#!/bin/bash
gmt begin kodiak1.21_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source kodiak1.21'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.805     0.550     0.200
     0.811     0.246     0.200
     0.639    -0.118     0.200
     0.716     0.337     0.200
     0.368     0.180     0.200
     0.477     0.224     0.200
     0.617     0.514     0.200
     0.740    -0.093     0.200
     0.716    -0.039     0.200
     0.683    -0.124     0.200
     0.743    -0.083     0.200
     0.767     0.252     0.200
     0.594     0.768     0.200
     0.818    -0.023     0.200
     0.466    -0.068     0.200
     0.633    -0.281     0.200
     0.088    -0.421     0.200
     0.173     0.411     0.200
     0.370     0.346     0.200
     0.539     0.647     0.200
     0.710    -0.295     0.200
     0.508     0.014     0.200
     0.603     1.127     0.200
     0.261     0.278     0.200
     0.279    -0.148     0.200
     0.597     1.002     0.200
     0.806    -0.667     0.200
     0.826    -0.993     0.200
     0.816     0.090     0.200
     0.832     0.011     0.200
     0.809     1.033     0.200
     0.809     0.380     0.200
     0.809     0.693     0.200
     0.709    -0.181     0.200
     0.268     0.266     0.200
     0.630     1.176     0.200
     0.782    -0.351     0.200
     0.872    -0.603     0.200
     0.538    -0.425     0.200
     0.515     1.273     0.200
     0.292    -0.450     0.200
     0.292     0.249     0.200
     0.386    -0.184     0.200
     0.922    -0.622     0.200
     0.922     0.303     0.200
     0.863     0.460     0.200
     0.840     0.181     0.200
     0.861    -0.774     0.200
     0.444     0.850     0.200
     0.973     0.256     0.200
     0.973    -1.037     0.200
     0.448    -0.707     0.200
     0.696     1.033     0.200
     0.760     0.218     0.200
     0.955    -0.754     0.200
     0.019    -0.331     0.200
     0.051    -0.533     0.200
     0.093    -0.828     0.200
     0.067    -0.129     0.200
     0.074     0.013     0.200
     0.092    -0.101     0.200
     0.167    -0.542     0.200
     0.150    -0.567     0.200
     0.163     0.134     0.200
     0.183     0.180     0.200
     0.266     0.503     0.200
     0.375    -0.941     0.200
     0.362    -0.137     0.200
     0.369     0.125     0.200
     0.433    -0.940     0.200
     0.787     0.616     0.200
     0.905    -1.111     0.200
     0.925    -0.162     0.200
     0.601    -0.593     0.200
     0.601    -0.432     0.200
     0.148    -0.432     0.200
     0.711    -0.719     0.200
     0.728    -0.827     0.200
     0.858     0.261     0.200
     0.909     0.247     0.200
     0.062    -0.294     0.200
     0.424    -0.071     0.200
     0.622    -0.638     0.200
     0.645    -0.394     0.200
     0.664    -0.626     0.200
     0.470    -0.301     0.200
     0.470    -0.153     0.200
     0.372     0.615     0.200
     0.783    -0.633     0.200
     0.783    -0.086     0.200
     0.891    -0.071     0.200
     0.057     0.274     0.200
     0.794     0.548     0.200
     0.431     0.047     0.200
     0.804    -0.465     0.200
     0.926     0.232     0.200
     0.546     0.460     0.200
     0.546     0.108     0.200
     0.191     0.014     0.200
     0.937    -0.104     0.200
     0.694    -0.018     0.200
     0.727     0.369     0.200
     0.470    -0.000     0.200
     0.501     0.302     0.200
     0.319    -0.367     0.200
     0.419     0.253     0.200
     0.668    -0.237     0.200
     0.999    -0.351     0.200
     0.857     0.557     0.200
     0.934     0.630     0.200
     0.518     0.280     0.200
     0.360    -0.109     0.200
     0.611    -0.067     0.200
     0.757    -0.344     0.200
     0.711     0.345     0.200
     0.770     0.143     0.200
     0.799     0.107     0.200
     0.673     0.417     0.200
     0.673     0.708     0.200
     0.842     0.429     0.200
     0.873     0.064     0.200
     0.831    -0.749     0.200
     0.831    -1.099     0.200
     0.910    -0.066     0.200
     0.715    -0.259     0.200
     0.436    -0.514     0.200
     0.501    -0.304     0.200
     0.613    -0.093     0.200
     0.453     0.918     0.200
     0.590    -0.113     0.200
     0.588     0.858     0.200
     0.825    -0.277     0.200
     0.563    -0.182     0.200
     0.563    -0.074     0.200
     0.822     0.718     0.200
     0.551    -0.337     0.200
     0.551    -0.474     0.200
     0.821     0.307     0.200
     0.606     0.051     0.200
     0.606     0.235     0.200
     0.961     0.009     0.200
     0.703     0.112     0.200
     0.996    -0.411     0.200
     0.996    -0.219     0.200
     0.346     0.048     0.200
     0.518     0.171     0.200
     0.535     0.485     0.200
     0.535     0.758     0.200
     0.916     0.055     0.200
     0.982    -0.588     0.200
     0.593     0.327     0.200
     0.895    -0.604     0.200
     0.499    -0.375     0.200
     0.877    -0.217     0.200
     0.877    -0.016     0.200
     0.475    -0.426     0.200
     0.475    -0.266     0.200
     0.804     0.573     0.200
     0.804     0.229     0.200
     0.439    -0.922     0.200
     0.439    -0.502     0.200
     0.439    -0.611     0.200
     0.772     0.161     0.200
     0.772     0.502     0.200
     0.591    -0.175     0.200
     0.843    -0.721     0.200
     0.247    -0.132     0.200
     0.166     0.480     0.200
     0.476     0.342     0.200
     0.633     0.533     0.200
     0.644    -0.209     0.200
     0.657     0.047     0.200
     0.675    -0.497     0.200
     0.687     0.175     0.200
     0.713    -0.146     0.200
     0.766    -0.317     0.200
     0.825    -1.359     0.200
     0.781    -0.004     0.200
     0.871    -0.412     0.200
     0.961    -0.701     0.200
     0.961    -0.420     0.200
     0.960    -0.690     0.200
     0.957    -0.593     0.200
     0.581     0.499     0.200
     0.674     0.404     0.200
     0.419    -0.569     0.200
     0.419    -0.373     0.200
     0.436    -0.212     0.200
     0.450     0.202     0.200
     0.462    -0.040     0.200
     0.512    -0.353     0.200
     0.498    -0.114     0.200
     0.509     0.085     0.200
     0.574     0.060     0.200
     0.619    -0.259     0.200
     0.583    -0.134     0.200
     0.720    -0.242     0.200
     0.720    -0.179     0.200
     0.791    -0.014     0.200
     0.792     0.105     0.200
     0.050    -1.577     0.200
     0.073    -0.747     0.200
     0.085     0.407     0.200
     0.104     0.350     0.200
     0.356    -0.619     0.200
     0.307     0.575     0.200
     0.340     0.238     0.200
     0.342     0.158     0.200
     0.423    -0.711     0.200
     0.388     0.252     0.200
     0.387     0.247     0.200
     0.566    -0.545     0.200
     0.809    -0.600     0.200
     0.872    -0.328     0.200
     0.888    -0.844     0.200
     0.888    -0.731     0.200
     0.842     0.012     0.200
     0.305     0.098     0.200
     0.305    -0.012     0.200
     0.305    -0.262     0.200
     0.386     0.109     0.200
     0.451     0.156     0.200
     0.338     0.401     0.200
     0.338     0.557     0.200
     0.679     0.712     0.200
     0.932     0.268     0.200
     0.932     0.113     0.200
     0.988    -0.350     0.200
     0.272    -0.118     0.200
     0.272     0.046     0.200
     0.364     0.371     0.200
     0.827    -1.176     0.200
     0.482     0.062     0.200
     0.497    -0.115     0.200
     0.514    -0.026     0.200
     0.557     0.046     0.200
     0.550     0.484     0.200
     0.612     0.025     0.200
     0.663    -0.072     0.200
     0.695     0.218     0.200
     0.734     0.115     0.200
     0.911    -1.080     0.200
     0.935    -1.262     0.200
     0.911     0.289     0.200
     0.965    -0.993     0.200
     0.648    -0.097     0.200
     0.649    -0.200     0.200
     0.903    -0.704     0.200
     0.518    -0.259     0.200
     0.518    -0.031     0.200
     0.897     0.006     0.200
     0.897     0.246     0.200
     0.526     0.038     0.200
     0.933    -0.236     0.200
     0.933    -0.537     0.200
     0.595     0.053     0.200
     0.595     0.213     0.200
     0.102    -0.774     0.200
     0.068    -1.526     0.200
     0.085     0.372     0.200
     0.097     0.967     0.200
     0.374     0.029     0.200
     0.817    -0.084     0.200
     0.828     0.183     0.200
     0.876     0.081     0.200
     0.409     0.511     0.200
     0.554    -0.099     0.200
     0.574    -0.400     0.200
     0.623    -0.097     0.200
     0.609     0.163     0.200
     0.746    -0.217     0.200
     0.805    -0.408     0.200
     0.812    -0.114     0.200
     0.414     0.222     0.200
     0.545    -0.075     0.200
     0.564    -0.379     0.200
     0.613    -0.064     0.200
     0.612     0.020     0.200
     0.736    -0.174     0.200
     0.797    -0.402     0.200
     0.813    -0.196     0.200
     0.393     0.505     0.200
     0.531    -0.192     0.200
     0.554    -0.471     0.200
     0.605    -0.237     0.200
     0.589     0.172     0.200
     0.725    -0.106     0.200
     0.689     0.124     0.200
     0.780    -0.371     0.200
     0.689     0.929     0.200
     0.972    -0.191     0.200
     0.972     0.063     0.200
     0.485     0.109     0.200
     0.865     0.004     0.200
     0.517     0.435     0.200
     0.719    -0.247     0.200
     0.221    -0.046     0.200
     0.940     0.041     0.200
     0.199     0.219     0.200
     0.199    -0.211     0.200
     0.463    -0.094     0.200
     0.651    -0.080     0.200
     0.206    -0.512     0.200
     0.643    -0.440     0.200
     0.631    -0.123     0.200
     0.632    -0.160     0.200
     0.885    -0.671     0.200
     0.630    -0.534     0.200
     0.860    -0.652     0.200
     0.476     0.310     0.200
     0.974    -0.414     0.200
     0.975    -0.293     0.200
     0.392    -0.217     0.200
     0.414    -0.248     0.200
     0.560    -0.292     0.200
     0.674    -0.018     0.200
     0.675     0.072     0.200
     0.696    -0.073     0.200
     0.733    -1.209     0.200
     0.785    -0.309     0.200
     0.879    -1.245     0.200
     0.991    -0.005     0.200
     0.570     0.774     0.200
     0.786    -0.567     0.200
     0.548    -0.221     0.200
     0.940    -0.868     0.200
     0.564     0.147     0.200
     0.997    -1.507     0.200
     0.556     0.312     0.200
     0.495     0.559     0.200
     0.495    -0.451     0.200
     0.495    -0.223     0.200
     0.952     0.453     0.200
     0.952    -0.297     0.200
     0.625     0.380     0.200
     0.562     0.226     0.200
     0.651     0.561     0.200
     0.670     0.087     0.200
     0.670    -0.034     0.200
     0.596    -0.828     0.200
     0.597     0.655     0.200
     0.325    -0.082     0.200
     0.325     0.166     0.200
     0.380    -0.126     0.200
     0.380     0.026     0.200
     0.437     0.209     0.200
     0.402    -0.104     0.200
     0.402     0.466     0.200
     0.970    -0.291     0.200
     0.970    -0.151     0.200
     0.970     0.017     0.200
     0.700     0.081     0.200
     0.754    -0.234     0.200
     0.655     0.371     0.200
     0.707     0.094     0.200
     0.727     0.336     0.200
     0.807    -0.437     0.200
     0.831    -0.200     0.200
     0.858    -0.661     0.200
     0.856    -0.324     0.200
     0.857    -0.056     0.200
     0.932    -0.781     0.200
     0.375    -0.435     0.200
     0.375     0.326     0.200
     0.722    -2.054     0.200
     0.722    -1.081     0.200
     0.708     0.446     0.200
     0.807     0.108     0.200
     0.831     0.155     0.200
     0.865    -0.480     0.200
     0.857    -0.006     0.200
     0.857     0.368     0.200
     0.847     0.214     0.200
     0.935    -0.533     0.200
     0.960     0.120     0.200
     0.993     0.068     0.200
     0.488    -0.344     0.200
     0.500    -0.226     0.200
     0.495     0.063     0.200
     0.541    -0.118     0.200
     0.581    -0.373     0.200
     0.597    -0.144     0.200
     0.684     0.049     0.200
     0.760    -0.180     0.200
     0.835    -1.331     0.200
     0.869    -1.589     0.200
     0.957    -0.976     0.200
     0.620    -0.291     0.200
     0.788    -0.140     0.200
     0.852    -0.017     0.200
     0.896    -0.043     0.200
     0.765    -0.109     0.200
     0.861    -0.158     0.200
     0.981    -0.327     0.200
     0.984    -0.350     0.200
     0.686    -0.330     0.200
     0.686    -0.549     0.200
     0.111    -0.245     0.200
     0.111    -0.095     0.200
     0.936    -0.487     0.200
     0.475     0.417     0.200
     0.299    -0.220     0.200
     0.340    -0.156     0.200
     0.396    -0.215     0.200
     0.402    -0.322     0.200
     0.419    -0.227     0.200
     0.444    -0.087     0.200
     0.457    -0.256     0.200
     0.469     0.039     0.200
     0.494    -0.099     0.200
     0.519    -0.121     0.200
     0.516    -0.507     0.200
     0.581    -0.254     0.200
     0.613     0.009     0.200
     0.648    -0.168     0.200
     0.798     0.050     0.200
     0.943    -0.994     0.200
     0.301    -0.261     0.200
     0.341    -0.226     0.200
     0.361    -0.299     0.200
     0.402    -0.351     0.200
     0.398    -0.268     0.200
     0.416    -0.145     0.200
     0.441    -0.036     0.200
     0.457    -0.074     0.200
     0.471    -0.030     0.200
     0.495     0.020     0.200
     0.521    -0.160     0.200
     0.583    -0.270     0.200
     0.645    -0.050     0.200
     0.799     0.123     0.200
     0.938    -0.830     0.200
     0.026    -0.314     0.200
     0.098    -0.780     0.200
     0.100    -0.417     0.200
     0.234    -0.306     0.200
     0.226     0.538     0.200
     0.251    -0.210     0.200
     0.320    -0.255     0.200
     0.321     0.004     0.200
     0.370    -0.524     0.200
     0.357     0.097     0.200
     0.412    -0.122     0.200
     0.522     0.051     0.200
     0.615     0.208     0.200
     0.646     0.112     0.200
     0.726    -1.157     0.200
     0.924    -1.329     0.200
     0.955    -0.526     0.200
     0.321     0.456     0.200
     0.365    -0.104     0.200
     0.490    -1.221     0.200
     0.391    -0.156     0.200
     0.444    -0.202     0.200
     0.538     0.521     0.200
     0.496    -0.151     0.200
     0.502    -0.141     0.200
     0.561     0.425     0.200
     0.535    -0.397     0.200
     0.661    -0.836     0.200
     0.713     0.193     0.200
     0.786    -0.746     0.200
     0.818    -0.708     0.200
     0.887    -0.260     0.200
     0.960    -0.500     0.200
     0.156    -1.560     0.200
     0.369     0.097     0.200
     0.513    -0.048     0.200
     0.576    -0.870     0.200
     0.596    -0.927     0.200
     0.597    -0.672     0.200
     0.581     0.109     0.200
     0.685    -0.405     0.200
     0.678    -0.173     0.200
     0.848    -0.629     0.200
     0.912    -1.237     0.200
     0.986    -1.050     0.200
     0.854    -0.960     0.200
     0.854    -0.829     0.200
     0.863    -0.988     0.200
     0.863    -0.828     0.200
     0.868    -0.906     0.200
     0.885    -0.655     0.200
     0.917    -1.007     0.200
     0.917    -0.796     0.200
     0.829     0.880     0.200
     0.829     0.495     0.200
     0.829     0.124     0.200
     0.625     0.170     0.200
     0.596    -0.563     0.200
     0.922    -0.327     0.200
     0.981    -0.368     0.200
     0.981    -0.358     0.200
     0.990    -0.385     0.200
     0.986    -0.004     0.200
     0.988    -0.394     0.200
     0.766    -0.049     0.200
     0.378    -0.255     0.200
     0.034     0.226     0.200
     0.053     0.281     0.200
     0.092    -0.221     0.200
     0.092    -0.042     0.200
     0.103    -0.308     0.200
     0.109    -0.155     0.200
     0.162    -0.195     0.200
     0.162     0.237     0.200
     0.197    -0.403     0.200
     0.197     0.155     0.200
     0.255    -0.539     0.200
     0.255    -0.390     0.200
     0.273    -0.394     0.200
     0.273     0.313     0.200
     0.367    -0.447     0.200
     0.367    -0.244     0.200
     0.427    -0.399     0.200
     0.427    -0.228     0.200
     0.573    -0.286     0.200
     0.573    -0.138     0.200
     0.767     0.110     0.200
     0.767     0.528     0.200
     0.795     0.513     0.200
     0.869     0.147     0.200
     0.869     0.315     0.200
     0.871     0.981     0.200
     0.924    -0.003     0.200
     0.924     0.196     0.200
     0.037    -0.075     0.200
     0.101    -0.520     0.200
     0.110    -0.495     0.200
     0.109    -0.609     0.200
     0.167    -0.641     0.200
     0.152     0.027     0.200
     0.264    -0.462     0.200
     0.375    -0.339     0.200
     0.436    -0.281     0.200
     0.758     0.572     0.200
     0.786    -0.002     0.200
     0.860     0.078     0.200
     0.914    -0.092     0.200
     0.994     0.020     0.200
     0.033    -0.212     0.200
     0.061    -0.556     0.200
     0.072    -0.055     0.200
     0.124    -0.322     0.200
     0.156    -0.482     0.200
     0.192     0.007     0.200
     0.224    -0.604     0.200
     0.336    -0.444     0.200
     0.396    -0.381     0.200
     0.399    -0.001     0.200
     0.798     0.529     0.200
     0.825     0.313     0.200
     0.901    -0.095     0.200
     0.901     0.193     0.200
     0.666    -1.472     0.200
     0.649     0.577     0.200
     0.655     0.605     0.200
     0.733     0.904     0.200
     0.863     0.395     0.200
     0.886     0.013     0.200
     0.956    -0.232     0.200
     0.975    -0.227     0.200
     0.039    -0.057     0.200
     0.042     0.079     0.200
     0.106    -0.259     0.200
     0.112    -0.669     0.200
     0.145    -0.443     0.200
     0.145    -0.103     0.200
     0.173    -0.666     0.200
     0.270    -0.446     0.200
     0.380    -0.548     0.200
     0.427     0.212     0.200
     0.442    -0.091     0.200
     0.854     0.037     0.200
     0.857     0.260     0.200
     0.907     0.100     0.200
     0.907    -0.001     0.200
     0.047    -0.561     0.200
     0.047    -0.350     0.200
     0.047    -0.524     0.200
     0.047    -0.153     0.200
     0.080    -0.542     0.200
     0.080    -0.343     0.200
     0.088    -0.171     0.200
     0.129    -0.211     0.200
     0.150    -0.180     0.200
     0.208    -0.143     0.200
     0.209    -0.041     0.200
     0.231     0.139     0.200
     0.323    -0.322     0.200
     0.318     0.238     0.200
     0.381     0.060     0.200
     0.393     0.008     0.200
     0.813     0.348     0.200
     0.915    -0.046     0.200
     0.915     0.228     0.200
     0.916    -0.024     0.200
     0.916     0.136     0.200
     0.970    -0.049     0.200
     0.028    -0.179     0.200
     0.096    -0.418     0.200
     0.075    -0.314     0.200
     0.061     0.010     0.200
     0.117    -0.298     0.200
     0.159    -0.346     0.200
     0.178     0.239     0.200
     0.210     0.035     0.200
     0.238    -0.332     0.200
     0.290     0.215     0.200
     0.350    -0.622     0.200
     0.411    -0.186     0.200
     0.408     0.127     0.200
     0.783     0.464     0.200
     0.887     0.231     0.200
     0.886    -0.154     0.200
     0.066    -0.186     0.200
     0.030    -0.287     0.200
     0.030    -0.166     0.200
     0.092    -0.267     0.200
     0.067    -0.037     0.200
     0.122    -0.206     0.200
     0.158    -0.197     0.200
     0.229    -0.167     0.200
     0.187     0.093     0.200
     0.217     0.063     0.200
     0.299     0.354     0.200
     0.341    -0.301     0.200
     0.401     0.051     0.200
     0.402     0.255     0.200
     0.793     0.634     0.200
     0.896     0.488     0.200
     0.895     0.226     0.200
     0.948    -0.439     0.200
     0.056    -0.310     0.200
     0.028     0.068     0.200
     0.070    -0.624     0.200
     0.096    -0.383     0.200
     0.133    -0.383     0.200
     0.164    -0.643     0.200
     0.219    -0.372     0.200
     0.331    -0.485     0.200
     0.392    -0.232     0.200
     0.390     0.188     0.200
     0.803    -1.455     0.200
     0.904     0.278     0.200
     0.907     0.146     0.200
     0.955    -0.056     0.200
     0.044    -0.134     0.200
     0.103    -0.628     0.200
     0.034     0.022     0.200
     0.077     0.109     0.200
     0.172    -0.681     0.200
     0.147    -0.641     0.200
     0.207    -0.190     0.200
     0.317    -0.302     0.200
     0.379     0.041     0.200
     0.376     0.429     0.200
     0.816     0.596     0.200
     0.921     0.320     0.200
     0.917     0.047     0.200
     0.965    -0.175     0.200
     0.038    -0.320     0.200
     0.052    -0.494     0.200
     0.052    -0.338     0.200
     0.078    -0.203     0.200
     0.087    -0.426     0.200
     0.156    -0.255     0.200
     0.215    -0.307     0.200
     0.200    -0.047     0.200
     0.228     0.059     0.200
     0.328    -0.023     0.200
     0.312     0.169     0.200
     0.388    -0.048     0.200
     0.393     0.337     0.200
     0.534     0.182     0.200
     0.806     0.345     0.200
     0.834     0.410     0.200
     0.909    -0.046     0.200
     0.909     0.163     0.200
     0.962    -0.205     0.200
     0.939     0.097     0.200
     0.985     0.277     0.200
     0.350    -0.168     0.200
     0.462     0.082     0.200
     0.746    -0.155     0.200
     0.991    -0.501     0.200
     0.233    -0.446     0.200
     0.107    -0.529     0.200
     0.158    -0.871     0.200
     0.133     0.638     0.200
     0.223    -1.015     0.200
     0.216    -0.476     0.200
     0.339    -0.281     0.200
     0.395    -0.079     0.200
     0.423    -0.377     0.200
     0.425     0.448     0.200
     0.481    -0.503     0.200
     0.552     0.091     0.200
     0.615    -0.009     0.200
     0.691     0.540     0.200
     0.831    -0.877     0.200
     0.458    -0.215     0.200
     0.525    -0.050     0.200
     0.825     0.104     0.200
     0.924    -0.394     0.200
     0.924    -0.629     0.200
     0.400     0.104     0.200
     0.711     0.061     0.200
     0.960    -0.069     0.200
     0.960    -0.338     0.200
     0.399     0.101     0.200
     0.707     0.408     0.200
     0.961    -0.098     0.200
     0.129     0.114     0.200
     0.129     0.215     0.200
     0.476     0.256     0.200
     0.454     0.463     0.200
     0.426     0.334     0.200
     0.339    -0.112     0.200
     0.545    -0.028     0.200
     0.486     0.256     0.200
     0.034    -0.116     0.200
     0.034    -0.273     0.200
     0.848    -0.312     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.877    -0.610     0.200
     0.598    -0.186     0.200
     0.575    -0.256     0.200
     0.722    -0.395     0.200
     0.784     0.367     0.200
     0.824     0.279     0.200
     0.605     0.423     0.200
     0.747    -0.481     0.200
     0.935     1.054     0.200
     0.966     0.915     0.200
     0.748    -0.161     0.200
     0.095    -0.220     0.200
     0.773     0.099     0.200
     0.786     0.533     0.200
     0.849     0.258     0.200
     0.596    -0.322     0.200
     0.646    -0.473     0.200
     0.789    -0.049     0.200
     0.252     0.175     0.200
     0.641     0.105     0.200
     0.632     0.287     0.200
     0.664     0.459     0.200
     0.689     0.628     0.200
     0.692     0.521     0.200
     0.692     0.823     0.200
     0.692     0.265     0.200
     0.696     0.646     0.200
     0.710     0.572     0.200
     0.996     0.713     0.200
     0.708     0.327     0.200
     0.708    -1.065     0.200
     0.830    -0.082     0.200
     0.828     0.324     0.200
     0.539    -1.136     0.200
     0.457     0.133     0.200
     0.794     0.365     0.200
     0.553     0.016     0.200
     0.613     0.124     0.200
     0.617     0.145     0.200
     0.637     0.385     0.200
     0.734     0.252     0.200
     0.824     0.120     0.200
     0.243     0.111     0.200
     0.602     0.500     0.200
     0.646     0.094     0.200
     0.670     0.525     0.200
     0.672     0.755     0.200
     0.672     0.336     0.200
     0.673     0.536     0.200
     0.678     0.667     0.200
     0.692     0.512     0.200
     0.974     0.696     0.200
     0.434     0.316     0.200
     0.743     0.750     0.200
     0.752     0.599     0.200
     0.753     0.095     0.200
     0.757     0.475     0.200
     0.768     0.529     0.200
     0.774     0.540     0.200
     0.939    -0.148     0.200
     0.587    -0.817     0.200
     0.644    -0.915     0.200
     0.892    -0.348     0.200
     0.935    -0.220     0.200
     0.939    -0.069     0.200
     0.989    -0.074     0.200
     0.168    -0.237     0.200
     0.219    -0.667     0.200
     0.875     0.160     0.200
     0.365    -0.360     0.200
     0.425    -0.327     0.200
     0.403     0.041     0.200
     0.875     0.466     0.200
     0.430    -0.495     0.200
     0.438    -0.179     0.200
     0.572    -0.126     0.200
     0.738    -0.159     0.200
     0.912     0.055     0.200
     0.521     0.211     0.200
     0.732     0.278     0.200
     0.906     0.070     0.200
     0.884     0.113     0.200
     0.938     0.480     0.200
     0.960     0.595     0.200
     0.962     0.427     0.200
     0.962     0.702     0.200
     0.964     0.577     0.200
     0.971     0.623     0.200
     0.980     0.584     0.200
     0.964     0.068     0.200
     0.763     0.315     0.200
     0.782    -0.426     0.200
     0.098     0.231     0.200
     0.095     0.113     0.200
     0.344    -0.335     0.200
     0.548    -0.257     0.200
     0.567    -0.145     0.200
     0.798     0.201     0.200
     0.906    -0.139     0.200
     0.927    -0.080     0.200
     0.982     0.472     0.200
     0.882    -0.346     0.200
     0.995     0.503     0.200
     0.852     0.003     0.200
     0.893     0.221     0.200
     0.910     0.149     0.200
     0.997     0.360     0.200
     0.951     0.667     0.200
     0.983     0.117     0.200
     0.820    -0.466     0.200
     0.857    -0.282     0.200
     0.876    -0.255     0.200
     0.960    -0.012     0.200
     0.989     0.027     0.200
     0.973    -0.158     0.200
     0.348     0.152     0.200
     0.407    -0.016     0.200
     0.520    -0.006     0.200
     0.618     0.071     0.200
     0.601     0.099     0.200
     0.676    -0.214     0.200
     0.722     0.261     0.200
     0.756     0.434     0.200
     0.781     0.549     0.200
     0.784     0.582     0.200
     0.754    -0.112     0.200
     0.803     0.448     0.200
     0.867    -0.385     0.200
     0.959    -0.497     0.200
     0.952    -0.080     0.200
     0.717    -0.634     0.200
     0.631     0.098     0.200
     0.795    -0.031     0.200
     0.683     0.077     0.200
     0.791    -0.384     0.200
     0.811    -0.300     0.200
     0.840    -0.109     0.200
     0.845     0.203     0.200
     0.855    -0.291     0.200
     0.922    -0.005     0.200
     0.955    -0.196     0.200
     0.999     0.063     0.200
     0.996     0.006     0.200
     0.263    -0.742     0.200
     0.614     0.137     0.200
     0.637    -0.008     0.200
     0.756    -0.126     0.200
     0.814    -0.195     0.200
     0.842    -0.172     0.200
     0.942    -0.069     0.200
     0.954     0.159     0.200
     0.291     0.106     0.200
     0.499    -0.096     0.200
     0.691    -0.849     0.200
     0.592     0.367     0.200
     0.624     0.711     0.200
     0.747    -1.048     0.200
     0.700     0.114     0.200
     0.782     0.205     0.200
     0.825     0.038     0.200
     0.951    -0.199     0.200
     0.959    -0.016     0.200
     0.963     0.400     0.200
     0.969    -0.205     0.200
     0.985     0.827     0.200
     0.988     0.824     0.200
     0.990     0.517     0.200
     0.993     0.499     0.200
     0.991     0.228     0.200
     0.060    -0.018     0.200
     0.271     0.159     0.200
     0.328     0.110     0.200
     0.351     0.067     0.200
     0.434    -0.125     0.200
     0.459    -0.166     0.200
     0.515     0.227     0.200
     0.555    -0.126     0.200
     0.609     0.070     0.200
     0.619    -0.108     0.200
     0.690     0.288     0.200
     0.769     0.392     0.200
     0.898     0.307     0.200
     0.561    -1.501     0.200
     0.782     0.016     0.200
     0.778     0.057     0.200
     0.822    -0.877     0.200
     0.823    -0.372     0.200
     0.844     0.153     0.200
     0.923    -0.608     0.200
     0.988    -0.603     0.200
     0.986    -0.146     0.200
     0.203     0.126     0.200
     0.266     0.118     0.200
     0.384    -0.128     0.200
     0.376    -0.264     0.200
     0.440     0.340     0.200
     0.433    -0.001     0.200
     0.550     0.376     0.200
     0.626    -0.372     0.200
     0.688    -0.061     0.200
     0.700    -0.062     0.200
     0.826     0.686     0.200
     0.779     0.119     0.200
     0.846     0.709     0.200
     0.850     0.762     0.200
     0.861     0.924     0.200
     0.864     0.720     0.200
     0.799    -0.022     0.200
     0.902     0.182     0.200
     0.926    -0.009     0.200
     0.438    -0.261     0.200
     0.499    -0.329     0.200
     0.503    -0.221     0.200
     0.502    -0.151     0.200
     0.594     0.025     0.200
     0.611     0.008     0.200
     0.763    -0.326     0.200
     0.770    -0.061     0.200
     0.852     0.112     0.200
     0.885     0.067     0.200
     0.903     0.284     0.200
     0.090     0.008     0.200
     0.215     0.138     0.200
     0.307     0.195     0.200
     0.361    -0.177     0.200
     0.376     0.196     0.200
     0.434     0.193     0.200
     0.490    -0.071     0.200
     0.524     0.186     0.200
     0.558    -0.040     0.200
     0.570    -0.319     0.200
     0.573     0.099     0.200
     0.645    -0.084     0.200
     0.653     0.501     0.200
     0.675     0.172     0.200
     0.705     0.121     0.200
     0.824     0.255     0.200
     0.795    -0.255     0.200
     0.830    -0.515     0.200
     0.858     0.035     0.200
     0.852    -0.355     0.200
     0.949    -0.181     0.200
     0.970    -0.131     0.200
     0.270    -0.024     0.200
     0.472     0.251     0.200
     0.448     0.295     0.200
     0.499     0.029     0.200
     0.367    -0.040     0.200
     0.392    -0.135     0.200
     0.483    -0.028     0.200
     0.529    -0.059     0.200
     0.549     0.043     0.200
     0.706     0.078     0.200
     0.771    -0.342     0.200
     0.761    -0.330     0.200
     0.793    -0.159     0.200
     0.810     0.138     0.200
     0.810    -0.122     0.200
     0.528     0.044     0.200
     0.522    -0.129     0.200
     0.578    -0.106     0.200
     0.759    -0.224     0.200
     0.894     0.234     0.200
     0.642    -0.134     0.200
     0.682    -0.561     0.200
     0.726     0.090     0.200
     0.733    -0.343     0.200
     0.764    -0.095     0.200
     0.779     0.100     0.200
     0.780    -0.193     0.200
     0.833    -0.204     0.200
     0.897    -0.195     0.200
     0.968     0.464     0.200
     0.976    -0.006     0.200
     0.072    -0.463     0.200
     0.169    -0.245     0.200
     0.244    -0.367     0.200
     0.289    -0.324     0.200
     0.277    -0.213     0.200
     0.357    -0.048     0.200
     0.387    -0.229     0.200
     0.410     0.112     0.200
     0.429     0.204     0.200
     0.403     0.627     0.200
     0.632    -0.054     0.200
     0.671     0.362     0.200
     0.689     0.712     0.200
     0.696     0.520     0.200
     0.710     0.543     0.200
     0.797     0.036     0.200
     0.835     0.274     0.200
     0.916    -0.169     0.200
     0.971    -0.238     0.200
     0.975     0.479     0.200
     0.950     0.292     0.200
     0.446    -0.457     0.200
     0.527    -0.323     0.200
     0.899     0.306     0.200
     0.846    -0.230     0.200
     0.864    -0.136     0.200
     0.929    -0.210     0.200
     0.938    -0.289     0.200
     0.708     0.319     0.200
     0.708    -0.606     0.200
     0.824     0.395     0.200
     0.760    -0.585     0.200
     0.904    -0.107     0.200
     0.934    -0.486     0.200
     0.950    -0.164     0.200
     0.298    -0.725     0.200
     0.298    -0.026     0.200
     0.513    -0.610     0.200
     0.074    -0.078     0.200
     0.315    -0.194     0.200
     0.346     0.032     0.200
     0.377     0.132     0.200
     0.670     0.269     0.200
     0.690     0.264     0.200
     0.774     0.095     0.200
     0.523    -0.034     0.200
     0.713     0.428     0.200
     0.761     0.552     0.200
     0.760     0.210     0.200
     0.937     0.109     0.200
     0.958    -0.171     0.200
     0.987    -0.236     0.200
     0.287    -0.030     0.200
     0.686    -1.106     0.200
     0.406    -0.190     0.200
     0.626     0.600     0.200
     0.649     0.742     0.200
     0.677     0.886     0.200
     0.677     0.886     0.200
     0.696     1.009     0.200
     0.740    -0.048     0.200
     0.868    -0.148     0.200
     0.918    -0.567     0.200
     0.946     0.081     0.200
     0.950     0.008     0.200
     0.984     0.345     0.200
     0.980     0.986     0.200
     0.556    -0.515     0.200
     0.661     0.354     0.200
     0.688     0.514     0.200
     0.691     0.521     0.200
     0.709     1.058     0.200
     0.741     0.421     0.200
     0.894    -0.497     0.200
     0.977     0.511     0.200
     0.975     0.107     0.200
     0.971    -0.444     0.200
     0.486    -0.399     0.200
     0.623     0.583     0.200
     0.658    -0.280     0.200
     0.667     0.037     0.200
     0.773    -0.102     0.200
     0.781     0.095     0.200
     0.829     0.001     0.200
     0.933    -0.803     0.200
     0.905    -0.170     0.200
     0.929    -0.230     0.200
     0.972     0.055     0.200
     0.310    -0.200     0.200
     0.364    -0.091     0.200
     0.518    -0.317     0.200
     0.600    -0.259     0.200
     0.634     0.077     0.200
     0.661    -0.287     0.200
     0.654    -0.418     0.200
     0.698     0.193     0.200
     0.769    -0.122     0.200
     0.830    -0.318     0.200
     0.360    -0.134     0.200
     0.390    -0.080     0.200
     0.447    -0.081     0.200
     0.472    -0.184     0.200
     0.518     0.204     0.200
     0.521    -0.076     0.200
     0.578     0.292     0.200
     0.574    -0.044     0.200
     0.618    -0.011     0.200
     0.652    -0.189     0.200
     0.660    -0.458     0.200
     0.711    -0.250     0.200
     0.785    -0.315     0.200
     0.896     0.239     0.200
     0.970    -0.117     0.200
     0.658    -0.301     0.200
     0.757     0.055     0.200
     0.843     0.010     0.200
     0.973    -0.001     0.200
     0.062     0.095     0.200
     0.209    -0.238     0.200
     0.246    -0.086     0.200
     0.365    -0.103     0.200
     0.377    -0.052     0.200
     0.442     0.447     0.200
     0.418    -0.064     0.200
     0.474    -0.371     0.200
     0.520    -0.048     0.200
     0.470    -0.018     0.200
     0.526     0.085     0.200
     0.609     0.181     0.200
     0.614     0.151     0.200
     0.624    -0.191     0.200
     0.983     0.416     0.200
     0.997     0.716     0.200
     0.412    -0.514     0.200
     0.540    -0.063     0.200
     0.540    -0.313     0.200
     0.927    -0.750     0.200
     0.552    -0.459     0.200
     0.674    -0.299     0.200
     0.715    -0.063     0.200
     0.741    -0.409     0.200
     0.741    -0.534     0.200
     0.942     0.312     0.200
     0.949     0.655     0.200
     0.984     0.513     0.200
     0.985     0.484     0.200
     0.206     0.207     0.200
     0.297    -0.382     0.200
     0.441    -0.091     0.200
     0.455    -0.436     0.200
     0.492     0.057     0.200
     0.558     0.191     0.200
     0.561     0.265     0.200
     0.517    -0.137     0.200
     0.559    -0.304     0.200
     0.643     0.198     0.200
     0.795     0.182     0.200
     0.821     0.486     0.200
     0.757    -0.871     0.200
     0.863    -0.727     0.200
     0.948    -0.326     0.200
     0.323    -0.235     0.200
     0.358    -0.252     0.200
     0.411     0.100     0.200
     0.487     0.050     0.200
     0.624    -0.200     0.200
     0.756    -0.422     0.200
     0.774    -0.388     0.200
     0.779    -0.518     0.200
     0.832     0.152     0.200
     0.862    -0.316     0.200
     0.899     0.330     0.200
     0.907     0.397     0.200
     0.885    -0.021     0.200
     0.926     0.641     0.200
     0.945     0.424     0.200
     0.749    -0.021     0.200
     0.347    -0.464     0.200
     0.541    -0.182     0.200
     0.628    -0.208     0.200
     0.738    -0.394     0.200
     0.852    -0.139     0.200
     0.900     0.423     0.200
     0.920     0.687     0.200
     0.976    -0.272     0.200
     0.994    -0.453     0.200
     0.463     0.225     0.200
     0.463    -0.994     0.200
     0.686    -0.387     0.200
     0.755    -0.335     0.200
     0.778    -0.017     0.200
     0.873     0.373     0.200
     0.878     0.059     0.200
     0.866     0.258     0.200
     0.920     0.002     0.200
     0.988     0.044     0.200
     0.721    -0.883     0.200
     0.582    -0.184     0.200
     0.697     0.088     0.200
     0.697    -0.677     0.200
     0.836    -0.472     0.200
     0.891    -0.439     0.200
     0.937    -0.025     0.200
     0.925    -0.145     0.200
     0.402     0.114     0.200
     0.529    -0.406     0.200
     0.531    -0.137     0.200
     0.910    -0.538     0.200
     0.994    -0.015     0.200
     0.994    -0.460     0.200
     0.994     0.118     0.200
     0.316     0.180     0.200
     0.335     0.208     0.200
     0.477     0.015     0.200
     0.561    -0.073     0.200
     0.796     0.356     0.200
     0.843     0.039     0.200
     0.959     0.416     0.200
     0.615    -0.511     0.200
     0.669    -0.666     0.200
     0.717    -0.326     0.200
     0.758    -0.313     0.200
     0.768    -0.297     0.200
     0.821     0.333     0.200
     0.832     0.059     0.200
     0.887     0.035     0.200
     0.338    -0.089     0.200
     0.423     0.083     0.200
     0.686    -0.209     0.200
     0.736    -0.395     0.200
     0.856     0.216     0.200
     0.858     0.557     0.200
     0.871     0.864     0.200
     0.897    -0.043     0.200
     0.947    -0.341     0.200
     0.947    -0.510     0.200
     0.426    -0.536     0.200
     0.542    -0.712     0.200
     0.650     0.485     0.200
     0.714    -0.028     0.200
     0.754    -0.329     0.200
     0.748     0.459     0.200
     0.821    -0.256     0.200
     0.856    -0.123     0.200
     0.933    -0.181     0.200
     0.931     0.122     0.200
     0.438     0.052     0.200
     0.730     0.420     0.200
     0.749     0.734     0.200
     0.722     0.016     0.200
     0.768     0.547     0.200
     0.777     0.808     0.200
     0.802     0.071     0.200
     0.897     0.078     0.200
     0.877    -0.252     0.200
     0.058     0.541     0.200
     0.308    -0.383     0.200
     0.353     0.191     0.200
     0.546     0.266     0.200
     0.586     0.442     0.200
     0.718     0.300     0.200
     0.723    -0.210     0.200
     0.933     1.133     0.200
     0.948     1.145     0.200
     0.953     1.061     0.200
     0.346     0.107     0.200
     0.365     0.246     0.200
     0.453     0.211     0.200
     0.457     0.194     0.200
     0.544     0.149     0.200
     0.571    -0.034     0.200
     0.676    -0.017     0.200
     0.701     0.258     0.200
     0.695     0.100     0.200
     0.750     0.461     0.200
     0.792     0.574     0.200
     0.792     0.611     0.200
     0.925    -0.770     0.200
     0.560    -0.273     0.200
     0.738     0.058     0.200
     0.900     0.172     0.200
     0.926    -0.157     0.200
     0.945     0.246     0.200
     0.479    -0.058     0.200
     0.610    -0.118     0.200
     0.679     0.556     0.200
     0.686     0.104     0.200
     0.775    -0.305     0.200
     0.812    -0.331     0.200
     0.527    -0.467     0.200
     0.553    -0.331     0.200
     0.539    -0.665     0.200
     0.323    -0.002     0.200
     0.405     0.009     0.200
     0.599    -0.315     0.200
     0.628    -0.189     0.200
     0.813    -0.146     0.200
     0.852     0.172     0.200
     0.972    -0.252     0.200
     0.965     0.461     0.200
     0.970     0.464     0.200
     0.972     0.438     0.200
     0.942     0.148     0.200
     0.989     0.500     0.200
     0.989     0.446     0.200
     0.473     0.061     0.200
     0.553     0.132     0.200
     0.700    -0.105     0.200
     0.756     0.232     0.200
     0.760     0.255     0.200
     0.767     0.326     0.200
     0.781     0.295     0.200
     0.815    -0.212     0.200
     0.913     0.039     0.200
     0.459    -0.108     0.200
     0.721    -0.767     0.200
     0.899    -0.423     0.200
     0.999    -0.270     0.200
     0.202     0.170     0.200
     0.090     0.124     0.200
     0.262     0.190     0.200
     0.305     0.004     0.200
     0.320     0.154     0.200
     0.346    -0.161     0.200
     0.424    -0.053     0.200
     0.439     0.078     0.200
     0.932     0.224     0.200
     0.960     0.002     0.200
     0.494     0.396     0.200
     0.536    -0.102     0.200
     0.638    -0.245     0.200
     0.748    -0.040     0.200
     0.798    -0.367     0.200
     0.818    -0.454     0.200
     0.889    -0.113     0.200
     0.916    -0.084     0.200
     0.934    -0.269     0.200
     0.340    -0.330     0.200
     0.461     0.007     0.200
     0.504    -0.008     0.200
     0.514    -0.007     0.200
     0.552    -0.240     0.200
     0.678     0.254     0.200
     0.791     0.172     0.200
     0.811     0.246     0.200
     0.824     0.004     0.200
     0.959     0.125     0.200
     0.173     0.108     0.200
     0.219     0.051     0.200
     0.283     0.159     0.200
     0.302     0.123     0.200
     0.340    -0.046     0.200
     0.356     0.164     0.200
     0.440     0.457     0.200
     0.499     0.142     0.200
     0.542     0.448     0.200
     0.933     0.165     0.200
     0.983     0.005     0.200
     0.992     0.156     0.200
     0.362     0.149     0.200
     0.502     0.294     0.200
     0.673     0.072     0.200
     0.637     0.548     0.200
     0.642     0.727     0.200
     0.643     0.427     0.200
     0.645     0.599     0.200
     0.682     0.025     0.200
     0.659     0.453     0.200
     0.836    -0.150     0.200
     0.904     0.170     0.200
     0.949     0.576     0.200
     0.145     0.133     0.200
     0.206     0.127     0.200
     0.357    -0.165     0.200
     0.517    -0.310     0.200
     0.563    -0.323     0.200
     0.642    -0.057     0.200
     0.635     0.216     0.200
     0.750    -0.124     0.200
     0.766     0.189     0.200
     0.836     0.129     0.200
     0.870     0.187     0.200
     0.946     0.559     0.200
     0.951     0.535     0.200
     0.968     0.646     0.200
     0.967     0.533     0.200
     0.972     0.552     0.200
     0.634     0.010     0.200
     0.663    -1.021     0.200
     0.088    -0.207     0.200
     0.274     0.041     0.200
     0.329    -0.331     0.200
     0.363    -0.056     0.200
     0.374     0.071     0.200
     0.435    -0.123     0.200
     0.480     0.082     0.200
     0.600     0.147     0.200
     0.631     0.159     0.200
     0.997    -0.824     0.200
     0.026    -0.235     0.200
     0.184    -0.150     0.200
     0.134     0.304     0.200
     0.152    -0.063     0.200
     0.164    -0.195     0.200
     0.170    -0.200     0.200
     0.191    -0.129     0.200
     0.263     0.259     0.200
     0.315     0.109     0.200
     0.280     0.196     0.200
     0.424     0.434     0.200
     0.486     0.060     0.200
     0.503     0.125     0.200
     0.569     0.452     0.200
     0.815     0.111     0.200
     0.921     0.090     0.200
     0.135    -0.031     0.200
     0.461    -0.143     0.200
     0.615    -0.249     0.200
     0.630    -0.034     0.200
     0.726     0.189     0.200
     0.783     0.602     0.200
     0.784     0.571     0.200
     0.788     0.610     0.200
     0.873     0.031     0.200
     0.859     0.164     0.200
     0.802     0.604     0.200
     0.811     0.622     0.200
     0.979     0.177     0.200
     0.187     0.072     0.200
     0.166    -0.168     0.200
     0.299     0.102     0.200
     0.393     0.139     0.200
     0.468    -0.263     0.200
     0.977     0.232     0.200
     0.888    -0.927     0.200
     0.473    -0.466     0.200
     0.850    -0.402     0.200
     0.996    -0.557     0.200
     0.641    -0.259     0.200
     0.647    -0.696     0.200
     0.753    -0.460     0.200
     0.785    -0.994     0.200
     0.785    -0.392     0.200
     0.806     0.261     0.200
     0.823    -0.061     0.200
     0.846    -0.085     0.200
     0.886    -0.128     0.200
     0.640    -0.104     0.200
     0.655     0.654     0.200
     0.685    -0.237     0.200
     0.803    -0.218     0.200
     0.820     0.349     0.200
     0.838     0.180     0.200
     0.854    -0.196     0.200
     0.936    -0.049     0.200
     0.998    -0.220     0.200
     0.151    -0.422     0.200
     0.342     0.099     0.200
     0.293    -0.102     0.200
     0.337     0.019     0.200
     0.342    -0.253     0.200
     0.388    -0.000     0.200
     0.516    -0.152     0.200
     0.481     0.001     0.200
     0.958     0.239     0.200
     0.966     0.162     0.200
     0.354    -0.665     0.200
     0.531    -0.229     0.200
     0.585    -0.340     0.200
     0.594    -0.034     0.200
     0.704     0.140     0.200
     0.698     0.055     0.200
     0.737     0.011     0.200
     0.745     0.120     0.200
     0.851    -0.229     0.200
     0.902    -0.006     0.200
     0.982    -0.774     0.200
     0.982    -0.380     0.200
     0.965     0.105     0.200
     0.978    -0.203     0.200
     0.217     0.246     0.200
     0.299     0.265     0.200
     0.496    -0.043     0.200
     0.539    -0.304     0.200
     0.584     0.324     0.200
     0.610     0.044     0.200
     0.729    -0.121     0.200
     0.852     0.105     0.200
     0.840    -0.190     0.200
     0.990     0.495     0.200
     0.214     0.426     0.200
     0.296     0.626     0.200
     0.543    -0.308     0.200
     0.492    -0.028     0.200
     0.585     0.324     0.200
     0.609     0.070     0.200
     0.732    -0.131     0.200
     0.839    -0.206     0.200
     0.983     0.735     0.200
     0.985     0.613     0.200
     0.732    -0.516     0.200
     0.872    -0.275     0.200
     0.880     0.224     0.200
     0.957     0.266     0.200
     0.531    -0.210     0.200
     0.531    -0.460     0.200
     0.767    -0.479     0.200
     0.836    -0.426     0.200
     0.926     0.197     0.200
     0.954    -0.064     0.200
     0.938    -0.055     0.200
     0.849    -0.178     0.200
     0.849     0.045     0.200
     0.494    -0.372     0.200
     0.578    -0.016     0.200
     0.641    -0.299     0.200
     0.645     0.479     0.200
     0.677     0.679     0.200
     0.699    -0.012     0.200
     0.769     0.094     0.200
     0.778     0.100     0.200
     0.783    -0.192     0.200
     0.842    -0.479     0.200
     0.835     0.252     0.200
     0.439     0.049     0.200
     0.664    -0.198     0.200
     0.856    -0.467     0.200
     0.823    -0.340     0.200
     0.786    -0.202     0.200
     0.891     0.261     0.200
     0.915    -0.181     0.200
     0.923     0.054     0.200
     0.935     0.262     0.200
     0.893     0.449     0.200
     0.897     0.497     0.200
     0.900     0.535     0.200
     0.906     0.605     0.200
     0.911     0.517     0.200
     0.919     0.462     0.200
     0.115     0.068     0.200
     0.207     0.058     0.200
     0.265     0.618     0.200
     0.297     0.237     0.200
     0.351     0.112     0.200
     0.318     0.083     0.200
     0.355     0.107     0.200
     0.370     0.079     0.200
     0.415     0.150     0.200
     0.606    -0.198     0.200
     0.652     0.504     0.200
     0.795     0.010     0.200
     0.928    -0.165     0.200
     0.569    -0.318     0.200
     0.569    -0.091     0.200
     0.730    -0.681     0.200
     0.730    -0.572     0.200
     0.750    -0.564     0.200
     0.774     0.144     0.200
     0.777    -0.076     0.200
     0.850    -0.191     0.200
     0.853    -0.347     0.200
     0.882    -0.249     0.200
     0.892    -0.067     0.200
     0.909    -0.318     0.200
     0.951    -0.061     0.200
     0.954    -0.211     0.200
     0.463    -0.045     0.200
     0.632    -0.643     0.200
     0.863    -0.611     0.200
     0.892    -0.156     0.200
     0.972    -0.429     0.200
     0.579    -0.512     0.200
     0.788     0.144     0.200
     0.788    -0.324     0.200
     0.859    -0.563     0.200
     0.921    -0.121     0.200
     0.564    -0.570     0.200
     0.631    -0.253     0.200
     0.734    -0.227     0.200
     0.730    -0.412     0.200
     0.747    -0.142     0.200
     0.753    -0.018     0.200
     0.753    -0.120     0.200
     0.776    -0.021     0.200
     0.927     0.064     0.200
     0.959    -0.055     0.200
     0.413    -0.400     0.200
     0.413    -0.528     0.200
     0.946    -0.194     0.200
     0.910    -0.207     0.200
     0.746     1.200     0.200
     0.834     1.158     0.200
     0.279    -0.474     0.200
     0.424    -0.023     0.200
     0.700     0.149     0.200
     0.857     0.407     0.200
     0.860     0.611     0.200
     0.878     0.474     0.200
     0.883     0.493     0.200
     0.579    -0.529     0.200
     0.824    -0.382     0.200
     0.762    -0.195     0.200
     0.270    -0.199     0.200
     0.313     0.154     0.200
     0.398     0.133     0.200
     0.532     0.158     0.200
     0.549     0.076     0.200
     0.813    -0.275     0.200
     0.932     0.075     0.200
     0.932     0.317     0.200
     0.711    -0.484     0.200
     0.711    -0.203     0.200
     0.782    -1.429     0.200
     0.303     0.104     0.200
     0.362    -0.229     0.200
     0.368    -0.188     0.200
     0.455     0.163     0.200
     0.502     0.045     0.200
     0.652     0.030     0.200
     0.974     0.335     0.200
     0.980     0.309     0.200
     0.604    -0.222     0.200
     0.715    -0.119     0.200
     0.732    -0.085     0.200
     0.755     0.088     0.200
     0.772    -0.322     0.200
     0.780    -0.197     0.200
     0.581    -0.194     0.200
     0.913     0.332     0.200
     0.921     0.456     0.200
     0.923     0.394     0.200
     0.942     0.379     0.200
     0.615     0.266     0.200
     0.655     0.608     0.200
     0.663     0.707     0.200
     0.683     0.706     0.200
     0.692     0.677     0.200
     0.861     0.260     0.200
     0.861     0.670     0.200
     0.845     0.401     0.200
     0.845     0.547     0.200
     0.845     0.514     0.200
     0.882     0.372     0.200
     0.469     0.115     0.200
     0.567    -0.170     0.200
     0.787    -0.053     0.200
     0.796     0.087     0.200
     0.854    -0.173     0.200
     0.904     0.220     0.200
     0.903     0.525     0.200
     0.906     0.590     0.200
     0.924     0.519     0.200
     0.925     0.602     0.200
     0.929     0.535     0.200
     0.215    -0.328     0.200
     0.529    -0.871     0.200
     0.459    -0.183     0.200
     0.460    -0.186     0.200
     0.570    -0.145     0.200
     0.708    -0.116     0.200
     0.752     0.008     0.200
     0.543     0.049     0.200
     0.638    -0.525     0.200
     0.831     0.835     0.200
     0.860     0.693     0.200
     0.935     0.146     0.200
     0.564    -0.133     0.200
     0.823    -1.103     0.200
     0.289    -0.181     0.200
     0.446    -0.146     0.200
     0.446     0.007     0.200
     0.480    -0.102     0.200
     0.660     0.214     0.200
     0.762    -0.546     0.200
     0.788     0.069     0.200
     0.804    -0.244     0.200
     0.803    -0.407     0.200
     0.863    -0.223     0.200
     0.863     0.082     0.200
     0.265     0.315     0.200
     0.289     0.292     0.200
     0.449     0.179     0.200
     0.618    -0.155     0.200
     0.992     0.319     0.200
     0.423    -0.160     0.200
     0.490    -0.142     0.200
     0.592    -0.140     0.200
     0.603     0.087     0.200
     0.612     0.243     0.200
     0.614    -0.007     0.200
     0.626    -0.194     0.200
     0.723     0.519     0.200
     0.833     0.249     0.200
     0.877    -0.223     0.200
     0.921    -0.148     0.200
     0.911    -0.108     0.200
     0.996    -0.059     0.200
     0.580    -0.006     0.200
     0.624    -0.147     0.200
     0.690    -0.550     0.200
     0.758    -0.302     0.200
     0.758    -0.001     0.200
     0.851    -0.327     0.200
     0.867    -0.294     0.200
     0.930     0.076     0.200
     0.822    -0.640     0.200
     0.194    -0.084     0.200
     0.296    -0.080     0.200
     0.278    -0.090     0.200
     0.324     0.261     0.200
     0.350     0.163     0.200
     0.369     0.465     0.200
     0.376     0.377     0.200
     0.446     0.172     0.200
     0.478     0.121     0.200
     0.490     0.477     0.200
     0.565     0.108     0.200
     0.678    -0.268     0.200
     0.692    -0.156     0.200
     0.693    -0.167     0.200
     0.991    -0.086     0.200
     0.949     0.159     0.200
     0.949     0.416     0.200
     0.181    -0.110     0.200
     0.463     0.206     0.200
     0.487     0.501     0.200
     0.553     0.158     0.200
     0.677    -0.154     0.200
     0.950     0.388     0.200
     0.755     0.076     0.200
     0.737    -0.064     0.200
     0.737     0.151     0.200
     0.794    -0.256     0.200
     0.236     0.032     0.200
     0.236     0.243     0.200
     0.659     0.391     0.200
     0.712    -0.154     0.200
     0.714    -0.184     0.200
     0.985     0.653     0.200
     0.985     0.332     0.200
     0.985     0.578     0.200
     0.498    -0.321     0.200
     0.671    -0.249     0.200
     0.492    -0.234     0.200
     0.052    -0.338     0.200
     0.331     0.148     0.200
     0.360     0.054     0.200
     0.401    -0.037     0.200
     0.484    -0.172     0.200
     0.571     0.151     0.200
     0.651    -0.089     0.200
     0.716    -0.342     0.200
     0.889     0.196     0.200
     0.855    -2.348     0.200
     0.579    -0.263     0.200
     0.569     0.039     0.200
     0.930     0.266     0.200
     0.930     0.386     0.200
     0.461    -0.396     0.200
     0.429    -0.439     0.200
     0.429    -0.271     0.200
     0.871    -0.110     0.200
     0.871     0.031     0.200
     0.737     0.419     0.200
     0.940    -0.064     0.200
     0.308    -0.149     0.200
     0.602    -0.798     0.200
     0.721    -0.217     0.200
     0.233     0.121     0.200
     0.498    -0.292     0.200
     0.657    -0.146     0.200
     0.654    -0.111     0.200
     0.658     0.367     0.200
     0.679    -0.152     0.200
     0.747     0.181     0.200
     0.760    -0.081     0.200
     0.816     0.241     0.200
     0.799    -0.029     0.200
     0.785    -0.004     0.200
     0.944    -0.032     0.200
     0.944    -0.290     0.200
     0.944    -0.036     0.200
     0.920     0.158     0.200
     0.970    -0.174     0.200
     0.971    -0.113     0.200
     0.033     0.326     0.200
     0.116     0.030     0.200
     0.157    -0.124     0.200
     0.147     0.096     0.200
     0.171     0.121     0.200
     0.355    -0.319     0.200
     0.449     0.054     0.200
     0.597     0.309     0.200
     0.770     0.110     0.200
     0.850    -0.041     0.200
     0.886    -0.136     0.200
     0.908     0.166     0.200
     0.998     0.248     0.200
     0.358    -0.446     0.200
     0.358    -0.225     0.200
     0.431     0.077     0.200
     0.432     0.064     0.200
     0.602    -0.199     0.200
     0.677     0.080     0.200
     0.742    -0.198     0.200
     0.881    -1.386     0.200
     0.386     0.099     0.200
     0.457    -0.076     0.200
     0.457     0.072     0.200
     0.471     0.106     0.200
     0.554     0.109     0.200
     0.611    -0.026     0.200
     0.673     0.389     0.200
     0.675     0.430     0.200
     0.732    -0.022     0.200
     0.733     0.007     0.200
     0.764    -0.219     0.200
     0.776    -0.241     0.200
     0.787    -0.150     0.200
     0.841     0.057     0.200
     0.840     0.338     0.200
     0.870     0.182     0.200
     0.893     0.805     0.200
     0.899     0.803     0.200
     0.884     0.348     0.200
     0.922     0.150     0.200
     0.894    -0.079     0.200
     0.894    -0.872     0.200
     0.052    -0.109     0.200
     0.285     0.104     0.200
     0.331     0.175     0.200
     0.353     0.085     0.200
     0.495     0.120     0.200
     0.523    -0.382     0.200
     0.749    -0.186     0.200
     0.811    -0.023     0.200
     0.883    -0.094     0.200
     0.283    -0.110     0.200
     0.761    -0.135     0.200
     0.802     0.147     0.200
     0.802    -0.103     0.200
     0.836    -0.399     0.200
     0.937     0.054     0.200
     0.980    -0.181     0.200
     0.966    -0.216     0.200
     0.972     0.429     0.200
     0.991    -0.164     0.200
     0.186    -0.138     0.200
     0.213     0.162     0.200
     0.262     0.001     0.200
     0.263     0.028     0.200
     0.319     0.175     0.200
     0.353     0.181     0.200
     0.364     0.419     0.200
     0.370    -0.075     0.200
     0.371    -0.177     0.200
     0.372     0.157     0.200
     0.372    -0.184     0.200
     0.406    -0.018     0.200
     0.417     0.315     0.200
     0.499     0.372     0.200
     0.517    -0.042     0.200
     0.597     0.279     0.200
     0.622     0.097     0.200
     0.800    -0.126     0.200
     0.836    -0.176     0.200
     0.933     0.288     0.200
     0.972     0.098     0.200
     0.976     0.167     0.200
     0.355    -0.074     0.200
     0.356    -0.093     0.200
     0.603     0.074     0.200
     0.695    -0.388     0.200
     0.806    -0.206     0.200
     0.887    -0.285     0.200
     0.969     0.028     0.200
     0.359    -0.155     0.200
     0.402    -0.163     0.200
     0.503    -0.046     0.200
     0.518     0.222     0.200
     0.526    -0.044     0.200
     0.554     0.105     0.200
     0.566    -0.192     0.200
     0.658     0.134     0.200
     0.666    -0.257     0.200
     0.665     0.027     0.200
     0.696    -0.241     0.200
     0.696    -0.356     0.200
     0.727    -0.165     0.200
     0.727    -0.012     0.200
     0.789     0.057     0.200
     0.808     0.288     0.200
     0.840    -0.050     0.200
     0.920    -0.064     0.200
     0.920    -0.173     0.200
     0.919    -0.173     0.200
     0.943     0.213     0.200
     0.953     0.067     0.200
     0.352    -0.233     0.200
     0.413    -0.145     0.200
     0.514     0.215     0.200
     0.537    -0.124     0.200
     0.577    -0.048     0.200
     0.660    -0.034     0.200
     0.676     0.212     0.200
     0.706     0.015     0.200
     0.729    -0.016     0.200
     0.844    -0.061     0.200
     0.931     0.044     0.200
     0.784    -0.380     0.200
     0.300    -0.428     0.200
     0.789    -0.634     0.200
     0.514    -0.192     0.200
     0.536     0.140     0.200
     0.536     0.015     0.200
     0.663     0.276     0.200
     0.664     0.325     0.200
     0.783    -0.525     0.200
     0.787    -0.437     0.200
     0.788    -0.490     0.200
     0.813     0.052     0.200
     0.856     0.144     0.200
     0.899    -0.174     0.200
     0.903    -0.075     0.200
     0.936    -0.207     0.200
     0.950    -0.148     0.200
     0.967     0.244     0.200
     0.974     0.438     0.200
     0.986     0.057     0.200
     0.994     0.493     0.200
     0.256     0.619     0.200
     0.302    -0.050     0.200
     0.380     0.355     0.200
     0.397     0.189     0.200
     0.441     0.424     0.200
     0.548    -0.134     0.200
     0.596    -0.145     0.200
     0.582     0.218     0.200
     0.576     0.544     0.200
     0.868     0.004     0.200
     0.948    -0.262     0.200
     0.995    -0.100     0.200
     0.290    -0.534     0.200
     0.290    -0.135     0.200
     0.290    -0.264     0.200
     0.753    -0.175     0.200
     0.745     0.225     0.200
     0.745     0.545     0.200
     0.174    -0.392     0.200
     0.174    -0.563     0.200
     0.679    -0.634     0.200
     0.792     0.013     0.200
     0.793     0.001     0.200
     0.897    -0.670     0.200
     0.798     0.287     0.200
     0.062    -0.012     0.200
     0.027     0.082     0.200
     0.143     0.394     0.200
     0.196     0.140     0.200
     0.205     0.101     0.200
     0.242    -0.131     0.200
     0.243    -0.136     0.200
     0.286    -0.179     0.200
     0.504    -0.016     0.200
     0.556     0.188     0.200
     0.700     0.167     0.200
     0.796     0.161     0.200
     0.079    -0.099     0.200
     0.351     0.179     0.200
     0.419     0.170     0.200
     0.475     0.477     0.200
     0.559     0.146     0.200
     0.615    -0.261     0.200
     0.616    -0.276     0.200
     0.684    -0.349     0.200
     0.782     0.081     0.200
     0.819     0.037     0.200
     0.850     0.065     0.200
     0.630     0.194     0.200
     0.676    -0.027     0.200
     0.685    -0.101     0.200
     0.701     0.156     0.200
     0.755    -0.094     0.200
     0.827    -0.162     0.200
     0.836     0.068     0.200
     0.827    -0.414     0.200
     0.844     0.182     0.200
     0.956    -0.110     0.200
     0.553    -0.131     0.200
     0.621     0.349     0.200
     0.625     0.054     0.200
     0.680     0.075     0.200
     0.700    -0.012     0.200
     0.654     0.264     0.200
     0.790     0.093     0.200
     0.924    -0.520     0.200
     0.920     0.047     0.200
     0.906    -0.002     0.200
     0.989     0.023     0.200
     0.459    -0.642     0.200
     0.493    -0.087     0.200
     0.495    -0.186     0.200
     0.820     0.114     0.200
     0.052    -0.205     0.200
     0.730    -0.931     0.200
     0.792     0.198     0.200
     0.364     0.154     0.200
     0.365     0.202     0.200
     0.399    -0.238     0.200
     0.399    -0.028     0.200
     0.728     0.263     0.200
     0.731     0.272     0.200
     0.748     0.315     0.200
     0.917     0.304     0.200
     0.539    -0.603     0.200
     0.668    -0.020     0.200
     0.676    -0.358     0.200
     0.677    -0.294     0.200
     0.740     0.034     0.200
     0.792     0.377     0.200
     0.943    -0.709     0.200
     0.882     0.057     0.200
     0.929    -0.207     0.200
     0.926    -0.119     0.200
     0.935    -0.224     0.200
     0.995     0.173     0.200
     0.397     0.075     0.200
     0.656    -0.233     0.200
     0.656    -0.131     0.200
     0.646     0.045     0.200
     0.665    -0.137     0.200
     0.676    -0.201     0.200
     0.676    -0.215     0.200
     0.754    -0.029     0.200
     0.776     0.136     0.200
     0.890     0.005     0.200
     0.962    -0.098     0.200
     0.964    -0.117     0.200
     0.979     0.361     0.200
     0.981     0.407     0.200
     0.581     0.007     0.200
     0.580    -0.336     0.200
     0.581    -0.221     0.200
     0.640    -0.227     0.200
     0.657     0.198     0.200
     0.792     0.071     0.200
     0.923     0.003     0.200
     0.940    -0.189     0.200
     0.371    -0.060     0.200
     0.438     0.225     0.200
     0.440     0.327     0.200
     0.585    -0.137     0.200
     0.747     0.195     0.200
     0.745     0.253     0.200
     0.703    -0.044     0.200
     0.764     0.196     0.200
     0.783     0.068     0.200
     0.859    -0.270     0.200
     0.914     0.064     0.200
     0.929    -0.369     0.200
     0.930    -0.427     0.200
     0.335    -0.567     0.200
     0.335    -0.137     0.200
     0.335    -0.258     0.200
     0.841    -2.197     0.200
     0.841    -2.307     0.200
     0.477     0.156     0.200
     0.479     0.180     0.200
     0.614     0.249     0.200
     0.666    -0.101     0.200
     0.666    -0.431     0.200
     0.732    -0.122     0.200
     0.856    -0.157     0.200
     0.250    -0.061     0.200
     0.329     0.109     0.200
     0.432     0.172     0.200
     0.432     0.289     0.200
     0.415    -0.160     0.200
     0.487     0.043     0.200
     0.487    -0.113     0.200
     0.488    -0.177     0.200
     0.660     0.103     0.200
     0.660     0.319     0.200
     0.742    -0.031     0.200
     0.867     0.590     0.200
     0.892     0.592     0.200
     0.826     0.113     0.200
     0.889     0.538     0.200
     0.891     0.275     0.200
     0.993     0.028     0.200
     0.311     0.226     0.200
     0.363     0.057     0.200
     0.564    -0.211     0.200
     0.564    -0.057     0.200
     0.566    -0.223     0.200
     0.752     0.554     0.200
     0.775     0.546     0.200
     0.803     0.578     0.200
     0.805     0.249     0.200
     0.861     0.003     0.200
     0.943     0.102     0.200
     1.000    -0.409     0.200
     0.023    -0.021     0.200
     0.241    -0.127     0.200
     0.134     0.167     0.200
     0.150    -0.246     0.200
     0.188    -0.117     0.200
     0.331    -0.075     0.200
     0.270    -0.226     0.200
     0.318    -0.241     0.200
     0.319    -0.395     0.200
     0.348     0.056     0.200
     0.337    -0.081     0.200
     0.424     0.079     0.200
     0.775     0.192     0.200
     0.775     0.004     0.200
     0.888    -0.310     0.200
     0.917    -0.866     0.200
     0.917    -0.628     0.200
     0.227    -0.274     0.200
     0.701    -0.089     0.200
     0.816    -0.227     0.200
     0.894    -0.217     0.200
     0.959    -0.225     0.200
     0.959     0.284     0.200
     0.991    -0.191     0.200
     0.218    -0.414     0.200
     0.218    -0.524     0.200
     0.619    -0.270     0.200
     0.619    -0.305     0.200
     0.868    -0.632     0.200
     0.868    -0.773     0.200
     0.542    -0.568     0.200
     0.542    -0.396     0.200
     0.722    -0.062     0.200
     0.813     0.193     0.200
     0.862     0.037     0.200
     0.862    -0.187     0.200
     0.871    -0.076     0.200
     0.909     0.114     0.200
     0.447     0.181     0.200
     0.654    -0.247     0.200
     0.646     0.719     0.200
     0.718     0.034     0.200
     0.731     0.050     0.200
     0.728    -0.149     0.200
     0.807    -0.128     0.200
     0.784     0.294     0.200
     0.834     0.088     0.200
     0.857    -0.232     0.200
     0.944     0.544     0.200
     0.484    -0.031     0.200
     0.578    -0.451     0.200
     0.701    -0.214     0.200
     0.795    -0.293     0.200
     0.109     0.221     0.200
     0.250     0.452     0.200
     0.208    -0.066     0.200
     0.282    -0.411     0.200
     0.316     0.249     0.200
     0.375     0.371     0.200
     0.755     0.154     0.200
     0.906    -0.611     0.200
     0.906    -0.171     0.200
     0.937     0.070     0.200
     0.993     0.101     0.200
     0.951     0.060     0.200
     0.951     0.429     0.200
     0.056    -0.043     0.200
     0.056     0.066     0.200
     0.055     0.028     0.200
     0.305     0.325     0.200
     0.314     0.094     0.200
     0.420     0.177     0.200
     0.466     0.093     0.200
     0.788     0.020     0.200
     0.825     0.420     0.200
     0.825     0.248     0.200
     0.815     0.322     0.200
     0.815     0.462     0.200
     0.916     0.294     0.200
     0.916     0.098     0.200
     0.430     0.107     0.200
     0.537    -0.324     0.200
     0.576    -0.239     0.200
     0.662    -0.130     0.200
     0.682    -0.356     0.200
     0.900     0.095     0.200
     0.948     0.127     0.200
     0.348    -0.043     0.200
     0.420    -0.140     0.200
     0.389     0.065     0.200
     0.535    -0.021     0.200
     0.863    -0.218     0.200
     0.836    -0.046     0.200
     0.873    -0.140     0.200
     0.918     0.168     0.200
     0.959     0.067     0.200
     0.920    -2.021     0.200
     0.835    -0.712     0.200
     0.575    -0.666     0.200
     0.700    -0.194     0.200
     0.700    -0.463     0.200
     0.957    -0.360     0.200
     0.957    -0.547     0.200
     0.885    -0.384     0.200
     0.410    -0.122     0.200
     0.477     0.120     0.200
     0.492    -0.311     0.200
     0.660     0.436     0.200
     0.756    -0.487     0.200
     0.867     0.088     0.200
     0.867    -0.705     0.200
     0.936    -0.281     0.200
     0.996    -0.244     0.200
     0.374    -0.132     0.200
     0.560    -0.288     0.200
     0.626    -0.208     0.200
     0.702     0.094     0.200
     0.820    -0.144     0.200
     0.885    -0.177     0.200
     0.918    -0.306     0.200
     0.917     0.078     0.200
     0.113    -0.229     0.200
     0.706    -0.294     0.200
     0.727    -0.339     0.200
     0.747    -0.052     0.200
     0.746    -0.183     0.200
     0.831    -0.205     0.200
     0.874     0.270     0.200
     0.892     0.287     0.200
     0.914     0.130     0.200
     0.920     0.107     0.200
     0.933    -0.430     0.200
     0.419    -0.289     0.200
     0.419    -0.570     0.200
     0.498    -0.321     0.200
     0.483    -0.227     0.200
     0.483    -0.463     0.200
     0.520    -0.319     0.200
     0.796    -0.100     0.200
     0.804    -0.340     0.200
     0.858    -0.334     0.200
     0.938     0.117     0.200
     0.960    -0.225     0.200
     0.998    -0.371     0.200
     0.998    -0.211     0.200
     0.133     0.244     0.200
     0.164     0.155     0.200
     0.247     0.133     0.200
     0.311    -0.192     0.200
     0.439    -0.190     0.200
     0.471    -0.300     0.200
     0.548     0.422     0.200
     0.566     0.031     0.200
     0.589     0.156     0.200
     0.634    -0.103     0.200
     0.894    -0.136     0.200
     0.976     0.373     0.200
     0.499     0.440     0.200
     0.568    -0.577     0.200
     0.617     0.028     0.200
     0.866    -0.116     0.200
     0.883    -0.331     0.200
     0.931    -0.484     0.200
     0.923     0.102     0.200
     0.949    -0.470     0.200
     0.981    -0.351     0.200
     0.985     0.285     0.200
     0.261     0.228     0.200
     0.406    -0.032     0.200
     0.535     0.012     0.200
     0.626     0.611     0.200
     0.612     0.088     0.200
     0.700    -0.296     0.200
     0.672     0.399     0.200
     0.688     0.503     0.200
     0.704     0.411     0.200
     0.862    -0.323     0.200
     0.989    -0.061     0.200
     0.198     0.050     0.200
     0.645    -1.061     0.200
     0.987     0.043     0.200
     0.674    -0.156     0.200
     0.792    -0.227     0.200
     0.809    -0.144     0.200
     0.811    -0.310     0.200
     0.839     0.045     0.200
     0.865    -0.171     0.200
     0.885     0.277     0.200
     0.905    -0.032     0.200
     0.929     0.127     0.200
     0.978     0.092     0.200
     0.439    -0.456     0.200
     0.445     0.076     0.200
     0.491     0.013     0.200
     0.511    -0.486     0.200
     0.613    -0.131     0.200
     0.622    -0.275     0.200
     0.708    -0.161     0.200
     0.707    -0.344     0.200
     0.880    -0.136     0.200
     0.904     0.189     0.200
     0.997    -0.113     0.200
     0.356    -0.423     0.200
     0.488    -0.212     0.200
     0.488    -0.431     0.200
     0.864    -0.372     0.200
     0.300     0.405     0.200
     0.393     0.151     0.200
     0.469     0.149     0.200
     0.562    -0.219     0.200
     0.600    -0.069     0.200
     0.722     0.524     0.200
     0.725    -0.278     0.200
     0.739     0.655     0.200
     0.745     0.708     0.200
     0.746     0.729     0.200
     0.749     0.746     0.200
     0.768     0.589     0.200
     0.767     0.742     0.200
     0.840     0.168     0.200
     0.889    -0.137     0.200
     0.973     0.112     0.200
     0.658    -0.644     0.200
     0.668    -0.748     0.200
     0.829    -0.323     0.200
     0.921    -0.212     0.200
     0.977     0.223     0.200
     0.988     0.092     0.200
     0.990     0.091     0.200
     0.995     0.067     0.200
     0.782    -2.418     0.200
     0.352    -0.201     0.200
     0.371    -0.241     0.200
     0.448    -0.032     0.200
     0.468    -0.320     0.200
     0.605    -0.416     0.200
     0.619    -0.202     0.200
     0.686    -0.196     0.200
     0.723    -0.015     0.200
     0.754    -0.397     0.200
     0.783    -0.127     0.200
     0.843    -0.114     0.200
     0.895     0.039     0.200
     0.895    -0.211     0.200
     0.919    -0.010     0.200
     0.428    -0.967     0.200
     0.428    -0.647     0.200
     0.822    -1.548     0.200
     0.709    -0.250     0.200
     0.730    -0.127     0.200
     0.759    -0.127     0.200
     0.809    -0.160     0.200
     0.889    -0.140     0.200
     0.890    -0.111     0.200
     0.906     0.065     0.200
     0.947     0.178     0.200
     0.974    -0.184     0.200
     0.962    -0.018     0.200
     0.943    -0.640     0.200
     0.943    -0.169     0.200
     0.419    -0.361     0.200
     0.732     0.049     0.200
     0.941    -0.523     0.200
     0.950    -0.464     0.200
     0.971    -0.153     0.200
     0.507    -0.290     0.200
     0.541    -0.093     0.200
     0.361    -0.021     0.200
     0.422    -0.729     0.200
     0.292    -0.288     0.200
     0.322    -0.185     0.200
     0.405    -0.126     0.200
     0.429    -0.484     0.200
     0.470    -0.014     0.200
     0.466    -0.259     0.200
     0.472     0.057     0.200
     0.552    -0.281     0.200
     0.664    -0.338     0.200
     0.673     0.019     0.200
     0.689     0.239     0.200
     0.750     0.124     0.200
     0.794     0.048     0.200
     0.814    -0.148     0.200
     0.822     0.250     0.200
     0.898     0.040     0.200
     0.284    -0.338     0.200
     0.305    -0.186     0.200
     0.306    -0.257     0.200
     0.387    -0.268     0.200
     0.372     0.186     0.200
     0.380     0.107     0.200
     0.397     0.014     0.200
     0.487     0.058     0.200
     0.491     0.174     0.200
     0.946    -0.138     0.200
     0.995     0.110     0.200
     0.551    -0.139     0.200
     0.551     0.080     0.200
     0.551     0.181     0.200
     0.633    -0.345     0.200
     0.831     0.272     0.200
     0.841    -0.260     0.200
     0.881    -0.270     0.200
     0.886     0.324     0.200
     0.903    -0.336     0.200
     0.990    -0.235     0.200
     0.993     0.109     0.200
     0.575    -0.381     0.200
     0.689     0.258     0.200
     0.750    -0.116     0.200
     0.759     0.089     0.200
     0.870    -0.486     0.200
     0.853    -0.325     0.200
     0.852     0.471     0.200
     0.882    -0.274     0.200
     0.962     0.012     0.200
     0.975    -0.075     0.200
     0.976    -0.131     0.200
     0.347     0.084     0.200
     0.322    -0.209     0.200
     0.421     0.149     0.200
     0.517    -0.185     0.200
     0.550    -0.033     0.200
     0.681    -0.258     0.200
     0.739     0.356     0.200
     0.795     0.278     0.200
     0.756     0.466     0.200
     0.761     0.470     0.200
     0.761     0.574     0.200
     0.764     0.563     0.200
     0.819    -0.111     0.200
     0.785     0.584     0.200
     0.845    -0.171     0.200
     0.928     0.271     0.200
     0.993    -0.308     0.200
     0.055    -0.110     0.200
     0.092    -0.316     0.200
     0.125    -0.012     0.200
     0.117     0.039     0.200
     0.260    -0.128     0.200
     0.382     0.196     0.200
     0.432     0.351     0.200
     0.470    -0.077     0.200
     0.579     0.344     0.200
     0.770     0.156     0.200
     0.791     0.110     0.200
     0.866     0.125     0.200
     0.883     0.066     0.200
     0.956     0.137     0.200
     0.532    -0.346     0.200
     0.689     0.131     0.200
     0.689    -0.024     0.200
     0.767    -0.365     0.200
     0.828    -0.248     0.200
     0.848    -0.141     0.200
     0.886    -0.072     0.200
     0.910     0.017     0.200
     0.916     0.542     0.200
     0.956     0.482     0.200
     0.980     0.283     0.200
     0.332     0.083     0.200
     0.729     0.443     0.200
     0.747     0.354     0.200
     0.754     0.550     0.200
     0.769     0.475     0.200
     0.800     0.623     0.200
     0.880    -0.315     0.200
     0.903    -0.361     0.200
     0.914    -0.464     0.200
     0.957     0.062     0.200
     0.997    -0.270     0.200
     0.998     0.334     0.200
     0.752     0.101     0.200
     0.857     0.309     0.200
     0.862     0.031     0.200
     0.998     0.022     0.200
     0.967     0.057     0.200
     0.752    -0.386     0.200
     0.856    -0.210     0.200
     0.859    -0.420     0.200
     0.980    -0.473     0.200
     0.355     0.064     0.200
     0.535    -0.063     0.200
     0.615     0.045     0.200
     0.690    -0.298     0.200
     0.772    -0.338     0.200
     0.759     0.350     0.200
     0.777     0.362     0.200
     0.784     0.472     0.200
     0.800     0.449     0.200
     0.829     0.536     0.200
     0.945     0.204     0.200
     0.482    -0.134     0.200
     0.505    -0.175     0.200
     0.552    -0.156     0.200
     0.653     0.011     0.200
     0.655     0.187     0.200
     0.734    -0.334     0.200
     0.853     0.071     0.200
     0.863     0.341     0.200
     0.966    -0.631     0.200
     0.718    -0.528     0.200
     0.827    -0.209     0.200
     0.827    -0.092     0.200
     0.936     0.228     0.200
     0.297     0.258     0.200
     0.338    -0.179     0.200
     0.356     0.272     0.200
     0.429    -0.208     0.200
     0.438    -0.115     0.200
     0.455    -0.057     0.200
     0.522    -0.002     0.200
     0.570     0.256     0.200
     0.576    -0.082     0.200
     0.706    -0.519     0.200
     0.733     0.034     0.200
     0.985    -0.189     0.200
     0.985    -0.463     0.200
     0.985     0.077     0.200
     0.484     0.155     0.200
     0.558     0.123     0.200
     0.567    -0.150     0.200
     0.656    -0.327     0.200
     0.672    -0.210     0.200
     0.691    -0.191     0.200
     0.685     0.065     0.200
     0.752    -0.107     0.200
     0.778    -0.217     0.200
     0.780    -0.227     0.200
     0.771    -0.067     0.200
     0.807     0.111     0.200
     0.982    -1.477     0.200
     0.547    -0.102     0.200
     0.731    -0.146     0.200
     0.731     0.050     0.200
     0.724    -0.143     0.200
     0.807    -0.040     0.200
     0.858    -0.152     0.200
     0.904     0.257     0.200
     0.919     0.506     0.200
     0.932     0.472     0.200
     0.934     0.301     0.200
     0.956     0.318     0.200
     0.985    -0.401     0.200
     0.108    -0.191     0.200
     0.194     0.032     0.200
     0.198    -0.198     0.200
     0.244    -0.083     0.200
     0.280    -0.013     0.200
     0.286     0.038     0.200
     0.326     0.076     0.200
     0.370    -0.014     0.200
     0.456    -0.092     0.200
     0.506    -0.147     0.200
     0.581    -0.386     0.200
     0.592    -0.303     0.200
     0.591     0.218     0.200
     0.631     0.290     0.200
     0.662     0.247     0.200
     0.671     0.353     0.200
     0.728     0.122     0.200
     0.719     0.148     0.200
     0.857     0.324     0.200
     0.863    -0.786     0.200
     0.210     0.178     0.200
     0.216     0.223     0.200
     0.233     0.182     0.200
     0.243    -0.097     0.200
     0.292     0.157     0.200
     0.299     0.011     0.200
     0.327     0.018     0.200
     0.334     0.273     0.200
     0.357     0.016     0.200
     0.360    -0.119     0.200
     0.397    -0.182     0.200
     0.416     0.235     0.200
     0.427    -0.067     0.200
     0.443     0.021     0.200
     0.533     0.256     0.200
     0.887     0.126     0.200
     0.919    -0.263     0.200
     0.920     0.059     0.200
     0.933     0.146     0.200
     0.946     0.362     0.200
     0.956     0.019     0.200
     0.993     0.121     0.200
     0.316    -0.268     0.200
     0.421     0.033     0.200
     0.613     0.106     0.200
     0.628     0.165     0.200
     0.642     0.312     0.200
     0.668     0.336     0.200
     0.764    -0.108     0.200
     0.402    -0.186     0.200
     0.808     0.116     0.200
     0.827    -0.081     0.200
     0.844    -0.388     0.200
     0.855     0.082     0.200
     0.865    -0.068     0.200
     0.875    -0.004     0.200
     0.892    -0.023     0.200
     0.932     0.116     0.200
     0.340     0.126     0.200
     0.721     0.497     0.200
     0.735     0.449     0.200
     0.737     0.544     0.200
     0.871    -0.483     0.200
     0.930     0.227     0.200
     0.167    -0.599     0.200
     0.691     0.095     0.200
     0.628    -0.120     0.200
     0.496     0.028     0.200
     0.895    -0.399     0.200
     0.959    -0.578     0.200
     0.959     0.344     0.200
     0.966    -0.473     0.200
     0.105    -0.156     0.200
     0.628    -0.079     0.200
     0.798     0.235     0.200
     0.806     0.251     0.200
     0.827     0.369     0.200
     0.829     0.426     0.200
     0.905    -0.198     0.200
     0.862     0.416     0.200
     0.562    -0.610     0.200
     0.615     0.123     0.200
     0.610    -0.438     0.200
     0.608    -0.454     0.200
     0.668    -0.090     0.200
     0.663     0.035     0.200
     0.670    -0.545     0.200
     0.762     0.177     0.200
     0.762    -0.082     0.200
     0.827    -0.032     0.200
     0.881    -0.326     0.200
     0.985     0.095     0.200
     0.337     0.169     0.200
     0.396    -0.040     0.200
     0.439    -0.016     0.200
     0.520     0.169     0.200
     0.590    -0.230     0.200
     0.687    -0.215     0.200
     0.696     0.377     0.200
     0.748    -0.252     0.200
     0.769    -0.203     0.200
     0.779    -0.278     0.200
     0.814     0.380     0.200
     0.867     0.298     0.200
     0.832     0.425     0.200
     0.836     0.530     0.200
     0.841     0.483     0.200
     0.847     0.350     0.200
     0.851     0.481     0.200
     0.858     0.387     0.200
     0.862     0.316     0.200
     0.964     0.093     0.200
     0.417     0.072     0.200
     0.462     0.095     0.200
     0.542     0.160     0.200
     0.572    -0.112     0.200
     0.588    -0.145     0.200
     0.700    -0.340     0.200
     0.706    -0.247     0.200
     0.711    -0.235     0.200
     0.744    -0.317     0.200
     0.744     0.574     0.200
     0.787    -0.270     0.200
     0.830     0.058     0.200
     0.824     0.212     0.200
     0.873    -0.155     0.200
     0.889    -0.057     0.200
     0.672    -0.667     0.200
     0.230    -0.239     0.200
     0.262    -0.187     0.200
     0.283    -0.309     0.200
     0.318    -0.085     0.200
     0.359     0.219     0.200
     0.376    -0.264     0.200
     0.372     0.246     0.200
     0.412    -0.373     0.200
     0.414     0.097     0.200
     0.473     0.182     0.200
     0.553    -0.026     0.200
     0.573    -0.145     0.200
     0.569    -0.131     0.200
     0.924     0.134     0.200
     0.398    -0.243     0.200
     0.602    -0.033     0.200
     0.654     0.157     0.200
     0.810    -0.007     0.200
     0.413    -0.126     0.200
     0.868     0.133     0.200
     0.441     0.027     0.200
     0.525    -0.094     0.200
     0.624     0.042     0.200
     0.706     0.182     0.200
     0.841    -0.689     0.200
     0.822     0.085     0.200
     0.838     0.116     0.200
     0.848     0.318     0.200
     0.852     0.253     0.200
     0.869     0.213     0.200
     0.875    -0.430     0.200
     0.893     0.252     0.200
     0.923    -0.274     0.200
     0.936    -0.306     0.200
     0.934    -0.243     0.200
     0.362    -0.573     0.200
     0.700    -0.525     0.200
     0.692     0.391     0.200
     0.692     0.243     0.200
     0.786    -0.405     0.200
     0.802    -0.304     0.200
     0.820    -0.478     0.200
     0.826     0.014     0.200
     0.835    -0.242     0.200
     0.868     0.238     0.200
     0.884    -0.062     0.200
     0.912     0.192     0.200
     0.956    -0.289     0.200
     0.147    -0.318     0.200
     0.549    -0.296     0.200
     0.890    -0.367     0.200
     0.931     0.036     0.200
     0.309    -0.256     0.200
     0.640    -0.018     0.200
     0.749    -0.339     0.200
     0.749    -0.034     0.200
     0.744    -0.319     0.200
     0.778    -0.368     0.200
     0.772    -0.447     0.200
     0.802    -0.435     0.200
     0.851     0.124     0.200
     0.881     0.206     0.200
     0.874     0.101     0.200
     0.907    -0.215     0.200
     0.929    -0.089     0.200
     0.610    -0.624     0.200
     0.610     0.022     0.200
     0.641     0.111     0.200
     0.652     0.268     0.200
     0.772     0.231     0.200
     0.720    -0.183     0.200
     0.724     0.111     0.200
     0.745    -0.126     0.200
     0.810     0.210     0.200
     0.795    -0.303     0.200
     0.829    -0.376     0.200
     0.865    -0.145     0.200
     0.913    -0.176     0.200
     0.898    -0.032     0.200
     0.940    -0.313     0.200
     0.939     0.023     0.200
     0.943    -0.112     0.200
     0.303     0.029     0.200
     0.370     0.118     0.200
     0.492     0.134     0.200
     0.571     0.122     0.200
     0.655    -0.130     0.200
     0.653     0.884     0.200
     0.715    -0.131     0.200
     0.816    -0.405     0.200
     0.845    -0.253     0.200
     0.861    -0.354     0.200
     0.893    -0.125     0.200
     0.423    -0.116     0.200
     0.491     0.201     0.200
     0.540    -0.043     0.200
     0.644     0.012     0.200
     0.726     0.135     0.200
     0.792    -0.083     0.200
     0.796     0.300     0.200
     0.812     0.351     0.200
     0.856     0.010     0.200
     0.823     0.550     0.200
     0.826     0.511     0.200
     0.831     0.376     0.200
     0.835     0.431     0.200
     0.845     0.417     0.200
     0.890    -0.083     0.200
     0.947    -0.168     0.200
     0.009     0.126     0.200
     0.096     0.013     0.200
     0.069     0.181     0.200
     0.112     0.175     0.200
     0.168    -0.164     0.200
     0.163    -0.078     0.200
     0.172    -0.155     0.200
     0.241     0.034     0.200
     0.267    -0.122     0.200
     0.285     0.249     0.200
     0.345     0.327     0.200
     0.355     0.108     0.200
     0.361     0.028     0.200
     0.490     0.305     0.200
     0.798    -0.336     0.200
     0.849     0.273     0.200
     0.877     0.180     0.200
     0.952     0.262     0.200
     0.951     0.209     0.200
     0.460     0.205     0.200
     0.470    -0.019     0.200
     0.582    -0.071     0.200
     0.681     0.017     0.200
     0.809    -0.393     0.200
     0.763     0.092     0.200
     0.824    -0.202     0.200
     0.833     0.176     0.200
     0.849     0.200     0.200
     0.860     0.402     0.200
     0.863     0.225     0.200
     0.867     0.493     0.200
     0.872     0.524     0.200
     0.932    -0.086     0.200
     0.986    -0.331     0.200
     0.977    -0.303     0.200
     0.557    -0.365     0.200
     0.767    -0.575     0.200
     0.820    -0.451     0.200
     0.828    -0.520     0.200
     0.837    -0.580     0.200
     0.909     0.066     0.200
     0.932    -0.376     0.200
     0.932    -0.332     0.200
     0.951    -0.308     0.200
     0.954     0.027     0.200
     0.935    -0.356     0.200
     0.975    -0.070     0.200
     0.995    -0.363     0.200
     0.155     0.061     0.200
     0.293     0.094     0.200
     0.365     0.050     0.200
     0.361     0.193     0.200
     0.465    -0.227     0.200
     0.494    -0.187     0.200
     0.628    -0.219     0.200
     0.673    -0.073     0.200
     0.702     0.151     0.200
     0.702    -0.299     0.200
     0.741     0.193     0.200
     0.770    -0.020     0.200
     0.767     0.462     0.200
     0.787     0.720     0.200
     0.874     0.012     0.200
     0.881     0.037     0.200
     0.964    -0.383     0.200
     0.991     0.375     0.200
     0.293     0.273     0.200
     0.329     0.301     0.200
     0.392     0.173     0.200
     0.423     0.125     0.200
     0.448     0.230     0.200
     0.471     0.232     0.200
     0.504    -0.019     0.200
     0.514     0.067     0.200
     0.571     0.352     0.200
     0.652     0.444     0.200
     0.706     0.147     0.200
     0.712     0.456     0.200
     0.749     0.254     0.200
     0.774     0.414     0.200
     0.764     0.086     0.200
     0.865    -0.349     0.200
     0.836     0.324     0.200
     0.899    -0.205     0.200
     0.607    -0.157     0.200
     0.696     0.123     0.200
     0.706     0.011     0.200
     0.765    -0.126     0.200
     0.791    -0.172     0.200
     0.823    -0.301     0.200
     0.812    -0.073     0.200
     0.843    -0.199     0.200
     0.838    -0.608     0.200
     0.879     0.334     0.200
     0.887     0.287     0.200
     0.977    -0.021     0.200
     0.384     0.104     0.200
     0.766     0.186     0.200
     0.697    -0.066     0.200
     0.736    -0.023     0.200
     0.769     0.013     0.200
     0.870    -0.096     0.200
     0.874     0.243     0.200
     0.880    -0.108     0.200
     0.887     0.131     0.200
     0.925    -0.202     0.200
     0.935     0.281     0.200
     0.984     0.228     0.200
     0.207    -0.684     0.200
     0.429    -0.710     0.200
     0.489    -0.209     0.200
     0.499    -0.399     0.200
     0.596    -0.270     0.200
     0.615     0.071     0.200
     0.634    -0.314     0.200
     0.636     0.225     0.200
     0.660    -0.091     0.200
     0.733     0.352     0.200
     0.740     0.125     0.200
     0.918     0.017     0.200
     0.916     0.114     0.200
     0.942     0.196     0.200
     0.972     0.122     0.200
     0.345    -0.063     0.200
     0.389    -0.264     0.200
     0.401    -0.232     0.200
     0.455    -0.113     0.200
     0.526    -0.129     0.200
     0.543     0.174     0.200
     0.549     0.081     0.200
     0.556    -0.143     0.200
     0.651    -0.588     0.200
     0.681     0.073     0.200
     0.709     0.152     0.200
     0.738     0.093     0.200
     0.773    -0.142     0.200
     0.790     0.336     0.200
     0.862    -0.167     0.200
     0.907    -0.098     0.200
     0.975    -0.049     0.200
     0.392    -0.411     0.200
     0.715    -0.424     0.200
     0.290    -0.102     0.200
     0.370    -0.256     0.200
     0.418    -0.055     0.200
     0.451    -0.228     0.200
     0.532    -0.137     0.200
     0.613    -0.298     0.200
     0.645    -0.211     0.200
     0.666    -0.285     0.200
     0.689     0.113     0.200
     0.730     0.287     0.200
     0.741    -0.107     0.200
     0.834     0.457     0.200
     0.854     0.511     0.200
     0.852     0.695     0.200
     0.859     0.675     0.200
     0.861     0.603     0.200
     0.862     0.698     0.200
     0.883     0.630     0.200
     0.380    -0.233     0.200
     0.666    -0.102     0.200
     0.742     0.262     0.200
     0.747    -0.317     0.200
     0.758     0.811     0.200
     0.769     0.428     0.200
     0.820    -0.282     0.200
     0.900    -0.326     0.200
     0.899     0.037     0.200
     0.978    -0.492     0.200
     0.583     0.195     0.200
     0.639    -0.196     0.200
     0.684    -0.114     0.200
     0.684     0.136     0.200
     0.651    -0.259     0.200
     0.688    -0.291     0.200
     0.679    -0.649     0.200
     0.707    -0.288     0.200
     0.743    -0.370     0.200
     0.777    -0.248     0.200
     0.810     0.422     0.200
     0.843     0.336     0.200
     0.853     0.019     0.200
     0.870    -0.297     0.200
     0.181    -0.180     0.200
     0.264    -0.348     0.200
     0.278    -0.120     0.200
     0.279    -0.134     0.200
     0.331     0.227     0.200
     0.369     0.237     0.200
     0.365    -0.008     0.200
     0.363     0.116     0.200
     0.551     0.333     0.200
     0.950     0.476     0.200
     0.975     0.351     0.200
     0.113    -0.187     0.200
     0.127    -0.016     0.200
     0.186     0.258     0.200
     0.205    -0.029     0.200
     0.203    -0.447     0.200
     0.277     0.338     0.200
     0.303    -0.148     0.200
     0.320     0.013     0.200
     0.338     0.631     0.200
     0.376     0.141     0.200
     0.437     0.131     0.200
     0.483     0.081     0.200
     0.921     0.087     0.200
     0.959    -0.146     0.200
     0.389    -0.301     0.200
     0.412    -0.446     0.200
     0.433    -0.250     0.200
     0.482    -0.134     0.200
     0.481    -0.120     0.200
     0.568     0.018     0.200
     0.753     0.116     0.200
     0.633    -0.121     0.200
     0.681    -0.013     0.200
     0.693     0.072     0.200
     0.694    -0.194     0.200
     0.755     0.375     0.200
     0.749    -0.061     0.200
     0.788     0.139     0.200
     0.809     0.129     0.200
     0.805     0.058     0.200
     0.841     0.529     0.200
     0.849    -0.005     0.200
     0.937    -0.382     0.200
     0.964     0.103     0.200
     0.215    -0.133     0.200
     0.233    -0.198     0.200
     0.247    -0.218     0.200
     0.299    -0.062     0.200
     0.334     0.051     0.200
     0.389     0.127     0.200
     0.393     0.003     0.200
     0.399     0.038     0.200
     0.397     0.047     0.200
     0.499    -0.273     0.200
     0.622    -0.262     0.200
     0.646     0.290     0.200
     0.713     0.142     0.200
     0.751    -0.076     0.200
     0.769     0.139     0.200
     0.856     0.002     0.200
     0.986    -0.018     0.200
     0.997     0.138     0.200
     0.593    -0.249     0.200
     0.258     0.104     0.200
     0.151    -0.409     0.200
     0.223    -0.121     0.200
     0.222    -0.251     0.200
     0.323    -0.096     0.200
     0.331     0.186     0.200
     0.350     0.054     0.200
     0.364     0.100     0.200
     0.380     0.093     0.200
     0.402    -0.242     0.200
     0.524     0.153     0.200
     0.543     0.410     0.200
     0.667    -0.084     0.200
     0.679     0.326     0.200
     0.790     0.025     0.200
     0.793     0.199     0.200
     0.858     0.169     0.200
     0.930     0.098     0.200
     0.594    -0.451     0.200
     0.707    -0.368     0.200
     0.712    -0.291     0.200
     0.726     0.021     0.200
     0.739    -0.459     0.200
     0.747    -0.050     0.200
     0.768    -0.324     0.200
     0.827     0.017     0.200
     0.840    -0.025     0.200
     0.976    -0.065     0.200
     0.328     0.117     0.200
     0.743    -0.460     0.200
     0.158    -0.068     0.200
     0.256     0.052     0.200
     0.264     0.189     0.200
     0.270     0.184     0.200
     0.271    -0.145     0.200
     0.275     0.176     0.200
     0.357     0.002     0.200
     0.369     0.120     0.200
     0.357     0.244     0.200
     0.406    -0.058     0.200
     0.428    -0.264     0.200
     0.489    -0.130     0.200
     0.857    -0.160     0.200
     0.914    -0.034     0.200
     0.293     0.087     0.200
     0.238     0.216     0.200
     0.434     0.075     0.200
     0.505     0.114     0.200
     0.605    -0.214     0.200
     0.618    -0.266     0.200
     0.676     0.652     0.200
     0.676     0.280     0.200
     0.682     0.559     0.200
     0.685     0.809     0.200
     0.704     0.557     0.200
     0.768    -0.214     0.200
     0.758     0.343     0.200
     0.812    -0.106     0.200
     0.838    -0.228     0.200
     0.843     0.110     0.200
     0.882     0.180     0.200
     0.909    -0.037     0.200
     0.993    -0.473     0.200
     0.431     0.105     0.200
     0.431    -0.074     0.200
     0.406    -0.060     0.200
     0.922    -0.484     0.200
     0.419    -0.999     0.200
     0.991     0.032     0.200
     0.274    -0.352     0.200
     0.742    -0.678     0.200
     0.829    -0.203     0.200
     0.209    -0.153     0.200
     0.777    -0.133     0.200
     0.777     0.441     0.200
     0.766     0.136     0.200
     0.046    -0.061     0.200
     0.262     0.282     0.200
     0.325     0.328     0.200
     0.333    -0.009     0.200
     0.374     0.332     0.200
     0.441     0.275     0.200
     0.549     0.234     0.200
     0.698     0.185     0.200
     0.710    -0.113     0.200
     0.885    -0.179     0.200
     0.301     0.120     0.200
     0.330    -0.014     0.200
     0.366    -0.272     0.200
     0.368     0.064     0.200
     0.586    -0.190     0.200
     0.609     0.108     0.200
     0.727    -0.007     0.200
     0.800     0.054     0.200
     0.966    -0.226     0.200
     0.968     0.450     0.200
     0.080    -0.013     0.200
     0.265     0.356     0.200
     0.301    -0.040     0.200
     0.327     0.089     0.200
     0.342     0.414     0.200
     0.347     0.166     0.200
     0.422     0.370     0.200
     0.428     0.187     0.200
     0.459     0.149     0.200
     0.487     0.083     0.200
     0.499    -0.133     0.200
     0.609     0.148     0.200
     0.776    -0.186     0.200
     0.883    -0.160     0.200
     0.499    -0.051     0.200
     0.831    -0.162     0.200
     0.452    -0.020     0.200
     0.573     0.326     0.200
     0.575     0.061     0.200
     0.654     0.109     0.200
     0.692     0.494     0.200
     0.709     0.491     0.200
     0.717     0.271     0.200
     0.721     0.531     0.200
     0.728     0.588     0.200
     0.732     0.559     0.200
     0.737    -0.233     0.200
     0.736     0.567     0.200
     0.763     0.640     0.200
     0.796    -0.123     0.200
     0.924    -0.134     0.200
     0.938    -0.265     0.200
     0.987    -0.172     0.200
     0.987    -0.054     0.200
     0.171    -0.063     0.200
     0.207     0.224     0.200
     0.221    -0.053     0.200
     0.240     0.194     0.200
     0.224     0.225     0.200
     0.236     0.153     0.200
     0.322     0.358     0.200
     0.309     0.102     0.200
     0.347     0.167     0.200
     0.364     0.036     0.200
     0.380    -0.125     0.200
     0.438     0.358     0.200
     0.495     0.092     0.200
     0.899    -0.210     0.200
     0.960     0.046     0.200
     0.966     0.041     0.200
     0.014     0.030     0.200
     0.098    -0.031     0.200
     0.111    -0.079     0.200
     0.151     0.058     0.200
     0.147     0.304     0.200
     0.178     0.173     0.200
     0.181     0.124     0.200
     0.219     0.207     0.200
     0.327     0.004     0.200
     0.449     0.396     0.200
     0.645     0.548     0.200
     0.709     0.146     0.200
     0.826     0.002     0.200
     0.972     0.163     0.200
     0.755    -0.358     0.200
     0.727    -0.132     0.200
     0.393    -0.119     0.200
     0.559    -0.493     0.200
     0.965     0.224     0.200
     0.952    -0.293     0.200
     0.993     0.155     0.200
     0.569    -0.745     0.200
     0.536    -0.482     0.200
     0.582    -0.416     0.200
     0.643    -0.328     0.200
     0.699    -0.013     0.200
     0.736     0.053     0.200
     0.787     0.252     0.200
     0.819     0.012     0.200
     0.204    -0.006     0.200
     0.668    -0.264     0.200
     0.668     0.002     0.200
     0.980     0.156     0.200
     0.991     0.192     0.200
     0.999     0.361     0.200
     0.663    -1.103     0.200
     0.663    -0.572     0.200
     0.663    -0.713     0.200
     0.662    -0.484     0.200
     0.473    -0.152     0.200
     0.473    -0.348     0.200
     0.629    -0.012     0.200
     0.956    -0.284     0.200
     0.983    -0.285     0.200
     0.040     0.214     0.200
     0.113     0.359     0.200
     0.155     0.300     0.200
     0.155    -0.060     0.200
     0.176     0.077     0.200
     0.882     0.249     0.200
     0.906     0.097     0.200
     0.987     0.099     0.200
     0.955     0.502     0.200
     0.153    -0.159     0.200
     0.573     0.196     0.200
     0.762     0.515     0.200
     0.772     0.571     0.200
     0.776     0.578     0.200
     0.793     0.335     0.200
     0.806     0.658     0.200
     0.806     0.279     0.200
     0.825     0.169     0.200
     0.829    -0.482     0.200
     0.910    -0.403     0.200
     0.643     0.134     0.200
     0.718     0.298     0.200
     0.855     0.177     0.200
     0.888    -0.431     0.200
     0.919     0.182     0.200
     0.958    -0.061     0.200
     0.961    -0.845     0.200
     0.673    -0.068     0.200
     0.750     0.262     0.200
     0.857    -0.020     0.200
     0.883     0.130     0.200
     0.912     0.001     0.200
     0.932    -0.367     0.200
     0.957    -0.050     0.200
     0.998    -0.114     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.088    -0.512     0.200
     0.173     0.426     0.200
     0.539     0.959     0.200
     0.268     0.619     0.200
     0.630    -0.438     0.200
     0.872    -1.299     0.200
     0.538     0.713     0.200
     0.292     0.449     0.200
     0.292     0.602     0.200
     0.386     0.112     0.200
     0.922    -0.174     0.200
     0.863     1.127     0.200
     0.861    -0.566     0.200
     0.444     1.270     0.200
     0.448    -0.720     0.200
     0.067     0.511     0.200
     0.601    -1.049     0.200
     0.728    -1.578     0.200
     0.858     1.207     0.200
     0.664     0.332     0.200
     0.372     0.348     0.200
     0.783    -0.645     0.200
     0.057     0.816     0.200
     0.431     0.421     0.200
     0.804     0.111     0.200
     0.191     1.027     0.200
     0.470     0.339     0.200
     0.501     1.198     0.200
     0.319    -0.144     0.200
     0.997     0.067     0.200
     0.419     0.727     0.200
     0.518     0.384     0.200
     0.360     1.314     0.200
     0.831    -0.841     0.200
     0.831    -0.970     0.200
     0.715     1.359     0.200
     0.436    -0.605     0.200
     0.453     1.130     0.200
     0.588     1.877     0.200
     0.825    -0.240     0.200
     0.563     1.004     0.200
     0.563     1.433     0.200
     0.551     0.732     0.200
     0.551     1.011     0.200
     0.606     1.230     0.200
     0.606     1.058     0.200
     0.703    -0.114     0.200
     0.996    -1.015     0.200
     0.996    -1.124     0.200
     0.346     1.289     0.200
     0.346     1.645     0.200
     0.855    -2.788     0.200
     0.855    -2.581     0.200
     0.518     0.512     0.200
     0.746     2.516     0.200
     0.982    -1.340     0.200
     0.719     2.076     0.200
     0.895    -0.223     0.200
     0.499     0.494     0.200
     0.499     0.812     0.200
     0.439    -0.025     0.200
     0.439     0.338     0.200
     0.843    -0.635     0.200
     0.247     0.763     0.200
     0.881    -0.802     0.200
     0.166     1.087     0.200
     0.644     0.071     0.200
     0.657     0.034     0.200
     0.713     0.110     0.200
     0.766    -0.065     0.200
     0.825    -2.276     0.200
     0.871    -0.260     0.200
     0.961    -0.439     0.200
     0.581     0.963     0.200
     0.419     0.500     0.200
     0.419     0.664     0.200
     0.436     0.511     0.200
     0.512     0.536     0.200
     0.498     0.324     0.200
     0.574     0.595     0.200
     0.619     0.673     0.200
     0.340     0.961     0.200
     0.342     1.083     0.200
     0.388     1.399     0.200
     0.387     1.505     0.200
     0.888     0.181     0.200
     0.842     0.920     0.200
     0.305     0.527     0.200
     0.305     0.391     0.200
     0.386     0.387     0.200
     0.784    -0.643     0.200
     0.530    -0.726     0.200
     0.451     0.919     0.200
     0.338     0.493     0.200
     0.338     0.724     0.200
     0.679     1.328     0.200
     0.272     1.300     0.200
     0.272     1.479     0.200
     0.862    -3.953     0.200
     0.862    -3.516     0.200
     0.364     1.251     0.200
     0.364     1.001     0.200
     0.827    -1.822     0.200
     0.827    -1.330     0.200
     0.482     0.506     0.200
     0.497     0.450     0.200
     0.514     0.205     0.200
     0.557     0.415     0.200
     0.695     0.642     0.200
     0.911    -1.714     0.200
     0.935    -0.807     0.200
     0.965    -1.350     0.200
     0.648     0.799     0.200
     0.649     0.749     0.200
     0.903    -0.974     0.200
     0.595     1.609     0.200
     0.554     0.396     0.200
     0.574    -0.322     0.200
     0.414     0.817     0.200
     0.545     0.434     0.200
     0.564    -0.118     0.200
     0.393     1.766     0.200
     0.531     0.437     0.200
     0.554    -0.093     0.200
     0.972    -0.976     0.200
     0.485     0.441     0.200
     0.485     0.582     0.200
     0.946    -0.779     0.200
     0.517    -0.375     0.200
     0.719    -0.493     0.200
     0.199     1.373     0.200
     0.199     1.053     0.200
     0.920    -1.533     0.200
     0.920    -2.106     0.200
     0.463    -0.280     0.200
     0.651    -0.154     0.200
     0.206     0.841     0.200
     0.835    -0.554     0.200
     0.885    -0.651     0.200
     0.860    -0.496     0.200
     0.476     0.722     0.200
     0.392     0.511     0.200
     0.414     0.454     0.200
     0.560     0.380     0.200
     0.588     0.574     0.200
     0.674     0.779     0.200
     0.675     1.636     0.200
     0.879    -0.481     0.200
     0.570     2.315     0.200
     0.548    -0.507     0.200
     0.940    -0.434     0.200
     0.564     0.215     0.200
     0.997    -1.970     0.200
     0.651     0.298     0.200
     0.325     1.919     0.200
     0.782    -2.863     0.200
     0.380     1.955     0.200
     0.754    -1.158     0.200
     0.707     0.933     0.200
     0.807    -0.011     0.200
     0.858    -0.159     0.200
     0.854     0.383     0.200
     0.856    -0.008     0.200
     0.857     0.296     0.200
     0.932    -0.297     0.200
     0.960    -0.448     0.200
     0.375     1.040     0.200
     0.375     1.219     0.200
     0.722    -1.857     0.200
     0.722    -1.216     0.200
     0.807     0.291     0.200
     0.865    -0.848     0.200
     0.857     0.185     0.200
     0.935    -0.085     0.200
     0.960     0.524     0.200
     0.488    -0.042     0.200
     0.500    -0.274     0.200
     0.581     0.101     0.200
     0.835    -1.736     0.200
     0.957    -0.740     0.200
     0.620    -0.816     0.200
     0.788     0.066     0.200
     0.852     0.965     0.200
     0.765     0.533     0.200
     0.861     0.605     0.200
     0.686    -0.593     0.200
     0.686    -0.772     0.200
     0.111     0.427     0.200
     0.475     0.777     0.200
     0.475     0.160     0.200
     0.299     0.169     0.200
     0.340     0.227     0.200
     0.396     0.252     0.200
     0.402    -0.241     0.200
     0.419     0.254     0.200
     0.469     0.589     0.200
     0.613     0.219     0.200
     0.301    -0.012     0.200
     0.341     0.090     0.200
     0.361    -0.222     0.200
     0.402    -0.246     0.200
     0.398    -0.120     0.200
     0.416     0.139     0.200
     0.471     0.336     0.200
     0.521     0.400     0.200
     0.938    -0.730     0.200
     0.026     0.668     0.200
     0.098    -0.803     0.200
     0.100     0.048     0.200
     0.234    -0.137     0.200
     0.226     1.258     0.200
     0.251     0.017     0.200
     0.320     0.511     0.200
     0.321     0.507     0.200
     0.370    -0.314     0.200
     0.357     1.416     0.200
     0.412     0.335     0.200
     0.522     0.731     0.200
     0.615     1.388     0.200
     0.646     0.780     0.200
     0.726    -0.792     0.200
     0.924    -0.779     0.200
     0.955    -0.442     0.200
     0.445     0.400     0.200
     0.321     0.749     0.200
     0.490    -1.499     0.200
     0.391     0.080     0.200
     0.444     0.291     0.200
     0.538     1.364     0.200
     0.496     0.713     0.200
     0.561     1.122     0.200
     0.661    -0.931     0.200
     0.786    -0.525     0.200
     0.818    -0.417     0.200
     0.369     1.168     0.200
     0.513     1.086     0.200
     0.576    -0.193     0.200
     0.596    -0.221     0.200
     0.597     0.268     0.200
     0.685     0.598     0.200
     0.678     0.813     0.200
     0.848     0.276     0.200
     0.912    -0.392     0.200
     0.986    -0.299     0.200
     0.650     0.449     0.200
     0.854    -0.496     0.200
     0.854    -0.286     0.200
     0.863    -0.225     0.200
     0.868    -0.176     0.200
     0.538     0.922     0.200
     0.625    -0.096     0.200
     0.596    -0.920     0.200
     0.922    -0.315     0.200
     0.970     0.061     0.200
     0.981     0.263     0.200
     0.981     0.480     0.200
     0.990    -0.186     0.200
     0.988     0.376     0.200
     0.378     0.757     0.200
     0.034     0.590     0.200
     0.053     0.731     0.200
     0.092    -0.007     0.200
     0.162     0.436     0.200
     0.197     0.161     0.200
     0.255    -0.290     0.200
     0.427     0.224     0.200
     0.924     0.597     0.200
     0.037     0.339     0.200
     0.101     0.252     0.200
     0.110     0.165     0.200
     0.109    -0.509     0.200
     0.167    -0.155     0.200
     0.152     0.789     0.200
     0.375     1.733     0.200
     0.436     0.736     0.200
     0.786     0.963     0.200
     0.914     0.418     0.200
     0.033     0.097     0.200
     0.061    -0.495     0.200
     0.072     0.666     0.200
     0.089    -0.123     0.200
     0.156    -0.042     0.200
     0.192     0.884     0.200
     0.224    -0.191     0.200
     0.336     0.530     0.200
     0.399     0.971     0.200
     0.666     0.580     0.200
     0.953    -1.874     0.200
     0.039     0.198     0.200
     0.042    -0.626     0.200
     0.042     0.684     0.200
     0.106    -0.385     0.200
     0.112    -0.609     0.200
     0.145     0.195     0.200
     0.173    -0.239     0.200
     0.270    -0.266     0.200
     0.380     0.004     0.200
     0.427     0.987     0.200
     0.442     0.400     0.200
     0.792    -1.300     0.200
     0.047    -0.094     0.200
     0.047     0.230     0.200
     0.080     0.021     0.200
     0.088     0.441     0.200
     0.129     0.138     0.200
     0.208     0.089     0.200
     0.209     0.677     0.200
     0.323     0.378     0.200
     0.381     0.625     0.200
     0.393     1.096     0.200
     0.028     0.011     0.200
     0.075    -0.201     0.200
     0.061     0.175     0.200
     0.117    -0.065     0.200
     0.178     0.621     0.200
     0.238    -0.340     0.200
     0.411     0.827     0.200
     0.408     0.330     0.200
     0.066    -0.167     0.200
     0.030    -0.029     0.200
     0.092    -0.090     0.200
     0.067     0.024     0.200
     0.122    -0.027     0.200
     0.187     0.618     0.200
     0.341     0.436     0.200
     0.401     0.402     0.200
     0.402     0.779     0.200
     0.793     0.860     0.200
     0.056     0.084     0.200
     0.028     0.735     0.200
     0.070     0.871     0.200
     0.096    -0.199     0.200
     0.133    -0.104     0.200
     0.164     0.244     0.200
     0.219    -0.248     0.200
     0.331     0.172     0.200
     0.392     0.368     0.200
     0.390    -1.477     0.200
     0.390     0.578     0.200
     0.907     0.616     0.200
     0.955     0.886     0.200
     0.044     0.108     0.200
     0.103    -0.633     0.200
     0.034     0.432     0.200
     0.077     0.656     0.200
     0.207     0.030     0.200
     0.317     0.245     0.200
     0.379     0.582     0.200
     0.376     1.395     0.200
     0.038    -0.369     0.200
     0.052    -0.362     0.200
     0.078     0.109     0.200
     0.087     0.078     0.200
     0.215    -0.477     0.200
     0.200     0.464     0.200
     0.228     0.596     0.200
     0.328     0.632     0.200
     0.388     0.535     0.200
     0.393     1.006     0.200
     0.939    -1.030     0.200
     0.350     0.556     0.200
     0.734     0.731     0.200
     0.462     0.369     0.200
     0.746    -0.458     0.200
     0.746    -0.230     0.200
     0.233    -0.411     0.200
     0.216     0.861     0.200
     0.339     0.312     0.200
     0.395     1.136     0.200
     0.423     0.510     0.200
     0.425     1.313     0.200
     0.481     0.377     0.200
     0.615     1.831     0.200
     0.831    -0.668     0.200
     0.458     1.423     0.200
     0.525     0.473     0.200
     0.734    -0.891     0.200
     0.924    -0.371     0.200
     0.924    -0.050     0.200
     0.960    -0.532     0.200
     0.399     0.174     0.200
     0.129     0.771     0.200
     0.755    -0.836     0.200
     0.727     0.004     0.200
     0.569    -0.325     0.200
     0.545     0.824     0.200
     0.486     1.738     0.200
     0.034     0.685     0.200
     0.848     0.757     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.818    -0.602     0.200
     0.773     0.747     0.200
     0.849     0.686     0.200
     0.252    -0.173     0.200
     0.641     0.774     0.200
     0.632    -0.212     0.200
     0.689     1.087     0.200
     0.996     1.067     0.200
     0.830    -0.755     0.200
     0.828     1.139     0.200
     0.553    -0.495     0.200
     0.613    -0.494     0.200
     0.617    -0.088     0.200
     0.637     0.506     0.200
     0.734     1.239     0.200
     0.646     0.052     0.200
     0.974     0.737     0.200
     0.587     0.703     0.200
     0.644    -0.618     0.200
     0.935    -0.887     0.200
     0.989     1.049     0.200
     0.875     1.240     0.200
     0.425     0.976     0.200
     0.438     0.378     0.200
     0.738    -0.040     0.200
     0.912     1.097     0.200
     0.521     0.097     0.200
     0.732     0.188     0.200
     0.906     0.473     0.200
     0.884     0.550     0.200
     0.962     0.997     0.200
     0.964    -0.424     0.200
     0.763     1.549     0.200
     0.710    -1.364     0.200
     0.098     0.491     0.200
     0.095     0.167     0.200
     0.344    -0.293     0.200
     0.567    -0.792     0.200
     0.798     0.702     0.200
     0.893    -0.363     0.200
     0.407     0.721     0.200
     0.520     0.846     0.200
     0.618     0.383     0.200
     0.756     0.509     0.200
     0.781     0.085     0.200
     0.754     0.433     0.200
     0.803     1.009     0.200
     0.959    -0.213     0.200
     0.952     0.379     0.200
     0.717    -0.417     0.200
     0.922     0.041     0.200
     0.942     0.360     0.200
     0.624    -0.945     0.200
     0.963     0.877     0.200
     0.990    -0.761     0.200
     0.060    -0.930     0.200
     0.271    -0.027     0.200
     0.328     0.069     0.200
     0.351    -0.436     0.200
     0.434     0.100     0.200
     0.515    -0.416     0.200
     0.555    -0.617     0.200
     0.609     0.410     0.200
     0.619    -0.137     0.200
     0.690     0.783     0.200
     0.769     0.397     0.200
     0.898     0.280     0.200
     0.782     0.339     0.200
     0.778     1.471     0.200
     0.986     1.265     0.200
     0.203     0.220     0.200
     0.376    -0.387     0.200
     0.433    -1.053     0.200
     0.926    -0.586     0.200
     0.499    -0.325     0.200
     0.503    -0.311     0.200
     0.502    -0.878     0.200
     0.594    -0.327     0.200
     0.763    -0.268     0.200
     0.770    -0.597     0.200
     0.852     0.673     0.200
     0.885     0.347     0.200
     0.903     0.806     0.200
     0.090    -0.008     0.200
     0.307     0.586     0.200
     0.361    -0.138     0.200
     0.434     0.155     0.200
     0.490    -0.318     0.200
     0.524    -0.349     0.200
     0.558     0.377     0.200
     0.570    -0.362     0.200
     0.573    -0.313     0.200
     0.653     0.093     0.200
     0.949    -0.341     0.200
     0.826     0.462     0.200
     0.483     0.067     0.200
     0.810     0.256     0.200
     0.522     0.106     0.200
     0.642     0.041     0.200
     0.764     0.274     0.200
     0.779     1.741     0.200
     0.968    -0.325     0.200
     0.289     0.261     0.200
     0.277     0.488     0.200
     0.357     0.364     0.200
     0.950     0.866     0.200
     0.527     0.015     0.200
     0.809     0.471     0.200
     0.709    -0.255     0.200
     0.708     0.154     0.200
     0.708     0.478     0.200
     0.934    -0.088     0.200
     0.950     0.242     0.200
     0.298     0.012     0.200
     0.513     0.152     0.200
     0.346     0.269     0.200
     0.377     0.149     0.200
     0.523     0.849     0.200
     0.761     0.819     0.200
     0.937     0.329     0.200
     0.958    -0.161     0.200
     0.287     0.675     0.200
     0.686    -1.330     0.200
     0.868     0.176     0.200
     0.984     1.145     0.200
     0.556     0.224     0.200
     0.661    -0.196     0.200
     0.709     0.923     0.200
     0.741     0.309     0.200
     0.894    -0.033     0.200
     0.975     0.679     0.200
     0.658    -0.133     0.200
     0.667     0.079     0.200
     0.781     0.023     0.200
     0.933    -0.976     0.200
     0.634     0.325     0.200
     0.698     1.216     0.200
     0.769    -0.174     0.200
     0.518    -0.292     0.200
     0.521     0.149     0.200
     0.578     0.349     0.200
     0.658    -0.016     0.200
     0.757    -0.355     0.200
     0.973     0.891     0.200
     0.365     0.170     0.200
     0.377     0.649     0.200
     0.470     0.786     0.200
     0.526     0.029     0.200
     0.983     0.414     0.200
     0.840    -0.541     0.200
     0.412    -0.335     0.200
     0.540     0.262     0.200
     0.540     0.627     0.200
     0.741    -0.259     0.200
     0.741    -0.040     0.200
     0.942     1.217     0.200
     0.985     1.273     0.200
     0.441     0.177     0.200
     0.561     1.350     0.200
     0.411     0.805     0.200
     0.774     0.726     0.200
     0.862     0.418     0.200
     0.899     1.111     0.200
     0.749     0.227     0.200
     0.628     0.252     0.200
     0.738     0.230     0.200
     0.900     0.704     0.200
     0.463     0.962     0.200
     0.866    -0.260     0.200
     0.988     0.709     0.200
     0.582     0.751     0.200
     0.697     0.768     0.200
     0.937     0.144     0.200
     0.402     0.385     0.200
     0.531     0.415     0.200
     0.994     0.209     0.200
     0.316     0.105     0.200
     0.335     0.174     0.200
     0.796     0.734     0.200
     0.973    -1.001     0.200
     0.973     0.349     0.200
     0.696     1.463     0.200
     0.760    -1.310     0.200
     0.669     0.120     0.200
     0.768     0.193     0.200
     0.821     1.762     0.200
     0.821     2.117     0.200
     0.832     0.874     0.200
     0.887     1.121     0.200
     0.736     0.293     0.200
     0.856     1.226     0.200
     0.947    -0.669     0.200
     0.947    -0.443     0.200
     0.426     0.057     0.200
     0.542    -1.543     0.200
     0.754     0.001     0.200
     0.821     0.245     0.200
     0.856     0.123     0.200
     0.730     0.669     0.200
     0.777     0.991     0.200
     0.897     0.160     0.200
     0.586     0.753     0.200
     0.365     0.064     0.200
     0.457     0.422     0.200
     0.601    -0.840     0.200
     0.750     0.993     0.200
     0.925    -1.364     0.200
     0.470    -0.813     0.200
     0.470    -0.211     0.200
     0.560     1.295     0.200
     0.738     1.212     0.200
     0.926    -0.530     0.200
     0.945     1.106     0.200
     0.891    -1.357     0.200
     0.479     1.141     0.200
     0.812    -0.114     0.200
     0.794     0.337     0.200
     0.527     1.307     0.200
     0.553     0.395     0.200
     0.539     0.669     0.200
     0.323     0.733     0.200
     0.628    -0.076     0.200
     0.972    -0.845     0.200
     0.965     0.934     0.200
     0.989     0.976     0.200
     0.989     2.181     0.200
     0.926    -1.066     0.200
     0.553     1.627     0.200
     0.700     0.389     0.200
     0.760     0.807     0.200
     0.781     1.060     0.200
     0.815     0.167     0.200
     0.913     0.917     0.200
     0.546     0.070     0.200
     0.546    -0.086     0.200
     0.937     0.506     0.200
     0.694    -0.447     0.200
     0.459     0.216     0.200
     0.999    -0.030     0.200
     0.727    -1.154     0.200
     0.202     0.246     0.200
     0.305    -0.102     0.200
     0.960    -0.330     0.200
     0.536     0.748     0.200
     0.638     0.575     0.200
     0.748     0.573     0.200
     0.798     0.179     0.200
     0.916     0.551     0.200
     0.504     0.594     0.200
     0.283     0.483     0.200
     0.302     0.256     0.200
     0.340    -0.158     0.200
     0.542     0.872     0.200
     0.983     0.006     0.200
     0.362     0.392     0.200
     0.637     0.711     0.200
     0.659     0.764     0.200
     0.836    -0.444     0.200
     0.904    -0.038     0.200
     0.145     0.527     0.200
     0.517    -0.216     0.200
     0.635     0.714     0.200
     0.836    -0.285     0.200
     0.946     1.222     0.200
     0.972     0.811     0.200
     0.634     1.195     0.200
     0.663     0.251     0.200
     0.088    -0.255     0.200
     0.435     0.122     0.200
     0.480     0.411     0.200
     0.668    -1.605     0.200
     0.999    -0.544     0.200
     0.026     0.045     0.200
     0.152     0.537     0.200
     0.191     0.595     0.200
     0.263     1.052     0.200
     0.280    -0.041     0.200
     0.424     1.254     0.200
     0.503     0.401     0.200
     0.569     0.860     0.200
     0.815    -0.253     0.200
     0.135     0.165     0.200
     0.461     0.047     0.200
     0.615    -0.080     0.200
     0.630     0.114     0.200
     0.726     0.596     0.200
     0.783     1.522     0.200
     0.811     0.815     0.200
     0.276     0.580     0.200
     0.299     0.001     0.200
     0.468    -0.356     0.200
     0.888    -0.257     0.200
     0.473    -0.097     0.200
     0.473    -0.327     0.200
     0.850    -0.512     0.200
     0.641    -0.107     0.200
     0.785     0.842     0.200
     0.823     0.708     0.200
     0.846    -0.865     0.200
     0.640     0.089     0.200
     0.685     0.285     0.200
     0.828    -1.052     0.200
     0.803     0.701     0.200
     0.936     0.202     0.200
     0.998     0.232     0.200
     0.342     0.512     0.200
     0.516    -0.241     0.200
     0.966    -0.119     0.200
     0.354    -0.933     0.200
     0.585    -0.338     0.200
     0.704    -0.032     0.200
     0.698    -0.166     0.200
     0.982    -0.417     0.200
     0.965     0.416     0.200
     0.217     1.104     0.200
     0.496     0.322     0.200
     0.610     0.259     0.200
     0.755    -0.679     0.200
     0.543     0.287     0.200
     0.609     0.415     0.200
     0.732    -0.771     0.200
     0.839     0.041     0.200
     0.732    -0.633     0.200
     0.880     0.281     0.200
     0.673    -0.513     0.200
     0.827    -0.093     0.200
     0.531     0.566     0.200
     0.849     0.642     0.200
     0.494     0.145     0.200
     0.641     0.641     0.200
     0.677     1.663     0.200
     0.699    -0.593     0.200
     0.704    -0.177     0.200
     0.842     0.134     0.200
     0.835     2.028     0.200
     0.439     0.472     0.200
     0.525     0.576     0.200
     0.856    -0.555     0.200
     0.823    -0.178     0.200
     0.911     1.005     0.200
     0.351    -0.154     0.200
     0.318     0.675     0.200
     0.415     0.873     0.200
     0.606    -0.185     0.200
     0.795    -0.555     0.200
     0.501    -0.588     0.200
     0.569    -0.166     0.200
     0.569     0.787     0.200
     0.569    -0.604     0.200
     0.730    -0.943     0.200
     0.750    -1.082     0.200
     0.774     0.326     0.200
     0.777    -0.773     0.200
     0.853     0.052     0.200
     0.882     0.206     0.200
     0.951     1.508     0.200
     0.613    -1.440     0.200
     0.463     0.341     0.200
     0.632    -0.500     0.200
     0.892     0.233     0.200
     0.972    -0.026     0.200
     0.579    -0.750     0.200
     0.579    -0.516     0.200
     0.788     1.590     0.200
     0.788     0.926     0.200
     0.859    -0.337     0.200
     0.921     0.967     0.200
     0.631     0.629     0.200
     0.734     0.358     0.200
     0.730     0.432     0.200
     0.747     0.473     0.200
     0.753     0.881     0.200
     0.959     0.153     0.200
     0.413    -0.257     0.200
     0.413    -0.111     0.200
     0.413    -0.417     0.200
     0.657     0.193     0.200
     0.946    -0.813     0.200
     0.910     0.451     0.200
     0.616     0.451     0.200
     0.279     0.198     0.200
     0.424    -0.178     0.200
     0.603     1.575     0.200
     0.700     0.159     0.200
     0.857     1.959     0.200
     0.579    -0.633     0.200
     0.579    -0.490     0.200
     0.824     0.039     0.200
     0.762    -0.919     0.200
     0.313    -0.012     0.200
     0.398    -0.105     0.200
     0.813    -0.866     0.200
     0.932     0.380     0.200
     0.932     0.513     0.200
     0.711     1.321     0.200
     0.711     1.079     0.200
     0.782    -1.371     0.200
     0.782    -1.058     0.200
     0.455     1.181     0.200
     0.980    -0.139     0.200
     0.590    -0.102     0.200
     0.732    -0.263     0.200
     0.723    -2.133     0.200
     0.581     2.246     0.200
     0.942     2.542     0.200
     0.615     0.216     0.200
     0.615     0.368     0.200
     0.655     0.344     0.200
     0.692     0.856     0.200
     0.861     0.658     0.200
     0.845     1.247     0.200
     0.845     1.029     0.200
     0.882    -0.284     0.200
     0.469     0.267     0.200
     0.567    -0.382     0.200
     0.929     0.980     0.200
     0.215    -0.232     0.200
     0.529    -1.452     0.200
     0.459    -0.129     0.200
     0.460    -0.149     0.200
     0.570     0.223     0.200
     0.708     0.326     0.200
     0.708     1.803     0.200
     0.752     0.205     0.200
     0.543     0.405     0.200
     0.638    -0.784     0.200
     0.860     1.363     0.200
     0.564     0.070     0.200
     0.823    -1.666     0.200
     0.446    -0.489     0.200
     0.788     0.817     0.200
     0.803    -0.140     0.200
     0.863     0.425     0.200
     0.863     0.108     0.200
     0.992     1.065     0.200
     0.603     0.187     0.200
     0.877     0.105     0.200
     0.996     0.288     0.200
     0.624     0.347     0.200
     0.758     0.022     0.200
     0.867    -0.579     0.200
     0.821     0.722     0.200
     0.194    -0.046     0.200
     0.296     0.927     0.200
     0.478     0.602     0.200
     0.490     0.892     0.200
     0.565     0.162     0.200
     0.692    -0.402     0.200
     0.693    -0.315     0.200
     0.949     0.542     0.200
     0.949     1.025     0.200
     0.961    -0.721     0.200
     0.961    -0.534     0.200
     0.181     0.566     0.200
     0.463     1.331     0.200
     0.487     1.344     0.200
     0.553     0.536     0.200
     0.677    -0.060     0.200
     0.755     0.812     0.200
     0.755     1.011     0.200
     0.737     1.595     0.200
     0.236     0.507     0.200
     0.659     0.569     0.200
     0.714    -0.898     0.200
     0.985     1.020     0.200
     0.498    -0.341     0.200
     0.498    -0.174     0.200
     0.671    -0.081     0.200
     0.492     0.020     0.200
     0.052    -1.023     0.200
     0.401    -0.114     0.200
     0.571    -0.453     0.200
     0.651    -0.988     0.200
     0.716    -1.264     0.200
     0.889    -0.242     0.200
     0.579    -0.831     0.200
     0.579    -0.698     0.200
     0.930     0.727     0.200
     0.535    -0.409     0.200
     0.535    -0.174     0.200
     0.461     1.117     0.200
     0.429    -0.169     0.200
     0.429     0.153     0.200
     0.871     0.385     0.200
     0.871     0.191     0.200
     0.871     0.507     0.200
     0.308     0.549     0.200
     0.602    -0.086     0.200
     0.721     1.261     0.200
     0.877     1.193     0.200
     0.877    -0.141     0.200
     0.877     0.081     0.200
     0.804     0.977     0.200
     0.772     1.502     0.200
     0.772     1.329     0.200
     0.591    -0.618     0.200
     0.233     0.646     0.200
     0.654     0.410     0.200
     0.760     0.348     0.200
     0.944     0.088     0.200
     0.920     0.129     0.200
     0.920     0.622     0.200
     0.970     0.565     0.200
     0.147     0.348     0.200
     0.171     0.146     0.200
     0.355    -0.387     0.200
     0.449    -0.201     0.200
     0.597     0.672     0.200
     0.358     0.337     0.200
     0.431     0.475     0.200
     0.432     0.453     0.200
     0.602     0.892     0.200
     0.742     0.292     0.200
     0.457    -0.016     0.200
     0.471     0.374     0.200
     0.673     0.287     0.200
     0.675     0.152     0.200
     0.732    -0.013     0.200
     0.733    -0.005     0.200
     0.899     0.772     0.200
     0.913     1.739     0.200
     0.894    -0.424     0.200
     0.894    -0.608     0.200
     0.894    -0.178     0.200
     0.052    -0.303     0.200
     0.331     0.519     0.200
     0.353     0.379     0.200
     0.495     0.126     0.200
     0.749    -0.054     0.200
     0.883    -0.185     0.200
     0.960    -1.408     0.200
     0.283     0.595     0.200
     0.761     0.612     0.200
     0.802     0.629     0.200
     0.937     0.389     0.200
     0.980     0.370     0.200
     0.991    -0.186     0.200
     0.674    -1.297     0.200
     0.262    -0.404     0.200
     0.263    -0.149     0.200
     0.263    -0.411     0.200
     0.319     0.244     0.200
     0.353     0.353     0.200
     0.371    -0.413     0.200
     0.372    -0.003     0.200
     0.372    -0.199     0.200
     0.622    -0.214     0.200
     0.800    -0.100     0.200
     0.800     0.037     0.200
     0.836    -0.863     0.200
     0.356     0.268     0.200
     0.603     0.574     0.200
     0.695     0.972     0.200
     0.887     0.043     0.200
     0.359     0.434     0.200
     0.503     0.173     0.200
     0.526     0.177     0.200
     0.554     0.687     0.200
     0.566     0.102     0.200
     0.696    -0.100     0.200
     0.696    -0.108     0.200
     0.727    -0.172     0.200
     0.808     0.787     0.200
     0.920     0.053     0.200
     0.919     0.070     0.200
     0.943     0.872     0.200
     0.352     0.027     0.200
     0.514    -0.141     0.200
     0.537     0.220     0.200
     0.660     0.433     0.200
     0.706    -0.267     0.200
     0.729     0.382     0.200
     0.931    -0.065     0.200
     0.300    -0.373     0.200
     0.390    -0.306     0.200
     0.789    -0.871     0.200
     0.789    -0.641     0.200
     0.932    -0.626     0.200
     0.932    -1.101     0.200
     0.988    -0.837     0.200
     0.514     0.316     0.200
     0.536     1.242     0.200
     0.663     0.878     0.200
     0.664     0.845     0.200
     0.787    -0.509     0.200
     0.788    -0.533     0.200
     0.813     0.308     0.200
     0.813     0.480     0.200
     0.950     0.258     0.200
     0.986     0.994     0.200
     0.441     1.169     0.200
     0.548     0.416     0.200
     0.596    -0.171     0.200
     0.582     0.287     0.200
     0.868     0.166     0.200
     0.948     0.407     0.200
     0.290     0.325     0.200
     0.290     0.465     0.200
     0.745     0.964     0.200
     0.174    -0.030     0.200
     0.174    -1.041     0.200
     0.679    -0.537     0.200
     0.792     0.701     0.200
     0.793     0.686     0.200
     0.897    -0.046     0.200
     0.798     0.775     0.200
     0.062    -0.460     0.200
     0.027    -0.109     0.200
     0.242    -0.622     0.200
     0.243    -0.631     0.200
     0.556     0.181     0.200
     0.700     0.163     0.200
     0.796    -0.409     0.200
     0.796    -0.224     0.200
     0.079    -0.185     0.200
     0.419     0.047     0.200
     0.559     0.089     0.200
     0.615    -0.479     0.200
     0.616    -0.437     0.200
     0.684    -0.498     0.200
     0.684    -0.736     0.200
     0.819     0.031     0.200
     0.850    -0.323     0.200
     0.630     0.382     0.200
     0.676    -0.060     0.200
     0.827    -0.115     0.200
     0.827    -0.110     0.200
     0.897     0.724     0.200
     0.933     0.876     0.200
     0.553     0.151     0.200
     0.700     0.336     0.200
     0.654     0.972     0.200
     0.906     0.145     0.200
     0.989    -0.145     0.200
     0.459    -0.584     0.200
     0.459     0.236     0.200
     0.493     0.285     0.200
     0.495     0.264     0.200
     0.820     0.116     0.200
     0.820     0.647     0.200
     0.052    -0.160     0.200
     0.730    -1.476     0.200
     0.792     0.817     0.200
     0.689    -0.551     0.200
     0.691    -0.588     0.200
     0.972    -0.872     0.200
     0.865    -0.925     0.200
     0.865    -0.190     0.200
     0.946    -1.055     0.200
     0.364     0.780     0.200
     0.365     0.367     0.200
     0.399    -0.177     0.200
     0.399     1.174     0.200
     0.917     0.059     0.200
     0.539     0.257     0.200
     0.676     0.488     0.200
     0.677     0.587     0.200
     0.740     0.938     0.200
     0.929     0.315     0.200
     0.397     0.546     0.200
     0.656     0.154     0.200
     0.646     1.071     0.200
     0.665     0.039     0.200
     0.676    -0.124     0.200
     0.676    -0.135     0.200
     0.776     0.955     0.200
     0.890    -0.053     0.200
     0.962    -0.070     0.200
     0.964    -0.103     0.200
     0.979     0.397     0.200
     0.981     0.368     0.200
     0.581     0.514     0.200
     0.580     0.112     0.200
     0.581     0.226     0.200
     0.792     0.798     0.200
     0.923     0.545     0.200
     0.371     1.027     0.200
     0.438     1.211     0.200
     0.440     1.186     0.200
     0.585     0.508     0.200
     0.703     0.618     0.200
     0.764     0.460     0.200
     0.914     0.015     0.200
     0.335     0.605     0.200
     0.841    -3.175     0.200
     0.940    -0.187     0.200
     0.477    -0.090     0.200
     0.479     0.029     0.200
     0.614     1.226     0.200
     0.666    -0.311     0.200
     0.666     0.372     0.200
     0.732     0.686     0.200
     0.250     0.624     0.200
     0.432     0.246     0.200
     0.487    -0.334     0.200
     0.826     0.151     0.200
     0.891     0.350     0.200
     0.991    -0.293     0.200
     0.311     0.459     0.200
     0.363     0.637     0.200
     0.564    -0.407     0.200
     0.566    -0.431     0.200
     0.803     0.646     0.200
     0.805     0.571     0.200
     0.861     0.175     0.200
     1.000    -0.861     0.200
     0.188     0.471     0.200
     0.318     0.515     0.200
     0.319     0.365     0.200
     0.424     1.430     0.200
     0.775     1.388     0.200
     0.775     1.216     0.200
     0.888     0.303     0.200
     0.917    -0.061     0.200
     0.227     0.040     0.200
     0.701     0.648     0.200
     0.816     0.538     0.200
     0.959    -1.109     0.200
     0.991    -0.775     0.200
     0.218    -0.096     0.200
     0.218    -0.331     0.200
     0.619    -0.072     0.200
     0.619    -0.181     0.200
     0.868    -0.477     0.200
     0.542    -0.000     0.200
     0.542     0.468     0.200
     0.813     0.335     0.200
     0.862     0.123     0.200
     0.871     0.103     0.200
     0.447    -0.081     0.200
     0.654    -0.269     0.200
     0.718     0.294     0.200
     0.784     0.980     0.200
     0.834     0.305     0.200
     0.944     0.427     0.200
     0.484    -0.031     0.200
     0.578    -0.103     0.200
     0.701     0.919     0.200
     0.795    -0.104     0.200
     0.282    -0.140     0.200
     0.316     0.003     0.200
     0.375     0.542     0.200
     0.937    -0.201     0.200
     0.056    -0.105     0.200
     0.055    -0.088     0.200
     0.305     0.854     0.200
     0.314     0.561     0.200
     0.420    -0.950     0.200
     0.466     0.253     0.200
     0.788    -0.915     0.200
     0.788    -0.493     0.200
     0.825     0.278     0.200
     0.825     0.051     0.200
     0.815     0.764     0.200
     0.815     0.928     0.200
     0.916     0.351     0.200
     0.916     0.108     0.200
     0.430     0.900     0.200
     0.537    -0.158     0.200
     0.576    -0.550     0.200
     0.682    -0.222     0.200
     0.900     1.137     0.200
     0.348     0.000     0.200
     0.420    -0.021     0.200
     0.836    -0.412     0.200
     0.873    -0.109     0.200
     0.643     0.369     0.200
     0.575    -0.417     0.200
     0.700     0.454     0.200
     0.957    -0.432     0.200
     0.631     0.339     0.200
     0.632    -0.178     0.200
     0.885    -1.030     0.200
     0.630     0.714     0.200
     0.974    -0.363     0.200
     0.975     0.162     0.200
     0.410     0.346     0.200
     0.660     0.504     0.200
     0.756    -0.038     0.200
     0.867    -0.010     0.200
     0.374     0.687     0.200
     0.626    -0.002     0.200
     0.702     0.475     0.200
     0.820     0.167     0.200
     0.885     0.225     0.200
     0.918     0.446     0.200
     0.917     0.547     0.200
     0.113     0.559     0.200
     0.706    -0.219     0.200
     0.727     0.188     0.200
     0.747     0.352     0.200
     0.746    -0.038     0.200
     0.831     0.728     0.200
     0.874     0.389     0.200
     0.892     0.483     0.200
     0.914     0.203     0.200
     0.920     0.315     0.200
     0.933     0.193     0.200
     0.419    -0.311     0.200
     0.419    -0.107     0.200
     0.498    -0.099     0.200
     0.483     0.061     0.200
     0.483    -0.163     0.200
     0.520    -0.202     0.200
     0.804    -0.404     0.200
     0.858    -0.259     0.200
     0.998    -1.158     0.200
     0.786     0.288     0.200
     0.133     0.372     0.200
     0.164     0.520     0.200
     0.247     0.465     0.200
     0.311    -0.030     0.200
     0.439    -0.334     0.200
     0.471    -0.116     0.200
     0.548     0.683     0.200
     0.589     0.692     0.200
     0.894    -0.285     0.200
     0.976     1.076     0.200
     0.499     1.151     0.200
     0.568    -0.313     0.200
     0.617     0.620     0.200
     0.949     0.035     0.200
     0.261     0.592     0.200
     0.406     0.723     0.200
     0.535     0.495     0.200
     0.626     0.639     0.200
     0.612     0.545     0.200
     0.700     0.153     0.200
     0.672     0.781     0.200
     0.688     0.658     0.200
     0.704     0.755     0.200
     0.744    -0.231     0.200
     0.862    -0.030     0.200
     0.979     0.083     0.200
     0.198     0.622     0.200
     0.645    -1.379     0.200
     0.987     0.634     0.200
     0.674     0.205     0.200
     0.792     0.262     0.200
     0.809     0.025     0.200
     0.811     0.174     0.200
     0.885     1.214     0.200
     0.929     0.582     0.200
     0.439     0.404     0.200
     0.445     0.871     0.200
     0.491     1.128     0.200
     0.511    -0.053     0.200
     0.613     1.341     0.200
     0.707    -0.342     0.200
     0.880    -0.851     0.200
     0.904    -0.039     0.200
     0.997    -0.326     0.200
     0.356    -0.085     0.200
     0.488     0.138     0.200
     0.488     0.290     0.200
     0.864     1.054     0.200
     0.300     0.033     0.200
     0.393     0.445     0.200
     0.469     0.846     0.200
     0.562     0.155     0.200
     0.600    -0.046     0.200
     0.722     1.070     0.200
     0.725    -0.386     0.200
     0.739     1.228     0.200
     0.746     1.291     0.200
     0.749     1.089     0.200
     0.768    -0.010     0.200
     0.840     0.625     0.200
     0.889    -0.533     0.200
     0.952     1.014     0.200
     0.625    -0.294     0.200
     0.670    -0.536     0.200
     0.670     0.035     0.200
     0.596    -1.523     0.200
     0.658     0.036     0.200
     0.668     0.600     0.200
     0.829    -0.164     0.200
     0.921    -0.598     0.200
     0.977     0.941     0.200
     0.988     1.416     0.200
     0.995     1.339     0.200
     0.352     0.228     0.200
     0.371     0.870     0.200
     0.468     0.188     0.200
     0.605     0.057     0.200
     0.619     0.672     0.200
     0.723     1.254     0.200
     0.754     1.475     0.200
     0.895     0.241     0.200
     0.895     0.655     0.200
     0.428     0.028     0.200
     0.822    -1.183     0.200
     0.822    -0.984     0.200
     0.709    -0.147     0.200
     0.730     0.045     0.200
     0.809    -0.166     0.200
     0.889    -1.193     0.200
     0.890    -0.445     0.200
     0.906     0.371     0.200
     0.947     0.335     0.200
     0.974    -0.174     0.200
     0.962     0.185     0.200
     0.943     0.208     0.200
     0.419     0.420     0.200
     0.732     0.673     0.200
     0.971     0.399     0.200
     0.507    -0.531     0.200
     0.541     0.745     0.200
     0.361     0.298     0.200
     0.422    -1.497     0.200
     0.700    -0.071     0.200
     0.322    -0.073     0.200
     0.405    -0.228     0.200
     0.429    -0.186     0.200
     0.466     0.365     0.200
     0.472     0.049     0.200
     0.552    -0.132     0.200
     0.664    -0.428     0.200
     0.673     0.710     0.200
     0.794     0.417     0.200
     0.814     0.357     0.200
     0.898     0.365     0.200
     0.284    -0.191     0.200
     0.305    -0.122     0.200
     0.372     0.417     0.200
     0.380     0.621     0.200
     0.397     0.177     0.200
     0.491     0.528     0.200
     0.571    -0.098     0.200
     0.946     0.112     0.200
     0.995     0.135     0.200
     0.551     0.133     0.200
     0.551     1.172     0.200
     0.633    -0.442     0.200
     0.841    -0.264     0.200
     0.886     0.025     0.200
     0.903     0.040     0.200
     0.990    -0.029     0.200
     0.575    -0.770     0.200
     0.689     0.924     0.200
     0.750     0.699     0.200
     0.870    -0.932     0.200
     0.853    -0.266     0.200
     0.852     0.966     0.200
     0.975    -0.106     0.200
     0.976    -0.453     0.200
     0.347     0.616     0.200
     0.322     0.692     0.200
     0.421     1.031     0.200
     0.517    -0.096     0.200
     0.550    -0.140     0.200
     0.681    -0.031     0.200
     0.739     0.117     0.200
     0.756     0.665     0.200
     0.761     0.933     0.200
     0.993    -0.660     0.200
     0.995    -1.632     0.200
     0.055    -0.118     0.200
     0.092    -0.553     0.200
     0.125     0.293     0.200
     0.117     0.276     0.200
     0.260    -0.288     0.200
     0.382     0.077     0.200
     0.432     0.271     0.200
     0.470    -0.427     0.200
     0.770    -0.128     0.200
     0.791    -0.407     0.200
     0.866    -0.089     0.200
     0.883    -0.112     0.200
     0.956     0.238     0.200
     0.532    -0.185     0.200
     0.689     0.781     0.200
     0.689     0.406     0.200
     0.767     0.072     0.200
     0.828     0.462     0.200
     0.886     0.665     0.200
     0.981    -0.838     0.200
     0.332     1.311     0.200
     0.729     0.662     0.200
     0.747     0.506     0.200
     0.754     0.624     0.200
     0.769     0.899     0.200
     0.880    -0.327     0.200
     0.903     0.089     0.200
     0.914    -0.370     0.200
     0.957    -0.600     0.200
     0.957    -0.460     0.200
     0.998     0.565     0.200
     0.752     1.360     0.200
     0.752     0.618     0.200
     0.857    -0.016     0.200
     0.862    -0.726     0.200
     0.998     0.366     0.200
     0.967     0.962     0.200
     0.967    -0.448     0.200
     0.752    -0.003     0.200
     0.856     0.061     0.200
     0.859    -0.249     0.200
     0.980    -0.266     0.200
     0.535     0.476     0.200
     0.772    -0.273     0.200
     0.759     0.822     0.200
     0.777     0.821     0.200
     0.801     1.166     0.200
     0.800     0.871     0.200
     0.482    -0.220     0.200
     0.505    -0.141     0.200
     0.552    -0.009     0.200
     0.734    -0.390     0.200
     0.853     0.826     0.200
     0.966    -0.695     0.200
     0.718    -0.160     0.200
     0.718    -0.480     0.200
     0.827    -0.050     0.200
     0.297     0.045     0.200
     0.338     0.104     0.200
     0.356     0.118     0.200
     0.429    -0.442     0.200
     0.438    -0.192     0.200
     0.455    -0.160     0.200
     0.570     1.160     0.200
     0.576    -0.181     0.200
     0.706    -0.462     0.200
     0.733     0.154     0.200
     0.985    -1.088     0.200
     0.985    -1.387     0.200
     0.484     0.602     0.200
     0.567     0.062     0.200
     0.656    -0.324     0.200
     0.672    -0.259     0.200
     0.691     0.018     0.200
     0.685     0.764     0.200
     0.752    -0.051     0.200
     0.778    -0.169     0.200
     0.780    -0.515     0.200
     0.771    -0.394     0.200
     0.936    -0.233     0.200
     0.936    -0.563     0.200
     0.982     0.126     0.200
     0.547     0.222     0.200
     0.731    -0.867     0.200
     0.724     0.571     0.200
     0.807     0.450     0.200
     0.904     0.662     0.200
     0.932     0.254     0.200
     0.956     0.747     0.200
     0.985    -0.341     0.200
     0.108    -0.315     0.200
     0.194     0.237     0.200
     0.198    -0.208     0.200
     0.244    -0.147     0.200
     0.280     0.616     0.200
     0.286     0.206     0.200
     0.456    -0.276     0.200
     0.506    -0.021     0.200
     0.581    -0.881     0.200
     0.591    -0.086     0.200
     0.631     0.724     0.200
     0.719     0.069     0.200
     0.863    -1.832     0.200
     0.210     0.149     0.200
     0.216     0.214     0.200
     0.233     0.388     0.200
     0.243    -0.553     0.200
     0.292     0.080     0.200
     0.299    -0.292     0.200
     0.334     0.592     0.200
     0.360    -0.402     0.200
     0.416     0.178     0.200
     0.427    -0.049     0.200
     0.533     0.162     0.200
     0.887    -0.011     0.200
     0.919    -0.697     0.200
     0.920    -0.333     0.200
     0.946     0.258     0.200
     0.956     0.346     0.200
     0.993     0.782     0.200
     0.316     0.007     0.200
     0.421     0.107     0.200
     0.613     0.574     0.200
     0.628     0.705     0.200
     0.642     0.689     0.200
     0.668     0.920     0.200
     0.686     1.362     0.200
     0.764     1.031     0.200
     0.968    -0.409     0.200
     0.808    -0.040     0.200
     0.827     0.346     0.200
     0.844     0.051     0.200
     0.855     0.324     0.200
     0.865     0.129     0.200
     0.875    -0.004     0.200
     0.892     0.355     0.200
     0.932     0.229     0.200
     0.887    -0.671     0.200
     0.885    -1.798     0.200
     0.917    -1.682     0.200
     0.829    -0.631     0.200
     0.829     0.000     0.200
     0.625    -1.290     0.200
     0.340     0.114     0.200
     0.721     0.337     0.200
     0.735     0.433     0.200
     0.737     0.684     0.200
     0.871    -0.990     0.200
     0.930     0.541     0.200
     0.167    -0.592     0.200
     0.691    -0.266     0.200
     0.691    -0.615     0.200
     0.628    -0.442     0.200
     0.496     0.532     0.200
     0.895    -0.516     0.200
     0.959     0.894     0.200
     0.959     0.745     0.200
     0.966    -0.079     0.200
     0.105     0.381     0.200
     0.628     0.368     0.200
     0.798     0.551     0.200
     0.806     0.844     0.200
     0.829     0.838     0.200
     0.905    -0.749     0.200
     0.905    -0.914     0.200
     0.562     0.225     0.200
     0.615     1.191     0.200
     0.608    -0.222     0.200
     0.668     0.805     0.200
     0.762     0.612     0.200
     0.762     0.874     0.200
     0.827     0.037     0.200
     0.881    -0.183     0.200
     0.985     1.583     0.200
     0.337     0.365     0.200
     0.439     0.311     0.200
     0.520     0.763     0.200
     0.590    -0.263     0.200
     0.687    -0.231     0.200
     0.696     0.495     0.200
     0.748    -0.016     0.200
     0.769     0.109     0.200
     0.779     0.013     0.200
     0.825     0.292     0.200
     0.814     0.702     0.200
     0.832     0.775     0.200
     0.836     0.720     0.200
     0.847     0.873     0.200
     0.417     0.375     0.200
     0.462     0.489     0.200
     0.572     0.381     0.200
     0.700     0.096     0.200
     0.711    -0.048     0.200
     0.744    -0.241     0.200
     0.830     1.134     0.200
     0.824     1.237     0.200
     0.873     0.148     0.200
     0.889     0.162     0.200
     0.672    -0.734     0.200
     0.230    -0.202     0.200
     0.262     0.033     0.200
     0.283     0.046     0.200
     0.318     0.688     0.200
     0.359     0.798     0.200
     0.412    -0.119     0.200
     0.414     0.578     0.200
     0.553     0.229     0.200
     0.573    -0.077     0.200
     0.569     0.011     0.200
     0.924     0.607     0.200
     0.398     0.240     0.200
     0.602     0.199     0.200
     0.654     0.324     0.200
     0.810     0.272     0.200
     0.413    -0.030     0.200
     0.868     0.538     0.200
     0.441     0.018     0.200
     0.525     0.672     0.200
     0.624     0.922     0.200
     0.706     1.430     0.200
     0.841    -1.448     0.200
     0.822     0.892     0.200
     0.838     0.775     0.200
     0.848     0.743     0.200
     0.852     0.490     0.200
     0.869     1.147     0.200
     0.875     0.262     0.200
     0.936     0.212     0.200
     0.934     0.185     0.200
     0.362     0.021     0.200
     0.700    -0.241     0.200
     0.692     1.610     0.200
     0.692     1.438     0.200
     0.786    -0.126     0.200
     0.786     0.124     0.200
     0.802    -0.077     0.200
     0.802     0.400     0.200
     0.820    -0.306     0.200
     0.820    -0.072     0.200
     0.826     0.752     0.200
     0.835     0.093     0.200
     0.956     0.352     0.200
     0.147    -0.237     0.200
     0.549    -0.057     0.200
     0.890    -0.204     0.200
     0.931     0.232     0.200
     0.309    -0.168     0.200
     0.640     0.435     0.200
     0.749     1.751     0.200
     0.749     0.809     0.200
     0.744    -0.043     0.200
     0.778    -0.076     0.200
     0.778     0.057     0.200
     0.772    -0.751     0.200
     0.772    -0.302     0.200
     0.802     0.024     0.200
     0.851     1.353     0.200
     0.881     0.764     0.200
     0.874     0.576     0.200
     0.907     0.057     0.200
     0.610    -0.468     0.200
     0.610    -1.082     0.200
     0.641     0.279     0.200
     0.772     0.192     0.200
     0.720     0.583     0.200
     0.745    -1.007     0.200
     0.810     1.391     0.200
     0.795     0.068     0.200
     0.829    -0.317     0.200
     0.865    -0.216     0.200
     0.913    -0.512     0.200
     0.940    -0.326     0.200
     0.943    -0.188     0.200
     0.303     0.670     0.200
     0.370     1.149     0.200
     0.492     0.917     0.200
     0.571     1.076     0.200
     0.655     0.578     0.200
     0.653     1.414     0.200
     0.715     0.175     0.200
     0.736     1.198     0.200
     0.751     1.718     0.200
     0.816     0.117     0.200
     0.845     0.574     0.200
     0.893     0.450     0.200
     0.934     1.081     0.200
     0.940     0.472     0.200
     0.423    -0.764     0.200
     0.491     0.141     0.200
     0.540     0.161     0.200
     0.644     0.406     0.200
     0.726     0.948     0.200
     0.796     0.503     0.200
     0.812     0.759     0.200
     0.856    -0.469     0.200
     0.823     0.737     0.200
     0.831     0.770     0.200
     0.835     0.671     0.200
     0.845     1.157     0.200
     0.965     0.034     0.200
     0.069    -0.024     0.200
     0.112     0.121     0.200
     0.168    -0.595     0.200
     0.163    -0.012     0.200
     0.172    -0.429     0.200
     0.241     0.071     0.200
     0.267    -0.584     0.200
     0.285     0.413     0.200
     0.345     0.385     0.200
     0.361    -0.790     0.200
     0.361    -0.524     0.200
     0.798    -0.734     0.200
     0.877    -0.495     0.200
     0.952    -0.195     0.200
     0.951     0.235     0.200
     0.460     0.076     0.200
     0.470     1.112     0.200
     0.582     0.500     0.200
     0.681     0.547     0.200
     0.809    -1.150     0.200
     0.763     0.911     0.200
     0.824     0.386     0.200
     0.833     0.854     0.200
     0.849     0.790     0.200
     0.860     0.690     0.200
     0.863     0.719     0.200
     0.932     0.076     0.200
     0.557     0.005     0.200
     0.767    -0.604     0.200
     0.820    -0.292     0.200
     0.828     0.086     0.200
     0.909    -0.043     0.200
     0.909     0.195     0.200
     0.932    -0.263     0.200
     0.932    -0.093     0.200
     0.951    -0.348     0.200
     0.935     0.027     0.200
     0.995    -0.171     0.200
     0.155     0.121     0.200
     0.293     0.143     0.200
     0.361     0.337     0.200
     0.465    -0.274     0.200
     0.494    -0.476     0.200
     0.628    -0.318     0.200
     0.702    -0.315     0.200
     0.770     0.325     0.200
     0.767     0.582     0.200
     0.784     0.634     0.200
     0.817     0.766     0.200
     0.874     0.048     0.200
     0.881    -0.034     0.200
     0.964    -0.760     0.200
     0.293     0.412     0.200
     0.423     0.159     0.200
     0.471    -0.822     0.200
     0.514    -0.289     0.200
     0.652     0.184     0.200
     0.706    -0.173     0.200
     0.712     0.293     0.200
     0.749     0.220     0.200
     0.774     0.184     0.200
     0.764    -0.662     0.200
     0.836    -0.044     0.200
     0.607    -0.096     0.200
     0.696     0.551     0.200
     0.706     0.067     0.200
     0.843     0.761     0.200
     0.959    -0.169     0.200
     0.384    -0.247     0.200
     0.384     0.241     0.200
     0.766    -0.689     0.200
     0.697    -0.161     0.200
     0.736     0.164     0.200
     0.769     0.236     0.200
     0.880     0.063     0.200
     0.925     0.089     0.200
     0.935     0.570     0.200
     0.984     0.286     0.200
     0.994    -0.967     0.200
     0.207    -0.454     0.200
     0.429    -0.456     0.200
     0.489    -0.109     0.200
     0.499     0.155     0.200
     0.634    -0.403     0.200
     0.740     1.109     0.200
     0.918    -0.161     0.200
     0.916     0.530     0.200
     0.942     0.409     0.200
     0.972     0.354     0.200
     0.345     0.513     0.200
     0.389    -0.193     0.200
     0.401    -0.213     0.200
     0.455    -0.145     0.200
     0.526    -0.022     0.200
     0.543     0.743     0.200
     0.681    -0.141     0.200
     0.709     0.293     0.200
     0.738     0.316     0.200
     0.862     0.144     0.200
     0.907     0.146     0.200
     0.975    -0.336     0.200
     0.392    -0.236     0.200
     0.715    -0.328     0.200
     0.863    -0.075     0.200
     0.886    -0.546     0.200
     0.956    -0.650     0.200
     0.975    -0.824     0.200
     0.290     0.365     0.200
     0.370     0.396     0.200
     0.418     0.586     0.200
     0.451    -0.202     0.200
     0.532    -0.241     0.200
     0.613     0.073     0.200
     0.645     0.128     0.200
     0.666    -0.109     0.200
     0.689     0.001     0.200
     0.741     0.370     0.200
     0.834     1.012     0.200
     0.854     0.745     0.200
     0.852     0.794     0.200
     0.861     1.201     0.200
     0.862     0.924     0.200
     0.883     0.790     0.200
     0.380    -0.134     0.200
     0.666     0.749     0.200
     0.742     0.684     0.200
     0.758     0.696     0.200
     0.769     0.551     0.200
     0.900    -0.044     0.200
     0.899     0.787     0.200
     0.583     0.961     0.200
     0.639     0.411     0.200
     0.684    -0.517     0.200
     0.684     0.101     0.200
     0.688    -0.040     0.200
     0.679    -0.247     0.200
     0.707     0.215     0.200
     0.743    -0.738     0.200
     0.777     0.061     0.200
     0.810     0.800     0.200
     0.843     0.480     0.200
     0.870    -0.343     0.200
     0.181    -0.218     0.200
     0.264    -0.562     0.200
     0.278    -0.061     0.200
     0.279    -0.023     0.200
     0.363     0.603     0.200
     0.551     0.094     0.200
     0.950     0.170     0.200
     0.975     0.476     0.200
     0.113     0.152     0.200
     0.205     0.254     0.200
     0.203    -0.079     0.200
     0.277     0.183     0.200
     0.303    -0.113     0.200
     0.483     0.196     0.200
     0.921     0.163     0.200
     0.959     0.014     0.200
     0.389    -0.181     0.200
     0.412     0.071     0.200
     0.433    -0.047     0.200
     0.482     0.177     0.200
     0.481     0.097     0.200
     0.568     0.533     0.200
     0.753     0.456     0.200
     0.777     0.430     0.200
     0.906    -0.030     0.200
     0.931     0.137     0.200
     0.633    -0.143     0.200
     0.681    -0.274     0.200
     0.693     0.196     0.200
     0.694     0.200     0.200
     0.788     0.044     0.200
     0.809     0.066     0.200
     0.964     0.623     0.200
     0.215    -0.346     0.200
     0.233    -0.286     0.200
     0.247    -0.155     0.200
     0.299    -0.188     0.200
     0.334    -0.037     0.200
     0.713    -0.207     0.200
     0.751    -0.433     0.200
     0.769     0.281     0.200
     0.856     0.293     0.200
     0.986     0.696     0.200
     0.997     0.223     0.200
     0.593     0.235     0.200
     0.962    -1.040     0.200
     0.258     0.460     0.200
     0.956    -1.391     0.200
     0.151     0.169     0.200
     0.223     0.045     0.200
     0.323    -0.024     0.200
     0.402     0.117     0.200
     0.667     0.218     0.200
     0.679     0.783     0.200
     0.790    -0.412     0.200
     0.793     0.475     0.200
     0.930     0.462     0.200
     0.594    -0.235     0.200
     0.707     0.544     0.200
     0.712     0.366     0.200
     0.976     0.506     0.200
     0.328     0.318     0.200
     0.743    -0.875     0.200
     0.369     0.089     0.200
     0.357     0.544     0.200
     0.428    -0.201     0.200
     0.463     0.670     0.200
     0.857    -0.725     0.200
     0.914    -0.119     0.200
     0.293     0.164     0.200
     0.238     0.637     0.200
     0.434     0.072     0.200
     0.505     0.490     0.200
     0.605    -0.110     0.200
     0.618    -0.697     0.200
     0.676     0.760     0.200
     0.676     0.532     0.200
     0.685     0.804     0.200
     0.704     0.885     0.200
     0.768    -0.415     0.200
     0.758     0.639     0.200
     0.838    -0.327     0.200
     0.909     0.321     0.200
     0.993    -0.880     0.200
     0.431     0.633     0.200
     0.431     0.083     0.200
     0.406     0.202     0.200
     0.419    -0.455     0.200
     0.991    -0.544     0.200
     0.991    -0.663     0.200
     0.742    -0.882     0.200
     0.829    -0.128     0.200
     0.209     0.382     0.200
     0.777     1.179     0.200
     0.777     0.906     0.200
     0.766     1.395     0.200
     0.046    -0.326     0.200
     0.262     0.779     0.200
     0.325     0.444     0.200
     0.333    -0.231     0.200
     0.374     0.522     0.200
     0.441     0.301     0.200
     0.549    -0.095     0.200
     0.698     0.418     0.200
     0.710    -0.432     0.200
     0.885    -0.226     0.200
     0.301     0.135     0.200
     0.366     0.070     0.200
     0.586    -0.434     0.200
     0.966    -1.093     0.200
     0.966    -0.218     0.200
     0.968     0.045     0.200
     0.080    -0.582     0.200
     0.265     0.332     0.200
     0.301    -0.094     0.200
     0.327     0.173     0.200
     0.347     0.237     0.200
     0.776    -0.743     0.200
     0.499     0.748     0.200
     0.831     0.826     0.200
     0.452     0.665     0.200
     0.573     0.518     0.200
     0.575     0.455     0.200
     0.654     0.466     0.200
     0.692     0.891     0.200
     0.709     0.636     0.200
     0.717     0.567     0.200
     0.721     0.711     0.200
     0.728     1.029     0.200
     0.732     0.872     0.200
     0.737     0.012     0.200
     0.736     0.872     0.200
     0.796    -0.342     0.200
     0.924    -0.160     0.200
     0.938    -0.451     0.200
     0.987    -0.903     0.200
     0.987    -0.648     0.200
     0.171    -0.312     0.200
     0.207     0.496     0.200
     0.221    -0.220     0.200
     0.240     0.454     0.200
     0.224     0.188     0.200
     0.236     0.062     0.200
     0.347     0.211     0.200
     0.899    -0.869     0.200
     0.960    -0.146     0.200
     0.966    -0.543     0.200
     0.098     0.110     0.200
     0.111    -0.055     0.200
     0.151     0.425     0.200
     0.147     0.596     0.200
     0.178     0.630     0.200
     0.219     0.169     0.200
     0.327     0.153     0.200
     0.449    -0.048     0.200
     0.645     0.528     0.200
     0.709    -0.090     0.200
     0.826     0.194     0.200
     0.972     0.419     0.200
     0.711    -1.432     0.200
     0.960    -0.894     0.200
     0.961    -0.661     0.200
     0.393    -0.062     0.200
     0.965     0.045     0.200
     0.952    -0.284     0.200
     0.993    -0.725     0.200
     0.536     0.069     0.200
     0.582    -0.013     0.200
     0.643    -0.001     0.200
     0.787     1.461     0.200
     0.787     0.891     0.200
     0.204     0.244     0.200
     0.668     0.272     0.200
     0.668    -1.181     0.200
     0.980     1.020     0.200
     0.991     0.907     0.200
     0.999     0.979     0.200
     0.663    -0.869     0.200
     0.662     0.328     0.200
     0.473     1.660     0.200
     0.473     0.207     0.200
     0.473    -0.105     0.200
     0.629     0.458     0.200
     0.956    -0.100     0.200
     0.983    -0.194     0.200
     0.040    -0.267     0.200
     0.155    -0.015     0.200
     0.155    -0.209     0.200
     0.176     0.046     0.200
     0.882    -0.749     0.200
     0.987    -0.103     0.200
     0.955     0.244     0.200
     0.153    -0.511     0.200
     0.573     0.606     0.200
     0.762     0.813     0.200
     0.772     1.018     0.200
     0.776     0.960     0.200
     0.793     0.468     0.200
     0.806     0.637     0.200
     0.825     0.716     0.200
     0.910    -0.734     0.200
     0.643     0.147     0.200
     0.718     0.505     0.200
     0.855     0.808     0.200
     0.888     0.908     0.200
     0.919     0.670     0.200
     0.958    -0.224     0.200
     0.961     0.376     0.200
     0.673     0.020     0.200
     0.750     0.337     0.200
     0.857    -0.447     0.200
     0.883     0.495     0.200
     0.912     0.045     0.200
     0.932     0.817     0.200
     0.957     0.707     0.200
     0.998     0.004     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.126
 1.00   -0.126
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.007
 1.00   -0.007
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.2
 1.00    0.2
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00    0.2
 1.00    0.2
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =  -0.1 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.0 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.2 (dashed red line)
     0.050    -9.500   Sn = green circles; average =   0.2 (dashed green line)
EOF
gmt end
