#!/bin/bash
gmt begin kodiak1.21_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic kodiak1.21'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.477
   135.500     1.560
   136.000     1.645
   136.500     1.734
   137.000     1.826
   137.500     1.921
   138.000     2.019
   138.500     2.121
   139.000     2.226
   139.500     2.336
   140.000     2.449
   140.500     2.566
   141.000     2.688
   141.500     2.813
   142.000     2.944
   142.500     3.079
   143.000     3.220
   143.500     3.365
   144.000     3.517
   144.500     3.673
   145.000     3.836
   145.500     4.005
   146.000     4.180
   146.500     4.362
   147.000     4.552
   147.500     4.748
   148.000     4.951
   148.500     5.163
   149.000     5.383
   149.500     5.612
   150.000     5.851
   150.500     6.100
   151.000     6.359
   151.500     6.628
   152.000     6.907
   152.500     7.197
   153.000     7.496
   153.500     7.807
   154.000     8.127
   154.500     8.459
   155.000     8.802
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.572
   145.500     0.406
   146.000     1.440
   146.500     2.516
   147.000     3.625
   147.500     4.764
   148.000     5.929
   148.500     7.118
   149.000     8.332
   149.500     9.568
   150.000    10.826
   150.500    12.104
   151.000    13.404
   151.500    14.723
   152.000    16.060
   152.500    17.416
   153.000    18.790
   153.500    20.181
   154.000    21.590
   154.500    23.016
   155.000    24.460
   155.500    25.920
   156.000    27.397
   156.500    28.891
   157.000    30.401
   157.500    31.928
   158.000    33.472
   158.500    35.032
   159.000    36.609
   159.500    38.202
   160.000    39.811
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.592
   145.500     0.158
   146.000     0.843
   146.500     1.478
   147.000     2.071
   147.500     2.626
   148.000     3.146
   148.500     3.634
   149.000     4.097
   149.500     4.541
   150.000     4.969
   150.500     5.384
   151.000     5.789
   151.500     6.185
   152.000     6.572
   152.500     6.953
   153.000     7.327
   153.500     7.698
   154.000     8.066
   154.500     8.432
   155.000     8.796
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   146.801     0.492     0.200
   147.183    -0.405     0.200
   147.394     0.328     0.200
   146.957    -0.358     0.200
   144.918    -0.419     0.200
   146.702     0.038     0.200
   135.623    -0.234     0.200
   136.411    -6.801     0.200
   139.172    -7.387     0.200
   139.589     0.353     0.200
   142.074    -6.127     0.200
   143.263    -2.235     0.200
   143.689    -2.883     0.200
   147.938    -5.226     0.200
   148.035    -0.988     0.200
   149.888    -4.377     0.200
   136.360    -0.723     0.200
   142.894    -4.202     0.200
   144.444    -2.024     0.200
   147.120    -4.988     0.200
   148.481    -0.237     0.200
   148.859    -0.850     0.200
   136.616    -6.032     0.200
   138.213    -3.979     0.200
   139.780    -4.146     0.200
   139.780     0.155     0.200
   141.567    -5.071     0.200
   148.384    -3.806     0.200
   137.083    -1.927     0.200
   142.749    -5.208     0.200
   144.138    -1.751     0.200
   135.735    -0.370     0.200
   136.348    -3.111     0.200
   137.745    -0.694     0.200
   138.702    -7.453     0.200
   142.008    -5.433     0.200
   142.729    -4.714     0.200
   143.775    -2.956     0.200
   147.600    -0.585     0.200
   147.985    -5.420     0.200
   150.958    -1.059     0.200
   146.322    -0.762     0.200
   155.453    -7.886     0.200
   146.353    -1.021     0.200
   143.398    -3.904     0.200
   144.195    -2.301     0.200
   148.962    -1.431     0.200
   149.055    -1.481     0.200
   149.408    -4.048     0.200
   149.728     0.441     0.200
   150.561     1.934     0.200
   137.723     0.014     0.200
   141.719    -8.948     0.200
   148.284    -4.944     0.200
   148.458    -0.729     0.200
   149.876    -0.507     0.200
   150.655    -0.225     0.200
   154.359    -0.685     0.200
   147.286    -1.214     0.200
   143.617    -3.780     0.200
   150.519    -1.718     0.200
   151.048     1.093     0.200
   147.136     0.305     0.200
   147.726    -0.064     0.200
   148.044     1.020     0.200
   147.167    -1.264     0.200
   137.101    -3.778     0.200
   142.097    -7.366     0.200
   147.215    -4.525     0.200
   147.652    -0.479     0.200
   148.320    -7.949     0.200
   151.234    -0.902     0.200
   151.234    -1.064     0.200
   154.756     0.455     0.200
   159.743    -4.571     0.200
   147.233    -2.044     0.200
   147.633    -2.080     0.200
   148.299    -4.436     0.200
   151.216    -0.657     0.200
   147.645     0.755     0.200
   147.870    -4.840     0.200
   148.515     1.103     0.200
   146.813     0.409     0.200
   147.995    -1.356     0.200
   159.626    -5.888     0.200
   147.133     0.023     0.200
   146.806    -0.131     0.200
   138.564    -3.059     0.200
   150.280    -0.699     0.200
   146.784    -2.374     0.200
   159.720    -1.371     0.200
   142.044    -2.546     0.200
   146.332    -0.427     0.200
   159.462    -1.286     0.200
   148.221     1.152     0.200
   150.138    -0.856     0.200
   147.194     0.318     0.200
   138.815    -0.265     0.200
   146.326    -0.555     0.200
   146.326    -1.102     0.200
   146.253    -0.832     0.200
   146.253    -1.586     0.200
   146.754    -0.823     0.200
   148.059    -0.016     0.200
   147.134     0.466     0.200
   146.618    -0.428     0.200
   146.317    -1.039     0.200
   146.317    -2.281     0.200
   147.511    -0.256     0.200
   136.977    -0.747     0.200
   143.149    -4.711     0.200
   143.438    -3.539     0.200
   148.410     0.056     0.200
   136.767    -2.352     0.200
   137.088    -0.571     0.200
   137.503     0.043     0.200
   138.487    -1.667     0.200
   146.428    -0.099     0.200
   150.078    -0.442     0.200
   153.625     0.311     0.200
   147.850     0.793     0.200
   150.500    -1.656     0.200
   138.472    -2.301     0.200
   139.359    -1.735     0.200
   139.359    -2.684     0.200
   143.570    -2.890     0.200
   146.185    -0.886     0.200
   146.596    -0.537     0.200
   159.508    -5.938     0.200
   159.655    -0.102     0.200
   147.623     1.000     0.200
   146.047    -0.178     0.200
   146.419     0.420     0.200
   146.603     0.220     0.200
   138.541    -2.640     0.200
   146.191    -1.345     0.200
   146.891    -0.124     0.200
   146.771    -0.641     0.200
   150.701     1.571     0.200
   137.321    -2.463     0.200
   137.737     0.261     0.200
   138.223    -3.752     0.200
   140.747    -6.478     0.200
   146.084    -1.392     0.200
   150.141    -0.860     0.200
   150.141    -1.614     0.200
   153.636    -1.333     0.200
   148.156     1.139     0.200
   147.774     1.074     0.200
   148.073     0.742     0.200
   147.365     0.340     0.200
   147.367     0.399     0.200
   146.090    -1.276     0.200
   145.990    -0.635     0.200
   146.617     0.058     0.200
   147.333     0.264     0.200
   146.115    -0.594     0.200
   146.079    -0.575     0.200
   147.065     0.425     0.200
   148.422     0.650     0.200
   144.753    -1.256     0.200
   145.923    -1.906     0.200
   146.305    -0.515     0.200
   146.305    -0.808     0.200
   146.154    -0.395     0.200
   142.734    -4.079     0.200
   144.191    -1.956     0.200
   144.484    -1.566     0.200
   144.520    -1.257     0.200
   148.150     1.242     0.200
   150.262    -0.151     0.200
   152.552     0.976     0.200
   144.042    -2.212     0.200
   146.160    -0.766     0.200
   146.871    -0.353     0.200
   148.140     0.935     0.200
   147.395     0.134     0.200
   145.949    -0.205     0.200
   145.949    -1.650     0.200
   136.375    -2.406     0.200
   146.064    -1.967     0.200
   145.991    -1.557     0.200
   145.991    -1.880     0.200
   147.192     0.435     0.200
   145.879    -1.137     0.200
   159.076    -3.952     0.200
   146.074    -0.788     0.200
   144.892    -0.801     0.200
   144.966    -0.511     0.200
   147.115    -0.091     0.200
   144.925    -1.105     0.200
   146.064    -2.143     0.200
   146.064    -2.317     0.200
   145.647    -1.266     0.200
   145.708    -1.820     0.200
   146.449    -1.640     0.200
   148.763    -1.865     0.200
   149.542    -2.047     0.200
   150.283    -2.318     0.200
   159.779    -2.992     0.200
   147.621    -2.270     0.200
   147.450     0.642     0.200
   137.021    -0.908     0.200
   141.727    -0.935     0.200
   142.117    -7.451     0.200
   143.966    -2.239     0.200
   144.165    -1.676     0.200
   144.850    -0.794     0.200
   144.995    -0.456     0.200
   144.995    -0.308     0.200
   146.299    -0.410     0.200
   146.925     0.356     0.200
   146.925     0.114     0.200
   151.490    -0.723     0.200
   144.536    -1.161     0.200
   145.727    -0.291     0.200
   146.781     1.034     0.200
   146.263    -0.191     0.200
   147.788     0.333     0.200
   147.735    -0.299     0.200
   147.057     0.529     0.200
   147.057    -0.068     0.200
   147.771    -0.127     0.200
   151.358    -0.778     0.200
   147.564     0.800     0.200
   147.564     0.366     0.200
   147.138    -0.297     0.200
   149.900    -0.298     0.200
   147.014    -0.721     0.200
   147.014    -0.535     0.200
   147.542    -0.786     0.200
   147.531     0.231     0.200
   147.531     0.485     0.200
   145.905     0.751     0.200
   147.282     0.318     0.200
   147.282     0.482     0.200
   148.195     0.175     0.200
   147.377     0.466     0.200
   148.029     0.982     0.200
   148.029     0.876     0.200
   142.980    -3.523     0.200
   144.680    -0.605     0.200
   147.926     1.087     0.200
   147.770     0.882     0.200
   147.776     0.528     0.200
   147.059     0.390     0.200
   146.706    -0.292     0.200
   148.437     0.692     0.200
   147.693    -0.144     0.200
   145.883    -1.250     0.200
   159.391     3.755     0.200
   145.896    -1.269     0.200
   145.932    -2.115     0.200
   148.242     0.610     0.200
   147.926     1.063     0.200
   146.730    -0.182     0.200
   146.673    -0.014     0.200
   147.032    -0.156     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   149.833     2.277     0.200
   148.035     2.313     0.200
   148.035     2.415     0.200
   148.859     2.650     0.200
   152.274     5.344     0.200
   147.163     2.211     0.200
   148.384     2.194     0.200
   149.383     3.278     0.200
   150.201     4.282     0.200
   148.330     2.848     0.200
   147.600     2.115     0.200
   147.917     2.493     0.200
   145.269    -1.066     0.200
   149.275     3.260     0.200
   152.205     4.626     0.200
   153.448     5.908     0.200
   145.243    -1.229     0.200
   149.244     3.904     0.200
   146.621     0.536     0.200
   149.355     2.037     0.200
   150.140     3.790     0.200
   148.110     1.962     0.200
   146.949     1.477     0.200
   147.735     3.386     0.200
   147.848     1.699     0.200
   151.644     5.185     0.200
   149.862     2.641     0.200
   148.083     2.280     0.200
   151.308     5.021     0.200
   150.343     4.114     0.200
   150.166     3.980     0.200
   147.685     1.429     0.200
   151.282     4.843     0.200
   151.080     4.966     0.200
   147.215     1.020     0.200
   147.652     2.611     0.200
   147.233     1.056     0.200
   147.633     2.222     0.200
   151.216     5.143     0.200
   151.216     5.532     0.200
   147.219     1.213     0.200
   150.799     5.007     0.200
   147.835     1.723     0.200
   147.116     0.940     0.200
   147.251     2.326     0.200
   147.608     1.186     0.200
   150.840     4.613     0.200
   149.931     3.719     0.200
   150.221     2.562     0.200
   146.816     0.740     0.200
   146.718     1.129     0.200
   148.044     1.364     0.200
   147.096     1.503     0.200
   147.735     2.519     0.200
   147.735     2.144     0.200
   146.996     0.902     0.200
   146.636     0.931     0.200
   148.134     1.649     0.200
   150.199     3.971     0.200
   150.199     3.452     0.200
   150.397     3.411     0.200
   148.483     3.034     0.200
   148.483     2.596     0.200
   152.056     5.466     0.200
   152.056     4.997     0.200
   146.571     1.467     0.200
   148.221     1.508     0.200
   150.138     4.246     0.200
   147.636     2.403     0.200
   151.221     4.874     0.200
   149.983     3.601     0.200
   148.480     2.992     0.200
   152.050     5.604     0.200
   152.050     5.729     0.200
   146.340     0.836     0.200
   148.487     1.571     0.200
   149.919     3.946     0.200
   151.650     3.955     0.200
   151.006     5.254     0.200
   151.003     3.961     0.200
   150.254     4.098     0.200
   150.250     4.230     0.200
   147.877     1.395     0.200
   150.521     4.322     0.200
   150.439     4.498     0.200
   146.618     0.367     0.200
   151.770     5.296     0.200
   151.770     5.540     0.200
   148.506     2.696     0.200
   152.083     5.235     0.200
   152.083     4.876     0.200
   150.902     3.588     0.200
   146.526     1.477     0.200
   148.302     1.994     0.200
   148.302     1.869     0.200
   150.106     4.207     0.200
   148.058     2.431     0.200
   148.058     2.781     0.200
   148.058     2.941     0.200
   151.641     5.070     0.200
   151.641     5.410     0.200
   149.986     3.125     0.200
   145.018    -0.713     0.200
   146.495     0.534     0.200
   148.336     2.070     0.200
   148.336     1.921     0.200
   150.078     4.888     0.200
   150.078     4.408     0.200
   150.078     4.697     0.200
   152.712     6.541     0.200
   149.844     2.430     0.200
   150.500     4.547     0.200
   148.230     3.301     0.200
   148.230     2.701     0.200
   151.818     5.538     0.200
   151.818     4.858     0.200
   146.614     1.209     0.200
   150.397     3.332     0.200
   147.623     1.289     0.200
   150.793     4.586     0.200
   147.987     1.360     0.200
   151.576     4.454     0.200
   147.322     2.697     0.200
   147.508     1.216     0.200
   150.905     4.978     0.200
   146.603     0.532     0.200
   151.812     5.512     0.200
   151.812     4.918     0.200
   150.047     3.725     0.200
   148.704     1.892     0.200
   149.673     3.577     0.200
   152.204     5.458     0.200
   152.205     6.165     0.200
   151.521     5.238     0.200
   151.157     4.896     0.200
   151.084     4.636     0.200
   144.969    -1.909     0.200
   151.604     5.314     0.200
   151.574     5.422     0.200
   150.840     4.380     0.200
   148.266     1.839     0.200
   150.141     4.561     0.200
   154.799     7.763     0.200
   150.233     3.935     0.200
   150.340     3.429     0.200
   151.026     4.423     0.200
   146.603     0.634     0.200
   152.324     5.583     0.200
   151.798     5.894     0.200
   152.284     6.286     0.200
   148.090     1.690     0.200
   151.344     4.706     0.200
   149.977     2.709     0.200
   150.739     2.807     0.200
   152.110     5.682     0.200
   148.160     2.148     0.200
   148.160     1.956     0.200
   150.237     3.910     0.200
   148.358     1.775     0.200
   150.055     3.508     0.200
   149.963     3.281     0.200
   145.026    -0.862     0.200
   146.179     0.358     0.200
   147.474     1.218     0.200
   148.150     1.802     0.200
   150.262     4.198     0.200
   148.401     1.883     0.200
   150.013     3.982     0.200
   152.254     5.736     0.200
   150.182     3.591     0.200
   152.453     6.315     0.200
   147.635     2.378     0.200
   152.338     5.172     0.200
   147.702     2.848     0.200
   152.409     6.196     0.200
   145.879    -0.094     0.200
   146.339     0.902     0.200
   146.518     1.383     0.200
   147.154     2.143     0.200
   147.694     2.615     0.200
   148.258     3.014     0.200
   148.796     3.970     0.200
   150.883     5.298     0.200
   145.307    -2.472     0.200
   146.449     1.141     0.200
   148.222     2.847     0.200
   148.763     3.325     0.200
   149.542     4.033     0.200
   150.865     3.568     0.200
   146.058    -0.053     0.200
   146.058     0.411     0.200
   150.960     4.770     0.200
   147.902     3.297     0.200
   147.902     3.136     0.200
   148.329     3.459     0.200
   151.370     3.553     0.200
   151.490     5.477     0.200
   152.749     6.354     0.200
   146.976     0.879     0.200
   151.439     5.194     0.200
   148.050     1.771     0.200
   148.050     2.007     0.200
   150.364     4.891     0.200
   150.364     4.476     0.200
   151.584     5.734     0.200
   152.229     4.568     0.200
   147.872     2.261     0.200
   151.358     5.374     0.200
   151.358     5.562     0.200
   151.470     3.341     0.200
   150.848     4.686     0.200
   148.403     1.879     0.200
   149.976     3.957     0.200
   147.915     1.243     0.200
   150.490     4.246     0.200
   148.032     1.915     0.200
   148.032     2.407     0.200
   148.350     3.357     0.200
   148.057     1.655     0.200
   148.057     1.874     0.200
   150.357     4.290     0.200
   146.392     1.447     0.200
   146.904     2.066     0.200
   147.696     2.955     0.200
   150.489     3.975     0.200
   150.489     5.147     0.200
   147.061     1.130     0.200
   147.061     0.841     0.200
   151.353     4.250     0.200
   151.353     3.851     0.200
   151.334     3.599     0.200
   146.599     1.059     0.200
   146.362     0.496     0.200
   148.390     2.663     0.200
   151.710     4.868     0.200
   146.744     0.474     0.200
   149.967     3.320     0.200
   146.678     1.124     0.200
   150.689     3.452     0.200
   152.528     6.022     0.200
   152.516     6.145     0.200
   152.479     5.941     0.200
   150.408     4.756     0.200
   147.927     1.777     0.200
   150.470     4.768     0.200
   148.076     1.404     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   148.035     7.012     0.200
   161.118    41.458     0.200
   149.355     9.037     0.200
   150.343    10.964     0.200
   161.499    42.822     0.200
   161.902    43.344     0.200
   161.389    42.009     0.200
   160.410    38.683     0.200
   160.401    39.423     0.200
   160.248    39.461     0.200
   162.068    43.929     0.200
   168.058    64.378     0.200
   160.736    39.024     0.200
   160.306    40.234     0.200
   161.375    43.057     0.200
   159.720    35.832     0.200
   160.357    38.715     0.200
   160.528    38.629     0.200
   162.101    45.282     0.200
   155.451    25.117     0.200
   150.138    10.843     0.200
   147.636     5.363     0.200
   161.605    43.396     0.200
   160.254    37.547     0.200
   161.301    39.881     0.200
   161.458    42.143     0.200
   162.398    45.453     0.200
   162.398    45.214     0.200
   150.254    11.173     0.200
   161.092    41.345     0.200
   161.265    41.886     0.200
   160.077    36.536     0.200
   160.077    35.935     0.200
   160.447    37.259     0.200
   160.447    37.071     0.200
   159.397    35.289     0.200
   160.117    37.643     0.200
   161.057    40.281     0.200
   146.495     1.929     0.200
   150.078    10.808     0.200
   153.625    19.984     0.200
   153.625    21.090     0.200
   160.738    39.839     0.200
   161.546    42.501     0.200
   162.456    45.772     0.200
   161.487    41.285     0.200
   161.385    41.331     0.200
   145.373    -0.172     0.200
   159.508    35.834     0.200
   159.655    36.223     0.200
   160.191    37.883     0.200
   160.314    38.135     0.200
   161.128    41.038     0.200
   161.128    40.212     0.200
   164.906    53.274     0.200
   160.000    37.317     0.200
   160.670    40.638     0.200
   160.667    38.216     0.200
   160.808    39.915     0.200
   161.691    43.031     0.200
   159.829    37.776     0.200
   161.513    43.550     0.200
   161.990    43.930     0.200
   160.628    39.057     0.200
   161.744    42.208     0.200
   160.106    37.523     0.200
   161.793    43.647     0.200
   162.873    47.188     0.200
   160.486    39.186     0.200
   161.140    41.421     0.200
   161.294    41.324     0.200
   161.386    42.313     0.200
   162.223    45.192     0.200
   162.223    45.035     0.200
   163.351    49.369     0.200
   166.244    57.114     0.200
   166.413    59.532     0.200
   160.163    37.469     0.200
   160.971    40.151     0.200
   161.597    41.278     0.200
   161.922    44.909     0.200
   161.922    43.347     0.200
   163.073    47.841     0.200
   161.268    40.984     0.200
   151.344    14.054     0.200
   162.245    43.696     0.200
   152.110    15.756     0.200
   159.175    33.677     0.200
   160.795    39.010     0.200
   160.795    39.693     0.200
   145.053    -0.649     0.200
   160.682    40.042     0.200
   162.558    46.828     0.200
   162.718    46.973     0.200
   159.616    35.691     0.200
   160.242    38.464     0.200
   160.242    37.477     0.200
   145.647     0.124     0.200
   160.297    38.844     0.200
   160.297    38.460     0.200
   159.868    36.251     0.200
   160.675    39.121     0.200
   162.658    46.198     0.200
   145.697     0.653     0.200
   146.255     1.492     0.200
   146.255     1.172     0.200
   159.782    36.900     0.200
   159.902    37.479     0.200
   160.461    38.810     0.200
   161.415    42.501     0.200
   161.415    42.649     0.200
   162.445    45.941     0.200
   165.113    55.158     0.200
   160.038    37.204     0.200
   161.505    42.258     0.200
   162.426    46.637     0.200
   162.426    46.430     0.200
   145.259     0.096     0.200
   145.878     0.928     0.200
   162.188    44.521     0.200
   162.188    44.896     0.200
   161.337    42.417     0.200
   162.125    44.312     0.200
   159.492    35.258     0.200
   161.130    41.022     0.200
   161.130    40.438     0.200
   160.219    37.857     0.200
   160.267    36.574     0.200
   161.803    44.540     0.200
   161.599    42.746     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   138.333     1.721     0.200
   135.623     5.664     0.200
   136.826     2.999     0.200
   139.989     1.196     0.200
   147.672     4.292     0.200
   151.268     6.242     0.200
   151.791     8.294     0.200
   151.234     5.765     0.200
   146.816     7.540     0.200
   141.778     2.296     0.200
   137.503     1.543     0.200
   138.487     3.033     0.200
   153.625     7.658     0.200
   153.625     9.039     0.200
   151.095     5.683     0.200
   151.095     6.003     0.200
   151.992     6.581     0.200
   153.636     7.917     0.200
   150.641     5.558     0.200
   148.269     4.822     0.200
   152.521     7.131     0.200
   147.380     4.813     0.200
   151.490     5.902     0.200
   147.788     4.208     0.200
   148.483     4.351     0.200
   151.712     6.310     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
