#!/bin/bash
gmt begin kodiak1.21_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P kodiak1.21'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.561
    79.000     8.397
    80.000     7.318
    81.000     6.324
    82.000     5.416
    83.000     4.592
    84.000     3.852
    85.000     3.200
    86.000     2.632
    87.000     2.141
    88.000     1.761
    89.000     1.467
    90.000     1.213
    91.000     0.989
    92.000     0.791
    93.000     0.611
    94.000     0.447
    95.000     0.305
    96.000     0.188
    97.000     0.098
    98.000     0.036
    99.000     0.004
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    18.748    -1.633     0.200
    19.140    -1.929     0.200
    19.625    -2.233     0.200
    19.959     2.118     0.200
    21.817    -0.964     0.200
    22.524    -2.503     0.200
    26.073     0.862     0.200
    26.882     0.660     0.200
    27.464    -1.768     0.200
    28.471    -0.757     0.200
    28.858     1.600     0.200
    29.755    -0.155     0.200
    29.955     2.266     0.200
    31.240     0.822     0.200
    32.004     2.005     0.200
    32.135     2.753     0.200
    33.806    -1.754     0.200
    34.500    -2.774     0.200
    34.267     1.445     0.200
    35.272     1.566     0.200
    37.078     2.812     0.200
    37.224     1.879     0.200
    38.101    -1.543     0.200
    38.744    -1.950     0.200
    39.541    -1.616     0.200
    39.402     0.546     0.200
    40.300     1.075     0.200
    41.663    -1.147     0.200
    41.588     1.461     0.200
    47.587    -1.436     0.200
    47.815    -0.203     0.200
    47.666    -2.043     0.200
    48.041     0.051     0.200
    48.439    -0.528     0.200
    49.984    -0.047     0.200
    50.330    -0.770     0.200
    53.563    -2.562     0.200
    53.597    -1.010     0.200
    55.342    -1.894     0.200
    55.955    -0.901     0.200
    59.263    -0.789     0.200
    62.647    -2.182     0.200
    62.811    -1.274     0.200
    63.169     0.845     0.200
    63.678    -1.023     0.200
    65.095    -0.301     0.200
    71.507    -1.467     0.200
    72.191    -0.575     0.200
    72.754     0.068     0.200
    73.512    -0.415     0.200
    74.071    -0.586     0.200
    74.213    -0.622     0.200
    74.623     0.096     0.200
    76.042    -0.062     0.200
    78.155    -0.935     0.200
    80.747    -0.057     0.200
    81.638    -1.793     0.200
    84.690    -0.557     0.200
    92.750     1.024     0.200
    18.813    -0.414     0.200
    18.907    -0.448     0.200
    19.315    -0.926     0.200
    20.340     1.893     0.200
    20.782     2.000     0.200
    21.529     2.643     0.200
    21.520     2.140     0.200
    21.740     0.781     0.200
    22.151    -0.617     0.200
    23.905     1.051     0.200
    24.390     0.920     0.200
    25.553     1.937     0.200
    26.131     1.102     0.200
    26.228     0.728     0.200
    26.462     2.005     0.200
    26.899     2.171     0.200
    27.110    -0.735     0.200
    27.180     1.842     0.200
    27.241     2.692     0.200
    27.948     1.656     0.200
    28.421    -0.460     0.200
    28.904     2.047     0.200
    28.968     2.483     0.200
    29.602    -0.947     0.200
    29.380     3.123     0.200
    29.438     0.506     0.200
    30.117     1.992     0.200
    31.289     1.648     0.200
    31.629     2.151     0.200
    32.170     3.395     0.200
    32.263     2.479     0.200
    33.426    -0.591     0.200
    34.204    -2.356     0.200
    35.385     2.238     0.200
    37.201     1.917     0.200
    37.299     2.089     0.200
    37.879    -2.824     0.200
    38.005     0.110     0.200
    39.158    -1.576     0.200
    40.280     0.081     0.200
    40.579     0.606     0.200
    41.169    -2.257     0.200
    42.216    -0.334     0.200
    42.860     0.532     0.200
    44.010     1.352     0.200
    44.280    -0.516     0.200
    44.849    -0.055     0.200
    46.717    -2.818     0.200
    47.192    -0.527     0.200
    47.364    -0.870     0.200
    47.493     0.130     0.200
    47.984     0.317     0.200
    48.042    -0.530     0.200
    48.534     0.066     0.200
    48.313    -0.427     0.200
    49.563     0.081     0.200
    49.974    -1.948     0.200
    50.279    -0.061     0.200
    51.637    -0.478     0.200
    52.792    -1.062     0.200
    53.181    -1.934     0.200
    54.615    -1.423     0.200
    54.958    -1.012     0.200
    55.573    -1.242     0.200
    58.881    -1.330     0.200
    58.976    -2.187     0.200
    62.266    -1.825     0.200
    62.349    -0.487     0.200
    62.792    -0.346     0.200
    63.213    -0.140     0.200
    63.330    -0.917     0.200
    63.238    -0.309     0.200
    64.554    -1.972     0.200
    64.722    -0.072     0.200
    67.034    -1.961     0.200
    70.581    -0.160     0.200
    70.919    -1.117     0.200
    71.125    -0.365     0.200
    71.496    -0.807     0.200
    71.901    -1.048     0.200
    71.736    -1.056     0.200
    71.785    -1.048     0.200
    72.371    -0.360     0.200
    73.061     0.039     0.200
    72.991     0.453     0.200
    72.994    -0.063     0.200
    73.130    -0.368     0.200
    74.044     0.257     0.200
    74.239     0.115     0.200
    74.392    -1.474     0.200
    75.664    -0.117     0.200
    75.973    -0.884     0.200
    76.012    -2.104     0.200
    76.279    -0.623     0.200
    76.535    -0.678     0.200
    77.851    -0.466     0.200
    77.965    -1.098     0.200
    78.136    -0.446     0.200
    78.698    -1.152     0.200
    80.382    -1.318     0.200
    81.275    -1.095     0.200
    81.896    -2.377     0.200
    81.963    -0.328     0.200
    81.927     4.460     0.200
    82.384     0.066     0.200
    84.555    -2.099     0.200
    91.063    -1.400     0.200
    18.962    -2.242     0.200
    19.224    -0.113     0.200
    20.200     1.235     0.200
    20.469     1.312     0.200
    20.937     1.244     0.200
    21.620    -0.105     0.200
    21.815     0.806     0.200
    21.984    -0.004     0.200
    24.021     1.392     0.200
    24.539     1.461     0.200
    25.738     1.669     0.200
    26.257     0.068     0.200
    26.415     0.548     0.200
    26.972    -0.577     0.200
    27.024     1.851     0.200
    27.349     2.535     0.200
    27.435     1.757     0.200
    28.142     2.241     0.200
    29.418    -0.403     0.200
    29.136     1.899     0.200
    29.616     1.745     0.200
    30.190     1.062     0.200
    31.429     1.327     0.200
    31.773     1.804     0.200
    32.362     1.635     0.200
    32.439     2.453     0.200
    33.243    -0.078     0.200
    33.976    -1.459     0.200
    34.431     1.596     0.200
    35.555     1.901     0.200
    36.430     1.413     0.200
    37.670    -2.125     0.200
    37.375     2.072     0.200
    37.451     1.723     0.200
    38.965    -1.029     0.200
    39.489     1.595     0.200
    40.138    -0.798     0.200
    40.337    -0.451     0.200
    40.378     0.308     0.200
    41.047    -2.311     0.200
    41.067    -0.480     0.200
    40.888     0.994     0.200
    42.332    -0.634     0.200
    42.956     0.198     0.200
    44.239    -0.233     0.200
    44.230    -0.165     0.200
    45.020     0.533     0.200
    46.219    -0.951     0.200
    46.505    -2.200     0.200
    47.328    -0.636     0.200
    47.342    -0.739     0.200
    47.473    -1.763     0.200
    48.069    -0.381     0.200
    48.096    -0.390     0.200
    48.357    -0.104     0.200
    49.855    -1.080     0.200
    49.627     0.460     0.200
    50.267    -0.205     0.200
    50.367    -0.161     0.200
    50.591     0.344     0.200
    51.713    -0.078     0.200
    52.906    -0.736     0.200
    52.782    -0.018     0.200
    52.971    -1.615     0.200
    53.003    -1.258     0.200
    54.754    -1.955     0.200
    55.124    -1.130     0.200
    55.363    -1.058     0.200
    58.527    -1.379     0.200
    58.671    -1.179     0.200
    58.772    -1.988     0.200
    62.054    -2.416     0.200
    62.159    -0.520     0.200
    62.221    -1.033     0.200
    62.593    -1.322     0.200
    63.100    -1.396     0.200
    63.236    -0.001     0.200
    63.388    -0.804     0.200
    64.326    -0.485     0.200
    64.555    -0.479     0.200
    64.562    -0.027     0.200
    66.133    -1.504     0.200
    66.815    -1.564     0.200
    70.400    -0.440     0.200
    70.729    -0.946     0.200
    70.937    -2.211     0.200
    71.329    -0.691     0.200
    71.675    -0.673     0.200
    72.087    -0.151     0.200
    72.178     0.003     0.200
    72.152    -0.837     0.200
    72.500    -0.616     0.200
    72.833     0.404     0.200
    72.810    -0.458     0.200
    72.910    -1.051     0.200
    72.939    -0.024     0.200
    73.192    -1.722     0.200
    73.521    -0.461     0.200
    73.665    -0.405     0.200
    74.036    -0.681     0.200
    74.196    -0.917     0.200
    75.486     0.921     0.200
    75.744    -0.553     0.200
    76.087    -1.514     0.200
    76.345    -0.978     0.200
    77.021     0.902     0.200
    77.622    -1.167     0.200
    77.748    -0.866     0.200
    78.468    -0.863     0.200
    78.226    -0.922     0.200
    78.674     1.003     0.200
    79.305     0.547     0.200
    80.156    -2.072     0.200
    81.000     0.400     0.200
    81.048    -0.857     0.200
    81.612     1.153     0.200
    81.665     0.871     0.200
    81.797    -1.824     0.200
    81.751     0.520     0.200
    81.777     2.281     0.200
    82.156     0.288     0.200
    83.277    -0.536     0.200
    84.796    -0.581     0.200
    84.731     0.049     0.200
    85.079     1.298     0.200
    86.827    -0.852     0.200
    90.832    -1.284     0.200
    93.031    -0.457     0.200
    19.336    -1.545     0.200
    19.728    -0.835     0.200
    20.664     0.983     0.200
    21.062     1.283     0.200
    21.881     1.877     0.200
    22.125     0.269     0.200
    22.487     0.420     0.200
    24.246     1.064     0.200
    24.680     1.902     0.200
    25.767     1.630     0.200
    26.458     1.072     0.200
    26.435     1.883     0.200
    26.651     1.929     0.200
    27.227     0.846     0.200
    27.485    -0.470     0.200
    27.427     2.054     0.200
    28.117    -1.118     0.200
    28.135     2.023     0.200
    29.085     2.069     0.200
    29.393    -1.469     0.200
    29.219     2.278     0.200
    30.314     1.485     0.200
    31.928     2.151     0.200
    32.364     1.328     0.200
    33.360    -0.389     0.200
    33.733    -0.631     0.200
    35.633     2.940     0.200
    37.440     1.921     0.200
    37.753    -3.124     0.200
    38.864    -1.481     0.200
    39.441    -1.308     0.200
    39.735     0.241     0.200
    39.983    -0.820     0.200
    40.648    -0.323     0.200
    40.632     0.308     0.200
    40.967     0.043     0.200
    41.936     1.092     0.200
    43.224    -0.376     0.200
    43.294    -0.341     0.200
    44.709    -0.305     0.200
    46.604    -2.290     0.200
    47.793    -1.563     0.200
    47.899    -2.384     0.200
    48.359    -0.942     0.200
    49.640    -1.767     0.200
    50.651    -0.532     0.200
    53.411    -1.187     0.200
    55.208    -1.673     0.200
    55.805    -1.166     0.200
    58.999    -1.201     0.200
    59.229    -1.794     0.200
    62.668    -1.268     0.200
    63.425     0.104     0.200
    63.433     0.052     0.200
    63.376     0.425     0.200
    63.526     0.432     0.200
    65.057    -0.500     0.200
    66.603    -1.367     0.200
    67.224    -0.517     0.200
    69.259    -1.276     0.200
    70.890    -0.586     0.200
    71.207    -0.209     0.200
    71.378    -0.246     0.200
    71.418    -1.486     0.200
    71.725    -0.336     0.200
    71.832    -0.980     0.200
    71.875    -1.240     0.200
    72.072    -1.117     0.200
    72.123    -1.026     0.200
    72.563    -0.354     0.200
    72.654     0.004     0.200
    72.962    -0.725     0.200
    73.047     0.772     0.200
    73.297     0.294     0.200
    73.361    -1.080     0.200
    73.417    -0.111     0.200
    73.865    -0.444     0.200
    74.018    -0.044     0.200
    74.163    -0.389     0.200
    74.361    -0.939     0.200
    74.492     0.296     0.200
    74.666     0.284     0.200
    75.980    -0.270     0.200
    76.565    -0.591     0.200
    76.824    -2.057     0.200
    77.440    -1.515     0.200
    77.515     0.665     0.200
    77.849    -0.801     0.200
    78.505    -0.436     0.200
    80.525     1.566     0.200
    80.656    -0.137     0.200
    81.410    -1.151     0.200
    81.906     0.229     0.200
    81.961     0.941     0.200
    82.187    -0.246     0.200
    82.288     0.223     0.200
    82.516     1.030     0.200
    84.328    -1.293     0.200
    85.408     1.273     0.200
    87.049    -1.819     0.200
    91.145    -1.124     0.200
    92.564     0.112     0.200
    18.867    -0.003     0.200
    19.031     0.199     0.200
    20.870     1.181     0.200
    21.404     1.430     0.200
    21.566    -0.306     0.200
    21.946     0.629     0.200
    22.076     1.240     0.200
    24.389     1.502     0.200
    24.991     1.715     0.200
    26.276     1.072     0.200
    26.637     0.812     0.200
    26.650     0.398     0.200
    27.214     0.923     0.200
    27.871    -2.262     0.200
    27.709     1.883     0.200
    27.996     2.024     0.200
    28.702     1.843     0.200
    29.635     2.164     0.200
    30.718     2.088     0.200
    31.858     1.250     0.200
    32.210     1.364     0.200
    32.582     1.599     0.200
    32.776    -0.602     0.200
    32.915     1.184     0.200
    32.875     3.539     0.200
    32.957     2.519     0.200
    33.552     2.628     0.200
    34.838     1.680     0.200
    36.057     2.009     0.200
    37.077    -3.682     0.200
    37.886     1.669     0.200
    37.910     1.763     0.200
    38.191    -0.107     0.200
    38.467    -0.425     0.200
    39.828     0.204     0.200
    40.477    -1.176     0.200
    42.138     1.188     0.200
    43.269    -0.986     0.200
    43.404    -1.081     0.200
    45.904    -4.018     0.200
    46.915    -0.953     0.200
    47.333    -0.212     0.200
    48.350    -0.089     0.200
    48.528     0.944     0.200
    49.489    -3.020     0.200
    48.968     0.367     0.200
    50.405     0.227     0.200
    52.417    -1.633     0.200
    52.443     0.178     0.200
    54.218    -1.462     0.200
    54.555    -1.513     0.200
    54.811    -1.171     0.200
    58.020    -1.526     0.200
    58.116    -1.292     0.200
    58.239    -1.560     0.200
    61.675    -0.943     0.200
    61.669    -0.295     0.200
    62.071    -1.203     0.200
    62.437    -1.454     0.200
    63.815    -1.090     0.200
    63.836    -0.727     0.200
    64.130     0.336     0.200
    70.234    -0.569     0.200
    70.449    -1.684     0.200
    70.756    -0.555     0.200
    71.044    -1.304     0.200
    70.908    -0.277     0.200
    71.146    -0.420     0.200
    71.201    -0.152     0.200
    71.678    -0.133     0.200
    72.337    -0.078     0.200
    72.444     0.084     0.200
    72.928    -0.397     0.200
    73.079    -0.183     0.200
    73.225    -0.247     0.200
    73.503     0.014     0.200
    74.914    -3.209     0.200
    76.566     1.448     0.200
    76.989    -2.036     0.200
    79.674     0.122     0.200
    81.033    -0.184     0.200
    83.858    -2.921     0.200
    84.277    -2.254     0.200
    86.194    -0.634     0.200
    90.203    -1.238     0.200
    19.483     1.603     0.200
    19.855    -1.459     0.200
    20.221    -0.445     0.200
    21.079     1.262     0.200
    21.428     1.502     0.200
    22.336     0.793     0.200
    22.605    -0.070     0.200
    22.879    -0.971     0.200
    23.229     2.343     0.200
    24.678     0.549     0.200
    25.056     0.305     0.200
    26.056     1.641     0.200
    26.716     0.277     0.200
    26.875     1.039     0.200
    26.911     0.717     0.200
    27.926    -0.585     0.200
    27.673     2.681     0.200
    27.683     2.593     0.200
    27.762     1.880     0.200
    29.551     1.974     0.200
    30.676     1.418     0.200
    31.984     1.396     0.200
    32.314     1.608     0.200
    32.361     3.194     0.200
    32.628     0.851     0.200
    32.807     2.286     0.200
    34.151    -3.429     0.200
    34.087    -0.871     0.200
    35.021     2.049     0.200
    35.628     0.830     0.200
    35.959     1.987     0.200
    37.578    -0.798     0.200
    37.756     1.496     0.200
    39.363    -0.805     0.200
    41.079     0.971     0.200
    42.346     0.600     0.200
    42.987     0.398     0.200
    43.732    -0.114     0.200
    45.226    -0.554     0.200
    46.443    -2.163     0.200
    47.900    -1.528     0.200
    48.312    -1.712     0.200
    48.827    -0.672     0.200
    49.220    -0.689     0.200
    49.884    -0.645     0.200
    49.966    -0.268     0.200
    50.444    -0.092     0.200
    50.618    -0.811     0.200
    51.115    -0.052     0.200
    51.750    -0.802     0.200
    52.496    -0.356     0.200
    53.669    -1.097     0.200
    55.489    -1.512     0.200
    56.064    -1.232     0.200
    59.314    -1.392     0.200
    60.137    -0.857     0.200
    62.741    -1.458     0.200
    62.936    -0.759     0.200
    62.970    -0.088     0.200
    63.355    -1.236     0.200
    63.747     0.373     0.200
    65.113    -1.068     0.200
    65.444    -1.212     0.200
    66.914    -1.444     0.200
    67.429    -0.916     0.200
    69.643    -0.742     0.200
    71.244    -0.220     0.200
    71.534    -0.675     0.200
    71.817    -0.980     0.200
    71.752    -0.590     0.200
    71.745    -0.543     0.200
    72.059    -0.433     0.200
    72.222    -0.704     0.200
    72.460    -0.826     0.200
    72.515    -0.754     0.200
    73.004     0.942     0.200
    72.975    -0.390     0.200
    73.645    -0.840     0.200
    73.744     0.080     0.200
    74.242    -0.733     0.200
    74.392    -0.407     0.200
    74.539    -0.558     0.200
    74.776     0.566     0.200
    75.739     0.523     0.200
    75.969    -1.288     0.200
    76.344     0.579     0.200
    76.890    -0.509     0.200
    77.836    -1.806     0.200
    77.879     0.756     0.200
    80.812    -0.048     0.200
    81.373    -0.032     0.200
    81.546    -0.945     0.200
    81.954    -0.101     0.200
    82.011     0.603     0.200
    84.030    -1.849     0.200
    84.930    -1.403     0.200
    87.014    -0.715     0.200
    91.217    -1.521     0.200
    19.090     0.455     0.200
    19.649     1.743     0.200
    20.903     2.024     0.200
    21.111     1.573     0.200
    21.635     1.948     0.200
    21.666    -0.382     0.200
    22.193     0.285     0.200
    22.324     0.888     0.200
    22.433     2.036     0.200
    23.282     2.059     0.200
    24.633     1.223     0.200
    25.225     0.842     0.200
    26.726     1.760     0.200
    27.019    -0.376     0.200
    27.166     1.298     0.200
    27.631    -1.864     0.200
    27.657     1.299     0.200
    28.197     2.083     0.200
    28.903     1.802     0.200
    28.952     2.060     0.200
    29.862     2.095     0.200
    29.858     2.230     0.200
    30.335     2.918     0.200
    30.353     1.956     0.200
    30.887     1.442     0.200
    30.952     1.667     0.200
    32.446     2.134     0.200
    32.849    -0.499     0.200
    33.214    -2.187     0.200
    33.175     2.660     0.200
    33.971     2.228     0.200
    35.079     1.645     0.200
    36.279     2.544     0.200
    36.873     1.284     0.200
    36.970     0.957     0.200
    37.935    -2.714     0.200
    38.105     1.851     0.200
    38.143     1.338     0.200
    38.521    -0.644     0.200
    40.299     0.329     0.200
    40.458    -0.792     0.200
    40.840     0.057     0.200
    41.053    -0.694     0.200
    41.056    -0.720     0.200
    41.558     1.159     0.200
    42.380     0.446     0.200
    42.726     1.237     0.200
    42.726     0.636     0.200
    42.855    -2.411     0.200
    42.940     0.898     0.200
    43.516    -0.755     0.200
    43.853     0.533     0.200
    44.033    -2.907     0.200
    44.389    -0.366     0.200
    44.678    -1.067     0.200
    45.082     1.020     0.200
    45.202    -1.239     0.200
    45.439     0.888     0.200
    45.770     0.265     0.200
    45.770     0.366     0.200
    45.729    -2.407     0.200
    45.889     2.430     0.200
    45.889     2.328     0.200
    46.366    -3.532     0.200
    46.565    -0.985     0.200
    47.015    -0.508     0.200
    47.217    -1.081     0.200
    47.225     1.853     0.200
    47.692    -2.773     0.200
    47.533    -0.738     0.200
    47.775     0.584     0.200
    48.170    -0.974     0.200
    48.170    -1.474     0.200
    48.599     0.222     0.200
    48.715     0.327     0.200
    49.244    -1.429     0.200
    50.099    -0.039     0.200
    50.444     0.149     0.200
    50.586     1.278     0.200
    50.609     1.904     0.200
    50.774    -2.540     0.200
    50.905    -0.323     0.200
    51.793    -1.972     0.200
    51.912    -0.663     0.200
    52.057     4.359     0.200
    52.057     4.058     0.200
    52.402    -0.808     0.200
    52.432    -1.726     0.200
    52.452    -1.172     0.200
    53.035     0.817     0.200
    53.626    -2.529     0.200
    54.246    -1.453     0.200
    54.556    -1.313     0.200
    54.549     3.743     0.200
    54.826    -1.169     0.200
    55.247     0.792     0.200
    55.247     0.690     0.200
    55.717    -0.689     0.200
    56.558    -0.693     0.200
    57.125    -1.717     0.200
    57.134     3.023     0.200
    57.800    -1.472     0.200
    58.129    -0.478     0.200
    58.270    -1.660     0.200
    60.258    -0.515     0.200
    60.460    -0.994     0.200
    60.555    -0.937     0.200
    61.696    -1.277     0.200
    61.726    -0.378     0.200
    61.993    -1.276     0.200
    62.110    -1.255     0.200
    62.356    -1.704     0.200
    62.403    -1.018     0.200
    62.444    -1.297     0.200
    62.808    -1.721     0.200
    63.565    -2.740     0.200
    63.918    -0.069     0.200
    64.277    -3.428     0.200
    64.224    -0.677     0.200
    64.231    -0.427     0.200
    65.899    -0.957     0.200
    65.901    -0.571     0.200
    66.043     0.119     0.200
    66.264    -1.300     0.200
    66.217    -1.002     0.200
    66.789    -1.653     0.200
    66.952     1.610     0.200
    67.894     0.651     0.200
    68.420    -0.950     0.200
    70.005    -0.767     0.200
    70.005    -0.170     0.200
    70.273    -1.411     0.200
    70.289    -0.513     0.200
    70.511     0.831     0.200
    70.816     0.079     0.200
    70.878     2.202     0.200
    71.003    -0.958     0.200
    71.186     0.033     0.200
    71.240    -1.095     0.200
    71.297    -0.441     0.200
    71.640     0.294     0.200
    71.730    -0.351     0.200
    72.072    -0.302     0.200
    72.012     0.056     0.200
    72.077     0.772     0.200
    72.393    -1.223     0.200
    72.405    -0.090     0.200
    72.416     0.442     0.200
    72.848     1.474     0.200
    73.122    -0.547     0.200
    73.015    -0.313     0.200
    73.163    -0.489     0.200
    73.310    -0.660     0.200
    73.388    -0.117     0.200
    73.491    -0.524     0.200
    73.532     0.032     0.200
    73.600    -0.163     0.200
    73.731    -1.134     0.200
    74.669    -2.102     0.200
    74.993    -1.474     0.200
    75.061    -0.871     0.200
    75.109    -0.447     0.200
    75.252    -0.968     0.200
    75.541     0.476     0.200
    75.645    -0.621     0.200
    75.687    -1.460     0.200
    75.690    -0.281     0.200
    75.862    -0.463     0.200
    75.909    -0.732     0.200
    76.186    -1.306     0.200
    76.022    -0.377     0.200
    76.445    -1.777     0.200
    76.383     2.575     0.200
    76.592     0.089     0.200
    76.622    -1.079     0.200
    76.644     0.697     0.200
    76.866    -0.155     0.200
    76.965     2.288     0.200
    77.163    -0.828     0.200
    77.274    -0.551     0.200
    77.715    -0.913     0.200
    77.864     1.260     0.200
    77.913    -0.017     0.200
    78.188     0.158     0.200
    78.169    -0.438     0.200
    78.287     0.913     0.200
    78.823     0.957     0.200
    78.841     0.357     0.200
    79.582     1.309     0.200
    79.504     0.235     0.200
    79.556    -2.047     0.200
    79.636    -0.485     0.200
    79.822    -0.594     0.200
    80.289     0.986     0.200
    80.221     3.354     0.200
    80.387    -1.542     0.200
    80.445     3.149     0.200
    80.748    -0.477     0.200
    80.891    -0.240     0.200
    80.945     1.470     0.200
    81.045    -1.666     0.200
    81.053     0.896     0.200
    81.180    -0.981     0.200
    81.201    -0.692     0.200
    81.494     0.557     0.200
    81.574     0.134     0.200
    82.495    -0.701     0.200
    83.064    -0.155     0.200
    82.999    -1.518     0.200
    83.520    -2.005     0.200
    83.892    -0.412     0.200
    84.126    -0.106     0.200
    84.121    -1.078     0.200
    84.222    -1.489     0.200
    84.385     0.579     0.200
    84.648     0.251     0.200
    84.681     1.285     0.200
    85.239     3.284     0.200
    86.069    -0.640     0.200
    87.119     2.518     0.200
    88.153    -1.936     0.200
    90.125    -0.498     0.200
    90.236    -0.212     0.200
    90.939    -2.983     0.200
    91.637    -0.221     0.200
    92.314     0.147     0.200
    92.781     0.490     0.200
    92.874    -0.436     0.200
    93.577    -0.177     0.200
    93.408     3.604     0.200
    94.625    -1.489     0.200
    14.194     9.251     0.200
    19.337     0.968     0.200
    19.420     0.060     0.200
    19.742    -0.457     0.200
    20.555     1.690     0.200
    20.884     2.131     0.200
    21.299     2.058     0.200
    22.080     1.280     0.200
    22.305    -0.111     0.200
    22.400    -1.128     0.200
    22.838     1.222     0.200
    24.914     1.239     0.200
    26.018     2.217     0.200
    26.687     1.479     0.200
    27.438    -1.481     0.200
    27.443    -0.527     0.200
    27.445     0.956     0.200
    27.681     2.139     0.200
    27.690     0.261     0.200
    28.389     2.126     0.200
    28.465     2.343     0.200
    28.801     2.356     0.200
    29.141    -0.663     0.200
    29.463     2.278     0.200
    29.685     1.413     0.200
    29.820     3.115     0.200
    29.917     2.460     0.200
    30.551     1.756     0.200
    30.640     1.273     0.200
    31.822     0.956     0.200
    32.159     1.799     0.200
    32.617     2.676     0.200
    32.744     2.766     0.200
    32.906     3.052     0.200
    32.988     1.935     0.200
    33.621    -1.088     0.200
    33.579     3.273     0.200
    33.944    -1.899     0.200
    35.878     2.411     0.200
    36.080     1.081     0.200
    36.177    -2.147     0.200
    37.496    -1.377     0.200
    37.687     1.507     0.200
    37.817     1.406     0.200
    38.136    -2.780     0.200
    38.888    -1.101     0.200
    39.312    -0.858     0.200
    39.464    -0.923     0.200
    39.752    -0.316     0.200
    40.834     0.514     0.200
    40.936     0.481     0.200
    41.282     0.032     0.200
    41.277     1.074     0.200
    42.157     0.972     0.200
    42.769     0.391     0.200
    42.888    -2.079     0.200
    43.596    -0.298     0.200
    44.778    -0.268     0.200
    46.091     0.327     0.200
    46.347    -1.692     0.200
    46.525     0.916     0.200
    46.749    -0.843     0.200
    47.749    -0.531     0.200
    47.738    -1.450     0.200
    47.882    -0.666     0.200
    48.010    -1.661     0.200
    48.547    -0.602     0.200
    48.605    -0.044     0.200
    48.873    -0.312     0.200
    49.470    -0.780     0.200
    49.573    -0.662     0.200
    50.127    -0.675     0.200
    50.215    -0.748     0.200
    50.531    -1.234     0.200
    50.672    -0.498     0.200
    50.791     0.100     0.200
    51.122     0.216     0.200
    51.344    -0.652     0.200
    51.836    -1.230     0.200
    52.102    -0.312     0.200
    52.201    -0.451     0.200
    52.556    -0.482     0.200
    53.212    -1.227     0.200
    53.249    -1.500     0.200
    53.271    -0.762     0.200
    53.321    -1.729     0.200
    54.246    -1.504     0.200
    54.158     1.139     0.200
    55.057    -1.588     0.200
    55.644    -1.214     0.200
    56.125    -1.060     0.200
    58.947    -0.841     0.200
    59.079    -1.258     0.200
    61.252    -0.647     0.200
    62.141    -0.737     0.200
    62.511    -1.015     0.200
    62.914    -1.007     0.200
    63.265    -0.232     0.200
    63.610     0.481     0.200
    64.141     1.989     0.200
    64.293    -1.612     0.200
    64.967     0.589     0.200
    64.974    -1.062     0.200
    66.693     0.070     0.200
    67.041     0.252     0.200
    67.201     0.236     0.200
    69.167    -1.095     0.200
    69.399     0.463     0.200
    70.778    -0.495     0.200
    70.792    -1.082     0.200
    71.080    -0.828     0.200
    71.602     0.017     0.200
    71.643     1.767     0.200
    71.744    -0.540     0.200
    71.982    -0.973     0.200
    72.036    -0.491     0.200
    72.433     0.736     0.200
    72.509     0.084     0.200
    72.524     0.095     0.200
    72.801     0.844     0.200
    72.818    -0.258     0.200
    72.852     1.544     0.200
    72.850    -0.946     0.200
    73.182    -0.912     0.200
    73.207    -0.559     0.200
    73.189     0.345     0.200
    73.427     0.143     0.200
    73.290     0.350     0.200
    73.468    -0.102     0.200
    73.768    -0.763     0.200
    73.919    -0.249     0.200
    74.016    -0.316     0.200
    74.065     0.101     0.200
    74.203     0.392     0.200
    74.256     0.491     0.200
    74.397    -0.537     0.200
    74.530    -0.812     0.200
    74.610     0.227     0.200
    74.856    -2.200     0.200
    75.335     1.039     0.200
    75.742    -1.294     0.200
    75.831    -0.805     0.200
    75.879    -1.080     0.200
    76.029     2.066     0.200
    75.875     0.549     0.200
    76.071    -2.174     0.200
    76.451    -1.330     0.200
    76.699    -1.731     0.200
    77.124    -1.125     0.200
    77.276     0.021     0.200
    77.356    -0.430     0.200
    77.410     0.872     0.200
    77.605    -0.823     0.200
    77.779     2.205     0.200
    77.987    -0.947     0.200
    78.080     0.235     0.200
    78.460    -1.571     0.200
    78.459     0.434     0.200
    78.643     0.423     0.200
    78.906     0.178     0.200
    78.992    -0.499     0.200
    79.548     0.366     0.200
    79.590     0.838     0.200
    79.875    -0.311     0.200
    79.728    -0.513     0.200
    80.322    -0.725     0.200
    81.082     0.209     0.200
    81.203    -0.436     0.200
    81.588    -1.876     0.200
    81.571    -0.386     0.200
    81.732     0.767     0.200
    81.572     3.608     0.200
    81.776     0.534     0.200
    82.000    -0.646     0.200
    82.021    -1.755     0.200
    82.309     0.731     0.200
    82.736    -0.994     0.200
    82.964     0.321     0.200
    83.061    -0.176     0.200
    83.192    -1.857     0.200
    83.815    -1.058     0.200
    83.996    -0.983     0.200
    84.790    -1.713     0.200
    84.697    -0.836     0.200
    85.033    -3.129     0.200
    84.991    -0.018     0.200
    85.189    -0.011     0.200
    85.366    -0.194     0.200
    86.805    -1.501     0.200
    88.976    -0.374     0.200
    89.322    -0.497     0.200
    90.921    -0.755     0.200
    91.059    -0.099     0.200
    92.491    -0.728     0.200
    93.136    -0.203     0.200
    93.074     0.686     0.200
    95.284    -1.564     0.200
    98.060    -0.142     0.200
    17.439     4.857     0.200
    19.690    -0.810     0.200
    19.856    -1.621     0.200
    20.846     3.635     0.200
    21.657    -3.084     0.200
    22.289     0.170     0.200
    22.836    -0.620     0.200
    23.404    -0.568     0.200
    24.236     1.828     0.200
    25.792     0.880     0.200
    26.422     0.288     0.200
    26.948     1.251     0.200
    27.684     1.751     0.200
    28.361     0.805     0.200
    28.524     0.161     0.200
    28.828     0.758     0.200
    29.123     1.843     0.200
    30.089     1.780     0.200
    30.146     2.379     0.200
    30.501     1.638     0.200
    30.932     0.637     0.200
    31.062     2.194     0.200
    31.521     3.151     0.200
    31.555     0.456     0.200
    32.208    -1.387     0.200
    32.689    -1.600     0.200
    33.638     1.123     0.200
    34.309     2.293     0.200
    35.747    -1.091     0.200
    36.258     1.533     0.200
    36.449     3.900     0.200
    37.483     1.416     0.200
    38.287    -0.665     0.200
    38.262    -0.461     0.200
    38.241    -1.281     0.200
    38.858    -1.459     0.200
    39.309     0.170     0.200
    39.341     1.701     0.200
    39.899    -0.141     0.200
    41.211     1.021     0.200
    41.907     0.822     0.200
    42.747     3.481     0.200
    44.593    -1.363     0.200
    44.794    -0.463     0.200
    45.053    -0.029     0.200
    46.495    -1.410     0.200
    46.920     4.263     0.200
    47.349    -1.780     0.200
    47.992    -0.663     0.200
    48.299    -0.435     0.200
    48.413    -1.315     0.200
    49.688     0.422     0.200
    49.750     0.653     0.200
    50.003    -1.467     0.200
    50.226    -1.162     0.200
    50.809    -0.562     0.200
    51.585     0.618     0.200
    51.832     0.579     0.200
    53.857    -2.468     0.200
    56.348     1.853     0.200
    56.711    -2.731     0.200
    61.327     1.479     0.200
    61.595    -2.528     0.200
    62.554    -0.965     0.200
    62.927     0.555     0.200
    69.868    -0.848     0.200
    69.936     0.734     0.200
    70.024    -1.805     0.200
    70.571    -1.151     0.200
    71.447    -0.462     0.200
    72.232    -0.773     0.200
    73.041     0.715     0.200
    73.145    -1.597     0.200
    73.195    -0.591     0.200
    73.898     2.174     0.200
    74.954    -1.160     0.200
    75.552     0.403     0.200
    75.875    -1.444     0.200
    75.920     0.698     0.200
    75.951     0.124     0.200
    79.665    -1.541     0.200
    79.868    -1.642     0.200
    82.337    -0.374     0.200
    82.626     0.322     0.200
    83.031    -1.182     0.200
    84.773    -0.274     0.200
    85.071    -0.168     0.200
    92.217    -1.788     0.200
    18.732    -0.628     0.200
    20.782     0.321     0.200
    21.448    -1.865     0.200
    21.331     3.393     0.200
    21.964     0.814     0.200
    22.584     1.010     0.200
    22.729     0.473     0.200
    24.293     0.766     0.200
    24.662     0.808     0.200
    24.914     2.510     0.200
    26.225     1.523     0.200
    26.510    -0.948     0.200
    26.559     0.207     0.200
    27.192    -0.097     0.200
    27.323     0.730     0.200
    27.655     1.753     0.200
    27.767     1.751     0.200
    28.612     0.722     0.200
    28.659     2.304     0.200
    28.698     2.461     0.200
    28.943    -2.714     0.200
    29.067     0.078     0.200
    29.339    -1.236     0.200
    29.571     1.715     0.200
    30.079     1.516     0.200
    30.091     3.106     0.200
    30.582     1.471     0.200
    31.775     1.458     0.200
    32.128     1.956     0.200
    32.667    -1.571     0.200
    32.870     1.655     0.200
    33.334    -3.399     0.200
    33.675     1.634     0.200
    35.993     2.224     0.200
    37.104    -2.847     0.200
    37.028     1.900     0.200
    37.825     1.449     0.200
    37.834     1.770     0.200
    38.055    -0.893     0.200
    38.365    -1.503     0.200
    38.786    -1.038     0.200
    38.825     2.732     0.200
    39.726     0.105     0.200
    40.606     0.317     0.200
    41.238     1.608     0.200
    42.047     0.678     0.200
    42.771     0.093     0.200
    44.041    -0.150     0.200
    45.927    -3.153     0.200
    46.797     0.009     0.200
    48.240    -0.400     0.200
    48.671     0.682     0.200
    48.834     0.226     0.200
    50.077    -0.558     0.200
    51.607     1.221     0.200
    52.279    -1.785     0.200
    52.331    -2.166     0.200
    52.359     0.826     0.200
    54.126    -0.971     0.200
    54.474    -0.406     0.200
    57.046    -2.451     0.200
    58.030    -1.082     0.200
    58.146    -2.297     0.200
    60.304    -1.030     0.200
    61.565     0.007     0.200
    61.586    -1.437     0.200
    61.975    -0.156     0.200
    62.354     0.104     0.200
    63.684    -2.730     0.200
    63.604    -0.202     0.200
    72.190    -0.220     0.200
    72.531     0.743     0.200
    72.484     1.023     0.200
    72.965    -0.835     0.200
    73.111    -0.699     0.200
    73.410    -0.461     0.200
    76.974    -1.982     0.200
    78.410    -0.489     0.200
    80.998     0.970     0.200
    81.158    -1.882     0.200
    81.280    -2.035     0.200
    84.285    -2.136     0.200
    84.407    -0.757     0.200
    84.430     0.626     0.200
    19.270    -0.060     0.200
    20.097     1.315     0.200
    20.383     1.209     0.200
    20.836     1.601     0.200
    21.760     0.851     0.200
    22.079    -1.053     0.200
    22.084    -0.104     0.200
    22.336     1.607     0.200
    22.545     1.880     0.200
    23.942     0.775     0.200
    24.152     2.762     0.200
    24.399     0.701     0.200
    24.442     1.317     0.200
    25.620     1.898     0.200
    25.843     1.583     0.200
    26.173     1.195     0.200
    26.931    -0.250     0.200
    27.048    -1.302     0.200
    27.137     0.397     0.200
    27.313     1.724     0.200
    28.019     1.898     0.200
    28.079     2.165     0.200
    28.325     1.777     0.200
    28.430     2.539     0.200
    28.583     1.673     0.200
    29.028     2.627     0.200
    29.448    -0.706     0.200
    29.451     3.069     0.200
    30.089     1.620     0.200
    31.337     0.807     0.200
    31.679     2.000     0.200
    32.241     0.663     0.200
    32.327     2.607     0.200
    33.154     2.161     0.200
    33.348    -0.430     0.200
    34.116    -1.705     0.200
    34.343     1.822     0.200
    35.446     2.505     0.200
    37.263     1.783     0.200
    37.352     1.132     0.200
    37.800    -2.265     0.200
    38.405    -1.364     0.200
    38.928    -1.749     0.200
    39.077    -0.899     0.200
    40.231    -0.610     0.200
    40.308     0.456     0.200
    40.795     0.231     0.200
    41.199    -0.596     0.200
    41.656     1.352     0.200
    42.254     0.268     0.200
    42.771    -0.438     0.200
    43.280    -1.056     0.200
    43.514     0.456     0.200
    44.255    -0.398     0.200
    45.887     0.025     0.200
    46.198    -0.820     0.200
    46.637    -1.772     0.200
    47.188    -0.775     0.200
    47.346    -0.408     0.200
    47.464    -0.726     0.200
    48.009    -0.151     0.200
    48.481    -1.596     0.200
    48.457    -0.715     0.200
    49.159    -1.308     0.200
    49.811    -0.981     0.200
    49.935    -0.922     0.200
    50.059    -1.167     0.200
    49.980    -0.560     0.200
    52.216     0.839     0.200
    53.025    -0.849     0.200
    53.128    -0.811     0.200
    53.315    -1.186     0.200
    53.793     0.504     0.200
    54.406    -0.768     0.200
    54.873    -1.357     0.200
    55.250    -0.079     0.200
    55.486    -1.081     0.200
    55.607    -1.644     0.200
    56.831     2.614     0.200
    57.806    -1.570     0.200
    58.640    -1.601     0.200
    58.794    -1.077     0.200
    58.891    -1.449     0.200
    61.016    -1.340     0.200
    62.199    -1.619     0.200
    62.269     0.008     0.200
    62.342    -0.783     0.200
    62.709    -1.932     0.200
    63.125    -0.601     0.200
    63.239    -1.352     0.200
    63.139    -0.191     0.200
    64.657    -1.585     0.200
    65.807    -1.040     0.200
    70.504    -0.414     0.200
    70.702    -0.822     0.200
    70.839    -0.852     0.200
    70.985    -0.237     0.200
    71.352    -0.764     0.200
    71.424    -0.997     0.200
    71.664    -1.145     0.200
    71.713    -0.541     0.200
    72.249     0.145     0.200
    72.290    -0.598     0.200
    72.305    -1.085     0.200
    72.617    -0.447     0.200
    72.886     0.054     0.200
    72.973     0.541     0.200
    73.049     0.388     0.200
    73.099    -0.208     0.200
    73.269    -0.910     0.200
    73.465    -0.365     0.200
    73.620    -0.579     0.200
    73.761    -1.106     0.200
    73.763    -0.421     0.200
    74.155    -1.411     0.200
    75.884    -0.389     0.200
    77.043     1.045     0.200
    77.608     0.880     0.200
    78.049     0.426     0.200
    78.184    -0.125     0.200
    78.163    -0.709     0.200
    78.609    -0.671     0.200
    78.814     0.200     0.200
    78.679    -0.059     0.200
    79.031    -2.291     0.200
    79.222    -0.037     0.200
    79.736    -0.837     0.200
    80.415     0.495     0.200
    81.184    -0.616     0.200
    81.027    -2.681     0.200
    81.460    -1.079     0.200
    81.752     0.379     0.200
    81.805     0.098     0.200
    81.866    -0.722     0.200
    81.937    -1.495     0.200
    82.127    -0.591     0.200
    82.293    -0.460     0.200
    82.444    -0.852     0.200
    83.273    -0.653     0.200
    83.650    -0.494     0.200
    83.704     1.229     0.200
    83.672    -0.606     0.200
    84.155    -1.071     0.200
    84.490    -1.774     0.200
    84.492     0.221     0.200
    85.032    -1.404     0.200
    84.988     0.520     0.200
    85.217     1.569     0.200
    85.315     0.081     0.200
    86.476     0.030     0.200
    86.967    -0.669     0.200
    87.216    -1.282     0.200
    87.425    -0.293     0.200
    88.886     0.775     0.200
    92.613     0.433     0.200
    93.017    -0.428     0.200
    93.972    -1.827     0.200
    94.761    -1.246     0.200
    95.536    -1.490     0.200
    98.312    -1.048     0.200
    98.658    -1.699     0.200
    16.456     1.757     0.200
    16.719     0.890     0.200
    19.141    -0.986     0.200
    19.488    -0.071     0.200
    21.595     1.505     0.200
    21.794    -0.614     0.200
    22.109     2.237     0.200
    22.802     0.317     0.200
    23.402     0.859     0.200
    23.401     1.371     0.200
    23.544     1.161     0.200
    25.469     2.645     0.200
    25.498     0.781     0.200
    25.702     1.435     0.200
    26.934     2.025     0.200
    27.376     0.472     0.200
    28.077     0.618     0.200
    28.014    -0.826     0.200
    28.631     2.394     0.200
    29.337     1.926     0.200
    29.395     2.213     0.200
    29.729    -3.044     0.200
    29.901     1.634     0.200
    30.286     1.139     0.200
    30.323     1.709     0.200
    30.509     2.267     0.200
    30.769     3.075     0.200
    31.220     2.007     0.200
    32.057     1.952     0.200
    32.333     2.131     0.200
    32.901    -2.931     0.200
    32.926     1.850     0.200
    35.562     1.749     0.200
    36.493    -2.901     0.200
    38.099     0.515     0.200
    38.566     1.790     0.200
    38.990    -0.858     0.200
    42.087    -2.586     0.200
    42.886    -0.272     0.200
    43.425    -0.121     0.200
    43.999     3.274     0.200
    44.113    -0.533     0.200
    44.760    -0.695     0.200
    45.336    -2.564     0.200
    47.215    -2.296     0.200
    47.004    -0.657     0.200
    47.139    -0.208     0.200
    48.003    -1.402     0.200
    48.178    -1.153     0.200
    48.649    -0.970     0.200
    48.750     0.350     0.200
    48.759    -1.018     0.200
    48.901    -0.805     0.200
    49.078    -0.558     0.200
    49.509    -0.341     0.200
    51.427    -0.899     0.200
    51.970     0.054     0.200
    52.147    -1.058     0.200
    52.385    -1.525     0.200
    52.386    -1.129     0.200
    52.295     3.145     0.200
    53.204    -1.057     0.200
    54.225    -1.921     0.200
    54.485    -0.903     0.200
    54.781    -0.852     0.200
    54.968    -0.401     0.200
    55.067    -1.410     0.200
    55.438     0.021     0.200
    57.965    -0.688     0.200
    58.253    -1.499     0.200
    58.120     0.528     0.200
    58.908    -1.251     0.200
    59.417    -2.665     0.200
    60.611    -0.940     0.200
    60.708    -1.102     0.200
    61.607    -3.677     0.200
    61.661    -1.042     0.200
    61.764    -0.534     0.200
    62.108    -1.043     0.200
    62.193    -1.609     0.200
    62.382    -0.373     0.200
    63.194    -1.266     0.200
    63.316    -0.075     0.200
    63.399    -0.623     0.200
    63.795    -0.229     0.200
    64.342    -0.813     0.200
    64.397     0.026     0.200
    65.930     0.096     0.200
    66.198    -0.420     0.200
    66.802    -1.470     0.200
    70.070    -0.061     0.200
    70.322    -1.996     0.200
    70.585    -1.201     0.200
    70.592    -0.246     0.200
    70.829     0.415     0.200
    70.857     0.150     0.200
    71.115    -0.413     0.200
    71.350    -0.435     0.200
    71.412    -0.208     0.200
    71.665    -0.130     0.200
    71.758    -0.286     0.200
    71.725     0.210     0.200
    71.755     0.231     0.200
    71.763     0.385     0.200
    72.447     0.197     0.200
    72.482     0.589     0.200
    72.531     0.502     0.200
    72.592     0.036     0.200
    72.601    -0.115     0.200
    72.654    -0.632     0.200
    72.875    -0.538     0.200
    73.102    -0.482     0.200
    73.024     0.077     0.200
    73.027     0.060     0.200
    73.253     0.126     0.200
    73.279    -0.325     0.200
    73.263    -0.034     0.200
    73.240     0.205     0.200
    73.274    -0.096     0.200
    73.403     0.143     0.200
    73.514    -0.705     0.200
    73.548    -0.106     0.200
    73.590    -0.349     0.200
    73.569     0.170     0.200
    73.596    -1.189     0.200
    73.616    -1.304     0.200
    73.743    -1.248     0.200
    73.886     0.016     0.200
    73.958    -0.107     0.200
    74.184    -2.621     0.200
    74.191    -0.665     0.200
    74.358    -0.134     0.200
    74.700    -1.613     0.200
    75.195    -1.966     0.200
    75.474     0.238     0.200
    75.617     0.716     0.200
    75.674    -1.012     0.200
    75.805    -0.954     0.200
    75.774     0.620     0.200
    75.730     0.570     0.200
    75.944    -1.046     0.200
    76.081     0.472     0.200
    76.562    -0.250     0.200
    76.875    -1.015     0.200
    77.074    -0.130     0.200
    77.266    -0.208     0.200
    77.283     1.200     0.200
    77.418    -0.054     0.200
    77.344     0.556     0.200
    77.483     0.581     0.200
    77.600    -0.068     0.200
    77.793    -2.146     0.200
    78.603    -1.119     0.200
    78.985     1.287     0.200
    78.932    -0.426     0.200
    78.982     0.304     0.200
    78.994     0.834     0.200
    79.248    -0.651     0.200
    79.487     0.550     0.200
    80.138    -0.473     0.200
    80.219    -2.407     0.200
    80.017     1.682     0.200
    80.329     0.401     0.200
    80.586    -0.276     0.200
    80.620    -1.554     0.200
    80.413    -0.451     0.200
    80.659    -1.263     0.200
    80.712    -2.048     0.200
    80.703    -1.002     0.200
    80.884     0.533     0.200
    80.742     1.790     0.200
    81.076    -0.787     0.200
    80.882     3.046     0.200
    81.324    -1.301     0.200
    81.335     0.240     0.200
    81.530     1.612     0.200
    81.794    -1.779     0.200
    81.609     1.193     0.200
    81.870    -1.178     0.200
    82.047    -1.708     0.200
    82.379    -0.640     0.200
    82.425    -0.081     0.200
    82.610    -2.042     0.200
    82.672    -1.365     0.200
    82.732     0.324     0.200
    82.957    -0.843     0.200
    83.759    -0.462     0.200
    83.889    -0.425     0.200
    84.050     0.554     0.200
    84.124    -0.821     0.200
    84.179    -0.599     0.200
    84.198    -1.693     0.200
    84.510     0.228     0.200
    84.594    -3.199     0.200
    84.855    -0.008     0.200
    86.767    -0.966     0.200
    89.901    -0.823     0.200
    92.237    -0.659     0.200
    92.504    -0.892     0.200
    93.346    -0.573     0.200
    93.460    -1.299     0.200
    94.256    -0.459     0.200
    96.340     0.034     0.200
    97.355    -2.058     0.200
    97.834    -1.716     0.200
    15.973     5.977     0.200
    19.961     0.916     0.200
    20.023     0.348     0.200
    20.993     2.326     0.200
    22.614     0.664     0.200
    22.950     1.411     0.200
    23.222    -0.364     0.200
    23.722     1.257     0.200
    23.841     2.267     0.200
    25.208     1.806     0.200
    25.538     1.405     0.200
    25.851     1.473     0.200
    26.791     1.781     0.200
    27.695    -2.743     0.200
    27.571     2.065     0.200
    27.863    -2.442     0.200
    28.127     0.700     0.200
    28.239    -0.301     0.200
    28.211     1.946     0.200
    28.274     1.888     0.200
    28.897     2.448     0.200
    29.225    -2.763     0.200
    29.043     1.749     0.200
    29.380     1.761     0.200
    29.991     1.844     0.200
    30.511     1.246     0.200
    30.532     2.057     0.200
    30.554     0.165     0.200
    31.103     2.623     0.200
    32.139     1.212     0.200
    34.492    -2.517     0.200
    34.446    -0.815     0.200
    34.934     2.068     0.200
    37.571     1.321     0.200
    38.044    -2.675     0.200
    37.806     1.333     0.200
    38.152     0.417     0.200
    39.742    -2.105     0.200
    39.568     0.547     0.200
    41.723    -0.258     0.200
    42.047    -0.508     0.200
    43.157     0.772     0.200
    43.835    -1.294     0.200
    44.517     0.442     0.200
    44.898     0.597     0.200
    46.389    -2.094     0.200
    46.732    -2.189     0.200
    46.960    -2.170     0.200
    49.162    -1.301     0.200
    49.308    -1.717     0.200
    49.468    -0.236     0.200
    50.017    -0.419     0.200
    50.901     1.200     0.200
    51.598     0.067     0.200
    51.873    -0.884     0.200
    54.048    -1.040     0.200
    54.632    -1.591     0.200
    55.866    -1.387     0.200
    56.165    -2.030     0.200
    56.390    -0.636     0.200
    56.449    -0.855     0.200
    56.443    -0.815     0.200
    59.630    -0.354     0.200
    59.889    -1.438     0.200
    60.087    -2.490     0.200
    60.469    -1.106     0.200
    63.206    -1.230     0.200
    63.315    -0.854     0.200
    63.337    -0.501     0.200
    63.729    -0.791     0.200
    63.886    -1.026     0.200
    64.639    -1.963     0.200
    64.833    -2.231     0.200
    65.790    -0.034     0.200
    68.495    -0.607     0.200
    68.597    -0.246     0.200
    69.981     0.184     0.200
    71.902    -0.480     0.200
    72.137    -0.889     0.200
    72.416    -0.158     0.200
    72.425    -0.112     0.200
    73.342    -1.052     0.200
    73.344    -0.367     0.200
    73.632    -0.758     0.200
    74.111    -0.068     0.200
    74.392     0.099     0.200
    74.744    -0.248     0.200
    74.890     0.010     0.200
    75.039    -0.255     0.200
    75.152     0.394     0.200
    75.129    -0.171     0.200
    75.218     0.017     0.200
    75.321    -0.575     0.200
    75.348    -0.735     0.200
    75.348    -0.233     0.200
    75.349    -0.238     0.200
    75.429    -0.298     0.200
    75.562     0.239     0.200
    75.931    -0.770     0.200
    76.316    -2.264     0.200
    76.477     0.224     0.200
    76.806     0.069     0.200
    78.003     0.262     0.200
    78.502    -0.498     0.200
    79.028    -0.391     0.200
    79.184    -0.246     0.200
    81.193    -0.081     0.200
    81.769    -0.630     0.200
    81.924    -0.948     0.200
    82.137    -0.465     0.200
    82.472    -1.321     0.200
    82.463    -0.572     0.200
    82.513     0.068     0.200
    82.598    -0.474     0.200
    83.450    -0.690     0.200
    83.624     0.418     0.200
    85.240    -1.966     0.200
    86.062    -0.054     0.200
    86.726    -1.320     0.200
    16.145     2.562     0.200
    16.480     2.273     0.200
    21.008     0.957     0.200
    22.621     0.180     0.200
    22.965     1.045     0.200
    23.197    -0.011     0.200
    23.677     1.454     0.200
    24.352     1.790     0.200
    25.193     0.638     0.200
    25.232     1.577     0.200
    25.553     0.766     0.200
    25.875     1.248     0.200
    27.667    -2.100     0.200
    28.062     1.071     0.200
    28.129    -0.524     0.200
    28.218    -0.318     0.200
    28.299     1.762     0.200
    29.199    -2.041     0.200
    29.066     1.136     0.200
    29.401     1.964     0.200
    29.809     1.550     0.200
    30.002     0.838     0.200
    30.527     0.896     0.200
    30.552     1.779     0.200
    32.164     0.786     0.200
    34.419    -1.389     0.200
    34.460    -1.246     0.200
    34.937     1.629     0.200
    34.958     1.453     0.200
    37.594     1.621     0.200
    37.832    -2.090     0.200
    37.826     0.962     0.200
    38.155     0.182     0.200
    39.554     1.455     0.200
    40.505     0.755     0.200
    41.744     0.967     0.200
    42.015     0.147     0.200
    42.420     1.740     0.200
    42.931     0.598     0.200
    43.170    -0.243     0.200
    43.808    -1.385     0.200
    44.487     0.672     0.200
    44.407    -0.988     0.200
    45.404    -0.124     0.200
    46.361    -1.684     0.200
    46.703    -2.762     0.200
    46.927    -1.620     0.200
    54.018    -0.422     0.200
    54.602    -1.880     0.200
    55.836    -0.981     0.200
    56.419    -1.654     0.200
    56.412    -1.202     0.200
    59.600    -0.150     0.200
    59.860    -1.139     0.200
    60.054    -2.078     0.200
    60.437    -1.295     0.200
    62.263    -1.154     0.200
    63.177    -1.148     0.200
    63.284    -0.657     0.200
    63.309     0.081     0.200
    63.699    -1.901     0.200
    64.632    -0.928     0.200
    64.801    -1.229     0.200
    64.832    -0.428     0.200
    65.334    -4.691     0.200
    65.765    -0.277     0.200
    66.864    -1.019     0.200
    68.463    -0.616     0.200
    68.572     0.405     0.200
    69.956     0.632     0.200
    70.518     0.690     0.200
    71.873    -0.517     0.200
    72.073     0.585     0.200
    72.105    -0.906     0.200
    72.387    -0.093     0.200
    72.397    -0.152     0.200
    72.834     0.148     0.200
    73.310    -1.070     0.200
    73.316    -0.105     0.200
    73.602     0.208     0.200
    74.083     0.391     0.200
    74.133     0.099     0.200
    74.685     0.389     0.200
    74.718     0.196     0.200
    74.864     0.250     0.200
    75.013     0.091     0.200
    75.103    -0.029     0.200
    75.322    -0.091     0.200
    75.324     0.099     0.200
    75.403     0.045     0.200
    75.536     0.379     0.200
    75.899     0.706     0.200
    76.452     0.362     0.200
    76.780     0.102     0.200
    79.152    -1.277     0.200
    81.160    -1.115     0.200
    81.739    -0.880     0.200
    81.892    -0.984     0.200
    82.105    -0.607     0.200
    82.441    -1.662     0.200
    82.996     0.248     0.200
    83.591     1.180     0.200
    86.151    -1.201     0.200
    16.073     6.164     0.200
    16.551     1.654     0.200
    20.930     1.475     0.200
    22.552     1.192     0.200
    23.204    -0.299     0.200
    24.271     2.013     0.200
    25.120     0.375     0.200
    25.151     1.498     0.200
    25.476     1.347     0.200
    25.793     1.167     0.200
    27.747    -2.636     0.200
    27.980     1.677     0.200
    28.212    -0.584     0.200
    28.217     1.367     0.200
    28.834     2.574     0.200
    29.320     1.665     0.200
    29.727     1.753     0.200
    29.928     1.971     0.200
    30.449     1.470     0.200
    30.471     1.870     0.200
    34.434    -0.939     0.200
    34.529    -2.162     0.200
    37.745     1.123     0.200
    38.092     0.393     0.200
    42.057    -0.319     0.200
    42.854     1.000     0.200
    43.094     0.453     0.200
    43.823    -1.122     0.200
    44.836     0.569     0.200
    46.780    -2.490     0.200
    54.051    -0.584     0.200
    55.865    -1.508     0.200
    56.497    -0.427     0.200
    56.445    -0.957     0.200
    59.633    -0.200     0.200
    59.888    -1.255     0.200
    63.200    -0.820     0.200
    63.316    -0.386     0.200
    63.909    -1.208     0.200
    64.661    -1.136     0.200
    65.773     0.253     0.200
    68.504    -0.689     0.200
    69.964     0.765     0.200
    71.894     0.039     0.200
    72.408    -0.341     0.200
    72.416    -0.087     0.200
    73.379    -0.800     0.200
    73.629    -1.269     0.200
    74.104    -0.050     0.200
    74.279    -1.071     0.200
    74.378    -0.152     0.200
    74.691     0.130     0.200
    74.729     0.112     0.200
    74.874     0.071     0.200
    75.113    -0.908     0.200
    75.333    -0.872     0.200
    75.412    -0.228     0.200
    81.766    -0.245     0.200
    82.511    -2.150     0.200
    87.392    -0.086     0.200
    18.682     0.578     0.200
    19.302     0.773     0.200
    20.370     1.225     0.200
    21.413     0.854     0.200
    21.916     0.548     0.200
    22.326     1.173     0.200
    22.720    -0.715     0.200
    23.078     2.101     0.200
    23.184     1.681     0.200
    23.204     1.474     0.200
    23.445     1.037     0.200
    24.504     0.418     0.200
    24.757     1.714     0.200
    25.211     1.984     0.200
    25.905     0.890     0.200
    26.137     0.682     0.200
    26.166     1.220     0.200
    26.347     0.989     0.200
    27.038     1.855     0.200
    27.403     2.170     0.200
    27.526     1.268     0.200
    28.055    -2.556     0.200
    27.747     1.195     0.200
    27.832     1.637     0.200
    28.437    -2.560     0.200
    28.864     1.439     0.200
    29.642    -1.566     0.200
    29.828     1.889     0.200
    29.977     1.264     0.200
    30.911     1.514     0.200
    31.360     1.057     0.200
    31.978     0.618     0.200
    34.000    -1.050     0.200
    34.607    -2.314     0.200
    34.607    -1.814     0.200
    34.313     2.232     0.200
    34.360     1.823     0.200
    34.477     1.308     0.200
    37.245     1.575     0.200
    37.248     0.055     0.200
    38.161    -2.172     0.200
    38.161    -1.371     0.200
    40.309    -1.623     0.200
    40.728     0.410     0.200
    41.644     0.272     0.200
    42.278     0.690     0.200
    42.512     1.786     0.200
    43.383    -1.373     0.200
    43.722    -0.004     0.200
    43.920     1.100     0.200
    44.168     0.116     0.200
    44.236     1.169     0.200
    44.697    -0.121     0.200
    46.746    -1.513     0.200
    46.967    -1.246     0.200
    47.502     0.580     0.200
    48.011    -0.369     0.200
    48.744    -2.021     0.200
    48.592     0.150     0.200
    49.133    -1.309     0.200
    49.289    -1.002     0.200
    49.791    -1.032     0.200
    49.929    -1.282     0.200
    49.533     0.437     0.200
    50.035    -0.983     0.200
    50.191    -1.268     0.200
    49.890     0.817     0.200
    50.010    -0.891     0.200
    50.176     0.645     0.200
    50.871    -0.207     0.200
    50.872     0.388     0.200
    51.431    -1.809     0.200
    52.611    -2.203     0.200
    52.850    -0.068     0.200
    53.678    -0.967     0.200
    53.744    -2.548     0.200
    54.430    -1.359     0.200
    54.914    -2.064     0.200
    55.527    -1.389     0.200
    55.895    -1.134     0.200
    56.137    -0.862     0.200
    56.060     0.685     0.200
    56.655     0.142     0.200
    56.741    -0.768     0.200
    58.854    -1.019     0.200
    59.343    -1.110     0.200
    59.329    -0.317     0.200
    59.545    -1.404     0.200
    60.200    -2.010     0.200
    60.465    -0.121     0.200
    60.616    -1.154     0.200
    60.802    -0.823     0.200
    61.334    -1.033     0.200
    61.387    -1.088     0.200
    61.725    -0.775     0.200
    62.497    -0.356     0.200
    62.434    -1.315     0.200
    62.448    -1.029     0.200
    62.800    -1.451     0.200
    62.817    -1.294     0.200
    63.073    -0.894     0.200
    62.923    -0.598     0.200
    62.994    -0.670     0.200
    63.227    -0.717     0.200
    63.364    -1.322     0.200
    63.699    -1.241     0.200
    63.823    -0.656     0.200
    63.773    -0.324     0.200
    64.112    -0.755     0.200
    64.164    -0.799     0.200
    64.360    -0.682     0.200
    64.562    -1.310     0.200
    64.726    -0.578     0.200
    64.753    -0.351     0.200
    64.956    -1.678     0.200
    64.833    -0.579     0.200
    64.894    -0.274     0.200
    65.292    -0.656     0.200
    65.299    -0.303     0.200
    65.916    -1.191     0.200
    66.016     0.163     0.200
    66.360    -0.544     0.200
    66.998    -1.015     0.200
    67.141    -1.124     0.200
    67.227    -1.472     0.200
    67.013    -0.513     0.200
    67.110     0.075     0.200
    67.192    -0.351     0.200
    67.383    -0.759     0.200
    67.740     1.085     0.200
    67.582    -1.918     0.200
    67.645    -2.117     0.200
    68.184     0.093     0.200
    68.258    -1.476     0.200
    69.028     0.219     0.200
    69.504    -1.927     0.200
    69.766     0.454     0.200
    70.097    -0.078     0.200
    70.914    -0.068     0.200
    71.155    -0.630     0.200
    71.174    -0.047     0.200
    71.493    -0.577     0.200
    71.587     0.360     0.200
    71.633    -0.417     0.200
    71.791     0.128     0.200
    71.829    -0.100     0.200
    72.199    -0.718     0.200
    72.006    -0.161     0.200
    72.013    -0.203     0.200
    72.064    -0.211     0.200
    72.279    -0.896     0.200
    72.293    -0.979     0.200
    72.346     0.304     0.200
    72.305    -0.252     0.200
    72.361    -0.384     0.200
    72.353     0.062     0.200
    72.589     0.352     0.200
    72.462     1.610     0.200
    72.661     0.329     0.200
    72.854    -0.218     0.200
    72.903     0.190     0.200
    72.945    -0.060     0.200
    73.271    -0.592     0.200
    73.464     0.370     0.200
    73.537     0.142     0.200
    73.789    -0.336     0.200
    73.621    -0.050     0.200
    73.683     0.385     0.200
    73.666     0.184     0.200
    73.704     0.463     0.200
    73.842    -0.146     0.200
    73.932    -0.173     0.200
    74.153    -1.670     0.200
    74.307     0.234     0.200
    74.165     0.060     0.200
    74.204     0.235     0.200
    74.266    -0.126     0.200
    74.414     0.011     0.200
    74.409     0.042     0.200
    74.466    -0.190     0.200
    74.561    -0.243     0.200
    74.626     0.778     0.200
    74.646    -0.138     0.200
    74.730     0.276     0.200
    74.809     0.322     0.200
    74.809     0.822     0.200
    74.807     0.131     0.200
    74.821    -0.449     0.200
    74.827    -0.786     0.200
    74.860     0.220     0.200
    74.853    -0.135     0.200
    74.868    -0.123     0.200
    74.937    -0.223     0.200
    74.937    -0.224     0.200
    75.027     0.156     0.200
    75.039    -0.009     0.200
    75.073    -0.205     0.200
    75.362    -1.870     0.200
    75.405    -0.120     0.200
    75.404    -0.514     0.200
    75.435     0.513     0.200
    75.664     0.695     0.200
    75.711     0.526     0.200
    75.781     0.029     0.200
    75.811     0.558     0.200
    75.764    -0.177     0.200
    76.044    -0.375     0.200
    76.054     0.668     0.200
    75.967     0.662     0.200
    75.973     0.034     0.200
    76.075     0.951     0.200
    76.144     0.256     0.200
    76.399    -0.792     0.200
    76.229    -0.330     0.200
    76.543     2.390     0.200
    76.375    -3.654     0.200
    76.303    -0.051     0.200
    76.364     0.305     0.200
    76.573    -3.781     0.200
    76.545    -0.621     0.200
    76.601     2.062     0.200
    76.601     4.062     0.200
    76.853    -0.858     0.200
    76.846    -0.820     0.200
    77.016    -1.278     0.200
    77.253    -1.412     0.200
    77.109    -1.202     0.200
    77.509    -1.042     0.200
    77.329     0.462     0.200
    77.510    -0.551     0.200
    77.693    -0.075     0.200
    77.735    -0.408     0.200
    77.951    -0.312     0.200
    78.057     0.903     0.200
    78.266    -0.555     0.200
    78.189     0.170     0.200
    78.260     0.777     0.200
    78.319     0.248     0.200
    78.382    -0.896     0.200
    78.379     0.519     0.200
    78.571    -0.743     0.200
    78.501    -1.053     0.200
    78.517    -0.646     0.200
    78.533     0.268     0.200
    78.520     0.339     0.200
    78.617     0.304     0.200
    78.805    -0.633     0.200
    78.741     0.620     0.200
    78.990     0.852     0.200
    78.985    -1.220     0.200
    79.119    -0.652     0.200
    79.212     0.538     0.200
    79.306    -0.475     0.200
    79.383    -0.394     0.200
    79.343     0.523     0.200
    79.442    -1.717     0.200
    79.442    -1.217     0.200
    79.259     2.279     0.200
    79.552    -0.315     0.200
    79.539    -0.247     0.200
    79.617    -0.071     0.200
    79.814     1.258     0.200
    80.302    -4.377     0.200
    80.317    -0.459     0.200
    80.896    -0.561     0.200
    80.875    -1.454     0.200
    80.929    -0.742     0.200
    80.848    -0.307     0.200
    81.034     0.398     0.200
    81.188    -0.621     0.200
    81.181    -0.083     0.200
    81.414    -0.118     0.200
    81.550     0.960     0.200
    81.487     0.294     0.200
    81.711     1.110     0.200
    81.794    -1.330     0.200
    81.884     0.199     0.200
    81.952     0.838     0.200
    82.241    -1.677     0.200
    82.117    -0.224     0.200
    82.066     1.740     0.200
    82.313    -1.051     0.200
    82.313    -0.651     0.200
    82.236    -0.553     0.200
    82.367    -0.336     0.200
    82.361    -0.802     0.200
    82.471     0.619     0.200
    82.485     1.147     0.200
    82.730     0.770     0.200
    82.902    -0.121     0.200
    82.960     0.578     0.200
    83.072    -0.001     0.200
    83.671    -1.388     0.200
    83.635     0.596     0.200
    83.724    -1.059     0.200
    84.313     0.637     0.200
    84.699    -2.120     0.200
    84.773    -1.190     0.200
    85.460    -1.537     0.200
    85.566    -0.664     0.200
    85.503    -0.351     0.200
    85.899     0.085     0.200
    86.266    -2.030     0.200
    86.364     0.886     0.200
    86.413    -2.853     0.200
    86.964    -1.553     0.200
    88.393    -3.600     0.200
    91.661     3.832     0.200
    92.585    -1.036     0.200
    92.876    -2.282     0.200
    92.496     3.473     0.200
    95.137    -1.669     0.200
    95.954     0.303     0.200
    98.398    -1.540     0.200
    19.168    -0.264     0.200
    21.394     1.320     0.200
    21.596    -0.741     0.200
    22.567     0.833     0.200
    23.342     0.823     0.200
    25.272     0.238     0.200
    26.175     2.559     0.200
    26.552    -2.340     0.200
    26.552    -1.942     0.200
    26.794     1.883     0.200
    27.358     1.720     0.200
    28.218    -1.257     0.200
    28.218    -0.457     0.200
    28.496     2.270     0.200
    29.260     2.184     0.200
    29.854     0.427     0.200
    30.643     3.256     0.200
    30.956     1.899     0.200
    32.745    -1.108     0.200
    32.918     1.673     0.200
    33.135     2.381     0.200
    35.878     1.680     0.200
    36.588    -2.379     0.200
    36.588    -2.078     0.200
    38.438     0.982     0.200
    42.137    -1.811     0.200
    43.212    -0.023     0.200
    43.424     0.070     0.200
    43.576    -0.456     0.200
    45.281    -1.865     0.200
    45.423    -0.991     0.200
    45.423    -0.691     0.200
    45.372     0.609     0.200
    50.132    -1.746     0.200
    54.089    -1.631     0.200
    54.656    -1.651     0.200
    55.157    -2.568     0.200
    55.157    -2.068     0.200
    57.495    -1.222     0.200
    57.842    -1.155     0.200
    58.115    -1.564     0.200
    59.326    -0.783     0.200
    59.951    -1.778     0.200
    60.368    -2.528     0.200
    61.531    -0.823     0.200
    62.486    -1.424     0.200
    62.898    -2.170     0.200
    64.144    -0.586     0.200
    65.473    -1.337     0.200
    66.549    -0.344     0.200
    66.701    -1.415     0.200
    68.840     0.130     0.200
    70.162    -1.527     0.200
    70.672    -0.637     0.200
    70.672    -0.035     0.200
    70.694     0.232     0.200
    70.741    -1.056     0.200
    70.789    -0.746     0.200
    70.875    -0.873     0.200
    71.599     0.257     0.200
    71.785    -1.362     0.200
    71.785    -0.561     0.200
    71.863    -0.833     0.200
    71.863    -0.434     0.200
    72.371     0.631     0.200
    72.418     0.054     0.200
    72.512     0.294     0.200
    72.698    -0.412     0.200
    72.743    -0.778     0.200
    72.926    -0.063     0.200
    73.124    -0.133     0.200
    73.071    -0.217     0.200
    73.072    -0.222     0.200
    73.220    -0.096     0.200
    73.365    -0.358     0.200
    73.461    -0.515     0.200
    73.564     0.773     0.200
    73.676    -0.383     0.200
    73.697    -0.506     0.200
    73.771    -0.439     0.200
    73.901    -0.201     0.200
    74.363    -1.589     0.200
    74.363    -1.390     0.200
    74.836     0.169     0.200
    75.162    -0.008     0.200
    77.433    -2.085     0.200
    77.433    -1.585     0.200
    77.626    -0.162     0.200
    77.626     0.440     0.200
    79.414    -0.008     0.200
    79.998    -0.671     0.200
    81.262     0.064     0.200
    81.555    -0.089     0.200
    81.698    -0.039     0.200
    81.786    -0.101     0.200
    81.949    -0.557     0.200
    83.335    -0.963     0.200
    83.335    -0.963     0.200
    84.322    -0.802     0.200
    13.544     4.380     0.200
    21.737     1.392     0.200
    21.757     2.680     0.200
    22.968     0.879     0.200
    29.767     1.868     0.200
    30.955     1.984     0.200
    31.327     1.010     0.200
    33.112     2.182     0.200
    33.301     0.936     0.200
    35.723     2.124     0.200
    38.775     1.101     0.200
    54.792    -1.146     0.200
    59.464    -1.006     0.200
    60.560    -1.007     0.200
    61.638    -1.900     0.200
    61.675    -0.946     0.200
    71.057    -0.069     0.200
    72.925    -0.436     0.200
    73.309    -0.301     0.200
    73.460    -0.587     0.200
    73.702    -0.605     0.200
    73.853    -0.390     0.200
    80.993    -0.198     0.200
    81.344    -0.341     0.200
    81.416    -0.539     0.200
    81.485    -0.586     0.200
    81.575    -0.179     0.200
    15.032     2.130     0.200
    19.106     0.353     0.200
    19.356    -0.781     0.200
    20.206     0.776     0.200
    20.978     2.440     0.200
    21.443    -1.450     0.200
    21.449     2.378     0.200
    21.499     1.646     0.200
    21.529     1.530     0.200
    22.009     1.722     0.200
    22.579     0.367     0.200
    23.396     1.455     0.200
    25.296     0.747     0.200
    25.449     4.759     0.200
    25.975     2.600     0.200
    26.281     2.528     0.200
    26.897     2.382     0.200
    27.294    -0.275     0.200
    27.410     1.383     0.200
    27.580     0.865     0.200
    27.743     0.108     0.200
    28.116    -1.614     0.200
    28.116    -1.216     0.200
    28.609     2.297     0.200
    29.320     0.890     0.200
    29.324     2.155     0.200
    29.367     2.278     0.200
    29.513     2.283     0.200
    29.566     2.008     0.200
    30.237     2.778     0.200
    30.482     2.310     0.200
    30.756     3.196     0.200
    30.755     2.306     0.200
    31.024     1.134     0.200
    31.260     1.561     0.200
    32.139     1.832     0.200
    32.415     2.416     0.200
    32.415     2.418     0.200
    32.479     2.463     0.200
    32.771    -1.697     0.200
    32.954     1.503     0.200
    33.203     2.531     0.200
    33.243     2.181     0.200
    33.526     2.725     0.200
    33.538     1.619     0.200
    34.027     1.369     0.200
    34.056    -0.185     0.200
    34.541     1.927     0.200
    34.795     1.728     0.200
    35.418     1.671     0.200
    35.447     2.124     0.200
    35.981     1.548     0.200
    36.459    -2.135     0.200
    37.619    -1.866     0.200
    38.297    -0.483     0.200
    38.509     1.570     0.200
    38.511     1.221     0.200
    39.125    -2.818     0.200
    40.079    -0.951     0.200
    40.690    -2.294     0.200
    41.128    -1.297     0.200
    41.983    -1.790     0.200
    41.975    -1.628     0.200
    42.573     0.104     0.200
    43.108    -2.120     0.200
    44.425    -0.393     0.200
    44.507    -0.948     0.200
    45.114    -2.172     0.200
    45.290    -2.273     0.200
    46.573     0.233     0.200
    46.739    -0.870     0.200
    47.406    -2.267     0.200
    47.991    -1.190     0.200
    47.908    -0.757     0.200
    48.159    -1.291     0.200
    48.021     0.078     0.200
    48.227     1.885     0.200
    48.401     0.343     0.200
    48.354    -0.895     0.200
    48.896    -0.757     0.200
    48.768    -0.373     0.200
    48.934    -1.045     0.200
    48.858    -0.262     0.200
    49.112    -1.109     0.200
    48.964     0.078     0.200
    49.298    -0.829     0.200
    49.546    -0.215     0.200
    49.520    -0.217     0.200
    49.898    -0.787     0.200
    49.755    -0.306     0.200
    50.048    -1.627     0.200
    50.052    -0.059     0.200
    50.326     0.270     0.200
    50.557    -0.673     0.200
    50.865    -0.687     0.200
    50.759     0.204     0.200
    50.766     0.557     0.200
    50.769    -0.269     0.200
    51.152     0.258     0.200
    51.618     1.569     0.200
    51.705    -0.480     0.200
    52.076    -1.035     0.200
    52.087    -1.319     0.200
    52.191    -0.095     0.200
    52.129    -0.435     0.200
    52.434    -1.293     0.200
    53.187    -1.450     0.200
    53.363    -0.738     0.200
    53.711     2.216     0.200
    54.197    -1.133     0.200
    54.496    -0.603     0.200
    54.393     1.747     0.200
    54.912    -0.014     0.200
    55.025    -1.330     0.200
    55.623    -0.633     0.200
    55.502    -3.760     0.200
    55.680    -0.041     0.200
    55.884    -0.598     0.200
    56.914    -0.928     0.200
    56.783     1.100     0.200
    57.402    -1.268     0.200
    57.943    -1.167     0.200
    58.177     0.794     0.200
    58.127     2.145     0.200
    58.791    -1.481     0.200
    58.791    -1.380     0.200
    58.940    -0.610     0.200
    59.153    -1.184     0.200
    59.845    -0.754     0.200
    59.954    -0.898     0.200
    60.200    -1.783     0.200
    61.025    -1.200     0.200
    61.251    -1.132     0.200
    61.285    -1.856     0.200
    61.358    -1.153     0.200
    61.792    -1.079     0.200
    61.998    -0.859     0.200
    61.982    -2.252     0.200
    62.091    -0.977     0.200
    62.413    -1.131     0.200
    62.726    -1.221     0.200
    63.121    -1.744     0.200
    63.987    -0.249     0.200
    65.131    -0.617     0.200
    65.352    -1.447     0.200
    65.312    -0.689     0.200
    65.327    -0.684     0.200
    65.667    -1.475     0.200
    65.604     0.227     0.200
    65.885    -0.879     0.200
    65.843    -0.610     0.200
    66.155    -0.616     0.200
    66.336    -1.772     0.200
    66.278    -0.953     0.200
    66.407    -0.524     0.200
    66.413    -0.563     0.200
    66.526    -1.287     0.200
    66.789    -0.625     0.200
    66.981    -0.471     0.200
    68.085    -0.286     0.200
    68.127    -0.061     0.200
    68.135    -0.286     0.200
    68.178    -0.290     0.200
    68.275    -0.577     0.200
    68.663    -0.467     0.200
    68.676    -0.037     0.200
    68.864     0.295     0.200
    68.909     0.514     0.200
    69.533     0.156     0.200
    69.771    -0.112     0.200
    69.805    -0.522     0.200
    69.937    -0.227     0.200
    69.995    -0.683     0.200
    70.252    -0.058     0.200
    70.504    -0.397     0.200
    70.527    -0.436     0.200
    70.687    -1.308     0.200
    70.613    -0.358     0.200
    70.769     0.595     0.200
    70.767    -0.999     0.200
    70.843    -0.267     0.200
    70.880    -0.380     0.200
    70.960    -0.268     0.200
    70.992    -1.157     0.200
    71.064    -0.897     0.200
    71.261    -0.068     0.200
    71.340     0.133     0.200
    71.372     0.271     0.200
    71.377    -0.389     0.200
    71.430    -0.808     0.200
    71.432    -0.021     0.200
    71.432     0.272     0.200
    71.459    -0.123     0.200
    71.482     0.267     0.200
    71.629    -0.602     0.200
    71.578     0.271     0.200
    71.692    -0.684     0.200
    71.686     0.263     0.200
    71.741    -0.080     0.200
    71.771     0.274     0.200
    71.833     0.341     0.200
    71.892     0.266     0.200
    72.052     0.112     0.200
    72.061     0.046     0.200
    72.130    -0.006     0.200
    72.150    -0.029     0.200
    72.145     0.101     0.200
    72.204     0.253     0.200
    72.255    -0.172     0.200
    72.263    -0.203     0.200
    72.280    -0.502     0.200
    72.341     0.136     0.200
    72.433    -0.215     0.200
    72.533    -0.007     0.200
    72.536    -0.626     0.200
    72.572     0.061     0.200
    72.572    -0.140     0.200
    72.764    -0.488     0.200
    72.788    -0.420     0.200
    72.873    -0.705     0.200
    72.911    -0.648     0.200
    72.915    -0.778     0.200
    72.948     0.132     0.200
    73.034    -0.581     0.200
    72.871    -0.013     0.200
    73.040    -0.212     0.200
    73.060    -0.734     0.200
    73.205    -0.991     0.200
    73.216    -0.321     0.200
    73.241    -0.398     0.200
    73.275    -2.397     0.200
    73.306    -0.381     0.200
    73.301    -0.953     0.200
    73.317    -0.248     0.200
    73.302     0.742     0.200
    73.306     0.617     0.200
    73.269     0.335     0.200
    73.395    -0.505     0.200
    73.451    -0.933     0.200
    73.517    -1.020     0.200
    73.541     0.036     0.200
    73.540    -0.856     0.200
    73.517     0.779     0.200
    73.552     0.773     0.200
    73.613    -0.989     0.200
    73.645     0.323     0.200
    73.825     0.270     0.200
    73.849     0.731     0.200
    73.870     1.007     0.200
    74.206    -0.849     0.200
    74.206     0.148     0.200
    74.216     0.288     0.200
    74.220     0.065     0.200
    74.220     0.666     0.200
    74.291     0.353     0.200
    74.414     0.738     0.200
    74.457    -0.911     0.200
    74.552    -1.861     0.200
    74.552    -1.060     0.200
    74.513     0.367     0.200
    74.525     0.194     0.200
    74.564     0.669     0.200
    74.647    -0.411     0.200
    74.663     0.892     0.200
    74.680    -0.301     0.200
    74.719    -0.028     0.200
    74.872    -0.812     0.200
    74.901    -0.881     0.200
    74.915    -0.661     0.200
    74.942    -0.216     0.200
    75.030     0.377     0.200
    75.051     0.557     0.200
    75.081    -0.716     0.200
    75.077     0.286     0.200
    75.082     0.578     0.200
    75.141    -1.260     0.200
    75.139     1.160     0.200
    75.307    -1.414     0.200
    75.348    -0.953     0.200
    75.399    -0.343     0.200
    75.432     1.066     0.200
    75.462     0.646     0.200
    75.479     1.101     0.200
    75.479     0.460     0.200
    75.560     0.837     0.200
    75.596    -0.372     0.200
    75.616    -1.486     0.200
    75.623     1.265     0.200
    75.643    -0.639     0.200
    75.677    -0.335     0.200
    75.759     0.899     0.200
    75.792     0.012     0.200
    75.943    -0.450     0.200
    75.885     0.783     0.200
    76.044    -1.426     0.200
    76.006     0.938     0.200
    76.043    -0.418     0.200
    76.059    -1.008     0.200
    76.015     0.940     0.200
    76.073     0.443     0.200
    76.093    -0.502     0.200
    76.107     0.415     0.200
    76.194    -0.279     0.200
    76.221    -0.502     0.200
    76.308    -0.525     0.200
    76.334     0.431     0.200
    76.357    -0.761     0.200
    76.424    -1.079     0.200
    76.380    -0.384     0.200
    76.388    -1.147     0.200
    76.415    -0.527     0.200
    76.410     0.499     0.200
    76.455    -0.256     0.200
    76.461    -1.490     0.200
    76.506    -0.886     0.200
    76.728    -1.297     0.200
    76.728    -2.297     0.200
    76.748    -0.407     0.200
    76.760    -0.370     0.200
    76.933    -0.452     0.200
    76.951     1.446     0.200
    76.954    -0.173     0.200
    76.939    -0.785     0.200
    77.016    -0.416     0.200
    77.003     0.052     0.200
    77.143    -0.327     0.200
    77.204     0.026     0.200
    77.274    -0.362     0.200
    77.222     0.126     0.200
    77.135    -1.083     0.200
    77.147    -1.651     0.200
    77.329     1.526     0.200
    77.257     0.031     0.200
    77.262    -1.294     0.200
    77.290     0.548     0.200
    77.406    -0.102     0.200
    77.470    -0.761     0.200
    77.593     0.056     0.200
    77.600    -1.185     0.200
    77.600    -0.583     0.200
    77.643     0.078     0.200
    77.601     0.413     0.200
    77.697     0.876     0.200
    77.796    -0.275     0.200
    77.733    -0.029     0.200
    77.743    -0.201     0.200
    77.677    -1.616     0.200
    77.887     0.520     0.200
    77.981     0.625     0.200
    78.019     0.985     0.200
    78.053    -0.310     0.200
    77.999    -1.800     0.200
    78.136    -0.463     0.200
    78.148     0.373     0.200
    78.130     0.873     0.200
    78.241    -0.639     0.200
    78.346    -1.719     0.200
    78.378     0.503     0.200
    78.504     0.075     0.200
    78.574     0.522     0.200
    78.620    -0.334     0.200
    78.614    -0.197     0.200
    78.640     0.558     0.200
    78.682    -0.174     0.200
    78.758    -0.690     0.200
    78.860    -0.350     0.200
    78.872    -0.714     0.200
    78.911     0.271     0.200
    78.911    -0.256     0.200
    79.077    -0.036     0.200
    79.035    -1.608     0.200
    79.239     0.175     0.200
    79.119    -0.870     0.200
    79.266    -0.368     0.200
    79.129    -1.221     0.200
    79.268    -0.980     0.200
    79.276     0.075     0.200
    79.330    -0.716     0.200
    79.265    -1.864     0.200
    79.381    -0.195     0.200
    79.390    -1.046     0.200
    79.325    -0.224     0.200
    79.441    -1.324     0.200
    79.435    -0.288     0.200
    79.548     0.898     0.200
    79.588    -0.620     0.200
    79.642     1.084     0.200
    79.510    -1.301     0.200
    79.533    -1.821     0.200
    79.696     0.193     0.200
    79.732    -1.301     0.200
    79.784    -0.184     0.200
    79.682    -0.324     0.200
    79.826    -0.911     0.200
    79.850     0.458     0.200
    79.986    -0.277     0.200
    80.085    -1.810     0.200
    80.076     0.539     0.200
    80.159     0.892     0.200
    80.201    -0.433     0.200
    80.249     0.310     0.200
    80.231     0.603     0.200
    80.280     0.142     0.200
    80.169    -1.063     0.200
    80.345     0.894     0.200
    80.378    -0.888     0.200
    80.349     0.871     0.200
    80.461     0.171     0.200
    80.461     0.671     0.200
    80.515    -0.223     0.200
    80.516    -0.624     0.200
    80.545     1.220     0.200
    80.620    -1.680     0.200
    80.588    -0.408     0.200
    80.669     0.058     0.200
    80.658    -0.784     0.200
    80.685     0.273     0.200
    80.687    -0.342     0.200
    80.700     1.693     0.200
    80.748    -0.366     0.200
    80.753    -0.394     0.200
    80.859    -0.757     0.200
    81.007    -0.643     0.200
    81.009    -0.656     0.200
    81.077    -0.015     0.200
    81.037     0.094     0.200
    81.062    -1.039     0.200
    81.088     0.021     0.200
    81.099    -1.234     0.200
    81.121    -1.350     0.200
    81.094     1.291     0.200
    81.128     1.109     0.200
    81.133     1.188     0.200
    81.173     1.372     0.200
    81.309    -1.448     0.200
    81.271     0.955     0.200
    81.299    -1.095     0.200
    81.296    -0.380     0.200
    81.322    -1.417     0.200
    81.288     1.362     0.200
    81.425    -0.159     0.200
    81.491    -0.212     0.200
    81.443     0.644     0.200
    81.486    -0.788     0.200
    81.501    -0.862     0.200
    81.567    -0.316     0.200
    81.494     1.069     0.200
    81.539    -0.563     0.200
    81.550    -1.224     0.200
    81.548    -0.115     0.200
    81.558    -0.165     0.200
    81.530     1.481     0.200
    81.581    -0.786     0.200
    81.655     0.022     0.200
    81.611     1.657     0.200
    81.716    -0.297     0.200
    81.731    -0.578     0.200
    81.782     0.156     0.200
    81.887    -0.399     0.200
    81.836    -0.431     0.200
    81.827     0.119     0.200
    81.921    -0.017     0.200
    81.811    -1.870     0.200
    81.938    -1.166     0.200
    81.949    -0.723     0.200
    81.940     0.222     0.200
    82.004    -0.712     0.200
    82.079    -1.301     0.200
    82.211    -0.395     0.200
    82.125     0.088     0.200
    82.294    -0.925     0.200
    82.497     0.411     0.200
    82.584     0.960     0.200
    82.674    -0.727     0.200
    82.802    -1.172     0.200
    82.889     0.079     0.200
    82.991    -0.152     0.200
    83.103    -1.230     0.200
    83.240    -1.435     0.200
    83.240    -1.537     0.200
    83.256    -3.015     0.200
    83.296    -1.223     0.200
    83.391    -3.710     0.200
    83.413    -1.327     0.200
    83.559    -0.974     0.200
    83.574    -0.549     0.200
    83.677    -0.979     0.200
    83.613     1.546     0.200
    83.718    -0.689     0.200
    83.890    -0.768     0.200
    83.969     1.829     0.200
    84.150     0.410     0.200
    84.194    -1.116     0.200
    84.151     0.403     0.200
    84.260    -0.645     0.200
    84.416     1.063     0.200
    84.397    -0.340     0.200
    84.467    -1.498     0.200
    84.552     0.376     0.200
    84.565     3.809     0.200
    84.498     0.648     0.200
    84.625    -0.993     0.200
    85.010    -0.928     0.200
    85.120    -1.976     0.200
    85.347     0.391     0.200
    85.366     0.898     0.200
    85.444     0.304     0.200
    85.626    -0.397     0.200
    85.680    -1.766     0.200
    85.727    -1.798     0.200
    85.996     0.673     0.200
    86.310     1.026     0.200
    86.461    -1.416     0.200
    86.447     0.853     0.200
    86.599    -1.294     0.200
    86.628    -2.433     0.200
    86.696     0.234     0.200
    86.904    -0.280     0.200
    87.002    -0.958     0.200
    87.475     1.455     0.200
    88.340     0.350     0.200
    88.874     1.637     0.200
    89.353     1.485     0.200
    89.928     0.200     0.200
    91.221    -3.813     0.200
    91.845     0.993     0.200
    93.093     2.232     0.200
    93.413    -1.242     0.200
    94.182     0.226     0.200
    95.181    -1.348     0.200
    95.556    -0.062     0.200
    97.312    -1.627     0.200
    98.143    -1.564     0.200
    21.700     2.385     0.200
    21.741     2.153     0.200
    22.154     1.257     0.200
    22.537    -0.295     0.200
    23.695     1.242     0.200
    27.510     0.713     0.200
    27.715     1.679     0.200
    29.241     1.312     0.200
    30.317     2.496     0.200
    31.298     1.146     0.200
    32.355     1.867     0.200
    32.984     2.368     0.200
    33.152     1.908     0.200
    33.156     0.873     0.200
    33.356     1.524     0.200
    33.423     2.542     0.200
    33.937     1.082     0.200
    34.122     0.779     0.200
    34.581     1.307     0.200
    34.705     1.438     0.200
    35.697     1.411     0.200
    35.742     2.021     0.200
    35.932     1.401     0.200
    38.673     0.695     0.200
    41.229     2.005     0.200
    44.991    -0.663     0.200
    48.492     0.088     0.200
    50.931    -0.245     0.200
    61.254    -0.694     0.200
    62.332    -1.340     0.200
    62.365    -0.858     0.200
    71.051    -0.161     0.200
    71.558    -0.316     0.200
    71.589     0.097     0.200
    71.751    -0.380     0.200
    72.483     0.151     0.200
    72.496     0.473     0.200
    73.260     0.148     0.200
    73.330     0.135     0.200
    73.370    -0.998     0.200
    73.614     0.070     0.200
    73.841    -0.162     0.200
    73.995    -0.060     0.200
    74.145     0.065     0.200
    74.386    -0.240     0.200
    74.438     2.358     0.200
    74.537    -0.012     0.200
    74.601    -0.283     0.200
    74.700    -0.360     0.200
    74.821    -0.159     0.200
    74.940     0.156     0.200
    75.279     0.208     0.200
    75.770     0.295     0.200
    76.004     0.166     0.200
    76.109     1.467     0.200
    76.130     1.649     0.200
    77.005    -1.094     0.200
    77.826     0.122     0.200
    79.316     0.024     0.200
    81.366    -0.425     0.200
    81.721    -1.061     0.200
    81.799    -0.751     0.200
    81.860    -0.073     0.200
    81.953     0.003     0.200
    30.212     0.578     0.200
    32.426     2.460     0.200
    21.285     1.989     0.200
    21.820    -1.779     0.200
    24.494     0.827     0.200
    32.120     1.418     0.200
    33.926     2.312     0.200
    34.061     1.504     0.200
    34.306     1.449     0.200
    35.477     1.534     0.200
    39.059    -0.438     0.200
    43.697     0.695     0.200
    45.485     0.701     0.200
    21.291     1.915     0.200
    23.205     1.491     0.200
    26.915     0.099     0.200
    32.612     2.193     0.200
    32.995     2.295     0.200
    34.168     2.212     0.200
    34.358     2.062     0.200
    41.162    -0.446     0.200
    42.352    -0.665     0.200
    48.886     0.529     0.200
    60.181    -0.788     0.200
    60.596    -1.216     0.200
    61.685    -1.286     0.200
    71.107    -0.120     0.200
    72.893     0.292     0.200
    73.279    -0.195     0.200
    73.427    -0.067     0.200
    73.574    -0.527     0.200
    73.668    -0.276     0.200
    73.884    -0.544     0.200
    73.901    -0.439     0.200
    75.276    -0.110     0.200
    21.104     1.981     0.200
    21.565     0.180     0.200
    22.208     0.613     0.200
    22.523    -0.544     0.200
    24.784     1.388     0.200
    24.967     0.750     0.200
    25.057     2.774     0.200
    25.781     1.677     0.200
    26.539     2.088     0.200
    26.587    -0.340     0.200
    29.367     0.927     0.200
    30.900     1.317     0.200
    31.653     1.231     0.200
    32.116     1.509     0.200
    32.331     1.816     0.200
    32.592     1.894     0.200
    33.501     0.881     0.200
    33.642     1.923     0.200
    33.690     1.507     0.200
    36.278    -0.147     0.200
    37.610    -0.311     0.200
    38.150     0.669     0.200
    40.039     1.212     0.200
    41.727     0.129     0.200
    41.810     3.925     0.200
    42.195    -0.515     0.200
    42.403     0.687     0.200
    46.183    -2.357     0.200
    46.853    -0.142     0.200
    51.125    -0.357     0.200
    51.283    -0.806     0.200
    54.310    -0.403     0.200
    54.858    -0.383     0.200
    59.174    -2.133     0.200
    59.857    -0.549     0.200
    60.186    -1.105     0.200
    60.500    -1.053     0.200
    61.768    -0.649     0.200
    63.313    -0.366     0.200
    63.396    -1.513     0.200
    64.134    -1.375     0.200
    64.207    -1.856     0.200
    66.261    -0.675     0.200
    66.583    -0.835     0.200
    67.252    -0.491     0.200
    67.275     0.363     0.200
    70.803     0.064     0.200
    70.804     0.259     0.200
    70.855     0.046     0.200
    70.910    -1.488     0.200
    71.029    -0.013     0.200
    71.137    -1.567     0.200
    71.201    -1.053     0.200
    71.510    -0.921     0.200
    71.604    -0.989     0.200
    72.479    -0.825     0.200
    72.496     0.671     0.200
    72.748    -1.031     0.200
    72.791     0.018     0.200
    72.981    -1.008     0.200
    73.052    -0.931     0.200
    73.094    -1.079     0.200
    73.239    -1.133     0.200
    73.389    -1.320     0.200
    73.477    -1.340     0.200
    73.620    -1.180     0.200
    73.694    -1.311     0.200
    73.697    -1.332     0.200
    73.774    -1.185     0.200
    73.900    -1.318     0.200
    73.948     0.097     0.200
    74.143     0.457     0.200
    74.607    -1.236     0.200
    75.070    -1.116     0.200
    75.239     0.210     0.200
    75.260     0.390     0.200
    75.644    -1.616     0.200
    78.236     1.597     0.200
    79.697    -0.114     0.200
    80.192     0.206     0.200
    81.016     0.191     0.200
    82.521     1.262     0.200
    98.700    -0.560     0.200
    15.797     3.123     0.200
    21.365     0.101     0.200
    30.021    -0.345     0.200
    31.419     2.134     0.200
    43.255    -1.426     0.200
    44.163    -1.108     0.200
    44.561     0.313     0.200
    52.083    -2.425     0.200
    60.211    -0.733     0.200
    61.108    -1.632     0.200
    83.128    -0.280     0.200
    21.490     2.836     0.200
    22.685    -0.380     0.200
    30.574    -0.132     0.200
    31.042     1.844     0.200
    33.126     1.972     0.200
    33.122     2.875     0.200
    34.507     1.665     0.200
    37.477    -0.708     0.200
    43.234     0.188     0.200
    44.257     0.673     0.200
    44.710    -0.841     0.200
    53.545    -1.180     0.200
    61.788     0.426     0.200
    62.544     1.363     0.200
    60.788    -0.558     0.200
    61.683     0.001     0.200
    19.198    -0.643     0.200
    21.640    -1.967     0.200
    21.640     1.634     0.200
    52.520    -2.625     0.200
    53.664    -2.337     0.200
    60.649    -2.567     0.200
    13.104     2.690     0.200
    20.010    -0.511     0.200
    21.603    -3.112     0.200
    32.247     2.751     0.200
    43.503    -1.330     0.200
    45.194    -0.168     0.200
    45.645     3.480     0.200
    52.005    -3.424     0.200
    52.373    -0.946     0.200
    56.212    -1.515     0.200
    57.715    -1.493     0.200
    60.129    -3.046     0.200
    60.394    -3.053     0.200
    61.128    -3.216     0.200
    72.373    -1.765     0.200
    18.795    -0.276     0.200
    30.377     0.857     0.200
    43.742    -1.120     0.200
    43.831    -1.737     0.200
    44.143    -1.043     0.200
    46.077    -2.409     0.200
    52.700    -2.307     0.200
    59.331    -2.566     0.200
    60.830    -3.646     0.200
    63.296    -3.111     0.200
    77.641     0.702     0.200
    77.845    -1.642     0.200
    81.531     0.021     0.200
    81.780     0.206     0.200
    81.877     0.492     0.200
    82.128    -0.042     0.200
    82.194    -0.723     0.200
    82.229     0.054     0.200
    82.340    -0.312     0.200
    82.358     0.072     0.200
    82.751    -0.635     0.200
    82.809    -0.702     0.200
    84.243    -1.227     0.200
    19.273    -0.360     0.200
    20.246    -1.191     0.200
    22.623     2.543     0.200
    23.423     1.674     0.200
    23.708     1.431     0.200
    24.224     1.752     0.200
    24.238     1.691     0.200
    24.397     1.634     0.200
    24.543     1.145     0.200
    24.723     2.138     0.200
    25.245     2.084     0.200
    25.545    -1.535     0.200
    25.490     1.248     0.200
    27.741     1.621     0.200
    28.560     1.459     0.200
    30.675     2.052     0.200
    31.029     1.592     0.200
    31.070     1.568     0.200
    31.149     2.242     0.200
    31.199     2.057     0.200
    31.948     1.722     0.200
    32.164     0.605     0.200
    32.344     1.575     0.200
    32.980     2.358     0.200
    33.012     2.190     0.200
    33.125     2.087     0.200
    33.936     2.308     0.200
    34.326     2.204     0.200
    35.501     1.462     0.200
    35.659    -1.366     0.200
    35.641     1.593     0.200
    35.693     1.474     0.200
    35.720     1.413     0.200
    36.360     1.915     0.200
    36.434     1.288     0.200
    36.487     1.103     0.200
    36.541     1.225     0.200
    39.282    -1.873     0.200
    39.604     1.745     0.200
    40.172     0.833     0.200
    42.103    -0.973     0.200
    43.719    -1.275     0.200
    43.747     0.706     0.200
    43.815     0.159     0.200
    45.105    -2.556     0.200
    45.495     0.046     0.200
    46.635    -0.471     0.200
    47.760    -1.913     0.200
    48.689     0.409     0.200
    48.864     0.346     0.200
    48.999    -1.668     0.200
    49.040     1.266     0.200
    51.260    -0.588     0.200
    52.483    -1.146     0.200
    52.508    -1.738     0.200
    57.844    -1.761     0.200
    57.975    -0.680     0.200
    58.119    -0.789     0.200
    60.632    -3.165     0.200
    60.893    -2.540     0.200
    64.488    -1.524     0.200
    65.402    -0.974     0.200
    69.714    -1.228     0.200
    71.837    -0.153     0.200
    77.074    -1.814     0.200
    82.539    -1.941     0.200
    96.983    -2.177     0.200
    19.063    -0.348     0.200
    29.616     1.607     0.200
    30.162     1.896     0.200
    31.110     1.101     0.200
    31.111     1.129     0.200
    33.334     1.650     0.200
    34.641     1.168     0.200
    34.685     0.649     0.200
    43.277    -2.026     0.200
    44.331    -0.376     0.200
    44.412    -2.426     0.200
    52.119    -2.890     0.200
    53.505    -1.214     0.200
    58.485    -2.284     0.200
    60.248    -2.643     0.200
    60.352    -1.651     0.200
    72.323    -0.887     0.200
    78.708    -0.142     0.200
    83.423    -1.999     0.200
    19.687     0.214     0.200
    33.453     2.221     0.200
    60.949    -1.190     0.200
    73.065    -0.942     0.200
    83.416    -0.402     0.200
    19.425    -0.368     0.200
    30.885     1.886     0.200
    44.190    -0.789     0.200
    19.076    -0.176     0.200
    22.713     1.856     0.200
    30.323     0.428     0.200
    32.950    -0.263     0.200
    42.710     0.153     0.200
    43.617     1.120     0.200
    53.191    -1.085     0.200
    59.709    -2.053     0.200
    60.652    -0.708     0.200
    61.321    -1.248     0.200
    62.239    -0.815     0.200
    66.317    -1.115     0.200
    66.547    -1.584     0.200
    84.418    -1.481     0.200
    19.536    -0.720     0.200
    31.067     0.838     0.200
    33.577     0.355     0.200
    52.908    -1.780     0.200
    60.367    -1.626     0.200
    61.965    -1.644     0.200
    72.824     0.628     0.200
    79.472    -0.339     0.200
    19.991     0.020     0.200
    24.173     1.585     0.200
    30.182     2.538     0.200
    30.655     2.682     0.200
    31.793     1.371     0.200
    31.793     1.178     0.200
    33.773     0.965     0.200
    33.951     1.351     0.200
    34.186     0.424     0.200
    35.349     1.218     0.200
    35.989     0.636     0.200
    37.873     0.314     0.200
    43.377     0.866     0.200
    43.818    -1.871     0.200
    44.188    -0.928     0.200
    45.369    -2.307     0.200
    45.119     1.168     0.200
    45.260    -0.143     0.200
    48.115     1.494     0.200
    48.507    -0.221     0.200
    52.857    -1.525     0.200
    56.785    -1.474     0.200
    58.426    -0.681     0.200
    79.479     0.642     0.200
    82.913    -1.446     0.200
    19.642    -0.272     0.200
    31.631     1.292     0.200
    33.903     0.668     0.200
    44.893    -0.545     0.200
    45.009     0.930     0.200
    48.252    -1.393     0.200
    82.982    -0.924     0.200
    20.034     0.243     0.200
    21.051     3.135     0.200
    21.514     2.600     0.200
    21.624     2.185     0.200
    21.944     2.208     0.200
    22.029     2.072     0.200
    22.074     2.856     0.200
    22.457     2.308     0.200
    22.579     2.457     0.200
    22.625     2.239     0.200
    22.751     0.555     0.200
    23.289     1.991     0.200
    23.635     1.059     0.200
    23.635     2.040     0.200
    23.679     1.615     0.200
    24.503     2.501     0.200
    25.147     2.797     0.200
    27.655     2.026     0.200
    28.098     1.252     0.200
    29.660     2.320     0.200
    29.756     1.754     0.200
    29.919     2.709     0.200
    30.559     1.622     0.200
    30.969     2.247     0.200
    31.234     2.402     0.200
    32.020     2.440     0.200
    32.652     2.189     0.200
    32.794     2.883     0.200
    32.900     2.691     0.200
    33.309     1.156     0.200
    33.948     0.852     0.200
    36.876    -3.208     0.200
    37.632    -0.231     0.200
    38.591     1.793     0.200
    38.593     1.714     0.200
    38.593     2.782     0.200
    40.903    -1.720     0.200
    42.834     1.299     0.200
    43.187    -1.653     0.200
    44.456     2.144     0.200
    44.457     2.752     0.200
    44.627    -0.608     0.200
    45.389     0.637     0.200
    45.742    -3.953     0.200
    45.790     0.458     0.200
    46.308    -2.409     0.200
    47.724     1.750     0.200
    48.076     0.068     0.200
    48.626     0.075     0.200
    49.612    -0.257     0.200
    49.888    -1.263     0.200
    50.076    -1.689     0.200
    50.515    -0.513     0.200
    50.915    -1.043     0.200
    53.474    -2.133     0.200
    53.454    -1.589     0.200
    57.501    -1.979     0.200
    57.521    -1.221     0.200
    59.077    -2.385     0.200
    59.119    -0.880     0.200
    59.458    -1.421     0.200
    60.911    -1.165     0.200
    61.395    -1.347     0.200
    61.395    -1.147     0.200
    61.582    -1.411     0.200
    61.909    -0.806     0.200
    62.349    -1.255     0.200
    62.513    -1.156     0.200
    62.916    -1.038     0.200
    63.674    -2.058     0.200
    65.205    -0.065     0.200
    65.683    -1.253     0.200
    65.789    -1.340     0.200
    66.564    -1.310     0.200
    66.956    -0.309     0.200
    67.623    -1.527     0.200
    70.851    -0.717     0.200
    71.192    -0.584     0.200
    72.635    -0.336     0.200
    73.401    -0.269     0.200
    73.466    -0.350     0.200
    73.520    -0.469     0.200
    73.695     0.004     0.200
    73.748    -0.409     0.200
    73.999    -0.574     0.200
    74.127    -0.322     0.200
    74.134    -1.263     0.200
    74.277    -0.294     0.200
    74.372    -0.448     0.200
    74.518    -0.496     0.200
    74.668    -0.365     0.200
    74.831    -0.308     0.200
    74.947    -0.179     0.200
    75.002    -0.199     0.200
    75.080     0.252     0.200
    75.083    -0.064     0.200
    75.419     0.303     0.200
    75.675    -0.463     0.200
    75.899    -0.239     0.200
    76.133    -0.175     0.200
    76.605    -0.049     0.200
    77.024     0.689     0.200
    77.645     0.414     0.200
    77.701     0.100     0.200
    77.960    -0.243     0.200
    78.172    -0.414     0.200
    78.218     0.130     0.200
    79.180    -0.559     0.200
    80.073     0.390     0.200
    80.999    -0.375     0.200
    81.209    -0.109     0.200
    81.583     0.306     0.200
    81.684    -0.004     0.200
    81.850    -0.379     0.200
    81.929    -0.413     0.200
    81.982    -0.214     0.200
    81.989    -0.329     0.200
    82.032    -0.596     0.200
    82.082    -0.115     0.200
    82.516    -0.344     0.200
    82.560    -0.355     0.200
    82.630    -0.957     0.200
    83.047     0.575     0.200
    83.649    -1.022     0.200
    18.579    -0.519     0.200
    30.300     0.886     0.200
    37.925    -1.264     0.200
    43.603    -1.706     0.200
    43.700     0.917     0.200
    43.917    -1.026     0.200
    52.477    -2.518     0.200
    60.271    -1.070     0.200
    60.607    -1.866     0.200
    61.371    -1.253     0.200
    63.933    -2.441     0.200
    21.537     4.834     0.200
    21.667     3.140     0.200
    22.388     1.996     0.200
    22.450     1.782     0.200
    22.760     1.191     0.200
    23.540     1.868     0.200
    23.740     2.257     0.200
    24.647     2.917     0.200
    25.640     2.560     0.200
    26.045     1.843     0.200
    27.326     1.788     0.200
    28.785     2.186     0.200
    28.894     2.757     0.200
    28.989     2.197     0.200
    30.068     3.054     0.200
    30.386     1.535     0.200
    30.612     1.738     0.200
    31.841     2.363     0.200
    32.216     2.691     0.200
    32.335     1.176     0.200
    32.584     2.251     0.200
    32.756     0.513     0.200
    33.753     1.838     0.200
    33.894     1.952     0.200
    33.941     0.339     0.200
    34.121     2.075     0.200
    34.733     2.116     0.200
    34.968     1.793     0.200
    36.443     0.461     0.200
    37.862     1.666     0.200
    37.854     2.130     0.200
    40.452    -0.217     0.200
    41.962     1.058     0.200
    42.071    -1.220     0.200
    43.421    -0.965     0.200
    43.664    -1.294     0.200
    43.774     1.762     0.200
    43.774     2.045     0.200
    44.838    -0.310     0.200
    45.911    -0.284     0.200
    47.261     1.211     0.200
    47.418     0.136     0.200
    49.557     0.505     0.200
    50.696    -2.133     0.200
    51.550     0.172     0.200
    51.640    -0.181     0.200
    52.534    -1.550     0.200
    54.242    -0.107     0.200
    56.065    -0.938     0.200
    58.050    -1.603     0.200
    59.210    -0.357     0.200
    59.995    -1.389     0.200
    60.341    -1.562     0.200
    60.341    -1.438     0.200
    60.664    -1.339     0.200
    63.147    -1.804     0.200
    64.018     1.448     0.200
    65.981    -0.866     0.200
    66.314    -0.999     0.200
    66.824    -1.906     0.200
    70.301    -0.964     0.200
    70.349    -0.955     0.200
    70.645    -0.564     0.200
    70.651    -0.297     0.200
    70.683    -0.892     0.200
    70.795    -1.275     0.200
    70.900    -0.914     0.200
    71.021    -1.351     0.200
    71.088    -1.053     0.200
    71.362     1.710     0.200
    71.332    -0.230     0.200
    71.551     0.148     0.200
    72.340     0.219     0.200
    72.413    -0.419     0.200
    72.614    -0.914     0.200
    72.634    -0.311     0.200
    72.838     0.880     0.200
    72.868    -0.925     0.200
    72.939    -0.745     0.200
    72.968    -0.915     0.200
    73.353    -1.091     0.200
    73.498    -1.043     0.200
    73.572    -1.178     0.200
    73.654    -1.064     0.200
    73.683     0.169     0.200
    73.942    -0.449     0.200
    74.035     0.305     0.200
    74.195     0.075     0.200
    74.309     1.410     0.200
    74.351     0.164     0.200
    74.952    -0.816     0.200
    75.027    -0.353     0.200
    75.446    -0.562     0.200
    75.568    -0.461     0.200
    75.885    -0.471     0.200
    76.516    -0.659     0.200
    77.484    -1.863     0.200
    77.955     1.373     0.200
    78.827     0.003     0.200
    80.016    -0.423     0.200
    80.715    -0.179     0.200
    80.842    -0.361     0.200
    81.789    -0.323     0.200
    82.103    -0.540     0.200
    82.102    -0.666     0.200
    82.135    -0.198     0.200
    82.181    -0.581     0.200
    82.264    -0.666     0.200
    82.268    -0.594     0.200
    82.358    -0.315     0.200
    82.576    -0.752     0.200
    82.716    -0.892     0.200
    82.872    -0.933     0.200
    84.194    -0.683     0.200
    20.005     0.131     0.200
    32.032     1.480     0.200
    34.305     0.006     0.200
    45.232    -0.324     0.200
    45.396    -0.102     0.200
    52.601    -0.201     0.200
    20.257    -0.088     0.200
    20.553    -0.330     0.200
    23.795     1.636     0.200
    23.926     2.135     0.200
    25.427     2.151     0.200
    26.384     2.346     0.200
    26.810    -1.259     0.200
    26.969     1.800     0.200
    27.946     0.911     0.200
    28.245     1.899     0.200
    28.533     2.867     0.200
    29.865     1.274     0.200
    29.950     2.700     0.200
    29.948     2.828     0.200
    30.047     2.657     0.200
    30.128     2.971     0.200
    30.201     2.424     0.200
    30.425     3.472     0.200
    30.497     1.580     0.200
    30.700     2.868     0.200
    30.838     3.179     0.200
    31.260     2.416     0.200
    31.525     1.881     0.200
    31.614     1.855     0.200
    32.225     0.589     0.200
    32.302     1.853     0.200
    32.364     3.969     0.200
    32.424     1.898     0.200
    32.524     2.663     0.200
    33.280    -3.079     0.200
    33.188     3.006     0.200
    33.598     1.716     0.200
    33.610     3.404     0.200
    33.596     2.434     0.200
    33.667     2.378     0.200
    33.800     2.674     0.200
    34.794     1.434     0.200
    34.857     1.811     0.200
    34.934     2.535     0.200
    35.722     1.456     0.200
    35.743     1.548     0.200
    35.886     2.561     0.200
    36.627    -3.283     0.200
    37.902     0.150     0.200
    38.678     0.684     0.200
    38.716     2.527     0.200
    38.881     2.088     0.200
    39.212     2.191     0.200
    39.404     2.061     0.200
    39.597     0.887     0.200
    42.109     1.675     0.200
    42.911    -1.996     0.200
    43.226    -1.736     0.200
    43.125     0.829     0.200
    44.596    -1.576     0.200
    44.745     1.604     0.200
    44.745     1.736     0.200
    45.865     1.711     0.200
    46.079    -0.140     0.200
    48.336    -1.850     0.200
    48.363    -0.896     0.200
    48.397     0.086     0.200
    48.735    -2.369     0.200
    48.732     0.087     0.200
    48.740     0.256     0.200
    49.791    -1.779     0.200
    49.872     0.879     0.200
    50.014    -0.134     0.200
    52.168    -1.136     0.200
    52.940    -0.238     0.200
    53.184    -0.894     0.200
    53.396    -2.606     0.200
    53.411    -1.809     0.200
    54.076    -2.475     0.200
    54.884    -1.944     0.200
    55.154    -0.089     0.200
    55.214    -1.023     0.200
    57.220    -0.831     0.200
    57.240    -1.212     0.200
    58.844    -1.200     0.200
    58.876    -2.923     0.200
    59.149    -1.559     0.200
    60.865    -1.878     0.200
    60.866    -1.082     0.200
    61.392    -1.244     0.200
    61.392    -0.041     0.200
    61.537    -1.400     0.200
    62.472    -1.297     0.200
    62.638    -0.412     0.200
    62.773    -1.904     0.200
    62.951    -1.189     0.200
    63.536    -2.762     0.200
    65.422    -1.278     0.200
    65.510    -1.848     0.200
    66.293    -1.384     0.200
    66.725    -1.040     0.200
    66.854    -1.964     0.200
    67.545    -2.646     0.200
    68.489    -0.769     0.200
    68.970    -1.365     0.200
    69.084     3.529     0.200
    69.905    -0.035     0.200
    70.575    -0.832     0.200
    71.010    -0.119     0.200
    71.172     0.096     0.200
    71.191    -0.674     0.200
    71.494     0.457     0.200
    71.695    -0.213     0.200
    71.732    -0.136     0.200
    71.883    -1.037     0.200
    72.032    -1.135     0.200
    72.071     0.031     0.200
    72.191     0.614     0.200
    72.331    -1.023     0.200
    72.375    -0.183     0.200
    72.483    -0.230     0.200
    72.619    -0.832     0.200
    72.641     0.037     0.200
    72.676    -0.374     0.200
    72.686     0.368     0.200
    72.822    -0.242     0.200
    72.813    -0.089     0.200
    72.989     0.072     0.200
    73.348     0.651     0.200
    73.399    -0.151     0.200
    73.412    -0.025     0.200
    73.430    -0.731     0.200
    73.558    -0.085     0.200
    73.639    -0.160     0.200
    73.666    -0.014     0.200
    73.783     0.197     0.200
    73.966     0.231     0.200
    73.981    -0.460     0.200
    74.012    -0.439     0.200
    74.021     0.004     0.200
    74.021    -1.094     0.200
    74.033     0.038     0.200
    74.100     0.145     0.200
    74.158     0.204     0.200
    74.161    -0.808     0.200
    74.266    -0.323     0.200
    74.312    -0.689     0.200
    74.448     0.122     0.200
    74.477     0.354     0.200
    74.523    -0.218     0.200
    74.554    -0.896     0.200
    74.569     0.121     0.200
    74.706    -0.874     0.200
    74.726     0.107     0.200
    74.767    -1.030     0.200
    74.871    -0.932     0.200
    75.086    -0.067     0.200
    75.088     0.017     0.200
    75.396     1.651     0.200
    75.412    -0.244     0.200
    75.420     0.213     0.200
    75.518     1.346     0.200
    75.586     0.060     0.200
    75.719    -0.900     0.200
    75.850     0.351     0.200
    75.983    -1.504     0.200
    76.061     2.052     0.200
    76.080    -0.458     0.200
    76.089    -0.007     0.200
    76.169     0.153     0.200
    76.292     0.138     0.200
    76.290     0.451     0.200
    76.638    -0.522     0.200
    76.745    -0.220     0.200
    76.978     2.761     0.200
    77.050     0.459     0.200
    77.283    -0.243     0.200
    77.309     1.905     0.200
    77.422     0.776     0.200
    77.699    -0.474     0.200
    77.731     0.252     0.200
    77.745    -0.325     0.200
    77.813     1.996     0.200
    77.853     0.470     0.200
    77.916     1.821     0.200
    77.946    -1.046     0.200
    77.985    -0.658     0.200
    78.067    -0.516     0.200
    78.046     2.299     0.200
    78.097     0.218     0.200
    78.181    -0.645     0.200
    78.247    -0.311     0.200
    78.385    -0.374     0.200
    78.808     0.467     0.200
    79.070    -0.739     0.200
    79.614     1.298     0.200
    80.652    -1.298     0.200
    80.790     0.565     0.200
    80.953    -0.196     0.200
    80.972    -0.505     0.200
    81.165     0.466     0.200
    81.243     0.043     0.200
    81.331     0.116     0.200
    81.518    -0.335     0.200
    81.555    -0.381     0.200
    81.557    -0.308     0.200
    81.600    -0.285     0.200
    81.652    -0.612     0.200
    81.680    -0.569     0.200
    81.736     0.057     0.200
    81.738    -0.455     0.200
    81.732    -2.631     0.200
    81.771    -0.660     0.200
    81.778    -0.566     0.200
    81.809    -0.240     0.200
    81.832    -0.045     0.200
    81.943    -1.217     0.200
    81.993    -0.666     0.200
    82.216    -0.372     0.200
    82.253    -0.746     0.200
    82.313    -0.410     0.200
    82.460     0.151     0.200
    82.491    -1.206     0.200
    82.518    -0.831     0.200
    82.976     0.221     0.200
    83.368    -0.850     0.200
    84.005    -1.810     0.200
    91.636     0.685     0.200
    18.618    -1.219     0.200
    19.056    -1.495     0.200
    20.270    -0.464     0.200
    20.558    -0.989     0.200
    21.345     2.584     0.200
    21.399     2.620     0.200
    21.626     3.358     0.200
    21.806     2.285     0.200
    21.918     2.376     0.200
    22.233     2.414     0.200
    22.323     2.408     0.200
    22.367     1.849     0.200
    22.508     2.745     0.200
    22.753     1.652     0.200
    22.872     1.880     0.200
    23.046     1.643     0.200
    23.054     2.839     0.200
    23.297     2.095     0.200
    23.549     1.884     0.200
    23.585     1.425     0.200
    23.607     2.430     0.200
    23.720     2.710     0.200
    23.799     1.863     0.200
    23.917     3.155     0.200
    23.931     1.664     0.200
    23.970     2.430     0.200
    24.136     3.458     0.200
    24.249     2.171     0.200
    24.487     2.409     0.200
    24.798     1.687     0.200
    25.428     3.026     0.200
    25.584     3.163     0.200
    26.474    -3.250     0.200
    26.504     1.144     0.200
    26.506     2.612     0.200
    26.528     2.983     0.200
    26.806    -1.234     0.200
    26.835     0.829     0.200
    26.881     0.827     0.200
    26.971     2.485     0.200
    27.321     1.398     0.200
    27.568     0.193     0.200
    27.728     1.204     0.200
    27.770     1.581     0.200
    27.861     1.629     0.200
    27.886     1.728     0.200
    28.165    -2.099     0.200
    27.952     1.440     0.200
    27.961     2.394     0.200
    28.251     1.122     0.200
    28.381     1.655     0.200
    28.393     1.896     0.200
    28.416     1.585     0.200
    28.552     1.448     0.200
    28.611     2.429     0.200
    28.725    -0.099     0.200
    28.736     2.509     0.200
    28.956     1.872     0.200
    29.349    -3.220     0.200
    29.142     1.838     0.200
    29.198     2.352     0.200
    29.413     1.998     0.200
    29.475     2.404     0.200
    29.499     1.956     0.200
    29.629     1.480     0.200
    29.871     3.062     0.200
    29.917     2.014     0.200
    29.951     2.672     0.200
    30.052     2.620     0.200
    30.129     2.625     0.200
    30.202     2.534     0.200
    30.430     2.336     0.200
    30.501     2.255     0.200
    30.522     2.792     0.200
    30.839     3.071     0.200
    31.264     2.225     0.200
    31.400     2.771     0.200
    31.530     1.504     0.200
    31.530     1.573     0.200
    31.618     1.884     0.200
    31.651     2.124     0.200
    31.817     1.713     0.200
    32.226     2.045     0.200
    32.280     2.352     0.200
    32.303     2.362     0.200
    32.368     2.018     0.200
    32.424     2.437     0.200
    32.523     3.007     0.200
    33.287    -2.866     0.200
    33.084     1.972     0.200
    33.191     2.648     0.200
    33.605     1.680     0.200
    33.596     1.925     0.200
    33.614     2.502     0.200
    33.667     2.366     0.200
    33.836    -1.742     0.200
    33.801     2.498     0.200
    33.989     2.418     0.200
    34.227     0.289     0.200
    34.798     1.844     0.200
    34.857     1.702     0.200
    34.938     2.203     0.200
    35.727     1.742     0.200
    35.889     2.322     0.200
    35.975     2.936     0.200
    36.630    -4.168     0.200
    37.545     1.513     0.200
    37.912     0.197     0.200
    38.674    -2.136     0.200
    38.910    -2.711     0.200
    38.717     2.179     0.200
    38.884     1.642     0.200
    38.946     2.166     0.200
    39.215     2.760     0.200
    39.408     2.192     0.200
    39.603     1.212     0.200
    41.864    -0.549     0.200
    42.112     1.625     0.200
    42.910    -2.135     0.200
    43.241    -1.209     0.200
    43.130     0.885     0.200
    43.729     0.038     0.200
    43.743     0.389     0.200
    44.753    -0.511     0.200
    44.748     1.393     0.200
    44.748     1.388     0.200
    44.879    -0.812     0.200
    45.501    -3.062     0.200
    45.610    -0.648     0.200
    45.869     0.659     0.200
    46.086    -0.090     0.200
    46.099    -0.510     0.200
    46.582    -0.660     0.200
    46.954    -0.208     0.200
    47.302    -0.450     0.200
    47.406     0.502     0.200
    47.930     0.602     0.200
    48.017    -0.180     0.200
    48.330    -0.919     0.200
    48.330    -1.585     0.200
    48.330    -2.347     0.200
    48.370    -0.259     0.200
    48.402     0.831     0.200
    48.736    -2.445     0.200
    48.740     0.053     0.200
    48.748     0.180     0.200
    49.517    -0.713     0.200
    49.789    -2.512     0.200
    49.705    -0.677     0.200
    49.884    -0.159     0.200
    50.025    -0.442     0.200
    50.482    -0.633     0.200
    50.686    -0.158     0.200
    51.200    -0.566     0.200
    51.457     0.028     0.200
    51.680    -0.244     0.200
    51.821    -0.170     0.200
    52.166    -1.366     0.200
    52.130    -0.419     0.200
    52.421    -0.894     0.200
    52.949    -0.758     0.200
    53.180    -1.211     0.200
    53.046    -0.587     0.200
    53.200    -1.650     0.200
    53.230    -1.299     0.200
    53.400    -2.475     0.200
    53.425    -1.679     0.200
    53.808    -1.261     0.200
    53.937    -1.656     0.200
    54.080    -1.546     0.200
    53.936    -0.284     0.200
    54.513     0.997     0.200
    54.452    -0.183     0.200
    54.461    -0.106     0.200
    54.570    -0.421     0.200
    54.577    -0.045     0.200
    54.650     4.414     0.200
    54.897    -1.380     0.200
    55.158    -1.158     0.200
    55.272    -1.181     0.200
    55.773     1.106     0.200
    55.924    -1.758     0.200
    56.511    -0.405     0.200
    57.219    -1.963     0.200
    57.239    -1.840     0.200
    58.412     1.669     0.200
    58.845    -1.237     0.200
    58.884    -3.111     0.200
    59.589     1.254     0.200
    59.692    -1.797     0.200
    59.771    -1.336     0.200
    60.252    -1.036     0.200
    60.865    -0.912     0.200
    60.879    -1.206     0.200
    61.407    -1.276     0.200
    61.407    -0.952     0.200
    61.589    -1.006     0.200
    61.552    -1.430     0.200
    61.703    -0.878     0.200
    62.057    -2.454     0.200
    62.486    -1.127     0.200
    62.653    -0.326     0.200
    62.784    -1.506     0.200
    62.966    -1.118     0.200
    63.547    -2.665     0.200
    63.865    -1.959     0.200
    64.113    -1.890     0.200
    65.424    -1.823     0.200
    65.509    -1.777     0.200
    65.584    -1.459     0.200
    65.736    -2.238     0.200
    65.771     0.834     0.200
    66.199    -1.696     0.200
    66.294    -1.020     0.200
    66.730    -0.805     0.200
    66.867    -2.377     0.200
    67.558    -2.757     0.200
    68.370    -0.052     0.200
    68.503     0.014     0.200
    68.984    -0.681     0.200
    69.948    -0.189     0.200
    70.447     0.414     0.200
    70.575    -1.460     0.200
    70.709     1.221     0.200
    70.730    -2.106     0.200
    71.026    -0.969     0.200
    71.187     0.812     0.200
    71.206    -0.490     0.200
    71.494    -1.226     0.200
    71.534    -1.370     0.200
    71.710    -0.231     0.200
    71.747    -0.354     0.200
    71.851     0.021     0.200
    71.897    -0.254     0.200
    72.030    -0.550     0.200
    71.969    -0.682     0.200
    72.048    -1.356     0.200
    72.136    -1.180     0.200
    72.133     1.776     0.200
    72.179    -0.837     0.200
    72.207     1.395     0.200
    72.351    -1.166     0.200
    72.271    -1.390     0.200
    72.347    -1.142     0.200
    72.390     0.101     0.200
    72.392    -0.913     0.200
    72.499     1.552     0.200
    72.634    -0.349     0.200
    72.656     0.219     0.200
    72.690    -0.685     0.200
    72.812    -0.809     0.200
    72.757     1.117     0.200
    72.837     1.245     0.200
    73.001    -0.823     0.200
    73.362     0.741     0.200
    73.414     0.435     0.200
    73.428     1.458     0.200
    73.445    -0.343     0.200
    73.502    -1.381     0.200
    73.510     1.044     0.200
    73.573     1.500     0.200
    73.655     1.223     0.200
    73.739    -2.673     0.200
    73.681    -0.230     0.200
    73.708    -1.216     0.200
    73.705     0.027     0.200
    73.785    -2.943     0.200
    73.788    -1.259     0.200
    73.798     1.880     0.200
    73.981     1.515     0.200
    73.996    -0.677     0.200
    74.027     1.045     0.200
    74.037    -1.310     0.200
    74.048     1.421     0.200
    74.176    -1.122     0.200
    74.198    -0.654     0.200
    74.327    -1.002     0.200
    74.463     1.505     0.200
    74.492     1.041     0.200
    74.583    -0.989     0.200
    74.721    -1.089     0.200
    74.741     0.597     0.200
    74.783    -1.347     0.200
    74.887    -1.046     0.200
    74.904     1.552     0.200
    74.970    -0.326     0.200
    75.101     0.022     0.200
    75.103    -0.195     0.200
    75.125    -0.918     0.200
    75.337     0.778     0.200
    75.427    -0.057     0.200
    75.411     2.237     0.200
    75.435     0.400     0.200
    75.534     1.832     0.200
    75.602     1.147     0.200
    75.735    -1.114     0.200
    75.875    -1.016     0.200
    75.832     0.008     0.200
    75.996    -0.708     0.200
    75.962    -0.611     0.200
    76.005     1.244     0.200
    76.076     2.139     0.200
    76.095    -0.168     0.200
    76.104     0.079     0.200
    76.101     1.297     0.200
    76.078     0.847     0.200
    76.185    -0.278     0.200
    76.307     0.088     0.200
    76.305     0.239     0.200
    76.519    -0.274     0.200
    76.654    -0.632     0.200
    76.760    -0.431     0.200
    76.744    -0.011     0.200
    76.794    -0.427     0.200
    76.868     0.711     0.200
    76.806     0.925     0.200
    77.324    -0.402     0.200
    77.268    -1.283     0.200
    77.280     1.734     0.200
    77.298    -0.255     0.200
    77.325     1.796     0.200
    77.424     0.638     0.200
    77.348     0.495     0.200
    77.345     1.668     0.200
    77.535    -0.099     0.200
    77.508     1.917     0.200
    77.555     0.776     0.200
    77.629     1.194     0.200
    77.715     0.115     0.200
    77.755     2.393     0.200
    77.761    -0.439     0.200
    77.828     2.088     0.200
    77.869     1.460     0.200
    77.932     1.912     0.200
    77.948     1.721     0.200
    78.000    -0.867     0.200
    78.079    -0.907     0.200
    78.039     1.814     0.200
    78.061     1.793     0.200
    78.163    -0.871     0.200
    78.096     2.102     0.200
    78.120    -0.136     0.200
    78.168     0.641     0.200
    78.196    -0.655     0.200
    78.262    -0.520     0.200
    78.310     2.418     0.200
    78.413    -0.150     0.200
    78.401    -0.583     0.200
    78.481     2.053     0.200
    78.497    -1.115     0.200
    78.554     0.523     0.200
    78.742     1.027     0.200
    78.823     0.979     0.200
    78.877     0.214     0.200
    78.941    -2.657     0.200
    78.954     0.110     0.200
    79.100    -1.027     0.200
    79.082     0.073     0.200
    79.327     0.722     0.200
    79.359     0.706     0.200
    79.543    -0.442     0.200
    79.553    -0.028     0.200
    79.902     0.472     0.200
    79.940    -1.034     0.200
    80.032    -0.411     0.200
    80.051    -1.230     0.200
    80.160     0.169     0.200
    80.160    -0.359     0.200
    80.312    -1.045     0.200
    80.411    -1.128     0.200
    80.391    -0.442     0.200
    80.445    -1.311     0.200
    80.466    -0.926     0.200
    80.571    -0.956     0.200
    80.805     0.561     0.200
    80.842     0.595     0.200
    80.956    -0.243     0.200
    80.910    -1.399     0.200
    80.971     2.058     0.200
    80.986    -0.204     0.200
    81.175     0.293     0.200
    81.132    -0.682     0.200
    81.246    -0.304     0.200
    81.226     2.652     0.200
    81.334     0.146     0.200
    81.333    -0.045     0.200
    81.374    -0.265     0.200
    81.356     0.334     0.200
    81.421    -0.209     0.200
    81.459     0.515     0.200
    81.603    -0.315     0.200
    81.562    -0.259     0.200
    81.684    -0.440     0.200
    81.667     0.191     0.200
    81.740     0.204     0.200
    81.741    -0.423     0.200
    81.776    -0.563     0.200
    81.781    -0.472     0.200
    81.746     0.579     0.200
    81.835    -0.118     0.200
    81.824    -1.036     0.200
    81.833    -0.082     0.200
    81.947    -0.945     0.200
    81.890    -0.184     0.200
    81.881     0.951     0.200
    81.997    -0.587     0.200
    82.026    -0.143     0.200
    81.993    -0.086     0.200
    82.126    -1.265     0.200
    82.125    -0.732     0.200
    82.170    -1.334     0.200
    82.181    -0.231     0.200
    82.257    -0.610     0.200
    82.317    -0.282     0.200
    82.470    -0.018     0.200
    82.523    -0.814     0.200
    82.430     0.168     0.200
    82.547     0.049     0.200
    82.549    -0.321     0.200
    82.636     0.114     0.200
    82.677    -1.701     0.200
    82.746    -0.046     0.200
    82.883    -0.847     0.200
    82.921    -0.720     0.200
    82.990    -0.020     0.200
    83.064    -1.597     0.200
    82.975     0.004     0.200
    83.128    -0.232     0.200
    83.367    -1.017     0.200
    83.381     0.702     0.200
    83.632    -1.063     0.200
    83.876    -0.873     0.200
    83.956    -1.122     0.200
    84.217    -0.169     0.200
    85.466     0.713     0.200
    85.809     2.012     0.200
    87.620    -4.079     0.200
    88.221    -0.443     0.200
    93.615    -1.768     0.200
    19.466    -0.194     0.200
    19.891    -1.436     0.200
    23.122     1.840     0.200
    26.020     0.730     0.200
    29.205     2.229     0.200
    29.248     2.829     0.200
    29.632     3.094     0.200
    30.730     1.815     0.200
    32.430     2.211     0.200
    32.442     2.742     0.200
    32.847     2.029     0.200
    33.374     0.118     0.200
    33.618    -2.321     0.200
    34.027     1.781     0.200
    34.167     2.618     0.200
    35.158     1.225     0.200
    38.650     2.319     0.200
    41.406    -0.671     0.200
    42.324     0.950     0.200
    42.878    -0.579     0.200
    44.000     1.576     0.200
    44.000     1.990     0.200
    44.831    -0.385     0.200
    45.090     1.074     0.200
    47.906    -0.300     0.200
    49.377    -1.613     0.200
    50.508    -1.657     0.200
    51.574    -0.592     0.200
    53.035    -2.330     0.200
    53.250    -1.633     0.200
    53.951    -0.751     0.200
    57.931    -0.853     0.200
    59.509    -1.545     0.200
    59.501    -0.291     0.200
    60.710    -1.679     0.200
    61.118    -1.454     0.200
    61.118    -1.102     0.200
    61.380    -1.230     0.200
    62.208    -1.222     0.200
    62.303    -1.742     0.200
    63.664    -2.046     0.200
    64.845    -0.788     0.200
    64.853    -1.292     0.200
    66.008    -1.062     0.200
    66.192    -1.050     0.200
    66.929    -0.559     0.200
    67.185     0.814     0.200
    67.482    -1.570     0.200
    71.240    -1.028     0.200
    71.422    -0.130     0.200
    71.437    -0.223     0.200
    71.631    -0.392     0.200
    71.850    -1.005     0.200
    71.918    -0.517     0.200
    72.340    -0.044     0.200
    72.457     0.565     0.200
    72.695    -0.444     0.200
    73.120    -0.575     0.200
    73.147    -0.733     0.200
    73.180    -0.131     0.200
    73.414    -1.039     0.200
    73.423    -0.467     0.200
    73.595    -0.278     0.200
    73.676    -0.650     0.200
    73.770    -0.403     0.200
    73.786    -0.499     0.200
    73.933    -0.565     0.200
    74.173    -0.664     0.200
    74.320    -0.619     0.200
    74.391    -0.829     0.200
    74.479    -0.747     0.200
    74.754    -0.139     0.200
    75.002     0.893     0.200
    75.536    -0.349     0.200
    75.937     0.761     0.200
    76.264    -0.305     0.200
    76.382     0.025     0.200
    77.271     0.217     0.200
    77.343    -0.293     0.200
    77.998     1.252     0.200
    78.087    -0.829     0.200
    79.673     0.294     0.200
    81.876    -0.331     0.200
    82.136    -0.876     0.200
    82.209    -1.043     0.200
    82.260    -0.458     0.200
    82.367    -0.672     0.200
    82.427    -0.683     0.200
    82.690     1.205     0.200
    82.738    -0.443     0.200
    82.893    -0.124     0.200
    84.059    -0.897     0.200
    18.645    -2.434     0.200
    19.082    -2.356     0.200
    19.082    -2.607     0.200
    20.223     0.211     0.200
    20.541    -1.137     0.200
    20.855     2.840     0.200
    21.185     3.102     0.200
    21.331     2.743     0.200
    21.382     2.852     0.200
    21.449     2.326     0.200
    21.611     3.451     0.200
    21.794     3.396     0.200
    21.903     2.679     0.200
    21.956     2.667     0.200
    22.223     2.675     0.200
    22.261     2.791     0.200
    22.309     2.802     0.200
    22.317     2.937     0.200
    22.354     2.567     0.200
    22.496     2.870     0.200
    22.736     2.081     0.200
    22.859     2.391     0.200
    22.905     2.340     0.200
    23.029     1.944     0.200
    23.046     3.027     0.200
    23.287     2.546     0.200
    23.305     1.981     0.200
    23.533     2.193     0.200
    23.566     1.543     0.200
    23.596     2.673     0.200
    23.707     2.335     0.200
    23.726     0.872     0.200
    23.784     2.035     0.200
    23.890     2.138     0.200
    23.911     3.296     0.200
    23.910     1.597     0.200
    24.782     1.982     0.200
    25.409     0.314     0.200
    25.415     1.723     0.200
    25.423     1.328     0.200
    25.750     1.767     0.200
    25.880     1.639     0.200
    26.046     1.497     0.200
    26.382     0.975     0.200
    26.482     1.314     0.200
    26.499     2.542     0.200
    26.822    -1.433     0.200
    26.813     0.988     0.200
    26.859     1.140     0.200
    26.961     2.336     0.200
    27.006     1.558     0.200
    27.298     1.790     0.200
    27.365     1.776     0.200
    27.546     0.690     0.200
    27.680    -0.408     0.200
    27.706     1.065     0.200
    27.749     1.839     0.200
    27.876    -0.274     0.200
    27.858     1.482     0.200
    27.865     1.532     0.200
    28.166    -1.058     0.200
    27.931     1.605     0.200
    27.961     2.356     0.200
    28.171    -0.371     0.200
    28.230     1.063     0.200
    28.362     1.575     0.200
    28.377     1.860     0.200
    28.393     1.605     0.200
    28.434    -0.106     0.200
    28.517     1.184     0.200
    28.531     1.660     0.200
    28.641     0.587     0.200
    28.647     1.998     0.200
    28.656     0.549     0.200
    28.686     1.116     0.200
    28.760     2.133     0.200
    28.801     1.485     0.200
    28.934     2.136     0.200
    29.061     1.974     0.200
    29.368    -4.338     0.200
    29.122     1.766     0.200
    29.198     1.892     0.200
    29.220     2.199     0.200
    29.410     1.738     0.200
    29.452     2.567     0.200
    29.607     1.899     0.200
    29.850     2.825     0.200
    29.880     2.218     0.200
    29.917     1.609     0.200
    29.940     2.491     0.200
    29.938     2.787     0.200
    30.004     2.771     0.200
    30.124     2.566     0.200
    30.196     2.322     0.200
    30.395     3.001     0.200
    30.485     2.509     0.200
    30.687     1.542     0.200
    30.835     3.253     0.200
    31.248     2.117     0.200
    31.400     2.899     0.200
    31.511     1.443     0.200
    31.511     1.565     0.200
    31.636     1.900     0.200
    31.802     1.672     0.200
    32.224     1.483     0.200
    32.265     2.622     0.200
    32.298     2.544     0.200
    32.354     1.950     0.200
    32.523     2.210     0.200
    33.263    -2.605     0.200
    33.074     1.894     0.200
    33.180     2.781     0.200
    33.580     1.776     0.200
    33.595     2.091     0.200
    33.600     2.263     0.200
    33.784    -1.143     0.200
    34.191     0.406     0.200
    34.855     1.291     0.200
    35.708     1.796     0.200
    35.819     2.353     0.200
    35.879     1.961     0.200
    36.032     0.895     0.200
    36.179    -0.203     0.200
    36.174     2.067     0.200
    36.215     2.723     0.200
    36.620    -2.734     0.200
    36.387     2.498     0.200
    36.393     2.454     0.200
    36.481     1.897     0.200
    36.769     1.895     0.200
    37.285     1.714     0.200
    37.440     2.657     0.200
    37.593    -0.158     0.200
    37.876    -0.049     0.200
    38.689    -1.519     0.200
    38.930    -2.536     0.200
    38.710     1.835     0.200
    38.870     1.704     0.200
    38.933     2.289     0.200
    39.202     2.389     0.200
    39.268     2.184     0.200
    39.395     2.084     0.200
    39.580     0.959     0.200
    40.627    -1.231     0.200
    41.831    -1.308     0.200
    42.916    -2.341     0.200
    43.189    -2.045     0.200
    43.680    -0.614     0.200
    43.680     0.125     0.200
    43.689     0.021     0.200
    43.841     0.703     0.200
    44.736     1.068     0.200
    44.736     1.648     0.200
    44.850    -0.164     0.200
    45.489    -3.326     0.200
    45.561     0.055     0.200
    45.853     0.038     0.200
    46.062    -0.328     0.200
    46.069    -0.755     0.200
    46.404    -0.684     0.200
    47.111    -1.758     0.200
    47.271    -0.614     0.200
    47.592    -0.605     0.200
    47.601    -0.650     0.200
    47.975     0.035     0.200
    47.988    -0.584     0.200
    48.352    -1.655     0.200
    48.352    -1.276     0.200
    48.343    -0.109     0.200
    48.383     1.445     0.200
    48.735    -1.926     0.200
    49.476    -0.408     0.200
    49.605     0.133     0.200
    49.797    -1.929     0.200
    49.657    -0.790     0.200
    49.669    -0.681     0.200
    49.695    -0.884     0.200
    49.844    -0.139     0.200
    49.987    -0.375     0.200
    50.440    -0.141     0.200
    50.618    -0.904     0.200
    50.644    -0.302     0.200
    51.165    -0.188     0.200
    51.333    -0.396     0.200
    51.639    -0.082     0.200
    51.781    -0.052     0.200
    51.880    -0.686     0.200
    52.174    -1.386     0.200
    52.089     0.130     0.200
    52.188     0.134     0.200
    52.342     1.566     0.200
    52.391    -1.261     0.200
    52.503     1.396     0.200
    53.195    -1.575     0.200
    53.029    -0.516     0.200
    53.153    -1.533     0.200
    53.013    -0.541     0.200
    53.182    -2.092     0.200
    53.389    -2.150     0.200
    53.377    -1.944     0.200
    53.377    -1.909     0.200
    53.889    -2.038     0.200
    54.068    -0.521     0.200
    53.904    -0.263     0.200
    53.927     1.905     0.200
    54.463     0.647     0.200
    54.463     3.576     0.200
    54.641     0.665     0.200
    54.856     0.158     0.200
    55.145     0.172     0.200
    55.342    -2.349     0.200
    55.053     0.052     0.200
    55.076     0.363     0.200
    55.244     0.505     0.200
    55.165    -3.162     0.200
    55.526    -1.662     0.200
    55.263     1.149     0.200
    55.276     0.325     0.200
    55.350     0.678     0.200
    55.472     1.876     0.200
    55.481     0.660     0.200
    55.711    -0.179     0.200
    55.764     1.641     0.200
    56.461    -0.514     0.200
    56.742     0.552     0.200
    57.224    -1.758     0.200
    57.244    -1.191     0.200
    56.990     0.095     0.200
    57.600    -1.309     0.200
    57.947    -1.765     0.200
    58.403     2.474     0.200
    58.846    -1.108     0.200
    58.860    -3.208     0.200
    59.700    -1.214     0.200
    59.771    -1.499     0.200
    60.246    -0.433     0.200
    60.234    -0.003     0.200
    60.869    -2.002     0.200
    60.745    -0.846     0.200
    60.787     0.745     0.200
    60.832    -1.851     0.200
    60.899    -0.206     0.200
    61.356    -1.401     0.200
    61.356    -1.287     0.200
    61.353    -1.093     0.200
    61.413    -0.827     0.200
    61.440    -0.727     0.200
    61.440     2.593     0.200
    61.603    -0.266     0.200
    61.466    -0.520     0.200
    61.504    -1.576     0.200
    61.564    -1.135     0.200
    61.708    -0.835     0.200
    61.764    -0.878     0.200
    61.794    -0.862     0.200
    61.811    -0.859     0.200
    61.845    -0.826     0.200
    62.069    -2.099     0.200
    61.985    -0.816     0.200
    61.998    -0.871     0.200
    62.036    -0.818     0.200
    62.067    -0.825     0.200
    62.145    -0.858     0.200
    62.197    -0.869     0.200
    62.331    -0.824     0.200
    62.357    -0.864     0.200
    62.439    -1.674     0.200
    62.526    -0.249     0.200
    62.564    -0.818     0.200
    62.573    -0.288     0.200
    62.749    -2.439     0.200
    62.534    -0.207     0.200
    62.784    -0.862     0.200
    62.876    -0.866     0.200
    63.127    -1.651     0.200
    62.996    -0.886     0.200
    63.041    -0.519     0.200
    63.038    -0.865     0.200
    63.133    -1.191     0.200
    63.133    -0.861     0.200
    63.343    -0.994     0.200
    63.511    -3.694     0.200
    63.841    -2.165     0.200
    63.790    -0.734     0.200
    64.084    -2.361     0.200
    64.032    -0.721     0.200
    64.072    -0.782     0.200
    64.197    -0.406     0.200
    64.278    -0.537     0.200
    64.278    -0.817     0.200
    64.429    -0.812     0.200
    64.455    -0.812     0.200
    64.509    -0.815     0.200
    64.577    -0.682     0.200
    64.533    -0.810     0.200
    64.643    -0.517     0.200
    64.643    -0.657     0.200
    64.674    -0.224     0.200
    64.678    -0.815     0.200
    64.740    -0.654     0.200
    64.740    -0.824     0.200
    64.783    -0.733     0.200
    64.810    -0.406     0.200
    64.943    -0.736     0.200
    65.122    -0.698     0.200
    65.221    -0.679     0.200
    65.281    -0.618     0.200
    65.513    -2.265     0.200
    65.396    -0.741     0.200
    65.594    -1.286     0.200
    65.434    -0.624     0.200
    65.443    -0.382     0.200
    65.488    -0.613     0.200
    65.532    -0.596     0.200
    65.694    -1.536     0.200
    65.720     0.298     0.200
    65.702    -0.623     0.200
    65.759    -0.309     0.200
    65.771    -0.620     0.200
    65.773    -0.719     0.200
    65.916    -0.362     0.200
    65.952    -0.611     0.200
    65.988    -0.743     0.200
    66.178    -2.051     0.200
    66.049    -0.606     0.200
    66.090    -1.781     0.200
    66.090    -0.741     0.200
    66.293    -1.779     0.200
    66.320    -1.462     0.200
    66.164    -0.615     0.200
    66.256    -0.615     0.200
    66.714    -1.470     0.200
    66.763    -0.079     0.200
    66.823    -1.466     0.200
    66.786    -0.128     0.200
    66.848    -0.602     0.200
    66.874    -1.985     0.200
    66.874    -0.745     0.200
    66.947    -0.312     0.200
    66.965    -0.967     0.200
    67.095     0.206     0.200
    67.094     1.813     0.200
    67.147    -0.531     0.200
    67.354    -0.734     0.200
    67.515    -2.347     0.200
    67.480    -0.301     0.200
    67.589    -1.174     0.200
    67.527    -0.275     0.200
    67.658    -0.293     0.200
    67.887    -0.891     0.200
    67.960     0.638     0.200
    67.964    -0.227     0.200
    68.014    -0.302     0.200
    68.061    -1.334     0.200
    68.017    -0.511     0.200
    68.017    -0.621     0.200
    68.021    -0.225     0.200
    68.185    -0.334     0.200
    68.319     0.099     0.200
    68.319    -0.302     0.200
    68.445    -0.217     0.200
    68.479    -0.355     0.200
    68.483     0.070     0.200
    68.670     0.009     0.200
    68.936    -1.150     0.200
    68.936    -1.290     0.200
    69.077    -0.663     0.200
    69.115     0.009     0.200
    69.141    -0.338     0.200
    69.156    -0.213     0.200
    69.196    -0.340     0.200
    69.391     0.011     0.200
    69.669     0.322     0.200
    69.679    -0.332     0.200
    69.614    -1.670     0.200
    69.736     0.067     0.200
    69.735    -0.485     0.200
    69.735    -0.325     0.200
    69.774    -0.327     0.200
    69.779    -0.345     0.200
    69.803    -0.335     0.200
    69.804    -0.321     0.200
    69.829    -0.333     0.200
    69.724    -0.764     0.200
    69.857    -0.327     0.200
    69.896    -0.306     0.200
    69.893    -0.328     0.200
    69.900    -0.340     0.200
    69.916    -0.328     0.200
    70.000    -0.292     0.200
    70.050     0.111     0.200
    69.942    -0.981     0.200
    69.960    -1.951     0.200
    70.032    -0.762     0.200
    70.191    -1.099     0.200
    70.393    -0.547     0.200
    70.396     0.560     0.200
    70.577    -1.740     0.200
    70.412    -1.214     0.200
    70.688    -2.215     0.200
    70.972     1.060     0.200
    70.974     0.177     0.200
    71.155    -0.253     0.200
    71.253    -0.344     0.200
    71.260    -0.386     0.200
    71.304    -0.250     0.200
    71.306    -0.293     0.200
    71.481    -0.521     0.200
    71.481     0.068     0.200
    71.660    -0.494     0.200
    71.696    -0.115     0.200
    71.800     0.264     0.200
    71.847    -1.022     0.200
    71.847    -0.022     0.200
    72.052    -1.549     0.200
    71.915    -0.529     0.200
    71.915    -0.029     0.200
    72.112     0.191     0.200
    71.995    -0.807     0.200
    72.081     0.458     0.200
    72.126    -0.487     0.200
    72.126     0.013     0.200
    72.155     0.157     0.200
    72.369     0.460     0.200
    72.328    -0.296     0.200
    72.218    -0.942     0.200
    72.218    -0.272     0.200
    72.294    -0.593     0.200
    72.294    -0.193     0.200
    72.340     0.431     0.200
    72.447     0.363     0.200
    72.494     0.914     0.200
    72.584    -0.018     0.200
    72.605     0.455     0.200
    72.605     0.455     0.200
    72.641    -0.262     0.200
    72.649     0.240     0.200
    72.819    -1.013     0.200
    72.708     0.042     0.200
    72.951    -0.799     0.200
    72.952     0.194     0.200
    72.981    -0.275     0.200
    73.009     0.459     0.200
    73.213    -1.145     0.200
    73.314     0.058     0.200
    73.314    -0.092     0.200
    73.338     0.517     0.200
    73.364    -0.234     0.200
    73.395     0.081     0.200
    73.458     0.210     0.200
    73.473     0.125     0.200
    73.783    -1.699     0.200
    73.629     0.105     0.200
    73.807    -1.839     0.200
    73.657     0.140     0.200
    73.657    -0.706     0.200
    73.654    -0.938     0.200
    73.736    -0.521     0.200
    73.747     0.257     0.200
    73.929     0.267     0.200
    73.944    -0.237     0.200
    73.985     0.125     0.200
    73.985    -0.576     0.200
    73.897    -0.732     0.200
    74.064    -0.078     0.200
    74.122     0.221     0.200
    74.123    -0.486     0.200
    74.145    -0.412     0.200
    74.230    -0.206     0.200
    74.275    -0.466     0.200
    74.418    -0.401     0.200
    74.411     0.059     0.200
    74.440     0.073     0.200
    74.447     0.231     0.200
    74.475     0.272     0.200
    74.497     0.044     0.200
    74.533     0.530     0.200
    74.450     2.213     0.200
    74.517    -0.674     0.200
    74.622     0.019     0.200
    74.630     0.072     0.200
    74.669    -0.653     0.200
    74.691    -0.080     0.200
    74.730    -0.710     0.200
    74.808     0.339     0.200
    74.834    -0.610     0.200
    74.853     0.281     0.200
    74.919     0.201     0.200
    74.980     0.050     0.200
    74.973    -0.611     0.200
    75.100    -0.342     0.200
    75.159     0.514     0.200
    75.024     0.394     0.200
    75.035     0.328     0.200
    75.050     0.146     0.200
    75.052    -0.268     0.200
    75.073    -0.087     0.200
    75.104     0.533     0.200
    75.171     0.448     0.200
    75.184     0.370     0.200
    75.193     0.419     0.200
    75.193     0.519     0.200
    75.205     0.452     0.200
    75.286     0.787     0.200
    75.289     0.770     0.200
    75.342     0.264     0.200
    75.493     0.398     0.200
    75.377    -0.536     0.200
    75.359     0.669     0.200
    75.384     0.024     0.200
    75.448     0.255     0.200
    75.474     0.610     0.200
    75.470     0.733     0.200
    75.481     0.266     0.200
    75.735    -1.283     0.200
    75.601     0.681     0.200
    75.601     0.781     0.200
    75.682    -0.782     0.200
    75.713     0.742     0.200
    75.879    -1.809     0.200
    75.731     0.835     0.200
    75.762     0.759     0.200
    75.762     0.859     0.200
    75.815    -0.440     0.200
    75.779     0.406     0.200
    75.858     1.109     0.200
    75.858     1.210     0.200
    75.909     0.220     0.200
    75.950    -1.213     0.200
    75.909    -0.375     0.200
    75.949    -0.017     0.200
    75.953     1.071     0.200
    75.955     2.860     0.200
    76.023     0.570     0.200
    76.045     0.249     0.200
    76.024     0.056     0.200
    76.133    -0.153     0.200
    76.256    -0.449     0.200
    76.277     0.627     0.200
    76.397    -0.751     0.200
    76.339     0.958     0.200
    76.371     0.595     0.200
    76.469    -0.619     0.200
    76.468    -0.155     0.200
    76.459     0.799     0.200
    76.506    -0.867     0.200
    76.740     0.113     0.200
    76.581    -0.390     0.200
    76.601    -0.305     0.200
    76.662     0.572     0.200
    76.707    -0.502     0.200
    76.682     1.440     0.200
    76.708    -0.007     0.200
    76.690     0.175     0.200
    76.744    -1.214     0.200
    76.611     0.566     0.200
    76.779    -0.407     0.200
    76.801    -0.665     0.200
    76.825    -0.270     0.200
    76.825     1.431     0.200
    76.814     0.904     0.200
    76.800     0.862     0.200
    76.963    -0.276     0.200
    77.013     0.672     0.200
    77.109    -0.767     0.200
    77.096    -0.312     0.200
    77.337    -1.043     0.200
    77.205     0.097     0.200
    77.217    -1.171     0.200
    77.187    -0.406     0.200
    77.227     1.303     0.200
    77.261     1.584     0.200
    77.417    -0.293     0.200
    77.274     0.180     0.200
    77.464    -1.754     0.200
    77.420     0.492     0.200
    77.562    -0.801     0.200
    77.415    -0.180     0.200
    77.488     0.114     0.200
    77.449     0.732     0.200
    77.455     0.198     0.200
    77.464     0.747     0.200
    77.503    -0.163     0.200
    77.526     0.800     0.200
    77.558    -0.807     0.200
    77.578    -0.499     0.200
    77.588    -0.817     0.200
    77.623     0.359     0.200
    77.576     0.632     0.200
    77.598     0.657     0.200
    77.615     0.701     0.200
    77.716    -1.156     0.200
    77.662     0.243     0.200
    77.703    -1.113     0.200
    77.694    -0.933     0.200
    77.703     1.016     0.200
    77.751     0.648     0.200
    77.708    -0.312     0.200
    77.731     1.055     0.200
    77.782    -1.527     0.200
    77.793    -1.589     0.200
    77.747     0.670     0.200
    77.776     0.607     0.200
    77.781     0.882     0.200
    77.817     0.881     0.200
    77.858    -0.949     0.200
    77.996    -0.713     0.200
    77.842     0.242     0.200
    77.918    -0.282     0.200
    77.879     0.533     0.200
    77.895     0.148     0.200
    77.911     0.359     0.200
    77.909     0.966     0.200
    77.910     1.063     0.200
    77.920    -0.492     0.200
    77.948    -0.449     0.200
    77.958    -0.497     0.200
    78.039    -0.551     0.200
    77.987     0.334     0.200
    78.009     0.612     0.200
    78.010     0.708     0.200
    78.072    -1.134     0.200
    78.044     0.821     0.200
    78.040     0.343     0.200
    78.061     0.127     0.200
    78.082     0.106     0.200
    78.116    -0.572     0.200
    78.103     1.592     0.200
    78.151     0.524     0.200
    78.210    -0.199     0.200
    78.095    -0.266     0.200
    78.276    -0.763     0.200
    78.257     0.737     0.200
    78.293    -0.360     0.200
    78.238     0.245     0.200
    78.375     0.190     0.200
    78.299     0.209     0.200
    78.376    -0.817     0.200
    78.348    -0.265     0.200
    78.398     0.210     0.200
    78.394     0.480     0.200
    78.446    -1.262     0.200
    78.456    -0.739     0.200
    78.456    -0.589     0.200
    78.500     0.266     0.200
    78.524     0.164     0.200
    78.759     4.073     0.200
    78.590     0.601     0.200
    78.620    -0.663     0.200
    78.620     0.687     0.200
    78.530    -0.466     0.200
    78.650     0.073     0.200
    78.722    -0.724     0.200
    78.632     1.369     0.200
    78.632     3.569     0.200
    78.842    -1.183     0.200
    78.824     0.605     0.200
    78.702    -0.615     0.200
    78.743     0.009     0.200
    78.904     0.280     0.200
    79.130    -0.957     0.200
    79.042     0.521     0.200
    79.144    -0.337     0.200
    79.136     0.468     0.200
    79.159     0.182     0.200
    79.168     0.133     0.200
    79.308    -0.154     0.200
    79.273     0.928     0.200
    79.391     0.536     0.200
    79.493    -0.940     0.200
    79.504    -0.129     0.200
    79.358     0.057     0.200
    79.358     3.298     0.200
    79.578     0.200     0.200
    79.466    -0.531     0.200
    79.712    -1.126     0.200
    79.580    -0.560     0.200
    79.674     0.378     0.200
    79.761     0.207     0.200
    79.633    -0.888     0.200
    79.642     0.043     0.200
    79.849    -0.139     0.200
    79.835     0.909     0.200
    79.890    -1.275     0.200
    79.864    -0.324     0.200
    79.866     0.035     0.200
    79.983    -1.285     0.200
    79.984    -0.798     0.200
    80.001    -1.324     0.200
    80.079     0.286     0.200
    80.048     1.054     0.200
    80.106    -0.077     0.200
    80.107     0.369     0.200
    80.262    -1.821     0.200
    80.213     0.163     0.200
    80.363    -0.639     0.200
    80.341    -1.504     0.200
    80.396    -1.537     0.200
    80.418    -0.439     0.200
    80.319    -2.457     0.200
    80.580    -0.805     0.200
    80.650    -1.178     0.200
    80.521    -1.521     0.200
    80.608     0.154     0.200
    80.754    -0.858     0.200
    80.948    -0.732     0.200
    80.789     0.539     0.200
    80.802     0.208     0.200
    80.868     0.653     0.200
    80.860    -1.524     0.200
    80.927     0.339     0.200
    80.937    -0.715     0.200
    80.801     0.015     0.200
    81.152    -0.758     0.200
    81.143    -0.810     0.200
    81.084     0.003     0.200
    81.050     0.288     0.200
    81.236    -0.224     0.200
    80.975    -1.413     0.200
    81.239    -0.119     0.200
    81.139     0.121     0.200
    81.221     0.277     0.200
    81.325    -0.335     0.200
    81.191     0.336     0.200
    81.285    -0.063     0.200
    81.296     0.082     0.200
    81.327     0.216     0.200
    81.303     0.354     0.200
    81.445    -2.407     0.200
    81.345    -0.321     0.200
    81.301     0.351     0.200
    81.373    -0.026     0.200
    81.513    -0.850     0.200
    81.504    -0.719     0.200
    81.545    -0.238     0.200
    81.406     0.978     0.200
    81.593    -0.733     0.200
    81.416     0.245     0.200
    81.528     1.034     0.200
    81.430     0.670     0.200
    81.429     0.475     0.200
    81.519    -0.600     0.200
    81.488     0.651     0.200
    81.492     0.842     0.200
    81.674    -0.696     0.200
    81.583    -2.637     0.200
    81.540     0.287     0.200
    81.728    -0.026     0.200
    81.732    -0.923     0.200
    81.618     0.075     0.200
    81.773    -0.519     0.200
    81.603     0.895     0.200
    81.808    -2.326     0.200
    81.696    -0.534     0.200
    81.825    -0.774     0.200
    81.821     4.607     0.200
    81.693     0.982     0.200
    81.867    -0.132     0.200
    81.775    -0.251     0.200
    81.785    -0.540     0.200
    81.734     1.064     0.200
    81.830     0.058     0.200
    81.842    -0.643     0.200
    81.831    -0.347     0.200
    81.835    -0.567     0.200
    82.074    -1.822     0.200
    81.978     0.002     0.200
    81.940     1.083     0.200
    82.016    -0.518     0.200
    81.875     1.076     0.200
    82.152     0.370     0.200
    82.079    -1.169     0.200
    82.205    -0.005     0.200
    82.122    -1.191     0.200
    82.072     0.972     0.200
    82.133    -0.531     0.200
    82.237     0.426     0.200
    82.182     1.176     0.200
    82.389    -0.370     0.200
    82.315    -1.122     0.200
    82.439    -0.630     0.200
    82.377     0.967     0.200
    82.426     0.039     0.200
    82.455    -1.013     0.200
    82.440     1.175     0.200
    82.495     1.200     0.200
    82.582    -0.474     0.200
    82.614    -0.540     0.200
    82.593     0.470     0.200
    82.610    -0.520     0.200
    82.630    -0.961     0.200
    82.692     1.053     0.200
    82.835    -1.067     0.200
    82.945    -1.119     0.200
    82.945    -1.159     0.200
    82.867     0.677     0.200
    83.069    -1.134     0.200
    82.922     0.503     0.200
    82.988     0.022     0.200
    82.870     0.099     0.200
    83.032    -1.448     0.200
    83.040    -1.127     0.200
    82.937     0.264     0.200
    83.074    -0.005     0.200
    83.130    -0.214     0.200
    83.228     0.278     0.200
    83.372    -0.941     0.200
    83.372    -1.521     0.200
    83.303     0.393     0.200
    83.332    -1.037     0.200
    83.424     1.771     0.200
    83.584    -1.568     0.200
    83.643    -0.855     0.200
    83.675     1.251     0.200
    83.728    -0.787     0.200
    83.915    -1.742     0.200
    83.791    -1.828     0.200
    83.826    -1.036     0.200
    83.994    -2.145     0.200
    83.907    -1.664     0.200
    83.998    -0.168     0.200
    84.055     0.542     0.200
    84.068     0.979     0.200
    84.168    -1.111     0.200
    84.221     0.702     0.200
    84.283    -0.215     0.200
    84.435     0.017     0.200
    84.337    -2.139     0.200
    84.376     0.776     0.200
    84.465    -0.084     0.200
    84.545    -1.692     0.200
    84.599    -0.812     0.200
    84.578     0.185     0.200
    84.588    -1.819     0.200
    84.871    -0.081     0.200
    84.910    -1.277     0.200
    84.984    -1.150     0.200
    85.067    -0.633     0.200
    85.149     3.815     0.200
    85.204     0.251     0.200
    85.309     1.427     0.200
    85.293    -1.153     0.200
    85.423    -1.543     0.200
    85.438     0.405     0.200
    85.468    -0.667     0.200
    85.735    -0.891     0.200
    85.736    -0.936     0.200
    85.736    -0.806     0.200
    85.815     2.268     0.200
    85.814    -0.782     0.200
    85.902    -1.720     0.200
    86.128    -0.337     0.200
    86.221    -1.294     0.200
    86.440     3.127     0.200
    86.675    -0.723     0.200
    86.733    -1.805     0.200
    86.820     0.269     0.200
    87.458    -1.322     0.200
    87.424     0.060     0.200
    87.542    -0.647     0.200
    87.551    -1.269     0.200
    87.567    -0.396     0.200
    87.705    -2.005     0.200
    87.785    -0.447     0.200
    87.789    -0.815     0.200
    87.707    -0.933     0.200
    87.912    -1.588     0.200
    87.986    -0.310     0.200
    88.116    -0.606     0.200
    88.167    -0.678     0.200
    88.821    -1.541     0.200
    89.584     0.642     0.200
    89.840     4.041     0.200
    89.862     0.539     0.200
    90.244     3.326     0.200
    90.263     3.811     0.200
    90.282     0.202     0.200
    90.330     0.159     0.200
    90.380     0.324     0.200
    90.657     0.037     0.200
    90.706     3.366     0.200
    90.832     0.030     0.200
    91.016     3.326     0.200
    91.308    -4.389     0.200
    91.237     4.273     0.200
    91.279     0.048     0.200
    91.670     0.164     0.200
    91.671    -2.728     0.200
    91.867    -0.876     0.200
    92.058    -0.976     0.200
    92.043    -0.190     0.200
    92.257     0.022     0.200
    92.379     0.657     0.200
    92.568     3.677     0.200
    92.796     3.745     0.200
    92.895     3.668     0.200
    92.938    -0.322     0.200
    92.938    -0.422     0.200
    93.096     3.360     0.200
    93.151     3.319     0.200
    93.514    -2.375     0.200
    93.605    -0.492     0.200
    94.472    -1.094     0.200
    95.454    -1.965     0.200
    96.777     0.130     0.200
    97.061    -1.162     0.200
    18.613    -1.594     0.200
    19.049    -1.481     0.200
    19.049    -0.562     0.200
    20.242    -0.403     0.200
    20.505    -0.409     0.200
    21.368     2.923     0.200
    23.744     2.336     0.200
    23.945     1.485     0.200
    23.948     3.261     0.200
    26.420     2.393     0.200
    26.786    -1.320     0.200
    26.998     2.133     0.200
    27.896     1.508     0.200
    27.966     1.817     0.200
    27.999     2.471     0.200
    28.128    -2.929     0.200
    28.413     1.892     0.200
    28.839    -0.458     0.200
    29.333    -4.032     0.200
    29.236     1.969     0.200
    29.955     1.888     0.200
    29.974     2.604     0.200
    30.162     2.558     0.200
    30.432     2.961     0.200
    30.722     2.203     0.200
    30.873     3.125     0.200
    31.438     2.911     0.200
    31.546     1.563     0.200
    31.673     2.235     0.200
    32.561     2.194     0.200
    33.216     2.486     0.200
    33.633     2.059     0.200
    33.636     2.053     0.200
    34.218    -0.011     0.200
    34.893     1.124     0.200
    36.583    -2.315     0.200
    37.610     1.846     0.200
    38.653    -0.312     0.200
    38.907     1.372     0.200
    39.239     2.137     0.200
    39.304     2.223     0.200
    39.614     1.341     0.200
    40.591    -1.482     0.200
    43.664     0.518     0.200
    44.773     1.017     0.200
    44.773     0.541     0.200
    45.577    -0.380     0.200
    46.096    -0.079     0.200
    48.318    -0.474     0.200
    48.318    -2.094     0.200
    48.376    -0.044     0.200
    48.418     0.761     0.200
    50.014    -0.379     0.200
    51.194    -1.215     0.200
    51.807    -0.120     0.200
    52.112    -0.435     0.200
    53.025     0.138     0.200
    53.158    -1.532     0.200
    53.134    -1.558     0.200
    53.359    -1.258     0.200
    54.031    -1.826     0.200
    53.934    -1.191     0.200
    57.206    -0.997     0.200
    57.632    -1.646     0.200
    60.813    -1.391     0.200
    61.342    -1.074     0.200
    61.342    -0.849     0.200
    61.342    -0.740     0.200
    61.454    -0.727     0.200
    61.486    -1.266     0.200
    61.552    -0.713     0.200
    61.552     2.097     0.200
    62.032    -1.918     0.200
    62.421    -1.017     0.200
    63.113    -0.912     0.200
    63.483    -2.070     0.200
    64.558    -0.862     0.200
    65.103    -0.914     0.200
    65.708     0.017     0.200
    65.910     1.614     0.200
    66.678    -0.299     0.200
    67.082     0.132     0.200
    67.492    -1.966     0.200
    67.491    -1.259     0.200
    67.566    -1.461     0.200
    67.946     0.196     0.200
    68.919    -1.199     0.200
    69.657     0.146     0.200
    69.885    -0.765     0.200
    70.036    -0.221     0.200
    70.375    -0.525     0.200
    70.963    -1.014     0.200
    71.142    -0.427     0.200
    71.471    -0.816     0.200
    71.646    -0.266     0.200
    71.683    -0.093     0.200
    71.833    -0.188     0.200
    71.909    -0.748     0.200
    71.987    -1.117     0.200
    72.119    -0.703     0.200
    72.211    -1.152     0.200
    72.286    -0.904     0.200
    72.325    -0.136     0.200
    72.435     0.258     0.200
    72.569    -0.289     0.200
    72.592    -0.025     0.200
    72.592    -0.025     0.200
    72.625    -0.621     0.200
    72.638     0.343     0.200
    72.781    -0.246     0.200
    72.935    -0.561     0.200
    72.941     0.306     0.200
    72.966    -0.369     0.200
    73.193    -1.201     0.200
    73.297     0.106     0.200
    73.297    -0.104     0.200
    73.350     0.292     0.200
    73.380    -0.185     0.200
    73.447     0.320     0.200
    73.462     0.232     0.200
    73.618     0.215     0.200
    73.644    -0.598     0.200
    73.749    -0.551     0.200
    73.725    -0.813     0.200
    73.918     0.161     0.200
    73.935    -0.440     0.200
    73.974    -0.868     0.200
    73.974    -0.166     0.200
    73.927    -1.210     0.200
    74.053    -0.835     0.200
    74.114    -0.785     0.200
    74.138    -0.622     0.200
    74.218    -0.303     0.200
    74.266    -0.767     0.200
    74.429    -0.818     0.200
    74.508    -0.975     0.200
    74.518     0.464     0.200
    74.660    -0.856     0.200
    74.721    -0.910     0.200
    74.826    -1.015     0.200
    74.841     1.897     0.200
    74.906    -0.480     0.200
    74.960    -0.291     0.200
    75.037    -0.034     0.200
    75.039     0.052     0.200
    75.063    -0.281     0.200
    75.196     0.550     0.200
    75.350     0.468     0.200
    75.362    -0.006     0.200
    75.371     0.448     0.200
    75.472     0.364     0.200
    75.674    -1.089     0.200
    75.775     0.213     0.200
    75.901    -0.585     0.200
    75.930    -2.152     0.200
    76.015     0.367     0.200
    76.031    -0.324     0.200
    76.021    -0.920     0.200
    76.243     0.041     0.200
    76.266     0.717     0.200
    76.328     1.026     0.200
    76.361     0.299     0.200
    76.449     0.604     0.200
    76.592    -0.504     0.200
    76.651     0.260     0.200
    76.698    -0.302     0.200
    76.687     0.188     0.200
    76.815     1.347     0.200
    76.953     0.102     0.200
    77.003     0.479     0.200
    77.300    -0.288     0.200
    77.250     1.491     0.200
    77.264     0.707     0.200
    77.284     0.611     0.200
    77.401    -0.451     0.200
    77.404    -0.669     0.200
    77.469     0.168     0.200
    77.567    -0.520     0.200
    77.587    -0.041     0.200
    77.605     0.412     0.200
    77.606     1.006     0.200
    77.655    -0.071     0.200
    77.692    -0.853     0.200
    77.687    -1.145     0.200
    77.700    -0.518     0.200
    77.722     0.959     0.200
    77.763    -1.469     0.200
    77.744     0.635     0.200
    77.766     0.514     0.200
    77.806     0.689     0.200
    77.831     0.150     0.200
    77.900     0.367     0.200
    77.938    -0.641     0.200
    78.013    -0.461     0.200
    77.999     0.716     0.200
    78.007    -0.324     0.200
    78.034     0.924     0.200
    78.050     0.035     0.200
    78.075    -0.002     0.200
    78.104    -0.006     0.200
    78.142     0.526     0.200
    78.143     1.120     0.200
    78.200    -0.394     0.200
    78.235     0.410     0.200
    78.276    -0.313     0.200
    78.338    -0.560     0.200
    78.356    -0.758     0.200
    78.387     0.572     0.200
    78.434    -1.057     0.200
    78.494     0.894     0.200
    78.617    -0.197     0.200
    78.617     0.593     0.200
    78.630    -0.268     0.200
    78.760    -0.170     0.200
    78.891     0.522     0.200
    79.016     0.613     0.200
    79.131     0.064     0.200
    79.131     0.693     0.200
    79.157    -0.454     0.200
    79.270     0.297     0.200
    79.385     0.397     0.200
    79.672     0.338     0.200
    80.046     1.015     0.200
    80.102     0.214     0.200
    80.102     0.224     0.200
    80.211    -0.174     0.200
    80.741    -0.635     0.200
    80.783     1.332     0.200
    81.048     0.149     0.200
    81.117     0.484     0.200
    81.189     1.297     0.200
    81.300     0.213     0.200
    81.332    -0.017     0.200
    81.401     0.647     0.200
    81.468     0.423     0.200
    81.414     0.106     0.200
    81.428    -0.066     0.200
    81.427     0.538     0.200
    81.486     0.578     0.200
    81.490     0.805     0.200
    81.539     0.548     0.200
    81.600     0.986     0.200
    81.682     0.032     0.200
    81.691     0.846     0.200
    81.772    -2.183     0.200
    81.767    -0.236     0.200
    81.824    -0.417     0.200
    81.961    -0.095     0.200
    82.002    -0.292     0.200
    82.061    -0.097     0.200
    82.068     1.745     0.200
    82.105    -1.210     0.200
    82.116    -0.385     0.200
    82.177     1.204     0.200
    82.297    -1.337     0.200
    82.408     0.487     0.200
    82.441    -0.787     0.200
    82.437     0.935     0.200
    82.491     0.595     0.200
    82.578     0.809     0.200
    82.612    -0.535     0.200
    82.688     1.578     0.200
    82.818    -1.164     0.200
    82.864     1.028     0.200
    82.924    -0.636     0.200
    82.918     0.788     0.200
    83.069     0.114     0.200
    83.114     0.123     0.200
    83.334    -1.092     0.200
    83.334    -0.563     0.200
    83.316    -0.860     0.200
    83.566    -1.384     0.200
    83.811    -0.698     0.200
    83.890    -1.843     0.200
    83.958    -0.006     0.200
    83.981    -0.127     0.200
    84.044     1.017     0.200
    84.152    -0.373     0.200
    84.531    -1.235     0.200
    85.718    -1.351     0.200
    86.204    -0.751     0.200
    86.658    -1.981     0.200
    87.533    -0.125     0.200
    87.686    -1.958     0.200
    87.763    -0.143     0.200
    91.655    -0.433     0.200
    91.843    -0.905     0.200
    19.343     0.127     0.200
    30.326     1.822     0.200
    31.382     0.902     0.200
    44.599    -0.675     0.200
    44.784     0.976     0.200
    19.316    -1.809     0.200
    19.316    -1.231     0.200
    19.804    -0.129     0.200
    20.387    -1.049     0.200
    20.898     2.500     0.200
    21.005     2.918     0.200
    21.013     2.788     0.200
    21.185     2.626     0.200
    21.216     2.703     0.200
    21.248     2.614     0.200
    21.306     2.128     0.200
    21.491     2.970     0.200
    21.578     2.803     0.200
    21.780     2.024     0.200
    22.152     2.346     0.200
    22.147     2.741     0.200
    22.398     2.293     0.200
    22.412     2.904     0.200
    22.592     2.206     0.200
    22.779     2.376     0.200
    23.280     2.690     0.200
    23.404     0.833     0.200
    23.657     1.224     0.200
    23.733     0.882     0.200
    23.867     2.410     0.200
    23.863     2.392     0.200
    24.538     3.794     0.200
    24.652     2.221     0.200
    25.396     2.724     0.200
    26.367     2.146     0.200
    26.442     2.275     0.200
    26.532     2.763     0.200
    26.583     2.421     0.200
    26.626     0.620     0.200
    26.881     1.933     0.200
    26.970    -0.507     0.200
    27.752     1.689     0.200
    27.846     0.765     0.200
    27.969     2.004     0.200
    27.970     2.047     0.200
    28.047     0.477     0.200
    28.172    -0.251     0.200
    28.199     0.947     0.200
    28.244     1.332     0.200
    28.566     2.223     0.200
    29.081     1.874     0.200
    29.303     1.560     0.200
    29.400     1.885     0.200
    29.729     1.846     0.200
    29.795     2.557     0.200
    29.847     2.457     0.200
    30.087     2.564     0.200
    30.158     2.376     0.200
    30.407     3.217     0.200
    30.893     2.186     0.200
    31.346     0.896     0.200
    32.140     2.156     0.200
    32.139     2.458     0.200
    32.216     2.058     0.200
    32.255     2.199     0.200
    32.531     1.981     0.200
    33.039    -2.879     0.200
    33.071     2.370     0.200
    33.083     2.672     0.200
    33.361     1.315     0.200
    33.867     0.438     0.200
    35.544     1.700     0.200
    35.803     1.976     0.200
    36.524    -3.028     0.200
    37.553    -0.177     0.200
    38.032     1.535     0.200
    38.656     1.454     0.200
    38.756     1.376     0.200
    40.789    -1.365     0.200
    41.542    -0.760     0.200
    42.716    -1.012     0.200
    42.969    -1.861     0.200
    42.937     0.609     0.200
    44.641     1.718     0.200
    45.122    -0.173     0.200
    45.379    -3.641     0.200
    45.836    -2.239     0.200
    45.719     0.629     0.200
    45.812    -0.719     0.200
    47.732    -0.373     0.200
    48.108    -0.049     0.200
    48.222     1.216     0.200
    48.465     0.073     0.200
    48.473     0.242     0.200
    48.547    -1.748     0.200
    48.725    -1.805     0.200
    49.434    -0.787     0.200
    49.493     0.254     0.200
    49.861    -2.283     0.200
    50.863    -0.399     0.200
    51.279     1.976     0.200
    52.127    -0.898     0.200
    52.242    -1.649     0.200
    52.728    -0.563     0.200
    52.947     0.333     0.200
    53.319    -1.377     0.200
    53.319    -1.198     0.200
    53.959    -1.476     0.200
    57.281    -1.189     0.200
    58.850    -1.271     0.200
    58.923    -0.602     0.200
    59.767    -1.902     0.200
    60.403    -1.860     0.200
    60.898    -1.226     0.200
    60.898    -0.925     0.200
    61.065    -1.455     0.200
    61.075    -1.875     0.200
    62.006    -2.102     0.200
    62.171    -1.905     0.200
    62.428    -2.324     0.200
    65.361    -1.399     0.200
    65.432    -0.356     0.200
    65.541    -1.860     0.200
    65.675    -1.726     0.200
    65.888    -0.100     0.200
    66.077    -2.614     0.200
    66.278    -1.096     0.200
    66.566    -0.937     0.200
    67.114    -1.525     0.200
    70.502     0.194     0.200
    70.588    -1.510     0.200
    70.696    -1.165     0.200
    71.201     0.069     0.200
    71.234    -0.126     0.200
    71.394    -0.293     0.200
    71.514    -0.619     0.200
    71.643    -0.192     0.200
    71.738    -0.663     0.200
    71.813    -1.212     0.200
    71.887     0.042     0.200
    71.897    -0.918     0.200
    71.979     0.578     0.200
    72.126    -0.290     0.200
    72.141    -0.078     0.200
    72.141    -0.078     0.200
    72.196    -0.306     0.200
    72.259     0.021     0.200
    72.501    -0.227     0.200
    72.871    -0.720     0.200
    72.904     0.083     0.200
    72.942    -0.640     0.200
    72.987     0.392     0.200
    73.000     0.518     0.200
    73.158     0.481     0.200
    73.198     0.100     0.200
    73.466    -0.129     0.200
    73.513    -0.405     0.200
    73.513     0.492     0.200
    73.647    -0.193     0.200
    73.664    -0.091     0.200
    73.798    -0.177     0.200
    73.968     0.630     0.200
    74.040    -0.391     0.200
    74.081    -2.332     0.200
    74.232    -0.109     0.200
    74.254    -0.438     0.200
    74.355    -0.428     0.200
    74.509     0.580     0.200
    74.586     0.735     0.200
    74.587     0.625     0.200
    74.599     0.157     0.200
    74.881     0.826     0.200
    74.921     0.197     0.200
    74.923     0.483     0.200
    75.003     1.022     0.200
    75.202    -0.219     0.200
    75.427    -0.717     0.200
    75.586     0.077     0.200
    75.659    -0.043     0.200
    75.663    -0.165     0.200
    75.780     2.170     0.200
    75.912    -0.884     0.200
    76.125     0.006     0.200
    76.540     0.951     0.200
    76.768    -0.131     0.200
    76.827     0.633     0.200
    77.032     0.177     0.200
    77.179    -0.043     0.200
    77.228     0.183     0.200
    77.303     1.159     0.200
    77.344     0.930     0.200
    77.352    -0.015     0.200
    77.369     0.589     0.200
    77.438     0.610     0.200
    77.475    -0.101     0.200
    77.514     1.084     0.200
    77.534     1.168     0.200
    77.668    -1.074     0.200
    77.670    -0.086     0.200
    77.735     0.150     0.200
    77.874     0.078     0.200
    77.933     1.050     0.200
    77.950     1.054     0.200
    78.677    -1.359     0.200
    78.681     0.219     0.200
    78.845     0.321     0.200
    78.964    -0.036     0.200
    79.115     0.541     0.200
    79.520    -0.567     0.200
    79.620     0.991     0.200
    79.620     0.311     0.200
    80.293    -0.143     0.200
    80.494    -0.224     0.200
    80.607    -1.829     0.200
    81.633    -0.419     0.200
    81.801    -0.863     0.200
    81.866    -0.564     0.200
    81.997    -0.792     0.200
    82.112    -0.513     0.200
    82.159     0.156     0.200
    82.388    -0.717     0.200
    83.409    -1.183     0.200
    83.409    -1.074     0.200
    83.842    -2.741     0.200
    88.689    -1.829     0.200
    92.110    -0.576     0.200
    93.501    -1.872     0.200
    94.330    -1.195     0.200
    95.319    -1.097     0.200
    19.061    -0.065     0.200
    29.486     1.608     0.200
    43.983     2.091     0.200
    43.901    -1.179     0.200
    45.200    -1.793     0.200
    52.758    -1.600     0.200
    54.007    -0.098     0.200
    60.888    -0.829     0.200
    84.019     0.151     0.200
    15.827     1.366     0.200
    19.225    -0.710     0.200
    19.791     0.173     0.200
    20.515     0.601     0.200
    21.029     2.669     0.200
    21.327     2.283     0.200
    21.383     2.744     0.200
    21.438     2.181     0.200
    22.335     3.128     0.200
    22.385     2.313     0.200
    23.131     2.315     0.200
    23.144     0.006     0.200
    23.568     1.909     0.200
    23.794     1.451     0.200
    23.852     1.237     0.200
    24.016     2.573     0.200
    25.074     0.463     0.200
    25.563     2.732     0.200
    26.537     2.621     0.200
    26.741     0.647     0.200
    27.034     1.980     0.200
    27.268    -1.025     0.200
    27.623     0.998     0.200
    27.871     1.367     0.200
    28.017     1.582     0.200
    28.163     2.004     0.200
    28.324     1.234     0.200
    28.378     1.638     0.200
    28.730     1.700     0.200
    29.422     0.930     0.200
    29.572     2.263     0.200
    29.790     1.555     0.200
    29.857     2.170     0.200
    29.927     2.742     0.200
    29.983     2.252     0.200
    30.252     1.872     0.200
    30.322     2.046     0.200
    30.478    -0.113     0.200
    30.981     2.530     0.200
    31.247     1.739     0.200
    31.470     1.376     0.200
    31.470     1.464     0.200
    31.639     1.813     0.200
    32.278     1.417     0.200
    32.389     0.195     0.200
    32.418     2.368     0.200
    32.829    -2.728     0.200
    33.148     2.199     0.200
    33.229     2.213     0.200
    33.622     1.947     0.200
    33.917     0.658     0.200
    35.363     1.814     0.200
    35.667     1.777     0.200
    35.732     1.395     0.200
    35.956     2.330     0.200
    37.604     0.160     0.200
    38.897     3.018     0.200
    39.432     2.115     0.200
    40.667    -2.824     0.200
    43.057     0.657     0.200
    43.934    -2.189     0.200
    44.788    -0.011     0.200
    45.088     0.061     0.200
    45.853     0.613     0.200
    47.817     0.294     0.200
    48.202    -0.150     0.200
    48.438    -1.677     0.200
    48.438    -1.524     0.200
    48.550    -1.785     0.200
    48.554     0.154     0.200
    49.526    -0.007     0.200
    49.706    -2.266     0.200
    52.757    -1.379     0.200
    53.184    -1.393     0.200
    55.272    -1.430     0.200
    58.678    -0.295     0.200
    60.212    -2.365     0.200
    60.723    -1.241     0.200
    60.723    -0.591     0.200
    60.884    -1.564     0.200
    62.973    -2.978     0.200
    65.175    -1.181     0.200
    65.375    -1.775     0.200
    66.364     1.372     0.200
    70.418    -1.139     0.200
    70.806     0.698     0.200
    71.026    -0.434     0.200
    71.062     0.051     0.200
    71.950     0.303     0.200
    72.712    -0.834     0.200
    72.730     0.659     0.200
    73.024     0.072     0.200
    73.310     0.534     0.200
    73.349    -0.199     0.200
    73.489     0.181     0.200
    73.513     0.340     0.200
    73.640     0.194     0.200
    73.883    -0.025     0.200
    74.035     0.088     0.200
    74.200     0.022     0.200
    74.415     0.477     0.200
    74.417     0.664     0.200
    74.438     0.244     0.200
    74.750     0.637     0.200
    75.276     0.506     0.200
    75.411     0.032     0.200
    76.378     1.526     0.200
    77.031     1.144     0.200
    77.075     0.601     0.200
    77.165     0.697     0.200
    79.482     0.810     0.200
    80.680    -0.235     0.200
    81.044     0.128     0.200
    81.245    -0.681     0.200
    81.304    -0.473     0.200
    81.378    -0.445     0.200
    81.425     0.049     0.200
    81.444    -0.516     0.200
    81.498    -0.578     0.200
    81.535    -0.235     0.200
    82.004    -0.459     0.200
    82.423    -0.809     0.200
    83.246    -1.451     0.200
    83.246    -0.901     0.200
    93.306    -1.368     0.200
    97.468    -1.514     0.200
    16.264     2.387     0.200
    18.666    -0.572     0.200
    20.332    -0.642     0.200
    20.630    -0.278     0.200
    24.315     1.329     0.200
    24.478     3.302     0.200
    25.198     2.838     0.200
    25.597     1.610     0.200
    28.165    -1.158     0.200
    28.115     1.341     0.200
    28.336     1.941     0.200
    28.761     1.944     0.200
    29.525     2.024     0.200
    30.434     2.696     0.200
    30.470     2.756     0.200
    30.904     2.652     0.200
    31.302     0.028     0.200
    31.911     1.547     0.200
    31.911     1.893     0.200
    33.554     3.016     0.200
    33.982     2.427     0.200
    34.140     2.717     0.200
    34.619     0.529     0.200
    35.736     1.535     0.200
    39.064     2.072     0.200
    42.567    -1.944     0.200
    45.240    -2.780     0.200
    45.109     1.964     0.200
    45.955    -0.301     0.200
    46.890    -0.501     0.200
    47.944    -2.038     0.200
    49.140    -0.201     0.200
    49.441    -1.926     0.200
    49.523     0.032     0.200
    50.120    -1.081     0.200
    52.812    -1.060     0.200
    53.246    -2.296     0.200
    53.476    -1.664     0.200
    53.819    -0.787     0.200
    54.919    -1.381     0.200
    61.510    -1.197     0.200
    61.510    -1.147     0.200
    61.600    -1.303     0.200
    62.764    -1.503     0.200
    63.462    -1.919     0.200
    63.973    -1.781     0.200
    66.493    -1.600     0.200
    71.312    -0.822     0.200
    71.554    -0.489     0.200
    71.639    -0.792     0.200
    71.813    -0.231     0.200
    71.860    -0.119     0.200
    71.989    -0.994     0.200
    72.164    -0.435     0.200
    72.215    -0.345     0.200
    72.356    -1.080     0.200
    72.517    -1.237     0.200
    72.734     0.169     0.200
    72.767    -0.526     0.200
    72.772     0.050     0.200
    72.772     0.050     0.200
    73.520    -0.467     0.200
    73.537    -0.867     0.200
    73.636    -0.549     0.200
    73.813    -0.710     0.200
    73.927    -0.852     0.200
    74.153    -0.369     0.200
    74.327    -0.081     0.200
    74.368    -1.418     0.200
    74.480    -0.673     0.200
    74.723    -0.879     0.200
    74.878    -0.173     0.200
    75.046    -0.947     0.200
    75.140     0.116     0.200
    75.217     0.277     0.200
    75.221     0.251     0.200
    75.267    -0.511     0.200
    75.543    -0.195     0.200
    75.899    -1.029     0.200
    76.130    -1.341     0.200
    76.198    -0.031     0.200
    76.424     0.487     0.200
    76.445     0.772     0.200
    76.804    -1.254     0.200
    76.905    -0.321     0.200
    77.207    -0.416     0.200
    77.892    -0.138     0.200
    78.043    -1.079     0.200
    78.139    -0.008     0.200
    79.039     1.742     0.200
    79.619     0.679     0.200
    80.358     0.293     0.200
    80.675    -0.369     0.200
    81.060     0.122     0.200
    81.240     0.083     0.200
    81.333    -0.048     0.200
    81.416    -0.331     0.200
    81.470    -0.531     0.200
    81.477     0.012     0.200
    81.504    -0.409     0.200
    81.516     0.424     0.200
    81.565    -0.071     0.200
    81.699    -1.041     0.200
    81.741    -0.862     0.200
    82.009    -0.670     0.200
    82.053    -0.542     0.200
    82.268    -1.225     0.200
    83.029    -0.878     0.200
    16.552     1.383     0.200
    18.448    -1.984     0.200
    19.817     0.462     0.200
    20.572     0.066     0.200
    21.008     1.707     0.200
    21.204     2.803     0.200
    21.315     2.749     0.200
    21.846     2.401     0.200
    22.015     1.642     0.200
    22.088     2.058     0.200
    22.637     1.686     0.200
    23.024     2.153     0.200
    23.071     1.655     0.200
    23.089     2.163     0.200
    23.296     1.871     0.200
    23.344     2.698     0.200
    23.432     1.893     0.200
    23.580     2.064     0.200
    23.594     2.238     0.200
    23.615     2.162     0.200
    24.106     2.403     0.200
    24.192     2.101     0.200
    24.230     2.090     0.200
    24.240     1.926     0.200
    24.493     1.694     0.200
    24.531     2.413     0.200
    24.590     1.238     0.200
    24.684     2.175     0.200
    24.872     3.144     0.200
    25.203     2.425     0.200
    25.490     1.648     0.200
    25.564     2.483     0.200
    25.835     1.078     0.200
    26.168     2.820     0.200
    27.236     2.212     0.200
    27.485     0.690     0.200
    27.691     2.056     0.200
    27.848     0.664     0.200
    28.609     1.515     0.200
    28.606     1.158     0.200
    28.744     2.476     0.200
    28.905     0.918     0.200
    29.083     1.325     0.200
    29.193     0.839     0.200
    29.475     2.751     0.200
    29.884     2.258     0.200
    30.665     2.230     0.200
    30.716     2.729     0.200
    30.867     2.519     0.200
    30.939     2.069     0.200
    31.102     2.369     0.200
    31.145     3.097     0.200
    31.188     2.728     0.200
    31.195     2.037     0.200
    31.265     0.210     0.200
    31.678     2.035     0.200
    31.953     1.963     0.200
    32.150     2.726     0.200
    32.199     1.420     0.200
    32.323     1.516     0.200
    32.350     1.576     0.200
    32.514     1.501     0.200
    32.907     2.126     0.200
    32.976     2.241     0.200
    33.273     2.134     0.200
    33.805     1.879     0.200
    33.892     2.378     0.200
    33.903     2.226     0.200
    34.227     1.680     0.200
    34.314     2.087     0.200
    34.720     0.568     0.200
    35.603     1.588     0.200
    35.635     1.838     0.200
    35.876    -2.476     0.200
    36.061     1.300     0.200
    36.396     2.050     0.200
    36.438     1.634     0.200
    36.611     1.783     0.200
    37.983    -1.665     0.200
    39.449     1.077     0.200
    39.587     0.049     0.200
    39.654     1.990     0.200
    39.936    -0.948     0.200
    39.924     2.086     0.200
    39.987     1.452     0.200
    40.115     1.725     0.200
    40.244     1.560     0.200
    40.718    -1.890     0.200
    42.176    -1.304     0.200
    43.329    -1.063     0.200
    43.714    -0.002     0.200
    43.793     0.827     0.200
    44.748    -2.945     0.200
    45.345    -1.225     0.200
    45.461     1.091     0.200
    45.461     1.434     0.200
    45.846    -0.293     0.200
    46.380    -2.513     0.200
    46.559     0.666     0.200
    46.680    -0.566     0.200
    46.718     0.042     0.200
    47.046    -0.188     0.200
    47.372     4.596     0.200
    47.685    -1.948     0.200
    47.685    -1.008     0.200
    47.985    -1.927     0.200
    47.859    -0.339     0.200
    48.143    -0.537     0.200
    48.600     0.052     0.200
    48.877    -0.377     0.200
    49.060    -1.503     0.200
    48.976    -0.180     0.200
    49.073     1.069     0.200
    49.333     0.270     0.200
    49.341     0.237     0.200
    49.933    -0.418     0.200
    50.204    -0.284     0.200
    50.302    -0.493     0.200
    50.330     0.356     0.200
    50.500    -0.175     0.200
    51.439    -1.136     0.200
    51.723    -0.220     0.200
    52.483    -1.467     0.200
    52.483    -1.030     0.200
    52.647    -1.391     0.200
    52.539    -0.268     0.200
    52.982    -1.669     0.200
    52.982    -2.076     0.200
    53.105    -1.741     0.200
    53.326    -1.381     0.200
    53.506    -0.242     0.200
    53.500    -0.351     0.200
    54.131     0.995     0.200
    54.131     2.205     0.200
    54.407    -0.945     0.200
    54.463    -1.054     0.200
    56.500    -1.434     0.200
    58.170    -2.174     0.200
    58.435    -0.799     0.200
    59.254    -1.017     0.200
    60.432    -1.549     0.200
    60.522    -1.012     0.200
    60.976    -1.239     0.200
    61.052    -1.252     0.200
    61.052    -0.979     0.200
    61.105    -1.715     0.200
    61.223    -1.056     0.200
    62.049    -1.651     0.200
    62.151     0.164     0.200
    62.258     0.750     0.200
    62.311    -0.885     0.200
    62.922    -2.765     0.200
    63.152    -2.387     0.200
    63.433    -1.436     0.200
    64.668    -1.216     0.200
    64.767    -1.363     0.200
    65.038    -1.514     0.200
    65.542    -1.869     0.200
    65.985    -0.712     0.200
    66.800    -0.811     0.200
    66.975    -0.899     0.200
    67.045    -2.265     0.200
    67.437    -0.518     0.200
    67.539    -1.581     0.200
    68.148    -0.251     0.200
    68.307     0.050     0.200
    68.557    -1.647     0.200
    69.828    -0.995     0.200
    70.454    -0.314     0.200
    70.855    -0.749     0.200
    71.216     0.076     0.200
    71.250    -0.134     0.200
    71.353    -0.551     0.200
    71.409    -0.188     0.200
    71.522    -0.870     0.200
    71.633    -1.134     0.200
    71.651    -0.144     0.200
    71.759     0.012     0.200
    71.813    -0.312     0.200
    71.883    -0.032     0.200
    71.963     0.092     0.200
    72.015    -0.021     0.200
    72.079    -0.899     0.200
    72.034    -0.432     0.200
    72.116    -0.123     0.200
    72.183    -0.022     0.200
    72.273    -0.558     0.200
    72.289    -0.454     0.200
    72.322     0.151     0.200
    72.612    -0.770     0.200
    72.699     0.113     0.200
    72.940    -0.406     0.200
    73.062     0.371     0.200
    73.069    -0.270     0.200
    73.203     0.245     0.200
    73.237     0.143     0.200
    73.355    -0.255     0.200
    73.383     0.082     0.200
    73.397    -1.599     0.200
    73.497    -0.087     0.200
    73.740    -0.005     0.200
    73.742    -0.219     0.200
    73.739     0.498     0.200
    73.758     0.087     0.200
    73.805     0.116     0.200
    73.842     0.002     0.200
    73.908    -0.086     0.200
    73.973    -0.368     0.200
    73.967     0.170     0.200
    74.167    -0.195     0.200
    74.204    -1.309     0.200
    74.199     0.123     0.200
    74.202     0.203     0.200
    74.242     0.174     0.200
    74.311    -0.031     0.200
    74.307    -0.109     0.200
    74.362     0.174     0.200
    74.385    -0.460     0.200
    74.517    -0.221     0.200
    74.586    -0.017     0.200
    74.641    -0.039     0.200
    74.636    -0.109     0.200
    74.691     0.074     0.200
    74.752     0.317     0.200
    74.767     0.332     0.200
    74.773     0.297     0.200
    74.773     0.102     0.200
    74.776     0.382     0.200
    74.783     0.345     0.200
    74.840     0.314     0.200
    74.850     0.555     0.200
    74.933     0.378     0.200
    74.934     0.472     0.200
    74.936     0.460     0.200
    74.999     0.497     0.200
    75.062     0.036     0.200
    75.087     0.491     0.200
    75.149     0.536     0.200
    75.205     0.418     0.200
    75.208     0.196     0.200
    75.240     0.512     0.200
    75.282     1.072     0.200
    75.277     0.299     0.200
    75.286     0.551     0.200
    75.339     0.749     0.200
    75.464     0.633     0.200
    75.653     0.556     0.200
    75.677     0.476     0.200
    75.739    -0.034     0.200
    75.728     0.331     0.200
    75.814     0.642     0.200
    75.819     0.411     0.200
    75.878     0.135     0.200
    75.946    -0.012     0.200
    75.937     0.841     0.200
    75.996     0.907     0.200
    76.016     1.087     0.200
    76.099     1.090     0.200
    76.117     0.176     0.200
    76.144     0.264     0.200
    76.229     0.383     0.200
    76.422     0.446     0.200
    76.480     0.462     0.200
    76.590     1.576     0.200
    76.668     0.637     0.200
    76.705     1.401     0.200
    76.724    -0.166     0.200
    76.715     0.961     0.200
    76.778     1.084     0.200
    77.026     1.395     0.200
    77.037     0.607     0.200
    77.037     0.058     0.200
    77.016     0.371     0.200
    77.038     0.427     0.200
    77.165    -0.570     0.200
    77.175     0.662     0.200
    77.290     0.323     0.200
    77.319    -0.970     0.200
    77.390    -0.536     0.200
    77.349    -1.135     0.200
    77.372     0.441     0.200
    77.369     0.883     0.200
    77.364     0.809     0.200
    77.513    -0.721     0.200
    77.518     0.250     0.200
    77.522    -0.472     0.200
    77.533    -0.633     0.200
    77.539     0.635     0.200
    77.578     0.520     0.200
    77.584    -0.276     0.200
    77.602    -0.016     0.200
    77.613     0.825     0.200
    77.673     0.289     0.200
    77.709    -0.012     0.200
    77.715    -0.378     0.200
    77.727    -0.805     0.200
    77.739     0.919     0.200
    77.753     0.242     0.200
    77.756    -0.692     0.200
    77.823    -0.442     0.200
    77.900     0.127     0.200
    77.913    -0.043     0.200
    77.959     0.401     0.200
    77.981     0.377     0.200
    78.119     0.794     0.200
    78.119     0.316     0.200
    78.138     1.123     0.200
    78.153     0.832     0.200
    78.213     0.597     0.200
    78.411     0.036     0.200
    78.499    -0.753     0.200
    78.533     0.838     0.200
    78.616     0.074     0.200
    78.631    -0.242     0.200
    78.658     0.258     0.200
    78.857     0.125     0.200
    79.024    -0.241     0.200
    79.082     0.233     0.200
    79.160     0.221     0.200
    79.184     0.076     0.200
    79.173     0.738     0.200
    79.249     0.644     0.200
    79.357     0.535     0.200
    79.554    -0.771     0.200
    79.541    -0.238     0.200
    79.635    -0.459     0.200
    79.609     1.073     0.200
    79.661    -1.081     0.200
    79.700    -0.651     0.200
    79.914    -0.704     0.200
    79.978     0.200     0.200
    80.005    -1.208     0.200
    79.987     0.428     0.200
    79.987     0.080     0.200
    80.053    -1.114     0.200
    80.034     0.139     0.200
    80.200    -0.217     0.200
    80.183    -1.092     0.200
    80.211     0.128     0.200
    80.491    -0.075     0.200
    80.520    -1.329     0.200
    80.461    -0.456     0.200
    80.579    -0.046     0.200
    80.518    -0.890     0.200
    80.576     0.071     0.200
    80.723    -3.715     0.200
    80.640     1.010     0.200
    80.765    -0.336     0.200
    80.822    -0.339     0.200
    80.727     0.464     0.200
    80.848    -0.380     0.200
    80.930    -0.612     0.200
    80.986     0.087     0.200
    80.986    -0.414     0.200
    80.982     0.122     0.200
    81.026    -0.521     0.200
    81.080    -0.009     0.200
    80.985     0.392     0.200
    81.116     0.340     0.200
    81.247    -0.097     0.200
    81.340    -2.184     0.200
    81.276     1.117     0.200
    81.418     0.106     0.200
    81.354     0.943     0.200
    81.420    -0.507     0.200
    81.477    -1.104     0.200
    81.404     1.137     0.200
    81.564    -0.363     0.200
    81.479     1.440     0.200
    81.503     0.713     0.200
    81.711    -0.547     0.200
    81.796     0.417     0.200
    81.963     1.242     0.200
    81.972     0.181     0.200
    82.287     0.208     0.200
    82.345     1.126     0.200
    82.380     0.404     0.200
    82.384     1.523     0.200
    82.628    -1.238     0.200
    82.628    -1.226     0.200
    82.580     0.581     0.200
    82.774     1.681     0.200
    82.808     1.382     0.200
    84.006    -0.437     0.200
    91.388    -0.359     0.200
    91.388    -0.386     0.200
    91.413    -1.571     0.200
    93.510    -0.810     0.200
    96.676    -1.820     0.200
    19.285     0.136     0.200
    20.178    -0.867     0.200
    44.570    -0.524     0.200
    52.382    -2.060     0.200
    53.459    -1.382     0.200
    60.300    -2.204     0.200
    60.300    -1.852     0.200
    60.510    -2.267     0.200
    72.599    -0.904     0.200
    81.097    -0.146     0.200
    81.457    -0.357     0.200
    81.492    -0.940     0.200
    81.557    -0.782     0.200
    83.431    -2.082     0.200
    20.581     0.105     0.200
    45.904     1.802     0.200
    19.574    -0.238     0.200
    19.584     0.208     0.200
    20.387     0.061     0.200
    23.593     1.600     0.200
    30.005     2.356     0.200
    31.211     2.858     0.200
    42.524    -0.970     0.200
    42.797     2.175     0.200
    44.533     2.294     0.200
    44.533     3.528     0.200
    48.697    -0.794     0.200
    52.788    -0.758     0.200
    53.442    -1.127     0.200
    60.917    -0.650     0.200
    77.392     0.371     0.200
    80.904     0.059     0.200
    81.171     0.342     0.200
    81.264     0.543     0.200
    81.469    -0.539     0.200
    81.523     0.074     0.200
    81.596    -0.208     0.200
    81.640     0.363     0.200
    81.642    -0.557     0.200
    81.664    -0.068     0.200
    81.720    -0.060     0.200
    81.754     0.161     0.200
    81.880    -0.309     0.200
    82.120    -0.659     0.200
    82.219     0.017     0.200
    82.401    -0.726     0.200
    83.494    -0.686     0.200
    19.642     0.026     0.200
    24.123     1.544     0.200
    30.680     2.322     0.200
    31.753     1.567     0.200
    31.989     1.328     0.200
    32.840     1.679     0.200
    33.959     0.567     0.200
    44.871    -0.677     0.200
    45.150     0.930     0.200
    45.150     1.359     0.200
    47.967     0.039     0.200
    20.498    -0.020     0.200
    47.867    -1.610     0.200
    61.255    -1.604     0.200
    65.599    -1.128     0.200
    73.479    -0.067     0.200
    13.097     2.436     0.200
    18.614    -1.134     0.200
    20.011    -0.472     0.200
    20.025    -0.005     0.200
    47.656    -1.222     0.200
    52.405    -0.617     0.200
    64.749    -1.392     0.200
    14.666     4.137     0.200
    20.449    -1.346     0.200
    20.925    -1.044     0.200
    21.130     1.784     0.200
    21.215     3.214     0.200
    21.226     3.794     0.200
    21.271     2.528     0.200
    21.446     3.842     0.200
    21.573     2.616     0.200
    22.362     1.348     0.200
    22.646     2.032     0.200
    22.661     0.928     0.200
    22.673     1.721     0.200
    22.913     0.904     0.200
    22.989     1.609     0.200
    23.448     2.875     0.200
    23.650     2.602     0.200
    23.670     3.744     0.200
    24.151     2.102     0.200
    24.173     2.296     0.200
    24.554     3.156     0.200
    25.248     1.094     0.200
    25.552     1.211     0.200
    25.552     2.193     0.200
    25.547     0.925     0.200
    26.428     1.224     0.200
    26.977     1.518     0.200
    27.154     1.554     0.200
    27.236     1.780     0.200
    27.267     0.710     0.200
    27.809     1.788     0.200
    27.889     2.085     0.200
    28.241     2.329     0.200
    28.607     3.279     0.200
    28.586     2.245     0.200
    28.807     3.176     0.200
    28.897     2.743     0.200
    29.015    -1.202     0.200
    29.207     2.357     0.200
    29.227     3.171     0.200
    29.282     2.841     0.200
    29.635     3.253     0.200
    29.975     3.590     0.200
    30.019     2.660     0.200
    30.298     1.874     0.200
    30.298     2.232     0.200
    30.521     1.503     0.200
    30.541     2.664     0.200
    30.635     2.808     0.200
    30.903     1.732     0.200
    31.383     2.332     0.200
    31.405     2.166     0.200
    31.748     2.672     0.200
    32.125     2.943     0.200
    32.252     1.913     0.200
    32.466     2.644     0.200
    32.687     0.934     0.200
    32.793     1.784     0.200
    32.806     2.344     0.200
    32.899     2.699     0.200
    33.439     2.289     0.200
    33.804     2.322     0.200
    34.028     1.890     0.200
    34.227     1.994     0.200
    34.714     2.529     0.200
    34.876     2.762     0.200
    35.244     2.106     0.200
    36.091     2.139     0.200
    36.374    -0.248     0.200
    37.169    -2.827     0.200
    37.771     1.410     0.200
    37.762     2.301     0.200
    37.859     2.130     0.200
    38.130     2.337     0.200
    38.315     1.625     0.200
    39.854    -1.704     0.200
    41.009     1.637     0.200
    41.848    -0.945     0.200
    41.876     1.388     0.200
    42.099    -1.093     0.200
    42.137    -1.707     0.200
    43.341    -1.244     0.200
    43.448     0.567     0.200
    43.706    -2.076     0.200
    43.683     1.723     0.200
    43.881    -2.220     0.200
    43.991    -0.130     0.200
    44.668    -0.392     0.200
    44.705     1.082     0.200
    44.754    -0.317     0.200
    45.020     0.073     0.200
    45.229    -0.276     0.200
    45.835    -0.503     0.200
    45.992    -2.520     0.200
    46.111    -0.314     0.200
    46.590    -0.103     0.200
    46.983     0.576     0.200
    47.174     1.614     0.200
    47.330    -0.402     0.200
    48.146    -1.929     0.200
    48.171    -0.864     0.200
    48.288    -0.416     0.200
    49.352    -0.844     0.200
    49.397    -0.629     0.200
    49.530    -1.722     0.200
    49.641    -1.699     0.200
    49.641    -0.136     0.200
    49.691    -0.138     0.200
    49.733    -0.580     0.200
    49.992     0.420     0.200
    50.788    -1.591     0.200
    50.977    -0.704     0.200
    51.475    -0.244     0.200
    52.372    -2.633     0.200
    52.465     0.302     0.200
    52.581    -2.340     0.200
    52.953     0.200     0.200
    53.175    -1.064     0.200
    53.539     0.179     0.200
    54.158    -1.365     0.200
    54.331    -0.727     0.200
    54.518    -2.187     0.200
    54.570    -1.413     0.200
    55.606     0.054     0.200
    56.157    -1.286     0.200
    56.991    -1.396     0.200
    58.142    -1.031     0.200
    58.163    -1.064     0.200
    58.523    -0.563     0.200
    58.983    -2.688     0.200
    59.296    -0.782     0.200
    59.677    -0.485     0.200
    60.042    -1.297     0.200
    60.376    -1.686     0.200
    60.376    -1.461     0.200
    60.540    -1.955     0.200
    60.556    -2.010     0.200
    60.711    -1.445     0.200
    61.626    -1.073     0.200
    62.485    -1.534     0.200
    63.218    -2.816     0.200
    63.373    -2.342     0.200
    64.020    -1.811     0.200
    64.045    -2.572     0.200
    64.420    -1.828     0.200
    64.691    -1.199     0.200
    65.140    -0.726     0.200
    66.074    -1.055     0.200
    66.203    -2.183     0.200
    66.315    -1.904     0.200
    66.624    -1.080     0.200
    66.879    -1.906     0.200
    67.086    -1.119     0.200
    67.069    -1.414     0.200
    67.688    -0.327     0.200
    68.098    -1.310     0.200
    68.823    -0.480     0.200
    69.884    -1.065     0.200
    70.164    -0.823     0.200
    70.326    -0.516     0.200
    70.374    -0.611     0.200
    70.620    -1.809     0.200
    70.680    -0.677     0.200
    70.683    -0.496     0.200
    70.741    -0.251     0.200
    70.814    -1.094     0.200
    70.902    -0.726     0.200
    70.917    -0.617     0.200
    71.121    -0.558     0.200
    71.391    -0.489     0.200
    71.394    -0.107     0.200
    71.425    -0.992     0.200
    71.583    -0.047     0.200
    71.610    -0.510     0.200
    71.747    -0.834     0.200
    71.789    -1.787     0.200
    71.880    -0.434     0.200
    71.835    -0.329     0.200
    71.969    -0.468     0.200
    72.031    -0.338     0.200
    72.051    -1.441     0.200
    72.252    -1.364     0.200
    72.374     0.011     0.200
    72.373    -0.782     0.200
    72.378    -0.411     0.200
    72.450    -0.344     0.200
    72.464    -0.426     0.200
    72.439    -1.269     0.200
    72.545    -0.710     0.200
    72.586    -0.654     0.200
    72.640    -0.575     0.200
    72.669    -0.444     0.200
    72.795    -0.397     0.200
    72.766    -1.313     0.200
    72.867    -0.525     0.200
    72.895    -0.888     0.200
    72.899    -0.711     0.200
    72.958    -0.560     0.200
    72.990    -1.051     0.200
    73.163    -0.772     0.200
    73.169    -1.713     0.200
    73.347    -0.458     0.200
    73.348    -0.965     0.200
    73.361    -0.242     0.200
    73.376    -0.729     0.200
    73.480    -0.344     0.200
    73.520    -0.677     0.200
    73.595    -0.819     0.200
    73.707    -0.279     0.200
    73.753     0.150     0.200
    73.804    -0.144     0.200
    73.775    -0.476     0.200
    73.887    -0.435     0.200
    73.931     0.008     0.200
    73.931     0.007     0.200
    73.948    -0.091     0.200
    73.964     0.215     0.200
    73.968    -0.205     0.200
    73.977    -0.060     0.200
    74.022    -0.021     0.200
    74.026     0.056     0.200
    74.032     0.116     0.200
    74.048    -0.723     0.200
    74.057    -0.230     0.200
    74.109     0.471     0.200
    74.130     0.146     0.200
    74.217    -0.163     0.200
    74.302     0.343     0.200
    74.354    -0.160     0.200
    74.381     0.186     0.200
    74.385     0.162     0.200
    74.411    -0.090     0.200
    74.472     0.357     0.200
    74.506     0.459     0.200
    74.510    -1.064     0.200
    74.550     0.100     0.200
    74.619     0.400     0.200
    74.681     0.342     0.200
    74.725    -0.410     0.200
    74.777     0.884     0.200
    74.874    -0.274     0.200
    75.044    -0.356     0.200
    75.062    -0.261     0.200
    75.131     0.539     0.200
    75.469    -0.303     0.200
    75.593    -0.011     0.200
    75.910     0.574     0.200
    76.099    -0.102     0.200
    76.173    -0.023     0.200
    76.419    -0.621     0.200
    76.442    -0.050     0.200
    76.452    -0.004     0.200
    76.468     0.404     0.200
    76.496    -1.053     0.200
    76.536    -0.282     0.200
    76.610     0.600     0.200
    76.677    -0.179     0.200
    76.720    -0.122     0.200
    76.784    -1.782     0.200
    76.851    -0.462     0.200
    76.928     0.003     0.200
    76.962    -0.588     0.200
    77.034    -0.392     0.200
    77.139    -0.978     0.200
    77.164     0.861     0.200
    77.236    -0.426     0.200
    77.313    -0.657     0.200
    77.367     0.242     0.200
    77.546    -1.253     0.200
    77.838    -0.189     0.200
    78.287    -0.379     0.200
    78.342    -0.082     0.200
    78.356    -0.362     0.200
    78.433    -0.089     0.200
    78.563    -0.754     0.200
    78.578     0.312     0.200
    78.838     0.118     0.200
    78.965    -0.712     0.200
    79.396    -0.509     0.200
    79.480    -0.427     0.200
    80.058    -0.561     0.200
    80.110    -1.243     0.200
    80.757     0.477     0.200
    80.883    -0.894     0.200
    81.251    -1.154     0.200
    81.345    -1.452     0.200
    81.472    -1.216     0.200
    81.783     0.234     0.200
    82.129    -0.085     0.200
    82.193    -0.222     0.200
    82.226     0.206     0.200
    82.273    -0.238     0.200
    82.336     0.134     0.200
    82.370    -1.117     0.200
    82.359     0.109     0.200
    82.560     0.264     0.200
    84.287    -0.902     0.200
    84.287    -0.771     0.200
    84.349    -2.238     0.200
    93.241     0.265     0.200
    93.420    -2.360     0.200
    98.645    -1.615     0.200
    18.760    -1.520     0.200
    20.383    -0.792     0.200
    20.541     0.092     0.200
    20.971     3.011     0.200
    21.097     2.125     0.200
    21.594     2.024     0.200
    21.683     2.360     0.200
    22.200     2.009     0.200
    22.603     1.988     0.200
    22.647     2.477     0.200
    22.723     3.015     0.200
    22.777     2.663     0.200
    23.680     2.588     0.200
    23.770     2.330     0.200
    23.997     2.212     0.200
    24.082     1.867     0.200
    24.222     0.834     0.200
    24.394     2.925     0.200
    25.081     2.140     0.200
    25.503     0.296     0.200
    25.685     2.677     0.200
    26.521     1.610     0.200
    26.638     1.234     0.200
    27.127     1.026     0.200
    28.022     0.950     0.200
    28.113     0.767     0.200
    28.670     1.302     0.200
    28.677     1.941     0.200
    28.830     1.009     0.200
    30.226     2.320     0.200
    30.389     2.470     0.200
    30.462     2.216     0.200
    30.812     2.435     0.200
    31.094     2.969     0.200
    31.644     3.044     0.200
    31.819     1.521     0.200
    32.476     1.615     0.200
    32.565     1.646     0.200
    32.768     2.518     0.200
    33.467     2.562     0.200
    33.582     2.061     0.200
    34.603     1.236     0.200
    35.220     2.139     0.200
    35.647     1.652     0.200
    36.030     1.649     0.200
    36.159     2.000     0.200
    36.424    -2.614     0.200
    38.208    -0.422     0.200
    39.164     1.175     0.200
    39.685     1.978     0.200
    40.321    -0.689     0.200
    42.390     1.594     0.200
    42.648    -1.797     0.200
    45.023     1.417     0.200
    45.023     1.624     0.200
    45.869    -0.098     0.200
    46.152     0.602     0.200
    48.037    -0.397     0.200
    48.037    -1.701     0.200
    48.037    -0.962     0.200
    48.494    -2.146     0.200
    49.524    -2.464     0.200
    53.230    -1.692     0.200
    53.458    -1.724     0.200
    53.879    -2.337     0.200
    54.574     0.428     0.200
    54.909    -1.125     0.200
    55.013    -1.972     0.200
    55.313    -1.034     0.200
    58.066    -1.548     0.200
    58.742    -2.677     0.200
    59.007    -0.867     0.200
    60.911    -1.567     0.200
    61.480    -1.121     0.200
    61.480    -1.121     0.200
    61.584    -1.566     0.200
    62.523    -1.314     0.200
    62.710    -2.260     0.200
    62.732    -0.809     0.200
    63.358    -2.560     0.200
    63.478    -1.953     0.200
    64.003    -1.904     0.200
    64.426    -1.971     0.200
    65.200    -1.711     0.200
    65.945    -1.868     0.200
    66.547    -1.477     0.200
    67.557    -2.279     0.200
    69.026    -1.468     0.200
    71.230    -2.265     0.200
    71.282    -0.878     0.200
    71.599    -0.191     0.200
    71.637    -0.419     0.200
    71.783    -0.095     0.200
    71.828    -0.269     0.200
    71.962    -0.971     0.200
    72.170    -1.114     0.200
    72.306    -0.224     0.200
    72.308    -1.141     0.200
    72.455    -0.313     0.200
    72.524    -0.025     0.200
    72.705    -0.299     0.200
    72.739     0.299     0.200
    73.060     0.001     0.200
    73.406    -0.438     0.200
    73.490    -0.032     0.200
    73.510    -0.150     0.200
    73.889    -0.571     0.200
    74.136    -0.815     0.200
    74.286    -0.289     0.200
    74.322    -0.198     0.200
    74.682    -0.682     0.200
    74.835    -0.673     0.200
    74.893    -0.606     0.200
    75.055     0.760     0.200
    75.184     0.017     0.200
    75.188     0.295     0.200
    75.228    -1.032     0.200
    75.855    -0.420     0.200
    76.084    -0.229     0.200
    76.169    -0.308     0.200
    76.310    -0.509     0.200
    76.386    -0.040     0.200
    76.763    -0.871     0.200
    76.865    -0.446     0.200
    77.020     0.933     0.200
    77.168    -0.345     0.200
    77.750    -0.200     0.200
    77.845     0.376     0.200
    77.873    -0.781     0.200
    77.880    -0.223     0.200
    78.047    -0.748     0.200
    78.101    -0.446     0.200
    78.300    -0.546     0.200
    78.505    -0.379     0.200
    78.681     0.645     0.200
    79.044     0.461     0.200
    79.479     1.239     0.200
    79.583    -0.371     0.200
    80.305     0.435     0.200
    80.305     0.795     0.200
    80.319     0.440     0.200
    80.349    -1.233     0.200
    81.395    -0.689     0.200
    81.478    -0.827     0.200
    81.537    -0.338     0.200
    81.601     1.604     0.200
    82.365    -0.283     0.200
    82.894     1.478     0.200
    83.109    -0.947     0.200
    83.075     1.850     0.200
    83.123     1.322     0.200
    83.202     0.495     0.200
    96.749    -1.169     0.200
    19.769    -0.887     0.200
    19.854     0.106     0.200
    19.860    -0.185     0.200
    19.860     0.160     0.200
    20.708     1.179     0.200
    21.027     0.619     0.200
    21.151     2.187     0.200
    21.553     2.227     0.200
    21.560     2.036     0.200
    21.595     1.820     0.200
    21.731     1.342     0.200
    21.995     1.841     0.200
    22.097     1.943     0.200
    22.269     1.806     0.200
    22.514     1.680     0.200
    22.786     1.569     0.200
    22.837     1.300     0.200
    22.944     1.535     0.200
    23.033     1.276     0.200
    23.129     1.304     0.200
    23.191     1.812     0.200
    23.191     1.391     0.200
    23.707     2.031     0.200
    24.492     1.188     0.200
    24.638     3.002     0.200
    25.778     0.144     0.200
    26.190     2.059     0.200
    26.575     1.701     0.200
    27.258    -2.167     0.200
    27.070     1.096     0.200
    27.171     2.160     0.200
    27.214     1.993     0.200
    27.568    -1.390     0.200
    27.568     1.449     0.200
    27.630     1.689     0.200
    27.801     1.199     0.200
    27.822     2.068     0.200
    27.860     0.932     0.200
    27.946     1.622     0.200
    28.161     0.059     0.200
    28.375     1.817     0.200
    28.622     1.802     0.200
    28.955    -1.440     0.200
    28.757     2.034     0.200
    29.173     2.142     0.200
    29.173     2.644     0.200
    29.340     2.307     0.200
    29.413     2.023     0.200
    29.604     2.763     0.200
    29.631     2.729     0.200
    29.734     2.257     0.200
    29.950     1.687     0.200
    30.049     2.701     0.200
    30.154     1.966     0.200
    30.204     1.800     0.200
    30.239     2.176     0.200
    30.487     0.032     0.200
    30.501     2.225     0.200
    30.782     1.775     0.200
    30.844     2.046     0.200
    30.929     2.229     0.200
    31.049     1.379     0.200
    31.273     1.782     0.200
    31.375     2.299     0.200
    31.408     1.707     0.200
    31.435     1.538     0.200
    31.512     2.200     0.200
    31.515     2.206     0.200
    31.733     2.055     0.200
    32.402     2.783     0.200
    32.414     2.568     0.200
    32.537     1.999     0.200
    32.798     1.941     0.200
    32.893     2.038     0.200
    33.236     3.574     0.200
    33.554     1.675     0.200
    33.979    -1.794     0.200
    34.066     1.351     0.200
    34.066     1.181     0.200
    34.170     2.075     0.200
    34.597     1.664     0.200
    34.978     1.713     0.200
    34.983     1.656     0.200
    35.105     2.288     0.200
    35.317     1.856     0.200
    36.524     2.061     0.200
    37.400    -2.468     0.200
    37.310     0.336     0.200
    37.930     2.009     0.200
    38.112     1.785     0.200
    38.875     1.613     0.200
    39.441    -0.493     0.200
    42.256    -1.299     0.200
    43.424    -0.869     0.200
    43.698    -1.575     0.200
    43.969     1.879     0.200
    43.969     1.898     0.200
    44.064    -0.665     0.200
    44.200    -0.259     0.200
    44.933    -0.757     0.200
    45.104     1.163     0.200
    45.364     0.252     0.200
    45.419    -0.601     0.200
    45.842    -0.177     0.200
    46.265    -2.291     0.200
    46.670     0.086     0.200
    46.928    -0.462     0.200
    47.004    -0.324     0.200
    47.334     0.388     0.200
    47.519     0.008     0.200
    47.650     1.715     0.200
    47.669     0.273     0.200
    47.884     1.276     0.200
    47.884     0.726     0.200
    48.130    -0.425     0.200
    48.049     0.454     0.200
    49.064     0.069     0.200
    49.065     0.186     0.200
    49.065     0.186     0.200
    49.047    -0.059     0.200
    49.323     0.175     0.200
    49.525    -2.004     0.200
    49.525    -1.356     0.200
    49.684    -0.182     0.200
    49.968    -0.303     0.200
    50.086    -0.427     0.200
    50.100    -0.511     0.200
    50.139    -0.096     0.200
    50.138    -0.061     0.200
    50.378    -0.436     0.200
    50.576    -2.402     0.200
    50.569    -0.312     0.200
    51.747    -0.459     0.200
    52.952    -1.934     0.200
    53.551    -0.566     0.200
    53.564    -1.935     0.200
    53.781    -1.181     0.200
    53.770    -0.125     0.200
    54.281    -0.370     0.200
    54.845    -1.366     0.200
    54.845    -1.076     0.200
    54.800     0.302     0.200
    55.304    -0.783     0.200
    55.672    -0.427     0.200
    55.918    -0.788     0.200
    55.985    -0.974     0.200
    56.313    -1.221     0.200
    56.799    -2.399     0.200
    58.009    -1.503     0.200
    58.029    -2.145     0.200
    58.029    -1.300     0.200
    58.266    -2.171     0.200
    59.578    -2.810     0.200
    59.635    -0.500     0.200
    59.860    -0.595     0.200
    60.479    -1.285     0.200
    60.561    -1.847     0.200
    61.240    -1.458     0.200
    61.662    -0.809     0.200
    61.662    -0.829     0.200
    61.910    -0.803     0.200
    62.835    -0.969     0.200
    62.835    -1.270     0.200
    62.892    -0.940     0.200
    63.366    -0.793     0.200
    64.113    -2.277     0.200
    64.113    -1.717     0.200
    64.119    -0.858     0.200
    64.119    -3.058     0.200
    64.557    -1.123     0.200
    64.759    -1.742     0.200
    64.759    -1.342     0.200
    65.173    -1.704     0.200
    65.399    -0.396     0.200
    65.399    -1.016     0.200
    66.000     0.828     0.200
    66.206    -1.298     0.200
    66.300    -1.998     0.200
    66.367    -1.031     0.200
    66.824    -1.450     0.200
    67.476    -0.886     0.200
    67.994    -0.750     0.200
    67.994    -1.650     0.200
    67.994    -2.650     0.200
    67.994    -2.250     0.200
    68.601    -0.051     0.200
    69.061    -1.736     0.200
    69.320    -1.218     0.200
    70.144    -0.184     0.200
    70.357    -0.098     0.200
    71.211    -0.132     0.200
    71.365    -1.424     0.200
    71.455    -0.361     0.200
    71.662    -0.111     0.200
    71.704    -1.162     0.200
    71.708    -0.285     0.200
    71.966    -0.237     0.200
    71.983    -0.137     0.200
    72.058     0.212     0.200
    72.173     0.321     0.200
    72.169    -0.656     0.200
    72.279    -0.211     0.200
    72.318    -1.241     0.200
    72.486    -0.244     0.200
    72.666     0.385     0.200
    72.835    -2.223     0.200
    72.886     0.478     0.200
    72.886     0.478     0.200
    72.893    -0.267     0.200
    72.996    -0.373     0.200
    72.857    -0.233     0.200
    73.051    -0.700     0.200
    73.051    -0.580     0.200
    73.049    -1.587     0.200
    73.202     0.110     0.200
    73.260     0.368     0.200
    73.272     0.493     0.200
    73.316    -0.435     0.200
    73.304    -0.094     0.200
    73.600    -1.438     0.200
    73.421    -1.232     0.200
    73.664     0.288     0.200
    73.692     0.023     0.200
    73.692    -0.387     0.200
    73.704     0.055     0.200
    73.722    -0.010     0.200
    73.817    -1.011     0.200
    73.871    -0.125     0.200
    73.906    -0.031     0.200
    73.958     0.063     0.200
    73.970    -0.304     0.200
    74.223    -0.380     0.200
    74.225    -0.094     0.200
    74.315    -0.116     0.200
    74.332    -0.219     0.200
    74.401     0.084     0.200
    74.676     0.084     0.200
    74.720    -0.468     0.200
    74.863    -0.897     0.200
    74.866    -0.415     0.200
    74.937    -0.526     0.200
    74.995    -0.158     0.200
    75.025    -0.431     0.200
    75.117    -0.162     0.200
    75.194     0.094     0.200
    75.252     0.259     0.200
    75.298     0.207     0.200
    75.300     0.082     0.200
    75.328     0.424     0.200
    75.329     0.515     0.200
    75.401     1.805     0.200
    75.403     0.489     0.200
    75.562     0.583     0.200
    75.679     0.712     0.200
    75.691     0.240     0.200
    75.678     0.219     0.200
    75.863    -0.539     0.200
    75.972     0.516     0.200
    76.081    -0.082     0.200
    76.197     1.089     0.200
    76.221     0.423     0.200
    76.349    -0.008     0.200
    76.384     0.048     0.200
    76.463     0.849     0.200
    76.484     1.031     0.200
    76.474     0.826     0.200
    76.533    -0.929     0.200
    76.665    -2.095     0.200
    76.766    -1.467     0.200
    76.759     0.476     0.200
    76.810    -0.411     0.200
    76.811    -0.017     0.200
    76.911     1.360     0.200
    76.900     0.802     0.200
    76.929     0.118     0.200
    77.018     0.018     0.200
    77.102    -0.627     0.200
    77.179     0.623     0.200
    77.242     0.755     0.200
    77.449    -0.802     0.200
    77.445     0.222     0.200
    77.490     1.272     0.200
    77.525     0.226     0.200
    77.550     0.582     0.200
    77.551     0.628     0.200
    77.485    -2.065     0.200
    77.708     1.031     0.200
    77.807     0.603     0.200
    77.814     0.459     0.200
    77.822     0.919     0.200
    77.856    -0.669     0.200
    77.889    -0.055     0.200
    77.890     0.939     0.200
    77.948     1.016     0.200
    78.008     0.684     0.200
    78.050     0.349     0.200
    78.077     0.103     0.200
    78.095     1.332     0.200
    78.110     0.417     0.200
    77.982    -0.695     0.200
    78.138     1.301     0.200
    78.204     0.295     0.200
    78.143     0.335     0.200
    78.181    -0.178     0.200
    78.256     0.112     0.200
    78.293    -0.195     0.200
    78.308    -0.761     0.200
    78.309     0.618     0.200
    78.369    -0.214     0.200
    78.380     0.432     0.200
    78.473     1.300     0.200
    78.578    -0.967     0.200
    78.578    -0.787     0.200
    78.571    -0.033     0.200
    78.567     0.594     0.200
    78.585     1.063     0.200
    78.674     0.805     0.200
    78.689     1.017     0.200
    78.708    -0.966     0.200
    78.711     0.749     0.200
    78.693     0.398     0.200
    79.041    -0.323     0.200
    78.926    -0.943     0.200
    79.188    -0.110     0.200
    79.219     0.111     0.200
    79.244     0.756     0.200
    79.239     0.504     0.200
    79.327    -0.175     0.200
    79.429     0.069     0.200
    79.477     0.408     0.200
    79.521     0.445     0.200
    79.433    -1.193     0.200
    79.590    -0.338     0.200
    79.616     0.279     0.200
    79.680    -0.197     0.200
    79.561    -0.813     0.200
    79.724     0.266     0.200
    80.099     0.635     0.200
    80.213     0.580     0.200
    80.213     0.400     0.200
    80.264    -0.746     0.200
    80.278     0.989     0.200
    80.367     0.033     0.200
    80.346     0.004     0.200
    80.259    -0.256     0.200
    80.528    -0.072     0.200
    80.395    -1.228     0.200
    80.695     0.070     0.200
    80.569     0.434     0.200
    80.861     0.343     0.200
    80.926     1.499     0.200
    81.045    -0.726     0.200
    81.098     0.282     0.200
    81.215     0.959     0.200
    81.130     0.542     0.200
    81.300    -0.193     0.200
    81.439    -2.029     0.200
    81.402     0.969     0.200
    81.423     0.825     0.200
    81.466     0.877     0.200
    81.466     0.627     0.200
    81.480     0.515     0.200
    81.491     0.096     0.200
    81.386     0.434     0.200
    81.523     1.354     0.200
    81.643    -0.566     0.200
    81.701    -0.515     0.200
    81.701     0.485     0.200
    81.689     1.090     0.200
    81.698     1.084     0.200
    81.719     1.414     0.200
    81.821     1.257     0.200
    81.870    -0.405     0.200
    81.870    -0.215     0.200
    81.991     0.260     0.200
    81.997    -0.670     0.200
    82.030     0.156     0.200
    82.172     0.811     0.200
    82.167     1.609     0.200
    82.202     1.281     0.200
    82.300    -0.561     0.200
    82.374    -0.546     0.200
    82.319    -0.781     0.200
    82.453    -0.557     0.200
    82.506     0.066     0.200
    82.513    -0.571     0.200
    82.542    -0.324     0.200
    82.503     1.142     0.200
    82.606    -0.054     0.200
    82.555     1.258     0.200
    82.598     1.087     0.200
    82.620     0.969     0.200
    82.597     0.750     0.200
    82.724     0.731     0.200
    82.596    -1.872     0.200
    82.784    -0.182     0.200
    82.790     1.237     0.200
    82.855    -0.252     0.200
    82.906     0.424     0.200
    82.965    -0.621     0.200
    82.990    -1.751     0.200
    83.025    -0.733     0.200
    83.025    -0.533     0.200
    83.073     0.823     0.200
    83.226    -0.868     0.200
    83.300    -0.259     0.200
    83.490     0.971     0.200
    83.490     0.371     0.200
    83.810    -0.868     0.200
    83.989    -0.783     0.200
    84.157    -1.428     0.200
    84.157    -0.688     0.200
    84.137    -0.699     0.200
    84.241     0.434     0.200
    84.241    -0.166     0.200
    84.405     0.800     0.200
    84.415    -0.349     0.200
    84.555    -0.257     0.200
    84.755    -1.363     0.200
    84.984    -0.715     0.200
    85.076    -0.139     0.200
    85.814     0.446     0.200
    86.239    -0.955     0.200
    86.239    -0.455     0.200
    87.698     3.557     0.200
    88.188    -1.081     0.200
    89.590    -1.295     0.200
    89.590    -0.745     0.200
    92.041     1.969     0.200
    94.383    -2.260     0.200
    95.237    -3.169     0.200
    95.237     2.271     0.200
    98.314    -0.900     0.200
    19.712    -2.374     0.200
    19.712    -1.784     0.200
    19.896    -0.351     0.200
    19.903     0.132     0.200
    21.255    -1.635     0.200
    23.248     1.051     0.200
    24.693     1.179     0.200
    27.687     1.167     0.200
    29.395     0.700     0.200
    29.468     1.340     0.200
    30.558     1.679     0.200
    30.839     1.359     0.200
    30.901     1.502     0.200
    33.263     2.172     0.200
    33.940    -3.678     0.200
    33.940    -1.868     0.200
    34.227     1.579     0.200
    36.581     1.531     0.200
    37.363     0.616     0.200
    38.169     0.913     0.200
    42.442     0.331     0.200
    43.429    -0.718     0.200
    43.643    -2.143     0.200
    44.026     1.192     0.200
    44.026     0.432     0.200
    44.120     0.073     0.200
    45.161     0.707     0.200
    45.291     0.165     0.200
    46.217    -3.627     0.200
    49.472    -1.830     0.200
    53.555    -1.079     0.200
    53.772    -1.157     0.200
    55.937    -1.741     0.200
    56.262    -1.204     0.200
    60.375    -0.592     0.200
    61.230    -0.710     0.200
    61.661    -0.817     0.200
    61.661    -0.666     0.200
    61.901    -0.811     0.200
    64.079    -1.957     0.200
    64.725    -1.333     0.200
    65.140    -1.500     0.200
    66.155    -0.784     0.200
    66.782    -1.421     0.200
    67.431    -1.012     0.200
    71.983    -0.054     0.200
    72.074     0.403     0.200
    72.179    -0.823     0.200
    72.473    -0.281     0.200
    73.697    -0.421     0.200
    73.958    -0.010     0.200
    73.974    -0.344     0.200
    74.227    -0.519     0.200
    74.324    -0.185     0.200
    74.487    -0.230     0.200
    74.727    -0.422     0.200
    74.873    -0.371     0.200
    75.033    -0.490     0.200
    75.306     0.139     0.200
    75.871    -0.502     0.200
    76.090    -0.348     0.200
    76.468     0.008     0.200
    76.489    -0.011     0.200
    77.825     0.386     0.200
    77.866    -0.038     0.200
    77.898    -0.117     0.200
    78.186    -0.317     0.200
    78.557    -0.568     0.200
    78.577    -0.076     0.200
    82.058     0.194     0.200
    82.325    -0.204     0.200
    82.404    -0.517     0.200
    82.464    -0.428     0.200
    82.507    -0.453     0.200
    83.483    -0.437     0.200
    84.102    -1.172     0.200
    20.051    -0.593     0.200
    32.826     3.560     0.200
    52.611    -3.452     0.200
    60.631    -1.828     0.200
    60.737    -3.169     0.200
    65.333    -2.342     0.200
    72.934    -0.727     0.200
    79.496    -0.537     0.200
    82.838    -1.880     0.200
    18.858    -1.393     0.200
    20.158    -0.809     0.200
    28.711     2.221     0.200
    30.543     1.508     0.200
    30.614     2.705     0.200
    31.814     0.841     0.200
    32.712     1.869     0.200
    45.107     1.392     0.200
    65.536    -3.149     0.200
    79.717    -1.389     0.200
    18.463    -0.244     0.200
    20.164     0.981     0.200
    20.975    -1.356     0.200
    21.003     2.051     0.200
    21.153     2.728     0.200
    21.317     1.814     0.200
    21.333     3.380     0.200
    21.447     1.523     0.200
    22.231     0.562     0.200
    22.508     1.777     0.200
    22.537     1.280     0.200
    22.537     0.745     0.200
    22.531     2.048     0.200
    22.822     2.233     0.200
    23.527     0.733     0.200
    23.661     1.793     0.200
    23.725     0.623     0.200
    24.085     2.313     0.200
    24.461     2.600     0.200
    24.686     1.982     0.200
    25.111     0.503     0.200
    25.450     1.566     0.200
    25.457     1.653     0.200
    25.843     1.454     0.200
    26.288     0.881     0.200
    26.374    -0.812     0.200
    26.839     1.346     0.200
    26.940     1.000     0.200
    27.022     1.115     0.200
    27.025     1.578     0.200
    27.111     2.324     0.200
    27.247    -0.511     0.200
    27.605     2.017     0.200
    27.753     1.697     0.200
    27.756     1.475     0.200
    28.060     1.552     0.200
    28.106     1.573     0.200
    28.470     2.809     0.200
    29.113    -1.167     0.200
    29.113    -0.347     0.200
    29.075     1.805     0.200
    29.139    -0.205     0.200
    29.197     1.728     0.200
    29.553     2.561     0.200
    29.744     1.764     0.200
    29.750     1.832     0.200
    29.882     2.510     0.200
    29.920     1.637     0.200
    29.977     1.875     0.200
    30.165     1.339     0.200
    30.403     1.545     0.200
    30.417     1.580     0.200
    31.020     2.121     0.200
    31.317     1.293     0.200
    31.999     2.219     0.200
    32.009     2.166     0.200
    32.374     1.650     0.200
    32.581    -0.132     0.200
    32.707     1.346     0.200
    32.999     2.472     0.200
    33.412    -2.564     0.200
    33.342     1.835     0.200
    33.938     1.702     0.200
    34.766     2.025     0.200
    35.151     1.779     0.200
    35.962     1.724     0.200
    37.234    -2.524     0.200
    37.651     1.554     0.200
    37.651     1.814     0.200
    37.658     2.321     0.200
    37.741     2.030     0.200
    37.843    -0.388     0.200
    38.012     2.335     0.200
    38.150     1.517     0.200
    38.197     2.029     0.200
    39.985    -0.742     0.200
    39.985    -1.041     0.200
    40.474     1.076     0.200
    40.890     1.516     0.200
    41.081     1.757     0.200
    41.740     0.957     0.200
    41.985    -0.059     0.200
    42.707     0.097     0.200
    42.707    -0.473     0.200
    43.188    -0.749     0.200
    43.614    -1.497     0.200
    43.616    -1.174     0.200
    43.567     1.667     0.200
    43.674    -0.488     0.200
    43.817    -0.823     0.200
    43.990    -2.636     0.200
    44.578     0.525     0.200
    44.609     0.579     0.200
    44.860     0.749     0.200
    45.147     0.199     0.200
    45.676     0.289     0.200
    46.051    -2.617     0.200
    46.832     0.391     0.200
    48.262    -2.356     0.200
    49.104     1.924     0.200
    49.341     0.467     0.200
    49.785    -2.438     0.200
    49.785    -2.219     0.200
    49.785    -1.918     0.200
    50.900    -1.852     0.200
    51.315    -0.046     0.200
    51.575    -1.817     0.200
    52.224    -0.882     0.200
    52.288    -2.225     0.200
    52.305     1.360     0.200
    52.495    -2.016     0.200
    52.495    -2.359     0.200
    52.980    -0.904     0.200
    54.083    -1.234     0.200
    54.083    -0.933     0.200
    54.442    -2.045     0.200
    54.458    -1.014     0.200
    55.789    -1.370     0.200
    56.230    -0.969     0.200
    56.254    -0.570     0.200
    56.887    -2.354     0.200
    58.246    -1.356     0.200
    58.413     1.547     0.200
    58.999    -2.801     0.200
    59.145    -2.010     0.200
    59.771    -0.829     0.200
    59.957    -1.409     0.200
    60.270    -1.454     0.200
    60.270    -1.227     0.200
    60.424    -3.409     0.200
    60.433    -2.500     0.200
    60.625    -1.231     0.200
    61.369    -0.202     0.200
    61.487    -0.328     0.200
    62.318    -0.709     0.200
    62.458    -0.946     0.200
    62.858    -0.812     0.200
    63.188    -1.985     0.200
    63.188    -1.805     0.200
    63.271    -1.354     0.200
    63.368    -2.210     0.200
    63.368    -1.999     0.200
    63.965    -2.338     0.200
    63.965    -2.178     0.200
    63.965    -1.637     0.200
    64.016    -1.368     0.200
    64.016    -1.759     0.200
    64.021    -1.726     0.200
    64.413    -1.870     0.200
    64.556    -2.609     0.200
    64.585    -0.295     0.200
    65.202    -2.511     0.200
    65.202    -2.812     0.200
    66.136    -2.138     0.200
    66.148    -1.817     0.200
    66.343    -1.964     0.200
    66.507    -1.812     0.200
    66.740    -0.900     0.200
    66.811    -2.352     0.200
    66.811    -2.552     0.200
    67.129    -0.376     0.200
    67.157    -1.052     0.200
    67.188    -0.051     0.200
    68.007    -1.016     0.200
    68.705    -0.604     0.200
    69.258     0.180     0.200
    69.764    -0.569     0.200
    69.812    -1.539     0.200
    70.056    -0.635     0.200
    70.204    -0.242     0.200
    70.253    -0.543     0.200
    70.573    -0.200     0.200
    70.572    -0.296     0.200
    70.565    -0.450     0.200
    70.685    -0.678     0.200
    70.784    -0.385     0.200
    70.799     0.026     0.200
    70.799    -0.173     0.200
    70.870    -0.936     0.200
    70.912     0.040     0.200
    70.957    -0.336     0.200
    70.971    -0.018     0.200
    70.976    -0.450     0.200
    70.988    -0.622     0.200
    71.064     0.014     0.200
    71.110    -0.164     0.200
    71.276    -0.663     0.200
    71.291     0.146     0.200
    71.471     0.155     0.200
    71.471     0.155     0.200
    71.504    -0.342     0.200
    71.520    -0.740     0.200
    71.649    -0.620     0.200
    71.763    -0.501     0.200
    71.847    -0.310     0.200
    71.900    -0.612     0.200
    71.907    -0.855     0.200
    71.930    -0.607     0.200
    71.950    -1.054     0.200
    71.870    -0.202     0.200
    72.079    -0.717     0.200
    72.270    -0.539     0.200
    72.252    -0.333     0.200
    72.266     0.086     0.200
    72.321    -0.076     0.200
    72.334    -0.353     0.200
    72.371     0.156     0.200
    72.426    -0.672     0.200
    72.485    -0.583     0.200
    72.476     0.133     0.200
    72.469    -0.529     0.200
    72.520    -0.430     0.200
    72.560    -0.171     0.200
    72.560    -0.433     0.200
    72.672    -0.436     0.200
    72.774    -0.091     0.200
    72.751    -1.504     0.200
    72.776    -0.450     0.200
    72.780    -0.674     0.200
    72.827    -0.257     0.200
    72.867    -0.391     0.200
    72.872    -0.724     0.200
    73.012    -0.349     0.200
    73.048    -0.264     0.200
    73.178    -1.430     0.200
    73.184     0.151     0.200
    73.211    -1.425     0.200
    73.228    -0.529     0.200
    73.250    -0.660     0.200
    73.327     0.186     0.200
    73.393    -0.504     0.200
    73.419    -1.151     0.200
    73.470    -0.555     0.200
    73.491     0.622     0.200
    73.548    -0.614     0.200
    73.774    -0.040     0.200
    73.882    -0.772     0.200
    73.909     0.272     0.200
    73.914     0.443     0.200
    73.932    -0.361     0.200
    73.950     0.132     0.200
    73.950    -0.007     0.200
    74.092     0.101     0.200
    74.207     0.029     0.200
    74.204    -0.355     0.200
    74.275     0.632     0.200
    74.305     0.358     0.200
    74.311    -0.375     0.200
    74.411     0.093     0.200
    74.493     0.177     0.200
    74.575    -0.007     0.200
    74.595    -0.124     0.200
    74.748    -1.911     0.200
    74.827     0.430     0.200
    74.844    -0.366     0.200
    74.895     1.036     0.200
    74.880    -0.616     0.200
    74.945     0.097     0.200
    74.954     0.095     0.200
    74.961     0.678     0.200
    75.011     0.870     0.200
    75.032     1.049     0.200
    75.087    -0.581     0.200
    75.077    -1.092     0.200
    75.118    -1.249     0.200
    75.124     0.648     0.200
    75.234    -1.137     0.200
    75.345    -0.055     0.200
    75.447     0.458     0.200
    75.457     0.490     0.200
    75.470     0.126     0.200
    75.655     0.337     0.200
    75.747     0.060     0.200
    75.789     0.901     0.200
    75.903    -0.557     0.200
    75.973     0.252     0.200
    76.054    -0.111     0.200
    76.204    -0.102     0.200
    76.219    -0.345     0.200
    76.299     0.902     0.200
    76.319     0.387     0.200
    76.340    -1.557     0.200
    76.340    -1.477     0.200
    76.345     0.640     0.200
    76.367    -0.386     0.200
    76.364    -0.671     0.200
    76.372    -1.128     0.200
    76.407    -0.215     0.200
    76.464     0.375     0.200
    76.499    -0.786     0.200
    76.564    -1.510     0.200
    76.600     0.994     0.200
    76.627     0.542     0.200
    76.674    -0.287     0.200
    76.731    -0.144     0.200
    76.784    -1.783     0.200
    76.784     0.353     0.200
    76.736     0.067     0.200
    76.885    -1.316     0.200
    76.913    -0.169     0.200
    77.050     1.429     0.200
    77.085    -0.839     0.200
    77.114     0.097     0.200
    77.163     1.023     0.200
    77.169     0.288     0.200
    77.169     0.079     0.200
    77.304     0.421     0.200
    77.493    -0.978     0.200
    77.715     0.137     0.200
    78.016    -0.089     0.200
    78.016     0.442     0.200
    78.119     0.793     0.200
    78.116    -0.389     0.200
    78.125    -0.335     0.200
    78.195     0.971     0.200
    78.195     0.731     0.200
    78.366     0.986     0.200
    78.556    -0.723     0.200
    78.699     0.352     0.200
    78.699     0.139     0.200
    78.742     0.652     0.200
    78.779    -0.171     0.200
    78.824    -0.599     0.200
    78.819    -0.171     0.200
    78.861     0.195     0.200
    78.771     1.002     0.200
    78.911     0.425     0.200
    78.837     0.639     0.200
    79.059     1.975     0.200
    79.421    -0.866     0.200
    79.479    -0.083     0.200
    79.496    -0.272     0.200
    79.569     0.332     0.200
    79.634    -0.024     0.200
    79.736    -0.613     0.200
    79.877    -0.903     0.200
    79.897    -0.396     0.200
    79.961     0.003     0.200
    79.964     0.487     0.200
    79.982    -0.177     0.200
    79.998    -0.284     0.200
    80.031     0.324     0.200
    80.182    -0.311     0.200
    80.212     0.688     0.200
    80.373    -0.015     0.200
    80.441     0.120     0.200
    80.429     0.912     0.200
    80.557    -4.696     0.200
    80.689    -0.102     0.200
    80.784     1.322     0.200
    80.931     0.255     0.200
    80.848     0.190     0.200
    81.045    -0.413     0.200
    81.070     0.956     0.200
    81.081     1.719     0.200
    81.273     1.035     0.200
    81.543     0.916     0.200
    81.597    -0.177     0.200
    81.631     1.280     0.200
    81.845     0.155     0.200
    81.944     0.434     0.200
    81.905    -2.872     0.200
    82.190    -0.056     0.200
    82.252    -0.383     0.200
    82.283     0.459     0.200
    82.334    -0.310     0.200
    82.420    -0.058     0.200
    82.576    -1.170     0.200
    82.864    -0.269     0.200
    83.193     0.398     0.200
    83.256    -1.697     0.200
    83.621    -0.411     0.200
    84.082    -1.528     0.200
    84.334    -0.710     0.200
    84.390    -2.493     0.200
    86.889    -1.294     0.200
    87.060    -0.822     0.200
    89.660     0.693     0.200
    94.170    -0.949     0.200
    19.279    -0.149     0.200
    19.680    -1.437     0.200
    21.891     1.993     0.200
    23.416     1.173     0.200
    23.441     1.466     0.200
    26.322     1.050     0.200
    26.689     2.105     0.200
    26.851    -0.267     0.200
    27.199     1.094     0.200
    27.920     0.861     0.200
    29.975    -0.240     0.200
    29.940     2.580     0.200
    30.737     1.621     0.200
    30.861     1.463     0.200
    31.065     0.849     0.200
    31.065     1.556     0.200
    31.299     2.341     0.200
    31.659     2.337     0.200
    32.870     2.087     0.200
    33.024     1.486     0.200
    33.171     0.979     0.200
    33.248     1.742     0.200
    33.430     0.509     0.200
    33.818     1.840     0.200
    34.154     1.790     0.200
    34.983     1.139     0.200
    35.347     1.582     0.200
    35.612     1.216     0.200
    36.854     1.380     0.200
    38.524     1.307     0.200
    42.229    -1.072     0.200
    42.644     0.609     0.200
    44.429     0.247     0.200
    44.429     1.805     0.200
    44.591    -0.366     0.200
    45.465     0.414     0.200
    46.861    -0.850     0.200
    47.302     0.193     0.200
    48.099     0.120     0.200
    50.257    -0.491     0.200
    50.521    -0.202     0.200
    52.531    -2.283     0.200
    58.800    -1.433     0.200
    60.437    -0.071     0.200
    60.437     0.279     0.200
    60.661    -1.370     0.200
    62.968    -3.049     0.200
    63.619    -1.718     0.200
    65.795    -1.845     0.200
    70.766    -0.156     0.200
    71.307    -0.133     0.200
    72.442    -0.535     0.200
    72.736    -0.745     0.200
    72.777    -0.525     0.200
    73.152    -0.447     0.200
    73.158    -0.479     0.200
    73.196     0.479     0.200
    73.302    -0.529     0.200
    73.543    -0.746     0.200
    73.693    -0.623     0.200
    73.758    -0.809     0.200
    74.110    -0.166     0.200
    74.458     0.412     0.200
    74.922    -0.373     0.200
    75.125    -0.142     0.200
    76.668     0.167     0.200
    76.725    -0.351     0.200
    79.099     0.560     0.200
    15.718     2.044     0.200
    19.314    -0.726     0.200
    19.756    -0.309     0.200
    19.766    -0.004     0.200
    20.326    -0.881     0.200
    23.747     1.858     0.200
    23.747     2.002     0.200
    25.433     2.458     0.200
    27.318    -0.362     0.200
    30.124     2.905     0.200
    31.133     2.217     0.200
    31.362     1.784     0.200
    33.506     2.260     0.200
    37.137     2.311     0.200
    42.014     1.282     0.200
    44.668     1.570     0.200
    45.077    -0.228     0.200
    48.466     0.213     0.200
    52.865    -2.733     0.200
    60.817    -1.244     0.200
    60.993    -0.881     0.200
    65.829    -1.965     0.200
    71.661     0.543     0.200
    73.118     0.341     0.200
    73.569     0.212     0.200
    73.720     0.231     0.200
    73.962     0.016     0.200
    74.176    -0.032     0.200
    76.047     0.005     0.200
    76.462    -0.146     0.200
    77.103     0.141     0.200
    77.302     0.818     0.200
    79.546     0.895     0.200
    81.091    -0.537     0.200
    81.444    -0.607     0.200
    81.518    -0.902     0.200
    81.584    -0.750     0.200
    82.144    -0.691     0.200
    83.373    -0.464     0.200
    83.373    -0.613     0.200
    20.170    -0.388     0.200
    45.432    -0.851     0.200
    65.312    -2.953     0.200
    19.091    -0.518     0.200
    19.103    -0.142     0.200
    19.661    -0.631     0.200
    19.996    -1.460     0.200
    22.681     0.153     0.200
    23.552     1.037     0.200
    25.502     0.882     0.200
    28.143     0.066     0.200
    29.805    -0.842     0.200
    29.826     1.828     0.200
    30.172     1.466     0.200
    31.184     1.069     0.200
    33.409     1.018     0.200
    34.716     0.605     0.200
    36.988     0.161     0.200
    41.827    -0.090     0.200
    44.362    -1.086     0.200
    44.607    -0.211     0.200
    45.608    -0.124     0.200
    47.223    -0.932     0.200
    47.796    -0.474     0.200
    49.858    -0.474     0.200
    52.079    -1.840     0.200
    55.511    -1.195     0.200
    57.202    -0.737     0.200
    59.994    -1.035     0.200
    60.208    -2.286     0.200
    62.235     0.681     0.200
    66.120    -0.758     0.200
    66.165     2.957     0.200
    83.346    -1.680     0.200
    18.791    -1.137     0.200
    20.752    -1.464     0.200
    20.752    -1.714     0.200
    22.115     0.811     0.200
    22.878     1.235     0.200
    22.878     0.836     0.200
    23.955     0.862     0.200
    24.751     1.787     0.200
    24.751     1.896     0.200
    25.059     1.595     0.200
    25.753     2.470     0.200
    25.758    -0.071     0.200
    26.583     0.252     0.200
    26.633    -0.092     0.200
    27.441     1.209     0.200
    28.816    -0.743     0.200
    28.993     2.579     0.200
    29.101     2.145     0.200
    29.197     2.073     0.200
    29.366     1.666     0.200
    29.425     0.933     0.200
    30.504     1.298     0.200
    30.504     1.663     0.200
    32.456     1.725     0.200
    32.699     1.784     0.200
    33.299     2.232     0.200
    34.432     2.225     0.200
    36.297     0.807     0.200
    36.986    -3.472     0.200
    41.108     1.741     0.200
    41.214     1.244     0.200
    41.820    -0.195     0.200
    42.106    -1.400     0.200
    42.081     1.146     0.200
    43.542    -1.154     0.200
    43.887    -0.758     0.200
    43.887     1.217     0.200
    44.911     0.699     0.200
    45.813    -3.738     0.200
    47.531     0.420     0.200
    47.941     0.335     0.200
    48.741     0.181     0.200
    49.599     0.480     0.200
    50.585    -2.167     0.200
    51.671    -0.193     0.200
    52.541    -2.280     0.200
    54.103    -2.850     0.200
    55.970    -1.438     0.200
    58.835    -4.625     0.200
    59.144    -1.872     0.200
    60.365    -1.976     0.200
    60.365    -1.398     0.200
    60.671    -1.652     0.200
    62.376    -2.359     0.200
    62.945    -1.049     0.200
    63.243    -3.232     0.200
    63.896    -2.225     0.200
    66.158    -2.905     0.200
    66.817    -1.945     0.200
    66.817    -2.460     0.200
    66.917     3.620     0.200
    69.032    -2.365     0.200
    70.155    -1.194     0.200
    71.065    -0.336     0.200
    71.168    -0.255     0.200
    71.199    -0.944     0.200
    71.378    -0.331     0.200
    71.445    -1.930     0.200
    71.599    -0.060     0.200
    72.011    -1.034     0.200
    72.365     0.152     0.200
    72.433    -0.244     0.200
    72.660    -1.961     0.200
    76.283     0.756     0.200
    76.976    -1.061     0.200
    77.466     0.195     0.200
    77.466    -0.188     0.200
    77.696    -0.995     0.200
    77.861     0.210     0.200
    82.311    -0.571     0.200
    84.087    -0.980     0.200
    20.311    -0.875     0.200
    20.320    -0.588     0.200
    20.559    -1.677     0.200
    20.559    -1.779     0.200
    23.428     0.883     0.200
    26.995     3.056     0.200
    28.422     2.903     0.200
    29.743     4.466     0.200
    29.976     3.334     0.200
    30.055     3.181     0.200
    30.149     4.282     0.200
    30.222     2.960     0.200
    30.857     4.177     0.200
    31.293     3.012     0.200
    31.562     2.075     0.200
    33.217     3.492     0.200
    33.641     3.180     0.200
    34.046     3.596     0.200
    34.271     0.231     0.200
    35.393     2.366     0.200
    37.312     2.057     0.200
    37.956     0.048     0.200
    39.434     2.711     0.200
    40.578    -0.176     0.200
    42.000     2.713     0.200
    42.139     2.095     0.200
    43.147    -1.279     0.200
    43.284    -1.976     0.200
    44.792    -0.572     0.200
    44.773     2.413     0.200
    45.660    -0.557     0.200
    48.296    -0.281     0.200
    48.296    -0.430     0.200
    48.296    -0.532     0.200
    48.296     0.081     0.200
    48.407     0.283     0.200
    53.235    -2.227     0.200
    53.460    -1.732     0.200
    55.835    -0.300     0.200
    58.892    -2.756     0.200
    59.162    -1.131     0.200
    60.028    -2.289     0.200
    60.914    -2.245     0.200
    61.447    -1.442     0.200
    61.447    -1.419     0.200
    61.587    -1.513     0.200
    62.693    -1.438     0.200
    62.693    -1.610     0.200
    63.482    -2.428     0.200
    63.568    -2.519     0.200
    63.568    -2.308     0.200
    63.873    -1.867     0.200
    63.873    -1.617     0.200
    64.127    -2.386     0.200
    64.576    -1.323     0.200
    65.414    -1.075     0.200
    65.491    -0.572     0.200
    65.812     0.260     0.200
    66.109    -1.524     0.200
    66.109    -1.649     0.200
    66.280    -0.444     0.200
    66.730    -0.421     0.200
    66.897    -2.184     0.200
    67.595    -1.309     0.200
    67.589    -1.771     0.200
    67.589    -2.271     0.200
    68.411    -0.228     0.200
    69.021    -1.231     0.200
    69.990    -1.073     0.200
    70.489    -0.061     0.200
    70.558    -0.586     0.200
    70.760    -1.915     0.200
    71.068    -0.282     0.200
    71.246    -1.264     0.200
    71.537    -1.019     0.200
    71.577    -1.157     0.200
    71.750    -0.621     0.200
    71.788    -0.631     0.200
    71.752     0.040     0.200
    71.788     0.023     0.200
    71.893    -0.263     0.200
    71.936    -0.521     0.200
    71.936    -0.412     0.200
    72.014     0.308     0.200
    71.951    -0.243     0.200
    72.093    -0.959     0.200
    72.129    -0.275     0.200
    72.129    -0.072     0.200
    72.138    -0.628     0.200
    72.224    -0.541     0.200
    72.149    -0.046     0.200
    72.254    -0.718     0.200
    72.268    -0.507     0.200
    72.197     0.128     0.200
    72.316    -1.090     0.200
    72.317    -1.220     0.200
    72.429    -0.366     0.200
    72.358    -0.076     0.200
    72.358    -1.475     0.200
    72.358    -1.248     0.200
    72.541    -0.029     0.200
    72.541    -0.130     0.200
    72.562    -0.125     0.200
    72.649     1.620     0.200
    72.674    -0.523     0.200
    72.697    -0.162     0.200
    72.697    -0.162     0.200
    72.622     0.377     0.200
    72.743    -0.038     0.200
    72.723     0.311     0.200
    72.879    -0.343     0.200
    72.791     0.177     0.200
    73.039    -0.884     0.200
    73.046    -0.030     0.200
    73.069    -1.258     0.200
    73.068     0.215     0.200
    73.176    -0.499     0.200
    73.385    -0.030     0.200
    73.399    -0.508     0.200
    73.429    -0.988     0.200
    73.455    -0.437     0.200
    73.455    -0.242     0.200
    73.470    -0.229     0.200
    73.544    -0.771     0.200
    73.553    -0.014     0.200
    73.568    -0.102     0.200
    73.579     0.232     0.200
    73.696    -0.255     0.200
    73.724    -1.120     0.200
    73.741     0.176     0.200
    73.747    -0.462     0.200
    73.748    -0.467     0.200
    73.748    -0.302     0.200
    73.831    -0.951     0.200
    74.023    -0.168     0.200
    74.041    -0.373     0.200
    74.069    -0.641     0.200
    74.079    -0.802     0.200
    74.079    -0.301     0.200
    74.090    -0.161     0.200
    74.088    -0.354     0.200
    74.099    -0.715     0.200
    74.158    -0.557     0.200
    74.215    -0.388     0.200
    74.220    -0.620     0.200
    74.243    -0.757     0.200
    74.323     0.082     0.200
    74.371    -1.001     0.200
    74.412    -0.539     0.200
    74.488    -0.377     0.200
    74.580    -0.113     0.200
    74.613    -0.807     0.200
    74.765    -0.789     0.200
    74.827    -0.940     0.200
    74.931    -0.849     0.200
    74.946     0.066     0.200
    75.065    -0.198     0.200
    75.142     0.070     0.200
    75.144    -0.218     0.200
    75.168    -0.307     0.200
    75.302     0.322     0.200
    75.467     0.180     0.200
    75.475     0.249     0.200
    75.779    -0.813     0.200
    75.799     0.671     0.200
    76.006    -0.514     0.200
    76.030    -1.447     0.200
    76.047     0.956     0.200
    76.050    -0.381     0.200
    76.135    -0.246     0.200
    76.227    -0.166     0.200
    76.236    -0.617     0.200
    76.327     0.469     0.200
    76.348    -0.751     0.200
    76.348     0.648     0.200
    76.352    -1.421     0.200
    76.697    -0.525     0.200
    76.777     0.192     0.200
    76.803    -0.427     0.200
    76.892    -1.302     0.200
    76.976    -1.002     0.200
    77.108     0.356     0.200
    77.186    -0.955     0.200
    77.191     0.345     0.200
    77.342    -0.055     0.200
    77.415     1.342     0.200
    77.415     0.303     0.200
    77.570    -0.955     0.200
    77.687     0.324     0.200
    77.761     0.108     0.200
    77.792    -1.160     0.200
    77.805    -1.234     0.200
    77.863    -1.758     0.200
    78.106    -1.145     0.200
    78.106    -0.606     0.200
    78.239    -1.844     0.200
    78.295     1.552     0.200
    78.339     0.202     0.200
    78.405     1.137     0.200
    78.444    -0.374     0.200
    78.491     0.664     0.200
    78.508     0.875     0.200
    78.578    -0.956     0.200
    78.722     0.198     0.200
    79.108    -2.123     0.200
    79.154    -0.276     0.200
    79.236    -0.028     0.200
    79.529    -0.522     0.200
    79.670    -0.786     0.200
    80.207     0.347     0.200
    80.500    -0.167     0.200
    81.023    -0.362     0.200
    81.240     0.286     0.200
    81.592     0.632     0.200
    81.592     0.523     0.200
    81.597    -0.006     0.200
    81.679    -0.138     0.200
    81.735    -0.133     0.200
    81.829     0.069     0.200
    82.312    -0.161     0.200
    83.004    -0.252     0.200
    83.101    -0.703     0.200
    83.101    -0.259     0.200
    91.324    -0.702     0.200
    91.503    -0.860     0.200
    91.882    -1.029     0.200
    92.143    -0.604     0.200
    96.981    -0.359     0.200
    20.283    -0.156     0.200
    20.813    -0.147     0.200
    23.955     0.859     0.200
    24.470     1.142     0.200
    28.912     1.697     0.200
    30.447     2.130     0.200
    30.590     2.497     0.200
    32.063     1.115     0.200
    32.063     1.713     0.200
    32.122     1.921     0.200
    32.767     2.256     0.200
    33.086    -1.886     0.200
    34.798     0.449     0.200
    36.290    -1.914     0.200
    37.806     2.110     0.200
    40.081    -0.775     0.200
    43.666     0.458     0.200
    45.244     1.481     0.200
    53.558    -1.955     0.200
    55.476    -0.529     0.200
    58.934    -1.167     0.200
    60.098    -2.027     0.200
    61.008    -1.625     0.200
    61.614    -1.015     0.200
    61.614    -0.691     0.200
    61.681    -1.818     0.200
    63.324    -2.906     0.200
    63.484    -1.975     0.200
    63.660    -1.233     0.200
    63.970    -1.286     0.200
    65.859    -1.613     0.200
    69.264    -1.949     0.200
    72.134    -1.632     0.200
    72.392    -2.027     0.200
    72.392    -1.578     0.200
    73.624     0.442     0.200
    73.917    -0.636     0.200
    78.087    -0.089     0.200
    80.897    -0.247     0.200
    80.982     0.297     0.200
    81.343    -0.416     0.200
    81.394    -0.284     0.200
    81.490    -0.391     0.200
    81.982    -0.480     0.200
    83.141     0.245     0.200
    18.493    -0.311     0.200
    19.860     1.661     0.200
    20.033     2.215     0.200
    20.086     2.162     0.200
    20.216     1.787     0.200
    20.259     2.354     0.200
    20.453     2.252     0.200
    20.860    -0.921     0.200
    20.860    -1.101     0.200
    20.961     1.876     0.200
    20.979     2.190     0.200
    21.083     1.865     0.200
    21.253     3.041     0.200
    21.409     1.626     0.200
    21.413     1.640     0.200
    21.425     1.729     0.200
    21.429     1.485     0.200
    21.493     1.124     0.200
    21.530     1.418     0.200
    21.561     1.712     0.200
    21.809     1.587     0.200
    21.826     0.186     0.200
    21.952     1.353     0.200
    21.997     2.146     0.200
    22.027     2.173     0.200
    22.035     1.619     0.200
    22.285     2.237     0.200
    22.360     1.485     0.200
    22.377     0.984     0.200
    22.492     1.471     0.200
    22.552     1.793     0.200
    22.588     2.032     0.200
    22.605     1.314     0.200
    22.627     1.762     0.200
    22.636     0.838     0.200
    22.801     1.932     0.200
    22.806     2.219     0.200
    22.894     2.350     0.200
    22.903     1.830     0.200
    22.909     1.558     0.200
    22.919     2.759     0.200
    22.930     2.640     0.200
    22.973     1.677     0.200
    23.041     2.514     0.200
    23.111     2.176     0.200
    23.253     1.576     0.200
    23.357     1.111     0.200
    23.398     1.472     0.200
    23.412     2.123     0.200
    23.428     1.093     0.200
    23.623     1.300     0.200
    23.674     1.213     0.200
    23.692     1.015     0.200
    23.768     1.613     0.200
    23.768     2.484     0.200
    23.807     2.949     0.200
    23.820     1.343     0.200
    23.834     1.085     0.200
    23.828     1.634     0.200
    23.894     1.648     0.200
    24.054     2.437     0.200
    24.116     1.442     0.200
    24.291     1.590     0.200
    24.295     1.403     0.200
    24.320     1.694     0.200
    24.323     1.574     0.200
    24.346     1.215     0.200
    24.388     1.889     0.200
    24.475     1.805     0.200
    24.570     1.930     0.200
    24.569     2.531     0.200
    24.569     1.867     0.200
    24.598     2.170     0.200
    24.599     1.470     0.200
    24.613     1.853     0.200
    24.634     1.207     0.200
    24.642     1.567     0.200
    24.694     1.485     0.200
    24.691     1.465     0.200
    24.758     0.945     0.200
    24.774     1.951     0.200
    24.880     2.506     0.200
    24.893     2.177     0.200
    24.914     2.152     0.200
    24.930     2.344     0.200
    24.972     1.419     0.200
    24.970     1.903     0.200
    25.028     2.521     0.200
    25.090     1.042     0.200
    25.193     1.882     0.200
    25.200     0.785     0.200
    25.241     1.451     0.200
    25.244     1.623     0.200
    25.261     1.871     0.200
    25.285     1.190     0.200
    25.297     1.442     0.200
    25.333     1.764     0.200
    25.358     1.907     0.200
    25.457     2.036     0.200
    25.502     0.136     0.200
    25.555     1.817     0.200
    25.566     1.403     0.200
    25.566     2.012     0.200
    25.586     1.341     0.200
    25.584     2.340     0.200
    25.692     1.436     0.200
    25.695     2.001     0.200
    25.704     2.047     0.200
    25.719     2.153     0.200
    25.781     2.396     0.200
    25.799     2.158     0.200
    25.795     2.642     0.200
    25.924     2.294     0.200
    25.946     3.860     0.200
    26.017     2.454     0.200
    26.140     2.283     0.200
    26.172     2.419     0.200
    26.190     1.643     0.200
    26.220     2.060     0.200
    26.239     2.654     0.200
    26.272     2.273     0.200
    26.281     1.823     0.200
    26.341     2.016     0.200
    26.436     2.109     0.200
    26.490     2.088     0.200
    26.552     1.868     0.200
    26.577     1.440     0.200
    26.606     1.412     0.200
    26.602     1.594     0.200
    26.677     1.647     0.200
    26.676     1.829     0.200
    26.864     2.131     0.200
    27.137    -1.984     0.200
    26.972     1.604     0.200
    26.994     1.177     0.200
    26.997     1.846     0.200
    27.058     1.464     0.200
    27.066     1.162     0.200
    27.088     1.337     0.200
    27.106     1.850     0.200
    27.132     1.484     0.200
    27.271     1.493     0.200
    27.289     1.773     0.200
    27.364     1.773     0.200
    27.377     1.277     0.200
    27.434     1.180     0.200
    27.455     2.040     0.200
    27.470     1.375     0.200
    27.558     1.607     0.200
    27.588     1.692     0.200
    27.634     1.835     0.200
    27.657     1.626     0.200
    27.711    -0.222     0.200
    27.737     2.491     0.200
    27.828     2.546     0.200
    27.832     2.181     0.200
    28.063    -1.573     0.200
    28.009     1.747     0.200
    28.110     1.833     0.200
    28.195     0.613     0.200
    28.201     2.276     0.200
    28.513    -1.970     0.200
    28.513    -1.830     0.200
    28.329     2.538     0.200
    28.382     1.911     0.200
    28.536     1.934     0.200
    28.619     2.262     0.200
    28.632     1.866     0.200
    28.885     3.540     0.200
    28.885     1.216     0.200
    28.891     1.802     0.200
    28.948     2.788     0.200
    28.949     1.911     0.200
    28.974     1.168     0.200
    29.117     1.835     0.200
    29.152     1.490     0.200
    29.236     1.625     0.200
    29.251     1.504     0.200
    29.364     1.208     0.200
    29.492     1.707     0.200
    29.671     1.395     0.200
    29.732     1.193     0.200
    29.757     1.536     0.200
    29.964     1.701     0.200
    30.051     2.237     0.200
    30.072     2.173     0.200
    30.156     1.907     0.200
    30.256     1.453     0.200
    30.256     1.365     0.200
    30.255     1.568     0.200
    30.289     2.056     0.200
    30.307     1.590     0.200
    30.335     1.028     0.200
    30.401     1.360     0.200
    30.443     1.066     0.200
    30.475     1.324     0.200
    30.582     1.540     0.200
    30.861     0.711     0.200
    30.934     0.422     0.200
    31.066     0.559     0.200
    31.199     0.736     0.200
    31.390     1.961     0.200
    31.390     1.328     0.200
    31.426     1.642     0.200
    31.483     2.447     0.200
    31.498     1.016     0.200
    31.545     1.497     0.200
    31.812     0.880     0.200
    32.019     1.506     0.200
    32.109     2.437     0.200
    32.233     1.824     0.200
    32.242     1.275     0.200
    32.284     1.247     0.200
    32.470     1.661     0.200
    32.482     1.072     0.200
    32.482     1.720     0.200
    32.577     1.061     0.200
    32.577    -0.701     0.200
    32.672     0.723     0.200
    32.777     1.587     0.200
    32.807     1.190     0.200
    32.900     1.394     0.200
    32.909     1.045     0.200
    32.982     1.400     0.200
    33.039     1.924     0.200
    33.088     2.098     0.200
    33.297    -2.151     0.200
    33.297    -2.433     0.200
    33.223     1.377     0.200
    33.274     1.622     0.200
    33.341     1.406     0.200
    33.346     1.898     0.200
    33.355     1.668     0.200
    33.435     1.334     0.200
    33.448     1.501     0.200
    33.472     1.173     0.200
    33.695     1.843     0.200
    33.767    -1.060     0.200
    33.830     0.907     0.200
    33.931     1.482     0.200
    33.941     2.372     0.200
    34.005     1.406     0.200
    34.047     1.715     0.200
    34.192     1.328     0.200
    34.200     1.627     0.200
    34.215     1.631     0.200
    34.239     1.723     0.200
    34.293     2.002     0.200
    34.321     0.658     0.200
    34.444     1.163     0.200
    34.468     0.848     0.200
    34.487     1.199     0.200
    34.537     1.175     0.200
    34.670     1.630     0.200
    34.711     1.487     0.200
    34.816     1.319     0.200
    34.869     1.833     0.200
    34.869     2.017     0.200
    34.905     2.367     0.200
    34.950     1.206     0.200
    34.984     2.261     0.200
    34.990     1.762     0.200
    35.087     1.673     0.200
    35.286     1.870     0.200
    35.371     1.836     0.200
    35.723     1.730     0.200
    35.983     2.003     0.200
    36.055     1.899     0.200
    36.143     1.245     0.200
    36.264    -0.412     0.200
    36.598     1.362     0.200
    36.757     1.082     0.200
    36.922     2.085     0.200
    37.120    -2.369     0.200
    37.104     1.363     0.200
    37.155     2.193     0.200
    37.688     1.212     0.200
    37.699     1.168     0.200
    37.881     1.493     0.200
    38.099     1.225     0.200
    38.111     2.092     0.200
    38.190     1.037     0.200
    38.295     2.349     0.200
    38.392     1.015     0.200
    38.748     1.743     0.200
    38.860     1.525     0.200
    39.251     1.638     0.200
    39.663     0.959     0.200
    39.893    -2.964     0.200
    39.893    -2.034     0.200
    40.220     0.976     0.200
    40.282     0.014     0.200
    41.587    -1.589     0.200
    41.897    -0.979     0.200
    41.828     0.986     0.200
    42.103    -3.859     0.200
    42.459    -0.520     0.200
    42.776    -2.527     0.200
    43.081    -0.905     0.200
    43.081    -1.206     0.200
    43.081    -0.803     0.200
    43.530    -0.865     0.200
    43.667     1.725     0.200
    43.747     0.024     0.200
    43.829    -0.777     0.200
    44.419     0.150     0.200
    44.673     1.112     0.200
    44.692    -1.139     0.200
    45.937    -2.513     0.200
    46.909     0.957     0.200
    47.131     0.226     0.200
    48.091    -1.829     0.200
    48.091    -0.727     0.200
    48.163    -1.686     0.200
    48.203    -0.008     0.200
    48.451     0.284     0.200
    49.004    -0.757     0.200
    49.702    -1.290     0.200
    49.702    -1.391     0.200
    49.702    -1.303     0.200
    50.228    -0.583     0.200
    50.799    -1.891     0.200
    52.407    -2.312     0.200
    52.408    -1.184     0.200
    53.186    -1.068     0.200
    53.832    -2.903     0.200
    53.990    -0.562     0.200
    54.364    -0.688     0.200
    54.350    -1.682     0.200
    54.514     0.025     0.200
    54.514    -0.745     0.200
    54.514    -0.964     0.200
    54.919    -1.115     0.200
    54.969    -1.568     0.200
    54.996    -1.065     0.200
    54.996    -1.066     0.200
    55.545    -0.524     0.200
    55.675    -1.364     0.200
    56.117    -0.442     0.200
    56.117    -0.625     0.200
    56.117    -0.926     0.200
    56.416    -0.380     0.200
    58.141    -1.438     0.200
    58.884    -3.417     0.200
    59.054    -2.093     0.200
    59.185    -1.755     0.200
    59.185    -1.482     0.200
    59.663    -0.703     0.200
    59.869    -1.221     0.200
    60.194    -1.449     0.200
    60.194    -0.875     0.200
    60.564    -1.682     0.200
    60.834    -0.619     0.200
    61.295    -1.114     0.200
    61.413    -0.347     0.200
    62.349    -1.438     0.200
    62.763    -1.503     0.200
    62.825    -0.613     0.200
    62.916    -0.458     0.200
    63.080    -2.110     0.200
    63.080    -1.911     0.200
    63.080    -2.391     0.200
    63.174     0.470     0.200
    63.310    -0.261     0.200
    63.449    -1.235     0.200
    63.536    -0.627     0.200
    63.851    -2.004     0.200
    63.851    -1.254     0.200
    63.903    -1.150     0.200
    63.903    -1.435     0.200
    63.903    -1.748     0.200
    63.909    -1.785     0.200
    63.909    -1.675     0.200
    63.849    -0.343     0.200
    63.854    -0.399     0.200
    63.959    -1.969     0.200
    64.045    -2.483     0.200
    66.037    -0.921     0.200
    66.040    -1.945     0.200
    66.228    -2.051     0.200
    66.228    -2.211     0.200
    66.228    -1.774     0.200
    66.295    -1.183     0.200
    66.401    -1.460     0.200
    66.640    -0.588     0.200
    66.716    -1.370     0.200
    66.716    -1.698     0.200
    66.801     0.689     0.200
    67.014    -0.071     0.200
    67.048    -1.184     0.200
    67.115    -0.215     0.200
    67.880    -2.128     0.200
    67.922    -1.159     0.200
    67.922    -1.409     0.200
    68.173    -1.249     0.200
    68.373     0.154     0.200
    68.424    -0.156     0.200
    68.637    -0.834     0.200
    68.927    -1.497     0.200
    68.927    -1.497     0.200
    68.890     0.035     0.200
    69.186     0.001     0.200
    69.212    -0.464     0.200
    69.702    -1.690     0.200
    69.697    -0.894     0.200
    69.946    -0.382     0.200
    69.981    -0.806     0.200
    69.981    -1.005     0.200
    70.139    -0.173     0.200
    70.153    -0.360     0.200
    70.160    -0.764     0.200
    70.187    -0.271     0.200
    70.396    -0.449     0.200
    70.460    -1.239     0.200
    70.497    -0.168     0.200
    70.497    -0.469     0.200
    70.499    -0.378     0.200
    70.510    -0.343     0.200
    70.556    -0.524     0.200
    70.625    -0.749     0.200
    70.721     0.210     0.200
    70.721    -0.427     0.200
    70.728    -0.271     0.200
    70.764    -0.595     0.200
    70.803    -1.079     0.200
    70.803    -0.329     0.200
    70.812    -0.283     0.200
    70.850    -0.416     0.200
    70.852    -0.728     0.200
    70.894     0.216     0.200
    70.930    -0.100     0.200
    70.918    -0.328     0.200
    70.932    -0.314     0.200
    70.991     0.230     0.200
    71.033     0.275     0.200
    71.201    -0.441     0.200
    71.213     0.486     0.200
    71.321    -0.992     0.200
    71.321    -1.469     0.200
    71.328    -1.408     0.200
    71.413    -1.225     0.200
    71.399    -0.138     0.200
    71.399    -0.138     0.200
    71.428     0.085     0.200
    71.427    -0.211     0.200
    71.568    -0.360     0.200
    71.785     0.037     0.200
    71.792    -0.866     0.200
    71.782    -0.147     0.200
    71.851     0.241     0.200
    71.871    -0.681     0.200
    71.964    -0.141     0.200
    72.074     0.104     0.200
    72.111    -0.020     0.200
    72.143    -1.211     0.200
    72.219    -0.350     0.200
    72.182    -0.045     0.200
    72.191     0.102     0.200
    72.196     0.072     0.200
    72.269    -0.561     0.200
    72.269    -0.065     0.200
    72.287    -0.116     0.200
    72.287     0.224     0.200
    72.370    -0.439     0.200
    72.359    -0.401     0.200
    72.394     0.489     0.200
    72.400    -0.649     0.200
    72.442     0.304     0.200
    72.453    -0.363     0.200
    72.486    -0.657     0.200
    72.486    -0.618     0.200
    72.558    -0.695     0.200
    72.708    -0.381     0.200
    72.769    -0.241     0.200
    72.803    -0.347     0.200
    72.912    -0.291     0.200
    72.965    -0.808     0.200
    72.968    -0.225     0.200
    72.968     1.775     0.200
    72.949    -0.307     0.200
    73.063    -2.189     0.200
    73.069     0.647     0.200
    73.121    -0.328     0.200
    73.188    -0.521     0.200
    73.233    -0.390     0.200
    73.249     0.417     0.200
    73.271    -0.316     0.200
    73.331    -0.472     0.200
    73.413     0.548     0.200
    73.407    -0.514     0.200
    73.487    -0.588     0.200
    73.524    -0.385     0.200
    73.584     0.012     0.200
    73.618    -0.144     0.200
    73.781     0.088     0.200
    73.841     0.138     0.200
    73.869     0.872     0.200
    73.869     0.673     0.200
    73.869     0.345     0.200
    73.979     0.157     0.200
    74.201     0.394     0.200
    74.229    -0.040     0.200
    74.347    -0.638     0.200
    74.321    -0.570     0.200
    74.355     0.212     0.200
    74.376    -0.290     0.200
    74.536    -0.115     0.200
    74.674    -0.578     0.200
    74.755    -0.096     0.200
    74.784    -0.454     0.200
    74.804    -0.311     0.200
    74.879    -0.299     0.200
    74.945     0.917     0.200
    74.966     1.096     0.200
    75.125    -0.225     0.200
    75.125    -0.093     0.200
    75.282    -0.025     0.200
    75.391     0.543     0.200
    75.405     0.064     0.200
    75.444    -1.011     0.200
    75.494     0.056     0.200
    75.605    -1.025     0.200
    75.723     0.942     0.200
    75.911     0.171     0.200
    75.939    -0.810     0.200
    75.925     0.186     0.200
    76.150    -0.593     0.200
    76.164    -0.971     0.200
    76.252    -0.572     0.200
    76.252     0.088     0.200
    76.263     0.369     0.200
    76.280     0.768     0.200
    76.307    -0.780     0.200
    76.348    -0.113     0.200
    76.514    -0.077     0.200
    76.514    -0.558     0.200
    76.514     0.802     0.200
    76.524    -0.011     0.200
    76.550     0.842     0.200
    76.523     0.693     0.200
    76.664    -0.106     0.200
    76.780    -1.162     0.200
    76.841    -0.801     0.200
    76.847    -0.040     0.200
    76.961    -3.077     0.200
    76.973     0.250     0.200
    77.049     0.325     0.200
    77.124     0.507     0.200
    77.336    -0.286     0.200
    77.336    -0.185     0.200
    77.392    -0.399     0.200
    77.392    -0.501     0.200
    77.569    -0.488     0.200
    77.569    -1.238     0.200
    77.670     0.451     0.200
    77.685     1.056     0.200
    78.006     0.778     0.200
    78.081     0.265     0.200
    78.170    -0.028     0.200
    78.459    -0.629     0.200
    78.649     0.587     0.200
    78.649     0.524     0.200
    78.685     0.523     0.200
    78.775    -0.370     0.200
    78.775     0.227     0.200
    79.356     0.550     0.200
    79.771     0.289     0.200
    79.918     0.798     0.200
    80.318    -0.361     0.200
    80.766    -0.363     0.200
    80.945    -0.221     0.200
    80.942     0.610     0.200
    80.942     0.794     0.200
    81.055    -1.004     0.200
    81.263     0.499     0.200
    81.459    -2.751     0.200
    81.449     0.041     0.200
    81.492    -0.026     0.200
    81.457    -1.190     0.200
    81.731     0.013     0.200
    81.830     0.389     0.200
    81.881    -0.005     0.200
    82.057    -0.301     0.200
    82.076    -0.101     0.200
    82.090    -0.076     0.200
    82.138    -0.228     0.200
    82.168     0.216     0.200
    82.220    -0.456     0.200
    82.220    -0.158     0.200
    82.205    -0.327     0.200
    82.297    -0.361     0.200
    82.306    -0.005     0.200
    82.347    -0.611     0.200
    82.670    -1.505     0.200
    82.750    -0.318     0.200
    83.619     0.122     0.200
    83.597    -0.497     0.200
    83.977    -1.840     0.200
    84.154     0.468     0.200
    84.284    -0.905     0.200
    84.364     0.394     0.200
    84.917     0.553     0.200
    86.114    -0.528     0.200
    90.792    -0.829     0.200
    91.140    -1.214     0.200
    91.351    -0.965     0.200
    91.622    -0.800     0.200
    93.073    -0.785     0.200
    93.551    -1.553     0.200
    93.581    -1.663     0.200
    94.056    -1.776     0.200
    98.788    -1.884     0.200
    19.351    -2.106     0.200
    19.447     2.192     0.200
    19.971     1.221     0.200
    19.994     0.623     0.200
    20.087     0.351     0.200
    20.269     0.495     0.200
    20.426     0.241     0.200
    20.537     2.165     0.200
    20.593     0.727     0.200
    20.617     1.925     0.200
    20.665     1.319     0.200
    20.899     1.351     0.200
    21.065     1.055     0.200
    21.106     1.074     0.200
    21.259     1.204     0.200
    21.372     1.334     0.200
    21.636    -1.583     0.200
    21.636    -1.743     0.200
    21.474     2.361     0.200
    21.562     0.965     0.200
    21.647     2.453     0.200
    21.668     0.804     0.200
    21.722     0.817     0.200
    21.754     1.896     0.200
    21.851     0.697     0.200
    21.862     0.829     0.200
    21.870     1.956     0.200
    21.904     1.882     0.200
    21.929     1.084     0.200
    22.050     1.177     0.200
    22.102     1.834     0.200
    22.114     1.287     0.200
    22.350     0.689     0.200
    22.474     2.264     0.200
    22.477     0.447     0.200
    22.492     1.072     0.200
    22.619     0.784     0.200
    22.648     1.295     0.200
    22.665     1.943     0.200
    22.682     1.913     0.200
    22.764     0.932     0.200
    22.765     1.101     0.200
    22.784     1.083     0.200
    22.787     2.554     0.200
    22.850     0.674     0.200
    22.883     0.329     0.200
    22.892     1.624     0.200
    22.925     0.326     0.200
    23.025     0.538     0.200
    23.055     0.807     0.200
    23.072     0.535     0.200
    23.121     0.541     0.200
    23.131     1.414     0.200
    23.165     1.182     0.200
    23.182     0.672     0.200
    23.284     0.799     0.200
    23.451     1.421     0.200
    23.571     1.488     0.200
    23.604     0.357     0.200
    23.616     2.555     0.200
    23.676     1.755     0.200
    23.709     1.469     0.200
    23.751     0.603     0.200
    23.863     0.734     0.200
    23.928     1.141     0.200
    23.935     0.716     0.200
    24.187     0.469     0.200
    24.235     1.211     0.200
    24.258     0.729     0.200
    24.272     0.222     0.200
    24.357     0.720     0.200
    24.439     0.586     0.200
    24.441     2.004     0.200
    24.441     2.762     0.200
    24.442     0.833     0.200
    24.467     1.345     0.200
    24.536     0.597     0.200
    24.579     1.081     0.200
    24.595     0.708     0.200
    24.652    -0.165     0.200
    24.655     1.430     0.200
    24.759     0.211     0.200
    24.785     0.842     0.200
    24.809     0.462     0.200
    24.872     0.836     0.200
    24.994     1.007     0.200
    25.039     0.951     0.200
    25.073     0.702     0.200
    25.077     0.893     0.200
    25.077     0.703     0.200
    25.111     1.654     0.200
    25.164     0.583     0.200
    25.277     0.704     0.200
    25.287     0.830     0.200
    25.323     0.946     0.200
    25.387     2.155     0.200
    25.457     1.070     0.200
    25.482     1.442     0.200
    25.547     1.748     0.200
    25.560     4.884     0.200
    25.625     1.566     0.200
    25.652     0.691     0.200
    25.720     0.387     0.200
    25.723     0.651     0.200
    25.809     0.694     0.200
    25.810     0.568     0.200
    25.816     0.691     0.200
    25.873     1.435     0.200
    25.886     1.188     0.200
    25.904     0.938     0.200
    25.908     1.184     0.200
    26.037     1.762     0.200
    26.049     0.952     0.200
    26.137     1.305     0.200
    26.215     1.055     0.200
    26.346     1.308     0.200
    26.366     0.183     0.200
    26.378     0.929     0.200
    26.457     1.427     0.200
    26.613     0.550     0.200
    26.629     1.173     0.200
    26.637     0.925     0.200
    26.652     1.047     0.200
    26.679     0.549     0.200
    26.734     1.427     0.200
    26.794     0.672     0.200
    26.861     1.407     0.200
    26.860     1.173     0.200
    26.921     0.915     0.200
    26.955     1.270     0.200
    26.956     1.169     0.200
    26.957     0.671     0.200
    26.982     1.297     0.200
    27.007     1.287     0.200
    27.020     1.445     0.200
    27.121     0.786     0.200
    27.117     1.164     0.200
    27.146     1.159     0.200
    27.187     1.669     0.200
    27.525    -2.443     0.200
    27.327     0.409     0.200
    27.679    -2.021     0.200
    27.342     0.532     0.200
    27.342     0.821     0.200
    27.357     0.887     0.200
    27.364     0.919     0.200
    27.407     1.283     0.200
    27.433     1.544     0.200
    27.454     1.535     0.200
    27.526     1.287     0.200
    27.526     1.674     0.200
    27.539     1.032     0.200
    27.556     1.163     0.200
    27.629     0.780     0.200
    27.635     2.437     0.200
    27.642     1.398     0.200
    27.751     1.561     0.200
    27.743     0.751     0.200
    27.743     1.204     0.200
    27.753     1.787     0.200
    27.765     1.904     0.200
    27.791     1.394     0.200
    27.788     1.670     0.200
    27.803     1.403     0.200
    27.807     1.531     0.200
    28.154    -2.543     0.200
    28.154    -2.325     0.200
    27.876     1.275     0.200
    27.886     1.659     0.200
    28.089     1.393     0.200
    28.102     1.265     0.200
    28.285    -0.180     0.200
    28.163     1.413     0.200
    28.213     1.710     0.200
    28.249     1.915     0.200
    28.283     1.414     0.200
    28.289     1.398     0.200
    28.319     1.657     0.200
    28.333     1.821     0.200
    28.379     1.175     0.200
    28.405     1.513     0.200
    28.410     1.357     0.200
    28.514     1.391     0.200
    28.520     2.390     0.200
    28.611     1.757     0.200
    28.692    -0.133     0.200
    28.693     1.795     0.200
    28.711     1.896     0.200
    28.716     1.668     0.200
    28.727     2.033     0.200
    28.778     1.530     0.200
    28.820     0.783     0.200
    28.881     1.525     0.200
    28.902     3.482     0.200
    28.916     2.011     0.200
    29.030     2.068     0.200
    29.057     1.004     0.200
    29.060     1.911     0.200
    29.060     2.477     0.200
    29.069     3.599     0.200
    29.081     2.504     0.200
    29.136     2.388     0.200
    29.150     1.761     0.200
    29.166     2.029     0.200
    29.166     1.186     0.200
    29.196     2.272     0.200
    29.203     2.521     0.200
    29.203     1.427     0.200
    29.243     1.761     0.200
    29.252     2.164     0.200
    29.342     1.749     0.200
    29.342     2.092     0.200
    29.354     1.748     0.200
    29.387     2.252     0.200
    29.463     2.387     0.200
    29.495     1.572     0.200
    29.502     2.277     0.200
    29.502     1.332     0.200
    29.506     2.022     0.200
    29.551     2.008     0.200
    29.573     1.552     0.200
    29.588     2.794     0.200
    29.601     1.802     0.200
    29.623     1.790     0.200
    29.624     1.547     0.200
    29.635     1.785     0.200
    29.677     1.507     0.200
    29.679     1.766     0.200
    29.827     1.675     0.200
    29.846     2.896     0.200
    29.947     2.117     0.200
    30.019     1.764     0.200
    30.049     2.022     0.200
    30.073     0.446     0.200
    30.081     1.357     0.200
    30.125     1.331     0.200
    30.127     1.911     0.200
    30.138     1.283     0.200
    30.165     0.341     0.200
    30.165     1.309     0.200
    30.157     1.372     0.200
    30.189     2.251     0.200
    30.199     1.792     0.200
    30.280     1.924     0.200
    30.380     1.516     0.200
    30.397     2.239     0.200
    30.407     1.679     0.200
    30.436     1.625     0.200
    30.486     1.911     0.200
    30.527     0.372     0.200
    30.564     1.754     0.200
    30.606     1.421     0.200
    30.610     1.651     0.200
    30.689     0.361     0.200
    30.705     1.363     0.200
    30.705     1.463     0.200
    30.716     1.516     0.200
    30.716     1.911     0.200
    30.726     1.066     0.200
    30.758     1.466     0.200
    30.778     1.211     0.200
    30.839     1.016     0.200
    30.967     0.630     0.200
    30.974     1.527     0.200
    30.977     1.368     0.200
    31.011     0.741     0.200
    31.014     1.392     0.200
    31.054     1.299     0.200
    31.057     0.605     0.200
    31.131     1.285     0.200
    31.160     2.334     0.200
    31.189     1.343     0.200
    31.220     1.080     0.200
    31.220     1.580     0.200
    31.255     0.621     0.200
    31.262     1.478     0.200
    31.283     2.190     0.200
    31.335     0.987     0.200
    31.342     1.766     0.200
    31.390     1.929     0.200
    31.396     1.692     0.200
    31.411     1.499     0.200
    31.446     0.843     0.200
    31.450     0.138     0.200
    31.473     0.090     0.200
    31.546     1.906     0.200
    31.575     0.406     0.200
    31.600     0.474     0.200
    31.633     1.789     0.200
    31.697     2.049     0.200
    31.756     1.692     0.200
    31.754    -0.366     0.200
    31.779     1.221     0.200
    31.811     0.512     0.200
    31.832     1.980     0.200
    31.884     1.085     0.200
    31.937     0.962     0.200
    32.081     1.644     0.200
    32.130     1.550     0.200
    32.182     0.963     0.200
    32.177     2.217     0.200
    32.189     1.341     0.200
    32.221     2.884     0.200
    32.227     2.182     0.200
    32.275     2.600     0.200
    32.287     1.156     0.200
    32.309     1.014     0.200
    32.319     1.575     0.200
    32.333     1.803     0.200
    32.333     1.389     0.200
    32.346     1.109     0.200
    32.364     2.121     0.200
    32.418     1.080     0.200
    32.446     1.316     0.200
    32.444     1.248     0.200
    32.481     1.891     0.200
    32.501     1.347     0.200
    32.515     2.104     0.200
    32.576     1.459     0.200
    32.602     1.901     0.200
    32.605     2.160     0.200
    32.634     1.705     0.200
    32.670     1.792     0.200
    32.691     1.434     0.200
    32.720     1.553     0.200
    32.723     2.095     0.200
    32.723     2.278     0.200
    32.730     2.188     0.200
    32.796     2.241     0.200
    32.812     2.603     0.200
    32.870     1.094     0.200
    32.878     1.755     0.200
    32.911     1.888     0.200
    32.942     1.299     0.200
    32.939     1.713     0.200
    32.987     2.024     0.200
    33.070     1.087     0.200
    33.125     1.594     0.200
    33.181     1.447     0.200
    33.187     1.306     0.200
    33.229     1.437     0.200
    33.252     1.169     0.200
    33.278     0.996     0.200
    33.309     1.279     0.200
    33.316     1.539     0.200
    33.316     1.874     0.200
    33.335     1.516     0.200
    33.352     1.333     0.200
    33.501     1.187     0.200
    33.587     1.457     0.200
    33.594     1.298     0.200
    33.597     1.312     0.200
    33.653     1.718     0.200
    33.719     1.379     0.200
    33.719     1.058     0.200
    33.742     1.407     0.200
    33.766     1.352     0.200
    33.770     1.048     0.200
    33.772     1.614     0.200
    33.853     1.178     0.200
    33.853     0.975     0.200
    33.855     1.645     0.200
    33.956     2.119     0.200
    33.970     2.009     0.200
    33.996     0.822     0.200
    34.038     1.306     0.200
    34.043     1.082     0.200
    34.354    -2.229     0.200
    34.354    -1.748     0.200
    34.071     1.533     0.200
    34.092     1.416     0.200
    34.447    -0.738     0.200
    34.293     1.872     0.200
    34.298     1.859     0.200
    34.317     1.414     0.200
    34.393     1.514     0.200
    34.453     1.677     0.200
    34.463     1.145     0.200
    34.462     1.314     0.200
    34.502     0.932     0.200
    34.500     1.339     0.200
    34.516     0.794     0.200
    34.518     1.203     0.200
    34.546     1.430     0.200
    34.598     1.594     0.200
    34.707     1.648     0.200
    34.716     1.221     0.200
    34.742     1.860     0.200
    34.829     1.225     0.200
    34.857     1.780     0.200
    34.864     1.539     0.200
    34.901     1.840     0.200
    34.947     1.602     0.200
    34.947     2.012     0.200
    34.971     1.876     0.200
    35.007     1.516     0.200
    35.056     1.203     0.200
    35.113     1.657     0.200
    35.171     2.088     0.200
    35.189     2.228     0.200
    35.199     1.557     0.200
    35.199     0.982     0.200
    35.248     2.166     0.200
    35.294     1.866     0.200
    35.329     1.505     0.200
    35.503     1.198     0.200
    35.557     1.333     0.200
    35.582     1.521     0.200
    35.629     1.471     0.200
    35.661     1.872     0.200
    35.760     2.355     0.200
    35.807     1.683     0.200
    35.813     1.638     0.200
    35.871     1.276     0.200
    36.025     1.448     0.200
    36.081     1.524     0.200
    36.113     1.210     0.200
    36.153     0.856     0.200
    36.159     2.236     0.200
    36.203     1.907     0.200
    36.269     1.688     0.200
    36.301     1.705     0.200
    36.331     1.518     0.200
    36.429     2.126     0.200
    36.452     1.716     0.200
    36.608     1.745     0.200
    36.632     1.983     0.200
    36.704     1.759     0.200
    36.707     1.925     0.200
    36.761     1.695     0.200
    36.877     1.835     0.200
    36.989     2.222     0.200
    37.003     1.777     0.200
    37.081     1.508     0.200
    37.136     1.734     0.200
    37.207     1.825     0.200
    37.226     0.500     0.200
    37.221     1.436     0.200
    37.258     2.459     0.200
    37.698    -2.661     0.200
    37.399     0.852     0.200
    37.529     1.732     0.200
    37.569     1.746     0.200
    37.658     2.067     0.200
    37.672     2.049     0.200
    37.753     1.481     0.200
    37.758     2.203     0.200
    37.769     2.097     0.200
    37.913     1.988     0.200
    37.987     0.150     0.200
    37.990     2.040     0.200
    38.036     1.969     0.200
    38.052     2.195     0.200
    38.160     2.227     0.200
    38.162     2.381     0.200
    38.261     1.969     0.200
    38.304     1.976     0.200
    38.375     2.162     0.200
    38.399     1.874     0.200
    38.408     1.552     0.200
    38.484     2.063     0.200
    38.500     1.389     0.200
    38.594     2.203     0.200
    38.682     1.851     0.200
    38.786     1.993     0.200
    38.830     1.514     0.200
    38.853     1.757     0.200
    38.858     1.896     0.200
    38.973     2.303     0.200
    39.009     1.947     0.200
    39.137     2.094     0.200
    39.559    -2.179     0.200
    39.242     1.863     0.200
    39.269     2.002     0.200
    39.269     2.031     0.200
    39.309     2.173     0.200
    39.420     2.580     0.200
    39.550     2.349     0.200
    39.689     1.996     0.200
    39.711     1.774     0.200
    39.710     1.794     0.200
    39.831     1.969     0.200
    40.025     1.641     0.200
    40.178     1.661     0.200
    40.188     1.803     0.200
    40.240     1.696     0.200
    40.263     1.468     0.200
    40.309    -1.131     0.200
    40.359    -0.523     0.200
    40.565     1.532     0.200
    40.590     1.550     0.200
    40.618     1.192     0.200
    40.688     1.583     0.200
    40.698     1.691     0.200
    40.711     1.152     0.200
    40.835    -0.261     0.200
    40.970     0.918     0.200
    41.034     1.577     0.200
    41.048     1.437     0.200
    41.057     1.685     0.200
    41.457    -1.623     0.200
    41.203     1.349     0.200
    41.209     1.825     0.200
    41.267     0.284     0.200
    41.419     1.900     0.200
    41.456     1.448     0.200
    41.530     1.348     0.200
    41.928     1.444     0.200
    41.981     1.857     0.200
    42.101     1.462     0.200
    42.526    -4.403     0.200
    42.551    -1.912     0.200
    42.314     1.221     0.200
    42.674    -3.110     0.200
    42.581     1.604     0.200
    42.675     1.081     0.200
    42.773     1.592     0.200
    43.027     1.868     0.200
    43.214     1.240     0.200
    43.253     1.591     0.200
    43.392     0.174     0.200
    43.405     1.632     0.200
    43.550     0.072     0.200
    43.849    -0.801     0.200
    43.826     1.764     0.200
    43.879     1.379     0.200
    44.012     0.328     0.200
    44.012    -0.707     0.200
    44.068    -0.559     0.200
    44.118     1.377     0.200
    44.479     0.255     0.200
    44.479    -0.905     0.200
    44.572    -0.694     0.200
    44.996     0.630     0.200
    45.373    -0.949     0.200
    45.375    -1.109     0.200
    45.325     0.400     0.200
    45.327     0.703     0.200
    45.498    -0.281     0.200
    45.498    -0.117     0.200
    45.894    -0.313     0.200
    46.111     0.447     0.200
    46.572    -2.416     0.200
    46.820    -0.111     0.200
    47.073     0.365     0.200
    47.345     0.145     0.200
    47.372     1.292     0.200
    47.566     1.825     0.200
    47.659     0.403     0.200
    48.048    -2.610     0.200
    48.541    -0.610     0.200
    49.126    -1.091     0.200
    49.126    -2.007     0.200
    49.126    -1.508     0.200
    49.063    -0.150     0.200
    49.126    -0.261     0.200
    49.180    -0.010     0.200
    49.443    -0.102     0.200
    49.762    -2.060     0.200
    49.538    -0.063     0.200
    50.095    -0.270     0.200
    50.686    -0.365     0.200
    50.753    -2.268     0.200
    50.439     0.158     0.200
    51.766    -0.564     0.200
    52.332     0.022     0.200
    53.534    -1.846     0.200
    54.076    -1.316     0.200
    54.005    -1.592     0.200
    54.221    -1.296     0.200
    55.151    -0.912     0.200
    55.151    -2.013     0.200
    55.151    -0.482     0.200
    56.287    -1.268     0.200
    56.589    -1.021     0.200
    56.589    -0.486     0.200
    56.901    -0.376     0.200
    58.229    -1.783     0.200
    59.860    -0.296     0.200
    59.952    -1.723     0.200
    60.210    -1.279     0.200
    60.210    -0.717     0.200
    60.828    -1.414     0.200
    61.680    -1.687     0.200
    61.826    -1.565     0.200
    62.095    -0.577     0.200
    62.095    -0.678     0.200
    62.261    -0.886     0.200
    62.351    -0.964     0.200
    62.535    -1.518     0.200
    62.980    -1.484     0.200
    63.324    -0.872     0.200
    63.785    -0.914     0.200
    64.541    -1.471     0.200
    64.541    -1.623     0.200
    64.932    -0.497     0.200
    65.041    -1.206     0.200
    65.157    -1.286     0.200
    65.157    -1.395     0.200
    65.157    -1.012     0.200
    65.160    -1.222     0.200
    65.004     1.674     0.200
    65.345    -0.804     0.200
    65.813    -0.028     0.200
    65.813    -0.560     0.200
    66.476    -1.085     0.200
    66.430    -0.094     0.200
    67.180    -1.372     0.200
    67.180    -1.220     0.200
    67.322    -0.670     0.200
    67.499    -0.192     0.200
    67.807    -0.135     0.200
    67.749    -2.269     0.200
    68.063    -0.194     0.200
    68.241    -0.173     0.200
    68.392    -1.388     0.200
    68.262    -0.396     0.200
    68.262    -0.497     0.200
    68.434    -0.770     0.200
    68.434    -1.571     0.200
    68.463    -0.370     0.200
    68.500    -0.604     0.200
    68.523     0.470     0.200
    68.702     0.558     0.200
    68.912    -3.955     0.200
    69.032     0.302     0.200
    69.724     1.391     0.200
    69.760    -0.987     0.200
    69.760    -1.460     0.200
    69.793    -0.310     0.200
    70.253    -0.064     0.200
    70.350    -1.121     0.200
    70.350    -1.121     0.200
    70.353     0.260     0.200
    70.433    -0.026     0.200
    70.571     0.044     0.200
    70.791     0.188     0.200
    70.791    -0.261     0.200
    71.086    -1.197     0.200
    71.105     0.483     0.200
    71.145    -0.160     0.200
    71.287    -0.121     0.200
    71.385    -0.288     0.200
    71.584    -1.209     0.200
    71.570    -0.168     0.200
    71.636    -0.319     0.200
    71.656     0.023     0.200
    71.798    -0.287     0.200
    71.888    -0.437     0.200
    71.887    -0.284     0.200
    72.075    -0.361     0.200
    72.142    -1.363     0.200
    72.084     0.187     0.200
    72.104    -0.081     0.200
    72.130     0.010     0.200
    72.381    -1.591     0.200
    72.347     0.113     0.200
    72.400    -0.100     0.200
    72.414    -0.088     0.200
    72.486     0.087     0.200
    72.471     0.075     0.200
    72.609     0.020     0.200
    72.609    -0.148     0.200
    72.583    -0.394     0.200
    72.676    -0.045     0.200
    72.816     0.082     0.200
    72.816    -0.379     0.200
    72.688    -0.021     0.200
    72.723     0.074     0.200
    72.850    -0.271     0.200
    72.742     0.440     0.200
    72.742     0.159     0.200
    72.742    -0.138     0.200
    72.761    -0.253     0.200
    72.809    -0.440     0.200
    72.841     0.173     0.200
    73.014    -0.061     0.200
    72.876    -0.034     0.200
    72.893     0.061     0.200
    73.108    -1.408     0.200
    73.108    -1.908     0.200
    73.205     0.016     0.200
    73.216     0.103     0.200
    73.261     0.220     0.200
    73.421    -0.126     0.200
    73.421     0.034     0.200
    73.421    -0.286     0.200
    73.421     0.315     0.200
    73.317     0.160     0.200
    73.317     0.160     0.200
    73.340     0.321     0.200
    73.434    -0.331     0.200
    73.623     0.108     0.200
    73.623    -0.103     0.200
    73.687     0.470     0.200
    73.786    -1.798     0.200
    73.628     0.128     0.200
    73.786     0.351     0.200
    73.786     0.050     0.200
    73.726     0.149     0.200
    73.753    -0.755     0.200
    73.753    -0.005     0.200
    73.976    -1.712     0.200
    74.002     0.034     0.200
    74.002    -0.267     0.200
    74.130     0.709     0.200
    74.130     0.248     0.200
    74.021     0.327     0.200
    74.097    -0.049     0.200
    74.132    -0.051     0.200
    74.132    -0.243     0.200
    74.119     0.051     0.200
    74.127     0.204     0.200
    74.157     0.228     0.200
    74.257     0.046     0.200
    74.297     0.712     0.200
    74.296    -0.182     0.200
    74.296    -0.381     0.200
    74.333     0.006     0.200
    74.391    -0.136     0.200
    74.391     0.001     0.200
    74.394    -0.149     0.200
    74.567     0.646     0.200
    74.647    -0.223     0.200
    74.650    -0.240     0.200
    74.738    -0.349     0.200
    74.727     0.013     0.200
    74.752    -0.031     0.200
    74.816     0.097     0.200
    74.831     0.013     0.200
    74.899    -0.078     0.200
    74.998     0.446     0.200
    75.107     0.119     0.200
    75.119    -1.753     0.200
    75.101    -0.044     0.200
    75.138    -0.262     0.200
    75.199     0.090     0.200
    75.299     0.615     0.200
    75.284    -0.200     0.200
    75.357    -0.318     0.200
    75.407    -0.004     0.200
    75.428    -0.272     0.200
    75.446    -0.099     0.200
    75.441    -0.202     0.200
    75.478     0.193     0.200
    75.545     0.029     0.200
    75.624     0.138     0.200
    75.683     0.160     0.200
    75.736    -0.490     0.200
    75.736     0.311     0.200
    75.723     0.279     0.200
    75.760     0.468     0.200
    75.903     0.351     0.200
    75.980     1.516     0.200
    76.010     0.046     0.200
    76.111     0.598     0.200
    76.095     1.158     0.200
    76.126     0.159     0.200
    76.171    -0.543     0.200
    76.200    -0.441     0.200
    76.277    -0.276     0.200
    76.359    -0.364     0.200
    76.325     1.495     0.200
    76.406     0.331     0.200
    76.432     0.146     0.200
    76.494     0.098     0.200
    76.583    -0.439     0.200
    76.656    -0.142     0.200
    76.638     1.280     0.200
    76.704    -0.136     0.200
    76.866     1.193     0.200
    76.739    -0.089     0.200
    76.783    -0.017     0.200
    76.819    -3.841     0.200
    76.797     0.081     0.200
    76.797    -0.618     0.200
    76.886     0.978     0.200
    76.909    -0.349     0.200
    76.873     0.394     0.200
    76.907     1.263     0.200
    76.971     0.104     0.200
    76.971     0.002     0.200
    77.200    -0.648     0.200
    77.231     0.144     0.200
    77.334     0.765     0.200
    77.352    -1.136     0.200
    77.371    -0.048     0.200
    77.371    -0.548     0.200
    77.323     0.266     0.200
    77.351     0.272     0.200
    77.537    -0.884     0.200
    77.666     1.109     0.200
    77.726     1.176     0.200
    77.840    -0.619     0.200
    77.816     1.762     0.200
    77.863     0.412     0.200
    77.887     0.678     0.200
    77.961    -0.233     0.200
    77.961    -0.534     0.200
    77.976     0.785     0.200
    77.945     0.755     0.200
    78.108    -0.249     0.200
    78.228     0.888     0.200
    78.223     0.611     0.200
    78.212     1.172     0.200
    78.266    -0.627     0.200
    78.332     0.207     0.200
    78.304     0.064     0.200
    78.479     0.496     0.200
    78.479     0.293     0.200
    78.370    -0.131     0.200
    78.370    -0.002     0.200
    78.376    -0.036     0.200
    78.376     0.163     0.200
    78.334     0.997     0.200
    78.349     0.716     0.200
    78.432     0.458     0.200
    78.474    -0.077     0.200
    78.476    -1.188     0.200
    78.482     1.081     0.200
    78.483     0.872     0.200
    78.394     0.744     0.200
    78.564    -0.573     0.200
    78.562     0.066     0.200
    78.631     0.258     0.200
    78.652    -3.661     0.200
    78.646    -0.421     0.200
    78.605     0.001     0.200
    78.705     0.149     0.200
    78.650     0.652     0.200
    78.689    -0.318     0.200
    78.698     0.889     0.200
    78.791    -0.022     0.200
    79.012    -0.137     0.200
    79.012    -0.586     0.200
    79.012     0.277     0.200
    78.994     0.265     0.200
    79.135    -0.311     0.200
    79.083     0.878     0.200
    79.083     0.058     0.200
    79.363    -0.455     0.200
    79.363    -1.006     0.200
    79.363    -0.557     0.200
    79.376     0.624     0.200
    79.676    -0.761     0.200
    79.628     0.401     0.200
    80.025    -0.349     0.200
    80.027    -1.022     0.200
    80.106     0.015     0.200
    80.273    -0.356     0.200
    80.494    -3.928     0.200
    80.611     0.597     0.200
    80.611    -0.525     0.200
    80.685    -0.772     0.200
    80.791    -1.057     0.200
    80.798    -0.505     0.200
    80.770     0.118     0.200
    80.963     0.016     0.200
    80.993    -0.043     0.200
    81.314     0.447     0.200
    81.275     0.395     0.200
    81.576     0.660     0.200
    81.739    -0.558     0.200
    81.791     0.449     0.200
    81.810    -0.522     0.200
    82.017    -0.058     0.200
    81.874     0.589     0.200
    81.911     0.805     0.200
    81.971     1.378     0.200
    82.045    -1.007     0.200
    82.095     1.327     0.200
    82.312     0.094     0.200
    82.277    -0.326     0.200
    82.399     0.235     0.200
    82.333    -1.425     0.200
    82.520    -0.597     0.200
    82.430    -0.448     0.200
    82.533    -1.864     0.200
    82.582    -0.315     0.200
    82.520     0.106     0.200
    82.520    -0.734     0.200
    82.520     1.657     0.200
    82.670    -0.276     0.200
    82.569    -1.122     0.200
    82.808    -0.292     0.200
    82.844    -0.379     0.200
    82.902    -0.082     0.200
    82.845     1.317     0.200
    82.983     1.601     0.200
    82.993     1.144     0.200
    83.395    -0.588     0.200
    83.938    -0.848     0.200
    83.938    -0.260     0.200
    84.053    -2.498     0.200
    84.354    -1.439     0.200
    84.354    -1.127     0.200
    84.244    -1.012     0.200
    85.019     0.918     0.200
    85.105    -1.162     0.200
    85.087    -2.244     0.200
    85.302    -1.559     0.200
    85.528    -1.055     0.200
    86.119    -1.165     0.200
    86.162    -1.288     0.200
    86.858     1.042     0.200
    88.698    -0.908     0.200
    88.956    -1.480     0.200
    89.910    -2.707     0.200
    90.514     0.288     0.200
    91.241    -0.079     0.200
    92.288    -0.548     0.200
    92.470    -0.768     0.200
    93.110    -0.124     0.200
    93.224    -0.517     0.200
    94.684    -1.740     0.200
    96.543    -2.023     0.200
    20.238    -1.931     0.200
    20.564     1.132     0.200
    20.592    -0.626     0.200
    20.592    -0.736     0.200
    21.073     2.185     0.200
    21.402     1.992     0.200
    21.557     1.501     0.200
    21.712     2.545     0.200
    21.846     1.834     0.200
    22.636     1.214     0.200
    22.681     0.200     0.200
    22.909     1.176     0.200
    22.930     1.141     0.200
    22.940     0.481     0.200
    23.206     1.519     0.200
    23.557     1.455     0.200
    23.928     1.097     0.200
    24.066     2.445     0.200
    24.107     0.775     0.200
    24.392     1.497     0.200
    24.402     0.925     0.200
    24.416     1.004     0.200
    24.599     1.618     0.200
    24.731     1.190     0.200
    24.773     0.537     0.200
    24.797     1.127     0.200
    24.870     0.849     0.200
    24.866     2.753     0.200
    24.943     2.415     0.200
    25.030     0.782     0.200
    25.134     1.187     0.200
    25.271     0.441     0.200
    25.387     0.443     0.200
    25.503     0.844     0.200
    25.585     1.067     0.200
    25.631     0.774     0.200
    25.637     1.440     0.200
    25.657     0.354     0.200
    25.860     0.411     0.200
    25.856     2.037     0.200
    25.861     2.027     0.200
    25.996     1.130     0.200
    26.019     0.595     0.200
    26.208     0.326     0.200
    26.249     1.527     0.200
    26.324     0.220     0.200
    26.403    -0.087     0.200
    26.403    -0.263     0.200
    26.443     0.943     0.200
    26.475     1.536     0.200
    26.524     1.585     0.200
    26.586     1.233     0.200
    26.614     0.774     0.200
    26.640     0.235     0.200
    26.681     0.508     0.200
    26.845    -1.446     0.200
    26.816     1.279     0.200
    26.872     1.183     0.200
    26.881     1.326     0.200
    26.898     0.678     0.200
    26.909     1.062     0.200
    26.907     1.171     0.200
    26.922     0.472     0.200
    26.922     0.351     0.200
    26.943     0.590     0.200
    26.982     1.374     0.200
    26.986     0.521     0.200
    27.081     0.808     0.200
    27.180     1.033     0.200
    27.296     0.005     0.200
    27.298     1.291     0.200
    27.346     1.486     0.200
    27.358     0.597     0.200
    27.369     1.138     0.200
    27.396     1.203     0.200
    27.410     1.337     0.200
    27.417     1.158     0.200
    27.421     1.208     0.200
    27.474     1.111     0.200
    27.511     0.930     0.200
    27.511     1.465     0.200
    27.576     0.612     0.200
    27.668     1.269     0.200
    27.680     1.445     0.200
    27.760    -0.240     0.200
    27.760    -1.220     0.200
    27.738     1.760     0.200
    27.751     1.409     0.200
    27.770     1.898     0.200
    27.817     1.113     0.200
    27.818     1.720     0.200
    27.924     0.905     0.200
    28.036     0.969     0.200
    28.111     0.692     0.200
    28.161     1.888     0.200
    28.168     1.576     0.200
    28.210    -1.815     0.200
    28.210    -1.963     0.200
    28.182     1.726     0.200
    28.310     2.190     0.200
    28.327     1.778     0.200
    28.347     0.915     0.200
    28.362     1.161     0.200
    28.410     2.160     0.200
    28.429     1.479     0.200
    28.465     1.781     0.200
    28.613     2.435     0.200
    28.634     1.907     0.200
    28.715     2.786     0.200
    28.726     1.108     0.200
    28.744     1.287     0.200
    28.746     1.722     0.200
    28.783     1.594     0.200
    28.781     1.977     0.200
    28.873     2.345     0.200
    28.888     2.870     0.200
    28.901     1.515     0.200
    28.913     1.713     0.200
    28.978     1.068     0.200
    29.041     2.507     0.200
    29.069     0.995     0.200
    29.098     2.321     0.200
    29.130     0.678     0.200
    29.135     2.570     0.200
    29.155     0.735     0.200
    29.166     1.726     0.200
    29.197     1.586     0.200
    29.216     2.253     0.200
    29.219     2.664     0.200
    29.240     1.583     0.200
    29.252     1.761     0.200
    29.273     1.306     0.200
    29.352     1.313     0.200
    29.395     1.022     0.200
    29.420     1.865     0.200
    29.449     2.295     0.200
    29.463     1.150     0.200
    29.523     2.091     0.200
    29.535     1.804     0.200
    29.551     1.330     0.200
    29.569     1.652     0.200
    29.669     2.277     0.200
    29.719     1.604     0.200
    29.764     2.366     0.200
    29.849     1.612     0.200
    29.872     1.601     0.200
    29.931     1.383     0.200
    29.936     2.870     0.200
    29.956     1.832     0.200
    30.005     1.721     0.200
    30.033     1.407     0.200
    30.037     1.850     0.200
    30.075     1.348     0.200
    30.144     1.911     0.200
    30.162     1.338     0.200
    30.202     1.133     0.200
    30.231     1.578     0.200
    30.348     1.746     0.200
    30.367     1.724     0.200
    30.376     1.754     0.200
    30.404     1.793     0.200
    30.466     1.687     0.200
    30.466     1.960     0.200
    30.539     1.106     0.200
    30.547     1.259     0.200
    30.557     1.478     0.200
    30.559     1.386     0.200
    30.559     1.769     0.200
    30.565     1.302     0.200
    30.688     1.377     0.200
    30.685     2.475     0.200
    30.715     1.647     0.200
    30.806     1.667     0.200
    30.806     1.502     0.200
    30.841     1.691     0.200
    30.885     1.187     0.200
    30.883     1.643     0.200
    30.905     2.088     0.200
    30.912     1.768     0.200
    30.922     1.419     0.200
    30.931     1.451     0.200
    30.949     1.495     0.200
    30.975     1.881     0.200
    30.996     1.107     0.200
    31.042     1.332     0.200
    31.110     1.667     0.200
    31.130     2.667     0.200
    31.141     1.115     0.200
    31.238     1.525     0.200
    31.242     1.621     0.200
    31.257     2.147     0.200
    31.264     0.895     0.200
    31.269     0.990     0.200
    31.298     1.418     0.200
    31.336     2.396     0.200
    31.362     1.514     0.200
    31.452     1.453     0.200
    31.469     1.238     0.200
    31.469     1.180     0.200
    31.531     1.040     0.200
    31.548     1.384     0.200
    31.678     0.895     0.200
    31.698     1.247     0.200
    31.721     1.622     0.200
    31.732     1.073     0.200
    31.774     2.617     0.200
    31.788     0.865     0.200
    31.795     2.160     0.200
    31.796     1.863     0.200
    31.827     1.803     0.200
    31.846     1.017     0.200
    31.848     1.361     0.200
    31.842     2.078     0.200
    31.846     1.924     0.200
    32.008     1.199     0.200
    32.117     1.130     0.200
    32.161     2.335     0.200
    32.187     1.321     0.200
    32.186     1.630     0.200
    32.196     2.288     0.200
    32.211     1.152     0.200
    32.231     1.874     0.200
    32.264     1.032     0.200
    32.291     1.244     0.200
    32.356     1.161     0.200
    32.369     0.874     0.200
    32.362     1.291     0.200
    32.391     1.768     0.200
    32.413     1.939     0.200
    32.499    -1.309     0.200
    32.485     1.712     0.200
    32.522     1.965     0.200
    32.526     1.262     0.200
    32.532     2.093     0.200
    32.586     1.633     0.200
    32.588     1.283     0.200
    32.599     2.071     0.200
    32.599     2.460     0.200
    32.605     1.166     0.200
    32.609     2.013     0.200
    32.628     1.922     0.200
    32.700     2.043     0.200
    32.704     1.229     0.200
    32.762     1.828     0.200
    32.775     1.577     0.200
    32.778     1.899     0.200
    32.848     0.214     0.200
    32.848    -0.559     0.200
    32.963     1.857     0.200
    32.978     1.582     0.200
    33.021     1.403     0.200
    33.050     0.526     0.200
    33.044     1.964     0.200
    33.064     1.392     0.200
    33.070     1.287     0.200
    33.075     2.085     0.200
    33.157     1.597     0.200
    33.157     1.801     0.200
    33.213     1.450     0.200
    33.276     2.108     0.200
    33.316     2.271     0.200
    33.385     1.721     0.200
    33.437     1.584     0.200
    33.471     1.426     0.200
    33.475     1.525     0.200
    33.492     1.455     0.200
    33.528     1.216     0.200
    33.557     1.228     0.200
    33.581     1.790     0.200
    33.589     1.970     0.200
    33.622     1.317     0.200
    33.646     0.921     0.200
    33.646     1.374     0.200
    33.732     0.474     0.200
    33.777     1.436     0.200
    33.776     1.797     0.200
    33.920     0.733     0.200
    33.941     1.489     0.200
    33.947     1.879     0.200
    33.998     2.099     0.200
    34.005     1.470     0.200
    34.018     0.902     0.200
    34.018     1.744     0.200
    34.021     1.383     0.200
    34.044    -0.142     0.200
    34.036     1.228     0.200
    34.134     1.380     0.200
    34.137     1.226     0.200
    34.228     1.721     0.200
    34.231     1.715     0.200
    34.275     1.094     0.200
    34.293     2.277     0.200
    34.305     2.126     0.200
    34.318     1.547     0.200
    34.343     1.046     0.200
    34.343     1.448     0.200
    34.365     2.066     0.200
    34.376     1.614     0.200
    34.412     0.970     0.200
    34.443     0.965     0.200
    34.475     1.209     0.200
    34.490     2.079     0.200
    34.505     1.387     0.200
    34.519     1.127     0.200
    34.521     0.692     0.200
    34.559     1.640     0.200
    34.626     1.000     0.200
    34.658     1.262     0.200
    34.754     1.894     0.200
    34.754     1.722     0.200
    34.765     1.491     0.200
    34.792     1.516     0.200
    34.794     1.859     0.200
    34.791     1.565     0.200
    34.799     1.695     0.200
    34.818     1.258     0.200
    34.836     1.542     0.200
    34.841     1.441     0.200
    34.844     1.480     0.200
    34.935     0.584     0.200
    34.956     2.347     0.200
    34.964     2.148     0.200
    35.115     1.845     0.200
    35.171     1.782     0.200
    35.171     2.087     0.200
    35.201     1.676     0.200
    35.237     1.939     0.200
    35.254     0.788     0.200
    35.254     1.280     0.200
    35.261     1.743     0.200
    35.288     1.255     0.200
    35.294     1.769     0.200
    35.305     1.813     0.200
    35.310     1.916     0.200
    35.330     1.870     0.200
    35.351     2.024     0.200
    35.370     2.175     0.200
    35.556     1.815     0.200
    35.611     1.529     0.200
    35.618     1.625     0.200
    35.617     1.835     0.200
    35.619     1.329     0.200
    35.671     1.847     0.200
    35.683     2.260     0.200
    35.714     2.286     0.200
    35.721     1.922     0.200
    35.773     1.146     0.200
    35.844     1.855     0.200
    35.854     2.212     0.200
    35.895     1.803     0.200
    35.909     1.806     0.200
    35.974     1.554     0.200
    36.090     1.432     0.200
    36.104     1.646     0.200
    36.119     1.860     0.200
    36.134     2.287     0.200
    36.155     1.781     0.200
    36.172     1.804     0.200
    36.191     2.129     0.200
    36.210     2.449     0.200
    36.281     1.460     0.200
    36.286     1.934     0.200
    36.290     1.709     0.200
    36.376     1.759     0.200
    36.466     2.140     0.200
    36.488     1.836     0.200
    36.535    -0.235     0.200
    36.587     2.373     0.200
    36.631     1.973     0.200
    36.652    -0.131     0.200
    36.658     2.118     0.200
    36.678     1.993     0.200
    36.729     2.130     0.200
    36.784     2.005     0.200
    36.840    -2.061     0.200
    36.840    -2.190     0.200
    36.884     1.800     0.200
    36.893     1.835     0.200
    36.900     2.115     0.200
    36.970     1.845     0.200
    36.993     1.572     0.200
    37.064     1.869     0.200
    37.062     1.933     0.200
    37.101     2.276     0.200
    37.103     2.548     0.200
    37.224     2.476     0.200
    37.323     1.528     0.200
    37.339     1.659     0.200
    37.360     2.015     0.200
    37.381     1.860     0.200
    37.402     1.782     0.200
    37.404     2.172     0.200
    37.459     2.610     0.200
    37.475     1.078     0.200
    37.495     1.814     0.200
    37.501     2.465     0.200
    37.561     2.568     0.200
    37.639     0.732     0.200
    37.743     1.739     0.200
    37.748     2.223     0.200
    37.787     2.273     0.200
    37.789     2.218     0.200
    37.928     2.418     0.200
    37.952     1.938     0.200
    37.991     2.407     0.200
    38.037     2.261     0.200
    38.037     2.143     0.200
    38.053     1.610     0.200
    38.064     1.590     0.200
    38.126     2.410     0.200
    38.193     2.558     0.200
    38.281     2.016     0.200
    38.295     1.859     0.200
    38.307     1.808     0.200
    38.372     2.115     0.200
    38.401     2.316     0.200
    38.415     1.510     0.200
    38.465     2.339     0.200
    38.469     1.790     0.200
    38.476     1.776     0.200
    38.514     2.312     0.200
    38.535     0.932     0.200
    38.576     1.728     0.200
    38.599     1.655     0.200
    38.602     1.984     0.200
    38.693     2.254     0.200
    38.758     2.303     0.200
    38.845     1.809     0.200
    38.867     1.970     0.200
    38.906     2.138     0.200
    39.060     2.012     0.200
    39.150     2.228     0.200
    39.161     2.158     0.200
    39.286     2.004     0.200
    39.299     1.900     0.200
    39.331     2.222     0.200
    39.374     1.884     0.200
    39.482     1.823     0.200
    39.507     1.929     0.200
    39.589    -1.690     0.200
    39.553     1.917     0.200
    39.580     2.468     0.200
    39.676     1.436     0.200
    39.698     1.589     0.200
    39.716    -0.664     0.200
    39.749     1.637     0.200
    39.760     2.073     0.200
    39.885     1.901     0.200
    39.952     0.018     0.200
    39.947     2.008     0.200
    39.961     0.265     0.200
    39.985     1.453     0.200
    39.997     1.841     0.200
    40.187     1.443     0.200
    40.249     1.438     0.200
    40.524     0.903     0.200
    40.553     1.315     0.200
    40.564    -1.141     0.200
    40.626     1.084     0.200
    40.683     1.190     0.200
    40.777     1.459     0.200
    40.815     1.560     0.200
    40.875     1.186     0.200
    40.978     0.951     0.200
    41.106     1.275     0.200
    41.136     1.483     0.200
    41.292     1.470     0.200
    41.349     1.415     0.200
    41.415     0.974     0.200
    41.483     0.946     0.200
    41.535     1.407     0.200
    41.595    -1.861     0.200
    41.595    -1.630     0.200
    41.629     0.413     0.200
    41.629     0.253     0.200
    41.660     1.457     0.200
    41.814    -3.305     0.200
    41.901    -0.807     0.200
    41.980     1.221     0.200
    42.131     0.818     0.200
    42.130     2.033     0.200
    42.181     0.313     0.200
    42.181     0.051     0.200
    42.198     1.431     0.200
    42.399     1.361     0.200
    42.472    -1.552     0.200
    42.560     0.032     0.200
    42.560    -0.078     0.200
    42.699     1.623     0.200
    42.730     0.673     0.200
    42.781    -1.862     0.200
    42.781    -0.959     0.200
    42.784     0.245     0.200
    42.865     1.154     0.200
    43.165     1.704     0.200
    43.323     1.583     0.200
    43.333     1.297     0.200
    43.460    -1.512     0.200
    43.462    -1.293     0.200
    43.559     1.391     0.200
    43.731     1.495     0.200
    43.971     1.273     0.200
    44.022    -0.979     0.200
    44.011     1.319     0.200
    44.026     0.494     0.200
    44.232     1.136     0.200
    44.706    -0.297     0.200
    44.977     0.630     0.200
    44.977     0.848     0.200
    44.991    -0.078     0.200
    45.211     0.279     0.200
    45.460    -0.639     0.200
    45.505    -0.458     0.200
    45.661    -2.184     0.200
    46.029    -0.680     0.200
    46.603    -0.082     0.200
    46.600     0.649     0.200
    46.799    -0.315     0.200
    46.961    -2.426     0.200
    47.434     1.238     0.200
    47.544     0.204     0.200
    47.859    -2.451     0.200
    47.859    -1.990     0.200
    48.403     0.677     0.200
    48.493    -0.288     0.200
    48.620    -0.077     0.200
    48.735     0.185     0.200
    49.216    -1.778     0.200
    49.290    -0.140     0.200
    49.403    -1.139     0.200
    49.403    -1.208     0.200
    49.403    -1.005     0.200
    49.615    -0.585     0.200
    49.866    -0.425     0.200
    49.942    -0.098     0.200
    50.495    -1.583     0.200
    51.180    -0.428     0.200
    52.074     0.129     0.200
    52.115    -2.103     0.200
    52.326    -1.590     0.200
    52.326    -1.458     0.200
    53.557    -1.632     0.200
    53.604    -1.269     0.200
    53.887    -1.150     0.200
    53.887    -0.650     0.200
    54.060    -0.608     0.200
    54.060    -0.609     0.200
    54.239    -1.005     0.200
    54.250    -1.387     0.200
    54.665    -1.020     0.200
    55.055    -0.465     0.200
    55.274     0.010     0.200
    55.399    -1.093     0.200
    55.832    -0.995     0.200
    55.866    -1.737     0.200
    56.132    -0.339     0.200
    56.765    -2.182     0.200
    57.861    -1.159     0.200
    58.577    -0.263     0.200
    58.649    -3.266     0.200
    58.946    -1.641     0.200
    58.946    -1.544     0.200
    58.958    -0.802     0.200
    59.287    -0.718     0.200
    59.366    -0.723     0.200
    59.587    -1.105     0.200
    59.787    -1.719     0.200
    60.096    -1.908     0.200
    60.152    -2.826     0.200
    60.155    -1.147     0.200
    60.184    -1.860     0.200
    60.320    -1.113     0.200
    60.456    -1.326     0.200
    60.484    -0.917     0.200
    60.816    -1.862     0.200
    61.201    -0.631     0.200
    61.217    -1.047     0.200
    61.381    -0.444     0.200
    61.515    -0.868     0.200
    61.646    -1.190     0.200
    62.133    -0.431     0.200
    62.170    -1.372     0.200
    62.230    -0.469     0.200
    62.422    -0.489     0.200
    62.629    -0.028     0.200
    62.841    -1.061     0.200
    62.905    -1.979     0.200
    62.905    -1.479     0.200
    63.294    -0.647     0.200
    63.324    -0.662     0.200
    63.397    -1.832     0.200
    63.453    -0.900     0.200
    63.462    -0.833     0.200
    63.618    -1.693     0.200
    63.618    -1.892     0.200
    63.694    -1.589     0.200
    63.694    -1.730     0.200
    63.699    -1.624     0.200
    63.870    -1.151     0.200
    63.870    -0.054     0.200
    64.031    -1.232     0.200
    64.094    -1.518     0.200
    64.476    -1.177     0.200
    64.485     0.224     0.200
    64.584    -0.862     0.200
    65.558     0.159     0.200
    65.750    -0.673     0.200
    65.924    -1.194     0.200
    65.981    -1.760     0.200
    65.981    -2.131     0.200
    65.981    -1.858     0.200
    66.101    -1.232     0.200
    66.168    -0.282     0.200
    66.191    -0.748     0.200
    66.326    -0.873     0.200
    66.336    -0.737     0.200
    66.346    -0.268     0.200
    66.568    -0.297     0.200
    66.602    -1.433     0.200
    66.602    -1.671     0.200
    66.602    -1.234     0.200
    66.752    -1.087     0.200
    66.753    -1.397     0.200
    67.021    -3.096     0.200
    67.081    -1.181     0.200
    67.429    -0.682     0.200
    67.851    -0.939     0.200
    67.851    -1.408     0.200
    68.322    -0.098     0.200
    68.406    -0.115     0.200
    68.519    -2.523     0.200
    68.851    -0.399     0.200
    68.936    -1.346     0.200
    69.087    -1.343     0.200
    69.159     0.200     0.200
    69.197    -0.533     0.200
    69.513    -1.487     0.200
    69.513    -1.456     0.200
    69.708     0.024     0.200
    69.849    -0.540     0.200
    69.939    -0.444     0.200
    69.943    -0.197     0.200
    69.946    -0.945     0.200
    69.946    -0.645     0.200
    70.128     0.337     0.200
    70.136    -1.009     0.200
    70.156    -0.529     0.200
    70.270    -2.928     0.200
    70.336    -1.532     0.200
    70.459    -0.747     0.200
    70.459    -0.587     0.200
    70.470    -0.547     0.200
    70.538    -0.162     0.200
    70.536    -1.150     0.200
    70.641    -1.490     0.200
    70.674    -0.044     0.200
    70.674    -0.192     0.200
    70.752    -0.065     0.200
    70.780    -0.234     0.200
    70.794    -0.807     0.200
    70.794     0.283     0.200
    70.794    -0.018     0.200
    70.854     0.011     0.200
    70.867    -1.765     0.200
    70.877    -1.124     0.200
    70.935    -1.179     0.200
    70.958    -0.017     0.200
    70.959    -1.220     0.200
    70.988    -0.195     0.200
    71.115    -0.465     0.200
    71.167     0.222     0.200
    71.187    -1.502     0.200
    71.230    -1.557     0.200
    71.230    -2.057     0.200
    71.237    -1.302     0.200
    71.237    -1.419     0.200
    71.298    -0.570     0.200
    71.371    -0.013     0.200
    71.372    -0.217     0.200
    71.388    -0.217     0.200
    71.396     0.034     0.200
    71.473     0.075     0.200
    71.510    -0.649     0.200
    71.557    -0.662     0.200
    71.680    -0.171     0.200
    71.728    -0.479     0.200
    71.799    -0.185     0.200
    71.821     0.283     0.200
    71.821    -0.576     0.200
    71.821    -0.719     0.200
    71.982    -0.243     0.200
    72.054    -0.216     0.200
    72.054    -0.513     0.200
    72.069    -0.807     0.200
    72.066    -1.186     0.200
    72.078    -0.055     0.200
    72.134    -0.375     0.200
    72.134    -0.894     0.200
    72.134    -1.273     0.200
    72.134    -0.594     0.200
    72.153    -0.406     0.200
    72.155     0.180     0.200
    72.155    -0.008     0.200
    72.170    -0.909     0.200
    72.179    -0.159     0.200
    72.219    -0.130     0.200
    72.219     0.300     0.200
    72.219    -0.310     0.200
    72.223     0.278     0.200
    72.323    -0.381     0.200
    72.323    -0.521     0.200
    72.334     0.014     0.200
    72.348    -0.365     0.200
    72.348    -0.666     0.200
    72.379     0.649     0.200
    72.385    -0.484     0.200
    72.385    -0.187     0.200
    72.420    -0.139     0.200
    72.445    -1.146     0.200
    72.450    -0.372     0.200
    72.450    -0.474     0.200
    72.640     0.698     0.200
    72.665    -1.450     0.200
    72.699    -1.152     0.200
    72.702    -0.470     0.200
    72.787    -1.173     0.200
    72.790    -0.494     0.200
    72.805    -1.186     0.200
    72.835    -0.149     0.200
    72.838    -1.579     0.200
    72.838    -1.579     0.200
    72.885    -0.457     0.200
    72.902     0.243     0.200
    72.902     0.343     0.200
    72.952    -1.255     0.200
    73.069     0.256     0.200
    73.071     0.644     0.200
    73.131    -1.210     0.200
    73.152    -0.034     0.200
    73.179    -0.094     0.200
    73.192    -1.472     0.200
    73.205    -0.547     0.200
    73.277     0.130     0.200
    73.338    -1.430     0.200
    73.410    -0.454     0.200
    73.463    -0.466     0.200
    73.487    -0.128     0.200
    73.500    -0.123     0.200
    73.541     0.148     0.200
    73.598     0.383     0.200
    73.678    -0.026     0.200
    73.714     0.365     0.200
    73.714    -0.135     0.200
    73.737     0.029     0.200
    73.775    -0.795     0.200
    73.811     0.693     0.200
    73.811     0.186     0.200
    73.811     0.393     0.200
    73.814     0.275     0.200
    73.837     0.144     0.200
    73.956     0.055     0.200
    74.150    -0.181     0.200
    74.168     0.511     0.200
    74.188     0.035     0.200
    74.201     0.119     0.200
    74.251     0.230     0.200
    74.256    -0.401     0.200
    74.270    -0.331     0.200
    74.300    -0.053     0.200
    74.334    -1.557     0.200
    74.338     0.014     0.200
    74.536     2.373     0.200
    74.641    -0.902     0.200
    74.693    -0.333     0.200
    74.716    -0.417     0.200
    74.745     0.461     0.200
    74.755     1.110     0.200
    74.795    -1.227     0.200
    74.828     1.184     0.200
    74.842    -0.029     0.200
    74.850    -0.443     0.200
    74.939    -0.055     0.200
    74.939     0.445     0.200
    74.938     0.149     0.200
    74.959     0.228     0.200
    75.057    -0.039     0.200
    75.242    -0.970     0.200
    75.284    -0.937     0.200
    75.385     0.877     0.200
    75.403    -0.722     0.200
    75.410    -1.012     0.200
    75.442    -0.145     0.200
    75.442    -0.446     0.200
    75.466    -0.481     0.200
    75.466    -0.583     0.200
    75.568    -0.898     0.200
    75.740    -0.348     0.200
    75.822     0.984     0.200
    75.900    -0.564     0.200
    75.917    -0.559     0.200
    76.034     1.175     0.200
    76.189    -0.406     0.200
    76.196     0.055     0.200
    76.215     0.449     0.200
    76.280    -0.222     0.200
    76.287    -0.463     0.200
    76.308     0.723     0.200
    76.328    -1.594     0.200
    76.361    -0.981     0.200
    76.435     0.298     0.200
    76.474     0.077     0.200
    76.480     3.046     0.200
    76.483     0.229     0.200
    76.526     0.285     0.200
    76.552     0.136     0.200
    76.575    -0.495     0.200
    76.657    -0.954     0.200
    76.690    -0.339     0.200
    76.801    -2.775     0.200
    76.796     0.764     0.200
    77.179     0.109     0.200
    77.179    -0.028     0.200
    77.252    -0.700     0.200
    77.252    -1.098     0.200
    77.251    -2.193     0.200
    77.481    -0.374     0.200
    77.721     1.082     0.200
    77.721     0.882     0.200
    77.726     0.056     0.200
    77.981    -0.688     0.200
    78.117     0.485     0.200
    78.155     1.478     0.200
    78.281    -1.119     0.200
    78.275    -0.584     0.200
    78.358     0.054     0.200
    78.455    -0.581     0.200
    78.622    -0.099     0.200
    78.658    -0.697     0.200
    78.692     0.068     0.200
    78.692     0.119     0.200
    78.732    -0.804     0.200
    78.730    -0.290     0.200
    78.738    -0.237     0.200
    78.836    -0.173     0.200
    78.836    -0.575     0.200
    78.843    -0.713     0.200
    78.849    -0.746     0.200
    78.854     0.230     0.200
    78.854    -0.321     0.200
    79.105     0.353     0.200
    79.123    -2.046     0.200
    79.182    -1.565     0.200
    79.269    -0.842     0.200
    79.247    -1.418     0.200
    79.353    -1.800     0.200
    79.351     0.108     0.200
    79.413     0.074     0.200
    79.682     0.514     0.200
    79.711    -0.542     0.200
    79.837     0.878     0.200
    79.868     0.107     0.200
    79.956     0.534     0.200
    79.979     0.207     0.200
    80.078     1.575     0.200
    80.265    -0.235     0.200
    80.286    -0.147     0.200
    80.529    -0.250     0.200
    80.529    -0.149     0.200
    80.686     0.114     0.200
    80.748    -0.122     0.200
    80.753    -0.649     0.200
    80.771    -0.043     0.200
    80.771     0.058     0.200
    80.792     0.643     0.200
    80.792     0.982     0.200
    80.872     0.121     0.200
    80.899    -1.523     0.200
    81.000    -0.665     0.200
    81.027    -0.308     0.200
    81.041     0.121     0.200
    81.226    -1.965     0.200
    81.245    -0.043     0.200
    81.453     0.133     0.200
    81.491    -0.263     0.200
    81.552     0.414     0.200
    81.729    -0.521     0.200
    81.799    -0.087     0.200
    81.863    -0.325     0.200
    81.895     0.308     0.200
    81.943    -0.245     0.200
    82.029     0.102     0.200
    82.096    -0.549     0.200
    82.098     0.040     0.200
    82.244    -1.224     0.200
    82.306    -1.534     0.200
    82.476    -0.130     0.200
    82.799    -0.908     0.200
    83.146    -2.386     0.200
    83.676    -1.628     0.200
    83.984    -0.754     0.200
    83.984    -1.047     0.200
    84.910     0.074     0.200
    84.910    -0.594     0.200
    86.857    -0.662     0.200
    88.907    -1.560     0.200
    89.212    -0.932     0.200
    91.579    -4.062     0.200
    91.592     0.865     0.200
    93.209    -0.853     0.200
    93.782    -0.886     0.200
    94.526    -0.231     0.200
    96.949    -2.763     0.200
    97.044    -0.171     0.200
    98.557    -1.243     0.200
    18.884    -0.989     0.200
    20.385    -0.281     0.200
    20.395    -0.797     0.200
    24.109     1.775     0.200
    24.511     1.374     0.200
    24.815     2.870     0.200
    24.829     1.401     0.200
    25.182     1.227     0.200
    25.476     1.483     0.200
    25.614     1.497     0.200
    25.610     2.727     0.200
    25.696     1.207     0.200
    25.795     0.775     0.200
    25.832     1.372     0.200
    25.949     1.325     0.200
    26.025     1.464     0.200
    26.065     0.946     0.200
    26.077     1.785     0.200
    26.225     0.609     0.200
    26.245     0.648     0.200
    26.543     0.828     0.200
    26.697     0.677     0.200
    26.693     0.878     0.200
    26.772     0.618     0.200
    26.802     0.516     0.200
    26.837     0.838     0.200
    26.947     0.563     0.200
    27.091    -1.753     0.200
    27.038    -0.058     0.200
    27.140     0.656     0.200
    27.185     0.911     0.200
    27.193     1.126     0.200
    27.328     0.352     0.200
    27.509     0.799     0.200
    27.642     1.137     0.200
    27.646     0.740     0.200
    27.645     1.788     0.200
    27.661     1.147     0.200
    27.673     1.439     0.200
    27.860     0.959     0.200
    27.959    -0.091     0.200
    27.959    -0.461     0.200
    27.920     1.184     0.200
    27.928     1.731     0.200
    27.961     1.525     0.200
    27.983     1.305     0.200
    28.002     0.783     0.200
    28.035     1.214     0.200
    28.098     1.096     0.200
    28.253     0.509     0.200
    28.417     1.017     0.200
    28.422     1.289     0.200
    28.493     1.443     0.200
    28.532     1.511     0.200
    28.703     1.301     0.200
    28.722     1.118     0.200
    28.786     1.528     0.200
    28.809     1.648     0.200
    28.814     1.828     0.200
    28.837     1.182     0.200
    28.860     1.496     0.200
    28.926     1.251     0.200
    28.919     2.038     0.200
    29.030     2.059     0.200
    29.043     1.463     0.200
    29.199     1.347     0.200
    29.222     1.409     0.200
    29.214     1.694     0.200
    29.373     1.723     0.200
    29.476     1.106     0.200
    29.501     1.247     0.200
    29.553     1.693     0.200
    29.669     1.270     0.200
    29.706     1.169     0.200
    29.743     1.326     0.200
    29.739     1.669     0.200
    29.788     1.613     0.200
    30.002     2.050     0.200
    30.034     1.029     0.200
    30.178     2.056     0.200
    30.203     2.056     0.200
    30.207     2.795     0.200
    30.263     1.775     0.200
    30.312     2.668     0.200
    30.372     1.460     0.200
    30.466     0.913     0.200
    30.492     1.212     0.200
    30.692     1.225     0.200
    30.730     1.815     0.200
    30.742     1.817     0.200
    30.801     1.419     0.200
    30.836     1.195     0.200
    30.936     1.602     0.200
    31.079     1.576     0.200
    31.158     1.737     0.200
    31.204     1.325     0.200
    31.229     1.914     0.200
    31.343     1.393     0.200
    31.410     1.426     0.200
    31.680     1.803     0.200
    31.689     1.398     0.200
    31.697     0.938     0.200
    31.715     1.426     0.200
    31.709     1.721     0.200
    31.709     0.860     0.200
    31.709     1.460     0.200
    31.743     2.084     0.200
    31.800     2.351     0.200
    31.842     1.616     0.200
    32.001     1.340     0.200
    32.051     1.834     0.200
    32.068     1.304     0.200
    32.103     1.434     0.200
    32.223     1.532     0.200
    32.276     1.608     0.200
    32.392     1.893     0.200
    32.442     1.685     0.200
    32.408     1.965     0.200
    32.452     1.540     0.200
    32.480     1.195     0.200
    32.573     2.302     0.200
    32.799     1.857     0.200
    32.929     1.761     0.200
    33.040     1.293     0.200
    33.088     1.198     0.200
    33.297     2.394     0.200
    33.362     3.215     0.200
    33.420     1.272     0.200
    33.437     1.801     0.200
    33.689     0.935     0.200
    33.751     1.468     0.200
    33.778     1.329     0.200
    33.814     1.169     0.200
    33.796     2.476     0.200
    33.796     1.681     0.200
    33.834     1.495     0.200
    33.838     2.270     0.200
    33.950     2.219     0.200
    34.201     1.449     0.200
    34.210     1.326     0.200
    34.231     1.259     0.200
    34.229     1.383     0.200
    34.261     1.851     0.200
    34.270     1.734     0.200
    34.380    -0.003     0.200
    34.487     1.906     0.200
    34.575     0.906     0.200
    34.615     1.086     0.200
    34.640     0.873     0.200
    34.742     1.424     0.200
    34.897     1.907     0.200
    34.950     1.687     0.200
    35.066     1.295     0.200
    35.088     1.008     0.200
    35.129     1.574     0.200
    35.122     1.980     0.200
    35.230     1.486     0.200
    35.243     2.160     0.200
    35.440     1.581     0.200
    35.449     1.797     0.200
    35.540     0.575     0.200
    35.537     1.802     0.200
    35.547     2.273     0.200
    35.607     1.153     0.200
    35.609     1.338     0.200
    35.884     1.535     0.200
    35.876     2.282     0.200
    36.072     1.789     0.200
    36.285     1.700     0.200
    36.889     1.653     0.200
    36.896     1.823     0.200
    36.961     1.969     0.200
    37.263     2.024     0.200
    37.278     1.671     0.200
    37.296     1.636     0.200
    37.306     2.305     0.200
    37.315     1.829     0.200
    37.572     2.410     0.200
    37.662     2.278     0.200
    37.817     2.065     0.200
    37.860     1.742     0.200
    38.078     2.010     0.200
    38.153     1.922     0.200
    38.154     1.907     0.200
    38.171     2.308     0.200
    38.377     2.665     0.200
    38.639     1.818     0.200
    39.047     1.996     0.200
    39.063     2.069     0.200
    39.110     0.828     0.200
    39.097     2.034     0.200
    39.359     1.895     0.200
    39.381     2.063     0.200
    39.405     1.737     0.200
    39.417     1.807     0.200
    39.579     2.003     0.200
    39.737     1.686     0.200
    39.807     2.084     0.200
    40.059     1.988     0.200
    40.379     1.162     0.200
    40.372     2.232     0.200
    40.388     1.977     0.200
    40.765     2.176     0.200
    40.782     1.344     0.200
    40.824     2.255     0.200
    40.888     1.999     0.200
    40.946     1.951     0.200
    41.296    -4.496     0.200
    41.267     1.617     0.200
    41.333     1.403     0.200
    41.558    -0.037     0.200
    41.620     1.445     0.200
    41.761     1.188     0.200
    41.782     1.641     0.200
    41.787     1.306     0.200
    42.031     1.345     0.200
    42.158     1.515     0.200
    42.158     1.692     0.200
    42.308     1.455     0.200
    42.630     1.574     0.200
    43.111    -0.261     0.200
    43.111    -0.761     0.200
    43.087     1.600     0.200
    43.220    -1.845     0.200
    43.191     1.687     0.200
    43.784     1.418     0.200
    44.512     1.269     0.200
    44.729     1.720     0.200
    44.931     1.510     0.200
    44.980     1.387     0.200
    45.214     1.255     0.200
    45.330    -4.306     0.200
    45.484     0.510     0.200
    45.712    -1.226     0.200
    46.050     1.009     0.200
    46.050     1.170     0.200
    46.918     1.311     0.200
    48.026    -0.991     0.200
    48.909    -0.070     0.200
    52.421     0.293     0.200
    53.135    -2.502     0.200
    53.362    -1.836     0.200
    53.909    -2.767     0.200
    55.667    -0.949     0.200
    57.036     0.167     0.200
    58.987    -1.361     0.200
    58.987    -1.481     0.200
    59.923    -1.432     0.200
    60.736    -2.088     0.200
    60.815    -1.823     0.200
    61.368    -1.367     0.200
    61.368    -0.766     0.200
    61.488    -1.506     0.200
    61.537    -0.799     0.200
    61.574     1.800     0.200
    61.874    -1.077     0.200
    62.664    -1.656     0.200
    63.430    -1.935     0.200
    63.430    -2.165     0.200
    63.716    -1.921     0.200
    63.976    -1.536     0.200
    63.979    -2.155     0.200
    64.099    -2.342     0.200
    64.398    -1.896     0.200
    64.476    -1.405     0.200
    65.247    -1.218     0.200
    65.739     0.604     0.200
    65.948    -2.139     0.200
    65.948    -1.840     0.200
    65.948    -1.840     0.200
    66.565     4.611     0.200
    67.198    -0.786     0.200
    67.378    -0.882     0.200
    67.378    -1.082     0.200
    67.476    -1.570     0.200
    67.599    -0.847     0.200
    69.223    -2.389     0.200
    69.944    -1.730     0.200
    69.944    -1.690     0.200
    71.169    -0.691     0.200
    71.475     0.358     0.200
    71.514     0.224     0.200
    71.671     0.401     0.200
    72.058     0.259     0.200
    72.192    -0.540     0.200
    72.200    -0.287     0.200
    72.213    -1.667     0.200
    72.213    -1.567     0.200
    72.220    -1.710     0.200
    72.346    -0.261     0.200
    72.346    -0.061     0.200
    72.984    -0.249     0.200
    72.992    -1.593     0.200
    72.992    -1.093     0.200
    73.305    -0.444     0.200
    73.377     0.236     0.200
    73.478    -0.260     0.200
    73.670     0.193     0.200
    73.766     0.348     0.200
    73.995     0.410     0.200
    74.008     0.437     0.200
    74.014     0.200     0.200
    74.160     0.448     0.200
    74.312     0.563     0.200
    74.325    -0.313     0.200
    74.530     3.800     0.200
    74.555     0.353     0.200
    74.732    -0.292     0.200
    74.804     0.314     0.200
    75.068     0.091     0.200
    75.105     0.780     0.200
    75.223     0.779     0.200
    75.318    -0.817     0.200
    75.347    -0.515     0.200
    75.398     0.394     0.200
    75.923     0.246     0.200
    75.955     0.915     0.200
    76.056    -0.304     0.200
    76.146    -0.474     0.200
    76.171     0.277     0.200
    76.182     0.724     0.200
    76.632    -0.507     0.200
    76.638     0.743     0.200
    76.779    -1.306     0.200
    77.045     1.550     0.200
    77.106    -0.134     0.200
    77.297    -0.460     0.200
    77.546    -0.152     0.200
    77.760    -0.547     0.200
    77.980    -0.770     0.200
    77.980    -0.151     0.200
    78.980    -2.180     0.200
    80.169     0.337     0.200
    80.781    -0.416     0.200
    81.073    -0.369     0.200
    81.161    -0.036     0.200
    81.315    -1.256     0.200
    81.568     0.005     0.200
    81.568    -0.595     0.200
    81.607    -0.699     0.200
    81.662    -0.290     0.200
    82.988    -0.703     0.200
    82.989    -0.314     0.200
    83.184    -0.505     0.200
    86.230     1.308     0.200
    20.396     0.506     0.200
    27.704     0.353     0.200
    53.626    -2.195     0.200
    53.626    -2.195     0.200
    54.128    -1.689     0.200
    56.493    -0.619     0.200
    59.876    -1.125     0.200
    60.712    -1.520     0.200
    61.584    -2.334     0.200
    62.064    -0.762     0.200
    62.064    -0.762     0.200
    62.256    -1.075     0.200
    64.607    -0.458     0.200
    64.716    -1.169     0.200
    64.872    -1.290     0.200
    66.833    -1.484     0.200
    70.104    -1.378     0.200
    72.998    -1.502     0.200
    73.090    -0.079     0.200
    74.363    -0.259     0.200
    80.697    -0.559     0.200
    83.914    -0.790     0.200
    19.550    -0.127     0.200
    19.559     0.186     0.200
    23.387    -0.247     0.200
    27.779    -2.125     0.200
    29.743     2.665     0.200
    30.999     2.249     0.200
    44.196    -1.913     0.200
    44.292     1.324     0.200
    53.036    -2.083     0.200
    56.091    -1.139     0.200
    62.024    -1.453     0.200
    64.055    -1.351     0.200
    83.754    -1.079     0.200
    20.044     0.240     0.200
    26.564    -0.844     0.200
    45.243    -0.396     0.200
    54.689     0.190     0.200
    19.222     0.340     0.200
    19.554    -1.175     0.200
    22.450     1.772     0.200
    22.790     1.197     0.200
    23.645     1.545     0.200
    23.645     1.354     0.200
    23.659     1.670     0.200
    24.276     1.493     0.200
    24.715     1.665     0.200
    25.110     1.205     0.200
    25.568     2.798     0.200
    26.178     1.261     0.200
    26.517     1.161     0.200
    27.386     1.175     0.200
    27.494    -0.738     0.200
    27.593     0.720     0.200
    27.624     0.912     0.200
    27.624     0.576     0.200
    27.625     1.188     0.200
    27.658     1.539     0.200
    27.779     0.990     0.200
    27.895     1.994     0.200
    28.176     1.063     0.200
    28.230     2.505     0.200
    28.272     0.912     0.200
    28.628     1.035     0.200
    28.735     0.882     0.200
    29.064     1.121     0.200
    29.121     2.437     0.200
    29.135     1.433     0.200
    29.138     0.998     0.200
    29.449     1.256     0.200
    29.455     1.702     0.200
    29.677     1.100     0.200
    29.757     2.102     0.200
    29.764     2.559     0.200
    29.879     1.562     0.200
    29.904     1.655     0.200
    29.905     2.781     0.200
    29.958     2.309     0.200
    29.968     2.383     0.200
    30.049     1.380     0.200
    30.045     2.612     0.200
    30.137     2.104     0.200
    30.153     0.996     0.200
    30.165     1.441     0.200
    30.187     2.401     0.200
    30.542     1.422     0.200
    30.669     1.549     0.200
    30.723     1.472     0.200
    30.905     1.415     0.200
    31.040     1.731     0.200
    31.178     1.498     0.200
    31.276     1.562     0.200
    31.389     1.199     0.200
    31.524     2.028     0.200
    31.524     1.602     0.200
    31.600     1.226     0.200
    31.596     1.789     0.200
    31.596     1.688     0.200
    31.619     2.156     0.200
    31.707     1.577     0.200
    31.808     1.404     0.200
    31.835     2.439     0.200
    31.954     1.614     0.200
    31.979     0.783     0.200
    32.024     2.163     0.200
    32.071     1.521     0.200
    32.169     1.405     0.200
    32.433     0.763     0.200
    32.417     1.571     0.200
    32.417     1.465     0.200
    32.448     1.114     0.200
    32.462     2.626     0.200
    32.499     2.236     0.200
    32.560     0.954     0.200
    32.543     1.925     0.200
    32.733     0.931     0.200
    32.781     1.114     0.200
    32.903     1.769     0.200
    32.930     1.807     0.200
    32.979     1.254     0.200
    33.009     2.770     0.200
    33.061     1.307     0.200
    33.074     1.280     0.200
    33.076     1.495     0.200
    33.120     2.425     0.200
    33.142     1.190     0.200
    33.188     1.258     0.200
    33.241     1.420     0.200
    33.304     2.164     0.200
    33.301     2.314     0.200
    33.316     1.435     0.200
    33.317     2.146     0.200
    33.346     2.005     0.200
    33.414     2.150     0.200
    33.434     0.978     0.200
    33.480     2.291     0.200
    33.480     2.115     0.200
    33.493     2.544     0.200
    33.508     1.259     0.200
    33.713     0.980     0.200
    33.733     1.375     0.200
    33.781     1.397     0.200
    33.779     1.896     0.200
    33.817     1.126     0.200
    33.861     1.145     0.200
    33.875     1.519     0.200
    33.875     1.417     0.200
    33.955     1.360     0.200
    33.972     1.761     0.200
    34.209     1.238     0.200
    34.231     0.729     0.200
    34.261     1.474     0.200
    34.270     0.970     0.200
    34.275     1.333     0.200
    34.297     1.767     0.200
    34.329     1.328     0.200
    34.437     1.637     0.200
    34.610     0.735     0.200
    34.712     2.057     0.200
    34.736     1.804     0.200
    34.770     0.932     0.200
    34.842     0.777     0.200
    34.928     1.529     0.200
    35.009     2.222     0.200
    35.015     1.921     0.200
    35.035     1.426     0.200
    35.060     0.620     0.200
    35.089     1.204     0.200
    35.116     1.261     0.200
    35.134     1.199     0.200
    35.208     0.946     0.200
    35.193     1.771     0.200
    35.239     1.224     0.200
    35.278     1.613     0.200
    35.354     1.711     0.200
    35.466     1.297     0.200
    35.543     1.385     0.200
    35.563     1.177     0.200
    35.563     1.622     0.200
    35.624     1.215     0.200
    35.624     0.883     0.200
    35.623     1.050     0.200
    35.660     1.928     0.200
    35.741     0.799     0.200
    35.819     1.670     0.200
    35.886     2.020     0.200
    35.886     1.598     0.200
    35.973     1.239     0.200
    35.979     1.873     0.200
    36.002     1.568     0.200
    36.028     2.045     0.200
    36.115     0.838     0.200
    36.334     1.602     0.200
    36.380     1.668     0.200
    36.508     1.670     0.200
    36.572     1.991     0.200
    36.613     1.818     0.200
    36.628     1.982     0.200
    36.739     2.316     0.200
    36.834     1.817     0.200
    36.880     2.044     0.200
    36.929     2.136     0.200
    37.004     1.899     0.200
    37.094     1.503     0.200
    37.181     1.100     0.200
    37.203     1.968     0.200
    37.305     2.452     0.200
    37.373     1.923     0.200
    37.394     1.900     0.200
    37.502     1.914     0.200
    37.610     1.752     0.200
    37.662     1.645     0.200
    37.708     1.651     0.200
    37.782     1.832     0.200
    37.820     2.201     0.200
    37.972     2.393     0.200
    38.038     2.038     0.200
    38.077     1.700     0.200
    38.099     1.594     0.200
    38.108     1.622     0.200
    38.174     1.413     0.200
    38.174     0.940     0.200
    38.211     1.501     0.200
    38.280     1.856     0.200
    38.489     1.218     0.200
    38.506     2.116     0.200
    38.670     1.775     0.200
    38.755     1.972     0.200
    38.756     2.069     0.200
    38.771     1.870     0.200
    38.844     2.070     0.200
    38.862     1.928     0.200
    38.907     1.260     0.200
    38.911     2.096     0.200
    39.000     1.894     0.200
    39.012     1.896     0.200
    39.045     1.409     0.200
    39.090     1.859     0.200
    39.180     1.971     0.200
    39.195     1.592     0.200
    39.237     1.180     0.200
    39.320     2.020     0.200
    39.360     1.664     0.200
    39.455     1.683     0.200
    39.462     1.390     0.200
    39.564     1.777     0.200
    39.778     1.774     0.200
    39.802     1.711     0.200
    39.867     2.007     0.200
    40.017     1.574     0.200
    40.092     1.865     0.200
    40.197     1.718     0.200
    40.394     1.464     0.200
    40.417     1.262     0.200
    40.468     1.624     0.200
    40.496     0.860     0.200
    40.567     1.292     0.200
    40.603     1.686     0.200
    40.661     1.901     0.200
    40.968     1.480     0.200
    41.064     1.805     0.200
    41.271     1.111     0.200
    41.345     1.273     0.200
    41.402     1.146     0.200
    41.495     1.532     0.200
    41.533     1.566     0.200
    41.717     1.388     0.200
    41.996     1.222     0.200
    42.010     1.716     0.200
    42.049     1.349     0.200
    42.067     1.355     0.200
    42.208     1.217     0.200
    42.311     1.007     0.200
    42.505     1.175     0.200
    42.618     1.107     0.200
    42.845     0.840     0.200
    42.847     1.835     0.200
    43.078     0.920     0.200
    43.257     0.754     0.200
    43.607     0.487     0.200
    43.782     1.044     0.200
    43.883     1.255     0.200
    43.900     1.150     0.200
    44.042     1.541     0.200
    44.051     0.917     0.200
    44.062     0.543     0.200
    44.254     0.476     0.200
    44.266     0.184     0.200
    44.276     0.685     0.200
    44.481    -1.344     0.200
    44.449     1.336     0.200
    44.521     0.810     0.200
    44.645     0.537     0.200
    44.693    -0.069     0.200
    44.688     0.705     0.200
    44.712     0.503     0.200
    44.722     0.635     0.200
    44.728     0.946     0.200
    44.763     0.804     0.200
    44.950     1.198     0.200
    45.000     0.591     0.200
    45.124     0.663     0.200
    45.187     0.790     0.200
    45.381     0.643     0.200
    45.573     0.717     0.200
    45.686     0.608     0.200
    45.696     0.445     0.200
    45.696     0.793     0.200
    45.881    -0.174     0.200
    45.928     0.284     0.200
    46.169     0.154     0.200
    46.490     0.339     0.200
    47.485    -0.048     0.200
    51.632    -0.049     0.200
    52.136    -2.882     0.200
    53.342    -0.554     0.200
    53.342    -0.554     0.200
    55.460    -0.591     0.200
    58.663     3.108     0.200
    58.733    -1.475     0.200
    59.594    -1.825     0.200
    60.066    -2.031     0.200
    60.265    -1.822     0.200
    63.203    -1.964     0.200
    65.398    -1.967     0.200
    66.133     3.752     0.200
    68.364    -0.962     0.200
    69.097    -0.620     0.200
    69.700    -0.620     0.200
    69.826    -0.633     0.200
    69.922    -1.037     0.200
    70.129    -0.773     0.200
    70.146    -0.605     0.200
    70.170    -0.922     0.200
    70.400    -0.924     0.200
    70.495    -0.807     0.200
    70.679    -1.223     0.200
    70.772     0.702     0.200
    70.902    -1.278     0.200
    70.977    -1.034     0.200
    71.015    -2.161     0.200
    71.307    -0.424     0.200
    71.323    -0.627     0.200
    71.806    -0.530     0.200
    72.058    -0.835     0.200
    72.142    -0.740     0.200
    72.348    -1.063     0.200
    72.366    -0.873     0.200
    72.366    -0.240     0.200
    72.676    -1.013     0.200
    72.810    -0.808     0.200
    72.823    -0.387     0.200
    72.828    -0.819     0.200
    72.961    -0.801     0.200
    73.203    -1.030     0.200
    73.354    -0.920     0.200
    73.389    -0.426     0.200
    73.416    -1.089     0.200
    73.519    -1.088     0.200
    73.762    -0.412     0.200
    73.961     2.825     0.200
    74.592    -0.742     0.200
    74.823    -0.780     0.200
    74.922     0.250     0.200
    74.943     0.431     0.200
    75.288    -0.553     0.200
    75.396    -0.373     0.200
    75.703     0.270     0.200
    76.278     0.197     0.200
    76.345    -0.078     0.200
    76.392    -0.644     0.200
    76.638    -0.639     0.200
    77.123    -0.459     0.200
    78.127    -0.657     0.200
    78.792    -0.285     0.200
    83.274    -0.985     0.200
    84.891    -0.623     0.200
    19.982    -1.711     0.200
    19.982    -1.511     0.200
    19.942     0.028     0.200
    20.417     1.436     0.200
    20.494     1.197     0.200
    20.933     2.725     0.200
    21.300     1.212     0.200
    21.496     1.454     0.200
    21.528    -1.096     0.200
    21.603     0.841     0.200
    21.686     0.822     0.200
    21.839     1.074     0.200
    22.029     0.521     0.200
    22.405     0.943     0.200
    22.449     0.923     0.200
    22.473     0.633     0.200
    22.530    -0.985     0.200
    22.533     0.632     0.200
    22.595     0.903     0.200
    22.588     0.750     0.200
    22.589     0.181     0.200
    22.609    -0.082     0.200
    22.675    -0.176     0.200
    22.705     0.766     0.200
    22.751     0.638     0.200
    22.861     1.668     0.200
    22.900     1.312     0.200
    22.945     0.705     0.200
    22.954     0.666     0.200
    22.954     0.478     0.200
    23.128     0.918     0.200
    23.429     0.322     0.200
    23.490     1.899     0.200
    23.511     1.465     0.200
    23.735     1.952     0.200
    23.761     0.940     0.200
    23.836     1.821     0.200
    23.912     1.677     0.200
    24.113     1.458     0.200
    24.264     0.970     0.200
    24.278     2.023     0.200
    24.278     1.827     0.200
    24.271     1.535     0.200
    24.290     1.721     0.200
    24.459     1.871     0.200
    24.478     1.745     0.200
    24.621     1.722     0.200
    24.680     1.765     0.200
    24.817     0.980     0.200
    24.846     1.232     0.200
    24.899     0.726     0.200
    25.110     0.898     0.200
    25.225     1.592     0.200
    25.310     1.369     0.200
    25.379     1.816     0.200
    25.543     2.781     0.200
    25.543     1.258     0.200
    25.628     1.548     0.200
    25.867     1.369     0.200
    25.872     0.517     0.200
    26.686     0.980     0.200
    26.699     0.419     0.200
    26.777     0.505     0.200
    26.856     1.491     0.200
    26.974     1.410     0.200
    27.165     0.380     0.200
    27.180     1.481     0.200
    27.223     0.913     0.200
    27.351     0.788     0.200
    27.351     0.989     0.200
    27.372     0.905     0.200
    27.379     0.432     0.200
    27.469     1.354     0.200
    27.672    -2.189     0.200
    27.566     1.557     0.200
    27.853    -1.907     0.200
    27.853    -2.307     0.200
    27.702     0.897     0.200
    27.720     0.678     0.200
    27.892     0.890     0.200
    28.045     1.382     0.200
    28.116     0.645     0.200
    28.143     0.982     0.200
    28.157     1.362     0.200
    28.328    -2.500     0.200
    28.328    -2.040     0.200
    28.206    -0.161     0.200
    28.249     1.156     0.200
    28.311     0.665     0.200
    28.357     1.427     0.200
    28.515     1.547     0.200
    28.530     1.598     0.200
    28.598     1.291     0.200
    28.611     1.605     0.200
    28.751     1.085     0.200
    28.859     1.831     0.200
    28.892     1.492     0.200
    28.904     2.822     0.200
    28.904     0.879     0.200
    28.949     1.598     0.200
    28.985     1.443     0.200
    29.027     1.753     0.200
    29.038     2.136     0.200
    29.058     1.093     0.200
    29.148     1.530     0.200
    29.211     1.696     0.200
    29.227     1.696     0.200
    29.230     2.180     0.200
    29.246     1.593     0.200
    29.333     2.677     0.200
    29.364     1.164     0.200
    29.396     1.554     0.200
    29.425     1.801     0.200
    29.448     1.801     0.200
    29.466     1.272     0.200
    29.554     1.061     0.200
    29.605     1.476     0.200
    29.648     1.477     0.200
    29.684     1.644     0.200
    29.686     1.156     0.200
    29.804     1.547     0.200
    29.821     1.368     0.200
    29.844     1.476     0.200
    29.896     0.681     0.200
    29.908     1.630     0.200
    29.951     0.946     0.200
    29.989     0.064     0.200
    29.989     0.835     0.200
    30.006     0.727     0.200
    30.172     2.046     0.200
    30.173     1.461     0.200
    30.197     1.778     0.200
    30.240     0.719     0.200
    30.267     0.930     0.200
    30.325     1.019     0.200
    30.397     1.560     0.200
    30.425     1.452     0.200
    30.438     1.104     0.200
    30.438     0.960     0.200
    30.517     1.768     0.200
    30.529     0.649     0.200
    30.529     0.588     0.200
    30.543     0.715     0.200
    30.543     1.153     0.200
    30.537    -0.229     0.200
    30.539     0.501     0.200
    30.562     1.607     0.200
    30.601     1.946     0.200
    30.619     1.303     0.200
    30.639     1.930     0.200
    30.671     1.667     0.200
    30.693     2.184     0.200
    30.706     2.186     0.200
    30.751     1.654     0.200
    30.932     1.543     0.200
    30.938     1.965     0.200
    30.939     1.331     0.200
    30.951     1.970     0.200
    31.033     2.050     0.200
    31.033     1.750     0.200
    31.060     0.656     0.200
    31.090     1.330     0.200
    31.110     1.493     0.200
    31.109     2.067     0.200
    31.163     1.642     0.200
    31.163     1.172     0.200
    31.227     1.600     0.200
    31.234     1.393     0.200
    31.229     1.637     0.200
    31.315     0.771     0.200
    31.308     1.431     0.200
    31.388     1.738     0.200
    31.444     2.047     0.200
    31.484     1.105     0.200
    31.513     1.308     0.200
    31.570     1.517     0.200
    31.595     0.971     0.200
    31.643    -0.495     0.200
    31.656     0.145     0.200
    31.779     1.297     0.200
    31.789     1.825     0.200
    31.798     0.673     0.200
    31.846     1.411     0.200
    31.886     1.097     0.200
    31.886     1.189     0.200
    31.920     0.865     0.200
    31.903     1.714     0.200
    31.904     0.869     0.200
    31.966     1.165     0.200
    31.976     0.695     0.200
    32.025     0.241     0.200
    32.009     0.447     0.200
    32.048     2.580     0.200
    32.061     0.089     0.200
    32.091     1.953     0.200
    32.107     0.967     0.200
    32.111     1.493     0.200
    32.171     1.279     0.200
    32.194     1.586     0.200
    32.246     1.383     0.200
    32.275     0.631     0.200
    32.359     1.595     0.200
    32.368     1.591     0.200
    32.418     1.317     0.200
    32.415     1.379     0.200
    32.462     1.687     0.200
    32.507     1.156     0.200
    32.533     1.593     0.200
    32.549     1.763     0.200
    32.554     1.826     0.200
    32.600     1.279     0.200
    32.617     1.268     0.200
    32.629     2.001     0.200
    32.654     1.608     0.200
    32.692     1.411     0.200
    32.702     1.169     0.200
    32.714     1.153     0.200
    32.723     2.254     0.200
    32.739     1.701     0.200
    32.750     1.471     0.200
    32.780     1.051     0.200
    32.872     1.541     0.200
    32.872     1.880     0.200
    32.913     1.578     0.200
    32.925     1.469     0.200
    32.960     1.134     0.200
    33.022     1.805     0.200
    33.054     0.989     0.200
    33.054     1.177     0.200
    33.067     1.138     0.200
    33.075     0.846     0.200
    33.077     0.613     0.200
    33.086     1.051     0.200
    33.153     0.933     0.200
    33.170     1.571     0.200
    33.198     0.868     0.200
    33.223     1.122     0.200
    33.293     1.456     0.200
    33.342     2.007     0.200
    33.337     1.858     0.200
    33.452     1.758     0.200
    33.549     0.729     0.200
    33.549     1.429     0.200
    33.558     1.878     0.200
    33.565     1.890     0.200
    33.573     1.423     0.200
    33.603     1.312     0.200
    33.606     1.424     0.200
    33.693     0.827     0.200
    33.693     0.409     0.200
    33.746     0.379     0.200
    33.766     0.912     0.200
    33.770     1.310     0.200
    33.782     0.400     0.200
    33.804     1.434     0.200
    33.824     0.477     0.200
    33.908     1.342     0.200
    33.940     1.458     0.200
    33.964     1.261     0.200
    33.960     1.352     0.200
    34.006     2.182     0.200
    34.011     1.733     0.200
    34.017     1.541     0.200
    34.049     1.721     0.200
    34.090     1.639     0.200
    34.242     1.137     0.200
    34.270     1.657     0.200
    34.293     1.462     0.200
    34.298     1.433     0.200
    34.293     1.294     0.200
    34.309     0.936     0.200
    34.456    -1.649     0.200
    34.456    -1.919     0.200
    34.358     0.878     0.200
    34.412     0.232     0.200
    34.377     1.835     0.200
    34.392     1.922     0.200
    34.412     2.068     0.200
    34.422     1.889     0.200
    34.453     0.791     0.200
    34.489     0.233     0.200
    34.544     1.120     0.200
    34.555     0.761     0.200
    34.586     1.202     0.200
    34.610     1.408     0.200
    34.639     0.930     0.200
    34.656     0.382     0.200
    34.656     0.736     0.200
    34.692     1.503     0.200
    34.725     2.227     0.200
    34.725     2.387     0.200
    34.763     1.699     0.200
    34.778     1.468     0.200
    34.795     2.275     0.200
    34.860     1.946     0.200
    34.901     2.281     0.200
    34.951     1.176     0.200
    34.951     0.912     0.200
    34.978     1.506     0.200
    35.026     0.829     0.200
    35.026     0.512     0.200
    35.085     1.495     0.200
    35.163     1.098     0.200
    35.300     1.966     0.200
    35.312     2.371     0.200
    35.311     1.817     0.200
    35.532     2.392     0.200
    35.570     1.948     0.200
    35.592     2.135     0.200
    35.648     1.522     0.200
    35.634     1.265     0.200
    35.681     0.869     0.200
    35.708     1.217     0.200
    35.719     2.359     0.200
    35.720     2.024     0.200
    35.942     2.323     0.200
    35.963     2.413     0.200
    36.010     1.384     0.200
    36.082     2.096     0.200
    36.099     1.405     0.200
    36.117     1.944     0.200
    36.138     2.345     0.200
    36.176     1.594     0.200
    36.253     1.530     0.200
    36.282     1.691     0.200
    36.308     1.892     0.200
    36.352     2.005     0.200
    36.481     2.059     0.200
    36.487     2.366     0.200
    36.492     2.132     0.200
    36.505     1.561     0.200
    36.527     1.753     0.200
    36.564     1.909     0.200
    36.627     1.823     0.200
    36.697     1.771     0.200
    36.767     2.096     0.200
    36.817     1.943     0.200
    36.839     0.601     0.200
    36.839     1.420     0.200
    36.843     1.754     0.200
    36.841     1.653     0.200
    36.896     1.401     0.200
    36.920     2.060     0.200
    36.920     1.927     0.200
    36.975     1.494     0.200
    37.005     1.895     0.200
    37.050    -0.438     0.200
    37.050     0.229     0.200
    37.150     1.354     0.200
    37.228     0.908     0.200
    37.289     2.458     0.200
    37.322     1.894     0.200
    37.324     1.120     0.200
    37.342     1.906     0.200
    37.354     2.676     0.200
    37.360     2.272     0.200
    37.440     1.882     0.200
    37.451     1.597     0.200
    37.586     1.354     0.200
    37.836    -2.455     0.200
    37.836    -1.776     0.200
    37.709     1.388     0.200
    37.738     0.687     0.200
    37.738     1.524     0.200
    37.814     1.025     0.200
    37.817     1.849     0.200
    37.833     1.082     0.200
    37.844     1.996     0.200
    37.864     1.325     0.200
    37.858     1.447     0.200
    37.865     2.258     0.200
    37.913     1.140     0.200
    37.945     1.541     0.200
    38.096     2.056     0.200
    38.132     2.149     0.200
    38.136     2.037     0.200
    38.156     2.198     0.200
    38.178     2.050     0.200
    38.198     1.707     0.200
    38.203     0.376     0.200
    38.192     1.642     0.200
    38.192     1.767     0.200
    38.235     1.429     0.200
    38.268     1.904     0.200
    38.271     1.762     0.200
    38.328     1.130     0.200
    38.336     1.997     0.200
    38.355     1.328     0.200
    38.451     1.313     0.200
    38.558     1.683     0.200
    38.617     1.603     0.200
    38.651     1.419     0.200
    38.679     1.060     0.200
    38.684     1.403     0.200
    38.707     1.284     0.200
    38.714     1.562     0.200
    38.731     1.867     0.200
    38.743     1.669     0.200
    38.801     1.959     0.200
    38.838     2.186     0.200
    38.967     1.235     0.200
    38.967     1.884     0.200
    38.981     1.882     0.200
    39.038     1.791     0.200
    39.088     1.765     0.200
    39.101     2.336     0.200
    39.095     1.832     0.200
    39.136     1.844     0.200
    39.141     1.328     0.200
    39.156     2.028     0.200
    39.163     2.119     0.200
    39.179     1.420     0.200
    39.221     1.965     0.200
    39.346     1.725     0.200
    39.381     1.844     0.200
    39.497     1.739     0.200
    39.502     1.159     0.200
    39.521     1.587     0.200
    39.537     1.730     0.200
    39.536     1.398     0.200
    39.556     1.490     0.200
    39.732    -2.059     0.200
    39.732    -2.439     0.200
    39.576     1.304     0.200
    39.631     1.532     0.200
    39.643     1.645     0.200
    39.661     1.457     0.200
    39.904    -2.592     0.200
    39.790     1.347     0.200
    39.795     0.515     0.200
    39.850     1.494     0.200
    39.878     1.479     0.200
    39.888     1.214     0.200
    39.913     1.332     0.200
    39.980     1.094     0.200
    40.004     1.401     0.200
    40.015     1.525     0.200
    40.068     1.538     0.200
    40.133     0.130     0.200
    40.182     0.568     0.200
    40.182     0.862     0.200
    40.269     1.321     0.200
    40.284     2.107     0.200
    40.332     1.985     0.200
    40.347     1.970     0.200
    40.390     1.288     0.200
    40.417     1.092     0.200
    40.435     1.166     0.200
    40.443     1.015     0.200
    40.443     1.262     0.200
    40.517     1.440     0.200
    40.525     1.635     0.200
    40.537     0.855     0.200
    40.537     1.283     0.200
    40.714     1.629     0.200
    40.760     1.160     0.200
    40.788     1.762     0.200
    40.807     1.479     0.200
    40.862     1.611     0.200
    40.867     1.594     0.200
    40.875     1.628     0.200
    40.885     1.308     0.200
    41.032     1.446     0.200
    41.036     0.865     0.200
    41.167     1.239     0.200
    41.208     0.879     0.200
    41.210     1.150     0.200
    41.217     0.742     0.200
    41.237     0.895     0.200
    41.246     1.390     0.200
    41.263     0.544     0.200
    41.267     0.695     0.200
    41.359     1.335     0.200
    41.632    -2.167     0.200
    41.561     0.926     0.200
    41.574     0.672     0.200
    41.610     0.578     0.200
    41.625     0.944     0.200
    41.653     0.854     0.200
    41.720     0.870     0.200
    41.755     1.310     0.200
    41.810     1.343     0.200
    41.908     1.036     0.200
    41.929     1.008     0.200
    41.947     0.213     0.200
    42.002     1.432     0.200
    42.023     0.146     0.200
    42.046     0.863     0.200
    42.049     1.300     0.200
    42.097     0.731     0.200
    42.138     0.919     0.200
    42.324     0.820     0.200
    42.323     0.999     0.200
    42.409     1.758     0.200
    42.438     1.121     0.200
    42.458     1.152     0.200
    42.502     1.101     0.200
    42.672    -2.430     0.200
    42.561     1.064     0.200
    42.728    -0.581     0.200
    42.728    -0.291     0.200
    42.586     1.293     0.200
    42.601     1.326     0.200
    42.842    -2.809     0.200
    42.760     1.536     0.200
    42.768     1.444     0.200
    42.814     0.845     0.200
    42.829    -0.018     0.200
    42.856     0.711     0.200
    42.866     0.667     0.200
    42.920     0.346     0.200
    42.920     0.653     0.200
    43.024     0.758     0.200
    43.042     1.233     0.200
    43.080     1.532     0.200
    43.234     1.249     0.200
    43.235     0.291     0.200
    43.258     0.565     0.200
    43.258     0.837     0.200
    43.282     1.222     0.200
    43.362     0.659     0.200
    43.419     0.325     0.200
    43.485    -0.004     0.200
    43.468     1.542     0.200
    43.583     0.891     0.200
    43.636     0.597     0.200
    43.655     1.225     0.200
    43.666     0.618     0.200
    43.708     0.926     0.200
    43.799     0.796     0.200
    43.810     0.881     0.200
    43.818     0.636     0.200
    43.842     0.124     0.200
    43.919     0.102     0.200
    43.919     0.321     0.200
    43.946     0.708     0.200
    44.030     0.908     0.200
    44.125     1.260     0.200
    44.150     0.927     0.200
    44.155     0.328     0.200
    44.229     0.665     0.200
    44.253     0.470     0.200
    44.519     0.548     0.200
    44.528     0.603     0.200
    44.552     0.619     0.200
    44.547     0.330     0.200
    44.547     0.200     0.200
    44.611     0.532     0.200
    44.666     0.778     0.200
    44.822     0.376     0.200
    44.822     0.978     0.200
    44.934     0.806     0.200
    44.934     1.034     0.200
    44.994     0.437     0.200
    45.011     0.524     0.200
    45.040     0.667     0.200
    45.150     0.369     0.200
    45.239     0.265     0.200
    45.259    -0.356     0.200
    45.371    -1.808     0.200
    45.371    -0.487     0.200
    45.358    -0.637     0.200
    45.358    -0.063     0.200
    45.394     0.746     0.200
    45.493     1.363     0.200
    45.554     0.766     0.200
    45.589     0.256     0.200
    45.891     0.656     0.200
    45.935     0.625     0.200
    46.102     1.330     0.200
    46.382     1.387     0.200
    46.451     0.494     0.200
    46.473     0.796     0.200
    46.503    -0.215     0.200
    46.732     1.546     0.200
    46.770     1.738     0.200
    46.771     1.931     0.200
    46.900     0.845     0.200
    47.251    -2.338     0.200
    47.210     0.297     0.200
    47.169     1.625     0.200
    47.168     0.277     0.200
    47.341     1.754     0.200
    47.390     1.250     0.200
    47.444     0.530     0.200
    47.603     1.270     0.200
    47.888     0.370     0.200
    48.216    -2.153     0.200
    48.583     1.742     0.200
    48.693    -1.198     0.200
    48.887     0.123     0.200
    49.303    -1.002     0.200
    49.303    -1.511     0.200
    49.303    -1.502     0.200
    49.302    -1.399     0.200
    49.276     2.010     0.200
    49.494     2.175     0.200
    49.917    -2.381     0.200
    49.918     0.111     0.200
    50.458     0.415     0.200
    50.831    -0.499     0.200
    50.920    -1.764     0.200
    50.806     0.094     0.200
    51.478     0.579     0.200
    51.478     0.832     0.200
    53.468    -1.810     0.200
    53.985     0.277     0.200
    54.249    -0.969     0.200
    54.250    -0.910     0.200
    54.250    -0.831     0.200
    54.249    -0.969     0.200
    54.225    -1.146     0.200
    54.225    -1.376     0.200
    55.285    -0.431     0.200
    55.285    -0.832     0.200
    55.285    -0.571     0.200
    55.319    -0.673     0.200
    55.335    -1.167     0.200
    55.761    -0.054     0.200
    55.761    -0.754     0.200
    55.761    -0.924     0.200
    55.864    -1.202     0.200
    56.363    -0.758     0.200
    56.423    -1.684     0.200
    56.452    -1.291     0.200
    56.734    -1.294     0.200
    57.045    -0.501     0.200
    57.223    -1.540     0.200
    58.371    -0.827     0.200
    58.391    -1.068     0.200
    59.237    -0.144     0.200
    59.350    -0.832     0.200
    60.017    -0.425     0.200
    60.055    -2.781     0.200
    60.317    -1.140     0.200
    60.317    -1.079     0.200
    60.840    -0.148     0.200
    61.302    -0.581     0.200
    61.685    -0.766     0.200
    61.882    -1.593     0.200
    62.147    -1.295     0.200
    62.074    -0.487     0.200
    62.074    -0.387     0.200
    62.239    -0.552     0.200
    62.355    -0.767     0.200
    62.403    -0.938     0.200
    63.150    -1.068     0.200
    63.300    -0.360     0.200
    63.850    -1.195     0.200
    64.019    -0.504     0.200
    64.603    -0.632     0.200
    64.603    -1.632     0.200
    64.603    -1.861     0.200
    64.830     1.037     0.200
    65.034    -1.639     0.200
    65.243    -1.095     0.200
    65.243    -2.095     0.200
    65.243    -1.604     0.200
    65.246    -1.919     0.200
    65.246    -1.319     0.200
    65.350    -0.289     0.200
    65.755    -0.307     0.200
    65.762     0.645     0.200
    65.762    -0.545     0.200
    66.403     0.830     0.200
    66.622    -1.173     0.200
    66.667    -1.458     0.200
    66.768    -0.032     0.200
    67.293    -1.541     0.200
    67.293    -1.300     0.200
    67.293    -1.041     0.200
    67.476    -0.900     0.200
    67.774    -1.681     0.200
    67.932    -0.273     0.200
    68.458    -0.571     0.200
    68.458    -1.671     0.200
    68.567    -1.387     0.200
    69.005     0.415     0.200
    69.323    -2.454     0.200
    69.413    -1.130     0.200
    69.616     0.764     0.200
    69.758    -1.041     0.200
    70.239     0.005     0.200
    70.321     0.204     0.200
    70.417    -2.086     0.200
    70.417    -1.336     0.200
    70.405    -0.010     0.200
    70.771     0.260     0.200
    70.771     0.571     0.200
    71.077     0.398     0.200
    71.157    -1.089     0.200
    71.157    -1.638     0.200
    71.111    -0.107     0.200
    71.243     0.097     0.200
    71.532    -0.733     0.200
    71.599    -1.144     0.200
    71.616    -0.136     0.200
    71.743    -1.221     0.200
    71.760    -0.256     0.200
    71.855    -0.397     0.200
    71.847    -0.046     0.200
    71.849    -0.027     0.200
    71.865    -0.954     0.200
    71.865    -0.253     0.200
    72.046    -0.340     0.200
    72.043     0.179     0.200
    72.090    -3.403     0.200
    72.063     0.104     0.200
    72.090     0.093     0.200
    72.173    -2.299     0.200
    72.279     0.161     0.200
    72.379    -0.120     0.200
    72.379    -0.330     0.200
    72.412    -2.129     0.200
    72.413     0.163     0.200
    72.453    -0.074     0.200
    72.531    -0.341     0.200
    72.593    -0.306     0.200
    72.600    -0.147     0.200
    72.632     0.159     0.200
    72.651    -0.154     0.200
    72.698     0.065     0.200
    72.705     0.738     0.200
    72.705     0.628     0.200
    72.705     0.028     0.200
    72.737    -0.064     0.200
    72.758    -0.391     0.200
    72.774     0.319     0.200
    72.816     0.064     0.200
    72.823    -0.078     0.200
    72.836     0.148     0.200
    72.923    -0.668     0.200
    72.923    -0.158     0.200
    72.923    -0.438     0.200
    72.877     0.204     0.200
    72.954    -0.355     0.200
    72.906     0.131     0.200
    73.119    -0.528     0.200
    73.085     0.072     0.200
    73.088    -0.048     0.200
    73.118    -1.323     0.200
    73.118    -1.192     0.200
    73.118    -1.723     0.200
    73.125    -1.564     0.200
    73.125    -1.704     0.200
    73.128    -1.323     0.200
    73.162    -1.884     0.200
    73.310    -1.760     0.200
    73.324     0.559     0.200
    73.289     0.065     0.200
    73.367    -0.051     0.200
    73.307    -0.041     0.200
    73.315    -0.087     0.200
    73.391    -0.132     0.200
    73.424    -0.331     0.200
    73.526    -0.529     0.200
    73.526    -0.099     0.200
    73.526    -0.829     0.200
    73.593    -0.226     0.200
    73.727    -0.108     0.200
    73.727    -0.398     0.200
    73.686     0.232     0.200
    73.715    -0.242     0.200
    73.738    -0.577     0.200
    73.738     0.023     0.200
    73.731     0.469     0.200
    73.891     0.927     0.200
    73.951    -1.321     0.200
    73.975    -0.664     0.200
    73.970    -0.135     0.200
    73.974     0.045     0.200
    73.997     0.710     0.200
    74.072    -0.131     0.200
    74.074     0.156     0.200
    74.083     0.208     0.200
    74.088     0.074     0.200
    74.092    -0.145     0.200
    74.128    -0.457     0.200
    74.128     0.242     0.200
    74.128     0.032     0.200
    74.141     0.067     0.200
    74.234     0.424     0.200
    74.297    -0.741     0.200
    74.248    -0.159     0.200
    74.260     0.276     0.200
    74.291     0.594     0.200
    74.299     0.446     0.200
    74.299    -0.153     0.200
    74.299     0.007     0.200
    74.355     0.017     0.200
    74.369    -0.162     0.200
    74.369     0.038     0.200
    74.513     0.301     0.200
    74.610    -0.062     0.200
    74.613     0.118     0.200
    74.675     0.164     0.200
    74.708    -0.032     0.200
    74.812    -0.333     0.200
    74.803     0.119     0.200
    74.814    -1.441     0.200
    74.814    -1.542     0.200
    74.854     0.124     0.200
    75.093    -0.157     0.200
    75.237    -0.087     0.200
    75.312    -0.218     0.200
    75.382     0.082     0.200
    75.393    -0.083     0.200
    75.407    -0.324     0.200
    75.460     0.118     0.200
    75.525    -0.310     0.200
    75.595     0.091     0.200
    75.655     0.139     0.200
    75.684     0.451     0.200
    75.726    -0.090     0.200
    75.726     0.810     0.200
    75.775     0.328     0.200
    75.871     2.080     0.200
    75.873    -0.153     0.200
    76.048    -0.030     0.200
    76.087     0.382     0.200
    76.108     0.229     0.200
    76.107    -0.797     0.200
    76.113    -1.000     0.200
    76.173    -0.298     0.200
    76.168     0.891     0.200
    76.188     0.773     0.200
    76.202    -0.006     0.200
    76.227    -0.348     0.200
    76.253     0.648     0.200
    76.278     0.764     0.200
    76.334    -0.132     0.200
    76.442     0.135     0.200
    76.592    -2.114     0.200
    76.635    -0.002     0.200
    76.664     0.678     0.200
    76.684    -0.216     0.200
    76.690     0.031     0.200
    76.716     0.682     0.200
    76.743     1.428     0.200
    76.761    -0.165     0.200
    76.828    -1.851     0.200
    76.847     1.142     0.200
    76.868     1.324     0.200
    77.029    -0.979     0.200
    76.967    -0.232     0.200
    76.961    -0.478     0.200
    76.963     0.592     0.200
    76.978     0.507     0.200
    77.071     0.083     0.200
    77.196    -0.830     0.200
    77.187     0.232     0.200
    77.221    -0.940     0.200
    77.294     0.929     0.200
    77.320    -0.613     0.200
    77.310     0.444     0.200
    77.358    -0.526     0.200
    77.359    -0.631     0.200
    77.359    -0.032     0.200
    77.352     0.605     0.200
    77.626     1.073     0.200
    77.653     1.324     0.200
    77.773     0.354     0.200
    77.739     0.955     0.200
    77.817     0.610     0.200
    77.852     0.012     0.200
    77.829     0.542     0.200
    77.924    -0.388     0.200
    77.874     0.691     0.200
    77.966    -0.118     0.200
    77.980    -0.000     0.200
    78.028     0.939     0.200
    78.101    -0.371     0.200
    78.139     1.617     0.200
    78.167     0.665     0.200
    78.185     0.864     0.200
    78.212    -0.484     0.200
    78.254     0.086     0.200
    78.217     1.039     0.200
    78.408    -1.169     0.200
    78.335     0.132     0.200
    78.335     0.632     0.200
    78.366    -0.339     0.200
    78.377    -0.200     0.200
    78.440    -0.044     0.200
    78.412     0.909     0.200
    78.624     0.539     0.200
    78.567     0.055     0.200
    78.589     4.235     0.200
    78.641    -0.051     0.200
    78.654    -0.425     0.200
    78.624     0.738     0.200
    78.616    -1.867     0.200
    78.699    -1.621     0.200
    78.751     0.142     0.200
    78.792     0.115     0.200
    78.925    -0.316     0.200
    78.907     2.781     0.200
    78.953     0.332     0.200
    79.053     0.185     0.200
    79.053    -0.516     0.200
    79.053    -0.666     0.200
    79.009     1.221     0.200
    79.098     0.336     0.200
    79.151    -1.851     0.200
    79.254    -0.116     0.200
    79.217     4.487     0.200
    79.372    -0.760     0.200
    79.372    -0.161     0.200
    79.332    -0.171     0.200
    79.711    -2.403     0.200
    79.742    -0.374     0.200
    79.929     1.213     0.200
    79.966     0.913     0.200
    80.069    -2.643     0.200
    80.020     0.661     0.200
    80.070     0.050     0.200
    80.142    -0.540     0.200
    80.145    -1.185     0.200
    80.316    -0.048     0.200
    80.319     0.458     0.200
    80.447     0.721     0.200
    80.471     1.051     0.200
    80.517     0.805     0.200
    80.545     0.774     0.200
    80.545     0.373     0.200
    80.632    -0.173     0.200
    80.656    -0.304     0.200
    80.968     0.261     0.200
    80.920     0.987     0.200
    81.009     0.865     0.200
    81.178    -0.388     0.200
    81.101     0.821     0.200
    81.101     1.511     0.200
    81.204     0.721     0.200
    81.240     0.484     0.200
    81.477    -0.875     0.200
    81.499     1.208     0.200
    81.647     0.626     0.200
    81.731    -0.278     0.200
    81.798     0.533     0.200
    82.173    -1.137     0.200
    82.159    -0.065     0.200
    82.194     0.051     0.200
    82.355    -0.192     0.200
    82.451    -0.092     0.200
    82.425    -0.130     0.200
    82.425    -1.200     0.200
    82.539    -0.052     0.200
    82.567     1.013     0.200
    82.567     1.301     0.200
    82.637    -1.862     0.200
    82.724    -0.615     0.200
    82.677    -0.458     0.200
    82.677    -0.958     0.200
    82.808    -0.054     0.200
    82.889    -0.474     0.200
    82.946    -0.470     0.200
    82.946    -0.670     0.200
    82.945    -0.165     0.200
    82.985    -0.571     0.200
    83.040    -0.156     0.200
    83.220    -1.187     0.200
    83.331     0.541     0.200
    83.480    -0.427     0.200
    83.826    -0.497     0.200
    83.853     0.165     0.200
    83.959    -0.549     0.200
    83.959    -0.080     0.200
    84.214    -0.979     0.200
    84.215    -2.485     0.200
    84.215    -0.985     0.200
    84.225    -0.164     0.200
    84.517    -0.813     0.200
    85.081    -1.455     0.200
    85.052     0.792     0.200
    85.211    -2.506     0.200
    86.157    -3.365     0.200
    86.778    -0.784     0.200
    86.820     0.062     0.200
    86.820     0.418     0.200
    87.465    -0.151     0.200
    87.674     2.653     0.200
    88.030    -1.159     0.200
    88.492    -0.727     0.200
    88.720    -0.379     0.200
    88.976     0.305     0.200
    89.462     0.673     0.200
    90.111    -0.198     0.200
    90.127     0.058     0.200
    90.494    -0.991     0.200
    90.750    -0.525     0.200
    91.887     0.281     0.200
    91.887    -0.219     0.200
    92.206    -0.391     0.200
    92.842    -0.789     0.200
    94.821    -2.327     0.200
    97.478    -0.905     0.200
    98.846    -2.447     0.200
    19.937     0.699     0.200
    22.567    -0.226     0.200
    24.199     1.712     0.200
    28.245    -0.942     0.200
    28.397    -3.097     0.200
    28.907     2.154     0.200
    30.466     1.398     0.200
    33.515     0.389     0.200
    34.546    -1.671     0.200
    37.924    -3.148     0.200
    37.924    -2.836     0.200
    43.582     1.556     0.200
    50.997    -1.511     0.200
    54.297    -1.141     0.200
    55.374     0.458     0.200
    56.820    -0.783     0.200
    56.820    -1.552     0.200
    57.132    -0.391     0.200
    60.408    -1.177     0.200
    60.408    -0.774     0.200
    60.408    -1.005     0.200
    60.915    -0.934     0.200
    62.138    -0.694     0.200
    62.138    -0.296     0.200
    62.427    -0.629     0.200
    62.427    -0.930     0.200
    63.937    -1.146     0.200
    64.689    -1.576     0.200
    64.689    -1.236     0.200
    65.332    -1.357     0.200
    67.383    -1.398     0.200
    67.383    -1.101     0.200
    67.383    -1.370     0.200
    68.535    -1.847     0.200
    70.504    -1.207     0.200
    71.245    -1.069     0.200
    72.147     0.560     0.200
    73.013    -0.394     0.200
    73.192    -1.054     0.200
    73.192    -1.382     0.200
    74.141     0.773     0.200
    74.413    -0.211     0.200
    74.432    -0.023     0.200
    74.763    -0.144     0.200
    74.909     0.714     0.200
    75.148    -0.465     0.200
    75.740     0.932     0.200
    82.246    -0.325     0.200
    82.539    -0.053     0.200
    82.627    -0.011     0.200
    82.811    -0.573     0.200
    82.896    -0.414     0.200
    82.978    -0.733     0.200
    83.034    -0.025     0.200
    83.034    -0.430     0.200
    83.034    -0.629     0.200
    83.073    -0.627     0.200
    83.611    -0.501     0.200
    84.036    -0.789     0.200
    84.596    -1.119     0.200
    84.596    -1.017     0.200
    27.244    -0.902     0.200
    28.296    -1.863     0.200
    56.576    -0.343     0.200
    59.587    -0.454     0.200
    66.597    -0.940     0.200
    14.329     4.282     0.200
    19.302     0.090     0.200
    19.430    -0.484     0.200
    19.430    -1.046     0.200
    19.823     0.294     0.200
    19.823     0.572     0.200
    20.779     2.286     0.200
    22.026     3.350     0.200
    22.589     1.317     0.200
    22.912     0.132     0.200
    23.491     1.155     0.200
    23.655     1.107     0.200
    23.710     1.507     0.200
    23.782     0.643     0.200
    23.782    -0.193     0.200
    23.800    -1.429     0.200
    24.265     1.488     0.200
    24.857     1.551     0.200
    24.947     0.708     0.200
    25.250     1.206     0.200
    25.579     1.502     0.200
    25.878     1.351     0.200
    26.014    -1.371     0.200
    26.014    -0.519     0.200
    26.077     1.495     0.200
    26.314     1.269     0.200
    26.584    -0.356     0.200
    26.653     0.996     0.200
    26.710     2.203     0.200
    26.910     0.469     0.200
    26.910    -0.332     0.200
    27.357    -0.939     0.200
    27.521     1.381     0.200
    27.721     0.709     0.200
    27.755     0.210     0.200
    27.755     0.589     0.200
    27.766     1.355     0.200
    27.794     1.247     0.200
    27.908     0.957     0.200
    28.177     0.947     0.200
    28.272     1.368     0.200
    28.306     1.203     0.200
    28.370     1.241     0.200
    28.370     1.639     0.200
    28.400     0.694     0.200
    28.759     0.950     0.200
    28.864     0.939     0.200
    28.998     1.786     0.200
    29.194     1.437     0.200
    29.255     2.461     0.200
    29.267     1.567     0.200
    29.580     1.184     0.200
    29.588     1.939     0.200
    29.739     3.411     0.200
    29.739     2.950     0.200
    29.797     2.126     0.200
    29.806     1.415     0.200
    29.951     0.782     0.200
    30.008     0.040     0.200
    30.015     1.569     0.200
    30.037     1.801     0.200
    30.072     2.204     0.200
    30.177     1.145     0.200
    30.280     1.020     0.200
    30.370     1.808     0.200
    30.385     2.114     0.200
    30.394     1.673     0.200
    30.452     1.655     0.200
    30.670     1.384     0.200
    30.760     1.518     0.200
    30.782     2.625     0.200
    30.805     2.301     0.200
    30.849     1.500     0.200
    30.914     1.531     0.200
    31.036     1.020     0.200
    31.167     1.741     0.200
    31.177     2.136     0.200
    31.313     1.163     0.200
    31.317     1.925     0.200
    31.413     1.458     0.200
    31.413     1.307     0.200
    31.519     0.999     0.200
    31.530     2.366     0.200
    31.666     1.498     0.200
    31.670     1.348     0.200
    31.676     1.097     0.200
    31.681     1.897     0.200
    31.739     1.424     0.200
    31.739     1.807     0.200
    31.755     2.278     0.200
    31.842     1.644     0.200
    31.877     1.207     0.200
    31.876     1.245     0.200
    31.937     1.849     0.200
    31.979     2.471     0.200
    32.049     1.587     0.200
    32.089     1.768     0.200
    32.102     2.119     0.200
    32.137     1.522     0.200
    32.168     1.922     0.200
    32.205     1.999     0.200
    32.209     1.699     0.200
    32.281     1.853     0.200
    32.370    -1.630     0.200
    32.370    -1.990     0.200
    32.543     1.496     0.200
    32.621     1.342     0.200
    32.634     1.057     0.200
    32.643     1.840     0.200
    32.696     1.011     0.200
    32.846     1.395     0.200
    32.860     0.941     0.200
    33.074     1.618     0.200
    33.151     1.990     0.200
    33.193     1.457     0.200
    33.204     1.443     0.200
    33.220     1.658     0.200
    33.262     1.928     0.200
    33.270     1.676     0.200
    33.320     1.390     0.200
    33.322     1.648     0.200
    33.380     1.955     0.200
    33.415     1.154     0.200
    33.414     1.455     0.200
    33.428     1.133     0.200
    33.438     1.550     0.200
    33.442     1.381     0.200
    33.484     1.726     0.200
    33.548     0.856     0.200
    33.550     1.609     0.200
    33.600     0.557     0.200
    33.624     1.445     0.200
    33.635     1.752     0.200
    33.838     1.024     0.200
    33.868     1.596     0.200
    33.921     0.991     0.200
    33.924     1.951     0.200
    33.948     1.837     0.200
    34.014     1.304     0.200
    34.014     1.523     0.200
    34.116     1.878     0.200
    34.231     1.472     0.200
    34.317     1.086     0.200
    34.382     1.548     0.200
    34.434     1.737     0.200
    34.581     1.584     0.200
    34.598     0.939     0.200
    34.628     1.351     0.200
    34.778     1.791     0.200
    34.860     1.490     0.200
    34.860     2.003     0.200
    34.899     1.520     0.200
    34.997     1.434     0.200
    35.072     1.353     0.200
    35.082     1.440     0.200
    35.146     2.225     0.200
    35.159     1.781     0.200
    35.174     1.622     0.200
    35.184     1.363     0.200
    35.185     0.948     0.200
    35.264     1.517     0.200
    35.336     1.253     0.200
    35.338     1.835     0.200
    35.364     1.448     0.200
    35.498     2.017     0.200
    35.608     1.724     0.200
    35.687     1.192     0.200
    35.751     1.009     0.200
    35.804     2.131     0.200
    35.810     1.981     0.200
    35.964     1.583     0.200
    36.009     1.664     0.200
    36.038    -1.619     0.200
    36.029     1.872     0.200
    36.043     1.047     0.200
    36.114     0.521     0.200
    36.270    -1.202     0.200
    36.402     1.276     0.200
    36.455     1.797     0.200
    36.466     1.811     0.200
    36.471     1.974     0.200
    36.524     1.551     0.200
    36.541     1.889     0.200
    36.565     1.707     0.200
    36.619     1.134     0.200
    36.711     1.991     0.200
    36.882     2.015     0.200
    36.972     1.588     0.200
    37.025     2.058     0.200
    37.047     2.230     0.200
    37.130     1.590     0.200
    37.149     1.755     0.200
    37.149     2.345     0.200
    37.216     1.749     0.200
    37.339     2.200     0.200
    37.444     2.113     0.200
    37.461    -0.417     0.200
    37.516     1.867     0.200
    37.532     2.094     0.200
    37.588     2.283     0.200
    37.825     1.606     0.200
    37.845     1.586     0.200
    37.923     1.793     0.200
    37.960     2.024     0.200
    38.191     1.328     0.200
    38.237     1.616     0.200
    38.252    -0.386     0.200
    38.252     1.595     0.200
    38.303     1.107     0.200
    38.349     1.593     0.200
    38.420     0.650     0.200
    38.420     2.905     0.200
    38.628     1.480     0.200
    38.734     1.106     0.200
    38.809     1.751     0.200
    38.895     1.899     0.200
    38.897     1.922     0.200
    39.139     2.013     0.200
    39.151     1.992     0.200
    39.161     1.843     0.200
    39.231     1.786     0.200
    39.336     1.562     0.200
    39.369     0.883     0.200
    39.413     1.647     0.200
    39.428     1.708     0.200
    39.459     1.028     0.200
    39.594     1.755     0.200
    39.600     1.482     0.200
    39.704     1.649     0.200
    39.727     1.679     0.200
    39.858     1.140     0.200
    39.880     1.161     0.200
    39.919     1.946     0.200
    39.940     1.474     0.200
    39.979     1.125     0.200
    40.009     1.976     0.200
    40.109     1.370     0.200
    40.157     1.892     0.200
    40.190     1.869     0.200
    40.190     2.255     0.200
    40.231     1.007     0.200
    40.233     1.941     0.200
    40.406     0.924     0.200
    40.409     1.935     0.200
    40.426     1.612     0.200
    40.557     1.535     0.200
    40.609     1.806     0.200
    40.633     1.207     0.200
    40.667     0.645     0.200
    40.702     1.182     0.200
    40.747    -0.522     0.200
    40.745     1.705     0.200
    40.792     0.617     0.200
    40.819     1.498     0.200
    40.843     1.525     0.200
    41.195     0.535     0.200
    41.349    -0.313     0.200
    41.379     1.500     0.200
    41.411     1.293     0.200
    41.486     1.193     0.200
    41.541     1.166     0.200
    41.541     1.037     0.200
    41.612    -1.658     0.200
    41.636     1.716     0.200
    41.722    -0.161     0.200
    41.837     1.058     0.200
    41.940     0.365     0.200
    42.034     0.977     0.200
    42.051     1.187     0.200
    42.134     1.127     0.200
    42.188     1.154     0.200
    42.316     0.800     0.200
    42.350     1.229     0.200
    42.427    -0.288     0.200
    42.442     0.971     0.200
    42.448     0.866     0.200
    42.569     1.146     0.200
    42.645     1.170     0.200
    42.758     0.945     0.200
    42.787     0.815     0.200
    42.822     0.961     0.200
    42.827     1.128     0.200
    42.918     0.292     0.200
    42.969     1.238     0.200
    42.989     1.896     0.200
    43.058     1.126     0.200
    43.107     0.961     0.200
    43.116     0.828     0.200
    43.215     1.002     0.200
    43.395     0.282     0.200
    43.549     0.806     0.200
    43.559     0.895     0.200
    43.578     0.722     0.200
    43.622     1.081     0.200
    43.624     0.173     0.200
    43.631     0.619     0.200
    43.724     1.255     0.200
    43.745     0.523     0.200
    43.780     0.799     0.200
    43.922     1.223     0.200
    44.025     1.165     0.200
    44.039     0.704     0.200
    44.118     0.986     0.200
    44.126     0.516     0.200
    44.183     1.501     0.200
    44.193     1.156     0.200
    44.200     0.917     0.200
    44.394     0.719     0.200
    44.406     0.696     0.200
    44.419     0.809     0.200
    44.496     0.629     0.200
    44.547    -0.560     0.200
    44.585     0.661     0.200
    44.590     1.397     0.200
    44.662     0.628     0.200
    44.784     0.689     0.200
    44.812     0.013     0.200
    44.830     1.065     0.200
    44.852     0.592     0.200
    44.862     0.491     0.200
    44.870     0.628     0.200
    44.871     0.805     0.200
    44.904     1.268     0.200
    45.042     1.154     0.200
    45.062     0.927     0.200
    45.092     0.924     0.200
    45.139     0.334     0.200
    45.264     0.613     0.200
    45.327     0.638     0.200
    45.398     0.900     0.200
    45.464     0.549     0.200
    45.521     1.096     0.200
    45.572     0.206     0.200
    45.714     0.753     0.200
    45.823     0.292     0.200
    45.835     0.496     0.200
    45.835     0.738     0.200
    45.947     0.821     0.200
    45.975     0.471     0.200
    46.067     0.377     0.200
    46.309     0.036     0.200
    46.346     0.961     0.200
    46.403     1.311     0.200
    46.554     0.870     0.200
    46.631     0.772     0.200
    46.721     1.082     0.200
    46.999     0.395     0.200
    46.978     0.767     0.200
    47.171     1.049     0.200
    47.520     1.417     0.200
    47.533     1.188     0.200
    47.749     1.875     0.200
    47.793     1.181     0.200
    48.288     1.131     0.200
    48.380     2.178     0.200
    48.435     2.205     0.200
    48.566    -1.379     0.200
    48.566    -1.106     0.200
    48.566    -0.225     0.200
    48.614     2.413     0.200
    48.825     2.818     0.200
    49.183     2.221     0.200
    49.580     2.345     0.200
    49.636    -1.069     0.200
    49.988     1.868     0.200
    50.085    -0.486     0.200
    51.848    -2.874     0.200
    52.069    -1.832     0.200
    53.203    -0.123     0.200
    53.203    -0.124     0.200
    53.449    -0.776     0.200
    53.570    -1.266     0.200
    53.927    -1.396     0.200
    53.927    -1.393     0.200
    54.604    -0.878     0.200
    55.015    -0.695     0.200
    55.317     0.129     0.200
    56.985     0.314     0.200
    57.967    -3.884     0.200
    58.250    -1.538     0.200
    58.250    -1.456     0.200
    58.519    -0.623     0.200
    58.658    -2.393     0.200
    59.080    -3.010     0.200
    59.526    -2.579     0.200
    60.017    -1.145     0.200
    60.017    -1.216     0.200
    60.140    -0.427     0.200
    60.196    -1.991     0.200
    60.197    -1.399     0.200
    60.351    -2.826     0.200
    61.260    -0.991     0.200
    61.637    -1.830     0.200
    62.009    -0.424     0.200
    62.386    -2.738     0.200
    62.386    -2.508     0.200
    62.941    -2.425     0.200
    62.941    -2.323     0.200
    62.941    -2.136     0.200
    63.079    -1.738     0.200
    63.079    -2.238     0.200
    63.189    -1.264     0.200
    63.213    -1.724     0.200
    63.880    -0.015     0.200
    64.929    -0.458     0.200
    65.265    -1.829     0.200
    65.265    -1.731     0.200
    65.476    -0.695     0.200
    65.995     1.170     0.200
    66.252    -1.670     0.200
    66.976    -0.279     0.200
    67.620    -1.840     0.200
    68.079    -0.653     0.200
    68.324    -0.252     0.200
    68.382    -0.518     0.200
    68.551    -0.596     0.200
    68.711    -0.463     0.200
    68.956    -1.680     0.200
    68.956    -2.610     0.200
    69.053     0.017     0.200
    69.123    -0.712     0.200
    69.320    -0.431     0.200
    69.565    -1.111     0.200
    69.628    -0.607     0.200
    69.667    -0.216     0.200
    69.790    -0.601     0.200
    69.815    -0.777     0.200
    69.869    -4.407     0.200
    69.887    -0.520     0.200
    69.957    -3.146     0.200
    70.029    -0.386     0.200
    70.096    -0.299     0.200
    70.112    -0.766     0.200
    70.136    -0.441     0.200
    70.196    -3.305     0.200
    70.267    -1.039     0.200
    70.321    -0.515     0.200
    70.354    -0.470     0.200
    70.455    -0.288     0.200
    70.512    -0.535     0.200
    70.512    -0.835     0.200
    70.579    -0.337     0.200
    70.654    -0.793     0.200
    70.656    -0.210     0.200
    70.710    -0.235     0.200
    70.736     0.461     0.200
    70.736     0.109     0.200
    70.788    -0.405     0.200
    70.829    -0.456     0.200
    70.854    -0.709     0.200
    70.873    -0.521     0.200
    70.877    -0.848     0.200
    70.942    -1.943     0.200
    70.942    -2.142     0.200
    70.949    -1.985     0.200
    70.949    -2.216     0.200
    70.953    -2.294     0.200
    70.954    -0.510     0.200
    70.987    -2.230     0.200
    71.005    -0.420     0.200
    71.003    -0.406     0.200
    71.041    -0.638     0.200
    71.156     0.569     0.200
    71.245    -0.572     0.200
    71.262    -0.175     0.200
    71.277    -0.063     0.200
    71.293    -0.060     0.200
    71.307    -0.445     0.200
    71.314    -1.488     0.200
    71.448    -0.391     0.200
    71.448    -1.613     0.200
    71.607    -0.149     0.200
    71.620    -0.724     0.200
    71.642    -0.155     0.200
    71.648    -0.894     0.200
    71.648    -0.793     0.200
    71.735    -0.217     0.200
    71.771    -0.031     0.200
    71.832    -1.896     0.200
    71.953     0.081     0.200
    71.968    -0.310     0.200
    71.968    -0.412     0.200
    71.995    -0.471     0.200
    71.995    -0.772     0.200
    71.995    -0.369     0.200
    72.002    -0.614     0.200
    72.024    -0.841     0.200
    72.024    -1.040     0.200
    72.024    -0.321     0.200
    72.025    -0.545     0.200
    72.060     0.140     0.200
    72.105    -0.227     0.200
    72.113    -0.276     0.200
    72.127    -0.061     0.200
    72.151     0.495     0.200
    72.169    -0.210     0.200
    72.180    -1.674     0.200
    72.180    -1.572     0.200
    72.284    -0.592     0.200
    72.284    -0.193     0.200
    72.309    -0.738     0.200
    72.309    -0.238     0.200
    72.309    -0.442     0.200
    72.309    -0.551     0.200
    72.318    -0.291     0.200
    72.318    -0.393     0.200
    72.391    -0.328     0.200
    72.600    -0.071     0.200
    72.620    -1.188     0.200
    72.639    -0.504     0.200
    72.639    -0.405     0.200
    72.683    -0.760     0.200
    72.691    -0.608     0.200
    72.779    -0.332     0.200
    72.779    -0.431     0.200
    72.805    -0.282     0.200
    72.930    -0.326     0.200
    72.986    -1.250     0.200
    73.076    -0.986     0.200
    73.095    -0.193     0.200
    73.173    -0.654     0.200
    73.325    -0.451     0.200
    73.342    -0.452     0.200
    73.351    -0.602     0.200
    73.388    -0.204     0.200
    73.386    -0.606     0.200
    73.492    -0.133     0.200
    73.492    -0.731     0.200
    73.491    -0.523     0.200
    73.509    -0.174     0.200
    73.575    -0.217     0.200
    73.577    -0.126     0.200
    73.617    -0.460     0.200
    73.617     0.337     0.200
    73.617    -0.062     0.200
    73.630    -0.169     0.200
    73.677    -0.016     0.200
    73.707     0.088     0.200
    73.727    -0.009     0.200
    73.829     2.200     0.200
    73.823    -0.069     0.200
    73.859     0.080     0.200
    73.861    -0.091     0.200
    74.015     0.218     0.200
    74.022    -1.209     0.200
    74.039    -0.142     0.200
    74.043     0.294     0.200
    74.051    -0.997     0.200
    74.073     0.177     0.200
    74.080     0.234     0.200
    74.095     0.151     0.200
    74.138    -0.497     0.200
    74.186     0.117     0.200
    74.256    -0.228     0.200
    74.299    -0.500     0.200
    74.340    -0.672     0.200
    74.467     1.089     0.200
    74.513    -0.805     0.200
    74.568    -0.093     0.200
    74.574    -0.524     0.200
    74.622     0.042     0.200
    74.680     0.060     0.200
    74.705    -0.354     0.200
    74.704     0.221     0.200
    74.796    -0.312     0.200
    74.823    -0.468     0.200
    74.887     0.765     0.200
    74.908     0.946     0.200
    75.159    -1.103     0.200
    75.257    -0.059     0.200
    75.263    -0.492     0.200
    75.263    -0.793     0.200
    75.279    -1.389     0.200
    75.363     0.033     0.200
    75.429    -0.838     0.200
    75.596     2.599     0.200
    75.626    -0.873     0.200
    75.668     0.787     0.200
    75.699    -1.290     0.200
    75.758    -0.662     0.200
    75.805    -1.292     0.200
    75.820    -0.778     0.200
    75.901     0.158     0.200
    75.979    -0.581     0.200
    76.049     0.021     0.200
    76.144     0.080     0.200
    76.180    -1.021     0.200
    76.200    -1.137     0.200
    76.228    -0.896     0.200
    76.235    -0.331     0.200
    76.246     0.606     0.200
    76.276     0.633     0.200
    76.294    -0.364     0.200
    76.276    -1.524     0.200
    76.324     0.561     0.200
    76.354    -0.808     0.200
    76.366    -0.173     0.200
    76.431     0.158     0.200
    76.466    -0.940     0.200
    76.484    -0.839     0.200
    76.497    -0.213     0.200
    76.563    -0.382     0.200
    76.603    -0.210     0.200
    76.715    -0.243     0.200
    76.828    -0.978     0.200
    76.906     1.082     0.200
    76.906     0.582     0.200
    77.003    -0.063     0.200
    77.029    -0.605     0.200
    77.180    -0.352     0.200
    77.200    -0.664     0.200
    78.090    -0.208     0.200
    78.284    -0.542     0.200
    78.780    -0.005     0.200
    78.807    -0.673     0.200
    78.952    -0.751     0.200
    78.975    -0.872     0.200
    79.044    -0.952     0.200
    79.416    -0.705     0.200
    80.060    -0.648     0.200
    80.404     0.096     0.200
    80.548    -1.676     0.200
    80.655     0.153     0.200
    80.752     0.435     0.200
    80.968    -0.314     0.200
    81.003     0.097     0.200
    81.071    -0.158     0.200
    81.108     0.044     0.200
    81.146    -0.257     0.200
    81.146    -0.455     0.200
    81.214    -0.614     0.200
    81.234     0.078     0.200
    81.632    -0.123     0.200
    81.655    -0.244     0.200
    81.688    -0.419     0.200
    81.757    -0.673     0.200
    81.758    -0.335     0.200
    82.102     0.264     0.200
    82.823    -1.534     0.200
    83.130    -1.028     0.200
    83.130    -1.020     0.200
    84.855    -0.105     0.200
    88.444     1.212     0.200
    92.512    -0.452     0.200
    92.689    -0.564     0.200
    96.573    -0.400     0.200
    97.927    -1.618     0.200
    19.172    -0.433     0.200
    19.943    -0.454     0.200
    26.152    -1.803     0.200
    26.518    -0.926     0.200
    27.512    -1.354     0.200
    31.259     1.697     0.200
    36.167    -2.543     0.200
    41.819    -2.091     0.200
    52.081    -2.184     0.200
    53.357    -1.778     0.200
    53.357    -1.782     0.200
    58.353    -1.556     0.200
    83.276    -1.242     0.200
    19.443    -0.356     0.200
    19.443    -1.027     0.200
    20.146    -0.228     0.200
    21.093    -0.678     0.200
    21.093    -1.749     0.200
    21.335     1.921     0.200
    21.536     2.356     0.200
    21.907     1.683     0.200
    21.948     1.710     0.200
    22.031     1.886     0.200
    22.115     1.715     0.200
    22.157     0.915     0.200
    22.167     1.648     0.200
    22.197     1.017     0.200
    22.258     1.189     0.200
    22.313     1.271     0.200
    22.498     1.786     0.200
    22.553     1.625     0.200
    23.062     1.021     0.200
    23.071     1.927     0.200
    23.077     1.407     0.200
    23.152     1.061     0.200
    23.171     0.473     0.200
    23.261     0.939     0.200
    23.514     0.811     0.200
    23.514     0.436     0.200
    23.580     1.181     0.200
    23.754     1.765     0.200
    24.128     2.166     0.200
    24.157     2.349     0.200
    24.165     2.576     0.200
    24.362     1.434     0.200
    24.366     1.348     0.200
    24.545     2.520     0.200
    24.818     1.214     0.200
    24.851     1.253     0.200
    24.889     1.807     0.200
    24.927     2.616     0.200
    24.927     2.069     0.200
    25.028     1.371     0.200
    25.110     1.809     0.200
    25.119     2.716     0.200
    25.325     2.131     0.200
    25.365     1.114     0.200
    25.445     0.797     0.200
    25.499     1.557     0.200
    25.536     1.431     0.200
    25.660     1.368     0.200
    25.879     1.970     0.200
    26.017     2.098     0.200
    26.101     1.065     0.200
    26.493     2.016     0.200
    27.001    -2.563     0.200
    27.253    -0.120     0.200
    27.724    -1.745     0.200
    27.681     0.338     0.200
    27.721     0.452     0.200
    27.878     1.137     0.200
    27.945     1.526     0.200
    28.077    -0.900     0.200
    28.077    -0.697     0.200
    28.195     0.461     0.200
    28.236     0.961     0.200
    28.392     1.095     0.200
    28.665     1.189     0.200
    28.680     0.429     0.200
    29.079     1.962     0.200
    29.117     1.633     0.200
    29.142     1.208     0.200
    29.252     1.199     0.200
    29.430     1.488     0.200
    29.468     3.229     0.200
    29.468     2.471     0.200
    29.475     1.231     0.200
    29.479     0.714     0.200
    29.597     2.300     0.200
    29.605     2.160     0.200
    29.631     1.656     0.200
    29.758     1.601     0.200
    29.782     1.679     0.200
    29.898     1.576     0.200
    29.968     2.076     0.200
    30.034     0.595     0.200
    30.156     1.016     0.200
    30.227     1.471     0.200
    30.312     1.065     0.200
    30.709     1.445     0.200
    30.947     0.862     0.200
    31.073     1.399     0.200
    31.073     1.032     0.200
    31.093     1.626     0.200
    31.102     1.168     0.200
    31.188     2.256     0.200
    31.246     0.939     0.200
    31.450     1.356     0.200
    31.510     1.393     0.200
    31.534     1.360     0.200
    31.639     1.344     0.200
    31.645     1.395     0.200
    31.695     1.990     0.200
    31.716     1.227     0.200
    31.784     1.256     0.200
    31.863     1.361     0.200
    31.899     1.399     0.200
    31.984     1.490     0.200
    32.028     1.793     0.200
    32.250     1.946     0.200
    32.347     1.684     0.200
    32.446     1.484     0.200
    32.532     2.215     0.200
    32.823     2.166     0.200
    32.859     2.371     0.200
    32.867     1.653     0.200
    32.870     1.843     0.200
    32.901     1.354     0.200
    33.135     1.586     0.200
    33.135     2.063     0.200
    33.155     1.873     0.200
    33.193     1.616     0.200
    33.209     1.619     0.200
    33.219     1.720     0.200
    33.255     2.036     0.200
    33.251     1.395     0.200
    33.258     2.681     0.200
    33.300     1.700     0.200
    33.393     1.054     0.200
    33.432     1.779     0.200
    33.451     0.889     0.200
    33.642     1.262     0.200
    33.640     1.247     0.200
    33.640     1.067     0.200
    33.642     1.963     0.200
    33.813    -1.456     0.200
    33.813    -2.073     0.200
    33.803     1.381     0.200
    33.949    -0.165     0.200
    34.230     0.392     0.200
    34.233     1.764     0.200
    34.262     2.132     0.200
    34.274     0.996     0.200
    34.339     1.416     0.200
    34.446     1.950     0.200
    34.512     1.701     0.200
    34.537     1.602     0.200
    34.558     1.859     0.200
    34.808     1.493     0.200
    34.825     1.496     0.200
    34.843     1.572     0.200
    34.868     0.999     0.200
    34.951     1.272     0.200
    34.986     1.054     0.200
    35.005     1.832     0.200
    35.193     1.219     0.200
    35.299     0.822     0.200
    35.327     0.951     0.200
    35.408     1.737     0.200
    35.480     1.710     0.200
    35.719     1.104     0.200
    35.806     1.424     0.200
    36.127     1.902     0.200
    36.147     1.928     0.200
    36.229     1.691     0.200
    36.226     2.366     0.200
    36.238     1.942     0.200
    36.268     2.146     0.200
    36.287     2.244     0.200
    36.293     1.797     0.200
    36.341     1.974     0.200
    36.357     1.450     0.200
    36.447     1.491     0.200
    36.498     1.324     0.200
    36.532     1.263     0.200
    36.595     1.453     0.200
    36.671     1.888     0.200
    36.700     1.964     0.200
    36.699     2.067     0.200
    36.910     2.063     0.200
    37.164    -3.048     0.200
    37.164    -2.368     0.200
    37.060     2.332     0.200
    37.074     2.365     0.200
    37.130     1.924     0.200
    37.206     2.095     0.200
    37.408     1.977     0.200
    37.449     2.059     0.200
    37.479     1.672     0.200
    37.482     2.107     0.200
    37.482     1.811     0.200
    37.488     2.051     0.200
    37.520     1.938     0.200
    37.533     1.138     0.200
    37.548     1.908     0.200
    37.632    -1.133     0.200
    37.693     1.453     0.200
    37.875     1.932     0.200
    37.880     1.653     0.200
    37.911     1.986     0.200
    37.963     2.279     0.200
    37.988     1.845     0.200
    38.028     1.831     0.200
    38.216     0.969     0.200
    38.254     0.790     0.200
    38.289     1.645     0.200
    38.293     1.605     0.200
    38.403     1.567     0.200
    38.407     1.914     0.200
    38.423     2.223     0.200
    38.423     2.808     0.200
    38.467     1.119     0.200
    38.464     1.620     0.200
    38.479     0.886     0.200
    38.714     1.138     0.200
    38.731     1.468     0.200
    38.781     1.761     0.200
    38.785     2.039     0.200
    38.819     0.836     0.200
    38.845     1.428     0.200
    38.894     0.904     0.200
    38.905     1.440     0.200
    39.131     1.330     0.200
    39.208     1.667     0.200
    39.248     1.108     0.200
    39.251     1.162     0.200
    39.261     1.382     0.200
    39.285     1.599     0.200
    39.281     1.721     0.200
    39.307     1.279     0.200
    39.413     2.055     0.200
    39.458     2.099     0.200
    39.549     1.791     0.200
    39.594     1.885     0.200
    39.617     1.602     0.200
    39.648     1.496     0.200
    39.691     1.689     0.200
    39.718     0.902     0.200
    39.745     1.905     0.200
    39.749     1.391     0.200
    39.875     0.950     0.200
    40.041     1.273     0.200
    40.110     0.727     0.200
    40.134     1.457     0.200
    40.142     1.725     0.200
    40.147     1.420     0.200
    40.197     1.332     0.200
    40.242     1.787     0.200
    40.358     1.405     0.200
    40.373     1.215     0.200
    40.463     1.377     0.200
    40.472     1.097     0.200
    40.520     0.879     0.200
    40.605     1.468     0.200
    40.624     1.393     0.200
    40.988     0.945     0.200
    41.022     1.737     0.200
    41.027     1.455     0.200
    41.027     1.119     0.200
    41.132     1.135     0.200
    41.132     0.682     0.200
    41.347     0.878     0.200
    41.357     0.898     0.200
    41.367     1.216     0.200
    41.397     0.963     0.200
    41.460     1.036     0.200
    41.740     1.283     0.200
    41.807     0.516     0.200
    42.125     0.070     0.200
    42.165     1.385     0.200
    42.169     1.325     0.200
    42.211     1.108     0.200
    42.247     1.152     0.200
    42.321     1.199     0.200
    42.537     0.759     0.200
    42.578     1.285     0.200
    42.653     1.462     0.200
    42.671     1.281     0.200
    42.901     0.794     0.200
    43.043    -0.273     0.200
    43.187     0.818     0.200
    43.297     0.030     0.200
    43.297    -0.072     0.200
    43.411     0.440     0.200
    43.519    -1.263     0.200
    43.469     0.959     0.200
    43.622     0.911     0.200
    43.848     0.095     0.200
    43.844     0.821     0.200
    43.844     0.961     0.200
    43.850     0.356     0.200
    43.962     0.683     0.200
    44.081     0.619     0.200
    44.012     0.510     0.200
    44.190     0.971     0.200
    44.208     0.877     0.200
    44.248     0.437     0.200
    44.276     1.387     0.200
    44.408     0.359     0.200
    44.411     0.746     0.200
    44.413     0.693     0.200
    44.710     0.703     0.200
    44.728     0.652     0.200
    44.748     0.623     0.200
    44.830     0.797     0.200
    44.860     0.843     0.200
    45.115     0.765     0.200
    45.133     0.675     0.200
    45.200     0.851     0.200
    45.269     0.442     0.200
    45.420     0.855     0.200
    45.420     0.457     0.200
    45.526    -1.213     0.200
    45.526    -0.338     0.200
    45.586     0.371     0.200
    45.597     0.570     0.200
    45.640    -0.077     0.200
    45.689     0.220     0.200
    45.845     0.330     0.200
    46.035    -2.415     0.200
    45.982     0.645     0.200
    46.149     0.637     0.200
    46.191     0.675     0.200
    46.375     1.059     0.200
    46.484     0.611     0.200
    46.555     0.406     0.200
    46.708     0.948     0.200
    47.059     0.966     0.200
    47.076     1.178     0.200
    47.337     1.687     0.200
    47.583     0.779     0.200
    47.943     1.791     0.200
    47.966     1.828     0.200
    48.742    -1.275     0.200
    48.741    -1.842     0.200
    50.279    -1.703     0.200
    51.935     0.602     0.200
    53.639    -1.030     0.200
    53.581    -1.403     0.200
    53.639    -1.031     0.200
    53.801    -1.407     0.200
    54.614    -1.041     0.200
    54.614    -0.564     0.200
    55.301    -0.712     0.200
    55.301    -0.501     0.200
    55.693    -0.031     0.200
    55.751    -1.247     0.200
    56.373    -0.334     0.200
    58.872    -0.883     0.200
    59.357    -0.944     0.200
    59.410    -3.904     0.200
    59.668    -1.183     0.200
    59.668    -0.886     0.200
    60.391    -0.547     0.200
    60.789    -0.764     0.200
    61.258    -0.849     0.200
    61.322    -1.279     0.200
    61.727    -1.312     0.200
    61.727    -1.132     0.200
    61.930    -1.160     0.200
    62.073    -4.137     0.200
    63.271    -0.928     0.200
    64.030    -1.734     0.200
    64.030    -1.508     0.200
    64.391    -1.500     0.200
    64.624    -1.232     0.200
    64.624    -1.099     0.200
    64.922    -0.567     0.200
    65.952    -0.935     0.200
    66.014    -1.334     0.200
    66.637    -1.249     0.200
    66.812    -1.138     0.200
    67.265    -0.221     0.200
    67.977    -1.318     0.200
    69.350    -1.078     0.200
    70.081    -0.577     0.200
    70.565    -1.171     0.200
    70.752     0.014     0.200
    70.808    -0.722     0.200
    71.523    -0.250     0.200
    71.523    -0.851     0.200
    71.580    -3.589     0.200
    71.675    -1.969     0.200
    71.764    -0.401     0.200
    71.807    -0.560     0.200
    71.913    -2.597     0.200
    72.031    -0.469     0.200
    72.031    -0.609     0.200
    72.057    -0.364     0.200
    72.144    -0.480     0.200
    72.194    -0.378     0.200
    72.274     0.175     0.200
    72.274     0.440     0.200
    72.308    -0.070     0.200
    72.290    -0.851     0.200
    72.362    -0.188     0.200
    72.408    -0.554     0.200
    72.472     0.041     0.200
    72.515    -1.193     0.200
    72.546    -0.784     0.200
    72.586    -0.522     0.200
    72.617    -0.606     0.200
    72.675    -1.663     0.200
    72.675    -2.147     0.200
    72.682    -1.689     0.200
    72.682    -1.431     0.200
    72.685    -2.091     0.200
    72.719     0.345     0.200
    72.719    -1.566     0.200
    72.723    -0.235     0.200
    72.723    -0.837     0.200
    72.879     0.050     0.200
    72.879    -0.059     0.200
    72.957    -0.526     0.200
    72.962    -0.454     0.200
    72.981     0.036     0.200
    73.026    -0.227     0.200
    73.081     0.141     0.200
    73.081    -0.008     0.200
    73.144     0.860     0.200
    73.342    -0.196     0.200
    73.369     0.044     0.200
    73.588     0.785     0.200
    73.660    -0.567     0.200
    73.693    -0.568     0.200
    73.717    -0.402     0.200
    73.732     0.109     0.200
    73.778    -0.262     0.200
    73.786    -0.408     0.200
    74.026     0.083     0.200
    74.026    -0.519     0.200
    74.026    -0.292     0.200
    74.066    -0.549     0.200
    74.253    -0.340     0.200
    74.317    -0.811     0.200
    74.439    -0.519     0.200
    74.437    -0.413     0.200
    74.478    -0.450     0.200
    74.588    -0.485     0.200
    74.829    -0.685     0.200
    74.977    -0.739     0.200
    75.047    -0.539     0.200
    75.045    -0.830     0.200
    75.103    -0.012     0.200
    75.139    -0.669     0.200
    75.222     0.045     0.200
    75.342     0.558     0.200
    75.342    -0.043     0.200
    75.399    -0.067     0.200
    75.407     0.290     0.200
    75.554     0.653     0.200
    75.784    -0.675     0.200
    75.901     0.656     0.200
    75.945     0.867     0.200
    75.981     0.107     0.200
    76.202    -0.357     0.200
    76.286     0.144     0.200
    76.334     0.323     0.200
    76.416    -0.100     0.200
    76.440    -0.605     0.200
    76.565    -0.314     0.200
    76.561    -0.389     0.200
    76.581    -0.109     0.200
    76.920    -0.418     0.200
    76.917    -0.402     0.200
    76.985    -0.986     0.200
    77.031    -0.244     0.200
    77.341     0.514     0.200
    77.400    -0.612     0.200
    77.538     0.016     0.200
    77.553    -0.172     0.200
    77.707    -0.533     0.200
    77.791     0.001     0.200
    77.953     0.803     0.200
    77.953     0.404     0.200
    77.913     0.425     0.200
    77.911    -0.259     0.200
    77.960    -0.239     0.200
    77.965    -0.465     0.200
    77.944     0.152     0.200
    77.981    -1.056     0.200
    78.025    -0.100     0.200
    78.007    -0.294     0.200
    78.217    -0.957     0.200
    78.278    -0.399     0.200
    78.469    -0.352     0.200
    78.529    -0.088     0.200
    78.729    -0.064     0.200
    78.933    -0.710     0.200
    79.537    -1.409     0.200
    79.772    -0.482     0.200
    80.360    -0.141     0.200
    81.487    -0.273     0.200
    81.779     0.085     0.200
    81.787     0.043     0.200
    81.867     0.121     0.200
    81.992    -1.435     0.200
    82.052    -0.353     0.200
    82.136    -0.092     0.200
    82.218    -0.517     0.200
    82.274     0.087     0.200
    82.274    -0.416     0.200
    82.274    -0.416     0.200
    82.313    -0.322     0.200
    82.368    -0.110     0.200
    82.851    -0.422     0.200
    83.485    -0.553     0.200
    83.485    -0.695     0.200
    83.565    -1.507     0.200
    83.867    -1.155     0.200
    84.547     0.892     0.200
    86.531     0.060     0.200
    23.013     1.591     0.200
    24.889     2.576     0.200
    28.504     0.644     0.200
    29.239     1.796     0.200
    29.563     1.898     0.200
    30.640     1.098     0.200
    32.837     1.384     0.200
    37.583     0.074     0.200
    43.630    -2.970     0.200
    44.025     0.854     0.200
    44.208    -1.192     0.200
    44.830    -0.550     0.200
    45.048     0.542     0.200
    52.490    -2.787     0.200
    56.138    -2.155     0.200
    59.011    -2.609     0.200
    60.620    -2.797     0.200
    61.426    -2.751     0.200
    64.053    -2.097     0.200
    71.390    -3.095     0.200
    72.629    -1.745     0.200
    82.248    -1.784     0.200
    83.949    -0.588     0.200
    20.377     0.228     0.200
    26.906    -1.476     0.200
    58.704    -0.731     0.200
    65.667    -1.099     0.200
    16.705     3.018     0.200
    19.821    -2.595     0.200
    20.812     0.022     0.200
    24.749     2.697     0.200
    25.665    -1.952     0.200
    25.976    -0.731     0.200
    26.264     4.015     0.200
    26.441    -1.573     0.200
    28.084    -0.936     0.200
    30.966     3.019     0.200
    34.403     0.562     0.200
    34.449     1.305     0.200
    34.933     0.477     0.200
    35.845    -3.660     0.200
    37.841    -1.278     0.200
    38.620     0.391     0.200
    39.783    -0.762     0.200
    40.883    -2.965     0.200
    40.919    -0.754     0.200
    40.919    -0.453     0.200
    43.165    -0.516     0.200
    43.165    -0.786     0.200
    44.724    -2.775     0.200
    45.586     1.905     0.200
    46.090    -0.657     0.200
    47.518    -0.882     0.200
    47.518    -1.183     0.200
    47.518    -0.930     0.200
    51.315    -0.520     0.200
    52.345    -1.383     0.200
    52.345    -1.380     0.200
    53.152    -1.734     0.200
    53.302     0.266     0.200
    54.730    -1.318     0.200
    55.042    -0.220     0.200
    57.640    -0.912     0.200
    58.015    -0.336     0.200
    58.448    -0.332     0.200
    61.244    -1.297     0.200
    61.244    -1.161     0.200
    61.274    -1.695     0.200
    63.020    -1.965     0.200
    63.020    -1.852     0.200
    63.496    -1.403     0.200
    63.496    -0.743     0.200
    63.499    -1.520     0.200
    64.257    -1.390     0.200
    64.616    -0.331     0.200
    65.392    -0.758     0.200
    65.392    -0.880     0.200
    65.392    -0.661     0.200
    65.980    -3.334     0.200
    67.192    -1.243     0.200
    67.274    -0.967     0.200
    68.798    -1.599     0.200
    69.388    -0.444     0.200
    69.504    -1.263     0.200
    71.048    -0.677     0.200
    71.053    -0.105     0.200
    71.098    -0.097     0.200
    71.203    -0.250     0.200
    71.436    -0.190     0.200
    71.544    -0.573     0.200
    71.665    -0.686     0.200
    71.975    -1.640     0.200
    71.975    -1.741     0.200
    71.982    -1.886     0.200
    72.030    -0.370     0.200
    72.077     0.045     0.200
    72.202    -0.099     0.200
    72.430    -0.256     0.200
    72.477    -0.632     0.200
    72.499    -0.165     0.200
    72.519     0.123     0.200
    73.255     0.071     0.200
    73.307     0.465     0.200
    73.548    -0.246     0.200
    73.808    -0.766     0.200
    74.164    -0.040     0.200
    74.224    -0.492     0.200
    77.638     0.313     0.200
    77.834    -0.376     0.200
    77.973    -0.745     0.200
    80.212     0.673     0.200
    80.658     0.432     0.200
    82.530    -0.795     0.200
    82.709    -0.171     0.200
    86.164     0.353     0.200
    91.143     0.569     0.200
    96.440    -1.431     0.200
    27.940    -2.870     0.200
    49.033    -1.863     0.200
    56.302    -0.211     0.200
    59.400    -1.731     0.200
    61.347    -1.296     0.200
    62.189    -1.272     0.200
    66.397    -1.453     0.200
    72.105    -1.589     0.200
    73.398    -0.759     0.200
    22.553     1.009     0.200
    22.683     1.979     0.200
    22.842     0.572     0.200
    23.235     0.620     0.200
    23.431     3.129     0.200
    23.644     0.423     0.200
    24.056     2.044     0.200
    25.139     1.663     0.200
    27.001    -0.126     0.200
    29.823     0.249     0.200
    30.174     1.271     0.200
    30.432     2.332     0.200
    30.337     0.602     0.200
    30.678     0.648     0.200
    30.925     0.945     0.200
    31.002     1.346     0.200
    31.137    -0.047     0.200
    31.282     1.095     0.200
    31.382     0.295     0.200
    31.420     4.145     0.200
    31.600    -1.067     0.200
    31.629    -0.238     0.200
    31.897     1.264     0.200
    31.901     1.418     0.200
    31.942     0.632     0.200
    31.960     1.738     0.200
    32.139     0.389     0.200
    32.146     0.726     0.200
    32.227     0.067     0.200
    32.240    -0.747     0.200
    32.285     0.645     0.200
    32.287     0.772     0.200
    32.283     1.211     0.200
    32.482    -0.052     0.200
    32.412     1.160     0.200
    32.533     0.323     0.200
    32.620     0.905     0.200
    32.703     0.232     0.200
    32.691     0.890     0.200
    32.991     0.137     0.200
    33.062    -0.131     0.200
    33.087     0.084     0.200
    33.266    -0.493     0.200
    33.155     0.658     0.200
    33.306    -1.185     0.200
    33.369    -0.234     0.200
    33.413    -0.281     0.200
    33.657     0.563     0.200
    33.814     0.554     0.200
    33.898     1.725     0.200
    33.930     1.884     0.200
    34.074     1.098     0.200
    34.127     1.765     0.200
    34.239     1.858     0.200
    34.280     1.399     0.200
    34.358     0.578     0.200
    34.500     1.309     0.200
    35.132    -0.202     0.200
    35.215     0.889     0.200
    35.259    -0.058     0.200
    35.389    -0.307     0.200
    35.651     3.629     0.200
    35.740     0.121     0.200
    35.968     0.377     0.200
    36.102     1.257     0.200
    36.257    -0.534     0.200
    36.534     1.404     0.200
    36.565     0.853     0.200
    36.685     0.656     0.200
    37.074     0.912     0.200
    37.249     0.400     0.200
    37.543     1.479     0.200
    37.676     1.847     0.200
    37.649     1.201     0.200
    37.695     1.156     0.200
    37.875     0.009     0.200
    37.854     0.173     0.200
    38.009     2.704     0.200
    38.129    -0.061     0.200
    38.174     2.007     0.200
    38.280     2.727     0.200
    38.517     2.068     0.200
    38.589     2.488     0.200
    38.726     0.795     0.200
    38.681     3.152     0.200
    38.751     0.257     0.200
    38.907     0.224     0.200
    39.034     0.141     0.200
    39.074    -0.098     0.200
    39.142     2.350     0.200
    39.234     2.427     0.200
    39.303     2.064     0.200
    39.553     0.634     0.200
    39.685     0.220     0.200
    39.738     1.947     0.200
    39.961     0.492     0.200
    40.076     1.317     0.200
    40.139    -0.211     0.200
    40.224    -0.172     0.200
    40.188     0.625     0.200
    40.300     0.549     0.200
    40.398     0.749     0.200
    40.466     0.930     0.200
    40.468     0.877     0.200
    40.515     1.112     0.200
    40.859     0.604     0.200
    40.914     0.240     0.200
    40.920    -0.466     0.200
    41.079    -0.084     0.200
    41.274    -0.061     0.200
    41.281    -0.026     0.200
    41.366    -0.604     0.200
    41.615    -1.167     0.200
    41.674    -0.416     0.200
    42.086     0.103     0.200
    42.365     0.867     0.200
    42.472     0.330     0.200
    42.458     0.076     0.200
    42.498     0.905     0.200
    42.502     0.502     0.200
    42.508     1.657     0.200
    42.532     1.688     0.200
    42.900     0.858     0.200
    42.877     0.112     0.200
    42.874     0.146     0.200
    42.857     0.683     0.200
    42.894    -0.020     0.200
    43.022     0.430     0.200
    43.278    -0.001     0.200
    43.191     0.463     0.200
    43.271    -0.196     0.200
    43.289     0.131     0.200
    43.320    -0.493     0.200
    43.460    -0.243     0.200
    43.475     0.207     0.200
    43.640    -0.096     0.200
    43.711    -0.552     0.200
    43.733     0.361     0.200
    43.760     0.607     0.200
    43.773    -0.175     0.200
    43.816    -0.834     0.200
    43.947     1.300     0.200
    43.925     1.847     0.200
    44.034     0.966     0.200
    44.129     0.636     0.200
    44.180     0.841     0.200
    44.171     0.173     0.200
    44.252     0.262     0.200
    44.330     0.463     0.200
    44.477     1.926     0.200
    44.624     0.498     0.200
    44.640     0.164     0.200
    44.646     0.620     0.200
    44.685     0.046     0.200
    44.722     1.030     0.200
    44.910     0.867     0.200
    45.033     0.766     0.200
    45.049     0.437     0.200
    45.121     0.607     0.200
    45.252     0.104     0.200
    45.324     0.507     0.200
    45.353     2.330     0.200
    45.424     1.996     0.200
    45.538     0.303     0.200
    45.772     0.138     0.200
    45.809     0.658     0.200
    53.780    -1.093     0.200
    60.220     0.207     0.200
    61.910     0.235     0.200
    67.223     0.068     0.200
    72.590     0.818     0.200
    72.688     0.060     0.200
    73.861     1.188     0.200
    78.913     0.483     0.200
    79.958     1.639     0.200
    15.978     1.244     0.200
    20.579    -0.155     0.200
    23.908     0.465     0.200
    24.536     0.674     0.200
    24.536     1.151     0.200
    28.995     2.042     0.200
    29.023     1.399     0.200
    30.638     2.272     0.200
    30.792     2.455     0.200
    32.143     1.396     0.200
    34.251     2.028     0.200
    45.394     1.168     0.200
    55.175    -0.820     0.200
    58.517    -1.201     0.200
    61.134    -1.288     0.200
    62.195    -1.837     0.200
    65.471    -1.533     0.200
    71.905    -1.394     0.200
    73.438    -0.065     0.200
    82.655    -0.276     0.200
    19.141     0.006     0.200
    22.596     1.150     0.200
    23.401     1.171     0.200
    25.505     1.305     0.200
    26.451    -0.633     0.200
    29.957     1.522     0.200
    32.965     1.504     0.200
    33.231     0.543     0.200
    35.971     0.598     0.200
    44.420     0.885     0.200
    44.431    -0.378     0.200
    45.440     1.018     0.200
    55.757    -0.534     0.200
    60.480    -1.914     0.200
    63.366    -1.758     0.200
    63.474    -2.473     0.200
    72.547    -1.026     0.200
    78.906    -0.961     0.200
    82.074    -0.708     0.200
    19.820    -0.113     0.200
    25.656    -1.322     0.200
    26.875    -1.596     0.200
    35.724    -1.695     0.200
    54.983    -0.319     0.200
    58.057    -1.907     0.200
    65.050    -2.412     0.200
    82.717    -1.827     0.200
    19.998     0.654     0.200
    24.264     3.547     0.200
    28.972     2.539     0.200
    30.537     2.153     0.200
    43.650     2.302     0.200
    47.177    -0.798     0.200
    54.299    -1.258     0.200
    56.764    -0.510     0.200
    57.076     0.211     0.200
    60.367    -0.551     0.200
    62.150    -0.154     0.200
    62.150     0.146     0.200
    62.429    -0.646     0.200
    64.667    -1.221     0.200
    65.086    -0.655     0.200
    65.300    -1.349     0.200
    67.340    -0.578     0.200
    71.219    -0.879     0.200
    72.973     0.517     0.200
    73.192    -0.753     0.200
    73.199    -0.999     0.200
    73.778    -0.449     0.200
    74.445     0.350     0.200
    79.323     1.031     0.200
    80.620     1.110     0.200
    84.031     0.121     0.200
    13.974     7.989     0.200
    19.806    -1.466     0.200
    19.806    -0.421     0.200
    20.620    -0.807     0.200
    20.620    -0.946     0.200
    22.353     2.053     0.200
    22.978     2.105     0.200
    23.341     0.782     0.200
    23.417     0.879     0.200
    23.587     0.605     0.200
    23.587     1.144     0.200
    23.587     1.900     0.200
    23.812     1.535     0.200
    23.961     1.013     0.200
    24.365     1.890     0.200
    24.524     2.180     0.200
    24.770     1.861     0.200
    25.085     1.507     0.200
    25.197     1.170     0.200
    25.197     3.744     0.200
    25.349     3.647     0.200
    25.388     2.163     0.200
    25.418     2.217     0.200
    25.583     1.602     0.200
    25.682     2.231     0.200
    25.715     1.155     0.200
    25.781     2.169     0.200
    26.169     0.909     0.200
    26.635    -2.957     0.200
    26.741     1.562     0.200
    27.443     1.765     0.200
    27.509     0.494     0.200
    27.589    -2.161     0.200
    27.643     1.705     0.200
    27.683     0.249     0.200
    28.080     0.197     0.200
    28.191     0.531     0.200
    28.895     2.193     0.200
    29.281     2.816     0.200
    29.669     1.942     0.200
    29.669     2.663     0.200
    29.687     2.063     0.200
    29.689     2.734     0.200
    29.892     2.471     0.200
    29.892     2.897     0.200
    29.962     2.916     0.200
    30.472     0.388     0.200
    30.713     0.333     0.200
    31.195     1.671     0.200
    31.195     1.716     0.200
    31.301     2.313     0.200
    31.301     2.608     0.200
    31.323     0.879     0.200
    31.477     2.122     0.200
    31.579     1.986     0.200
    31.882     2.152     0.200
    31.921     1.127     0.200
    32.013     1.718     0.200
    32.017     2.253     0.200
    32.142     2.382     0.200
    32.165     1.954     0.200
    32.280     1.529     0.200
    32.307     0.587     0.200
    32.432     1.484     0.200
    32.474     0.092     0.200
    32.538     2.148     0.200
    32.560    -0.148     0.200
    32.795     0.176     0.200
    32.841     0.419     0.200
    32.862     1.235     0.200
    32.876     1.900     0.200
    32.893     1.639     0.200
    32.906     3.224     0.200
    33.008     1.261     0.200
    33.103     2.259     0.200
    33.103     2.877     0.200
    33.120     3.384     0.200
    33.177     0.697     0.200
    33.279    -2.387     0.200
    33.279    -2.496     0.200
    33.233     1.676     0.200
    33.237     0.363     0.200
    33.242     1.163     0.200
    33.280     0.476     0.200
    33.313     2.887     0.200
    33.464     0.378     0.200
    33.542     1.113     0.200
    33.558     0.600     0.200
    33.559     1.033     0.200
    33.585     0.924     0.200
    33.711     2.003     0.200
    33.758     1.328     0.200
    33.758     1.853     0.200
    33.796     0.150     0.200
    33.848     1.004     0.200
    33.949     0.677     0.200
    34.074     2.150     0.200
    34.150     1.290     0.200
    34.274     0.475     0.200
    34.292     0.536     0.200
    34.431     1.217     0.200
    34.445     2.898     0.200
    34.490     1.532     0.200
    34.493     2.343     0.200
    34.545     2.091     0.200
    34.633     2.902     0.200
    34.642     1.601     0.200
    34.642     2.311     0.200
    34.690     1.697     0.200
    34.825     2.135     0.200
    34.830     2.348     0.200
    34.857     0.864     0.200
    34.932     1.808     0.200
    34.960     0.134     0.200
    35.059     2.130     0.200
    35.088     1.742     0.200
    35.124     2.313     0.200
    35.202     1.103     0.200
    35.202     2.028     0.200
    35.251     2.082     0.200
    35.308     0.665     0.200
    35.392     0.974     0.200
    35.461     2.155     0.200
    35.461     2.757     0.200
    35.487     0.552     0.200
    35.503     1.508     0.200
    35.618     0.482     0.200
    35.620     1.059     0.200
    35.620     2.780     0.200
    35.709     1.015     0.200
    35.792     1.748     0.200
    35.792     1.857     0.200
    35.852     0.821     0.200
    35.883     1.729     0.200
    36.051     0.223     0.200
    36.065     0.121     0.200
    36.055     2.604     0.200
    36.212     0.502     0.200
    36.247     1.623     0.200
    36.261     1.461     0.200
    36.318    -2.115     0.200
    36.451     3.196     0.200
    36.612     0.715     0.200
    36.674     0.491     0.200
    36.785     0.153     0.200
    36.819     0.253     0.200
    36.960     1.370     0.200
    36.960     2.518     0.200
    37.116     2.862     0.200
    37.312     0.183     0.200
    37.347     0.344     0.200
    37.487     0.263     0.200
    37.755     1.435     0.200
    37.989     1.518     0.200
    38.197     0.474     0.200
    38.250     0.142     0.200
    38.278     0.303     0.200
    38.444     0.460     0.200
    38.473     0.273     0.200
    38.524     0.657     0.200
    38.534    -0.410     0.200
    38.586     1.980     0.200
    38.867     1.108     0.200
    38.898     0.725     0.200
    38.927     0.155     0.200
    38.987     1.816     0.200
    39.019     0.159     0.200
    39.115     2.031     0.200
    39.245     1.267     0.200
    39.272     0.644     0.200
    39.342     1.619     0.200
    39.495     0.847     0.200
    39.737     0.624     0.200
    39.740     1.068     0.200
    39.749     1.028     0.200
    39.797     0.991     0.200
    39.898     0.812     0.200
    39.984     1.481     0.200
    40.080     0.679     0.200
    40.117     0.483     0.200
    40.134     0.834     0.200
    40.440     0.620     0.200
    40.537     0.674     0.200
    40.669    -0.220     0.200
    40.728     0.090     0.200
    40.827     0.286     0.200
    40.909     0.166     0.200
    41.138     0.495     0.200
    41.265     1.199     0.200
    41.265     1.711     0.200
    41.316     1.298     0.200
    41.439     0.745     0.200
    41.468     0.357     0.200
    41.661     0.272     0.200
    41.689     1.520     0.200
    41.689     2.325     0.200
    41.900     0.823     0.200
    41.907     0.367     0.200
    41.927     0.156     0.200
    42.041     0.191     0.200
    42.176     0.432     0.200
    42.247     0.247     0.200
    42.368    -0.039     0.200
    42.429    -0.352     0.200
    42.514     0.097     0.200
    42.602     0.033     0.200
    42.652    -0.123     0.200
    42.702     1.230     0.200
    42.713    -0.119     0.200
    42.836    -0.159     0.200
    42.889    -1.378     0.200
    42.864    -0.051     0.200
    43.054    -0.062     0.200
    43.072    -0.025     0.200
    43.210    -0.295     0.200
    43.235    -0.226     0.200
    43.429     0.308     0.200
    43.473    -0.308     0.200
    43.493     0.083     0.200
    43.497    -0.215     0.200
    43.516     0.256     0.200
    43.609    -0.409     0.200
    43.641    -0.560     0.200
    43.865    -0.309     0.200
    43.930     0.282     0.200
    44.104     0.219     0.200
    44.283    -0.612     0.200
    44.342    -0.827     0.200
    44.354    -0.394     0.200
    44.394    -0.725     0.200
    44.463     1.888     0.200
    44.464     1.712     0.200
    44.529    -0.027     0.200
    44.680    -0.038     0.200
    44.711    -0.372     0.200
    44.725    -0.476     0.200
    44.751    -0.675     0.200
    44.761     0.307     0.200
    44.822     0.846     0.200
    44.825     0.280     0.200
    45.056    -0.045     0.200
    45.119    -0.211     0.200
    45.144    -1.077     0.200
    45.163     0.602     0.200
    45.193     0.392     0.200
    45.237     0.369     0.200
    45.459     0.482     0.200
    45.556     1.355     0.200
    45.556     1.121     0.200
    45.608     0.481     0.200
    45.708     0.595     0.200
    45.722     0.006     0.200
    45.726     0.303     0.200
    46.099     1.018     0.200
    46.485     1.322     0.200
    47.218     0.309     0.200
    47.631     1.002     0.200
    48.684    -1.538     0.200
    50.047    -1.986     0.200
    53.154    -1.655     0.200
    53.454    -1.748     0.200
    53.485    -0.963     0.200
    53.485    -0.964     0.200
    55.974    -1.025     0.200
    55.987    -0.527     0.200
    57.455    -1.344     0.200
    59.053    -0.504     0.200
    59.145    -1.670     0.200
    59.145    -1.266     0.200
    61.086    -1.029     0.200
    61.086    -0.879     0.200
    61.282    -1.332     0.200
    61.282    -1.457     0.200
    63.420    -2.325     0.200
    63.856    -1.499     0.200
    64.053    -1.904     0.200
    64.053    -1.314     0.200
    64.467    -1.635     0.200
    65.579    -1.046     0.200
    66.132    -1.453     0.200
    66.132    -1.502     0.200
    66.149    -1.994     0.200
    66.224    -1.623     0.200
    66.486    -0.571     0.200
    67.334    -1.461     0.200
    69.968    -1.387     0.200
    70.125    -0.438     0.200
    70.790    -0.891     0.200
    70.828    -2.522     0.200
    71.035    -2.480     0.200
    71.274    -2.724     0.200
    71.418    -0.196     0.200
    71.781     0.323     0.200
    72.028    -1.235     0.200
    72.028    -1.360     0.200
    72.028    -1.091     0.200
    72.035    -1.153     0.200
    72.035    -1.502     0.200
    72.079     0.134     0.200
    72.316     0.822     0.200
    72.352    -0.132     0.200
    72.352    -0.892     0.200
    73.095    -0.205     0.200
    73.092     0.516     0.200
    73.251     0.875     0.200
    73.386    -0.198     0.200
    73.447     0.619     0.200
    73.772     0.811     0.200
    74.706     2.575     0.200
    74.918    -0.655     0.200
    75.110     0.547     0.200
    75.133    -0.268     0.200
    76.108     0.933     0.200
    76.767    -0.498     0.200
    77.546    -3.568     0.200
    77.569    -0.595     0.200
    77.896    -0.216     0.200
    78.096    -0.551     0.200
    78.714    -0.275     0.200
    79.752     0.801     0.200
    79.764    -0.563     0.200
    81.093    -0.295     0.200
    81.166    -0.860     0.200
    81.369     0.037     0.200
    81.460    -0.046     0.200
    81.658    -0.386     0.200
    81.848     0.310     0.200
    81.913    -0.430     0.200
    81.955    -0.249     0.200
    82.379    -0.472     0.200
    82.427    -0.521     0.200
    82.767     0.850     0.200
    82.841    -0.573     0.200
    82.841     0.226     0.200
    83.604    -0.957     0.200
    23.199     1.387     0.200
    25.136     2.211     0.200
    27.940    -0.470     0.200
    28.436    -1.530     0.200
    30.830     1.816     0.200
    44.244     1.576     0.200
    45.249    -0.201     0.200
    52.235    -1.570     0.200
    53.789    -0.927     0.200
    53.789    -0.927     0.200
    55.870    -1.734     0.200
    58.720    -1.566     0.200
    60.365    -1.287     0.200
    63.398    -1.479     0.200
    63.497    -1.653     0.200
    63.506    -2.205     0.200
    65.749    -2.493     0.200
    71.130    -1.266     0.200
    83.711    -0.976     0.200
    19.754     0.242     0.200
    19.754    -1.465     0.200
    19.815     0.139     0.200
    20.889     1.250     0.200
    21.171     3.709     0.200
    21.493     1.482     0.200
    22.641     3.010     0.200
    22.810     2.048     0.200
    22.855     1.552     0.200
    23.240     1.414     0.200
    23.274     0.902     0.200
    23.762     2.022     0.200
    23.773     1.809     0.200
    23.904     2.059     0.200
    23.908     1.197     0.200
    23.935     1.529     0.200
    24.039     1.729     0.200
    24.063     1.311     0.200
    24.063     1.455     0.200
    24.283     1.046     0.200
    24.572     1.767     0.200
    25.004     2.023     0.200
    25.075     2.305     0.200
    25.115     2.298     0.200
    25.397     2.219     0.200
    25.502     1.541     0.200
    25.542     1.382     0.200
    25.905    -1.150     0.200
    25.865     2.274     0.200
    25.872     1.539     0.200
    26.171     1.361     0.200
    26.459     1.968     0.200
    26.846     4.000     0.200
    26.889     1.825     0.200
    27.036    -0.751     0.200
    27.036    -0.305     0.200
    27.080    -1.545     0.200
    27.307     2.162     0.200
    27.417     1.631     0.200
    27.697    -0.939     0.200
    28.001     1.653     0.200
    28.077     0.514     0.200
    28.077     0.776     0.200
    28.543     1.125     0.200
    28.618     1.120     0.200
    28.618     1.655     0.200
    28.658     0.584     0.200
    29.632     2.229     0.200
    29.848     4.229     0.200
    29.997     3.312     0.200
    30.022     0.955     0.200
    30.022     3.525     0.200
    30.173     2.609     0.200
    30.212     1.125     0.200
    30.212     2.324     0.200
    30.260     2.558     0.200
    30.455     0.897     0.200
    30.549     1.856     0.200
    30.549     1.782     0.200
    30.549     1.980     0.200
    30.576     2.669     0.200
    30.618     2.166     0.200
    30.731     0.341     0.200
    30.731     1.001     0.200
    31.014     1.159     0.200
    31.397     0.814     0.200
    31.604     1.136     0.200
    31.687     1.170     0.200
    31.687     1.026     0.200
    31.688     1.606     0.200
    31.688     1.286     0.200
    31.695     1.242     0.200
    31.820     1.353     0.200
    31.893     1.298     0.200
    31.893     1.904     0.200
    31.927     1.621     0.200
    31.927     1.145     0.200
    32.016     1.390     0.200
    32.139     2.125     0.200
    32.234     1.283     0.200
    32.271     1.567     0.200
    32.289     1.465     0.200
    32.314     0.910     0.200
    32.390     1.183     0.200
    32.442    -2.020     0.200
    32.442    -1.520     0.200
    32.447     1.752     0.200
    32.524     0.955     0.200
    32.559     1.016     0.200
    32.616     0.991     0.200
    32.626     1.910     0.200
    32.637     2.583     0.200
    32.711     1.744     0.200
    32.711     2.096     0.200
    32.725     2.388     0.200
    32.735     0.981     0.200
    32.757     1.029     0.200
    32.804     1.916     0.200
    32.838     1.940     0.200
    32.904     0.952     0.200
    32.988     1.138     0.200
    33.056     0.863     0.200
    33.199     1.175     0.200
    33.201     1.385     0.200
    33.219     1.679     0.200
    33.241     1.269     0.200
    33.275     1.009     0.200
    33.352     1.235     0.200
    33.404     1.426     0.200
    33.437     1.469     0.200
    33.491     2.364     0.200
    33.528     0.879     0.200
    33.529     1.440     0.200
    33.529     1.070     0.200
    33.531     0.771     0.200
    33.605     1.250     0.200
    33.623     2.538     0.200
    33.638     1.440     0.200
    33.638     1.616     0.200
    33.645     1.791     0.200
    33.688     2.483     0.200
    33.768     1.335     0.200
    33.775     1.661     0.200
    33.819     0.915     0.200
    33.871     2.006     0.200
    33.901     0.882     0.200
    33.967     0.911     0.200
    33.996     0.479     0.200
    34.033     1.024     0.200
    34.126     2.126     0.200
    34.186     1.347     0.200
    34.190     0.974     0.200
    34.210     0.576     0.200
    34.251     1.647     0.200
    34.264     0.603     0.200
    34.275     1.540     0.200
    34.275     1.208     0.200
    34.319     0.995     0.200
    34.323     0.969     0.200
    34.326     1.172     0.200
    34.442     0.938     0.200
    34.486     0.739     0.200
    34.542     0.842     0.200
    34.638     0.801     0.200
    34.700     0.874     0.200
    34.708     0.909     0.200
    34.719     0.908     0.200
    34.739     1.373     0.200
    34.753     0.740     0.200
    34.788     0.605     0.200
    34.911     1.054     0.200
    35.023     0.924     0.200
    35.042     1.874     0.200
    35.046     0.721     0.200
    35.056     2.240     0.200
    35.082     0.639     0.200
    35.183     2.387     0.200
    35.200     0.667     0.200
    35.200     0.503     0.200
    35.221     1.057     0.200
    35.232     1.246     0.200
    35.253     0.511     0.200
    35.304     0.855     0.200
    35.310     0.867     0.200
    35.326     0.425     0.200
    35.326     1.081     0.200
    35.336     0.491     0.200
    35.358     0.449     0.200
    35.380     1.761     0.200
    35.496     1.245     0.200
    35.519     0.388     0.200
    35.535     0.909     0.200
    35.587     0.391     0.200
    35.592     0.558     0.200
    35.607     1.740     0.200
    35.628     1.267     0.200
    35.640     1.523     0.200
    35.695    -0.956     0.200
    35.673     1.165     0.200
    35.710     0.504     0.200
    35.883     0.587     0.200
    35.979    -1.381     0.200
    35.979    -1.642     0.200
    35.945     0.402     0.200
    35.963     0.543     0.200
    36.084     0.897     0.200
    36.096     0.571     0.200
    36.103     0.302     0.200
    36.124     1.602     0.200
    36.208     0.730     0.200
    36.230     1.896     0.200
    36.230     2.193     0.200
    36.268     0.352     0.200
    36.275     0.558     0.200
    36.286     1.605     0.200
    36.316     0.533     0.200
    36.320     0.463     0.200
    36.324     0.632     0.200
    36.350     1.074     0.200
    36.350     1.324     0.200
    36.535     0.630     0.200
    36.555     1.565     0.200
    36.558     0.295     0.200
    36.561     0.431     0.200
    36.579     0.888     0.200
    36.599     0.716     0.200
    36.699     1.684     0.200
    36.705     0.757     0.200
    36.744     1.383     0.200
    36.793     1.593     0.200
    36.855     0.619     0.200
    36.914     0.519     0.200
    36.918     0.449     0.200
    36.941     1.076     0.200
    36.946     1.177     0.200
    36.968     1.610     0.200
    36.999     0.808     0.200
    37.076     0.818     0.200
    37.099     0.465     0.200
    37.111     0.564     0.200
    37.132     0.843     0.200
    37.165     0.701     0.200
    37.302     0.225     0.200
    37.317     0.367     0.200
    37.413     0.159     0.200
    37.449     0.620     0.200
    37.456     0.050     0.200
    37.468     0.133     0.200
    37.477     1.710     0.200
    37.477     1.988     0.200
    37.616     0.312     0.200
    37.684     0.541     0.200
    37.700     0.943     0.200
    37.712     0.641     0.200
    37.721     2.142     0.200
    37.726     0.840     0.200
    37.751     0.691     0.200
    37.813    -0.007     0.200
    37.813    -0.214     0.200
    37.843     0.390     0.200
    37.914    -0.133     0.200
    37.921     0.708     0.200
    37.946     0.406     0.200
    37.994     0.399     0.200
    38.022     1.272     0.200
    38.022     1.756     0.200
    38.045     0.050     0.200
    38.065     1.594     0.200
    38.092     0.652     0.200
    38.114     0.862     0.200
    38.243     1.005     0.200
    38.296     0.768     0.200
    38.392     0.733     0.200
    38.401     0.555     0.200
    38.466    -2.313     0.200
    38.501     1.296     0.200
    38.558     0.326     0.200
    38.633     0.640     0.200
    38.633     1.351     0.200
    38.797     0.828     0.200
    38.807     0.198     0.200
    38.812     0.578     0.200
    38.877     0.727     0.200
    38.974     0.621     0.200
    38.983     0.097     0.200
    39.147     0.921     0.200
    39.147     1.635     0.200
    39.147    -0.501     0.200
    39.171     0.537     0.200
    39.289     0.261     0.200
    39.308     0.868     0.200
    39.391     0.059     0.200
    39.465     1.386     0.200
    39.481     0.586     0.200
    39.682     0.540     0.200
    39.682     2.540     0.200
    39.685     0.567     0.200
    39.712     0.072     0.200
    39.715     0.537     0.200
    39.721     0.952     0.200
    39.851     0.646     0.200
    39.885     0.826     0.200
    39.890     0.470     0.200
    39.910     0.293     0.200
    39.976     0.231     0.200
    40.049     0.200     0.200
    40.170     0.800     0.200
    40.182     0.629     0.200
    40.274     0.667     0.200
    40.281     0.314     0.200
    40.298     0.495     0.200
    40.346     0.563     0.200
    40.365     0.819     0.200
    40.398     1.473     0.200
    40.458    -0.784     0.200
    40.440     0.363     0.200
    40.511     0.685     0.200
    40.547     0.441     0.200
    40.589     0.340     0.200
    40.674     0.483     0.200
    40.705     1.007     0.200
    40.738     0.771     0.200
    40.793     0.882     0.200
    40.846     0.285     0.200
    40.917     0.921     0.200
    40.931     0.858     0.200
    40.978     0.893     0.200
    40.996     0.960     0.200
    41.073     0.787     0.200
    41.113     0.615     0.200
    41.116     0.494     0.200
    41.116     0.642     0.200
    41.175     0.908     0.200
    41.230     0.371     0.200
    41.236     0.169     0.200
    41.393    -2.940     0.200
    41.371     0.603     0.200
    41.457     1.201     0.200
    41.475     0.604     0.200
    41.634    -1.105     0.200
    41.634    -1.003     0.200
    41.596     0.147     0.200
    41.636     0.506     0.200
    41.646     1.148     0.200
    41.663     0.121     0.200
    41.723    -0.083     0.200
    41.796     0.848     0.200
    41.824     0.492     0.200
    41.890     0.837     0.200
    41.894     0.980     0.200
    41.916     1.297     0.200
    41.950     0.315     0.200
    41.988     0.112     0.200
    42.023     0.149     0.200
    42.157    -0.869     0.200
    42.157    -0.228     0.200
    42.242    -2.053     0.200
    42.272     1.341     0.200
    42.272     1.822     0.200
    42.272     0.234     0.200
    42.315     0.621     0.200
    42.318     0.549     0.200
    42.320     0.270     0.200
    42.354     0.379     0.200
    42.358     0.373     0.200
    42.374     0.447     0.200
    42.404     0.807     0.200
    42.416    -0.218     0.200
    42.418     0.062     0.200
    42.618     0.612     0.200
    42.635     0.369     0.200
    42.671     0.401     0.200
    42.693     0.296     0.200
    42.725     0.364     0.200
    42.726     0.478     0.200
    42.793     0.092     0.200
    42.795    -0.159     0.200
    42.835     0.903     0.200
    42.863    -0.187     0.200
    42.865    -0.145     0.200
    42.887    -0.075     0.200
    43.018     0.078     0.200
    43.047    -0.169     0.200
    43.071    -0.251     0.200
    43.085     0.216     0.200
    43.085     0.622     0.200
    43.090     0.820     0.200
    43.098     0.746     0.200
    43.110     0.748     0.200
    43.205    -0.052     0.200
    43.216    -0.196     0.200
    43.248     0.862     0.200
    43.266     1.018     0.200
    43.410     0.741     0.200
    43.477    -0.073     0.200
    43.491     0.671     0.200
    43.583    -2.417     0.200
    43.565     0.780     0.200
    43.578    -0.417     0.200
    43.583    -0.171     0.200
    43.629    -0.597     0.200
    43.871    -0.425     0.200
    43.892    -0.815     0.200
    43.906    -0.321     0.200
    43.906    -0.215     0.200
    43.912     0.032     0.200
    43.913    -0.111     0.200
    43.933     0.126     0.200
    43.944     0.171     0.200
    43.949    -0.148     0.200
    44.001    -0.564     0.200
    44.016     0.213     0.200
    44.272    -0.613     0.200
    44.294    -0.184     0.200
    44.296    -0.300     0.200
    44.362    -0.927     0.200
    44.393    -0.675     0.200
    44.403     0.279     0.200
    44.405     0.587     0.200
    44.467     0.601     0.200
    44.472     0.206     0.200
    44.664     0.291     0.200
    44.665     0.617     0.200
    44.698    -0.091     0.200
    44.711     0.514     0.200
    44.720    -0.302     0.200
    44.826    -2.102     0.200
    44.778     0.550     0.200
    44.792    -0.686     0.200
    44.821     0.796     0.200
    44.856     0.382     0.200
    45.010    -1.058     0.200
    45.046     0.637     0.200
    45.049     0.933     0.200
    45.049     1.355     0.200
    45.050     0.950     0.200
    45.117     0.118     0.200
    45.142    -0.194     0.200
    45.155     0.334     0.200
    45.165     0.256     0.200
    45.185    -0.042     0.200
    45.185    -0.273     0.200
    45.219     0.580     0.200
    45.244     0.158     0.200
    45.318     0.801     0.200
    45.330     0.555     0.200
    45.389     0.600     0.200
    45.505     0.854     0.200
    45.534     0.430     0.200
    45.630     0.613     0.200
    45.679     0.585     0.200
    45.736     0.549     0.200
    45.866    -2.709     0.200
    45.836     0.452     0.200
    45.867     0.105     0.200
    45.886     0.324     0.200
    46.012     0.780     0.200
    46.037     0.006     0.200
    46.089     0.925     0.200
    46.100    -0.411     0.200
    46.142     0.246     0.200
    46.142     0.492     0.200
    46.202     0.584     0.200
    46.216     0.728     0.200
    46.235     0.553     0.200
    46.338     0.351     0.200
    46.371     0.017     0.200
    46.575     0.255     0.200
    46.612     0.966     0.200
    46.666     0.241     0.200
    46.676     0.795     0.200
    46.709     0.482     0.200
    46.810     0.661     0.200
    46.896     0.572     0.200
    46.991     1.105     0.200
    47.133     0.518     0.200
    47.230     0.412     0.200
    47.705     0.809     0.200
    47.740     1.031     0.200
    47.740     1.301     0.200
    47.767     0.878     0.200
    47.773     0.770     0.200
    47.824     1.350     0.200
    47.862     0.060     0.200
    48.009     1.395     0.200
    48.037     1.044     0.200
    48.041     1.289     0.200
    48.235    -0.832     0.200
    48.252    -0.740     0.200
    48.252    -1.170     0.200
    48.252    -1.168     0.200
    48.209     1.627     0.200
    48.211     0.238     0.200
    48.304     1.947     0.200
    48.362     0.285     0.200
    48.445    -0.021     0.200
    48.629     2.176     0.200
    48.676     1.438     0.200
    48.713     1.522     0.200
    48.722     1.554     0.200
    48.908     1.506     0.200
    49.431    -1.583     0.200
    49.482     0.080     0.200
    49.556     0.844     0.200
    49.556     1.223     0.200
    49.572     0.665     0.200
    49.687    -0.065     0.200
    50.629     0.117     0.200
    52.124     0.176     0.200
    52.396    -2.333     0.200
    52.915    -1.048     0.200
    52.947    -0.668     0.200
    52.947    -0.668     0.200
    53.406    -0.061     0.200
    53.406    -0.537     0.200
    53.406     0.064     0.200
    53.553    -1.182     0.200
    53.553    -1.460     0.200
    54.030    -0.388     0.200
    54.555    -1.597     0.200
    54.725    -1.723     0.200
    54.931    -1.414     0.200
    54.931    -0.992     0.200
    55.223    -1.104     0.200
    55.236    -0.466     0.200
    58.041    -2.872     0.200
    58.312    -1.613     0.200
    58.312    -1.492     0.200
    58.312    -1.562     0.200
    60.352    -0.989     0.200
    60.388    -0.656     0.200
    60.388    -1.203     0.200
    60.523    -2.274     0.200
    60.630    -4.500     0.200
    61.082    -0.886     0.200
    61.082    -0.273     0.200
    61.458    -1.833     0.200
    62.579    -2.755     0.200
    62.579    -2.021     0.200
    62.579    -2.200     0.200
    63.018    -2.714     0.200
    63.018    -1.862     0.200
    63.018    -1.112     0.200
    63.127    -1.883     0.200
    63.207    -1.362     0.200
    63.207    -1.925     0.200
    63.207    -3.065     0.200
    63.211    -1.954     0.200
    63.405    -2.878     0.200
    63.512    -0.676     0.200
    64.838    -1.443     0.200
    65.078    -1.601     0.200
    65.259    -1.770     0.200
    65.306    -1.775     0.200
    65.306    -1.923     0.200
    65.323    -2.016     0.200
    65.397    -1.822     0.200
    65.783    -0.745     0.200
    66.537    -2.268     0.200
    67.051    -1.829     0.200
    67.386    -1.094     0.200
    68.388    -2.378     0.200
    69.124    -1.908     0.200
    69.299    -0.781     0.200
    70.067    -0.458     0.200
    70.112    -1.176     0.200
    70.185    -0.481     0.200
    70.188    -0.339     0.200
    70.285    -0.328     0.200
    70.498    -0.622     0.200
    70.512    -0.211     0.200
    70.536    -0.756     0.200
    70.691    -0.199     0.200
    71.079    -0.444     0.200
    71.110    -1.060     0.200
    71.193    -0.234     0.200
    71.212    -0.148     0.200
    71.256    -2.336     0.200
    71.256    -1.942     0.200
    71.263    -2.005     0.200
    71.263    -3.157     0.200
    71.280    -1.856     0.200
    71.359    -0.487     0.200
    71.368    -0.090     0.200
    71.344     1.887     0.200
    71.517    -1.016     0.200
    71.517    -0.781     0.200
    71.517    -0.633     0.200
    71.614    -0.368     0.200
    71.714    -0.769     0.200
    71.714    -0.601     0.200
    71.705    -0.413     0.200
    71.789    -0.319     0.200
    72.007    -1.019     0.200
    72.223    -0.006     0.200
    72.273    -1.296     0.200
    72.396    -0.142     0.200
    72.396     0.069     0.200
    72.422    -0.296     0.200
    72.514     0.056     0.200
    72.690    -0.306     0.200
    72.690    -0.361     0.200
    72.699     0.562     0.200
    72.720     0.338     0.200
    72.788    -0.762     0.200
    73.024     0.541     0.200
    73.035    -0.922     0.200
    73.184    -0.800     0.200
    73.221    -0.719     0.200
    73.349    -0.373     0.200
    73.722    -0.310     0.200
    73.753    -0.379     0.200
    73.878     2.236     0.200
    73.958     0.062     0.200
    74.011     0.125     0.200
    74.126    -0.416     0.200
    74.242     0.444     0.200
    74.352    -0.854     0.200
    74.378    -0.875     0.200
    74.381    -0.992     0.200
    74.418     0.134     0.200
    74.593     0.627     0.200
    74.645     0.502     0.200
    74.887    -0.359     0.200
    74.943    -0.082     0.200
    74.991    -0.294     0.200
    75.076    -0.372     0.200
    75.175    -0.271     0.200
    75.208    -0.763     0.200
    75.305     0.580     0.200
    75.652    -1.524     0.200
    75.735     1.120     0.200
    75.800    -0.872     0.200
    76.088     1.023     0.200
    76.127    -0.312     0.200
    76.324    -0.615     0.200
    76.385     0.735     0.200
    76.506    -0.054     0.200
    76.580     1.034     0.200
    76.581    -1.530     0.200
    76.759     0.631     0.200
    76.870     1.007     0.200
    77.075    -1.246     0.200
    77.129    -0.249     0.200
    77.161    -0.727     0.200
    77.275    -1.312     0.200
    77.363     0.643     0.200
    77.744     0.823     0.200
    77.780    -0.216     0.200
    77.856     0.607     0.200
    78.293     0.286     0.200
    78.482    -0.655     0.200
    78.868     4.412     0.200
    78.834    -0.997     0.200
    78.978    -1.671     0.200
    79.138    -0.009     0.200
    79.138    -0.689     0.200
    79.200     0.335     0.200
    79.212     0.425     0.200
    79.256     0.732     0.200
    79.340     2.505     0.200
    79.696     0.527     0.200
    79.710    -1.440     0.200
    79.724    -0.088     0.200
    79.727    -0.514     0.200
    79.983     0.675     0.200
    80.320    -1.311     0.200
    80.334    -0.211     0.200
    80.369    -0.542     0.200
    80.600    -0.234     0.200
    80.623    -1.219     0.200
    80.693     0.068     0.200
    80.899    -0.527     0.200
    81.023    -0.587     0.200
    81.067    -0.024     0.200
    81.095    -0.878     0.200
    81.149    -0.557     0.200
    81.182    -0.230     0.200
    81.172    -0.816     0.200
    81.596    -0.515     0.200
    81.647    -0.483     0.200
    81.849    -1.313     0.200
    81.977    -0.525     0.200
    82.047    -0.533     0.200
    82.047    -1.186     0.200
    82.362    -1.155     0.200
    82.362    -0.366     0.200
    82.362    -0.827     0.200
    82.362     0.694     0.200
    82.362    -0.497     0.200
    82.433    -0.700     0.200
    82.642    -0.281     0.200
    82.953    -0.825     0.200
    82.953    -0.942     0.200
    82.977    -1.179     0.200
    83.836    -1.083     0.200
    83.894    -1.013     0.200
    83.894    -1.654     0.200
    84.663     0.197     0.200
    85.251    -0.145     0.200
    85.251     0.425     0.200
    86.371    -0.080     0.200
    87.195    -1.988     0.200
    87.195    -3.129     0.200
    88.679     1.471     0.200
    89.797    -0.108     0.200
    91.175    -0.174     0.200
    91.626    -0.767     0.200
    91.688    -0.551     0.200
    92.202    -0.726     0.200
    92.225    -0.308     0.200
    92.225     0.293     0.200
    92.866    -0.597     0.200
    92.866    -0.414     0.200
    92.951    -1.042     0.200
    92.950    -1.377     0.200
    96.479    -1.660     0.200
    96.780    -0.252     0.200
    97.468    -0.989     0.200
    97.481    -2.076     0.200
    21.754     1.091     0.200
    21.967     1.279     0.200
    22.015     1.105     0.200
    26.787    -0.546     0.200
    27.968     0.041     0.200
    27.968     1.381     0.200
    28.961     1.544     0.200
    29.085     0.627     0.200
    29.662     0.778     0.200
    29.679     1.396     0.200
    29.688     1.547     0.200
    29.747     1.581     0.200
    29.913     1.912     0.200
    30.800     1.553     0.200
    31.006     1.749     0.200
    31.034     1.183     0.200
    34.154     0.439     0.200
    34.174     1.026     0.200
    34.460     0.465     0.200
    36.041     0.814     0.200
    36.960     1.196     0.200
    37.138     1.220     0.200
    37.613     1.807     0.200
    37.968     1.581     0.200
    38.145     0.841     0.200
    38.225     0.881     0.200
    38.800     1.635     0.200
    39.306     1.391     0.200
    39.355     0.759     0.200
    40.244     1.998     0.200
    40.758     1.831     0.200
    40.906     1.458     0.200
    41.495     1.663     0.200
    42.574     1.783     0.200
    43.749     1.053     0.200
    44.163     0.999     0.200
    44.164     1.703     0.200
    45.684     1.280     0.200
    52.601    -2.855     0.200
    59.232     1.720     0.200
    63.678    -1.101     0.200
    63.787    -1.823     0.200
    66.010    -1.427     0.200
    66.744     3.257     0.200
    70.977    -0.446     0.200
    19.432    -0.726     0.200
    26.137    -2.113     0.200
    31.381     0.808     0.200
    44.764     0.628     0.200
    55.453    -0.335     0.200
    58.444    -2.145     0.200
    22.656     1.010     0.200
    27.131    -2.466     0.200
    28.142     0.778     0.200
    28.180     0.531     0.200
    28.484    -2.001     0.200
    28.484    -2.430     0.200
    28.994    -2.970     0.200
    30.284     1.388     0.200
    30.284     2.469     0.200
    32.624     0.759     0.200
    37.121    -2.365     0.200
    37.121    -3.490     0.200
    37.428    -1.095     0.200
    39.866    -1.737     0.200
    41.646     0.680     0.200
    41.646    -0.288     0.200
    41.867    -2.072     0.200
    41.858     0.952     0.200
    41.968    -1.743     0.200
    42.755    -3.145     0.200
    43.581    -1.471     0.200
    43.687     2.532     0.200
    43.870    -2.343     0.200
    45.763    -1.457     0.200
    45.939    -3.999     0.200
    47.242    -2.154     0.200
    49.668    -1.830     0.200
    50.780    -1.290     0.200
    52.456    -1.352     0.200
    54.339    -0.573     0.200
    54.339    -0.523     0.200
    56.401    -0.763     0.200
    56.414    -0.254     0.200
    59.201    -1.505     0.200
    59.201    -1.290     0.200
    59.652     0.477     0.200
    60.247    -1.105     0.200
    60.247    -0.827     0.200
    60.586    -1.044     0.200
    60.877    -3.796     0.200
    61.348    -1.181     0.200
    63.113    -1.539     0.200
    63.113    -2.003     0.200
    63.584     0.081     0.200
    63.869    -2.099     0.200
    63.869    -1.548     0.200
    63.928    -1.685     0.200
    63.906    -0.395     0.200
    66.033    -0.466     0.200
    66.242    -1.451     0.200
    66.259    -1.955     0.200
    66.759    -1.508     0.200
    67.022    -1.283     0.200
    68.959    -1.591     0.200
    70.502    -2.737     0.200
    71.265     0.728     0.200
    71.368    -1.291     0.200
    71.368    -1.490     0.200
    71.375    -1.332     0.200
    71.375    -1.203     0.200
    72.244     0.748     0.200
    72.321     0.146     0.200
    72.456     0.386     0.200
    72.492     0.969     0.200
    72.539     0.089     0.200
    73.284    -0.326     0.200
    74.795     3.354     0.200
    77.431     0.162     0.200
    77.432    -1.036     0.200
    77.636     0.223     0.200
    78.436    -0.714     0.200
    78.697     0.506     0.200
    78.708     0.137     0.200
    80.974    -0.030     0.200
    82.249    -0.858     0.200
    84.270    -0.421     0.200
    84.270    -0.218     0.200
    84.294    -0.974     0.200
    84.973    -0.066     0.200
    85.109     1.040     0.200
    19.231     0.411     0.200
    31.157     1.405     0.200
    43.017    -1.205     0.200
    53.468    -1.390     0.200
    53.468    -1.390     0.200
    55.636    -0.237     0.200
    71.196    -1.823     0.200
    82.025    -1.474     0.200
    83.427    -1.196     0.200
    19.431    -0.227     0.200
    19.431     0.228     0.200
    21.749     0.967     0.200
    22.053     0.722     0.200
    22.283     1.499     0.200
    22.398     1.736     0.200
    22.773     0.816     0.200
    23.179     1.342     0.200
    23.330     0.820     0.200
    23.456     1.596     0.200
    23.498     0.904     0.200
    23.498     1.153     0.200
    23.498     2.089     0.200
    23.848     1.544     0.200
    23.977     1.994     0.200
    24.089     1.284     0.200
    24.407     2.398     0.200
    24.477     2.056     0.200
    24.710     1.429     0.200
    24.801     2.628     0.200
    24.924     0.969     0.200
    24.983     1.903     0.200
    25.042     2.399     0.200
    25.266     1.589     0.200
    25.314     1.586     0.200
    25.384     1.279     0.200
    25.612     1.432     0.200
    25.649     1.740     0.200
    25.642     3.038     0.200
    25.860     2.923     0.200
    26.048     1.432     0.200
    26.076     1.225     0.200
    26.246     3.315     0.200
    26.292     3.026     0.200
    26.383     1.428     0.200
    26.502    -1.662     0.200
    26.502    -1.962     0.200
    26.713     1.847     0.200
    26.818     2.189     0.200
    27.263     2.007     0.200
    27.416     2.054     0.200
    27.539     1.147     0.200
    27.973     1.112     0.200
    28.037     1.901     0.200
    28.096     1.312     0.200
    28.096     0.496     0.200
    28.810     2.045     0.200
    28.891     0.801     0.200
    29.003     2.046     0.200
    29.046     1.428     0.200
    29.351     1.885     0.200
    29.457     1.887     0.200
    29.608     1.887     0.200
    29.656     1.868     0.200
    29.656     1.254     0.200
    29.812     1.261     0.200
    29.884     1.416     0.200
    29.981     2.044     0.200
    30.249     1.236     0.200
    30.905     2.055     0.200
    31.118     1.722     0.200
    31.119     1.421     0.200
    31.119     1.216     0.200
    31.218     2.391     0.200
    31.306     1.788     0.200
    31.306     1.571     0.200
    31.331     2.135     0.200
    31.331     1.738     0.200
    31.540     1.768     0.200
    31.651     1.793     0.200
    31.690     1.743     0.200
    32.100     1.368     0.200
    32.113     1.736     0.200
    32.113     2.750     0.200
    32.126     2.301     0.200
    32.205     1.768     0.200
    32.239     1.558     0.200
    32.377     1.933     0.200
    32.619     2.203     0.200
    32.797     1.422     0.200
    32.901     2.051     0.200
    32.943     1.746     0.200
    32.954     1.276     0.200
    32.993     2.669     0.200
    33.033     1.036     0.200
    33.033     1.618     0.200
    33.051     1.113     0.200
    33.097     1.717     0.200
    33.097     2.013     0.200
    33.112     1.102     0.200
    33.153     2.544     0.200
    33.176     2.178     0.200
    33.176     1.729     0.200
    33.286     1.264     0.200
    33.485     1.517     0.200
    33.539    -0.014     0.200
    33.539     1.346     0.200
    33.531     1.577     0.200
    33.651     0.914     0.200
    33.708     0.577     0.200
    33.700     1.185     0.200
    33.737     0.482     0.200
    33.784     1.313     0.200
    34.013     0.310     0.200
    34.140     1.692     0.200
    34.311     0.468     0.200
    34.395     1.798     0.200
    34.459     1.577     0.200
    34.462     1.327     0.200
    34.529    -0.017     0.200
    34.600     1.171     0.200
    34.622     1.095     0.200
    34.656     1.849     0.200
    34.725    -0.077     0.200
    34.725     0.556     0.200
    34.727     2.038     0.200
    34.737     1.477     0.200
    34.796     0.855     0.200
    34.884     0.581     0.200
    34.897     2.319     0.200
    35.024     0.857     0.200
    35.029     1.365     0.200
    35.065     1.642     0.200
    35.108     0.367     0.200
    35.165     0.571     0.200
    35.162     1.323     0.200
    35.243     0.348     0.200
    35.257     1.354     0.200
    35.315     1.277     0.200
    35.342     2.052     0.200
    35.453     0.235     0.200
    35.461     0.916     0.200
    35.525     2.072     0.200
    35.525     1.780     0.200
    35.587     1.576     0.200
    35.636     2.138     0.200
    35.636     1.626     0.200
    35.688     1.895     0.200
    35.784     0.160     0.200
    35.765     1.156     0.200
    35.765     0.371     0.200
    35.803     0.390     0.200
    35.807     0.028     0.200
    35.838     0.440     0.200
    35.955     1.140     0.200
    35.955     0.833     0.200
    36.064    -0.913     0.200
    36.087    -0.619     0.200
    36.102     1.463     0.200
    36.214     0.971     0.200
    36.214     1.321     0.200
    36.343    -1.554     0.200
    36.412     0.492     0.200
    36.441     0.793     0.200
    36.474     0.176     0.200
    36.567    -1.159     0.200
    36.567    -0.478     0.200
    36.593     0.501     0.200
    36.592    -0.390     0.200
    36.640     0.761     0.200
    36.646    -0.027     0.200
    36.691     0.734     0.200
    36.846     0.502     0.200
    36.902     1.836     0.200
    36.902     2.413     0.200
    36.927    -0.384     0.200
    36.960     0.820     0.200
    37.005     0.587     0.200
    37.113     0.558     0.200
    37.128     1.623     0.200
    37.223     0.396     0.200
    37.226     0.301     0.200
    37.226     0.623     0.200
    37.244     0.139     0.200
    37.300    -0.404     0.200
    37.300    -0.266     0.200
    37.397    -0.440     0.200
    37.487     0.181     0.200
    37.510     0.334     0.200
    37.640     0.374     0.200
    37.806     0.654     0.200
    37.816     1.982     0.200
    37.816     1.784     0.200
    37.871     0.619     0.200
    37.928     1.286     0.200
    38.018    -0.077     0.200
    38.033     0.020     0.200
    38.057     0.080     0.200
    38.073     0.446     0.200
    38.082     0.392     0.200
    38.152     0.974     0.200
    38.312     0.343     0.200
    38.312     0.698     0.200
    38.312     0.560     0.200
    38.504     1.313     0.200
    38.504     0.822     0.200
    38.562     0.402     0.200
    38.562     0.761     0.200
    38.562     0.521     0.200
    38.648     0.156     0.200
    38.642     2.738     0.200
    38.683     1.104     0.200
    38.728     1.253     0.200
    38.729    -0.027     0.200
    38.812     0.664     0.200
    38.843     0.195     0.200
    38.848     0.228     0.200
    38.865     0.399     0.200
    38.955     0.814     0.200
    39.027     0.930     0.200
    39.100     1.458     0.200
    39.130     0.238     0.200
    39.130     1.216     0.200
    39.202     0.176     0.200
    39.213     0.374     0.200
    39.258     0.386     0.200
    39.317     0.049     0.200
    39.359     0.466     0.200
    39.352    -0.366     0.200
    39.381    -0.629     0.200
    39.462     0.193     0.200
    39.478     0.491     0.200
    39.501     0.728     0.200
    39.543     0.232     0.200
    39.652     0.300     0.200
    39.650     0.278     0.200
    39.748     0.735     0.200
    39.777     0.426     0.200
    39.820     0.462     0.200
    39.806     1.614     0.200
    39.806     2.190     0.200
    39.846     1.320     0.200
    39.913     0.121     0.200
    39.930     0.477     0.200
    39.986     0.593     0.200
    40.086     0.215     0.200
    40.137    -0.014     0.200
    40.172     0.103     0.200
    40.222    -0.078     0.200
    40.215     0.226     0.200
    40.277     0.574     0.200
    40.339    -0.077     0.200
    40.364     0.376     0.200
    40.377     0.035     0.200
    40.401     0.443     0.200
    40.513    -0.390     0.200
    40.581     0.252     0.200
    40.579     0.397     0.200
    40.640     0.234     0.200
    40.643     0.663     0.200
    40.655     0.974     0.200
    40.703     0.852     0.200
    40.724     0.402     0.200
    40.826     0.331     0.200
    40.854     0.192     0.200
    40.860     0.056     0.200
    40.913     0.026     0.200
    40.944     0.409     0.200
    40.972     0.234     0.200
    41.044     0.037     0.200
    41.058    -0.423     0.200
    41.074     0.298     0.200
    41.113     0.680     0.200
    41.146     0.557     0.200
    41.147     0.340     0.200
    41.224     0.302     0.200
    41.234    -0.050     0.200
    41.217     1.024     0.200
    41.217     0.816     0.200
    41.261     0.275     0.200
    41.289     0.507     0.200
    41.315    -0.113     0.200
    41.343     0.266     0.200
    41.418     0.010     0.200
    41.423     0.392     0.200
    41.476     0.169     0.200
    41.503     0.514     0.200
    41.532     0.311     0.200
    41.625     0.061     0.200
    41.689    -0.204     0.200
    41.683     1.770     0.200
    41.683     0.803     0.200
    41.734    -0.166     0.200
    41.776     0.359     0.200
    41.810     0.161     0.200
    41.808     0.362     0.200
    41.830     0.450     0.200
    41.887     0.181     0.200
    41.900     0.032     0.200
    41.958    -0.079     0.200
    42.131    -0.149     0.200
    42.161    -0.264     0.200
    42.203    -0.232     0.200
    42.245     0.428     0.200
    42.268    -0.180     0.200
    42.343    -0.022     0.200
    42.352    -0.132     0.200
    42.390    -1.652     0.200
    42.471    -0.166     0.200
    42.473     0.258     0.200
    42.510    -0.165     0.200
    42.540    -0.155     0.200
    42.539     0.373     0.200
    42.547    -0.165     0.200
    42.684    -0.731     0.200
    42.687    -0.267     0.200
    42.702     0.997     0.200
    42.702     0.344     0.200
    42.824     0.023     0.200
    42.819    -0.098     0.200
    42.882    -0.151     0.200
    42.936    -0.135     0.200
    42.943     0.238     0.200
    43.051     0.091     0.200
    43.051     0.350     0.200
    43.063    -0.176     0.200
    43.094    -0.829     0.200
    43.105    -0.399     0.200
    43.126    -1.613     0.200
    43.249    -0.245     0.200
    43.333    -0.445     0.200
    43.360    -1.173     0.200
    43.368     0.108     0.200
    43.384     0.365     0.200
    43.388     0.333     0.200
    43.406    -0.040     0.200
    43.398     0.449     0.200
    43.477    -0.730     0.200
    43.541    -0.421     0.200
    43.591     0.120     0.200
    43.730    -0.306     0.200
    43.740     0.622     0.200
    43.749    -0.215     0.200
    43.827    -0.913     0.200
    43.864    -0.973     0.200
    43.894     0.696     0.200
    43.894     0.023     0.200
    43.913     0.588     0.200
    43.944    -0.478     0.200
    43.947    -0.166     0.200
    44.085    -0.399     0.200
    44.109     0.494     0.200
    44.153    -0.378     0.200
    44.160     0.535     0.200
    44.189    -0.730     0.200
    44.253    -0.923     0.200
    44.260     1.141     0.200
    44.274    -0.660     0.200
    44.363    -0.066     0.200
    44.459     1.650     0.200
    44.460     1.007     0.200
    44.550    -0.025     0.200
    44.576    -0.753     0.200
    44.606    -0.547     0.200
    44.612     0.475     0.200
    44.645    -0.473     0.200
    44.661     0.821     0.200
    44.695     0.153     0.200
    44.696     0.750     0.200
    44.729    -0.580     0.200
    44.753    -0.001     0.200
    44.838     0.538     0.200
    44.950     1.188     0.200
    44.989    -0.111     0.200
    45.038    -0.917     0.200
    45.069     0.767     0.200
    45.110    -0.563     0.200
    45.173    -0.327     0.200
    45.338     0.071     0.200
    45.363     0.214     0.200
    45.407    -1.259     0.200
    45.411    -1.283     0.200
    45.424    -0.641     0.200
    45.459     0.439     0.200
    45.467    -1.112     0.200
    45.518    -0.771     0.200
    45.510     0.851     0.200
    45.510     0.175     0.200
    45.532     0.754     0.200
    45.532     0.172     0.200
    45.567    -2.692     0.200
    45.576    -0.670     0.200
    45.596     0.060     0.200
    45.596     0.347     0.200
    45.639     0.337     0.200
    45.643     0.683     0.200
    45.793    -0.474     0.200
    45.788    -0.442     0.200
    45.821     0.323     0.200
    45.877     0.162     0.200
    45.896    -0.437     0.200
    46.038     0.823     0.200
    46.232     0.181     0.200
    46.252    -0.461     0.200
    46.279     0.346     0.200
    46.328     0.841     0.200
    46.419     0.876     0.200
    46.557     0.537     0.200
    46.617     0.153     0.200
    46.650     0.342     0.200
    46.691     0.305     0.200
    46.965     0.775     0.200
    47.066     0.969     0.200
    47.079     0.701     0.200
    47.181     0.713     0.200
    47.186     0.908     0.200
    47.189    -0.177     0.200
    47.269    -1.957     0.200
    47.414     0.571     0.200
    47.436     0.382     0.200
    47.436     0.994     0.200
    47.444     0.318     0.200
    47.433     1.295     0.200
    47.450     0.080     0.200
    47.485     0.002     0.200
    47.548     1.454     0.200
    47.639     1.351     0.200
    47.731     1.934     0.200
    47.765     0.076     0.200
    47.828     0.211     0.200
    47.833     0.436     0.200
    47.856     0.943     0.200
    47.908    -0.160     0.200
    47.994     0.097     0.200
    47.995     0.694     0.200
    48.048     0.920     0.200
    48.092     1.336     0.200
    48.141     0.159     0.200
    48.147     0.412     0.200
    48.166     0.931     0.200
    48.237     0.511     0.200
    48.256    -0.061     0.200
    48.269     0.814     0.200
    48.302     0.704     0.200
    48.348     1.277     0.200
    48.489     1.630     0.200
    48.607     0.372     0.200
    48.749    -0.341     0.200
    49.024    -0.048     0.200
    49.012     0.179     0.200
    49.026     0.758     0.200
    49.061     0.951     0.200
    49.128     0.218     0.200
    49.143    -0.069     0.200
    49.238    -0.287     0.200
    49.243     0.957     0.200
    49.296     0.750     0.200
    49.319     0.627     0.200
    49.462     0.632     0.200
    49.496     1.045     0.200
    49.552     0.085     0.200
    49.648     1.747     0.200
    49.688    -0.073     0.200
    49.713     0.104     0.200
    49.851    -0.761     0.200
    49.951    -0.023     0.200
    49.981     0.580     0.200
    50.067     1.150     0.200
    50.153     0.759     0.200
    50.200    -0.346     0.200
    50.219     0.645     0.200
    50.248    -0.715     0.200
    50.271     1.221     0.200
    50.325     0.415     0.200
    50.546     0.057     0.200
    50.584     0.438     0.200
    50.698     0.643     0.200
    51.028     0.467     0.200
    51.140     0.510     0.200
    51.512     0.557     0.200
    51.634     0.001     0.200
    52.677    -2.144     0.200
    53.495    -1.244     0.200
    53.526    -1.612     0.200
    53.526    -1.612     0.200
    55.525    -2.414     0.200
    55.816    -0.713     0.200
    55.829    -0.778     0.200
    58.853    -0.556     0.200
    58.853    -2.207     0.200
    58.969     0.992     0.200
    60.421    -1.724     0.200
    60.559    -1.186     0.200
    60.592    -1.662     0.200
    60.592    -1.737     0.200
    60.806    -1.791     0.200
    60.979    -2.692     0.200
    61.616    -1.097     0.200
    63.023    -2.201     0.200
    63.550    -2.488     0.200
    63.550    -1.868     0.200
    63.706    -2.511     0.200
    63.799    -1.926     0.200
    65.858    -2.452     0.200
    65.858    -1.920     0.200
    65.875    -2.163     0.200
    66.564     2.553     0.200
    66.751    -1.438     0.200
    66.879    -1.747     0.200
    68.222    -1.714     0.200
    68.734    -0.849     0.200
    69.229    -2.488     0.200
    69.590    -1.973     0.200
    70.338    -0.677     0.200
    70.389    -1.917     0.200
    70.389    -1.667     0.200
    70.433    -0.885     0.200
    70.588    -2.732     0.200
    70.654    -0.486     0.200
    70.897    -0.719     0.200
    71.096    -0.825     0.200
    71.283    -0.540     0.200
    71.288    -0.277     0.200
    71.406    -0.292     0.200
    71.411    -0.322     0.200
    71.558    -2.005     0.200
    71.558    -1.885     0.200
    71.565    -2.147     0.200
    71.582    -2.047     0.200
    71.588    -0.188     0.200
    71.733    -0.356     0.200
    71.823    -0.296     0.200
    71.892    -0.409     0.200
    71.907    -0.864     0.200
    72.054    -1.581     0.200
    72.054    -1.351     0.200
    72.208    -0.503     0.200
    72.235    -0.772     0.200
    72.582    -0.632     0.200
    72.598    -0.122     0.200
    72.596    -0.533     0.200
    72.729    -1.124     0.200
    72.766     0.175     0.200
    72.795    -1.286     0.200
    72.863     0.002     0.200
    72.863    -0.408     0.200
    72.892    -0.467     0.200
    72.892    -0.707     0.200
    72.900    -0.746     0.200
    72.960     0.227     0.200
    73.288    -0.609     0.200
    73.585    -0.854     0.200
    73.671    -0.657     0.200
    73.927     0.538     0.200
    73.964    -0.266     0.200
    73.969    -0.461     0.200
    74.139    -0.158     0.200
    74.196    -0.105     0.200
    74.273    -0.224     0.200
    74.421     0.262     0.200
    74.426     2.237     0.200
    74.615     0.398     0.200
    74.629    -0.591     0.200
    74.658    -0.911     0.200
    74.768     0.625     0.200
    74.813     0.507     0.200
    74.868     0.708     0.200
    75.086    -0.438     0.200
    75.151     0.213     0.200
    75.281    -0.262     0.200
    75.881    -0.353     0.200
    76.097    -0.222     0.200
    76.335    -0.914     0.200
    76.415    -0.468     0.200
    76.430    -0.655     0.200
    76.576    -1.081     0.200
    76.617     0.288     0.200
    76.786     0.336     0.200
    76.789    -0.477     0.200
    76.789     0.553     0.200
    76.804    -1.962     0.200
    76.835    -1.140     0.200
    76.898     0.308     0.200
    76.899    -0.399     0.200
    77.081    -0.824     0.200
    77.097    -1.013     0.200
    77.162     0.223     0.200
    77.388     0.259     0.200
    77.414    -1.087     0.200
    77.418     0.262     0.200
    77.463    -0.863     0.200
    77.463    -0.693     0.200
    77.664    -0.710     0.200
    77.690    -0.728     0.200
    77.640     1.150     0.200
    77.770     0.126     0.200
    77.770     0.576     0.200
    77.816    -0.231     0.200
    77.873    -0.147     0.200
    78.277    -0.352     0.200
    78.318    -0.010     0.200
    78.479    -1.899     0.200
    78.605    -0.072     0.200
    78.721     0.269     0.200
    78.730    -0.280     0.200
    79.217    -0.245     0.200
    79.253     0.009     0.200
    79.264    -0.083     0.200
    79.264     0.415     0.200
    79.305     0.394     0.200
    79.434    -0.128     0.200
    79.645    -0.977     0.200
    79.654    -0.926     0.200
    79.707    -0.411     0.200
    79.819    -0.360     0.200
    80.006     0.169     0.200
    80.196     0.349     0.200
    80.801    -0.799     0.200
    80.925    -0.559     0.200
    81.188    -0.554     0.200
    81.282    -0.254     0.200
    81.538    -0.611     0.200
    81.609    -0.885     0.200
    81.680    -0.757     0.200
    81.680    -0.356     0.200
    81.740    -0.871     0.200
    81.786     0.626     0.200
    82.179    -0.875     0.200
    82.307    -0.254     0.200
    82.383    -0.591     0.200
    82.383    -0.914     0.200
    82.665    -0.310     0.200
    83.246    -1.047     0.200
    83.551    -1.591     0.200
    83.551    -1.087     0.200
    83.575    -1.520     0.200
    84.235     0.836     0.200
    85.286    -1.331     0.200
    85.402    -0.138     0.200
    85.402     0.212     0.200
    85.881    -2.018     0.200
    86.091    -2.746     0.200
    87.392    -2.195     0.200
    87.673    -0.762     0.200
    87.878    -1.227     0.200
    88.543    -1.789     0.200
    89.165    -1.835     0.200
    92.353    -0.147     0.200
    92.490    -0.352     0.200
    97.552    -1.816     0.200
    97.835    -2.487     0.200
    97.835    -1.549     0.200
    19.914    -0.566     0.200
    20.424    -0.852     0.200
    21.153     1.068     0.200
    21.284     2.581     0.200
    21.317     2.026     0.200
    21.344     2.118     0.200
    21.508     2.977     0.200
    21.893     3.460     0.200
    21.996     1.267     0.200
    22.103     1.814     0.200
    22.272     2.526     0.200
    22.443     2.050     0.200
    22.535     1.699     0.200
    22.550     1.807     0.200
    22.578     2.311     0.200
    23.232     2.459     0.200
    23.414     2.029     0.200
    23.453     1.619     0.200
    23.500     1.785     0.200
    23.533     2.658     0.200
    23.545     1.961     0.200
    23.580     1.607     0.200
    23.623     2.690     0.200
    23.780     0.841     0.200
    23.780     1.451     0.200
    23.780     1.677     0.200
    24.017     2.197     0.200
    24.165     2.163     0.200
    24.338     1.612     0.200
    24.571     2.757     0.200
    24.623     3.519     0.200
    24.648     3.055     0.200
    24.725     1.931     0.200
    24.975     2.924     0.200
    25.026     2.976     0.200
    25.202     2.810     0.200
    25.276     1.716     0.200
    25.280     2.417     0.200
    25.404     2.827     0.200
    25.404     3.468     0.200
    25.595     3.462     0.200
    25.610     1.831     0.200
    25.790     2.877     0.200
    25.882     1.764     0.200
    25.907     1.563     0.200
    25.988     2.175     0.200
    26.429    -2.205     0.200
    26.320     2.378     0.200
    26.342     1.366     0.200
    26.362     1.718     0.200
    26.372     2.840     0.200
    26.458     2.730     0.200
    26.676     1.211     0.200
    26.903     2.754     0.200
    26.948     1.900     0.200
    27.391    -2.143     0.200
    27.514    -0.677     0.200
    27.563     1.516     0.200
    27.671     1.979     0.200
    27.867     0.575     0.200
    27.867     0.884     0.200
    28.168     0.647     0.200
    28.023     1.680     0.200
    28.243     1.629     0.200
    28.280     1.592     0.200
    28.384     1.351     0.200
    28.578     2.528     0.200
    28.952     2.960     0.200
    29.172     2.845     0.200
    29.192     1.651     0.200
    29.207     2.980     0.200
    29.331     1.996     0.200
    29.349     2.463     0.200
    29.488     3.323     0.200
    29.739     2.892     0.200
    29.739     3.450     0.200
    29.882     2.523     0.200
    29.955     2.194     0.200
    29.955     2.440     0.200
    30.012     2.207     0.200
    30.154     2.714     0.200
    30.254     2.231     0.200
    30.276     2.462     0.200
    30.294     2.586     0.200
    30.393     2.821     0.200
    30.469     3.352     0.200
    31.329     3.336     0.200
    31.334     2.144     0.200
    31.390     1.498     0.200
    31.390     1.678     0.200
    31.391     1.645     0.200
    31.391     1.625     0.200
    31.391     1.516     0.200
    31.506     2.192     0.200
    31.525     1.344     0.200
    31.525     1.942     0.200
    31.582     2.760     0.200
    31.684     2.822     0.200
    31.712     2.209     0.200
    31.782     2.045     0.200
    31.786     1.885     0.200
    31.789     3.100     0.200
    31.935     2.498     0.200
    32.084     2.282     0.200
    32.146     2.789     0.200
    32.220     1.938     0.200
    32.220     2.345     0.200
    32.224     3.020     0.200
    32.267     2.421     0.200
    32.267     2.925     0.200
    32.349     2.538     0.200
    32.372     2.656     0.200
    32.487     2.026     0.200
    32.639     2.586     0.200
    32.745     2.210     0.200
    33.095    -2.348     0.200
    33.095    -2.508     0.200
    33.021     2.795     0.200
    33.045     2.460     0.200
    33.085     0.971     0.200
    33.083     2.138     0.200
    33.087     2.397     0.200
    33.109     2.466     0.200
    33.133     2.478     0.200
    33.154     2.525     0.200
    33.215     2.379     0.200
    33.239     1.423     0.200
    33.276     3.423     0.200
    33.310     2.375     0.200
    33.310     2.617     0.200
    33.322     2.667     0.200
    33.344     2.549     0.200
    33.390     1.787     0.200
    33.419     1.672     0.200
    33.463     3.317     0.200
    33.514     2.538     0.200
    33.563     2.634     0.200
    33.590     2.873     0.200
    33.629     2.396     0.200
    33.715     2.407     0.200
    33.766     2.511     0.200
    33.918     2.461     0.200
    33.925     2.969     0.200
    33.952     0.507     0.200
    33.956     1.493     0.200
    33.956     1.790     0.200
    34.100     0.609     0.200
    34.098     2.056     0.200
    34.281     2.076     0.200
    34.313     2.047     0.200
    34.391     2.192     0.200
    34.414     0.315     0.200
    34.441     0.225     0.200
    34.510     1.753     0.200
    34.626     0.981     0.200
    34.626     1.922     0.200
    34.693     2.310     0.200
    34.707     0.322     0.200
    34.752     1.548     0.200
    34.849     2.127     0.200
    34.849     2.275     0.200
    34.852     2.240     0.200
    34.891     1.705     0.200
    34.983     0.616     0.200
    35.026     1.681     0.200
    35.037     2.451     0.200
    35.123     0.152     0.200
    35.130     0.111     0.200
    35.139     1.969     0.200
    35.259     1.796     0.200
    35.283     0.761     0.200
    35.295     2.012     0.200
    35.322     1.804     0.200
    35.382     0.588     0.200
    35.409     1.399     0.200
    35.458     2.888     0.200
    35.502     0.313     0.200
    35.515     2.688     0.200
    35.647     0.214     0.200
    35.668     2.266     0.200
    35.668     2.376     0.200
    35.710     1.609     0.200
    35.806     2.427     0.200
    35.824     2.053     0.200
    35.824     2.408     0.200
    35.850     0.781     0.200
    35.977    -0.092     0.200
    35.993     1.294     0.200
    35.993     1.466     0.200
    36.026     0.427     0.200
    36.090     2.109     0.200
    36.090     2.328     0.200
    36.164     0.748     0.200
    36.168     0.663     0.200
    36.210    -0.261     0.200
    36.230    -0.084     0.200
    36.546    -2.506     0.200
    36.546    -2.065     0.200
    36.442     0.285     0.200
    36.443     1.544     0.200
    36.443     2.235     0.200
    36.460     1.405     0.200
    36.460     2.237     0.200
    36.488     0.079     0.200
    36.607     0.450     0.200
    36.677     0.896     0.200
    36.705     0.149     0.200
    36.784     0.367     0.200
    36.819     0.451     0.200
    36.837     0.355     0.200
    36.959     0.135     0.200
    36.968     1.283     0.200
    36.968     2.287     0.200
    36.985     0.239     0.200
    37.052     0.253     0.200
    37.158     1.955     0.200
    37.180     0.221     0.200
    37.246     0.072     0.200
    37.244    -0.469     0.200
    37.267     0.467     0.200
    37.321     2.623     0.200
    37.345     0.516     0.200
    37.413     0.310     0.200
    37.485     0.428     0.200
    37.618     0.480     0.200
    37.638     0.356     0.200
    37.638     0.719     0.200
    37.647     0.192     0.200
    37.660    -0.312     0.200
    37.660     0.121     0.200
    37.662    -0.079     0.200
    37.752    -0.238     0.200
    37.748     1.773     0.200
    37.748     1.902     0.200
    37.899    -0.037     0.200
    37.900    -0.157     0.200
    37.969     0.018     0.200
    37.961     2.199     0.200
    38.040     0.527     0.200
    38.047     2.540     0.200
    38.095     0.597     0.200
    38.190     0.513     0.200
    38.187     1.768     0.200
    38.187     1.994     0.200
    38.220     0.566     0.200
    38.378    -0.080     0.200
    38.434     0.007     0.200
    38.434     0.790     0.200
    38.434     1.021     0.200
    38.451     0.435     0.200
    38.460     0.250     0.200
    38.466     0.419     0.200
    38.531     0.362     0.200
    38.650     0.168     0.200
    38.662    -0.075     0.200
    38.672     1.926     0.200
    38.672     2.375     0.200
    38.700     0.236     0.200
    38.709     0.856     0.200
    38.787     1.550     0.200
    38.787     2.042     0.200
    38.831     0.490     0.200
    38.858     2.586     0.200
    38.997     0.046     0.200
    39.067     1.235     0.200
    39.089    -0.058     0.200
    39.189     0.643     0.200
    39.240     0.089     0.200
    39.280     0.227     0.200
    39.318     2.584     0.200
    39.342     0.796     0.200
    39.435     0.557     0.200
    39.435     1.109     0.200
    39.435     1.797     0.200
    39.526    -0.185     0.200
    39.565    -0.134     0.200
    39.585     0.014     0.200
    39.680     0.354     0.200
    39.711     0.441     0.200
    39.720     0.274     0.200
    39.742     0.534     0.200
    39.820     0.342     0.200
    39.869     0.290     0.200
    39.913     0.410     0.200
    39.911    -0.247     0.200
    40.001     2.456     0.200
    40.050     0.127     0.200
    40.081     0.058     0.200
    40.154     0.275     0.200
    40.164     0.669     0.200
    40.199    -0.295     0.200
    40.292    -0.043     0.200
    40.298     0.061     0.200
    40.316     0.298     0.200
    40.381     0.212     0.200
    40.457     0.036     0.200
    40.465    -0.105     0.200
    40.553    -0.198     0.200
    40.562     0.382     0.200
    40.744    -1.874     0.200
    40.633     0.167     0.200
    40.706     0.183     0.200
    40.753     0.104     0.200
    40.855     0.405     0.200
    40.889    -0.547     0.200
    40.903    -0.063     0.200
    40.903     0.832     0.200
    40.912     0.160     0.200
    40.999     0.318     0.200
    41.002     0.430     0.200
    41.006     0.374     0.200
    41.025    -0.017     0.200
    41.036     0.020     0.200
    41.046     0.404     0.200
    41.084     0.134     0.200
    41.143     0.529     0.200
    41.282     0.219     0.200
    41.336     0.030     0.200
    41.386     0.055     0.200
    41.433    -0.088     0.200
    41.440     0.318     0.200
    41.460     0.544     0.200
    41.464     0.607     0.200
    41.504    -0.102     0.200
    41.564     0.386     0.200
    41.590    -0.240     0.200
    41.618    -0.024     0.200
    41.621     0.250     0.200
    41.787    -2.804     0.200
    41.656     0.186     0.200
    41.690    -0.430     0.200
    41.765     0.205     0.200
    41.801    -0.381     0.200
    41.837    -0.300     0.200
    41.853     0.138     0.200
    41.867    -0.608     0.200
    41.893     1.821     0.200
    41.893     1.434     0.200
    41.938    -0.038     0.200
    41.957     0.031     0.200
    41.994    -0.471     0.200
    42.067     0.330     0.200
    42.061    -0.014     0.200
    42.094     0.377     0.200
    42.116     0.094     0.200
    42.177     0.113     0.200
    42.191    -0.279     0.200
    42.224    -0.154     0.200
    42.257    -0.120     0.200
    42.268    -0.244     0.200
    42.324    -0.520     0.200
    42.431    -0.541     0.200
    42.453     0.008     0.200
    42.534    -0.748     0.200
    42.560    -0.713     0.200
    42.557    -0.252     0.200
    42.610    -0.141     0.200
    42.685    -0.417     0.200
    42.693    -0.251     0.200
    42.711    -0.443     0.200
    42.838    -2.249     0.200
    42.781    -1.143     0.200
    42.789     0.115     0.200
    42.953    -2.083     0.200
    42.839    -0.318     0.200
    42.837    -0.281     0.200
    42.893    -0.191     0.200
    43.019    -0.749     0.200
    43.041    -0.341     0.200
    43.191    -0.672     0.200
    43.246    -0.295     0.200
    43.244    -0.140     0.200
    43.258    -0.099     0.200
    43.336    -0.572     0.200
    43.364     0.017     0.200
    43.392    -0.246     0.200
    43.414    -0.322     0.200
    43.426    -0.766     0.200
    43.466    -0.557     0.200
    43.617    -0.715     0.200
    43.658    -0.421     0.200
    43.684    -0.269     0.200
    43.685     0.439     0.200
    43.695    -1.137     0.200
    43.693    -0.224     0.200
    43.693     0.451     0.200
    43.706    -0.415     0.200
    43.706     0.171     0.200
    43.781    -0.492     0.200
    43.781     0.047     0.200
    43.822    -0.773     0.200
    43.895    -0.412     0.200
    43.915    -0.625     0.200
    43.964    -0.662     0.200
    44.041    -0.124     0.200
    44.051    -0.399     0.200
    44.062    -0.327     0.200
    44.158    -0.792     0.200
    44.155    -0.104     0.200
    44.155     0.998     0.200
    44.204    -1.102     0.200
    44.204    -0.151     0.200
    44.229    -0.629     0.200
    44.294    -0.663     0.200
    44.300    -0.599     0.200
    44.315    -0.259     0.200
    44.406     0.162     0.200
    44.467     0.389     0.200
    44.467     0.878     0.200
    44.471    -0.298     0.200
    44.511     0.055     0.200
    44.523    -0.242     0.200
    44.525    -1.006     0.200
    44.543    -0.751     0.200
    44.547     1.052     0.200
    44.579    -0.768     0.200
    44.618    -0.714     0.200
    44.620    -0.632     0.200
    44.726     0.127     0.200
    44.838    -0.351     0.200
    44.897    -0.584     0.200
    44.921    -0.225     0.200
    44.935    -0.932     0.200
    44.953     0.800     0.200
    44.994    -0.812     0.200
    45.010    -1.289     0.200
    45.007     0.252     0.200
    45.035    -0.062     0.200
    45.079    -0.169     0.200
    45.086    -0.445     0.200
    45.119    -0.618     0.200
    45.145     0.008     0.200
    45.236    -0.261     0.200
    45.306    -0.160     0.200
    45.356     0.590     0.200
    45.364    -0.829     0.200
    45.380    -1.415     0.200
    45.445    -1.577     0.200
    45.526    -0.413     0.200
    45.563    -0.723     0.200
    45.648     0.112     0.200
    45.672    -0.828     0.200
    45.737    -1.154     0.200
    45.755     0.720     0.200
    45.755     0.935     0.200
    45.772    -0.551     0.200
    45.806    -1.413     0.200
    45.845     0.145     0.200
    45.876    -0.507     0.200
    45.910     0.184     0.200
    45.918    -0.250     0.200
    45.920     0.451     0.200
    46.095     0.292     0.200
    46.132    -0.145     0.200
    46.138     0.007     0.200
    46.145    -0.543     0.200
    46.147    -0.371     0.200
    46.162    -0.447     0.200
    46.239    -0.504     0.200
    46.249    -0.315     0.200
    46.288     0.670     0.200
    46.352    -0.271     0.200
    46.479    -0.189     0.200
    46.474    -0.180     0.200
    46.525    -0.190     0.200
    46.600     1.027     0.200
    46.682     0.739     0.200
    46.933     0.343     0.200
    46.950     0.109     0.200
    46.986     0.708     0.200
    47.066    -0.845     0.200
    47.136     0.591     0.200
    47.368     1.064     0.200
    47.371     0.514     0.200
    47.752     0.420     0.200
    47.754     0.664     0.200
    47.784    -0.038     0.200
    47.803     0.122     0.200
    47.811     0.324     0.200
    48.149     0.533     0.200
    48.158     0.248     0.200
    48.171     0.190     0.200
    48.184     0.047     0.200
    48.196     0.805     0.200
    48.246     0.024     0.200
    48.265     1.864     0.200
    48.494    -1.700     0.200
    48.494    -1.749     0.200
    48.409    -0.125     0.200
    48.482     0.713     0.200
    48.562     0.284     0.200
    48.576     0.814     0.200
    48.590     0.181     0.200
    48.599     0.858     0.200
    48.889     0.336     0.200
    48.945     0.401     0.200
    49.017     1.110     0.200
    49.064     0.573     0.200
    49.331     0.377     0.200
    49.350     0.376     0.200
    49.377     0.903     0.200
    49.427     0.336     0.200
    49.471     0.194     0.200
    49.477     1.208     0.200
    49.656    -0.180     0.200
    49.792     0.582     0.200
    49.809     0.963     0.200
    49.890     0.108     0.200
    50.031    -0.380     0.200
    50.186     0.055     0.200
    50.297     0.812     0.200
    50.376     1.454     0.200
    50.482     0.842     0.200
    50.539     0.722     0.200
    50.592    -0.949     0.200
    50.630     0.169     0.200
    50.918     0.237     0.200
    51.023     0.553     0.200
    51.057     0.651     0.200
    51.358     0.479     0.200
    51.435     0.712     0.200
    51.755     0.632     0.200
    52.016     0.250     0.200
    53.057    -1.690     0.200
    53.285    -1.481     0.200
    53.285    -1.505     0.200
    54.363    -0.779     0.200
    55.474    -1.109     0.200
    55.474    -1.000     0.200
    55.782    -1.507     0.200
    58.959    -1.371     0.200
    61.015    -1.293     0.200
    61.015    -0.968     0.200
    61.185    -1.388     0.200
    61.685    -0.420     0.200
    63.267    -2.269     0.200
    63.881    -1.722     0.200
    65.373    -1.550     0.200
    65.531    -1.569     0.200
    65.652    -1.346     0.200
    65.941    -1.585     0.200
    66.602     4.358     0.200
    67.216    -1.546     0.200
    69.554    -2.752     0.200
    70.814    -0.157     0.200
    70.911    -2.248     0.200
    71.319    -0.448     0.200
    71.353     0.377     0.200
    71.709     0.234     0.200
    71.827    -0.478     0.200
    71.924    -1.557     0.200
    71.931    -1.600     0.200
    72.003     0.370     0.200
    72.166    -0.705     0.200
    72.244    -0.169     0.200
    72.912    -0.339     0.200
    72.988    -0.418     0.200
    73.022     0.206     0.200
    73.130     0.370     0.200
    73.164     0.272     0.200
    73.316    -0.449     0.200
    73.364     0.888     0.200
    73.770    -0.289     0.200
    73.788     1.004     0.200
    73.921    -0.874     0.200
    73.992     0.211     0.200
    74.163    -0.583     0.200
    74.350    -0.696     0.200
    74.386    -0.029     0.200
    74.517     2.154     0.200
    74.507    -1.787     0.200
    74.573     0.709     0.200
    74.628     0.608     0.200
    74.705     0.428     0.200
    74.721    -0.029     0.200
    74.857     1.193     0.200
    75.041    -0.771     0.200
    75.038    -1.029     0.200
    75.042     0.367     0.200
    75.298     1.742     0.200
    75.512     0.913     0.200
    75.573     0.089     0.200
    75.704     0.017     0.200
    77.192    -0.895     0.200
    77.284    -0.011     0.200
    77.424    -3.992     0.200
    77.762    -0.379     0.200
    77.962    -0.188     0.200
    78.110     0.191     0.200
    78.456     0.879     0.200
    78.770    -1.149     0.200
    79.746     0.304     0.200
    80.888    -0.110     0.200
    81.000    -0.307     0.200
    81.166    -0.087     0.200
    81.257     0.129     0.200
    81.453    -0.211     0.200
    81.520    -0.366     0.200
    81.646     0.372     0.200
    81.660    -0.404     0.200
    81.660    -0.602     0.200
    81.709    -0.559     0.200
    81.752    -0.285     0.200
    82.178    -0.420     0.200
    82.179     0.267     0.200
    82.225    -0.466     0.200
    82.725    -0.425     0.200
    83.397    -1.095     0.200
    85.849    -0.511     0.200
    97.366    -2.861     0.200
    19.374    -0.122     0.200
    43.799     2.455     0.200
    53.359    -1.560     0.200
    20.269    -0.247     0.200
    20.556    -1.056     0.200
    21.268     2.839     0.200
    22.115     1.584     0.200
    22.687     2.186     0.200
    23.624     2.359     0.200
    23.664     2.809     0.200
    23.702     2.112     0.200
    23.932     1.322     0.200
    23.932     2.072     0.200
    23.932     1.798     0.200
    24.069     2.687     0.200
    24.233     2.532     0.200
    24.619     3.182     0.200
    24.669     3.348     0.200
    25.031     4.050     0.200
    25.246     3.290     0.200
    25.429     2.683     0.200
    25.614     2.860     0.200
    25.773     2.067     0.200
    25.823     2.826     0.200
    26.005     2.475     0.200
    26.473    -2.799     0.200
    26.473    -3.073     0.200
    26.516     1.934     0.200
    26.805    -1.565     0.200
    26.966     2.092     0.200
    27.272    -2.454     0.200
    27.928    -0.723     0.200
    27.928    -0.223     0.200
    28.060     1.138     0.200
    28.164    -2.120     0.200
    28.382     0.548     0.200
    28.394     1.652     0.200
    28.612     0.747     0.200
    29.482     2.491     0.200
    29.511     3.393     0.200
    29.888     2.326     0.200
    29.888     2.467     0.200
    30.024     2.781     0.200
    30.120     2.176     0.200
    30.130     2.506     0.200
    30.130     2.764     0.200
    30.151     0.404     0.200
    30.202     2.948     0.200
    30.489     2.112     0.200
    30.501     2.363     0.200
    30.781     1.100     0.200
    30.933     0.452     0.200
    31.239     2.074     0.200
    31.530     1.834     0.200
    31.531     1.863     0.200
    31.531     1.793     0.200
    31.531     1.183     0.200
    31.561     2.428     0.200
    31.618     2.617     0.200
    31.712     3.188     0.200
    31.780     2.808     0.200
    31.798     2.822     0.200
    32.166     3.212     0.200
    32.213     2.874     0.200
    32.227     2.243     0.200
    32.391     2.809     0.200
    32.487     2.782     0.200
    32.758     2.528     0.200
    33.088     1.935     0.200
    33.192     3.332     0.200
    33.285    -2.673     0.200
    33.305     2.897     0.200
    33.329     2.549     0.200
    33.605     1.791     0.200
    33.614     3.156     0.200
    33.652     1.336     0.200
    33.652     1.640     0.200
    33.657     2.444     0.200
    33.770     2.523     0.200
    33.778     2.901     0.200
    33.937     2.437     0.200
    34.081     1.933     0.200
    34.081     2.355     0.200
    34.227     0.317     0.200
    34.227     0.442     0.200
    34.305     2.481     0.200
    34.353     0.660     0.200
    34.378     2.426     0.200
    34.676     0.547     0.200
    34.689     0.529     0.200
    34.715     3.125     0.200
    34.768     2.256     0.200
    34.799     2.453     0.200
    34.835     2.364     0.200
    34.858     1.408     0.200
    34.858     3.487     0.200
    34.865     2.137     0.200
    34.940     3.000     0.200
    34.964     0.362     0.200
    35.061     2.629     0.200
    35.151     0.541     0.200
    35.249     0.503     0.200
    35.314     1.811     0.200
    35.366     2.401     0.200
    35.382     0.384     0.200
    35.382     0.501     0.200
    35.442     2.001     0.200
    35.476     0.366     0.200
    35.463     2.500     0.200
    35.544     0.586     0.200
    35.695     2.453     0.200
    35.728     1.967     0.200
    35.720     1.992     0.200
    35.786     1.049     0.200
    35.811     2.167     0.200
    35.890     2.231     0.200
    35.913     0.409     0.200
    36.093     1.899     0.200
    36.109     2.239     0.200
    36.478     0.272     0.200
    36.482     0.112     0.200
    36.646     0.592     0.200
    36.680     0.045     0.200
    36.750     0.201     0.200
    36.855     0.432     0.200
    36.848     0.749     0.200
    36.928     0.287     0.200
    37.017     0.276     0.200
    37.095     0.367     0.200
    37.187     0.322     0.200
    37.237     0.436     0.200
    37.319     0.202     0.200
    37.390     2.963     0.200
    37.417     0.196     0.200
    37.456     0.016     0.200
    37.508     0.469     0.200
    37.592     0.345     0.200
    37.683     0.406     0.200
    37.717     0.523     0.200
    37.875     0.360     0.200
    37.882    -0.174     0.200
    37.912     0.448     0.200
    37.912     0.800     0.200
    37.912     0.365     0.200
    37.969     0.609     0.200
    37.990     1.934     0.200
    38.151     0.205     0.200
    38.171     0.176     0.200
    38.712    -0.398     0.200
    38.724    -0.139     0.200
    38.718     2.333     0.200
    38.888     0.491     0.200
    38.885     1.807     0.200
    38.950     0.732     0.200
    38.968     0.769     0.200
    39.095     0.655     0.200
    39.311     0.958     0.200
    39.428     0.376     0.200
    39.493     0.110     0.200
    39.506     0.076     0.200
    39.782     0.052     0.200
    39.789    -0.245     0.200
    39.818    -0.010     0.200
    39.869     0.367     0.200
    39.927     0.373     0.200
    39.921     0.896     0.200
    39.985     0.553     0.200
    40.072     2.200     0.200
    40.121     0.520     0.200
    40.140     0.073     0.200
    40.186     0.295     0.200
    40.277     0.346     0.200
    40.311     0.283     0.200
    40.370     0.784     0.200
    40.392     0.171     0.200
    40.516     0.100     0.200
    40.543     0.118     0.200
    40.608    -1.313     0.200
    40.584     0.112     0.200
    40.637     0.239     0.200
    40.795    -0.040     0.200
    40.851     0.535     0.200
    40.934     0.155     0.200
    41.003     0.258     0.200
    41.125    -0.496     0.200
    41.218     0.492     0.200
    41.269     0.456     0.200
    41.272     0.079     0.200
    41.279     0.405     0.200
    41.291     0.109     0.200
    41.306     0.246     0.200
    41.465     1.383     0.200
    41.532    -0.369     0.200
    41.669     0.573     0.200
    41.682    -0.002     0.200
    41.721     0.333     0.200
    41.817     0.160     0.200
    41.844    -0.135     0.200
    41.864    -0.463     0.200
    41.914     0.373     0.200
    41.925    -0.346     0.200
    41.969     0.262     0.200
    41.976     1.957     0.200
    41.976     2.059     0.200
    42.044    -0.243     0.200
    42.058    -0.082     0.200
    42.065     0.096     0.200
    42.133     0.063     0.200
    42.191    -0.082     0.200
    42.306    -0.428     0.200
    42.327     0.156     0.200
    42.386     0.011     0.200
    42.422    -0.053     0.200
    42.440    -0.335     0.200
    42.474     0.276     0.200
    42.511    -0.414     0.200
    42.524    -0.435     0.200
    42.550    -0.300     0.200
    42.814    -0.188     0.200
    42.909    -3.036     0.200
    42.905    -0.301     0.200
    42.931    -0.339     0.200
    43.034    -0.756     0.200
    43.067    -0.511     0.200
    43.239    -1.303     0.200
    43.216    -0.777     0.200
    43.257    -0.379     0.200
    43.424    -0.596     0.200
    43.471    -0.760     0.200
    43.577    -0.899     0.200
    43.594    -0.254     0.200
    43.619    -0.956     0.200
    43.626    -0.568     0.200
    43.687    -0.404     0.200
    43.846    -0.424     0.200
    43.893    -1.102     0.200
    44.016    -0.254     0.200
    44.028    -0.736     0.200
    44.111    -0.511     0.200
    44.197    -0.384     0.200
    44.283     0.497     0.200
    44.351    -0.762     0.200
    44.405    -0.367     0.200
    44.471    -0.481     0.200
    44.505    -0.618     0.200
    44.543    -0.488     0.200
    44.608    -1.271     0.200
    44.723    -0.686     0.200
    44.747    -0.726     0.200
    44.753    -1.083     0.200
    44.753    -0.340     0.200
    44.748     1.500     0.200
    44.749     1.619     0.200
    44.768    -0.915     0.200
    44.823    -0.860     0.200
    44.834    -0.280     0.200
    44.949    -0.079     0.200
    44.994    -0.392     0.200
    45.078     0.002     0.200
    45.081     0.060     0.200
    45.127    -0.511     0.200
    45.153    -0.055     0.200
    45.205    -0.196     0.200
    45.211    -0.759     0.200
    45.305    -0.499     0.200
    45.323     0.062     0.200
    45.486    -0.384     0.200
    45.552    -0.827     0.200
    45.582    -0.306     0.200
    45.609    -0.348     0.200
    45.585    -1.246     0.200
    45.739    -0.364     0.200
    45.807    -0.047     0.200
    45.815    -0.137     0.200
    45.822     0.259     0.200
    45.870     0.936     0.200
    45.870     1.412     0.200
    45.919    -0.556     0.200
    45.929    -1.109     0.200
    45.982    -0.440     0.200
    46.086     0.511     0.200
    46.094    -0.549     0.200
    46.153    -0.290     0.200
    46.184    -0.250     0.200
    46.405    -0.302     0.200
    46.471    -0.217     0.200
    46.532    -0.363     0.200
    46.658    -0.254     0.200
    46.717    -0.103     0.200
    46.933    -0.096     0.200
    47.038    -0.020     0.200
    47.128    -0.470     0.200
    47.302    -0.677     0.200
    47.308     0.005     0.200
    47.534    -1.213     0.200
    47.627    -0.934     0.200
    47.659     0.039     0.200
    47.773     0.063     0.200
    47.847    -0.110     0.200
    48.017     0.246     0.200
    48.068    -0.090     0.200
    48.078     0.224     0.200
    48.105     0.146     0.200
    48.329    -1.822     0.200
    48.370     0.205     0.200
    48.408     0.154     0.200
    48.431    -0.055     0.200
    48.465    -0.073     0.200
    48.462     0.433     0.200
    48.740     0.413     0.200
    48.784     0.090     0.200
    48.799     0.280     0.200
    48.852     0.248     0.200
    49.144     0.700     0.200
    49.183     1.136     0.200
    49.207     0.250     0.200
    49.241     0.076     0.200
    49.556     0.876     0.200
    49.675     0.217     0.200
    49.696    -0.294     0.200
    49.705    -0.398     0.200
    49.935    -0.913     0.200
    49.983     0.421     0.200
    50.024    -0.525     0.200
    50.019    -0.157     0.200
    50.036    -0.268     0.200
    50.040    -0.167     0.200
    50.234    -0.305     0.200
    50.381    -0.131     0.200
    50.446    -0.311     0.200
    50.488    -0.337     0.200
    50.558    -0.313     0.200
    50.672     0.719     0.200
    50.756     0.672     0.200
    50.781    -0.607     0.200
    50.796    -0.296     0.200
    50.830    -0.283     0.200
    50.927    -0.511     0.200
    51.199    -0.419     0.200
    51.211    -0.651     0.200
    51.241    -0.409     0.200
    51.539    -0.240     0.200
    51.651    -0.893     0.200
    52.259    -0.585     0.200
    52.377    -1.750     0.200
    52.420    -0.891     0.200
    53.179    -1.102     0.200
    53.180    -1.055     0.200
    53.422    -2.088     0.200
    54.078    -1.030     0.200
    55.531    -1.245     0.200
    55.829    -0.926     0.200
    55.842    -0.846     0.200
    59.137    -1.210     0.200
    59.137    -1.538     0.200
    59.137    -1.663     0.200
    61.404    -0.756     0.200
    61.404    -0.178     0.200
    61.549    -1.241     0.200
    61.549    -1.030     0.200
    61.647    -3.687     0.200
    61.647    -3.586     0.200
    61.836    -0.760     0.200
    62.477    -0.757     0.200
    63.545    -2.136     0.200
    63.545    -1.940     0.200
    63.863    -1.833     0.200
    63.863    -1.262     0.200
    63.972    -1.619     0.200
    64.111    -1.665     0.200
    64.114    -1.592     0.200
    65.264    -0.623     0.200
    65.422    -1.101     0.200
    66.103    -1.584     0.200
    66.103    -1.788     0.200
    66.103    -1.686     0.200
    66.120    -1.945     0.200
    66.197    -1.584     0.200
    67.556    -1.329     0.200
    68.317    -0.909     0.200
    70.067    -1.339     0.200
    71.743    -0.259     0.200
    71.936    -0.166     0.200
    72.096     1.376     0.200
    72.188     0.043     0.200
    72.281    -1.204     0.200
    72.281    -1.110     0.200
    72.288    -1.270     0.200
    72.288    -1.770     0.200
    72.305    -1.074     0.200
    72.349    -0.634     0.200
    72.349    -0.064     0.200
    72.388     1.034     0.200
    72.552     0.047     0.200
    72.613     0.284     0.200
    72.950     0.499     0.200
    73.059     0.559     0.200
    73.135    -0.698     0.200
    73.412     1.274     0.200
    73.706     0.144     0.200
    73.706     0.433     0.200
    73.714     0.298     0.200
    74.372    -0.143     0.200
    74.684     2.446     0.200
    74.772     1.020     0.200
    75.432     0.776     0.200
    76.093     0.701     0.200
    78.077    -0.568     0.200
    78.077    -0.091     0.200
    78.276     0.058     0.200
    78.421    -0.268     0.200
    80.146     0.740     0.200
    80.158     0.660     0.200
    80.293    -0.308     0.200
    80.954    -0.106     0.200
    81.246    -0.360     0.200
    81.244    -0.248     0.200
    81.333     0.080     0.200
    81.682    -0.563     0.200
    81.740    -0.468     0.200
    81.780    -0.577     0.200
    81.833    -0.062     0.200
    82.273    -0.366     0.200
    82.316    -0.283     0.200
    83.068     0.412     0.200
    83.366    -1.329     0.200
    83.366    -0.829     0.200
    19.740     0.492     0.200
    20.100     0.142     0.200
    25.757    -1.713     0.200
    25.757    -1.537     0.200
    26.822    -1.652     0.200
    27.515    -1.279     0.200
    32.422    -1.661     0.200
    35.864    -2.218     0.200
    42.322    -1.864     0.200
    42.322    -1.614     0.200
    43.780    -1.850     0.200
    52.579    -2.641     0.200
    52.700    -1.998     0.200
    52.700    -1.999     0.200
    54.798    -0.545     0.200
    55.105    -0.859     0.200
    55.105     0.243     0.200
    58.283    -1.677     0.200
    60.610    -2.034     0.200
    60.704    -1.195     0.200
    61.674    -1.962     0.200
    62.651    -2.669     0.200
    63.000    -1.137     0.200
    63.000    -1.285     0.200
    63.109    -1.858     0.200
    63.228    -1.590     0.200
    63.231    -2.307     0.200
    64.550    -1.092     0.200
    65.261    -2.073     0.200
    68.449    -2.448     0.200
    71.425    -2.596     0.200
    72.913    -1.007     0.200
    77.387    -0.871     0.200
    79.494     0.010     0.200
    82.757    -1.054     0.200
    85.496     0.362     0.200
    88.745    -0.250     0.200
    20.455    -0.432     0.200
    21.167     3.025     0.200
    21.427    -1.247     0.200
    21.427    -1.077     0.200
    21.537     3.297     0.200
    21.785    -1.288     0.200
    21.830     2.654     0.200
    21.895     2.591     0.200
    22.705     2.512     0.200
    22.781    -1.320     0.200
    22.798     1.867     0.200
    22.798    -0.998     0.200
    22.902     1.817     0.200
    22.980     1.869     0.200
    23.155     2.428     0.200
    23.155     2.287     0.200
    23.208    -0.221     0.200
    23.382    -0.135     0.200
    23.445     3.553     0.200
    23.650     2.242     0.200
    23.756    -0.304     0.200
    23.785     3.031     0.200
    23.794    -0.144     0.200
    23.968     2.876     0.200
    23.997     2.234     0.200
    24.173    -0.886     0.200
    24.468     2.594     0.200
    24.485     2.423     0.200
    24.555     3.469     0.200
    24.555     3.801     0.200
    24.600     3.301     0.200
    24.747     3.882     0.200
    24.738    -0.057     0.200
    24.953    -0.347     0.200
    25.127    -0.444     0.200
    25.168     2.904     0.200
    25.508     2.594     0.200
    25.558     2.470     0.200
    25.644     3.036     0.200
    25.742    -0.623     0.200
    25.742     1.272     0.200
    26.121     3.015     0.200
    26.806     1.504     0.200
    26.920     2.462     0.200
    27.132     2.720     0.200
    27.363    -2.432     0.200
    27.334    -0.871     0.200
    27.334     1.480     0.200
    27.385     2.734     0.200
    27.621    -1.769     0.200
    27.578    -0.944     0.200
    27.578     2.276     0.200
    27.590     1.830     0.200
    27.765    -0.755     0.200
    27.765     1.293     0.200
    27.742     3.347     0.200
    28.030    -0.802     0.200
    27.921     1.727     0.200
    28.092     1.069     0.200
    28.092    -1.974     0.200
    28.092    -0.700     0.200
    28.105     3.852     0.200
    28.540     0.565     0.200
    28.534     2.416     0.200
    28.636     3.001     0.200
    28.718     2.565     0.200
    28.719     2.594     0.200
    28.887     2.978     0.200
    28.929     2.941     0.200
    29.064     2.839     0.200
    29.108     2.983     0.200
    29.108     3.799     0.200
    29.235     1.826     0.200
    29.259     2.944     0.200
    29.259     2.919     0.200
    29.357     2.361     0.200
    29.358     2.203     0.200
    29.332     2.481     0.200
    29.439     3.063     0.200
    29.498     2.207     0.200
    29.491     1.699     0.200
    29.545     1.962     0.200
    29.605     2.473     0.200
    29.623     2.149     0.200
    29.637     2.476     0.200
    29.680     1.927     0.200
    30.062    -0.316     0.200
    30.062     2.201     0.200
    30.449     1.689     0.200
    30.701     0.237     0.200
    30.701     1.928     0.200
    30.739     1.227     0.200
    30.740     1.555     0.200
    30.740     2.395     0.200
    30.740     2.184     0.200
    30.784     0.067     0.200
    30.784     2.052     0.200
    30.838     0.776     0.200
    30.907    -0.741     0.200
    31.290     3.984     0.200
    31.435     0.092     0.200
    31.435     2.792     0.200
    31.514     0.865     0.200
    32.207     0.242     0.200
    32.330     2.369     0.200
    32.350     2.641     0.200
    32.472     0.511     0.200
    32.451     2.436     0.200
    32.452     1.492     0.200
    32.560     2.779     0.200
    32.750     2.116     0.200
    32.786     2.454     0.200
    32.810    -0.280     0.200
    32.869     2.708     0.200
    32.888     0.432     0.200
    32.922     2.375     0.200
    33.137     1.618     0.200
    33.207     0.650     0.200
    33.275     0.332     0.200
    33.275     2.373     0.200
    33.473     3.054     0.200
    33.682    -0.383     0.200
    33.727     0.010     0.200
    33.860     2.150     0.200
    33.890     0.392     0.200
    33.974     1.812     0.200
    33.988     0.262     0.200
    33.988     1.791     0.200
    34.119    -1.302     0.200
    34.119    -1.981     0.200
    33.978    -0.549     0.200
    34.052     0.205     0.200
    34.073     2.763     0.200
    34.186     0.824     0.200
    34.278     2.063     0.200
    34.301     2.996     0.200
    34.306     1.918     0.200
    34.438     2.563     0.200
    34.436     0.193     0.200
    34.542     2.509     0.200
    34.581     0.226     0.200
    34.642     1.504     0.200
    34.686    -1.167     0.200
    34.768    -0.611     0.200
    34.768     1.728     0.200
    34.821    -0.019     0.200
    34.821     3.199     0.200
    34.930     0.608     0.200
    35.035     0.838     0.200
    35.035     1.918     0.200
    35.136     0.154     0.200
    35.232    -0.191     0.200
    35.310     0.314     0.200
    35.263     0.174     0.200
    35.263     2.076     0.200
    35.298     2.045     0.200
    35.434     2.898     0.200
    35.552    -0.758     0.200
    35.734    -0.937     0.200
    35.734     1.090     0.200
    35.760     0.320     0.200
    35.760     2.960     0.200
    35.855    -0.918     0.200
    35.855     1.125     0.200
    35.854     2.612     0.200
    35.985     1.895     0.200
    36.092     1.982     0.200
    36.141    -1.227     0.200
    36.248    -1.623     0.200
    36.475     2.438     0.200
    36.538     2.807     0.200
    36.720    -0.688     0.200
    36.897     0.617     0.200
    36.897     1.671     0.200
    37.088     0.646     0.200
    37.123     0.782     0.200
    37.123     2.546     0.200
    37.116     0.588     0.200
    37.198    -0.560     0.200
    37.198     0.507     0.200
    37.307    -0.491     0.200
    37.326    -0.921     0.200
    37.326     0.870     0.200
    37.515    -1.925     0.200
    37.515    -2.486     0.200
    37.519    -0.266     0.200
    37.519     1.002     0.200
    37.548     0.538     0.200
    37.854     1.468     0.200
    37.854     2.423     0.200
    37.907     0.726     0.200
    37.907     2.049     0.200
    38.052     1.515     0.200
    38.053     2.712     0.200
    38.053     1.706     0.200
    38.053     2.087     0.200
    38.054     1.323     0.200
    38.118    -0.602     0.200
    38.119    -0.244     0.200
    38.135    -0.651     0.200
    38.315     0.635     0.200
    38.315     1.733     0.200
    38.350     0.022     0.200
    38.710     0.163     0.200
    38.772     1.091     0.200
    38.865    -0.078     0.200
    38.844     0.422     0.200
    38.844     1.600     0.200
    39.161     0.649     0.200
    39.153     0.723     0.200
    39.222     1.600     0.200
    39.323     0.621     0.200
    39.366     1.660     0.200
    39.437     0.317     0.200
    39.467     0.501     0.200
    39.697     0.382     0.200
    39.716     0.254     0.200
    39.737     1.550     0.200
    39.736    -0.129     0.200
    39.836     0.745     0.200
    39.901     0.236     0.200
    40.013     0.644     0.200
    40.022     0.909     0.200
    40.022     1.230     0.200
    40.160     0.044     0.200
    40.260     0.599     0.200
    40.278     1.625     0.200
    40.369     0.712     0.200
    40.519     1.974     0.200
    40.487     2.579     0.200
    40.622     0.224     0.200
    40.664     1.216     0.200
    40.664     1.695     0.200
    40.670     0.642     0.200
    40.707     0.296     0.200
    40.662     0.281     0.200
    40.797     0.142     0.200
    40.765     0.708     0.200
    40.765     2.265     0.200
    40.879     0.498     0.200
    40.963     0.311     0.200
    41.030    -0.578     0.200
    41.142     0.731     0.200
    41.133     0.937     0.200
    41.133     2.968     0.200
    41.220     0.288     0.200
    41.264     0.268     0.200
    41.374     0.747     0.200
    41.410    -1.066     0.200
    41.396    -0.355     0.200
    41.528     0.051     0.200
    41.651    -0.539     0.200
    41.680     0.679     0.200
    41.702    -0.482     0.200
    41.783     0.761     0.200
    42.105    -0.123     0.200
    42.101    -0.215     0.200
    42.204     0.018     0.200
    42.243    -0.011     0.200
    42.345     1.659     0.200
    42.403    -0.314     0.200
    42.494     0.259     0.200
    42.562    -0.246     0.200
    42.562     0.926     0.200
    42.791    -0.217     0.200
    42.892    -0.701     0.200
    42.927    -0.650     0.200
    43.149    -2.730     0.200
    43.111    -0.681     0.200
    43.110    -0.569     0.200
    43.170    -1.237     0.200
    43.284     0.373     0.200
    43.284     0.104     0.200
    43.319    -1.529     0.200
    43.353    -0.918     0.200
    43.417    -0.543     0.200
    43.458    -0.180     0.200
    43.570    -0.730     0.200
    43.478    -0.191     0.200
    43.622    -1.439     0.200
    43.688    -0.705     0.200
    43.777    -1.577     0.200
    43.803    -0.719     0.200
    43.821    -0.351     0.200
    43.830    -1.153     0.200
    43.854    -0.207     0.200
    43.904     2.454     0.200
    43.904     2.554     0.200
    44.050    -0.736     0.200
    44.050     0.535     0.200
    44.111    -1.518     0.200
    44.137    -1.323     0.200
    44.341    -1.892     0.200
    44.396    -1.228     0.200
    44.425    -0.462     0.200
    44.485    -0.239     0.200
    44.495    -0.972     0.200
    44.503    -0.615     0.200
    44.614    -0.743     0.200
    44.676    -0.654     0.200
    44.739     0.311     0.200
    44.922    -0.124     0.200
    44.918    -0.352     0.200
    45.088    -0.837     0.200
    45.067    -0.254     0.200
    45.145     0.199     0.200
    45.134    -0.889     0.200
    45.148    -0.406     0.200
    45.148     1.256     0.200
    45.199    -1.199     0.200
    45.279    -0.962     0.200
    45.277    -0.996     0.200
    45.336    -1.012     0.200
    45.336     0.131     0.200
    45.507    -0.870     0.200
    45.659    -0.713     0.200
    45.756    -0.147     0.200
    45.787    -1.464     0.200
    46.010    -0.160     0.200
    46.079     1.087     0.200
    46.384    -3.518     0.200
    46.781    -0.958     0.200
    46.728    -0.916     0.200
    46.769    -0.195     0.200
    47.013    -0.118     0.200
    47.323    -0.309     0.200
    47.323     1.575     0.200
    47.391     0.067     0.200
    47.395    -0.465     0.200
    47.598     1.502     0.200
    47.605     0.637     0.200
    47.650    -1.120     0.200
    47.756    -2.015     0.200
    47.869    -0.576     0.200
    47.912     0.946     0.200
    47.966     0.409     0.200
    48.034     0.514     0.200
    48.105    -1.570     0.200
    48.162    -0.152     0.200
    48.162     0.270     0.200
    48.311    -0.286     0.200
    48.349     1.018     0.200
    48.457    -0.079     0.200
    48.508    -1.108     0.200
    48.423    -1.402     0.200
    48.499    -1.243     0.200
    48.647    -1.513     0.200
    48.927    -1.385     0.200
    48.994    -1.255     0.200
    48.994     1.117     0.200
    49.038     0.956     0.200
    49.157    -1.125     0.200
    49.258    -0.908     0.200
    49.328    -0.467     0.200
    49.359    -0.962     0.200
    49.363    -0.682     0.200
    49.363     1.343     0.200
    49.370    -0.432     0.200
    49.390    -1.005     0.200
    49.458    -0.787     0.200
    49.458     1.043     0.200
    49.519    -0.707     0.200
    49.638     1.040     0.200
    49.656    -0.028     0.200
    49.754    -0.280     0.200
    49.786    -0.643     0.200
    49.786     0.740     0.200
    50.008    -1.671     0.200
    50.061    -1.075     0.200
    50.083    -0.898     0.200
    50.133     0.339     0.200
    50.227    -1.415     0.200
    50.219    -0.640     0.200
    50.387    -0.356     0.200
    50.474    -0.218     0.200
    50.508    -0.328     0.200
    50.576    -0.151     0.200
    50.613    -1.137     0.200
    50.589    -0.141     0.200
    50.652    -1.687     0.200
    50.611    -0.868     0.200
    50.817    -1.130     0.200
    50.847     1.232     0.200
    51.071    -0.871     0.200
    51.285    -1.559     0.200
    51.384    -0.939     0.200
    51.385    -1.585     0.200
    51.609     0.425     0.200
    51.612    -0.715     0.200
    51.694    -0.703     0.200
    51.738    -0.872     0.200
    51.780    -0.755     0.200
    51.826    -1.185     0.200
    51.865    -0.108     0.200
    51.921    -0.396     0.200
    52.112    -0.786     0.200
    52.185    -0.549     0.200
    52.213    -0.861     0.200
    52.292     0.556     0.200
    52.396    -0.302     0.200
    53.268     1.618     0.200
    53.391     0.283     0.200
    53.718    -0.856     0.200
    53.935    -1.144     0.200
    53.935    -1.041     0.200
    53.935    -0.881     0.200
    54.009    -1.310     0.200
    54.009    -1.311     0.200
    54.963    -1.516     0.200
    54.963    -0.196     0.200
    54.963    -0.446     0.200
    56.042     0.289     0.200
    56.102    -1.237     0.200
    56.421    -0.595     0.200
    56.421    -0.816     0.200
    56.719    -0.581     0.200
    56.732    -0.422     0.200
    58.235    -1.216     0.200
    58.407    -0.423     0.200
    59.717    -0.806     0.200
    59.727     1.630     0.200
    59.980    -0.797     0.200
    59.980    -0.890     0.200
    59.980    -1.056     0.200
    60.985    -1.175     0.200
    61.540    -0.882     0.200
    61.640    -0.142     0.200
    61.780    -1.420     0.200
    61.783    -0.395     0.200
    61.808    -1.171     0.200
    61.811    -0.862     0.200
    61.977    -0.617     0.200
    62.063    -0.487     0.200
    62.064    -0.763     0.200
    62.251    -1.916     0.200
    62.698     0.097     0.200
    62.901    -0.586     0.200
    62.900     0.653     0.200
    63.041    -0.597     0.200
    63.041     0.012     0.200
    63.518    -0.846     0.200
    64.272    -1.589     0.200
    64.272    -1.408     0.200
    64.696    -0.866     0.200
    64.805    -0.991     0.200
    64.905    -1.016     0.200
    64.909    -1.371     0.200
    64.909    -1.043     0.200
    65.058    -0.541     0.200
    65.531    -0.121     0.200
    65.539    -0.099     0.200
    66.958    -0.909     0.200
    66.958    -1.133     0.200
    66.958    -0.959     0.200
    66.975    -0.958     0.200
    67.051    -0.880     0.200
    67.179    -0.865     0.200
    67.602     0.660     0.200
    68.150    -0.787     0.200
    68.740    -0.981     0.200
    70.084    -1.041     0.200
    70.823    -1.203     0.200
    70.823    -0.783     0.200
    70.952    -0.390     0.200
    71.455    -0.934     0.200
    71.604    -0.231     0.200
    71.806     0.054     0.200
    71.852    -0.123     0.200
    71.860    -1.870     0.200
    72.099    -2.903     0.200
    72.115     0.016     0.200
    72.586     0.325     0.200
    72.586    -0.115     0.200
    72.617     0.370     0.200
    72.782     0.142     0.200
    72.816     0.417     0.200
    72.822    -1.244     0.200
    72.822    -0.775     0.200
    72.829    -1.096     0.200
    72.829    -1.256     0.200
    72.939    -1.519     0.200
    72.973    -0.514     0.200
    72.988     0.380     0.200
    73.030     0.383     0.200
    73.389     0.397     0.200
    73.457     0.808     0.200
    73.679     0.925     0.200
    73.813     0.838     0.200
    73.813     0.598     0.200
    73.839     0.087     0.200
    73.845     0.450     0.200
    73.872    -0.008     0.200
    73.897     1.008     0.200
    73.936    -0.183     0.200
    73.959    -0.565     0.200
    73.959    -0.565     0.200
    74.016     0.340     0.200
    74.104    -0.163     0.200
    74.108     0.290     0.200
    74.116     0.247     0.200
    74.114    -0.125     0.200
    74.368    -0.201     0.200
    74.390     0.171     0.200
    74.622    -0.081     0.200
    74.821     0.167     0.200
    74.833    -0.302     0.200
    74.848    -0.190     0.200
    74.862    -0.370     0.200
    75.008    -0.713     0.200
    75.080    -1.128     0.200
    75.144     0.876     0.200
    75.193     0.738     0.200
    75.264     0.905     0.200
    75.341    -0.724     0.200
    75.400     0.766     0.200
    75.445     0.273     0.200
    75.450     0.686     0.200
    75.477     0.365     0.200
    75.536     3.052     0.200
    75.621     0.503     0.200
    75.828     0.862     0.200
    75.841     0.246     0.200
    75.884     0.017     0.200
    75.884    -0.339     0.200
    75.910    -0.121     0.200
    76.076     1.845     0.200
    76.299     0.218     0.200
    76.371     0.671     0.200
    76.464    -1.841     0.200
    76.499     0.421     0.200
    76.628     2.431     0.200
    76.749     1.049     0.200
    77.994    -0.325     0.200
    78.046     0.770     0.200
    78.313     1.381     0.200
    78.733    -0.007     0.200
    79.085     0.061     0.200
    80.335     0.061     0.200
    80.346     0.705     0.200
    80.890    -0.371     0.200
    80.895    -0.568     0.200
    81.771    -0.097     0.200
    82.020    -0.961     0.200
    82.020     0.103     0.200
    82.132     0.126     0.200
    82.221     0.559     0.200
    82.299    -1.800     0.200
    82.326     1.039     0.200
    82.489     0.058     0.200
    82.569     0.042     0.200
    82.635    -0.634     0.200
    82.638    -1.147     0.200
    82.623     0.458     0.200
    82.669    -0.077     0.200
    82.721     0.152     0.200
    83.201    -0.137     0.200
    83.359    -0.273     0.200
    83.548     0.405     0.200
    83.576     1.043     0.200
    83.653    -0.193     0.200
    83.653    -0.714     0.200
    84.239    -1.302     0.200
    84.263    -1.284     0.200
    85.037    -0.253     0.200
    86.748     0.643     0.200
    19.102    -2.798     0.200
    20.055     0.151     0.200
    20.298     0.210     0.200
    20.304     0.367     0.200
    20.837     0.485     0.200
    21.347     1.597     0.200
    21.422     1.814     0.200
    21.492     1.218     0.200
    21.503     1.380     0.200
    21.713     1.455     0.200
    21.930     1.736     0.200
    22.020     0.783     0.200
    22.108     0.975     0.200
    22.332     1.884     0.200
    22.851     1.326     0.200
    22.889     1.417     0.200
    22.924     0.830     0.200
    22.941     1.309     0.200
    23.010     1.092     0.200
    23.008     1.636     0.200
    23.094     0.585     0.200
    23.167     0.597     0.200
    23.265     1.408     0.200
    23.309     1.920     0.200
    23.342     0.912     0.200
    23.363     1.127     0.200
    23.531     1.012     0.200
    23.545     2.148     0.200
    23.848     0.612     0.200
    23.886     1.993     0.200
    23.899     1.578     0.200
    23.901     1.469     0.200
    24.114     1.740     0.200
    24.175     0.929     0.200
    24.311     2.289     0.200
    24.507     2.118     0.200
    24.663     2.152     0.200
    24.663     1.894     0.200
    24.678     0.492     0.200
    24.682     1.198     0.200
    24.687     0.205     0.200
    24.717     0.659     0.200
    24.791     2.099     0.200
    24.842     2.260     0.200
    24.881     2.175     0.200
    25.070     1.866     0.200
    25.228     2.318     0.200
    25.242     1.256     0.200
    25.299     2.114     0.200
    25.352     1.383     0.200
    25.606     1.552     0.200
    25.718     0.616     0.200
    25.773     1.298     0.200
    25.775     1.489     0.200
    25.967     1.758     0.200
    25.967     1.000     0.200
    26.192     1.007     0.200
    26.271     1.441     0.200
    26.560     3.200     0.200
    26.840    -1.849     0.200
    26.903    -0.915     0.200
    27.100     1.171     0.200
    27.331    -2.349     0.200
    27.331    -2.474     0.200
    27.439    -1.855     0.200
    27.439    -1.339     0.200
    27.398     1.167     0.200
    27.592     0.717     0.200
    27.592     0.600     0.200
    27.603     1.575     0.200
    27.631     2.927     0.200
    27.768     1.330     0.200
    27.768     1.166     0.200
    27.801     1.304     0.200
    27.913    -1.860     0.200
    27.915    -2.136     0.200
    27.915    -1.870     0.200
    27.915    -2.003     0.200
    27.859     1.247     0.200
    27.962    -0.032     0.200
    27.990     1.029     0.200
    28.032     2.093     0.200
    28.214     2.089     0.200
    28.416     0.212     0.200
    28.416    -0.132     0.200
    28.475     1.405     0.200
    28.741     1.803     0.200
    28.972    -1.262     0.200
    28.972    -2.769     0.200
    28.939     2.110     0.200
    29.008     1.555     0.200
    29.111     1.139     0.200
    29.149     2.522     0.200
    29.281     2.383     0.200
    29.328     2.778     0.200
    29.328     0.880     0.200
    29.373     1.395     0.200
    29.373     1.708     0.200
    29.449     1.836     0.200
    29.447     1.124     0.200
    29.460     2.373     0.200
    29.591     1.579     0.200
    29.591     1.829     0.200
    29.592     2.066     0.200
    29.617     3.052     0.200
    29.646     2.209     0.200
    29.716     2.219     0.200
    29.818     1.695     0.200
    29.846     2.644     0.200
    29.863     2.101     0.200
    29.950    -2.368     0.200
    30.323     1.594     0.200
    30.320     1.582     0.200
    30.366     1.828     0.200
    30.415     1.319     0.200
    30.467     2.485     0.200
    30.511     1.362     0.200
    30.639     1.409     0.200
    30.835     1.362     0.200
    30.835     1.136     0.200
    30.951     1.032     0.200
    30.951     0.727     0.200
    30.948     1.680     0.200
    30.951     1.147     0.200
    30.951     1.186     0.200
    30.951     0.467     0.200
    30.954     1.325     0.200
    30.954     1.130     0.200
    30.969     1.787     0.200
    30.993     1.251     0.200
    31.021     1.777     0.200
    31.062     0.072     0.200
    31.392     1.777     0.200
    31.400     1.786     0.200
    31.436     0.803     0.200
    31.436     1.099     0.200
    31.554     1.706     0.200
    31.554     1.120     0.200
    31.606     1.679     0.200
    31.613     1.592     0.200
    31.616     1.541     0.200
    31.810     1.696     0.200
    31.974     1.139     0.200
    32.210     1.696     0.200
    32.295     0.271     0.200
    32.352     1.496     0.200
    32.393     1.603     0.200
    32.453     1.274     0.200
    32.511     2.082     0.200
    32.553     1.236     0.200
    32.553     1.642     0.200
    32.585     1.820     0.200
    32.596     1.805     0.200
    32.699     0.995     0.200
    32.707     1.260     0.200
    32.742     2.092     0.200
    32.794     1.590     0.200
    32.853     1.808     0.200
    32.892     1.405     0.200
    32.962     1.539     0.200
    32.966     0.036     0.200
    32.974     1.417     0.200
    33.119     1.121     0.200
    33.119     1.378     0.200
    33.162     1.354     0.200
    33.230     1.260     0.200
    33.296     1.595     0.200
    33.472     1.263     0.200
    33.472     0.857     0.200
    33.537     1.464     0.200
    33.561     0.895     0.200
    33.586     0.542     0.200
    33.716     0.974     0.200
    33.965     0.275     0.200
    33.965     0.479     0.200
    33.988     1.314     0.200
    34.070     0.787     0.200
    34.070     1.092     0.200
    34.072     1.076     0.200
    34.079     0.951     0.200
    34.093     1.415     0.200
    34.154     1.115     0.200
    34.228    -1.286     0.200
    34.228    -1.771     0.200
    34.228    -1.997     0.200
    34.195     1.250     0.200
    34.205     1.078     0.200
    34.205     1.398     0.200
    34.254     1.665     0.200
    34.292     1.466     0.200
    34.315     0.708     0.200
    34.335     1.417     0.200
    34.358     1.116     0.200
    34.407     1.107     0.200
    34.408     0.983     0.200
    34.440     1.383     0.200
    34.459     1.112     0.200
    34.465     1.389     0.200
    34.486     1.120     0.200
    34.536     0.870     0.200
    34.570     0.430     0.200
    34.580     0.986     0.200
    34.668     1.421     0.200
    34.686     1.307     0.200
    34.716     0.898     0.200
    34.723     1.107     0.200
    34.840     1.249     0.200
    34.929     1.409     0.200
    34.929     0.237     0.200
    34.933     1.142     0.200
    35.017     1.324     0.200
    35.076     0.808     0.200
    35.076     0.394     0.200
    35.146     1.010     0.200
    35.146     1.932     0.200
    35.179     1.550     0.200
    35.332     0.962     0.200
    35.441     0.651     0.200
    35.438     1.000     0.200
    35.624     0.562     0.200
    35.727     1.002     0.200
    35.949     1.752     0.200
    35.949     0.564     0.200
    35.975     0.733     0.200
    35.990     1.573     0.200
    36.196     0.388     0.200
    36.196    -0.159     0.200
    36.452     0.631     0.200
    36.527     0.874     0.200
    36.672     1.463     0.200
    36.672     1.362     0.200
    36.783     0.825     0.200
    36.910     0.793     0.200
    36.913     0.789     0.200
    37.034     0.798     0.200
    37.207     1.152     0.200
    37.207     0.933     0.200
    37.225     1.063     0.200
    37.343     1.793     0.200
    37.343     1.231     0.200
    37.404     0.703     0.200
    37.519    -2.734     0.200
    37.519    -2.305     0.200
    37.476     0.178     0.200
    37.476    -0.009     0.200
    37.560     0.346     0.200
    37.616    -2.126     0.200
    37.619     0.431     0.200
    37.645     0.358     0.200
    37.645    -0.181     0.200
    37.708     1.919     0.200
    37.708     1.630     0.200
    37.821     0.653     0.200
    37.838     0.917     0.200
    37.902    -0.044     0.200
    37.980     1.318     0.200
    38.091     1.045     0.200
    38.165     0.973     0.200
    38.224     1.185     0.200
    38.226     1.347     0.200
    38.226     0.300     0.200
    38.226     0.941     0.200
    38.226     0.302     0.200
    38.397     0.329     0.200
    38.430     0.627     0.200
    38.430     0.369     0.200
    38.615     0.594     0.200
    38.639     0.752     0.200
    38.639     1.284     0.200
    38.657     0.506     0.200
    38.724     1.034     0.200
    38.920     0.866     0.200
    38.920    -0.603     0.200
    38.994     0.331     0.200
    39.058    -2.465     0.200
    39.064     0.848     0.200
    39.064     0.512     0.200
    39.078     1.096     0.200
    39.112     0.413     0.200
    39.168     0.444     0.200
    39.205     0.674     0.200
    39.251     1.075     0.200
    39.320    -2.009     0.200
    39.320    -1.244     0.200
    39.370     1.665     0.200
    39.389     0.503     0.200
    39.425     1.204     0.200
    39.440     0.615     0.200
    39.467     0.561     0.200
    39.635     0.385     0.200
    39.634     0.783     0.200
    39.751     0.273     0.200
    39.759     0.942     0.200
    39.759     0.067     0.200
    39.794     0.042     0.200
    39.843    -0.255     0.200
    39.917    -0.485     0.200
    39.988    -0.034     0.200
    40.006     0.781     0.200
    40.006     0.211     0.200
    40.027    -0.306     0.200
    40.053    -0.057     0.200
    40.115     0.615     0.200
    40.198     0.553     0.200
    40.300     0.398     0.200
    40.309     0.723     0.200
    40.335     0.851     0.200
    40.434     0.760     0.200
    40.438     0.323     0.200
    40.503     0.035     0.200
    40.543     0.552     0.200
    40.559     1.026     0.200
    40.595     0.840     0.200
    40.608     0.173     0.200
    40.608     0.915     0.200
    40.669     0.665     0.200
    40.756    -0.194     0.200
    40.789     0.906     0.200
    40.789     0.507     0.200
    40.810     0.747     0.200
    40.862     1.183     0.200
    40.862     0.089     0.200
    40.900     0.673     0.200
    40.927     0.372     0.200
    40.953     1.040     0.200
    40.953     0.368     0.200
    40.968     0.772     0.200
    40.984     0.602     0.200
    40.984     0.336     0.200
    41.030     0.541     0.200
    41.030    -0.225     0.200
    41.083     0.151     0.200
    41.214    -1.664     0.200
    41.214    -1.953     0.200
    41.231     0.789     0.200
    41.283     0.768     0.200
    41.292     1.196     0.200
    41.292     0.477     0.200
    41.304     0.557     0.200
    41.345    -0.146     0.200
    41.374    -0.259     0.200
    41.374     0.194     0.200
    41.402     0.567     0.200
    41.402    -0.074     0.200
    41.449     1.184     0.200
    41.516    -0.027     0.200
    41.516    -0.480     0.200
    41.520     0.505     0.200
    41.552    -0.196     0.200
    41.599     0.139     0.200
    41.599     0.607     0.200
    41.635     0.502     0.200
    41.651     0.157     0.200
    41.691    -0.024     0.200
    41.837     0.754     0.200
    41.840    -0.053     0.200
    41.863    -0.233     0.200
    41.942    -0.370     0.200
    41.947     0.450     0.200
    41.947     0.082     0.200
    41.961    -0.113     0.200
    42.013    -0.239     0.200
    42.021     0.768     0.200
    42.057     0.442     0.200
    42.101     0.038     0.200
    42.154     0.213     0.200
    42.306    -2.363     0.200
    42.306    -1.972     0.200
    42.265     0.417     0.200
    42.364     0.113     0.200
    42.392     0.842     0.200
    42.473     0.222     0.200
    42.519     0.215     0.200
    42.560     1.141     0.200
    42.611     0.647     0.200
    42.660     0.110     0.200
    42.677    -0.135     0.200
    42.705     0.036     0.200
    42.751     0.751     0.200
    42.832    -0.141     0.200
    42.834    -0.240     0.200
    43.086    -2.003     0.200
    43.071    -0.127     0.200
    43.142    -0.168     0.200
    43.147    -0.676     0.200
    43.195    -0.173     0.200
    43.221    -0.229     0.200
    43.278    -0.012     0.200
    43.346     0.376     0.200
    43.360    -0.151     0.200
    43.427    -0.960     0.200
    43.443    -0.048     0.200
    43.457    -0.575     0.200
    43.584    -0.451     0.200
    43.584    -0.608     0.200
    43.663    -1.959     0.200
    43.661    -0.008     0.200
    43.661     0.656     0.200
    43.677     0.211     0.200
    43.677     0.336     0.200
    43.690    -0.173     0.200
    43.737    -0.351     0.200
    43.755     0.398     0.200
    43.876    -0.497     0.200
    43.922    -0.845     0.200
    43.948    -0.105     0.200
    44.060     1.133     0.200
    44.061     1.666     0.200
    44.061     1.666     0.200
    44.072    -0.454     0.200
    44.105    -0.403     0.200
    44.114    -0.041     0.200
    44.161     0.682     0.200
    44.161     0.440     0.200
    44.152     0.229     0.200
    44.190     0.390     0.200
    44.282    -0.369     0.200
    44.318    -0.375     0.200
    44.318     0.461     0.200
    44.376    -0.218     0.200
    44.375    -0.500     0.200
    44.510     0.433     0.200
    44.546    -0.348     0.200
    44.587    -0.873     0.200
    44.649    -1.398     0.200
    44.667     0.037     0.200
    44.689    -0.057     0.200
    44.717     0.401     0.200
    44.756     0.077     0.200
    44.772    -1.612     0.200
    44.971    -0.239     0.200
    44.981     0.049     0.200
    45.067    -0.474     0.200
    45.067    -0.763     0.200
    45.137    -2.044     0.200
    45.137    -1.450     0.200
    45.175    -1.585     0.200
    45.271     0.428     0.200
    45.293    -0.942     0.200
    45.304     0.465     0.200
    45.354    -0.293     0.200
    45.401    -1.017     0.200
    45.401    -0.454     0.200
    45.425     0.644     0.200
    45.429    -0.345     0.200
    45.442    -0.068     0.200
    45.544    -0.094     0.200
    45.547    -0.773     0.200
    45.576    -0.664     0.200
    45.575    -0.099     0.200
    45.576     0.408     0.200
    45.576     0.596     0.200
    45.664    -1.251     0.200
    45.677    -0.013     0.200
    45.683     0.116     0.200
    45.708    -0.023     0.200
    45.708    -0.304     0.200
    45.788     0.007     0.200
    45.855     0.217     0.200
    45.848     0.114     0.200
    45.860     0.558     0.200
    45.915    -0.316     0.200
    45.929    -0.381     0.200
    46.049    -0.698     0.200
    46.118    -0.994     0.200
    46.132    -0.111     0.200
    46.167    -0.289     0.200
    46.210     0.029     0.200
    46.269     0.070     0.200
    46.344    -0.248     0.200
    46.352    -0.346     0.200
    46.361    -0.241     0.200
    46.530    -0.385     0.200
    46.534    -0.212     0.200
    46.551     0.425     0.200
    46.603     0.596     0.200
    46.629    -0.738     0.200
    46.632     0.090     0.200
    46.718    -0.323     0.200
    46.848    -2.709     0.200
    46.852    -0.844     0.200
    46.866    -0.566     0.200
    46.898     0.194     0.200
    46.928    -0.015     0.200
    46.962    -0.199     0.200
    47.038    -1.438     0.200
    47.061    -0.717     0.200
    47.149     0.314     0.200
    47.149    -0.045     0.200
    47.217     0.188     0.200
    47.220    -0.313     0.200
    47.315    -0.466     0.200
    47.321    -0.304     0.200
    47.321    -0.140     0.200
    47.372     0.183     0.200
    47.372     0.292     0.200
    47.468     0.087     0.200
    47.509     0.312     0.200
    47.595     0.458     0.200
    47.595    -0.120     0.200
    47.617     0.117     0.200
    47.647    -0.300     0.200
    47.667     0.382     0.200
    47.677     0.096     0.200
    47.676     0.563     0.200
    47.708     0.220     0.200
    47.760    -0.569     0.200
    47.818    -1.774     0.200
    47.800    -0.894     0.200
    47.872     0.058     0.200
    47.909    -0.037     0.200
    47.970    -0.279     0.200
    47.976    -0.057     0.200
    47.983     0.047     0.200
    47.987    -0.124     0.200
    48.031    -0.018     0.200
    48.155    -0.259     0.200
    48.153    -0.090     0.200
    48.216    -0.544     0.200
    48.216    -0.364     0.200
    48.215     0.653     0.200
    48.223     0.988     0.200
    48.314    -0.201     0.200
    48.333    -0.790     0.200
    48.403    -1.205     0.200
    48.363    -0.151     0.200
    48.365     0.237     0.200
    48.369     0.176     0.200
    48.425    -0.401     0.200
    48.437     0.304     0.200
    48.449    -0.136     0.200
    48.599    -0.368     0.200
    48.601     0.251     0.200
    48.649     0.652     0.200
    48.648     0.131     0.200
    48.681    -0.316     0.200
    48.729    -0.879     0.200
    48.751     0.716     0.200
    48.764     0.015     0.200
    48.817    -0.166     0.200
    48.879    -1.282     0.200
    48.879    -1.351     0.200
    48.879    -1.777     0.200
    48.879    -1.777     0.200
    48.835    -0.535     0.200
    48.835     0.176     0.200
    48.852    -0.809     0.200
    48.896    -1.303     0.200
    48.926    -1.607     0.200
    49.036    -0.302     0.200
    49.049     1.048     0.200
    49.088    -0.377     0.200
    49.129    -0.536     0.200
    49.179    -1.529     0.200
    49.201    -0.507     0.200
    49.365     0.147     0.200
    49.427    -0.652     0.200
    49.427    -0.784     0.200
    49.438    -1.203     0.200
    49.470     1.288     0.200
    49.480    -0.020     0.200
    49.494     0.818     0.200
    49.555    -1.886     0.200
    49.518    -0.065     0.200
    49.553    -0.431     0.200
    49.615    -0.123     0.200
    49.628     0.530     0.200
    49.654     0.379     0.200
    49.668    -0.312     0.200
    49.680    -0.477     0.200
    49.685    -0.585     0.200
    49.685    -0.117     0.200
    49.754     0.122     0.200
    49.782     0.051     0.200
    49.782    -0.512     0.200
    49.780     0.263     0.200
    49.839    -0.608     0.200
    49.864     0.201     0.200
    49.871    -0.325     0.200
    49.911    -0.791     0.200
    49.911    -0.526     0.200
    50.002    -0.789     0.200
    50.027    -0.202     0.200
    50.142     0.037     0.200
    50.190     0.382     0.200
    50.319     0.031     0.200
    50.359    -0.433     0.200
    50.410    -2.489     0.200
    50.495    -0.378     0.200
    50.527    -1.722     0.200
    50.484    -0.119     0.200
    50.510     0.141     0.200
    50.696    -0.525     0.200
    50.700    -0.054     0.200
    50.709    -0.304     0.200
    50.722    -0.018     0.200
    50.875    -0.745     0.200
    50.880    -0.342     0.200
    50.892    -1.173     0.200
    50.972    -0.706     0.200
    50.972    -0.816     0.200
    51.074    -0.586     0.200
    51.073    -0.704     0.200
    51.133     0.144     0.200
    51.148    -0.254     0.200
    51.293    -0.022     0.200
    51.545    -1.472     0.200
    51.596    -0.535     0.200
    51.663    -0.398     0.200
    51.902    -0.026     0.200
    51.902    -0.261     0.200
    51.934    -1.295     0.200
    52.016    -0.433     0.200
    52.057    -1.141     0.200
    52.065    -0.676     0.200
    52.070    -0.401     0.200
    52.109    -1.512     0.200
    52.446    -0.405     0.200
    52.492    -0.783     0.200
    52.815    -0.505     0.200
    52.869    -0.184     0.200
    53.645     0.227     0.200
    53.808    -1.416     0.200
    53.838    -0.983     0.200
    53.824    -1.769     0.200
    53.824    -1.129     0.200
    53.838    -0.851     0.200
    53.838    -0.984     0.200
    54.237    -0.896     0.200
    54.237    -0.896     0.200
    54.296    -1.473     0.200
    54.477    -1.211     0.200
    54.908    -1.012     0.200
    54.975    -0.783     0.200
    55.444    -1.431     0.200
    55.706    -2.366     0.200
    56.061    -0.012     0.200
    56.109    -1.353     0.200
    56.399    -1.244     0.200
    56.399    -0.822     0.200
    56.699    -0.544     0.200
    56.712    -0.267     0.200
    56.712    -0.267     0.200
    57.989    -1.160     0.200
    58.009    -1.606     0.200
    59.304    -0.817     0.200
    59.648    -0.491     0.200
    59.824    -0.904     0.200
    60.074    -0.767     0.200
    60.077    -1.449     0.200
    60.077    -0.792     0.200
    60.077    -1.324     0.200
    61.235    -2.630     0.200
    61.643    -0.292     0.200
    61.875    -0.800     0.200
    61.975    -0.673     0.200
    62.113    -0.815     0.200
    62.119    -0.796     0.200
    62.143    -0.542     0.200
    62.146    -0.767     0.200
    62.146    -0.595     0.200
    62.312    -0.804     0.200
    62.366    -0.547     0.200
    62.365    -1.440     0.200
    62.366    -0.547     0.200
    62.474    -0.945     0.200
    62.518    -3.257     0.200
    62.746     0.316     0.200
    63.231    -0.536     0.200
    63.380    -0.255     0.200
    63.380    -0.692     0.200
    63.713    -0.788     0.200
    64.473    -1.413     0.200
    64.805    -1.443     0.200
    64.805    -1.052     0.200
    64.914    -0.965     0.200
    65.055    -1.223     0.200
    65.055    -0.973     0.200
    65.058    -1.400     0.200
    65.058    -0.845     0.200
    65.359    -1.045     0.200
    65.896    -0.291     0.200
    66.282    -0.995     0.200
    66.287    -1.232     0.200
    67.037    -1.481     0.200
    67.037    -1.090     0.200
    67.037    -1.090     0.200
    67.037    -1.621     0.200
    67.055    -1.621     0.200
    67.115    -0.615     0.200
    67.132    -1.338     0.200
    67.132    -1.517     0.200
    67.646     0.329     0.200
    67.734    -0.825     0.200
    68.149    -1.515     0.200
    68.257    -0.682     0.200
    68.421    -1.549     0.200
    68.421    -1.346     0.200
    68.478    -0.725     0.200
    68.514    -0.724     0.200
    69.024    -1.501     0.200
    69.103    -0.684     0.200
    69.783    -1.033     0.200
    69.783    -0.908     0.200
    70.275    -1.089     0.200
    70.275    -1.316     0.200
    70.293    -0.018     0.200
    70.640     0.049     0.200
    71.004    -1.451     0.200
    71.032    -0.523     0.200
    71.370    -0.270     0.200
    71.462    -0.255     0.200
    71.644    -0.139     0.200
    71.709    -0.071     0.200
    71.734     0.239     0.200
    71.870    -0.096     0.200
    71.911    -1.823     0.200
    71.940    -0.408     0.200
    71.940    -0.853     0.200
    71.962    -0.226     0.200
    72.121    -1.683     0.200
    72.149     0.508     0.200
    72.181    -0.044     0.200
    72.359    -2.006     0.200
    72.450    -0.136     0.200
    72.653     0.172     0.200
    72.683     0.291     0.200
    72.683    -0.240     0.200
    72.720    -0.047     0.200
    72.815     0.348     0.200
    72.815     0.004     0.200
    72.842     0.414     0.200
    72.873    -0.870     0.200
    72.883     0.105     0.200
    72.957     0.533     0.200
    72.968     0.270     0.200
    73.074     0.540     0.200
    73.080     0.337     0.200
    73.091     0.190     0.200
    73.115    -1.472     0.200
    73.115    -1.300     0.200
    73.115    -1.370     0.200
    73.129     0.445     0.200
    73.122    -1.701     0.200
    73.122    -1.131     0.200
    73.122    -1.240     0.200
    73.138    -2.190     0.200
    73.146     0.619     0.200
    73.290     0.282     0.200
    73.290    -0.366     0.200
    73.287     0.487     0.200
    73.376     0.248     0.200
    73.377     0.152     0.200
    73.449     0.429     0.200
    73.468    -0.001     0.200
    73.468    -0.494     0.200
    73.470     0.206     0.200
    73.494     0.284     0.200
    73.553     0.638     0.200
    73.767    -0.042     0.200
    73.793     0.103     0.200
    73.793    -0.616     0.200
    73.793    -0.296     0.200
    73.998    -0.594     0.200
    74.046    -0.469     0.200
    74.079    -1.142     0.200
    74.079    -1.142     0.200
    74.150     0.425     0.200
    74.150     0.089     0.200
    74.201    -0.281     0.200
    74.201    -0.078     0.200
    74.290     0.194     0.200
    74.368    -0.822     0.200
    74.401    -0.712     0.200
    74.401     0.156     0.200
    74.433    -0.227     0.200
    74.444    -0.453     0.200
    74.444     0.032     0.200
    74.452    -0.462     0.200
    74.520     0.665     0.200
    74.716     0.930     0.200
    74.849    -0.140     0.200
    75.144    -0.343     0.200
    75.147    -1.058     0.200
    75.176     0.171     0.200
    75.480    -0.285     0.200
    75.508    -0.012     0.200
    75.525     0.332     0.200
    75.620     2.619     0.200
    75.610     0.429     0.200
    75.654    -0.175     0.200
    75.695    -1.310     0.200
    75.770     0.566     0.200
    75.770     0.183     0.200
    75.819     0.613     0.200
    75.965     0.609     0.200
    75.982    -0.446     0.200
    76.109     0.718     0.200
    76.134     0.086     0.200
    76.166     0.757     0.200
    76.174     0.383     0.200
    76.190    -0.411     0.200
    76.206     0.124     0.200
    76.216    -0.675     0.200
    76.219    -0.296     0.200
    76.241     0.881     0.200
    76.311     0.379     0.200
    76.352     0.377     0.200
    76.417    -0.121     0.200
    76.478    -0.565     0.200
    76.647    -0.821     0.200
    76.637    -0.391     0.200
    76.705     0.152     0.200
    76.738     0.570     0.200
    76.834     0.160     0.200
    76.901    -0.255     0.200
    76.957    -0.277     0.200
    76.997    -0.298     0.200
    77.025    -0.259     0.200
    77.044    -0.976     0.200
    77.096    -0.051     0.200
    77.329    -1.061     0.200
    77.408     0.704     0.200
    77.410     0.529     0.200
    77.547     0.523     0.200
    77.846    -0.245     0.200
    77.847     0.851     0.200
    77.869     0.132     0.200
    77.889    -0.492     0.200
    77.975    -1.459     0.200
    77.990    -0.442     0.200
    78.001    -0.494     0.200
    78.062     0.452     0.200
    78.138    -0.863     0.200
    78.222     0.569     0.200
    78.247     0.928     0.200
    78.288     0.502     0.200
    78.288     0.354     0.200
    78.288     0.807     0.200
    78.334     0.951     0.200
    78.349     0.210     0.200
    78.349     0.367     0.200
    78.349    -0.141     0.200
    78.365    -0.621     0.200
    78.396    -0.095     0.200
    78.460     0.354     0.200
    78.603     0.464     0.200
    78.638    -0.029     0.200
    78.655    -0.825     0.200
    78.696    -0.252     0.200
    78.722    -0.296     0.200
    78.780    -0.716     0.200
    78.820     0.767     0.200
    78.898    -0.457     0.200
    78.975    -0.271     0.200
    78.975    -0.879     0.200
    79.138    -1.474     0.200
    79.145    -0.615     0.200
    79.175     0.120     0.200
    79.205     0.458     0.200
    79.205    -0.471     0.200
    79.248    -0.476     0.200
    79.299     0.351     0.200
    79.323     0.310     0.200
    79.326    -2.001     0.200
    79.331    -2.128     0.200
    79.372    -0.548     0.200
    79.372    -0.845     0.200
    79.587    -0.784     0.200
    79.617    -1.484     0.200
    79.669     1.430     0.200
    79.719    -0.244     0.200
    79.751     0.085     0.200
    79.983    -0.971     0.200
    80.127    -0.143     0.200
    80.136     0.104     0.200
    80.162     0.164     0.200
    80.297    -0.365     0.200
    80.455    -1.115     0.200
    80.639     0.002     0.200
    80.645     0.466     0.200
    80.713     0.184     0.200
    80.724     0.523     0.200
    80.724     0.171     0.200
    80.742    -0.152     0.200
    80.761    -0.224     0.200
    80.855     0.203     0.200
    80.858     0.025     0.200
    80.918    -0.016     0.200
    81.125     0.102     0.200
    81.207    -0.631     0.200
    81.207    -1.771     0.200
    81.207    -1.131     0.200
    81.214    -0.668     0.200
    81.214    -1.059     0.200
    81.391     0.689     0.200
    81.392     0.489     0.200
    81.392     0.270     0.200
    81.770    -0.010     0.200
    81.786    -0.093     0.200
    81.797     0.138     0.200
    81.853    -0.548     0.200
    81.855     0.240     0.200
    81.904     0.369     0.200
    81.928    -0.941     0.200
    81.987     0.307     0.200
    82.000     0.577     0.200
    82.106     0.170     0.200
    82.098     0.764     0.200
    82.129     0.102     0.200
    82.187    -1.030     0.200
    82.187    -0.257     0.200
    82.216     0.345     0.200
    82.220     0.127     0.200
    82.365    -0.490     0.200
    82.394    -0.387     0.200
    82.405    -1.834     0.200
    82.458    -0.353     0.200
    82.462    -0.238     0.200
    82.474     1.199     0.200
    82.489    -0.177     0.200
    82.573    -0.522     0.200
    82.602     0.186     0.200
    82.603    -0.218     0.200
    82.633     0.367     0.200
    82.626     0.200     0.200
    82.659    -0.562     0.200
    82.689    -0.024     0.200
    82.688    -0.419     0.200
    82.721     0.013     0.200
    82.817     0.210     0.200
    82.826    -0.134     0.200
    82.941    -0.019     0.200
    82.953    -1.202     0.200
    82.978    -0.321     0.200
    83.124     1.721     0.200
    83.171    -0.217     0.200
    83.210    -0.326     0.200
    83.219    -0.568     0.200
    83.410    -1.464     0.200
    83.674    -0.680     0.200
    83.674    -0.508     0.200
    83.780    -0.552     0.200
    83.831    -0.914     0.200
    83.832    -1.663     0.200
    83.832    -0.921     0.200
    83.827     0.005     0.200
    83.827    -0.214     0.200
    83.916    -1.045     0.200
    83.928    -0.162     0.200
    83.928    -0.217     0.200
    83.929    -0.164     0.200
    83.950    -0.423     0.200
    84.133    -1.103     0.200
    84.133    -0.955     0.200
    84.156    -1.510     0.200
    84.156    -0.270     0.200
    84.193    -1.059     0.200
    84.292    -0.365     0.200
    84.292    -0.560     0.200
    84.427    -1.049     0.200
    84.453     0.125     0.200
    84.680     0.454     0.200
    84.689    -1.531     0.200
    84.689    -0.969     0.200
    84.725    -0.650     0.200
    84.745    -1.094     0.200
    84.832    -0.190     0.200
    85.324     0.141     0.200
    85.314    -0.550     0.200
    85.314    -0.917     0.200
    85.361    -1.338     0.200
    85.567    -0.911     0.200
    85.607    -0.468     0.200
    85.715    -0.601     0.200
    85.829    -0.571     0.200
    86.284    -2.218     0.200
    86.569    -0.954     0.200
    86.933     0.306     0.200
    86.933     0.478     0.200
    87.130     0.697     0.200
    87.461    -2.680     0.200
    88.689    -1.047     0.200
    88.689    -0.485     0.200
    90.411    -0.742     0.200
    90.497     0.545     0.200
    91.218     0.232     0.200
    91.533    -0.883     0.200
    92.274    -1.007     0.200
    92.493    -0.886     0.200
    92.493    -1.191     0.200
    94.024    -1.378     0.200
    95.198    -1.203     0.200
    95.587    -1.003     0.200
    96.030    -1.254     0.200
    96.062    -0.820     0.200
    97.102    -2.137     0.200
    97.102    -2.138     0.200
    97.588    -0.731     0.200
    98.677    -0.873     0.200
    20.213     0.480     0.200
    24.326     1.559     0.200
    25.948     1.935     0.200
    29.038     1.659     0.200
    30.658     1.254     0.200
    34.865     0.881     0.200
    37.445     0.874     0.200
    41.518    -0.747     0.200
    43.774     0.855     0.200
    43.740     1.006     0.200
    44.089    -0.377     0.200
    44.930     1.452     0.200
    45.624    -0.486     0.200
    54.155    -0.885     0.200
    54.155    -0.889     0.200
    54.471    -0.888     0.200
    57.065     0.325     0.200
    60.423    -0.281     0.200
    62.341    -0.207     0.200
    62.341    -0.584     0.200
    62.601    -0.329     0.200
    63.432    -0.385     0.200
    65.148     0.211     0.200
    65.257    -0.498     0.200
    65.389    -0.810     0.200
    66.038    -0.228     0.200
    67.386    -0.423     0.200
    70.589    -0.456     0.200
    73.358    -0.916     0.200
    74.636     0.561     0.200
    79.460     0.403     0.200
    80.835     0.283     0.200
    84.188    -0.057     0.200
    84.472    -0.145     0.200
    20.017    -1.067     0.200
    30.219     1.081     0.200
    31.518     0.945     0.200
    44.792     0.937     0.200
    55.673    -2.176     0.200
    58.874    -2.263     0.200
    62.095    -3.249     0.200
    63.700    -2.729     0.200
    63.814    -2.735     0.200
    64.884    -2.297     0.200
    65.853    -2.679     0.200
    71.907    -2.921     0.200
    73.323    -1.837     0.200
    79.784    -1.447     0.200
    82.700    -1.686     0.200
    83.277    -1.915     0.200
    19.437     0.021     0.200
    19.449     0.247     0.200
    19.449     0.002     0.200
    19.449    -1.508     0.200
    23.818     1.251     0.200
    23.818     1.559     0.200
    24.437     1.749     0.200
    24.868     1.552     0.200
    24.894     3.786     0.200
    24.966     3.505     0.200
    25.688     2.236     0.200
    26.055    -1.551     0.200
    26.055    -2.176     0.200
    27.322    -1.838     0.200
    27.877    -0.924     0.200
    27.877    -0.718     0.200
    28.841     2.076     0.200
    29.364     2.376     0.200
    29.935     2.651     0.200
    30.103     2.465     0.200
    30.308     2.290     0.200
    30.365     2.141     0.200
    30.365     1.971     0.200
    30.433     2.290     0.200
    30.694     3.319     0.200
    31.446     1.617     0.200
    31.446     1.447     0.200
    31.446     0.837     0.200
    31.731     1.720     0.200
    32.432     2.576     0.200
    32.435     2.510     0.200
    32.481    -1.620     0.200
    32.481    -1.779     0.200
    32.524     0.944     0.200
    33.278     2.704     0.200
    33.376     1.353     0.200
    33.703    -0.801     0.200
    33.924     2.203     0.200
    34.853     2.333     0.200
    34.915     2.106     0.200
    34.965     2.084     0.200
    35.102     2.006     0.200
    35.124     2.232     0.200
    35.124     1.988     0.200
    35.145     2.290     0.200
    35.157     1.709     0.200
    35.236     1.819     0.200
    35.241     2.254     0.200
    35.381     1.720     0.200
    35.943     2.073     0.200
    36.027     2.334     0.200
    36.510     2.016     0.200
    36.875     2.958     0.200
    37.243     1.715     0.200
    37.516     2.437     0.200
    38.926     0.270     0.200
    41.890    -0.288     0.200
    41.918     0.267     0.200
    42.730    -1.319     0.200
    44.836     1.367     0.200
    44.837     1.066     0.200
    44.939    -1.718     0.200
    45.072    -1.930     0.200
    45.312    -0.624     0.200
    45.858     0.833     0.200
    46.086    -2.438     0.200
    48.322     0.541     0.200
    48.403    -1.182     0.200
    48.432     0.465     0.200
    48.512    -1.419     0.200
    50.169    -1.094     0.200
    50.172    -0.046     0.200
    50.897    -0.108     0.200
    52.253    -2.370     0.200
    53.147    -1.646     0.200
    53.178    -0.966     0.200
    53.178    -0.966     0.200
    55.068    -0.801     0.200
    55.068    -1.211     0.200
    55.358    -0.808     0.200
    55.371    -0.330     0.200
    57.723    -0.785     0.200
    58.080    -2.082     0.200
    58.359    -1.807     0.200
    58.359    -1.877     0.200
    60.209    -2.492     0.200
    60.209    -1.542     0.200
    60.381    -1.768     0.200
    61.126    -0.426     0.200
    61.285    -2.144     0.200
    61.339    -1.961     0.200
    61.339    -0.671     0.200
    62.537    -1.863     0.200
    62.537    -2.293     0.200
    63.054    -2.252     0.200
    63.054    -1.932     0.200
    63.163    -2.092     0.200
    63.210    -2.369     0.200
    63.210    -2.659     0.200
    63.214    -2.182     0.200
    64.068    -1.154     0.200
    65.366    -2.002     0.200
    65.366    -2.327     0.200
    65.366    -2.002     0.200
    65.383    -2.346     0.200
    65.456    -2.265     0.200
    66.080     4.349     0.200
    68.354    -2.335     0.200
    68.771    -2.232     0.200
    69.099    -2.046     0.200
    70.008     0.039     0.200
    70.129    -2.505     0.200
    70.292    -0.799     0.200
    70.332     0.658     0.200
    70.775    -0.441     0.200
    70.902     0.591     0.200
    70.984    -0.507     0.200
    71.073    -1.446     0.200
    71.124    -2.553     0.200
    71.124    -1.553     0.200
    71.124    -2.053     0.200
    71.131    -2.586     0.200
    71.150    -1.009     0.200
    71.196    -0.489     0.200
    71.437    -0.141     0.200
    71.498    -0.307     0.200
    71.559    -1.027     0.200
    71.559    -1.162     0.200
    71.559    -1.272     0.200
    72.216     0.050     0.200
    72.216     0.390     0.200
    72.251    -0.418     0.200
    72.299    -1.752     0.200
    72.299    -1.752     0.200
    72.300    -0.808     0.200
    72.479     0.226     0.200
    72.510    -0.259     0.200
    72.518    -0.138     0.200
    72.586    -0.910     0.200
    72.835    -1.084     0.200
    72.975    -0.913     0.200
    73.001    -0.868     0.200
    73.126    -0.807     0.200
    73.369    -1.135     0.200
    73.521    -1.029     0.200
    73.579     0.134     0.200
    73.582    -1.085     0.200
    73.680    -0.659     0.200
    73.687    -1.103     0.200
    73.706    -2.414     0.200
    73.769    -0.190     0.200
    73.823     0.389     0.200
    73.900     0.388     0.200
    73.923    -0.581     0.200
    74.053     0.604     0.200
    74.203     0.312     0.200
    74.207    -1.138     0.200
    74.231     0.106     0.200
    74.237    -1.309     0.200
    74.236     0.549     0.200
    74.402     0.992     0.200
    74.536    -0.347     0.200
    74.764    -0.665     0.200
    74.766     0.160     0.200
    74.898    -0.004     0.200
    74.916    -1.642     0.200
    75.022     0.746     0.200
    75.082     0.703     0.200
    75.103    -0.617     0.200
    75.452    -0.722     0.200
    75.558    -0.527     0.200
    75.641    -1.200     0.200
    75.865    -1.079     0.200
    75.989    -0.581     0.200
    76.004    -2.069     0.200
    76.365    -0.514     0.200
    76.414    -0.392     0.200
    76.479    -0.063     0.200
    76.521    -0.096     0.200
    76.666    -1.218     0.200
    76.994    -0.611     0.200
    76.994    -1.061     0.200
    77.195    -0.835     0.200
    77.345    -0.727     0.200
    77.688    -1.239     0.200
    78.945    -0.397     0.200
    78.964     0.193     0.200
    78.976     0.110     0.200
    78.976     0.977     0.200
    79.019     0.562     0.200
    79.231    -1.637     0.200
    79.255    -0.466     0.200
    80.307    -2.305     0.200
    80.502     0.016     0.200
    80.661    -2.263     0.200
    80.985    -0.721     0.200
    81.002     0.931     0.200
    81.934    -0.721     0.200
    81.934    -0.742     0.200
    81.934    -1.093     0.200
    82.756    -0.277     0.200
    83.143    -1.226     0.200
    83.143    -0.876     0.200
    83.167    -1.510     0.200
    83.780    -1.214     0.200
    85.050     0.214     0.200
    85.050     0.659     0.200
    85.390     0.244     0.200
    85.440    -1.906     0.200
    86.549    -2.924     0.200
    88.504     0.157     0.200
    89.227    -0.055     0.200
    92.589     0.338     0.200
    96.728    -0.607     0.200
    97.786    -2.376     0.200
    15.806     3.354     0.200
    20.424     0.002     0.200
    20.432    -1.063     0.200
    20.431    -1.481     0.200
    21.077     2.728     0.200
    21.167     2.484     0.200
    21.348     2.373     0.200
    21.452     2.337     0.200
    21.468     3.012     0.200
    21.858     2.547     0.200
    21.879     3.016     0.200
    21.907     2.255     0.200
    21.971     2.783     0.200
    22.018     1.966     0.200
    22.045     2.119     0.200
    22.250     2.207     0.200
    22.400     2.480     0.200
    22.494     2.325     0.200
    22.542     1.913     0.200
    22.606     1.792     0.200
    22.902     3.317     0.200
    22.958     1.853     0.200
    22.992     1.985     0.200
    23.237     2.718     0.200
    23.415     2.619     0.200
    23.414     1.815     0.200
    23.492     2.117     0.200
    23.502     2.061     0.200
    23.508     1.549     0.200
    23.590     2.736     0.200
    23.607     0.943     0.200
    23.693     2.021     0.200
    23.800     2.256     0.200
    23.847     2.553     0.200
    23.856     1.722     0.200
    23.863     1.559     0.200
    23.863     1.700     0.200
    23.863     1.876     0.200
    23.885     1.779     0.200
    23.914     2.081     0.200
    23.969     3.207     0.200
    24.063     2.798     0.200
    24.091     2.434     0.200
    24.362     1.769     0.200
    24.461     3.016     0.200
    24.485     3.259     0.200
    24.490     2.635     0.200
    24.677     2.856     0.200
    24.709     1.888     0.200
    24.880     3.098     0.200
    25.084     2.786     0.200
    25.099     2.701     0.200
    25.167     1.588     0.200
    25.198     1.778     0.200
    25.253     2.934     0.200
    25.253     3.119     0.200
    25.288     3.154     0.200
    25.377     1.848     0.200
    25.391     2.155     0.200
    25.434     3.209     0.200
    25.453     3.282     0.200
    25.654     2.812     0.200
    25.714     1.793     0.200
    25.822     3.098     0.200
    25.880     2.007     0.200
    25.902     3.341     0.200
    26.202     2.442     0.200
    26.269     2.263     0.200
    26.349     2.707     0.200
    26.378     2.897     0.200
    26.387     2.598     0.200
    26.449     1.164     0.200
    26.706    -2.698     0.200
    26.706    -2.998     0.200
    26.785     1.889     0.200
    26.908    -1.700     0.200
    26.908    -2.019     0.200
    26.831     2.436     0.200
    27.166     2.194     0.200
    27.378    -2.336     0.200
    27.380    -2.205     0.200
    27.380    -2.355     0.200
    27.445     1.836     0.200
    27.499     1.363     0.200
    27.633     1.815     0.200
    27.673     1.594     0.200
    27.830     2.254     0.200
    27.883     1.662     0.200
    28.030     0.888     0.200
    28.094     1.669     0.200
    28.229     0.089     0.200
    28.228     2.053     0.200
    28.363    -2.134     0.200
    28.291     1.832     0.200
    28.300     1.805     0.200
    28.443     2.274     0.200
    28.472    -0.497     0.200
    28.472     1.493     0.200
    28.620     2.710     0.200
    28.803     0.661     0.200
    28.803     2.716     0.200
    29.012     2.182     0.200
    29.063     2.500     0.200
    29.070     2.078     0.200
    29.226     2.024     0.200
    29.249     2.269     0.200
    29.332     2.796     0.200
    29.412     2.157     0.200
    29.422     2.370     0.200
    29.427     2.466     0.200
    29.553     2.875     0.200
    29.589     2.329     0.200
    29.638     3.465     0.200
    29.697     2.400     0.200
    29.802     3.508     0.200
    29.816     3.541     0.200
    29.816     3.316     0.200
    29.945     2.558     0.200
    29.953     2.917     0.200
    29.959     1.377     0.200
    29.959     2.432     0.200
    30.032     2.451     0.200
    30.063     2.032     0.200
    30.063     2.376     0.200
    30.069     2.324     0.200
    30.149     2.370     0.200
    30.186     2.911     0.200
    30.199     3.273     0.200
    30.209     1.640     0.200
    30.240     3.163     0.200
    30.309     3.394     0.200
    30.316     2.445     0.200
    30.348     2.402     0.200
    30.392     2.526     0.200
    30.464     2.845     0.200
    30.615     2.029     0.200
    30.755     1.996     0.200
    30.755     1.818     0.200
    30.810     1.131     0.200
    30.810     0.888     0.200
    30.858     2.195     0.200
    30.897     2.454     0.200
    31.079     0.212     0.200
    31.059     2.919     0.200
    31.119     2.877     0.200
    31.407     2.251     0.200
    31.407     2.142     0.200
    31.450     1.904     0.200
    31.450     1.799     0.200
    31.450     1.852     0.200
    31.450     1.802     0.200
    31.450     0.792     0.200
    31.496     2.185     0.200
    31.537     2.884     0.200
    31.577     2.502     0.200
    31.588     2.624     0.200
    31.595     1.757     0.200
    31.615     2.459     0.200
    31.706     2.238     0.200
    31.931     2.222     0.200
    31.985     2.518     0.200
    32.009     2.677     0.200
    32.036     1.970     0.200
    32.036     1.792     0.200
    32.137     2.437     0.200
    32.166     2.270     0.200
    32.201     2.465     0.200
    32.210     2.441     0.200
    32.291     1.060     0.200
    32.572     2.109     0.200
    32.756     2.586     0.200
    32.756     2.052     0.200
    32.821     1.810     0.200
    32.896     1.492     0.200
    32.941     2.272     0.200
    32.999     2.516     0.200
    33.001     1.725     0.200
    33.033     1.991     0.200
    33.062     2.911     0.200
    33.120     2.317     0.200
    33.147     2.267     0.200
    33.147     2.130     0.200
    33.160     2.363     0.200
    33.179     1.244     0.200
    33.236     1.632     0.200
    33.269     2.168     0.200
    33.273     2.421     0.200
    33.375     2.312     0.200
    33.391     2.086     0.200
    33.394     2.292     0.200
    33.408     2.903     0.200
    33.460     1.718     0.200
    33.603    -2.438     0.200
    33.603    -2.096     0.200
    33.603    -2.697     0.200
    33.481     2.263     0.200
    33.487     1.698     0.200
    33.499     2.581     0.200
    33.567     1.892     0.200
    33.567     1.764     0.200
    33.576     2.300     0.200
    33.630     2.418     0.200
    33.670     1.442     0.200
    33.756     2.115     0.200
    33.789     3.127     0.200
    33.845     2.526     0.200
    33.889     1.474     0.200
    33.919     2.151     0.200
    33.987     2.037     0.200
    34.128     2.088     0.200
    34.172     1.926     0.200
    34.172     1.313     0.200
    34.283     0.501     0.200
    34.318     1.420     0.200
    34.569     2.494     0.200
    34.584     1.884     0.200
    34.665     2.102     0.200
    34.669     1.819     0.200
    34.669     1.679     0.200
    34.672     1.806     0.200
    34.680     1.203     0.200
    34.687     2.064     0.200
    34.698     1.863     0.200
    34.693     1.978     0.200
    34.726     1.939     0.200
    34.776     2.336     0.200
    34.786     1.957     0.200
    34.827     2.587     0.200
    34.838     1.861     0.200
    34.845     1.879     0.200
    34.883     2.253     0.200
    34.891     1.936     0.200
    34.905     1.709     0.200
    34.940     1.808     0.200
    34.940     1.842     0.200
    34.940     2.012     0.200
    34.940     2.224     0.200
    34.972     1.872     0.200
    34.992     1.786     0.200
    34.996     1.895     0.200
    35.014     1.906     0.200
    35.018     1.727     0.200
    35.103     1.886     0.200
    35.112     1.949     0.200
    35.131     1.638     0.200
    35.255     1.850     0.200
    35.270     2.334     0.200
    35.272     1.802     0.200
    35.320     2.069     0.200
    35.354     1.734     0.200
    35.421     0.374     0.200
    35.519     1.683     0.200
    35.519     2.296     0.200
    35.532     1.842     0.200
    35.628     0.604     0.200
    35.619     2.153     0.200
    35.647     1.905     0.200
    35.744     2.031     0.200
    35.744     2.419     0.200
    35.927     2.215     0.200
    35.927     2.093     0.200
    35.976     1.484     0.200
    36.138     0.740     0.200
    36.136     2.123     0.200
    36.490    -1.470     0.200
    36.473     0.301     0.200
    36.473     2.417     0.200
    36.495     2.513     0.200
    36.495     2.379     0.200
    36.560     2.431     0.200
    36.683     1.807     0.200
    36.796     1.636     0.200
    36.796     1.514     0.200
    36.905     2.271     0.200
    37.117    -2.100     0.200
    37.188     2.219     0.200
    37.188     2.423     0.200
    37.247     2.517     0.200
    37.814     2.044     0.200
    37.831     2.253     0.200
    37.879    -0.103     0.200
    37.966     0.454     0.200
    38.221     2.234     0.200
    38.558     2.396     0.200
    38.602     1.464     0.200
    38.602     1.071     0.200
    38.783    -1.137     0.200
    38.783    -1.356     0.200
    38.752     0.432     0.200
    38.768     0.244     0.200
    38.766     1.920     0.200
    38.766     1.790     0.200
    38.820     2.456     0.200
    38.984    -2.034     0.200
    38.977     0.773     0.200
    38.977     0.623     0.200
    39.005     0.983     0.200
    39.089     2.526     0.200
    39.158     2.283     0.200
    39.187     2.811     0.200
    39.227     0.406     0.200
    39.284     2.450     0.200
    39.446    -0.347     0.200
    39.524     0.187     0.200
    39.547     0.489     0.200
    39.549     1.511     0.200
    39.615     0.793     0.200
    39.754     0.212     0.200
    39.789    -0.017     0.200
    39.817     0.278     0.200
    39.931     2.539     0.200
    39.971     0.405     0.200
    40.072     1.052     0.200
    40.072     0.216     0.200
    40.072     2.354     0.200
    40.144     0.012     0.200
    40.151     0.354     0.200
    40.240     0.357     0.200
    40.350     0.401     0.200
    40.381     0.134     0.200
    40.566     0.363     0.200
    40.698    -1.851     0.200
    40.631     0.524     0.200
    40.631     0.203     0.200
    40.670     0.619     0.200
    40.813    -0.065     0.200
    40.819     0.152     0.200
    40.933     0.509     0.200
    40.958     0.181     0.200
    40.958     0.020     0.200
    41.031     0.352     0.200
    41.056     0.398     0.200
    41.056     0.267     0.200
    41.070     0.178     0.200
    41.070     0.073     0.200
    41.136     0.814     0.200
    41.138    -0.392     0.200
    41.131     0.950     0.200
    41.197     2.105     0.200
    41.295     0.078     0.200
    41.316     0.637     0.200
    41.316     0.486     0.200
    41.323     0.505     0.200
    41.341     0.487     0.200
    41.374     1.705     0.200
    41.374     1.554     0.200
    41.472    -0.256     0.200
    41.478     1.465     0.200
    41.478     1.331     0.200
    41.548    -0.357     0.200
    41.601     0.086     0.200
    41.653     0.505     0.200
    41.702     0.477     0.200
    41.702     0.347     0.200
    41.808    -0.674     0.200
    41.808    -1.894     0.200
    41.708     0.057     0.200
    41.743     0.438     0.200
    41.743    -0.017     0.200
    41.820    -0.001     0.200
    41.845     2.131     0.200
    41.886    -0.265     0.200
    41.904     0.410     0.200
    41.897     1.459     0.200
    41.936    -0.470     0.200
    41.936    -0.221     0.200
    41.950     0.304     0.200
    41.948     0.296     0.200
    41.990     2.021     0.200
    42.052     0.136     0.200
    42.055    -0.040     0.200
    42.055    -0.149     0.200
    42.063    -0.089     0.200
    42.177     0.311     0.200
    42.221     0.031     0.200
    42.230    -0.427     0.200
    42.312     0.365     0.200
    42.321    -0.592     0.200
    42.471    -3.197     0.200
    42.366     0.337     0.200
    42.465    -0.297     0.200
    42.467    -0.187     0.200
    42.552    -0.642     0.200
    42.558    -0.282     0.200
    42.574     0.274     0.200
    42.778    -0.455     0.200
    42.792    -0.174     0.200
    42.820    -0.510     0.200
    42.820    -0.731     0.200
    42.892    -0.158     0.200
    42.914     0.425     0.200
    43.077    -1.928     0.200
    43.063    -0.196     0.200
    43.063    -0.325     0.200
    43.055     1.092     0.200
    43.071    -0.161     0.200
    43.071    -0.310     0.200
    43.084    -0.196     0.200
    43.149    -1.759     0.200
    43.188    -1.071     0.200
    43.198    -0.589     0.200
    43.418    -0.867     0.200
    43.418    -0.057     0.200
    43.418     0.043     0.200
    43.433    -0.687     0.200
    43.471    -0.408     0.200
    43.588    -0.763     0.200
    43.596    -0.678     0.200
    43.618     0.836     0.200
    43.618     0.387     0.200
    43.650    -0.205     0.200
    43.683    -0.389     0.200
    43.809    -0.325     0.200
    43.813     0.259     0.200
    43.824    -0.657     0.200
    43.851    -0.376     0.200
    43.865    -1.154     0.200
    43.978    -0.741     0.200
    44.024     0.009     0.200
    44.086     0.754     0.200
    44.086     0.073     0.200
    44.027    -0.233     0.200
    44.067    -0.302     0.200
    44.102    -0.245     0.200
    44.125    -0.319     0.200
    44.138    -0.496     0.200
    44.190     0.985     0.200
    44.190     0.866     0.200
    44.206    -0.226     0.200
    44.318    -0.817     0.200
    44.446    -0.106     0.200
    44.489    -0.217     0.200
    44.491    -0.569     0.200
    44.514    -0.206     0.200
    44.547    -0.317     0.200
    44.553    -0.550     0.200
    44.553    -0.186     0.200
    44.582     0.027     0.200
    44.614     0.917     0.200
    44.635    -0.130     0.200
    44.696    -1.080     0.200
    44.731    -0.851     0.200
    44.759    -0.641     0.200
    44.759    -0.479     0.200
    44.789    -0.062     0.200
    44.802    -0.826     0.200
    44.823    -0.760     0.200
    44.877    -0.011     0.200
    44.968    -0.650     0.200
    44.948     0.117     0.200
    44.976     0.070     0.200
    44.990    -0.562     0.200
    45.024    -0.045     0.200
    45.041    -0.478     0.200
    45.095    -0.154     0.200
    45.093    -1.217     0.200
    45.142    -1.904     0.200
    45.160    -0.046     0.200
    45.176    -0.202     0.200
    45.188    -1.273     0.200
    45.191    -0.860     0.200
    45.238     0.339     0.200
    45.248    -0.217     0.200
    45.255     0.195     0.200
    45.298    -0.436     0.200
    45.343     0.125     0.200
    45.343    -0.059     0.200
    45.347    -0.366     0.200
    45.440    -0.215     0.200
    45.440    -0.103     0.200
    45.452    -0.245     0.200
    45.516    -0.943     0.200
    45.509     1.799     0.200
    45.563     0.484     0.200
    45.571    -0.776     0.200
    45.565    -1.379     0.200
    45.594     0.035     0.200
    45.594    -0.073     0.200
    45.613    -1.418     0.200
    45.763    -3.065     0.200
    45.685     0.701     0.200
    45.683    -0.120     0.200
    45.725     0.815     0.200
    45.727    -0.292     0.200
    45.748    -0.519     0.200
    45.796    -0.403     0.200
    45.764     1.142     0.200
    45.771     0.221     0.200
    45.782    -0.575     0.200
    45.822     0.026     0.200
    45.821     0.076     0.200
    45.834     0.193     0.200
    45.834    -0.356     0.200
    45.849     0.223     0.200
    45.849    -0.151     0.200
    45.850    -0.207     0.200
    45.850    -0.390     0.200
    45.859     0.879     0.200
    45.896    -1.276     0.200
    45.924     0.264     0.200
    45.931     0.698     0.200
    45.935    -0.293     0.200
    45.943    -0.719     0.200
    45.968     0.057     0.200
    45.966    -0.618     0.200
    45.981    -1.496     0.200
    46.038     0.213     0.200
    46.149     1.130     0.200
    46.087    -0.436     0.200
    46.092    -0.392     0.200
    46.111    -0.887     0.200
    46.123    -0.653     0.200
    46.142     0.263     0.200
    46.164    -0.125     0.200
    46.288    -3.508     0.200
    46.186    -0.017     0.200
    46.189    -0.531     0.200
    46.342    -1.626     0.200
    46.255    -0.176     0.200
    46.298    -1.826     0.200
    46.298    -0.845     0.200
    46.299    -1.705     0.200
    46.346    -0.638     0.200
    46.424    -0.343     0.200
    46.424    -1.172     0.200
    46.473     0.222     0.200
    46.467    -0.280     0.200
    46.479    -0.921     0.200
    46.488    -0.069     0.200
    46.488    -0.512     0.200
    46.511    -0.014     0.200
    46.527    -0.264     0.200
    46.532    -0.445     0.200
    46.542    -0.073     0.200
    46.565     0.182     0.200
    46.600    -0.191     0.200
    46.621    -0.926     0.200
    46.658    -0.637     0.200
    46.663    -0.326     0.200
    46.718    -0.149     0.200
    46.722     1.398     0.200
    46.722     1.221     0.200
    46.732    -0.030     0.200
    46.757    -0.011     0.200
    46.777    -0.915     0.200
    46.804     0.053     0.200
    46.804    -0.489     0.200
    46.845     0.179     0.200
    46.883    -0.451     0.200
    46.899    -0.714     0.200
    46.910     0.293     0.200
    46.910    -0.545     0.200
    46.934    -0.244     0.200
    46.970    -0.768     0.200
    46.970    -0.882     0.200
    46.983     0.089     0.200
    47.023    -0.036     0.200
    47.064     0.376     0.200
    47.101    -0.584     0.200
    47.100    -0.316     0.200
    47.117     0.348     0.200
    47.102     0.713     0.200
    47.109     0.458     0.200
    47.114    -0.572     0.200
    47.248    -2.099     0.200
    47.138    -0.413     0.200
    47.194    -0.291     0.200
    47.205    -0.652     0.200
    47.230    -1.200     0.200
    47.303     0.493     0.200
    47.304    -0.043     0.200
    47.314    -0.915     0.200
    47.313    -0.197     0.200
    47.313    -0.359     0.200
    47.337    -0.227     0.200
    47.344     0.322     0.200
    47.359     0.241     0.200
    47.370    -0.064     0.200
    47.384    -0.434     0.200
    47.409    -0.138     0.200
    47.409    -0.337     0.200
    47.419    -0.434     0.200
    47.429     0.833     0.200
    47.429     0.231     0.200
    47.455    -0.322     0.200
    47.489    -0.209     0.200
    47.475     1.544     0.200
    47.475     1.032     0.200
    47.497     0.130     0.200
    47.504    -0.377     0.200
    47.504    -0.606     0.200
    47.496     1.109     0.200
    47.512    -0.886     0.200
    47.534     0.238     0.200
    47.534    -0.335     0.200
    47.555     1.374     0.200
    47.555     0.865     0.200
    47.590    -0.033     0.200
    47.649    -0.069     0.200
    47.654    -0.271     0.200
    47.666    -0.347     0.200
    47.666    -0.453     0.200
    47.672    -0.585     0.200
    47.678    -0.200     0.200
    47.680     1.433     0.200
    47.680     1.256     0.200
    47.773    -0.070     0.200
    47.831     0.771     0.200
    47.856    -0.171     0.200
    47.877    -0.595     0.200
    47.868     0.666     0.200
    47.877    -0.623     0.200
    47.885     0.381     0.200
    47.925    -1.194     0.200
    47.925     0.209     0.200
    47.925    -0.062     0.200
    47.928    -0.459     0.200
    47.966    -0.900     0.200
    47.950    -0.122     0.200
    47.962    -0.019     0.200
    47.996    -0.251     0.200
    47.986     0.118     0.200
    48.008     0.185     0.200
    48.008     0.046     0.200
    48.072    -0.085     0.200
    48.074     0.196     0.200
    48.093     0.008     0.200
    48.121    -0.808     0.200
    48.124    -0.382     0.200
    48.160    -0.533     0.200
    48.160    -0.659     0.200
    48.173     0.211     0.200
    48.182    -0.603     0.200
    48.393    -1.788     0.200
    48.392    -1.293     0.200
    48.393    -1.318     0.200
    48.393    -1.878     0.200
    48.393    -2.778     0.200
    48.304     1.159     0.200
    48.304     1.039     0.200
    48.317     0.249     0.200
    48.318     0.132     0.200
    48.317     1.341     0.200
    48.334    -0.055     0.200
    48.342    -0.121     0.200
    48.344     0.018     0.200
    48.363    -0.546     0.200
    48.363    -0.651     0.200
    48.400     0.108     0.200
    48.419    -0.198     0.200
    48.431     0.116     0.200
    48.435     0.817     0.200
    48.445    -0.076     0.200
    48.527    -0.138     0.200
    48.527    -0.283     0.200
    48.544    -0.170     0.200
    48.544    -0.397     0.200
    48.550    -1.093     0.200
    48.586    -0.041     0.200
    48.614     0.221     0.200
    48.614     0.737     0.200
    48.720    -1.548     0.200
    48.693     0.551     0.200
    48.696     1.063     0.200
    48.696     0.957     0.200
    48.711     0.224     0.200
    48.767    -0.216     0.200
    48.723     0.353     0.200
    48.731     0.151     0.200
    48.743    -0.472     0.200
    48.740    -0.155     0.200
    48.755     0.235     0.200
    48.762     0.126     0.200
    48.786     0.306     0.200
    48.942    -1.995     0.200
    48.844    -0.136     0.200
    48.846     0.241     0.200
    48.846     0.094     0.200
    48.961    -0.834     0.200
    48.976    -0.715     0.200
    48.976    -0.959     0.200
    48.984    -0.121     0.200
    49.054    -0.651     0.200
    49.047     0.354     0.200
    49.047     0.084     0.200
    49.100     2.908     0.200
    49.117     0.159     0.200
    49.124     1.228     0.200
    49.124     1.106     0.200
    49.133     1.388     0.200
    49.189    -0.182     0.200
    49.197     0.947     0.200
    49.206    -0.119     0.200
    49.206    -0.232     0.200
    49.211    -0.862     0.200
    49.206     0.656     0.200
    49.231    -0.114     0.200
    49.330    -1.197     0.200
    49.328    -0.047     0.200
    49.426    -0.214     0.200
    49.456    -0.304     0.200
    49.467     1.209     0.200
    49.467     0.558     0.200
    49.497     0.412     0.200
    49.509    -0.256     0.200
    49.510     0.920     0.200
    49.576     1.777     0.200
    49.581     0.975     0.200
    49.591     0.363     0.200
    49.616    -0.222     0.200
    49.611    -0.072     0.200
    49.654     0.073     0.200
    49.721    -0.651     0.200
    49.683    -0.250     0.200
    49.720    -0.197     0.200
    49.755    -0.354     0.200
    49.755    -0.566     0.200
    49.836    -0.296     0.200
    49.891     0.070     0.200
    49.902    -0.291     0.200
    49.925     0.238     0.200
    49.935     1.150     0.200
    49.949     0.547     0.200
    49.950     0.492     0.200
    49.965     0.065     0.200
    49.995    -0.604     0.200
    49.995    -0.733     0.200
    50.018    -0.526     0.200
    50.030    -0.221     0.200
    50.034     0.098     0.200
    50.034    -0.018     0.200
    50.064     0.049     0.200
    50.071    -0.077     0.200
    50.089    -0.298     0.200
    50.108    -0.472     0.200
    50.146    -0.299     0.200
    50.146    -0.436     0.200
    50.211    -0.262     0.200
    50.244    -0.133     0.200
    50.316    -0.125     0.200
    50.315    -0.322     0.200
    50.351     0.248     0.200
    50.351     0.134     0.200
    50.383     0.589     0.200
    50.401    -0.285     0.200
    50.391    -0.592     0.200
    50.429     0.758     0.200
    50.438    -0.236     0.200
    50.474    -0.302     0.200
    50.494     1.208     0.200
    50.528    -0.239     0.200
    50.538    -0.086     0.200
    50.522     1.612     0.200
    50.568    -0.307     0.200
    50.592    -0.268     0.200
    50.592    -0.596     0.200
    50.638     0.865     0.200
    50.678     0.760     0.200
    50.678     0.624     0.200
    50.694    -0.035     0.200
    50.705     1.081     0.200
    50.734     1.070     0.200
    50.755    -0.290     0.200
    50.783     0.029     0.200
    50.774    -0.576     0.200
    50.774    -0.786     0.200
    50.791    -0.131     0.200
    50.800    -0.850     0.200
    50.792    -0.248     0.200
    50.819    -0.212     0.200
    50.904    -0.272     0.200
    50.909    -0.571     0.200
    50.999    -0.102     0.200
    50.998    -0.448     0.200
    51.082     0.294     0.200
    51.083     0.319     0.200
    51.177    -0.652     0.200
    51.173     0.599     0.200
    51.191     0.356     0.200
    51.197    -0.419     0.200
    51.197    -0.530     0.200
    51.218    -0.249     0.200
    51.233    -0.303     0.200
    51.264    -0.091     0.200
    51.280    -0.093     0.200
    51.289    -0.226     0.200
    51.311    -0.297     0.200
    51.360    -0.370     0.200
    51.438     0.108     0.200
    51.427     0.562     0.200
    51.486    -0.154     0.200
    51.497    -0.773     0.200
    51.511    -0.041     0.200
    51.514     0.686     0.200
    51.514     0.584     0.200
    51.521     0.052     0.200
    51.531    -0.330     0.200
    51.558    -0.725     0.200
    51.633    -0.792     0.200
    51.687    -0.236     0.200
    51.753    -0.195     0.200
    51.753    -0.309     0.200
    51.783    -0.229     0.200
    51.797     0.042     0.200
    51.885    -0.180     0.200
    51.905     0.112     0.200
    51.905    -0.568     0.200
    51.906     0.719     0.200
    51.951     0.277     0.200
    51.977    -0.568     0.200
    52.001    -0.206     0.200
    52.023    -0.093     0.200
    52.023    -0.200     0.200
    52.020    -0.320     0.200
    52.034     0.341     0.200
    52.041    -0.317     0.200
    52.062    -0.461     0.200
    52.068    -0.738     0.200
    52.074    -1.270     0.200
    52.132    -0.173     0.200
    52.132    -0.570     0.200
    52.167     0.736     0.200
    52.167     0.223     0.200
    52.182    -0.743     0.200
    52.322    -1.181     0.200
    52.232    -0.173     0.200
    52.257    -0.449     0.200
    52.278    -0.381     0.200
    52.278    -0.481     0.200
    52.298    -1.086     0.200
    52.345     0.047     0.200
    52.359    -1.077     0.200
    52.366    -0.212     0.200
    52.392     0.303     0.200
    52.419    -0.843     0.200
    52.419    -1.003     0.200
    52.461    -0.071     0.200
    52.458    -0.313     0.200
    52.480    -0.809     0.200
    52.461    -0.995     0.200
    52.486    -0.623     0.200
    52.503    -0.574     0.200
    52.662    -2.098     0.200
    52.702     0.110     0.200
    52.790    -1.138     0.200
    52.801    -1.263     0.200
    52.878    -0.690     0.200
    52.892    -1.011     0.200
    52.938    -0.788     0.200
    52.963    -0.352     0.200
    53.083    -1.136     0.200
    53.083    -1.281     0.200
    53.091    -1.068     0.200
    53.091    -1.180     0.200
    53.266    -1.360     0.200
    53.296    -1.126     0.200
    53.176    -1.176     0.200
    53.296    -0.426     0.200
    53.296    -1.126     0.200
    53.221    -1.102     0.200
    53.221    -1.270     0.200
    53.288    -0.795     0.200
    53.306    -0.775     0.200
    53.324     1.662     0.200
    53.435    -0.624     0.200
    53.560    -1.259     0.200
    53.588    -0.773     0.200
    53.662    -3.258     0.200
    53.564    -1.111     0.200
    53.581    -1.889     0.200
    53.629    -1.530     0.200
    53.784    -1.691     0.200
    53.784    -1.693     0.200
    53.784    -1.380     0.200
    53.784    -1.231     0.200
    53.784    -1.471     0.200
    53.808    -0.807     0.200
    53.854    -1.385     0.200
    53.904    -0.995     0.200
    53.927    -0.300     0.200
    54.064     0.247     0.200
    54.064    -0.274     0.200
    54.068    -0.496     0.200
    54.089    -1.059     0.200
    54.089    -1.315     0.200
    54.368    -1.511     0.200
    54.330    -1.515     0.200
    54.355    -0.498     0.200
    54.369    -1.216     0.200
    54.412    -0.557     0.200
    54.440    -0.074     0.200
    54.583     0.000     0.200
    54.697    -1.078     0.200
    54.740    -1.124     0.200
    54.867    -0.819     0.200
    54.830    -0.123     0.200
    54.938    -1.767     0.200
    54.843    -0.537     0.200
    54.845    -1.151     0.200
    55.014    -1.085     0.200
    55.152    -0.867     0.200
    55.209    -1.228     0.200
    55.259    -0.984     0.200
    55.426    -0.559     0.200
    55.475    -2.115     0.200
    55.483    -1.770     0.200
    55.524    -1.136     0.200
    55.632    -2.342     0.200
    55.608    -0.770     0.200
    56.071    -1.751     0.200
    55.967    -0.786     0.200
    56.083    -0.832     0.200
    56.083    -0.832     0.200
    56.028    -0.681     0.200
    56.225    -0.821     0.200
    56.466    -1.102     0.200
    56.616    -0.788     0.200
    56.685    -0.653     0.200
    56.912     0.951     0.200
    57.054    -1.045     0.200
    57.074    -0.575     0.200
    57.396    -1.384     0.200
    57.517    -0.609     0.200
    57.571    -0.828     0.200
    57.612    -0.939     0.200
    57.944    -0.714     0.200
    58.234    -0.765     0.200
    58.374    -0.749     0.200
    58.667    -0.366     0.200
    58.667    -0.950     0.200
    59.041    -0.786     0.200
    58.999    -0.797     0.200
    59.040    -0.109     0.200
    59.040    -0.213     0.200
    59.198    -1.468     0.200
    59.445    -1.276     0.200
    59.448    -1.531     0.200
    59.448    -1.301     0.200
    59.448    -1.681     0.200
    59.494    -2.096     0.200
    59.430    -0.761     0.200
    59.665    -0.902     0.200
    59.849    -1.158     0.200
    59.972    -2.503     0.200
    60.165    -0.309     0.200
    60.271     0.666     0.200
    60.592    -0.914     0.200
    60.707    -0.723     0.200
    61.337     1.068     0.200
    61.489    -0.426     0.200
    61.586    -0.710     0.200
    61.723    -0.854     0.200
    61.733    -0.601     0.200
    61.751    -0.541     0.200
    61.754    -0.494     0.200
    61.758    -0.839     0.200
    61.758    -0.809     0.200
    61.758    -0.814     0.200
    61.910    -0.862     0.200
    61.911    -1.068     0.200
    61.911    -1.068     0.200
    61.911    -1.168     0.200
    61.926    -0.751     0.200
    62.085    -0.733     0.200
    62.085    -0.993     0.200
    62.133    -0.556     0.200
    62.189    -1.534     0.200
    62.925    -0.741     0.200
    63.002     0.012     0.200
    63.002    -0.228     0.200
    63.131    -1.313     0.200
    63.252    -0.776     0.200
    63.539    -0.213     0.200
    63.896    -1.725     0.200
    64.180    -1.317     0.200
    64.445    -1.346     0.200
    64.445    -1.487     0.200
    64.448    -1.985     0.200
    64.900    -1.033     0.200
    65.202    -0.693     0.200
    65.607    -0.192     0.200
    65.656    -1.331     0.200
    65.691    -1.352     0.200
    65.730    -1.506     0.200
    65.774     0.764     0.200
    66.405    -1.519     0.200
    66.405    -1.340     0.200
    66.405    -1.610     0.200
    66.405    -1.615     0.200
    66.405    -1.740     0.200
    66.422    -2.399     0.200
    66.502    -0.858     0.200
    66.500    -1.424     0.200
    67.010    -0.199     0.200
    67.164    -0.075     0.200
    67.228    -0.876     0.200
    67.622    -0.340     0.200
    67.646     0.078     0.200
    67.801    -0.469     0.200
    67.919    -1.881     0.200
    67.919    -2.141     0.200
    67.909    -0.378     0.200
    67.976    -0.400     0.200
    68.022    -0.390     0.200
    68.056    -0.520     0.200
    68.248    -0.805     0.200
    68.439    -1.220     0.200
    68.468    -3.279     0.200
    68.677    -1.683     0.200
    68.863    -0.743     0.200
    69.343    -1.187     0.200
    69.883    -0.500     0.200
    70.111     0.851     0.200
    70.249    -1.891     0.200
    70.400    -1.314     0.200
    70.412    -1.390     0.200
    70.412    -1.370     0.200
    70.766    -1.948     0.200
    71.149    -3.766     0.200
    71.384    -1.886     0.200
    71.517     0.960     0.200
    71.530    -0.367     0.200
    71.557    -0.531     0.200
    71.557    -0.631     0.200
    71.604    -2.016     0.200
    71.626    -0.370     0.200
    71.842    -1.844     0.200
    71.834    -0.796     0.200
    71.850    -0.334     0.200
    71.875    -0.941     0.200
    72.054    -0.066     0.200
    72.054    -1.016     0.200
    72.093    -0.728     0.200
    72.062    -0.372     0.200
    72.255    -0.097     0.200
    72.251    -0.324     0.200
    72.380    -1.065     0.200
    72.450     0.021     0.200
    72.451    -0.485     0.200
    72.500     0.099     0.200
    72.476     0.086     0.200
    72.476     0.236     0.200
    72.578     0.058     0.200
    72.604    -1.398     0.200
    72.662    -0.003     0.200
    72.662    -1.043     0.200
    72.644    -1.534     0.200
    72.644    -1.534     0.200
    72.651    -2.706     0.200
    72.651    -1.776     0.200
    72.719    -0.384     0.200
    72.744     0.071     0.200
    72.867    -0.038     0.200
    72.924     0.304     0.200
    72.977    -1.712     0.200
    72.986    -0.063     0.200
    73.026     0.490     0.200
    73.005    -0.420     0.200
    73.045     0.086     0.200
    73.077    -0.005     0.200
    73.258     0.450     0.200
    73.172    -0.184     0.200
    73.373     0.302     0.200
    73.356    -0.447     0.200
    73.385     0.080     0.200
    73.385    -0.470     0.200
    73.385    -0.720     0.200
    73.421    -0.029     0.200
    73.458    -1.047     0.200
    73.458    -0.847     0.200
    73.458    -1.047     0.200
    73.517    -0.415     0.200
    73.720    -0.290     0.200
    73.765     0.256     0.200
    73.765     0.146     0.200
    73.799     0.251     0.200
    73.799    -0.349     0.200
    73.760    -1.052     0.200
    73.845    -0.623     0.200
    73.866    -0.244     0.200
    73.951    -0.500     0.200
    74.024    -0.080     0.200
    74.024     0.030     0.200
    74.032    -0.616     0.200
    74.050    -0.169     0.200
    74.050    -0.020     0.200
    73.979    -1.783     0.200
    74.059    -0.092     0.200
    74.059    -0.497     0.200
    74.067    -0.370     0.200
    74.102     0.580     0.200
    74.088    -0.413     0.200
    74.307     0.580     0.200
    74.286    -1.375     0.200
    74.379    -1.139     0.200
    74.529    -0.810     0.200
    74.626    -0.072     0.200
    74.639    -1.144     0.200
    74.712     1.332     0.200
    74.730    -0.470     0.200
    74.770    -1.005     0.200
    74.807    -1.119     0.200
    74.907    -1.093     0.200
    74.989     2.533     0.200
    75.058    -1.064     0.200
    74.994    -0.916     0.200
    75.092    -0.144     0.200
    75.128     0.162     0.200
    75.121    -1.127     0.200
    75.143     0.185     0.200
    75.218    -0.089     0.200
    75.222    -1.110     0.200
    75.251     0.161     0.200
    75.318    -0.141     0.200
    75.353    -0.364     0.200
    75.350     0.056     0.200
    75.372     0.028     0.200
    75.449     0.265     0.200
    75.466    -0.612     0.200
    75.601     0.243     0.200
    75.693     0.588     0.200
    75.739    -0.407     0.200
    75.765    -0.574     0.200
    75.769    -0.244     0.200
    75.780     0.472     0.200
    75.785     0.492     0.200
    75.785     0.362     0.200
    75.831     0.302     0.200
    75.865     0.368     0.200
    75.998     0.569     0.200
    76.023    -0.892     0.200
    76.053    -0.964     0.200
    76.042    -0.067     0.200
    76.068    -1.151     0.200
    76.255    -0.119     0.200
    76.292     0.276     0.200
    76.293    -0.731     0.200
    76.315     0.107     0.200
    76.363    -0.114     0.200
    76.446    -0.093     0.200
    76.447    -0.074     0.200
    76.431    -1.351     0.200
    76.526    -0.847     0.200
    76.561    -0.346     0.200
    76.559    -0.845     0.200
    76.626     0.087     0.200
    76.647     0.269     0.200
    76.992    -0.777     0.200
    77.021    -1.319     0.200
    77.075     0.866     0.200
    77.100    -0.585     0.200
    77.170    -1.069     0.200
    77.193    -1.105     0.200
    77.203    -1.062     0.200
    77.290     0.153     0.200
    77.308    -0.148     0.200
    77.228    -0.320     0.200
    77.328     0.437     0.200
    77.403    -1.413     0.200
    77.417     0.338     0.200
    77.407     0.096     0.200
    77.450    -0.516     0.200
    77.498    -0.945     0.200
    77.516    -0.514     0.200
    77.532    -0.102     0.200
    77.617     0.523     0.200
    77.619    -1.087     0.200
    77.661     0.650     0.200
    77.627     0.266     0.200
    77.708    -0.285     0.200
    77.832     0.424     0.200
    77.894    -0.322     0.200
    77.894     0.258     0.200
    77.923    -1.180     0.200
    77.946    -0.210     0.200
    78.013     0.119     0.200
    78.001     0.487     0.200
    77.938    -1.282     0.200
    78.033     0.407     0.200
    78.103    -0.980     0.200
    78.189    -0.455     0.200
    78.198    -0.608     0.200
    78.237    -0.332     0.200
    78.342    -0.903     0.200
    78.378    -0.302     0.200
    78.378    -0.711     0.200
    78.378    -0.901     0.200
    78.377     0.505     0.200
    78.396    -0.061     0.200
    78.406    -2.044     0.200
    78.436    -0.269     0.200
    78.437    -0.177     0.200
    78.437    -0.327     0.200
    78.464    -0.577     0.200
    78.487     0.355     0.200
    78.506    -0.837     0.200
    78.537    -0.977     0.200
    78.636     0.103     0.200
    78.603     0.361     0.200
    78.653    -0.807     0.200
    78.779    -0.408     0.200
    78.781     0.281     0.200
    78.782    -0.829     0.200
    78.782    -0.729     0.200
    78.833    -0.580     0.200
    78.904    -0.495     0.200
    78.883    -1.189     0.200
    78.985     0.359     0.200
    79.088     0.298     0.200
    79.130     1.268     0.200
    79.134    -1.055     0.200
    79.168    -0.512     0.200
    79.168    -1.042     0.200
    79.093    -0.671     0.200
    79.189    -1.408     0.200
    79.375    -0.070     0.200
    79.439    -0.619     0.200
    79.427    -0.614     0.200
    79.427     0.286     0.200
    79.521    -0.067     0.200
    79.533     0.071     0.200
    79.599    -0.830     0.200
    79.830    -0.845     0.200
    79.919    -0.406     0.200
    79.919    -0.026     0.200
    79.935     0.091     0.200
    79.945    -0.164     0.200
    80.013    -0.730     0.200
    80.087    -0.331     0.200
    80.048     0.351     0.200
    80.166     0.340     0.200
    80.194    -0.289     0.200
    80.279    -1.765     0.200
    80.295    -0.952     0.200
    80.234    -0.815     0.200
    80.431     0.015     0.200
    80.431    -0.175     0.200
    80.469    -1.487     0.200
    80.480     0.176     0.200
    80.480    -0.245     0.200
    80.467     0.321     0.200
    80.479     0.409     0.200
    80.479     0.528     0.200
    80.415     0.500     0.200
    80.520     0.460     0.200
    80.562     0.575     0.200
    80.567     0.588     0.200
    80.580    -1.795     0.200
    80.580    -0.755     0.200
    80.648    -0.048     0.200
    80.638    -0.583     0.200
    80.745    -1.368     0.200
    80.679     0.165     0.200
    80.769    -2.093     0.200
    80.769    -0.852     0.200
    80.800    -0.461     0.200
    80.800    -1.061     0.200
    80.800    -0.781     0.200
    80.921     0.196     0.200
    80.930    -0.564     0.200
    81.040    -1.638     0.200
    81.043    -1.026     0.200
    81.164     1.002     0.200
    81.221     0.099     0.200
    81.191     0.326     0.200
    81.255    -0.320     0.200
    81.255     0.021     0.200
    81.343    -0.119     0.200
    81.306    -1.594     0.200
    81.306    -2.154     0.200
    81.409    -0.098     0.200
    81.496     0.139     0.200
    81.448    -0.376     0.200
    81.587    -1.214     0.200
    81.587     0.111     0.200
    81.654    -0.384     0.200
    81.654     0.106     0.200
    81.742    -0.956     0.200
    81.774     0.272     0.200
    81.774     0.032     0.200
    81.792     0.381     0.200
    81.923     1.421     0.200
    81.907    -0.207     0.200
    81.892     0.552     0.200
    81.939    -0.514     0.200
    81.947     0.587     0.200
    82.020    -0.018     0.200
    82.024     0.159     0.200
    82.104     1.189     0.200
    82.045     0.459     0.200
    82.191     0.187     0.200
    82.223     0.220     0.200
    82.248    -0.515     0.200
    82.290    -0.085     0.200
    82.271     0.844     0.200
    82.384     0.076     0.200
    82.430    -0.163     0.200
    82.527    -0.641     0.200
    82.602     0.198     0.200
    82.863    -0.318     0.200
    83.020    -1.100     0.200
    83.098    -0.125     0.200
    83.240    -1.135     0.200
    83.240    -0.066     0.200
    83.241    -0.379     0.200
    83.241    -0.569     0.200
    83.334     1.153     0.200
    83.334     0.433     0.200
    83.362     0.479     0.200
    83.430    -0.345     0.200
    83.430    -0.226     0.200
    83.430    -0.341     0.200
    83.431    -0.347     0.200
    83.431    -0.447     0.200
    83.542    -0.547     0.200
    83.542    -1.167     0.200
    83.542    -1.017     0.200
    83.485     0.276     0.200
    83.565    -1.197     0.200
    83.611     1.625     0.200
    83.737    -0.621     0.200
    83.809     1.071     0.200
    83.897    -0.235     0.200
    83.897    -0.475     0.200
    83.897    -0.935     0.200
    84.404    -0.114     0.200
    84.654     1.193     0.200
    84.730    -0.460     0.200
    84.896    -0.093     0.200
    85.198    -1.517     0.200
    85.250    -0.068     0.200
    85.268     0.471     0.200
    85.285    -0.643     0.200
    85.397    -0.603     0.200
    85.417     0.081     0.200
    85.487     1.149     0.200
    85.473    -0.579     0.200
    85.711    -2.161     0.200
    85.847    -2.036     0.200
    86.140    -0.227     0.200
    86.594    -0.343     0.200
    86.594     0.102     0.200
    86.603     1.510     0.200
    87.484    -1.040     0.200
    87.498    -0.988     0.200
    87.640     0.499     0.200
    87.883    -0.247     0.200
    87.957    -0.700     0.200
    88.083    -1.795     0.200
    88.111    -0.831     0.200
    88.117    -0.790     0.200
    88.190    -0.213     0.200
    88.212    -1.108     0.200
    91.437    -0.507     0.200
    91.437    -0.222     0.200
    92.512    -0.613     0.200
    92.913    -0.825     0.200
    93.342    -0.955     0.200
    93.872    -1.522     0.200
    95.446    -2.156     0.200
    96.885    -1.692     0.200
    96.885    -1.507     0.200
    96.900    -1.808     0.200
    96.901    -1.805     0.200
    97.974    -1.962     0.200
    20.264    -1.308     0.200
    23.326     1.412     0.200
    28.306     0.477     0.200
    29.010     0.807     0.200
    29.076     0.278     0.200
    30.045     1.435     0.200
    30.090     2.577     0.200
    30.111     1.265     0.200
    30.649     1.900     0.200
    30.652     2.282     0.200
    30.948     1.133     0.200
    30.948     0.870     0.200
    32.162     1.503     0.200
    32.162     0.784     0.200
    32.162     0.163     0.200
    32.270    -1.161     0.200
    34.136     0.710     0.200
    34.155     2.203     0.200
    34.321     1.495     0.200
    36.520     1.031     0.200
    38.206     0.191     0.200
    42.112    -1.350     0.200
    43.746     0.157     0.200
    45.488     0.635     0.200
    48.867    -0.045     0.200
    49.212     0.094     0.200
    50.499     0.453     0.200
    50.954    -0.390     0.200
    54.911    -0.795     0.200
    57.986    -1.295     0.200
    58.126    -2.047     0.200
    65.742     2.683     0.200
    19.152    -0.326     0.200
    27.578    -1.638     0.200
    31.192    -0.175     0.200
    42.950    -2.032     0.200
    52.142    -3.231     0.200
    55.531    -0.542     0.200
    58.436    -2.273     0.200
    60.271    -2.496     0.200
    65.455    -2.324     0.200
    71.024    -2.820     0.200
    72.359    -1.303     0.200
    78.764    -1.232     0.200
    81.853    -2.003     0.200
    16.121     0.693     0.200
    16.121     1.068     0.200
    18.641    -0.820     0.200
    19.686    -0.432     0.200
    19.699     0.279     0.200
    19.699    -1.116     0.200
    20.631     0.499     0.200
    20.964     1.595     0.200
    21.103     1.153     0.200
    21.550     1.519     0.200
    21.568     1.632     0.200
    21.716     1.116     0.200
    21.950     2.659     0.200
    21.992     2.395     0.200
    22.336     1.912     0.200
    22.402     1.890     0.200
    22.479     1.570     0.200
    22.590     1.769     0.200
    22.724     0.764     0.200
    22.921     0.542     0.200
    22.955     0.307     0.200
    23.089     1.497     0.200
    23.498     1.648     0.200
    23.527     2.082     0.200
    23.622     1.852     0.200
    23.824     0.921     0.200
    23.840     0.606     0.200
    23.847     1.807     0.200
    23.979     0.784     0.200
    24.024     1.589     0.200
    24.116     1.010     0.200
    24.122     0.828     0.200
    24.122     1.082     0.200
    24.166     1.969     0.200
    24.258     1.542     0.200
    24.289     1.034     0.200
    24.296     2.020     0.200
    24.367     1.176     0.200
    24.544     1.516     0.200
    24.664     1.439     0.200
    24.739     0.691     0.200
    24.779     2.145     0.200
    25.167     0.846     0.200
    25.181     2.535     0.200
    25.224     2.084     0.200
    25.494     2.097     0.200
    25.574     0.845     0.200
    25.597     1.060     0.200
    25.741     2.060     0.200
    25.757     1.512     0.200
    25.782    -0.697     0.200
    25.789     2.025     0.200
    25.926     0.897     0.200
    25.973     2.146     0.200
    26.171     2.343     0.200
    26.310    -0.126     0.200
    26.310     1.195     0.200
    26.345     1.946     0.200
    26.569     2.302     0.200
    26.567    -0.623     0.200
    26.696     0.298     0.200
    26.696     0.714     0.200
    26.795     1.546     0.200
    26.900    -0.617     0.200
    26.900    -0.747     0.200
    26.957     1.377     0.200
    26.988     1.529     0.200
    27.016    -0.878     0.200
    27.018    -0.658     0.200
    27.018    -0.893     0.200
    27.399     1.358     0.200
    27.527     1.110     0.200
    27.590    -0.110     0.200
    27.871     0.872     0.200
    28.117     0.251     0.200
    28.117     0.370     0.200
    28.256     0.036     0.200
    28.256     0.495     0.200
    28.372     0.327     0.200
    28.418     0.497     0.200
    28.541     1.296     0.200
    28.607     0.958     0.200
    28.691     0.808     0.200
    28.691     1.149     0.200
    28.714     0.654     0.200
    28.714     1.046     0.200
    28.986     1.311     0.200
    29.162    -1.247     0.200
    29.328     1.717     0.200
    29.338     1.233     0.200
    29.515     1.234     0.200
    29.516     2.146     0.200
    29.606     1.886     0.200
    29.668     1.648     0.200
    29.691     1.639     0.200
    29.768     1.807     0.200
    29.807     1.892     0.200
    29.907     2.484     0.200
    29.994     1.177     0.200
    30.048     2.429     0.200
    30.055     3.091     0.200
    30.058     1.792     0.200
    30.081     2.543     0.200
    30.081     2.873     0.200
    30.233     2.194     0.200
    30.258     1.433     0.200
    30.264     1.623     0.200
    30.264     1.806     0.200
    30.375     1.515     0.200
    30.391     1.373     0.200
    30.406     0.554     0.200
    30.443     1.525     0.200
    30.518     1.780     0.200
    30.611     1.479     0.200
    30.639     1.868     0.200
    30.653     1.213     0.200
    30.653     1.432     0.200
    30.660     1.366     0.200
    30.722     1.509     0.200
    30.754     0.667     0.200
    30.815     1.705     0.200
    30.819     1.273     0.200
    30.956     1.403     0.200
    31.042     2.607     0.200
    31.295     2.356     0.200
    31.318     1.418     0.200
    31.327     1.847     0.200
    31.557     1.608     0.200
    31.750     0.867     0.200
    31.750     1.282     0.200
    31.750     1.026     0.200
    31.750     1.086     0.200
    31.750     0.526     0.200
    31.791     2.185     0.200
    31.946     1.640     0.200
    31.975     1.134     0.200
    31.975     1.365     0.200
    31.975     1.261     0.200
    31.997     1.711     0.200
    32.024     1.170     0.200
    32.024     1.403     0.200
    32.245     1.952     0.200
    32.279    -1.538     0.200
    32.279    -1.395     0.200
    32.359     1.158     0.200
    32.360     1.815     0.200
    32.385     0.903     0.200
    32.407     2.001     0.200
    32.528     1.039     0.200
    32.705     1.163     0.200
    32.720     1.683     0.200
    32.727     1.516     0.200
    32.813     0.921     0.200
    32.813     1.144     0.200
    32.814     1.383     0.200
    32.844     2.212     0.200
    32.909     1.578     0.200
    32.947     1.738     0.200
    33.091     0.657     0.200
    33.262     1.790     0.200
    33.330     1.299     0.200
    33.406     0.636     0.200
    33.406     0.798     0.200
    33.463     1.663     0.200
    33.544     1.319     0.200
    33.565     1.271     0.200
    33.565     1.602     0.200
    33.565     1.365     0.200
    33.576     2.066     0.200
    33.647     1.403     0.200
    33.678     0.765     0.200
    33.680     1.347     0.200
    33.680     1.456     0.200
    33.691     1.023     0.200
    33.699     1.563     0.200
    33.737     1.474     0.200
    33.737    -0.171     0.200
    33.833     1.008     0.200
    33.837     1.255     0.200
    33.884     1.290     0.200
    33.884     1.450     0.200
    33.937     2.072     0.200
    33.992     0.021     0.200
    33.992     0.306     0.200
    34.043     1.361     0.200
    34.145     1.467     0.200
    34.179     1.004     0.200
    34.190     1.360     0.200
    34.194     1.449     0.200
    34.219     1.433     0.200
    34.339     1.664     0.200
    34.343     1.070     0.200
    34.343     1.256     0.200
    34.364     1.502     0.200
    34.422     1.597     0.200
    34.491     1.291     0.200
    34.719     0.720     0.200
    34.846     1.212     0.200
    34.867     1.137     0.200
    34.926     0.444     0.200
    34.970     0.724     0.200
    34.970     0.972     0.200
    35.014     0.964     0.200
    35.108     0.839     0.200
    35.119     1.233     0.200
    35.148     1.405     0.200
    35.152     1.181     0.200
    35.204     0.594     0.200
    35.204     0.364     0.200
    35.216     1.087     0.200
    35.260     1.613     0.200
    35.267     1.235     0.200
    35.271     0.880     0.200
    35.323     1.183     0.200
    35.331     2.805     0.200
    35.331     1.066     0.200
    35.339     0.685     0.200
    35.353     1.221     0.200
    35.372     0.642     0.200
    35.374     0.836     0.200
    35.425     1.039     0.200
    35.425     0.886     0.200
    35.435     1.269     0.200
    35.438     1.644     0.200
    35.438     0.685     0.200
    35.438     0.824     0.200
    35.441     0.743     0.200
    35.450     0.934     0.200
    35.457     1.031     0.200
    35.469     1.148     0.200
    35.537     0.940     0.200
    35.542     1.045     0.200
    35.602     1.377     0.200
    35.682     1.043     0.200
    35.708     0.435     0.200
    35.744     1.339     0.200
    35.744     0.919     0.200
    35.843    -1.115     0.200
    35.870     0.784     0.200
    35.945     1.267     0.200
    35.945     1.804     0.200
    35.959     1.031     0.200
    36.054     1.480     0.200
    36.117     1.027     0.200
    36.123     0.495     0.200
    36.230     0.613     0.200
    36.230     1.216     0.200
    36.297     0.799     0.200
    36.322     1.506     0.200
    36.400     1.417     0.200
    36.429     0.939     0.200
    36.429     0.822     0.200
    36.570    -0.108     0.200
    36.663     0.749     0.200
    36.663     0.999     0.200
    36.663     1.120     0.200
    36.807     1.744     0.200
    36.865     1.672     0.200
    36.892    -0.942     0.200
    36.969     1.252     0.200
    36.969     0.953     0.200
    37.169     1.309     0.200
    37.177     0.972     0.200
    37.396     0.671     0.200
    37.448     1.298     0.200
    37.448     1.175     0.200
    37.546     1.448     0.200
    37.546     1.677     0.200
    37.679     0.322     0.200
    37.679     0.531     0.200
    37.812     1.557     0.200
    37.837    -0.407     0.200
    38.079     1.213     0.200
    38.079     1.383     0.200
    38.400    -0.103     0.200
    38.400    -0.455     0.200
    38.520     1.115     0.200
    38.527     0.744     0.200
    38.561     0.604     0.200
    38.568     1.455     0.200
    38.669     0.778     0.200
    38.669     0.897     0.200
    38.747     0.840     0.200
    38.756    -1.533     0.200
    38.791     1.031     0.200
    38.806     0.450     0.200
    38.806     0.790     0.200
    38.826     1.498     0.200
    38.901     1.091     0.200
    39.004     1.124     0.200
    39.020     1.069     0.200
    39.124     0.447     0.200
    39.130     1.451     0.200
    39.194     0.146     0.200
    39.200     1.259     0.200
    39.200     1.368     0.200
    39.226     1.192     0.200
    39.226     1.008     0.200
    39.316     0.680     0.200
    39.451     0.946     0.200
    39.487     1.039     0.200
    39.583     1.662     0.200
    39.612     0.430     0.200
    39.639     1.349     0.200
    39.725     0.580     0.200
    39.731     0.705     0.200
    39.731     1.057     0.200
    39.731     0.873     0.200
    39.760     1.407     0.200
    39.769     1.351     0.200
    39.954     0.871     0.200
    39.967     0.592     0.200
    40.110     0.279     0.200
    40.126     0.201     0.200
    40.126     0.457     0.200
    40.371     0.424     0.200
    40.371     0.549     0.200
    40.401    -0.632     0.200
    40.401     0.298     0.200
    40.412     0.143     0.200
    40.412     0.497     0.200
    40.470     0.722     0.200
    40.487     1.613     0.200
    40.679     0.171     0.200
    40.690     0.935     0.200
    40.694     1.193     0.200
    40.855     0.639     0.200
    40.855     0.424     0.200
    40.856     1.240     0.200
    40.857     0.599     0.200
    40.899     0.581     0.200
    40.899     0.421     0.200
    41.021     0.671     0.200
    41.021     0.956     0.200
    41.027    -0.322     0.200
    41.058     0.955     0.200
    41.058     0.775     0.200
    41.129     0.975     0.200
    41.129     0.700     0.200
    41.139     0.159     0.200
    41.155     0.219     0.200
    41.182    -0.797     0.200
    41.302     0.601     0.200
    41.380    -0.176     0.200
    41.422    -0.011     0.200
    41.429     0.239     0.200
    41.429     0.466     0.200
    41.510     0.762     0.200
    41.510     0.563     0.200
    41.538     0.189     0.200
    41.585     0.032     0.200
    41.643    -1.965     0.200
    41.712     0.899     0.200
    41.712     1.109     0.200
    41.734    -0.200     0.200
    41.734     0.093     0.200
    41.737     0.987     0.200
    41.742     0.638     0.200
    41.742     0.429     0.200
    41.751     0.113     0.200
    41.830    -0.323     0.200
    41.830    -0.220     0.200
    41.849     0.716     0.200
    41.867     0.717     0.200
    41.922     0.003     0.200
    41.929     0.719     0.200
    41.929     0.586     0.200
    41.948     1.011     0.200
    42.011    -0.045     0.200
    42.010    -0.606     0.200
    42.010     0.345     0.200
    42.010    -0.456     0.200
    42.034     0.175     0.200
    42.079    -2.515     0.200
    42.143     0.545     0.200
    42.148    -0.226     0.200
    42.174     0.389     0.200
    42.199    -0.395     0.200
    42.247     0.917     0.200
    42.299    -0.131     0.200
    42.355    -0.154     0.200
    42.356     0.909     0.200
    42.356     1.228     0.200
    42.394     0.488     0.200
    42.436    -0.666     0.200
    42.464     1.320     0.200
    42.487    -0.431     0.200
    42.531     0.415     0.200
    42.530    -0.844     0.200
    42.530    -0.675     0.200
    42.571     0.772     0.200
    42.619     1.289     0.200
    42.677    -0.386     0.200
    42.683    -0.244     0.200
    42.683    -0.391     0.200
    42.710     0.877     0.200
    42.760    -0.313     0.200
    42.760    -0.175     0.200
    42.760    -0.034     0.200
    42.833     0.592     0.200
    42.854    -1.301     0.200
    42.878     0.188     0.200
    42.878    -0.005     0.200
    42.996    -0.230     0.200
    43.022     0.592     0.200
    43.029    -0.509     0.200
    43.036    -0.158     0.200
    43.100     0.367     0.200
    43.199     0.355     0.200
    43.257     0.480     0.200
    43.300     1.005     0.200
    43.324     0.654     0.200
    43.324     0.514     0.200
    43.337    -0.408     0.200
    43.395     0.537     0.200
    43.399     0.255     0.200
    43.409    -1.748     0.200
    43.409    -2.157     0.200
    43.413    -0.318     0.200
    43.459    -0.371     0.200
    43.471     0.189     0.200
    43.494     0.555     0.200
    43.641    -0.373     0.200
    43.667     0.843     0.200
    43.773    -0.206     0.200
    43.810     0.599     0.200
    43.919     1.133     0.200
    43.922    -0.459     0.200
    43.922    -0.330     0.200
    43.971    -0.178     0.200
    43.980    -0.234     0.200
    43.980    -0.051     0.200
    44.082    -0.293     0.200
    44.083     0.265     0.200
    44.083    -0.272     0.200
    44.109    -0.326     0.200
    44.150     0.284     0.200
    44.190     0.170     0.200
    44.210     0.175     0.200
    44.213     0.726     0.200
    44.312     0.109     0.200
    44.353    -0.132     0.200
    44.367     0.263     0.200
    44.383    -0.081     0.200
    44.428     0.375     0.200
    44.472    -0.162     0.200
    44.480    -0.206     0.200
    44.493    -0.480     0.200
    44.533     0.376     0.200
    44.606    -1.596     0.200
    44.625     0.691     0.200
    44.638     0.011     0.200
    44.648    -0.337     0.200
    44.667    -0.796     0.200
    44.687    -1.575     0.200
    44.694     0.076     0.200
    44.744    -0.829     0.200
    44.812    -0.634     0.200
    44.831    -0.616     0.200
    44.835     0.450     0.200
    44.835     0.212     0.200
    44.855    -0.187     0.200
    44.895     0.231     0.200
    44.905     0.115     0.200
    44.908    -1.357     0.200
    44.936    -0.301     0.200
    44.936     0.077     0.200
    44.965    -0.045     0.200
    44.983     0.407     0.200
    45.008    -0.146     0.200
    45.020     0.036     0.200
    45.070     0.060     0.200
    45.088    -0.143     0.200
    45.134     0.688     0.200
    45.135     0.943     0.200
    45.135     0.946     0.200
    45.156    -0.415     0.200
    45.179    -0.681     0.200
    45.194    -0.769     0.200
    45.196    -0.076     0.200
    45.196     0.171     0.200
    45.200     0.289     0.200
    45.214     0.211     0.200
    45.226    -0.692     0.200
    45.231    -1.034     0.200
    45.268    -0.417     0.200
    45.280    -0.259     0.200
    45.281     0.288     0.200
    45.294     0.293     0.200
    45.338     0.738     0.200
    45.440     0.210     0.200
    45.484    -0.146     0.200
    45.484    -0.005     0.200
    45.559    -0.438     0.200
    45.566     1.026     0.200
    45.577    -0.102     0.200
    45.577    -0.235     0.200
    45.581     0.620     0.200
    45.593    -1.475     0.200
    45.593    -1.256     0.200
    45.625     0.218     0.200
    45.625     0.044     0.200
    45.660    -0.602     0.200
    45.663     0.734     0.200
    45.678    -1.111     0.200
    45.698     0.111     0.200
    45.707     0.005     0.200
    45.719    -0.200     0.200
    45.734    -0.446     0.200
    45.736     0.080     0.200
    45.770     0.560     0.200
    45.781    -0.594     0.200
    45.786    -1.377     0.200
    45.786    -1.692     0.200
    45.814     0.292     0.200
    45.824     0.331     0.200
    45.848     1.153     0.200
    45.886    -0.011     0.200
    45.903     0.127     0.200
    45.920    -0.397     0.200
    45.975    -0.485     0.200
    45.980    -1.233     0.200
    46.016    -0.038     0.200
    46.030    -1.013     0.200
    46.057    -0.452     0.200
    46.061    -0.395     0.200
    46.087     0.300     0.200
    46.108     0.123     0.200
    46.117     0.704     0.200
    46.119    -0.418     0.200
    46.130     1.005     0.200
    46.130    -0.470     0.200
    46.136     0.664     0.200
    46.160     0.615     0.200
    46.160     0.795     0.200
    46.162     0.414     0.200
    46.186    -0.348     0.200
    46.186    -0.110     0.200
    46.283    -0.471     0.200
    46.288    -0.717     0.200
    46.295    -0.545     0.200
    46.311    -0.418     0.200
    46.311    -0.592     0.200
    46.328     0.679     0.200
    46.339    -0.428     0.200
    46.365    -1.240     0.200
    46.399    -0.714     0.200
    46.423    -0.458     0.200
    46.453    -0.707     0.200
    46.474     0.997     0.200
    46.573    -0.360     0.200
    46.581    -0.234     0.200
    46.609    -0.142     0.200
    46.608    -1.006     0.200
    46.620    -0.589     0.200
    46.655    -0.576     0.200
    46.686    -0.113     0.200
    46.693    -1.272     0.200
    46.693    -0.711     0.200
    46.719     0.466     0.200
    46.727    -0.033     0.200
    46.741    -0.726     0.200
    46.770    -0.425     0.200
    46.770    -0.882     0.200
    46.782    -0.493     0.200
    46.938     0.343     0.200
    46.870    -0.340     0.200
    46.905    -0.002     0.200
    46.905    -0.322     0.200
    46.941     1.250     0.200
    46.967     1.044     0.200
    46.971    -0.190     0.200
    46.976    -0.568     0.200
    47.029     0.158     0.200
    47.033    -0.066     0.200
    47.055    -0.943     0.200
    47.056     0.906     0.200
    47.087     0.962     0.200
    47.094     0.201     0.200
    47.171    -0.385     0.200
    47.202     0.243     0.200
    47.205    -0.335     0.200
    47.206     0.518     0.200
    47.234     0.841     0.200
    47.243     0.636     0.200
    47.246     0.321     0.200
    47.260    -0.002     0.200
    47.282     0.321     0.200
    47.298    -0.252     0.200
    47.330    -0.048     0.200
    47.355    -0.520     0.200
    47.376    -0.404     0.200
    47.425    -0.184     0.200
    47.438    -0.001     0.200
    47.476    -0.367     0.200
    47.590     0.715     0.200
    47.590     0.293     0.200
    47.590     0.880     0.200
    47.590     0.646     0.200
    47.606     0.108     0.200
    47.617     0.764     0.200
    47.619     0.044     0.200
    47.619    -0.200     0.200
    47.629    -0.163     0.200
    47.690     0.292     0.200
    47.695    -0.159     0.200
    47.700     0.610     0.200
    47.714    -0.063     0.200
    47.714     0.043     0.200
    47.743    -0.503     0.200
    47.757    -0.164     0.200
    47.795     0.609     0.200
    47.951    -0.155     0.200
    47.953    -0.496     0.200
    47.985    -0.279     0.200
    47.985     0.112     0.200
    47.994     0.045     0.200
    48.017     0.076     0.200
    48.019    -0.072     0.200
    48.025     0.362     0.200
    48.032     0.138     0.200
    48.043     0.986     0.200
    48.043     0.619     0.200
    48.063    -0.297     0.200
    48.085     0.356     0.200
    48.112     0.712     0.200
    48.115    -0.188     0.200
    48.121    -0.687     0.200
    48.144     0.177     0.200
    48.144    -0.352     0.200
    48.190    -0.195     0.200
    48.196     0.414     0.200
    48.201     0.166     0.200
    48.201     0.301     0.200
    48.207    -0.663     0.200
    48.207    -0.657     0.200
    48.208    -0.563     0.200
    48.208    -0.602     0.200
    48.319    -0.378     0.200
    48.371     0.069     0.200
    48.377     0.040     0.200
    48.396     0.070     0.200
    48.396     0.230     0.200
    48.438     0.311     0.200
    48.438     0.460     0.200
    48.447    -0.031     0.200
    48.459     0.072     0.200
    48.472     0.107     0.200
    48.480    -0.596     0.200
    48.496     0.983     0.200
    48.563    -0.014     0.200
    48.605     0.014     0.200
    48.625     0.900     0.200
    48.733     0.105     0.200
    48.750    -0.412     0.200
    48.755     0.802     0.200
    48.755     0.636     0.200
    48.767    -0.060     0.200
    48.779     0.124     0.200
    48.794     0.390     0.200
    48.810    -0.264     0.200
    48.810     0.099     0.200
    48.812    -1.029     0.200
    48.812    -0.136     0.200
    48.874    -0.022     0.200
    48.906     0.141     0.200
    49.023    -0.243     0.200
    49.055    -0.192     0.200
    49.055    -0.052     0.200
    49.115     0.096     0.200
    49.129    -0.270     0.200
    49.131     0.113     0.200
    49.205    -0.217     0.200
    49.212     0.000     0.200
    49.271    -0.281     0.200
    49.293     0.056     0.200
    49.317     1.064     0.200
    49.325     0.489     0.200
    49.330    -0.005     0.200
    49.340    -1.367     0.200
    49.360     1.234     0.200
    49.381    -0.026     0.200
    49.478     0.200     0.200
    49.510     2.551     0.200
    49.552     0.781     0.200
    49.577     0.102     0.200
    49.598     0.846     0.200
    49.605     0.314     0.200
    49.648     0.718     0.200
    49.662     4.043     0.200
    49.677    -0.504     0.200
    49.678     0.028     0.200
    49.678    -0.103     0.200
    49.682    -0.631     0.200
    49.682    -0.346     0.200
    49.741    -1.069     0.200
    49.750     0.331     0.200
    49.750     0.607     0.200
    49.764    -0.027     0.200
    49.773     0.605     0.200
    49.790    -0.005     0.200
    49.833     0.290     0.200
    49.908    -0.003     0.200
    49.908     0.247     0.200
    49.910     1.833     0.200
    50.012    -0.354     0.200
    50.014    -0.196     0.200
    50.014     0.027     0.200
    50.036     0.559     0.200
    50.036     0.450     0.200
    50.054    -0.120     0.200
    50.058    -0.402     0.200
    50.058     0.387     0.200
    50.070     0.277     0.200
    50.088     1.216     0.200
    50.118     0.180     0.200
    50.137     0.604     0.200
    50.190     2.450     0.200
    50.236    -0.961     0.200
    50.333    -0.326     0.200
    50.406    -0.229     0.200
    50.419     0.047     0.200
    50.419    -0.138     0.200
    50.419    -0.144     0.200
    50.419    -0.359     0.200
    50.467    -0.102     0.200
    50.473    -0.509     0.200
    50.473    -0.325     0.200
    50.551     0.052     0.200
    50.569     0.810     0.200
    50.583     2.169     0.200
    50.612     0.763     0.200
    50.612     0.658     0.200
    50.614    -0.268     0.200
    50.646     0.270     0.200
    50.663     1.216     0.200
    50.727     0.845     0.200
    50.740     0.024     0.200
    50.740    -0.155     0.200
    50.802     0.655     0.200
    50.802     0.489     0.200
    50.805    -0.774     0.200
    50.805    -0.534     0.200
    50.807    -0.516     0.200
    50.820    -0.104     0.200
    50.865     0.899     0.200
    50.893    -0.671     0.200
    50.927     1.763     0.200
    50.960     0.116     0.200
    51.006     0.422     0.200
    51.025     0.076     0.200
    51.025     0.315     0.200
    51.074     0.662     0.200
    51.140     0.626     0.200
    51.152     0.153     0.200
    51.160     0.029     0.200
    51.198    -0.547     0.200
    51.200     0.009     0.200
    51.215    -0.121     0.200
    51.254    -0.395     0.200
    51.275     0.482     0.200
    51.326     0.598     0.200
    51.515     0.789     0.200
    51.568    -0.177     0.200
    51.583     0.907     0.200
    51.601     0.584     0.200
    51.602    -0.058     0.200
    51.651    -0.517     0.200
    51.695     0.770     0.200
    51.695     0.447     0.200
    51.699    -0.169     0.200
    51.730     0.336     0.200
    51.763     0.223     0.200
    51.839     0.314     0.200
    51.839    -0.032     0.200
    51.860    -0.109     0.200
    51.956    -0.216     0.200
    51.995    -2.075     0.200
    52.003     0.124     0.200
    52.014    -0.566     0.200
    52.014    -0.369     0.200
    52.023    -0.061     0.200
    52.078    -1.027     0.200
    52.135    -0.163     0.200
    52.220    -2.501     0.200
    52.220    -2.505     0.200
    52.220    -2.121     0.200
    52.240     0.231     0.200
    52.251    -0.618     0.200
    52.285    -0.984     0.200
    52.285    -1.240     0.200
    52.362    -0.961     0.200
    52.362    -0.731     0.200
    52.374    -0.817     0.200
    52.417    -0.510     0.200
    52.419    -0.408     0.200
    52.477     0.369     0.200
    52.585    -1.178     0.200
    52.665    -2.184     0.200
    52.757    -0.971     0.200
    52.772    -0.571     0.200
    52.803    -1.177     0.200
    52.825    -0.819     0.200
    52.838    -0.064     0.200
    52.838     0.256     0.200
    52.844    -0.608     0.200
    52.876    -0.267     0.200
    52.876    -0.178     0.200
    52.876    -0.267     0.200
    52.915    -0.779     0.200
    53.070    -0.894     0.200
    53.070    -1.258     0.200
    53.109    -0.801     0.200
    53.109    -1.118     0.200
    53.173    -0.803     0.200
    53.173    -1.226     0.200
    53.266    -0.419     0.200
    53.266    -0.184     0.200
    53.344    -2.185     0.200
    53.361    -0.165     0.200
    53.361    -0.064     0.200
    53.501    -0.078     0.200
    53.542    -0.803     0.200
    53.600    -0.983     0.200
    53.694    -2.181     0.200
    53.694    -3.011     0.200
    53.842    -0.331     0.200
    53.842    -1.065     0.200
    53.846     0.208     0.200
    53.925     0.626     0.200
    53.981    -0.414     0.200
    53.984    -0.115     0.200
    54.042    -1.095     0.200
    54.042    -1.239     0.200
    54.067    -2.431     0.200
    54.317     0.335     0.200
    54.317    -0.075     0.200
    54.321    -0.071     0.200
    54.417    -0.467     0.200
    54.434     0.756     0.200
    54.671    -0.703     0.200
    54.671    -0.504     0.200
    54.802    -0.320     0.200
    54.802     0.383     0.200
    54.912    -1.248     0.200
    55.093     0.183     0.200
    55.106     0.160     0.200
    55.106     0.160     0.200
    55.599    -0.220     0.200
    56.706    -0.453     0.200
    56.726    -0.629     0.200
    56.750     1.362     0.200
    57.489    -0.875     0.200
    57.518     0.353     0.200
    57.878    -1.300     0.200
    58.147    -0.999     0.200
    58.151    -1.245     0.200
    58.151    -1.030     0.200
    58.259    -0.060     0.200
    58.790    -1.844     0.200
    59.066    -1.556     0.200
    59.115     0.139     0.200
    59.158    -2.391     0.200
    59.169    -1.165     0.200
    59.247    -1.099     0.200
    59.950    -1.281     0.200
    60.046    -1.534     0.200
    60.182    -1.375     0.200
    60.195    -1.529     0.200
    60.214    -1.584     0.200
    60.218    -2.062     0.200
    60.218    -1.753     0.200
    60.333     0.253     0.200
    60.346    -2.231     0.200
    60.347    -1.907     0.200
    60.347    -1.907     0.200
    60.388    -1.537     0.200
    60.451    -4.746     0.200
    60.478    -0.432     0.200
    60.544    -1.631     0.200
    61.035    -0.105     0.200
    61.035    -0.284     0.200
    61.469    -1.053     0.200
    61.646    -1.728     0.200
    61.695    -0.953     0.200
    61.974    -0.224     0.200
    62.402    -2.542     0.200
    62.402    -2.786     0.200
    62.854    -1.500     0.200
    62.854    -1.207     0.200
    62.963    -1.362     0.200
    63.036    -1.765     0.200
    63.036    -1.504     0.200
    63.336    -2.014     0.200
    63.336    -1.273     0.200
    63.711    -0.153     0.200
    64.137    -0.708     0.200
    64.591    -0.597     0.200
    64.711    -0.876     0.200
    64.975    -0.892     0.200
    65.148    -1.613     0.200
    65.148    -1.513     0.200
    65.149    -1.513     0.200
    65.149    -1.664     0.200
    65.166    -1.517     0.200
    65.173    -0.571     0.200
    65.211    -1.715     0.200
    65.668    -2.964     0.200
    65.667    -0.457     0.200
    65.799    -1.516     0.200
    65.845     0.002     0.200
    66.058    -1.373     0.200
    66.220    -1.013     0.200
    66.237    -1.542     0.200
    66.358    -1.826     0.200
    66.358    -2.285     0.200
    66.363    -1.417     0.200
    66.458    -1.392     0.200
    66.677    -1.005     0.200
    66.884    -1.726     0.200
    66.903    -3.151     0.200
    66.927    -1.285     0.200
    67.107    -0.949     0.200
    67.119    -0.720     0.200
    67.298    -1.648     0.200
    67.326    -0.757     0.200
    67.367    -1.065     0.200
    67.434    -0.214     0.200
    67.473     0.632     0.200
    67.552    -1.597     0.200
    67.598    -0.538     0.200
    67.719    -0.793     0.200
    67.781    -2.090     0.200
    67.781    -1.610     0.200
    67.792    -0.930     0.200
    67.998    -0.460     0.200
    68.033    -0.161     0.200
    68.059    -1.024     0.200
    68.142     0.247     0.200
    68.212    -1.886     0.200
    68.321    -0.646     0.200
    68.333    -1.041     0.200
    68.346    -1.184     0.200
    68.693    -2.482     0.200
    68.778    -1.109     0.200
    68.949    -1.731     0.200
    69.142    -0.563     0.200
    69.263    -0.773     0.200
    69.281    -0.413     0.200
    69.301    -0.698     0.200
    69.307    -1.152     0.200
    69.455    -0.477     0.200
    69.628    -0.422     0.200
    69.735    -0.509     0.200
    69.798    -0.311     0.200
    69.834    -2.827     0.200
    69.860    -0.861     0.200
    69.905    -0.868     0.200
    69.908    -1.007     0.200
    70.004    -0.767     0.200
    70.019    -1.257     0.200
    70.022    -0.852     0.200
    70.049    -2.741     0.200
    70.080    -0.668     0.200
    70.014     0.162     0.200
    70.122    -1.046     0.200
    70.287    -2.495     0.200
    70.350    -0.856     0.200
    70.387     0.610     0.200
    70.521    -0.888     0.200
    70.564    -0.881     0.200
    70.704    -0.906     0.200
    70.756    -0.235     0.200
    70.781    -0.747     0.200
    70.908    -0.567     0.200
    70.947    -0.505     0.200
    70.967     0.827     0.200
    70.967     0.978     0.200
    70.968    -0.368     0.200
    70.968    -0.229     0.200
    71.022    -0.452     0.200
    71.043    -0.581     0.200
    71.078    -1.970     0.200
    71.078    -2.146     0.200
    71.086    -2.249     0.200
    71.086    -2.117     0.200
    71.102    -2.791     0.200
    71.139    -1.861     0.200
    71.156    -0.284     0.200
    71.156    -0.063     0.200
    71.196    -0.509     0.200
    71.197    -0.114     0.200
    71.354    -0.589     0.200
    71.354    -0.240     0.200
    71.354    -0.449     0.200
    71.355    -0.562     0.200
    71.476    -0.677     0.200
    71.476    -0.388     0.200
    71.535    -0.843     0.200
    71.551    -0.274     0.200
    71.628     0.135     0.200
    71.721    -0.032     0.200
    71.804    -1.157     0.200
    71.835    -1.081     0.200
    71.835    -0.943     0.200
    71.975     0.070     0.200
    71.975    -0.280     0.200
    71.991    -2.778     0.200
    72.060     0.322     0.200
    72.107    -1.488     0.200
    72.107    -1.367     0.200
    72.107    -1.337     0.200
    72.160    -1.012     0.200
    72.190    -0.451     0.200
    72.197    -0.609     0.200
    72.227    -0.625     0.200
    72.227    -0.385     0.200
    72.251    -0.627     0.200
    72.251    -0.828     0.200
    72.310    -0.816     0.200
    72.333    -0.614     0.200
    72.485    -1.019     0.200
    72.514    -0.680     0.200
    72.514    -0.991     0.200
    72.521    -0.770     0.200
    72.521    -0.630     0.200
    72.521    -0.704     0.200
    72.529    -0.919     0.200
    72.534    -0.888     0.200
    72.547    -0.186     0.200
    72.757     0.168     0.200
    73.089    -0.392     0.200
    73.125    -0.545     0.200
    73.152    -2.164     0.200
    73.176    -0.807     0.200
    73.221    -1.467     0.200
    73.467    -0.212     0.200
    73.553    -0.838     0.200
    73.583    -0.389     0.200
    73.608     0.090     0.200
    73.617    -0.518     0.200
    73.658    -0.732     0.200
    73.715    -0.266     0.200
    73.719     2.511     0.200
    73.729    -0.473     0.200
    73.788     0.198     0.200
    73.790    -0.576     0.200
    73.794    -0.737     0.200
    73.794    -0.428     0.200
    73.843    -0.442     0.200
    73.869    -0.465     0.200
    73.920    -0.155     0.200
    73.923    -0.212     0.200
    74.076    -0.070     0.200
    74.131    -0.292     0.200
    74.176    -1.152     0.200
    74.194    -1.153     0.200
    74.202    -1.411     0.200
    74.205    -1.220     0.200
    74.236    -0.378     0.200
    74.249     0.098     0.200
    74.356    -0.197     0.200
    74.389     0.909     0.200
    74.389    -0.189     0.200
    74.427     0.184     0.200
    74.479     0.122     0.200
    74.509    -0.785     0.200
    74.718    -0.929     0.200
    74.723    -0.120     0.200
    74.730    -0.557     0.200
    74.773    -0.657     0.200
    74.792    -2.914     0.200
    74.881    -1.032     0.200
    74.907    -0.435     0.200
    75.000    -1.217     0.200
    75.021    -0.865     0.200
    75.067    -0.369     0.200
    75.093    -0.851     0.200
    75.125    -1.464     0.200
    75.351    -0.829     0.200
    75.368    -1.207     0.200
    75.368    -1.425     0.200
    75.370     0.665     0.200
    75.443    -1.056     0.200
    75.443    -1.355     0.200
    75.571     0.791     0.200
    75.571     0.912     0.200
    75.643    -0.798     0.200
    75.650    -1.536     0.200
    75.664    -1.616     0.200
    75.767    -1.103     0.200
    75.854    -0.497     0.200
    75.912    -0.430     0.200
    75.929    -0.127     0.200
    75.929    -0.227     0.200
    75.943     0.695     0.200
    75.951    -1.053     0.200
    75.951    -0.148     0.200
    75.951    -0.382     0.200
    75.967    -0.842     0.200
    76.022    -0.356     0.200
    76.080    -1.480     0.200
    76.091    -1.043     0.200
    76.150    -1.078     0.200
    76.157    -0.117     0.200
    76.330    -0.421     0.200
    76.330    -1.001     0.200
    76.361    -1.374     0.200
    76.383    -0.898     0.200
    76.434     0.415     0.200
    76.450    -0.778     0.200
    76.548    -1.332     0.200
    76.562    -3.411     0.200
    76.603    -1.041     0.200
    76.614     0.602     0.200
    76.624    -1.356     0.200
    76.630    -0.560     0.200
    76.636    -1.229     0.200
    76.654     0.670     0.200
    76.694     0.807     0.200
    76.700    -1.287     0.200
    76.786    -0.966     0.200
    76.830    -0.928     0.200
    76.830    -1.118     0.200
    76.865    -1.245     0.200
    76.875    -0.088     0.200
    76.896    -0.967     0.200
    76.896    -0.649     0.200
    76.896    -0.813     0.200
    76.904    -1.134     0.200
    76.908    -0.755     0.200
    76.963    -1.182     0.200
    76.980    -0.257     0.200
    76.978    -0.367     0.200
    76.983     0.524     0.200
    76.987    -1.096     0.200
    77.096    -0.580     0.200
    77.115    -1.114     0.200
    77.138    -0.945     0.200
    77.219     0.405     0.200
    77.243    -0.432     0.200
    77.251    -1.572     0.200
    77.302     1.028     0.200
    77.339    -1.355     0.200
    77.343    -1.291     0.200
    77.582    -1.818     0.200
    77.589    -0.460     0.200
    77.599     0.484     0.200
    77.599     0.604     0.200
    77.598    -1.511     0.200
    77.613    -1.115     0.200
    77.618    -1.123     0.200
    77.712     0.555     0.200
    77.821    -0.550     0.200
    77.903    -4.104     0.200
    78.147     0.249     0.200
    78.148     0.339     0.200
    78.355    -0.702     0.200
    78.460    -0.981     0.200
    78.460    -1.180     0.200
    78.554    -2.096     0.200
    78.561     0.466     0.200
    78.572     0.508     0.200
    78.604    -1.369     0.200
    78.611    -1.709     0.200
    78.664    -0.795     0.200
    78.730    -1.680     0.200
    78.730    -2.161     0.200
    78.744    -1.636     0.200
    78.744    -1.235     0.200
    78.803     0.638     0.200
    78.831     0.439     0.200
    78.834    -0.827     0.200
    78.838    -1.052     0.200
    78.838    -0.632     0.200
    78.838    -0.453     0.200
    78.839    -1.159     0.200
    78.854    -1.138     0.200
    78.887    -1.788     0.200
    78.898    -1.279     0.200
    78.946    -0.225     0.200
    78.946    -0.545     0.200
    79.051     0.306     0.200
    79.052    -0.019     0.200
    79.052     0.219     0.200
    79.063     0.193     0.200
    79.063     0.519     0.200
    79.107     0.396     0.200
    79.113    -0.554     0.200
    79.116    -1.470     0.200
    79.152    -1.554     0.200
    79.174    -0.424     0.200
    79.195    -1.698     0.200
    79.195    -1.899     0.200
    79.208    -1.590     0.200
    79.208    -1.471     0.200
    79.208    -2.170     0.200
    79.247    -1.187     0.200
    79.247    -1.386     0.200
    79.247    -1.386     0.200
    79.247    -1.277     0.200
    79.312    -0.435     0.200
    79.312    -0.236     0.200
    79.360    -1.799     0.200
    79.378     0.506     0.200
    79.395    -0.568     0.200
    79.442    -1.345     0.200
    79.487    -1.388     0.200
    79.487    -1.489     0.200
    79.495    -2.131     0.200
    79.705     0.131     0.200
    79.712    -1.709     0.200
    79.773     0.044     0.200
    79.785    -0.582     0.200
    79.790     1.269     0.200
    79.885     0.237     0.200
    79.931    -1.591     0.200
    79.958    -0.514     0.200
    79.958    -0.334     0.200
    79.969    -1.404     0.200
    79.969    -1.195     0.200
    79.969    -0.795     0.200
    80.046     0.290     0.200
    80.129    -1.154     0.200
    80.134     0.121     0.200
    80.147    -0.849     0.200
    80.147    -0.689     0.200
    80.292     0.433     0.200
    80.353    -0.788     0.200
    80.353    -0.958     0.200
    80.353    -1.458     0.200
    80.393    -0.273     0.200
    80.393     0.366     0.200
    80.414     0.413     0.200
    80.414     0.563     0.200
    80.416    -0.114     0.200
    80.419     0.588     0.200
    80.460    -2.020     0.200
    80.464    -0.563     0.200
    80.463    -0.047     0.200
    80.523     0.934     0.200
    80.528    -1.692     0.200
    80.542    -0.050     0.200
    80.556    -1.442     0.200
    80.557     0.449     0.200
    80.568    -1.105     0.200
    80.606    -1.408     0.200
    80.623    -0.498     0.200
    80.624    -0.807     0.200
    80.641     0.903     0.200
    80.641     0.682     0.200
    80.676    -0.784     0.200
    80.691    -0.067     0.200
    80.714    -1.689     0.200
    80.733    -0.598     0.200
    80.766    -0.262     0.200
    80.814    -0.119     0.200
    80.885    -0.598     0.200
    80.905    -0.403     0.200
    80.922    -0.443     0.200
    80.927     0.278     0.200
    80.942    -1.302     0.200
    80.955    -0.270     0.200
    80.955    -0.370     0.200
    80.970    -1.016     0.200
    81.015    -0.189     0.200
    81.045     0.054     0.200
    81.083    -0.551     0.200
    81.124    -1.966     0.200
    81.145     0.012     0.200
    81.143    -1.067     0.200
    81.182    -0.072     0.200
    81.197    -2.755     0.200
    81.218    -2.964     0.200
    81.241    -0.987     0.200
    81.305    -2.121     0.200
    81.417    -1.314     0.200
    81.455    -0.213     0.200
    81.479    -1.381     0.200
    81.492    -0.010     0.200
    81.507    -0.389     0.200
    81.528    -1.602     0.200
    81.596    -0.758     0.200
    81.656    -1.075     0.200
    81.663    -0.051     0.200
    81.664     0.085     0.200
    81.681    -1.076     0.200
    81.681    -0.606     0.200
    81.766     0.060     0.200
    81.771    -0.415     0.200
    81.776    -0.205     0.200
    81.849    -0.885     0.200
    81.868    -0.790     0.200
    81.869    -0.810     0.200
    81.869    -0.792     0.200
    82.023    -0.100     0.200
    82.158    -0.902     0.200
    82.161    -2.321     0.200
    82.177    -1.203     0.200
    82.250    -1.983     0.200
    82.253    -0.201     0.200
    82.352    -0.828     0.200
    82.427    -0.333     0.200
    82.431     0.392     0.200
    82.431     0.572     0.200
    82.465    -0.702     0.200
    82.546    -1.247     0.200
    82.546    -0.999     0.200
    82.583    -1.118     0.200
    82.592    -0.287     0.200
    82.595    -0.481     0.200
    82.635    -2.688     0.200
    82.649    -0.557     0.200
    82.651     0.228     0.200
    82.653    -0.333     0.200
    82.684    -1.143     0.200
    82.729     3.004     0.200
    82.745    -0.058     0.200
    82.754    -3.104     0.200
    82.754    -1.533     0.200
    82.797    -0.529     0.200
    82.800    -1.839     0.200
    82.852    -0.253     0.200
    82.852    -0.638     0.200
    82.852    -0.313     0.200
    82.877    -0.797     0.200
    83.048    -2.421     0.200
    83.139     0.008     0.200
    83.178    -1.393     0.200
    83.262     0.077     0.200
    83.270    -1.967     0.200
    83.295     0.607     0.200
    83.357    -0.810     0.200
    83.384     0.553     0.200
    83.455    -1.514     0.200
    83.486    -0.982     0.200
    83.486    -1.172     0.200
    83.492    -0.302     0.200
    83.557    -1.136     0.200
    83.563    -0.368     0.200
    83.639     0.443     0.200
    83.669    -0.767     0.200
    83.709    -1.312     0.200
    83.713     0.469     0.200
    83.746     0.300     0.200
    83.827     0.182     0.200
    83.852    -0.340     0.200
    83.908    -1.247     0.200
    83.910    -0.604     0.200
    83.910    -0.735     0.200
    83.960    -1.190     0.200
    83.963     0.196     0.200
    84.010     0.857     0.200
    84.013     1.039     0.200
    84.089     0.154     0.200
    84.096    -0.384     0.200
    84.157     0.009     0.200
    84.195    -0.080     0.200
    84.220     0.589     0.200
    84.236    -0.188     0.200
    84.293     0.422     0.200
    84.317     0.602     0.200
    84.376     1.100     0.200
    84.582    -1.157     0.200
    84.621     0.207     0.200
    84.621     0.967     0.200
    84.625    -0.051     0.200
    85.069    -2.079     0.200
    85.087    -0.093     0.200
    85.087     0.081     0.200
    85.097    -0.716     0.200
    85.128    -1.574     0.200
    85.143    -2.247     0.200
    85.155    -2.008     0.200
    85.256    -1.907     0.200
    85.337    -1.916     0.200
    85.415     1.697     0.200
    85.465    -1.851     0.200
    85.510    -0.921     0.200
    86.292    -0.733     0.200
    86.368    -1.804     0.200
    86.469     0.002     0.200
    86.497    -1.133     0.200
    86.520    -3.946     0.200
    86.628    -0.797     0.200
    86.658    -0.319     0.200
    86.807     0.552     0.200
    87.279    -0.631     0.200
    87.515    -1.562     0.200
    87.656    -1.236     0.200
    88.234    -1.192     0.200
    89.000    -1.875     0.200
    89.751     0.442     0.200
    89.751     0.211     0.200
    90.419    -1.304     0.200
    90.595    -2.220     0.200
    91.219     0.887     0.200
    91.414     2.283     0.200
    91.519    -0.104     0.200
    91.603    -0.493     0.200
    91.689    -0.460     0.200
    91.709     0.419     0.200
    91.784    -1.631     0.200
    91.996    -1.385     0.200
    92.158    -0.558     0.200
    92.302     0.327     0.200
    92.810    -0.971     0.200
    92.889    -0.893     0.200
    93.173    -1.386     0.200
    93.303    -0.671     0.200
    93.303    -0.241     0.200
    93.327    -1.999     0.200
    93.557    -0.879     0.200
    93.803    -1.431     0.200
    93.807    -0.926     0.200
    94.061    -0.671     0.200
    94.659    -0.465     0.200
    96.399    -1.318     0.200
    96.399    -1.572     0.200
    96.602    -0.591     0.200
    96.602    -0.452     0.200
    97.255    -0.453     0.200
    97.515    -1.375     0.200
    97.515    -0.936     0.200
    97.523    -1.691     0.200
    97.528    -1.564     0.200
    97.529    -1.567     0.200
    98.271    -0.928     0.200
    13.137     3.446     0.200
    13.137     3.607     0.200
    16.643     2.981     0.200
    18.164    -3.706     0.200
    20.036    -0.640     0.200
    20.049     0.016     0.200
    24.640     1.546     0.200
    31.180     1.777     0.200
    32.270     1.433     0.200
    45.663     1.360     0.200
    54.596    -0.244     0.200
    57.707    -0.777     0.200
    64.692    -1.683     0.200
    56.406    -1.179     0.200
    56.406    -1.179     0.200
    59.234    -1.590     0.200
    59.238    -1.619     0.200
    66.272    -1.819     0.200
    66.272    -1.819     0.200
    19.414    -0.586     0.200
    19.427    -1.842     0.200
    19.427    -1.268     0.200
    19.427    -1.262     0.200
    25.898    -2.045     0.200
    25.834     0.948     0.200
    27.218    -1.486     0.200
    27.221    -1.513     0.200
    30.134    -0.317     0.200
    30.178     1.236     0.200
    30.509    -0.187     0.200
    31.550     1.030     0.200
    32.292    -0.886     0.200
    33.459     1.259     0.200
    33.737     0.376     0.200
    38.442     0.982     0.200
    39.045     0.598     0.200
    42.598    -2.464     0.200
    44.961    -0.408     0.200
    44.962    -0.408     0.200
    49.290     0.694     0.200
    53.068    -2.599     0.200
    53.068    -2.595     0.200
    55.206    -1.441     0.200
    55.206    -1.441     0.200
    58.167    -1.092     0.200
    58.170    -1.122     0.200
    60.201    -2.794     0.200
    60.201    -2.792     0.200
    63.552    -0.582     0.200
    65.180    -1.920     0.200
    65.180    -1.926     0.200
    70.941    -2.185     0.200
    70.941    -2.191     0.200
    72.693    -1.394     0.200
    78.838    -1.098     0.200
    81.747    -0.836     0.200
    83.004    -0.776     0.200
    83.004    -0.776     0.200
    19.411    -0.852     0.200
    19.424    -0.988     0.200
    19.424    -0.993     0.200
    23.974    -0.363     0.200
    25.818    -1.854     0.200
    25.909    -0.356     0.200
    26.606    -0.590     0.200
    26.907     1.668     0.200
    27.164    -0.810     0.200
    27.166    -0.835     0.200
    30.582     1.702     0.200
    30.582     1.706     0.200
    31.606     0.718     0.200
    31.606     0.720     0.200
    31.937     2.547     0.200
    33.505     1.838     0.200
    33.761    -0.127     0.200
    35.559     2.118     0.200
    36.227     2.066     0.200
    37.410     2.310     0.200
    42.529    -1.899     0.200
    44.785     0.509     0.200
    45.027    -0.485     0.200
    45.027    -0.487     0.200
    51.989     0.816     0.200
    53.009    -1.921     0.200
    55.123    -0.663     0.200
    55.123    -1.433     0.200
    55.123    -0.665     0.200
    58.322     1.050     0.200
    60.117    -2.162     0.200
    60.117    -2.159     0.200
    61.036    -1.896     0.200
    63.852    -0.892     0.200
    65.089    -2.713     0.200
    65.089    -2.711     0.200
    65.280    -0.723     0.200
    70.856    -2.220     0.200
    70.856    -2.220     0.200
    73.654     2.007     0.200
    75.429     0.400     0.200
    76.912     0.173     0.200
    78.777    -0.711     0.200
    18.810    -0.165     0.200
    20.202     0.225     0.200
    20.578     0.364     0.200
    20.916    -1.001     0.200
    20.916    -1.986     0.200
    21.352     0.845     0.200
    21.565     1.636     0.200
    21.588     1.427     0.200
    22.468     1.526     0.200
    22.616     1.116     0.200
    22.626     1.151     0.200
    22.748     0.442     0.200
    22.775     2.479     0.200
    22.775     1.776     0.200
    22.923     0.698     0.200
    23.376     0.017     0.200
    23.797     1.088     0.200
    23.888     1.236     0.200
    23.983     0.785     0.200
    24.211     1.085     0.200
    24.610     2.784     0.200
    24.810     1.833     0.200
    24.941     2.312     0.200
    24.978     1.781     0.200
    25.352     1.617     0.200
    25.352     0.461     0.200
    25.598     2.459     0.200
    25.617     2.042     0.200
    25.808     2.370     0.200
    26.026     1.353     0.200
    26.166     1.961     0.200
    26.537     1.062     0.200
    26.680    -1.285     0.200
    26.680    -1.137     0.200
    26.811     1.268     0.200
    27.023    -0.174     0.200
    27.123    -2.794     0.200
    27.123    -0.419     0.200
    27.326     1.977     0.200
    27.326     2.688     0.200
    27.372     1.855     0.200
    28.276     2.359     0.200
    28.323     2.227     0.200
    28.370    -2.412     0.200
    28.700     2.508     0.200
    28.695     1.033     0.200
    28.734     1.422     0.200
    28.889     1.234     0.200
    28.930     1.995     0.200
    28.930     1.604     0.200
    28.956    -1.582     0.200
    28.975     2.137     0.200
    29.286     2.422     0.200
    29.354     0.952     0.200
    29.617     2.312     0.200
    30.193     1.472     0.200
    30.398     1.323     0.200
    30.398     1.691     0.200
    30.398     1.572     0.200
    30.604     0.528     0.200
    30.604     1.395     0.200
    30.631     1.202     0.200
    30.652     2.164     0.200
    30.998     1.967     0.200
    31.030     2.269     0.200
    31.059     2.443     0.200
    31.445     2.265     0.200
    31.445     2.609     0.200
    31.456     1.313     0.200
    31.456     2.492     0.200
    31.497     2.322     0.200
    31.544     2.162     0.200
    31.584     2.078     0.200
    31.917     1.221     0.200
    31.970     1.604     0.200
    32.068     0.394     0.200
    32.068     1.448     0.200
    32.093     1.321     0.200
    32.368     1.295     0.200
    32.368     1.685     0.200
    32.390     1.201     0.200
    32.521     2.258     0.200
    32.521     2.437     0.200
    32.580     2.424     0.200
    32.831     0.185     0.200
    32.831    -0.111     0.200
    32.846     2.260     0.200
    32.984     1.433     0.200
    32.984     1.706     0.200
    33.009     2.125     0.200
    33.481     2.153     0.200
    33.623     1.592     0.200
    33.669     2.317     0.200
    33.751     1.562     0.200
    33.775     1.726     0.200
    33.785     1.437     0.200
    33.849     1.706     0.200
    33.900     1.051     0.200
    33.948     0.943     0.200
    33.969     1.936     0.200
    34.009     0.439     0.200
    34.009     0.291     0.200
    34.005     0.777     0.200
    34.006     1.701     0.200
    34.036     1.841     0.200
    34.045     1.555     0.200
    34.058     1.433     0.200
    34.058     1.294     0.200
    34.065     2.250     0.200
    34.082     1.304     0.200
    34.089     1.436     0.200
    34.080     1.970     0.200
    34.169     1.607     0.200
    34.175     2.168     0.200
    34.237     2.268     0.200
    34.315     0.785     0.200
    34.349     0.924     0.200
    34.508     1.182     0.200
    34.591     1.975     0.200
    34.698     1.125     0.200
    34.851     0.738     0.200
    34.864     1.311     0.200
    34.864     2.256     0.200
    34.949     1.443     0.200
    34.949     2.475     0.200
    35.060     1.419     0.200
    35.430     0.504     0.200
    35.502     1.718     0.200
    35.643     1.318     0.200
    35.797     2.727     0.200
    36.076     1.909     0.200
    36.186     2.127     0.200
    36.186     1.666     0.200
    36.518    -0.195     0.200
    36.518     0.164     0.200
    36.574    -0.165     0.200
    36.574     0.186     0.200
    36.737     1.554     0.200
    37.144    -3.214     0.200
    37.153     1.891     0.200
    37.211     1.646     0.200
    37.344    -0.469     0.200
    37.344    -0.172     0.200
    37.371     1.046     0.200
    37.593     0.482     0.200
    37.593     0.771     0.200
    37.757     0.220     0.200
    37.828     1.864     0.200
    37.828     2.176     0.200
    37.857     1.334     0.200
    37.857     1.553     0.200
    37.941     1.980     0.200
    38.212     2.014     0.200
    38.413     0.226     0.200
    38.403     1.192     0.200
    38.398     1.603     0.200
    38.936     0.079     0.200
    39.114     2.554     0.200
    39.849    -0.028     0.200
    39.926     0.543     0.200
    39.926     0.356     0.200
    40.356     1.650     0.200
    40.513    -0.252     0.200
    40.504     0.931     0.200
    40.504     1.228     0.200
    40.545     0.706     0.200
    40.591    -0.242     0.200
    40.591     0.211     0.200
    41.094     2.211     0.200
    41.233     0.139     0.200
    41.435    -0.151     0.200
    41.437     0.098     0.200
    41.457    -0.564     0.200
    41.672    -0.622     0.200
    41.693    -0.421     0.200
    41.746    -0.246     0.200
    41.746     0.247     0.200
    41.930     0.226     0.200
    41.930     0.125     0.200
    41.979     0.424     0.200
    41.979     0.706     0.200
    42.045     0.350     0.200
    42.182    -0.441     0.200
    42.238    -1.081     0.200
    42.507    -0.490     0.200
    42.683    -0.239     0.200
    42.683    -0.520     0.200
    42.751    -0.215     0.200
    42.847    -0.502     0.200
    43.026    -1.182     0.200
    43.067    -0.429     0.200
    43.069     0.080     0.200
    43.190    -1.072     0.200
    43.177     0.827     0.200
    43.222     0.013     0.200
    43.357    -0.543     0.200
    43.466    -0.376     0.200
    43.626    -0.208     0.200
    44.165    -2.871     0.200
    43.762     1.273     0.200
    43.763     1.454     0.200
    43.809    -2.096     0.200
    43.833    -0.553     0.200
    43.871     0.006     0.200
    43.898    -1.023     0.200
    43.877     0.106     0.200
    43.937    -0.026     0.200
    43.954    -0.286     0.200
    43.974    -0.111     0.200
    44.063    -0.650     0.200
    44.073    -0.855     0.200
    44.157    -0.163     0.200
    44.159    -0.504     0.200
    44.177    -0.001     0.200
    44.216    -0.563     0.200
    44.218    -1.455     0.200
    44.259     0.426     0.200
    44.261     0.057     0.200
    44.355    -0.558     0.200
    44.420    -0.053     0.200
    44.646     0.002     0.200
    44.656    -0.241     0.200
    44.724     0.531     0.200
    44.722    -0.384     0.200
    44.752    -0.959     0.200
    44.797     1.083     0.200
    44.811     0.793     0.200
    44.834    -0.559     0.200
    44.858    -0.498     0.200
    44.868     0.083     0.200
    45.036    -0.427     0.200
    45.088    -0.855     0.200
    45.121    -0.132     0.200
    45.121    -0.320     0.200
    45.350    -1.086     0.200
    45.357     0.268     0.200
    45.462    -0.066     0.200
    45.524    -0.818     0.200
    45.571    -1.116     0.200
    45.773    -0.545     0.200
    45.819    -0.582     0.200
    45.845    -0.714     0.200
    45.880    -0.454     0.200
    45.912    -0.958     0.200
    45.970    -0.421     0.200
    45.977    -0.358     0.200
    45.991    -0.264     0.200
    46.073    -0.688     0.200
    46.150    -0.409     0.200
    46.169    -0.187     0.200
    46.251    -0.778     0.200
    46.275    -0.606     0.200
    46.321    -0.779     0.200
    46.431    -0.279     0.200
    46.454    -0.164     0.200
    46.459    -0.204     0.200
    46.459    -0.423     0.200
    46.499    -0.851     0.200
    46.510    -0.451     0.200
    46.511    -0.042     0.200
    46.585    -0.002     0.200
    46.607    -0.942     0.200
    46.700    -0.045     0.200
    46.719    -0.309     0.200
    46.740    -0.326     0.200
    46.757    -0.252     0.200
    46.773    -0.703     0.200
    46.812    -0.044     0.200
    46.937    -0.560     0.200
    46.937    -0.669     0.200
    46.941    -0.110     0.200
    46.941    -0.259     0.200
    46.958    -0.103     0.200
    46.971    -0.056     0.200
    47.009    -0.346     0.200
    47.061    -0.395     0.200
    47.104     0.120     0.200
    47.134    -1.265     0.200
    47.155    -3.224     0.200
    47.179     0.671     0.200
    47.210    -0.200     0.200
    47.288    -0.300     0.200
    47.350     0.142     0.200
    47.379     0.100     0.200
    47.506     0.398     0.200
    47.518    -0.065     0.200
    47.542     0.351     0.200
    47.556     0.103     0.200
    47.547     0.122     0.200
    47.556    -0.738     0.200
    47.631    -0.270     0.200
    47.631    -0.402     0.200
    47.652    -0.517     0.200
    47.835    -1.054     0.200
    47.835    -0.554     0.200
    47.847    -0.298     0.200
    47.925    -1.042     0.200
    47.941    -0.308     0.200
    48.019    -0.550     0.200
    48.023    -0.253     0.200
    48.089    -0.450     0.200
    48.152    -0.737     0.200
    48.194    -0.967     0.200
    48.200     0.055     0.200
    48.294    -1.508     0.200
    48.314    -0.568     0.200
    48.314    -0.935     0.200
    48.313     0.254     0.200
    48.416    -0.463     0.200
    48.435    -0.309     0.200
    48.458    -0.741     0.200
    48.514     0.086     0.200
    48.534    -0.577     0.200
    48.554     0.345     0.200
    48.555     0.033     0.200
    48.617    -0.046     0.200
    48.617     0.103     0.200
    48.640    -0.240     0.200
    48.680    -0.161     0.200
    48.678     0.178     0.200
    48.678    -0.728     0.200
    48.704    -0.408     0.200
    48.758     0.355     0.200
    48.758    -0.380     0.200
    48.806    -0.473     0.200
    48.816    -0.452     0.200
    48.886    -0.517     0.200
    48.953    -0.207     0.200
    49.036    -1.255     0.200
    49.060     0.137     0.200
    49.074    -0.668     0.200
    49.081    -0.147     0.200
    49.114    -0.302     0.200
    49.183     0.061     0.200
    49.188    -0.253     0.200
    49.221    -0.722     0.200
    49.367    -0.100     0.200
    49.399    -0.069     0.200
    49.471    -0.516     0.200
    49.493     0.004     0.200
    49.504    -0.316     0.200
    49.520    -0.317     0.200
    49.524    -0.197     0.200
    49.533     0.063     0.200
    49.528    -1.286     0.200
    49.528    -1.292     0.200
    49.610     0.103     0.200
    49.729     0.195     0.200
    49.729     0.461     0.200
    49.765    -0.359     0.200
    49.830     0.010     0.200
    49.883    -0.696     0.200
    49.883    -0.321     0.200
    49.922    -0.549     0.200
    49.930    -0.111     0.200
    49.923    -0.428     0.200
    49.923    -0.155     0.200
    49.943    -0.193     0.200
    49.973    -0.445     0.200
    49.966    -0.014     0.200
    49.967    -0.471     0.200
    50.014    -0.526     0.200
    50.063     0.109     0.200
    50.105    -1.342     0.200
    50.126    -0.494     0.200
    50.133    -0.667     0.200
    50.172    -0.070     0.200
    50.179     0.478     0.200
    50.189    -0.372     0.200
    50.241     0.128     0.200
    50.284    -0.168     0.200
    50.275     0.180     0.200
    50.357     0.352     0.200
    50.394     0.019     0.200
    50.436     0.129     0.200
    50.442     0.638     0.200
    50.442     0.278     0.200
    50.500    -0.162     0.200
    50.504    -0.064     0.200
    50.600     0.672     0.200
    50.600     0.219     0.200
    50.604    -0.084     0.200
    50.703    -0.230     0.200
    50.725     0.711     0.200
    50.773    -0.132     0.200
    50.821     0.070     0.200
    50.815     0.054     0.200
    50.847    -0.099     0.200
    50.912    -0.221     0.200
    50.912     0.162     0.200
    50.988    -0.303     0.200
    51.015    -0.764     0.200
    51.022    -0.614     0.200
    51.347    -2.116     0.200
    51.107    -1.439     0.200
    51.118    -0.202     0.200
    51.152    -0.319     0.200
    51.169    -0.645     0.200
    51.173    -0.150     0.200
    51.266    -0.137     0.200
    51.315    -0.343     0.200
    51.430     0.052     0.200
    51.516     0.005     0.200
    51.516    -0.237     0.200
    51.528    -0.849     0.200
    51.556    -0.138     0.200
    51.568    -0.059     0.200
    51.574    -0.584     0.200
    51.588    -0.277     0.200
    51.609    -0.478     0.200
    51.613    -0.503     0.200
    51.613    -0.729     0.200
    51.753    -0.354     0.200
    51.859    -0.450     0.200
    52.071    -0.541     0.200
    52.086    -0.442     0.200
    52.101     0.027     0.200
    52.115     0.031     0.200
    52.287    -0.363     0.200
    52.335    -1.121     0.200
    52.416     0.773     0.200
    52.580    -0.351     0.200
    52.695    -2.064     0.200
    52.661    -0.621     0.200
    52.783    -0.766     0.200
    52.923     0.176     0.200
    52.984    -0.337     0.200
    54.238    -1.218     0.200
    54.238    -1.382     0.200
    56.426    -0.723     0.200
    56.426    -0.723     0.200
    59.299    -1.947     0.200
    59.299    -1.697     0.200
    59.621     1.101     0.200
    59.867    -0.887     0.200
    60.234    -1.581     0.200
    60.337    -1.175     0.200
    60.477    -1.446     0.200
    60.507    -1.569     0.200
    60.507    -1.444     0.200
    60.824    -1.731     0.200
    60.825    -1.323     0.200
    61.729    -1.028     0.200
    62.102     0.035     0.200
    63.064    -1.678     0.200
    63.284    -1.700     0.200
    63.822    -0.718     0.200
    63.976    -1.777     0.200
    64.063    -1.806     0.200
    66.039    -1.310     0.200
    66.327    -2.019     0.200
    66.327    -1.933     0.200
    66.416    -1.335     0.200
    66.537    -1.021     0.200
    66.714    -0.811     0.200
    66.937    -0.923     0.200
    67.021    -0.877     0.200
    67.083     1.227     0.200
    67.512    -0.888     0.200
    67.964    -2.938     0.200
    69.123    -0.373     0.200
    69.890    -1.408     0.200
    69.890    -1.228     0.200
    70.295    -1.222     0.200
    70.295    -0.690     0.200
    70.811    -0.636     0.200
    70.817     0.632     0.200
    71.207    -0.334     0.200
    71.265    -0.688     0.200
    71.342    -0.255     0.200
    71.522     0.061     0.200
    71.601    -1.568     0.200
    71.601    -1.638     0.200
    71.740    -0.653     0.200
    71.970    -0.837     0.200
    72.131    -0.284     0.200
    72.178    -0.174     0.200
    72.188    -0.479     0.200
    72.292     0.604     0.200
    72.490     0.204     0.200
    72.490     0.563     0.200
    72.505    -0.121     0.200
    72.505     0.269     0.200
    72.505     0.168     0.200
    72.507    -0.846     0.200
    72.578    -0.061     0.200
    72.684    -0.515     0.200
    72.800    -0.661     0.200
    72.800    -0.380     0.200
    72.919     0.617     0.200
    73.105    -0.891     0.200
    73.131    -0.226     0.200
    73.200    -0.898     0.200
    73.200    -0.351     0.200
    73.265    -0.134     0.200
    73.537    -0.236     0.200
    73.557    -0.646     0.200
    73.894    -0.110     0.200
    74.077    -0.103     0.200
    74.082     0.173     0.200
    74.156     0.437     0.200
    74.160     0.127     0.200
    74.171     0.023     0.200
    74.171     0.258     0.200
    74.300     0.054     0.200
    74.517     0.355     0.200
    74.540     0.266     0.200
    74.637    -0.655     0.200
    74.642    -0.088     0.200
    74.667    -0.326     0.200
    75.068     0.404     0.200
    75.177     0.328     0.200
    75.193    -0.153     0.200
    75.357    -0.104     0.200
    75.421    -0.380     0.200
    75.938    -0.881     0.200
    76.437     0.136     0.200
    76.451     0.655     0.200
    76.803     0.441     0.200
    76.803    -0.332     0.200
    76.820    -0.235     0.200
    76.841    -0.249     0.200
    76.868    -0.199     0.200
    77.085     0.081     0.200
    77.132    -0.589     0.200
    77.469     0.123     0.200
    77.563     0.202     0.200
    77.633    -0.648     0.200
    77.633    -0.391     0.200
    77.836    -0.297     0.200
    77.995     0.398     0.200
    78.015    -0.020     0.200
    78.016     0.258     0.200
    78.400     0.352     0.200
    78.992     0.125     0.200
    79.389     0.231     0.200
    79.367    -0.751     0.200
    79.633    -1.162     0.200
    79.633    -0.599     0.200
    79.612    -0.618     0.200
    80.362     0.860     0.200
    81.124    -1.109     0.200
    81.124    -0.039     0.200
    81.129    -0.444     0.200
    82.092    -0.596     0.200
    82.472    -0.192     0.200
    82.472    -0.662     0.200
    82.472    -0.311     0.200
    84.222    -0.821     0.200
    85.244     0.055     0.200
    19.969    -0.416     0.200
    19.969    -0.418     0.200
    23.807     0.786     0.200
    27.366    -3.047     0.200
    27.368    -3.073     0.200
    30.107     0.923     0.200
    30.107     0.925     0.200
    31.416     0.633     0.200
    31.416     0.637     0.200
    33.119    -1.536     0.200
    42.942    -2.919     0.200
    44.684     0.889     0.200
    44.684     0.894     0.200
    53.110    -2.741     0.200
    53.110    -2.737     0.200
    55.787    -1.944     0.200
    55.787    -1.948     0.200
    61.237    -1.711     0.200
    61.237    -1.715     0.200
    65.962    -2.153     0.200
    65.962    -2.159     0.200
    71.975    -2.255     0.200
    82.774    -0.189     0.200
    82.774    -0.191     0.200
    83.388    -1.332     0.200
    83.388    -1.332     0.200
    23.165     2.057     0.200
    24.591     3.078     0.200
    28.070    -1.604     0.200
    28.072    -1.622     0.200
    29.133     2.462     0.200
    29.294     1.867     0.200
    29.294     1.867     0.200
    30.753     2.031     0.200
    30.753     1.757     0.200
    30.753     1.546     0.200
    41.394    -1.127     0.200
    42.357     1.891     0.200
    43.744    -1.549     0.200
    43.930     1.828     0.200
    53.852    -1.701     0.200
    53.987    -1.166     0.200
    53.987    -1.471     0.200
    56.680    -0.120     0.200
    56.680    -0.120     0.200
    56.680    -0.253     0.200
    59.686     1.850     0.200
    59.908    -0.932     0.200
    59.912    -0.606     0.200
    59.912    -0.957     0.200
    61.729    -0.780     0.200
    61.729    -0.780     0.200
    61.981    -1.070     0.200
    61.981    -1.070     0.200
    64.831    -1.083     0.200
    66.263    -0.683     0.200
    66.892    -0.850     0.200
    66.892    -1.147     0.200
    66.892    -1.147     0.200
    67.541     3.682     0.200
    70.745    -1.219     0.200
    70.745    -0.969     0.200
    72.738    -1.378     0.200
    72.738    -1.058     0.200
    73.887    -0.406     0.200
    73.887    -0.906     0.200
    73.887    -0.406     0.200
    74.025    -0.815     0.200
    74.025    -0.815     0.200
    75.469     3.374     0.200
    78.852     0.579     0.200
    80.270     0.362     0.200
    81.944    -1.716     0.200
    83.570    -0.540     0.200
    83.570    -0.542     0.200
    84.204    -1.028     0.200
    84.204    -1.028     0.200
    84.204    -0.637     0.200
    19.233    -0.429     0.200
    19.233    -0.430     0.200
    27.424    -0.347     0.200
    27.427    -0.360     0.200
    55.368    -0.581     0.200
    55.368    -0.589     0.200
    20.614     0.307     0.200
    27.529     0.289     0.200
    44.443     0.194     0.200
    46.751    -1.640     0.200
    54.210    -1.703     0.200
    56.384    -0.817     0.200
    59.826    -1.765     0.200
    62.172    -1.144     0.200
    62.172    -2.168     0.200
    62.337    -0.949     0.200
    66.773    -1.300     0.200
    20.927     0.979     0.200
    26.963     0.909     0.200
    45.177    -1.260     0.200
    53.971    -2.478     0.200
    62.095    -0.547     0.200
    64.392    -0.851     0.200
    80.831     0.762     0.200
    17.804     4.247     0.200
    18.543    -0.931     0.200
    20.649    -1.428     0.200
    20.649    -1.719     0.200
    20.940     0.024     0.200
    21.518     3.197     0.200
    21.621     2.718     0.200
    22.405     4.020     0.200
    22.474     3.451     0.200
    22.909     2.731     0.200
    23.310     3.012     0.200
    23.357     2.961     0.200
    23.425     2.456     0.200
    23.649     2.768     0.200
    23.900     2.933     0.200
    23.920     2.620     0.200
    23.979     2.979     0.200
    24.241     2.497     0.200
    24.320     2.796     0.200
    24.337     1.854     0.200
    24.337     1.164     0.200
    24.449     3.079     0.200
    24.510     2.516     0.200
    24.864     3.235     0.200
    24.871     2.711     0.200
    25.289     3.176     0.200
    25.484     3.219     0.200
    25.491     2.978     0.200
    25.637     2.025     0.200
    25.814     3.444     0.200
    26.045     3.257     0.200
    26.194     1.095     0.200
    26.199     3.516     0.200
    26.406    -2.824     0.200
    26.406    -3.125     0.200
    26.463    -2.041     0.200
    26.463    -2.241     0.200
    26.938    -2.169     0.200
    26.753     1.785     0.200
    26.756     3.102     0.200
    26.925     1.391     0.200
    27.163     2.287     0.200
    28.016    -2.162     0.200
    28.619    -0.728     0.200
    28.600     1.808     0.200
    28.978    -2.718     0.200
    28.948     1.547     0.200
    29.324     0.710     0.200
    29.324     0.040     0.200
    29.720     1.313     0.200
    30.245     1.967     0.200
    30.288     3.783     0.200
    30.348     2.532     0.200
    30.543     2.218     0.200
    30.563     2.280     0.200
    30.687     4.066     0.200
    31.251     1.891     0.200
    31.438     3.468     0.200
    31.472     2.502     0.200
    31.814     2.320     0.200
    31.916     1.812     0.200
    31.916     1.745     0.200
    31.921     2.942     0.200
    31.928     3.117     0.200
    31.932     2.103     0.200
    31.932     1.808     0.200
    31.958     2.315     0.200
    31.991     3.018     0.200
    32.359     3.178     0.200
    32.363     4.126     0.200
    32.403     2.278     0.200
    32.529     2.639     0.200
    32.586     2.756     0.200
    32.586     2.639     0.200
    32.651     1.749     0.200
    33.261     1.989     0.200
    33.474    -2.781     0.200
    33.474    -2.482     0.200
    33.325     2.900     0.200
    33.351     2.663     0.200
    33.523     2.613     0.200
    33.656     1.529     0.200
    33.763     3.030     0.200
    33.832     1.777     0.200
    33.865     2.759     0.200
    33.939     2.691     0.200
    34.058     1.653     0.200
    34.058     1.452     0.200
    34.133     2.415     0.200
    34.181     1.532     0.200
    34.240     2.324     0.200
    34.443     2.013     0.200
    34.509     2.318     0.200
    34.680     2.039     0.200
    34.802     0.068     0.200
    34.802    -0.062     0.200
    34.881    -0.916     0.200
    34.958     2.334     0.200
    35.037     2.229     0.200
    35.037     2.096     0.200
    35.037     1.240     0.200
    35.037     1.645     0.200
    35.039     1.281     0.200
    35.053     2.074     0.200
    35.167     2.162     0.200
    35.264     2.459     0.200
    35.298     2.246     0.200
    35.407     1.308     0.200
    35.407     0.468     0.200
    35.440     1.295     0.200
    35.506     1.770     0.200
    35.633     2.481     0.200
    35.843    -3.728     0.200
    36.077    -1.726     0.200
    35.900     1.885     0.200
    35.901     2.292     0.200
    35.983     2.237     0.200
    36.112     1.699     0.200
    36.158     2.417     0.200
    36.303     2.113     0.200
    36.415     1.522     0.200
    36.624    -2.997     0.200
    36.624    -3.348     0.200
    36.650    -2.115     0.200
    36.641     0.660     0.200
    36.641     0.240     0.200
    36.923     2.491     0.200
    36.999     0.564     0.200
    36.958     2.237     0.200
    37.153     1.499     0.200
    37.342     0.751     0.200
    37.279     1.447     0.200
    37.326     2.251     0.200
    37.509     1.198     0.200
    37.643     2.159     0.200
    38.343    -2.132     0.200
    38.343    -1.690     0.200
    38.198     2.157     0.200
    38.198     1.306     0.200
    38.316    -0.508     0.200
    38.304     1.908     0.200
    38.384    -0.155     0.200
    38.485     0.556     0.200
    38.485     0.224     0.200
    38.679     2.100     0.200
    38.957     2.417     0.200
    38.957     1.622     0.200
    39.097     0.999     0.200
    39.362    -2.362     0.200
    39.203     1.822     0.200
    39.203     1.434     0.200
    39.491     0.670     0.200
    40.030     1.438     0.200
    40.030     0.988     0.200
    40.242    -1.720     0.200
    40.349     2.476     0.200
    40.349     2.175     0.200
    40.591     0.584     0.200
    41.341    -1.619     0.200
    41.341    -1.988     0.200
    41.464     0.206     0.200
    41.510     1.330     0.200
    41.547     0.373     0.200
    41.832     1.430     0.200
    41.927     1.216     0.200
    42.136    -3.016     0.200
    42.270     1.174     0.200
    42.271     2.082     0.200
    42.271     1.460     0.200
    42.398    -0.323     0.200
    42.690    -2.018     0.200
    42.863    -3.124     0.200
    42.694     0.185     0.200
    43.084     0.175     0.200
    43.094     0.341     0.200
    43.443     0.250     0.200
    43.462     0.020     0.200
    43.515     0.257     0.200
    43.524     1.015     0.200
    43.578    -0.568     0.200
    43.681     0.534     0.200
    43.771     0.056     0.200
    43.771    -0.155     0.200
    43.764    -0.172     0.200
    43.867    -1.311     0.200
    43.805     0.361     0.200
    44.018     0.251     0.200
    44.057    -0.092     0.200
    44.138     0.600     0.200
    44.164    -0.219     0.200
    44.292    -0.316     0.200
    44.292     0.383     0.200
    44.292     0.014     0.200
    44.226     0.050     0.200
    44.290     0.478     0.200
    44.296     0.106     0.200
    44.308    -0.158     0.200
    44.327     0.336     0.200
    44.439    -0.289     0.200
    44.439    -1.549     0.200
    44.497    -0.511     0.200
    44.507     0.269     0.200
    44.536    -0.205     0.200
    44.585     0.243     0.200
    44.648     0.871     0.200
    44.736     0.614     0.200
    44.867     0.104     0.200
    44.904     0.416     0.200
    44.963    -0.121     0.200
    45.051     0.626     0.200
    45.040     1.653     0.200
    45.054    -0.410     0.200
    45.165    -1.390     0.200
    45.165    -1.644     0.200
    45.074    -0.091     0.200
    45.105    -0.100     0.200
    45.101     0.326     0.200
    45.150     0.152     0.200
    45.239    -0.785     0.200
    45.239    -1.053     0.200
    45.279    -0.505     0.200
    45.512    -3.111     0.200
    45.364    -0.046     0.200
    45.394     0.083     0.200
    45.585    -0.868     0.200
    46.143    -4.098     0.200
    45.674    -0.323     0.200
    45.684     0.376     0.200
    45.684    -0.189     0.200
    45.869    -3.181     0.200
    45.765    -0.186     0.200
    45.773     0.248     0.200
    45.861    -0.532     0.200
    45.855     0.156     0.200
    45.913     0.342     0.200
    45.931    -0.076     0.200
    45.926     0.016     0.200
    45.967    -0.109     0.200
    46.004    -0.771     0.200
    46.141     0.502     0.200
    46.287    -1.818     0.200
    46.200    -0.018     0.200
    46.318    -1.325     0.200
    46.225    -0.082     0.200
    46.212     1.017     0.200
    46.257    -0.276     0.200
    46.269    -0.415     0.200
    46.263    -0.511     0.200
    46.295    -0.554     0.200
    46.322     0.750     0.200
    46.322     0.346     0.200
    46.333     0.106     0.200
    46.367    -0.303     0.200
    46.442     0.368     0.200
    46.659    -1.036     0.200
    46.523     0.234     0.200
    46.523    -0.270     0.200
    46.590     0.101     0.200
    46.590    -0.625     0.200
    46.591    -0.310     0.200
    46.638    -0.533     0.200
    46.840    -2.753     0.200
    46.705    -0.472     0.200
    46.715    -0.238     0.200
    46.727     0.757     0.200
    46.746    -0.116     0.200
    46.772    -0.132     0.200
    46.788    -0.605     0.200
    46.804    -0.165     0.200
    46.945    -1.390     0.200
    46.920    -0.374     0.200
    46.974    -0.363     0.200
    46.993    -0.915     0.200
    46.999    -0.085     0.200
    47.048    -0.364     0.200
    47.075    -0.043     0.200
    47.162    -0.160     0.200
    47.180     1.247     0.200
    47.218     0.490     0.200
    47.424    -1.597     0.200
    47.322    -0.379     0.200
    47.391    -0.368     0.200
    47.412    -0.703     0.200
    47.472    -0.120     0.200
    47.481    -0.412     0.200
    47.485    -0.777     0.200
    47.598     0.145     0.200
    47.625    -0.602     0.200
    47.711    -0.173     0.200
    47.731    -0.454     0.200
    47.919    -1.833     0.200
    47.919    -1.954     0.200
    47.919    -1.734     0.200
    47.919    -1.895     0.200
    47.743    -1.100     0.200
    47.755    -0.431     0.200
    47.823    -0.274     0.200
    47.823    -0.588     0.200
    47.832    -0.527     0.200
    47.899    -0.329     0.200
    47.912     0.513     0.200
    47.936    -0.562     0.200
    47.966    -0.254     0.200
    48.021    -0.577     0.200
    48.021    -0.835     0.200
    48.025    -0.751     0.200
    48.026    -0.154     0.200
    48.027     0.909     0.200
    48.098    -0.099     0.200
    48.125    -0.283     0.200
    48.125    -0.059     0.200
    48.121     1.225     0.200
    48.187    -0.630     0.200
    48.186    -0.008     0.200
    48.182    -0.267     0.200
    48.186    -0.477     0.200
    48.212     0.022     0.200
    48.279     0.010     0.200
    48.345     0.313     0.200
    48.345    -0.379     0.200
    48.388    -0.441     0.200
    48.417     0.052     0.200
    48.602    -2.901     0.200
    48.445     0.100     0.200
    48.445    -0.388     0.200
    48.472    -0.601     0.200
    48.465    -0.706     0.200
    48.485    -0.791     0.200
    48.510     0.233     0.200
    48.510    -0.394     0.200
    48.560    -0.027     0.200
    48.611    -0.325     0.200
    48.683    -0.523     0.200
    48.633    -0.710     0.200
    48.637    -0.368     0.200
    48.658    -0.103     0.200
    48.676    -0.560     0.200
    48.692    -0.430     0.200
    48.717     0.189     0.200
    48.779     0.017     0.200
    48.782     0.153     0.200
    48.779     1.146     0.200
    48.840     0.114     0.200
    48.849    -0.067     0.200
    48.854    -0.076     0.200
    48.880    -0.558     0.200
    48.922    -0.479     0.200
    48.936    -0.963     0.200
    48.954    -0.607     0.200
    49.024    -0.026     0.200
    49.047    -0.128     0.200
    49.053    -0.014     0.200
    49.066    -0.645     0.200
    49.119    -0.583     0.200
    49.194    -0.374     0.200
    49.216     0.164     0.200
    49.244     0.235     0.200
    49.251    -0.048     0.200
    49.263    -0.316     0.200
    49.270    -0.223     0.200
    49.351    -0.047     0.200
    49.350     0.163     0.200
    49.552    -2.360     0.200
    49.395    -0.786     0.200
    49.573    -1.226     0.200
    49.424    -0.320     0.200
    49.435     0.172     0.200
    49.477    -0.792     0.200
    49.497    -0.743     0.200
    49.493    -0.110     0.200
    49.545    -0.385     0.200
    49.550     0.016     0.200
    49.550    -0.490     0.200
    49.571    -0.647     0.200
    49.622    -0.172     0.200
    49.622    -0.363     0.200
    49.710     0.229     0.200
    49.726    -0.801     0.200
    49.719    -0.130     0.200
    49.726    -0.522     0.200
    49.832    -0.102     0.200
    49.844    -0.534     0.200
    49.849    -0.584     0.200
    49.833    -0.052     0.200
    49.846     0.030     0.200
    49.878    -1.002     0.200
    49.886    -0.650     0.200
    49.884    -0.482     0.200
    49.924    -0.379     0.200
    49.932    -0.624     0.200
    49.934    -0.217     0.200
    49.951    -0.125     0.200
    49.951    -0.474     0.200
    49.954     0.745     0.200
    49.969    -0.159     0.200
    49.970    -0.584     0.200
    50.024     0.069     0.200
    50.020    -0.188     0.200
    50.104    -0.310     0.200
    50.114    -0.204     0.200
    50.166    -0.667     0.200
    50.178     0.124     0.200
    50.192    -0.153     0.200
    50.183    -0.410     0.200
    50.232    -0.620     0.200
    50.260     0.009     0.200
    50.278    -0.801     0.200
    50.274    -0.558     0.200
    50.299    -0.408     0.200
    50.351    -0.630     0.200
    50.351    -0.334     0.200
    50.343    -0.232     0.200
    50.392    -0.432     0.200
    50.412    -0.255     0.200
    50.439    -0.261     0.200
    50.437     0.165     0.200
    50.486     0.192     0.200
    50.494    -0.731     0.200
    50.506    -0.113     0.200
    50.514    -0.578     0.200
    50.545    -0.078     0.200
    50.572    -0.657     0.200
    50.576    -0.139     0.200
    50.619    -0.822     0.200
    50.609    -0.358     0.200
    50.609    -0.231     0.200
    50.627    -0.317     0.200
    50.663     0.059     0.200
    50.654    -0.337     0.200
    50.667     0.285     0.200
    50.702    -0.173     0.200
    50.701    -0.096     0.200
    50.731    -0.420     0.200
    50.755     0.081     0.200
    50.773     0.208     0.200
    50.831    -0.017     0.200
    50.836    -0.013     0.200
    50.902    -0.095     0.200
    50.912    -0.441     0.200
    50.907    -0.238     0.200
    50.922    -0.323     0.200
    50.982     0.298     0.200
    50.975    -0.443     0.200
    51.013    -0.367     0.200
    51.037    -0.122     0.200
    51.049     0.021     0.200
    51.063     0.276     0.200
    51.072    -0.222     0.200
    51.080    -0.058     0.200
    51.114     0.010     0.200
    51.112     0.007     0.200
    51.125     0.068     0.200
    51.188     0.331     0.200
    51.206    -0.055     0.200
    51.235     0.027     0.200
    51.246    -0.052     0.200
    51.261    -0.377     0.200
    51.272     0.295     0.200
    51.272    -0.825     0.200
    51.296    -0.912     0.200
    51.293    -0.079     0.200
    51.316    -1.361     0.200
    51.297    -0.087     0.200
    51.376    -0.290     0.200
    51.412    -0.220     0.200
    51.419    -0.467     0.200
    51.433     0.328     0.200
    51.475    -0.672     0.200
    51.489    -0.149     0.200
    51.490    -0.398     0.200
    51.501     0.275     0.200
    51.520     0.006     0.200
    51.551     0.388     0.200
    51.553     0.274     0.200
    51.587    -1.109     0.200
    51.592     0.161     0.200
    51.622     0.185     0.200
    51.641    -0.238     0.200
    51.671     0.087     0.200
    51.695    -0.279     0.200
    51.695    -0.734     0.200
    51.697    -0.578     0.200
    51.730    -0.729     0.200
    51.740    -0.073     0.200
    51.749     0.637     0.200
    51.758    -0.213     0.200
    51.750    -0.290     0.200
    51.749    -0.135     0.200
    51.772     0.143     0.200
    51.796    -0.066     0.200
    51.821    -0.009     0.200
    51.866    -0.063     0.200
    51.895     0.048     0.200
    51.903     0.021     0.200
    51.924    -0.129     0.200
    51.933     0.114     0.200
    51.947    -0.504     0.200
    51.968    -0.615     0.200
    51.970    -0.397     0.200
    52.012     0.276     0.200
    52.060    -0.697     0.200
    52.085     0.219     0.200
    52.085     0.057     0.200
    52.093     0.006     0.200
    52.120    -0.013     0.200
    52.133     0.138     0.200
    52.145     0.043     0.200
    52.178    -0.375     0.200
    52.194    -0.094     0.200
    52.229    -0.017     0.200
    52.246    -0.335     0.200
    52.258    -0.327     0.200
    52.277     0.046     0.200
    52.323     0.569     0.200
    52.367    -0.283     0.200
    52.393     0.021     0.200
    52.408     0.297     0.200
    52.407    -0.118     0.200
    52.427     0.043     0.200
    52.426     0.289     0.200
    52.474    -0.349     0.200
    52.492    -0.435     0.200
    52.526    -0.480     0.200
    52.534    -0.299     0.200
    52.544     0.203     0.200
    52.544    -0.318     0.200
    52.559     0.015     0.200
    52.619    -0.309     0.200
    52.633     0.077     0.200
    52.860    -1.203     0.200
    52.651    -0.321     0.200
    52.660     0.210     0.200
    52.667    -0.174     0.200
    52.726    -0.160     0.200
    52.843    -1.626     0.200
    52.919    -1.336     0.200
    52.755     0.140     0.200
    52.791     0.152     0.200
    52.789    -0.411     0.200
    52.800    -0.992     0.200
    52.877     0.139     0.200
    52.909    -0.382     0.200
    52.925    -1.021     0.200
    52.937     0.318     0.200
    52.960    -0.744     0.200
    52.966    -0.988     0.200
    52.982    -0.519     0.200
    52.986    -0.229     0.200
    53.014    -0.472     0.200
    53.010    -0.667     0.200
    53.308    -2.230     0.200
    53.029     0.220     0.200
    53.097     0.082     0.200
    53.129    -0.425     0.200
    53.202    -0.503     0.200
    53.409    -2.691     0.200
    53.293    -1.215     0.200
    53.301    -1.307     0.200
    53.326    -0.576     0.200
    53.361    -0.640     0.200
    53.751    -2.675     0.200
    53.399    -0.988     0.200
    53.418     0.014     0.200
    53.407    -0.596     0.200
    53.439    -0.440     0.200
    53.466    -0.162     0.200
    53.503    -0.356     0.200
    53.508    -0.592     0.200
    53.584    -1.411     0.200
    53.590    -1.233     0.200
    53.729    -1.931     0.200
    53.786    -0.852     0.200
    53.725    -1.260     0.200
    53.930    -1.200     0.200
    53.779    -0.167     0.200
    53.799    -0.125     0.200
    53.799    -0.431     0.200
    53.796    -0.896     0.200
    53.818    -0.485     0.200
    53.959    -2.084     0.200
    53.959    -1.600     0.200
    54.088    -0.980     0.200
    54.088    -1.650     0.200
    54.088    -1.941     0.200
    53.970    -0.295     0.200
    53.997    -0.250     0.200
    54.018    -0.294     0.200
    54.049     0.050     0.200
    54.069    -0.839     0.200
    54.081    -1.546     0.200
    54.132    -1.497     0.200
    54.136    -0.561     0.200
    54.145    -0.504     0.200
    54.476    -1.646     0.200
    54.311    -0.299     0.200
    54.335    -0.094     0.200
    54.355    -1.037     0.200
    54.479    -1.326     0.200
    54.402    -0.559     0.200
    54.522    -0.218     0.200
    54.519    -0.480     0.200
    54.535     0.254     0.200
    54.635     0.405     0.200
    54.576    -0.395     0.200
    54.579    -0.324     0.200
    54.593    -1.268     0.200
    54.623    -0.296     0.200
    54.815    -0.029     0.200
    54.829    -0.204     0.200
    54.852    -0.287     0.200
    54.870    -0.021     0.200
    54.888    -1.395     0.200
    55.078    -1.627     0.200
    54.950    -0.172     0.200
    54.950    -0.727     0.200
    54.976    -0.377     0.200
    55.087    -0.798     0.200
    54.990    -0.549     0.200
    55.031    -0.345     0.200
    55.110     0.071     0.200
    55.198    -1.218     0.200
    55.244    -1.213     0.200
    55.366    -1.315     0.200
    55.396    -1.423     0.200
    55.478    -1.090     0.200
    55.478    -1.709     0.200
    55.478    -1.600     0.200
    55.334    -0.384     0.200
    55.793    -0.930     0.200
    55.775    -2.839     0.200
    55.762    -0.870     0.200
    56.469    -0.696     0.200
    56.527    -0.821     0.200
    56.527    -0.647     0.200
    56.690    -0.684     0.200
    57.019    -1.289     0.200
    57.039    -1.631     0.200
    57.085    -1.627     0.200
    58.111    -0.461     0.200
    58.111    -0.651     0.200
    58.582    -0.723     0.200
    58.689     0.302     0.200
    58.936    -3.211     0.200
    59.299    -1.656     0.200
    59.299    -1.426     0.200
    59.450    -1.568     0.200
    59.626    -2.275     0.200
    59.540    -0.306     0.200
    60.527    -0.022     0.200
    60.675    -0.457     0.200
    60.763    -1.380     0.200
    60.626    -0.220     0.200
    60.786    -1.307     0.200
    60.840    -0.716     0.200
    60.909    -0.636     0.200
    61.271    -1.231     0.200
    61.767    -1.440     0.200
    61.998    -0.593     0.200
    61.998    -0.718     0.200
    62.018    -0.138     0.200
    62.083    -1.212     0.200
    62.121    -0.330     0.200
    62.129    -0.656     0.200
    62.168    -0.551     0.200
    62.489    -3.476     0.200
    62.698     0.497     0.200
    62.724    -0.463     0.200
    63.120    -1.177     0.200
    63.188    -0.305     0.200
    63.251     0.054     0.200
    63.251     0.294     0.200
    63.270     0.499     0.200
    63.486    -0.696     0.200
    63.580    -0.025     0.200
    63.690    -0.543     0.200
    63.737     0.031     0.200
    63.895    -1.789     0.200
    63.895    -2.019     0.200
    63.774    -1.222     0.200
    64.046    -0.683     0.200
    64.155    -1.447     0.200
    64.368    -1.220     0.200
    64.368    -1.589     0.200
    64.370    -1.467     0.200
    64.330     0.536     0.200
    64.500    -0.314     0.200
    64.520     0.285     0.200
    64.762    -1.433     0.200
    64.718    -0.307     0.200
    64.769    -0.417     0.200
    64.899    -0.023     0.200
    65.069    -1.055     0.200
    65.069    -0.924     0.200
    65.321    -1.187     0.200
    65.319    -1.279     0.200
    65.235    -0.866     0.200
    65.354    -1.403     0.200
    65.374    -0.132     0.200
    65.508    -0.051     0.200
    65.894    -0.946     0.200
    65.921    -0.230     0.200
    65.921     0.440     0.200
    66.164    -0.816     0.200
    66.101    -0.177     0.200
    66.233    -1.658     0.200
    66.233    -2.247     0.200
    66.233    -1.583     0.200
    66.329    -2.275     0.200
    66.329    -1.704     0.200
    66.375     0.830     0.200
    66.479    -2.051     0.200
    66.587     0.348     0.200
    66.794    -0.141     0.200
    67.337    -2.688     0.200
    68.034    -1.377     0.200
    68.034    -1.726     0.200
    68.034    -0.963     0.200
    68.040    -0.665     0.200
    68.138    -0.631     0.200
    68.255    -0.006     0.200
    68.635    -2.237     0.200
    68.712     0.055     0.200
    68.885    -0.190     0.200
    69.025    -1.658     0.200
    69.021    -0.056     0.200
    69.123    -1.926     0.200
    69.149    -0.036     0.200
    69.530    -0.779     0.200
    69.549    -0.237     0.200
    69.673    -2.063     0.200
    69.673    -1.339     0.200
    70.228    -0.767     0.200
    70.382    -0.982     0.200
    70.386    -1.333     0.200
    70.347    -1.997     0.200
    70.407    -0.862     0.200
    70.379    -1.394     0.200
    70.547    -0.827     0.200
    70.487     0.138     0.200
    70.837    -0.599     0.200
    70.953    -0.911     0.200
    71.205    -1.151     0.200
    71.351    -0.533     0.200
    71.442    -1.177     0.200
    71.464    -2.371     0.200
    71.648     0.031     0.200
    71.700    -2.389     0.200
    71.742    -0.854     0.200
    71.782     0.108     0.200
    71.800    -0.289     0.200
    71.810    -0.009     0.200
    71.903    -0.312     0.200
    71.903    -0.072     0.200
    71.950    -0.303     0.200
    71.936    -2.808     0.200
    71.910     0.036     0.200
    72.000     0.031     0.200
    72.110    -0.078     0.200
    72.138    -0.446     0.200
    72.292    -0.407     0.200
    72.353     0.083     0.200
    72.300     0.058     0.200
    72.517     0.095     0.200
    72.517    -0.177     0.200
    72.517    -0.357     0.200
    72.517    -0.616     0.200
    72.477     0.165     0.200
    72.587    -0.594     0.200
    72.726     0.060     0.200
    72.686    -0.079     0.200
    72.772     0.349     0.200
    72.717    -0.367     0.200
    72.797    -1.337     0.200
    72.796     0.070     0.200
    72.879     0.264     0.200
    72.970     0.339     0.200
    73.231     0.538     0.200
    73.222    -0.050     0.200
    73.283    -2.081     0.200
    73.253    -0.336     0.200
    73.269    -0.026     0.200
    73.339    -1.041     0.200
    73.312    -0.281     0.200
    73.485    -0.103     0.200
    73.572    -0.010     0.200
    73.605     0.037     0.200
    73.605    -0.302     0.200
    73.736    -0.074     0.200
    73.949     0.279     0.200
    73.911     0.104     0.200
    74.007     0.341     0.200
    74.024     0.258     0.200
    74.024     0.045     0.200
    74.070     0.072     0.200
    74.097    -0.785     0.200
    74.259    -0.224     0.200
    74.356    -0.281     0.200
    74.301    -0.044     0.200
    74.311     0.773     0.200
    74.321     0.111     0.200
    74.321    -0.858     0.200
    74.338    -0.654     0.200
    74.527     1.017     0.200
    74.463    -1.010     0.200
    74.602     0.380     0.200
    74.822     2.708     0.200
    74.860     0.692     0.200
    74.860     0.591     0.200
    74.905    -1.171     0.200
    74.799    -0.307     0.200
    74.943     0.112     0.200
    74.992    -0.572     0.200
    75.011     0.020     0.200
    75.328    -0.506     0.200
    75.332    -0.398     0.200
    75.358     0.239     0.200
    75.386    -1.054     0.200
    75.410    -0.746     0.200
    75.402     0.292     0.200
    75.515     0.364     0.200
    75.557     0.720     0.200
    75.557    -0.540     0.200
    75.575     0.019     0.200
    75.677    -2.602     0.200
    75.627     0.167     0.200
    75.643    -0.050     0.200
    75.704     0.345     0.200
    75.708     0.355     0.200
    75.731    -1.190     0.200
    75.861     0.405     0.200
    75.945    -0.199     0.200
    76.012     0.226     0.200
    76.030     0.636     0.200
    76.206    -0.221     0.200
    76.292    -0.301     0.200
    76.250    -0.877     0.200
    76.473     0.257     0.200
    76.493     2.092     0.200
    76.511    -1.043     0.200
    76.499     0.749     0.200
    76.551     0.457     0.200
    76.590    -1.059     0.200
    76.616    -0.026     0.200
    76.686     0.002     0.200
    76.752    -0.210     0.200
    76.798    -0.051     0.200
    76.855    -0.482     0.200
    76.906    -1.001     0.200
    77.184    -0.384     0.200
    77.211    -0.681     0.200
    77.211     0.035     0.200
    77.231    -0.734     0.200
    77.364     0.865     0.200
    77.364     0.662     0.200
    77.370    -0.175     0.200
    77.379    -0.732     0.200
    77.443    -0.684     0.200
    77.592     0.458     0.200
    77.599     0.348     0.200
    77.595    -0.601     0.200
    77.683    -0.301     0.200
    77.819    -0.639     0.200
    77.763    -1.667     0.200
    77.906    -0.199     0.200
    77.993     0.958     0.200
    78.066     0.576     0.200
    78.123    -0.374     0.200
    78.151    -0.019     0.200
    78.193     0.779     0.200
    78.192     0.755     0.200
    78.318     0.055     0.200
    78.322    -0.420     0.200
    78.312    -0.510     0.200
    78.347    -1.000     0.200
    78.366     0.492     0.200
    78.500     0.273     0.200
    78.500    -0.147     0.200
    78.500    -0.737     0.200
    78.478     0.977     0.200
    78.413    -1.358     0.200
    78.643    -0.013     0.200
    78.644    -0.922     0.200
    78.697     0.070     0.200
    78.661    -0.053     0.200
    78.743    -0.206     0.200
    78.641    -1.473     0.200
    78.739     0.840     0.200
    78.837     0.700     0.200
    78.839    -0.299     0.200
    78.928     0.199     0.200
    78.970     0.473     0.200
    79.060    -0.620     0.200
    79.191     1.061     0.200
    79.205    -1.015     0.200
    79.226    -0.568     0.200
    79.124    -1.050     0.200
    79.131    -1.206     0.200
    79.300    -0.231     0.200
    79.340    -0.010     0.200
    79.349    -1.197     0.200
    79.332     0.895     0.200
    79.377    -0.548     0.200
    79.351     0.789     0.200
    79.395    -0.908     0.200
    79.492    -0.776     0.200
    79.361    -1.224     0.200
    79.459     0.504     0.200
    79.423    -1.660     0.200
    79.587    -0.291     0.200
    79.602    -0.723     0.200
    79.583    -0.173     0.200
    79.583    -0.673     0.200
    79.833    -0.626     0.200
    79.779    -0.942     0.200
    79.893     0.449     0.200
    79.900     0.313     0.200
    80.005    -1.147     0.200
    80.206    -0.437     0.200
    80.228    -0.257     0.200
    80.312     0.391     0.200
    80.312     0.690     0.200
    80.294     0.140     0.200
    80.369    -1.434     0.200
    80.560    -1.472     0.200
    80.459    -0.898     0.200
    80.513    -0.686     0.200
    80.511    -2.445     0.200
    80.688    -1.125     0.200
    80.712    -0.933     0.200
    80.801    -0.415     0.200
    80.914    -0.229     0.200
    80.829     0.524     0.200
    80.901     0.922     0.200
    80.872     0.295     0.200
    80.958    -0.891     0.200
    80.964    -1.195     0.200
    81.050    -0.153     0.200
    81.014    -0.462     0.200
    80.887     0.661     0.200
    81.020     0.104     0.200
    81.104    -0.061     0.200
    80.972    -0.451     0.200
    81.149    -1.781     0.200
    81.225    -0.183     0.200
    81.309     0.173     0.200
    81.254    -0.339     0.200
    81.173    -1.476     0.200
    81.173     2.203     0.200
    81.296     0.339     0.200
    81.479    -0.329     0.200
    81.533     0.138     0.200
    81.403    -1.070     0.200
    81.587    -0.300     0.200
    81.536     0.568     0.200
    81.639    -1.408     0.200
    81.639    -1.873     0.200
    81.675    -0.464     0.200
    81.532    -1.738     0.200
    81.723    -0.614     0.200
    81.723    -0.416     0.200
    81.629     0.040     0.200
    81.741     0.188     0.200
    81.747    -0.545     0.200
    81.819    -0.123     0.200
    81.654    -0.741     0.200
    81.838    -0.699     0.200
    81.870     0.408     0.200
    81.966     1.007     0.200
    82.032    -0.109     0.200
    82.032     0.262     0.200
    82.153     0.725     0.200
    82.165     0.665     0.200
    82.218     0.190     0.200
    82.317    -0.231     0.200
    82.267     0.933     0.200
    82.306     0.665     0.200
    82.264    -0.444     0.200
    82.491    -0.240     0.200
    82.491     0.360     0.200
    82.491     0.049     0.200
    82.617     0.947     0.200
    82.740     0.866     0.200
    82.728    -0.573     0.200
    82.637    -2.019     0.200
    82.861    -2.062     0.200
    82.998     0.329     0.200
    82.886    -0.592     0.200
    83.101     0.998     0.200
    83.162    -0.795     0.200
    83.162    -1.015     0.200
    83.121     1.196     0.200
    83.175     0.914     0.200
    83.395    -0.319     0.200
    83.435    -0.621     0.200
    83.459     0.276     0.200
    83.459     0.655     0.200
    83.480     1.344     0.200
    83.530     0.392     0.200
    83.403    -2.511     0.200
    83.550     0.335     0.200
    83.550     0.138     0.200
    83.550    -0.112     0.200
    83.541     1.534     0.200
    83.813    -0.138     0.200
    83.862     0.488     0.200
    83.885     0.473     0.200
    83.905     0.270     0.200
    84.035     1.308     0.200
    84.256     0.885     0.200
    84.321     0.056     0.200
    84.330     0.513     0.200
    84.494    -0.220     0.200
    84.528     0.958     0.200
    85.077    -0.148     0.200
    85.145    -0.290     0.200
    85.249    -0.609     0.200
    85.399     0.043     0.200
    85.506     0.311     0.200
    85.900     0.257     0.200
    86.093     0.902     0.200
    86.265     0.327     0.200
    86.561    -2.745     0.200
    86.806     0.006     0.200
    86.876     1.017     0.200
    86.937    -0.435     0.200
    88.025     0.902     0.200
    88.308     0.204     0.200
    88.308    -0.226     0.200
    88.507    -0.404     0.200
    91.513    -1.266     0.200
    96.377    -1.874     0.200
    96.383    -2.121     0.200
    96.383    -1.996     0.200
    96.456    -2.081     0.200
    98.117    -0.548     0.200
    98.453    -2.054     0.200
    20.909     0.438     0.200
    30.331     3.307     0.200
    31.893     2.575     0.200
    33.474    -0.985     0.200
    42.706    -1.389     0.200
    45.020     2.260     0.200
    53.941    -0.924     0.200
    55.803    -0.139     0.200
    59.300    -0.937     0.200
    61.977    -0.371     0.200
    61.977    -1.121     0.200
    62.065    -0.564     0.200
    66.235    -1.562     0.200
    72.780    -0.427     0.200
    19.588     0.639     0.200
    55.323     0.185     0.200
    21.425    -0.798     0.200
    21.860     1.063     0.200
    23.118     2.773     0.200
    23.116    -0.768     0.200
    23.763     0.906     0.200
    24.428     0.737     0.200
    24.534     3.933     0.200
    24.534     1.996     0.200
    26.095     1.471     0.200
    26.930     0.365     0.200
    28.123     0.041     0.200
    29.238     2.921     0.200
    30.676     0.349     0.200
    30.705     2.389     0.200
    32.829     2.677     0.200
    43.799    -1.122     0.200
    43.877     2.526     0.200
    56.740     0.176     0.200
    59.972    -1.380     0.200
    61.765    -0.216     0.200
    62.024    -0.412     0.200
    66.952    -0.903     0.200
    70.801    -1.538     0.200
    72.783    -0.734     0.200
    73.179     0.822     0.200
    74.061     0.064     0.200
    74.777    -0.216     0.200
    75.844    -1.547     0.200
    83.617    -0.105     0.200
    84.260    -0.801     0.200
    18.907    -2.867     0.200
    20.829    -1.516     0.200
    22.800     1.442     0.200
    28.342    -2.584     0.200
    29.344     1.864     0.200
    32.812     0.213     0.200
    33.313    -2.909     0.200
    33.313    -2.667     0.200
    42.123    -1.782     0.200
    43.806     1.785     0.200
    47.117    -3.086     0.200
    52.576    -2.449     0.200
    54.205    -1.705     0.200
    56.351    -1.515     0.200
    59.200    -1.926     0.200
    59.200    -2.317     0.200
    59.561     1.462     0.200
    60.390    -1.327     0.200
    60.706    -1.961     0.200
    63.875    -2.476     0.200
    66.231    -2.574     0.200
    66.956    -1.030     0.200
    66.994    -0.268     0.200
    71.482    -2.091     0.200
    72.683     0.822     0.200
    77.719    -0.780     0.200
    79.317    -1.096     0.200
    81.014    -1.178     0.200
    82.353     0.661     0.200
    84.168    -1.329     0.200
    18.572    -0.387     0.200
    20.694     0.628     0.200
    21.344    -1.264     0.200
    27.589    -0.667     0.200
    28.721    -0.226     0.200
    44.377    -1.063     0.200
    56.504    -0.864     0.200
    59.979    -1.281     0.200
    62.512    -1.388     0.200
    63.421    -0.874     0.200
    64.488    -1.444     0.200
    66.149    -0.527     0.200
    66.921    -1.394     0.200
    70.278    -1.287     0.200
    73.247    -1.215     0.200
    74.643    -0.530     0.200
    78.495     0.199     0.200
    81.004     0.673     0.200
    83.854    -0.911     0.200
    84.036    -0.489     0.200
    29.141     3.001     0.200
    19.233     0.178     0.200
    20.417    -0.437     0.200
    22.148     1.324     0.200
    23.357     0.268     0.200
    23.357    -0.653     0.200
    24.465     2.259     0.200
    24.964    -1.378     0.200
    25.176     3.053     0.200
    25.176    -0.493     0.200
    26.573    -1.720     0.200
    26.837    -0.595     0.200
    26.837    -2.145     0.200
    27.787    -2.343     0.200
    29.856     2.392     0.200
    30.981     1.286     0.200
    33.163     1.149     0.200
    33.358    -0.072     0.200
    43.232    -1.850     0.200
    43.576    -1.056     0.200
    44.542    -0.361     0.200
    45.381     0.505     0.200
    47.517    -0.783     0.200
    48.020    -0.341     0.200
    55.889    -0.288     0.200
    60.689    -1.799     0.200
    65.867    -1.528     0.200
    71.446    -1.966     0.200
    72.751    -0.652     0.200
    83.650    -0.787     0.200
    20.097     0.256     0.200
    32.059     1.862     0.200
    45.406     1.400     0.200
    20.286    -0.158     0.200
    26.872    -2.159     0.200
    29.462     0.874     0.200
    29.997     2.540     0.200
    30.228     2.510     0.200
    30.610     2.303     0.200
    30.610     2.029     0.200
    31.397     1.890     0.200
    31.668     2.316     0.200
    31.908     1.435     0.200
    31.908     1.414     0.200
    31.908     1.304     0.200
    32.780     1.945     0.200
    33.906     0.511     0.200
    33.927     1.567     0.200
    34.033     1.895     0.200
    34.415     0.827     0.200
    34.415     0.717     0.200
    38.379     0.326     0.200
    38.407     1.692     0.200
    38.930     0.133     0.200
    39.448     0.063     0.200
    39.496     0.215     0.200
    40.522     0.178     0.200
    40.526    -0.116     0.200
    41.233     0.596     0.200
    41.377    -0.765     0.200
    41.458     0.596     0.200
    42.132    -0.040     0.200
    42.177    -0.296     0.200
    42.336     0.390     0.200
    42.439    -1.994     0.200
    42.677     0.169     0.200
    42.851     0.233     0.200
    43.043    -1.211     0.200
    43.259    -1.135     0.200
    43.500     0.779     0.200
    44.134    -2.048     0.200
    44.199    -0.938     0.200
    44.198     0.306     0.200
    44.268    -0.183     0.200
    44.322    -0.599     0.200
    44.559    -0.300     0.200
    44.673     0.615     0.200
    44.806    -0.049     0.200
    44.997    -0.657     0.200
    45.186     1.172     0.200
    45.186     0.539     0.200
    45.426    -1.925     0.200
    45.428    -0.350     0.200
    45.573    -0.477     0.200
    45.710    -0.177     0.200
    45.881    -1.719     0.200
    45.942    -0.331     0.200
    46.053    -0.041     0.200
    46.180    -0.309     0.200
    46.223     0.057     0.200
    46.274     0.904     0.200
    46.371    -0.437     0.200
    47.111    -1.265     0.200
    47.535     0.037     0.200
    47.865    -0.830     0.200
    47.982    -1.373     0.200
    47.982    -1.056     0.200
    48.167     0.464     0.200
    48.296     0.204     0.200
    48.558    -0.335     0.200
    48.642    -0.044     0.200
    48.662    -0.106     0.200
    48.988    -0.782     0.200
    49.030     0.154     0.200
    49.127     0.021     0.200
    49.135    -0.346     0.200
    49.237    -0.452     0.200
    49.270     0.404     0.200
    49.424    -0.118     0.200
    49.541    -0.024     0.200
    49.790     0.477     0.200
    49.926    -0.161     0.200
    49.983    -0.258     0.200
    49.997    -0.435     0.200
    50.031    -0.573     0.200
    50.073    -0.167     0.200
    50.196     0.035     0.200
    50.514     0.199     0.200
    50.555    -0.649     0.200
    50.650     0.047     0.200
    50.682    -0.073     0.200
    50.701    -1.278     0.200
    50.775    -0.542     0.200
    51.124    -0.307     0.200
    51.141    -0.856     0.200
    51.196    -0.400     0.200
    51.315     0.103     0.200
    52.703    -0.556     0.200
    52.765    -1.432     0.200
    52.830    -0.809     0.200
    52.933    -1.024     0.200
    55.302    -0.581     0.200
    58.342     1.033     0.200
    58.559    -1.245     0.200
    58.559    -1.140     0.200
    60.789    -0.658     0.200
    60.925    -1.328     0.200
    60.958    -0.776     0.200
    60.962    -1.553     0.200
    60.962    -2.053     0.200
    61.058    -2.125     0.200
    61.058    -1.453     0.200
    63.284    -1.309     0.200
    64.900    -0.865     0.200
    65.527    -1.159     0.200
    65.527    -1.710     0.200
    65.527    -1.460     0.200
    65.621    -1.324     0.200
    69.495    -1.735     0.200
    70.764    -1.341     0.200
    71.778    -1.955     0.200
    71.778    -2.083     0.200
    72.556    -0.948     0.200
    72.556    -1.198     0.200
    72.556    -1.011     0.200
    72.972     0.221     0.200
    73.265    -0.206     0.200
    73.265    -0.402     0.200
    73.270     0.024     0.200
    74.323    -0.372     0.200
    74.669     0.008     0.200
    74.673     0.181     0.200
    74.826    -0.026     0.200
    74.890    -0.540     0.200
    74.919    -0.579     0.200
    74.995     0.117     0.200
    75.232     0.782     0.200
    75.256     0.376     0.200
    75.643    -1.013     0.200
    75.650    -0.378     0.200
    75.685    -0.916     0.200
    79.826     0.556     0.200
    79.826     1.060     0.200
    80.342    -0.201     0.200
    82.547    -0.277     0.200
    82.547    -0.837     0.200
    82.547    -0.278     0.200
    82.885    -1.317     0.200
    83.093    -0.102     0.200
    83.478    -0.773     0.200
    91.660    -0.150     0.200
    96.968    -1.984     0.200
    19.656     0.364     0.200
    55.198     0.180     0.200
    20.442    -0.545     0.200
    24.905     1.569     0.200
    25.320     1.944     0.200
    27.187    -2.619     0.200
    27.187     0.597     0.200
    29.559     2.930     0.200
    30.182     2.334     0.200
    30.182     2.723     0.200
    31.627     1.549     0.200
    31.627     1.818     0.200
    34.374     0.501     0.200
    44.820     1.057     0.200
    44.820     1.518     0.200
    14.695     5.675     0.200
    27.863     1.015     0.200
    56.588     0.089     0.200
    59.914    -0.263     0.200
    64.638    -0.293     0.200
    64.747    -1.734     0.200
    64.881    -0.319     0.200
    66.879    -1.621     0.200
    66.879    -0.387     0.200
    70.820    -0.138     0.200
    56.255    -1.929     0.200
    59.175    -2.669     0.200
    63.858    -2.279     0.200
    63.967    -2.994     0.200
    66.196    -2.645     0.200
    17.907     0.173     0.200
    29.334     2.922     0.200
    30.823     2.995     0.200
    43.984     2.668     0.200
    46.751    -0.232     0.200
    53.943    -0.595     0.200
    56.668     0.006     0.200
    59.937    -0.822     0.200
    61.831    -0.411     0.200
    66.911    -1.407     0.200
    72.827    -1.257     0.200
    74.129    -0.254     0.200
    20.877    -0.689     0.200
    24.433     1.065     0.200
    25.800     1.790     0.200
    26.204    -3.384     0.200
    26.812    -2.275     0.200
    28.445    -1.329     0.200
    28.994     1.650     0.200
    29.350     1.963     0.200
    30.382     2.026     0.200
    30.508     1.620     0.200
    31.964     1.355     0.200
    32.020     0.769     0.200
    32.020     0.626     0.200
    32.020     0.900     0.200
    34.815    -0.393     0.200
    35.540     1.103     0.200
    39.332     0.877     0.200
    40.163    -0.887     0.200
    42.527    -2.759     0.200
    46.036    -2.818     0.200
    52.730    -1.880     0.200
    55.588    -1.846     0.200
    59.059    -1.847     0.200
    61.769    -2.132     0.200
    61.769    -1.882     0.200
    61.841    -1.992     0.200
    63.804    -0.698     0.200
    63.913    -1.417     0.200
    64.121    -2.841     0.200
    72.552    -2.783     0.200
    74.072    -1.349     0.200
    80.634    -0.713     0.200
    82.996    -1.559     0.200
    83.301    -1.502     0.200
    15.216     4.467     0.200
    18.646    -0.371     0.200
    20.946     0.728     0.200
    25.522     0.785     0.200
    44.479     1.697     0.200
    71.573    -1.412     0.200
    72.911     0.392     0.200
    72.911     0.072     0.200
    19.987    -0.698     0.200
    28.085    -2.611     0.200
    61.178    -2.336     0.200
    65.880    -2.200     0.200
    71.914    -2.499     0.200
    20.065    -0.555     0.200
    55.163    -0.343     0.200
    29.364     1.989     0.200
    30.498     2.360     0.200
    14.450     3.657     0.200
    17.917    -0.925     0.200
    20.515     0.047     0.200
    26.830    -0.431     0.200
    20.890     0.537     0.200
    24.447     0.808     0.200
    32.015     1.711     0.200
    33.256    -1.078     0.200
    42.540    -0.774     0.200
    45.169     1.948     0.200
    53.746    -2.064     0.200
    59.084    -0.508     0.200
    61.869    -1.474     0.200
    63.669    -1.890     0.200
    64.147    -1.035     0.200
    66.020    -0.574     0.200
    66.020    -0.394     0.200
    83.009    -0.454     0.200
    83.330    -1.163     0.200
    15.879     5.431     0.200
    18.687    -2.454     0.200
    20.026    -0.184     0.200
    20.324    -2.363     0.200
    20.686     1.248     0.200
    21.232     0.455     0.200
    21.287     1.109     0.200
    22.143     1.472     0.200
    22.709     0.137     0.200
    23.164     0.346     0.200
    23.460     1.004     0.200
    23.677     1.204     0.200
    23.752     1.307     0.200
    23.825     0.756     0.200
    23.860     0.774     0.200
    23.916     1.615     0.200
    23.916     0.308     0.200
    24.147     0.853     0.200
    24.297     1.230     0.200
    24.338     0.534     0.200
    24.701     2.563     0.200
    24.775     2.067     0.200
    24.887     1.895     0.200
    25.105     2.537     0.200
    25.362     2.170     0.200
    25.531     3.357     0.200
    25.531     1.618     0.200
    25.721     2.778     0.200
    25.918     2.879     0.200
    26.114     2.788     0.200
    26.312    -2.877     0.200
    26.497     0.241     0.200
    26.693     2.535     0.200
    27.074     0.794     0.200
    27.256    -0.735     0.200
    28.043    -0.331     0.200
    28.414     0.036     0.200
    28.706     1.017     0.200
    29.875     0.538     0.200
    29.963     0.214     0.200
    30.005     2.622     0.200
    30.005     1.198     0.200
    30.091     1.051     0.200
    30.226     2.948     0.200
    30.226     1.092     0.200
    30.267     0.697     0.200
    30.595     3.082     0.200
    31.526     1.531     0.200
    31.526     1.953     0.200
    31.636     1.726     0.200
    31.658     1.420     0.200
    31.658     0.430     0.200
    31.811     2.400     0.200
    31.907     1.535     0.200
    31.910     1.444     0.200
    31.911     2.652     0.200
    32.344     1.776     0.200
    32.346     2.074     0.200
    32.396     1.549     0.200
    32.476     1.351     0.200
    32.498     2.794     0.200
    32.611     1.027     0.200
    32.632     1.372     0.200
    32.871     2.108     0.200
    33.010    -2.404     0.200
    33.207     1.992     0.200
    33.214     1.342     0.200
    33.436     1.955     0.200
    33.555     0.852     0.200
    33.555     1.331     0.200
    33.756     0.876     0.200
    33.890     2.246     0.200
    34.082     0.523     0.200
    34.044     1.936     0.200
    34.091     0.740     0.200
    34.407     1.582     0.200
    34.761     0.884     0.200
    34.878     1.949     0.200
    34.974     2.554     0.200
    34.974     1.663     0.200
    34.981     1.411     0.200
    35.135     1.114     0.200
    35.164     1.353     0.200
    35.255    -0.375     0.200
    35.255     0.623     0.200
    35.262     1.738     0.200
    35.393     1.414     0.200
    35.421     1.520     0.200
    35.536     1.740     0.200
    35.582     1.784     0.200
    35.723     1.849     0.200
    35.835     1.837     0.200
    35.930     1.717     0.200
    35.955     1.430     0.200
    36.127     0.597     0.200
    36.216     1.663     0.200
    36.435    -2.586     0.200
    36.578     1.340     0.200
    36.595     1.562     0.200
    36.813     0.923     0.200
    37.172    -1.027     0.200
    37.100     1.447     0.200
    37.293     1.081     0.200
    37.768     0.772     0.200
    37.768    -0.536     0.200
    37.795     0.162     0.200
    37.884     0.855     0.200
    38.089     0.556     0.200
    38.322     1.665     0.200
    38.569     0.541     0.200
    38.592     0.988     0.200
    38.833     0.194     0.200
    38.801     0.492     0.200
    38.801     1.017     0.200
    38.921     1.721     0.200
    38.921     0.897     0.200
    38.921     0.524     0.200
    39.272    -0.463     0.200
    40.133     1.450     0.200
    41.129     0.231     0.200
    41.752    -0.212     0.200
    41.998    -0.236     0.200
    42.025     1.085     0.200
    42.025     0.969     0.200
    42.731    -0.522     0.200
    42.731    -1.054     0.200
    42.824    -1.666     0.200
    43.395    -0.695     0.200
    43.407    -0.069     0.200
    43.648    -0.413     0.200
    43.915    -0.153     0.200
    44.290     0.337     0.200
    44.434    -0.407     0.200
    44.712    -0.550     0.200
    44.678    -0.739     0.200
    44.800     1.332     0.200
    44.800    -0.049     0.200
    44.950    -0.726     0.200
    45.212    -0.176     0.200
    45.341    -0.603     0.200
    45.692    -2.655     0.200
    45.692    -2.385     0.200
    45.890     0.584     0.200
    46.003    -0.319     0.200
    46.046     0.574     0.200
    46.271    -0.294     0.200
    46.559    -0.967     0.200
    46.659     0.072     0.200
    46.894    -0.859     0.200
    47.106    -0.364     0.200
    47.200    -0.245     0.200
    47.631    -0.688     0.200
    47.606     0.296     0.200
    47.707     0.105     0.200
    47.783    -0.680     0.200
    47.837    -0.005     0.200
    47.935     0.235     0.200
    47.935     0.003     0.200
    48.095    -0.656     0.200
    48.140    -0.321     0.200
    48.314    -0.640     0.200
    48.306     0.615     0.200
    48.306    -0.825     0.200
    48.390    -0.439     0.200
    48.380    -0.064     0.200
    48.416    -0.521     0.200
    48.539    -0.701     0.200
    48.573    -0.754     0.200
    48.628    -0.138     0.200
    48.666     0.059     0.200
    48.685    -0.311     0.200
    48.865    -0.265     0.200
    49.029    -0.743     0.200
    49.033    -0.656     0.200
    49.031    -0.447     0.200
    49.113    -1.145     0.200
    49.152    -0.640     0.200
    49.465    -0.483     0.200
    49.467     0.358     0.200
    49.565    -0.229     0.200
    49.630    -0.429     0.200
    49.669    -0.605     0.200
    49.712    -0.929     0.200
    49.712    -1.495     0.200
    49.751    -1.115     0.200
    49.786    -0.263     0.200
    49.870    -0.708     0.200
    49.888    -1.000     0.200
    49.894    -0.344     0.200
    49.913     0.077     0.200
    49.982     0.318     0.200
    50.054    -0.667     0.200
    50.071    -0.611     0.200
    50.132    -0.713     0.200
    50.257    -0.405     0.200
    50.266    -0.078     0.200
    50.284    -0.318     0.200
    50.366    -0.306     0.200
    50.424    -0.617     0.200
    50.459    -0.217     0.200
    50.618    -0.565     0.200
    50.710    -1.120     0.200
    50.752    -0.537     0.200
    50.727    -0.286     0.200
    50.758    -0.453     0.200
    50.788    -1.211     0.200
    51.088     0.245     0.200
    51.075    -0.263     0.200
    51.275    -0.120     0.200
    51.411     0.406     0.200
    52.150    -0.022     0.200
    52.231    -0.741     0.200
    52.331    -0.342     0.200
    52.496    -0.093     0.200
    53.048    -1.088     0.200
    53.151    -1.299     0.200
    54.322    -0.079     0.200
    55.667    -1.246     0.200
    55.667    -0.916     0.200
    58.722    -0.834     0.200
    58.871    -1.652     0.200
    58.871    -1.072     0.200
    58.871    -2.313     0.200
    61.025    -1.560     0.200
    61.175    -2.945     0.200
    61.284    -3.416     0.200
    62.099    -1.666     0.200
    62.009    -1.108     0.200
    63.212    -3.070     0.200
    63.212    -2.677     0.200
    63.809    -2.359     0.200
    64.889    -0.931     0.200
    65.257    -1.043     0.200
    65.404    -1.497     0.200
    65.849    -1.545     0.200
    65.849    -1.979     0.200
    65.942    -1.896     0.200
    66.157    -0.549     0.200
    66.501     4.448     0.200
    68.128    -3.670     0.200
    68.818    -2.546     0.200
    69.016    -2.526     0.200
    69.746    -2.499     0.200
    70.777    -0.042     0.200
    70.825    -0.520     0.200
    70.845    -0.951     0.200
    70.905    -0.656     0.200
    70.912    -1.867     0.200
    70.950    -0.443     0.200
    71.329    -0.345     0.200
    71.342     0.018     0.200
    71.677    -1.004     0.200
    71.753    -0.202     0.200
    71.753    -0.693     0.200
    71.755    -0.487     0.200
    71.797    -0.097     0.200
    71.910    -2.347     0.200
    71.910    -2.652     0.200
    72.009    -0.472     0.200
    72.080    -0.993     0.200
    72.275    -0.641     0.200
    72.310    -0.972     0.200
    72.650    -0.627     0.200
    72.634     0.601     0.200
    72.853    -1.529     0.200
    72.853    -1.728     0.200
    73.033     0.131     0.200
    72.882     0.526     0.200
    73.162     0.268     0.200
    73.301    -1.062     0.200
    73.325    -1.132     0.200
    73.327    -0.373     0.200
    73.327    -0.704     0.200
    73.366     0.767     0.200
    73.572     0.649     0.200
    73.673     0.159     0.200
    74.394    -0.728     0.200
    74.415    -0.224     0.200
    74.426     2.558     0.200
    74.523     1.472     0.200
    74.589    -0.263     0.200
    74.643     0.090     0.200
    74.720     0.115     0.200
    74.722     0.287     0.200
    74.873     0.278     0.200
    75.024     0.079     0.200
    75.054     0.109     0.200
    75.142    -0.362     0.200
    75.271    -0.400     0.200
    75.311    -0.511     0.200
    75.096     0.679     0.200
    75.523    -0.602     0.200
    75.540    -0.104     0.200
    75.582    -0.399     0.200
    75.560    -0.959     0.200
    75.714    -0.556     0.200
    75.831    -0.774     0.200
    75.774     0.090     0.200
    75.930    -1.603     0.200
    76.354     0.167     0.200
    76.609    -1.700     0.200
    76.950     0.318     0.200
    77.150     0.293     0.200
    77.252     0.273     0.200
    77.323     0.322     0.200
    77.420    -1.579     0.200
    77.435     0.498     0.200
    77.697     0.434     0.200
    77.924    -1.478     0.200
    77.926     0.156     0.200
    78.308     0.439     0.200
    78.415     0.350     0.200
    78.379    -0.441     0.200
    78.768     0.172     0.200
    78.855     0.424     0.200
    78.856     0.117     0.200
    79.267     0.570     0.200
    79.269    -0.141     0.200
    79.415    -0.037     0.200
    79.790     0.246     0.200
    79.832    -0.627     0.200
    79.976    -0.084     0.200
    80.251     0.430     0.200
    80.546     0.149     0.200
    80.584     0.640     0.200
    80.464     1.663     0.200
    80.662    -0.286     0.200
    80.775    -0.181     0.200
    80.934    -0.703     0.200
    81.055     0.026     0.200
    81.120     0.477     0.200
    81.222     1.138     0.200
    81.340    -0.389     0.200
    81.410    -0.359     0.200
    81.487    -0.568     0.200
    81.538     0.063     0.200
    81.513    -0.307     0.200
    81.549    -0.496     0.200
    81.549    -0.397     0.200
    81.596    -0.345     0.200
    81.641    -0.284     0.200
    82.070    -0.240     0.200
    82.116    -0.482     0.200
    82.604    -1.109     0.200
    82.702    -0.802     0.200
    82.966    -1.009     0.200
    83.269    -0.530     0.200
    83.269    -0.970     0.200
    83.619     0.020     0.200
    85.872     0.242     0.200
    86.233     0.334     0.200
    87.347    -2.116     0.200
    89.261     0.299     0.200
    91.890     0.558     0.200
    92.786    -1.073     0.200
    92.845    -0.155     0.200
    97.248    -1.397     0.200
    18.703    -2.684     0.200
    20.105     0.283     0.200
    20.478    -1.616     0.200
    20.478    -0.756     0.200
    20.626     0.609     0.200
    20.788     1.301     0.200
    21.162    -1.043     0.200
    21.226    -0.801     0.200
    21.394     1.984     0.200
    21.556     0.162     0.200
    21.562     1.310     0.200
    21.959     1.990     0.200
    22.069    -2.570     0.200
    22.336     2.262     0.200
    22.606     1.752     0.200
    22.624    -2.361     0.200
    22.634     2.384     0.200
    23.044     1.023     0.200
    23.090    -1.993     0.200
    23.114    -1.759     0.200
    23.373    -0.385     0.200
    23.484     2.224     0.200
    23.541     3.325     0.200
    23.537     2.222     0.200
    23.599     2.642     0.200
    23.872     2.678     0.200
    23.872     0.431     0.200
    23.946     2.233     0.200
    24.058    -0.133     0.200
    24.214    -0.399     0.200
    24.239     1.287     0.200
    24.610     0.124     0.200
    24.673    -0.641     0.200
    24.804     3.277     0.200
    25.008     1.779     0.200
    25.018     1.636     0.200
    25.133    -0.051     0.200
    25.266    -0.069     0.200
    25.431     4.301     0.200
    25.431     3.187     0.200
    25.593     1.977     0.200
    25.596     4.271     0.200
    25.619     0.781     0.200
    25.821     1.101     0.200
    26.011     1.037     0.200
    26.436    -1.753     0.200
    26.436    -1.632     0.200
    26.376     1.262     0.200
    26.455    -0.002     0.200
    26.587     1.554     0.200
    26.850    -0.956     0.200
    26.972     1.159     0.200
    27.314    -1.821     0.200
    27.314    -0.962     0.200
    27.314    -2.387     0.200
    27.711     2.071     0.200
    27.980     0.193     0.200
    28.006     1.791     0.200
    28.150    -0.879     0.200
    29.423     1.789     0.200
    29.423     2.573     0.200
    29.830     0.981     0.200
    30.054     0.325     0.200
    30.129     3.194     0.200
    30.698    -0.126     0.200
    30.712     0.620     0.200
    31.244     2.174     0.200
    31.477     2.315     0.200
    31.477     0.325     0.200
    31.549     2.813     0.200
    31.549     1.860     0.200
    31.587     0.402     0.200
    31.692     3.151     0.200
    32.232     1.203     0.200
    32.238     0.543     0.200
    33.180    -1.742     0.200
    33.180    -0.417     0.200
    33.180    -2.265     0.200
    33.116     1.504     0.200
    33.479     1.336     0.200
    33.528     2.380     0.200
    33.528     1.177     0.200
    33.548     0.738     0.200
    33.658     1.466     0.200
    33.783     0.339     0.200
    34.034     0.687     0.200
    34.106     1.692     0.200
    34.106     0.629     0.200
    34.308     0.359     0.200
    34.715     0.051     0.200
    34.775    -0.135     0.200
    34.868    -0.147     0.200
    34.868     1.880     0.200
    34.868     1.404     0.200
    34.875     0.898     0.200
    35.064     1.377     0.200
    35.269     0.198     0.200
    35.328     1.795     0.200
    35.440     0.864     0.200
    35.730     0.134     0.200
    35.823     0.337     0.200
    35.837     2.880     0.200
    35.872     1.035     0.200
    36.059     1.470     0.200
    36.574    -0.850     0.200
    36.527     1.264     0.200
    36.534     1.309     0.200
    36.577    -0.322     0.200
    37.021     0.189     0.200
    37.236     1.541     0.200
    37.344     0.163     0.200
    37.787     0.431     0.200
    37.791     0.636     0.200
    37.791     0.824     0.200
    37.990     1.510     0.200
    38.266     1.024     0.200
    38.548     0.496     0.200
    38.608     0.394     0.200
    38.710     2.060     0.200
    38.841     0.100     0.200
    38.852     2.624     0.200
    38.852     3.116     0.200
    38.852    -0.052     0.200
    39.118     0.653     0.200
    39.286     1.929     0.200
    39.379     2.836     0.200
    41.416     1.256     0.200
    41.539     1.851     0.200
    41.539     0.120     0.200
    41.757    -0.671     0.200
    41.802     1.222     0.200
    41.950     1.167     0.200
    42.069     0.474     0.200
    42.915    -2.093     0.200
    42.898     0.214     0.200
    42.898    -0.516     0.200
    43.042    -1.377     0.200
    43.073     0.748     0.200
    43.434     0.061     0.200
    43.513    -0.440     0.200
    43.543    -0.552     0.200
    43.543    -1.700     0.200
    43.796    -0.014     0.200
    43.915    -0.008     0.200
    44.159     0.322     0.200
    44.235     0.127     0.200
    44.235    -0.073     0.200
    44.422    -1.168     0.200
    44.492    -0.274     0.200
    44.665     0.459     0.200
    44.665    -1.096     0.200
    44.723     2.107     0.200
    44.723     1.914     0.200
    44.724     2.476     0.200
    44.886    -0.570     0.200
    45.047    -2.404     0.200
    45.110     0.501     0.200
    45.200    -0.318     0.200
    45.217    -0.282     0.200
    45.436     0.491     0.200
    45.524     0.485     0.200
    45.873    -1.463     0.200
    45.829     0.945     0.200
    45.829     1.398     0.200
    46.014     0.568     0.200
    46.177    -2.770     0.200
    46.048    -1.003     0.200
    46.381    -0.627     0.200
    46.458     0.190     0.200
    46.613     0.108     0.200
    46.710    -0.446     0.200
    46.764     1.629     0.200
    46.764    -0.035     0.200
    46.769    -0.396     0.200
    46.982    -0.587     0.200
    46.949    -0.409     0.200
    47.095    -1.200     0.200
    47.160    -0.459     0.200
    47.692    -0.688     0.200
    47.842    -0.428     0.200
    47.861     0.086     0.200
    47.925     1.411     0.200
    47.925     0.095     0.200
    48.152    -1.058     0.200
    48.189    -0.240     0.200
    48.395    -0.827     0.200
    48.287    -1.016     0.200
    48.341    -0.316     0.200
    48.396    -0.055     0.200
    48.437    -0.612     0.200
    48.435    -1.055     0.200
    48.715    -0.580     0.200
    48.625    -1.224     0.200
    48.672    -1.383     0.200
    48.703    -0.559     0.200
    48.733    -1.015     0.200
    48.762    -0.664     0.200
    48.928    -2.457     0.200
    48.984     0.686     0.200
    49.056    -3.030     0.200
    49.082    -2.469     0.200
    49.080    -1.211     0.200
    49.091    -1.259     0.200
    49.164    -0.375     0.200
    49.197    -1.383     0.200
    49.274     0.431     0.200
    49.520    -1.628     0.200
    49.716    -0.716     0.200
    49.721    -1.420     0.200
    49.750    -0.951     0.200
    49.788    -1.055     0.200
    49.816    -0.901     0.200
    49.899    -0.311     0.200
    49.916     0.891     0.200
    49.931    -1.336     0.200
    49.937    -1.203     0.200
    50.116    -1.080     0.200
    50.125    -2.402     0.200
    50.201    -3.654     0.200
    50.304    -1.580     0.200
    50.325    -1.449     0.200
    50.337    -1.420     0.200
    50.417    -1.409     0.200
    50.490    -1.492     0.200
    50.676    -1.666     0.200
    50.778    -3.058     0.200
    50.900    -1.853     0.200
    50.927    -1.676     0.200
    51.087    -0.585     0.200
    51.323     0.182     0.200
    51.386    -0.862     0.200
    51.661     0.761     0.200
    51.823    -1.458     0.200
    52.325    -0.437     0.200
    52.633     0.086     0.200
    52.658    -1.165     0.200
    52.887     0.573     0.200
    53.215    -1.111     0.200
    53.239    -1.337     0.200
    54.018    -0.535     0.200
    55.798    -0.838     0.200
    58.830     0.958     0.200
    59.038    -0.664     0.200
    59.038    -0.984     0.200
    60.943    -0.246     0.200
    61.177    -0.149     0.200
    61.212    -0.456     0.200
    61.366    -0.950     0.200
    61.366    -1.208     0.200
    61.476    -1.638     0.200
    61.476    -1.537     0.200
    61.623    -0.328     0.200
    61.750     0.321     0.200
    62.286    -0.799     0.200
    62.457     0.183     0.200
    63.400    -1.481     0.200
    63.400    -1.871     0.200
    63.719     0.522     0.200
    63.988    -1.043     0.200
    64.226     0.743     0.200
    64.356    -0.156     0.200
    64.707     0.030     0.200
    64.879    -0.089     0.200
    65.065     0.003     0.200
    65.333    -0.165     0.200
    65.504    -0.911     0.200
    65.943    -0.096     0.200
    66.011    -1.373     0.200
    66.011    -1.373     0.200
    66.231    -0.234     0.200
    66.277     0.336     0.200
    66.653     2.423     0.200
    66.747     0.473     0.200
    67.362     0.434     0.200
    67.384    -2.112     0.200
    68.173     1.489     0.200
    68.320    -1.093     0.200
    69.008    -1.067     0.200
    69.008    -1.481     0.200
    69.201    -1.024     0.200
    69.580     0.352     0.200
    69.767    -1.064     0.200
    70.151    -0.914     0.200
    70.164    -1.197     0.200
    70.212    -1.787     0.200
    70.321    -1.355     0.200
    70.563    -0.930     0.200
    70.505     0.885     0.200
    70.683     0.549     0.200
    71.007     0.509     0.200
    71.011    -0.149     0.200
    71.131     0.548     0.200
    71.469    -0.913     0.200
    71.515     0.426     0.200
    71.515    -0.050     0.200
    71.551     0.484     0.200
    71.643     0.355     0.200
    71.677    -0.015     0.200
    71.840     0.181     0.200
    71.807     0.388     0.200
    71.853     0.330     0.200
    71.893     0.305     0.200
    71.934     0.697     0.200
    71.944     0.536     0.200
    71.972     0.686     0.200
    72.088     0.432     0.200
    72.032     0.706     0.200
    72.101    -1.135     0.200
    72.101    -1.107     0.200
    72.133     0.682     0.200
    72.248     0.329     0.200
    72.197     0.720     0.200
    72.449    -0.091     0.200
    72.460     0.769     0.200
    72.474     0.523     0.200
    72.498     0.425     0.200
    72.838     0.553     0.200
    72.838     0.107     0.200
    72.956     1.229     0.200
    73.008    -0.396     0.200
    73.149     0.448     0.200
    73.219     0.958     0.200
    73.252     0.496     0.200
    73.252     0.164     0.200
    73.485    -0.108     0.200
    73.513     0.297     0.200
    73.513     0.375     0.200
    73.555     0.985     0.200
    73.585     0.408     0.200
    73.761     0.876     0.200
    73.863     1.180     0.200
    73.873     0.423     0.200
    74.092     1.145     0.200
    74.183     0.116     0.200
    74.223     0.676     0.200
    74.539     0.497     0.200
    74.581     0.639     0.200
    74.685    -0.562     0.200
    74.773     0.520     0.200
    74.803     0.134     0.200
    74.827     0.660     0.200
    74.904     0.689     0.200
    74.906     0.778     0.200
    75.057     1.147     0.200
    75.207     1.340     0.200
    75.224     0.265     0.200
    75.239     0.789     0.200
    75.496     0.678     0.200
    75.768     0.566     0.200
    75.900     0.406     0.200
    76.017     0.389     0.200
    76.304    -0.348     0.200
    76.786     0.109     0.200
    76.972     0.639     0.200
    77.162    -0.999     0.200
    77.350     1.025     0.200
    77.401     0.328     0.200
    77.414     0.397     0.200
    77.916    -0.196     0.200
    77.916     0.195     0.200
    77.963    -0.161     0.200
    77.999     0.244     0.200
    78.115     0.642     0.200
    78.115     0.493     0.200
    78.472    -0.080     0.200
    79.020     0.612     0.200
    79.144    -0.739     0.200
    79.672    -0.840     0.200
    79.958     1.080     0.200
    80.253     0.188     0.200
    80.412     1.170     0.200
    81.116     0.222     0.200
    81.383     1.698     0.200
    82.894     0.105     0.200
    82.894     0.395     0.200
    83.366    -0.632     0.200
    83.366    -0.238     0.200
    83.390    -0.062     0.200
    83.397    -0.102     0.200
    83.413    -0.278     0.200
    83.415    -0.289     0.200
    85.580    -1.520     0.200
    97.184    -1.135     0.200
    18.358    -1.570     0.200
    20.546     0.909     0.200
    21.169    -1.749     0.200
    26.984    -2.761     0.200
    26.984    -3.308     0.200
    27.546    -0.955     0.200
    27.546    -0.377     0.200
    27.546    -2.603     0.200
    27.546    -1.150     0.200
    28.612    -2.361     0.200
    29.740     2.938     0.200
    31.316     2.798     0.200
    33.947    -2.329     0.200
    33.947    -2.087     0.200
    37.184    -2.571     0.200
    40.126    -0.522     0.200
    43.296    -2.032     0.200
    43.296    -2.305     0.200
    43.707     0.986     0.200
    43.707     0.385     0.200
    43.906    -0.857     0.200
    44.430     2.372     0.200
    45.317    -0.342     0.200
    45.743    -1.093     0.200
    45.751     1.128     0.200
    45.890    -0.244     0.200
    45.934     0.432     0.200
    45.934    -1.599     0.200
    46.700    -1.306     0.200
    46.700    -1.462     0.200
    46.700    -1.150     0.200
    50.160    -1.009     0.200
    53.469    -1.480     0.200
    53.914    -1.237     0.200
    53.936    -0.561     0.200
    54.137    -1.139     0.200
    54.137    -1.069     0.200
    54.643    -0.746     0.200
    54.647    -1.083     0.200
    55.210    -1.362     0.200
    55.617    -0.673     0.200
    56.054    -1.401     0.200
    56.054    -1.222     0.200
    56.045    -0.567     0.200
    56.367    -0.695     0.200
    58.690    -0.672     0.200
    59.287    -2.330     0.200
    59.787    -1.127     0.200
    59.787    -1.080     0.200
    59.787    -1.182     0.200
    59.787    -0.971     0.200
    60.927    -0.621     0.200
    61.071    -1.640     0.200
    61.470    -1.275     0.200
    61.826    -0.773     0.200
    62.095    -0.254     0.200
    62.095    -0.621     0.200
    62.201    -0.316     0.200
    62.264    -1.233     0.200
    62.265    -0.771     0.200
    62.265    -0.989     0.200
    62.372    -2.002     0.200
    62.372    -1.900     0.200
    62.461    -0.199     0.200
    62.422    -0.529     0.200
    62.640    -0.823     0.200
    63.337    -0.627     0.200
    63.337    -0.494     0.200
    63.494    -0.858     0.200
    63.616    -1.141     0.200
    63.616    -1.563     0.200
    63.666    -0.232     0.200
    64.259    -1.279     0.200
    64.259    -1.396     0.200
    64.800    -1.129     0.200
    65.255    -0.116     0.200
    65.934    -1.071     0.200
    66.053    -0.675     0.200
    66.737    -1.613     0.200
    66.737    -1.254     0.200
    66.737    -1.387     0.200
    66.737    -1.254     0.200
    66.832    -1.219     0.200
    66.932    -2.073     0.200
    67.589    -2.315     0.200
    68.281    -0.761     0.200
    69.889    -0.912     0.200
    70.053    -1.040     0.200
    70.612    -2.558     0.200
    70.773    -1.134     0.200
    70.773    -1.235     0.200
    70.883    -1.639     0.200
    70.891    -1.653     0.200
    70.891    -1.755     0.200
    70.978    -1.097     0.200
    71.050    -1.356     0.200
    71.086    -1.762     0.200
    71.338    -1.322     0.200
    71.700    -1.522     0.200
    71.747    -3.330     0.200
    71.893    -0.307     0.200
    71.967    -3.149     0.200
    72.226    -0.828     0.200
    72.577    -0.495     0.200
    72.803    -0.136     0.200
    72.831     1.199     0.200
    72.873     0.148     0.200
    73.002    -0.470     0.200
    73.002     0.085     0.200
    73.002    -0.704     0.200
    73.000    -1.037     0.200
    73.000    -1.303     0.200
    73.000    -0.725     0.200
    73.000    -0.803     0.200
    73.085    -0.007     0.200
    73.387     0.110     0.200
    73.804    -0.637     0.200
    73.804    -0.942     0.200
    74.070     0.002     0.200
    74.102     0.122     0.200
    74.349    -1.521     0.200
    74.396     0.035     0.200
    74.396    -0.590     0.200
    74.759     0.603     0.200
    75.468     0.471     0.200
    75.584    -2.189     0.200
    75.705     1.160     0.200
    75.782     0.040     0.200
    75.783     0.526     0.200
    75.932    -0.246     0.200
    76.121    -0.301     0.200
    76.376     0.825     0.200
    76.498    -0.452     0.200
    76.606    -0.065     0.200
    76.653     0.506     0.200
    76.784     0.219     0.200
    76.911    -0.345     0.200
    77.621    -0.344     0.200
    77.870    -1.450     0.200
    77.886    -0.451     0.200
    78.056    -0.279     0.200
    78.248    -0.247     0.200
    78.290    -0.450     0.200
    78.310    -0.629     0.200
    78.365     0.121     0.200
    78.449     0.293     0.200
    78.473    -0.943     0.200
    78.545    -0.683     0.200
    78.801    -0.376     0.200
    78.801     0.006     0.200
    78.801    -0.173     0.200
    78.862    -0.988     0.200
    79.000     0.440     0.200
    79.000     0.213     0.200
    79.145    -0.182     0.200
    79.260    -0.544     0.200
    79.260    -0.809     0.200
    80.039    -0.169     0.200
    80.770     0.716     0.200
    81.554    -0.325     0.200
    81.945     0.034     0.200
    83.767    -0.939     0.200
    83.767    -1.236     0.200
    83.785     1.971     0.200
    83.798    -0.197     0.200
    83.792     0.038     0.200
    83.792     0.140     0.200
    83.792    -0.313     0.200
    84.515    -0.196     0.200
    28.209    -3.161     0.200
    29.243     2.650     0.200
    30.586     1.823     0.200
    43.828     2.366     0.200
    59.739    -0.971     0.200
    66.736    -1.458     0.200
    19.681     0.290     0.200
    55.764    -0.749     0.200
    65.857    -1.675     0.200
    83.436    -1.044     0.200
    27.241     0.710     0.200
    27.278    -1.106     0.200
    52.917    -1.476     0.200
    61.046    -1.408     0.200
    65.978    -1.714     0.200
    71.794    -1.560     0.200
    72.083    -0.310     0.200
    72.084    -0.455     0.200
    72.484     0.470     0.200
    73.076     0.106     0.200
    73.144    -0.057     0.200
    75.435     0.454     0.200
    77.473    -0.343     0.200
    79.526     0.244     0.200
    82.611    -0.458     0.200
    83.553    -0.319     0.200
    27.325    -2.118     0.200
    27.614    -0.528     0.200
    30.144     3.033     0.200
    31.461     1.835     0.200
    33.106    -3.264     0.200
    44.725     0.040     0.200
    53.126    -2.578     0.200
    55.758    -1.080     0.200
    58.966    -1.470     0.200
    61.095    -0.802     0.200
    61.095    -1.529     0.200
    61.254    -1.576     0.200
    63.305    -2.467     0.200
    63.907    -1.869     0.200
    64.948    -0.977     0.200
    65.944    -1.664     0.200
    68.907    -1.932     0.200
    69.108    -1.650     0.200
    71.990    -1.651     0.200
    72.081    -0.549     0.200
    72.383    -0.644     0.200
    73.103     0.186     0.200
    73.397    -0.201     0.200
    73.468    -0.373     0.200
    74.465     0.487     0.200
    74.711     0.167     0.200
    74.787     0.316     0.200
    74.790     0.601     0.200
    74.940     0.664     0.200
    75.090    -0.351     0.200
    75.123     0.414     0.200
    75.652     0.520     0.200
    75.784     0.047     0.200
    78.012    -1.030     0.200
    79.841     0.264     0.200
    81.147     0.175     0.200
    81.502    -0.299     0.200
    81.579    -0.513     0.200
    81.630     0.318     0.200
    81.641    -0.339     0.200
    81.641    -0.534     0.200
    81.733    -0.020     0.200
    82.163    -0.181     0.200
    82.209    -0.319     0.200
    82.786    -0.823     0.200
    83.351    -1.343     0.200
    18.888    -0.092     0.200
    30.513     1.574     0.200
    43.878     1.127     0.200
    44.227    -0.544     0.200
    56.317    -0.360     0.200
    71.564    -1.068     0.200
    13.765     7.306     0.200
    18.235    -0.631     0.200
    19.850    -0.796     0.200
    13.378     2.726     0.200
    54.820     0.611     0.200
    19.402    -0.052     0.200
    20.615     0.311     0.200
    20.615    -0.939     0.200
    20.897    -1.487     0.200
    20.897    -1.666     0.200
    23.957     2.266     0.200
    25.287     3.878     0.200
    26.713    -2.927     0.200
    27.309    -1.257     0.200
    27.309    -2.210     0.200
    27.309    -0.460     0.200
    28.430     0.034     0.200
    28.430    -0.763     0.200
    28.482    -0.301     0.200
    29.996     3.166     0.200
    29.996     1.033     0.200
    31.455     1.332     0.200
    31.538     1.917     0.200
    31.538     2.761     0.200
    33.676     0.638     0.200
    33.682    -1.439     0.200
    33.682    -1.908     0.200
    33.682    -1.611     0.200
    34.432     1.183     0.200
    35.563    -0.454     0.200
    36.911    -3.080     0.200
    43.040    -1.985     0.200
    43.040    -2.610     0.200
    43.617     0.135     0.200
    43.617    -0.037     0.200
    43.773    -1.732     0.200
    44.127    -0.144     0.200
    44.157    -0.235     0.200
    45.142    -0.782     0.200
    45.146    -0.883     0.200
    45.620    -1.707     0.200
    45.818    -0.375     0.200
    45.985     0.303     0.200
    45.985    -0.064     0.200
    46.447    -1.347     0.200
    46.674    -0.079     0.200
    47.035    -0.006     0.200
    48.130     0.760     0.200
    48.477     0.064     0.200
    49.341     0.485     0.200
    49.344     0.727     0.200
    49.497    -0.461     0.200
    50.178     0.547     0.200
    50.277     0.081     0.200
    50.594     0.623     0.200
    50.762     0.338     0.200
    51.213     0.027     0.200
    51.388    -0.426     0.200
    53.230    -0.642     0.200
    53.953    -2.030     0.200
    53.953    -1.373     0.200
    56.096    -0.743     0.200
    56.096    -1.040     0.200
    59.520    -1.510     0.200
    59.520    -1.870     0.200
    59.520    -0.768     0.200
    59.520    -1.190     0.200
    60.852    -0.985     0.200
    61.905    -1.569     0.200
    61.941    -0.838     0.200
    61.941    -0.814     0.200
    62.079    -1.085     0.200
    62.080    -1.067     0.200
    62.162    -4.020     0.200
    62.190    -1.011     0.200
    63.014    -0.627     0.200
    63.389    -1.584     0.200
    64.018    -1.416     0.200
    64.018    -1.534     0.200
    64.018    -0.323     0.200
    64.257    -0.795     0.200
    64.543    -1.764     0.200
    64.543    -1.068     0.200
    65.793     0.010     0.200
    65.802    -0.027     0.200
    66.468    -1.503     0.200
    66.468    -1.199     0.200
    66.468    -1.097     0.200
    66.563    -1.409     0.200
    68.074    -1.573     0.200
    69.029    -1.135     0.200
    69.808    -1.091     0.200
    70.525    -1.238     0.200
    70.525    -1.081     0.200
    71.740    -1.484     0.200
    72.399    -0.529     0.200
    72.671     0.160     0.200
    72.712     0.110     0.200
    72.735    -0.725     0.200
    72.735    -0.475     0.200
    72.808    -1.437     0.200
    72.808    -1.257     0.200
    72.808    -1.359     0.200
    72.924     0.353     0.200
    73.168     0.613     0.200
    73.225    -0.120     0.200
    73.541    -0.683     0.200
    73.564     0.141     0.200
    73.948     0.224     0.200
    73.948    -0.042     0.200
    74.242    -0.310     0.200
    74.242     0.112     0.200
    74.242    -0.083     0.200
    74.313     1.096     0.200
    75.391     0.399     0.200
    75.394    -0.981     0.200
    75.504     0.262     0.200
    75.558     0.508     0.200
    75.635     0.724     0.200
    75.637     0.023     0.200
    75.787     0.093     0.200
    75.909    -0.147     0.200
    75.938    -0.361     0.200
    75.938    -0.119     0.200
    75.938     0.780     0.200
    75.969     0.825     0.200
    76.226     0.868     0.200
    76.233    -0.527     0.200
    76.456    -0.275     0.200
    76.497     0.156     0.200
    76.618    -0.351     0.200
    76.629     0.212     0.200
    76.654    -0.724     0.200
    76.734     0.004     0.200
    76.841    -0.668     0.200
    77.356    -0.835     0.200
    77.449    -0.376     0.200
    77.670    -0.214     0.200
    77.700    -0.877     0.200
    77.883     0.026     0.200
    78.026    -0.676     0.200
    78.354     0.177     0.200
    78.578    -0.143     0.200
    78.638    -0.361     0.200
    78.777     0.267     0.200
    78.777    -0.233     0.200
    79.865    -0.597     0.200
    80.677     0.231     0.200
    80.678     0.648     0.200
    80.678     0.281     0.200
    81.284    -0.770     0.200
    81.692     0.291     0.200
    81.854    -1.380     0.200
    83.509    -0.129     0.200
    83.509    -0.684     0.200
    83.587    -0.481     0.200
    83.587     0.017     0.200
    83.587    -0.311     0.200
    84.305    -0.614     0.200
    87.110     1.085     0.200
    13.326     6.035     0.200
    17.774    -1.511     0.200
    17.774    -1.292     0.200
    19.585     0.758     0.200
    19.585    -0.234     0.200
    19.726     0.330     0.200
    25.862    -1.005     0.200
    35.913    -1.891     0.200
    44.826    -0.451     0.200
    44.932    -1.886     0.200
    55.181    -0.140     0.200
    58.195    -1.403     0.200
    60.318    -1.783     0.200
    65.198    -2.305     0.200
    71.054    -2.609     0.200
    72.475    -1.320     0.200
    78.992    -0.264     0.200
    80.169    -1.854     0.200
    82.945    -0.710     0.200
    43.379    -1.602     0.200
    63.645    -0.759     0.200
    65.881    -1.448     0.200
    13.191     3.499     0.200
    13.191     3.296     0.200
    14.148     3.583     0.200
    17.192    -2.182     0.200
    17.192    -2.745     0.200
    18.083    -2.351     0.200
    18.083    -2.585     0.200
    20.143     0.239     0.200
    20.143     0.005     0.200
    26.492    -1.208     0.200
    26.829     0.835     0.200
    28.644     1.252     0.200
    38.185     0.611     0.200
    39.093    -1.245     0.200
    41.523     0.582     0.200
    41.930    -1.223     0.200
    42.891    -0.223     0.200
    45.343    -0.575     0.200
    45.343    -0.676     0.200
    46.599    -0.267     0.200
    47.258    -0.421     0.200
    47.815    -0.392     0.200
    48.345     0.387     0.200
    48.578     0.416     0.200
    48.690     0.435     0.200
    48.922     0.619     0.200
    49.187    -0.899     0.200
    49.302     0.588     0.200
    49.535     0.133     0.200
    50.111     0.449     0.200
    50.250    -1.215     0.200
    50.998    -0.191     0.200
    51.040    -1.021     0.200
    54.349    -0.535     0.200
    54.655    -0.455     0.200
    54.655    -0.306     0.200
    57.803    -1.278     0.200
    57.803    -0.849     0.200
    64.783    -0.691     0.200
    64.783    -1.684     0.200
    64.783    -1.223     0.200
    64.876    -0.830     0.200
    68.703    -2.252     0.200
    71.015    -2.835     0.200
    21.236     0.800     0.200
    28.983     1.187     0.200
    31.885     1.314     0.200
    32.108     2.531     0.200
    32.108     2.867     0.200
    45.192     2.506     0.200
    55.745    -0.120     0.200
    59.342    -1.321     0.200
    59.342    -0.571     0.200
    62.236    -1.919     0.200
    62.293    -2.679     0.200
    66.261    -1.340     0.200
    66.261     0.035     0.200
    70.488    -0.330     0.200
    72.998    -0.723     0.200
    17.325    -1.844     0.200
    20.052     0.770     0.200
    20.052     0.219     0.200
    43.819    -0.884     0.200
    55.194     0.688     0.200
    64.567    -1.663     0.200
    71.472    -2.439     0.200
    79.504     1.052     0.200
    82.847    -0.176     0.200
    20.244    -0.316     0.200
    27.077    -2.584     0.200
    27.750    -1.027     0.200
    31.711     0.825     0.200
    42.671    -1.999     0.200
    53.139    -1.854     0.200
    55.560    -0.966     0.200
    58.825    -1.741     0.200
    61.143    -2.319     0.200
    61.265    -1.996     0.200
    62.212    -1.207     0.200
    63.658    -1.393     0.200
    63.797    -1.495     0.200
    65.793    -1.796     0.200
    68.856    -1.826     0.200
    71.992    -1.735     0.200
    73.445    -1.202     0.200
    75.151     0.409     0.200
    18.679    -0.359     0.200
    19.625    -1.925     0.200
    19.625    -1.495     0.200
    20.094    -0.591     0.200
    22.063     1.636     0.200
    22.311     0.833     0.200
    22.965     0.086     0.200
    23.024     1.916     0.200
    23.115     1.994     0.200
    23.142     1.215     0.200
    23.243     1.665     0.200
    23.243     0.546     0.200
    23.243     1.290     0.200
    23.299     1.552     0.200
    23.463     2.422     0.200
    24.102     2.413     0.200
    24.364     1.448     0.200
    24.382     0.973     0.200
    25.028     0.437     0.200
    25.298     2.190     0.200
    25.810     1.307     0.200
    25.973     0.940     0.200
    26.021     0.867     0.200
    26.098    -0.671     0.200
    26.098    -0.921     0.200
    26.396    -1.816     0.200
    26.519     1.808     0.200
    26.861     1.397     0.200
    26.967     0.986     0.200
    27.181     0.966     0.200
    27.269     1.385     0.200
    27.459     0.243     0.200
    27.740     1.462     0.200
    27.825     1.475     0.200
    27.826     0.909     0.200
    27.861     0.655     0.200
    27.861     0.965     0.200
    27.902    -0.914     0.200
    27.902    -1.513     0.200
    28.293    -0.794     0.200
    28.293    -1.034     0.200
    28.293    -0.564     0.200
    28.782     1.587     0.200
    29.360     1.891     0.200
    29.382    -0.262     0.200
    29.571     2.334     0.200
    29.875     1.782     0.200
    29.958     2.145     0.200
    30.073    -1.679     0.200
    30.879     1.851     0.200
    30.879     1.964     0.200
    31.174     2.012     0.200
    31.287     2.067     0.200
    31.555     3.157     0.200
    31.742     2.340     0.200
    32.085    -0.926     0.200
    32.107     2.282     0.200
    32.220     2.906     0.200
    32.228     2.190     0.200
    32.273     2.361     0.200
    32.508     1.435     0.200
    32.556     1.203     0.200
    32.535    -2.632     0.200
    32.535    -2.401     0.200
    32.535    -1.501     0.200
    32.667     1.965     0.200
    32.748     1.645     0.200
    32.748     2.055     0.200
    32.956     2.588     0.200
    32.980    -0.117     0.200
    32.980    -0.517     0.200
    32.974    -1.125     0.200
    33.157    -0.144     0.200
    33.210     2.258     0.200
    33.491     1.790     0.200
    33.719     2.450     0.200
    33.816     2.376     0.200
    34.087     1.572     0.200
    34.159     2.475     0.200
    34.201    -0.072     0.200
    34.201     0.190     0.200
    34.401     1.288     0.200
    34.580     1.294     0.200
    34.584     1.416     0.200
    34.651     1.182     0.200
    34.660     2.271     0.200
    34.714     1.432     0.200
    34.718     1.705     0.200
    34.916     1.681     0.200
    35.071     1.789     0.200
    35.158     0.118     0.200
    35.196     2.142     0.200
    35.255     2.251     0.200
    35.405     1.666     0.200
    35.563     2.212     0.200
    35.614     1.540     0.200
    35.749     2.453     0.200
    35.938     1.840     0.200
    35.986     1.146     0.200
    36.026     1.255     0.200
    36.053     1.115     0.200
    36.362    -2.794     0.200
    36.362    -1.733     0.200
    36.667     0.308     0.200
    36.673     1.909     0.200
    36.692     1.093     0.200
    36.692     2.585     0.200
    36.865     0.388     0.200
    37.005     0.444     0.200
    37.186     1.947     0.200
    37.520    -0.675     0.200
    37.711     2.144     0.200
    37.722     1.057     0.200
    37.738    -1.144     0.200
    37.810    -0.118     0.200
    37.810     0.553     0.200
    37.824     1.353     0.200
    38.335     0.297     0.200
    38.413     1.701     0.200
    38.413     0.056     0.200
    38.413     1.851     0.200
    38.413     2.146     0.200
    38.470    -0.028     0.200
    38.470     2.165     0.200
    38.470     2.622     0.200
    38.817     1.441     0.200
    38.966     0.793     0.200
    39.121     0.030     0.200
    39.270     0.085     0.200
    39.270    -0.515     0.200
    39.420    -0.853     0.200
    39.715     2.810     0.200
    39.860     0.161     0.200
    39.923     1.051     0.200
    40.005     0.181     0.200
    40.217    -0.157     0.200
    40.217     0.554     0.200
    40.740    -0.793     0.200
    40.740    -0.363     0.200
    40.844    -0.202     0.200
    40.849     1.817     0.200
    40.849     1.119     0.200
    41.024     1.405     0.200
    41.024     1.979     0.200
    41.299    -1.715     0.200
    41.373     0.176     0.200
    41.423    -0.002     0.200
    41.488    -1.426     0.200
    41.564     1.713     0.200
    41.912     0.270     0.200
    42.095    -0.089     0.200
    42.095    -0.468     0.200
    42.263     0.702     0.200
    42.283     0.265     0.200
    42.302    -1.576     0.200
    42.437     0.946     0.200
    42.473     0.069     0.200
    42.506    -0.211     0.200
    42.936    -0.204     0.200
    42.992    -1.538     0.200
    42.992    -2.107     0.200
    42.992    -1.568     0.200
    42.996    -1.461     0.200
    43.060     0.308     0.200
    43.073    -0.557     0.200
    43.197    -1.716     0.200
    43.316    -1.182     0.200
    43.482     0.055     0.200
    43.548    -0.197     0.200
    43.579    -1.605     0.200
    43.671     0.414     0.200
    43.781    -0.188     0.200
    43.781    -0.406     0.200
    43.937    -0.268     0.200
    44.134    -1.479     0.200
    44.203    -0.357     0.200
    44.236    -0.203     0.200
    44.324     0.526     0.200
    44.344     1.746     0.200
    44.344     1.483     0.200
    44.432     0.085     0.200
    44.648    -0.078     0.200
    44.648     0.178     0.200
    44.831    -0.882     0.200
    45.001    -2.128     0.200
    45.001    -1.554     0.200
    45.084    -0.083     0.200
    45.171    -0.540     0.200
    45.174    -2.731     0.200
    45.260     0.022     0.200
    45.285     0.971     0.200
    45.295    -0.923     0.200
    45.306    -0.323     0.200
    45.318     1.033     0.200
    45.318     1.412     0.200
    45.689     0.073     0.200
    45.746    -0.875     0.200
    46.024    -0.087     0.200
    46.057    -0.541     0.200
    46.189     1.275     0.200
    46.189     1.593     0.200
    46.299     0.515     0.200
    46.412     0.489     0.200
    46.432    -0.039     0.200
    46.572     0.086     0.200
    46.572    -0.154     0.200
    46.583     0.497     0.200
    46.607    -1.837     0.200
    46.721     0.232     0.200
    46.721    -0.234     0.200
    46.830    -0.069     0.200
    46.836     0.370     0.200
    46.896     0.683     0.200
    46.896     1.052     0.200
    47.015    -0.353     0.200
    47.015     0.463     0.200
    47.061    -0.062     0.200
    47.143    -0.161     0.200
    47.196     0.129     0.200
    47.313    -0.395     0.200
    47.326    -0.404     0.200
    47.443     0.321     0.200
    47.453    -0.365     0.200
    47.491    -0.599     0.200
    47.491    -0.900     0.200
    47.491    -1.028     0.200
    47.669    -0.055     0.200
    47.750     1.999     0.200
    47.750     2.130     0.200
    47.771     0.186     0.200
    47.745    -0.265     0.200
    48.024    -0.217     0.200
    48.060    -0.288     0.200
    48.203    -0.702     0.200
    48.466    -0.394     0.200
    48.528     0.506     0.200
    48.666     0.689     0.200
    48.717     0.041     0.200
    48.731     0.502     0.200
    48.917     0.445     0.200
    49.162     1.514     0.200
    49.138    -0.870     0.200
    49.138    -1.111     0.200
    49.138    -0.470     0.200
    49.137    -1.368     0.200
    49.137    -1.069     0.200
    49.137    -0.825     0.200
    49.392     0.038     0.200
    49.531    -0.171     0.200
    49.550    -0.309     0.200
    49.626     0.237     0.200
    49.847     0.458     0.200
    49.970    -0.121     0.200
    50.021     0.069     0.200
    50.114    -1.391     0.200
    50.456     0.079     0.200
    50.712    -2.099     0.200
    50.825     0.544     0.200
    51.142     0.614     0.200
    51.370     0.037     0.200
    51.607    -1.220     0.200
    51.632    -1.841     0.200
    51.846    -1.863     0.200
    51.846    -1.892     0.200
    52.342    -1.687     0.200
    52.851    -1.379     0.200
    53.146    -1.196     0.200
    53.392    -1.612     0.200
    53.392    -1.423     0.200
    53.694    -1.381     0.200
    53.689     0.068     0.200
    53.727    -0.714     0.200
    54.325    -0.419     0.200
    54.444    -0.978     0.200
    54.537    -1.265     0.200
    54.815    -0.675     0.200
    54.815    -1.276     0.200
    54.851    -2.250     0.200
    55.365    -1.034     0.200
    55.365    -1.165     0.200
    55.365    -0.834     0.200
    55.575    -1.242     0.200
    55.663    -0.473     0.200
    55.663    -0.772     0.200
    56.317    -1.037     0.200
    56.939    -0.254     0.200
    57.876    -0.872     0.200
    58.206    -0.640     0.200
    58.423    -1.374     0.200
    58.423    -1.624     0.200
    58.423    -1.374     0.200
    58.537    -0.988     0.200
    58.939     2.340     0.200
    58.973    -4.193     0.200
    59.063    -1.226     0.200
    59.114    -0.957     0.200
    59.673    -0.569     0.200
    59.713    -1.699     0.200
    59.713    -1.574     0.200
    59.976    -1.453     0.200
    59.976    -1.613     0.200
    60.041    -1.028     0.200
    60.038    -1.326     0.200
    60.209    -2.895     0.200
    60.229    -1.035     0.200
    60.319    -1.368     0.200
    60.389    -0.917     0.200
    60.850    -0.863     0.200
    60.945    -0.409     0.200
    60.945    -0.970     0.200
    60.945    -0.819     0.200
    61.105    -1.177     0.200
    61.187    -0.972     0.200
    61.317    -1.255     0.200
    61.582    -1.836     0.200
    61.639    -0.996     0.200
    61.957    -0.181     0.200
    61.957    -0.533     0.200
    61.996    -1.518     0.200
    62.198    -0.727     0.200
    62.376    -1.934     0.200
    62.376    -1.793     0.200
    62.620    -0.811     0.200
    62.683    -0.891     0.200
    63.092    -1.797     0.200
    63.092    -1.476     0.200
    63.162    -1.858     0.200
    63.162    -1.579     0.200
    63.167    -1.712     0.200
    63.201    -1.892     0.200
    63.596    -0.628     0.200
    63.734    -0.955     0.200
    63.976     0.145     0.200
    64.455    -2.616     0.200
    65.313     1.144     0.200
    65.286    -1.162     0.200
    65.462    -1.901     0.200
    65.462    -2.152     0.200
    65.462    -2.001     0.200
    65.550    -1.815     0.200
    65.689    -1.766     0.200
    65.902    -0.882     0.200
    65.964    -1.032     0.200
    66.099    -1.397     0.200
    66.099    -1.666     0.200
    66.247     5.156     0.200
    66.314    -0.772     0.200
    66.539    -0.881     0.200
    66.687    -0.852     0.200
    66.945    -0.596     0.200
    67.379    -1.392     0.200
    67.379    -1.742     0.200
    67.379    -1.253     0.200
    67.865    -1.905     0.200
    68.215    -1.948     0.200
    68.214    -1.494     0.200
    68.729     0.405     0.200
    68.779    -0.341     0.200
    68.980     0.327     0.200
    68.982    -2.056     0.200
    68.982    -1.915     0.200
    69.404    -0.101     0.200
    69.437    -0.330     0.200
    69.475    -0.038     0.200
    69.494    -0.022     0.200
    69.507    -0.623     0.200
    69.530    -0.573     0.200
    69.535    -0.217     0.200
    69.572    -0.251     0.200
    69.750     0.493     0.200
    69.778    -0.519     0.200
    69.921     0.005     0.200
    70.018    -0.592     0.200
    70.018    -0.176     0.200
    70.036    -0.075     0.200
    70.117    -0.122     0.200
    70.096    -0.943     0.200
    70.225    -0.128     0.200
    70.246    -0.094     0.200
    70.297    -0.070     0.200
    70.379     0.990     0.200
    70.382     0.048     0.200
    70.411    -0.063     0.200
    70.462     0.194     0.200
    70.462     0.024     0.200
    70.483    -0.108     0.200
    70.504    -0.034     0.200
    70.522     0.056     0.200
    70.539    -0.047     0.200
    70.555     0.708     0.200
    70.717     0.072     0.200
    70.742    -1.531     0.200
    70.742    -1.381     0.200
    70.742    -1.782     0.200
    70.940     0.247     0.200
    70.945    -0.413     0.200
    70.962     0.150     0.200
    71.022    -0.176     0.200
    71.023    -0.504     0.200
    71.049    -0.611     0.200
    71.049    -1.043     0.200
    71.032    -0.817     0.200
    71.260    -0.815     0.200
    71.312    -0.933     0.200
    71.343    -0.119     0.200
    71.368    -0.590     0.200
    71.428     0.081     0.200
    71.596    -0.740     0.200
    71.610    -0.685     0.200
    71.610    -0.906     0.200
    71.610    -1.025     0.200
    71.716    -0.064     0.200
    71.716     0.137     0.200
    71.750    -0.332     0.200
    71.773    -0.504     0.200
    71.798    -0.494     0.200
    71.934    -0.337     0.200
    71.966    -0.186     0.200
    71.966     0.009     0.200
    72.005    -0.591     0.200
    72.010     0.081     0.200
    72.010    -0.626     0.200
    72.087    -0.182     0.200
    72.100     0.338     0.200
    72.290     0.604     0.200
    72.309     0.028     0.200
    72.406    -1.390     0.200
    72.434     0.248     0.200
    72.436    -0.266     0.200
    72.613     0.381     0.200
    72.619     0.148     0.200
    72.722    -0.265     0.200
    72.749     0.175     0.200
    72.811     0.231     0.200
    72.814    -0.012     0.200
    72.914    -0.205     0.200
    73.028     0.061     0.200
    73.047     0.591     0.200
    73.094     0.130     0.200
    73.150     0.365     0.200
    73.249    -0.024     0.200
    73.318    -1.485     0.200
    73.351    -0.507     0.200
    73.353     0.249     0.200
    73.383     0.249     0.200
    73.384     0.384     0.200
    73.388     0.609     0.200
    73.530     0.238     0.200
    73.729    -0.407     0.200
    73.731     0.582     0.200
    73.743    -0.068     0.200
    73.817     0.241     0.200
    73.823    -0.343     0.200
    73.917     0.503     0.200
    73.982     0.621     0.200
    74.016     2.424     0.200
    74.171    -0.181     0.200
    74.273     0.341     0.200
    74.337     0.170     0.200
    74.401    -0.013     0.200
    74.408     0.443     0.200
    74.529     0.541     0.200
    74.532    -0.526     0.200
    74.532    -2.374     0.200
    74.589    -0.360     0.200
    74.941    -1.134     0.200
    74.977     0.749     0.200
    75.076    -0.472     0.200
    75.141    -0.293     0.200
    75.192     1.016     0.200
    75.271    -0.469     0.200
    75.358    -1.336     0.200
    75.473     0.075     0.200
    75.587    -0.699     0.200
    75.587    -0.949     0.200
    75.602    -0.448     0.200
    75.604     0.255     0.200
    75.608    -0.868     0.200
    75.696     0.430     0.200
    75.724    -0.677     0.200
    75.956     0.238     0.200
    75.956    -0.057     0.200
    75.961    -1.053     0.200
    75.988    -0.436     0.200
    75.998    -0.507     0.200
    76.060    -0.242     0.200
    76.101    -1.100     0.200
    76.240     0.332     0.200
    76.264    -0.657     0.200
    76.277    -0.861     0.200
    76.466     0.653     0.200
    76.488    -0.924     0.200
    76.562    -0.578     0.200
    76.597    -0.857     0.200
    76.731    -0.217     0.200
    76.735    -0.611     0.200
    76.735    -0.866     0.200
    76.735    -0.995     0.200
    76.765    -0.764     0.200
    76.821    -1.091     0.200
    76.848     0.796     0.200
    76.938    -0.784     0.200
    77.133    -0.399     0.200
    77.220    13.784     0.200
    77.252     0.630     0.200
    77.339     0.135     0.200
    77.396     0.226     0.200
    77.635    -0.162     0.200
    77.706    -0.892     0.200
    77.762    -1.812     0.200
    77.772    -0.669     0.200
    78.020    -0.359     0.200
    78.180    -1.432     0.200
    78.224    -1.473     0.200
    78.236    -1.269     0.200
    78.255    -0.348     0.200
    78.343    -0.034     0.200
    78.570    -0.982     0.200
    78.799    -0.944     0.200
    78.799    -1.244     0.200
    78.785     0.633     0.200
    78.791    -0.610     0.200
    78.848     0.422     0.200
    78.853    -0.207     0.200
    78.887     0.407     0.200
    78.916    -1.381     0.200
    78.985    -1.262     0.200
    79.355    -0.369     0.200
    79.442    -0.192     0.200
    79.493     0.278     0.200
    79.519     0.326     0.200
    79.519    -0.775     0.200
    79.585    -0.630     0.200
    79.640     0.872     0.200
    79.661    -1.374     0.200
    79.739    -0.365     0.200
    79.789    -0.533     0.200
    79.815    -0.476     0.200
    80.047    -0.792     0.200
    80.068    -1.022     0.200
    80.185    -0.071     0.200
    80.217    -1.433     0.200
    80.217    -0.726     0.200
    80.271     0.166     0.200
    80.505    -0.230     0.200
    80.735    -0.319     0.200
    80.935    -0.328     0.200
    80.970    -0.174     0.200
    81.070     0.295     0.200
    81.330    -1.683     0.200
    81.299    -0.519     0.200
    81.314    -0.300     0.200
    81.379     0.255     0.200
    81.376    -0.524     0.200
    81.422    -1.650     0.200
    81.404    -0.077     0.200
    81.458    -0.462     0.200
    81.459    -0.565     0.200
    81.486    -0.711     0.200
    81.543    -0.757     0.200
    81.538    -0.483     0.200
    81.544    -0.116     0.200
    81.596    -0.687     0.200
    81.596    -0.589     0.200
    81.596    -0.740     0.200
    81.924    -0.513     0.200
    81.986    -0.440     0.200
    82.279     0.170     0.200
    82.354    -0.301     0.200
    83.267    -1.897     0.200
    83.576    -1.082     0.200
    83.576    -1.082     0.200
    83.576    -0.941     0.200
    83.671    -0.669     0.200
    84.500    -1.079     0.200
    87.374    -0.974     0.200
    88.971    15.846     0.200
    89.707     1.039     0.200
    93.212    -0.731     0.200
    94.006    -1.380     0.200
    95.684    15.283     0.200
    95.819    14.380     0.200
    98.553    -1.813     0.200
    19.623    -1.418     0.200
    19.232    -0.820     0.200
    55.788    -0.510     0.200
    60.592    -1.870     0.200
    26.916    -0.848     0.200
    45.052     2.797     0.200
    55.859     0.295     0.200
    66.346    -0.225     0.200
    83.179     0.152     0.200
    20.282    -0.647     0.200
    30.623     0.486     0.200
    45.198     1.039     0.200
    19.788     0.048     0.200
    31.471     1.617     0.200
    55.575    -1.196     0.200
    83.243    -0.899     0.200
    20.294     0.824     0.200
    21.999     1.331     0.200
    22.723     1.613     0.200
    22.816    -1.690     0.200
    22.901     0.777     0.200
    22.981     0.871     0.200
    23.211    -0.604     0.200
    23.274     1.677     0.200
    23.339    -0.359     0.200
    24.181    -0.290     0.200
    24.527     2.163     0.200
    27.482    -2.652     0.200
    28.037    -1.415     0.200
    28.037    -2.165     0.200
    29.140     1.741     0.200
    29.238     1.704     0.200
    29.238     1.274     0.200
    30.842     1.514     0.200
    33.024     0.853     0.200
    33.024     0.713     0.200
    33.221     0.320     0.200
    33.359     0.102     0.200
    33.849    -0.181     0.200
    33.905     0.961     0.200
    33.905     0.801     0.200
    34.155    -0.029     0.200
    34.385    -2.329     0.200
    34.385    -1.189     0.200
    35.010    -0.626     0.200
    37.393    -0.317     0.200
    37.584     0.783     0.200
    37.584    -0.654     0.200
    39.939     0.256     0.200
    40.597     0.260     0.200
    40.972    -0.040     0.200
    41.167     2.135     0.200
    42.748     0.084     0.200
    43.495    -0.067     0.200
    43.563    -1.121     0.200
    43.740     0.530     0.200
    43.740     0.021     0.200
    43.934     2.184     0.200
    43.934     1.869     0.200
    45.476     0.483     0.200
    45.707     0.034     0.200
    45.889    -0.618     0.200
    46.850    -1.203     0.200
    47.098    -1.364     0.200
    47.098    -1.639     0.200
    47.510     0.426     0.200
    47.510    -0.776     0.200
    47.817    -0.852     0.200
    48.138    -1.127     0.200
    48.845     0.320     0.200
    48.987    -0.987     0.200
    48.986    -1.837     0.200
    49.635    -1.447     0.200
    49.725    -1.428     0.200
    49.967    -0.926     0.200
    50.254    -1.641     0.200
    51.826    -0.741     0.200
    53.961    -0.989     0.200
    53.962    -1.159     0.200
    54.363    -1.341     0.200
    55.295    -0.414     0.200
    56.550    -0.345     0.200
    56.863    -0.530     0.200
    58.147    -0.959     0.200
    59.791    -0.387     0.200
    60.235    -0.830     0.200
    60.235    -0.930     0.200
    60.235    -0.590     0.200
    60.883     0.046     0.200
    62.257    -0.328     0.200
    62.257    -0.179     0.200
    62.491    -0.274     0.200
    62.492    -0.950     0.200
    62.873    -2.142     0.200
    64.236    -0.746     0.200
    64.623    -0.966     0.200
    64.962    -0.650     0.200
    65.210    -0.639     0.200
    65.737     0.064     0.200
    66.427    -1.542     0.200
    66.788    -0.177     0.200
    67.195    -0.833     0.200
    67.195    -0.783     0.200
    67.289    -0.772     0.200
    67.357    -1.221     0.200
    67.802     2.225     0.200
    68.426     0.019     0.200
    68.557    -1.388     0.200
    69.053    -0.995     0.200
    69.454    -2.891     0.200
    70.069    -0.218     0.200
    71.156    -0.577     0.200
    71.338    -0.036     0.200
    71.348    -1.107     0.200
    71.417    -0.534     0.200
    71.536    -0.980     0.200
    71.729    -0.987     0.200
    71.793     0.193     0.200
    72.051    -0.085     0.200
    72.151    -0.048     0.200
    72.088    -0.256     0.200
    72.561     0.424     0.200
    72.669    -0.539     0.200
    72.767     0.320     0.200
    72.840     0.526     0.200
    72.877     0.266     0.200
    72.954     0.429     0.200
    73.040     0.522     0.200
    73.047     0.581     0.200
    73.066     0.470     0.200
    73.116     0.002     0.200
    73.244    -1.407     0.200
    73.260     0.724     0.200
    73.447    -0.501     0.200
    73.489     0.373     0.200
    73.564     0.232     0.200
    73.651     0.540     0.200
    74.157     1.096     0.200
    74.188    -0.582     0.200
    74.236    -0.385     0.200
    74.251    -0.289     0.200
    74.260     0.557     0.200
    74.279     0.165     0.200
    74.336     0.215     0.200
    74.409     0.471     0.200
    74.547    -0.114     0.200
    74.554     0.045     0.200
    74.554     0.295     0.200
    74.631     0.303     0.200
    74.638     1.658     0.200
    74.831     0.939     0.200
    74.965     1.068     0.200
    74.970     0.240     0.200
    75.254     0.349     0.200
    75.261     0.258     0.200
    75.456     0.437     0.200
    75.590     0.134     0.200
    75.638     0.755     0.200
    75.693     0.320     0.200
    75.778     3.399     0.200
    75.791     0.586     0.200
    75.849     0.663     0.200
    75.888    -0.589     0.200
    75.896     0.765     0.200
    75.925     0.905     0.200
    75.927     0.937     0.200
    76.071     0.849     0.200
    76.138     0.641     0.200
    76.275     1.126     0.200
    76.286     0.643     0.200
    76.314    -0.568     0.200
    76.344     0.143     0.200
    76.525     0.664     0.200
    76.817     0.768     0.200
    76.945     0.568     0.200
    77.026     0.190     0.200
    77.119    -0.185     0.200
    77.322    -0.595     0.200
    77.524     0.653     0.200
    77.868     0.557     0.200
    78.116    -0.010     0.200
    78.121     0.728     0.200
    78.258    -0.146     0.200
    78.295     1.042     0.200
    78.438     0.248     0.200
    78.407     1.323     0.200
    78.488    -0.897     0.200
    78.639    -1.031     0.200
    78.677     1.331     0.200
    78.783    -1.028     0.200
    78.893     0.946     0.200
    79.095     0.154     0.200
    79.102     0.065     0.200
    79.118     0.274     0.200
    79.118    -0.390     0.200
    79.273    -0.214     0.200
    79.277     1.140     0.200
    79.318    -0.358     0.200
    79.369     0.938     0.200
    79.500    -0.049     0.200
    79.823     0.569     0.200
    80.240    -0.739     0.200
    80.802     0.299     0.200
    81.330    -1.600     0.200
    81.509     0.641     0.200
    82.010    -0.021     0.200
    82.060    -1.120     0.200
    82.054     0.753     0.200
    82.341    -0.261     0.200
    82.341    -0.455     0.200
    82.562    -1.000     0.200
    83.246     0.695     0.200
    83.549    -0.027     0.200
    83.970    -1.643     0.200
    84.063     0.124     0.200
    84.271    -0.732     0.200
    84.271    -0.873     0.200
    84.404    -0.417     0.200
    97.132    -2.687     0.200
    20.305     0.009     0.200
    28.025    -2.131     0.200
    29.249     1.427     0.200
    30.854     1.481     0.200
    32.643     0.572     0.200
    32.854     1.111     0.200
    33.036     1.052     0.200
    33.233     0.364     0.200
    33.918     0.085     0.200
    35.022     0.678     0.200
    38.377     0.397     0.200
    40.610     0.885     0.200
    41.871     0.557     0.200
    43.576    -0.993     0.200
    43.788    -2.022     0.200
    43.745    -0.237     0.200
    43.947     0.305     0.200
    44.243    -1.045     0.200
    44.222     0.041     0.200
    45.132     0.357     0.200
    45.311    -1.352     0.200
    45.523    -0.247     0.200
    45.523    -0.292     0.200
    45.717     0.148     0.200
    46.129    -0.442     0.200
    47.093    -0.901     0.200
    51.839    -0.513     0.200
    53.234    -0.609     0.200
    53.949    -1.095     0.200
    54.140    -0.185     0.200
    54.261     0.613     0.200
    54.363    -0.482     0.200
    54.363    -0.487     0.200
    54.866    -0.529     0.200
    55.284    -0.428     0.200
    55.393    -0.190     0.200
    55.686    -0.241     0.200
    56.234    -0.164     0.200
    56.853    -2.352     0.200
    56.853    -1.921     0.200
    57.393    -1.056     0.200
    58.862    -0.284     0.200
    59.780    -0.500     0.200
    60.227    -1.539     0.200
    60.227    -0.494     0.200
    60.751     0.757     0.200
    62.259     0.174     0.200
    62.259    -0.076     0.200
    62.492    -0.612     0.200
    62.587    -0.059     0.200
    63.346    -0.606     0.200
    64.619    -1.214     0.200
    64.619    -1.723     0.200
    65.204    -1.244     0.200
    65.991     0.098     0.200
    67.187    -0.641     0.200
    67.187    -0.835     0.200
    67.281    -1.364     0.200
    67.794     1.699     0.200
    69.053    -0.294     0.200
    69.454    -1.350     0.200
    70.215    -0.590     0.200
    70.422    -0.558     0.200
    71.151    -0.535     0.200
    72.053     0.027     0.200
    72.563     0.557     0.200
    72.956     0.644     0.200
    73.049     0.496     0.200
    73.068     0.582     0.200
    73.109    -0.080     0.200
    73.243    -0.905     0.200
    73.261     0.840     0.200
    73.440     0.206     0.200
    73.491     0.288     0.200
    73.565     0.348     0.200
    73.910     0.047     0.200
    73.910    -0.276     0.200
    74.230    -0.840     0.200
    74.230    -0.190     0.200
    74.262     0.071     0.200
    74.262     0.571     0.200
    74.317     0.576     0.200
    74.317     0.197     0.200
    74.317     0.451     0.200
    74.337     1.033     0.200
    74.549     0.203     0.200
    74.556    -0.200     0.200
    74.556     0.485     0.200
    74.556    -0.200     0.200
    74.639     1.177     0.200
    74.833     1.357     0.200
    74.966     0.289     0.200
    75.263     0.478     0.200
    75.292     1.008     0.200
    75.592     0.247     0.200
    75.639     0.761     0.200
    75.770     2.969     0.200
    75.794     0.351     0.200
    75.852     0.734     0.200
    75.898     0.865     0.200
    75.927     0.911     0.200
    75.929     0.966     0.200
    76.127     0.032     0.200
    76.073     0.856     0.200
    76.216     0.375     0.200
    76.277     1.064     0.200
    76.344     0.327     0.200
    76.819     0.878     0.200
    76.947     0.613     0.200
    77.026     0.436     0.200
    77.119    -0.255     0.200
    77.525     0.007     0.200
    78.116     0.444     0.200
    78.121     0.877     0.200
    78.259    -1.444     0.200
    78.474     0.723     0.200
    78.519     0.280     0.200
    78.520     0.914     0.200
    78.783     0.023     0.200
    79.102    -0.059     0.200
    79.115     0.453     0.200
    79.273    -0.568     0.200
    79.315     0.262     0.200
    79.500    -0.096     0.200
    80.241    -0.403     0.200
    80.285    -1.029     0.200
    80.807     0.929     0.200
    80.807    -0.067     0.200
    81.332    -0.209     0.200
    82.336     0.125     0.200
    82.336    -1.665     0.200
    84.062    -0.565     0.200
    84.062     0.363     0.200
    84.259    -0.641     0.200
    87.208     0.497     0.200
    21.037    -0.289     0.200
    26.872    -1.859     0.200
    30.402     2.088     0.200
    31.990     2.334     0.200
    45.102     0.948     0.200
    54.013    -2.064     0.200
    55.761    -1.325     0.200
    59.296    -2.114     0.200
    62.063    -1.384     0.200
    62.137    -1.726     0.200
    72.848    -1.823     0.200
    80.910     0.784     0.200
    81.547     0.564     0.200
    83.110    -1.288     0.200
    14.490     6.702     0.200
    30.067     4.590     0.200
    19.052    -0.124     0.200
    60.614    -1.317     0.200
    65.913    -2.771     0.200
    19.930    -1.300     0.200
    54.741     0.683     0.200
    64.816    -1.114     0.200
    28.449    -1.001     0.200
    57.032     0.503     0.200
    21.389    -0.534     0.200
    27.114    -1.906     0.200
    27.507    -1.136     0.200
    28.928     0.335     0.200
    31.408     2.456     0.200
    34.216    -1.620     0.200
    37.349    -1.659     0.200
    43.331    -1.155     0.200
    44.342    -1.834     0.200
    47.015    -0.630     0.200
    47.015    -0.915     0.200
    54.553    -0.888     0.200
    54.553    -1.411     0.200
    56.505    -0.036     0.200
    56.505    -0.935     0.200
    60.041    -0.459     0.200
    60.041    -0.924     0.200
    62.526    -0.208     0.200
    62.680    -0.821     0.200
    62.680    -2.032     0.200
    64.897    -0.727     0.200
    65.104    -0.545     0.200
    66.974    -2.811     0.200
    66.974    -0.690     0.200
    66.974    -1.823     0.200
    69.630    -1.043     0.200
    71.101    -1.267     0.200
    73.410    -0.902     0.200
    74.827     0.600     0.200
    83.807     0.061     0.200
    30.454     2.194     0.200
    56.301    -0.676     0.200
    59.141    -0.984     0.200
    60.647    -1.604     0.200
    66.174    -1.247     0.200
    18.495    -0.766     0.200
    18.495    -0.914     0.200
    19.428    -0.148     0.200
    19.428     0.055     0.200
    21.316    -0.755     0.200
    28.297    -1.553     0.200
    30.499     1.075     0.200
    30.499     1.192     0.200
    31.803     0.682     0.200
    32.571     0.197     0.200
    32.571     0.588     0.200
    36.923    -0.157     0.200
    41.719    -2.499     0.200
    43.740     0.471     0.200
    44.815    -0.810     0.200
    48.292    -0.972     0.200
    49.045    -0.965     0.200
    49.568    -0.156     0.200
    50.559    -0.621     0.200
    59.788     1.162     0.200
    59.804    -1.202     0.200
    61.160    -0.711     0.200
    61.623    -1.603     0.200
    64.503    -0.161     0.200
    66.804    -1.829     0.200
    66.804    -1.267     0.200
    67.495     2.916     0.200
    71.682    -1.039     0.200
    76.169     1.447     0.200
    19.077    -1.223     0.200
    20.334     0.276     0.200
    20.785    -1.374     0.200
    20.791     0.413     0.200
    22.238     2.328     0.200
    22.526     1.691     0.200
    22.581     0.676     0.200
    23.484     1.582     0.200
    23.834     1.448     0.200
    23.834     0.884     0.200
    24.675     0.263     0.200
    24.697     1.564     0.200
    24.881     1.673     0.200
    25.128     1.050     0.200
    25.263     1.995     0.200
    26.671    -3.295     0.200
    26.828     2.382     0.200
    27.394    -3.574     0.200
    27.620     1.557     0.200
    27.639     1.036     0.200
    27.988     0.767     0.200
    27.988    -0.470     0.200
    28.105    -0.487     0.200
    28.105    -0.347     0.200
    28.276     1.022     0.200
    28.274     0.870     0.200
    28.274     0.171     0.200
    28.443     0.743     0.200
    28.451     0.492     0.200
    29.388     2.603     0.200
    29.399     1.744     0.200
    29.524     2.090     0.200
    29.596     0.964     0.200
    29.789     2.307     0.200
    29.789     0.835     0.200
    29.813     2.336     0.200
    29.813     1.552     0.200
    29.927     2.723     0.200
    29.968     2.632     0.200
    30.005     2.777     0.200
    30.030     0.511     0.200
    30.199     0.939     0.200
    30.253     2.063     0.200
    30.712     1.621     0.200
    30.712     0.568     0.200
    30.758    -0.572     0.200
    30.784     1.232     0.200
    30.986     0.358     0.200
    30.991     2.217     0.200
    31.145     1.295     0.200
    31.223     2.347     0.200
    31.279     1.682     0.200
    31.409     2.009     0.200
    31.409     1.656     0.200
    31.425     1.587     0.200
    31.425     2.124     0.200
    31.486     0.678     0.200
    31.547     1.686     0.200
    31.613     0.313     0.200
    31.629     1.122     0.200
    32.222     1.134     0.200
    32.529     1.217     0.200
    32.604     1.644     0.200
    32.951     1.131     0.200
    33.043     2.535     0.200
    33.055     2.641     0.200
    33.149     1.090     0.200
    33.149     0.586     0.200
    33.160     1.141     0.200
    33.527    -2.574     0.200
    33.433     1.670     0.200
    33.486     2.389     0.200
    33.528     1.376     0.200
    33.528     2.003     0.200
    33.613     1.024     0.200
    33.594     1.526     0.200
    33.630     2.114     0.200
    33.715     1.358     0.200
    33.769     2.049     0.200
    33.802     1.697     0.200
    33.967     1.685     0.200
    33.967     1.330     0.200
    34.139     0.943     0.200
    34.214     0.785     0.200
    34.395    -0.644     0.200
    34.598     1.870     0.200
    34.671     2.031     0.200
    34.685     1.160     0.200
    34.685     1.490     0.200
    34.685     1.689     0.200
    34.692     1.318     0.200
    34.773     1.975     0.200
    34.895     1.291     0.200
    34.959     1.533     0.200
    34.977     1.685     0.200
    35.090     1.691     0.200
    35.144     1.501     0.200
    35.280     2.023     0.200
    35.287     1.707     0.200
    35.357     0.798     0.200
    35.357     0.191     0.200
    35.529     1.992     0.200
    35.547     1.334     0.200
    35.622     1.300     0.200
    35.636     0.296     0.200
    35.743     2.273     0.200
    35.743     1.039     0.200
    35.940     1.492     0.200
    35.964     1.517     0.200
    35.964     1.076     0.200
    36.456     2.248     0.200
    36.471     1.849     0.200
    36.694     1.710     0.200
    36.762     0.875     0.200
    36.901     1.956     0.200
    37.168     0.952     0.200
    37.245     1.425     0.200
    37.744     0.217     0.200
    37.746    -0.547     0.200
    37.822    -0.591     0.200
    37.803     1.996     0.200
    37.829    -0.357     0.200
    37.825    -0.183     0.200
    37.898    -0.257     0.200
    38.201     1.671     0.200
    38.562     0.903     0.200
    38.755     1.868     0.200
    38.755     1.374     0.200
    38.975    -0.296     0.200
    38.917    -0.045     0.200
    39.515     1.962     0.200
    39.667    -1.292     0.200
    39.929     2.003     0.200
    39.929     1.427     0.200
    40.306     1.119     0.200
    41.353     1.872     0.200
    41.461     0.591     0.200
    41.461     1.356     0.200
    41.827    -0.615     0.200
    41.838     2.539     0.200
    41.981     1.861     0.200
    42.155     1.720     0.200
    43.069    -1.434     0.200
    43.029     1.582     0.200
    43.029    -0.094     0.200
    43.199     0.285     0.200
    43.292     0.230     0.200
    43.458    -1.772     0.200
    43.902     0.136     0.200
    43.964    -0.131     0.200
    43.972     0.135     0.200
    43.972    -0.407     0.200
    44.610     1.948     0.200
    44.610     1.329     0.200
    44.692    -0.486     0.200
    45.302    -1.923     0.200
    45.285     0.418     0.200
    45.285     0.134     0.200
    45.492    -0.771     0.200
    45.492    -0.402     0.200
    45.543    -1.243     0.200
    45.693     0.081     0.200
    45.748     1.466     0.200
    45.915     0.144     0.200
    46.003    -0.237     0.200
    46.253    -1.054     0.200
    46.253    -1.304     0.200
    46.418    -1.366     0.200
    46.455     0.150     0.200
    46.701     1.221     0.200
    47.170    -0.425     0.200
    47.258     0.387     0.200
    47.527     0.987     0.200
    47.603    -1.177     0.200
    47.854    -1.072     0.200
    47.959     0.440     0.200
    47.959     0.053     0.200
    48.284     0.434     0.200
    48.301    -0.264     0.200
    48.677     0.589     0.200
    48.803     0.582     0.200
    49.149     0.157     0.200
    49.430     0.767     0.200
    49.689    -1.153     0.200
    49.889    -0.686     0.200
    49.978     0.387     0.200
    50.018    -0.496     0.200
    50.350     0.315     0.200
    50.730    -0.589     0.200
    51.026     0.444     0.200
    52.126    -0.893     0.200
    53.308    -1.257     0.200
    53.665    -2.028     0.200
    55.734    -0.707     0.200
    56.045    -0.736     0.200
    56.045    -0.885     0.200
    58.922    -3.583     0.200
    59.021     0.027     0.200
    59.376    -1.254     0.200
    61.635    -0.323     0.200
    61.635    -0.724     0.200
    61.792    -1.035     0.200
    61.897    -2.789     0.200
    62.068    -0.539     0.200
    62.710    -0.812     0.200
    62.879    -0.146     0.200
    63.145    -0.916     0.200
    63.503    -0.583     0.200
    63.798    -1.607     0.200
    63.798    -1.726     0.200
    64.104    -1.230     0.200
    64.213    -1.204     0.200
    64.360    -1.221     0.200
    64.363    -1.381     0.200
    64.782    -1.266     0.200
    65.621    -1.106     0.200
    65.677    -1.465     0.200
    66.338    -1.509     0.200
    66.338    -1.583     0.200
    66.338    -1.109     0.200
    66.477    -0.900     0.200
    66.953     3.269     0.200
    67.806    -2.121     0.200
    69.419    -1.405     0.200
    69.419    -1.678     0.200
    69.595    -1.287     0.200
    70.319    -1.044     0.200
    70.491    -0.555     0.200
    71.433    -0.768     0.200
    71.938    -0.243     0.200
    71.982     0.315     0.200
    72.019    -0.548     0.200
    72.322     0.886     0.200
    72.379     0.193     0.200
    72.368    -0.170     0.200
    72.428     0.192     0.200
    72.454    -0.083     0.200
    72.527    -1.290     0.200
    72.527    -1.117     0.200
    72.589     0.232     0.200
    72.589     0.107     0.200
    72.589    -0.467     0.200
    72.621    -0.179     0.200
    72.793     0.342     0.200
    72.863    -0.011     0.200
    73.299     0.580     0.200
    73.379    -1.073     0.200
    73.642     0.057     0.200
    73.642     0.596     0.200
    73.688    -0.478     0.200
    73.936     0.325     0.200
    74.008    -0.346     0.200
    74.920     2.959     0.200
    75.005     0.426     0.200
    75.194     0.563     0.200
    75.248     0.708     0.200
    75.325     0.582     0.200
    75.327     0.377     0.200
    75.383     1.097     0.200
    75.477     0.937     0.200
    75.657     0.682     0.200
    75.661     0.873     0.200
    76.191     0.681     0.200
    76.323     0.369     0.200
    77.203     0.871     0.200
    77.707     1.057     0.200
    77.776     0.620     0.200
    77.876     1.518     0.200
    77.988     1.200     0.200
    78.021    -0.326     0.200
    78.252     1.136     0.200
    78.330    -0.095     0.200
    78.478     1.287     0.200
    78.529     0.382     0.200
    78.529    -0.692     0.200
    78.547    -0.496     0.200
    78.860     1.084     0.200
    78.963     1.021     0.200
    79.333    -0.899     0.200
    79.408     0.492     0.200
    80.078    -0.240     0.200
    80.202     0.351     0.200
    80.354     0.826     0.200
    80.420    -0.610     0.200
    80.796     0.907     0.200
    81.153    -0.383     0.200
    81.497    -0.116     0.200
    81.497     0.115     0.200
    81.818     1.092     0.200
    82.406    -0.848     0.200
    83.317    -0.306     0.200
    83.317    -0.057     0.200
    83.317    -0.637     0.200
    83.531    -0.858     0.200
    91.540    -0.711     0.200
    96.989    -2.259     0.200
    20.147     0.346     0.200
    27.380    -1.729     0.200
    30.037     2.437     0.200
    31.419     2.479     0.200
    55.914    -0.699     0.200
    66.147    -0.917     0.200
    72.247    -0.756     0.200
    80.076     0.811     0.200
    18.989    -1.616     0.200
    20.576    -1.040     0.200
    24.585     1.810     0.200
    25.276     1.208     0.200
    26.044    -1.729     0.200
    28.031    -1.330     0.200
    28.494     0.251     0.200
    28.494     0.946     0.200
    30.333     0.895     0.200
    30.562     1.155     0.200
    30.578     2.670     0.200
    31.255    -1.188     0.200
    31.977     1.585     0.200
    31.977     1.693     0.200
    31.977     1.333     0.200
    32.011     2.917     0.200
    32.069     2.384     0.200
    32.159     1.058     0.200
    32.159     3.383     0.200
    32.220     2.417     0.200
    32.653     2.986     0.200
    32.753     2.533     0.200
    32.824     1.324     0.200
    32.837     2.729     0.200
    32.938    -2.855     0.200
    32.938    -1.906     0.200
    33.203     1.617     0.200
    34.041     1.392     0.200
    34.530     2.047     0.200
    34.618    -0.821     0.200
    35.784     0.249     0.200
    35.906     2.201     0.200
    36.215    -1.911     0.200
    36.340     1.661     0.200
    36.544     0.551     0.200
    37.025     2.068     0.200
    38.304     1.337     0.200
    38.437     2.766     0.200
    42.427     2.370     0.200
    42.460    -1.677     0.200
    43.576     1.661     0.200
    44.504    -2.773     0.200
    45.200     0.413     0.200
    45.700    -2.151     0.200
    45.700    -3.007     0.200
    48.441     0.005     0.200
    48.802    -0.668     0.200
    52.729    -0.467     0.200
    53.297    -3.587     0.200
    55.107    -2.287     0.200
    55.418    -0.553     0.200
    55.418    -1.174     0.200
    58.779    -1.473     0.200
    61.339    -2.617     0.200
    61.339    -2.992     0.200
    61.421    -3.023     0.200
    65.733    -2.697     0.200
    65.733    -1.983     0.200
    65.733    -1.588     0.200
    66.336     1.663     0.200
    69.781    -2.647     0.200
    70.130    -0.833     0.200
    71.142    -1.804     0.200
    71.994    -1.679     0.200
    72.137    -2.822     0.200
    72.137    -2.838     0.200
    73.643    -1.458     0.200
    74.317     2.822     0.200
    74.766    -1.784     0.200
    74.920     0.326     0.200
    74.971     0.178     0.200
    75.053     0.079     0.200
    75.206     0.253     0.200
    75.373    -0.393     0.200
    75.635     0.226     0.200
    76.027    -0.951     0.200
    78.057    -0.631     0.200
    80.209     0.566     0.200
    82.895    -0.745     0.200
    82.918    -0.666     0.200
    84.273    -0.232     0.200
    86.226     0.108     0.200
    17.943     0.913     0.200
    18.931    -1.335     0.200
    20.549    -1.236     0.200
    25.994    -1.555     0.200
    26.980    -0.913     0.200
    27.975    -2.163     0.200
    28.506    -0.892     0.200
    30.618     1.938     0.200
    30.909     1.605     0.200
    31.234    -0.237     0.200
    31.231    -0.350     0.200
    31.999     1.244     0.200
    31.999     0.096     0.200
    32.871    -1.782     0.200
    34.054     0.958     0.200
    34.094     0.519     0.200
    34.554     0.670     0.200
    34.554    -0.072     0.200
    35.562     0.668     0.200
    45.232     1.360     0.200
    55.366    -0.668     0.200
    55.366    -0.969     0.200
    58.357     0.005     0.200
    58.714    -1.634     0.200
    61.349    -3.633     0.200
    65.210    -2.269     0.200
    65.669    -2.211     0.200
    66.275     2.459     0.200
    69.709    -2.046     0.200
    72.064    -2.898     0.200
    73.573    -1.633     0.200
    74.723     0.375     0.200
    80.147    -0.233     0.200
    80.147     0.118     0.200
    82.878    -1.088     0.200
    17.685     0.393     0.200
    18.875    -2.568     0.200
    19.729    -0.030     0.200
    19.729    -1.260     0.200
    20.113    -1.702     0.200
    28.251    -2.208     0.200
    43.449    -1.806     0.200
    43.754     2.868     0.200
    46.786    -0.893     0.200
    56.828    -0.157     0.200
    60.021    -0.917     0.200
    61.705    -0.891     0.200
    61.705    -1.117     0.200
    61.983    -0.512     0.200
    64.839    -0.627     0.200
    64.922    -0.607     0.200
    67.007    -0.639     0.200
    72.747    -1.201     0.200
    80.200     1.223     0.200
    18.799    -0.429     0.200
    19.671     0.222     0.200
    21.451    -0.443     0.200
    22.514    -1.143     0.200
    22.969     1.608     0.200
    22.969     0.740     0.200
    23.244    -2.171     0.200
    23.661     0.640     0.200
    23.826     1.358     0.200
    24.273    -0.159     0.200
    24.368     0.719     0.200
    24.435     1.295     0.200
    24.612    -1.103     0.200
    25.555     0.591     0.200
    27.131     0.016     0.200
    27.441    -2.415     0.200
    27.441    -2.313     0.200
    27.411     2.251     0.200
    27.578     1.852     0.200
    27.787    -1.653     0.200
    27.787    -0.211     0.200
    27.787    -2.313     0.200
    27.798    -0.134     0.200
    27.798    -2.181     0.200
    28.256    -2.775     0.200
    28.256    -2.595     0.200
    28.256    -2.720     0.200
    28.256    -2.326     0.200
    28.924     2.682     0.200
    28.959     2.053     0.200
    29.136     1.862     0.200
    29.152    -1.891     0.200
    29.152    -1.012     0.200
    29.152    -0.462     0.200
    29.175    -1.436     0.200
    29.166     2.118     0.200
    29.496     2.596     0.200
    29.856     1.432     0.200
    29.915     1.773     0.200
    30.322    -3.026     0.200
    30.391    -0.894     0.200
    30.565     1.650     0.200
    30.560     0.863     0.200
    30.560     0.368     0.200
    30.560     1.618     0.200
    30.718     2.375     0.200
    30.795     1.935     0.200
    30.806     1.807     0.200
    31.229     1.709     0.200
    31.237     1.925     0.200
    31.382     2.026     0.200
    31.399     1.843     0.200
    31.499     0.914     0.200
    31.642     1.036     0.200
    31.767     1.245     0.200
    31.967     0.689     0.200
    32.047     0.697     0.200
    32.099     0.571     0.200
    32.121     1.455     0.200
    32.336     1.121     0.200
    32.285     1.268     0.200
    32.447     1.248     0.200
    32.585     1.911     0.200
    32.568     0.150     0.200
    32.663     1.337     0.200
    32.718     0.696     0.200
    32.669     0.292     0.200
    32.669     1.807     0.200
    32.669     1.917     0.200
    32.781     1.579     0.200
    32.779     0.326     0.200
    32.945     1.116     0.200
    33.108     1.248     0.200
    33.103     0.868     0.200
    33.103     1.376     0.200
    33.312     1.444     0.200
    33.395     1.138     0.200
    33.524     0.899     0.200
    33.410     0.449     0.200
    33.776     1.110     0.200
    33.841     1.433     0.200
    33.868     1.118     0.200
    33.806     1.348     0.200
    33.875     1.115     0.200
    34.068     1.718     0.200
    34.150     1.687     0.200
    34.321     0.994     0.200
    34.448     1.429     0.200
    34.473     0.559     0.200
    34.538    -0.418     0.200
    34.730     1.116     0.200
    34.757     1.000     0.200
    34.822     1.344     0.200
    34.895     1.962     0.200
    35.116     0.993     0.200
    35.104     1.125     0.200
    35.241     1.162     0.200
    35.593     1.684     0.200
    35.606     1.780     0.200
    35.649     0.140     0.200
    35.899     1.743     0.200
    36.049     1.500     0.200
    36.996     1.723     0.200
    36.999    -1.093     0.200
    36.938     1.976     0.200
    36.938     1.843     0.200
    37.061    -4.880     0.200
    37.092    -0.237     0.200
    37.092     0.427     0.200
    37.092     0.232     0.200
    37.343    -1.279     0.200
    37.337     1.891     0.200
    37.293     0.786     0.200
    37.570    -2.034     0.200
    37.570    -2.843     0.200
    37.570    -2.702     0.200
    37.723     1.428     0.200
    37.559    -0.807     0.200
    37.560    -0.266     0.200
    37.703     1.587     0.200
    37.896     1.393     0.200
    37.896     1.702     0.200
    37.888     0.173     0.200
    38.090     0.857     0.200
    38.323     1.828     0.200
    38.323     2.055     0.200
    38.294     0.445     0.200
    38.406     1.853     0.200
    38.707    -1.484     0.200
    38.652     1.613     0.200
    39.078     2.421     0.200
    39.078     2.148     0.200
    39.197     0.294     0.200
    39.453     2.503     0.200
    39.468     0.390     0.200
    39.658    -0.534     0.200
    39.658    -1.331     0.200
    39.651    -1.414     0.200
    40.063     1.199     0.200
    40.157     1.247     0.200
    40.102     2.012     0.200
    40.488     1.672     0.200
    40.488     1.437     0.200
    40.588    -2.248     0.200
    40.471    -0.015     0.200
    40.598     1.243     0.200
    40.598     0.684     0.200
    40.983     1.795     0.200
    40.983     1.498     0.200
    41.297     0.626     0.200
    41.583    -2.508     0.200
    41.471    -0.015     0.200
    41.471     0.293     0.200
    41.784     0.493     0.200
    42.164     1.423     0.200
    42.164     1.228     0.200
    42.177     0.113     0.200
    42.350    -0.155     0.200
    42.700    -2.382     0.200
    42.700    -0.839     0.200
    42.700    -1.542     0.200
    42.699    -0.634     0.200
    42.916     0.383     0.200
    42.966    -1.211     0.200
    43.111    -0.923     0.200
    43.134    -0.510     0.200
    43.244    -2.748     0.200
    43.062     0.106     0.200
    43.306     0.463     0.200
    43.306     0.709     0.200
    43.295     0.352     0.200
    43.372    -1.309     0.200
    43.528     0.152     0.200
    43.528     0.019     0.200
    43.528     0.461     0.200
    43.755     1.313     0.200
    43.756     1.830     0.200
    43.904    -1.765     0.200
    44.025    -0.126     0.200
    44.025     0.761     0.200
    44.025    -0.598     0.200
    44.129     0.200     0.200
    44.195    -0.389     0.200
    44.744     0.763     0.200
    44.886     0.854     0.200
    44.937    -1.851     0.200
    44.970     0.243     0.200
    44.924    -0.123     0.200
    44.924    -0.591     0.200
    44.981     0.554     0.200
    45.141     0.395     0.200
    45.141     0.657     0.200
    45.069     0.099     0.200
    45.179    -1.386     0.200
    45.184     0.896     0.200
    45.383    -3.266     0.200
    45.205     0.509     0.200
    45.592    -0.649     0.200
    45.836     0.503     0.200
    46.066     3.860     0.200
    46.066    -0.597     0.200
    46.342    -0.980     0.200
    46.432    -2.338     0.200
    46.420    -0.047     0.200
    46.662     1.141     0.200
    46.913    -1.113     0.200
    46.729    -0.943     0.200
    46.807     1.365     0.200
    46.784     0.352     0.200
    47.145    -3.216     0.200
    47.145    -2.619     0.200
    47.145    -3.189     0.200
    47.056     0.193     0.200
    47.048    -0.620     0.200
    47.111    -0.899     0.200
    47.168     0.208     0.200
    47.429     0.168     0.200
    47.446    -0.129     0.200
    47.446     0.605     0.200
    47.452    -0.223     0.200
    47.668     0.017     0.200
    47.723     0.340     0.200
    48.095    -2.896     0.200
    48.095    -1.396     0.200
    47.898    -0.204     0.200
    48.166    -0.146     0.200
    47.951    -1.701     0.200
    48.029    -0.435     0.200
    48.055    -0.888     0.200
    48.209    -0.405     0.200
    48.209     0.865     0.200
    48.430    -1.883     0.200
    48.317    -0.041     0.200
    48.328    -0.904     0.200
    48.328     0.217     0.200
    48.273    -2.015     0.200
    48.273    -0.714     0.200
    48.497    -1.233     0.200
    48.569     0.777     0.200
    48.710    -0.737     0.200
    48.655    -0.285     0.200
    48.785     0.174     0.200
    48.775     0.217     0.200
    48.824    -0.951     0.200
    48.986    -0.155     0.200
    49.287    -1.410     0.200
    49.287    -1.947     0.200
    49.287    -2.964     0.200
    49.287    -0.062     0.200
    49.287    -1.062     0.200
    49.109     0.396     0.200
    49.143    -0.590     0.200
    49.122    -0.035     0.200
    49.165     0.870     0.200
    49.175     0.605     0.200
    49.221    -1.637     0.200
    49.221    -0.582     0.200
    49.207    -1.668     0.200
    49.296    -1.227     0.200
    49.503    -0.148     0.200
    49.576     0.053     0.200
    49.718    -0.252     0.200
    49.695     0.095     0.200
    49.761    -0.666     0.200
    49.775    -0.666     0.200
    49.876    -0.185     0.200
    50.074    -0.032     0.200
    50.190     0.310     0.200
    50.446    -1.499     0.200
    50.446    -0.171     0.200
    50.363    -0.358     0.200
    50.407    -1.191     0.200
    50.819    -0.782     0.200
    50.784    -2.218     0.200
    51.387    -0.561     0.200
    51.671    -2.262     0.200
    52.069    -0.614     0.200
    52.148    -1.421     0.200
    52.645    -1.388     0.200
    53.161    -0.724     0.200
    53.192    -1.759     0.200
    53.741    -0.082     0.200
    53.538    -1.498     0.200
    53.565    -2.685     0.200
    53.663    -0.971     0.200
    53.962    -1.908     0.200
    53.779    -0.964     0.200
    53.779    -0.882     0.200
    53.779    -2.042     0.200
    54.086    -1.059     0.200
    54.132    -2.971     0.200
    54.167    -1.299     0.200
    54.321    -1.394     0.200
    54.321    -0.816     0.200
    54.331    -1.891     0.200
    54.275    -1.413     0.200
    54.797    -0.873     0.200
    54.854    -1.578     0.200
    54.777    -2.467     0.200
    55.241    -0.885     0.200
    55.241    -0.784     0.200
    55.073    -0.295     0.200
    55.342    -0.917     0.200
    55.319    -1.747     0.200
    55.556    -0.553     0.200
    55.827    -1.120     0.200
    55.827    -0.695     0.200
    55.621    -1.927     0.200
    56.154    -1.637     0.200
    56.492    -2.056     0.200
    56.492    -0.443     0.200
    56.800    -0.418     0.200
    56.800    -2.180     0.200
    56.776    -1.877     0.200
    57.295    -0.045     0.200
    58.212    -0.788     0.200
    58.232    -0.726     0.200
    58.238    -1.473     0.200
    59.364    -2.866     0.200
    59.831    -0.518     0.200
    59.783    -1.445     0.200
    59.974    -1.019     0.200
    60.448    -0.925     0.200
    60.687    -1.073     0.200
    60.756    -1.040     0.200
    60.979    -0.956     0.200
    60.870    -3.816     0.200
    61.629    -0.957     0.200
    61.629    -0.106     0.200
    61.857    -0.495     0.200
    61.713    -0.576     0.200
    62.130    -1.603     0.200
    62.130    -0.924     0.200
    61.909    -0.775     0.200
    61.957    -1.989     0.200
    61.957    -0.489     0.200
    62.123    -0.983     0.200
    62.123    -1.085     0.200
    62.251    -1.327     0.200
    62.289    -0.133     0.200
    62.576    -0.117     0.200
    62.723    -0.275     0.200
    63.049    -1.661     0.200
    62.855    -0.822     0.200
    62.855     0.827     0.200
    62.971    -0.153     0.200
    63.035    -0.807     0.200
    63.120    -0.573     0.200
    63.443    -0.974     0.200
    63.458    -0.797     0.200
    63.929    -0.475     0.200
    64.037    -0.511     0.200
    64.123    -0.216     0.200
    64.337    -0.256     0.200
    64.193    -1.679     0.200
    64.193    -1.511     0.200
    64.545    -0.443     0.200
    64.681    -2.786     0.200
    64.616    -1.301     0.200
    64.638    -0.075     0.200
    64.862    -1.556     0.200
    64.862    -1.287     0.200
    64.904    -0.599     0.200
    65.129    -1.471     0.200
    65.292    -0.843     0.200
    65.321    -0.369     0.200
    65.329    -2.407     0.200
    65.519    -0.170     0.200
    65.485    -0.573     0.200
    65.666    -0.377     0.200
    65.753    -1.165     0.200
    66.501    -1.361     0.200
    66.578    -0.757     0.200
    66.372     0.040     0.200
    66.372    -0.327     0.200
    66.678    -1.436     0.200
    66.697    -0.714     0.200
    66.963    -1.215     0.200
    66.963    -1.281     0.200
    66.963    -1.715     0.200
    67.054    -1.229     0.200
    67.039    -1.505     0.200
    67.032    -0.064     0.200
    67.275    -0.789     0.200
    67.170    -0.233     0.200
    67.335    -1.871     0.200
    67.443    -1.124     0.200
    67.630    -0.833     0.200
    67.599    -0.660     0.200
    67.864    -0.414     0.200
    67.646    -2.084     0.200
    67.799    -0.887     0.200
    67.799    -1.309     0.200
    67.835    -0.126     0.200
    68.018    -0.447     0.200
    68.018    -0.810     0.200
    68.059     0.134     0.200
    68.520    -0.925     0.200
    68.472    -0.773     0.200
    68.536    -0.804     0.200
    68.561     0.304     0.200
    68.878     0.276     0.200
    69.209    -0.411     0.200
    69.209    -0.911     0.200
    69.267    -1.271     0.200
    69.311    -0.646     0.200
    69.552    -3.621     0.200
    69.640     0.308     0.200
    69.738    -1.178     0.200
    69.818    -0.504     0.200
    69.792     0.537     0.200
    69.878     0.340     0.200
    69.961     0.184     0.200
    70.239    -0.424     0.200
    70.325     0.051     0.200
    70.376    -2.494     0.200
    70.380     0.068     0.200
    70.633     0.571     0.200
    70.669     0.114     0.200
    70.758    -1.532     0.200
    70.882     0.507     0.200
    71.098    -0.326     0.200
    71.115    -0.734     0.200
    71.134    -0.953     0.200
    71.043     0.229     0.200
    71.245    -0.380     0.200
    71.271    -0.412     0.200
    71.280    -0.790     0.200
    71.285     0.021     0.200
    71.320    -0.010     0.200
    71.445    -0.370     0.200
    71.359     0.243     0.200
    71.563    -2.102     0.200
    71.402     0.056     0.200
    71.409    -0.297     0.200
    71.413    -0.204     0.200
    71.419    -0.335     0.200
    71.552    -0.093     0.200
    71.448    -0.293     0.200
    71.542    -1.669     0.200
    71.527    -0.297     0.200
    71.602     0.200     0.200
    71.624    -0.019     0.200
    71.656    -0.088     0.200
    71.736    -2.244     0.200
    71.900    -0.407     0.200
    71.835     0.366     0.200
    71.835     0.265     0.200
    71.834     0.254     0.200
    71.933     0.598     0.200
    71.933    -0.039     0.200
    71.944     0.097     0.200
    72.046    -0.102     0.200
    72.011     0.195     0.200
    72.146     0.456     0.200
    72.152    -0.037     0.200
    72.155     0.081     0.200
    72.206     0.074     0.200
    72.254     0.241     0.200
    72.264     0.893     0.200
    72.264     0.627     0.200
    72.292     0.159     0.200
    72.398    -0.498     0.200
    72.328     0.813     0.200
    72.372     0.336     0.200
    72.383     0.184     0.200
    72.426     0.126     0.200
    72.432     0.088     0.200
    72.460     0.024     0.200
    72.579    -0.036     0.200
    72.606     0.283     0.200
    72.639     0.359     0.200
    72.644     0.113     0.200
    72.674    -1.021     0.200
    72.674    -2.076     0.200
    72.674    -1.349     0.200
    72.772    -0.031     0.200
    72.786    -0.702     0.200
    72.860    -0.693     0.200
    72.941    -0.685     0.200
    72.845     0.366     0.200
    72.862    -0.063     0.200
    73.021     0.171     0.200
    72.944    -0.354     0.200
    72.956    -2.022     0.200
    72.978    -0.130     0.200
    73.179    -0.203     0.200
    73.269     0.426     0.200
    73.377    -0.083     0.200
    73.292     0.114     0.200
    73.292    -0.011     0.200
    73.545     0.900     0.200
    73.529    -1.203     0.200
    73.527     0.086     0.200
    73.552     0.545     0.200
    73.806    -0.735     0.200
    73.626    -0.179     0.200
    73.629     0.304     0.200
    73.681    -0.132     0.200
    73.681    -1.171     0.200
    73.695     0.646     0.200
    73.695     0.341     0.200
    73.695    -0.081     0.200
    73.720    -0.028     0.200
    73.885     0.454     0.200
    73.802     0.343     0.200
    73.894    -1.008     0.200
    73.844     0.446     0.200
    73.844     0.344     0.200
    73.857    -0.047     0.200
    73.924     0.113     0.200
    73.924     0.027     0.200
    73.926    -0.435     0.200
    74.325    -2.362     0.200
    74.002    -0.279     0.200
    74.028     1.570     0.200
    74.214     0.880     0.200
    74.365     1.000     0.200
    74.359     0.172     0.200
    74.542     0.670     0.200
    74.648     0.156     0.200
    74.672     0.418     0.200
    74.709     0.290     0.200
    74.744     0.503     0.200
    74.917    -0.794     0.200
    74.837     0.963     0.200
    74.954    -0.054     0.200
    74.961     0.660     0.200
    75.062    -1.180     0.200
    75.151    -1.169     0.200
    75.211    -0.590     0.200
    75.250    -1.789     0.200
    75.279     0.780     0.200
    75.286    -0.492     0.200
    75.288    -0.496     0.200
    75.430    -0.297     0.200
    75.536     2.936     0.200
    75.570     0.938     0.200
    75.661    -0.405     0.200
    75.727    -1.141     0.200
    75.756    -0.134     0.200
    75.889    -0.007     0.200
    76.202    -1.365     0.200
    76.114    -0.491     0.200
    76.189    -0.402     0.200
    76.238     0.134     0.200
    76.316    -0.205     0.200
    76.520     0.397     0.200
    76.515    -0.197     0.200
    76.648    -0.148     0.200
    76.868    -0.830     0.200
    76.874    -0.250     0.200
    76.909    -0.283     0.200
    77.238     1.491     0.200
    77.283     0.675     0.200
    77.406     0.922     0.200
    77.495    -0.749     0.200
    77.457     1.063     0.200
    77.520     0.473     0.200
    77.535    -0.414     0.200
    77.537     1.095     0.200
    77.537     0.219     0.200
    77.612     1.594     0.200
    77.655    -0.919     0.200
    77.724     1.568     0.200
    77.890     1.315     0.200
    77.890     1.018     0.200
    77.920    -0.043     0.200
    77.993     0.539     0.200
    77.995     0.962     0.200
    78.196    -0.225     0.200
    78.209    -0.562     0.200
    78.244    -3.718     0.200
    78.210     0.772     0.200
    78.286    -1.151     0.200
    78.419     0.442     0.200
    78.492    -0.414     0.200
    78.529    -0.295     0.200
    78.623     0.474     0.200
    78.623    -1.451     0.200
    78.623    -0.311     0.200
    78.595     1.544     0.200
    78.698     0.083     0.200
    78.686     1.242     0.200
    78.825     0.307     0.200
    78.841     0.092     0.200
    78.927    -1.494     0.200
    79.001     2.009     0.200
    79.140     0.950     0.200
    79.318     0.579     0.200
    79.519    -0.021     0.200
    79.641    -1.183     0.200
    79.636    -0.805     0.200
    79.685    -0.888     0.200
    80.123     0.749     0.200
    80.123    -1.513     0.200
    80.510     0.229     0.200
    80.716    -0.587     0.200
    80.826     0.836     0.200
    81.285     0.144     0.200
    81.592    -0.587     0.200
    81.909    -0.404     0.200
    81.965    -0.198     0.200
    82.190    -0.082     0.200
    82.142     0.270     0.200
    82.114     0.278     0.200
    82.280     0.148     0.200
    82.227    -0.074     0.200
    82.312    -0.818     0.200
    82.474    -0.266     0.200
    82.336     0.151     0.200
    82.545    -0.137     0.200
    82.467    -0.630     0.200
    82.467    -1.251     0.200
    82.482    -0.507     0.200
    82.482    -0.328     0.200
    82.622    -0.738     0.200
    82.503    -0.117     0.200
    82.707    -0.783     0.200
    82.673    -0.002     0.200
    82.684    -0.561     0.200
    82.684    -0.561     0.200
    82.731    -0.604     0.200
    82.776    -0.341     0.200
    82.901    -0.689     0.200
    83.222    -1.276     0.200
    83.007    -0.435     0.200
    83.205    -0.759     0.200
    83.251    -0.299     0.200
    83.194    -0.502     0.200
    83.405    -1.594     0.200
    83.468    -0.717     0.200
    83.518    -0.574     0.200
    83.519     0.225     0.200
    83.519    -1.665     0.200
    83.555    -0.760     0.200
    83.664    -0.421     0.200
    83.710    -0.858     0.200
    84.420    -0.977     0.200
    84.163    -0.672     0.200
    84.360    -1.801     0.200
    84.360    -1.172     0.200
    84.360    -1.761     0.200
    84.263    -0.912     0.200
    84.634    -1.161     0.200
    84.675    -0.263     0.200
    84.840     0.006     0.200
    85.232    -0.562     0.200
    85.347    -0.534     0.200
    85.954    -2.850     0.200
    86.084    -0.796     0.200
    86.084    -1.945     0.200
    86.360    -1.153     0.200
    86.380     0.749     0.200
    86.671    -0.483     0.200
    86.520     0.861     0.200
    86.583    -1.752     0.200
    87.054    -0.448     0.200
    87.644     1.867     0.200
    87.870    -0.978     0.200
    88.063     0.095     0.200
    88.063    -2.698     0.200
    89.112     2.246     0.200
    89.464     2.681     0.200
    90.103     0.350     0.200
    90.919    -0.030     0.200
    92.396    -0.617     0.200
    93.643     1.223     0.200
    96.017     1.824     0.200
    96.063    -0.283     0.200
    97.711    -1.349     0.200
    97.748    -1.668     0.200
    19.674    -1.653     0.200
    27.782    -1.071     0.200
    27.782    -0.781     0.200
    30.368     0.921     0.200
    32.596     0.323     0.200
    33.425    -0.816     0.200
    34.066    -1.893     0.200
    35.665     0.519     0.200
    35.900     0.095     0.200
    37.107     0.216     0.200
    37.107     0.365     0.200
    37.311    -0.243     0.200
    37.539    -1.786     0.200
    37.904     0.679     0.200
    38.108     1.693     0.200
    38.570    -0.621     0.200
    38.677     0.975     0.200
    39.475    -0.621     0.200
    39.624    -2.705     0.200
    40.839     0.255     0.200
    41.314     1.345     0.200
    41.493     0.962     0.200
    41.540     0.231     0.200
    42.372     0.417     0.200
    42.388    -0.397     0.200
    42.539    -0.056     0.200
    42.989    -0.876     0.200
    43.043    -0.561     0.200
    43.173    -0.095     0.200
    43.320    -0.708     0.200
    43.347    -2.022     0.200
    43.787    -0.688     0.200
    43.996    -1.383     0.200
    44.154     0.940     0.200
    44.323    -0.472     0.200
    45.070    -0.044     0.200
    45.166     0.081     0.200
    45.188    -2.595     0.200
    46.691    -0.835     0.200
    46.691    -1.080     0.200
    46.801    -0.246     0.200
    47.132     0.864     0.200
    47.150     0.748     0.200
    47.317     0.692     0.200
    47.457     0.046     0.200
    47.469     0.574     0.200
    47.601     1.166     0.200
    47.847     0.265     0.200
    47.880     2.632     0.200
    47.979     0.864     0.200
    48.807     0.466     0.200
    48.845     0.462     0.200
    49.136     0.882     0.200
    49.162     0.673     0.200
    51.406     0.406     0.200
    51.405    -0.595     0.200
    51.518     0.555     0.200
    51.585    -0.493     0.200
    53.749    -2.445     0.200
    54.137     0.090     0.200
    56.763    -0.184     0.200
    56.763    -0.774     0.200
    59.796    -0.200     0.200
    59.935    -1.185     0.200
    59.935    -1.055     0.200
    59.935    -2.145     0.200
    61.602    -0.497     0.200
    61.602    -0.697     0.200
    61.878    -1.361     0.200
    62.090    -2.682     0.200
    63.423    -1.311     0.200
    64.156    -1.173     0.200
    64.156    -1.702     0.200
    64.828    -0.878     0.200
    66.924    -1.755     0.200
    67.592     3.089     0.200
    71.393    -0.887     0.200
    71.906     0.233     0.200
    72.125     0.107     0.200
    72.301     0.261     0.200
    72.355    -0.065     0.200
    72.398     0.078     0.200
    72.611     0.410     0.200
    72.642    -1.150     0.200
    72.916     0.196     0.200
    73.602    -0.022     0.200
    73.602     0.348     0.200
    73.667     0.264     0.200
    73.794    -0.167     0.200
    73.815    -0.498     0.200
    73.897    -0.428     0.200
    73.975    -0.635     0.200
    73.999     1.022     0.200
    74.620    -0.192     0.200
    76.140    -0.353     0.200
    76.168     1.221     0.200
    76.211    -0.116     0.200
    76.749    -1.111     0.200
    76.833     2.551     0.200
    79.364     0.805     0.200
    79.588     0.015     0.200
    80.104    -0.526     0.200
    84.326     0.093     0.200
    18.522    -1.340     0.200
    18.522    -0.598     0.200
    18.596    -0.631     0.200
    18.596    -0.197     0.200
    20.073    -0.744     0.200
    20.073    -0.986     0.200
    22.774     1.049     0.200
    23.367     1.471     0.200
    23.785     2.587     0.200
    23.972     2.401     0.200
    24.016     0.646     0.200
    24.016     1.357     0.200
    24.016     1.505     0.200
    24.340     2.891     0.200
    24.450     2.012     0.200
    25.005     2.701     0.200
    25.215     3.379     0.200
    25.226     2.218     0.200
    25.521     2.500     0.200
    25.642     1.674     0.200
    25.794     1.970     0.200
    25.844     1.451     0.200
    26.598     1.911     0.200
    27.152    -2.391     0.200
    27.561    -2.371     0.200
    27.796     1.786     0.200
    28.097     0.809     0.200
    28.480     1.263     0.200
    28.519     1.909     0.200
    28.519     1.069     0.200
    28.619    -0.434     0.200
    28.817     0.958     0.200
    29.446     0.850     0.200
    29.932     0.312     0.200
    29.955     2.170     0.200
    30.119     2.338     0.200
    30.113     2.545     0.200
    30.120     2.527     0.200
    30.189     1.988     0.200
    30.189     1.269     0.200
    30.337     1.267     0.200
    30.337     1.962     0.200
    30.379     2.743     0.200
    30.408     2.549     0.200
    30.632     2.247     0.200
    30.641     2.840     0.200
    30.755     0.415     0.200
    30.805     0.612     0.200
    30.811     1.490     0.200
    30.811     1.264     0.200
    31.359     2.011     0.200
    31.388     2.240     0.200
    31.627     1.405     0.200
    31.628     1.306     0.200
    31.628     1.626     0.200
    31.628     1.165     0.200
    31.746     1.805     0.200
    31.822     1.372     0.200
    31.922     2.175     0.200
    32.024     2.316     0.200
    32.324     1.902     0.200
    32.445     2.593     0.200
    32.459     2.590     0.200
    32.477     2.304     0.200
    32.581     2.487     0.200
    32.610     1.792     0.200
    32.903    -2.081     0.200
    32.874     2.052     0.200
    32.906     1.919     0.200
    32.983     1.951     0.200
    32.985     2.404     0.200
    33.261     1.771     0.200
    33.320     1.434     0.200
    33.338     2.651     0.200
    33.349     2.601     0.200
    33.393     2.147     0.200
    33.479     1.830     0.200
    33.548     2.055     0.200
    33.584     1.879     0.200
    33.629     1.346     0.200
    33.629     0.728     0.200
    33.627     0.499     0.200
    33.650     1.561     0.200
    33.650     1.881     0.200
    33.754     1.677     0.200
    33.868     1.338     0.200
    33.956     2.085     0.200
    34.003     1.165     0.200
    34.095     2.519     0.200
    34.158     0.466     0.200
    34.156     1.778     0.200
    34.162     2.234     0.200
    34.194     1.680     0.200
    34.194     1.344     0.200
    34.522     1.637     0.200
    34.519     1.349     0.200
    34.626     1.636     0.200
    34.831     1.774     0.200
    34.890     2.232     0.200
    34.990     1.793     0.200
    35.031     1.783     0.200
    35.086     1.628     0.200
    35.086     1.820     0.200
    35.093     1.005     0.200
    35.138     2.238     0.200
    35.231     1.331     0.200
    35.275     2.477     0.200
    35.334     0.531     0.200
    35.334     0.726     0.200
    35.350     1.695     0.200
    35.390     1.751     0.200
    35.533     1.918     0.200
    35.648     2.275     0.200
    35.695     2.113     0.200
    35.825     1.130     0.200
    35.907     2.053     0.200
    36.043     2.114     0.200
    36.065     1.943     0.200
    36.065     2.599     0.200
    36.156     0.797     0.200
    36.233     1.808     0.200
    36.322    -3.274     0.200
    36.500     2.096     0.200
    36.680     2.080     0.200
    36.680     1.818     0.200
    36.699     1.505     0.200
    36.897     2.347     0.200
    37.143    -2.103     0.200
    37.254    -2.646     0.200
    37.208     1.707     0.200
    37.208     1.993     0.200
    37.396     1.883     0.200
    37.561     1.754     0.200
    37.844     0.341     0.200
    37.883    -0.426     0.200
    38.114     0.494     0.200
    38.200     1.965     0.200
    38.200     2.371     0.200
    38.423    -2.644     0.200
    38.915     0.950     0.200
    38.911     2.354     0.200
    38.911     1.823     0.200
    39.558     1.863     0.200
    39.564     2.352     0.200
    39.658     2.544     0.200
    40.242     2.303     0.200
    40.242     1.866     0.200
    41.133    -0.010     0.200
    41.202     0.362     0.200
    41.656    -1.053     0.200
    41.834    -1.018     0.200
    41.869     0.318     0.200
    42.076     0.268     0.200
    42.133     1.588     0.200
    42.133     1.428     0.200
    42.403    -0.399     0.200
    42.600     0.167     0.200
    42.819    -3.412     0.200
    43.065     2.073     0.200
    43.220     0.552     0.200
    43.220     1.251     0.200
    43.266    -0.346     0.200
    43.392    -0.406     0.200
    43.392    -1.746     0.200
    43.596     0.414     0.200
    43.923    -1.453     0.200
    44.000     0.006     0.200
    44.048    -0.871     0.200
    44.171    -2.556     0.200
    44.174    -2.224     0.200
    44.146    -0.355     0.200
    44.170    -3.679     0.200
    44.282    -0.525     0.200
    44.393    -0.117     0.200
    44.470    -0.156     0.200
    44.768    -0.870     0.200
    44.768    -0.651     0.200
    44.935    -2.653     0.200
    44.908     1.166     0.200
    44.951     0.707     0.200
    45.024    -1.781     0.200
    45.022     0.475     0.200
    45.149     0.658     0.200
    45.295    -0.098     0.200
    45.295    -0.715     0.200
    45.340    -0.282     0.200
    45.678    -0.488     0.200
    45.994     0.473     0.200
    45.994     1.015     0.200
    46.041    -0.001     0.200
    46.142    -0.224     0.200
    46.142     0.120     0.200
    46.411    -1.160     0.200
    46.446    -0.241     0.200
    47.579    -2.019     0.200
    47.576    -0.790     0.200
    47.623    -1.036     0.200
    47.623    -1.708     0.200
    47.747    -2.112     0.200
    47.770     0.020     0.200
    47.780    -0.098     0.200
    47.780    -0.227     0.200
    47.822    -0.196     0.200
    47.911     0.265     0.200
    47.929     0.630     0.200
    48.020    -0.002     0.200
    48.056    -1.599     0.200
    48.056    -2.091     0.200
    48.024    -0.170     0.200
    48.024    -0.526     0.200
    48.264    -0.273     0.200
    48.260    -1.443     0.200
    48.261    -1.448     0.200
    48.261    -2.274     0.200
    48.284    -0.238     0.200
    48.288    -0.631     0.200
    48.292    -0.766     0.200
    48.399    -0.019     0.200
    48.399    -0.421     0.200
    48.748    -1.230     0.200
    48.756     0.075     0.200
    48.832    -0.068     0.200
    48.854     0.559     0.200
    48.882     0.153     0.200
    48.978    -0.428     0.200
    49.020     0.156     0.200
    49.156    -0.268     0.200
    49.297    -0.149     0.200
    49.422    -0.810     0.200
    49.513    -0.975     0.200
    49.602    -2.254     0.200
    49.619    -0.271     0.200
    49.641     0.097     0.200
    49.710    -0.744     0.200
    49.726    -0.696     0.200
    49.780    -0.405     0.200
    49.822    -0.285     0.200
    49.942    -0.428     0.200
    49.942    -0.088     0.200
    49.997    -0.074     0.200
    49.997     0.523     0.200
    50.021     0.134     0.200
    50.069     0.282     0.200
    50.118    -0.009     0.200
    50.268    -0.037     0.200
    50.302    -0.313     0.200
    50.323    -0.338     0.200
    50.398    -0.325     0.200
    50.500    -0.261     0.200
    50.502    -0.542     0.200
    50.544    -0.212     0.200
    50.725    -0.129     0.200
    50.818     0.149     0.200
    50.915    -0.249     0.200
    51.047     0.083     0.200
    51.154     0.099     0.200
    51.496    -0.014     0.200
    51.887    -0.074     0.200
    52.233     0.098     0.200
    52.418    -0.980     0.200
    52.434    -0.451     0.200
    52.758    -1.678     0.200
    52.927    -0.399     0.200
    52.935    -0.450     0.200
    52.982    -2.246     0.200
    52.982    -1.714     0.200
    53.045    -1.208     0.200
    54.470    -1.233     0.200
    55.554    -0.952     0.200
    55.554    -1.281     0.200
    58.763    -2.386     0.200
    58.763    -1.828     0.200
    58.763    -2.437     0.200
    60.705    -0.923     0.200
    60.937    -1.512     0.200
    60.969    -1.659     0.200
    60.973    -1.736     0.200
    60.973    -1.536     0.200
    61.108    -1.470     0.200
    61.109    -1.707     0.200
    61.109    -1.527     0.200
    61.142    -1.068     0.200
    63.119    -2.943     0.200
    63.481    -1.777     0.200
    64.863    -0.988     0.200
    65.143    -1.176     0.200
    65.293    -1.438     0.200
    65.740    -2.444     0.200
    65.740    -2.026     0.200
    65.740    -2.394     0.200
    65.833    -2.202     0.200
    66.389     3.211     0.200
    67.057    -1.443     0.200
    67.665    -3.063     0.200
    68.060    -3.164     0.200
    69.649    -2.475     0.200
    70.773    -1.365     0.200
    71.276    -0.372     0.200
    71.568    -0.477     0.200
    71.664    -0.286     0.200
    71.701    -0.608     0.200
    71.742    -0.355     0.200
    71.779    -0.372     0.200
    71.796    -0.474     0.200
    71.840    -2.316     0.200
    71.840    -2.051     0.200
    71.840    -2.301     0.200
    71.922    -2.202     0.200
    71.954    -0.723     0.200
    72.200    -0.792     0.200
    72.227    -0.575     0.200
    72.255    -0.921     0.200
    72.563    -0.256     0.200
    72.594    -0.965     0.200
    72.594    -0.734     0.200
    72.580     0.105     0.200
    72.721    -0.493     0.200
    72.785    -0.313     0.200
    73.102    -0.645     0.200
    73.243    -0.677     0.200
    73.257    -0.422     0.200
    73.275    -0.265     0.200
    73.280    -0.803     0.200
    73.346    -0.681     0.200
    73.936    -0.544     0.200
    73.979    -0.195     0.200
    74.340     0.134     0.200
    74.367    -0.369     0.200
    74.417    -0.265     0.200
    74.477     0.146     0.200
    74.541    -0.072     0.200
    74.595     0.096     0.200
    74.594    -0.162     0.200
    74.671     0.194     0.200
    74.674     0.228     0.200
    74.825     0.162     0.200
    74.938    -1.295     0.200
    74.967    -1.397     0.200
    74.992    -0.006     0.200
    75.003     0.088     0.200
    74.989    -1.349     0.200
    75.099    -0.020     0.200
    75.175     0.227     0.200
    75.261     0.362     0.200
    75.454    -1.071     0.200
    75.472     0.001     0.200
    75.529    -0.050     0.200
    75.581    -1.238     0.200
    75.662    -0.314     0.200
    75.662     1.185     0.200
    75.777    -0.765     0.200
    75.844    -1.571     0.200
    75.879    -1.506     0.200
    76.114    -1.408     0.200
    76.312     0.721     0.200
    76.561    -2.265     0.200
    77.093     0.071     0.200
    77.138     0.636     0.200
    77.241    -0.868     0.200
    77.374    -1.124     0.200
    77.493     0.681     0.200
    77.839    -1.123     0.200
    78.339    -1.373     0.200
    78.373    -1.522     0.200
    78.719    -0.444     0.200
    79.040    -0.470     0.200
    78.994    -0.541     0.200
    79.198    -0.584     0.200
    79.519    -0.292     0.200
    79.766     0.335     0.200
    79.766     0.120     0.200
    79.808     0.798     0.200
    80.081    -0.194     0.200
    80.477    -1.022     0.200
    80.506     0.312     0.200
    80.553    -0.587     0.200
    80.835    -1.092     0.200
    80.951    -1.280     0.200
    82.235    -1.600     0.200
    82.319    -0.864     0.200
    82.529    -0.528     0.200
    82.619    -0.781     0.200
    82.626    -0.884     0.200
    82.627    -0.413     0.200
    82.627    -1.022     0.200
    82.741     0.064     0.200
    83.007     0.623     0.200
    83.109    -0.872     0.200
    83.158    -1.664     0.200
    83.158    -1.113     0.200
    83.158    -1.566     0.200
    83.350    -0.241     0.200
    83.516    -1.393     0.200
    84.420    -0.077     0.200
    84.417     0.110     0.200
    84.669    -0.821     0.200
    85.343    -1.188     0.200
    85.829     0.673     0.200
    85.829    -0.401     0.200
    86.336    -1.630     0.200
    87.386    -0.952     0.200
    97.326    -0.547     0.200
    44.831     2.813     0.200
    56.074    -1.655     0.200
    66.542    -1.302     0.200
    20.895     0.623     0.200
    26.796    -3.000     0.200
    27.257    -1.384     0.200
    27.257     0.006     0.200
    27.257    -2.269     0.200
    29.995     3.239     0.200
    31.627     2.785     0.200
    44.710     2.746     0.200
    46.680    -2.290     0.200
    46.680    -2.996     0.200
    48.200    -1.832     0.200
    49.358    -0.937     0.200
    50.255    -1.697     0.200
    54.273    -1.623     0.200
    56.185    -0.751     0.200
    56.185    -1.156     0.200
    59.703    -1.386     0.200
    59.703    -1.111     0.200
    62.006    -0.353     0.200
    62.275    -0.692     0.200
    62.275    -0.893     0.200
    62.398    -1.416     0.200
    62.399    -1.231     0.200
    64.276    -1.411     0.200
    64.449    -1.293     0.200
    64.558    -1.395     0.200
    64.767    -1.709     0.200
    66.637    -1.718     0.200
    66.637    -1.468     0.200
    66.733    -1.343     0.200
    68.350    -0.605     0.200
    69.346    -0.958     0.200
    70.769    -1.266     0.200
    72.075    -0.249     0.200
    72.921    -0.469     0.200
    73.122    -1.539     0.200
    73.255     0.034     0.200
    74.023     0.027     0.200
    74.283     0.310     0.200
    74.576    -0.696     0.200
    75.641     0.139     0.200
    75.718     1.292     0.200
    75.841     0.294     0.200
    75.905    -0.370     0.200
    75.971     0.446     0.200
    75.974     0.281     0.200
    76.125     0.120     0.200
    76.304     0.448     0.200
    76.830     0.262     0.200
    76.963     0.092     0.200
    79.060     0.151     0.200
    81.022     0.282     0.200
    83.521    -1.205     0.200
    83.891    -0.885     0.200
    17.750    -1.429     0.200
    18.976    -3.158     0.200
    19.433     0.110     0.200
    19.433    -0.210     0.200
    20.911     1.992     0.200
    21.989     2.034     0.200
    23.186     1.929     0.200
    23.775     1.777     0.200
    23.775     0.461     0.200
    25.637     0.778     0.200
    25.752     2.244     0.200
    26.033     2.004     0.200
    26.107    -2.491     0.200
    26.349     0.754     0.200
    26.376     2.431     0.200
    26.790     0.345     0.200
    26.790    -0.987     0.200
    26.915    -1.175     0.200
    26.915    -0.335     0.200
    26.915    -0.835     0.200
    27.366    -1.587     0.200
    27.366    -0.676     0.200
    27.366    -1.856     0.200
    27.366    -2.286     0.200
    27.773     0.860     0.200
    27.927    -0.778     0.200
    27.927    -0.489     0.200
    27.927    -1.817     0.200
    28.107     0.022     0.200
    28.344     1.608     0.200
    28.367     1.452     0.200
    29.509    -1.326     0.200
    29.733     2.708     0.200
    29.917     2.334     0.200
    30.002     1.407     0.200
    30.133     0.526     0.200
    30.315     2.249     0.200
    30.315     1.339     0.200
    30.417     0.816     0.200
    30.417     1.120     0.200
    30.476     1.640     0.200
    30.706     3.023     0.200
    31.402     1.620     0.200
    31.402     1.388     0.200
    31.402     0.747     0.200
    31.455     2.826     0.200
    31.522     1.476     0.200
    31.628     1.932     0.200
    31.681     2.092     0.200
    31.907     2.901     0.200
    32.024     2.233     0.200
    32.053     1.923     0.200
    32.078     2.490     0.200
    32.533    -2.474     0.200
    32.533    -2.052     0.200
    32.474     2.317     0.200
    32.480     1.739     0.200
    32.515     2.687     0.200
    32.572     2.603     0.200
    32.661    -1.505     0.200
    32.611     2.510     0.200
    32.760     1.434     0.200
    32.935     2.395     0.200
    32.995     2.132     0.200
    33.046    -1.237     0.200
    33.046    -3.026     0.200
    33.059     1.235     0.200
    33.059     1.024     0.200
    33.212     1.427     0.200
    33.212     1.193     0.200
    33.235     2.075     0.200
    33.309     2.198     0.200
    33.336     1.216     0.200
    33.336     1.783     0.200
    33.336     1.908     0.200
    33.346     1.604     0.200
    33.345     2.187     0.200
    33.455     1.620     0.200
    33.548     2.318     0.200
    33.673     0.143     0.200
    33.713     2.219     0.200
    33.810     2.133     0.200
    33.852     2.282     0.200
    33.995     1.824     0.200
    34.026     1.916     0.200
    34.032     2.573     0.200
    34.156     2.178     0.200
    34.183     1.488     0.200
    34.352     2.041     0.200
    34.390     1.777     0.200
    34.442    -0.761     0.200
    34.508     2.206     0.200
    34.622     1.481     0.200
    34.687     1.903     0.200
    34.776     1.670     0.200
    34.879     0.149     0.200
    34.879     0.348     0.200
    34.995     1.955     0.200
    35.014     2.122     0.200
    35.104     1.311     0.200
    35.104     1.745     0.200
    35.104     0.921     0.200
    35.104     1.612     0.200
    35.111     1.665     0.200
    35.413     1.981     0.200
    35.535     1.439     0.200
    35.598     1.841     0.200
    35.620     1.847     0.200
    35.722     2.451     0.200
    35.785     0.890     0.200
    35.785     0.550     0.200
    35.945     0.085     0.200
    35.964     1.808     0.200
    35.978     2.340     0.200
    36.067     2.245     0.200
    36.081     1.509     0.200
    36.153    -2.347     0.200
    36.153    -1.429     0.200
    36.153    -1.698     0.200
    36.243     0.360     0.200
    36.375    -1.828     0.200
    36.327     1.958     0.200
    36.481    -1.246     0.200
    36.459     2.259     0.200
    36.517     2.242     0.200
    36.623     1.615     0.200
    36.623     1.271     0.200
    37.103     2.114     0.200
    37.148     0.652     0.200
    37.143     0.963     0.200
    37.143     1.650     0.200
    37.198     2.292     0.200
    37.198     1.968     0.200
    37.360     0.237     0.200
    37.360     0.592     0.200
    37.500     0.109     0.200
    37.651    -1.710     0.200
    37.675     0.453     0.200
    37.731     2.056     0.200
    37.731     1.853     0.200
    38.182     2.041     0.200
    38.204     0.148     0.200
    38.220     2.115     0.200
    38.271    -2.660     0.200
    38.326     1.119     0.200
    38.326     1.252     0.200
    38.477     0.958     0.200
    38.477     0.813     0.200
    38.557    -0.432     0.200
    38.690     0.746     0.200
    38.748    -1.449     0.200
    38.748     0.043     0.200
    38.748    -1.258     0.200
    38.748    -1.109     0.200
    38.861     0.220     0.200
    38.858     1.650     0.200
    38.858     2.095     0.200
    38.879     1.058     0.200
    38.879     1.562     0.200
    38.879     0.894     0.200
    38.879     1.698     0.200
    38.991     0.834     0.200
    39.102    -1.412     0.200
    39.175     0.335     0.200
    39.176     0.708     0.200
    39.201     1.571     0.200
    39.336     2.583     0.200
    39.336     2.580     0.200
    39.385     1.530     0.200
    39.385     1.187     0.200
    39.423     2.220     0.200
    39.443     0.785     0.200
    39.486    -1.611     0.200
    39.790     0.257     0.200
    39.801     0.552     0.200
    39.885    -1.295     0.200
    40.037     0.914     0.200
    40.142     2.419     0.200
    40.142     2.138     0.200
    40.213     0.911     0.200
    40.273     0.303     0.200
    40.529     0.621     0.200
    40.537     0.549     0.200
    40.537     0.838     0.200
    40.563     0.459     0.200
    40.563     0.139     0.200
    40.812     0.553     0.200
    41.062     0.499     0.200
    41.351     0.069     0.200
    41.364     1.608     0.200
    41.391     1.467     0.200
    41.404     0.013     0.200
    41.416     0.419     0.200
    41.497    -0.205     0.200
    41.519     1.324     0.200
    41.519     0.715     0.200
    41.607    -0.056     0.200
    41.601     1.144     0.200
    41.930    -0.733     0.200
    41.931    -0.731     0.200
    41.931    -0.239     0.200
    41.936    -1.095     0.200
    41.936    -0.903     0.200
    41.975    -1.296     0.200
    42.010     1.866     0.200
    42.010     1.682     0.200
    42.065    -2.704     0.200
    42.044     0.051     0.200
    42.083     0.200     0.200
    42.302     0.230     0.200
    42.352    -0.446     0.200
    42.494     0.333     0.200
    42.577    -1.629     0.200
    42.577    -1.418     0.200
    42.577    -2.027     0.200
    42.551    -0.109     0.200
    42.626    -0.227     0.200
    42.626    -1.316     0.200
    42.626    -1.117     0.200
    42.626     0.012     0.200
    42.661    -0.044     0.200
    42.702     0.389     0.200
    42.779    -1.627     0.200
    42.893    -0.097     0.200
    42.984     0.534     0.200
    42.984     0.812     0.200
    42.977     0.817     0.200
    42.977     1.153     0.200
    42.977     0.965     0.200
    43.143     0.210     0.200
    43.202    -3.242     0.200
    43.463    -2.512     0.200
    43.589    -0.141     0.200
    43.585    -1.035     0.200
    43.635     0.333     0.200
    43.635     0.036     0.200
    43.641     0.002     0.200
    43.692    -0.426     0.200
    43.905    -1.934     0.200
    43.915    -2.426     0.200
    43.897     0.719     0.200
    43.955     0.919     0.200
    43.969    -0.129     0.200
    43.992     0.478     0.200
    44.102     0.381     0.200
    44.162    -1.627     0.200
    44.163     0.037     0.200
    44.137     0.010     0.200
    44.185    -2.928     0.200
    44.185     0.970     0.200
    44.185     0.680     0.200
    44.257    -1.269     0.200
    44.315    -2.079     0.200
    44.315    -0.418     0.200
    44.405    -1.072     0.200
    44.405    -0.556     0.200
    44.503    -0.091     0.200
    44.697    -0.789     0.200
    44.788     1.391     0.200
    44.789     0.791     0.200
    44.836    -0.818     0.200
    44.866     0.144     0.200
    44.865     0.452     0.200
    44.868     0.565     0.200
    44.868     0.710     0.200
    44.888    -0.243     0.200
    44.992    -2.252     0.200
    44.945    -0.247     0.200
    45.122    -2.057     0.200
    45.117     0.185     0.200
    45.232    -0.278     0.200
    45.261     0.105     0.200
    45.261     0.374     0.200
    45.261     0.534     0.200
    45.366     0.222     0.200
    45.453     0.469     0.200
    45.552     0.386     0.200
    45.720    -0.163     0.200
    45.791    -0.579     0.200
    45.803    -1.066     0.200
    45.812     0.955     0.200
    45.814     1.050     0.200
    45.814     0.820     0.200
    45.842     0.359     0.200
    45.842     0.152     0.200
    45.947    -1.144     0.200
    45.967    -0.584     0.200
    45.967    -0.901     0.200
    45.987    -0.336     0.200
    46.133    -2.887     0.200
    46.102     0.614     0.200
    46.201    -0.689     0.200
    46.226    -0.263     0.200
    46.275    -1.530     0.200
    46.412    -0.695     0.200
    46.444    -0.589     0.200
    46.605     0.754     0.200
    46.549    -0.376     0.200
    46.600    -0.720     0.200
    46.708     1.221     0.200
    46.708     1.409     0.200
    46.727    -0.762     0.200
    46.727    -1.067     0.200
    46.807    -2.111     0.200
    46.796     0.119     0.200
    46.855    -1.752     0.200
    46.873    -0.285     0.200
    46.925    -0.394     0.200
    46.977    -1.397     0.200
    46.995     0.126     0.200
    47.039    -1.944     0.200
    47.114    -0.005     0.200
    47.126     0.388     0.200
    47.244     0.509     0.200
    47.285    -2.125     0.200
    47.276     0.358     0.200
    47.276     0.468     0.200
    47.273     0.703     0.200
    47.321    -0.935     0.200
    47.399    -1.145     0.200
    47.378    -0.069     0.200
    47.426    -0.734     0.200
    47.426     0.676     0.200
    47.413    -0.482     0.200
    47.419     0.279     0.200
    47.448     1.183     0.200
    47.448     0.851     0.200
    47.538     0.298     0.200
    47.547     0.154     0.200
    47.628    -0.487     0.200
    47.647    -0.255     0.200
    47.647     0.272     0.200
    47.720    -1.024     0.200
    47.765     1.303     0.200
    47.765     0.983     0.200
    47.793    -0.376     0.200
    47.799    -0.175     0.200
    47.817     0.071     0.200
    47.861    -0.034     0.200
    47.872     0.209     0.200
    47.888    -0.129     0.200
    47.996    -0.648     0.200
    48.016    -0.366     0.200
    48.022    -0.170     0.200
    48.063    -0.715     0.200
    48.055     0.516     0.200
    48.055     0.665     0.200
    48.082    -0.004     0.200
    48.114    -0.102     0.200
    48.142     1.809     0.200
    48.184    -0.675     0.200
    48.278     0.741     0.200
    48.278     0.928     0.200
    48.278     1.530     0.200
    48.364    -0.820     0.200
    48.357    -0.041     0.200
    48.375     0.339     0.200
    48.454    -0.084     0.200
    48.454    -1.307     0.200
    48.410     0.973     0.200
    48.425    -0.610     0.200
    48.433    -0.107     0.200
    48.458    -0.105     0.200
    48.473     0.334     0.200
    48.490    -0.541     0.200
    48.483     0.556     0.200
    48.498     0.273     0.200
    48.496    -0.338     0.200
    48.519    -0.992     0.200
    48.553    -1.314     0.200
    48.553    -0.044     0.200
    48.553    -1.142     0.200
    48.552    -2.433     0.200
    48.590    -0.068     0.200
    48.632     0.277     0.200
    48.726    -0.020     0.200
    48.749     0.049     0.200
    48.832    -0.392     0.200
    49.013     1.695     0.200
    49.062    -0.366     0.200
    49.061    -0.416     0.200
    49.087    -0.200     0.200
    49.152    -0.483     0.200
    49.159    -0.069     0.200
    49.159    -0.194     0.200
    49.162     2.046     0.200
    49.226    -0.595     0.200
    49.196    -0.372     0.200
    49.247     0.495     0.200
    49.254     1.151     0.200
    49.254     0.940     0.200
    49.304     0.243     0.200
    49.343     0.156     0.200
    49.355    -0.445     0.200
    49.437    -0.143     0.200
    49.437     0.091     0.200
    49.453    -0.387     0.200
    49.509    -0.355     0.200
    49.536    -0.234     0.200
    49.577     0.374     0.200
    49.685    -2.087     0.200
    49.677     0.150     0.200
    49.678     0.029     0.200
    49.715    -0.315     0.200
    49.730    -0.157     0.200
    49.728     0.348     0.200
    49.721     0.089     0.200
    49.743     1.425     0.200
    49.768    -0.212     0.200
    49.768    -0.399     0.200
    49.774     0.435     0.200
    49.793    -0.173     0.200
    49.830     0.230     0.200
    49.863    -0.836     0.200
    49.892     0.195     0.200
    49.899    -0.231     0.200
    49.959    -0.037     0.200
    50.016    -0.536     0.200
    50.047    -0.196     0.200
    50.063    -0.400     0.200
    50.086     0.545     0.200
    50.086     0.174     0.200
    50.087     0.174     0.200
    50.115     0.080     0.200
    50.134    -0.045     0.200
    50.134    -0.323     0.200
    50.134    -0.009     0.200
    50.231     0.030     0.200
    50.294    -0.476     0.200
    50.294    -0.664     0.200
    50.305    -0.544     0.200
    50.404     0.275     0.200
    50.458     0.966     0.200
    50.465    -0.313     0.200
    50.465    -0.430     0.200
    50.486     0.068     0.200
    50.501     0.174     0.200
    50.496     0.461     0.200
    50.564    -0.084     0.200
    50.628     0.495     0.200
    50.700     0.091     0.200
    50.700    -0.112     0.200
    50.715    -0.042     0.200
    50.768     0.013     0.200
    50.776     0.142     0.200
    50.820    -0.001     0.200
    51.004    -0.165     0.200
    51.044    -0.046     0.200
    51.087     0.298     0.200
    51.084     0.249     0.200
    51.164    -3.133     0.200
    51.160     0.176     0.200
    51.168    -0.440     0.200
    51.177     0.081     0.200
    51.177    -0.126     0.200
    51.198    -0.173     0.200
    51.205    -0.140     0.200
    51.203    -0.314     0.200
    51.228    -0.142     0.200
    51.247    -0.329     0.200
    51.295     0.404     0.200
    51.323     0.119     0.200
    51.363     0.159     0.200
    51.377     0.098     0.200
    51.444    -0.105     0.200
    51.467    -0.521     0.200
    51.522    -0.332     0.200
    51.522    -0.070     0.200
    51.581    -1.060     0.200
    51.674    -0.751     0.200
    51.809    -0.097     0.200
    51.805    -0.052     0.200
    51.805    -0.161     0.200
    51.918    -0.114     0.200
    51.918    -0.263     0.200
    51.898     0.595     0.200
    51.947    -0.697     0.200
    52.069    -2.287     0.200
    52.069    -1.936     0.200
    52.027    -0.348     0.200
    52.027    -0.504     0.200
    52.071    -0.998     0.200
    52.081    -1.751     0.200
    52.199    -1.436     0.200
    52.290    -2.922     0.200
    52.366    -0.074     0.200
    52.385    -0.487     0.200
    52.460    -0.115     0.200
    52.496    -0.182     0.200
    52.507     0.021     0.200
    52.660    -0.354     0.200
    52.716     0.130     0.200
    52.797    -1.860     0.200
    52.769    -1.101     0.200
    52.890    -3.253     0.200
    52.978     0.394     0.200
    53.019    -0.066     0.200
    53.224    -1.427     0.200
    53.166    -0.271     0.200
    53.224    -1.497     0.200
    53.291     0.356     0.200
    53.299     0.020     0.200
    53.504    -0.942     0.200
    53.522     0.318     0.200
    53.640    -1.821     0.200
    53.631    -0.047     0.200
    53.706    -0.770     0.200
    53.789    -2.723     0.200
    53.789    -1.344     0.200
    53.831    -1.115     0.200
    53.831    -0.807     0.200
    53.986     0.405     0.200
    53.986     0.213     0.200
    54.048    -0.735     0.200
    54.119    -1.052     0.200
    54.159    -4.242     0.200
    54.189    -1.749     0.200
    54.308    -0.995     0.200
    54.308    -0.225     0.200
    54.308    -0.526     0.200
    54.310    -0.194     0.200
    54.693    -0.614     0.200
    54.724    -2.038     0.200
    55.018    -0.558     0.200
    55.110    -0.977     0.200
    55.120    -0.758     0.200
    55.120    -0.496     0.200
    55.120    -0.273     0.200
    55.258    -1.788     0.200
    55.423    -1.588     0.200
    56.349     0.150     0.200
    56.834    -1.617     0.200
    57.047    -1.232     0.200
    57.067    -0.576     0.200
    57.067    -1.357     0.200
    57.280    -0.466     0.200
    57.280    -0.349     0.200
    57.583    -3.807     0.200
    58.411    -2.257     0.200
    58.418    -1.689     0.200
    58.595    -0.875     0.200
    58.705    -0.426     0.200
    58.752    -0.936     0.200
    59.292    -2.003     0.200
    59.363    -0.098     0.200
    59.503    -1.855     0.200
    59.591    -1.262     0.200
    59.830    -1.105     0.200
    60.130    -1.100     0.200
    60.130    -0.018     0.200
    60.231    -1.509     0.200
    60.240    -2.106     0.200
    60.240    -1.958     0.200
    60.408    -1.386     0.200
    60.418    -2.400     0.200
    60.673    -0.157     0.200
    60.787    -2.379     0.200
    60.942    -1.384     0.200
    61.179    -0.486     0.200
    61.293    -1.300     0.200
    61.380    -0.784     0.200
    61.380     0.255     0.200
    61.405    -1.183     0.200
    61.483    -1.410     0.200
    61.483    -0.941     0.200
    61.483    -1.050     0.200
    61.483    -1.179     0.200
    61.639    -1.131     0.200
    61.834    -2.297     0.200
    61.866    -2.516     0.200
    62.042    -1.393     0.200
    62.060    -0.712     0.200
    62.549    -1.086     0.200
    62.519    -0.450     0.200
    62.519    -0.743     0.200
    62.584    -2.982     0.200
    62.584    -2.814     0.200
    62.584    -2.584     0.200
    62.745    -0.990     0.200
    62.716    -2.490     0.200
    62.887    -2.368     0.200
    63.106    -2.269     0.200
    63.106    -1.730     0.200
    63.106    -2.011     0.200
    63.140    -1.059     0.200
    63.195    -0.564     0.200
    63.215    -3.001     0.200
    63.260    -2.466     0.200
    63.260    -2.196     0.200
    63.260    -2.032     0.200
    63.260    -2.298     0.200
    63.264    -2.424     0.200
    63.410    -1.285     0.200
    63.986    -0.697     0.200
    64.099    -1.160     0.200
    64.201    -1.702     0.200
    64.575    -0.228     0.200
    65.031    -1.591     0.200
    65.314    -1.625     0.200
    65.314    -1.395     0.200
    65.418    -2.396     0.200
    65.418    -2.021     0.200
    65.447    -2.253     0.200
    65.508    -2.119     0.200
    65.508    -1.967     0.200
    65.519    -1.243     0.200
    65.800    -0.766     0.200
    65.998    -1.328     0.200
    66.133    -0.194     0.200
    66.359    -1.076     0.200
    66.393    -0.033     0.200
    66.393    -2.033     0.200
    66.468    -1.612     0.200
    66.468    -2.572     0.200
    66.468    -2.733     0.200
    66.732    -0.416     0.200
    66.977    -0.994     0.200
    67.123    -2.396     0.200
    67.169    -1.485     0.200
    67.376    -1.627     0.200
    67.674    -1.075     0.200
    67.820     0.506     0.200
    67.842    -1.969     0.200
    67.842    -1.739     0.200
    67.946    -1.183     0.200
    67.987    -2.638     0.200
    68.135    -0.066     0.200
    68.135    -1.566     0.200
    68.145    -2.627     0.200
    68.158    -0.709     0.200
    68.242    -1.237     0.200
    68.261    -1.156     0.200
    68.261    -1.257     0.200
    68.370    -1.175     0.200
    68.370    -0.757     0.200
    68.402    -3.139     0.200
    68.813    -2.993     0.200
    68.934    -0.018     0.200
    69.148    -2.369     0.200
    69.151    -1.392     0.200
    69.411    -1.293     0.200
    69.547    -0.897     0.200
    69.557    -1.755     0.200
    69.715    -3.869     0.200
    69.723    -0.839     0.200
    69.787    -0.826     0.200
    69.864    -0.581     0.200
    69.958    -0.648     0.200
    69.966    -3.407     0.200
    69.982    -0.382     0.200
    70.002    -0.799     0.200
    70.012    -0.796     0.200
    70.038    -1.451     0.200
    70.049    -0.609     0.200
    70.109    -0.731     0.200
    70.116    -0.963     0.200
    70.154    -0.621     0.200
    70.171    -2.764     0.200
    70.192    -2.712     0.200
    70.192    -2.841     0.200
    70.262    -0.450     0.200
    70.334    -1.135     0.200
    70.342    -1.207     0.200
    70.340    -1.496     0.200
    70.358    -1.025     0.200
    70.410    -2.920     0.200
    70.488    -0.755     0.200
    70.544    -0.735     0.200
    70.736    -0.811     0.200
    70.768    -0.600     0.200
    70.828    -1.144     0.200
    70.883    -0.193     0.200
    70.933    -0.299     0.200
    70.958    -0.299     0.200
    70.974    -0.451     0.200
    71.015    -0.876     0.200
    71.015    -0.994     0.200
    71.036    -1.031     0.200
    71.052    -0.620     0.200
    71.162    -2.587     0.200
    71.162    -2.434     0.200
    71.162    -2.485     0.200
    71.204    -0.935     0.200
    71.228    -0.583     0.200
    71.379    -0.689     0.200
    71.403    -0.598     0.200
    71.425    -0.853     0.200
    71.455    -0.570     0.200
    71.468    -0.529     0.200
    71.486    -0.745     0.200
    71.537    -1.302     0.200
    71.560    -0.780     0.200
    71.611    -0.698     0.200
    71.611    -0.976     0.200
    71.611    -0.847     0.200
    71.806    -0.638     0.200
    71.843    -0.477     0.200
    71.871    -1.163     0.200
    71.978    -0.421     0.200
    71.989    -0.553     0.200
    72.025    -0.147     0.200
    72.054    -1.445     0.200
    72.217    -1.017     0.200
    72.247    -0.392     0.200
    72.283    -0.113     0.200
    72.283    -0.910     0.200
    72.297    -0.691     0.200
    72.312    -1.685     0.200
    72.315    -0.239     0.200
    72.315    -0.501     0.200
    72.350    -2.008     0.200
    72.350    -2.071     0.200
    72.357    -0.074     0.200
    72.392    -0.756     0.200
    72.427    -0.884     0.200
    72.427    -0.064     0.200
    72.517    -1.099     0.200
    72.531    -1.325     0.200
    72.541    -1.117     0.200
    72.591    -0.041     0.200
    72.675    -1.042     0.200
    72.794     0.058     0.200
    72.905    -0.503     0.200
    72.913    -0.848     0.200
    72.950    -0.680     0.200
    73.124    -0.299     0.200
    73.218    -0.747     0.200
    73.256    -0.169     0.200
    73.330    -1.536     0.200
    73.369    -0.927     0.200
    73.360    -1.183     0.200
    73.422    -0.053     0.200
    73.611    -0.562     0.200
    73.624    -0.432     0.200
    73.682    -0.577     0.200
    73.715    -0.540     0.200
    73.731    -0.246     0.200
    73.744    -2.214     0.200
    73.798    -0.587     0.200
    73.840    -1.020     0.200
    73.853    -0.234     0.200
    73.866    -0.222     0.200
    73.867    -0.377     0.200
    73.871    -0.079     0.200
    73.930    -0.132     0.200
    73.932    -0.264     0.200
    73.985     2.557     0.200
    74.081    -0.123     0.200
    74.192    -0.817     0.200
    74.263    -0.399     0.200
    74.266     0.291     0.200
    74.273    -0.533     0.200
    74.273    -1.350     0.200
    74.522    -0.699     0.200
    74.530    -1.526     0.200
    74.705    -0.028     0.200
    74.736    -0.870     0.200
    74.794    -0.038     0.200
    74.797    -0.588     0.200
    74.929    -0.468     0.200
    74.929    -0.815     0.200
    74.953    -0.955     0.200
    74.954    -1.465     0.200
    74.996    -1.304     0.200
    75.058    -0.804     0.200
    75.111    -0.814     0.200
    75.182    -0.521     0.200
    75.244    -1.376     0.200
    75.380    -1.403     0.200
    75.390    -1.163     0.200
    75.390    -1.059     0.200
    75.380    -0.935     0.200
    75.440    -0.709     0.200
    75.483    -0.485     0.200
    75.553    -0.386     0.200
    75.675    -1.798     0.200
    75.685    -2.250     0.200
    75.691    -1.086     0.200
    75.796    -0.770     0.200
    75.828    -0.201     0.200
    75.843    -1.754     0.200
    75.859     1.255     0.200
    75.831    -0.487     0.200
    75.833     0.207     0.200
    75.909    -2.029     0.200
    75.854     0.285     0.200
    75.854     0.244     0.200
    75.981    -1.237     0.200
    75.986    -1.350     0.200
    75.926    -0.924     0.200
    76.018    -1.535     0.200
    76.026    -0.823     0.200
    76.038    -0.896     0.200
    76.041    -1.161     0.200
    76.047    -0.441     0.200
    76.080    -0.876     0.200
    76.079    -0.794     0.200
    76.058     0.023     0.200
    76.128     0.355     0.200
    76.202    -0.569     0.200
    76.210    -0.360     0.200
    76.209    -0.761     0.200
    76.296    -1.105     0.200
    76.343    -0.614     0.200
    76.344    -1.122     0.200
    76.356     0.531     0.200
    76.373    -0.922     0.200
    76.385    -1.101     0.200
    76.401    -0.335     0.200
    76.401     0.778     0.200
    76.422    -1.819     0.200
    76.450    -0.216     0.200
    76.458    -0.767     0.200
    76.515     0.164     0.200
    76.568     0.538     0.200
    76.583    -1.447     0.200
    76.592    -0.771     0.200
    76.592    -1.303     0.200
    76.630    -1.183     0.200
    76.642     0.717     0.200
    76.623    -0.730     0.200
    76.682    -2.406     0.200
    76.642    -0.308     0.200
    76.704    -0.900     0.200
    76.742    -1.647     0.200
    76.774    -1.039     0.200
    76.888    -1.312     0.200
    76.904     0.648     0.200
    76.960    -1.835     0.200
    76.983    -0.463     0.200
    76.989    -0.830     0.200
    77.012    -0.063     0.200
    77.012     0.230     0.200
    77.012     1.250     0.200
    76.961     0.647     0.200
    77.022    -0.679     0.200
    77.023     0.067     0.200
    77.038    -1.426     0.200
    77.038    -1.207     0.200
    77.038    -1.090     0.200
    77.038    -0.801     0.200
    77.038    -0.437     0.200
    77.039    -1.026     0.200
    77.087    -1.182     0.200
    77.135     0.552     0.200
    77.171    -1.081     0.200
    77.177    -1.802     0.200
    77.187    -0.344     0.200
    77.187    -1.543     0.200
    77.194    -0.142     0.200
    77.197    -0.158     0.200
    77.214    -0.253     0.200
    77.239    -1.132     0.200
    77.239    -1.730     0.200
    77.326    -0.016     0.200
    77.338    -1.198     0.200
    77.358    -2.058     0.200
    77.349    -0.939     0.200
    77.406    -0.266     0.200
    77.409    -0.886     0.200
    77.418    -1.138     0.200
    77.420    -1.151     0.200
    77.470    -1.156     0.200
    77.497     0.925     0.200
    77.516     0.221     0.200
    77.540    -0.813     0.200
    77.553    -1.058     0.200
    77.524    -0.571     0.200
    77.575    -1.764     0.200
    77.624     0.517     0.200
    77.658    -1.369     0.200
    77.669    -1.285     0.200
    77.700    -1.207     0.200
    77.703    -2.723     0.200
    77.728    -0.432     0.200
    77.760    -0.738     0.200
    77.769    -0.083     0.200
    77.792    -0.657     0.200
    77.842    -0.490     0.200
    77.863    -0.511     0.200
    78.051    -2.253     0.200
    78.064     0.573     0.200
    78.065     0.869     0.200
    78.109    -1.705     0.200
    78.109    -1.173     0.200
    78.184    -1.131     0.200
    78.199    -1.069     0.200
    78.326    -1.162     0.200
    78.361    -0.868     0.200
    78.380    -1.379     0.200
    78.474    -1.048     0.200
    78.477     0.097     0.200
    78.478     0.687     0.200
    78.492    -0.589     0.200
    78.513    -1.802     0.200
    78.522    -1.237     0.200
    78.625    -1.319     0.200
    78.624     0.286     0.200
    78.688    -0.668     0.200
    78.764    -1.813     0.200
    78.781    -1.478     0.200
    78.816    -1.620     0.200
    78.832    -0.603     0.200
    78.832    -0.134     0.200
    78.881    -0.585     0.200
    78.955    -1.328     0.200
    78.979    -1.938     0.200
    78.994     0.175     0.200
    78.994    -1.091     0.200
    79.037     0.352     0.200
    79.037     0.590     0.200
    79.104    -0.495     0.200
    79.175    -0.704     0.200
    79.185     0.413     0.200
    79.232    -1.839     0.200
    79.288    -0.415     0.200
    79.288    -1.446     0.200
    79.275    -0.585     0.200
    79.325    -1.349     0.200
    79.425    -0.789     0.200
    79.462     0.608     0.200
    79.433     0.975     0.200
    79.433     1.366     0.200
    79.433     0.409     0.200
    79.527    -1.146     0.200
    79.569    -0.785     0.200
    79.665    -0.391     0.200
    79.665    -0.567     0.200
    79.702     1.409     0.200
    79.699     0.751     0.200
    79.754     0.325     0.200
    79.795     0.804     0.200
    79.795     0.343     0.200
    79.832    -1.856     0.200
    79.836    -0.648     0.200
    79.839    -0.238     0.200
    79.850    -0.432     0.200
    79.965    -0.075     0.200
    79.988    -0.539     0.200
    80.017    -2.547     0.200
    79.994     0.131     0.200
    80.044    -1.240     0.200
    80.036     0.701     0.200
    80.037     0.677     0.200
    80.041     0.923     0.200
    80.057    -0.341     0.200
    80.137    -1.599     0.200
    80.151     0.876     0.200
    80.145    -0.698     0.200
    80.198     0.430     0.200
    80.187    -0.010     0.200
    80.226    -0.910     0.200
    80.238    -0.786     0.200
    80.293    -1.660     0.200
    80.293    -2.141     0.200
    80.320     0.674     0.200
    80.330     0.822     0.200
    80.356    -1.010     0.200
    80.356    -0.858     0.200
    80.295     0.110     0.200
    80.432     1.072     0.200
    80.484    -0.335     0.200
    80.487    -2.125     0.200
    80.519     0.007     0.200
    80.520    -0.558     0.200
    80.536    -0.613     0.200
    80.547    -0.502     0.200
    80.547     0.357     0.200
    80.547    -0.010     0.200
    80.547     0.213     0.200
    80.628    -0.744     0.200
    80.671    -0.427     0.200
    80.713    -2.657     0.200
    80.713    -1.657     0.200
    80.716    -1.269     0.200
    80.747    -1.209     0.200
    80.772    -0.345     0.200
    80.799    -2.188     0.200
    80.807    -1.930     0.200
    80.868    -0.052     0.200
    80.882    -1.531     0.200
    80.913    -0.385     0.200
    80.993    -1.922     0.200
    81.037    -1.157     0.200
    81.053    -1.340     0.200
    81.042     2.020     0.200
    81.191    -0.673     0.200
    81.231    -0.185     0.200
    81.231    -0.084     0.200
    81.264    -1.059     0.200
    81.264    -0.858     0.200
    81.274    -1.712     0.200
    81.327    -0.593     0.200
    81.327    -0.393     0.200
    81.309    -0.298     0.200
    81.353    -0.427     0.200
    81.463    -1.612     0.200
    81.487    -1.440     0.200
    81.519    -1.745     0.200
    81.536    -1.592     0.200
    81.622    -0.452     0.200
    81.584     0.352     0.200
    81.757    -0.757     0.200
    81.873    -0.190     0.200
    81.873    -0.756     0.200
    81.974    -0.728     0.200
    81.975    -1.253     0.200
    81.975    -1.003     0.200
    81.987    -1.365     0.200
    82.023    -0.154     0.200
    82.037    -0.226     0.200
    82.064    -1.866     0.200
    82.083     0.031     0.200
    82.083     0.852     0.200
    82.227    -1.822     0.200
    82.187    -1.646     0.200
    82.257    -1.878     0.200
    82.380    -0.585     0.200
    82.413    -0.462     0.200
    82.487    -2.177     0.200
    82.518     1.629     0.200
    82.547    -1.989     0.200
    82.679    -0.931     0.200
    82.808    -2.344     0.200
    82.811    -1.559     0.200
    82.886    -1.922     0.200
    82.982    -1.643     0.200
    82.966    -0.860     0.200
    82.968    -0.871     0.200
    83.079     1.734     0.200
    83.193    -0.780     0.200
    83.193    -1.292     0.200
    83.193    -1.132     0.200
    83.193    -1.573     0.200
    83.354    -1.460     0.200
    83.419     1.005     0.200
    83.484     0.649     0.200
    83.846    -0.731     0.200
    83.956     1.261     0.200
    83.997     0.156     0.200
    84.000     1.007     0.200
    84.120    -0.173     0.200
    84.156    -2.827     0.200
    84.219    -0.576     0.200
    84.219    -0.974     0.200
    84.363     2.166     0.200
    84.416    -0.269     0.200
    84.430     0.827     0.200
    84.709    -0.651     0.200
    84.965     0.667     0.200
    85.077     0.609     0.200
    85.077    -0.618     0.200
    85.135     1.716     0.200
    85.512    -1.362     0.200
    85.793     2.016     0.200
    85.967    -1.714     0.200
    86.193     3.041     0.200
    86.333    -1.190     0.200
    86.635    -0.696     0.200
    86.662    -2.326     0.200
    86.692     0.228     0.200
    86.692    -1.674     0.200
    86.733    -1.373     0.200
    86.787    -3.136     0.200
    86.829     2.927     0.200
    86.972    -0.268     0.200
    87.128    -0.593     0.200
    87.252    -0.781     0.200
    87.440    -1.606     0.200
    87.513    -0.645     0.200
    87.513    -2.946     0.200
    87.644    -0.901     0.200
    87.674    -0.502     0.200
    87.847    -0.109     0.200
    87.851    -2.353     0.200
    87.996    -0.203     0.200
    88.036    -0.231     0.200
    88.190    -0.049     0.200
    88.272    -2.578     0.200
    88.493    -1.388     0.200
    90.753    -1.954     0.200
    90.838     0.249     0.200
    90.890    -1.932     0.200
    91.572     0.246     0.200
    91.654     0.266     0.200
    92.026    -1.225     0.200
    92.453    -1.575     0.200
    92.453    -0.427     0.200
    92.453    -0.978     0.200
    92.503    -1.256     0.200
    92.520    -2.233     0.200
    92.537    -0.689     0.200
    92.537    -0.103     0.200
    92.537    -0.814     0.200
    92.898    -2.157     0.200
    92.898    -1.509     0.200
    93.260    -3.356     0.200
    93.260    -2.961     0.200
    93.346    -1.879     0.200
    93.346    -0.485     0.200
    93.392    -2.155     0.200
    93.392    -0.784     0.200
    93.339    -1.208     0.200
    93.339     0.191     0.200
    93.546    -1.965     0.200
    93.546    -0.492     0.200
    93.596    -1.893     0.200
    93.596    -0.647     0.200
    93.772    -1.891     0.200
    93.772    -0.535     0.200
    93.960    -2.611     0.200
    93.960    -3.755     0.200
    94.020    -1.660     0.200
    94.122    -1.608     0.200
    94.292     0.685     0.200
    94.613     0.606     0.200
    94.728    -0.830     0.200
    94.815    -1.511     0.200
    95.888    -0.782     0.200
    96.706    -1.792     0.200
    96.706    -4.695     0.200
    96.873    -0.647     0.200
    96.947    -2.355     0.200
    97.792    -1.189     0.200
    97.805    -1.651     0.200
    97.800    -2.226     0.200
    97.800    -2.019     0.200
    97.846    -1.115     0.200
    98.571    -2.788     0.200
    98.618    -1.797     0.200
    19.129    -0.577     0.200
    19.129    -0.257     0.200
    20.225     0.042     0.200
    20.491     0.045     0.200
    20.895     0.541     0.200
    21.229    -0.227     0.200
    22.187     0.859     0.200
    22.561    -0.315     0.200
    23.237     0.703     0.200
    23.356     0.711     0.200
    23.491    -0.776     0.200
    23.547     0.490     0.200
    23.583    -0.371     0.200
    23.787     1.217     0.200
    23.903     0.982     0.200
    23.903     2.013     0.200
    23.970     0.393     0.200
    24.031     0.311     0.200
    24.400     0.127     0.200
    24.500     0.440     0.200
    24.735     0.036     0.200
    25.038     0.576     0.200
    25.226     3.097     0.200
    25.321     3.386     0.200
    26.233     1.786     0.200
    26.269    -0.510     0.200
    26.700     1.590     0.200
    27.362    -0.217     0.200
    27.785    -1.297     0.200
    27.923     0.315     0.200
    28.378     2.464     0.200
    28.401     2.819     0.200
    28.767     2.827     0.200
    29.311     2.850     0.200
    29.466     2.882     0.200
    29.471     2.747     0.200
    29.501     1.828     0.200
    29.583     2.702     0.200
    29.902     2.259     0.200
    30.181     2.540     0.200
    30.982     0.635     0.200
    30.983     1.567     0.200
    31.208     2.241     0.200
    31.264     2.256     0.200
    31.264    -0.343     0.200
    31.495     3.148     0.200
    31.495     1.680     0.200
    31.614     1.537     0.200
    31.646     0.371     0.200
    31.989     2.970     0.200
    32.008     2.704     0.200
    32.060     2.114     0.200
    32.060     1.067     0.200
    32.113     1.973     0.200
    32.159     1.286     0.200
    32.201     1.307     0.200
    32.479     2.522     0.200
    32.566     2.574     0.200
    32.641     0.172     0.200
    32.817     0.182     0.200
    32.924     1.774     0.200
    32.924     1.534     0.200
    32.938     1.928     0.200
    32.971     1.632     0.200
    33.138     2.436     0.200
    33.138     2.293     0.200
    33.440     0.888     0.200
    33.625     2.676     0.200
    33.711     2.828     0.200
    33.745     2.290     0.200
    33.986     0.597     0.200
    34.096     0.699     0.200
    34.203     0.371     0.200
    34.585     0.725     0.200
    34.680     2.568     0.200
    34.696     0.353     0.200
    34.703     1.675     0.200
    34.703     0.746     0.200
    34.853     2.113     0.200
    35.007     1.170     0.200
    35.124     0.920     0.200
    35.206     1.071     0.200
    35.314     2.116     0.200
    35.480     2.144     0.200
    35.555     0.948     0.200
    35.560     2.518     0.200
    35.560     1.572     0.200
    35.661     1.551     0.200
    35.661     0.397     0.200
    35.660     0.767     0.200
    35.916     1.317     0.200
    36.097     1.627     0.200
    36.208     0.851     0.200
    36.409     2.826     0.200
    36.684     1.697     0.200
    36.777     2.340     0.200
    36.777     1.212     0.200
    37.048     2.518     0.200
    37.099     0.486     0.200
    37.313     1.473     0.200
    37.769     0.535     0.200
    37.800     0.623     0.200
    37.917     1.389     0.200
    37.917     1.244     0.200
    38.088    -0.312     0.200
    38.442     2.394     0.200
    38.442     1.272     0.200
    38.458    -0.062     0.200
    38.596     0.908     0.200
    38.969     0.508     0.200
    39.630     1.727     0.200
    39.723     2.605     0.200
    39.723     0.828     0.200
    40.401    -0.715     0.200
    41.013    -0.375     0.200
    41.102    -0.163     0.200
    41.098     1.365     0.200
    41.098     0.901     0.200
    41.590     0.631     0.200
    41.638     0.270     0.200
    42.461     1.224     0.200
    42.558     1.224     0.200
    42.558     0.629     0.200
    43.193    -0.443     0.200
    43.220     0.162     0.200
    43.286    -0.409     0.200
    43.551    -2.573     0.200
    43.557    -0.025     0.200
    43.739     0.041     0.200
    43.765     1.078     0.200
    44.000    -0.117     0.200
    44.361     1.054     0.200
    44.369     1.199     0.200
    44.426    -1.606     0.200
    44.599    -3.137     0.200
    44.845    -0.349     0.200
    45.158     0.789     0.200
    45.392     0.987     0.200
    45.392     1.092     0.200
    45.394     0.401     0.200
    45.428     0.146     0.200
    45.580    -0.770     0.200
    45.580    -1.252     0.200
    46.022    -0.655     0.200
    46.288     1.527     0.200
    46.288     1.023     0.200
    46.339    -0.644     0.200
    46.477    -0.502     0.200
    46.732    -1.042     0.200
    47.245    -0.697     0.200
    47.344     1.166     0.200
    47.470    -0.153     0.200
    47.614    -1.642     0.200
    47.647     0.162     0.200
    47.989     0.307     0.200
    48.072     0.418     0.200
    48.335     0.092     0.200
    49.183    -0.347     0.200
    51.414    -0.888     0.200
    52.397    -2.482     0.200
    53.644    -1.372     0.200
    55.815    -0.303     0.200
    55.815    -0.531     0.200
    58.739    -2.499     0.200
    59.005     1.955     0.200
    60.288    -1.835     0.200
    60.526    -2.069     0.200
    61.374    -2.148     0.200
    63.534    -2.547     0.200
    63.551    -1.735     0.200
    64.067    -1.783     0.200
    65.757    -2.350     0.200
    66.494     4.026     0.200
    71.285    -2.054     0.200
    77.431    -1.222     0.200
    78.933    -0.895     0.200
    61.158    -3.118     0.200
    62.142    -2.357     0.200
    63.566    -3.161     0.200
    71.874    -3.100     0.200
    79.966    -0.593     0.200
    20.061    -0.492     0.200
    55.353     0.809     0.200
    58.541    -0.124     0.200
    79.620     0.093     0.200
    32.197     0.745     0.200
    54.856    -0.644     0.200
    58.064     0.022     0.200
    63.032    -1.332     0.200
    13.855     7.507     0.200
    17.265     0.554     0.200
    18.381    -1.432     0.200
    23.294     1.561     0.200
    24.920     2.236     0.200
    25.877     0.615     0.200
    27.392     0.865     0.200
    27.789     1.714     0.200
    27.899     1.623     0.200
    27.880    -3.140     0.200
    29.253     3.169     0.200
    29.382     2.181     0.200
    29.472     1.931     0.200
    29.613     1.836     0.200
    30.903     1.121     0.200
    30.903     1.475     0.200
    31.018     2.078     0.200
    31.034     1.931     0.200
    31.199     2.828     0.200
    31.299     2.150     0.200
    31.314     2.823     0.200
    31.740     1.833     0.200
    31.749     2.401     0.200
    31.781     1.745     0.200
    31.864     2.373     0.200
    31.890     2.482     0.200
    32.010     2.026     0.200
    32.603     1.837     0.200
    32.827     2.135     0.200
    32.942     0.958     0.200
    32.958     0.648     0.200
    33.081     1.637     0.200
    33.145     2.821     0.200
    33.247     2.742     0.200
    33.288     1.840     0.200
    33.435     2.471     0.200
    33.466     1.841     0.200
    33.797     1.598     0.200
    34.031     3.006     0.200
    34.270     2.638     0.200
    34.369     1.851     0.200
    34.369     1.461     0.200
    34.376     1.396     0.200
    34.553     2.542     0.200
    34.661     2.343     0.200
    34.813     2.305     0.200
    34.923     1.570     0.200
    34.979     2.693     0.200
    35.100     2.012     0.200
    35.230     1.992     0.200
    35.326     1.839     0.200
    35.335     2.588     0.200
    35.502     1.665     0.200
    35.970     0.963     0.200
    36.196     2.256     0.200
    36.669     2.300     0.200
    37.092    -1.448     0.200
    37.207     0.367     0.200
    37.477     1.445     0.200
    37.697     2.055     0.200
    38.184     2.563     0.200
    38.296     1.480     0.200
    39.105    -0.444     0.200
    39.511     2.345     0.200
    40.847     1.514     0.200
    40.974     1.795     0.200
    41.402     1.648     0.200
    41.644    -4.999     0.200
    42.497     0.404     0.200
    42.856    -2.665     0.200
    43.441    -2.621     0.200
    43.666     0.891     0.200
    44.177     1.156     0.200
    44.627     0.356     0.200
    44.892    -2.967     0.200
    45.265     0.874     0.200
    45.316     0.437     0.200
    45.430    -0.053     0.200
    46.985     0.304     0.200
    47.154    -0.547     0.200
    47.850    -1.051     0.200
    48.976    -0.735     0.200
    49.174    -0.936     0.200
    49.317     0.056     0.200
    49.326    -0.686     0.200
    49.774    -1.363     0.200
    50.121    -1.565     0.200
    50.346    -1.234     0.200
    51.564    -0.984     0.200
    51.735    -1.065     0.200
    53.188    -2.274     0.200
    56.241    -1.170     0.200
    59.345    -2.413     0.200
    61.080    -1.584     0.200
    61.080    -3.346     0.200
    61.318    -1.883     0.200
    61.504    -3.055     0.200
    62.166    -1.805     0.200
    64.157    -2.357     0.200
    64.224    -2.848     0.200
    64.837    -1.672     0.200
    65.836    -0.926     0.200
    66.340    -2.087     0.200
    66.754    -1.506     0.200
    67.025     1.372     0.200
    69.368    -2.216     0.200
    70.685    -0.592     0.200
    70.874    -0.742     0.200
    71.384     0.211     0.200
    71.606    -0.265     0.200
    71.777    -0.493     0.200
    72.074    -2.447     0.200
    72.081    -0.318     0.200
    72.385    -0.936     0.200
    72.548    -1.314     0.200
    72.829    -0.575     0.200
    73.083    -0.683     0.200
    73.377    -1.384     0.200
    73.453    -1.064     0.200
    73.459     0.400     0.200
    74.082    -0.452     0.200
    74.459    -0.205     0.200
    74.898    -0.008     0.200
    74.912     2.034     0.200
    75.099    -0.085     0.200
    75.108    -0.022     0.200
    75.570    -0.140     0.200
    75.710    -1.254     0.200
    75.768    -0.219     0.200
    77.827     0.603     0.200
    78.192    -2.023     0.200
    79.682    -0.648     0.200
    81.320    -1.308     0.200
    81.344    -0.704     0.200
    81.616    -0.342     0.200
    81.708    -0.129     0.200
    82.043    -0.691     0.200
    82.089    -0.135     0.200
    82.109    -0.937     0.200
    82.109    -0.737     0.200
    82.162    -0.617     0.200
    82.200    -0.714     0.200
    82.619    -1.003     0.200
    82.905    -1.286     0.200
    83.883    -1.816     0.200
    29.609     2.987     0.200
    30.898     1.920     0.200
    43.445    -2.076     0.200
    44.172     1.627     0.200
    56.244    -0.654     0.200
    59.346    -1.975     0.200
    64.224    -1.779     0.200
    66.342    -2.922     0.200
    72.072    -1.883     0.200
    83.887    -0.749     0.200
    53.866    -1.164     0.200
    56.600    -1.077     0.200
    59.859    -1.141     0.200
    64.685    -1.096     0.200
    66.834    -1.083     0.200
    72.749    -2.622     0.200
    19.442    -0.242     0.200
    30.251     1.759     0.200
    31.356     1.138     0.200
    44.733     0.958     0.200
    55.496    -0.476     0.200
    18.335    -2.063     0.200
    19.414     0.160     0.200
    20.637     0.740     0.200
    20.881    -2.366     0.200
    27.284    -2.276     0.200
    30.020     2.549     0.200
    31.563     2.689     0.200
    44.699     2.683     0.200
    45.144    -0.659     0.200
    48.273    -1.521     0.200
    53.205    -2.427     0.200
    53.954    -1.178     0.200
    56.076    -2.097     0.200
    59.001     0.625     0.200
    59.505    -1.154     0.200
    61.945    -0.754     0.200
    61.945    -0.531     0.200
    62.080    -0.608     0.200
    63.017    -0.530     0.200
    64.352    -2.659     0.200
    64.534    -0.686     0.200
    65.802     0.037     0.200
    66.452    -0.863     0.200
    67.038     2.679     0.200
    72.808    -0.984     0.200
    75.350    -0.471     0.200
    78.771     0.238     0.200
    80.688     0.936     0.200
    83.486    -0.965     0.200
    18.733    -0.502     0.200
    19.851    -0.315     0.200
    20.879    -0.349     0.200
    20.879     0.940     0.200
    21.295    -1.637     0.200
    21.295    -1.027     0.200
    26.965    -0.500     0.200
    27.029    -2.577     0.200
    27.445    -0.399     0.200
    27.445    -0.509     0.200
    27.445    -0.087     0.200
    31.460     1.295     0.200
    34.120    -1.320     0.200
    34.120    -2.367     0.200
    37.260    -2.110     0.200
    38.698     2.966     0.200
    42.740    -1.986     0.200
    43.257    -0.568     0.200
    44.517     0.529     0.200
    45.654    -0.318     0.200
    46.918    -0.895     0.200
    46.918    -0.652     0.200
    46.918    -1.449     0.200
    48.366    -0.482     0.200
    53.372    -1.911     0.200
    54.466    -0.714     0.200
    56.103     0.250     0.200
    56.419    -0.943     0.200
    59.946    -0.477     0.200
    59.946    -0.375     0.200
    60.343    -0.198     0.200
    62.446    -0.308     0.200
    62.446     0.091     0.200
    62.593    -0.536     0.200
    62.673    -1.621     0.200
    63.521    -0.066     0.200
    63.892    -0.093     0.200
    64.508    -1.231     0.200
    64.692     0.068     0.200
    64.801    -1.502     0.200
    65.005    -1.094     0.200
    65.005    -0.570     0.200
    65.007    -0.664     0.200
    65.975    -0.841     0.200
    66.277    -0.701     0.200
    66.880    -0.132     0.200
    66.880    -0.757     0.200
    66.976    -1.401     0.200
    68.586    -1.381     0.200
    69.149    -2.015     0.200
    69.543    -0.867     0.200
    71.004    -0.761     0.200
    73.164     0.490     0.200
    73.164     1.013     0.200
    73.321    -0.916     0.200
    73.321    -0.791     0.200
    73.321    -1.018     0.200
    74.453    -0.245     0.200
    74.584     0.096     0.200
    74.747     0.379     0.200
    74.788     1.312     0.200
    75.094     0.249     0.200
    75.417     0.488     0.200
    75.470     3.685     0.200
    75.458     1.158     0.200
    76.139     0.755     0.200
    76.288     0.537     0.200
    76.468     0.747     0.200
    76.729    -0.491     0.200
    77.003     0.329     0.200
    77.953    -0.133     0.200
    79.083     0.536     0.200
    79.281     0.055     0.200
    79.281     0.430     0.200
    81.143     0.522     0.200
    82.164     0.558     0.200
    83.733    -0.345     0.200
    84.099     0.391     0.200
    18.807    -0.010     0.200
    20.920     0.277     0.200
    31.432     1.867     0.200
    45.753    -1.015     0.200
    47.016    -1.457     0.200
    56.494    -0.167     0.200
    60.038    -1.139     0.200
    62.543    -0.429     0.200
    62.693    -0.578     0.200
    63.619    -0.131     0.200
    65.104    -0.417     0.200
    66.367    -0.304     0.200
    66.970    -1.060     0.200
    83.790    -0.849     0.200
    63.999    -2.881     0.200
    66.154    -2.623     0.200
    18.506    -0.952     0.200
    18.506    -0.623     0.200
    19.548    -0.936     0.200
    19.548     0.369     0.200
    20.657    -0.879     0.200
    20.657    -1.121     0.200
    20.899    -1.238     0.200
    20.899     0.294     0.200
    23.621    -0.686     0.200
    23.878    -0.606     0.200
    24.110    -1.744     0.200
    24.303     0.584     0.200
    24.303     1.263     0.200
    24.303     1.896     0.200
    24.305     0.020     0.200
    25.121     0.707     0.200
    25.833     3.610     0.200
    26.423    -2.956     0.200
    26.493     0.649     0.200
    26.968    -0.048     0.200
    26.968    -0.134     0.200
    26.968    -3.157     0.200
    27.222     1.526     0.200
    27.399     2.638     0.200
    27.712     0.783     0.200
    28.037    -1.729     0.200
    28.488     0.015     0.200
    28.488     0.819     0.200
    28.584     0.076     0.200
    28.584     1.404     0.200
    28.710     1.790     0.200
    28.710     2.532     0.200
    29.162    -0.522     0.200
    29.852     1.439     0.200
    29.959     1.653     0.200
    30.255     4.598     0.200
    30.255     2.816     0.200
    30.263    -1.299     0.200
    30.322     2.749     0.200
    31.215     2.245     0.200
    31.279     0.874     0.200
    31.552    -1.625     0.200
    31.581     2.804     0.200
    31.787     2.726     0.200
    31.883     2.299     0.200
    31.883     1.438     0.200
    31.883     2.102     0.200
    31.896     1.800     0.200
    31.902     1.805     0.200
    31.906     3.048     0.200
    31.935     1.193     0.200
    31.966     1.490     0.200
    32.337     3.054     0.200
    32.379     2.095     0.200
    32.561     2.129     0.200
    32.562     2.649     0.200
    32.628     1.035     0.200
    32.763    -1.649     0.200
    32.919     2.825     0.200
    33.238     1.516     0.200
    33.300     2.491     0.200
    33.477    -2.377     0.200
    33.499     2.142     0.200
    33.622     1.630     0.200
    33.840     2.785     0.200
    33.896    -0.727     0.200
    33.909     0.599     0.200
    33.916     2.020     0.200
    34.022     2.886     0.200
    34.022     2.230     0.200
    34.108     1.813     0.200
    34.412     0.726     0.200
    34.412     2.406     0.200
    34.485     2.633     0.200
    34.497     3.520     0.200
    34.763    -1.461     0.200
    34.763     0.249     0.200
    34.934     1.827     0.200
    35.020     2.347     0.200
    35.028     1.611     0.200
    35.134     1.969     0.200
    35.240     2.466     0.200
    35.482     1.657     0.200
    35.610     2.368     0.200
    35.635     1.616     0.200
    35.898     0.521     0.200
    35.898     0.333     0.200
    35.876     1.856     0.200
    36.104    -1.747     0.200
    35.960     2.369     0.200
    36.079     2.159     0.200
    36.385     1.697     0.200
    36.638    -3.404     0.200
    36.638    -2.803     0.200
    36.638    -3.662     0.200
    36.891     2.722     0.200
    36.925     2.661     0.200
    37.244     1.072     0.200
    37.612     0.376     0.200
    38.173     0.844     0.200
    38.373    -2.373     0.200
    38.270     0.800     0.200
    38.347    -0.760     0.200
    38.446    -0.049     0.200
    38.647     1.209     0.200
    38.930     1.795     0.200
    39.061     1.836     0.200
    39.173     1.304     0.200
    39.452     0.188     0.200
    40.246     0.751     0.200
    40.321     2.578     0.200
    41.427     1.599     0.200
    42.156    -1.380     0.200
    42.242     2.243     0.200
    42.242     2.618     0.200
    42.360    -0.284     0.200
    42.715    -1.818     0.200
    43.167     1.625     0.200
    43.244    -0.341     0.200
    43.491     1.060     0.200
    43.739    -0.279     0.200
    44.239    -3.301     0.200
    44.270     0.271     0.200
    44.403    -1.495     0.200
    44.498     0.099     0.200
    44.616     0.983     0.200
    45.011     1.142     0.200
    45.011     1.525     0.200
    45.143    -1.362     0.200
    45.143    -2.339     0.200
    45.147    -1.393     0.200
    45.202    -0.931     0.200
    45.202    -0.134     0.200
    45.344     0.802     0.200
    45.524    -2.919     0.200
    45.897    -2.154     0.200
    45.897    -3.310     0.200
    45.817    -0.072     0.200
    45.992     0.857     0.200
    46.284    -1.800     0.200
    46.284    -2.199     0.200
    46.181     0.535     0.200
    46.181     1.410     0.200
    46.254    -0.872     0.200
    46.224    -0.911     0.200
    46.488     0.267     0.200
    46.567     0.283     0.200
    46.925    -0.927     0.200
    46.954    -0.751     0.200
    47.010    -0.286     0.200
    47.230    -1.398     0.200
    47.374    -1.009     0.200
    47.705    -1.223     0.200
    47.785    -0.341     0.200
    47.952    -1.370     0.200
    48.357    -0.103     0.200
    48.405    -0.177     0.200
    48.474    -0.532     0.200
    48.474     0.585     0.200
    48.520    -0.148     0.200
    48.804     0.159     0.200
    48.816    -0.513     0.200
    49.186     0.230     0.200
    49.577    -2.573     0.200
    49.919     0.767     0.200
    50.146    -1.003     0.200
    50.446    -0.197     0.200
    50.507     0.210     0.200
    50.523    -0.741     0.200
    50.570    -0.466     0.200
    51.236    -0.981     0.200
    51.710    -0.659     0.200
    52.822    -1.910     0.200
    52.890    -1.144     0.200
    52.751    -0.071     0.200
    52.890    -1.801     0.200
    52.887    -0.063     0.200
    53.311    -1.645     0.200
    53.874    -1.063     0.200
    53.938    -1.640     0.200
    53.938    -1.773     0.200
    53.938    -1.999     0.200
    54.213    -0.783     0.200
    54.458    -1.565     0.200
    55.343    -1.266     0.200
    55.379    -1.616     0.200
    55.379    -1.217     0.200
    55.495    -1.473     0.200
    55.495    -1.355     0.200
    55.810    -1.489     0.200
    55.810    -1.215     0.200
    55.892    -1.150     0.200
    56.037    -0.894     0.200
    56.667    -0.380     0.200
    56.826    -1.092     0.200
    57.063    -1.014     0.200
    57.061    -1.770     0.200
    57.542    -0.703     0.200
    58.408    -0.768     0.200
    58.558    -1.195     0.200
    58.711    -0.776     0.200
    59.304    -1.877     0.200
    59.304    -1.854     0.200
    59.304    -1.284     0.200
    59.304    -1.987     0.200
    59.798    -0.594     0.200
    60.165    -1.439     0.200
    60.501    -0.299     0.200
    60.814    -0.952     0.200
    61.955    -0.536     0.200
    61.973    -0.862     0.200
    61.973    -0.831     0.200
    62.060    -1.038     0.200
    62.063    -1.113     0.200
    62.101    -3.120     0.200
    62.095    -0.683     0.200
    62.103    -0.374     0.200
    62.298    -0.723     0.200
    62.461    -0.822     0.200
    62.697     0.272     0.200
    63.030     0.333     0.200
    63.039    -1.817     0.200
    63.114    -1.472     0.200
    63.151    -0.619     0.200
    63.161     0.658     0.200
    63.243    -0.558     0.200
    63.293    -2.250     0.200
    63.296    -1.122     0.200
    63.888    -2.885     0.200
    63.888    -1.979     0.200
    63.888    -1.620     0.200
    64.049    -2.034     0.200
    64.049    -1.284     0.200
    64.158    -1.859     0.200
    64.367    -2.026     0.200
    64.367    -1.206     0.200
    64.369    -2.432     0.200
    64.369    -1.408     0.200
    64.770    -0.978     0.200
    64.800    -1.349     0.200
    65.049    -0.863     0.200
    65.049    -1.566     0.200
    65.343    -1.073     0.200
    65.348    -1.002     0.200
    65.371    -1.257     0.200
    65.466    -0.385     0.200
    65.642    -0.481     0.200
    65.873    -0.958     0.200
    65.883    -0.650     0.200
    66.093    -0.473     0.200
    66.184    -0.788     0.200
    66.239    -2.240     0.200
    66.239    -1.561     0.200
    66.335    -2.255     0.200
    66.335    -1.614     0.200
    66.479    -1.614     0.200
    66.698    -2.072     0.200
    66.804    -0.949     0.200
    66.978    -0.819     0.200
    67.036    -0.360     0.200
    67.322    -1.234     0.200
    67.952    -0.858     0.200
    68.018    -1.919     0.200
    68.019    -1.387     0.200
    68.019    -1.645     0.200
    68.075    -1.965     0.200
    68.140    -1.582     0.200
    69.005    -1.582     0.200
    69.128    -0.592     0.200
    69.562    -1.522     0.200
    69.667    -1.374     0.200
    70.044     0.124     0.200
    70.234    -0.754     0.200
    70.255    -0.482     0.200
    70.333    -3.456     0.200
    70.375    -1.713     0.200
    70.388    -0.312     0.200
    70.355    -0.147     0.200
    70.355    -1.576     0.200
    70.392    -0.905     0.200
    70.505    -0.767     0.200
    70.599    -1.415     0.200
    70.617    -0.549     0.200
    70.737    -0.535     0.200
    70.797    -1.502     0.200
    70.843    -0.173     0.200
    71.026     0.265     0.200
    71.026     0.484     0.200
    71.073     0.683     0.200
    71.211    -0.495     0.200
    71.148     0.016     0.200
    71.230    -2.603     0.200
    71.357    -0.439     0.200
    71.450    -2.833     0.200
    71.443     0.087     0.200
    71.467     0.115     0.200
    71.685    -3.050     0.200
    71.775    -0.666     0.200
    71.775    -0.478     0.200
    71.775    -0.049     0.200
    71.776    -0.776     0.200
    71.776    -0.604     0.200
    71.908    -0.014     0.200
    71.908    -0.490     0.200
    71.922    -3.970     0.200
    72.114     0.004     0.200
    72.203    -0.154     0.200
    72.275    -0.006     0.200
    72.275    -0.272     0.200
    72.275     0.228     0.200
    72.322     0.035     0.200
    72.357    -0.213     0.200
    72.438     0.068     0.200
    72.521     0.121     0.200
    72.521    -0.973     0.200
    72.521    -0.152     0.200
    72.503     0.057     0.200
    72.503     0.167     0.200
    72.525    -0.201     0.200
    72.620    -0.543     0.200
    72.661    -0.384     0.200
    72.661     0.124     0.200
    72.693    -0.269     0.200
    72.730     0.208     0.200
    72.778    -1.474     0.200
    72.785    -1.985     0.200
    72.785    -1.306     0.200
    72.799    -0.101     0.200
    72.799     0.110     0.200
    72.946     0.032     0.200
    73.245    -0.337     0.200
    73.245    -0.032     0.200
    73.245     0.155     0.200
    73.243    -0.121     0.200
    73.286    -0.795     0.200
    73.341    -1.301     0.200
    73.568     0.606     0.200
    73.609     0.597     0.200
    73.581    -0.511     0.200
    73.720    -0.029     0.200
    73.811    -0.262     0.200
    73.916     1.007     0.200
    73.982    -0.836     0.200
    73.982     0.539     0.200
    73.982     0.336     0.200
    74.000    -0.565     0.200
    74.075    -0.505     0.200
    74.235     0.262     0.200
    74.276     0.251     0.200
    74.276    -0.624     0.200
    74.278    -2.035     0.200
    74.275     0.437     0.200
    74.288     0.859     0.200
    74.294    -0.194     0.200
    74.329    -0.693     0.200
    74.358    -0.004     0.200
    74.344    -0.071     0.200
    74.504     0.700     0.200
    74.504     1.341     0.200
    74.581     0.158     0.200
    74.828     2.921     0.200
    74.817    -0.014     0.200
    74.920    -0.107     0.200
    74.920     0.182     0.200
    74.969     0.213     0.200
    75.055     1.011     0.200
    75.334    -0.748     0.200
    75.367    -1.686     0.200
    75.389    -0.125     0.200
    75.389    -0.207     0.200
    75.418    -0.170     0.200
    75.549     0.142     0.200
    75.587     0.220     0.200
    75.601     0.164     0.200
    75.608     0.197     0.200
    75.701     1.807     0.200
    75.678     0.312     0.200
    75.682     0.179     0.200
    75.835     0.409     0.200
    75.924    -1.383     0.200
    75.924    -0.563     0.200
    75.924    -2.024     0.200
    75.988     0.113     0.200
    76.005    -0.226     0.200
    76.005     0.985     0.200
    76.186     0.650     0.200
    76.266    -0.390     0.200
    76.526    -0.369     0.200
    76.661    -0.529     0.200
    76.750     0.334     0.200
    76.806    -0.055     0.200
    76.852    -0.426     0.200
    77.235    -0.427     0.200
    77.358    -0.564     0.200
    77.381     0.920     0.200
    77.572    -0.064     0.200
    77.663    -1.837     0.200
    77.679     0.034     0.200
    77.689    -0.600     0.200
    77.758    -0.482     0.200
    77.884    -0.551     0.200
    78.046    -1.348     0.200
    78.130    -0.352     0.200
    78.172    -0.297     0.200
    78.172     0.367     0.200
    78.252     0.025     0.200
    78.487     0.966     0.200
    78.488    -1.073     0.200
    78.488    -0.237     0.200
    78.488     0.020     0.200
    78.685    -0.322     0.200
    78.685    -0.447     0.200
    79.481    -1.673     0.200
    79.867    -0.071     0.200
    80.794     0.748     0.200
    80.797     0.213     0.200
    81.056    -0.718     0.200
    81.056     0.095     0.200
    81.530    -0.586     0.200
    81.530    -0.352     0.200
    81.643    -1.339     0.200
    81.956    -0.095     0.200
    82.471    -0.524     0.200
    82.761     1.364     0.200
    82.885    -0.906     0.200
    83.186    -0.701     0.200
    83.470    -2.446     0.200
    83.533    -0.489     0.200
    83.534    -0.287     0.200
    83.777     0.558     0.200
    83.867     1.420     0.200
    84.241     0.876     0.200
    98.109    -0.689     0.200
    21.643    -1.407     0.200
    28.887    -0.558     0.200
    56.375    -0.868     0.200
    63.727    -1.978     0.200
    66.101    -2.287     0.200
    13.543     2.866     0.200
    17.537    -0.588     0.200
    18.451    -1.942     0.200
    20.392     0.005     0.200
    31.062     2.186     0.200
    32.291     1.591     0.200
    45.611     0.720     0.200
    54.815    -0.127     0.200
    60.684    -2.359     0.200
    13.057     3.698     0.200
    19.982    -0.466     0.200
    54.670     0.031     0.200
    64.754    -1.937     0.200
    17.962    -1.959     0.200
    20.577     0.070     0.200
    32.034     1.348     0.200
    42.389    -2.919     0.200
    47.835    -1.969     0.200
    52.666    -2.561     0.200
    53.222    -2.706     0.200
    55.336    -1.040     0.200
    58.691    -1.550     0.200
    61.271    -1.602     0.200
    61.346    -1.794     0.200
    61.346    -2.161     0.200
    62.334    -1.484     0.200
    63.534    -2.352     0.200
    63.710    -2.155     0.200
    65.218    -1.092     0.200
    65.645    -1.692     0.200
    65.645    -1.825     0.200
    65.739    -1.630     0.200
    69.693    -1.974     0.200
    72.060    -2.182     0.200
    72.707    -1.908     0.200
    73.574    -1.421     0.200
    77.973    -0.723     0.200
    80.158     0.225     0.200
    82.815    -0.901     0.200
    82.846    -1.700     0.200
    86.163     0.502     0.200
    15.281     3.519     0.200
    18.405    -0.977     0.200
    18.405    -0.315     0.200
    19.527    -2.515     0.200
    19.584     0.183     0.200
    20.402     0.295     0.200
    21.642    -0.829     0.200
    21.642    -1.061     0.200
    21.853    -2.557     0.200
    22.835    -0.516     0.200
    23.049    -0.593     0.200
    23.113    -1.208     0.200
    23.206    -0.681     0.200
    23.346    -0.553     0.200
    23.346     2.238     0.200
    24.038    -0.978     0.200
    25.296     0.083     0.200
    26.770     0.343     0.200
    27.041     0.456     0.200
    27.530    -1.180     0.200
    27.580    -0.779     0.200
    27.714    -0.700     0.200
    27.714     2.273     0.200
    27.979    -0.041     0.200
    27.958    -0.012     0.200
    28.587    -0.886     0.200
    29.085    -0.476     0.200
    29.281     2.456     0.200
    29.292     1.465     0.200
    30.313    -0.605     0.200
    30.753    -1.173     0.200
    30.753    -0.587     0.200
    30.910     0.410     0.200
    30.910    -0.571     0.200
    30.910     2.019     0.200
    31.152     2.503     0.200
    31.332     0.127     0.200
    31.517     2.589     0.200
    31.518     0.682     0.200
    32.190    -0.285     0.200
    32.257     0.836     0.200
    32.454     1.127     0.200
    32.667     0.755     0.200
    32.868     1.137     0.200
    33.063     1.405     0.200
    33.102     1.023     0.200
    33.441     1.681     0.200
    33.423     0.787     0.200
    33.423     2.191     0.200
    33.888     0.261     0.200
    33.966     0.838     0.200
    34.001     1.470     0.200
    34.167     0.723     0.200
    34.196     2.471     0.200
    34.405    -0.462     0.200
    34.405    -1.401     0.200
    34.437    -0.026     0.200
    34.562     1.129     0.200
    34.594     0.811     0.200
    35.104     2.138     0.200
    35.102    -1.102     0.200
    35.102     0.962     0.200
    35.102     1.567     0.200
    35.233     0.828     0.200
    35.726     1.806     0.200
    36.622     1.285     0.200
    37.130     2.295     0.200
    37.659     1.279     0.200
    37.679     0.328     0.200
    37.892     0.812     0.200
    37.892     2.601     0.200
    38.162     0.746     0.200
    38.330     0.622     0.200
    38.343     0.511     0.200
    38.634     0.320     0.200
    39.051     1.235     0.200
    39.467     0.725     0.200
    39.467     0.495     0.200
    39.978     0.910     0.200
    40.369     0.305     0.200
    40.369     0.953     0.200
    40.814     0.435     0.200
    40.898     0.169     0.200
    41.265    -1.971     0.200
    41.221     2.223     0.200
    41.221     3.170     0.200
    41.532     0.296     0.200
    41.666     0.542     0.200
    42.349    -0.646     0.200
    42.521     0.711     0.200
    42.521     2.070     0.200
    43.651    -1.120     0.200
    43.841     0.648     0.200
    43.841     1.097     0.200
    43.841     0.767     0.200
    43.988     1.843     0.200
    44.115    -0.880     0.200
    44.115    -0.430     0.200
    44.321     0.593     0.200
    45.181     0.811     0.200
    45.287    -1.873     0.200
    45.552    -0.326     0.200
    45.552     0.127     0.200
    45.602    -0.465     0.200
    45.606     0.420     0.200
    45.816     0.420     0.200
    45.933    -0.642     0.200
    45.933    -1.431     0.200
    45.977     0.585     0.200
    45.992     0.274     0.200
    45.992     1.354     0.200
    46.138    -1.417     0.200
    47.133    -0.996     0.200
    47.593     0.935     0.200
    47.902    -1.274     0.200
    47.902    -1.162     0.200
    47.897    -0.449     0.200
    48.271    -0.725     0.200
    48.681    -0.233     0.200
    48.742    -0.813     0.200
    48.764     0.030     0.200
    48.916    -0.590     0.200
    48.917    -0.392     0.200
    48.917    -0.283     0.200
    49.457     0.287     0.200
    49.734    -0.615     0.200
    49.821    -1.157     0.200
    49.821    -0.741     0.200
    50.618    -1.534     0.200
    53.870    -1.501     0.200
    53.905    -0.593     0.200
    53.905    -1.224     0.200
    54.439    -0.751     0.200
    56.533    -0.332     0.200
    56.533    -0.502     0.200
    56.545     0.643     0.200
    56.847    -1.123     0.200
    56.847    -0.181     0.200
    58.911     0.359     0.200
    59.759     0.509     0.200
    60.251    -0.735     0.200
    60.251    -0.866     0.200
    60.251    -0.565     0.200
    60.695    -2.402     0.200
    60.842     0.299     0.200
    61.034     0.368     0.200
    61.835     0.416     0.200
    62.344    -0.231     0.200
    62.344    -0.182     0.200
    62.568    -0.765     0.200
    62.821    -2.515     0.200
    63.430    -0.539     0.200
    64.669    -1.579     0.200
    64.669    -0.939     0.200
    64.741    -0.318     0.200
    64.982    -1.329     0.200
    64.982    -0.530     0.200
    65.091    -0.748     0.200
    65.241    -0.983     0.200
    65.241    -0.614     0.200
    65.244    -0.743     0.200
    65.243     1.041     0.200
    65.561     0.359     0.200
    65.745     0.406     0.200
    66.084     0.057     0.200
    67.083    -0.062     0.200
    67.206    -1.566     0.200
    67.206    -1.426     0.200
    67.206    -0.826     0.200
    67.301    -1.427     0.200
    67.301    -0.817     0.200
    68.504    -0.608     0.200
    68.504     0.591     0.200
    69.287     1.457     0.200
    70.083     0.763     0.200
    70.370     1.567     0.200
    70.614     1.494     0.200
    70.689     1.224     0.200
    70.963     0.412     0.200
    71.106     1.410     0.200
    71.196    -0.889     0.200
    71.359    -0.064     0.200
    71.408    -0.048     0.200
    71.518     0.685     0.200
    71.551    -0.221     0.200
    71.805     0.689     0.200
    71.790     1.191     0.200
    72.045     1.769     0.200
    72.063    -0.979     0.200
    72.102    -1.460     0.200
    72.166     0.347     0.200
    72.125     1.141     0.200
    72.138    -0.136     0.200
    72.159     0.026     0.200
    72.195     0.892     0.200
    72.312     0.405     0.200
    72.373     0.091     0.200
    72.402     0.284     0.200
    72.687     0.336     0.200
    72.668     0.738     0.200
    72.668     0.574     0.200
    72.746     0.911     0.200
    73.040     0.212     0.200
    73.131    -0.387     0.200
    73.089     0.811     0.200
    73.176     0.101     0.200
    73.154     0.431     0.200
    73.317    -1.108     0.200
    73.324    -0.457     0.200
    73.324    -0.666     0.200
    73.344     0.907     0.200
    73.464     0.217     0.200
    73.464     1.258     0.200
    73.648     0.619     0.200
    73.648     0.257     0.200
    73.826    -0.095     0.200
    73.967     0.059     0.200
    73.974     1.390     0.200
    73.993    -0.683     0.200
    73.993     0.299     0.200
    74.093     0.715     0.200
    74.209    -0.226     0.200
    74.259    -0.756     0.200
    74.259    -0.896     0.200
    74.347     0.831     0.200
    74.400    -0.959     0.200
    74.400     0.524     0.200
    74.523     1.325     0.200
    74.528     0.778     0.200
    74.632     0.377     0.200
    74.632    -0.164     0.200
    74.641     0.698     0.200
    74.658     1.042     0.200
    74.717     0.583     0.200
    74.720     1.864     0.200
    74.915     1.338     0.200
    74.935    -1.068     0.200
    75.050     1.459     0.200
    75.277     0.380     0.200
    75.344     0.865     0.200
    75.344     1.275     0.200
    75.375     1.387     0.200
    75.375     1.598     0.200
    75.723     0.981     0.200
    75.790     3.809     0.200
    75.781     0.539     0.200
    75.855     0.689     0.200
    75.880     0.839     0.200
    75.898    -1.375     0.200
    75.938     1.046     0.200
    75.958     0.948     0.200
    75.970     1.621     0.200
    75.981     1.133     0.200
    76.102    -1.272     0.200
    76.014     0.945     0.200
    76.015     1.130     0.200
    76.161     0.981     0.200
    76.363     1.304     0.200
    76.372     0.981     0.200
    76.421    -0.167     0.200
    76.506     1.275     0.200
    76.611     1.354     0.200
    76.613     0.991     0.200
    76.903     1.141     0.200
    77.032     0.765     0.200
    77.103    -0.329     0.200
    77.108    -2.082     0.200
    77.324    -1.369     0.200
    77.607     0.277     0.200
    77.690    -0.491     0.200
    77.945    -0.767     0.200
    78.070    -0.731     0.200
    78.177    -0.782     0.200
    78.192    -1.144     0.200
    78.218    -0.581     0.200
    78.294    -1.091     0.200
    78.338    -0.286     0.200
    78.551    -0.605     0.200
    78.597    -0.311     0.200
    78.598    -0.469     0.200
    78.662    -0.698     0.200
    78.662     0.511     0.200
    78.858    -1.095     0.200
    78.990     1.298     0.200
    79.099    -0.544     0.200
    79.176    -0.946     0.200
    79.176     0.296     0.200
    79.176    -0.425     0.200
    79.293    -0.241     0.200
    79.376     0.661     0.200
    79.574    -1.259     0.200
    80.903     0.850     0.200
    81.827     0.546     0.200
    82.022    -0.317     0.200
    82.377     0.302     0.200
    84.131     0.163     0.200
    84.231    -0.043     0.200
    84.865     1.138     0.200
    18.441    -0.509     0.200
    19.621     0.225     0.200
    20.431     0.430     0.200
    21.662    -1.233     0.200
    22.641    -1.868     0.200
    29.277     2.510     0.200
    30.916     1.735     0.200
    32.903     0.343     0.200
    32.934    -0.119     0.200
    34.429    -1.025     0.200
    38.367    -0.704     0.200
    38.380     0.009     0.200
    43.878     0.555     0.200
    43.878     0.684     0.200
    43.988     2.204     0.200
    44.152    -0.883     0.200
    44.357     0.643     0.200
    45.639     0.010     0.200
    45.846     0.674     0.200
    45.971    -0.767     0.200
    46.029    -0.137     0.200
    47.161    -0.653     0.200
    47.161    -0.323     0.200
    53.904     0.156     0.200
    53.904    -0.645     0.200
    54.475    -0.335     0.200
    56.546    -1.282     0.200
    56.860     0.078     0.200
    56.860     0.537     0.200
    59.767     1.613     0.200
    60.274    -0.095     0.200
    60.274    -0.075     0.200
    60.274     0.085     0.200
    60.483    -0.276     0.200
    60.847     0.225     0.200
    62.381    -0.220     0.200
    62.381     0.231     0.200
    62.604    -0.012     0.200
    63.467     0.152     0.200
    64.699    -1.575     0.200
    65.006    -0.762     0.200
    65.115    -0.165     0.200
    65.268    -0.724     0.200
    65.271    -0.130     0.200
    66.121     0.411     0.200
    67.228    -0.548     0.200
    67.228     0.002     0.200
    67.228    -0.398     0.200
    71.225    -0.625     0.200
    72.175     0.122     0.200
    73.353    -0.596     0.200
    74.284     0.111     0.200
    74.284    -0.018     0.200
    74.678     0.431     0.200
    75.381     1.227     0.200
    75.760     0.896     0.200
    75.812     4.058     0.200
    75.975     0.595     0.200
    76.018     1.184     0.200
    76.052     1.204     0.200
    76.053     1.079     0.200
    76.198     1.222     0.200
    76.400     1.177     0.200
    76.940     0.899     0.200
    77.069     0.741     0.200
    79.296    -0.392     0.200
    79.409     1.209     0.200
    80.940     1.450     0.200
    82.405     0.745     0.200
    84.166     0.868     0.200
    84.236     0.112     0.200
    15.143     3.231     0.200
    18.510    -0.612     0.200
    28.019     0.036     0.200
    30.886     2.678     0.200
    43.944     3.413     0.200
    44.240    -0.297     0.200
    47.255     0.867     0.200
    56.933     0.998     0.200
    62.472     1.211     0.200
    65.204     0.566     0.200
    65.364     0.684     0.200
    66.206     1.079     0.200
    71.320    -0.476     0.200
    74.770     1.291     0.200
    81.020     0.870     0.200
    19.227    -0.724     0.200
    42.234    -2.796     0.200
    43.713    -2.139     0.200
    60.686    -2.088     0.200
    20.257     0.457     0.200
    31.010     0.763     0.200
    32.207     0.976     0.200
    54.840     1.045     0.200
    18.954    -2.854     0.200
    20.702    -1.103     0.200
    20.702    -0.984     0.200
    21.478     0.738     0.200
    24.988    -1.042     0.200
    29.362     0.571     0.200
    30.880     0.235     0.200
    32.171     0.944     0.200
    32.251     0.298     0.200
    32.251     0.538     0.200
    34.821    -0.568     0.200
    38.507    -0.779     0.200
    45.492     0.679     0.200
    55.109    -1.065     0.200
    63.520    -2.757     0.200
    80.140     0.061     0.200
    18.319     9.783     0.200
    66.296    -2.349     0.200
    19.730    -1.655     0.200
    21.476    -0.967     0.200
    43.766    -0.812     0.200
    44.988    -1.693     0.200
    53.841    -1.520     0.200
    54.154    -0.956     0.200
    56.814    -0.006     0.200
    60.006    -0.322     0.200
    61.694    -0.169     0.200
    62.788     0.052     0.200
    64.825    -0.601     0.200
    64.907    -0.661     0.200
    65.389    -0.057     0.200
    66.993    -0.562     0.200
    72.735    -0.563     0.200
    83.577     0.642     0.200
    84.358    -0.070     0.200
    19.090    -0.509     0.200
    21.090    -1.436     0.200
    16.558     1.694     0.200
    17.928    -1.162     0.200
    18.299    -1.204     0.200
    19.278     0.464     0.200
    20.141    -0.047     0.200
    20.141    -0.511     0.200
    20.892    -0.429     0.200
    24.372     2.351     0.200
    24.751     2.899     0.200
    25.943    -2.237     0.200
    26.034     1.199     0.200
    28.005     1.565     0.200
    30.741     2.715     0.200
    32.188     1.782     0.200
    32.205     1.102     0.200
    32.205     1.930     0.200
    32.953    -2.858     0.200
    34.270     2.348     0.200
    34.293     1.387     0.200
    34.293     1.520     0.200
    34.911     0.278     0.200
    36.142    -3.264     0.200
    36.142    -2.955     0.200
    38.597    -0.283     0.200
    39.936    -1.318     0.200
    39.937    -1.278     0.200
    41.057    -1.511     0.200
    41.057    -0.972     0.200
    41.697    -2.447     0.200
    42.295    -2.014     0.200
    43.807     0.466     0.200
    45.392     1.349     0.200
    45.510    -2.608     0.200
    45.683    -1.036     0.200
    45.761    -3.612     0.200
    45.761    -2.339     0.200
    46.203    -0.863     0.200
    46.468    -2.145     0.200
    47.648    -1.927     0.200
    47.648    -2.269     0.200
    47.648    -1.371     0.200
    48.807    -1.453     0.200
    49.166    -2.436     0.200
    52.524    -1.092     0.200
    52.524    -1.034     0.200
    53.255    -1.975     0.200
    53.488    -2.486     0.200
    53.597    -1.068     0.200
    54.702    -1.763     0.200
    54.910    -1.958     0.200
    55.012    -1.197     0.200
    55.326    -0.695     0.200
    55.326    -0.855     0.200
    58.781    -1.841     0.200
    58.781    -1.517     0.200
    61.563    -1.139     0.200
    61.563    -1.241     0.200
    61.610    -1.737     0.200
    62.621    -1.543     0.200
    62.730     0.054     0.200
    63.276    -0.521     0.200
    63.372    -2.589     0.200
    63.372    -2.300     0.200
    63.372    -1.890     0.200
    63.526    -1.831     0.200
    63.526    -1.612     0.200
    63.526    -0.999     0.200
    63.635    -1.678     0.200
    63.844    -1.783     0.200
    64.252    -1.356     0.200
    64.594    -1.313     0.200
    65.533    -0.470     0.200
    65.720    -1.974     0.200
    65.720    -1.669     0.200
    65.816    -1.552     0.200
    67.538    -2.069     0.200
    68.607    -0.473     0.200
    69.854    -1.431     0.200
    69.854    -1.560     0.200
    69.868    -0.956     0.200
    69.981    -1.221     0.200
    70.034    -0.728     0.200
    70.323    -1.064     0.200
    70.689    -1.764     0.200
    70.689    -0.967     0.200
    70.627    -0.344     0.200
    70.835    -0.579     0.200
    71.223    -0.828     0.200
    71.366    -0.761     0.200
    71.707     0.281     0.200
    71.998    -0.453     0.200
    71.998    -0.094     0.200
    72.212    -0.570     0.200
    72.315    -1.969     0.200
    72.315    -2.043     0.200
    72.323    -2.098     0.200
    72.323    -1.578     0.200
    72.526     0.016     0.200
    72.752     0.140     0.200
    72.816    -0.748     0.200
    72.816    -0.959     0.200
    72.816    -0.748     0.200
    72.868     0.768     0.200
    73.573    -0.076     0.200
    73.573     0.725     0.200
    73.560    -0.080     0.200
    73.804    -1.089     0.200
    73.834    -0.523     0.200
    73.857     0.964     0.200
    73.866    -0.517     0.200
    74.308     2.938     0.200
    74.491    -0.323     0.200
    74.546     0.759     0.200
    74.917    -0.156     0.200
    75.151     0.263     0.200
    75.202     0.541     0.200
    75.278     0.102     0.200
    75.284     0.045     0.200
    75.439     0.205     0.200
    75.445    -1.133     0.200
    75.474    -1.132     0.200
    75.502    -0.441     0.200
    75.598     0.160     0.200
    76.113     0.251     0.200
    76.249    -0.454     0.200
    77.342    -0.426     0.200
    77.723    -0.858     0.200
    77.840    -0.204     0.200
    77.989    -0.441     0.200
    77.989    -0.230     0.200
    78.186    -0.880     0.200
    78.207    -0.246     0.200
    78.324    -1.096     0.200
    80.482     0.535     0.200
    80.482     0.082     0.200
    80.537    -0.204     0.200
    82.760    -1.219     0.200
    82.760    -1.000     0.200
    82.760    -0.769     0.200
    83.055    -0.703     0.200
    83.055    -1.174     0.200
    83.055    -0.396     0.200
    83.373     1.120     0.200
    19.166    -0.948     0.200
    30.186     0.490     0.200
    31.215     1.070     0.200
    44.630     0.231     0.200
    52.133    -3.519     0.200
    55.508    -2.213     0.200
    58.415    -2.517     0.200
    60.262    -2.778     0.200
    63.210    -4.148     0.200
    63.874    -2.106     0.200
    65.434    -2.684     0.200
    71.014    -3.603     0.200
    78.764    -1.365     0.200
    98.070    -2.651     0.200
    15.910     1.255     0.200
    16.091     1.296     0.200
    16.454     1.598     0.200
    16.957     1.839     0.200
    18.323    -2.924     0.200
    18.690    -0.894     0.200
    20.974    -1.271     0.200
    20.962     0.250     0.200
    20.974    -2.235     0.200
    20.974    -1.735     0.200
    23.863     0.556     0.200
    24.154     1.879     0.200
    26.682    -2.201     0.200
    26.682    -1.837     0.200
    26.682    -1.337     0.200
    26.682    -1.580     0.200
    26.707    -3.465     0.200
    26.677     0.451     0.200
    27.014     2.495     0.200
    27.160     0.157     0.200
    27.160    -1.581     0.200
    27.160    -3.093     0.200
    28.298    -1.488     0.200
    28.532     1.680     0.200
    28.797    -0.173     0.200
    29.266     0.073     0.200
    30.091     2.338     0.200
    30.876     1.542     0.200
    31.403     2.484     0.200
    31.568     1.022     0.200
    31.708     2.179     0.200
    31.723     1.598     0.200
    33.807    -2.154     0.200
    33.807    -1.916     0.200
    33.807    -1.756     0.200
    33.898     1.438     0.200
    33.898     1.950     0.200
    34.709    -0.730     0.200
    34.721     0.464     0.200
    35.841     0.626     0.200
    36.195     1.579     0.200
    36.321    -1.564     0.200
    36.712     1.195     0.200
    36.761     1.579     0.200
    36.936    -2.968     0.200
    36.936    -2.707     0.200
    38.253    -0.118     0.200
    38.402     0.111     0.200
    38.402     0.502     0.200
    38.424    -0.203     0.200
    38.476     1.376     0.200
    38.705     2.351     0.200
    38.981     0.864     0.200
    38.981     1.352     0.200
    38.981     1.895     0.200
    39.620    -2.375     0.200
    39.666    -1.044     0.200
    39.666    -2.313     0.200
    39.856     0.752     0.200
    39.905     1.539     0.200
    40.111     1.587     0.200
    40.302    -1.338     0.200
    40.387     0.084     0.200
    40.448    -1.870     0.200
    40.449    -1.479     0.200
    40.449    -1.854     0.200
    41.103    -0.878     0.200
    41.534    -0.779     0.200
    41.535    -0.804     0.200
    41.535    -0.284     0.200
    41.535    -0.964     0.200
    41.535    -0.073     0.200
    41.889    -1.929     0.200
    42.040     1.906     0.200
    42.422    -2.426     0.200
    43.333     1.249     0.200
    43.521    -0.414     0.200
    43.977     0.094     0.200
    43.977     0.395     0.200
    44.113    -0.970     0.200
    44.113    -0.834     0.200
    44.363    -0.879     0.200
    44.491    -3.587     0.200
    44.573    -1.122     0.200
    44.573     0.186     0.200
    44.573     0.557     0.200
    44.573     0.065     0.200
    44.596     0.293     0.200
    44.596    -0.945     0.200
    44.596     0.633     0.200
    44.807     1.593     0.200
    45.097    -0.722     0.200
    45.449    -0.658     0.200
    45.449    -0.545     0.200
    45.632    -1.641     0.200
    45.663     1.637     0.200
    45.723    -1.472     0.200
    45.743     0.046     0.200
    45.826    -2.882     0.200
    45.966    -1.439     0.200
    46.108    -3.641     0.200
    46.183    -0.333     0.200
    46.237    -0.167     0.200
    46.340    -0.456     0.200
    46.354    -0.357     0.200
    46.620    -0.939     0.200
    46.620    -1.119     0.200
    46.620    -1.818     0.200
    46.887    -0.787     0.200
    46.978     1.147     0.200
    47.088    -2.579     0.200
    47.462    -2.486     0.200
    47.702     0.045     0.200
    47.702    -0.341     0.200
    47.902     0.821     0.200
    48.105    -1.604     0.200
    48.105    -1.201     0.200
    48.105    -1.369     0.200
    48.105    -2.170     0.200
    48.105    -1.689     0.200
    48.086    -0.000     0.200
    48.370     0.356     0.200
    48.373     0.173     0.200
    48.840    -1.776     0.200
    48.887    -1.727     0.200
    48.975    -1.981     0.200
    49.262    -1.056     0.200
    49.215    -0.053     0.200
    49.457    -0.631     0.200
    49.807    -2.705     0.200
    49.875    -1.424     0.200
    50.293    -1.632     0.200
    50.427     0.164     0.200
    50.428     0.240     0.200
    50.535    -0.002     0.200
    50.535    -0.509     0.200
    50.535    -0.213     0.200
    50.674     1.853     0.200
    53.051    -1.539     0.200
    53.086    -1.281     0.200
    53.133    -1.395     0.200
    53.627    -0.915     0.200
    54.023    -0.965     0.200
    54.070    -0.632     0.200
    54.181    -0.463     0.200
    54.251    -1.165     0.200
    54.251    -1.306     0.200
    54.431    -0.966     0.200
    54.468    -0.835     0.200
    54.675    -2.064     0.200
    54.675    -0.740     0.200
    54.768    -1.153     0.200
    55.363    -0.664     0.200
    55.527    -1.588     0.200
    55.644    -0.664     0.200
    55.781    -0.835     0.200
    55.781    -1.003     0.200
    56.097    -0.626     0.200
    56.077    -3.023     0.200
    56.193    -0.822     0.200
    56.350    -0.730     0.200
    57.124    -0.541     0.200
    57.350    -0.536     0.200
    57.361    -1.544     0.200
    57.857    -0.037     0.200
    58.720    -0.612     0.200
    58.853    -0.540     0.200
    58.968    -0.767     0.200
    59.630    -1.130     0.200
    59.630    -1.040     0.200
    59.907    -1.247     0.200
    60.036    -0.933     0.200
    60.002    -1.370     0.200
    60.453    -0.108     0.200
    60.757    -0.762     0.200
    60.788    -0.134     0.200
    60.803    -0.740     0.200
    61.104    -0.787     0.200
    61.165    -0.570     0.200
    61.651    -0.835     0.200
    61.705    -0.737     0.200
    62.003    -0.471     0.200
    62.265    -0.728     0.200
    62.265    -0.478     0.200
    62.273    -0.472     0.200
    62.376    -0.916     0.200
    62.383    -0.346     0.200
    62.385    -0.279     0.200
    62.427    -2.113     0.200
    62.435    -0.142     0.200
    62.591    -1.016     0.200
    62.768    -0.796     0.200
    62.981    -0.333     0.200
    63.321    -0.285     0.200
    63.334    -0.737     0.200
    63.388    -0.694     0.200
    63.450    -0.908     0.200
    63.445    -0.271     0.200
    63.515    -0.347     0.200
    63.515    -0.124     0.200
    63.515     0.223     0.200
    63.607    -0.710     0.200
    63.626    -1.766     0.200
    63.990     0.038     0.200
    64.252    -0.592     0.200
    64.296    -1.670     0.200
    64.296    -1.369     0.200
    64.378    -0.166     0.200
    64.378    -1.006     0.200
    64.378    -0.596     0.200
    64.390    -0.387     0.200
    64.390    -0.285     0.200
    64.487    -1.219     0.200
    64.588     0.044     0.200
    64.701    -1.194     0.200
    64.701    -1.015     0.200
    64.701    -0.757     0.200
    64.703    -1.056     0.200
    64.734    -0.121     0.200
    64.780    -0.325     0.200
    64.780    -0.622     0.200
    65.089     0.039     0.200
    65.111    -0.119     0.200
    65.111    -0.440     0.200
    65.281    -0.101     0.200
    65.566    -0.929     0.200
    65.589    -1.373     0.200
    65.653    -0.989     0.200
    65.760    -0.256     0.200
    65.934    -0.545     0.200
    66.006     1.112     0.200
    66.143    -0.141     0.200
    66.152    -0.233     0.200
    66.152     0.056     0.200
    66.181    -0.181     0.200
    66.386    -0.493     0.200
    66.449    -0.598     0.200
    66.561    -1.012     0.200
    66.561    -1.012     0.200
    66.657    -1.171     0.200
    66.636     0.498     0.200
    66.636    -0.041     0.200
    66.812     0.320     0.200
    66.815     0.107     0.200
    66.820     0.366     0.200
    66.833    -0.210     0.200
    66.993    -0.366     0.200
    67.115    -0.841     0.200
    67.276    -0.857     0.200
    67.570    -1.801     0.200
    67.648    -2.309     0.200
    67.852     0.145     0.200
    67.973    -1.488     0.200
    68.191    -1.122     0.200
    68.236     0.063     0.200
    68.309    -1.052     0.200
    68.329     0.050     0.200
    68.329    -0.302     0.200
    68.322    -0.256     0.200
    68.343    -1.374     0.200
    68.343    -0.984     0.200
    68.343    -0.862     0.200
    68.410    -0.455     0.200
    68.457     0.064     0.200
    68.483     0.284     0.200
    68.944     0.161     0.200
    69.234     0.576     0.200
    69.234     0.475     0.200
    69.258    -0.080     0.200
    69.321    -0.456     0.200
    69.453     0.059     0.200
    69.818    -0.908     0.200
    69.818    -0.799     0.200
    69.895    -1.496     0.200
    70.072    -0.529     0.200
    70.257     0.681     0.200
    70.343    -0.638     0.200
    70.329     0.361     0.200
    70.329    -0.201     0.200
    70.378    -0.013     0.200
    70.589     0.408     0.200
    70.589    -0.198     0.200
    70.641     0.229     0.200
    70.682    -1.308     0.200
    70.660    -3.372     0.200
    70.711     0.357     0.200
    70.714    -0.729     0.200
    70.705     0.264     0.200
    70.834    -0.458     0.200
    70.818     0.178     0.200
    70.905    -0.373     0.200
    70.958     0.440     0.200
    70.958     0.659     0.200
    71.166     0.362     0.200
    71.166     0.260     0.200
    71.312     0.488     0.200
    71.312    -0.176     0.200
    71.389     0.052     0.200
    71.535    -0.048     0.200
    71.558    -2.607     0.200
    71.567     0.490     0.200
    71.681    -0.020     0.200
    71.664    -0.072     0.200
    71.732     0.079     0.200
    71.749     0.208     0.200
    71.781    -3.247     0.200
    72.013    -3.341     0.200
    72.073    -0.053     0.200
    72.059     0.137     0.200
    72.065     0.166     0.200
    72.066    -0.356     0.200
    72.066    -0.145     0.200
    72.234     0.648     0.200
    72.250    -3.058     0.200
    72.281     0.076     0.200
    72.289     0.074     0.200
    72.289    -0.230     0.200
    72.367    -0.758     0.200
    72.407    -0.794     0.200
    72.406    -0.041     0.200
    72.441     0.267     0.200
    72.568    -0.102     0.200
    72.568     0.007     0.200
    72.610     0.155     0.200
    72.683     0.452     0.200
    72.720     0.297     0.200
    72.750     0.246     0.200
    72.750    -0.433     0.200
    72.750     0.035     0.200
    72.795     0.198     0.200
    72.845    -0.498     0.200
    72.815     0.038     0.200
    72.848     0.307     0.200
    72.848    -0.115     0.200
    72.955    -0.053     0.200
    72.955     0.311     0.200
    72.990    -0.056     0.200
    73.005     0.370     0.200
    73.005     0.608     0.200
    73.031     0.101     0.200
    73.058     0.367     0.200
    73.068    -0.118     0.200
    73.068     0.042     0.200
    73.089     0.157     0.200
    73.095    -1.330     0.200
    73.095    -1.381     0.200
    73.089     0.317     0.200
    73.103    -1.361     0.200
    73.103    -1.658     0.200
    73.103    -1.111     0.200
    73.243     0.150     0.200
    73.243     0.010     0.200
    73.270    -0.913     0.200
    73.306    -0.138     0.200
    73.459     0.417     0.200
    73.491    -0.212     0.200
    73.491     0.089     0.200
    73.520     0.383     0.200
    73.521    -1.435     0.200
    73.520     0.379     0.200
    73.521     0.425     0.200
    73.534    -0.294     0.200
    73.534    -0.466     0.200
    73.532     0.098     0.200
    73.562     0.962     0.200
    73.543     0.084     0.200
    73.569     0.321     0.200
    73.601     0.743     0.200
    73.582    -0.042     0.200
    73.772     0.070     0.200
    73.849    -0.011     0.200
    73.856     0.328     0.200
    73.881    -0.497     0.200
    73.881    -2.149     0.200
    73.881    -0.094     0.200
    73.917     0.320     0.200
    73.977     0.231     0.200
    74.013     0.229     0.200
    74.137     0.088     0.200
    74.198    -0.034     0.200
    74.198    -0.347     0.200
    74.198     0.075     0.200
    74.206     0.179     0.200
    74.206     0.347     0.200
    74.232     0.124     0.200
    74.232     0.245     0.200
    74.244    -1.718     0.200
    74.274     0.208     0.200
    74.298    -0.429     0.200
    74.298     0.126     0.200
    74.305     0.327     0.200
    74.352     0.214     0.200
    74.352     0.054     0.200
    74.352     0.335     0.200
    74.351    -0.047     0.200
    74.381    -0.314     0.200
    74.413     0.002     0.200
    74.532    -0.587     0.200
    74.532    -0.080     0.200
    74.567    -0.102     0.200
    74.567    -0.020     0.200
    74.567     0.155     0.200
    74.575    -1.655     0.200
    74.575    -0.089     0.200
    74.591     0.869     0.200
    74.637    -0.199     0.200
    74.689     0.050     0.200
    74.803     0.640     0.200
    74.803     1.101     0.200
    74.888     0.248     0.200
    74.888     0.448     0.200
    74.913     0.388     0.200
    75.038     0.193     0.200
    75.038     0.326     0.200
    75.051     0.111     0.200
    75.076     0.309     0.200
    75.151     3.233     0.200
    75.135     0.626     0.200
    75.151    -0.367     0.200
    75.221     0.029     0.200
    75.221     0.201     0.200
    75.267     0.667     0.200
    75.304    -0.644     0.200
    75.282    -0.721     0.200
    75.293    -0.281     0.200
    75.293     0.406     0.200
    75.370     0.345     0.200
    75.405     0.121     0.200
    75.405     0.235     0.200
    75.445    -1.154     0.200
    75.502     0.278     0.200
    75.596     0.147     0.200
    75.596     0.248     0.200
    75.600    -0.146     0.200
    75.630     0.269     0.200
    75.661    -0.112     0.200
    75.683    -1.611     0.200
    75.683    -1.420     0.200
    75.696     0.176     0.200
    75.710    -0.142     0.200
    75.772     0.152     0.200
    75.838     0.948     0.200
    75.838     0.550     0.200
    75.835     0.083     0.200
    75.838     0.288     0.200
    75.878     0.469     0.200
    75.884     0.312     0.200
    75.888     0.136     0.200
    75.897     0.038     0.200
    75.965     0.398     0.200
    75.965     0.534     0.200
    75.968     0.344     0.200
    76.096     0.470     0.200
    76.120     0.377     0.200
    76.168    -1.524     0.200
    76.236    -0.216     0.200
    76.283     0.297     0.200
    76.296     0.597     0.200
    76.296     0.753     0.200
    76.354    -0.119     0.200
    76.470     0.955     0.200
    76.481     0.340     0.200
    76.481     0.481     0.200
    76.521     0.521     0.200
    76.521     0.810     0.200
    76.555    -0.322     0.200
    76.684     0.648     0.200
    76.763     0.435     0.200
    76.765    -0.370     0.200
    76.820    -0.079     0.200
    76.836    -0.240     0.200
    76.868    -0.078     0.200
    76.945    -0.504     0.200
    76.954     0.095     0.200
    77.031     0.031     0.200
    77.039    -0.336     0.200
    77.039     0.102     0.200
    77.103    -0.754     0.200
    77.129    -0.338     0.200
    77.161    -0.251     0.200
    77.157     1.236     0.200
    77.177     0.420     0.200
    77.219    -0.742     0.200
    77.352    -0.398     0.200
    77.477    -0.029     0.200
    77.488    -0.825     0.200
    77.488    -0.520     0.200
    77.488    -0.289     0.200
    77.541    -0.410     0.200
    77.606     1.412     0.200
    77.664     0.799     0.200
    77.664     1.607     0.200
    77.634     0.619     0.200
    77.690    -0.146     0.200
    77.775    -0.503     0.200
    77.795     0.011     0.200
    77.884     0.219     0.200
    77.891     0.235     0.200
    77.977    -0.169     0.200
    77.994    -0.258     0.200
    77.993    -0.117     0.200
    78.011    -0.032     0.200
    77.999     1.535     0.200
    78.003     0.198     0.200
    78.065     0.023     0.200
    78.151    -0.278     0.200
    78.196    -0.416     0.200
    78.176    -0.493     0.200
    78.190    -1.387     0.200
    78.190    -0.524     0.200
    78.190    -0.262     0.200
    78.197    -3.892     0.200
    78.190     0.278     0.200
    78.371     0.857     0.200
    78.359     0.530     0.200
    78.359     0.745     0.200
    78.397    -0.965     0.200
    78.393     0.353     0.200
    78.415    -0.729     0.200
    78.415     0.138     0.200
    78.415    -0.151     0.200
    78.421    -0.384     0.200
    78.438    -0.350     0.200
    78.482    -0.225     0.200
    78.483     0.096     0.200
    78.509     0.851     0.200
    78.539     1.330     0.200
    78.597    -0.170     0.200
    78.621    -0.681     0.200
    78.644    -0.979     0.200
    78.638     0.308     0.200
    78.675     0.902     0.200
    78.820     0.448     0.200
    78.820    -0.497     0.200
    78.820     0.304     0.200
    78.896     0.118     0.200
    78.917    -0.018     0.200
    78.943    -0.934     0.200
    78.939     0.556     0.200
    78.960    -1.296     0.200
    79.018     0.422     0.200
    79.018    -0.078     0.200
    79.027    -0.042     0.200
    79.038     0.310     0.200
    79.122    -0.650     0.200
    79.136    -0.129     0.200
    79.166     0.611     0.200
    79.279    -0.403     0.200
    79.358    -0.999     0.200
    79.476     0.393     0.200
    79.548     0.629     0.200
    79.548    -0.043     0.200
    79.548     0.820     0.200
    79.610    -0.406     0.200
    79.652     0.463     0.200
    80.091     0.588     0.200
    80.096     0.265     0.200
    80.173    -1.278     0.200
    80.357     0.528     0.200
    80.508     0.048     0.200
    80.532    -0.680     0.200
    80.651    -0.220     0.200
    80.812    -0.658     0.200
    80.995    -0.055     0.200
    81.037     0.547     0.200
    81.065    -0.526     0.200
    81.079     0.072     0.200
    81.079     0.611     0.200
    81.230     0.583     0.200
    81.213     0.086     0.200
    81.292    -0.414     0.200
    81.292    -0.176     0.200
    81.388    -0.142     0.200
    81.729     0.061     0.200
    81.784     0.564     0.200
    81.833     0.512     0.200
    81.970    -3.021     0.200
    81.975     0.465     0.200
    82.062     0.108     0.200
    82.082    -0.431     0.200
    82.220     0.180     0.200
    82.341     0.249     0.200
    82.351     0.962     0.200
    82.397    -0.309     0.200
    82.457     0.741     0.200
    82.667     0.179     0.200
    82.735    -0.091     0.200
    82.704     0.168     0.200
    82.828     1.224     0.200
    83.223    -2.779     0.200
    83.359     0.620     0.200
    83.426    -0.823     0.200
    83.414    -0.301     0.200
    83.722    -0.983     0.200
    83.765     0.686     0.200
    83.765     0.924     0.200
    83.851     0.149     0.200
    83.858    -0.307     0.200
    83.858     0.013     0.200
    83.866     0.267     0.200
    83.917     0.950     0.200
    84.184     0.151     0.200
    84.399    -0.634     0.200
    84.454     0.646     0.200
    84.429     0.378     0.200
    85.714    -0.586     0.200
    85.790     1.037     0.200
    87.124     0.453     0.200
    88.632     0.306     0.200
    96.397    -2.574     0.200
    20.677     0.561     0.200
    27.624    -0.831     0.200
    45.581    -0.971     0.200
    46.946    -0.898     0.200
    48.558    -2.846     0.200
    54.402    -1.002     0.200
    56.540    -0.610     0.200
    60.012    -1.098     0.200
    62.530    -0.936     0.200
    63.435    -0.403     0.200
    64.587    -1.205     0.200
    64.861    -0.703     0.200
    65.045    -0.663     0.200
    66.156    -0.068     0.200
    66.955    -0.943     0.200
    70.306    -0.800     0.200
    73.228     0.199     0.200
    73.266    -1.120     0.200
    74.656    -0.168     0.200
    81.008     0.787     0.200
    83.890    -0.220     0.200
    84.057    -0.173     0.200
    15.206     1.801     0.200
    20.209    -0.321     0.200
    20.209    -0.626     0.200
    22.475     0.203     0.200
    24.050     1.659     0.200
    24.880     1.645     0.200
    26.374    -2.361     0.200
    26.756     0.306     0.200
    27.630     0.070     0.200
    27.630    -1.770     0.200
    28.075     2.712     0.200
    28.198    -0.890     0.200
    28.198    -0.691     0.200
    28.198    -0.031     0.200
    30.044     2.935     0.200
    30.941     3.334     0.200
    31.137     2.549     0.200
    31.410     3.085     0.200
    32.703    -1.446     0.200
    32.763    -1.966     0.200
    33.080     0.990     0.200
    33.080     2.589     0.200
    34.358     2.703     0.200
    35.812     2.280     0.200
    36.194     1.832     0.200
    36.383    -1.069     0.200
    36.413    -2.465     0.200
    36.413    -1.354     0.200
    36.413    -2.154     0.200
    37.954     0.683     0.200
    38.335    -0.821     0.200
    38.454     0.183     0.200
    38.610     2.877     0.200
    39.849    -0.475     0.200
    39.871     0.799     0.200
    41.740     2.954     0.200
    41.931     0.126     0.200
    41.931    -1.365     0.200
    42.107    -1.011     0.200
    42.107    -2.611     0.200
    42.107    -1.220     0.200
    42.244    -0.629     0.200
    42.713     1.517     0.200
    43.556    -1.703     0.200
    43.945    -2.672     0.200
    43.945    -1.101     0.200
    44.138    -0.959     0.200
    44.138     0.701     0.200
    44.456    -2.637     0.200
    44.552    -0.480     0.200
    44.518     1.840     0.200
    45.249    -1.843     0.200
    45.327    -2.754     0.200
    45.327    -2.553     0.200
    45.734    -0.163     0.200
    46.442     0.939     0.200
    46.868    -0.267     0.200
    46.868    -1.687     0.200
    47.401     1.064     0.200
    47.592    -1.795     0.200
    48.013     1.452     0.200
    48.810    -0.177     0.200
    48.810    -1.476     0.200
    49.956    -1.609     0.200
    52.394    -2.493     0.200
    53.491    -0.797     0.200
    55.384     0.020     0.200
    55.384    -0.170     0.200
    55.687    -0.670     0.200
    57.318    -1.635     0.200
    58.644    -1.320     0.200
    58.644    -1.329     0.200
    58.644    -1.534     0.200
    58.865    -0.446     0.200
    59.773    -1.308     0.200
    60.102    -0.863     0.200
    60.307    -1.969     0.200
    60.307    -1.170     0.200
    60.307    -1.394     0.200
    60.523    -1.388     0.200
    60.635     1.202     0.200
    60.703    -3.460     0.200
    61.390    -1.470     0.200
    61.545    -0.862     0.200
    62.027    -0.496     0.200
    62.311    -0.801     0.200
    62.837    -1.900     0.200
    63.334    -1.435     0.200
    63.334    -1.996     0.200
    63.334    -2.195     0.200
    63.443    -2.056     0.200
    63.470    -1.373     0.200
    63.470    -2.494     0.200
    63.470    -2.084     0.200
    63.475    -2.399     0.200
    63.466    -0.264     0.200
    64.113    -0.620     0.200
    64.227    -1.369     0.200
    65.296    -1.022     0.200
    65.586    -1.290     0.200
    65.657    -1.749     0.200
    65.657    -2.473     0.200
    65.746    -1.506     0.200
    65.746    -1.387     0.200
    65.916    -2.917     0.200
    66.267    -0.569     0.200
    66.383     0.395     0.200
    66.601    -1.495     0.200
    66.601    -1.796     0.200
    67.258     0.126     0.200
    67.485    -2.406     0.200
    68.307    -1.563     0.200
    68.449     0.618     0.200
    68.496    -1.243     0.200
    68.597    -0.359     0.200
    68.662    -0.439     0.200
    68.662    -0.572     0.200
    68.933    -0.716     0.200
    68.933    -0.216     0.200
    68.953    -1.285     0.200
    69.003    -0.206     0.200
    69.003     0.044     0.200
    69.334     0.165     0.200
    69.334     0.454     0.200
    69.393     0.091     0.200
    69.393    -0.386     0.200
    69.586     0.291     0.200
    69.759    -0.137     0.200
    69.784    -1.619     0.200
    69.784    -1.518     0.200
    69.784    -1.118     0.200
    69.809    -2.068     0.200
    69.856    -0.862     0.200
    69.894     0.299     0.200
    69.961    -1.101     0.200
    70.024    -0.198     0.200
    70.047     0.529     0.200
    70.055    -0.200     0.200
    70.055    -0.679     0.200
    70.094    -0.405     0.200
    70.094     0.019     0.200
    70.104    -1.277     0.200
    70.104    -0.822     0.200
    70.104    -0.518     0.200
    70.114    -1.741     0.200
    70.150    -0.250     0.200
    70.193     0.014     0.200
    70.239    -1.203     0.200
    70.307    -0.386     0.200
    70.307     0.336     0.200
    70.312    -3.653     0.200
    70.372    -0.058     0.200
    70.398    -0.218     0.200
    70.398     0.133     0.200
    70.511     0.323     0.200
    70.552    -2.210     0.200
    70.579    -1.378     0.200
    70.577    -1.263     0.200
    70.510    -0.761     0.200
    70.612     0.004     0.200
    70.612    -0.277     0.200
    70.612    -0.621     0.200
    70.638    -0.037     0.200
    70.638    -0.301     0.200
    70.611    -0.872     0.200
    70.655    -1.239     0.200
    70.728     0.014     0.200
    70.728    -0.107     0.200
    70.762    -0.693     0.200
    70.811    -0.455     0.200
    70.811    -0.186     0.200
    70.835     0.069     0.200
    70.835     0.179     0.200
    70.943     0.024     0.200
    71.001     0.693     0.200
    71.001     0.419     0.200
    71.003    -0.152     0.200
    71.003     0.049     0.200
    71.049    -0.228     0.200
    71.062    -1.508     0.200
    71.058    -1.285     0.200
    71.091    -0.283     0.200
    71.122     0.229     0.200
    71.126    -0.298     0.200
    71.203    -1.862     0.200
    71.276    -1.850     0.200
    71.276    -3.000     0.200
    71.283    -1.747     0.200
    71.283    -1.775     0.200
    71.283    -1.943     0.200
    71.303     0.033     0.200
    71.303     0.234     0.200
    71.336    -0.292     0.200
    71.484     0.237     0.200
    71.538    -0.178     0.200
    71.544    -0.016     0.200
    71.544    -0.362     0.200
    71.544    -0.006     0.200
    71.545    -0.021     0.200
    71.562    -0.099     0.200
    71.594    -0.217     0.200
    71.606     0.009     0.200
    71.622    -0.619     0.200
    71.622    -1.088     0.200
    71.629    -0.089     0.200
    71.643    -0.743     0.200
    71.798     0.541     0.200
    71.806    -0.490     0.200
    71.841    -0.741     0.200
    71.841    -1.102     0.200
    71.923    -0.192     0.200
    71.944     0.010     0.200
    71.950    -0.951     0.200
    71.950    -0.137     0.200
    71.950    -0.551     0.200
    72.057    -0.289     0.200
    72.073    -2.086     0.200
    72.240     0.015     0.200
    72.243    -0.001     0.200
    72.243    -0.138     0.200
    72.313     0.081     0.200
    72.313     0.182     0.200
    72.313    -0.119     0.200
    72.359    -0.592     0.200
    72.359    -0.092     0.200
    72.374    -0.176     0.200
    72.376     0.003     0.200
    72.444     0.079     0.200
    72.444    -0.101     0.200
    72.444    -0.302     0.200
    72.482    -0.625     0.200
    72.551     0.064     0.200
    72.580    -0.328     0.200
    72.591    -0.676     0.200
    72.591    -0.176     0.200
    72.607     0.033     0.200
    72.607    -0.192     0.200
    72.607    -0.918     0.200
    72.675     0.226     0.200
    72.681    -0.508     0.200
    72.782    -1.608     0.200
    72.774     0.628     0.200
    72.836     0.170     0.200
    72.828    -0.282     0.200
    72.872     0.758     0.200
    72.947     0.118     0.200
    72.998     0.415     0.200
    72.998     0.185     0.200
    73.033     0.307     0.200
    73.060     0.248     0.200
    73.060    -0.012     0.200
    73.156    -0.419     0.200
    73.202     0.110     0.200
    73.269    -0.485     0.200
    73.300    -0.366     0.200
    73.300    -0.045     0.200
    73.333     0.241     0.200
    73.368     0.533     0.200
    73.386    -0.171     0.200
    73.386     0.148     0.200
    73.401    -1.263     0.200
    73.419    -0.184     0.200
    73.419     0.142     0.200
    73.552    -1.545     0.200
    73.601     0.002     0.200
    73.592    -1.281     0.200
    73.642    -0.317     0.200
    73.642    -0.163     0.200
    73.672    -1.154     0.200
    73.679    -0.158     0.200
    73.684     0.123     0.200
    73.747    -0.115     0.200
    73.784     0.603     0.200
    73.808    -0.198     0.200
    73.855    -0.216     0.200
    73.855    -1.843     0.200
    73.911     0.083     0.200
    73.925     0.290     0.200
    73.925    -1.015     0.200
    73.927     0.007     0.200
    73.925     0.659     0.200
    73.941     0.326     0.200
    73.989     0.297     0.200
    73.988     0.412     0.200
    74.088     0.680     0.200
    74.137     0.534     0.200
    74.221     2.341     0.200
    74.288    -0.447     0.200
    74.330     0.227     0.200
    74.334    -0.411     0.200
    74.334     0.093     0.200
    74.334     0.300     0.200
    74.345    -0.758     0.200
    74.375    -0.641     0.200
    74.375    -0.749     0.200
    74.484     0.758     0.200
    74.529     0.796     0.200
    74.548     0.365     0.200
    74.583    -0.180     0.200
    74.801    -0.410     0.200
    74.866     0.066     0.200
    74.871    -0.423     0.200
    74.893    -0.643     0.200
    74.914    -0.322     0.200
    74.980    -0.560     0.200
    74.996     0.021     0.200
    75.067    -1.305     0.200
    75.108    -0.447     0.200
    75.117    -0.671     0.200
    75.151    -1.248     0.200
    75.151    -0.736     0.200
    75.208    -1.081     0.200
    75.254    -1.387     0.200
    75.277    -0.508     0.200
    75.267    -1.001     0.200
    75.374    -0.487     0.200
    75.486    -1.107     0.200
    75.486    -1.597     0.200
    75.563    -0.420     0.200
    75.598     0.802     0.200
    75.643    -0.454     0.200
    75.937    -1.430     0.200
    75.937     0.371     0.200
    75.937    -0.219     0.200
    75.941    -0.205     0.200
    75.962    -0.173     0.200
    76.024    -0.285     0.200
    76.065    -1.154     0.200
    76.126    -1.034     0.200
    76.132    -0.670     0.200
    76.132     0.162     0.200
    76.144    -0.209     0.200
    76.147    -0.159     0.200
    76.146    -0.109     0.200
    76.149    -1.522     0.200
    76.152    -0.401     0.200
    76.171    -0.633     0.200
    76.292    -0.510     0.200
    76.325    -1.184     0.200
    76.347     0.664     0.200
    76.425    -0.920     0.200
    76.505     0.248     0.200
    76.505     0.629     0.200
    76.508    -1.043     0.200
    76.517     0.701     0.200
    76.551    -0.533     0.200
    76.551    -1.327     0.200
    76.615    -0.306     0.200
    76.615    -0.111     0.200
    76.799    -1.042     0.200
    76.815    -0.807     0.200
    76.879    -0.282     0.200
    76.892     0.877     0.200
    77.033    -0.794     0.200
    77.052    -1.494     0.200
    77.077    -1.073     0.200
    77.119     0.871     0.200
    77.129    -0.693     0.200
    77.118    -1.173     0.200
    77.133    -1.341     0.200
    77.193    -1.211     0.200
    77.193    -0.846     0.200
    77.292    -0.234     0.200
    77.276     0.713     0.200
    77.394    -0.572     0.200
    77.394    -0.947     0.200
    77.411    -0.440     0.200
    77.525    -0.655     0.200
    77.532    -1.314     0.200
    77.532    -0.715     0.200
    77.547     0.299     0.200
    77.578    -1.573     0.200
    77.606     0.273     0.200
    77.773    -1.633     0.200
    78.049     0.768     0.200
    78.274    -1.077     0.200
    78.391    -0.658     0.200
    78.608    -0.007     0.200
    78.608     0.183     0.200
    78.949     0.136     0.200
    78.992     0.171     0.200
    78.999    -0.918     0.200
    79.167     0.526     0.200
    79.341     0.618     0.200
    79.369    -1.317     0.200
    79.473     0.168     0.200
    79.738     0.910     0.200
    79.785     0.508     0.200
    79.897     0.319     0.200
    80.016     0.589     0.200
    80.175     0.221     0.200
    80.175     0.551     0.200
    80.296    -0.358     0.200
    80.311     0.802     0.200
    80.412     1.149     0.200
    80.463    -0.484     0.200
    80.612     0.106     0.200
    80.614     0.655     0.200
    80.710     0.941     0.200
    80.710     0.531     0.200
    80.710     1.191     0.200
    80.758    -0.131     0.200
    80.777     0.773     0.200
    80.845    -0.095     0.200
    80.941    -1.780     0.200
    80.941    -1.960     0.200
    80.985    -0.125     0.200
    81.268     0.914     0.200
    81.298     0.195     0.200
    81.555     0.348     0.200
    81.574    -0.348     0.200
    81.635    -0.585     0.200
    81.999    -0.098     0.200
    82.104    -0.835     0.200
    82.104    -0.786     0.200
    82.237     0.308     0.200
    82.680    -0.967     0.200
    82.689     0.603     0.200
    83.158    -0.559     0.200
    83.464    -1.234     0.200
    83.654    -0.779     0.200
    83.736     0.262     0.200
    84.292     0.442     0.200
    85.119    -0.315     0.200
    86.588     1.358     0.200
    88.682    -0.477     0.200
    96.951     0.034     0.200
    16.018     0.884     0.200
    17.782    -1.663     0.200
    18.752    -1.182     0.200
    19.592     0.211     0.200
    19.729    -0.370     0.200
    19.729    -0.570     0.200
    24.017     1.695     0.200
    24.017     1.531     0.200
    25.885     2.541     0.200
    27.123    -1.601     0.200
    27.679    -0.713     0.200
    27.679    -1.510     0.200
    29.970     2.004     0.200
    30.563     1.760     0.200
    30.804     0.630     0.200
    31.456     0.770     0.200
    31.646     1.156     0.200
    31.930     1.789     0.200
    32.325    -2.636     0.200
    32.325    -2.136     0.200
    33.572     0.661     0.200
    33.572     1.747     0.200
    33.880    -0.170     0.200
    33.880     0.095     0.200
    33.880     0.330     0.200
    34.864    -0.738     0.200
    35.092     0.073     0.200
    35.351     1.152     0.200
    35.351     1.300     0.200
    35.351     1.745     0.200
    35.915    -2.692     0.200
    35.915    -2.380     0.200
    36.329     0.858     0.200
    36.763    -0.377     0.200
    37.567     0.416     0.200
    37.681    -1.191     0.200
    37.726    -0.322     0.200
    38.465     0.456     0.200
    38.656     1.939     0.200
    39.107     1.784     0.200
    39.126     1.644     0.200
    40.391     1.376     0.200
    42.031    -1.863     0.200
    42.258     1.863     0.200
    43.219     1.067     0.200
    43.382    -2.700     0.200
    43.937    -2.959     0.200
    44.189    -1.241     0.200
    44.634    -0.868     0.200
    44.833    -0.557     0.200
    44.937    -2.506     0.200
    44.964    -2.806     0.200
    45.037     1.283     0.200
    46.078    -0.208     0.200
    46.078    -0.013     0.200
    46.183    -0.777     0.200
    46.952     0.756     0.200
    47.072    -1.394     0.200
    47.874    -0.489     0.200
    48.315    -0.893     0.200
    50.355    -0.958     0.200
    52.198    -1.279     0.200
    52.978    -0.593     0.200
    53.871    -1.786     0.200
    54.879    -1.141     0.200
    54.879    -0.821     0.200
    55.182    -0.537     0.200
    58.199    -2.378     0.200
    58.199    -2.448     0.200
    58.347    -0.353     0.200
    59.644     0.025     0.200
    60.181    -2.705     0.200
    60.326    -2.868     0.200
    61.253    -2.656     0.200
    62.899    -2.602     0.200
    62.899    -2.415     0.200
    63.008    -2.394     0.200
    63.070    -2.894     0.200
    63.070    -2.597     0.200
    63.074    -2.577     0.200
    64.075    -2.017     0.200
    64.789    -0.672     0.200
    65.201    -2.445     0.200
    65.752    -0.995     0.200
    68.972    -2.968     0.200
    71.061    -2.964     0.200
    71.163    -1.296     0.200
    72.483    -1.639     0.200
    72.517    -0.807     0.200
    73.146    -1.228     0.200
    73.770     1.814     0.200
    74.748    -0.468     0.200
    76.648    -1.925     0.200
    76.690    -2.340     0.200
    77.099    -1.499     0.200
    78.089    -0.726     0.200
    79.000    -0.790     0.200
    80.374    -0.654     0.200
    81.859    -1.899     0.200
    82.944    -1.547     0.200
    97.637    -1.221     0.200
    19.474    -0.507     0.200
    44.712    -1.112     0.200
    44.894    -2.884     0.200
    58.178    -2.474     0.200
    62.982    -2.932     0.200
    63.035    -2.929     0.200
    65.185    -2.854     0.200
    72.381    -1.987     0.200
    78.884    -1.379     0.200
    13.915     4.255     0.200
    15.620     1.932     0.200
    16.009     1.789     0.200
    16.174     1.196     0.200
    16.607     1.483     0.200
    17.369    -1.399     0.200
    17.369    -2.155     0.200
    18.279    -1.973     0.200
    19.425     0.157     0.200
    19.425    -0.523     0.200
    20.254     0.106     0.200
    20.643     1.759     0.200
    20.729     1.809     0.200
    21.100     2.015     0.200
    21.708     2.190     0.200
    22.122     2.584     0.200
    22.798     1.606     0.200
    23.182     3.004     0.200
    24.245     1.963     0.200
    24.432     1.979     0.200
    24.622     2.084     0.200
    24.698     2.430     0.200
    24.720     0.979     0.200
    24.762     1.900     0.200
    24.818     3.158     0.200
    24.966     2.797     0.200
    25.434    -0.570     0.200
    26.069     0.634     0.200
    26.372     3.812     0.200
    26.524    -0.863     0.200
    26.524    -1.474     0.200
    27.193     0.120     0.200
    27.193     0.319     0.200
    27.193     0.629     0.200
    27.328    -0.427     0.200
    27.837     2.980     0.200
    28.645     2.299     0.200
    28.979     1.168     0.200
    28.979    -1.543     0.200
    29.167     2.009     0.200
    29.167     2.558     0.200
    30.963     1.182     0.200
    31.060     2.208     0.200
    31.443     3.442     0.200
    32.123    -0.586     0.200
    32.034     2.763     0.200
    32.245     1.854     0.200
    32.435     2.742     0.200
    32.451     0.875     0.200
    34.203     2.245     0.200
    34.203     2.095     0.200
    34.550     0.693     0.200
    35.511    -0.838     0.200
    35.542    -0.913     0.200
    35.542    -1.304     0.200
    35.542    -1.454     0.200
    35.542    -1.692     0.200
    35.469     0.287     0.200
    35.759     0.840     0.200
    36.793    -2.612     0.200
    36.895     2.066     0.200
    37.300     1.890     0.200
    37.344     1.369     0.200
    37.912     0.961     0.200
    37.912     1.323     0.200
    37.912    -0.279     0.200
    38.170    -0.809     0.200
    38.170    -0.139     0.200
    38.238     1.361     0.200
    38.378    -0.886     0.200
    38.703    -2.001     0.200
    39.056     0.683     0.200
    39.622     2.750     0.200
    39.622     3.270     0.200
    39.691     1.341     0.200
    39.691     1.809     0.200
    39.691     2.430     0.200
    39.898    -1.144     0.200
    40.140     0.592     0.200
    40.424    -1.175     0.200
    40.931     0.921     0.200
    41.265    -1.153     0.200
    42.005    -1.278     0.200
    42.005    -2.878     0.200
    42.385    -3.354     0.200
    42.385    -2.114     0.200
    42.393     0.509     0.200
    42.346     1.973     0.200
    42.475     2.163     0.200
    42.516     1.504     0.200
    42.780     2.204     0.200
    42.811     2.604     0.200
    43.041     2.000     0.200
    43.083     1.862     0.200
    43.105     0.677     0.200
    43.210    -1.220     0.200
    43.210    -0.259     0.200
    43.441    -2.960     0.200
    43.431     0.373     0.200
    43.618    -2.198     0.200
    43.745     2.569     0.200
    43.825     1.959     0.200
    43.843     2.011     0.200
    44.007     1.158     0.200
    44.017     1.641     0.200
    44.177     0.274     0.200
    44.178     1.966     0.200
    44.223     0.875     0.200
    44.401    -2.031     0.200
    44.427     1.652     0.200
    44.670    -0.724     0.200
    44.786     0.169     0.200
    44.837    -1.338     0.200
    44.837    -1.563     0.200
    44.827    -1.028     0.200
    44.837     0.384     0.200
    45.017    -0.782     0.200
    45.191    -0.167     0.200
    45.323    -1.877     0.200
    45.281     0.444     0.200
    45.281    -0.396     0.200
    45.381     0.184     0.200
    45.476    -0.093     0.200
    45.588     1.962     0.200
    45.835     1.392     0.200
    46.242    -0.242     0.200
    46.445    -0.438     0.200
    46.541    -0.981     0.200
    46.559     1.783     0.200
    46.671     0.362     0.200
    46.706     1.105     0.200
    46.848    -0.283     0.200
    46.903    -0.799     0.200
    47.033    -0.302     0.200
    47.546     0.759     0.200
    47.612     0.671     0.200
    47.688    -0.893     0.200
    47.688     1.327     0.200
    47.688     0.222     0.200
    47.688     0.023     0.200
    47.688    -0.387     0.200
    47.742    -0.492     0.200
    47.742    -0.801     0.200
    47.822    -2.148     0.200
    47.753     0.675     0.200
    47.753     0.126     0.200
    47.753     0.485     0.200
    47.897     1.278     0.200
    48.151     0.315     0.200
    48.344     0.394     0.200
    48.415     0.684     0.200
    48.576     0.907     0.200
    48.525     0.742     0.200
    48.525     0.382     0.200
    48.611     1.154     0.200
    48.671     1.807     0.200
    48.758     0.510     0.200
    48.850     0.408     0.200
    48.902    -2.284     0.200
    48.972     2.381     0.200
    49.120     1.299     0.200
    49.120     1.969     0.200
    49.276     1.069     0.200
    49.869     1.914     0.200
    49.978     2.665     0.200
    50.311    -0.069     0.200
    50.311     0.271     0.200
    50.673     0.381     0.200
    51.326     0.260     0.200
    51.575     0.026     0.200
    51.580    -0.564     0.200
    51.570     2.462     0.200
    51.780     0.548     0.200
    52.404    -3.379     0.200
    52.360     0.712     0.200
    52.396    -0.546     0.200
    52.322     1.022     0.200
    52.346     0.231     0.200
    52.671     0.379     0.200
    52.682     0.549     0.200
    53.244     0.484     0.200
    54.049    -0.489     0.200
    54.125    -1.539     0.200
    54.047     0.546     0.200
    54.164    -1.276     0.200
    54.171     0.375     0.200
    54.474     0.330     0.200
    54.360     1.780     0.200
    54.512     0.811     0.200
    54.781    -0.465     0.200
    56.289    -0.464     0.200
    56.310    -0.307     0.200
    57.869     0.219     0.200
    57.980    -1.529     0.200
    58.785    -1.645     0.200
    58.945    -1.584     0.200
    59.066    -0.385     0.200
    59.806    -1.783     0.200
    60.474    -2.712     0.200
    60.474    -2.913     0.200
    60.527    -2.853     0.200
    60.560    -2.700     0.200
    60.518    -1.198     0.200
    60.518    -1.516     0.200
    60.518    -0.617     0.200
    60.932    -1.711     0.200
    60.973     0.063     0.200
    61.231    -0.037     0.200
    61.532    -3.075     0.200
    61.626    -1.792     0.200
    61.763    -1.575     0.200
    61.767    -2.232     0.200
    62.465    -2.889     0.200
    62.428    -0.846     0.200
    62.463    -1.031     0.200
    62.701    -0.709     0.200
    62.701    -1.488     0.200
    62.810    -2.232     0.200
    62.824    -1.209     0.200
    62.944    -0.948     0.200
    62.944    -1.448     0.200
    62.947    -1.588     0.200
    62.947    -2.139     0.200
    63.504    -0.457     0.200
    63.513    -2.015     0.200
    63.965    -1.840     0.200
    64.144    -1.590     0.200
    64.344    -1.595     0.200
    64.375    -1.558     0.200
    64.466    -1.146     0.200
    64.592    -1.947     0.200
    64.566    -1.402     0.200
    64.566    -0.863     0.200
    64.724     0.078     0.200
    64.953    -2.013     0.200
    64.953    -1.962     0.200
    65.047    -0.955     0.200
    65.047    -1.593     0.200
    65.090    -0.993     0.200
    65.194    -2.245     0.200
    65.294    -0.811     0.200
    65.282     0.419     0.200
    65.467    -1.872     0.200
    65.535    -1.980     0.200
    65.602     0.008     0.200
    66.476    -2.082     0.200
    66.487    -0.571     0.200
    66.637     0.255     0.200
    66.757    -2.066     0.200
    66.645     1.956     0.200
    67.458    -0.210     0.200
    67.468    -3.351     0.200
    67.819    -0.654     0.200
    67.978    -1.803     0.200
    68.038    -3.026     0.200
    68.185    -2.446     0.200
    68.793    -2.826     0.200
    68.833    -0.107     0.200
    68.869    -0.656     0.200
    68.906    -2.323     0.200
    69.093    -0.476     0.200
    69.107    -0.863     0.200
    69.126    -0.811     0.200
    69.163    -0.759     0.200
    69.263    -0.430     0.200
    69.441    -0.420     0.200
    69.540    -0.408     0.200
    69.547    -0.176     0.200
    69.609    -1.055     0.200
    69.639    -0.196     0.200
    69.691    -2.857     0.200
    69.901    -0.541     0.200
    69.836     0.052     0.200
    69.915    -2.729     0.200
    69.991    -0.066     0.200
    70.047    -0.633     0.200
    70.146    -3.339     0.200
    70.277    -1.238     0.200
    70.277    -0.990     0.200
    70.284    -0.356     0.200
    70.295    -0.844     0.200
    70.320    -0.480     0.200
    70.357    -0.033     0.200
    70.383    -2.681     0.200
    70.425    -0.696     0.200
    70.434    -1.999     0.200
    70.476    -0.724     0.200
    70.586    -1.411     0.200
    70.586     0.299     0.200
    70.619    -0.475     0.200
    70.662    -1.773     0.200
    70.657    -0.795     0.200
    70.675    -0.844     0.200
    70.774    -0.514     0.200
    70.774    -0.815     0.200
    70.783    -0.726     0.200
    70.831    -0.878     0.200
    70.929    -0.402     0.200
    70.943    -0.904     0.200
    70.964    -0.511     0.200
    71.030     0.040     0.200
    71.045    -2.089     0.200
    71.112    -0.796     0.200
    71.126    -0.532     0.200
    71.158    -0.873     0.200
    71.168    -2.731     0.200
    71.180    -2.602     0.200
    71.185    -0.730     0.200
    71.190    -0.084     0.200
    71.190    -0.305     0.200
    71.190    -0.693     0.200
    71.218    -2.636     0.200
    71.225    -0.673     0.200
    71.238    -2.579     0.200
    71.238    -2.653     0.200
    71.245    -2.511     0.200
    71.245    -2.767     0.200
    71.263    -1.002     0.200
    71.268     0.455     0.200
    71.392    -0.068     0.200
    71.436    -0.943     0.200
    71.436    -0.643     0.200
    71.525    -0.737     0.200
    71.589    -2.059     0.200
    71.694    -0.993     0.200
    71.710    -1.083     0.200
    71.745    -0.290     0.200
    71.746    -0.230     0.200
    71.750    -0.461     0.200
    71.899     0.505     0.200
    71.920    -1.842     0.200
    71.924    -0.463     0.200
    71.905    -0.353     0.200
    71.971    -1.344     0.200
    72.054    -1.938     0.200
    72.067    -1.018     0.200
    72.067    -0.774     0.200
    72.184    -0.810     0.200
    72.234     0.891     0.200
    72.360    -1.472     0.200
    72.360    -1.361     0.200
    72.421    -0.097     0.200
    72.473    -0.025     0.200
    72.484    -0.995     0.200
    72.484    -0.595     0.200
    72.490    -1.127     0.200
    72.490    -0.610     0.200
    72.526    -0.041     0.200
    72.550    -1.588     0.200
    72.725    -1.323     0.200
    72.776    -0.420     0.200
    72.777    -0.551     0.200
    72.777    -1.578     0.200
    72.823    -1.168     0.200
    72.823    -0.182     0.200
    72.870    -0.774     0.200
    72.955    -0.377     0.200
    72.989    -0.578     0.200
    72.990    -0.182     0.200
    73.053    -0.454     0.200
    73.265    -0.570     0.200
    73.294    -1.372     0.200
    73.323    -0.442     0.200
    73.388    -2.620     0.200
    73.432    -2.282     0.200
    73.456    -0.321     0.200
    73.461    -0.952     0.200
    73.466    -0.177     0.200
    73.532     2.036     0.200
    73.539    -1.006     0.200
    73.641    -0.240     0.200
    73.658    -1.404     0.200
    73.758    -0.987     0.200
    73.808    -0.976     0.200
    73.807    -0.357     0.200
    73.828    -2.719     0.200
    73.827    -0.430     0.200
    73.893    -0.738     0.200
    73.921    -0.862     0.200
    74.013    -0.204     0.200
    74.010     0.265     0.200
    74.064    -0.613     0.200
    74.079    -0.425     0.200
    74.114    -0.420     0.200
    74.190    -0.162     0.200
    74.197    -0.138     0.200
    74.257    -1.288     0.200
    74.328    -1.638     0.200
    74.352    -0.130     0.200
    74.390    -1.653     0.200
    74.483     0.328     0.200
    74.510    -0.599     0.200
    74.764     0.084     0.200
    74.775     0.249     0.200
    74.920    -0.061     0.200
    74.939     0.678     0.200
    74.977     0.045     0.200
    75.023    -0.727     0.200
    75.032    -1.715     0.200
    75.160    -0.323     0.200
    75.202    -1.117     0.200
    75.322    -1.093     0.200
    75.389    -1.498     0.200
    75.671    -0.633     0.200
    75.671    -0.908     0.200
    75.709    -0.801     0.200
    75.828    -0.801     0.200
    75.734     0.535     0.200
    75.736     0.825     0.200
    75.907    -0.556     0.200
    75.922    -0.376     0.200
    75.922    -0.531     0.200
    75.946    -0.116     0.200
    76.037     0.021     0.200
    76.126    -2.325     0.200
    76.126    -1.190     0.200
    76.143    -0.740     0.200
    76.153     0.121     0.200
    76.231    -1.467     0.200
    76.296    -0.466     0.200
    76.367     0.148     0.200
    76.436    -0.673     0.200
    76.504    -0.523     0.200
    76.506    -0.013     0.200
    76.510     0.180     0.200
    76.556    -1.471     0.200
    76.569    -0.408     0.200
    76.569    -0.589     0.200
    76.639    -0.708     0.200
    76.789    -1.587     0.200
    76.876    -0.528     0.200
    76.958    -0.783     0.200
    76.958    -0.316     0.200
    76.870     0.821     0.200
    77.103    -0.477     0.200
    77.108    -1.590     0.200
    77.156    -1.330     0.200
    77.281    -0.819     0.200
    77.177     1.404     0.200
    77.502    -1.477     0.200
    77.502    -1.008     0.200
    77.563    -0.347     0.200
    78.110     1.113     0.200
    78.341    -1.629     0.200
    78.541     0.782     0.200
    78.556     0.649     0.200
    78.685    -1.233     0.200
    79.111     0.436     0.200
    79.437    -0.759     0.200
    79.447     0.211     0.200
    79.767     0.083     0.200
    80.233     0.729     0.200
    80.303    -1.255     0.200
    80.434     0.502     0.200
    80.666    -0.935     0.200
    80.819     0.054     0.200
    80.820     1.364     0.200
    81.900     0.141     0.200
    81.985    -0.691     0.200
    81.992    -0.378     0.200
    81.992    -1.479     0.200
    81.879    -0.342     0.200
    82.000    -0.572     0.200
    82.009    -0.519     0.200
    82.133    -0.733     0.200
    82.437    -1.399     0.200
    82.563    -0.344     0.200
    83.348     0.155     0.200
    83.622     1.255     0.200
    84.098     0.435     0.200
    85.386    -0.918     0.200
    85.863    -0.378     0.200
    87.684    -0.403     0.200
    88.532    -0.284     0.200
    90.800     0.601     0.200
    90.863     0.508     0.200
    91.064    -0.023     0.200
    91.623    -0.612     0.200
    91.764    -0.139     0.200
    91.764    -0.503     0.200
    91.764     0.136     0.200
    92.178    -0.378     0.200
    92.417    -0.378     0.200
    95.079    -0.905     0.200
    96.971    -2.093     0.200
    18.973    -0.284     0.200
    20.415    -0.917     0.200
    24.297     3.226     0.200
    25.194     3.243     0.200
    27.103    -2.675     0.200
    30.290     2.418     0.200
    31.702     1.176     0.200
    44.614    -2.412     0.200
    44.914     1.033     0.200
    45.747    -1.081     0.200
    55.702    -1.329     0.200
    59.034    -1.975     0.200
    61.426    -1.374     0.200
    62.495    -1.881     0.200
    63.873    -2.421     0.200
    64.031    -2.162     0.200
    65.314    -1.804     0.200
    65.993    -2.229     0.200
    72.272    -2.192     0.200
    74.576     2.046     0.200
    83.047    -0.747     0.200
    83.207    -1.387     0.200
    19.167    -0.293     0.200
    60.888    -2.262     0.200
    61.713    -2.171     0.200
    63.924    -3.103     0.200
    63.947    -2.627     0.200
    66.141    -2.625     0.200
    13.796     1.945     0.200
    13.796     2.047     0.200
    15.444     1.494     0.200
    15.814     1.592     0.200
    16.537     1.019     0.200
    17.099    -2.581     0.200
    17.099    -3.206     0.200
    18.002    -2.203     0.200
    18.002    -2.641     0.200
    18.238    -0.760     0.200
    19.201    -0.735     0.200
    19.330     0.590     0.200
    19.329    -1.111     0.200
    20.029    -0.104     0.200
    20.646    -0.774     0.200
    22.749    -0.985     0.200
    23.136     0.257     0.200
    24.254    -1.138     0.200
    26.151    -2.120     0.200
    26.151    -0.331     0.200
    26.341     0.262     0.200
    26.602    -2.277     0.200
    26.602    -2.035     0.200
    27.191    -1.478     0.200
    27.191    -0.595     0.200
    28.286     0.110     0.200
    30.743    -0.278     0.200
    31.987    -1.145     0.200
    31.987    -0.715     0.200
    32.166     0.983     0.200
    34.380     0.253     0.200
    35.480    -1.529     0.200
    35.480    -1.825     0.200
    35.480    -4.232     0.200
    36.516    -2.867     0.200
    37.984    -1.665     0.200
    37.984    -0.744     0.200
    38.067     0.804     0.200
    38.067     1.483     0.200
    38.256    -2.702     0.200
    38.993    -0.223     0.200
    39.984    -1.014     0.200
    41.170    -0.448     0.200
    42.773    -0.016     0.200
    42.935    -1.686     0.200
    42.935    -2.045     0.200
    42.935    -1.053     0.200
    43.362    -3.109     0.200
    43.445    -2.742     0.200
    43.994    -2.892     0.200
    44.751    -0.233     0.200
    44.963    -2.505     0.200
    45.152     0.029     0.200
    45.233    -1.497     0.200
    45.233    -0.505     0.200
    45.372    -2.431     0.200
    45.372    -2.205     0.200
    45.372    -2.408     0.200
    45.443    -1.224     0.200
    45.485     1.166     0.200
    45.547     1.376     0.200
    45.547     0.696     0.200
    46.281    -1.789     0.200
    46.481     0.319     0.200
    46.568    -1.528     0.200
    46.639    -0.967     0.200
    46.982    -1.570     0.200
    46.982    -1.695     0.200
    47.419     0.315     0.200
    47.424    -0.182     0.200
    47.698    -0.185     0.200
    47.794    -0.522     0.200
    47.794    -1.170     0.200
    47.793    -1.019     0.200
    47.793     0.390     0.200
    48.034     0.658     0.200
    48.227     0.287     0.200
    48.460     0.907     0.200
    48.505     0.090     0.200
    48.572     0.613     0.200
    48.715    -1.519     0.200
    48.753    -0.128     0.200
    48.764     0.242     0.200
    48.931    -1.534     0.200
    48.956    -0.716     0.200
    49.028     0.178     0.200
    49.171    -0.829     0.200
    49.184     0.932     0.200
    49.327     0.728     0.200
    50.131     0.621     0.200
    51.316    -0.904     0.200
    52.153    -3.001     0.200
    52.423    -0.033     0.200
    52.460    -0.803     0.200
    52.460    -0.311     0.200
    52.474     0.172     0.200
    53.240    -0.716     0.200
    53.385    -1.061     0.200
    53.544    -0.078     0.200
    54.428    -0.070     0.200
    54.428    -0.438     0.200
    54.423     0.409     0.200
    54.733     0.157     0.200
    54.733    -0.570     0.200
    56.302    -1.256     0.200
    56.322    -0.784     0.200
    57.851    -0.805     0.200
    57.851    -1.047     0.200
    57.851    -1.657     0.200
    57.863    -0.636     0.200
    59.083    -0.799     0.200
    60.209    -2.906     0.200
    60.209    -2.718     0.200
    60.278    -2.952     0.200
    60.620    -1.243     0.200
    61.269    -2.948     0.200
    61.281    -1.458     0.200
    62.270    -2.135     0.200
    62.270    -2.463     0.200
    62.446    -0.853     0.200
    62.565    -1.490     0.200
    62.565    -1.779     0.200
    62.674    -1.462     0.200
    62.782    -1.568     0.200
    62.782    -1.115     0.200
    62.785    -1.927     0.200
    64.190    -2.093     0.200
    64.334    -1.269     0.200
    64.573    -1.132     0.200
    64.761    -0.852     0.200
    64.836    -1.142     0.200
    64.836    -1.228     0.200
    64.836    -1.533     0.200
    64.928    -1.723     0.200
    64.928    -1.622     0.200
    65.276    -1.274     0.200
    68.724    -1.918     0.200
    68.724    -1.660     0.200
    69.176    -0.562     0.200
    70.661    -1.431     0.200
    70.994    -2.794     0.200
    71.001    -2.751     0.200
    71.001    -2.861     0.200
    71.059    -0.601     0.200
    71.059    -0.726     0.200
    71.076    -2.679     0.200
    71.827    -2.046     0.200
    71.926    -0.639     0.200
    72.512    -1.561     0.200
    73.195    -1.353     0.200
    73.411     2.584     0.200
    73.582    -2.485     0.200
    73.847    -0.984     0.200
    74.110    -1.907     0.200
    74.140    -1.693     0.200
    74.244    -0.713     0.200
    74.259    -1.254     0.200
    75.661    -0.715     0.200
    75.894    -1.424     0.200
    76.322    -0.929     0.200
    76.321    -0.534     0.200
    76.364    -1.662     0.200
    76.388    -1.309     0.200
    76.740    -1.396     0.200
    76.740    -1.052     0.200
    76.854    -1.983     0.200
    76.939    -1.593     0.200
    77.586    -0.173     0.200
    79.160    -0.514     0.200
    79.160    -0.850     0.200
    80.852    -1.589     0.200
    81.757    -1.293     0.200
    81.763    -1.382     0.200
    82.114    -0.537     0.200
    82.143    -1.750     0.200
    82.449    -1.770     0.200
    82.449    -1.629     0.200
    82.449    -1.200     0.200
    82.471    -1.538     0.200
    82.650    -1.210     0.200
    83.519    -0.880     0.200
    83.742    -0.605     0.200
    84.208    -0.145     0.200
    85.115    -0.531     0.200
    85.975    -2.007     0.200
    87.916    -2.037     0.200
    88.302    -0.784     0.200
    91.103    -0.169     0.200
    91.162    -2.335     0.200
    92.616    -0.780     0.200
    97.189    -1.701     0.200
    20.746    -0.379     0.200
    31.197     0.464     0.200
    32.509     1.391     0.200
    15.256     2.403     0.200
    15.256     4.677     0.200
    18.590    -2.243     0.200
    18.662    -0.213     0.200
    19.779    -0.381     0.200
    20.822     0.472     0.200
    21.256    -1.158     0.200
    21.256    -1.030     0.2