#!/bin/bash
gmt begin kodiak1.21_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times kodiak1.21'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   318.860
    25.500   323.398
    26.000   327.924
    26.500   332.438
    27.000   336.938
    27.500   341.420
    28.000   345.883
    28.500   350.333
    29.000   354.773
    29.500   359.206
    30.000   363.630
    30.500   368.047
    31.000   372.456
    31.500   376.858
    32.000   381.250
    32.500   385.633
    33.000   390.004
    33.500   394.361
    34.000   398.704
    34.500   403.032
    35.000   407.345
    35.500   411.643
    36.000   415.926
    36.500   420.194
    37.000   424.446
    37.500   428.682
    38.000   432.902
    38.500   437.106
    39.000   441.294
    39.500   445.464
    40.000   449.617
    40.500   453.753
    41.000   457.873
    41.500   461.975
    42.000   466.060
    42.500   470.128
    43.000   474.179
    43.500   478.212
    44.000   482.227
    44.500   486.225
    45.000   490.204
    45.500   494.166
    46.000   498.110
    46.500   502.036
    47.000   505.943
    47.500   509.833
    48.000   513.705
    48.500   517.558
    49.000   521.394
    49.500   525.211
    50.000   529.010
    50.500   532.790
    51.000   536.553
    51.500   540.297
    52.000   544.024
    52.500   547.732
    53.000   551.423
    53.500   555.096
    54.000   558.751
    54.500   562.388
    55.000   566.006
    55.500   569.605
    56.000   573.186
    56.500   576.749
    57.000   580.294
    57.500   583.821
    58.000   587.329
    58.500   590.820
    59.000   594.292
    59.500   597.746
    60.000   601.182
    60.500   604.599
    61.000   607.998
    61.500   611.378
    62.000   614.741
    62.500   618.086
    63.000   621.412
    63.500   624.721
    64.000   628.012
    64.500   631.285
    65.000   634.540
    65.500   637.778
    66.000   640.997
    66.500   644.198
    67.000   647.381
    67.500   650.546
    68.000   653.693
    68.500   656.822
    69.000   659.933
    69.500   663.026
    70.000   666.100
    70.500   669.157
    71.000   672.195
    71.500   675.215
    72.000   678.217
    72.500   681.201
    73.000   684.167
    73.500   687.114
    74.000   690.042
    74.500   692.951
    75.000   695.842
    75.500   698.715
    76.000   701.569
    76.500   704.405
    77.000   707.223
    77.500   710.023
    78.000   712.805
    78.500   715.569
    79.000   718.315
    79.500   721.042
    80.000   723.751
    80.500   726.440
    81.000   729.110
    81.500   731.761
    82.000   734.393
    82.500   737.006
    83.000   739.601
    83.500   742.176
    84.000   744.732
    84.500   747.268
    85.000   749.783
    85.500   752.279
    86.000   754.756
    86.500   757.216
    87.000   759.657
    87.500   762.074
    88.000   764.455
    88.500   766.818
    89.000   769.170
    89.500   771.514
    90.000   773.850
    90.500   776.180
    91.000   778.503
    91.500   780.821
    92.000   783.135
    92.500   785.445
    93.000   787.752
    93.500   790.055
    94.000   792.354
    94.500   794.648
    95.000   796.937
    95.500   799.220
    96.000   801.497
    96.500   803.767
    97.000   806.031
    97.500   808.288
    98.000   810.538
    98.500   812.780
    99.000   815.015
    99.500   817.242
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1116.062
   116.000  1117.024
   116.500  1117.986
   117.000  1118.948
   117.500  1119.910
   118.000  1120.872
   118.500  1121.834
   119.000  1122.796
   119.500  1123.757
   120.000  1124.718
   120.500  1125.679
   121.000  1126.640
   121.500  1127.601
   122.000  1128.561
   122.500  1129.521
   123.000  1130.480
   123.500  1131.439
   124.000  1132.398
   124.500  1133.356
   125.000  1134.314
   125.500  1135.271
   126.000  1136.227
   126.500  1137.183
   127.000  1138.138
   127.500  1139.093
   128.000  1140.046
   128.500  1140.999
   129.000  1141.951
   129.500  1142.901
   130.000  1143.851
   130.500  1144.800
   131.000  1145.747
   131.500  1146.694
   132.000  1147.639
   132.500  1148.582
   133.000  1149.524
   133.500  1150.465
   134.000  1151.403
   134.500  1152.340
   135.000  1153.275
   135.500  1154.208
   136.000  1155.139
   136.500  1156.068
   137.000  1156.994
   137.500  1157.918
   138.000  1158.839
   138.500  1159.757
   139.000  1160.673
   139.500  1161.585
   140.000  1162.495
   140.500  1163.401
   141.000  1164.303
   141.500  1165.201
   142.000  1166.095
   142.500  1166.985
   143.000  1167.871
   143.500  1168.752
   144.000  1169.628
   144.500  1170.498
   145.000  1171.364
   145.500  1172.223
   146.000  1173.076
   146.500  1173.923
   147.000  1174.764
   147.500  1175.598
   148.000  1176.424
   148.500  1177.243
   149.000  1178.054
   149.500  1178.856
   150.000  1179.648
   150.500  1180.431
   151.000  1181.204
   151.500  1181.966
   152.000  1182.719
   152.500  1183.462
   153.000  1184.194
   153.500  1184.917
   154.000  1185.628
   154.500  1186.329
   155.000  1187.019
   155.500  1187.697
   156.000  1188.364
   156.500  1189.018
   157.000  1189.661
   157.500  1190.292
   158.000  1190.910
   158.500  1191.516
   159.000  1192.110
   159.500  1192.690
   160.000  1193.258
   160.500  1193.813
   161.000  1194.355
   161.500  1194.883
   162.000  1195.399
   162.500  1195.901
   163.000  1196.390
   163.500  1196.866
   164.000  1197.327
   164.500  1197.775
   165.000  1198.209
   165.500  1198.629
   166.000  1199.036
   166.500  1199.428
   167.000  1199.807
   167.500  1200.172
   168.000  1200.522
   168.500  1200.859
   169.000  1201.181
   169.500  1201.490
   170.000  1201.784
   170.500  1202.064
   171.000  1202.329
   171.500  1202.581
   172.000  1202.818
   172.500  1203.041
   173.000  1203.250
   173.500  1203.444
   174.000  1203.624
   174.500  1203.790
   175.000  1203.941
   175.500  1204.078
   176.000  1204.200
   176.500  1204.308
   177.000  1204.402
   177.500  1204.481
   178.000  1204.546
   178.500  1204.597
   179.000  1204.633
   179.500  1204.654
   180.000  1204.662
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   986.960
     1.000   986.969
     1.500   986.983
     2.000   987.002
     2.500   987.027
     3.000   987.058
     3.500   987.095
     4.000   987.137
     4.500   987.184
     5.000   987.237
     5.500   987.296
     6.000   987.360
     6.500   987.430
     7.000   987.506
     7.500   987.587
     8.000   987.674
     8.500   987.766
     9.000   987.864
     9.500   987.967
    10.000   988.076
    10.500   988.190
    11.000   988.311
    11.500   988.436
    12.000   988.567
    12.500   988.704
    13.000   988.846
    13.500   988.994
    14.000   989.147
    14.500   989.306
    15.000   989.471
    15.500   989.640
    16.000   989.816
    16.500   989.997
    17.000   990.183
    17.500   990.375
    18.000   990.572
    18.500   990.775
    19.000   990.983
    19.500   991.197
    20.000   991.416
    20.500   991.641
    21.000   991.871
    21.500   992.106
    22.000   992.347
    22.500   992.594
    23.000   992.845
    23.500   993.102
    24.000   993.365
    24.500   993.633
    25.000   993.906
    25.500   994.185
    26.000   994.469
    26.500   994.758
    27.000   995.053
    27.500   995.352
    28.000   995.658
    28.500   995.968
    29.000   996.284
    29.500   996.605
    30.000   996.932
    30.500   997.263
    31.000   997.600
    31.500   997.942
    32.000   998.290
    32.500   998.642
    33.000   999.000
    33.500   999.363
    34.000   999.731
    34.500  1000.104
    35.000  1000.483
    35.500  1000.866
    36.000  1001.255
    36.500  1001.649
    37.000  1002.048
    37.500  1002.452
    38.000  1002.861
    38.500  1003.275
    39.000  1003.694
    39.500  1004.118
    40.000  1004.547
    40.500  1004.982
    41.000  1005.421
    41.500  1005.865
    42.000  1006.314
    42.500  1006.768
    43.000  1007.227
    43.500  1007.691
    44.000  1008.160
    44.500  1008.633
    45.000  1009.112
    45.500  1009.595
    46.000  1010.084
    46.500  1010.577
    47.000  1011.075
    47.500  1011.577
    48.000  1012.085
    48.500  1012.597
    49.000  1013.114
    49.500  1013.635
    50.000  1014.161
    50.500  1014.693
    51.000  1015.228
    51.500  1015.768
    52.000  1016.313
    52.500  1016.863
    53.000  1017.417
    53.500  1017.976
    54.000  1018.539
    54.500  1019.107
    55.000  1019.680
    55.500  1020.256
    56.000  1020.838
    56.500  1021.424
    57.000  1022.014
    57.500  1022.609
    58.000  1023.208
    58.500  1023.812
    59.000  1024.419
    59.500  1025.032
    60.000  1025.648
    60.500  1026.269
    61.000  1026.895
    61.500  1027.524
    62.000  1028.158
    62.500  1028.796
    63.000  1029.438
    63.500  1030.085
    64.000  1030.736
    64.500  1031.391
    65.000  1032.049
    65.500  1032.713
    66.000  1033.380
    66.500  1034.051
    67.000  1034.726
    67.500  1035.406
    68.000  1036.089
    68.500  1036.777
    69.000  1037.468
    69.500  1038.163
    70.000  1038.863
    70.500  1039.566
    71.000  1040.273
    71.500  1040.984
    72.000  1041.699
    72.500  1042.418
    73.000  1043.140
    73.500  1043.866
    74.000  1044.596
    74.500  1045.330
    75.000  1046.068
    75.500  1046.809
    76.000  1047.554
    76.500  1048.302
    77.000  1049.054
    77.500  1049.810
    78.000  1050.569
    78.500  1051.332
    79.000  1052.099
    79.500  1052.869
    80.000  1053.642
    80.500  1054.419
    81.000  1055.200
    81.500  1055.984
    82.000  1056.771
    82.500  1057.562
    83.000  1058.355
    83.500  1059.153
    84.000  1059.954
    84.500  1060.758
    85.000  1061.565
    85.500  1062.375
    86.000  1063.189
    86.500  1064.006
    87.000  1064.826
    87.500  1065.650
    88.000  1066.476
    88.500  1067.305
    89.000  1068.138
    89.500  1068.974
    90.000  1069.812
    90.500  1070.654
    91.000  1071.499
    91.500  1072.347
    92.000  1073.197
    92.500  1074.051
    93.000  1074.907
    93.500  1075.767
    94.000  1076.629
    94.500  1077.494
    95.000  1078.362
    95.500  1079.232
    96.000  1080.106
    96.500  1080.982
    97.000  1081.861
    97.500  1082.742
    98.000  1083.626
    98.500  1084.513
    99.000  1085.402
    99.500  1086.294
   100.000  1087.189
   100.500  1088.086
   101.000  1088.986
   101.500  1089.888
   102.000  1090.792
   102.500  1091.700
   103.000  1092.609
   103.500  1093.521
   104.000  1094.435
   104.500  1095.352
   105.000  1096.271
   105.500  1097.192
   106.000  1098.115
   106.500  1099.041
   107.000  1099.969
   107.500  1100.899
   108.000  1101.832
   108.500  1102.766
   109.000  1103.703
   109.500  1104.642
   110.000  1105.582
   110.500  1106.525
   111.000  1107.470
   111.500  1108.417
   112.000  1109.366
   112.500  1110.317
   113.000  1111.270
   113.500  1112.225
   114.000  1113.181
   114.500  1114.140
   115.000  1115.100
   115.500  1116.062
   116.000  1117.026
   116.500  1117.992
   117.000  1118.960
   117.500  1119.929
   118.000  1120.900
   118.500  1121.872
   119.000  1122.847
   119.500  1123.823
   120.000  1124.800
   120.500  1125.779
   121.000  1126.760
   121.500  1127.742
   122.000  1128.725
   122.500  1129.711
   123.000  1130.697
   123.500  1131.685
   124.000  1132.675
   124.500  1133.666
   125.000  1134.658
   125.500  1135.651
   126.000  1136.646
   126.500  1137.642
   127.000  1138.640
   127.500  1139.639
   128.000  1140.638
   128.500  1141.640
   129.000  1142.642
   129.500  1143.645
   130.000  1144.650
   130.500  1145.656
   131.000  1146.662
   131.500  1147.670
   132.000  1148.679
   132.500  1149.689
   133.000  1150.700
   133.500  1151.712
   134.000  1152.724
   134.500  1153.738
   135.000  1154.753
   135.500  1155.768
   136.000  1156.785
   136.500  1157.802
   137.000  1158.820
   137.500  1159.839
   138.000  1160.858
   138.500  1161.878
   139.000  1162.899
   139.500  1163.921
   140.000  1164.943
   140.500  1165.966
   141.000  1166.990
   141.500  1168.014
   142.000  1169.039
   142.500  1170.065
   143.000  1171.091
   143.500  1172.117
   144.000  1173.144
   144.500  1174.172
   145.000  1175.200
   145.500  1176.228
   146.000  1177.257
   146.500  1178.286
   147.000  1179.315
   147.500  1180.345
   148.000  1181.375
   148.500  1182.406
   149.000  1183.437
   149.500  1184.468
   150.000  1185.499
   150.500  1186.531
   151.000  1187.562
   151.500  1188.594
   152.000  1189.626
   152.500  1190.659
   153.000  1191.691
   153.500  1192.723
   154.000  1193.756
   154.500  1194.788
   155.000  1195.821
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1170.792
   145.500  1172.628
   146.000  1174.516
   146.500  1176.439
   147.000  1178.389
   147.500  1180.361
   148.000  1182.353
   148.500  1184.362
   149.000  1186.386
   149.500  1188.424
   150.000  1190.474
   150.500  1192.536
   151.000  1194.607
   151.500  1196.689
   152.000  1198.779
   152.500  1200.878
   153.000  1202.984
   153.500  1205.098
   154.000  1207.218
   154.500  1209.345
   155.000  1211.478
   155.500  1213.617
   156.000  1215.760
   156.500  1217.909
   157.000  1220.063
   157.500  1222.220
   158.000  1224.383
   158.500  1226.549
   159.000  1228.719
   159.500  1230.892
   160.000  1233.069
   160.500  1235.250
   161.000  1237.433
   161.500  1239.619
   162.000  1241.808
   162.500  1243.999
   163.000  1246.192
   163.500  1248.388
   164.000  1250.586
   164.500  1252.786
   165.000  1254.988
   165.500  1257.192
   166.000  1259.397
   166.500  1261.604
   167.000  1263.813
   167.500  1266.023
   168.000  1268.234
   168.500  1270.447
   169.000  1272.660
   169.500  1274.875
   170.000  1277.091
   170.500  1279.307
   171.000  1281.525
   171.500  1283.743
   172.000  1285.962
   172.500  1288.181
   173.000  1290.401
   173.500  1292.622
   174.000  1294.843
   174.500  1297.065
   175.000  1299.286
   175.500  1301.509
   176.000  1303.731
   176.500  1305.953
   177.000  1308.176
   177.500  1310.399
   178.000  1312.622
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1170.772
   145.500  1172.381
   146.000  1173.919
   146.500  1175.401
   147.000  1176.835
   147.500  1178.223
   148.000  1179.570
   148.500  1180.877
   149.000  1182.151
   149.500  1183.396
   150.000  1184.617
   150.500  1185.815
   151.000  1186.993
   151.500  1188.151
   152.000  1189.291
   152.500  1190.415
   153.000  1191.522
   153.500  1192.615
   154.000  1193.695
   154.500  1194.761
   155.000  1195.815
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   503.836
     1.000   503.872
     1.500   503.932
     2.000   504.016
     2.500   504.124
     3.000   504.257
     3.500   504.413
     4.000   504.593
     4.500   504.797
     5.000   505.025
     5.500   505.277
     6.000   505.553
     6.500   505.852
     7.000   506.175
     7.500   506.522
     8.000   506.892
     8.500   507.286
     9.000   507.703
     9.500   508.143
    10.000   508.607
    10.500   509.094
    11.000   509.604
    11.500   510.137
    12.000   510.692
    12.500   511.271
    13.000   511.872
    13.500   512.495
    14.000   513.141
    14.500   513.810
    15.000   514.500
    15.500   515.213
    16.000   515.948
    16.500   516.704
    17.000   517.482
    17.500   518.281
    18.000   519.102
    18.500   519.945
    19.000   520.808
    19.500   521.692
    20.000   522.597
    20.500   523.523
    21.000   524.469
    21.500   525.435
    22.000   526.422
    22.500   527.429
    23.000   528.455
    23.500   529.501
    24.000   530.567
    24.500   531.652
    25.000   532.756
    25.500   533.879
    26.000   535.021
    26.500   536.182
    27.000   537.361
    27.500   538.558
    28.000   539.774
    28.500   541.007
    29.000   542.258
    29.500   543.527
    30.000   544.813
    30.500   546.116
    31.000   547.436
    31.500   548.773
    32.000   550.127
    32.500   551.497
    33.000   552.883
    33.500   554.286
    34.000   555.704
    34.500   557.138
    35.000   558.587
    35.500   560.052
    36.000   561.532
    36.500   563.027
    37.000   564.537
    37.500   566.061
    38.000   567.600
    38.500   569.153
    39.000   570.719
    39.500   572.300
    40.000   573.894
    40.500   575.502
    41.000   577.123
    41.500   578.757
    42.000   580.404
    42.500   582.064
    43.000   583.736
    43.500   585.421
    44.000   587.118
    44.500   588.827
    45.000   590.547
    45.500   592.279
    46.000   594.023
    46.500   595.778
    47.000   597.545
    47.500   599.322
    48.000   601.110
    48.500   602.908
    49.000   604.717
    49.500   606.536
    50.000   608.366
    50.500   610.205
    51.000   612.054
    51.500   613.913
    52.000   615.781
    52.500   617.658
    53.000   619.545
    53.500   621.440
    54.000   623.345
    54.500   625.258
    55.000   627.179
    55.500   629.109
    56.000   631.047
    56.500   632.993
    57.000   634.947
    57.500   636.908
    58.000   638.878
    58.500   640.854
    59.000   642.838
    59.500   644.830
    60.000   646.828
    60.500   648.833
    61.000   650.845
    61.500   652.863
    62.000   654.888
    62.500   656.919
    63.000   658.957
    63.500   661.000
    64.000   663.050
    64.500   665.105
    65.000   667.166
    65.500   669.233
    66.000   671.305
    66.500   673.382
    67.000   675.465
    67.500   677.552
    68.000   679.645
    68.500   681.742
    69.000   683.844
    69.500   685.951
    70.000   688.062
    70.500   690.178
    71.000   692.298
    71.500   694.422
    72.000   696.550
    72.500   698.682
    73.000   700.818
    73.500   702.957
    74.000   705.101
    74.500   707.248
    75.000   709.398
    75.500   711.551
    76.000   713.708
    76.500   715.868
    77.000   718.031
    77.500   720.197
    78.000   722.366
    78.500   724.538
    79.000   726.712
    79.500   728.889
    80.000   731.068
    80.500   733.250
    81.000   735.434
    81.500   737.621
    82.000   739.809
    82.500   742.000
    83.000   744.193
    83.500   746.388
    84.000   748.584
    84.500   750.783
    85.000   752.983
    85.500   755.184
    86.000   757.388
    86.500   759.592
    87.000   761.799
    87.500   764.006
    88.000   766.215
    88.500   768.425
    89.000   770.637
    89.500   772.849
    90.000   775.063
    90.500   777.277
    91.000   779.493
    91.500   781.709
    92.000   783.926
    92.500   786.144
    93.000   788.362
    93.500   790.581
    94.000   792.801
    94.500   795.021
    95.000   797.242
    95.500   799.463
    96.000   801.685
    96.500   803.907
    97.000   806.129
    97.500   808.351
    98.000   810.574
    98.500   812.796
    99.000   815.019
    99.500   817.242
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.000   409.791
    28.500   415.349
    29.000   420.906
    29.500   426.462
    30.000   432.018
    30.500   437.572
    31.000   443.124
    31.500   448.674
    32.000   454.222
    32.500   459.767
    33.000   465.309
    33.500   470.847
    34.000   476.382
    34.500   481.912
    35.000   487.437
    35.500   492.956
    36.000   498.470
    36.500   503.977
    37.000   509.477
    37.500   514.969
    38.000   520.454
    38.500   525.930
    39.000   531.396
    39.500   536.853
    40.000   542.299
    40.500   547.734
    41.000   553.158
    41.500   558.570
    42.000   563.969
    42.500   569.354
    43.000   574.727
    43.500   580.085
    44.000   585.428
    44.500   590.756
    45.000   596.069
    45.500   601.366
    46.000   606.646
    46.500   611.909
    47.000   616.923
    47.500   621.495
    48.000   626.064
    48.500   630.627
    49.000   635.186
    49.500   639.740
    50.000   644.289
    50.500   648.832
    51.000   653.370
    51.500   657.903
    52.000   662.430
    52.500   666.951
    53.000   671.466
    53.500   675.975
    54.000   680.476
    54.500   684.969
    55.000   689.452
    55.500   693.924
    56.000   698.388
    56.500   702.844
    57.000   707.295
    57.500   711.741
    58.000   716.182
    58.500   720.619
    59.000   725.051
    59.500   729.480
    60.000   733.905
    60.500   738.326
    61.000   742.743
    61.500   747.157
    62.000   751.567
    62.500   755.972
    63.000   760.374
    63.500   764.772
    64.000   769.165
    64.500   773.553
    65.000   777.936
    65.500   782.314
    66.000   786.685
    66.500   791.051
    67.000   795.409
    67.500   799.760
    68.000   804.104
    68.500   808.440
    69.000   812.769
    69.500   817.090
    70.000   821.404
    70.500   825.710
    71.000   830.008
    71.500   834.299
    72.000   838.583
    72.500   842.859
    73.000   847.127
    73.500   851.387
    74.000   855.640
    74.500   859.885
    75.000   864.122
    75.500   868.351
    76.000   872.571
    76.500   876.784
    77.000   880.989
    77.500   885.185
    78.000   889.373
    78.500   893.552
    79.000   897.723
    79.500   901.885
    80.000   906.039
    80.500   910.184
    81.000   914.321
    81.500   918.449
    82.000   922.569
    82.500   926.681
    83.000   930.783
    83.500   934.878
    84.000   938.963
    84.500   943.040
    85.000   947.109
    85.500   951.168
    86.000   955.219
    86.500   959.261
    87.000   963.294
    87.500   967.319
    88.000   971.334
    88.500   975.341
    89.000   979.339
    89.500   983.328
    90.000   987.308
    90.500   991.279
    91.000   995.240
    91.500   999.193
    92.000  1003.137
    92.500  1007.072
    93.000  1010.998
    93.500  1014.915
    94.000  1018.823
    94.500  1022.722
    95.000  1026.612
    95.500  1030.492
    96.000  1034.364
    96.500  1038.227
    97.000  1042.080
    97.500  1045.925
    98.000  1049.760
    98.500  1053.587
    99.000  1057.404
    99.500  1061.212
   100.000  1065.011
   100.500  1068.801
   101.000  1072.581
   101.500  1076.353
   102.000  1080.115
   102.500  1083.868
   103.000  1087.612
   103.500  1091.347
   104.000  1095.074
   104.500  1098.791
   105.000  1102.500
   105.500  1106.199
   106.000  1109.890
   106.500  1113.572
   107.000  1117.245
   107.500  1120.908
   108.000  1124.563
   108.500  1128.208
   109.000  1131.845
   109.500  1135.472
   110.000  1139.089
   110.500  1142.698
   111.000  1146.297
   111.500  1149.887
   112.000  1153.468
   112.500  1157.039
   113.000  1160.602
   113.500  1164.155
   114.000  1167.699
   114.500  1171.234
   115.000  1174.761
   115.500  1178.278
   116.000  1181.786
   116.500  1185.285
   117.000  1188.775
   117.500  1192.256
   118.000  1195.728
   118.500  1199.190
   119.000  1202.644
   119.500  1206.088
   120.000  1209.523
   120.500  1212.949
   121.000  1216.366
   121.500  1219.773
   122.000  1223.171
   122.500  1226.560
   123.000  1229.940
   123.500  1233.311
   124.000  1236.673
   124.500  1240.026
   125.000  1243.370
   125.500  1246.705
   126.000  1250.031
   126.500  1253.347
   127.000  1256.656
   127.500  1259.955
   128.000  1263.245
   128.500  1266.526
   129.000  1269.799
   129.500  1273.062
   130.000  1276.316
   130.500  1279.562
   131.000  1282.798
   131.500  1286.026
   132.000  1289.244
   132.500  1292.453
   133.000  1295.654
   133.500  1298.845
   134.000  1302.027
   134.500  1305.200
   135.000  1308.365
   135.500  1311.520
   136.000  1314.666
   136.500  1317.803
   137.000  1320.931
   137.500  1324.049
   138.000  1327.159
   138.500  1330.260
   139.000  1333.351
   139.500  1336.434
   140.000  1339.507
   140.500  1342.571
   141.000  1345.627
   141.500  1348.673
   142.000  1351.710
   142.500  1354.738
   143.000  1357.757
   143.500  1360.767
   144.000  1363.768
   144.500  1366.760
   145.000  1369.743
   145.500  1372.717
   146.000  1375.681
   146.500  1378.636
   147.000  1381.582
   147.500  1384.518
   148.000  1387.445
   148.500  1390.362
   149.000  1393.270
   149.500  1396.169
   150.000  1399.059
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   819.465
   100.500   821.688
   101.000   823.911
   101.500   826.133
   102.000   828.356
   102.500   830.579
   103.000   832.802
   103.500   835.025
   104.000   837.248
   104.500   839.470
   105.000   841.693
   105.500   843.916
   106.000   846.139
   106.500   848.362
   107.000   850.585
   107.500   852.807
   108.000   855.030
   108.500   857.253
   109.000   859.476
   109.500   861.699
   110.000   863.922
   110.500   866.144
   111.000   868.367
   111.500   870.590
   112.000   872.813
   112.500   875.036
   113.000   877.259
   113.500   879.481
   114.000   881.704
   114.500   883.927
   115.000   886.150
   115.500   888.373
   116.000   890.596
   116.500   892.818
   117.000   895.041
   117.500   897.264
   118.000   899.487
   118.500   901.710
   119.000   903.933
   119.500   906.155
   120.000   908.378
   120.500   910.601
   121.000   912.824
   121.500   915.047
   122.000   917.270
   122.500   919.492
   123.000   921.715
   123.500   923.938
   124.000   926.161
   124.500   928.384
   125.000   930.607
   125.500   932.829
   126.000   935.052
   126.500   937.275
   127.000   939.498
   127.500   941.721
   128.000   943.944
   128.500   946.166
   129.000   948.389
   129.500   950.612
   130.000   952.835
   130.500   955.058
   131.000   957.281
   131.500   959.503
   132.000   961.726
   132.500   963.949
   133.000   966.172
   133.500   968.395
   134.000   970.618
   134.500   972.841
   135.000   975.063
   135.500   977.286
   136.000   979.509
   136.500   981.732
   137.000   983.955
   137.500   986.177
   138.000   988.400
   138.500   990.623
   139.000   992.846
   139.500   995.069
   140.000   997.292
   140.500   999.514
   141.000  1001.737
   141.500  1003.960
   142.000  1006.183
   142.500  1008.406
   143.000  1010.629
   143.500  1012.852
   144.000  1015.074
   144.500  1017.297
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.000   368.425
    14.500   378.664
    15.000   388.899
    15.500   399.128
    16.000   409.347
    16.500   419.553
    17.000   429.741
    17.500   439.906
    18.000   450.045
    18.500   459.442
    19.000   470.218
    19.500   480.242
    20.000   490.215
    20.500   500.133
    21.000   509.989
    21.500   519.780
    22.000   529.499
    22.500   538.699
    23.000   546.857
    23.500   554.981
    24.000   563.073
    24.500   571.128
    25.000   579.124
    25.500   587.044
    26.000   594.949
    26.500   602.845
    27.000   610.732
    27.500   618.612
    28.000   626.486
    28.500   634.353
    29.000   642.213
    29.500   650.067
    30.000   657.912
    30.500   665.749
    31.000   673.576
    31.500   681.390
    32.000   689.191
    32.500   696.977
    33.000   704.747
    33.500   712.500
    34.000   720.234
    34.500   727.950
    35.000   735.646
    35.500   743.323
    36.000   750.980
    36.500   758.617
    37.000   766.234
    37.500   773.830
    38.000   781.404
    38.500   788.957
    39.000   796.487
    39.500   803.995
    40.000   811.480
    40.500   818.941
    41.000   826.379
    41.500   833.794
    42.000   841.184
    42.500   848.551
    43.000   855.892
    43.500   863.210
    44.000   870.502
    44.500   877.770
    45.000   885.012
    45.500   892.229
    46.000   899.421
    46.500   906.586
    47.000   913.726
    47.500   920.839
    48.000   927.925
    48.500   934.984
    49.000   942.016
    49.500   949.022
    50.000   956.000
    50.500   962.952
    51.000   969.876
    51.500   976.773
    52.000   983.642
    52.500   990.483
    53.000   997.298
    53.500  1004.088
    54.000  1010.851
    54.500  1017.588
    55.000  1024.298
    55.500  1030.981
    56.000  1037.636
    56.500  1044.263
    57.000  1050.863
    57.500  1057.434
    58.000  1063.978
    58.500  1070.494
    59.000  1076.982
    59.500  1083.442
    60.000  1089.876
    60.500  1096.281
    61.000  1102.659
    61.500  1109.008
    62.000  1115.329
    62.500  1121.622
    63.000  1127.886
    63.500  1134.122
    64.000  1140.330
    64.500  1146.509
    65.000  1152.660
    65.500  1158.783
    66.000  1164.878
    66.500  1170.945
    67.000  1176.983
    67.500  1182.993
    68.000  1188.974
    68.500  1194.927
    69.000  1200.851
    69.500  1206.746
    70.000  1212.613
    70.500  1218.451
    71.000  1224.261
    71.500  1230.041
    72.000  1235.792
    72.500  1241.514
    73.000  1247.206
    73.500  1252.869
    74.000  1258.500
    74.500  1264.103
    75.000  1269.675
    75.500  1275.219
    76.000  1280.733
    76.500  1286.218
    77.000  1291.673
    77.500  1297.098
    78.000  1302.493
    78.500  1307.858
    79.000  1313.192
    79.500  1318.498
    80.000  1323.774
    80.500  1329.021
    81.000  1334.237
    81.500  1339.423
    82.000  1344.576
    82.500  1349.697
    83.000  1354.786
    83.500  1359.844
    84.000  1364.872
    84.500  1369.869
    85.000  1374.834
    85.500  1379.768
    86.000  1384.670
    86.500  1389.540
    87.000  1394.378
    87.500  1399.184
    88.000  1403.956
    88.500  1408.695
    89.000  1413.402
    89.500  1418.074
    90.000  1422.713
    90.500  1427.319
    91.000  1431.890
    91.500  1436.428
    92.000  1440.932
    92.500  1445.403
    93.000  1449.839
    93.500  1454.242
    94.000  1458.622
    94.500  1462.987
    95.000  1467.339
    95.500  1471.679
    96.000  1476.008
    96.500  1480.323
    97.000  1484.620
    97.500  1488.897
    98.000  1493.154
    98.500  1497.392
    99.000  1501.610
    99.500  1505.808
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   710.291
     1.000   710.338
     1.500   710.416
     2.000   710.525
     2.500   710.665
     3.000   710.837
     3.500   711.039
     4.000   711.272
     4.500   711.537
     5.000   711.832
     5.500   712.158
     6.000   712.515
     6.500   712.903
     7.000   713.320
     7.500   713.769
     8.000   714.248
     8.500   714.757
     9.000   715.296
     9.500   715.865
    10.000   716.464
    10.500   717.092
    11.000   717.751
    11.500   718.438
    12.000   719.155
    12.500   719.901
    13.000   720.675
    13.500   721.478
    14.000   722.310
    14.500   723.170
    15.000   724.058
    15.500   724.974
    16.000   725.918
    16.500   726.889
    17.000   727.888
    17.500   728.913
    18.000   729.965
    18.500   731.044
    19.000   732.149
    19.500   733.280
    20.000   734.437
    20.500   735.619
    21.000   736.827
    21.500   738.060
    22.000   739.317
    22.500   740.599
    23.000   741.905
    23.500   743.235
    24.000   744.588
    24.500   745.965
    25.000   747.365
    25.500   748.787
    26.000   750.232
    26.500   751.699
    27.000   753.188
    27.500   754.698
    28.000   756.230
    28.500   757.782
    29.000   759.355
    29.500   760.949
    30.000   762.562
    30.500   764.195
    31.000   765.847
    31.500   767.518
    32.000   769.208
    32.500   770.916
    33.000   772.642
    33.500   774.386
    34.000   776.147
    34.500   777.925
    35.000   779.720
    35.500   781.531
    36.000   783.358
    36.500   785.200
    37.000   787.058
    37.500   788.931
    38.000   790.819
    38.500   792.721
    39.000   794.637
    39.500   796.567
    40.000   798.509
    40.500   800.465
    41.000   802.434
    41.500   804.414
    42.000   806.407
    42.500   808.412
    43.000   810.427
    43.500   812.454
    44.000   814.491
    44.500   816.539
    45.000   818.596
    45.500   820.663
    46.000   822.740
    46.500   824.825
    47.000   826.919
    47.500   829.022
    48.000   831.133
    48.500   833.251
    49.000   835.377
    49.500   837.510
    50.000   839.649
    50.500   841.796
    51.000   843.948
    51.500   846.106
    52.000   848.270
    52.500   850.440
    53.000   852.614
    53.500   854.793
    54.000   856.977
    54.500   859.164
    55.000   861.356
    55.500   863.552
    56.000   865.750
    56.500   867.952
    57.000   870.157
    57.500   872.365
    58.000   874.575
    58.500   876.787
    59.000   879.002
    59.500   881.218
    60.000   883.435
    60.500   885.654
    61.000   887.874
    61.500   890.096
    62.000   892.317
    62.500   894.540
    63.000   896.762
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   922.345
     1.000   922.412
     1.500   922.523
     2.000   922.678
     2.500   922.878
     3.000   923.122
     3.500   923.410
     4.000   923.742
     4.500   924.119
     5.000   924.540
     5.500   925.004
     6.000   925.513
     6.500   926.065
     7.000   926.661
     7.500   927.300
     8.000   927.983
     8.500   928.710
     9.000   929.479
     9.500   930.292
    10.000   931.147
    10.500   932.045
    11.000   932.986
    11.500   933.969
    12.000   934.994
    12.500   936.061
    13.000   937.171
    13.500   938.321
    14.000   939.513
    14.500   940.747
    15.000   942.021
    15.500   943.336
    16.000   944.692
    16.500   946.088
    17.000   947.524
    17.500   949.000
    18.000   950.515
    18.500   952.070
    19.000   953.663
    19.500   955.296
    20.000   956.966
    20.500   958.675
    21.000   960.422
    21.500   962.207
    22.000   964.029
    22.500   965.888
    23.000   967.784
    23.500   969.716
    24.000   971.684
    24.500   973.688
    25.000   975.728
    25.500   977.802
    26.000   979.912
    26.500   982.056
    27.000   984.235
    27.500   986.447
    28.000   988.693
    28.500   990.973
    29.000   993.285
    29.500   995.630
    30.000   998.007
    30.500  1000.416
    31.000  1002.857
    31.500  1005.329
    32.000  1007.832
    32.500  1010.365
    33.000  1012.929
    33.500  1015.523
    34.000  1018.146
    34.500  1020.799
    35.000  1023.480
    35.500  1026.190
    36.000  1028.928
    36.500  1031.694
    37.000  1034.488
    37.500  1037.309
    38.000  1040.157
    38.500  1043.031
    39.000  1045.932
    39.500  1048.858
    40.000  1051.810
    40.500  1054.787
    41.000  1057.789
    41.500  1060.816
    42.000  1063.867
    42.500  1066.942
    43.000  1070.040
    43.500  1073.161
    44.000  1076.306
    44.500  1079.472
    45.000  1082.661
    45.500  1085.873
    46.000  1089.105
    46.500  1092.359
    47.000  1095.635
    47.500  1098.930
    48.000  1102.246
    48.500  1105.582
    49.000  1108.938
    49.500  1112.314
    50.000  1115.708
    50.500  1119.122
    51.000  1122.553
    51.500  1126.004
    52.000  1129.472
    52.500  1132.957
    53.000  1136.460
    53.500  1139.980
    54.000  1143.518
    54.500  1147.071
    55.000  1150.641
    55.500  1154.227
    56.000  1157.828
    56.500  1161.445
    57.000  1165.077
    57.500  1168.724
    58.000  1172.385
    58.500  1176.061
    59.000  1179.750
    59.500  1183.454
    60.000  1187.171
    60.500  1190.902
    61.000  1194.646
    61.500  1198.402
    62.000  1202.171
    62.500  1205.952
    63.000  1209.745
    63.500  1213.551
    64.000  1217.367
    64.500  1221.196
    65.000  1225.035
    65.500  1228.885
    66.000  1232.746
    66.500  1236.617
    67.000  1240.499
    67.500  1244.390
    68.000  1248.291
    68.500  1252.202
    69.000  1256.122
    69.500  1260.052
    70.000  1263.990
    70.500  1267.937
    71.000  1271.892
    71.500  1275.856
    72.000  1279.828
    72.500  1283.808
    73.000  1287.796
    73.500  1291.791
    74.000  1295.793
    74.500  1299.803
    75.000  1303.819
    75.500  1307.843
    76.000  1311.872
    76.500  1315.909
    77.000  1319.951
    77.500  1324.000
    78.000  1328.054
    78.500  1332.115
    79.000  1336.180
    79.500  1340.252
    80.000  1344.328
    80.500  1348.409
    81.000  1352.496
    81.500  1356.587
    82.000  1360.682
    82.500  1364.782
    83.000  1368.886
    83.500  1372.995
    84.000  1377.107
    84.500  1381.223
    85.000  1385.343
    85.500  1389.466
    86.000  1393.592
    86.500  1397.722
    87.000  1401.855
    87.500  1405.991
    88.000  1410.130
    88.500  1414.271
    89.000  1418.415
    89.500  1422.562
    90.000  1426.710
    90.500  1430.861
    91.000  1435.014
    91.500  1439.169
    92.000  1443.326
    92.500  1447.484
    93.000  1451.644
    93.500  1455.805
    94.000  1459.968
    94.500  1464.132
    95.000  1468.297
    95.500  1472.463
    96.000  1476.630
    96.500  1480.797
    97.000  1484.966
    97.500  1489.135
    98.000  1493.304
    98.500  1497.474
    99.000  1501.644
    99.500  1505.814
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    28.500   756.379
    29.000   766.618
    29.500   776.857
    30.000   787.094
    30.500   797.328
    31.000   807.559
    31.500   817.786
    32.000   828.008
    32.500   838.224
    33.000   848.434
    33.500   858.636
    34.000   868.829
    34.500   879.012
    35.000   889.184
    35.500   899.344
    36.000   909.490
    36.500   919.621
    37.000   929.736
    37.500   939.833
    38.000   949.636
    38.500   959.968
    39.000   970.003
    39.500   980.014
    40.000   989.999
    40.500   999.959
    41.000  1009.890
    41.500  1019.791
    42.000  1029.662
    42.500  1039.501
    43.000  1049.306
    43.500  1059.077
    44.000  1068.812
    44.500  1078.510
    45.000  1088.171
    45.500  1096.583
    46.000  1104.743
    46.500  1112.887
    47.000  1121.014
    47.500  1129.125
    48.000  1137.219
    48.500  1145.297
    49.000  1153.355
    49.500  1161.391
    50.000  1169.396
    50.500  1177.350
    51.000  1185.271
    51.500  1193.183
    52.000  1201.088
    52.500  1208.989
    53.000  1216.885
    53.500  1224.776
    54.000  1232.664
    54.500  1240.548
    55.000  1248.429
    55.500  1256.307
    56.000  1264.181
    56.500  1272.051
    57.000  1279.919
    57.500  1287.783
    58.000  1295.644
    58.500  1303.501
    59.000  1311.355
    59.500  1319.206
    60.000  1327.052
    60.500  1334.894
    61.000  1342.732
    61.500  1350.564
    62.000  1358.391
    62.500  1366.213
    63.000  1374.028
    63.500  1381.836
    64.000  1389.638
    64.500  1397.433
    65.000  1405.220
    65.500  1412.999
    66.000  1420.770
    66.500  1428.533
    67.000  1436.286
    67.500  1444.031
    68.000  1451.767
    68.500  1459.493
    69.000  1467.210
    69.500  1474.917
    70.000  1482.615
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     1.021    16.398     0.150
     1.022    16.398     0.150
     8.125   113.000     0.150
    19.866   275.500     0.150
    25.405   329.801     0.150
    25.405     7.699     0.150
    25.405   349.500     0.150
    26.900   349.500     0.150
    31.574   382.500     0.150
    34.267  1039.500     0.150
    35.272   516.500     0.150
    35.272   572.500     0.150
    37.224   578.500     0.150
    41.588    11.000     0.150
    41.588   579.500     0.150
    42.217   477.500     0.150
    44.530   489.500     0.150
    49.656   537.898     0.150
    49.656   977.500     0.150
    49.984   975.500     0.150
    53.493   564.699     0.150
    59.105   597.500     0.150
    59.359   598.500     0.150
    62.732   630.703     0.150
    63.019   627.500     0.150
    66.817   656.500     0.150
    70.961   683.500     0.150
    71.302   679.500     0.150
    71.302   723.500     0.150
    71.814   680.500     0.150
    71.814   745.500     0.150
    71.868   688.703     0.150
    72.109   690.203     0.150
    72.157   690.703     0.150
    73.374   698.500     0.150
    77.314   721.500     0.150
    77.577   723.797     0.150
    77.577   733.500     0.150
    87.357   767.797     0.150
     3.957    82.273     0.150
     8.616   132.273     0.150
    24.390   593.273     0.150
    31.629   561.273     0.150
    31.629   857.273     0.150
    34.299   403.273     0.150
    35.385   573.273     0.150
    40.276   452.273     0.150
    49.563   981.273     0.150
    50.236   535.273     0.150
    50.236   621.273     0.150
    50.236   896.273     0.150
    50.236   984.273     0.150
    53.181    13.000     0.150
    55.338   563.273     0.150
    70.919   691.273     0.150
    70.919   827.273     0.150
    70.919   849.273     0.150
    71.432   678.273     0.150
    71.432    15.000     0.150
    71.432   705.273     0.150
    71.432   745.273     0.150
    71.432   802.273     0.150
    72.371   858.273     0.150
    73.028   696.273     0.150
    77.199   719.973     0.150
    77.199   744.273     0.150
    81.927   798.273     0.150
    83.256   744.273     0.150
    85.309   748.273     0.150
   137.400  1164.273     0.150
    21.702   294.711     0.150
    25.738   356.812     0.150
    31.773   764.812     0.150
    35.555   520.812     0.150
    35.555   571.812     0.150
    35.555   803.812     0.150
    44.230   900.812     0.150
    44.924   491.211     0.150
    50.267    19.000     0.150
    50.267   619.812     0.150
    50.267  1163.812     0.150
    52.906   615.812     0.150
    52.971   621.812     0.150
    53.003   615.812     0.150
    58.772  1086.812     0.150
    62.159   635.812     0.150
    62.221   642.812     0.150
    63.000   622.812     0.150
    70.729   688.812     0.150
    70.729   746.812     0.150
    70.729   844.812     0.150
    70.883   673.812     0.150
    71.569   619.113     0.150
    73.367   750.012     0.150
    77.021     0.301     0.150
    84.377   743.812     0.150
   138.555  1152.812     0.150
    24.680   600.598     0.150
    25.767     7.398     0.150
    25.767   354.598     0.150
    27.227    19.000     0.150
    27.427   779.598     0.150
    31.593   382.098     0.150
    31.928   727.598     0.150
    41.936   584.598     0.150
    48.720   519.199     0.150
    71.207   693.598     0.150
    71.207    22.000     0.150
    76.824  1310.598     0.150
    77.515     0.398     0.150
     0.475     5.941     0.150
    21.404     8.000     0.150
    24.389     9.699     0.150
    26.650   345.340     0.150
    27.996   363.340     0.150
    28.702   369.340     0.150
    29.663   363.141     0.150
    30.134   368.840     0.150
    30.656   366.340     0.150
    32.210   562.340     0.150
    32.582  3608.500     0.150
    32.875   403.340     0.150
    32.957   565.340     0.150
    36.057   573.340     0.150
    37.886   579.340     0.150
    37.910   445.340     0.150
    37.910   500.340     0.150
    40.592   452.340     0.150
    41.320   474.340     0.150
    42.138   582.340     0.150
    44.177   486.340     0.150
    49.122   537.441     0.150
    49.738   546.238     0.150
    50.657   546.340     0.150
    50.860   537.738     0.150
    52.417   561.340     0.150
    52.443   561.340     0.150
    58.116   602.340     0.150
    61.675   627.340     0.150
    61.669   621.340     0.150
    70.234   682.340     0.150
    70.234   743.340     0.150
    70.756   683.340     0.150
    70.756   703.340     0.150
    71.678   702.340     0.150
    72.393   691.840     0.150
    76.566   739.340     0.150
    84.277  1369.340     0.150
    93.086   800.340     0.150
     8.391   319.363     0.150
    20.678   276.562     0.150
    25.056   601.363     0.150
    27.673   645.363     0.150
    27.683   645.363     0.150
    28.392   357.262     0.150
    29.335   358.562     0.150
    29.822   367.363     0.150
    35.628  2632.363     0.150
    59.513   598.762     0.150
    62.936  1205.363     0.150
    71.534   707.363     0.150
    71.534   736.363     0.150
    72.059   717.363     0.150
    73.655   688.363     0.150
    75.739    14.500     0.150
    26.486   337.410     0.150
    26.486   430.109     0.150
    26.486   723.109     0.150
    26.892   280.508     0.150
    26.892   554.109     0.150
    27.631   343.109     0.150
    27.561   404.109     0.150
    27.657   679.109     0.150
    28.197   352.109     0.150
    33.119   405.109     0.150
    33.175   802.109     0.150
    36.279   554.109     0.150
    40.074   458.109     0.150
    40.458   826.109     0.150
    42.380   864.109     0.150
    42.726   475.711     0.150
    42.726   866.211     0.150
    43.661   474.609     0.150
    44.734   497.109     0.150
    45.770   499.109     0.150
    47.692   511.109     0.150
    48.170   924.109     0.150
    49.244   524.410     0.150
    49.244   958.109     0.150
    49.244   524.410     0.150
    49.244   533.109     0.150
    49.244   524.410     0.150
    49.244   524.410     0.150
    49.244   524.410     0.150
    49.314   543.109     0.150
    50.480   544.109     0.150
    50.647   540.109     0.150
    50.647    16.000     0.150
    50.647   578.109     0.150
    50.647   712.109     0.150
    50.647   952.109     0.150
    52.057  1004.109     0.150
    52.432   841.109     0.150
    52.432   995.109     0.150
    52.432  2374.109     0.150
    52.452     6.301     0.150
    52.452   713.109     0.150
    53.626   556.109     0.150
    54.549   641.109     0.150
    54.549   759.109     0.150
    54.549   987.109     0.150
    54.549   999.109     0.150
    54.549  1009.109     0.150
    54.549  1164.109     0.150
    54.826  2386.109     0.150
    56.558     0.199     0.150
    56.558   579.109     0.150
    56.558  1051.109     0.150
    58.129   857.109     0.150
    58.129  1201.109     0.150
    60.460   759.109     0.150
    60.460  1379.109     0.150
    60.555   627.109     0.150
    61.696   823.109     0.150
    61.696   859.109     0.150
    61.696   871.109     0.150
    61.696  1389.109     0.150
    61.726   769.109     0.150
    61.726   849.109     0.150
    62.110   616.910     0.150
    62.110  1108.109     0.150
    62.403   849.109     0.150
    62.403   619.109     0.150
    62.403   768.109     0.150
    62.403   849.109     0.150
    62.403  1125.109     0.150
    62.403  1208.109     0.150
    62.403  1365.109     0.150
    62.444   833.109     0.150
    62.444  1383.109     0.150
    62.444   619.109     0.150
    62.444   769.109     0.150
    62.444   833.109     0.150
    62.444   900.109     0.150
    62.444  1144.109     0.150
    62.444  1383.109     0.150
    62.646   631.109     0.150
    62.646   647.109     0.150
    62.646   844.109     0.150
    62.646  1167.109     0.150
    62.646  1412.109     0.150
    62.646  1534.109     0.150
    64.231  4029.109     0.150
    65.901   666.109     0.150
    66.043   903.109     0.150
    66.043  1444.109     0.150
    68.127   657.609     0.150
    68.127  1199.109     0.150
    68.632   669.109     0.150
    68.632  1449.109     0.150
    69.792   671.109     0.150
    70.005   962.109     0.150
    70.273   929.109     0.150
    70.273  1260.109     0.150
    70.289   675.508     0.150
    70.289   707.609     0.150
    70.289  1228.109     0.150
    70.289  1703.109     0.150
    70.289   670.109     0.150
    70.289   675.109     0.150
    70.289   708.109     0.150
    70.289  1228.109     0.150
    70.289  1242.109     0.150
    70.289  1276.109     0.150
    70.289  1486.109     0.150
    70.289  1703.109     0.150
    70.816  2358.109     0.150
    70.910   672.109     0.150
    71.730  1239.109     0.150
    72.072   956.109     0.150
    72.072  1288.109     0.150
    72.072   681.109     0.150
    72.072   847.109     0.150
    72.072   956.109     0.150
    72.072  1288.109     0.150
    72.012   708.109     0.150
    72.393   949.109     0.150
    72.393  1039.109     0.150
    72.393   682.109     0.150
    72.393   849.109     0.150
    72.393   909.109     0.150
    72.393  1521.109     0.150
    73.122  1231.109     0.150
    73.511   697.109     0.150
    73.511   872.109     0.150
    73.511   977.109     0.150
    73.511  1095.109     0.150
    73.511  1271.109     0.150
    73.511  1764.109     0.150
    73.600   956.109     0.150
    73.731  1326.109     0.150
    74.162   691.609     0.150
    74.669  1209.109     0.150
    75.432   706.109     0.150
    75.432  1295.109     0.150
    75.645  1300.109     0.150
    75.937   713.109     0.150
    75.980   702.109     0.150
    76.186   743.109     0.150
    76.186   899.109     0.150
    76.186  1301.109     0.150
    76.186  1369.109     0.150
    76.186  1835.109     0.150
    76.592   988.109     0.150
    76.592  1349.109     0.150
    76.592  1782.109     0.150
    76.874   718.109     0.150
    77.163  1001.109     0.150
    77.595   723.109     0.150
    77.834   696.109     0.150
    78.188   913.109     0.150
    78.169   716.109     0.150
    78.169     9.000     0.150
    78.169  1310.109     0.150
    78.767   721.309     0.150
    79.260   727.109     0.150
    79.611   735.109     0.150
    79.720   741.109     0.150
    79.537   782.711     0.150
    79.929   723.109     0.150
    80.563   736.109     0.150
    80.776   742.109     0.150
    80.891  1030.109     0.150
    81.045  1047.109     0.150
    82.248   757.711     0.150
    83.064  2540.109     0.150
    83.795   741.109     0.150
    84.121  1043.109     0.150
    84.121  1161.109     0.150
    84.121  1284.109     0.150
    84.121  1402.109     0.150
    84.121  1433.109     0.150
    84.121  1670.109     0.150
    84.121  1890.109     0.150
    84.648  1337.109     0.150
    85.161   738.109     0.150
    86.217   765.410     0.150
    86.217  1411.109     0.150
    87.119   784.109     0.150
    87.119  1419.109     0.150
    90.236  1118.109     0.150
    92.596   798.109     0.150
    92.781  1432.109     0.150
    93.577  1028.109     0.150
    94.625  1157.109     0.150
    94.625  1599.109     0.150
    94.625  1873.109     0.150
    94.625  2097.109     0.150
    96.659   813.609     0.150
    99.100   830.109     0.150
    99.100  1465.109     0.150
   100.483   826.609     0.150
   100.483  1097.109     0.150
   100.792  1471.109     0.150
   100.899   833.109     0.150
   102.761   857.109     0.150
   102.761  1104.109     0.150
   102.761  2169.109     0.150
   103.025   846.109     0.150
   103.025  2190.109     0.150
   103.025  6131.109     0.150
   105.167   840.410     0.150
   105.167  2243.109     0.150
   107.999  1499.109     0.150
   107.999  1599.109     0.150
   112.476  1531.109     0.150
   112.476  1804.109     0.150
   113.387  1174.109     0.150
   117.231   911.609     0.150
   117.231  1122.109     0.150
   124.278   941.109     0.150
   124.278  1189.109     0.150
   124.278  1341.109     0.150
   124.278  1597.109     0.150
   124.278  1901.109     0.150
   134.165  1381.109     0.150
   139.172  1360.109     0.150
   143.263  1784.109     0.150
   143.263  2129.109     0.150
   147.938  2231.109     0.150
   148.035  1596.211     0.150
   148.035  1815.109     0.150
   148.035  2181.109     0.150
   148.035  2889.109     0.150
     7.924   148.555     0.150
     7.924   172.555     0.150
    14.194   283.555     0.150
    23.042   295.555     0.150
    24.428   311.852     0.150
    24.428   328.555     0.150
    24.457   317.656     0.150
    24.457     7.898     0.150
    24.914   331.555     0.150
    26.018   353.555     0.150
    26.018   429.555     0.150
    27.681   403.555     0.150
    27.681   349.352     0.150
    27.681   403.555     0.150
    27.681   626.555     0.150
    27.919   356.555     0.150
    30.438   365.555     0.150
    32.744   476.555     0.150
    32.744   483.555     0.150
    32.988   432.555     0.150
    48.605   643.555     0.150
    50.531    13.297     0.150
    50.791   622.555     0.150
    53.212   616.555     0.150
    53.249   576.555     0.150
    53.249  1007.555     0.150
    55.057   569.352     0.150
    55.057   569.352     0.150
    55.057  1029.555     0.150
    61.252  2415.555     0.150
    62.511    13.797     0.150
    62.511   670.555     0.150
    62.914     5.805     0.150
    62.914   624.453     0.150
    62.914  1126.555     0.150
    68.901   664.555     0.150
    70.555   675.555     0.150
    71.080   886.555     0.150
    71.274   683.055     0.150
    71.274   796.555     0.150
    71.627   686.555     0.150
    71.602    14.000     0.150
    71.602  1236.555     0.150
    72.524  1242.555     0.150
    72.818   713.555     0.150
    76.437   704.555     0.150
    76.775   715.555     0.150
    77.276    14.000     0.150
    77.276   995.555     0.150
    77.276  1794.555     0.150
    78.698   719.555     0.150
    80.456   737.555     0.150
    82.736  1719.555     0.150
    84.991    15.000     0.150
    85.366   809.555     0.150
    85.366   987.555     0.150
    85.366  1554.555     0.150
    85.366  2040.555     0.150
    87.606   762.555     0.150
    90.921  1006.555     0.150
   113.296  1125.555     0.150
   137.222  1157.555     0.150
   138.349  1153.055     0.150
     0.911    12.219     0.150
    19.647   272.219     0.150
    27.646   345.219     0.150
    28.064   352.820     0.150
    29.382   366.617     0.150
    30.146   407.219     0.150
    30.500   376.219     0.150
    31.521   415.219     0.150
    32.208   698.219     0.150
    47.467   511.219     0.150
    48.094   505.320     0.150
    49.549   528.520     0.150
    51.921   543.219     0.150
    57.672   584.219     0.150
    57.772   587.219     0.150
    74.410   699.719     0.150
    75.383   705.219     0.150
    78.953   718.219     0.150
    84.453   754.219     0.150
    84.453   754.219     0.150
    84.773   770.219     0.150
   139.780  1186.219     0.150
   147.163  1179.219     0.150
     6.970   208.473     0.150
    13.313   183.172     0.150
    13.313   190.473     0.150
    15.583   418.473     0.150
    15.583   500.473     0.150
    26.225   346.473     0.150
    26.559   349.473     0.150
    26.676   346.873     0.150
    27.323   356.473     0.150
    27.323   652.473     0.150
    27.960   352.473     0.150
    28.612   386.473     0.150
    28.612  4155.473     0.150
    28.698   367.473     0.150
    29.571   377.473     0.150
    32.870   405.473     0.150
    37.825   446.473     0.150
    37.834   447.473     0.150
    41.238   475.473     0.150
    42.598   484.973     0.150
    48.174   525.572     0.150
    48.240   529.473     0.150
    48.835   541.973     0.150
    49.479   542.773     0.150
    49.587   530.473     0.150
    50.567   532.473     0.150
    52.359   558.473     0.150
    54.724   565.172     0.150
    54.724   576.473     0.150
    57.046   590.473     0.150
    57.046   606.473     0.150
    57.046   645.473     0.150
    58.030   598.473     0.150
    60.380   608.473     0.150
    60.380   617.473     0.150
    61.586   622.473     0.150
    64.014   634.172     0.150
    64.022   636.572     0.150
    66.156   649.473     0.150
    69.825   677.473     0.150
    70.131   672.473     0.150
    70.131   678.473     0.150
    70.791   684.172     0.150
    71.037   672.473     0.150
    71.030   686.473     0.150
    71.084   687.672     0.150
    71.577   680.473     0.150
    71.881   682.473     0.150
    71.881   691.473     0.150
    72.341   685.873     0.150
    72.531   707.473     0.150
    72.815   687.473     0.150
    73.587   692.473     0.150
    75.157   706.473     0.150
    76.480  1276.473     0.150
    76.853   692.473     0.150
    79.612   727.473     0.150
    79.590   730.473     0.150
    81.210   740.373     0.150
    84.011   757.473     0.150
    86.180   766.473     0.150
   148.037  1181.373     0.150
     7.662   124.777     0.150
    29.028    14.400     0.150
    29.028   556.777     0.150
    32.327  3984.777     0.150
    37.352   580.777     0.150
    37.352   813.777     0.150
    47.421   510.377     0.150
    47.421   611.777     0.150
    53.128   633.777     0.150
    54.406   629.777     0.150
    55.486     3.301     0.150
    57.806  2369.777     0.150
    58.794   655.777     0.150
    62.342   645.777     0.150
    66.455   656.777     0.150
    66.945   659.777     0.150
    71.814   678.777     0.150
    76.198   703.777     0.150
    80.936   726.277     0.150
    81.936   735.477     0.150
    84.599   750.678     0.150
    93.017  1272.777     0.150
    14.961   231.576     0.150
    25.119   316.076     0.150
    25.469    17.400     0.150
    26.934   356.576     0.150
    26.934   363.576     0.150
    29.395   364.576     0.150
    30.286   383.576     0.150
    30.286   391.576     0.150
    30.509   385.576     0.150
    47.966   503.275     0.150
    49.078   538.275     0.150
    52.385   613.576     0.150
    52.386   546.576     0.150
    54.225   556.676     0.150
    60.611    15.000     0.150
    62.108   612.576     0.150
    68.192   653.377     0.150
    70.070   690.076     0.150
    70.857   675.576     0.150
    71.282   664.576     0.150
    71.755    11.500     0.150
    72.482    29.801     0.150
    72.654    21.199     0.150
    73.590   691.576     0.150
    73.590   707.576     0.150
    73.590   724.576     0.150
    74.191   693.576     0.150
    74.191   694.576     0.150
    74.191   767.576     0.150
    75.469   715.576     0.150
    75.506   715.576     0.150
    75.599   716.576     0.150
    75.774   704.176     0.150
    80.017   739.576     0.150
    80.551   722.576     0.150
    84.216   736.076     0.150
   101.379   820.576     0.150
   137.950  1157.076     0.150
   138.528  1147.576     0.150
     0.877    14.750     0.150
    16.512   229.352     0.150
    16.512   229.352     0.150
    16.512   229.352     0.150
    27.863   346.852     0.150
    27.863   346.852     0.150
    28.040   368.152     0.150
    29.594   366.750     0.150
    29.786   352.551     0.150
    34.492   405.152     0.150
    39.742   450.152     0.150
    39.568    16.000     0.150
    41.723   479.352     0.150
    46.960   508.352     0.150
    60.087   604.352     0.150
    72.100   685.551     0.150
    73.342   690.352     0.150
    73.342   690.352     0.150
    74.165   691.352     0.150
    75.218    27.000     0.150
    75.931   705.652     0.150
    76.316   706.352     0.150
    76.316   706.352     0.150
    87.355   768.352     0.150
   149.376  1164.852     0.150
     0.863    14.543     0.150
     4.988    72.945     0.150
     5.327    78.145     0.150
    16.480   425.145     0.150
    16.480   425.145     0.150
    16.480   425.145     0.150
    29.199   359.145     0.150
    29.619   367.145     0.150
    42.015   471.145     0.150
    42.931   492.145     0.150
    42.931   498.645     0.150
    42.931   525.945     0.150
    42.931  1098.145     0.150
    42.931  1098.145     0.150
    42.931  1098.145     0.150
    46.927   508.645     0.150
    54.602   566.246     0.150
    54.602   566.246     0.150
    56.419   579.543     0.150
    56.419   579.543     0.150
    63.177   626.543     0.150
    63.177   626.543     0.150
    73.310   690.145     0.150
    73.310   690.145     0.150
    75.122   706.145     0.150
    75.899   706.945     0.150
    76.284   718.145     0.150
    86.151   746.645     0.150
   149.244  4148.344     0.150
     8.847   126.824     0.150
    16.551   414.824     0.150
    16.551   414.824     0.150
    16.551   414.824     0.150
    25.120     9.900     0.150
    28.068   356.824     0.150
    29.538   363.824     0.150
    34.876   422.424     0.150
    37.512   432.824     0.150
    37.745   578.824     0.150
    39.526   467.824     0.150
    42.057   471.024     0.150
    42.057   471.024     0.150
    42.854   556.024     0.150
    42.854   556.024     0.150
    42.854   556.024     0.150
    45.363   498.824     0.150
    54.051    12.000     0.150
    56.497   581.324     0.150
    56.497   581.324     0.150
    60.508   607.224     0.150
    63.725   634.824     0.150
    63.909   631.324     0.150
    70.533   675.824     0.150
    70.533   710.824     0.150
    79.221   721.824     0.150
    82.177   739.024     0.150
     0.990    17.615     0.150
     3.340    47.715     0.150
     3.702    56.814     0.150
     4.560    68.314     0.150
     4.948    72.516     0.150
    16.669   232.314     0.150
    22.326   310.115     0.150
    27.038    11.799     0.150
    27.038   369.715     0.150
    28.055   349.215     0.150
    28.055   633.416     0.150
    28.055   725.115     0.150
    28.437   352.615     0.150
    28.437   637.115     0.150
    28.306   352.115     0.150
    29.178   363.916     0.150
    29.642   364.314     0.150
    29.642   429.115     0.150
    29.642   660.115     0.150
    30.970   384.115     0.150
    30.970   384.916     0.150
    30.970   451.115     0.150
    30.970   671.115     0.150
    30.970   797.115     0.150
    31.978   561.115     0.150
    34.607   491.615     0.150
    34.607   734.115     0.150
    34.607   855.115     0.150
    38.161     0.801     0.150
    38.161   437.615     0.150
    38.161   545.814     0.150
    38.161   581.814     0.150
    38.161   787.814     0.150
    38.890   452.115     0.150
    40.309   456.115     0.150
    40.309   823.715     0.150
    40.309  1019.115     0.150
    41.116   467.115     0.150
    41.832   467.115     0.150
    41.832   467.115     0.150
    41.832  1060.115     0.150
    42.278   510.814     0.150
    42.278   594.814     0.150
    42.278   833.115     0.150
    43.920   598.814     0.150
    44.236    10.199     0.150
    44.881   510.615     0.150
    46.103   512.115     0.150
    46.746   508.215     0.150
    46.497   508.115     0.150
    47.014   498.516     0.150
    47.014   498.516     0.150
    46.967   510.115     0.150
    53.744   739.115     0.150
    53.744  1015.115     0.150
    53.744  1114.115     0.150
    54.914   569.115     0.150
    54.914  1027.115     0.150
    54.914  1049.115     0.150
    55.895   577.115     0.150
    55.895     4.600     0.150
    55.895  1046.115     0.150
    55.895  1064.115     0.150
    56.655   583.814     0.150
    56.741   583.516     0.150
    56.741   789.115     0.150
    56.741  1046.115     0.150
    56.741  1269.115     0.150
    59.343   601.416     0.150
    59.343  1092.416     0.150
    60.200   606.416     0.150
    60.200  1100.715     0.150
    60.616   610.115     0.150
    60.616  1109.115     0.150
    60.802   611.715     0.150
    63.073   626.916     0.150
    63.073  1139.916     0.150
    62.994   626.615     0.150
    63.823   632.115     0.150
    63.823   864.814     0.150
    63.823  1147.115     0.150
    63.773   632.115     0.150
    63.773     6.000     0.150
    63.773  1147.115     0.150
    63.773  1158.115     0.150
    64.423   642.115     0.150
    64.562   636.314     0.150
    64.562     5.301     0.150
    64.562   872.115     0.150
    64.562  1153.615     0.150
    64.562  1562.115     0.150
    64.956   638.516     0.150
    64.956   877.615     0.150
    64.956  1155.516     0.150
    67.582   655.115     0.150
    67.582     6.000     0.150
    67.582  1193.115     0.150
    68.258   659.814     0.150
    68.258  1202.115     0.150
    71.146   679.115     0.150
    71.146  1274.115     0.150
    71.493   734.115     0.150
    71.493   829.115     0.150
    71.493   680.615     0.150
    71.493  1236.115     0.150
    71.579   681.115     0.150
    72.006   684.115     0.150
    72.006     6.000     0.150
    72.006  1247.115     0.150
    72.013   684.115     0.150
    72.013  1246.115     0.150
    72.244   675.115     0.150
    72.346   686.615     0.150
    72.346  1253.115     0.150
    72.283   688.115     0.150
    72.589   688.115     0.150
    72.589  1254.615     0.150
    72.854  1792.115     0.150
    72.903   699.115     0.150
    72.945  1249.115     0.150
    72.945   689.814     0.150
    72.945  1249.115     0.150
    73.271   691.215     0.150
    73.271     5.500     0.150
    73.271  1261.115     0.150
    73.464   693.314     0.150
    73.464   714.715     0.150
    73.464   957.314     0.150
    73.464  1259.115     0.150
    73.464  1259.115     0.150
    73.683   694.615     0.150
    73.683   705.115     0.150
    73.683  1266.615     0.150
    73.704   694.814     0.150
    73.704     5.801     0.150
    73.704  1265.916     0.150
    73.923   693.615     0.150
    73.923    11.000     0.150
    74.060   701.115     0.150
    74.307   698.115     0.150
    74.307  1273.115     0.150
    74.314   703.115     0.150
    75.401   701.715     0.150
    75.404     1.400     0.150
    75.404   703.715     0.150
    75.404     1.400     0.150
    75.711     6.000     0.150
    75.781   706.416     0.150
    75.598   712.016     0.150
    76.044   707.516     0.150
    76.044     6.000     0.150
    76.044  1291.516     0.150
    76.399   709.115     0.150
    76.399  1294.115     0.150
    76.492   710.615     0.150
    76.573   707.115     0.150
    76.573   729.115     0.150
    76.573  1296.115     0.150
    76.573  1310.115     0.150
    77.543   709.115     0.150
    78.266   719.814     0.150
    78.439   717.115     0.150
    78.501   720.615     0.150
    78.501  1314.615     0.150
    78.571   721.314     0.150
    78.571  1004.516     0.150
    78.517   721.115     0.150
    78.517  1317.115     0.150
    78.533   952.314     0.150
    78.533  1292.814     0.150
    78.533  1687.115     0.150
    78.684   729.516     0.150
    78.805   722.715     0.150
    78.805  1322.115     0.150
    79.119   724.416     0.150
    79.119  1323.016     0.150
    79.212   726.115     0.150
    79.212  1325.115     0.150
    79.306   725.615     0.150
    79.306   899.115     0.150
    79.306  1320.016     0.150
    79.306  1383.115     0.150
    79.343   726.814     0.150
    79.343  1379.115     0.150
    79.442  1325.814     0.150
    79.552   727.115     0.150
    79.552  1327.115     0.150
    80.302  1293.115     0.150
    80.848  1403.115     0.150
    81.034   735.814     0.150
    81.034  1347.115     0.150
    81.550   739.115     0.150
    81.711   740.115     0.150
    81.711  1354.115     0.150
    81.711  1410.115     0.150
    81.711  1871.115     0.150
    81.794   738.115     0.150
    81.794  1351.115     0.150
    81.952   741.115     0.150
    81.952  1354.115     0.150
    81.945   745.115     0.150
    82.313     2.000     0.150
    82.313     1.600     0.150
    82.313  1361.115     0.150
    82.367   742.115     0.150
    82.367  1357.115     0.150
    82.471   743.615     0.150
    82.471  1363.115     0.150
    82.485   800.516     0.150
    82.781   741.314     0.150
    82.880   741.115     0.150
    82.902   745.115     0.150
    82.902  1364.516     0.150
    83.635  1059.715     0.150
    86.003   754.115     0.150
    86.364   780.115     0.150
    93.898   796.115     0.150
    98.199   824.314     0.150
    98.199   841.115     0.150
    98.203   823.115     0.150
   149.355  1187.115     0.150
    15.007   209.562     0.150
    23.342   318.562     0.150
    25.272    14.000     0.150
    28.505   359.062     0.150
    45.281   490.562     0.150
    45.281    13.000     0.150
    59.326   595.762     0.150
    61.531   610.762     0.150
    62.898    27.000     0.150
    62.898   618.562     0.150
    62.898    27.000     0.150
    66.701   644.062     0.150
    69.934   680.062     0.150
    70.162   665.562     0.150
    70.162    14.000     0.150
    71.599   676.062     0.150
    71.599   689.562     0.150
    71.598   666.164     0.150
    71.598    23.699     0.150
    71.863   691.164     0.150
    72.371   681.062     0.150
    72.371   694.562     0.150
    72.633   678.562     0.150
    72.633   679.363     0.150
    79.414   720.562     0.150
    81.262   730.562     0.150
     4.481    61.789     0.150
     6.049    88.609     0.150
     7.149   104.759     0.150
    21.793   286.739     0.150
    21.863   289.239     0.150
    72.677   670.239     0.150
    14.858   207.023     0.150
    25.296    15.000     0.150
    25.449   327.223     0.150
    26.281   753.723     0.150
    27.294   338.824     0.150
    27.580    19.102     0.150
    28.116   414.824     0.150
    28.116   619.223     0.150
    28.618   361.324     0.150
    30.286   368.223     0.150
    32.771    27.000     0.150
    32.771   385.824     0.150
    32.771    18.000     0.150
    32.771    27.000     0.150
    32.771   480.824     0.150
    32.771   694.824     0.150
    36.459   417.223     0.150
    36.459    22.602     0.150
    36.459   518.824     0.150
    36.459   750.824     0.150
    36.459   928.824     0.150
    37.619   427.324     0.150
    37.619    18.500     0.150
    39.125   439.023     0.150
    39.125    16.301     0.150
    39.125   789.824     0.150
    40.079   448.824     0.150
    40.079   573.324     0.150
    40.079   808.824     0.150
    45.114   488.426     0.150
    45.114    16.398     0.150
    45.114   880.824     0.150
    45.114  1080.824     0.150
    45.114  1140.824     0.150
    49.546   524.824     0.150
    50.875   531.605     0.150
    50.875  1203.324     0.150
    53.187    20.500     0.150
    53.187   550.824     0.150
    53.187    20.500     0.150
    53.187   994.824     0.150
    54.197   558.523     0.150
    54.197   618.125     0.150
    54.482   559.824     0.150
    54.698   583.324     0.150
    54.912   564.824     0.150
    55.025  1007.824     0.150
    55.025   564.324     0.150
    55.025    16.500     0.150
    55.025  1007.824     0.150
    55.025  1368.824     0.150
    58.791  1058.824     0.150
    58.791  1058.824     0.150
    59.153   593.625     0.150
    61.025     0.398     0.150
    61.251   608.023     0.150
    61.251  1104.625     0.150
    61.251  1497.824     0.150
    61.358   667.824     0.150
    61.982   611.824     0.150
    62.091   613.824     0.150
    62.091    24.000     0.150
    62.091  1117.824     0.150
    62.726   649.324     0.150
    62.726   617.824     0.150
    62.726   649.324     0.150
    63.121   619.926     0.150
    63.121  1121.824     0.150
    63.121  1204.824     0.150
    65.843   638.824     0.150
    65.844   659.125     0.150
    66.361   652.824     0.150
    66.526   642.523     0.150
    66.526    22.301     0.150
    66.526  1189.824     0.150
    69.937    13.598     0.150
    69.995   664.824     0.150
    69.995  1209.824     0.150
    69.995   664.824     0.150
    69.995  1209.824     0.150
    70.504   668.223     0.150
    70.527   668.324     0.150
    70.527   668.324     0.150
    70.568   661.824     0.150
    70.706   666.824     0.150
    70.769   670.824     0.150
    70.882   678.824     0.150
    71.430     8.199     0.150
    71.430   673.426     0.150
    71.629   674.824     0.150
    71.629    27.398     0.150
    71.629  1228.824     0.150
    71.692   675.125     0.150
    72.204   679.125     0.150
    72.204    27.398     0.150
    73.034  1243.824     0.150
    73.275   834.824     0.150
    73.317    33.402     0.150
    73.825   692.824     0.150
    73.825   726.824     0.150
    73.825   761.824     0.150
    73.870   727.824     0.150
    73.870   741.824     0.150
    73.870   760.824     0.150
    74.206   689.824     0.150
    74.206  1258.824     0.150
    74.216   696.824     0.150
    74.216    27.801     0.150
    74.216   756.824     0.150
    74.216   691.023     0.150
    74.216   702.824     0.150
    74.216    27.801     0.150
    74.220   735.926     0.150
    74.552    21.000     0.150
    74.552  1259.824     0.150
    74.901   693.824     0.150
    74.901  1264.824     0.150
    75.359   703.324     0.150
    76.424   702.324     0.150
    77.016   706.324     0.150
    77.016  1289.824     0.150
    77.274   707.824     0.150
    77.274  1286.824     0.150
    77.340   708.824     0.150
    77.406   708.824     0.150
    77.406  1292.824     0.150
    77.470   708.523     0.150
    77.470  1291.824     0.150
    77.470  1325.824     0.150
    77.600  1299.125     0.150
    79.239   719.223     0.150
    79.642   722.324     0.150
    79.642  1316.824     0.150
    80.461  1327.824     0.150
    80.515   725.723     0.150
    80.515  1326.824     0.150
    80.669   726.824     0.150
    80.658    28.398     0.150
    81.088   729.023     0.150
    81.088  1333.824     0.150
    82.258   726.625     0.150
    82.998   725.824     0.150
    84.151    13.000     0.150
    84.151   773.824     0.150
    84.561   736.324     0.150
    86.447   787.523     0.150
    88.209   757.824     0.150
    90.049   767.824     0.150
    92.420   766.723     0.150
    92.839   779.523     0.150
    92.839    23.301     0.150
    93.093   812.926     0.150
    93.413   836.324     0.150
   101.250   819.824     0.150
   116.939  1181.324     0.150
   116.939  1228.824     0.150
   116.939  1266.723     0.150
   141.719  1156.023     0.150
     1.754    27.359     0.150
     1.888    56.710     0.150
     2.217    66.689     0.150
     2.462    70.619     0.150
     3.566    94.920     0.150
     4.297    57.859     0.150
    19.993   267.960     0.150
    53.083   563.560     0.150
    55.480   579.960     0.150
    60.762   601.560     0.150
    65.076   646.359     0.150
    65.771   650.560     0.150
    66.226   652.859     0.150
    66.452   644.560     0.150
    66.452     7.000     0.150
    67.469   664.560     0.150
    69.750   676.560     0.150
    70.808   682.060     0.150
    70.848   683.060     0.150
    71.051    12.000     0.150
    71.051   671.560     0.150
    71.051    12.100     0.150
    71.332   686.260     0.150
    71.558    12.100     0.150
    71.589   686.560     0.150
    71.751   688.060     0.150
    72.081   690.659     0.150
    72.483   691.060     0.150
    72.496   691.260     0.150
    72.723   693.560     0.150
    73.260   696.260     0.150
    73.260    21.000     0.150
    73.601   693.260     0.150
    75.279   709.760     0.150
    80.853   740.060     0.150
    81.688   727.560     0.150
    82.308   744.560     0.150
    82.477   747.560     0.150
    83.245   749.560     0.150
     2.510    41.512     0.150
    18.464   254.222     0.150
    24.492   318.622     0.150
     1.652    49.453     0.150
     4.133    57.912     0.150
    19.215   260.193     0.150
     2.971    48.672     0.150
     4.294    63.531     0.150
    10.122   138.102     0.150
    34.379   398.453     0.150
    72.629   672.852     0.150
     0.310     7.355     0.150
     1.437    44.363     0.150
    13.374   196.055     0.150
    19.202   259.855     0.150
    21.791   290.055     0.150
    72.893   690.453     0.150
     2.991   441.547     0.150
     3.216    47.947     0.150
     3.221    47.787     0.150
     3.237    48.807     0.150
    18.601   252.396     0.150
    18.609   256.146     0.150
    21.565    16.000     0.150
    21.802   294.266     0.150
    23.730   313.596     0.150
    25.364   324.246     0.150
    31.957   384.627     0.150
    32.116   551.107     0.150
    37.610   432.146     0.150
    37.610   570.047     0.150
    42.195    37.799     0.150
    43.704   480.736     0.150
    49.781   525.646     0.150
    60.186   604.447     0.150
    61.768   615.646     0.150
    62.664   629.646     0.150
    62.664   630.047     0.150
    64.207   630.646     0.150
    67.036   659.646     0.150
    67.036   659.646     0.150
    70.286   677.646     0.150
    70.286   677.646     0.150
    70.803   674.246     0.150
    70.803     8.701     0.150
    70.804   674.447     0.150
    71.734   689.646     0.150
    72.161   691.146     0.150
    72.443   692.646     0.150
    73.585   700.646     0.150
    73.948     3.799     0.150
    75.149   699.047     0.150
    77.713   724.846     0.150
    77.713   724.846     0.150
    98.205   824.646     0.150
   147.848  1181.346     0.150
     1.854    31.008     0.150
    19.316   259.098     0.150
    19.928   270.154     0.150
    19.928   267.555     0.150
    22.685   531.555     0.150
    33.126   564.145     0.150
    33.122   534.275     0.150
    61.460   613.455     0.150
    61.674   614.055     0.150
    73.759   692.256     0.150
    73.759   691.756     0.150
     3.866   100.336     0.150
    19.606   262.805     0.150
     3.709    57.381     0.150
    20.010   713.381     0.150
    60.070   587.782     0.150
    60.070   587.782     0.150
    72.373   668.881     0.150
     1.297    23.234     0.150
     1.556    28.531     0.150
     2.159    37.438     0.150
     4.038    61.234     0.150
    45.274   494.836     0.150
    72.802   685.938     0.150
    82.096   740.672     0.150
   150.510  1196.336     0.150
     7.222    99.438     0.150
     1.430    25.537     0.150
     1.434    25.637     0.150
     1.435    25.537     0.150
     1.440    25.387     0.150
     1.451    25.738     0.150
     1.454    25.838     0.150
     1.620    28.137     0.150
     1.729    29.938     0.150
     1.729    51.838     0.150
     2.090    34.537     0.150
     2.115    35.238     0.150
     2.159    35.838     0.150
     2.164    35.838     0.150
     3.485    54.838     0.150
     4.132    64.338     0.150
     4.325    67.637     0.150
     4.708    69.637     0.150
     4.743    73.338     0.150
     4.825    75.338     0.150
     5.467    83.637     0.150
     6.984   103.137     0.150
     7.702   113.537     0.150
    22.068   291.537     0.150
    32.344   556.027     0.150
    35.659   417.438     0.150
    36.360   576.838     0.150
    39.604   453.938     0.150
    39.604   579.938     0.150
    47.699   518.738     0.150
    54.167   568.537     0.150
    56.390   576.438     0.150
    57.844   590.637     0.150
    65.402     8.000     0.150
    70.924   676.438     0.150
    70.924   676.438     0.150
    72.872   687.338     0.150
    77.074   712.238     0.150
    77.074   722.938     0.150
    78.995   722.438     0.150
   116.566  1125.938     0.150
   148.083  1185.637     0.150
     1.280    40.185     0.150
     5.976    88.385     0.150
    12.958   339.985     0.150
    45.270   487.485     0.150
     1.624    27.767     0.150
     3.475    53.667     0.150
    83.846   738.066     0.150
     5.900    82.680     0.150
     6.039    83.883     0.150
     6.271    86.781     0.150
    32.356   383.859     0.150
    46.501   501.383     0.150
    61.000   621.281     0.150
     1.177    19.075     0.150
    31.067   388.975     0.150
    44.377   489.475     0.150
    61.038   609.675     0.150
     0.438   -58.430     0.150
     0.438    24.971     0.150
     1.211    21.270     0.150
     2.560    72.070     0.150
     7.583   122.371     0.150
    19.991    19.902     0.150
    24.173    20.598     0.150
    19.642   284.562     0.150
    70.623   671.363     0.150
    70.623    16.000     0.150
    70.623   671.363     0.150
    70.623    16.000     0.150
     4.883   143.064     0.150
    12.707  1029.346     0.150
    23.635    10.299     0.150
    27.101   351.445     0.150
    27.101   351.445     0.150
    27.101   601.445     0.150
    29.581  2210.645     0.150
    36.876   421.645     0.150
    43.194   472.445     0.150
    43.187   475.545     0.150
    45.742   493.645     0.150
    46.173   503.145     0.150
    48.454   519.996     0.150
    50.915   536.346     0.150
    59.077   594.045     0.150
    59.458   597.645     0.150
    59.458  1084.545     0.150
    61.909   614.945     0.150
    61.909  1116.445     0.150
    62.513   618.645     0.150
    62.916   621.445     0.150
    63.674   625.445     0.150
    65.683     9.600     0.150
    65.683    13.100     0.150
    65.789     8.000     0.150
    66.564   644.945     0.150
    66.564    13.000     0.150
    66.956   648.445     0.150
    66.956    10.500     0.150
    66.956    14.500     0.150
    67.623    17.900     0.150
    67.623   651.445     0.150
    67.623     9.500     0.150
    67.623    17.900     0.150
    67.623   678.645     0.150
    67.623  1175.645     0.150
    71.728   680.246     0.150
    71.728     9.199     0.150
    71.728  1234.445     0.150
    71.728   680.246     0.150
    71.728     9.699     0.150
    71.728  1234.445     0.150
    71.728   680.246     0.150
    71.728     9.699     0.150
    71.821   680.746     0.150
    71.896   677.145     0.150
    72.109   678.145     0.150
    72.625   685.445     0.150
    72.625   705.445     0.150
    72.625   685.445     0.150
    72.625   705.445     0.150
    73.401     9.000     0.150
    73.401   687.945     0.150
    73.401     9.000     0.150
    74.372   693.445     0.150
    74.372    17.199     0.150
    78.172   715.045     0.150
    78.172   724.846     0.150
    78.172    12.900     0.150
    78.172  1308.145     0.150
    79.180   720.445     0.150
    79.180    16.000     0.150
    79.452   725.045     0.150
   161.221  1184.645     0.150
     2.501    65.004     0.150
     3.476    97.801     0.150
     4.113    58.102     0.150
     1.750    29.429     0.150
     1.876    31.429     0.150
     2.170    35.429     0.150
    13.303   191.129     0.150
    21.537   291.649     0.150
    21.662   292.199     0.150
    21.876   295.060     0.150
    58.050     9.000     0.150
    65.981     9.000     0.150
    66.314     8.000     0.150
    68.767   670.729     0.150
    69.857   677.449     0.150
    70.019   678.260     0.150
    70.651   672.530     0.150
    70.651     9.700     0.150
    70.712   681.729     0.150
    70.865   682.530     0.150
    70.935   681.639     0.150
    70.963   683.659     0.150
    71.575   680.929     0.150
    71.575     6.300     0.150
    72.013   689.929     0.150
    72.340   686.229     0.150
    72.347   686.229     0.150
    72.350   692.639     0.150
    72.420   668.629     0.150
    72.420   676.729     0.150
    72.518   687.229     0.150
    72.872   694.889     0.150
    72.962   696.659     0.150
    73.064   696.429     0.150
    73.321   691.830     0.150
    74.351     9.600     0.150
    75.027     9.900     0.150
    81.691   734.909     0.150
     0.548    27.871     0.150
     2.283    35.828     0.150
     3.993    58.438     0.150
     4.032    59.656     0.150
     4.075    59.219     0.150
     4.647    68.168     0.150
     4.652    68.387     0.150
     4.800    69.496     0.150
     4.993    72.668     0.150
     7.790   109.809     0.150
    10.256   141.508     0.150
    15.442   209.867     0.150
    21.622   285.906     0.150
    27.722   347.758     0.150
    30.395   370.586     0.150
    49.791    14.398     0.150
    49.695   529.598     0.150
    53.411   622.918     0.150
    62.638   622.188     0.150
    63.536    24.801     0.150
    65.510    11.801     0.150
    66.293    15.500     0.150
    66.725    14.199     0.150
    66.725   890.766     0.150
    66.854    20.801     0.150
    71.518   674.066     0.150
    71.732   677.367     0.150
    72.163   678.266     0.150
    74.679   694.867     0.150
    75.242   699.766     0.150
    75.462   707.289     0.150
    75.990   703.766     0.150
    77.332   711.266     0.150
    77.330   719.559     0.150
    77.768   714.969     0.150
    77.879   714.066     0.150
    78.482   715.766     0.150
    79.070    23.000     0.150
    79.180   721.367     0.150
    79.344   722.168     0.150
    80.020   724.488     0.150
    82.216    24.699     0.150
    82.628   740.617     0.150
    83.861   745.469     0.150
    85.793   770.867     0.150
    93.612   781.367     0.150
   160.532  1209.266     0.150
   160.532  1241.469     0.150
     1.607    27.176     0.150
     2.757    76.375     0.150
     3.178    49.117     0.150
     6.670    96.594     0.150
    20.270   735.117     0.150
    20.270   520.965     0.150
    20.270   537.566     0.150
    20.270  2322.016     0.150
    20.558   288.414     0.150
    20.558   302.215     0.150
    20.558   483.516     0.150
    21.832   295.266     0.150
    23.585    12.500     0.150
    23.720    11.809     0.150
    23.799    12.051     0.150
    23.931    12.141     0.150
    25.584    12.629     0.150
    28.165   412.715     0.150
    28.842   368.914     0.150
    30.129   560.641     0.150
    31.530    19.500     0.150
    33.989   575.086     0.150
    34.938    14.023     0.150
    47.101   499.316     0.150
    48.330    23.684     0.150
    48.736    12.551     0.150
    52.191   560.035     0.150
    53.230   555.645     0.150
    53.425   622.691     0.150
    53.425   634.867     0.150
    53.937   560.027     0.150
    56.004   587.516     0.150
    56.511   578.996     0.150
    56.481   591.516     0.150
    57.239   270.758     0.150
    57.239   580.824     0.150
    58.275   604.566     0.150
    58.884   650.117     0.150
    59.589   602.926     0.150
    61.589    11.699     0.150
    61.589    23.398     0.150
    62.057    19.699     0.150
    62.653   622.016     0.150
    62.784   666.016     0.150
    65.424    13.000     0.150
    65.424    17.398     0.150
    65.509     9.500     0.150
    66.199   552.062     0.150
    66.199   641.234     0.150
    66.294    10.500     0.150
    66.294    16.000     0.150
    66.427   657.516     0.150
    66.615   658.516     0.150
    66.730    13.000     0.150
    66.730    18.301     0.150
    66.730   912.914     0.150
    67.558   672.215     0.150
    67.556   640.414     0.150
    68.984   797.414     0.150
    71.510   677.125     0.150
    71.747    10.500     0.150
    71.747   677.016     0.150
    71.747    10.199     0.150
    71.747   695.516     0.150
    72.087   680.715     0.150
    72.634     9.598     0.150
    72.634  1245.816     0.150
    72.690     4.801     0.150
    72.701   684.715     0.150
    73.004   686.016     0.150
    73.414   697.016     0.150
    73.525   689.055     0.150
    74.037   691.977     0.150
    74.115   692.617     0.150
    74.173   693.316     0.150
    74.282   693.055     0.150
    74.538   695.316     0.150
    74.583   702.715     0.150
    74.686   694.715     0.150
    74.686     7.801     0.150
    74.741    18.797     0.150
    74.970    11.102     0.150
    75.101    16.000     0.150
    75.103    16.301     0.150
    75.258   700.016     0.150
    75.427    17.500     0.150
    75.435    13.500     0.150
    75.875    13.000     0.150
    75.875    20.000     0.150
    76.095    13.500     0.150
    76.329   706.375     0.150
    76.519   711.215     0.150
    76.519   736.215     0.150
    76.734   709.695     0.150
    77.784   714.766     0.150
    77.834   714.816     0.150
    77.894   714.516     0.150
    77.963   714.617     0.150
    77.963   715.766     0.150
    78.113   715.215     0.150
    78.674   719.516     0.150
    78.674    11.000     0.150
    79.190   719.895     0.150
    79.445   721.414     0.150
    79.888   737.516     0.150
    80.130   729.305     0.150
    80.160  2345.316     0.150
    80.267   727.816     0.150
    81.369   744.637     0.150
    81.567   731.137     0.150
    81.542   732.465     0.150
    81.667    11.398     0.150
    81.657   732.574     0.150
    81.739   749.914     0.150
    81.824     9.598     0.150
    82.067   737.824     0.150
    82.235   736.676     0.150
    82.476   751.266     0.150
    82.494   737.297     0.150
    82.643   741.188     0.150
    84.596   760.234     0.150
    85.688   765.547     0.150
    85.809    10.000     0.150
    88.221   763.824     0.150
    99.844   833.867     0.150
   100.404   834.465     0.150
   115.418  1131.188     0.150
   151.791  1202.676     0.150
     1.401    42.961     0.150
     1.865    32.828     0.150
    32.774   399.414     0.150
    59.501     4.297     0.150
    66.008     4.398     0.150
    66.192     4.203     0.150
    66.929    14.000     0.150
    67.185     4.797     0.150
    67.185     7.000     0.150
    71.437   680.305     0.150
    77.822   715.406     0.150
    81.513   736.445     0.150
    81.783   737.727     0.150
    82.255   740.891     0.150
    82.330   740.711     0.150
    82.834   743.211     0.150
     1.571    27.640     0.150
     2.037    33.690     0.150
     3.170    46.041     0.150
     4.358    61.760     0.150
    12.870   325.585     0.150
    15.863   400.210     0.150
    25.409    18.000     0.150
    25.409   389.541     0.150
    25.409   432.541     0.150
    25.409  1196.541     0.150
    25.423    17.000     0.150
    25.423   464.680     0.150
    26.382   392.000     0.150
    26.382   702.000     0.150
    27.680   411.280     0.150
    28.166   404.660     0.150
    28.171   449.690     0.150
    28.171   662.690     0.150
    28.651   352.090     0.150
    28.651   490.090     0.150
    28.656   416.930     0.150
    29.368   431.860     0.150
    29.368   547.860     0.150
    38.689    20.300     0.150
    38.689   547.860     0.150
    38.930   986.860     0.150
    39.268    14.020     0.150
    42.190   478.318     0.150
    42.916   607.860     0.150
    42.916   849.860     0.150
    43.189   500.360     0.150
    43.680   483.420     0.150
    43.689     0.206     0.150
    43.689    13.858     0.150
    43.689   602.486     0.150
    43.689   803.956     0.150
    43.689   842.856     0.150
    43.689   480.541     0.150
    44.736    14.380     0.150
    47.111    13.800     0.150
    47.975   547.960     0.150
    47.975   569.960     0.150
    48.383   647.694     0.150
    48.735   895.531     0.150
    48.712   519.410     0.150
    49.797    12.400     0.150
    49.657   957.940     0.150
    53.153  1161.335     0.150
    53.389   735.860     0.150
    53.389  1325.860     0.150
    53.889   560.740     0.150
    55.145   763.061     0.150
    55.145  1362.061     0.150
    55.526  1171.423     0.150
    55.526  1174.328     0.150
    55.263     0.070     0.150
    57.947   591.980     0.150
    58.846    11.000     0.150
    58.860   810.860     0.150
    60.246     5.420     0.150
    60.787     5.690     0.150
    61.353     6.610     0.150
    61.440     6.030     0.150
    61.440   766.351     0.150
    61.440   966.460     0.150
    61.440  1538.200     0.150
    61.564   618.000     0.150
    62.069    13.000     0.150
    62.069    17.000     0.150
    62.526     7.080     0.150
    62.602   655.101     0.150
    62.602   655.120     0.150
    62.602  1159.831     0.150
    62.602  1591.021     0.150
    62.602  1033.800     0.150
    62.602  2400.150     0.150
    62.749  1118.860     0.150
    62.749  1531.860     0.150
    63.511   772.860     0.150
    63.511  1545.860     0.150
    63.790   626.570     0.150
    64.032   628.170     0.150
    64.072   628.430     0.150
    64.674   632.870     0.150
    64.810   633.610     0.150
    65.418   635.860     0.150
    65.418    13.000     0.150
    65.513   911.860     0.150
    65.694   677.860     0.150
    66.178     0.027     0.150
    66.178     1.159     0.150
    66.178  1166.514     0.150
    66.562   644.960     0.150
    66.562   645.050     0.150
    66.714   915.860     0.150
    66.714   919.860     0.150
    66.823   677.860     0.150
    66.823  1212.960     0.150
    66.823  1612.760     0.150
    66.786   646.660     0.150
    67.095   734.160     0.150
    67.515  1228.460     0.150
    67.506   647.960     0.150
    67.506  2294.860     0.150
    67.887    15.000     0.150
    67.887   675.360     0.150
    68.319   656.190     0.150
    68.483   657.510     0.150
    68.936    15.700     0.150
    68.936    21.400     0.150
    69.614  1230.736     0.150
    69.896   913.041     0.150
    70.661   670.960     0.150
    70.974   935.700     0.150
    70.974  1714.530     0.150
    71.155   676.760     0.150
    71.155   949.860     0.150
    71.155  1267.860     0.150
    71.155  1693.860     0.150
    71.155  2343.860     0.150
    71.155  2365.460     0.150
    71.253   674.081     0.150
    71.304   674.521     0.150
    71.660  2343.561     0.150
    71.696  1234.860     0.150
    71.696  2337.860     0.150
    71.696   677.061     0.150
    71.696   835.860     0.150
    71.696  1234.660     0.150
    71.696  2337.760     0.150
    71.847   947.860     0.150
    71.847  1493.860     0.150
    71.847  1729.860     0.150
    72.340    20.700     0.150
    72.605  2341.360     0.150
    72.605  2551.960     0.150
    72.605  2341.360     0.150
    72.605  2551.960     0.150
    72.819    15.000     0.150
    72.819   843.860     0.150
    74.450    21.200     0.150
    74.450  1564.360     0.150
    74.453   713.200     0.150
    74.665   694.460     0.150
    74.665     9.400     0.150
    74.665    15.400     0.150
    75.879    15.000     0.150
    75.812   719.860     0.150
    75.812   728.860     0.150
    75.812  1293.860     0.150
    75.812  1533.860     0.150
    75.845   707.860     0.150
    75.950    21.000     0.150
    75.955    10.600     0.150
    76.673   722.960     0.150
    76.986   701.700     0.150
    77.417    14.800     0.150
    77.296   709.670     0.150
    77.793  1001.860     0.150
    77.793  1317.860     0.150
    78.140   723.860     0.150
    78.375  1005.860     0.150
    78.375  1613.860     0.150
    78.456   715.530     0.150
    78.722  1001.860     0.150
    78.772   714.331     0.150
    78.743    21.660     0.150
    79.042  1015.860     0.150
    79.493   720.890     0.150
    80.148   724.450     0.150
    80.319    25.760     0.150
    81.047   744.860     0.150
    81.143  1021.860     0.150
    81.692   726.760     0.150
    82.152   803.561     0.150
    83.069  1730.580     0.150
    83.344   739.860     0.150
    83.994  1407.360     0.150
    84.309   741.081     0.150
    85.736   753.320     0.150
    89.855   778.900     0.150
    90.296   780.590     0.150
    90.282   776.180     0.150
    90.282   776.240     0.150
    91.339   785.740     0.150
    93.605   816.860     0.150
    94.150   787.860     0.150
   100.451  1020.360     0.150
   100.451  1483.460     0.150
   102.265   837.240     0.150
   103.830   844.561     0.150
   107.301   871.860     0.150
   137.101  1149.800     0.150
   147.215  1171.460     0.150
   151.234  1192.268     0.150
   151.234  1181.500     0.150
   151.234  1188.259     0.150
   151.234  1193.559     0.150
     6.636    92.419     0.150
    20.242    11.500     0.150
    23.945    12.950     0.150
    23.945    18.875     0.150
    26.420   330.609     0.150
    33.613   395.329     0.150
    48.744   519.049     0.150
    51.194    15.280     0.150
    53.433   554.969     0.150
    61.342   611.749     0.150
    66.367   645.469     0.150
    66.556   647.469     0.150
    66.749   643.569     0.150
    68.919   658.639     0.150
    70.644   670.469     0.150
    71.683   676.669     0.150
    71.833   677.469     0.150
    72.569  1244.269     0.150
    72.592   871.169     0.150
    72.592   871.169     0.150
    73.350    22.500     0.150
    74.518    10.500     0.150
    75.942   718.849     0.150
    76.811   706.589     0.150
    77.090   705.469     0.150
    77.461   723.269     0.150
    77.578   710.449     0.150
    77.948   711.159     0.150
    81.690   741.369     0.150
   109.199  1116.269     0.150
   114.972  1127.969     0.150
   137.113  1156.969     0.150
   147.233  1176.669     0.150
   160.401  1227.569     0.150
   160.401  2286.769     0.150
     3.171    45.590     0.150
     3.171    78.010     0.150
    60.123   595.168     0.150
    22.454   297.055     0.150
    25.573   326.715     0.150
    62.140   622.965     0.150
    65.361     4.500     0.150
    65.541     4.500     0.150
    66.278    10.500     0.150
    71.234   673.367     0.150
    71.565   675.957     0.150
    72.196   711.367     0.150
    72.904   716.566     0.150
    74.468   693.066     0.150
    74.468    14.000     0.150
    75.912    15.000     0.150
    88.689   927.676     0.150
   150.799  1191.277     0.150
     2.932    76.961     0.150
     5.529   135.582     0.150
    30.457   367.716     0.150
    42.131   465.246     0.150
    61.817   612.865     0.150
    70.522   670.365     0.150
    71.062   671.166     0.150
    72.730   684.266     0.150
    72.730     9.000     0.150
     1.225    38.723     0.150
    18.666   252.922     0.150
    20.332   487.223     0.150
    22.289   310.773     0.150
    22.694   314.293     0.150
    22.692   314.953     0.150
    23.984   325.562     0.150
    24.078   326.602     0.150
    24.138   327.602     0.150
    24.205   328.434     0.150
    24.315    13.840     0.150
    24.615   332.191     0.150
    25.198    13.531     0.150
    54.952   561.621     0.150
    58.702   584.922     0.150
    60.927   603.422     0.150
    61.502   608.922     0.150
    61.600   610.398     0.150
    62.540   615.422     0.150
    66.493    16.301     0.150
    66.493    23.000     0.150
    71.860   676.922     0.150
    73.520   692.422     0.150
    74.844   696.023     0.150
    78.043    12.500     0.150
    79.039   704.922     0.150
    81.526   729.922     0.150
   117.510  1118.945     0.150
     8.334   121.094     0.150
    18.448   245.496     0.150
    20.572   982.344     0.150
    22.848   296.516     0.150
    23.071    22.770     0.150
    24.590    22.949     0.150
    25.564    23.180     0.150
    25.835    23.090     0.150
    27.236    37.520     0.150
    33.892   575.566     0.150
    33.892   588.016     0.150
    33.903   577.207     0.150
    33.903   587.926     0.150
    34.314   576.344     0.150
    35.876   579.145     0.150
    36.061   582.734     0.150
    36.438   585.105     0.150
    36.438   594.617     0.150
    36.611   585.395     0.150
    37.983   443.195     0.150
    39.587   593.176     0.150
    41.081   450.195     0.150
    44.748    33.801     0.150
    47.888   498.406     0.150
    49.073    21.648     0.150
    51.439    25.000     0.150
    52.751   540.094     0.150
    55.012   565.715     0.150
    60.976    21.602     0.150
    61.105   601.621     0.150
    62.151    29.699     0.150
    62.258   615.695     0.150
    64.668    25.500     0.150
    64.668    38.000     0.150
    64.767    25.500     0.150
    65.542    26.000     0.150
    65.985    30.000     0.150
    65.985    40.000     0.150
    65.985   896.195     0.150
    67.539    22.281     0.150
    70.855    30.000     0.150
    71.409   668.895     0.150
    72.015    30.199     0.150
    72.273  1315.492     0.150
    72.322  1776.492     0.150
    72.612   722.594     0.150
    73.062    28.898     0.150
    73.355    29.602     0.150
    73.958   684.496     0.150
    74.776   689.395     0.150
    74.934   690.297     0.150
    75.135   686.496     0.150
    76.668    25.602     0.150
    77.456   703.984     0.150
    81.340   943.297     0.150
    93.510    34.551     0.150
    97.141   798.996     0.150
   161.097  1170.594     0.150
     1.208    37.902     0.150
     2.602    41.551     0.150
    82.037   732.570     0.150
   150.226  1181.820     0.150
     3.803    57.682     0.150
     7.557   108.631     0.150
     0.502    10.320     0.150
     5.446    75.062     0.150
    23.593    12.148     0.150
    60.124   592.766     0.150
    60.293   601.164     0.150
     3.245    50.124     0.150
     0.622    14.691     0.150
     0.637    14.771     0.150
     1.493    27.271     0.150
     1.571    28.541     0.150
     1.647    27.861     0.150
     1.653    29.381     0.150
     1.687    29.881     0.150
     1.743    29.841     0.150
     1.770    30.521     0.150
     1.829    31.531     0.150
     1.840    31.481     0.150
     1.871    31.861     0.150
     1.957    33.892     0.150
     1.951    33.321     0.150
     2.046    34.812     0.150
     2.095    35.222     0.150
     2.252    37.451     0.150
     3.747    58.312     0.150
     4.265    64.291     0.150
     6.442    93.821     0.150
     6.693    98.831     0.150
    18.646   533.986     0.150
    20.969   287.491     0.150
    28.017   357.091     0.150
    29.227   558.041     0.150
    30.298   559.541     0.150
    32.687   565.341     0.150
    39.854    15.500     0.150
    43.881  1116.991     0.150
    48.146    12.601     0.150
    50.788    10.500     0.150
    50.788    14.300     0.150
    53.175    10.400     0.150
    53.175    14.200     0.150
    58.163    15.899     0.150
    59.677     9.600     0.150
    59.677    13.200     0.150
    60.376  2373.091     0.150
    61.597   612.901     0.150
    66.074    10.500     0.150
    66.074    14.100     0.150
    66.074  1421.591     0.150
    66.406   644.991     0.150
    66.406    11.000     0.150
    66.879  1197.191     0.150
    67.086    10.000     0.150
    67.086    14.000     0.150
    67.069     9.000     0.150
    67.069    13.000     0.150
    70.620     5.300     0.150
    70.683   673.392     0.150
    70.683    10.000     0.150
    71.880   679.642     0.150
    72.259   680.892     0.150
    72.657   684.621     0.150
    73.804    11.600     0.150
    73.775    15.699     0.150
    73.775  1262.191     0.150
    73.887    10.301     0.150
    73.948     9.500     0.150
    74.022    10.000     0.150
    74.026     9.800     0.150
    74.385     9.200     0.150
    74.411    10.000     0.150
    75.062     9.900     0.150
    76.812   709.392     0.150
    77.313  1665.491     0.150
    77.382   713.591     0.150
    77.859   715.091     0.150
    78.839   720.251     0.150
    81.864   736.091     0.150
   159.626  1202.191     0.150
   160.434  1203.791     0.150
     1.884    30.980     0.150
     1.825    53.641     0.150
     4.535    69.570     0.150
     4.968    74.660     0.150
     4.968   133.617     0.150
     5.235    76.820     0.150
     5.577    81.930     0.150
     6.219    92.777     0.150
     6.251    90.707     0.150
     7.562   109.539     0.150
     8.265   119.680     0.150
    20.541    12.000     0.150
    26.521   540.230     0.150
    46.831   500.027     0.150
    46.831    13.500     0.150
    49.524    14.801     0.150
    63.478   631.828     0.150
    65.200    13.398     0.150
    65.200    18.898     0.150
    67.557   659.430     0.150
    71.282    25.000     0.150
    71.828   677.027     0.150
    81.533   730.629     0.150
    81.627   731.230     0.150
     0.806    14.727     0.150
     0.826    14.807     0.150
     4.530    64.227     0.150
     4.617    67.027     0.150
     5.020   152.287     0.150
     5.020    71.827     0.150
     5.178    72.797     0.150
     5.383    72.027     0.150
     5.383    77.327     0.150
     5.566    79.247     0.150
     6.161    89.027     0.150
     7.057   100.927     0.150
     8.350   117.977     0.150
     8.350   206.377     0.150
     8.350   118.027     0.150
     8.350   206.427     0.150
     9.125   129.427     0.150
    14.689   201.767     0.150
    14.689   201.727     0.150
    15.136   214.077     0.150
    19.860   524.227     0.150
    21.595   289.527     0.150
    28.955   355.527     0.150
    29.173   361.627     0.150
    29.173   546.627     0.150
    29.340   362.752     0.150
    29.340   546.952     0.150
    30.782   374.977     0.150
    30.782   550.143     0.150
    33.979   399.457     0.150
    34.066   403.127     0.150
    34.170   559.517     0.150
    34.978   411.527     0.150
    37.400   431.927     0.150
    38.112   438.327     0.150
    41.363   465.577     0.150
    41.363   465.627     0.150
    43.698   481.027     0.150
    43.969   486.677     0.150
    43.969   590.152     0.150
    47.004   503.237     0.150
    47.884   608.327     0.150
    47.884   839.927     0.150
    47.884   516.927     0.150
    47.884   608.327     0.150
    47.884   627.327     0.150
    47.884   839.927     0.150
    47.884   927.127     0.150
    47.884   942.927     0.150
    47.884  1108.627     0.150
    49.064   524.802     0.150
    49.064   524.827     0.150
    49.065   525.027     0.150
    49.525   526.927     0.150
    50.138   526.607     0.150
    50.576     9.700     0.150
    50.576    13.700     0.150
    50.576   533.827     0.150
    50.576     9.700     0.150
    50.576    13.700     0.150
    50.576   964.627     0.150
    50.569   535.827     0.150
    52.952   552.027     0.150
    53.551   557.797     0.150
    53.551     5.530     0.150
    53.781   558.865     0.150
    53.781   624.640     0.150
    53.781   558.827     0.150
    53.781   624.627     0.150
    54.098   564.877     0.150
    54.098   564.877     0.150
    54.165   564.427     0.150
    54.281   563.327     0.150
    54.800   567.767     0.150
    54.800     7.790     0.150
    55.304   570.327     0.150
    56.313   577.027     0.150
    56.799   579.397     0.150
    58.009   588.827     0.150
    58.029   589.127     0.150
    58.266   589.957     0.150
    59.635    10.000     0.150
    59.635   883.527     0.150
    59.635   601.127     0.150
    59.635    10.000     0.150
    59.635   736.827     0.150
    59.635   883.527     0.150
    59.635  1088.827     0.150
    59.635  1187.527     0.150
    59.860   602.577     0.150
    59.860   602.627     0.150
    61.662   614.627     0.150
    61.662   614.602     0.150
    61.662   614.627     0.150
    61.910   616.302     0.150
    61.910   616.327     0.150
    62.835   622.327     0.150
    62.835  1123.027     0.150
    62.892   622.737     0.150
    62.892     8.440     0.150
    64.119   627.407     0.150
    64.557   630.487     0.150
    64.557   630.627     0.150
    64.759   634.307     0.150
    65.173   636.927     0.150
    66.000   994.827     0.150
    66.206     4.500     0.150
    66.206     6.800     0.150
    66.206   644.027     0.150
    66.206     4.500     0.150
    66.206     6.800     0.150
    66.300   643.927     0.150
    67.476     9.900     0.150
    67.476    14.600     0.150
    67.476   652.527     0.150
    67.476     9.900     0.150
    67.476    14.600     0.150
    67.827   644.527     0.150
    67.994   660.027     0.150
    67.994   677.227     0.150
    69.320   663.647     0.150
    70.144   674.147     0.150
    71.026   679.227     0.150
    71.455   682.227     0.150
    71.455   677.627     0.150
    71.455     4.600     0.150
    71.983   686.227     0.150
    71.983   681.027     0.150
    71.983   681.027     0.150
    71.983   686.027     0.150
    71.983   681.027     0.150
    71.983   686.227     0.150
    72.173     4.400     0.150
    72.173   682.627     0.150
    72.173   699.927     0.150
    72.666     4.600     0.150
    72.893     4.500     0.150
    73.600     4.800     0.150
    73.600   689.327     0.150
    73.600     4.800     0.150
    73.600  1265.127     0.150
    73.722   691.470     0.150
    74.863   701.327     0.150
    75.401    12.300     0.150
    75.401  1310.327     0.150
    76.665    10.700     0.150
    76.665    13.300     0.150
    76.665   706.327     0.150
    76.665    10.700     0.150
    76.665   718.527     0.150
    76.665    13.300     0.150
    76.665  1289.827     0.150
    77.490   714.427     0.150
    77.490   714.427     0.150
    78.204   717.397     0.150
    78.578   718.227     0.150
    78.693   720.217     0.150
    80.213   728.615     0.150
    81.300   979.527     0.150
    81.902   732.327     0.150
    83.011   737.227     0.150
    84.157   748.027     0.150
    92.041   791.387     0.150
    94.383   795.027     0.150
    95.237   805.867     0.150
   123.715  1135.965     0.150
   146.806  1165.827     0.150
     5.594    79.753     0.150
    21.255   282.413     0.150
    27.923   345.253     0.150
    43.429   479.713     0.150
    47.828   509.913     0.150
    50.520   532.113     0.150
    66.155     7.000     0.150
    66.155    11.301     0.150
    67.431    10.000     0.150
    67.431    14.000     0.150
    71.983   681.113     0.150
    71.983     6.000     0.150
    82.557   739.413     0.150
    13.842   189.633     0.150
    45.196   491.613     0.150
   147.945  1179.023     0.150
     2.254    62.664     0.150
     3.744    55.891     0.150
     4.128    62.891     0.150
     4.789    69.863     0.150
    20.158   268.184     0.150
    82.953   734.691     0.150
     1.788    29.707     0.150
     1.829    30.229     0.150
     2.026    32.467     0.150
     4.966   127.217     0.150
     5.567    78.988     0.150
     6.733    94.197     0.150
     6.881    97.367     0.150
     6.881   173.467     0.150
    14.537   202.438     0.150
    14.537   358.717     0.150
    15.790   218.768     0.150
    19.295   265.047     0.150
    22.537   298.523     0.150
    27.247   392.268     0.150
    27.247   403.867     0.150
    27.247   713.467     0.150
    27.247   981.967     0.150
    28.152   365.867     0.150
    29.113   416.768     0.150
    29.113   426.768     0.150
    33.412   393.268     0.150
    37.234   426.068     0.150
    37.843   433.367     0.150
    41.985   468.168     0.150
    45.946   501.428     0.150
    46.832   507.268     0.150
    48.132   530.318     0.150
    48.262     6.400     0.150
    49.785   527.268     0.150
    49.785   527.768     0.150
    49.785   951.768     0.150
    52.495   547.967     0.150
    54.442   568.867     0.150
    56.230   576.268     0.150
    56.887     0.029     0.150
    59.771    10.100     0.150
    59.771    14.400     0.150
    59.957   601.867     0.150
    60.270   603.967     0.150
    60.270   603.967     0.150
    60.270   603.967     0.150
    60.270   604.188     0.150
    60.270   604.168     0.150
    60.625   606.668     0.150
    62.458   665.867     0.150
    62.458  1153.768     0.150
    62.458  1209.768     0.150
    62.858     9.699     0.150
    63.271    10.400     0.150
    63.271    14.900     0.150
    64.016   628.867     0.150
    64.585   633.967     0.150
    65.005   634.367     0.150
    66.136   659.568     0.150
    66.811   671.568     0.150
    67.129     9.500     0.150
    67.157     5.801     0.150
    67.604   648.768     0.150
    69.693   671.367     0.150
    70.056   668.268     0.150
    70.056     9.801     0.150
    70.056   668.268     0.150
    70.056     9.801     0.150
    70.573   668.467     0.150
    70.572   671.768     0.150
    70.572    10.900     0.150
    70.572   671.768     0.150
    70.572    10.900     0.150
    70.572   671.768     0.150
    70.572    10.900     0.150
    71.504   677.367     0.150
    71.520    10.799     0.150
    71.520    14.100     0.150
    71.649   701.168     0.150
    72.560   683.568     0.150
    74.895     8.100     0.150
    74.895    14.400     0.150
    74.895   971.168     0.150
    75.379   699.418     0.150
    75.602   702.338     0.150
    76.370   704.887     0.150
    76.557   705.668     0.150
    76.749   706.908     0.150
    76.885    11.400     0.150
    76.885  1283.068     0.150
    77.493   711.568     0.150
    78.116   900.668     0.150
    79.564   719.557     0.150
    80.169   726.838     0.150
    81.045   731.367     0.150
    82.775   735.268     0.150
    82.094   719.717     0.150
    19.289   260.443     0.150
    19.289   519.193     0.150
    19.289   730.494     0.150
    21.544   282.434     0.150
    23.441   305.645     0.150
    23.441    13.949     0.150
    23.441    13.949     0.150
    23.441   305.645     0.150
    23.441    13.949     0.150
    33.248    10.041     0.150
    33.430   393.773     0.150
    33.430    16.311     0.150
    50.049   530.555     0.150
    58.800   590.924     0.150
    60.661   603.773     0.150
    64.022   624.715     0.150
    70.766   670.055     0.150
    70.766   670.055     0.150
    74.458   695.654     0.150
    75.125   698.754     0.150
    79.099    13.426     0.150
    81.157   731.854     0.150
    81.507   733.453     0.150
    81.649   732.254     0.150
    81.738   734.754     0.150
    82.196   736.654     0.150
     0.726    24.488     0.150
     4.517    69.320     0.150
     7.642   110.020     0.150
    19.766   264.961     0.150
    19.766   731.359     0.150
    23.747   308.465     0.150
    23.747    14.297     0.150
    23.747    14.297     0.150
    25.433    14.262     0.150
    60.993   606.090     0.150
   147.691  1186.621     0.150
     4.142    59.289     0.150
     4.638    65.148     0.150
    13.050   182.789     0.150
     2.965    80.018     0.150
     5.766    84.906     0.150
     8.519   117.496     0.150
    22.681    13.740     0.150
    23.552   303.666     0.150
    29.826   363.146     0.150
    31.183   373.246     0.150
    35.809   413.367     0.150
    44.607    18.023     0.150
    49.858    22.801     0.150
    57.202    16.000     0.150
    57.202    23.000     0.150
    60.208   599.447     0.150
    66.120    19.500     0.150
     1.388    44.125     0.150
     1.843    29.891     0.150
     3.688    56.320     0.150
    18.801   256.570     0.150
    22.878    11.031     0.150
    24.367   313.992     0.150
    24.751    11.945     0.150
    25.742   332.000     0.150
    26.155   336.945     0.150
    28.816   741.320     0.150
    29.345   366.273     0.150
    33.242   388.023     0.150
    37.976   433.422     0.150
    42.106   467.023     0.150
    43.678   474.523     0.150
    45.813   512.320     0.150
    52.541   547.320     0.150
    52.541    11.375     0.150
    58.835   607.227     0.150
    59.144   595.023     0.150
    59.173   592.227     0.150
    59.173   604.922     0.150
    59.173   592.227     0.150
    59.173   592.227     0.150
    59.479   607.227     0.150
    59.479     7.000     0.150
    59.479    10.398     0.150
    59.479   737.523     0.150
    60.001   597.422     0.150
    60.001   608.922     0.150
    60.001   597.422     0.150
    60.001   597.422     0.150
    60.671   605.695     0.150
    60.671   605.695     0.150
    60.671    11.602     0.150
    62.945    14.102     0.150
    63.113   619.922     0.150
    63.113   619.852     0.150
    66.875   649.023     0.150
    70.339   678.023     0.150
    70.678   682.625     0.150
    70.678   682.625     0.150
    70.840   683.320     0.150
    71.066   684.625     0.150
    71.445   674.625     0.150
    71.445    11.867     0.150
    71.580   688.125     0.150
    71.580   688.125     0.150
    71.982   688.922     0.150
    72.103   690.523     0.150
    72.319   679.227     0.150
    72.319   678.977     0.150
    72.904   694.125     0.150
    72.985   695.625     0.150
    73.008   694.820     0.150
    73.154   695.625     0.150
    73.394   696.922     0.150
    73.539   698.523     0.150
    73.612   698.125     0.150
    73.979   701.727     0.150
    75.486   710.422     0.150
    76.484   716.523     0.150
    76.650   708.820     0.150
    78.882   716.984     0.150
    81.004   742.320     0.150
    83.438   743.695     0.150
    84.087   745.875     0.150
     0.918    17.430     0.150
     0.947    17.398     0.150
     1.111    31.930     0.150
     1.058    19.203     0.150
     1.044    18.875     0.150
     1.044    18.805     0.150
     1.097    19.820     0.150
     1.278    22.711     0.150
     1.658    27.758     0.150
     2.137    37.320     0.150
     2.137    65.375     0.150
     2.230    38.500     0.150
     2.474    42.172     0.150
     3.956    63.422     0.150
     4.547    70.984     0.150
     4.591    70.570     0.150
     4.593    71.305     0.150
     4.623    72.469     0.150
     4.671    73.102     0.150
     4.677    73.180     0.150
     4.740    73.211     0.150
     4.933    76.773     0.150
     5.031    76.141     0.150
     5.181    79.680     0.150
     6.059    91.102     0.150
     6.506    97.445     0.150
     7.245   108.180     0.150
     7.292   109.375     0.150
     7.731   113.164     0.150
     7.757   114.531     0.150
     7.838   114.805     0.150
     8.302   199.602     0.150
     8.302   115.898     0.150
     8.302   199.602     0.150
     8.647   126.203     0.150
     9.389   135.695     0.150
    13.590   195.273     0.150
    20.320   272.289     0.150
    20.320   524.289     0.150
    20.320   272.305     0.150
    20.320   524.305     0.150
    20.559     8.297     0.150
    25.447   329.266     0.150
    25.447   329.305     0.150
    26.995   341.500     0.150
    29.976   368.305     0.150
    30.222   370.102     0.150
    33.296   390.102     0.150
    33.205   396.930     0.150
    33.641   400.305     0.150
    34.271   402.820     0.150
    38.911   446.102     0.150
    40.578   455.805     0.150
    40.578    16.594     0.150
    43.284   476.102     0.150
    44.792   489.602     0.150
    44.773   606.852     0.150
    44.773   492.430     0.150
    44.773    15.094     0.150
    44.773   593.094     0.150
    44.773   606.852     0.150
    44.773   492.398     0.150
    44.773    15.102     0.150
    44.773   593.102     0.150
    44.773   606.898     0.150
    45.660   496.500     0.150
    47.078   510.602     0.150
    47.078   603.703     0.150
    48.296   517.398     0.150
    48.296   517.102     0.150
    48.296   517.703     0.150
    48.407   518.805     0.150
    49.767   535.500     0.150
    53.235   552.602     0.150
    53.460   554.750     0.150
    53.460   622.125     0.150
    53.460   554.805     0.150
    53.460   622.102     0.150
    55.835   573.398     0.150
    59.162   596.000     0.150
    60.914   606.898     0.150
    61.447   611.305     0.150
    61.447   611.305     0.150
    61.587   612.203     0.150
    62.032   622.398     0.150
    63.482   623.898     0.150
    65.414   909.398     0.150
    65.414  1226.602     0.150
    65.812   641.805     0.150
    66.897   802.805     0.150
    67.595   651.602     0.150
    69.021   660.633     0.150
    70.489   670.805     0.150
    71.246   674.203     0.150
    71.246   674.203     0.150
    71.537   676.203     0.150
    71.577   676.305     0.150
    71.750   677.898     0.150
    71.750   700.000     0.150
    71.788   678.102     0.150
    71.788   678.102     0.150
    71.893   679.102     0.150
    72.014   680.398     0.150
    72.093   679.602     0.150
    72.224   680.805     0.150
    72.697   684.000     0.150
    72.697   684.000     0.150
    73.069   685.102     0.150
    73.385   688.203     0.150
    73.399   687.812     0.150
    73.544   688.398     0.150
    73.747   689.898     0.150
    73.748   689.898     0.150
    73.748   690.102     0.150
    73.831   689.898     0.150
    74.079   691.500     0.150
    74.215   692.703     0.150
    74.220   692.500     0.150
    74.243   692.500     0.150
    74.371   693.000     0.150
    74.535   692.898     0.150
    74.613   694.602     0.150
    74.765   695.500     0.150
    74.827   695.703     0.150
    74.931   696.398     0.150
    75.065   697.805     0.150
    75.142   698.500     0.150
    75.144   698.250     0.150
    75.144   698.305     0.150
    75.168   698.305     0.150
    75.467   700.500     0.150
    75.475   700.602     0.150
    75.779   701.305     0.150
    76.006   702.898     0.150
    76.227   704.500     0.150
    76.230   699.500     0.150
    76.236   704.102     0.150
    76.240   703.000     0.150
    76.327   705.703     0.150
    76.348   704.602     0.150
    76.348   706.000     0.150
    76.697   706.805     0.150
    76.777   708.000     0.150
    77.108   710.000     0.150
    77.191   710.398     0.150
    77.390   711.102     0.150
    77.390   711.102     0.150
    77.415   711.703     0.150
    77.570   711.305     0.150
    77.761   713.398     0.150
    77.848   713.602     0.150
    78.043   713.000     0.150
    78.444   716.703     0.150
    78.491   718.000     0.150
    78.508   718.305     0.150
    78.578   716.898     0.150
    79.269   719.703     0.150
    79.529   722.500     0.150
    80.904   748.703     0.150
    83.004   741.203     0.150
    83.101   741.703     0.150
    96.981   807.500     0.150
   120.072  1128.703     0.150
   123.230  1133.820     0.150
   123.230  1133.805     0.150
   148.590  1199.102     0.150
   159.708  1221.703     0.150
   159.708  1234.602     0.150
   159.708  1214.305     0.150
   159.708  1221.703     0.150
   160.306  1235.805     0.150
   160.515  1219.203     0.150
   160.515  1238.102     0.150
   160.515  1214.500     0.150
   160.515  1219.203     0.150
   161.375  1269.102     0.150
   161.375  1239.805     0.150
     1.555    25.170     0.150
     3.454    53.859     0.150
     5.396    78.721     0.150
    13.478   189.990     0.150
    13.478   332.750     0.150
    14.813   205.420     0.150
    24.470   314.020     0.150
    30.447   368.520     0.150
    43.666   478.721     0.150
    45.244   492.291     0.150
    61.614   610.041     0.150
    63.324   619.221     0.150
    63.484   756.820     0.150
    72.134   675.922     0.150
     0.809    27.316     0.150
     5.551    81.395     0.150
     5.787    91.457     0.150
     6.782   106.695     0.150
     8.747   122.457     0.150
    18.493   253.758     0.150
    18.493   253.746     0.150
    20.190   276.047     0.150
    20.216     9.707     0.150
    20.259   283.926     0.150
    21.253   287.188     0.150
    22.627   300.535     0.150
    24.569   320.156     0.150
    24.569   320.105     0.150
    25.555   328.375     0.150
    25.566   328.188     0.150
    25.946   334.098     0.150
    26.313   335.539     0.150
    26.571   337.863     0.150
    28.063   347.727     0.150
    28.885   357.734     0.150
    29.166   358.387     0.150
    29.236   764.305     0.150
    30.659   364.156     0.150
    31.390   380.605     0.150
    31.426   380.656     0.150
    32.482   389.328     0.150
    37.120   425.906     0.150
    37.748   437.555     0.150
    37.840   434.836     0.150
    40.282   454.805     0.150
    41.828   468.586     0.150
    43.888   478.855     0.150
    43.888   581.355     0.150
    43.747   483.137     0.150
    43.829   483.047     0.150
    44.673   491.668     0.150
    44.673     9.668     0.150
    44.692   489.535     0.150
    46.909   509.156     0.150
    47.131   510.176     0.150
    48.163    11.500     0.150
    49.702   528.406     0.150
    49.702   528.457     0.150
    49.702   610.258     0.150
    50.799    12.500     0.150
    54.514   564.758     0.150
    58.141   589.957     0.150
    58.141   720.855     0.150
    58.141  1067.457     0.150
    58.141  1294.355     0.150
    58.141   589.957     0.150
    58.141   720.855     0.150
    58.141  1067.457     0.150
    58.141  1087.258     0.150
    58.141  1294.355     0.150
    59.054   595.656     0.150
    59.185   597.176     0.150
    59.663    10.898     0.150
    59.663    14.699     0.150
    59.869   602.156     0.150
    62.763   621.457     0.150
    62.763  1125.758     0.150
    63.851   628.906     0.150
    63.851   664.676     0.150
    63.903   628.777     0.150
    66.037    13.098     0.150
    66.037  1417.555     0.150
    66.228   643.855     0.150
    66.228   643.828     0.150
    66.401    13.199     0.150
    66.401   915.055     0.150
    66.401   918.957     0.150
    67.014    10.500     0.150
    67.014    14.500     0.150
    67.048    10.500     0.150
    67.048    14.301     0.150
    67.048   649.656     0.150
    67.048    10.500     0.150
    67.048   798.855     0.150
    67.048  1177.156     0.150
    67.048  1438.055     0.150
    67.048   649.656     0.150
    67.048    10.500     0.150
    67.048    14.301     0.150
    67.048   798.855     0.150
    67.048  1177.156     0.150
    67.048  1194.957     0.150
    67.048  1438.055     0.150
    67.115   651.055     0.150
    67.115    11.703     0.150
    67.922   654.926     0.150
    68.890   662.484     0.150
    69.186   664.258     0.150
    69.981   668.355     0.150
    69.981    11.699     0.150
    70.139   669.957     0.150
    70.139   669.957     0.150
    70.187   670.156     0.150
    70.187   670.156     0.150
    70.497   672.125     0.150
    70.497    10.402     0.150
    70.499   671.957     0.150
    70.499    11.699     0.150
    70.499   672.055     0.150
    70.499    11.602     0.150
    70.510   672.055     0.150
    70.510   672.055     0.150
    70.556   672.156     0.150
    70.556    11.602     0.150
    70.625   672.355     0.150
    70.625   672.355     0.150
    70.728   673.457     0.150
    70.728   673.457     0.150
    70.852   673.758     0.150
    70.852   673.758     0.150
    70.918   674.555     0.150
    70.918   674.555     0.150
    70.932   674.656     0.150
    70.932   674.656     0.150
    70.991   675.555     0.150
    70.991    11.402     0.150
    71.321   676.355     0.150
    71.321   676.328     0.150
    71.328   675.965     0.150
    71.413    10.301     0.150
    71.413    14.500     0.150
    71.399   677.656     0.150
    71.399    11.500     0.150
    71.399   677.656     0.150
    71.399    11.500     0.150
    71.851   680.758     0.150
    71.851    11.797     0.150
    71.871   679.918     0.150
    72.111   682.055     0.150
    72.182   682.457     0.150
    72.182   682.457     0.150
    72.196   682.656     0.150
    72.196    11.301     0.150
    72.269   682.984     0.150
    72.287   683.316     0.150
    72.400   683.156     0.150
    72.400    12.102     0.150
    72.442   684.355     0.150
    72.442    11.199     0.150
    72.453   683.758     0.150
    72.453   683.758     0.150
    72.486   683.656     0.150
    72.486    11.699     0.150
    72.708   685.258     0.150
    72.708   685.258     0.150
    72.769   685.758     0.150
    72.769   685.758     0.150
    72.803   685.855     0.150
    72.803   685.855     0.150
    72.912   686.555     0.150
    72.965   690.855     0.150
    72.949   686.758     0.150
    72.949   686.758     0.150
    73.188   687.957     0.150
    73.188   687.957     0.150
    73.249   689.258     0.150
    73.249     9.098     0.150
    73.331   688.855     0.150
    73.331   688.855     0.150
    73.413   690.355     0.150
    73.413    10.902     0.150
    73.407   689.258     0.150
    73.407   689.258     0.150
    73.487   689.656     0.150
    73.487   689.656     0.150
    73.779   689.258     0.150
    73.779    14.199     0.150
    73.781   692.055     0.150
    73.781   692.055     0.150
    74.321   694.555     0.150
    74.376   695.195     0.150
    74.536   696.258     0.150
    74.536   696.258     0.150
    74.784   697.355     0.150
    74.784   697.355     0.150
    74.945   699.656     0.150
    74.945   699.656     0.150
    74.966   699.957     0.150
    74.966   699.957     0.150
    75.282   700.656     0.150
    75.282   700.656     0.150
    75.391   701.895     0.150
    75.405   701.457     0.150
    75.405   701.457     0.150
    75.494   702.008     0.150
    75.723   704.156     0.150
    75.723   704.156     0.150
    75.925   704.555     0.150
    75.925   704.555     0.150
    76.150   705.078     0.150
    76.263   706.656     0.150
    76.263   706.656     0.150
    76.280   707.156     0.150
    76.307   705.758     0.150
    76.307   705.758     0.150
    76.348   706.656     0.150
    76.348   706.656     0.150
    76.524   707.836     0.150
    76.550   708.707     0.150
    76.664   708.457     0.150
    76.664   708.457     0.150
    76.780   708.055     0.150
    76.780    14.602     0.150
    76.780   884.555     0.150
    76.780   987.055     0.150
    76.780  1287.457     0.150
    76.780  1584.957     0.150
    76.780   708.055     0.150
    76.780    14.602     0.150
    76.780    21.500     0.150
    76.780   884.555     0.150
    76.780   987.055     0.150
    76.780  1287.457     0.150
    76.780  1314.855     0.150
    76.780  1584.957     0.150
    76.841   708.766     0.150
    77.049   711.055     0.150
    77.049   711.055     0.150
    77.392   712.305     0.150
    78.170   716.957     0.150
    78.170   716.957     0.150
    80.016   725.555     0.150
    80.945   732.457     0.150
    80.942   732.887     0.150
    81.459   732.098     0.150
    82.090   738.137     0.150
    83.352   750.156     0.150
    83.977   746.078     0.150
    84.284   748.555     0.150
    94.056   794.156     0.150
    98.788   815.555     0.150
   159.720  1247.055     0.150
   160.357  1249.457     0.150
   160.528  1249.957     0.150
     1.256    21.863     0.150
     4.544    70.363     0.150
     7.461   108.566     0.150
     9.669   135.566     0.150
    11.136   160.266     0.150
    12.232   912.941     0.150
    12.232   912.941     0.150
    12.448   176.945     0.150
    19.351   262.066     0.150
    19.971   272.125     0.150
    20.087   533.109     0.150
    20.087   272.566     0.150
    20.087   525.863     0.150
    20.087   533.164     0.150
    20.087   272.555     0.150
    20.087   525.906     0.150
    20.087   533.113     0.150
    20.087   740.816     0.150
    21.636     8.102     0.150
    21.474   289.523     0.150
    22.102   295.734     0.150
    23.131   306.273     0.150
    24.441   320.086     0.150
    24.575   322.016     0.150
    25.387   328.066     0.150
    25.560   332.363     0.150
    27.151   341.305     0.150
    27.679   344.664     0.150
    28.285   351.766     0.150
    28.285   351.766     0.150
    28.213   353.105     0.150
    28.283   354.766     0.150
    28.410   354.414     0.150
    28.707   355.195     0.150
    29.030   360.684     0.150
    29.030   766.863     0.150
    29.069   362.543     0.150
    29.150   554.641     0.150
    29.150   361.434     0.150
    29.150   547.434     0.150
    29.150   554.637     0.150
    29.150   766.664     0.150
    29.623   365.664     0.150
    30.689   373.625     0.150
    30.705   374.906     0.150
    30.705   552.012     0.150
    30.705   557.863     0.150
    31.220   379.605     0.150
    32.333   389.184     0.150
    32.576   391.375     0.150
    32.723   393.504     0.150
    32.870   393.523     0.150
    33.719   560.016     0.150
    33.719   565.816     0.150
    34.901   411.914     0.150
    35.113   413.523     0.150
    37.698   525.164     0.150
    37.698   576.465     0.150
    37.698   929.766     0.150
    37.698   431.305     0.150
    37.753   435.934     0.150
    37.987   579.941     0.150
    38.830   445.043     0.150
    38.830     7.262     0.150
    39.559   447.555     0.150
    39.807   454.875     0.150
    41.267   464.023     0.150
    42.551   472.363     0.150
    42.314   473.605     0.150
    42.674   602.766     0.150
    42.674  1077.566     0.150
    43.886   479.266     0.150
    43.849   483.965     0.150
    43.849     5.500     0.150
    43.826   598.191     0.150
    43.826   486.363     0.150
    43.826   598.164     0.150
    43.826   486.344     0.150
    43.826   598.184     0.150
    43.826   820.566     0.150
    44.012   486.363     0.150
    44.012   486.363     0.150
    44.012   601.664     0.150
    44.068   485.996     0.150
    44.572   489.906     0.150
    44.996   494.574     0.150
    44.996     7.250     0.150
    45.327   497.227     0.150
    47.307  3566.641     0.150
    47.313  3562.527     0.150
    47.325  3561.152     0.150
    47.345   512.523     0.150
    47.345     7.793     0.150
    47.566   515.984     0.150
    47.659   515.234     0.150
    48.048   515.363     0.150
    48.462  3656.988     0.150
    48.476  3654.203     0.150
    48.480  3647.922     0.150
    48.541   521.066     0.150
    49.126   524.125     0.150
    48.875  3674.344     0.150
    48.973  3677.363     0.150
    49.762   528.926     0.150
    50.632   540.066     0.150
    50.632   540.023     0.150
    51.766   545.586     0.150
    54.005   561.066     0.150
    54.221   562.934     0.150
    54.221   627.387     0.150
    55.151   570.496     0.150
    56.287   643.965     0.150
    56.589   580.266     0.150
    56.589   580.801     0.150
    58.229   591.074     0.150
    59.860    10.102     0.150
    59.860    14.102     0.150
    59.952   829.465     0.150
    60.828   609.363     0.150
    61.680   614.863     0.150
    62.980     7.500     0.150
    63.324   626.613     0.150
    64.932   637.566     0.150
    64.932     7.398     0.150
    64.932   637.594     0.150
    64.932     7.391     0.150
    64.932   772.715     0.150
    65.157   638.539     0.150
    66.476     6.898     0.150
    66.476    10.898     0.150
    66.430   647.664     0.150
    67.180   651.363     0.150
    67.180     7.301     0.150
    67.180   651.316     0.150
    67.180     7.297     0.150
    67.180   788.746     0.150
    67.499   654.363     0.150
    68.262   658.965     0.150
    69.316   661.465     0.150
    69.316   661.465     0.150
    71.105   677.363     0.150
    71.584    10.297     0.150
    71.584    14.199     0.150
    71.888   681.164     0.150
    71.888   681.164     0.150
    71.888     7.801     0.150
    71.888   681.164     0.150
    71.888     7.801     0.150
    71.888   692.465     0.150
    72.084   682.965     0.150
    72.084   682.965     0.150
    72.130   683.066     0.150
    72.130   683.066     0.150
    72.400   684.504     0.150
    72.400   684.465     0.150
    72.400     8.699     0.150
    72.400   703.863     0.150
    72.414   684.664     0.150
    72.414   684.664     0.150
    72.486   685.266     0.150
    72.471   685.164     0.150
    72.471   685.164     0.150
    72.583   685.363     0.150
    72.583   685.363     0.150
    72.816   686.793     0.150
    72.688   686.363     0.150
    72.688   686.363     0.150
    72.742   686.574     0.150
    72.809   686.664     0.150
    72.809   686.664     0.150
    72.876   687.465     0.150
    72.876   687.465     0.150
    72.893   687.664     0.150
    72.893   687.664     0.150
    73.421   690.566     0.150
    73.421   691.035     0.150
    73.317   690.266     0.150
    73.317     7.699     0.150
    73.317   690.266     0.150
    73.317     7.699     0.150
    73.786     7.398     0.150
    73.726   692.664     0.150
    74.002   693.836     0.150
    74.021   694.566     0.150
    74.119   694.863     0.150
    74.119   694.863     0.150
    74.157   695.266     0.150
    74.297   696.566     0.150
    74.297     7.699     0.150
    74.297   696.566     0.150
    74.297     7.699     0.150
    74.296   695.453     0.150
    74.296     7.684     0.150
    74.333   696.066     0.150
    74.391   696.266     0.150
    74.394   696.266     0.150
    74.394   696.266     0.150
    74.567   698.066     0.150
    74.567     7.898     0.150
    74.567   698.066     0.150
    74.567     7.898     0.150
    74.647   697.664     0.150
    74.647   697.664     0.150
    74.727   698.363     0.150
    74.727   698.363     0.150
    74.752   698.465     0.150
    74.752   698.465     0.150
    74.816   698.965     0.150
    74.816   698.965     0.150
    74.831   698.965     0.150
    74.831     7.500     0.150
    74.899   699.266     0.150
    74.899   699.266     0.150
    74.998   700.363     0.150
    74.998     9.000     0.150
    75.107   700.664     0.150
    75.107     7.402     0.150
    75.107   713.266     0.150
    75.107   700.664     0.150
    75.107     7.402     0.150
    75.107   713.266     0.150
    75.119   720.066     0.150
    75.138   700.465     0.150
    75.138   700.465     0.150
    75.199   701.164     0.150
    75.199     7.199     0.150
    75.199   701.164     0.150
    75.199     7.199     0.150
    75.299   702.266     0.150
    75.299     6.898     0.150
    75.299   715.566     0.150
    75.299   702.266     0.150
    75.299     6.898     0.150
    75.299   715.566     0.150
    75.284   701.363     0.150
    75.284   701.363     0.150
    75.357   701.664     0.150
    75.357   701.664     0.150
    75.441   702.266     0.150
    75.441   702.266     0.150
    75.736   704.465     0.150
    75.723   704.363     0.150
    75.723   704.363     0.150
    75.821   705.965     0.150
    76.200   706.363     0.150
    76.277   706.965     0.150
    76.277   706.965     0.150
    76.494   708.566     0.150
    76.494   708.566     0.150
    76.739   709.766     0.150
    76.739   709.766     0.150
    76.797   709.535     0.150
    76.886   711.664     0.150
    76.886   711.664     0.150
    76.907   712.066     0.150
    76.907   712.066     0.150
    77.231   712.766     0.150
    77.231   712.766     0.150
    77.334   713.977     0.150
    77.351   713.566     0.150
    77.351   713.566     0.150
    77.569   716.445     0.150
    77.666   716.164     0.150
    77.666   716.164     0.150
    77.887   716.965     0.150
    77.887   716.965     0.150
    77.976   717.566     0.150
    78.228   719.066     0.150
    78.223   718.766     0.150
    78.223   718.766     0.150
    78.266   717.766     0.150
    78.266   717.766     0.150
    78.332   718.965     0.150
    78.304   718.664     0.150
    78.304   718.664     0.150
    78.479   719.887     0.150
    78.631   720.664     0.150
    78.646   720.066     0.150
    78.605   720.266     0.150
    78.605   720.266     0.150
    78.791   721.266     0.150
    78.791   721.266     0.150
    79.012   722.777     0.150
    78.994   722.664     0.150
    78.994   722.664     0.150
    79.135   722.863     0.150
    79.925   726.664     0.150
    80.106   728.465     0.150
    80.106   728.465     0.150
    80.611   731.727     0.150
    80.647   730.164     0.150
    80.647   730.113     0.150
    80.798   731.656     0.150
    80.963   733.039     0.150
    81.697   736.965     0.150
    82.095   740.363     0.150
    82.533   739.453     0.150
    82.520   742.914     0.150
    82.808   743.066     0.150
    82.983   745.285     0.150
    82.993   744.844     0.150
    84.053   746.637     0.150
    85.019   752.496     0.150
   107.416  1785.090     0.150
   107.416  1797.691     0.150
   109.204  8215.070     0.150
   109.215  8219.539     0.150
   109.221  8214.910     0.150
   124.148  1137.316     0.150
   159.462  1238.363     0.150
     0.708    14.539     0.150
     0.708    14.539     0.150
     0.708    25.129     0.150
     2.284    35.211     0.150
     2.905    44.340     0.150
     3.119    46.441     0.150
     3.119    80.332     0.150
     3.494    51.340     0.150
     3.865    56.621     0.150
     4.149    61.070     0.150
     4.305    63.379     0.150
     4.923    70.840     0.150
     5.232    75.109     0.150
     5.532    79.262     0.150
     5.556    80.281     0.150
     5.582    80.289     0.150
     6.769    95.340     0.150
     6.769   170.039     0.150
     9.041   125.340     0.150
    11.526   284.641     0.150
    12.160   294.750     0.150
    12.858   178.371     0.150
    18.708  2344.734     0.150
    21.073   281.422     0.150
    21.557   285.961     0.150
    22.930   300.152     0.150
    23.928   309.492     0.150
    24.866   319.730     0.150
    25.861   328.051     0.150
    26.249   331.031     0.150
    26.403   330.621     0.150
    26.907   336.625     0.150
    26.922   352.129     0.150
    27.296   338.949     0.150
    28.161   348.520     0.150
    28.161   348.617     0.150
    28.465   351.152     0.150
    28.901   354.730     0.150
    30.559  2291.941     0.150
    30.806   371.711     0.150
    31.421   375.340     0.150
    31.421   375.359     0.150
    32.362   384.992     0.150
    32.413   386.141     0.150
    32.485   386.582     0.150
    32.775   388.961     0.150
    32.848  2284.566     0.150
    32.848   387.469     0.150
    34.343   402.039     0.150
    34.343   402.516     0.150
    34.754   406.449     0.150
    38.064   434.352     0.150
    38.535   437.680     0.150
    39.589   447.539     0.150
    40.564   452.422     0.150
    41.191   458.242     0.150
    41.629   462.742     0.150
    41.814     5.703     0.150
    41.814   583.840     0.150
    41.814  1011.039     0.150
    41.901   463.742     0.150
    42.131   467.191     0.150
    42.181   467.141     0.150
    42.472   598.242     0.150
    42.472  1071.039     0.150
    42.745   470.129     0.150
    42.781   469.852     0.150
    43.585   474.340     0.150
    43.585   474.641     0.150
    44.977   489.891     0.150
    44.991   489.289     0.150
    45.211   491.402     0.150
    46.029   496.902     0.150
    46.282   497.211     0.150
    46.603   502.039     0.150
    46.799   503.340     0.150
    47.434   509.852     0.150
    48.772  3669.152     0.150
    48.778  3671.512     0.150
    48.790  3673.305     0.150
    49.216   520.520     0.150
    49.290   522.691     0.150
    49.403   522.641     0.150
    49.403   522.582     0.150
    49.866   526.840     0.150
    50.495    15.598     0.150
    50.495    22.699     0.150
    51.180   536.730     0.150
    52.115   542.039     0.150
    52.115   542.039     0.150
    52.326   544.172     0.150
    54.060   557.840     0.150
    54.239   558.789     0.150
    55.832   570.230     0.150
    57.840   588.641     0.150
    57.861   584.422     0.150
    58.309   579.152     0.150
    58.649   802.141     0.150
    58.946   591.641     0.150
    58.958   592.441     0.150
    58.958   592.441     0.150
    59.366    12.699     0.150
    59.366    18.199     0.150
    59.587   596.480     0.150
    59.787   597.242     0.150
    59.787   597.242     0.150
    60.209   599.801     0.150
    60.816    18.852     0.150
    60.816    26.250     0.150
    61.217   607.660     0.150
    61.381   609.340     0.150
    61.381   609.320     0.150
    61.515   609.852     0.150
    61.646   610.410     0.150
    61.699   610.340     0.150
    61.699   610.340     0.150
    62.841   618.531     0.150
    62.905   753.340     0.150
    62.905  1372.840     0.150
    62.905   617.992     0.150
    63.174   620.312     0.150
    63.174   620.312     0.150
    63.294   621.949     0.150
    63.324   622.129     0.150
    63.397   621.441     0.150
    63.462   622.871     0.150
    63.618   622.992     0.150
    63.694   623.641     0.150
    63.870   625.242     0.150
    64.031   626.219     0.150
    64.476   629.180     0.150
    64.485   630.641     0.150
    64.584   630.199     0.150
    65.558   637.539     0.150
    65.750    13.199     0.150
    65.750    18.500     0.150
    66.101    16.199     0.150
    66.191   640.699     0.150
    66.326   641.441     0.150
    66.602   786.441     0.150
    66.752    14.000     0.150
    66.752    19.000     0.150
    66.753    13.801     0.150
    66.753    18.801     0.150
    67.081   645.941     0.150
    67.429   648.641     0.150
    67.851   651.039     0.150
    68.322   654.840     0.150
    68.936    17.059     0.150
    69.159   660.340     0.150
    69.849   672.270     0.150
    69.943   664.742     0.150
    69.946   682.141     0.150
    69.946   664.340     0.150
    69.946   679.641     0.150
    69.946  1204.641     0.150
    69.946  1696.641     0.150
    70.156    14.918     0.150
    70.459   693.109     0.150
    70.459    18.000     0.150
    70.459   667.340     0.150
    70.459   693.141     0.150
    70.470   667.641     0.150
    70.538   668.441     0.150
    70.794   670.160     0.150
    70.794   688.480     0.150
    70.854   670.539     0.150
    70.854   687.742     0.150
    70.877   669.539     0.150
    70.958   671.141     0.150
    70.958    17.000     0.150
    70.988   671.141     0.150
    70.988   688.641     0.150
    71.115    14.602     0.150
    71.167   672.641     0.150
    71.167   690.242     0.150
    71.187   671.039     0.150
    71.230   670.711     0.150
    71.230    17.539     0.150
    71.371   673.641     0.150
    71.372   673.391     0.150
    71.388   673.539     0.150
    71.388   691.141     0.150
    71.510   673.840     0.150
    71.557   674.109     0.150
    71.680   675.340     0.150
    71.680   675.340     0.150
    71.728   675.320     0.150
    71.799   676.039     0.150
    71.799   693.641     0.150
    71.821   676.641     0.150
    71.982   677.082     0.150
    72.054   677.219     0.150
    72.078   677.840     0.150
    72.134   677.859     0.150
    72.153   677.941     0.150
    72.153   695.742     0.150
    72.155   678.539     0.150
    72.155   696.039     0.150
    72.179   678.340     0.150
    72.179   678.340     0.150
    72.219   678.941     0.150
    72.223   679.039     0.150
    72.323   678.980     0.150
    72.323   678.801     0.150
    72.334   679.441     0.150
    72.348   679.141     0.150
    72.379   680.340     0.150
    72.385   679.340     0.150
    72.385   679.379     0.150
    72.420   679.801     0.150
    72.450   679.742     0.150
    72.640   681.941     0.150
    72.702   681.141     0.150
    72.702   681.141     0.150
    72.835   682.250     0.150
    72.838   680.879     0.150
    72.885   682.242     0.150
    72.902   683.039     0.150
    72.902    19.500     0.150
    72.902   683.141     0.150
    73.069   683.941     0.150
    73.069    14.598     0.150
    73.071   684.441     0.150
    73.131   682.941     0.150
    73.152   684.242     0.150
    73.152   684.242     0.150
    73.179   684.340     0.150
    73.179   701.941     0.150
    73.205   690.039     0.150
    73.277   685.141     0.150
    73.277    19.801     0.150
    73.477   688.641     0.150
    73.477    13.801     0.150
    73.477    19.398     0.150
    73.487   686.117     0.150
    73.500   686.199     0.150
    73.541   686.707     0.150
    73.598   687.285     0.150
    73.678   687.320     0.150
    73.678   687.316     0.150
    73.737   687.711     0.150
    73.737   687.711     0.150
    73.811   688.840     0.150
    73.814   688.430     0.150
    73.814   688.434     0.150
    73.956   689.047     0.150
    74.150   689.941     0.150
    74.150   689.941     0.150
    74.168   690.719     0.150
    74.168   690.719     0.150
    74.188   690.379     0.150
    74.300   690.941     0.150
    74.536    13.199     0.150
    74.536    18.297     0.150
    74.641   692.066     0.150
    74.693   692.941     0.150
    74.693   692.941     0.150
    74.716   692.996     0.150
    74.755   694.742     0.150
    74.755   694.742     0.150
    74.842   694.113     0.150
    74.850   693.762     0.150
    74.939   694.641     0.150
    75.057   695.340     0.150
    75.242   713.941     0.150
    75.385   698.090     0.150
    75.410   714.281     0.150
    75.422   697.742     0.150
    75.442   697.441     0.150
    75.568   715.391     0.150
    75.900   717.879     0.150
    76.189   701.441     0.150
    76.435   703.539     0.150
    76.474   703.539     0.150
    76.480    12.203     0.150
    76.483   703.742     0.150
    76.483   703.742     0.150
    76.526   704.039     0.150
    76.526   704.039     0.150
    76.552   704.039     0.150
    76.552   704.039     0.150
    76.690   704.340     0.150
    76.690   704.340     0.150
    77.252   707.219     0.150
    77.481   708.742     0.150
    77.721    16.402     0.150
    77.721   711.289     0.150
    77.721    16.473     0.150
    78.155    13.602     0.150
    78.155    16.301     0.150
    78.730   715.711     0.150
    78.854   716.941     0.150
    80.529   725.539     0.150
    80.686   726.742     0.150
    80.686   726.742     0.150
    80.753   726.340     0.150
    80.753   726.340     0.150
    80.771   727.039     0.150
    80.872   727.742     0.150
    80.872   727.742     0.150
    80.899   726.242     0.150
    81.000   727.641     0.150
    81.000   727.641     0.150
    81.041   728.641     0.150
    81.041   728.641     0.150
    81.041   728.641     0.150
    81.226   727.551     0.150
    81.453   730.840     0.150
    81.552   731.641     0.150
    81.729   731.641     0.150
    81.729   731.641     0.150
    81.729   731.641     0.150
    81.799   732.441     0.150
    81.799   732.441     0.150
    81.863   732.539     0.150
    81.895   733.340     0.150
    81.943   733.039     0.150
    81.943   733.039     0.150
    82.011   724.141     0.150
    82.029   733.840     0.150
    82.476   735.941     0.150
    82.799   736.840     0.150
    82.799   736.840     0.150
    83.387   745.141     0.150
    83.676   740.652     0.150
    83.676   746.781     0.150
    93.209   787.031     0.150
    93.209   800.020     0.150
    93.782    21.000     0.150
   105.510  1100.066     0.150
   105.510  1796.242     0.150
   114.449  1768.242     0.150
   122.396  1129.051     0.150
   134.534  1548.641     0.150
   146.571  1174.621     0.150
   150.138  1183.242     0.150
   150.138  1178.172     0.150
   150.138  1183.191     0.150
   150.138  1189.812     0.150
   160.768  1242.840     0.150
     1.128    19.483     0.150
     1.128    35.983     0.150
     2.391    68.718     0.150
     4.390    64.488     0.150
     4.446   118.578     0.150
     4.772    68.328     0.150
     5.026    72.008     0.150
     5.428    77.528     0.150
     5.758    82.378     0.150
     6.647    94.038     0.150
     7.737   214.258     0.150
     7.883   110.288     0.150
     8.160   114.008     0.150
     8.265   115.408     0.150
     8.265   203.798     0.150
    18.884   254.958     0.150
    20.385   272.003     0.150
    20.385   522.053     0.150
    20.385   733.753     0.150
    20.395   299.208     0.150
    24.109    19.580     0.150
    24.109   312.330     0.150
    25.610   327.024     0.150
    27.091   335.858     0.150
    27.091   335.858     0.150
    29.364   359.537     0.150
    30.049   364.408     0.150
    30.049   364.358     0.150
    30.312   368.958     0.150
    30.312    13.700     0.150
    31.709   380.059     0.150
    31.709    14.899     0.150
    31.709    20.100     0.150
    32.222   390.108     0.150
    32.341   385.857     0.150
    33.778   398.008     0.150
    33.796   399.338     0.150
    34.380   401.883     0.150
    34.380    13.250     0.150
    41.558   462.288     0.150
    43.111   474.748     0.150
    43.220   474.008     0.150
    43.677   479.759     0.150
    44.335   485.628     0.150
    44.931   491.059     0.150
    44.931    13.550     0.150
    45.712   494.508     0.150
    46.050   499.418     0.150
    48.026   512.809     0.150
    49.606   527.608     0.150
    53.135   549.809     0.150
    53.362   622.059     0.150
    53.362   552.133     0.150
    53.362   622.059     0.150
    55.667   569.748     0.150
    58.663   595.008     0.150
    58.987   592.608     0.150
    58.987   592.608     0.150
    59.923   599.108     0.150
    60.815   604.809     0.150
    61.368   609.008     0.150
    61.368   609.608     0.150
    61.488   609.684     0.150
    61.564   604.908     0.150
    63.430   758.108     0.150
    63.716   624.108     0.150
    63.976   626.208     0.150
    65.247    11.300     0.150
    65.247    15.899     0.150
    65.739   639.809     0.150
    65.948   638.708     0.150
    65.948   638.684     0.150
    66.113   650.908     0.150
    66.113     9.500     0.150
    66.113   664.908     0.150
    66.565   649.108     0.150
    67.198   647.738     0.150
    67.476   662.309     0.150
    67.599   650.208     0.150
    70.393   670.908     0.150
    71.169   672.408     0.150
    71.671   676.508     0.150
    72.058   678.708     0.150
    72.192   678.708     0.150
    72.200   678.979     0.150
    72.213   677.688     0.150
    72.213   677.684     0.150
    72.213   677.769     0.150
    72.220   677.678     0.150
    72.346   679.918     0.150
    72.984   683.708     0.150
    72.992   682.858     0.150
    73.305   685.408     0.150
    73.377   686.508     0.150
    73.670   688.184     0.150
    73.995   690.309     0.150
    74.008   690.309     0.150
    74.325   691.508     0.150
    74.530    13.699     0.150
    74.530  1301.908     0.150
    74.732   693.883     0.150
    75.068   696.238     0.150
    75.068   696.243     0.150
    75.223   697.786     0.150
    75.398   698.438     0.150
    75.398   698.437     0.150
    75.692   704.408     0.150
    75.923   701.253     0.150
    76.056   701.467     0.150
    76.146   701.809     0.150
    77.142   704.108     0.150
    77.297   708.309     0.150
    77.546   710.008     0.150
    77.713   712.809     0.150
    77.760   710.809     0.150
    80.169   724.883     0.150
    81.315   729.428     0.150
    82.989   739.108     0.150
    83.184   739.933     0.150
    86.230   757.083     0.150
   147.194  1175.277     0.150
   147.636  1182.889     0.150
   151.221  1186.283     0.150
     1.301    43.273     0.150
     1.301    23.070     0.150
     2.627    43.070     0.150
     4.009    66.469     0.150
     7.044   198.930     0.150
     8.512   259.195     0.150
     8.741   126.469     0.150
    10.751   154.484     0.150
    11.248   163.789     0.150
    14.861   207.844     0.150
    20.403   276.508     0.150
    27.704   347.164     0.150
    28.409   357.164     0.150
    28.409   357.164     0.150
    54.128   561.867     0.150
    56.493   579.992     0.150
    56.493   636.984     0.150
    59.876   603.141     0.150
    62.064   618.367     0.150
    62.256   619.344     0.150
    64.872   636.406     0.150
    66.833   648.844     0.150
    70.104   669.391     0.150
    72.998   686.719     0.150
    73.090   688.688     0.150
    74.363   695.977     0.150
    80.697   731.070     0.150
    83.914   747.664     0.150
     0.298    14.273     0.150
     7.679   105.297     0.150
     7.679   105.297     0.150
     7.679   186.875     0.150
    12.234   171.598     0.150
    13.761   190.797     0.150
    19.559   264.344     0.150
    19.652   261.727     0.150
    19.652   261.723     0.150
    23.387   304.824     0.150
    27.779   342.723     0.150
    27.779    16.324     0.150
    29.743   364.965     0.150
    30.999   375.648     0.150
    30.999    10.301     0.150
    44.196   482.887     0.150
    44.292   486.898     0.150
    44.292    11.426     0.150
    53.036   550.648     0.150
    56.091   573.758     0.150
    62.024   614.531     0.150
    62.024    11.848     0.150
    64.055   628.109     0.150
    83.754   743.547     0.150
     3.129    49.742     0.150
    64.792   623.840     0.150
     0.937    17.559     0.150
     0.937    30.734     0.150
     1.796    29.738     0.150
     1.809    30.238     0.150
     1.912    31.410     0.150
     1.965    32.570     0.150
     2.060    33.930     0.150
     6.887    97.047     0.150
     6.887   169.832     0.150
    12.175   299.359     0.150
    13.067   181.207     0.150
    19.222   259.004     0.150
    19.222   518.754     0.150
    19.554   261.109     0.150
    23.645   306.684     0.150
    25.568   325.500     0.150
    27.494   339.309     0.150
    31.276   375.109     0.150
    31.276   545.910     0.150
    33.317   393.551     0.150
    35.973   415.473     0.150
    41.402   460.840     0.150
    44.481   483.309     0.150
    44.688   487.008     0.150
    44.688   587.957     0.150
    52.136   540.684     0.150
    55.460   567.238     0.150
    55.460   627.199     0.150
    58.663    15.000     0.150
    58.663    21.500     0.150
    58.663   644.059     0.150
    60.066   598.082     0.150
    60.265   599.660     0.150
    63.203   619.270     0.150
    63.203   655.562     0.150
    65.398   633.613     0.150
    69.161   658.160     0.150
    70.129   664.559     0.150
    70.170   664.660     0.150
    70.411   670.059     0.150
    70.679   667.457     0.150
    70.902   668.758     0.150
    70.977   669.457     0.150
    71.015   668.559     0.150
    71.806   674.957     0.150
    72.058   676.160     0.150
    72.142   676.758     0.150
    72.366   678.582     0.150
    72.676   679.660     0.150
    72.810   680.660     0.150
    72.763   683.859     0.150
    72.828   680.758     0.150
    72.961   681.559     0.150
    73.203   682.758     0.150
    73.354   683.758     0.150
    73.416   683.957     0.150
    73.519   684.559     0.150
    73.762   686.660     0.150
    73.961    23.500     0.150
    74.592   691.160     0.150
    74.823   692.457     0.150
    74.922   694.059     0.150
    74.943   694.359     0.150
    75.288   695.359     0.150
    75.396   696.160     0.150
    75.703   698.559     0.150
    76.278   701.758     0.150
    76.345   701.859     0.150
    76.392   701.559     0.150
    76.638   702.957     0.150
    77.123   705.859     0.150
    78.127   711.258     0.150
    78.792   715.285     0.150
    83.274   738.410     0.150
    84.891   746.984     0.150
   122.060  1126.832     0.150
   149.983  1181.484     0.150
   161.605  1195.398     0.150
   161.605  1195.398     0.150
   161.605  1236.648     0.150
     0.782    29.888     0.150
     2.208    34.938     0.150
     2.209    63.788     0.150
     2.307    36.138     0.150
     2.324    36.168     0.150
     2.840    45.868     0.150
     2.866    45.598     0.150
     2.870    46.378     0.150
     3.144    46.738     0.150
     4.173    62.158     0.150
     4.418    65.107     0.150
     4.811    71.698     0.150
     4.993    72.998     0.150
     5.023    72.848     0.150
     5.291    75.208     0.150
     5.370    76.538     0.150
     5.370    76.508     0.150
     5.400    76.798     0.150
     5.377    78.078     0.150
     5.678    80.378     0.150
     5.641    81.528     0.150
     5.962    86.708     0.150
     6.155    88.568     0.150
     6.672    93.198     0.150
     6.980   100.438     0.150
     7.142   103.008     0.150
     7.387   106.308     0.150
     7.446   107.248     0.150
     7.414   105.548     0.150
     7.844   109.848     0.150
     7.884   110.138     0.150
     8.013   112.028     0.150
     8.396   117.118     0.150
     8.520   118.868     0.150
     8.564   119.397     0.150
     8.721   217.388     0.150
     8.721   123.438     0.150
     8.721   217.388     0.150
     9.422   130.818     0.150
     9.496   134.468     0.150
    10.044   139.178     0.150
    12.056   909.998     0.150
    14.649   205.248     0.150
    14.803   207.518     0.150
    19.982   269.598     0.150
    19.942   270.888     0.150
    19.942   270.883     0.150
    19.942   526.133     0.150
    19.942   741.433     0.150
    21.300   286.838     0.150
    21.579   289.568     0.150
    21.729   290.888     0.150
    21.871   292.888     0.150
    22.609   299.498     0.150
    22.954   303.897     0.150
    24.278   318.098     0.150
    25.225   326.318     0.150
    25.545   327.968     0.150
    25.867   331.938     0.150
    27.165   342.658     0.150
    27.672   344.638     0.150
    27.672   344.638     0.150
    27.566   347.418     0.150
    28.045   351.548     0.150
    28.116   351.448     0.150
    28.328   350.668     0.150
    28.328   350.663     0.150
    28.328   764.338     0.150
    28.206   351.388     0.150
    28.206   351.388     0.150
    28.249   353.088     0.150
    28.985   359.963     0.150
    28.985   548.158     0.150
    28.985   767.863     0.150
    29.448   364.438     0.150
    29.804   367.338     0.150
    30.084   369.454     0.150
    30.368   365.338     0.150
    30.368   448.838     0.150
    30.368   786.838     0.150
    30.476   372.659     0.150
    30.529   372.788     0.150
    30.529   771.838     0.150
    30.543   373.068     0.150
    30.543   551.518     0.150
    30.543   771.768     0.150
    30.537   372.038     0.150
    31.060   377.548     0.150
    31.060   377.545     0.150
    31.163   379.388     0.150
    31.224   379.538     0.150
    31.224   379.548     0.150
    31.261   379.341     0.150
    31.976   385.628     0.150
    32.171   387.918     0.150
    32.171   387.827     0.150
    32.275   388.226     0.150
    32.418   390.138     0.150
    32.543   384.978     0.150
    32.549   391.778     0.150
    32.692   392.607     0.150
    33.403   398.982     0.150
    33.549   399.448     0.150
    33.549   780.062     0.150
    33.693   400.888     0.150
    34.725   411.147     0.150
    34.778   410.871     0.150
    34.951   412.058     0.150
    35.208   414.884     0.150
    35.300   415.873     0.150
    35.754   419.094     0.150
    36.008   422.054     0.150
    36.920   429.744     0.150
    37.586   434.688     0.150
    37.836   546.538     0.150
    37.814   436.397     0.150
    39.732   460.138     0.150
    40.796   461.926     0.150
    41.632   464.863     0.150
    42.138   472.147     0.150
    42.672   609.938     0.150
    42.842   605.138     0.150
    42.842  1082.838     0.150
    43.485   482.168     0.150
    43.655   484.688     0.150
    43.655   484.688     0.150
    43.655   590.238     0.150
    43.655   819.613     0.150
    44.051   481.138     0.150
    43.919   485.688     0.150
    44.822   493.258     0.150
    45.150   495.808     0.150
    45.371   496.728     0.150
    45.371   496.725     0.150
    46.503   505.978     0.150
    47.168   511.618     0.150
    47.451  3568.231     0.150
    47.469  3561.157     0.150
    47.390   514.378     0.150
    48.216     3.000     0.150
    48.216     4.300     0.150
    48.216   517.258     0.150
    48.605  3652.863     0.150
    48.618  3657.122     0.150
    48.486   522.838     0.150
    48.486   522.838     0.150
    48.622  3660.780     0.150
    48.822  3677.655     0.150
    49.302   526.408     0.150
    49.302   526.413     0.150
    49.917   530.088     0.150
    50.458   537.008     0.150
    50.920     7.500     0.150
    54.225   563.468     0.150
    54.225   563.463     0.150
    54.225   560.368     0.150
    55.864   575.288     0.150
    55.864  1165.888     0.150
    56.734   581.368     0.150
    57.045   584.318     0.150
    57.045   584.318     0.150
    58.391   593.278     0.150
    60.017     4.500     0.150
    60.017     6.700     0.150
    60.317   606.618     0.150
    60.317   606.613     0.150
    60.840   611.038     0.150
    61.685   616.138     0.150
    62.074   619.038     0.150
    62.074   619.088     0.150
    62.074   619.088     0.150
    62.355   620.618     0.150
    62.355   620.613     0.150
    63.150     3.200     0.150
    63.300   627.348     0.150
    64.603   867.138     0.150
    65.034   637.388     0.150
    65.246   639.128     0.150
    65.246   639.125     0.150
    65.755   643.438     0.150
    65.967  4942.238     0.150
    66.403   648.738     0.150
    66.622     4.700     0.150
    66.622     7.000     0.150
    66.667     7.700     0.150
    67.293   652.508     0.150
    67.293   652.513     0.150
    67.293  2359.312     0.150
    67.476     3.500     0.150
    67.476     5.500     0.150
    67.774   662.838     0.150
    67.932    10.000     0.150
    67.932   923.838     0.150
    68.458   666.738     0.150
    68.458   659.338     0.150
    69.323   663.838     0.150
    69.758   667.838     0.150
    69.758   667.918     0.150
    70.239   671.938     0.150
    70.417   671.688     0.150
    71.375  5345.537     0.150
    71.620  5363.938     0.150
    71.743    11.000     0.150
    71.855   681.338     0.150
    71.865   688.638     0.150
    71.865   680.838     0.150
    71.865   688.638     0.150
    71.865   697.638     0.150
    71.865  1240.838     0.150
    71.865  1634.838     0.150
    71.865  1694.838     0.150
    72.043   683.038     0.150
    72.043   683.038     0.150
    72.090   683.238     0.150
    72.090   683.238     0.150
    72.379   692.578     0.150
    72.379  1537.838     0.150
    72.379   684.738     0.150
    72.379   692.538     0.150
    72.379   701.538     0.150
    72.379  1250.838     0.150
    72.413   685.238     0.150
    72.413   685.238     0.150
    72.531   685.438     0.150
    72.531   685.438     0.150
    72.593   685.938     0.150
    72.632   686.538     0.150
    72.632   686.538     0.150
    72.705   687.448     0.150
    72.758   686.738     0.150
    72.758   686.738     0.150
    72.774   687.538     0.150
    72.823   687.438     0.150
    72.823   687.438     0.150
    72.836   687.738     0.150
    72.836   687.738     0.150
    72.877   688.038     0.150
    72.954   687.998     0.150
    72.906   688.138     0.150
    73.119   688.798     0.150
    73.085   689.138     0.150
    73.085  1255.838     0.150
    73.118   688.062     0.150
    73.118   687.488     0.150
    73.324   691.058     0.150
    73.307   690.338     0.150
    73.307  1260.138     0.150
    73.391   690.738     0.150
    73.424   690.738     0.150
    73.526   691.138     0.150
    73.727   692.748     0.150
    73.686   692.838     0.150
    73.715   692.538     0.150
    73.794   688.838     0.150
    73.794   688.848     0.150
    73.738   692.357     0.150
    73.731   693.338     0.150
    73.858  5531.338     0.150
    73.891   694.738     0.150
    73.882  5533.338     0.150
    73.954  5538.438     0.150
    73.970   694.138     0.150
    73.970   694.147     0.150
    73.974   694.338     0.150
    74.084  5548.537     0.150
    74.072   694.738     0.150
    74.083   695.138     0.150
    74.083   695.138     0.150
    74.128   694.738     0.150
    74.141   695.238     0.150
    74.141   695.328     0.150
    74.141   695.331     0.150
    74.234   696.258     0.150
    74.221  5559.037     0.150
    74.291   696.738     0.150
    74.355   696.538     0.150
    74.355   696.538     0.150
    74.369   696.658     0.150
    74.369  2328.088     0.150
    74.369   696.663     0.150
    74.369  2328.088     0.150
    74.513   697.738     0.150
    74.610   697.938     0.150
    74.610   697.938     0.150
    74.675   698.538     0.150
    74.675   698.538     0.150
    74.708   698.538     0.150
    74.812   698.838     0.150
    74.854   699.538     0.150
    74.854   699.538     0.150
    75.093   700.638     0.150
    75.093   700.638     0.150
    75.237   701.538     0.150
    75.237   701.538     0.150
    75.312   701.838     0.150
    75.312   701.838     0.150
    75.393   702.438     0.150
    75.393   702.438     0.150
    75.684   704.638     0.150
    75.684   704.638     0.150
    75.726   704.368     0.150
    75.726   701.938     0.150
    75.726   705.238     0.150
    75.871     6.500     0.150
    76.227   706.938     0.150
    76.227   706.938     0.150
    76.442   708.638     0.150
    76.442   708.638     0.150
    76.690   709.938     0.150
    76.690   709.938     0.150
    76.828   708.838     0.150
    76.828  1292.838     0.150
    76.847   711.938     0.150
    76.847   711.938     0.150
    76.868   712.238     0.150
    76.868   712.238     0.150
    76.967   711.238     0.150
    77.187   712.938     0.150
    77.187   712.938     0.150
    77.294   714.278     0.150
    77.310   713.838     0.150
    77.310   713.838     0.150
    77.626   716.238     0.150
    77.626   716.238     0.150
    77.817   716.838     0.150
    77.829   716.838     0.150
    77.829   716.838     0.150
    78.101   717.438     0.150
    78.167   718.838     0.150
    78.167   718.838     0.150
    78.185   719.138     0.150
    78.212   717.938     0.150
    78.212   717.938     0.150
    78.254   718.738     0.150
    78.254   718.738     0.150
    78.217   720.528     0.150
    78.335   719.278     0.150
    78.335   719.282     0.150
    78.624   721.188     0.150
    78.567   720.438     0.150
    78.567   720.438     0.150
    78.751   721.538     0.150
    78.751   721.538     0.150
    78.953   722.838     0.150
    78.953   722.838     0.150
    79.254   723.988     0.150
    79.254   723.988     0.150
    79.372   724.008     0.150
    79.430   719.238     0.150
    79.430  1022.838     0.150
    79.530   729.938     0.150
    79.613  5962.537     0.150
    79.555   724.738     0.150
    79.711  1838.938     0.150
    80.070   728.638     0.150
    80.070   728.638     0.150
    80.545   731.913     0.150
    80.632   731.438     0.150
    80.734  6049.438     0.150
    81.731   733.718     0.150
    81.895   737.938     0.150
    82.173   738.668     0.150
    82.159   739.638     0.150
    82.451   741.138     0.150
    82.539   741.638     0.150
    82.637   740.378     0.150
    82.637   927.288     0.150
    82.724   742.038     0.150
    82.808   743.038     0.150
    82.808   743.038     0.150
    82.889   743.038     0.150
    82.946   743.338     0.150
    82.946   743.338     0.150
    82.945   743.638     0.150
    82.985   743.438     0.150
    83.040   744.138     0.150
    83.480   746.138     0.150
    83.523   745.638     0.150
    83.523   745.638     0.150
    83.853   748.638     0.150
    83.853   748.618     0.150
    83.959   748.938     0.150
    84.215   747.808     0.150
    84.517   751.038     0.150
    91.887   787.468     0.150
    91.887   787.463     0.150
    91.887   786.908     0.150
    92.206   788.268     0.150
    97.478   811.838     0.150
    98.846   816.438     0.150
   100.417   826.438     0.150
   107.343  1107.038     0.150
   107.343  1124.688     0.150
   107.343  1778.188     0.150
   109.050  8205.377     0.150
   109.061  8207.771     0.150
   109.067  8198.951     0.150
   124.191  1137.988     0.150
   124.191  1138.138     0.150
   148.480  1184.968     0.150
   152.050  1193.118     0.150
   160.254  1195.968     0.150
   160.254  1235.828     0.150
     1.322    24.465     0.150
     1.322    39.465     0.150
     2.139    34.273     0.150
     2.299    62.594     0.150
     2.407    37.684     0.150
     2.605    39.453     0.150
     2.946    47.703     0.150
     3.206    48.234     0.150
     4.229    63.355     0.150
     5.430    80.895     0.150
     6.007    88.344     0.150
     6.285    92.855     0.150
     6.994   101.977     0.150
     7.429   107.234     0.150
     7.506   107.703     0.150
     8.776   124.914     0.150
     8.776   124.914     0.150
     8.776   218.363     0.150
    12.254   175.441     0.150
    14.687   206.594     0.150
    19.937   272.215     0.150
    19.937   272.211     0.150
    24.199   317.867     0.150
    28.245   351.746     0.150
    28.245   351.738     0.150
    28.397   350.996     0.150
    28.397   350.988     0.150
    28.907   360.738     0.150
    30.466   373.805     0.150
    33.515   399.594     0.150
    33.515   399.590     0.150
    43.582   485.293     0.150
    43.582   485.289     0.150
    47.455  3567.324     0.150
    47.460  3572.652     0.150
    47.472  3575.945     0.150
    48.607  3659.789     0.150
    48.621  3654.434     0.150
    48.625  3660.723     0.150
    54.297   564.746     0.150
    54.297   564.742     0.150
    56.511   578.363     0.150
    57.132   585.906     0.150
    57.132   585.906     0.150
    60.408   608.039     0.150
    60.915   611.566     0.150
    62.138   620.465     0.150
    62.427   621.770     0.150
    65.332   640.406     0.150
    67.383   653.543     0.150
    67.383   653.590     0.150
    70.504   673.137     0.150
    70.504   673.141     0.150
    71.928   680.465     0.150
    71.928   680.465     0.150
    72.147   684.863     0.150
    72.147   684.863     0.150
    73.013   689.105     0.150
    73.192   689.141     0.150
    74.141   696.863     0.150
    74.141   696.863     0.150
    74.413   697.465     0.150
    74.413   697.465     0.150
    74.432   697.727     0.150
    74.432   697.727     0.150
    74.763   699.566     0.150
    74.909   701.266     0.150
    74.909   701.266     0.150
    75.148   701.465     0.150
    75.148   701.465     0.150
    75.740   706.266     0.150
    75.740   706.266     0.150
    82.246   740.664     0.150
    82.539   742.465     0.150
    82.627   742.965     0.150
    82.811   743.363     0.150
    82.896   743.965     0.150
    82.896   743.965     0.150
    82.978   744.066     0.150
    83.034   745.066     0.150
    83.034   744.664     0.150
    83.034   744.664     0.150
    83.073   744.664     0.150
    83.611   747.566     0.150
    84.036   749.449     0.150
    84.596   752.066     0.150
     2.906    42.516     0.150
     7.658   107.684     0.150
     7.658   187.816     0.150
    11.785   165.516     0.150
    11.785   291.090     0.150
    19.206   260.211     0.150
    27.244   338.590     0.150
    28.296   347.027     0.150
    53.177   554.227     0.150
    53.177   554.227     0.150
    56.576   577.367     0.150
    59.587   598.320     0.150
    61.307   612.355     0.150
    61.307   612.359     0.150
    66.597   644.316     0.150
     0.677    17.461     0.150
     1.058    19.203     0.150
     1.058    33.504     0.150
     1.140    22.031     0.150
     2.500    38.703     0.150
     3.019    46.684     0.150
     3.019    82.414     0.150
     3.818    55.973     0.150
     5.258    75.512     0.150
     5.533    79.691     0.150
     5.845    83.613     0.150
     6.877    96.344     0.150
     6.877   170.691     0.150
     6.877    96.344     0.150
     6.877   170.691     0.150
     6.877   702.793     0.150
     7.218    99.012     0.150
     9.866   135.820     0.150
    12.290   172.641     0.150
    12.290   300.441     0.150
    19.302   257.688     0.150
    19.302   515.539     0.150
    19.302   722.938     0.150
    19.302   982.336     0.150
    19.430   473.043     0.150
    22.026    16.453     0.150
    22.912   296.273     0.150
    23.491    20.102     0.150
    23.710    19.848     0.150
    23.782    21.039     0.150
    23.782    21.875     0.150
    23.782   304.762     0.150
    23.800    23.871     0.150
    25.251   310.684     0.150
    25.251    24.340     0.150
    26.014   323.793     0.150
    26.313   326.352     0.150
    26.584   329.094     0.150
    27.357   335.414     0.150
    27.357   533.320     0.150
    27.357   335.418     0.150
    27.357   533.316     0.150
    28.370   346.613     0.150
    29.255    16.309     0.150
    29.513   349.742     0.150
    30.008   359.891     0.150
    30.008    22.113     0.150
    30.385   365.344     0.150
    30.385    21.199     0.150
    30.385   541.016     0.150
    31.177   372.312     0.150
    31.177    21.121     0.150
    31.413   373.594     0.150
    31.413    21.648     0.150
    31.413   542.742     0.150
    32.281   381.703     0.150
    33.220   389.773     0.150
    33.320   390.320     0.150
    33.600   387.902     0.150
    33.600    26.070     0.150
    33.600   547.766     0.150
    33.624   393.082     0.150
    33.624    22.020     0.150
    33.624   393.000     0.150
    33.635   393.441     0.150
    33.635    21.270     0.150
    33.948   396.254     0.150
    33.948    21.566     0.150
    36.038   410.703     0.150
    36.270   413.141     0.150
    36.402   416.711     0.150
    36.402    22.242     0.150
    36.402   416.816     0.150
    37.216    16.230     0.150
    38.919   435.141     0.150
    38.919    25.500     0.150
    38.919   435.141     0.150
    38.919    25.512     0.150
    40.747   451.293     0.150
    41.349   456.414     0.150
    41.612   588.441     0.150
    41.722   459.641     0.150
    41.722   459.551     0.150
    42.427   485.543     0.150
    42.727   462.641     0.150
    42.727   485.242     0.150
    44.547   481.992     0.150
    44.547    22.727     0.150
    44.830   485.867     0.150
    44.830    23.074     0.150
    44.830   585.414     0.150
    45.823   492.945     0.150
    45.835   493.203     0.150
    45.835    22.430     0.150
    46.101   494.641     0.150
    46.874   501.980     0.150
    46.999    19.500     0.150
    46.999    28.801     0.150
    48.566   515.141     0.150
    48.566   513.719     0.150
    49.636    23.500     0.150
    50.085   525.016     0.150
    51.848   535.844     0.150
    52.024   539.742     0.150
    52.024    23.801     0.150
    52.069   607.922     0.150
    52.069   538.516     0.150
    52.069   607.918     0.150
    53.449   574.043     0.150
    53.449   583.742     0.150
    54.604   581.742     0.150
    55.317   564.184     0.150
    55.317    23.297     0.150
    55.317   623.684     0.150
    55.317   853.941     0.150
    57.967   603.941     0.150
    58.250   583.371     0.150
    58.250    24.500     0.150
    58.250   583.367     0.150
    58.250    24.500     0.150
    58.250   864.891     0.150
    58.519    22.699     0.150
    58.519    31.199     0.150
    58.658   585.242     0.150
    59.526   591.043     0.150
    60.017   595.766     0.150
    60.017    23.477     0.150
    60.140   597.398     0.150
    60.197   596.816     0.150
    60.197    23.000     0.150
    63.079   615.332     0.150
    64.929    20.301     0.150
    65.248   633.043     0.150
    65.265   630.172     0.150
    65.265    23.172     0.150
    65.265   630.168     0.150
    65.265    23.176     0.150
    65.265  2353.219     0.150
    65.914   636.242     0.150
    65.914    24.500     0.150
    65.914    36.500     0.150
    65.995    24.500     0.150
    65.995    35.500     0.150
    65.995   900.242     0.150
    65.995  1414.543     0.150
    67.620   645.043     0.150
    69.815   659.742     0.150
    69.815   659.742     0.150
    70.096   661.941     0.150
    70.096   661.941     0.150
    70.136   662.043     0.150
    70.136    24.500     0.150
    70.136   662.043     0.150
    70.136    24.500     0.150
    70.267    37.000     0.150
    70.321   663.141     0.150
    70.321   663.043     0.150
    70.579   664.844     0.150
    70.579   664.844     0.150
    70.654   664.844     0.150
    70.654   664.844     0.150
    70.710   665.742     0.150
    70.788   666.043     0.150
    70.788   666.043     0.150
    70.829   693.641     0.150
    70.829   666.242     0.150
    70.829    27.398     0.150
    70.854   666.141     0.150
    70.873   666.461     0.150
    70.877   666.141     0.150
    70.877   666.141     0.150
    70.942   665.422     0.150
    70.942   665.418     0.150
    70.942   665.230     0.150
    70.954   666.941     0.150
    70.954   666.941     0.150
    71.005   693.941     0.150
    71.005   667.344     0.150
    71.005    26.598     0.150
    71.003   667.344     0.150
    71.003   667.344     0.150
    71.041   667.383     0.150
    71.245   696.043     0.150
    71.245   668.641     0.150
    71.245    27.402     0.150
    71.293   669.504     0.150
    71.307   669.141     0.150
    71.314   668.141     0.150
    71.448   670.133     0.150
    71.620   670.742     0.150
    71.642   671.492     0.150
    71.648   670.742     0.150
    71.735   671.941     0.150
    71.771   672.344     0.150
    71.968   673.191     0.150
    71.995   673.281     0.150
    72.002   700.742     0.150
    72.002   673.141     0.150
    72.002    27.602     0.150
    72.024    27.098     0.150
    72.025   673.344     0.150
    72.025    24.898     0.150
    72.105   674.141     0.150
    72.105   674.141     0.150
    72.151   675.164     0.150
    72.169   674.543     0.150
    72.180   673.242     0.150
    72.284   674.844     0.150
    72.318   675.242     0.150
    72.391   675.742     0.150
    72.391    24.602     0.150
    72.391   675.742     0.150
    72.391    24.602     0.150
    72.600   677.242     0.150
    72.620    25.500     0.150
    72.620    37.301     0.150
    72.639   677.043     0.150
    72.639   677.043     0.150
    72.683   677.043     0.150
    72.691   677.242     0.150
    72.779   677.941     0.150
    72.779    24.699     0.150
    72.805   678.242     0.150
    72.805    24.602     0.150
    72.805   678.242     0.150
    72.805    24.602     0.150
    72.930   678.941     0.150
    72.930    24.699     0.150
    72.930   678.941     0.150
    72.930    24.699     0.150
    72.986   690.941     0.150
    72.986   704.543     0.150
    73.076   679.141     0.150
    73.173   680.043     0.150
    73.173   680.043     0.150
    73.325   681.141     0.150
    73.325    24.602     0.150
    73.325   681.141     0.150
    73.325    24.602     0.150
    73.386   681.344     0.150
    73.386   681.344     0.150
    73.491   682.043     0.150
    73.491   682.043     0.150
    73.617   682.883     0.150
    73.727   683.941     0.150
    73.727    24.801     0.150
    73.727   683.941     0.150
    73.727    24.801     0.150
    74.340   686.844     0.150
    74.340   686.844     0.150
    74.568   688.742     0.150
    74.568    24.500     0.150
    74.568   688.742     0.150
    74.568    24.500     0.150
    74.796   689.844     0.150
    74.796   689.844     0.150
    74.823   689.801     0.150
    74.887   691.441     0.150
    74.887   691.441     0.150
    74.908   691.742     0.150
    74.908   691.742     0.150
    75.257   692.742     0.150
    75.257    24.699     0.150
    75.257   692.742     0.150
    75.257    24.699     0.150
    75.336   691.641     0.150
    75.336   691.602     0.150
    75.363   693.441     0.150
    75.363   693.441     0.150
    75.626    32.500     0.150
    75.668   695.941     0.150
    75.668   695.941     0.150
    75.901   696.641     0.150
    76.246   699.043     0.150
    76.246    24.898     0.150
    76.324   699.441     0.150
    76.324   699.441     0.150
    76.354   698.242     0.150
    76.354   698.242     0.150
    76.366   698.941     0.150
    76.366   698.941     0.150
    76.603   700.242     0.150
    76.603   700.242     0.150
    76.906   702.754     0.150
    77.003   702.641     0.150
    77.003   702.641     0.150
    77.029   702.242     0.150
    77.029   702.242     0.150
    78.090   708.543     0.150
    78.090   708.543     0.150
    78.780   712.543     0.150
    78.952   712.742     0.150
    80.196   713.742     0.150
    80.548   720.402     0.150
    81.758   728.191     0.150
    82.823   732.551     0.150
    83.130   734.641     0.150
    84.855   744.316     0.150
    88.444   763.094     0.150
    92.512   780.359     0.150
    92.689   781.066     0.150
    97.927   803.891     0.150
    97.927  1077.469     0.150
   101.330   819.742     0.150
   101.330  1082.992     0.150
   105.624  1792.094     0.150
   105.624  1090.555     0.150
   105.624  1773.918     0.150
   105.624  1792.094     0.150
   120.416  1117.820     0.150
   120.416  1117.816     0.150
   121.966  1123.219     0.150
   149.919  1178.516     0.150
   149.919  1203.816     0.150
   162.398  1236.055     0.150
     5.998    87.320     0.150
     8.257   119.422     0.150
    70.961   665.637     0.150
     1.565    49.906     0.150
     1.891    31.930     0.150
     3.952    59.195     0.150
     4.276    64.836     0.150
     4.580   114.680     0.150
     4.959    72.594     0.150
     5.162    74.859     0.150
     5.162   131.586     0.150
     5.822    84.742     0.150
     5.940    95.133     0.150
     6.870    99.266     0.150
     7.162   102.711     0.150
     7.162   183.375     0.150
     7.210   102.859     0.150
     7.255   104.305     0.150
     7.493   116.820     0.150
     8.473   120.516     0.150
     8.473   211.109     0.150
     9.152   140.055     0.150
    14.364   199.312     0.150
    14.531   203.766     0.150
    19.443   264.711     0.150
    20.146   534.211     0.150
    21.335   287.469     0.150
    21.907   293.430     0.150
    23.062   305.055     0.150
    23.514   309.469     0.150
    23.514   309.383     0.150
    24.927   324.234     0.150
    25.879   332.234     0.150
    26.493   337.766     0.150
    27.001   337.766     0.150
    27.681   346.797     0.150
    28.077   349.070     0.150
    31.102   385.742     0.150
    33.155   396.742     0.150
    33.219   397.062     0.150
    34.137   404.227     0.150
    38.423   441.172     0.150
    38.844   444.656     0.150
    40.443   457.781     0.150
    40.707   467.484     0.150
    42.125   479.312     0.150
    43.297   494.211     0.150
    43.297   480.250     0.150
    43.405   475.812     0.150
    43.519   493.609     0.150
    43.848   490.812     0.150
    43.844   491.773     0.150
    44.081   487.156     0.150
    44.276   600.359     0.150
    45.420   498.031     0.150
    45.623   506.039     0.150
    45.689   506.211     0.150
    45.689   499.492     0.150
    45.689   506.211     0.150
    47.661   522.312     0.150
    47.661   522.281     0.150
    47.969   525.812     0.150
    47.969   525.766     0.150
    48.742   521.766     0.150
    51.935   554.656     0.150
    53.581   558.016     0.150
    53.639   558.812     0.150
    55.751   632.609     0.150
    59.357     7.000     0.150
    59.357     9.500     0.150
    59.668   601.773     0.150
    60.391   607.109     0.150
    61.258   612.711     0.150
    64.391   632.945     0.150
    65.952    11.305     0.150
    66.812     7.398     0.150
    66.812    10.500     0.150
    67.265     6.203     0.150
    67.265     9.000     0.150
    67.977   664.812     0.150
    69.350   664.930     0.150
    71.085   677.109     0.150
    71.085     7.000     0.150
    71.085    10.102     0.150
    71.523   682.914     0.150
    71.523   679.016     0.150
    71.523   682.914     0.150
    71.523   693.812     0.150
    71.764   680.312     0.150
    71.764   680.312     0.150
    71.807   680.414     0.150
    71.807   680.414     0.150
    71.850  5359.609     0.150
    72.031   681.812     0.150
    72.194   682.914     0.150
    72.194   682.914     0.150
    72.274   683.914     0.150
    72.308   683.812     0.150
    72.290   683.016     0.150
    72.290   683.016     0.150
    72.408   684.016     0.150
    72.408   684.016     0.150
    72.472   684.914     0.150
    72.515   684.016     0.150
    72.515   684.016     0.150
    72.546   689.414     0.150
    72.546   697.711     0.150
    72.546   684.609     0.150
    72.546    13.102     0.150
    72.586   685.109     0.150
    72.586   685.109     0.150
    72.617   685.211     0.150
    72.617   685.211     0.150
    72.675   684.031     0.150
    72.723   686.219     0.150
    72.879   687.414     0.150
    72.957   692.109     0.150
    72.957   687.312     0.150
    72.957     4.797     0.150
    73.026   692.109     0.150
    73.026   688.016     0.150
    73.026   701.914     0.150
    73.081   688.711     0.150
    73.144   689.711     0.150
    73.342   689.914     0.150
    73.342   704.211     0.150
    73.660   691.422     0.150
    73.693   691.609     0.150
    73.717   691.914     0.150
    73.717   706.414     0.150
    73.732   692.516     0.150
    73.732     4.297     0.150
    73.732   692.500     0.150
    73.786   692.312     0.150
    73.786   692.312     0.150
    74.026   694.219     0.150
    74.066   693.812     0.150
    74.066   693.812     0.150
    74.253   695.109     0.150
    74.317   695.016     0.150
    74.317   695.016     0.150
    74.439   696.016     0.150
    74.439   696.016     0.150
    74.437   696.109     0.150
    74.437   696.109     0.150
    74.588   696.914     0.150
    74.588   696.914     0.150
    74.829   698.109     0.150
    74.829   698.109     0.150
    74.977   698.914     0.150
    74.977   698.914     0.150
    75.045   699.211     0.150
    75.045   699.211     0.150
    75.139   699.914     0.150
    75.139   699.914     0.150
    75.342   702.305     0.150
    75.399   702.016     0.150
    75.399   702.016     0.150
    75.749   701.328     0.150
    75.981   705.516     0.150
    75.981   705.516     0.150
    76.202   706.312     0.150
    76.202   706.312     0.150
    76.440   707.414     0.150
    76.440   707.414     0.150
    76.561   708.312     0.150
    76.561   708.312     0.150
    76.581   708.711     0.150
    76.581   708.711     0.150
    76.917   710.312     0.150
    76.917   710.312     0.150
    77.031   711.109     0.150
    77.031   711.109     0.150
    77.341   713.609     0.150
    77.341   713.609     0.150
    77.953   716.891     0.150
    77.911   716.016     0.150
    77.944   716.609     0.150
    77.944   716.609     0.150
    77.981   715.609     0.150
    77.981   715.609     0.150
    78.007   716.516     0.150
    78.007   716.516     0.150
    78.278   717.914     0.150
    78.278   717.914     0.150
    78.469   719.016     0.150
    78.469   719.016     0.150
    78.529   719.641     0.150
    79.772   726.016     0.150
    79.772   726.016     0.150
    81.294  6073.414     0.150
    81.487   735.414     0.150
    81.779   737.312     0.150
    81.867   737.812     0.150
    81.992   736.883     0.150
    82.052   738.312     0.150
    82.136   739.016     0.150
    82.136   739.016     0.150
    82.218   739.016     0.150
    82.274   739.914     0.150
    82.274   739.414     0.150
    82.274   739.414     0.150
    82.313   739.711     0.150
    82.368   740.211     0.150
    82.851   742.414     0.150
    83.565   745.023     0.150
     0.515    20.664     0.150
    11.667   289.184     0.150
    26.767   336.465     0.150
    26.838   338.379     0.150
    55.408   562.384     0.150
     1.687    27.980     0.150
     1.687    48.781     0.150
    20.812   273.480     0.150
    25.665   318.680     0.150
    26.264   329.980     0.150
    26.441   326.078     0.150
    28.084   341.379     0.150
    34.933   402.781     0.150
    39.720   442.078     0.150
    43.165   470.379     0.150
    47.518   504.391     0.150
    47.518   504.379     0.150
    51.315   533.578     0.150
    52.345   540.379     0.150
    53.152   545.980     0.150
    55.042   561.180     0.150
    55.042   621.379     0.150
    56.383   572.680     0.150
    58.015    27.000     0.150
    58.448   585.180     0.150
    58.448   634.379     0.150
    61.244   603.480     0.150
    61.274   603.180     0.150
    65.469   632.980     0.150
    65.469    24.199     0.150
    65.469    35.000     0.150
    65.980    24.500     0.150
    65.980    35.500     0.150
    69.743   657.180     0.150
    69.743    25.301     0.150
    69.743    36.500     0.150
    69.743   811.980     0.150
    70.992   664.840     0.150
    71.048   666.680     0.150
    71.544   669.781     0.150
    71.974   676.180     0.150
    72.030   672.879     0.150
    72.045   671.539     0.150
    72.077   673.578     0.150
    72.202   674.180     0.150
    72.499   675.879     0.150
    73.255   680.578     0.150
    73.307   681.281     0.150
    73.548   681.980     0.150
    73.808   682.980     0.150
    74.164   685.781     0.150
    74.224   685.680     0.150
    74.353   687.180     0.150
    75.039   695.180     0.150
    77.834   706.281     0.150
    82.530   731.078     0.150
    82.709   732.680     0.150
    91.143   774.379     0.150
    99.831   812.578     0.150
   151.006  1180.781     0.150
     0.292    13.102     0.150
    12.326   169.422     0.150
    19.544   261.277     0.150
    75.060   696.316     0.150
     0.922    25.090     0.150
     0.922    25.090     0.150
     0.922    26.809     0.150
     2.525    68.379     0.150
     2.575    40.469     0.150
     2.693    42.059     0.150
     2.693    71.740     0.150
     2.795    44.219     0.150
     2.837    43.570     0.150
     2.837    73.650     0.150
     3.569    93.219     0.150
     3.729    63.559     0.150
     6.469    98.439     0.150
     7.055   103.559     0.150
     7.311   109.639     0.150
     8.176   200.414     0.150
    10.318   151.180     0.150
    22.099   298.160     0.150
    22.312   301.289     0.150
    22.553   303.814     0.150
    22.553   303.439     0.150
    22.553   303.820     0.150
    23.968   318.779     0.150
    24.064   318.549     0.150
    24.401   322.500     0.150
    24.696   323.879     0.150
    25.008   329.000     0.150
    25.139   330.760     0.150
    25.122   332.830     0.150
    25.581   333.619     0.150
    26.712   341.316     0.150
    28.754   363.115     0.150
    30.548   373.172     0.150
    30.748   374.375     0.150
    30.900   376.256     0.150
    31.097   377.332     0.150
    31.394   385.025     0.150
    31.799   389.229     0.150
    32.166   387.512     0.150
    32.221   393.369     0.150
    32.922   392.789     0.150
    34.127   407.199     0.150
    34.749   408.930     0.150
    36.416   425.580     0.150
    36.565   428.039     0.150
    37.022   429.121     0.150
    37.102   431.371     0.150
    37.284   433.594     0.150
    37.284   435.699     0.150
    37.676   438.000     0.150
    37.946   439.875     0.150
    38.321   442.977     0.150
    38.308   442.736     0.150
    38.930   447.705     0.150
    39.510   449.973     0.150
    39.738   455.139     0.150
    39.759   454.379     0.150
    41.381   465.410     0.150
    41.606   469.828     0.150
    41.946   469.930     0.150
    42.498   478.359     0.150
    43.256   480.121     0.150
    43.356   486.939     0.150
    43.356   592.934     0.150
    43.890   487.686     0.150
    44.477   495.309     0.150
    44.732   494.215     0.150
    45.206   496.076     0.150
    47.027   512.990     0.150
    57.135   587.740     0.150
    64.332   634.949     0.150
    64.271   639.258     0.150
    65.058   641.279     0.150
    67.223   653.689     0.150
    67.223     1.600     0.150
    67.223     8.180     0.150
    71.776  5343.039     0.150
    72.898   689.639     0.150
    83.559   749.240     0.150
     5.423    79.494     0.150
     8.151   113.615     0.150
     5.834    82.141     0.150
     8.644   120.418     0.150
     1.144    21.000     0.150
     1.873    30.141     0.150
     3.051    46.461     0.150
     1.323    23.838     0.150
     1.323    39.988     0.150
     2.324    39.258     0.150
     2.331    37.397     0.150
     2.344    39.178     0.150
     2.400    39.808     0.150
     2.531    42.107     0.150
     8.797   122.638     0.150
    12.323   178.488     0.150
    25.862   328.888     0.150
     0.540    11.006     0.150
     1.244    20.115     0.150
     1.660    28.895     0.150
     1.767    30.666     0.150
     1.830    30.615     0.150
     2.621    41.605     0.150
     3.372    49.805     0.150
     3.958    59.105     0.150
     4.190    63.805     0.150
     4.190    63.805     0.150
     4.577    66.205     0.150
     4.965    72.105     0.150
     5.271    75.805     0.150
     5.477    78.904     0.150
     6.256    89.006     0.150
     6.543    93.705     0.150
     6.675    95.006     0.150
     6.703    96.105     0.150
    20.620   287.904     0.150
    27.509   343.895     0.150
    27.509   343.904     0.150
    28.895   356.705     0.150
    29.669   364.006     0.150
    30.472   368.904     0.150
    32.906   393.105     0.150
    33.103   394.404     0.150
    33.233   394.375     0.150
    33.233   394.404     0.150
    33.313   396.305     0.150
    34.642   407.205     0.150
    36.631   423.705     0.150
    41.584   463.010     0.150
    42.702   473.705     0.150
    42.889   472.605     0.150
    43.307   480.506     0.150
    43.307   480.506     0.150
    44.277   484.760     0.150
    45.556   496.404     0.150
    48.684   518.205     0.150
    50.047    18.000     0.150
    53.485   554.805     0.150
    59.145   594.705     0.150
    61.431   606.006     0.150
    62.345   619.305     0.150
    63.420   622.605     0.150
    63.856   626.305     0.150
    64.467   630.205     0.150
    65.579    12.199     0.150
    65.579    17.000     0.150
    66.132   641.205     0.150
    66.132   641.006     0.150
    66.224   641.605     0.150
    66.486    10.900     0.150
    66.486    17.400     0.150
    69.677   670.305     0.150
    70.883   673.205     0.150
    70.883   673.205     0.150
    71.781   678.006     0.150
    71.781   689.705     0.150
    72.028   678.105     0.150
    72.079   679.605     0.150
    72.079   691.805     0.150
    72.316   681.705     0.150
    72.316   693.205     0.150
    73.092   686.006     0.150
    73.092    12.398     0.150
    73.251   687.305     0.150
    73.447   688.205     0.150
    73.772   690.305     0.150
    74.706     5.398     0.150
    74.706   704.605     0.150
    77.546   715.805     0.150
     0.741    24.547     0.150
     6.576    86.305     0.150
     1.057    18.543     0.150
     1.057    33.723     0.150
     1.057    18.875     0.150
     1.161    23.805     0.150
     1.278    25.266     0.150
     1.382    26.562     0.150
     1.448    27.703     0.150
     4.127    59.676     0.150
     4.232    61.773     0.150
     4.901    65.375     0.150
     5.695    81.074     0.150
     5.964    84.973     0.150
     6.311    89.574     0.150
     8.640   132.246     0.150
    11.884   170.586     0.150
    21.171    15.832     0.150
    22.641    17.430     0.150
    23.762    19.797     0.150
    23.904    14.770     0.150
    23.908    19.879     0.150
    24.039    20.152     0.150
    24.063   308.023     0.150
    24.063   525.176     0.150
    25.075    20.293     0.150
    25.542    20.441     0.150
    25.865   325.344     0.150
    25.865    21.711     0.150
    25.872    20.711     0.150
    29.632    13.762     0.150
    31.688    19.000     0.150
    32.442   754.535     0.150
    33.383   386.586     0.150
    33.529   392.383     0.150
    34.851   403.035     0.150
    34.911    23.336     0.150
    35.979   410.273     0.150
    36.053   408.574     0.150
    37.684   426.914     0.150
    38.797   436.535     0.150
    39.682    19.352     0.150
    39.792   444.883     0.150
    41.116    14.688     0.150
    41.393    19.199     0.150
    41.393   581.973     0.150
    41.393  1043.473     0.150
    41.646   460.414     0.150
    41.796   461.426     0.150
    42.157   462.574     0.150
    42.242   462.074     0.150
    42.887   469.273     0.150
    44.467   482.684     0.150
    46.089   495.773     0.150
    48.252   510.875     0.150
    52.396   609.801     0.150
    53.406   616.176     0.150
    54.931   560.473     0.150
    58.312    21.152     0.150
    58.369   590.676     0.150
    58.369    16.000     0.150
    58.369    23.797     0.150
    58.369  1069.973     0.150
    58.369  1093.574     0.150
    60.388   598.875     0.150
    61.082   646.074     0.150
    61.774   613.676     0.150
    63.018   653.574     0.150
    63.018   754.273     0.150
    64.838    18.000     0.150
    64.838   654.473     0.150
    65.783    16.199     0.150
    65.783   656.875     0.150
    69.961   663.934     0.150
    70.112   677.375     0.150
    70.112   815.773     0.150
    70.188   662.574     0.150
    70.691   691.754     0.150
    70.691   665.773     0.150
    70.691   691.773     0.150
    70.917   662.312     0.150
    71.079    26.898     0.150
    71.079   667.875     0.150
    71.079   694.773     0.150
    71.193    26.402     0.150
    71.193   668.773     0.150
    71.193   695.176     0.150
    71.212    26.602     0.150
    71.212   668.973     0.150
    71.212   695.574     0.150
    71.368    26.000     0.150
    71.368   669.973     0.150
    71.368   695.973     0.150
    71.517   670.133     0.150
    71.517   670.293     0.150
    71.517   670.074     0.150
    71.614   671.176     0.150
    71.705   671.676     0.150
    72.007   672.875     0.150
    72.396    26.699     0.150
    72.396    26.449     0.150
    72.396   676.074     0.150
    72.396   702.773     0.150
    72.422   676.074     0.150
    72.514   676.973     0.150
    72.690    26.492     0.150
    72.720   678.473     0.150
    73.024   680.473     0.150
    73.349   681.473     0.150
    73.878    20.500     0.150
    73.878    29.898     0.150
    74.381   686.875     0.150
    75.175   692.176     0.150
    75.453   698.875     0.150
    75.735    26.137     0.150
    75.735   696.676     0.150
    76.324   698.375     0.150
    77.056   706.875     0.150
    79.212    21.301     0.150
    80.623   721.375     0.150
    82.065   724.996     0.150
    82.433   731.375     0.150
    97.481   801.574     0.150
   106.062  1790.273     0.150
     0.376    23.214     0.150
     1.007    16.157     0.150
    11.869   294.067     0.150
    24.696   321.077     0.150
    29.289   357.827     0.150
    29.850   362.617     0.150
     0.422    10.824     0.150
     2.700    41.775     0.150
     2.711    74.775     0.150
     3.951    59.004     0.150
     0.749    14.070     0.150
     0.749    24.422     0.150
     1.249    38.723     0.150
     1.714    28.109     0.150
     1.852    52.902     0.150
     2.325    35.359     0.150
     2.967    45.352     0.150
     2.939    45.012     0.150
     3.528    51.492     0.150
     3.880    57.082     0.150
     4.136    60.680     0.150
     5.145    74.070     0.150
     5.152    73.070     0.150
     5.299    76.602     0.150
     5.566    80.082     0.150
     5.606    80.949     0.150
     6.837    97.121     0.150
     6.873    94.238     0.150
    20.866   273.152     0.150
    20.866   288.949     0.150
    28.180   349.090     0.150
    32.624   388.551     0.150
    39.866   447.820     0.150
    41.646   464.949     0.150
    41.858   466.910     0.150
    41.968   477.152     0.150
    42.755   603.449     0.150
    42.755  1082.250     0.150
    43.581   478.551     0.150
    54.339   561.801     0.150
    63.928   626.961     0.150
    66.033    10.301     0.150
    66.033    14.402     0.150
    66.242   642.250     0.150
    67.022    16.402     0.150
    67.022   670.750     0.150
    70.551   681.609     0.150
    71.265   675.750     0.150
    71.265   687.449     0.150
    71.368   674.191     0.150
    72.244   681.652     0.150
    72.244   692.949     0.150
    72.321   681.551     0.150
    73.284   686.750     0.150
    74.795    15.301     0.150
    78.436    16.699     0.150
    84.973   750.859     0.150
     5.450    76.812     0.150
     1.666    27.739     0.150
     1.666    49.459     0.150
     1.819    29.709     0.150
     5.755    80.759     0.150
     7.281   102.869     0.150
    19.431    12.400     0.150
    22.307   296.749     0.150
    22.307    11.730     0.150
    23.330    13.450     0.150
    23.456    13.330     0.150
    23.498    13.550     0.150
    23.498    12.370     0.150
    24.983    13.120     0.150
    25.314    13.790     0.150
    25.384    13.950     0.150
    25.612     9.410     0.150
    25.649    15.600     0.150
    26.076    15.880     0.150
    27.539   343.129     0.150
    28.096    17.050     0.150
    28.891    15.730     0.150
    29.422   359.969     0.150
    29.422    15.620     0.150
    29.457    15.620     0.150
    33.051    15.500     0.150
    33.176    10.240     0.150
    33.700   397.379     0.150
    34.737    10.130     0.150
    36.174   418.012     0.150
    36.479   420.339     0.150
    36.567   419.709     0.150
    38.504    15.700     0.150
    39.909   447.379     0.150
    42.203   467.679     0.150
    42.390   467.779     0.150
    42.824   472.979     0.150
    43.384   477.819     0.150
    43.406   477.629     0.150
    43.551   477.207     0.150
    44.695   488.229     0.150
    47.088   507.113     0.150
    48.743   519.418     0.150
    50.222   531.969     0.150
    50.638   534.489     0.150
    50.766   535.739     0.150
    51.634   541.469     0.150
    58.853    17.800     0.150
    58.853    17.375     0.150
    62.360   619.979     0.150
    66.751   644.579     0.150
    68.222   653.579     0.150
    68.734   657.679     0.150
    70.389   666.779     0.150
    70.389   669.679     0.150
    70.389    14.100     0.150
    70.897   686.799     0.150
    70.897   671.079     0.150
    70.897   686.779     0.150
    71.096   672.179     0.150
    71.288   673.879     0.150
    71.288   688.579     0.150
    71.406   674.579     0.150
    71.411   674.579     0.150
    71.565   673.619     0.150
    71.588   675.779     0.150
    71.733   676.479     0.150
    71.823   677.079     0.150
    71.823   690.479     0.150
    71.892   677.379     0.150
    71.907   676.979     0.150
    72.208   679.179     0.150
    72.582   681.279     0.150
    72.598   681.879     0.150
    72.598   687.779     0.150
    72.598   703.179     0.150
    72.598   681.789     0.150
    72.596   681.479     0.150
    72.729   681.679     0.150
    72.766   683.179     0.150
    72.960   684.379     0.150
    73.288   685.479     0.150
    73.585   686.979     0.150
    73.671   687.679     0.150
    74.426    10.100     0.150
    74.658   693.179     0.150
    75.436   695.579     0.150
    75.436   695.579     0.150
    76.415   703.679     0.150
    76.430   703.579     0.150
    76.576   703.979     0.150
    76.789   705.779     0.150
    76.835   705.379     0.150
    76.835   704.679     0.150
    76.835   704.679     0.150
    77.081   707.079     0.150
    77.097   706.979     0.150
    77.690   710.579     0.150
    79.645   721.079     0.150
    79.645   721.029     0.150
    80.578   726.879     0.150
    81.490   730.679     0.150
    81.651   731.579     0.150
    82.231   734.779     0.150
    82.665   737.689     0.150
     3.381    49.914     0.150
     4.306    62.473     0.150
     4.578    65.652     0.150
     4.975    75.613     0.150
     4.975    75.613     0.150
     5.345    77.812     0.150
     5.295    76.184     0.150
     6.228    89.414     0.150
     6.509    93.902     0.150
     6.724    96.113     0.150
     6.768    96.902     0.150
     7.269   100.434     0.150
     7.748   108.883     0.150
     7.842   189.066     0.150
    14.351   199.754     0.150
    22.272   295.242     0.150
    23.780   309.473     0.150
    25.882   328.754     0.150
    26.429   329.715     0.150
    26.362   332.934     0.150
    26.372   334.234     0.150
    26.903   338.926     0.150
    27.391   338.414     0.150
    27.671   345.004     0.150
    30.393   370.004     0.150
    31.506   379.254     0.150
    31.525   379.133     0.150
    32.146   385.395     0.150
    32.220   385.605     0.150
    32.267   386.586     0.150
    33.109   393.535     0.150
    33.310   395.383     0.150
    33.419   395.414     0.150
    33.419   395.426     0.150
    33.514   397.145     0.150
    33.590   398.133     0.150
    33.925   401.074     0.150
    34.849   408.402     0.150
    34.849    12.453     0.150
    35.588   412.312     0.150
    35.588   412.355     0.150
    36.090   419.086     0.150
    37.961   434.824     0.150
    38.672   441.023     0.150
    38.672    13.969     0.150
    38.787   441.215     0.150
    39.435   446.773     0.150
    39.662   446.758     0.150
    40.001   452.184     0.150
    41.618   462.984     0.150
    41.787    16.102     0.150
    42.067   465.742     0.150
    42.685   471.312     0.150
    42.838   470.715     0.150
    44.543   485.883     0.150
    45.035   490.465     0.150
    45.568   494.004     0.150
    45.755   497.203     0.150
    45.910   497.715     0.150
    45.910   497.754     0.150
    47.066   505.695     0.150
    47.408   509.621     0.150
    48.171   515.266     0.150
    48.265   517.684     0.150
    53.285   552.133     0.150
    55.782   570.215     0.150
    55.782   629.914     0.150
    58.846   596.516     0.150
    63.267    10.098     0.150
    65.373     7.898     0.150
    65.373    11.000     0.150
    65.531    11.699     0.150
    66.602     8.203     0.150
    66.602    11.402     0.150
    70.583   670.812     0.150
    70.814   671.016     0.150
    71.319   673.812     0.150
    71.709   676.812     0.150
    71.827   676.812     0.150
    71.862   680.516     0.150
    72.003   678.715     0.150
    72.003   700.812     0.150
    72.244   679.613     0.150
    72.988   683.812     0.150
    73.022   684.613     0.150
    73.130   685.414     0.150
    73.164   685.516     0.150
    73.364   687.312     0.150
    73.992   690.312     0.150
    74.517   703.016     0.150
    74.517    11.402     0.150
    74.517    14.500     0.150
    75.783   702.613     0.150
    75.901   705.914     0.150
    76.633   701.613     0.150
    82.725   737.914     0.150
     1.662    27.715     0.150
     9.209   231.174     0.150
     3.794    55.477     0.150
     4.363    64.344     0.150
     4.992    71.070     0.150
     5.388    77.500     0.150
     5.706    81.883     0.150
     6.639    94.961     0.150
     6.919    99.156     0.150
     7.135   101.328     0.150
     8.158   114.352     0.150
    14.401   202.219     0.150
    20.556   285.500     0.150
    23.932   311.219     0.150
    27.928   345.344     0.150
    28.394   351.273     0.150
    30.501   370.711     0.150
    30.933   372.602     0.150
    31.530   379.172     0.150
    31.561   380.117     0.150
    32.166   386.180     0.150
    33.192   395.297     0.150
    33.192    12.281     0.150
    33.329   397.047     0.150
    33.329   395.680     0.150
    33.329    11.742     0.150
    33.605   397.398     0.150
    33.605   397.359     0.150
    33.614   398.781     0.150
    34.227   401.422     0.150
    36.109   419.398     0.150
    36.109   419.438     0.150
    38.885   442.500     0.150
    38.950   441.891     0.150
    43.239   475.102     0.150
    44.753   488.172     0.150
    45.785   497.695     0.150
    45.870   498.758     0.150
    46.086   499.594     0.150
    48.017   514.398     0.150
    48.017   514.422     0.150
    53.180   551.953     0.150
    53.422   622.680     0.150
    58.843   598.500     0.150
    59.137   593.852     0.150
    61.404   610.203     0.150
    64.114   627.500     0.150
    65.422     8.000     0.150
    65.422    11.000     0.150
    66.103   640.367     0.150
    66.103   640.367     0.150
    66.197   640.969     0.150
    66.292   648.000     0.150
    66.292     7.000     0.150
    66.292    10.297     0.150
    66.728   652.000     0.150
    67.556   672.203     0.150
    72.096   680.500     0.150
    72.225   681.398     0.150
    72.225   681.398     0.150
    72.281   679.000     0.150
    72.349   680.539     0.150
    72.388   702.500     0.150
    72.388   681.898     0.150
    72.388   694.102     0.150
    73.135   684.602     0.150
    73.412   695.000     0.150
    73.412   688.203     0.150
    73.412   700.203     0.150
    73.706   688.820     0.150
    73.706   702.023     0.150
    74.372   692.398     0.150
    74.684   703.000     0.150
    74.684    13.203     0.150
    74.968   697.484     0.150
    75.021   697.938     0.150
     4.450    64.465     0.150
     4.569    65.066     0.150
     4.869    69.465     0.150
     5.234    75.168     0.150
     5.988    84.965     0.150
     6.251    88.066     0.150
     6.639    94.168     0.150
     6.930    98.566     0.150
    26.574   336.477     0.150
    52.700   542.965     0.150
    64.550   626.066     0.150
    72.913   678.066     0.150
    76.819   703.168     0.150
     0.973    18.686     0.150
     2.016    56.654     0.150
     3.948    59.254     0.150
     4.351    64.855     0.150
     4.574    68.555     0.150
     5.157    75.355     0.150
     5.516    80.654     0.150
     5.774    84.555     0.150
     6.902    99.654     0.150
     6.903    99.955     0.150
     7.201   104.055     0.150
     7.204   103.855     0.150
     7.288   103.545     0.150
     8.438   120.855     0.150
     9.855   138.855     0.150
    14.476   354.855     0.150
    14.476   204.055     0.150
    14.476   354.855     0.150
    19.926   738.199     0.150
    21.427     5.699     0.150
    21.537   291.654     0.150
    22.895   305.225     0.150
    23.155   304.271     0.150
    23.155   307.855     0.150
    24.555   322.555     0.150
    24.700   324.164     0.150
    25.168   327.254     0.150
    25.508   330.055     0.150
    26.090   331.633     0.150
    26.121   336.055     0.150
    26.806   340.754     0.150
    26.968   342.904     0.150
    27.765   349.154     0.150
    28.030   349.375     0.150
    28.030   349.355     0.150
    28.534   357.055     0.150
    28.887   360.754     0.150
    29.108   365.055     0.150
    29.357   361.021     0.150
    29.680   366.754     0.150
    29.979   372.725     0.150
    30.739   373.904     0.150
    30.784   376.654     0.150
    30.921   374.820     0.150
    31.290   383.055     0.150
    31.346   379.256     0.150
    31.435   383.154     0.150
    32.452   390.754     0.150
    32.786   394.654     0.150
    32.869   392.551     0.150
    32.869   395.654     0.150
    33.137   396.855     0.150
    33.645   401.824     0.150
    33.645   401.855     0.150
    34.119   401.754     0.150
    34.173   407.465     0.150
    34.649   407.209     0.150
    35.232   416.635     0.150
    35.298   416.055     0.150
    35.453   413.959     0.150
    35.469   413.721     0.150
    35.783   418.441     0.150
    35.783   421.605     0.150
    35.881   417.590     0.150
    36.092   420.033     0.150
    37.254   429.570     0.150
    37.854   438.254     0.150
    38.093   437.553     0.150
    38.053   439.654     0.150
    38.118   439.775     0.150
    38.710   445.225     0.150
    38.772   444.605     0.150
    38.844   445.754     0.150
    38.952   445.277     0.150
    39.339   449.539     0.150
    39.492   450.975     0.150
    39.697   452.525     0.150
    39.901   454.475     0.150
    40.144   455.857     0.150
    40.466   456.012     0.150
    40.630   459.523     0.150
    40.662   461.975     0.150
    40.964   461.432     0.150
    41.046   463.084     0.150
    41.220   465.525     0.150
    41.220   465.555     0.150
    41.264   464.994     0.150
    41.257   463.289     0.150
    41.365   464.619     0.150
    41.374   466.254     0.150
    41.680   466.355     0.150
    41.713   466.783     0.150
    41.802   469.098     0.150
    42.345   472.652     0.150
    42.345   474.754     0.150
    42.394   472.553     0.150
    42.534   473.531     0.150
    42.880   476.285     0.150
    42.925   476.750     0.150
    43.110   481.074     0.150
    43.170   479.855     0.150
    43.284   481.055     0.150
    43.319   481.404     0.150
    43.353   482.414     0.150
    43.570   482.254     0.150
    43.478   484.135     0.150
    43.769   493.555     0.150
    43.769   493.555     0.150
    44.033   484.598     0.150
    44.050   487.355     0.150
    44.267   487.422     0.150
    44.739   493.334     0.150
    44.874   492.842     0.150
    45.041   493.248     0.150
    45.052   493.943     0.150
    45.052   497.215     0.150
    45.151   494.020     0.150
    45.291   497.635     0.150
    45.336   497.254     0.150
    45.421   498.174     0.150
    45.841   502.725     0.150
    45.841   502.754     0.150
    46.010   505.025     0.150
    46.061   501.863     0.150
    46.362   503.564     0.150
    46.465   504.121     0.150
    46.622   506.506     0.150
    46.848   508.252     0.150
    47.093   509.588     0.150
    47.093   512.115     0.150
    47.182   510.807     0.150
    47.323   514.254     0.150
    47.406   511.887     0.150
    47.598   513.789     0.150
    47.605   515.555     0.150
    47.650   516.664     0.150
    47.650   516.654     0.150
    47.714   514.469     0.150
    47.725   514.428     0.150
    47.751   514.816     0.150
    47.893   515.855     0.150
    48.099   517.633     0.150
    48.166   518.516     0.150
    48.540   519.838     0.150
    48.546   520.711     0.150
    48.743   524.615     0.150
    48.791   522.359     0.150
    48.808   523.396     0.150
    48.963   523.877     0.150
    49.344   527.049     0.150
    49.390   530.205     0.150
    49.680   531.805     0.150
    49.855   533.334     0.150
    49.893   533.580     0.150
    49.893   534.484     0.150
    49.893   534.455     0.150
    49.940   531.023     0.150
    50.026   532.521     0.150
    50.083   535.875     0.150
    50.110   532.865     0.150
    50.410   534.977     0.150
    50.495   536.398     0.150
    50.508   537.805     0.150
    50.526   535.812     0.150
    50.576   539.494     0.150
    50.576   539.455     0.150
    50.652     7.000     0.150
    51.010   539.736     0.150
    51.340   542.146     0.150
    51.784   548.484     0.150
    52.292   551.055     0.150
    52.396   552.064     0.150
    52.401   551.062     0.150
    53.718   560.154     0.150
    54.009   561.855     0.150
    59.727     5.000     0.150
    59.980   604.455     0.150
    62.251   618.955     0.150
    64.696   636.154     0.150
    64.905   637.455     0.150
    65.539   642.455     0.150
    66.291  4955.254     0.150
    66.958   650.754     0.150
    66.958   650.654     0.150
    67.051   651.355     0.150
    67.179     5.500     0.150
    67.179     8.000     0.150
    67.602     5.699     0.150
    67.602    10.000     0.150
    71.604   680.154     0.150
    71.604     4.900     0.150
    71.604  1240.055     0.150
    71.681  5356.656     0.150
    72.115   689.535     0.150
    72.115   683.455     0.150
    72.115   689.555     0.150
    72.115   698.154     0.150
    72.816   688.055     0.150
    72.816   693.654     0.150
    72.822   686.855     0.150
    73.813   694.355     0.150
    73.813   701.455     0.150
    73.959   693.855     0.150
    73.959   693.855     0.150
    74.016   695.055     0.150
    74.159  5543.254     0.150
    74.184  5544.855     0.150
    74.255  5550.254     0.150
    74.386  5559.953     0.150
    74.821   699.555     0.150
    74.833   706.154     0.150
    74.848   699.355     0.150
    75.164   702.059     0.150
    75.450   703.654     0.150
    78.046   718.455     0.150
    78.313   720.555     0.150
    79.914  5974.055     0.150
    80.890   732.754     0.150
    80.895   732.654     0.150
    81.063  6061.953     0.150
    81.771   737.754     0.150
    82.299   738.855     0.150
    82.635   741.754     0.150
    82.638   741.254     0.150
    82.628   742.855     0.150
    83.359   745.855     0.150
    83.548   747.455     0.150
    98.467   817.754     0.150
     2.809    41.188     0.150
     4.319    63.969     0.150
     4.740    69.672     0.150
     4.869    70.273     0.150
     4.938    73.773     0.150
     5.220    74.352     0.150
     5.529    79.070     0.150
     5.894    84.773     0.150
     6.290    90.070     0.150
     7.294   104.172     0.150
     7.294   182.570     0.150
     7.555   106.391     0.150
     7.589   108.273     0.150
     7.979   110.570     0.150
     8.795   124.469     0.150
     9.917   139.867     0.150
    10.838   149.938     0.150
    11.386   155.609     0.150
    11.624   166.773     0.150
    12.423   939.930     0.150
    12.479   932.883     0.150
    12.689   316.320     0.150
    12.872   177.633     0.150
    14.863   386.594     0.150
    14.863   468.852     0.150
    14.863   208.070     0.150
    15.316   214.062     0.150
    19.102   258.570     0.150
    20.901   277.250     0.150
    21.422   288.367     0.150
    21.713   291.070     0.150
    22.332   298.172     0.150
    24.663   321.070     0.150
    25.352   326.867     0.150
    25.606   329.367     0.150
    26.271   335.273     0.150
    26.903   338.570     0.150
    27.915   346.570     0.150
    27.990   350.250     0.150
    27.990   350.273     0.150
    28.416   352.867     0.150
    28.972   355.172     0.150
    28.956   363.047     0.150
    29.008   359.867     0.150
    29.373   546.203     0.150
    29.863   367.969     0.150
    30.954   376.672     0.150
    31.436   380.867     0.150
    31.554   381.867     0.150
    32.553   391.172     0.150
    32.962   394.672     0.150
    33.119   395.867     0.150
    33.296   397.680     0.150
    33.965   402.367     0.150
    34.070   403.867     0.150
    34.228   558.781     0.150
    34.963   412.438     0.150
    35.332   413.117     0.150
    35.332   413.172     0.150
    35.438   415.570     0.150
    36.817   420.070     0.150
    37.055   423.172     0.150
    37.055   764.172     0.150
    37.519   532.672     0.150
    37.821   436.703     0.150
    38.226   573.023     0.150
    38.226   439.672     0.150
    38.615   442.133     0.150
    39.627   451.016     0.150
    40.198   454.227     0.150
    40.337   456.172     0.150
    40.300   456.008     0.150
    40.318   457.164     0.150
    40.968   461.867     0.150
    41.214   581.023     0.150
    41.516   465.172     0.150
    41.552   465.102     0.150
    41.651   466.883     0.150
    42.206   471.984     0.150
    42.446   474.031     0.150
    42.560   475.383     0.150
    42.560   475.367     0.150
    42.677   474.961     0.150
    42.834   476.242     0.150
    43.045   478.633     0.150
    43.289   479.352     0.150
    43.427   480.219     0.150
    43.661   483.070     0.150
    44.061   487.969     0.150
    44.318   488.867     0.150
    44.418   487.906     0.150
    44.510   490.367     0.150
    44.770   491.016     0.150
    44.949   492.242     0.150
    44.971   492.047     0.150
    45.210   494.344     0.150
    45.210   494.719     0.150
    45.237   495.039     0.150
    45.451   496.766     0.150
    45.576   498.969     0.150
    46.132   502.672     0.150
    46.738   508.500     0.150
    46.752   508.172     0.150
    47.033   508.461     0.150
    47.094  3533.836     0.150
    47.099  3534.141     0.150
    47.112  3535.086     0.150
    47.145   510.203     0.150
    47.500   513.562     0.150
    47.595   514.070     0.150
    47.818   510.867     0.150
    47.909   516.562     0.150
    47.909   516.570     0.150
    48.250  3623.625     0.150
    48.263  3620.406     0.150
    48.268  3624.391     0.150
    48.437   519.977     0.150
    48.879   522.367     0.150
    48.879   607.172     0.150
    49.045   524.977     0.150
    49.078  3690.820     0.150
    49.555   527.469     0.150
    49.503   528.828     0.150
    50.495   541.672     0.150
    50.527     7.102     0.150
    50.700   538.008     0.150
    51.545   541.938     0.150
    53.645   560.172     0.150
    53.838   560.367     0.150
    54.477   564.773     0.150
    54.975   568.773     0.150
    55.444   571.500     0.150
    58.009   589.570     0.150
    59.648     7.797     0.150
    60.077   604.172     0.150
    60.077   649.570     0.150
    61.724   612.742     0.150
    61.724   612.977     0.150
    62.146   618.773     0.150
    62.366   620.469     0.150
    62.518   618.773     0.150
    64.473   633.570     0.150
    66.062  4943.273     0.150
    66.282     7.195     0.150
    66.282    11.000     0.150
    66.287     4.898     0.150
    67.037   650.070     0.150
    67.037   796.242     0.150
    67.037   649.867     0.150
    67.037   796.273     0.150
    67.115     3.500     0.150
    67.115     6.305     0.150
    67.646     7.000     0.150
    67.646     9.500     0.150
    68.421   661.172     0.150
    68.421   806.070     0.150
    68.926   656.070     0.150
    69.783   667.672     0.150
    70.293   671.773     0.150
    71.406  5343.367     0.150
    71.653  5361.867     0.150
    71.940   681.367     0.150
    72.149   683.570     0.150
    72.450   684.672     0.150
    72.450   702.172     0.150
    72.653   686.172     0.150
    72.815   686.969     0.150
    72.842   687.570     0.150
    72.957   688.367     0.150
    72.957   696.867     0.150
    72.968   688.172     0.150
    73.074   697.070     0.150
    73.115   687.367     0.150
    73.290   687.070     0.150
    73.290   689.469     0.150
    73.287   690.273     0.150
    73.377   690.469     0.150
    73.377   696.969     0.150
    73.449   691.172     0.150
    73.468   690.367     0.150
    73.470   691.070     0.150
    73.562   692.867     0.150
    73.767   692.570     0.150
    73.793   692.172     0.150
    73.877  5529.070     0.150
    73.900  5530.367     0.150
    74.000   686.070     0.150
    73.972  5535.570     0.150
    74.079   693.273     0.150
    74.079   693.273     0.150
    74.104  5544.773     0.150
    74.150   694.969     0.150
    74.290   695.867     0.150
    74.368   695.273     0.150
    74.444   696.070     0.150
    74.520   697.672     0.150
    74.849   698.773     0.150
    75.144   700.273     0.150
    75.147   704.172     0.150
    75.176   700.969     0.150
    75.620     4.203     0.150
    75.620     6.898     0.150
    75.742   705.570     0.150
    75.770   704.367     0.150
    76.647     5.602     0.150
    76.647     7.703     0.150
    77.410   713.969     0.150
    78.349   718.570     0.150
    78.754   720.219     0.150
    78.805   711.773     0.150
    78.975   721.969     0.150
    79.372   723.469     0.150
    79.630  5959.672     0.150
    80.761   731.570     0.150
    80.850  6051.273     0.150
    81.207   732.469     0.150
    81.214   733.172     0.150
    81.392   735.469     0.150
    81.610   735.469     0.150
    81.770   737.172     0.150
    81.770   737.250     0.150
    81.853   737.070     0.150
    82.405   738.672     0.150
    82.462   740.570     0.150
    82.626   741.773     0.150
    82.626   741.867     0.150
    82.626   741.867     0.150
    82.817   742.867     0.150
    82.953   742.172     0.150
    82.978   743.172     0.150
    82.978   743.172     0.150
    83.832   746.273     0.150
    83.827   747.672     0.150
    83.950   748.070     0.150
    84.292   749.672     0.150
    84.427   749.867     0.150
    84.745   751.469     0.150
    84.832   752.773     0.150
    85.829   757.367     0.150
    98.677   816.773     0.150
   142.119  1164.117     0.150
   142.119  1164.117     0.150
   142.119  1166.203     0.150
   146.317  1176.812     0.150
   148.506  1184.172     0.150
   152.083  1191.969     0.150
   160.077  1195.969     0.150
   160.077  1233.570     0.150
   160.447  1196.672     0.150
   160.447  1235.070     0.150
     3.000    48.170     0.150
     3.361    88.430     0.150
     8.310   117.719     0.150
     8.952   127.859     0.150
    12.135   910.100     0.150
    12.190   914.477     0.150
    14.942   211.959     0.150
    47.178  3558.953     0.150
    47.184  3558.607     0.150
    47.196  3559.545     0.150
    48.331  3637.938     0.150
    48.344  3644.314     0.150
    48.349  3644.701     0.150
     0.821    15.446     0.150
     2.650    74.977     0.150
     2.852    78.566     0.150
     4.631    69.146     0.150
     4.836    71.736     0.150
     5.032    74.227     0.150
     5.554    77.677     0.150
     6.058    90.036     0.150
     6.263    91.297     0.150
     6.579    95.937     0.150
     7.511   108.757     0.150
     7.880   113.047     0.150
     0.947    17.370     0.150
     0.947    30.670     0.150
     1.312    20.870     0.150
     3.210    48.870     0.150
     3.855    56.070     0.150
     3.932    58.170     0.150
     5.455    78.570     0.150
     5.730    82.570     0.150
     5.967    86.350     0.150
     6.031    86.470     0.150
     6.280    89.570     0.150
     6.961   102.240     0.150
     6.967    98.570     0.150
     7.371   102.590     0.150
     8.227   116.770     0.150
    13.036   185.110     0.150
    13.272   183.170     0.150
    23.818   307.870     0.150
    32.435   385.770     0.150
    33.376   392.770     0.150
    37.196   425.870     0.150
    38.703   426.270     0.150
    41.918   463.770     0.150
    44.837   488.070     0.150
    45.858   495.870     0.150
    50.662   534.970     0.150
    53.178   549.770     0.150
    53.178   617.270     0.150
    62.537   749.670     0.150
    65.366   632.870     0.150
    65.366   767.390     0.150
    65.456   633.170     0.150
    70.008   664.070     0.150
    70.008   684.770     0.150
    70.902   670.070     0.150
    71.131   668.270     0.150
    71.196   670.770     0.150
    71.437   672.570     0.150
    71.498   672.770     0.150
    72.216   677.770     0.150
    72.299   676.170     0.150
    72.299   676.170     0.150
    78.945   715.470     0.150
    79.019   716.770     0.150
    80.173   720.850     0.150
    80.173   720.870     0.150
    80.661   722.870     0.150
    80.844   727.270     0.150
    80.985   726.170     0.150
    83.780   740.270     0.150
    96.699   799.870     0.150
    96.728   801.970     0.150
   141.928  1157.345     0.150
     1.178    65.039     0.150
     1.178    35.999     0.150
     1.399    23.949     0.150
     1.399    42.789     0.150
     1.419    24.719     0.150
     1.419    44.209     0.150
     1.577    26.169     0.150
     1.776    29.489     0.150
     2.209    35.119     0.150
     2.437    68.699     0.150
     2.422    38.659     0.150
     4.816    67.209     0.150
     4.816    67.199     0.150
     4.816   123.899     0.150
     5.296    75.799     0.150
     5.358   138.819     0.150
     5.684    81.799     0.150
     5.684   144.899     0.150
     5.989    85.799     0.150
     6.966    99.499     0.150
     7.250   103.499     0.150
     7.333   103.899     0.150
     7.420   105.899     0.150
     8.489   120.799     0.150
     9.354   132.599     0.150
    10.279   146.439     0.150
    10.279   146.399     0.150
    11.810   168.819     0.150
    12.005   170.539     0.150
    12.919   950.719     0.150
    12.976   183.559     0.150
    12.976   952.774     0.150
    14.026   199.259     0.150
    14.026   199.299     0.150
    20.432   535.794     0.150
    20.432   272.999     0.150
    20.431   535.489     0.150
    21.907   292.199     0.150
    22.250   295.799     0.150
    22.902   303.799     0.150
    23.863    10.050     0.150
    23.863     9.910     0.150
    23.863   311.599     0.150
    23.863     9.900     0.150
    25.253   545.365     0.150
    25.253   325.699     0.150
    25.880   330.299     0.150
    26.202   333.599     0.150
    26.449   334.604     0.150
    26.785   338.329     0.150
    26.908    12.500     0.150
    26.831   339.299     0.150
    27.499   344.199     0.150
    28.030   348.481     0.150
    28.229   349.429     0.150
    28.363   348.399     0.150
    28.291   351.792     0.150
    28.472   353.033     0.150
    28.803   355.099     0.150
    29.012   358.499     0.150
    29.226   360.199     0.150
    29.436   353.799     0.150
    29.589   363.799     0.150
    29.802   366.799     0.150
    29.959  1916.849     0.150
    29.959   558.699     0.150
    29.959  1916.849     0.150
    30.392   371.099     0.150
    31.079   374.799     0.150
    31.450   560.869     0.150
    31.450   560.872     0.150
    31.496   380.399     0.150
    31.496   380.300     0.150
    31.985   385.099     0.150
    32.036   384.999     0.150
    32.137   386.299     0.150
    32.137   386.253     0.150
    33.062   394.899     0.150
    33.147   394.999     0.150
    33.179   394.263     0.150
    33.394   397.199     0.150
    33.603   554.309     0.150
    33.499   398.399     0.150
    33.567   398.299     0.150
    33.670   398.622     0.150
    33.845   401.299     0.150
    33.987   401.988     0.150
    34.283   403.019     0.150
    34.283   402.999     0.150
    34.669   407.799     0.150
    34.698   408.146     0.150
    35.421   412.792     0.150
    35.647   416.299     0.150
    35.647   416.383     0.150
    35.927   418.999     0.150
    35.976   418.682     0.150
    36.905   427.287     0.150
    37.831   435.112     0.150
    37.879   433.150     0.150
    37.947   437.199     0.150
    37.947   445.999     0.150
    37.947   437.199     0.150
    37.947   445.999     0.150
    37.966   434.606     0.150
    38.221   438.458     0.150
    38.558   441.499     0.150
    38.558   441.370     0.150
    38.783   451.299     0.150
    38.768   440.970     0.150
    38.766   442.763     0.150
    39.227   444.995     0.150
    39.549   448.899     0.150
    39.549   448.834     0.150
    40.034   451.094     0.150
    40.350   454.362     0.150
    40.566   456.052     0.150
    41.323   462.572     0.150
    41.341   462.695     0.150
    41.845   468.364     0.150
    41.886   466.399     0.150
    41.886   466.294     0.150
    41.950   467.504     0.150
    43.055   477.199     0.150
    43.055   477.184     0.150
    43.294   486.099     0.150
    43.418   490.599     0.150
    43.418   479.099     0.150
    43.418   490.599     0.150
    43.813   482.406     0.150
    43.865   481.405     0.150
    44.024   483.999     0.150
    44.024   483.999     0.150
    44.027   483.717     0.150
    44.125   484.500     0.150
    44.138   484.380     0.150
    45.024   491.804     0.150
    45.238   493.999     0.150
    45.516   494.904     0.150
    45.565   494.732     0.150
    45.763   503.399     0.150
    45.796   606.124     0.150
    45.796   497.649     0.150
    45.796   594.429     0.150
    45.796   606.129     0.150
    45.764   498.899     0.150
    45.764   498.844     0.150
    45.849   498.699     0.150
    45.859   499.342     0.150
    46.038   500.199     0.150
    46.038   500.083     0.150
    46.511   503.599     0.150
    46.532   502.819     0.150
    47.248   503.799     0.150
    47.313   509.699     0.150
    47.549   512.101     0.150
    47.773   513.369     0.150
    48.008   515.499     0.150
    48.317   518.999     0.150
    48.334   517.770     0.150
    48.344   517.899     0.150
    48.344   517.933     0.150
    48.743   520.597     0.150
    49.054   522.651     0.150
    49.721   527.799     0.150
    49.721   527.799     0.150
    49.683   527.832     0.150
    49.948   526.499     0.150
    49.935   531.305     0.150
    49.949   530.735     0.150
    49.965   530.371     0.150
    50.071   530.939     0.150
    50.089   530.883     0.150
    50.474   533.783     0.150
    50.528   534.335     0.150
    50.568   534.599     0.150
    50.592   534.799     0.150
    50.792   536.287     0.150
    50.904   537.089     0.150
    50.999   537.925     0.150
    51.082   538.955     0.150
    51.177   538.704     0.150
    51.179   538.823     0.150
    51.233   539.599     0.150
    51.233   539.571     0.150
    51.905   544.999     0.150
    51.977   544.890     0.150
    52.023   545.699     0.150
    52.232   547.099     0.150
    52.298   546.630     0.150
    52.419   547.899     0.150
    52.963   552.399     0.150
    53.296   554.099     0.150
    53.296    11.400     0.150
    53.560   555.899     0.150
    53.588   566.869     0.150
    53.784   635.049     0.150
    53.784   635.049     0.150
    53.784   557.399     0.150
    53.784    10.700     0.150
    53.784   567.779     0.150
    54.412   562.799     0.150
    54.440   563.395     0.150
    54.938   565.379     0.150
    55.483    17.800     0.150
    56.083   643.859     0.150
    56.083   643.859     0.150
    56.083   643.859     0.150
    59.198   606.599     0.150
    59.448   597.299     0.150
    59.448    10.900     0.150
    60.271   615.919     0.150
    61.758   613.899     0.150
    61.911   614.699     0.150
    61.911    10.500     0.150
    61.926   615.139     0.150
    62.189    11.000     0.150
    62.189    17.200     0.150
    62.812   623.079     0.150
    63.002   623.099     0.150
    63.896   627.199     0.150
    63.896   857.699     0.150
    64.180   629.412     0.150
    64.180   629.499     0.150
    64.445   630.999     0.150
    65.607   639.899     0.150
    65.656    10.200     0.150
    65.656    14.400     0.150
    66.405   643.719     0.150
    66.405    10.630     0.150
    66.502    11.400     0.150
    66.502    16.300     0.150
    66.500   644.399     0.150
    66.616  4949.299     0.150
    67.164   661.599     0.150
    67.164   649.999     0.150
    67.164   661.599     0.150
    67.228   658.999     0.150
    67.228  1169.999     0.150
    67.635   654.359     0.150
    67.919   670.199     0.150
    67.919  1229.999     0.150
    67.909   654.399     0.150
    68.863   659.999     0.150
    69.343   662.529     0.150
    69.343   662.499     0.150
    69.883   666.499     0.150
    71.557   679.399     0.150
    71.557   676.699     0.150
    71.906  5353.599     0.150
    72.062   682.639     0.150
    72.062   691.619     0.150
    72.062   679.899     0.150
    72.062   691.599     0.150
    72.062  1238.999     0.150
    72.251   681.099     0.150
    72.451   682.099     0.150
    72.451   694.999     0.150
    72.476   682.999     0.150
    72.578   683.399     0.150
    72.578   694.199     0.150
    72.744   684.399     0.150
    72.744   696.199     0.150
    72.744  1246.299     0.150
    72.977    14.400     0.150
    72.986   685.699     0.150
    73.047   683.669     0.150
    73.047   684.239     0.150
    73.047   684.199     0.150
    73.045   686.199     0.150
    73.045   697.199     0.150
    73.077   686.299     0.150
    73.356   687.499     0.150
    73.458   687.499     0.150
    73.553   690.799     0.150
    73.720   689.799     0.150
    73.720   689.799     0.150
    73.765   690.599     0.150
    73.799   690.799     0.150
    73.866   690.699     0.150
    73.951   690.899     0.150
    74.059   691.999     0.150
    74.102   692.899     0.150
    74.365  5539.499     0.150
    74.387  5541.799     0.150
    74.639   694.299     0.150
    74.730   695.499     0.150
    74.770   695.199     0.150
    74.807   704.999     0.150
    74.807   695.299     0.150
    75.218   698.799     0.150
    75.350   699.599     0.150
    75.350   699.589     0.150
    75.350   699.599     0.150
    75.693   702.099     0.150
    75.769   701.699     0.150
    76.053    11.500     0.150
    76.053    18.500     0.150
    76.561   706.099     0.150
    76.559   705.599     0.150
    77.075   710.199     0.150
    77.140   719.489     0.150
    77.516   711.299     0.150
    77.532   711.799     0.150
    77.661   713.299     0.150
    77.708   712.599     0.150
    77.713   712.699     0.150
    77.894   714.199     0.150
    77.946   713.999     0.150
    78.189   715.099     0.150
    78.171   720.849     0.150
    78.437   716.706     0.150
    78.437   716.609     0.150
    78.904   718.999     0.150
    78.985   720.379     0.150
    79.427   721.699     0.150
    79.919   724.599     0.150
    80.116  5970.599     0.150
    80.194   726.199     0.150
    80.480   728.199     0.150
    80.520   728.699     0.150
    80.769   728.699     0.150
    80.800   728.999     0.150
    81.255   731.799     0.150
    81.418  6056.499     0.150
    81.658   737.294     0.150
    81.658   737.299     0.150
    81.654   733.899     0.150
    81.792   735.494     0.150
    81.907   735.399     0.150
    82.020   736.199     0.150
    82.045   736.799     0.150
    82.191   737.299     0.150
    82.191   737.299     0.150
    82.384   738.199     0.150
    82.384   738.199     0.150
    82.527   738.199     0.150
    83.239   742.499     0.150
    83.240   741.399     0.150
    83.241   742.199     0.150
    83.334   744.199     0.150
    83.542   743.572     0.150
    84.404   748.399     0.150
    85.250   752.699     0.150
    85.285   752.299     0.150
    85.397   752.899     0.150
    85.417   753.679     0.150
    85.847   753.699     0.150
    87.484   762.699     0.150
    87.957   765.299     0.150
    87.957   765.299     0.150
    88.083   764.819     0.150
    88.111   765.899     0.150
    88.111   765.899     0.150
    88.212   766.099     0.150
    91.437   782.099     0.150
    96.885   805.799     0.150
    97.974   810.199     0.150
    98.108   812.599     0.150
    99.763   819.499     0.150
   101.363  1085.849     0.150
   143.149  1011.909     0.150
   143.438  1013.599     0.150
   148.058  1192.129     0.150
   148.058  1173.359     0.150
   148.058  1181.199     0.150
     0.906    15.258     0.150
     0.906    24.727     0.150
     3.646    51.188     0.150
     4.008    55.305     0.150
     4.138    56.445     0.150
     4.845    67.672     0.150
     5.092   124.508     0.150
     5.375    74.773     0.150
     5.371    75.828     0.150
     5.587    75.414     0.150
     5.606    76.203     0.150
     5.785    80.305     0.150
     5.997    82.984     0.150
     6.075   154.336     0.150
     6.067    84.312     0.150
     6.133    83.688     0.150
     6.291    86.148     0.150
     6.390    86.367     0.150
     6.896    94.969     0.150
     7.055    95.656     0.150
     7.127    96.781     0.150
     7.069    97.438     0.150
     7.108    96.656     0.150
     7.108   174.266     0.150
     7.342   101.555     0.150
     7.320    99.414     0.150
     8.605   118.086     0.150
    13.551   193.812     0.150
     0.260     3.877     0.150
     0.761    15.607     0.150
     1.456    26.537     0.150
     1.466    26.617     0.150
     1.432    24.506     0.150
     1.480    27.037     0.150
     1.456    25.336     0.150
     2.054    34.246     0.150
     2.526    41.377     0.150
     2.569    42.006     0.150
     2.610    42.637     0.150
     2.669    43.777     0.150
     2.697    43.967     0.150
     2.889    45.777     0.150
     4.748    73.717     0.150
     4.755    74.127     0.150
     4.903    75.857     0.150
     5.110    78.277     0.150
     5.350    81.746     0.150
     5.589    85.438     0.150
     5.806    89.816     0.150
     6.306    96.277     0.150
     6.511    99.348     0.150
     7.817   112.857     0.150
     9.318   137.527     0.150
    30.699   379.896     0.150
    32.345   390.447     0.150
    46.549   507.236     0.150
     0.880    19.168     0.150
     1.187    20.607     0.150
     1.187    35.883     0.150
     1.431    23.449     0.150
     1.634    28.838     0.150
     2.087    34.879     0.150
     2.642    42.338     0.150
     3.353    51.289     0.150
     4.426    63.889     0.150
     4.794    69.289     0.150
     5.817    83.789     0.150
     6.197    88.289     0.150
     7.049    99.289     0.150
     7.171  2353.688     0.150
     8.017   115.889     0.150
    10.233   140.889     0.150
    13.414   184.988     0.150
    14.367   197.789     0.150
    16.121   391.559     0.150
    18.641   249.389     0.150
    19.699  2318.184     0.150
    19.666   262.428     0.150
    19.666   262.289     0.150
    22.724   294.789     0.150
    23.527   303.588     0.150
    24.122    20.852     0.150
    24.122    20.600     0.150
    24.122   308.100     0.150
    25.973    20.930     0.150
    25.973   325.928     0.150
    25.973    20.910     0.150
    26.957   333.988     0.150
    27.018   332.209     0.150
    27.018   743.719     0.150
    27.399   337.889     0.150
    27.590   532.908     0.150
    28.418   346.188     0.150
    28.714   348.889     0.150
    29.162    27.400     0.150
    29.994   360.789     0.150
    30.055   363.188     0.150
    30.258   363.389     0.150
    30.406   363.789     0.150
    30.754   366.934     0.150
    30.815   368.588     0.150
    30.819   368.189     0.150
    31.750  2264.738     0.150
    32.139   379.568     0.150
    32.720   385.188     0.150
    32.813   385.289     0.150
    32.814   385.789     0.150
    32.814   385.883     0.150
    33.544   392.092     0.150
    33.576   393.088     0.150
    33.680   393.188     0.150
    33.884   394.988     0.150
    33.992  2255.438     0.150
    33.992   394.588     0.150
    34.194   397.789     0.150
    34.422   399.889     0.150
    34.422    21.900     0.150
    34.513   399.898     0.150
    34.685   401.998     0.150
    35.438   407.688     0.150
    35.708    24.049     0.150
    35.945   412.688     0.150
    35.973   411.688     0.150
    36.322   416.051     0.150
    36.570   416.588     0.150
    36.663    22.801     0.150
    36.807   420.471     0.150
    36.865   420.932     0.150
    37.177   422.789     0.150
    37.837   427.059     0.150
    38.527   433.951     0.150
    38.568   434.924     0.150
    39.004   438.289     0.150
    39.142   438.789     0.150
    39.200   440.172     0.150
    39.226   568.818     0.150
    39.226   440.088     0.150
    39.226   440.143     0.150
    39.313   440.789     0.150
    40.401   570.578     0.150
    40.401   790.209     0.150
    41.155   455.189     0.150
    41.182   454.389     0.150
    41.585   458.488     0.150
    41.585   574.889     0.150
    41.734   459.488     0.150
    41.867   461.449     0.150
    42.011   461.811     0.150
    42.079   459.988     0.150
    42.530   577.389     0.150
    42.760   467.889     0.150
    42.760   577.488     0.150
    42.853   469.375     0.150
    42.996   469.721     0.150
    43.324   473.236     0.150
    43.971   477.607     0.150
    44.082   478.271     0.150
    44.533   482.633     0.150
    44.744   483.088     0.150
    44.744   483.145     0.150
    45.135   487.988     0.150
    45.226   487.088     0.150
    45.226    23.100     0.150
    46.160   495.910     0.150
    46.162   495.482     0.150
    46.186   495.248     0.150
    46.399   496.314     0.150
    46.620   498.195     0.150
    46.905   500.889     0.150
    47.056   502.982     0.150
    47.205   502.988     0.150
    47.205   503.000     0.150
    47.438   504.971     0.150
    47.672   512.666     0.150
    47.795   508.449     0.150
    47.953   508.068     0.150
    47.985   509.432     0.150
    48.112   510.920     0.150
    48.115   510.131     0.150
    48.121   509.688     0.150
    48.208   911.588     0.150
    48.400   518.818     0.150
    48.443   518.301     0.150
    48.447   512.809     0.150
    48.496   514.191     0.150
    48.625   515.088     0.150
    48.812   515.434     0.150
    48.816   522.639     0.150
    48.825   522.328     0.150
    48.906   540.088     0.150
    49.131   525.547     0.150
    49.171   524.277     0.150
    49.317   520.611     0.150
    49.340    23.199     0.150
    49.552   521.982     0.150
    49.598   522.414     0.150
    49.685   527.941     0.150
    50.033   530.338     0.150
    50.054   525.027     0.150
    50.088   526.461     0.150
    50.115   531.059     0.150
    50.247   533.158     0.150
    50.467   528.088     0.150
    50.802   537.332     0.150
    50.820   530.629     0.150
    50.926   535.484     0.150
    50.960   531.963     0.150
    51.025   532.365     0.150
    51.147   539.018     0.150
    51.198   539.252     0.150
    51.481   536.656     0.150
    51.541   541.816     0.150
    51.601   537.275     0.150
    51.699   542.279     0.150
    51.726   532.588     0.150
    51.726    27.801     0.150
    51.995   537.488     0.150
    51.995   610.188     0.150
    52.037   544.812     0.150
    52.135   540.424     0.150
    52.240   541.725     0.150
    52.362   541.637     0.150
    52.409   547.736     0.150
    52.585   565.889     0.150
    52.876   545.889     0.150
    52.876   613.889     0.150
    52.876   545.889     0.150
    52.876   613.889     0.150
    53.266   548.539     0.150
    53.266   844.508     0.150
    53.266   571.889     0.150
    54.417   577.389     0.150
    54.802   559.789     0.150
    54.802   622.088     0.150
    54.912    32.102     0.150
    55.106   562.488     0.150
    55.106   622.988     0.150
    56.726   573.289     0.150
    58.259    35.100     0.150
    60.218   596.088     0.150
    60.218   596.398     0.150
    60.347   597.088     0.150
    60.347   642.088     0.150
    60.451   594.988     0.150
    61.469   605.588     0.150
    61.469   647.289     0.150
    61.695    22.900     0.150
    62.714   613.139     0.150
    62.854   614.588     0.150
    63.036   615.289     0.150
    63.040  2350.738     0.150
    64.137   623.559     0.150
    64.137   623.588     0.150
    64.143   621.949     0.150
    64.591   626.688     0.150
    64.591   659.389     0.150
    64.591   659.889     0.150
    64.711    19.102     0.150
    64.711  1175.389     0.150
    64.711  1394.088     0.150
    65.148   629.389     0.150
    65.149   761.221     0.150
    65.149   629.289     0.150
    65.625   632.789     0.150
    65.625   632.789     0.150
    65.668    27.000     0.150
    65.667    24.000     0.150
    65.667    35.500     0.150
    65.845    23.400     0.150
    65.845    34.000     0.150
    66.358    26.699     0.150
    66.363   637.289     0.150
    66.491   637.988     0.150
    67.235   642.998     0.150
    67.298   642.988     0.150
    67.781   646.088     0.150
    67.781   672.988     0.150
    67.894   648.678     0.150
    68.333   650.088     0.150
    69.631   658.059     0.150
    69.908   659.889     0.150
    69.908   682.488     0.150
    70.004    32.301     0.150
    70.019   660.289     0.150
    70.019   660.289     0.150
    70.019   682.389     0.150
    70.049   812.688     0.150
    70.521   663.688     0.150
    70.521   684.588     0.150
    70.704   664.789     0.150
    70.704   685.488     0.150
    70.908   666.389     0.150
    70.968   666.949     0.150
    71.022   667.188     0.150
    71.043   667.188     0.150
    71.078   665.889     0.150
    71.086   665.789     0.150
    71.196   668.188     0.150
    71.196   688.588     0.150
    71.354   669.406     0.150
    71.354   669.268     0.150
    71.355   669.088     0.150
    71.535   669.889     0.150
    71.804   671.188     0.150
    71.835   671.588     0.150
    71.835   671.488     0.150
    72.107   672.789     0.150
    72.160   673.488     0.150
    72.190   674.188     0.150
    72.197   674.088     0.150
    72.227   674.289     0.150
    72.310   674.588     0.150
    72.333    28.100     0.150
    72.534   675.889     0.150
    72.547   676.588     0.150
    73.089   679.588     0.150
    73.089   697.088     0.150
    73.152   690.588     0.150
    73.176   679.588     0.150
    73.221   679.289     0.150
    73.221   696.088     0.150
    73.221   840.588     0.150
    73.251   678.889     0.150
    73.251   678.889     0.150
    73.251   695.789     0.150
    73.719    23.801     0.150
    73.794   683.688     0.150
    73.794   683.588     0.150
    74.052   684.688     0.150
    74.792   686.988     0.150
    74.792   700.988     0.150
    74.792  1247.988     0.150
    74.792  1298.988     0.150
    75.000   689.889     0.150
    75.021   690.357     0.150
    75.067   691.088     0.150
    75.125   690.357     0.150
    75.327   691.789     0.150
    75.351    21.199     0.150
    75.351    34.100     0.150
    75.368   692.008     0.150
    75.600   705.809     0.150
    75.643   693.988     0.150
    75.929   696.289     0.150
    75.951   693.188     0.150
    76.330   698.289     0.150
    76.562    21.900     0.150
    76.603   699.188     0.150
    76.694   701.631     0.150
    76.830   700.289     0.150
    76.896   700.889     0.150
    77.217   702.289     0.150
    77.251    33.000     0.150
    77.339   703.088     0.150
    77.339   702.988     0.150
    77.613   704.789     0.150
    78.137   708.459     0.150
    78.831   712.988     0.150
    78.946   712.988     0.150
    79.107   714.588     0.150
    79.208   713.188     0.150
    79.247   713.588     0.150
    79.274   717.088     0.150
    79.312   714.789     0.150
    79.885   718.588     0.150
    79.885   718.488     0.150
    80.170   721.988     0.150
    80.292   720.988     0.150
    80.292   720.889     0.150
    80.393   721.457     0.150
    80.393   721.484     0.150
    80.393   721.488     0.150
    80.460   719.488     0.150
    80.630   720.289     0.150
    80.673   720.188     0.150
    80.825   721.289     0.150
    80.922   720.389     0.150
    80.922   723.389     0.150
    80.970   720.088     0.150
    80.970   723.188     0.150
    81.474   722.988     0.150
    81.771   725.988     0.150
    81.771   728.014     0.150
    81.771   728.088     0.150
    81.869   728.160     0.150
    81.869   728.088     0.150
    82.352   730.588     0.150
    82.546   731.188     0.150
    82.546   731.088     0.150
    82.754   731.988     0.150
    83.908   736.588     0.150
    83.908   738.188     0.150
    84.582   739.289     0.150
    85.182   749.889     0.150
    86.628   748.088     0.150
    92.302   779.988     0.150
    96.602   798.889     0.150
    97.255   801.789     0.150
   122.027  1124.568     0.150
   122.027  1331.539     0.150
   122.027  1124.209     0.150
   136.767  1137.883     0.150
   138.487  1145.838     0.150
   138.487  1145.838     0.150
   138.487  1358.389     0.150
   140.264  1150.008     0.150
   140.264  1150.658     0.150
   140.264  1365.039     0.150
   141.585  1154.357     0.150
   141.585  1154.357     0.150
   141.873  1152.379     0.150
   141.873  1154.789     0.150
   141.873  1152.379     0.150
   146.495  1169.258     0.150
   146.495  1380.289     0.150
   148.336  1173.857     0.150
   148.336  1199.139     0.150
   150.078  1174.148     0.150
   150.078  1186.107     0.150
   150.078  1204.139     0.150
   150.078  1179.469     0.150
   152.712  1185.088     0.150
   162.456  1236.406     0.150
     1.128    27.559     0.150
     1.120    27.301     0.150
     1.173    27.648     0.150
     1.172    27.668     0.150
     1.245    28.320     0.150
    13.523   187.969     0.150
    20.049   258.410     0.150
     3.871    54.816     0.150
     4.245   102.246     0.150
     5.261    74.715     0.150
     6.508    91.363     0.150
     6.638    92.496     0.150
     7.711   107.375     0.150
     8.388   117.383     0.150
     8.881   122.324     0.150
     0.410     8.912     0.150
     1.335    22.992     0.150
     1.399    24.021     0.150
     1.499    26.332     0.150
     1.865    32.012     0.150
     1.877    31.531     0.150
     1.877    54.932     0.150
     1.870    31.791     0.150
     1.913    32.492     0.150
     1.981    33.121     0.150
     2.143    38.801     0.150
     2.674    43.371     0.150
     3.179    51.881     0.150
     4.300    69.641     0.150
     4.928    77.451     0.150
     6.244    90.371     0.150
     6.714   100.721     0.150
    11.765   172.320     0.150
    14.195   204.471     0.150
    19.427   526.676     0.150
    23.919   312.574     0.150
    26.657   337.592     0.150
    26.657   337.381     0.150
    39.045   448.900     0.150
    58.397   588.832     0.150
    65.794   639.832     0.150
    65.794   664.332     0.150
    65.794    35.799     0.150
    65.901   640.230     0.150
    70.144   663.230     0.150
    73.746   688.631     0.150
    73.746   855.031     0.150
    73.746  1249.131     0.150
    73.746  1536.531     0.150
   149.927  1189.156     0.150
     1.225    20.079     0.150
     1.225    35.891     0.150
     1.269    22.094     0.150
     1.334    23.144     0.150
     1.477    24.754     0.150
     1.477    44.523     0.150
     1.594    26.534     0.150
     1.798    30.813     0.150
     1.912    32.574     0.150
     2.473    39.504     0.150
     4.713    73.434     0.150
     5.166    78.474     0.150
     6.827    96.874     0.150
     6.881   180.250     0.150
     6.881   208.780     0.150
     6.881   180.254     0.150
     6.881   208.784     0.150
     8.653   128.894     0.150
    10.965   161.954     0.150
    19.424   525.592     0.150
    26.606   338.418     0.150
    51.989   550.677     0.150
    58.075   589.523     0.150
    58.079   589.704     0.150
    58.079   589.528     0.150
    72.931   686.134     0.150
    85.234   756.438     0.150
     0.470    10.047     0.150
     0.470    17.148     0.150
     3.806    55.445     0.150
     3.806    97.250     0.150
     3.858    55.742     0.150
     4.423    64.750     0.150
     5.300    76.047     0.150
     5.567    80.047     0.150
     5.690    82.047     0.150
     5.854    84.047     0.150
     5.872    84.648     0.150
     6.800    96.781     0.150
     7.105   100.750     0.150
     8.951   123.945     0.150
     9.191   130.852     0.150
    15.475   212.648     0.150
    20.916   287.750     0.150
    21.352   285.047     0.150
    22.775   301.148     0.150
    22.775   298.367     0.150
    24.941   322.352     0.150
    25.423   324.547     0.150
    25.598   328.445     0.150
    26.026   331.250     0.150
    26.680   334.648     0.150
    26.792   331.750     0.150
    28.151   346.867     0.150
    28.889   356.750     0.150
    28.889   544.250     0.150
    30.604   371.250     0.150
    30.604   548.648     0.150
    30.652   373.344     0.150
    31.158   372.828     0.150
    31.354   375.781     0.150
    31.456   379.547     0.150
    32.368   387.547     0.150
    32.521   389.852     0.150
    32.831   390.148     0.150
    36.737   425.648     0.150
    37.371   428.719     0.150
    37.857   434.852     0.150
    37.857   569.750     0.150
    40.513   455.445     0.150
    40.513   455.469     0.150
    40.515   446.852     0.150
    41.930   478.547     0.150
    41.930   467.445     0.150
    41.930   478.547     0.150
    41.979   468.148     0.150
    42.238   479.750     0.150
    42.238   468.750     0.150
    42.238   479.750     0.150
    43.954   483.445     0.150
    43.974   483.672     0.150
    44.797   491.547     0.150
    44.797   491.609     0.150
    47.104   508.750     0.150
    47.104   508.734     0.150
    47.288   509.688     0.150
    47.941   514.750     0.150
    48.534   519.086     0.150
    49.183   524.727     0.150
    49.188   525.266     0.150
    49.528   526.047     0.150
    49.830   529.648     0.150
    49.830   529.656     0.150
    50.847   537.180     0.150
    51.609   542.547     0.150
    59.299   596.648     0.150
    59.545   600.547     0.150
    61.093   617.148     0.150
    61.729   613.852     0.150
    62.548   628.945     0.150
    63.284   623.648     0.150
    63.822   628.148     0.150
    63.976   628.047     0.150
    64.063   628.648     0.150
    66.039     7.000     0.150
    66.039    10.703     0.150
    66.301   651.250     0.150
    66.327   643.047     0.150
    66.416   644.352     0.150
    66.545   658.945     0.150
    66.979   651.445     0.150
    66.979   656.648     0.150
    67.021    12.297     0.150
    67.021    18.000     0.150
    69.351   673.047     0.150
    70.295   680.047     0.150
    70.295   669.250     0.150
    70.318   666.648     0.150
    70.535   679.547     0.150
    70.714   680.547     0.150
    70.811   682.531     0.150
    70.811   672.445     0.150
    70.811   682.547     0.150
    70.955   681.445     0.150
    71.207   675.148     0.150
    71.308   673.945     0.150
    71.342   685.852     0.150
    71.342   676.047     0.150
    71.522   687.250     0.150
    71.522   677.445     0.150
    71.601   676.250     0.150
    71.740   689.445     0.150
    71.740   678.047     0.150
    71.900   677.148     0.150
    72.131   680.750     0.150
    72.188   680.945     0.150
    72.292   682.648     0.150
    72.435   693.250     0.150
    72.684   683.852     0.150
    72.800   684.352     0.150
    72.800   684.648     0.150
    72.919   696.852     0.150
    72.919   686.352     0.150
    72.863  5424.445     0.150
    73.200   686.547     0.150
    73.200   687.047     0.150
    73.265   687.648     0.150
    73.537   698.852     0.150
    73.537   689.148     0.150
    73.557   698.750     0.150
    73.557   688.852     0.150
    73.894    11.703     0.150
    74.022   703.414     0.150
    74.082    11.414     0.150
    74.156    10.938     0.150
    74.160    11.641     0.150
    74.171   693.148     0.150
    74.300    11.859     0.150
    74.517   707.102     0.150
    74.540    10.625     0.150
    75.938   702.445     0.150
    76.505   716.352     0.150
    76.598   706.547     0.150
    76.803   708.648     0.150
    77.633   718.047     0.150
    78.016   715.250     0.150
    79.482   724.047     0.150
    79.633   722.648     0.150
    79.612   723.148     0.150
    81.129   731.445     0.150
    82.092   736.352     0.150
    82.472   738.750     0.150
    85.244   753.258     0.150
    97.447   809.945     0.150
   159.607  1243.492     0.150
     2.416    38.363     0.150
     5.369    77.342     0.150
     1.861    29.789     0.150
     3.681   101.719     0.150
     4.500   120.070     0.150
     4.838    70.133     0.150
     5.062    75.852     0.150
     6.331    92.852     0.150
     6.848    97.992     0.150
     7.942   111.125     0.150
     8.412   205.250     0.150
     8.412   205.258     0.150
    23.165   301.859     0.150
    24.543   312.773     0.150
    25.187   322.250     0.150
    26.149   331.758     0.150
    66.263     4.305     0.150
    66.263     7.000     0.150
    67.136   653.430     0.150
    67.136     4.398     0.150
    67.136     6.500     0.150
     1.034    18.898     0.150
     5.609    80.414     0.150
     7.191   105.307     0.150
     1.338    40.709     0.150
     6.083    88.459     0.150
     7.807   109.068     0.150
     1.471    24.896     0.150
     2.706    42.197     0.150
     5.322    74.797     0.150
     5.684    80.936     0.150
     6.158    88.086     0.150
     6.408    91.176     0.150
     7.308   103.137     0.150
     7.326   103.016     0.150
     7.582   107.236     0.150
     7.836   110.596     0.150
     9.262   130.316     0.150
    13.510   185.566     0.150
    18.961   263.803     0.150
    20.649   521.646     0.150
    20.940  2316.641     0.150
    21.026   285.043     0.150
    22.471   299.023     0.150
    23.310   306.627     0.150
    26.463    14.900     0.150
    28.016   343.965     0.150
    28.016   344.137     0.150
    30.245   367.906     0.150
    30.245    14.029     0.150
    30.348   562.596     0.150
    31.916  2270.447     0.150
    31.932   382.666     0.150
    31.932   550.277     0.150
    32.363   388.736     0.150
    32.363    13.340     0.150
    33.474   391.605     0.150
    34.058   400.887     0.150
    34.058    12.660     0.150
    34.058   555.697     0.150
    36.624   498.846     0.150
    36.624   418.107     0.150
    37.509   430.117     0.150
    38.343   573.447     0.150
    38.316   448.547     0.150
    38.316   435.246     0.150
    38.316   448.547     0.150
    38.517   427.947     0.150
    38.517   981.947     0.150
    38.957   442.746     0.150
    38.957    13.990     0.150
    38.957   571.297     0.150
    39.203   444.947     0.150
    39.203   587.492     0.150
    39.203   444.676     0.150
    40.030   451.066     0.150
    42.136   594.646     0.150
    42.136  1071.646     0.150
    42.690   469.846     0.150
    43.771   493.947     0.150
    43.771   480.646     0.150
    43.771   493.947     0.150
    43.867   480.047     0.150
    44.439   485.646     0.150
    45.239   491.256     0.150
    45.239   590.936     0.150
    45.869   607.422     0.150
    46.523   502.176     0.150
    46.523   594.857     0.150
    46.840     8.199     0.150
    47.322   508.326     0.150
    47.823   511.986     0.150
    47.823    13.621     0.150
    47.823   599.807     0.150
    48.602   515.676     0.150
    48.510   517.486     0.150
    48.510    13.340     0.150
    48.683   532.447     0.150
    48.683   518.646     0.150
    48.683   532.447     0.150
    48.779   521.037     0.150
    49.552    12.398     0.150
    49.573   536.547     0.150
    49.573   546.447     0.150
    51.261   538.346     0.150
    51.683   541.090     0.150
    52.544   547.906     0.150
    52.544    14.990     0.150
    52.571   547.656     0.150
    53.409   626.547     0.150
    53.729   555.076     0.150
    53.959   637.771     0.150
    54.088   748.346     0.150
    54.088   557.865     0.150
    55.078    14.801     0.150
    55.215   562.447     0.150
    55.396   567.637     0.150
    55.478   568.566     0.150
    55.793   644.727     0.150
    57.039   579.096     0.150
    58.689    10.699     0.150
    58.689    16.000     0.150
    60.786   624.846     0.150
    61.998   614.346     0.150
    62.489   614.766     0.150
    63.251   623.307     0.150
    63.486   638.336     0.150
    63.580   638.557     0.150
    63.737   639.607     0.150
    63.895   625.496     0.150
    64.046   627.797     0.150
    64.368   629.416     0.150
    64.368   629.086     0.150
    64.368    14.031     0.150
    64.500   644.047     0.150
    64.762   631.746     0.150
    64.718   646.227     0.150
    65.319    13.400     0.150
    65.319    18.900     0.150
    65.354    12.801     0.150
    65.354    18.600     0.150
    65.508   650.846     0.150
    65.921   654.127     0.150
    65.921   641.127     0.150
    65.921    13.020     0.150
    66.375   644.447     0.150
    66.479   642.146     0.150
    66.587   658.377     0.150
    66.794    13.801     0.150
    67.337   662.547     0.150
    68.034   665.947     0.150
    68.034   900.646     0.150
    68.034   652.426     0.150
    68.138   654.146     0.150
    68.255   669.066     0.150
    68.712   672.236     0.150
    69.025   658.646     0.150
    69.025   673.146     0.150
    69.025  1200.646     0.150
    69.021   673.756     0.150
    69.123   658.947     0.150
    69.149   675.057     0.150
    69.530   662.686     0.150
    69.530   662.686     0.150
    69.549   676.857     0.150
    70.382   667.646     0.150
    70.386   667.246     0.150
    70.407    14.699     0.150
    70.547   668.746     0.150
    70.487   682.527     0.150
    70.689   672.637     0.150
    70.837   670.746     0.150
    71.205   672.447     0.150
    71.351   673.947     0.150
    71.442   673.846     0.150
    71.800   690.246     0.150
    71.800   676.947     0.150
    71.800  1233.646     0.150
    71.800  1724.646     0.150
    72.300   680.246     0.150
    72.300    13.801     0.150
    72.517   681.277     0.150
    72.477   681.467     0.150
    72.477   681.467     0.150
    72.686   682.447     0.150
    72.797   681.922     0.150
    72.796   683.246     0.150
    72.970   684.547     0.150
    73.222   685.646     0.150
    73.283   683.947     0.150
    73.253   685.566     0.150
    73.253   685.566     0.150
    73.269   685.947     0.150
    73.312   685.947     0.150
    73.572   687.746     0.150
    73.911   689.836     0.150
    73.911   689.836     0.150
    74.007   690.547     0.150
    74.070   690.727     0.150
    74.070   690.727     0.150
    74.097   690.047     0.150
    74.356   692.047     0.150
    74.311   692.846     0.150
    74.463   691.996     0.150
    74.602   694.146     0.150
    74.822    13.400     0.150
    74.943   695.846     0.150
    74.992   695.447     0.150
    75.011   696.146     0.150
    75.328   697.447     0.150
    75.328    14.670     0.150
    75.332    15.363     0.150
    75.358    14.115     0.150
    75.402    14.018     0.150
    75.515    13.779     0.150
    75.575    14.291     0.150
    75.677    15.801     0.150
    75.677    20.900     0.150
    75.627    14.223     0.150
    75.704    14.291     0.150
    75.708    14.324     0.150
    75.731   699.066     0.150
    75.861    14.326     0.150
    76.012    13.994     0.150
    76.030    14.291     0.150
    76.144   705.736     0.150
    76.144    10.953     0.150
    76.292    14.531     0.150
    76.250   702.336     0.150
    76.493    11.980     0.150
    76.511   718.646     0.150
    76.511   703.646     0.150
    76.499    13.334     0.150
    76.551    13.744     0.150
    76.686    14.410     0.150
    76.855   706.166     0.150
    77.364   710.350     0.150
    77.364   710.176     0.150
    77.599   711.117     0.150
    77.763   710.047     0.150
    78.217   706.947     0.150
    78.217   718.146     0.150
    78.217  1293.947     0.150
    78.318   727.646     0.150
    78.500   716.066     0.150
    78.413   713.957     0.150
    78.641   715.096     0.150
    79.060   718.266     0.150
    79.060    14.131     0.150
    79.205  1827.447     0.150
    79.124   718.166     0.150
    79.131   718.047     0.150
    79.361   719.287     0.150
    79.423   719.186     0.150
    79.583   721.547     0.150
    79.779   721.836     0.150
    80.005   722.857     0.150
    80.294   725.697     0.150
    80.369   724.527     0.150
    80.560   726.646     0.150
    80.511   724.277     0.150
    80.712   726.867     0.150
    80.872   728.977     0.150
    80.872    14.400     0.150
    81.050    12.199     0.150
    81.050   729.447     0.150
    81.050    12.250     0.150
    81.014   728.938     0.150
    80.972   728.736     0.150
    81.149   728.336     0.150
    81.173   728.777     0.150
    81.173   732.457     0.150
    81.403   730.406     0.150
    81.543   729.096     0.150
    81.639   731.311     0.150
    81.639   730.826     0.150
    81.639    12.930     0.150
    81.532   730.416     0.150
    81.629   732.646     0.150
    81.654   732.057     0.150
    81.966   735.477     0.150
    82.032   734.646     0.150
    82.306   736.887     0.150
    82.264   735.557     0.150
    82.491   736.947     0.150
    82.491   737.236     0.150
    82.491   737.586     0.150
    82.617   738.787     0.150
    82.728   737.816     0.150
    82.728    14.119     0.150
    82.637   735.926     0.150
    82.861   737.086     0.150
    82.861    14.850     0.150
    82.886   738.646     0.150
    83.162   739.596     0.150
    83.435   741.457     0.150
    83.459   742.447     0.150
    83.459   742.396     0.150
    83.403   739.396     0.150
    84.077   755.146     0.150
    84.528   748.596     0.150
    86.265   756.615     0.150
    88.025   765.705     0.150
    88.507   766.674     0.150
    91.513   779.877     0.150
    93.609   783.646     0.150
    96.457   801.746     0.150
    96.370   801.447     0.150
    96.370   801.506     0.150
    98.117   810.756     0.150
    98.117   825.287     0.150
    98.453   810.756     0.150
    98.453   810.756     0.150
    98.453   810.736     0.150
   101.807   826.057     0.150
   104.101   835.787     0.150
   107.673   857.955     0.150
   111.316   870.537     0.150
   120.197  1124.176     0.150
   122.051  1127.297     0.150
   122.420  1128.617     0.150
   122.420  1127.236     0.150
   138.472  1157.607     0.150
   139.359  1159.836     0.150
   143.570  1166.227     0.150
   145.373  1172.076     0.150
   146.185  1172.766     0.150
   146.596  1169.336     0.150
   148.230  1180.346     0.150
   148.230  1179.756     0.150
   151.818  1188.221     0.150
   151.818  1188.227     0.150
   151.818  1187.586     0.150
   161.128  1190.156     0.150
   161.128  1234.986     0.150
     1.398    42.609     0.150
     1.636    41.528     0.150
     2.679    40.350     0.150
     5.075   126.489     0.150
     6.553    92.270     0.150
     6.910    96.770     0.150
     7.034    98.560     0.150
     7.294   101.649     0.150
     7.306   101.550     0.150
     7.739   108.270     0.150
     7.815   108.579     0.150
     7.926   110.619     0.150
    26.959   337.484     0.150
    13.081   186.111     0.150
     6.725    99.598     0.150
     7.313   109.238     0.150
     7.973   116.336     0.150
     8.180   119.887     0.150
     8.387   123.473     0.150
     8.679   126.254     0.150
    21.716   288.949     0.150
    54.038   564.953     0.150
     1.452    23.502     0.150
     1.917    27.092     0.150
     4.170    62.043     0.150
     1.917    31.562     0.150
     5.154   128.805     0.150
    28.950   353.305     0.150
    47.826   511.359     0.150
    52.732   548.180     0.150
    66.956    14.500     0.150
    66.956    19.500     0.150
     1.613    53.555     0.150
     5.648    80.820     0.150
     5.324   140.230     0.150
     5.418    77.910     0.150
     5.771    84.012     0.150
     5.771   149.512     0.150
     5.857   150.473     0.150
     5.876    86.852     0.150
     5.876   152.844     0.150
     5.959    88.660     0.150
     6.107    87.051     0.150
     6.997   101.980     0.150
     7.237   101.723     0.150
     7.238   102.242     0.150
     7.824   110.004     0.150
     7.933   115.562     0.150
     8.894   227.410     0.150
     9.217   132.871     0.150
     9.239   133.281     0.150
    46.913  3533.730     0.150
    46.919  3534.137     0.150
    46.931  3535.156     0.150
    48.065  3619.688     0.150
    48.079  3620.809     0.150
    48.083  3621.320     0.150
    23.203   299.383     0.150
    24.558   312.160     0.150
    26.191   326.199     0.150
     3.565    55.562     0.150
     6.458    94.910     0.150
     3.335    50.461     0.150
     9.068   126.301     0.150
     9.432   130.211     0.150
     7.280   101.795     0.150
     5.148    76.883     0.150
    45.561   489.645     0.150
    45.573   490.234     0.150
    45.716   491.812     0.150
    45.716   492.043     0.150
    55.302   563.516     0.150
    66.161   642.574     0.150
    74.323   687.156     0.150
    74.669   689.539     0.150
    74.673   689.738     0.150
    74.826   690.414     0.150
    74.995   691.527     0.150
    75.256   693.289     0.150
    75.650   694.785     0.150
     2.615    42.305     0.150
     3.281    51.176     0.150
     3.415    52.656     0.150
     5.647    81.910     0.150
     7.000    97.922     0.150
     1.746    52.090     0.150
     3.014    45.529     0.150
     5.372    77.830     0.150
     6.584    92.129     0.150
     7.364   103.180     0.150
     5.775    81.484     0.150
     5.797    85.295     0.150
     5.822    86.785     0.150
     6.813    98.375     0.150
     8.817   122.664     0.150
    13.057   182.395     0.150
     2.652    40.285     0.150
     2.937    46.484     0.150
     5.356    79.824     0.150
     5.717    86.344     0.150
     6.947   101.035     0.150
     7.555   109.703     0.150
     7.676   111.305     0.150
     8.214   118.953     0.150
     8.402   121.145     0.150
     8.632   124.113     0.150
    44.123   496.715     0.150
    56.588   580.762     0.150
     1.154    43.656     0.150
     1.187    44.486     0.150
     2.966    46.955     0.150
     3.273    50.516     0.150
     3.328    87.602     0.150
     4.625    67.826     0.150
     5.652    81.176     0.150
     6.060    87.275     0.150
     7.446   104.895     0.150
     8.060   115.246     0.150
    12.450   174.516     0.150
    13.242   192.688     0.150
     3.655    53.824     0.150
     3.752   103.113     0.150
     4.065   107.273     0.150
     4.963    71.473     0.150
     5.734    82.053     0.150
     5.799    82.764     0.150
     7.476   108.613     0.150
     8.466   122.113     0.150
    59.655   605.434     0.150
     0.083    14.258     0.150
     0.083    25.547     0.150
     2.593    39.457     0.150
     7.528   104.727     0.150
     8.665   118.066     0.150
     0.857    29.742     0.150
     1.422    25.930     0.150
     1.491    27.031     0.150
     1.607    28.812     0.150
     2.332    41.320     0.150
     2.812    46.219     0.150
     3.252    53.129     0.150
     4.411    69.762     0.150
     5.289    78.691     0.150
     7.681   115.062     0.150
     8.241   122.980     0.150
     8.618   127.250     0.150
     8.621   127.340     0.150
     8.736   214.895     0.150
    40.128   454.266     0.150
    72.277   684.785     0.150
     2.008    58.176     0.150
     2.531    71.707     0.150
    66.306   653.008     0.150
     3.362    51.953     0.150
     4.752    70.754     0.150
     1.351    21.883     0.150
     1.430    23.383     0.150
     1.710    54.203     0.150
     1.710    28.324     0.150
     3.567    55.133     0.150
     4.730    67.555     0.150
     8.054   117.922     0.150
    27.118   342.262     0.150
    62.304   621.000     0.150
    66.488   649.859     0.150
    73.023   690.500     0.150
    83.372   746.648     0.150
     0.473    10.930     0.150
     0.473    19.355     0.150
     0.473    10.957     0.150
     0.850    15.488     0.150
     0.850    27.047     0.150
     1.590    25.238     0.150
     1.590    44.188     0.150
     2.130    33.258     0.150
     2.843    42.008     0.150
     3.032    44.828     0.150
     3.640    53.957     0.150
     6.162    89.656     0.150
     7.054   175.664     0.150
     8.718   123.758     0.150
    13.514   194.664     0.150
     2.335    36.840     0.150
     3.378    50.309     0.150
     4.769    69.637     0.150
     5.017    75.379     0.150
     5.129    71.449     0.150
     5.918    86.438     0.150
     6.172    89.430     0.150
     6.399    92.098     0.150
     3.281    49.203     0.150
     6.369    92.344     0.150
     9.199   128.062     0.150
     2.070    60.512     0.150
     6.222    86.812     0.150
     6.447    90.664     0.150
     6.438    89.973     0.150
     6.720    93.441     0.150
     7.169   100.203     0.150
    13.225   190.648     0.150
    28.270   357.176     0.150
    59.272   605.500     0.150
    66.296   652.152     0.150
     0.982    31.109     0.150
     1.319    39.275     0.150
     2.797    41.690     0.150
     3.130    46.795     0.150
     1.062    34.434     0.150
     1.310    39.271     0.150
     1.892    28.355     0.150
     2.193    34.092     0.150
     2.277    36.146     0.150
     3.245    47.781     0.150
     7.977   111.633     0.150
    61.869   612.273     0.150
     0.831    14.893     0.150
     2.487    71.174     0.150
     2.688    42.484     0.150
     3.110    47.396     0.150
     3.106    86.412     0.150
     3.152    50.572     0.150
     3.407    51.256     0.150
     3.296    52.652     0.150
     4.058    60.959     0.150
     4.695    69.010     0.150
     4.847    73.924     0.150
     5.040    73.807     0.150
     4.933    75.912     0.150
     5.285    78.932     0.150
     5.228    79.303     0.150
     5.628    82.158     0.150
     5.826    84.770     0.150
     5.861    84.861     0.150
     5.913    87.480     0.150
     6.204    89.787     0.150
     7.558   107.688     0.150
     7.609   110.533     0.150
     7.998   116.822     0.150
     8.047   117.152     0.150
     8.079   117.713     0.150
     8.190   118.604     0.150
     8.824   125.051     0.150
    27.573   348.424     0.150
    30.389   370.584     0.150
    34.974   412.184     0.150
    49.231   525.609     0.150
    50.727   537.771     0.150
    65.257     4.500     0.150
    65.257     7.801     0.150
    66.157     3.699     0.150
    68.128   654.562     0.150
    68.128   654.562     0.150
    68.128   901.723     0.150
    68.128  1601.293     0.150
    70.825   677.973     0.150
    70.825   690.373     0.150
    72.634  5328.273     0.150
    73.298   691.873     0.150
    76.651   706.973     0.150
    77.159   708.969     0.150
    82.966   742.213     0.150
     0.980    16.543     0.150
     1.184    19.844     0.150
     2.178    62.254     0.150
     2.406    35.871     0.150
     2.678    40.055     0.150
     3.296    48.094     0.150
     3.296    48.137     0.150
     4.164    59.586     0.150
     4.793    68.750     0.150
     4.921    70.168     0.150
     5.982    85.090     0.150
     5.964    84.609     0.150
     6.082    87.055     0.150
     6.185    87.582     0.150
     6.720    95.828     0.150
     6.767    96.559     0.150
     7.724   109.430     0.150
     7.958   112.613     0.150
     8.919   125.586     0.150
     9.580   132.621     0.150
    13.012   183.891     0.150
    20.478   286.594     0.150
    20.478   300.691     0.150
    23.763   304.453     0.150
    23.872    13.402     0.150
    28.477   346.812     0.150
    30.493   367.762     0.150
    31.712   376.520     0.150
    31.798   377.145     0.150
    31.802   377.348     0.150
    31.805   378.520     0.150
    32.301   382.246     0.150
    32.377   382.344     0.150
    32.396   383.113     0.150
    32.766   385.965     0.150
    33.180   389.895     0.150
    33.334   390.504     0.150
    34.834   404.242     0.150
    35.152   405.887     0.150
    35.269   408.961     0.150
    35.319   407.668     0.150
    35.475   410.207     0.150
    35.674   410.652     0.150
    37.841   430.195     0.150
    38.710   436.586     0.150
    39.536   444.348     0.150
    40.052   448.707     0.150
    40.217   450.023     0.150
    42.898   472.492     0.150
    43.042   472.094     0.150
    43.543   476.992     0.150
    44.724   589.344     0.150
    45.412   491.266     0.150
    45.873   494.691     0.150
    47.201   507.934     0.150
    49.438   523.160     0.150
    49.799   528.992     0.150
    49.812   524.488     0.150
    49.904   528.961     0.150
    49.916   525.031     0.150
    50.479   529.379     0.150
    52.154   542.434     0.150
    55.489   569.691     0.150
    55.798   569.742     0.150
    62.733   619.793     0.150
    65.384   633.492     0.150
    65.384    19.801     0.150
    65.504    16.000     0.150
    67.362   648.992     0.150
    68.320   901.492     0.150
    68.320   653.582     0.150
    68.320   653.582     0.150
    68.320   653.582     0.150
    68.320   679.730     0.150
    68.320   803.402     0.150
    68.320   901.551     0.150
    68.320  1187.363     0.150
    68.320  1244.781     0.150
    68.320  1646.113     0.150
    71.011    24.000     0.150
    71.011   670.992     0.150
    71.011    24.000     0.150
    72.044   675.730     0.150
    72.032   677.992     0.150
    72.248   678.891     0.150
    72.197   678.992     0.150
    72.498   680.492     0.150
    73.219   685.293     0.150
    73.555   687.293     0.150
    73.863   689.293     0.150
    73.873   688.594     0.150
    74.092   690.594     0.150
    74.183   690.094     0.150
    74.223   690.891     0.150
    75.816   700.152     0.150
    77.114   709.793     0.150
    77.316   709.594     0.150
    77.862   713.094     0.150
    80.709   728.293     0.150
    86.053   755.703     0.150
    92.667   794.594     0.150
     0.704    13.438     0.150
     3.252    49.707     0.150
     1.393    23.117     0.150
     1.833    31.633     0.150
     1.806    58.609     0.150
     1.885    32.523     0.150
     2.070    34.969     0.150
     2.864    41.609     0.150
     3.285    49.617     0.150
     3.555    52.844     0.150
     4.231    60.930     0.150
     4.950    69.742     0.150
     4.992    71.922     0.150
     5.132    74.328     0.150
     5.574    79.938     0.150
     6.212    87.461     0.150
     6.242    89.500     0.150
     6.353    91.555     0.150
     6.398    91.742     0.150
     6.698    93.039     0.150
     6.794    97.344     0.150
     6.947    96.102     0.150
     7.269   103.609     0.150
     7.558   107.594     0.150
     7.675   109.133     0.150
     7.882   110.680     0.150
     8.347   117.289     0.150
     8.838   123.609     0.150
     8.881   124.648     0.150
     9.704   139.500     0.150
    10.296   142.320     0.150
    14.047   190.711     0.150
    14.047   190.734     0.150
    14.791   209.281     0.150
    14.951   208.852     0.150
    16.483   224.500     0.150
    18.358   247.711     0.150
    20.422   268.477     0.150
    21.169     3.203     0.150
    21.169   310.711     0.150
    21.169   280.469     0.150
    22.701   290.109     0.150
    22.701   290.117     0.150
    23.372   300.281     0.150
    23.711   303.766     0.150
    27.546   342.422     0.150
    29.740   356.609     0.150
    37.184   425.164     0.150
    40.126   451.914     0.150
    43.707   482.078     0.150
    43.906   482.414     0.150
    43.935   478.234     0.150
    53.914   558.820     0.150
    54.137   560.570     0.150
    54.538   565.312     0.150
    55.617   571.664     0.150
    56.367   577.102     0.150
    62.095   617.109     0.150
    62.265   617.531     0.150
    64.259   630.273     0.150
    64.800   634.164     0.150
    65.923   649.609     0.150
    65.923     3.102     0.150
    65.934     9.305     0.150
    65.934    13.406     0.150
    66.832   647.094     0.150
    66.932   646.812     0.150
    67.328   657.711     0.150
    68.281     3.000     0.150
    68.281   688.711     0.150
    68.281  1640.711     0.150
    70.883   671.812     0.150
    70.978   672.914     0.150
    71.008   670.812     0.150
    71.050   673.109     0.150
    71.086   672.914     0.150
    71.282   673.883     0.150
    71.282   673.812     0.150
    71.338   674.914     0.150
    71.700   676.914     0.150
    71.893   679.312     0.150
    72.226   680.711     0.150
    72.577   683.203     0.150
    72.803   684.914     0.150
    73.000   685.438     0.150
    73.085   686.711     0.150
    73.387   688.609     0.150
    73.804   690.312     0.150
    73.804   690.055     0.150
    74.070   692.539     0.150
    74.102   690.609     0.150
    74.102   690.648     0.150
    74.349   692.648     0.150
    74.396   693.852     0.150
    74.759   697.109     0.150
    75.430   701.406     0.150
    75.584   699.109     0.150
    76.121   704.000     0.150
    76.498   706.055     0.150
    76.911   708.414     0.150
    77.870   712.711     0.150
    77.886   713.812     0.150
    78.056   714.914     0.150
    78.248   715.969     0.150
    78.310   716.008     0.150
    78.545   717.211     0.150
    79.260   721.023     0.150
    81.554   733.789     0.150
    83.767   744.398     0.150
     1.186    20.803     0.150
     1.268    22.193     0.150
     1.517    24.993     0.150
     2.237    33.663     0.150
     2.779    41.913     0.150
     2.811    43.203     0.150
     3.513    52.382     0.150
     4.049    59.733     0.150
     7.625   107.193     0.150
     0.436     9.202     0.150
     0.436    15.729     0.150
     0.501    10.358     0.150
     0.501    17.612     0.150
     1.177    19.356     0.150
     1.177    33.604     0.150
     2.269    33.881     0.150
     2.406    37.793     0.150
     2.406    37.683     0.150
     2.422    37.870     0.150
     2.422    66.594     0.150
     2.609    39.596     0.150
     2.805    43.358     0.150
     2.942    44.383     0.150
     2.942    77.847     0.150
     3.070    46.504     0.150
     3.685    54.487     0.150
     3.831    56.658     0.150
     4.071    59.348     0.150
     4.286    62.276     0.150
     4.985    71.865     0.150
     5.055    73.308     0.150
     5.114    71.278     0.150
     5.392    77.656     0.150
     5.490    78.596     0.150
     5.797    83.758     0.150
     5.913    84.590     0.150
     6.142    88.432     0.150
     6.210    88.366     0.150
     6.962    99.386     0.150
     0.569    12.328     0.150
     0.730    23.953     0.150
     1.407    22.578     0.150
     1.740    28.641     0.150
     2.015    30.938     0.150
     2.101    32.875     0.150
     2.219    62.844     0.150
     2.348    36.109     0.150
     2.928    44.672     0.150
     3.064    44.602     0.150
     3.659    52.719     0.150
     3.832    56.500     0.150
     4.312    63.609     0.150
     4.790    71.398     0.150
     6.386    89.328     0.150
     6.845    94.750     0.150
     6.959    97.789     0.150
     7.035    98.781     0.150
     7.252   102.359     0.150
    13.726   194.758     0.150
    13.726   194.250     0.150
     0.463    18.973     0.150
     0.632    12.230     0.150
     0.632    21.668     0.150
     1.090    19.199     0.150
     1.352    21.879     0.150
     1.352    37.543     0.150
     1.815    29.660     0.150
     1.814    29.621     0.150
     1.810    28.570     0.150
     1.810    49.789     0.150
     2.044    32.898     0.150
     2.213    34.426     0.150
     2.281    36.273     0.150
     2.357    35.031     0.150
     2.357    36.301     0.150
     2.399    37.098     0.150
     3.023    45.922     0.150
     3.065    44.941     0.150
     3.262    47.539     0.150
     3.423    51.082     0.150
     3.761    55.191     0.150
     3.878    57.379     0.150
     4.098    60.332     0.150
     4.257    61.652     0.150
     4.344    62.320     0.150
     4.380    62.961     0.150
     4.406    64.648     0.150
     4.653    68.121     0.150
     4.793    68.641     0.150
     5.280    75.840     0.150
     5.492    78.184     0.150
     5.533    79.160     0.150
     5.538    79.352     0.150
     5.616    80.758     0.150
     5.848    83.656     0.150
     6.042    86.273     0.150
     6.082    86.711     0.150
     6.167    88.695     0.150
     6.302    90.008     0.150
     6.364    91.180     0.150
     6.361    90.648     0.150
     6.387    91.121     0.150
     6.478    91.777     0.150
     7.581   106.488     0.150
     7.634   108.930     0.150
     7.758   110.176     0.150
     7.819   109.781     0.150
     7.845   110.258     0.150
     8.435   118.320     0.150
     0.579    11.984     0.150
     1.086    18.477     0.150
     1.086    32.352     0.150
     1.308    22.578     0.150
     1.308    39.734     0.150
     1.867    51.078     0.150
     2.061    33.062     0.150
     2.061    59.156     0.150
     2.061    59.148     0.150
     2.377    36.688     0.150
     2.555    39.680     0.150
     2.568    39.406     0.150
     2.568    69.961     0.150
     2.713    41.070     0.150
     3.192    83.852     0.150
     4.097    59.398     0.150
     4.282    62.969     0.150
     4.406    62.750     0.150
     4.533    65.719     0.150
     4.576    67.102     0.150
     4.728    67.664     0.150
     4.817    68.422     0.150
     4.855    70.812     0.150
     5.169    73.828     0.150
     5.353    77.539     0.150
     5.500    78.750     0.150
     5.647    80.914     0.150
     5.737    82.703     0.150
     5.867    83.492     0.150
     5.973    85.617     0.150
     6.114    87.094     0.150
     6.218    88.578     0.150
     6.320    89.648     0.150
     6.372    90.555     0.150
     6.526    94.047     0.150
     6.560    93.609     0.150
     6.602    93.406     0.150
     6.650    93.922     0.150
     6.827    97.125     0.150
     7.262   103.734     0.150
     7.376   102.766     0.150
     7.582   106.750     0.150
     7.630   107.602     0.150
     7.705   109.391     0.150
     7.857   110.070     0.150
     8.010   113.961     0.150
     8.067   113.789     0.150
     8.146   114.609     0.150
     8.668   122.828     0.150
     8.722   121.836     0.150
     8.843   125.289     0.150
     8.874   124.734     0.150
     5.090    70.488     0.150
     5.171    72.625     0.150
     5.352    75.227     0.150
     6.138    86.059     0.150
     6.473    90.816     0.150
     6.656    97.086     0.150
     7.399   106.355     0.150
     7.977   111.168     0.150
     8.170   118.516     0.150
     8.918   127.785     0.150
     0.413     8.955     0.150
     1.175    20.016     0.150
     1.175    35.996     0.150
     1.586    26.219     0.150
     1.675    49.574     0.150
     1.675    27.373     0.150
     1.774    28.244     0.150
     2.015    32.217     0.150
     2.098    32.283     0.150
     2.098    56.725     0.150
     2.429    36.199     0.150
     2.405    36.773     0.150
     2.398    36.506     0.150
     2.993    44.914     0.150
     3.232    47.752     0.150
     3.367    49.428     0.150
     3.800    55.121     0.150
     4.071    58.928     0.150
     3.996    58.621     0.150
     4.175    60.619     0.150
     4.331    63.273     0.150
     4.445    64.658     0.150
     4.614    66.709     0.150
     5.372    77.387     0.150
     5.447    78.359     0.150
     6.992    99.609     0.150
     7.097   100.434     0.150
     8.801   122.805     0.150
     0.657    14.254     0.150
     0.946    17.676     0.150
     0.946    30.344     0.150
     0.910    17.305     0.150
     0.910    30.973     0.150
     1.500    24.754     0.150
     1.462    24.094     0.150
     1.462    41.836     0.150
     1.667    27.754     0.150
     1.666    27.723     0.150
     1.892    30.074     0.150
     2.057    33.145     0.150
     2.057    58.004     0.150
     2.173    34.945     0.150
     2.387    36.344     0.150
     2.435    37.316     0.150
     2.929    44.184     0.150
     3.164    46.375     0.150
     3.301    49.984     0.150
     3.316    49.074     0.150
     3.770    55.645     0.150
     3.864    57.293     0.150
     4.074    59.133     0.150
     4.157    61.496     0.150
     4.219    61.754     0.150
     4.273    61.965     0.150
     4.348    63.145     0.150
     4.434    64.086     0.150
     4.419    63.855     0.150
     4.440    65.496     0.150
     4.564    65.043     0.150
     4.755    68.844     0.150
     4.765    69.523     0.150
     4.962    70.934     0.150
     4.950    72.684     0.150
     4.981    72.465     0.150
     5.097    73.555     0.150
     5.320    77.375     0.150
     5.353    77.246     0.150
     5.385    77.414     0.150
     5.523    79.383     0.150
     5.533    79.395     0.150
     5.653    80.363     0.150
     5.729    82.676     0.150
     5.913    85.004     0.150
     5.973    85.223     0.150
     6.032    86.414     0.150
     6.143    88.535     0.150
     6.239    88.773     0.150
     6.229    89.273     0.150
     6.252    89.633     0.150
     6.517    93.133     0.150
     6.615    94.363     0.150
     6.844    98.195     0.150
     6.992    98.324     0.150
     7.041   100.195     0.150
     7.182   101.984     0.150
     7.222   102.676     0.150
     7.272   102.684     0.150
     7.467   105.195     0.150
     7.655   108.594     0.150
     7.764   108.836     0.150
     7.799   110.156     0.150
     7.805   110.883     0.150
     7.800   109.926     0.150
     7.856   110.945     0.150
     8.129   114.375     0.150
     0.169    16.589     0.150
     0.169    29.139     0.150
     0.318    18.719     0.150
     0.583    20.399     0.150
     0.616    20.529     0.150
     1.250    24.851     0.150
     1.509    27.094     0.150
     1.659    52.429     0.150
     1.746    29.667     0.150
     1.718    30.079     0.150
     1.914    33.059     0.150
     1.915    33.099     0.150
     2.142    35.529     0.150
     2.333    63.937     0.150
     2.442    39.555     0.150
     2.436    38.602     0.150
     2.511    67.959     0.150
     2.724    43.229     0.150
     2.952    45.667     0.150
     3.440    53.622     0.150
     3.685    55.549     0.150
     3.685    55.547     0.150
     3.774    56.725     0.150
     3.809    57.628     0.150
     3.920    58.256     0.150
     4.156    61.623     0.150
     4.419    66.304     0.150
     4.805    70.719     0.150
     4.932    71.619     0.150
     5.141    73.647     0.150
     5.274    77.209     0.150
     5.541    79.821     0.150
     5.817    82.838     0.150
     5.882    84.667     0.150
     5.880    83.474     0.150
     5.900    85.067     0.150
     5.995    85.939     0.150
     5.959    87.098     0.150
     6.085    87.943     0.150
     6.120    88.229     0.150
     6.219    89.127     0.150
     6.357    90.155     0.150
     6.449    92.067     0.150
     6.491    92.957     0.150
     6.684    95.730     0.150
     6.654    96.032     0.150
     7.252   103.604     0.150
     7.506   105.119     0.150
     7.604   107.460     0.150
     7.635   108.207     0.150
     7.642   109.046     0.150
     7.977   113.059     0.150
     7.972   111.466     0.150
     8.076   113.247     0.150
     8.329   117.618     0.150
     8.372   118.668     0.150
     8.501   118.427     0.150
     8.564   119.873     0.150
     9.777   137.367     0.150
    20.446   269.029     0.150
     0.279     7.836     0.150
     0.279    14.172     0.150
     1.376    42.211     0.150
     1.376    22.969     0.150
     1.376    40.336     0.150
     1.376    22.922     0.150
     1.489    45.195     0.150
     2.155    34.133     0.150
     2.623    71.547     0.150
     3.078    84.977     0.150
     3.078    45.953     0.150
     4.010    59.516     0.150
     4.193    60.477     0.150
     4.999   128.617     0.150
     5.104    74.297     0.150
     5.128    73.602     0.150
     5.497    78.547     0.150
     5.528    78.781     0.150
     6.189    88.719     0.150
     6.191    88.297     0.150
     6.395   162.391     0.150
     6.752    96.609     0.150
     6.945    98.781     0.150
     7.163   101.469     0.150
     7.387   104.930     0.150
     7.445   105.641     0.150
     7.445   105.711     0.150
     7.622   107.859     0.150
     8.430   118.312     0.150
     8.775   121.938     0.150
     8.824   124.039     0.150
     8.905   125.344     0.150
     8.972   125.609     0.150
     8.981   125.367     0.150
     9.443   133.500     0.150
     9.443   133.477     0.150
    10.248   143.828     0.150
    10.414   146.398     0.150
    14.895   206.719     0.150
    20.615   274.641     0.150
    20.897   303.789     0.150
    26.713   332.367     0.150
    27.309   339.391     0.150
    27.309   340.219     0.150
    28.430   349.859     0.150
    33.676   397.516     0.150
    38.068   427.531     0.150
    43.040   473.508     0.150
    43.617   480.297     0.150
    45.142   491.492     0.150
    46.447   501.195     0.150
    48.130   516.477     0.150
    53.953   558.109     0.150
    56.096   573.836     0.150
    61.941   614.586     0.150
    62.080   615.320     0.150
    62.162   612.891     0.150
    63.014   621.961     0.150
    64.257   630.078     0.150
    65.793   640.766     0.150
    65.802   640.828     0.150
    66.468   643.609     0.150
    66.468   644.008     0.150
    66.563   644.289     0.150
    68.074   902.992     0.150
    69.029   912.289     0.150
    71.740   676.289     0.150
    72.399   681.172     0.150
    72.808   682.836     0.150
    72.808   682.727     0.150
    72.924    13.398     0.150
    72.924   685.188     0.150
    73.168    12.797     0.150
    73.168   686.891     0.150
    73.225    13.094     0.150
    73.225   686.492     0.150
    73.541   687.758     0.150
    73.564   688.789     0.150
    73.948   691.086     0.150
    73.948    13.703     0.150
    74.242   692.477     0.150
    75.394   698.289     0.150
    75.938   701.992     0.150
    75.938   703.117     0.150
    76.233   703.516     0.150
    76.734   706.891     0.150
    76.841   706.812     0.150
    77.670   711.898     0.150
    77.700   711.391     0.150
    77.708   724.008     0.150
    77.883   713.289     0.150
    78.354   716.086     0.150
    79.069   711.180     0.150
    79.069   711.188     0.150
    81.284   730.938     0.150
    81.854   733.367     0.150
    83.509   742.672     0.150
    83.587   743.281     0.150
   151.812  1188.617     0.150
     0.424    14.195     0.150
     0.424    24.719     0.150
     0.603    17.469     0.150
     1.014    19.523     0.150
     1.014    33.859     0.150
     1.122    34.742     0.150
     1.122    21.008     0.150
     1.122    21.016     0.150
     1.420    24.461     0.150
     1.409    24.648     0.150
     1.632    27.477     0.150
     1.632    47.875     0.150
     1.664    28.516     0.150
     1.688    28.867     0.150
     2.093    32.984     0.150
     2.257    36.062     0.150
     2.801    43.352     0.150
     2.827    42.148     0.150
     3.344    49.805     0.150
     3.706    54.516     0.150
     3.914    56.836     0.150
     4.012    58.320     0.150
     4.680    67.344     0.150
     4.960    72.773     0.150
     5.032    72.469     0.150
     5.092    73.188     0.150
     5.231    75.820     0.150
     5.289    76.156     0.150
     5.636    80.805     0.150
     6.102    86.852     0.150
     6.775    96.062     0.150
     6.890    98.953     0.150
     6.964    98.188     0.150
     7.278   102.664     0.150
     7.488   106.594     0.150
     0.579    12.098     0.150
     0.824    15.283     0.150
     0.824    27.211     0.150
     1.213    20.340     0.150
     1.213    35.449     0.150
     1.351    23.434     0.150
     1.652    26.564     0.150
     1.730    28.428     0.150
     1.752    27.693     0.150
     2.017    31.555     0.150
     2.354    35.164     0.150
     2.659    40.646     0.150
     3.079    45.717     0.150
     3.682    53.543     0.150
     3.736    53.744     0.150
     4.010    59.057     0.150
     4.091    59.150     0.150
     4.568    66.141     0.150
     4.787    68.627     0.150
     4.909    71.121     0.150
     4.900    71.076     0.150
     5.136    73.832     0.150
     5.224    75.928     0.150
     5.458    78.412     0.150
     5.665    81.723     0.150
     6.933    99.305     0.150
     7.142   101.434     0.150
     0.762    25.434     0.150
     1.332    22.855     0.150
     1.332    40.348     0.150
     1.424    23.605     0.150
     1.415    23.887     0.150
     1.415    42.789     0.150
     1.515    24.992     0.150
     1.680    27.613     0.150
     1.932    31.148     0.150
     1.932    55.371     0.150
     2.048    32.816     0.150
     2.126    32.473     0.150
     2.272    35.328     0.150
     2.443    37.562     0.150
     2.530    39.402     0.150
     2.978    44.605     0.150
     2.997    45.332     0.150
     3.064    45.176     0.150
     3.446    50.438     0.150
     3.515    51.590     0.150
     3.551    51.988     0.150
     3.577    52.734     0.150
     3.719    54.523     0.150
     3.742    55.438     0.150
     3.897    57.191     0.150
     4.284    62.578     0.150
     4.292    63.172     0.150
     4.420    64.113     0.150
     4.680    68.613     0.150
     4.818    69.738     0.150
     5.213    75.285     0.150
     5.253    73.977     0.150
     5.280    75.980     0.150
     5.635    81.277     0.150
     5.875    84.000     0.150
     6.548    92.805     0.150
     6.813    96.902     0.150
     6.993    99.648     0.150
     7.016    99.531     0.150
     7.322   103.113     0.150
     7.809   109.992     0.150
     8.777   121.406     0.150
     0.453    10.141     0.150
     0.453    16.594     0.150
     1.708    50.691     0.150
     2.836    44.148     0.150
     2.916    44.996     0.150
     3.236    50.348     0.150
     3.265    50.301     0.150
     3.334    52.016     0.150
     3.482    52.879     0.150
     3.885    57.527     0.150
     4.061    61.832     0.150
     4.107    62.430     0.150
     4.145    61.812     0.150
     4.691    69.488     0.150
     5.204    76.672     0.150
     5.204    76.668     0.150
     5.262    77.109     0.150
     5.271    77.160     0.150
     5.435    79.469     0.150
     5.491    79.930     0.150
     5.491    79.930     0.150
     5.735    83.477     0.150
     6.042    87.719     0.150
     6.136    89.000     0.150
     6.563    94.824     0.150
     6.736    96.242     0.150
     6.859    98.684     0.150
     6.971    99.020     0.150
     7.444   107.750     0.150
     8.125   116.789     0.150
     9.248   133.859     0.150
     1.276    26.062     0.150
     1.649    29.086     0.150
     1.649    29.172     0.150
     1.694    30.469     0.150
     1.738    30.258     0.150
     2.036    35.336     0.150
     2.565    42.258     0.150
     2.639    72.148     0.150
     2.839    43.883     0.150
     3.079    44.547     0.150
     3.364    51.984     0.150
     3.364    51.844     0.150
     3.770    56.469     0.150
     4.202    61.773     0.150
     4.591    69.570     0.150
     5.100    74.758     0.150
     5.142    73.953     0.150
     5.474    77.906     0.150
     5.746    82.383     0.150
     6.311    89.891     0.150
     7.077    99.328     0.150
     8.058   111.719     0.150
     8.255   117.227     0.150
     9.934   138.273     0.150
    10.331   148.297     0.150
    10.408   143.875     0.150
    10.967   156.102     0.150
    11.562   162.469     0.150
    26.492   325.984     0.150
     0.782    13.727     0.150
     1.968    30.773     0.150
     3.284    49.906     0.150
     3.801    56.977     0.150
     4.020    58.773     0.150
     4.732    66.883     0.150
     5.610    81.125     0.150
     5.660    80.609     0.150
     7.632   110.070     0.150
     8.776   122.305     0.150
    55.745   570.570     0.150
     1.176    37.203     0.150
     1.176    21.492     0.150
     1.176    36.883     0.150
     1.607    26.801     0.150
     1.682    29.125     0.150
     2.205    35.965     0.150
     2.388    36.402     0.150
     2.588    39.863     0.150
     2.680    42.062     0.150
     2.760    41.875     0.150
     3.321    49.422     0.150
     3.307    50.273     0.150
     3.255    49.516     0.150
     3.443    51.516     0.150
     3.827    57.715     0.150
     3.865    56.953     0.150
     4.053    60.488     0.150
     4.213    61.402     0.150
     2.556    44.514     0.150
     2.458    39.912     0.150
     3.120    48.793     0.150
     3.162    46.924     0.150
     3.614    54.254     0.150
     3.668    60.504     0.150
     3.696    51.713     0.150
     3.818    58.863     0.150
     4.005    60.902     0.150
     4.329    61.523     0.150
     4.843    68.293     0.150
     4.775    76.072     0.150
     5.377    76.482     0.150
     5.297    82.594     0.150
     5.371    79.822     0.150
     5.736    88.203     0.150
     5.768    89.844     0.150
     6.168    90.492     0.150
     6.533   100.094     0.150
     6.584    99.072     0.150
     6.595    97.623     0.150
     6.940   102.113     0.150
     6.928   102.123     0.150
     7.039   103.053     0.150
     7.037   104.082     0.150
     7.063   102.764     0.150
     7.559   114.293     0.150
     7.928   116.082     0.150
     7.927   115.273     0.150
     0.772    15.208     0.150
     1.041    18.918     0.150
     1.085    19.097     0.150
     1.381    41.664     0.150
     1.810    28.695     0.150
     1.810    50.490     0.150
     1.913    51.728     0.150
     2.137    34.338     0.150
     2.136    33.148     0.150
     2.136    59.861     0.150
     2.263    61.654     0.150
     2.558    38.758     0.150
     2.647    41.063     0.150
     2.888    43.417     0.150
     3.076    46.409     0.150
     3.144    47.139     0.150
     3.195    48.438     0.150
     3.612    52.376     0.150
     4.024    58.488     0.150
     4.242    61.869     0.150
     4.290    63.338     0.150
     4.572    67.613     0.150
     4.695    68.458     0.150
     4.821    69.028     0.150
     4.877    71.398     0.150
     4.886    69.876     0.150
     5.007    71.176     0.150
     5.226    74.569     0.150
     5.379    76.716     0.150
     5.373    77.515     0.150
     5.752    83.389     0.150
     5.833    83.176     0.150
     5.999    85.270     0.150
     6.007    85.356     0.150
     6.075    86.336     0.150
     6.142    87.855     0.150
     6.200    88.376     0.150
     6.412    91.238     0.150
     6.507    92.776     0.150
     6.698    95.784     0.150
     6.704    95.256     0.150
     6.716    95.477     0.150
     6.947    98.629     0.150
     6.985    98.816     0.150
     7.487   106.113     0.150
     8.098   114.539     0.150
     8.175   114.836     0.150
     0.723    12.000     0.150
     0.581    12.180     0.150
     0.581    23.562     0.150
     0.921    31.352     0.150
     1.271    18.531     0.150
     1.271    33.227     0.150
     1.271    18.531     0.150
     1.271    33.227     0.150
     1.188    20.680     0.150
     1.450    24.156     0.150
     1.497    23.172     0.150
     1.497    23.164     0.150
     1.618    26.727     0.150
     1.703    48.672     0.150
     1.703    27.336     0.150
     1.703    48.672     0.150
     1.806    27.859     0.150
     1.806    27.852     0.150
     1.861    29.156     0.150
     2.426    36.633     0.150
     2.473    39.539     0.150
     2.470    37.625     0.150
     2.669    39.781     0.150
     2.946    43.430     0.150
     3.083    46.031     0.150
     3.513    52.430     0.150
     3.665    53.438     0.150
     3.712    54.156     0.150
     3.823    54.859     0.150
     3.836    56.516     0.150
     4.061    59.047     0.150
     4.042    59.602     0.150
     4.648    67.375     0.150
     4.714    68.227     0.150
     4.854    70.055     0.150
     4.873    70.273     0.150
     4.927    71.625     0.150
     5.157    74.547     0.150
     5.361    77.312     0.150
     5.434    78.617     0.150
     5.515    79.430     0.150
     5.722    82.172     0.150
     5.749    82.406     0.150
     5.811    83.336     0.150
     6.410    90.445     0.150
     6.743    96.000     0.150
     0.615    13.643     0.150
     1.131    19.732     0.150
     1.217    21.070     0.150
     1.217    35.777     0.150
     1.508    24.463     0.150
     1.508    24.486     0.150
     1.508    42.121     0.150
     1.601    25.912     0.150
     1.601    26.316     0.150
     1.697    27.293     0.150
     1.697    47.482     0.150
     1.697    27.301     0.150
     1.697    47.988     0.150
     1.947    27.072     0.150
     2.167    34.082     0.150
     2.167    34.195     0.150
     2.483    37.062     0.150
     2.483    38.168     0.150
     2.855    73.275     0.150
     3.082    46.410     0.150
     3.162    46.352     0.150
     3.154    47.893     0.150
     3.188    81.186     0.150
     3.194    46.793     0.150
     3.536    51.611     0.150
     3.650    54.982     0.150
     3.670    54.209     0.150
     3.775    54.748     0.150
     3.760    56.373     0.150
     3.885    56.582     0.150
     4.004    59.707     0.150
     4.351    63.533     0.150
     4.392    64.293     0.150
     4.392    64.330     0.150
     4.465    65.219     0.150
     4.530    65.975     0.150
     4.839    69.812     0.150
     5.021    72.924     0.150
     5.129    74.512     0.150
     5.310    76.402     0.150
     5.310    76.383     0.150
     5.328    76.229     0.150
     5.927    84.037     0.150
     6.220    89.447     0.150
     6.248    89.439     0.150
     6.367    90.268     0.150
     6.369    90.172     0.150
     6.612    94.709     0.150
     6.636    94.342     0.150
     6.694    95.512     0.150
     6.736    95.576     0.150
     7.599   109.092     0.150
     8.339   118.682     0.150
     9.288   130.430     0.150
    12.572   174.436     0.150
    15.392   213.633     0.150
    18.679   451.373     0.150
    19.625   261.973     0.150
    22.311   293.143     0.150
    23.243   302.572     0.150
    26.098   327.053     0.150
    28.293   346.941     0.150
    28.293     7.590     0.150
    29.382   357.021     0.150
    31.690   380.625     0.150
    32.980   388.463     0.150
    32.979   388.242     0.150
    33.467   392.781     0.150
    36.362    11.400     0.150
    36.667   419.361     0.150
    36.792   421.941     0.150
    37.186   425.393     0.150
    38.413   435.572     0.150
    38.413     9.160     0.150
    38.470   435.902     0.150
    39.099   439.572     0.150
    39.917   446.941     0.150
    40.719   453.672     0.150
    40.740   454.002     0.150
    41.299   457.742     0.150
    41.912     6.559     0.150
    42.095   465.812     0.150
    42.095   465.842     0.150
    42.095     7.570     0.150
    43.671   479.031     0.150
    43.781     8.801     0.150
    43.937   480.512     0.150
    45.001   487.762     0.150
    45.318   492.822     0.150
    48.528   517.254     0.150
    48.731   518.902     0.150
    49.138   520.691     0.150
    49.137   520.402     0.150
    51.632    20.000     0.150
    51.731   539.893     0.150
    51.846   540.143     0.150
    51.846   540.133     0.150
    53.392   551.742     0.150
    53.392     9.670     0.150
    54.325   559.723     0.150
    54.815   563.082     0.150
    55.663   569.072     0.150
    59.713   596.543     0.150
    59.806   598.053     0.150
    60.209   598.842     0.150
    60.945   611.682     0.150
    60.945    11.061     0.150
    63.092   619.232     0.150
    63.092    11.150     0.150
    63.162   619.623     0.150
    65.286    10.500     0.150
    65.286    14.500     0.150
    65.462   634.643     0.150
    65.462   634.502     0.150
    65.550   640.902     0.150
    65.689    14.000     0.150
    65.689   903.543     0.150
    65.689   636.332     0.150
    65.689     7.730     0.150
    65.902   638.482     0.150
    66.247   646.742     0.150
    66.314    13.500     0.150
    66.314    21.000     0.150
    66.945    19.301     0.150
    66.945   889.342     0.150
    66.945   645.473     0.150
    66.945   645.473     0.150
    66.945   645.473     0.150
    66.945    14.520     0.150
    66.945    19.279     0.150
    66.945   793.043     0.150
    66.945   889.342     0.150
    66.945  1175.012     0.150
    66.945  1195.752     0.150
    66.945  1469.883     0.150
    66.945  1659.422     0.150
    67.379   647.053     0.150
    69.507   661.432     0.150
    69.507   659.742     0.150
    70.018   664.543     0.150
    70.036   665.268     0.150
    70.411   667.543     0.150
    70.522   668.342     0.150
    70.539   668.342     0.150
    70.717   669.543     0.150
    70.742   668.203     0.150
    70.742   667.803     0.150
    70.945   670.441     0.150
    71.022   671.143     0.150
    71.049   670.463     0.150
    71.260   671.973     0.150
    71.312   672.133     0.150
    71.343   673.143     0.150
    71.368   672.742     0.150
    71.458   673.133     0.150
    71.610   673.932     0.150
    71.610   674.133     0.150
    72.100   678.143     0.150
    72.434   680.043     0.150
    72.436   679.543     0.150
    72.619   681.043     0.150
    72.722   681.242     0.150
    72.737   685.643     0.150
    72.749   681.842     0.150
    72.814   682.043     0.150
    72.914   682.441     0.150
    73.307   686.549     0.150
    74.203   691.285     0.150
    74.532   689.742     0.150
    74.589   692.043     0.150
    74.977   695.482     0.150
    75.956   700.191     0.150
    75.976   702.842     0.150
    75.998   700.043     0.150
    76.952   707.941     0.150
    77.133   875.143     0.150
    77.220   721.213     0.150
    77.800   713.441     0.150
    77.808   712.842     0.150
    78.010   717.912     0.150
    78.799   715.232     0.150
    81.486   729.912     0.150
    81.596   730.492     0.150
    84.501   745.242     0.150
    88.971   783.822     0.150
    95.684   814.281     0.150
    95.819   813.992     0.150
    97.215   803.918     0.150
    98.540   810.941     0.150
     0.469    14.773     0.150
     0.469    25.844     0.150
     1.035    19.812     0.150
     1.035    34.742     0.150
     1.214    22.812     0.150
     1.214    40.234     0.150
     1.215    22.844     0.150
     1.388    23.680     0.150
     1.388    41.492     0.150
     1.438    25.164     0.150
     1.438    43.766     0.150
     1.671    27.984     0.150
     1.707    51.188     0.150
     1.734    29.383     0.150
     1.734    51.328     0.150
     1.978    31.523     0.150
     1.978    54.492     0.150
     2.134    33.664     0.150
     2.295    36.188     0.150
     2.334    36.688     0.150
     2.837    42.398     0.150
     2.846    43.898     0.150
     2.868    43.539     0.150
     2.975    45.406     0.150
     3.389    50.680     0.150
     3.385    50.859     0.150
     3.397    51.562     0.150
     3.679    54.984     0.150
     3.962    58.859     0.150
     4.056    58.820     0.150
     4.123    60.500     0.150
     4.268    61.141     0.150
     4.328    63.305     0.150
     4.377    63.484     0.150
     4.481    66.023     0.150
     4.718    68.016     0.150
     4.739    68.508     0.150
     4.842    70.938     0.150
     5.074    72.930     0.150
     5.106    73.422     0.150
     5.138    73.820     0.150
     5.178    75.078     0.150
     5.276    76.305     0.150
     5.333    76.820     0.150
     5.398    77.383     0.150
     5.628    80.625     0.150
     5.678    81.367     0.150
     5.788    83.141     0.150
     5.895    84.391     0.150
     6.147    88.227     0.150
     6.728    95.812     0.150
     6.886    98.062     0.150
     7.669   108.570     0.150
     1.640    27.336     0.150
     2.052    33.688     0.150
     4.667    65.961     0.150
     5.898    86.289     0.150
     6.307    88.617     0.150
     6.368    86.961     0.150
     7.336   101.859     0.150
     7.500   107.766     0.150
     0.570    12.227     0.150
     0.570    21.469     0.150
     0.708    13.992     0.150
     1.088    18.758     0.150
     1.362    23.297     0.150
     1.545    46.422     0.150
     1.583    25.148     0.150
     1.801    29.195     0.150
     1.801    51.852     0.150
     1.851    28.867     0.150
     1.867    29.484     0.150
     1.922    30.117     0.150
     1.990    31.273     0.150
     2.014    31.641     0.150
     2.568    38.898     0.150
     2.629    40.125     0.150
     2.692    41.320     0.150
     2.926    44.172     0.150
     3.191    45.453     0.150
     3.656    54.398     0.150
     3.770    55.477     0.150
     3.884    56.586     0.150
     4.000    58.906     0.150
     4.215    62.094     0.150
     4.554    66.180     0.150
     4.805    70.180     0.150
     5.032    72.602     0.150
     5.924    84.844     0.150
     0.638    13.070     0.150
     0.638    22.752     0.150
     1.096    19.954     0.150
     1.105    19.704     0.150
     1.320    21.498     0.150
     1.512    24.754     0.150
     1.512    43.665     0.150
     1.780    28.337     0.150
     1.780    49.285     0.150
     1.825    28.879     0.150
     1.825    51.051     0.150
     2.022    31.804     0.150
     2.022    56.051     0.150
     2.091    33.382     0.150
     2.091    58.062     0.150
     2.191    34.166     0.150
     2.307    34.135     0.150
     2.307    36.182     0.150
     2.414    37.242     0.150
     2.605    39.624     0.150
     2.663    40.354     0.150
     2.935    44.079     0.150
     3.021    45.779     0.150
     3.086    46.379     0.150
     3.126    45.922     0.150
     3.196    48.600     0.150
     3.755    55.854     0.150
     3.810    55.874     0.150
     3.915    57.659     0.150
     4.066    59.778     0.150
     4.100    60.110     0.150
     4.109    59.109     0.150
     4.285    62.487     0.150
     4.392    63.166     0.150
     4.405    64.429     0.150
     4.434    63.902     0.150
     4.513    64.521     0.150
     4.660    67.563     0.150
     4.786    68.942     0.150
     4.864    70.242     0.150
     4.950    71.468     0.150
     5.103    73.462     0.150
     5.125    74.480     0.150
     5.249    75.813     0.150
     5.344    76.722     0.150
     5.544    79.690     0.150
     5.562    79.654     0.150
     5.581    79.722     0.150
     5.651    80.738     0.150
     5.674    81.583     0.150
     5.863    84.302     0.150
     5.914    84.879     0.150
     6.368    91.278     0.150
     6.457    92.272     0.150
     6.532    93.027     0.150
     7.097   101.659     0.150
     7.347   103.426     0.150
     7.400   104.014     0.150
     7.400   104.015     0.150
     7.609   106.743     0.150
     7.609   107.242     0.150
     7.730   108.578     0.150
     7.858   110.244     0.150
     7.865   110.726     0.150
     8.241   115.278     0.150
     8.289   115.413     0.150
     8.370   116.834     0.150
     8.370   116.835     0.150
     0.564    12.195     0.150
     0.564    21.336     0.150
     0.823    14.414     0.150
     0.823    25.215     0.150
     1.214    20.648     0.150
     1.220    20.676     0.150
     1.220    36.094     0.150
     1.846    29.246     0.150
     2.470    38.137     0.150
     2.677    40.496     0.150
     2.791    41.895     0.150
     2.852    42.629     0.150
     3.224    47.035     0.150
     3.225    49.027     0.150
     3.255    47.973     0.150
     3.329    48.828     0.150
     3.365    49.477     0.150
     3.737    56.152     0.150
     3.945    57.121     0.150
     3.923    57.656     0.150
     4.100    61.027     0.150
     4.233    62.543     0.150
     4.507    67.508     0.150
     4.630    66.516     0.150
     5.312    76.414     0.150
     5.328    78.086     0.150
     5.384    77.430     0.150
     5.561    79.266     0.150
     6.009    84.770     0.150
     6.612    94.047     0.150
     6.843    97.105     0.150
     7.025    99.398     0.150
     1.044    18.648     0.150
     1.272    21.656     0.150
     1.272    37.980     0.150
     1.343    22.566     0.150
     1.502    24.621     0.150
     1.502    43.328     0.150
     1.558    25.316     0.150
     1.558    44.387     0.150
     1.590    26.125     0.150
     2.017    31.773     0.150
     2.258    34.875     0.150
     2.364    36.547     0.150
     2.439    37.324     0.150
     2.501    38.348     0.150
     2.510    39.422     0.150
     2.852    42.945     0.150
     2.888    43.641     0.150
     2.975    45.402     0.150
     3.321    49.836     0.150
     3.584    53.441     0.150
     3.584    53.133     0.150
     3.721    58.734     0.150
     4.005    59.094     0.150
     4.070    60.055     0.150
     4.343    63.863     0.150
     4.408    63.770     0.150
     4.486    64.852     0.150
     4.665    68.648     0.150
     4.703    67.422     0.150
     4.816    70.262     0.150
     5.128    74.223     0.150
     5.284    76.773     0.150
     5.497    79.020     0.150
     5.746    82.711     0.150
     5.803    83.281     0.150
     5.911    84.449     0.150
     6.355    90.809     0.150
     6.395    91.031     0.150
     6.988    99.637     0.150
     7.308   102.820     0.150
     7.477   105.586     0.150
     7.598   107.500     0.150
     7.770   109.457     0.150
     7.884   110.684     0.150
     8.092   114.371     0.150
     8.096   113.969     0.150
     9.425   131.754     0.150
     9.645   134.984     0.150
    10.410   143.984     0.150
    10.410   143.473     0.150
    31.917   378.117     0.150
     2.302    65.781     0.150
     3.494    47.164     0.150
     0.877    16.266     0.150
     0.877    28.766     0.150
     0.911    16.973     0.150
     1.233    36.156     0.150
     1.253    21.625     0.150
     1.253    38.652     0.150
     2.043    30.961     0.150
     2.043    54.742     0.150
     2.007    32.348     0.150
     2.006    32.121     0.150
     2.423    37.418     0.150
     2.432    37.473     0.150
     2.577    38.781     0.150
     2.521    39.547     0.150
     2.800    42.137     0.150
     4.135    59.250     0.150
     4.439    63.137     0.150
     4.577    65.180     0.150
     4.733    69.266     0.150
     4.926    69.758     0.150
     5.103    71.367     0.150
     5.121    73.387     0.150
     5.315    74.668     0.150
     5.749    81.906     0.150
     5.882    84.035     0.150
     5.897    83.996     0.150
     6.008    86.387     0.150
     6.334    90.090     0.150
     6.883    97.797     0.150
     7.823   112.090     0.150
     8.161   114.430     0.150
     8.868   124.855     0.150
     0.825    26.094     0.150
     1.315    41.969     0.150
     1.315    22.969     0.150
     1.315    41.961     0.150
     1.344    23.961     0.150
     1.492    23.953     0.150
     1.438    24.805     0.150
     1.631    27.984     0.150
     1.631    27.797     0.150
     1.870    31.273     0.150
     1.914    31.633     0.150
     2.317    60.766     0.150
     2.253    35.570     0.150
     2.331    36.359     0.150
     2.456    39.578     0.150
     2.488    39.133     0.150
     2.854    72.578     0.150
     2.902    44.398     0.150
     2.945    45.422     0.150
     3.375    49.984     0.150
     3.284    49.773     0.150
     3.439    51.422     0.150
     3.474    60.828     0.150
     3.501    61.297     0.150
     3.678    64.133     0.150
     3.672    55.461     0.150
     3.821    57.242     0.150
     3.888    58.602     0.150
     4.010    61.625     0.150
     4.134    64.352     0.150
     4.213    62.680     0.150
     4.356    64.086     0.150
     4.232    63.289     0.150
     4.459    66.656     0.150
     4.607    68.336     0.150
     4.604    75.719     0.150
     4.750    69.461     0.150
     5.164    76.062     0.150
     5.214    79.453     0.150
     5.502    81.617     0.150
     6.019    91.047     0.150
     6.301    95.156     0.150
     6.426    96.016     0.150
     6.575    98.656     0.150
     6.940    99.461     0.150
     7.389   108.047     0.150
     0.758    26.445     0.150
     0.758    26.441     0.150
     0.851    16.215     0.150
     0.867    16.285     0.150
     0.867    28.250     0.150
     0.930    17.508     0.150
     1.365    23.035     0.150
     1.464    24.012     0.150
     1.464    41.961     0.150
     1.539    24.934     0.150
     1.539    43.410     0.150
     1.581    25.660     0.150
     1.684    27.957     0.150
     1.684    27.992     0.150
     1.767    28.457     0.150
     1.767    49.727     0.150
     1.960    30.832     0.150
     1.960    53.758     0.150
     2.182    34.984     0.150
     2.197    34.309     0.150
     2.359    36.508     0.150
     2.399    36.672     0.150
     2.409    36.883     0.150
     2.682    40.785     0.150
     2.822    43.160     0.150
     2.856    43.285     0.150
     3.124    45.672     0.150
     3.286    48.684     0.150
     3.500    52.535     0.150
     3.752    55.285     0.150
     3.819    56.547     0.150
     3.909    57.832     0.150
     3.920    56.973     0.150
     4.039    58.391     0.150
     4.158    60.906     0.150
     4.202    60.754     0.150
     4.207    62.008     0.150
     4.214    62.082     0.150
     4.332    62.445     0.150
     4.395    63.230     0.150
     4.480    65.984     0.150
     4.522    64.191     0.150
     4.908    70.250     0.150
     4.912    70.809     0.150
     5.286    76.160     0.150
     5.362    77.691     0.150
     5.517    79.117     0.150
     5.519    78.812     0.150
     5.601    79.672     0.150
     5.741    82.203     0.150
     6.207    89.246     0.150
     6.234    89.277     0.150
     6.546    93.371     0.150
     7.034   101.109     0.150
     7.252   104.105     0.150
     7.540   107.383     0.150
     7.723   108.773     0.150
     7.750   110.625     0.150
     7.792   109.473     0.150
     8.218   116.684     0.150
     8.558   120.707     0.150
     8.877   125.859     0.150
     8.993   127.188     0.150
     9.506   133.641     0.150
     0.563    11.021     0.150
     1.472    22.761     0.150
     1.472    39.484     0.150
     2.135    34.039     0.150
     3.185    49.040     0.150
     3.290    50.152     0.150
     3.575    54.597     0.150
     3.677    55.001     0.150
     3.701    57.404     0.150
     3.959    58.985     0.150
     4.077    60.702     0.150
     5.040    72.861     0.150
     5.141    75.168     0.150
     5.506    79.625     0.150
     5.593    81.433     0.150
     5.660    83.189     0.150
     6.104    89.719     0.150
     6.228    90.786     0.150
     6.405    92.689     0.150
     6.758    98.292     0.150
     7.220   104.682     0.150
     7.657   110.491     0.150
     8.040   112.722     0.150
     8.123   113.682     0.150
     8.303   120.802     0.150
     8.464   120.321     0.150
     9.633   137.469     0.150
    12.371   922.449     0.150
    14.927   210.191     0.150
    23.274   305.825     0.150
    30.704   372.008     0.150
    31.419   379.250     0.150
    31.476   379.680     0.150
    31.478   379.948     0.150
    31.835   381.430     0.150
    37.088   428.249     0.150
    41.167   460.850     0.150
    41.443   462.631     0.150
    43.934   589.056     0.150
    44.896   491.763     0.150
    45.476   496.487     0.150
    47.099  3546.968     0.150
    47.105  3547.531     0.150
    47.117  3546.968     0.150
    47.560   512.958     0.150
    47.661   513.399     0.150
    48.254  3630.489     0.150
    48.267  3629.357     0.150
    48.272  3627.657     0.150
    48.931  3681.722     0.150
    50.810   537.259     0.150
    55.295     7.100     0.150
    55.295    11.500     0.150
    56.863   582.972     0.150
    66.427     7.500     0.150
    66.432   647.922     0.150
    66.432     6.200     0.150
    66.432    11.399     0.150
    69.454   664.212     0.150
    69.454   664.212     0.150
    69.454   917.521     0.150
    69.454  1676.172     0.150
    74.970  2099.521     0.150
    77.509   713.781     0.150
    78.101   723.312     0.150
    80.802   732.912     0.150
   109.264  8214.464     0.150
   109.275  8220.843     0.150
   109.281  8215.229     0.150
     0.821    15.897     0.150
     0.821    31.211     0.150
     1.461    22.189     0.150
     1.461    22.306     0.150
     1.427    51.198     0.150
     1.427    24.643     0.150
     1.427    42.677     0.150
     2.125    33.539     0.150
     2.542    40.833     0.150
     2.934    44.230     0.150
     3.258    50.819     0.150
     3.669    54.460     0.150
     4.485    66.088     0.150
     4.509    67.104     0.150
     5.039    73.550     0.150
     5.147    74.618     0.150
     5.662    82.699     0.150
     6.103    89.061     0.150
     6.867    98.974     0.150
     7.222   104.185     0.150
     8.028   112.094     0.150
     8.607   123.130     0.150
     8.741   124.469     0.150
     9.619   136.154     0.150
     9.872   139.483     0.150
    12.950   183.879     0.150
    43.745   483.430     0.150
    45.523   497.560     0.150
    47.089  3535.552     0.150
    47.094  3533.677     0.150
    47.107  3535.165     0.150
    48.244  3619.128     0.150
    48.257  3616.871     0.150
    48.261  3617.561     0.150
    48.942  3682.300     0.150
    53.949   560.880     0.150
    55.284    10.101     0.150
    55.284  1016.529     0.150
    61.083   612.229     0.150
    62.259   620.330     0.150
    62.492   621.130     0.150
    62.861   619.330     0.150
    69.454   665.140     0.150
    69.454   665.140     0.150
    69.454   921.060     0.150
    69.454  1676.359     0.150
    71.299   673.430     0.150
    71.299     3.000     0.150
    71.299     4.300     0.150
    75.823   714.965     0.150
    78.474   717.447     0.150
    78.584   723.984     0.150
    79.115   720.399     0.150
   109.275  8211.459     0.150
   109.286  8214.811     0.150
   109.292  8214.314     0.150
     0.565    15.572     0.150
     1.071    20.436     0.150
     1.150    21.202     0.150
     1.150    36.695     0.150
     1.438    25.295     0.150
     1.588    26.501     0.150
     1.685    27.677     0.150
     1.688    28.857     0.150
     1.761    28.202     0.150
     1.993    32.139     0.150
     2.096    33.410     0.150
     2.080    33.396     0.150
     2.211    35.715     0.150
     2.335    36.540     0.150
     2.582    39.788     0.150
     2.644    40.602     0.150
     2.696    41.815     0.150
     3.179    48.075     0.150
     3.874    57.699     0.150
     4.209    61.224     0.150
     4.803    69.560     0.150
     5.617    79.931     0.150
     5.744    81.848     0.150
     5.802    83.025     0.150
     6.127    87.462     0.150
     6.363    91.247     0.150
     7.010    97.718     0.150
     7.186   102.025     0.150
     7.618   104.872     0.150
     7.982   113.585     0.150
     8.025   113.188     0.150
     0.961    18.422     0.150
     1.091    18.375     0.150
     1.157    20.266     0.150
     1.455    24.238     0.150
     1.519    25.801     0.150
     1.549    25.758     0.150
     1.555    25.977     0.150
     1.555    25.926     0.150
     1.765    30.047     0.150
     1.765    29.918     0.150
     2.076    33.680     0.150
     2.645    41.711     0.150
     2.720    42.840     0.150
     3.108    48.238     0.150
     3.228    49.293     0.150
     3.267    50.961     0.150
     3.605    56.613     0.150
     3.813    58.363     0.150
     4.089    62.344     0.150
     4.166    62.777     0.150
     5.255    78.562     0.150
     5.447    81.039     0.150
     5.453    80.129     0.150
     5.782    85.988     0.150
     6.515    95.395     0.150
     6.867   100.383     0.150
     8.886   127.133     0.150
     9.397   133.117     0.150
     0.553    15.391     0.150
     1.010    17.869     0.150
     2.717    41.260     0.150
     2.904    45.613     0.150
     2.934    43.098     0.150
     3.551    52.549     0.150
     3.616    53.977     0.150
     3.958    58.086     0.150
     4.035    59.660     0.150
     4.334    61.717     0.150
     4.535    65.420     0.150
     5.156    74.014     0.150
     5.181    75.758     0.150
     5.818    83.188     0.150
     6.294    90.041     0.150
     1.078    19.863     0.150
     1.414    25.188     0.150
     1.488    24.797     0.150
     1.545    26.137     0.150
     1.836    29.547     0.150
     2.159    33.547     0.150
     2.168    34.762     0.150
     2.295    36.012     0.150
     2.570    38.785     0.150
     3.073    45.426     0.150
     3.107    46.719     0.150
     3.136    47.645     0.150
     3.210    49.020     0.150
     3.461    51.605     0.150
     3.551    53.188     0.150
     3.769    55.086     0.150
     3.971    57.207     0.150
     4.278    63.742     0.150
     4.778    69.066     0.150
     5.508    79.684     0.150
     6.433    91.992     0.150
     7.546   106.398     0.150
     7.654   108.055     0.150
     8.258   116.605     0.150
     0.498    11.401     0.150
     0.671    13.549     0.150
     1.036    32.301     0.150
     2.236    32.852     0.150
     2.484    37.081     0.150
     2.685    39.852     0.150
     2.783    40.871     0.150
     3.100    46.709     0.150
     3.329    47.602     0.150
     3.598    50.931     0.150
     3.944    57.081     0.150
    31.496   379.961     0.150
    44.697   491.255     0.150
    72.398   692.761     0.150
    73.818   700.578     0.150
     0.492    10.794     0.150
     1.478    24.724     0.150
     1.755    28.103     0.150
     1.761    27.714     0.150
     1.915    29.921     0.150
     2.074    32.339     0.150
     2.456    36.643     0.150
     2.612    41.103     0.150
     3.181    47.034     0.150
     3.710    54.729     0.150
     3.764    54.633     0.150
     3.759    55.303     0.150
     3.785    55.103     0.150
     4.146    60.442     0.150
     4.188    60.342     0.150
     4.644    67.965     0.150
     4.670    67.442     0.150
     4.951    71.322     0.150
     5.171    74.424     0.150
     6.565    92.774     0.150
     7.070   181.614     0.150
     7.081    99.893     0.150
     7.605   107.060     0.150
     2.940    44.852     0.150
     6.564    94.949     0.150
     6.735    97.141     0.150
     0.703    13.652     0.150
     1.092    19.000     0.150
     1.811    50.438     0.150
     2.119    56.219     0.150
     2.880    45.230     0.150
     2.902    46.258     0.150
     3.037    47.031     0.150
     3.027    46.621     0.150
     3.568    50.062     0.150
     3.621    53.742     0.150
     3.922    59.625     0.150
     4.490    65.621     0.150
     4.547    66.785     0.150
     5.018    72.738     0.150
     5.061    74.023     0.150
     5.205    76.121     0.150
     5.405    79.078     0.150
     5.638    82.398     0.150
     5.719    83.043     0.150
     5.757    83.746     0.150
     6.227    89.992     0.150
     6.324    91.246     0.150
     6.607    95.473     0.150
     6.740    96.637     0.150
     6.750    99.383     0.150
     7.060   102.344     0.150
     7.142   102.852     0.150
     7.346   104.840     0.150
     7.367   106.477     0.150
     8.060   115.879     0.150
     8.287   117.637     0.150
     0.346     8.004     0.150
     0.855    13.824     0.150
     1.144    19.824     0.150
     1.821    29.219     0.150
     3.989    59.422     0.150
     5.111    73.668     0.150
     5.704    83.047     0.150
     5.951    85.676     0.150
     6.020    87.527     0.150
     6.239    89.172     0.150
     6.534    95.977     0.150
     7.197   102.785     0.150
     7.801   111.418     0.150
    31.408   377.258     0.150
    46.506  3512.090     0.150
    46.512  3511.301     0.150
    46.524  3506.672     0.150
    47.663  3583.957     0.150
    47.676  3579.066     0.150
    47.681  3588.922     0.150
    69.630   665.676     0.150
    69.630   665.676     0.150
    69.630   920.316     0.150
    69.630  1679.598     0.150
     1.146    20.312     0.150
     1.257    20.711     0.150
     1.257    35.609     0.150
     1.257    20.633     0.150
     1.608    26.023     0.150
     2.082    31.820     0.150
     2.082    31.836     0.150
     2.325    35.984     0.150
     2.355    36.211     0.150
     2.570    39.930     0.150
     3.132    46.734     0.150
     3.157    45.969     0.150
     3.647    53.016     0.150
     3.647    52.938     0.150
     3.912    56.938     0.150
     5.126    74.234     0.150
     5.484    78.562     0.150
     6.386    91.906     0.150
     1.140    20.995     0.150
     1.311    23.294     0.150
     1.759    29.085     0.150
     2.151    61.214     0.150
     2.558    39.403     0.150
     2.689    41.735     0.150
     4.787    69.967     0.150
     4.921    72.109     0.150
     5.118    73.909     0.150
     5.597    79.769     0.150
     5.729    81.981     0.150
     5.780    83.066     0.150
     6.248    89.255     0.150
     6.601    94.521     0.150
     6.674    95.172     0.150
     7.281   102.129     0.150
     9.431   131.265     0.150
     0.518    10.766     0.150
     0.518    10.922     0.150
     0.518    18.547     0.150
     1.807    29.922     0.150
     2.427    38.352     0.150
     2.440    38.914     0.150
     2.599    40.203     0.150
     2.622    68.992     0.150
     3.000    45.883     0.150
     3.115    47.266     0.150
     3.221    47.430     0.150
     3.480    50.656     0.150
     3.499    51.648     0.150
     4.062    59.562     0.150
     4.154    60.617     0.150
     4.609    66.695     0.150
     4.638    67.164     0.150
     4.744    67.711     0.150
     4.769    69.867     0.150
     4.991    72.148     0.150
     5.093    74.305     0.150
     5.972    86.062     0.150
     5.972    85.922     0.150
     7.201   103.070     0.150
     7.335   105.141     0.150
     7.522   106.750     0.150
     7.831   111.195     0.150
     7.880   111.984     0.150
     7.934   113.102     0.150
     8.039   113.969     0.150
     9.433   133.414     0.150
     9.439   134.148     0.150
    10.773   152.062     0.150
    11.841   167.008     0.150
    17.314   237.164     0.150
    23.161   304.086     0.150
    32.637   387.773     0.150
    34.195   401.703     0.150
    44.815   490.422     0.150
    44.875   494.508     0.150
    47.981  3625.031     0.150
    47.986  3645.219     0.150
    47.999  3652.422     0.150
    49.140  3683.734     0.150
    49.153  3686.438     0.150
    49.157  3687.672     0.150
    51.245   538.688     0.150
    53.493   558.539     0.150
    56.713   582.188     0.150
    70.534   667.734     0.150
    70.534   668.336     0.150
    72.391   684.633     0.150
    78.299   715.586     0.150
     0.461    10.199     0.150
     0.461    10.240     0.150
     1.069    18.561     0.150
     1.348    21.186     0.150
     1.623    48.141     0.150
     2.508    35.994     0.150
     3.174    47.439     0.150
     3.727    55.604     0.150
     3.967    58.600     0.150
     4.083    59.395     0.150
     4.806    69.107     0.150
     5.171    73.799     0.150
     5.171    73.699     0.150
     5.203    74.426     0.150
     5.867    83.900     0.150
     5.924    85.500     0.150
     5.924    85.580     0.150
     6.840    97.600     0.150
     6.860    97.652     0.150
     7.124   101.199     0.150
     7.298   103.199     0.150
     8.075   114.529     0.150
     8.119   115.033     0.150
     8.779   122.834     0.150
     9.018   126.420     0.150
     9.274   130.400     0.150
     9.925   139.156     0.150
    10.034   141.074     0.150
    10.742   151.695     0.150
    11.181   156.875     0.150
    14.570   202.799     0.150
    20.785     9.500     0.150
    20.785   291.500     0.150
    20.785   544.600     0.150
    22.238   295.000     0.150
    23.834   309.600     0.150
    23.834   306.457     0.150
    26.671   331.100     0.150
    26.828   338.199     0.150
    28.105   346.900     0.150
    29.596   361.500     0.150
    29.813   364.000     0.150
    30.784   372.299     0.150
    30.986   373.199     0.150
    31.425   378.229     0.150
    31.598   378.525     0.150
    32.144   381.762     0.150
    32.212   381.869     0.150
    32.586   386.494     0.150
    33.055   393.600     0.150
    33.486   397.100     0.150
    33.528   396.500     0.150
    38.797   435.000     0.150
    43.029   476.500     0.150
    44.170   482.732     0.150
    44.610   488.900     0.150
    46.455   502.299     0.150
    47.667   510.420     0.150
    47.959   514.299     0.150
    56.045   573.199     0.150
    61.897   611.699     0.150
    61.897    10.701     0.150
    63.503    10.701     0.150
    63.503    17.400     0.150
    64.104   628.100     0.150
    64.360   629.699     0.150
    65.621    11.100     0.150
    65.621    17.400     0.150
    65.677    10.699     0.150
    65.730   641.600     0.150
    66.477    11.400     0.150
    66.477    19.701     0.150
    66.953    10.299     0.150
    67.806   904.600     0.150
    68.745   649.400     0.150
    68.745   649.400     0.150
    68.745   653.410     0.150
    68.745   900.930     0.150
    68.745  1184.629     0.150
    68.745  1588.719     0.150
    68.745   649.400     0.150
    68.745   806.699     0.150
    70.491     6.801     0.150
    70.491     9.801     0.150
    71.433   674.600     0.150
    71.938  3139.170     0.150
    71.938  3148.779     0.150
    71.938  3271.490     0.150
    71.938   678.100     0.150
    72.322   681.600     0.150
    72.368   680.799     0.150
    72.454   681.400     0.150
    72.527   680.600     0.150
    72.589   682.299     0.150
    72.621   682.299     0.150
    72.621   693.900     0.150
    72.863   683.900     0.150
    73.379   685.900     0.150
    73.642   689.100     0.150
    74.008   690.299     0.150
    74.920    11.100     0.150
    74.920    19.000     0.150
    81.153   730.100     0.150
    81.497   732.400     0.150
    82.406   736.199     0.150
    83.531   742.100     0.150
     0.871    15.984     0.150
     2.647    39.340     0.150
     2.916    43.774     0.150
     3.448    51.707     0.150
     4.318    62.680     0.150
     4.552    65.508     0.150
     5.834    83.291     0.150
     6.842    95.923     0.150
     7.658   107.010     0.150
     0.746    15.730     0.150
     1.182    21.754     0.150
     1.359    23.852     0.150
     1.359    24.082     0.150
     1.639    28.309     0.150
     1.639    28.344     0.150
     1.813    29.973     0.150
     1.813    53.285     0.150
     1.931    32.445     0.150
     2.191    38.320     0.150
     2.191    38.434     0.150
     2.386    39.223     0.150
     2.759    44.082     0.150
     2.870    47.289     0.150
     2.906    46.570     0.150
     3.203    51.176     0.150
     3.250    50.941     0.150
     4.014    61.316     0.150
     4.566    68.199     0.150
     4.728    70.301     0.150
     4.861    75.250     0.150
     5.500    84.629     0.150
     5.362    84.578     0.150
     5.927    88.215     0.150
     6.151    90.926     0.150
     6.443    96.105     0.150
     7.429   111.762     0.150
     7.429   110.793     0.150
     8.195   120.891     0.150
     8.314   117.039     0.150
     8.696   126.410     0.150
    18.989   260.598     0.150
    34.041   404.480     0.150
    44.325   488.852     0.150
    44.457   489.770     0.150
    45.885   505.289     0.150
    58.401   593.590     0.150
    72.310   684.891     0.150
    72.608   686.289     0.150
    73.349   691.391     0.150
    80.209   729.051     0.150
    96.697   811.391     0.150
     0.719    14.785     0.150
     0.847    16.902     0.150
     0.847    29.148     0.150
     1.014    29.445     0.150
     1.355    22.996     0.150
     1.355    40.293     0.150
     1.355    22.617     0.150
     1.355    23.176     0.150
     1.355    39.801     0.150
     1.581    27.305     0.150
     1.777    29.352     0.150
     2.324    38.367     0.150
     3.274    53.164     0.150
     3.888    62.047     0.150
     4.039    63.598     0.150
     4.484    69.098     0.150
     4.798    66.848     0.150
     4.798    72.633     0.150
     5.656    85.062     0.150
     5.675    84.254     0.150
     6.110    90.930     0.150
     6.404    95.855     0.150
     6.695    99.465     0.150
     6.900   102.992     0.150
     6.962   104.332     0.150
     7.235   107.246     0.150
     7.985   117.777     0.150
     8.000   114.887     0.150
     8.106   118.805     0.150
     8.106   118.703     0.150
     8.253   108.477     0.150
     8.420   124.008     0.150
     8.433   124.238     0.150
     8.581   123.055     0.150
     8.561   126.109     0.150
     8.599   122.887     0.150
     8.713   127.234     0.150
     8.713   128.703     0.150
     8.925   130.332     0.150
     9.077   133.074     0.150
     9.586   138.070     0.150
    10.048   142.598     0.150
    10.498   147.086     0.150
    13.289   189.645     0.150
    26.796   341.926     0.150
    30.579   372.922     0.150
    32.871   392.637     0.150
    33.663   400.207     0.150
    33.675   400.875     0.150
    34.054   404.477     0.150
    35.376   414.355     0.150
    55.366   573.465     0.150
    12.933   176.465     0.150
     1.207    37.172     0.150
     3.358    50.012     0.150
     1.565    27.875     0.150
     0.499     9.723     0.150
     2.860    44.192     0.150
     2.981    45.711     0.150
     3.098    46.723     0.150
     7.008    99.473     0.150
     0.475     9.449     0.150
     0.804    15.883     0.150
     2.190    33.656     0.150
     2.704    43.188     0.150
     2.904    45.152     0.150
     3.316    47.566     0.150
     3.316    47.566     0.150
     3.205    49.250     0.150
     3.355    51.309     0.150
     3.974    60.258     0.150
     4.098    61.758     0.150
     4.095    60.305     0.150
     4.926    72.961     0.150
     4.914    71.613     0.150
     4.943    71.805     0.150
     5.027    73.285     0.150
     5.028    73.406     0.150
     5.450    76.875     0.150
     5.545    81.008     0.150
     5.545    81.074     0.150
     6.474    91.316     0.150
     6.217    89.508     0.150
     6.973    99.406     0.150
     7.265   103.957     0.150
     8.239   117.508     0.150
     8.239   117.945     0.150
     8.284   117.406     0.150
     8.337   118.047     0.150
     9.390   131.906     0.150
    10.562   147.895     0.150
    14.909   204.168     0.150
    14.909   204.207     0.150
    14.914   204.555     0.150
    15.176   207.918     0.150
    18.799   257.652     0.150
    21.451   293.707     0.150
    21.451   316.406     0.150
    21.451   565.105     0.150
    22.514   297.105     0.150
    23.837   308.195     0.150
    25.511   326.246     0.150
    27.131   339.895     0.150
    28.256   349.305     0.150
    29.136   358.086     0.150
    29.152   358.605     0.150
    30.560   369.895     0.150
    30.560   370.078     0.150
    32.669   390.906     0.150
    34.151   409.445     0.150
    37.061   423.605     0.150
    36.983   429.852     0.150
    37.703   436.137     0.150
    38.090   438.062     0.150
    40.588  4657.906     0.150
    40.471   456.176     0.150
    40.996   462.922     0.150
    41.297   461.617     0.150
    41.901   468.238     0.150
    42.966   474.906     0.150
    43.111   477.848     0.150
    44.025   486.855     0.150
    44.195   487.012     0.150
    44.886   493.801     0.150
    44.924   492.707     0.150
    45.383     7.000     0.150
    45.383     9.902     0.150
    47.446   512.906     0.150
    47.452   512.895     0.150
    47.950   515.301     0.150
    48.095     9.398     0.150
    48.095    14.098     0.150
    48.095   600.305     0.150
    48.430     8.703     0.150
    48.430    12.402     0.150
    48.317   519.773     0.150
    48.328   520.117     0.150
    48.887  3665.621     0.150
    48.901  3645.551     0.150
    48.905  3646.141     0.150
    48.655   522.133     0.150
    48.986   524.805     0.150
    49.287   525.906     0.150
    49.122   525.969     0.150
    49.674   531.301     0.150
    49.677   526.250     0.150
    49.677   526.250     0.150
    49.695   530.477     0.150
    49.775   530.324     0.150
    50.074   533.227     0.150
    50.190   534.445     0.150
    50.407   534.590     0.150
    50.724   537.305     0.150
    53.565   556.605     0.150
    53.565   625.105     0.150
    54.167   866.832     0.150
    54.167   560.828     0.150
    54.167   560.805     0.150
    55.684   578.605     0.150
    56.327   574.707     0.150
    58.212     6.301     0.150
    58.232   589.848     0.150
    58.232   589.805     0.150
    60.687     9.102     0.150
    60.756    10.102     0.150
    60.756    14.000     0.150
    61.629   615.105     0.150
    62.123   618.406     0.150
    62.123   618.406     0.150
    62.123  1129.805     0.150
    62.123   753.207     0.150
    62.123  1129.707     0.150
    63.049     7.102     0.150
    63.049    14.500     0.150
    62.855   623.547     0.150
    63.896   636.078     0.150
    64.337     6.000     0.150
    64.193   862.707     0.150
    65.329   638.117     0.150
    65.329   638.105     0.150
    65.519   641.508     0.150
    65.519  1167.105     0.150
    65.959   642.906     0.150
    65.969   642.977     0.150
    66.392  4954.906     0.150
    66.501    10.000     0.150
    66.963   649.805     0.150
    67.054   650.406     0.150
    67.039   649.906     0.150
    67.275     6.801     0.150
    67.275     9.801     0.150
    68.018   656.805     0.150
    68.018   677.707     0.150
    69.087   664.707     0.150
    68.878   663.336     0.150
    68.878   663.336     0.150
    68.878   911.758     0.150
    68.878  1651.535     0.150
    68.878   663.305     0.150
    68.878   815.105     0.150
    68.878   911.707     0.150
    68.878  1211.805     0.150
    68.878  1471.105     0.150
    68.878  1651.508     0.150
    69.311   665.137     0.150
    69.818   668.305     0.150
    71.098   676.305     0.150
    71.098  1233.605     0.150
    71.115   676.008     0.150
    71.134   675.906     0.150
    71.245     4.199     0.150
    71.245  1225.906     0.150
    71.271   677.305     0.150
    71.445   678.406     0.150
    71.563     6.301     0.150
    71.563    11.398     0.150
    71.563   833.508     0.150
    71.419   847.906     0.150
    71.419   938.906     0.150
    71.419  1706.906     0.150
    71.419   678.305     0.150
    71.419  1234.906     0.150
    71.419   678.289     0.150
    71.552   679.305     0.150
    71.816  5356.605     0.150
    71.624   686.066     0.150
    71.900   681.105     0.150
    71.900  1242.406     0.150
    71.933   682.305     0.150
    71.933   691.605     0.150
    71.933  1235.906     0.150
    72.046   682.207     0.150
    72.398   684.008     0.150
    72.398  1248.008     0.150
    72.328   690.805     0.150
    72.328   684.906     0.150
    72.383   690.906     0.150
    72.383   684.605     0.150
    72.426   690.406     0.150
    72.426   684.805     0.150
    72.432   691.406     0.150
    72.432   684.805     0.150
    72.460   684.906     0.150
    72.639   692.508     0.150
    72.639   686.305     0.150
    72.786   686.105     0.150
    72.860   686.605     0.150
    72.941   687.105     0.150
    72.862   694.605     0.150
    72.862   687.207     0.150
    72.944   694.105     0.150
    72.944   687.406     0.150
    72.956   697.105     0.150
    72.956   685.805     0.150
    73.179   688.965     0.150
    73.179   689.008     0.150
    73.269   695.805     0.150
    73.269   690.105     0.150
    73.292   689.906     0.150
    73.626   691.605     0.150
    73.629   689.797     0.150
    73.629   698.605     0.150
    73.629   692.105     0.150
    73.681   690.906     0.150
    73.695   692.805     0.150
    73.894   692.305     0.150
    73.819   691.234     0.150
    73.819   691.207     0.150
    73.857   691.055     0.150
    73.857   691.105     0.150
    74.300  5547.406     0.150
    74.325  5547.305     0.150
    74.002   699.805     0.150
    74.002   693.707     0.150
    74.028   695.707     0.150
    74.365   697.105     0.150
    74.648   697.906     0.150
    74.672   698.207     0.150
    74.744   698.805     0.150
    74.917   698.508     0.150
    74.837   699.805     0.150
    74.954   699.406     0.150
    74.954  1277.508     0.150
    74.974   698.461     0.150
    75.014   698.578     0.150
    75.071   698.547     0.150
    75.250   699.406     0.150
    75.274   700.078     0.150
    75.279   702.105     0.150
    75.536     6.703     0.150
    75.642   702.785     0.150
    75.756   703.906     0.150
    76.202     7.102     0.150
    76.202     9.500     0.150
    76.520   708.805     0.150
    76.937   708.805     0.150
    77.520   714.508     0.150
    77.535   713.707     0.150
    77.655   713.906     0.150
    77.890   717.406     0.150
    77.920   716.207     0.150
    78.315   714.207     0.150
    78.194   720.078     0.150
    78.196   717.605     0.150
    78.209   717.305     0.150
    78.623  1012.906     0.150
    78.623  1372.707     0.150
    78.698   720.707     0.150
    78.997   719.305     0.150
    78.997     8.801     0.150
    78.927   720.406     0.150
    79.009   715.105     0.150
    79.009  1014.605     0.150
    79.009  1308.008     0.150
    79.009  1830.406     0.150
    79.683   728.008     0.150
    80.056  5981.605     0.150
    80.033   729.906     0.150
    80.160   726.227     0.150
    80.160   726.207     0.150
    81.386   736.906     0.150
    82.151   736.297     0.150
    81.990   739.406     0.150
    82.467   739.605     0.150
    82.482   740.605     0.150
    83.194   742.445     0.150
    83.194   742.406     0.150
    83.472   744.348     0.150
    84.420   748.266     0.150
    84.263   749.207     0.150
    84.348   747.906     0.150
   144.969  1173.605     0.150
   164.875  1203.426     0.150
     0.772    27.729     0.150
     0.772    15.247     0.150
     2.004    33.118     0.150
     2.158    32.768     0.150
     2.158    65.878     0.150
     2.768    42.738     0.150
     2.882    44.483     0.150
     3.299    46.529     0.150
     3.299    46.714     0.150
     3.518    51.714     0.150
     3.784    58.289     0.150
     3.839    58.551     0.150
     4.093    61.059     0.150
     4.060    60.817     0.150
     4.716    65.759     0.150
     5.276    76.444     0.150
     7.757   112.919     0.150
     7.915   113.819     0.150
     8.166   118.509     0.150
     8.703   125.529     0.150
    12.115   903.359     0.150
    14.226   199.832     0.150
    22.752   297.999     0.150
    30.588   370.959     0.150
    33.425   393.934     0.150
    38.677   441.239     0.150
    40.161   453.269     0.150
    41.063   459.839     0.150
    42.191   470.146     0.150
    43.515   484.999     0.150
    43.787   587.809     0.150
    45.070   493.879     0.150
    45.166   493.435     0.150
    45.156   490.529     0.150
    45.865   499.529     0.150
    47.005   509.899     0.150
    47.057   510.979     0.150
    47.293   512.929     0.150
    47.471   513.689     0.150
    47.499   513.849     0.150
    48.507   521.169     0.150
    48.666   523.189     0.150
    48.786   523.839     0.150
    49.236   527.909     0.150
    66.351   651.959     0.150
    71.906   687.479     0.150
    71.906   693.359     0.150
    72.834   693.259     0.150
    72.834   693.259     0.150
    73.140   690.003     0.150
    75.545   701.701     0.150
    76.491   705.117     0.150
    76.831   712.279     0.150
    76.881   707.582     0.150
    81.717   741.559     0.150
     1.625    51.844     0.150
     2.255    36.617     0.150
     2.255    36.133     0.150
     2.313    35.570     0.150
     2.441    39.133     0.150
     2.885    43.766     0.150
     2.969    44.812     0.150
     2.938    45.039     0.150
     3.153    47.570     0.150
     3.421    50.812     0.150
     4.054    60.453     0.150
     4.591    67.648     0.150
     6.374    91.383     0.150
     0.233    10.016     0.150
     0.785    15.285     0.150
     0.920    17.266     0.150
     0.920    17.344     0.150
     1.129    20.332     0.150
     1.229    21.598     0.150
     1.229    21.547     0.150
     1.685    27.047     0.150
     1.807    29.008     0.150
     1.955    31.621     0.150
     2.130    33.270     0.150
     2.469    37.844     0.150
     2.686    40.828     0.150
     2.700    40.891     0.150
     3.018    45.648     0.150
     3.127    46.840     0.150
     3.388    50.598     0.150
     3.425    51.117     0.150
     3.425    51.250     0.150
     3.547    53.102     0.150
     3.590    53.695     0.150
     3.590    53.629     0.150
     3.589    53.902     0.150
     3.798    56.246     0.150
     3.834    57.422     0.150
     3.963    58.855     0.150
     4.134    60.984     0.150
     4.198    61.707     0.150
     4.390    64.473     0.150
     4.394    64.703     0.150
     4.479    64.695     0.150
     4.631    66.898     0.150
     4.728    68.773     0.150
     4.804    69.922     0.150
     4.754    69.910     0.150
     5.200    74.898     0.150
     5.200    74.805     0.150
     5.233    76.398     0.150
     5.334    77.078     0.150
     5.556    80.496     0.150
     5.811    83.273     0.150
     5.858    84.430     0.150
     6.265    89.973     0.150
     6.331    90.695     0.150
     6.821    97.363     0.150
     6.871    98.293     0.150
     7.505   106.367     0.150
     7.820   111.281     0.150
     7.934   112.422     0.150
     8.489   120.422     0.150
     8.629   120.312     0.150
     8.817   123.707     0.150
     9.218   129.074     0.150
     9.482   133.387     0.150
     9.576   134.688     0.150
     9.781   137.812     0.150
    11.893   163.961     0.150
    14.048   194.758     0.150
    28.097   346.672     0.150
    31.627   378.492     0.150
    32.903   386.148     0.150
    37.844   430.957     0.150
    37.883   430.590     0.150
    39.009   434.008     0.150
    42.708   468.676     0.150
    43.926   479.996     0.150
    44.675   482.477     0.150
    48.077   511.219     0.150
    49.562   524.219     0.150
    50.410   530.078     0.150
    51.758   540.328     0.150
    52.982   616.320     0.150
    58.609   594.098     0.150
    65.143    15.102     0.150
    68.060   649.797     0.150
    68.060   649.797     0.150
    68.060   897.688     0.150
    68.060  1641.848     0.150
    70.773   668.398     0.150
    72.981   687.297     0.150
     0.449    16.527     0.150
     0.358     8.668     0.150
     0.358    15.539     0.150
     1.065    18.490     0.150
     1.065    32.945     0.150
     1.406    23.135     0.150
     1.406    41.475     0.150
     1.604    27.174     0.150
     1.607    26.764     0.150
     1.782    29.035     0.150
     1.830    29.174     0.150
     1.880    30.475     0.150
     2.133    33.135     0.150
     2.133    33.033     0.150
     2.373    36.309     0.150
     2.493    38.824     0.150
     2.884    42.805     0.150
     3.032    44.912     0.150
     3.390    49.496     0.150
     3.473    50.768     0.150
     3.534    52.061     0.150
     3.862    57.965     0.150
     3.877    56.465     0.150
     4.134    60.096     0.150
     4.205    62.514     0.150
     4.392    64.010     0.150
     4.469    65.502     0.150
     4.604    70.734     0.150
     4.588    67.102     0.150
     4.976    72.227     0.150
     5.009    72.439     0.150
     4.997    72.285     0.150
     5.075    73.404     0.150
     5.184    75.373     0.150
     5.401    79.184     0.150
     5.725    82.555     0.150
     5.792    82.926     0.150
     6.202    89.037     0.150
     6.313    90.760     0.150
     6.455    97.635     0.150
     6.456    92.092     0.150
     6.569    94.994     0.150
     6.720    96.355     0.150
     7.028    98.984     0.150
     7.028    98.986     0.150
     0.677    13.395     0.150
     1.084    18.121     0.150
     1.084    32.473     0.150
     1.125    18.867     0.150
     1.087    19.367     0.150
     1.325    22.715     0.150
     1.560    24.668     0.150
     1.763    28.746     0.150
     1.836    29.176     0.150
     1.887    29.293     0.150
     1.922    30.426     0.150
     1.977    30.691     0.150
     2.544    38.781     0.150
     2.549    38.449     0.150
     2.594    39.617     0.150
     2.685    40.820     0.150
     2.735    40.836     0.150
     2.891    42.168     0.150
     2.912    43.727     0.150
     2.904    44.102     0.150
     3.058    45.078     0.150
     3.340    49.359     0.150
     3.559    53.418     0.150
     3.636    54.012     0.150
     3.644    54.215     0.150
     3.795    56.418     0.150
     3.850    55.895     0.150
     3.948    56.559     0.150
     4.038    59.840     0.150
     4.067    60.766     0.150
     4.178    61.965     0.150
     4.302    62.871     0.150
     4.367    63.766     0.150
     4.384    63.723     0.150
     4.564    66.980     0.150
     4.628    66.441     0.150
     4.681    66.984     0.150
     4.775    68.750     0.150
     4.997    72.016     0.150
     5.018    72.266     0.150
     5.108    74.410     0.150
     5.408    77.336     0.150
     5.452    78.965     0.150
     5.505    79.070     0.150
     5.577    80.266     0.150
     5.648    81.535     0.150
     5.726    82.766     0.150
     5.796    83.574     0.150
     5.868    84.824     0.150
     5.873    84.785     0.150
     6.193    88.836     0.150
     6.558    92.738     0.150
     6.964    99.383     0.150
     7.166   101.242     0.150
     7.170   101.793     0.150
     7.349   104.340     0.150
     8.022   113.129     0.150
     8.214   116.234     0.150
     8.298   117.211     0.150
     8.596   120.805     0.150
     8.718   122.164     0.150
     0.247     6.567     0.150
     0.247    12.019     0.150
     0.881    15.007     0.150
     0.881    27.314     0.150
     1.029    18.647     0.150
     1.029    34.073     0.150
     1.076    19.029     0.150
     1.076    35.465     0.150
     1.501    25.004     0.150
     1.501    45.399     0.150
     1.698    53.798     0.150
     1.942    31.189     0.150
     1.942    55.386     0.150
     1.925    31.359     0.150
     2.168    34.409     0.150
     2.168    34.449     0.150
     2.447    38.254     0.150
     2.493    39.139     0.150
     2.877    43.704     0.150
     3.120    46.854     0.150
     3.248    47.899     0.150
     3.539    52.404     0.150
     3.614    53.397     0.150
     3.745    56.427     0.150
     3.825    55.189     0.150
     3.837    56.839     0.150
     4.095    60.209     0.150
     4.247    62.130     0.150
     4.261    62.779     0.150
     4.499    66.004     0.150
     4.545    66.713     0.150
     4.678    68.929     0.150
     4.883    70.239     0.150
     5.077    74.829     0.150
     5.131    74.654     0.150
     5.273    76.604     0.150
     5.368    76.629     0.150
     5.425    79.367     0.150
     5.704    81.989     0.150
     5.737    83.204     0.150
     5.797    83.129     0.150
     6.012    87.511     0.150
     6.286    90.229     0.150
     6.405    92.354     0.150
     6.512    93.854     0.150
     6.529    94.193     0.150
     6.724    96.225     0.150
     7.028   100.285     0.150
     7.274   103.804     0.150
     7.304   104.438     0.150
     7.442   105.944     0.150
     7.539   108.554     0.150
     7.538   108.137     0.150
     9.028   128.779     0.150
     9.316   132.054     0.150
     9.627   136.679     0.150
    35.512   412.009     0.150
    45.903   496.599     0.150
    46.516  3549.881     0.150
    46.522  3549.359     0.150
    46.534  3551.346     0.150
    47.676  3609.678     0.150
    47.689  3633.026     0.150
    47.694  3633.311     0.150
    54.273   561.704     0.150
    62.399   618.893     0.150
    69.346   663.859     0.150
    69.346   663.859     0.150
    69.346   808.149     0.150
    69.346   890.769     0.150
    69.346  1634.419     0.150
    70.769   672.299     0.150
    75.609   703.793     0.150
    75.776   705.039     0.150
     0.732    15.488     0.150
     0.894    17.223     0.150
     1.005    18.359     0.150
     1.233    21.629     0.150
     1.269    21.656     0.150
     1.269    21.773     0.150
     1.621    27.105     0.150
     1.940    30.559     0.150
     1.940    30.625     0.150
     2.203    34.828     0.150
     2.203    34.809     0.150
     2.386    57.285     0.150
     2.490    58.477     0.150
     2.557    39.918     0.150
     2.706    40.523     0.150
     2.808    43.059     0.150
     3.294    50.238     0.150
     3.294    50.160     0.150
     3.337    50.617     0.150
     3.375    50.422     0.150
     3.501    53.008     0.150
     3.605    53.203     0.150
     3.708    55.906     0.150
     3.864    56.457     0.150
     3.864    56.535     0.150
     3.907    57.059     0.150
     4.031    60.262     0.150
     4.215    62.656     0.150
     4.215    62.707     0.150
     4.380    65.219     0.150
     4.380    65.281     0.150
     4.620    67.559     0.150
     4.619    67.355     0.150
     4.905    71.957     0.150
     4.966    71.578     0.150
     5.378    78.695     0.150
     5.519    80.656     0.150
     5.564    80.434     0.150
     5.898    85.008     0.150
     6.985    98.809     0.150
     6.988    98.656     0.150
     6.988    98.715     0.150
     7.090  2352.957     0.150
     7.222   102.785     0.150
     7.389   104.984     0.150
     7.454   106.176     0.150
     7.444   105.227     0.150
     7.865   110.133     0.150
     8.115   115.195     0.150
     8.182   116.828     0.150
     8.279   118.355     0.150
     8.535   120.152     0.150
     8.730   123.984     0.150
     8.853   124.844     0.150
     8.890   126.777     0.150
     9.199   131.246     0.150
     9.261   130.230     0.150
     9.445   131.367     0.150
     9.495   134.539     0.150
     9.513   133.957     0.150
     9.790   136.633     0.150
     9.910   137.914     0.150
     9.892   135.855     0.150
    11.748   163.844     0.150
    12.990   177.438     0.150
    14.234   193.855     0.150
    14.671   201.957     0.150
    23.186   302.355     0.150
    26.790   333.559     0.150
    28.107   344.957     0.150
    30.133   363.457     0.150
    30.315  2354.035     0.150
    30.476   367.500     0.150
    31.402  2268.855     0.150
    32.533   381.988     0.150
    32.533    19.797     0.150
    33.336   392.258     0.150
    33.336   392.793     0.150
    35.104   407.656     0.150
    35.598   412.293     0.150
    37.360   425.859     0.150
    37.500   426.742     0.150
    38.748    21.301     0.150
    38.858   439.758     0.150
    38.858   440.227     0.150
    38.879   439.355     0.150
    38.879   568.855     0.150
    38.879   789.957     0.150
    38.879   439.859     0.150
    39.201   442.559     0.150
    39.336   444.605     0.150
    40.812   454.797     0.150
    41.364   460.402     0.150
    41.404   459.145     0.150
    41.931   462.855     0.150
    41.931   462.816     0.150
    41.936   462.457     0.150
    42.302   466.742     0.150
    42.577   467.156     0.150
    42.577   467.219     0.150
    42.702   470.145     0.150
    42.977   472.758     0.150
    43.143   473.539     0.150
    43.589   476.809     0.150
    43.992   480.621     0.150
    44.102   481.406     0.150
    44.405   482.355     0.150
    44.405   482.828     0.150
    44.405   482.855     0.150
    44.789   586.016     0.150
    44.836   486.059     0.150
    44.866   487.270     0.150
    45.122   487.059     0.150
    45.117   489.289     0.150
    45.275   484.707     0.150
    45.232   489.738     0.150
    45.261   490.355     0.150
    45.453   492.230     0.150
    45.812   495.539     0.150
    45.987   495.633     0.150
    46.226   497.586     0.150
    46.275   496.703     0.150
    46.412   498.609     0.150
    46.444   498.969     0.150
    46.873   502.656     0.150
    46.873   502.703     0.150
    46.873   502.609     0.150
    46.873   502.766     0.150
    46.925   502.918     0.150
    46.995   503.984     0.150
    47.039   502.168     0.150
    47.114   504.867     0.150
    47.126   505.266     0.150
    47.244   506.305     0.150
    47.413   506.621     0.150
    47.547   508.297     0.150
    47.628   508.281     0.150
    47.647   508.656     0.150
    47.647   509.250     0.150
    47.647   509.336     0.150
    47.793   509.672     0.150
    47.799   509.922     0.150
    47.817   510.309     0.150
    47.861   510.539     0.150
    48.022   511.648     0.150
    48.108  3680.738     0.150
    48.114  3680.027     0.150
    48.126  3678.301     0.150
    48.278   514.559     0.150
    48.357   514.355     0.150
    48.375   514.875     0.150
    48.425   514.312     0.150
    48.490   514.875     0.150
    48.498   515.758     0.150
    48.496   515.129     0.150
    48.553   514.688     0.150
    48.726   517.207     0.150
    48.749   517.453     0.150
    49.062   519.434     0.150
    49.061   519.379     0.150
    49.087   519.789     0.150
    49.152   520.004     0.150
    49.226   539.355     0.150
    49.196   520.453     0.150
    49.247   521.609     0.150
    49.279  3658.316     0.150
    49.293  3655.480     0.150
    49.297  3639.145     0.150
    49.304   521.895     0.150
    49.437   522.520     0.150
    49.437   522.719     0.150
    49.509   522.852     0.150
    49.577   524.102     0.150
    49.693   525.566     0.150
    49.730   524.734     0.150
    49.728   525.219     0.150
    49.793   525.191     0.150
    49.863   525.059     0.150
    49.899   525.938     0.150
    49.959   526.586     0.150
    50.047   527.094     0.150
    50.063   527.016     0.150
    50.115   527.887     0.150
    50.231   528.711     0.150
    50.305   528.699     0.150
    50.404   530.262     0.150
    50.496   531.145     0.150
    50.564   531.105     0.150
    50.628   532.172     0.150
    50.715   532.246     0.150
    50.776   532.930     0.150
    51.044   534.750     0.150
    51.168   535.285     0.150
    51.323   537.004     0.150
    51.363   537.344     0.150
    51.377   537.391     0.150
    51.444   537.688     0.150
    51.467   537.441     0.150
    51.809   540.418     0.150
    51.918   541.258     0.150
    51.898   541.684     0.150
    52.069   540.156     0.150
    52.290   611.883     0.150
    52.290  2786.434     0.150
    52.366   544.570     0.150
    52.460   545.223     0.150
    52.496   545.426     0.150
    52.660   546.461     0.150
    52.716   547.363     0.150
    53.166   550.273     0.150
    53.224   549.457     0.150
    53.299   551.535     0.150
    53.504   552.047     0.150
    53.522   553.504     0.150
    53.631   553.902     0.150
    53.789   553.828     0.150
    53.831   554.258     0.150
    54.119    16.301     0.150
    54.119    23.500     0.150
    54.310   558.699     0.150
    55.120   564.066     0.150
    55.423  2356.816     0.150
    55.423  2799.168     0.150
    57.280   579.625     0.150
    57.280   579.570     0.150
    57.583    25.000     0.150
    59.073   590.938     0.150
    59.503    18.500     0.150
    59.503    26.199     0.150
    60.240  2363.754     0.150
    60.240   598.559     0.150
    60.344   599.328     0.150
    60.349   597.867     0.150
    60.418  2821.605     0.150
    60.566   597.457     0.150
    60.566   597.457     0.150
    62.042    13.301     0.150
    62.519   615.379     0.150
    62.584    15.000     0.150
    62.887   616.059     0.150
    63.106   617.758     0.150
    63.410   620.707     0.150
    63.986   624.957     0.150
    63.986  1135.457     0.150
    64.099   625.355     0.150
    64.099   625.398     0.150
    65.031    16.000     0.150
    65.031    25.301     0.150
    65.314    16.500     0.150
    65.447   632.957     0.150
    65.508   633.559     0.150
    65.781   632.355     0.150
    65.998    19.301     0.150
    66.468   640.188     0.150
    67.376   645.926     0.150
    67.376   645.926     0.150
    67.376   892.148     0.150
    67.376  1626.434     0.150
    67.376   645.855     0.150
    67.376    20.703     0.150
    67.376   794.656     0.150
    67.376   892.059     0.150
    67.376  1174.656     0.150
    67.376  1210.656     0.150
    67.376  1434.457     0.150
    69.547   660.156     0.150
    69.547  1203.457     0.150
    69.557   659.355     0.150
    69.723   661.258     0.150
    69.864    15.301     0.150
    70.002   663.059     0.150
    70.038    24.602     0.150
    70.038   662.656     0.150
    70.038    19.902     0.150
    70.038  1208.457     0.150
    70.192   662.355     0.150
    70.342   664.758     0.150
    70.488   666.059     0.150
    70.544   676.078     0.150
    70.544   681.676     0.150
    70.544   666.457     0.150
    70.828   667.758     0.150
    70.933   669.258     0.150
    70.974   669.355     0.150
    71.052   669.656     0.150
    71.162  2340.184     0.150
    71.228   670.758     0.150
    71.379   671.559     0.150
    71.468   672.258     0.150
    71.486   672.156     0.150
    71.530   670.457     0.150
    71.530   670.457     0.150
    71.560   672.559     0.150
    71.611   672.656     0.150
    71.611   672.812     0.150
    71.611   672.828     0.150
    71.843   674.559     0.150
    71.871   674.059     0.150
    71.871   672.957     0.150
    72.247   677.059     0.150
    72.283   677.559     0.150
    72.312   676.059     0.150
    72.350   675.957     0.150
    72.357    17.480     0.150
    72.392   677.559     0.150
    72.531   677.855     0.150
    72.591   679.457     0.150
    72.675    22.301     0.150
    72.905   680.758     0.150
    72.913   680.559     0.150
    73.218   682.457     0.150
    73.256   683.258     0.150
    73.330   682.258     0.150
    73.369   683.156     0.150
    73.360  5371.660     0.150
    73.422   684.355     0.150
    73.744   684.059     0.150
    73.840   685.855     0.150
    73.871   686.957     0.150
    73.985    13.699     0.150
    74.192   688.059     0.150
    74.954   691.855     0.150
    75.058   693.156     0.150
    75.143   692.719     0.150
    76.041   698.355     0.150
    76.450   701.656     0.150
    76.774   702.656     0.150
    76.863   698.855     0.150
    77.349   705.957     0.150
    77.406    23.602     0.150
    77.409    16.102     0.150
    77.409    23.102     0.150
    77.420   706.156     0.150
    77.703   878.656     0.150
    77.703  1793.457     0.150
    77.760    19.000     0.150
    77.760    27.801     0.150
    78.764   712.855     0.150
    79.037   716.559     0.150
    79.266   719.445     0.150
    79.266   719.457     0.150
    79.433   719.355     0.150
    79.777   718.559     0.150
    79.953   721.957     0.150
    80.198   722.945     0.150
    80.198    17.762     0.150
    80.226   721.758     0.150
    80.278   721.957     0.150
    80.330   724.062     0.150
    80.356   722.355     0.150
    80.687   727.559     0.150
    80.713   722.656     0.150
    80.742   724.457     0.150
    80.772   725.355     0.150
    80.868   726.059     0.150
    80.879   725.156     0.150
    81.353   728.258     0.150
    81.598   728.445     0.150
    81.757   730.059     0.150
    81.873   731.258     0.150
    81.975  2311.105     0.150
    81.975  2896.707     0.150
    82.125   731.758     0.150
    82.083   732.559     0.150
    82.886   734.758     0.150
    92.453   781.875     0.150
    92.537   783.156     0.150
    93.115   788.277     0.150
    96.706   797.656     0.150
    97.800   805.059     0.150
   120.335  1724.605     0.150
   122.193  1126.457     0.150
   122.302  1124.957     0.150
   136.856  1143.250     0.150
   137.321  1144.379     0.150
   137.737  1156.156     0.150
   138.223  1153.059     0.150
   138.496  1146.406     0.150
   141.967  1156.707     0.150
   146.084  1169.355     0.150
   148.266  1169.527     0.150
     3.107    48.895     0.150
     4.080    61.523     0.150
     0.166     4.480     0.150
     0.166     7.793     0.150
     0.825    14.672     0.150
     0.917    17.297     0.150
     1.186    21.879     0.150
     1.281    22.461     0.150
     1.416    23.820     0.150
     1.418    23.891     0.150
     1.418    42.062     0.150
     1.791    29.953     0.150
     2.013    61.664     0.150
     2.035    32.801     0.150
     2.771    42.750     0.150
     2.882    44.699     0.150
     3.016    48.832     0.150
     3.423    51.961     0.150
     5.142    74.699     0.150
     5.675    81.383     0.150
     7.347   103.941     0.150
     7.409   106.281     0.150
     7.571   110.652     0.150
     7.933   115.047     0.150
     8.095   115.938     0.150
     8.155   118.355     0.150
     0.283     8.738     0.150
     0.283    15.746     0.150
     0.761    14.316     0.150
     0.761    25.582     0.150
     0.802    26.621     0.150
     0.980    17.211     0.150
     0.980    30.566     0.150
     1.352    22.641     0.150
     1.352    22.703     0.150
     1.586    25.852     0.150
     1.727    27.086     0.150
     1.712    27.914     0.150
     2.106    32.383     0.150
     2.107    32.520     0.150
     2.460    37.234     0.150
     2.565    39.039     0.150
     2.775    41.121     0.150
     2.908    43.285     0.150
     2.898    43.754     0.150
     2.978    45.922     0.150
     3.191    47.527     0.150
     3.301    48.883     0.150
     3.477    51.184     0.150
     3.816    56.250     0.150
     3.909    56.383     0.150
     3.984    58.777     0.150
     4.020    59.461     0.150
     4.324    63.234     0.150
     4.338    63.852     0.150
     4.503    65.715     0.150
     4.600    66.473     0.150
     4.609    67.145     0.150
     4.625    67.582     0.150
     4.652    68.359     0.150
     4.657    66.922     0.150
     4.832    69.301     0.150
     4.887    71.551     0.150
     4.948    72.605     0.150
     5.027    73.285     0.150
     5.042    72.781     0.150
     5.102    73.844     0.150
     5.141    73.383     0.150
     5.172    74.691     0.150
     5.199    74.203     0.150
     5.299    74.953     0.150
     5.469    79.137     0.150
     5.584    80.305     0.150
     5.649    80.156     0.150
     5.717    82.652     0.150
     5.753    82.934     0.150
     5.873    83.605     0.150
     6.128    87.340     0.150
     6.256    90.305     0.150
     6.348    89.910     0.150
     6.449    92.359     0.150
     6.482    92.527     0.150
     6.673    95.355     0.150
     6.724    95.777     0.150
     6.700    95.223     0.150
     6.721    96.234     0.150
     7.003    99.508     0.150
     7.030    98.480     0.150
     7.227   102.695     0.150
     7.220   102.773     0.150
     7.545   106.516     0.150
     7.844   110.867     0.150
     5.388    76.535     0.150
     5.495    81.855     0.150
     5.797    82.828     0.150
     5.923    84.227     0.150
     6.855    96.715     0.150
     7.001    98.926     0.150
     7.398   104.355     0.150
     0.263    19.707     0.150
     0.263    19.738     0.150
     0.263    34.535     0.150
     0.622    21.168     0.150
     0.622    37.039     0.150
     0.800    22.258     0.150
     0.836    22.508     0.150
     0.836    39.289     0.150
     1.025    24.559     0.150
     1.025    43.207     0.150
     1.048    24.707     0.150
     1.048    43.293     0.150
     1.146    24.617     0.150
     1.146    43.586     0.150
     1.297    27.035     0.150
     1.297    47.277     0.150
     1.384    27.645     0.150
     1.464    28.520     0.150
     1.497    29.082     0.150
     1.694    30.719     0.150
     1.737    31.734     0.150
     1.790    31.469     0.150
     2.110    36.609     0.150
     2.134    35.688     0.150
     2.146    36.426     0.150
     2.334    38.273     0.150
     2.540    41.582     0.150
     2.730    43.066     0.150
     2.852    45.539     0.150
     3.005    47.418     0.150
     3.023    47.621     0.150
     3.075    47.492     0.150
     3.454    53.059     0.150
     3.454    53.148     0.150
     3.462    52.938     0.150
     3.840    58.043     0.150
     3.948    59.898     0.150
     4.386    64.859     0.150
     4.385    65.734     0.150
     4.537    67.488     0.150
     4.632    67.793     0.150
     5.044    73.199     0.150
     5.221    74.871     0.150
     5.335    77.008     0.150
     5.463    78.047     0.150
     5.511    79.926     0.150
     6.001    86.066     0.150
     6.013    84.469     0.150
     6.239    89.609     0.150
     7.036   100.199     0.150
     7.138   100.168     0.150
     7.138   100.051     0.150
     7.264   103.535     0.150
     7.425   105.680     0.150
     7.719   109.812     0.150
     7.740   108.035     0.150
     8.050   114.883     0.150
     0.603    12.690     0.150
     0.695    13.424     0.150
     1.158    19.708     0.150
     1.306    22.271     0.150
     1.729    28.312     0.150
     1.765    28.107     0.150
     1.919    29.842     0.150
     1.940    30.371     0.150
     2.007    31.327     0.150
     2.481    37.007     0.150
     3.090    45.918     0.150
     3.534    52.734     0.150
     3.632    53.953     0.150
     3.680    54.591     0.150
     3.708    54.924     0.150
     4.075    59.856     0.150
     4.121    61.321     0.150
     4.248    61.054     0.150
     4.175    63.365     0.150
     4.453    64.759     0.150
     4.451    65.244     0.150
     4.936    70.789     0.150
     5.773    83.364     0.150
     5.830    84.043     0.150
     6.354    90.693     0.150
     6.766    96.743     0.150
     7.010    99.571     0.150
     7.080   100.833     0.150
     7.218   102.685     0.150
     7.393   103.641     0.150
     7.856   111.567     0.150
     8.515   120.259     0.150
     8.987   126.817     0.150
     9.132   128.962     0.150
     9.146   129.344     0.150
     9.351   132.329     0.150
     9.429   132.931     0.150
    10.433   148.011     0.150
    10.521   149.897     0.150
    10.977   155.632     0.150
    11.376   159.412     0.150
    11.495   161.010     0.150
    21.957   287.741     0.150
    23.211   301.761     0.150
    23.356   304.451     0.150
    24.805   315.731     0.150
    29.501   358.737     0.150
    40.944   456.399     0.150
    47.030   505.021     0.150
    50.058   530.504     0.150
    75.409   699.671     0.150
     0.359    11.512     0.150
     0.359    20.820     0.150
     0.727    26.496     0.150
     0.920    17.652     0.150
     1.266    21.562     0.150
     1.266    21.570     0.150
     1.266    38.336     0.150
     1.320    22.656     0.150
     1.640    26.812     0.150
     1.668    26.938     0.150
     1.941    29.910     0.150
     2.026    32.012     0.150
     2.026    55.984     0.150
     2.130    33.438     0.150
     2.130    58.316     0.150
     2.146    34.148     0.150
     2.146    59.875     0.150
     2.309    35.637     0.150
     2.454    37.578     0.150
     2.454    66.207     0.150
     2.499    38.586     0.150
     2.670    41.590     0.150
     2.900    44.027     0.150
     2.989    45.062     0.150
     3.020    45.250     0.150
     3.013    45.285     0.150
     3.104    47.195     0.150
     3.354    50.312     0.150
     3.603    53.531     0.150
     3.751    54.379     0.150
     3.769    56.723     0.150
     3.769    56.727     0.150
     3.791    56.188     0.150
     3.860    57.160     0.150
     3.876    57.363     0.150
     4.092    60.426     0.150
     4.152    60.785     0.150
     4.198    61.898     0.150
     4.323    63.160     0.150
     4.334    64.031     0.150
     4.465    65.535     0.150
     4.571    65.910     0.150
     4.577    66.168     0.150
     4.654    66.930     0.150
     4.709    68.262     0.150
     4.798    70.406     0.150
     4.863    69.863     0.150
     4.983    71.910     0.150
     5.058    73.527     0.150
     5.127    73.988     0.150
     5.152    72.969     0.150
     5.238    75.926     0.150
     5.257    76.285     0.150
     5.310    76.641     0.150
     5.811    83.988     0.150
     5.890    84.922     0.150
     5.970    85.270     0.150
     6.046    86.109     0.150
     6.076    86.152     0.150
     6.208    88.664     0.150
     6.247    88.289     0.150
     6.290    90.203     0.150
     6.314    90.922     0.150
     6.574    93.875     0.150
     6.813    97.070     0.150
     7.094   101.027     0.150
     7.203   102.414     0.150
     7.539   106.387     0.150
     7.597   108.574     0.150
     7.626   108.211     0.150
     7.789   110.473     0.150
     7.852   111.293     0.150
     8.196   116.168     0.150
     8.367   118.840     0.150
     8.375   117.762     0.150
     8.375   117.734     0.150
     8.398   118.781     0.150
     8.845   124.535     0.150
    10.446   145.082     0.150
     1.039    30.352     0.150
     1.047    18.875     0.150
     1.273    21.250     0.150
     1.274    21.156     0.150
     1.274    38.758     0.150
     1.486    25.859     0.150
     1.487    24.930     0.150
     1.507    26.188     0.150
     1.511    26.586     0.150
     1.913    32.219     0.150
     2.239    36.656     0.150
     2.239    36.836     0.150
     2.254    39.094     0.150
     2.295    37.438     0.150
     2.247    38.508     0.150
     2.315    39.164     0.150
     2.587    42.836     0.150
     2.651    42.562     0.150
     2.707    43.281     0.150
     3.242    53.750     0.150
     3.503    56.711     0.150
     3.500    54.219     0.150
     3.774    57.922     0.150
     3.804    59.227     0.150
     4.178    64.125     0.150
     4.520    70.320     0.150
     4.722    72.609     0.150
     4.763    74.180     0.150
     4.767    70.711     0.150
     4.909    72.578     0.150
     4.948    70.938     0.150
     5.281    80.242     0.150
     5.281    80.125     0.150
     5.868    86.312     0.150
     6.173    92.609     0.150
     6.368    95.797     0.150
    10.659   154.617     0.150
    30.512   371.859     0.150
    31.759   381.977     0.150
    65.520   645.133     0.150
     0.025     2.195     0.150
     0.096     1.086     0.150
     0.158     5.418     0.150
     0.254     3.887     0.150
     0.388     7.766     0.150
     0.388     7.785     0.150
     0.832    13.426     0.150
     0.832    13.488     0.150
     0.888    28.703     0.150
     0.842    16.188     0.150
     0.842    28.035     0.150
     1.057    19.219     0.150
     1.113    20.637     0.150
     1.109    20.805     0.150
     1.500    25.066     0.150
     1.532    25.891     0.150
     1.534    25.867     0.150
     1.577    27.871     0.150
     1.577    49.820     0.150
     1.724    30.234     0.150
     1.976    32.566     0.150
     1.976    35.113     0.150
     2.020    33.027     0.150
     2.252    39.129     0.150
     2.319    37.598     0.150
     2.423    39.445     0.150
     2.428    39.785     0.150
     2.488    42.406     0.150
     2.553    42.047     0.150
     2.717    45.875     0.150
     2.762    45.855     0.150
     2.762    45.859     0.150
     2.845    45.898     0.150
     3.306    54.578     0.150
     3.306    54.578     0.150
     3.285    52.031     0.150
     3.658    56.168     0.150
     3.684    57.715     0.150
     3.709    58.375     0.150
     3.914    62.707     0.150
     3.917    60.836     0.150
     4.016    61.938     0.150
     4.360    68.203     0.150
     4.669    71.629     0.150
     4.891    73.988     0.150
     5.689    86.156     0.150
     5.689    86.160     0.150
     5.721    87.082     0.150
     5.927    87.117     0.150
     5.988    87.066     0.150
     5.962    87.445     0.150
     7.038   101.535     0.150
     7.092   101.605     0.150
     7.631   250.363     0.150
     7.761   111.527     0.150
     9.658   136.906     0.150
     0.305    13.461     0.150
     0.386     6.031     0.150
     1.205    20.457     0.150
     1.473    44.207     0.150
     1.826    29.270     0.150
     2.088    59.641     0.150
     2.167    33.695     0.150
     2.234    34.645     0.150
     2.466    38.840     0.150
     2.522    39.184     0.150
     2.561    39.293     0.150
     2.717    41.332     0.150
     3.013    45.379     0.150
     3.136    46.164     0.150
     3.349    49.938     0.150
     3.667    54.402     0.150
     3.773    55.770     0.150
     3.938    58.102     0.150
     4.074    59.277     0.150
     4.484    64.473     0.150
     4.508    66.699     0.150
     4.662    67.945     0.150
     5.047    73.508     0.150
     5.100    74.379     0.150
     5.146    74.340     0.150
     5.579    80.367     0.150
     5.579    80.285     0.150
     5.718    81.934     0.150
     5.827    84.211     0.150
     6.184    88.719     0.150
     6.188    89.059     0.150
     6.215    89.605     0.150
     6.296    90.184     0.150
     6.622    94.945     0.150
     6.967    99.898     0.150
     7.328   105.328     0.150
     7.366   106.262     0.150
     7.458   106.426     0.150
     7.561   106.750     0.150
     7.731   109.910     0.150
     7.797   109.898     0.150
     8.026   113.871     0.150
     8.230   116.207     0.150
     8.312   117.203     0.150
     8.756   124.180     0.150
     8.970   125.844     0.150
     9.247   130.355     0.150
     9.593   135.895     0.150
     9.910   139.348     0.150
    10.615   151.242     0.150
    11.822   167.418     0.150
    13.228   187.512     0.150
    19.575   262.469     0.150
    23.294   304.211     0.150
    24.234   312.641     0.150
    24.683   316.508     0.150
    32.942   390.129     0.150
    34.369   402.141     0.150
    42.619   470.508     0.150
    47.862  3656.820     0.150
    47.868  3656.820     0.150
    47.880  3656.820     0.150
    53.775   555.855     0.150
    65.836    11.402     0.150
    66.754    12.301     0.150
    66.754    18.199     0.150
    70.685     3.203     0.150
    70.685     5.801     0.150
    71.384   687.770     0.150
    74.751   695.055     0.150
     0.789    13.875     0.150
     1.210    19.812     0.150
     1.400    41.332     0.150
     1.831    28.848     0.150
     1.831    51.312     0.150
     2.086    33.492     0.150
     2.169    61.148     0.150
     2.169    33.301     0.150
     2.169    61.152     0.150
     2.204    34.746     0.150
     2.455    37.438     0.150
     2.520    38.703     0.150
     2.562    38.875     0.150
     2.716    41.223     0.150
     3.017    45.062     0.150
     3.236    47.539     0.150
     3.337    49.617     0.150
     3.367    50.297     0.150
     3.454    51.199     0.150
     4.069    58.855     0.150
     4.168    61.273     0.150
     4.184    61.129     0.150
     4.399    64.355     0.150
     4.435    65.344     0.150
     4.456    65.207     0.150
     4.479    65.773     0.150
     4.511    66.375     0.150
     4.616    67.559     0.150
     4.666    68.270     0.150
     4.715    68.555     0.150
     4.939    71.930     0.150
     5.016    72.867     0.150
     5.049    73.238     0.150
     5.104    74.195     0.150
     5.141    74.102     0.150
     5.292    76.426     0.150
     5.297    76.715     0.150
     5.324    76.496     0.150
     5.694    81.613     0.150
     5.825    84.461     0.150
     5.880    84.629     0.150
     6.180    88.445     0.150
     6.187    88.391     0.150
     6.218    88.984     0.150
     6.236    89.676     0.150
     6.648    95.309     0.150
     6.851    97.836     0.150
     7.390   104.559     0.150
     7.607   107.238     0.150
     7.938   112.328     0.150
     7.996   112.895     0.150
     8.099   114.562     0.150
     8.446   116.621     0.150
    13.850   196.648     0.150
     2.034    30.641     0.150
     8.387   117.586     0.150
     0.679    13.936     0.150
     0.679    23.688     0.150
     0.988    18.182     0.150
     1.750    55.217     0.150
     1.926    31.342     0.150
     2.026    33.088     0.150
     2.602    41.764     0.150
     2.740    42.756     0.150
     2.902    45.314     0.150
     3.203    50.096     0.150
     3.366    51.732     0.150
     3.364    50.904     0.150
     3.565    53.859     0.150
     3.707    57.768     0.150
     3.746    55.555     0.150
     4.234    62.822     0.150
     4.443    65.857     0.150
     4.642    69.020     0.150
     4.812    71.668     0.150
     5.068    73.475     0.150
     5.475    80.480     0.150
     5.626    83.928     0.150
     5.612    82.154     0.150
     5.765    84.211     0.150
     6.313    91.189     0.150
     6.428    93.457     0.150
     8.806   127.857     0.150
     0.536    22.962     0.150
     0.787    15.048     0.150
     0.787    15.088     0.150
     0.813    27.558     0.150
     0.813    15.742     0.150
     0.950    17.265     0.150
     0.950    30.562     0.150
     1.187    20.384     0.150
     1.275    22.173     0.150
     1.314    21.673     0.150
     1.314    38.449     0.150
     1.618    26.832     0.150
     1.634    26.398     0.150
     1.671    27.261     0.150
     1.671    47.394     0.150
     1.686    27.023     0.150
     1.688    27.223     0.150
     1.763    28.874     0.150
     1.845    29.354     0.150
     1.868    29.346     0.150
     2.000    31.207     0.150
     2.278    35.024     0.150
     2.280    35.473     0.150
     2.384    36.973     0.150
     2.469    38.298     0.150
     2.575    39.374     0.150
     2.624    40.053     0.150
     2.731    40.547     0.150
     2.807    41.720     0.150
     2.819    42.523     0.150
     2.877    42.995     0.150
     3.304    49.499     0.150
     3.332    49.758     0.150
     3.340    50.152     0.150
     3.369    50.449     0.150
     3.396    51.207     0.150
     3.507    53.054     0.150
     3.564    52.833     0.150
     3.781    56.654     0.150
     3.791    56.292     0.150
     3.852    57.164     0.150
     3.980    57.766     0.150
     4.083    60.018     0.150
     4.101    60.750     0.150
     4.132    58.962     0.150
     4.136    61.241     0.150
     4.287    63.131     0.150
     4.317    62.623     0.150
     4.347    63.083     0.150
     4.424    64.875     0.150
     4.441    65.401     0.150
     4.497    65.425     0.150
     4.545    65.198     0.150
     4.545    65.164     0.150
     4.658    67.373     0.150
     4.704    68.898     0.150
     4.857    70.398     0.150
     4.857    70.427     0.150
     4.868    70.263     0.150
     4.919    71.564     0.150
     4.951    71.322     0.150
     4.964    71.841     0.150
     4.985    72.416     0.150
     5.093    73.296     0.150
     5.095    73.594     0.150
     5.097    73.247     0.150
     5.149    74.667     0.150
     5.233    74.783     0.150
     5.242    75.668     0.150
     5.323    76.792     0.150
     5.382    76.639     0.150
     5.452    79.140     0.150
     5.542    79.740     0.150
     5.541    79.475     0.150
     5.553    80.764     0.150
     5.598    80.306     0.150
     5.687    80.874     0.150
     5.704    82.202     0.150
     5.800    83.354     0.150
     5.811    83.311     0.150
     5.862    83.896     0.150
     5.983    85.812     0.150
     6.078    86.960     0.150
     6.584    92.874     0.150
     6.606    94.083     0.150
     6.796    96.707     0.150
     7.066    99.844     0.150
     7.266   102.775     0.150
     7.299   103.533     0.150
     7.347   103.014     0.150
     7.368   103.710     0.150
     7.385   104.812     0.150
     7.597   107.485     0.150
     7.776   109.717     0.150
     7.907   111.542     0.150
     7.930   111.319     0.150
     8.273   116.140     0.150
     0.582    14.969     0.150
     5.876    82.672     0.150
     0.753    14.152     0.150
     0.745    14.344     0.150
     0.745    25.324     0.150
     1.197    19.137     0.150
     1.348    22.094     0.150
     1.348    39.809     0.150
     1.394    26.613     0.150
     1.394    44.863     0.150
     1.871    29.246     0.150
     2.266    34.391     0.150
     2.619    40.270     0.150
     2.619    40.195     0.150
     2.924    43.406     0.150
     3.075    46.770     0.150
     3.283    49.480     0.150
     3.390    50.797     0.150
     3.410    51.719     0.150
     3.722    54.402     0.150
     3.991    58.648     0.150
     4.010    59.465     0.150
     4.745    69.117     0.150
     4.828    70.168     0.150
     4.926    71.090     0.150
     5.388    77.246     0.150
     5.509    78.672     0.150
     5.509    78.609     0.150
     5.873    83.363     0.150
     6.186    89.570     0.150
     6.719    95.305     0.150
     8.213   116.105     0.150
     8.698   123.141     0.150
    20.637   273.102     0.150
     0.272     7.055     0.150
     0.862    12.961     0.150
     0.862    13.055     0.150
     1.090    18.969     0.150
     1.267    21.867     0.150
     1.743    28.312     0.150
     1.768    28.336     0.150
     1.768    57.617     0.150
     1.996    32.812     0.150
     2.175    33.625     0.150
     2.145    34.688     0.150
     2.686    41.078     0.150
     4.112    59.977     0.150
     4.785    69.812     0.150
     5.258    76.570     0.150
     5.319    77.414     0.150
     5.820    82.672     0.150
     5.875    84.570     0.150
     5.949    87.570     0.150
     6.618    94.969     0.150
     6.700    96.570     0.150
     6.738    96.625     0.150
     6.788    96.594     0.150
     7.077   101.711     0.150
     7.136   102.055     0.150
     7.174   103.164     0.150
     7.524   104.891     0.150
     7.453   106.625     0.150
     7.639   108.969     0.150
     7.675   108.820     0.150
     7.998   114.117     0.150
     9.247   130.867     0.150
    13.811   190.672     0.150
    15.327   214.070     0.150
    20.879   279.273     0.150
    31.460   377.953     0.150
    46.522  3518.906     0.150
    46.528  3518.039     0.150
    46.540  3519.797     0.150
    47.680  3604.664     0.150
    47.693  3605.734     0.150
    47.697  3605.758     0.150
    48.366   518.469     0.150
    62.673   620.172     0.150
    64.508   632.672     0.150
    64.508   770.867     0.150
    65.975     4.000     0.150
    66.976   648.367     0.150
    69.543   665.023     0.150
    69.543   665.023     0.150
    69.543   920.203     0.150
    69.543  1680.242     0.150
    69.543   664.969     0.150
    69.543   818.969     0.150
    69.543   920.172     0.150
    69.543  1213.367     0.150
    69.543  1482.672     0.150
    70.164   670.172     0.150
    74.584   696.172     0.150
    74.788   698.570     0.150
    75.094   699.273     0.150
    75.417   701.367     0.150
    75.458   702.273     0.150
    77.135   708.906     0.150
     0.364     8.578     0.150
     0.827    14.484     0.150
     1.368    23.242     0.150
     1.368    43.539     0.150
     1.845    34.734     0.150
     1.845    62.141     0.150
     2.247    36.016     0.150
     3.209    47.914     0.150
     3.456    54.344     0.150
     3.991    60.266     0.150
     4.012    59.570     0.150
     4.197    61.891     0.150
     4.565    67.328     0.150
     5.013    76.352     0.150
     6.239    91.086     0.150
     6.739    99.773     0.150
     7.775   112.617     0.150
    14.336   202.742     0.150
     0.734    14.242     0.150
     0.911    30.766     0.150
     1.117    18.820     0.150
     1.117    33.305     0.150
     1.231    39.070     0.150
     1.380    25.031     0.150
     1.450    25.312     0.150
     2.440    40.688     0.150
     3.209    51.914     0.150
     3.809    57.781     0.150
     3.876    58.375     0.150
     4.171    62.531     0.150
     4.366    65.711     0.150
     5.985    90.383     0.150
     6.910    97.453     0.150
     7.058    99.141     0.150
     7.491   110.227     0.150
     0.679    12.500     0.150
     0.679    21.992     0.150
     0.897    15.430     0.150
     0.897    27.812     0.150
     1.145    19.547     0.150
     1.376    22.910     0.150
     1.487    23.734     0.150
     1.806    29.109     0.150
     1.806    52.047     0.150
     1.968    30.195     0.150
     2.176    33.844     0.150
     2.231    35.137     0.150
     2.299    35.262     0.150
     2.338    35.637     0.150
     2.863    42.230     0.150
     3.074    46.379     0.150
     3.229    48.082     0.150
     3.223    47.898     0.150
     3.612    53.305     0.150
     3.877    56.922     0.150
     3.936    57.809     0.150
     4.009    58.945     0.150
     4.036    59.398     0.150
     4.239    61.977     0.150
     4.390    64.168     0.150
     4.438    65.012     0.150
     4.611    66.793     0.150
     4.660    68.637     0.150
     4.912    71.340     0.150
     5.067    72.977     0.150
     5.076    73.680     0.150
     5.100    73.590     0.150
     5.247    75.039     0.150
     5.380    77.211     0.150
     5.567    79.422     0.150
     5.622    80.875     0.150
     0.798    15.195     0.150
     1.021    18.648     0.150
     1.021    18.148     0.150
     1.482    25.203     0.150
     1.513    25.219     0.150
     1.579    25.867     0.150
     1.627    26.547     0.150
     1.957    30.336     0.150
     2.227    34.938     0.150
     2.572    39.102     0.150
     2.982    45.773     0.150
     3.035    45.703     0.150
     3.150    46.656     0.150
     3.683    54.352     0.150
     4.116    60.461     0.150
     4.585    66.258     0.150
     4.686    68.578     0.150
     5.068    73.086     0.150
     5.277    78.391     0.150
     5.282    79.148     0.150
     5.646    82.117     0.150
     5.649    82.945     0.150
     5.649    80.148     0.150
     5.700    81.258     0.150
     6.133    88.016     0.150
     6.141    88.445     0.150
     6.371    90.648     0.150
     6.837    96.703     0.150
     7.051   100.047     0.150
     7.341   102.664     0.150
     7.550   106.883     0.150
     7.550   106.945     0.150
     7.799   110.445     0.150
     8.787   122.648     0.150
     9.261   131.078     0.150
     9.261   131.148     0.150
    10.753   153.945     0.150
    11.522   160.195     0.150
    11.536   157.711     0.150
    11.554   159.219     0.150
    11.665   160.000     0.150
    12.218   169.195     0.150
    13.456   185.078     0.150
    23.878   308.547     0.150
    24.303   313.648     0.150
    26.493   333.648     0.150
    26.968   337.148     0.150
    26.968   337.047     0.150
    28.584   351.750     0.150
    29.959   365.445     0.150
    31.552   376.250     0.150
    31.902   379.906     0.150
    31.902   379.945     0.150
    33.477   392.445     0.150
    33.477   392.359     0.150
    33.909   399.047     0.150
    34.763   404.445     0.150
    36.638   419.156     0.150
    38.446   437.195     0.150
    43.739   480.445     0.150
    44.403   484.547     0.150
    45.202   491.445     0.150
    46.181   500.648     0.150
    46.488   502.906     0.150
    46.488   502.844     0.150
    48.091   514.867     0.150
    48.474   517.445     0.150
    48.474   518.555     0.150
    49.577    17.805     0.150
    52.890   549.445     0.150
    53.938   557.148     0.150
    54.213    12.500     0.150
    54.213    17.797     0.150
    55.810   570.945     0.150
    57.542   584.086     0.150
    58.408   590.086     0.150
    61.973   614.344     0.150
    61.991   617.656     0.150
    63.151    13.898     0.150
    63.151    18.203     0.150
    64.049   626.945     0.150
    64.367   629.047     0.150
    64.770   632.648     0.150
    65.049   634.625     0.150
    65.343    14.305     0.150
    65.343    23.305     0.150
    65.371    14.203     0.150
    65.371    18.000     0.150
    66.184    11.797     0.150
    66.239   641.664     0.150
    66.335   641.547     0.150
    66.479   643.047     0.150
    69.128   660.750     0.150
    69.562   662.594     0.150
    70.388   668.750     0.150
    70.392   668.250     0.150
    70.505   669.047     0.150
    70.599   668.945     0.150
    70.737   670.648     0.150
    70.797   670.047     0.150
    70.843   671.648     0.150
    71.211   673.547     0.150
    71.148   673.750     0.150
    71.357   674.547     0.150
    71.775   676.945     0.150
    71.775   676.945     0.150
    71.775    13.805     0.150
    71.775    13.836     0.150
    72.275   680.445     0.150
    72.322   680.852     0.150
    72.322   680.906     0.150
    72.521   682.156     0.150
    72.661   682.445     0.150
    72.693   682.750     0.150
    72.785   678.555     0.150
    72.785   681.547     0.150
    72.799   683.547     0.150
    72.799    12.602     0.150
    72.946   684.547     0.150
    72.946    11.898     0.150
    72.946   684.508     0.150
    73.233   685.359     0.150
    73.233   685.344     0.150
    73.245   685.945     0.150
    73.286   685.648     0.150
    73.609   688.945     0.150
    73.581   681.289     0.150
    73.581   681.250     0.150
    73.811   686.000     0.150
    74.075   690.648     0.150
    74.075   703.250     0.150
    74.288   693.250     0.150
    74.288   706.250     0.150
    74.329   691.844     0.150
    74.358   692.750     0.150
    74.344   692.648     0.150
    74.581   694.250     0.150
    74.828    13.898     0.150
    74.920   708.148     0.150
    74.920   695.945     0.150
    74.969   696.547     0.150
    74.969   710.148     0.150
    75.334    15.328     0.150
    75.367   696.945     0.150
    75.418    14.438     0.150
    75.549    14.469     0.150
    75.587    14.422     0.150
    75.601    14.438     0.150
    75.608    14.289     0.150
    75.701    12.602     0.150
    75.678    13.773     0.150
    75.682    14.680     0.150
    75.835    14.477     0.150
    75.924   700.445     0.150
    75.988    14.516     0.150
    76.005    14.500     0.150
    76.266    15.109     0.150
    76.526    14.961     0.150
    76.661    14.195     0.150
    76.661   704.156     0.150
    77.663   709.750     0.150
    77.679   711.750     0.150
    77.884   712.250     0.150
    78.046   712.344     0.150
    78.130   713.844     0.150
    79.192   716.445     0.150
    79.192  1828.344     0.150
    81.056   729.344     0.150
    81.643   731.844     0.150
    81.643   731.789     0.150
    82.885   738.750     0.150
    98.109   811.047     0.150
   151.798  1189.000     0.150
     1.065    34.553     0.150
     1.110    20.795     0.150
     1.110    36.570     0.150
     1.149    21.064     0.150
     1.332    23.824     0.150
     1.362    24.594     0.150
     1.403    25.023     0.150
     1.485    26.316     0.150
     1.642    29.273     0.150
     1.642    29.277     0.150
     1.690    29.344     0.150
     1.720    29.545     0.150
     1.998    33.949     0.150
     2.014    34.951     0.150
     2.257    38.477     0.150
     2.324    40.205     0.150
     2.513    42.705     0.150
     2.515    42.701     0.150
     2.767    45.223     0.150
     2.801    46.555     0.150
     2.801    46.553     0.150
     3.143    49.523     0.150
     3.143    49.504     0.150
     3.165    50.453     0.150
     3.265    52.189     0.150
     3.335    52.824     0.150
     3.358    52.225     0.150
     3.358    52.152     0.150
     3.412    54.035     0.150
     3.607    56.412     0.150
     3.612    56.605     0.150
     3.662    57.170     0.150
     3.706    57.771     0.150
     3.707    58.275     0.150
     4.011    61.949     0.150
     4.058    61.852     0.150
     4.092    62.971     0.150
     4.205    65.145     0.150
     4.309    65.975     0.150
     4.295    66.605     0.150
     4.406    67.385     0.150
     4.436    67.500     0.150
     4.813    73.088     0.150
     4.895    72.975     0.150
     5.274    81.363     0.150
     5.274    81.416     0.150
     5.304    79.850     0.150
     5.752    85.516     0.150
     6.069    89.564     0.150
     6.140    90.725     0.150
     6.140    90.787     0.150
     6.140    91.111     0.150
     6.600    96.857     0.150
     7.295   106.684     0.150
     7.376   108.330     0.150
     8.645   125.812     0.150
    15.974   221.625     0.150
    18.206   250.924     0.150
    21.194   282.174     0.150
     0.504    18.535     0.150
     0.796    20.617     0.150
     1.124    23.805     0.150
     1.191    24.480     0.150
     1.304    25.326     0.150
     1.518    27.166     0.150
     1.571    28.586     0.150
     1.662    29.297     0.150
     1.793    30.895     0.150
     1.852    32.207     0.150
     1.852    56.557     0.150
     1.960    33.113     0.150
     2.081    34.354     0.150
     2.380    38.916     0.150
     2.497    39.885     0.150
     2.497    39.783     0.150
     2.488    39.875     0.150
     2.498    39.342     0.150
     2.665    42.445     0.150
     2.846    44.309     0.150
     2.896    44.645     0.150
     3.101    47.838     0.150
     3.213    49.432     0.150
     3.305    50.791     0.150
     3.346    51.291     0.150
     3.364    51.717     0.150
     3.628    54.328     0.150
     3.663    54.877     0.150
     3.656    54.865     0.150
     3.870    58.883     0.150
     4.004    60.160     0.150
     4.041    60.410     0.150
     3.981    58.463     0.150
     4.061    60.627     0.150
     4.095    60.402     0.150
     4.195    62.148     0.150
     4.193    61.979     0.150
     4.520    65.914     0.150
     4.625    68.258     0.150
     4.619    67.984     0.150
     4.745    70.104     0.150
     4.775    68.629     0.150
     4.827    70.941     0.150
     4.885    71.082     0.150
     5.079    72.414     0.150
     5.102    74.768     0.150
     5.216    76.061     0.150
     5.460    78.482     0.150
     5.487    78.779     0.150
     5.487    79.945     0.150
     5.507    79.977     0.150
     5.672    80.432     0.150
     5.691    82.293     0.150
     5.754    81.525     0.150
     5.818    82.430     0.150
     5.823    83.047     0.150
     5.813    84.256     0.150
     5.946    85.967     0.150
     6.060    86.395     0.150
     6.071    87.805     0.150
     6.433    92.016     0.150
     6.543    93.777     0.150
     6.624    94.746     0.150
     6.852    97.684     0.150
     7.030    99.859     0.150
     7.112   101.758     0.150
     7.209   102.932     0.150
     7.919   112.266     0.150
     8.428   118.895     0.150
     8.892   125.664     0.150
     9.268   130.465     0.150
     9.423   132.826     0.150
     9.681   136.227     0.150
     9.803   137.660     0.150
    10.842   153.381     0.150
    12.726   177.832     0.150
    26.480   327.281     0.150
     0.079    18.801     0.150
     0.079    32.984     0.150
     0.684    20.891     0.150
     0.782    22.066     0.150
     0.819    22.168     0.150
     0.819    39.066     0.150
     0.850    22.441     0.150
     0.850    39.105     0.150
     1.145    25.109     0.150
     1.341    27.508     0.150
     1.480    28.391     0.150
     1.480    49.680     0.150
     1.537    29.219     0.150
     1.540    28.539     0.150
     1.621    29.285     0.150
     1.778    30.992     0.150
     1.863    33.398     0.150
     2.014    34.887     0.150
     2.118    32.723     0.150
     2.215    36.391     0.150
     2.215    36.441     0.150
     2.404    39.391     0.150
     2.480    39.941     0.150
     2.498    40.066     0.150
     2.573    41.453     0.150
     2.810    44.625     0.150
     3.028    47.527     0.150
     3.202    49.883     0.150
     3.202    49.805     0.150
     3.463    53.207     0.150
     3.592    54.359     0.150
     3.605    54.762     0.150
     3.782    57.074     0.150
     3.824    57.883     0.150
     4.139    61.309     0.150
     4.255    63.594     0.150
     4.314    64.562     0.150
     4.793    69.219     0.150
     5.224    74.859     0.150
     5.301    75.699     0.150
     5.746    83.914     0.150
     6.139    87.477     0.150
     6.794    96.871     0.150
     6.804    97.109     0.150
     7.153   103.293     0.150
     7.285   104.812     0.150
     7.409   105.219     0.150
     8.114   115.594     0.150
    13.057   314.594     0.150
     1.048    19.008     0.150
     1.110    20.359     0.150
     1.114    19.914     0.150
     1.319    22.492     0.150
     1.388    23.773     0.150
     1.595    26.625     0.150
     1.748    27.531     0.150
     1.748    48.141     0.150
     1.854    29.602     0.150
     2.124    33.328     0.150
     2.191    33.930     0.150
     2.317    36.148     0.150
     2.336    37.055     0.150
     2.796    43.195     0.150
     2.967    44.852     0.150
     3.170    47.578     0.150
     3.490    52.172     0.150
     3.975    58.695     0.150
     4.044    59.812     0.150
     4.168    61.711     0.150
     4.251    62.469     0.150
     4.265    62.664     0.150
     4.389    64.531     0.150
     4.765    69.633     0.150
     4.874    70.586     0.150
     4.990    72.594     0.150
     5.253    75.883     0.150
     5.417    78.352     0.150
     5.675    81.516     0.150
     5.992    86.211     0.150
     6.363    91.133     0.150
     6.395    90.609     0.150
     6.700    95.727     0.150
     6.983    99.672     0.150
     7.254   102.719     0.150
    25.963   320.805     0.150
    26.761   327.727     0.150
    55.336   622.711     0.150
    69.693   659.664     0.150
     0.518    19.686     0.150
     0.518    10.467     0.150
     1.371    20.375     0.150
     1.371    20.562     0.150
     1.517    25.895     0.150
     1.517    26.016     0.150
     2.668    39.984     0.150
     2.762    41.785     0.150
     2.822    41.365     0.150
     3.233    49.350     0.150
     3.479    51.025     0.150
     3.682    54.775     0.150
     3.912    59.025     0.150
     3.987    59.498     0.150
     4.137    59.139     0.150
     4.136    60.879     0.150
     4.580    67.457     0.150
     4.668    69.488     0.150
     4.814    68.734     0.150
     4.852    68.945     0.150
     4.953    70.865     0.150
     4.859    69.285     0.150
     4.923    72.705     0.150
     5.150    75.238     0.150
     5.334    78.568     0.150
     5.325    77.963     0.150
     5.700    82.484     0.150
     5.695    82.348     0.150
     5.826    84.412     0.150
     5.816    84.127     0.150
     6.199    89.830     0.150
     6.254    90.439     0.150
     6.449    92.516     0.150
     6.514    93.566     0.150
     6.616    96.852     0.150
     6.890    98.285     0.150
     7.234   103.414     0.150
     7.298   104.355     0.150
     7.946   110.676     0.150
     7.946   110.275     0.150
     8.168   114.305     0.150
     8.129   116.426     0.150
     8.986   128.365     0.150
     9.409   135.027     0.150
     9.446   133.586     0.150
    10.330   145.320     0.150
    10.362   149.975     0.150
    23.297   305.205     0.150
    23.346   306.461     0.150
    24.230   311.484     0.150
    24.633   318.654     0.150
    29.563   363.326     0.150
    30.585   369.574     0.150
    30.585   376.564     0.150
    35.100   411.768     0.150
    35.376   410.781     0.150
    35.726   414.904     0.150
    37.308   431.117     0.150
    38.153   436.797     0.150
    40.898   457.926     0.150
    44.313   485.979     0.150
    44.321   489.225     0.150
    44.985   490.727     0.150
    45.552   500.725     0.150
    46.991  3529.670     0.150
    46.997  3525.527     0.150
    47.009  3532.977     0.150
    47.765   520.734     0.150
    48.146  3616.029     0.150
    48.159  3619.447     0.150
    48.164  3617.252     0.150
    50.618     7.000     0.150
    59.759     7.301     0.150
    59.759    10.201     0.150
    60.695     4.701     0.150
    60.695     7.201     0.150
    62.344   620.775     0.150
    64.195   633.676     0.150
    64.195     7.000     0.150
    66.381   643.375     0.150
    66.390   647.475     0.150
    66.413   647.676     0.150
    66.413     6.500     0.150
    67.232   647.676     0.150
    67.232     6.000     0.150
    68.504   661.766     0.150
    68.949   665.738     0.150
    69.287   667.266     0.150
    69.985   671.295     0.150
    69.985   670.285     0.150
    70.689   675.586     0.150
    70.963   673.775     0.150
    71.039   678.078     0.150
    71.293   679.176     0.150
    71.293     4.299     0.150
    71.293     6.100     0.150
    71.293   718.375     0.150
    71.361   680.436     0.150
    71.361   680.225     0.150
    71.408   680.078     0.150
    71.611   681.875     0.150
    71.611   681.664     0.150
    71.699   681.195     0.150
    71.778   682.529     0.150
    72.030   683.926     0.150
    72.138   684.129     0.150
    72.267   685.541     0.150
    72.373   699.086     0.150
    72.648   687.115     0.150
    72.648   693.426     0.150
    72.648   687.398     0.150
    72.869   688.936     0.150
    72.975   689.547     0.150
    73.167   687.686     0.150
    73.344   691.836     0.150
    73.367   691.393     0.150
    73.572   693.322     0.150
    73.593   692.955     0.150
    74.262   696.812     0.150
    74.272   697.418     0.150
    74.595   698.932     0.150
    74.641   699.002     0.150
    75.441   703.672     0.150
    76.015   707.285     0.150
    76.363   709.535     0.150
    76.505   710.586     0.150
    77.032   712.785     0.150
    77.052   709.186     0.150
    77.965   715.543     0.150
    77.987   715.906     0.150
    79.293   724.885     0.150
    83.497   746.855     0.150
   109.292  8209.111     0.150
   109.303  8210.305     0.150
   109.309  8209.537     0.150
     0.526    10.730     0.150
     0.526    19.990     0.150
     0.526    10.758     0.150
     0.526    19.990     0.150
     0.933    17.350     0.150
     0.933    31.047     0.150
     1.348    20.639     0.150
     1.348    20.705     0.150
     1.348    36.020     0.150
     2.523    39.799     0.150
     2.636    40.396     0.150
     2.812    40.910     0.150
     2.978    45.234     0.150
     3.344    50.377     0.150
     3.498    51.699     0.150
     3.702    55.170     0.150
     3.711    55.658     0.150
     3.820    58.295     0.150
     4.013    59.770     0.150
     4.120    59.646     0.150
     4.348    63.082     0.150
     4.509    65.947     0.150
     4.617    67.174     0.150
     4.636    69.646     0.150
     4.697    69.434     0.150
     4.877    70.344     0.150
     4.892    70.143     0.150
     5.065    74.314     0.150
     5.164    75.020     0.150
     5.362    78.172     0.150
     5.367    78.906     0.150
     5.477    78.469     0.150
     5.716    83.000     0.150
     5.732    82.254     0.150
     5.879    83.830     0.150
     5.848    84.945     0.150
     5.850    83.709     0.150
     6.110    88.217     0.150
     6.212    90.141     0.150
     6.236    90.012     0.150
     6.381    92.383     0.150
     6.549    93.678     0.150
     6.680    96.641     0.150
     6.835    98.119     0.150
     6.899    99.545     0.150
     6.927    99.336     0.150
     6.998   100.629     0.150
     6.997   100.408     0.150
     7.175   103.320     0.150
     7.323   105.455     0.150
     7.346   105.934     0.150
     7.427   106.744     0.150
     7.447   106.580     0.150
     7.634   110.580     0.150
     7.808   112.289     0.150
     7.829   110.359     0.150
     7.928   110.459     0.150
     7.920   113.928     0.150
     7.923   112.576     0.150
     8.157   116.617     0.150
     8.282   118.285     0.150
     8.431   121.484     0.150
     8.623   123.596     0.150
     8.847   126.398     0.150
     9.103   129.363     0.150
    23.052   302.270     0.150
    27.977   349.844     0.150
    33.119   393.539     0.150
    46.962  3528.809     0.150
    46.968  3529.295     0.150
    46.980  3530.055     0.150
    48.116  3614.443     0.150
    48.130  3617.623     0.150
    48.134  3617.594     0.150
    64.199   633.070     0.150
    71.306   679.170     0.150
    71.306     4.199     0.150
    71.306     6.699     0.150
    71.306   855.570     0.150
   109.282  8212.252     0.150
   109.293  8211.893     0.150
   109.299  8213.578     0.150
     0.595    12.016     0.150
     0.595    21.396     0.150
     1.028    32.086     0.150
     1.337    37.422     0.150
     1.642    46.781     0.150
     2.619    41.172     0.150
     3.066    46.592     0.150
     3.437    51.301     0.150
     3.787    56.465     0.150
     3.798    58.248     0.150
     3.793    56.844     0.150
     3.913    59.408     0.150
     4.043    60.436     0.150
     4.106    61.174     0.150
     4.425    64.910     0.150
     4.587    67.359     0.150
     4.692    69.689     0.150
     4.930    71.568     0.150
     4.941    71.609     0.150
     5.155    75.732     0.150
     5.464    80.158     0.150
     5.637    82.727     0.150
     5.660    82.695     0.150
     5.795    84.367     0.150
     5.912    85.123     0.150
     6.053    88.391     0.150
     6.280    91.812     0.150
     6.307    91.934     0.150
     6.609    95.074     0.150
     6.924    99.887     0.150
    46.923  3531.334     0.150
    46.929  3531.855     0.150
    46.941  3530.816     0.150
    48.077  3614.809     0.150
    48.090  3616.756     0.150
    48.094  3617.172     0.150
    53.946   562.828     0.150
    54.570   567.002     0.150
    60.362   608.078     0.150
    67.314   653.652     0.150
     0.459    10.086     0.150
     0.820    15.469     0.150
     1.003    16.883     0.150
     1.184    20.168     0.150
     1.462    24.766     0.150
     1.462    44.250     0.150
     1.692    26.566     0.150
     1.783    27.453     0.150
     1.890    30.613     0.150
     2.034    31.641     0.150
     2.088    32.238     0.150
     2.673    40.133     0.150
     2.727    42.426     0.150
     2.737    41.590     0.150
     3.193    47.422     0.150
     3.316    49.148     0.150
     3.368    49.500     0.150
     3.451    51.223     0.150
     3.633    53.582     0.150
     3.693    54.938     0.150
     3.732    55.398     0.150
     3.762    55.742     0.150
     3.785    56.195     0.150
     3.829    56.492     0.150
     3.899    56.547     0.150
     3.935    58.242     0.150
     4.106    60.473     0.150
     4.171    61.340     0.150
     4.181    61.340     0.150
     4.316    63.418     0.150
     4.446    64.656     0.150
     4.445    64.605     0.150
     4.474    65.617     0.150
     4.597    66.668     0.150
     4.718    68.395     0.150
     4.685    68.523     0.150
     4.724    68.871     0.150
     4.769    69.520     0.150
     4.840    70.523     0.150
     5.055    72.555     0.150
     5.165    74.926     0.150
     5.250    75.332     0.150
     5.251    75.973     0.150
     5.402    78.055     0.150
     5.421    78.215     0.150
     5.537    79.863     0.150
     5.594    80.391     0.150
     5.595    80.434     0.150
     5.716    81.934     0.150
     5.707    81.695     0.150
     5.782    83.254     0.150
     5.848    84.289     0.150
     5.877    84.262     0.150
     5.928    84.859     0.150
     5.978    85.668     0.150
     5.931    85.457     0.150
     5.956    84.777     0.150
     5.991    85.422     0.150
     6.027    86.129     0.150
     6.024    86.094     0.150
     6.334    90.422     0.150
     6.482    92.281     0.150
     6.602    94.324     0.150
     6.658    94.719     0.150
     6.672    94.039     0.150
     6.833    97.602     0.150
     6.856    97.387     0.150
     6.931    98.008     0.150
     6.975    98.750     0.150
     6.952    99.227     0.150
     7.153   101.305     0.150
     7.171   100.926     0.150
     7.227   101.863     0.150
     7.377   103.797     0.150
     7.410   104.434     0.150
     7.435   104.898     0.150
     7.482   105.613     0.150
     7.531   107.059     0.150
     7.536   107.012     0.150
     7.812   110.051     0.150
     8.017   112.625     0.150
     8.124   114.285     0.150
     8.171   115.102     0.150
     8.202   115.609     0.150
     8.348   117.859     0.150
    12.027   165.941     0.150
     0.162     6.227     0.150
     0.293     6.625     0.150
     0.374     7.273     0.150
     0.828    29.676     0.150
     0.828    16.070     0.150
     0.828    29.672     0.150
     1.096    36.996     0.150
     1.091    20.660     0.150
     1.091    37.445     0.150
     1.422    25.746     0.150
     1.440    25.734     0.150
     1.458    25.766     0.150
     1.512    25.234     0.150
     1.512    25.980     0.150
     1.512    42.855     0.150
     1.509    25.074     0.150
     1.509    25.086     0.150
     1.535    25.453     0.150
     1.537    25.555     0.150
     1.560    27.227     0.150
     1.560    27.559     0.150
     1.560    48.770     0.150
     1.607    29.199     0.150
     1.714    30.074     0.150
     1.714    30.191     0.150
     1.714    53.488     0.150
     1.758    30.609     0.150
     1.758    56.434     0.150
     2.009    33.707     0.150
     2.242    37.855     0.150
     2.314    37.094     0.150
     2.420    39.246     0.150
     2.540    41.855     0.150
     2.827    45.770     0.150
     3.215    50.848     0.150
     3.272    51.984     0.150
     3.667    57.355     0.150
     3.748    59.070     0.150
     3.694    57.918     0.150
     3.900    60.367     0.150
     3.955    62.066     0.150
     4.024    62.359     0.150
     4.136    63.391     0.150
     4.248    66.098     0.150
     4.612    70.250     0.150
     4.887    74.594     0.150
     5.098    76.746     0.150
     5.232    78.965     0.150
     5.536    84.336     0.150
     5.618    85.176     0.150
     5.618    85.172     0.150
     5.679    85.574     0.150
     5.679    85.574     0.150
     5.708    86.895     0.150
     6.056    90.602     0.150
     6.157    92.082     0.150
     6.254    94.656     0.150
     6.254    94.656     0.150
     7.417   109.887     0.150
     7.468   110.406     0.150
     7.619   198.359     0.150
     8.203   120.625     0.150
    13.902   202.262     0.150
    58.046   596.266     0.150
     1.040    19.330     0.150
     1.114    20.811     0.150
     1.199    21.576     0.150
     1.199    38.076     0.150
     1.275    21.799     0.150
     1.275    21.771     0.150
     1.309    22.717     0.150
     1.309    40.891     0.150
     1.576    25.891     0.150
     1.620    26.980     0.150
     1.620    49.398     0.150
     1.757    29.510     0.150
     1.757    52.549     0.150
     1.914    31.109     0.150
     1.916    31.260     0.150
     1.908    31.561     0.150
     2.288    36.535     0.150
     2.288    64.967     0.150
     2.337    37.609     0.150
     2.630    41.752     0.150
     2.647    40.920     0.150
     2.740    43.084     0.150
     2.855    44.600     0.150
     2.865    44.957     0.150
     3.049    47.709     0.150
     3.049    84.398     0.150
     3.263    51.059     0.150
     3.298    50.859     0.150
     3.298    91.006     0.150
     3.589    55.270     0.150
     3.819    57.430     0.150
     3.860    58.832     0.150
     3.892    59.068     0.150
     3.892   105.092     0.150
     3.960    60.721     0.150
     3.942    60.186     0.150
     3.971    62.109     0.150
     4.055    61.285     0.150
     4.308    65.074     0.150
     4.416    67.236     0.150
     4.531    68.914     0.150
     4.543    69.049     0.150
     4.544    66.980     0.150
     4.626    69.436     0.150
     4.716    69.949     0.150
     4.788    73.008     0.150
     5.052    74.660     0.150
     5.811    85.811     0.150
     5.892    86.322     0.150
     6.166    90.490     0.150
     6.245    91.918     0.150
     6.288    92.139     0.150
     6.366    94.008     0.150
     6.754    98.141     0.150
     7.796   113.121     0.150
     7.868   113.975     0.150
     7.949   114.611     0.150
     8.503   122.363     0.150
     8.972   128.584     0.150
     9.475   134.824     0.150
    11.347   163.869     0.150
    24.886   321.230     0.150
     1.273    21.512     0.150
     1.747    30.312     0.150
     3.009    47.832     0.150
     3.204    50.162     0.150
     3.453    53.922     0.150
     5.437    82.053     0.150
     5.576    81.822     0.150
     1.022    18.938     0.150
     1.296    21.479     0.150
     1.296    36.829     0.150
     1.296    21.478     0.150
     1.101    20.674     0.150
     1.172    37.637     0.150
     1.589    46.922     0.150
     1.602    27.456     0.150
     1.853    32.219     0.150
     1.915    31.242     0.150
     1.916    30.339     0.150
     2.022    32.709     0.150
     2.089    36.438     0.150
     2.325    37.033     0.150
     2.347    39.639     0.150
     2.633    41.379     0.150
     2.715    43.244     0.150
     2.849    43.688     0.150
     2.990    47.688     0.150
     3.151    48.528     0.150
     3.270    50.634     0.150
     3.402    54.959     0.150
     3.836    58.233     0.150
     3.956    59.429     0.150
     4.116    63.869     0.150
     4.028    61.064     0.150
     4.540    67.928     0.150
     4.896    72.493     0.150
     5.024    74.585     0.150
     5.247    77.546     0.150
     7.726   112.799     0.150
     8.063   117.479     0.150
    10.544   152.259     0.150
     3.489    50.812     0.150
     0.691    13.967     0.150
     1.348    23.869     0.150
     1.348    41.389     0.150
     1.413    45.172     0.150
     1.413    45.172     0.150
     1.633    26.332     0.150
     1.666    28.910     0.150
     1.863    31.266     0.150
     1.933    30.689     0.150
     2.040    33.346     0.150
     2.226    34.955     0.150
     2.346    37.061     0.150
     2.391    39.234     0.150
     2.455    37.691     0.150
     2.517    38.758     0.150
     2.438    38.373     0.150
     2.871    44.680     0.150
     2.967    46.092     0.150
     3.096    47.449     0.150
     3.241    48.326     0.150
     3.327    50.191     0.150
     3.374    50.646     0.150
     3.336    50.842     0.150
     3.369    51.359     0.150
     3.419    51.715     0.150
     3.509    52.395     0.150
     3.541    51.947     0.150
     3.613    54.590     0.150
     3.627    54.875     0.150
     3.646    54.627     0.150
     3.713    55.811     0.150
     3.756    56.725     0.150
     3.825    57.279     0.150
     3.792    57.426     0.150
     3.884    58.221     0.150
     3.953    59.244     0.150
     3.903    58.598     0.150
     4.211    62.459     0.150
     4.232    62.992     0.150
     4.324    64.275     0.150
     4.379    65.266     0.150
     4.481    66.688     0.150
     4.419    65.549     0.150
     4.535    66.771     0.150
     4.610    68.197     0.150
     4.556    67.402     0.150
     4.584    68.115     0.150
     4.640    68.365     0.150
     4.731    69.879     0.150
     4.757    70.494     0.150
     4.923    73.207     0.150
     5.011    73.916     0.150
     5.050    74.307     0.150
     5.059    74.723     0.150
     5.102    75.258     0.150
     5.176    76.201     0.150
     5.381    78.979     0.150
     5.328    78.713     0.150
     5.340    78.469     0.150
     5.473    79.875     0.150
     5.595    81.947     0.150
     5.637    82.885     0.150
     5.737    83.119     0.150
     5.773    84.418     0.150
     6.061    87.766     0.150
     5.989    86.949     0.150
     6.083    87.551     0.150
     6.083    87.549     0.150
     6.028    87.467     0.150
     6.205    89.730     0.150
     6.205    89.734     0.150
     6.309    91.176     0.150
     6.372    92.303     0.150
     6.340    91.979     0.150
     6.532    94.486     0.150
     6.674    96.352     0.150
     6.740    97.619     0.150
     6.832    98.457     0.150
     6.841    98.598     0.150
     6.832    98.379     0.150
     6.982   100.467     0.150
     7.129   102.244     0.150
     7.341   105.299     0.150
     7.479   106.707     0.150
     7.506   108.037     0.150
     7.631   109.445     0.150
     7.706   109.418     0.150
     7.938   115.172     0.150
     8.374   119.398     0.150
    18.319   262.393     0.150
     0.485    10.000     0.150
     0.865    16.320     0.150
     0.946    16.312     0.150
     0.946    16.336     0.150
     1.200    20.930     0.150
     1.200    38.469     0.150
     2.011    31.141     0.150
     2.021    59.859     0.150
     2.162    35.047     0.150
     2.761    43.922     0.150
     2.972    45.961     0.150
     3.062    46.977     0.150
     3.171    49.578     0.150
     3.407    52.164     0.150
     3.932    58.070     0.150
     3.953    58.648     0.150
     4.118    60.578     0.150
     4.458    65.766     0.150
     4.888    71.102     0.150
     4.802    71.602     0.150
     4.875    72.250     0.150
     5.101    74.109     0.150
     5.268    76.742     0.150
     5.614    82.352     0.150
     5.794    84.258     0.150
     5.979    88.023     0.150
     7.480   107.672     0.150
     7.889   114.578     0.150
     8.197   119.102     0.150
     9.157   129.625     0.150
     9.768   137.148     0.150
    10.830   155.297     0.150
    14.311   204.500     0.150
    30.581   370.766     0.150
     1.005    17.815     0.150
     1.291    40.525     0.150
     1.314    22.192     0.150
     1.314    39.864     0.150
     1.332    21.275     0.150
     1.444    23.786     0.150
     1.447    24.521     0.150
     1.626    26.454     0.150
     1.822    28.696     0.150
     2.358    35.594     0.150
     2.346    35.701     0.150
     2.478    37.344     0.150
     2.578    39.670     0.150
     2.752    43.545     0.150
     2.805    41.971     0.150
     3.049    46.255     0.150
     3.156    47.420     0.150
     3.206    46.918     0.150
     3.418    50.971     0.150
     3.513    52.103     0.150
     3.545    51.996     0.150
     3.545    52.045     0.150
     3.534    52.791     0.150
     3.854    57.259     0.150
     3.948    57.654     0.150
     4.182    60.616     0.150
     4.182    60.614     0.150
     4.276    62.995     0.150
     4.341    63.329     0.150
     4.363    63.319     0.150
     4.590    67.345     0.150
     4.733    68.634     0.150
     4.738    68.934     0.150
     4.811    70.215     0.150
     4.867    69.438     0.150
     5.135    74.971     0.150
     5.174    75.271     0.150
     5.256    76.404     0.150
     5.426    77.951     0.150
     5.471    78.807     0.150
     5.513    79.601     0.150
     5.707    81.537     0.150
     6.249    89.812     0.150
     6.464    94.585     0.150
     6.566    94.020     0.150
     6.621    95.161     0.150
     6.857    97.804     0.150
     6.911    98.924     0.150
     7.007    99.322     0.150
     7.110   100.781     0.150
     7.306   104.469     0.150
     7.768   110.315     0.150
     8.137   115.447     0.150
     8.476   119.446     0.150
     8.783   123.997     0.150
     8.842   123.841     0.150
     8.884   124.258     0.150
    11.315   154.936     0.150
    19.083   255.726     0.150
     0.539    11.312     0.150
     0.539    20.789     0.150
     0.943    16.375     0.150
     1.471    23.090     0.150
     1.872    29.559     0.150
     1.977    30.832     0.150
     2.016    31.207     0.150
     2.120    32.648     0.150
     2.266    34.492     0.150
     2.616    39.340     0.150
     2.616    39.340     0.150
     2.675    40.047     0.150
     2.750    41.168     0.150
     2.969    44.871     0.150
     3.061    49.383     0.150
     3.061    46.016     0.150
     3.138    47.441     0.150
     3.436    50.672     0.150
     3.475    50.758     0.150
     3.678    54.391     0.150
     3.829    56.641     0.150
     4.071    59.742     0.150
     4.235    61.965     0.150
     4.268    62.918     0.150
     4.419    64.316     0.150
     4.747    69.996     0.150
     4.941    70.957     0.150
     4.898    71.391     0.150
     4.924    71.918     0.150
     5.007    72.742     0.150
     5.076    73.430     0.150
     5.088    73.641     0.150
     5.103    73.340     0.150
     5.180    74.738     0.150
     5.203    74.230     0.150
     5.232    76.277     0.150
     5.266    76.418     0.150
     5.424    78.316     0.150
     5.559    78.988     0.150
     5.660    81.617     0.150
     5.933    85.496     0.150
     6.102    86.051     0.150
     6.102    86.055     0.150
     6.383    90.426     0.150
     6.531    93.008     0.150
     6.741    96.035     0.150
     6.945    97.383     0.150
     6.945    97.383     0.150
     7.026   100.062     0.150
     7.197   102.953     0.150
     8.002   113.379     0.150
     8.115   114.750     0.150
     8.175   117.102     0.150
     8.395   117.316     0.150
     8.793   124.770     0.150
     9.611   136.531     0.150
     9.905   138.711     0.150
     0.656    25.711     0.150
     0.776    16.250     0.150
     0.776    28.945     0.150
     1.055    19.227     0.150
     1.055    33.062     0.150
     1.350    22.664     0.150
     1.350    39.547     0.150
     1.446    24.297     0.150
     1.597    26.406     0.150
     1.633    26.531     0.150
     1.633    45.852     0.150
     1.772    28.500     0.150
     1.939    31.258     0.150
     2.041    32.766     0.150
     2.219    34.844     0.150
     2.232    34.523     0.150
     2.328    35.766     0.150
     2.328    62.078     0.150
     2.519    38.062     0.150
     2.520    38.680     0.150
     2.642    40.656     0.150
     2.667    40.656     0.150
     2.837    42.852     0.150
     3.164    47.672     0.150
     3.325    50.000     0.150
     3.430    51.375     0.150
     3.645    54.180     0.150
     3.681    54.984     0.150
     3.732    55.141     0.150
     3.737    55.859     0.150
     3.889    56.477     0.150
     4.012    59.008     0.150
     4.204    60.953     0.150
     4.634    66.688     0.150
     4.871    69.695     0.150
     5.002    72.492     0.150
     5.114    73.969     0.150
     5.187    75.523     0.150
     5.451    79.078     0.150
     5.771    82.758     0.150
     5.870    83.805     0.150
     5.875    84.281     0.150
     6.011    86.336     0.150
     6.031    86.539     0.150
     6.398    91.375     0.150
     6.542    93.547     0.150
     7.280   103.883     0.150
     7.333   103.258     0.150
     7.526   106.992     0.150
     7.584   106.867     0.150
     7.674   108.891     0.150
     7.712   109.656     0.150
     7.953   111.641     0.150
     8.384   118.523     0.150
     8.510   119.812     0.150
     9.153   128.469     0.150
     0.640    14.605     0.150
     1.023    33.535     0.150
     1.208    21.172     0.150
     1.208    21.176     0.150
     1.208    37.215     0.150
     1.531    25.355     0.150
     1.657    47.516     0.150
     1.657    47.543     0.150
     1.875    51.273     0.150
     1.985    31.418     0.150
     1.985    55.609     0.150
     2.125    33.395     0.150
     2.125    58.469     0.150
     2.196    34.367     0.150
     2.196    61.105     0.150
     2.589    39.867     0.150
     2.637    40.094     0.150
     2.973    44.992     0.150
     3.189    48.793     0.150
     3.373    50.270     0.150
     3.376    50.121     0.150
     3.517    52.031     0.150
     3.585    53.941     0.150
     3.625    54.020     0.150
     3.628    53.969     0.150
     3.757    55.918     0.150
     4.180    61.770     0.150
     4.229    62.293     0.150
     4.245    61.211     0.150
     4.349    63.770     0.150
     4.675    68.562     0.150
     4.838    69.922     0.150
     4.931    71.941     0.150
     5.036    72.895     0.150
     5.072    73.418     0.150
     5.144    75.156     0.150
     5.259    75.895     0.150
     5.282    76.930     0.150
     5.283    76.074     0.150
     5.288    76.742     0.150
     5.362    77.344     0.150
     5.413    77.324     0.150
     5.413    77.145     0.150
     5.644    79.730     0.150
     5.825    83.941     0.150
     5.876    84.730     0.150
     6.012    86.352     0.150
     6.025    86.031     0.150
     6.025    86.031     0.150
     6.141    88.730     0.150
     6.175    88.031     0.150
     6.175    87.941     0.150
     6.534    93.094     0.150
     6.565    92.711     0.150
     6.594    93.312     0.150
     6.580    93.980     0.150
     6.720    95.211     0.150
     6.810    97.207     0.150
     6.954    99.344     0.150
     6.975    97.941     0.150
     7.051   100.316     0.150
     7.239   102.430     0.150
     7.239   102.441     0.150
     7.319   103.883     0.150
     7.524   106.711     0.150
     7.591   106.996     0.150
     7.591   107.043     0.150
     8.021   114.383     0.150
     8.111   113.711     0.150
     8.249   116.598     0.150
     8.469   118.043     0.150
     8.595   206.543     0.150
     8.609   122.008     0.150
     8.637   121.863     0.150
     8.736   123.441     0.150
     8.763   123.297     0.150
     8.775   124.703     0.150
     8.774   123.375     0.150
     8.847   123.445     0.150
     9.319   130.590     0.150
     9.434   132.586     0.150
     9.554   135.719     0.150
     9.830   135.332     0.150
     9.988   139.434     0.150
     9.997   140.613     0.150
    34.270   400.844     0.150
    34.293   400.145     0.150
    49.166   924.344     0.150
    52.524   544.145     0.150
    53.488   615.012     0.150
    54.910   560.633     0.150
    55.012   562.102     0.150
    55.290   559.844     0.150
    55.326   564.941     0.150
    58.263   589.543     0.150
    61.563   607.844     0.150
    62.621   614.543     0.150
    63.276   619.844     0.150
    63.372   755.441     0.150
    64.252   625.441     0.150
    65.720   634.344     0.150
    68.607   654.043     0.150
    69.868   661.344     0.150
    69.981   661.844     0.150
    70.034   662.645     0.150
    70.323   664.043     0.150
    70.627   666.645     0.150
    70.835   667.645     0.150
    71.223   669.742     0.150
    72.290   685.344     0.150
    72.315   675.242     0.150
    72.323   675.145     0.150
    72.816   679.441     0.150
    72.816   679.242     0.150
    73.804   684.844     0.150
    73.834   685.543     0.150
    73.857   687.242     0.150
    74.491   689.645     0.150
    74.546   691.043     0.150
    83.055   736.145     0.150
    83.055   736.543     0.150
     0.371    10.729     0.150
     0.371    19.574     0.150
     0.371    19.574     0.150
     0.914    16.898     0.150
     1.028    18.703     0.150
     1.028    32.750     0.150
     1.247    37.436     0.150
     1.247    37.436     0.150
     1.318    22.992     0.150
     1.410    23.203     0.150
     1.410    23.184     0.150
     1.596    25.678     0.150
     1.704    27.332     0.150
     1.668    46.900     0.150
     1.760    27.979     0.150
     2.136    33.004     0.150
     2.282    35.479     0.150
     2.577    39.154     0.150
     2.689    40.678     0.150
     2.771    41.703     0.150
     3.106    47.031     0.150
     3.288    48.074     0.150
     3.266    49.582     0.150
     3.339    48.971     0.150
     3.499    52.547     0.150
     3.612    52.803     0.150
     3.612    52.904     0.150
     3.833    56.912     0.150
     4.314    64.195     0.150
     4.705    68.531     0.150
     4.942    71.670     0.150
     5.171    76.104     0.150
     5.501    79.715     0.150
     5.454    78.311     0.150
     5.511    80.131     0.150
     6.219    90.164     0.150
     6.384    90.754     0.150
     6.538    94.143     0.150
     6.533    94.123     0.150
     6.537    93.975     0.150
     6.575    92.303     0.150
     6.575    92.303     0.150
     6.738    96.355     0.150
     6.765    95.803     0.150
     6.756    96.857     0.150
     7.075   100.502     0.150
     7.192   101.604     0.150
     7.394   104.609     0.150
     7.617   108.568     0.150
     7.716   109.900     0.150
     7.722   109.148     0.150
     7.919   112.895     0.150
     8.628   120.789     0.150
     8.872   124.555     0.150
     8.978   124.910     0.150
     9.045   126.295     0.150
     9.674   133.205     0.150
     9.716   135.996     0.150
     9.883   138.703     0.150
     9.955   139.127     0.150
     0.335    15.543     0.150
     0.335    15.770     0.150
     0.841    13.258     0.150
     0.841    23.379     0.150
     0.841    23.371     0.150
     1.065    18.992     0.150
     1.065    33.730     0.150
     1.065    33.730     0.150
     1.082    18.871     0.150
     1.744    27.641     0.150
     1.744    27.570     0.150
     1.744    27.730     0.150
     1.853    28.949     0.150
     2.030    30.191     0.150
     2.030    53.027     0.150
     2.492    38.887     0.150
     3.248    49.508     0.150
     3.352    49.984     0.150
     4.606    67.137     0.150
     4.611    68.570     0.150
     4.663    69.375     0.150
     5.280    75.949     0.150
     5.862    83.176     0.150
     5.862    83.270     0.150
     5.862    83.172     0.150
     6.219    87.871     0.150
     6.452    91.215     0.150
     6.560    93.672     0.150
     7.387   104.688     0.150
     9.038   125.945     0.150
     9.038   125.969     0.150
     9.038   125.969     0.150
     9.259   129.250     0.150
    10.618   149.297     0.150
    10.729   151.070     0.150
    13.432   188.754     0.150
    13.610   186.469     0.150
    14.543   199.082     0.150
    15.264   388.195     0.150
    15.264   211.672     0.150
    19.767   267.172     0.150
    20.962   279.570     0.150
    23.593   306.070     0.150
    27.160   337.770     0.150
    28.298   347.969     0.150
    29.266   358.172     0.150
    29.266   358.180     0.150
    33.807   396.102     0.150
    33.807   554.949     0.150
    33.898   400.270     0.150
    36.936   422.262     0.150
    36.936   422.281     0.150
    38.565   434.570     0.150
    38.705   442.180     0.150
    38.981   444.031     0.150
    39.856   450.172     0.150
    41.535   462.469     0.150
    42.040   469.320     0.150
    43.977   483.172     0.150
    43.977   483.461     0.150
    44.596   488.270     0.150
    44.596   488.262     0.150
    45.449   494.172     0.150
    46.094   497.422     0.150
    46.340   501.422     0.150
    47.702   512.469     0.150
    48.105   514.430     0.150
    48.373   517.770     0.150
    48.373   517.832     0.150
    48.581   530.871     0.150
    49.875   541.570     0.150
    49.875   602.270     0.150
    55.781   571.871     0.150
    55.781   571.832     0.150
    58.968    11.699     0.150
    58.968    18.199     0.150
    59.704   596.871     0.150
    59.907    11.199     0.150
    59.907    18.500     0.150
    62.265   616.871     0.150
    62.265   616.871     0.150
    63.388    13.199     0.150
    63.515   625.770     0.150
    64.296   629.719     0.150
    64.701   632.582     0.150
    65.089   636.172     0.150
    65.589    13.000     0.150
    66.152   642.871     0.150
    66.152   642.879     0.150
    66.152   643.129     0.150
    66.449    11.500     0.150
    66.449    20.500     0.150
    66.812   647.570     0.150
    68.343   655.969     0.150
    69.321   916.070     0.150
    69.453   663.871     0.150
    69.818   665.148     0.150
    70.641   671.379     0.150
    70.682    12.500     0.150
    70.682    17.500     0.150
    70.711   671.871     0.150
    70.714   670.770     0.150
    70.834   671.770     0.150
    70.905   672.422     0.150
    71.389   675.711     0.150
    71.535   676.469     0.150
    71.567   677.160     0.150
    71.681   677.371     0.150
    72.073   679.672     0.150
    72.066   679.344     0.150
    72.066   679.371     0.150
    72.066    14.199     0.150
    72.066   679.371     0.150
    72.065   679.961     0.150
    72.568   682.570     0.150
    72.568   682.566     0.150
    72.610   683.129     0.150
    72.720   683.949     0.150
    72.795   684.230     0.150
    72.848   684.672     0.150
    72.848   684.781     0.150
    73.095   684.570     0.150
    73.103   684.570     0.150
    73.103   684.570     0.150
    73.243   686.871     0.150
    73.521   686.969     0.150
    73.534   688.199     0.150
    73.543   688.609     0.150
    73.849   690.230     0.150
    73.881   688.270     0.150
    74.232   692.633     0.150
    74.274   692.969     0.150
    74.274   692.969     0.150
    74.298   693.070     0.150
    74.298   693.059     0.150
    74.381   693.070     0.150
    74.575   692.871     0.150
    74.591   695.469     0.150
    74.689   695.172     0.150
    74.888   696.570     0.150
    75.151    12.500     0.150
    75.221   698.270     0.150
    75.267   699.172     0.150
    75.267   699.191     0.150
    75.293   698.371     0.150
    75.600   700.230     0.150
    75.683   699.270     0.150
    75.772   701.531     0.150
    75.838   702.371     0.150
    75.878   702.469     0.150
    76.168   702.172     0.150
    76.236   703.871     0.150
    76.283   704.629     0.150
    33.659   706.750     0.150
    76.954   708.281     0.150
    77.039   708.281     0.150
    77.129   708.770     0.150
    77.977   713.672     0.150
    78.197   711.172     0.150
    78.386   713.852     0.150
    78.415   715.469     0.150
    78.438   715.969     0.150
    78.483   716.730     0.150
    78.621   716.672     0.150
    78.644   716.469     0.150
    78.820   718.832     0.150
    79.122  1013.270     0.150
    79.136   720.070     0.150
    79.358   720.371     0.150
    79.522   717.570     0.150
    80.995   730.262     0.150
    81.079   730.770     0.150
    82.220   736.832     0.150
    82.397   737.270     0.150
    82.503   736.012     0.150
    83.426   744.070     0.150
    84.057   744.969     0.150
   145.923  1172.270     0.150
   159.981  1230.340     0.150
     1.229    39.672     0.150
     3.556    51.582     0.150
     9.094   126.973     0.150
     9.269   129.594     0.150
    10.511   146.395     0.150
    11.853   164.973     0.150
    12.574   174.473     0.150
    12.734   176.535     0.150
    13.578   187.172     0.150
    47.878  3602.695     0.150
    47.892  3607.246     0.150
    47.896  3605.148     0.150
     0.614    13.834     0.150
     0.666    13.938     0.150
     0.666    13.957     0.150
     0.666    14.010     0.150
     1.053    18.613     0.150
     1.150    19.959     0.150
     1.289    22.500     0.150
     1.481    24.068     0.150
     1.518    25.686     0.150
     1.823    50.584     0.150
     1.865    29.811     0.150
     1.892    52.918     0.150
     1.892    29.707     0.150
     2.542    37.279     0.150
     2.588    38.742     0.150
     2.600    70.645     0.150
     2.701    41.123     0.150
     2.701    71.807     0.150
     2.981    44.895     0.150
     3.391    86.914     0.150
     3.405    50.770     0.150
     3.506    51.559     0.150
     3.554    53.047     0.150
     3.820    55.738     0.150
     3.820    55.818     0.150
     3.917    58.170     0.150
     4.140    61.443     0.150
     5.026    73.092     0.150
     5.327    77.201     0.150
     5.478    78.719     0.150
     5.643    81.799     0.150
     5.682    81.619     0.150
     6.735    95.555     0.150
     6.882    95.770     0.150
     7.002    98.873     0.150
     7.327   104.770     0.150
     7.633   108.598     0.150
     7.975   112.869     0.150
     8.494   120.469     0.150
     8.601   121.217     0.150
    10.436   146.193     0.150
    10.460   147.855     0.150
    10.555   148.119     0.150
    13.232   183.344     0.150
    23.511   307.439     0.150
    26.756   333.920     0.150
    26.783   338.139     0.150
    33.080   390.520     0.150
    33.080   392.680     0.150
    33.449   395.670     0.150
    38.335   433.719     0.150
    38.454   435.789     0.150
    41.931   464.459     0.150
    42.713   472.219     0.150
    42.713   473.889     0.150
    44.156   485.039     0.150
    46.868   503.469     0.150
    47.401   508.920     0.150
    47.401   511.729     0.150
    48.013   514.080     0.150
    49.219   523.219     0.150
    54.390   561.920     0.150
    55.384   567.469     0.150
    58.644   589.219     0.150
    58.865    14.199     0.150
    59.773    16.100     0.150
    59.773    23.000     0.150
    60.523   602.119     0.150
    63.334   620.930     0.150
    63.470   621.770     0.150
    64.227   626.840     0.150
    65.746   636.520     0.150
    66.267    21.900     0.150
    66.601   887.318     0.150
    67.258   647.859     0.150
    67.288   638.719     0.150
    67.485   894.920     0.150
    68.496   654.299     0.150
    68.597   654.109     0.150
    69.393   661.158     0.150
    69.586   662.510     0.150
    69.784   662.369     0.150
    69.809   661.568     0.150
    69.961   663.459     0.150
    70.055   664.488     0.150
    70.104   664.119     0.150
    70.104    18.500     0.150
    70.239   665.109     0.150
    70.577   667.068     0.150
    70.510   667.209     0.150
    70.612   668.229     0.150
    70.638   668.629     0.150
    70.728   669.250     0.150
    70.811   669.619     0.150
    70.811   669.529     0.150
    70.943   670.609     0.150
    71.001   671.619     0.150
    71.001   671.619     0.150
    71.003   670.979     0.150
    71.049   670.920     0.150
    71.058   670.000     0.150
    71.091   671.119     0.150
    71.122   671.719     0.150
    71.122   671.779     0.150
    71.126   671.318     0.150
    71.126   671.379     0.150
    71.283   670.850     0.150
    71.283   670.729     0.150
    71.303   672.719     0.150
    71.303   672.979     0.150
    71.538   673.920     0.150
    71.538   673.969     0.150
    71.545   674.129     0.150
    71.606   674.559     0.150
    71.622   674.020     0.150
    71.622   674.068     0.150
    71.841   675.229     0.150
    71.923   676.279     0.150
    71.950   676.059     0.150
    72.240   678.307     0.150
    72.240   678.359     0.150
    72.243   678.359     0.150
    72.359   678.496     0.150
    72.359   679.010     0.150
    72.444   679.469     0.150
    72.482   679.119     0.150
    72.580   677.520     0.150
    72.591   680.229     0.150
    72.607   680.568     0.150
    72.675   681.119     0.150
    72.681   680.420     0.150
    72.782   679.920     0.150
    72.836   682.020     0.150
    72.828   681.609     0.150
    72.872   680.930     0.150
    72.998   683.219     0.150
    73.033   683.318     0.150
    73.060   683.510     0.150
    73.156   683.340     0.150
    73.300   684.119     0.150
    73.333   685.020     0.150
    73.386   684.920     0.150
    73.552   684.600     0.150
    73.592   685.059     0.150
    73.672   685.619     0.150
    73.855   685.920     0.150
    73.925   688.520     0.150
    73.988   689.020     0.150
    73.988   689.080     0.150
    74.288   689.979     0.150
    74.330   690.920     0.150
    74.330   690.979     0.150
    74.996   694.479     0.150
    75.151   694.680     0.150
    75.251   694.467     0.150
    75.251   694.420     0.150
    75.563   697.219     0.150
    75.598   698.779     0.150
    76.132   700.219     0.150
    76.292   699.520     0.150
    76.292   699.580     0.150
    76.325   700.818     0.150
    76.551   701.920     0.150
    76.799   703.619     0.150
    76.815   703.920     0.150
    76.879   704.818     0.150
    77.077   705.250     0.150
    77.193   705.719     0.150
    77.193   706.129     0.150
    77.292   707.219     0.150
    77.276   708.129     0.150
    77.502   707.270     0.150
    77.502   707.359     0.150
    77.532   708.119     0.150
    77.578   994.719     0.150
    78.999    21.199     0.150
    80.099   721.438     0.150
    80.463   722.510     0.150
    80.463   722.520     0.150
    80.941   725.619     0.150
    81.999   732.920     0.150
    81.999   732.979     0.150
    83.158   738.520     0.150
     1.177    22.406     0.150
     1.120    20.742     0.150
     1.120    20.938     0.150
     1.414    24.188     0.150
     1.672    28.672     0.150
     1.965    31.727     0.150
     2.012    31.922     0.150
     2.310    36.453     0.150
     2.809    43.406     0.150
     2.874    42.969     0.150
     3.058    46.656     0.150
     3.362    51.148     0.150
     3.482    52.344     0.150
     3.763    54.398     0.150
     4.145    61.016     0.150
     4.340    63.117     0.150
     4.651    68.102     0.150
     4.839    70.227     0.150
     5.498    79.219     0.150
     8.890   127.023     0.150
     9.367   132.008     0.150
    11.328   159.133     0.150
    24.017    20.773     0.150
    25.885    21.492     0.150
    36.703   417.492     0.150
    47.874   508.266     0.150
    52.198   609.102     0.150
    53.871    24.203     0.150
    64.789    22.297     0.150
    70.525   663.375     0.150
    73.770    24.297     0.150
    79.410   720.516     0.150
     0.311    12.963     0.150
     1.000    18.787     0.150
     1.000    32.818     0.150
     1.062    20.513     0.150
     1.127    20.285     0.150
     1.127    35.318     0.150
     1.127    35.318     0.150
     1.371    23.713     0.150
     1.371    41.140     0.150
     1.411    24.312     0.150
     1.477    24.912     0.150
     1.558    26.088     0.150
     1.558    45.480     0.150
     1.578    47.292     0.150
     1.578    47.292     0.150
     1.978    31.412     0.150
     1.979    31.221     0.150
     2.106    33.120     0.150
     2.106    56.706     0.150
     2.146    34.213     0.150
     2.183    34.690     0.150
     2.262    35.363     0.150
     3.476    52.238     0.150
     3.568    53.338     0.150
     3.991    58.253     0.150
     5.521    79.113     0.150
     7.663   108.490     0.150
     8.380   118.307     0.150
     8.659   125.152     0.150
     8.874   124.787     0.150
    10.318   142.273     0.150
    55.198   560.577     0.150
   148.448  1177.206     0.150
     0.150    31.943     0.150
     1.024    41.061     0.150
     1.037    40.803     0.150
     1.037    22.582     0.150
     1.037    40.547     0.150
     0.917    37.936     0.150
     0.917    37.936     0.150
     1.041    41.678     0.150
     1.500    27.734     0.150
     1.500    49.932     0.150
     1.500    49.932     0.150
     1.445    48.025     0.150
     1.554    51.096     0.150
     1.560    27.713     0.150
     1.572    28.143     0.150
     1.910    32.521     0.150
     1.910    58.645     0.150
     1.910    58.645     0.150
     2.211    64.281     0.150
     2.347    38.361     0.150
     2.347    65.307     0.150
     2.497    67.525     0.150
     2.497    67.525     0.150
     2.491    39.973     0.150
     2.762    43.799     0.150
     2.663    41.559     0.150
     3.225    49.656     0.150
     3.253    85.316     0.150
     3.482    53.383     0.150
     3.640    54.852     0.150
     3.699    56.469     0.150
     3.699    97.924     0.150
     3.842   101.562     0.150
     3.933   103.309     0.150
     4.069    60.871     0.150
     4.148    62.143     0.150
     4.194    63.035     0.150
     4.194   110.117     0.150
     4.255    62.043     0.150
     4.387   112.164     0.150
     4.488    64.662     0.150
     4.488    64.742     0.150
     4.599    67.443     0.150
     4.771    70.818     0.150
     4.770   121.336     0.150
     5.051   130.387     0.150
     5.378   138.857     0.150
     5.577    81.014     0.150
     5.657   144.859     0.150
     5.865   148.904     0.150
     5.962    84.943     0.150
     6.214    88.914     0.150
     6.214    89.043     0.150
     6.687    95.031     0.150
     6.687    95.043     0.150
     6.687   170.543     0.150
     6.953   100.418     0.150
     7.024   177.068     0.150
     7.162   102.682     0.150
     7.148   180.615     0.150
     7.321   183.775     0.150
     7.370   103.469     0.150
     7.370   183.803     0.150
     7.418   105.543     0.150
     7.418   185.492     0.150
     7.435   104.543     0.150
     7.501   189.420     0.150
     7.723   109.973     0.150
     7.737   192.758     0.150
     7.781   195.195     0.150
     7.768   195.020     0.150
     7.864   112.631     0.150
     7.864   112.742     0.150
     7.864   194.535     0.150
     7.915   113.031     0.150
     8.047   114.617     0.150
     8.229   116.451     0.150
     8.267   204.248     0.150
     8.334   205.307     0.150
     8.581   121.617     0.150
     8.771   124.475     0.150
     9.018   223.098     0.150
     9.199   128.070     0.150
     9.308   130.393     0.150
    10.055   140.969     0.150
    10.087   141.594     0.150
    10.087   249.055     0.150
    10.280   144.955     0.150
    10.628   262.439     0.150
    10.634   148.031     0.150
    10.766   148.844     0.150
    11.595   158.482     0.150
    11.594   159.031     0.150
    11.998   164.078     0.150
    12.215   303.242     0.150
    12.671   173.162     0.150
    12.766   173.820     0.150
    13.029   322.623     0.150
    13.295   328.463     0.150
    13.458   187.729     0.150
    13.870   189.742     0.150
    13.915   192.055     0.150
    19.425   257.703     0.150
    20.254   265.543     0.150
    23.182   298.543     0.150
    26.069   323.943     0.150
    26.372   328.242     0.150
    26.524   324.943     0.150
    27.193   331.943     0.150
    27.193   331.943     0.150
    27.328   332.643     0.150
    27.328   334.963     0.150
    28.645   347.043     0.150
    28.979   348.844     0.150
    30.963   366.344     0.150
    32.123   374.844     0.150
    32.123   374.754     0.150
    34.203   395.742     0.150
    34.203   395.604     0.150
    34.550   397.068     0.150
    35.542    23.801     0.150
    35.542   403.504     0.150
    37.912   425.943     0.150
    39.691   441.242     0.150
    42.005   499.943     0.150
    42.385   458.543     0.150
    42.486   464.652     0.150
    44.837   480.273     0.150
    45.281   485.443     0.150
    45.334   485.953     0.150
    45.381   486.043     0.150
    45.476   486.393     0.150
    47.325   501.113     0.150
    47.688   812.480     0.150
    47.688   504.043     0.150
    47.688   503.803     0.150
    47.753   505.043     0.150
    48.576   552.943     0.150
    48.525   511.043     0.150
    48.584   510.061     0.150
    49.120   516.143     0.150
    49.270   516.902     0.150
    51.580   532.742     0.150
    53.387   547.143     0.150
    54.125   613.344     0.150
    54.216   555.844     0.150
    54.216    27.100     0.150
    54.216   610.543     0.150
    54.474   554.844     0.150
    58.785    24.500     0.150
    58.785    39.600     0.150
    62.542   607.393     0.150
    62.701   610.844     0.150
    62.944   612.143     0.150
    63.504   616.373     0.150
    64.375    45.900     0.150
    64.566    45.500     0.150
    65.047   625.943     0.150
    65.090   626.232     0.150
    65.294    45.400     0.150
    65.602    30.900     0.150
    65.602    45.400     0.150
    65.602   903.844     0.150
    66.476   658.143     0.150
    66.476   634.043     0.150
    67.365   641.943     0.150
    67.468   886.643     0.150
    67.819   643.924     0.150
    69.093   652.014     0.150
    69.107   651.652     0.150
    69.263   653.104     0.150
    69.441   654.184     0.150
    69.547   655.053     0.150
    69.798   656.301     0.150
    69.901   656.854     0.150
    69.836   657.072     0.150
    70.047   657.732     0.150
    70.277   658.443     0.150
    70.277   658.344     0.150
    70.769   661.043     0.150
    70.774   665.633     0.150
    70.943   662.742     0.150
    71.005   662.643     0.150
    71.158   664.143     0.150
    71.185   664.443     0.150
    71.190   664.943     0.150
    71.225   664.742     0.150
    71.245   663.043     0.150
    71.245   662.943     0.150
    71.263   664.643     0.150
    71.305   664.543     0.150
    71.305   664.543     0.150
    71.436   665.742     0.150
    71.694   667.242     0.150
    71.734   666.943     0.150
    71.734   666.943     0.150
    71.746   668.344     0.150
    71.924   669.174     0.150
    72.067   669.643     0.150
    72.219   669.943     0.150
    72.234   672.383     0.150
    72.484   671.943     0.150
    72.490   672.344     0.150
    72.491   671.742     0.150
    72.550   671.742     0.150
    72.823   673.742     0.150
    72.955   675.363     0.150
    72.989   675.344     0.150
    73.053   675.844     0.150
    73.402   676.742     0.150
    73.402   676.742     0.150
    73.456   678.344     0.150
    73.466   678.543     0.150
    73.828   678.143     0.150
    73.828   678.242     0.150
    74.013   681.742     0.150
    74.328   682.143     0.150
    74.390   682.443     0.150
    75.032   686.043     0.150
    75.202   687.643     0.150
    75.482   687.963     0.150
    76.126   691.742     0.150
    76.143   693.344     0.150
    76.358   693.715     0.150
    76.358   693.742     0.150
    76.510   696.344     0.150
    76.569   696.143     0.150
    76.601   695.373     0.150
    76.601   695.344     0.150
    76.663   690.043     0.150
    76.663  1261.443     0.150
    76.789   696.143     0.150
    76.876   697.742     0.150
    76.958   698.443     0.150
    76.958   697.844     0.150
    77.116   703.492     0.150
    77.156   698.543     0.150
    77.281   699.742     0.150
    77.502   700.242     0.150
    77.612   706.242     0.150
    79.767   714.242     0.150
    80.303   715.742     0.150
    80.434   718.242     0.150
    81.900   725.643     0.150
    81.992   725.643     0.150
    82.133   725.943     0.150
    82.915   728.742     0.150
    91.764   773.043     0.150
   143.827  1156.723     0.150
   143.827  1156.742     0.150
     0.227     7.958     0.150
     0.227    14.207     0.150
     0.227    14.207     0.150
     0.701    13.504     0.150
     0.701    24.098     0.150
     0.816    15.052     0.150
     0.816    26.732     0.150
     1.646    26.185     0.150
     1.646    46.638     0.150
     1.646    46.638     0.150
     1.658    27.159     0.150
     1.658    47.615     0.150
     1.658    47.615     0.150
     1.638    25.771     0.150
     1.740    27.284     0.150
     2.081    32.359     0.150
     2.777    42.076     0.150
     2.920    43.465     0.150
     3.413    50.752     0.150
     3.468    51.296     0.150
     3.821    56.215     0.150
     3.838    55.498     0.150
     4.039    59.617     0.150
     4.049    59.817     0.150
     4.207    61.896     0.150
     4.325    63.809     0.150
     4.326    63.496     0.150
     4.496    65.580     0.150
     4.533    66.128     0.150
     4.607    68.224     0.150
     4.852    71.062     0.150
     4.961    71.970     0.150
     5.005    72.615     0.150
     5.123    74.292     0.150
     5.132    73.521     0.150
     5.478    79.054     0.150
     5.499    79.812     0.150
     5.649    81.089     0.150
     5.703    82.295     0.150
     5.771    83.143     0.150
     6.035    86.068     0.150
     6.057    86.433     0.150
     6.214    89.646     0.150
     6.230    89.219     0.150
     6.380    91.604     0.150
     6.468    92.392     0.150
     6.477    92.657     0.150
     6.628    94.171     0.150
     6.667    95.044     0.150
     6.877    98.533     0.150
     6.997    99.380     0.150
     7.041   100.582     0.150
     7.219   102.727     0.150
     7.620   107.385     0.150
     7.708   109.141     0.150
     8.041   113.949     0.150
     8.043   114.755     0.150
     8.115   115.093     0.150
     8.206   116.660     0.150
     8.415   119.528     0.150
     8.795   123.785     0.150
    13.073   187.284     0.150
    75.055   699.784     0.150
    80.223   723.114     0.150
     0.218    12.305     0.150
     0.868    26.672     0.150
     1.094    18.422     0.150
     1.094    33.016     0.150
     1.094    33.016     0.150
     1.086    18.703     0.150
     1.086    33.805     0.150
     1.086    33.805     0.150
     1.436    23.781     0.150
     1.686    26.078     0.150
     1.691    27.688     0.150
     1.691    49.688     0.150
     1.965    30.250     0.150
     1.965    53.289     0.150
     2.305    35.281     0.150
     2.658    39.609     0.150
     2.985    44.875     0.150
     3.021    45.289     0.150
     3.178    47.180     0.150
     3.284    48.828     0.150
     3.420    50.492     0.150
     3.466    51.086     0.150
     3.595    52.648     0.150
     3.597    52.828     0.150
     3.867    56.773     0.150
     3.905    57.594     0.150
     4.009    58.156     0.150
     3.971    58.430     0.150
     4.028    58.883     0.150
     4.032    59.172     0.150
     4.347    63.672     0.150
     4.443    64.898     0.150
     4.540    66.172     0.150
     4.665    67.852     0.150
     4.858    70.258     0.150
     5.038    72.562     0.150
     5.583    80.102     0.150
     6.116    88.250     0.150
    56.160   573.250     0.150
     0.542    21.727     0.150
     1.018    17.820     0.150
     1.135    19.312     0.150
     1.505    24.281     0.150
     1.943    30.383     0.150
     2.057    31.883     0.150
     2.521    38.406     0.150
     2.674    40.109     0.150
     3.083    47.742     0.150
     3.359    50.031     0.150
     3.511    52.688     0.150
     4.196    61.734     0.150
     4.296    64.086     0.150
     8.965   128.977     0.150
     0.208    17.564     0.150
     0.755    20.574     0.150
     0.937    22.049     0.150
     0.937    38.498     0.150
     0.937    38.498     0.150
     1.020    22.291     0.150
     1.020    39.178     0.150
     1.020    39.178     0.150
     1.370    46.365     0.150
     1.370    46.365     0.150
     1.540    28.334     0.150
     1.524    28.248     0.150
     1.524    50.199     0.150
     1.524    50.199     0.150
     1.598    28.748     0.150
     1.598    50.566     0.150
     1.651    29.234     0.150
     1.778    54.488     0.150
     1.778    54.488     0.150
     2.020    58.762     0.150
     2.093    35.799     0.150
     2.205    64.861     0.150
     2.221    36.803     0.150
     2.268    37.305     0.150
     2.365    38.990     0.150
     2.472    39.510     0.150
     2.663    41.596     0.150
     2.780    43.453     0.150
     2.780    75.994     0.150
     3.025    47.084     0.150
     3.120    48.227     0.150
     3.156    49.000     0.150
     3.211    49.070     0.150
     3.391    51.994     0.150
     3.537    53.641     0.150
     3.566    55.160     0.150
     3.604    54.250     0.150
     3.710    56.299     0.150
     3.810    57.340     0.150
     3.965    59.674     0.150
     4.505    65.170     0.150
     4.709    69.186     0.150
     4.801    68.980     0.150
     5.183    76.648     0.150
     5.471    78.939     0.150
     5.571    79.922     0.150
     5.792    83.029     0.150
     5.935    85.221     0.150
     6.086    86.818     0.150
     6.356    90.799     0.150
     6.573    93.141     0.150
     6.847    98.096     0.150
     7.008   100.379     0.150
     7.017   100.189     0.150
     7.028   100.117     0.150
     7.239   102.318     0.150
     8.215   115.051     0.150
     8.277   117.787     0.150
     0.788    21.305     0.150
     1.250    25.805     0.150
     1.570    29.234     0.150
     1.562    28.414     0.150
     1.638    29.969     0.150
     1.686    30.219     0.150
     1.690    29.805     0.150
     1.690    29.719     0.150
     1.690    51.703     0.150
     1.840    32.156     0.150
     2.062    61.633     0.150
     2.112    34.805     0.150
     2.112    34.891     0.150
     2.189    36.148     0.150
     2.649    42.766     0.150
     2.976    47.219     0.150
     3.122    48.891     0.150
     3.251    50.719     0.150
     3.251    50.211     0.150
     3.268    50.023     0.150
     4.010    59.688     0.150
     4.529    64.953     0.150
     4.589    67.633     0.150
     4.860    70.711     0.150
     5.128    74.484     0.150
     5.180    76.078     0.150
     5.796    83.648     0.150
     5.850    83.492     0.150
     5.936    85.047     0.150
     5.929    85.234     0.150
     6.206    88.805     0.150
     6.422    91.312     0.150
     6.746    96.781     0.150
     6.909    98.977     0.150
     7.153   102.203     0.150
     7.157   100.531     0.150
     7.969   112.953     0.150
     7.950   111.305     0.150
     7.950   111.344     0.150
     8.205   115.938     0.150
     8.454   117.625     0.150
     9.511   131.234     0.150
     9.935   139.570     0.150
     9.963   135.445     0.150
    10.065   141.227     0.150
    10.212   143.562     0.150
    10.430   145.211     0.150
    10.424   146.539     0.150
    10.925   152.578     0.150
    10.995   153.375     0.150
    11.317   153.961     0.150
    11.317   153.648     0.150
    12.394   169.344     0.150
    13.321   185.375     0.150
    23.337   295.625     0.150
    27.879   336.273     0.150
    31.987   372.758     0.150
    32.710   376.281     0.150
    42.112   454.602     0.150
    42.112   450.492     0.150
    45.233   483.469     0.150
    47.794   503.461     0.150
    49.142   515.125     0.150
    49.203   514.789     0.150
    54.428   552.961     0.150
    56.322    32.023     0.150
    64.334    32.797     0.150
    64.334    47.602     0.150
    64.573    31.000     0.150
    64.928   623.695     0.150
    65.276    32.797     0.150
    65.276    48.000     0.150
    70.510   658.695     0.150
    70.815   660.789     0.150
    71.001   660.609     0.150
    71.059   663.062     0.150
    73.143   673.703     0.150
    73.411    34.000     0.150
    73.923   679.578     0.150
    73.929   679.508     0.150
    74.084   680.422     0.150
    74.140   679.383     0.150
    74.244   681.594     0.150
    74.811   693.164     0.150
    74.896   684.711     0.150
    74.896   683.359     0.150
    74.948   684.891     0.150
    75.878   686.977     0.150
    76.103   691.320     0.150
    76.347   692.828     0.150
    76.543   692.922     0.150
    81.631   721.344     0.150
    81.756   722.258     0.150
     1.017    32.121     0.150
     1.537    25.020     0.150
     6.018    86.320     0.150
     5.656    80.090     0.150
     0.199     5.998     0.150
     0.199    11.110     0.150
     0.920    15.185     0.150
     0.920    27.685     0.150
     0.920    15.190     0.150
     1.019    34.194     0.150
     1.019    18.225     0.150
     1.698    57.354     0.150
     1.698    27.554     0.150
     1.698    48.068     0.150
     1.698    27.645     0.150
     2.151    33.851     0.150
     2.468    77.475     0.150
     3.066    46.575     0.150
     3.066    93.645     0.150
     3.317    49.821     0.150
     3.337    51.155     0.150
     3.522    53.160     0.150
     3.624    53.140     0.150
     4.076    60.158     0.150
     6.633    96.066     0.150
     6.840    97.896     0.150
     7.925   112.149     0.150
     9.093   130.194     0.150
     9.174   129.135     0.150
     9.848   139.631     0.150
    10.455   146.352     0.150
    12.068   168.504     0.150
    13.442   186.313     0.150
    13.461   186.405     0.150
    14.114   194.204     0.150
    14.691   201.716     0.150
    23.882   312.904     0.150
    31.120   371.755     0.150
    31.274   370.805     0.150
    31.420   377.385     0.150
    34.073   400.595     0.150
    44.575   495.645     0.150
    46.656   504.125     0.150
    54.768     9.300     0.150
    59.268   604.185     0.150
    62.296   622.185     0.150
    64.537   633.175     0.150
    65.888     4.101     0.150
    65.952     8.600     0.150
    66.749     4.400     0.150
    66.749     8.900     0.150
    67.402   658.784     0.150
    69.956   665.875     0.150
    70.839     4.399     0.150
    72.142   679.784     0.150
    72.172     3.300     0.150
    72.677   689.435     0.150
    72.712   683.295     0.150
    73.119   688.314     0.150
    74.001   692.746     0.150
   109.774  8274.942     0.150
   109.784  8277.286     0.150
   109.791  8274.942     0.150
     1.043    18.859     0.150
     1.714    33.220     0.150
     1.874    35.460     0.150
     1.874    59.360     0.150
     1.885    29.690     0.150
     5.188    75.070     0.150
     5.689    79.370     0.150
     7.985   116.090     0.150
     8.568   118.254     0.150
    10.439   146.240     0.150
     3.451    52.328     0.150
     4.063    59.969     0.150
     6.276    91.398     0.150
     1.495    47.367     0.150
     5.753    79.973     0.150
     5.940    83.484     0.150
     9.837   139.945     0.150
    20.771    12.453     0.150
    52.824   547.074     0.150
     0.885    16.203     0.150
     0.885    16.152     0.150
     0.885    27.672     0.150
     0.885    16.262     0.150
     1.358    23.141     0.150
     1.549    24.805     0.150
     1.549    24.742     0.150
     1.648    27.684     0.150
     1.648    52.305     0.150
     1.869    30.656     0.150
     1.869    58.539     0.150
     2.004    31.109     0.150
     2.294    35.289     0.150
     2.289    35.445     0.150
     2.373    35.785     0.150
     2.417    37.586     0.150
     2.432    38.961     0.150
     2.520    38.629     0.150
     2.603    38.953     0.150
     2.865    43.465     0.150
     2.901    43.895     0.150
     2.938    44.332     0.150
     3.141    47.133     0.150
     3.321    48.852     0.150
     3.457    50.133     0.150
     3.435    50.902     0.150
     3.435    50.902     0.150
     3.435    50.906     0.150
     3.595    52.617     0.150
     3.886    57.074     0.150
     4.718    69.336     0.150
     4.867    71.781     0.150
     5.166    74.645     0.150
     5.207    75.406     0.150
     5.526    80.102     0.150
     5.526    80.023     0.150
     5.861    83.746     0.150
     6.293    90.250     0.150
     6.444    92.359     0.150
     6.562    93.703     0.150
     6.754    96.062     0.150
     7.566   108.090     0.150
     7.751   108.703     0.150
     8.345   118.594     0.150
     8.653   120.902     0.150
     8.653   120.906     0.150
     8.966   126.395     0.150
     9.163   129.602     0.150
     9.163   129.605     0.150
     9.331   131.004     0.150
     9.487   134.207     0.150
     9.935   140.043     0.150
    10.575   148.738     0.150
    12.725   178.703     0.150
    20.206   269.805     0.150
    22.283   293.613     0.150
    22.536   298.902     0.150
    24.337   312.691     0.150
    24.491   314.852     0.150
    24.491   314.902     0.150
    25.249   321.953     0.150
    25.862   326.965     0.150
    25.862   327.004     0.150
    26.280   332.504     0.150
    26.515   332.363     0.150
    26.549   334.375     0.150
    26.942   341.191     0.150
    27.126   340.602     0.150
    27.632   341.992     0.150
    28.604   351.305     0.150
    28.604   351.805     0.150
    28.882   354.852     0.150
    29.945   363.691     0.150
    29.945   363.703     0.150
    31.310   375.863     0.150
    31.310   375.902     0.150
    32.383   388.402     0.150
    33.646   398.191     0.150
    33.745   397.984     0.150
    33.970   404.375     0.150
    33.968   400.715     0.150
    34.112   400.895     0.150
    36.268   418.562     0.150
    37.188     5.301     0.150
    38.193   442.895     0.150
    40.187   453.402     0.150
    40.801   462.305     0.150
    41.542   464.305     0.150
    41.737   466.504     0.150
    41.882   466.422     0.150
    42.025   471.543     0.150
    43.519   479.703     0.150
    43.653   481.504     0.150
    46.541   505.004     0.150
    46.758   502.223     0.150
    49.795   529.004     0.150
    50.300   617.602     0.150
    52.192   547.305     0.150
    54.347   558.203     0.150
    55.539   571.703     0.150
    56.060   579.602     0.150
    56.188   576.703     0.150
    56.487   578.805     0.150
    59.234   596.902     0.150
    60.529   606.402     0.150
    60.642     9.699     0.150
    64.868   634.543     0.150
    66.108    12.301     0.150
    66.178   642.844     0.150
    66.482    12.199     0.150
    66.717    17.102     0.150
    66.717   890.004     0.150
    67.124    12.301     0.150
    67.124   671.004     0.150
    67.508   650.094     0.150
    67.508   650.094     0.150
    67.508   896.883     0.150
    67.508  1640.512     0.150
    67.508   650.004     0.150
    67.508   797.805     0.150
    67.508   896.805     0.150
    67.508  1185.004     0.150
    67.508  1445.602     0.150
    69.095   661.441     0.150
    69.160   662.352     0.150
    69.957   668.102     0.150
    70.341   669.203     0.150
    70.395   669.762     0.150
    70.429   669.031     0.150
    70.577   670.781     0.150
    70.691   677.305     0.150
    70.850   672.395     0.150
    70.921    12.000     0.150
    71.107   674.383     0.150
    71.174   674.223     0.150
    71.193   676.703     0.150
    71.193   676.613     0.150
    71.315   675.902     0.150
    71.322   675.402     0.150
    71.500   677.902     0.150
    71.500   677.941     0.150
    71.852   678.703     0.150
    72.073   680.902     0.150
    72.123   679.805     0.150
    72.167   686.602     0.150
    72.167   686.602     0.150
    72.243   682.102     0.150
    72.378   683.684     0.150
    72.427   683.305     0.150
    72.599   685.504     0.150
    72.955   686.703     0.150
    73.106   685.703     0.150
    73.215   687.504     0.150
    73.215   687.594     0.150
    73.229   688.504     0.150
    73.355   688.812     0.150
    73.852   691.902     0.150
    74.125   691.914     0.150
    74.177   694.164     0.150
    74.366   693.949     0.150
    74.366   693.902     0.150
    76.141   704.602     0.150
    76.155   704.402     0.150
    76.237   704.203     0.150
    76.510   706.602     0.150
    76.834   708.703     0.150
    76.841   708.203     0.150
    76.886   708.602     0.150
    77.329   711.004     0.150
    77.562   712.602     0.150
    78.076   716.703     0.150
    78.076   716.762     0.150
    81.076   731.305     0.150
    81.076   731.363     0.150
    81.504   732.305     0.150
    81.504   732.223     0.150
    81.779   735.305     0.150
    82.088   737.805     0.150
    84.058   746.305     0.150
    84.058   746.215     0.150
     1.960    32.172     0.150
     2.206    35.852     0.150
     2.294    36.672     0.150
     2.347    35.473     0.150
     2.855    45.211     0.150
     3.620    53.070     0.150
     4.509    67.891     0.150
     6.780    97.070     0.150
    71.338   677.441     0.150
     1.618    28.287     0.150
     1.844    31.668     0.150
     1.844    31.688     0.150
     2.649    42.047     0.150
     5.141    73.406     0.150
     5.286    74.707     0.150
     5.394    76.938     0.150
     5.347    77.217     0.150
     5.410    77.857     0.150
     5.668    80.557     0.150
     5.694    81.387     0.150
     5.809    82.477     0.150
     6.094    87.066     0.150
     6.237    88.428     0.150
     7.429   104.438     0.150
     0.477    18.242     0.150
     0.756    15.164     0.150
     1.580    24.082     0.150
     1.634    26.055     0.150
     2.408    51.945     0.150
     2.516    59.125     0.150
     2.703    42.055     0.150
     2.856    42.395     0.150
     7.004    98.703     0.150
     0.820    15.367     0.150
     2.212    33.258     0.150
     3.791    55.078     0.150
     4.294    61.598     0.150
     4.893    70.387     0.150
     5.537    78.457     0.150
     5.835    82.715     0.150
     6.363    91.805     0.150
     7.615   108.828     0.150
     8.138   113.805     0.150
     9.852   137.402     0.150
     6.479    91.199     0.150
     6.710    94.070     0.150
     8.901   123.910     0.150
     1.769    27.582     0.150
     2.644    40.162     0.150
     2.784    40.781     0.150
     3.032    45.562     0.150
     4.970    74.182     0.150
     5.192    76.383     0.150
     5.435    79.713     0.150
     9.556   135.980     0.150
    12.073   292.184     0.150
    13.320   191.230     0.150
     0.937    16.078     0.150
     1.315    24.242     0.150
     1.333    23.555     0.150
     1.490    26.625     0.150
     1.490    26.375     0.150
     1.822    31.234     0.150
     5.779    83.031     0.150
     1.453    26.446     0.150
     1.851    29.576     0.150
     1.886    31.876     0.150
     2.036    34.606     0.150
     2.235    36.977     0.150
     2.395    38.916     0.150
     3.413    52.946     0.150
     3.505    53.776     0.150
     3.709    56.956     0.150
     3.664    56.866     0.150
     3.672    56.597     0.150
     3.854    59.166     0.150
     5.043    72.727     0.150
     5.703    84.797     0.150
     4.640    66.769     0.150
     7.740   109.668     0.150
     1.026    33.955     0.150
     5.432    77.404     0.150
     7.070    99.594     0.150
     8.688   121.344     0.150
     1.461    21.895     0.150
     2.325    61.297     0.150
     4.508    63.727     0.150
     2.410    41.143     0.150
     2.945    46.434     0.150
     5.076    74.152     0.150
     1.360    24.322     0.150
     1.399    25.043     0.150
     1.731    53.332     0.150
     2.130    36.582     0.150
     2.201    36.992     0.150
     2.272    38.213     0.150
     2.402    40.191     0.150
     2.740    45.133     0.150
     2.817    46.941     0.150
     4.067    61.223     0.150
     4.462    69.322     0.150
     4.547    67.902     0.150
     4.600    70.303     0.150
     3.759   100.000     0.150
     8.161   114.199     0.150
    43.377   473.770     0.150
    53.818   553.680     0.150
    65.927   637.434     0.150
     1.101    20.554     0.150
     1.464    24.693     0.150
     2.690    41.703     0.150
     4.539    65.483     0.150
     0.556    21.852     0.150
     1.698    27.930     0.150
     8.581   125.039     0.150
    46.834  3521.723     0.150
    46.839  3522.066     0.150
    46.852  3525.277     0.150
    47.988  3608.383     0.150
    48.001  3609.465     0.150
    48.005  3610.078     0.150
     0.495    20.877     0.150
     0.952    17.557     0.150
     1.299    18.877     0.150
     1.299    18.307     0.150
     1.299    18.205     0.150
     1.583    26.332     0.150
     1.583    26.417     0.150
     2.166    34.107     0.150
     2.409    68.567     0.150
     2.604    39.405     0.150
     2.721    40.547     0.150
     2.766    39.857     0.150
     2.766    40.127     0.150
     2.766    39.888     0.150
     2.661    42.025     0.150
     3.151    45.767     0.150
     3.188    46.487     0.150
     3.350    48.847     0.150
     3.265    49.452     0.150
     3.420    49.667     0.150
     3.336    50.372     0.150
     3.775    52.251     0.150
     3.779    52.347     0.150
     3.684    54.400     0.150
     3.841    58.506     0.150
     4.071    57.324     0.150
     4.005    59.352     0.150
     4.145    60.827     0.150
     4.485    65.468     0.150
     4.751    66.827     0.150
     4.751    67.167     0.150
     4.582    68.366     0.150
     4.788    67.137     0.150
     4.788    67.287     0.150
     4.832    67.847     0.150
     4.890    68.307     0.150
     4.890    69.197     0.150
     5.131    71.407     0.150
     5.053    73.852     0.150
     4.981    73.248     0.150
     5.247    75.637     0.150
     5.693    82.270     0.150
     5.830    80.977     0.150
     5.780    83.177     0.150
     5.806    84.242     0.150
     5.892    84.308     0.150
     6.187    89.957     0.150
     6.143    88.977     0.150
     6.292    89.887     0.150
     6.403    92.177     0.150
     6.403    92.085     0.150
     6.656    95.727     0.150
     7.027   100.607     0.150
     7.021    99.857     0.150
     7.477   103.797     0.150
     7.398   105.307     0.150
     7.407   105.317     0.150
     7.515   107.677     0.150
     7.879   108.477     0.150
     7.879   108.607     0.150
     7.879   108.708     0.150
     7.963   109.997     0.150
     7.812   112.077     0.150
     7.833   112.377     0.150
     7.833   112.345     0.150
     8.101   112.327     0.150
     8.080   113.757     0.150
     8.133   116.391     0.150
     8.268   117.757     0.150
     8.563   121.954     0.150
     8.667   123.687     0.150
     8.920   123.457     0.150
     9.050   129.527     0.150
     9.110   126.977     0.150
     9.221   131.717     0.150
     9.244   132.347     0.150
     9.969   139.893     0.150
     9.924   139.063     0.150
    10.008   138.577     0.150
    10.170   143.077     0.150
    10.122   143.460     0.150
    10.553   149.133     0.150
    10.966   154.451     0.150
    12.494   950.701     0.150
    12.494   305.557     0.150
    12.494   950.700     0.150
    13.235   188.877     0.150
    14.300   195.877     0.150
    14.300   196.557     0.150
    20.478  2316.552     0.150
    22.289   296.677     0.150
    23.399     9.630     0.150
    24.601   320.177     0.150
    26.236   334.047     0.150
    27.457   342.377     0.150
    28.645   357.177     0.150
    28.645   357.237     0.150
    29.061   356.677     0.150
    30.933   375.897     0.150
    30.961  2276.927     0.150
    32.485   388.977     0.150
    32.710   390.477     0.150
    32.945   393.177     0.150
    32.981   392.657     0.150
    33.022   393.357     0.150
    33.159   394.977     0.150
    33.242   395.777     0.150
    33.964   401.037     0.150
    33.995   401.777     0.150
    34.240   403.797     0.150
    34.416   403.987     0.150
    34.865   409.287     0.150
    35.002   410.627     0.150
    35.139   412.017     0.150
    35.155   412.047     0.150
    35.155   412.077     0.150
    35.264   413.177     0.150
    37.611   425.377     0.150
    37.654   957.277     0.150
    37.928   436.777     0.150
    38.206   438.777     0.150
    39.340   560.577     0.150
    39.539   449.427     0.150
    40.428   456.417     0.150
    42.572   474.447     0.150
    43.726   871.417     0.150
    43.726   481.377     0.150
    43.911   485.477     0.150
    43.911   485.567     0.150
    44.178   486.387     0.150
    44.373   488.277     0.150
    44.396   490.677     0.150
    44.766   493.337     0.150
    45.260     6.300     0.150
    45.260   892.877     0.150
    46.915  3522.416     0.150
    46.920  3521.353     0.150
    46.933  3523.960     0.150
    47.000   511.817     0.150
    47.000   511.777     0.150
    47.654   514.977     0.150
    47.866   832.377     0.150
    47.784   517.637     0.150
    48.069  3608.819     0.150
    48.082  3609.811     0.150
    48.087  3610.045     0.150
    48.061   518.047     0.150
    48.865   523.677     0.150
    48.865   522.577     0.150
    48.979  3687.761     0.150
    50.584     7.100     0.150
    50.614   547.577     0.150
    50.614   555.177     0.150
    50.614   608.377     0.150
    53.332   556.017     0.150
    53.761   561.227     0.150
    53.863   559.377     0.150
    54.272   564.697     0.150
    54.272   564.677     0.150
    54.491   565.277     0.150
    54.929   565.337     0.150
    55.114   569.837     0.150
    55.235     7.500     0.150
    56.104   577.877     0.150
    55.993   578.077     0.150
    56.518   579.577     0.150
    56.833   581.987     0.150
    60.259   605.477     0.150
    60.481     6.700     0.150
    60.633     4.600     0.150
    61.716   662.577     0.150
    62.403   620.477     0.150
    62.781   627.377     0.150
    63.637   630.547     0.150
    63.637   631.277     0.150
    64.163     5.400     0.150
    64.384   635.217     0.150
    64.634   636.777     0.150
    64.770   635.547     0.150
    64.993   637.187     0.150
    65.592   643.877     0.150
    65.749   642.647     0.150
    66.158   646.587     0.150
    66.809   651.777     0.150
    67.398   653.517     0.150
    67.802    12.300     0.150
    67.980   901.977     0.150
    68.557   661.917     0.150
    68.669   660.277     0.150
    68.669   910.577     0.150
    68.669   660.267     0.150
    69.085     7.060     0.150
    69.579   667.607     0.150
    69.579   667.607     0.150
    69.579   923.757     0.150
    69.579  1684.657     0.150
    69.579   667.577     0.150
    70.090   670.057     0.150
    71.023   674.177     0.150
    71.356   678.007     0.150
    71.364   677.237     0.150
    71.524   678.777     0.150
    71.811   680.627     0.150
    72.173   682.637     0.150
    72.110   682.947     0.150
    72.197   690.777     0.150
    72.197   681.777     0.150
    72.197   949.577     0.150
    72.197  1723.577     0.150
    72.197   682.357     0.150
    72.319   683.657     0.150
    72.929   687.517     0.150
    73.072   688.466     0.150
    73.147   689.077     0.150
    73.190   688.277     0.150
    73.214   689.277     0.150
    73.225   695.777     0.150
    73.225   689.077     0.150
    73.374   688.717     0.150
    73.374   688.677     0.150
    73.374   688.837     0.150
    73.402   690.277     0.150
    73.634   691.977     0.150
    73.633   693.167     0.150
    73.633   693.177     0.150
    73.706   691.977     0.150
    73.706   692.017     0.150
    74.050   693.477     0.150
    74.222   694.977     0.150
    74.261   694.367     0.150
    74.332   695.877     0.150
    74.412   699.167     0.150
    74.407   696.677     0.150
    74.458   696.477     0.150
    74.463   696.957     0.150
    74.583   698.077     0.150
    74.776   699.077     0.150
    74.776   697.577     0.150
    75.258   700.557     0.150
    75.432   702.377     0.150
    75.487   702.677     0.150
    75.503   702.987     0.150
    75.618   704.615     0.150
    75.737   704.696     0.150
    75.948   703.777     0.150
    76.026   705.777     0.150
    76.026   705.867     0.150
    76.052   706.077     0.150
    76.076   706.037     0.150
    76.155   705.587     0.150
    76.267     6.200     0.150
    76.389   707.377     0.150
    76.389   707.487     0.150
    76.423   708.237     0.150
    76.431   707.987     0.150
    76.692     7.300     0.150
    77.252   712.577     0.150
    77.296   717.177     0.150
    77.351   713.477     0.150
    77.583   714.287     0.150
    77.824   715.077     0.150
    77.937   716.377     0.150
    78.228   718.077     0.150
    78.243   718.277     0.150
    78.405   717.677     0.150
    78.393   717.977     0.150
    78.425   718.577     0.150
    78.603   719.377     0.150
    78.580   721.687     0.150
    78.620   720.731     0.150
    78.650   720.277     0.150
    78.652   720.077     0.150
    78.648   718.037     0.150
    78.878  1319.977     0.150
    78.908   720.677     0.150
    79.215   723.777     0.150
    79.559   900.277     0.150
    79.559  1015.277     0.150
    79.624   725.477     0.150
    79.891  1013.977     0.150
    80.055   728.947     0.150
    80.380   734.347     0.150
    80.523   732.117     0.150
    81.010   734.447     0.150
    81.010   734.477     0.150
    81.112   728.777     0.150
    81.134   733.177     0.150
    81.462   735.877     0.150
    82.027   739.397     0.150
    82.027   739.377     0.150
    82.217   742.517     0.150
    82.475   741.477     0.150
    83.900   746.477     0.150
    83.900   746.487     0.150
    83.929   748.087     0.150
    84.177   749.677     0.150
    87.492   766.387     0.150
    90.742   779.393     0.150
    91.352   785.627     0.150
    91.352   785.677     0.150
    92.350   790.127     0.150
    92.350   790.177     0.150
    95.106   745.807     0.150
    96.955   809.877     0.150
    98.906   819.177     0.150
    98.906   818.667     0.150
   109.314  8214.118     0.150
   109.325  8212.300     0.150
   109.331  8211.447     0.150
   124.345  1137.577     0.150
   146.064  1173.297     0.150
   160.242  1235.737     0.150
     1.765    29.080     0.150
    12.476   932.030     0.150
    12.476   932.030     0.150
    12.875   178.950     0.150
    12.875   309.525     0.150
    46.808  3517.782     0.150
    46.813  3516.632     0.150
    46.826  3522.545     0.150
    47.961  3608.812     0.150
    47.974  3609.719     0.150
    47.978  3610.085     0.150
    56.950   592.216     0.150
    60.415   614.776     0.150
    62.810   630.134     0.150
    63.677   635.872     0.150
    65.433   648.828     0.150
     0.562    11.428     0.150
     0.562    21.388     0.150
     0.562    11.457     0.150
     0.562    21.181     0.150
     1.022    18.975     0.150
     1.304    19.418     0.150
     1.304    19.558     0.150
     1.304    35.438     0.150
     1.304    19.569     0.150
     1.644    27.782     0.150
     1.644    48.360     0.150
     1.644    27.827     0.150
     2.163    59.588     0.150
     2.237    60.947     0.150
     2.313    66.527     0.150
     2.375    36.708     0.150
     2.667    40.817     0.150
     2.799    41.016     0.150
     2.735    43.518     0.150
     3.346    49.168     0.150
     3.381    49.867     0.150
     3.413    51.525     0.150
     3.459    53.681     0.150
     3.778    53.086     0.150
     3.784    57.275     0.150
     3.910   106.845     0.150
     4.087    58.583     0.150
     4.556    66.737     0.150
     4.771    71.428     0.150
     5.148    72.287     0.150
     5.050    74.731     0.150
     5.205    75.711     0.150
     5.764    83.875     0.150
     5.846    82.570     0.150
     5.740    84.220     0.150
     5.817    84.542     0.150
     5.820    83.951     0.150
     5.906    85.598     0.150
     5.873    85.543     0.150
     5.930    85.521     0.150
     6.351    91.781     0.150
     6.395    92.472     0.150
     6.457    93.489     0.150
     6.742    98.616     0.150
     7.491   104.688     0.150
     7.891   109.617     0.150
     7.891   109.617     0.150
     8.008   114.977     0.150
     8.291   116.001     0.150
     8.684   124.412     0.150
     8.698   123.218     0.150
     8.698   122.976     0.150
     9.113   131.718     0.150
     9.322   133.556     0.150
     9.348   133.710     0.150
     9.471   134.994     0.150
     9.526   134.098     0.150
    10.166   145.947     0.150
    10.166   142.337     0.150
    10.438   143.826     0.150
    11.311   157.050     0.150
    12.459   932.005     0.150
    12.459   933.634     0.150
    12.809   177.712     0.150
    14.318   197.117     0.150
    16.530   228.579     0.150
    19.492   266.197     0.150
    42.577   475.607     0.150
    46.897  3523.518     0.150
    46.903  3523.941     0.150
    46.915  3525.066     0.150
    47.233   511.178     0.150
    48.051  3612.037     0.150
    48.064  3612.930     0.150
    48.068  3613.363     0.150
    48.916  3685.738     0.150
    56.900   583.537     0.150
   109.252  8210.893     0.150
   109.263  8210.551     0.150
   109.269  8211.029     0.150
     0.651    13.773     0.150
     4.418    65.113     0.150
     4.646    68.125     0.150
     4.814    70.402     0.150
     5.420    79.496     0.150
     5.481    79.953     0.150
     5.743    84.086     0.150
     5.854    84.902     0.150
     6.116    87.926     0.150
     6.421    91.535     0.150
     6.459    92.953     0.150
     6.492    93.184     0.150
     6.528    94.234     0.150
     6.654    96.004     0.150
     7.103   102.035     0.150
     7.545   108.184     0.150
     9.928   144.383     0.150
    10.589   149.613     0.150
    12.432   930.078     0.150
    12.432   930.090     0.150
    15.972   219.734     0.150
    16.585   228.293     0.150
    16.784   230.016     0.150
    21.937   290.926     0.150
    22.054   292.344     0.150
    24.076   311.984     0.150
    24.559   316.715     0.150
    24.607   317.152     0.150
    24.660   317.973     0.150
    25.043   320.824     0.150
    26.007   330.465     0.150
    26.138   331.152     0.150
    27.066   338.113     0.150
    28.882   353.703     0.150
    28.893   357.594     0.150
    30.893   373.305     0.150
    34.072   406.051     0.150
    45.966   504.023     0.150
    46.848  3527.504     0.150
    46.853  3527.930     0.150
    46.866  3527.383     0.150
    48.000  3612.492     0.150
    48.014  3613.594     0.150
    48.018  3614.367     0.150
    59.864   608.375     0.150
   109.179  8210.152     0.150
   109.189  8212.129     0.150
   109.195  8207.875     0.150
     1.763    28.988     0.150
     9.285   128.523     0.150
    29.130   358.359     0.150
    29.187   358.820     0.150
    30.882   374.039     0.150
    46.845  3528.809     0.150
    46.851  3529.004     0.150
    46.863  3530.270     0.150
    47.998  3614.449     0.150
    48.011  3615.438     0.150
    48.015  3616.594     0.150
    54.693   567.836     0.150
    56.999   585.031     0.150
     0.597    22.465     0.150
     1.986    32.547     0.150
     2.093    66.859     0.150
     2.376    71.445     0.150
     2.887    46.105     0.150
     6.290    91.195     0.150
    21.222   285.266     0.150
    34.771   406.656     0.150
    47.387  3577.176     0.150
    47.400  3577.703     0.150
    47.404  3578.395     0.150
    75.087   705.418     0.150
    76.076   706.617     0.150
     9.390   133.729     0.150
     0.325     7.770     0.150
     0.782    11.621     0.150
     0.782    11.947     0.150
     1.829    58.770     0.150
     1.829    57.561     0.150
     2.317    37.260     0.150
     3.757    55.492     0.150
     4.065    59.539     0.150
     4.289    61.551     0.150
     4.667    68.357     0.150
     5.258    74.307     0.150
     5.271    76.396     0.150
     5.350    77.609     0.150
     5.481    79.488     0.150
     5.890    83.471     0.150
     6.001    85.850     0.150
     6.383    91.150     0.150
     6.540    94.406     0.150
     6.676    95.250     0.150
     7.312   101.541     0.150
     7.229   103.531     0.150
     7.443   104.820     0.150
     7.683   109.750     0.150
     7.968   112.650     0.150
     8.109   115.750     0.150
     9.092   128.898     0.150
     9.293   130.750     0.150
     9.293   130.750     0.150
    10.230   143.131     0.150
    12.122   169.332     0.150
    13.360   185.111     0.150
    13.358   184.904     0.150
    15.384   214.201     0.150
    18.794   255.283     0.150
    21.252   280.350     0.150
    27.365   340.051     0.150
    34.086   400.240     0.150
    37.206   532.350     0.150
    37.206   948.650     0.150
    43.184   476.650     0.150
    44.130   485.650     0.150
    46.443  3506.646     0.150
    46.448  3512.959     0.150
    46.461  3507.053     0.150
    47.601  3585.939     0.150
    47.614  3588.607     0.150
    47.618  3586.646     0.150
    48.282   514.150     0.150
    54.256   561.750     0.150
    56.360   577.250     0.150
    58.094   590.439     0.150
    58.953   596.141     0.150
    64.657   633.850     0.150
    65.367   638.891     0.150
    65.877    16.701     0.150
    66.700    14.000     0.150
    66.839   648.051     0.150
    66.936   648.150     0.150
    68.592     5.199     0.150
    68.592  1232.650     0.150
    68.592  1650.650     0.150
    69.557   664.471     0.150
    69.557   664.471     0.150
    69.557   921.041     0.150
    69.557  1687.889     0.150
    69.557   664.451     0.150
    69.557   819.951     0.150
    69.557   920.951     0.150
    69.557  1213.252     0.150
    69.557  1482.850     0.150
    69.731   666.689     0.150
    70.990   674.480     0.150
    70.992   673.490     0.150
    71.113   675.051     0.150
    71.154   675.320     0.150
    71.444   677.090     0.150
    71.814   679.320     0.150
    71.960   680.141     0.150
    72.273   681.951     0.150
    72.687   685.291     0.150
    72.784   686.031     0.150
    72.828   687.590     0.150
    73.127   684.750     0.150
    73.166   688.250     0.150
    73.204   688.350     0.150
    73.295   689.150     0.150
    73.334   687.750     0.150
    73.457   690.150     0.150
    73.457   690.051     0.150
    73.758   691.350     0.150
    73.758   691.391     0.150
    73.880   692.871     0.150
    74.219   694.840     0.150
    74.482   693.650     0.150
    74.482   695.660     0.150
    74.605   696.250     0.150
    74.811   698.350     0.150
    74.939   697.721     0.150
    74.968   697.840     0.150
    75.440   701.551     0.150
    75.545   703.951     0.150
    75.483   702.650     0.150
    76.059   705.641     0.150
    76.634   708.131     0.150
    77.163     8.201     0.150
    84.105   746.051     0.150
    86.395   761.561     0.150
     3.043    47.938     0.150
     4.063    64.359     0.150
     5.408    79.836     0.150
     6.238    90.570     0.150
    10.512   143.266     0.150
    19.626    24.273     0.150
    19.626    24.969     0.150
   160.245 11963.875     0.150
   160.253 11969.766     0.150
   160.263 11966.766     0.150
     0.428    18.240     0.150
     0.822    13.820     0.150
     1.135    34.580     0.150
     1.542    46.439     0.150
     1.590    47.359     0.150
     1.731    28.650     0.150
     1.786    53.674     0.150
     1.786    28.061     0.150
     1.786    53.670     0.150
     1.838    53.840     0.150
     1.955    32.369     0.150
     2.766    42.580     0.150
     4.154    62.719     0.150
     4.905    70.219     0.150
     5.877    85.629     0.150
    31.763   377.670     0.150
    31.822   378.699     0.150
    33.768   394.141     0.150
    35.154   406.670     0.150
    39.591   445.379     0.150
    44.908   487.420     0.150
     1.108    15.574     0.150
     1.108    15.617     0.150
     1.018    18.215     0.150
     1.677    34.895     0.150
     1.677    60.242     0.150
     1.677    27.422     0.150
     1.677    27.516     0.150
     1.974    31.031     0.150
     2.137    32.902     0.150
     2.575    37.098     0.150
     2.545    37.703     0.150
     2.546    37.684     0.150
     2.958    42.805     0.150
     3.209    45.773     0.150
     3.278    49.117     0.150
     3.583    49.641     0.150
     3.588    49.703     0.150
     3.875    54.625     0.150
     4.063    59.172     0.150
     4.555    63.945     0.150
     4.694    66.305     0.150
     4.501    64.816     0.150
     4.594    68.273     0.150
     5.062    72.203     0.150
     5.575    80.367     0.150
     5.683    82.762     0.150
     6.051    83.586     0.150
     5.875    83.969     0.150
     5.978    86.992     0.150
     6.214    88.223     0.150
     6.741    95.727     0.150
     6.882    97.203     0.150
     6.882    96.953     0.150
     7.206    99.914     0.150
     7.182   101.473     0.150
     7.240   102.172     0.150
     7.393   104.957     0.150
     7.683   105.445     0.150
     7.683   105.371     0.150
     7.768   107.312     0.150
     7.580   107.969     0.150
     7.647   107.754     0.150
     7.647   107.805     0.150
     7.733   108.004     0.150
     7.906   109.043     0.150
     7.978   112.203     0.150
     7.978   112.352     0.150
    12.589   172.246     0.150
    12.684   954.371     0.150
    12.684   954.359     0.150
    26.289   329.766     0.150
    27.276   343.934     0.150
    37.529   429.184     0.150
    37.942   436.496     0.150
    41.440   462.555     0.150
    42.760   472.996     0.150
    42.777   472.953     0.150
    44.206   484.555     0.150
    45.979   497.723     0.150
    46.739  3507.297     0.150
    46.744  3507.727     0.150
    46.756  3510.699     0.150
    47.894  3599.961     0.150
    47.907  3595.953     0.150
    47.911  3599.543     0.150
    48.676   517.684     0.150
    48.984   525.645     0.150
    49.296   525.828     0.150
    49.206   524.145     0.150
    62.651   621.273     0.150
    63.998   630.875     0.150
    63.998     7.000     0.150
    66.200   644.473     0.150
    66.200     7.602     0.150
    66.221     8.102     0.150
    67.059     7.398     0.150
    67.691   919.676     0.150
    69.607   920.023     0.150
    69.607  1680.684     0.150
    71.143     3.199     0.150
    71.143     8.000     0.150
    73.102   683.414     0.150
    73.455   686.684     0.150
    78.749   722.086     0.150
     0.437    19.195     0.150
     1.085    16.602     0.150
     3.227    46.094     0.150
     4.559    65.523     0.150
     5.715    81.562     0.150
    12.677   956.773     0.150
    12.677   956.328     0.150
    20.693   274.531     0.150
    26.392   339.039     0.150
    29.456   356.516     0.150
    44.187   484.703     0.150
    44.187   483.539     0.150
    44.076   486.523     0.150
    46.701  3512.547     0.150
    46.706  3512.984     0.150
    46.719  3514.906     0.150
    47.855  3599.047     0.150
    47.869  3597.180     0.150
    47.873  3597.500     0.150
    48.684   519.133     0.150
    54.590   566.164     0.150
    56.739   637.250     0.150
    59.612   604.891     0.150
    66.261     6.602     0.150
    67.740   662.695     0.150
    71.607   681.148     0.150
    72.323   683.359     0.150
     1.470    24.346     0.150
     4.173    62.695     0.150
     4.292    64.355     0.150
     5.271    77.205     0.150
    20.712   539.256     0.150
    24.045   309.205     0.150
    34.724   404.355     0.150
    45.231   589.676     0.150
    55.443   567.605     0.150
    72.275   676.756     0.150
     0.402    18.139     0.150
     0.402    16.649     0.150
     0.402     9.090     0.150
     0.402    17.970     0.150
     0.970    33.299     0.150
     1.622    27.178     0.150
     1.622    27.168     0.150
     2.217    65.369     0.150
     2.608    38.849     0.150
     2.606    39.399     0.150
     2.485    39.372     0.150
     3.198    46.229     0.150
     3.280    47.769     0.150
     3.662    51.239     0.150
     3.662    51.306     0.150
     3.666    50.879     0.150
     3.950    58.776     0.150
     4.397    64.029     0.150
     4.631    65.708     0.150
     4.770    67.549     0.150
     4.693    68.406     0.150
     5.043    73.029     0.150
     4.993   131.889     0.150
     4.993    71.983     0.150
     5.171    75.009     0.150
     5.501    79.599     0.150
     5.498    79.679     0.150
     5.605    80.878     0.150
     5.758    82.969     0.150
     6.078    85.619     0.150
     6.127    85.338     0.150
     5.825    84.459     0.150
     5.824   155.139     0.150
     6.158    89.583     0.150
     6.218    89.835     0.150
     6.275    89.279     0.150
     6.275   163.259     0.150
     6.375    90.798     0.150
     6.387    93.066     0.150
     6.591    94.515     0.150
     6.903    98.971     0.150
     7.210    99.438     0.150
     7.283   100.389     0.150
     6.995   100.719     0.150
     7.348   101.159     0.150
     7.353   101.289     0.150
     7.005   100.260     0.150
     7.380   101.729     0.150
     7.415   102.019     0.150
     7.107   100.749     0.150
     7.233   101.759     0.150
     7.267   102.628     0.150
     7.761   107.039     0.150
     7.761   107.099     0.150
     7.761   107.271     0.150
     7.845   107.769     0.150
     7.549   107.938     0.150
     7.586   107.409     0.150
     7.625   107.548     0.150
     7.983   110.099     0.150
     7.669   108.239     0.150
     7.844   112.579     0.150
     8.836   121.568     0.150
     8.564   120.989     0.150
     8.607   121.059     0.150
     8.908   126.803     0.150
     9.083   131.039     0.150
     9.083   128.588     0.150
     9.147   221.264     0.150
     9.147   129.829     0.150
     9.246   129.821     0.150
     9.292   131.289     0.150
     9.784   137.524     0.150
    10.126   141.338     0.150
    10.126   141.378     0.150
    10.109   142.249     0.150
    10.223   144.531     0.150
    10.269   145.729     0.150
    11.824   166.291     0.150
    12.666   173.739     0.150
    12.666   173.318     0.150
    12.614   172.622     0.150
    12.614   305.194     0.150
    12.614   172.526     0.150
    12.614   305.194     0.150
    12.925   179.597     0.150
    13.740   188.208     0.150
    14.180   195.039     0.150
    14.180   194.239     0.150
    14.180   194.259     0.150
    14.452   198.059     0.150
    16.635   226.108     0.150
    18.950   255.229     0.150
    22.403   294.938     0.150
    22.403   294.889     0.150
    23.278   303.329     0.150
    23.234   304.259     0.150
    24.712   318.539     0.150
    24.712   318.519     0.150
    24.826   319.159     0.150
    25.460   325.139     0.150
    25.460   325.128     0.150
    27.292   341.759     0.150
    27.339   340.739     0.150
    27.819   344.739     0.150
    27.759   345.628     0.150
    28.132   349.289     0.150
    28.716   354.289     0.150
    30.252   367.938     0.150
    30.252   367.958     0.150
    30.472   369.438     0.150
    31.061   374.338     0.150
    31.081  2277.139     0.150
    31.081   375.429     0.150
    31.180   376.179     0.150
    31.792   381.608     0.150
    33.280   395.239     0.150
    33.280   395.279     0.150
    33.280   398.648     0.150
    33.591   397.199     0.150
    34.104   401.648     0.150
    34.186  2260.083     0.150
    34.186   403.088     0.150
    35.254   411.019     0.150
    35.275   416.229     0.150
    35.538   414.119     0.150
    36.060   418.849     0.150
    36.479   422.779     0.150
    36.761   424.009     0.150
    37.827   432.739     0.150
    38.041   435.139     0.150
    38.041   435.108     0.150
    38.810   441.729     0.150
    39.223    11.500     0.150
    39.448   447.719     0.150
    41.716   465.539     0.150
    41.716   465.539     0.150
    42.692   473.739     0.150
    42.692   473.708     0.150
    43.958   484.749     0.150
    44.494   488.199     0.150
    45.346   495.438     0.150
    45.346   495.418     0.150
    45.728   498.179     0.150
    46.328   502.938     0.150
    46.328   502.958     0.150
    46.816  3516.538     0.150
    46.821  3516.949     0.150
    46.834  3517.769     0.150
    46.772   504.668     0.150
    46.772   504.519     0.150
    47.104   509.068     0.150
    47.971  3602.629     0.150
    47.984  3603.727     0.150
    47.988  3603.854     0.150
    47.934   514.869     0.150
    48.126     3.300     0.150
    48.126     4.900     0.150
    48.076   515.739     0.150
    48.076   515.688     0.150
    48.745   521.128     0.150
    48.745   521.148     0.150
    48.745   520.519     0.150
    48.931   522.898     0.150
    49.197   525.398     0.150
    49.544   526.599     0.150
    50.472     5.200     0.150
    50.517   548.139     0.150
    50.517   560.938     0.150
    50.517   657.938     0.150
    51.413   541.979     0.150
    53.746   558.858     0.150
    53.942   561.139     0.150
    54.389   563.289     0.150
    54.389   563.349     0.150
    54.271   563.019     0.150
    54.492   564.918     0.150
    54.812   566.389     0.150
    56.422   578.739     0.150
    56.357   629.938     0.150
    56.737   581.139     0.150
    56.737   581.168     0.150
    57.257   585.378     0.150
    57.969   588.918     0.150
    59.628     6.900     0.150
    59.777   605.798     0.150
    60.529     4.100     0.150
    61.248   612.909     0.150
    62.420   620.739     0.150
    62.420   620.539     0.150
    63.657   629.068     0.150
    63.657   629.219     0.150
    65.858  4921.539     0.150
    65.672   642.079     0.150
    65.672  1167.769     0.150
    66.262     7.600     0.150
    66.195   644.949     0.150
    66.850   649.389     0.150
    67.106     8.200     0.150
    67.136   650.179     0.150
    67.232   651.208     0.150
    67.337   652.298     0.150
    67.719     7.400     0.150
    68.655   913.838     0.150
    68.655  1651.639     0.150
    69.320   666.108     0.150
    69.577   667.309     0.150
    69.577   667.309     0.150
    69.577   694.539     0.150
    69.577   922.009     0.150
    69.577  1682.668     0.150
    69.577   667.239     0.150
    69.577   694.539     0.150
    69.577   820.938     0.150
    69.577   921.938     0.150
    69.577  1216.239     0.150
    69.577  1485.139     0.150
    70.018   669.349     0.150
    70.042   668.259     0.150
    71.170  5321.439     0.150
    71.418  5336.439     0.150
    71.182     3.700     0.150
    71.182     7.400     0.150
    71.115   677.079     0.150
    71.344   680.539     0.150
    71.289   676.418     0.150
    71.381  1236.199     0.150
    71.449   678.279     0.150
    71.449  1236.628     0.150
    71.737   679.818     0.150
    71.748   678.938     0.150
    71.748   678.889     0.150
    72.101   682.079     0.150
    72.038   682.099     0.150
    72.132   676.039     0.150
    72.250   682.239     0.150
    72.250   682.208     0.150
    72.247   682.818     0.150
    72.416   684.949     0.150
    72.724   694.229     0.150
    72.977   686.588     0.150
    73.068   687.479     0.150
    73.187   690.548     0.150
    73.100   687.999     0.150
    73.206   688.849     0.150
    73.116   688.938     0.150
    73.116   688.849     0.150
    73.162   688.938     0.150
    73.204   689.338     0.150
    73.204  1257.338     0.150
    73.636  5508.138     0.150
    73.658  5507.138     0.150
    73.233   689.739     0.150
    73.233  1259.139     0.150
    73.239   689.539     0.150
    73.730  5515.939     0.150
    73.404   690.449     0.150
    73.362   688.539     0.150
    73.362   688.619     0.150
    73.370   689.039     0.150
    73.370   688.898     0.150
    73.416   690.639     0.150
    73.416  1261.139     0.150
    73.863  5522.439     0.150
    73.650  1262.039     0.150
    73.650   691.639     0.150
    73.650  1262.039     0.150
    73.655   690.938     0.150
    73.719   692.438     0.150
    73.733   691.199     0.150
    73.995   692.729     0.150
    74.035   694.239     0.150
    74.062   692.708     0.150
    74.156   694.249     0.150
    74.208   693.568     0.150
    74.208   693.858     0.150
    74.137   695.229     0.150
    74.348   694.999     0.150
    74.474   697.389     0.150
    74.410   696.039     0.150
    74.410   696.048     0.150
    74.425   703.039     0.150
    74.425   696.739     0.150
    74.425  1268.438     0.150
    74.425   696.838     0.150
    74.471   696.539     0.150
    74.590   697.039     0.150
    74.651   697.199     0.150
    74.683   697.099     0.150
    75.073   699.249     0.150
    74.985   700.349     0.150
    75.105   700.239     0.150
    75.194   700.289     0.150
    75.226   700.599     0.150
    75.445   702.239     0.150
    75.633     7.879     0.150
    75.796     7.847     0.150
    75.859     7.951     0.150
    75.945   704.139     0.150
    75.964     7.524     0.150
    76.035   704.759     0.150
    76.054     7.832     0.150
    76.194     7.400     0.150
    76.097     7.848     0.150
    76.098     7.751     0.150
    76.184   707.438     0.150
    76.583     8.200     0.150
    76.393   708.438     0.150
    76.442     7.912     0.150
    76.446     7.952     0.150
    76.475   708.239     0.150
    76.510     7.981     0.150
    76.979     8.155     0.150
    77.167   711.358     0.150
    77.258   713.139     0.150
    77.310   719.438     0.150
    77.582   713.599     0.150
    77.836   721.838     0.150
    77.751   715.702     0.150
    78.039   717.656     0.150
    78.308   717.628     0.150
    78.227   718.338     0.150
    78.243   717.739     0.150
    78.400   718.539     0.150
    78.400   718.548     0.150
    78.428   717.739     0.150
    78.603   719.708     0.150
    78.623   714.733     0.150
    78.652   720.639     0.150
    78.652   720.548     0.150
    78.657   720.039     0.150
    78.887   721.438     0.150
    78.905   721.438     0.150
    78.901  1643.389     0.150
    79.388  5939.939     0.150
    79.051   722.631     0.150
    79.547   731.438     0.150
    79.526   720.438     0.150
    79.503  1649.128     0.150
    79.621   724.639     0.150
    79.871  1014.838     0.150
    79.871  1835.338     0.150
    80.060   727.579     0.150
    81.058   732.969     0.150
    81.132   736.139     0.150
    81.362   740.338     0.150
    81.504   733.369     0.150
    81.504     1.150     0.150
    81.423   731.338     0.150
    81.621   735.749     0.150
    81.624   743.838     0.150
    81.721   735.838     0.150
    81.953   737.139     0.150
    82.281   739.208     0.150
    82.299   739.088     0.150
    82.523   738.708     0.150
    83.790   745.229     0.150
    84.165   748.949     0.150
    87.274   772.338     0.150
    87.288   763.648     0.150
    92.230   785.628     0.150
    97.350   808.039     0.150
    98.869   816.139     0.150
    98.869   816.108     0.150
   100.189   820.679     0.150
   100.933   827.232     0.150
   109.418  8210.779     0.150
   109.428  8212.957     0.150
   109.435  8212.068     0.150
   145.647  1175.108     0.150
   148.763  1179.749     0.150
   159.452  1235.667     0.150
     3.146    43.828     0.150
     6.459    91.023     0.150
     1.589    55.457     0.150
    43.815   482.809     0.150
    47.054  3535.762     0.150
    47.059  3546.137     0.150
    47.072  3552.812     0.150
    48.207  3636.383     0.150
    48.220  3640.746     0.150
    48.224  3641.227     0.150
    57.031   585.438     0.150
    76.038   714.371     0.150
    76.069   715.309     0.150
    76.237   715.781     0.150
    76.444   714.164     0.150
    76.517   714.578     0.150
    77.115   713.484     0.150
     2.504    37.094     0.150
     0.402    12.738     0.150
     1.269    21.930     0.150
     1.470    45.941     0.150
     1.908    30.930     0.150
     5.258    76.221     0.150
     5.284    78.611     0.150
     6.080    86.871     0.150
     0.551    21.352     0.150
     0.633    12.961     0.150
    36.578   417.391     0.150
    63.077   617.625     0.150
     1.934    30.031     0.150
     6.870    98.629     0.150
     0.960    17.906     0.150
     0.995    18.781     0.150
     1.052    33.766     0.150
     2.765    43.266     0.150
     2.761    45.031     0.150
     2.800    46.594     0.150
     3.096    50.344     0.150
     3.156    51.039     0.150
     3.853    59.555     0.150
     6.314    93.203     0.150
     6.575    95.625     0.150
     7.605   111.453     0.150
    26.947   334.547     0.150
    31.853   383.594     0.150
     1.878    61.895     0.150
     2.714    40.555     0.150
     4.024    58.375     0.150
     6.042    87.824     0.150
     7.742   112.785     0.150
    21.289   279.273     0.150
    40.533   459.086     0.150
    65.835     9.297     0.150
     0.847    28.680     0.150
     0.993    32.648     0.150
     1.691    31.000     0.150
     1.946    34.188     0.150
     2.419    42.547     0.150
     2.687    45.367     0.150
     2.741    43.734     0.150
     2.765    46.172     0.150
     2.749    45.930     0.150
     2.807    46.633     0.150
     3.103    50.219     0.150
     3.161    51.633     0.150
     3.318    53.703     0.150
     7.597   111.820     0.150
     0.869    25.820     0.150
     1.292    23.030     0.150
     1.309    23.340     0.150
     1.321    23.700     0.150
     1.321    23.500     0.150
     1.261    23.270     0.150
     2.008    33.220     0.150
     2.428    39.260     0.150
     2.744    42.979     0.150
     2.768    43.840     0.150
     3.114    49.340     0.150
     4.503    69.939     0.150
     5.189    78.780     0.150
     1.453    23.882     0.150
     5.699    80.932     0.150
     1.273    23.227     0.150
     1.354    24.676     0.150
     2.071    35.316     0.150
     2.721    46.344     0.150
     2.744    43.527     0.150
     2.785    45.016     0.150
     3.207    49.207     0.150
     4.544    71.867     0.150
     5.840    84.797     0.150
     6.011    88.395     0.150
     8.094   117.055     0.150
     8.698   124.645     0.150
     0.689    14.236     0.150
     1.657    44.953     0.150
    43.706    31.043     0.150
    74.979    36.352     0.150
    74.979    62.832     0.150
    17.018    40.793     0.150
    68.792    60.432     0.150
    79.528    60.303     0.150
     4.614    66.092     0.150
    22.895    71.602     0.150
     5.327    76.293     0.150
   103.966    77.492     0.150
    77.255    78.082     0.150
    75.011    82.172     0.150
     6.268    88.592     0.150
    69.485    89.781     0.150
     6.373    90.252     0.150
     6.551    93.092     0.150
    47.240    94.062     0.150
     6.756    95.293     0.150
    31.411   105.453     0.150
    83.815   106.453     0.150
    71.974   107.412     0.150
     7.726   108.162     0.150
   115.007   123.152     0.150
     8.881   125.893     0.150
     9.839   138.012     0.150
    51.266   218.803     0.150
    71.399   298.531     0.150
    23.138   297.793     0.150
    23.138   297.793     0.150
   100.151   298.793     0.150
   116.820   300.643     0.150
    23.664   302.143     0.150
    25.589   321.771     0.150
    27.416   336.592     0.150
    27.416   335.332     0.150
    27.416   337.992     0.150
    27.549   340.723     0.150
    33.144   388.352     0.150
    34.812   402.893     0.150
    38.759   437.393     0.150
    42.288   485.293     0.150
    44.444    17.600     0.150
    45.811   493.393     0.150
    47.056   506.812     0.150
    47.056   508.822     0.150
    47.541  3615.004     0.150
    47.547  3615.051     0.150
    47.559  3617.789     0.150
    48.707  3695.105     0.150
    48.721  3696.809     0.150
    48.725  3693.398     0.150
    49.738   530.082     0.150
    55.516   567.912     0.150
    57.281    15.900     0.150
    61.362    20.801     0.150
    63.390   653.492     0.150
    63.390   621.133     0.150
    63.936   624.992     0.150
    63.958   624.441     0.150
    64.225   625.191     0.150
    64.544   629.893     0.150
    65.584   638.691     0.150
    65.682   632.893     0.150
    66.318    22.199     0.150
    67.072   651.992     0.150
    67.267   890.793     0.150
    68.190   902.492     0.150
    68.190   653.352     0.150
    68.190   653.352     0.150
    68.190   653.352     0.150
    68.190   804.242     0.150
    68.190   902.553     0.150
    68.190  1194.633     0.150
    68.190  1458.031     0.150
    68.190  1654.512     0.150
    68.850   657.252     0.150
    70.127   665.531     0.150
    70.143   664.672     0.150
    70.175   665.512     0.150
    70.299   666.293     0.150
    70.582   668.012     0.150
    70.861   670.893     0.150
    70.861   670.592     0.150
    70.861   688.992     0.150
    70.932   670.082     0.150
    70.867   670.133     0.150
    71.078   670.982     0.150
    71.366   669.463     0.150
    71.366  3290.652     0.150
    71.797   676.793     0.150
    71.839   677.092     0.150
    71.875   677.393     0.150
    71.881   677.893     0.150
    72.051   678.393     0.150
    72.051   678.412     0.150
    72.359   679.957     0.150
    72.356   680.982     0.150
    72.559   682.098     0.150
    72.694   680.264     0.150
    72.765   683.232     0.150
    72.940   681.873     0.150
    72.984   681.691     0.150
    73.048   683.793     0.150
    73.069   684.992     0.150
    73.106   683.590     0.150
    73.244   685.303     0.150
    73.413   686.691     0.150
    73.435   686.293     0.150
    73.666   687.598     0.150
    73.725   688.293     0.150
    73.966   687.922     0.150
    74.040   689.492     0.150
    74.040   689.492     0.150
    74.078   690.691     0.150
    74.445   693.896     0.150
    74.557   691.088     0.150
    74.661   692.650     0.150
    74.674   694.529     0.150
    74.693   694.592     0.150
    74.751   695.029     0.150
    74.753   695.178     0.150
    74.902   696.131     0.150
    75.011   695.422     0.150
    75.090   694.949     0.150
    75.152   696.719     0.150
    75.877   699.082     0.150
    76.857   705.578     0.150
    77.022   706.379     0.150
    77.267   707.729     0.150
    77.277   707.984     0.150
    77.409   704.293     0.150
    77.517   709.049     0.150
    77.814   711.031     0.150
    78.489   711.592     0.150
    78.489   887.492     0.150
    78.489  1006.092     0.150
    78.489  1812.793     0.150
     2.170   714.611     0.150
    78.844   719.373     0.150
    79.443   722.393     0.150
    80.533   719.473     0.150
    81.699   733.002     0.150
   150.960  1185.123     0.150
   150.960  1188.893     0.150
     1.247    22.895     0.150
    44.689    22.137     0.150
    44.689    38.586     0.150
     1.290    22.836     0.150
     1.406    24.457     0.150
     1.406    24.727     0.150
    17.744    29.047     0.150
     3.085    50.797     0.150
    74.078    52.336     0.150
     5.036    76.176     0.150
    69.534    76.234     0.150
    80.873    82.855     0.150
    80.873    83.195     0.150
     5.685    84.895     0.150
    23.672    89.266     0.150
    75.661    99.746     0.150
    70.385   107.688     0.150
    48.142   111.566     0.150
    32.204   122.957     0.150
     8.815   219.277     0.150
   115.882   139.266     0.150
    15.030   370.496     0.150
    21.013   281.426     0.150
    26.670   336.156     0.150
    30.640   374.336     0.150
    61.858   616.035     0.150
    65.917   643.336     0.150
    72.563   683.965     0.150
     0.957    18.266     0.150
    75.171    44.180     0.150
    75.171    25.453     0.150
    43.390    44.516     0.150
     3.719    54.125     0.150
    76.566    70.000     0.150
   104.901    70.289     0.150
    47.063    84.719     0.150
    31.398    98.883     0.150
   114.852   110.594     0.150
    10.219   141.094     0.150
    69.225   383.023     0.150
    74.397   688.461     0.150
     0.752    14.621     0.150
     0.967    17.441     0.150
    44.438    22.379     0.150
    44.438    39.180     0.150
     1.485    42.750     0.150
     1.485    24.602     0.150
     1.485    42.801     0.150
     1.485    24.645     0.150
     2.365    63.000     0.150
     2.384    63.988     0.150
     2.382    61.941     0.150
     2.699    71.430     0.150
    74.317    83.211     0.150
    74.317    47.641     0.150
    80.117    50.059     0.150
     4.235    62.102     0.150
    80.830    76.660     0.150
   103.212    88.629     0.150
    77.322    89.480     0.150
    84.318    96.961     0.150
     7.273   103.199     0.150
    47.903   105.930     0.150
     8.508   118.844     0.150
     8.621  2356.852     0.150
     8.621   119.680     0.150
     8.980   127.000     0.150
    13.593   188.059     0.150
    26.408   379.000     0.150
    26.408   329.922     0.150
    26.879   333.898     0.150
    27.869   342.922     0.150
    27.869   343.000     0.150
    28.327   347.891     0.150
    29.211   356.801     0.150
    30.321   368.859     0.150
    31.944  2270.000     0.150
    33.208   389.070     0.150
    34.047   399.102     0.150
    34.709  2257.273     0.150
    35.167   409.160     0.150
    35.167   559.219     0.150
    35.735   412.801     0.150
    35.735   412.094     0.150
    35.833   413.109     0.150
    36.421   416.590     0.150
    39.060   440.852     0.150
    39.267   445.344     0.150
    41.316   459.371     0.150
    41.980   482.699     0.150
    43.964   481.371     0.150
    44.082    22.301     0.150
    44.158   483.199     0.150
    44.158   483.301     0.150
    45.208   491.398     0.150
    45.785   493.602     0.150
    45.785   493.551     0.150
    45.996   495.801     0.150
    46.745    15.902     0.150
    47.769   511.199     0.150
    47.903   511.602     0.150
    47.903   511.512     0.150
    48.475   516.602     0.150
    49.390   538.000     0.150
    49.390   601.000     0.150
    52.356   536.852     0.150
    52.411   546.699     0.150
    52.795   549.199     0.150
    53.401   552.500     0.150
    53.428   553.102     0.150
    53.428   553.129     0.150
    53.446   554.699     0.150
    53.630   553.699     0.150
    53.880   556.199     0.150
    53.880   556.570     0.150
    54.963   583.094     0.150
    55.294   566.602     0.150
    55.294   566.512     0.150
    55.294   566.500     0.150
    55.448   622.602     0.150
    55.607   569.102     0.150
    56.896    12.801     0.150
    56.896    18.098     0.150
    59.440    13.000     0.150
    60.662   620.996     0.150
    61.448   609.602     0.150
    61.671   611.199     0.150
    61.793  1521.898     0.150
    62.925   620.320     0.150
    63.011    23.898     0.150
    63.662   623.500     0.150
    63.782   624.602     0.150
    63.782   624.895     0.150
    63.782   624.699     0.150
    63.891   625.301     0.150
    64.493   630.039     0.150
    64.519   630.219     0.150
    64.741   630.691     0.150
    65.139    16.402     0.150
    65.192    16.199     0.150
    65.227    16.898     0.150
    65.605   637.398     0.150
    65.605   637.969     0.150
    65.985   638.602     0.150
    66.010    19.598     0.150
    66.080   639.797     0.150
    66.273   641.500     0.150
    67.709   649.699     0.150
    67.940   652.836     0.150
    68.647   657.645     0.150
    68.697   908.301     0.150
    68.697   657.121     0.150
    68.697   657.121     0.150
    68.697   657.121     0.150
    68.697    14.160     0.150
    68.697   808.762     0.150
    68.697  1196.359     0.150
    68.697  1220.672     0.150
    68.697  1462.250     0.150
    68.869   658.129     0.150
    69.258   659.500     0.150
    88.162   664.070     0.150
    70.132   665.930     0.150
    70.138   665.191     0.150
    70.238   666.449     0.150
    70.298   666.961     0.150
    70.535   668.250     0.150
    70.587   668.738     0.150
    70.952   671.031     0.150
    70.983   672.062     0.150
    71.097   671.801     0.150
    71.338   673.602     0.150
    71.473   673.898     0.150
    71.473    14.402     0.150
    71.473  1226.000     0.150
    71.473  1524.000     0.150
    71.473  1788.000     0.150
    71.919   677.699     0.150
    71.971   679.000     0.150
    71.973   677.379     0.150
    72.022   678.008     0.150
    72.141   678.934     0.150
    72.258   679.449     0.150
    72.258   679.277     0.150
    72.258   679.520     0.150
    72.258   679.398     0.150
    72.319   679.773     0.150
    72.359   680.199     0.150
    72.390   680.000     0.150
    72.430   680.398     0.150
    72.476   685.000     0.150
    72.469   678.602     0.150
    72.468   680.602     0.150
    72.468   680.570     0.150
    72.477   679.000     0.150
    72.477   679.352     0.150
    72.499   681.000     0.150
    72.499   680.969     0.150
    72.642   681.801     0.150
    72.895   683.199     0.150
    72.895   683.270     0.150
    72.934   682.898     0.150
    72.941   683.398     0.150
    73.016   683.359     0.150
    73.069   683.602     0.150
    73.069   683.102     0.150
    73.108   701.340     0.150
    73.244   685.102     0.150
    73.244   685.121     0.150
    73.337   686.410     0.150
    73.646   687.398     0.150
    73.646   687.371     0.150
    73.681   688.000     0.150
    73.696   687.398     0.150
    73.931   688.621     0.150
    73.974   689.328     0.150
    73.974   689.551     0.150
    73.979   689.629     0.150
    73.998   689.602     0.150
    73.998   689.504     0.150
    74.057   689.469     0.150
    74.042   689.801     0.150
    74.274   691.230     0.150
    74.274   691.301     0.150
    74.615   693.199     0.150
    74.664   693.699     0.150
    74.683   693.711     0.150
    74.683   693.801     0.150
    75.117    13.980     0.150
    75.229   697.195     0.150
    75.302    14.102     0.150
    75.378    13.785     0.150
    75.383    13.207     0.150
    75.529    14.500     0.150
    75.551   698.121     0.150
    75.704    14.867     0.150
    75.759    13.484     0.150
    75.966    15.055     0.150
    76.173    13.723     0.150
    76.224    14.602     0.150
    76.359   703.371     0.150
    76.424   703.270     0.150
    77.182   708.602     0.150
    77.578   709.602     0.150
    77.898   712.930     0.150
     2.974   713.172     0.150
    78.183   713.102     0.150
    78.183   713.281     0.150
    78.183   713.320     0.150
    78.144   713.301     0.150
    78.275   709.602     0.150
    78.485    13.199     0.150
    78.485   886.898     0.150
    78.485  1816.500     0.150
    78.787   717.699     0.150
    78.885  1001.500     0.150
    78.885  1821.301     0.150
    79.895  1021.000     0.150
    80.565   726.262     0.150
    80.565   721.219     0.150
    80.801   727.301     0.150
    80.780   726.309     0.150
    80.801   727.301     0.150
    80.801   727.535     0.150
    81.330   731.070     0.150
    81.377   728.699     0.150
    81.621   732.699     0.150
    81.652   732.500     0.150
    81.733   733.301     0.150
    81.733   733.352     0.150
    81.865   734.266     0.150
    82.545   737.699     0.150
    94.351   737.121     0.150
    94.351   737.398     0.150
    83.133   740.500     0.150
    83.133   740.395     0.150
    83.133   740.000     0.150
    83.548   742.102     0.150
    86.611   755.820     0.150
    81.557   761.898     0.150
    88.151   780.344     0.150
    88.782   753.602     0.150
    91.141   778.391     0.150
    91.562   791.344     0.150
    96.382   801.801     0.150
    97.810   808.602     0.150
    97.810   809.297     0.150
    99.914  1086.750     0.150
   141.727  1159.672     0.150
   141.727  1175.699     0.150
   146.299  1172.898     0.150
   147.902  1179.102     0.150
   151.490  1187.270     0.150
   151.490  1181.000     0.150
   151.490  1183.625     0.150
   155.081  1195.668     0.150
   160.588  1233.434     0.150
    44.451    21.777     0.150
    44.451    38.859     0.150
    17.543    30.809     0.150
     2.396    38.559     0.150
    74.305    47.488     0.150
    39.964    65.457     0.150
    69.332    71.387     0.150
    75.562    93.840     0.150
     9.788   139.207     0.150
    45.126   488.746     0.150
    75.148    25.652     0.150
    68.842    48.684     0.150
    79.619    54.484     0.150
    22.929    60.395     0.150
    76.577    70.242     0.150
    74.084    73.562     0.150
     5.426    79.453     0.150
     5.533    80.805     0.150
    68.566    81.855     0.150
    44.259    29.312     0.150
    44.259    51.430     0.150
    17.558    34.586     0.150
    74.421    40.961     0.150
    74.421    71.922     0.150
    80.081    55.062     0.150
    69.337    64.156     0.150
   103.720    84.242     0.150
    76.948    84.391     0.150
    75.032    88.602     0.150
    69.687    96.562     0.150
    47.799   101.070     0.150
    31.962   113.031     0.150
     8.379   116.875     0.150
    76.109    22.586     0.150
     1.361    21.352     0.150
     1.381    44.047     0.150
     1.576    50.422     0.150
     1.628    27.523     0.150
     2.624    39.867     0.150
   105.037    61.906     0.150
    77.340    61.734     0.150
    74.329    66.484     0.150
    11.384   162.602     0.150
    18.627   255.375     0.150
    56.348   575.531     0.150
    63.897   628.062     0.150
    66.191   642.352     0.150
    84.194   746.531     0.150
     0.718    14.805     0.150
     1.340    23.000     0.150
    44.295    23.031     0.150
    44.295    40.320     0.150
    74.454    45.609     0.150
    79.987    51.492     0.150
   148.877    58.602     0.150
    23.326    81.422     0.150
   103.317    87.305     0.150
    77.357    87.836     0.150
    75.497    92.125     0.150
     7.183   103.891     0.150
    47.765   104.711     0.150
     7.992   111.406     0.150
    14.698   201.031     0.150
    20.614   272.414     0.150
    64.106   625.070     0.150
    96.685   804.969     0.150
   151.439  1184.477     0.150
     1.149    20.329     0.150
    74.795    32.009     0.150
    74.795    55.819     0.150
    43.806    38.199     0.150
   147.884    44.899     0.150
   104.425    76.919     0.150
    76.650    76.839     0.150
    74.417    78.879     0.150
     6.815    95.729     0.150
     6.972   100.119     0.150
     7.294   102.629     0.150
     7.568   106.729     0.150
    83.210   109.589     0.150
   115.214   117.869     0.150
    13.622   188.549     0.150
    27.116   333.899     0.150
    28.507   345.989     0.150
    38.715   351.869     0.150
    30.138   362.579     0.150
    37.980   427.799     0.150
    38.916   438.039     0.150
    42.968   471.219     0.150
    55.315   564.589     0.150
    60.634   599.789     0.150
    62.974   617.209     0.150
    70.839   667.139     0.150
    71.223   668.529     0.150
    73.696   683.893     0.150
    74.193   687.689     0.150
    75.183   693.039     0.150
    75.183   693.039     0.150
    75.448   693.809     0.150
    76.740   701.859     0.150
    76.740   701.859     0.150
    78.843   714.559     0.150
    80.915   724.829     0.150
    81.109   726.019     0.150
    81.263   726.399     0.150
    81.453   728.029     0.150
    82.255   731.519     0.150
    82.255   731.519     0.150
    75.031    29.844     0.150
    75.031    52.164     0.150
    43.574    39.664     0.150
   147.934    43.000     0.150
    22.967    64.812     0.150
   104.518    73.742     0.150
    76.790    73.977     0.150
    39.242    80.953     0.150
    47.195    89.422     0.150
    31.465   102.023     0.150
   114.978   115.820     0.150
     0.936    17.076     0.150
    44.152    28.416     0.150
    44.152    16.266     0.150
     1.614    52.900     0.150
     1.614    26.416     0.150
    74.716    52.176     0.150
    76.204    95.555     0.150
    70.684   102.885     0.150
     8.996   126.715     0.150
    13.199   185.430     0.150
    13.199   327.531     0.150
    15.168   210.705     0.150
    20.768   278.906     0.150
    24.406   315.635     0.150
   101.269   319.986     0.150
    25.758   327.305     0.150
    26.753   338.355     0.150
    26.944   339.795     0.150
    28.269   350.725     0.150
    28.545   351.316     0.150
    31.446   381.305     0.150
    79.001   385.305     0.150
    29.661   384.605     0.150
    34.482   407.775     0.150
    34.482   407.781     0.150
    35.596   416.605     0.150
    35.932   418.045     0.150
    37.161   426.465     0.150
    38.162   438.725     0.150
    43.915   484.555     0.150
    46.158   501.686     0.150
    46.770   505.695     0.150
    47.718   510.906     0.150
    56.395   578.746     0.150
    57.233   584.035     0.150
    58.764   594.846     0.150
    62.272   618.605     0.150
    63.517   627.666     0.150
    65.149   637.436     0.150
    65.409   638.656     0.150
    65.853     9.199     0.150
    67.326     7.199     0.150
    67.326   684.906     0.150
    70.775     3.199     0.150
    70.775     7.199     0.150
    71.052   675.166     0.150
    71.310   677.996     0.150
    72.071  2123.605     0.150
    72.611   683.865     0.150
    72.661   683.205     0.150
    73.034   687.715     0.150
    73.034   685.006     0.150
    73.156   686.115     0.150
    73.905   692.846     0.150
    75.817    10.699     0.150
    76.299   707.066     0.150
    76.961   710.266     0.150
    81.316   734.955     0.150
    82.702   741.525     0.150
    83.752   745.705     0.150
   146.263  1176.645     0.150
     0.475     9.680     0.150
     1.353    23.672     0.150
    76.078    27.500     0.150
    76.078    47.250     0.150
     1.602    51.461     0.150
     1.730    30.609     0.150
     1.762    31.023     0.150
   148.327    38.102     0.150
     2.474    41.078     0.150
     2.565    40.570     0.150
     3.146    48.742     0.150
    67.802    54.344     0.150
    80.611    55.891     0.150
   104.757    64.625     0.150
    77.571    66.000     0.150
    68.767    76.602     0.150
    46.145    82.930     0.150
     5.618    83.430     0.150
    30.391    92.234     0.150
   113.923   117.859     0.150
    13.160   185.758     0.150
    64.144   631.602     0.150
     1.454    22.938     0.150
    75.340    25.109     0.150
    75.340    43.547     0.150
   147.790    38.070     0.150
    43.242    43.477     0.150
    79.876    54.203     0.150
    22.709    60.328     0.150
   104.828    68.320     0.150
    76.798    68.391     0.150
    74.214    72.102     0.150
    79.277    72.930     0.150
    68.623    80.078     0.150
    46.890    83.930     0.150
    31.199    96.523     0.150
   114.676   111.672     0.150
    74.930    13.016     0.150
    74.930    22.576     0.150
    80.885    14.466     0.150
    80.885    25.355     0.150
    97.773    15.366     0.150
    97.773    26.556     0.150
     0.592    25.985     0.150
     1.915    55.646     0.150
     1.915    30.326     0.150
    74.221    40.376     0.150
    74.221    71.105     0.150
     2.905    43.275     0.150
   148.083    54.786     0.150
    80.319    56.936     0.150
    69.599    62.286     0.150
    40.048    69.416     0.150
    79.782    69.516     0.150
    23.698    74.716     0.150
     5.584    80.065     0.150
     6.319    89.466     0.150
    83.504    99.296     0.150
    48.001   101.146     0.150
     7.271   104.246     0.150
    32.210   114.156     0.150
    13.302   182.806     0.150
    13.302   182.805     0.150
    13.302   322.341     0.150
    80.351    18.555     0.150
    80.351    32.305     0.150
    97.764    18.562     0.150
    97.764    32.223     0.150
    75.037    18.723     0.150
    74.203    38.742     0.150
    74.203    66.973     0.150
    44.364    41.613     0.150
    69.741    57.434     0.150
    80.411    62.711     0.150
    23.829    69.492     0.150
    76.130    82.645     0.150
    48.028    97.871     0.150
    32.325   112.004     0.150
    74.501     9.273     0.150
    74.501    15.684     0.150
    80.816    10.234     0.150
    98.231    14.996     0.150
     1.199    21.754     0.150
     1.309    23.754     0.150
     1.336    24.152     0.150
     1.359    43.062     0.150
     1.359    24.734     0.150
     1.378    43.883     0.150
     1.381    24.676     0.150
     1.825    31.184     0.150
    74.677    37.715     0.150
    74.677    66.844     0.150
    43.946    41.125     0.150
     2.492    41.773     0.150
     4.171    64.375     0.150
     5.755    88.074     0.150
     5.998    90.574     0.150
     6.268    95.074     0.150
     7.780   116.176     0.150
    31.737   383.891     0.150
    67.333   663.473     0.150
    74.499     9.318     0.150
    74.499    15.408     0.150
    80.812    10.238     0.150
    80.812    17.628     0.150
    98.234    15.098     0.150
     1.189    20.658     0.150
     1.354    24.758     0.150
     1.373    25.008     0.150
     2.117    36.588     0.150
    74.679    36.928     0.150
    74.679    65.818     0.150
    43.943    40.238     0.150
     2.488    41.918     0.150
   148.035    51.968     0.150
     3.391    51.758     0.150
    69.183    61.048     0.150
     4.167    64.428     0.150
     4.668    70.908     0.150
    23.276    73.028     0.150
   115.598    86.628     0.150
    80.250    35.934     0.150
    73.952    21.484     0.150
    75.346    21.895     0.150
    98.910    22.984     0.150
   147.497    35.223     0.150
    79.617    50.793     0.150
    22.775    57.504     0.150
    76.553    66.715     0.150
    73.918    69.574     0.150
    79.314    72.035     0.150
    46.891    82.234     0.150
    31.253    95.754     0.150
    80.400     6.266     0.150
    80.400    10.957     0.150
    74.721     7.977     0.150
    74.721    13.617     0.150
    98.083    10.465     0.150
     1.113    35.117     0.150
     1.108    36.305     0.150
     1.234    22.996     0.150
     1.334    23.266     0.150
     1.411    25.324     0.150
     1.404    25.277     0.150
     1.611    28.645     0.150
     1.714    29.965     0.150
     1.767    31.984     0.150
    74.522    35.555     0.150
    44.048    43.984     0.150
   147.618    49.598     0.150
    69.428    58.215     0.150
     7.159   106.234     0.150
     8.047   118.965     0.150
     0.445     9.562     0.150
     1.044    32.328     0.150
    73.612    30.117     0.150
    75.366    45.500     0.150
   149.435    56.719     0.150
     5.113    74.102     0.150
   103.347    81.406     0.150
    22.359    81.891     0.150
    78.199    82.438     0.150
    75.872    87.672     0.150
    46.857    99.727     0.150
    30.893   108.891     0.150
     8.097   117.398     0.150
     8.510   123.500     0.150
     8.570   124.102     0.150
    14.575   204.031     0.150
    30.995   373.023     0.150
    62.109   619.578     0.150
    66.916   649.781     0.150
    74.665    17.988     0.150
    74.665    30.938     0.150
    97.914    21.328     0.150
    97.914    37.719     0.150
     1.377    23.090     0.150
    74.378    45.328     0.150
    80.073    51.328     0.150
   148.783    58.551     0.150
     4.340    63.391     0.150
    39.890    66.258     0.150
     5.705    82.188     0.150
   103.357    87.277     0.150
    77.246    88.090     0.150
   115.507    91.648     0.150
     6.857    96.891     0.150
     6.857    96.988     0.150
    84.188    97.988     0.150
    72.340    98.688     0.150
     7.129   100.688     0.150
    47.842   104.750     0.150
     7.419   104.988     0.150
     8.895   125.988     0.150
    10.657   147.090     0.150
    14.672   202.488     0.150
    26.441   328.488     0.150
    28.183   343.879     0.150
    28.978   353.988     0.150
    29.115   355.188     0.150
    31.894   378.891     0.150
    30.086   385.688     0.150
    33.131   387.559     0.150
    33.131   387.848     0.150
    33.999   394.891     0.150
    33.990   398.688     0.150
    33.990   397.090     0.150
    36.100   415.789     0.150
    36.100   415.289     0.150
    36.381   496.789     0.150
    36.381   923.590     0.150
    38.312   433.090     0.150
    38.305   451.250     0.150
    39.051   440.391     0.150
    44.016   479.590     0.150
    45.143   489.090     0.150
    45.143   489.488     0.150
    45.804   492.590     0.150
    47.694   509.391     0.150
    47.951   510.391     0.150
    48.407   514.891     0.150
    48.407   515.980     0.150
    48.773   519.090     0.150
    49.361   539.789     0.150
    49.361   608.590     0.150
    51.593   538.988     0.150
    52.308   544.391     0.150
    52.516   545.488     0.150
    52.822   546.988     0.150
    53.269   550.090     0.150
    54.943   562.891     0.150
    54.971   560.988     0.150
    55.264   565.391     0.150
    55.264   565.250     0.150
    55.320   685.488     0.150
    61.532   609.289     0.150
    61.532   609.289     0.150
    62.786   618.328     0.150
    63.558   621.488     0.150
    63.707   623.289     0.150
    63.707   623.160     0.150
    63.816   660.340     0.150
    64.610   629.891     0.150
    65.112    21.301     0.150
    65.461   636.000     0.150
    65.996    17.199     0.150
    66.014   637.988     0.150
    66.513    20.301     0.150
    66.513  1155.090     0.150
    67.586   647.898     0.150
    67.586   647.891     0.150
    67.586  1226.188     0.150
    67.586   648.039     0.150
    68.800   656.688     0.150
    88.030   662.348     0.150
    70.065   664.770     0.150
    70.232   665.500     0.150
    70.520   667.348     0.150
    70.882   669.461     0.150
    70.819   669.660     0.150
    71.028   670.508     0.150
    71.334   672.090     0.150
    71.334   671.988     0.150
    71.835   679.770     0.150
    71.888   675.828     0.150
    72.185   677.828     0.150
    72.185   677.488     0.150
    72.185   677.590     0.150
    72.221   677.988     0.150
    72.252   678.090     0.150
    72.293   678.188     0.150
    72.330   678.488     0.150
    72.340   676.988     0.150
    72.340   677.289     0.150
    72.347   677.391     0.150
    72.347   677.469     0.150
    72.359   678.789     0.150
    72.505   679.688     0.150
    72.757   680.988     0.150
    72.804   681.188     0.150
    72.990   681.391     0.150
    73.107   682.688     0.150
    73.140   682.688     0.150
    73.508   684.988     0.150
    73.542   685.988     0.150
    73.559   685.391     0.150
    73.634   685.719     0.150
    73.847   688.078     0.150
    73.857   687.188     0.150
    73.904   688.590     0.150
    74.008   688.359     0.150
    74.140   690.609     0.150
    74.395   691.062     0.150
    74.479   691.188     0.150
    74.527   691.930     0.150
    74.527   691.930     0.150
    74.547   692.551     0.150
    74.928   692.789     0.150
    75.093   694.590     0.150
    75.484   695.988     0.150
    75.547   697.598     0.150
    26.250   697.359     0.150
    76.220   701.301     0.150
    76.290   701.289     0.150
    76.379   702.188     0.150
    76.746   703.789     0.150
    76.937   706.789     0.150
    77.224   706.988     0.150
    77.240   707.391     0.150
    77.443   707.688     0.150
    77.606   709.289     0.150
    77.663   708.090     0.150
    77.689   709.090     0.150
    77.889   709.090     0.150
    78.067   711.188     0.150
    78.042   712.230     0.150
     2.833   711.949     0.150
     2.833   711.688     0.150
    78.375  1808.891     0.150
    78.426   712.188     0.150
    78.766   998.488     0.150
    78.766  1817.590     0.150
    80.420   724.590     0.150
    80.644   720.500     0.150
    80.736   725.891     0.150
    80.861   728.891     0.150
    81.185   728.488     0.150
    81.304   727.891     0.150
    81.338   723.738     0.150
    81.344   728.270     0.150
    81.589   730.789     0.150
    82.688   735.320     0.150
    82.741   735.188     0.150
    83.008   737.508     0.150
    83.101   738.289     0.150
    83.351   738.090     0.150
    97.704   806.988     0.150
    97.704   806.988     0.150
   123.182  1129.688     0.150
   147.771  1174.160     0.150
   151.358  1179.289     0.150
    74.909     8.590     0.150
    74.909    14.859     0.150
    81.053    11.953     0.150
     0.713    24.781     0.150
    97.762    13.703     0.150
    97.762    23.160     0.150
     2.676    41.633     0.150
    74.214    42.453     0.150
     2.950    45.383     0.150
     3.034    45.992     0.150
     3.074    47.453     0.150
     3.672    55.082     0.150
    80.304    56.520     0.150
   148.249    56.230     0.150
     4.123    61.750     0.150
     4.251    61.859     0.150
     4.260    62.859     0.150
     4.364    64.500     0.150
     4.515    66.742     0.150
    40.054    70.910     0.150
     4.964    74.652     0.150
     5.409    79.641     0.150
    23.671    80.160     0.150
     6.111    90.582     0.150
    74.913    93.000     0.150
     6.879   101.020     0.150
    69.644   101.422     0.150
    48.007   105.141     0.150
     7.317   106.961     0.150
     7.447   109.562     0.150
     7.918   115.453     0.150
    13.343   192.281     0.150
    20.528   277.656     0.150
    20.528   527.957     0.150
    26.640   337.453     0.150
    30.638   372.340     0.150
    30.814   373.473     0.150
    32.144   386.051     0.150
    45.407   495.820     0.150
    45.407   594.992     0.150
    45.806   498.902     0.150
    55.136   570.781     0.150
    58.458   593.770     0.150
    72.320   683.102     0.150
    79.973   726.270     0.150
   150.848  1189.281     0.150
    80.169    17.095     0.150
    74.254    18.785     0.150
    74.254    32.854     0.150
     1.171    18.994     0.150
     1.171    34.044     0.150
     1.171    19.225     0.150
     1.171    34.265     0.150
     1.102    20.245     0.150
    98.613    20.515     0.150
     1.229    21.314     0.150
     1.244    21.415     0.150
     1.276    21.655     0.150
     1.390    22.944     0.150
     1.390    41.345     0.150
     1.316    23.495     0.150
     1.423    24.205     0.150
    75.048    24.015     0.150
    75.048    43.755     0.150
     1.451    25.274     0.150
     1.764    28.354     0.150
     1.715    29.165     0.150
     1.877    31.645     0.150
   147.409    41.035     0.150
    79.438    56.405     0.150
     5.166    78.774     0.150
    68.414    84.265     0.150
    47.190    87.365     0.150
    31.554   102.045     0.150
    12.349   174.225     0.150
    13.051   185.825     0.150
    19.327   265.005     0.150
    55.206   572.255     0.150
    58.137   590.625     0.150
     0.650    12.662     0.150
     0.829    16.193     0.150
    75.661    19.502     0.150
    75.661    34.762     0.150
     1.197    22.693     0.150
     1.378    23.273     0.150
     1.444    23.662     0.150
     1.411    41.672     0.150
     1.477    44.562     0.150
     1.819    29.604     0.150
     1.828    54.354     0.150
     1.828    54.883     0.150
     1.891    31.072     0.150
     1.891    31.273     0.150
   147.667    35.053     0.150
     2.172    37.293     0.150
     2.290    38.963     0.150
     2.417    38.492     0.150
     2.860    47.092     0.150
   105.122    66.822     0.150
    76.832    65.842     0.150
     4.438    70.262     0.150
   114.946    70.043     0.150
    68.349    77.443     0.150
    78.984    81.473     0.150
     6.043    92.082     0.150
    30.918    94.723     0.150
     8.718   125.992     0.150
     8.660   127.643     0.150
     9.108   132.354     0.150
     9.171   133.963     0.150
    70.341   301.062     0.150
   103.448   323.553     0.150
    26.574   342.762     0.150
    27.520   351.232     0.150
    29.559   361.922     0.150
    29.865   366.133     0.150
    99.224   379.203     0.150
    32.775   391.963     0.150
    32.775   394.492     0.150
    35.062   411.783     0.150
    38.371   439.863     0.150
    38.391   440.242     0.150
    44.292   488.822     0.150
    63.667   629.193     0.150
    70.544   672.193     0.150
    74.706   699.152     0.150
    74.691   701.393     0.150
    75.934   708.672     0.150
    81.557   737.793     0.150
    94.313   794.393     0.150
   149.976  1186.092     0.150
     0.538    11.039     0.150
     0.625    12.498     0.150
    76.108    23.469     0.150
    76.108    41.818     0.150
     1.884    28.299     0.150
    80.865    30.918     0.150
    73.112    31.549     0.150
    73.112    57.389     0.150
   148.120    34.770     0.150
    99.664    33.789     0.150
    21.910    59.318     0.150
   104.962    61.270     0.150
    77.410    62.209     0.150
   114.370    65.578     0.150
    68.558    73.959     0.150
    46.118    78.979     0.150
    30.401    89.709     0.150
     8.215   114.328     0.150
     9.083   125.520     0.150
    11.402   161.658     0.150
    11.402   282.109     0.150
    12.960   182.338     0.150
    18.670   255.869     0.150
    29.286   361.559     0.150
    30.352   367.078     0.150
    43.740   484.258     0.150
    49.589   530.482     0.150
    49.589   530.479     0.150
    56.397   579.250     0.150
    63.971   630.230     0.150
    66.257   647.629     0.150
    66.257   647.629     0.150
     0.970    18.398     0.150
     0.986    33.180     0.150
     1.117    19.484     0.150
     1.284    39.039     0.150
     1.284    22.773     0.150
     1.284    38.141     0.150
     1.292    41.172     0.150
     1.356    24.703     0.150
     1.493    26.773     0.150
     1.599    28.391     0.150
     1.604    28.195     0.150
     1.664    29.281     0.150
     1.820    31.805     0.150
     1.857    32.172     0.150
    74.632    33.836     0.150
    74.632    58.539     0.150
     2.248    39.594     0.150
     2.272    37.648     0.150
     2.807    44.492     0.150
   147.567    48.422     0.150
     3.344    52.375     0.150
    69.338    55.719     0.150
     3.837    58.375     0.150
    79.445    63.461     0.150
     4.429    67.664     0.150
    23.425    69.359     0.150
    68.778    91.711     0.150
     6.271    95.352     0.150
     6.689   100.125     0.150
     7.056   104.711     0.150
     7.220   189.492     0.150
    18.524   261.734     0.150
     1.257    23.100     0.150
    74.825    29.270     0.150
   147.431    41.999     0.150
    69.190    49.550     0.150
    76.278    73.680     0.150
    73.952    76.579     0.150
   115.748    78.220     0.150
    47.412    88.560     0.150
    30.663   369.340     0.150
    58.052   580.810     0.150
    65.057   626.909     0.150
     0.766    23.012     0.150
     1.240    22.609     0.150
     1.527    27.859     0.150
    74.180    43.121     0.150
     2.545    41.211     0.150
     2.823    44.102     0.150
   147.865    56.129     0.150
    69.688    62.270     0.150
    80.389    62.902     0.150
    23.781    76.590     0.150
     5.768    88.070     0.150
     5.827    88.539     0.150
     5.862    89.391     0.150
    76.388    87.559     0.150
    74.531    91.402     0.150
    48.044   103.559     0.150
     7.795   116.391     0.150
   115.825   127.160     0.150
     9.717   138.109     0.150
    54.877   574.469     0.150
     0.691    13.445     0.150
    75.146    38.846     0.150
   148.871    50.756     0.150
    68.553    64.676     0.150
    39.121    76.115     0.150
   103.733    77.977     0.150
   114.826   127.205     0.150
    12.545   177.111     0.150
    19.955   266.217     0.150
    20.012   266.887     0.150
    44.376   484.326     0.150
    64.315   628.676     0.150
    81.830    23.359     0.150
     1.540    46.203     0.150
    98.205    25.188     0.150
    74.674    44.906     0.150
   149.045    57.234     0.150
     4.248    60.625     0.150
    68.957    69.453     0.150
     5.146    72.844     0.150
    23.088    81.453     0.150
   103.295    85.516     0.150
    77.587    87.016     0.150
   115.147    90.047     0.150
    75.620    91.430     0.150
     8.230   114.953     0.150
    14.690   198.070     0.150
    14.690   198.078     0.150
    30.100   363.469     0.150
    81.561    20.469     0.150
    98.341    22.840     0.150
    74.802    41.148     0.150
    74.802    71.160     0.150
     3.286    86.238     0.150
   148.785    53.719     0.150
   148.785    92.969     0.150
    79.662    57.109     0.150
    68.896    65.871     0.150
    39.465    72.258     0.150
    23.011    76.809     0.150
   103.610    81.988     0.150
    77.417    82.648     0.150
    75.327    86.879     0.150
    69.838    94.621     0.150
     8.236   208.301     0.150
    12.870   179.125     0.150
    14.379   197.199     0.150
    20.235   271.000     0.150
    27.308   338.078     0.150
    30.098   367.750     0.150
    44.714   487.949     0.150
    45.576   494.168     0.150
    55.869   572.051     0.150
    64.128   628.309     0.150
    66.123   640.578     0.150
   147.138  1174.820     0.150
     0.905    16.270     0.150
    99.238    27.059     0.150
   147.594    32.330     0.150
   147.594    56.080     0.150
    68.356    44.459     0.150
    22.444    55.139     0.150
   105.195    63.600     0.150
    76.775    63.150     0.150
    73.956    65.850     0.150
    46.562    78.729     0.150
    78.982    77.180     0.150
    11.745   284.314     0.150
    12.782   178.449     0.150
    18.818   255.420     0.150
     0.725    14.018     0.150
     0.762    15.107     0.150
    80.967    15.586     0.150
    80.967    28.207     0.150
    98.467    18.457     0.150
    98.467    32.666     0.150
   148.199    46.557     0.150
    68.924    57.518     0.150
    80.103    62.336     0.150
    79.632    63.357     0.150
    23.018    69.176     0.150
    39.354    77.426     0.150
    12.621   175.912     0.150
    13.803   188.262     0.150
    20.220   261.836     0.150
    31.481   377.236     0.150
    44.792   488.688     0.150
    55.591   562.549     0.150
    85.615   748.137     0.150
   147.653    39.887     0.150
    79.660    55.750     0.150
    23.008    61.578     0.150
    79.572    70.539     0.150
    76.562    71.617     0.150
    74.131    75.547     0.150
     5.320    78.258     0.150
   114.964   112.238     0.150
     0.588    21.078     0.150
    80.604    16.238     0.150
    74.173    16.068     0.150
    74.173    26.809     0.150
    98.612    18.969     0.150
    75.053    28.538     0.150
    43.539    42.339     0.150
   147.843    42.589     0.150
    68.878    52.019     0.150
    79.548    68.499     0.150
    76.721    72.488     0.150
    74.323    75.969     0.150
    76.018    21.416     0.150
    76.018    36.896     0.150
     1.283    22.086     0.150
     1.307    22.586     0.150
    73.223    29.547     0.150
   147.974    32.957     0.150
    42.582    47.996     0.150
    80.275    49.926     0.150
    22.029    57.387     0.150
   105.044    60.797     0.150
    77.247    61.297     0.150
    74.281    65.076     0.150
    46.210    77.848     0.150
    74.573    13.710     0.150
    74.573    24.740     0.150
    80.752    14.780     0.150
    98.169    16.240     0.150
     1.718    28.470     0.150
    74.614    35.120     0.150
    44.002    36.460     0.150
   147.972    49.229     0.150
    69.259    57.450     0.150
    79.803    63.790     0.150
    23.351    69.149     0.150
   104.237    78.500     0.150
   104.237    79.550     0.150
    76.651    79.580     0.150
    47.611    95.109     0.150
   115.391   119.710     0.150
    44.440    27.594     0.150
    44.440    48.133     0.150
    74.255    44.062     0.150
    80.230    52.992     0.150
   148.499    57.465     0.150
    80.166    72.984     0.150
    23.584    78.914     0.150
   103.541    87.445     0.150
    76.957    87.633     0.150
    75.158    91.105     0.150
   115.726   128.742     0.150
    44.329    25.979     0.150
    44.329    41.829     0.150
    74.414    45.609     0.150
   148.832    58.409     0.150
    69.248    69.129     0.150
    80.513    74.489     0.150
    20.629   274.669     0.150
    30.406   369.259     0.150
    45.051   491.629     0.150
    80.459    18.539     0.150
    80.459    32.664     0.150
    74.016    19.258     0.150
    74.016    34.023     0.150
    75.243    24.641     0.150
    75.243    45.312     0.150
     1.934    29.258     0.150
     2.468    68.328     0.150
   147.703    38.281     0.150
    68.734    48.492     0.150
     3.400    51.969     0.150
     3.811    57.430     0.150
    22.822    59.891     0.150
     4.192    64.008     0.150
     4.379    64.203     0.150
   104.850    70.703     0.150
    79.384    72.414     0.150
    74.145    73.133     0.150
     5.620    82.242     0.150
    46.989    85.953     0.150
     6.066    85.484     0.150
     6.447    94.797     0.150
    31.309    97.203     0.150
   114.777   110.992     0.150
    74.162    15.852     0.150
    74.162    27.625     0.150
     1.622    48.156     0.150
     1.622    48.789     0.150
     2.239    33.984     0.150
    74.965    34.531     0.150
   148.415    48.914     0.150
    79.554    62.141     0.150
    80.312    64.492     0.150
    39.303    76.836     0.150
   104.042    77.375     0.150
    77.170    77.953     0.150
    74.919    81.562     0.150
    74.919    81.805     0.150
     7.802   109.664     0.150
     7.986   111.945     0.150
     8.527   120.133     0.150
    13.952   190.141     0.150
    30.115   367.172     0.150
    44.680   489.922     0.150
    55.757   569.703     0.150
    61.142   607.594     0.150
    73.596    23.420     0.150
    73.596    41.111     0.150
    75.531    31.580     0.150
   148.544    43.850     0.150
     3.585    51.820     0.150
    68.267    57.430     0.150
    80.614    60.660     0.150
    22.364    68.150     0.150
    78.988    67.680     0.150
     4.815    68.689     0.150
   104.253    70.430     0.150
    77.516    71.689     0.150
    74.940    77.121     0.150
    38.737    83.350     0.150
     0.744    23.590     0.150
    74.215    15.738     0.150
    74.215    25.711     0.150
    81.186    17.102     0.150
    74.909    35.770     0.150
   148.416    48.590     0.150
    68.880    59.750     0.150
    79.609    61.539     0.150
   104.008    78.648     0.150
    69.434    90.500     0.150
     7.834   108.820     0.150
    12.675   311.980     0.150
    13.991   189.355     0.150
    19.946   267.430     0.150
    30.162   366.559     0.150
    31.451   377.168     0.150
    55.718   570.410     0.150
    58.900   592.008     0.150
    61.153   606.551     0.150
    63.830   624.480     0.150
    65.882   638.352     0.150
    71.890   675.309     0.150
    83.333   739.770     0.150
    74.040    18.071     0.150
    74.040    30.001     0.150
    80.837    18.181     0.150
    98.705    21.091     0.150
    75.150    29.951     0.150
    75.150    51.441     0.150
   148.077    42.951     0.150
    68.732    54.471     0.150
    22.823    65.281     0.150
    79.421    66.941     0.150
   104.458    71.831     0.150
    76.960    73.191     0.150
    74.540    76.541     0.150
    39.121    81.261     0.150
    31.325   101.151     0.150
    83.354   113.231     0.150
    13.539   185.241     0.150
    19.547   260.511     0.150
    27.491   340.131     0.150
    30.106   364.061     0.150
    36.333   415.531     0.150
    52.640   544.081     0.150
    55.682   567.951     0.150
    58.731   588.381     0.150
    60.769   602.331     0.150
    63.604   621.231     0.150
    71.515   671.281     0.150
    72.878   680.571     0.150
    79.291   717.111     0.150
   147.915  1175.051     0.150
   150.490  1182.191     0.150
     0.717    13.786     0.150
     0.736    13.986     0.150
     0.740    14.156     0.150
     0.745    14.246     0.150
     0.751    14.446     0.150
     0.756    14.316     0.150
    80.329    30.486     0.150
    74.181    18.166     0.150
    74.181    32.376     0.150
    98.658    19.636     0.150
     1.385    41.266     0.150
     1.431    21.596     0.150
    75.095    25.536     0.150
     2.030    29.716     0.150
     2.491    36.926     0.150
     2.569    34.676     0.150
     2.685    38.436     0.150
     4.161    58.136     0.150
     4.500    60.536     0.150
     4.869    68.486     0.150
    76.507    70.526     0.150
   104.886    71.016     0.150
    79.546    71.306     0.150
     5.605    76.116     0.150
     6.624    90.176     0.150
     6.648    90.306     0.150
     6.849    94.046     0.150
     6.948    94.586     0.150
     7.140    97.196     0.150
     7.179    96.856     0.150
     7.473   101.946     0.150
     9.011   125.666     0.150
    80.434    33.461     0.150
    74.002    19.844     0.150
    75.262    24.117     0.150
    75.262    43.359     0.150
   147.679    37.906     0.150
    68.722    48.023     0.150
   104.883    69.539     0.150
    74.117    72.188     0.150
     0.096    23.891     0.150
    74.873    15.008     0.150
    74.873    25.102     0.150
    80.558    15.023     0.150
    80.558    25.844     0.150
    97.894    15.922     0.150
    97.894    27.102     0.150
    74.336    37.156     0.150
    74.336    64.703     0.150
   147.766    52.164     0.150
    80.252    61.617     0.150
    79.532    65.031     0.150
    23.657    70.031     0.150
     5.023    72.344     0.150
     5.502    80.492     0.150
    76.365    83.266     0.150
   104.258    83.523     0.150
    74.395    86.117     0.150
    69.122    93.523     0.150
    47.891    95.797     0.150
     7.205   100.211     0.150
     7.992   114.414     0.150
    80.472    19.619     0.150
    80.472    34.408     0.150
    73.958    20.219     0.150
    98.861    22.338     0.150
    75.300    42.959     0.150
    75.300    24.529     0.150
   147.718    37.988     0.150
    68.677    48.578     0.150
    79.798    53.629     0.150
    22.765    59.709     0.150
     0.909    16.508     0.150
    74.287    16.676     0.150
    81.417    18.746     0.150
    81.417    33.445     0.150
    98.337    21.266     0.150
    98.337    38.266     0.150
    43.912    29.168     0.150
    74.795    39.156     0.150
   148.641    52.355     0.150
    79.688    59.117     0.150
    68.935    63.906     0.150
    39.472    73.055     0.150
    23.044    75.477     0.150
    75.184    85.547     0.150
    47.424    98.047     0.150
    12.842   180.250     0.150
    20.168   269.547     0.150
    30.163   366.906     0.150
    44.764   490.266     0.150
    63.997   626.348     0.150
    80.284    16.609     0.150
    80.284    28.867     0.150
    74.401    17.500     0.150
    74.401    31.020     0.150
     1.165    21.680     0.150
     1.165    37.609     0.150
    74.874    29.008     0.150
   147.518    42.270     0.150
    69.123    49.949     0.150
    74.030    76.207     0.150
    13.263   186.000     0.150
    19.544   261.277     0.150
    27.123   331.500     0.150
    30.584   367.188     0.150
    31.646   376.090     0.150
    45.048   487.938     0.150
    55.148   561.957     0.150
    63.013   614.270     0.150
    97.531    21.043     0.150
    97.531    36.663     0.150
    80.388    21.533     0.150
    80.388    37.403     0.150
     0.865    39.604     0.150
     1.552    53.703     0.150
     2.479    40.713     0.150
    73.970    42.733     0.150
   147.576    56.113     0.150
    69.951    60.703     0.150
    40.307    70.523     0.150
    40.307    71.483     0.150
    24.042    72.903     0.150
     5.445    77.953     0.150
    74.285    89.264     0.150
    69.140    97.043     0.150
    48.259   101.273     0.150
    83.031   100.184     0.150
    71.179   101.153     0.150
     7.248   103.813     0.150
     7.358   102.054     0.150
     7.405   103.213     0.150
     8.540   121.343     0.150
    45.836   482.224     0.150
    74.162    17.072     0.150
    81.197    18.062     0.150
    98.509    20.742     0.150
    98.509    36.682     0.150
    74.962    35.541     0.150
    74.962    61.621     0.150
   148.429    48.223     0.150
    68.827    59.631     0.150
    22.927    70.893     0.150
    77.180    78.211     0.150
   115.188    81.662     0.150
    74.934    82.012     0.150
    69.418    89.822     0.150
    47.258    94.541     0.150
    74.932     1.504     0.150
    80.597     2.797     0.150
    80.597     3.125     0.150
    97.826     6.707     0.150
    97.826     7.105     0.150
    97.826    11.434     0.150
     1.067    35.676     0.150
     1.155    37.715     0.150
     1.431    26.195     0.150
     1.431    45.555     0.150
     1.449    26.676     0.150
     1.437    25.895     0.150
     1.448    25.695     0.150
     1.467    26.176     0.150
     1.467    26.824     0.150
     1.466    26.016     0.150
     1.466    25.816     0.150
     1.483    26.805     0.150
     1.618    28.477     0.150
     2.043    34.605     0.150
     2.273    38.027     0.150
     2.327    38.375     0.150
     2.327    38.535     0.150
    74.268    40.664     0.150
    44.329    40.586     0.150
     2.472    40.285     0.150
     2.766    44.426     0.150
     3.415    55.117     0.150
   147.801    55.055     0.150
   147.801    55.734     0.150
     3.979    62.816     0.150
    80.313    64.734     0.150
     4.369    67.504     0.150
    79.542    70.406     0.150
     4.610    71.285     0.150
     4.657    72.086     0.150
     4.827    75.094     0.150
     5.121    78.945     0.150
     5.651    86.195     0.150
    74.445    89.477     0.150
     6.038    91.355     0.150
     6.293    96.855     0.150
     6.499    97.406     0.150
     6.574    98.414     0.150
    47.958   103.504     0.150
     7.016   104.477     0.150
     7.016   104.664     0.150
     7.119   106.137     0.150
     7.487   111.207     0.150
     7.518   112.195     0.150
     7.657   113.754     0.150
     7.902   117.555     0.150
     9.361   138.277     0.150
    26.600   339.145     0.150
    27.434   345.746     0.150
    30.246   371.684     0.150
    32.169   388.176     0.150
    32.253   390.816     0.150
    34.330   407.395     0.150
    35.662   419.656     0.150
    42.260   473.766     0.150
    44.969   500.754     0.150
    45.498   500.230     0.150
    45.498   601.012     0.150
    45.498   601.016     0.150
    46.636   512.656     0.150
    47.642   517.660     0.150
    47.753   518.574     0.150
    48.474   526.055     0.150
    49.045   532.457     0.150
    50.415   540.586     0.150
    54.590   571.566     0.150
    64.451   639.156     0.150
    71.359   678.414     0.150
    73.170   694.301     0.150
    96.969   812.895     0.150
     0.384    10.918     0.150
    73.776    22.098     0.150
    73.776    37.605     0.150
    81.393    23.207     0.150
    98.872    26.148     0.150
    75.328    34.598     0.150
    75.328    59.738     0.150
   148.636    46.766     0.150
    79.172    64.219     0.150
   104.052    73.977     0.150
    77.508    75.086     0.150
   114.793    78.316     0.150
    69.427    86.625     0.150
    46.891    91.586     0.150
    74.416    42.859     0.150
    74.416    73.570     0.150
   148.559    55.539     0.150
    39.851    68.629     0.150
    23.420    77.609     0.150
   103.584    85.719     0.150
    77.071    86.109     0.150
   115.577    89.980     0.150
    75.182    89.859     0.150
    69.828    97.898     0.150
    47.803   102.250     0.150
     8.248   115.020     0.150
    44.466   483.051     0.150
    46.444   502.922     0.150
    63.808   624.781     0.150
    71.097   670.711     0.150
    72.114   675.781     0.150
     2.629   712.262     0.150
    80.147   723.141     0.150
    83.323   742.809     0.150
    74.495    16.664     0.150
    74.495    28.504     0.150
    81.412    18.385     0.150
    98.123    20.363     0.150
    98.123    35.674     0.150
    74.582    41.465     0.150
    74.582    72.135     0.150
   148.626    54.604     0.150
    39.685    69.465     0.150
   103.623    83.844     0.150
    77.194    84.555     0.150
   115.412    87.793     0.150
    75.213    88.234     0.150
    69.803    96.145     0.150
    47.637   101.074     0.150
     0.047     2.898     0.150
    74.941     1.262     0.150
    74.941     2.609     0.150
    80.598     3.172     0.150
    80.598     6.059     0.150
    97.816     6.930     0.150
    97.816    12.410     0.150
     0.914    30.570     0.150
     1.439    26.379     0.150
     1.459    26.738     0.150
     1.475    25.750     0.150
     2.016    33.789     0.150
    74.259    41.578     0.150
     2.473    40.031     0.150
     2.713    45.219     0.150
     2.776    46.199     0.150
     3.424    55.160     0.150
   147.801    54.352     0.150
    79.539    70.738     0.150
     4.760    73.730     0.150
     4.907    74.648     0.150
    23.721    75.809     0.150
    40.014    76.320     0.150
   104.179    87.012     0.150
    74.448    90.461     0.150
     6.166    93.910     0.150
     6.315    95.031     0.150
     7.336   110.000     0.150
     7.698   114.621     0.150
     7.901   117.840     0.150
    10.622   154.629     0.150
    20.270   528.531     0.150
    99.419   318.340     0.150
   116.341   318.699     0.150
    19.545   332.160     0.150
    68.176   334.422     0.150
    26.373   336.520     0.150
    30.967   377.949     0.150
    45.506   500.391     0.150
    50.295   539.141     0.150
    58.106   592.711     0.150
    64.445     4.500     0.150
    65.078   638.141     0.150
    68.315   658.246     0.150
    71.361   677.711     0.150
    77.285   712.633     0.150
    79.531   724.852     0.150
    79.531   724.852     0.150
    91.731   787.102     0.150
   150.384  1189.875     0.150
   150.384  1189.879     0.150
     0.362    10.102     0.150
     0.362    16.695     0.150
    74.229    21.094     0.150
    74.229    34.578     0.150
    81.666    23.297     0.150
    98.350    25.516     0.150
    98.350    45.062     0.150
    74.814    43.797     0.150
    74.814    75.188     0.150
   148.889    56.234     0.150
    80.689    72.766     0.150
    39.454    73.555     0.150
     5.252    76.117     0.150
    22.980    80.344     0.150
    75.431    89.508     0.150
    69.930    96.492     0.150
    47.405   101.938     0.150
     8.327   202.617     0.150
    74.530    23.674     0.150
    74.530    13.914     0.150
    81.120    15.395     0.150
    81.120    27.174     0.150
    98.142    17.424     0.150
    98.142    30.654     0.150
    74.594    38.344     0.150
   148.337    51.213     0.150
    23.294    73.504     0.150
   115.531    85.354     0.150
    74.918    85.434     0.150
    69.524    93.604     0.150
     0.089     2.848     0.150
    74.908     2.090     0.150
    74.908     4.000     0.150
    80.585     2.859     0.150
    97.854     7.250     0.150
    97.854    13.281     0.150
     1.402    44.359     0.150
     1.417    26.301     0.150
     1.422    44.988     0.150
     1.419    26.449     0.150
    74.296    40.379     0.150
    74.296    70.918     0.150
     2.735    43.449     0.150
     4.627    71.340     0.150
     4.709    72.820     0.150
     5.311    80.918     0.150
     5.623    85.770     0.150
     5.679    86.129     0.150
     6.011    90.969     0.150
   116.022    90.969     0.150
     6.543    97.480     0.150
    69.166    97.758     0.150
     7.059   105.168     0.150
     7.438   110.199     0.150
    74.759    13.406     0.150
    74.759    23.023     0.150
    81.106    14.785     0.150
    97.908    16.285     0.150
    74.360    41.004     0.150
    74.360    71.355     0.150
   148.311    54.125     0.150
    39.908    69.727     0.150
    23.521    75.543     0.150
    74.942    88.566     0.150
   115.735    88.793     0.150
    69.623    96.125     0.150
    47.860   100.484     0.150
     7.720   110.914     0.150
    13.208   180.805     0.150
    13.208   180.805     0.150
    13.208   321.781     0.150
    18.219   241.996     0.150
    18.219   242.016     0.150
    26.790   334.465     0.150
    65.533   632.465     0.150
    73.729    22.701     0.150
    73.729    39.760     0.150
    81.460    23.840     0.150
    98.908    26.740     0.150
    98.908    47.391     0.150
    75.365    34.910     0.150
    75.365    60.471     0.150
   148.704    46.920     0.150
   114.732    78.391     0.150
    75.133    79.340     0.150
    38.902    80.691     0.150
    69.472    86.701     0.150
    46.854    92.141     0.150
     0.649    24.023     0.150
     0.655    24.124     0.150
     0.733    27.243     0.150
     0.953    15.374     0.150
    74.936    19.283     0.150
    74.936    33.833     0.150
     1.198    21.563     0.150
    97.627    23.553     0.150
     2.070    35.633     0.150
    74.092    51.153     0.150
     3.526    53.863     0.150
    40.176    64.803     0.150
    69.557    75.633     0.150
     5.203    78.383     0.150
     5.686    84.433     0.150
    77.146    94.523     0.150
    70.226   107.593     0.150
     8.661   127.628     0.150
    80.373    15.994     0.150
    80.373    27.785     0.150
    98.465    18.135     0.150
    74.903    28.635     0.150
    74.903    50.434     0.150
   147.607    41.645     0.150
    69.075    50.115     0.150
    69.075    88.385     0.150
    23.163    62.455     0.150
    76.459    73.674     0.150
   104.740    74.994     0.150
    74.114    76.625     0.150
    68.674    84.664     0.150
    47.330    88.125     0.150
    69.886   407.205     0.150
    55.222   563.654     0.150
    74.948     1.438     0.150
    74.948     2.747     0.150
    80.597     2.468     0.150
    80.597     5.037     0.150
    97.809     7.117     0.150
    97.809    11.008     0.150
     0.854    16.968     0.150
     0.857    30.327     0.150
     1.448    26.127     0.150
     1.452    48.487     0.150
     1.461    23.598     0.150
     1.479    28.258     0.150
     1.481    23.276     0.150
     1.756    30.338     0.150
     2.017    61.067     0.150
     2.284    37.758     0.150
     2.284    70.407     0.150
     2.341    38.327     0.150
     2.610    76.588     0.150
     2.719    42.447     0.150
     3.307    49.478     0.150
     3.412    51.667     0.150
     3.429    52.627     0.150
    69.637    61.247     0.150
     3.992    63.338     0.150
     4.383    68.447     0.150
     4.912    74.357     0.150
    23.728    75.447     0.150
     5.135    74.308     0.150
     5.354    81.397     0.150
     5.506    78.548     0.150
     5.995    86.067     0.150
    69.198    99.107     0.150
     7.067   102.718     0.150
     7.067   104.827     0.150
     7.134   105.978     0.150
     7.519   111.218     0.150
     8.179   117.478     0.150
    10.408   146.098     0.150
    12.532   174.388     0.150
    13.218   187.933     0.150
    20.276   275.497     0.150
    34.537   409.657     0.150
    65.073   640.197     0.150
    82.117   739.308     0.150
     0.820    29.324     0.150
    80.381    19.154     0.150
    73.995    20.113     0.150
    98.841    21.934     0.150
   147.627    37.104     0.150
     2.778    43.734     0.150
    22.807    59.104     0.150
    74.061    71.133     0.150
    46.956    83.854     0.150
     7.145   100.174     0.150
    74.892     2.352     0.150
    74.892     4.074     0.150
    80.584     2.824     0.150
    80.584     5.742     0.150
    97.870     7.633     0.150
    97.870    13.883     0.150
     1.404    26.043     0.150
     1.431    25.504     0.150
     1.475    26.652     0.150
     1.779    32.695     0.150
     1.983    35.344     0.150
     2.617    45.242     0.150
     3.040    51.094     0.150
     3.142    53.172     0.150
     3.371    54.074     0.150
   147.791    54.695     0.150
     4.613    71.645     0.150
     4.696    72.402     0.150
     4.706    74.082     0.150
     4.791    74.375     0.150
    23.674    74.383     0.150
     5.059    76.422     0.150
     5.652    85.285     0.150
     5.667    85.633     0.150
   104.221    86.102     0.150
     6.981   104.215     0.150
     7.083   105.852     0.150
     7.101   106.152     0.150
    74.920     1.898     0.150
    74.920     3.568     0.150
    80.590     2.748     0.150
    97.840     7.008     0.150
     1.506    26.607     0.150
     1.929    33.057     0.150
   147.794    55.318     0.150
     4.352    67.578     0.150
     4.722    72.787     0.150
     4.935    76.338     0.150
    23.701    74.988     0.150
     5.692    86.707     0.150
    76.367    86.658     0.150
     6.172    93.277     0.150
     6.483    97.367     0.150
     6.838   102.158     0.150
     7.035   104.828     0.150
     7.446   110.877     0.150
    74.912     1.988     0.150
    74.912     3.566     0.150
    80.586     3.238     0.150
    80.586     6.066     0.150
    97.848     7.195     0.150
    97.848    12.598     0.150
     0.793    16.227     0.150
     0.895    30.316     0.150
     1.497    26.977     0.150
     3.381    52.457     0.150
   147.791    54.957     0.150
     4.516    70.125     0.150
    23.694    74.668     0.150
     6.015    90.875     0.150
     7.097   105.637     0.150
     0.056    -1.516     0.150
     0.056    -0.422     0.150
     0.028    -0.406     0.150
    80.576     0.617     0.150
    80.576     2.914     0.150
     0.392     4.945     0.150
    97.853     7.211     0.150
    97.853    13.195     0.150
     0.831    17.516     0.150
     0.907    15.617     0.150
     1.149    37.688     0.150
     1.396    25.680     0.150
     1.396    44.219     0.150
     1.396    44.344     0.150
     1.400    26.039     0.150
     1.404    24.000     0.150
     1.404    25.625     0.150
     1.404    44.961     0.150
     1.410    24.109     0.150
     1.410    25.648     0.150
     1.410    45.039     0.150
     1.415    26.141     0.150
     1.413    24.250     0.150
     1.413    25.875     0.150
     1.449    25.555     0.150
     1.490    24.477     0.150
     1.490    25.008     0.150
     1.490    26.359     0.150
     1.709    30.547     0.150
     1.909    32.570     0.150
     2.008    33.891     0.150
     2.009    33.539     0.150
     2.237    37.578     0.150
     2.291    38.305     0.150
     3.379    55.250     0.150
   147.781    54.945     0.150
    69.601    60.766     0.150
     4.333    66.828     0.150
     4.505    69.641     0.150
     4.807    75.555     0.150
    23.692    75.695     0.150
    39.979    76.281     0.150
     5.320    81.047     0.150
    76.361    87.320     0.150
   104.219    88.539     0.150
    74.420    90.375     0.150
     6.123    92.531     0.150
     6.467    97.727     0.150
    69.158    98.195     0.150
    47.932   101.789     0.150
     7.623   187.812     0.150
     7.945   118.141     0.150
    20.225   273.805     0.150
    20.225   273.805     0.150
    30.946   378.570     0.150
    45.481   500.734     0.150
    63.069   627.156     0.150
    82.095   739.438     0.150
    82.551   741.906     0.150
    82.551   741.906     0.150
   150.357  1191.984     0.150
    80.827    16.703     0.150
    98.617    19.688     0.150
   148.064    43.703     0.150
   104.418    74.055     0.150
    76.913    74.164     0.150
    39.209    80.266     0.150
    69.023    86.750     0.150
     7.251   101.984     0.150
    12.445   173.898     0.150
    83.315   737.414     0.150
    80.563     3.117     0.150
    80.563     5.562     0.150
    97.860     7.305     0.150
     1.396    26.383     0.150
     1.448    25.875     0.150
     1.480    26.734     0.150
     1.579    28.188     0.150
     1.694    30.117     0.150
     2.655    44.680     0.150
   147.769    55.805     0.150
     3.929    62.227     0.150
     4.320    66.680     0.150
     4.778    75.188     0.150
     4.849    74.406     0.150
    23.688    75.297     0.150
    74.406    87.867     0.150
     7.296   108.867     0.150
     7.412   110.594     0.150
     7.415   111.203     0.150
     7.469   111.367     0.150
     7.744   114.805     0.150
    80.746    15.133     0.150
    80.746    26.480     0.150
    98.120    16.961     0.150
     1.149    21.742     0.150
     1.149    21.812     0.150
   147.964    49.383     0.150
    76.624    80.641     0.150
    10.375   145.820     0.150
    20.051    11.699     0.150
    27.427   340.531     0.150
    27.427   340.570     0.150
    32.512   379.711     0.150
    33.839    18.129     0.150
    35.405   413.621     0.150
    35.405    17.551     0.150
    35.961   409.480     0.150
    35.961    16.801     0.150
    39.289   444.500     0.150
    39.289    18.453     0.150
    44.933   491.152     0.150
    44.933    17.969     0.150
    45.197    14.098     0.150
    45.317   487.262     0.150
    47.423   509.660     0.150
    48.058   594.258     0.150
    48.182    18.828     0.150
    50.024    18.520     0.150
    53.408   548.660     0.150
    55.569   563.051     0.150
    56.240   568.133     0.150
    56.240   568.172     0.150
    58.374   583.801     0.150
    59.164   585.473     0.150
    64.758    19.500     0.150
    64.984    20.098     0.150
    65.715    12.902     0.150
    67.781   646.953     0.150
    70.450   661.773     0.150
    70.450  1494.172     0.150
    70.450  1536.172     0.150
    71.487   668.102     0.150
    72.951   677.500     0.150
    72.971   678.492     0.150
    73.182   680.473     0.150
   152.658   680.773     0.150
    74.400    24.102     0.150
    74.737   689.129     0.150
    96.331   700.191     0.150
    77.307   706.203     0.150
    77.307    20.480     0.150
    77.429    23.410     0.150
     2.079   707.312     0.150
    79.017    23.781     0.150
    26.830   722.551     0.150
    92.940   785.492     0.150
    74.707    14.215     0.150
    74.707    25.255     0.150
    80.688    14.604     0.150
    80.688    25.864     0.150
    98.042    16.084     0.150
    74.486    36.494     0.150
    74.486    63.364     0.150
   147.903    49.944     0.150
    23.486    70.104     0.150
   104.224    81.145     0.150
    76.541    80.364     0.150
    69.171    92.534     0.150
    47.739    96.215     0.150
    71.430   105.975     0.150
    74.713    14.250     0.150
    74.713    23.840     0.150
     1.256    22.371     0.150
     1.938    53.441     0.150
    74.402    40.352     0.150
   148.341    53.820     0.150
   103.774    84.871     0.150
    76.880    84.930     0.150
    69.630    96.562     0.150
     8.058   112.012     0.150
   115.586   124.750     0.150
    14.283   195.430     0.150
    45.209   486.910     0.150
    50.853   530.473     0.150
    63.607   620.691     0.150
    73.384   682.852     0.150
     0.755    27.109     0.150
    74.683    16.023     0.150
    74.683    28.133     0.150
    81.400    18.523     0.150
     1.043    18.391     0.150
    97.930    34.625     0.150
     2.806    42.289     0.150
    74.388    43.180     0.150
    80.087    52.859     0.150
   148.604    56.000     0.150
    39.879    67.992     0.150
    23.438    78.609     0.150
   103.527    86.148     0.150
    77.098    87.039     0.150
    75.234    90.484     0.150
    69.885    98.492     0.150
    47.831   102.734     0.150
     8.306   114.289     0.150
    74.788    13.369     0.150
    74.788    23.189     0.150
    80.950    14.381     0.150
    97.907    15.721     0.150
    97.907    27.430     0.150
     1.307    23.170     0.150
    74.356    39.619     0.150
    74.356    69.330     0.150
   148.156    54.100     0.150
    79.888    68.330     0.150
    39.913    70.990     0.150
    23.555    74.070     0.150
   103.916    84.711     0.150
    76.704    83.990     0.150
    74.786    88.051     0.150
    13.179   181.180     0.150
    18.219   255.174     0.150
    73.864    21.714     0.150
    73.864    38.244     0.150
    81.566    23.094     0.150
     1.603    46.884     0.150
     1.607    26.974     0.150
    98.748    25.894     0.150
     1.763    29.014     0.150
     1.763    51.304     0.150
    75.209    37.084     0.150
    75.209    66.564     0.150
     2.626    71.864     0.150
     2.635    71.604     0.150
   148.804    49.654     0.150
    22.620    73.864     0.150
    75.265    82.134     0.150
    74.901     2.227     0.150
    74.901     4.062     0.150
    80.582     3.078     0.150
    80.582     5.953     0.150
     0.129     3.852     0.150
    97.861     7.453     0.150
    97.861    12.922     0.150
     0.962    32.086     0.150
     1.483    25.898     0.150
    74.303    40.234     0.150
     2.664    43.914     0.150
     2.727    45.281     0.150
     2.727    45.602     0.150
     3.377    54.016     0.150
   147.788    54.797     0.150
     4.330    67.086     0.150
    73.460    25.898     0.150
    73.460    45.428     0.150
     1.604    26.748     0.150
    81.490    27.158     0.150
    99.181    30.139     0.150
    75.639    33.248     0.150
    75.639    57.598     0.150
   148.739    44.668     0.150
    80.826    61.918     0.150
     4.482    64.229     0.150
    22.222    69.139     0.150
    75.118    76.828     0.150
    69.369    83.848     0.150
    46.580    88.908     0.150
    30.739    98.318     0.150
     0.956    18.664     0.150
     0.985    30.805     0.150
    74.304    20.391     0.150
    74.304    33.625     0.150
    81.629    37.484     0.150
     1.152    23.562     0.150
     1.152    38.812     0.150
     1.209    40.531     0.150
     1.433    42.094     0.150
     1.363    44.234     0.150
     1.437    27.703     0.150
     1.676    47.523     0.150
     1.807    32.859     0.150
     2.184    57.961     0.150
     2.133    57.953     0.150
     2.136    57.930     0.150
     2.168    39.086     0.150
     2.642    42.531     0.150
     2.537    44.812     0.150
    74.742    43.383     0.150
     2.999    50.930     0.150
   148.849    56.250     0.150
     4.190    64.539     0.150
     3.954    63.562     0.150
     4.627    72.820     0.150
    23.056    79.570     0.150
     5.929    87.961     0.150
     5.662    87.773     0.150
    75.406    89.695     0.150
     6.502    98.344     0.150
    69.930    97.352     0.150
    47.477   102.281     0.150
    31.583   112.820     0.150
     8.329   114.711     0.150
    20.609   273.211     0.150
    44.749   593.609     0.150
    53.495   554.859     0.150
    55.868   573.922     0.150
    59.183   597.242     0.150
    61.622   613.500     0.150
    66.240   644.281     0.150
    72.171   679.766     0.150
    72.462   683.320     0.150
    72.763   685.359     0.150
    73.487   689.859     0.150
    73.781   689.766     0.150
    73.781   689.766     0.150
    80.233   727.938     0.150
    81.948   736.820     0.150
    83.138   742.711     0.150
    74.739    13.481     0.150
    74.739    23.461     0.150
    80.874    14.181     0.150
    97.973    15.681     0.150
    97.973    27.651     0.150
    74.420    38.301     0.150
   148.083    51.651     0.150
    23.510    72.591     0.150
    74.698    85.911     0.150
    47.802    98.131     0.150
    82.389   729.734     0.150
    74.456    13.891     0.150
    74.456    23.695     0.150
    81.221    15.508     0.150
    98.200    17.961     0.150
    98.200    31.977     0.150
     1.771    52.055     0.150
    74.654    38.547     0.150
    74.654    66.633     0.150
    23.217    74.367     0.150
    73.268    28.445     0.150
    73.268    49.750     0.150
    81.535    29.477     0.150
    75.830    32.844     0.150
    75.830    57.289     0.150
    99.372    32.336     0.150
   148.788    43.805     0.150
    22.030    68.750     0.150
    69.321    82.234     0.150
    46.389    87.273     0.150
    30.546    96.078     0.150
    76.039    20.117     0.150
    76.039    34.688     0.150
     1.556    26.008     0.150
     1.700    49.148     0.150
     1.775    50.633     0.150
     1.819    28.500     0.150
    80.653    29.070     0.150
    73.214    29.969     0.150
    99.599    31.391     0.150
    99.599    59.258     0.150
   147.907    32.023     0.150
    22.024    56.523     0.150
     4.203    62.062     0.150
    68.391    72.367     0.150
    80.301    18.180     0.150
    80.301    31.727     0.150
    97.827    18.398     0.150
    97.827    32.102     0.150
    74.986    18.477     0.150
    74.986    32.547     0.150
   147.507    51.586     0.150
    23.782    68.430     0.150
    40.015    74.945     0.150
    74.148    84.578     0.150
    68.916    93.602     0.150
    47.967    96.625     0.150
    32.275   111.938     0.150
   115.755   116.016     0.150
    10.517   148.961     0.150
    19.344   254.680     0.150
    62.813   609.859     0.150
    64.845   622.969     0.150
    80.230    17.247     0.150
    80.230    29.438     0.150
    74.293    18.447     0.150
    98.561    19.467     0.150
    98.561    33.827     0.150
   147.468    39.728     0.150
    23.108    60.057     0.150
    73.955    73.967     0.150
     1.389    41.227     0.150
    73.540    23.375     0.150
    73.540    42.797     0.150
     1.880    30.367     0.150
   148.063    36.766     0.150
    22.333    61.055     0.150
    30.828    94.984     0.150
     7.114   177.457     0.150
    11.828   291.508     0.150
    20.569   273.375     0.150
    53.853   554.855     0.150
     0.734    15.262     0.150
    73.586    39.842     0.150
     2.657    72.361     0.150
     3.769    99.941     0.150
   150.190    68.711     0.150
    39.026    75.641     0.150
     5.505    80.752     0.150
     5.686    84.551     0.150
     5.960    87.752     0.150
    22.343    93.002     0.150
    76.656    98.791     0.150
    46.967   109.400     0.150
    30.885   115.811     0.150
    46.824  3524.895     0.150
    46.830  3527.869     0.150
    46.842  3526.566     0.150
    47.976  3611.312     0.150
    47.989  3618.121     0.150
    47.994  3618.055     0.150
    73.842    20.625     0.150
    73.842    36.461     0.150
    81.344    21.875     0.150
    81.344    39.133     0.150
    98.813    24.812     0.150
     1.641    48.461     0.150
     2.214    32.016     0.150
     2.487    36.883     0.150
     2.498    40.031     0.150
     2.842    72.625     0.150
   148.586    46.156     0.150
     4.402    64.844     0.150
    22.605    71.156     0.150
    77.440    75.211     0.150
    75.032    79.352     0.150
    46.951    92.852     0.150
     6.877    96.055     0.150
    31.121   101.859     0.150
    10.028   139.164     0.150
    73.492    31.223     0.150
    82.185    32.961     0.150
     2.578    41.781     0.150
   149.429    55.502     0.150
     4.180    61.291     0.150
    38.783    79.682     0.150
    22.240    80.301     0.150
    78.247    81.422     0.150
    75.843    86.291     0.150
    30.773   106.512     0.150
     8.509   121.711     0.150
   114.460   134.031     0.150
    12.358   176.688     0.150
    12.358   310.836     0.150
    14.492   360.312     0.150
    15.092   213.982     0.150
    19.935   271.162     0.150
    21.456   284.732     0.150
    28.098   347.932     0.150
    45.107   493.662     0.150
    45.824   498.162     0.150
    56.744   581.143     0.150
    62.083   617.592     0.150
    64.361   632.732     0.150
    65.549   642.062     0.150
    72.841   685.711     0.150
    74.126   693.912     0.150
    84.249   748.062     0.150
   146.599  1179.082     0.150
    83.672   746.562     0.150
    74.038    21.180     0.150
    74.038    36.609     0.150
    81.670    23.273     0.150
    81.670    40.867     0.150
    98.547    25.828     0.150
    98.547    45.188     0.150
     2.435    35.688     0.150
   148.901    52.406     0.150
    22.791    76.852     0.150
    77.601    80.867     0.150
    75.403    85.602     0.150
    31.316   107.156     0.150
   114.960   130.023     0.150
     1.355    39.879     0.150
    81.677    23.230     0.150
    81.677    42.500     0.150
    98.614    46.688     0.150
    75.078    40.098     0.150
   148.911    52.230     0.150
    80.793    69.000     0.150
    39.190    74.918     0.150
    22.725    75.711     0.150
    77.636    80.461     0.150
    75.399    85.230     0.150
   114.893   129.430     0.150
    12.625   303.359     0.150
    27.594   339.129     0.150
    80.163    19.541     0.150
    80.163    33.900     0.150
    97.930    19.881     0.150
    97.930    34.359     0.150
    74.366    36.311     0.150
   147.376    49.631     0.150
    79.189    62.391     0.150
    23.719    66.359     0.150
    39.918    77.170     0.150
    76.044    80.100     0.150
    73.993    82.109     0.150
    47.870    93.801     0.150
    47.870    95.121     0.150
    32.206   110.020     0.150
    12.084   168.000     0.150
    80.631    15.117     0.150
    80.631    26.664     0.150
    98.392    17.539     0.150
    98.392    30.195     0.150
     0.966    18.508     0.150
    74.834    31.664     0.150
   147.862    44.477     0.150
    23.168    65.711     0.150
   104.468    76.555     0.150
    76.647    75.969     0.150
    74.386    78.859     0.150
    47.392    91.609     0.150
    31.666   104.914     0.150
    19.744   263.266     0.150
    55.329   565.336     0.150
    79.265   715.844     0.150
     1.371    23.984     0.150
    73.919    30.375     0.150
    73.919    54.391     0.150
   149.588    61.641     0.150
    39.258    72.250     0.150
   103.005    86.398     0.150
    22.668    85.844     0.150
    78.187    87.938     0.150
     6.166    88.047     0.150
    76.097    92.898     0.150
    47.205   105.578     0.150
   114.919   139.836     0.150
    21.318   283.805     0.150
    22.549   297.359     0.150
   106.254   312.328     0.150
    54.194   562.789     0.150
    80.226    18.352     0.150
    80.226    31.622     0.150
    97.868    18.532     0.150
    97.868    32.202     0.150
    74.961    18.842     0.150
    74.961    33.002     0.150
     1.598    28.702     0.150
    74.305    36.942     0.150
   147.434    50.962     0.150
    79.223    63.182     0.150
    23.762    67.412     0.150
    76.069    81.242     0.150
    74.065    83.952     0.150
    47.930    95.802     0.150
     6.688    94.252     0.150
   115.719   115.162     0.150
    10.960   154.312     0.150
     0.107     3.704     0.150
     0.158     4.494     0.150
     0.133     5.434     0.150
     0.223     6.374     0.150
     0.339     6.324     0.150
    80.276     7.233     0.150
    80.276    12.344     0.150
    74.761     9.463     0.150
    74.761    16.724     0.150
    98.066    10.793     0.150
     1.014    18.213     0.150
     1.021    18.184     0.150
     1.265    22.744     0.150
     1.322    23.713     0.150
     1.419    25.067     0.150
     1.419    24.003     0.150
     1.621    27.644     0.150
     1.618    27.983     0.150
     1.618    51.144     0.150
     1.812    33.023     0.150
     1.932    32.414     0.150
    74.503    34.704     0.150
    74.503    62.574     0.150
     2.069    36.114     0.150
     2.317    37.724     0.150
     2.606    44.193     0.150
   147.494    50.713     0.150
     3.262    51.114     0.150
    79.339    64.704     0.150
     4.206    64.824     0.150
     4.420    69.704     0.150
     4.508    69.813     0.150
    76.200    81.543     0.150
     5.430    80.284     0.150
     5.606    82.474     0.150
    74.083    85.494     0.150
     5.914    89.233     0.150
    68.777    92.784     0.150
    47.731    96.804     0.150
     6.735   100.934     0.150
     7.235   107.043     0.150
    32.053   110.554     0.150
   115.520   120.083     0.150
    19.467   267.494     0.150
    34.202   406.414     0.150
    60.291   606.923     0.150
    62.874   626.124     0.150
    64.949   640.644     0.150
    74.479    22.516     0.150
     1.437    25.314     0.150
    98.037    50.166     0.150
     2.759    45.945     0.150
     2.849    48.775     0.150
   149.154    63.156     0.150
    39.763    69.725     0.150
    80.833    79.785     0.150
    23.227    86.486     0.150
    75.766    96.006     0.150
    47.712   109.416     0.150
    31.761   118.766     0.150
     8.745   127.826     0.150
     8.898   129.805     0.150
   115.446   139.666     0.150
    10.008   144.266     0.150
   116.126   313.035     0.150
    44.093   324.826     0.150
    20.705   327.156     0.150
    67.642   329.135     0.150
    30.189   375.025     0.150
    38.290   397.475     0.150
    33.500   394.926     0.150
    33.850   406.225     0.150
    38.521   437.826     0.150
    38.799   449.025     0.150
    39.026   449.885     0.150
    39.026   450.525     0.150
    40.429   456.426     0.150
    44.864   498.926     0.150
    47.002   512.426     0.150
    48.295   523.725     0.150
    59.335   600.395     0.150
    72.705   686.326     0.150
    73.902   694.826     0.150
    74.129   695.225     0.150
    74.151   699.625     0.150
    75.197    -0.305     0.150
    75.893    -0.451     0.150
    78.082   716.436     0.150
    94.513   744.105     0.150
    83.309   745.426     0.150
   160.298  1239.838     0.150
    45.047   494.016     0.150
    74.502    21.758     0.150
    74.502    38.008     0.150
     1.428    46.887     0.150
     1.428    23.367     0.150
    98.021    45.980     0.150
   149.114    60.598     0.150
    39.779    66.328     0.150
    69.112    72.547     0.150
    80.791    76.730     0.150
    77.573    89.098     0.150
    75.729    93.949     0.150
   115.465   134.480     0.150
    20.701   278.781     0.150
     0.987    18.850     0.150
    80.322    33.040     0.150
    74.104    35.390     0.150
    75.176    25.200     0.150
    75.176    43.700     0.150
   147.564    38.240     0.150
    76.537    69.950     0.150
     6.797    95.730     0.150
    19.277   258.380     0.150
    19.912   264.860     0.150
    45.006   489.330     0.150
    48.625   515.811     0.150
    55.391   566.290     0.150
    58.323   584.410     0.150
    60.246   597.771     0.150
    72.064   673.630     0.150
    44.317   479.190     0.150
    80.347    17.539     0.150
    80.347    30.391     0.150
    74.947    17.832     0.150
    74.947    30.461     0.150
    97.858    17.781     0.150
    74.297    37.312     0.150
    74.297    64.711     0.150
   147.554    50.250     0.150
    69.653    56.449     0.150
    79.328    63.840     0.150
    23.741    68.680     0.150
    39.982    75.391     0.150
    76.168    81.910     0.150
   104.427    82.879     0.150
    74.188    84.590     0.150
    47.934    96.152     0.150
     8.079   111.922     0.150
   115.722   115.832     0.150
     1.089    36.406     0.150
    74.509    23.242     0.150
    74.509    23.484     0.150
    74.509    42.492     0.150
     1.282    23.594     0.150
     1.320    24.992     0.150
     1.325    24.422     0.150
     1.401    25.727     0.150
    81.878    27.062     0.150
    98.019    28.602     0.150
    98.019    51.195     0.150
   149.083    64.125     0.150
     4.765    74.672     0.150
    69.121    75.641     0.150
    80.763    80.914     0.150
     0.014    23.177     0.150
    74.909    14.547     0.150
    74.909    24.957     0.150
    80.710    14.816     0.150
    80.710    25.657     0.150
    97.828    15.417     0.150
    97.828    26.816     0.150
   147.913    53.367     0.150
    69.591    59.877     0.150
    79.644    66.986     0.150
    23.684    71.757     0.150
     0.371     7.754     0.150
     0.734    12.895     0.150
     0.924    16.992     0.150
     1.642    48.355     0.150
     1.755    54.605     0.150
     1.786    54.863     0.150
    73.551    29.266     0.150
     1.829    56.492     0.150
     1.950    59.555     0.150
    98.970    33.676     0.150
     2.162    65.824     0.150
     2.462    76.766     0.150
     2.819    42.055     0.150
   149.344    54.535     0.150
    68.168    68.953     0.150
    81.300    71.523     0.150
   103.474    78.254     0.150
    22.299    78.844     0.150
     5.587    79.164     0.150
    78.155    80.324     0.150
    75.766    85.645     0.150
     6.578    92.164     0.150
    46.778    98.266     0.150
     8.448   122.215     0.150
   114.511   131.785     0.150
    53.875   559.773     0.150
    63.660   630.312     0.150
    66.883   648.840     0.150
    73.761   692.914     0.150
    97.528   718.285     0.150
    81.697   736.414     0.150
    83.590   746.164     0.150
    83.872   747.414     0.150
    84.174   748.215     0.150
    73.553    30.434     0.150
    98.961    34.543     0.150
    98.961    61.203     0.150
     2.811    78.645     0.150
   149.378    55.354     0.150
    68.168    69.863     0.150
    81.328    72.383     0.150
    22.302    80.543     0.150
    78.181    80.975     0.150
    78.181    81.383     0.150
    75.802    86.793     0.150
    70.074    93.363     0.150
    46.787    99.094     0.150
     8.484   205.914     0.150
   114.517   132.984     0.150
    73.557    30.535     0.150
    73.557    57.545     0.150
    82.135    32.035     0.150
    82.135    59.445     0.150
    98.958    34.586     0.150
    98.958    61.205     0.150
     2.804    77.775     0.150
   149.378    55.564     0.150
    68.171    69.465     0.150
     4.920    70.314     0.150
    81.326    73.355     0.150
     4.980    71.035     0.150
     5.299    78.035     0.150
   103.437    78.125     0.150
    22.305    79.516     0.150
    78.179    80.746     0.150
     5.910    84.555     0.150
    75.802    86.215     0.150
     0.129    11.316     0.150
     1.244    36.828     0.150
    73.556    24.020     0.150
    73.556    42.039     0.150
    81.113    24.199     0.150
    81.113    43.660     0.150
     1.503    44.848     0.150
   148.363    40.848     0.150
    22.332    64.590     0.150
   104.458    68.238     0.150
    77.395    69.688     0.150
     4.775    70.480     0.150
    74.745    74.000     0.150
    69.032    81.688     0.150
    13.486   191.500     0.150
     0.476    19.064     0.150
     1.859    29.665     0.150
     1.859    29.754     0.150
     1.859    64.004     0.150
     1.859    29.795     0.150
     2.734    40.635     0.150
     2.921    43.935     0.150
     3.742    54.225     0.150
     4.466    63.635     0.150
    39.402    67.625     0.150
     4.803    67.935     0.150
     4.865    68.345     0.150
   150.037    68.145     0.150
     5.867    83.234     0.150
     5.622    80.694     0.150
    68.536    81.805     0.150
     6.042    84.895     0.150
    81.743    83.814     0.150
     6.109    86.285     0.150
   102.518    91.765     0.150
     6.392    91.145     0.150
    22.731    93.234     0.150
    78.516    94.045     0.150
     6.631    94.555     0.150
    85.380    99.245     0.150
    73.537   100.185     0.150
     7.145    99.935     0.150
     7.165    99.865     0.150
    76.580    98.615     0.150
     7.183   100.365     0.150
     7.202   100.865     0.150
     7.028    99.675     0.150
     7.544   104.685     0.150
     7.361   104.484     0.150
    70.978   104.765     0.150
     7.629   106.215     0.150
     7.672   106.365     0.150
     7.691   106.234     0.150
     7.767   107.875     0.150
     7.527   106.505     0.150
     7.571   108.274     0.150
    47.345   110.104     0.150
     7.842   110.915     0.150
     7.881   111.585     0.150
     7.895   111.685     0.150
     7.894   110.805     0.150
     8.291   116.665     0.150
    31.273   116.904     0.150
     9.307   130.935     0.150
     9.438   132.654     0.150
     9.742   134.404     0.150
    11.009   155.588     0.150
    12.455   171.415     0.150
    12.781   948.606     0.150
    12.781   948.606     0.150
    16.436   224.365     0.150
    20.831   279.835     0.150
   100.656   284.745     0.150
    21.582   286.935     0.150
    41.069   343.870     0.150
    28.990   358.415     0.150
    28.990   365.435     0.150
   107.010   387.665     0.150
     8.291   400.875     0.150
    34.402   403.830     0.150
    34.409   413.635     0.150
    37.545   429.783     0.150
    37.545   429.885     0.150
    38.459   441.515     0.150
    39.090   443.335     0.150
    40.956   459.435     0.150
    40.945   467.391     0.150
    42.024   468.535     0.150
    44.686   492.194     0.150
    44.713   499.335     0.150
    44.713   499.335     0.150
    44.713   499.335     0.150
    44.713   499.335     0.150
    44.713   499.335     0.150
    44.713   491.104     0.150
    44.967   494.016     0.150
    46.243   503.635     0.150
    46.563  3504.225     0.150
    46.568  3505.738     0.150
    46.581  3506.566     0.150
    46.655   504.154     0.150
    46.716   514.035     0.150
    47.190   510.109     0.150
    47.190   510.035     0.150
    47.324   518.734     0.150
    47.718  3588.873     0.150
    47.731  3596.346     0.150
    47.735  3587.781     0.150
    47.969   519.234     0.150
    48.584   520.274     0.150
    48.584   520.234     0.150
    49.240  3699.404     0.150
    54.940   566.305     0.150
    54.940   566.679     0.150
    56.386   578.435     0.150
    56.386   578.435     0.150
    56.386   578.435     0.150
    56.386   578.435     0.150
    56.386   578.765     0.150
    56.386   578.795     0.150
    56.386   578.635     0.150
    59.930   611.459     0.150
    60.230   605.609     0.150
    63.864   630.835     0.150
    64.975   637.115     0.150
    66.423   646.975     0.150
    67.166   651.035     0.150
    67.166   650.910     0.150
    67.166   650.835     0.150
    67.083   650.835     0.150
    67.262   651.234     0.150
    67.262   651.234     0.150
    67.262   651.234     0.150
    67.262   651.234     0.150
    67.262   651.555     0.150
    80.317   655.125     0.150
    67.886   660.835     0.150
    69.359   664.575     0.150
    82.551   682.345     0.150
    73.153   688.635     0.150
    73.537   689.345     0.150
    73.544   689.425     0.150
    73.619   690.234     0.150
    73.854   692.935     0.150
    73.854   692.935     0.150
    73.854   692.935     0.150
    73.854   692.935     0.150
    73.854   692.535     0.150
    73.854   692.535     0.150
    73.981   702.335     0.150
    74.261   694.935     0.150
    74.261   694.935     0.150
    74.261   694.935     0.150
    74.261   694.935     0.150
    74.261   694.694     0.150
    74.261   694.771     0.150
    74.374   695.935     0.150
    74.606   697.335     0.150
    74.606   697.335     0.150
    74.606   697.335     0.150
    74.606   697.335     0.150
    74.612   696.935     0.150
    74.612   696.935     0.150
    74.612   696.935     0.150
    74.612   696.935     0.150
    74.672   697.435     0.150
    74.672   697.435     0.150
    74.672   697.435     0.150
    74.672   697.435     0.150
    74.672   697.372     0.150
    74.863   698.120     0.150
    74.905   698.535     0.150
    74.905   698.535     0.150
    74.905   698.535     0.150
    74.905   698.535     0.150
    74.905   698.442     0.150
    75.183   701.435     0.150
    75.183   701.435     0.150
    75.183   701.435     0.150
    75.183   701.435     0.150
   114.776   706.035     0.150
    75.689   704.035     0.150
    75.689   704.035     0.150
    75.689   704.035     0.150
   152.900   702.435     0.150
    75.902   705.035     0.150
    75.902   705.035     0.150
    75.902   705.035     0.150
    75.999   705.234     0.150
    75.999   705.241     0.150
    76.103   705.635     0.150
    76.103   705.635     0.150
    76.103   705.635     0.150
    76.103   705.585     0.150
    76.230   706.835     0.150
    76.230   706.835     0.150
    76.230   706.835     0.150
    76.230   706.858     0.150
    76.230   706.935     0.150
    76.649   709.035     0.150
    76.649   709.035     0.150
    76.649   708.860     0.150
    76.832   710.835     0.150
    76.832   710.835     0.150
    76.860   710.335     0.150
    77.149   712.835     0.150
    77.180   712.335     0.150
    77.180   712.335     0.150
    77.313   712.435     0.150
    77.313   712.475     0.150
    77.313   712.443     0.150
    77.446   713.734     0.150
    77.498   713.435     0.150
    77.511   716.535     0.150
    77.511   716.535     0.150
    77.542   713.635     0.150
    77.872   715.234     0.150
    49.852   717.135     0.150
    77.970   716.135     0.150
    78.018   718.535     0.150
    78.018   718.535     0.150
    78.388   724.354     0.150
    78.591   719.135     0.150
    78.601   718.524     0.150
    97.217   720.555     0.150
    97.217   720.595     0.150
    78.845   720.635     0.150
    78.982   724.465     0.150
    78.901   721.305     0.150
    78.982   718.234     0.150
    79.329   724.035     0.150
    79.527   724.935     0.150
    27.542   728.491     0.150
    27.542   725.835     0.150
    81.187   734.185     0.150
    81.654   735.345     0.150
    81.761   740.734     0.150
    81.761   744.734     0.150
    81.983   738.955     0.150
    81.983   737.835     0.150
    82.154   736.285     0.150
    82.399   739.555     0.150
    86.891   741.629     0.150
    94.781   746.001     0.150
    83.998   747.685     0.150
    84.229   750.055     0.150
    84.327   749.835     0.150
    84.600   752.488     0.150
    86.121   765.335     0.150
    97.806   815.276     0.150
   101.071   830.859     0.150
   109.480  8226.365     0.150
   109.491  8218.133     0.150
   158.586  1199.524     0.150
   158.586  1913.823     0.150
    34.082   723.135     0.150
    34.082   737.635     0.150
    34.082   726.435     0.150
    27.104   721.635     0.150
    30.763   729.335     0.150
    34.082   728.535     0.150
    34.082   730.535     0.150
     0.454    19.846     0.150
     1.867    29.579     0.150
     1.867    29.529     0.150
     1.867    67.630     0.150
     1.867    29.556     0.150
     2.361    35.525     0.150
     2.432    36.306     0.150
     2.684    39.905     0.150
     2.802    41.525     0.150
     2.965    44.105     0.150
     3.696    53.445     0.150
     4.563    66.376     0.150
     5.634    80.746     0.150
    68.587    81.565     0.150
     5.822    83.086     0.150
    81.708    84.176     0.150
     6.128    86.445     0.150
   102.509    92.676     0.150
    22.781    93.046     0.150
    78.478    93.826     0.150
     6.655    94.235     0.150
     6.715    96.636     0.150
     6.859    97.626     0.150
    73.522    99.126     0.150
    76.568    98.655     0.150
     7.585   105.796     0.150
     7.647   106.366     0.150
     7.801   109.126     0.150
    47.393   110.586     0.150
     7.868   111.136     0.150
     7.906   111.576     0.150
     7.925   111.416     0.150
    31.323   118.336     0.150
     9.355   134.536     0.150
     9.380   135.836     0.150
    10.142   144.496     0.150
   115.076   146.746     0.150
    10.674   153.136     0.150
    10.808   154.556     0.150
    28.078   359.096     0.150
    29.588   371.436     0.150
    33.511   405.936     0.150
    38.509   439.186     0.150
    41.454   475.376     0.150
    46.531  3504.905     0.150
    46.536  3510.413     0.150
    46.549  3512.464     0.150
    47.686  3583.747     0.150
    47.699  3585.003     0.150
    47.704  3585.854     0.150
    48.017   523.466     0.150
    48.017   524.436     0.150
    48.139   526.235     0.150
    60.191   605.536     0.150
    65.777   651.536     0.150
    67.125   651.136     0.150
    71.315   684.076     0.150
    73.146   688.336     0.150
    73.529   689.286     0.150
    97.166   720.506     0.150
    97.166   719.466     0.150
    79.305   723.256     0.150
   102.451   838.466     0.150
   160.253  1238.303     0.150
    34.069   762.426     0.150
    34.069   650.126     0.150
     1.817    29.238     0.150
     2.387    35.469     0.150
     2.459    36.430     0.150
     2.469    36.590     0.150
     2.715    40.117     0.150
     2.841    41.348     0.150
     2.907    42.930     0.150
     2.944    42.391     0.150
     3.005    43.688     0.150
     3.061    44.867     0.150
     3.109    45.309     0.150
     3.107    45.430     0.150
     3.324    48.980     0.150
     3.741    55.609     0.150
     4.426    62.520     0.150
     4.463    62.730     0.150
     4.561    63.910     0.150
    39.409    66.957     0.150
     4.802    66.770     0.150
     4.866    67.809     0.150
    68.555    81.379     0.150
     6.040    83.117     0.150
    81.695    83.598     0.150
     6.075    85.617     0.150
   102.559    92.379     0.150
    22.746    92.020     0.150
     6.601    93.750     0.150
     6.664    95.367     0.150
     7.069    98.230     0.150
    85.330    98.207     0.150
    73.487    98.641     0.150
     7.167    99.480     0.150
     7.049   100.328     0.150
     7.118   100.840     0.150
     7.327   103.699     0.150
     7.546   103.820     0.150
     7.631   105.570     0.150
     7.674   105.699     0.150
     7.693   106.340     0.150
     7.687   108.508     0.150
     7.698   108.980     0.150
     7.747   109.668     0.150
    31.287   118.719     0.150
     8.572   116.820     0.150
     8.648   119.168     0.150
     8.540   119.688     0.150
     9.312   133.039     0.150
     9.333   723.219     0.150
    20.810   743.445     0.150
    21.836   290.438     0.150
    46.584  3487.113     0.150
    46.590  3499.137     0.150
    46.602  3499.812     0.150
    47.142   509.270     0.150
    47.739  3589.082     0.150
    47.753  3584.996     0.150
    47.757  3588.738     0.150
   112.487   522.098     0.150
    54.624   565.070     0.150
    56.349   577.957     0.150
    66.379   646.527     0.150
    67.122   650.117     0.150
    67.218   650.770     0.150
    73.402   691.969     0.150
    73.568   690.859     0.150
    73.806   699.969     0.150
    73.806   691.969     0.150
    74.184   694.238     0.150
    74.212   694.164     0.150
    74.326   695.270     0.150
    74.623   694.770     0.150
    74.815   697.504     0.150
   152.896   702.367     0.150
    75.853   705.168     0.150
    75.853   702.867     0.150
    76.181   706.312     0.150
    76.181   706.238     0.150
    77.397   712.340     0.150
    78.559   717.090     0.150
    97.195   720.000     0.150
    79.032   721.148     0.150
    27.523   727.277     0.150
    83.970   747.000     0.150
   109.513  8223.547     0.150
   109.524  8226.324     0.150
     4.540    64.000     0.150
    34.033   524.129     0.150
    45.803   498.598     0.150
    73.871    20.264     0.150
    73.871    35.424     0.150
    81.192    21.364     0.150
     1.575    44.534     0.150
   148.435    45.124     0.150
    68.543    57.544     0.150
    22.640    68.634     0.150
    74.880    78.254     0.150
    46.956    90.804     0.150
   114.727   121.004     0.150
    66.072   638.354     0.150
    80.669    21.941     0.150
    73.688    22.781     0.150
    73.688    38.301     0.150
   147.919    36.609     0.150
     3.227    49.859     0.150
    68.399    49.242     0.150
    22.487    60.180     0.150
   104.828    67.910     0.150
    76.994    67.680     0.150
    74.307    71.043     0.150
    46.683    83.480     0.150
   114.468   112.602     0.150
    74.269    14.664     0.150
    74.269    25.445     0.150
    80.950    15.461     0.150
    80.950    27.812     0.150
     0.787    15.555     0.150
    98.446    18.406     0.150
    98.446    32.492     0.150
    43.746    35.445     0.150
   148.180    45.727     0.150
    23.043    68.758     0.150
    76.942    77.555     0.150
    63.519   656.352     0.150
     0.668    13.148     0.150
    80.571    23.352     0.150
    80.571    41.320     0.150
    73.627    23.773     0.150
    73.627    41.367     0.150
    99.186    26.250     0.150
   147.823    35.219     0.150
    42.958    45.344     0.150
    22.434    58.359     0.150
    76.948    65.453     0.150
    74.195    68.992     0.150
    30.920    93.281     0.150
    18.973   257.508     0.150
    20.370   270.461     0.150
    26.571   328.508     0.150
    30.870   369.531     0.150
    32.799   386.805     0.150
    35.991   414.141     0.150
    43.287   471.609     0.150
    44.273   482.352     0.150
    47.831   508.609     0.150
    61.544   608.812     0.150
    65.443    23.398     0.150
    71.939   673.414     0.150
    77.373   707.758     0.150
    83.691   740.914     0.150
     0.663    12.371     0.150
     0.663    21.133     0.150
     1.560    46.633     0.150
     1.566    47.793     0.150
     1.566    47.754     0.150
     1.590    48.031     0.150
    72.996    31.754     0.150
   148.204    33.793     0.150
    74.480    65.320     0.150
    18.615   254.316     0.150
    18.615   254.434     0.150
    25.887   333.262     0.150
    27.173   344.531     0.150
    32.639   386.043     0.150
    32.639   388.754     0.150
    33.453   394.102     0.150
    37.996   431.781     0.150
    47.112   513.273     0.150
    47.502   509.332     0.150
    48.226   514.203     0.150
    56.223   573.844     0.150
    59.341   597.094     0.150
    60.403   614.141     0.150
    60.746   607.211     0.150
    63.440   626.934     0.150
    66.378   643.641     0.150
    67.135   646.344     0.150
    70.167   671.551     0.150
    71.165   685.141     0.150
    71.209   683.242     0.150
    71.242   685.344     0.150
    71.422   686.641     0.150
    71.729   687.641     0.150
    72.400   679.441     0.150
    72.400   692.441     0.150
    74.188   695.953     0.150
    75.399   697.844     0.150
    75.399    12.199     0.150
    82.248   740.164     0.150
    82.410   738.141     0.150
    96.359   746.602     0.150
    84.353   747.844     0.150
    89.016   780.637     0.150
    45.914   495.762     0.150
     0.473    10.883     0.150
     0.473    10.906     0.150
    80.849    19.742     0.150
     1.243    38.977     0.150
     1.711    49.914     0.150
   148.094    40.938     0.150
   148.094    70.727     0.150
    68.550    52.734     0.150
    22.640    63.773     0.150
   104.552    70.602     0.150
    77.055    70.664     0.150
    74.521    74.453     0.150
    46.884    86.828     0.150
     7.223   101.844     0.150
    83.345   115.633     0.150
    71.509   116.219     0.150
   114.665   115.953     0.150
    19.376   261.742     0.150
    47.596   264.992     0.150
   102.708   282.328     0.150
    70.867   300.617     0.150
    20.376   316.438     0.150
   102.885   321.719     0.150
    29.940   365.742     0.150
    31.093   375.094     0.150
    98.895   375.852     0.150
    32.956   387.438     0.150
    36.562   419.117     0.150
    38.542   439.383     0.150
    42.764   472.328     0.150
    43.139   473.789     0.150
    44.559   492.945     0.150
    47.969   514.648     0.150
    48.831   518.625     0.150
    52.627   546.594     0.150
    56.032   575.898     0.150
    61.775   612.547     0.150
    63.528   622.672     0.150
    65.840   638.117     0.150
    66.833   644.945     0.150
    68.171   653.055     0.150
    69.878   664.172     0.150
    80.562   665.914     0.150
    71.065   672.445     0.150
    72.033   677.164     0.150
    72.287   677.688     0.150
    72.590   681.531     0.150
    72.807   682.539     0.150
    72.837   682.773     0.150
    74.712   694.727     0.150
    75.210   696.188     0.150
    75.226   697.000     0.150
    76.752   707.305     0.150
    77.048   706.484     0.150
    77.422   708.953     0.150
    77.623   709.969     0.150
    83.257   739.945     0.150
    97.174   806.953     0.150
    32.039   755.742     0.150
    32.039   748.219     0.150
    32.039   749.992     0.150
    32.039   747.625     0.150
    32.039   643.188     0.150
    32.039   464.156     0.150
    43.788   478.773     0.150
    80.570    15.881     0.150
    80.570    27.420     0.150
    97.938    16.650     0.150
    97.938    28.830     0.150
     1.348    43.760     0.150
     1.376    25.270     0.150
    74.380    37.189     0.150
    74.380    37.561     0.150
    74.380    64.490     0.150
     2.468    66.811     0.150
   147.780    50.631     0.150
    69.522    57.590     0.150
    23.612    69.680     0.150
    39.894    73.539     0.150
   104.272    82.680     0.150
    69.111    93.551     0.150
    83.169   104.381     0.150
    71.321   104.869     0.150
     7.567   183.725     0.150
    20.142   513.051     0.150
    54.962   556.109     0.150
   150.339  1174.875     0.150
    74.583    23.695     0.150
    74.583    40.805     0.150
     1.347    25.148     0.150
     1.349    25.070     0.150
     1.361    24.781     0.150
    81.910    27.047     0.150
     1.504    27.500     0.150
    97.936    28.461     0.150
    97.936    49.227     0.150
    97.936    49.547     0.150
     3.050    51.086     0.150
     3.171    52.430     0.150
    74.408    52.766     0.150
     3.276    53.602     0.150
    80.001    53.797     0.150
     3.695    59.930     0.150
     3.712    60.070     0.150
     3.834    61.961     0.150
   149.110    65.289     0.150
     5.577    82.367     0.150
    23.331    88.461     0.150
    77.537    93.547     0.150
    75.744    98.102     0.150
    70.355   105.414     0.150
     7.268   108.906     0.150
     7.824   113.508     0.150
   115.548   139.805     0.150
   115.548   140.109     0.150
    20.632   279.711     0.150
    20.780   281.758     0.150
    31.827   387.156     0.150
    44.974   498.086     0.150
    72.669   687.383     0.150
     1.119    19.281     0.150
     1.119    19.582     0.150
     1.195    21.145     0.150
     1.195    37.984     0.150
     1.251    21.902     0.150
     1.264    22.094     0.150
    74.549    23.633     0.150
    74.549    43.992     0.150
     1.351    24.113     0.150
     1.406    24.711     0.150
     1.409    24.672     0.150
     1.420    24.332     0.150
    81.970    26.594     0.150
    97.960    27.793     0.150
     2.144    37.574     0.150
     2.468    41.762     0.150
     2.565    43.594     0.150
     2.584    43.895     0.150
    74.433    51.684     0.150
    79.969    52.434     0.150
   149.171    64.574     0.150
    39.839    68.453     0.150
    69.154    76.504     0.150
    23.297    88.082     0.150
    77.599    92.844     0.150
     6.399    93.262     0.150
    75.800    97.473     0.150
    20.692   277.582     0.150
    76.747   312.504     0.150
    31.794   386.184     0.150
    44.933   493.004     0.150
    46.143   503.934     0.150
    47.853   516.305     0.150
    48.373   520.273     0.150
    49.095   525.594     0.150
   151.742  1199.008     0.150
     0.034     9.602     0.150
    81.256    47.383     0.150
     1.641    49.562     0.150
    75.687    30.695     0.150
     2.607    38.898     0.150
   148.507    41.938     0.150
    68.128    56.617     0.150
    22.223    66.703     0.150
   104.375    68.852     0.150
    77.552    69.562     0.150
    78.841    70.445     0.150
    74.875    74.555     0.150
    69.126    81.625     0.150
     5.937    84.195     0.150
    46.533    85.695     0.150
    30.732    94.102     0.150
   114.304   119.711     0.150
    20.896   277.953     0.150
    56.325   577.023     0.150
    75.616    20.187     0.150
    75.616    34.697     0.150
    80.330    24.237     0.150
    80.330    42.316     0.150
    99.181    46.887     0.150
    68.413    44.427     0.150
    42.937    48.267     0.150
    22.501    55.606     0.150
   105.174    64.027     0.150
    76.740    63.887     0.150
    73.953    67.327     0.150
    79.039    77.507     0.150
    46.620    79.617     0.150
    30.978    92.566     0.150
   114.410   107.407     0.150
    74.908    17.556     0.150
    74.908    30.656     0.150
     1.039    19.546     0.150
    81.568    19.727     0.150
    81.568    35.276     0.150
    97.664    20.417     0.150
    97.664    35.566     0.150
    97.664    36.196     0.150
    44.607    23.066     0.150
     1.617    49.469     0.150
    74.128    47.526     0.150
    80.319    51.296     0.150
   148.754    63.196     0.150
    40.140    63.836     0.150
     4.416    66.236     0.150
    69.532    71.917     0.150
     5.118    73.017     0.150
     5.613    81.546     0.150
    23.658    84.376     0.150
   103.230    90.446     0.150
    77.125    90.917     0.150
     6.452    90.906     0.150
    75.446    95.866     0.150
     9.049   125.176     0.150
   115.841   134.046     0.150
    32.147   383.376     0.150
    63.900   625.287     0.150
    74.901    18.277     0.150
    74.901    32.078     0.150
    81.608    20.496     0.150
    81.608    36.457     0.150
    97.665    21.156     0.150
    97.665    37.199     0.150
    44.612    22.277     0.150
    74.129    47.996     0.150
    80.312    50.109     0.150
   148.794    60.566     0.150
     4.452    66.406     0.150
    69.522    69.566     0.150
     5.332    74.809     0.150
    23.650    83.816     0.150
    77.160    91.039     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.351   216.500     0.150
    18.748   256.500     0.150
    19.140   260.500     0.150
    19.625   265.500     0.150
    19.959   273.500     0.150
    21.817   290.500     0.150
    22.524   296.500     0.150
    26.073   333.602     0.150
    26.882   340.699     0.150
    27.464   343.500     0.150
    28.471   353.500     0.150
    28.858   359.301     0.150
    29.755   365.500     0.150
    29.955   369.699     0.150
    31.240   379.602     0.150
    31.574     6.000     0.150
    32.004   387.500     0.150
    32.135   389.398     0.150
    32.135     7.102     0.150
    33.806   399.500     0.150
    34.500   404.500     0.150
    34.500   730.500     0.150
    34.267   406.699     0.150
    35.272   415.500     0.150
    35.272     6.000     0.150
    35.272   787.500     0.150
    37.078   432.199     0.150
    37.224   432.500     0.150
    37.224   797.500     0.150
    38.101   436.500     0.150
    38.744   441.500     0.150
    39.541   448.500     0.150
    39.402   449.500     0.150
    40.300   457.500     0.150
    41.663   466.500     0.150
    41.663   842.500     0.150
    41.588   468.500     0.150
    41.588   568.500     0.150
    41.588   853.500     0.150
    47.587   513.500     0.150
    47.815   516.500     0.150
    47.666   513.500     0.150
    48.041   518.500     0.150
    48.041     7.000     0.150
    48.041   942.500     0.150
    48.439   521.000     0.150
    49.984   533.301     0.150
    50.330   535.199     0.150
    53.563   557.500     0.150
    53.597   559.301     0.150
    53.597   626.500     0.150
    53.597   628.500     0.150
    55.342   571.102     0.150
    55.955   576.500     0.150
    55.955     7.000     0.150
    59.105     7.000     0.150
    59.263   599.898     0.150
    59.263     6.602     0.150
    62.647   621.500     0.150
    62.811   623.500     0.150
    62.811     7.000     0.150
    62.811  1129.500     0.150
    63.169   628.000     0.150
    63.678   629.500     0.150
    65.095   639.500     0.150
    71.302     6.000     0.150
    71.302   699.500     0.150
    71.507   678.500     0.150
    71.814     6.000     0.150
    71.814   699.500     0.150
    72.191   683.500     0.150
    72.754   687.500     0.150
    73.512   691.500     0.150
    74.071   694.602     0.150
    74.213   695.398     0.150
    74.623   698.500     0.150
    76.042   706.500     0.150
    78.155   717.500     0.150
    80.747   732.500     0.150
    81.638   735.500     0.150
    81.638  1348.500     0.150
    84.690   752.500     0.150
    84.690     7.000     0.150
    87.357   969.500     0.150
    87.357  1406.500     0.150
    92.750   792.500     0.150
   146.801  1180.000     0.150
     0.805    16.074     0.150
     0.811    15.875     0.150
     3.957    59.574     0.150
     7.742   111.273     0.150
    15.410   218.273     0.150
    18.813   259.273     0.150
    18.907   260.273     0.150
    19.315   264.273     0.150
    20.340   278.273     0.150
    20.782   283.172     0.150
    21.529   291.875     0.150
    21.520   291.273     0.150
    21.740   292.273     0.150
    22.151   295.273     0.150
    23.905   314.973     0.150
    24.390   319.273     0.150
    25.553   330.875     0.150
    26.131   335.273     0.150
    26.228   335.773     0.150
    26.462   339.172     0.150
    26.899   343.273     0.150
    27.110   342.273     0.150
    27.180   345.473     0.150
    27.241   346.875     0.150
    27.948   352.172     0.150
    28.421   354.273     0.150
    28.904   361.074     0.150
    28.968   362.074     0.150
    29.602   364.273     0.150
    29.380   366.375     0.150
    29.438   364.273     0.150
    30.117   371.773     0.150
    31.289   381.773     0.150
    31.629   385.273     0.150
    31.629   700.273     0.150
    31.629   783.273     0.150
    32.170   391.273     0.150
    32.263   391.172     0.150
    32.263   557.273     0.150
    33.426   398.273     0.150
    34.204   403.273     0.150
    35.385   418.074     0.150
    37.201   433.273     0.150
    37.201   571.273     0.150
    37.299   434.273     0.150
    37.879   434.273     0.150
    38.005   438.273     0.150
    39.158   446.273     0.150
    40.280   457.273     0.150
    40.579   460.273     0.150
    41.169   462.273     0.150
    41.169   831.273     0.150
    42.216   472.773     0.150
    42.860   478.875     0.150
    44.010   488.973     0.150
    44.280   489.273     0.150
    44.849   494.273     0.150
    46.717   506.273     0.150
    47.192   512.273     0.150
    47.364   513.273     0.150
    47.493   515.273     0.150
    47.984   519.273     0.150
    47.984   941.273     0.150
    48.042   518.875     0.150
    48.534   523.273     0.150
    48.313   521.074     0.150
    49.563   531.172     0.150
    49.974   532.273     0.150
    49.974   964.273     0.150
    50.236  1186.273     0.150
    50.279   536.473     0.150
    51.637   546.273     0.150
    52.792   554.273     0.150
    53.181   556.273     0.150
    54.615   567.273     0.150
    54.958   570.172     0.150
    55.573   574.375     0.150
    55.573     6.898     0.150
    58.881   597.672     0.150
    58.881     7.602     0.150
    58.976   597.473     0.150
    62.266   620.273     0.150
    62.349   622.172     0.150
    62.349   661.273     0.150
    62.792   625.273     0.150
    63.213   628.273     0.150
    63.330   628.273     0.150
    63.238   628.273     0.150
    64.554   635.273     0.150
    64.722   638.273     0.150
    67.034   651.273     0.150
    70.581   675.172     0.150
    70.919   676.273     0.150
    70.919     7.000     0.150
    70.919    10.000     0.150
    70.919   840.273     0.150
    71.125   678.273     0.150
    71.496   680.074     0.150
    71.901   682.273     0.150
    71.736   681.273     0.150
    71.785   681.574     0.150
    72.371   685.773     0.150
    73.061   690.273     0.150
    72.991   690.273     0.150
    72.994   689.773     0.150
    73.130   690.273     0.150
    74.044   696.273     0.150
    74.239   697.273     0.150
    74.392   696.574     0.150
    75.664   705.273     0.150
    75.973   706.273     0.150
    76.012   705.273     0.150
    76.279   708.273     0.150
    76.535   709.672     0.150
    77.199   725.273     0.150
    77.851   717.273     0.150
    77.965   717.273     0.150
    77.965  1315.273     0.150
    78.136   718.875     0.150
    78.698   721.273     0.150
    80.382   730.273     0.150
    81.275   735.273     0.150
    81.275  1348.273     0.150
    81.896   737.273     0.150
    81.963   739.672     0.150
    81.927   744.273     0.150
    82.384   742.273     0.150
    82.384  1361.273     0.150
    84.555   751.273     0.150
    91.063   783.273     0.150
   138.333  1167.273     0.150
   147.183  1180.773     0.150
   147.183  1188.273     0.150
   149.833  1187.773     0.150
     0.639    12.414     0.150
     3.766    56.211     0.150
     7.554   108.012     0.150
     8.694   124.812     0.150
    15.557   217.812     0.150
    18.879   259.812     0.150
    18.962   257.812     0.150
    19.224   262.812     0.150
    20.200   274.812     0.150
    20.469   277.812     0.150
    20.937   282.812     0.150
    21.620   288.812     0.150
    21.702   540.812     0.150
    21.815   291.812     0.150
    21.984   292.812     0.150
    24.021   315.012     0.150
    24.539   319.812     0.150
    24.539   590.812     0.150
    25.738   330.914     0.150
    26.257   334.012     0.150
    26.415   335.914     0.150
    26.972   339.812     0.150
    27.024   342.711     0.150
    27.349   346.312     0.150
    27.435   346.312     0.150
    27.435   630.812     0.150
    27.435   704.812     0.150
    27.435   770.812     0.150
    28.142   353.113     0.150
    29.418   361.812     0.150
    29.418   654.812     0.150
    29.136   361.613     0.150
    29.616   365.711     0.150
    30.190   370.113     0.150
    31.429   381.312     0.150
    31.773   384.812     0.150
    31.773   455.812     0.150
    31.773   553.812     0.150
    31.773   689.812     0.150
    31.773   798.812     0.150
    32.362   389.812     0.150
    32.362   709.812     0.150
    32.439   391.312     0.150
    32.439   556.812     0.150
    33.243   395.812     0.150
    33.976   400.812     0.150
    34.431   407.812     0.150
    34.431   738.812     0.150
    35.555   417.812     0.150
    35.555   491.812     0.150
    35.555   563.812     0.150
    35.555   760.812     0.150
    36.430   424.812     0.150
    37.670   431.812     0.150
    37.375   433.512     0.150
    37.451   433.812     0.150
    38.965   443.812     0.150
    39.489   450.812     0.150
    40.138   453.812     0.150
    40.138   814.812     0.150
    40.337   455.812     0.150
    40.378   456.914     0.150
    41.047   459.812     0.150
    41.067   461.812     0.150
    41.067   832.812     0.150
    40.888   461.812     0.150
    42.332   472.012     0.150
    42.956   477.914     0.150
    44.239   487.812     0.150
    44.230   487.812     0.150
    45.020   494.812     0.150
    46.219   502.812     0.150
    46.505   503.812     0.150
    47.328   511.812     0.150
    47.342   511.812     0.150
    47.473   511.812     0.150
    48.069   517.812     0.150
    48.069   940.812     0.150
    48.096   518.012     0.150
    48.357   520.312     0.150
    49.855   530.812     0.150
    49.855   960.812     0.150
    49.627   530.613     0.150
    49.627   959.812     0.150
    50.267   534.812     0.150
    50.267     6.000     0.150
    50.267   612.812     0.150
    50.267   655.812     0.150
    50.267   967.812     0.150
    50.267   979.812     0.150
    50.267  1213.812     0.150
    50.367   535.613     0.150
    50.591   537.812     0.150
    50.591   970.812     0.150
    51.713   545.812     0.150
    52.906   554.012     0.150
    52.782   553.812     0.150
    52.971   553.613     0.150
    52.971   998.812     0.150
    53.003   554.211     0.150
    53.003   680.812     0.150
    53.003  1009.812     0.150
    54.754   566.312     0.150
    55.124   569.812     0.150
    55.124  1032.812     0.150
    55.363   571.613     0.150
    55.363     5.199     0.150
    55.363  2383.812     0.150
    58.527   593.711     0.150
    58.671   594.914     0.150
    58.671     6.898     0.150
    58.772   594.812     0.150
    62.054   616.812     0.150
    62.159   619.414     0.150
    62.159     6.398     0.150
    62.221   619.312     0.150
    62.221     7.500     0.150
    62.221  1116.812     0.150
    62.221  2366.812     0.150
    62.593   621.512     0.150
    63.100   624.812     0.150
    63.236   627.113     0.150
    63.388   627.312     0.150
    64.326   633.812     0.150
    64.555   635.312     0.150
    64.562   635.812     0.150
    66.133   644.512     0.150
    66.133     6.301     0.150
    66.815   648.812     0.150
    70.400   672.312     0.150
    70.729   673.812     0.150
    70.729     7.000     0.150
    70.729   697.812     0.150
    70.937   673.812     0.150
    70.937     8.000     0.150
    71.329   677.711     0.150
    71.675   679.812     0.150
    72.087   682.812     0.150
    72.178   683.512     0.150
    72.152   682.512     0.150
    72.152     9.301     0.150
    72.500   684.812     0.150
    72.833   687.812     0.150
    72.810   686.812     0.150
    72.910   686.812     0.150
    72.939   688.012     0.150
    73.192   687.812     0.150
    73.521   691.012     0.150
    73.665   691.914     0.150
    74.036   693.812     0.150
    74.196   694.512     0.150
    75.486   703.812     0.150
    75.744   703.812     0.150
    76.087   704.812     0.150
    76.087    10.000     0.150
    76.345   706.812     0.150
    76.345  1289.812     0.150
    77.021   712.512     0.150
    77.622   713.812     0.150
    77.748   714.812     0.150
    77.748  1309.812     0.150
    78.468   718.812     0.150
    78.468  1310.812     0.150
    78.226   717.414     0.150
    78.226  1310.812     0.150
    78.674   721.812     0.150
    79.305   724.812     0.150
    80.156   726.812     0.150
    81.000   733.812     0.150
    81.000  1345.812     0.150
    81.048   732.812     0.150
    81.612   737.812     0.150
    81.665   737.812     0.150
    81.797   735.812     0.150
    81.751   737.914     0.150
    81.777   739.812     0.150
    82.156   739.812     0.150
    82.156  1349.812     0.150
    83.277   744.812     0.150
    84.796   752.512     0.150
    84.731   752.812     0.150
    85.079   755.812     0.150
    86.827   762.312     0.150
    90.832   780.812     0.150
    93.031   791.812     0.150
   117.608  1123.812     0.150
   124.830  1139.113     0.150
   138.555  1840.812     0.150
   147.394  1180.312     0.150
     0.716    14.199     0.150
     8.038   114.598     0.150
     9.001   127.297     0.150
    15.706   221.598     0.150
    19.104   265.598     0.150
    19.336   263.598     0.150
    19.728   268.598     0.150
    20.318   279.598     0.150
    20.664   280.598     0.150
    21.062   285.199     0.150
    21.881   294.598     0.150
    22.125   295.598     0.150
    22.487   299.598     0.150
    24.246   317.797     0.150
    24.246   535.598     0.150
    24.680   322.598     0.150
    25.767   332.199     0.150
    25.767   538.598     0.150
    26.458   337.898     0.150
    26.435   338.496     0.150
    26.651   340.496     0.150
    27.227   344.598     0.150
    27.227     4.000     0.150
    27.485   345.598     0.150
    27.427   347.598     0.150
    27.427    10.000     0.150
    28.117   350.598     0.150
    28.117   636.598     0.150
    28.135   353.898     0.150
    29.085   362.398     0.150
    29.393   361.598     0.150
    29.219   363.797     0.150
    30.314   372.699     0.150
    31.928   387.598     0.150
    31.928     6.000     0.150
    31.928   555.598     0.150
    32.364   390.598     0.150
    33.360   397.598     0.150
    33.733   400.598     0.150
    35.633   420.598     0.150
    35.633     7.000     0.150
    35.633   566.598     0.150
    37.440   434.996     0.150
    37.440     6.602     0.150
    37.753   432.598     0.150
    38.864   443.598     0.150
    39.441   448.598     0.150
    39.735   452.598     0.150
    39.983   453.598     0.150
    40.648   459.598     0.150
    40.632   460.098     0.150
    40.967   462.598     0.150
    41.936   471.598     0.150
    41.936     8.000     0.150
    41.936   567.598     0.150
    41.936   854.598     0.150
    43.224   480.598     0.150
    43.294   481.199     0.150
    44.709   492.598     0.150
    46.604   505.598     0.150
    47.793   515.598     0.150
    47.899   515.598     0.150
    48.359   520.598     0.150
    49.640   529.598     0.150
    50.651   538.496     0.150
    53.411   558.398     0.150
    55.208   570.996     0.150
    55.805   575.797     0.150
    58.999   598.297     0.150
    58.999     7.301     0.150
    59.229   599.297     0.150
    62.668   623.199     0.150
    62.668  1131.598     0.150
    63.425   629.598     0.150
    63.433   629.598     0.150
    63.376   629.598     0.150
    63.526   630.598     0.150
    65.057   639.699     0.150
    66.603   648.797     0.150
    67.224   653.598     0.150
    69.259   665.598     0.150
    70.890   676.297     0.150
    71.207   678.598     0.150
    71.378   679.598     0.150
    71.378     7.000     0.150
    71.418   678.598     0.150
    71.725   681.598     0.150
    71.725     5.000     0.150
    71.725   703.598     0.150
    71.832   681.598     0.150
    71.875   681.598     0.150
    72.072   682.898     0.150
    72.123   683.297     0.150
    72.563   686.598     0.150
    72.654   687.496     0.150
    72.654   706.598     0.150
    72.962   688.598     0.150
    73.047   690.598     0.150
    73.297   691.598     0.150
    73.361   690.598     0.150
    73.417   691.898     0.150
    73.865   694.199     0.150
    74.018   695.496     0.150
    74.163   695.996     0.150
    74.361   696.598     0.150
    74.492   698.598     0.150
    74.666   699.598     0.150
    75.980   706.598     0.150
    76.565   709.598     0.150
    76.824   709.598     0.150
    77.440   713.598     0.150
    77.515   716.199     0.150
    77.849   716.598     0.150
    78.505   720.598     0.150
    78.505  1273.598     0.150
    80.525   733.598     0.150
    80.656   732.598     0.150
    81.410   735.598     0.150
    81.906   739.598     0.150
    81.961   740.598     0.150
    82.187   740.598     0.150
    82.288   741.598     0.150
    82.516   743.598     0.150
    84.328   750.598     0.150
    85.408   758.598     0.150
    87.049   763.598     0.150
    91.145   783.598     0.150
    92.564   791.398     0.150
   146.957  1180.098     0.150
     3.304    49.340     0.150
     7.080   100.641     0.150
    16.008   223.340     0.150
    18.867   257.340     0.150
    19.031   259.340     0.150
    19.415   265.340     0.150
    20.674   279.340     0.150
    20.870   280.340     0.150
    21.404   286.340     0.150
    21.566   286.340     0.150
    21.946   291.340     0.150
    22.076   293.340     0.150
    24.389   316.641     0.150
    24.389   748.340     0.150
    24.991   322.340     0.150
    24.991   593.340     0.150
    26.276   333.340     0.150
    26.276    14.000     0.150
    26.637   336.340     0.150
    26.650   336.039     0.150
    27.214   341.641     0.150
    27.871   344.340     0.150
    27.709   347.039     0.150
    27.996   349.738     0.150
    28.702   355.840     0.150
    29.635   364.441     0.150
    30.718   373.941     0.150
    31.858   383.141     0.150
    32.210   386.340     0.150
    32.210    10.000     0.150
    32.210    13.000     0.150
    32.210   702.340     0.150
    32.210   773.340     0.150
    32.582   389.840     0.150
    32.582     8.500     0.150
    32.776   389.340     0.150
    32.915   392.340     0.150
    32.875   394.340     0.150
    32.957   394.039     0.150
    32.957     9.301     0.150
    32.957    13.301     0.150
    33.552   399.340     0.150
    34.838   409.539     0.150
    36.057   420.340     0.150
    36.057     9.000     0.150
    36.057    14.000     0.150
    37.077   423.340     0.150
    37.886   435.539     0.150
    37.886     8.801     0.150
    37.910   435.840     0.150
    38.191   436.340     0.150
    38.467   438.340     0.150
    39.828   450.340     0.150
    40.477   454.340     0.150
    42.138   470.340     0.150
    42.138     9.000     0.150
    42.138   854.340     0.150
    43.269   477.340     0.150
    43.404   478.340     0.150
    45.904   495.340     0.150
    46.915   506.340     0.150
    47.333   510.340     0.150
    48.350   518.340     0.150
    48.528   520.738     0.150
    49.489   524.141     0.150
    48.968   523.539     0.150
    50.405   534.340     0.150
    50.405    11.000     0.150
    50.405   965.340     0.150
    50.405  1225.340     0.150
    52.417   547.539     0.150
    52.443   549.539     0.150
    54.218   560.941     0.150
    54.555   563.340     0.150
    54.811   565.539     0.150
    58.020   588.039     0.150
    58.116   588.941     0.150
    58.239   589.539     0.150
    61.675   613.738     0.150
    61.669   614.340     0.150
    62.071   616.141     0.150
    62.437   618.340     0.150
    63.815   627.840     0.150
    63.836   628.340     0.150
    64.130   631.340     0.150
    70.234   669.141     0.150
    70.449   669.340     0.150
    70.756   672.340     0.150
    71.044   673.340     0.150
    70.908   673.539     0.150
    71.146   674.840     0.150
    71.201   675.441     0.150
    71.678   678.340     0.150
    72.337   682.340     0.150
    72.444   683.141     0.150
    72.928   685.539     0.150
    73.079   686.641     0.150
    73.225   687.441     0.150
    73.503   689.340     0.150
    74.914   694.340     0.150
    76.566   708.441     0.150
    76.566    11.898     0.150
    76.989   707.340     0.150
    79.674   724.340     0.150
    81.033   731.340     0.150
    83.858   743.340     0.150
    84.277   746.141     0.150
    86.194   757.340     0.150
    90.203   775.840     0.150
   122.894  1133.340     0.150
     0.877    16.664     0.150
     8.391   118.465     0.150
    16.091   226.363     0.150
    19.483   267.363     0.150
    19.855   268.363     0.150
    20.221   273.363     0.150
    21.079   284.363     0.150
    21.428   288.363     0.150
    22.336   297.363     0.150
    22.605   299.363     0.150
    22.879   301.363     0.150
    23.229   308.363     0.150
    24.678   320.164     0.150
    25.056   323.363     0.150
    26.056   333.762     0.150
    26.716   338.363     0.150
    26.875   340.562     0.150
    26.911   340.562     0.150
    27.926   348.363     0.150
    27.673   349.363     0.150
    27.683   349.363     0.150
    27.762   349.363     0.150
    29.551   365.363     0.150
    30.676   374.762     0.150
    31.984   386.262     0.150
    32.314   389.363     0.150
    32.314     8.000     0.150
    32.314   467.363     0.150
    32.314   706.363     0.150
    32.314   821.363     0.150
    32.361   391.363     0.150
    32.628   391.363     0.150
    32.628   707.363     0.150
    32.807   394.363     0.150
    32.807     6.000     0.150
    34.151   400.363     0.150
    34.087   402.363     0.150
    35.021   413.363     0.150
    35.021   750.363     0.150
    35.628   417.363     0.150
    35.959   421.363     0.150
    37.578   432.363     0.150
    37.756   436.164     0.150
    37.756     7.199     0.150
    39.363   447.363     0.150
    41.079   463.363     0.150
    42.346   473.363     0.150
    42.346     9.000     0.150
    42.346   858.363     0.150
    42.987   478.363     0.150
    43.732   483.863     0.150
    45.226   495.363     0.150
    46.443   503.363     0.150
    47.900   515.363     0.150
    48.312   518.363     0.150
    48.827   523.363     0.150
    48.827   946.363     0.150
    49.220   526.363     0.150
    49.220   953.363     0.150
    49.884   531.465     0.150
    49.966   532.465     0.150
    50.444   536.262     0.150
    50.444   970.363     0.150
    50.618   536.863     0.150
    51.115   541.363     0.150
    51.750   545.363     0.150
    52.496   551.363     0.150
    53.669   559.262     0.150
    55.489   572.062     0.150
    56.064   576.465     0.150
    59.314   599.164     0.150
    59.513  1086.363     0.150
    60.137   605.363     0.150
    62.741   622.363     0.150
    62.936   624.363     0.150
    62.936  1127.363     0.150
    62.970   625.262     0.150
    62.970     5.102     0.150
    63.355   626.664     0.150
    63.747   630.863     0.150
    65.113   638.363     0.150
    65.444   640.363     0.150
    66.914   649.562     0.150
    67.429   653.363     0.150
    69.643   667.363     0.150
    71.244   677.664     0.150
    71.534   678.965     0.150
    71.534     7.398     0.150
    71.534   699.363     0.150
    71.534   845.363     0.150
    71.817   680.363     0.150
    71.752   680.363     0.150
    71.745   680.363     0.150
    71.745  1245.363     0.150
    71.745  1526.363     0.150
    72.059   682.363     0.150
    72.059     7.000     0.150
    72.222   683.062     0.150
    72.222     6.301     0.150
    72.460   684.363     0.150
    72.460     6.000     0.150
    72.515   684.762     0.150
    72.515     6.602     0.150
    73.004   689.363     0.150
    72.975   687.863     0.150
    73.645   691.363     0.150
    73.645     8.000     0.150
    73.744   692.863     0.150
    74.242   694.965     0.150
    74.392   696.164     0.150
    74.392     6.199     0.150
    74.539   696.863     0.150
    74.776   699.363     0.150
    75.739   704.863     0.150
    75.739   715.363     0.150
    75.969   704.363     0.150
    76.344   708.363     0.150
    76.890   710.363     0.150
    77.836   714.363     0.150
    77.879   717.164     0.150
    77.879   724.363     0.150
    80.812   732.363     0.150
    81.373   735.363     0.150
    81.546   735.363     0.150
    81.954   738.363     0.150
    82.011   739.363     0.150
    84.030   747.363     0.150
    84.930   752.363     0.150
    84.930     7.000     0.150
    84.930  1380.363     0.150
    87.014   763.363     0.150
    91.217   782.363     0.150
   144.918  1175.363     0.150
   146.702  1178.863     0.150
   146.702  1186.363     0.150
     0.368     8.508     0.150
     7.157   102.109     0.150
     9.230   129.109     0.150
    15.217   209.508     0.150
    15.973   223.609     0.150
    16.242   226.109     0.150
    19.090   260.711     0.150
    19.213   262.809     0.150
    19.649   268.109     0.150
    20.776   281.711     0.150
    20.903   282.008     0.150
    21.111   283.809     0.150
    21.635   289.809     0.150
    21.666   287.809     0.150
    22.193   294.109     0.150
    22.324   296.109     0.150
    22.433   298.410     0.150
    22.433   541.109     0.150
    23.282   307.410     0.150
    23.282   567.109     0.150
    24.633   319.109     0.150
    24.633   580.109     0.150
    25.225   324.109     0.150
    25.225   597.109     0.150
    26.726   338.609     0.150
    27.019   339.109     0.150
    27.166   342.109     0.150
    27.631   343.109     0.150
    27.657   346.508     0.150
    28.197   352.109     0.150
    28.197   644.109     0.150
    28.903   358.109     0.150
    28.952   358.809     0.150
    28.952   649.109     0.150
    29.862   366.910     0.150
    29.858   367.008     0.150
    30.335   371.910     0.150
    30.353   371.109     0.150
    30.353   674.109     0.150
    30.887   375.309     0.150
    30.952   376.109     0.150
    30.952   679.109     0.150
    32.446   389.711     0.150
    32.446   704.109     0.150
    32.849   390.609     0.150
    33.214   392.109     0.150
    33.175   396.609     0.150
    33.175   779.109     0.150
    33.971   403.109     0.150
    35.079   412.109     0.150
    36.279   423.309     0.150
    36.279   766.109     0.150
    36.873   427.109     0.150
    36.970   427.609     0.150
    36.970   789.109     0.150
    37.935   432.109     0.150
    38.105   438.109     0.150
    38.105   795.109     0.150
    38.143   437.910     0.150
    38.521   439.109     0.150
    40.299   454.910     0.150
    40.299   817.109     0.150
    40.458   455.109     0.150
    40.840   459.109     0.150
    41.053   460.309     0.150
    41.053   460.109     0.150
    41.056   460.109     0.150
    41.558   466.109     0.150
    41.558   839.109     0.150
    42.380   472.109     0.150
    42.726   475.711     0.150
    42.726   475.109     0.150
    42.855   473.109     0.150
    42.855   863.910     0.150
    42.940   477.109     0.150
    42.940   860.109     0.150
    43.516   480.109     0.150
    43.853   484.109     0.150
    44.033   482.910     0.150
    44.033   482.109     0.150
    44.033   887.008     0.150
    44.389   487.508     0.150
    44.678   489.109     0.150
    44.678   879.109     0.150
    45.082   494.410     0.150
    45.202   493.109     0.150
    45.439   497.109     0.150
    45.770   499.109     0.150
    45.770   897.109     0.150
    45.770   499.211     0.150
    45.770   897.410     0.150
    45.729   496.109     0.150
    45.889   502.211     0.150
    45.889   502.109     0.150
    46.366   500.008     0.150
    46.366   903.109     0.150
    46.565   504.109     0.150
    47.015   508.109     0.150
    47.015   918.109     0.150
    47.217   509.109     0.150
    47.225   512.109     0.150
    47.225   923.109     0.150
    47.692   511.109     0.150
    47.692  1113.109     0.150
    47.533   511.910     0.150
    47.775   515.109     0.150
    48.170   516.609     0.150
    48.170   516.109     0.150
    48.599   521.109     0.150
    48.599   945.109     0.150
    48.599  1106.109     0.150
    48.715   522.109     0.150
    48.715     9.000     0.150
    49.244   524.410     0.150
    49.244   958.109     0.150
    50.099   532.309     0.150
    50.444   535.109     0.150
    50.586   537.309     0.150
    50.609   538.109     0.150
    50.609   974.109     0.150
    50.647   658.109     0.150
    50.647  1192.109     0.150
    50.774   534.910     0.150
    50.774   977.109     0.150
    50.905   538.109     0.150
    51.793   543.508     0.150
    51.793   543.109     0.150
    51.912   545.309     0.150
    51.912   997.109     0.150
    52.057   551.410     0.150
    52.057   551.109     0.150
    52.402   548.809     0.150
    52.432   548.109     0.150
    52.432   989.109     0.150
    52.432  1015.109     0.150
    52.452   548.809     0.150
    52.452   621.109     0.150
    52.452   991.109     0.150
    53.035   555.109     0.150
    53.626   556.109     0.150
    53.626  1016.109     0.150
    54.246   561.711     0.150
    54.246  1015.109     0.150
    54.556   564.109     0.150
    54.556  1021.109     0.150
    54.549   569.109     0.150
    54.549    10.000     0.150
    54.549  1024.109     0.150
    54.549  1034.109     0.150
    54.826   566.211     0.150
    54.826  1032.109     0.150
    54.826  1046.109     0.150
    55.247   571.211     0.150
    55.247   571.109     0.150
    55.247  1025.609     0.150
    55.717   573.109     0.150
    56.558   579.109     0.150
    56.558  1051.109     0.150
    57.125   583.008     0.150
    57.125   582.109     0.150
    57.134   586.910     0.150
    57.134  1068.609     0.150
    57.800   587.109     0.150
    58.129   590.410     0.150
    58.129  1075.109     0.150
    58.129  1094.109     0.150
    58.129  2375.109     0.150
    58.129  2395.109     0.150
    58.270   590.211     0.150
    58.270  1063.109     0.150
    60.258   605.109     0.150
    60.460   606.008     0.150
    60.460     8.102     0.150
    60.460  1121.109     0.150
    60.555   606.711     0.150
    60.555     8.398     0.150
    60.555   651.109     0.150
    61.696   614.109     0.150
    61.696   759.109     0.150
    61.696  1115.109     0.150
    61.696  1139.109     0.150
    61.696  1226.109     0.150
    61.696  2373.109     0.150
    61.726   615.211     0.150
    61.726   653.109     0.150
    61.726  1119.109     0.150
    61.993   616.109     0.150
    61.993  1118.109     0.150
    62.110   616.910     0.150
    62.110  1108.109     0.150
    62.110  1117.109     0.150
    62.110  1125.109     0.150
    62.110  2382.910     0.150
    62.356   618.109     0.150
    62.356  1121.109     0.150
    62.403   619.109     0.150
    62.403   768.109     0.150
    62.403  1125.109     0.150
    62.403  1208.109     0.150
    62.403  1365.109     0.150
    62.444   619.109     0.150
    62.444   769.109     0.150
    62.444   900.109     0.150
    62.444  1126.109     0.150
    62.444  1144.109     0.150
    62.444  1123.109     0.150
    62.646   767.109     0.150
    62.646  1135.109     0.150
    62.808   621.109     0.150
    63.565   625.109     0.150
    63.565  1139.109     0.150
    63.918   630.109     0.150
    63.918  1146.109     0.150
    64.277   629.109     0.150
    64.224   631.508     0.150
    64.231   631.809     0.150
    64.231   773.109     0.150
    64.231  1147.109     0.150
    64.231  1396.109     0.150
    65.899   642.109     0.150
    65.901   642.508     0.150
    65.901   791.109     0.150
    65.901  1167.109     0.150
    65.901  1187.109     0.150
    66.043   644.109     0.150
    66.043   797.109     0.150
    66.043  1172.109     0.150
    66.264   644.109     0.150
    66.217   644.109     0.150
    66.217   795.109     0.150
    66.217  1177.109     0.150
    66.789   647.109     0.150
    66.789  1172.109     0.150
    66.952   651.410     0.150
    66.952  1193.109     0.150
    67.894   656.410     0.150
    67.894  1196.109     0.150
    68.420   658.109     0.150
    68.632   817.109     0.150
    68.632  1205.109     0.150
    69.792   829.109     0.150
    69.792  1221.109     0.150
    70.005   668.109     0.150
    70.005  1224.109     0.150
    70.005   668.711     0.150
    70.005   823.109     0.150
    70.005  1218.109     0.150
    70.273   669.109     0.150
    70.273   688.109     0.150
    70.273   829.109     0.150
    70.273  1223.109     0.150
    70.273  1277.109     0.150
    70.289   670.109     0.150
    70.289     8.898     0.150
    70.289    13.500     0.150
    70.289   692.910     0.150
    70.289  1242.109     0.150
    70.289  1276.109     0.150
    70.289  1486.109     0.150
    70.289     9.000     0.150
    70.289    14.000     0.150
    70.289   693.109     0.150
    70.511   672.809     0.150
    70.511    14.301     0.150
    70.511   692.109     0.150
    70.511  1227.109     0.150
    70.511  1241.109     0.150
    70.816   673.910     0.150
    70.816  1229.109     0.150
    70.816  1275.109     0.150
    70.816  1499.109     0.150
    70.878   676.410     0.150
    71.003   674.008     0.150
    71.186   676.109     0.150
    71.240   675.309     0.150
    71.297   676.309     0.150
    71.640   679.109     0.150
    71.640   834.109     0.150
    71.640  1246.109     0.150
    71.730   679.008     0.150
    71.730   839.109     0.150
    71.730  1276.109     0.150
    71.730  1512.109     0.150
    72.072   681.109     0.150
    72.072   847.109     0.150
    72.012   681.109     0.150
    72.012   846.109     0.150
    72.012  1241.109     0.150
    72.012  1260.109     0.150
    72.077   682.211     0.150
    72.077   703.109     0.150
    72.077   839.109     0.150
    72.077  1241.109     0.150
    72.393   682.109     0.150
    72.393   849.109     0.150
    72.393  1521.109     0.150
    72.405   683.309     0.150
    72.405  1251.109     0.150
    72.416   683.910     0.150
    72.416   849.109     0.150
    72.416  1249.109     0.150
    72.848   687.508     0.150
    72.848  1247.109     0.150
    73.122   687.109     0.150
    73.015   686.711     0.150
    73.163   687.410     0.150
    73.310   688.109     0.150
    73.388   689.109     0.150
    73.491   689.309     0.150
    73.532   690.109     0.150
    73.532  1261.109     0.150
    73.600   690.309     0.150
    73.600     8.801     0.150
    73.600   707.109     0.150
    73.600   854.109     0.150
    73.600  1254.109     0.150
    73.600  1287.109     0.150
    73.600  1293.109     0.150
    73.600  1299.109     0.150
    73.731   690.109     0.150
    73.731   864.109     0.150
    73.731  1250.109     0.150
    74.669   694.609     0.150
    74.993   697.109     0.150
    74.993  1280.109     0.150
    75.061   698.109     0.150
    75.061  1281.109     0.150
    75.109   698.809     0.150
    75.252   699.109     0.150
    75.252  1279.109     0.150
    75.541   702.211     0.150
    75.645   701.711     0.150
    75.645   878.109     0.150
    75.687   701.109     0.150
    75.690   702.309     0.150
    75.862   703.109     0.150
    75.862  1283.109     0.150
    75.909   703.109     0.150
    75.909   879.109     0.150
    75.909  1289.109     0.150
    75.937  1318.109     0.150
    75.980   719.109     0.150
    75.980  1284.109     0.150
    75.980  1309.109     0.150
    76.186   704.109     0.150
    76.022   704.109     0.150
    76.022    10.000     0.150
    76.022  1291.109     0.150
    76.022  1308.109     0.150
    76.445   705.109     0.150
    76.383   709.109     0.150
    76.383  1299.109     0.150
    76.592   707.809     0.150
    76.592     8.301     0.150
    76.592   719.109     0.150
    76.592   872.109     0.150
    76.592  1289.109     0.150
    76.592  1299.109     0.150
    76.592  1586.109     0.150
    76.622   706.809     0.150
    76.644   708.711     0.150
    76.644   719.109     0.150
    76.866   709.109     0.150
    76.874  1319.109     0.150
    76.965   712.109     0.150
    77.163   710.109     0.150
    77.163     9.000     0.150
    77.163   889.109     0.150
    77.163  1298.109     0.150
    77.163  1317.109     0.150
    77.163  1345.109     0.150
    77.163  1599.109     0.150
    77.274   711.008     0.150
    77.274   888.109     0.150
    77.274  1304.109     0.150
    77.715   713.109     0.150
    77.864   716.109     0.150
    77.864  1307.109     0.150
    77.834  1313.109     0.150
    77.913   715.109     0.150
    77.913  1306.109     0.150
    78.188   716.809     0.150
    78.188    11.301     0.150
    78.188  1337.109     0.150
    78.169   716.109     0.150
    78.169     9.000     0.150
    78.169  1310.109     0.150
    78.169  1357.109     0.150
    78.169  1352.109     0.150
    78.287   718.109     0.150
    78.287  1313.109     0.150
    78.767    14.801     0.150
    78.823   721.109     0.150
    78.841   720.609     0.150
    78.841   900.109     0.150
    78.841  1322.109     0.150
    79.260  1336.109     0.150
    79.582   725.609     0.150
    79.504   724.109     0.150
    79.504  1329.109     0.150
    79.556   722.109     0.150
    79.556  1328.109     0.150
    79.636   724.109     0.150
    79.636  1332.109     0.150
    79.822   725.008     0.150
    79.822  1329.109     0.150
    79.929  1324.109     0.150
    80.289   729.109     0.150
    80.221   731.109     0.150
    80.387   727.109     0.150
    80.387  1333.109     0.150
    80.445   732.109     0.150
    80.748   730.109     0.150
    80.748    10.000     0.150
    80.748  1338.109     0.150
    80.776  1348.109     0.150
    80.891   731.109     0.150
    80.891    10.000     0.150
    80.891   925.109     0.150
    80.891  1350.109     0.150
    80.891  1363.109     0.150
    80.891  1659.109     0.150
    80.945   733.109     0.150
    81.045   730.508     0.150
    81.045   922.109     0.150
    81.045  1337.109     0.150
    81.045  1395.109     0.150
    81.053   733.109     0.150
    81.053  1351.109     0.150
    81.180   731.910     0.150
    81.201   732.309     0.150
    81.201  1346.109     0.150
    81.494   735.109     0.150
    81.494  1354.109     0.150
    81.574   735.109     0.150
    81.574  1346.109     0.150
    82.495   739.109     0.150
    83.064   742.609     0.150
    83.064    11.500     0.150
    83.064   931.109     0.150
    83.064  1355.109     0.150
    83.064  1373.109     0.150
    83.064  1689.109     0.150
    82.999   740.910     0.150
    83.520   743.109     0.150
    83.520  1364.109     0.150
    83.795   750.109     0.150
    83.795  1366.109     0.150
    83.892   746.609     0.150
    83.892  1369.109     0.150
    84.126   748.109     0.150
    84.121   747.109     0.150
    84.121     9.000     0.150
    84.121   948.109     0.150
    84.121  1364.109     0.150
    84.121  1370.109     0.150
    84.222   747.211     0.150
    84.222   946.109     0.150
    84.222  1369.109     0.150
    84.222  1374.109     0.150
    84.222  1426.109     0.150
    84.385   750.109     0.150
    84.385  1380.109     0.150
    84.648   751.109     0.150
    84.648     9.000     0.150
    84.681   752.309     0.150
    85.239   757.109     0.150
    85.239  1374.109     0.150
    86.069   757.309     0.150
    87.119   765.609     0.150
    88.153   766.109     0.150
    88.153  1410.109     0.150
    90.125   776.809     0.150
    90.236   777.609     0.150
    90.236   990.109     0.150
    90.236  1411.109     0.150
    90.939   778.109     0.150
    91.637   784.109     0.150
    91.637  1443.109     0.150
    92.314   787.609     0.150
    92.314  1449.109     0.150
    92.781   790.109     0.150
    92.874   789.609     0.150
    92.874  1416.109     0.150
    93.577   793.109     0.150
    93.408   796.109     0.150
    94.625   796.609     0.150
    94.625  1031.109     0.150
    94.625  1436.109     0.150
    94.625  1475.109     0.150
    94.625  1557.109     0.150
    99.100  1068.109     0.150
    99.100  1598.109     0.150
   100.483  1500.109     0.150
   100.792   826.109     0.150
   100.899  1069.109     0.150
   100.899  1463.109     0.150
   100.899  1942.109     0.150
   102.761  1472.109     0.150
   102.761  1539.109     0.150
   102.761  1635.109     0.150
   102.761  1967.109     0.150
   103.025  1546.109     0.150
   103.025  1642.109     0.150
   103.025  1982.109     0.150
   105.167  1118.109     0.150
   105.167  1488.109     0.150
   105.167  1666.109     0.150
   105.167  2011.109     0.150
   107.999  1499.109     0.150
   112.476   879.109     0.150
   112.476  1163.109     0.150
   113.387  1519.109     0.150
   117.235  1120.609     0.150
   122.861  1134.410     0.150
   124.278  1136.809     0.150
   124.278  1245.109     0.150
   124.278  2256.109     0.150
   134.165  1151.109     0.150
   134.165  1915.109     0.150
   135.623  1157.211     0.150
   135.623  1163.109     0.150
   135.623  1318.109     0.150
   136.411  1152.109     0.150
   136.411  1318.109     0.150
   139.172  1156.609     0.150
   139.172  1344.109     0.150
   139.589  1165.109     0.150
   142.074  1163.109     0.150
   142.074  1361.109     0.150
   143.263  1169.109     0.150
   143.263  1381.109     0.150
   143.689  1169.211     0.150
   147.938  1174.109     0.150
   148.035  1178.508     0.150
   148.035  1181.809     0.150
   148.035  1186.508     0.150
   148.035  1396.211     0.150
   148.035  2535.109     0.150
   148.035  1181.910     0.150
   149.888  1178.109     0.150
   161.599  1197.109     0.150
   161.599  1247.109     0.150
     0.477     9.758     0.150
     7.924   112.555     0.150
     9.180   131.555     0.150
    14.194   201.055     0.150
    14.194   209.555     0.150
    14.194   348.555     0.150
    15.881   223.555     0.150
    15.937   224.555     0.150
    19.337   265.555     0.150
    19.420   265.555     0.150
    19.742   268.555     0.150
    20.555   279.555     0.150
    20.884   283.555     0.150
    21.299   287.953     0.150
    22.080   295.555     0.150
    22.305   296.555     0.150
    22.400   296.555     0.150
    22.838   303.555     0.150
    24.457   589.555     0.150
    24.914   323.453     0.150
    26.018   334.453     0.150
    26.687   339.758     0.150
    26.687   615.555     0.150
    27.438   343.555     0.150
    27.443   344.555     0.150
    27.445   346.055     0.150
    27.445    11.500     0.150
    27.681   349.352     0.150
    27.681   626.555     0.150
    27.681     7.203     0.150
    27.681   398.555     0.150
    27.690   347.555     0.150
    27.919     7.000     0.150
    28.389   355.656     0.150
    28.389     6.898     0.150
    28.465   356.555     0.150
    28.465     7.000     0.150
    28.801   359.555     0.150
    28.801     7.000     0.150
    28.801   546.555     0.150
    29.141   359.555     0.150
    29.141   648.555     0.150
    29.463   365.352     0.150
    29.463     7.203     0.150
    29.685   366.453     0.150
    29.685   769.555     0.150
    29.820   369.352     0.150
    29.917   369.555     0.150
    30.551   374.453     0.150
    30.551     6.102     0.150
    30.640   374.758     0.150
    30.640     6.797     0.150
    30.640   436.555     0.150
    31.822   384.852     0.150
    31.822     7.703     0.150
    31.822   554.555     0.150
    32.159   388.656     0.150
    32.617   393.555     0.150
    32.617     6.000     0.150
    32.617   711.555     0.150
    32.744   394.758     0.150
    32.744     6.797     0.150
    32.906   396.453     0.150
    32.988   396.055     0.150
    32.988     7.500     0.150
    33.621   398.555     0.150
    33.579   402.555     0.150
    33.944   400.555     0.150
    35.878   421.555     0.150
    35.878   764.555     0.150
    36.080   421.953     0.150
    36.080   501.555     0.150
    36.177   419.555     0.150
    37.496   431.555     0.150
    37.496   775.555     0.150
    37.687   436.055     0.150
    37.687     8.500     0.150
    37.687   787.555     0.150
    37.817   437.055     0.150
    37.817     8.500     0.150
    38.136   435.555     0.150
    38.136   785.555     0.150
    38.888   443.555     0.150
    39.312   447.352     0.150
    39.464   448.555     0.150
    39.752   451.555     0.150
    40.834   461.352     0.150
    40.936   462.156     0.150
    40.936   562.555     0.150
    40.936   833.555     0.150
    41.282   464.555     0.150
    41.282   837.555     0.150
    41.277   465.555     0.150
    41.277     7.000     0.150
    41.277   843.555     0.150
    42.157   472.656     0.150
    42.157     7.898     0.150
    42.769   477.055     0.150
    42.769   863.555     0.150
    42.888   475.555     0.150
    43.596   483.055     0.150
    44.778   492.555     0.150
    46.091   503.555     0.150
    46.347   503.555     0.150
    46.525   507.555     0.150
    46.749   507.555     0.150
    47.749   515.656     0.150
    47.738   514.656     0.150
    47.882   516.555     0.150
    48.010   516.555     0.150
    48.547   521.758     0.150
    48.547   939.555     0.150
    48.605   522.758     0.150
    48.873   524.555     0.150
    49.470   528.656     0.150
    49.573   529.555     0.150
    50.127   533.758     0.150
    50.127   965.555     0.150
    50.215   534.352     0.150
    50.531   536.258     0.150
    50.531     7.297     0.150
    50.672   538.055     0.150
    50.791   539.555     0.150
    50.791     7.000     0.150
    50.791   977.555     0.150
    50.791  1123.555     0.150
    51.122   542.156     0.150
    51.122   978.555     0.150
    51.344   542.953     0.150
    51.836   546.055     0.150
    52.102   548.953     0.150
    52.201   549.555     0.150
    52.201     7.000     0.150
    52.201   993.555     0.150
    52.556   552.156     0.150
    52.556     6.398     0.150
    53.212   556.258     0.150
    53.212     7.297     0.150
    53.249   556.258     0.150
    53.249     7.297     0.150
    53.271   557.156     0.150
    53.271  1005.555     0.150
    53.321   556.555     0.150
    54.246   563.555     0.150
    54.158   565.555     0.150
    55.057   569.352     0.150
    55.057     6.805     0.150
    55.057  1029.555     0.150
    55.644   573.953     0.150
    55.644     6.602     0.150
    55.644  1039.555     0.150
    55.644  2382.555     0.150
    56.125   577.555     0.150
    58.947   597.656     0.150
    58.947     5.898     0.150
    58.947  1083.555     0.150
    58.947  2371.555     0.150
    59.079   598.156     0.150
    59.079  1082.555     0.150
    61.252   613.656     0.150
    61.252     5.898     0.150
    61.252   756.555     0.150
    61.252  1115.555     0.150
    62.141   619.555     0.150
    62.511   621.758     0.150
    62.511     6.797     0.150
    62.511  1128.555     0.150
    62.511  1207.555     0.150
    62.511  1369.555     0.150
    62.511  2369.555     0.150
    62.914   624.453     0.150
    62.914     5.805     0.150
    62.914  1126.555     0.150
    62.914  2366.852     0.150
    63.265   627.555     0.150
    63.265  1137.555     0.150
    63.610   630.555     0.150
    63.610  1147.555     0.150
    64.141   635.555     0.150
    64.141  1037.555     0.150
    64.293   632.953     0.150
    64.293  1150.555     0.150
    64.967   639.555     0.150
    64.974   637.953     0.150
    64.974     6.602     0.150
    64.974  1159.555     0.150
    66.693   650.156     0.150
    66.693     6.398     0.150
    66.693  1191.555     0.150
    67.041   652.555     0.150
    67.041  1185.555     0.150
    67.201   653.555     0.150
    67.201  1190.555     0.150
    69.167   664.555     0.150
    69.167     7.000     0.150
    69.399   667.555     0.150
    69.399  1219.555     0.150
    70.778   675.055     0.150
    70.778    11.500     0.150
    70.778   834.555     0.150
    70.792   674.555     0.150
    71.080   676.555     0.150
    71.080     7.000     0.150
    71.080   837.555     0.150
    71.080  1233.555     0.150
    71.080  2347.555     0.150
    71.274     7.500     0.150
    71.274   843.555     0.150
    71.274  1242.555     0.150
    71.274  1510.555     0.150
    71.602   680.555     0.150
    71.602     7.000     0.150
    71.602   845.555     0.150
    71.643   682.555     0.150
    71.643     7.000     0.150
    71.643   840.555     0.150
    71.744   680.852     0.150
    71.982   681.852     0.150
    72.036   682.656     0.150
    72.433   686.258     0.150
    72.433     6.297     0.150
    72.433   853.555     0.150
    72.509   686.055     0.150
    72.524   686.156     0.150
    72.524   847.555     0.150
    72.801   688.555     0.150
    72.801  1253.555     0.150
    72.818   687.555     0.150
    72.852   689.555     0.150
    72.852  1243.555     0.150
    72.850   687.055     0.150
    72.850     7.500     0.150
    73.182   689.055     0.150
    73.207   689.555     0.150
    73.207  1258.555     0.150
    73.189   690.352     0.150
    73.189  1261.555     0.150
    73.427   691.555     0.150
    73.290   690.953     0.150
    73.468   691.555     0.150
    73.468     6.000     0.150
    73.768   692.656     0.150
    73.768   855.555     0.150
    73.919   694.055     0.150
    74.016   694.555     0.150
    74.065   695.258     0.150
    74.203   696.352     0.150
    74.256   696.758     0.150
    74.397   696.555     0.150
    74.397     7.000     0.150
    74.397    10.000     0.150
    74.397   712.555     0.150
    74.530   697.055     0.150
    74.610   698.555     0.150
    74.856   697.555     0.150
    74.856  1272.555     0.150
    75.335   703.555     0.150
    75.742   703.555     0.150
    75.742  1285.555     0.150
    75.831   704.555     0.150
    75.879   704.555     0.150
    76.029   708.555     0.150
    75.875   706.156     0.150
    76.071   704.555     0.150
    76.071  1289.555     0.150
    76.451   707.555     0.150
    76.699   708.555     0.150
    76.699   888.555     0.150
    76.699  1291.555     0.150
    77.124   711.555     0.150
    77.276   713.555     0.150
    77.276   723.555     0.150
    77.276   888.555     0.150
    77.276  1299.555     0.150
    77.276  1599.555     0.150
    77.356   713.555     0.150
    77.410   715.156     0.150
    77.605   714.555     0.150
    77.779   718.555     0.150
    77.987   716.555     0.150
    77.987  1307.555     0.150
    78.080   718.258     0.150
    78.080     6.297     0.150
    78.080  1331.555     0.150
    78.460   718.555     0.150
    78.460  1314.555     0.150
    78.459   720.555     0.150
    78.459  1311.555     0.150
    78.643   721.555     0.150
    78.643  1316.555     0.150
    78.698  1317.555     0.150
    78.906   722.758     0.150
    78.992   722.555     0.150
    78.992  1315.555     0.150
    79.548   726.453     0.150
    79.548  1331.555     0.150
    79.590   727.156     0.150
    79.875   727.555     0.150
    79.875   907.555     0.150
    79.875  1327.555     0.150
    79.728   726.555     0.150
    79.728  1323.555     0.150
    80.322   729.555     0.150
    80.322  1334.555     0.150
    81.082   734.555     0.150
    81.082  1343.555     0.150
    81.203   734.555     0.150
    81.203  1342.555     0.150
    81.588   735.156     0.150
    81.571   736.555     0.150
    81.732   738.555     0.150
    81.572   740.555     0.150
    81.776   738.555     0.150
    82.000   738.555     0.150
    82.021   737.555     0.150
    82.309   741.555     0.150
    82.309  1356.555     0.150
    82.736   742.055     0.150
    82.736   929.555     0.150
    82.736  1358.555     0.150
    82.964   744.555     0.150
    83.061   744.555     0.150
    83.192   743.555     0.150
    83.192  1362.555     0.150
    83.815   747.555     0.150
    83.996   748.555     0.150
    83.996     8.000     0.150
    83.996  1378.555     0.150
    84.790   751.852     0.150
    84.697   752.258     0.150
    85.033   751.656     0.150
    85.033  1373.555     0.150
    84.991   754.555     0.150
    84.991     7.000     0.150
    85.189   755.555     0.150
    85.366   756.258     0.150
    85.366     8.297     0.150
    85.366    12.297     0.150
    85.366   959.555     0.150
    85.366  1380.555     0.150
    85.366  1390.555     0.150
    86.805   762.055     0.150
    86.805   964.555     0.150
    86.805  1389.555     0.150
    88.976   773.555     0.150
    89.322   775.055     0.150
    90.921   782.258     0.150
    90.921   996.555     0.150
    90.921  1409.555     0.150
    91.059   783.555     0.150
    91.059   999.555     0.150
    91.059  1413.555     0.150
    92.491   789.555     0.150
    93.136   793.055     0.150
    93.136     6.500     0.150
    93.136  1016.555     0.150
    93.074   793.656     0.150
    95.284   801.555     0.150
    98.060   815.555     0.150
    98.060     6.000     0.150
   100.194   822.555     0.150
   100.194   831.555     0.150
   100.194  1461.555     0.150
   100.194  1933.555     0.150
   100.612   825.555     0.150
   100.612  1074.555     0.150
   100.612  1466.555     0.150
   113.296  1744.555     0.150
   118.019  1124.352     0.150
   123.682  1138.352     0.150
   136.360  1160.156     0.150
   137.222  1327.555     0.150
   142.894  1168.555     0.150
   144.444  1173.453     0.150
   147.120  1175.055     0.150
   148.481  1182.055     0.150
   148.859  1182.055     0.150
   148.859  1185.555     0.150
   152.274  1193.555     0.150
     4.068    58.918     0.150
     4.864    70.219     0.150
     6.505    93.418     0.150
     6.836    97.020     0.150
     7.118   101.418     0.150
     7.118   180.219     0.150
     7.296   103.418     0.150
    10.346   142.219     0.150
    12.835   181.617     0.150
    14.263   199.520     0.150
    14.263   375.219     0.150
    17.098   237.219     0.150
    17.439   245.219     0.150
    19.690   265.219     0.150
    19.856   266.219     0.150
    20.846   282.219     0.150
    21.657   284.219     0.150
    22.289   294.219     0.150
    22.836   299.219     0.150
    23.404   305.219     0.150
    24.236   315.219     0.150
    25.792   328.418     0.150
    26.422   333.520     0.150
    26.948   339.219     0.150
    27.684   346.320     0.150
    28.361   351.418     0.150
    28.524   352.219     0.150
    28.828   355.520     0.150
    29.123   359.219     0.150
    29.382   655.219     0.150
    30.089   367.719     0.150
    30.146   368.820     0.150
    30.501   371.219     0.150
    30.500   551.219     0.150
    30.932   374.020     0.150
    30.932   549.219     0.150
    31.062   376.719     0.150
    31.521   381.719     0.150
    31.555   379.320     0.150
    32.208   383.219     0.150
    32.689   387.219     0.150
    33.638   398.219     0.150
    33.638   726.219     0.150
    34.309   405.219     0.150
    34.309    10.000     0.150
    34.309   559.219     0.150
    35.747   414.219     0.150
    35.747   752.219     0.150
    36.258   421.219     0.150
    36.258   766.219     0.150
    36.449   425.219     0.150
    37.483   431.520     0.150
    37.483   788.219     0.150
    38.287   436.219     0.150
    38.262   436.219     0.150
    38.241   435.219     0.150
    38.241   570.219     0.150
    38.858   440.219     0.150
    39.309   445.617     0.150
    39.309   575.219     0.150
    39.341   447.418     0.150
    39.341   576.219     0.150
    39.341   806.219     0.150
    39.899   450.219     0.150
    41.211   462.219     0.150
    41.907   467.719     0.150
    42.747   477.219     0.150
    42.747   585.219     0.150
    44.593   487.219     0.150
    44.794   489.719     0.150
    45.053   492.219     0.150
    46.495   502.219     0.150
    46.920   511.219     0.150
    47.349   508.520     0.150
    47.369   927.219     0.150
    47.992   514.617     0.150
    48.299   517.219     0.150
    48.413   517.219     0.150
    49.688   528.719     0.150
    49.750   529.418     0.150
    50.003   529.219     0.150
    50.226   531.219     0.150
    50.809   536.219     0.150
    51.585   543.219     0.150
    51.585   614.219     0.150
    51.585   976.219     0.150
    51.832   545.020     0.150
    53.857   556.918     0.150
    56.348   579.219     0.150
    56.711   577.219     0.150
    61.327   613.418     0.150
    61.327   650.219     0.150
    61.595   611.219     0.150
    62.554   619.219     0.150
    62.927   623.219     0.150
    69.868   666.219     0.150
    69.936   668.219     0.150
    70.024   666.219     0.150
    70.571   670.219     0.150
    71.447   676.219     0.150
    72.232   680.617     0.150
    73.041   686.918     0.150
    73.145   685.219     0.150
    73.195   686.520     0.150
    73.898   693.418     0.150
    74.954   696.219     0.150
    75.552   701.219     0.150
    75.875   701.219     0.150
    75.920   703.617     0.150
    75.951   703.219     0.150
    79.665   722.219     0.150
    79.868   723.219     0.150
    82.337   737.617     0.150
    82.626   739.820     0.150
    83.031   740.418     0.150
    84.453    12.000     0.150
    84.773   750.219     0.150
    84.773   755.219     0.150
    85.071   751.820     0.150
    85.071   947.219     0.150
    92.217   784.219     0.150
   101.672   827.617     0.150
   102.087   829.219     0.150
   136.616  1152.219     0.150
   138.213  1157.219     0.150
   139.780  1159.918     0.150
   139.780  1164.219     0.150
   141.567  1162.219     0.150
   147.163  1179.219     0.150
   148.384  1175.219     0.150
   148.384  1181.219     0.150
   149.383  1183.918     0.150
   150.201  1186.219     0.150
   161.118  1237.918     0.150
     0.617    12.672     0.150
     2.168    34.072     0.150
     2.168    37.473     0.150
     3.515    52.572     0.150
     3.636    53.873     0.150
     4.252    63.172     0.150
     6.035    87.572     0.150
     6.970   100.473     0.150
     7.137   101.473     0.150
    15.583   219.373     0.150
    15.621   219.473     0.150
    15.931   222.473     0.150
    18.140   252.473     0.150
    18.732   256.172     0.150
    19.776   271.473     0.150
    20.782   279.473     0.150
    21.448   284.473     0.150
    21.331   288.473     0.150
    21.964   292.672     0.150
    22.584   299.473     0.150
    22.729   300.473     0.150
    24.293   316.072     0.150
    24.662   319.473     0.150
    24.914   323.473     0.150
    26.225   334.373     0.150
    26.510   334.473     0.150
    26.559   336.072     0.150
    27.192   341.473     0.150
    27.323   343.473     0.150
    27.655   347.473     0.150
    27.767   348.473     0.150
    28.612   354.973     0.150
    28.612   544.473     0.150
    28.659   356.973     0.150
    28.698   357.473     0.150
    28.943   354.473     0.150
    29.067   358.373     0.150
    29.339   359.473     0.150
    29.571   364.473     0.150
    29.571   547.473     0.150
    30.079   368.773     0.150
    30.079     9.699     0.150
    30.091   370.473     0.150
    30.582   373.172     0.150
    31.775   383.672     0.150
    32.128   387.273     0.150
    32.128   706.473     0.150
    32.667   388.473     0.150
    32.870   393.473     0.150
    33.334   392.473     0.150
    33.675   400.473     0.150
    35.993   421.072     0.150
    35.993   763.473     0.150
    37.104   425.473     0.150
    37.028   429.572     0.150
    37.825   435.873     0.150
    37.834   436.273     0.150
    37.834   796.473     0.150
    38.055   435.473     0.150
    38.365   437.473     0.150
    38.786   441.473     0.150
    38.825   445.572     0.150
    39.726   450.473     0.150
    40.606   457.973     0.150
    41.238   464.473     0.150
    42.047   470.172     0.150
    42.771   475.473     0.150
    42.771    10.000     0.150
    44.041   485.473     0.150
    45.927   497.473     0.150
    46.797   507.473     0.150
    48.240   518.273     0.150
    48.671   522.672     0.150
    48.834   523.473     0.150
    50.077   532.172     0.150
    51.607   545.473     0.150
    52.279   547.473     0.150
    52.331   547.473     0.150
    52.359   550.672     0.150
    54.126   561.873     0.150
    54.474   564.973     0.150
    57.046   581.373     0.150
    58.030   589.672     0.150
    58.146   589.273     0.150
    60.304   605.473     0.150
    60.304    11.000     0.150
    61.565   615.072     0.150
    61.586   613.773     0.150
    61.975   617.672     0.150
    62.354   620.473     0.150
    63.684   626.473     0.150
    63.604   628.473     0.150
    69.825   691.473     0.150
    72.190   682.473     0.150
    72.531   685.473     0.150
    72.531    10.000     0.150
    72.484   685.473     0.150
    72.484    13.000     0.150
    72.965   686.473     0.150
    73.111   687.473     0.150
    73.410   689.473     0.150
    76.974   708.473     0.150
    78.410   717.973     0.150
    78.410  1308.473     0.150
    80.998   733.473     0.150
    81.158   731.473     0.150
    81.280   731.973     0.150
    84.285   747.473     0.150
    84.407   749.473     0.150
    84.430   750.973     0.150
     0.740    14.178     0.150
     2.860    43.777     0.150
     4.307    63.477     0.150
     4.296    63.377     0.150
     4.827    71.277     0.150
     6.633    95.777     0.150
     7.662   109.078     0.150
     7.767   110.277     0.150
     7.846   111.178     0.150
     7.824   110.977     0.150
     8.548   119.777     0.150
     8.638   120.777     0.150
    15.347   216.777     0.150
    15.461   218.777     0.150
    15.686   217.777     0.150
    15.686   390.777     0.150
    18.887   260.777     0.150
    19.270   263.377     0.150
    19.475   268.777     0.150
    20.097   273.777     0.150
    20.383   276.777     0.150
    20.836   282.078     0.150
    20.836   516.777     0.150
    21.760   291.277     0.150
    22.079   292.777     0.150
    22.084   293.777     0.150
    22.336   298.178     0.150
    22.545   300.678     0.150
    23.942   313.678     0.150
    23.942   533.777     0.150
    24.152   317.578     0.150
    24.399   317.777     0.150
    24.442   318.777     0.150
    25.620   330.078     0.150
    25.843   331.777     0.150
    26.173   334.377     0.150
    26.931   339.777     0.150
    27.048   339.777     0.150
    27.137   342.277     0.150
    27.313   345.178     0.150
    28.019   351.678     0.150
    28.079   352.477     0.150
    28.325   354.277     0.150
    28.325   544.777     0.150
    28.430   355.977     0.150
    28.583   356.477     0.150
    29.028   361.377     0.150
    29.028    10.400     0.150
    29.028   546.777     0.150
    29.448   361.777     0.150
    29.451   365.578     0.150
    30.089   369.777     0.150
    31.337   379.977     0.150
    31.337     8.801     0.150
    31.337   552.777     0.150
    31.679   384.178     0.150
    32.241   387.777     0.150
    32.241   707.777     0.150
    32.327   390.477     0.150
    32.327     8.301     0.150
    32.327   555.777     0.150
    33.154   397.277     0.150
    33.348   396.377     0.150
    34.116   401.777     0.150
    34.343   407.277     0.150
    34.343   732.777     0.150
    35.446   417.477     0.150
    37.263   432.277     0.150
    37.263     9.500     0.150
    37.263   569.777     0.150
    37.352   432.377     0.150
    37.352   569.777     0.150
    37.800   432.777     0.150
    38.405   438.777     0.150
    38.928   442.777     0.150
    39.077   444.877     0.150
    40.231   454.777     0.150
    40.308   456.477     0.150
    40.795   460.277     0.150
    40.795   580.777     0.150
    41.199   462.777     0.150
    41.656   468.477     0.150
    42.254   472.277     0.150
    42.771   475.777     0.150
    43.280   479.277     0.150
    43.514   482.678     0.150
    43.514    10.100     0.150
    44.255   487.777     0.150
    45.887   501.178     0.150
    45.887  1113.777     0.150
    46.198   502.777     0.150
    46.637   505.277     0.150
    47.188   510.578     0.150
    47.346   512.178     0.150
    47.464   512.777     0.150
    48.009   517.578     0.150
    48.481   519.777     0.150
    48.457   520.477     0.150
    49.159   525.277     0.150
    49.811   530.578     0.150
    49.935   531.578     0.150
    50.059   532.277     0.150
    49.980   532.277     0.150
    52.216   550.477     0.150
    53.025   554.777     0.150
    53.025    10.000     0.150
    53.025   622.777     0.150
    53.128   555.578     0.150
    53.128    10.199     0.150
    53.315   556.578     0.150
    53.793   561.777     0.150
    54.406   564.977     0.150
    54.873   567.777     0.150
    55.250   571.777     0.150
    55.486   572.477     0.150
    55.486     9.301     0.150
    55.486   631.777     0.150
    55.607   572.777     0.150
    56.831   585.777     0.150
    57.806   588.477     0.150
    57.806     5.301     0.150
    57.806    10.301     0.150
    57.806  2378.777     0.150
    58.640   594.277     0.150
    58.640    10.500     0.150
    58.640   644.777     0.150
    58.794   595.877     0.150
    58.794     9.900     0.150
    58.794   645.777     0.150
    58.891   596.178     0.150
    61.016   610.877     0.150
    61.016     9.900     0.150
    61.016  2371.777     0.150
    62.199   618.578     0.150
    62.199    10.199     0.150
    62.199   658.777     0.150
    62.269   620.678     0.150
    62.269    10.100     0.150
    62.269  2369.777     0.150
    62.342   620.377     0.150
    62.342     9.400     0.150
    62.342  1124.777     0.150
    62.342  1144.777     0.150
    62.342  1380.777     0.150
    62.709   621.678     0.150
    63.125   625.777     0.150
    63.239   625.777     0.150
    63.139   626.277     0.150
    63.139    10.500     0.150
    64.657   634.877     0.150
    65.807   642.877     0.150
    65.807     9.900     0.150
    65.807   673.777     0.150
    70.504   672.977     0.150
    70.504     9.801     0.150
    70.504   691.777     0.150
    70.702   673.777     0.150
    70.702    10.000     0.150
    70.839   674.578     0.150
    70.839     9.199     0.150
    70.985   676.078     0.150
    70.985     9.699     0.150
    71.352   677.777     0.150
    71.352    10.000     0.150
    71.352   700.777     0.150
    71.424   677.977     0.150
    71.664   679.277     0.150
    71.713   680.178     0.150
    72.249   684.078     0.150
    72.249     9.699     0.150
    72.290   683.578     0.150
    72.305   683.178     0.150
    72.617   685.678     0.150
    72.617    10.100     0.150
    72.617   703.777     0.150
    72.617   853.777     0.150
    72.886   687.777     0.150
    72.973   688.777     0.150
    73.049   689.078     0.150
    73.099   688.777     0.150
    73.269   689.078     0.150
    73.269     9.699     0.150
    73.465   690.777     0.150
    73.465    10.000     0.150
    73.620   691.477     0.150
    73.761   691.777     0.150
    73.761    10.000     0.150
    73.763   692.477     0.150
    74.155   693.777     0.150
    75.884   704.777     0.150
    77.043   712.777     0.150
    77.608   715.777     0.150
    78.049   717.777     0.150
    78.184   717.977     0.150
    78.163   717.277     0.150
    78.609   719.777     0.150
    78.814   721.777     0.150
    78.679   720.777     0.150
    79.031   720.477     0.150
    79.222   723.777     0.150
    79.736   725.777     0.150
    80.415   730.777     0.150
    81.184   733.777     0.150
    81.027   730.877     0.150
    81.460   734.777     0.150
    81.752   737.777     0.150
    81.805   737.777     0.150
    81.866   737.277     0.150
    81.937   736.877     0.150
    82.127   738.777     0.150
    82.293   739.777     0.150
    82.444   740.178     0.150
    83.273   744.678     0.150
    83.273    10.100     0.150
    83.650   746.777     0.150
    83.704   748.777     0.150
    83.672   746.777     0.150
    84.155   748.777     0.150
    84.490   749.777     0.150
    84.490   941.777     0.150
    84.492   751.777     0.150
    84.599     9.100     0.150
    84.599  1398.777     0.150
    85.032   752.877     0.150
    84.988   754.578     0.150
    84.988    10.199     0.150
    84.988  1384.777     0.150
    84.988  1401.777     0.150
    85.217   756.777     0.150
    85.315   755.777     0.150
    86.476   761.477     0.150
    86.967   763.178     0.150
    87.216   763.777     0.150
    87.425   765.777     0.150
    88.886   773.777     0.150
    92.613   790.777     0.150
    93.017   791.777     0.150
    93.972   794.777     0.150
    94.761   798.977     0.150
    94.761     9.801     0.150
    95.536   802.277     0.150
    97.728   813.977     0.150
    98.312   815.277     0.150
    98.658   816.178     0.150
    99.716   820.777     0.150
   100.134   822.777     0.150
   100.134  1070.777     0.150
   117.770  1123.377     0.150
   124.954  1138.678     0.150
   133.102  1153.578     0.150
   137.083  1159.777     0.150
   142.749  1166.777     0.150
   144.138  1172.678     0.150
   148.330  1184.377     0.150
     0.598    13.477     0.150
     3.631    53.477     0.150
     3.905    57.076     0.150
     3.842    55.877     0.150
     4.036    58.377     0.150
     4.036   101.576     0.150
     4.752    68.977     0.150
     5.326    76.676     0.150
     6.180    88.275     0.150
     6.480    92.977     0.150
     6.753    94.877     0.150
     7.023    98.576     0.150
     7.155   100.877     0.150
     7.245   101.576     0.150
     7.257   101.576     0.150
     7.378   103.076     0.150
     7.942   111.576     0.150
     8.197   116.477     0.150
     9.224   128.275     0.150
     9.712   134.076     0.150
    10.212   141.477     0.150
    13.278   187.176     0.150
    14.759   202.275     0.150
    14.759   358.275     0.150
    14.961   207.076     0.150
    14.961   380.576     0.150
    16.456   228.176     0.150
    16.719   230.576     0.150
    19.141   256.576     0.150
    19.488   261.275     0.150
    20.125   269.576     0.150
    21.595   285.576     0.150
    21.794   285.576     0.150
    21.794   986.576     0.150
    22.109   291.775     0.150
    22.802   297.176     0.150
    23.402   303.576     0.150
    23.401   304.076     0.150
    23.544   305.176     0.150
    25.469   324.176     0.150
    25.469   532.576     0.150
    25.498   322.576     0.150
    25.702   325.076     0.150
    26.934   336.775     0.150
    26.934   534.576     0.150
    27.376   339.176     0.150
    28.077   345.576     0.150
    28.014   343.576     0.150
    28.631   352.275     0.150
    28.631    18.301     0.150
    29.337   358.076     0.150
    29.395   358.877     0.150
    29.395    16.699     0.150
    29.395   541.576     0.150
    29.395   756.576     0.150
    29.729   356.576     0.150
    29.901   362.775     0.150
    30.286   365.676     0.150
    30.323   366.576     0.150
    30.509   368.775     0.150
    30.509   543.576     0.150
    30.769   371.877     0.150
    30.769   545.576     0.150
    31.220   374.775     0.150
    32.057   382.076     0.150
    32.333   384.676     0.150
    32.333   549.477     0.150
    32.901   384.576     0.150
    32.926   389.576     0.150
    32.926   994.775     0.150
    35.562   412.275     0.150
    36.493   415.576     0.150
    38.099   432.576     0.150
    38.566   437.775     0.150
    38.990   438.676     0.150
    38.990   792.076     0.150
    42.087   462.477     0.150
    42.886   471.275     0.150
    42.886   581.576     0.150
    43.425   475.775     0.150
    43.425   582.377     0.150
    43.999   483.775     0.150
    44.113   480.877     0.150
    44.113   584.377     0.150
    44.113   816.877     0.150
    44.760   485.877     0.150
    45.336   488.576     0.150
    47.215   503.576     0.150
    47.004   503.576     0.150
    47.139   505.076     0.150
    48.003   510.576     0.150
    48.003   598.377     0.150
    48.178   512.176     0.150
    48.649   515.977     0.150
    48.649   601.076     0.150
    48.750   518.076     0.150
    48.759   516.775     0.150
    48.759   601.377     0.150
    48.759   941.576     0.150
    48.901   518.076     0.150
    48.901   601.977     0.150
    49.078   519.676     0.150
    49.078   602.176     0.150
    49.509   523.176     0.150
    51.427   537.076     0.150
    51.970   542.076     0.150
    52.147   542.275     0.150
    52.385   543.576     0.150
    52.386   543.977     0.150
    52.386   613.576     0.150
    52.386   658.576     0.150
    52.295   547.576     0.150
    53.204   550.076     0.150
    54.225   556.676     0.150
    54.485   559.576     0.150
    54.781   561.775     0.150
    54.781   622.576     0.150
    54.968   563.576     0.150
    55.067   563.275     0.150
    55.438   567.377     0.150
    57.965   584.576     0.150
    57.965   635.576     0.150
    58.253   585.775     0.150
    58.120   586.877     0.150
    58.908   590.576     0.150
    58.908  1071.576     0.150
    59.417   592.676     0.150
    60.611   602.576     0.150
    60.708   603.076     0.150
    61.607   606.576     0.150
    61.661   609.576     0.150
    61.661  1101.576     0.150
    61.764   610.775     0.150
    62.108   612.576     0.150
    62.193   612.576     0.150
    62.382   615.076     0.150
    63.194   619.576     0.150
    63.316   621.576     0.150
    63.399   621.576     0.150
    63.795   624.576     0.150
    64.342   627.576     0.150
    64.397   628.775     0.150
    64.397    19.201     0.150
    65.930   638.775     0.150
    66.198   639.977     0.150
    66.802   642.775     0.150
    66.802  1169.576     0.150
    70.070   664.576     0.150
    70.322   664.176     0.150
    70.585   666.576     0.150
    70.592   667.576     0.150
    70.592  1218.576     0.150
    70.829   669.676     0.150
    70.857   669.576     0.150
    70.857  1220.576     0.150
    71.115   670.576     0.150
    71.350   671.977     0.150
    71.412   672.576     0.150
    71.665   674.176     0.150
    71.758   674.576     0.150
    71.725   674.877     0.150
    71.755   675.076     0.150
    71.763   675.275     0.150
    72.447   679.176     0.150
    72.482   679.775     0.150
    72.531   679.977     0.150
    72.531    18.600     0.150
    72.592   679.877     0.150
    72.601   679.775     0.150
    72.654   679.576     0.150
    72.654   694.775     0.150
    72.875   680.977     0.150
    73.102   682.377     0.150
    73.024   682.477     0.150
    73.027   682.477     0.150
    73.253   683.877     0.150
    73.279   683.576     0.150
    73.263   683.775     0.150
    73.240   683.877     0.150
    73.274   683.775     0.150
    73.403   684.775     0.150
    73.514   684.576     0.150
    73.514   696.576     0.150
    73.548   685.377     0.150
    73.590   685.377     0.150
    73.569   685.775     0.150
    73.596   684.576     0.150
    73.616   684.576     0.150
    73.743   685.377     0.150
    73.886   687.477     0.150
    73.958   687.775     0.150
    74.184   686.576     0.150
    74.191   688.576     0.150
    74.358   690.076     0.150
    74.700   690.576     0.150
    75.195   693.076     0.150
    75.474   696.877     0.150
    75.617   698.176     0.150
    75.617   866.775     0.150
    75.674   696.775     0.150
    75.805   697.576     0.150
    75.774   698.977     0.150
    75.730   698.676     0.150
    75.944   698.275     0.150
    76.081   700.576     0.150
    76.562   702.576     0.150
    76.875   703.576     0.150
    77.074   705.576     0.150
    77.266   706.576     0.150
    77.283   708.076     0.150
    77.418   707.576     0.150
    77.344   707.775     0.150
    77.483   708.576     0.150
    77.600   708.576     0.150
    77.793   707.576     0.150
    78.603   713.076     0.150
    78.985   717.576     0.150
    78.932   715.576     0.150
    78.982   716.576     0.150
    78.994   717.176     0.150
    79.248   717.076     0.150
    79.248  1631.576     0.150
    79.487   719.576     0.150
    80.138   722.076     0.150
    80.219   720.576     0.150
    80.017   723.576     0.150
    80.329   723.977     0.150
    80.586   724.676     0.150
    80.620   723.576     0.150
    80.413   723.576     0.150
    80.659   724.076     0.150
    80.712   723.576     0.150
    80.703   724.576     0.150
    80.884   727.076     0.150
    80.742   727.576     0.150
    81.076   726.775     0.150
    81.076  1329.076     0.150
    80.882   729.576     0.150
    81.324   727.576     0.150
    81.324    25.000     0.150
    81.335   729.176     0.150
    81.530   731.576     0.150
    81.794   729.576     0.150
    81.609   731.576     0.150
    81.870   730.576     0.150
    82.047   730.977     0.150
    82.379   733.775     0.150
    82.425   734.576     0.150
    82.610   733.576     0.150
    82.672   734.576     0.150
    82.732   736.576     0.150
    82.957   736.576     0.150
    83.759   741.076     0.150
    83.889   741.775     0.150
    84.050   743.576     0.150
    84.124   742.576     0.150
    84.179   743.076     0.150
    84.198   742.076     0.150
    84.510   745.576     0.150
    84.594   742.576     0.150
    84.855   747.076     0.150
    84.855   942.576     0.150
    86.767   755.576     0.150
    89.901   770.576     0.150
    92.237   781.576     0.150
    92.504   782.576     0.150
    93.346   786.775     0.150
    93.460   786.576     0.150
    94.256   791.076     0.150
    96.340   801.076     0.150
    97.355   803.576     0.150
    97.834   806.076     0.150
    99.577   815.076     0.150
   100.963   820.076     0.150
   101.240   823.576     0.150
   101.811  1085.477     0.150
   117.265  1116.377     0.150
   122.718  1129.678     0.150
   135.735  1152.178     0.150
   136.348  1150.576     0.150
   136.348  1313.576     0.150
   137.745  1155.576     0.150
   138.528  1324.576     0.150
   138.702  1150.576     0.150
   138.702  1327.576     0.150
   142.008  1158.576     0.150
   142.008  1346.576     0.150
   142.729  1160.576     0.150
   142.729  1351.576     0.150
   143.775  1164.178     0.150
   147.600  1173.076     0.150
   147.600  1175.775     0.150
   147.917  1176.678     0.150
   147.985  1168.877     0.150
   150.958  1177.975     0.150
     0.716    13.852     0.150
     1.253    22.250     0.150
     1.392    22.852     0.150
     1.594    27.250     0.150
     2.139    34.750     0.150
     2.339    35.352     0.150
     2.338    36.352     0.150
     2.498    38.750     0.150
     2.766    41.652     0.150
     2.746    43.551     0.150
     2.877    45.652     0.150
     3.029    47.352     0.150
     3.214    49.152     0.150
     3.366    50.152     0.150
     3.932    59.453     0.150
     4.435    66.551     0.150
     5.413    78.551     0.150
     8.749   124.352     0.150
     8.860   125.852     0.150
     9.502   134.453     0.150
    10.051   141.152     0.150
    10.685   151.551     0.150
    14.681   205.352     0.150
    15.973   230.352     0.150
    16.512   229.352     0.150
    19.961   272.750     0.150
    20.023   272.852     0.150
    20.993   285.352     0.150
    22.614   301.051     0.150
    22.950   305.352     0.150
    23.222   306.453     0.150
    23.722   313.051     0.150
    23.841   315.152     0.150
    25.208   327.152     0.150
    25.538   329.750     0.150
    25.851   332.652     0.150
    26.791   341.453     0.150
    26.791     6.000     0.150
    27.454   350.352     0.150
    27.695   345.051     0.150
    27.571   348.750     0.150
    27.863   346.852     0.150
    28.127   352.352     0.150
    28.239   352.352     0.150
    28.211   354.352     0.150
    28.274   354.852     0.150
    28.897   360.953     0.150
    29.225   358.652     0.150
    29.043   361.551     0.150
    29.380   364.551     0.150
    29.991   370.051     0.150
    29.991     6.699     0.150
    30.511   374.051     0.150
    30.511     7.402     0.150
    30.532   375.051     0.150
    30.554   373.352     0.150
    31.103   380.652     0.150
    32.139   388.352     0.150
    34.492   405.152     0.150
    34.446   406.453     0.150
    34.934   413.551     0.150
    37.571   435.352     0.150
    38.044   435.352     0.150
    37.806   437.352     0.150
    37.806   799.352     0.150
    38.152   439.352     0.150
    38.152     9.000     0.150
    39.742   450.152     0.150
    39.568   451.352     0.150
    41.723   468.352     0.150
    42.047   470.750     0.150
    43.157   481.051     0.150
    43.835   484.453     0.150
    44.517   491.652     0.150
    44.898   494.852     0.150
    46.389   503.953     0.150
    46.732   506.551     0.150
    46.960   508.352     0.150
    49.162   526.250     0.150
    49.308   526.953     0.150
    49.468   529.652     0.150
    50.017   533.652     0.150
    50.901   541.953     0.150
    51.598   546.051     0.150
    51.873   547.152     0.150
    54.048   563.051     0.150
    54.632   566.750     0.150
    55.866   575.852     0.150
    55.866     7.000     0.150
    56.165   577.352     0.150
    56.390   580.352     0.150
    56.449   580.551     0.150
    56.443   580.551     0.150
    56.443     6.699     0.150
    59.630   603.352     0.150
    59.630     6.801     0.150
    59.889   604.051     0.150
    60.087   604.352     0.150
    60.469   608.352     0.150
    60.469  1106.352     0.150
    63.206   626.652     0.150
    63.315   627.750     0.150
    63.337   628.250     0.150
    63.729   630.551     0.150
    63.729     6.602     0.150
    63.886   631.352     0.150
    64.639   635.352     0.150
    64.833   636.352     0.150
    65.790   644.750     0.150
    68.495   661.352     0.150
    68.597   662.352     0.150
    69.981   671.352     0.150
    71.902   682.352     0.150
    71.902    12.000     0.150
    72.137   683.352     0.150
    72.416   685.750     0.150
    72.425   685.852     0.150
    73.342   690.352     0.150
    73.344   691.051     0.150
    73.632   692.352     0.150
    74.111   695.852     0.150
    74.111     7.500     0.150
    74.111   708.352     0.150
    74.392   697.652     0.150
    74.744   699.352     0.150
    74.890   700.453     0.150
    75.039   701.051     0.150
    75.152   702.352     0.150
    75.129   701.652     0.150
    75.218   702.352     0.150
    75.218    10.000     0.150
    75.218   718.352     0.150
    75.321   702.352     0.150
    75.348   702.352     0.150
    75.348   702.852     0.150
    75.349   702.852     0.150
    75.429   703.250     0.150
    75.562   704.551     0.150
    75.931   705.652     0.150
    76.316   706.352     0.150
    76.477   709.750     0.150
    76.806   711.453     0.150
    78.003   718.352     0.150
    78.502   720.352     0.150
    79.028   723.352     0.150
    79.184   724.352     0.150
    81.193   735.352     0.150
    81.769   737.852     0.150
    81.769     6.898     0.150
    81.924   738.352     0.150
    82.137   739.953     0.150
    82.472   740.852     0.150
    82.463   741.551     0.150
    82.513   742.453     0.150
    82.598   742.352     0.150
    82.598     7.000     0.150
    83.450   746.551     0.150
    83.624   748.551     0.150
    85.240   754.352     0.150
    86.062   760.352     0.150
    86.726   762.352     0.150
   119.445  1123.352     0.150
   145.269  1176.352     0.150
   146.322  1178.453     0.150
   149.275  1187.352     0.150
   152.205  1193.250     0.150
   153.448  1196.352     0.150
   155.453  1185.352     0.150
     0.683    13.145     0.150
     1.223    21.445     0.150
     1.364    22.043     0.150
     1.381    23.543     0.150
     1.561    26.543     0.150
     2.311    35.746     0.150
     2.479    40.043     0.150
     2.475    37.945     0.150
     2.714    43.145     0.150
     2.750    41.145     0.150
     2.845    45.445     0.150
     3.001    46.746     0.150
     3.182    48.945     0.150
     4.425    65.645     0.150
     4.848    71.945     0.150
     5.387    78.145     0.150
     5.734    84.145     0.150
     5.973    87.344     0.150
     6.491    94.645     0.150
     6.644    96.445     0.150
     7.398   108.145     0.150
     7.455   107.844     0.150
     7.770   114.145     0.150
     7.889   113.645     0.150
     8.015   116.344     0.150
     8.259   117.645     0.150
     8.357   119.145     0.150
     8.607   122.145     0.150
     8.722   124.145     0.150
     8.764   125.145     0.150
     8.833   125.645     0.150
     8.860   126.543     0.150
     9.585   136.844     0.150
     9.508   133.344     0.150
    10.047   140.445     0.150
    10.193   145.645     0.150
    10.659   150.344     0.150
    10.909   154.145     0.150
    11.359   161.145     0.150
    14.660   207.145     0.150
    15.991   224.645     0.150
    16.145   229.145     0.150
    16.480   233.145     0.150
    16.480   425.145     0.150
    19.955   272.645     0.150
    20.016   273.145     0.150
    20.293   279.543     0.150
    20.725   284.145     0.150
    21.008   284.145     0.150
    22.621   300.645     0.150
    22.965   305.145     0.150
    23.197   306.543     0.150
    23.677   312.844     0.150
    24.352   319.344     0.150
    25.193   325.844     0.150
    25.232   327.145     0.150
    25.553   329.246     0.150
    25.875   332.645     0.150
    27.667   345.445     0.150
    28.062   352.145     0.150
    28.129   351.145     0.150
    28.218   352.145     0.150
    28.299   354.945     0.150
    29.199   359.145     0.150
    29.066   361.145     0.150
    29.401   364.945     0.150
    29.809   368.145     0.150
    30.002   369.145     0.150
    30.527   373.844     0.150
    30.552   374.945     0.150
    32.164   388.145     0.150
    34.419   405.645     0.150
    34.460   406.145     0.150
    34.937   413.145     0.150
    34.958   413.145     0.150
    37.594   435.844     0.150
    37.832   434.145     0.150
    37.826   437.145     0.150
    37.826   799.645     0.150
    38.155   439.145     0.150
    39.554   452.145     0.150
    40.505   459.344     0.150
    41.744   469.746     0.150
    41.744     6.500     0.150
    42.015   471.145     0.150
    42.420   476.043     0.150
    42.931   479.043     0.150
    42.931     7.602     0.150
    43.170   480.145     0.150
    43.808   484.145     0.150
    44.487   491.645     0.150
    44.407   489.344     0.150
    45.404   498.145     0.150
    46.361   504.145     0.150
    46.703   505.746     0.150
    46.927   508.645     0.150
    54.018   563.445     0.150
    54.602   566.246     0.150
    55.836   576.043     0.150
    56.419   579.543     0.150
    56.412   579.945     0.150
    56.412     6.801     0.150
    59.600   603.344     0.150
    59.600     6.602     0.150
    59.600  1096.145     0.150
    59.860   604.145     0.150
    60.054   604.543     0.150
    60.054  1098.145     0.150
    60.437   607.945     0.150
    60.437  1105.145     0.150
    62.263   620.445     0.150
    63.177   626.543     0.150
    63.284   627.746     0.150
    63.309   628.645     0.150
    63.699   629.246     0.150
    64.632   636.344     0.150
    64.801   637.145     0.150
    64.832   638.145     0.150
    65.334   637.145     0.150
    65.765   644.344     0.150
    66.864   650.645     0.150
    68.463   661.145     0.150
    68.572   662.844     0.150
    69.956   671.645     0.150
    70.518   675.145     0.150
    70.518    10.000     0.150
    71.873   682.145     0.150
    72.073   684.445     0.150
    72.105   683.145     0.150
    72.387   685.645     0.150
    72.397   685.645     0.150
    72.834   688.543     0.150
    73.310   690.145     0.150
    73.316   691.145     0.150
    73.602   693.145     0.150
    74.083   696.145     0.150
    74.133   696.145     0.150
    74.685   699.645     0.150
    74.718   699.645     0.150
    74.864   700.543     0.150
    75.013   701.246     0.150
    75.103   701.645     0.150
    75.322   702.844     0.150
    75.324   703.043     0.150
    75.403   703.445     0.150
    75.536   704.543     0.150
    75.899   706.945     0.150
    76.452   709.746     0.150
    76.780   711.344     0.150
    79.152   723.145     0.150
    81.160   734.145     0.150
    81.739   737.445     0.150
    81.892   738.145     0.150
    82.105   739.645     0.150
    82.441   740.344     0.150
    82.996   745.145     0.150
    83.591   749.145     0.150
    86.151   759.645     0.150
   145.243  1176.145     0.150
   146.353  1178.246     0.150
   149.244  1187.945     0.150
     0.743    14.324     0.150
     1.254    22.224     0.150
     1.444    23.324     0.150
     1.609    27.724     0.150
     2.392    36.924     0.150
     2.557    39.224     0.150
     2.527    40.824     0.150
     2.829    42.124     0.150
     3.022    47.624     0.150
     3.189    50.424     0.150
     3.429    50.424     0.150
     4.498    65.624     0.150
     4.902    72.924     0.150
     4.998    74.024     0.150
     5.342    78.924     0.150
     5.396    78.824     0.150
     6.486    95.024     0.150
     6.694    97.624     0.150
     8.418   121.924     0.150
     8.737   123.824     0.150
     9.440   133.824     0.150
     9.622   137.824     0.150
    10.261   147.324     0.150
    10.670   152.324     0.150
    14.653   205.824     0.150
    16.073   231.824     0.150
    16.551   233.424     0.150
    16.551   414.824     0.150
    19.910   273.224     0.150
    20.930   283.824     0.150
    22.552   300.924     0.150
    23.204   306.324     0.150
    24.271   318.824     0.150
    25.120   324.924     0.150
    25.151   326.324     0.150
    25.476   329.124     0.150
    25.793   331.824     0.150
    27.747   345.624     0.150
    27.980   352.024     0.150
    28.212   351.824     0.150
    28.217   353.824     0.150
    28.834   360.524     0.150
    29.320   363.924     0.150
    29.727   367.624     0.150
    29.928   369.624     0.150
    30.449   373.724     0.150
    30.471   374.324     0.150
    34.434   406.224     0.150
    34.529   405.824     0.150
    37.745   436.624     0.150
    38.092   438.824     0.150
    42.057   471.024     0.150
    42.854   478.824     0.150
    42.854     4.300     0.150
    43.094   480.224     0.150
    43.823   484.524     0.150
    44.836   494.324     0.150
    46.780   506.624     0.150
    54.051   563.524     0.150
    55.865   575.724     0.150
    56.497   581.324     0.150
    56.445   580.424     0.150
    56.445     5.400     0.150
    59.633   603.524     0.150
    59.888   604.224     0.150
    63.200   627.024     0.150
    63.316   628.224     0.150
    63.316     5.000     0.150
    63.909   631.324     0.150
    64.661   636.324     0.150
    65.773   644.924     0.150
    68.504   661.324     0.150
    69.964   671.824     0.150
    71.894   682.824     0.150
    72.408   685.524     0.150
    72.416   685.824     0.150
    73.379   690.824     0.150
    73.629   691.824     0.150
    74.104   695.824     0.150
    74.279   695.824     0.150
    74.378   697.324     0.150
    74.691   699.424     0.150
    74.729   699.624     0.150
    74.874   700.424     0.150
    75.113   700.824     0.150
    75.333   702.124     0.150
    75.412   703.224     0.150
    81.766   738.224     0.150
    82.511   740.224     0.150
    87.392   766.824     0.150
     0.767    15.016     0.150
     1.121    20.615     0.150
     1.432    23.615     0.150
     1.608    27.516     0.150
     1.583    27.715     0.150
     1.846    29.715     0.150
     2.439    38.516     0.150
     2.450    40.215     0.150
     2.797    43.416     0.150
     2.682    43.314     0.150
     2.762    44.715     0.150
     2.792    45.615     0.150
     2.871    46.416     0.150
     2.987    46.916     0.150
     3.301    51.416     0.150
     4.843    72.516     0.150
     4.995    74.215     0.150
     5.301    76.416     0.150
     5.952    88.416     0.150
     6.573    95.615     0.150
     8.316   118.115     0.150
     8.316   118.615     0.150
     8.797   126.715     0.150
     9.366   136.416     0.150
    10.348   149.814     0.150
    14.103   199.115     0.150
    15.498   219.615     0.150
    15.385   217.115     0.150
    16.669   232.314     0.150
    18.682   259.115     0.150
    19.241   274.115     0.150
    19.302   266.115     0.150
    20.370   278.215     0.150
    21.413   289.115     0.150
    21.916   294.215     0.150
    22.326   299.215     0.150
    22.720   301.516     0.150
    23.078   308.115     0.150
    23.184   308.814     0.150
    23.204   308.814     0.150
    23.445   310.916     0.150
    24.504   320.115     0.150
    24.757   323.715     0.150
    24.757   754.115     0.150
    25.211   328.115     0.150
    25.905   333.314     0.150
    26.137   335.215     0.150
    26.166   336.016     0.150
    26.347   337.416     0.150
    27.038   344.516     0.150
    27.038   627.115     0.150
    27.403   348.115     0.150
    27.526   348.314     0.150
    28.055   349.215     0.150
    28.055   633.416     0.150
    27.747   350.215     0.150
    27.832   351.416     0.150
    27.832   765.115     0.150
    28.437   352.615     0.150
    28.437   637.115     0.150
    28.864   360.416     0.150
    29.642   364.314     0.150
    29.642   660.115     0.150
    29.642   550.115     0.150
    29.828   369.416     0.150
    29.977   370.115     0.150
    30.970   671.115     0.150
    30.911   378.615     0.150
    31.360   382.115     0.150
    31.978   387.115     0.150
    31.978   699.115     0.150
    34.000   403.115     0.150
    34.607   407.115     0.150
    34.607   734.115     0.150
    34.607   407.615     0.150
    34.607   481.115     0.150
    34.607  1031.115     0.150
    34.313   409.115     0.150
    34.360   409.115     0.150
    34.477   409.615     0.150
    37.245   433.615     0.150
    37.248   432.115     0.150
    37.248   574.115     0.150
    38.161   437.615     0.150
    38.161   787.814     0.150
    38.161   438.416     0.150
    38.161   523.416     0.150
    40.309   456.115     0.150
    40.309   823.715     0.150
    40.309   553.115     0.150
    40.728   461.615     0.150
    41.116   841.115     0.150
    41.116  1037.115     0.150
    41.644   469.016     0.150
    42.278   474.615     0.150
    42.278  1055.115     0.150
    42.512   477.615     0.150
    43.383   481.516     0.150
    43.383   869.115     0.150
    43.722   485.615     0.150
    43.920   488.314     0.150
    44.168   489.314     0.150
    44.236   490.916     0.150
    44.236   886.115     0.150
    44.697   493.314     0.150
    46.103   911.115     0.150
    46.746   508.115     0.150
    46.967   510.115     0.150
    46.967   624.115     0.150
    46.967   931.115     0.150
    47.502   516.115     0.150
    48.011   519.115     0.150
    48.744   523.115     0.150
    48.744   637.115     0.150
    48.744   939.115     0.150
    48.592   524.115     0.150
    49.133   526.814     0.150
    49.289   528.314     0.150
    49.791   532.115     0.150
    49.929   532.916     0.150
    49.929   963.115     0.150
    49.533   531.615     0.150
    50.035   534.016     0.150
    50.191   534.916     0.150
    49.890   534.715     0.150
    50.010   533.916     0.150
    50.176   536.715     0.150
    50.871   541.115     0.150
    50.872   541.715     0.150
    51.431   543.715     0.150
    51.431   661.115     0.150
    51.431   981.115     0.150
    52.611   552.115     0.150
    52.850   556.016     0.150
    53.678   561.215     0.150
    53.744   560.115     0.150
    53.744     6.000     0.150
    54.430   566.314     0.150
    54.914   569.115     0.150
    54.914  1027.115     0.150
    54.914   632.115     0.150
    54.914   691.115     0.150
    54.914  1164.115     0.150
    54.914  1251.115     0.150
    55.527   574.215     0.150
    55.527     5.801     0.150
    55.895   577.115     0.150
    55.895     4.600     0.150
    55.895  1046.115     0.150
    55.895   709.115     0.150
    55.895  1052.115     0.150
    56.137   579.115     0.150
    56.137     6.500     0.150
    56.060   580.115     0.150
    56.655   583.814     0.150
    56.741   583.516     0.150
    56.741  1046.115     0.150
    56.741   717.115     0.150
    56.741  1165.115     0.150
    58.854   598.115     0.150
    58.854  1082.115     0.150
    59.343   601.416     0.150
    59.343  1092.416     0.150
    59.329   602.115     0.150
    59.329     5.500     0.150
    59.329   727.115     0.150
    59.329  1091.115     0.150
    59.329  1191.115     0.150
    59.545   602.516     0.150
    59.545     5.900     0.150
    59.545  1091.115     0.150
    60.200   606.416     0.150
    60.200  1100.715     0.150
    60.465   610.115     0.150
    60.465  1103.115     0.150
    60.616   610.115     0.150
    60.616  1109.115     0.150
    60.802   611.715     0.150
    61.334   615.115     0.150
    61.334  1108.115     0.150
    61.387   615.416     0.150
    61.387  1118.516     0.150
    61.725   618.016     0.150
    62.497   623.615     0.150
    62.497  1128.115     0.150
    62.497  1148.615     0.150
    62.434   622.234     0.150
    62.448   622.615     0.150
    62.800   624.545     0.150
    62.817   624.814     0.150
    63.073   626.916     0.150
    63.073  1139.916     0.150
    62.923   626.215     0.150
    62.994   626.615     0.150
    62.994     5.500     0.150
    62.994   759.115     0.150
    62.994  1135.115     0.150
    63.227   628.115     0.150
    63.227   763.115     0.150
    63.227  1141.115     0.150
    63.227  1215.115     0.150
    63.227  1399.115     0.150
    63.364   628.416     0.150
    63.364     5.799     0.150
    63.364  1140.115     0.150
    63.699   630.715     0.150
    63.699  1146.115     0.150
    63.823   632.115     0.150
    63.823  1147.115     0.150
    63.823   771.814     0.150
    63.823  1227.115     0.150
    63.773   632.115     0.150
    63.773     6.000     0.150
    63.773  1147.115     0.150
    63.773  1163.115     0.150
    63.773  1168.115     0.150
    63.773  1221.115     0.150
    64.112   633.916     0.150
    64.164   634.215     0.150
    64.360   635.615     0.150
    64.562   636.314     0.150
    64.562     5.301     0.150
    64.562  1153.615     0.150
    64.562   779.115     0.150
    64.726   638.115     0.150
    64.753   638.516     0.150
    64.956   638.516     0.150
    64.956  1155.516     0.150
    64.956  1226.715     0.150
    64.833   638.814     0.150
    64.894   639.516     0.150
    65.292   641.715     0.150
    65.299   642.115     0.150
    65.916   645.215     0.150
    66.016   647.215     0.150
    66.360   648.715     0.150
    66.998   652.314     0.150
    66.998  1187.115     0.150
    67.141   653.115     0.150
    67.141  1188.615     0.150
    67.227   653.314     0.150
    67.227   680.115     0.150
    67.227  1189.115     0.150
    67.013   652.916     0.150
    67.013  1189.115     0.150
    67.013  1457.115     0.150
    67.110   654.115     0.150
    67.110  1188.115     0.150
    67.192   654.215     0.150
    67.383   655.016     0.150
    67.740   659.115     0.150
    67.582   655.115     0.150
    67.582     6.000     0.150
    67.582  1193.115     0.150
    67.582   804.115     0.150
    67.645   655.314     0.150
    68.184   660.916     0.150
    68.184  1203.115     0.150
    68.258   659.814     0.150
    68.258  1202.115     0.150
    69.028   666.314     0.150
    69.504   667.115     0.150
    69.766   671.115     0.150
    69.766  1223.115     0.150
    70.097   672.615     0.150
    70.914   677.615     0.150
    70.914     5.199     0.150
    70.914   695.715     0.150
    70.914  1239.115     0.150
    71.146  1234.115     0.150
    71.155   678.516     0.150
    71.155   845.615     0.150
    71.174   679.215     0.150
    71.493   680.615     0.150
    71.493     6.500     0.150
    71.493  1236.115     0.150
    71.587   682.115     0.150
    71.633   681.615     0.150
    71.633  1242.115     0.150
    71.791   683.115     0.150
    71.829   683.115     0.150
    72.199   684.715     0.150
    72.199  1247.115     0.150
    72.006   684.115     0.150
    72.006     6.000     0.150
    72.006   703.115     0.150
    72.006  1247.115     0.150
    72.006  1271.115     0.150
    72.013   684.115     0.150
    72.013  1246.115     0.150
    72.064   684.416     0.150
    72.279   685.016     0.150
    72.293   685.016     0.150
    72.346   686.615     0.150
    72.346  1253.115     0.150
    72.283  1254.115     0.150
    72.305   685.814     0.150
    72.361   686.016     0.150
    72.353   686.416     0.150
    72.589   688.115     0.150
    72.589  1254.615     0.150
    72.462   688.615     0.150
    72.661   688.516     0.150
    72.854   689.115     0.150
    72.903   689.814     0.150
    72.903     5.400     0.150
    72.945   689.814     0.150
    73.271   691.215     0.150
    73.271     5.500     0.150
    73.271  1261.115     0.150
    73.464   693.314     0.150
    73.464  1259.115     0.150
    73.464   855.115     0.150
    73.537   693.516     0.150
    73.789   694.516     0.150
    73.621   693.814     0.150
    73.683   694.615     0.150
    73.683  1266.615     0.150
    73.666   694.314     0.150
    73.704   694.814     0.150
    73.704     5.801     0.150
    73.704  1265.916     0.150
    73.842   695.016     0.150
    73.842   857.115     0.150
    73.842  1265.115     0.150
    73.842  1552.115     0.150
    73.932   695.516     0.150
    74.153   695.314     0.150
    74.307   698.115     0.150
    74.307  1273.115     0.150
    74.165   697.115     0.150
    74.204   697.516     0.150
    74.266   697.516     0.150
    74.414   698.516     0.150
    74.409   698.516     0.150
    74.466   698.615     0.150
    74.561   699.115     0.150
    74.626   700.516     0.150
    74.646   699.715     0.150
    74.730   700.615     0.150
    74.809   701.115     0.150
    74.809     5.000     0.150
    74.809   701.615     0.150
    74.809     4.500     0.150
    74.809   714.115     0.150
    74.807   700.916     0.150
    74.807     6.199     0.150
    74.821   700.416     0.150
    74.827   700.115     0.150
    74.860   701.314     0.150
    74.853   700.916     0.150
    74.868   701.016     0.150
    74.937   701.314     0.150
    74.937   701.314     0.150
    75.027   702.215     0.150
    75.039   702.115     0.150
    75.073   702.115     0.150
    75.362   702.115     0.150
    75.362  1282.115     0.150
    75.405   704.115     0.150
    75.405  1287.115     0.150
    75.404   703.715     0.150
    75.435   704.916     0.150
    75.664   706.416     0.150
    75.711   706.516     0.150
    75.711   717.615     0.150
    75.781   706.416     0.150
    75.781   722.115     0.150
    75.811   707.115     0.150
    75.764   706.115     0.150
    76.044   707.516     0.150
    76.044     6.000     0.150
    76.044  1291.516     0.150
    76.054   708.615     0.150
    76.054  1295.115     0.150
    75.967   708.115     0.150
    75.973   707.516     0.150
    76.075   709.016     0.150
    76.144   708.715     0.150
    76.399   709.115     0.150
    76.399  1294.115     0.150
    76.399   880.115     0.150
    76.229   708.615     0.150
    76.543   713.115     0.150
    76.375   706.115     0.150
    76.303   709.314     0.150
    76.364   710.016     0.150
    76.573   707.115     0.150
    76.573  1296.115     0.150
    76.573   881.115     0.150
    76.573  1336.115     0.150
    76.545   710.115     0.150
    76.601   713.115     0.150
    76.601   715.115     0.150
    76.853   711.615     0.150
    76.846   711.615     0.150
    77.016   712.115     0.150
    77.253   713.314     0.150
    77.109   712.715     0.150
    77.109  1299.615     0.150
    77.509   715.115     0.150
    77.509  1305.115     0.150
    77.329   715.615     0.150
    77.510   715.615     0.150
    77.510  1309.115     0.150
    77.693   717.115     0.150
    77.735   717.016     0.150
    77.951   718.314     0.150
    78.057   720.115     0.150
    78.266   719.814     0.150
    78.189   720.115     0.150
    78.260   721.115     0.150
    78.319   720.916     0.150
    78.382   720.115     0.150
    78.379   721.516     0.150
    78.571   721.314     0.150
    78.501   720.615     0.150
    78.501  1314.615     0.150
    78.571   728.916     0.150
    78.571   895.115     0.150
    78.571  1616.115     0.150
    78.517   721.115     0.150
    78.517  1317.115     0.150
    78.533   722.115     0.150
    78.533     5.000     0.150
    78.520   722.115     0.150
    78.617   722.615     0.150
    78.617  1323.115     0.150
    78.805   722.715     0.150
    78.805  1322.115     0.150
    78.741   723.615     0.150
    78.741  1322.115     0.150
    78.990   725.215     0.150
    78.990  1320.215     0.150
    78.985   723.115     0.150
    79.119   724.416     0.150
    79.119  1323.016     0.150
    79.212   726.115     0.150
    79.212  1325.115     0.150
    79.306   725.615     0.150
    79.306  1320.016     0.150
    79.383   726.115     0.150
    79.383   904.115     0.150
    79.383  1324.115     0.150
    79.343   726.814     0.150
    79.343   737.115     0.150
    79.442   725.115     0.150
    79.442  1325.814     0.150
    79.442   725.615     0.150
    79.259   728.115     0.150
    79.552   727.115     0.150
    79.552  1327.115     0.150
    79.539   727.115     0.150
    79.539  1328.115     0.150
    79.617   727.715     0.150
    79.814   730.115     0.150
    79.814   909.115     0.150
    79.814  1335.115     0.150
    79.814  1639.115     0.150
    80.302   727.115     0.150
    80.317   731.115     0.150
    80.896   734.115     0.150
    80.896  1344.516     0.150
    80.875   733.115     0.150
    80.929   734.115     0.150
    80.929  1344.516     0.150
    80.848   734.115     0.150
    80.848   917.115     0.150
    80.848  1343.115     0.150
    81.034   735.814     0.150
    81.034   741.115     0.150
    81.034  1347.115     0.150
    81.034     5.301     0.150
    81.034  1392.115     0.150
    81.188   735.615     0.150
    81.181   736.115     0.150
    81.414   737.314     0.150
    81.550   739.115     0.150
    81.550  1355.115     0.150
    81.487   738.115     0.150
    81.711   740.115     0.150
    81.711  1354.115     0.150
    81.711   927.115     0.150
    81.794   738.115     0.150
    81.794  1351.115     0.150
    81.884   740.115     0.150
    81.952   741.115     0.150
    81.952  1354.115     0.150
    82.241   740.115     0.150
    82.241  1354.115     0.150
    82.117   740.916     0.150
    82.066   742.615     0.150
    82.066  1374.615     0.150
    82.313   741.115     0.150
    82.313  1361.115     0.150
    82.313   741.516     0.150
    82.236   741.215     0.150
    82.236  1356.516     0.150
    82.367   742.115     0.150
    82.367  1357.115     0.150
    82.367  1407.115     0.150
    82.361   741.615     0.150
    82.471   743.615     0.150
    82.471  1363.115     0.150
    82.485   744.215     0.150
    82.485   749.814     0.150
    82.730   745.115     0.150
    82.730  1367.115     0.150
    82.902   745.115     0.150
    82.902  1364.516     0.150
    82.960   746.115     0.150
    83.072   746.115     0.150
    83.671   747.814     0.150
    83.635   749.615     0.150
    83.635   940.016     0.150
    83.635  1371.516     0.150
    83.724   748.416     0.150
    84.313   753.115     0.150
    84.699   752.314     0.150
    84.699  1383.115     0.150
    84.773   753.615     0.150
    85.460   756.715     0.150
    85.460  1378.215     0.150
    85.566   758.115     0.150
    85.503   758.115     0.150
    85.503  1387.115     0.150
    85.899   760.516     0.150
    86.266   760.215     0.150
    86.364   763.615     0.150
    86.364  1400.115     0.150
    86.413   760.115     0.150
    86.964   764.115     0.150
    88.393   768.916     0.150
    91.661   791.615     0.150
    92.585   791.016     0.150
    92.585  1454.115     0.150
    92.876   791.115     0.150
    92.496   795.115     0.150
    95.137   802.115     0.150
    95.137  1031.115     0.150
    95.137  1435.115     0.150
    95.137  1555.115     0.150
    95.954   807.814     0.150
    98.199  1065.115     0.150
    98.398   817.016     0.150
    99.029   821.115     0.150
   118.424  1127.115     0.150
   124.253  1141.115     0.150
   136.826  1166.115     0.150
   136.826  1332.115     0.150
   139.989  1170.115     0.150
   143.398  1171.115     0.150
   144.195  1174.115     0.150
   146.621  1181.115     0.150
   148.962  1183.016     0.150
   149.055  1183.115     0.150
   149.355  1187.115     0.150
   149.355  1194.115     0.150
   149.408  1181.115     0.150
   149.728  1186.115     0.150
   150.140  1190.115     0.150
   150.561  1188.916     0.150
     0.575    11.961     0.150
     2.938    44.762     0.150
     3.157    47.262     0.150
     3.412    50.363     0.150
     3.818    55.664     0.150
     3.873    55.762     0.150
     4.518    65.863     0.150
     4.911    71.562     0.150
     5.119    73.664     0.150
     5.087    73.562     0.150
     5.794    84.062     0.150
     5.948    85.562     0.150
     6.205    88.961     0.150
     6.573    93.664     0.150
     6.774    96.961     0.150
     6.943    98.461     0.150
     7.067    99.562     0.150
     7.067   100.062     0.150
     7.824   112.164     0.150
     8.679   124.664     0.150
    13.218   183.562     0.150
    15.007   209.562     0.150
    19.168   258.863     0.150
    19.175   259.562     0.150
    19.175   278.562     0.150
    19.230   260.562     0.150
    19.230   278.562     0.150
    21.394   284.562     0.150
    21.596   284.664     0.150
    22.567   296.562     0.150
    23.342   304.562     0.150
    25.272   321.562     0.150
    26.175   332.062     0.150
    26.552   330.562     0.150
    26.552   330.961     0.150
    26.794   336.961     0.150
    27.358   341.863     0.150
    28.218   346.562     0.150
    28.218    14.000     0.150
    28.218    22.000     0.150
    28.218   347.363     0.150
    28.218    13.199     0.150
    28.218    21.199     0.150
    28.496   352.562     0.150
    29.260   359.262     0.150
    29.854   362.762     0.150
    30.643   372.562     0.150
    30.956   373.961     0.150
    30.956    13.602     0.150
    30.956    19.602     0.150
    32.745   386.664     0.150
    32.918   390.961     0.150
    32.918    20.000     0.150
    33.135   393.562     0.150
    33.135    13.000     0.150
    33.135    19.000     0.150
    35.878   416.562     0.150
    35.878    14.398     0.150
    35.878    20.699     0.150
    36.588   418.562     0.150
    36.588    16.102     0.150
    36.588   418.863     0.150
    36.588    15.801     0.150
    38.438   437.562     0.150
    38.438    14.301     0.150
    42.137   465.363     0.150
    43.212   475.863     0.150
    43.212    14.699     0.150
    43.424   477.664     0.150
    43.576   478.363     0.150
    45.281   490.562     0.150
    45.281    13.000     0.150
    45.423   492.562     0.150
    45.423   492.863     0.150
    45.372   493.762     0.150
    45.372    14.801     0.150
    50.132   528.262     0.150
    54.089   557.762     0.150
    54.656   561.863     0.150
    55.157   564.562     0.150
    55.157   565.062     0.150
    55.157   627.863     0.150
    57.495   582.562     0.150
    57.842   585.062     0.150
    58.115   586.562     0.150
    59.326   595.762     0.150
    59.951   599.062     0.150
    60.368   601.164     0.150
    61.531   610.762     0.150
    61.531    13.801     0.150
    62.486   616.562     0.150
    62.898   618.562     0.150
    64.144   628.363     0.150
    65.473   636.262     0.150
    66.549   644.164     0.150
    66.701   644.062     0.150
    68.840   659.062     0.150
    68.840    13.500     0.150
    70.162   665.562     0.150
    70.162    14.000     0.150
    70.672   669.562     0.150
    70.672   670.164     0.150
    70.694   670.562     0.150
    70.694    13.000     0.150
    70.741   669.562     0.150
    70.789   670.164     0.150
    70.875   670.562     0.150
    70.875    13.000     0.150
    71.599   676.062     0.150
    71.599    13.500     0.150
    71.785   675.562     0.150
    71.785   676.363     0.150
    71.863   676.562     0.150
    71.863   676.961     0.150
    72.371   681.062     0.150
    72.371   694.562     0.150
    72.418   680.762     0.150
    72.512   681.562     0.150
    72.698   681.961     0.150
    72.743   681.863     0.150
    72.926   683.664     0.150
    73.124   684.762     0.150
    73.071   684.363     0.150
    73.072   684.363     0.150
    73.220   685.363     0.150
    73.365   685.961     0.150
    73.461   686.363     0.150
    73.564   688.262     0.150
    73.564   701.762     0.150
    73.676   687.762     0.150
    73.697   687.762     0.150
    73.771   688.262     0.150
    73.901   689.262     0.150
    74.363   690.562     0.150
    74.363   690.762     0.150
    74.363   710.164     0.150
    74.836   695.062     0.150
    75.162   696.762     0.150
    77.433   707.562     0.150
    77.433   708.062     0.150
    77.626   710.562     0.150
    77.626   711.164     0.150
    79.414   720.562     0.150
    79.998   723.062     0.150
    79.998    14.500     0.150
    81.262   730.562     0.150
    81.555   731.961     0.150
    81.698   732.762     0.150
    81.786   733.164     0.150
    81.949   733.562     0.150
    83.335   740.363     0.150
    83.335   740.363     0.150
    84.322   745.562     0.150
   148.110  1178.562     0.150
     0.722    14.839     0.150
     0.784    16.399     0.150
     0.824    16.680     0.150
     1.106    20.089     0.150
     1.195    21.600     0.150
     1.195    37.890     0.150
     1.221    22.189     0.150
     1.221    39.589     0.150
     1.228    22.159     0.150
     1.228    37.909     0.150
     1.242    22.259     0.150
     1.523    25.970     0.150
     1.523    45.430     0.150
     1.641    27.430     0.150
     1.641    47.199     0.150
     1.856    30.039     0.150
     1.856    52.489     0.150
     1.968    31.279     0.150
     1.968    54.499     0.150
     2.152    33.729     0.150
     2.152    58.249     0.150
     2.246    35.989     0.150
     2.246    61.529     0.150
     2.319    36.310     0.150
     2.319    64.999     0.150
     2.511    38.640     0.150
     2.511    68.029     0.150
     2.873    45.720     0.150
     2.873    81.339     0.150
     2.909    43.039     0.150
     2.938    43.879     0.150
     2.938    76.449     0.150
     3.127    47.379     0.150
     3.139    47.239     0.150
     3.145    47.409     0.150
     3.145    84.329     0.150
     3.187    48.279     0.150
     3.216    48.869     0.150
     3.273    49.529     0.150
     3.349    50.419     0.150
     3.590    52.970     0.150
     3.629    54.770     0.150
     3.629    95.479     0.150
     3.942    57.879     0.150
     3.942   101.180     0.150
     3.985    58.470     0.150
     3.999    58.239     0.150
     4.129    59.939     0.150
     4.186    60.959     0.150
     4.291    62.100     0.150
     4.291   107.869     0.150
     4.306    61.479     0.150
     4.306   106.569     0.150
     4.443    63.609     0.150
     4.443   111.079     0.150
     4.481   110.229     0.150
     4.570    66.449     0.150
     4.570   115.939     0.150
     4.584    67.189     0.150
     4.584   113.949     0.150
     4.625    66.289     0.150
     4.625   116.209     0.150
     4.691    67.539     0.150
     4.691   115.350     0.150
     4.698    67.089     0.150
     4.717    68.439     0.150
     4.718    68.009     0.150
     4.718   118.829     0.150
     4.735    67.759     0.150
     4.735   118.680     0.150
     4.755    68.579     0.150
     4.755   118.999     0.150
     4.824    69.699     0.150
     4.911    70.720     0.150
     4.911   124.299     0.150
     4.942    72.439     0.150
     5.076    72.799     0.150
     5.076   126.239     0.150
     5.107    73.609     0.150
     5.107   128.159     0.150
     5.131    73.839     0.150
     5.142    73.989     0.150
     5.285    76.209     0.150
     5.285   132.909     0.150
     5.334    77.149     0.150
     5.444    77.819     0.150
     5.444   136.409     0.150
     5.439    79.140     0.150
     5.581    81.239     0.150
     5.768    83.100     0.150
     5.781    82.140     0.150
     5.781   144.149     0.150
     5.907    85.020     0.150
     5.950    84.720     0.150
     5.978    84.720     0.150
     6.053    87.129     0.150
     6.090    86.899     0.150
     6.285    88.789     0.150
     6.285   155.180     0.150
     6.285    89.579     0.150
     6.413    91.089     0.150
     6.797    98.259     0.150
     6.809    96.589     0.150
     6.851    97.979     0.150
     6.878    97.149     0.150
     7.053   100.529     0.150
     7.090    99.850     0.150
     7.193   102.539     0.150
     7.322   102.739     0.150
     7.342   104.939     0.150
     7.475   105.520     0.150
     7.950   114.439     0.150
     8.624   122.339     0.150
     9.877   137.039     0.150
    13.544   193.239     0.150
    21.737   286.739     0.150
    21.757   288.239     0.150
    22.968   299.239     0.150
    29.767   361.539     0.150
    30.955   372.140     0.150
    31.327   374.439     0.150
    31.327    17.500     0.150
    33.112   391.239     0.150
    33.112    18.000     0.150
    33.301   391.640     0.150
    33.301    17.600     0.150
    35.723   413.739     0.150
    38.775   438.539     0.150
    38.775    18.500     0.150
    54.792   561.239     0.150
    59.464   594.339     0.150
    60.560   601.839     0.150
    61.638   608.239     0.150
    61.675   609.439     0.150
    71.057   670.239     0.150
    72.925   681.039     0.150
    73.309   683.439     0.150
    73.460   684.039     0.150
    73.702   685.439     0.150
    73.853   686.539     0.150
    80.993   726.579     0.150
    81.344   728.299     0.150
    81.416   728.479     0.150
    81.485   728.799     0.150
    81.575   729.680     0.150
     0.605    13.395     0.150
     0.747    14.125     0.150
     0.935    18.094     0.150
     0.966    18.383     0.150
     1.384    23.625     0.150
     1.487    24.746     0.150
     1.520    24.875     0.150
     1.798    30.004     0.150
     1.971    31.465     0.150
     2.141    33.934     0.150
     2.141    59.676     0.150
     2.449    39.605     0.150
     2.432    36.574     0.150
     2.478    37.695     0.150
     2.765    42.766     0.150
     2.770    42.703     0.150
     2.770    76.805     0.150
     2.830    43.734     0.150
     2.847    44.035     0.150
     2.898    44.594     0.150
     2.990    45.125     0.150
     2.983    45.785     0.150
     3.211    48.445     0.150
     3.272    48.824     0.150
     3.550    52.625     0.150
     3.604    53.574     0.150
     3.549    52.223     0.150
     3.677    53.812     0.150
     3.677    53.824     0.150
     3.828    55.035     0.150
     3.882    56.766     0.150
     4.071    59.285     0.150
     4.147    59.855     0.150
     4.738    69.426     0.150
     4.653    67.375     0.150
     4.673    67.453     0.150
     4.815    69.594     0.150
     4.968    72.125     0.150
     5.193    75.223     0.150
     5.207    74.766     0.150
     5.348    76.875     0.150
     5.474    78.086     0.150
     5.472    78.215     0.150
     5.636    80.945     0.150
     5.620    80.266     0.150
     5.820    83.223     0.150
     6.346    91.625     0.150
     6.411    90.312     0.150
     6.464    91.273     0.150
     6.623    93.723     0.150
     6.674    93.863     0.150
     6.751    95.953     0.150
     6.910    97.613     0.150
     6.910    97.223     0.150
     6.905    99.125     0.150
     7.059    99.184     0.150
     7.649   108.125     0.150
     8.164   115.926     0.150
     8.578   120.824     0.150
     8.874   123.535     0.150
     9.510   131.023     0.150
    12.999   178.023     0.150
    13.085   179.824     0.150
    14.858   207.023     0.150
    15.032   211.023     0.150
    19.106   258.426     0.150
    19.356   260.023     0.150
    19.913   268.824     0.150
    20.206   270.824     0.150
    20.978   280.824     0.150
    21.443   281.926     0.150
    21.449   285.824     0.150
    21.499   285.625     0.150
    21.529   285.824     0.150
    22.009   291.145     0.150
    22.579   295.824     0.150
    23.396   305.223     0.150
    25.296   321.824     0.150
    25.975   329.824     0.150
    26.281   332.523     0.150
    26.281    14.902     0.150
    26.281    17.000     0.150
    26.281   534.824     0.150
    26.897   337.926     0.150
    26.897    14.797     0.150
    26.897    17.699     0.150
    27.294   338.824     0.150
    27.410   341.523     0.150
    27.410    15.102     0.150
    27.580   342.523     0.150
    27.580    15.301     0.150
    27.743   343.223     0.150
    28.116   344.824     0.150
    28.116    16.000     0.150
    28.116    22.000     0.150
    28.116   619.223     0.150
    28.116   345.223     0.150
    28.116    15.602     0.150
    28.116    21.602     0.150
    28.116   400.824     0.150
    28.116   535.824     0.150
    28.116   710.824     0.150
    28.609   353.125     0.150
    28.609    14.500     0.150
    29.320   358.023     0.150
    29.320    16.602     0.150
    29.320   542.523     0.150
    29.320   759.125     0.150
    29.324   359.324     0.150
    29.324    14.898     0.150
    29.324    21.000     0.150
    29.367   359.824     0.150
    29.367    15.000     0.150
    29.513   361.125     0.150
    29.566   361.324     0.150
    29.566    15.000     0.150
    30.237   368.023     0.150
    30.237    14.801     0.150
    30.286    14.801     0.150
    30.286    22.602     0.150
    30.286   544.426     0.150
    30.482   369.723     0.150
    30.482    14.801     0.150
    30.482   545.625     0.150
    30.756   373.023     0.150
    30.756    15.102     0.150
    30.755   372.125     0.150
    31.024   373.324     0.150
    31.260   375.824     0.150
    32.139   383.824     0.150
    32.139    15.000     0.150
    32.415   386.824     0.150
    32.415    15.000     0.150
    32.415   386.824     0.150
    32.415    14.000     0.150
    32.479   387.426     0.150
    32.479    14.898     0.150
    32.771   385.824     0.150
    32.771    18.000     0.150
    32.771   694.824     0.150
    32.771   454.824     0.150
    32.771   548.824     0.150
    32.771   820.824     0.150
    32.771  1005.824     0.150
    32.954   390.625     0.150
    33.203   393.824     0.150
    33.203    15.000     0.150
    33.203   553.824     0.150
    33.243   393.824     0.150
    33.243    15.000     0.150
    33.526   396.824     0.150
    33.526    15.000     0.150
    33.538   395.824     0.150
    33.538    15.000     0.150
    34.027   399.824     0.150
    34.027    15.000     0.150
    34.056   398.523     0.150
    34.056    16.301     0.150
    34.541   404.824     0.150
    34.541    14.000     0.150
    34.795   406.824     0.150
    34.795    15.000     0.150
    35.418   412.125     0.150
    35.418    15.098     0.150
    35.447   412.824     0.150
    35.447    15.000     0.150
    35.447   559.824     0.150
    35.981   416.824     0.150
    35.981    15.000     0.150
    35.981   560.824     0.150
    36.459   417.223     0.150
    36.459    22.602     0.150
    36.459   750.824     0.150
    36.459   558.824     0.150
    36.459   899.824     0.150
    36.459  1026.824     0.150
    37.619   427.324     0.150
    37.619    18.500     0.150
    38.297   434.426     0.150
    38.509   438.254     0.150
    38.509   793.254     0.150
    38.509   966.652     0.150
    38.511   437.926     0.150
    38.511    15.898     0.150
    38.511   569.824     0.150
    39.125   439.023     0.150
    39.125    16.301     0.150
    39.125   789.824     0.150
    40.079   448.824     0.150
    40.079   808.824     0.150
    40.079   541.824     0.150
    40.079   980.824     0.150
    40.690   452.523     0.150
    41.128   457.125     0.150
    41.983   463.625     0.150
    41.975   463.723     0.150
    41.975   837.625     0.150
    42.573   470.324     0.150
    43.108   472.426     0.150
    44.425   484.723     0.150
    44.507   484.824     0.150
    44.507    17.000     0.150
    45.114   488.426     0.150
    45.114    16.398     0.150
    45.114   880.824     0.150
    45.114   589.824     0.150
    45.114  1080.824     0.150
    45.290   489.723     0.150
    46.573   502.324     0.150
    46.573   595.523     0.150
    46.739   502.523     0.150
    47.406   506.324     0.150
    47.991   511.926     0.150
    47.908   511.723     0.150
    48.159   513.125     0.150
    48.021   513.426     0.150
    48.227   516.824     0.150
    48.401   516.625     0.150
    48.354   515.023     0.150
    48.896   519.324     0.150
    48.768   518.723     0.150
    48.768    16.703     0.150
    48.934   519.324     0.150
    48.934   937.824     0.150
    48.858   519.523     0.150
    48.858    14.000     0.150
    49.112   520.625     0.150
    48.964   520.676     0.150
    49.298   522.324     0.150
    49.546   524.824     0.150
    49.546   949.824     0.150
    49.520   524.625     0.150
    49.898   526.926     0.150
    49.755   526.324     0.150
    50.048   527.223     0.150
    50.048    18.602     0.150
    50.048   951.824     0.150
    50.052   528.824     0.150
    50.326   531.223     0.150
    50.557   532.023     0.150
    50.865   534.324     0.150
    50.759   534.426     0.150
    50.766   534.824     0.150
    50.769   534.023     0.150
    50.875   967.855     0.150
    51.152   537.426     0.150
    51.152    17.398     0.150
    51.618   542.223     0.150
    51.705   540.824     0.150
    52.076   543.023     0.150
    52.087   542.824     0.150
    52.191   544.824     0.150
    52.129   544.023     0.150
    52.434   545.426     0.150
    52.434   983.824     0.150
    52.434  1130.324     0.150
    53.187   550.824     0.150
    53.187   994.824     0.150
    53.187   619.824     0.150
    53.187  1014.824     0.150
    53.363   552.824     0.150
    53.711   558.324     0.150
    54.197   558.523     0.150
    54.496   561.223     0.150
    54.393   562.824     0.150
    54.912   564.824     0.150
    55.025   564.324     0.150
    55.025    16.500     0.150
    55.025   626.824     0.150
    55.025  1149.824     0.150
    55.623   569.324     0.150
    55.502   565.324     0.150
    55.680   570.324     0.150
    55.884   571.223     0.150
    56.914   578.223     0.150
    56.783   579.324     0.150
    57.402   581.324     0.150
    57.402  1052.824     0.150
    57.402  1162.824     0.150
    57.943   585.223     0.150
    58.177   588.824     0.150
    58.127   589.824     0.150
    58.791   590.824     0.150
    58.791   590.926     0.150
    58.791   640.824     0.150
    58.791  1172.824     0.150
    58.940   592.723     0.150
    58.940    22.102     0.150
    58.940  1073.824     0.150
    59.153   593.625     0.150
    59.845   598.824     0.150
    59.845    25.000     0.150
    59.845  1083.824     0.150
    59.954   599.426     0.150
    60.200   600.223     0.150
    60.200   645.926     0.150
    61.025   606.426     0.150
    61.025  1098.824     0.150
    61.025  1134.824     0.150
    61.251   608.023     0.150
    61.251  1104.625     0.150
    61.251   652.824     0.150
    61.251  1192.824     0.150
    61.285   607.523     0.150
    61.358   608.723     0.150
    61.792   611.723     0.150
    61.998   613.324     0.150
    61.998  1112.824     0.150
    61.998  1142.824     0.150
    61.998  1194.824     0.150
    61.998  1354.824     0.150
    61.982   611.824     0.150
    61.982   651.824     0.150
    62.091   613.824     0.150
    62.091    24.000     0.150
    62.091  1117.824     0.150
    62.413   615.824     0.150
    62.413  1117.324     0.150
    62.726   617.824     0.150
    63.121   619.926     0.150
    63.121  1121.824     0.150
    63.121   656.824     0.150
    63.121   760.824     0.150
    63.987   627.125     0.150
    65.131   634.223     0.150
    65.352   634.824     0.150
    65.352  1155.324     0.150
    65.352  1182.824     0.150
    65.352  1223.926     0.150
    65.312   635.324     0.150
    65.327   635.426     0.150
    65.667   636.824     0.150
    65.667    18.000     0.150
    65.667   784.824     0.150
    65.667  1154.824     0.150
    65.604   638.125     0.150
    65.885   638.824     0.150
    65.885    23.000     0.150
    65.885  1159.824     0.150
    65.843   638.824     0.150
    65.843   668.824     0.150
    65.843  1172.824     0.150
    65.843  1224.824     0.150
    66.155   640.824     0.150
    66.336   640.824     0.150
    66.278   641.273     0.150
    66.407   642.523     0.150
    66.407  1170.324     0.150
    66.407  1232.324     0.150
    66.413   642.523     0.150
    66.526   642.523     0.150
    66.526    22.301     0.150
    66.526   670.824     0.150
    66.526   788.824     0.150
    66.526  1233.824     0.150
    66.789   644.863     0.150
    66.981   646.234     0.150
    68.085   653.383     0.150
    68.127   653.875     0.150
    68.135   653.695     0.150
    68.178   653.965     0.150
    68.275   654.285     0.150
    68.663   656.812     0.150
    68.676   657.324     0.150
    68.864   658.824     0.150
    68.909   659.324     0.150
    69.533   662.824     0.150
    69.771   664.023     0.150
    69.805   663.824     0.150
    69.937   664.926     0.150
    69.937    23.199     0.150
    69.995   664.824     0.150
    69.995  1209.824     0.150
    70.252   667.023     0.150
    70.504   668.223     0.150
    70.504  1216.824     0.150
    70.527   668.324     0.150
    70.687   668.426     0.150
    70.613   668.926     0.150
    70.769   670.824     0.150
    70.767   669.223     0.150
    70.843   670.414     0.150
    70.880   670.523     0.150
    70.960   671.125     0.150
    70.992   670.426     0.150
    71.064   671.125     0.150
    71.261   673.145     0.150
    71.340   673.824     0.150
    71.372   674.152     0.150
    71.377   673.523     0.150
    71.430   673.426     0.150
    71.432   674.223     0.150
    71.432   674.516     0.150
    71.459   674.285     0.150
    71.482   674.812     0.150
    71.629   674.824     0.150
    71.629    27.398     0.150
    71.629  1228.824     0.150
    71.578   675.395     0.150
    71.692   675.125     0.150
    71.686   676.035     0.150
    71.741   676.023     0.150
    71.771   676.555     0.150
    71.833   676.996     0.150
    71.892   677.273     0.150
    72.052   678.074     0.150
    72.061   678.062     0.150
    72.130   678.426     0.150
    72.150   678.523     0.150
    72.145   678.625     0.150
    72.204   679.125     0.150
    72.204    27.398     0.150
    72.255   679.004     0.150
    72.263   679.023     0.150
    72.280   678.824     0.150
    72.341   679.824     0.150
    72.433   680.023     0.150
    72.533   680.824     0.150
    72.536   680.223     0.150
    72.572   681.125     0.150
    72.572   680.926     0.150
    72.764   681.715     0.150
    72.788   681.926     0.150
    72.873   682.145     0.150
    72.911   682.426     0.150
    72.915   682.324     0.150
    72.948   683.426     0.150
    73.034   683.223     0.150
    72.871   682.824     0.150
    73.040   683.625     0.150
    73.060   683.223     0.150
    73.205   683.824     0.150
    73.216   684.555     0.150
    73.241   684.625     0.150
    73.275   682.824     0.150
    73.306   685.023     0.150
    73.301   684.426     0.150
    73.317   685.223     0.150
    73.302   686.125     0.150
    73.306   686.023     0.150
    73.269   685.523     0.150
    73.395   685.426     0.150
    73.451   685.324     0.150
    73.517   685.625     0.150
    73.541   686.824     0.150
    73.540   685.926     0.150
    73.517   687.426     0.150
    73.552   687.625     0.150
    73.613   686.223     0.150
    73.645   687.723     0.150
    73.825   688.723     0.150
    73.825    27.102     0.150
    73.849   689.324     0.150
    73.870   689.723     0.150
    73.870    16.102     0.150
    73.870    27.102     0.150
    74.206   689.824     0.150
    74.206  1258.824     0.150
    74.206   690.824     0.150
    74.216   691.023     0.150
    74.216   702.824     0.150
    74.220   690.824     0.150
    74.220   691.426     0.150
    74.220   857.625     0.150
    74.291   691.523     0.150
    74.414   692.625     0.150
    74.457   691.223     0.150
    74.552   690.824     0.150
    74.552  1259.824     0.150
    74.552   691.625     0.150
    74.513   692.824     0.150
    74.525   692.723     0.150
    74.564   693.426     0.150
    74.647   692.824     0.150
    74.663   694.223     0.150
    74.680   693.125     0.150
    74.719   693.625     0.150
    74.872   693.723     0.150
    74.901   693.824     0.150
    74.901  1264.824     0.150
    74.901  1292.824     0.150
    74.915   694.125     0.150
    74.942   694.723     0.150
    75.030   695.824     0.150
    75.051   696.125     0.150
    75.081   695.023     0.150
    75.077   696.004     0.150
    75.082   696.324     0.150
    75.141   694.824     0.150
    75.139   697.234     0.150
    75.307   695.625     0.150
    75.348   696.324     0.150
    75.399   697.223     0.150
    75.432   698.824     0.150
    75.462   698.574     0.150
    75.479   699.125     0.150
    75.479   698.484     0.150
    75.560   699.324     0.150
    75.596   698.324     0.150
    75.616   697.324     0.150
    75.623   700.113     0.150
    75.643   698.324     0.150
    75.677   698.824     0.150
    75.759   700.523     0.150
    75.792   699.824     0.150
    75.943   700.223     0.150
    75.885   701.125     0.150
    76.044   699.824     0.150
    76.006   701.973     0.150
    76.043   700.824     0.150
    76.059   700.324     0.150
    76.015   702.023     0.150
    76.073   701.855     0.150
    76.093   701.023     0.150
    76.107   702.023     0.150
    76.194   701.824     0.150
    76.221   701.754     0.150
    76.308   702.223     0.150
    76.334   703.324     0.150
    76.357   702.266     0.150
    76.424   702.324     0.150
    76.380   702.773     0.150
    76.388   702.055     0.150
    76.415   702.824     0.150
    76.410   703.824     0.150
    76.455   703.324     0.150
    76.461   702.125     0.150
    76.506   702.984     0.150
    76.728   703.824     0.150
    76.728   702.824     0.150
    76.748   704.824     0.150
    76.760   704.934     0.150
    76.933   705.824     0.150
    76.951   707.824     0.150
    76.954   706.223     0.150
    76.939   705.523     0.150
    77.016   706.324     0.150
    77.016  1289.824     0.150
    77.016   716.324     0.150
    77.003   706.723     0.150
    77.143   707.125     0.150
    77.204   707.824     0.150
    77.274   707.824     0.150
    77.274  1286.824     0.150
    77.222   708.023     0.150
    77.135   706.324     0.150
    77.147   705.824     0.150
    77.329   710.023     0.150
    77.329  1293.824     0.150
    77.257   708.125     0.150
    77.262   706.824     0.150
    77.290   708.824     0.150
    77.406   708.824     0.150
    77.406  1292.824     0.150
    77.470   708.523     0.150
    77.470  1291.824     0.150
    77.470    16.301     0.150
    77.470  1314.824     0.150
    77.470  1342.824     0.150
    77.593   710.023     0.150
    77.600   708.824     0.150
    77.600  1299.125     0.150
    77.600   709.426     0.150
    77.643   710.324     0.150
    77.601   710.426     0.150
    77.697   711.426     0.150
    77.796   710.824     0.150
    77.733   710.723     0.150
    77.743   710.605     0.150
    77.677   708.824     0.150
    77.887   712.125     0.150
    77.981   712.754     0.150
    78.019   713.324     0.150
    78.053   712.215     0.150
    77.999   710.426     0.150
    78.136   712.523     0.150
    78.148   713.426     0.150
    78.130   713.824     0.150
    78.241   712.926     0.150
    78.346   712.426     0.150
    78.378   714.824     0.150
    78.504   715.094     0.150
    78.574   715.926     0.150
    78.620   715.324     0.150
    78.614   715.426     0.150
    78.640   716.324     0.150
    78.682   715.824     0.150
    78.758   715.723     0.150
    78.860   716.625     0.150
    78.872   716.324     0.150
    78.911   717.523     0.150
    78.911   716.996     0.150
    79.077   718.125     0.150
    79.035   716.324     0.150
    79.239   719.223     0.150
    79.119   717.523     0.150
    79.266   718.824     0.150
    79.129   717.223     0.150
    79.268   718.223     0.150
    79.276   719.324     0.150
    79.330   718.824     0.150
    79.265   717.324     0.150
    79.381   719.625     0.150
    79.390   718.824     0.150
    79.325   719.293     0.150
    79.441   718.824     0.150
    79.435   719.824     0.150
    79.548   721.625     0.150
    79.588   720.324     0.150
    79.642   722.324     0.150
    79.642  1316.824     0.150
    79.510   719.223     0.150
    79.533   718.824     0.150
    79.696   721.723     0.150
    79.732   720.426     0.150
    79.784   721.824     0.150
    79.682   721.133     0.150
    79.826   721.324     0.150
    79.850   722.824     0.150
    79.986   722.824     0.150
    80.085   721.824     0.150
    80.076   724.125     0.150
    80.159   724.926     0.150
    80.201   723.824     0.150
    80.249   724.824     0.150
    80.231   725.023     0.150
    80.280   724.824     0.150
    80.169   723.023     0.150
    80.345   725.926     0.150
    80.378   724.324     0.150
    80.349   725.926     0.150
    80.461   725.824     0.150
    80.461  1327.824     0.150
    80.461   726.324     0.150
    80.461  1335.824     0.150
    80.515   725.723     0.150
    80.515  1326.824     0.150
    80.516   725.324     0.150
    80.545   727.324     0.150
    80.620   724.824     0.150
    80.588   725.926     0.150
    80.669   726.824     0.150
    80.669  1330.824     0.150
    80.658   725.926     0.150
    80.658    18.199     0.150
    80.685   727.125     0.150
    80.687   726.523     0.150
    80.700   728.625     0.150
    80.748   726.824     0.150
    80.753   726.824     0.150
    80.859   727.023     0.150
    81.007   727.926     0.150
    81.009   727.926     0.150
    81.077   728.926     0.150
    81.037   728.824     0.150
    81.062   727.824     0.150
    81.088   729.023     0.150
    81.088  1333.824     0.150
    81.099   727.824     0.150
    81.121   727.824     0.150
    81.094   730.324     0.150
    81.128   730.324     0.150
    81.133   730.426     0.150
    81.173   730.824     0.150
    81.309   728.723     0.150
    81.271   730.926     0.150
    81.299   729.023     0.150
    81.296   729.723     0.150
    81.322   728.824     0.150
    81.288   731.426     0.150
    81.425   730.625     0.150
    81.491   730.926     0.150
    81.443   731.523     0.150
    81.486   730.324     0.150
    81.501   730.324     0.150
    81.567   731.223     0.150
    81.494   732.223     0.150
    81.539   730.824     0.150
    81.550   730.223     0.150
    81.548   731.324     0.150
    81.558   731.324     0.150
    81.530   732.824     0.150
    81.581   730.824     0.150
    81.655   732.023     0.150
    81.611   733.426     0.150
    81.716   732.023     0.150
    81.731   731.824     0.150
    81.782   732.824     0.150
    81.782  1342.824     0.150
    81.887   732.824     0.150
    81.836   732.523     0.150
    81.827   733.023     0.150
    81.921   733.383     0.150
    81.811   730.953     0.150
    81.938   732.324     0.150
    81.949   732.824     0.150
    81.940   733.723     0.150
    82.004   733.125     0.150
    82.079   732.926     0.150
    82.211   734.523     0.150
    82.125   734.555     0.150
    82.294   734.426     0.150
    82.497   736.824     0.150
    82.584   737.824     0.150
    82.674   736.605     0.150
    82.802   736.824     0.150
    82.889   738.523     0.150
    82.991   738.824     0.150
    83.103   738.324     0.150
    83.240   738.824     0.150
    83.240   738.723     0.150
    83.256   737.324     0.150
    83.296   739.324     0.150
    83.391   737.324     0.150
    83.413   739.824     0.150
    83.559   740.926     0.150
    83.574   741.426     0.150
    83.677   741.523     0.150
    83.613   743.723     0.150
    83.718   742.023     0.150
    83.890   742.824     0.150
    83.969   745.824     0.150
    84.150   745.324     0.150
    84.194   744.023     0.150
    84.151   745.324     0.150
    84.260   744.824     0.150
    84.416   747.324     0.150
    84.397   745.824     0.150
    84.467   745.023     0.150
    84.552   747.324     0.150
    84.565   750.824     0.150
    84.565  1368.824     0.150
    84.498   747.324     0.150
    84.625   746.324     0.150
    85.010   748.324     0.150
    85.010  1366.824     0.150
    85.120   747.824     0.150
    85.347   751.324     0.150
    85.366   751.926     0.150
    85.444   751.723     0.150
    85.626   751.926     0.150
    85.680   750.824     0.150
    85.727   751.023     0.150
    85.996   754.824     0.150
    86.310   756.723     0.150
    86.461   755.023     0.150
    86.447   757.223     0.150
    86.599   755.824     0.150
    86.628   754.824     0.150
    86.696   757.824     0.150
    86.904   758.324     0.150
    87.002   758.125     0.150
    87.475   762.824     0.150
    87.475  1397.824     0.150
    88.340   765.824     0.150
    88.874   769.625     0.150
    89.353   771.723     0.150
    89.928   773.125     0.150
    91.221   775.125     0.150
    91.845   782.824     0.150
    92.839   786.824     0.150
    93.093   789.824     0.150
    93.413   787.824     0.150
    93.413    17.000     0.150
    94.182   792.824     0.150
    95.181   795.824     0.150
    95.556   798.824     0.150
    97.312   805.223     0.150
    98.143   809.023     0.150
   100.356   822.824     0.150
   101.016   820.824     0.150
   101.016  1060.824     0.150
   116.939  1117.023     0.150
   123.924  1131.324     0.150
   137.723  1157.723     0.150
   148.284  1171.324     0.150
   148.284  1199.426     0.150
   148.458  1175.824     0.150
   149.876  1178.324     0.150
   150.655  1179.824     0.150
   154.359  1184.824     0.150
     0.748    14.560     0.150
     1.367    22.970     0.150
     1.475    24.260     0.150
     1.888    30.229     0.150
     1.913    30.300     0.150
     1.915    31.050     0.150
     1.916    30.979     0.150
     1.916    30.659     0.150
     1.921    31.229     0.150
     1.935    31.909     0.150
     2.217    35.290     0.150
     2.462    38.069     0.150
     2.470    38.670     0.150
     2.893    44.130     0.150
     3.012    45.609     0.150
     3.054    46.439     0.150
     3.057    46.329     0.150
     3.056    46.439     0.150
     3.072    46.399     0.150
     3.088    46.640     0.150
     3.107    47.369     0.150
     3.141    47.260     0.150
     3.191    47.619     0.150
     3.201    47.880     0.150
     3.477    50.640     0.150
     3.566    52.130     0.150
     3.779    55.460     0.150
     3.819    56.270     0.150
     3.835    56.220     0.150
     3.880    57.279     0.150
     3.963    58.390     0.150
     4.025    58.449     0.150
     4.040    59.560     0.150
     4.264    61.109     0.150
     4.302    63.149     0.150
     4.302   114.609     0.150
     4.364    63.560     0.150
     4.646    68.060     0.150
     4.674    68.569     0.150
     4.770    68.229     0.150
     4.770    68.659     0.150
     4.803    68.880     0.150
     4.853    69.130     0.150
     4.975    71.369     0.150
     5.000    70.859     0.150
     5.160    73.540     0.150
     5.170    73.890     0.150
     5.263    76.270     0.150
     5.299    75.829     0.150
     5.599    80.560     0.150
     5.688    81.409     0.150
     5.905    85.399     0.150
     6.033    87.260     0.150
     6.237    89.829     0.150
     6.252    90.310     0.150
     6.272    91.310     0.150
     6.395    91.180     0.150
     6.441    92.180     0.150
     6.458    91.829     0.150
     6.531    92.729     0.150
     6.726    96.770     0.150
     6.868    97.520     0.150
     6.874    98.029     0.150
     6.899    98.300     0.150
     7.285   103.710     0.150
     7.555   106.069     0.150
     7.718   109.060     0.150
     7.766   108.790     0.150
     7.982   113.270     0.150
     8.000   112.260     0.150
     8.151   114.880     0.150
     8.639   124.060     0.150
     9.068   126.619     0.150
    10.002   141.060     0.150
    14.170   196.560     0.150
    14.345   199.859     0.150
    21.700   288.359     0.150
    21.741   288.560     0.150
    22.154   292.060     0.150
    22.537   294.560     0.150
    23.695   307.560     0.150
    27.510   341.560     0.150
    27.715   344.359     0.150
    27.715    12.400     0.150
    29.241   357.560     0.150
    30.317   368.260     0.150
    31.298   375.560     0.150
    32.355   385.560     0.150
    32.984   391.560     0.150
    33.152   392.560     0.150
    33.156   391.560     0.150
    33.356   393.960     0.150
    33.423   395.560     0.150
    33.937   398.560     0.150
    34.122   399.859     0.150
    34.581   404.359     0.150
    34.705   405.560     0.150
    35.697   414.060     0.150
    35.742   415.060     0.150
    35.932   416.060     0.150
    38.673   438.560     0.150
    41.229   461.060     0.150
    44.991   488.760     0.150
    48.492   516.859     0.150
    50.931   535.060     0.150
    61.254   608.260     0.150
    62.332   614.859     0.150
    62.365   615.560     0.150
    71.051   671.560     0.150
    71.558   674.460     0.150
    71.558   693.560     0.150
    71.589   675.060     0.150
    71.589   693.560     0.150
    71.751   675.560     0.150
    72.483   680.460     0.150
    72.496   680.859     0.150
    73.260   685.060     0.150
    73.330   685.460     0.150
    73.370   684.560     0.150
    73.601   698.859     0.150
    73.614   687.060     0.150
    73.841   688.159     0.150
    73.995   689.159     0.150
    74.145   690.159     0.150
    74.386   691.260     0.150
    74.438   694.159     0.150
    74.537   692.359     0.150
    74.601   692.460     0.150
    74.700   692.960     0.150
    74.821   693.859     0.150
    74.940   694.859     0.150
    74.940   705.560     0.150
    74.940   707.659     0.150
    75.279   696.859     0.150
    75.279   708.760     0.150
    75.770   699.760     0.150
    76.004   700.960     0.150
    76.109   702.859     0.150
    76.130   703.159     0.150
    77.005   705.359     0.150
    77.826   711.159     0.150
    79.316   719.260     0.150
    81.366   729.819     0.150
    81.721   731.060     0.150
    81.799   731.779     0.150
    81.860   732.779     0.150
    81.953   733.340     0.150
   147.286  1173.159     0.150
   147.286  1187.060     0.150
     0.594    12.542     0.150
     0.818    15.532     0.150
     0.818    26.552     0.150
     1.147    21.052     0.150
     1.147    37.262     0.150
     1.209    21.662     0.150
     1.209    37.522     0.150
     1.321    23.302     0.150
     1.321    41.442     0.150
     1.470    24.942     0.150
     1.459    25.792     0.150
     1.463    25.952     0.150
     1.463    44.642     0.150
     1.488    26.192     0.150
     1.498    26.272     0.150
     1.503    26.302     0.150
     1.635    28.132     0.150
     1.635    49.722     0.150
     1.757    29.322     0.150
     1.941    32.042     0.150
     1.963    32.302     0.150
     2.058    33.152     0.150
     2.273    35.522     0.150
     2.253    35.922     0.150
     2.254    35.952     0.150
     2.256    35.992     0.150
     2.272    35.692     0.150
     2.283    36.302     0.150
     2.305    36.412     0.150
     2.315    36.222     0.150
     2.259    35.492     0.150
     2.368    37.112     0.150
     2.377    37.552     0.150
     2.429    39.392     0.150
     2.767    41.482     0.150
     2.821    42.982     0.150
     2.790    42.792     0.150
     2.887    44.132     0.150
     2.921    45.152     0.150
     2.937    45.402     0.150
     2.978    45.012     0.150
     2.979    43.342     0.150
     2.992    46.182     0.150
     3.010    46.202     0.150
     3.075    46.822     0.150
     3.114    47.822     0.150
     3.168    48.022     0.150
     3.258    48.892     0.150
     3.372    49.812     0.150
     3.425    52.122     0.150
     3.436    51.212     0.150
     3.473    51.702     0.150
     3.473    51.252     0.150
     3.494    51.312     0.150
     3.517    52.452     0.150
     3.648    53.972     0.150
     3.683    54.603     0.150
     3.676    54.912     0.150
     3.670    55.152     0.150
     3.670    98.232     0.150
     3.810    56.632     0.150
     3.810    97.872     0.150
     3.819    56.672     0.150
     3.846    56.912     0.150
     3.943    59.092     0.150
     4.017    58.592     0.150
     4.069    60.702     0.150
     4.134    63.032     0.150
     4.178    61.182     0.150
     4.209    62.132     0.150
     4.603    68.422     0.150
     4.750    70.082     0.150
     4.774    70.132     0.150
     4.778    71.312     0.150
     4.997    72.672     0.150
     5.116    74.072     0.150
     5.118    75.232     0.150
     5.174    75.542     0.150
     5.148    75.042     0.150
     5.250    77.362     0.150
     5.253    77.212     0.150
     5.334    77.572     0.150
     5.349    77.642     0.150
     5.499    80.112     0.150
     5.558    81.432     0.150
     5.752    83.812     0.150
     5.818    86.322     0.150
     5.995    87.072     0.150
     6.273    90.332     0.150
     6.350    91.222     0.150
     6.356    93.622     0.150
     6.371    92.022     0.150
     6.374    91.682     0.150
     6.423    94.122     0.150
     6.470    93.172     0.150
     6.574    94.622     0.150
     6.591    94.132     0.150
     6.820    97.302     0.150
     6.954    99.952     0.150
     7.846   111.732     0.150
    20.725   279.912     0.150
    20.725   292.662     0.150
    30.212   369.012     0.150
    30.212    11.811     0.150
    32.426   390.392     0.150
     0.095     5.992     0.150
     0.773    14.482     0.150
     0.773    25.514     0.150
     1.243    21.053     0.150
     1.243    38.402     0.150
     1.572    26.213     0.150
     1.572    46.193     0.150
     1.586    26.764     0.150
     1.597    26.383     0.150
     1.602    26.844     0.150
     1.669    27.684     0.150
     1.669    48.674     0.150
     1.612    26.623     0.150
     1.618    27.014     0.150
     1.652    26.652     0.150
     1.816    29.344     0.150
     1.816    51.014     0.150
     1.877    30.453     0.150
     1.877    53.463     0.150
     1.854    30.094     0.150
     1.854    52.832     0.150
     2.106    32.844     0.150
     2.106    56.742     0.150
     2.244    35.014     0.150
     2.257    35.004     0.150
     2.588    39.533     0.150
     2.588    69.434     0.150
     2.631    40.383     0.150
     2.632    40.402     0.150
     2.653    40.553     0.150
     2.657    40.713     0.150
     2.768    40.982     0.150
     2.737    41.684     0.150
     2.760    42.062     0.150
     2.760    74.004     0.150
     2.923    43.514     0.150
     2.923    76.082     0.150
     2.983    46.402     0.150
     3.112    46.094     0.150
     3.314    48.332     0.150
     3.241    48.623     0.150
     3.359    49.992     0.150
     3.366    51.082     0.150
     3.373    50.424     0.150
     3.373    89.293     0.150
     3.397    51.113     0.150
     3.433    51.363     0.150
     3.436    51.104     0.150
     3.436    91.062     0.150
     3.441    51.094     0.150
     3.441    60.482     0.150
     3.441    91.053     0.150
     3.598    52.193     0.150
     3.486    52.113     0.150
     3.578    53.232     0.150
     3.578    94.703     0.150
     3.706    54.184     0.150
     3.706    93.273     0.150
     3.640    52.514     0.150
     3.729    54.492     0.150
     3.729    94.992     0.150
     3.743    55.242     0.150
     3.743    96.963     0.150
     4.020    58.293     0.150
     4.046    59.594     0.150
     4.132    59.613     0.150
     4.131    59.754     0.150
     4.131   103.594     0.150
     4.133    59.582     0.150
     4.133   103.424     0.150
     4.251    60.773     0.150
     4.251   104.652     0.150
     4.181    61.174     0.150
     4.410    63.723     0.150
     4.503    65.293     0.150
     4.561    65.893     0.150
     4.561   113.562     0.150
     4.692    68.053     0.150
     4.713    69.393     0.150
     4.957    71.473     0.150
     5.074    72.193     0.150
     5.330    77.383     0.150
     5.391    77.543     0.150
     5.518    80.184     0.150
     5.700    81.533     0.150
     5.756    82.344     0.150
     5.733    82.723     0.150
     5.833    83.822     0.150
     6.095    86.844     0.150
     6.303    90.533     0.150
     6.509    93.344     0.150
     6.728    96.184     0.150
     7.000    99.393     0.150
     7.065   100.232     0.150
     7.449   106.492     0.150
     7.434   103.553     0.150
     7.434   184.412     0.150
     7.459   105.354     0.150
     8.192   115.943     0.150
     8.275   118.033     0.150
     9.300   128.982     0.150
     0.786    20.297     0.150
     0.849    20.602     0.150
     0.849    36.422     0.150
     1.189    24.227     0.150
     1.189    41.750     0.150
     1.203    24.555     0.150
     1.205    24.875     0.150
     1.205    42.656     0.150
     1.210    23.852     0.150
     1.220    24.820     0.150
     1.225    24.844     0.150
     1.373    26.125     0.150
     1.373    45.750     0.150
     1.389    26.086     0.150
     1.539    26.164     0.150
     1.873    32.320     0.150
     2.106    35.484     0.150
     2.222    36.375     0.150
     2.253    37.195     0.150
     2.253    65.336     0.150
     2.295    37.914     0.150
     2.295    37.891     0.150
     2.332    38.250     0.150
     2.332    66.984     0.150
     2.424    39.773     0.150
     2.471    40.172     0.150
     2.482    39.891     0.150
     2.490    39.711     0.150
     2.490    67.727     0.150
     2.645    41.977     0.150
     2.943    46.109     0.150
     3.071    47.820     0.150
     3.071    84.172     0.150
     3.091    47.852     0.150
     3.097    48.414     0.150
     3.119    48.570     0.150
     3.141    49.164     0.150
     3.180    48.805     0.150
     3.212    49.609     0.150
     3.262    50.609     0.150
     3.289    49.906     0.150
     3.904    57.953     0.150
     3.999    59.062     0.150
     4.077    60.273     0.150
     4.089    60.156     0.150
     4.294    61.664     0.150
     4.294   107.875     0.150
     4.418    64.164     0.150
     4.490    64.711     0.150
     4.351    62.977     0.150
     4.482    66.250     0.150
     4.598    66.953     0.150
     4.720    67.820     0.150
     4.755    69.383     0.150
     4.898    69.883     0.150
     4.999    72.062     0.150
     5.103    73.336     0.150
     5.128    74.484     0.150
     5.157    74.414     0.150
     5.223    76.047     0.150
     5.459    78.766     0.150
     5.475    78.461     0.150
     5.487    79.492     0.150
     5.704    81.656     0.150
     5.704   144.250     0.150
     5.777    82.875     0.150
     5.962    86.773     0.150
     6.031    86.320     0.150
     6.191    88.156     0.150
     6.298    89.586     0.150
     6.363    90.445     0.150
     6.492    92.656     0.150
     6.737    94.172     0.150
     6.857    96.094     0.150
     6.872    97.000     0.150
     6.897    98.070     0.150
     7.072    98.930     0.150
     7.086    99.461     0.150
     7.150   102.383     0.150
     7.247   101.750     0.150
     7.290   101.773     0.150
     7.302   104.570     0.150
     7.396   102.977     0.150
     7.396   103.266     0.150
     7.456   104.172     0.150
     7.546   107.547     0.150
     7.634   108.172     0.150
     7.838   112.305     0.150
     7.935   111.906     0.150
     7.969   113.656     0.150
     9.270   129.070     0.150
    10.617   146.070     0.150
    12.888   177.352     0.150
    13.679   188.453     0.150
    21.285   279.047     0.150
    21.820   280.953     0.150
    24.494   309.062     0.150
    32.120   377.523     0.150
    33.926   394.133     0.150
    34.061   394.492     0.150
    34.306   396.547     0.150
    35.477   406.695     0.150
    39.059   434.953     0.150
    43.697   473.953     0.150
    45.485   488.156     0.150
     0.596    12.023     0.150
     1.024    18.043     0.150
     1.357    23.496     0.150
     1.357    40.594     0.150
     1.357    41.246     0.150
     1.372    23.805     0.150
     1.381    24.086     0.150
     1.382    23.414     0.150
     1.387    23.734     0.150
     1.403    24.035     0.150
     1.437    23.836     0.150
     1.509    25.496     0.150
     1.644    27.406     0.150
     1.675    27.355     0.150
     1.715    28.156     0.150
     1.920    30.246     0.150
     1.896    29.906     0.150
     2.039    32.355     0.150
     2.137    33.996     0.150
     2.389    37.023     0.150
     2.433    37.895     0.150
     2.433    37.844     0.150
     2.460    38.176     0.150
     2.549    39.125     0.150
     2.563    39.543     0.150
     2.665    39.535     0.150
     2.784    41.523     0.150
     2.815    44.016     0.150
     2.996    44.215     0.150
     3.051    46.016     0.150
     3.171    47.254     0.150
     3.175    48.496     0.150
     3.183    47.844     0.150
     3.208    48.645     0.150
     3.240    48.977     0.150
     3.245    48.695     0.150
     3.252    48.496     0.150
     3.399    49.926     0.150
     3.421    50.336     0.150
     3.576    52.945     0.150
     3.589    52.855     0.150
     3.595    52.254     0.150
     3.893    57.355     0.150
     3.966    57.633     0.150
     3.994    57.855     0.150
     3.994    57.125     0.150
     3.999    58.625     0.150
     4.008    58.113     0.150
     4.200    60.816     0.150
     4.373    63.086     0.150
     4.360    62.754     0.150
     4.481    64.605     0.150
     4.545    66.094     0.150
     4.666    67.664     0.150
     4.871    70.414     0.150
     5.182    75.035     0.150
     5.175    74.453     0.150
     5.225    75.953     0.150
     5.079    72.055     0.150
     5.423    78.805     0.150
     5.559    80.625     0.150
     5.602    81.023     0.150
     5.641    80.664     0.150
     5.695    81.805     0.150
     5.737    83.035     0.150
     6.001    86.184     0.150
     6.062    86.605     0.150
     6.099    86.996     0.150
     6.309    90.555     0.150
     6.351    90.664     0.150
     6.789    95.785     0.150
     6.826    96.484     0.150
     6.966    98.895     0.150
     7.034    98.605     0.150
     7.080   100.543     0.150
     7.122   104.504     0.150
     7.273   101.676     0.150
     7.306   102.543     0.150
     7.306   102.586     0.150
     7.366   104.754     0.150
     7.418   105.293     0.150
     7.991   112.734     0.150
     8.074   113.895     0.150
     8.933   127.883     0.150
     9.390   130.555     0.150
    10.108   139.816     0.150
    20.734   278.285     0.150
    21.291   284.285     0.150
    23.205   304.176     0.150
    26.915   336.555     0.150
    32.612   389.086     0.150
    32.612    15.707     0.150
    32.995   392.535     0.150
    32.995    16.840     0.150
    34.168   402.656     0.150
    34.168    16.699     0.150
    34.358   404.156     0.150
    34.358    16.629     0.150
    41.162   459.055     0.150
    42.352   468.555     0.150
    48.886   521.355     0.150
    48.886    16.027     0.150
    60.181   601.953     0.150
    60.596   604.355     0.150
    61.685   611.656     0.150
    71.107   673.055     0.150
    72.893   684.156     0.150
    72.893   696.754     0.150
    73.279   685.953     0.150
    73.427   686.953     0.150
    73.574   687.355     0.150
    73.668   688.156     0.150
    73.884   689.156     0.150
    73.901   689.355     0.150
    75.276   697.656     0.150
     0.646    12.947     0.150
     0.789    15.367     0.150
     1.447    25.076     0.150
     1.511    25.707     0.150
     1.511    44.086     0.150
     1.490    25.867     0.150
     1.646    27.916     0.150
     1.691    29.057     0.150
     1.691    28.746     0.150
     1.691    51.436     0.150
     1.710    27.996     0.150
     1.711    29.277     0.150
     1.711    52.766     0.150
     1.718    29.346     0.150
     1.730    29.436     0.150
     1.732    29.496     0.150
     1.768    28.916     0.150
     1.893    31.717     0.150
     1.931    31.307     0.150
     1.931    57.746     0.150
     2.027    32.916     0.150
     2.175    35.137     0.150
     2.217    35.326     0.150
     2.219    35.336     0.150
     2.233    35.797     0.150
     2.318    35.586     0.150
     2.289    36.406     0.150
     2.426    38.326     0.150
     2.426    69.547     0.150
     2.506    38.906     0.150
     2.506    68.516     0.150
     2.564    39.746     0.150
     2.573    39.986     0.150
     2.596    40.256     0.150
     2.662    40.836     0.150
     2.666    41.246     0.150
     2.666    73.346     0.150
     2.687    40.676     0.150
     2.730    41.156     0.150
     2.731    43.367     0.150
     2.765    41.777     0.150
     2.991    46.746     0.150
     3.099    46.717     0.150
     3.248    48.766     0.150
     3.278    48.877     0.150
     3.281    49.326     0.150
     3.291    49.686     0.150
     3.326    49.676     0.150
     3.365    50.447     0.150
     3.469    51.807     0.150
     3.469    94.516     0.150
     3.611    53.186     0.150
     3.668    54.176     0.150
     3.717    54.457     0.150
     3.721    55.646     0.150
     3.760    55.387     0.150
     3.760    55.096     0.150
     3.768    56.076     0.150
     3.963    58.477     0.150
     4.045    59.906     0.150
     4.045   102.807     0.150
     4.088    60.697     0.150
     4.100    60.496     0.150
     4.337    64.326     0.150
     4.434    66.537     0.150
     4.449    65.396     0.150
     4.449   113.596     0.150
     4.860    72.047     0.150
     4.915    72.586     0.150
     4.915   125.547     0.150
     5.024    74.756     0.150
     5.034    73.736     0.150
     5.147    74.836     0.150
     5.147   129.396     0.150
     5.147   130.256     0.150
     5.166    75.336     0.150
     5.243    77.316     0.150
     5.376    78.346     0.150
     5.445    79.846     0.150
     5.426    78.457     0.150
     5.475    80.016     0.150
     5.489    80.246     0.150
     5.509    79.967     0.150
     5.509   138.037     0.150
     5.545    80.787     0.150
     5.555    80.746     0.150
     5.688    82.246     0.150
     5.763    83.617     0.150
     5.689    84.707     0.150
     5.855    85.197     0.150
     5.914    84.926     0.150
     6.078    87.557     0.150
     6.112    87.527     0.150
     6.242    90.807     0.150
     6.259    92.047     0.150
     6.444    92.816     0.150
     6.634    94.506     0.150
     6.665    94.117     0.150
     6.673    95.186     0.150
     6.684    95.246     0.150
     6.758    97.426     0.150
     6.868    98.016     0.150
     6.928   100.447     0.150
     7.042   100.406     0.150
     7.109   101.156     0.150
     7.109   101.156     0.150
     7.109   176.467     0.150
     7.114   100.646     0.150
     7.114   101.246     0.150
     7.124   101.816     0.150
     7.247   103.496     0.150
     7.621   109.516     0.150
     7.621   191.346     0.150
     8.017   114.357     0.150
     8.067   114.246     0.150
     8.147   115.826     0.150
     8.396   119.346     0.150
     8.700   122.877     0.150
     8.841   126.146     0.150
     8.841   220.096     0.150
     9.037   128.447     0.150
     9.377   134.186     0.150
     9.925   138.816     0.150
    11.267   159.617     0.150
    13.031   183.146     0.150
    15.711   218.646     0.150
    15.711   218.846     0.150
    15.712   218.086     0.150
    20.628   279.807     0.150
    21.104   284.496     0.150
    21.565   287.646     0.150
    22.208   294.957     0.150
    22.523   297.146     0.150
    24.784   321.037     0.150
    24.967   322.066     0.150
    25.057   324.906     0.150
    25.781   330.377     0.150
    26.539   337.646     0.150
    26.587   335.646     0.150
    29.367   361.746     0.150
    30.900   375.697     0.150
    31.653   382.236     0.150
    31.957   553.797     0.150
    32.116   386.586     0.150
    32.331   388.777     0.150
    32.592   391.146     0.150
    33.501   398.076     0.150
    33.642   400.346     0.150
    33.690   400.346     0.150
    36.278   421.006     0.150
    37.610   432.166     0.150
    37.610   570.107     0.150
    38.150   437.707     0.150
    40.039   454.047     0.150
    41.727   466.867     0.150
    41.810   471.346     0.150
    42.195   470.047     0.150
    42.195     5.699     0.150
    42.403   472.947     0.150
    46.183   500.146     0.150
    46.853   507.617     0.150
    51.125   540.146     0.150
    51.283   540.877     0.150
    54.310   563.646     0.150
    54.858   567.646     0.150
    59.174   596.447     0.150
    59.857   602.746     0.150
    60.186   604.447     0.150
    60.500   606.646     0.150
    61.768   615.646     0.150
    63.313   626.246     0.150
    63.396   625.646     0.150
    64.134   630.646     0.150
    64.207   630.646     0.150
    66.261   645.146     0.150
    66.261     6.500     0.150
    66.261    11.000     0.150
    66.583   647.047     0.150
    66.583     5.299     0.150
    67.252   651.646     0.150
    67.275   652.646     0.150
    70.803   674.246     0.150
    70.803     8.701     0.150
    70.804   674.447     0.150
    70.804     9.398     0.150
    70.855   674.547     0.150
    70.855     9.600     0.150
    70.910   673.346     0.150
    71.029   675.547     0.150
    71.137   674.646     0.150
    71.201   675.547     0.150
    71.510   677.547     0.150
    71.604   678.047     0.150
    72.479   683.447     0.150
    72.496   685.047     0.150
    72.496     9.600     0.150
    72.496   700.146     0.150
    72.748   684.846     0.150
    72.791   686.146     0.150
    72.981   686.246     0.150
    73.052   686.746     0.150
    73.094   686.846     0.150
    73.239   687.646     0.150
    73.389   688.346     0.150
    73.477   688.846     0.150
    73.620   689.846     0.150
    73.694   690.146     0.150
    73.697   690.146     0.150
    73.774   690.746     0.150
    73.900   691.346     0.150
    73.948   693.047     0.150
    74.143   694.547     0.150
    74.607   695.547     0.150
    75.070   698.346     0.150
    75.239   700.646     0.150
    75.260   700.947     0.150
    75.644   701.146     0.150
    78.236   718.947     0.150
    79.697   725.246     0.150
    80.192   728.246     0.150
    80.192     7.600     0.150
    81.016   732.646     0.150
    82.521   741.646     0.150
    98.700   816.447     0.150
   143.617  1168.646     0.150
   146.949  1179.627     0.150
   146.949  1189.576     0.150
   147.672  1183.646     0.150
   147.735  1182.846     0.150
   147.848  1181.346     0.150
   150.519  1182.217     0.150
   151.048  1185.846     0.150
   151.644  1190.846     0.150
     0.252    11.906     0.150
     0.252    20.195     0.150
     0.641    14.867     0.150
     0.641    26.477     0.150
     0.632    15.016     0.150
     0.632    25.426     0.150
     0.664    15.496     0.150
     0.689    16.055     0.150
     0.689    27.938     0.150
     0.692    15.977     0.150
     0.692    16.137     0.150
     0.692    15.695     0.150
     0.696    16.016     0.150
     0.710    16.105     0.150
     0.996    19.547     0.150
     0.996    33.957     0.150
     1.106    19.645     0.150
     1.151    20.918     0.150
     1.151    36.355     0.150
     1.247    22.516     0.150
     1.410    24.855     0.150
     1.410    43.918     0.150
     1.406    24.508     0.150
     1.414    24.574     0.150
     1.414    43.016     0.150
     1.490    25.406     0.150
     1.490    44.305     0.150
     1.773    28.668     0.150
     1.809    30.477     0.150
     1.890    31.008     0.150
     1.996    31.977     0.150
     2.393    39.016     0.150
     2.516    38.258     0.150
     2.563    38.375     0.150
     2.626    40.758     0.150
     2.629    40.645     0.150
     2.652    41.336     0.150
     2.639    40.406     0.150
     2.664    41.457     0.150
     2.683    41.527     0.150
     2.697    41.406     0.150
     2.757    42.586     0.150
     2.822    42.227     0.150
     3.164    47.227     0.150
     3.190    47.465     0.150
     3.207    47.707     0.150
     3.247    48.145     0.150
     3.281    48.895     0.150
     3.322    49.547     0.150
     3.448    50.734     0.150
     3.469    51.875     0.150
     3.515    52.496     0.150
     3.681    53.918     0.150
     3.681    53.438     0.150
     3.829    56.395     0.150
     3.865    56.367     0.150
     3.883    56.707     0.150
     3.964    57.055     0.150
     4.085    59.938     0.150
     4.094    59.156     0.150
     4.412    63.574     0.150
     4.448    64.734     0.150
     4.424    64.598     0.150
     4.644    67.285     0.150
     5.039    72.695     0.150
     5.052    73.258     0.150
     5.061    73.656     0.150
     5.036    73.496     0.150
     5.280    76.098     0.150
     5.275    75.848     0.150
     5.359    76.926     0.150
     5.537    79.227     0.150
     5.549    79.668     0.150
     5.635    80.137     0.150
     5.693    81.477     0.150
     5.838    83.516     0.150
     5.861    83.477     0.150
     5.858    84.055     0.150
     6.147    87.395     0.150
     6.269    89.816     0.150
     6.299    88.887     0.150
     6.379    90.547     0.150
     6.534    93.688     0.150
     6.517    93.074     0.150
     6.568    93.188     0.150
     6.600    93.246     0.150
     6.592    93.266     0.150
     6.794    95.457     0.150
     6.821    96.438     0.150
     6.821    96.367     0.150
     6.893    98.496     0.150
     6.893   171.598     0.150
     6.966    98.617     0.150
     6.978    98.426     0.150
     7.371   103.875     0.150
     7.417   105.926     0.150
     7.834   109.707     0.150
     8.129   116.336     0.150
     8.691   123.098     0.150
     8.796   122.445     0.150
     9.675   136.195     0.150
     9.675   236.996     0.150
     9.874   136.074     0.150
    13.097   181.695     0.150
    15.797   220.895     0.150
    21.365   281.098     0.150
    30.021   361.098     0.150
    31.419   375.895     0.150
    43.255   472.297     0.150
    44.163   479.895     0.150
    44.561   484.496     0.150
    52.083   539.598     0.150
    60.211   599.195     0.150
    61.108   604.395     0.150
    83.128   737.098     0.150
     0.708    14.125     0.150
     1.487    24.666     0.150
     1.721    28.115     0.150
     2.037    32.115     0.150
     2.037    57.615     0.150
     2.122    33.795     0.150
     2.122    58.266     0.150
     2.145    34.365     0.150
     2.147    34.176     0.150
     2.149    34.225     0.150
     2.151    34.365     0.150
     2.157    34.346     0.150
     2.169    34.525     0.150
     2.402    37.605     0.150
     2.391    36.635     0.150
     2.441    38.025     0.150
     2.570    39.744     0.150
     2.607    40.494     0.150
     2.802    42.744     0.150
     2.864    43.305     0.150
     2.851    43.105     0.150
     2.854    43.525     0.150
     2.877    43.645     0.150
     3.030    46.154     0.150
     3.223    48.195     0.150
     3.541    51.596     0.150
     3.679    53.734     0.150
     3.701    56.055     0.150
     3.882    56.105     0.150
     4.036    58.086     0.150
     4.031    58.865     0.150
     4.037    59.574     0.150
     4.062    60.455     0.150
     4.087    60.324     0.150
     4.070    59.445     0.150
     4.107    60.395     0.150
     4.287    62.035     0.150
     4.314    61.955     0.150
     4.314   108.756     0.150
     4.382    63.725     0.150
     4.479    64.756     0.150
     4.399    61.916     0.150
     4.484    64.955     0.150
     4.865    70.395     0.150
     4.892    69.715     0.150
     4.889    69.855     0.150
     4.889    69.734     0.150
     4.905    70.605     0.150
     5.095    72.936     0.150
     5.266    74.904     0.150
     5.333    76.455     0.150
     5.360    77.055     0.150
     5.430    78.154     0.150
     5.520    78.855     0.150
     5.552    79.766     0.150
     5.880    84.355     0.150
     6.103    87.756     0.150
     6.362    91.064     0.150
     6.435    92.086     0.150
     6.463    91.836     0.150
     6.494    92.564     0.150
     6.468    93.324     0.150
     6.590    93.836     0.150
     6.617    94.475     0.150
     6.809    96.725     0.150
     6.837    97.166     0.150
     6.985    99.295     0.150
     7.242   102.785     0.150
     7.417   105.275     0.150
     7.537   108.555     0.150
     7.670   107.865     0.150
     7.860   111.186     0.150
     7.924   111.195     0.150
     8.162   113.355     0.150
     8.200   114.475     0.150
     8.221   116.936     0.150
     8.797   123.695     0.150
     8.882   125.494     0.150
     9.392   133.055     0.150
     9.686   136.355     0.150
     9.686   240.855     0.150
     9.806   136.516     0.150
    10.144   141.154     0.150
    10.144   249.654     0.150
    14.261   196.256     0.150
    14.261   369.654     0.150
    14.511   199.516     0.150
    21.490   287.256     0.150
    22.685   296.756     0.150
    30.574   368.756     0.150
    30.574   546.055     0.150
    31.042   374.855     0.150
    33.126   393.266     0.150
    33.126    13.039     0.150
    33.122   394.135     0.150
    34.507   404.945     0.150
    37.477   427.975     0.150
    43.234   476.455     0.150
    44.257   485.154     0.150
    44.710   487.256     0.150
    53.545   554.455     0.150
    61.788   613.955     0.150
    62.544   619.955     0.150
    73.759   704.555     0.150
     0.708    14.312     0.150
     0.830    16.672     0.150
     0.830    28.461     0.150
     0.828    17.125     0.150
     0.828    30.422     0.150
     1.144    20.875     0.150
     1.239    22.328     0.150
     1.264    22.914     0.150
     1.266    22.922     0.150
     1.267    23.633     0.150
     1.267    22.586     0.150
     1.267    22.898     0.150
     1.273    22.883     0.150
     1.286    23.008     0.150
     1.568    26.734     0.150
     1.536    26.094     0.150
     1.536    44.898     0.150
     1.682    28.062     0.150
     1.713    28.203     0.150
     1.713    48.812     0.150
     1.871    30.633     0.150
     1.871    53.797     0.150
     1.896    30.633     0.150
     1.932    31.336     0.150
     1.932    54.422     0.150
     1.979    31.867     0.150
     1.979    55.328     0.150
     1.985    31.852     0.150
     2.013    31.984     0.150
     2.192    34.312     0.150
     2.192    58.828     0.150
     2.364    37.016     0.150
     2.440    38.086     0.150
     2.458    38.586     0.150
     2.492    38.984     0.150
     2.917    45.992     0.150
     2.948    43.625     0.150
     2.980    44.664     0.150
     3.056    46.461     0.150
     3.172    48.125     0.150
     3.190    48.125     0.150
     3.178    47.773     0.150
     3.216    48.742     0.150
     3.245    48.031     0.150
     3.232    49.031     0.150
     3.248    49.008     0.150
     3.261    48.711     0.150
     3.318    49.953     0.150
     3.394    51.078     0.150
     3.561    52.023     0.150
     3.633    53.203     0.150
     3.674    54.664     0.150
     3.768    55.602     0.150
     3.866    56.375     0.150
     4.026    59.203     0.150
     4.030    59.508     0.150
     4.030    59.031     0.150
     4.172    60.352     0.150
     4.172    60.008     0.150
     4.228    61.125     0.150
     4.290    61.875     0.150
     4.325    62.875     0.150
     4.344    62.234     0.150
     4.376    63.633     0.150
     4.572    65.844     0.150
     4.629    67.594     0.150
     4.663    67.117     0.150
     4.724    67.992     0.150
     4.684    68.414     0.150
     4.793    69.102     0.150
     4.902    70.945     0.150
     4.944    70.938     0.150
     4.982    72.578     0.150
     5.138    73.734     0.150
     5.169    74.516     0.150
     5.311    76.172     0.150
     5.480    79.703     0.150
     5.701    82.758     0.150
     5.864    84.023     0.150
     5.981    85.672     0.150
     5.985    85.406     0.150
     6.008    85.586     0.150
     6.122    87.461     0.150
     6.446    91.875     0.150
     6.509    93.055     0.150
     6.840    99.156     0.150
     6.882    98.227     0.150
     7.367   103.227     0.150
     7.427   104.375     0.150
     7.427   104.516     0.150
     7.427   104.602     0.150
     7.427   183.203     0.150
     7.544   105.664     0.150
     7.662   109.188     0.150
     7.909   112.062     0.150
     9.899   139.305     0.150
     9.899   245.406     0.150
    10.208   142.008     0.150
    60.788   603.406     0.150
    61.683   610.008     0.150
     0.539    10.531     0.150
     0.457    10.863     0.150
     0.794    15.363     0.150
     1.132    20.062     0.150
     1.149    20.863     0.150
     1.157    20.664     0.150
     1.158    20.172     0.150
     1.162    20.762     0.150
     1.172    20.863     0.150
     1.179    20.961     0.150
     1.209    20.762     0.150
     1.363    23.262     0.150
     1.430    23.664     0.150
     1.428    24.461     0.150
     1.552    25.762     0.150
     1.564    26.262     0.150
     1.578    25.863     0.150
     1.675    26.863     0.150
     1.691    27.363     0.150
     1.777    28.191     0.150
     1.783    28.664     0.150
     1.850    29.461     0.150
     1.828    29.562     0.150
     1.828    52.062     0.150
     1.830    29.164     0.150
     1.846    29.262     0.150
     1.988    32.262     0.150
     2.187    34.262     0.150
     2.259    35.461     0.150
     2.329    36.363     0.150
     2.355    36.664     0.150
     2.362    36.762     0.150
     2.362    65.664     0.150
     2.537    39.062     0.150
     2.578    38.363     0.150
     2.650    41.961     0.150
     2.858    43.664     0.150
     2.893    42.762     0.150
     2.980    45.262     0.150
     2.982    45.262     0.150
     2.991    45.461     0.150
     3.044    46.164     0.150
     3.052    46.102     0.150
     3.060    46.461     0.150
     3.111    46.363     0.150
     3.165    46.461     0.150
     3.196    48.262     0.150
     3.192    47.191     0.150
     3.289    48.262     0.150
     3.349    49.262     0.150
     3.412    50.562     0.150
     3.455    51.164     0.150
     3.507    51.461     0.150
     3.612    51.664     0.150
     3.744    55.262     0.150
     3.815    56.062     0.150
     3.861    56.062     0.150
     3.861    55.543     0.150
     3.893    56.562     0.150
     3.927    57.461     0.150
     3.933    56.863     0.150
     3.966    56.863     0.150
     4.066    59.062     0.150
     4.128    59.062     0.150
     4.249    60.824     0.150
     4.284    61.762     0.150
     4.325    62.562     0.150
     4.378    63.762     0.150
     4.414    63.762     0.150
     4.559    66.062     0.150
     4.691    68.863     0.150
     4.731    68.363     0.150
     4.796    69.262     0.150
     4.902    70.762     0.150
     4.949    71.293     0.150
     5.018    72.863     0.150
     5.088    72.824     0.150
     5.128    74.363     0.150
     5.164    72.961     0.150
     5.338    77.164     0.150
     5.382    77.562     0.150
     5.418    78.164     0.150
     5.598    80.062     0.150
     5.560    79.961     0.150
     5.594    79.961     0.150
     5.622    80.461     0.150
     5.667    82.164     0.150
     5.637    82.664     0.150
     5.715    81.461     0.150
     5.830    83.961     0.150
     5.877    84.461     0.150
     5.838    83.762     0.150
     5.990    85.562     0.150
     6.011    86.062     0.150
     6.041    86.164     0.150
     6.097    87.762     0.150
     6.123    87.762     0.150
     6.178    87.762     0.150
     6.331    90.961     0.150
     6.474    92.762     0.150
     6.529    94.062     0.150
     6.618    93.164     0.150
     6.665    94.461     0.150
     6.761    96.461     0.150
     6.817    96.164     0.150
     6.892    98.164     0.150
     7.045    99.461     0.150
     7.130   100.961     0.150
     7.099   100.062     0.150
     7.154    99.863     0.150
     7.154   178.262     0.150
     7.154   100.363     0.150
     7.259   102.363     0.150
     7.291   103.664     0.150
     7.783   110.062     0.150
     7.866   111.562     0.150
     8.085   114.062     0.150
     9.950   137.461     0.150
    12.008   167.062     0.150
    19.198   258.961     0.150
    21.640   284.062     0.150
    21.640   287.664     0.150
    30.970   386.762     0.150
    52.520   545.461     0.150
    53.664   554.164     0.150
    60.649   603.262     0.150
     0.553    20.282     0.150
     0.553    35.082     0.150
     0.613    20.782     0.150
     0.613    35.782     0.150
     0.617    20.682     0.150
     0.617    36.082     0.150
     0.637    21.082     0.150
     0.637    36.981     0.150
     0.734    21.682     0.150
     0.734    38.881     0.150
     0.824    22.182     0.150
     1.081    24.782     0.150
     1.081    24.981     0.150
     1.090    25.182     0.150
     1.093    25.082     0.150
     1.098    24.501     0.150
     1.103    25.182     0.150
     1.118    25.381     0.150
     1.154    25.182     0.150
     1.154    44.981     0.150
     1.352    27.782     0.150
     1.352    47.981     0.150
     1.471    28.282     0.150
     1.471    49.682     0.150
     1.657    30.401     0.150
     1.677    31.182     0.150
     1.677    54.881     0.150
     1.684    31.282     0.150
     1.684    54.481     0.150
     1.702    31.481     0.150
     1.702    55.682     0.150
     1.751    29.771     0.150
     1.751    32.182     0.150
     1.751    56.782     0.150
     1.923    33.481     0.150
     1.923    59.481     0.150
     2.038    35.481     0.150
     2.038    61.481     0.150
     2.072    35.981     0.150
     2.072    63.182     0.150
     2.144    36.881     0.150
     2.144    64.481     0.150
     2.149    36.981     0.150
     2.180    36.381     0.150
     2.180    63.682     0.150
     2.237    37.981     0.150
     2.306    38.881     0.150
     2.306    67.182     0.150
     2.374    39.682     0.150
     2.368    39.352     0.150
     2.432    39.582     0.150
     2.432    68.582     0.150
     2.449    40.481     0.150
     2.749    44.582     0.150
     2.824    46.881     0.150
     2.837    45.682     0.150
     2.874    46.182     0.150
     2.881    46.582     0.150
     2.900    46.682     0.150
     2.919    46.832     0.150
     2.943    47.381     0.150
     3.017    47.981     0.150
     3.060    48.981     0.150
     3.075    47.251     0.150
     3.230    49.481     0.150
     3.434    52.481     0.150
     3.493    54.682     0.150
     3.493    94.082     0.150
     3.511    53.881     0.150
     3.646    55.282     0.150
     3.685    54.282     0.150
     3.765    56.481     0.150
     3.771    56.782     0.150
     3.931    59.182     0.150
     3.967    58.182     0.150
     4.054    59.881     0.150
     4.153    60.202     0.150
     4.206    63.312     0.150
     4.298    62.782     0.150
     4.346    63.582     0.150
     4.391    64.881     0.150
     4.454    64.981     0.150
     4.485    64.751     0.150
     4.584    66.012     0.150
     4.609    66.682     0.150
     4.616    67.582     0.150
     4.659    66.582     0.150
     4.659   118.082     0.150
     4.839    69.481     0.150
     4.923    71.282     0.150
     4.981    71.881     0.150
     5.029    73.381     0.150
     5.051    73.182     0.150
     5.115    74.282     0.150
     5.139    75.481     0.150
     5.237    76.182     0.150
     5.275    76.782     0.150
     5.291    77.481     0.150
     5.386    77.481     0.150
     5.429    78.381     0.150
     5.477    81.881     0.150
     5.591    81.082     0.150
     5.587    80.782     0.150
     5.639    82.082     0.150
     5.782    83.682     0.150
     5.770    82.282     0.150
     5.832    83.682     0.150
     5.856    84.282     0.150
     6.066    87.481     0.150
     6.085    87.182     0.150
     6.296    89.981     0.150
     6.354    90.481     0.150
     6.457    93.381     0.150
     6.491    93.182     0.150
     6.522    91.682     0.150
     6.636    94.182     0.150
     6.655    93.782     0.150
     6.754    97.082     0.150
     6.855    97.782     0.150
     6.897    96.981     0.150
     7.036    98.582     0.150
     7.201   100.182     0.150
     7.201   175.682     0.150
     7.201   691.282     0.150
     7.201   100.981     0.150
     7.253   101.782     0.150
     7.303   105.082     0.150
     7.284   104.381     0.150
     7.320   104.582     0.150
     7.372   105.171     0.150
     7.735   110.381     0.150
     7.827   110.981     0.150
     8.041   114.082     0.150
     8.157   115.582     0.150
     8.147   112.981     0.150
     9.910   135.082     0.150
    10.702   146.202     0.150
    13.104   183.582     0.150
    13.509   183.782     0.150
    13.995   191.251     0.150
    20.010   261.381     0.150
    20.010   510.682     0.150
    20.010   713.082     0.150
    21.603   275.782     0.150
    32.247   378.082     0.150
    32.247   749.481     0.150
    43.503   468.381     0.150
    45.194   482.981     0.150
    45.645   490.182     0.150
    52.005   531.782     0.150
    52.373   536.981     0.150
    56.212   564.182     0.150
    57.715   574.782     0.150
    60.129   589.881     0.150
    60.394   591.682     0.150
    61.128   596.481     0.150
    72.373   669.182     0.150
    99.528   807.082     0.150
   149.862  1171.582     0.150
     0.466     9.102     0.150
     0.633    12.031     0.150
     1.297    38.234     0.150
     1.409    25.531     0.150
     1.409    44.031     0.150
     1.511    27.336     0.150
     1.511    48.234     0.150
     1.534    27.633     0.150
     1.534    48.531     0.150
     1.539    27.938     0.150
     1.555    27.977     0.150
     1.562    28.234     0.150
     1.576    28.234     0.150
     1.575    28.438     0.150
     1.615    29.031     0.150
     1.787    30.734     0.150
     1.736    30.633     0.150
     1.736    54.836     0.150
     1.763    31.133     0.150
     1.763    53.133     0.150
     1.861    33.531     0.150
     2.016    34.438     0.150
     2.065    35.031     0.150
     2.065    61.633     0.150
     2.068    34.117     0.150
     2.114    35.734     0.150
     2.114    62.031     0.150
     2.117    35.734     0.150
     2.117    61.633     0.150
     2.125    35.836     0.150
     2.129    35.938     0.150
     2.129    62.336     0.150
     2.225    37.234     0.150
     2.225    65.531     0.150
     2.398    38.133     0.150
     2.398    65.531     0.150
     2.516    41.234     0.150
     2.548    41.133     0.150
     2.599    41.438     0.150
     2.581    42.234     0.150
     2.586    41.938     0.150
     2.717    44.836     0.150
     2.754    43.234     0.150
     2.731    43.531     0.150
     2.864    44.133     0.150
     2.864    77.336     0.150
     3.037    47.836     0.150
     3.165    49.133     0.150
     3.165    49.438     0.150
     3.166    49.734     0.150
     3.188    50.031     0.150
     3.236    51.031     0.150
     3.230    50.734     0.150
     3.235    50.836     0.150
     3.334    51.438     0.150
     3.334    88.234     0.150
     3.367    52.633     0.150
     3.404    52.633     0.150
     3.467    53.734     0.150
     3.622    55.594     0.150
     3.726    55.938     0.150
     3.726    96.938     0.150
     3.758    56.836     0.150
     3.758    99.234     0.150
     3.743    58.234     0.150
     3.780    57.234     0.150
     3.804    57.734     0.150
     3.804    57.297     0.150
     3.848    57.438     0.150
     3.848    99.734     0.150
     3.945    60.336     0.150
     3.998    60.336     0.150
     3.998   103.836     0.150
     4.165    62.734     0.150
     4.159    62.227     0.150
     4.272    64.531     0.150
     4.359    65.438     0.150
     4.418    66.836     0.150
     4.437    67.438     0.150
     4.516    68.031     0.150
     4.564    68.234     0.150
     4.955    74.836     0.150
     5.132    77.133     0.150
     5.197    77.133     0.150
     5.291    77.938     0.150
     5.313    77.906     0.150
     5.470    82.133     0.150
     5.471    81.836     0.150
     5.499    81.633     0.150
     5.539    82.438     0.150
     5.493    81.547     0.150
     5.535    81.031     0.150
     5.676    84.133     0.150
     5.677    83.234     0.150
     5.848    86.734     0.150
     5.884    87.133     0.150
     5.873    86.234     0.150
     6.090    89.633     0.150
     6.310    92.734     0.150
     6.583    96.133     0.150
     6.651    96.938     0.150
     7.052   103.133     0.150
     7.146   102.938     0.150
     7.146   181.531     0.150
     7.146   103.438     0.150
     8.012   115.133     0.150
     8.093   117.492     0.150
     9.959   141.938     0.150
    13.122   185.633     0.150
    18.795   258.938     0.150
    30.377   372.633     0.150
    43.742   484.031     0.150
    43.831   484.133     0.150
    44.143   487.336     0.150
    46.077   501.336     0.150
    52.700   552.031     0.150
    59.331   599.234     0.150
    60.830   608.438     0.150
    63.296   625.531     0.150
    77.641   716.938     0.150
    77.845   715.734     0.150
    81.531   737.414     0.150
    81.780   738.914     0.150
    81.877   739.711     0.150
    82.128   740.492     0.150
    82.194   740.156     0.150
    82.229   741.117     0.150
    82.340   741.336     0.150
    82.358   741.812     0.150
    82.751   743.156     0.150
    82.809   743.391     0.150
    84.243   750.234     0.150
     0.243    11.340     0.150
     0.602    14.539     0.150
     0.646    14.637     0.150
     0.646    25.340     0.150
     0.670    15.438     0.150
     0.672    15.539     0.150
     0.672    15.250     0.150
     0.673    15.438     0.150
     0.678    15.539     0.150
     0.692    15.539     0.150
     0.974    19.039     0.150
     0.974    32.738     0.150
     1.061    19.539     0.150
     1.097    19.637     0.150
     1.148    20.539     0.150
     1.148    35.637     0.150
     1.206    21.738     0.150
     1.206    38.340     0.150
     1.309    22.738     0.150
     1.339    22.848     0.150
     1.353    23.340     0.150
     1.371    24.238     0.150
     1.392    24.039     0.150
     1.421    24.137     0.150
     1.448    24.738     0.150
     1.732    28.137     0.150
     1.771    29.840     0.150
     1.849    30.137     0.150
     1.898    30.938     0.150
     1.951    31.539     0.150
     1.970    31.438     0.150
     2.145    33.938     0.150
     2.361    38.539     0.150
     2.468    38.840     0.150
     2.521    37.840     0.150
     2.581    40.039     0.150
     2.601    40.340     0.150
     2.604    40.238     0.150
     2.627    40.938     0.150
     2.640    41.137     0.150
     2.641    40.438     0.150
     2.731    42.137     0.150
     2.781    41.938     0.150
     2.804    43.340     0.150
     3.110    47.340     0.150
     3.128    46.238     0.150
     3.151    46.840     0.150
     3.204    47.137     0.150
     3.244    48.840     0.150
     3.408    50.137     0.150
     3.444    52.137     0.150
     3.482    52.137     0.150
     3.645    53.238     0.150
     3.645    53.117     0.150
     3.729    54.539     0.150
     3.786    55.137     0.150
     3.922    56.137     0.150
     4.057    59.148     0.150
     4.056    59.438     0.150
     4.123    58.738     0.150
     4.241    61.137     0.150
     4.366    62.938     0.150
     4.371    63.039     0.150
     4.410    64.137     0.150
     4.701    69.039     0.150
     4.731    68.340     0.150
     4.816    69.438     0.150
     5.000    72.539     0.150
     5.026    73.039     0.150
     5.037    73.340     0.150
     5.199    75.438     0.150
     5.240    76.039     0.150
     5.325    76.840     0.150
     5.499    79.438     0.150
     5.520    79.637     0.150
     5.592    79.738     0.150
     5.824    83.340     0.150
     5.831    83.840     0.150
     6.056    87.039     0.150
     6.104    86.637     0.150
     6.272    89.039     0.150
     6.306    91.137     0.150
     6.350    89.738     0.150
     6.491    92.137     0.150
     6.495    92.539     0.150
     6.557    93.539     0.150
     6.537    92.637     0.150
     6.753    96.637     0.150
     6.758    95.840     0.150
     6.767    95.738     0.150
     6.862    96.938     0.150
     6.923    98.438     0.150
     6.908    99.039     0.150
     6.948    97.840     0.150
     7.211   102.137     0.150
     7.328   103.539     0.150
     7.318   104.840     0.150
     7.402   105.938     0.150
     7.803   109.738     0.150
    19.273   258.340     0.150
     0.088     1.637     0.150
     0.088     2.938     0.150
     0.173     3.938     0.150
     0.173     6.338     0.150
     0.370     7.537     0.150
     1.053    18.838     0.150
     1.440    47.908     0.150
     1.620    49.938     0.150
     1.521    25.838     0.150
     2.066    33.988     0.150
     2.090    61.338     0.150
     2.312    38.438     0.150
     2.413    40.037     0.150
     2.413    69.838     0.150
     2.576    41.938     0.150
     2.584    42.037     0.150
     2.582    42.137     0.150
     2.669    43.238     0.150
     2.688    44.238     0.150
     2.689    43.938     0.150
     2.725    44.037     0.150
     2.870    44.838     0.150
     2.879    46.137     0.150
     3.189    50.537     0.150
     3.283    52.137     0.150
     3.332    52.938     0.150
     3.336    52.738     0.150
     3.343    53.338     0.150
     3.398    52.957     0.150
     3.508    55.637     0.150
     3.727    57.838     0.150
     3.867    61.537     0.150
     4.082    62.938     0.150
     4.131    63.938     0.150
     4.178    64.238     0.150
     4.275    66.537     0.150
     4.354    65.938     0.150
     4.524    68.738     0.150
     4.524    68.268     0.150
     4.641    70.838     0.150
     4.685    71.838     0.150
     4.690    71.938     0.150
     4.722    71.838     0.150
     4.821    73.438     0.150
     4.883    71.838     0.150
     4.948    74.238     0.150
     4.937    74.938     0.150
     5.091    76.037     0.150
     5.114    77.438     0.150
     5.326    80.037     0.150
     5.330    80.238     0.150
     5.340    79.738     0.150
     5.707    86.238     0.150
     5.683    84.137     0.150
     5.734    86.637     0.150
     5.790    86.537     0.150
     5.924    88.537     0.150
     6.171    91.938     0.150
     6.177    92.738     0.150
     6.277    94.537     0.150
     6.559    96.537     0.150
     6.721    99.037     0.150
     7.103   104.338     0.150
     7.119   104.537     0.150
     7.077   104.037     0.150
     7.156   106.838     0.150
     7.330   107.637     0.150
     7.494   110.037     0.150
     7.502   110.777     0.150
     7.455   109.537     0.150
     7.531   110.137     0.150
     7.641   108.938     0.150
     7.641   111.338     0.150
     7.786   112.738     0.150
     7.873   113.607     0.150
     7.987   116.107     0.150
     7.887   114.338     0.150
     8.150   118.037     0.150
     8.182   118.938     0.150
     8.282   120.338     0.150
     8.586   124.738     0.150
     9.517   136.838     0.150
    10.369   148.338     0.150
    13.119   188.178     0.150
    13.917   195.238     0.150
    20.246   274.738     0.150
    22.623   304.027     0.150
    23.423   311.607     0.150
    23.708   314.158     0.150
    24.224   319.197     0.150
    24.238   319.268     0.150
    24.397   320.658     0.150
    24.543   321.498     0.150
    24.723   324.137     0.150
    25.245   328.828     0.150
    25.545   327.938     0.150
    25.490   330.217     0.150
    27.741   350.898     0.150
    28.560   358.037     0.150
    30.675   377.377     0.150
    31.029   380.037     0.150
    31.070   380.377     0.150
    31.149   381.748     0.150
    31.199   381.998     0.150
    31.948   388.258     0.150
    32.164   389.037     0.150
    32.344   391.588     0.150
    32.980   397.947     0.150
    33.012   398.057     0.150
    33.125   398.938     0.150
    33.936   406.227     0.150
    33.936   564.447     0.150
    34.326   409.508     0.150
    35.501   418.908     0.150
    35.659   417.438     0.150
    35.641   420.248     0.150
    35.641   568.227     0.150
    35.693   420.568     0.150
    35.693   568.727     0.150
    35.720   420.738     0.150
    36.360   426.727     0.150
    36.434   426.727     0.150
    36.487   426.998     0.150
    36.541   427.578     0.150
    39.282   447.637     0.150
    39.604   453.938     0.150
    39.604   579.938     0.150
    40.172   457.748     0.150
    42.103   471.838     0.150
    43.719   484.637     0.150
    43.747   486.838     0.150
    43.815   486.838     0.150
    45.105   494.438     0.150
    45.495   500.137     0.150
    45.495   599.137     0.150
    46.635   508.607     0.150
    47.760   515.938     0.150
    48.689   525.438     0.150
    48.864   526.717     0.150
    48.999   525.738     0.150
    49.040   528.988     0.150
    51.260   543.977     0.150
    52.483   552.537     0.150
    52.508   552.137     0.150
    57.844   590.637     0.150
    57.975   592.637     0.150
    58.119   593.537     0.150
    60.632   608.537     0.150
    60.893   610.938     0.150
    64.488   635.938     0.150
    65.402   642.438     0.150
    69.714   669.438     0.150
    71.837   683.438     0.150
    77.074   712.238     0.150
    77.074   722.938     0.150
    82.539   741.738     0.150
    96.983   810.338     0.150
   100.385   825.938     0.150
   148.083  1185.637     0.150
     0.434    11.485     0.150
     0.743    15.385     0.150
     0.752    15.485     0.150
     0.753    14.965     0.150
     0.757    15.385     0.150
     0.768    15.485     0.150
     0.774    15.585     0.150
     0.939    16.955     0.150
     1.021    18.785     0.150
     1.057    19.385     0.150
     1.057    34.385     0.150
     1.244    22.185     0.150
     1.244    38.585     0.150
     1.280    22.185     0.150
     1.298    21.785     0.150
     1.298    38.285     0.150
     1.373    22.585     0.150
     1.380    23.085     0.150
     1.368    22.485     0.150
     1.368    39.585     0.150
     1.425    23.685     0.150
     1.444    23.885     0.150
     1.574    25.885     0.150
     1.574    45.085     0.150
     1.551    25.785     0.150
     1.551    45.085     0.150
     1.661    28.085     0.150
     1.832    29.685     0.150
     1.862    29.985     0.150
     1.884    30.285     0.150
     1.928    30.885     0.150
     1.928    54.385     0.150
     1.964    31.285     0.150
     1.964    55.585     0.150
     1.965    31.385     0.150
     2.146    33.885     0.150
     2.295    37.485     0.150
     2.345    35.385     0.150
     2.353    35.985     0.150
     2.467    38.585     0.150
     2.587    40.185     0.150
     2.596    40.185     0.150
     2.601    40.385     0.150
     2.626    40.985     0.150
     2.628    39.485     0.150
     2.650    41.185     0.150
     2.661    39.805     0.150
     2.671    41.785     0.150
     2.671    74.385     0.150
     2.806    43.185     0.150
     2.801    41.725     0.150
     2.911    44.985     0.150
     2.997    43.685     0.150
     2.997    76.885     0.150
     3.011    44.685     0.150
     3.028    45.585     0.150
     3.054    46.385     0.150
     3.139    46.985     0.150
     3.252    47.985     0.150
     3.404    50.885     0.150
     3.432    51.285     0.150
     3.544    51.985     0.150
     3.544    51.415     0.150
     3.543    52.485     0.150
     3.603    52.785     0.150
     3.748    54.885     0.150
     3.746    53.885     0.150
     3.760    54.885     0.150
     3.933    56.185     0.150
     3.945    57.115     0.150
     4.065    58.585     0.150
     4.161    60.085     0.150
     4.195    60.585     0.150
     4.279    62.385     0.150
     4.546    65.655     0.150
     4.565    65.985     0.150
     4.598    66.485     0.150
     4.599    67.385     0.150
     4.656    67.985     0.150
     4.779    68.885     0.150
     4.860    70.485     0.150
     5.006    72.285     0.150
     5.034    73.285     0.150
     5.088    74.085     0.150
     5.236    75.385     0.150
     5.257    75.785     0.150
     5.404    77.185     0.150
     5.362    76.385     0.150
     5.477    78.885     0.150
     5.483    78.485     0.150
     5.702    81.485     0.150
     5.734    83.585     0.150
     5.807    83.185     0.150
     5.751    84.785     0.150
     5.894    83.985     0.150
     5.849    86.385     0.150
     5.860    85.785     0.150
     5.951    85.585     0.150
     6.149    90.485     0.150
     6.212    89.985     0.150
     6.246    88.585     0.150
     6.254    89.785     0.150
     6.306    88.985     0.150
     6.342    90.485     0.150
     6.473    91.485     0.150
     6.503    92.685     0.150
     6.686    95.285     0.150
     6.717    95.005     0.150
     6.733    95.285     0.150
     6.805    95.585     0.150
     6.805   169.585     0.150
     6.805    95.885     0.150
     6.982    98.985     0.150
     7.053   100.185     0.150
     7.083   100.285     0.150
     7.378   105.085     0.150
     7.462   106.225     0.150
     7.741   109.285     0.150
     8.352   119.095     0.150
     8.384   120.485     0.150
     9.110   128.585     0.150
     9.133   129.785     0.150
     9.566   132.375     0.150
     9.592   133.085     0.150
    12.003   168.685     0.150
    12.003   296.885     0.150
    12.958   180.285     0.150
    15.035   209.185     0.150
    19.063   257.185     0.150
    19.063   728.685     0.150
    29.616   361.265     0.150
    30.162   366.385     0.150
    31.110   373.955     0.150
    31.110    15.990     0.150
    31.111   373.985     0.150
    33.334   393.985     0.150
    33.334    16.580     0.150
    34.641   404.835     0.150
    34.685   404.695     0.150
    43.277   473.785     0.150
    44.331   483.885     0.150
    44.412   482.485     0.150
    52.119   541.385     0.150
    53.505   553.285     0.150
    58.485   587.785     0.150
    60.248   599.585     0.150
    60.352   601.285     0.150
    72.323   678.585     0.150
    78.708   715.885     0.150
    83.423   739.085     0.150
     0.587    12.273     0.150
     0.587    23.371     0.150
     0.644    12.812     0.150
     0.644    23.172     0.150
     0.892    16.473     0.150
     0.935    17.172     0.150
     0.935    29.371     0.150
     0.939    17.273     0.150
     0.989    17.973     0.150
     0.989    32.473     0.150
     1.018    18.473     0.150
     1.035    18.570     0.150
     1.035    31.773     0.150
     1.234    21.371     0.150
     1.234    37.570     0.150
     1.298    22.273     0.150
     1.298    39.473     0.150
     1.401    23.973     0.150
     1.401    42.973     0.150
     1.425    24.570     0.150
     1.425    44.070     0.150
     1.427    24.672     0.150
     1.427    43.773     0.150
     1.428    24.262     0.150
     1.428    43.570     0.150
     1.429    24.570     0.150
     1.434    24.570     0.150
     1.447    24.672     0.150
     1.674    27.070     0.150
     1.674    47.672     0.150
     1.728    28.473     0.150
     1.817    29.273     0.150
     1.872    30.172     0.150
     1.872    52.773     0.150
     2.010    32.172     0.150
     2.022    32.070     0.150
     2.092    32.523     0.150
     2.092    57.793     0.150
     2.105    33.672     0.150
     2.139    33.773     0.150
     2.145    33.871     0.150
     2.145    59.773     0.150
     2.172    34.070     0.150
     2.320    35.773     0.150
     2.430    38.273     0.150
     2.523    39.371     0.150
     2.568    39.973     0.150
     2.599    40.273     0.150
     2.618    40.871     0.150
     2.652    40.973     0.150
     2.702    41.672     0.150
     2.714    41.672     0.150
     2.892    44.070     0.150
     3.064    44.871     0.150
     3.115    46.070     0.150
     3.330    50.070     0.150
     3.332    49.570     0.150
     3.347    50.172     0.150
     3.348    50.273     0.150
     3.370    49.672     0.150
     3.374    51.172     0.150
     3.391    51.070     0.150
     3.406    50.992     0.150
     3.419    51.570     0.150
     3.476    52.273     0.150
     3.552    53.172     0.150
     3.658    53.070     0.150
     3.682    54.871     0.150
     3.824    56.473     0.150
     3.907    57.273     0.150
     3.988    57.871     0.150
     4.176    61.172     0.150
     4.187    61.773     0.150
     4.311    61.434     0.150
     4.360    62.773     0.150
     4.420    64.773     0.150
     4.413    63.273     0.150
     4.456    63.672     0.150
     4.516    65.273     0.150
     4.596    66.023     0.150
     4.621    65.773     0.150
     4.671    66.570     0.150
     4.709    67.422     0.150
     4.755    67.773     0.150
     4.774    68.070     0.150
     4.819    69.273     0.150
     4.904    70.672     0.150
     5.033    73.070     0.150
     5.031    72.273     0.150
     5.132    74.973     0.150
     5.181    75.371     0.150
     5.175    74.773     0.150
     5.201    76.973     0.150
     5.139    74.812     0.150
     5.228    76.070     0.150
     5.249    76.871     0.150
     5.267    75.570     0.150
     5.284    75.773     0.150
     5.343    78.273     0.150
     5.391    77.473     0.150
     5.425    78.371     0.150
     5.526    81.371     0.150
     5.563    79.871     0.150
     5.636    80.672     0.150
     5.605    80.773     0.150
     5.766    83.172     0.150
     5.784    83.473     0.150
     5.822    83.973     0.150
     6.006    86.473     0.150
     6.006    85.570     0.150
     6.066    86.070     0.150
     6.085    87.070     0.150
     6.087    86.672     0.150
     6.113    89.273     0.150
     6.148    88.570     0.150
     6.205    88.973     0.150
     6.246    89.672     0.150
     6.356    91.473     0.150
     6.459    92.172     0.150
     6.533    93.070     0.150
     6.581    94.273     0.150
     6.809    97.672     0.150
     6.964    99.273     0.150
     7.009    99.570     0.150
     7.075    99.672     0.150
     7.237   102.773     0.150
     7.286   102.172     0.150
     7.390   105.371     0.150
     7.518   106.371     0.150
     7.485   105.094     0.150
     7.499   105.871     0.150
     7.597   107.172     0.150
     7.576   105.973     0.150
     7.576   187.672     0.150
     8.156   117.172     0.150
     8.513   118.570     0.150
     8.710   122.891     0.150
    19.687   264.172     0.150
    33.453   395.113     0.150
    33.453    15.980     0.150
    60.949   605.273     0.150
    73.065   682.371     0.150
    83.416   740.070     0.150
     0.168     6.767     0.150
     0.219     6.747     0.150
     0.875    15.967     0.150
     0.875    28.566     0.150
     1.219    20.967     0.150
     1.219    36.167     0.150
     1.312    21.566     0.150
     1.364    22.866     0.150
     1.364    40.467     0.150
     1.455    23.667     0.150
     1.446    23.866     0.150
     1.585    26.467     0.150
     1.600    26.366     0.150
     1.604    27.167     0.150
     1.662    26.667     0.150
     1.610    27.066     0.150
     1.611    26.417     0.150
     1.615    26.366     0.150
     1.632    27.566     0.150
     1.789    29.267     0.150
     1.887    30.467     0.150
     1.955    31.167     0.150
     1.995    32.066     0.150
     2.027    31.467     0.150
     2.125    33.167     0.150
     2.249    34.767     0.150
     2.239    34.217     0.150
     2.245    35.267     0.150
     2.290    35.967     0.150
     2.291    35.366     0.150
     2.308    35.866     0.150
     2.417    37.767     0.150
     2.649    40.066     0.150
     2.692    41.366     0.150
     2.744    41.767     0.150
     2.791    42.467     0.150
     2.815    42.566     0.150
     2.824    43.167     0.150
     2.937    43.267     0.150
     2.998    45.167     0.150
     3.093    47.667     0.150
     3.272    48.366     0.150
     3.461    50.267     0.150
     3.440    51.366     0.150
     3.440    51.366     0.150
     3.451    51.767     0.150
     3.505    52.667     0.150
     3.512    52.066     0.150
     3.519    53.066     0.150
     3.569    53.366     0.150
     3.618    51.977     0.150
     3.656    54.066     0.150
     3.855    56.667     0.150
     3.873    56.366     0.150
     3.869    56.566     0.150
     4.173    61.267     0.150
     4.215    60.866     0.150
     4.274    61.467     0.150
     4.274    61.137     0.150
     4.301    61.467     0.150
     4.286    61.767     0.150
     4.300    61.866     0.150
     4.440    63.267     0.150
     4.480    64.667     0.150
     4.607    66.366     0.150
     4.598    65.967     0.150
     4.616    66.267     0.150
     4.652    66.906     0.150
     4.745    68.667     0.150
     4.862    69.797     0.150
     4.907    70.467     0.150
     4.809    69.467     0.150
     4.823    71.366     0.150
     4.901    70.767     0.150
     4.943    71.467     0.150
     4.981    71.566     0.150
     5.141    74.267     0.150
     5.137    73.866     0.150
     5.394    76.616     0.150
     5.550    80.366     0.150
     5.560    79.667     0.150
     5.498    79.866     0.150
     5.627    80.167     0.150
     5.731    83.066     0.150
     5.825    83.667     0.150
     5.834    83.566     0.150
     5.894    84.366     0.150
     5.874    84.767     0.150
     5.961    85.167     0.150
     5.975    86.366     0.150
     6.068    87.066     0.150
     6.306    90.267     0.150
     6.298    89.566     0.150
     6.280    89.267     0.150
     6.375    91.066     0.150
     6.515    93.366     0.150
     6.715    96.267     0.150
     6.941    98.866     0.150
     6.938    99.667     0.150
     7.213   102.267     0.150
     7.519   104.646     0.150
     7.543   106.066     0.150
     7.586   105.967     0.150
    19.425   262.467     0.150
    30.885   374.467     0.150
    44.190   484.167     0.150
     0.365     8.953     0.150
     0.425     9.680     0.150
     0.425    18.078     0.150
     1.082    19.078     0.150
     1.901    30.680     0.150
     1.901    53.680     0.150
     1.881    29.578     0.150
     1.949    31.383     0.150
     1.949    55.883     0.150
     1.938    30.977     0.150
     2.001    31.578     0.150
     2.001    55.078     0.150
     1.973    31.977     0.150
     1.973    31.617     0.150
     1.979    32.281     0.150
     1.994    32.281     0.150
     2.019    31.977     0.150
     2.022    31.578     0.150
     2.070    32.680     0.150
     2.272    34.977     0.150
     2.272    60.781     0.150
     2.235    34.883     0.150
     2.235    61.578     0.150
     2.508    38.680     0.150
     2.529    38.977     0.150
     2.529    68.883     0.150
     2.529    38.336     0.150
     2.531    38.883     0.150
     2.531    68.781     0.150
     2.532    38.680     0.150
     2.532    67.180     0.150
     2.577    39.477     0.150
     2.577    69.680     0.150
     2.584    39.578     0.150
     2.586    39.680     0.150
     2.852    41.977     0.150
     2.852    72.281     0.150
     2.965    44.781     0.150
     2.994    45.180     0.150
     3.032    45.180     0.150
     3.055    45.977     0.150
     3.055    81.578     0.150
     3.066    45.883     0.150
     3.218    46.977     0.150
     3.218    82.680     0.150
     3.210    48.883     0.150
     3.260    47.578     0.150
     3.216    47.477     0.150
     3.216    84.078     0.150
     3.471    50.180     0.150
     3.629    52.977     0.150
     3.653    53.680     0.150
     3.723    55.180     0.150
     3.718    55.102     0.150
     3.719    54.883     0.150
     3.721    54.977     0.150
     3.783    55.180     0.150
     3.783    95.977     0.150
     3.758    55.180     0.150
     3.884    56.680     0.150
     3.988    58.180     0.150
     4.033    58.688     0.150
     4.146    59.578     0.150
     4.204    60.578     0.150
     4.204   106.281     0.150
     4.246    60.781     0.150
     4.246   105.281     0.150
     4.229    60.977     0.150
     4.244    61.281     0.150
     4.282    61.680     0.150
     4.282    60.992     0.150
     4.367    63.180     0.150
     4.367   109.680     0.150
     4.436    64.078     0.150
     4.452    64.383     0.150
     4.486    64.781     0.150
     4.546    66.078     0.150
     4.567    66.477     0.150
     4.578    66.383     0.150
     4.628    66.547     0.150
     4.694    68.078     0.150
     4.839    70.078     0.150
     4.872    70.578     0.150
     4.872   122.383     0.150
     4.928    71.281     0.150
     4.983    71.781     0.150
     5.258    72.969     0.150
     5.266    72.883     0.150
     5.396    78.180     0.150
     5.503    79.078     0.150
     5.662    81.078     0.150
     5.668    81.078     0.150
     5.759    81.648     0.150
     5.855    82.383     0.150
     5.912    85.578     0.150
     5.960    85.680     0.150
     6.010    85.883     0.150
     5.972    85.578     0.150
     5.946    83.281     0.150
     5.982    84.383     0.150
     5.983    83.883     0.150
     6.055    86.578     0.150
     6.142    88.078     0.150
     6.237    86.883     0.150
     6.299    89.781     0.150
     6.405    91.578     0.150
     6.561    93.883     0.150
     6.679    96.578     0.150
     7.176   101.977     0.150
     7.172   101.078     0.150
     7.516   105.977     0.150
     7.628   108.477     0.150
     7.628   187.680     0.150
     8.540   120.883     0.150
     8.578   121.383     0.150
     8.991   123.633     0.150
    11.633   163.477     0.150
    13.567   189.281     0.150
    19.076   258.477     0.150
    22.713   299.680     0.150
    30.323   367.578     0.150
    32.950   389.977     0.150
    42.710   472.680     0.150
    43.617   480.977     0.150
    53.191   552.477     0.150
    59.709   597.883     0.150
    60.652   605.680     0.150
    61.321   609.680     0.150
    62.239   616.281     0.150
    66.317   642.680     0.150
    66.547   643.680     0.150
    84.418   746.180     0.150
     0.403    10.145     0.150
     0.875    16.475     0.150
     1.101    19.575     0.150
     1.101    35.375     0.150
     1.128    19.375     0.150
     1.271    21.475     0.150
     1.271    37.675     0.150
     1.458    24.175     0.150
     1.458    42.875     0.150
     1.489    25.175     0.150
     1.489    44.075     0.150
     1.511    25.875     0.150
     1.475    24.274     0.150
     1.475    42.975     0.150
     1.514    25.675     0.150
     1.516    25.254     0.150
     1.519    25.575     0.150
     1.526    25.675     0.150
     1.537    25.575     0.150
     1.785    29.075     0.150
     1.804    29.375     0.150
     1.804    51.774     0.150
     1.970    31.575     0.150
     1.987    32.075     0.150
     2.004    31.375     0.150
     2.163    33.305     0.150
     2.172    33.975     0.150
     2.213    34.575     0.150
     2.213    60.075     0.150
     2.215    34.774     0.150
     2.267    35.274     0.150
     2.267    61.475     0.150
     2.237    34.375     0.150
     2.410    37.975     0.150
     2.583    39.774     0.150
     2.583    70.475     0.150
     2.656    40.875     0.150
     2.678    41.175     0.150
     2.720    41.575     0.150
     2.760    42.075     0.150
     2.760    42.274     0.150
     2.941    44.375     0.150
     2.983    43.975     0.150
     2.983    76.075     0.150
     3.070    47.575     0.150
     3.305    48.575     0.150
     3.305    84.875     0.150
     3.383    50.475     0.150
     3.446    51.475     0.150
     3.457    51.435     0.150
     3.539    51.375     0.150
     3.539    89.175     0.150
     3.487    51.234     0.150
     3.519    52.274     0.150
     3.519    94.575     0.150
     3.704    54.075     0.150
     3.876    56.875     0.150
     3.876   100.875     0.150
     3.915    57.075     0.150
     3.915    98.675     0.150
     4.166    60.675     0.150
     4.298    62.675     0.150
     4.282    61.675     0.150
     4.282    61.475     0.150
     4.310    62.274     0.150
     4.341    62.475     0.150
     4.361    62.475     0.150
     4.361   108.175     0.150
     4.488    64.774     0.150
     4.512    64.274     0.150
     4.659    66.975     0.150
     4.678    67.175     0.150
     4.678   118.375     0.150
     4.693    67.475     0.150
     4.669    66.945     0.150
     4.807    69.175     0.150
     4.807   120.475     0.150
     4.746    67.435     0.150
     4.797    69.375     0.150
     4.901    70.875     0.150
     4.974    71.675     0.150
     5.081    73.274     0.150
     5.081   128.175     0.150
     5.194    74.875     0.150
     5.194   131.375     0.150
     5.277    75.575     0.150
     5.437    78.375     0.150
     5.432    78.075     0.150
     5.538    79.975     0.150
     5.538   140.774     0.150
     5.742    82.975     0.150
     5.690    81.575     0.150
     5.795    82.175     0.150
     5.925    84.975     0.150
     5.972    84.975     0.150
     5.969    84.875     0.150
     5.981    85.375     0.150
     6.063    86.375     0.150
     6.049    86.975     0.150
     6.258    89.274     0.150
     6.396    90.875     0.150
     6.422    91.875     0.150
     6.405    91.075     0.150
     6.639    94.875     0.150
     6.676    95.875     0.150
     6.819    97.375     0.150
     6.950   100.175     0.150
     7.066   100.575     0.150
     7.035    98.675     0.150
     7.240   102.375     0.150
     7.343   103.975     0.150
     7.299   102.675     0.150
     7.336   104.975     0.150
     7.414   104.675     0.150
     7.438   105.975     0.150
     7.498   105.245     0.150
     7.498   183.354     0.150
     7.517   105.675     0.150
     7.576   105.575     0.150
     7.576   187.575     0.150
     8.248   118.274     0.150
     8.508   119.375     0.150
     9.494   133.675     0.150
     9.676   133.774     0.150
    12.252   172.975     0.150
    19.536   262.574     0.150
    19.536   277.675     0.150
    31.067   374.074     0.150
    33.577   395.574     0.150
    52.908   549.175     0.150
    60.367   602.274     0.150
    61.965   613.074     0.150
    72.824   683.975     0.150
    79.472   720.774     0.150
     0.430    13.471     0.150
     0.438    13.871     0.150
     0.438    24.871     0.150
     0.572    14.971     0.150
     0.738    16.570     0.150
     0.738    29.170     0.150
     0.912    18.570     0.150
     0.912    33.471     0.150
     1.051    20.371     0.150
     1.051    35.670     0.150
     1.088    20.170     0.150
     1.088    35.971     0.150
     1.146    19.750     0.150
     1.211    39.170     0.150
     1.324    24.070     0.150
     1.324    41.070     0.150
     1.346    24.570     0.150
     1.346    43.170     0.150
     1.347    24.570     0.150
     1.346    24.371     0.150
     1.350    24.010     0.150
     1.358    24.770     0.150
     1.358    42.670     0.150
     1.365    24.670     0.150
     1.365    42.471     0.150
     1.656    28.471     0.150
     1.656    49.770     0.150
     1.660    27.871     0.150
     1.660    48.670     0.150
     1.960    31.971     0.150
     1.960    56.270     0.150
     2.014    32.340     0.150
     2.014    56.680     0.150
     2.034    33.170     0.150
     2.034    57.371     0.150
     2.051    33.471     0.150
     2.051    58.670     0.150
     2.066    33.770     0.150
     2.066    59.471     0.150
     2.103    33.971     0.150
     2.103    60.570     0.150
     2.128    34.570     0.150
     2.197    34.871     0.150
     2.197    60.971     0.150
     2.453    38.871     0.150
     2.453    70.471     0.150
     2.485    38.371     0.150
     2.485    66.670     0.150
     2.527    40.170     0.150
     2.531    39.971     0.150
     2.531    71.871     0.150
     2.543    40.270     0.150
     2.543    69.670     0.150
     2.560    40.471     0.150
     3.030    45.570     0.150
     3.099    48.570     0.150
     3.235    48.471     0.150
     3.235    85.371     0.150
     3.268    48.070     0.150
     3.284    49.971     0.150
     3.337    50.311     0.150
     3.537    51.971     0.150
     3.838    57.270     0.150
     3.908    57.170     0.150
     3.908    98.270     0.150
     3.926    56.670     0.150
     3.997    59.070     0.150
     4.163    60.371     0.150
     4.223    62.070     0.150
     4.329    61.939     0.150
     4.329   108.781     0.150
     4.396    63.770     0.150
     4.396   111.270     0.150
     4.396    62.600     0.150
     4.443    64.371     0.150
     4.486    65.070     0.150
     4.486   112.871     0.150
     4.582    65.971     0.150
     4.689    67.770     0.150
     4.769    69.371     0.150
     4.769   122.670     0.150
     4.808    70.270     0.150
     4.808   124.070     0.150
     4.811    69.041     0.150
     4.862    68.871     0.150
     4.862    72.070     0.150
     4.931    72.170     0.150
     4.969    71.270     0.150
     4.989    71.371     0.150
     4.989   123.971     0.150
     5.119    73.570     0.150
     5.167    74.371     0.150
     5.219    76.170     0.150
     5.258    76.070     0.150
     5.319    76.371     0.150
     5.340    77.170     0.150
     5.483    78.471     0.150
     5.524    79.270     0.150
     5.702    81.770     0.150
     5.702   142.770     0.150
     5.758    82.570     0.150
     5.963    84.570     0.150
     5.996    86.570     0.150
     6.069    86.570     0.150
     6.231    88.971     0.150
     6.256    91.070     0.150
     6.332    89.971     0.150
     6.404    90.971     0.150
     6.404   160.371     0.150
     6.506    92.670     0.150
     6.523    92.471     0.150
     6.579    93.770     0.150
     6.807    98.371     0.150
     6.823    96.670     0.150
     6.964    97.570     0.150
     7.060    98.670     0.150
     7.143   100.570     0.150
     7.268   103.570     0.150
     7.263   102.770     0.150
     7.464   104.000     0.150
     7.466   104.371     0.150
     7.592   107.770     0.150
     7.583   105.971     0.150
     7.583   189.270     0.150
     7.882   111.570     0.150
     7.973   112.270     0.150
     7.967   114.170     0.150
     7.989   113.471     0.150
     8.042   113.570     0.150
     8.185   113.971     0.150
     8.208   116.170     0.150
    12.864   180.570     0.150
    13.810   190.371     0.150
    19.991   265.469     0.150
    19.991   725.172     0.150
    24.173   309.672     0.150
    30.182   364.449     0.150
    30.655   368.770     0.150
    30.655    22.000     0.150
    31.793   377.461     0.150
    31.793   377.270     0.150
    31.793    21.801     0.150
    33.773   394.332     0.150
    33.951   396.262     0.150
    34.186   397.371     0.150
    35.349   408.172     0.150
    35.989   413.070     0.150
    37.873   428.719     0.150
    43.377   474.570     0.150
    43.818   475.371     0.150
    43.818   581.270     0.150
    44.188   479.270     0.150
    45.369   487.270     0.150
    45.369   586.172     0.150
    45.369   809.871     0.150
    45.119   488.770     0.150
    45.260   488.570     0.150
    48.115   512.492     0.150
    48.507   513.789     0.150
    52.625   613.270     0.150
    52.857   545.172     0.150
    56.785   573.570     0.150
    58.426   585.871     0.150
    79.479   717.570     0.150
    82.913   733.672     0.150
     0.521    14.762     0.150
     0.521    25.465     0.150
     0.732    16.762     0.150
     0.732    28.965     0.150
     0.906    18.363     0.150
     0.906    32.465     0.150
     0.884    18.262     0.150
     0.884    32.262     0.150
     0.938    19.164     0.150
     0.960    19.664     0.150
     0.962    19.465     0.150
     0.962    19.664     0.150
     0.962    34.164     0.150
     0.964    19.664     0.150
     0.971    19.664     0.150
     0.980    19.762     0.150
     0.964    19.164     0.150
     0.964    32.965     0.150
     1.116    19.574     0.150
     1.271    23.363     0.150
     1.326    23.562     0.150
     1.326    40.863     0.150
     1.579    26.965     0.150
     1.579    48.262     0.150
     1.633    27.543     0.150
     1.651    27.062     0.150
     1.673    28.262     0.150
     1.673    49.363     0.150
     1.685    28.562     0.150
     1.721    28.762     0.150
     1.742    29.664     0.150
     1.822    29.863     0.150
     2.106    33.164     0.150
     2.106    57.965     0.150
     2.116    34.262     0.150
     2.137    34.863     0.150
     2.150    34.965     0.150
     2.163    35.062     0.150
     2.184    35.164     0.150
     2.250    36.062     0.150
     2.706    43.465     0.150
     2.760    41.812     0.150
     2.895    42.965     0.150
     2.895    76.562     0.150
     2.879    44.465     0.150
     2.904    44.562     0.150
     2.930    44.762     0.150
     2.935    45.363     0.150
     2.975    45.863     0.150
     3.154    47.164     0.150
     3.522    51.863     0.150
     3.605    53.562     0.150
     3.781    55.262     0.150
     3.781    96.562     0.150
     3.830    57.762     0.150
     4.004    58.562     0.150
     4.096    59.562     0.150
     4.198    60.664     0.150
     4.205    61.664     0.150
     4.296    61.363     0.150
     4.334    63.164     0.150
     4.382    65.062     0.150
     4.496    63.863     0.150
     4.577    66.883     0.150
     4.744    68.863     0.150
     5.105    73.363     0.150
     5.181    74.863     0.150
     5.334    77.863     0.150
     5.332    77.262     0.150
     5.363    77.164     0.150
     5.676    81.363     0.150
     6.014    86.363     0.150
     6.068    86.664     0.150
     6.068   150.762     0.150
     6.161    87.965     0.150
     6.188    88.762     0.150
     6.472    91.863     0.150
     6.472   159.465     0.150
     6.583    92.863     0.150
     6.777    95.664     0.150
     6.923    99.062     0.150
     7.079   100.262     0.150
     7.195   101.262     0.150
     7.195   177.363     0.150
     7.571   106.965     0.150
     7.672   108.164     0.150
     8.137   114.762     0.150
    13.417   185.965     0.150
    19.642   261.465     0.150
    31.631   376.062     0.150
    33.903   395.262     0.150
    44.893   485.363     0.150
    45.009   487.762     0.150
    48.252   510.762     0.150
    82.982   734.664     0.150
     0.763    14.545     0.150
     0.763    26.045     0.150
     0.782    14.064     0.150
     1.255    21.445     0.150
     1.312    22.145     0.150
     1.475    24.445     0.150
     1.623    26.945     0.150
     1.623    45.645     0.150
     2.034    32.846     0.150
     2.061    32.916     0.150
     2.238    34.545     0.150
     2.497    38.346     0.150
     2.569    39.645     0.150
     2.724    41.326     0.150
     3.935    58.096     0.150
     3.972    58.475     0.150
     4.096    58.545     0.150
     4.271    61.256     0.150
     4.296    60.945     0.150
     4.372    63.045     0.150
     4.416    62.445     0.150
     4.478    64.846     0.150
     4.766    69.045     0.150
     4.848    69.746     0.150
     4.883    69.615     0.150
     4.989    71.846     0.150
     5.047    72.045     0.150
     5.269    75.166     0.150
     5.337    75.645     0.150
     5.381    76.846     0.150
     5.754    82.936     0.150
     6.129    88.246     0.150
     6.923    97.586     0.150
     7.534   106.246     0.150
     8.094   113.756     0.150
     8.175   114.645     0.150
     8.788   125.916     0.150
     9.216   130.686     0.150
     9.975   137.375     0.150
    12.631   177.045     0.150
    12.631   314.145     0.150
    14.275   198.445     0.150
    14.354   201.445     0.150
    20.034   269.945     0.150
    21.051   283.855     0.150
    21.514   288.295     0.150
    21.624   289.055     0.150
    21.944   292.496     0.150
    22.029   293.275     0.150
    22.074   294.535     0.150
    22.457   298.064     0.150
    22.579   299.506     0.150
    22.625   299.775     0.150
    22.751   299.416     0.150
    23.289   306.525     0.150
    23.635   308.865     0.150
    23.635   309.846     0.150
    23.679   309.826     0.150
    24.503   318.234     0.150
    25.147   324.385     0.150
    27.101   601.445     0.150
    27.655   346.246     0.150
    28.098   349.426     0.150
    29.660   364.365     0.150
    29.756   364.645     0.150
    29.919   367.045     0.150
    30.559   371.615     0.150
    30.969   375.855     0.150
    31.234   378.346     0.150
    32.020   385.295     0.150
    32.652   390.586     0.150
    32.794   392.525     0.150
    32.900   393.256     0.150
    33.309   395.295     0.150
    33.948   400.545     0.150
    33.948    10.900     0.150
    36.876   421.645     0.150
    37.632   431.035     0.150
    38.591   441.135     0.150
    38.593   441.076     0.150
    38.593   442.145     0.150
    38.593    10.000     0.150
    40.903   456.846     0.150
    42.834   475.635     0.150
    43.187   475.545     0.150
    44.456   489.535     0.150
    44.457   490.145     0.150
    44.457     9.900     0.150
    44.627   488.145     0.150
    44.627     9.400     0.150
    45.389   495.445     0.150
    45.742   493.645     0.150
    45.790   498.436     0.150
    46.308   499.645     0.150
    47.724   514.855     0.150
    48.076   515.895     0.150
    48.626   936.445     0.150
    48.626   520.145     0.150
    49.612   527.355     0.150
    49.888   528.445     0.150
    50.076   529.445     0.150
    50.515   533.945     0.150
    50.915   536.426     0.150
    53.474   554.346     0.150
    53.454   554.746     0.150
    53.454    12.100     0.150
    57.501   583.445     0.150
    57.521   584.346     0.150
    59.077   594.045     0.150
    59.119   595.846     0.150
    59.458   597.645     0.150
    59.458  1084.545     0.150
    60.911   607.846     0.150
    61.395   610.945     0.150
    61.395   611.145     0.150
    61.395    12.500     0.150
    61.395   654.846     0.150
    61.582   612.145     0.150
    61.582    11.900     0.150
    61.909   614.945     0.150
    61.909  1116.445     0.150
    62.349   617.445     0.150
    62.349  1111.445     0.150
    62.513   618.645     0.150
    62.916   621.445     0.150
    63.674   625.445     0.150
    65.205   637.445     0.150
    65.683   639.346     0.150
    65.789   639.945     0.150
    66.564   644.945     0.150
    66.956   648.445     0.150
    67.623   651.445     0.150
    67.623     9.500     0.150
    67.623   678.645     0.150
    67.623  1175.645     0.150
    70.851   672.246     0.150
    71.192   674.445     0.150
    72.635   683.346     0.150
    73.401   687.945     0.150
    73.466   688.246     0.150
    73.520   688.445     0.150
    73.695   689.945     0.150
    73.748   689.846     0.150
    73.999   691.145     0.150
    74.127   692.145     0.150
    74.134   691.246     0.150
    74.277   693.045     0.150
    74.372   693.445     0.150
    74.372    17.199     0.150
    74.518   694.246     0.150
    74.668   695.246     0.150
    74.831   696.246     0.150
    74.947   697.045     0.150
    75.002   697.346     0.150
    75.080   698.246     0.150
    75.083   697.945     0.150
    75.419   700.246     0.150
    75.675   700.945     0.150
    75.899   702.445     0.150
    76.133   703.846     0.150
    76.605   706.645     0.150
    77.024   709.746     0.150
    77.645   712.945     0.150
    77.701   712.945     0.150
    77.960   714.045     0.150
    78.172   715.045     0.150
    78.172   724.846     0.150
    78.172    12.900     0.150
    78.172  1308.145     0.150
    78.218   715.846     0.150
    79.180   720.445     0.150
    79.180    16.000     0.150
    80.073   726.246     0.150
    80.073    10.799     0.150
    80.999   730.445     0.150
    81.209   731.826     0.150
    81.583   734.225     0.150
    81.684   734.445     0.150
    81.850   734.945     0.150
    81.929   735.326     0.150
    81.982   735.805     0.150
    81.989   735.725     0.150
    82.032   735.686     0.150
    82.082   736.426     0.150
    82.516   738.465     0.150
    82.560   738.686     0.150
    82.630   738.445     0.150
    83.047   742.145     0.150
    83.047    11.201     0.150
    83.649   743.645     0.150
    83.649    12.301     0.150
   117.392  1120.346     0.150
   147.136  1177.145     0.150
   147.726  1177.756     0.150
   151.308  1188.545     0.150
   151.308  1194.746     0.150
     0.539    11.504     0.150
     0.539    19.203     0.150
     0.710    13.422     0.150
     0.710    23.113     0.150
     1.272    22.602     0.150
     1.259    22.004     0.150
     1.259    39.402     0.150
     1.392    24.504     0.150
     1.431    24.801     0.150
     1.449    26.402     0.150
     1.449    45.203     0.150
     1.458    25.402     0.150
     1.542    25.801     0.150
     1.469    26.402     0.150
     1.469    44.203     0.150
     1.571    26.504     0.150
     1.571    46.504     0.150
     1.624    27.902     0.150
     1.624    49.902     0.150
     1.653    27.902     0.150
     1.783    29.801     0.150
     1.694    28.102     0.150
     1.831    30.004     0.150
     1.898    31.504     0.150
     1.904    31.402     0.150
     1.946    31.703     0.150
     1.948    32.004     0.150
     1.974    32.102     0.150
     2.029    32.602     0.150
     2.029    63.102     0.150
     2.064    33.301     0.150
     2.120    33.801     0.150
     2.328    36.801     0.150
     2.266    36.004     0.150
     2.394    37.504     0.150
     2.397    37.801     0.150
     2.397    72.301     0.150
     2.501    38.203     0.150
     2.486    40.004     0.150
     2.619    39.504     0.150
     2.967    45.402     0.150
     2.992    46.004     0.150
     3.081    46.504     0.150
     3.155    47.703     0.150
     3.369    50.504     0.150
     3.476    51.402     0.150
     3.505    51.902     0.150
     3.527    52.504     0.150
     3.555    52.703     0.150
     3.555    52.152     0.150
     3.602    52.801     0.150
     3.502    52.602     0.150
     3.759    55.801     0.150
     3.771    55.902     0.150
     3.771    95.102     0.150
     3.907    58.004     0.150
     3.959    58.703     0.150
     4.058    60.203     0.150
     4.131    60.602     0.150
     4.164    61.902     0.150
     4.164   107.004     0.150
     4.199    62.504     0.150
     4.292    63.004     0.150
     4.314    63.602     0.150
     4.702    69.902     0.150
     4.888    71.902     0.150
     4.880    72.402     0.150
     5.050    73.703     0.150
     5.217    77.703     0.150
     5.155    74.602     0.150
     5.248    76.902     0.150
     5.237    77.004     0.150
     5.324    77.902     0.150
     5.448    78.902     0.150
     5.448   135.801     0.150
     5.595    82.004     0.150
     5.681    82.801     0.150
     5.630    82.203     0.150
     5.704    83.242     0.150
     5.866    85.102     0.150
     5.755    85.102     0.150
     6.010    87.102     0.150
     6.109    87.402     0.150
     6.276    90.301     0.150
     6.442    93.102     0.150
     6.376    92.801     0.150
     6.551    94.102     0.150
     6.650    95.004     0.150
     6.648    97.203     0.150
     6.797    97.602     0.150
     6.862    98.223     0.150
     6.899    98.602     0.150
     6.899   173.902     0.150
     6.900    99.102     0.150
     7.813   112.203     0.150
     7.886   113.504     0.150
    11.324   160.801     0.150
    18.579   254.602     0.150
    30.300   370.102     0.150
    37.925   434.004     0.150
    43.603   480.402     0.150
    43.700   483.801     0.150
    43.917   483.602     0.150
    52.477   548.203     0.150
    60.271   605.203     0.150
    60.607   606.703     0.150
    61.371   612.504     0.150
    63.933   628.402     0.150
     0.508    10.530     0.150
     0.603    13.179     0.150
     1.209    21.729     0.150
     1.343    23.330     0.150
     1.412    24.830     0.150
     1.412    44.129     0.150
     1.448    25.229     0.150
     1.433    25.330     0.150
     1.433    44.629     0.150
     1.439    25.429     0.150
     1.403    24.830     0.150
     1.403    44.429     0.150
     1.452    25.530     0.150
     1.484    25.830     0.150
     1.620    26.830     0.150
     1.624    27.830     0.150
     1.915    31.429     0.150
     1.915    54.830     0.150
     2.010    32.629     0.150
     2.010    60.830     0.150
     2.267    36.030     0.150
     2.307    36.719     0.150
     2.359    37.330     0.150
     2.425    38.429     0.150
     2.425    71.629     0.150
     2.427    38.030     0.150
     2.550    41.030     0.150
     2.595    39.330     0.150
     2.729    40.629     0.150
     2.978    45.760     0.150
     3.080    46.530     0.150
     3.147    48.320     0.150
     3.239    48.530     0.150
     3.480    51.729     0.150
     3.494    52.330     0.150
     3.576    54.030     0.150
     3.582    52.229     0.150
     3.619    53.429     0.150
     3.640    53.830     0.150
     3.640    53.729     0.150
     3.711    53.830     0.150
     3.845    57.030     0.150
     3.871    56.830     0.150
     3.997    59.030     0.150
     4.023    59.129     0.150
     4.071    59.629     0.150
     4.221    61.929     0.150
     4.261    62.830     0.150
     4.419    64.629     0.150
     4.802    70.729     0.150
     5.168    75.320     0.150
     5.160    74.429     0.150
     5.336    77.429     0.150
     5.692    82.330     0.150
     5.591    82.290     0.150
     6.392    94.229     0.150
     6.938    99.300     0.150
     6.980    99.229     0.150
     6.980   174.588     0.150
     7.931   112.760     0.150
     8.904   124.429     0.150
    11.431   161.836     0.150
    11.431   284.278     0.150
    12.967   182.205     0.150
    18.692   256.743     0.150
    18.692   522.128     0.150
    21.667   291.350     0.150
    22.388   297.899     0.150
    22.450   298.340     0.150
    22.760   301.030     0.150
    23.540   309.770     0.150
    23.740   311.990     0.150
    24.647   320.929     0.150
    25.640   329.590     0.150
    26.045   332.540     0.150
    27.326   344.030     0.150
    28.785   357.449     0.150
    28.894   358.990     0.150
    28.989   359.270     0.150
    30.068   369.689     0.150
    30.386   370.979     0.150
    30.612   373.179     0.150
    31.841   384.629     0.150
    32.216   388.250     0.150
    32.216   554.639     0.150
    32.335   387.780     0.150
    32.335   553.570     0.150
    32.584   391.040     0.150
    32.756   390.804     0.150
    32.756     9.486     0.150
    33.753   400.830     0.150
    33.894   402.169     0.150
    33.941   400.959     0.150
    34.121   404.260     0.150
    34.121     9.220     0.150
    34.733   409.600     0.150
    34.968   411.300     0.150
    34.968    10.570     0.150
    36.443   422.619     0.150
    37.862   435.869     0.150
    37.862    13.170     0.150
    37.862   570.770     0.150
    37.854   436.270     0.150
    40.452   455.629     0.150
    41.962   469.320     0.150
    42.071   467.929     0.150
    43.421   479.129     0.150
    43.421   587.109     0.150
    43.664   480.760     0.150
    43.664     9.538     0.150
    43.774   484.699     0.150
    43.774   484.983     0.150
    44.838   491.139     0.150
    45.911   499.669     0.150
    47.261   511.750     0.150
    47.418   511.889     0.150
    49.557   528.728     0.150
    50.696   534.729     0.150
    51.550   543.439     0.150
    51.640   543.760     0.150
    52.534   549.039     0.150
    52.534     9.101     0.150
    54.242   563.029     0.150
    56.065   575.350     0.150
    58.050   588.729     0.150
    59.210   598.056     0.150
    59.995   602.429     0.150
    60.341   604.629     0.150
    60.341   604.753     0.150
    60.664   607.054     0.150
    63.147   623.280     0.150
    63.147     9.130     0.150
    64.018   632.280     0.150
    65.981   642.729     0.150
    66.314   644.729     0.150
    66.824   647.080     0.150
    66.824     9.860     0.150
    70.301   669.729     0.150
    70.349   670.030     0.150
    70.645   672.229     0.150
    70.651   672.530     0.150
    70.651     9.700     0.150
    70.683   672.129     0.150
    70.795   672.429     0.150
    70.900   673.429     0.150
    71.021   673.729     0.150
    71.088   674.429     0.150
    71.362   678.850     0.150
    71.332   676.729     0.150
    71.551   678.429     0.150
    72.340   683.229     0.150
    72.340     9.500     0.150
    72.413   683.030     0.150
    72.413     9.500     0.150
    72.614   683.729     0.150
    72.634   684.455     0.150
    72.634    10.268     0.150
    72.838   686.859     0.150
    72.868   685.229     0.150
    72.939   685.830     0.150
    72.968   685.830     0.150
    73.353   687.929     0.150
    73.498   688.830     0.150
    73.572   689.129     0.150
    73.654   689.729     0.150
    73.683   691.129     0.150
    73.942   692.030     0.150
    74.035   693.330     0.150
    74.195   694.030     0.150
    74.309   696.030     0.150
    74.351   695.030     0.150
    74.952   697.530     0.150
    75.027   698.429     0.150
    75.446   700.629     0.150
    75.568   701.429     0.150
    75.885   703.229     0.150
    76.516   706.629     0.150
    77.484   710.869     0.150
    77.955   716.729     0.150
    78.827   720.179     0.150
    78.827    10.277     0.150
    80.016   726.229     0.150
    80.016     9.500     0.150
    80.715   730.229     0.150
    80.715    10.200     0.150
    80.842   730.729     0.150
    80.842     9.500     0.150
    81.789   735.790     0.150
    82.103   737.219     0.150
    82.102   737.090     0.150
    82.135   737.729     0.150
    82.181   737.590     0.150
    82.264   737.939     0.150
    82.268   738.030     0.150
    82.358   738.780     0.150
    82.576   739.479     0.150
    82.716   740.070     0.150
    82.872   740.840     0.150
    84.194   747.878     0.150
    84.194    10.351     0.150
   116.323  1119.565     0.150
   148.044  1180.530     0.150
   150.343  1187.315     0.150
   150.343  1194.166     0.150
   161.499  1240.729     0.150
   161.902  1241.668     0.150
     0.098    15.072     0.150
     0.098    26.471     0.150
     0.095    14.971     0.150
     0.095    26.172     0.150
     0.344    15.371     0.150
     0.344    27.172     0.150
     0.548    16.672     0.150
     0.567    16.971     0.150
     0.567    29.172     0.150
     0.798    19.172     0.150
     0.798    33.971     0.150
     1.157    23.871     0.150
     1.157    40.971     0.150
     1.174    23.871     0.150
     1.175    23.672     0.150
     1.175    41.672     0.150
     1.450    24.281     0.150
     1.470    27.172     0.150
     1.470    46.771     0.150
     1.809    31.471     0.150
     1.809    53.672     0.150
     1.833    31.672     0.150
     1.858    31.971     0.150
     1.858    54.971     0.150
     1.902    32.471     0.150
     1.902    55.572     0.150
     2.166    34.971     0.150
     2.166    61.672     0.150
     2.439    38.271     0.150
     2.687    42.471     0.150
     3.082    47.771     0.150
     3.081    48.371     0.150
     3.473    51.971     0.150
     3.872    57.371     0.150
     3.938    57.771     0.150
     3.938   100.271     0.150
     4.065    59.971     0.150
     4.099    59.771     0.150
     4.264    61.711     0.150
     4.389    63.281     0.150
     4.509    64.771     0.150
     4.527    65.771     0.150
     4.524    67.191     0.150
     4.535    64.371     0.150
     4.570    66.672     0.150
     4.632    66.471     0.150
     4.696    68.572     0.150
     4.688    67.572     0.150
     4.688   118.971     0.150
     4.798    70.271     0.150
     4.844    69.072     0.150
     4.928    70.971     0.150
     4.890    71.971     0.150
     4.940    72.371     0.150
     4.976    72.871     0.150
     5.067    72.672     0.150
     5.079    73.072     0.150
     5.098    73.572     0.150
     5.074    73.572     0.150
     5.212    75.371     0.150
     5.237    76.971     0.150
     5.277    76.672     0.150
     5.336    77.072     0.150
     5.367    78.072     0.150
     5.429    77.672     0.150
     5.462    78.871     0.150
     5.485    78.971     0.150
     5.555    80.371     0.150
     5.574    81.072     0.150
     5.666    81.971     0.150
     5.740    82.971     0.150
     5.766    82.371     0.150
     5.912    84.172     0.150
     5.921    85.271     0.150
     6.024    85.971     0.150
     6.311    90.172     0.150
     6.296    89.871     0.150
     6.386    91.271     0.150
     6.399    92.072     0.150
     6.399   160.371     0.150
     6.447    92.271     0.150
     6.461    91.871     0.150
     6.532    93.371     0.150
     6.557    94.471     0.150
     6.735    94.971     0.150
     6.837    97.471     0.150
     6.837   167.072     0.150
     6.882    97.471     0.150
     7.065    98.871     0.150
     7.073    99.471     0.150
     7.233   103.771     0.150
     7.250   101.771     0.150
     7.294   104.172     0.150
     7.385   105.072     0.150
     7.386   103.021     0.150
     7.386   182.441     0.150
     7.665   109.172     0.150
     7.661   109.641     0.150
     7.964   112.771     0.150
     8.331   116.371     0.150
     9.265   129.172     0.150
    12.991   182.121     0.150
    12.991   322.445     0.150
    20.005   264.221     0.150
    32.032   377.771     0.150
    34.305   396.053     0.150
    45.232   486.146     0.150
    45.396   487.662     0.150
    52.601   542.521     0.150
   150.166  1177.094     0.150
     0.906    16.219     0.150
     0.927    16.527     0.150
     1.006    17.898     0.150
     1.039    18.219     0.150
     1.084    18.789     0.150
     0.982    17.777     0.150
     1.013    18.207     0.150
     1.271    21.637     0.150
     1.835    29.387     0.150
     2.028    32.676     0.150
     2.052    33.398     0.150
     2.058    33.195     0.150
     2.074    33.695     0.150
     2.361    37.316     0.150
     2.438    37.637     0.150
     2.678    41.266     0.150
     2.676    41.445     0.150
     2.683    41.098     0.150
     2.727    42.027     0.150
     2.770    42.578     0.150
     2.779    42.906     0.150
     2.810    42.887     0.150
     2.981    44.867     0.150
     3.097    47.297     0.150
     3.163    48.168     0.150
     3.207    48.559     0.150
     3.256    49.406     0.150
     3.284    49.727     0.150
     3.341    50.258     0.150
     3.361    50.238     0.150
     3.831    56.809     0.150
     3.780    55.129     0.150
     3.995    58.789     0.150
     4.018    59.605     0.150
     4.028    58.387     0.150
     4.123    60.848     0.150
     4.276    61.008     0.150
     4.396    63.605     0.150
     4.464    65.086     0.150
     4.573    66.309     0.150
     4.642    66.879     0.150
     4.640    67.348     0.150
     4.737    69.457     0.150
     4.842    69.668     0.150
     4.978    70.938     0.150
     5.183    74.477     0.150
     5.249    74.176     0.150
     5.240    76.867     0.150
     5.394    76.836     0.150
     5.441    78.637     0.150
     5.428    77.355     0.150
     5.640    81.336     0.150
     5.662    81.816     0.150
     5.634    80.617     0.150
     5.693    81.398     0.150
     5.754    82.148     0.150
     5.810    83.488     0.150
     5.928    84.695     0.150
     5.972    84.969     0.150
     6.263    89.469     0.150
     6.473    92.957     0.150
     6.563    94.016     0.150
     6.772    96.797     0.150
     6.906    97.746     0.150
     7.126   100.926     0.150
     7.546   106.977     0.150
     8.040   113.156     0.150
     8.144   113.496     0.150
     8.156   114.078     0.150
     8.240   115.855     0.150
     8.240   206.500     0.150
     8.661   122.258     0.150
     8.747   123.637     0.150
     9.177   128.738     0.150
    10.150   141.289     0.150
    11.020   152.398     0.150
    12.897   181.484     0.150
    14.044   196.367     0.150
    14.388   199.168     0.150
    20.257   271.500     0.150
    20.553   274.469     0.150
    20.553   498.367     0.150
    20.484   276.379     0.150
    20.867   281.047     0.150
    23.795   310.258     0.150
    23.926   311.949     0.150
    25.427   325.629     0.150
    26.384   334.488     0.150
    26.810   334.719     0.150
    26.969   339.207     0.150
    27.946   347.066     0.150
    28.245   350.719     0.150
    28.533   354.246     0.150
    29.865   364.469     0.150
    29.950   366.648     0.150
    29.948   366.758     0.150
    30.047   367.457     0.150
    30.128   368.492     0.150
    30.201   368.586     0.150
    30.425   371.617     0.150
    30.497   370.355     0.150
    30.700   373.438     0.150
    30.838   374.969     0.150
    31.260   377.918     0.150
    31.260    13.801     0.150
    31.525   379.719     0.150
    31.614   380.477     0.150
    32.225   384.578     0.150
    32.302   386.516     0.150
    32.364   389.176     0.150
    32.424   387.629     0.150
    32.524   389.266     0.150
    33.280   390.129     0.150
    33.188   395.418     0.150
    33.598   397.695     0.150
    33.610   399.488     0.150
    33.596   398.398     0.150
    33.667   398.957     0.150
    33.800   400.406     0.150
    34.794   407.777     0.150
    34.857   408.695     0.150
    34.934   410.086     0.150
    35.722   415.777     0.150
    35.743   416.047     0.150
    35.886   418.289     0.150
    36.627   418.766     0.150
    37.902   433.008     0.150
    38.678   440.066     0.150
    38.716   442.227     0.150
    38.881   443.168     0.150
    39.212   446.039     0.150
    39.404   447.516     0.150
    39.597   447.945     0.150
    42.109   469.418     0.150
    42.911   472.266     0.150
    43.226   475.066     0.150
    43.226    16.699     0.150
    43.125   476.816     0.150
    43.715  1071.527     0.150
    44.596   486.223     0.150
    44.745   490.586     0.150
    44.745   490.719     0.150
    45.865   499.566     0.150
    46.079   499.406     0.150
    48.336   515.266     0.150
    48.363   516.426     0.150
    48.397   517.668     0.150
    48.735   517.816     0.150
    48.732   520.246     0.150
    48.740   520.477     0.150
    49.791   526.469     0.150
    49.872   529.746     0.150
    50.014   529.809     0.150
    52.168   544.969     0.150
    52.940   551.578     0.150
    53.184   552.719     0.150
    53.396   552.566     0.150
    53.396    18.301     0.150
    53.411   553.469     0.150
    54.076   557.668     0.150
    54.884   564.066     0.150
    55.154   567.867     0.150
    55.214   567.367     0.150
    55.214    14.699     0.150
    57.220   581.867     0.150
    57.240   581.629     0.150
    58.844   592.867     0.150
    58.876   591.367     0.150
    58.876  1071.867     0.150
    58.876  1098.867     0.150
    59.149   594.617     0.150
    60.865   606.066     0.150
    60.866   606.867     0.150
    61.392   610.266     0.150
    61.392   611.469     0.150
    61.537   611.094     0.150
    62.472   617.469     0.150
    62.638   619.457     0.150
    62.773   618.867     0.150
    62.951   620.766     0.150
    63.536   623.066     0.150
    65.422   636.867     0.150
    65.510   636.867     0.150
    66.293   642.367     0.150
    66.725   645.469     0.150
    66.725   674.668     0.150
    66.725   794.168     0.150
    66.725  1172.867     0.150
    66.725  1431.867     0.150
    66.854   645.367     0.150
    66.854   675.168     0.150
    67.545   649.066     0.150
    67.545   678.266     0.150
    68.489   656.867     0.150
    68.970   659.266     0.150
    69.084   664.867     0.150
    69.905   666.367     0.150
    69.905   685.367     0.150
    70.575   669.668     0.150
    71.010   673.027     0.150
    71.010    12.781     0.150
    71.172   674.219     0.150
    71.191   673.566     0.150
    71.494   676.527     0.150
    71.695   677.066     0.150
    71.695   696.266     0.150
    71.732   677.367     0.150
    71.732   695.867     0.150
    71.732   695.969     0.150
    71.883   677.367     0.150
    71.883    16.500     0.150
    72.032   678.168     0.150
    72.071   679.566     0.150
    72.191   680.867     0.150
    72.331   680.066     0.150
    72.375   681.168     0.150
    72.375    18.098     0.150
    72.483   681.766     0.150
    72.619   681.969     0.150
    72.619   696.469     0.150
    72.641   682.969     0.150
    72.641    13.297     0.150
    72.641    18.598     0.150
    72.676   682.766     0.150
    72.686   683.566     0.150
    72.822   683.766     0.150
    72.813   683.867     0.150
    72.989   685.066     0.150
    73.348   687.766     0.150
    73.399   687.266     0.150
    73.399    18.602     0.150
    73.412   687.469     0.150
    73.430   686.867     0.150
    73.558   688.266     0.150
    73.639   688.668     0.150
    73.666   688.969     0.150
    73.783   689.867     0.150
    73.966   690.969     0.150
    73.981   690.367     0.150
    74.012   690.566     0.150
    74.021   691.066     0.150
    74.021   689.969     0.150
    74.033   691.168     0.150
    74.100   691.668     0.150
    74.158   692.066     0.150
    74.161   691.066     0.150
    74.266   692.168     0.150
    74.312   692.066     0.150
    74.448   693.668     0.150
    74.477   694.066     0.150
    74.523   693.766     0.150
    74.554   693.266     0.150
    74.569   694.367     0.150
    74.569    18.000     0.150
    74.679   706.867     0.150
    74.679  1301.867     0.150
    74.706   694.168     0.150
    74.726   695.266     0.150
    74.767   694.367     0.150
    74.871   695.066     0.150
    75.086   697.168     0.150
    75.088   697.266     0.150
    75.396   700.668     0.150
    75.412   698.867     0.150
    75.420   699.367     0.150
    75.518   701.066     0.150
    75.586   700.168     0.150
    75.719   699.969     0.150
    75.850   701.969     0.150
    75.983   700.867     0.150
    75.983    16.000     0.150
    75.983   867.867     0.150
    76.061   704.867     0.150
    76.080   702.469     0.150
    76.089   702.969     0.150
    76.169   703.586     0.150
    76.292   704.266     0.150
    76.290   704.566     0.150
    76.638   705.566     0.150
    76.745   706.469     0.150
    76.978   710.766     0.150
    77.050   708.867     0.150
    77.283   709.469     0.150
    77.309   711.766     0.150
    77.422   711.266     0.150
    77.699   711.566     0.150
    77.731   712.469     0.150
    77.745   711.969     0.150
    77.813   714.668     0.150
    77.853   713.367     0.150
    77.916   715.066     0.150
    77.946   712.367     0.150
    77.985   712.969     0.150
    78.067   713.566     0.150
    78.067   721.969     0.150
    78.067    18.102     0.150
    78.046   716.266     0.150
    78.097   714.469     0.150
    78.181   714.066     0.150
    78.247   714.766     0.150
    78.385   715.469     0.150
    78.808   718.637     0.150
    79.070   718.867     0.150
    79.614   723.867     0.150
    80.652   726.867     0.150
    80.790   729.469     0.150
    80.953   729.578     0.150
    80.972   729.367     0.150
    80.972    18.500     0.150
    81.165   731.367     0.150
    81.243   731.355     0.150
    81.331   731.898     0.150
    81.518   732.438     0.150
    81.555   732.586     0.150
    81.557   732.668     0.150
    81.600   732.918     0.150
    81.652   732.867     0.150
    81.680   733.059     0.150
    81.736   733.977     0.150
    81.738   733.477     0.150
    81.732   731.266     0.150
    81.771   733.445     0.150
    81.778   733.578     0.150
    81.809   734.066     0.150
    81.809    15.000     0.150
    81.832   734.379     0.150
    81.943   733.789     0.150
    81.993   734.605     0.150
    82.216   736.066     0.150
    82.253   735.887     0.150
    82.313   736.539     0.150
    82.460   737.867     0.150
    82.491   736.668     0.150
    82.518   737.188     0.150
    82.976   740.617     0.150
    83.368   741.566     0.150
    84.005   743.867     0.150
    91.636   783.066     0.150
   100.417   821.934     0.150
   117.391  1121.031     0.150
   147.685  1178.316     0.150
   151.268  1188.840     0.150
   160.532  1252.766     0.150
     0.882    15.746     0.150
     1.011    17.824     0.150
     1.047    18.156     0.150
     1.090    18.777     0.150
     1.086    18.695     0.150
     0.995    18.016     0.150
     1.026    17.516     0.150
     1.166    20.406     0.150
     1.184    20.656     0.150
     1.276    21.555     0.150
     1.259    21.797     0.150
     1.372    23.047     0.150
     2.043    32.855     0.150
     2.067    33.465     0.150
     2.073    33.566     0.150
     2.180    34.676     0.150
     2.220    35.164     0.150
     2.273    35.445     0.150
     2.377    37.527     0.150
     2.452    37.844     0.150
     2.693    41.766     0.150
     2.692    42.027     0.150
     2.742    42.656     0.150
     2.699    41.367     0.150
     2.757    42.426     0.150
     2.785    42.855     0.150
     2.794    43.215     0.150
     2.826    43.266     0.150
     2.997    45.066     0.150
     3.112    47.535     0.150
     3.222    49.086     0.150
     3.271    50.086     0.150
     3.299    49.855     0.150
     3.357    50.637     0.150
     3.377    50.414     0.150
     3.746    57.016     0.150
     3.843    57.047     0.150
     3.796    55.387     0.150
     4.019    58.844     0.150
     3.987    59.188     0.150
     4.008    59.316     0.150
     4.011    59.004     0.150
     4.034    59.938     0.150
     4.061    58.375     0.150
     4.043    58.695     0.150
     4.155    62.516     0.150
     4.210    62.254     0.150
     4.291    61.945     0.150
     4.412    64.406     0.150
     4.479    65.414     0.150
     4.594    67.375     0.150
     4.636    67.387     0.150
     4.640    67.645     0.150
     4.589    66.547     0.150
     4.669    69.105     0.150
     4.687    68.438     0.150
     4.718    69.445     0.150
     4.725    68.938     0.150
     4.657    67.047     0.150
     4.653    66.754     0.150
     4.788    68.996     0.150
     4.858    70.645     0.150
     4.980    72.188     0.150
     5.016    72.406     0.150
     4.994    71.465     0.150
     5.079    73.156     0.150
     5.039    71.957     0.150
     5.049    72.117     0.150
     5.083    72.414     0.150
     5.228    76.195     0.150
     5.199    74.406     0.150
     5.264    74.324     0.150
     5.457    78.984     0.150
     5.409    77.336     0.150
     5.443    77.457     0.150
     5.558    79.254     0.150
     5.675    81.816     0.150
     5.708    81.637     0.150
     5.769    82.047     0.150
     5.824    83.188     0.150
     5.944    84.805     0.150
     5.986    85.246     0.150
     6.205    89.406     0.150
     6.278    90.367     0.150
     6.432    92.367     0.150
     6.508    94.637     0.150
     6.488    93.566     0.150
     6.641    95.195     0.150
     6.577    93.938     0.150
     6.787    97.156     0.150
     6.805    96.566     0.150
     6.921    99.055     0.150
     7.137   101.367     0.150
     7.259   104.805     0.150
     7.141   100.957     0.150
     7.560   107.027     0.150
     7.678   107.707     0.150
     7.663   110.277     0.150
     7.778   109.875     0.150
     7.851   110.836     0.150
     7.896   111.516     0.150
     7.926   111.844     0.150
     7.993   113.426     0.150
     7.927   112.344     0.150
     8.068   115.395     0.150
     8.052   113.156     0.150
     8.160   113.977     0.150
     8.171   114.625     0.150
     8.181   116.957     0.150
     8.256   115.266     0.150
     8.256   205.414     0.150
     8.256   715.016     0.150
     8.762   123.906     0.150
     9.193   129.285     0.150
    10.166   141.438     0.150
    10.265   141.277     0.150
    11.036   153.027     0.150
    12.908   180.590     0.150
    12.908   322.816     0.150
    14.073   195.977     0.150
    14.073   199.516     0.150
    14.058   197.414     0.150
    14.403   199.867     0.150
    14.403   723.617     0.150
    18.618   252.336     0.150
    19.056   256.863     0.150
    20.270   291.617     0.150
    20.270   271.117     0.150
    20.270   734.867     0.150
    20.558   273.715     0.150
    20.487   277.547     0.150
    20.504   276.836     0.150
    20.626   278.227     0.150
    20.871   280.867     0.150
    21.345   285.766     0.150
    21.399   286.375     0.150
    21.626   289.547     0.150
    21.806   290.395     0.150
    21.918   291.688     0.150
    22.233   295.074     0.150
    22.323   296.027     0.150
    22.367   295.938     0.150
    22.508   298.324     0.150
    22.753   299.824     0.150
    22.872   301.305     0.150
    23.046   302.906     0.150
    23.054   304.188     0.150
    23.297   305.977     0.150
    23.549   308.074     0.150
    23.585   307.945     0.150
    23.607   309.145     0.150
    23.720   310.457     0.150
    23.799   310.336     0.150
    23.917   312.707     0.150
    23.931   311.344     0.150
    23.970   312.465     0.150
    24.136   315.004     0.150
    24.249   314.746     0.150
    24.487   317.156     0.150
    24.798   319.266     0.150
    25.428   326.324     0.150
    25.584   327.875     0.150
    26.474   329.516     0.150
    26.504   334.176     0.150
    26.506   335.664     0.150
    26.528   336.234     0.150
    26.528    11.691     0.150
    26.806   334.516     0.150
    26.806   377.516     0.150
    26.806   609.516     0.150
    26.835   336.844     0.150
    26.881   337.254     0.150
    26.971   339.727     0.150
    27.321   341.777     0.150
    27.568   342.785     0.150
    27.728   345.227     0.150
    27.770   345.977     0.150
    27.770    12.559     0.150
    27.861   346.836     0.150
    27.886   347.156     0.150
    27.886    12.469     0.150
    28.165   345.816     0.150
    28.165   397.715     0.150
    28.165   627.414     0.150
    27.952   347.457     0.150
    27.952    12.629     0.150
    27.961   348.496     0.150
    28.251   349.805     0.150
    28.381   351.496     0.150
    28.381    12.270     0.150
    28.393   351.844     0.150
    28.393    12.281     0.150
    28.416   351.734     0.150
    28.552   352.805     0.150
    28.552    12.680     0.150
    28.611   354.316     0.150
    28.725   352.797     0.150
    28.736   355.504     0.150
    28.956   356.816     0.150
    28.956    12.527     0.150
    29.349   355.215     0.150
    29.349    10.801     0.150
    29.142   358.438     0.150
    29.142    12.539     0.150
    29.198   359.445     0.150
    29.413   360.996     0.150
    29.475   361.957     0.150
    29.475    12.660     0.150
    29.499   361.715     0.150
    29.499    12.590     0.150
    29.629   362.395     0.150
    29.871   366.117     0.150
    29.871    12.988     0.150
    29.917   365.477     0.150
    29.951   366.438     0.150
    29.951    12.680     0.150
    30.052   367.277     0.150
    30.052    12.910     0.150
    30.129   367.965     0.150
    30.129    12.324     0.150
    30.129   545.965     0.150
    30.129   764.691     0.150
    30.202   368.516     0.150
    30.430   370.336     0.150
    30.501   370.875     0.150
    30.501    12.680     0.150
    30.522   371.605     0.150
    30.522    12.371     0.150
    30.839   374.676     0.150
    30.839    12.719     0.150
    31.264   377.574     0.150
    31.400   379.316     0.150
    31.530   379.195     0.150
    31.530    12.500     0.150
    31.530   379.266     0.150
    31.530    12.648     0.150
    31.530   548.965     0.150
    31.618   380.344     0.150
    31.618    12.773     0.150
    31.651   380.875     0.150
    31.651    12.590     0.150
    31.817   381.926     0.150
    32.226   385.844     0.150
    32.280   386.625     0.150
    32.280    12.902     0.150
    32.303   386.844     0.150
    32.368   387.066     0.150
    32.424   387.977     0.150
    32.523   389.414     0.150
    33.287   390.215     0.150
    33.084   393.277     0.150
    33.084    12.910     0.150
    33.191   394.895     0.150
    33.191    12.672     0.150
    33.605   397.527     0.150
    33.596   397.695     0.150
    33.614   398.426     0.150
    33.614    12.102     0.150
    33.667   398.754     0.150
    33.836   396.117     0.150
    33.801   400.047     0.150
    33.801    12.410     0.150
    33.989   401.605     0.150
    33.989    12.500     0.150
    34.227   401.539     0.150
    34.227    12.625     0.150
    34.227   775.715     0.150
    34.798   408.027     0.150
    34.798    12.547     0.150
    34.857   408.395     0.150
    34.938   409.594     0.150
    35.727   415.914     0.150
    35.889   417.875     0.150
    35.889    12.762     0.150
    35.975   419.227     0.150
    36.630   417.715     0.150
    37.545   431.156     0.150
    37.912   432.945     0.150
    38.674   437.016     0.150
    38.674    11.699     0.150
    38.910   438.414     0.150
    38.717   441.695     0.150
    38.717    12.551     0.150
    38.884   442.555     0.150
    38.884    12.672     0.150
    38.946   443.594     0.150
    38.946    12.992     0.150
    39.215   446.438     0.150
    39.408   447.477     0.150
    39.408    12.809     0.150
    39.603   448.125     0.150
    39.603    12.770     0.150
    41.864   464.996     0.150
    41.864    12.629     0.150
    42.112   469.195     0.150
    42.112    12.898     0.150
    42.910   471.914     0.150
    42.910   852.516     0.150
    42.910  1044.016     0.150
    43.241   475.516     0.150
    43.130   476.715     0.150
    43.729   480.695     0.150
    43.729   810.605     0.150
    43.729   866.484     0.150
    43.729  1057.867     0.150
    43.743   481.156     0.150
    44.753   488.336     0.150
    44.753   889.156     0.150
    44.748   490.195     0.150
    44.748    12.992     0.150
    44.748   490.191     0.150
    44.748    13.426     0.150
    44.748    19.375     0.150
    44.879   489.035     0.150
    45.501   491.715     0.150
    45.501   888.516     0.150
    45.610   494.992     0.150
    45.610    13.348     0.150
    45.869   498.344     0.150
    45.869    12.852     0.150
    46.086   499.305     0.150
    46.086    12.949     0.150
    46.099   498.984     0.150
    46.099    12.953     0.150
    46.582   502.625     0.150
    46.954   505.984     0.150
    47.302   508.457     0.150
    47.302    13.039     0.150
    47.406   510.215     0.150
    47.930   514.375     0.150
    47.930    12.750     0.150
    48.017   514.266     0.150
    48.017    13.039     0.150
    48.330   515.941     0.150
    48.330    12.348     0.150
    48.330   515.277     0.150
    48.330    12.137     0.150
    48.330   514.516     0.150
    48.330   932.516     0.150
    48.370   516.914     0.150
    48.402   518.246     0.150
    48.736   517.539     0.150
    48.740   520.066     0.150
    48.740    12.910     0.150
    48.748   520.254     0.150
    49.517   525.246     0.150
    49.517    14.211     0.150
    49.789   525.516     0.150
    49.789   948.516     0.150
    49.705   526.715     0.150
    49.705    12.910     0.150
    49.884   528.586     0.150
    49.884    13.301     0.150
    50.025   529.375     0.150
    50.025    13.352     0.150
    50.482   532.645     0.150
    50.686   534.656     0.150
    50.686    13.730     0.150
    51.200   538.105     0.150
    51.200    13.031     0.150
    51.457   540.625     0.150
    51.457    13.121     0.150
    51.680   542.016     0.150
    51.821   543.145     0.150
    52.166   544.516     0.150
    52.166   983.516     0.150
    52.130   545.195     0.150
    52.130    14.020     0.150
    52.421   546.875     0.150
    52.949   550.914     0.150
    52.949    13.391     0.150
    53.180   552.164     0.150
    53.180    12.102     0.150
    53.180    17.352     0.150
    53.046   551.797     0.150
    53.046    13.348     0.150
    53.200   551.871     0.150
    53.230   552.445     0.150
    53.400   552.516     0.150
    53.400    11.801     0.150
    53.425   553.492     0.150
    53.808   556.715     0.150
    53.937   557.266     0.150
    54.080   558.414     0.150
    53.936   558.625     0.150
    54.513   564.105     0.150
    54.452   562.484     0.150
    54.461   562.625     0.150
    54.570   563.105     0.150
    54.577   563.527     0.150
    54.650   568.516     0.150
    54.897   564.516     0.150
    54.897  1014.016     0.150
    55.158   566.617     0.150
    55.272   567.414     0.150
    55.773   573.305     0.150
    55.924   571.516     0.150
    56.511   577.055     0.150
    56.511    12.301     0.150
    57.219   580.516     0.150
    57.219  1048.516     0.150
    57.239   580.781     0.150
    58.412   592.516     0.150
    58.845   592.617     0.150
    58.845  1075.516     0.150
    58.884   591.016     0.150
    58.884  1072.016     0.150
    59.589   600.254     0.150
    59.692   597.914     0.150
    59.771   598.914     0.150
    60.252   602.516     0.150
    60.865   606.816     0.150
    60.865  1103.516     0.150
    60.879   606.617     0.150
    61.407   610.117     0.150
    61.407   610.441     0.150
    61.589   611.617     0.150
    61.589  1113.516     0.150
    61.589  1132.516     0.150
    61.552   610.941     0.150
    61.552    13.301     0.150
    61.552  2367.090     0.150
    61.703   612.516     0.150
    61.703   743.516     0.150
    61.703  1111.516     0.150
    61.703  1200.516     0.150
    62.057   613.316     0.150
    62.057  1111.516     0.150
    62.486   617.516     0.150
    62.653   619.426     0.150
    62.784   619.117     0.150
    62.784  1126.516     0.150
    62.966   620.715     0.150
    63.547   623.016     0.150
    63.547    11.500     0.150
    63.547   661.516     0.150
    63.865   625.816     0.150
    64.113   627.516     0.150
    65.424   636.117     0.150
    65.509   636.715     0.150
    65.584   637.516     0.150
    65.584  1160.715     0.150
    65.736   637.715     0.150
    65.771   641.016     0.150
    65.771    17.699     0.150
    66.199   641.230     0.150
    66.199  1166.449     0.150
    66.199  1231.816     0.150
    66.199  2356.285     0.150
    66.294   642.516     0.150
    66.294   789.516     0.150
    66.294  1163.516     0.150
    66.294  1233.516     0.150
    66.730   645.516     0.150
    66.730   674.715     0.150
    66.730   794.215     0.150
    66.730  1171.316     0.150
    66.730  1234.715     0.150
    66.867   644.816     0.150
    67.558   648.816     0.150
    67.558    12.699     0.150
    67.558  1181.117     0.150
    68.370   656.617     0.150
    68.503   657.516     0.150
    68.984   659.816     0.150
    68.984    13.301     0.150
    69.948   666.254     0.150
    69.948    13.402     0.150
    69.948    17.832     0.150
    70.447   669.914     0.150
    70.575   668.816     0.150
    70.709   672.316     0.150
    70.709    12.398     0.150
    70.709  1216.617     0.150
    70.730   669.117     0.150
    71.026   672.047     0.150
    71.026    13.250     0.150
    71.026   690.746     0.150
    71.187   674.805     0.150
    71.187    12.391     0.150
    71.206   673.617     0.150
    71.206   692.215     0.150
    71.494   674.617     0.150
    71.510    11.742     0.150
    71.534   674.715     0.150
    71.710   676.914     0.150
    71.710   695.215     0.150
    71.710  1236.117     0.150
    71.747   677.016     0.150
    71.747   695.516     0.150
    71.851   678.016     0.150
    71.897   678.016     0.150
    71.897    12.301     0.150
    71.897    18.500     0.150
    72.030   678.516     0.150
    71.969   678.016     0.150
    72.048   677.816     0.150
    72.136   678.516     0.150
    72.133   681.457     0.150
    72.133    11.637     0.150
    72.179   679.117     0.150
    72.207   681.516     0.150
    72.351   679.816     0.150
    72.271   679.117     0.150
    72.347   679.816     0.150
    72.390   681.316     0.150
    72.390    13.098     0.150
    72.390    18.801     0.150
    72.392   680.316     0.150
    72.499   683.414     0.150
    72.634   682.316     0.150
    72.634    19.000     0.150
    72.656   683.016     0.150
    72.656    12.500     0.150
    72.656    18.199     0.150
    72.690   682.316     0.150
    72.690    18.301     0.150
    72.690  1248.414     0.150
    72.812   682.914     0.150
    72.812  1245.516     0.150
    72.757   684.516     0.150
    72.757    17.801     0.150
    72.757  1279.414     0.150
    72.837   685.117     0.150
    73.001   684.016     0.150
    73.362   687.715     0.150
    73.414   687.715     0.150
    73.414    12.301     0.150
    73.414    18.801     0.150
    73.428   688.816     0.150
    73.445   687.117     0.150
    73.502   686.414     0.150
    73.510   688.887     0.150
    73.573   689.715     0.150
    73.655   689.914     0.150
    73.739   686.516     0.150
    73.681   688.617     0.150
    73.708   687.789     0.150
    73.708    13.277     0.150
    73.705   689.016     0.150
    73.785   686.516     0.150
    73.788   688.215     0.150
    73.798   691.414     0.150
    73.981   692.117     0.150
    73.996   690.016     0.150
    74.027   691.914     0.150
    74.037   689.617     0.150
    74.048   692.414     0.150
    74.176   690.617     0.150
    74.198   691.215     0.150
    74.327   691.617     0.150
    74.463   694.914     0.150
    74.492   694.617     0.150
    74.583   693.117     0.150
    74.583   706.617     0.150
    74.686   862.516     0.150
    74.686  1269.016     0.150
    74.721   693.816     0.150
    74.741   695.617     0.150
    74.783   693.914     0.150
    74.887   694.816     0.150
    74.904   697.516     0.150
    74.904   709.516     0.150
    74.970   696.016     0.150
    74.970   710.316     0.150
    75.101   697.117     0.150
    75.103   696.914     0.150
    75.103   707.617     0.150
    75.125   696.316     0.150
    75.337   699.234     0.150
    75.337    13.344     0.150
    75.427   698.914     0.150
    75.411   701.117     0.150
    75.435   699.414     0.150
    75.534   701.414     0.150
    75.602   701.117     0.150
    75.735   699.617     0.150
    75.875   700.516     0.150
    75.832   701.297     0.150
    75.832   712.707     0.150
    75.996   701.516     0.150
    75.996    12.000     0.150
    75.962   701.414     0.150
    76.005   703.516     0.150
    76.076   704.816     0.150
    76.095   702.617     0.150
    76.104   702.914     0.150
    76.101   704.117     0.150
    76.078   703.535     0.150
    76.078   713.844     0.150
    76.185   703.016     0.150
    76.307   704.074     0.150
    76.305   704.215     0.150
    76.519   704.914     0.150
    76.519    12.602     0.150
    76.519    14.801     0.150
    76.654   705.316     0.150
    76.760   706.117     0.150
    76.744   706.445     0.150
    76.744   716.754     0.150
    76.794   706.316     0.150
    76.868   707.867     0.150
    76.868   717.516     0.150
    76.806   707.734     0.150
    77.324   709.316     0.150
    77.324  1293.516     0.150
    77.268   708.117     0.150
    77.280   711.207     0.150
    77.280   719.656     0.150
    77.298   709.316     0.150
    77.325   711.516     0.150
    77.424   710.914     0.150
    77.348   710.344     0.150
    77.345   711.504     0.150
    77.535   710.797     0.150
    77.508   712.664     0.150
    77.518   723.316     0.150
    77.555   711.785     0.150
    77.629   712.617     0.150
    77.629   721.516     0.150
    77.715   712.016     0.150
    77.755   714.516     0.150
    77.761   711.715     0.150
    77.801   725.117     0.150
    77.828   714.617     0.150
    77.869   714.215     0.150
    77.932   715.016     0.150
    77.948   714.914     0.150
    78.000   712.617     0.150
    78.079   713.016     0.150
    78.039   715.516     0.150
    78.061   715.617     0.150
    78.163   713.516     0.150
    78.096   716.117     0.150
    78.120   714.016     0.150
    78.168   715.055     0.150
    78.196   713.914     0.150
    78.262   714.414     0.150
    78.310   717.617     0.150
    78.292   728.914     0.150
    78.413   715.617     0.150
    78.401   715.117     0.150
    78.481   718.195     0.150
    78.497   715.117     0.150
    78.554   717.066     0.150
    78.554   725.836     0.150
    78.742   718.605     0.150
    78.823   719.004     0.150
    78.877   718.535     0.150
    78.877   727.445     0.150
    78.941   716.016     0.150
    78.954   718.855     0.150
    79.100   718.516     0.150
    79.082   719.516     0.150
    79.082  1313.516     0.150
    79.082  1314.516     0.150
    79.190   727.914     0.150
    79.213   730.414     0.150
    79.222   732.617     0.150
    79.327   721.504     0.150
    79.327   728.906     0.150
    79.359   721.664     0.150
    79.445   729.688     0.150
    79.543   721.516     0.150
    79.553   721.984     0.150
    79.728   734.516     0.150
    79.902   724.375     0.150
    79.902   731.906     0.150
    79.940   723.074     0.150
    80.032   724.195     0.150
    80.051   723.477     0.150
    80.160   725.465     0.150
    80.160    12.652     0.150
    80.160   724.938     0.150
    80.160   732.555     0.150
    80.312   725.066     0.150
    80.411   725.516     0.150
    80.391   726.094     0.150
    80.445   725.516     0.150
    80.466   726.016     0.150
    80.571   726.547     0.150
    80.805   729.316     0.150
    80.842   729.547     0.150
    80.842   734.527     0.150
    80.956   729.316     0.150
    80.856   742.414     0.150
    80.910   727.914     0.150
    80.971   731.695     0.150
    80.986   729.516     0.150
    80.986    13.602     0.150
    80.986    19.000     0.150
    81.175   731.016     0.150
    81.132   729.816     0.150
    81.104   738.117     0.150
    81.246   730.797     0.150
    81.226   733.645     0.150
    81.334   731.715     0.150
    81.333   731.516     0.150
    81.374   731.516     0.150
    81.356   732.016     0.150
    81.356   737.086     0.150
    81.421   731.816     0.150
    81.459   732.746     0.150
    81.459   737.285     0.150
    81.603   732.676     0.150
    81.562   732.516     0.150
    81.542   736.715     0.150
    81.684   732.977     0.150
    81.667   733.516     0.150
    81.667    19.000     0.150
    81.740   733.914     0.150
    81.741   733.297     0.150
    81.776   733.336     0.150
    81.781   733.457     0.150
    81.746   734.324     0.150
    81.835   734.094     0.150
    81.824   733.117     0.150
    81.833   734.117     0.150
    81.947   733.855     0.150
    81.890   734.316     0.150
    81.881   735.406     0.150
    81.997   734.477     0.150
    82.026   735.074     0.150
    81.993   734.957     0.150
    81.993   739.527     0.150
    82.126   734.477     0.150
    82.125   735.004     0.150
    82.125   740.035     0.150
    82.170   734.637     0.150
    82.181   735.797     0.150
    82.257   735.816     0.150
    82.317   736.457     0.150
    82.235   741.336     0.150
    82.470   737.516     0.150
    82.523   736.996     0.150
    82.430   737.496     0.150
    82.430   742.145     0.150
    82.494   742.297     0.150
    82.547   737.984     0.150
    82.547   742.688     0.150
    82.549   737.625     0.150
    82.549   742.555     0.150
    82.636   738.516     0.150
    82.677   736.914     0.150
    82.746   738.926     0.150
    82.746   743.074     0.150
    82.883   738.836     0.150
    82.921   739.156     0.150
    82.921   743.645     0.150
    82.990   740.215     0.150
    82.990    13.500     0.150
    82.990    19.102     0.150
    83.064   739.023     0.150
    83.064  1354.027     0.150
    82.975   740.164     0.150
    82.975   743.527     0.150
    83.128   740.715     0.150
    83.128   745.145     0.150
    83.367   741.164     0.150
    83.381   742.957     0.150
    83.632   742.477     0.150
    83.876   743.914     0.150
    83.956   744.074     0.150
    84.217   746.355     0.150
    85.466   753.516     0.150
    85.466    12.500     0.150
    85.809   756.516     0.150
    87.620   759.266     0.150
    88.221   765.754     0.150
    93.615   789.516     0.150
    93.615    13.500     0.150
    99.844   820.617     0.150
   100.404   820.867     0.150
   115.418  1115.840     0.150
   115.418  1751.188     0.150
   117.406  1119.547     0.150
   117.406  1133.496     0.150
   117.406  1740.996     0.150
   120.057  1124.453     0.150
   120.057  1138.402     0.150
   137.321  1170.852     0.150
   147.167  1174.516     0.150
   147.167  1191.516     0.150
   151.282  1187.215     0.150
   151.282  1195.316     0.150
   151.282  1201.566     0.150
   151.791  1191.438     0.150
   151.791  1208.105     0.150
   160.524  1189.117     0.150
   161.389  1237.516     0.150
     0.261     5.570     0.150
     0.279     5.477     0.150
     1.369    24.602     0.150
     1.396    25.109     0.150
     1.401    25.047     0.150
     1.425    25.445     0.150
     1.459    26.367     0.150
     1.574    28.414     0.150
     1.574    49.648     0.150
     1.637    29.320     0.150
     1.650    29.547     0.150
     1.678    29.930     0.150
     1.871    33.148     0.150
     1.871    57.031     0.150
     1.888    32.805     0.150
     1.896    33.641     0.150
     1.918    33.820     0.150
     2.161    36.617     0.150
     2.161    62.625     0.150
     2.223    37.836     0.150
     2.415    39.977     0.150
     2.415    68.797     0.150
     2.450    39.945     0.150
     2.450    68.461     0.150
     2.463    40.938     0.150
     2.515    41.734     0.150
     2.520    41.609     0.150
     2.566    42.445     0.150
     2.568    42.102     0.150
     2.582    42.352     0.150
     2.961    47.789     0.150
     3.063    49.070     0.150
     3.091    49.352     0.150
     3.073    49.352     0.150
     3.449    53.250     0.150
     3.575    54.195     0.150
     3.698    56.875     0.150
     3.702    57.641     0.150
     3.711    57.516     0.150
     3.711   102.266     0.150
     3.735    57.750     0.150
     3.896    59.648     0.150
     3.909    60.305     0.150
     3.976    61.617     0.150
     4.038    61.211     0.150
     4.393    67.008     0.150
     4.438    65.719     0.150
     4.463    66.719     0.150
     4.470    67.016     0.150
     4.477    66.688     0.150
     4.560    67.414     0.150
     4.683    70.141     0.150
     4.704    70.195     0.150
     4.732    70.578     0.150
     4.877    72.734     0.150
     4.848    72.648     0.150
     4.867    71.930     0.150
     5.059    77.031     0.150
     5.054    75.078     0.150
     5.072    75.727     0.150
     5.487    81.539     0.150
     5.483    81.414     0.150
     5.567    82.852     0.150
     5.662    84.102     0.150
     5.660    84.438     0.150
     5.683    84.367     0.150
     5.625    83.328     0.150
     5.773    85.602     0.150
     6.000    88.141     0.150
     6.028    88.789     0.150
     6.078    90.055     0.150
     6.176    91.305     0.150
     6.175    91.664     0.150
     6.212    91.398     0.150
     6.372    93.445     0.150
     6.510    95.680     0.150
     6.776    99.398     0.150
     7.132   105.070     0.150
     7.304   105.320     0.150
     7.462   108.906     0.150
     7.605   109.500     0.150
     7.747   111.656     0.150
     7.776   111.984     0.150
     7.805   111.961     0.150
     7.805   198.453     0.150
     8.519   122.828     0.150
     8.602   124.469     0.150
     9.359   136.039     0.150
    10.612   150.477     0.150
    12.056   173.156     0.150
    12.056   307.859     0.150
    13.825   195.555     0.150
    19.466   266.656     0.150
    19.466   526.656     0.150
    19.891   270.055     0.150
    23.122   308.031     0.150
    26.020   333.898     0.150
    29.205   363.930     0.150
    29.248   364.906     0.150
    29.632   368.578     0.150
    30.730   377.008     0.150
    32.430   392.367     0.150
    32.442   393.000     0.150
    32.847   395.836     0.150
    33.374   398.531     0.150
    33.374   558.609     0.150
    33.618   398.219     0.150
    34.027   405.875     0.150
    34.167   407.930     0.150
    35.158   415.102     0.150
    38.650   445.914     0.150
    41.406   465.805     0.150
    42.324   474.938     0.150
    42.878   477.906     0.150
    44.000   489.117     0.150
    44.000   489.531     0.150
    44.000   593.508     0.150
    44.831   493.805     0.150
    45.090   497.320     0.150
    47.906   518.055     0.150
    49.377   528.055     0.150
    50.508   536.609     0.150
    51.574   545.688     0.150
    53.035   554.805     0.150
    53.250   557.086     0.150
    53.250   625.633     0.150
    53.951   563.109     0.150
    57.931   591.516     0.150
    59.509   601.805     0.150
    59.501   603.008     0.150
    60.710   609.906     0.150
    61.118   612.906     0.150
    61.118   613.258     0.150
    61.380   614.906     0.150
    62.208   620.492     0.150
    62.303   620.609     0.150
    63.664   629.352     0.150
    64.845   638.359     0.150
    64.853   637.906     0.150
    66.008   645.609     0.150
    66.192   646.805     0.150
    66.929   652.008     0.150
    67.185   655.008     0.150
    67.185   683.406     0.150
    67.482   654.508     0.150
    71.240   678.305     0.150
    71.422   680.305     0.150
    71.437   680.305     0.150
    71.631   681.305     0.150
    71.850   682.008     0.150
    71.918   682.906     0.150
    72.340   685.906     0.150
    72.457   687.211     0.150
    72.695   687.617     0.150
    73.120   690.008     0.150
    73.147   690.008     0.150
    73.180   690.805     0.150
    73.414   691.281     0.150
    73.423   691.906     0.150
    73.595   693.109     0.150
    73.676   693.211     0.150
    73.770   694.008     0.150
    73.786   694.008     0.150
    73.933   694.805     0.150
    74.173   696.109     0.150
    74.320   697.008     0.150
    74.391   697.211     0.150
    74.479   697.805     0.150
    74.754   700.008     0.150
    75.002   702.477     0.150
    75.536   704.305     0.150
    75.937   707.711     0.150
    76.264   708.508     0.150
    76.382   709.508     0.150
    77.271   714.711     0.150
    77.343   714.609     0.150
    77.998   719.805     0.150
    78.087   718.219     0.150
    79.673   728.055     0.150
    81.876   739.211     0.150
    82.136   740.031     0.150
    82.209   740.250     0.150
    82.260   741.102     0.150
    82.367   741.445     0.150
    82.427   741.750     0.150
    82.690   745.008     0.150
    82.738   743.609     0.150
    82.893   744.734     0.150
    84.059   749.961     0.150
   117.108  1123.797     0.150
   151.080  1192.406     0.150
     0.852    15.670     0.150
     0.893    16.420     0.150
     0.893    27.670     0.150
     0.910    16.541     0.150
     0.997    17.970     0.150
     1.023    18.200     0.150
     1.070    18.750     0.150
     1.048    18.440     0.150
     0.951    17.561     0.150
     1.123    19.950     0.150
     1.144    20.190     0.150
     0.983    17.440     0.150
     1.189    20.450     0.150
     1.261    21.410     0.150
     1.213    21.220     0.150
     1.335    22.630     0.150
     1.554    25.420     0.150
     1.802    29.041     0.150
     1.992    32.061     0.150
     2.082    32.170     0.150
     2.016    32.620     0.150
     2.018    32.480     0.150
     2.019    32.660     0.150
     2.037    57.250     0.150
     2.325    36.561     0.150
     2.641    40.630     0.150
     2.638    40.960     0.150
     2.690    41.581     0.150
     2.645    40.430     0.150
     2.645    71.220     0.150
     2.705    41.561     0.150
     2.734    41.870     0.150
     3.219    48.820     0.150
     3.305    50.010     0.150
     3.692    56.280     0.150
     3.802    56.430     0.150
     3.742    54.240     0.150
     4.064    60.081     0.150
     3.935    58.351     0.150
     3.958    58.240     0.150
     3.990    57.990     0.150
     4.101    61.360     0.150
     4.129    62.561     0.150
     4.425    64.230     0.150
     4.636    68.021     0.150
     4.676    67.791     0.150
     4.682    68.500     0.150
     4.535    65.561     0.150
     4.729    69.390     0.150
     4.767    69.630     0.150
     4.604    66.150     0.150
     4.831    70.260     0.150
     4.607    65.110     0.150
     4.804    69.750     0.150
     5.058    72.851     0.150
     5.122    73.620     0.150
     4.940    70.581     0.150
     4.985    71.200     0.150
     4.998    71.360     0.150
     5.269    76.660     0.150
     5.059    71.640     0.150
     5.145    73.630     0.150
     5.403    77.740     0.150
     5.632    81.340     0.150
     5.505    78.351     0.150
     5.599    79.890     0.150
     5.654    80.820     0.150
     5.717    82.180     0.150
     5.717   143.090     0.150
     5.776    81.860     0.150
     5.891    83.811     0.150
     6.225    88.800     0.150
     6.380    91.550     0.150
     6.549    93.920     0.150
     6.587    93.791     0.150
     6.530    93.260     0.150
     6.635    94.210     0.150
     6.620    94.490     0.150
     6.734    96.291     0.150
     6.757    95.180     0.150
     6.868    97.791     0.150
     7.084   100.250     0.150
     7.092   100.291     0.150
     7.105   100.480     0.150
     7.512   106.360     0.150
     7.609   108.630     0.150
     7.820   110.720     0.150
     7.926   112.200     0.150
     7.845   110.890     0.150
     8.034   112.800     0.150
     7.872   110.791     0.150
     7.909   110.730     0.150
     7.885   111.360     0.150
     8.107   114.450     0.150
     8.118   114.370     0.150
     8.202   114.660     0.150
     8.202   203.649     0.150
     8.714   123.101     0.150
     9.005   126.021     0.150
     9.139   128.720     0.150
    10.112   141.120     0.150
    10.234   140.760     0.150
    12.870   180.660     0.150
    12.985   182.370     0.150
    14.110   194.500     0.150
    14.012   193.400     0.150
    14.350   197.936     0.150
    14.350   356.910     0.150
    15.863   220.360     0.150
    18.645   251.490     0.150
    19.082   256.360     0.150
    19.082   256.109     0.150
    19.082   472.859     0.150
    20.223   271.360     0.150
    20.223   494.180     0.150
    20.541   273.460     0.150
    20.541   499.460     0.150
    20.474   276.820     0.150
    20.490   277.670     0.150
    20.610   278.561     0.150
    20.855   280.831     0.150
    21.185   284.640     0.150
    21.331   285.851     0.150
    21.382   286.510     0.150
    21.449   286.700     0.150
    21.611   289.561     0.150
    21.794   291.460     0.150
    21.903   291.910     0.150
    21.956   292.460     0.150
    22.223   295.311     0.150
    22.261   295.831     0.150
    22.309   296.351     0.150
    22.317   296.570     0.150
    22.354   296.590     0.150
    22.496   298.400     0.150
    22.736   300.150     0.150
    22.859   301.760     0.150
    22.905   302.190     0.150
    23.029   303.101     0.150
    23.046   304.370     0.150
    23.287   306.420     0.150
    23.305   306.030     0.150
    23.533   308.331     0.150
    23.566   307.980     0.150
    23.596   309.380     0.150
    23.707   310.061     0.150
    23.726   308.771     0.150
    23.784   310.460     0.150
    23.890   311.530     0.150
    23.911   312.880     0.150
    23.910   311.180     0.150
    24.782   319.510     0.150
    25.409   323.541     0.150
    25.409   360.541     0.150
    25.409   596.541     0.150
    25.409   607.541     0.150
    25.415   325.000     0.150
    25.423   324.680     0.150
    25.423   363.680     0.150
    25.423   596.680     0.150
    25.423   611.680     0.150
    25.750   328.081     0.150
    25.880   329.130     0.150
    26.046   330.490     0.150
    26.382   333.000     0.150
    26.382    11.000     0.150
    26.382    17.000     0.150
    26.382   373.000     0.150
    26.382   604.000     0.150
    26.382   627.000     0.150
    26.482   334.240     0.150
    26.499   335.620     0.150
    26.822   334.561     0.150
    26.813   336.900     0.150
    26.859   337.460     0.150
    26.961   339.581     0.150
    27.006   339.200     0.150
    27.298   342.061     0.150
    27.365   342.640     0.150
    27.546   343.180     0.150
    27.680   343.280     0.150
    27.680    12.000     0.150
    27.680    17.000     0.150
    27.680   390.280     0.150
    27.680   620.280     0.150
    27.680   642.280     0.150
    27.680   762.280     0.150
    27.706   344.980     0.150
    27.749   346.140     0.150
    27.876   345.160     0.150
    27.858   346.760     0.150
    27.865   346.870     0.150
    28.166   346.960     0.150
    28.166   629.260     0.150
    27.931   347.530     0.150
    27.961   348.550     0.150
    28.171   347.690     0.150
    28.171    12.000     0.150
    28.171    17.000     0.150
    28.171   396.690     0.150
    28.171   397.690     0.150
    28.171   409.690     0.150
    28.171   540.690     0.150
    28.171   630.690     0.150
    28.171   756.690     0.150
    28.230   349.650     0.150
    28.362   351.340     0.150
    28.377   351.760     0.150
    28.393   351.650     0.150
    28.434   350.300     0.150
    28.434    16.000     0.150
    28.434   400.300     0.150
    28.434   416.300     0.150
    28.434   633.300     0.150
    28.434   661.300     0.150
    28.517   352.331     0.150
    28.531   352.930     0.150
    28.641   352.831     0.150
    28.641    16.000     0.150
    28.641   415.831     0.150
    28.641   638.831     0.150
    28.641   663.831     0.150
    28.647   354.300     0.150
    28.651    13.000     0.150
    28.651    17.000     0.150
    28.651   417.090     0.150
    28.651   636.090     0.150
    28.656   352.930     0.150
    28.656    16.000     0.150
    28.656   638.930     0.150
    28.656   644.930     0.150
    28.686   353.760     0.150
    28.760   355.440     0.150
    28.801   355.150     0.150
    28.934   356.980     0.150
    29.061   357.950     0.150
    29.368   354.360     0.150
    29.368    11.900     0.150
    29.368   409.860     0.150
    29.368   642.860     0.150
    29.122   358.280     0.150
    29.198   359.081     0.150
    29.220   359.581     0.150
    29.410   360.811     0.150
    29.452   362.010     0.150
    29.607   362.710     0.150
    29.850   365.791     0.150
    29.880   365.450     0.150
    29.917   365.170     0.150
    29.940   366.250     0.150
    29.940    13.170     0.150
    29.938   366.530     0.150
    30.004   367.101     0.150
    30.124   367.955     0.150
    30.124    12.706     0.150
    30.196   368.351     0.150
    30.395   370.780     0.150
    30.485   371.090     0.150
    30.687   371.900     0.150
    30.835   374.920     0.150
    31.248   377.420     0.150
    31.400   379.541     0.150
    31.511   379.061     0.150
    31.511   379.184     0.150
    31.511    13.477     0.150
    31.636   380.620     0.150
    31.802   381.851     0.150
    32.224   385.360     0.150
    32.265   386.860     0.150
    32.298   387.070     0.150
    32.354   386.970     0.150
    32.523   388.710     0.150
    33.263   390.360     0.150
    33.074   393.210     0.150
    33.180   395.021     0.150
    33.580   397.500     0.150
    33.595   397.950     0.150
    33.600   398.160     0.150
    33.784   396.360     0.150
    34.191   401.436     0.150
    34.191   728.485     0.150
    34.855   408.061     0.150
    35.708   415.900     0.150
    35.819   417.410     0.150
    35.879   417.530     0.150
    36.032   417.771     0.150
    36.179   417.930     0.150
    36.174   420.160     0.150
    36.215   421.160     0.150
    36.620   419.160     0.150
    36.387   422.410     0.150
    36.393   422.410     0.150
    36.481   422.610     0.150
    36.769   425.061     0.150
    37.285   429.260     0.150
    37.440   431.510     0.150
    37.593   429.990     0.150
    37.876   432.490     0.150
    38.689   437.860     0.150
    38.689   527.860     0.150
    38.689   787.860     0.150
    38.689   809.860     0.150
    38.689   953.860     0.150
    38.930   438.860     0.150
    38.930   791.860     0.150
    38.930   809.860     0.150
    38.710   441.390     0.150
    38.870   442.601     0.150
    38.933   443.710     0.150
    38.933    13.440     0.150
    39.202   446.061     0.150
    39.268   446.400     0.150
    39.395   447.360     0.150
    39.580   447.780     0.150
    40.627   454.260     0.150
    40.627   801.910     0.150
    40.627   818.324     0.150
    41.831   464.070     0.150
    42.190   857.532     0.150
    42.916   471.860     0.150
    42.916   576.860     0.150
    43.189   474.360     0.150
    43.680   479.750     0.150
    43.680   580.581     0.150
    43.680   869.130     0.150
    43.680  1063.240     0.150
    43.680   480.490     0.150
    43.689   480.457     0.150
    43.689    13.851     0.150
    43.689   892.322     0.150
    43.841   482.360     0.150
    44.736   489.880     0.150
    44.736   490.460     0.150
    44.736    13.625     0.150
    44.850   489.550     0.150
    45.489   491.460     0.150
    45.489   889.660     0.150
    45.561   495.410     0.150
    45.853   497.700     0.150
    46.062   498.980     0.150
    46.069   498.610     0.150
    46.404   501.311     0.150
    47.111   505.760     0.150
    47.111   599.760     0.150
    47.111   615.160     0.150
    47.111   908.860     0.150
    47.271   508.150     0.150
    47.592   510.660     0.150
    47.601   510.680     0.150
    47.975   514.260     0.150
    47.988   513.740     0.150
    48.352   515.480     0.150
    48.352   515.860     0.150
    48.352   931.860     0.150
    48.343   516.960     0.150
    48.383   518.818     0.150
    48.383   939.367     0.150
    48.735   518.157     0.150
    48.735   934.610     0.150
    48.735  1105.169     0.150
    49.476   525.340     0.150
    49.605   526.860     0.150
    49.797   526.260     0.150
    49.797   641.860     0.150
    49.797   945.860     0.150
    49.657   526.340     0.150
    49.657   643.000     0.150
    49.657   956.610     0.150
    49.669   526.541     0.150
    49.695   526.530     0.150
    49.844   528.410     0.150
    49.987   529.260     0.150
    50.440   532.920     0.150
    50.618   533.500     0.150
    50.644   534.300     0.150
    51.165   538.331     0.150
    51.333   539.380     0.150
    51.639   541.980     0.150
    51.781   543.070     0.150
    51.880   543.175     0.150
    51.880   982.016     0.150
    52.174   544.660     0.150
    52.174   660.860     0.150
    52.174   981.860     0.150
    52.089   545.541     0.150
    52.188   546.280     0.150
    52.342   548.860     0.150
    52.391   546.390     0.150
    52.503   549.880     0.150
    53.195   552.010     0.150
    53.195    12.603     0.150
    53.029   551.851     0.150
    53.153   551.748     0.150
    53.153   995.279     0.150
    53.013   551.710     0.150
    53.182   551.400     0.150
    53.182    14.270     0.150
    53.389   552.860     0.150
    53.389    18.000     0.150
    53.389   623.860     0.150
    53.389   671.860     0.150
    53.389   997.860     0.150
    53.464  1000.160     0.150
    53.377   552.985     0.150
    53.377   621.035     0.150
    53.377   999.596     0.150
    53.377   553.021     0.150
    53.889   556.640     0.150
    54.068   559.460     0.150
    53.904   558.521     0.150
    53.927   560.860     0.150
    54.463   563.500     0.150
    54.463   566.430     0.150
    54.876  1021.610     0.150
    54.641   564.811     0.150
    54.856   565.860     0.150
    55.145   567.960     0.150
    55.145   627.860     0.150
    55.145  1021.760     0.150
    55.145  1241.660     0.150
    55.342   566.860     0.150
    55.053   567.180     0.150
    55.076   567.650     0.150
    55.244   569.009     0.150
    55.244  1033.256     0.150
    55.244  1051.240     0.150
    55.165   564.771     0.150
    55.526   568.868     0.150
    55.526  1031.778     0.150
    55.526  1155.357     0.150
    55.263   569.791     0.150
    55.276   569.061     0.150
    55.350   569.940     0.150
    55.472   572.021     0.150
    55.481   570.870     0.150
    55.711   571.680     0.150
    55.764   573.880     0.150
    56.461   576.700     0.150
    56.742   579.760     0.150
    57.224   580.860     0.150
    57.224  1051.860     0.150
    57.224  1068.860     0.150
    57.244   581.570     0.150
    56.990   581.061     0.150
    57.600   583.960     0.150
    57.947   585.940     0.150
    58.403   593.360     0.150
    58.846   592.860     0.150
    58.846  1074.860     0.150
    58.860   590.860     0.150
    58.860  1071.860     0.150
    59.700   598.660     0.150
    59.700  1082.860     0.150
    59.771   598.860     0.150
    60.246   603.180     0.150
    60.234   603.530     0.150
    60.869   605.860     0.150
    60.869   741.860     0.150
    60.745   606.170     0.150
    60.745    13.860     0.150
    60.787   608.050     0.150
    60.832   605.760     0.150
    60.899   607.860     0.150
    61.192  1103.741     0.150
    61.356   609.760     0.150
    61.356   609.875     0.150
    61.356  1106.738     0.150
    61.356  2365.460     0.150
    61.353   610.050     0.150
    61.413   610.720     0.150
    61.440   611.000     0.150
    61.440   614.320     0.150
    61.440  1117.370     0.150
    61.440  1241.930     0.150
    61.603   612.561     0.150
    61.603   891.860     0.150
    61.603  1111.860     0.150
    61.466   611.380     0.150
    61.504   610.585     0.150
    61.504  1107.029     0.150
    61.504  2366.061     0.150
    61.564   611.430     0.150
    61.564    13.420     0.150
    61.708   612.700     0.150
    61.764   613.030     0.150
    61.794   613.250     0.150
    61.811   613.370     0.150
    61.845   613.630     0.150
    62.069   613.860     0.150
    62.069   751.860     0.150
    62.069  1351.860     0.150
    61.985   614.581     0.150
    61.998   614.610     0.150
    62.036   614.920     0.150
    62.067   615.120     0.150
    62.145   615.610     0.150
    62.197   615.950     0.150
    62.331   616.890     0.150
    62.357   617.021     0.150
    62.439   616.760     0.150
    62.526   618.771     0.150
    62.564   618.450     0.150
    62.573   619.041     0.150
    62.602   660.750     0.150
    62.602   761.370     0.150
    62.602  1032.081     0.150
    62.749   618.061     0.150
    62.749   764.860     0.150
    62.749  1205.860     0.150
    62.749  1373.860     0.150
    62.534   618.860     0.150
    62.784   619.870     0.150
    62.876   620.480     0.150
    63.127   621.360     0.150
    62.996   621.260     0.150
    63.041   621.920     0.150
    63.038   621.561     0.150
    63.133   621.860     0.150
    63.133   661.860     0.150
    63.133  1126.860     0.150
    63.133  1210.860     0.150
    63.133   622.190     0.150
    63.343   623.450     0.150
    63.511   621.860     0.150
    63.511   661.860     0.150
    63.841   625.561     0.150
    63.790   626.660     0.150
    64.084   626.960     0.150
    64.032   628.260     0.150
    64.072   628.460     0.150
    64.197   629.660     0.150
    64.278   630.061     0.150
    64.278   629.780     0.150
    64.429   630.771     0.150
    64.455   630.940     0.150
    64.509   631.291     0.150
    64.577   631.870     0.150
    64.533   631.450     0.150
    64.643   632.460     0.150
    64.643   632.320     0.150
    64.674   632.960     0.150
    64.678   632.390     0.150
    64.740   632.960     0.150
    64.740   632.791     0.150
    64.783   633.160     0.150
    64.810   633.660     0.150
    64.943   634.200     0.150
    65.122   635.400     0.150
    65.221   636.061     0.150
    65.418   780.061     0.150
    65.418  1151.860     0.150
    65.281   636.510     0.150
    65.513   636.360     0.150
    65.513   779.860     0.150
    65.513  1153.860     0.150
    65.396   637.130     0.150
    65.594   637.860     0.150
    65.594  1159.860     0.150
    65.434   637.490     0.150
    65.443   637.791     0.150
    65.488   637.851     0.150
    65.532   638.150     0.150
    65.694   638.260     0.150
    65.694  1157.061     0.150
    65.694  1229.860     0.150
    65.720   640.260     0.150
    65.702   639.220     0.150
    65.759   639.900     0.150
    65.771   639.670     0.150
    65.773   639.581     0.150
    65.916   640.860     0.150
    65.952   640.840     0.150
    65.988   640.940     0.150
    66.178   640.854     0.150
    66.178  1166.420     0.150
    66.178  1233.108     0.150
    66.049   641.470     0.150
    66.090   640.561     0.150
    66.090   641.601     0.150
    66.293   641.860     0.150
    66.293   791.860     0.150
    66.293  1167.860     0.150
    66.293  1228.860     0.150
    66.320   642.351     0.150
    66.164   642.200     0.150
    66.256   642.791     0.150
    66.714   644.860     0.150
    66.714   677.860     0.150
    66.714   791.860     0.150
    66.714  1171.860     0.150
    66.714  1235.860     0.150
    66.763   646.561     0.150
    66.763   793.061     0.150
    66.823   645.561     0.150
    66.823   789.260     0.150
    66.823  1171.960     0.150
    66.823  1200.561     0.150
    66.823  1237.260     0.150
    66.823  1432.260     0.150
    66.786   646.660     0.150
    66.848   646.581     0.150
    66.874   645.360     0.150
    66.874   646.601     0.150
    66.947   647.500     0.150
    66.965   646.960     0.150
    67.095   648.960     0.150
    67.094   650.561     0.150
    67.094  1178.960     0.150
    67.147   648.550     0.150
    67.354   649.660     0.150
    67.515   649.061     0.150
    67.515    17.900     0.150
    67.515  1178.860     0.150
    67.515  1241.260     0.150
    67.480   650.890     0.150
    67.589   650.700     0.150
    67.527   651.210     0.150
    67.658   652.021     0.150
    67.887   652.860     0.150
    67.887   799.860     0.150
    67.887  1186.860     0.150
    67.887  1245.860     0.150
    67.887  1444.860     0.150
    67.960   654.851     0.150
    67.964   654.010     0.150
    68.014   654.250     0.150
    68.061   653.510     0.150
    68.017   654.061     0.150
    68.017   653.950     0.150
    68.021   654.370     0.150
    68.185   655.291     0.150
    68.319   656.561     0.150
    68.319   656.160     0.150
    68.445   657.030     0.150
    68.479   657.110     0.150
    68.483   657.561     0.150
    68.670   658.660     0.150
    68.936   659.160     0.150
    68.936  1199.561     0.150
    68.936   659.021     0.150
    69.077   660.521     0.150
    69.115   661.430     0.150
    69.141   661.240     0.150
    69.156   661.460     0.150
    69.196   661.581     0.150
    69.391   663.140     0.150
    69.669   665.160     0.150
    69.679   664.570     0.150
    69.614   662.834     0.150
    69.736   665.320     0.150
    69.735   664.760     0.150
    69.735   664.920     0.150
    69.774   665.160     0.150
    69.779   665.170     0.150
    69.803   665.331     0.150
    69.804   665.351     0.150
    69.829   665.490     0.150
    69.724   664.416     0.150
    69.857   665.670     0.150
    69.896   665.930     0.150
    69.896   824.640     0.150
    69.896  1213.601     0.150
    69.896  1471.740     0.150
    69.893   665.890     0.150
    69.900   665.920     0.150
    69.916   666.030     0.150
    70.000   666.581     0.150
    70.050   667.291     0.150
    69.942   665.537     0.150
    69.960   664.678     0.150
    70.032   666.312     0.150
    70.191   666.946     0.150
    70.393   668.730     0.150
    70.396   669.860     0.150
    70.577   668.660     0.150
    70.412   668.185     0.150
    70.688   668.860     0.150
    70.661    14.500     0.150
    70.661   693.260     0.150
    70.661   829.660     0.150
    70.661  1221.460     0.150
    70.972   673.860     0.150
    70.972  1225.860     0.150
    70.974   672.990     0.150
    70.974   833.800     0.150
    70.974  1223.210     0.150
    70.974  1505.260     0.150
    71.155   673.660     0.150
    71.155    17.200     0.150
    71.155   834.860     0.150
    71.155  1226.860     0.150
    71.155  1251.860     0.150
    71.155  1507.860     0.150
    71.253   674.160     0.150
    71.260   674.160     0.150
    71.304   674.561     0.150
    71.306   674.530     0.150
    71.481   675.360     0.150
    71.481   675.950     0.150
    71.660   676.460     0.150
    71.660   694.160     0.150
    71.660   835.960     0.150
    71.660  1232.860     0.150
    71.660  1512.860     0.150
    71.696   677.061     0.150
    71.696    14.800     0.150
    71.696   835.860     0.150
    71.696    15.000     0.150
    71.800   678.061     0.150
    71.800    14.800     0.150
    71.847   677.061     0.150
    71.847   678.061     0.150
    71.847    16.100     0.150
    71.847   829.860     0.150
    71.847  1232.360     0.150
    72.052   677.760     0.150
    71.915   677.960     0.150
    71.915   678.460     0.150
    72.112   679.860     0.150
    72.112  1237.860     0.150
    71.995   678.160     0.150
    72.081   679.940     0.150
    72.126   679.260     0.150
    72.126   679.760     0.150
    72.155   680.081     0.150
    72.369   681.660     0.150
    72.369  1241.860     0.150
    72.328   680.660     0.150
    72.218   679.360     0.150
    72.218   680.030     0.150
    72.294   680.160     0.150
    72.294   680.561     0.150
    72.340   681.460     0.150
    72.340  1241.061     0.150
    72.447   682.030     0.150
    72.494   682.860     0.150
    72.494    19.000     0.150
    72.494  1243.860     0.150
    72.584   682.460     0.150
    72.584    14.100     0.150
    72.584  1242.960     0.150
    72.605   683.061     0.150
    72.605   697.760     0.150
    72.605  1249.260     0.150
    72.605  1519.460     0.150
    72.605   683.061     0.150
    72.605   697.760     0.150
    72.605  1249.260     0.150
    72.605  1519.460     0.150
    72.641   682.561     0.150
    72.641    18.100     0.150
    72.641   846.160     0.150
    72.641  1245.360     0.150
    72.641  1533.960     0.150
    72.649   683.110     0.150
    72.819   682.860     0.150
    72.819  1245.860     0.150
    72.708   683.260     0.150
    72.708  1244.561     0.150
    72.951   683.860     0.150
    72.951    19.300     0.150
    72.951  1246.860     0.150
    72.952   684.860     0.150
    72.981   684.561     0.150
    73.009   685.460     0.150
    73.213   685.061     0.150
    73.314   686.860     0.150
    73.314   854.960     0.150
    73.314  1250.460     0.150
    73.314   686.710     0.150
    73.338   687.460     0.150
    73.364   686.860     0.150
    73.364   701.860     0.150
    73.364  1251.860     0.150
    73.395   687.360     0.150
    73.395  1252.561     0.150
    73.458   687.860     0.150
    73.473   687.860     0.150
    73.783   687.860     0.150
    73.629   688.760     0.150
    73.807   687.860     0.150
    73.657   688.960     0.150
    73.657   688.115     0.150
    73.657  1255.612     0.150
    73.657  2343.985     0.150
    73.654   687.860     0.150
    73.736   688.760     0.150
    73.747   689.601     0.150
    73.929   690.680     0.150
    73.944   690.260     0.150
    73.985   690.860     0.150
    73.985   690.160     0.150
    73.953   707.360     0.150
    73.897   689.490     0.150
    74.064   691.120     0.150
    73.994   706.561     0.150
    74.036   707.760     0.150
    74.122   691.760     0.150
    74.122  1261.561     0.150
    74.123   691.061     0.150
    74.068   706.061     0.150
    74.068   709.960     0.150
    74.145   691.260     0.150
    74.230   691.960     0.150
    74.165   707.760     0.150
    74.168   708.061     0.150
    74.168   711.460     0.150
    74.176   708.160     0.150
    74.275   691.960     0.150
    74.319   705.960     0.150
    74.326   708.360     0.150
    74.418   692.860     0.150
    74.411   693.280     0.150
    74.440   693.460     0.150
    74.447   693.660     0.150
    74.475   693.860     0.150
    74.497   693.760     0.150
    74.533   694.460     0.150
    74.533    10.600     0.150
    74.533   860.860     0.150
    74.533  1259.860     0.150
    74.450   695.660     0.150
    74.450  1291.860     0.150
    74.517   693.160     0.150
    74.665   707.860     0.150
    74.665   862.860     0.150
    74.665  1265.860     0.150
    74.665  1282.860     0.150
    74.665  1294.860     0.150
    74.665  1298.860     0.150
    74.665  1553.860     0.150
    74.622   694.460     0.150
    74.630   694.561     0.150
    74.669   694.061     0.150
    74.691   694.760     0.150
    74.730   694.360     0.150
    74.808   695.860     0.150
    74.834   695.061     0.150
    74.853   696.061     0.150
    74.919   696.360     0.150
    74.980   696.561     0.150
    74.980    13.100     0.150
    74.973   695.860     0.150
    75.100   696.860     0.150
    75.100  1257.860     0.150
    75.159   698.061     0.150
    75.024   697.160     0.150
    75.035   697.160     0.150
    75.050   697.061     0.150
    75.052   696.660     0.150
    75.073   696.960     0.150
    75.104   697.760     0.150
    75.171   698.061     0.150
    75.184   698.061     0.150
    75.193   698.160     0.150
    75.193   698.260     0.150
    75.205   698.260     0.150
    75.286   699.061     0.150
    75.289   699.061     0.150
    75.342   698.860     0.150
    75.493   699.860     0.150
    75.377   698.260     0.150
    75.359   699.360     0.150
    75.384   698.860     0.150
    75.448   699.460     0.150
    75.474   699.960     0.150
    75.470   700.061     0.150
    75.481   699.660     0.150
    75.735   699.561     0.150
    75.601   700.760     0.150
    75.601   700.860     0.150
    75.682   699.760     0.150
    75.713   701.460     0.150
    75.879   699.860     0.150
    75.879   871.860     0.150
    75.879  1276.860     0.150
    75.879  1566.860     0.150
    75.731   701.660     0.150
    75.762   701.760     0.150
    75.762   701.860     0.150
    75.815   700.860     0.150
    75.779   701.500     0.150
    75.858   702.660     0.150
    75.858   702.760     0.150
    75.812   865.860     0.150
    75.909   702.061     0.150
    75.845   710.860     0.150
    75.845  1278.860     0.150
    75.845  1570.860     0.150
    75.950   700.860     0.150
    75.950   879.860     0.150
    75.950  1276.860     0.150
    75.950  1309.860     0.150
    75.909   701.460     0.150
    75.949   702.050     0.150
    75.953   703.160     0.150
    75.955   704.960     0.150
    76.023   703.061     0.150
    76.045   702.860     0.150
    76.024   702.550     0.150
    76.133   702.960     0.150
    76.256   703.360     0.150
    76.277   704.561     0.150
    76.397   703.860     0.150
    76.339   705.240     0.150
    76.371   705.061     0.150
    76.469   704.400     0.150
    76.468   704.860     0.150
    76.459   705.760     0.150
    76.506   704.360     0.150
    76.740   706.660     0.150
    76.581   705.260     0.150
    76.601   705.460     0.150
    76.662   706.680     0.150
    76.707   705.860     0.150
    76.682   707.660     0.150
    76.708   706.360     0.150
    76.690   706.440     0.150
    76.744   705.360     0.150
    76.611   706.390     0.150
    76.779   706.360     0.150
    76.801   706.230     0.150
    76.825   706.760     0.150
    76.825   708.460     0.150
    76.814   707.870     0.150
    76.800   707.750     0.150
    76.963   707.530     0.150
    77.013   708.760     0.150
    77.109   707.860     0.150
    77.096   708.240     0.150
    77.337   708.860     0.150
    77.337   884.860     0.150
    77.205   709.260     0.150
    77.217   708.061     0.150
    77.187   708.660     0.150
    77.227   710.590     0.150
    77.261   711.061     0.150
    77.417   710.061     0.150
    77.417   719.860     0.150
    77.417   884.860     0.150
    77.417  1295.860     0.150
    77.417  1311.860     0.150
    77.417  1318.860     0.150
    77.417  1597.860     0.150
    77.274   709.730     0.150
    77.464   708.860     0.150
    77.420   710.860     0.150
    77.562   710.360     0.150
    77.415   710.160     0.150
    77.488   710.860     0.150
    77.449   711.260     0.150
    77.455   710.760     0.150
    77.464   711.360     0.150
    77.503   710.670     0.150
    77.526   711.760     0.150
    77.558   710.331     0.150
    77.578   710.750     0.150
    77.588   710.490     0.150
    77.623   711.860     0.150
    77.576   711.870     0.150
    77.598   712.021     0.150
    77.615   712.160     0.150
    77.716   710.860     0.150
    77.716  1295.860     0.150
    77.716  1348.860     0.150
    77.716  1598.860     0.150
    77.662   711.960     0.150
    77.703   710.831     0.150
    77.694   710.960     0.150
    77.703   712.960     0.150
    77.751   712.860     0.150
    77.708   711.660     0.150
    77.731   713.160     0.150
    77.782   710.860     0.150
    77.793   710.860     0.150
    77.793   885.860     0.150
    77.793  1297.860     0.150
    77.793  1347.860     0.150
    77.747   712.860     0.150
    77.776   712.960     0.150
    77.781   713.260     0.150
    77.817   713.460     0.150
    77.858   711.860     0.150
    77.996   712.860     0.150
    77.842   712.960     0.150
    77.918   712.860     0.150
    77.918    13.000     0.150
    77.918  1297.860     0.150
    77.918  1323.860     0.150
    77.918  1349.860     0.150
    77.879   713.460     0.150
    77.895   713.160     0.150
    77.911   713.460     0.150
    77.909   714.061     0.150
    77.910   714.160     0.150
    77.920   712.660     0.150
    77.948   712.860     0.150
    77.958   712.870     0.150
    78.039   713.260     0.150
    77.987   713.860     0.150
    78.009   714.260     0.150
    78.010   714.360     0.150
    78.072   712.860     0.150
    78.044   714.660     0.150
    78.040   714.160     0.150
    78.061   714.061     0.150
    78.082   714.160     0.150
    78.116   713.670     0.150
    78.103   715.760     0.150
    78.151   714.960     0.150
    78.210   714.561     0.150
    78.095   713.860     0.150
    78.276   714.360     0.150
    78.257   715.760     0.150
    78.293   714.860     0.150
    78.238   715.160     0.150
    78.375   715.860     0.150
    78.375    16.400     0.150
    78.375   899.860     0.150
    78.375  1306.660     0.150
    78.375  1325.860     0.150
    78.375  1340.061     0.150
    78.299   715.460     0.150
    78.376   714.860     0.150
    78.348   715.260     0.150
    78.398   716.010     0.150
    78.394   716.260     0.150
    78.446   714.800     0.150
    78.456   715.380     0.150
    78.456   715.530     0.150
    78.500   716.630     0.150
    78.524   716.660     0.150
    78.759   721.860     0.150
    78.590   717.460     0.150
    78.620   716.360     0.150
    78.620   717.710     0.150
    78.530   716.061     0.150
    78.650   717.260     0.150
    78.722   716.860     0.150
    78.722    13.000     0.150
    78.722  1309.860     0.150
    78.722  1320.860     0.150
    78.722  1349.860     0.150
    78.722  1621.860     0.150
    78.632   718.460     0.150
    78.632   720.660     0.150
    78.842   717.061     0.150
    78.824   718.750     0.150
    78.702   716.860     0.150
    78.743   717.710     0.150
    78.904   718.860     0.150
    79.130   718.860     0.150
    79.042   719.860     0.150
    79.042  1311.860     0.150
    79.042  1338.860     0.150
    79.042  1359.860     0.150
    79.144   719.561     0.150
    79.136   720.320     0.150
    79.159   720.160     0.150
    79.168   720.160     0.150
    79.308   720.640     0.150
    79.273   721.530     0.150
    79.391   721.780     0.150
    79.493   720.860     0.150
    79.504   721.730     0.150
    79.358   721.120     0.150
    79.358   724.360     0.150
    79.578   722.460     0.150
    79.466   721.120     0.150
    79.712   721.860     0.150
    79.580   721.710     0.150
    79.674   723.160     0.150
    79.761   723.460     0.150
    79.633   721.670     0.150
    79.642   722.650     0.150
    79.849   723.590     0.150
    79.835   724.561     0.150
    79.835    13.300     0.150
    79.835    17.300     0.150
    79.835  1323.860     0.150
    79.835  1354.860     0.150
    79.890   722.680     0.150
    79.864   723.490     0.150
    79.866   723.860     0.150
    79.983   723.170     0.150
    79.984   723.660     0.150
    80.001   723.230     0.150
    80.079   725.260     0.150
    80.048   725.860     0.150
    80.106   725.044     0.150
    80.106  1327.279     0.150
    80.106  1846.410     0.150
    80.106  2328.910     0.150
    80.107   725.490     0.150
    80.262   724.140     0.150
    80.213   725.860     0.150
    80.213  1332.960     0.150
    80.363   725.860     0.150
    80.341   724.880     0.150
    80.396   725.140     0.150
    80.418   726.360     0.150
    80.319   723.811     0.150
    80.580   726.860     0.150
    80.580  1327.860     0.150
    80.650   726.860     0.150
    80.650  1324.360     0.150
    80.521   725.831     0.150
    80.608   727.970     0.150
    80.754   727.740     0.150
    80.899  1845.180     0.150
    80.948   728.900     0.150
    80.789   729.320     0.150
    80.802   729.061     0.150
    80.868   729.860     0.150
    80.860   727.640     0.150
    80.927   729.860     0.150
    80.937   728.860     0.150
    80.937    15.500     0.150
    80.937  1333.860     0.150
    80.801   728.860     0.150
    80.801   925.860     0.150
    81.152   729.960     0.150
    81.143   729.860     0.150
    81.143    12.000     0.150
    81.143  1337.860     0.150
    81.143  1382.860     0.150
    81.143  1393.860     0.150
    81.084   730.360     0.150
    81.050   730.460     0.150
    81.236   730.940     0.150
    80.975   728.360     0.150
    81.239   731.061     0.150
    81.239  1338.360     0.150
    81.139   730.771     0.150
    81.221   731.360     0.150
    81.325   731.300     0.150
    81.191   731.260     0.150
    81.285   731.360     0.150
    81.296   731.561     0.150
    81.327   731.860     0.150
    81.303   731.870     0.150
    81.445   729.860     0.150
    81.445   914.860     0.150
    81.345   731.420     0.150
    81.301   731.860     0.150
    81.373   731.860     0.150
    81.513   731.780     0.150
    81.504   731.860     0.150
    81.545   732.561     0.150
    81.545  1339.561     0.150
    81.406   733.041     0.150
    81.593   732.320     0.150
    81.416   732.360     0.150
    81.528   733.741     0.150
    81.528  1340.992     0.150
    81.430   732.860     0.150
    81.429   732.660     0.150
    81.519   732.061     0.150
    81.488   733.150     0.150
    81.492   733.360     0.150
    81.674   732.780     0.150
    81.583   730.360     0.150
    81.540   733.061     0.150
    81.728   733.740     0.150
    81.732   732.860     0.150
    81.618   733.260     0.150
    81.618  1342.561     0.150
    81.773   733.480     0.150
    81.603   734.000     0.150
    81.808   731.860     0.150
    81.696   733.061     0.150
    81.825   733.500     0.150
    81.821   738.860     0.150
    81.693   734.561     0.150
    81.867   734.360     0.150
    81.775   733.760     0.150
    81.775  1341.561     0.150
    81.785   733.521     0.150
    81.734   734.860     0.150
    81.830   734.360     0.150
    81.842   733.720     0.150
    81.831   733.960     0.150
    81.835   733.760     0.150
    82.074   733.760     0.150
    82.074  1344.960     0.150
    81.978   735.081     0.150
    81.940   735.960     0.150
    82.016   734.760     0.150
    81.875   735.610     0.150
    82.152   736.360     0.150
    82.152  1347.860     0.150
    82.079   734.440     0.150
    82.205   736.260     0.150
    82.205  1342.860     0.150
    82.122   734.640     0.150
    82.072   736.541     0.150
    82.133   735.360     0.150
    82.237   736.860     0.150
    82.182   737.320     0.150
    82.389   736.860     0.150
    82.389    12.000     0.150
    82.315   735.720     0.150
    82.439   736.860     0.150
    82.439  1355.860     0.150
    82.377   738.130     0.150
    82.426   737.460     0.150
    82.455   736.561     0.150
    82.440   738.670     0.150
    82.495   738.980     0.150
    82.582   737.760     0.150
    82.614   737.860     0.150
    82.593   738.760     0.150
    82.610   737.860     0.150
    82.630   737.521     0.150
    82.692   739.860     0.150
    82.835   738.480     0.150
    82.945   739.000     0.150
    82.945   738.960     0.150
    82.945  1352.086     0.150
    82.945  1839.360     0.150
    82.867   740.390     0.150
    83.069   739.626     0.150
    83.069  1353.060     0.150
    82.922   740.500     0.150
    82.988   740.360     0.150
    82.870   739.831     0.150
    83.032   739.120     0.150
    83.040   739.480     0.150
    82.937   740.340     0.150
    83.074   740.780     0.150
    83.130   740.860     0.150
    83.228   741.860     0.150
    83.153   744.460     0.150
    83.372   741.380     0.150
    83.372   740.800     0.150
    83.372  1355.790     0.150
    83.303   742.360     0.150
    83.332   741.081     0.150
    83.424   744.360     0.150
    83.584   741.840     0.150
    83.643   742.860     0.150
    83.675   745.130     0.150
    83.728   743.360     0.150
    83.915   743.360     0.150
    83.791   742.640     0.150
    83.826   743.610     0.150
    83.994   743.360     0.150
    83.994  1360.360     0.150
    83.907   743.400     0.150
    83.998   745.360     0.150
    84.055   746.360     0.150
    84.068   746.860     0.150
    84.168   745.280     0.150
    84.221   747.360     0.150
    84.283   746.760     0.150
    84.435   747.760     0.150
    84.337   745.110     0.150
    84.376   748.220     0.150
    84.465   747.811     0.150
    84.545   746.610     0.150
    84.599   747.760     0.150
    84.578   748.650     0.150
    84.588   746.700     0.150
    84.871   749.860     0.150
    84.871  1368.860     0.150
    84.910   748.860     0.150
    84.984   749.360     0.150
    85.067   750.291     0.150
    85.149   755.150     0.150
    85.204   751.860     0.150
    85.309   753.561     0.150
    85.293   750.900     0.150
    85.423   751.160     0.150
    85.438   753.180     0.150
    85.468   752.260     0.150
    85.735   753.360     0.150
    85.736   753.320     0.150
    85.736   753.450     0.150
    85.815   756.917     0.150
    85.814   753.860     0.150
    85.902   753.360     0.150
    86.128   755.860     0.150
    86.128  1387.360     0.150
    86.221   755.360     0.150
    86.440   760.860     0.150
    86.675   758.160     0.150
    86.733   757.360     0.150
    86.820   759.860     0.150
    87.458   761.360     0.150
    87.424   762.581     0.150
    87.542   762.440     0.150
    87.551   761.860     0.150
    87.567   762.811     0.150
    87.705   761.860     0.150
    87.785   763.800     0.150
    87.789   763.450     0.150
    87.707   762.940     0.150
    87.912   763.260     0.150
    87.986   764.890     0.150
    88.116   765.210     0.150
    88.167   765.380     0.150
    88.821   767.601     0.150
    88.821   770.440     0.150
    88.821  1388.130     0.150
    88.821  1760.430     0.150
    89.584   773.360     0.150
    89.840   777.960     0.150
    89.862   774.561     0.150
    90.244   779.130     0.150
    90.263   779.700     0.150
    90.282   776.180     0.150
    90.330   776.360     0.150
    90.380   776.760     0.150
    90.657   777.760     0.150
    90.706   781.320     0.150
    90.832   778.570     0.150
    91.016   782.720     0.150
    91.308   776.360     0.150
    91.237   784.690     0.150
    91.279   780.660     0.150
    91.670   782.590     0.150
    91.671   779.700     0.150
    91.671   785.690     0.150
    91.867   782.460     0.150
    91.867   997.860     0.150
    92.058   783.240     0.150
    92.043   783.960     0.150
    92.257   785.160     0.150
    92.379   786.360     0.150
    92.568   790.250     0.150
    92.796   791.370     0.150
    92.895   791.750     0.150
    92.938   787.960     0.150
    92.938   787.860     0.150
    93.096   792.370     0.150
    93.151   792.581     0.150
    93.514   788.561     0.150
    93.605   790.860     0.150
    93.605  1011.860     0.150
    93.605  1417.860     0.150
    93.605  1445.860     0.150
    93.605  1537.860     0.150
    93.605  1831.860     0.150
    94.150  1012.360     0.150
    94.472   794.240     0.150
    94.472   797.291     0.150
    94.472  1424.380     0.150
    94.472  1844.360     0.150
    95.454   797.860     0.150
    96.777   805.970     0.150
    96.777  1042.860     0.150
    96.777  1436.610     0.150
    97.061   805.960     0.150
    97.720   809.660     0.150
    98.145   813.360     0.150
    98.615   815.160     0.150
    98.615  1444.260     0.150
    98.615  1474.860     0.150
    98.615  1505.061     0.150
    99.883   819.160     0.150
    99.883  1073.760     0.150
    99.883  1444.061     0.150
   100.449   821.958     0.150
   100.449  1455.260     0.150
   100.451   822.260     0.150
   100.451  1454.760     0.150
   102.265   829.581     0.150
   102.265  1464.120     0.150
   102.265  1956.710     0.150
   103.830  1470.660     0.150
   103.830  1542.061     0.150
   103.970   838.610     0.150
   103.970  1098.610     0.150
   103.970  1798.710     0.150
   107.301  1486.360     0.150
   107.301  1578.260     0.150
   109.220  1099.860     0.150
   114.997  1114.260     0.150
   114.997  1130.561     0.150
   115.400  1117.541     0.150
   115.400  1751.440     0.150
   116.096  1116.160     0.150
   116.096  1132.360     0.150
   117.355  1118.769     0.150
   117.355  1179.479     0.150
   117.355  1527.380     0.150
   117.355  1554.932     0.150
   117.355  1740.634     0.150
   117.355  1119.710     0.150
   117.355  1119.819     0.150
   117.355  1135.419     0.150
   117.355  1741.368     0.150
   120.058  1124.271     0.150
   123.246  1131.311     0.150
   137.101  1154.260     0.150
   142.097  1159.760     0.150
   142.097  1349.860     0.150
   147.215  1171.457     0.150
   147.215  1177.001     0.150
   147.215  1199.664     0.150
   147.652  1176.230     0.150
   147.652  1179.320     0.150
   148.320  1169.860     0.150
   151.234  1181.521     0.150
   151.234  1188.188     0.150
   151.234  1181.359     0.150
   154.756  1188.000     0.150
   154.756  1425.470     0.150
   159.743  1189.260     0.150
   160.410  1192.910     0.150
   160.410  1233.260     0.150
   160.413  1189.960     0.150
   160.550  1188.960     0.150
   161.418  1190.860     0.150
   166.838  1197.860     0.150
     0.820    14.849     0.150
     0.857    15.509     0.150
     0.876    15.749     0.150
     0.960    17.159     0.150
     0.989    17.609     0.150
     1.035    18.029     0.150
     1.021    17.669     0.150
     0.973    17.099     0.150
     1.007    17.249     0.150
     1.100    19.309     0.150
     1.119    19.659     0.150
     1.160    19.589     0.150
     1.224    20.869     0.150
     1.224    35.199     0.150
     1.193    20.709     0.150
     1.307    22.019     0.150
     1.559    25.489     0.150
     1.782    28.609     0.150
     1.980    31.979     0.150
     2.004    32.609     0.150
     2.010    32.549     0.150
     2.025    32.729     0.150
     2.055    31.759     0.150
     2.314    36.249     0.150
     2.630    40.979     0.150
     2.638    41.199     0.150
     2.638    70.079     0.150
     2.649    40.599     0.150
     2.679    41.799     0.150
     2.694    41.439     0.150
     2.694    70.879     0.150
     2.722    41.759     0.150
     2.731    42.299     0.150
     2.947    44.229     0.150
     3.058    46.929     0.150
     3.160    48.449     0.150
     3.209    48.909     0.150
     3.294    50.179     0.150
     3.777    56.349     0.150
     3.744    54.859     0.150
     3.812    56.989     0.150
     3.949    58.629     0.150
     4.044    60.289     0.150
     4.092    59.179     0.150
     4.358    62.589     0.150
     4.425    64.369     0.150
     4.535    66.169     0.150
     4.659    68.219     0.150
     4.610    66.289     0.150
     4.706    68.959     0.150
     4.627    65.769     0.150
     4.735    69.709     0.150
     4.744    69.459     0.150
     4.809    70.009     0.150
     4.801    70.389     0.150
     4.940    71.729     0.150
     5.036    72.869     0.150
     4.988    71.439     0.150
     5.011    71.819     0.150
     5.100    73.119     0.150
     5.245    76.739     0.150
     5.406    77.139     0.150
     5.515    78.449     0.150
     5.609    82.319     0.150
     5.614    80.289     0.150
     5.658    80.969     0.150
     5.728    82.459     0.150
     5.899    84.099     0.150
     5.955    85.569     0.150
     6.041    86.789     0.150
     6.230    89.599     0.150
     6.371    91.999     0.150
     6.582    94.699     0.150
     6.549    94.089     0.150
     6.738    97.099     0.150
     6.862    98.429     0.150
     7.087   100.829     0.150
     7.107   100.929     0.150
     7.124   100.899     0.150
     7.529   106.849     0.150
     7.797   110.309     0.150
     7.902   111.679     0.150
     7.868   111.199     0.150
     8.010   114.019     0.150
     8.031   112.859     0.150
     8.100   115.769     0.150
     8.197   115.369     0.150
     8.197   202.669     0.150
     8.972   128.069     0.150
    10.265   143.809     0.150
    12.898   180.894     0.150
    13.021   182.649     0.150
    14.082   195.049     0.150
    14.351   200.419     0.150
    15.898   218.019     0.150
    18.613   251.749     0.150
    19.049   256.649     0.150
    19.049   257.568     0.150
    20.242   270.719     0.150
    20.242   522.969     0.150
    20.242   734.969     0.150
    20.505   273.569     0.150
    21.368   286.189     0.150
    23.744   310.119     0.150
    23.945   311.107     0.150
    23.948   312.909     0.150
    26.420   334.479     0.150
    26.786   334.069     0.150
    26.998   339.429     0.150
    27.896   346.839     0.150
    27.966   347.769     0.150
    27.999   348.719     0.150
    28.128   344.469     0.150
    28.413   351.829     0.150
    28.839   353.259     0.150
    29.333   354.069     0.150
    29.333    12.900     0.150
    29.236   359.209     0.150
    29.955   365.499     0.150
    29.974   366.379     0.150
    30.162   367.994     0.150
    30.162    12.376     0.150
    30.162   546.200     0.150
    30.162  1899.944     0.150
    30.432   370.789     0.150
    30.722   372.589     0.150
    30.873   374.839     0.150
    31.438   379.599     0.150
    31.546   379.206     0.150
    31.546    13.313     0.150
    31.546    19.013     0.150
    31.546  1895.919     0.150
    31.673   380.989     0.150
    32.561   388.739     0.150
    33.216   394.759     0.150
    33.633   397.959     0.150
    33.636   397.979     0.150
    34.218   400.969     0.150
    34.218    14.550     0.150
    34.218  1886.669     0.150
    34.893   407.929     0.150
    36.583   418.969     0.150
    37.610   431.849     0.150
    38.653   438.469     0.150
    38.907   442.279     0.150
    39.239   445.819     0.150
    39.304   446.449     0.150
    39.614   448.149     0.150
    40.591   453.419     0.150
    43.664   480.449     0.150
    44.773   489.819     0.150
    44.773   489.344     0.150
    44.773    13.573     0.150
    44.773   590.344     0.150
    45.577   494.794     0.150
    46.096   499.189     0.150
    48.318   516.089     0.150
    48.318   514.469     0.150
    48.376   516.969     0.150
    48.418   518.099     0.150
    50.014   529.149     0.150
    50.014    14.420     0.150
    51.194   537.209     0.150
    51.807   542.879     0.150
    52.112   544.839     0.150
    52.112    14.250     0.150
    53.025   552.159     0.150
    53.025    12.730     0.150
    53.158   551.472     0.150
    53.158    12.100     0.150
    53.134   551.269     0.150
    53.359   553.219     0.150
    54.031   557.569     0.150
    53.934   557.499     0.150
    57.206   581.179     0.150
    57.632   583.529     0.150
    60.813   605.769     0.150
    61.342   609.669     0.150
    61.342   609.894     0.150
    61.342    13.775     0.150
    61.342  2367.818     0.150
    61.342  2381.794     0.150
    61.342   609.999     0.150
    61.454   610.769     0.150
    61.486   610.444     0.150
    61.486  2367.294     0.150
    61.486  2372.719     0.150
    61.486  2383.369     0.150
    61.552   611.449     0.150
    61.552   614.259     0.150
    62.032   613.469     0.150
    62.421   616.969     0.150
    63.113   621.679     0.150
    63.483   622.969     0.150
    64.558   631.239     0.150
    65.103   634.729     0.150
    65.708   639.569     0.150
    65.708   784.269     0.150
    65.910   642.469     0.150
    66.678   645.469     0.150
    66.749   798.169     0.150
    67.082   648.469     0.150
    67.082   805.169     0.150
    67.492   648.969     0.150
    67.491   649.669     0.150
    67.566   649.939     0.150
    67.946   653.989     0.150
    68.919   658.669     0.150
    69.657   664.579     0.150
    69.885   665.069     0.150
    70.036   666.539     0.150
    70.375   668.309     0.150
    70.963   671.399     0.150
    71.142   673.069     0.150
    71.142    13.700     0.150
    71.142   693.469     0.150
    71.142  1224.469     0.150
    71.471   674.669     0.150
    71.646   676.269     0.150
    71.646   694.669     0.150
    71.646  1234.769     0.150
    71.683   676.669     0.150
    71.683    19.800     0.150
    71.683  1234.469     0.150
    71.683    19.900     0.150
    71.683  1234.769     0.150
    71.833   677.469     0.150
    71.909   677.369     0.150
    71.987   677.469     0.150
    72.119   678.669     0.150
    72.211   678.769     0.150
    72.286   679.469     0.150
    72.325   680.469     0.150
    72.435   681.519     0.150
    72.569   681.769     0.150
    72.592   682.169     0.150
    72.592    13.900     0.150
    72.592    19.400     0.150
    72.592   682.169     0.150
    72.592    13.900     0.150
    72.592    19.400     0.150
    72.625   681.769     0.150
    72.638   682.809     0.150
    72.781   683.069     0.150
    72.935   683.669     0.150
    72.941   684.569     0.150
    72.966   684.039     0.150
    73.193   684.549     0.150
    73.297   686.469     0.150
    73.297   686.259     0.150
    73.350   686.969     0.150
    73.380   686.669     0.150
    73.447   687.569     0.150
    73.462   687.569     0.150
    73.618   688.469     0.150
    73.644   687.805     0.150
    73.644    14.225     0.150
    73.749   688.469     0.150
    73.725   688.069     0.150
    73.918   690.169     0.150
    73.935   689.669     0.150
    73.974   689.469     0.150
    73.974   690.169     0.150
    73.927   688.849     0.150
    74.053   689.959     0.150
    74.114   690.369     0.150
    74.138   690.669     0.150
    74.218   691.459     0.150
    74.266   691.269     0.150
    74.429   692.169     0.150
    74.508   692.469     0.150
    74.518   693.969     0.150
    74.518    19.300     0.150
    74.660   693.469     0.150
    74.721   693.769     0.150
    74.826   694.269     0.150
    74.841   697.269     0.150
    74.906   695.269     0.150
    74.960   695.769     0.150
    75.037   696.469     0.150
    75.039   696.569     0.150
    75.063   696.369     0.150
    75.196   697.969     0.150
    75.350   698.769     0.150
    75.362   698.369     0.150
    75.371   698.869     0.150
    75.472   699.369     0.150
    75.674   699.069     0.150
    75.775   700.949     0.150
    75.775    12.780     0.150
    75.901   700.869     0.150
    75.930   699.469     0.150
    76.015   702.469     0.150
    76.031   701.869     0.150
    76.021   701.219     0.150
    76.021    14.180     0.150
    76.243   703.439     0.150
    76.266   704.249     0.150
    76.328   704.909     0.150
    76.361   704.369     0.150
    76.449   705.169     0.150
    76.592   704.869     0.150
    76.651   705.969     0.150
    76.698   705.669     0.150
    76.687   706.099     0.150
    76.687    14.180     0.150
    76.815   707.979     0.150
    76.811    13.500     0.150
    76.953   707.509     0.150
    77.003   708.169     0.150
    77.300   709.069     0.150
    77.250   710.569     0.150
    77.264   709.859     0.150
    77.284   709.879     0.150
    77.401   709.469     0.150
    77.404   709.269     0.150
    77.469   710.469     0.150
    77.567   710.329     0.150
    77.587   710.919     0.150
    77.605   711.469     0.150
    77.606   712.069     0.150
    77.655   711.269     0.150
    77.692   710.689     0.150
    77.687   710.369     0.150
    77.700   711.069     0.150
    77.722   712.669     0.150
    77.763   710.469     0.150
    77.744   712.469     0.150
    77.766   712.469     0.150
    77.806   712.869     0.150
    77.831   712.469     0.150
    77.900   713.069     0.150
    77.938   712.269     0.150
    78.013   712.869     0.150
    77.999   713.969     0.150
    78.007   712.969     0.150
    78.034   714.369     0.150
    78.050   713.569     0.150
    78.075   713.669     0.150
    78.104   713.829     0.150
    78.142   714.569     0.150
    78.143   715.169     0.150
    78.200   713.969     0.150
    78.235   714.969     0.150
    78.276   714.469     0.150
    78.338   714.569     0.150
    78.356   714.469     0.150
    78.387   715.969     0.150
    78.434   714.599     0.150
    78.494   716.879     0.150
    78.494    13.560     0.150
    78.617   716.469     0.150
    78.617   717.259     0.150
    78.630   716.469     0.150
    78.760   717.279     0.150
    78.891   718.689     0.150
    79.016   719.469     0.150
    79.016  1306.469     0.150
    79.131   719.549     0.150
    79.131   720.179     0.150
    79.131    13.270     0.150
    79.157   719.169     0.150
    79.270   720.539     0.150
    79.270    14.060     0.150
    79.385   721.269     0.150
    79.385    13.290     0.150
    79.672   722.769     0.150
    80.046   725.469     0.150
    80.102   724.969     0.150
    80.102    13.300     0.150
    80.102  1846.219     0.150
    80.102  2330.818     0.150
    80.102   724.979     0.150
    80.102    14.180     0.150
    80.211   725.169     0.150
    80.741   727.549     0.150
    80.783   729.739     0.150
    80.783    13.840     0.150
    81.048   729.969     0.150
    81.117   730.669     0.150
    81.189   731.869     0.150
    81.300   731.369     0.150
    81.332   731.309     0.150
    81.401   732.339     0.150
    81.401    14.270     0.150
    81.468   732.469     0.150
    81.414   731.869     0.150
    81.428   731.769     0.150
    81.427   732.369     0.150
    81.486   732.719     0.150
    81.486    13.980     0.150
    81.490   732.969     0.150
    81.539   732.969     0.150
    81.600   733.729     0.150
    81.600    13.530     0.150
    81.682   733.209     0.150
    81.691   734.069     0.150
    81.772   731.469     0.150
    81.767   733.389     0.150
    81.824   733.509     0.150
    81.961   734.549     0.150
    82.002   734.569     0.150
    82.061   735.069     0.150
    82.068   736.949     0.150
    82.105   734.189     0.150
    82.116   735.069     0.150
    82.177   736.979     0.150
    82.297   735.069     0.150
    82.408   737.469     0.150
    82.441   736.369     0.150
    82.437   738.069     0.150
    82.491   738.009     0.150
    82.578   738.679     0.150
    82.612   737.509     0.150
    82.688   740.019     0.150
    82.818   737.949     0.150
    82.864   740.379     0.150
    82.864    14.530     0.150
    82.924   739.026     0.150
    82.918   740.419     0.150
    82.918    14.550     0.150
    83.069   740.529     0.150
    83.069    13.990     0.150
    83.114   740.769     0.150
    83.334   740.689     0.150
    83.334   741.219     0.150
    83.334    13.300     0.150
    83.334  1840.819     0.150
    83.316   740.829     0.150
    83.566   741.589     0.150
    83.811   743.529     0.150
    83.890   742.789     0.150
    83.958   744.969     0.150
    83.981   744.969     0.150
    84.044   746.429     0.150
    84.152   745.589     0.150
    84.531   746.649     0.150
    85.718   752.469     0.150
    86.204   755.469     0.150
    86.658   756.469     0.150
    87.533   762.569     0.150
    87.686   761.469     0.150
    87.763   763.649     0.150
    91.655   781.569     0.150
    91.655    12.750     0.150
    91.843   781.969     0.150
    99.858   819.169     0.150
   114.972  1112.869     0.150
   116.071  1113.469     0.150
   116.071  1130.369     0.150
   117.341  1119.177     0.150
   117.341  1132.678     0.150
   117.341  1742.227     0.150
   120.096  1123.254     0.150
   120.096  1138.354     0.150
   147.233  1173.599     0.150
   147.233  1176.699     0.150
   147.633  1174.229     0.150
   147.633  1178.530     0.150
   147.633  1192.629     0.150
   148.299  1172.969     0.150
   151.216  1181.368     0.150
   151.216  1187.168     0.150
   151.216  1201.317     0.150
   151.216  1187.557     0.150
   151.216  1201.201     0.150
   160.401  1247.669     0.150
   160.401  1233.619     0.150
   160.401  1247.219     0.150
     0.348    11.619     0.150
     0.407    11.949     0.150
     0.407    21.449     0.150
     0.520    12.990     0.150
     0.520    23.379     0.150
     0.618    13.959     0.150
     0.618    24.500     0.150
     0.601    13.869     0.150
     0.676    14.400     0.150
     0.722    15.350     0.150
     0.756    15.900     0.150
     0.756    27.400     0.150
     0.781    16.430     0.150
     0.781    27.689     0.150
     0.784    16.469     0.150
     0.754    15.449     0.150
     0.754    27.479     0.150
     0.803    16.469     0.150
     0.803    28.879     0.150
     0.867    16.459     0.150
     0.959    17.379     0.150
     0.959    30.939     0.150
     0.952    17.760     0.150
     0.952    31.469     0.150
     1.016    17.889     0.150
     1.086    20.109     0.150
     1.058    19.240     0.150
     1.058    33.320     0.150
     1.085    19.799     0.150
     1.181    20.299     0.150
     1.181    36.039     0.150
     1.183    20.990     0.150
     1.259    21.680     0.150
     1.401    23.930     0.150
     1.451    24.729     0.150
     1.465    25.320     0.150
     1.465    24.570     0.150
     1.465    42.289     0.150
     1.497    25.219     0.150
     1.497    42.820     0.150
     1.532    25.619     0.150
     1.533    25.469     0.150
     1.533    44.770     0.150
     1.819    29.070     0.150
     1.819    50.949     0.150
     1.870    30.959     0.150
     1.929    31.020     0.150
     1.978    31.830     0.150
     1.978    56.209     0.150
     2.010    32.309     0.150
     2.468    39.889     0.150
     2.693    41.670     0.150
     2.735    41.840     0.150
     3.230    48.189     0.150
     3.274    47.979     0.150
     3.346    49.639     0.150
     3.498    51.170     0.150
     3.588    53.559     0.150
     3.588    93.410     0.150
     3.747    54.580     0.150
     3.826    55.879     0.150
     3.950    58.189     0.150
     4.005    57.180     0.150
     4.036    58.650     0.150
     4.166    61.299     0.150
     4.454    64.779     0.150
     4.506    65.479     0.150
     4.500    65.830     0.150
     4.522    65.709     0.150
     4.670    67.490     0.150
     4.687    67.650     0.150
     4.818    69.420     0.150
     4.810    70.490     0.150
     4.993    75.340     0.150
     5.063    72.789     0.150
     5.095    74.420     0.150
     5.109    74.369     0.150
     5.354    77.350     0.150
     5.594    81.080     0.150
     5.630    81.320     0.150
     5.768    82.240     0.150
     5.922    84.729     0.150
     6.173    88.100     0.150
     6.173   151.670     0.150
     6.285    89.750     0.150
     6.868    97.439     0.150
     6.971    98.039     0.150
     6.971   173.090     0.150
     6.971    98.689     0.150
     7.300   104.490     0.150
     7.427   106.240     0.150
     7.512   107.279     0.150
     9.744   136.689     0.150
    13.165   183.084     0.150
    19.343   259.889     0.150
    30.326   366.715     0.150
    31.382   375.094     0.150
    44.599   484.615     0.150
    44.784   487.742     0.150
     0.717    13.516     0.150
     0.717    24.027     0.150
     0.631    13.055     0.150
     0.795    15.137     0.150
     0.683    13.676     0.150
     0.791    14.707     0.150
     0.811    15.008     0.150
     0.840    15.637     0.150
     0.845    15.977     0.150
     0.855    15.637     0.150
     0.922    16.816     0.150
     0.922    29.227     0.150
     0.955    17.035     0.150
     0.999    17.895     0.150
     0.996    17.785     0.150
     1.062    18.527     0.150
     1.074    19.145     0.150
     1.116    20.207     0.150
     1.116    35.547     0.150
     1.215    20.758     0.150
     1.404    23.316     0.150
     1.531    25.918     0.150
     1.555    26.465     0.150
     1.558    26.496     0.150
     1.559    26.508     0.150
     1.563    26.477     0.150
     1.756    27.465     0.150
     1.860    30.438     0.150
     2.150    34.215     0.150
     2.175    34.176     0.150
     2.161    33.988     0.150
     2.225    35.055     0.150
     2.238    34.938     0.150
     2.271    35.707     0.150
     2.278    35.508     0.150
     2.306    35.746     0.150
     2.458    37.707     0.150
     2.570    40.637     0.150
     2.563    39.996     0.150
     2.657    40.586     0.150
     2.702    41.406     0.150
     2.656    41.086     0.150
     2.752    42.047     0.150
     3.255    47.977     0.150
     3.434    51.555     0.150
     3.484    51.965     0.150
     3.507    51.246     0.150
     3.613    55.188     0.150
     3.819    56.637     0.150
     3.785    54.977     0.150
     3.870    56.598     0.150
     3.937    57.086     0.150
     4.047    59.168     0.150
     4.202    60.098     0.150
     4.316    62.715     0.150
     4.452    63.887     0.150
     4.499    64.676     0.150
     4.477    65.008     0.150
     4.546    65.195     0.150
     4.657    67.008     0.150
     4.751    67.465     0.150
     4.848    69.227     0.150
     4.887    69.926     0.150
     4.920    70.766     0.150
     5.036    72.375     0.150
     5.021    73.207     0.150
     5.039    73.336     0.150
     5.091    74.578     0.150
     5.170    74.258     0.150
     5.116    74.465     0.150
     5.157    73.965     0.150
     5.227    75.938     0.150
     5.155    75.258     0.150
     5.249    76.117     0.150
     5.253    75.168     0.150
     5.228    75.297     0.150
     5.288    76.438     0.150
     5.343    76.766     0.150
     5.418    77.637     0.150
     5.510    79.035     0.150
     5.521    78.766     0.150
     5.643    80.238     0.150
     5.648    82.066     0.150
     5.743    82.375     0.150
     6.102    86.836     0.150
     6.146    87.848     0.150
     6.120    87.598     0.150
     6.216    88.238     0.150
     6.251    89.215     0.150
     6.320    90.266     0.150
     6.385    91.375     0.150
     6.428    92.137     0.150
     6.466    91.855     0.150
     6.598    93.508     0.150
     6.655    94.496     0.150
     6.695    95.266     0.150
     7.084   100.836     0.150
     7.147   100.035     0.150
     7.385   104.305     0.150
     7.426   104.227     0.150
     7.516   105.395     0.150
     7.624   106.426     0.150
     7.624   107.496     0.150
     7.716   107.566     0.150
     7.716   187.293     0.150
     7.913   111.688     0.150
     8.195   116.027     0.150
     8.281   117.465     0.150
     8.200   115.805     0.150
     8.219   116.707     0.150
     8.301   116.676     0.150
     8.775   123.227     0.150
     9.369   131.637     0.150
     9.967   137.316     0.150
    10.073   141.238     0.150
    10.500   146.285     0.150
    12.542   175.418     0.150
    12.542   310.168     0.150
    13.189   182.906     0.150
    13.862   192.117     0.150
    13.862   363.992     0.150
    14.439   201.426     0.150
    15.701   218.809     0.150
    15.701   385.090     0.150
    19.316   258.855     0.150
    19.316   259.434     0.150
    19.316   474.051     0.150
    19.804   265.863     0.150
    19.804   733.062     0.150
    20.387   271.266     0.150
    20.387   493.965     0.150
    20.370   274.805     0.150
    20.373   275.367     0.150
    20.475   276.375     0.150
    20.723   277.945     0.150
    20.824   280.195     0.150
    20.898   280.328     0.150
    21.005   281.906     0.150
    21.013   281.855     0.150
    21.185   283.547     0.150
    21.216   283.957     0.150
    21.248   284.207     0.150
    21.306   284.348     0.150
    21.491   287.168     0.150
    21.578   287.938     0.150
    21.780   289.316     0.150
    22.152   293.598     0.150
    22.147   293.945     0.150
    22.398   296.156     0.150
    22.412   296.918     0.150
    22.592   298.117     0.150
    22.779   300.266     0.150
    23.280   305.766     0.150
    23.404   305.047     0.150
    23.657   307.746     0.150
    23.733   308.105     0.150
    23.867   310.855     0.150
    23.863   310.797     0.150
    24.538   318.355     0.150
    24.652   317.816     0.150
    25.396   325.078     0.150
    26.367   333.285     0.150
    26.442   334.098     0.150
    26.532   335.395     0.150
    26.583   335.508     0.150
    26.626   334.098     0.150
    26.881   337.707     0.150
    26.970   336.066     0.150
    27.752   345.266     0.150
    27.846   345.176     0.150
    27.969   347.508     0.150
    27.970   347.566     0.150
    28.047   346.676     0.150
    28.172   347.066     0.150
    28.199   348.508     0.150
    28.244   349.285     0.150
    28.566   353.047     0.150
    29.081   357.266     0.150
    29.081    13.641     0.150
    29.303   358.918     0.150
    29.400   360.105     0.150
    29.729   362.977     0.150
    29.795   364.277     0.150
    29.795    13.527     0.150
    29.847   364.637     0.150
    29.847    13.398     0.150
    30.087   366.867     0.150
    30.087   763.090     0.150
    30.158   367.305     0.150
    30.158    13.621     0.150
    30.407   370.348     0.150
    30.893   373.598     0.150
    31.346   376.305     0.150
    32.140   384.535     0.150
    32.139   384.828     0.150
    32.216   385.105     0.150
    32.216    13.250     0.150
    32.255   385.586     0.150
    32.531   387.785     0.150
    33.039   387.367     0.150
    33.071   392.895     0.150
    33.071    13.570     0.150
    33.083   393.297     0.150
    33.083    13.309     0.150
    33.361   394.367     0.150
    33.867   397.891     0.150
    35.544   413.617     0.150
    35.803   416.117     0.150
    36.524   417.266     0.150
    37.553   428.855     0.150
    38.032   434.605     0.150
    38.656   439.766     0.150
    38.656    13.492     0.150
    38.756   440.527     0.150
    40.789   454.668     0.150
    41.542   461.457     0.150
    42.716   470.766     0.150
    42.969   471.965     0.150
    42.937   474.176     0.150
    44.641   488.965     0.150
    45.122   490.891     0.150
    45.379   489.465     0.150
    45.836   494.477     0.150
    45.719   496.418     0.150
    45.812   495.805     0.150
    47.732   511.156     0.150
    48.108   514.387     0.150
    48.222   516.527     0.150
    48.465   517.258     0.150
    48.465    13.707     0.150
    48.473   517.488     0.150
    48.547   516.066     0.150
    48.725   517.375     0.150
    49.434   523.816     0.150
    49.493   525.305     0.150
    49.861   525.566     0.150
    50.863   535.016     0.150
    51.279   540.516     0.150
    52.127   543.957     0.150
    52.242   544.066     0.150
    52.728   548.746     0.150
    52.947   551.254     0.150
    53.319   552.285     0.150
    53.319   552.465     0.150
    53.959   556.867     0.150
    57.281   580.977     0.150
    58.850   591.867     0.150
    58.923   593.043     0.150
    59.767   597.566     0.150
    60.403   601.965     0.150
    60.898   605.965     0.150
    60.898   606.266     0.150
    61.065   606.875     0.150
    61.075   606.516     0.150
    62.006   612.566     0.150
    62.171   613.867     0.150
    62.428   615.168     0.150
    62.428   657.566     0.150
    65.361   635.367     0.150
    65.432   636.867     0.150
    65.541   636.066     0.150
    65.675   637.066     0.150
    65.888   640.066     0.150
    66.077   638.766     0.150
    66.278   641.566     0.150
    66.566   643.566     0.150
    67.114   646.465     0.150
    67.114   673.066     0.150
    67.114  1179.066     0.150
    70.502   669.246     0.150
    70.588   668.066     0.150
    70.696   669.066     0.150
    71.201   673.367     0.150
    71.234   673.367     0.150
    71.394   674.168     0.150
    71.514   674.566     0.150
    71.643   675.766     0.150
    71.738   675.867     0.150
    71.813   675.766     0.150
    71.887   677.465     0.150
    71.897   676.566     0.150
    71.979   678.555     0.150
    72.126   678.566     0.150
    72.126    13.801     0.150
    72.141   678.867     0.150
    72.141   678.867     0.150
    72.196   678.965     0.150
    72.196    14.703     0.150
    72.259   679.668     0.150
    72.259  1235.066     0.150
    72.501   680.867     0.150
    72.871   682.566     0.150
    72.904   683.566     0.150
    72.942   683.066     0.150
    72.987   684.367     0.150
    73.000   684.566     0.150
    73.158   685.465     0.150
    73.198   685.320     0.150
    73.466   686.668     0.150
    73.513   686.668     0.150
    73.513   687.566     0.150
    73.647   687.668     0.150
    73.664   687.867     0.150
    73.798   688.566     0.150
    73.968   690.367     0.150
    74.040   689.766     0.150
    74.081   688.066     0.150
    74.081    18.000     0.150
    74.232   691.168     0.150
    74.254   690.965     0.150
    74.355   691.566     0.150
    74.468   703.066     0.150
    74.509   693.465     0.150
    74.586   694.066     0.150
    74.587   693.965     0.150
    74.599   693.566     0.150
    74.881   695.867     0.150
    74.921   695.465     0.150
    74.923   695.766     0.150
    75.003   696.766     0.150
    75.202   696.668     0.150
    75.427   697.465     0.150
    75.586   699.168     0.150
    75.659   699.465     0.150
    75.663   699.367     0.150
    75.780   702.367     0.150
    75.912   700.066     0.150
    76.125   702.168     0.150
    76.540   705.465     0.150
    76.768   705.668     0.150
    76.827   706.766     0.150
    77.032   707.465     0.150
    77.179   708.066     0.150
    77.228   708.566     0.150
    77.303   709.965     0.150
    77.344   709.965     0.150
    77.352   709.066     0.150
    77.369   709.766     0.150
    77.438   710.168     0.150
    77.475   709.668     0.150
    77.514   711.066     0.150
    77.534   711.266     0.150
    77.668   709.766     0.150
    77.668   720.766     0.150
    77.668   890.266     0.150
    77.668  1287.965     0.150
    77.670   710.766     0.150
    77.735   711.367     0.150
    77.874   712.066     0.150
    77.933   713.367     0.150
    77.950   713.465     0.150
    78.677   715.066     0.150
    78.677    18.000     0.150
    78.677  1307.066     0.150
    78.681   716.668     0.150
    78.845   717.668     0.150
    78.964   717.965     0.150
    79.115   719.367     0.150
    79.520   720.465     0.150
    79.620   722.566     0.150
    79.620   721.887     0.150
    80.293   725.066     0.150
    80.494   726.066     0.150
    80.607   725.066     0.150
    81.633   731.926     0.150
    81.801   732.367     0.150
    81.866   733.008     0.150
    81.997   733.465     0.150
    82.112   734.348     0.150
    82.159   735.266     0.150
    82.388   735.586     0.150
    83.409   740.406     0.150
    83.409   740.516     0.150
    83.842   741.066     0.150
    88.689   765.758     0.150
    88.689   768.188     0.150
    92.110   782.945     0.150
    93.501   788.066     0.150
    94.330   792.555     0.150
    94.330   794.145     0.150
    95.319   797.176     0.150
    95.319   799.035     0.150
   100.853   822.895     0.150
   147.219  1176.215     0.150
   147.645  1176.465     0.150
   150.799  1185.773     0.150
     0.263     8.422     0.150
     0.614    12.973     0.150
     1.215    20.793     0.150
     1.215    36.750     0.150
     1.265    21.543     0.150
     1.343    22.770     0.150
     1.355    22.801     0.150
     1.355    40.461     0.150
     1.400    22.781     0.150
     1.455    24.562     0.150
     1.455    43.602     0.150
     1.466    25.230     0.150
     1.479    25.500     0.150
     1.496    25.383     0.150
     1.502    24.320     0.150
     1.509    24.812     0.150
     1.548    25.102     0.150
     1.573    25.410     0.150
     1.638    26.691     0.150
     1.596    26.031     0.150
     1.705    28.062     0.150
     1.683    27.340     0.150
     1.722    28.480     0.150
     1.718    27.312     0.150
     1.927    30.270     0.150
     1.927    53.180     0.150
     2.001    31.641     0.150
     2.055    32.363     0.150
     2.055    57.492     0.150
     2.053    32.582     0.150
     2.108    33.062     0.150
     2.112    33.031     0.150
     2.481    38.211     0.150
     2.533    38.883     0.150
     2.744    41.062     0.150
     2.812    43.391     0.150
     2.932    43.730     0.150
     3.162    47.922     0.150
     3.197    47.410     0.150
     3.209    47.992     0.150
     3.276    48.973     0.150
     3.364    50.520     0.150
     3.374    49.602     0.150
     3.334    49.090     0.150
     3.446    49.621     0.150
     3.453    50.500     0.150
     3.537    52.160     0.150
     3.849    56.301     0.150
     3.870    56.781     0.150
     3.942    56.910     0.150
     3.942    98.543     0.150
     3.951    57.301     0.150
     3.954    57.000     0.150
     4.077    58.340     0.150
     4.077   100.020     0.150
     4.160    60.262     0.150
     4.241    61.641     0.150
     4.323    63.113     0.150
     4.385    63.531     0.150
     4.385   108.270     0.150
     4.442    64.582     0.150
     4.587    66.152     0.150
     4.541    65.672     0.150
     4.615    66.461     0.150
     4.601    66.801     0.150
     4.601   116.930     0.150
     4.775    68.922     0.150
     4.779    69.012     0.150
     5.151    74.883     0.150
     5.224    75.070     0.150
     5.272    75.172     0.150
     5.368    77.371     0.150
     5.249    75.043     0.150
     5.270    75.340     0.150
     5.529    79.223     0.150
     5.672    82.062     0.150
     5.672   141.250     0.150
     5.707    81.520     0.150
     5.664    81.660     0.150
     5.654    81.051     0.150
     5.690    81.191     0.150
     5.775    83.512     0.150
     5.809    82.492     0.150
     5.931    84.742     0.150
     5.878    84.352     0.150
     5.904    84.730     0.150
     5.916    84.621     0.150
     5.990    85.863     0.150
     5.985    85.691     0.150
     6.034    86.652     0.150
     6.156    88.133     0.150
     6.349    91.000     0.150
     6.611    95.543     0.150
     6.858    97.062     0.150
     6.787    95.570     0.150
     6.928    97.820     0.150
     6.939    98.332     0.150
     7.227   101.473     0.150
     7.282   102.141     0.150
     7.282   182.992     0.150
     8.125   114.590     0.150
    13.310   185.668     0.150
    19.061   257.738     0.150
    29.486   360.492     0.150
    43.983   483.973     0.150
    43.901   480.047     0.150
    45.200   489.793     0.150
    52.758   547.828     0.150
    54.007   558.492     0.150
    60.888   606.191     0.150
    84.019   744.742     0.150
     0.637    13.865     0.150
     0.756    15.046     0.150
     0.814    15.666     0.150
     1.014    18.686     0.150
     1.402    24.346     0.150
     1.544    25.086     0.150
     1.544    43.976     0.150
     1.790    28.945     0.150
     2.039    32.796     0.150
     2.072    32.735     0.150
     2.138    33.746     0.150
     2.367    36.445     0.150
     2.454    38.865     0.150
     2.690    41.206     0.150
     3.070    47.976     0.150
     3.149    46.926     0.150
     3.226    48.726     0.150
     3.299    49.926     0.150
     3.324    49.825     0.150
     3.421    50.065     0.150
     3.488    52.626     0.150
     3.523    53.046     0.150
     3.699    55.315     0.150
     3.746    54.365     0.150
     3.820    55.706     0.150
     3.933    57.726     0.150
     4.187    60.926     0.150
     4.208    60.886     0.150
     4.336    62.016     0.150
     4.399    63.306     0.150
     4.499    64.916     0.150
     4.540    65.296     0.150
     4.740    68.176     0.150
     4.774    69.416     0.150
     4.974    71.546     0.150
     5.022    73.176     0.150
     5.022    73.046     0.150
     5.026    73.266     0.150
     5.044    73.646     0.150
     5.074    72.956     0.150
     5.157    75.096     0.150
     5.197    74.256     0.150
     5.237    75.325     0.150
     5.349    76.626     0.150
     5.495    78.966     0.150
     5.604    79.686     0.150
     5.655    81.166     0.150
     5.961    85.275     0.150
     6.025    85.916     0.150
     6.119    87.815     0.150
     6.169    87.506     0.150
     6.239    89.096     0.150
     6.253    89.496     0.150
     6.253   158.405     0.150
     6.264    89.836     0.150
     6.264   158.065     0.150
     6.474    92.646     0.150
     6.498    92.195     0.150
     6.630    93.916     0.150
     6.745    97.075     0.150
     6.928    98.896     0.150
     6.928   172.825     0.150
     6.992    98.275     0.150
     7.066   100.466     0.150
     7.250   102.386     0.150
     7.477   104.886     0.150
     7.486   105.206     0.150
     7.577   106.916     0.150
     7.577   189.865     0.150
     7.578   106.445     0.150
     7.641   107.796     0.150
     7.724   108.586     0.150
     7.841   110.775     0.150
     8.005   113.646     0.150
     8.091   114.216     0.150
     8.194   116.166     0.150
     8.565   122.766     0.150
    10.050   139.346     0.150
    12.592   176.516     0.150
    12.592   313.615     0.150
    13.753   190.341     0.150
    14.397   198.556     0.150
    15.827   220.091     0.150
    15.827   389.966     0.150
    19.225   258.064     0.150
    19.791   265.110     0.150
    19.791   280.511     0.150
    20.515   273.386     0.150
    21.029   280.985     0.150
    21.327   283.796     0.150
    21.383   284.855     0.150
    21.438   284.886     0.150
    22.335   295.376     0.150
    22.385   295.096     0.150
    23.131   302.916     0.150
    23.144   300.726     0.150
    23.568   306.506     0.150
    23.794   308.115     0.150
    23.852   308.436     0.150
    24.016   311.266     0.150
    25.074   318.785     0.150
    25.563   325.485     0.150
    26.537   334.176     0.150
    26.741   334.035     0.150
    27.034   337.996     0.150
    27.268   337.096     0.150
    27.623   342.285     0.150
    27.871   344.865     0.150
    28.017   346.386     0.150
    28.163   348.105     0.150
    28.324   348.766     0.150
    28.324    15.470     0.150
    28.378   349.655     0.150
    28.730   352.846     0.150
    29.422   358.206     0.150
    29.572   360.865     0.150
    29.790   362.086     0.150
    29.857   363.296     0.150
    29.927   364.485     0.150
    29.927    15.271     0.150
    29.983   364.496     0.150
    30.252   366.490     0.150
    30.252    17.226     0.150
    30.322   367.285     0.150
    30.457    16.220     0.150
    30.478   366.496     0.150
    30.981   373.575     0.150
    31.247   375.126     0.150
    31.470   376.726     0.150
    31.470    15.540     0.150
    31.470   376.815     0.150
    31.470    15.851     0.150
    31.639   378.646     0.150
    32.278   383.855     0.150
    32.278    14.920     0.150
    32.389   383.605     0.150
    32.418   386.035     0.150
    32.829   384.535     0.150
    33.148   392.246     0.150
    33.229   392.966     0.150
    33.229    16.040     0.150
    33.622   396.115     0.150
    33.622    16.030     0.150
    33.917   397.391     0.150
    33.917    17.500     0.150
    35.363   411.016     0.150
    35.363    15.460     0.150
    35.667   413.586     0.150
    35.732   413.766     0.150
    35.956   416.615     0.150
    35.956    15.450     0.150
    37.604   428.445     0.150
    38.897   442.166     0.150
    39.432   445.726     0.150
    39.432    16.050     0.150
    40.667   451.016     0.150
    42.131    17.979     0.150
    43.057   473.985     0.150
    43.057    15.860     0.150
    43.934   478.195     0.150
    44.788   487.190     0.150
    44.788    17.925     0.150
    45.088   489.641     0.150
    45.088    25.750     0.150
    45.853   496.235     0.150
    47.817   511.246     0.150
    48.202   513.775     0.150
    48.438   514.065     0.150
    48.438   514.216     0.150
    48.550   514.814     0.150
    48.554   516.785     0.150
    49.526   524.056     0.150
    49.706   523.166     0.150
    52.757   546.884     0.150
    53.184   550.016     0.150
    55.272   565.155     0.150
    58.678   590.365     0.150
    60.212   598.865     0.150
    60.723   603.466     0.150
    60.723   604.115     0.150
    60.723    24.886     0.150
    60.884   604.240     0.150
    62.973   616.836     0.150
    65.175   633.065     0.150
    65.375   633.766     0.150
    66.364   643.266     0.150
    70.418   666.065     0.150
    70.806   670.266     0.150
    71.026   670.466     0.150
    71.062   671.166     0.150
    71.950   676.766     0.150
    72.712   680.166     0.150
    72.730   681.766     0.150
    72.730    26.500     0.150
    73.024   682.916     0.150
    73.024    18.649     0.150
    73.310   685.065     0.150
    73.349   684.565     0.150
    73.489   685.766     0.150
    73.513   686.065     0.150
    73.640   686.666     0.150
    73.883   687.865     0.150
    74.035   688.865     0.150
    74.200   689.766     0.150
    74.415   691.466     0.150
    74.417   691.666     0.150
    74.438   691.365     0.150
    74.750   693.565     0.150
    75.276   696.466     0.150
    75.411   696.766     0.150
    76.378   703.766     0.150
    77.031   707.065     0.150
    77.075   706.766     0.150