#!/bin/bash
gmt begin kodiak1.21_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-44/44/-44/44
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation kodiak1.21'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     9.128     9.128
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.370    31.091
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.370    31.091 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.967     1.922
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -21.967     1.922 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.540     6.683
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -16.540     6.683 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.578    16.201
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.578    16.201 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -32.390    -1.697
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -32.390    -1.697 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.836    16.982
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -15.836    16.982 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.384    -6.239
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.384    -6.239 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.765    -0.963
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.765    -0.963 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.563    12.940
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -16.563    12.940 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.470     7.890
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.470     7.890 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.245     7.070
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.245     7.070 11
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.854     7.366
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.854     7.366 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.232    -0.995
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.232    -0.995 13
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.330    10.964
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.330    10.964 14
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.928     1.131
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.928     1.131 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -24.464     3.438
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -24.464     3.438 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.234     4.378
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.234     4.378 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.116    -0.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.685     3.718
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.685     3.718 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.537    -4.231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.101     4.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.528    -6.661
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.528    -6.661 22
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.939     6.322
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.166    10.310
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.166    10.310 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.442     3.209
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.731     1.212
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.413     1.052
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.632    -0.814
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.173    -6.164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.042    -2.114
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.983    -0.244
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.582    -3.727
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.227     6.690
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.489     3.508
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.460    -5.855
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.441   -11.737
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.441   -11.737 36
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.461    -4.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.865    -2.914
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.215    -2.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.831    -1.144
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.035     4.639
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.035     4.639 41
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.574     0.334
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.574     0.334 42
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.289     8.283
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.933    -1.510
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.807    12.453
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.807    12.453 45
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.335     6.027
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.335     6.027 46
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.342     8.471
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.456     1.730
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -16.456     1.730 48
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.739     1.806
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.846     0.299
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.880     8.363
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.915    -5.790
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.915    -5.790 52
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.961     1.646
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.911    10.251
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.911    10.251 54
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.535     5.840
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.535     5.840 55
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.674    -4.537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.606     1.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.077    -4.116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.520     4.232
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.436    -4.581
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.023    -1.470
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.829     9.478
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.829     9.478 62
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.953     4.963
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.953     4.963 63
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.921     7.751
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.921     7.751 64
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.745    14.155
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.745    14.155 65
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.319     6.787
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.254     4.679
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.537     6.021
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.713     4.794
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.900     5.368
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.156    -4.985
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.961     1.425
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.152     2.362
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.429    27.848
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.429    27.848 74
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.186    17.801
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.186    17.801 75
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.266     6.017
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.266     6.017 76
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.687     4.659
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -18.687     4.659 77
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.555     2.395
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.744     8.975
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.744     8.975 79
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.653   -14.390
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.653   -14.390 80
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.893     7.594
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.036    -1.223
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.315     4.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.483    -2.541
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.483    -2.541 84
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.817    10.106
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.817    10.106 85
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.563    -4.109
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.482     0.691
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.808     1.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.155     4.520
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.155     4.520 89
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.999     3.704
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.472    -0.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.987     7.021
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.091    -8.185
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.091    -8.185 93
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.519    21.719
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.519    21.719 94
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.456     0.658
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.208     0.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.104    -2.466
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.193     3.160
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.056     3.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.804    -0.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.112    -0.109
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.656    -1.410
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.151     0.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.981     2.298
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.666     1.262
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.508     5.632
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.155     3.461
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.358    11.058
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.358    11.058 108
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.110     4.140
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.434     0.694
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.317    12.531
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.317    12.531 111
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.706     2.039
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.281     5.645
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.276     0.568
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.590    -0.093
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.026     3.765
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.369    -8.574
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.369    -8.574 117
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.740     3.139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.455    -0.706
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.150    -0.035
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.159     3.367
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.187     0.755
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.167     5.055
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.330    -2.246
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.311    -3.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.794     5.647
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.857     7.255
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.811     3.026
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.769     2.430
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.165    -2.850
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.650    -1.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.413     2.404
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.413     2.404 132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.688     6.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.356    -2.440
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.020     9.709
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.020     9.709 135
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.764    -1.436
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.093    -0.856
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.279   -12.874
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.279   -12.874 138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.823     1.450
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.569    -1.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.123    -5.368
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.493     5.448
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.304    -1.428
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.399     0.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.466    -6.147
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.271    -5.099
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.009    -5.372
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.678     9.537
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.678     9.537 148
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.565    -6.779
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.027    -0.796
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.330    -3.960
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.330    -3.960 151
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.268    -1.064
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.113    -6.451
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.634    -7.792
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.280     5.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.473    -3.554
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.211    -8.008
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.211    -8.008 157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.572     1.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.729    -1.803
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.258    -0.560
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.942    -2.577
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.630     0.900
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.105     0.141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.080    -0.269
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.644    -4.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.112    -5.723
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.554     2.803
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.668    12.753
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.668    12.753 168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.304    -0.581
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.619    -0.621
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.786    -3.477
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.664    -6.212
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.233    -5.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.368    -1.896
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.477    -3.020
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.080    -9.080
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.080    -9.080 176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.483    -2.468
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.215    -2.294
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.422    -2.392
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.836    -0.463
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.985    -3.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.174    -1.986
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.603    -0.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.256     0.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.623    -1.962
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.529    -5.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.729     0.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.825    -0.700
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.576    -1.063
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.019    -1.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.241    -8.409
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    17.241    -8.409 191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.664     0.776
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.944   -10.835
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.944   -10.835 193
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.677     0.818
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.438    -4.170
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.191    -8.857
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.191    -8.857 196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.238    -1.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.345    -0.094
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.932    -2.560
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.882     0.253
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.538    -1.777
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.716    -3.367
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.461   -12.918
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.461   -12.918 203
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.583     0.350
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.075    -2.317
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.659   -12.575
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.659   -12.575 206
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.408    -4.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.477     1.911
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.242    -4.399
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.950    -3.002
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.045    -2.561
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.539    -2.335
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.383    -3.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.734     1.217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.712    -4.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.100    -1.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.712    -3.006
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.866    -3.475
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.711    -3.470
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.962     6.858
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.872     4.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.029     7.908
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.137    -3.871
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.709    -3.649
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.635    -3.604
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.488    -6.396
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.488    -6.396 226
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.623     3.535
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.378   -18.722
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.378   -18.722 228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.531    -4.761
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.775    -4.193
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.725     5.160
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.536    -1.966
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.121     1.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.529    -3.342
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.935    -4.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.880     3.256
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.070    -4.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.439    -0.669
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.144    -1.616
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.659    -4.322
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.487    -1.498
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.617     3.035
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.299     0.397
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.164    -0.877
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.617    -1.505
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.814    -3.761
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.199     0.192
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.979    -1.127
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.002    -6.666
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.629    -1.653
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.071     0.679
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.005    -2.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.682     6.941
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.748   -14.272
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.748   -14.272 254
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.110    -6.278
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.738    -0.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.802    -6.293
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.369     5.940
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.647     0.535
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.495     3.748
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.064    -0.861
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.178    -0.575
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.615    -8.020
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.615    -8.020 263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.730    -5.943
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.123     1.666
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.380    -4.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.777    -5.010
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.487    -0.340
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.698    -0.455
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.119    -0.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.487    -6.553
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.487    -6.553 271
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.447    -8.022
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.447    -8.022 272
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.262    -4.364
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.662    -9.965
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.662    -9.965 274
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.590    -1.153
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.114    -3.711
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.724    -2.367
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.351     4.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.805    -7.047
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.805    -7.047 279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.136     1.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.359    -1.357
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.904    -3.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.260     4.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.676     9.671
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.676     9.671 284
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.781    -1.158
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.608     9.733
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.608     9.733 286
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.174     1.659
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.915    -4.124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.432    -3.075
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.125    -3.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.546    -3.449
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.586    -2.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.969     2.398
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.685    -2.748
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.057     3.057
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.379    -7.230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.471     1.757
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.993    -4.695
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.755     1.482
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.184    -2.228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.103    -3.962
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.190    -3.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.874    -2.276
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.179    -1.510
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.520     1.355
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.884    -0.825
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.755     0.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.444    -0.203
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.200    -4.326
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.163     2.099
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.649    -2.107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.557    -3.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.998    -5.710
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.411    -2.411
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.020    -3.337
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.010    -3.852
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.629    -0.566
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.905    -2.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.699    -0.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.120    -0.164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.773    -9.365
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.773    -9.365 321
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.151    -2.359
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.829    -8.976
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.829    -8.976 323
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.848    -3.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.397    -4.058
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.526    -4.512
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.106    -1.212
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.108    -8.539
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.013     0.762
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.348    -5.838
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.644   -16.392
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.644   -16.392 331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.387   -16.592
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.387   -16.592 332
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.011     3.771
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.728   -23.981
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.728   -23.981 334
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.239     0.235
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.522     3.346
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.683    -5.868
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.356    -5.089
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.947     0.219
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.497    -3.069
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.895    -5.437
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.425    -1.821
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.176    -3.414
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.491    -1.978
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.465    -0.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.922     1.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.191     1.954
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.240     1.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.509    -2.616
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.038     0.142
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.072    -1.899
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.804     3.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.029    -1.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.457     3.358
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.437    -0.467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.129    -2.825
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.779     0.812
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.895    -1.740
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.638    -0.761
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.218    -1.551
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.385    -2.743
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.547     4.995
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.504    -1.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.004    -2.365
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.295    -1.860
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.173    -0.504
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.558     0.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.576     0.663
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.152    -4.614
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.717    -0.479
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.364     0.691
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.972     2.972
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.007    -7.443
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.392    -2.583
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.236     7.642
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.885     1.407
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.192    -1.202
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.787     0.871
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.868     1.044
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.336    -2.837
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.419    -1.091
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.211     0.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.702    -2.892
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.839     2.727
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.481    -2.566
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.545     0.178
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.947    -7.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.383    -2.170
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000    -2.599
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.545     4.236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.414    -3.296
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.166     1.056
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.568    -2.954
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.364     0.417
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.538    -0.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.034    -3.181
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.200    -2.291
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.039    -1.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.978    -4.585
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.857     2.121
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.531     0.538
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.041     2.327
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.165    -3.158
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.370     0.871
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.146     2.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.788     2.014
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.366    -0.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.148    -0.100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.475    -2.004
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.276    -0.878
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.979     0.913
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.671    -0.920
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.238    -3.432
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.726    -7.100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.766     0.248
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.172     0.082
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.465     0.049
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.962     1.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.635    -2.093
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.564     0.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.211     1.226
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.485    -1.900
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.454    -1.362
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.507     3.270
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.031    -1.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.730    -2.006
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.010    -0.847
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.180    -0.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.137    -1.891
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.170     1.619
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.720    -4.711
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.614    39.561
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -17.614    39.561 432
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.076    -0.327
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.680     2.725
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.781    -6.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.030    -5.586
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.604    -3.428
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.596    -2.338
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.471    -1.485
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.067    -4.725
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.401    -0.573
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.893    -6.231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.200    -3.811
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.040     3.265
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.377    -0.934
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.286    -1.803
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.370    -4.402
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.370    -4.402 447
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.135     1.934
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.361     0.294
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.637     3.500
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.329    -0.458
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.079    -1.285
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.187    -0.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.909    -0.306
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.605     0.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.062    -7.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.837   -16.375
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.837   -16.375 457
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.114   -18.730
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.114   -18.730 458
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.129    -6.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.447   -15.971
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.447   -15.971 460
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.554   -11.272
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.554   -11.272 461
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.542    -9.826
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.542    -9.826 462
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.697    -4.317
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.481    -6.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.447    -2.408
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.737    -4.574
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.656    -9.124
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.656    -9.124 467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.055     4.054
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.034    -1.752
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.323     1.419
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.612    -6.120
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.139   -13.789
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.139   -13.789 472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.554    -1.534
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.879     1.654
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.532     0.959
EOF
gmt plot $proj $reg -SE -Gred << EOF
     0.460    -0.545     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -42.000    42.000 Author: all ( 475 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -42.000   -42.000 Average =   0.7 km at 139.9 deg; median =    4.6 km
EOF
gmt end
