#!/bin/bash
gmt begin kodiak1.21_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-32/25/0/92
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya50f10+lCounts -BWeSn+t'Focal Depth Mislocation kodiak1.21' << EOF
     1.800
     9.800
    -4.900
     4.600
    -1.900
    -2.800
    -0.400
     7.500
    -9.000
     3.700
     3.500
   -14.600
     7.800
     3.100
     7.600
     3.500
     5.600
    -7.500
     9.400
    -0.400
   -20.200
     6.900
     4.700
    17.600
     1.200
     5.700
   -15.000
     5.400
     6.000
     5.100
     7.600
     5.000
     5.000
    14.100
     4.200
    18.200
    -3.600
    -0.700
     0.900
     5.400
    -1.200
    -9.300
     2.700
     4.800
     2.200
     0.500
     8.900
     2.500
     1.000
     8.000
     3.000
     0.400
    -1.300
     4.800
     2.500
     5.000
     2.000
     3.300
     2.800
     2.900
     8.200
    15.600
     5.800
     0.400
    -1.000
    -8.000
     3.400
     2.800
    -6.600
     2.800
     9.200
     6.200
     3.800
     8.200
     5.700
    14.100
     5.100
     2.500
     1.500
   -14.700
     0.300
     3.800
    -1.900
    -0.600
     7.000
    -7.000
     5.300
     9.400
     5.000
    10.500
     7.700
     1.000
    -1.000
     4.400
     0.900
     2.100
     7.000
     9.000
     2.400
     6.000
     3.700
   -15.800
     2.400
     0.600
     4.600
    -0.100
     0.400
    -8.000
     4.100
     3.100
     0.400
    -0.500
     9.000
    12.400
     3.600
    -0.400
    -3.600
    10.000
     6.600
    -0.900
     0.800
    -0.500
     7.700
    -0.200
    -2.400
     0.400
    -6.000
   -15.000
     3.900
     4.900
     0.300
     0.300
    -1.300
     2.700
     6.000
    -0.000
    10.800
    -3.300
    -0.000
     3.300
    -9.000
    -0.000
    -1.500
     2.100
    -3.100
     1.200
     4.500
   -12.000
   -20.900
    14.600
     5.200
   -13.000
     0.300
     0.600
     5.000
   -17.000
    -2.200
   -22.700
     4.900
     9.600
    -4.300
     4.000
   -14.000
     5.200
    -3.200
    -2.100
    -0.000
     1.700
    -1.600
    -4.400
   -10.000
     1.500
    -2.000
     0.600
    10.500
     0.400
     3.300
     4.100
     1.600
    -7.000
     3.000
    -2.000
    -6.300
     6.100
     4.400
     1.600
    -1.800
     5.100
    -3.100
     1.000
     0.300
     2.000
     2.700
   -19.000
    -0.600
     5.200
     6.300
    -0.100
    -4.800
     2.800
    -2.300
    -5.400
   -18.000
     4.500
     1.500
    -3.100
    -3.100
     0.200
    -1.400
    -0.600
    -2.000
     4.300
     2.000
     3.100
     2.000
    -8.300
     2.200
     0.100
     0.200
    -8.500
     2.000
    11.900
     3.700
    -0.300
     1.900
   -19.800
    -1.400
    -0.100
   -23.200
     1.600
    -0.800
    -4.400
     3.200
    -1.100
    -0.300
     0.500
    -0.600
     1.000
    -6.200
   -15.200
    -0.600
     4.400
     7.500
    -5.400
    -3.100
     0.400
     2.500
     4.700
    -5.500
    -3.100
     2.100
    -0.500
   -11.700
    -7.000
    -0.300
    -3.400
     9.400
     1.600
    13.000
     0.200
     5.200
     3.500
    -6.100
    -1.000
    -0.000
    -2.700
     8.500
    -2.000
     0.100
    -0.000
    -6.800
     0.100
    -4.000
    -3.600
     4.600
     0.300
    -0.100
    -8.200
   -14.200
    10.100
    -7.900
     4.000
    -0.500
     4.300
    10.700
     1.600
     2.700
     8.300
     2.000
    -5.400
    -0.500
    -1.600
     3.900
    14.000
    -1.300
    -8.800
     2.600
     4.700
     5.500
     0.300
     0.400
   -10.000
     9.000
    -0.500
     3.900
     1.800
     4.000
    -4.000
   -14.600
     4.200
     0.400
    -0.300
     4.100
     0.900
     6.000
     7.600
     1.900
    13.000
     2.700
    -0.000
    -8.900
   -13.000
   -15.300
    -2.500
    -0.000
   -26.900
    -0.200
   -16.400
     4.500
    -2.200
   -16.600
   -22.800
     4.700
    -7.300
    -0.200
    -7.700
     2.000
    -0.000
     0.700
     0.600
     4.300
     2.100
    -0.200
     5.900
     6.400
    -0.500
     3.000
     2.000
    -2.400
     9.000
     0.100
    15.500
     4.000
     0.500
     3.400
     4.700
     1.100
     3.000
     2.100
     1.500
     2.200
     0.200
    -0.100
     0.200
     3.400
    -0.200
    -0.600
     2.000
     4.200
    -0.500
    -7.700
    -3.100
    -0.500
     0.300
    -2.200
    -9.900
    -1.100
     3.500
     6.000
     6.200
    -0.000
    -0.700
    10.000
     8.200
     6.500
     0.100
    -2.600
     0.400
    -0.100
     0.200
     3.600
     4.700
     5.700
     1.300
     4.100
     5.600
     2.000
    -2.400
     2.500
    -0.100
     4.200
     0.500
    -1.100
     8.000
    -1.100
    -0.100
    -1.300
     2.600
    -3.000
     1.500
    -0.100
     4.500
     3.000
     3.200
     2.500
    -1.600
     2.000
     1.600
    -0.100
     0.400
     0.300
     8.500
     0.100
    -8.500
    -0.700
    -0.200
    -2.400
     0.400
     0.100
    -0.100
    -1.900
   -21.000
     0.100
     0.300
   -12.000
     1.000
     1.100
     4.100
    -1.100
    -4.000
     2.400
   -13.000
     2.900
    -4.000
     0.700
     0.100
   -17.100
     5.400
     0.700
    -4.000
    -1.500
     2.600
    -2.800
    10.000
    -2.000
     6.000
    -6.100
   -12.000
    -0.000
    -3.800
   -15.000
   -17.000
     4.700
    -0.000
    -0.300
     0.400
     5.300
    -2.500
     0.200
     5.800
    20.200
     7.900
     4.200
    -3.600
     0.100
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.600    81.830 Median =   0.6 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6  0.
  0.6  80.2
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -31.000    87.170 Author: all ( 475 samples)
EOF
gmt end
