#!/bin/bash
gmt begin kodiak1.21_dcal pdf,ps
proj=-JM16.0c+
reg=-R-159.4/-147.7/54.1/60.8
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration kodiak1.21'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -152.492    57.748
  -151.183    57.359
>
  -152.493    57.758
  -151.183    57.359
>
  -152.493    57.758
  -151.357    57.570
>
  -152.493    57.758
  -151.852    57.134
>
  -152.515    57.748
  -152.679    56.881
>
  -152.492    57.748
  -152.394    58.112
>
  -152.492    57.748
  -152.218    57.296
>
  -152.492    57.748
  -151.725    58.210
>
  -152.492    57.748
  -151.237    57.446
>
  -152.492    57.748
  -153.305    58.159
>
  -153.080    57.164
  -152.603    56.500
>
  -153.080    57.164
  -152.624    56.531
>
  -153.080    57.164
  -152.490    56.498
>
  -152.282    57.395
  -151.401    56.799
>
  -152.492    57.748
  -152.879    58.283
>
  -152.492    57.748
  -153.617    58.148
>
  -153.643    58.930
  -153.617    58.148
>
  -152.349    58.628
  -153.617    58.148
>
  -153.643    58.930
  -152.924    58.456
>
  -152.492    57.748
  -152.924    58.456
>
  -153.372    59.359
  -152.924    58.456
>
  -153.435    59.382
  -152.924    58.456
>
  -152.492    57.748
  -153.774    57.461
>
  -152.391    58.610
  -151.402    58.323
>
  -152.492    57.748
  -151.402    58.323
>
  -152.492    57.748
  -151.402    58.323
>
  -152.492    57.748
  -152.513    57.842
>
  -152.391    58.610
  -152.513    57.842
>
  -152.391    58.610
  -152.513    57.842
>
  -154.337    59.185
  -155.031    58.489
>
  -153.643    58.930
  -155.031    58.489
>
  -153.643    58.930
  -155.031    58.489
>
  -152.391    58.610
  -152.694    58.037
>
  -152.492    57.748
  -151.398    58.022
>
  -152.391    58.610
  -151.398    58.022
>
  -153.643    58.930
  -153.608    58.680
>
  -153.643    58.930
  -153.608    58.680
>
  -152.391    58.610
  -153.608    58.680
>
  -152.391    58.610
  -153.608    58.680
>
  -154.337    59.185
  -153.608    58.680
>
  -154.337    59.185
  -153.608    58.680
>
  -153.427    59.335
  -153.608    58.680
>
  -153.431    59.360
  -153.608    58.680
>
  -153.431    59.360
  -153.608    58.680
>
  -153.426    59.363
  -153.608    58.680
>
  -153.372    59.359
  -153.608    58.680
>
  -153.421    59.362
  -153.608    58.680
>
  -153.471    59.370
  -153.608    58.680
>
  -153.435    59.382
  -153.608    58.680
>
  -153.230    59.653
  -153.608    58.680
>
  -153.230    59.653
  -153.608    58.680
>
  -152.492    57.748
  -153.363    57.220
>
  -152.492    57.748
  -153.637    58.104
>
  -152.391    58.610
  -153.637    58.104
>
  -152.391    58.610
  -153.637    58.104
>
  -153.643    58.930
  -153.637    58.104
>
  -153.643    58.930
  -153.637    58.104
>
  -152.492    57.748
  -152.898    58.240
>
  -152.391    58.610
  -152.898    58.240
>
  -153.643    58.930
  -152.898    58.240
>
  -155.326    58.211
  -155.193    58.758
>
  -155.326    58.211
  -155.193    58.758
>
  -155.884    58.265
  -155.193    58.758
>
  -155.884    58.265
  -155.193    58.758
>
  -154.337    59.185
  -155.193    58.758
>
  -154.337    59.185
  -155.193    58.758
>
  -155.229    59.393
  -155.193    58.758
>
  -155.229    59.393
  -155.193    58.758
>
  -155.573    58.054
  -155.193    58.758
>
  -155.573    58.054
  -155.193    58.758
>
  -153.643    58.930
  -155.193    58.758
>
  -152.492    57.748
  -151.830    58.051
>
  -152.391    58.610
  -151.830    58.051
>
  -153.643    58.930
  -153.531    58.694
>
  -152.391    58.610
  -153.531    58.694
>
  -154.337    59.185
  -153.531    58.694
>
  -154.337    59.185
  -153.531    58.694
>
  -153.431    59.360
  -153.531    58.694
>
  -153.372    59.359
  -153.531    58.694
>
  -153.421    59.362
  -153.531    58.694
>
  -153.443    59.364
  -153.531    58.694
>
  -153.471    59.370
  -153.531    58.694
>
  -153.435    59.382
  -153.531    58.694
>
  -153.230    59.653
  -153.531    58.694
>
  -153.230    59.653
  -153.531    58.694
>
  -155.326    58.211
  -155.184    58.256
>
  -155.326    58.211
  -155.184    58.256
>
  -155.494    58.199
  -155.184    58.256
>
  -155.494    58.199
  -155.184    58.256
>
  -155.884    58.265
  -155.184    58.256
>
  -153.643    58.930
  -153.022    58.641
>
  -153.372    59.359
  -153.022    58.641
>
  -153.431    59.360
  -153.022    58.641
>
  -153.421    59.362
  -153.022    58.641
>
  -153.443    59.364
  -153.022    58.641
>
  -153.471    59.370
  -153.022    58.641
>
  -153.435    59.382
  -153.022    58.641
>
  -152.492    57.748
  -153.022    58.641
>
  -152.583    57.783
  -153.640    57.943
>
  -152.583    57.783
  -153.640    57.943
>
  -152.492    57.748
  -153.640    57.943
>
  -152.492    57.748
  -153.640    57.943
>
  -155.301    58.053
  -153.640    57.943
>
  -155.326    58.211
  -153.640    57.943
>
  -155.326    58.211
  -153.640    57.943
>
  -152.391    58.610
  -153.640    57.943
>
  -153.643    58.930
  -153.640    57.943
>
  -153.643    58.930
  -153.640    57.943
>
  -152.583    57.783
  -152.896    57.779
>
  -152.492    57.748
  -152.896    57.779
>
  -152.391    58.610
  -152.896    57.779
>
  -152.391    58.610
  -152.896    57.779
>
  -152.492    57.748
  -151.909    57.562
>
  -152.583    57.783
  -151.909    57.562
>
  -152.583    57.783
  -151.909    57.562
>
  -152.492    57.748
  -153.218    57.854
>
  -152.391    58.610
  -153.218    57.854
>
  -155.301    58.053
  -154.509    58.141
>
  -155.326    58.211
  -154.509    58.141
>
  -155.326    58.211
  -154.509    58.141
>
  -155.573    58.054
  -154.509    58.141
>
  -155.884    58.265
  -154.509    58.141
>
  -155.884    58.265
  -154.509    58.141
>
  -153.643    58.930
  -154.509    58.141
>
  -153.643    58.930
  -154.509    58.141
>
  -153.643    58.930
  -154.095    58.467
>
  -153.643    58.930
  -154.095    58.467
>
  -154.337    59.185
  -154.095    58.467
>
  -154.337    59.185
  -154.095    58.467
>
  -152.391    58.610
  -154.095    58.467
>
  -152.391    58.610
  -154.095    58.467
>
  -155.573    58.054
  -154.095    58.467
>
  -155.573    58.054
  -154.095    58.467
>
  -153.427    59.335
  -154.095    58.467
>
  -153.431    59.360
  -154.095    58.467
>
  -153.443    59.364
  -154.095    58.467
>
  -153.471    59.370
  -154.095    58.467
>
  -153.471    59.370
  -154.095    58.467
>
  -153.421    59.362
  -154.095    58.467
>
  -153.372    59.359
  -154.095    58.467
>
  -153.435    59.382
  -154.095    58.467
>
  -155.884    58.265
  -154.095    58.467
>
  -155.884    58.265
  -154.095    58.467
>
  -152.583    57.783
  -153.695    57.312
>
  -152.583    57.783
  -153.695    57.312
>
  -152.492    57.748
  -153.695    57.312
>
  -152.391    58.610
  -151.595    58.271
>
  -152.391    58.610
  -151.595    58.271
>
  -152.492    57.748
  -151.595    58.271
>
  -152.492    57.748
  -151.595    58.271
>
  -152.391    58.610
  -151.782    58.217
>
  -152.492    57.748
  -151.782    58.217
>
  -154.703    58.498
  -154.872    58.457
>
  -154.703    58.498
  -154.872    58.457
>
  -155.046    58.485
  -154.872    58.457
>
  -155.046    58.485
  -154.872    58.457
>
  -155.326    58.211
  -154.872    58.457
>
  -155.326    58.211
  -154.872    58.457
>
  -155.573    58.054
  -154.872    58.457
>
  -155.884    58.265
  -154.872    58.457
>
  -155.884    58.265
  -154.872    58.457
>
  -153.643    58.930
  -154.872    58.457
>
  -153.643    58.930
  -154.872    58.457
>
  -155.301    58.053
  -154.225    57.356
>
  -155.161    58.134
  -154.225    57.356
>
  -152.583    57.783
  -154.225    57.356
>
  -154.969    58.131
  -154.238    57.343
>
  -152.583    57.783
  -154.238    57.343
>
  -152.492    57.748
  -152.691    57.510
>
  -152.583    57.783
  -152.691    57.510
>
  -154.969    58.131
  -154.190    57.390
>
  -155.301    58.053
  -154.190    57.390
>
  -155.301    58.053
  -154.190    57.390
>
  -155.161    58.134
  -154.190    57.390
>
  -155.573    58.054
  -154.190    57.390
>
  -152.583    57.783
  -154.190    57.390
>
  -152.492    57.748
  -154.190    57.390
>
  -154.969    58.131
  -154.251    57.409
>
  -155.301    58.053
  -154.251    57.409
>
  -155.161    58.134
  -154.251    57.409
>
  -155.573    58.054
  -154.251    57.409
>
  -155.326    58.211
  -154.251    57.409
>
  -152.583    57.783
  -154.251    57.409
>
  -153.643    58.930
  -153.570    58.585
>
  -154.347    58.597
  -153.570    58.585
>
  -154.347    58.597
  -153.570    58.585
>
  -154.546    58.494
  -153.570    58.585
>
  -154.546    58.494
  -153.570    58.585
>
  -152.391    58.610
  -153.570    58.585
>
  -152.391    58.610
  -153.570    58.585
>
  -154.703    58.498
  -153.570    58.585
>
  -154.799    58.384
  -153.570    58.585
>
  -154.337    59.185
  -153.570    58.585
>
  -153.427    59.335
  -153.570    58.585
>
  -153.427    59.335
  -153.570    58.585
>
  -153.431    59.360
  -153.570    58.585
>
  -153.431    59.360
  -153.570    58.585
>
  -153.421    59.362
  -153.570    58.585
>
  -155.006    58.649
  -153.570    58.585
>
  -155.006    58.649
  -153.570    58.585
>
  -153.435    59.382
  -153.570    58.585
>
  -153.435    59.382
  -153.570    58.585
>
  -154.969    58.131
  -153.570    58.585
>
  -152.583    57.783
  -153.570    58.585
>
  -152.583    57.783
  -153.570    58.585
>
  -155.161    58.134
  -153.570    58.585
>
  -155.161    58.134
  -153.570    58.585
>
  -154.969    58.131
  -153.759    57.819
>
  -154.969    58.131
  -153.759    57.819
>
  -152.583    57.783
  -153.759    57.819
>
  -154.546    58.494
  -153.759    57.819
>
  -152.492    57.748
  -153.759    57.819
>
  -154.799    58.384
  -153.759    57.819
>
  -155.161    58.134
  -153.759    57.819
>
  -154.347    58.597
  -153.759    57.819
>
  -154.703    58.498
  -153.759    57.819
>
  -155.301    58.053
  -153.759    57.819
>
  -155.326    58.211
  -153.759    57.819
>
  -155.326    58.211
  -153.759    57.819
>
  -155.046    58.485
  -153.759    57.819
>
  -155.494    58.199
  -153.759    57.819
>
  -155.573    58.054
  -153.759    57.819
>
  -152.492    57.748
  -152.346    57.998
>
  -152.391    58.610
  -152.346    57.998
>
  -154.703    58.498
  -153.934    58.009
>
  -152.583    57.783
  -153.934    58.009
>
  -152.492    57.748
  -153.934    58.009
>
  -154.969    58.131
  -154.959    57.292
>
  -155.326    58.211
  -154.959    57.292
>
  -155.326    58.211
  -154.959    57.292
>
  -155.494    58.199
  -154.959    57.292
>
  -155.573    58.054
  -155.378    57.783
>
  -152.391    58.610
  -153.233    58.380
>
  -152.583    57.783
  -153.233    58.380
>
  -153.643    58.930
  -153.233    58.380
>
  -154.347    58.597
  -153.233    58.380
>
  -154.347    58.597
  -153.233    58.380
>
  -152.492    57.748
  -153.233    58.380
>
  -154.546    58.494
  -153.233    58.380
>
  -154.703    58.498
  -153.233    58.380
>
  -154.799    58.384
  -153.233    58.380
>
  -154.969    58.131
  -153.233    58.380
>
  -155.046    58.485
  -153.233    58.380
>
  -153.427    59.335
  -153.233    58.380
>
  -153.427    59.335
  -153.233    58.380
>
  -155.006    58.649
  -153.233    58.380
>
  -153.372    59.359
  -153.233    58.380
>
  -153.431    59.360
  -153.233    58.380
>
  -153.421    59.362
  -153.233    58.380
>
  -153.421    59.362
  -153.233    58.380
>
  -153.443    59.364
  -153.233    58.380
>
  -154.337    59.185
  -153.233    58.380
>
  -155.884    58.265
  -155.963    58.307
>
  -155.884    58.265
  -155.963    58.307
>
  -155.494    58.199
  -155.963    58.307
>
  -155.494    58.199
  -155.963    58.307
>
  -155.573    58.054
  -155.963    58.307
>
  -155.573    58.054
  -155.963    58.307
>
  -155.326    58.211
  -155.963    58.307
>
  -155.326    58.211
  -155.963    58.307
>
  -155.301    58.053
  -155.963    58.307
>
  -155.301    58.053
  -155.963    58.307
>
  -155.161    58.134
  -155.963    58.307
>
  -155.046    58.485
  -155.963    58.307
>
  -155.046    58.485
  -155.963    58.307
>
  -154.969    58.131
  -155.963    58.307
>
  -154.969    58.131
  -155.963    58.307
>
  -155.006    58.649
  -155.963    58.307
>
  -155.006    58.649
  -155.963    58.307
>
  -154.799    58.384
  -155.963    58.307
>
  -154.799    58.384
  -155.963    58.307
>
  -154.703    58.498
  -155.963    58.307
>
  -154.703    58.498
  -155.963    58.307
>
  -154.546    58.494
  -155.963    58.307
>
  -154.546    58.494
  -155.963    58.307
>
  -154.347    58.597
  -155.963    58.307
>
  -154.347    58.597
  -155.963    58.307
>
  -152.492    57.748
  -153.451    57.975
>
  -154.347    58.597
  -153.451    57.975
>
  -154.347    58.597
  -153.451    57.975
>
  -154.546    58.494
  -153.451    57.975
>
  -154.546    58.494
  -153.451    57.975
>
  -154.969    58.131
  -153.451    57.975
>
  -154.799    58.384
  -153.451    57.975
>
  -154.703    58.498
  -153.451    57.975
>
  -155.161    58.134
  -153.451    57.975
>
  -155.301    58.053
  -153.451    57.975
>
  -155.046    58.485
  -153.451    57.975
>
  -155.046    58.485
  -153.451    57.975
>
  -154.546    58.494
  -154.272    58.637
>
  -154.546    58.494
  -154.272    58.637
>
  -154.703    58.498
  -154.272    58.637
>
  -155.006    58.649
  -154.272    58.637
>
  -154.799    58.384
  -154.272    58.637
>
  -154.799    58.384
  -154.272    58.637
>
  -153.643    58.930
  -154.272    58.637
>
  -155.046    58.485
  -154.272    58.637
>
  -155.046    58.485
  -154.272    58.637
>
  -154.337    59.185
  -154.272    58.637
>
  -154.969    58.131
  -154.272    58.637
>
  -155.161    58.134
  -154.272    58.637
>
  -155.326    58.211
  -154.272    58.637
>
  -153.427    59.335
  -154.272    58.637
>
  -155.494    58.199
  -154.272    58.637
>
  -153.431    59.360
  -154.272    58.637
>
  -153.421    59.362
  -154.272    58.637
>
  -153.372    59.359
  -154.272    58.637
>
  -153.435    59.382
  -154.272    58.637
>
  -155.301    58.053
  -154.272    58.637
>
  -155.573    58.054
  -154.272    58.637
>
  -155.884    58.265
  -154.272    58.637
>
  -155.884    58.265
  -154.272    58.637
>
  -155.301    58.053
  -155.056    57.635
>
  -154.969    58.131
  -155.056    57.635
>
  -154.969    58.131
  -155.056    57.635
>
  -155.161    58.134
  -155.056    57.635
>
  -155.161    58.134
  -155.056    57.635
>
  -155.573    58.054
  -155.056    57.635
>
  -155.573    58.054
  -155.056    57.635
>
  -155.326    58.211
  -155.056    57.635
>
  -155.326    58.211
  -155.056    57.635
>
  -155.494    58.199
  -155.056    57.635
>
  -154.799    58.384
  -155.056    57.635
>
  -154.799    58.384
  -155.056    57.635
>
  -155.884    58.265
  -155.056    57.635
>
  -155.884    58.265
  -155.056    57.635
>
  -155.046    58.485
  -155.056    57.635
>
  -155.046    58.485
  -155.056    57.635
>
  -154.703    58.498
  -155.056    57.635
>
  -154.703    58.498
  -155.056    57.635
>
  -154.546    58.494
  -155.056    57.635
>
  -154.546    58.494
  -155.056    57.635
>
  -155.006    58.649
  -155.158    58.691
>
  -155.006    58.649
  -155.158    58.691
>
  -155.046    58.485
  -155.158    58.691
>
  -154.703    58.498
  -155.158    58.691
>
  -154.703    58.498
  -155.158    58.691
>
  -154.799    58.384
  -155.158    58.691
>
  -154.799    58.384
  -155.158    58.691
>
  -154.546    58.494
  -155.158    58.691
>
  -154.347    58.597
  -155.158    58.691
>
  -154.347    58.597
  -155.158    58.691
>
  -155.326    58.211
  -155.158    58.691
>
  -155.326    58.211
  -155.158    58.691
>
  -155.494    58.199
  -155.158    58.691
>
  -155.494    58.199
  -155.158    58.691
>
  -155.161    58.134
  -155.158    58.691
>
  -155.161    58.134
  -155.158    58.691
>
  -154.969    58.131
  -155.158    58.691
>
  -154.969    58.131
  -155.158    58.691
>
  -155.884    58.265
  -155.158    58.691
>
  -155.884    58.265
  -155.158    58.691
>
  -155.301    58.053
  -155.158    58.691
>
  -154.337    59.185
  -155.158    58.691
>
  -154.337    59.185
  -155.158    58.691
>
  -155.573    58.054
  -155.158    58.691
>
  -155.229    59.393
  -155.158    58.691
>
  -153.643    58.930
  -155.158    58.691
>
  -152.391    58.610
  -151.632    58.168
>
  -155.301    58.053
  -154.785    57.309
>
  -154.969    58.131
  -154.785    57.309
>
  -155.573    58.054
  -154.785    57.309
>
  -155.161    58.134
  -154.785    57.309
>
  -155.326    58.211
  -154.785    57.309
>
  -155.326    58.211
  -154.785    57.309
>
  -155.494    58.199
  -154.785    57.309
>
  -152.492    57.748
  -152.947    56.983
>
  -152.583    57.783
  -152.947    56.983
>
  -152.583    57.783
  -152.947    56.983
>
  -152.492    57.748
  -153.050    56.993
>
  -152.583    57.783
  -153.050    56.993
>
  -155.161    58.134
  -154.653    58.154
>
  -154.347    58.597
  -154.653    58.154
>
  -155.494    58.199
  -154.653    58.154
>
  -155.573    58.054
  -154.653    58.154
>
  -155.161    58.134
  -154.619    57.907
>
  -155.301    58.053
  -154.619    57.907
>
  -155.326    58.211
  -154.619    57.907
>
  -155.326    58.211
  -154.619    57.907
>
  -155.573    58.054
  -154.619    57.907
>
  -155.494    58.199
  -154.619    57.907
>
  -154.347    58.597
  -154.619    57.907
>
  -155.006    58.649
  -154.619    57.907
>
  -155.884    58.265
  -154.619    57.907
>
  -152.492    57.748
  -151.341    58.250
>
  -152.583    57.783
  -151.341    58.250
>
  -152.583    57.783
  -151.341    58.250
>
  -152.583    57.783
  -151.341    58.250
>
  -152.391    58.610
  -153.085    58.230
>
  -152.583    57.783
  -153.085    58.230
>
  -152.583    57.783
  -153.085    58.230
>
  -152.492    57.748
  -153.085    58.230
>
  -154.347    58.597
  -153.085    58.230
>
  -154.703    58.498
  -153.085    58.230
>
  -152.583    57.783
  -153.764    57.900
>
  -152.583    57.783
  -153.764    57.900
>
  -154.969    58.131
  -153.764    57.900
>
  -154.546    58.494
  -153.764    57.900
>
  -154.799    58.384
  -153.764    57.900
>
  -154.347    58.597
  -153.764    57.900
>
  -154.347    58.597
  -153.764    57.900
>
  -154.703    58.498
  -153.764    57.900
>
  -154.703    58.498
  -153.764    57.900
>
  -155.161    58.134
  -153.764    57.900
>
  -155.301    58.053
  -153.764    57.900
>
  -155.046    58.485
  -153.764    57.900
>
  -155.494    58.199
  -153.764    57.900
>
  -155.494    58.199
  -153.764    57.900
>
  -155.573    58.054
  -153.764    57.900
>
  -154.969    58.131
  -154.849    58.097
>
  -155.161    58.134
  -154.849    58.097
>
  -155.301    58.053
  -154.849    58.097
>
  -154.799    58.384
  -154.849    58.097
>
  -154.799    58.384
  -154.849    58.097
>
  -155.326    58.211
  -154.849    58.097
>
  -155.326    58.211
  -154.849    58.097
>
  -155.494    58.199
  -154.849    58.097
>
  -155.494    58.199
  -154.849    58.097
>
  -155.573    58.054
  -154.849    58.097
>
  -154.703    58.498
  -154.849    58.097
>
  -154.546    58.494
  -154.849    58.097
>
  -152.391    58.610
  -153.148    58.682
>
  -154.347    58.597
  -153.148    58.682
>
  -153.427    59.335
  -153.148    58.682
>
  -153.372    59.359
  -153.148    58.682
>
  -153.431    59.360
  -153.148    58.682
>
  -153.471    59.370
  -153.148    58.682
>
  -154.337    59.185
  -153.148    58.682
>
  -154.703    58.498
  -153.148    58.682
>
  -154.799    58.384
  -153.148    58.682
>
  -155.006    58.649
  -153.148    58.682
>
  -153.230    59.653
  -153.148    58.682
>
  -152.583    57.783
  -153.148    58.682
>
  -152.583    57.783
  -153.148    58.682
>
  -152.391    58.610
  -152.012    58.212
>
  -152.583    57.783
  -152.012    58.212
>
  -152.583    57.783
  -152.012    58.212
>
  -154.969    58.131
  -154.305    57.308
>
  -155.301    58.053
  -155.260    57.209
>
  -155.573    58.054
  -155.260    57.209
>
  -155.161    58.134
  -155.260    57.209
>
  -154.969    58.131
  -155.260    57.209
>
  -152.583    57.783
  -151.480    58.339
>
  -152.583    57.783
  -151.480    58.339
>
  -152.583    57.783
  -151.480    58.339
>
  -152.583    57.783
  -151.480    58.339
>
  -153.288    57.222
  -152.925    56.544
>
  -153.288    57.222
  -152.925    56.544
>
  -152.583    57.783
  -152.034    58.426
>
  -152.583    57.783
  -152.034    58.426
>
  -152.583    57.783
  -152.034    58.426
>
  -152.583    57.783
  -152.034    58.426
>
  -153.474    58.758
  -152.034    58.426
>
  -154.969    58.131
  -154.556    57.406
>
  -155.183    58.243
  -154.556    57.406
>
  -155.061    58.297
  -154.556    57.406
>
  -155.061    58.297
  -154.556    57.406
>
  -155.282    58.270
  -154.556    57.406
>
  -155.282    58.270
  -154.556    57.406
>
  -154.182    56.560
  -153.723    56.638
>
  -154.182    56.560
  -153.723    56.638
>
  -153.288    57.222
  -153.723    56.638
>
  -153.288    57.222
  -153.723    56.638
>
  -152.583    57.783
  -153.130    57.727
>
  -152.583    57.783
  -153.130    57.727
>
  -152.583    57.783
  -153.130    57.727
>
  -153.288    57.222
  -153.130    57.727
>
  -153.288    57.222
  -153.130    57.727
>
  -155.006    58.649
  -155.147    58.639
>
  -154.799    58.384
  -155.147    58.639
>
  -155.061    58.297
  -155.147    58.639
>
  -155.061    58.297
  -155.147    58.639
>
  -155.282    58.270
  -155.147    58.639
>
  -155.282    58.270
  -155.147    58.639
>
  -153.918    58.835
  -155.147    58.639
>
  -154.337    59.185
  -155.147    58.639
>
  -153.695    58.799
  -155.147    58.639
>
  -154.347    58.597
  -153.350    58.625
>
  -154.347    58.597
  -153.350    58.625
>
  -153.427    59.335
  -153.350    58.625
>
  -153.435    59.382
  -153.350    58.625
>
  -153.435    59.382
  -153.350    58.625
>
  -154.337    59.185
  -153.350    58.625
>
  -152.583    57.783
  -153.350    58.625
>
  -152.583    57.783
  -153.350    58.625
>
  -155.061    58.297
  -153.350    58.625
>
  -155.061    58.297
  -153.350    58.625
>
  -154.969    58.131
  -153.350    58.625
>
  -153.288    57.222
  -152.605    56.538
>
  -153.288    57.222
  -152.509    56.465
>
  -153.288    57.222
  -152.509    56.465
>
  -152.583    57.783
  -152.206    57.580
>
  -152.583    57.783
  -152.206    57.580
>
  -153.288    57.222
  -152.206    57.580
>
  -153.288    57.222
  -152.206    57.580
>
  -154.347    58.597
  -153.592    58.693
>
  -154.337    59.185
  -153.592    58.693
>
  -153.427    59.335
  -153.592    58.693
>
  -153.443    59.364
  -153.592    58.693
>
  -153.421    59.362
  -153.592    58.693
>
  -153.435    59.382
  -153.592    58.693
>
  -155.006    58.649
  -153.592    58.693
>
  -155.061    58.297
  -153.592    58.693
>
  -155.061    58.297
  -153.592    58.693
>
  -154.969    58.131
  -153.592    58.693
>
  -155.295    58.382
  -153.592    58.693
>
  -155.183    58.243
  -153.592    58.693
>
  -155.282    58.270
  -153.592    58.693
>
  -155.282    58.270
  -153.592    58.693
>
  -153.230    59.653
  -153.592    58.693
>
  -154.347    58.597
  -153.296    58.679
>
  -154.347    58.597
  -153.296    58.679
>
  -153.427    59.335
  -153.296    58.679
>
  -153.427    59.335
  -153.296    58.679
>
  -153.421    59.362
  -153.296    58.679
>
  -153.443    59.364
  -153.296    58.679
>
  -153.435    59.382
  -153.296    58.679
>
  -153.435    59.382
  -153.296    58.679
>
  -154.337    59.185
  -153.296    58.679
>
  -154.337    59.185
  -153.296    58.679
>
  -155.006    58.649
  -153.296    58.679
>
  -155.006    58.649
  -153.296    58.679
>
  -153.230    59.653
  -153.296    58.679
>
  -152.583    57.783
  -153.296    58.679
>
  -152.583    57.783
  -153.296    58.679
>
  -154.182    56.560
  -153.544    56.966
>
  -154.182    56.560
  -153.544    56.966
>
  -152.583    57.783
  -153.544    56.966
>
  -152.583    57.783
  -152.253    58.265
>
  -154.969    58.131
  -154.816    57.653
>
  -155.183    58.243
  -154.816    57.653
>
  -155.061    58.297
  -154.816    57.653
>
  -155.061    58.297
  -154.816    57.653
>
  -155.282    58.270
  -154.816    57.653
>
  -155.282    58.270
  -154.816    57.653
>
  -155.295    58.382
  -154.816    57.653
>
  -156.267    57.689
  -154.816    57.653
>
  -156.267    57.689
  -154.816    57.653
>
  -156.358    57.632
  -154.816    57.653
>
  -153.288    57.222
  -154.816    57.653
>
  -153.288    57.222
  -154.816    57.653
>
  -156.341    58.045
  -154.816    57.653
>
  -155.741    58.440
  -154.816    57.653
>
  -156.607    57.802
  -154.816    57.653
>
  -156.267    57.689
  -155.709    57.612
>
  -156.324    57.764
  -155.709    57.612
>
  -156.607    57.802
  -155.709    57.612
>
  -155.161    58.134
  -155.709    57.612
>
  -155.326    58.211
  -155.709    57.612
>
  -155.326    58.211
  -155.709    57.612
>
  -155.884    58.265
  -155.709    57.612
>
  -154.969    58.131
  -155.709    57.612
>
  -155.282    58.270
  -155.709    57.612
>
  -155.282    58.270
  -155.709    57.612
>
  -155.061    58.297
  -155.709    57.612
>
  -155.061    58.297
  -155.709    57.612
>
  -155.741    58.440
  -155.709    57.612
>
  -152.583    57.783
  -152.897    57.545
>
  -152.583    57.783
  -152.897    57.545
>
  -152.583    57.783
  -152.897    57.545
>
  -152.583    57.783
  -152.897    57.545
>
  -153.288    57.222
  -152.897    57.545
>
  -153.288    57.222
  -152.897    57.545
>
  -152.583    57.783
  -151.773    56.974
>
  -152.583    57.783
  -151.773    56.974
>
  -152.583    57.783
  -151.773    56.974
>
  -153.288    57.222
  -151.773    56.974
>
  -153.288    57.222
  -151.773    56.974
>
  -155.301    58.053
  -155.296    57.694
>
  -155.573    58.054
  -155.296    57.694
>
  -155.161    58.134
  -155.296    57.694
>
  -154.969    58.131
  -155.296    57.694
>
  -155.326    58.211
  -155.296    57.694
>
  -155.326    58.211
  -155.296    57.694
>
  -156.267    57.689
  -155.296    57.694
>
  -156.267    57.689
  -155.296    57.694
>
  -155.282    58.270
  -155.296    57.694
>
  -155.282    58.270
  -155.296    57.694
>
  -156.358    57.632
  -155.296    57.694
>
  -155.061    58.297
  -155.296    57.694
>
  -155.884    58.265
  -155.296    57.694
>
  -156.341    58.045
  -155.296    57.694
>
  -156.607    57.802
  -155.296    57.694
>
  -155.741    58.440
  -155.296    57.694
>
  -154.546    58.494
  -155.296    57.694
>
  -155.006    58.649
  -155.296    57.694
>
  -152.583    57.783
  -152.951    58.409
>
  -152.583    57.783
  -152.951    58.409
>
  -154.347    58.597
  -152.951    58.409
>
  -154.347    58.597
  -152.951    58.409
>
  -154.546    58.494
  -152.951    58.409
>
  -154.799    58.384
  -152.951    58.409
>
  -154.799    58.384
  -152.951    58.409
>
  -154.546    58.494
  -154.572    58.555
>
  -154.799    58.384
  -154.572    58.555
>
  -155.006    58.649
  -154.572    58.555
>
  -155.061    58.297
  -154.572    58.555
>
  -155.061    58.297
  -154.572    58.555
>
  -155.111    58.308
  -154.572    58.555
>
  -155.111    58.308
  -154.572    58.555
>
  -153.918    58.835
  -154.572    58.555
>
  -155.295    58.382
  -154.572    58.555
>
  -154.969    58.131
  -154.572    58.555
>
  -153.695    58.799
  -154.572    58.555
>
  -155.282    58.270
  -154.572    58.555
>
  -155.282    58.270
  -154.572    58.555
>
  -155.326    58.211
  -154.572    58.555
>
  -155.326    58.211
  -154.572    58.555
>
  -153.474    58.758
  -154.572    58.555
>
  -153.643    58.930
  -154.572    58.555
>
  -155.741    58.440
  -154.572    58.555
>
  -153.427    59.335
  -154.572    58.555
>
  -153.427    59.335
  -154.572    58.555
>
  -153.471    59.370
  -154.572    58.555
>
  -153.288    57.222
  -152.639    56.464
>
  -153.288    57.222
  -152.639    56.464
>
  -154.182    56.560
  -152.639    56.464
>
  -154.182    56.560
  -152.639    56.464
>
  -153.288    57.222
  -153.536    57.611
>
  -153.288    57.222
  -153.536    57.611
>
  -152.583    57.783
  -153.536    57.611
>
  -152.583    57.783
  -153.536    57.611
>
  -152.583    57.783
  -153.536    57.611
>
  -152.583    57.783
  -153.536    57.611
>
  -154.969    58.131
  -153.536    57.611
>
  -153.474    58.758
  -152.521    58.521
>
  -153.695    58.799
  -152.521    58.521
>
  -153.643    58.930
  -152.521    58.521
>
  -152.583    57.783
  -152.521    58.521
>
  -152.583    57.783
  -152.521    58.521
>
  -152.583    57.783
  -152.521    58.521
>
  -152.583    57.783
  -152.521    58.521
>
  -153.427    59.335
  -152.521    58.521
>
  -153.427    59.335
  -152.521    58.521
>
  -153.372    59.359
  -152.521    58.521
>
  -153.471    59.370
  -152.521    58.521
>
  -153.435    59.382
  -152.521    58.521
>
  -153.435    59.382
  -152.521    58.521
>
  -154.546    58.494
  -154.236    58.368
>
  -154.799    58.384
  -154.236    58.368
>
  -155.061    58.297
  -154.236    58.368
>
  -155.061    58.297
  -154.236    58.368
>
  -154.969    58.131
  -154.236    58.368
>
  -155.006    58.649
  -154.236    58.368
>
  -155.295    58.382
  -154.236    58.368
>
  -155.282    58.270
  -154.236    58.368
>
  -155.282    58.270
  -154.236    58.368
>
  -153.695    58.799
  -154.236    58.368
>
  -153.474    58.758
  -154.236    58.368
>
  -153.643    58.930
  -154.236    58.368
>
  -155.741    58.440
  -154.236    58.368
>
  -154.337    59.185
  -154.236    58.368
>
  -153.474    58.758
  -152.603    58.157
>
  -153.695    58.799
  -152.603    58.157
>
  -153.643    58.930
  -152.603    58.157
>
  -153.474    58.758
  -153.618    58.444
>
  -153.695    58.799
  -153.618    58.444
>
  -154.347    58.597
  -153.618    58.444
>
  -154.347    58.597
  -153.618    58.444
>
  -153.643    58.930
  -153.618    58.444
>
  -154.799    58.384
  -153.618    58.444
>
  -155.006    58.649
  -153.618    58.444
>
  -155.061    58.297
  -153.618    58.444
>
  -155.061    58.297
  -153.618    58.444
>
  -154.969    58.131
  -153.618    58.444
>
  -154.337    59.185
  -153.618    58.444
>
  -152.583    57.783
  -153.618    58.444
>
  -152.583    57.783
  -153.618    58.444
>
  -153.427    59.335
  -153.618    58.444
>
  -153.427    59.335
  -153.618    58.444
>
  -153.398    59.341
  -153.618    58.444
>
  -155.295    58.382
  -153.618    58.444
>
  -153.372    59.359
  -153.618    58.444
>
  -153.435    59.382
  -153.618    58.444
>
  -152.583    57.783
  -151.554    58.292
>
  -152.583    57.783
  -151.554    58.292
>
  -153.474    58.758
  -153.184    58.447
>
  -153.643    58.930
  -153.184    58.447
>
  -154.347    58.597
  -153.184    58.447
>
  -154.347    58.597
  -153.184    58.447
>
  -152.583    57.783
  -153.184    58.447
>
  -152.583    57.783
  -153.184    58.447
>
  -154.799    58.384
  -153.184    58.447
>
  -153.427    59.335
  -153.184    58.447
>
  -153.427    59.335
  -153.184    58.447
>
  -153.372    59.359
  -153.184    58.447
>
  -155.006    58.649
  -153.184    58.447
>
  -154.969    58.131
  -153.184    58.447
>
  -152.583    57.783
  -153.239    58.085
>
  -152.583    57.783
  -153.239    58.085
>
  -152.583    57.783
  -153.239    58.085
>
  -153.474    58.758
  -153.239    58.085
>
  -153.695    58.799
  -153.239    58.085
>
  -154.347    58.597
  -153.239    58.085
>
  -153.643    58.930
  -153.239    58.085
>
  -154.799    58.384
  -153.239    58.085
>
  -153.288    57.222
  -153.239    58.085
>
  -153.288    57.222
  -153.239    58.085
>
  -154.969    58.131
  -153.239    58.085
>
  -155.061    58.297
  -153.239    58.085
>
  -155.061    58.297
  -153.239    58.085
>
  -154.969    58.131
  -153.875    57.709
>
  -153.288    57.222
  -153.875    57.709
>
  -153.288    57.222
  -153.875    57.709
>
  -152.583    57.783
  -153.875    57.709
>
  -152.583    57.783
  -153.875    57.709
>
  -152.583    57.783
  -153.875    57.709
>
  -154.799    58.384
  -153.875    57.709
>
  -155.111    58.308
  -153.875    57.709
>
  -155.282    58.270
  -153.875    57.709
>
  -155.282    58.270
  -153.875    57.709
>
  -154.347    58.597
  -153.875    57.709
>
  -152.583    57.783
  -152.369    57.399
>
  -152.583    57.783
  -152.369    57.399
>
  -153.288    57.222
  -152.369    57.399
>
  -153.288    57.222
  -154.239    57.345
>
  -153.288    57.222
  -154.239    57.345
>
  -155.301    58.053
  -154.239    57.345
>
  -152.583    57.783
  -154.239    57.345
>
  -152.583    57.783
  -154.239    57.345
>
  -152.583    57.783
  -154.239    57.345
>
  -152.583    57.783
  -154.239    57.345
>
  -154.703    58.498
  -154.793    58.186
>
  -154.703    58.498
  -154.793    58.186
>
  -154.546    58.494
  -154.793    58.186
>
  -154.546    58.494
  -154.793    58.186
>
  -155.006    58.649
  -154.793    58.186
>
  -155.741    58.440
  -154.793    58.186
>
  -153.918    58.835
  -154.793    58.186
>
  -153.918    58.835
  -154.793    58.186
>
  -153.695    58.799
  -154.793    58.186
>
  -153.643    58.930
  -154.793    58.186
>
  -153.288    57.222
  -152.912    56.829
>
  -153.288    57.222
  -152.912    56.829
>
  -152.583    57.783
  -152.912    56.829
>
  -152.583    57.783
  -152.912    56.829
>
  -152.583    57.783
  -152.912    56.829
>
  -152.583    57.783
  -152.912    56.829
>
  -154.182    56.560
  -153.376    56.530
>
  -154.182    56.560
  -153.376    56.530
>
  -153.288    57.222
  -153.376    56.530
>
  -153.288    57.222
  -153.376    56.530
>
  -154.182    56.560
  -152.901    56.294
>
  -154.182    56.560
  -152.901    56.294
>
  -153.288    57.222
  -152.901    56.294
>
  -154.969    58.131
  -154.111    57.721
>
  -153.288    57.222
  -154.111    57.721
>
  -153.288    57.222
  -154.111    57.721
>
  -155.301    58.053
  -154.111    57.721
>
  -154.799    58.384
  -154.111    57.721
>
  -155.061    58.297
  -154.111    57.721
>
  -155.061    58.297
  -154.111    57.721
>
  -152.583    57.783
  -154.111    57.721
>
  -152.583    57.783
  -154.111    57.721
>
  -152.583    57.783
  -154.111    57.721
>
  -155.282    58.270
  -154.111    57.721
>
  -155.282    58.270
  -154.111    57.721
>
  -154.347    58.597
  -154.111    57.721
>
  -154.347    58.597
  -154.111    57.721
>
  -154.347    58.597
  -153.723    58.510
>
  -153.643    58.930
  -153.723    58.510
>
  -155.006    58.649
  -153.723    58.510
>
  -155.061    58.297
  -153.723    58.510
>
  -155.061    58.297
  -153.723    58.510
>
  -155.282    58.270
  -153.723    58.510
>
  -155.282    58.270
  -153.723    58.510
>
  -153.408    59.350
  -153.723    58.510
>
  -153.372    59.359
  -153.723    58.510
>
  -155.326    58.211
  -153.723    58.510
>
  -152.583    57.783
  -153.723    58.510
>
  -152.583    57.783
  -153.723    58.510
>
  -152.583    57.783
  -153.723    58.510
>
  -152.583    57.783
  -153.723    58.510
>
  -154.182    56.560
  -154.180    56.985
>
  -154.182    56.560
  -154.180    56.985
>
  -153.288    57.222
  -154.180    56.985
>
  -153.288    57.222
  -154.180    56.985
>
  -154.546    58.494
  -153.548    58.115
>
  -154.799    58.384
  -153.548    58.115
>
  -154.969    58.131
  -153.548    58.115
>
  -154.969    58.131
  -153.548    58.115
>
  -153.918    58.835
  -153.548    58.115
>
  -155.061    58.297
  -153.548    58.115
>
  -155.061    58.297
  -153.548    58.115
>
  -155.161    58.134
  -153.548    58.115
>
  -155.161    58.134
  -153.548    58.115
>
  -155.301    58.053
  -153.548    58.115
>
  -155.282    58.270
  -153.548    58.115
>
  -155.183    58.243
  -155.189    58.225
>
  -155.202    58.275
  -155.189    58.225
>
  -155.111    58.308
  -155.189    58.225
>
  -155.282    58.270
  -155.189    58.225
>
  -155.282    58.270
  -155.189    58.225
>
  -155.326    58.211
  -155.189    58.225
>
  -155.161    58.134
  -155.189    58.225
>
  -155.295    58.382
  -155.189    58.225
>
  -154.969    58.131
  -155.189    58.225
>
  -155.494    58.199
  -155.189    58.225
>
  -155.301    58.053
  -155.189    58.225
>
  -155.573    58.054
  -155.189    58.225
>
  -154.703    58.498
  -155.189    58.225
>
  -155.741    58.440
  -155.189    58.225
>
  -155.884    58.265
  -155.189    58.225
>
  -154.546    58.494
  -155.189    58.225
>
  -156.267    57.689
  -155.189    58.225
>
  -153.918    58.835
  -155.189    58.225
>
  -156.878    57.998
  -155.189    58.225
>
  -153.918    58.835
  -153.190    58.618
>
  -153.427    59.335
  -153.190    58.618
>
  -153.427    59.335
  -153.190    58.618
>
  -153.372    59.359
  -153.190    58.618
>
  -154.546    58.494
  -153.190    58.618
>
  -153.471    59.370
  -153.190    58.618
>
  -153.435    59.382
  -153.190    58.618
>
  -153.435    59.382
  -153.190    58.618
>
  -154.703    58.498
  -153.190    58.618
>
  -152.583    57.783
  -153.190    58.618
>
  -152.583    57.783
  -153.190    58.618
>
  -154.799    58.384
  -153.190    58.618
>
  -154.347    58.597
  -154.299    58.544
>
  -154.799    58.384
  -154.299    58.544
>
  -153.918    58.835
  -154.299    58.544
>
  -155.202    58.275
  -154.299    58.544
>
  -155.282    58.270
  -154.299    58.544
>
  -155.282    58.270
  -154.299    58.544
>
  -155.494    58.199
  -154.299    58.544
>
  -155.301    58.053
  -154.299    58.544
>
  -153.471    59.370
  -154.299    58.544
>
  -153.372    59.359
  -154.299    58.544
>
  -153.435    59.382
  -154.299    58.544
>
  -155.295    58.382
  -155.247    58.726
>
  -154.703    58.498
  -155.247    58.726
>
  -154.703    58.498
  -155.247    58.726
>
  -155.202    58.275
  -155.247    58.726
>
  -155.282    58.270
  -155.247    58.726
>
  -155.282    58.270
  -155.247    58.726
>
  -155.494    58.199
  -155.247    58.726
>
  -155.884    58.265
  -155.247    58.726
>
  -155.301    58.053
  -155.247    58.726
>
  -153.918    58.835
  -155.247    58.726
>
  -155.573    58.054
  -155.247    58.726
>
  -152.583    57.783
  -151.738    58.180
>
  -152.583    57.783
  -151.738    58.180
>
  -152.583    57.783
  -151.738    58.180
>
  -152.583    57.783
  -151.738    58.180
>
  -153.918    58.835
  -153.859    58.690
>
  -153.471    59.370
  -153.859    58.690
>
  -153.435    59.382
  -153.859    58.690
>
  -153.435    59.382
  -153.859    58.690
>
  -155.282    58.270
  -153.859    58.690
>
  -155.282    58.270
  -153.859    58.690
>
  -155.326    58.211
  -153.859    58.690
>
  -153.918    58.835
  -153.939    58.774
>
  -154.546    58.494
  -153.939    58.774
>
  -153.427    59.335
  -153.939    58.774
>
  -153.471    59.370
  -153.939    58.774
>
  -153.435    59.382
  -153.939    58.774
>
  -153.435    59.382
  -153.939    58.774
>
  -153.427    59.335
  -152.647    58.705
>
  -153.427    59.335
  -152.647    58.705
>
  -153.435    59.382
  -152.647    58.705
>
  -153.471    59.370
  -152.647    58.705
>
  -152.583    57.783
  -152.647    58.705
>
  -152.583    57.783
  -152.647    58.705
>
  -152.583    57.783
  -151.869    58.057
>
  -152.583    57.783
  -151.869    58.057
>
  -152.583    57.783
  -151.869    58.057
>
  -152.583    57.783
  -151.869    58.057
>
  -153.288    57.222
  -153.938    57.656
>
  -153.288    57.222
  -153.938    57.656
>
  -152.583    57.783
  -153.938    57.656
>
  -152.583    57.783
  -153.938    57.656
>
  -154.546    58.494
  -153.938    57.656
>
  -155.326    58.211
  -153.938    57.656
>
  -155.326    58.211
  -153.938    57.656
>
  -155.282    58.270
  -153.938    57.656
>
  -155.282    58.270
  -153.938    57.656
>
  -153.288    57.222
  -152.913    56.912
>
  -153.288    57.222
  -152.913    56.912
>
  -154.182    56.560
  -152.913    56.912
>
  -154.182    56.560
  -152.913    56.912
>
  -154.182    56.560
  -152.913    56.912
>
  -152.583    57.783
  -152.913    56.912
>
  -152.583    57.783
  -152.913    56.912
>
  -154.347    58.597
  -153.454    58.705
>
  -154.347    58.597
  -153.454    58.705
>
  -154.546    58.494
  -153.454    58.705
>
  -153.435    59.382
  -153.454    58.705
>
  -154.703    58.498
  -153.454    58.705
>
  -154.799    58.384
  -153.454    58.705
>
  -155.006    58.649
  -153.454    58.705
>
  -155.006    58.649
  -153.454    58.705
>
  -154.182    56.560
  -154.079    56.560
>
  -154.182    56.560
  -154.079    56.560
>
  -153.288    57.222
  -154.079    56.560
>
  -153.288    57.222
  -154.079    56.560
>
  -154.182    56.560
  -155.033    56.798
>
  -154.182    56.560
  -155.033    56.798
>
  -154.182    56.560
  -155.075    56.810
>
  -154.182    56.560
  -155.075    56.810
>
  -154.182    56.560
  -155.028    56.828
>
  -154.182    56.560
  -155.028    56.828
>
  -154.546    58.494
  -153.942    58.432
>
  -154.546    58.494
  -153.942    58.432
>
  -154.703    58.498
  -153.942    58.432
>
  -155.006    58.649
  -153.942    58.432
>
  -155.111    58.308
  -153.942    58.432
>
  -155.111    58.308
  -153.942    58.432
>
  -155.301    58.053
  -153.942    58.432
>
  -155.494    58.199
  -153.942    58.432
>
  -152.583    57.783
  -153.942    58.432
>
  -152.583    57.783
  -153.942    58.432
>
  -153.414    59.355
  -153.942    58.432
>
  -153.414    59.355
  -153.942    58.432
>
  -153.443    59.364
  -153.942    58.432
>
  -153.421    59.362
  -153.942    58.432
>
  -155.573    58.054
  -153.942    58.432
>
  -153.357    59.370
  -153.942    58.432
>
  -153.357    59.370
  -153.942    58.432
>
  -153.435    59.382
  -153.942    58.432
>
  -153.435    59.382
  -153.942    58.432
>
  -153.288    57.222
  -152.837    56.869
>
  -153.288    57.222
  -152.837    56.869
>
  -154.182    56.560
  -152.837    56.869
>
  -154.182    56.560
  -152.837    56.869
>
  -152.583    57.783
  -152.837    56.869
>
  -152.583    57.783
  -152.837    56.869
>
  -154.546    58.494
  -153.670    58.609
>
  -154.703    58.498
  -153.670    58.609
>
  -154.703    58.498
  -153.670    58.609
>
  -155.006    58.649
  -153.670    58.609
>
  -155.006    58.649
  -153.670    58.609
>
  -153.408    59.350
  -153.670    58.609
>
  -153.414    59.355
  -153.670    58.609
>
  -153.414    59.355
  -153.670    58.609
>
  -153.421    59.362
  -153.670    58.609
>
  -153.357    59.370
  -153.670    58.609
>
  -153.357    59.370
  -153.670    58.609
>
  -155.111    58.308
  -153.670    58.609
>
  -155.111    58.308
  -153.670    58.609
>
  -155.282    58.270
  -153.670    58.609
>
  -155.282    58.270
  -153.670    58.609
>
  -152.583    57.783
  -151.874    58.176
>
  -152.583    57.783
  -151.874    58.176
>
  -152.583    57.783
  -151.874    58.176
>
  -152.583    57.783
  -151.874    58.176
>
  -154.182    56.560
  -154.045    56.385
>
  -154.182    56.560
  -154.045    56.385
>
  -153.288    57.222
  -154.045    56.385
>
  -153.288    57.222
  -154.045    56.385
>
  -154.182    56.560
  -153.244    56.105
>
  -154.182    56.560
  -153.244    56.105
>
  -152.583    57.783
  -152.934    58.201
>
  -152.583    57.783
  -152.934    58.201
>
  -153.695    58.799
  -152.934    58.201
>
  -154.546    58.494
  -152.934    58.201
>
  -153.288    57.222
  -152.934    58.201
>
  -153.288    57.222
  -152.934    58.201
>
  -152.583    57.783
  -151.539    58.251
>
  -152.583    57.783
  -151.539    58.251
>
  -154.703    58.498
  -154.956    58.346
>
  -154.703    58.498
  -154.956    58.346
>
  -155.111    58.308
  -154.956    58.346
>
  -154.546    58.494
  -154.956    58.346
>
  -155.006    58.649
  -154.956    58.346
>
  -155.006    58.649
  -154.956    58.346
>
  -155.494    58.199
  -154.956    58.346
>
  -155.301    58.053
  -154.956    58.346
>
  -155.741    58.440
  -154.956    58.346
>
  -155.573    58.054
  -154.956    58.346
>
  -156.324    57.764
  -154.956    58.346
>
  -156.267    57.689
  -154.956    58.346
>
  -156.267    57.689
  -154.956    58.346
>
  -154.347    58.597
  -153.600    58.298
>
  -154.546    58.494
  -153.600    58.298
>
  -154.546    58.494
  -153.600    58.298
>
  -154.799    58.384
  -153.600    58.298
>
  -154.799    58.384
  -153.600    58.298
>
  -152.583    57.783
  -153.600    58.298
>
  -152.583    57.783
  -153.600    58.298
>
  -155.111    58.308
  -153.600    58.298
>
  -155.111    58.308
  -153.600    58.298
>
  -155.006    58.649
  -153.600    58.298
>
  -155.282    58.270
  -153.600    58.298
>
  -155.326    58.211
  -153.600    58.298
>
  -155.326    58.211
  -153.600    58.298
>
  -155.301    58.053
  -153.600    58.298
>
  -155.301    58.053
  -154.816    57.833
>
  -155.573    58.054
  -154.816    57.833
>
  -155.282    58.270
  -154.816    57.833
>
  -155.282    58.270
  -154.816    57.833
>
  -155.494    58.199
  -154.816    57.833
>
  -154.799    58.384
  -154.816    57.833
>
  -154.546    58.494
  -154.816    57.833
>
  -156.267    57.689
  -154.816    57.833
>
  -156.324    57.764
  -154.816    57.833
>
  -155.006    58.649
  -154.816    57.833
>
  -156.607    57.802
  -154.816    57.833
>
  -155.295    58.382
  -155.377    58.548
>
  -155.006    58.649
  -155.377    58.548
>
  -155.282    58.270
  -155.377    58.548
>
  -155.282    58.270
  -155.377    58.548
>
  -155.061    58.297
  -155.377    58.548
>
  -155.061    58.297
  -155.377    58.548
>
  -155.326    58.211
  -155.377    58.548
>
  -155.326    58.211
  -155.377    58.548
>
  -155.494    58.199
  -155.377    58.548
>
  -154.546    58.494
  -155.377    58.548
>
  -155.301    58.053
  -155.377    58.548
>
  -154.347    58.597
  -155.377    58.548
>
  -154.347    58.597
  -155.377    58.548
>
  -156.324    57.764
  -155.377    58.548
>
  -156.267    57.689
  -155.377    58.548
>
  -156.267    57.689
  -155.377    58.548
>
  -156.607    57.802
  -155.377    58.548
>
  -154.347    58.597
  -153.711    58.739
>
  -154.347    58.597
  -153.711    58.739
>
  -154.546    58.494
  -153.711    58.739
>
  -154.799    58.384
  -153.711    58.739
>
  -153.414    59.355
  -153.711    58.739
>
  -153.414    59.355
  -153.711    58.739
>
  -153.443    59.364
  -153.711    58.739
>
  -153.421    59.362
  -153.711    58.739
>
  -153.471    59.370
  -153.711    58.739
>
  -155.006    58.649
  -153.711    58.739
>
  -153.357    59.370
  -153.711    58.739
>
  -153.357    59.370
  -153.711    58.739
>
  -155.061    58.297
  -153.711    58.739
>
  -155.061    58.297
  -153.711    58.739
>
  -155.295    58.382
  -153.711    58.739
>
  -155.295    58.382
  -153.711    58.739
>
  -153.230    59.653
  -153.711    58.739
>
  -154.347    58.597
  -154.154    58.493
>
  -154.347    58.597
  -154.154    58.493
>
  -154.546    58.494
  -154.154    58.493
>
  -154.799    58.384
  -154.154    58.493
>
  -155.061    58.297
  -154.154    58.493
>
  -155.061    58.297
  -154.154    58.493
>
  -154.969    58.131
  -154.154    58.493
>
  -155.161    58.134
  -154.154    58.493
>
  -155.282    58.270
  -154.154    58.493
>
  -155.282    58.270
  -154.154    58.493
>
  -155.301    58.053
  -154.154    58.493
>
  -155.494    58.199
  -154.154    58.493
>
  -155.741    58.440
  -154.154    58.493
>
  -155.741    58.440
  -154.154    58.493
>
  -155.573    58.054
  -154.154    58.493
>
  -153.414    59.355
  -154.154    58.493
>
  -153.414    59.355
  -154.154    58.493
>
  -153.421    59.362
  -154.154    58.493
>
  -153.378    59.370
  -154.154    58.493
>
  -153.435    59.382
  -154.154    58.493
>
  -153.357    59.370
  -154.154    58.493
>
  -153.357    59.370
  -154.154    58.493
>
  -153.288    57.222
  -154.453    57.205
>
  -153.288    57.222
  -154.453    57.205
>
  -154.182    56.560
  -154.453    57.205
>
  -154.182    56.560
  -154.453    57.205
>
  -154.182    56.560
  -153.386    56.726
>
  -154.182    56.560
  -153.386    56.726
>
  -153.288    57.222
  -153.386    56.726
>
  -153.288    57.222
  -153.386    56.726
>
  -155.006    58.649
  -155.173    58.647
>
  -155.006    58.649
  -155.173    58.647
>
  -155.295    58.382
  -155.173    58.647
>
  -154.799    58.384
  -155.173    58.647
>
  -154.546    58.494
  -155.173    58.647
>
  -155.202    58.275
  -155.173    58.647
>
  -154.347    58.597
  -155.173    58.647
>
  -154.347    58.597
  -155.173    58.647
>
  -155.494    58.199
  -155.173    58.647
>
  -155.494    58.199
  -155.173    58.647
>
  -155.301    58.053
  -155.173    58.647
>
  -155.573    58.054
  -155.173    58.647
>
  -152.583    57.783
  -152.277    58.055
>
  -152.583    57.783
  -152.277    58.055
>
  -153.288    57.222
  -152.277    58.055
>
  -153.288    57.222
  -152.277    58.055
>
  -153.288    57.222
  -153.068    56.822
>
  -153.288    57.222
  -153.068    56.822
>
  -154.182    56.560
  -153.068    56.822
>
  -154.182    56.560
  -153.068    56.822
>
  -152.583    57.783
  -153.068    56.822
>
  -152.583    57.783
  -153.068    56.822
>
  -154.969    58.131
  -155.006    58.148
>
  -154.969    58.131
  -155.006    58.148
>
  -155.301    58.053
  -155.006    58.148
>
  -155.183    58.243
  -155.006    58.148
>
  -155.061    58.297
  -155.006    58.148
>
  -155.061    58.297
  -155.006    58.148
>
  -155.202    58.275
  -155.006    58.148
>
  -155.111    58.308
  -155.006    58.148
>
  -155.282    58.270
  -155.006    58.148
>
  -155.282    58.270
  -155.006    58.148
>
  -155.494    58.199
  -155.006    58.148
>
  -155.494    58.199
  -155.006    58.148
>
  -155.573    58.054
  -155.006    58.148
>
  -155.295    58.382
  -155.006    58.148
>
  -155.295    58.382
  -155.006    58.148
>
  -154.546    58.494
  -155.006    58.148
>
  -154.546    58.494
  -155.006    58.148
>
  -155.741    58.440
  -155.006    58.148
>
  -155.006    58.649
  -155.006    58.148
>
  -155.006    58.649
  -155.006    58.148
>
  -154.347    58.597
  -155.006    58.148
>
  -154.347    58.597
  -155.006    58.148
>
  -156.267    57.689
  -155.006    58.148
>
  -156.267    57.689
  -155.006    58.148
>
  -156.607    57.802
  -155.006    58.148
>
  -154.347    58.597
  -154.125    58.666
>
  -154.347    58.597
  -154.125    58.666
>
  -155.006    58.649
  -154.125    58.666
>
  -155.006    58.649
  -154.125    58.666
>
  -155.061    58.297
  -154.125    58.666
>
  -155.061    58.297
  -154.125    58.666
>
  -155.111    58.308
  -154.125    58.666
>
  -155.111    58.308
  -154.125    58.666
>
  -155.282    58.270
  -154.125    58.666
>
  -155.282    58.270
  -154.125    58.666
>
  -153.445    59.363
  -154.125    58.666
>
  -153.445    59.363
  -154.125    58.666
>
  -153.443    59.364
  -154.125    58.666
>
  -153.421    59.362
  -154.125    58.666
>
  -155.301    58.053
  -154.125    58.666
>
  -155.494    58.199
  -154.125    58.666
>
  -153.435    59.382
  -154.125    58.666
>
  -153.357    59.370
  -154.125    58.666
>
  -153.357    59.370
  -154.125    58.666
>
  -155.573    58.054
  -154.125    58.666
>
  -156.267    57.689
  -155.216    57.051
>
  -156.324    57.764
  -155.216    57.051
>
  -152.583    57.783
  -151.821    58.103
>
  -152.583    57.783
  -151.821    58.103
>
  -155.295    58.382
  -155.282    58.568
>
  -155.006    58.649
  -155.282    58.568
>
  -155.111    58.308
  -155.282    58.568
>
  -155.282    58.270
  -155.282    58.568
>
  -155.282    58.270
  -155.282    58.568
>
  -154.546    58.494
  -155.282    58.568
>
  -154.969    58.131
  -155.282    58.568
>
  -154.969    58.131
  -155.282    58.568
>
  -156.324    57.764
  -155.282    58.568
>
  -154.182    56.560
  -154.830    56.591
>
  -154.182    56.560
  -154.830    56.591
>
  -155.620    55.822
  -154.830    56.591
>
  -155.620    55.822
  -154.830    56.591
>
  -152.583    57.783
  -153.286    58.070
>
  -152.583    57.783
  -153.286    58.070
>
  -152.583    57.783
  -153.286    58.070
>
  -153.288    57.222
  -153.286    58.070
>
  -153.288    57.222
  -153.286    58.070
>
  -155.111    58.308
  -153.286    58.070
>
  -153.288    57.222
  -154.042    57.716
>
  -153.288    57.222
  -154.042    57.716
>
  -154.969    58.131
  -154.042    57.716
>
  -155.301    58.053
  -154.042    57.716
>
  -152.583    57.783
  -154.042    57.716
>
  -152.583    57.783
  -154.042    57.716
>
  -152.583    57.783
  -154.042    57.716
>
  -155.183    58.243
  -154.042    57.716
>
  -155.111    58.308
  -154.042    57.716
>
  -155.111    58.308
  -154.042    57.716
>
  -155.326    58.211
  -154.042    57.716
>
  -155.326    58.211
  -154.042    57.716
>
  -155.573    58.054
  -154.042    57.716
>
  -152.583    57.783
  -153.697    58.018
>
  -152.583    57.783
  -153.697    58.018
>
  -154.546    58.494
  -153.697    58.018
>
  -154.969    58.131
  -153.697    58.018
>
  -154.969    58.131
  -153.697    58.018
>
  -153.288    57.222
  -153.697    58.018
>
  -155.111    58.308
  -153.697    58.018
>
  -155.111    58.308
  -153.697    58.018
>
  -155.183    58.243
  -153.697    58.018
>
  -155.202    58.275
  -153.697    58.018
>
  -155.301    58.053
  -153.697    58.018
>
  -155.006    58.649
  -153.697    58.018
>
  -155.006    58.649
  -153.697    58.018
>
  -155.573    58.054
  -153.697    58.018
>
  -155.573    58.054
  -153.697    58.018
>
  -154.969    58.131
  -154.691    58.162
>
  -154.546    58.494
  -154.691    58.162
>
  -154.546    58.494
  -154.691    58.162
>
  -155.202    58.275
  -154.691    58.162
>
  -154.703    58.498
  -154.691    58.162
>
  -155.301    58.053
  -154.691    58.162
>
  -155.295    58.382
  -154.691    58.162
>
  -155.006    58.649
  -154.691    58.162
>
  -155.006    58.649
  -154.691    58.162
>
  -155.573    58.054
  -154.691    58.162
>
  -156.324    57.764
  -154.691    58.162
>
  -156.267    57.689
  -154.691    58.162
>
  -156.267    57.689
  -154.691    58.162
>
  -152.583    57.783
  -152.078    58.011
>
  -152.583    57.783
  -152.078    58.011
>
  -155.301    58.053
  -154.997    57.548
>
  -154.969    58.131
  -154.997    57.548
>
  -154.969    58.131
  -154.997    57.548
>
  -155.573    58.054
  -154.997    57.548
>
  -155.183    58.243
  -154.997    57.548
>
  -155.183    58.243
  -154.997    57.548
>
  -156.267    57.689
  -154.997    57.548
>
  -156.267    57.689
  -154.997    57.548
>
  -155.202    58.275
  -154.997    57.548
>
  -156.324    57.764
  -154.997    57.548
>
  -155.295    58.382
  -154.997    57.548
>
  -156.607    57.802
  -154.997    57.548
>
  -153.288    57.222
  -154.997    57.548
>
  -153.288    57.222
  -154.997    57.548
>
  -153.288    57.222
  -154.997    57.548
>
  -154.703    58.498
  -154.997    57.548
>
  -154.703    58.498
  -154.997    57.548
>
  -155.741    58.440
  -154.997    57.548
>
  -154.546    58.494
  -154.143    58.446
>
  -154.546    58.494
  -154.143    58.446
>
  -154.703    58.498
  -154.143    58.446
>
  -155.006    58.649
  -154.143    58.446
>
  -155.006    58.649
  -154.143    58.446
>
  -154.969    58.131
  -154.143    58.446
>
  -155.202    58.275
  -154.143    58.446
>
  -155.295    58.382
  -154.143    58.446
>
  -155.295    58.382
  -154.143    58.446
>
  -155.301    58.053
  -154.143    58.446
>
  -155.494    58.199
  -154.143    58.446
>
  -155.573    58.054
  -154.143    58.446
>
  -155.741    58.440
  -154.143    58.446
>
  -153.443    59.364
  -154.143    58.446
>
  -154.546    58.494
  -154.145    58.454
>
  -154.703    58.498
  -154.145    58.454
>
  -154.969    58.131
  -154.145    58.454
>
  -154.969    58.131
  -154.145    58.454
>
  -155.006    58.649
  -154.145    58.454
>
  -155.202    58.275
  -154.145    58.454
>
  -155.295    58.382
  -154.145    58.454
>
  -155.295    58.382
  -154.145    58.454
>
  -155.301    58.053
  -154.145    58.454
>
  -155.301    58.053
  -154.145    58.454
>
  -155.741    58.440
  -154.145    58.454
>
  -155.741    58.440
  -154.145    58.454
>
  -153.471    59.370
  -154.145    58.454
>
  -153.421    59.362
  -154.145    58.454
>
  -154.182    56.560
  -155.212    57.022
>
  -154.182    56.560
  -155.212    57.022
>
  -156.358    57.632
  -155.212    57.022
>
  -156.267    57.689
  -155.212    57.022
>
  -156.267    57.689
  -155.212    57.022
>
  -156.324    57.764
  -155.212    57.022
>
  -154.969    58.131
  -154.128    57.718
>
  -154.799    58.384
  -154.128    57.718
>
  -155.301    58.053
  -154.128    57.718
>
  -155.183    58.243
  -154.128    57.718
>
  -155.202    58.275
  -154.128    57.718
>
  -153.288    57.222
  -154.128    57.718
>
  -153.288    57.222
  -154.128    57.718
>
  -153.288    57.222
  -154.128    57.718
>
  -155.282    58.270
  -154.128    57.718
>
  -155.573    58.054
  -154.128    57.718
>
  -155.494    58.199
  -154.128    57.718
>
  -152.583    57.783
  -154.128    57.718
>
  -152.583    57.783
  -154.128    57.718
>
  -152.583    57.783
  -154.128    57.718
>
  -152.583    57.783
  -154.128    57.718
>
  -155.295    58.382
  -154.128    57.718
>
  -153.288    57.222
  -154.089    57.528
>
  -153.288    57.222
  -154.089    57.528
>
  -153.288    57.222
  -154.089    57.528
>
  -154.969    58.131
  -154.089    57.528
>
  -155.301    58.053
  -154.089    57.528
>
  -155.183    58.243
  -154.089    57.528
>
  -155.573    58.054
  -154.089    57.528
>
  -154.799    58.384
  -154.089    57.528
>
  -152.583    57.783
  -154.089    57.528
>
  -152.583    57.783
  -154.089    57.528
>
  -152.583    57.783
  -154.089    57.528
>
  -154.969    58.131
  -154.120    57.933
>
  -154.969    58.131
  -154.120    57.933
>
  -154.799    58.384
  -154.120    57.933
>
  -155.301    58.053
  -154.120    57.933
>
  -155.301    58.053
  -154.120    57.933
>
  -155.183    58.243
  -154.120    57.933
>
  -154.347    58.597
  -154.120    57.933
>
  -154.347    58.597
  -154.120    57.933
>
  -155.326    58.211
  -154.120    57.933
>
  -155.326    58.211
  -154.120    57.933
>
  -155.282    58.270
  -154.120    57.933
>
  -155.295    58.382
  -154.120    57.933
>
  -155.494    58.199
  -154.120    57.933
>
  -155.573    58.054
  -154.120    57.933
>
  -153.288    57.222
  -154.120    57.933
>
  -153.288    57.222
  -154.120    57.933
>
  -152.583    57.783
  -154.120    57.933
>
  -152.583    57.783
  -154.120    57.933
>
  -153.288    57.222
  -154.017    56.632
>
  -153.288    57.222
  -154.017    56.632
>
  -154.347    58.597
  -153.548    58.467
>
  -154.347    58.597
  -153.548    58.467
>
  -154.546    58.494
  -153.548    58.467
>
  -154.799    58.384
  -153.548    58.467
>
  -152.583    57.783
  -153.548    58.467
>
  -152.583    57.783
  -153.548    58.467
>
  -154.969    58.131
  -153.548    58.467
>
  -154.969    58.131
  -153.548    58.467
>
  -155.006    58.649
  -153.548    58.467
>
  -155.183    58.243
  -153.548    58.467
>
  -155.161    58.134
  -153.548    58.467
>
  -155.295    58.382
  -153.548    58.467
>
  -155.282    58.270
  -153.548    58.467
>
  -153.414    59.355
  -153.548    58.467
>
  -153.431    59.360
  -153.548    58.467
>
  -153.445    59.363
  -153.548    58.467
>
  -153.471    59.370
  -153.548    58.467
>
  -153.357    59.370
  -153.548    58.467
>
  -153.357    59.370
  -153.548    58.467
>
  -153.435    59.382
  -153.548    58.467
>
  -154.969    58.131
  -154.916    58.020
>
  -155.301    58.053
  -154.916    58.020
>
  -155.183    58.243
  -154.916    58.020
>
  -155.202    58.275
  -154.916    58.020
>
  -155.573    58.054
  -154.916    58.020
>
  -155.573    58.054
  -154.916    58.020
>
  -155.282    58.270
  -154.916    58.020
>
  -155.282    58.270
  -154.916    58.020
>
  -155.494    58.199
  -154.916    58.020
>
  -154.799    58.384
  -154.916    58.020
>
  -155.295    58.382
  -154.916    58.020
>
  -155.295    58.382
  -154.916    58.020
>
  -155.741    58.440
  -154.916    58.020
>
  -155.741    58.440
  -154.916    58.020
>
  -154.347    58.597
  -154.916    58.020
>
  -156.267    57.689
  -154.916    58.020
>
  -156.267    57.689
  -154.916    58.020
>
  -156.607    57.802
  -154.916    58.020
>
  -153.288    57.222
  -152.494    57.285
>
  -153.288    57.222
  -152.494    57.285
>
  -152.583    57.783
  -152.494    57.285
>
  -152.583    57.783
  -152.494    57.285
>
  -152.583    57.783
  -153.611    57.929
>
  -152.583    57.783
  -153.611    57.929
>
  -152.583    57.783
  -153.611    57.929
>
  -152.583    57.783
  -153.611    57.929
>
  -152.583    57.783
  -153.611    57.929
>
  -153.288    57.222
  -153.611    57.929
>
  -153.288    57.222
  -153.611    57.929
>
  -153.288    57.222
  -153.611    57.929
>
  -154.969    58.131
  -153.611    57.929
>
  -154.969    58.131
  -153.611    57.929
>
  -154.347    58.597
  -153.611    57.929
>
  -154.347    58.597
  -153.611    57.929
>
  -154.799    58.384
  -153.611    57.929
>
  -154.799    58.384
  -153.611    57.929
>
  -155.161    58.134
  -153.611    57.929
>
  -155.061    58.297
  -153.611    57.929
>
  -155.061    58.297
  -153.611    57.929
>
  -155.111    58.308
  -153.611    57.929
>
  -155.111    58.308
  -153.611    57.929
>
  -155.183    58.243
  -153.611    57.929
>
  -155.301    58.053
  -153.611    57.929
>
  -155.282    58.270
  -153.611    57.929
>
  -155.282    58.270
  -153.611    57.929
>
  -155.326    58.211
  -153.611    57.929
>
  -152.583    57.783
  -151.604    58.103
>
  -152.583    57.783
  -151.604    58.103
>
  -152.583    57.783
  -153.440    57.847
>
  -152.583    57.783
  -153.440    57.847
>
  -153.288    57.222
  -153.440    57.847
>
  -153.288    57.222
  -153.440    57.847
>
  -154.969    58.131
  -153.440    57.847
>
  -154.347    58.597
  -153.440    57.847
>
  -154.347    58.597
  -153.440    57.847
>
  -155.061    58.297
  -153.440    57.847
>
  -155.061    58.297
  -153.440    57.847
>
  -153.288    57.222
  -154.027    57.640
>
  -153.288    57.222
  -154.027    57.640
>
  -153.288    57.222
  -154.027    57.640
>
  -152.583    57.783
  -154.027    57.640
>
  -152.583    57.783
  -154.027    57.640
>
  -152.583    57.783
  -154.027    57.640
>
  -152.583    57.783
  -154.027    57.640
>
  -155.061    58.297
  -154.027    57.640
>
  -155.061    58.297
  -154.027    57.640
>
  -155.282    58.270
  -154.027    57.640
>
  -155.282    58.270
  -154.027    57.640
>
  -154.969    58.131
  -154.359    57.672
>
  -155.161    58.134
  -154.359    57.672
>
  -155.161    58.134
  -154.359    57.672
>
  -153.288    57.222
  -154.359    57.672
>
  -153.288    57.222
  -154.359    57.672
>
  -155.061    58.297
  -154.359    57.672
>
  -155.061    58.297
  -154.359    57.672
>
  -155.326    58.211
  -154.359    57.672
>
  -155.326    58.211
  -154.359    57.672
>
  -155.202    58.275
  -154.359    57.672
>
  -155.111    58.308
  -154.359    57.672
>
  -155.111    58.308
  -154.359    57.672
>
  -155.282    58.270
  -154.359    57.672
>
  -154.347    58.597
  -154.359    57.672
>
  -152.583    57.783
  -154.359    57.672
>
  -152.583    57.783
  -154.359    57.672
>
  -152.583    57.783
  -152.075    58.093
>
  -152.583    57.783
  -152.075    58.093
>
  -152.583    57.783
  -152.075    58.093
>
  -152.583    57.783
  -152.075    58.093
>
  -152.583    57.783
  -152.075    58.093
>
  -155.282    58.270
  -154.112    58.055
>
  -153.288    57.222
  -154.112    58.055
>
  -153.288    57.222
  -154.112    58.055
>
  -153.645    58.929
  -154.112    58.055
>
  -153.645    58.929
  -154.112    58.055
>
  -156.267    57.689
  -155.503    58.148
>
  -156.878    57.998
  -155.503    58.148
>
  -156.819    57.700
  -155.503    58.148
>
  -154.182    56.560
  -154.381    56.816
>
  -154.182    56.560
  -154.381    56.816
>
  -153.645    58.929
  -154.083    58.573
>
  -153.645    58.929
  -154.083    58.573
>
  -155.111    58.308
  -154.083    58.573
>
  -155.282    58.270
  -154.083    58.573
>
  -155.282    58.270
  -154.083    58.573
>
  -153.414    59.355
  -154.083    58.573
>
  -153.414    59.355
  -154.083    58.573
>
  -153.471    59.370
  -154.083    58.573
>
  -153.435    59.382
  -154.083    58.573
>
  -153.357    59.370
  -154.083    58.573
>
  -152.583    57.783
  -152.510    58.358
>
  -152.583    57.783
  -152.510    58.358
>
  -152.583    57.783
  -152.510    58.358
>
  -153.645    58.929
  -152.510    58.358
>
  -153.645    58.929
  -152.510    58.358
>
  -152.583    57.783
  -151.456    58.251
>
  -152.583    57.783
  -151.456    58.251
>
  -153.288    57.222
  -153.219    56.772
>
  -153.288    57.222
  -153.219    56.772
>
  -155.741    58.440
  -155.304    58.583
>
  -155.282    58.270
  -155.304    58.583
>
  -155.282    58.270
  -155.304    58.583
>
  -155.494    58.199
  -155.304    58.583
>
  -155.494    58.199
  -155.304    58.583
>
  -155.301    58.053
  -155.304    58.583
>
  -155.573    58.054
  -155.304    58.583
>
  -155.229    59.392
  -155.304    58.583
>
  -155.229    59.392
  -155.304    58.583
>
  -153.645    58.929
  -155.304    58.583
>
  -153.645    58.929
  -155.304    58.583
>
  -153.645    58.929
  -155.304    58.583
>
  -153.645    58.929
  -155.304    58.583
>
  -154.182    56.560
  -155.465    56.598
>
  -154.182    56.560
  -155.465    56.598
>
  -154.182    56.560
  -155.465    56.598
>
  -154.182    56.560
  -155.465    56.598
>
  -155.620    55.822
  -155.465    56.598
>
  -155.620    55.822
  -155.465    56.598
>
  -155.620    55.822
  -155.465    56.598
>
  -155.183    58.243
  -154.642    58.143
>
  -155.301    58.053
  -154.642    58.143
>
  -155.326    58.211
  -154.642    58.143
>
  -155.494    58.199
  -154.642    58.143
>
  -155.494    58.199
  -154.642    58.143
>
  -155.573    58.054
  -154.642    58.143
>
  -155.741    58.440
  -154.642    58.143
>
  -156.324    57.764
  -154.642    58.143
>
  -156.267    57.689
  -154.642    58.143
>
  -156.267    57.689
  -154.642    58.143
>
  -152.583    57.783
  -151.710    58.144
>
  -152.583    57.783
  -151.710    58.144
>
  -155.301    58.053
  -154.501    57.628
>
  -155.573    58.054
  -154.501    57.628
>
  -155.326    58.211
  -154.501    57.628
>
  -155.326    58.211
  -154.501    57.628
>
  -155.111    58.308
  -154.501    57.628
>
  -153.288    57.222
  -154.501    57.628
>
  -155.494    58.199
  -154.501    57.628
>
  -152.583    57.783
  -152.949    58.477
>
  -153.645    58.929
  -152.949    58.477
>
  -153.645    58.929
  -152.949    58.477
>
  -153.414    59.355
  -152.949    58.477
>
  -153.357    59.370
  -152.949    58.477
>
  -153.378    59.370
  -152.949    58.477
>
  -153.435    59.382
  -152.949    58.477
>
  -153.435    59.382
  -152.949    58.477
>
  -153.645    58.929
  -152.459    58.909
>
  -153.645    58.929
  -152.459    58.909
>
  -153.645    58.929
  -152.459    58.909
>
  -153.357    59.370
  -152.459    58.909
>
  -153.357    59.370
  -152.459    58.909
>
  -153.378    59.370
  -152.459    58.909
>
  -153.443    59.364
  -152.459    58.909
>
  -153.435    59.382
  -152.459    58.909
>
  -153.435    59.382
  -152.459    58.909
>
  -151.643    59.658
  -152.459    58.909
>
  -151.643    59.658
  -152.459    58.909
>
  -151.643    59.658
  -152.459    58.909
>
  -153.232    59.652
  -152.459    58.909
>
  -153.232    59.652
  -152.459    58.909
>
  -153.232    59.652
  -152.459    58.909
>
  -153.232    59.652
  -152.459    58.909
>
  -153.230    59.653
  -152.459    58.909
>
  -151.236    59.526
  -152.459    58.909
>
  -151.236    59.526
  -152.459    58.909
>
  -153.645    58.929
  -154.123    58.532
>
  -153.645    58.929
  -154.123    58.532
>
  -155.111    58.308
  -154.123    58.532
>
  -155.111    58.308
  -154.123    58.532
>
  -155.301    58.053
  -154.123    58.532
>
  -155.494    58.199
  -154.123    58.532
>
  -155.741    58.440
  -154.123    58.532
>
  -155.573    58.054
  -154.123    58.532
>
  -153.414    59.355
  -154.123    58.532
>
  -153.443    59.364
  -154.123    58.532
>
  -153.435    59.382
  -154.123    58.532
>
  -153.378    59.370
  -154.123    58.532
>
  -153.357    59.370
  -154.123    58.532
>
  -153.357    59.370
  -154.123    58.532
>
  -152.583    57.783
  -152.968    57.721
>
  -152.583    57.783
  -152.968    57.721
>
  -153.288    57.222
  -152.968    57.721
>
  -153.288    57.222
  -152.968    57.721
>
  -152.394    58.610
  -153.034    58.298
>
  -152.394    58.610
  -153.034    58.298
>
  -152.391    58.610
  -153.034    58.298
>
  -152.391    58.610
  -153.034    58.298
>
  -152.583    57.783
  -153.034    58.298
>
  -152.583    57.783
  -153.034    58.298
>
  -153.645    58.929
  -153.034    58.298
>
  -153.645    58.929
  -153.034    58.298
>
  -153.645    58.929
  -153.034    58.298
>
  -154.347    58.597
  -153.034    58.298
>
  -154.347    58.597
  -153.034    58.298
>
  -152.583    57.783
  -153.593    57.837
>
  -152.583    57.783
  -153.593    57.837
>
  -153.288    57.222
  -153.593    57.837
>
  -153.288    57.222
  -153.593    57.837
>
  -154.546    58.494
  -153.593    57.837
>
  -154.347    58.597
  -153.593    57.837
>
  -154.347    58.597
  -153.593    57.837
>
  -155.111    58.308
  -153.593    57.837
>
  -154.182    56.560
  -155.196    56.609
>
  -154.182    56.560
  -155.196    56.609
>
  -155.620    55.822
  -155.196    56.609
>
  -155.620    55.822
  -155.196    56.609
>
  -154.969    58.131
  -154.828    57.853
>
  -155.573    58.054
  -154.828    57.853
>
  -155.326    58.211
  -154.828    57.853
>
  -155.326    58.211
  -154.828    57.853
>
  -155.111    58.308
  -154.828    57.853
>
  -154.546    58.494
  -154.828    57.853
>
  -155.741    58.440
  -154.828    57.853
>
  -154.347    58.597
  -154.828    57.853
>
  -154.347    58.597
  -154.828    57.853
>
  -155.006    58.649
  -154.828    57.853
>
  -155.009    58.648
  -154.828    57.853
>
  -155.009    58.648
  -154.828    57.853
>
  -156.387    57.640
  -154.828    57.853
>
  -156.387    57.640
  -154.828    57.853
>
  -156.387    57.640
  -154.828    57.853
>
  -156.387    57.640
  -154.828    57.853
>
  -155.183    58.243
  -154.738    58.122
>
  -155.202    58.275
  -154.738    58.122
>
  -155.573    58.054
  -154.738    58.122
>
  -155.741    58.440
  -154.738    58.122
>
  -153.645    58.929
  -154.738    58.122
>
  -153.645    58.929
  -154.738    58.122
>
  -154.969    58.131
  -154.548    57.773
>
  -155.301    58.053
  -154.548    57.773
>
  -155.061    58.297
  -154.548    57.773
>
  -155.326    58.211
  -154.548    57.773
>
  -155.326    58.211
  -154.548    57.773
>
  -155.202    58.275
  -154.548    57.773
>
  -155.111    58.308
  -154.548    57.773
>
  -154.799    58.384
  -154.548    57.773
>
  -154.546    58.494
  -154.548    57.773
>
  -154.347    58.597
  -154.548    57.773
>
  -153.288    57.222
  -154.548    57.773
>
  -153.288    57.222
  -154.548    57.773
>
  -155.741    58.440
  -154.548    57.773
>
  -155.006    58.649
  -154.548    57.773
>
  -156.387    57.640
  -154.548    57.773
>
  -156.387    57.640
  -154.548    57.773
>
  -152.391    58.610
  -151.415    58.324
>
  -152.391    58.610
  -151.415    58.324
>
  -152.583    57.783
  -151.415    58.324
>
  -152.583    57.783
  -151.415    58.324
>
  -154.546    58.494
  -153.935    58.014
>
  -154.347    58.597
  -153.935    58.014
>
  -154.347    58.597
  -153.935    58.014
>
  -155.111    58.308
  -153.935    58.014
>
  -152.583    57.783
  -153.935    58.014
>
  -152.583    57.783
  -153.935    58.014
>
  -152.583    57.783
  -153.935    58.014
>
  -155.006    58.649
  -153.935    58.014
>
  -153.288    57.222
  -153.935    58.014
>
  -153.288    57.222
  -153.935    58.014
>
  -153.645    58.929
  -153.935    58.014
>
  -154.182    56.560
  -153.207    56.404
>
  -154.182    56.560
  -153.207    56.404
>
  -154.182    56.560
  -153.207    56.404
>
  -154.182    56.560
  -153.207    56.404
>
  -153.288    57.222
  -153.207    56.404
>
  -153.288    57.222
  -153.207    56.404
>
  -154.182    56.560
  -153.229    56.404
>
  -154.182    56.560
  -153.229    56.404
>
  -154.182    56.560
  -153.229    56.404
>
  -154.182    56.560
  -153.229    56.404
>
  -153.288    57.222
  -153.229    56.404
>
  -153.288    57.222
  -153.229    56.404
>
  -154.969    58.131
  -154.603    58.127
>
  -154.969    58.131
  -154.603    58.127
>
  -155.061    58.297
  -154.603    58.127
>
  -155.061    58.297
  -154.603    58.127
>
  -154.799    58.384
  -154.603    58.127
>
  -155.111    58.308
  -154.603    58.127
>
  -155.202    58.275
  -154.603    58.127
>
  -154.546    58.494
  -154.603    58.127
>
  -154.703    58.498
  -154.603    58.127
>
  -155.295    58.382
  -154.603    58.127
>
  -155.494    58.199
  -154.603    58.127
>
  -155.494    58.199
  -154.603    58.127
>
  -154.347    58.597
  -154.603    58.127
>
  -154.347    58.597
  -154.603    58.127
>
  -155.006    58.649
  -154.603    58.127
>
  -155.006    58.649
  -154.603    58.127
>
  -155.741    58.440
  -154.603    58.127
>
  -155.884    58.265
  -154.603    58.127
>
  -155.884    58.265
  -154.603    58.127
>
  -155.887    58.264
  -154.603    58.127
>
  -155.887    58.264
  -154.603    58.127
>
  -156.267    57.689
  -154.603    58.127
>
  -153.645    58.929
  -154.603    58.127
>
  -153.645    58.929
  -154.603    58.127
>
  -153.645    58.929
  -154.603    58.127
>
  -153.645    58.929
  -154.603    58.127
>
  -154.182    56.560
  -155.220    56.755
>
  -154.182    56.560
  -155.220    56.755
>
  -154.182    56.560
  -155.220    56.755
>
  -154.182    56.560
  -155.220    56.755
>
  -155.620    55.822
  -155.220    56.755
>
  -155.620    55.822
  -155.220    56.755
>
  -155.620    55.822
  -155.220    56.755
>
  -154.969    58.131
  -154.628    58.134
>
  -154.969    58.131
  -154.628    58.134
>
  -155.494    58.199
  -154.628    58.134
>
  -155.494    58.199
  -154.628    58.134
>
  -154.347    58.597
  -154.628    58.134
>
  -154.347    58.597
  -154.628    58.134
>
  -155.006    58.649
  -154.628    58.134
>
  -155.006    58.649
  -154.628    58.134
>
  -155.884    58.265
  -154.628    58.134
>
  -155.884    58.265
  -154.628    58.134
>
  -153.645    58.929
  -154.628    58.134
>
  -152.583    57.783
  -153.769    58.196
>
  -152.583    57.783
  -153.769    58.196
>
  -152.583    57.783
  -153.769    58.196
>
  -153.645    58.929
  -153.769    58.196
>
  -153.645    58.929
  -153.769    58.196
>
  -153.645    58.929
  -153.769    58.196
>
  -155.006    58.649
  -153.769    58.196
>
  -153.645    58.929
  -153.645    58.694
>
  -153.645    58.929
  -153.645    58.694
>
  -153.645    58.929
  -153.645    58.694
>
  -152.394    58.610
  -153.645    58.694
>
  -152.394    58.610
  -153.645    58.694
>
  -155.006    58.649
  -153.645    58.694
>
  -155.009    58.648
  -153.645    58.694
>
  -155.009    58.648
  -153.645    58.694
>
  -153.230    59.653
  -153.645    58.694
>
  -153.232    59.652
  -153.645    58.694
>
  -153.232    59.652
  -153.645    58.694
>
  -153.232    59.652
  -153.645    58.694
>
  -153.288    57.222
  -154.203    57.229
>
  -153.288    57.222
  -154.203    57.229
>
  -153.288    57.222
  -154.203    57.229
>
  -154.182    56.560
  -154.203    57.229
>
  -154.182    56.560
  -154.203    57.229
>
  -152.583    57.783
  -152.619    58.273
>
  -152.583    57.783
  -152.619    58.273
>
  -155.006    58.649
  -154.953    58.693
>
  -155.006    58.649
  -154.953    58.693
>
  -154.347    58.597
  -154.953    58.693
>
  -155.295    58.382
  -154.953    58.693
>
  -155.061    58.297
  -154.953    58.693
>
  -155.061    58.297
  -154.953    58.693
>
  -155.741    58.440
  -154.953    58.693
>
  -155.494    58.199
  -154.953    58.693
>
  -155.494    58.199
  -154.953    58.693
>
  -155.884    58.265
  -154.953    58.693
>
  -155.884    58.265
  -154.953    58.693
>
  -155.229    59.392
  -154.953    58.693
>
  -155.229    59.392
  -154.953    58.693
>
  -156.656    58.677
  -154.953    58.693
>
  -156.656    58.677
  -154.953    58.693
>
  -153.288    57.222
  -152.254    56.805
>
  -153.288    57.222
  -152.254    56.805
>
  -152.583    57.783
  -152.254    56.805
>
  -152.583    57.783
  -152.254    56.805
>
  -152.583    57.783
  -152.254    56.805
>
  -152.583    57.783
  -152.254    56.805
>
  -154.182    56.560
  -154.271    56.218
>
  -154.182    56.560
  -154.271    56.218
>
  -154.182    56.560
  -154.271    56.218
>
  -155.620    55.822
  -154.271    56.218
>
  -155.620    55.822
  -154.271    56.218
>
  -155.620    55.822
  -154.271    56.218
>
  -152.583    57.783
  -151.907    58.235
>
  -152.583    57.783
  -151.907    58.235
>
  -152.583    57.783
  -151.907    58.235
>
  -155.006    58.649
  -154.556    58.133
>
  -153.645    58.929
  -154.556    58.133
>
  -153.645    58.929
  -154.556    58.133
>
  -153.645    58.929
  -154.556    58.133
>
  -153.288    57.222
  -152.337    57.266
>
  -153.288    57.222
  -152.337    57.266
>
  -152.583    57.783
  -152.337    57.266
>
  -152.583    57.783
  -152.337    57.266
>
  -152.583    57.783
  -152.337    57.266
>
  -152.583    57.783
  -152.337    57.266
>
  -153.288    57.222
  -154.105    57.103
>
  -153.288    57.222
  -154.105    57.103
>
  -153.288    57.222
  -154.020    57.384
>
  -153.288    57.222
  -154.020    57.384
>
  -153.288    57.222
  -154.020    57.384
>
  -153.288    57.222
  -154.020    57.384
>
  -152.583    57.783
  -154.020    57.384
>
  -152.583    57.783
  -154.020    57.384
>
  -152.583    57.783
  -154.020    57.384
>
  -152.583    57.783
  -154.020    57.384
>
  -152.583    57.783
  -154.020    57.384
>
  -156.387    57.640
  -155.038    57.471
>
  -155.887    58.264
  -155.038    57.471
>
  -153.288    57.222
  -155.038    57.471
>
  -153.288    57.222
  -155.038    57.471
>
  -156.387    57.640
  -155.063    57.542
>
  -153.645    58.929
  -154.770    58.485
>
  -155.229    59.392
  -154.770    58.485
>
  -152.391    58.610
  -152.766    58.375
>
  -152.391    58.610
  -152.766    58.375
>
  -152.583    57.783
  -152.766    58.375
>
  -152.583    57.783
  -152.766    58.375
>
  -153.645    58.929
  -152.766    58.375
>
  -153.645    58.929
  -152.766    58.375
>
  -152.391    58.610
  -151.344    58.388
>
  -152.583    57.783
  -151.344    58.388
>
  -152.583    57.783
  -151.344    58.388
>
  -153.288    57.222
  -152.579    56.908
>
  -153.288    57.222
  -152.579    56.908
>
  -153.288    57.222
  -152.579    56.908
>
  -152.583    57.783
  -152.579    56.908
>
  -152.583    57.783
  -152.579    56.908
>
  -152.583    57.783
  -152.579    56.908
>
  -152.583    57.783
  -152.579    56.908
>
  -152.583    57.783
  -152.579    56.908
>
  -153.288    57.222
  -152.538    56.982
>
  -153.288    57.222
  -152.538    56.982
>
  -152.583    57.783
  -152.538    56.982
>
  -152.583    57.783
  -152.538    56.982
>
  -152.583    57.783
  -152.538    56.982
>
  -153.288    57.222
  -152.580    57.013
>
  -153.288    57.222
  -152.580    57.013
>
  -153.288    57.222
  -152.580    57.013
>
  -153.288    57.222
  -152.580    57.013
>
  -153.288    57.222
  -152.580    57.013
>
  -152.583    57.783
  -152.580    57.013
>
  -152.583    57.783
  -152.580    57.013
>
  -152.583    57.783
  -152.580    57.013
>
  -152.583    57.783
  -152.580    57.013
>
  -152.394    58.610
  -151.394    58.338
>
  -152.394    58.610
  -151.394    58.338
>
  -152.583    57.783
  -151.394    58.338
>
  -152.583    57.783
  -151.394    58.338
>
  -154.452    57.567
  -154.300    57.784
>
  -154.452    57.567
  -154.300    57.784
>
  -154.969    58.131
  -154.300    57.784
>
  -154.799    58.384
  -154.300    57.784
>
  -155.061    58.297
  -154.300    57.784
>
  -155.061    58.297
  -154.300    57.784
>
  -155.183    58.243
  -154.300    57.784
>
  -155.111    58.308
  -154.300    57.784
>
  -154.703    58.498
  -154.300    57.784
>
  -155.494    58.199
  -154.300    57.784
>
  -155.494    58.199
  -154.300    57.784
>
  -154.347    58.597
  -154.300    57.784
>
  -155.295    58.382
  -154.300    57.784
>
  -153.288    57.222
  -154.300    57.784
>
  -155.006    58.649
  -154.300    57.784
>
  -155.006    58.649
  -154.300    57.784
>
  -155.006    58.649
  -154.300    57.784
>
  -155.009    58.648
  -154.300    57.784
>
  -152.583    57.783
  -154.300    57.784
>
  -152.583    57.783
  -154.300    57.784
>
  -152.583    57.783
  -154.300    57.784
>
  -155.884    58.265
  -154.300    57.784
>
  -155.884    58.265
  -154.300    57.784
>
  -155.887    58.264
  -154.300    57.784
>
  -155.183    58.243
  -155.218    58.216
>
  -155.061    58.297
  -155.218    58.216
>
  -154.969    58.131
  -155.218    58.216
>
  -155.494    58.199
  -155.218    58.216
>
  -155.494    58.199
  -155.218    58.216
>
  -155.295    58.382
  -155.218    58.216
>
  -155.295    58.382
  -155.218    58.216
>
  -155.884    58.265
  -155.218    58.216
>
  -155.884    58.265
  -155.218    58.216
>
  -155.006    58.649
  -155.218    58.216
>
  -155.006    58.649
  -155.218    58.216
>
  -154.347    58.597
  -155.218    58.216
>
  -154.347    58.597
  -155.218    58.216
>
  -156.267    57.689
  -155.218    58.216
>
  -156.387    57.640
  -155.218    58.216
>
  -156.656    58.677
  -155.218    58.216
>
  -156.878    57.998
  -155.218    58.216
>
  -156.819    57.700
  -155.218    58.216
>
  -154.182    56.560
  -154.825    56.524
>
  -154.182    56.560
  -154.825    56.524
>
  -154.182    56.560
  -154.825    56.524
>
  -152.394    58.610
  -153.025    58.336
>
  -152.394    58.610
  -153.025    58.336
>
  -152.391    58.610
  -153.025    58.336
>
  -152.391    58.610
  -153.025    58.336
>
  -152.583    57.783
  -153.025    58.336
>
  -152.583    57.783
  -153.025    58.336
>
  -153.645    58.929
  -153.025    58.336
>
  -154.347    58.597
  -153.025    58.336
>
  -154.347    58.597
  -153.025    58.336
>
  -154.182    56.560
  -154.612    56.497
>
  -154.182    56.560
  -154.612    56.497
>
  -155.620    55.822
  -154.612    56.497
>
  -155.620    55.822
  -154.612    56.497
>
  -154.347    58.597
  -153.650    58.473
>
  -153.645    58.929
  -153.650    58.473
>
  -153.645    58.929
  -153.650    58.473
>
  -153.645    58.929
  -153.650    58.473
>
  -154.546    58.494
  -153.650    58.473
>
  -154.546    58.494
  -153.650    58.473
>
  -154.703    58.498
  -153.650    58.473
>
  -154.799    58.384
  -153.650    58.473
>
  -152.394    58.610
  -153.650    58.473
>
  -152.394    58.610
  -153.650    58.473
>
  -152.391    58.610
  -153.650    58.473
>
  -152.391    58.610
  -153.650    58.473
>
  -155.006    58.649
  -153.650    58.473
>
  -155.006    58.649
  -153.650    58.473
>
  -155.009    58.648
  -153.650    58.473
>
  -155.009    58.648
  -153.650    58.473
>
  -155.061    58.297
  -153.650    58.473
>
  -154.969    58.131
  -153.650    58.473
>
  -155.111    58.308
  -153.650    58.473
>
  -155.202    58.275
  -153.650    58.473
>
  -155.183    58.243
  -153.650    58.473
>
  -155.295    58.382
  -153.650    58.473
>
  -153.414    59.355
  -153.650    58.473
>
  -153.445    59.363
  -153.650    58.473
>
  -153.445    59.363
  -153.650    58.473
>
  -155.282    58.270
  -153.650    58.473
>
  -153.357    59.370
  -153.650    58.473
>
  -155.326    58.211
  -153.650    58.473
>
  -152.583    57.783
  -153.650    58.473
>
  -152.583    57.783
  -153.650    58.473
>
  -152.583    57.783
  -153.650    58.473
>
  -152.583    57.783
  -153.650    58.473
>
  -152.583    57.783
  -153.650    58.473
>
  -155.006    58.649
  -155.105    58.648
>
  -155.006    58.649
  -155.105    58.648
>
  -155.295    58.382
  -155.105    58.648
>
  -154.546    58.494
  -155.105    58.648
>
  -154.546    58.494
  -155.105    58.648
>
  -155.061    58.297
  -155.105    58.648
>
  -155.061    58.297
  -155.105    58.648
>
  -155.494    58.199
  -155.105    58.648
>
  -155.494    58.199
  -155.105    58.648
>
  -154.969    58.131
  -155.105    58.648
>
  -155.229    59.392
  -155.105    58.648
>
  -155.229    59.392
  -155.105    58.648
>
  -153.645    58.929
  -155.105    58.648
>
  -156.439    59.195
  -155.105    58.648
>
  -156.439    59.195
  -155.105    58.648
>
  -154.452    57.567
  -154.487    57.731
>
  -154.452    57.567
  -154.487    57.731
>
  -154.969    58.131
  -154.487    57.731
>
  -155.183    58.243
  -154.487    57.731
>
  -155.061    58.297
  -154.487    57.731
>
  -155.061    58.297
  -154.487    57.731
>
  -155.326    58.211
  -154.487    57.731
>
  -155.326    58.211
  -154.487    57.731
>
  -154.799    58.384
  -154.487    57.731
>
  -155.282    58.270
  -154.487    57.731
>
  -155.494    58.199
  -154.487    57.731
>
  -155.494    58.199
  -154.487    57.731
>
  -154.546    58.494
  -154.487    57.731
>
  -154.546    58.494
  -154.487    57.731
>
  -153.288    57.222
  -154.487    57.731
>
  -153.288    57.222
  -154.487    57.731
>
  -155.295    58.382
  -154.487    57.731
>
  -154.347    58.597
  -154.487    57.731
>
  -154.347    58.597
  -154.487    57.731
>
  -155.006    58.649
  -154.487    57.731
>
  -155.006    58.649
  -154.487    57.731
>
  -155.006    58.649
  -154.487    57.731
>
  -155.009    58.648
  -154.487    57.731
>
  -155.009    58.648
  -154.487    57.731
>
  -156.267    57.689
  -154.487    57.731
>
  -154.452    57.567
  -154.679    57.312
>
  -154.452    57.567
  -154.679    57.312
>
  -153.288    57.222
  -154.679    57.312
>
  -153.288    57.222
  -154.679    57.312
>
  -154.182    56.560
  -154.679    57.312
>
  -154.182    56.560
  -154.679    57.312
>
  -154.182    56.560
  -154.679    57.312
>
  -154.969    58.131
  -154.679    57.312
>
  -156.267    57.689
  -154.679    57.312
>
  -156.267    57.689
  -154.679    57.312
>
  -156.387    57.640
  -154.679    57.312
>
  -156.387    57.640
  -154.679    57.312
>
  -155.326    58.211
  -154.679    57.312
>
  -155.183    58.243
  -154.679    57.312
>
  -155.494    58.199
  -154.679    57.312
>
  -155.494    58.199
  -154.679    57.312
>
  -152.391    58.610
  -151.599    58.206
>
  -152.391    58.610
  -151.599    58.206
>
  -152.583    57.783
  -151.599    58.206
>
  -152.583    57.783
  -151.599    58.206
>
  -155.741    58.440
  -155.485    58.569
>
  -155.295    58.382
  -155.485    58.569
>
  -155.009    58.648
  -155.485    58.569
>
  -155.009    58.648
  -155.485    58.569
>
  -155.006    58.649
  -155.485    58.569
>
  -155.006    58.649
  -155.485    58.569
>
  -155.006    58.649
  -155.485    58.569
>
  -155.282    58.270
  -155.485    58.569
>
  -155.282    58.270
  -155.485    58.569
>
  -155.061    58.297
  -155.485    58.569
>
  -155.061    58.297
  -155.485    58.569
>
  -155.183    58.243
  -155.485    58.569
>
  -155.326    58.211
  -155.485    58.569
>
  -155.884    58.265
  -155.485    58.569
>
  -155.884    58.265
  -155.485    58.569
>
  -155.494    58.199
  -155.485    58.569
>
  -155.494    58.199
  -155.485    58.569
>
  -155.887    58.264
  -155.485    58.569
>
  -155.887    58.264
  -155.485    58.569
>
  -154.799    58.384
  -155.485    58.569
>
  -154.703    58.498
  -155.485    58.569
>
  -154.546    58.494
  -155.485    58.569
>
  -154.969    58.131
  -155.485    58.569
>
  -154.347    58.597
  -155.485    58.569
>
  -156.656    58.677
  -155.485    58.569
>
  -156.656    58.677
  -155.485    58.569
>
  -156.439    59.195
  -155.485    58.569
>
  -156.439    59.195
  -155.485    58.569
>
  -156.439    59.195
  -155.485    58.569
>
  -155.229    59.392
  -155.485    58.569
>
  -155.229    59.392
  -155.485    58.569
>
  -156.878    57.998
  -155.485    58.569
>
  -156.607    57.802
  -155.485    58.569
>
  -156.267    57.689
  -155.485    58.569
>
  -152.394    58.610
  -152.878    58.363
>
  -152.391    58.610
  -152.878    58.363
>
  -152.391    58.610
  -152.878    58.363
>
  -152.583    57.783
  -152.878    58.363
>
  -152.583    57.783
  -152.878    58.363
>
  -153.645    58.929
  -152.878    58.363
>
  -153.645    58.929
  -152.878    58.363
>
  -154.347    58.597
  -152.878    58.363
>
  -154.546    58.494
  -152.878    58.363
>
  -154.546    58.494
  -152.878    58.363
>
  -154.703    58.498
  -152.878    58.363
>
  -154.452    57.567
  -155.044    57.732
>
  -154.452    57.567
  -155.044    57.732
>
  -154.969    58.131
  -155.044    57.732
>
  -155.326    58.211
  -155.044    57.732
>
  -155.326    58.211
  -155.044    57.732
>
  -155.183    58.243
  -155.044    57.732
>
  -155.494    58.199
  -155.044    57.732
>
  -155.494    58.199
  -155.044    57.732
>
  -155.282    58.270
  -155.044    57.732
>
  -155.282    58.270
  -155.044    57.732
>
  -155.061    58.297
  -155.044    57.732
>
  -155.061    58.297
  -155.044    57.732
>
  -156.267    57.689
  -155.044    57.732
>
  -154.799    58.384
  -155.044    57.732
>
  -155.295    58.382
  -155.044    57.732
>
  -155.884    58.265
  -155.044    57.732
>
  -155.884    58.265
  -155.044    57.732
>
  -155.887    58.264
  -155.044    57.732
>
  -155.887    58.264
  -155.044    57.732
>
  -156.387    57.640
  -155.044    57.732
>
  -156.387    57.640
  -155.044    57.732
>
  -156.387    57.640
  -155.044    57.732
>
  -154.703    58.498
  -155.044    57.732
>
  -154.546    58.494
  -155.044    57.732
>
  -154.546    58.494
  -155.044    57.732
>
  -156.607    57.802
  -155.044    57.732
>
  -155.006    58.649
  -155.044    57.732
>
  -155.006    58.649
  -155.044    57.732
>
  -155.006    58.649
  -155.044    57.732
>
  -155.009    58.648
  -155.044    57.732
>
  -155.009    58.648
  -155.044    57.732
>
  -154.347    58.597
  -155.044    57.732
>
  -154.347    58.597
  -155.044    57.732
>
  -156.819    57.700
  -155.044    57.732
>
  -154.452    57.567
  -155.039    57.721
>
  -154.452    57.567
  -155.039    57.721
>
  -154.969    58.131
  -155.039    57.721
>
  -155.326    58.211
  -155.039    57.721
>
  -155.326    58.211
  -155.039    57.721
>
  -155.494    58.199
  -155.039    57.721
>
  -155.494    58.199
  -155.039    57.721
>
  -155.061    58.297
  -155.039    57.721
>
  -156.267    57.689
  -155.039    57.721
>
  -156.267    57.689
  -155.039    57.721
>
  -155.295    58.382
  -155.039    57.721
>
  -155.884    58.265
  -155.039    57.721
>
  -155.884    58.265
  -155.039    57.721
>
  -156.387    57.640
  -155.039    57.721
>
  -156.387    57.640
  -155.039    57.721
>
  -156.607    57.802
  -155.039    57.721
>
  -155.006    58.649
  -155.039    57.721
>
  -155.006    58.649
  -155.039    57.721
>
  -154.452    57.567
  -154.491    57.984
>
  -154.452    57.567
  -154.491    57.984
>
  -154.452    57.567
  -154.491    57.984
>
  -154.452    57.567
  -154.491    57.984
>
  -155.061    58.297
  -154.491    57.984
>
  -155.061    58.297
  -154.491    57.984
>
  -155.183    58.243
  -154.491    57.984
>
  -155.111    58.308
  -154.491    57.984
>
  -154.546    58.494
  -154.491    57.984
>
  -154.546    58.494
  -154.491    57.984
>
  -155.326    58.211
  -154.491    57.984
>
  -155.326    58.211
  -154.491    57.984
>
  -155.282    58.270
  -154.491    57.984
>
  -155.494    58.199
  -154.491    57.984
>
  -155.494    58.199
  -154.491    57.984
>
  -154.347    58.597
  -154.491    57.984
>
  -154.347    58.597
  -154.491    57.984
>
  -155.295    58.382
  -154.491    57.984
>
  -155.006    58.649
  -154.491    57.984
>
  -155.009    58.648
  -154.491    57.984
>
  -155.884    58.265
  -154.491    57.984
>
  -155.887    58.264
  -154.491    57.984
>
  -155.183    58.243
  -155.240    58.282
>
  -155.111    58.308
  -155.240    58.282
>
  -155.326    58.211
  -155.240    58.282
>
  -155.295    58.382
  -155.240    58.282
>
  -154.703    58.498
  -155.240    58.282
>
  -155.741    58.440
  -155.240    58.282
>
  -155.884    58.265
  -155.240    58.282
>
  -155.884    58.265
  -155.240    58.282
>
  -155.887    58.264
  -155.240    58.282
>
  -155.887    58.264
  -155.240    58.282
>
  -154.546    58.494
  -155.240    58.282
>
  -155.006    58.649
  -155.240    58.282
>
  -155.006    58.649
  -155.240    58.282
>
  -155.009    58.648
  -155.240    58.282
>
  -155.009    58.648
  -155.240    58.282
>
  -154.347    58.597
  -155.240    58.282
>
  -156.267    57.689
  -155.240    58.282
>
  -156.607    57.802
  -155.240    58.282
>
  -156.387    57.640
  -155.240    58.282
>
  -156.387    57.640
  -155.240    58.282
>
  -156.387    57.640
  -155.240    58.282
>
  -156.656    58.677
  -155.240    58.282
>
  -156.656    58.677
  -155.240    58.282
>
  -152.583    57.783
  -152.997    57.574
>
  -152.583    57.783
  -152.997    57.574
>
  -152.583    57.783
  -152.997    57.574
>
  -152.583    57.783
  -152.997    57.574
>
  -152.583    57.783
  -152.997    57.574
>
  -153.288    57.222
  -152.997    57.574
>
  -153.288    57.222
  -152.997    57.574
>
  -154.452    57.567
  -152.997    57.574
>
  -154.452    57.567
  -152.997    57.574
>
  -152.583    57.783
  -152.987    57.576
>
  -152.583    57.783
  -152.987    57.576
>
  -153.288    57.222
  -152.987    57.576
>
  -154.452    57.567
  -152.987    57.576
>
  -154.452    57.567
  -152.987    57.576
>
  -154.452    57.567
  -152.987    57.576
>
  -152.583    57.783
  -151.997    58.210
>
  -152.391    58.610
  -151.997    58.210
>
  -152.391    58.610
  -151.997    58.210
>
  -153.288    57.222
  -153.116    56.899
>
  -153.288    57.222
  -153.116    56.899
>
  -153.288    57.222
  -153.116    56.899
>
  -153.288    57.222
  -153.116    56.899
>
  -154.182    56.560
  -153.116    56.899
>
  -154.182    56.560
  -153.116    56.899
>
  -152.583    57.783
  -153.116    56.899
>
  -152.583    57.783
  -153.116    56.899
>
  -152.583    57.783
  -153.116    56.899
>
  -152.583    57.783
  -153.116    56.899
>
  -154.452    57.567
  -153.116    56.899
>
  -154.452    57.567
  -153.116    56.899
>
  -154.546    58.494
  -153.588    58.395
>
  -154.546    58.494
  -153.588    58.395
>
  -153.645    58.929
  -153.588    58.395
>
  -153.645    58.929
  -153.588    58.395
>
  -153.645    58.929
  -153.588    58.395
>
  -152.394    58.610
  -153.588    58.395
>
  -152.394    58.610
  -153.588    58.395
>
  -152.391    58.610
  -153.588    58.395
>
  -152.391    58.610
  -153.588    58.395
>
  -155.061    58.297
  -153.588    58.395
>
  -155.006    58.649
  -153.588    58.395
>
  -155.006    58.649
  -153.588    58.395
>
  -155.009    58.648
  -153.588    58.395
>
  -155.009    58.648
  -153.588    58.395
>
  -152.583    57.783
  -153.588    58.395
>
  -152.583    57.783
  -153.588    58.395
>
  -152.583    57.783
  -153.588    58.395
>
  -155.183    58.243
  -153.588    58.395
>
  -155.295    58.382
  -153.588    58.395
>
  -155.282    58.270
  -153.588    58.395
>
  -155.326    58.211
  -153.588    58.395
>
  -154.452    57.567
  -153.588    58.395
>
  -154.452    57.567
  -153.588    58.395
>
  -153.414    59.355
  -153.588    58.395
>
  -153.445    59.363
  -153.588    58.395
>
  -153.357    59.370
  -153.588    58.395
>
  -153.357    59.370
  -153.588    58.395
>
  -153.435    59.382
  -153.588    58.395
>
  -155.183    58.243
  -154.815    58.078
>
  -155.326    58.211
  -154.815    58.078
>
  -155.494    58.199
  -154.815    58.078
>
  -155.295    58.382
  -154.815    58.078
>
  -154.546    58.494
  -154.815    58.078
>
  -154.546    58.494
  -154.815    58.078
>
  -154.452    57.567
  -154.815    58.078
>
  -154.452    57.567
  -154.815    58.078
>
  -155.884    58.265
  -154.815    58.078
>
  -155.884    58.265
  -154.815    58.078
>
  -155.006    58.649
  -154.815    58.078
>
  -155.006    58.649
  -154.815    58.078
>
  -154.347    58.597
  -154.815    58.078
>
  -156.267    57.689
  -154.815    58.078
>
  -156.267    57.689
  -154.815    58.078
>
  -156.387    57.640
  -154.815    58.078
>
  -156.387    57.640
  -154.815    58.078
>
  -156.607    57.802
  -154.815    58.078
>
  -154.182    56.560
  -154.428    56.815
>
  -154.182    56.560
  -154.428    56.815
>
  -154.182    56.560
  -154.428    56.815
>
  -154.182    56.560
  -154.428    56.815
>
  -154.182    56.560
  -154.428    56.815
>
  -154.452    57.567
  -154.428    56.815
>
  -153.288    57.222
  -154.428    56.815
>
  -153.288    57.222
  -154.428    56.815
>
  -153.288    57.222
  -154.428    56.815
>
  -154.182    56.560
  -154.347    56.305
>
  -154.182    56.560
  -154.347    56.305
>
  -154.182    56.560
  -154.347    56.305
>
  -154.182    56.560
  -154.347    56.305
>
  -155.620    55.822
  -154.347    56.305
>
  -155.620    55.822
  -154.347    56.305
>
  -154.182    56.560
  -154.316    56.204
>
  -154.182    56.560
  -154.316    56.204
>
  -154.182    56.560
  -154.316    56.204
>
  -155.620    55.822
  -154.316    56.204
>
  -155.620    55.822
  -154.316    56.204
>
  -155.620    55.822
  -154.316    56.204
>
  -154.546    58.494
  -154.216    58.046
>
  -154.546    58.494
  -154.216    58.046
>
  -154.452    57.567
  -154.216    58.046
>
  -154.452    57.567
  -154.216    58.046
>
  -155.061    58.297
  -154.216    58.046
>
  -155.061    58.297
  -154.216    58.046
>
  -154.347    58.597
  -154.216    58.046
>
  -154.347    58.597
  -154.216    58.046
>
  -155.183    58.243
  -154.216    58.046
>
  -155.326    58.211
  -154.216    58.046
>
  -155.295    58.382
  -154.216    58.046
>
  -155.494    58.199
  -154.216    58.046
>
  -155.494    58.199
  -154.216    58.046
>
  -155.006    58.649
  -154.216    58.046
>
  -152.583    57.783
  -154.216    58.046
>
  -152.583    57.783
  -154.216    58.046
>
  -153.645    58.929
  -154.216    58.046
>
  -153.645    58.929
  -154.216    58.046
>
  -155.884    58.265
  -154.216    58.046
>
  -153.288    57.222
  -154.216    58.046
>
  -153.288    57.222
  -154.216    58.046
>
  -152.583    57.783
  -152.873    57.862
>
  -152.583    57.783
  -152.873    57.862
>
  -152.583    57.783
  -152.873    57.862
>
  -152.583    57.783
  -152.873    57.862
>
  -153.288    57.222
  -152.873    57.862
>
  -153.288    57.222
  -152.873    57.862
>
  -152.394    58.610
  -152.873    57.862
>
  -152.394    58.610
  -152.873    57.862
>
  -152.391    58.610
  -152.873    57.862
>
  -152.391    58.610
  -152.873    57.862
>
  -154.452    57.567
  -152.873    57.862
>
  -154.452    57.567
  -152.873    57.862
>
  -154.452    57.567
  -155.010    56.830
>
  -154.452    57.567
  -155.010    56.830
>
  -152.391    58.610
  -151.154    58.627
>
  -152.391    58.610
  -151.154    58.627
>
  -152.394    58.610
  -151.154    58.627
>
  -152.394    58.610
  -151.154    58.627
>
  -151.236    59.526
  -151.154    58.627
>
  -151.236    59.526
  -151.154    58.627
>
  -155.326    58.211
  -155.443    58.202
>
  -155.326    58.211
  -155.443    58.202
>
  -155.494    58.199
  -155.443    58.202
>
  -155.494    58.199
  -155.443    58.202
>
  -155.183    58.243
  -155.443    58.202
>
  -155.295    58.382
  -155.443    58.202
>
  -155.111    58.308
  -155.443    58.202
>
  -155.884    58.265
  -155.443    58.202
>
  -155.884    58.265
  -155.443    58.202
>
  -155.887    58.264
  -155.443    58.202
>
  -155.887    58.264
  -155.443    58.202
>
  -155.741    58.440
  -155.443    58.202
>
  -155.006    58.649
  -155.443    58.202
>
  -154.546    58.494
  -155.443    58.202
>
  -154.546    58.494
  -155.443    58.202
>
  -154.347    58.597
  -155.443    58.202
>
  -154.347    58.597
  -155.443    58.202
>
  -156.656    58.677
  -155.443    58.202
>
  -156.656    58.677
  -155.443    58.202
>
  -156.656    58.677
  -155.443    58.202
>
  -155.006    58.649
  -155.089    58.714
>
  -155.006    58.649
  -155.089    58.714
>
  -155.295    58.382
  -155.089    58.714
>
  -155.061    58.297
  -155.089    58.714
>
  -155.061    58.297
  -155.089    58.714
>
  -155.183    58.243
  -155.089    58.714
>
  -155.494    58.199
  -155.089    58.714
>
  -155.494    58.199
  -155.089    58.714
>
  -155.884    58.265
  -155.089    58.714
>
  -155.884    58.265
  -155.089    58.714
>
  -155.887    58.264
  -155.089    58.714
>
  -155.887    58.264
  -155.089    58.714
>
  -155.229    59.392
  -155.089    58.714
>
  -155.229    59.392
  -155.089    58.714
>
  -155.229    59.392
  -155.089    58.714
>
  -153.645    58.929
  -155.089    58.714
>
  -156.656    58.677
  -155.089    58.714
>
  -156.656    58.677
  -155.089    58.714
>
  -156.439    59.195
  -155.089    58.714
>
  -156.439    59.195
  -155.089    58.714
>
  -156.267    57.689
  -155.128    57.544
>
  -156.267    57.689
  -155.128    57.544
>
  -155.326    58.211
  -155.128    57.544
>
  -155.326    58.211
  -155.128    57.544
>
  -155.494    58.199
  -155.128    57.544
>
  -155.183    58.243
  -155.128    57.544
>
  -155.061    58.297
  -155.128    57.544
>
  -155.884    58.265
  -155.128    57.544
>
  -155.884    58.265
  -155.128    57.544
>
  -156.607    57.802
  -155.128    57.544
>
  -155.887    58.264
  -155.128    57.544
>
  -155.887    58.264
  -155.128    57.544
>
  -155.295    58.382
  -155.128    57.544
>
  -155.741    58.440
  -155.128    57.544
>
  -154.182    56.560
  -153.348    56.328
>
  -154.182    56.560
  -153.348    56.328
>
  -153.288    57.222
  -153.348    56.328
>
  -153.288    57.222
  -153.348    56.328
>
  -153.288    57.222
  -153.348    56.328
>
  -154.182    56.560
  -153.368    56.293
>
  -153.288    57.222
  -153.368    56.293
>
  -153.288    57.222
  -153.368    56.293
>
  -153.288    57.222
  -153.368    56.293
>
  -154.182    56.560
  -153.335    56.198
>
  -154.182    56.560
  -153.335    56.198
>
  -154.182    56.560
  -153.335    56.198
>
  -155.061    58.297
  -154.013    58.306
>
  -155.061    58.297
  -154.013    58.306
>
  -155.183    58.243
  -154.013    58.306
>
  -155.006    58.649
  -154.013    58.306
>
  -155.295    58.382
  -154.013    58.306
>
  -155.326    58.211
  -154.013    58.306
>
  -155.326    58.211
  -154.013    58.306
>
  -153.645    58.929
  -154.013    58.306
>
  -153.645    58.929
  -154.013    58.306
>
  -155.494    58.199
  -154.013    58.306
>
  -152.583    57.783
  -154.013    58.306
>
  -155.741    58.440
  -154.013    58.306
>
  -152.391    58.610
  -154.013    58.306
>
  -152.391    58.610
  -154.013    58.306
>
  -155.884    58.265
  -154.013    58.306
>
  -155.884    58.265
  -154.013    58.306
>
  -152.583    57.783
  -152.922    58.203
>
  -152.583    57.783
  -152.922    58.203
>
  -152.583    57.783
  -152.922    58.203
>
  -152.394    58.610
  -152.922    58.203
>
  -152.394    58.610
  -152.922    58.203
>
  -152.391    58.610
  -152.922    58.203
>
  -152.391    58.610
  -152.922    58.203
>
  -153.645    58.929
  -152.922    58.203
>
  -153.645    58.929
  -152.922    58.203
>
  -153.645    58.929
  -152.922    58.203
>
  -155.061    58.297
  -155.254    58.300
>
  -155.183    58.243
  -155.254    58.300
>
  -155.295    58.382
  -155.254    58.300
>
  -155.326    58.211
  -155.254    58.300
>
  -155.006    58.649
  -155.254    58.300
>
  -156.267    57.689
  -155.254    58.300
>
  -156.656    58.677
  -155.254    58.300
>
  -156.607    57.802
  -155.254    58.300
>
  -156.267    57.689
  -155.510    57.647
>
  -155.494    58.199
  -155.510    57.647
>
  -155.494    58.199
  -155.510    57.647
>
  -155.326    58.211
  -155.510    57.647
>
  -155.326    58.211
  -155.510    57.647
>
  -155.183    58.243
  -155.510    57.647
>
  -156.607    57.802
  -155.510    57.647
>
  -155.295    58.382
  -155.510    57.647
>
  -155.741    58.440
  -155.510    57.647
>
  -156.878    57.998
  -155.510    57.647
>
  -156.267    57.689
  -155.499    57.656
>
  -156.267    57.689
  -155.499    57.656
>
  -155.494    58.199
  -155.499    57.656
>
  -155.494    58.199
  -155.499    57.656
>
  -155.326    58.211
  -155.499    57.656
>
  -155.326    58.211
  -155.499    57.656
>
  -155.183    58.243
  -155.499    57.656
>
  -156.607    57.802
  -155.499    57.656
>
  -155.295    58.382
  -155.499    57.656
>
  -155.741    58.440
  -155.499    57.656
>
  -156.878    57.998
  -155.499    57.656
>
  -156.267    57.689
  -155.537    57.670
>
  -156.267    57.689
  -155.537    57.670
>
  -155.494    58.199
  -155.537    57.670
>
  -155.494    58.199
  -155.537    57.670
>
  -155.326    58.211
  -155.537    57.670
>
  -155.326    58.211
  -155.537    57.670
>
  -155.183    58.243
  -155.537    57.670
>
  -156.607    57.802
  -155.537    57.670
>
  -155.295    58.382
  -155.537    57.670
>
  -156.819    57.700
  -155.537    57.670
>
  -155.741    58.440
  -155.537    57.670
>
  -152.583    57.783
  -152.524    57.824
>
  -152.583    57.783
  -152.524    57.824
>
  -153.288    57.222
  -152.524    57.824
>
  -153.288    57.222
  -152.524    57.824
>
  -152.391    58.610
  -152.524    57.824
>
  -152.391    58.610
  -152.524    57.824
>
  -152.391    58.610
  -151.150    58.385
>
  -152.391    58.610
  -151.150    58.385
>
  -152.394    58.610
  -151.150    58.385
>
  -152.583    57.783
  -151.150    58.385
>
  -152.583    57.783
  -151.150    58.385
>
  -152.583    57.783
  -151.150    58.385
>
  -152.583    57.783
  -151.150    58.385
>
  -153.288    57.222
  -152.595    56.920
>
  -153.288    57.222
  -152.595    56.920
>
  -153.288    57.222
  -152.595    56.920
>
  -152.583    57.783
  -152.595    56.920
>
  -152.583    57.783
  -152.595    56.920
>
  -152.583    57.783
  -152.595    56.920
>
  -154.182    56.560
  -152.595    56.920
>
  -154.182    56.560
  -152.595    56.920
>
  -152.394    58.610
  -153.083    58.658
>
  -152.394    58.610
  -153.083    58.658
>
  -152.391    58.610
  -153.083    58.658
>
  -152.391    58.610
  -153.083    58.658
>
  -153.645    58.929
  -153.083    58.658
>
  -153.645    58.929
  -153.083    58.658
>
  -153.645    58.929
  -153.083    58.658
>
  -153.645    58.929
  -153.083    58.658
>
  -153.357    59.370
  -153.083    58.658
>
  -153.445    59.363
  -153.083    58.658
>
  -153.435    59.382
  -153.083    58.658
>
  -152.583    57.783
  -153.083    58.658
>
  -152.583    57.783
  -153.083    58.658
>
  -154.452    57.567
  -155.292    57.278
>
  -154.452    57.567
  -155.292    57.278
>
  -156.267    57.689
  -155.292    57.278
>
  -156.358    57.632
  -155.292    57.278
>
  -156.358    57.632
  -155.292    57.278
>
  -156.360    57.631
  -155.292    57.278
>
  -156.360    57.631
  -155.292    57.278
>
  -156.324    57.764
  -155.292    57.278
>
  -156.324    57.764
  -155.292    57.278
>
  -155.573    58.054
  -155.292    57.278
>
  -154.182    56.560
  -155.292    57.278
>
  -156.607    57.802
  -155.292    57.278
>
  -155.494    58.199
  -155.292    57.278
>
  -155.494    58.199
  -155.292    57.278
>
  -156.819    57.700
  -155.292    57.278
>
  -155.326    58.211
  -155.292    57.278
>
  -155.282    58.270
  -155.292    57.278
>
  -154.546    58.494
  -154.071    58.188
>
  -154.546    58.494
  -154.071    58.188
>
  -154.452    57.567
  -154.071    58.188
>
  -154.452    57.567
  -154.071    58.188
>
  -154.452    57.567
  -154.071    58.188
>
  -155.282    58.270
  -154.071    58.188
>
  -155.282    58.270
  -154.071    58.188
>
  -155.326    58.211
  -154.071    58.188
>
  -155.326    58.211
  -154.071    58.188
>
  -155.006    58.649
  -154.071    58.188
>
  -155.006    58.649
  -154.071    58.188
>
  -155.009    58.648
  -154.071    58.188
>
  -155.009    58.648
  -154.071    58.188
>
  -155.494    58.199
  -154.071    58.188
>
  -153.645    58.929
  -154.071    58.188
>
  -153.645    58.929
  -154.071    58.188
>
  -152.583    57.783
  -154.071    58.188
>
  -152.583    57.783
  -154.071    58.188
>
  -155.884    58.265
  -154.071    58.188
>
  -155.884    58.265
  -154.071    58.188
>
  -155.887    58.264
  -154.071    58.188
>
  -155.887    58.264
  -154.071    58.188
>
  -152.394    58.610
  -154.071    58.188
>
  -152.394    58.610
  -154.071    58.188
>
  -152.391    58.610
  -154.071    58.188
>
  -152.391    58.610
  -154.071    58.188
>
  -156.267    57.689
  -155.508    57.278
>
  -156.267    57.689
  -155.508    57.278
>
  -156.358    57.632
  -155.508    57.278
>
  -156.358    57.632
  -155.508    57.278
>
  -156.360    57.631
  -155.508    57.278
>
  -156.360    57.631
  -155.508    57.278
>
  -154.452    57.567
  -155.508    57.278
>
  -156.324    57.764
  -155.508    57.278
>
  -156.607    57.802
  -155.508    57.278
>
  -156.607    57.802
  -155.508    57.278
>
  -155.494    58.199
  -155.508    57.278
>
  -155.494    58.199
  -155.508    57.278
>
  -155.326    58.211
  -155.508    57.278
>
  -152.391    58.610
  -151.623    58.288
>
  -152.391    58.610
  -151.623    58.288
>
  -152.583    57.783
  -151.623    58.288
>
  -152.583    57.783
  -151.623    58.288
>
  -153.645    58.929
  -153.230    58.628
>
  -153.645    58.929
  -153.230    58.628
>
  -152.394    58.610
  -153.230    58.628
>
  -152.394    58.610
  -153.230    58.628
>
  -152.391    58.610
  -153.230    58.628
>
  -152.391    58.610
  -153.230    58.628
>
  -154.347    58.597
  -153.230    58.628
>
  -154.347    58.597
  -153.230    58.628
>
  -153.357    59.370
  -153.230    58.628
>
  -153.445    59.363
  -153.230    58.628
>
  -154.546    58.494
  -153.230    58.628
>
  -154.546    58.494
  -153.230    58.628
>
  -153.435    59.382
  -153.230    58.628
>
  -153.435    59.382
  -153.230    58.628
>
  -154.703    58.498
  -153.230    58.628
>
  -154.799    58.384
  -153.230    58.628
>
  -152.583    57.783
  -153.230    58.628
>
  -152.583    57.783
  -153.230    58.628
>
  -155.006    58.649
  -153.230    58.628
>
  -155.009    58.648
  -153.230    58.628
>
  -154.182    56.560
  -154.782    56.519
>
  -154.182    56.560
  -154.782    56.519
>
  -154.182    56.560
  -154.782    56.519
>
  -154.182    56.560
  -154.782    56.519
>
  -155.620    55.822
  -154.782    56.519
>
  -155.620    55.822
  -154.782    56.519
>
  -155.620    55.822
  -154.782    56.519
>
  -154.182    56.560
  -153.988    56.367
>
  -153.288    57.222
  -153.988    56.367
>
  -153.288    57.222
  -153.988    56.367
>
  -152.394    58.610
  -153.175    58.368
>
  -152.394    58.610
  -153.175    58.368
>
  -152.391    58.610
  -153.175    58.368
>
  -152.391    58.610
  -153.175    58.368
>
  -153.645    58.929
  -153.175    58.368
>
  -153.645    58.929
  -153.175    58.368
>
  -152.583    57.783
  -153.175    58.368
>
  -152.583    57.783
  -153.175    58.368
>
  -152.583    57.783
  -153.175    58.368
>
  -152.583    57.783
  -153.175    58.368
>
  -154.546    58.494
  -153.175    58.368
>
  -154.546    58.494
  -153.175    58.368
>
  -154.799    58.384
  -153.175    58.368
>
  -154.546    58.494
  -154.090    58.565
>
  -154.546    58.494
  -154.090    58.565
>
  -154.703    58.498
  -154.090    58.565
>
  -153.645    58.929
  -154.090    58.565
>
  -153.645    58.929
  -154.090    58.565
>
  -153.645    58.929
  -154.090    58.565
>
  -154.799    58.384
  -154.090    58.565
>
  -155.006    58.649
  -154.090    58.565
>
  -155.006    58.649
  -154.090    58.565
>
  -155.006    58.649
  -154.090    58.565
>
  -155.009    58.648
  -154.090    58.565
>
  -155.295    58.382
  -154.090    58.565
>
  -155.183    58.243
  -154.090    58.565
>
  -155.326    58.211
  -154.090    58.565
>
  -153.445    59.363
  -154.090    58.565
>
  -153.357    59.370
  -154.090    58.565
>
  -155.494    58.199
  -154.090    58.565
>
  -155.494    58.199
  -154.090    58.565
>
  -152.394    58.610
  -154.090    58.565
>
  -152.391    58.610
  -154.090    58.565
>
  -152.391    58.610
  -154.090    58.565
>
  -155.884    58.265
  -154.090    58.565
>
  -155.887    58.264
  -154.090    58.565
>
  -153.645    58.929
  -153.927    58.655
>
  -153.645    58.929
  -153.927    58.655
>
  -154.546    58.494
  -153.927    58.655
>
  -154.546    58.494
  -153.927    58.655
>
  -155.006    58.649
  -153.927    58.655
>
  -155.006    58.649
  -153.927    58.655
>
  -155.006    58.649
  -153.927    58.655
>
  -155.009    58.648
  -153.927    58.655
>
  -155.009    58.648
  -153.927    58.655
>
  -153.445    59.363
  -153.927    58.655
>
  -153.357    59.370
  -153.927    58.655
>
  -152.394    58.610
  -153.927    58.655
>
  -152.394    58.610
  -153.927    58.655
>
  -152.391    58.610
  -153.927    58.655
>
  -152.391    58.610
  -153.927    58.655
>
  -155.326    58.211
  -153.927    58.655
>
  -155.326    58.211
  -153.927    58.655
>
  -155.494    58.199
  -153.927    58.655
>
  -155.229    59.392
  -153.927    58.655
>
  -155.229    59.392
  -153.927    58.655
>
  -155.295    58.382
  -155.309    58.359
>
  -155.741    58.440
  -155.309    58.359
>
  -155.183    58.243
  -155.309    58.359
>
  -155.326    58.211
  -155.309    58.359
>
  -155.494    58.199
  -155.309    58.359
>
  -155.494    58.199
  -155.309    58.359
>
  -155.006    58.649
  -155.309    58.359
>
  -154.799    58.384
  -155.309    58.359
>
  -155.884    58.265
  -155.309    58.359
>
  -155.884    58.265
  -155.309    58.359
>
  -155.887    58.264
  -155.309    58.359
>
  -155.887    58.264
  -155.309    58.359
>
  -154.703    58.498
  -155.309    58.359
>
  -155.573    58.054
  -155.309    58.359
>
  -154.546    58.494
  -155.309    58.359
>
  -154.546    58.494
  -155.309    58.359
>
  -156.656    58.677
  -155.309    58.359
>
  -156.656    58.677
  -155.309    58.359
>
  -156.656    58.677
  -155.309    58.359
>
  -156.656    58.677
  -155.309    58.359
>
  -156.607    57.802
  -155.309    58.359
>
  -156.607    57.802
  -155.309    58.359
>
  -154.452    57.567
  -155.309    58.359
>
  -154.452    57.567
  -155.309    58.359
>
  -154.452    57.567
  -155.309    58.359
>
  -154.452    57.567
  -154.556    57.347
>
  -154.452    57.567
  -154.556    57.347
>
  -153.288    57.222
  -154.556    57.347
>
  -153.288    57.222
  -154.556    57.347
>
  -154.182    56.560
  -154.556    57.347
>
  -154.182    56.560
  -154.556    57.347
>
  -155.573    58.054
  -154.556    57.347
>
  -155.326    58.211
  -154.556    57.347
>
  -155.326    58.211
  -154.556    57.347
>
  -155.183    58.243
  -154.556    57.347
>
  -155.494    58.199
  -154.556    57.347
>
  -155.494    58.199
  -154.556    57.347
>
  -152.583    57.783
  -152.579    58.001
>
  -152.583    57.783
  -152.579    58.001
>
  -152.583    57.783
  -152.579    58.001
>
  -152.583    57.783
  -152.579    58.001
>
  -152.394    58.610
  -152.579    58.001
>
  -152.394    58.610
  -152.579    58.001
>
  -152.391    58.610
  -152.579    58.001
>
  -152.391    58.610
  -152.579    58.001
>
  -153.288    57.222
  -152.579    58.001
>
  -153.288    57.222
  -152.579    58.001
>
  -153.288    57.222
  -152.579    58.001
>
  -154.452    57.567
  -155.365    57.342
>
  -154.452    57.567
  -155.365    57.342
>
  -154.452    57.567
  -155.365    57.342
>
  -154.452    57.567
  -155.365    57.342
>
  -155.573    58.054
  -155.365    57.342
>
  -156.607    57.802
  -155.365    57.342
>
  -156.607    57.802
  -155.365    57.342
>
  -156.819    57.700
  -155.365    57.342
>
  -155.494    58.199
  -155.365    57.342
>
  -155.494    58.199
  -155.365    57.342
>
  -155.326    58.211
  -155.365    57.342
>
  -155.326    58.211
  -155.365    57.342
>
  -155.183    58.243
  -155.365    57.342
>
  -154.546    58.494
  -153.972    58.167
>
  -154.546    58.494
  -153.972    58.167
>
  -154.452    57.567
  -153.972    58.167
>
  -154.452    57.567
  -153.972    58.167
>
  -155.183    58.243
  -153.972    58.167
>
  -155.326    58.211
  -153.972    58.167
>
  -155.326    58.211
  -153.972    58.167
>
  -155.295    58.382
  -153.972    58.167
>
  -155.006    58.649
  -153.972    58.167
>
  -155.494    58.199
  -153.972    58.167
>
  -153.645    58.929
  -153.972    58.167
>
  -153.645    58.929
  -153.972    58.167
>
  -152.583    57.783
  -153.972    58.167
>
  -152.583    57.783
  -153.972    58.167
>
  -155.573    58.054
  -153.972    58.167
>
  -152.391    58.610
  -153.972    58.167
>
  -152.391    58.610
  -153.972    58.167
>
  -152.391    58.610
  -153.085    58.294
>
  -152.391    58.610
  -153.085    58.294
>
  -152.583    57.783
  -153.085    58.294
>
  -152.583    57.783
  -153.085    58.294
>
  -153.645    58.929
  -153.085    58.294
>
  -153.645    58.929
  -153.085    58.294
>
  -154.546    58.494
  -153.085    58.294
>
  -154.546    58.494
  -153.085    58.294
>
  -155.295    58.382
  -155.259    58.489
>
  -155.183    58.243
  -155.259    58.489
>
  -155.006    58.649
  -155.259    58.489
>
  -155.326    58.211
  -155.259    58.489
>
  -155.326    58.211
  -155.259    58.489
>
  -155.494    58.199
  -155.259    58.489
>
  -155.494    58.199
  -155.259    58.489
>
  -154.546    58.494
  -155.259    58.489
>
  -154.546    58.494
  -155.259    58.489
>
  -156.656    58.677
  -155.259    58.489
>
  -155.229    59.392
  -155.259    58.489
>
  -155.229    59.392
  -155.259    58.489
>
  -156.439    59.195
  -155.259    58.489
>
  -156.439    59.195
  -155.259    58.489
>
  -156.607    57.802
  -155.259    58.489
>
  -153.645    58.929
  -155.259    58.489
>
  -153.645    58.929
  -155.259    58.489
>
  -155.006    58.649
  -155.083    58.610
>
  -155.006    58.649
  -155.083    58.610
>
  -155.006    58.649
  -155.083    58.610
>
  -155.009    58.648
  -155.083    58.610
>
  -155.009    58.648
  -155.083    58.610
>
  -154.546    58.494
  -155.083    58.610
>
  -154.546    58.494
  -155.083    58.610
>
  -155.061    58.297
  -155.083    58.610
>
  -155.061    58.297
  -155.083    58.610
>
  -155.326    58.211
  -155.083    58.610
>
  -155.326    58.211
  -155.083    58.610
>
  -155.494    58.199
  -155.083    58.610
>
  -155.494    58.199
  -155.083    58.610
>
  -155.229    59.392
  -155.083    58.610
>
  -155.229    59.392
  -155.083    58.610
>
  -155.229    59.392
  -155.083    58.610
>
  -156.656    58.677
  -155.083    58.610
>
  -156.656    58.677
  -155.083    58.610
>
  -156.656    58.677
  -155.083    58.610
>
  -156.656    58.677
  -155.083    58.610
>
  -153.645    58.929
  -155.083    58.610
>
  -153.645    58.929
  -155.083    58.610
>
  -153.645    58.929
  -155.083    58.610
>
  -153.645    58.929
  -155.083    58.610
>
  -156.439    59.195
  -155.083    58.610
>
  -156.439    59.195
  -155.083    58.610
>
  -156.439    59.195
  -155.083    58.610
>
  -156.439    59.195
  -155.083    58.610
>
  -154.546    58.494
  -154.263    58.092
>
  -154.546    58.494
  -154.263    58.092
>
  -154.452    57.567
  -154.263    58.092
>
  -154.452    57.567
  -154.263    58.092
>
  -155.326    58.211
  -154.263    58.092
>
  -155.326    58.211
  -154.263    58.092
>
  -155.494    58.199
  -154.263    58.092
>
  -155.006    58.649
  -154.263    58.092
>
  -155.006    58.649
  -154.263    58.092
>
  -153.645    58.929
  -154.263    58.092
>
  -153.645    58.929
  -154.263    58.092
>
  -152.583    57.783
  -154.263    58.092
>
  -155.494    58.199
  -155.925    57.938
>
  -155.494    58.199
  -155.925    57.938
>
  -155.326    58.211
  -155.925    57.938
>
  -155.326    58.211
  -155.925    57.938
>
  -156.607    57.802
  -155.925    57.938
>
  -156.819    57.700
  -155.925    57.938
>
  -155.006    58.649
  -155.925    57.938
>
  -156.656    58.677
  -155.925    57.938
>
  -156.656    58.677
  -155.925    57.938
>
  -154.452    57.567
  -155.925    57.938
>
  -154.452    57.567
  -155.925    57.938
>
  -154.546    58.494
  -155.925    57.938
>
  -157.574    57.567
  -155.925    57.938
>
  -154.182    56.560
  -154.309    56.374
>
  -154.182    56.560
  -154.309    56.374
>
  -154.182    56.560
  -154.309    56.374
>
  -154.182    56.560
  -154.309    56.374
>
  -155.620    55.822
  -154.309    56.374
>
  -155.620    55.822
  -154.309    56.374
>
  -155.620    55.822
  -154.309    56.374
>
  -153.288    57.222
  -153.069    56.777
>
  -153.288    57.222
  -153.069    56.777
>
  -154.182    56.560
  -153.069    56.777
>
  -154.182    56.560
  -153.069    56.777
>
  -152.583    57.783
  -152.658    57.984
>
  -152.583    57.783
  -152.658    57.984
>
  -152.391    58.610
  -152.658    57.984
>
  -152.391    58.610
  -152.658    57.984
>
  -153.288    57.222
  -152.658    57.984
>
  -153.288    57.222
  -152.658    57.984
>
  -154.452    57.567
  -155.024    57.084
>
  -154.452    57.567
  -155.024    57.084
>
  -154.182    56.560
  -155.024    57.084
>
  -154.182    56.560
  -155.024    57.084
>
  -154.182    56.560
  -155.024    57.084
>
  -153.288    57.222
  -155.024    57.084
>
  -153.288    57.222
  -155.024    57.084
>
  -153.288    57.222
  -155.024    57.084
>
  -152.391    58.610
  -151.301    58.346
>
  -152.391    58.610
  -151.301    58.346
>
  -152.394    58.610
  -151.301    58.346
>
  -152.394    58.610
  -151.301    58.346
>
  -152.583    57.783
  -151.301    58.346
>
  -152.583    57.783
  -151.301    58.346
>
  -152.583    57.783
  -151.301    58.346
>
  -152.583    57.783
  -151.301    58.346
>
  -152.391    58.610
  -151.326    58.322
>
  -152.391    58.610
  -151.326    58.322
>
  -152.583    57.783
  -151.326    58.322
>
  -152.583    57.783
  -151.326    58.322
>
  -152.391    58.610
  -151.487    58.563
>
  -152.391    58.610
  -151.487    58.563
>
  -152.583    57.783
  -151.487    58.563
>
  -152.583    57.783
  -151.487    58.563
>
  -151.236    59.526
  -151.487    58.563
>
  -151.236    59.526
  -151.487    58.563
>
  -154.347    58.597
  -153.614    58.454
>
  -154.347    58.597
  -153.614    58.454
>
  -153.645    58.929
  -153.614    58.454
>
  -154.546    58.494
  -153.614    58.454
>
  -152.391    58.610
  -153.614    58.454
>
  -152.391    58.610
  -153.614    58.454
>
  -155.006    58.649
  -153.614    58.454
>
  -155.006    58.649
  -153.614    58.454
>
  -152.583    57.783
  -153.614    58.454
>
  -152.583    57.783
  -153.614    58.454
>
  -152.583    57.783
  -153.614    58.454
>
  -155.326    58.211
  -153.614    58.454
>
  -154.452    57.567
  -153.614    58.454
>
  -154.452    57.567
  -154.277    57.927
>
  -154.452    57.567
  -154.277    57.927
>
  -155.301    58.053
  -154.277    57.927
>
  -155.326    58.211
  -154.277    57.927
>
  -155.326    58.211
  -154.277    57.927
>
  -155.494    58.199
  -154.277    57.927
>
  -155.494    58.199
  -154.277    57.927
>
  -155.006    58.649
  -154.277    57.927
>
  -155.006    58.649
  -154.277    57.927
>
  -153.288    57.222
  -154.277    57.927
>
  -153.288    57.222
  -154.277    57.927
>
  -155.884    58.265
  -154.277    57.927
>
  -155.884    58.265
  -154.277    57.927
>
  -152.583    57.783
  -154.277    57.927
>
  -152.583    57.783
  -154.277    57.927
>
  -154.452    57.567
  -154.649    57.606
>
  -154.452    57.567
  -154.649    57.606
>
  -155.326    58.211
  -154.649    57.606
>
  -155.326    58.211
  -154.649    57.606
>
  -155.061    58.297
  -154.649    57.606
>
  -155.061    58.297
  -154.649    57.606
>
  -155.282    58.270
  -154.649    57.606
>
  -155.282    58.270
  -154.649    57.606
>
  -155.494    58.199
  -154.649    57.606
>
  -155.494    58.199
  -154.649    57.606
>
  -153.288    57.222
  -154.649    57.606
>
  -153.288    57.222
  -154.649    57.606
>
  -156.267    57.689
  -154.649    57.606
>
  -156.267    57.689
  -154.649    57.606
>
  -154.546    58.494
  -154.649    57.606
>
  -154.546    58.494
  -154.649    57.606
>
  -156.324    57.764
  -154.649    57.606
>
  -156.324    57.764
  -154.649    57.606
>
  -156.358    57.632
  -154.649    57.606
>
  -156.358    57.632
  -154.649    57.606
>
  -155.884    58.265
  -154.649    57.606
>
  -155.884    58.265
  -154.649    57.606
>
  -152.583    57.783
  -152.147    58.131
>
  -152.583    57.783
  -152.147    58.131
>
  -152.583    57.783
  -152.147    58.131
>
  -152.583    57.783
  -152.147    58.131
>
  -152.391    58.610
  -152.147    58.131
>
  -152.391    58.610
  -152.147    58.131
>
  -152.583    57.783
  -153.012    58.207
>
  -152.583    57.783
  -153.012    58.207
>
  -152.583    57.783
  -153.012    58.207
>
  -152.583    57.783
  -153.012    58.207
>
  -152.391    58.610
  -153.012    58.207
>
  -152.391    58.610
  -153.012    58.207
>
  -153.645    58.929
  -153.012    58.207
>
  -154.347    58.597
  -153.012    58.207
>
  -154.347    58.597
  -153.012    58.207
>
  -154.546    58.494
  -153.012    58.207
>
  -154.546    58.494
  -153.012    58.207
>
  -154.703    58.498
  -153.012    58.207
>
  -154.799    58.384
  -153.012    58.207
>
  -153.288    57.222
  -153.012    58.207
>
  -153.288    57.222
  -153.012    58.207
>
  -153.288    57.222
  -153.012    58.207
>
  -154.546    58.494
  -154.011    58.223
>
  -154.546    58.494
  -154.011    58.223
>
  -154.347    58.597
  -154.011    58.223
>
  -154.347    58.597
  -154.011    58.223
>
  -155.061    58.297
  -154.011    58.223
>
  -155.061    58.297
  -154.011    58.223
>
  -155.111    58.308
  -154.011    58.223
>
  -155.282    58.270
  -154.011    58.223
>
  -155.282    58.270
  -154.011    58.223
>
  -155.006    58.649
  -154.011    58.223
>
  -155.006    58.649
  -154.011    58.223
>
  -155.326    58.211
  -154.011    58.223
>
  -153.645    58.929
  -154.011    58.223
>
  -155.494    58.199
  -154.011    58.223
>
  -152.583    57.783
  -154.011    58.223
>
  -152.583    57.783
  -154.011    58.223
>
  -155.884    58.265
  -154.011    58.223
>
  -152.391    58.610
  -151.478    58.302
>
  -152.391    58.610
  -151.478    58.302
>
  -152.583    57.783
  -151.478    58.302
>
  -152.583    57.783
  -151.478    58.302
>
  -154.347    58.597
  -154.235    58.477
>
  -154.347    58.597
  -154.235    58.477
>
  -154.546    58.494
  -154.235    58.477
>
  -154.546    58.494
  -154.235    58.477
>
  -154.703    58.498
  -154.235    58.477
>
  -154.703    58.498
  -154.235    58.477
>
  -154.799    58.384
  -154.235    58.477
>
  -154.799    58.384
  -154.235    58.477
>
  -155.006    58.649
  -154.235    58.477
>
  -155.006    58.649
  -154.235    58.477
>
  -155.061    58.297
  -154.235    58.477
>
  -155.061    58.297
  -154.235    58.477
>
  -153.645    58.929
  -154.235    58.477
>
  -153.645    58.929
  -154.235    58.477
>
  -155.295    58.382
  -154.235    58.477
>
  -155.282    58.270
  -154.235    58.477
>
  -155.282    58.270
  -154.235    58.477
>
  -155.326    58.211
  -154.235    58.477
>
  -155.884    58.265
  -154.235    58.477
>
  -155.884    58.265
  -154.235    58.477
>
  -152.391    58.610
  -154.235    58.477
>
  -152.391    58.610
  -154.235    58.477
>
  -152.583    57.783
  -153.512    57.826
>
  -152.583    57.783
  -153.512    57.826
>
  -154.452    57.567
  -153.512    57.826
>
  -154.452    57.567
  -153.512    57.826
>
  -153.288    57.222
  -153.512    57.826
>
  -153.288    57.222
  -153.512    57.826
>
  -154.546    58.494
  -153.512    57.826
>
  -154.799    58.384
  -153.512    57.826
>
  -155.161    58.134
  -153.512    57.826
>
  -154.703    58.498
  -153.512    57.826
>
  -155.061    58.297
  -153.512    57.826
>
  -155.061    58.297
  -153.512    57.826
>
  -155.301    58.053
  -153.512    57.826
>
  -152.391    58.610
  -153.512    57.826
>
  -153.645    58.929
  -153.583    58.670
>
  -153.645    58.929
  -153.583    58.670
>
  -154.347    58.597
  -153.583    58.670
>
  -154.347    58.597
  -153.583    58.670
>
  -154.546    58.494
  -153.583    58.670
>
  -154.546    58.494
  -153.583    58.670
>
  -152.391    58.610
  -153.583    58.670
>
  -152.391    58.610
  -153.583    58.670
>
  -154.703    58.498
  -153.583    58.670
>
  -154.703    58.498
  -153.583    58.670
>
  -154.799    58.384
  -153.583    58.670
>
  -154.799    58.384
  -153.583    58.670
>
  -153.427    59.335
  -153.583    58.670
>
  -153.427    59.335
  -153.583    58.670
>
  -153.408    59.350
  -153.583    58.670
>
  -153.408    59.350
  -153.583    58.670
>
  -153.471    59.370
  -153.583    58.670
>
  -153.471    59.370
  -153.583    58.670
>
  -155.006    58.649
  -153.583    58.670
>
  -155.061    58.297
  -153.583    58.670
>
  -155.061    58.297
  -153.583    58.670
>
  -155.282    58.270
  -153.583    58.670
>
  -155.161    58.134
  -153.583    58.670
>
  -152.583    57.783
  -152.358    57.626
>
  -152.583    57.783
  -152.358    57.626
>
  -153.288    57.222
  -152.358    57.626
>
  -153.288    57.222
  -152.358    57.626
>
  -152.391    58.610
  -152.358    57.626
>
  -152.391    58.610
  -152.358    57.626
>
  -153.288    57.222
  -154.288    57.622
>
  -153.288    57.222
  -154.288    57.622
>
  -155.061    58.297
  -154.288    57.622
>
  -155.061    58.297
  -154.288    57.622
>
  -155.326    58.211
  -154.288    57.622
>
  -155.326    58.211
  -154.288    57.622
>
  -154.799    58.384
  -154.288    57.622
>
  -154.799    58.384
  -154.288    57.622
>
  -155.282    58.270
  -154.288    57.622
>
  -155.494    58.199
  -154.288    57.622
>
  -154.546    58.494
  -154.288    57.622
>
  -154.546    58.494
  -154.288    57.622
>
  -154.703    58.498
  -154.288    57.622
>
  -152.583    57.783
  -154.288    57.622
>
  -152.583    57.783
  -154.288    57.622
>
  -154.347    58.597
  -154.288    57.622
>
  -152.391    58.610
  -151.381    58.470
>
  -152.391    58.610
  -151.381    58.470
>
  -152.583    57.783
  -151.381    58.470
>
  -152.583    57.783
  -151.381    58.470
>
  -152.391    58.610
  -151.328    58.523
>
  -152.391    58.610
  -151.328    58.523
>
  -152.583    57.783
  -151.328    58.523
>
  -152.583    57.783
  -151.328    58.523
>
  -154.799    58.384
  -154.173    58.096
>
  -154.799    58.384
  -154.173    58.096
>
  -154.546    58.494
  -154.173    58.096
>
  -154.546    58.494
  -154.173    58.096
>
  -154.703    58.498
  -154.173    58.096
>
  -154.703    58.498
  -154.173    58.096
>
  -155.061    58.297
  -154.173    58.096
>
  -155.061    58.297
  -154.173    58.096
>
  -155.282    58.270
  -154.173    58.096
>
  -155.282    58.270
  -154.173    58.096
>
  -155.326    58.211
  -154.173    58.096
>
  -155.494    58.199
  -154.173    58.096
>
  -155.006    58.649
  -154.173    58.096
>
  -155.006    58.649
  -154.173    58.096
>
  -153.645    58.929
  -154.173    58.096
>
  -153.645    58.929
  -154.173    58.096
>
  -152.583    57.783
  -154.173    58.096
>
  -152.583    57.783
  -154.173    58.096
>
  -153.288    57.222
  -154.173    58.096
>
  -153.288    57.222
  -154.173    58.096
>
  -152.391    58.610
  -152.583    58.269
>
  -152.391    58.610
  -152.583    58.269
>
  -152.583    57.783
  -152.583    58.269
>
  -152.583    57.783
  -152.583    58.269
>
  -152.583    57.783
  -152.583    58.269
>
  -152.583    57.783
  -152.583    58.269
>
  -153.645    58.929
  -152.583    58.269
>
  -153.645    58.929
  -152.583    58.269
>
  -153.645    58.929
  -153.858    58.650
>
  -153.645    58.929
  -153.858    58.650
>
  -154.546    58.494
  -153.858    58.650
>
  -154.546    58.494
  -153.858    58.650
>
  -154.703    58.498
  -153.858    58.650
>
  -154.703    58.498
  -153.858    58.650
>
  -154.799    58.384
  -153.858    58.650
>
  -154.799    58.384
  -153.858    58.650
>
  -155.006    58.649
  -153.858    58.650
>
  -155.006    58.649
  -153.858    58.650
>
  -153.427    59.335
  -153.858    58.650
>
  -153.427    59.335
  -153.858    58.650
>
  -155.061    58.297
  -153.858    58.650
>
  -155.061    58.297
  -153.858    58.650
>
  -153.408    59.350
  -153.858    58.650
>
  -153.408    59.350
  -153.858    58.650
>
  -153.431    59.360
  -153.858    58.650
>
  -153.445    59.363
  -153.858    58.650
>
  -153.445    59.363
  -153.858    58.650
>
  -153.471    59.370
  -153.858    58.650
>
  -153.471    59.370
  -153.858    58.650
>
  -152.391    58.610
  -153.858    58.650
>
  -152.391    58.610
  -153.858    58.650
>
  -153.357    59.370
  -153.858    58.650
>
  -155.282    58.270
  -153.858    58.650
>
  -155.282    58.270
  -153.858    58.650
>
  -155.326    58.211
  -153.858    58.650
>
  -155.326    58.211
  -153.858    58.650
>
  -155.494    58.199
  -153.858    58.650
>
  -154.182    56.560
  -153.485    56.162
>
  -154.182    56.560
  -153.452    56.277
>
  -154.182    56.560
  -153.452    56.277
>
  -154.182    56.560
  -153.452    56.277
>
  -153.288    57.222
  -153.452    56.277
>
  -153.288    57.222
  -153.452    56.277
>
  -153.288    57.222
  -153.452    56.277
>
  -154.182    56.560
  -153.449    56.087
>
  -154.182    56.560
  -153.449    56.087
>
  -154.182    56.560
  -153.400    56.205
>
  -154.182    56.560
  -153.370    56.092
>
  -154.182    56.560
  -153.370    56.092
>
  -154.182    56.560
  -153.354    56.076
>
  -154.182    56.560
  -153.354    56.076
>
  -154.182    56.560
  -153.354    56.076
>
  -154.182    56.560
  -153.354    56.076
>
  -155.620    55.822
  -154.619    56.017
>
  -155.620    55.822
  -154.619    56.017
>
  -154.182    56.560
  -154.619    56.017
>
  -152.583    57.783
  -152.799    58.429
>
  -152.583    57.783
  -152.799    58.429
>
  -153.645    58.929
  -152.799    58.429
>
  -153.645    58.929
  -152.799    58.429
>
  -154.347    58.597
  -152.799    58.429
>
  -154.347    58.597
  -152.799    58.429
>
  -154.546    58.494
  -152.799    58.429
>
  -154.546    58.494
  -152.799    58.429
>
  -153.408    59.350
  -152.799    58.429
>
  -153.408    59.350
  -152.799    58.429
>
  -153.357    59.370
  -152.799    58.429
>
  -153.357    59.370
  -152.799    58.429
>
  -153.431    59.360
  -152.799    58.429
>
  -153.445    59.363
  -152.799    58.429
>
  -153.445    59.363
  -152.799    58.429
>
  -154.182    56.560
  -154.501    56.288
>
  -154.182    56.560
  -154.501    56.288
>
  -154.182    56.560
  -154.501    56.288
>
  -155.620    55.822
  -154.501    56.288
>
  -155.620    55.822
  -154.501    56.288
>
  -154.347    58.597
  -153.917    58.328
>
  -154.347    58.597
  -153.917    58.328
>
  -154.546    58.494
  -153.917    58.328
>
  -154.546    58.494
  -153.917    58.328
>
  -154.703    58.498
  -153.917    58.328
>
  -154.799    58.384
  -153.917    58.328
>
  -154.799    58.384
  -153.917    58.328
>
  -155.061    58.297
  -153.917    58.328
>
  -155.061    58.297
  -153.917    58.328
>
  -153.645    58.929
  -153.917    58.328
>
  -153.645    58.929
  -153.917    58.328
>
  -155.161    58.134
  -153.917    58.328
>
  -155.282    58.270
  -153.917    58.328
>
  -155.282    58.270
  -153.917    58.328
>
  -155.326    58.211
  -153.917    58.328
>
  -155.326    58.211
  -153.917    58.328
>
  -155.301    58.053
  -153.917    58.328
>
  -155.494    58.199
  -153.917    58.328
>
  -152.583    57.783
  -153.917    58.328
>
  -152.583    57.783
  -153.917    58.328
>
  -152.583    57.783
  -153.917    58.328
>
  -152.583    57.783
  -153.917    58.328
>
  -155.573    58.054
  -153.917    58.328
>
  -154.182    56.560
  -154.955    56.553
>
  -154.182    56.560
  -154.955    56.553
>
  -154.182    56.560
  -154.955    56.553
>
  -155.620    55.822
  -154.955    56.553
>
  -155.620    55.822
  -154.955    56.553
>
  -155.620    55.822
  -154.955    56.553
>
  -154.182    56.560
  -153.798    56.247
>
  -154.182    56.560
  -153.798    56.247
>
  -154.182    56.560
  -153.798    56.247
>
  -154.182    56.560
  -153.797    56.180
>
  -156.360    57.631
  -155.175    57.328
>
  -156.360    57.631
  -155.175    57.328
>
  -155.301    58.053
  -155.175    57.328
>
  -155.301    58.053
  -155.175    57.328
>
  -155.573    58.054
  -155.175    57.328
>
  -155.161    58.134
  -155.175    57.328
>
  -155.161    58.134
  -155.175    57.328
>
  -155.326    58.211
  -155.175    57.328
>
  -155.326    58.211
  -155.175    57.328
>
  -155.494    58.199
  -155.175    57.328
>
  -155.494    58.199
  -155.175    57.328
>
  -156.607    57.802
  -155.175    57.328
>
  -156.607    57.802
  -155.175    57.328
>
  -155.282    58.270
  -155.175    57.328
>
  -155.282    58.270
  -155.175    57.328
>
  -155.061    58.297
  -155.175    57.328
>
  -155.061    58.297
  -155.175    57.328
>
  -156.819    57.700
  -155.175    57.328
>
  -156.819    57.700
  -155.175    57.328
>
  -154.182    56.560
  -155.175    57.328
>
  -154.182    56.560
  -155.175    57.328
>
  -154.182    56.560
  -155.175    57.328
>
  -154.182    56.560
  -153.668    56.277
>
  -154.182    56.560
  -153.668    56.277
>
  -153.288    57.222
  -153.668    56.277
>
  -153.288    57.222
  -153.668    56.277
>
  -153.288    57.222
  -153.668    56.277
>
  -153.288    57.222
  -153.847    57.511
>
  -153.288    57.222
  -153.847    57.511
>
  -152.583    57.783
  -153.847    57.511
>
  -152.583    57.783
  -153.847    57.511
>
  -155.161    58.134
  -153.847    57.511
>
  -155.301    58.053
  -153.847    57.511
>
  -154.182    56.560
  -153.847    57.511
>
  -154.182    56.560
  -153.847    57.511
>
  -153.288    57.222
  -154.190    57.099
>
  -153.288    57.222
  -154.190    57.099
>
  -154.182    56.560
  -154.190    57.099
>
  -154.182    56.560
  -154.190    57.099
>
  -152.583    57.783
  -153.202    57.641
>
  -152.583    57.783
  -153.202    57.641
>
  -153.288    57.222
  -153.202    57.641
>
  -153.288    57.222
  -153.202    57.641
>
  -154.182    56.560
  -153.081    56.221
>
  -154.182    56.560
  -153.081    56.221
>
  -155.301    58.053
  -154.931    57.838
>
  -155.161    58.134
  -154.931    57.838
>
  -155.161    58.134
  -154.931    57.838
>
  -155.573    58.054
  -154.931    57.838
>
  -155.573    58.054
  -154.931    57.838
>
  -155.326    58.211
  -154.931    57.838
>
  -155.326    58.211
  -154.931    57.838
>
  -155.494    58.199
  -154.931    57.838
>
  -155.061    58.297
  -154.931    57.838
>
  -155.061    58.297
  -154.931    57.838
>
  -155.282    58.270
  -154.931    57.838
>
  -155.282    58.270
  -154.931    57.838
>
  -154.799    58.384
  -154.931    57.838
>
  -154.799    58.384
  -154.931    57.838
>
  -155.887    58.264
  -154.931    57.838
>
  -155.887    58.264
  -154.931    57.838
>
  -154.703    58.498
  -154.931    57.838
>
  -154.703    58.498
  -154.931    57.838
>
  -154.546    58.494
  -154.931    57.838
>
  -156.324    57.764
  -154.931    57.838
>
  -156.360    57.631
  -154.931    57.838
>
  -156.360    57.631
  -154.931    57.838
>
  -155.009    58.648
  -154.931    57.838
>
  -155.009    58.648
  -154.931    57.838
>
  -154.347    58.597
  -154.931    57.838
>
  -156.607    57.802
  -154.931    57.838
>
  -156.607    57.802
  -154.931    57.838
>
  -154.799    58.384
  -154.586    58.124
>
  -154.799    58.384
  -154.586    58.124
>
  -155.161    58.134
  -154.586    58.124
>
  -155.161    58.134
  -154.586    58.124
>
  -155.061    58.297
  -154.586    58.124
>
  -155.301    58.053
  -154.586    58.124
>
  -154.546    58.494
  -154.586    58.124
>
  -154.546    58.494
  -154.586    58.124
>
  -154.703    58.498
  -154.586    58.124
>
  -154.703    58.498
  -154.586    58.124
>
  -155.282    58.270
  -154.586    58.124
>
  -155.282    58.270
  -154.586    58.124
>
  -155.494    58.199
  -154.586    58.124
>
  -154.347    58.597
  -154.586    58.124
>
  -154.347    58.597
  -154.586    58.124
>
  -155.009    58.648
  -154.586    58.124
>
  -153.645    58.929
  -154.586    58.124
>
  -153.645    58.929
  -154.586    58.124
>
  -156.324    57.764
  -154.586    58.124
>
  -156.324    57.764
  -154.586    58.124
>
  -152.583    57.783
  -151.503    58.268
>
  -152.583    57.783
  -151.503    58.268
>
  -152.583    57.783
  -153.609    57.830
>
  -152.583    57.783
  -153.609    57.830
>
  -152.583    57.783
  -153.609    57.830
>
  -152.583    57.783
  -153.609    57.830
>
  -152.583    57.783
  -153.609    57.830
>
  -153.288    57.222
  -153.609    57.830
>
  -153.288    57.222
  -153.609    57.830
>
  -154.546    58.494
  -153.609    57.830
>
  -154.799    58.384
  -153.609    57.830
>
  -154.799    58.384
  -153.609    57.830
>
  -155.161    58.134
  -153.609    57.830
>
  -154.703    58.498
  -153.609    57.830
>
  -154.703    58.498
  -153.609    57.830
>
  -155.061    58.297
  -153.609    57.830
>
  -155.061    58.297
  -153.609    57.830
>
  -155.326    58.211
  -153.609    57.830
>
  -155.326    58.211
  -153.609    57.830
>
  -155.282    58.270
  -153.609    57.830
>
  -152.583    57.783
  -153.502    58.082
>
  -152.583    57.783
  -153.502    58.082
>
  -154.546    58.494
  -153.502    58.082
>
  -154.546    58.494
  -153.502    58.082
>
  -154.799    58.384
  -153.502    58.082
>
  -154.799    58.384
  -153.502    58.082
>
  -154.703    58.498
  -153.502    58.082
>
  -153.288    57.222
  -153.502    58.082
>
  -153.288    57.222
  -153.502    58.082
>
  -155.061    58.297
  -153.502    58.082
>
  -155.061    58.297
  -153.502    58.082
>
  -153.645    58.929
  -153.502    58.082
>
  -153.645    58.929
  -153.502    58.082
>
  -155.161    58.134
  -153.502    58.082
>
  -155.282    58.270
  -153.502    58.082
>
  -155.326    58.211
  -153.502    58.082
>
  -155.326    58.211
  -153.502    58.082
>
  -155.009    58.648
  -153.502    58.082
>
  -155.009    58.648
  -153.502    58.082
>
  -154.546    58.494
  -153.956    58.651
>
  -154.546    58.494
  -153.956    58.651
>
  -153.645    58.929
  -153.956    58.651
>
  -153.645    58.929
  -153.956    58.651
>
  -154.703    58.498
  -153.956    58.651
>
  -154.703    58.498
  -153.956    58.651
>
  -154.799    58.384
  -153.956    58.651
>
  -154.799    58.384
  -153.956    58.651
>
  -155.009    58.648
  -153.956    58.651
>
  -155.009    58.648
  -153.956    58.651
>
  -155.061    58.297
  -153.956    58.651
>
  -155.061    58.297
  -153.956    58.651
>
  -153.427    59.335
  -153.956    58.651
>
  -153.427    59.335
  -153.956    58.651
>
  -155.282    58.270
  -153.956    58.651
>
  -153.408    59.350
  -153.956    58.651
>
  -153.408    59.350
  -153.956    58.651
>
  -153.431    59.360
  -153.956    58.651
>
  -153.445    59.363
  -153.956    58.651
>
  -153.445    59.363
  -153.956    58.651
>
  -153.471    59.370
  -153.956    58.651
>
  -155.161    58.134
  -153.956    58.651
>
  -153.357    59.370
  -153.956    58.651
>
  -155.326    58.211
  -153.956    58.651
>
  -155.494    58.199
  -153.956    58.651
>
  -155.229    59.392
  -153.956    58.651
>
  -155.229    59.392
  -153.956    58.651
>
  -155.301    58.053
  -154.811    57.454
>
  -155.161    58.134
  -154.811    57.454
>
  -155.161    58.134
  -154.811    57.454
>
  -155.573    58.054
  -154.811    57.454
>
  -155.326    58.211
  -154.811    57.454
>
  -155.326    58.211
  -154.811    57.454
>
  -155.494    58.199
  -154.811    57.454
>
  -153.288    57.222
  -154.811    57.454
>
  -153.288    57.222
  -154.811    57.454
>
  -156.360    57.631
  -154.811    57.454
>
  -155.061    58.297
  -154.811    57.454
>
  -155.061    58.297
  -154.811    57.454
>
  -155.282    58.270
  -154.811    57.454
>
  -155.282    58.270
  -154.811    57.454
>
  -154.799    58.384
  -154.811    57.454
>
  -154.799    58.384
  -154.811    57.454
>
  -154.182    56.560
  -154.811    57.454
>
  -155.887    58.264
  -154.811    57.454
>
  -154.182    56.560
  -154.615    56.273
>
  -154.182    56.560
  -154.615    56.273
>
  -154.182    56.560
  -154.615    56.273
>
  -154.182    56.560
  -154.615    56.273
>
  -155.620    55.822
  -154.615    56.273
>
  -155.620    55.822
  -154.615    56.273
>
  -155.620    55.822
  -154.615    56.273
>
  -155.620    55.822
  -154.615    56.273
>
  -155.161    58.134
  -154.825    57.451
>
  -155.326    58.211
  -154.825    57.451
>
  -155.326    58.211
  -154.825    57.451
>
  -155.494    58.199
  -154.825    57.451
>
  -153.288    57.222
  -154.825    57.451
>
  -153.288    57.222
  -154.825    57.451
>
  -155.061    58.297
  -154.825    57.451
>
  -155.061    58.297
  -154.825    57.451
>
  -155.282    58.270
  -154.825    57.451
>
  -156.360    57.631
  -154.825    57.451
>
  -154.799    58.384
  -154.825    57.451
>
  -154.799    58.384
  -154.825    57.451
>
  -154.182    56.560
  -154.825    57.451
>
  -154.182    56.560
  -154.825    57.451
>
  -155.887    58.264
  -154.825    57.451
>
  -154.546    58.494
  -154.039    58.087
>
  -154.546    58.494
  -154.039    58.087
>
  -154.799    58.384
  -154.039    58.087
>
  -154.799    58.384
  -154.039    58.087
>
  -154.969    58.131
  -154.039    58.087
>
  -154.703    58.498
  -154.039    58.087
>
  -155.061    58.297
  -154.039    58.087
>
  -155.061    58.297
  -154.039    58.087
>
  -155.161    58.134
  -154.039    58.087
>
  -155.282    58.270
  -154.039    58.087
>
  -155.009    58.648
  -154.039    58.087
>
  -152.583    57.783
  -154.039    58.087
>
  -152.583    57.783
  -154.039    58.087
>
  -153.645    58.929
  -154.039    58.087
>
  -153.288    57.222
  -154.039    58.087
>
  -153.288    57.222
  -154.039    58.087
>
  -155.161    58.134
  -155.112    58.183
>
  -155.161    58.134
  -155.112    58.183
>
  -154.969    58.131
  -155.112    58.183
>
  -154.969    58.131
  -155.112    58.183
>
  -155.282    58.270
  -155.112    58.183
>
  -155.282    58.270
  -155.112    58.183
>
  -155.061    58.297
  -155.112    58.183
>
  -155.061    58.297
  -155.112    58.183
>
  -154.799    58.384
  -155.112    58.183
>
  -154.799    58.384
  -155.112    58.183
>
  -154.703    58.498
  -155.112    58.183
>
  -154.703    58.498
  -155.112    58.183
>
  -154.546    58.494
  -155.112    58.183
>
  -154.546    58.494
  -155.112    58.183
>
  -155.009    58.648
  -155.112    58.183
>
  -155.009    58.648
  -155.112    58.183
>
  -154.347    58.597
  -155.112    58.183
>
  -156.324    57.764
  -155.112    58.183
>
  -156.324    57.764
  -155.112    58.183
>
  -156.267    57.689
  -155.112    58.183
>
  -156.267    57.689
  -155.112    58.183
>
  -156.360    57.631
  -155.112    58.183
>
  -156.360    57.631
  -155.112    58.183
>
  -156.607    57.802
  -155.112    58.183
>
  -156.607    57.802
  -155.112    58.183
>
  -156.878    57.998
  -155.112    58.183
>
  -156.878    57.998
  -155.112    58.183
>
  -153.288    57.222
  -154.408    57.335
>
  -153.288    57.222
  -154.408    57.335
>
  -154.182    56.560
  -154.408    57.335
>
  -154.182    56.560
  -154.408    57.335
>
  -154.969    58.131
  -154.408    57.335
>
  -154.969    58.131
  -154.408    57.335
>
  -155.161    58.134
  -154.408    57.335
>
  -153.288    57.222
  -153.846    57.659
>
  -153.288    57.222
  -153.846    57.659
>
  -152.583    57.783
  -153.846    57.659
>
  -152.583    57.783
  -153.846    57.659
>
  -152.583    57.783
  -153.846    57.659
>
  -152.583    57.783
  -153.846    57.659
>
  -154.976    58.131
  -153.846    57.659
>
  -154.976    58.131
  -153.846    57.659
>
  -155.023    58.198
  -153.846    57.659
>
  -155.023    58.198
  -153.846    57.659
>
  -155.161    58.134
  -153.846    57.659
>
  -154.799    58.384
  -153.846    57.659
>
  -154.799    58.384
  -153.846    57.659
>
  -155.061    58.297
  -153.846    57.659
>
  -154.546    58.494
  -153.846    57.659
>
  -154.703    58.498
  -153.846    57.659
>
  -155.282    58.270
  -153.846    57.659
>
  -156.360    57.631
  -155.489    57.031
>
  -156.360    57.631
  -155.489    57.031
>
  -154.182    56.560
  -155.489    57.031
>
  -154.182    56.560
  -155.489    57.031
>
  -156.607    57.802
  -155.489    57.031
>
  -156.607    57.802
  -155.489    57.031
>
  -156.819    57.700
  -155.489    57.031
>
  -153.645    58.929
  -153.496    58.607
>
  -153.645    58.929
  -153.496    58.607
>
  -153.428    59.333
  -153.496    58.607
>
  -153.428    59.333
  -153.496    58.607
>
  -153.408    59.350
  -153.496    58.607
>
  -153.408    59.350
  -153.496    58.607
>
  -153.461    59.359
  -153.496    58.607
>
  -153.461    59.359
  -153.496    58.607
>
  -153.357    59.370
  -153.496    58.607
>
  -153.357    59.370
  -153.496    58.607
>
  -153.451    59.404
  -153.496    58.607
>
  -155.061    58.297
  -153.496    58.607
>
  -155.061    58.297
  -153.496    58.607
>
  -155.023    58.198
  -153.496    58.607
>
  -155.023    58.198
  -153.496    58.607
>
  -154.976    58.131
  -153.496    58.607
>
  -154.976    58.131
  -153.496    58.607
>
  -152.583    57.783
  -153.496    58.607
>
  -152.583    57.783
  -153.496    58.607
>
  -152.583    57.783
  -153.496    58.607
>
  -155.161    58.134
  -153.496    58.607
>
  -155.282    58.270
  -153.496    58.607
>
  -155.282    58.270
  -153.496    58.607
>
  -154.182    56.560
  -155.057    57.137
>
  -154.182    56.560
  -155.057    57.137
>
  -154.182    56.560
  -155.057    57.137
>
  -156.267    57.689
  -155.057    57.137
>
  -156.267    57.689
  -155.057    57.137
>
  -156.360    57.631
  -155.057    57.137
>
  -156.360    57.631
  -155.057    57.137
>
  -154.976    58.131
  -155.057    57.137
>
  -154.976    58.131
  -155.057    57.137
>
  -153.288    57.222
  -155.057    57.137
>
  -153.288    57.222
  -155.057    57.137
>
  -153.288    57.222
  -155.057    57.137
>
  -154.182    56.560
  -155.077    57.127
>
  -154.182    56.560
  -155.077    57.127
>
  -156.267    57.689
  -155.077    57.127
>
  -156.267    57.689
  -155.077    57.127
>
  -156.360    57.631
  -155.077    57.127
>
  -156.360    57.631
  -155.077    57.127
>
  -153.288    57.222
  -155.077    57.127
>
  -153.288    57.222
  -155.077    57.127
>
  -153.645    58.929
  -153.540    58.578
>
  -154.546    58.494
  -153.540    58.578
>
  -154.546    58.494
  -153.540    58.578
>
  -154.703    58.498
  -153.540    58.578
>
  -154.799    58.384
  -153.540    58.578
>
  -155.009    58.648
  -153.540    58.578
>
  -155.009    58.648
  -153.540    58.578
>
  -153.428    59.333
  -153.540    58.578
>
  -153.428    59.333
  -153.540    58.578
>
  -153.408    59.350
  -153.540    58.578
>
  -153.408    59.350
  -153.540    58.578
>
  -153.461    59.359
  -153.540    58.578
>
  -153.519    59.377
  -153.540    58.578
>
  -153.357    59.370
  -153.540    58.578
>
  -153.357    59.370
  -153.540    58.578
>
  -153.451    59.404
  -153.540    58.578
>
  -152.583    57.783
  -153.540    58.578
>
  -154.976    58.131
  -154.885    57.653
>
  -154.976    58.131
  -154.885    57.653
>
  -155.161    58.134
  -154.885    57.653
>
  -155.161    58.134
  -154.885    57.653
>
  -155.023    58.198
  -154.885    57.653
>
  -155.023    58.198
  -154.885    57.653
>
  -155.061    58.297
  -154.885    57.653
>
  -155.282    58.270
  -154.885    57.653
>
  -154.799    58.384
  -154.885    57.653
>
  -154.799    58.384
  -154.885    57.653
>
  -154.703    58.498
  -154.885    57.653
>
  -154.703    58.498
  -154.885    57.653
>
  -154.546    58.494
  -154.885    57.653
>
  -153.288    57.222
  -154.885    57.653
>
  -153.288    57.222
  -154.885    57.653
>
  -152.583    57.783
  -151.717    58.289
>
  -152.583    57.783
  -151.717    58.289
>
  -152.583    57.783
  -151.717    58.289
>
  -152.583    57.783
  -151.717    58.289
>
  -154.182    56.560
  -154.806    57.189
>
  -154.182    56.560
  -154.806    57.189
>
  -154.182    56.560
  -154.806    57.189
>
  -153.288    57.222
  -154.806    57.189
>
  -153.288    57.222
  -154.806    57.189
>
  -153.288    57.222
  -154.806    57.189
>
  -156.267    57.689
  -154.806    57.189
>
  -154.546    58.494
  -154.203    58.258
>
  -154.546    58.494
  -154.203    58.258
>
  -154.799    58.384
  -154.203    58.258
>
  -154.799    58.384
  -154.203    58.258
>
  -154.703    58.498
  -154.203    58.258
>
  -154.703    58.498
  -154.203    58.258
>
  -154.976    58.131
  -154.203    58.258
>
  -154.976    58.131
  -154.203    58.258
>
  -155.023    58.198
  -154.203    58.258
>
  -155.023    58.198
  -154.203    58.258
>
  -155.061    58.297
  -154.203    58.258
>
  -155.061    58.297
  -154.203    58.258
>
  -155.161    58.134
  -154.203    58.258
>
  -155.282    58.270
  -154.203    58.258
>
  -155.282    58.270
  -154.203    58.258
>
  -155.009    58.648
  -154.203    58.258
>
  -155.009    58.648
  -154.203    58.258
>
  -154.452    57.567
  -154.203    58.258
>
  -154.452    57.567
  -154.203    58.258
>
  -153.645    58.929
  -154.203    58.258
>
  -153.645    58.929
  -154.203    58.258
>
  -152.583    57.783
  -154.203    58.258
>
  -152.583    57.783
  -154.203    58.258
>
  -152.583    57.783
  -154.203    58.258
>
  -152.583    57.783
  -154.203    58.258
>
  -152.583    57.783
  -154.203    58.258
>
  -154.546    58.494
  -153.757    58.248
>
  -154.546    58.494
  -153.757    58.248
>
  -154.703    58.498
  -153.757    58.248
>
  -154.799    58.384
  -153.757    58.248
>
  -154.799    58.384
  -153.757    58.248
>
  -154.976    58.131
  -153.757    58.248
>
  -154.976    58.131
  -153.757    58.248
>
  -155.023    58.198
  -153.757    58.248
>
  -155.023    58.198
  -153.757    58.248
>
  -155.061    58.297
  -153.757    58.248
>
  -155.061    58.297
  -153.757    58.248
>
  -153.645    58.929
  -153.757    58.248
>
  -153.645    58.929
  -153.757    58.248
>
  -155.161    58.134
  -153.757    58.248
>
  -155.161    58.134
  -153.757    58.248
>
  -154.452    57.567
  -153.757    58.248
>
  -154.452    57.567
  -153.757    58.248
>
  -152.583    57.783
  -153.757    58.248
>
  -152.583    57.783
  -153.757    58.248
>
  -155.009    58.648
  -153.757    58.248
>
  -155.009    58.648
  -153.757    58.248
>
  -155.282    58.270
  -153.757    58.248
>
  -154.182    56.560
  -154.314    56.477
>
  -154.182    56.560
  -154.314    56.477
>
  -154.182    56.560
  -154.314    56.477
>
  -153.288    57.222
  -154.314    56.477
>
  -153.288    57.222
  -154.314    56.477
>
  -153.288    57.222
  -154.314    56.477
>
  -155.620    55.822
  -154.314    56.477
>
  -155.620    55.822
  -154.314    56.477
>
  -152.583    57.783
  -151.788    57.995
>
  -152.583    57.783
  -151.788    57.995
>
  -152.583    57.783
  -151.788    57.995
>
  -153.645    58.929
  -153.172    58.442
>
  -153.645    58.929
  -153.172    58.442
>
  -152.583    57.783
  -153.172    58.442
>
  -152.583    57.783
  -153.172    58.442
>
  -152.583    57.783
  -153.172    58.442
>
  -154.546    58.494
  -153.172    58.442
>
  -154.546    58.494
  -153.172    58.442
>
  -154.703    58.498
  -153.172    58.442
>
  -154.703    58.498
  -153.172    58.442
>
  -154.799    58.384
  -153.172    58.442
>
  -153.428    59.333
  -153.172    58.442
>
  -153.428    59.333
  -153.172    58.442
>
  -153.408    59.350
  -153.172    58.442
>
  -153.461    59.359
  -153.172    58.442
>
  -153.461    59.359
  -153.172    58.442
>
  -153.445    59.363
  -153.172    58.442
>
  -153.519    59.377
  -153.172    58.442
>
  -153.519    59.377
  -153.172    58.442
>
  -155.009    58.648
  -153.172    58.442
>
  -155.009    58.648
  -153.172    58.442
>
  -155.301    58.053
  -155.272    57.945
>
  -155.301    58.053
  -155.272    57.945
>
  -155.573    58.054
  -155.272    57.945
>
  -155.573    58.054
  -155.272    57.945
>
  -155.161    58.134
  -155.272    57.945
>
  -155.161    58.134
  -155.272    57.945
>
  -154.976    58.131
  -155.272    57.945
>
  -154.976    58.131
  -155.272    57.945
>
  -155.494    58.199
  -155.272    57.945
>
  -155.494    58.199
  -155.272    57.945
>
  -155.023    58.198
  -155.272    57.945
>
  -155.023    58.198
  -155.272    57.945
>
  -155.282    58.270
  -155.272    57.945
>
  -155.061    58.297
  -155.272    57.945
>
  -155.887    58.264
  -155.272    57.945
>
  -155.887    58.264
  -155.272    57.945
>
  -154.799    58.384
  -155.272    57.945
>
  -154.799    58.384
  -155.272    57.945
>
  -154.452    57.567
  -155.272    57.945
>
  -154.452    57.567
  -155.272    57.945
>
  -156.267    57.689
  -155.272    57.945
>
  -156.324    57.764
  -155.272    57.945
>
  -156.324    57.764
  -155.272    57.945
>
  -154.703    58.498
  -155.272    57.945
>
  -154.703    58.498
  -155.272    57.945
>
  -156.360    57.631
  -155.272    57.945
>
  -154.546    58.494
  -155.272    57.945
>
  -156.607    57.802
  -155.272    57.945
>
  -155.009    58.648
  -155.272    57.945
>
  -155.009    58.648
  -155.272    57.945
>
  -156.878    57.998
  -155.272    57.945
>
  -156.819    57.700
  -155.272    57.945
>
  -156.819    57.700
  -155.272    57.945
>
  -155.282    58.270
  -155.338    58.478
>
  -155.282    58.270
  -155.338    58.478
>
  -155.202    58.275
  -155.338    58.478
>
  -155.202    58.275
  -155.338    58.478
>
  -155.061    58.297
  -155.338    58.478
>
  -155.061    58.297
  -155.338    58.478
>
  -155.009    58.648
  -155.338    58.478
>
  -155.009    58.648
  -155.338    58.478
>
  -155.494    58.199
  -155.338    58.478
>
  -155.494    58.199
  -155.338    58.478
>
  -154.799    58.384
  -155.338    58.478
>
  -154.799    58.384
  -155.338    58.478
>
  -155.023    58.198
  -155.338    58.478
>
  -154.703    58.498
  -155.338    58.478
>
  -154.703    58.498
  -155.338    58.478
>
  -155.161    58.134
  -155.338    58.478
>
  -155.887    58.264
  -155.338    58.478
>
  -155.887    58.264
  -155.338    58.478
>
  -154.976    58.131
  -155.338    58.478
>
  -154.546    58.494
  -155.338    58.478
>
  -154.546    58.494
  -155.338    58.478
>
  -155.301    58.053
  -155.338    58.478
>
  -155.301    58.053
  -155.338    58.478
>
  -155.573    58.054
  -155.338    58.478
>
  -154.347    58.597
  -155.338    58.478
>
  -154.347    58.597
  -155.338    58.478
>
  -156.324    57.764
  -155.338    58.478
>
  -156.324    57.764
  -155.338    58.478
>
  -155.229    59.392
  -155.338    58.478
>
  -155.229    59.392
  -155.338    58.478
>
  -156.439    59.195
  -155.338    58.478
>
  -156.439    59.195
  -155.338    58.478
>
  -156.267    57.689
  -155.338    58.478
>
  -156.878    57.998
  -155.338    58.478
>
  -156.878    57.998
  -155.338    58.478
>
  -156.607    57.802
  -155.338    58.478
>
  -156.607    57.802
  -155.338    58.478
>
  -153.645    58.929
  -155.338    58.478
>
  -153.645    58.929
  -155.338    58.478
>
  -154.976    58.131
  -154.421    58.081
>
  -154.976    58.131
  -154.421    58.081
>
  -155.023    58.198
  -154.421    58.081
>
  -155.023    58.198
  -154.421    58.081
>
  -155.161    58.134
  -154.421    58.081
>
  -155.161    58.134
  -154.421    58.081
>
  -155.061    58.297
  -154.421    58.081
>
  -155.061    58.297
  -154.421    58.081
>
  -154.546    58.494
  -154.421    58.081
>
  -154.546    58.494
  -154.421    58.081
>
  -154.703    58.498
  -154.421    58.081
>
  -155.202    58.275
  -154.421    58.081
>
  -155.301    58.053
  -154.421    58.081
>
  -155.301    58.053
  -154.421    58.081
>
  -155.282    58.270
  -154.421    58.081
>
  -154.347    58.597
  -154.421    58.081
>
  -154.452    57.567
  -154.421    58.081
>
  -155.494    58.199
  -154.421    58.081
>
  -155.573    58.054
  -154.421    58.081
>
  -155.573    58.054
  -154.421    58.081
>
  -155.009    58.648
  -154.421    58.081
>
  -155.887    58.264
  -154.421    58.081
>
  -153.645    58.929
  -154.421    58.081
>
  -154.976    58.131
  -154.416    58.085
>
  -154.976    58.131
  -154.416    58.085
>
  -155.023    58.198
  -154.416    58.085
>
  -155.023    58.198
  -154.416    58.085
>
  -154.799    58.384
  -154.416    58.085
>
  -154.799    58.384
  -154.416    58.085
>
  -155.061    58.297
  -154.416    58.085
>
  -155.061    58.297
  -154.416    58.085
>
  -155.161    58.134
  -154.416    58.085
>
  -155.161    58.134
  -154.416    58.085
>
  -154.546    58.494
  -154.416    58.085
>
  -154.546    58.494
  -154.416    58.085
>
  -154.703    58.498
  -154.416    58.085
>
  -155.202    58.275
  -154.416    58.085
>
  -155.301    58.053
  -154.416    58.085
>
  -155.301    58.053
  -154.416    58.085
>
  -155.282    58.270
  -154.416    58.085
>
  -154.452    57.567
  -154.416    58.085
>
  -154.452    57.567
  -154.416    58.085
>
  -155.494    58.199
  -154.416    58.085
>
  -155.009    58.648
  -154.416    58.085
>
  -155.887    58.264
  -154.416    58.085
>
  -153.645    58.929
  -154.416    58.085
>
  -153.645    58.929
  -154.416    58.085
>
  -153.645    58.929
  -153.162    58.737
>
  -153.645    58.929
  -153.162    58.737
>
  -152.394    58.610
  -153.162    58.737
>
  -152.394    58.610
  -153.162    58.737
>
  -153.428    59.333
  -153.162    58.737
>
  -153.428    59.333
  -153.162    58.737
>
  -153.408    59.350
  -153.162    58.737
>
  -153.408    59.350
  -153.162    58.737
>
  -153.461    59.359
  -153.162    58.737
>
  -153.461    59.359
  -153.162    58.737
>
  -153.519    59.377
  -153.162    58.737
>
  -153.519    59.377
  -153.162    58.737
>
  -153.451    59.404
  -153.162    58.737
>
  -154.546    58.494
  -153.162    58.737
>
  -154.546    58.494
  -153.162    58.737
>
  -155.009    58.648
  -153.162    58.737
>
  -154.703    58.498
  -154.729    58.476
>
  -154.703    58.498
  -154.729    58.476
>
  -154.546    58.494
  -154.729    58.476
>
  -154.546    58.494
  -154.729    58.476
>
  -154.799    58.384
  -154.729    58.476
>
  -154.799    58.384
  -154.729    58.476
>
  -154.347    58.597
  -154.729    58.476
>
  -154.347    58.597
  -154.729    58.476
>
  -155.009    58.648
  -154.729    58.476
>
  -155.009    58.648
  -154.729    58.476
>
  -155.061    58.297
  -154.729    58.476
>
  -155.061    58.297
  -154.729    58.476
>
  -155.023    58.198
  -154.729    58.476
>
  -155.023    58.198
  -154.729    58.476
>
  -155.202    58.275
  -154.729    58.476
>
  -155.202    58.275
  -154.729    58.476
>
  -154.976    58.131
  -154.729    58.476
>
  -154.976    58.131
  -154.729    58.476
>
  -155.282    58.270
  -154.729    58.476
>
  -155.282    58.270
  -154.729    58.476
>
  -155.161    58.134
  -154.729    58.476
>
  -155.161    58.134
  -154.729    58.476
>
  -155.301    58.053
  -154.729    58.476
>
  -155.301    58.053
  -154.729    58.476
>
  -155.573    58.054
  -154.729    58.476
>
  -155.573    58.054
  -154.729    58.476
>
  -155.887    58.264
  -154.729    58.476
>
  -155.887    58.264
  -154.729    58.476
>
  -153.645    58.929
  -154.729    58.476
>
  -153.645    58.929
  -154.729    58.476
>
  -154.452    57.567
  -154.729    58.476
>
  -154.452    57.567
  -154.729    58.476
>
  -155.229    59.392
  -154.729    58.476
>
  -155.229    59.392
  -154.729    58.476
>
  -153.288    57.222
  -153.137    56.786
>
  -154.452    57.567
  -154.950    57.269
>
  -155.301    58.053
  -154.950    57.269
>
  -155.301    58.053
  -154.950    57.269
>
  -156.267    57.689
  -154.950    57.269
>
  -156.267    57.689
  -154.950    57.269
>
  -156.360    57.631
  -154.950    57.269
>
  -156.360    57.631
  -154.950    57.269
>
  -155.573    58.054
  -154.950    57.269
>
  -155.573    58.054
  -154.950    57.269
>
  -154.976    58.131
  -154.950    57.269
>
  -154.976    58.131
  -154.950    57.269
>
  -155.161    58.134
  -154.950    57.269
>
  -155.161    58.134
  -154.950    57.269
>
  -156.324    57.764
  -154.950    57.269
>
  -156.324    57.764
  -154.950    57.269
>
  -155.023    58.198
  -154.950    57.269
>
  -155.023    58.198
  -154.950    57.269
>
  -155.573    58.054
  -155.277    57.776
>
  -155.573    58.054
  -155.277    57.776
>
  -155.161    58.134
  -155.277    57.776
>
  -154.452    57.567
  -155.277    57.776
>
  -154.452    57.567
  -155.277    57.776
>
  -154.976    58.131
  -155.277    57.776
>
  -154.976    58.131
  -155.277    57.776
>
  -155.023    58.198
  -155.277    57.776
>
  -155.023    58.198
  -155.277    57.776
>
  -156.267    57.689
  -155.277    57.776
>
  -156.267    57.689
  -155.277    57.776
>
  -155.282    58.270
  -155.277    57.776
>
  -155.282    58.270
  -155.277    57.776
>
  -155.202    58.275
  -155.277    57.776
>
  -156.324    57.764
  -155.277    57.776
>
  -156.324    57.764
  -155.277    57.776
>
  -155.061    58.297
  -155.277    57.776
>
  -154.799    58.384
  -155.277    57.776
>
  -154.799    58.384
  -155.277    57.776
>
  -156.607    57.802
  -155.277    57.776
>
  -154.703    58.498
  -155.277    57.776
>
  -154.703    58.498
  -155.277    57.776
>
  -154.546    58.494
  -155.277    57.776
>
  -154.546    58.494
  -155.277    57.776
>
  -155.009    58.648
  -155.277    57.776
>
  -155.009    58.648
  -155.277    57.776
>
  -154.347    58.597
  -155.277    57.776
>
  -153.645    58.929
  -153.734    58.780
>
  -154.347    58.597
  -153.734    58.780
>
  -154.347    58.597
  -153.734    58.780
>
  -154.546    58.494
  -153.734    58.780
>
  -154.546    58.494
  -153.734    58.780
>
  -153.428    59.333
  -153.734    58.780
>
  -153.428    59.333
  -153.734    58.780
>
  -153.408    59.350
  -153.734    58.780
>
  -153.408    59.350
  -153.734    58.780
>
  -153.461    59.359
  -153.734    58.780
>
  -153.461    59.359
  -153.734    58.780
>
  -154.703    58.498
  -153.734    58.780
>
  -154.799    58.384
  -153.734    58.780
>
  -154.799    58.384
  -153.734    58.780
>
  -155.009    58.648
  -153.734    58.780
>
  -155.009    58.648
  -153.734    58.780
>
  -155.061    58.297
  -153.734    58.780
>
  -155.061    58.297
  -153.734    58.780
>
  -153.232    59.652
  -153.734    58.780
>
  -153.232    59.652
  -153.734    58.780
>
  -155.229    59.392
  -153.734    58.780
>
  -155.229    59.392
  -153.734    58.780
>
  -153.645    58.929
  -152.561    58.610
>
  -153.428    59.333
  -152.561    58.610
>
  -153.428    59.333
  -152.561    58.610
>
  -153.428    59.333
  -152.561    58.610
>
  -153.428    59.333
  -152.561    58.610
>
  -153.408    59.350
  -152.561    58.610
>
  -153.408    59.350
  -152.561    58.610
>
  -153.408    59.350
  -152.561    58.610
>
  -153.357    59.370
  -152.561    58.610
>
  -153.357    59.370
  -152.561    58.610
>
  -153.461    59.359
  -152.561    58.610
>
  -153.461    59.359
  -152.561    58.610
>
  -153.519    59.377
  -152.561    58.610
>
  -153.519    59.377
  -152.561    58.610
>
  -153.519    59.377
  -152.561    58.610
>
  -152.583    57.783
  -152.561    58.610
>
  -152.583    57.783
  -152.561    58.610
>
  -152.583    57.783
  -152.561    58.610
>
  -152.583    57.783
  -152.561    58.610
>
  -152.583    57.783
  -152.561    58.610
>
  -152.394    58.610
  -151.722    58.206
>
  -152.583    57.783
  -151.722    58.206
>
  -152.583    57.783
  -151.722    58.206
>
  -152.583    57.783
  -151.722    58.206
>
  -153.645    58.929
  -154.523    58.549
>
  -153.645    58.929
  -154.523    58.549
>
  -155.229    59.392
  -154.523    58.549
>
  -155.229    59.392
  -154.523    58.549
>
  -153.428    59.333
  -154.523    58.549
>
  -153.461    59.359
  -154.523    58.549
>
  -153.461    59.359
  -154.523    58.549
>
  -153.519    59.377
  -154.523    58.549
>
  -153.519    59.377
  -154.523    58.549
>
  -153.408    59.350
  -154.523    58.549
>
  -153.408    59.350
  -154.523    58.549
>
  -154.452    57.567
  -154.523    58.549
>
  -153.471    59.370
  -154.523    58.549
>
  -153.471    59.370
  -154.523    58.549
>
  -153.645    58.929
  -154.161    58.721
>
  -153.645    58.929
  -154.161    58.721
>
  -153.428    59.333
  -154.161    58.721
>
  -153.428    59.333
  -154.161    58.721
>
  -153.461    59.359
  -154.161    58.721
>
  -153.461    59.359
  -154.161    58.721
>
  -153.519    59.377
  -154.161    58.721
>
  -153.519    59.377
  -154.161    58.721
>
  -155.229    59.392
  -154.161    58.721
>
  -155.229    59.392
  -154.161    58.721
>
  -152.394    58.610
  -154.161    58.721
>
  -152.394    58.610
  -154.161    58.721
>
  -154.452    57.567
  -155.360    58.158
>
  -153.288    57.222
  -153.535    57.321
>
  -153.288    57.222
  -153.535    57.321
>
  -152.583    57.783
  -153.535    57.321
>
  -152.583    57.783
  -153.535    57.321
>
  -152.583    57.783
  -153.535    57.321
>
  -153.288    57.222
  -154.400    57.061
>
  -153.288    57.222
  -154.400    57.061
>
  -153.288    57.222
  -154.170    57.349
>
  -153.288    57.222
  -154.170    57.349
>
  -154.976    58.131
  -154.170    57.349
>
  -154.976    58.131
  -154.170    57.349
>
  -152.583    57.783
  -154.170    57.349
>
  -152.583    57.783
  -154.170    57.349
>
  -152.583    57.783
  -154.170    57.349
>
  -152.583    57.783
  -154.170    57.349
>
  -155.023    58.198
  -154.170    57.349
>
  -155.023    58.198
  -154.170    57.349
>
  -152.394    58.610
  -152.534    58.684
>
  -152.394    58.610
  -152.534    58.684
>
  -153.645    58.929
  -152.534    58.684
>
  -153.645    58.929
  -152.534    58.684
>
  -153.428    59.333
  -152.534    58.684
>
  -153.428    59.333
  -152.534    58.684
>
  -153.408    59.350
  -152.534    58.684
>
  -153.408    59.350
  -152.534    58.684
>
  -153.445    59.363
  -152.534    58.684
>
  -153.461    59.359
  -152.534    58.684
>
  -153.461    59.359
  -152.534    58.684
>
  -152.583    57.783
  -152.534    58.684
>
  -152.583    57.783
  -152.534    58.684
>
  -152.583    57.783
  -152.534    58.684
>
  -153.519    59.377
  -152.534    58.684
>
  -154.976    58.131
  -153.970    57.961
>
  -154.976    58.131
  -153.970    57.961
>
  -154.546    58.494
  -153.970    57.961
>
  -154.546    58.494
  -153.970    57.961
>
  -154.799    58.384
  -153.970    57.961
>
  -155.023    58.198
  -153.970    57.961
>
  -155.023    58.198
  -153.970    57.961
>
  -154.347    58.597
  -153.970    57.961
>
  -154.347    58.597
  -153.970    57.961
>
  -154.703    58.498
  -153.970    57.961
>
  -155.061    58.297
  -153.970    57.961
>
  -152.583    57.783
  -153.970    57.961
>
  -152.583    57.783
  -153.970    57.961
>
  -152.583    57.783
  -153.970    57.961
>
  -155.282    58.270
  -153.970    57.961
>
  -153.288    57.222
  -153.970    57.961
>
  -153.288    57.222
  -153.970    57.961
>
  -155.009    58.648
  -153.970    57.961
>
  -155.009    58.648
  -153.970    57.961
>
  -153.645    58.929
  -153.970    57.961
>
  -153.645    58.929
  -153.970    57.961
>
  -154.347    58.597
  -153.714    58.535
>
  -154.347    58.597
  -153.714    58.535
>
  -153.645    58.929
  -153.714    58.535
>
  -154.546    58.494
  -153.714    58.535
>
  -154.546    58.494
  -153.714    58.535
>
  -154.703    58.498
  -153.714    58.535
>
  -154.703    58.498
  -153.714    58.535
>
  -154.799    58.384
  -153.714    58.535
>
  -154.799    58.384
  -153.714    58.535
>
  -155.009    58.648
  -153.714    58.535
>
  -155.009    58.648
  -153.714    58.535
>
  -152.394    58.610
  -153.714    58.535
>
  -152.394    58.610
  -153.714    58.535
>
  -155.061    58.297
  -153.714    58.535
>
  -155.061    58.297
  -153.714    58.535
>
  -155.023    58.198
  -153.714    58.535
>
  -155.023    58.198
  -153.714    58.535
>
  -154.976    58.131
  -153.714    58.535
>
  -154.976    58.131
  -153.714    58.535
>
  -155.202    58.275
  -153.714    58.535
>
  -153.428    59.333
  -153.714    58.535
>
  -153.428    59.333
  -153.714    58.535
>
  -155.282    58.270
  -153.714    58.535
>
  -153.408    59.350
  -153.714    58.535
>
  -153.408    59.350
  -153.714    58.535
>
  -153.461    59.359
  -153.714    58.535
>
  -153.461    59.359
  -153.714    58.535
>
  -153.445    59.363
  -153.714    58.535
>
  -153.471    59.370
  -153.714    58.535
>
  -153.471    59.370
  -153.714    58.535
>
  -153.519    59.377
  -153.714    58.535
>
  -153.357    59.370
  -153.714    58.535
>
  -153.435    59.382
  -153.714    58.535
>
  -152.583    57.783
  -153.714    58.535
>
  -154.347    58.597
  -153.716    58.344
>
  -154.347    58.597
  -153.716    58.344
>
  -154.546    58.494
  -153.716    58.344
>
  -154.546    58.494
  -153.716    58.344
>
  -154.703    58.498
  -153.716    58.344
>
  -154.799    58.384
  -153.716    58.344
>
  -154.799    58.384
  -153.716    58.344
>
  -153.645    58.929
  -153.716    58.344
>
  -154.976    58.131
  -153.716    58.344
>
  -154.976    58.131
  -153.716    58.344
>
  -155.023    58.198
  -153.716    58.344
>
  -155.061    58.297
  -153.716    58.344
>
  -155.061    58.297
  -153.716    58.344
>
  -155.009    58.648
  -153.716    58.344
>
  -155.009    58.648
  -153.716    58.344
>
  -152.394    58.610
  -153.716    58.344
>
  -155.202    58.275
  -153.716    58.344
>
  -155.282    58.270
  -153.716    58.344
>
  -155.282    58.270
  -153.716    58.344
>
  -152.583    57.783
  -153.716    58.344
>
  -152.583    57.783
  -153.716    58.344
>
  -154.452    57.567
  -153.716    58.344
>
  -154.452    57.567
  -153.716    58.344
>
  -155.301    58.053
  -153.716    58.344
>
  -155.301    58.053
  -153.716    58.344
>
  -152.394    58.610
  -151.887    58.342
>
  -152.394    58.610
  -151.887    58.342
>
  -152.583    57.783
  -151.887    58.342
>
  -152.583    57.783
  -151.887    58.342
>
  -154.976    58.131
  -154.542    58.136
>
  -154.976    58.131
  -154.542    58.136
>
  -155.023    58.198
  -154.542    58.136
>
  -155.023    58.198
  -154.542    58.136
>
  -154.799    58.384
  -154.542    58.136
>
  -154.799    58.384
  -154.542    58.136
>
  -155.061    58.297
  -154.542    58.136
>
  -155.061    58.297
  -154.542    58.136
>
  -154.546    58.494
  -154.542    58.136
>
  -154.546    58.494
  -154.542    58.136
>
  -155.202    58.275
  -154.542    58.136
>
  -154.703    58.498
  -154.542    58.136
>
  -155.301    58.053
  -154.542    58.136
>
  -155.301    58.053
  -154.542    58.136
>
  -155.282    58.270
  -154.542    58.136
>
  -155.282    58.270
  -154.542    58.136
>
  -154.347    58.597
  -154.542    58.136
>
  -155.573    58.054
  -154.542    58.136
>
  -155.573    58.054
  -154.542    58.136
>
  -154.452    57.567
  -154.542    58.136
>
  -154.452    57.567
  -154.542    58.136
>
  -155.009    58.648
  -154.542    58.136
>
  -155.009    58.648
  -154.542    58.136
>
  -153.645    58.929
  -154.542    58.136
>
  -153.645    58.929
  -154.542    58.136
>
  -154.452    57.567
  -155.188    57.531
>
  -154.452    57.567
  -155.188    57.531
>
  -156.267    57.689
  -155.188    57.531
>
  -156.267    57.689
  -155.188    57.531
>
  -156.324    57.764
  -155.188    57.531
>
  -156.324    57.764
  -155.188    57.531
>
  -156.607    57.802
  -155.188    57.531
>
  -156.607    57.802
  -155.188    57.531
>
  -154.452    57.567
  -154.882    57.227
>
  -154.452    57.567
  -154.882    57.227
>
  -153.288    57.222
  -154.882    57.227
>
  -153.288    57.222
  -154.882    57.227
>
  -153.645    58.929
  -153.358    58.515
>
  -153.645    58.929
  -153.358    58.515
>
  -154.347    58.597
  -153.358    58.515
>
  -154.347    58.597
  -153.358    58.515
>
  -154.546    58.494
  -153.358    58.515
>
  -154.546    58.494
  -153.358    58.515
>
  -154.703    58.498
  -153.358    58.515
>
  -154.703    58.498
  -153.358    58.515
>
  -152.583    57.783
  -153.358    58.515
>
  -152.583    57.783
  -153.358    58.515
>
  -153.428    59.333
  -153.358    58.515
>
  -153.428    59.333
  -153.358    58.515
>
  -153.408    59.350
  -153.358    58.515
>
  -153.408    59.350
  -153.358    58.515
>
  -153.461    59.359
  -153.358    58.515
>
  -153.461    59.359
  -153.358    58.515
>
  -153.445    59.363
  -153.358    58.515
>
  -153.445    59.363
  -153.358    58.515
>
  -153.519    59.377
  -153.358    58.515
>
  -153.519    59.377
  -153.358    58.515
>
  -155.009    58.648
  -153.358    58.515
>
  -155.009    58.648
  -153.358    58.515
>
  -153.451    59.404
  -153.358    58.515
>
  -155.061    58.297
  -153.358    58.515
>
  -154.976    58.131
  -153.358    58.515
>
  -154.976    58.131
  -153.358    58.515
>
  -155.023    58.198
  -153.358    58.515
>
  -155.023    58.198
  -153.358    58.515
>
  -154.452    57.567
  -153.874    57.752
>
  -154.452    57.567
  -153.874    57.752
>
  -154.976    58.131
  -153.874    57.752
>
  -154.976    58.131
  -153.874    57.752
>
  -152.583    57.783
  -153.874    57.752
>
  -152.583    57.783
  -153.874    57.752
>
  -152.583    57.783
  -153.874    57.752
>
  -152.583    57.783
  -153.874    57.752
>
  -155.161    58.134
  -153.874    57.752
>
  -155.161    58.134
  -153.874    57.752
>
  -155.161    58.134
  -153.874    57.752
>
  -154.799    58.384
  -153.874    57.752
>
  -154.799    58.384
  -153.874    57.752
>
  -154.799    58.384
  -153.874    57.752
>
  -155.301    58.053
  -153.874    57.752
>
  -155.301    58.053
  -153.874    57.752
>
  -155.301    58.053
  -153.874    57.752
>
  -154.546    58.494
  -153.874    57.752
>
  -154.546    58.494
  -153.874    57.752
>
  -155.061    58.297
  -153.874    57.752
>
  -155.061    58.297
  -153.874    57.752
>
  -154.703    58.498
  -153.874    57.752
>
  -154.347    58.597
  -153.874    57.752
>
  -155.282    58.270
  -153.874    57.752
>
  -155.573    58.054
  -153.874    57.752
>
  -155.573    58.054
  -153.874    57.752
>
  -152.583    57.783
  -152.819    57.709
>
  -152.583    57.783
  -152.819    57.709
>
  -153.288    57.222
  -152.819    57.709
>
  -153.288    57.222
  -152.819    57.709
>
  -154.452    57.567
  -152.819    57.709
>
  -154.452    57.567
  -152.819    57.709
>
  -152.394    58.610
  -152.819    57.709
>
  -152.394    58.610
  -152.819    57.709
>
  -154.452    57.567
  -153.979    57.741
>
  -154.452    57.567
  -153.979    57.741
>
  -153.288    57.222
  -153.979    57.741
>
  -153.288    57.222
  -153.979    57.741
>
  -152.583    57.783
  -153.979    57.741
>
  -152.583    57.783
  -153.979    57.741
>
  -152.583    57.783
  -153.979    57.741
>
  -152.583    57.783
  -153.979    57.741
>
  -155.161    58.134
  -153.979    57.741
>
  -155.161    58.134
  -153.979    57.741
>
  -154.799    58.384
  -153.979    57.741
>
  -154.799    58.384
  -153.979    57.741
>
  -154.799    58.384
  -153.979    57.741
>
  -155.301    58.053
  -153.979    57.741
>
  -155.301    58.053
  -153.979    57.741
>
  -155.301    58.053
  -153.979    57.741
>
  -155.061    58.297
  -153.979    57.741
>
  -155.061    58.297
  -153.979    57.741
>
  -154.703    58.498
  -153.979    57.741
>
  -154.703    58.498
  -153.979    57.741
>
  -154.347    58.597
  -153.979    57.741
>
  -154.347    58.597
  -153.979    57.741
>
  -155.282    58.270
  -153.979    57.741
>
  -155.282    58.270
  -153.979    57.741
>
  -155.573    58.054
  -153.979    57.741
>
  -155.573    58.054
  -153.979    57.741
>
  -155.494    58.199
  -153.979    57.741
>
  -152.583    57.783
  -153.531    58.123
>
  -152.583    57.783
  -153.531    58.123
>
  -152.583    57.783
  -153.531    58.123
>
  -152.583    57.783
  -153.531    58.123
>
  -154.347    58.597
  -153.531    58.123
>
  -154.347    58.597
  -153.531    58.123
>
  -154.546    58.494
  -153.531    58.123
>
  -152.394    58.610
  -153.531    58.123
>
  -152.394    58.610
  -153.531    58.123
>
  -154.799    58.384
  -153.531    58.123
>
  -154.799    58.384
  -153.531    58.123
>
  -154.703    58.498
  -153.531    58.123
>
  -154.452    57.567
  -153.531    58.123
>
  -154.452    57.567
  -153.531    58.123
>
  -153.645    58.929
  -153.531    58.123
>
  -153.645    58.929
  -153.531    58.123
>
  -155.023    58.198
  -153.531    58.123
>
  -155.023    58.198
  -153.531    58.123
>
  -155.061    58.297
  -153.531    58.123
>
  -155.061    58.297
  -153.531    58.123
>
  -155.161    58.134
  -153.531    58.123
>
  -155.161    58.134
  -153.531    58.123
>
  -153.288    57.222
  -153.531    58.123
>
  -153.288    57.222
  -153.531    58.123
>
  -155.202    58.275
  -153.531    58.123
>
  -155.009    58.648
  -153.531    58.123
>
  -155.009    58.648
  -153.531    58.123
>
  -155.282    58.270
  -153.531    58.123
>
  -155.301    58.053
  -153.531    58.123
>
  -155.301    58.053
  -153.531    58.123
>
  -153.645    58.929
  -153.641    58.626
>
  -153.645    58.929
  -153.641    58.626
>
  -154.347    58.597
  -153.641    58.626
>
  -154.347    58.597
  -153.641    58.626
>
  -154.546    58.494
  -153.641    58.626
>
  -154.546    58.494
  -153.641    58.626
>
  -154.703    58.498
  -153.641    58.626
>
  -154.703    58.498
  -153.641    58.626
>
  -154.799    58.384
  -153.641    58.626
>
  -154.799    58.384
  -153.641    58.626
>
  -152.394    58.610
  -153.641    58.626
>
  -152.394    58.610
  -153.641    58.626
>
  -155.009    58.648
  -153.641    58.626
>
  -155.009    58.648
  -153.641    58.626
>
  -153.408    59.350
  -153.641    58.626
>
  -153.471    59.370
  -153.641    58.626
>
  -155.061    58.297
  -153.641    58.626
>
  -155.061    58.297
  -153.641    58.626
>
  -155.023    58.198
  -153.641    58.626
>
  -155.023    58.198
  -153.641    58.626
>
  -154.976    58.131
  -153.641    58.626
>
  -155.202    58.275
  -153.641    58.626
>
  -155.202    58.275
  -153.641    58.626
>
  -155.282    58.270
  -153.641    58.626
>
  -155.161    58.134
  -153.641    58.626
>
  -153.645    58.929
  -153.322    58.541
>
  -153.645    58.929
  -153.322    58.541
>
  -152.394    58.610
  -153.322    58.541
>
  -152.394    58.610
  -153.322    58.541
>
  -154.347    58.597
  -153.322    58.541
>
  -154.347    58.597
  -153.322    58.541
>
  -154.546    58.494
  -153.322    58.541
>
  -154.546    58.494
  -153.322    58.541
>
  -154.703    58.498
  -153.322    58.541
>
  -154.703    58.498
  -153.322    58.541
>
  -154.799    58.384
  -153.322    58.541
>
  -153.428    59.333
  -153.322    58.541
>
  -153.428    59.333
  -153.322    58.541
>
  -153.408    59.350
  -153.322    58.541
>
  -153.408    59.350
  -153.322    58.541
>
  -152.583    57.783
  -153.322    58.541
>
  -152.583    57.783
  -153.322    58.541
>
  -153.461    59.359
  -153.322    58.541
>
  -153.461    59.359
  -153.322    58.541
>
  -153.445    59.363
  -153.322    58.541
>
  -153.357    59.370
  -153.322    58.541
>
  -153.357    59.370
  -153.322    58.541
>
  -153.471    59.370
  -153.322    58.541
>
  -153.471    59.370
  -153.322    58.541
>
  -153.519    59.377
  -153.322    58.541
>
  -153.519    59.377
  -153.322    58.541
>
  -155.009    58.648
  -153.322    58.541
>
  -155.061    58.297
  -153.322    58.541
>
  -154.976    58.131
  -153.322    58.541
>
  -155.061    58.297
  -155.073    58.290
>
  -155.023    58.198
  -155.073    58.290
>
  -155.202    58.275
  -155.073    58.290
>
  -155.202    58.275
  -155.073    58.290
>
  -155.282    58.270
  -155.073    58.290
>
  -155.282    58.270
  -155.073    58.290
>
  -154.976    58.131
  -155.073    58.290
>
  -154.976    58.131
  -155.073    58.290
>
  -155.161    58.134
  -155.073    58.290
>
  -155.161    58.134
  -155.073    58.290
>
  -154.799    58.384
  -155.073    58.290
>
  -154.799    58.384
  -155.073    58.290
>
  -155.494    58.199
  -155.073    58.290
>
  -155.494    58.199
  -155.073    58.290
>
  -155.301    58.053
  -155.073    58.290
>
  -155.301    58.053
  -155.073    58.290
>
  -154.703    58.498
  -155.073    58.290
>
  -154.703    58.498
  -155.073    58.290
>
  -154.546    58.494
  -155.073    58.290
>
  -154.546    58.494
  -155.073    58.290
>
  -155.573    58.054
  -155.073    58.290
>
  -155.009    58.648
  -155.073    58.290
>
  -155.009    58.648
  -155.073    58.290
>
  -155.009    58.648
  -155.073    58.290
>
  -154.347    58.597
  -155.073    58.290
>
  -154.452    57.567
  -155.073    58.290
>
  -154.452    57.567
  -155.073    58.290
>
  -156.324    57.764
  -155.073    58.290
>
  -156.267    57.689
  -155.073    58.290
>
  -156.267    57.689
  -155.073    58.290
>
  -156.360    57.631
  -155.073    58.290
>
  -156.360    57.631
  -155.073    58.290
>
  -156.607    57.802
  -155.073    58.290
>
  -156.607    57.802
  -155.073    58.290
>
  -152.394    58.610
  -153.250    58.508
>
  -152.394    58.610
  -153.250    58.508
>
  -153.645    58.929
  -153.250    58.508
>
  -153.645    58.929
  -153.250    58.508
>
  -154.347    58.597
  -153.250    58.508
>
  -154.347    58.597
  -153.250    58.508
>
  -154.546    58.494
  -153.250    58.508
>
  -154.546    58.494
  -153.250    58.508
>
  -152.583    57.783
  -153.250    58.508
>
  -152.583    57.783
  -153.250    58.508
>
  -154.703    58.498
  -153.250    58.508
>
  -154.703    58.498
  -153.250    58.508
>
  -154.799    58.384
  -153.250    58.508
>
  -154.799    58.384
  -153.250    58.508
>
  -153.428    59.333
  -153.250    58.508
>
  -153.428    59.333
  -153.250    58.508
>
  -153.408    59.350
  -153.250    58.508
>
  -153.408    59.350
  -153.250    58.508
>
  -153.461    59.359
  -153.250    58.508
>
  -153.461    59.359
  -153.250    58.508
>
  -153.445    59.363
  -153.250    58.508
>
  -153.445    59.363
  -153.250    58.508
>
  -153.357    59.370
  -153.250    58.508
>
  -153.471    59.370
  -153.250    58.508
>
  -155.009    58.648
  -153.250    58.508
>
  -155.009    58.648
  -153.250    58.508
>
  -154.976    58.131
  -153.250    58.508
>
  -155.061    58.297
  -153.250    58.508
>
  -153.288    57.222
  -154.185    57.493
>
  -153.288    57.222
  -154.185    57.493
>
  -154.976    58.131
  -154.185    57.493
>
  -154.976    58.131
  -154.185    57.493
>
  -155.301    58.053
  -154.185    57.493
>
  -155.301    58.053
  -154.185    57.493
>
  -155.161    58.134
  -154.185    57.493
>
  -155.161    58.134
  -154.185    57.493
>
  -155.023    58.198
  -154.185    57.493
>
  -152.583    57.783
  -154.185    57.493
>
  -152.583    57.783
  -154.185    57.493
>
  -152.583    57.783
  -154.185    57.493
>
  -155.061    58.297
  -154.185    57.493
>
  -155.061    58.297
  -154.185    57.493
>
  -155.573    58.054
  -154.185    57.493
>
  -155.573    58.054
  -154.185    57.493
>
  -154.799    58.384
  -154.185    57.493
>
  -154.799    58.384
  -154.185    57.493
>
  -155.202    58.275
  -154.185    57.493
>
  -154.182    56.560
  -154.185    57.493
>
  -154.182    56.560
  -154.185    57.493
>
  -155.282    58.270
  -154.185    57.493
>
  -155.494    58.199
  -154.185    57.493
>
  -155.494    58.199
  -154.185    57.493
>
  -154.347    58.597
  -154.064    58.642
>
  -154.347    58.597
  -154.064    58.642
>
  -154.546    58.494
  -154.064    58.642
>
  -154.546    58.494
  -154.064    58.642
>
  -154.703    58.498
  -154.064    58.642
>
  -153.645    58.929
  -154.064    58.642
>
  -153.645    58.929
  -154.064    58.642
>
  -154.799    58.384
  -154.064    58.642
>
  -154.799    58.384
  -154.064    58.642
>
  -155.009    58.648
  -154.064    58.642
>
  -155.009    58.648
  -154.064    58.642
>
  -155.061    58.297
  -154.064    58.642
>
  -155.061    58.297
  -154.064    58.642
>
  -155.023    58.198
  -154.064    58.642
>
  -155.202    58.275
  -154.064    58.642
>
  -154.976    58.131
  -154.064    58.642
>
  -154.976    58.131
  -154.064    58.642
>
  -155.282    58.270
  -154.064    58.642
>
  -155.161    58.134
  -154.064    58.642
>
  -155.161    58.134
  -154.064    58.642
>
  -153.428    59.333
  -154.064    58.642
>
  -153.428    59.333
  -154.064    58.642
>
  -153.408    59.350
  -154.064    58.642
>
  -153.461    59.359
  -154.064    58.642
>
  -153.357    59.370
  -154.064    58.642
>
  -155.494    58.199
  -154.064    58.642
>
  -155.494    58.199
  -154.064    58.642
>
  -155.301    58.053
  -154.064    58.642
>
  -155.301    58.053
  -154.064    58.642
>
  -155.229    59.392
  -154.064    58.642
>
  -155.229    59.392
  -154.064    58.642
>
  -155.573    58.054
  -154.064    58.642
>
  -155.282    58.270
  -155.775    58.405
>
  -155.282    58.270
  -155.775    58.405
>
  -155.202    58.275
  -155.775    58.405
>
  -155.061    58.297
  -155.775    58.405
>
  -155.161    58.134
  -155.775    58.405
>
  -155.161    58.134
  -155.775    58.405
>
  -155.023    58.198
  -155.775    58.405
>
  -155.009    58.648
  -155.775    58.405
>
  -155.009    58.648
  -155.775    58.405
>
  -154.976    58.131
  -155.775    58.405
>
  -154.799    58.384
  -155.775    58.405
>
  -154.799    58.384
  -155.775    58.405
>
  -154.703    58.498
  -155.775    58.405
>
  -154.546    58.494
  -155.775    58.405
>
  -154.546    58.494
  -155.775    58.405
>
  -156.324    57.764
  -155.775    58.405
>
  -156.324    57.764
  -155.775    58.405
>
  -156.878    57.998
  -155.775    58.405
>
  -156.878    57.998
  -155.775    58.405
>
  -156.607    57.802
  -155.775    58.405
>
  -156.607    57.802
  -155.775    58.405
>
  -154.347    58.597
  -155.775    58.405
>
  -154.347    58.597
  -155.775    58.405
>
  -156.267    57.689
  -155.775    58.405
>
  -156.267    57.689
  -155.775    58.405
>
  -156.439    59.195
  -155.775    58.405
>
  -156.360    57.631
  -155.775    58.405
>
  -156.360    57.631
  -155.775    58.405
>
  -156.819    57.700
  -155.775    58.405
>
  -153.288    57.222
  -153.879    57.737
>
  -153.288    57.222
  -153.879    57.737
>
  -152.583    57.783
  -153.879    57.737
>
  -152.583    57.783
  -153.879    57.737
>
  -154.976    58.131
  -153.879    57.737
>
  -154.976    58.131
  -153.879    57.737
>
  -155.023    58.198
  -153.879    57.737
>
  -155.161    58.134
  -153.879    57.737
>
  -155.301    58.053
  -153.879    57.737
>
  -154.799    58.384
  -153.879    57.737
>
  -155.061    58.297
  -153.879    57.737
>
  -155.061    58.297
  -153.879    57.737
>
  -154.546    58.494
  -153.879    57.737
>
  -154.703    58.498
  -153.879    57.737
>
  -155.202    58.275
  -153.879    57.737
>
  -155.573    58.054
  -153.879    57.737
>
  -155.494    58.199
  -153.879    57.737
>
  -155.202    58.275
  -155.199    58.242
>
  -155.202    58.275
  -155.199    58.242
>
  -155.282    58.270
  -155.199    58.242
>
  -155.282    58.270
  -155.199    58.242
>
  -155.061    58.297
  -155.199    58.242
>
  -155.061    58.297
  -155.199    58.242
>
  -155.061    58.297
  -155.199    58.242
>
  -155.023    58.198
  -155.199    58.242
>
  -155.161    58.134
  -155.199    58.242
>
  -154.976    58.131
  -155.199    58.242
>
  -155.494    58.199
  -155.199    58.242
>
  -155.494    58.199
  -155.199    58.242
>
  -155.301    58.053
  -155.199    58.242
>
  -155.301    58.053
  -155.199    58.242
>
  -155.301    58.053
  -155.199    58.242
>
  -154.799    58.384
  -155.199    58.242
>
  -154.799    58.384
  -155.199    58.242
>
  -154.799    58.384
  -155.199    58.242
>
  -155.573    58.054
  -155.199    58.242
>
  -155.573    58.054
  -155.199    58.242
>
  -154.703    58.498
  -155.199    58.242
>
  -154.703    58.498
  -155.199    58.242
>
  -154.546    58.494
  -155.199    58.242
>
  -154.546    58.494
  -155.199    58.242
>
  -154.546    58.494
  -155.199    58.242
>
  -154.347    58.597
  -155.199    58.242
>
  -154.347    58.597
  -155.199    58.242
>
  -156.324    57.764
  -155.199    58.242
>
  -156.324    57.764
  -155.199    58.242
>
  -156.267    57.689
  -155.199    58.242
>
  -156.607    57.802
  -155.199    58.242
>
  -156.607    57.802
  -155.199    58.242
>
  -156.360    57.631
  -155.199    58.242
>
  -156.878    57.998
  -155.199    58.242
>
  -156.878    57.998
  -155.199    58.242
>
  -156.878    57.998
  -155.199    58.242
>
  -152.583    57.783
  -153.198    57.586
>
  -152.583    57.783
  -153.198    57.586
>
  -152.583    57.783
  -153.198    57.586
>
  -156.267    57.689
  -154.888    57.503
>
  -156.267    57.689
  -154.888    57.503
>
  -154.976    58.131
  -154.580    57.469
>
  -154.976    58.131
  -154.580    57.469
>
  -155.161    58.134
  -154.580    57.469
>
  -155.161    58.134
  -154.580    57.469
>
  -155.023    58.198
  -154.580    57.469
>
  -155.023    58.198
  -154.580    57.469
>
  -155.061    58.297
  -154.580    57.469
>
  -155.202    58.275
  -154.580    57.469
>
  -155.494    58.199
  -154.580    57.469
>
  -155.494    58.199
  -154.580    57.469
>
  -155.282    58.270
  -154.580    57.469
>
  -154.799    58.384
  -154.580    57.469
>
  -154.799    58.384
  -154.580    57.469
>
  -156.267    57.689
  -154.580    57.469
>
  -156.267    57.689
  -154.580    57.469
>
  -156.324    57.764
  -154.580    57.469
>
  -156.324    57.764
  -154.580    57.469
>
  -155.202    58.275
  -155.217    58.239
>
  -155.202    58.275
  -155.217    58.239
>
  -155.061    58.297
  -155.217    58.239
>
  -155.061    58.297
  -155.217    58.239
>
  -155.023    58.198
  -155.217    58.239
>
  -155.023    58.198
  -155.217    58.239
>
  -155.161    58.134
  -155.217    58.239
>
  -155.161    58.134
  -155.217    58.239
>
  -154.976    58.131
  -155.217    58.239
>
  -154.976    58.131
  -155.217    58.239
>
  -155.494    58.199
  -155.217    58.239
>
  -155.494    58.199
  -155.217    58.239
>
  -154.799    58.384
  -155.217    58.239
>
  -154.703    58.498
  -155.217    58.239
>
  -154.703    58.498
  -155.217    58.239
>
  -154.546    58.494
  -155.217    58.239
>
  -154.546    58.494
  -155.217    58.239
>
  -156.324    57.764
  -155.217    58.239
>
  -156.267    57.689
  -155.217    58.239
>
  -156.267    57.689
  -155.217    58.239
>
  -156.607    57.802
  -155.217    58.239
>
  -156.878    57.998
  -155.217    58.239
>
  -156.878    57.998
  -155.217    58.239
>
  -154.976    58.131
  -154.145    57.248
>
  -154.976    58.131
  -154.145    57.248
>
  -154.452    57.567
  -154.566    57.763
>
  -154.452    57.567
  -154.566    57.763
>
  -154.976    58.131
  -154.566    57.763
>
  -154.976    58.131
  -154.566    57.763
>
  -155.161    58.134
  -154.566    57.763
>
  -155.161    58.134
  -154.566    57.763
>
  -155.023    58.198
  -154.566    57.763
>
  -155.023    58.198
  -154.566    57.763
>
  -155.061    58.297
  -154.566    57.763
>
  -155.202    58.275
  -154.566    57.763
>
  -154.799    58.384
  -154.566    57.763
>
  -154.799    58.384
  -154.566    57.763
>
  -155.282    58.270
  -154.566    57.763
>
  -155.494    58.199
  -154.566    57.763
>
  -154.546    58.494
  -154.566    57.763
>
  -154.703    58.498
  -154.566    57.763
>
  -154.703    58.498
  -154.566    57.763
>
  -155.009    58.648
  -154.566    57.763
>
  -155.009    58.648
  -154.566    57.763
>
  -156.267    57.689
  -154.566    57.763
>
  -156.267    57.689
  -154.566    57.763
>
  -156.324    57.764
  -154.566    57.763
>
  -156.324    57.764
  -154.566    57.763
>
  -156.360    57.631
  -154.566    57.763
>
  -156.360    57.631
  -154.566    57.763
>
  -155.202    58.275
  -155.148    58.257
>
  -155.202    58.275
  -155.148    58.257
>
  -155.061    58.297
  -155.148    58.257
>
  -155.061    58.297
  -155.148    58.257
>
  -155.282    58.270
  -155.148    58.257
>
  -155.282    58.270
  -155.148    58.257
>
  -155.023    58.198
  -155.148    58.257
>
  -155.161    58.134
  -155.148    58.257
>
  -154.976    58.131
  -155.148    58.257
>
  -154.976    58.131
  -155.148    58.257
>
  -155.494    58.199
  -155.148    58.257
>
  -155.494    58.199
  -155.148    58.257
>
  -154.799    58.384
  -155.148    58.257
>
  -154.799    58.384
  -155.148    58.257
>
  -154.703    58.498
  -155.148    58.257
>
  -154.703    58.498
  -155.148    58.257
>
  -154.546    58.494
  -155.148    58.257
>
  -155.009    58.648
  -155.148    58.257
>
  -155.009    58.648
  -155.148    58.257
>
  -156.324    57.764
  -155.148    58.257
>
  -156.267    57.689
  -155.148    58.257
>
  -156.360    57.631
  -155.148    58.257
>
  -156.607    57.802
  -155.148    58.257
>
  -154.452    57.567
  -155.003    57.744
>
  -154.452    57.567
  -155.003    57.744
>
  -154.976    58.131
  -155.003    57.744
>
  -154.976    58.131
  -155.003    57.744
>
  -155.161    58.134
  -155.003    57.744
>
  -155.161    58.134
  -155.003    57.744
>
  -155.023    58.198
  -155.003    57.744
>
  -155.023    58.198
  -155.003    57.744
>
  -155.494    58.199
  -155.003    57.744
>
  -155.494    58.199
  -155.003    57.744
>
  -155.202    58.275
  -155.003    57.744
>
  -155.202    58.275
  -155.003    57.744
>
  -155.282    58.270
  -155.003    57.744
>
  -155.061    58.297
  -155.003    57.744
>
  -154.799    58.384
  -155.003    57.744
>
  -156.267    57.689
  -155.003    57.744
>
  -156.267    57.689
  -155.003    57.744
>
  -156.324    57.764
  -155.003    57.744
>
  -156.324    57.764
  -155.003    57.744
>
  -156.360    57.631
  -155.003    57.744
>
  -156.360    57.631
  -155.003    57.744
>
  -154.703    58.498
  -155.003    57.744
>
  -154.546    58.494
  -155.003    57.744
>
  -156.607    57.802
  -155.003    57.744
>
  -156.607    57.802
  -155.003    57.744
>
  -155.009    58.648
  -155.003    57.744
>
  -155.009    58.648
  -155.003    57.744
>
  -156.819    57.700
  -155.003    57.744
>
  -156.819    57.700
  -155.003    57.744
>
  -152.583    57.783
  -153.129    57.524
>
  -152.583    57.783
  -153.129    57.524
>
  -154.452    57.567
  -153.129    57.524
>
  -154.452    57.567
  -153.129    57.524
>
  -154.452    57.567
  -155.472    57.196
>
  -154.452    57.567
  -155.472    57.196
>
  -156.360    57.631
  -155.472    57.196
>
  -156.267    57.689
  -155.472    57.196
>
  -156.324    57.764
  -155.472    57.196
>
  -154.182    56.560
  -155.472    57.196
>
  -156.607    57.802
  -155.472    57.196
>
  -156.607    57.802
  -155.472    57.196
>
  -156.819    57.700
  -155.472    57.196
>
  -156.819    57.700
  -155.472    57.196
>
  -155.161    58.134
  -155.472    57.196
>
  -155.161    58.134
  -155.472    57.196
>
  -154.976    58.131
  -155.472    57.196
>
  -154.976    58.131
  -155.472    57.196
>
  -154.546    58.494
  -154.007    58.557
>
  -154.546    58.494
  -154.007    58.557
>
  -154.703    58.498
  -154.007    58.557
>
  -154.703    58.498
  -154.007    58.557
>
  -153.645    58.929
  -154.007    58.557
>
  -153.645    58.929
  -154.007    58.557
>
  -154.799    58.384
  -154.007    58.557
>
  -154.799    58.384
  -154.007    58.557
>
  -155.009    58.648
  -154.007    58.557
>
  -155.009    58.648
  -154.007    58.557
>
  -155.061    58.297
  -154.007    58.557
>
  -155.061    58.297
  -154.007    58.557
>
  -155.023    58.198
  -154.007    58.557
>
  -155.023    58.198
  -154.007    58.557
>
  -154.976    58.131
  -154.007    58.557
>
  -154.976    58.131
  -154.007    58.557
>
  -155.202    58.275
  -154.007    58.557
>
  -155.202    58.275
  -154.007    58.557
>
  -155.282    58.270
  -154.007    58.557
>
  -155.161    58.134
  -154.007    58.557
>
  -155.161    58.134
  -154.007    58.557
>
  -153.428    59.333
  -154.007    58.557
>
  -153.428    59.333
  -154.007    58.557
>
  -153.408    59.350
  -154.007    58.557
>
  -153.408    59.350
  -154.007    58.557
>
  -153.461    59.359
  -154.007    58.557
>
  -153.461    59.359
  -154.007    58.557
>
  -153.445    59.363
  -154.007    58.557
>
  -153.519    59.377
  -154.007    58.557
>
  -153.519    59.377
  -154.007    58.557
>
  -153.471    59.370
  -154.007    58.557
>
  -153.471    59.370
  -154.007    58.557
>
  -153.357    59.370
  -154.007    58.557
>
  -153.357    59.370
  -154.007    58.557
>
  -155.202    58.275
  -155.230    58.239
>
  -155.202    58.275
  -155.230    58.239
>
  -155.282    58.270
  -155.230    58.239
>
  -155.282    58.270
  -155.230    58.239
>
  -155.282    58.270
  -155.230    58.239
>
  -155.061    58.297
  -155.230    58.239
>
  -155.061    58.297
  -155.230    58.239
>
  -155.161    58.134
  -155.230    58.239
>
  -155.161    58.134
  -155.230    58.239
>
  -155.494    58.199
  -155.230    58.239
>
  -155.494    58.199
  -155.230    58.239
>
  -155.494    58.199
  -155.230    58.239
>
  -154.976    58.131
  -155.230    58.239
>
  -154.976    58.131
  -155.230    58.239
>
  -154.799    58.384
  -155.230    58.239
>
  -154.799    58.384
  -155.230    58.239
>
  -154.703    58.498
  -155.230    58.239
>
  -154.703    58.498
  -155.230    58.239
>
  -155.009    58.648
  -155.230    58.239
>
  -155.009    58.648
  -155.230    58.239
>
  -154.546    58.494
  -155.230    58.239
>
  -154.546    58.494
  -155.230    58.239
>
  -154.452    57.567
  -155.230    58.239
>
  -156.607    57.802
  -155.230    58.239
>
  -156.360    57.631
  -155.230    58.239
>
  -156.878    57.998
  -155.230    58.239
>
  -156.878    57.998
  -155.230    58.239
>
  -153.645    58.929
  -153.292    58.597
>
  -153.645    58.929
  -153.292    58.597
>
  -154.546    58.494
  -153.292    58.597
>
  -154.546    58.494
  -153.292    58.597
>
  -153.428    59.333
  -153.292    58.597
>
  -153.428    59.333
  -153.292    58.597
>
  -154.703    58.498
  -153.292    58.597
>
  -153.408    59.350
  -153.292    58.597
>
  -153.408    59.350
  -153.292    58.597
>
  -153.461    59.359
  -153.292    58.597
>
  -153.461    59.359
  -153.292    58.597
>
  -154.799    58.384
  -153.292    58.597
>
  -155.009    58.648
  -153.292    58.597
>
  -155.009    58.648
  -153.292    58.597
>
  -152.583    57.783
  -153.292    58.597
>
  -152.583    57.783
  -153.292    58.597
>
  -155.061    58.297
  -153.292    58.597
>
  -155.061    58.297
  -155.117    58.261
>
  -155.061    58.297
  -155.117    58.261
>
  -155.061    58.297
  -155.117    58.261
>
  -155.202    58.275
  -155.117    58.261
>
  -155.202    58.275
  -155.117    58.261
>
  -155.202    58.275
  -155.117    58.261
>
  -155.023    58.198
  -155.117    58.261
>
  -155.023    58.198
  -155.117    58.261
>
  -155.023    58.198
  -155.117    58.261
>
  -155.282    58.270
  -155.117    58.261
>
  -155.282    58.270
  -155.117    58.261
>
  -155.161    58.134
  -155.117    58.261
>
  -155.161    58.134
  -155.117    58.261
>
  -154.976    58.131
  -155.117    58.261
>
  -154.799    58.384
  -155.117    58.261
>
  -154.799    58.384
  -155.117    58.261
>
  -155.494    58.199
  -155.117    58.261
>
  -155.494    58.199
  -155.117    58.261
>
  -155.301    58.053
  -155.117    58.261
>
  -154.703    58.498
  -155.117    58.261
>
  -154.703    58.498
  -155.117    58.261
>
  -155.573    58.054
  -155.117    58.261
>
  -154.546    58.494
  -155.117    58.261
>
  -154.546    58.494
  -155.117    58.261
>
  -155.009    58.648
  -155.117    58.261
>
  -155.009    58.648
  -155.117    58.261
>
  -156.324    57.764
  -155.117    58.261
>
  -156.360    57.631
  -155.117    58.261
>
  -156.360    57.631
  -155.117    58.261
>
  -156.607    57.802
  -155.117    58.261
>
  -156.607    57.802
  -155.117    58.261
>
  -156.878    57.998
  -155.117    58.261
>
  -155.202    58.275
  -155.173    58.251
>
  -155.202    58.275
  -155.173    58.251
>
  -155.023    58.198
  -155.173    58.251
>
  -155.061    58.297
  -155.173    58.251
>
  -155.061    58.297
  -155.173    58.251
>
  -155.282    58.270
  -155.173    58.251
>
  -155.282    58.270
  -155.173    58.251
>
  -155.161    58.134
  -155.173    58.251
>
  -155.161    58.134
  -155.173    58.251
>
  -154.976    58.131
  -155.173    58.251
>
  -155.494    58.199
  -155.173    58.251
>
  -155.494    58.199
  -155.173    58.251
>
  -155.301    58.053
  -155.173    58.251
>
  -154.799    58.384
  -155.173    58.251
>
  -154.799    58.384
  -155.173    58.251
>
  -155.573    58.054
  -155.173    58.251
>
  -154.703    58.498
  -155.173    58.251
>
  -154.546    58.494
  -155.173    58.251
>
  -154.546    58.494
  -155.173    58.251
>
  -155.009    58.648
  -155.173    58.251
>
  -155.009    58.648
  -155.173    58.251
>
  -156.324    57.764
  -155.173    58.251
>
  -156.360    57.631
  -155.173    58.251
>
  -156.607    57.802
  -155.173    58.251
>
  -155.061    58.297
  -155.158    58.256
>
  -155.061    58.297
  -155.158    58.256
>
  -155.202    58.275
  -155.158    58.256
>
  -155.202    58.275
  -155.158    58.256
>
  -155.202    58.275
  -155.158    58.256
>
  -155.023    58.198
  -155.158    58.256
>
  -155.023    58.198
  -155.158    58.256
>
  -155.282    58.270
  -155.158    58.256
>
  -155.282    58.270
  -155.158    58.256
>
  -155.161    58.134
  -155.158    58.256
>
  -155.161    58.134
  -155.158    58.256
>
  -154.976    58.131
  -155.158    58.256
>
  -154.799    58.384
  -155.158    58.256
>
  -155.494    58.199
  -155.158    58.256
>
  -155.494    58.199
  -155.158    58.256
>
  -155.301    58.053
  -155.158    58.256
>
  -155.573    58.054
  -155.158    58.256
>
  -154.703    58.498
  -155.158    58.256
>
  -154.703    58.498
  -155.158    58.256
>
  -154.546    58.494
  -155.158    58.256
>
  -154.546    58.494
  -155.158    58.256
>
  -155.009    58.648
  -155.158    58.256
>
  -155.009    58.648
  -155.158    58.256
>
  -156.324    57.764
  -155.158    58.256
>
  -156.324    57.764
  -155.158    58.256
>
  -156.360    57.631
  -155.158    58.256
>
  -156.607    57.802
  -155.158    58.256
>
  -156.878    57.998
  -155.158    58.256
>
  -155.061    58.297
  -155.150    58.267
>
  -155.061    58.297
  -155.150    58.267
>
  -155.202    58.275
  -155.150    58.267
>
  -155.202    58.275
  -155.150    58.267
>
  -155.282    58.270
  -155.150    58.267
>
  -155.282    58.270
  -155.150    58.267
>
  -155.023    58.198
  -155.150    58.267
>
  -155.023    58.198
  -155.150    58.267
>
  -155.161    58.134
  -155.150    58.267
>
  -155.161    58.134
  -155.150    58.267
>
  -154.976    58.131
  -155.150    58.267
>
  -154.976    58.131
  -155.150    58.267
>
  -154.799    58.384
  -155.150    58.267
>
  -154.799    58.384
  -155.150    58.267
>
  -154.703    58.498
  -155.150    58.267
>
  -154.703    58.498
  -155.150    58.267
>
  -154.546    58.494
  -155.150    58.267
>
  -154.546    58.494
  -155.150    58.267
>
  -155.009    58.648
  -155.150    58.267
>
  -155.009    58.648
  -155.150    58.267
>
  -155.009    58.648
  -155.150    58.267
>
  -156.324    57.764
  -155.150    58.267
>
  -156.607    57.802
  -155.150    58.267
>
  -156.360    57.631
  -155.150    58.267
>
  -156.360    57.631
  -155.150    58.267
>
  -156.878    57.998
  -155.150    58.267
>
  -156.878    57.998
  -155.150    58.267
>
  -154.546    58.494
  -153.697    58.122
>
  -154.546    58.494
  -153.697    58.122
>
  -154.799    58.384
  -153.697    58.122
>
  -154.799    58.384
  -153.697    58.122
>
  -152.583    57.783
  -153.697    58.122
>
  -152.583    57.783
  -153.697    58.122
>
  -152.583    57.783
  -153.697    58.122
>
  -152.583    57.783
  -153.697    58.122
>
  -154.703    58.498
  -153.697    58.122
>
  -154.452    57.567
  -153.697    58.122
>
  -154.452    57.567
  -153.697    58.122
>
  -154.976    58.131
  -153.697    58.122
>
  -154.976    58.131
  -153.697    58.122
>
  -155.023    58.198
  -153.697    58.122
>
  -155.023    58.198
  -153.697    58.122
>
  -155.061    58.297
  -153.697    58.122
>
  -155.061    58.297
  -153.697    58.122
>
  -155.161    58.134
  -153.697    58.122
>
  -155.161    58.134
  -153.697    58.122
>
  -153.645    58.929
  -153.697    58.122
>
  -153.645    58.929
  -153.697    58.122
>
  -152.394    58.610
  -153.697    58.122
>
  -152.394    58.610
  -153.697    58.122
>
  -155.282    58.270
  -153.697    58.122
>
  -155.009    58.648
  -153.697    58.122
>
  -155.009    58.648
  -153.697    58.122
>
  -155.061    58.297
  -155.138    58.280
>
  -155.061    58.297
  -155.138    58.280
>
  -155.023    58.198
  -155.138    58.280
>
  -155.023    58.198
  -155.138    58.280
>
  -155.202    58.275
  -155.138    58.280
>
  -155.202    58.275
  -155.138    58.280
>
  -155.282    58.270
  -155.138    58.280
>
  -155.282    58.270
  -155.138    58.280
>
  -154.976    58.131
  -155.138    58.280
>
  -155.161    58.134
  -155.138    58.280
>
  -154.799    58.384
  -155.138    58.280
>
  -154.799    58.384
  -155.138    58.280
>
  -154.703    58.498
  -155.138    58.280
>
  -154.703    58.498
  -155.138    58.280
>
  -154.546    58.494
  -155.138    58.280
>
  -154.546    58.494
  -155.138    58.280
>
  -155.009    58.648
  -155.138    58.280
>
  -155.009    58.648
  -155.138    58.280
>
  -156.324    57.764
  -155.138    58.280
>
  -156.360    57.631
  -155.138    58.280
>
  -156.607    57.802
  -155.138    58.280
>
  -156.878    57.998
  -155.138    58.280
>
  -154.976    58.131
  -154.634    58.135
>
  -154.976    58.131
  -154.634    58.135
>
  -154.799    58.384
  -154.634    58.135
>
  -154.799    58.384
  -154.634    58.135
>
  -155.061    58.297
  -154.634    58.135
>
  -155.061    58.297
  -154.634    58.135
>
  -155.161    58.134
  -154.634    58.135
>
  -155.161    58.134
  -154.634    58.135
>
  -155.202    58.275
  -154.634    58.135
>
  -155.282    58.270
  -154.634    58.135
>
  -154.703    58.498
  -154.634    58.135
>
  -154.546    58.494
  -154.634    58.135
>
  -154.546    58.494
  -154.634    58.135
>
  -155.009    58.648
  -154.634    58.135
>
  -155.009    58.648
  -154.634    58.135
>
  -153.645    58.929
  -154.634    58.135
>
  -153.645    58.929
  -154.634    58.135
>
  -156.324    57.764
  -154.634    58.135
>
  -156.324    57.764
  -154.634    58.135
>
  -154.976    58.131
  -154.785    58.182
>
  -154.976    58.131
  -154.785    58.182
>
  -155.023    58.198
  -154.785    58.182
>
  -155.061    58.297
  -154.785    58.182
>
  -155.161    58.134
  -154.785    58.182
>
  -155.161    58.134
  -154.785    58.182
>
  -154.799    58.384
  -154.785    58.182
>
  -154.799    58.384
  -154.785    58.182
>
  -155.282    58.270
  -154.785    58.182
>
  -155.282    58.270
  -154.785    58.182
>
  -155.301    58.053
  -154.785    58.182
>
  -155.301    58.053
  -154.785    58.182
>
  -154.703    58.498
  -154.785    58.182
>
  -154.546    58.494
  -154.785    58.182
>
  -155.494    58.199
  -154.785    58.182
>
  -155.573    58.054
  -154.785    58.182
>
  -155.009    58.648
  -154.785    58.182
>
  -155.009    58.648
  -154.785    58.182
>
  -156.324    57.764
  -154.785    58.182
>
  -156.324    57.764
  -154.785    58.182
>
  -153.645    58.929
  -154.785    58.182
>
  -153.645    58.929
  -154.785    58.182
>
  -155.301    58.053
  -154.923    57.721
>
  -155.301    58.053
  -154.923    57.721
>
  -154.976    58.131
  -154.923    57.721
>
  -154.976    58.131
  -154.923    57.721
>
  -155.161    58.134
  -154.923    57.721
>
  -155.161    58.134
  -154.923    57.721
>
  -155.573    58.054
  -154.923    57.721
>
  -155.573    58.054
  -154.923    57.721
>
  -155.023    58.198
  -154.923    57.721
>
  -155.023    58.198
  -154.923    57.721
>
  -155.494    58.199
  -154.923    57.721
>
  -155.494    58.199
  -154.923    57.721
>
  -156.324    57.764
  -154.923    57.721
>
  -156.324    57.764
  -154.923    57.721
>
  -156.360    57.631
  -154.923    57.721
>
  -156.607    57.802
  -154.923    57.721
>
  -155.009    58.648
  -154.923    57.721
>
  -155.301    58.053
  -154.937    57.452
>
  -155.301    58.053
  -154.937    57.452
>
  -154.976    58.131
  -154.937    57.452
>
  -154.976    58.131
  -154.937    57.452
>
  -155.573    58.054
  -154.937    57.452
>
  -155.573    58.054
  -154.937    57.452
>
  -155.161    58.134
  -154.937    57.452
>
  -155.161    58.134
  -154.937    57.452
>
  -156.267    57.689
  -154.937    57.452
>
  -155.023    58.198
  -154.937    57.452
>
  -156.360    57.631
  -154.937    57.452
>
  -156.360    57.631
  -154.937    57.452
>
  -156.324    57.764
  -154.937    57.452
>
  -156.324    57.764
  -154.937    57.452
>
  -155.494    58.199
  -154.937    57.452
>
  -155.282    58.270
  -154.937    57.452
>
  -155.061    58.297
  -154.937    57.452
>
  -154.799    58.384
  -154.937    57.452
>
  -156.607    57.802
  -154.937    57.452
>
  -156.607    57.802
  -154.937    57.452
>
  -155.301    58.053
  -155.016    57.900
>
  -155.301    58.053
  -155.016    57.900
>
  -154.976    58.131
  -155.016    57.900
>
  -154.976    58.131
  -155.016    57.900
>
  -155.161    58.134
  -155.016    57.900
>
  -155.161    58.134
  -155.016    57.900
>
  -155.023    58.198
  -155.016    57.900
>
  -155.023    58.198
  -155.016    57.900
>
  -155.573    58.054
  -155.016    57.900
>
  -155.573    58.054
  -155.016    57.900
>
  -155.202    58.275
  -155.016    57.900
>
  -155.494    58.199
  -155.016    57.900
>
  -155.061    58.297
  -155.016    57.900
>
  -155.282    58.270
  -155.016    57.900
>
  -154.799    58.384
  -155.016    57.900
>
  -154.703    58.498
  -155.016    57.900
>
  -154.546    58.494
  -155.016    57.900
>
  -156.324    57.764
  -155.016    57.900
>
  -156.324    57.764
  -155.016    57.900
>
  -155.009    58.648
  -155.016    57.900
>
  -155.009    58.648
  -155.016    57.900
>
  -156.360    57.631
  -155.016    57.900
>
  -156.360    57.631
  -155.016    57.900
>
  -156.607    57.802
  -155.016    57.900
>
  -156.607    57.802
  -155.016    57.900
>
  -156.819    57.700
  -155.016    57.900
>
  -156.819    57.700
  -155.016    57.900
>
  -156.878    57.998
  -155.016    57.900
>
  -156.878    57.998
  -155.016    57.900
>
  -152.583    57.783
  -153.420    57.398
>
  -152.583    57.783
  -153.420    57.398
>
  -155.202    58.275
  -155.134    58.262
>
  -155.202    58.275
  -155.134    58.262
>
  -155.061    58.297
  -155.134    58.262
>
  -155.061    58.297
  -155.134    58.262
>
  -155.061    58.297
  -155.134    58.262
>
  -155.282    58.270
  -155.134    58.262
>
  -155.282    58.270
  -155.134    58.262
>
  -155.023    58.198
  -155.134    58.262
>
  -155.023    58.198
  -155.134    58.262
>
  -154.976    58.131
  -155.134    58.262
>
  -154.799    58.384
  -155.134    58.262
>
  -154.799    58.384
  -155.134    58.262
>
  -155.494    58.199
  -155.134    58.262
>
  -155.494    58.199
  -155.134    58.262
>
  -155.301    58.053
  -155.134    58.262
>
  -155.301    58.053
  -155.134    58.262
>
  -154.703    58.498
  -155.134    58.262
>
  -154.703    58.498
  -155.134    58.262
>
  -155.573    58.054
  -155.134    58.262
>
  -154.546    58.494
  -155.134    58.262
>
  -154.546    58.494
  -155.134    58.262
>
  -155.009    58.648
  -155.134    58.262
>
  -155.009    58.648
  -155.134    58.262
>
  -154.347    58.597
  -155.134    58.262
>
  -156.324    57.764
  -155.134    58.262
>
  -156.267    57.689
  -155.134    58.262
>
  -156.607    57.802
  -155.134    58.262
>
  -156.360    57.631
  -155.134    58.262
>
  -156.878    57.998
  -155.134    58.262
>
  -156.878    57.998
  -155.134    58.262
>
  -152.583    57.783
  -152.622    57.527
>
  -152.583    57.783
  -152.622    57.527
>
  -154.976    58.131
  -154.279    57.273
>
  -154.976    58.131
  -154.279    57.273
>
  -155.301    58.053
  -154.279    57.273
>
  -155.161    58.134
  -154.279    57.273
>
  -154.976    58.131
  -154.900    57.986
>
  -154.976    58.131
  -154.900    57.986
>
  -155.301    58.053
  -154.900    57.986
>
  -155.301    58.053
  -154.900    57.986
>
  -155.023    58.198
  -154.900    57.986
>
  -155.061    58.297
  -154.900    57.986
>
  -155.061    58.297
  -154.900    57.986
>
  -155.202    58.275
  -154.900    57.986
>
  -155.282    58.270
  -154.900    57.986
>
  -155.573    58.054
  -154.900    57.986
>
  -155.494    58.199
  -154.900    57.986
>
  -154.799    58.384
  -154.900    57.986
>
  -154.799    58.384
  -154.900    57.986
>
  -154.703    58.498
  -154.900    57.986
>
  -154.546    58.494
  -154.900    57.986
>
  -155.009    58.648
  -154.900    57.986
>
  -155.009    58.648
  -154.900    57.986
>
  -154.347    58.597
  -154.900    57.986
>
  -154.347    58.597
  -154.900    57.986
>
  -156.267    57.689
  -154.900    57.986
>
  -156.267    57.689
  -154.900    57.986
>
  -156.324    57.764
  -154.900    57.986
>
  -156.324    57.764
  -154.900    57.986
>
  -156.360    57.631
  -154.900    57.986
>
  -156.607    57.802
  -154.900    57.986
>
  -156.607    57.802
  -154.900    57.986
>
  -155.301    58.053
  -154.451    57.671
>
  -155.301    58.053
  -154.451    57.671
>
  -155.061    58.297
  -154.451    57.671
>
  -155.061    58.297
  -154.451    57.671
>
  -155.573    58.054
  -154.451    57.671
>
  -155.573    58.054
  -154.451    57.671
>
  -155.202    58.275
  -154.451    57.671
>
  -154.799    58.384
  -154.451    57.671
>
  -155.282    58.270
  -154.451    57.671
>
  -155.494    58.199
  -154.451    57.671
>
  -154.546    58.494
  -154.451    57.671
>
  -154.703    58.498
  -154.451    57.671
>
  -156.267    57.689
  -154.451    57.671
>
  -156.267    57.689
  -154.451    57.671
>
  -152.583    57.783
  -152.268    57.503
>
  -152.583    57.783
  -152.268    57.503
>
  -152.394    58.610
  -151.844    58.412
>
  -152.394    58.610
  -151.844    58.412
>
  -152.583    57.783
  -151.844    58.412
>
  -152.583    57.783
  -151.844    58.412
>
  -155.009    58.648
  -155.222    58.538
>
  -155.061    58.297
  -155.222    58.538
>
  -155.202    58.275
  -155.222    58.538
>
  -155.282    58.270
  -155.222    58.538
>
  -154.799    58.384
  -155.222    58.538
>
  -154.703    58.498
  -155.222    58.538
>
  -155.023    58.198
  -155.222    58.538
>
  -155.494    58.199
  -155.222    58.538
>
  -155.494    58.199
  -155.222    58.538
>
  -154.546    58.494
  -155.222    58.538
>
  -154.546    58.494
  -155.222    58.538
>
  -155.161    58.134
  -155.222    58.538
>
  -154.976    58.131
  -155.222    58.538
>
  -154.976    58.131
  -155.222    58.538
>
  -155.301    58.053
  -155.222    58.538
>
  -154.347    58.597
  -155.222    58.538
>
  -155.229    59.392
  -155.222    58.538
>
  -155.229    59.392
  -155.222    58.538
>
  -156.439    59.195
  -155.222    58.538
>
  -156.439    59.195
  -155.222    58.538
>
  -154.347    58.597
  -153.831    58.713
>
  -154.347    58.597
  -153.831    58.713
>
  -153.645    58.929
  -153.831    58.713
>
  -153.645    58.929
  -153.831    58.713
>
  -154.546    58.494
  -153.831    58.713
>
  -154.546    58.494
  -153.831    58.713
>
  -154.703    58.498
  -153.831    58.713
>
  -154.703    58.498
  -153.831    58.713
>
  -154.799    58.384
  -153.831    58.713
>
  -154.799    58.384
  -153.831    58.713
>
  -155.009    58.648
  -153.831    58.713
>
  -155.009    58.648
  -153.831    58.713
>
  -153.408    59.350
  -153.831    58.713
>
  -153.408    59.350
  -153.831    58.713
>
  -153.461    59.359
  -153.831    58.713
>
  -153.461    59.359
  -153.831    58.713
>
  -153.445    59.363
  -153.831    58.713
>
  -153.471    59.370
  -153.831    58.713
>
  -153.471    59.370
  -153.831    58.713
>
  -153.357    59.370
  -153.831    58.713
>
  -153.357    59.370
  -153.831    58.713
>
  -155.061    58.297
  -153.831    58.713
>
  -155.061    58.297
  -153.831    58.713
>
  -152.394    58.610
  -153.831    58.713
>
  -152.394    58.610
  -153.831    58.713
>
  -155.023    58.198
  -153.831    58.713
>
  -154.976    58.131
  -153.831    58.713
>
  -154.976    58.131
  -153.831    58.713
>
  -155.202    58.275
  -153.831    58.713
>
  -155.282    58.270
  -153.831    58.713
>
  -155.161    58.134
  -153.831    58.713
>
  -155.161    58.134
  -153.831    58.713
>
  -155.229    59.392
  -153.831    58.713
>
  -155.229    59.392
  -153.831    58.713
>
  -152.583    57.783
  -152.543    58.212
>
  -152.583    57.783
  -152.543    58.212
>
  -152.583    57.783
  -152.543    58.212
>
  -152.583    57.783
  -152.543    58.212
>
  -152.394    58.610
  -152.543    58.212
>
  -152.394    58.610
  -152.543    58.212
>
  -153.645    58.929
  -152.543    58.212
>
  -154.182    56.560
  -153.317    56.008
>
  -152.583    57.783
  -153.308    57.628
>
  -152.583    57.783
  -153.308    57.628
>
  -153.288    57.222
  -152.909    56.810
>
  -153.288    57.222
  -152.909    56.810
>
  -154.182    56.560
  -152.909    56.810
>
  -154.182    56.560
  -152.909    56.810
>
  -154.182    56.560
  -152.909    56.810
>
  -152.583    57.783
  -152.909    56.810
>
  -152.583    57.783
  -152.909    56.810
>
  -152.583    57.783
  -152.909    56.810
>
  -152.583    57.783
  -152.909    56.810
>
  -153.288    57.222
  -153.785    57.268
>
  -154.182    56.560
  -153.785    57.268
>
  -154.182    56.560
  -153.785    57.268
>
  -152.583    57.783
  -153.785    57.268
>
  -152.583    57.783
  -153.785    57.268
>
  -153.288    57.222
  -153.661    57.269
>
  -153.288    57.222
  -153.661    57.269
>
  -152.583    57.783
  -153.661    57.269
>
  -152.583    57.783
  -153.661    57.269
>
  -152.583    57.783
  -153.661    57.269
>
  -152.583    57.783
  -153.661    57.269
>
  -154.182    56.560
  -153.661    57.269
>
  -154.182    56.560
  -153.661    57.269
>
  -155.009    58.648
  -155.039    58.691
>
  -155.009    58.648
  -155.039    58.691
>
  -154.703    58.498
  -155.039    58.691
>
  -154.703    58.498
  -155.039    58.691
>
  -154.546    58.494
  -155.039    58.691
>
  -154.546    58.494
  -155.039    58.691
>
  -154.799    58.384
  -155.039    58.691
>
  -154.799    58.384
  -155.039    58.691
>
  -154.347    58.597
  -155.039    58.691
>
  -154.347    58.597
  -155.039    58.691
>
  -155.282    58.270
  -155.039    58.691
>
  -155.282    58.270
  -155.039    58.691
>
  -155.494    58.199
  -155.039    58.691
>
  -155.494    58.199
  -155.039    58.691
>
  -155.573    58.054
  -155.039    58.691
>
  -155.573    58.054
  -155.039    58.691
>
  -155.229    59.392
  -155.039    58.691
>
  -155.229    59.392
  -155.039    58.691
>
  -156.439    59.195
  -155.039    58.691
>
  -156.439    59.195
  -155.039    58.691
>
  -154.546    58.494
  -154.130    58.288
>
  -154.546    58.494
  -154.130    58.288
>
  -154.347    58.597
  -154.130    58.288
>
  -154.799    58.384
  -154.130    58.288
>
  -154.799    58.384
  -154.130    58.288
>
  -154.703    58.498
  -154.130    58.288
>
  -155.009    58.648
  -154.130    58.288
>
  -155.009    58.648
  -154.130    58.288
>
  -155.282    58.270
  -154.130    58.288
>
  -155.494    58.199
  -154.130    58.288
>
  -155.573    58.054
  -154.130    58.288
>
  -152.583    57.783
  -154.130    58.288
>
  -152.583    57.783
  -154.130    58.288
>
  -152.583    57.783
  -154.130    58.288
>
  -152.394    58.610
  -154.130    58.288
>
  -152.394    58.610
  -154.130    58.288
>
  -154.182    56.560
  -153.762    56.575
>
  -154.182    56.560
  -153.762    56.575
>
  -155.009    58.648
  -155.152    58.619
>
  -155.009    58.648
  -155.152    58.619
>
  -154.703    58.498
  -155.152    58.619
>
  -154.703    58.498
  -155.152    58.619
>
  -154.799    58.384
  -155.152    58.619
>
  -154.799    58.384
  -155.152    58.619
>
  -155.061    58.297
  -155.152    58.619
>
  -155.061    58.297
  -155.152    58.619
>
  -154.546    58.494
  -155.152    58.619
>
  -155.202    58.275
  -155.152    58.619
>
  -155.202    58.275
  -155.152    58.619
>
  -154.347    58.597
  -155.152    58.619
>
  -155.023    58.198
  -155.152    58.619
>
  -155.494    58.199
  -155.152    58.619
>
  -155.161    58.134
  -155.152    58.619
>
  -154.976    58.131
  -155.152    58.619
>
  -155.573    58.054
  -155.152    58.619
>
  -155.229    59.392
  -155.152    58.619
>
  -155.229    59.392
  -155.152    58.619
>
  -156.439    59.195
  -155.152    58.619
>
  -154.703    58.498
  -154.772    58.599
>
  -154.546    58.494
  -154.772    58.599
>
  -155.009    58.648
  -154.772    58.599
>
  -154.347    58.597
  -154.772    58.599
>
  -154.799    58.384
  -154.772    58.599
>
  -154.799    58.384
  -154.772    58.599
>
  -155.061    58.297
  -154.772    58.599
>
  -155.061    58.297
  -154.772    58.599
>
  -155.202    58.275
  -154.772    58.599
>
  -155.202    58.275
  -154.772    58.599
>
  -155.023    58.198
  -154.772    58.599
>
  -155.023    58.198
  -154.772    58.599
>
  -155.282    58.270
  -154.772    58.599
>
  -155.282    58.270
  -154.772    58.599
>
  -154.976    58.131
  -154.772    58.599
>
  -154.976    58.131
  -154.772    58.599
>
  -155.494    58.199
  -154.772    58.599
>
  -155.301    58.053
  -154.772    58.599
>
  -155.301    58.053
  -154.772    58.599
>
  -155.573    58.054
  -154.772    58.599
>
  -155.229    59.392
  -154.772    58.599
>
  -155.229    59.392
  -154.772    58.599
>
  -154.182    56.560
  -154.697    56.919
>
  -154.182    56.560
  -154.697    56.919
>
  -154.182    56.560
  -154.730    56.957
>
  -154.182    56.560
  -154.730    56.957
>
  -153.288    57.222
  -154.730    56.957
>
  -153.288    57.222
  -154.730    56.957
>
  -154.347    58.597
  -153.487    58.644
>
  -154.347    58.597
  -153.487    58.644
>
  -152.394    58.610
  -153.487    58.644
>
  -152.394    58.610
  -153.487    58.644
>
  -154.546    58.494
  -153.487    58.644
>
  -154.546    58.494
  -153.487    58.644
>
  -154.703    58.498
  -153.487    58.644
>
  -154.703    58.498
  -153.487    58.644
>
  -153.428    59.333
  -153.487    58.644
>
  -153.428    59.333
  -153.487    58.644
>
  -153.408    59.350
  -153.487    58.644
>
  -153.408    59.350
  -153.487    58.644
>
  -153.461    59.359
  -153.487    58.644
>
  -153.461    59.359
  -153.487    58.644
>
  -153.445    59.363
  -153.487    58.644
>
  -153.445    59.363
  -153.487    58.644
>
  -153.471    59.370
  -153.487    58.644
>
  -153.471    59.370
  -153.487    58.644
>
  -153.357    59.370
  -153.487    58.644
>
  -153.357    59.370
  -153.487    58.644
>
  -154.799    58.384
  -153.487    58.644
>
  -154.799    58.384
  -153.487    58.644
>
  -153.519    59.377
  -153.487    58.644
>
  -153.519    59.377
  -153.487    58.644
>
  -153.451    59.404
  -153.487    58.644
>
  -155.009    58.648
  -153.487    58.644
>
  -155.009    58.648
  -153.487    58.644
>
  -155.023    58.198
  -153.487    58.644
>
  -155.023    58.198
  -153.487    58.644
>
  -154.976    58.131
  -153.487    58.644
>
  -154.976    58.131
  -153.487    58.644
>
  -152.583    57.783
  -153.487    58.644
>
  -152.583    57.783
  -153.487    58.644
>
  -152.583    57.783
  -153.487    58.644
>
  -152.583    57.783
  -153.487    58.644
>
  -155.009    58.648
  -155.160    58.497
>
  -155.009    58.648
  -155.160    58.497
>
  -155.061    58.297
  -155.160    58.497
>
  -155.061    58.297
  -155.160    58.497
>
  -154.799    58.384
  -155.160    58.497
>
  -154.799    58.384
  -155.160    58.497
>
  -154.703    58.498
  -155.160    58.497
>
  -154.703    58.498
  -155.160    58.497
>
  -155.202    58.275
  -155.160    58.497
>
  -155.202    58.275
  -155.160    58.497
>
  -155.282    58.270
  -155.160    58.497
>
  -155.282    58.270
  -155.160    58.497
>
  -154.546    58.494
  -155.160    58.497
>
  -155.023    58.198
  -155.160    58.497
>
  -155.494    58.199
  -155.160    58.497
>
  -155.494    58.199
  -155.160    58.497
>
  -155.161    58.134
  -155.160    58.497
>
  -154.976    58.131
  -155.160    58.497
>
  -154.347    58.597
  -155.160    58.497
>
  -155.573    58.054
  -155.160    58.497
>
  -155.229    59.392
  -155.160    58.497
>
  -155.229    59.392
  -155.160    58.497
>
  -156.324    57.764
  -155.160    58.497
>
  -156.324    57.764
  -155.160    58.497
>
  -156.439    59.195
  -155.160    58.497
>
  -156.439    59.195
  -155.160    58.497
>
  -154.182    56.560
  -154.735    56.987
>
  -154.182    56.560
  -154.735    56.987
>
  -153.288    57.222
  -154.735    56.987
>
  -155.161    58.134
  -155.185    58.129
>
  -155.301    58.053
  -155.185    58.129
>
  -155.301    58.053
  -155.185    58.129
>
  -154.976    58.131
  -155.185    58.129
>
  -154.976    58.131
  -155.185    58.129
>
  -155.282    58.270
  -155.185    58.129
>
  -155.282    58.270
  -155.185    58.129
>
  -155.202    58.275
  -155.185    58.129
>
  -155.202    58.275
  -155.185    58.129
>
  -155.494    58.199
  -155.185    58.129
>
  -155.494    58.199
  -155.185    58.129
>
  -155.061    58.297
  -155.185    58.129
>
  -155.573    58.054
  -155.185    58.129
>
  -155.573    58.054
  -155.185    58.129
>
  -154.799    58.384
  -155.185    58.129
>
  -154.799    58.384
  -155.185    58.129
>
  -154.703    58.498
  -155.185    58.129
>
  -154.703    58.498
  -155.185    58.129
>
  -154.347    58.597
  -155.185    58.129
>
  -154.347    58.597
  -155.185    58.129
>
  -156.324    57.764
  -155.185    58.129
>
  -156.324    57.764
  -155.185    58.129
>
  -156.607    57.802
  -155.185    58.129
>
  -156.607    57.802
  -155.185    58.129
>
  -156.819    57.700
  -155.185    58.129
>
  -156.819    57.700
  -155.185    58.129
>
  -154.182    56.560
  -152.993    56.889
>
  -152.583    57.783
  -152.993    56.889
>
  -152.583    57.783
  -152.993    56.889
>
  -152.583    57.783
  -152.993    56.889
>
  -152.583    57.783
  -152.993    56.889
>
  -153.288    57.222
  -153.009    56.853
>
  -154.182    56.560
  -153.009    56.853
>
  -154.182    56.560
  -153.009    56.853
>
  -152.583    57.783
  -153.009    56.853
>
  -152.583    57.783
  -153.009    56.853
>
  -152.583    57.783
  -153.009    56.853
>
  -152.583    57.783
  -153.009    56.853
>
  -153.288    57.222
  -153.015    56.853
>
  -153.288    57.222
  -153.015    56.853
>
  -154.182    56.560
  -153.015    56.853
>
  -152.583    57.783
  -153.015    56.853
>
  -152.583    57.783
  -153.015    56.853
>
  -152.583    57.783
  -152.679    57.901
>
  -152.583    57.783
  -152.679    57.901
>
  -152.583    57.783
  -152.679    57.901
>
  -153.288    57.222
  -152.679    57.901
>
  -153.288    57.222
  -152.679    57.901
>
  -152.394    58.610
  -152.679    57.901
>
  -152.394    58.610
  -152.679    57.901
>
  -154.182    56.560
  -153.994    56.097
>
  -154.182    56.560
  -154.080    56.110
>
  -154.182    56.560
  -154.009    56.146
>
  -152.583    57.783
  -153.316    57.780
>
  -152.583    57.783
  -153.316    57.780
>
  -153.288    57.222
  -153.316    57.780
>
  -152.394    58.610
  -153.316    57.780
>
  -152.394    58.610
  -153.316    57.780
>
  -154.976    58.131
  -153.316    57.780
>
  -154.976    58.131
  -153.316    57.780
>
  -154.799    58.384
  -153.316    57.780
>
  -154.799    58.384
  -153.316    57.780
>
  -152.394    58.610
  -152.783    58.340
>
  -152.583    57.783
  -152.783    58.340
>
  -152.583    57.783
  -152.783    58.340
>
  -154.976    58.131
  -154.011    57.976
>
  -154.976    58.131
  -154.011    57.976
>
  -155.023    58.198
  -154.011    57.976
>
  -155.023    58.198
  -154.011    57.976
>
  -155.061    58.297
  -154.011    57.976
>
  -155.061    58.297
  -154.011    57.976
>
  -155.202    58.275
  -154.011    57.976
>
  -155.282    58.270
  -154.011    57.976
>
  -152.583    57.783
  -154.011    57.976
>
  -152.583    57.783
  -154.011    57.976
>
  -152.583    57.783
  -154.011    57.976
>
  -155.494    58.199
  -154.011    57.976
>
  -152.394    58.610
  -152.629    58.448
>
  -152.394    58.610
  -152.629    58.448
>
  -152.583    57.783
  -152.629    58.448
>
  -152.583    57.783
  -152.629    58.448
>
  -152.583    57.783
  -152.629    58.448
>
  -152.583    57.783
  -152.629    58.448
>
  -153.428    59.333
  -152.629    58.448
>
  -153.428    59.333
  -152.629    58.448
>
  -153.408    59.350
  -152.629    58.448
>
  -153.408    59.350
  -152.629    58.448
>
  -153.357    59.370
  -152.629    58.448
>
  -153.357    59.370
  -152.629    58.448
>
  -152.583    57.783
  -151.528    58.132
>
  -152.583    57.783
  -151.528    58.132
>
  -152.583    57.783
  -151.528    58.132
>
  -152.583    57.783
  -151.528    58.132
>
  -152.394    58.610
  -151.528    58.132
>
  -152.394    58.610
  -151.528    58.132
>
  -152.583    57.783
  -153.173    58.135
>
  -152.583    57.783
  -153.173    58.135
>
  -152.583    57.783
  -153.173    58.135
>
  -152.583    57.783
  -153.173    58.135
>
  -152.583    57.783
  -153.173    58.135
>
  -152.394    58.610
  -153.173    58.135
>
  -152.394    58.610
  -153.173    58.135
>
  -154.976    58.131
  -153.173    58.135
>
  -154.976    58.131
  -153.173    58.135
>
  -155.023    58.198
  -153.173    58.135
>
  -155.023    58.198
  -153.173    58.135
>
  -155.061    58.297
  -154.989    58.285
>
  -155.061    58.297
  -154.989    58.285
>
  -155.202    58.275
  -154.989    58.285
>
  -155.282    58.270
  -154.989    58.285
>
  -155.282    58.270
  -154.989    58.285
>
  -154.976    58.131
  -154.989    58.285
>
  -154.976    58.131
  -154.989    58.285
>
  -155.161    58.134
  -154.989    58.285
>
  -155.161    58.134
  -154.989    58.285
>
  -156.324    57.764
  -154.989    58.285
>
  -156.324    57.764
  -154.989    58.285
>
  -156.267    57.689
  -154.989    58.285
>
  -156.607    57.802
  -154.989    58.285
>
  -156.607    57.802
  -154.989    58.285
>
  -153.645    58.929
  -154.989    58.285
>
  -153.645    58.929
  -154.989    58.285
>
  -154.182    56.560
  -154.883    56.943
>
  -154.182    56.560
  -154.883    56.943
>
  -154.182    56.560
  -154.834    56.886
>
  -154.182    56.560
  -154.834    56.886
>
  -152.583    57.783
  -152.526    57.767
>
  -152.583    57.783
  -152.526    57.767
>
  -152.583    57.783
  -152.526    57.767
>
  -152.394    58.610
  -152.526    57.767
>
  -152.394    58.610
  -152.526    57.767
>
  -152.394    58.610
  -152.643    58.689
>
  -152.394    58.610
  -152.643    58.689
>
  -153.645    58.929
  -152.643    58.689
>
  -153.645    58.929
  -152.643    58.689
>
  -153.428    59.333
  -152.643    58.689
>
  -153.428    59.333
  -152.643    58.689
>
  -153.408    59.350
  -152.643    58.689
>
  -153.408    59.350
  -152.643    58.689
>
  -153.357    59.370
  -152.643    58.689
>
  -153.357    59.370
  -152.643    58.689
>
  -153.461    59.359
  -152.643    58.689
>
  -153.461    59.359
  -152.643    58.689
>
  -153.471    59.370
  -152.643    58.689
>
  -153.471    59.370
  -152.643    58.689
>
  -153.435    59.382
  -152.643    58.689
>
  -153.519    59.377
  -152.643    58.689
>
  -153.519    59.377
  -152.643    58.689
>
  -153.451    59.404
  -152.643    58.689
>
  -152.583    57.783
  -152.643    58.689
>
  -152.583    57.783
  -152.643    58.689
>
  -156.267    57.689
  -155.408    57.245
>
  -156.267    57.689
  -155.408    57.245
>
  -156.324    57.764
  -155.408    57.245
>
  -156.324    57.764
  -155.408    57.245
>
  -156.607    57.802
  -155.408    57.245
>
  -156.607    57.802
  -155.408    57.245
>
  -156.819    57.700
  -155.408    57.245
>
  -156.819    57.700
  -155.408    57.245
>
  -154.976    58.131
  -155.408    57.245
>
  -154.976    58.131
  -155.408    57.245
>
  -155.494    58.199
  -155.408    57.245
>
  -155.494    58.199
  -155.408    57.245
>
  -154.182    56.560
  -155.408    57.245
>
  -154.182    56.560
  -155.408    57.245
>
  -156.267    57.689
  -155.404    57.204
>
  -156.267    57.689
  -155.404    57.204
>
  -156.324    57.764
  -155.404    57.204
>
  -156.324    57.764
  -155.404    57.204
>
  -155.573    58.054
  -155.404    57.204
>
  -155.573    58.054
  -155.404    57.204
>
  -156.607    57.802
  -155.404    57.204
>
  -156.607    57.802
  -155.404    57.204
>
  -156.819    57.700
  -155.404    57.204
>
  -156.819    57.700
  -155.404    57.204
>
  -154.182    56.560
  -155.404    57.204
>
  -154.182    56.560
  -155.404    57.204
>
  -154.976    58.131
  -155.404    57.204
>
  -154.976    58.131
  -155.404    57.204
>
  -155.494    58.199
  -155.404    57.204
>
  -155.494    58.199
  -155.404    57.204
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -152.492    57.748     0.300
  -152.493    57.758     0.300
  -152.515    57.748     0.300
  -153.080    57.164     0.300
  -152.282    57.395     0.300
  -153.643    58.930     0.300
  -152.349    58.628     0.300
  -153.372    59.359     0.300
  -153.435    59.382     0.300
  -152.391    58.610     0.300
  -154.337    59.185     0.300
  -153.427    59.335     0.300
  -153.431    59.360     0.300
  -153.426    59.363     0.300
  -153.421    59.362     0.300
  -153.471    59.370     0.300
  -153.230    59.653     0.300
  -155.326    58.211     0.300
  -155.884    58.265     0.300
  -155.229    59.393     0.300
  -155.573    58.054     0.300
  -153.443    59.364     0.300
  -155.494    58.199     0.300
  -152.583    57.783     0.300
  -155.301    58.053     0.300
  -154.703    58.498     0.300
  -155.046    58.485     0.300
  -155.161    58.134     0.300
  -154.969    58.131     0.300
  -154.347    58.597     0.300
  -154.546    58.494     0.300
  -154.799    58.384     0.300
  -155.006    58.649     0.300
  -153.288    57.222     0.300
  -153.474    58.758     0.300
  -155.183    58.243     0.300
  -155.061    58.297     0.300
  -155.282    58.270     0.300
  -154.182    56.560     0.300
  -153.918    58.835     0.300
  -153.695    58.799     0.300
  -155.295    58.382     0.300
  -156.267    57.689     0.300
  -156.358    57.632     0.300
  -156.341    58.045     0.300
  -155.741    58.440     0.300
  -156.607    57.802     0.300
  -156.324    57.764     0.300
  -155.111    58.308     0.300
  -153.398    59.341     0.300
  -153.408    59.350     0.300
  -155.202    58.275     0.300
  -156.878    57.998     0.300
  -153.414    59.355     0.300
  -153.357    59.370     0.300
  -153.378    59.370     0.300
  -153.445    59.363     0.300
  -155.620    55.822     0.300
  -153.645    58.929     0.300
  -156.819    57.700     0.300
  -155.229    59.392     0.300
  -151.643    59.658     0.300
  -153.232    59.652     0.300
  -151.236    59.526     0.300
  -152.394    58.610     0.300
  -155.009    58.648     0.300
  -156.387    57.640     0.300
  -155.887    58.264     0.300
  -156.656    58.677     0.300
  -154.452    57.567     0.300
  -156.439    59.195     0.300
  -156.360    57.631     0.300
  -157.574    57.567     0.300
  -154.976    58.131     0.300
  -155.023    58.198     0.300
  -153.428    59.333     0.300
  -153.461    59.359     0.300
  -153.451    59.404     0.300
  -153.519    59.377     0.300
  -153.288    57.222     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -151.257    56.978     0.200
>
  -151.183    57.359     0.200
>
  -151.357    57.570     0.200
>
  -151.852    57.134     0.200
>
  -151.928    58.125     0.200
>
  -152.679    56.881     0.200
>
  -152.394    58.112     0.200
>
  -152.218    57.296     0.200
>
  -154.515    58.556     0.200
>
  -151.725    58.210     0.200
>
  -151.237    57.446     0.200
>
  -153.305    58.159     0.200
>
  -152.603    56.500     0.200
>
  -152.624    56.531     0.200
>
  -152.490    56.498     0.200
>
  -151.401    56.799     0.200
>
  -152.879    58.283     0.200
>
  -153.617    58.148     0.200
>
  -152.924    58.456     0.200
>
  -153.774    57.461     0.200
>
  -151.402    58.323     0.200
>
  -152.513    57.842     0.200
>
  -155.031    58.489     0.200
>
  -152.694    58.037     0.200
>
  -151.398    58.022     0.200
>
  -153.608    58.680     0.200
>
  -153.363    57.220     0.200
>
  -153.637    58.104     0.200
>
  -152.898    58.240     0.200
>
  -155.193    58.758     0.200
>
  -151.830    58.051     0.200
>
  -153.531    58.694     0.200
>
  -155.184    58.256     0.200
>
  -153.022    58.641     0.200
>
  -153.640    57.943     0.200
>
  -152.896    57.779     0.200
>
  -151.909    57.562     0.200
>
  -153.218    57.854     0.200
>
  -154.509    58.141     0.200
>
  -154.095    58.467     0.200
>
  -153.695    57.312     0.200
>
  -151.595    58.271     0.200
>
  -151.782    58.217     0.200
>
  -154.872    58.457     0.200
>
  -154.225    57.356     0.200
>
  -154.238    57.343     0.200
>
  -152.691    57.510     0.200
>
  -154.190    57.390     0.200
>
  -154.251    57.409     0.200
>
  -153.570    58.585     0.200
>
  -153.759    57.819     0.200
>
  -152.346    57.998     0.200
>
  -153.934    58.009     0.200
>
  -154.959    57.292     0.200
>
  -155.378    57.783     0.200
>
  -153.233    58.380     0.200
>
  -155.963    58.307     0.200
>
  -153.451    57.975     0.200
>
  -154.272    58.637     0.200
>
  -155.056    57.635     0.200
>
  -155.158    58.691     0.200
>
  -151.632    58.168     0.200
>
  -154.785    57.309     0.200
>
  -152.947    56.983     0.200
>
  -153.050    56.993     0.200
>
  -154.653    58.154     0.200
>
  -154.619    57.907     0.200
>
  -151.341    58.250     0.200
>
  -153.085    58.230     0.200
>
  -153.764    57.900     0.200
>
  -154.849    58.097     0.200
>
  -153.148    58.682     0.200
>
  -152.012    58.212     0.200
>
  -154.305    57.308     0.200
>
  -155.260    57.209     0.200
>
  -151.480    58.339     0.200
>
  -152.925    56.544     0.200
>
  -152.034    58.426     0.200
>
  -154.556    57.406     0.200
>
  -153.723    56.638     0.200
>
  -153.130    57.727     0.200
>
  -155.147    58.639     0.200
>
  -153.350    58.625     0.200
>
  -152.605    56.538     0.200
>
  -152.509    56.465     0.200
>
  -152.206    57.580     0.200
>
  -153.592    58.693     0.200
>
  -153.296    58.679     0.200
>
  -153.544    56.966     0.200
>
  -152.253    58.265     0.200
>
  -154.816    57.653     0.200
>
  -155.709    57.612     0.200
>
  -152.897    57.545     0.200
>
  -151.773    56.974     0.200
>
  -155.296    57.694     0.200
>
  -152.951    58.409     0.200
>
  -154.572    58.555     0.200
>
  -152.639    56.464     0.200
>
  -153.536    57.611     0.200
>
  -152.521    58.521     0.200
>
  -154.236    58.368     0.200
>
  -152.603    58.157     0.200
>
  -153.618    58.444     0.200
>
  -151.554    58.292     0.200
>
  -153.184    58.447     0.200
>
  -153.239    58.085     0.200
>
  -153.875    57.709     0.200
>
  -152.369    57.399     0.200
>
  -154.239    57.345     0.200
>
  -154.793    58.186     0.200
>
  -152.912    56.829     0.200
>
  -153.376    56.530     0.200
>
  -152.901    56.294     0.200
>
  -154.111    57.721     0.200
>
  -153.723    58.510     0.200
>
  -154.180    56.985     0.200
>
  -153.548    58.115     0.200
>
  -155.189    58.225     0.200
>
  -153.190    58.618     0.200
>
  -154.299    58.544     0.200
>
  -155.247    58.726     0.200
>
  -151.738    58.180     0.200
>
  -153.859    58.690     0.200
>
  -153.939    58.774     0.200
>
  -152.647    58.705     0.200
>
  -151.869    58.057     0.200
>
  -153.938    57.656     0.200
>
  -152.913    56.912     0.200
>
  -153.454    58.705     0.200
>
  -154.079    56.560     0.200
>
  -155.033    56.798     0.200
>
  -155.075    56.810     0.200
>
  -155.028    56.828     0.200
>
  -153.942    58.432     0.200
>
  -152.837    56.869     0.200
>
  -153.670    58.609     0.200
>
  -151.874    58.176     0.200
>
  -154.045    56.385     0.200
>
  -153.244    56.105     0.200
>
  -152.934    58.201     0.200
>
  -151.539    58.251     0.200
>
  -154.956    58.346     0.200
>
  -153.600    58.298     0.200
>
  -154.816    57.833     0.200
>
  -155.377    58.548     0.200
>
  -153.711    58.739     0.200
>
  -154.154    58.493     0.200
>
  -154.453    57.205     0.200
>
  -153.386    56.726     0.200
>
  -155.173    58.647     0.200
>
  -152.277    58.055     0.200
>
  -153.068    56.822     0.200
>
  -155.006    58.148     0.200
>
  -154.125    58.666     0.200
>
  -155.216    57.051     0.200
>
  -151.821    58.103     0.200
>
  -155.282    58.568     0.200
>
  -154.830    56.591     0.200
>
  -153.286    58.070     0.200
>
  -154.042    57.716     0.200
>
  -153.697    58.018     0.200
>
  -154.691    58.162     0.200
>
  -152.078    58.011     0.200
>
  -154.997    57.548     0.200
>
  -154.143    58.446     0.200
>
  -154.145    58.454     0.200
>
  -155.212    57.022     0.200
>
  -154.128    57.718     0.200
>
  -154.089    57.528     0.200
>
  -154.120    57.933     0.200
>
  -154.017    56.632     0.200
>
  -153.548    58.467     0.200
>
  -154.916    58.020     0.200
>
  -152.494    57.285     0.200
>
  -153.611    57.929     0.200
>
  -151.604    58.103     0.200
>
  -153.440    57.847     0.200
>
  -154.027    57.640     0.200
>
  -154.359    57.672     0.200
>
  -152.075    58.093     0.200
>
  -154.112    58.055     0.200
>
  -155.503    58.148     0.200
>
  -154.381    56.816     0.200
>
  -154.083    58.573     0.200
>
  -152.510    58.358     0.200
>
  -151.456    58.251     0.200
>
  -153.219    56.772     0.200
>
  -155.304    58.583     0.200
>
  -155.465    56.598     0.200
>
  -154.642    58.143     0.200
>
  -151.710    58.144     0.200
>
  -154.501    57.628     0.200
>
  -152.949    58.477     0.200
>
  -152.459    58.909     0.200
>
  -154.123    58.532     0.200
>
  -152.968    57.721     0.200
>
  -153.034    58.298     0.200
>
  -153.593    57.837     0.200
>
  -155.196    56.609     0.200
>
  -154.828    57.853     0.200
>
  -154.738    58.122     0.200
>
  -154.548    57.773     0.200
>
  -151.415    58.324     0.200
>
  -153.935    58.014     0.200
>
  -153.207    56.404     0.200
>
  -153.229    56.404     0.200
>
  -154.603    58.127     0.200
>
  -155.220    56.755     0.200
>
  -154.628    58.134     0.200
>
  -153.769    58.196     0.200
>
  -153.645    58.694     0.200
>
  -154.203    57.229     0.200
>
  -152.619    58.273     0.200
>
  -154.953    58.693     0.200
>
  -152.254    56.805     0.200
>
  -154.271    56.218     0.200
>
  -151.907    58.235     0.200
>
  -154.556    58.133     0.200
>
  -152.337    57.266     0.200
>
  -154.105    57.103     0.200
>
  -154.020    57.384     0.200
>
  -155.038    57.471     0.200
>
  -155.063    57.542     0.200
>
  -154.770    58.485     0.200
>
  -152.766    58.375     0.200
>
  -151.344    58.388     0.200
>
  -152.579    56.908     0.200
>
  -152.538    56.982     0.200
>
  -152.580    57.013     0.200
>
  -151.394    58.338     0.200
>
  -154.300    57.784     0.200
>
  -155.218    58.216     0.200
>
  -154.825    56.524     0.200
>
  -153.025    58.336     0.200
>
  -154.612    56.497     0.200
>
  -153.650    58.473     0.200
>
  -155.105    58.648     0.200
>
  -154.487    57.731     0.200
>
  -154.679    57.312     0.200
>
  -151.599    58.206     0.200
>
  -155.485    58.569     0.200
>
  -152.878    58.363     0.200
>
  -155.044    57.732     0.200
>
  -155.039    57.721     0.200
>
  -154.491    57.984     0.200
>
  -155.240    58.282     0.200
>
  -152.997    57.574     0.200
>
  -152.987    57.576     0.200
>
  -151.997    58.210     0.200
>
  -153.116    56.899     0.200
>
  -153.588    58.395     0.200
>
  -154.815    58.078     0.200
>
  -154.428    56.815     0.200
>
  -154.347    56.305     0.200
>
  -154.316    56.204     0.200
>
  -154.216    58.046     0.200
>
  -152.873    57.862     0.200
>
  -155.010    56.830     0.200
>
  -151.154    58.627     0.200
>
  -155.443    58.202     0.200
>
  -155.089    58.714     0.200
>
  -155.128    57.544     0.200
>
  -153.348    56.328     0.200
>
  -153.368    56.293     0.200
>
  -153.335    56.198     0.200
>
  -154.013    58.306     0.200
>
  -152.922    58.203     0.200
>
  -155.254    58.300     0.200
>
  -155.510    57.647     0.200
>
  -155.499    57.656     0.200
>
  -155.537    57.670     0.200
>
  -152.524    57.824     0.200
>
  -151.150    58.385     0.200
>
  -152.595    56.920     0.200
>
  -153.083    58.658     0.200
>
  -155.292    57.278     0.200
>
  -154.071    58.188     0.200
>
  -155.508    57.278     0.200
>
  -151.623    58.288     0.200
>
  -153.230    58.628     0.200
>
  -154.782    56.519     0.200
>
  -153.988    56.367     0.200
>
  -153.175    58.368     0.200
>
  -154.090    58.565     0.200
>
  -153.927    58.655     0.200
>
  -155.309    58.359     0.200
>
  -154.556    57.347     0.200
>
  -152.579    58.001     0.200
>
  -155.365    57.342     0.200
>
  -153.972    58.167     0.200
>
  -153.085    58.294     0.200
>
  -155.259    58.489     0.200
>
  -155.083    58.610     0.200
>
  -154.263    58.092     0.200
>
  -155.925    57.938     0.200
>
  -154.309    56.374     0.200
>
  -153.069    56.777     0.200
>
  -152.658    57.984     0.200
>
  -155.024    57.084     0.200
>
  -151.301    58.346     0.200
>
  -151.326    58.322     0.200
>
  -151.487    58.563     0.200
>
  -153.614    58.454     0.200
>
  -154.277    57.927     0.200
>
  -154.649    57.606     0.200
>
  -152.147    58.131     0.200
>
  -153.012    58.207     0.200
>
  -154.011    58.223     0.200
>
  -151.478    58.302     0.200
>
  -154.235    58.477     0.200
>
  -153.512    57.826     0.200
>
  -153.583    58.670     0.200
>
  -152.358    57.626     0.200
>
  -154.288    57.622     0.200
>
  -151.381    58.470     0.200
>
  -151.328    58.523     0.200
>
  -154.173    58.096     0.200
>
  -152.583    58.269     0.200
>
  -153.858    58.650     0.200
>
  -153.485    56.162     0.200
>
  -153.452    56.277     0.200
>
  -153.449    56.087     0.200
>
  -153.400    56.205     0.200
>
  -153.370    56.092     0.200
>
  -153.354    56.076     0.200
>
  -154.619    56.017     0.200
>
  -152.799    58.429     0.200
>
  -154.501    56.288     0.200
>
  -153.917    58.328     0.200
>
  -154.955    56.553     0.200
>
  -153.798    56.247     0.200
>
  -153.797    56.180     0.200
>
  -155.175    57.328     0.200
>
  -153.668    56.277     0.200
>
  -153.847    57.511     0.200
>
  -154.190    57.099     0.200
>
  -153.202    57.641     0.200
>
  -153.081    56.221     0.200
>
  -154.931    57.838     0.200
>
  -154.586    58.124     0.200
>
  -151.503    58.268     0.200
>
  -153.609    57.830     0.200
>
  -153.502    58.082     0.200
>
  -153.956    58.651     0.200
>
  -154.811    57.454     0.200
>
  -154.615    56.273     0.200
>
  -154.825    57.451     0.200
>
  -154.039    58.087     0.200
>
  -155.112    58.183     0.200
>
  -154.408    57.335     0.200
>
  -153.846    57.659     0.200
>
  -155.489    57.031     0.200
>
  -153.496    58.607     0.200
>
  -155.057    57.137     0.200
>
  -155.077    57.127     0.200
>
  -153.540    58.578     0.200
>
  -154.885    57.653     0.200
>
  -151.717    58.289     0.200
>
  -154.806    57.189     0.200
>
  -154.203    58.258     0.200
>
  -153.757    58.248     0.200
>
  -154.314    56.477     0.200
>
  -151.788    57.995     0.200
>
  -153.172    58.442     0.200
>
  -155.272    57.945     0.200
>
  -155.338    58.478     0.200
>
  -154.421    58.081     0.200
>
  -154.416    58.085     0.200
>
  -153.162    58.737     0.200
>
  -154.729    58.476     0.200
>
  -153.137    56.786     0.200
>
  -154.950    57.269     0.200
>
  -155.277    57.776     0.200
>
  -153.734    58.780     0.200
>
  -152.561    58.610     0.200
>
  -151.722    58.206     0.200
>
  -154.523    58.549     0.200
>
  -154.161    58.721     0.200
>
  -155.360    58.158     0.200
>
  -153.535    57.321     0.200
>
  -154.400    57.061     0.200
>
  -154.170    57.349     0.200
>
  -152.534    58.684     0.200
>
  -153.970    57.961     0.200
>
  -153.714    58.535     0.200
>
  -153.716    58.344     0.200
>
  -151.887    58.342     0.200
>
  -154.542    58.136     0.200
>
  -155.188    57.531     0.200
>
  -154.882    57.227     0.200
>
  -153.358    58.515     0.200
>
  -153.874    57.752     0.200
>
  -152.819    57.709     0.200
>
  -153.979    57.741     0.200
>
  -153.531    58.123     0.200
>
  -153.641    58.626     0.200
>
  -153.322    58.541     0.200
>
  -155.073    58.290     0.200
>
  -153.250    58.508     0.200
>
  -154.185    57.493     0.200
>
  -154.064    58.642     0.200
>
  -155.775    58.405     0.200
>
  -153.879    57.737     0.200
>
  -155.199    58.242     0.200
>
  -153.198    57.586     0.200
>
  -154.888    57.503     0.200
>
  -154.580    57.469     0.200
>
  -155.217    58.239     0.200
>
  -154.145    57.248     0.200
>
  -154.566    57.763     0.200
>
  -155.148    58.257     0.200
>
  -155.003    57.744     0.200
>
  -153.129    57.524     0.200
>
  -155.472    57.196     0.200
>
  -154.007    58.557     0.200
>
  -155.230    58.239     0.200
>
  -153.292    58.597     0.200
>
  -155.117    58.261     0.200
>
  -155.173    58.251     0.200
>
  -155.158    58.256     0.200
>
  -155.150    58.267     0.200
>
  -153.697    58.122     0.200
>
  -155.138    58.280     0.200
>
  -154.634    58.135     0.200
>
  -154.785    58.182     0.200
>
  -154.923    57.721     0.200
>
  -154.937    57.452     0.200
>
  -155.016    57.900     0.200
>
  -153.420    57.398     0.200
>
  -155.134    58.262     0.200
>
  -152.622    57.527     0.200
>
  -154.279    57.273     0.200
>
  -154.900    57.986     0.200
>
  -154.451    57.671     0.200
>
  -152.268    57.503     0.200
>
  -151.844    58.412     0.200
>
  -155.222    58.538     0.200
>
  -153.831    58.713     0.200
>
  -152.543    58.212     0.200
>
  -153.317    56.008     0.200
>
  -153.308    57.628     0.200
>
  -152.909    56.810     0.200
>
  -153.785    57.268     0.200
>
  -153.661    57.269     0.200
>
  -155.039    58.691     0.200
>
  -154.130    58.288     0.200
>
  -153.762    56.575     0.200
>
  -155.152    58.619     0.200
>
  -154.772    58.599     0.200
>
  -154.697    56.919     0.200
>
  -154.730    56.957     0.200
>
  -153.487    58.644     0.200
>
  -155.160    58.497     0.200
>
  -154.735    56.987     0.200
>
  -155.185    58.129     0.200
>
  -152.993    56.889     0.200
>
  -153.009    56.853     0.200
>
  -153.015    56.853     0.200
>
  -152.679    57.901     0.200
>
  -153.994    56.097     0.200
>
  -154.080    56.110     0.200
>
  -154.009    56.146     0.200
>
  -153.316    57.780     0.200
>
  -152.783    58.340     0.200
>
  -154.011    57.976     0.200
>
  -152.629    58.448     0.200
>
  -151.528    58.132     0.200
>
  -153.173    58.135     0.200
>
  -154.989    58.285     0.200
>
  -154.883    56.943     0.200
>
  -154.834    56.886     0.200
>
  -152.526    57.767     0.200
>
  -152.643    58.689     0.200
>
  -155.408    57.245     0.200
>
  -155.404    57.204     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -153.741    57.781     0.000   222.000   222.000
  -153.741    57.781     0.000   444.000   444.000
EOF
gmt end
