#!/bin/bash
gmt begin kodiak1.21_base pdf,ps
proj=-JM16.0c+
reg=-R-156.1/-151.0/55.9/59.0
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map kodiak1.21'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Cross-section locations
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
  -153.741    57.781   135.000 180.4k
EOF
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
  -153.741    57.781   135.000 -142.7k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
  -153.741    57.781   225.000 2.5k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
  -153.741    57.781   225.000 -2.5k
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -151.257    56.978 1
  -151.183    57.359 2
  -151.357    57.570 3
  -151.852    57.134 4
  -151.928    58.125 5
  -152.679    56.881 6
  -152.394    58.112 7
  -152.218    57.296 8
  -154.515    58.556 9
  -151.725    58.210 10
  -151.237    57.446 11
  -153.305    58.159 12
  -152.603    56.500 13
  -152.624    56.531 14
  -152.490    56.498 15
  -151.401    56.799 16
  -152.879    58.283 17
  -153.617    58.148 18
  -152.924    58.456 19
  -153.774    57.461 20
  -151.402    58.323 21
  -152.513    57.842 22
  -155.031    58.489 23
  -152.694    58.037 24
  -151.398    58.022 25
  -153.608    58.680 26
  -153.363    57.220 27
  -153.637    58.104 28
  -152.898    58.240 29
  -155.193    58.758 30
  -151.830    58.051 31
  -153.531    58.694 32
  -155.184    58.256 33
  -153.022    58.641 34
  -153.640    57.943 35
  -152.896    57.779 36
  -151.909    57.562 37
  -153.218    57.854 38
  -154.509    58.141 39
  -154.095    58.467 40
  -153.695    57.312 41
  -151.595    58.271 42
  -151.782    58.217 43
  -154.872    58.457 44
  -154.225    57.356 45
  -154.238    57.343 46
  -152.691    57.510 47
  -154.190    57.390 48
  -154.251    57.409 49
  -153.570    58.585 50
  -153.759    57.819 51
  -152.346    57.998 52
  -153.934    58.009 53
  -154.959    57.292 54
  -155.378    57.783 55
  -153.233    58.380 56
  -155.963    58.307 57
  -153.451    57.975 58
  -154.272    58.637 59
  -155.056    57.635 60
  -155.158    58.691 61
  -151.632    58.168 62
  -154.785    57.309 63
  -152.947    56.983 64
  -153.050    56.993 65
  -154.653    58.154 66
  -154.619    57.907 67
  -151.341    58.250 68
  -153.085    58.230 69
  -153.764    57.900 70
  -154.849    58.097 71
  -153.148    58.682 72
  -152.012    58.212 73
  -154.305    57.308 74
  -155.260    57.209 75
  -151.480    58.339 76
  -152.925    56.544 77
  -152.034    58.426 78
  -154.556    57.406 79
  -153.723    56.638 80
  -153.130    57.727 81
  -155.147    58.639 82
  -153.350    58.625 83
  -152.605    56.538 84
  -152.509    56.465 85
  -152.206    57.580 86
  -153.592    58.693 87
  -153.296    58.679 88
  -153.544    56.966 89
  -152.253    58.265 90
  -154.816    57.653 91
  -155.709    57.612 92
  -152.897    57.545 93
  -151.773    56.974 94
  -155.296    57.694 95
  -152.951    58.409 96
  -154.572    58.555 97
  -152.639    56.464 98
  -153.536    57.611 99
  -152.521    58.521 100
  -154.236    58.368 101
  -152.603    58.157 102
  -153.618    58.444 103
  -151.554    58.292 104
  -153.184    58.447 105
  -153.239    58.085 106
  -153.875    57.709 107
  -152.369    57.399 108
  -154.239    57.345 109
  -154.793    58.186 110
  -152.912    56.829 111
  -153.376    56.530 112
  -152.901    56.294 113
  -154.111    57.721 114
  -153.723    58.510 115
  -154.180    56.985 116
  -153.548    58.115 117
  -155.189    58.225 118
  -153.190    58.618 119
  -154.299    58.544 120
  -155.247    58.726 121
  -151.738    58.180 122
  -153.859    58.690 123
  -153.939    58.774 124
  -152.647    58.705 125
  -151.869    58.057 126
  -153.938    57.656 127
  -152.913    56.912 128
  -153.454    58.705 129
  -154.079    56.560 130
  -155.033    56.798 131
  -155.075    56.810 132
  -155.028    56.828 133
  -153.942    58.432 134
  -152.837    56.869 135
  -153.670    58.609 136
  -151.874    58.176 137
  -154.045    56.385 138
  -153.244    56.105 139
  -152.934    58.201 140
  -151.539    58.251 141
  -154.956    58.346 142
  -153.600    58.298 143
  -154.816    57.833 144
  -155.377    58.548 145
  -153.711    58.739 146
  -154.154    58.493 147
  -154.453    57.205 148
  -153.386    56.726 149
  -155.173    58.647 150
  -152.277    58.055 151
  -153.068    56.822 152
  -155.006    58.148 153
  -154.125    58.666 154
  -155.216    57.051 155
  -151.821    58.103 156
  -155.282    58.568 157
  -154.830    56.591 158
  -153.286    58.070 159
  -154.042    57.716 160
  -153.697    58.018 161
  -154.691    58.162 162
  -152.078    58.011 163
  -154.997    57.548 164
  -154.143    58.446 165
  -154.145    58.454 166
  -155.212    57.022 167
  -154.128    57.718 168
  -154.089    57.528 169
  -154.120    57.933 170
  -154.017    56.632 171
  -153.548    58.467 172
  -154.916    58.020 173
  -152.494    57.285 174
  -153.611    57.929 175
  -151.604    58.103 176
  -153.440    57.847 177
  -154.027    57.640 178
  -154.359    57.672 179
  -152.075    58.093 180
  -154.112    58.055 181
  -155.503    58.148 182
  -154.381    56.816 183
  -154.083    58.573 184
  -152.510    58.358 185
  -151.456    58.251 186
  -153.219    56.772 187
  -155.304    58.583 188
  -155.465    56.598 189
  -154.642    58.143 190
  -151.710    58.144 191
  -154.501    57.628 192
  -152.949    58.477 193
  -152.459    58.909 194
  -154.123    58.532 195
  -152.968    57.721 196
  -153.034    58.298 197
  -153.593    57.837 198
  -155.196    56.609 199
  -154.828    57.853 200
  -154.738    58.122 201
  -154.548    57.773 202
  -151.415    58.324 203
  -153.935    58.014 204
  -153.207    56.404 205
  -153.229    56.404 206
  -154.603    58.127 207
  -155.220    56.755 208
  -154.628    58.134 209
  -153.769    58.196 210
  -153.645    58.694 211
  -154.203    57.229 212
  -152.619    58.273 213
  -154.953    58.693 214
  -152.254    56.805 215
  -154.271    56.218 216
  -151.907    58.235 217
  -154.556    58.133 218
  -152.337    57.266 219
  -154.105    57.103 220
  -154.020    57.384 221
  -155.038    57.471 222
  -155.063    57.542 223
  -154.770    58.485 224
  -152.766    58.375 225
  -151.344    58.388 226
  -152.579    56.908 227
  -152.538    56.982 228
  -152.580    57.013 229
  -151.394    58.338 230
  -154.300    57.784 231
  -155.218    58.216 232
  -154.825    56.524 233
  -153.025    58.336 234
  -154.612    56.497 235
  -153.650    58.473 236
  -155.105    58.648 237
  -154.487    57.731 238
  -154.679    57.312 239
  -151.599    58.206 240
  -155.485    58.569 241
  -152.878    58.363 242
  -155.044    57.732 243
  -155.039    57.721 244
  -154.491    57.984 245
  -155.240    58.282 246
  -152.997    57.574 247
  -152.987    57.576 248
  -151.997    58.210 249
  -153.116    56.899 250
  -153.588    58.395 251
  -154.815    58.078 252
  -154.428    56.815 253
  -154.347    56.305 254
  -154.316    56.204 255
  -154.216    58.046 256
  -152.873    57.862 257
  -155.010    56.830 258
  -151.154    58.627 259
  -155.443    58.202 260
  -155.089    58.714 261
  -155.128    57.544 262
  -153.348    56.328 263
  -153.368    56.293 264
  -153.335    56.198 265
  -154.013    58.306 266
  -152.922    58.203 267
  -155.254    58.300 268
  -155.510    57.647 269
  -155.499    57.656 270
  -155.537    57.670 271
  -152.524    57.824 272
  -151.150    58.385 273
  -152.595    56.920 274
  -153.083    58.658 275
  -155.292    57.278 276
  -154.071    58.188 277
  -155.508    57.278 278
  -151.623    58.288 279
  -153.230    58.628 280
  -154.782    56.519 281
  -153.988    56.367 282
  -153.175    58.368 283
  -154.090    58.565 284
  -153.927    58.655 285
  -155.309    58.359 286
  -154.556    57.347 287
  -152.579    58.001 288
  -155.365    57.342 289
  -153.972    58.167 290
  -153.085    58.294 291
  -155.259    58.489 292
  -155.083    58.610 293
  -154.263    58.092 294
  -155.925    57.938 295
  -154.309    56.374 296
  -153.069    56.777 297
  -152.658    57.984 298
  -155.024    57.084 299
  -151.301    58.346 300
  -151.326    58.322 301
  -151.487    58.563 302
  -153.614    58.454 303
  -154.277    57.927 304
  -154.649    57.606 305
  -152.147    58.131 306
  -153.012    58.207 307
  -154.011    58.223 308
  -151.478    58.302 309
  -154.235    58.477 310
  -153.512    57.826 311
  -153.583    58.670 312
  -152.358    57.626 313
  -154.288    57.622 314
  -151.381    58.470 315
  -151.328    58.523 316
  -154.173    58.096 317
  -152.583    58.269 318
  -153.858    58.650 319
  -153.485    56.162 320
  -153.452    56.277 321
  -153.449    56.087 322
  -153.400    56.205 323
  -153.370    56.092 324
  -153.354    56.076 325
  -154.619    56.017 326
  -152.799    58.429 327
  -154.501    56.288 328
  -153.917    58.328 329
  -154.955    56.553 330
  -153.798    56.247 331
  -153.797    56.180 332
  -155.175    57.328 333
  -153.668    56.277 334
  -153.847    57.511 335
  -154.190    57.099 336
  -153.202    57.641 337
  -153.081    56.221 338
  -154.931    57.838 339
  -154.586    58.124 340
  -151.503    58.268 341
  -153.609    57.830 342
  -153.502    58.082 343
  -153.956    58.651 344
  -154.811    57.454 345
  -154.615    56.273 346
  -154.825    57.451 347
  -154.039    58.087 348
  -155.112    58.183 349
  -154.408    57.335 350
  -153.846    57.659 351
  -155.489    57.031 352
  -153.496    58.607 353
  -155.057    57.137 354
  -155.077    57.127 355
  -153.540    58.578 356
  -154.885    57.653 357
  -151.717    58.289 358
  -154.806    57.189 359
  -154.203    58.258 360
  -153.757    58.248 361
  -154.314    56.477 362
  -151.788    57.995 363
  -153.172    58.442 364
  -155.272    57.945 365
  -155.338    58.478 366
  -154.421    58.081 367
  -154.416    58.085 368
  -153.162    58.737 369
  -154.729    58.476 370
  -153.137    56.786 371
  -154.950    57.269 372
  -155.277    57.776 373
  -153.734    58.780 374
  -152.561    58.610 375
  -151.722    58.206 376
  -154.523    58.549 377
  -154.161    58.721 378
  -155.360    58.158 379
  -153.535    57.321 380
  -154.400    57.061 381
  -154.170    57.349 382
  -152.534    58.684 383
  -153.970    57.961 384
  -153.714    58.535 385
  -153.716    58.344 386
  -151.887    58.342 387
  -154.542    58.136 388
  -155.188    57.531 389
  -154.882    57.227 390
  -153.358    58.515 391
  -153.874    57.752 392
  -152.819    57.709 393
  -153.979    57.741 394
  -153.531    58.123 395
  -153.641    58.626 396
  -153.322    58.541 397
  -155.073    58.290 398
  -153.250    58.508 399
  -154.185    57.493 400
  -154.064    58.642 401
  -155.775    58.405 402
  -153.879    57.737 403
  -155.199    58.242 404
  -153.198    57.586 405
  -154.888    57.503 406
  -154.580    57.469 407
  -155.217    58.239 408
  -154.145    57.248 409
  -154.566    57.763 410
  -155.148    58.257 411
  -155.003    57.744 412
  -153.129    57.524 413
  -155.472    57.196 414
  -154.007    58.557 415
  -155.230    58.239 416
  -153.292    58.597 417
  -155.117    58.261 418
  -155.173    58.251 419
  -155.158    58.256 420
  -155.150    58.267 421
  -153.697    58.122 422
  -155.138    58.280 423
  -154.634    58.135 424
  -154.785    58.182 425
  -154.923    57.721 426
  -154.937    57.452 427
  -155.016    57.900 428
  -153.420    57.398 429
  -155.134    58.262 430
  -152.622    57.527 431
  -154.279    57.273 432
  -154.900    57.986 433
  -154.451    57.671 434
  -152.268    57.503 435
  -151.844    58.412 436
  -155.222    58.538 437
  -153.831    58.713 438
  -152.543    58.212 439
  -153.317    56.008 440
  -153.308    57.628 441
  -152.909    56.810 442
  -153.785    57.268 443
  -153.661    57.269 444
  -155.039    58.691 445
  -154.130    58.288 446
  -153.762    56.575 447
  -155.152    58.619 448
  -154.772    58.599 449
  -154.697    56.919 450
  -154.730    56.957 451
  -153.487    58.644 452
  -155.160    58.497 453
  -154.735    56.987 454
  -155.185    58.129 455
  -152.993    56.889 456
  -153.009    56.853 457
  -153.015    56.853 458
  -152.679    57.901 459
  -153.994    56.097 460
  -154.080    56.110 461
  -154.009    56.146 462
  -153.316    57.780 463
  -152.783    58.340 464
  -154.011    57.976 465
  -152.629    58.448 466
  -151.528    58.132 467
  -153.173    58.135 468
  -154.989    58.285 469
  -154.883    56.943 470
  -154.834    56.886 471
  -152.526    57.767 472
  -152.643    58.689 473
  -155.408    57.245 474
  -155.404    57.204 475
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -151.330    57.256
  -151.257    56.978
>
  -151.548    57.378
  -151.183    57.359
>
  -151.632    57.631
  -151.357    57.570
>
  -151.944    57.280
  -151.852    57.134
>
  -152.477    58.111
  -151.928    58.125
>
  -152.937    57.034
  -152.679    56.881
>
  -152.570    58.056
  -152.394    58.112
>
  -152.447    57.288
  -152.218    57.296
>
  -154.799    58.672
  -154.515    58.556
>
  -151.904    58.280
  -151.725    58.210
>
  -151.440    57.510
  -151.237    57.446
>
  -153.540    58.224
  -153.305    58.159
>
  -152.834    56.492
  -152.603    56.500
>
  -152.727    56.629
  -152.624    56.531
>
  -152.699    56.508
  -152.490    56.498
>
  -151.801    56.829
  -151.401    56.799
>
  -153.018    58.323
  -152.879    58.283
>
  -153.619    58.144
  -153.617    58.148
>
  -153.090    58.489
  -152.924    58.456
>
  -153.849    57.423
  -153.774    57.461
>
  -151.281    58.367
  -151.402    58.323
>
  -152.303    57.782
  -152.513    57.842
>
  -154.947    58.546
  -155.031    58.489
>
  -152.624    58.130
  -152.694    58.037
>
  -151.340    58.051
  -151.398    58.022
>
  -153.544    58.690
  -153.608    58.680
>
  -153.273    57.230
  -153.363    57.220
>
  -153.525    58.097
  -153.637    58.104
>
  -152.811    58.184
  -152.898    58.240
>
  -155.158    58.739
  -155.193    58.758
>
  -151.712    58.049
  -151.830    58.051
>
  -153.503    58.661
  -153.531    58.694
>
  -155.273    58.316
  -155.184    58.256
>
  -152.996    58.672
  -153.022    58.641
>
  -153.615    57.891
  -153.640    57.943
>
  -152.871    57.674
  -152.896    57.779
>
  -151.785    57.525
  -151.909    57.562
>
  -153.103    57.828
  -153.218    57.854
>
  -154.489    58.122
  -154.509    58.141
>
  -154.047    58.456
  -154.095    58.467
>
  -153.828    57.353
  -153.695    57.312
>
  -151.432    58.274
  -151.595    58.271
>
  -151.778    58.291
  -151.782    58.217
>
  -154.805    58.443
  -154.872    58.457
>
  -154.322    57.468
  -154.225    57.356
>
  -154.426    57.398
  -154.238    57.343
>
  -152.714    57.586
  -152.691    57.510
>
  -154.463    57.406
  -154.190    57.390
>
  -154.363    57.425
  -154.251    57.409
>
  -153.521    58.587
  -153.570    58.585
>
  -153.806    57.894
  -153.759    57.819
>
  -152.196    57.946
  -152.346    57.998
>
  -153.967    58.024
  -153.934    58.009
>
  -155.107    57.384
  -154.959    57.292
>
  -155.555    57.835
  -155.378    57.783
>
  -153.171    58.339
  -153.233    58.380
>
  -155.953    58.321
  -155.963    58.307
>
  -153.315    57.938
  -153.451    57.975
>
  -154.263    58.675
  -154.272    58.637
>
  -155.015    57.594
  -155.056    57.635
>
  -155.122    58.678
  -155.158    58.691
>
  -151.619    58.253
  -151.632    58.168
>
  -154.934    57.353
  -154.785    57.309
>
  -153.111    57.052
  -152.947    56.983
>
  -153.261    57.119
  -153.050    56.993
>
  -154.630    58.215
  -154.653    58.154
>
  -154.640    57.949
  -154.619    57.907
>
  -151.418    58.304
  -151.341    58.250
>
  -152.989    58.273
  -153.085    58.230
>
  -153.698    57.948
  -153.764    57.900
>
  -154.745    58.052
  -154.849    58.097
>
  -153.182    58.694
  -153.148    58.682
>
  -152.031    58.233
  -152.012    58.212
>
  -154.202    57.558
  -154.305    57.308
>
  -155.224    57.369
  -155.260    57.209
>
  -151.638    58.393
  -151.480    58.339
>
  -153.229    56.585
  -152.925    56.544
>
  -152.061    58.448
  -152.034    58.426
>
  -154.585    57.486
  -154.556    57.406
>
  -153.531    56.510
  -153.723    56.638
>
  -153.099    57.795
  -153.130    57.727
>
  -155.112    58.628
  -155.147    58.639
>
  -153.292    58.669
  -153.350    58.625
>
  -152.759    56.515
  -152.605    56.538
>
  -152.619    56.556
  -152.509    56.465
>
  -152.130    57.543
  -152.206    57.580
>
  -153.618    58.700
  -153.592    58.693
>
  -153.265    58.695
  -153.296    58.679
>
  -153.678    57.006
  -153.544    56.966
>
  -152.201    58.298
  -152.253    58.265
>
  -154.741    57.645
  -154.816    57.653
>
  -155.725    57.675
  -155.709    57.612
>
  -152.744    57.472
  -152.897    57.545
>
  -151.748    57.169
  -151.773    56.974
>
  -155.255    57.700
  -155.296    57.694
>
  -152.896    58.410
  -152.951    58.409
>
  -154.467    58.532
  -154.572    58.555
>
  -152.707    56.492
  -152.639    56.464
>
  -153.570    57.640
  -153.536    57.611
>
  -152.490    58.519
  -152.521    58.521
>
  -154.289    58.367
  -154.236    58.368
>
  -152.507    58.145
  -152.603    58.157
>
  -153.582    58.446
  -153.618    58.444
>
  -151.622    58.313
  -151.554    58.292
>
  -153.122    58.458
  -153.184    58.447
>
  -153.195    58.136
  -153.239    58.085
>
  -154.012    57.740
  -153.875    57.709
>
  -152.346    57.498
  -152.369    57.399
>
  -154.274    57.382
  -154.239    57.345
>
  -154.785    58.193
  -154.793    58.186
>
  -152.932    56.942
  -152.912    56.829
>
  -153.419    56.548
  -153.376    56.530
>
  -152.938    56.345
  -152.901    56.294
>
  -154.073    57.726
  -154.111    57.721
>
  -153.733    58.509
  -153.723    58.510
>
  -154.279    57.018
  -154.180    56.985
>
  -153.474    58.038
  -153.548    58.115
>
  -155.159    58.253
  -155.189    58.225
>
  -153.113    58.612
  -153.190    58.618
>
  -154.296    58.544
  -154.299    58.544
>
  -155.267    58.756
  -155.247    58.726
>
  -151.616    58.186
  -151.738    58.180
>
  -153.879    58.735
  -153.859    58.690
>
  -153.881    58.754
  -153.939    58.774
>
  -152.556    58.676
  -152.647    58.705
>
  -151.855    58.108
  -151.869    58.057
>
  -153.874    57.722
  -153.938    57.656
>
  -152.900    56.939
  -152.913    56.912
>
  -153.372    58.727
  -153.454    58.705
>
  -154.028    56.534
  -154.079    56.560
>
  -155.022    56.785
  -155.033    56.798
>
  -155.245    56.832
  -155.075    56.810
>
  -154.935    56.887
  -155.028    56.828
>
  -153.834    58.410
  -153.942    58.432
>
  -152.854    56.956
  -152.837    56.869
>
  -153.657    58.596
  -153.670    58.609
>
  -151.771    58.168
  -151.874    58.176
>
  -153.943    56.270
  -154.045    56.385
>
  -153.134    56.118
  -153.244    56.105
>
  -152.890    58.188
  -152.934    58.201
>
  -151.418    58.203
  -151.539    58.251
>
  -154.846    58.395
  -154.956    58.346
>
  -153.605    58.285
  -153.600    58.298
>
  -154.822    57.842
  -154.816    57.833
>
  -155.301    58.493
  -155.377    58.548
>
  -153.689    58.693
  -153.711    58.739
>
  -154.068    58.444
  -154.154    58.493
>
  -154.563    57.290
  -154.453    57.205
>
  -153.360    56.665
  -153.386    56.726
>
  -155.087    58.640
  -155.173    58.647
>
  -152.118    58.021
  -152.277    58.055
>
  -152.998    56.812
  -153.068    56.822
>
  -155.007    58.090
  -155.006    58.148
>
  -154.063    58.596
  -154.125    58.666
>
  -155.302    57.102
  -155.216    57.051
>
  -151.729    58.072
  -151.821    58.103
>
  -155.158    58.496
  -155.282    58.568
>
  -154.888    56.604
  -154.830    56.591
>
  -153.172    58.054
  -153.286    58.070
>
  -154.020    57.711
  -154.042    57.716
>
  -153.665    57.995
  -153.697    58.018
>
  -154.612    58.170
  -154.691    58.162
>
  -151.941    58.012
  -152.078    58.011
>
  -154.946    57.546
  -154.997    57.548
>
  -154.132    58.410
  -154.143    58.446
>
  -154.127    58.403
  -154.145    58.454
>
  -155.237    57.047
  -155.212    57.022
>
  -154.116    57.833
  -154.128    57.718
>
  -154.227    57.523
  -154.089    57.528
>
  -154.147    57.927
  -154.120    57.933
>
  -154.095    56.601
  -154.017    56.632
>
  -153.520    58.412
  -153.548    58.467
>
  -154.954    57.970
  -154.916    58.020
>
  -152.500    57.268
  -152.494    57.285
>
  -153.502    57.902
  -153.611    57.929
>
  -151.449    58.022
  -151.604    58.103
>
  -153.415    57.825
  -153.440    57.847
>
  -154.064    57.620
  -154.027    57.640
>
  -154.366    57.651
  -154.359    57.672
>
  -151.925    58.089
  -152.075    58.093
>
  -154.095    58.026
  -154.112    58.055
>
  -155.415    58.130
  -155.503    58.148
>
  -154.391    56.808
  -154.381    56.816
>
  -154.010    58.574
  -154.083    58.573
>
  -152.431    58.341
  -152.510    58.358
>
  -151.361    58.198
  -151.456    58.251
>
  -153.191    56.776
  -153.219    56.772
>
  -155.272    58.576
  -155.304    58.583
>
  -155.490    56.588
  -155.465    56.598
>
  -154.523    58.133
  -154.642    58.143
>
  -151.418    58.068
  -151.710    58.144
>
  -154.473    57.635
  -154.501    57.628
>
  -152.881    58.380
  -152.949    58.477
>
  -152.412    58.916
  -152.459    58.909
>
  -154.131    58.495
  -154.123    58.532
>
  -152.764    57.642
  -152.968    57.721
>
  -153.013    58.282
  -153.034    58.298
>
  -153.615    57.836
  -153.593    57.837
>
  -155.212    56.586
  -155.196    56.609
>
  -154.842    57.855
  -154.828    57.853
>
  -154.781    58.106
  -154.738    58.122
>
  -154.577    57.743
  -154.548    57.773
>
  -151.237    58.208
  -151.415    58.324
>
  -153.925    58.017
  -153.935    58.014
>
  -153.256    56.383
  -153.207    56.404
>
  -153.241    56.291
  -153.229    56.404
>
  -154.644    58.091
  -154.603    58.127
>
  -155.228    56.772
  -155.220    56.755
>
  -154.666    58.094
  -154.628    58.134
>
  -153.802    58.169
  -153.769    58.196
>
  -153.646    58.671
  -153.645    58.694
>
  -154.195    57.208
  -154.203    57.229
>
  -152.595    58.243
  -152.619    58.273
>
  -154.906    58.703
  -154.953    58.693
>
  -152.282    56.763
  -152.254    56.805
>
  -154.321    56.208
  -154.271    56.218
>
  -151.844    58.208
  -151.907    58.235
>
  -154.570    58.102
  -154.556    58.133
>
  -152.293    57.234
  -152.337    57.266
>
  -154.203    57.165
  -154.105    57.103
>
  -154.005    57.421
  -154.020    57.384
>
  -154.971    57.542
  -155.038    57.471
>
  -154.978    57.507
  -155.063    57.542
>
  -154.758    58.452
  -154.770    58.485
>
  -152.756    58.342
  -152.766    58.375
>
  -151.198    58.331
  -151.344    58.388
>
  -152.569    56.940
  -152.579    56.908
>
  -152.709    56.814
  -152.538    56.982
>
  -152.538    56.970
  -152.580    57.013
>
  -151.330    58.301
  -151.394    58.338
>
  -154.289    57.830
  -154.300    57.784
>
  -155.192    58.198
  -155.218    58.216
>
  -154.758    56.536
  -154.825    56.524
>
  -153.016    58.306
  -153.025    58.336
>
  -154.659    56.461
  -154.612    56.497
>
  -153.682    58.502
  -153.650    58.473
>
  -155.104    58.612
  -155.105    58.648
>
  -154.429    57.725
  -154.487    57.731
>
  -154.714    57.298
  -154.679    57.312
>
  -151.572    58.167
  -151.599    58.206
>
  -155.494    58.556
  -155.485    58.569
>
  -152.817    58.390
  -152.878    58.363
>
  -155.039    57.736
  -155.044    57.732
>
  -155.059    57.713
  -155.039    57.721
>
  -154.396    57.970
  -154.491    57.984
>
  -155.158    58.249
  -155.240    58.282
>
  -152.961    57.576
  -152.997    57.574
>
  -152.971    57.566
  -152.987    57.576
>
  -151.896    58.150
  -151.997    58.210
>
  -153.008    56.883
  -153.116    56.899
>
  -153.586    58.401
  -153.588    58.395
>
  -154.849    58.058
  -154.815    58.078
>
  -154.504    56.878
  -154.428    56.815
>
  -154.361    56.177
  -154.347    56.305
>
  -154.317    56.148
  -154.316    56.204
>
  -154.153    58.042
  -154.216    58.046
>
  -152.826    57.805
  -152.873    57.862
>
  -155.115    56.883
  -155.010    56.830
>
  -151.125    58.632
  -151.154    58.627
>
  -155.383    58.236
  -155.443    58.202
>
  -155.070    58.707
  -155.089    58.714
>
  -155.147    57.539
  -155.128    57.544
>
  -153.440    56.257
  -153.348    56.328
>
  -153.380    56.239
  -153.368    56.293
>
  -153.401    56.213
  -153.335    56.198
>
  -154.036    58.270
  -154.013    58.306
>
  -152.874    58.159
  -152.922    58.203
>
  -155.143    58.296
  -155.254    58.300
>
  -155.481    57.643
  -155.510    57.647
>
  -155.464    57.652
  -155.499    57.656
>
  -155.361    57.611
  -155.537    57.670
>
  -152.450    57.751
  -152.524    57.824
>
  -151.026    58.346
  -151.150    58.385
>
  -152.453    56.831
  -152.595    56.920
>
  -153.038    58.648
  -153.083    58.658
>
  -155.240    57.245
  -155.292    57.278
>
  -154.083    58.166
  -154.071    58.188
>
  -155.486    57.316
  -155.508    57.278
>
  -151.506    58.225
  -151.623    58.288
>
  -153.159    58.645
  -153.230    58.628
>
  -154.836    56.507
  -154.782    56.519
>
  -153.958    56.337
  -153.988    56.367
>
  -153.154    58.410
  -153.175    58.368
>
  -154.101    58.652
  -154.090    58.565
>
  -153.940    58.645
  -153.927    58.655
>
  -155.355    58.447
  -155.309    58.359
>
  -154.559    57.362
  -154.556    57.347
>
  -152.497    57.963
  -152.579    58.001
>
  -155.372    57.315
  -155.365    57.342
>
  -153.971    58.134
  -153.972    58.167
>
  -153.095    58.263
  -153.085    58.294
>
  -155.286    58.465
  -155.259    58.489
>
  -155.100    58.631
  -155.083    58.610
>
  -154.274    58.067
  -154.263    58.092
>
  -155.857    57.965
  -155.925    57.938
>
  -154.315    56.310
  -154.309    56.374
>
  -153.062    56.792
  -153.069    56.777
>
  -152.625    57.942
  -152.658    57.984
>
  -155.037    57.097
  -155.024    57.084
>
  -151.321    58.326
  -151.301    58.346
>
  -151.256    58.286
  -151.326    58.322
>
  -151.432    58.531
  -151.487    58.563
>
  -153.599    58.433
  -153.614    58.454
>
  -154.297    57.914
  -154.277    57.927
>
  -154.641    57.618
  -154.649    57.606
>
  -152.081    58.123
  -152.147    58.131
>
  -152.949    58.207
  -153.012    58.207
>
  -153.986    58.221
  -154.011    58.223
>
  -151.356    58.263
  -151.478    58.302
>
  -154.215    58.496
  -154.235    58.477
>
  -153.573    57.807
  -153.512    57.826
>
  -153.557    58.639
  -153.583    58.670
>
  -152.292    57.575
  -152.358    57.626
>
  -154.328    57.601
  -154.288    57.622
>
  -151.364    58.440
  -151.381    58.470
>
  -151.276    58.488
  -151.328    58.523
>
  -154.163    58.091
  -154.173    58.096
>
  -152.534    58.244
  -152.583    58.269
>
  -153.828    58.644
  -153.858    58.650
>
  -153.536    56.161
  -153.485    56.162
>
  -153.626    56.194
  -153.452    56.277
>
  -153.468    56.066
  -153.449    56.087
>
  -153.495    56.125
  -153.400    56.205
>
  -153.432    56.066
  -153.370    56.092
>
  -153.332    56.039
  -153.354    56.076
>
  -154.675    55.976
  -154.619    56.017
>
  -152.797    58.418
  -152.799    58.429
>
  -154.551    56.211
  -154.501    56.288
>
  -153.917    58.335
  -153.917    58.328
>
  -154.932    56.501
  -154.955    56.553
>
  -153.920    56.099
  -153.798    56.247
>
  -153.677    56.031
  -153.797    56.180
>
  -155.192    57.361
  -155.175    57.328
>
  -153.812    56.063
  -153.668    56.277
>
  -153.884    57.513
  -153.847    57.511
>
  -154.148    57.130
  -154.190    57.099
>
  -153.173    57.588
  -153.202    57.641
>
  -153.087    56.176
  -153.081    56.221
>
  -154.947    57.840
  -154.931    57.838
>
  -154.560    58.096
  -154.586    58.124
>
  -151.420    58.219
  -151.503    58.268
>
  -153.552    57.814
  -153.609    57.830
>
  -153.483    58.052
  -153.502    58.082
>
  -153.982    58.633
  -153.956    58.651
>
  -154.803    57.448
  -154.811    57.454
>
  -154.694    56.283
  -154.615    56.273
>
  -154.755    57.469
  -154.825    57.451
>
  -153.951    58.104
  -154.039    58.087
>
  -155.121    58.160
  -155.112    58.183
>
  -154.375    57.336
  -154.408    57.335
>
  -153.914    57.642
  -153.846    57.659
>
  -155.442    57.058
  -155.489    57.031
>
  -153.444    58.596
  -153.496    58.607
>
  -155.130    57.167
  -155.057    57.137
>
  -155.054    57.123
  -155.077    57.127
>
  -153.577    58.553
  -153.540    58.578
>
  -154.789    57.660
  -154.885    57.653
>
  -151.668    58.274
  -151.717    58.289
>
  -154.817    57.182
  -154.806    57.189
>
  -154.199    58.244
  -154.203    58.258
>
  -153.751    58.223
  -153.757    58.248
>
  -154.404    56.522
  -154.314    56.477
>
  -151.695    57.981
  -151.788    57.995
>
  -153.154    58.421
  -153.172    58.442
>
  -155.277    57.929
  -155.272    57.945
>
  -155.335    58.474
  -155.338    58.478
>
  -154.412    58.089
  -154.421    58.081
>
  -154.407    58.091
  -154.416    58.085
>
  -153.124    58.696
  -153.162    58.737
>
  -154.683    58.472
  -154.729    58.476
>
  -153.065    56.792
  -153.137    56.786
>
  -154.999    57.296
  -154.950    57.269
>
  -155.226    57.709
  -155.277    57.776
>
  -153.624    58.757
  -153.734    58.780
>
  -152.489    58.678
  -152.561    58.610
>
  -151.571    58.218
  -151.722    58.206
>
  -154.451    58.539
  -154.523    58.549
>
  -154.191    58.729
  -154.161    58.721
>
  -155.312    58.167
  -155.360    58.158
>
  -153.446    57.296
  -153.535    57.321
>
  -154.407    57.051
  -154.400    57.061
>
  -154.166    57.355
  -154.170    57.349
>
  -152.470    58.659
  -152.534    58.684
>
  -153.939    57.986
  -153.970    57.961
>
  -153.740    58.512
  -153.714    58.535
>
  -153.760    58.346
  -153.716    58.344
>
  -151.803    58.279
  -151.887    58.342
>
  -154.549    58.117
  -154.542    58.136
>
  -155.188    57.508
  -155.188    57.531
>
  -154.840    57.265
  -154.882    57.227
>
  -153.300    58.485
  -153.358    58.515
>
  -153.910    57.761
  -153.874    57.752
>
  -152.777    57.682
  -152.819    57.709
>
  -153.956    57.744
  -153.979    57.741
>
  -153.471    58.119
  -153.531    58.123
>
  -153.659    58.598
  -153.641    58.626
>
  -153.318    58.521
  -153.322    58.541
>
  -155.038    58.273
  -155.073    58.290
>
  -153.198    58.467
  -153.250    58.508
>
  -154.171    57.512
  -154.185    57.493
>
  -154.107    58.647
  -154.064    58.642
>
  -155.776    58.426
  -155.775    58.405
>
  -153.882    57.709
  -153.879    57.737
>
  -155.193    58.249
  -155.199    58.242
>
  -153.195    57.611
  -153.198    57.586
>
  -154.951    57.521
  -154.888    57.503
>
  -154.603    57.467
  -154.580    57.469
>
  -155.197    58.238
  -155.217    58.239
>
  -154.104    57.230
  -154.145    57.248
>
  -154.511    57.756
  -154.566    57.763
>
  -155.131    58.265
  -155.148    58.257
>
  -154.958    57.735
  -155.003    57.744
>
  -153.058    57.493
  -153.129    57.524
>
  -155.427    57.132
  -155.472    57.196
>
  -154.037    58.559
  -154.007    58.557
>
  -155.210    58.240
  -155.230    58.239
>
  -153.300    58.597
  -153.292    58.597
>
  -155.101    58.273
  -155.117    58.261
>
  -155.145    58.232
  -155.173    58.251
>
  -155.114    58.257
  -155.158    58.256
>
  -155.112    58.277
  -155.150    58.267
>
  -153.672    58.105
  -153.697    58.122
>
  -155.062    58.268
  -155.138    58.280
>
  -154.694    58.165
  -154.634    58.135
>
  -154.785    58.166
  -154.785    58.182
>
  -154.910    57.703
  -154.923    57.721
>
  -154.954    57.445
  -154.937    57.452
>
  -154.997    57.895
  -155.016    57.900
>
  -153.401    57.381
  -153.420    57.398
>
  -155.131    58.276
  -155.134    58.262
>
  -152.578    57.484
  -152.622    57.527
>
  -154.574    57.627
  -154.279    57.273
>
  -154.902    57.983
  -154.900    57.986
>
  -154.440    57.695
  -154.451    57.671
>
  -152.155    57.448
  -152.268    57.503
>
  -151.758    58.362
  -151.844    58.412
>
  -155.212    58.507
  -155.222    58.538
>
  -153.876    58.692
  -153.831    58.713
>
  -152.585    58.199
  -152.543    58.212
>
  -153.236    55.965
  -153.317    56.008
>
  -153.302    57.623
  -153.308    57.628
>
  -152.846    56.754
  -152.909    56.810
>
  -153.782    57.234
  -153.785    57.268
>
  -153.695    57.299
  -153.661    57.269
>
  -155.045    58.683
  -155.039    58.691
>
  -154.135    58.271
  -154.130    58.288
>
  -153.594    56.536
  -153.762    56.575
>
  -155.154    58.637
  -155.152    58.619
>
  -154.714    58.601
  -154.772    58.599
>
  -154.740    56.950
  -154.697    56.919
>
  -154.751    56.952
  -154.730    56.957
>
  -153.468    58.632
  -153.487    58.644
>
  -155.122    58.494
  -155.160    58.497
>
  -154.688    56.984
  -154.735    56.987
>
  -155.212    58.129
  -155.185    58.129
>
  -152.944    56.824
  -152.993    56.889
>
  -152.701    56.707
  -153.009    56.853
>
  -152.786    56.684
  -153.015    56.853
>
  -152.610    57.839
  -152.679    57.901
>
  -154.113    55.954
  -153.994    56.097
>
  -154.152    56.009
  -154.080    56.110
>
  -154.146    56.058
  -154.009    56.146
>
  -153.271    57.741
  -153.316    57.780
>
  -152.724    58.286
  -152.783    58.340
>
  -154.035    57.954
  -154.011    57.976
>
  -152.548    58.407
  -152.629    58.448
>
  -151.397    58.050
  -151.528    58.132
>
  -153.225    58.171
  -153.173    58.135
>
  -155.041    58.270
  -154.989    58.285
>
  -154.905    56.956
  -154.883    56.943
>
  -154.758    56.832
  -154.834    56.886
>
  -152.424    57.643
  -152.526    57.767
>
  -152.599    58.676
  -152.643    58.689
>
  -155.393    57.260
  -155.408    57.245
>
  -155.413    57.213
  -155.404    57.204
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -151.259    56.979
  -151.257    56.978
>
  -151.182    57.360
  -151.183    57.359
>
  -151.356    57.571
  -151.357    57.570
>
  -151.865    57.128
  -151.852    57.134
>
  -151.928    58.124
  -151.928    58.125
>
  -152.681    56.877
  -152.679    56.881
>
  -152.399    58.113
  -152.394    58.112
>
  -152.219    57.297
  -152.218    57.296
>
  -154.519    58.553
  -154.515    58.556
>
  -151.724    58.211
  -151.725    58.210
>
  -151.240    57.446
  -151.237    57.446
>
  -153.308    58.159
  -153.305    58.159
>
  -152.602    56.498
  -152.603    56.500
>
  -152.625    56.528
  -152.624    56.531
>
  -152.492    56.494
  -152.490    56.498
>
  -151.400    56.797
  -151.401    56.799
>
  -152.879    58.282
  -152.879    58.283
>
  -153.617    58.147
  -153.617    58.148
>
  -152.926    58.457
  -152.924    58.456
>
  -153.776    57.462
  -153.774    57.461
>
  -151.398    58.329
  -151.402    58.323
>
  -152.513    57.843
  -152.513    57.842
>
  -155.032    58.489
  -155.031    58.489
>
  -152.695    58.037
  -152.694    58.037
>
  -151.398    58.021
  -151.398    58.022
>
  -153.609    58.680
  -153.608    58.680
>
  -153.363    57.220
  -153.363    57.220
>
  -153.639    58.104
  -153.637    58.104
>
  -152.899    58.240
  -152.898    58.240
>
  -155.193    58.756
  -155.193    58.758
>
  -151.831    58.050
  -151.830    58.051
>
  -153.531    58.694
  -153.531    58.694
>
  -155.185    58.256
  -155.184    58.256
>
  -153.023    58.640
  -153.022    58.641
>
  -153.643    57.945
  -153.640    57.943
>
  -152.897    57.780
  -152.896    57.779
>
  -151.909    57.562
  -151.909    57.562
>
  -153.219    57.854
  -153.218    57.854
>
  -154.510    58.141
  -154.509    58.141
>
  -154.096    58.466
  -154.095    58.467
>
  -153.695    57.312
  -153.695    57.312
>
  -151.595    58.266
  -151.595    58.271
>
  -151.781    58.217
  -151.782    58.217
>
  -154.873    58.456
  -154.872    58.457
>
  -154.221    57.366
  -154.225    57.356
>
  -154.239    57.343
  -154.238    57.343
>
  -152.692    57.510
  -152.691    57.510
>
  -154.190    57.390
  -154.190    57.390
>
  -154.252    57.408
  -154.251    57.409
>
  -153.570    58.584
  -153.570    58.585
>
  -153.759    57.819
  -153.759    57.819
>
  -152.347    57.998
  -152.346    57.998
>
  -153.935    58.009
  -153.934    58.009
>
  -154.960    57.292
  -154.959    57.292
>
  -155.379    57.782
  -155.378    57.783
>
  -153.234    58.379
  -153.233    58.380
>
  -155.966    58.307
  -155.963    58.307
>
  -153.450    57.975
  -153.451    57.975
>
  -154.273    58.637
  -154.272    58.637
>
  -155.057    57.633
  -155.056    57.635
>
  -155.157    58.690
  -155.158    58.691
>
  -151.634    58.168
  -151.632    58.168
>
  -154.788    57.308
  -154.785    57.309
>
  -152.946    56.984
  -152.947    56.983
>
  -153.051    56.992
  -153.050    56.993
>
  -154.654    58.154
  -154.653    58.154
>
  -154.619    57.906
  -154.619    57.907
>
  -151.342    58.250
  -151.341    58.250
>
  -153.086    58.229
  -153.085    58.230
>
  -153.764    57.899
  -153.764    57.900
>
  -154.850    58.096
  -154.849    58.097
>
  -153.148    58.681
  -153.148    58.682
>
  -152.017    58.216
  -152.012    58.212
>
  -154.308    57.308
  -154.305    57.308
>
  -155.260    57.209
  -155.260    57.209
>
  -151.481    58.338
  -151.480    58.339
>
  -152.926    56.543
  -152.925    56.544
>
  -152.034    58.426
  -152.034    58.426
>
  -154.556    57.405
  -154.556    57.406
>
  -153.722    56.637
  -153.723    56.638
>
  -153.131    57.727
  -153.130    57.727
>
  -155.147    58.639
  -155.147    58.639
>
  -153.349    58.625
  -153.350    58.625
>
  -152.605    56.537
  -152.605    56.538
>
  -152.510    56.465
  -152.509    56.465
>
  -152.206    57.579
  -152.206    57.580
>
  -153.593    58.693
  -153.592    58.693
>
  -153.297    58.679
  -153.296    58.679
>
  -153.542    56.964
  -153.544    56.966
>
  -152.252    58.265
  -152.253    58.265
>
  -154.816    57.653
  -154.816    57.653
>
  -155.710    57.612
  -155.709    57.612
>
  -152.896    57.543
  -152.897    57.545
>
  -151.775    56.973
  -151.773    56.974
>
  -155.297    57.694
  -155.296    57.694
>
  -152.951    58.408
  -152.951    58.409
>
  -154.573    58.554
  -154.572    58.555
>
  -152.640    56.464
  -152.639    56.464
>
  -153.536    57.611
  -153.536    57.611
>
  -152.521    58.521
  -152.521    58.521
>
  -154.237    58.368
  -154.236    58.368
>
  -152.603    58.157
  -152.603    58.157
>
  -153.619    58.444
  -153.618    58.444
>
  -151.555    58.292
  -151.554    58.292
>
  -153.185    58.446
  -153.184    58.447
>
  -153.239    58.085
  -153.239    58.085
>
  -153.876    57.709
  -153.875    57.709
>
  -152.369    57.399
  -152.369    57.399
>
  -154.239    57.345
  -154.239    57.345
>
  -154.793    58.186
  -154.793    58.186
>
  -152.912    56.829
  -152.912    56.829
>
  -153.376    56.530
  -153.376    56.530
>
  -152.901    56.294
  -152.901    56.294
>
  -154.111    57.720
  -154.111    57.721
>
  -153.724    58.509
  -153.723    58.510
>
  -154.181    56.985
  -154.180    56.985
>
  -153.548    58.115
  -153.548    58.115
>
  -155.187    58.222
  -155.189    58.225
>
  -153.190    58.618
  -153.190    58.618
>
  -154.301    58.544
  -154.299    58.544
>
  -155.248    58.725
  -155.247    58.726
>
  -151.738    58.179
  -151.738    58.180
>
  -153.862    58.689
  -153.859    58.690
>
  -153.942    58.775
  -153.939    58.774
>
  -152.648    58.704
  -152.647    58.705
>
  -151.869    58.057
  -151.869    58.057
>
  -153.938    57.656
  -153.938    57.656
>
  -152.913    56.912
  -152.913    56.912
>
  -153.455    58.705
  -153.454    58.705
>
  -154.079    56.560
  -154.079    56.560
>
  -155.033    56.798
  -155.033    56.798
>
  -155.075    56.810
  -155.075    56.810
>
  -155.028    56.829
  -155.028    56.828
>
  -153.943    58.432
  -153.942    58.432
>
  -152.838    56.868
  -152.837    56.869
>
  -153.670    58.609
  -153.670    58.609
>
  -151.875    58.176
  -151.874    58.176
>
  -154.046    56.386
  -154.045    56.385
>
  -153.244    56.104
  -153.244    56.105
>
  -152.935    58.201
  -152.934    58.201
>
  -151.540    58.250
  -151.539    58.251
>
  -154.957    58.346
  -154.956    58.346
>
  -153.601    58.297
  -153.600    58.298
>
  -154.816    57.833
  -154.816    57.833
>
  -155.377    58.548
  -155.377    58.548
>
  -153.710    58.739
  -153.711    58.739
>
  -154.154    58.493
  -154.154    58.493
>
  -154.454    57.204
  -154.453    57.205
>
  -153.387    56.726
  -153.386    56.726
>
  -155.173    58.646
  -155.173    58.647
>
  -152.277    58.055
  -152.277    58.055
>
  -153.067    56.821
  -153.068    56.822
>
  -155.007    58.147
  -155.006    58.148
>
  -154.125    58.665
  -154.125    58.666
>
  -155.214    57.047
  -155.216    57.051
>
  -151.822    58.103
  -151.821    58.103
>
  -155.282    58.567
  -155.282    58.568
>
  -154.830    56.590
  -154.830    56.591
>
  -153.287    58.070
  -153.286    58.070
>
  -154.042    57.715
  -154.042    57.716
>
  -153.697    58.018
  -153.697    58.018
>
  -154.692    58.162
  -154.691    58.162
>
  -152.079    58.011
  -152.078    58.011
>
  -154.998    57.548
  -154.997    57.548
>
  -154.143    58.446
  -154.143    58.446
>
  -154.146    58.454
  -154.145    58.454
>
  -155.213    57.022
  -155.212    57.022
>
  -154.133    57.719
  -154.128    57.718
>
  -154.089    57.528
  -154.089    57.528
>
  -154.119    57.932
  -154.120    57.933
>
  -154.012    56.629
  -154.017    56.632
>
  -153.548    58.467
  -153.548    58.467
>
  -154.917    58.019
  -154.916    58.020
>
  -152.494    57.286
  -152.494    57.285
>
  -153.611    57.929
  -153.611    57.929
>
  -151.604    58.101
  -151.604    58.103
>
  -153.441    57.847
  -153.440    57.847
>
  -154.027    57.639
  -154.027    57.640
>
  -154.360    57.672
  -154.359    57.672
>
  -152.075    58.092
  -152.075    58.093
>
  -154.112    58.055
  -154.112    58.055
>
  -155.503    58.148
  -155.503    58.148
>
  -154.381    56.816
  -154.381    56.816
>
  -154.082    58.573
  -154.083    58.573
>
  -152.510    58.358
  -152.510    58.358
>
  -151.456    58.250
  -151.456    58.251
>
  -153.219    56.771
  -153.219    56.772
>
  -155.303    58.582
  -155.304    58.583
>
  -155.464    56.599
  -155.465    56.598
>
  -154.643    58.143
  -154.642    58.143
>
  -151.710    58.143
  -151.710    58.144
>
  -154.501    57.628
  -154.501    57.628
>
  -152.949    58.477
  -152.949    58.477
>
  -152.459    58.909
  -152.459    58.909
>
  -154.124    58.532
  -154.123    58.532
>
  -152.969    57.721
  -152.968    57.721
>
  -153.034    58.298
  -153.034    58.298
>
  -153.593    57.837
  -153.593    57.837
>
  -155.196    56.609
  -155.196    56.609
>
  -154.828    57.852
  -154.828    57.853
>
  -154.739    58.122
  -154.738    58.122
>
  -154.549    57.773
  -154.548    57.773
>
  -151.415    58.324
  -151.415    58.324
>
  -153.936    58.014
  -153.935    58.014
>
  -153.207    56.403
  -153.207    56.404
>
  -153.230    56.403
  -153.229    56.404
>
  -154.604    58.127
  -154.603    58.127
>
  -155.220    56.755
  -155.220    56.755
>
  -154.629    58.134
  -154.628    58.134
>
  -153.769    58.196
  -153.769    58.196
>
  -153.646    58.693
  -153.645    58.694
>
  -154.203    57.229
  -154.203    57.229
>
  -152.620    58.273
  -152.619    58.273
>
  -154.953    58.692
  -154.953    58.693
>
  -152.255    56.805
  -152.254    56.805
>
  -154.270    56.219
  -154.271    56.218
>
  -151.907    58.234
  -151.907    58.235
>
  -154.556    58.133
  -154.556    58.133
>
  -152.337    57.266
  -152.337    57.266
>
  -154.105    57.103
  -154.105    57.103
>
  -154.021    57.384
  -154.020    57.384
>
  -155.038    57.471
  -155.038    57.471
>
  -155.065    57.542
  -155.063    57.542
>
  -154.771    58.485
  -154.770    58.485
>
  -152.767    58.374
  -152.766    58.375
>
  -151.344    58.388
  -151.344    58.388
>
  -152.580    56.908
  -152.579    56.908
>
  -152.539    56.982
  -152.538    56.982
>
  -152.581    57.013
  -152.580    57.013
>
  -151.395    58.338
  -151.394    58.338
>
  -154.301    57.784
  -154.300    57.784
>
  -155.219    58.216
  -155.218    58.216
>
  -154.825    56.525
  -154.825    56.524
>
  -153.025    58.336
  -153.025    58.336
>
  -154.612    56.497
  -154.612    56.497
>
  -153.650    58.473
  -153.650    58.473
>
  -155.106    58.648
  -155.105    58.648
>
  -154.487    57.731
  -154.487    57.731
>
  -154.679    57.311
  -154.679    57.312
>
  -151.600    58.205
  -151.599    58.206
>
  -155.486    58.569
  -155.485    58.569
>
  -152.879    58.363
  -152.878    58.363
>
  -155.045    57.732
  -155.044    57.732
>
  -155.040    57.721
  -155.039    57.721
>
  -154.491    57.985
  -154.491    57.984
>
  -155.240    58.283
  -155.240    58.282
>
  -152.998    57.574
  -152.997    57.574
>
  -152.988    57.576
  -152.987    57.576
>
  -151.998    58.210
  -151.997    58.210
>
  -153.115    56.898
  -153.116    56.899
>
  -153.588    58.395
  -153.588    58.395
>
  -154.815    58.077
  -154.815    58.078
>
  -154.429    56.815
  -154.428    56.815
>
  -154.347    56.303
  -154.347    56.305
>
  -154.315    56.201
  -154.316    56.204
>
  -154.217    58.047
  -154.216    58.046
>
  -152.874    57.862
  -152.873    57.862
>
  -155.012    56.830
  -155.010    56.830
>
  -151.148    58.623
  -151.154    58.627
>
  -155.443    58.201
  -155.443    58.202
>
  -155.089    58.714
  -155.089    58.714
>
  -155.128    57.544
  -155.128    57.544
>
  -153.349    56.328
  -153.348    56.328
>
  -153.367    56.292
  -153.368    56.293
>
  -153.335    56.199
  -153.335    56.198
>
  -154.014    58.306
  -154.013    58.306
>
  -152.923    58.203
  -152.922    58.203
>
  -155.255    58.299
  -155.254    58.300
>
  -155.505    57.648
  -155.510    57.647
>
  -155.497    57.657
  -155.499    57.656
>
  -155.537    57.670
  -155.537    57.670
>
  -152.525    57.823
  -152.524    57.824
>
  -151.150    58.385
  -151.150    58.385
>
  -152.595    56.920
  -152.595    56.920
>
  -153.084    58.658
  -153.083    58.658
>
  -155.293    57.278
  -155.292    57.278
>
  -154.071    58.188
  -154.071    58.188
>
  -155.508    57.278
  -155.508    57.278
>
  -151.623    58.287
  -151.623    58.288
>
  -153.231    58.628
  -153.230    58.628
>
  -154.782    56.520
  -154.782    56.519
>
  -153.989    56.369
  -153.988    56.367
>
  -153.176    58.367
  -153.175    58.368
>
  -154.090    58.565
  -154.090    58.565
>
  -153.927    58.655
  -153.927    58.655
>
  -155.311    58.359
  -155.309    58.359
>
  -154.557    57.347
  -154.556    57.347
>
  -152.580    58.000
  -152.579    58.001
>
  -155.366    57.342
  -155.365    57.342
>
  -153.973    58.167
  -153.972    58.167
>
  -153.086    58.293
  -153.085    58.294
>
  -155.260    58.489
  -155.259    58.489
>
  -155.083    58.609
  -155.083    58.610
>
  -154.263    58.092
  -154.263    58.092
>
  -155.926    57.938
  -155.925    57.938
>
  -154.309    56.374
  -154.309    56.374
>
  -153.070    56.776
  -153.069    56.777
>
  -152.659    57.984
  -152.658    57.984
>
  -155.026    57.083
  -155.024    57.084
>
  -151.302    58.345
  -151.301    58.346
>
  -151.326    58.322
  -151.326    58.322
>
  -151.487    58.562
  -151.487    58.563
>
  -153.615    58.453
  -153.614    58.454
>
  -154.277    57.926
  -154.277    57.927
>
  -154.649    57.605
  -154.649    57.606
>
  -152.148    58.130
  -152.147    58.131
>
  -153.014    58.206
  -153.012    58.207
>
  -154.011    58.223
  -154.011    58.223
>
  -151.478    58.303
  -151.478    58.302
>
  -154.235    58.477
  -154.235    58.477
>
  -153.512    57.826
  -153.512    57.826
>
  -153.587    58.669
  -153.583    58.670
>
  -152.359    57.626
  -152.358    57.626
>
  -154.288    57.622
  -154.288    57.622
>
  -151.381    58.470
  -151.381    58.470
>
  -151.328    58.522
  -151.328    58.523
>
  -154.174    58.096
  -154.173    58.096
>
  -152.584    58.269
  -152.583    58.269
>
  -153.858    58.650
  -153.858    58.650
>
  -153.485    56.163
  -153.485    56.162
>
  -153.452    56.276
  -153.452    56.277
>
  -153.450    56.087
  -153.449    56.087
>
  -153.399    56.204
  -153.400    56.205
>
  -153.369    56.093
  -153.370    56.092
>
  -153.355    56.076
  -153.354    56.076
>
  -154.619    56.014
  -154.619    56.017
>
  -152.800    58.428
  -152.799    58.429
>
  -154.501    56.287
  -154.501    56.288
>
  -153.918    58.328
  -153.917    58.328
>
  -154.955    56.552
  -154.955    56.553
>
  -153.799    56.245
  -153.798    56.247
>
  -153.796    56.179
  -153.797    56.180
>
  -155.176    57.327
  -155.175    57.328
>
  -153.669    56.277
  -153.668    56.277
>
  -153.847    57.510
  -153.847    57.511
>
  -154.190    57.099
  -154.190    57.099
>
  -153.202    57.641
  -153.202    57.641
>
  -153.082    56.223
  -153.081    56.221
>
  -154.931    57.837
  -154.931    57.838
>
  -154.586    58.124
  -154.586    58.124
>
  -151.502    58.267
  -151.503    58.268
>
  -153.610    57.830
  -153.609    57.830
>
  -153.503    58.082
  -153.502    58.082
>
  -153.957    58.651
  -153.956    58.651
>
  -154.814    57.457
  -154.811    57.454
>
  -154.615    56.272
  -154.615    56.273
>
  -154.827    57.451
  -154.825    57.451
>
  -154.039    58.087
  -154.039    58.087
>
  -155.112    58.183
  -155.112    58.183
>
  -154.408    57.334
  -154.408    57.335
>
  -153.845    57.660
  -153.846    57.659
>
  -155.488    57.030
  -155.489    57.031
>
  -153.496    58.607
  -153.496    58.607
>
  -155.057    57.137
  -155.057    57.137
>
  -155.078    57.126
  -155.077    57.127
>
  -153.541    58.578
  -153.540    58.578
>
  -154.886    57.652
  -154.885    57.653
>
  -151.719    58.291
  -151.717    58.289
>
  -154.807    57.189
  -154.806    57.189
>
  -154.204    58.258
  -154.203    58.258
>
  -153.757    58.248
  -153.757    58.248
>
  -154.314    56.477
  -154.314    56.477
>
  -151.790    57.996
  -151.788    57.995
>
  -153.173    58.441
  -153.172    58.442
>
  -155.273    57.945
  -155.272    57.945
>
  -155.338    58.478
  -155.338    58.478
>
  -154.424    58.080
  -154.421    58.081
>
  -154.418    58.085
  -154.416    58.085
>
  -153.162    58.737
  -153.162    58.737
>
  -154.731    58.477
  -154.729    58.476
>
  -153.136    56.784
  -153.137    56.786
>
  -154.950    57.269
  -154.950    57.269
>
  -155.275    57.776
  -155.277    57.776
>
  -153.734    58.781
  -153.734    58.780
>
  -152.560    58.613
  -152.561    58.610
>
  -151.723    58.206
  -151.722    58.206
>
  -154.533    58.546
  -154.523    58.549
>
  -154.161    58.721
  -154.161    58.721
>
  -155.362    58.157
  -155.360    58.158
>
  -153.535    57.320
  -153.535    57.321
>
  -154.401    57.060
  -154.400    57.061
>
  -154.170    57.349
  -154.170    57.349
>
  -152.537    58.684
  -152.534    58.684
>
  -153.970    57.961
  -153.970    57.961
>
  -153.714    58.535
  -153.714    58.535
>
  -153.717    58.343
  -153.716    58.344
>
  -151.888    58.343
  -151.887    58.342
>
  -154.543    58.136
  -154.542    58.136
>
  -155.188    57.531
  -155.188    57.531
>
  -154.883    57.226
  -154.882    57.227
>
  -153.358    58.515
  -153.358    58.515
>
  -153.875    57.751
  -153.874    57.752
>
  -152.820    57.709
  -152.819    57.709
>
  -153.980    57.740
  -153.979    57.741
>
  -153.531    58.123
  -153.531    58.123
>
  -153.642    58.626
  -153.641    58.626
>
  -153.322    58.541
  -153.322    58.541
>
  -155.074    58.290
  -155.073    58.290
>
  -153.250    58.508
  -153.250    58.508
>
  -154.186    57.492
  -154.185    57.493
>
  -154.064    58.642
  -154.064    58.642
>
  -155.775    58.405
  -155.775    58.405
>
  -153.880    57.737
  -153.879    57.737
>
  -155.200    58.245
  -155.199    58.242
>
  -153.198    57.586
  -153.198    57.586
>
  -154.888    57.503
  -154.888    57.503
>
  -154.581    57.468
  -154.580    57.469
>
  -155.219    58.238
  -155.217    58.239
>
  -154.146    57.247
  -154.145    57.248
>
  -154.566    57.763
  -154.566    57.763
>
  -155.149    58.257
  -155.148    58.257
>
  -155.003    57.743
  -155.003    57.744
>
  -153.129    57.523
  -153.129    57.524
>
  -155.472    57.194
  -155.472    57.196
>
  -154.008    58.557
  -154.007    58.557
>
  -155.230    58.240
  -155.230    58.239
>
  -153.292    58.596
  -153.292    58.597
>
  -155.118    58.261
  -155.117    58.261
>
  -155.174    58.252
  -155.173    58.251
>
  -155.159    58.255
  -155.158    58.256
>
  -155.154    58.266
  -155.150    58.267
>
  -153.697    58.122
  -153.697    58.122
>
  -155.141    58.281
  -155.138    58.280
>
  -154.635    58.135
  -154.634    58.135
>
  -154.785    58.181
  -154.785    58.182
>
  -154.923    57.721
  -154.923    57.721
>
  -154.938    57.453
  -154.937    57.452
>
  -155.016    57.899
  -155.016    57.900
>
  -153.421    57.398
  -153.420    57.398
>
  -155.136    58.262
  -155.134    58.262
>
  -152.623    57.527
  -152.622    57.527
>
  -154.282    57.274
  -154.279    57.273
>
  -154.901    57.986
  -154.900    57.986
>
  -154.453    57.671
  -154.451    57.671
>
  -152.267    57.502
  -152.268    57.503
>
  -151.844    58.412
  -151.844    58.412
>
  -155.223    58.538
  -155.222    58.538
>
  -153.832    58.712
  -153.831    58.713
>
  -152.545    58.213
  -152.543    58.212
>
  -153.316    56.008
  -153.317    56.008
>
  -153.309    57.628
  -153.308    57.628
>
  -152.909    56.809
  -152.909    56.810
>
  -153.785    57.267
  -153.785    57.268
>
  -153.661    57.269
  -153.661    57.269
>
  -155.039    58.691
  -155.039    58.691
>
  -154.130    58.287
  -154.130    58.288
>
  -153.764    56.576
  -153.762    56.575
>
  -155.154    58.616
  -155.152    58.619
>
  -154.772    58.599
  -154.772    58.599
>
  -154.699    56.918
  -154.697    56.919
>
  -154.729    56.957
  -154.730    56.957
>
  -153.487    58.644
  -153.487    58.644
>
  -155.160    58.497
  -155.160    58.497
>
  -154.735    56.985
  -154.735    56.987
>
  -155.185    58.129
  -155.185    58.129
>
  -152.993    56.889
  -152.993    56.889
>
  -153.010    56.854
  -153.009    56.853
>
  -153.014    56.850
  -153.015    56.853
>
  -152.681    57.901
  -152.679    57.901
>
  -153.994    56.097
  -153.994    56.097
>
  -154.081    56.110
  -154.080    56.110
>
  -154.013    56.145
  -154.009    56.146
>
  -153.316    57.781
  -153.316    57.780
>
  -152.784    58.340
  -152.783    58.340
>
  -154.012    57.976
  -154.011    57.976
>
  -152.630    58.448
  -152.629    58.448
>
  -151.529    58.131
  -151.528    58.132
>
  -153.173    58.135
  -153.173    58.135
>
  -154.989    58.286
  -154.989    58.285
>
  -154.883    56.941
  -154.883    56.943
>
  -154.835    56.886
  -154.834    56.886
>
  -152.525    57.766
  -152.526    57.767
>
  -152.644    58.689
  -152.643    58.689
>
  -155.410    57.245
  -155.408    57.245
>
  -155.405    57.205
  -155.404    57.204
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -151.257    56.978    42.237     0.485     5.355
  -151.183    57.359   -49.181     3.100     5.869
  -151.357    57.570   -52.353     2.907     4.901
  -151.852    57.134   -40.112     3.664     6.753
  -151.928    58.125    47.359     0.774     3.908
  -152.679    56.881   -52.706     3.177     4.497
  -152.394    58.112   -39.562     2.320     3.727
  -152.218    57.296   -41.325     2.413     3.369
  -154.515    58.556   -81.193     4.741     6.505
  -151.725    58.210   -48.907     3.863     6.411
  -151.237    57.446   -50.246     2.316     3.349
  -153.305    58.159   -43.642     2.679     2.928
  -152.603    56.500   -42.963     2.485     3.539
  -152.624    56.531   -40.295     3.045     4.668
  -152.490    56.498   -39.919     2.776     4.646
  -151.401    56.799   -58.992     2.082     2.727
  -152.879    58.283   -41.580     3.656     4.312
  -153.617    58.148    66.506     2.133     2.511
  -152.924    58.456   -53.106     1.621     1.775
  -153.774    57.461    -6.543     2.941     3.426
  -151.402    58.323   -87.249     2.037     3.931
  -152.513    57.842   -75.025     2.377     4.740
  -155.031    58.489   -33.713     4.742     7.539
  -152.694    58.037   -68.479     2.469     4.369
  -151.398    58.022   -77.130     2.044     2.898
  -153.608    58.680   -69.320     2.236     3.927
  -153.363    57.220   -64.009     3.690     7.552
  -153.637    58.104   -60.507     2.119     4.344
  -152.898    58.240    82.950     1.737     3.040
  -155.193    58.758    40.096     2.982     5.133
  -151.830    58.051    78.790     2.113     3.181
  -153.531    58.694    74.523     1.845     2.763
  -155.184    58.256    62.083     2.468     4.294
  -153.022    58.641    87.920     2.156     2.927
  -153.640    57.943    74.663     1.506     2.519
  -152.896    57.779    79.710     1.850     3.970
  -151.909    57.562    74.582     2.079     3.854
  -153.218    57.854    78.661     1.530     2.983
  -154.509    58.141    55.363     1.823     2.671
  -154.095    58.467    62.688     1.959     3.223
  -153.695    57.312   -76.434     2.479     3.253
  -151.595    58.271    68.348     1.570     3.207
  -151.782    58.217   -59.747     1.907     2.538
  -154.872    58.457    52.624     2.124     4.744
  -154.225    57.356   -73.002     1.675     1.993
  -154.238    57.343   -70.569     1.248     1.483
  -152.691    57.510    76.938     1.744     2.400
  -154.190    57.390   -58.105     1.112     1.425
  -154.251    57.409   -51.403     1.521     1.753
  -153.570    58.585    54.576     1.163     2.580
  -153.759    57.819   -77.900     1.207     1.688
  -152.346    57.998    69.494     1.480     3.796
  -153.934    58.009   -87.105     1.883     2.163
  -154.959    57.292    50.253     2.224     2.509
  -155.378    57.783   -87.508     1.319     1.736
  -153.233    58.380    60.564     1.373     3.110
  -155.963    58.307    33.524     2.930     5.546
  -153.451    57.975    69.180     1.865     4.538
  -154.272    58.637    48.097     1.186     2.989
  -155.056    57.635    81.245     2.463     3.782
  -155.158    58.691    38.969     1.787     4.206
  -151.632    58.168   -53.805     1.599     2.110
  -154.785    57.309   -35.113     1.729     1.969
  -152.947    56.983   -58.543     1.601     2.941
  -153.050    56.993    64.633     4.089     4.791
  -154.653    58.154    58.071     2.346     4.483
  -154.619    57.907    69.148     2.213     4.494
  -151.341    58.250   -69.013     1.337     1.709
  -153.085    58.230    73.891     1.326     1.809
  -153.764    57.900    75.541     1.466     2.834
  -154.849    58.097    55.470     1.493     4.653
  -153.148    58.682    55.481     1.603     3.124
  -152.012    58.212    80.503     2.124     2.662
  -154.305    57.308    55.576     2.431     2.833
  -155.260    57.209    63.794     2.302     3.558
  -151.480    58.339   -55.823     1.254     2.165
  -152.925    56.544   -50.216     0.985     2.250
  -152.034    58.426   -60.362     0.836     1.362
  -154.556    57.406   -44.342     1.349     1.924
  -153.723    56.638    62.303     2.361     5.097
  -153.130    57.727    76.903     1.798     3.255
  -155.147    58.639    38.612     2.672     5.192
  -153.350    58.625   -71.025     1.232     1.312
  -152.605    56.538   -50.709     0.948     1.739
  -152.509    56.465    56.219     2.912     3.922
  -152.206    57.580    70.795     1.772     3.503
  -153.592    58.693   -70.552     0.987     1.329
  -153.296    58.679    55.872     1.582     3.002
  -153.544    56.966   -50.857     1.100     1.872
  -152.253    58.265    66.380     2.097     3.692
  -154.816    57.653    83.372     2.016     3.586
  -155.709    57.612    58.779     1.486     3.417
  -152.897    57.545    75.538     1.479     3.551
  -151.773    56.974   -47.202     2.316     3.915
  -155.296    57.694    61.749     1.779     2.698
  -152.951    58.409    65.118     1.440     2.893
  -154.572    58.555    48.250     1.321     3.109
  -152.639    56.464    78.454     3.201     6.281
  -153.536    57.611   -59.746     1.101     1.690
  -152.521    58.521    59.850     1.640     2.687
  -154.236    58.368   -87.199     0.927     1.304
  -152.603    58.157    77.896     1.728     3.060
  -153.618    58.444    59.014     1.520     3.124
  -151.554    58.292    71.104     1.483     2.901
  -153.184    58.447    65.698     1.102     2.643
  -153.239    58.085   -68.787     1.003     1.470
  -153.875    57.709   -66.078     0.980     1.503
  -152.369    57.399    83.552     1.827     3.503
  -154.239    57.345   -55.051     1.216     2.015
  -154.793    58.186    61.115     1.963     3.565
  -152.912    56.829   -57.601     1.467     2.429
  -153.376    56.530   -62.249     0.934     1.561
  -152.901    56.294    86.460     2.743     5.403
  -154.111    57.721    76.186     2.069     3.554
  -153.723    58.510    61.079     1.260     2.124
  -154.180    56.985   -65.105     0.807     1.196
  -153.548    58.115    62.154     1.650     4.638
  -155.189    58.225    40.794     1.923     2.637
  -153.190    58.618    56.178     1.103     2.392
  -154.299    58.544   -83.471     0.893     1.264
  -155.247    58.726    42.161     2.039     4.376
  -151.738    58.180    57.916     2.009     4.112
  -153.859    58.690    49.128     2.782     4.490
  -153.939    58.774    40.981     2.202     4.179
  -152.647    58.705    54.309     1.344     2.644
  -151.869    58.057   -70.618     1.059     1.529
  -153.938    57.656    85.832     2.422     3.284
  -152.913    56.912    66.540     2.211     3.634
  -153.454    58.705    54.230     1.051     2.251
  -154.079    56.560    84.375     2.524     4.937
  -155.033    56.798   -83.211     2.718     5.315
  -155.075    56.810   -71.092     0.947     1.215
  -155.028    56.828    80.775     3.254     4.583
  -153.942    58.432    53.957     1.046     2.037
  -152.837    56.869    78.174     2.087     3.872
  -153.670    58.609    48.176     1.644     3.472
  -151.874    58.176    62.042     1.940     2.917
  -154.045    56.385    78.033     3.360     6.589
  -153.244    56.105    73.314     3.404     6.442
  -152.934    58.201    62.484     1.339     2.198
  -151.539    58.251    64.704     2.035     4.143
  -154.956    58.346    48.822     2.047     4.554
  -153.600    58.298    61.172     1.352     3.034
  -154.816    57.833    71.560     1.653     2.093
  -155.377    58.548    34.994     2.305     5.489
  -153.711    58.739    51.782     1.545     2.886
  -154.154    58.493    52.272     1.072     2.479
  -154.453    57.205    35.415     3.830     4.476
  -153.386    56.726    83.487     2.327     5.206
  -155.173    58.647    38.988     1.869     4.010
  -152.277    58.055    66.881     1.594     3.158
  -153.068    56.822    86.941     2.247     4.677
  -155.006    58.148    55.783     1.797     3.308
  -154.125    58.666    49.062     1.212     2.690
  -155.216    57.051   -88.565     2.709     3.679
  -151.821    58.103    68.154     1.464     2.962
  -155.282    58.568    39.386     1.933     3.895
  -154.830    56.591   -83.950     3.556     5.769
  -153.286    58.070    52.126     1.680     2.668
  -154.042    57.716    78.815     1.864     3.518
  -153.697    58.018    69.463     0.948     2.084
  -154.691    58.162    56.526     1.738     3.182
  -152.078    58.011    58.791     2.329     4.372
  -154.997    57.548    85.288     2.003     2.647
  -154.143    58.446    52.713     1.264     2.594
  -154.145    58.454    54.893     1.260     2.752
  -155.212    57.022    86.690     1.922     3.382
  -154.128    57.718   -84.052     1.309     1.727
  -154.089    57.528   -76.014     1.650     1.982
  -154.120    57.933    78.110     1.426     2.816
  -154.017    56.632    72.354     2.243     3.043
  -153.548    58.467    59.671     0.822     1.588
  -154.916    58.020    56.831     1.465     2.119
  -152.494    57.285    77.326     1.465     3.048
  -153.611    57.929    72.556     1.110     1.991
  -151.604    58.103    71.299     1.660     2.692
  -153.440    57.847    75.014     1.284     2.215
  -154.027    57.640    67.981     1.787     2.284
  -154.359    57.672    88.166     2.055     3.054
  -152.075    58.093    77.122     1.133     1.708
  -154.112    58.055    64.273     1.100     1.632
  -155.503    58.148    48.216     2.445     3.476
  -154.381    56.816    77.302     1.572     2.149
  -154.083    58.573   -77.419     1.559     1.894
  -152.510    58.358    89.155     2.127     2.438
  -151.456    58.251    71.314     2.719     4.402
  -153.219    56.772    84.489     3.627     8.681
  -155.304    58.583    34.862     1.934     2.899
  -155.465    56.598   -79.572     3.113     4.723
  -154.642    58.143    55.632     1.628     2.907
  -151.710    58.144    80.701     4.138     5.617
  -154.501    57.628   -85.629     1.625     2.197
  -152.949    58.477    83.460     2.062     3.446
  -152.459    58.909   -81.745     0.986     1.192
  -154.123    58.532    51.919     1.239     1.840
  -152.968    57.721    69.730     2.324     3.557
  -153.034    58.298   -85.283     1.707     2.566
  -153.593    57.837    86.452     1.293     2.172
  -155.196    56.609   -82.300     2.785     4.773
  -154.828    57.853    85.475     1.405     1.965
  -154.738    58.122    70.883     1.649     2.675
  -154.548    57.773    85.469     1.501     2.233
  -151.415    58.324    65.648     1.982     3.988
  -153.935    58.014   -86.625     1.220     1.871
  -153.207    56.404    89.429     1.609     2.165
  -153.229    56.404   -88.116     1.746     2.588
  -154.603    58.127    72.580     1.138     1.759
  -155.220    56.755   -73.268     2.001     3.612
  -154.628    58.134    74.646     1.680     2.472
  -153.769    58.196   -68.476     1.985     3.011
  -153.645    58.694    80.251     1.272     1.968
  -154.203    57.229   -81.114     3.059     5.547
  -152.619    58.273   -88.322     1.646     1.856
  -154.953    58.693    40.417     2.085     3.322
  -152.254    56.805    75.364     2.782     5.418
  -154.271    56.218    66.455     3.590     5.695
  -151.907    58.235    81.209     1.803     2.515
  -154.556    58.133   -56.938     2.722     5.175
  -152.337    57.266   -83.342     1.544     2.749
  -154.105    57.103   -44.315     1.486     1.867
  -154.020    57.384   -88.633     2.654     4.716
  -155.038    57.471   -57.204     1.938     2.126
  -155.063    57.542   -42.043     2.837     3.400
  -154.770    58.485   -58.948     3.606     5.288
  -152.766    58.375    65.683     1.699     2.898
  -151.344    58.388    74.466     1.964     4.104
  -152.579    56.908   -86.844     3.482     7.018
  -152.538    56.982   -69.691     1.249     1.623
  -152.580    57.013   -60.456     2.072     3.243
  -151.394    58.338    76.206     1.810     3.635
  -154.300    57.784   -72.489     0.924     1.192
  -155.218    58.216    55.593     1.773     2.339
  -154.825    56.524    89.694     3.585     5.715
  -153.025    58.336    69.733     0.991     1.807
  -154.612    56.497    77.049     2.229     3.452
  -153.650    58.473    85.183     0.756     1.019
  -155.105    58.648    43.951     2.285     3.146
  -154.487    57.731   -89.041     1.834     2.680
  -154.679    57.312   -88.440     1.685     2.798
  -151.599    58.206    68.269     2.192     4.274
  -155.485    58.569    52.626     1.857     2.228
  -152.878    58.363    82.172     0.865     1.223
  -155.044    57.732    80.741     1.036     1.602
  -155.039    57.721    78.874     1.673     2.534
  -154.491    57.984    76.230     1.798     2.891
  -155.240    58.282    58.017     1.633     2.551
  -152.997    57.574    86.686     1.084     1.643
  -152.987    57.576    84.331     1.218     2.721
  -151.997    58.210    77.084     1.513     3.246
  -153.116    56.899    78.823     1.742     3.898
  -153.588    58.395    65.248     0.984     1.592
  -154.815    58.078    79.103     1.161     1.724
  -154.428    56.815   -84.898     1.684     2.790
  -154.347    56.305    87.350     2.235     3.782
  -154.316    56.204   -89.892     3.249     5.122
  -154.216    58.046    88.280     2.173     3.730
  -152.873    57.862    73.476     1.773     3.043
  -155.010    56.830   -77.438     1.218     1.483
  -151.154    58.627    78.017     1.133     2.268
  -155.443    58.202   -89.690     1.615     2.450
  -155.089    58.714    64.981     1.750     2.073
  -155.128    57.544    85.529     1.236     2.043
  -153.348    56.328   -74.958     1.699     2.459
  -153.368    56.293    89.111     2.215     4.102
  -153.335    56.198    76.416     2.705     5.635
  -154.013    58.306    74.861     1.323     2.239
  -152.922    58.203    78.321     1.118     2.060
  -155.254    58.300   -82.289     2.525     3.390
  -155.510    57.647    88.654     1.819     2.460
  -155.499    57.656    74.728     2.208     3.263
  -155.537    57.670    89.421     2.434     3.500
  -152.524    57.824    76.188     1.586     3.302
  -151.150    58.385    71.374     1.476     2.779
  -152.595    56.920    89.708     1.974     4.337
  -153.083    58.658    72.794     1.114     1.680
  -155.292    57.278   -88.126     1.682     2.928
  -154.071    58.188    69.901     0.835     1.373
  -155.508    57.278   -88.276     1.197     1.791
  -151.623    58.288    62.215     1.377     2.150
  -153.230    58.628    64.600     1.079     1.716
  -154.782    56.519    82.836     1.255     1.513
  -153.988    56.367    84.554     3.608     5.999
  -153.175    58.368    75.685     0.846     1.317
  -154.090    58.565    73.818     1.070     1.417
  -153.927    58.655    71.171     1.089     1.367
  -155.309    58.359    74.505     1.141     1.409
  -154.556    57.347   -84.861     1.315     2.155
  -152.579    58.001    60.702     1.591     2.470
  -155.365    57.342    82.032     1.797     2.502
  -153.972    58.167    70.878     1.284     2.076
  -153.085    58.294    69.336     1.262     2.104
  -155.259    58.489    71.124     1.790     2.121
  -155.083    58.610    77.204     1.185     1.519
  -154.263    58.092    57.197     1.608     2.182
  -155.925    57.938   -85.262     2.459     3.065
  -154.309    56.374    84.535     1.515     1.928
  -153.069    56.777    80.650     2.297     4.748
  -152.658    57.984    84.777     2.165     3.553
  -155.024    57.084   -81.960     2.052     2.840
  -151.301    58.346    80.239     0.948     1.501
  -151.326    58.322    73.555     1.814     3.014
  -151.487    58.563    69.714     1.897     3.498
  -153.614    58.454    65.978     1.778     2.255
  -154.277    57.927    68.384     1.572     2.592
  -154.649    57.606    83.647     1.356     2.425
  -152.147    58.131    70.934     1.608     2.661
  -153.012    58.207    70.335     1.420     2.426
  -154.011    58.223    61.870     1.682     2.997
  -151.478    58.302    68.370     1.907     4.240
  -154.235    58.477    69.430     0.978     1.480
  -153.512    57.826    74.425     1.090     2.057
  -153.583    58.670    55.701     1.177     2.098
  -152.358    57.626    75.483     1.451     3.081
  -154.288    57.622    86.051     1.098     1.862
  -151.381    58.470    70.432     2.284     4.259
  -151.328    58.523    76.962     1.874     3.334
  -154.173    58.096    82.687     1.455     2.475
  -152.583    58.269    69.834     1.213     1.797
  -153.858    58.650    57.690     0.676     1.188
  -153.485    56.162    82.218     2.728     5.055
  -153.452    56.277   -73.628     1.361     1.673
  -153.449    56.087    87.119     2.493     5.654
  -153.400    56.205   -78.826     1.636     2.444
  -153.370    56.092    86.923     2.670     4.147
  -153.354    56.076    80.780     1.972     3.795
  -154.619    56.017    72.538     2.325     3.919
  -152.799    58.429    61.243     1.185     2.126
  -154.501    56.288    81.219     1.816     2.706
  -153.917    58.328    65.413     1.261     1.952
  -154.955    56.553    85.959     3.016     4.221
  -153.798    56.247   -87.510     1.917     2.962
  -153.797    56.180    81.065     2.842     4.609
  -155.175    57.328   -79.857     1.623     1.922
  -153.668    56.277    87.634     1.451     1.608
  -153.847    57.511    87.059     1.655     3.231
  -154.190    57.099   -88.295     1.889     3.359
  -153.202    57.641    77.759     1.311     2.580
  -153.081    56.221    73.158     3.177     6.612
  -154.931    57.838    76.041     1.445     2.457
  -154.586    58.124    61.773     1.105     2.024
  -151.503    58.268    73.280     1.841     3.909
  -153.609    57.830    85.334     1.232     1.807
  -153.502    58.082    70.857     1.221     2.086
  -153.956    58.651    53.574     1.270     2.176
  -154.811    57.454   -87.109     2.491     3.159
  -154.615    56.273    73.506     2.056     3.307
  -154.825    57.451   -80.002     1.912     2.551
  -154.039    58.087    80.832     2.074     3.404
  -155.112    58.183    59.356     1.294     1.855
  -154.408    57.335   -79.282     2.822     3.509
  -153.846    57.659    74.392     1.520     1.936
  -155.489    57.031   -82.609     2.389     3.974
  -153.496    58.607    58.405     0.941     1.421
  -155.057    57.137    68.181     0.997     1.199
  -155.077    57.127    83.257     1.739     2.437
  -153.540    58.578    67.161     1.265     1.872
  -154.885    57.653    87.677     1.551     2.378
  -151.717    58.289    73.966     2.214     3.984
  -154.806    57.189    89.267     2.951     4.023
  -154.203    58.258    54.480     1.313     1.912
  -153.757    58.248    53.453     0.927     1.638
  -154.314    56.477   -64.567     2.516     2.969
  -151.788    57.995    63.739     1.835     2.968
  -153.172    58.442    60.530     1.241     2.147
  -155.272    57.945    54.373     1.722     2.995
  -155.338    58.478    38.363     1.662     2.758
  -154.421    58.081    54.179     2.010     2.930
  -154.416    58.085    69.152     1.732     3.478
  -153.162    58.737    57.494     1.348     2.250
  -154.729    58.476    38.899     1.258     2.910
  -153.137    56.786    88.548     1.859     4.375
  -154.950    57.269    64.751     1.069     1.389
  -155.277    57.776    60.145     2.436     3.479
  -153.734    58.780    44.333     1.674     3.328
  -152.561    58.610   -55.117     1.777     2.337
  -151.722    58.206    82.818     1.481     2.335
  -154.523    58.549    56.356     2.224     3.433
  -154.161    58.721    86.114     1.582     2.266
  -155.360    58.158    43.942     2.000     2.806
  -153.535    57.321    84.650     1.616     2.895
  -154.400    57.061    84.955     2.458     3.874
  -154.170    57.349    78.656     1.681     2.488
  -152.534    58.684    66.311     1.092     1.710
  -153.970    57.961    74.189     1.470     2.525
  -153.714    58.535    51.695     1.091     2.024
  -153.716    58.344    52.315     1.113     2.146
  -151.887    58.342    63.350     1.255     2.160
  -154.542    58.136    53.666     1.005     1.782
  -155.188    57.531    69.548     1.828     2.716
  -154.882    57.227    68.468     2.696     3.748
  -153.358    58.515    47.815     1.440     2.681
  -153.874    57.752    77.739     1.340     2.571
  -152.819    57.709    71.779     1.466     3.167
  -153.979    57.741    75.565     1.281     2.217
  -153.531    58.123    64.910     1.166     2.187
  -153.641    58.626    44.394     1.416     2.992
  -153.322    58.541    45.338     1.348     2.290
  -155.073    58.290    38.722     1.524     2.388
  -153.250    58.508    49.178     1.298     2.588
  -154.185    57.493    81.426     1.403     2.360
  -154.064    58.642    45.587     0.877     1.687
  -155.775    58.405    42.603     1.898     3.191
  -153.879    57.737    79.128     1.228     2.648
  -155.199    58.242    44.693     1.340     2.014
  -153.198    57.586    71.532     1.243     2.364
  -154.888    57.503    61.610     1.334     2.167
  -154.580    57.469    76.361     1.357     2.296
  -155.217    58.239    61.058     1.650     2.144
  -154.145    57.248    82.528     2.074     3.315
  -154.566    57.763    63.984     1.123     1.965
  -155.148    58.257    50.617     1.637     2.253
  -155.003    57.744    59.730     1.117     2.047
  -153.129    57.524    71.361     1.261     2.790
  -155.472    57.196    52.503     2.612     4.084
  -154.007    58.557    44.966     0.884     1.814
  -155.230    58.239    57.726     1.471     2.502
  -153.292    58.597    46.957     1.249     2.409
  -155.117    58.261    33.700     1.321     2.030
  -155.173    58.251    38.868     1.762     2.477
  -155.158    58.256    41.753     1.495     2.224
  -155.150    58.267    38.218     1.372     1.871
  -153.697    58.122    64.670     1.197     2.082
  -155.138    58.280    31.692     2.117     2.750
  -154.634    58.135    59.137     1.445     2.556
  -154.785    58.182    48.781     1.387     2.746
  -154.923    57.721    61.746     1.428     2.662
  -154.937    57.452    63.616     1.243     2.602
  -155.016    57.900    51.494     1.069     2.381
  -153.420    57.398    80.004     1.510     3.002
  -155.134    58.262    44.145     1.442     2.419
  -152.622    57.527    74.436     1.383     3.317
  -154.279    57.273   -69.987     2.641     5.062
  -154.900    57.986    53.721     1.147     2.169
  -154.451    57.671    68.440     1.652     3.046
  -152.268    57.503    76.507     1.879     4.585
  -151.844    58.412    67.966     1.670     2.991
  -155.222    58.538    44.457     1.639     2.348
  -153.831    58.713    46.121     1.019     2.138
  -152.543    58.212    65.936     1.605     2.915
  -153.317    56.008    75.822     3.181     6.841
  -153.308    57.628    73.014     1.960     3.760
  -152.909    56.810    76.944     2.042     3.465
  -153.785    57.268    83.040     1.597     2.621
  -153.661    57.269    75.132     1.481     2.278
  -155.039    58.691    39.867     1.459     2.636
  -154.130    58.288    61.367     1.329     1.953
  -153.762    56.575    88.892     2.130     3.678
  -155.152    58.619    36.241     1.564     2.699
  -154.772    58.599    33.152     1.329     2.606
  -154.697    56.919   -88.831     1.687     2.156
  -154.730    56.957    64.660     1.687     2.340
  -153.487    58.644    49.135     1.113     1.910
  -155.160    58.497    39.206     1.364     2.359
  -154.735    56.987    71.640     1.757     2.235
  -155.185    58.129    42.598     1.353     2.981
  -152.993    56.889    77.827     2.235     4.114
  -153.009    56.853    77.015     1.569     3.344
  -153.015    56.853    75.381     2.073     3.751
  -152.679    57.901    70.719     1.604     3.001
  -153.994    56.097    87.382     1.576     1.849
  -154.080    56.110    58.634     2.491     3.912
  -154.009    56.146    67.319     2.246     2.378
  -153.316    57.780    69.170     1.173     2.308
  -152.783    58.340    61.470     1.612     3.074
  -154.011    57.976    63.839     1.525     2.756
  -152.629    58.448    62.131     1.095     1.658
  -151.528    58.132    82.869     2.131     3.195
  -153.173    58.135    80.304     0.964     1.400
  -154.989    58.285    45.803     1.625     2.732
  -154.883    56.943    82.742     2.497     3.397
  -154.834    56.886    68.943     1.956     3.893
  -152.526    57.767    69.459     1.509     2.860
  -152.643    58.689    62.043     1.303     2.033
  -155.408    57.245    62.635     2.099     3.373
  -155.404    57.204    69.308     2.052     3.149
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -155.969    55.962    25.960     0.885     1.140
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -155.947    55.962   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -155.969    55.962     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -155.969    55.962     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -155.969    55.917   5 km
EOF
gmt end
