#!/bin/bash
gmt begin hubbard6.23_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases hubbard6.23'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     5.206
     1.500     1.498
     2.000    -2.211
     2.500    -5.920
     3.000    -9.629
     3.500   -13.337
     4.000   -17.049
     4.500   -20.762
     5.000   -24.476
     5.500   -28.193
     6.000   -31.912
     6.500   -35.633
     7.000   -39.357
     7.500   -43.084
     8.000   -46.814
     8.500   -50.548
     9.000   -54.284
     9.500   -58.025
    10.000   -61.769
    10.500   -65.518
    11.000   -69.272
    11.500   -73.030
    12.000   -76.793
    12.500   -80.561
    13.000   -84.335
    13.500   -88.114
    14.000   -91.899
    14.500   -95.691
    15.000   -99.488
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -81.335 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500    -0.010
     1.000    -0.304
     1.500    -0.536
     2.000    -0.753
     2.500    -0.965
     3.000    -1.175
     3.500    -1.387
     4.000    -1.598
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -4.598 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    12.231    -7.229     0.200
     5.184    -1.227     0.200
     5.801    -1.281     0.200
     7.143     2.680     0.200
     8.608    -3.158     0.200
     5.635    -1.207     0.200
     3.677    -0.240     0.200
     4.674    -1.779     0.200
     6.074    10.631     0.200
     5.249    -1.596     0.200
     5.214    -1.280     0.200
     5.202    -1.450     0.200
     8.576    -2.491     0.200
     5.804    -0.698     0.200
     6.155     0.657     0.200
     4.115     0.813     0.200
     3.929    -0.686     0.200
     5.804    -1.142     0.200
     8.568    -1.413     0.200
    12.087    -2.563     0.200
     3.998    -0.494     0.200
     8.693    -2.172     0.200
     5.213    -1.219     0.200
     8.546    -3.109     0.200
    12.181    -4.190     0.200
     9.897     2.071     0.200
    12.102    -8.231     0.200
    12.102    -7.255     0.200
    12.106    -7.976     0.200
     8.616    -2.438     0.200
     9.902     1.998     0.200
    10.117    -1.420     0.200
    10.117    -0.163     0.200
    12.117    -8.936     0.200
    12.117    -6.686     0.200
    12.122    -7.679     0.200
    12.348     0.058     0.200
    13.727    -4.657     0.200
    14.899    -7.764     0.200
    15.653    -8.107     0.200
    15.809     1.277     0.200
     3.956    -1.134     0.200
     8.597    -3.214     0.200
    12.103    -8.318     0.200
    12.107    -2.712     0.200
     3.932    -1.654     0.200
     5.806    -0.285     0.200
    12.088    -4.185     0.200
     3.954    -0.207     0.200
     5.087    -1.882     0.200
     2.517    -0.969     0.200
     4.661    -2.024     0.200
     3.892     1.230     0.200
     5.712     3.367     0.200
     6.235     9.111     0.200
     8.514    -3.361     0.200
    12.174    -5.476     0.200
     5.095    -2.144     0.200
     5.072    -1.950     0.200
     5.635    -2.261     0.200
     4.689    -2.192     0.200
     5.316    -1.669     0.200
     2.718    -0.655     0.200
     2.761    -1.051     0.200
     3.221    -0.305     0.200
     3.638    -1.369     0.200
     4.674    -1.843     0.200
     5.757    -1.593     0.200
     9.115    -2.386     0.200
     9.410    -0.872     0.200
    12.161    -8.406     0.200
     2.513    -1.558     0.200
     2.513    -1.289     0.200
     2.642    -0.531     0.200
     2.834    -1.313     0.200
     2.954    -0.467     0.200
     3.068    -1.351     0.200
     3.732    -1.735     0.200
     2.744    -0.897     0.200
     3.018    -0.947     0.200
     3.097    -1.551     0.200
     3.800    -1.013     0.200
     4.048    -3.709     0.200
     5.171    -2.052     0.200
     2.740    -0.781     0.200
     2.740    -1.149     0.200
     3.015    -0.783     0.200
     3.797    -0.919     0.200
     4.333    -1.043     0.200
     2.706    -0.742     0.200
     2.971    -0.828     0.200
     3.042    -1.185     0.200
     3.753    -1.665     0.200
     3.799    -0.872     0.200
     2.704    -0.400     0.200
     2.966    -0.701     0.200
     3.034    -1.221     0.200
     3.749    -1.510     0.200
     3.796    -0.527     0.200
     4.282    -1.658     0.200
     5.210    -1.369     0.200
     2.886    -1.441     0.200
     2.924    -0.651     0.200
     3.084    -0.544     0.200
     3.864    -0.617     0.200
     3.038    -1.571     0.200
     3.127    -1.546     0.200
     3.863    -1.152     0.200
     4.358     0.471     0.200
     5.559    -2.363     0.200
     2.545    -0.837     0.200
     2.939    -1.371     0.200
     4.674    -2.130     0.200
     4.712    -0.853     0.200
     3.030    -0.650     0.200
     3.118    -1.263     0.200
     3.210     0.172     0.200
     3.309    -1.098     0.200
     3.811    -1.817     0.200
     4.378    -1.888     0.200
     4.662    -1.674     0.200
     4.669    -1.421     0.200
     5.549    -2.453     0.200
     6.162    -2.304     0.200
     2.533    -0.906     0.200
     2.777    -0.708     0.200
     3.065    -1.386     0.200
     3.054    -1.699     0.200
     3.561    -1.223     0.200
     3.978    -1.524     0.200
     4.425    -1.363     0.200
     5.369    -1.082     0.200
     5.607    -1.095     0.200
     5.894    -1.780     0.200
     2.715    -0.370     0.200
     2.908    -1.594     0.200
     2.982    -1.195     0.200
     3.006    -1.634     0.200
     3.765    -1.692     0.200
     3.909    -1.986     0.200
     4.625    -1.110     0.200
     4.919    -1.734     0.200
     2.797    -0.481     0.200
     2.797    -0.922     0.200
     3.038    -0.250     0.200
     2.790    -1.543     0.200
     3.087    -1.108     0.200
     3.867    -1.111     0.200
     2.561    -0.767     0.200
     2.905    -1.229     0.200
     4.861    -1.989     0.200
     2.698    -0.775     0.200
     2.930    -1.018     0.200
     3.227    -0.964     0.200
     3.715    -1.142     0.200
     2.663    -0.870     0.200
     2.663    -1.026     0.200
     2.911    -1.441     0.200
     2.911    -1.094     0.200
     3.173    -1.619     0.200
     2.517     0.015     0.200
     2.555    -0.077     0.200
     3.291    -0.665     0.200
     3.760    -1.449     0.200
     4.831    -1.766     0.200
     2.940    -1.430     0.200
     3.091    -1.149     0.200
     2.980    -0.736     0.200
     2.756    -1.395     0.200
     3.960    -1.801     0.200
     4.113    -0.996     0.200
     4.225    -1.621     0.200
     2.580    -0.513     0.200
     2.629    -0.324     0.200
     2.832    -0.863     0.200
     2.832    -0.348     0.200
     3.095    -1.725     0.200
     4.478    -0.699     0.200
     3.201    -1.173     0.200
     4.773     0.018     0.200
     5.972    -0.504     0.200
     4.635    -1.367     0.200
     3.007    -1.664     0.200
     5.826    -2.554     0.200
     5.832    -0.811     0.200
     3.800    -1.514     0.200
     3.286    -1.611     0.200
     3.664    -1.827     0.200
     3.830    -1.582     0.200
     4.635    -1.993     0.200
     7.101    10.488     0.200
     2.537     1.113     0.200
     2.504    -1.040     0.200
     2.533    -1.333     0.200
     2.609    -0.546     0.200
     2.620     1.269     0.200
     3.348    -1.265     0.200
     3.903    -1.452     0.200
     4.188    -0.595     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.326    -5.636     0.200
     1.791    -0.541     0.200
     1.821    -3.539     0.200
     1.890    -3.704     0.200
     2.613    -9.006     0.200
     1.786    -3.050     0.200
     1.880    -3.920     0.200
     2.493    -6.455     0.200
     2.603    -8.284     0.200
     3.626   -15.713     0.200
     1.734    -2.077     0.200
     1.762    -1.941     0.200
     2.404    -5.766     0.200
     2.382    -6.913     0.200
     3.327   -12.926     0.200
     3.425   -13.610     0.200
     1.528    -0.863     0.200
     1.885    -2.994     0.200
     2.033    -4.866     0.200
     2.244    -5.705     0.200
     1.633    -0.181     0.200
     1.727    -2.075     0.200
     2.386    -4.990     0.200
     3.938   -17.701     0.200
     4.827   -22.625     0.200
     1.952    -3.248     0.200
     1.588    -0.193     0.200
     1.603    -0.105     0.200
     2.295    -5.023     0.200
     3.852   -18.017     0.200
     2.372    -5.833     0.200
     2.363    -5.734     0.200
     2.411    -6.910     0.200
     1.714    -0.224     0.200
     1.800    -1.357     0.200
     2.305    -5.504     0.200
     3.930   -15.646     0.200
     4.209   -17.319     0.200
     5.108   -21.474     0.200
    12.115   -72.841     0.200
     1.713    -0.508     0.200
     1.722    -0.685     0.200
     1.812    -2.153     0.200
     2.530    -7.110     0.200
     1.852    -0.939     0.200
     2.304    -3.899     0.200
     2.304    -5.367     0.200
     2.668    -7.357     0.200
     2.814    -8.587     0.200
     1.744    -1.134     0.200
     2.276    -5.385     0.200
     2.721    -8.639     0.200
     3.205   -12.042     0.200
     3.312   -12.417     0.200
     8.568   -53.362     0.200
    12.082   -72.560     0.200
     1.506    -0.228     0.200
     2.307    -5.036     0.200
     2.378    -5.550     0.200
     2.518    -7.218     0.200
     3.300   -13.004     0.200
     3.998   -18.299     0.200
     3.874   -16.392     0.200
     5.689   -31.607     0.200
     2.440    -4.349     0.200
     3.850   -15.693     0.200
     1.163     1.086     0.200
     2.292    -5.782     0.200
     2.780    -9.099     0.200
     3.960   -16.676     0.200
     8.600   -54.440     0.200
    10.118   -58.672     0.200
     2.307    -6.261     0.200
     2.307    -4.198     0.200
     2.783    -7.624     0.200
     3.973   -16.913     0.200
     8.616   -54.985     0.200
     9.997   -60.459     0.200
    10.117   -58.147     0.200
     2.294    -4.730     0.200
     2.546    -5.708     0.200
     3.956   -17.251     0.200
     8.597   -53.316     0.200
     1.570     0.140     0.200
     2.277    -3.708     0.200
     2.789    -4.936     0.200
     3.932   -16.224     0.200
     8.571   -51.782     0.200
     8.571   -52.512     0.200
     1.557     0.400     0.200
     2.295    -4.057     0.200
     2.295    -4.721     0.200
     3.949   -16.317     0.200
     2.155    -5.650     0.200
     2.789    -7.784     0.200
     1.341     2.233     0.200
     1.491     0.469     0.200
     1.720    -1.694     0.200
     1.518    -0.086     0.200
     1.616    -0.778     0.200
     1.676    -0.530     0.200
     1.896    -2.739     0.200
     1.915    -2.311     0.200
     2.353    -5.531     0.200
     2.238    -4.312     0.200
     3.146    -9.871     0.200
     3.433   -13.631     0.200
     1.378     1.322     0.200
     1.429     0.169     0.200
     1.467    -0.098     0.200
     1.850    -2.271     0.200
     2.517    -6.750     0.200
     1.734    -0.682     0.200
     2.356    -4.520     0.200
     2.625    -7.825     0.200
     3.217   -12.025     0.200
     3.900   -16.132     0.200
     3.900   -15.812     0.200
     4.586   -22.294     0.200
     5.107   -27.939     0.200
     1.549    -0.948     0.200
     1.823    -2.596     0.200
     2.398    -5.515     0.200
     2.398    -6.305     0.200
     2.580    -6.629     0.200
     3.171   -13.358     0.200
     3.893   -17.266     0.200
     4.542   -21.331     0.200
     1.347     0.741     0.200
     2.373    -5.807     0.200
     2.902   -12.220     0.200
     3.196   -13.023     0.200
     3.892   -16.280     0.200
     8.560   -53.116     0.200
     1.696    -0.379     0.200
     3.878   -17.896     0.200
     1.610     0.900     0.200
     1.807    -0.674     0.200
     1.807    -0.546     0.200
     2.043    -2.222     0.200
     2.145    -2.385     0.200
     2.291    -3.270     0.200
     2.398    -4.717     0.200
     2.391    -5.708     0.200
     1.683    -0.442     0.200
     1.782     0.022     0.200
     1.854    -0.513     0.200
     1.869    -1.004     0.200
     2.335    -5.810     0.200
     1.691    -1.929     0.200
     2.319    -5.955     0.200
     2.397    -5.654     0.200
     1.719    -0.845     0.200
     1.756    -0.215     0.200
     1.756    -0.344     0.200
     1.829    -0.737     0.200
     1.930    -1.992     0.200
     2.177    -3.460     0.200
     2.172    -3.416     0.200
     2.330    -3.818     0.200
     2.330    -4.484     0.200
     2.700    -7.331     0.200
     3.982   -17.393     0.200
     1.700    -0.102     0.200
     1.756    -0.771     0.200
     1.838     0.072     0.200
     2.375    -4.714     0.200
     4.016   -16.860     0.200
     1.749    -0.648     0.200
     4.020   -16.346     0.200
     4.689   -22.352     0.200
     7.190   -43.415     0.200
     2.216    -4.563     0.200
     2.308    -4.044     0.200
     3.898   -16.756     0.200
     1.369     0.349     0.200
     1.369     0.485     0.200
     1.505     1.254     0.200
     1.654    -0.942     0.200
     1.751    -2.579     0.200
     2.265    -4.752     0.200
     2.265    -4.283     0.200
     2.643    -7.089     0.200
     2.882    -8.691     0.200
     3.234   -12.728     0.200
     3.221   -11.465     0.200
     3.345   -13.496     0.200
     3.638   -16.236     0.200
     3.855   -16.116     0.200
     3.926   -19.472     0.200
     4.357   -19.109     0.200
     4.674   -23.464     0.200
     5.158   -29.117     0.200
     5.256   -27.564     0.200
     5.757   -33.897     0.200
     8.549   -53.699     0.200
     8.586   -54.399     0.200
     1.686    -0.142     0.200
     1.773    -0.263     0.200
     2.213    -3.277     0.200
     3.871   -15.603     0.200
     1.756    -1.965     0.200
     2.257    -5.199     0.200
     2.257    -4.910     0.200
     3.631   -17.127     0.200
     3.800   -17.411     0.200
     3.904   -18.612     0.200
     4.397   -22.666     0.200
     1.751    -1.928     0.200
     2.252    -4.904     0.200
     2.252    -5.080     0.200
     2.329    -5.561     0.200
     2.984   -12.214     0.200
     3.206   -12.373     0.200
     3.345   -14.832     0.200
     3.625   -16.585     0.200
     3.797   -16.981     0.200
     3.797   -15.727     0.200
     3.902   -18.432     0.200
     4.048   -20.182     0.200
     4.391   -22.450     0.200
     4.661   -24.134     0.200
     1.613    -0.014     0.200
     1.613    -0.585     0.200
     2.054    -2.979     0.200
     2.240    -4.694     0.200
     2.285    -5.813     0.200
     2.706    -8.352     0.200
     3.014   -11.754     0.200
     3.319   -13.069     0.200
     3.365   -14.434     0.200
     3.753   -17.001     0.200
     3.799   -15.849     0.200
     4.651   -23.777     0.200
     5.184   -26.794     0.200
     1.186     2.244     0.200
     1.605    -0.509     0.200
     1.730    -1.679     0.200
     2.242    -4.512     0.200
     2.281    -5.525     0.200
     3.192   -12.055     0.200
     3.323   -13.779     0.200
     3.749   -17.158     0.200
     4.653   -23.786     0.200
     1.269     0.865     0.200
     1.781    -0.341     0.200
     2.399    -4.139     0.200
     2.924   -10.033     0.200
     3.480   -12.620     0.200
     3.864   -17.617     0.200
     1.502    -0.842     0.200
     1.617    -1.877     0.200
     1.886    -3.134     0.200
     2.130    -3.317     0.200
     2.257    -5.128     0.200
     2.497    -6.105     0.200
     2.894   -10.010     0.200
     2.848    -9.946     0.200
     3.038   -10.682     0.200
     3.213   -12.120     0.200
     3.213   -12.851     0.200
     3.310   -13.787     0.200
     3.310   -13.929     0.200
     3.333   -14.105     0.200
     3.426   -14.333     0.200
     3.820   -17.775     0.200
     3.853   -17.133     0.200
     4.174   -19.069     0.200
     4.374   -22.701     0.200
     4.677   -22.650     0.200
     4.665   -24.474     0.200
     5.287   -27.972     0.200
     5.321   -28.740     0.200
     5.559   -32.613     0.200
     6.138   -34.647     0.200
     7.008   -42.723     0.200
     1.402     1.091     0.200
     1.791    -0.430     0.200
     1.782    -0.652     0.200
     1.782    -0.387     0.200
     1.799    -0.068     0.200
     2.181    -3.038     0.200
     2.268    -3.794     0.200
     2.334    -4.228     0.200
     2.391    -4.527     0.200
     2.391    -4.328     0.200
     4.712   -20.424     0.200
     5.299   -24.832     0.200
     1.610    -0.725     0.200
     1.672    -1.721     0.200
     1.757    -1.812     0.200
     1.757    -1.952     0.200
     1.793    -2.008     0.200
     1.880    -2.499     0.200
     2.253    -5.286     0.200
     2.343    -6.270     0.200
     2.343    -6.015     0.200
     2.650    -8.642     0.200
     2.750    -8.787     0.200
     2.750    -9.044     0.200
     2.886    -9.301     0.200
     3.030    -9.910     0.200
     3.210   -13.318     0.200
     3.210   -11.738     0.200
     3.241   -13.801     0.200
     3.309   -13.858     0.200
     3.309   -13.732     0.200
     3.335   -15.165     0.200
     3.335   -14.375     0.200
     3.419   -14.152     0.200
     3.627   -16.919     0.200
     3.811   -17.527     0.200
     3.811   -16.271     0.200
     3.920   -18.762     0.200
     3.920   -17.920     0.200
     4.168   -19.173     0.200
     4.332   -21.178     0.200
     4.378   -22.789     0.200
     4.662   -24.464     0.200
     4.669   -22.563     0.200
     4.669   -22.201     0.200
     5.279   -27.247     0.200
     5.312   -27.998     0.200
     6.104   -36.008     0.200
     1.879     0.193     0.200
     1.880    -1.401     0.200
     2.130    -3.039     0.200
     2.538    -6.382     0.200
     3.280   -11.435     0.200
     3.654   -11.925     0.200
     4.449   -21.626     0.200
     4.987   -20.994     0.200
     5.031   -21.525     0.200
     5.045   -21.621     0.200
     5.281   -24.164     0.200
     5.894   -29.430     0.200
     6.475   -33.086     0.200
     6.547   -33.915     0.200
     1.628    -0.379     0.200
     1.628    -1.009     0.200
     2.068    -3.090     0.200
     2.243    -4.734     0.200
     2.297    -5.920     0.200
     2.297    -6.067     0.200
     2.357    -5.528     0.200
     2.357    -5.778     0.200
     2.606    -8.268     0.200
     2.715    -8.680     0.200
     2.982   -11.655     0.200
     3.194   -12.255     0.200
     3.194   -12.965     0.200
     3.317   -13.317     0.200
     3.317   -12.862     0.200
     3.370   -13.417     0.200
     3.765   -17.612     0.200
     3.866   -18.607     0.200
     4.625   -23.211     0.200
     5.233   -27.296     0.200
     5.257   -27.310     0.200
     6.051   -34.772     0.200
     6.089   -34.716     0.200
     7.131   -43.325     0.200
     1.630     0.637     0.200
     1.688     0.180     0.200
     1.837    -0.613     0.200
     2.354    -4.440     0.200
     2.354    -3.354     0.200
     2.354    -4.118     0.200
     2.354    -3.161     0.200
     2.476    -4.789     0.200
     2.476    -3.762     0.200
     2.507    -5.368     0.200
     2.711    -6.421     0.200
     3.038    -9.156     0.200
     3.038    -8.441     0.200
     3.302   -10.265     0.200
     3.436   -12.875     0.200
     3.823   -15.659     0.200
     3.885   -14.461     0.200
     3.899   -15.898     0.200
     4.006   -17.057     0.200
     4.523   -21.377     0.200
     4.689   -21.561     0.200
     5.239   -24.110     0.200
     5.284   -23.633     0.200
     5.293   -23.531     0.200
     6.091   -32.428     0.200
     6.798   -36.702     0.200
     7.194   -41.072     0.200
     1.282     1.488     0.200
     1.773    -0.888     0.200
     1.778    -0.580     0.200
     1.778    -0.463     0.200
     1.842    -1.030     0.200
     1.871     0.126     0.200
     2.312    -4.957     0.200
     2.312    -4.176     0.200
     2.402    -4.330     0.200
     2.721    -7.382     0.200
     2.910    -9.822     0.200
     3.290   -11.576     0.200
     3.867   -15.329     0.200
     4.721   -21.500     0.200
     5.334   -24.150     0.200
     5.383   -24.080     0.200
     6.169   -33.812     0.200
     1.409     0.131     0.200
     1.511    -0.208     0.200
     1.514    -0.544     0.200
     1.733    -1.629     0.200
     1.869    -2.217     0.200
     1.926    -3.437     0.200
     2.133    -4.386     0.200
     2.411    -4.053     0.200
     4.169   -18.857     0.200
     1.425     2.980     0.200
     1.756     1.093     0.200
     1.756    -0.235     0.200
     1.932    -0.921     0.200
     1.879    -0.696     0.200
     2.476    -5.489     0.200
     2.447    -3.291     0.200
     0.788     2.465     0.200
     1.537    -0.457     0.200
     1.606    -0.559     0.200
     1.852    -2.282     0.200
     2.226    -4.605     0.200
     2.230    -4.188     0.200
     2.327    -5.907     0.200
     2.381    -5.037     0.200
     2.381    -5.631     0.200
     2.423    -6.364     0.200
     2.540    -6.702     0.200
     3.062   -12.080     0.200
     3.260   -10.782     0.200
     3.298   -12.647     0.200
     3.317   -12.924     0.200
     3.601   -14.554     0.200
     3.695   -14.976     0.200
     3.784   -15.811     0.200
     3.973   -17.869     0.200
     4.044   -17.768     0.200
     4.465   -23.014     0.200
     5.119   -24.614     0.200
     5.973   -34.458     0.200
     1.814    -2.127     0.200
     1.864    -2.547     0.200
     2.008    -2.935     0.200
     2.111    -4.015     0.200
     2.287    -5.350     0.200
     2.326    -5.522     0.200
     2.336    -5.565     0.200
     2.516    -7.179     0.200
     2.777    -9.360     0.200
     3.002   -10.392     0.200
     3.042   -10.985     0.200
     3.292   -12.981     0.200
     3.941   -16.538     0.200
     1.755    -1.257     0.200
     2.192    -3.569     0.200
     2.352    -5.339     0.200
     2.682    -6.922     0.200
     2.930    -8.396     0.200
     3.457   -13.080     0.200
     3.875   -16.315     0.200
     1.810    -1.881     0.200
     1.827    -2.586     0.200
     1.864    -2.374     0.200
     1.864    -2.072     0.200
     1.892    -2.757     0.200
     1.963    -2.532     0.200
     2.017    -2.722     0.200
     2.296    -3.830     0.200
     2.324    -5.453     0.200
     2.331    -5.454     0.200
     1.860    -2.188     0.200
     1.411    -0.193     0.200
     1.571    -0.289     0.200
     1.765    -2.184     0.200
     1.812    -2.215     0.200
     1.812    -2.379     0.200
     1.821    -2.278     0.200
     1.864    -2.229     0.200
     1.864    -2.618     0.200
     2.219    -3.875     0.200
     2.290    -4.960     0.200
     2.290    -5.528     0.200
     2.324    -5.846     0.200
     2.334    -4.884     0.200
     2.334    -5.886     0.200
     2.517    -6.456     0.200
     2.780    -9.817     0.200
     2.882   -10.989     0.200
     2.882   -10.884     0.200
     3.005   -10.779     0.200
     3.045   -10.180     0.200
     3.045   -11.289     0.200
     3.291   -13.286     0.200
     3.291   -12.124     0.200
     3.287   -14.056     0.200
     3.563   -15.233     0.200
     3.609   -15.466     0.200
     3.694   -15.976     0.200
     3.944   -16.764     0.200
     3.981   -18.724     0.200
     3.981   -18.306     0.200
     3.991   -17.495     0.200
     4.040   -19.942     0.200
     4.108   -18.409     0.200
     4.267   -21.146     0.200
     4.295   -21.036     0.200
     4.314   -20.279     0.200
     4.475   -22.526     0.200
     4.528   -21.566     0.200
     4.697   -24.008     0.200
     4.722   -24.701     0.200
     4.752   -24.153     0.200
     4.814   -23.642     0.200
     4.831   -23.736     0.200
     4.831   -23.139     0.200
     1.086     1.701     0.200
     1.086     1.867     0.200
     1.773    -0.164     0.200
     1.661    -0.523     0.200
     1.713    -1.229     0.200
     2.179    -3.968     0.200
     2.340    -5.673     0.200
     2.340    -5.382     0.200
     2.693    -8.416     0.200
     2.940    -9.320     0.200
     3.467   -13.851     0.200
     4.727   -21.974     0.200
     1.322     2.388     0.200
     2.389    -5.627     0.200
     2.422    -5.805     0.200
     2.922   -11.126     0.200
     4.792   -23.310     0.200
     4.847   -23.921     0.200
     5.458   -29.490     0.200
     1.496     0.302     0.200
     1.488     0.371     0.200
     1.702    -0.514     0.200
     1.702    -0.856     0.200
     1.697    -0.709     0.200
     1.872    -2.414     0.200
     2.057    -3.042     0.200
     2.128    -3.017     0.200
     2.216    -4.284     0.200
     2.216    -4.430     0.200
     2.235    -4.914     0.200
     2.334    -6.427     0.200
     2.334    -4.850     0.200
     2.391    -5.945     0.200
     2.391    -4.617     0.200
     2.502    -5.925     0.200
     2.502    -5.736     0.200
     2.507    -7.319     0.200
     2.507    -5.912     0.200
     2.593    -8.001     0.200
     2.898    -8.792     0.200
     2.916   -11.229     0.200
     2.916   -10.115     0.200
     3.151   -12.383     0.200
     3.151   -10.776     0.200
     3.163   -12.503     0.200
     3.163   -11.868     0.200
     3.185   -12.002     0.200
     3.185   -10.728     0.200
     3.205   -13.178     0.200
     3.205   -10.552     0.200
     3.205   -12.604     0.200
     3.358   -13.041     0.200
     3.636   -15.712     0.200
     3.636   -14.995     0.200
     3.676   -15.020     0.200
     3.960   -17.710     0.200
     3.960   -17.082     0.200
     4.113   -19.016     0.200
     4.113   -17.464     0.200
     4.170   -21.280     0.200
     4.307   -21.467     0.200
     4.426   -20.365     0.200
     4.589   -20.625     0.200
     4.620   -24.527     0.200
     4.620   -21.254     0.200
     4.801   -24.835     0.200
     4.801   -21.824     0.200
     4.815   -22.314     0.200
     4.866   -23.412     0.200
     4.916   -24.238     0.200
     5.421   -30.780     0.200
     5.513   -29.923     0.200
     6.283   -36.902     0.200
     1.757    -1.265     0.200
     2.273    -3.642     0.200
     2.400    -4.456     0.200
     1.325     0.582     0.200
     1.319     0.994     0.200
     1.319     0.091     0.200
     1.382     0.567     0.200
     1.425     0.417     0.200
     1.548    -0.660     0.200
     1.806    -2.918     0.200
     1.809    -2.151     0.200
     1.861    -2.355     0.200
     1.884    -2.511     0.200
     1.962    -3.809     0.200
     1.995    -3.101     0.200
     2.263    -6.853     0.200
     2.328    -5.835     0.200
     2.484    -7.512     0.200
     2.656    -9.841     0.200
     3.088   -11.551     0.200
     3.168   -12.453     0.200
     3.425   -13.771     0.200
     3.699   -17.886     0.200
     3.945   -18.402     0.200
     4.230   -21.936     0.200
     4.225   -19.938     0.200
     4.322   -21.184     0.200
     5.408   -29.540     0.200
     5.483   -30.499     0.200
     1.211     1.930     0.200
     1.625     0.302     0.200
     1.754    -0.015     0.200
     1.754     0.414     0.200
     1.847    -0.838     0.200
     2.559    -5.197     0.200
     1.713    -0.431     0.200
     1.713    -0.720     0.200
     1.781    -0.653     0.200
     1.781    -0.415     0.200
     2.024    -3.184     0.200
     2.084    -2.633     0.200
     2.234    -3.514     0.200
     2.234    -3.990     0.200
     2.383    -5.069     0.200
     2.469    -6.939     0.200
     2.556    -6.446     0.200
     2.854    -8.753     0.200
     3.103   -10.677     0.200
     3.201    -9.662     0.200
     3.201   -11.966     0.200
     3.630   -14.318     0.200
     3.628   -14.739     0.200
     3.929   -16.298     0.200
     4.074   -16.549     0.200
     4.380   -20.048     0.200
     4.773   -20.822     0.200
     5.389   -24.090     0.200
     5.391   -25.990     0.200
     5.473   -26.051     0.200
     5.972   -32.430     0.200
     7.279   -42.364     0.200
     9.362   -56.551     0.200
     3.157   -11.451     0.200
     1.335     0.824     0.200
     1.638    -0.169     0.200
     1.708    -1.913     0.200
     2.110    -4.065     0.200
     2.259    -4.969     0.200
     2.259    -4.820     0.200
     2.266    -5.306     0.200
     2.422    -8.627     0.200
     2.369    -6.045     0.200
     2.369    -5.607     0.200
     2.446    -6.023     0.200
     2.446    -5.710     0.200
     2.601    -7.227     0.200
     3.211   -11.878     0.200
     3.331   -12.969     0.200
     3.370   -14.575     0.200
     3.781   -16.031     0.200
     4.116   -18.554     0.200
     4.281   -20.013     0.200
     4.520   -20.992     0.200
     4.420   -21.702     0.200
     4.560   -21.708     0.200
     4.597   -21.142     0.200
     1.640    -0.561     0.200
     2.254    -4.861     0.200
     2.261    -4.085     0.200
     2.312    -4.510     0.200
     2.364    -4.794     0.200
     2.607    -7.306     0.200
     2.838    -8.900     0.200
     3.373   -13.061     0.200
     3.779   -15.739     0.200
     1.342    -0.477     0.200
     1.641    -2.256     0.200
     1.956    -3.749     0.200
     2.011    -6.933     0.200
     1.622    -0.196     0.200
     2.263    -3.761     0.200
     2.357    -5.463     0.200
     3.042   -10.700     0.200
     3.824   -16.218     0.200
     3.932   -17.801     0.200
     1.577    -1.571     0.200
     1.825    -2.438     0.200
     1.919    -2.739     0.200
     1.957    -3.308     0.200
     2.244    -4.599     0.200
     2.291    -5.360     0.200
     2.265    -4.407     0.200
     2.447    -6.658     0.200
     2.509    -7.409     0.200
     2.691    -9.610     0.200
     3.131   -11.838     0.200
     3.210   -12.101     0.200
     3.229   -11.924     0.200
     3.909   -17.994     0.200
     4.045   -18.806     0.200
     4.756   -23.079     0.200
     5.373   -28.534     0.200
     5.442   -28.363     0.200
     6.220   -36.072     0.200
     0.644     2.709     0.200
     0.702     2.369     0.200
     0.967     1.856     0.200
     1.671    -1.258     0.200
     1.676    -1.268     0.200
     5.100   -24.874     0.200
     8.626   -55.153     0.200
     8.626   -54.012     0.200
     1.678    -1.317     0.200
     1.669    -0.771     0.200
     1.751    -1.747     0.200
     1.820    -1.940     0.200
     1.860    -2.067     0.200
     1.944    -2.677     0.200
     1.941    -2.321     0.200
     2.787    -9.149     0.200
     3.982   -17.942     0.200
     1.918    -2.327     0.200
     2.192    -4.713     0.200
     2.471    -6.407     0.200
     3.796   -17.379     0.200
     5.339   -28.911     0.200
     1.237     0.561     0.200
     1.366     0.815     0.200
     1.374     0.791     0.200
     1.372    -0.124     0.200
     1.517    -1.039     0.200
     1.825    -2.897     0.200
     1.881    -3.062     0.200
     1.454     1.194     0.200
     2.140    -4.548     0.200
     1.678    -0.325     0.200
     1.710    -0.603     0.200
     1.900    -3.564     0.200
     2.005    -2.530     0.200
     2.255    -3.424     0.200
     2.466    -5.143     0.200
     2.667    -5.969     0.200
     3.038   -11.727     0.200
     3.767   -13.589     0.200
     1.617    -0.135     0.200
     2.403    -5.369     0.200
     3.655   -15.829     0.200
     3.868   -16.819     0.200
     4.635   -22.711     0.200
     4.693   -23.388     0.200
     1.810    -0.958     0.200
     2.042    -3.288     0.200
     2.394    -4.880     0.200
     4.688   -23.336     0.200
     1.307     0.779     0.200
     1.428     0.355     0.200
     1.428     0.215     0.200
     1.419     0.369     0.200
     1.659    -1.933     0.200
     1.780    -1.956     0.200
     1.780    -1.984     0.200
     2.393    -6.626     0.200
     1.115     2.342     0.200
     1.115     0.760     0.200
     1.175     1.932     0.200
     1.526    -2.053     0.200
     1.536    -1.625     0.200
     1.606    -1.974     0.200
     1.719    -3.058     0.200
     1.724    -2.432     0.200
     1.693    -2.759     0.200
     1.734    -2.611     0.200
     1.934    -4.306     0.200
     1.961    -5.032     0.200
     2.008    -7.058     0.200
     2.090    -5.088     0.200
     2.295    -7.924     0.200
     2.350    -7.639     0.200
     2.416    -8.162     0.200
     2.534    -8.841     0.200
     4.841   -25.251     0.200
     1.397     0.845     0.200
     1.738    -0.388     0.200
     1.834    -1.136     0.200
     2.185    -4.081     0.200
     2.334    -5.471     0.200
     2.334    -4.522     0.200
     2.406    -5.368     0.200
     3.459   -12.678     0.200
     3.879   -14.856     0.200
     3.966   -16.237     0.200
     1.416     0.136     0.200
     1.801    -1.992     0.200
     1.932    -4.257     0.200
     2.015    -3.540     0.200
     2.265    -7.950     0.200
     2.714   -11.507     0.200
     4.011   -18.324     0.200
     4.806   -27.492     0.200
     1.414     0.270     0.200
     1.587    -0.888     0.200
     1.810    -1.968     0.200
     1.939    -3.309     0.200
     2.026    -3.032     0.200
     2.273    -3.479     0.200
     2.273    -6.587     0.200
     2.253    -6.801     0.200
     2.706   -11.292     0.200
     4.012   -18.692     0.200
     4.252   -19.271     0.200
     4.808   -24.270     0.200
     1.746    -1.024     0.200
     1.881    -0.230     0.200
     1.935    -1.322     0.200
     2.119    -2.408     0.200
     1.943    -0.834     0.200
     1.683     0.458     0.200
     1.737     0.494     0.200
     1.753     1.290     0.200
     1.959    -0.048     0.200
     2.457    -3.395     0.200
     2.749    -5.167     0.200
     1.326     1.466     0.200
     2.165    -3.185     0.200
     1.387     1.712     0.200
     1.689    -0.085     0.200
     1.932    -2.188     0.200
     1.894    -0.200     0.200
     2.060    -2.408     0.200
     1.826    -0.016     0.200
     1.904    -1.337     0.200
     1.543     1.497     0.200
     1.881    -0.224     0.200
     1.924    -0.472     0.200
     1.823    -1.001     0.200
     2.320    -4.743     0.200
     2.910    -8.595     0.200
     2.956    -6.307     0.200
     3.190   -11.114     0.200
     3.251    -6.678     0.200
     3.528   -10.283     0.200
     3.796   -14.046     0.200
     1.373     1.087     0.200
     1.544     1.103     0.200
     1.836    -1.183     0.200
     1.345     1.629     0.200
     1.413     1.356     0.200
     1.685    -0.197     0.200
     1.703    -0.155     0.200
     1.775     0.827     0.200
     1.552     0.221     0.200
     2.007    -2.796     0.200
     2.114    -2.655     0.200
     2.131    -3.650     0.200
     1.662     0.030     0.200
     1.718    -0.473     0.200
     1.737    -0.465     0.200
     1.989    -4.169     0.200
     2.106    -4.584     0.200
     2.086    -2.992     0.200
     2.340    -6.649     0.200
     2.373    -4.605     0.200
     2.518    -4.888     0.200
     2.477    -6.341     0.200
     2.580    -4.620     0.200
     2.718    -6.047     0.200
     2.890    -8.676     0.200
     2.934    -8.849     0.200
     1.487     0.970     0.200
     1.854     0.735     0.200
     2.005    -2.189     0.200
     1.925     0.098     0.200
     2.106    -2.239     0.200
     2.008    -2.253     0.200
     2.192    -3.287     0.200
     1.927    -1.158     0.200
     1.930    -1.254     0.200
     2.127    -3.707     0.200
     2.110    -2.771     0.200
     2.183    -3.276     0.200
     2.369    -4.399     0.200
     2.529    -5.853     0.200
     2.594    -6.362     0.200
     1.751     0.020     0.200
     2.128    -2.990     0.200
     2.742    -5.325     0.200
     3.242   -11.203     0.200
     1.438     1.035     0.200
     1.214     3.143     0.200
     2.038    -3.073     0.200
     2.477    -5.924     0.200
     2.528    -5.161     0.200
     3.103    -8.541     0.200
     1.373     1.852     0.200
     1.676     0.511     0.200
     2.123    -4.592     0.200
     1.245     2.415     0.200
     1.844    -0.032     0.200
     1.061     2.060     0.200
     2.084    -2.762     0.200
     1.703     0.067     0.200
     1.760     0.064     0.200
     1.227     2.111     0.200
     2.044    -2.172     0.200
     2.168    -2.575     0.200
     1.858     0.666     0.200
     2.027    -2.567     0.200
     2.092    -3.535     0.200
     1.677     0.000     0.200
     1.733     0.286     0.200
     1.392     1.144     0.200
     1.688     0.063     0.200
     1.504     1.095     0.200
     1.794     0.390     0.200
     2.621    -4.656     0.200
     2.477    -4.365     0.200
     7.071   -41.107     0.200
     1.255     1.586     0.200
     1.693     0.420     0.200
     1.820    -0.370     0.200
     2.584    -4.064     0.200
     3.174    -9.477     0.200
     3.669   -14.474     0.200
     1.037     2.356     0.200
     1.023     2.528     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.222    -0.265     0.200
     2.269    -2.442     0.200
     8.640    -5.782     0.200
     1.106     0.904     0.200
     1.835    -1.381     0.200
     2.138    -1.107     0.200
     3.945    -3.098     0.200
     5.000    -4.534     0.200
     1.352    -2.648     0.200
     3.992    -3.930     0.200
     4.664    -3.025     0.200
     8.631    -6.960     0.200
     1.343    -2.466     0.200
     1.609     0.369     0.200
     3.988    -4.420     0.200
     5.645    -2.762     0.200
     0.438     0.534     0.200
     0.441     0.247     0.200
     0.706     0.173     0.200
     1.176     0.205     0.200
     1.292    -0.991     0.200
     1.660    -1.528     0.200
     1.829    -1.515     0.200
     3.960    -3.050     0.200
     4.725    -2.788     0.200
     5.696    -2.685     0.200
     0.263     0.579     0.200
     0.328     0.966     0.200
     1.223     0.042     0.200
     1.565    -2.240     0.200
     1.823    -2.473     0.200
     1.700    -3.214     0.200
     4.905    -4.807     0.200
     0.193     0.773     0.200
     1.105     0.543     0.200
     1.232    -0.085     0.200
     4.827    -2.926     0.200
     0.294     0.016     0.200
     0.345     0.004     0.200
     1.042     1.193     0.200
     1.405     0.104     0.200
     1.511    -1.078     0.200
     0.327     0.079     0.200
     0.748     1.330     0.200
     1.047     1.240     0.200
     1.222     0.363     0.200
     2.407    -3.185     0.200
     0.277     1.136     0.200
     0.360     0.972     0.200
     0.274     1.299     0.200
     0.564     1.578     0.200
     1.594    -1.212     0.200
     1.650    -1.272     0.200
     1.161     0.627     0.200
     0.865     2.165     0.200
     3.185    -3.776     0.200
     5.097    -3.618     0.200
     1.238     0.681     0.200
     1.377     0.793     0.200
     1.789    -2.200     0.200
     5.005    -3.128     0.200
     1.137     0.127     0.200
     1.348     0.180     0.200
     1.828    -0.733     0.200
     5.079    -3.518     0.200
     9.990    -4.921     0.200
     1.371    -0.846     0.200
     1.151     0.545     0.200
     1.329     0.157     0.200
     1.563    -1.439     0.200
     2.526    -1.642     0.200
     5.297    -4.114     0.200
     1.207    -0.372     0.200
     2.382    -3.359     0.200
     3.874    -4.564     0.200
     5.213    -2.450     0.200
     5.689    -4.146     0.200
     0.298     0.379     0.200
     1.013     0.549     0.200
     1.249    -0.541     0.200
     3.850    -3.115     0.200
     0.453     0.667     0.200
     1.734    -1.736     0.200
     3.960    -3.449     0.200
     5.079    -3.196     0.200
     5.079    -2.821     0.200
     5.825    -3.368     0.200
     8.600    -4.049     0.200
     0.440     0.702     0.200
     1.180    -0.460     0.200
     3.973    -4.046     0.200
     5.087    -2.789     0.200
     5.087    -4.234     0.200
     5.830    -3.664     0.200
     7.623    -3.830     0.200
     8.422    -6.864     0.200
     8.616    -3.789     0.200
     0.457     0.620     0.200
     1.162     0.099     0.200
     1.729    -0.656     0.200
     5.082    -3.279     0.200
     5.082    -3.912     0.200
     1.139    -0.343     0.200
     2.277    -2.747     0.200
     5.079    -2.651     0.200
     5.079    -3.315     0.200
     7.639    -5.165     0.200
     8.404    -5.275     0.200
     8.571    -5.184     0.200
    12.084    -6.592     0.200
     0.465     0.204     0.200
     1.160    -0.254     0.200
     1.203     1.021     0.200
     2.295    -0.744     0.200
     3.949    -2.583     0.200
     5.087    -3.295     0.200
     8.417    -6.137     0.200
     0.686     1.016     0.200
     1.243     0.805     0.200
     1.498    -0.341     0.200
     1.618    -0.624     0.200
     2.272    -2.239     0.200
     2.296    -2.263     0.200
     5.196    -2.639     0.200
     1.196    -0.225     0.200
     5.087    -4.030     0.200
     6.152    -7.436     0.200
     0.382    -0.024     0.200
     0.643     1.268     0.200
     0.878     0.521     0.200
     0.939     0.246     0.200
     1.023    -0.845     0.200
     1.226     0.131     0.200
     1.238    -0.575     0.200
     1.227     1.257     0.200
     1.420    -1.162     0.200
     1.720    -1.452     0.200
     1.626    -1.344     0.200
     1.808    -3.183     0.200
     3.954    -3.100     0.200
     5.143    -4.877     0.200
     0.226     1.321     0.200
     0.226     0.879     0.200
     0.460     1.191     0.200
     0.490     2.430     0.200
     0.758     1.079     0.200
     0.800     1.355     0.200
     0.947     0.269     0.200
     1.076     0.940     0.200
     1.125     0.400     0.200
     1.167    -0.139     0.200
     1.345    -1.331     0.200
     1.366    -0.177     0.200
     1.580    -2.387     0.200
     1.733    -0.209     0.200
     5.282    -3.153     0.200
     0.373     1.096     0.200
     0.776     0.401     0.200
     0.959     0.556     0.200
     1.194     0.167     0.200
     1.261     0.359     0.200
     1.632    -1.992     0.200
     1.757    -1.101     0.200
     2.242    -2.957     0.200
     4.676    -2.703     0.200
     5.174    -3.527     0.200
     0.331     0.751     0.200
     0.331     0.920     0.200
     0.534     0.983     0.200
     0.812     0.695     0.200
     0.867     1.269     0.200
     0.979     0.375     0.200
     1.227     0.017     0.200
     1.227    -0.143     0.200
     1.313    -0.539     0.200
     1.283     0.407     0.200
     1.590    -0.305     0.200
     1.801    -1.537     0.200
     2.020    -1.376     0.200
     3.950    -5.177     0.200
     5.219    -3.659     0.200
     0.239     0.745     0.200
     0.356     0.398     0.200
     0.789     0.523     0.200
     0.789     0.242     0.200
     0.893     1.313     0.200
     0.963     0.433     0.200
     0.963     0.324     0.200
     1.205    -0.421     0.200
     1.205    -0.222     0.200
     1.266     0.348     0.200
     1.266     0.488     0.200
     1.575    -1.770     0.200
     1.777    -0.559     0.200
     2.902    -3.390     0.200
     5.194    -2.486     0.200
     5.712    -6.735     0.200
     6.612    -9.076     0.200
     8.560    -5.046     0.200
     0.548    -0.495     0.200
     0.548     0.038     0.200
     0.548    -0.071     0.200
     0.613     0.694     0.200
     0.613     0.564     0.200
     0.845     0.648     0.200
     1.004     1.097     0.200
     1.038     0.369     0.200
     1.083     0.660     0.200
     1.136     0.535     0.200
     1.382    -0.177     0.200
     1.380    -0.140     0.200
     1.608    -0.869     0.200
     1.769    -1.998     0.200
     1.783    -1.167     0.200
     1.892    -1.632     0.200
     2.182    -1.812     0.200
     2.749    -2.400     0.200
     5.013    -2.571     0.200
     0.257    -0.059     0.200
     0.340    -0.026     0.200
     0.340     0.285     0.200
     0.588     1.835     0.200
     0.867     1.542     0.200
     0.923    -2.081     0.200
     0.962    -0.567     0.200
     1.072     1.652     0.200
     1.214    -0.156     0.200
     1.267     0.165     0.200
     1.408     0.683     0.200
     1.533    -0.855     0.200
     1.550    -0.191     0.200
     1.581    -1.744     0.200
     1.625    -0.690     0.200
     1.692    -2.108     0.200
     1.711    -1.607     0.200
     1.711    -0.787     0.200
     1.823    -1.381     0.200
     2.391    -2.699     0.200
     5.222    -3.128     0.200
     0.789     0.484     0.200
     0.985     0.066     0.200
     1.021    -0.410     0.200
     1.086    -0.665     0.200
     1.216    -0.131     0.200
     1.266     0.532     0.200
     1.300    -0.878     0.200
     1.668    -1.693     0.200
     1.736    -0.973     0.200
     2.781    -3.371     0.200
     0.234     0.915     0.200
     0.332     0.811     0.200
     0.584     2.480     0.200
     0.531     0.363     0.200
     0.801     1.067     0.200
     0.812     0.679     0.200
     0.870     1.240     0.200
     0.980     0.787     0.200
     1.075     0.019     0.200
     1.165     0.669     0.200
     1.192    -1.481     0.200
     1.192    -1.270     0.200
     1.227    -0.128     0.200
     1.227    -0.346     0.200
     1.284     0.075     0.200
     1.414    -0.215     0.200
     1.543    -1.472     0.200
     1.593    -2.011     0.200
     1.647     0.301     0.200
     1.724    -0.819     0.200
     5.217    -3.046     0.200
     0.177     0.331     0.200
     0.413     0.604     0.200
     0.413     0.737     0.200
     0.776     0.327     0.200
     0.776     0.856     0.200
     0.918     0.680     0.200
     0.977     1.037     0.200
     1.000     0.477     0.200
     1.000     0.688     0.200
     1.202    -0.157     0.200
     1.202     0.031     0.200
     1.261     0.308     0.200
     1.283     0.433     0.200
     1.295     0.821     0.200
     1.410     0.215     0.200
     1.315    -0.303     0.200
     1.531     0.288     0.200
     1.667    -0.993     0.200
     1.851    -1.375     0.200
     2.130    -0.618     0.200
     2.184    -1.104     0.200
     2.557    -2.197     0.200
     0.342     1.010     0.200
     1.087     0.410     0.200
     1.275     0.668     0.200
     1.289     0.226     0.200
     1.331    -0.237     0.200
     1.893    -1.876     0.200
     1.907    -1.755     0.200
     5.101    -3.649     0.200
     0.398    -0.320     0.200
     0.776    -0.086     0.200
     0.955    -0.016     0.200
     1.009    -0.309     0.200
     1.016    -0.314     0.200
     1.107    -0.717     0.200
     1.204     0.571     0.200
     1.238    -1.239     0.200
     1.321    -0.908     0.200
     1.308     0.205     0.200
     1.435     0.143     0.200
     1.706    -1.570     0.200
     1.758    -1.497     0.200
     1.795    -1.384     0.200
     1.869    -1.833     0.200
     1.891    -1.599     0.200
     2.315    -2.645     0.200
     0.155     0.142     0.200
     0.393     0.461     0.200
     0.425     0.551     0.200
     0.425     0.549     0.200
     0.689     2.342     0.200
     0.790     1.252     0.200
     0.790     0.961     0.200
     0.943     1.003     0.200
     1.027     0.668     0.200
     1.218    -0.255     0.200
     1.218     0.889     0.200
     1.240    -0.396     0.200
     1.275     0.571     0.200
     1.320     0.137     0.200
     1.443    -0.140     0.200
     1.696    -0.908     0.200
     1.696    -1.047     0.200
     1.868    -0.766     0.200
     2.769    -2.777     0.200
     3.657    -2.726     0.200
     5.085    -2.365     0.200
     5.863    -3.286     0.200
    12.150    -5.062     0.200
     0.421    -0.166     0.200
     0.732     0.317     0.200
     0.890    -0.345     0.200
     0.929    -0.075     0.200
     1.152    -0.725     0.200
     1.257    -0.200     0.200
     1.228     0.210     0.200
     1.626    -1.385     0.200
     1.673    -1.296     0.200
     1.676    -0.809     0.200
     1.712    -1.430     0.200
     1.801    -1.515     0.200
     3.303    -2.356     0.200
     0.211     0.838     0.200
     0.377     0.448     0.200
     0.377     0.686     0.200
     0.491     0.788     0.200
     0.491     0.105     0.200
     0.491     1.255     0.200
     0.491     0.001     0.200
     0.635     2.481     0.200
     0.705    -0.192     0.200
     0.780     0.461     0.200
     0.861    -0.647     0.200
     0.998     0.240     0.200
     0.974     0.724     0.200
     0.974     0.072     0.200
     0.974     0.357     0.200
     1.038    -0.155     0.200
     1.133     0.121     0.200
     1.213    -1.496     0.200
     1.215    -0.084     0.200
     1.218     0.612     0.200
     1.201     0.079     0.200
     1.201    -0.147     0.200
     1.253    -1.123     0.200
     1.275     0.033     0.200
     1.396    -1.735     0.200
     1.605    -1.521     0.200
     1.691    -0.457     0.200
     1.691    -0.137     0.200
     1.762    -1.050     0.200
     1.785    -1.516     0.200
     1.738    -0.552     0.200
     1.768    -0.911     0.200
     1.805    -1.400     0.200
     1.873    -2.048     0.200
     1.896    -3.709     0.200
     2.860    -2.797     0.200
     3.345    -1.855     0.200
     5.158    -5.589     0.200
     5.158    -3.913     0.200
     5.667    -2.746     0.200
     8.549    -5.898     0.200
     8.586    -7.181     0.200
     0.325     0.158     0.200
     0.540     0.054     0.200
     0.540    -0.071     0.200
     0.552    -0.081     0.200
     0.552     0.306     0.200
     0.618     0.392     0.200
     0.747    -0.546     0.200
     0.747    -0.773     0.200
     0.844     0.481     0.200
     1.042    -0.353     0.200
     1.113     0.892     0.200
     1.124    -0.132     0.200
     1.136     0.010     0.200
     1.619    -0.972     0.200
     1.619    -0.514     0.200
     1.625    -0.244     0.200
     1.625    -0.448     0.200
     1.639    -0.691     0.200
     1.686    -0.720     0.200
     1.716    -1.927     0.200
     1.758    -1.831     0.200
     2.095    -1.073     0.200
     2.108    -0.219     0.200
     2.108    -0.958     0.200
     2.270    -0.517     0.200
     2.760    -2.638     0.200
     2.834    -2.473     0.200
     3.124    -2.115     0.200
     3.186    -3.275     0.200
     4.064    -3.023     0.200
     4.759    -3.623     0.200
     5.024    -3.900     0.200
     0.374     0.780     0.200
     0.374     0.706     0.200
     0.492     0.726     0.200
     0.514     0.601     0.200
     0.681    -0.147     0.200
     0.681    -0.311     0.200
     0.776     0.850     0.200
     0.961     0.468     0.200
     0.961     0.620     0.200
     1.056    -0.340     0.200
     1.117    -0.076     0.200
     1.117    -0.338     0.200
     1.194    -0.044     0.200
     1.194    -0.099     0.200
     1.262     0.337     0.200
     1.286    -0.140     0.200
     1.286    -0.355     0.200
     1.635    -0.320     0.200
     1.667    -0.055     0.200
     1.667    -0.473     0.200
     1.754    -1.234     0.200
     1.754    -0.891     0.200
     1.766    -1.197     0.200
     1.804    -1.911     0.200
     2.989    -2.704     0.200
     3.351    -2.406     0.200
     4.336    -3.354     0.200
     4.397    -3.127     0.200
     5.530    -2.746     0.200
     0.234     1.127     0.200
     0.380     0.628     0.200
     0.380     0.890     0.200
     0.486     0.835     0.200
     0.486     0.515     0.200
     0.515     0.630     0.200
     0.515     0.279     0.200
     0.515     0.423     0.200
     0.683    -0.244     0.200
     0.683    -0.658     0.200
     0.770     0.884     0.200
     0.956     0.666     0.200
     0.956     0.353     0.200
     0.980    -1.207     0.200
     1.051    -0.404     0.200
     1.051    -0.271     0.200
     1.116    -0.446     0.200
     1.116    -0.161     0.200
     1.195    -1.169     0.200
     1.197     0.015     0.200
     1.188    -0.069     0.200
     1.188     0.224     0.200
     1.257     0.593     0.200
     1.280    -0.032     0.200
     1.280    -0.200     0.200
     1.378    -1.432     0.200
     1.639    -0.547     0.200
     1.667    -0.139     0.200
     1.749    -1.605     0.200
     1.751    -1.749     0.200
     1.769    -1.236     0.200
     1.798    -1.841     0.200
     2.102    -2.914     0.200
     2.792    -2.615     0.200
     2.796    -3.104     0.200
     2.867    -2.822     0.200
     2.984    -2.480     0.200
     3.015    -1.712     0.200
     3.201    -3.042     0.200
     3.345    -2.020     0.200
     5.166    -2.534     0.200
     5.530    -2.618     0.200
     0.372     0.664     0.200
     0.372     0.641     0.200
     0.497    -0.389     0.200
     0.568    -0.160     0.200
     0.568     0.223     0.200
     0.628    -0.604     0.200
     0.769    -0.127     0.200
     0.930     0.223     0.200
     0.930     0.371     0.200
     1.064    -0.435     0.200
     1.097    -0.229     0.200
     1.145    -1.197     0.200
     1.147    -1.108     0.200
     1.181    -0.223     0.200
     1.181     0.168     0.200
     1.234     0.493     0.200
     1.305     0.091     0.200
     1.547    -1.916     0.200
     1.593    -2.241     0.200
     1.684    -0.201     0.200
     1.721    -1.555     0.200
     1.730    -1.310     0.200
     1.730    -1.552     0.200
     1.802    -1.291     0.200
     2.738    -2.251     0.200
     0.284     0.772     0.200
     0.368     0.682     0.200
     0.503     0.158     0.200
     0.575     0.066     0.200
     0.619    -0.447     0.200
     0.806     0.281     0.200
     0.930     0.195     0.200
     1.058    -0.488     0.200
     1.106    -0.674     0.200
     1.183    -0.767     0.200
     1.306     0.339     0.200
     1.234     0.308     0.200
     1.312    -0.221     0.200
     1.538    -2.141     0.200
     1.584    -2.653     0.200
     1.676    -0.966     0.200
     1.713    -2.164     0.200
     1.799    -1.123     0.200
     2.929    -4.055     0.200
     3.022    -1.951     0.200
     3.985    -2.467     0.200
     4.427    -4.086     0.200
     5.470    -3.528     0.200
     6.084    -3.752     0.200
     0.431     0.287     0.200
     0.431     0.024     0.200
     0.420     0.704     0.200
     0.420     0.733     0.200
     0.468     0.700     0.200
     0.777    -1.536     0.200
     0.925     0.971     0.200
     0.969    -0.462     0.200
     0.969    -0.299     0.200
     0.996     0.030     0.200
     0.996     0.559     0.200
     1.197     0.287     0.200
     1.232     0.125     0.200
     1.285    -0.219     0.200
     1.288     0.065     0.200
     1.291     0.408     0.200
     1.322    -0.498     0.200
     1.408     0.357     0.200
     1.408     0.230     0.200
     1.673    -1.154     0.200
     1.673    -0.865     0.200
     1.674    -0.938     0.200
     1.725    -1.242     0.200
     1.937    -0.795     0.200
     2.190    -0.841     0.200
     2.791    -2.233     0.200
     2.952    -3.251     0.200
     3.084    -2.223     0.200
     3.302    -2.257     0.200
     3.302    -2.516     0.200
     4.334    -3.694     0.200
     5.098    -3.859     0.200
     0.212     1.504     0.200
     0.389     0.241     0.200
     0.389     0.768     0.200
     0.389     1.049     0.200
     0.480     0.863     0.200
     0.480     0.414     0.200
     0.487    -0.142     0.200
     0.487     0.727     0.200
     0.648     1.608     0.200
     0.713    -0.281     0.200
     0.713    -0.441     0.200
     0.771     0.659     0.200
     0.771     0.879     0.200
     0.874     0.855     0.200
     0.939     0.790     0.200
     0.969     0.475     0.200
     0.969     0.330     0.200
     1.009    -1.598     0.200
     1.025    -0.297     0.200
     1.025    -0.467     0.200
     1.192     0.049     0.200
     1.224    -1.363     0.200
     1.231     0.038     0.200
     1.231    -0.380     0.200
     1.265    -0.470     0.200
     1.269     0.459     0.200
     1.265    -0.041     0.200
     1.265    -0.232     0.200
     1.617    -1.357     0.200
     1.666    -1.620     0.200
     1.762    -1.931     0.200
     1.797    -1.263     0.200
     1.794    -1.959     0.200
     1.899    -1.642     0.200
     2.766    -3.310     0.200
     2.965    -1.809     0.200
     3.127    -2.407     0.200
     3.710    -5.053     0.200
     3.820    -2.476     0.200
     4.077    -3.169     0.200
     4.358    -4.099     0.200
     4.374    -2.713     0.200
     4.865    -4.060     0.200
     5.145    -3.293     0.200
     6.753    -3.808     0.200
     0.182     0.120     0.200
     0.442     0.507     0.200
     0.406     0.383     0.200
     0.406     0.953     0.200
     0.476     0.703     0.200
     0.669     2.722     0.200
     0.776     0.985     0.200
     0.776     0.458     0.200
     0.761    -0.369     0.200
     0.908     0.242     0.200
     0.986    -0.476     0.200
     0.986    -0.984     0.200
     0.986    -1.144     0.200
     0.968     0.364     0.200
     0.968     1.337     0.200
     0.994     0.557     0.200
     1.054     0.630     0.200
     1.054     0.451     0.200
     1.201    -0.266     0.200
     1.201    -0.000     0.200
     1.175     0.677     0.200
     1.245     0.490     0.200
     1.245     0.389     0.200
     1.245     0.209     0.200
     1.254     1.159     0.200
     1.291    -0.081     0.200
     1.268    -0.124     0.200
     1.271     0.280     0.200
     1.304     0.565     0.200
     1.371     0.586     0.200
     1.451     0.114     0.200
     1.656    -1.175     0.200
     1.731    -1.779     0.200
     1.744    -1.712     0.200
     1.799    -2.170     0.200
     1.839    -0.149     0.200
     1.920    -1.667     0.200
     2.173    -1.389     0.200
     2.552    -2.492     0.200
     3.306    -2.007     0.200
     3.315    -3.204     0.200
     3.832    -3.468     0.200
     4.349    -4.214     0.200
     0.220     1.080     0.200
     0.388     0.443     0.200
     0.388     0.646     0.200
     0.388     1.005     0.200
     0.496     0.297     0.200
     0.496     0.059     0.200
     0.480     0.522     0.200
     0.480     0.862     0.200
     0.645     0.920     0.200
     0.704    -0.274     0.200
     0.704    -0.169     0.200
     0.769     0.950     0.200
     0.935     0.438     0.200
     0.964     0.468     0.200
     1.001    -1.226     0.200
     1.032    -0.576     0.200
     1.135    -0.148     0.200
     1.135     0.062     0.200
     1.135    -0.041     0.200
     1.189     0.121     0.200
     1.215    -1.500     0.200
     1.228     0.139     0.200
     1.228    -0.249     0.200
     1.218    -0.154     0.200
     1.259    -0.013     0.200
     1.268    -0.211     0.200
     1.268    -0.550     0.200
     1.268    -0.318     0.200
     1.264     0.297     0.200
     1.688     0.429     0.200
     1.688    -0.552     0.200
     1.732    -1.016     0.200
     1.732    -1.216     0.200
     1.759    -0.537     0.200
     1.789    -1.417     0.200
     2.813    -2.309     0.200
     2.970    -2.122     0.200
     2.970    -2.274     0.200
     4.068    -2.326     0.200
     4.872    -3.634     0.200
     5.150    -3.932     0.200
     6.104    -5.608     0.200
     6.131    -4.309     0.200
     0.465    -0.095     0.200
     0.479    -0.165     0.200
     0.479     0.114     0.200
     0.506     0.322     0.200
     0.506     0.213     0.200
     0.676     0.148     0.200
     0.712     0.385     0.200
     0.712     0.584     0.200
     0.815    -0.965     0.200
     0.786    -0.028     0.200
     0.867     0.526     0.200
     0.867     0.413     0.200
     0.867     0.637     0.200
     1.025    -0.841     0.200
     1.028    -0.981     0.200
     1.090    -0.219     0.200
     1.215    -0.301     0.200
     1.215    -0.173     0.200
     1.332    -0.296     0.200
     1.422     0.319     0.200
     1.422    -0.349     0.200
     1.464    -2.167     0.200
     1.500    -0.796     0.200
     1.615    -1.425     0.200
     1.591    -0.247     0.200
     1.591    -0.405     0.200
     1.945    -2.355     0.200
     2.090     1.221     0.200
     2.090    -0.652     0.200
     2.092    -1.283     0.200
     2.092    -1.451     0.200
     2.130    -1.363     0.200
     2.130    -1.488     0.200
     2.236    -1.000     0.200
     2.236    -1.676     0.200
     2.340    -1.938     0.200
     2.809    -2.964     0.200
     3.032    -3.737     0.200
     3.362    -2.885     0.200
     3.499    -2.377     0.200
     4.449    -3.085     0.200
     5.260    -3.233     0.200
     5.956    -5.477     0.200
     0.374     0.479     0.200
     0.374     0.718     0.200
     0.493     0.153     0.200
     0.493     0.741     0.200
     0.554    -0.132     0.200
     0.554     0.003     0.200
     0.622     0.880     0.200
     0.768     0.458     0.200
     0.824    -0.380     0.200
     0.936     0.492     0.200
     0.936     0.292     0.200
     1.078    -0.431     0.200
     1.084    -0.331     0.200
     1.084    -1.164     0.200
     1.158    -2.112     0.200
     1.161    -0.399     0.200
     1.199     0.611     0.200
     1.199    -0.043     0.200
     1.182     0.297     0.200
     1.182     0.192     0.200
     1.209    -1.672     0.200
     1.319     0.527     0.200
     1.319    -0.092     0.200
     1.240    -0.458     0.200
     1.298     0.200     0.200
     1.298    -0.556     0.200
     1.559    -2.219     0.200
     1.698    -0.967     0.200
     1.734    -1.400     0.200
     1.735    -1.205     0.200
     1.735    -1.326     0.200
     1.800    -1.176     0.200
     1.835    -1.902     0.200
     2.261    -1.595     0.200
     2.982    -1.755     0.200
     3.006    -2.073     0.200
     3.057    -1.924     0.200
     3.057    -1.738     0.200
     3.317    -2.752     0.200
     4.008    -2.491     0.200
     4.412    -4.565     0.200
     5.491    -3.227     0.200
     6.051    -2.701     0.200
     6.089    -2.686     0.200
     6.105    -2.874     0.200
     0.255     0.176     0.200
     0.255     0.082     0.200
     0.503     0.595     0.200
     0.553    -0.833     0.200
     0.553    -0.481     0.200
     0.612    -0.108     0.200
     0.612    -0.331     0.200
     0.881    -0.346     0.200
     0.886     0.567     0.200
     1.034    -0.344     0.200
     1.034     0.316     0.200
     1.095    -0.242     0.200
     1.097    -0.662     0.200
     1.103    -0.384     0.200
     1.103    -0.072     0.200
     1.121    -0.521     0.200
     1.170    -0.342     0.200
     1.392     0.205     0.200
     1.392     0.393     0.200
     1.296     0.394     0.200
     1.296    -0.711     0.200
     1.340     0.123     0.200
     1.412     0.294     0.200
     1.412    -0.085     0.200
     1.473    -2.112     0.200
     1.660    -0.601     0.200
     1.837    -1.187     0.200
     2.297    -0.186     0.200
     2.297    -0.764     0.200
     2.363    -0.427     0.200
     3.279    -3.702     0.200
     0.425    -0.445     0.200
     0.433    -0.040     0.200
     0.433     0.554     0.200
     0.460     0.197     0.200
     0.763     0.569     0.200
     0.939     0.595     0.200
     0.955    -0.224     0.200
     0.994     0.358     0.200
     0.994    -0.290     0.200
     1.190    -0.115     0.200
     1.219     0.263     0.200
     1.219    -0.190     0.200
     1.210    -0.038     0.200
     1.299    -0.224     0.200
     1.302     0.047     0.200
     1.410     0.210     0.200
     1.336    -0.645     0.200
     1.688    -1.062     0.200
     1.768    -1.358     0.200
     1.768    -1.162     0.200
     2.204    -1.078     0.200
     2.204    -1.477     0.200
     2.572    -2.168     0.200
     2.790    -1.700     0.200
     2.910    -1.931     0.200
     2.966    -2.463     0.200
     3.290    -3.194     0.200
     3.290    -2.631     0.200
     3.287    -2.153     0.200
     4.148    -2.815     0.200
     4.321    -3.702     0.200
     4.721    -2.429     0.200
     4.798    -3.598     0.200
     0.247     0.497     0.200
     0.275     0.696     0.200
     0.485     0.923     0.200
     0.585     0.980     0.200
     0.585     0.761     0.200
     0.769     0.151     0.200
     0.769    -0.403     0.200
     0.769    -0.669     0.200
     0.799     0.102     0.200
     0.847     1.879     0.200
     0.847     1.442     0.200
     1.105     0.508     0.200
     1.120     0.256     0.200
     1.120     0.459     0.200
     1.127     0.035     0.200
     1.127    -0.074     0.200
     1.228     0.265     0.200
     1.228     0.030     0.200
     1.228    -0.118     0.200
     1.297    -0.569     0.200
     1.297    -0.991     0.200
     1.409    -0.275     0.200
     1.429    -0.469     0.200
     1.429    -0.203     0.200
     1.486    -1.747     0.200
     1.486    -2.262     0.200
     1.533    -1.259     0.200
     1.748    -1.340     0.200
     1.854    -0.971     0.200
     1.887    -1.985     0.200
     1.975    -0.864     0.200
     1.975    -1.755     0.200
     1.991    -2.193     0.200
     2.077    -2.587     0.200
     2.581    -3.168     0.200
     2.771    -2.335     0.200
     3.190    -3.252     0.200
     3.245    -1.822     0.200
     3.247    -2.485     0.200
     4.185    -4.197     0.200
     5.481    -4.238     0.200
     0.522    -0.901     0.200
     0.522    -0.557     0.200
     0.532     1.032     0.200
     0.594    -0.006     0.200
     0.594    -0.210     0.200
     0.656     0.313     0.200
     0.842     0.644     0.200
     0.950    -0.036     0.200
     0.950     0.370     0.200
     0.993    -0.363     0.200
     0.993    -0.129     0.200
     1.026    -2.037     0.200
     1.094     1.113     0.200
     1.290     0.752     0.200
     1.290     0.424     0.200
     1.220    -0.721     0.200
     1.238     0.020     0.200
     1.413    -1.323     0.200
     1.523    -0.166     0.200
     2.246    -1.198     0.200
     2.306    -0.192     0.200
     2.306    -1.661     0.200
     2.287    -1.740     0.200
     2.447    -2.581     0.200
     4.583    -2.291     0.200
     5.185    -4.551     0.200
     6.054    -3.990     0.200
     0.345     0.855     0.200
     0.371     0.997     0.200
     0.371     0.915     0.200
     0.550    -0.524     0.200
     0.550    -0.114     0.200
     0.527     0.075     0.200
     0.642    -0.185     0.200
     0.777     0.783     0.200
     0.777     0.462     0.200
     0.853     0.719     0.200
     0.901     0.615     0.200
     0.993     0.056     0.200
     0.993    -0.233     0.200
     0.993    -0.061     0.200
     1.075    -1.407     0.200
     1.259     0.061     0.200
     1.259     0.831     0.200
     1.161     0.070     0.200
     1.209     0.179     0.200
     1.347    -0.141     0.200
     1.653    -2.491     0.200
     1.705    -1.096     0.200
     1.705    -0.955     0.200
     1.770    -1.550     0.200
     1.815    -1.391     0.200
     1.815    -1.691     0.200
     1.985    -0.467     0.200
     2.661    -1.822     0.200
     2.747    -2.541     0.200
     2.965    -2.070     0.200
     3.043    -3.066     0.200
     3.173    -1.908     0.200
     3.399    -2.029     0.200
     3.917    -3.692     0.200
     0.136     1.706     0.200
     0.307     0.090     0.200
     0.463     0.312     0.200
     0.515     0.592     0.200
     0.515     0.720     0.200
     0.898    -0.504     0.200
     0.894    -0.512     0.200
     1.092     0.438     0.200
     1.218     0.098     0.200
     1.259     0.002     0.200
     1.310     0.149     0.200
     1.329    -0.621     0.200
     1.393    -0.595     0.200
     1.608    -1.590     0.200
     2.591    -2.843     0.200
     2.683    -1.845     0.200
     2.885    -2.274     0.200
     3.026    -2.812     0.200
     3.290    -3.612     0.200
     3.321    -3.142     0.200
     3.544    -3.431     0.200
     0.391     0.401     0.200
     0.428     0.041     0.200
     0.496     0.312     0.200
     0.767    -0.561     0.200
     1.015     0.039     0.200
     1.204    -0.167     0.200
     1.222     0.009     0.200
     1.261     0.059     0.200
     1.270    -0.039     0.200
     1.421     0.334     0.200
     1.699    -1.035     0.200
     1.811    -1.447     0.200
     1.912    -1.963     0.200
     2.170    -1.095     0.200
     2.718    -1.806     0.200
     2.952    -1.753     0.200
     3.094    -2.170     0.200
     3.325    -2.890     0.200
     3.332    -3.208     0.200
     0.302     0.019     0.200
     0.302     0.125     0.200
     0.471     0.362     0.200
     0.471     0.536     0.200
     0.513     0.763     0.200
     0.734     0.605     0.200
     0.827     0.259     0.200
     0.885    -0.453     0.200
     0.906    -0.493     0.200
     1.011     0.245     0.200
     1.051     0.195     0.200
     1.094     0.401     0.200
     1.186    -1.259     0.200
     1.211    -0.046     0.200
     1.211     0.244     0.200
     1.257    -0.011     0.200
     1.318    -0.294     0.200
     1.335    -0.880     0.200
     1.381     0.436     0.200
     1.400    -0.997     0.200
     1.402    -1.036     0.200
     1.415    -0.377     0.200
     1.600    -2.042     0.200
     1.600    -1.644     0.200
     1.771    -2.762     0.200
     1.892    -1.263     0.200
     2.103    -1.615     0.200
     0.309     0.212     0.200
     0.466     0.119     0.200
     0.511     0.625     0.200
     0.899    -0.140     0.200
     0.890    -0.896     0.200
     1.089     0.385     0.200
     1.213     0.083     0.200
     1.254    -0.244     0.200
     1.314    -0.484     0.200
     1.328    -0.945     0.200
     1.395    -1.036     0.200
     1.605    -1.610     0.200
     1.809    -1.597     0.200
     1.884    -1.233     0.200
     2.290    -3.290     0.200
     0.306     0.491     0.200
     0.306     0.317     0.200
     0.466     1.076     0.200
     0.466     0.824     0.200
     0.514     0.851     0.200
     0.729     2.077     0.200
     0.729     1.046     0.200
     0.827     0.675     0.200
     0.827     0.425     0.200
     0.901    -0.235     0.200
     0.901    -0.044     0.200
     0.886     1.720     0.200
     0.890    -0.631     0.200
     0.890    -0.818     0.200
     1.005    -0.372     0.200
     1.045     0.287     0.200
     1.092     0.546     0.200
     1.180    -0.889     0.200
     1.215     0.013     0.200
     1.215     0.271     0.200
     1.258    -0.031     0.200
     1.258     0.324     0.200
     1.330    -1.050     0.200
     1.330    -0.460     0.200
     1.313     0.064     0.200
     1.379    -0.476     0.200
     1.394    -1.788     0.200
     1.396    -0.519     0.200
     1.605    -1.509     0.200
     1.605    -1.966     0.200
     1.754    -0.672     0.200
     1.886    -1.584     0.200
     1.958    -1.436     0.200
     1.957    -2.272     0.200
     1.972    -1.238     0.200
     2.108    -1.842     0.200
     2.589    -2.708     0.200
     2.685    -1.787     0.200
     2.703    -2.525     0.200
     3.023    -2.972     0.200
     3.202    -2.279     0.200
     3.234    -6.182     0.200
     3.287    -2.855     0.200
     3.287    -3.361     0.200
     3.317    -2.361     0.200
     3.319    -2.626     0.200
     3.319    -2.895     0.200
     3.694    -2.103     0.200
     4.295    -3.911     0.200
     4.536    -7.501     0.200
     4.722    -2.529     0.200
     0.299    -0.352     0.200
     0.334     0.203     0.200
     0.535    -0.551     0.200
     0.535    -0.762     0.200
     0.520     1.908     0.200
     0.602    -0.383     0.200
     0.701     1.963     0.200
     0.779     1.366     0.200
     1.010    -0.179     0.200
     1.309     0.506     0.200
     1.217    -0.473     0.200
     1.253    -0.271     0.200
     1.418    -0.909     0.200
     1.891    -0.763     0.200
     2.264    -1.530     0.200
     2.702    -2.945     0.200
     0.403     0.422     0.200
     0.403     0.424     0.200
     0.428    -0.570     0.200
     0.485     0.455     0.200
     0.666     1.713     0.200
     0.772    -0.297     0.200
     0.968     0.420     0.200
     0.982    -0.535     0.200
     1.008     0.294     0.200
     1.008     0.588     0.200
     1.062    -0.723     0.200
     1.204    -0.213     0.200
     1.252    -0.606     0.200
     1.212     0.043     0.200
     1.249    -0.420     0.200
     1.249    -0.017     0.200
     1.276    -0.895     0.200
     1.278    -0.771     0.200
     1.309    -2.606     0.200
     1.297     0.073     0.200
     1.417    -0.104     0.200
     1.661    -2.683     0.200
     1.688    -1.928     0.200
     1.757    -0.542     0.200
     1.794    -1.675     0.200
     1.794    -1.505     0.200
     1.800    -1.307     0.200
     1.829    -0.093     0.200
     1.846    -1.455     0.200
     1.923    -1.027     0.200
     2.179    -2.588     0.200
     2.940    -2.871     0.200
     2.940    -1.803     0.200
     3.319    -3.327     0.200
     4.727    -2.754     0.200
     0.585     0.337     0.200
     0.850     0.050     0.200
     0.893     1.564     0.200
     0.986    -0.116     0.200
     1.310    -1.137     0.200
     1.310    -0.514     0.200
     1.322    -0.119     0.200
     1.322     0.707     0.200
     1.423     0.921     0.200
     1.850    -0.877     0.200
     1.893    -2.035     0.200
     1.893    -1.830     0.200
     1.913    -2.526     0.200
     1.913    -1.606     0.200
     3.383    -2.152     0.200
     3.403    -2.001     0.200
     0.264     0.227     0.200
     0.335    -0.083     0.200
     0.428     0.743     0.200
     0.428     0.441     0.200
     0.589     0.604     0.200
     0.589     0.283     0.200
     0.589    -0.227     0.200
     0.743     0.693     0.200
     0.774    -0.902     0.200
     0.774    -0.322     0.200
     0.853     1.898     0.200
     0.967    -0.468     0.200
     0.967    -0.586     0.200
     1.045     0.746     0.200
     1.045     0.106     0.200
     1.091     0.089     0.200
     1.091    -0.091     0.200
     1.091     0.628     0.200
     1.118    -0.176     0.200
     1.118    -0.576     0.200
     1.172    -0.033     0.200
     1.172     0.277     0.200
     1.172     0.431     0.200
     1.166    -0.743     0.200
     1.271    -0.645     0.200
     1.271    -0.765     0.200
     1.320    -0.337     0.200
     1.358    -0.550     0.200
     1.374     0.490     0.200
     1.406    -0.350     0.200
     1.437    -1.043     0.200
     1.437     0.049     0.200
     1.486    -0.990     0.200
     1.520    -0.488     0.200
     1.669    -2.161     0.200
     1.795    -1.072     0.200
     1.795    -0.859     0.200
     1.924    -2.038     0.200
     1.984    -2.184     0.200
     2.098    -0.520     0.200
     2.845    -1.876     0.200
     3.163    -2.182     0.200
     3.205    -1.905     0.200
     3.205    -2.551     0.200
     3.947    -2.125     0.200
     4.170    -2.700     0.200
     4.170    -3.908     0.200
     4.307    -3.833     0.200
     0.277     0.399     0.200
     0.334     0.786     0.200
     0.538    -0.139     0.200
     0.608    -0.214     0.200
     0.576    -0.297     0.200
     0.806     0.606     0.200
     0.851     1.224     0.200
     0.955    -0.134     0.200
     1.060    -0.369     0.200
     1.116    -1.271     0.200
     1.152     0.411     0.200
     1.133    -0.921     0.200
     1.324     0.598     0.200
     1.215     0.179     0.200
     1.786    -1.849     0.200
     1.840    -1.310     0.200
     1.828    -1.650     0.200
     0.339     0.329     0.200
     0.448     0.760     0.200
     0.448     1.154     0.200
     0.526     0.074     0.200
     0.526    -0.031     0.200
     0.763     0.391     0.200
     0.838    -0.222     0.200
     0.838     0.450     0.200
     0.790     1.887     0.200
     0.913    -0.904     0.200
     1.043     0.439     0.200
     1.043     0.576     0.200
     1.054     0.632     0.200
     1.145    -0.849     0.200
     1.145     0.804     0.200
     1.102     0.772     0.200
     1.193    -0.000     0.200
     1.375    -0.236     0.200
     1.428    -0.456     0.200
     1.456    -0.175     0.200
     1.548    -1.578     0.200
     2.328    -2.710     0.200
     4.230    -3.815     0.200
     0.447    -0.017     0.200
     0.447     0.054     0.200
     0.514    -0.279     0.200
     0.514    -0.107     0.200
     0.489     0.289     0.200
     0.489     0.179     0.200
     0.707     0.808     0.200
     0.717     0.572     0.200
     0.851    -1.293     0.200
     0.820    -0.281     0.200
     0.925     0.240     0.200
     0.925     0.420     0.200
     1.063    -1.413     0.200
     1.066    -1.144     0.200
     1.176     0.619     0.200
     1.108    -0.366     0.200
     1.108    -0.530     0.200
     1.211     1.664     0.200
     1.174    -0.444     0.200
     1.492    -2.943     0.200
     1.479    -0.452     0.200
     1.555    -0.150     0.200
     1.650    -1.762     0.200
     1.625     0.130     0.200
     1.792    -2.431     0.200
     1.981    -2.637     0.200
     2.147    -0.411     0.200
     2.147    -0.052     0.200
     2.146    -0.470     0.200
     2.155     0.074     0.200
     2.155     0.246     0.200
     2.289    -0.449     0.200
     2.327    -2.174     0.200
     2.327    -2.479     0.200
     3.355    -3.255     0.200
     0.237     0.175     0.200
     0.422     0.688     0.200
     0.550     0.740     0.200
     0.550     0.845     0.200
     0.550     0.697     0.200
     0.736     0.576     0.200
     0.917    -1.209     0.200
     1.022     0.846     0.200
     1.022     0.159     0.200
     1.073     0.272     0.200
     1.117     0.129     0.200
     1.117    -0.250     0.200
     1.167    -0.422     0.200
     1.167     0.390     0.200
     1.167     0.187     0.200
     1.314     0.500     0.200
     1.314     0.214     0.200
     1.302     0.562     0.200
     1.302     0.015     0.200
     1.400    -0.155     0.200
     1.400    -0.046     0.200
     1.439    -0.200     0.200
     1.473    -0.892     0.200
     1.473    -1.642     0.200
     1.527    -0.770     0.200
     1.619    -1.767     0.200
     1.825    -1.311     0.200
     1.876    -1.411     0.200
     1.882    -0.863     0.200
     1.882    -2.370     0.200
     1.962    -0.739     0.200
     2.008    -0.458     0.200
     2.232    -0.880     0.200
     2.232    -1.446     0.200
     2.234    -0.904     0.200
     2.342    -2.849     0.200
     2.342    -2.412     0.200
     2.640    -3.334     0.200
     2.792    -1.794     0.200
     3.190    -3.446     0.200
     3.219    -1.940     0.200
     3.219    -2.318     0.200
     3.600    -4.423     0.200
     3.676    -3.460     0.200
     4.205    -3.557     0.200
     4.205    -3.807     0.200
     0.260     0.389     0.200
     0.319     0.058     0.200
     0.548    -1.095     0.200
     0.634    -0.286     0.200
     0.634    -0.176     0.200
     0.750     1.400     0.200
     0.810    -0.921     0.200
     0.810    -0.461     0.200
     0.891     0.918     0.200
     1.053     1.180     0.200
     1.024    -0.636     0.200
     1.060    -1.189     0.200
     1.006     0.606     0.200
     1.035     0.168     0.200
     1.189     0.530     0.200
     1.291    -0.721     0.200
     1.315    -0.014     0.200
     1.412    -2.225     0.200
     1.461    -2.197     0.200
     1.593    -3.086     0.200
     1.614    -3.569     0.200
     2.296    -1.483     0.200
     2.689    -2.877     0.200
     2.980    -2.036     0.200
     3.283    -2.025     0.200
     0.360     0.680     0.200
     0.360     0.587     0.200
     0.505     0.185     0.200
     0.650    -0.450     0.200
     0.650    -0.263     0.200
     0.783     1.088     0.200
     0.892     1.105     0.200
     0.953     0.529     0.200
     1.091    -0.438     0.200
     1.091    -0.258     0.200
     1.160    -2.028     0.200
     1.163    -0.688     0.200
     1.189     0.426     0.200
     1.189     0.699     0.200
     1.198    -0.198     0.200
     1.257     0.277     0.200
     1.344    -1.342     0.200
     1.307    -0.557     0.200
     1.752    -0.872     0.200
     1.752    -1.012     0.200
     1.831    -1.958     0.200
     1.854    -3.871     0.200
     1.814    -0.960     0.200
     1.814    -1.437     0.200
     2.068    -2.086     0.200
     2.068    -0.883     0.200
     2.758    -2.846     0.200
     2.732    -1.687     0.200
     2.659    -1.848     0.200
     2.833    -2.782     0.200
     3.013    -2.320     0.200
     0.366     0.605     0.200
     0.366     0.425     0.200
     0.500     0.249     0.200
     0.653    -0.903     0.200
     0.778     0.715     0.200
     0.898     1.363     0.200
     0.950     0.459     0.200
     0.950     0.647     0.200
     0.950     0.360     0.200
     1.092    -0.393     0.200
     1.080    -0.406     0.200
     1.080    -0.570     0.200
     1.193    -0.169     0.200
     1.201     0.228     0.200
     1.195     0.738     0.200
     1.195     0.496     0.200
     1.212    -1.319     0.200
     1.301    -0.080     0.200
     1.348    -0.766     0.200
     1.714    -1.866     0.200
     1.748    -1.054     0.200
     1.809    -1.458     0.200
     1.836    -1.811     0.200
     2.073    -1.627     0.200
     2.729    -1.767     0.200
     2.762    -2.302     0.200
     2.997    -1.721     0.200
     3.364    -2.623     0.200
     0.318     1.602     0.200
     0.462     1.933     0.200
     0.533     0.971     0.200
     0.533     0.729     0.200
     0.777     1.467     0.200
     0.797     1.364     0.200
     0.797     1.833     0.200
     0.934     0.257     0.200
     0.934    -0.532     0.200
     1.146    -0.815     0.200
     1.146    -0.089     0.200
     1.208     0.095     0.200
     1.228    -0.587     0.200
     1.470    -2.434     0.200
     0.249     0.224     0.200
     0.586    -0.006     0.200
     0.591     0.829     0.200
     0.679    -0.305     0.200
     0.828     0.150     0.200
     0.887     0.636     0.200
     0.927     0.342     0.200
     0.933     0.774     0.200
     1.450    -1.185     0.200
     1.517     0.036     0.200
     1.650    -1.242     0.200
     0.384    -0.025     0.200
     0.485     0.704     0.200
     0.714    -0.578     0.200
     0.776    -0.268     0.200
     0.935    -0.809     0.200
     0.975     0.597     0.200
     1.008     0.414     0.200
     1.148    -0.136     0.200
     1.198     0.084     0.200
     1.247     0.283     0.200
     1.274     0.310     0.200
     1.664    -1.437     0.200
     1.699    -1.420     0.200
     1.795    -1.793     0.200
     1.799    -1.229     0.200
     0.375     0.795     0.200
     0.434     0.788     0.200
     0.503     0.522     0.200
     0.768     0.889     0.200
     0.747     0.849     0.200
     0.871    -0.608     0.200
     1.023    -0.087     0.200
     1.013     0.359     0.200
     1.075     0.714     0.200
     1.171    -0.035     0.200
     1.157     0.041     0.200
     1.177     0.345     0.200
     1.299     0.062     0.200
     1.354    -0.050     0.200
     1.421    -0.771     0.200
     1.737    -1.296     0.200
     1.774    -2.588     0.200
     1.782    -1.154     0.200
     1.841    -1.974     0.200
     2.837    -2.799     0.200
     4.249    -3.712     0.200
     0.413     1.018     0.200
     0.413     0.548     0.200
     0.572     0.411     0.200
     0.689    -0.407     0.200
     0.814    -1.021     0.200
     0.838     0.860     0.200
     0.841     0.645     0.200
     1.002     1.324     0.200
     1.207    -0.302     0.200
     1.488    -2.470     0.200
     3.155    -3.301     0.200
     3.190    -2.023     0.200
     0.468     1.695     0.200
     0.547     1.144     0.200
     0.760     1.752     0.200
     1.051     0.123     0.200
     0.923     1.221     0.200
     0.923     1.092     0.200
     0.982     0.848     0.200
     0.982     1.125     0.200
     0.994     0.784     0.200
     1.068     0.080     0.200
     1.068     0.682     0.200
     1.200     0.297     0.200
     1.288     0.559     0.200
     1.288     0.149     0.200
     1.319     0.049     0.200
     1.319    -1.041     0.200
     1.465    -1.068     0.200
     1.536    -1.557     0.200
     1.755    -0.529     0.200
     2.793    -2.467     0.200
     5.100    -3.425     0.200
     0.422     1.355     0.200
     0.687     2.369     0.200
     0.929     0.590     0.200
     0.929     1.012     0.200
     0.988     0.742     0.200
     0.994     0.590     0.200
     1.074     0.350     0.200
     1.074     0.131     0.200
     1.273    -0.343     0.200
     1.326    -0.300     0.200
     1.326    -1.312     0.200
     1.290     0.353     0.200
     1.290     0.564     0.200
     1.290    -0.397     0.200
     1.472    -1.061     0.200
     1.541    -0.913     0.200
     1.543    -1.316     0.200
     1.678    -1.759     0.200
     1.669    -1.681     0.200
     1.760    -0.539     0.200
     2.194    -1.010     0.200
     5.093    -4.196     0.200
     0.509    -0.050     0.200
     0.656     0.344     0.200
     0.763     0.910     0.200
     0.797    -1.789     0.200
     0.797    -0.869     0.200
     0.971     0.019     0.200
     0.999    -0.329     0.200
     1.058    -0.931     0.200
     1.148     0.779     0.200
     1.151    -0.264     0.200
     1.194    -0.965     0.200
     1.306     0.526     0.200
     1.261    -0.292     0.200
     1.261    -0.603     0.200
     1.292     0.739     0.200
     1.280     0.441     0.200
     1.280     0.720     0.200
     1.306     0.647     0.200
     1.408    -1.551     0.200
     1.525    -0.165     0.200
     1.584    -2.923     0.200
     2.192    -0.523     0.200
     3.059    -2.438     0.200
     3.796    -3.138     0.200
     0.289     1.654     0.200
     0.788     1.967     0.200
     0.807     1.253     0.200
     0.807     1.144     0.200
     1.066     0.171     0.200
     1.066     0.308     0.200
     1.093     0.891     0.200
     1.106    -0.082     0.200
     1.106     0.149     0.200
     1.237    -0.613     0.200
     1.237    -0.331     0.200
     1.237     0.362     0.200
     1.472    -2.252     0.200
     1.673    -3.518     0.200
     0.804    -0.432     0.200
     0.920     1.339     0.200
     1.018    -1.148     0.200
     1.349    -2.145     0.200
     1.486    -0.633     0.200
     1.680    -2.154     0.200
     1.707    -2.584     0.200
     1.814    -1.901     0.200
     2.085    -2.105     0.200
     0.685    -0.326     0.200
     0.776    -1.293     0.200
     0.776    -1.063     0.200
     0.858     0.240     0.200
     0.952     0.873     0.200
     0.970    -0.108     0.200
     0.970     0.172     0.200
     1.123     0.834     0.200
     1.281     0.451     0.200
     1.250    -0.171     0.200
     1.250     0.049     0.200
     1.261     0.144     0.200
     1.261     0.644     0.200
     1.354     0.914     0.200
     1.393    -2.526     0.200
     1.439    -2.017     0.200
     1.439    -0.480     0.200
     1.496    -0.115     0.200
     1.554    -1.463     0.200
     1.566    -0.819     0.200
     1.994    -2.095     0.200
     0.561    -0.656     0.200
     0.812     0.202     0.200
     0.910    -1.406     0.200
     0.967     0.335     0.200
     1.076    -0.169     0.200
     1.167    -1.120     0.200
     1.199     0.116     0.200
     1.223    -0.140     0.200
     1.273    -0.150     0.200
     1.518    -2.133     0.200
     1.567    -1.707     0.200
     1.697    -1.960     0.200
     1.821    -1.993     0.200
     5.237    -4.196     0.200
     0.553    -0.975     0.200
     0.805     0.951     0.200
     0.921    -1.256     0.200
     0.965     0.498     0.200
     1.082    -0.414     0.200
     1.179    -1.576     0.200
     1.201    -0.270     0.200
     1.217    -0.280     0.200
     1.530    -2.169     0.200
     1.578    -2.163     0.200
     1.625    -0.986     0.200
     5.226    -5.499     0.200
     0.299     1.026     0.200
     0.299     1.276     0.200
     0.878     0.787     0.200
     1.148    -1.281     0.200
     1.148    -1.179     0.200
     1.128     0.362     0.200
     1.333    -0.046     0.200
     1.333     0.185     0.200
     1.307     0.248     0.200
     1.368    -0.788     0.200
     1.514    -0.957     0.200
     1.540    -1.942     0.200
     1.722    -2.758     0.200
     1.880    -0.521     0.200
     2.252    -3.467     0.200
     0.505     1.430     0.200
     0.909    -0.576     0.200
     0.909    -0.275     0.200
     0.954     1.554     0.200
     1.124    -0.047     0.200
     1.124    -1.137     0.200
     1.175     1.042     0.200
     1.314    -1.506     0.200
     1.299    -1.036     0.200
     1.325    -0.841     0.200
     1.342    -0.807     0.200
     1.325    -0.009     0.200
     1.369    -0.254     0.200
     1.477    -1.266     0.200
     1.421     1.313     0.200
     1.421    -0.265     0.200
     1.693     0.202     0.200
     0.403    -0.256     0.200
     0.405    -0.435     0.200
     0.965     0.690     0.200
     1.048    -1.235     0.200
     1.048    -1.356     0.200
     1.184     0.265     0.200
     1.252     0.237     0.200
     1.277     1.168     0.200
     1.277     0.750     0.200
     1.445    -0.555     0.200
     1.703    -1.300     0.200
     1.702    -1.057     0.200
     1.694    -0.684     0.200
     1.694    -1.087     0.200
     1.834    -1.546     0.200
     2.168    -1.195     0.200
     3.966    -3.737     0.200
     0.407    -0.113     0.200
     0.407     0.316     0.200
     0.491     1.024     0.200
     0.494     0.514     0.200
     0.758     2.094     0.200
     0.986     0.573     0.200
     0.986     0.096     0.200
     1.061    -0.093     0.200
     1.144    -0.114     0.200
     1.144    -0.590     0.200
     1.159     0.461     0.200
     1.159     0.062     0.200
     1.243     0.487     0.200
     1.243    -0.185     0.200
     1.274     0.265     0.200
     1.311     0.185     0.200
     1.344     0.439     0.200
     1.344     0.072     0.200
     1.399    -1.085     0.200
     1.542    -0.979     0.200
     1.751    -2.838     0.200
     1.751    -1.432     0.200
     1.807    -1.188     0.200
     1.807    -0.868     0.200
     1.801    -3.128     0.200
     1.894    -3.726     0.200
     1.932    -1.671     0.200
     0.408     0.275     0.200
     0.408     0.408     0.200
     0.500     0.743     0.200
     0.503     0.194     0.200
     0.766     0.860     0.200
     0.766     1.805     0.200
     0.982     0.843     0.200
     0.982     0.328     0.200
     1.070     0.154     0.200
     1.070     0.045     0.200
     1.151    -0.674     0.200
     1.151    -0.182     0.200
     1.153     0.115     0.200
     1.245     0.389     0.200
     1.245     0.022     0.200
     1.269     0.756     0.200
     1.269     0.397     0.200
     1.310     0.524     0.200
     1.352    -0.794     0.200
     1.352    -0.091     0.200
     1.407    -0.391     0.200
     1.549    -0.957     0.200
     1.587    -1.349     0.200
     1.759    -1.266     0.200
     1.759    -3.024     0.200
     1.808    -2.915     0.200
     1.809    -0.880     0.200
     1.939    -1.145     0.200
     2.706    -2.175     0.200
     0.497     0.340     0.200
     0.978     0.491     0.200
     1.631    -2.087     0.200
     0.504     0.226     0.200
     0.739    -0.743     0.200
     0.871    -1.526     0.200
     1.261     0.778     0.200
     1.521    -2.294     0.200
     1.555    -2.569     0.200
     1.671    -2.802     0.200
     1.825    -1.432     0.200
     0.502    -0.619     0.200
     0.955     0.372     0.200
     1.270     1.263     0.200
     1.321     1.039     0.200
     1.573    -3.197     0.200
     1.805    -2.128     0.200
     1.894    -1.904     0.200
     0.669    -1.413     0.200
     0.824    -1.409     0.200
     0.903    -0.305     0.200
     1.148     1.419     0.200
     1.146     0.448     0.200
     1.329    -2.501     0.200
     1.357    -2.117     0.200
     1.468    -1.997     0.200
     1.728    -0.565     0.200
     1.784    -1.051     0.200
     0.531    -0.059     0.200
     0.718    -0.373     0.200
     0.923    -1.177     0.200
     0.992     0.352     0.200
     1.002     0.823     0.200
     1.016    -0.624     0.200
     1.307     1.834     0.200
     1.358     0.840     0.200
     1.492    -0.281     0.200
     1.573    -2.189     0.200
     1.589    -0.315     0.200
     1.608    -1.299     0.200
     1.723    -2.188     0.200
     1.754    -1.595     0.200
     1.772    -1.737     0.200
     1.931    -0.760     0.200
     1.972    -1.433     0.200
     2.161     0.610     0.200
     0.473     0.630     0.200
     0.642    -1.272     0.200
     0.887    -0.109     0.200
     0.960    -1.702     0.200
     1.383     1.072     0.200
     1.442    -1.673     0.200
     2.550    -2.889     0.200
     3.129    -3.077     0.200
     0.480     0.003     0.200
     1.400     0.626     0.200
     1.504    -2.588     0.200
     2.037    -1.794     0.200
     0.474    -0.690     0.200
     1.103     1.896     0.200
     1.491    -1.685     0.200
     1.777    -2.198     0.200
     2.048    -2.103     0.200
     0.515    -0.742     0.200
     0.531    -0.499     0.200
     0.861    -1.337     0.200
     1.042     0.943     0.200
     1.191    -1.328     0.200
     1.331    -1.600     0.200
     1.389    -1.412     0.200
     1.517    -2.795     0.200
     1.660    -2.382     0.200
     1.830    -1.601     0.200
     0.470     1.362     0.200
     0.650    -0.808     0.200
     0.778    -0.742     0.200
     0.880    -0.725     0.200
     0.967    -1.479     0.200
     1.102     1.271     0.200
     1.303    -2.220     0.200
     1.335    -2.810     0.200
     1.450    -1.851     0.200
     1.492    -2.537     0.200
     1.780    -2.370     0.200
     0.507     0.132     0.200
     0.803    -0.707     0.200
     1.227     1.119     0.200
     1.644    -1.849     0.200
     0.509     0.051     0.200
     0.793    -0.746     0.200
     0.809    -0.148     0.200
     0.901     0.621     0.200
     0.939     0.879     0.200
     1.075    -0.241     0.200
     1.222     2.078     0.200
     1.448    -2.161     0.200
     1.479    -1.946     0.200
     1.593    -1.583     0.200
     1.636    -2.022     0.200
     1.763    -3.613     0.200
     1.922    -2.241     0.200
     2.048     0.069     0.200
     0.534    -1.062     0.200
     0.685    -1.022     0.200
     0.501    -0.726     0.200
     0.736     0.508     0.200
     0.872    -1.829     0.200
     1.053     0.146     0.200
     1.261     1.196     0.200
     1.521    -2.021     0.200
     1.556    -1.815     0.200
     1.672    -1.460     0.200
     2.002    -1.570     0.200
     2.107    -1.820     0.200
     0.489     0.617     0.200
     0.585    -0.901     0.200
     0.934     1.012     0.200
     1.241    -1.890     0.200
     1.230     0.828     0.200
     2.110    -2.109     0.200
     2.351    -3.121     0.200
     2.557    -3.050     0.200
     2.499    -2.872     0.200
     3.072    -1.898     0.200
     0.483     0.241     0.200
     0.510     0.352     0.200
     0.756    -0.523     0.200
     0.859    -0.808     0.200
     0.943     1.733     0.200
     1.048     0.498     0.200
     1.260     1.157     0.200
     1.511    -1.342     0.200
     1.544    -1.780     0.200
     1.659    -1.850     0.200
     1.921    -0.741     0.200
     0.480     0.275     0.200
     0.585    -0.829     0.200
     0.736    -1.405     0.200
     0.906    -1.578     0.200
     0.928     0.043     0.200
     0.937     1.739     0.200
     1.060     1.059     0.200
     1.240    -1.292     0.200
     1.271    -1.623     0.200
     1.236    -0.167     0.200
     2.110    -1.456     0.200
     0.564     0.379     0.200
     0.597    -0.937     0.200
     0.851     1.236     0.200
     0.938    -1.927     0.200
     1.129     2.357     0.200
     0.527    -0.084     0.200
     0.493    -1.045     0.200
     0.653    -0.611     0.200
     0.796    -0.818     0.200
     1.120     0.372     0.200
     1.340    -2.173     0.200
     1.405     0.947     0.200
     1.453    -1.426     0.200
     1.782    -2.376     0.200
     1.932    -1.674     0.200
     0.510    -0.155     0.200
     0.740    -0.504     0.200
     0.877    -0.919     0.200
     0.952     0.454     0.200
     0.989     1.177     0.200
     1.045    -0.140     0.200
     1.269     1.441     0.200
     1.315     0.447     0.200
     1.448    -0.153     0.200
     1.527    -2.332     0.200
     1.561    -2.531     0.200
     1.677    -2.261     0.200
     1.818    -1.584     0.200
     1.889    -0.858     0.200
     1.932    -1.015     0.200
     0.489    -0.264     0.200
     0.626    -1.062     0.200
     1.098     0.734     0.200
     0.512    -0.794     0.200
     0.618    -0.507     0.200
     0.488    -0.114     0.200
     0.609    -1.092     0.200
     0.760     0.682     0.200
     0.932    -0.760     0.200
     0.926     1.798     0.200
     1.085     1.217     0.200
     1.370     0.645     0.200
     1.409    -1.588     0.200
     1.459    -0.874     0.200
     1.586    -3.752     0.200
     1.739    -2.929     0.200
     1.866    -2.690     0.200
     1.927    -0.413     0.200
     0.568     0.250     0.200
     0.699    -0.254     0.200
     0.878    -0.235     0.200
     0.927    -0.477     0.200
     1.037    -1.789     0.200
     0.849     1.765     0.200
     1.202     1.371     0.200
     1.364    -1.394     0.200
     1.388    -1.392     0.200
     1.565    -1.830     0.200
     1.693    -3.806     0.200
     1.776    -1.210     0.200
     1.835    -1.201     0.200
     1.822    -1.951     0.200
     1.958    -2.782     0.200
     0.505     0.359     0.200
     0.873    -0.993     0.200
     0.990     1.851     0.200
     0.948     0.524     0.200
     1.049     0.198     0.200
     1.183    -1.496     0.200
     1.264     1.632     0.200
     1.310     0.882     0.200
     1.557    -2.378     0.200
     1.547     0.471     0.200
     1.673    -2.605     0.200
     1.884    -1.711     0.200
     1.822    -1.606     0.200
     2.004    -2.603     0.200
     2.128    -0.240     0.200
     2.274    -1.803     0.200
     0.632    -1.174     0.200
     0.794     0.552     0.200
     0.901     0.956     0.200
     0.961    -1.066     0.200
     1.118     0.676     0.200
     1.432    -1.745     0.200
     1.488    -1.903     0.200
     1.760    -2.275     0.200
     1.891    -2.542     0.200
     2.066    -0.200     0.200
     0.551     1.003     0.200
     0.643    -1.416     0.200
     1.153     1.451     0.200
     1.332    -1.850     0.200
     1.508    -3.548     0.200
     1.767    -1.252     0.200
     1.902    -2.693     0.200
     1.950    -1.614     0.200
     0.507     0.061     0.200
     0.774    -0.721     0.200
     0.888     0.683     0.200
     0.933     1.517     0.200
     1.094    -1.916     0.200
     1.086    -0.425     0.200
     1.903    -1.844     0.200
     0.507     0.136     0.200
     0.782    -0.721     0.200
     0.816     0.545     0.200
     0.936     1.086     0.200
     1.101    -0.988     0.200
     1.082     0.207     0.200
     1.915    -1.123     0.200
     2.039     1.054     0.200
     2.129    -0.015     0.200
     2.750    -2.062     0.200
     2.890    -4.158     0.200
     3.055    -5.228     0.200
     3.070    -2.154     0.200
     0.461    -0.201     0.200
     0.640    -1.277     0.200
     0.880    -0.817     0.200
     1.088     0.903     0.200
     1.292    -1.079     0.200
     1.325    -0.893     0.200
     1.088     1.754     0.200
     0.438    -0.077     0.200
     0.629    -1.717     0.200
     1.062     1.303     0.200
     1.461    -0.562     0.200
     1.881    -1.581     0.200
     1.972    -1.168     0.200
     2.067    -1.442     0.200
     2.489    -1.894     0.200
     0.462    -0.028     0.200
     0.859     0.371     0.200
     0.494     0.918     0.200
     0.852    -0.914     0.200
     0.928     0.648     0.200
     1.245     1.465     0.200
     1.289     1.353     0.200
     1.683    -3.081     0.200
     1.982    -2.706     0.200
     0.479     0.096     0.200
     0.588    -0.604     0.200
     0.909    -1.424     0.200
     0.937     1.162     0.200
     1.234    -0.240     0.200
     2.107    -1.267     0.200
     2.316    -3.120     0.200
     2.348    -1.391     0.200
     0.511    -0.457     0.200
     0.643    -1.117     0.200
     0.802    -1.269     0.200
     0.901     0.986     0.200
     1.126     1.147     0.200
     1.169    -0.559     0.200
     1.331    -1.455     0.200
     1.442    -1.238     0.200
     2.551    -1.938     0.200
     0.495     0.189     0.200
     0.777    -0.947     0.200
     0.817    -1.168     0.200
     1.131    -0.747     0.200
     1.076    -0.253     0.200
     1.469    -1.550     0.200
     1.617    -0.880     0.200
     0.526     0.315     0.200
     0.722    -0.641     0.200
     0.914    -0.915     0.200
     0.983     0.391     0.200
     1.022     0.310     0.200
     1.299     1.760     0.200
     1.349     0.638     0.200
     1.483     0.268     0.200
     1.564    -2.302     0.200
     1.714    -1.828     0.200
     1.745    -1.663     0.200
     1.782    -1.702     0.200
     2.148    -1.707     0.200
     2.218    -1.899     0.200
     1.721    -2.499     0.200
     2.108    -1.487     0.200
     0.557    -0.676     0.200
     0.597    -1.415     0.200
     0.858     1.322     0.200
     1.262    -1.520     0.200
     0.533     0.428     0.200
     0.484    -0.132     0.200
     0.628    -0.449     0.200
     0.772    -0.187     0.200
     0.904     0.708     0.200
     0.928     1.163     0.200
     1.096     1.413     0.200
     1.284    -1.724     0.200
     1.198    -0.357     0.200
     1.315    -1.031     0.200
     1.428    -1.387     0.200
     1.604    -2.626     0.200
     1.758    -1.409     0.200
     1.942     0.805     0.200
     0.490     0.020     0.200
     0.637    -0.444     0.200
     0.783     1.954     0.200
     0.660    -1.371     0.200
     1.110     0.948     0.200
     0.577    -0.256     0.200
     0.716    -1.124     0.200
     0.895     0.728     0.200
     1.381    -1.286     0.200
     1.405    -1.295     0.200
     0.616    -0.921     0.200
     0.608    -0.366     0.200
     1.172     0.491     0.200
     0.429     1.118     0.200
     0.501     0.535     0.200
     0.745    -0.388     0.200
     0.862    -0.755     0.200
     0.938     1.882     0.200
     0.907     2.761     0.200
     1.172    -1.043     0.200
     1.511    -1.948     0.200
     1.662    -0.519     0.200
     1.834    -1.289     0.200
     1.992    -1.545     0.200
     2.119    -1.402     0.200
     2.357    -3.044     0.200
     2.770    -2.290     0.200
     2.967    -1.866     0.200
     2.986    -2.589     0.200
     3.321    -6.311     0.200
     3.488    -5.684     0.200
     3.891    -5.334     0.200
     3.998    -2.987     0.200
     2.283    -0.830     0.200
     2.986    -4.242     0.200
     2.507    -3.056     0.200
     3.244    -5.001     0.200
     0.492    -0.012     0.200
     0.636    -0.886     0.200
     1.293    -1.625     0.200
     1.323    -1.927     0.200
     0.441     0.641     0.200
     0.578    -0.669     0.200
     2.534    -2.315     0.200
     3.266    -5.649     0.200
EOF
gmt end
