#!/bin/bash
gmt begin hubbard6.23_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional hubbard6.23'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.917
    15.000    42.638
    15.500    42.357
    16.000    42.073
    16.500    41.784
    17.000    41.488
    17.500    41.183
    18.000    40.869
    18.500    40.542
    19.000    40.201
    19.500    39.843
    20.000    39.466
    20.500    39.068
    21.000    38.647
    21.500    38.199
    22.000    37.724
    22.500    37.219
    23.000    36.683
    23.500    36.113
    24.000    34.913
    24.500    33.642
    25.000    32.360
    25.500    31.069
    26.000    29.766
    26.500    28.452
    27.000    27.125
    27.500    25.782
    28.000    24.420
    28.500    23.041
    29.000    21.652
    29.500    20.253
    30.000    18.847
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.420 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     9.442
     1.500    10.513
     2.000    11.583
     2.500    12.654
     3.000    13.724
     3.500    14.794
     4.000    15.863
     4.500    16.931
     5.000    17.998
     5.500    19.064
     6.000    20.128
     6.500    21.191
     7.000    22.253
     7.500    23.313
     8.000    24.371
     8.500    25.427
     9.000    26.482
     9.500    27.534
    10.000    28.584
    10.500    29.631
    11.000    30.676
    11.500    31.718
    12.000    32.757
    12.500    33.794
    13.000    34.828
    13.500    35.858
    14.000    36.786
    14.500    37.529
    15.000    38.241
    15.500    38.920
    16.000    39.498
    16.500    40.003
    17.000    40.446
    17.500    40.019
    18.000    40.368
    18.500    40.660
    19.000    40.892
    19.500    41.067
    20.000    41.184
    20.500    41.241
    21.000    41.238
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    31.828 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.235
     1.000     6.307
     1.500     9.414
     2.000    12.530
     2.500    15.649
     3.000    18.769
     3.500    21.889
     4.000    25.008
     4.500    28.127
     5.000    31.244
     5.500    34.360
     6.000    37.475
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    29.244 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    25.236
     1.500    31.543
     2.000    37.849
     2.500    44.155
     3.000    50.461
     3.500    56.768
     4.000    63.071
     4.500    69.373
     5.000    75.674
     5.500    81.972
     6.000    88.268
     6.500    94.562
     7.000   100.853
     7.500   107.141
     8.000   113.426
     8.500   119.707
     9.000   125.986
     9.500   132.260
    10.000   138.531
    10.500   144.797
    11.000   151.058
    11.500   157.315
    12.000   163.567
    12.500   169.814
    13.000   176.055
    13.500   182.291
    14.000   188.521
    14.500   194.744
    15.000   200.962
    15.500   207.172
    16.000   213.377
    16.500   219.573
    17.000   225.763
    17.500   234.936
    18.000   241.208
    18.500   247.468
    19.000   253.715
    19.500   259.948
    20.000   266.168
    20.500   272.373
    21.000   278.563
    21.500   284.739
    22.000   290.898
    22.500   297.042
    23.000   303.169
    23.500   309.280
    24.000   315.373
    24.500   321.449
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    61.071 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.005
     1.000    19.726
     1.500    29.509
     2.000    39.307
     2.500    49.110
     3.000    58.915
     3.500    68.718
     4.000    78.522
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    66.718 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    17.608    48.626     0.150
    21.080   286.068     0.150
    24.176   294.916     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.689    44.395     0.200
    17.547    42.709     0.200
    17.659    41.400     0.200
    18.753    39.133     0.200
    20.692    39.004     0.200
    21.720    36.635     0.200
    22.845    36.514     0.200
    25.418    28.487     0.200
    16.680    44.553     0.200
    17.625    41.022     0.200
    17.541    41.006     0.200
    21.016    39.450     0.200
    21.031    39.675     0.200
    21.446    39.233     0.200
    21.668    37.845     0.200
    21.597    41.665     0.200
    22.214    40.675     0.200
    22.707    39.011     0.200
    23.467    39.851     0.200
    23.628    37.970     0.200
    24.088    36.605     0.200
    25.268    32.332     0.200
    25.363    33.226     0.200
    25.477    32.393     0.200
    25.501    32.612     0.200
    25.546    32.583     0.200
    26.563    30.712     0.200
    14.744    39.891     0.200
    15.688    43.971     0.200
    15.914    43.831     0.200
    17.546    40.794     0.200
    17.614    41.199     0.200
    21.021    39.533     0.200
    21.037    39.050     0.200
    21.253    38.827     0.200
    21.451    39.213     0.200
    21.679    37.657     0.200
    21.597    40.411     0.200
    22.214    39.215     0.200
    22.708    38.247     0.200
    22.771    37.813     0.200
    23.467    36.190     0.200
    24.090    33.923     0.200
    24.811    34.011     0.200
    25.128    32.606     0.200
    25.268    32.870     0.200
    25.365    32.542     0.200
    25.477    32.738     0.200
    25.501    32.656     0.200
    25.549    33.393     0.200
    26.876    29.714     0.200
    29.079    22.198     0.200
    29.215    19.617     0.200
    29.390    20.770     0.200
    17.799    43.151     0.200
    17.405    43.387     0.200
    17.542    43.297     0.200
    21.446    42.329     0.200
    21.819    39.503     0.200
    22.454    38.930     0.200
    25.135    34.775     0.200
    25.511    33.610     0.200
    26.272    30.707     0.200
    17.528    42.791     0.200
    25.495    33.277     0.200
    17.517    43.119     0.200
    21.620    37.916     0.200
    21.657    41.820     0.200
    22.039    39.405     0.200
    22.429    37.675     0.200
    25.109    34.513     0.200
    25.109    34.933     0.200
    25.492    33.022     0.200
    25.915    33.733     0.200
    26.242    31.514     0.200
    21.633    36.398     0.200
    21.633    37.507     0.200
    22.809    36.956     0.200
    25.244    31.316     0.200
    15.236    40.707     0.200
    16.156    40.120     0.200
    16.806    42.042     0.200
    16.912    42.226     0.200
    17.002    43.107     0.200
    17.230    44.423     0.200
    17.507    42.236     0.200
    17.507    41.611     0.200
    17.550    41.762     0.200
    17.642    40.310     0.200
    18.269    42.281     0.200
    20.197    39.253     0.200
    20.996    37.828     0.200
    21.080    40.443     0.200
    21.080    40.849     0.200
    21.080    39.474     0.200
    21.651    37.681     0.200
    21.651    37.493     0.200
    21.651    37.884     0.200
    21.577    38.794     0.200
    21.683    39.360     0.200
    21.782    38.780     0.200
    21.946    38.131     0.200
    21.946    37.584     0.200
    22.030    38.096     0.200
    22.189    39.396     0.200
    22.189    38.990     0.200
    22.418    37.119     0.200
    22.637    37.324     0.200
    22.723    38.163     0.200
    22.723    37.694     0.200
    22.967    37.600     0.200
    23.055    37.748     0.200
    23.196    37.893     0.200
    23.296    36.514     0.200
    23.296    39.085     0.200
    23.296    37.139     0.200
    23.512    35.630     0.200
    23.586    36.315     0.200
    23.594    36.505     0.200
    23.648    35.725     0.200
    23.797    36.568     0.200
    23.875    35.621     0.200
    23.917    35.839     0.200
    23.966    34.959     0.200
    23.967    35.838     0.200
    24.023    35.919     0.200
    24.048    37.406     0.200
    24.048    34.476     0.200
    24.083    34.984     0.200
    24.176    33.814     0.200
    24.176    33.611     0.200
    24.211    36.297     0.200
    24.211    34.914     0.200
    24.443    33.727     0.200
    24.496    34.976     0.200
    24.496    34.538     0.200
    24.570    35.710     0.200
    24.570    34.217     0.200
    25.012    34.451     0.200
    25.012    31.889     0.200
    25.101    32.740     0.200
    25.101    33.121     0.200
    25.099    33.004     0.200
    25.178    33.224     0.200
    25.178    32.380     0.200
    25.192    31.860     0.200
    25.208    32.198     0.200
    25.474    32.589     0.200
    25.521    32.416     0.200
    25.521    31.705     0.200
    25.682    32.644     0.200
    25.787    31.313     0.200
    25.902    31.006     0.200
    25.994    30.812     0.200
    26.048    31.468     0.200
    26.048    30.578     0.200
    26.100    30.393     0.200
    26.155    30.016     0.200
    26.249    29.292     0.200
    26.249    28.370     0.200
    26.399    29.008     0.200
    26.477    28.717     0.200
    26.487    30.150     0.200
    26.662    26.948     0.200
    26.662    26.604     0.200
    27.596    25.616     0.200
    27.602    27.326     0.200
    27.602    26.396     0.200
    27.666    25.765     0.200
    27.741    26.501     0.200
    27.741    24.455     0.200
    27.756    26.328     0.200
    27.756    25.743     0.200
    28.086    24.310     0.200
    28.972    22.031     0.200
    29.159    21.670     0.200
    29.237    21.541     0.200
    29.371    21.080     0.200
    29.410    23.230     0.200
    29.410    19.738     0.200
    29.584    21.309     0.200
    29.935    19.107     0.200
    13.977    41.391     0.200
    14.439    41.495     0.200
    14.491    45.170     0.200
    14.611    45.816     0.200
    14.708    42.832     0.200
    14.712    44.667     0.200
    14.899    42.049     0.200
    14.910    43.895     0.200
    14.956    44.415     0.200
    15.328    45.249     0.200
    15.653    43.873     0.200
    16.806    41.828     0.200
    16.911    43.936     0.200
    17.002    43.056     0.200
    17.510    41.038     0.200
    17.942    42.793     0.200
    18.306    39.648     0.200
    18.316    40.107     0.200
    18.316    42.036     0.200
    20.203    39.169     0.200
    21.077    40.395     0.200
    21.077    39.293     0.200
    21.320    40.800     0.200
    21.667    37.062     0.200
    21.667    37.719     0.200
    21.682    38.866     0.200
    21.781    38.805     0.200
    21.950    37.420     0.200
    21.957    39.949     0.200
    22.033    37.919     0.200
    22.186    38.382     0.200
    22.420    37.293     0.200
    22.640    36.577     0.200
    22.673    37.917     0.200
    22.738    35.686     0.200
    22.738    37.600     0.200
    23.059    36.357     0.200
    23.304    35.716     0.200
    23.300    37.365     0.200
    23.508    35.640     0.200
    23.593    35.675     0.200
    23.597    36.706     0.200
    23.645    35.272     0.200
    23.800    36.253     0.200
    23.878    35.999     0.200
    23.920    35.652     0.200
    23.969    34.434     0.200
    23.970    35.297     0.200
    24.026    35.387     0.200
    24.176    34.449     0.200
    24.176    33.761     0.200
    24.496    34.777     0.200
    25.008    32.688     0.200
    25.104    31.885     0.200
    25.104    33.165     0.200
    25.175    32.651     0.200
    25.210    31.523     0.200
    25.472    32.299     0.200
    25.519    31.368     0.200
    25.903    28.530     0.200
    25.992    29.545     0.200
    26.153    29.440     0.200
    26.260    29.725     0.200
    26.260    29.374     0.200
    26.476    28.857     0.200
    26.483    28.273     0.200
    27.597    24.801     0.200
    28.090    24.224     0.200
    29.158    22.518     0.200
    17.516    41.598     0.200
    21.622    37.438     0.200
    21.622    38.688     0.200
    22.039    37.391     0.200
    22.428    38.504     0.200
    22.708    37.442     0.200
    27.608    24.762     0.200
    21.642    36.584     0.200
    25.444    32.914     0.200
    15.923    41.927     0.200
    23.433    36.229     0.200
    25.548    31.505     0.200
    26.407    27.090     0.200
    21.681    36.377     0.200
    16.731    40.784     0.200
    17.393    41.621     0.200
    18.748    41.739     0.200
    19.307    42.344     0.200
    20.724    38.874     0.200
    20.997    40.059     0.200
    21.013    40.439     0.200
    21.242    41.165     0.200
    22.692    38.996     0.200
    23.224    38.604     0.200
    23.536    37.859     0.200
    24.437    35.345     0.200
    25.057    34.642     0.200
    26.068    31.395     0.200
    26.676    30.411     0.200
    28.945    23.300     0.200
    15.886    41.319     0.200
    15.886    41.835     0.200
    16.013    42.422     0.200
    17.649    40.536     0.200
    17.703    43.744     0.200
    18.480    43.459     0.200
    20.415    41.946     0.200
    20.724    40.812     0.200
    21.117    41.148     0.200
    21.117    39.780     0.200
    22.127    40.595     0.200
    22.127    39.439     0.200
    22.626    39.830     0.200
    23.533    38.678     0.200
    23.951    37.647     0.200
    23.951    37.178     0.200
    24.623    35.753     0.200
    24.637    35.710     0.200
    24.720    36.270     0.200
    25.057    34.986     0.200
    25.287    33.631     0.200
    26.116    32.104     0.200
    26.212    30.843     0.200
    26.309    31.865     0.200
    26.312    32.127     0.200
    26.312    31.799     0.200
    26.676    31.427     0.200
    26.676    31.028     0.200
    28.296    26.479     0.200
    28.274    26.554     0.200
    28.945    23.902     0.200
    28.945    24.324     0.200
    29.284    22.948     0.200
    29.417    22.129     0.200
    29.996    21.200     0.200
    19.938    37.899     0.200
    20.754    36.631     0.200
    29.020    20.800     0.200
    19.305    41.979     0.200
    20.729    37.532     0.200
    16.120    42.642     0.200
    20.569    38.667     0.200
    21.202    41.859     0.200
    22.434    39.405     0.200
    25.094    33.901     0.200
    17.611    41.046     0.200
    17.924    41.141     0.200
    18.493    41.687     0.200
    18.542    43.278     0.200
    18.868    41.560     0.200
    18.969    40.277     0.200
    19.642    40.915     0.200
    19.730    41.074     0.200
    20.602    39.640     0.200
    21.062    39.744     0.200
    17.922    41.821     0.200
    18.698    44.017     0.200
    19.401    42.087     0.200
    19.445    41.021     0.200
    19.566    40.135     0.200
    19.638    41.444     0.200
    20.600    39.464     0.200
    21.333    38.870     0.200
    21.427    38.434     0.200
    22.442    38.289     0.200
    20.448    39.252     0.200
    22.291    38.153     0.200
    22.547    36.671     0.200
    17.465    41.882     0.200
    17.781    42.688     0.200
    18.644    40.821     0.200
    21.081    41.559     0.200
    21.189    40.447     0.200
    21.896    38.953     0.200
    21.957    39.936     0.200
    21.952    39.185     0.200
    22.301    39.024     0.200
    23.174    35.219     0.200
    23.186    34.633     0.200
    17.323    43.770     0.200
    17.571    41.182     0.200
    17.894    42.800     0.200
    18.150    42.120     0.200
    18.214    41.806     0.200
    20.200    41.826     0.200
    20.355    41.110     0.200
    20.468    41.564     0.200
    21.214    40.247     0.200
    21.294    39.699     0.200
    21.362    39.894     0.200
    21.453    40.523     0.200
    21.464    41.236     0.200
    22.314    38.680     0.200
    25.034    35.405     0.200
    25.901    33.603     0.200
    26.850    30.860     0.200
    28.826    22.935     0.200
    17.894    43.450     0.200
    18.662    43.057     0.200
    20.612    41.213     0.200
    21.362    39.544     0.200
    21.294    40.359     0.200
    22.314    39.350     0.200
    22.821    39.786     0.200
    23.753    36.240     0.200
    23.753    36.760     0.200
    23.717    38.053     0.200
    24.919    35.500     0.200
    25.475    33.782     0.200
    27.943    26.988     0.200
    28.389    24.917     0.200
    16.230    43.235     0.200
    17.699    43.303     0.200
    18.476    45.840     0.200
    20.723    41.591     0.200
    20.849    40.244     0.200
    20.995    41.349     0.200
    21.593    42.340     0.200
    22.124    39.662     0.200
    22.220    40.614     0.200
    22.410    40.160     0.200
    25.283    35.649     0.200
    25.283    35.569     0.200
    16.191    45.614     0.200
    21.272    39.242     0.200
    21.283    40.804     0.200
    25.112    34.040     0.200
    25.104    33.573     0.200
    25.466    32.878     0.200
    25.964    33.253     0.200
    15.356    41.245     0.200
    16.743    42.005     0.200
    17.713    41.380     0.200
    21.124    38.433     0.200
    21.425    39.802     0.200
    22.424    39.085     0.200
    27.644    29.655     0.200
    22.200    38.527     0.200
    22.417    40.082     0.200
    22.479    38.269     0.200
    22.594    38.695     0.200
    22.602    39.823     0.200
    22.882    38.016     0.200
    22.908    39.449     0.200
    23.269    38.295     0.200
    23.671    36.136     0.200
    23.819    38.701     0.200
    24.206    32.526     0.200
    24.212    33.666     0.200
    25.121    33.110     0.200
    25.976    30.661     0.200
    26.955    30.831     0.200
    26.983    29.067     0.200
    28.864    22.041     0.200
    18.260    40.245     0.200
    19.047    40.454     0.200
    19.489    39.425     0.200
    19.728    40.687     0.200
    21.383    37.676     0.200
    21.570    38.173     0.200
    23.091    37.640     0.200
    24.682    33.461     0.200
    25.084    32.762     0.200
    25.591    30.662     0.200
    25.934    32.133     0.200
    26.119    29.246     0.200
    26.700    27.895     0.200
    28.919    21.487     0.200
    29.363    20.905     0.200
    16.218    40.967     0.200
    22.406    40.014     0.200
    25.279    34.408     0.200
    16.476    42.641     0.200
    21.235    41.992     0.200
    19.680    43.006     0.200
    20.422    43.071     0.200
    21.109    40.838     0.200
    21.252    41.611     0.200
    21.696    39.944     0.200
    25.540    34.024     0.200
    25.974    33.033     0.200
    18.696    40.604     0.200
    20.974    39.094     0.200
    21.042    39.519     0.200
    21.408    39.030     0.200
    21.675    38.616     0.200
    22.483    38.698     0.200
    22.674    38.062     0.200
    25.103    34.126     0.200
    27.778    24.806     0.200
    16.146    41.494     0.200
    16.429    42.814     0.200
    17.791    44.507     0.200
    17.830    43.936     0.200
    17.887    43.137     0.200
    18.079    40.895     0.200
    18.212    42.545     0.200
    18.509    43.631     0.200
    18.566    42.731     0.200
    18.842    41.948     0.200
    18.924    43.623     0.200
    18.974    42.003     0.200
    19.212    41.111     0.200
    19.378    43.137     0.200
    19.619    42.874     0.200
    19.700    41.533     0.200
    20.347    42.587     0.200
    20.558    40.641     0.200
    20.916    42.050     0.200
    20.979    40.704     0.200
    20.959    41.383     0.200
    21.044    41.979     0.200
    21.281    40.570     0.200
    21.330    40.620     0.200
    21.345    40.684     0.200
    21.328    39.075     0.200
    21.464    40.400     0.200
    21.586    40.248     0.200
    21.621    41.263     0.200
    21.593    41.086     0.200
    21.632    39.893     0.200
    22.132    39.310     0.200
    22.305    39.866     0.200
    22.391    40.067     0.200
    22.599    39.270     0.200
    22.756    37.674     0.200
    22.777    39.868     0.200
    22.958    37.097     0.200
    22.999    40.181     0.200
    23.129    38.779     0.200
    23.090    37.816     0.200
    23.424    39.201     0.200
    23.934    37.619     0.200
    23.962    38.881     0.200
    24.135    37.625     0.200
    25.467    34.358     0.200
    25.923    32.749     0.200
    25.968    31.871     0.200
    26.044    31.051     0.200
    26.837    30.967     0.200
    27.807    27.212     0.200
    27.945    26.679     0.200
    16.229    42.737     0.200
    17.122    43.541     0.200
    17.698    42.529     0.200
    18.743    42.315     0.200
    19.505    41.717     0.200
    20.162    41.912     0.200
    20.265    41.588     0.200
    20.377    40.948     0.200
    20.411    42.069     0.200
    20.722    41.506     0.200
    20.848    41.295     0.200
    21.011    40.956     0.200
    21.143    40.061     0.200
    21.262    40.957     0.200
    21.426    40.502     0.200
    21.411    40.123     0.200
    21.435    39.983     0.200
    21.787    39.660     0.200
    21.872    39.606     0.200
    21.895    39.069     0.200
    21.996    40.012     0.200
    22.219    39.229     0.200
    22.409    39.414     0.200
    22.475    39.970     0.200
    22.592    39.026     0.200
    22.622    39.852     0.200
    23.233    38.388     0.200
    23.528    38.506     0.200
    23.949    37.082     0.200
    25.282    34.566     0.200
    25.282    34.347     0.200
    27.740    27.319     0.200
    27.855    27.608     0.200
    28.116    26.497     0.200
    28.217    25.877     0.200
    20.968    40.537     0.200
    21.019    40.334     0.200
    21.388    39.380     0.200
    21.388    39.637     0.200
    21.682    39.441     0.200
    25.072    35.092     0.200
    20.968    41.524     0.200
    23.041    38.466     0.200
    24.666    34.106     0.200
    26.086    30.009     0.200
    26.893    29.696     0.200
    29.309    22.048     0.200
    29.553    21.648     0.200
    17.476    41.114     0.200
    18.835    41.208     0.200
    19.315    42.133     0.200
    20.125    39.599     0.200
    20.469    40.569     0.200
    21.108    39.847     0.200
    21.237    39.046     0.200
    15.925    42.139     0.200
    17.793    42.535     0.200
    18.565    45.493     0.200
    20.255    41.389     0.200
    20.508    41.004     0.200
    21.200    39.757     0.200
    21.397    38.746     0.200
    22.215    38.703     0.200
    22.718    39.073     0.200
    23.858    35.979     0.200
    23.858    36.569     0.200
    24.814    35.819     0.200
    25.044    35.464     0.200
    18.976    41.401     0.200
    19.535    40.717     0.200
    19.576    40.515     0.200
    19.646    40.764     0.200
    20.343    41.590     0.200
    20.543    38.926     0.200
    20.996    39.196     0.200
    21.065    39.086     0.200
    22.356    38.038     0.200
    23.727    35.266     0.200
    26.284    28.836     0.200
    26.902    27.827     0.200
    28.888    21.194     0.200
    29.327    22.666     0.200
    14.219    44.912     0.200
    16.082    44.421     0.200
    17.931    43.669     0.200
    18.708    41.470     0.200
    20.395    41.865     0.200
    20.640    41.077     0.200
    21.344    40.081     0.200
    21.344    39.651     0.200
    22.356    39.499     0.200
    22.356    38.859     0.200
    22.853    38.973     0.200
    23.727    35.930     0.200
    23.727    35.782     0.200
    24.865    36.532     0.200
    24.944    35.215     0.200
    25.117    33.656     0.200
    25.515    33.263     0.200
    25.980    31.132     0.200
    26.342    30.258     0.200
    26.516    29.622     0.200
    26.516    28.700     0.200
    26.902    29.523     0.200
    26.902    29.046     0.200
    27.960    26.906     0.200
    28.464    24.202     0.200
    28.513    25.289     0.200
    28.888    22.593     0.200
    29.327    21.876     0.200
    16.464    42.362     0.200
    16.967    41.515     0.200
    17.941    41.416     0.200
    18.721    44.635     0.200
    19.547    40.859     0.200
    19.652    40.611     0.200
    21.225    41.659     0.200
    25.144    32.893     0.200
    26.006    32.599     0.200
    26.618    29.589     0.200
    28.910    24.079     0.200
    18.557    41.519     0.200
    18.759    41.774     0.200
    19.318    40.983     0.200
    19.360    40.712     0.200
    19.362    40.589     0.200
    19.412    41.159     0.200
    19.426    40.702     0.200
    20.695    38.616     0.200
    21.490    39.367     0.200
    21.606    39.203     0.200
    22.724    39.204     0.200
    24.421    33.614     0.200
    25.092    33.374     0.200
    25.986    31.133     0.200
    26.691    29.363     0.200
    26.713    28.895     0.200
    27.772    26.875     0.200
    28.975    22.093     0.200
    15.886    42.163     0.200
    15.886    41.704     0.200
    17.711    42.899     0.200
    18.243    41.860     0.200
    18.492    43.525     0.200
    20.177    42.609     0.200
    20.420    41.464     0.200
    21.132    40.979     0.200
    21.132    40.599     0.200
    21.467    39.253     0.200
    21.677    42.866     0.200
    22.138    39.409     0.200
    22.138    39.238     0.200
    22.632    39.290     0.200
    23.546    38.711     0.200
    23.948    36.282     0.200
    24.438    35.848     0.200
    24.646    35.701     0.200
    24.724    35.733     0.200
    25.092    33.874     0.200
    25.297    33.917     0.200
    26.122    31.599     0.200
    26.337    30.050     0.200
    26.337    30.790     0.200
    26.304    31.581     0.200
    26.691    30.483     0.200
    26.691    30.383     0.200
    27.742    27.637     0.200
    28.302    24.676     0.200
    28.295    26.388     0.200
    28.975    21.902     0.200
    29.320    22.022     0.200
    29.428    23.610     0.200
    22.240    39.332     0.200
    25.508    31.814     0.200
    18.712    39.033     0.200
    21.428    39.185     0.200
    22.407    36.532     0.200
    25.567    33.087     0.200
    21.928    38.758     0.200
    17.987    42.283     0.200
    20.447    42.528     0.200
    20.563    40.813     0.200
    21.338    40.171     0.200
    25.887    32.583     0.200
    17.987    43.345     0.200
    18.752    44.937     0.200
    20.707    40.860     0.200
    21.338    40.050     0.200
    21.381    39.533     0.200
    22.915    38.867     0.200
    23.658    36.350     0.200
    25.014    35.442     0.200
    26.938    32.205     0.200
    28.038    26.628     0.200
    28.779    23.931     0.200
    21.348    38.400     0.200
    21.430    38.387     0.200
    22.698    37.163     0.200
    25.044    32.331     0.200
    25.516    32.214     0.200
    25.897    31.262     0.200
    16.599    41.052     0.200
    16.990    41.258     0.200
    17.386    40.979     0.200
    17.689    41.527     0.200
    17.860    41.724     0.200
    17.958    41.578     0.200
    18.213    41.519     0.200
    18.277    42.205     0.200
    18.631    41.834     0.200
    18.727    41.475     0.200
    18.908    40.820     0.200
    18.998    41.464     0.200
    19.281    41.255     0.200
    19.443    41.677     0.200
    19.480    40.999     0.200
    19.559    41.122     0.200
    19.594    40.588     0.200
    19.683    40.769     0.200
    20.265    40.306     0.200
    20.291    40.996     0.200
    20.420    40.253     0.200
    20.529    40.146     0.200
    20.632    39.823     0.200
    20.985    39.372     0.200
    21.272    40.548     0.200
    21.368    38.657     0.200
    21.358    39.569     0.200
    22.040    39.000     0.200
    22.818    36.810     0.200
    25.056    33.787     0.200
    25.914    31.878     0.200
    26.915    29.182     0.200
    17.958    43.156     0.200
    18.727    42.026     0.200
    20.420    41.343     0.200
    20.675    41.017     0.200
    21.368    39.137     0.200
    21.358    39.741     0.200
    22.379    38.153     0.200
    22.884    38.451     0.200
    23.690    36.193     0.200
    23.781    37.323     0.200
    24.892    36.345     0.200
    25.056    33.638     0.200
    24.981    34.781     0.200
    25.540    32.755     0.200
    26.376    33.364     0.200
    26.505    27.752     0.200
    28.003    26.469     0.200
    28.445    24.133     0.200
    28.815    23.123     0.200
    21.416    38.838     0.200
    16.139    41.606     0.200
    20.558    37.617     0.200
    21.409    39.124     0.200
    22.456    39.326     0.200
    22.647    38.839     0.200
    22.834    38.702     0.200
    25.091    33.106     0.200
    25.519    33.728     0.200
    25.953    32.601     0.200
    17.350    43.904     0.200
    17.811    42.776     0.200
    17.912    42.897     0.200
    18.687    42.826     0.200
    18.855    42.408     0.200
    19.704    41.921     0.200
    20.232    41.270     0.200
    20.324    40.547     0.200
    20.375    41.083     0.200
    20.472    41.451     0.200
    20.934    41.324     0.200
    20.991    40.217     0.200
    21.323    39.909     0.200
    21.426    38.724     0.200
    21.999    39.802     0.200
    22.336    39.537     0.200
    22.405    39.725     0.200
    22.622    39.753     0.200
    22.830    39.595     0.200
    24.927    35.249     0.200
    25.102    35.108     0.200
    25.155    33.501     0.200
    25.495    33.722     0.200
    25.920    32.282     0.200
    25.967    31.802     0.200
    26.881    30.657     0.200
    28.961    24.110     0.200
    18.687    42.463     0.200
    20.375    42.325     0.200
    20.622    41.695     0.200
    21.323    40.077     0.200
    21.426    38.865     0.200
    22.336    39.088     0.200
    23.745    37.783     0.200
    24.927    35.628     0.200
    25.102    36.710     0.200
    25.495    34.985     0.200
    25.967    32.419     0.200
    26.324    34.121     0.200
    26.493    29.936     0.200
    26.881    33.036     0.200
    27.785    29.394     0.200
    27.945    27.352     0.200
    23.745    37.396     0.200
    19.686    40.833     0.200
    20.902    42.179     0.200
    22.722    38.044     0.200
    19.395    41.657     0.200
    21.469    38.045     0.200
    25.146    31.737     0.200
    25.507    30.193     0.200
    26.011    29.151     0.200
    20.387    41.587     0.200
    21.340    38.523     0.200
    21.469    39.241     0.200
    22.348    38.776     0.200
    23.741    35.937     0.200
    24.930    34.748     0.200
    25.146    33.386     0.200
    26.011    30.136     0.200
    27.813    26.469     0.200
    15.441    42.842     0.200
    16.168    42.503     0.200
    16.554    43.202     0.200
    16.710    41.891     0.200
    16.739    42.348     0.200
    17.133    42.188     0.200
    17.154    43.026     0.200
    17.399    41.437     0.200
    17.437    41.841     0.200
    18.024    42.194     0.200
    18.486    42.357     0.200
    18.755    42.118     0.200
    19.314    41.640     0.200
    19.917    41.541     0.200
    20.174    41.337     0.200
    21.426    38.701     0.200
    22.692    38.794     0.200
    25.052    33.453     0.200
    25.945    31.091     0.200
    26.312    31.163     0.200
    26.682    31.266     0.200
    28.937    22.525     0.200
    17.710    42.805     0.200
    18.486    43.088     0.200
    18.569    43.578     0.200
    20.174    42.044     0.200
    20.423    41.148     0.200
    21.123    40.333     0.200
    21.426    39.158     0.200
    22.134    39.255     0.200
    22.634    39.289     0.200
    23.540    38.591     0.200
    23.943    35.513     0.200
    23.943    36.361     0.200
    24.645    37.142     0.200
    24.729    35.059     0.200
    25.052    33.594     0.200
    25.294    35.785     0.200
    25.945    31.271     0.200
    26.315    32.275     0.200
    26.682    32.735     0.200
    27.602    28.080     0.200
    27.751    26.899     0.200
    29.279    21.626     0.200
    15.862    44.948     0.200
    15.895    45.560     0.200
    17.648    42.934     0.200
    18.569    44.301     0.200
    21.123    41.122     0.200
    22.134    39.489     0.200
    23.943    35.998     0.200
    26.318    33.800     0.200
    26.682    33.035     0.200
    28.305    28.333     0.200
    28.937    22.747     0.200
    18.217    41.756     0.200
    18.749    42.295     0.200
    19.016    42.091     0.200
    20.149    41.998     0.200
    20.501    38.732     0.200
    20.435    40.618     0.200
    20.677    40.726     0.200
    21.386    39.281     0.200
    21.455    39.105     0.200
    22.112    40.221     0.200
    22.396    38.262     0.200
    22.992    36.404     0.200
    22.892    37.665     0.200
    23.997    36.659     0.200
    24.203    32.416     0.200
    16.136    42.671     0.200
    16.136    42.902     0.200
    17.438    41.167     0.200
    17.970    42.814     0.200
    18.749    43.194     0.200
    18.804    45.012     0.200
    18.804    44.872     0.200
    20.435    41.118     0.200
    20.677    41.284     0.200
    21.455    39.535     0.200
    21.386    39.731     0.200
    21.386    40.510     0.200
    22.396    38.852     0.200
    22.396    39.047     0.200
    22.891    38.999     0.200
    23.691    35.885     0.200
    23.691    36.924     0.200
    23.691    35.504     0.200
    23.745    38.768     0.200
    23.803    37.557     0.200
    24.905    34.506     0.200
    24.980    35.136     0.200
    25.144    33.763     0.200
    25.555    32.945     0.200
    26.002    31.322     0.200
    26.559    29.876     0.200
    26.559    30.136     0.200
    26.543    31.204     0.200
    26.944    28.805     0.200
    26.944    30.016     0.200
    27.851    26.302     0.200
    27.994    27.064     0.200
    28.507    24.186     0.200
    28.545    25.758     0.200
    28.895    23.155     0.200
    29.351    21.845     0.200
    29.686    22.394     0.200
    17.682    40.815     0.200
    19.027    41.323     0.200
    19.586    40.744     0.200
    19.766    39.575     0.200
    21.003    39.726     0.200
    20.475    39.959     0.200
    20.425    41.518     0.200
    21.271    40.158     0.200
    24.183    35.785     0.200
    16.154    45.783     0.200
    16.154    45.387     0.200
    17.412    42.713     0.200
    18.820    44.988     0.200
    23.672    36.853     0.200
    26.018    29.646     0.200
    28.012    26.805     0.200
    28.563    25.508     0.200
    28.902    22.858     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.269    12.005     0.200
     3.817    14.938     0.200
     4.949    17.535     0.200
     8.003    21.984     0.200
     8.388    23.200     0.200
     8.635    24.514     0.200
     9.767    29.007     0.200
    10.799    29.764     0.200
    12.231    31.252     0.200
    13.200    34.437     0.200
    15.855    38.160     0.200
    20.382    42.028     0.200
     2.326    11.762     0.200
     3.758    14.361     0.200
     3.798    13.180     0.200
     4.847    16.443     0.200
     4.884    16.408     0.200
     5.020    17.322     0.200
     5.184    17.810     0.200
     5.246    18.089     0.200
     5.801    18.612     0.200
     7.073    21.064     0.200
     7.143    23.053     0.200
     7.938    22.669     0.200
     8.325    22.258     0.200
     8.640    22.979     0.200
     8.722    25.421     0.200
    12.224    30.651     0.200
    12.286    30.235     0.200
    17.665    36.855     0.200
     2.241    11.854     0.200
     2.518    11.995     0.200
     3.556    12.708     0.200
     3.754    13.093     0.200
     4.923    17.257     0.200
     5.100    16.695     0.200
     5.104    17.346     0.200
     5.322    18.795     0.200
     5.730    18.335     0.200
     6.205    20.290     0.200
     7.159    20.657     0.200
     8.019    22.622     0.200
     8.397    22.713     0.200
     8.608    24.454     0.200
    12.203    31.302     0.200
    12.202    30.910     0.200
    15.839    38.267     0.200
    17.632    38.445     0.200
    18.573    40.366     0.200
    19.816    42.460     0.200
    20.014    42.139     0.200
    20.352    40.704     0.200
    20.670    39.490     0.200
     2.253    11.557     0.200
     2.513    11.960     0.200
     3.545    12.582     0.200
     3.818    15.693     0.200
     3.755    13.033     0.200
     4.954    17.342     0.200
     5.092    16.731     0.200
     5.112    16.397     0.200
     5.736    18.813     0.200
     6.155    18.720     0.200
     6.155    18.821     0.200
     7.067    21.973     0.200
     7.148    19.638     0.200
     8.011    22.664     0.200
     8.391    23.126     0.200
     8.617    23.986     0.200
     8.770    25.607     0.200
     9.938    30.075     0.200
    12.191    30.884     0.200
    12.214    30.011     0.200
    15.847    37.716     0.200
    17.641    37.675     0.200
    18.570    40.345     0.200
    20.020    41.023     0.200
    20.364    39.202     0.200
    20.680    39.410     0.200
     1.835    10.635     0.200
     2.138    11.415     0.200
     2.608    12.078     0.200
     2.728    12.534     0.200
     2.999    12.825     0.200
     3.270    13.367     0.200
     3.555    14.406     0.200
     3.635    14.903     0.200
     3.643    14.552     0.200
     3.648    14.493     0.200
     3.692    16.884     0.200
     3.733    14.219     0.200
     3.945    15.630     0.200
     3.964    14.539     0.200
     4.226    15.467     0.200
     5.000    16.321     0.200
     5.061    17.409     0.200
     6.217    21.416     0.200
     7.265    20.190     0.200
     8.579    23.850     0.200
     8.841    26.791     0.200
     1.795     7.820     0.200
     1.821     8.953     0.200
     1.890     8.661     0.200
     2.502    10.138     0.200
     2.613    10.894     0.200
     2.711    10.670     0.200
     3.255    11.432     0.200
     3.553    13.209     0.200
     3.636    12.495     0.200
     3.709    14.736     0.200
     3.668    14.829     0.200
     3.895    14.086     0.200
     3.917    14.610     0.200
     3.992    15.235     0.200
     4.149    14.441     0.200
     4.240    15.401     0.200
     4.302    14.666     0.200
     4.745    15.388     0.200
     4.664    16.895     0.200
     4.888    14.999     0.200
     5.004    16.143     0.200
     5.055    15.691     0.200
     5.055    16.832     0.200
     5.036    14.751     0.200
     5.093    15.000     0.200
     5.193    16.726     0.200
     5.417    17.812     0.200
     5.462    16.025     0.200
     5.632    17.082     0.200
     5.642    16.441     0.200
     5.635    18.863     0.200
     5.789    18.208     0.200
     6.062    18.106     0.200
     6.224    19.637     0.200
     6.253    18.973     0.200
     6.440    18.343     0.200
     6.455    19.207     0.200
     6.523    18.855     0.200
     6.523    19.590     0.200
     6.554    19.380     0.200
     6.690    19.381     0.200
     6.717    19.728     0.200
     6.718    19.978     0.200
     6.719    19.742     0.200
     6.744    20.254     0.200
     6.800    19.499     0.200
     6.847    20.098     0.200
     6.867    19.448     0.200
     6.901    20.565     0.200
     6.935    20.343     0.200
     7.040    20.488     0.200
     7.190    20.731     0.200
     7.198    20.892     0.200
     7.200    19.907     0.200
     7.213    21.617     0.200
     7.230    19.653     0.200
     7.402    20.896     0.200
     8.111    19.995     0.200
     8.631    25.238     0.200
     1.786     7.677     0.200
     1.811     8.924     0.200
     1.880     8.646     0.200
     2.493    10.106     0.200
     2.603    10.821     0.200
     2.701    10.357     0.200
     3.245    11.191     0.200
     3.543    12.824     0.200
     3.624    12.390     0.200
     3.626    12.238     0.200
     3.677    13.596     0.200
     3.886    13.717     0.200
     3.907    14.385     0.200
     3.988    14.950     0.200
     4.140    13.940     0.200
     4.232    14.870     0.200
     4.293    14.288     0.200
     4.735    15.151     0.200
     4.674    16.741     0.200
     4.879    14.611     0.200
     4.994    15.840     0.200
     5.027    14.629     0.200
     5.045    15.446     0.200
     5.045    16.888     0.200
     5.084    15.157     0.200
     5.183    16.698     0.200
     5.407    17.586     0.200
     5.453    15.634     0.200
     5.633    16.651     0.200
     5.624    18.186     0.200
     5.779    18.099     0.200
     5.645    18.908     0.200
     6.054    17.876     0.200
     6.156    17.337     0.200
     6.235    19.259     0.200
     6.214    18.981     0.200
     6.243    18.818     0.200
     6.232    18.645     0.200
     6.431    17.386     0.200
     6.445    19.558     0.200
     6.472    18.591     0.200
     6.513    18.273     0.200
     6.532    18.542     0.200
     6.514    19.867     0.200
     6.544    18.223     0.200
     6.669    18.833     0.200
     6.681    19.072     0.200
     6.708    19.157     0.200
     6.710    19.804     0.200
     6.709    19.970     0.200
     6.734    19.883     0.200
     6.791    19.546     0.200
     6.838    19.717     0.200
     6.859    19.320     0.200
     6.891    19.843     0.200
     6.926    20.071     0.200
     7.031    20.650     0.200
     7.184    22.521     0.200
     7.189    21.935     0.200
     7.222    19.381     0.200
     7.393    20.827     0.200
     7.678    20.889     0.200
     8.102    20.567     0.200
     8.482    21.367     0.200
     1.660     9.518     0.200
     1.734     9.051     0.200
     1.762     9.713     0.200
     1.829    10.076     0.200
     2.445    11.071     0.200
     2.551    11.867     0.200
     2.654    11.841     0.200
     3.197    12.816     0.200
     3.492    14.067     0.200
     3.576    14.366     0.200
     3.856    15.492     0.200
     4.725    16.751     0.200
     1.823    10.543     0.200
     2.404    12.134     0.200
     2.382    10.919     0.200
     3.049    11.907     0.200
     3.327    13.786     0.200
     3.417    12.911     0.200
     3.416    12.344     0.200
     3.425    13.913     0.200
     3.507    13.726     0.200
     3.867    15.415     0.200
     4.108    14.665     0.200
     4.478    15.844     0.200
     4.519    15.986     0.200
     4.900    15.600     0.200
     5.569    18.686     0.200
     1.528     8.238     0.200
     1.943     9.292     0.200
     2.033    10.444     0.200
     2.244    10.974     0.200
     2.244    10.774     0.200
     2.609    11.721     0.200
     2.775    11.780     0.200
     2.819    12.763     0.200
     3.096    12.369     0.200
     3.420    12.532     0.200
     3.483    15.522     0.200
     3.702    13.363     0.200
     3.771    14.363     0.200
     3.856    14.165     0.200
     4.080    14.548     0.200
     4.178    14.555     0.200
     4.671    15.749     0.200
     4.891    16.534     0.200
     5.193    16.070     0.200
     1.635     8.396     0.200
     1.727     9.421     0.200
     2.346    11.500     0.200
     2.386    11.854     0.200
     2.452    11.862     0.200
     2.554    11.973     0.200
     2.826    12.506     0.200
     3.118    12.744     0.200
     3.391    14.308     0.200
     3.474    14.942     0.200
     3.563    13.620     0.200
     3.757    15.633     0.200
     3.791    14.383     0.200
     3.810    13.339     0.200
     3.938    15.686     0.200
     4.165    15.777     0.200
     4.392    15.776     0.200
     4.583    15.277     0.200
     4.842    15.689     0.200
     4.827    17.154     0.200
     4.879    15.467     0.200
     5.184    17.050     0.200
     5.750    16.933     0.200
     5.750    16.952     0.200
     6.101    17.268     0.200
     7.635    22.634     0.200
     8.686    22.348     0.200
     1.959    10.676     0.200
     1.952     9.451     0.200
     2.632    12.425     0.200
     2.769    12.519     0.200
     2.842    13.272     0.200
     3.389    14.092     0.200
     3.511    16.491     0.200
     3.705    14.698     0.200
     3.747    15.508     0.200
     3.773    14.504     0.200
     3.781    14.011     0.200
     4.074    15.688     0.200
     4.092    15.892     0.200
     4.421    15.051     0.200
     4.470    17.769     0.200
     4.690    15.911     0.200
     4.845    16.993     0.200
     5.167    16.842     0.200
     5.216    16.563     0.200
     5.593    18.067     0.200
     5.933    21.300     0.200
     5.951    19.992     0.200
     6.177    19.647     0.200
     6.382    20.563     0.200
     2.295    11.401     0.200
     2.403    11.999     0.200
     2.770    12.225     0.200
     3.040    12.322     0.200
     3.409    14.252     0.200
     3.673    14.787     0.200
     3.905    14.605     0.200
     4.821    17.673     0.200
     4.965    17.103     0.200
     5.183    18.662     0.200
     5.249    17.948     0.200
     7.110    20.876     0.200
     8.252    23.045     0.200
     1.583     7.918     0.200
     1.639     9.553     0.200
     1.691     9.043     0.200
     2.331    11.117     0.200
     2.400    11.283     0.200
     2.372    11.535     0.200
     2.439    11.102     0.200
     2.538    11.686     0.200
     2.806    11.826     0.200
     3.035    12.065     0.200
     3.348    12.702     0.200
     3.440    13.328     0.200
     3.451    13.300     0.200
     3.531    11.964     0.200
     3.704    13.745     0.200
     3.882    13.067     0.200
     4.139    14.264     0.200
     4.502    15.732     0.200
     5.214    16.978     0.200
     5.589    18.144     0.200
     1.594     8.790     0.200
     1.650     9.587     0.200
     2.363    11.232     0.200
     2.342    11.453     0.200
     2.411    10.978     0.200
     2.450    10.797     0.200
     2.549    11.630     0.200
     2.817    12.000     0.200
     3.359    12.883     0.200
     3.378    14.271     0.200
     3.451    13.410     0.200
     3.462    13.581     0.200
     3.543    12.544     0.200
     3.715    14.428     0.200
     3.776    14.220     0.200
     3.872    13.473     0.200
     4.107    14.260     0.200
     4.150    13.755     0.200
     4.378    14.293     0.200
     4.514    15.014     0.200
     4.553    14.739     0.200
     4.715    15.164     0.200
     4.813    15.114     0.200
     4.939    14.842     0.200
     5.202    15.928     0.200
     5.229    17.561     0.200
     5.606    18.666     0.200
     5.867    19.622     0.200
     5.921    18.991     0.200
     6.346    18.832     0.200
     8.525    23.796     0.200
    12.159    30.686     0.200
     1.800     9.896     0.200
     2.305    11.701     0.200
     2.426    11.589     0.200
     2.516    12.243     0.200
     3.175    12.846     0.200
     3.283    13.184     0.200
     3.461    14.219     0.200
     3.483    15.555     0.200
     3.548    14.198     0.200
     3.553    13.937     0.200
     3.613    15.442     0.200
     3.576    13.368     0.200
     3.820    16.021     0.200
     3.868    13.858     0.200
     3.930    16.144     0.200
     3.767    13.738     0.200
     4.209    15.585     0.200
     4.653    16.500     0.200
     4.966    18.254     0.200
     5.108    18.323     0.200
     5.788    17.559     0.200
     6.139    21.727     0.200
     7.182    20.490     0.200
     8.028    22.914     0.200
     7.877    21.494     0.200
     8.399    23.686     0.200
     8.576    23.468     0.200
    12.115    30.570     0.200
     1.812    10.038     0.200
     2.435    11.769     0.200
     2.530    11.961     0.200
     3.185    12.618     0.200
     3.834    15.738     0.200
     3.751    15.110     0.200
     4.978    18.596     0.200
     5.097    17.200     0.200
     5.339    19.078     0.200
     5.804    19.405     0.200
     6.155    20.760     0.200
     7.185    19.934     0.200
     7.215    20.586     0.200
     8.412    23.516     0.200
     8.589    24.328     0.200
    12.114    30.666     0.200
     2.304    12.825     0.200
     2.304    11.245     0.200
     2.668    12.830     0.200
     2.814    12.613     0.200
     3.331    14.383     0.200
     3.405    13.518     0.200
     3.585    13.043     0.200
     4.115    17.047     0.200
     5.005    17.558     0.200
     5.005    18.539     0.200
     1.828    10.385     0.200
     2.276    12.517     0.200
     2.456    11.763     0.200
     2.541    12.071     0.200
     2.552    11.914     0.200
     2.664    12.158     0.200
     2.721    12.297     0.200
     3.205    13.285     0.200
     3.312    14.008     0.200
     3.845    16.384     0.200
     3.929    16.420     0.200
     3.750    13.300     0.200
     4.994    17.270     0.200
     5.136    18.023     0.200
     5.202    17.062     0.200
     5.079    17.539     0.200
     5.356    19.259     0.200
     5.775    20.015     0.200
     5.804    17.822     0.200
     6.157    19.254     0.200
     7.211    20.802     0.200
     7.241    20.236     0.200
     7.656    22.691     0.200
     8.426    22.774     0.200
     8.568    24.662     0.200
     8.754    24.668     0.200
     8.780    26.349     0.200
    12.082    31.419     0.200
    12.087    31.548     0.200
     2.526    11.668     0.200
     2.224    11.052     0.200
     2.307    10.721     0.200
     2.378    11.667     0.200
     2.433    11.695     0.200
     2.518    11.501     0.200
     3.109    12.730     0.200
     3.300    13.655     0.200
     3.683    14.954     0.200
     3.683    14.868     0.200
     3.998    15.586     0.200
     4.051    15.284     0.200
     4.745    16.409     0.200
     5.297    18.360     0.200
     5.297    18.485     0.200
     5.642    20.021     0.200
     2.382    12.257     0.200
     3.073    10.973     0.200
     3.711    14.830     0.200
     3.874    15.292     0.200
     3.874    15.428     0.200
     3.869    14.250     0.200
     4.346    16.806     0.200
     4.858    17.084     0.200
     5.001    18.477     0.200
     5.213    17.631     0.200
     5.213    17.400     0.200
     5.645    19.587     0.200
     5.689    16.452     0.200
     6.039    18.897     0.200
     8.290    22.794     0.200
     8.546    23.420     0.200
     8.546    23.709     0.200
     8.546    24.112     0.200
     8.528    25.713     0.200
     8.656    25.721     0.200
    12.175    29.752     0.200
    12.175    30.752     0.200
    12.181    30.984     0.200
     2.338    11.864     0.200
     2.440    12.467     0.200
     3.007    13.705     0.200
     3.850    16.024     0.200
     3.850    16.294     0.200
     1.734     8.868     0.200
     2.292    11.671     0.200
     2.551    11.668     0.200
     2.542    10.848     0.200
     2.780    11.439     0.200
     2.966    14.702     0.200
     3.174    12.851     0.200
     3.202    12.383     0.200
     3.315    13.061     0.200
     3.513    13.845     0.200
     3.519    15.170     0.200
     3.567    13.472     0.200
     3.579    13.408     0.200
     3.581    13.542     0.200
     3.593    13.026     0.200
     3.688    13.614     0.200
     3.730    12.116     0.200
     3.730    13.225     0.200
     3.897    13.872     0.200
     3.960    15.548     0.200
     3.960    15.650     0.200
     4.087    14.863     0.200
     4.180    15.206     0.200
     4.242    15.586     0.200
     4.252    14.265     0.200
     4.487    17.047     0.200
     4.642    16.696     0.200
     4.686    15.659     0.200
     4.686    16.041     0.200
     4.945    16.740     0.200
     4.997    17.129     0.200
     5.045    15.693     0.200
     5.079    16.654     0.200
     5.079    16.545     0.200
     5.202    16.883     0.200
     5.411    16.500     0.200
     5.422    19.354     0.200
     5.580    18.721     0.200
     5.737    19.291     0.200
     5.790    18.881     0.200
     5.790    19.022     0.200
     5.825    17.112     0.200
     5.825    16.963     0.200
     5.802    17.404     0.200
     5.999    19.824     0.200
     6.161    19.489     0.200
     6.177    20.859     0.200
     6.177    20.281     0.200
     6.235    18.640     0.200
     6.255    19.634     0.200
     6.275    20.110     0.200
     6.330    17.296     0.200
     6.461    20.785     0.200
     6.666    19.557     0.200
     6.668    19.876     0.200
     6.748    19.632     0.200
     6.798    21.153     0.200
     6.827    20.644     0.200
     6.851    21.217     0.200
     6.888    20.535     0.200
     6.993    21.406     0.200
     7.120    21.795     0.200
     7.153    22.344     0.200
     7.168    22.314     0.200
     7.226    20.199     0.200
     7.642    22.720     0.200
     7.806    22.894     0.200
     8.037    22.632     0.200
     8.098    23.017     0.200
     8.119    22.586     0.200
     8.189    23.077     0.200
     8.431    22.702     0.200
     8.411    25.338     0.200
     8.591    24.309     0.200
     8.600    24.375     0.200
     8.772    24.183     0.200
     9.333    25.707     0.200
    10.118    28.938     0.200
    12.102    30.821     0.200
    12.102    31.180     0.200
    12.106    30.409     0.200
    14.042    34.195     0.200
    14.712    35.574     0.200
    15.229    38.585     0.200
    15.801    38.043     0.200
    15.987    35.953     0.200
    18.311    40.985     0.200
    18.727    41.969     0.200
    19.286    42.085     0.200
    19.558    40.810     0.200
    19.980    40.112     0.200
    20.036    42.099     0.200
    20.214    39.888     0.200
    20.198    40.110     0.200
    20.206    40.602     0.200
    20.632    39.273     0.200
     1.731     8.251     0.200
     2.307    11.227     0.200
     2.307    10.907     0.200
     2.548    11.692     0.200
     2.530    11.184     0.200
     2.783    11.620     0.200
     3.182    12.798     0.200
     3.193    12.458     0.200
     3.308    13.214     0.200
     3.516    13.987     0.200
     3.557    12.805     0.200
     3.572    13.025     0.200
     3.573    13.976     0.200
     3.580    12.650     0.200
     3.681    13.252     0.200
     3.726    13.092     0.200
     3.889    13.700     0.200
     3.973    15.362     0.200
     4.088    14.604     0.200
     4.185    14.685     0.200
     4.238    15.341     0.200
     4.241    14.003     0.200
     4.489    16.496     0.200
     4.681    16.156     0.200
     4.940    16.523     0.200
     4.991    16.936     0.200
     5.034    15.396     0.200
     5.087    16.492     0.200
     5.087    16.320     0.200
     5.087    16.094     0.200
     5.401    16.587     0.200
     5.414    18.811     0.200
     5.521    17.607     0.200
     5.574    17.427     0.200
     5.790    18.263     0.200
     5.791    17.099     0.200
     5.830    17.102     0.200
     5.830    17.000     0.200
     6.002    18.124     0.200
     6.160    19.045     0.200
     6.181    18.795     0.200
     6.248    19.170     0.200
     6.322    18.716     0.200
     6.354    18.804     0.200
     6.386    19.689     0.200
     6.460    19.436     0.200
     6.617    20.063     0.200
     6.656    18.910     0.200
     6.658    20.221     0.200
     6.739    19.061     0.200
     6.788    20.141     0.200
     6.841    20.166     0.200
     6.878    20.070     0.200
     6.982    21.676     0.200
     7.109    22.157     0.200
     7.141    22.129     0.200
     7.195    20.857     0.200
     7.098    20.977     0.200
     7.212    20.333     0.200
     7.631    22.412     0.200
     7.693    22.704     0.200
     7.623    23.513     0.200
     7.793    22.768     0.200
     8.029    22.165     0.200
     8.085    22.479     0.200
     8.107    22.872     0.200
     8.087    23.346     0.200
     8.426    22.843     0.200
     8.422    24.667     0.200
     8.597    24.528     0.200
     8.616    24.056     0.200
     8.616    23.088     0.200
     8.616    24.252     0.200
     8.773    24.093     0.200
     8.800    25.781     0.200
     8.654    24.542     0.200
    10.117    28.765     0.200
    10.117    29.164     0.200
    12.117    29.084     0.200
    12.117    30.124     0.200
    12.122    29.462     0.200
    12.348    35.013     0.200
    12.853    35.685     0.200
    14.040    33.839     0.200
    14.712    35.393     0.200
    15.228    38.548     0.200
    15.809    37.863     0.200
    15.809    38.206     0.200
    15.973    35.958     0.200
    17.510    39.585     0.200
    19.027    42.335     0.200
    19.984    40.280     0.200
    20.033    41.960     0.200
    20.198    39.367     0.200
    20.218    39.763     0.200
    20.644    39.368     0.200
     1.729     8.564     0.200
     1.827     9.597     0.200
     2.294    11.442     0.200
     2.540    11.301     0.200
     2.546    12.051     0.200
     2.785    11.884     0.200
     3.169    13.456     0.200
     3.198    12.698     0.200
     3.310    13.242     0.200
     3.563    12.784     0.200
     3.575    13.612     0.200
     3.735    14.790     0.200
     3.893    14.252     0.200
     3.956    15.817     0.200
     4.082    14.992     0.200
     4.238    15.591     0.200
     4.249    14.152     0.200
     4.482    16.411     0.200
     4.682    16.421     0.200
     4.941    17.103     0.200
     4.993    18.264     0.200
     5.082    17.023     0.200
     5.082    16.562     0.200
     5.082    17.320     0.200
     5.355    18.848     0.200
     5.407    17.360     0.200
     5.785    18.987     0.200
     5.799    17.814     0.200
     5.820    17.953     0.200
     5.820    18.515     0.200
     6.156    19.811     0.200
     6.251    19.821     0.200
     6.456    20.420     0.200
     6.662    20.456     0.200
     6.745    19.876     0.200
     6.990    21.292     0.200
     7.224    20.368     0.200
     7.679    23.243     0.200
     8.427    23.426     0.200
     8.766    23.930     0.200
    12.103    31.364     0.200
    12.107    30.842     0.200
     2.277    12.085     0.200
     2.542    12.494     0.200
     2.664    12.325     0.200
     2.789    12.438     0.200
     3.150    13.410     0.200
     3.205    13.083     0.200
     3.312    13.609     0.200
     3.494    14.479     0.200
     3.571    13.560     0.200
     3.577    14.380     0.200
     3.583    14.813     0.200
     3.687    14.330     0.200
     3.748    15.012     0.200
     3.932    16.004     0.200
     3.932    16.433     0.200
     4.071    15.448     0.200
     4.159    15.313     0.200
     4.236    16.112     0.200
     4.259    14.988     0.200
     4.470    18.027     0.200
     4.640    17.235     0.200
     4.681    16.563     0.200
     4.941    17.578     0.200
     4.994    17.578     0.200
     5.079    18.728     0.200
     5.079    18.493     0.200
     5.202    17.514     0.200
     5.414    18.217     0.200
     5.552    18.523     0.200
     5.674    18.913     0.200
     5.731    19.886     0.200
     5.776    19.722     0.200
     5.806    17.825     0.200
     5.806    17.313     0.200
     5.809    18.153     0.200
     6.026    19.879     0.200
     6.150    20.059     0.200
     6.221    19.063     0.200
     6.254    20.478     0.200
     6.330    21.020     0.200
     6.450    20.255     0.200
     6.630    20.902     0.200
     6.669    20.704     0.200
     6.671    20.901     0.200
     6.751    20.553     0.200
     6.857    21.004     0.200
     6.893    21.924     0.200
     7.122    21.393     0.200
     7.240    20.621     0.200
     7.658    23.469     0.200
     8.111    22.267     0.200
     8.201    23.948     0.200
     8.374    24.388     0.200
     8.404    27.078     0.200
     8.426    23.596     0.200
     8.473    24.115     0.200
     8.571    25.245     0.200
     8.571    24.218     0.200
     8.571    25.096     0.200
     8.570    24.553     0.200
     8.756    24.443     0.200
    10.133    29.762     0.200
    12.084    31.694     0.200
    12.088    31.296     0.200
    18.316    40.281     0.200
     1.822    10.237     0.200
     2.295    12.074     0.200
     2.537    12.322     0.200
     2.540    12.400     0.200
     2.653    12.326     0.200
     2.791    12.779     0.200
     3.194    12.481     0.200
     3.161    13.120     0.200
     3.305    13.639     0.200
     3.742    15.076     0.200
     3.949    15.991     0.200
     3.949    16.139     0.200
     4.074    15.305     0.200
     4.167    15.553     0.200
     4.232    16.183     0.200
     4.676    16.682     0.200
     4.936    17.504     0.200
     6.150    19.703     0.200
     6.450    20.561     0.200
     7.671    23.445     0.200
     1.875    10.991     0.200
     1.913    10.776     0.200
     2.099    11.753     0.200
     2.296    11.920     0.200
     2.600    12.515     0.200
     2.611    12.241     0.200
     3.114    12.622     0.200
     3.189    13.356     0.200
     3.349    14.378     0.200
     3.457    14.283     0.200
     3.732    15.095     0.200
     3.732    15.435     0.200
     3.884    15.374     0.200
     3.955    16.070     0.200
     4.093    15.820     0.200
     4.514    18.208     0.200
     4.543    16.209     0.200
     4.867    17.859     0.200
     5.093    17.908     0.200
     5.611    19.357     0.200
     5.981    19.859     0.200
    10.980    29.834     0.200
    11.591    31.335     0.200
     1.725     8.719     0.200
     2.155    11.179     0.200
     2.298    11.608     0.200
     2.298    11.459     0.200
     2.542    11.699     0.200
     2.789    11.549     0.200
     2.696    11.783     0.200
     2.715    11.845     0.200
     2.923    12.286     0.200
     2.950    13.506     0.200
     3.306    13.274     0.200
     3.954    15.469     0.200
     4.077    14.127     0.200
     4.171    15.785     0.200
     4.430    15.833     0.200
     4.489    16.031     0.200
     4.741    16.169     0.200
     5.087    16.765     0.200
     5.087    16.453     0.200
     4.988    17.999     0.200
     5.037    15.533     0.200
     5.253    16.664     0.200
     5.193    16.921     0.200
     5.402    16.461     0.200
     5.570    18.503     0.200
     5.724    18.441     0.200
     5.795    17.647     0.200
     5.780    19.733     0.200
     6.152    18.637     0.200
     6.186    18.956     0.200
     6.247    18.244     0.200
     6.452    19.871     0.200
     6.725    19.798     0.200
     6.986    20.626     0.200
     7.220    20.836     0.200
     7.809    21.130     0.200
     8.100    23.084     0.200
     8.422    22.863     0.200
     8.597    24.287     0.200
     1.720     9.746     0.200
     1.808    10.491     0.200
     1.896    10.360     0.200
     1.915    10.794     0.200
     2.211    10.296     0.200
     2.353    11.302     0.200
     2.113    10.981     0.200
     2.238    11.314     0.200
     3.146    13.371     0.200
     3.433    14.099     0.200
     1.646     8.818     0.200
     1.719     9.203     0.200
     1.754     9.824     0.200
     1.766     9.802     0.200
     1.787     9.282     0.200
     1.850    10.759     0.200
     1.850    10.911     0.200
     1.968    10.257     0.200
     1.989    10.216     0.200
     2.052    10.813     0.200
     2.086    10.550     0.200
     2.112    11.770     0.200
     2.134    10.469     0.200
     2.400    12.578     0.200
     2.448    11.057     0.200
     2.498    11.128     0.200
     2.517    11.622     0.200
     2.517    11.743     0.200
     2.533    11.208     0.200
     2.993    11.973     0.200
     3.124    12.230     0.200
     3.316    13.275     0.200
     4.008    14.591     0.200
     4.008    15.482     0.200
     4.067    14.646     0.200
     4.111    14.691     0.200
     4.450    16.489     0.200
     2.242    11.789     0.200
     2.356    12.549     0.200
     2.625    11.731     0.200
     3.217    14.382     0.200
     3.900    16.032     0.200
     3.900    15.702     0.200
     4.586    16.461     0.200
     4.676    14.793     0.200
     5.107    17.375     0.200
     1.590     8.506     0.200
     1.629     9.507     0.200
     1.823    10.108     0.200
     2.043    10.090     0.200
     2.020    11.378     0.200
     2.054    10.905     0.200
     2.153    10.783     0.200
     2.170    10.472     0.200
     2.317    10.763     0.200
     2.312    11.459     0.200
     2.419    10.515     0.200
     2.398    11.985     0.200
     2.525    11.252     0.200
     2.580    11.735     0.200
     2.795    11.964     0.200
     3.066    12.615     0.200
     3.171    13.056     0.200
     3.349    13.863     0.200
     3.893    15.311     0.200
     3.950    14.855     0.200
     3.950    13.845     0.200
     4.057    14.614     0.200
     4.098    15.167     0.200
     4.542    15.607     0.200
     4.661    16.818     0.200
     4.854    17.635     0.200
     5.061    16.785     0.200
     5.219    17.746     0.200
     6.018    17.694     0.200
     7.119    19.313     0.200
     1.777    10.224     0.200
     1.849    10.049     0.200
     2.075    11.712     0.200
     2.109    10.833     0.200
     2.196    11.158     0.200
     2.263    11.917     0.200
     2.318    12.100     0.200
     2.343    11.351     0.200
     2.373    12.057     0.200
     2.902    12.595     0.200
     2.902    11.375     0.200
     3.075    12.615     0.200
     3.090    12.520     0.200
     3.196    13.120     0.200
     3.196    12.811     0.200
     3.283    13.088     0.200
     3.373    13.709     0.200
     3.398    14.566     0.200
     3.495    15.040     0.200
     3.495    14.321     0.200
     3.571    13.673     0.200
     3.845    14.360     0.200
     3.892    15.357     0.200
     3.967    15.038     0.200
     4.070    15.805     0.200
     4.070    14.485     0.200
     4.121    15.126     0.200
     4.331    16.744     0.200
     4.523    16.029     0.200
     4.565    16.402     0.200
     4.664    16.863     0.200
     4.878    18.391     0.200
     5.194    17.398     0.200
     5.194    17.277     0.200
     5.458    18.143     0.200
     5.615    20.613     0.200
     5.712    20.638     0.200
     6.000    19.344     0.200
     6.336    20.321     0.200
     6.886    22.663     0.200
     7.144    19.948     0.200
     7.590    22.917     0.200
     8.482    25.336     0.200
     8.514    24.675     0.200
     8.560    23.755     0.200
     8.560    23.514     0.200
    11.210    29.511     0.200
    12.169    29.774     0.200
    12.174    30.570     0.200
    12.174    30.464     0.200
     2.036    11.422     0.200
     2.062    12.587     0.200
     2.084    11.933     0.200
     2.182    11.645     0.200
     2.224    12.959     0.200
     2.258    12.401     0.200
     2.303    11.864     0.200
     2.337    12.063     0.200
     2.361    11.687     0.200
     2.388    12.355     0.200
     2.534    12.870     0.200
     2.585    13.179     0.200
     2.741    12.818     0.200
     2.749    12.266     0.200
     2.778    12.750     0.200
     3.133    14.119     0.200
     3.129    14.606     0.200
     3.129    15.547     0.200
     3.541    15.365     0.200
     3.653    15.351     0.200
     3.878    15.842     0.200
     3.878    16.243     0.200
     3.967    16.215     0.200
     4.155    15.595     0.200
     4.155    16.964     0.200
     4.287    16.802     0.200
     4.681    17.012     0.200
     4.997    18.255     0.200
     5.013    17.482     0.200
     2.043    11.633     0.200
     2.044    11.374     0.200
     2.145    11.448     0.200
     2.172    11.796     0.200
     2.318    11.927     0.200
     2.291    12.533     0.200
     2.398    13.296     0.200
     2.391    12.420     0.200
     2.525    12.861     0.200
     2.576    12.527     0.200
     2.933    13.104     0.200
     3.048    13.640     0.200
     3.048    13.259     0.200
     3.343    14.649     0.200
     3.369    13.618     0.200
     1.869    10.451     0.200
     2.335    12.035     0.200
     4.008    15.523     0.200
     1.631     9.433     0.200
     1.691     9.458     0.200
     1.724     9.640     0.200
     1.826    10.196     0.200
     1.849    10.116     0.200
     2.057    10.397     0.200
     2.085    10.749     0.200
     2.156    11.061     0.200
     2.172    11.098     0.200
     2.319    11.010     0.200
     2.410    11.558     0.200
     2.397    11.848     0.200
     2.397    12.067     0.200
     2.583    11.428     0.200
     2.820    13.057     0.200
     2.922    11.873     0.200
     2.922    12.998     0.200
     3.069    12.445     0.200
     3.069    12.937     0.200
     3.073    11.821     0.200
     3.067    11.904     0.200
     3.174    13.225     0.200
     3.174    12.990     0.200
     3.352    13.141     0.200
     3.387    13.985     0.200
     3.302    12.464     0.200
     3.434    14.049     0.200
     3.444    14.929     0.200
     3.717    14.432     0.200
     3.759    14.699     0.200
     3.895    15.665     0.200
     3.895    15.275     0.200
     4.026    15.107     0.200
     4.060    14.728     0.200
     4.101    14.404     0.200
     4.323    14.992     0.200
     4.361    15.375     0.200
     4.501    14.523     0.200
     4.544    15.765     0.200
     4.664    15.160     0.200
     4.804    16.383     0.200
     5.063    16.426     0.200
     5.701    17.609     0.200
     5.834    18.875     0.200
     5.893    18.583     0.200
     6.053    18.874     0.200
     6.321    19.340     0.200
     6.593    20.993     0.200
     6.614    20.653     0.200
     7.061    20.992     0.200
     7.120    20.141     0.200
     7.593    22.860     0.200
     8.291    22.797     0.200
     8.472    23.214     0.200
     1.851    10.314     0.200
     1.930    10.400     0.200
     1.933    10.705     0.200
     1.953    10.331     0.200
     1.950    10.666     0.200
     2.149    11.500     0.200
     2.184    12.102     0.200
     2.184    11.832     0.200
     2.177    11.047     0.200
     2.172    11.622     0.200
     2.271    11.662     0.200
     2.280    11.810     0.200
     2.330    11.832     0.200
     2.330    11.655     0.200
     2.422    11.983     0.200
     2.508    12.180     0.200
     2.535    12.374     0.200
     2.557    13.059     0.200
     2.557    12.604     0.200
     2.630    13.419     0.200
     2.677    12.177     0.200
     2.700    12.321     0.200
     2.700    12.115     0.200
     2.797    12.553     0.200
     2.882    12.813     0.200
     2.946    13.698     0.200
     2.946    13.410     0.200
     3.183    13.976     0.200
     3.183    14.675     0.200
     3.173    13.028     0.200
     3.187    13.902     0.200
     3.187    13.451     0.200
     3.177    13.881     0.200
     3.291    13.401     0.200
     3.474    14.647     0.200
     3.474    14.158     0.200
     3.483    14.734     0.200
     3.483    14.228     0.200
     3.537    14.398     0.200
     3.554    15.075     0.200
     3.642    15.420     0.200
     3.843    15.850     0.200
     3.843    15.690     0.200
     3.982    16.151     0.200
     3.982    16.008     0.200
     4.080    16.525     0.200
     4.080    15.668     0.200
     4.136    15.771     0.200
     4.182    16.705     0.200
     4.223    15.888     0.200
     4.443    16.704     0.200
     4.443    16.917     0.200
     4.459    17.062     0.200
     4.618    16.995     0.200
     4.665    16.598     0.200
     4.665    16.442     0.200
     4.711    17.081     0.200
     4.711    16.917     0.200
     4.765    18.020     0.200
     4.765    17.217     0.200
     4.820    16.729     0.200
     4.820    16.438     0.200
     4.827    18.159     0.200
     4.924    17.849     0.200
     4.974    18.182     0.200
     5.159    18.046     0.200
     5.306    17.773     0.200
     5.569    19.683     0.200
     6.148    19.612     0.200
     6.231    19.880     0.200
     6.448    20.123     0.200
     6.862    21.048     0.200
     7.189    21.762     0.200
     7.355    21.607     0.200
     7.676    22.148     0.200
     7.696    22.532     0.200
     7.748    22.508     0.200
     8.006    24.227     0.200
     1.893    11.111     0.200
     2.375    12.423     0.200
     2.315    12.424     0.200
     2.463    13.078     0.200
     2.758    12.896     0.200
     4.016    16.304     0.200
     1.951    10.966     0.200
     1.965    11.822     0.200
     2.153    12.023     0.200
     2.153    12.136     0.200
     2.309    11.768     0.200
     2.437    12.555     0.200
     2.464    13.154     0.200
     2.565    12.516     0.200
     2.596    13.752     0.200
     2.724    12.890     0.200
     2.769    12.762     0.200
     2.769    12.342     0.200
     2.823    14.190     0.200
     2.919    13.192     0.200
     2.975    13.907     0.200
     2.975    13.686     0.200
     3.148    13.281     0.200
     3.222    13.579     0.200
     3.222    13.499     0.200
     3.226    13.908     0.200
     3.248    14.927     0.200
     3.303    13.689     0.200
     3.315    14.061     0.200
     3.500    13.581     0.200
     3.521    14.974     0.200
     3.521    14.544     0.200
     3.573    15.003     0.200
     3.657    15.591     0.200
     3.873    16.231     0.200
     3.921    17.808     0.200
     4.020    16.089     0.200
     4.020    16.372     0.200
     4.220    17.442     0.200
     4.220    17.242     0.200
     4.481    16.885     0.200
     4.481    17.413     0.200
     4.497    15.114     0.200
     4.490    16.569     0.200
     4.641    15.550     0.200
     4.689    17.526     0.200
     4.691    16.911     0.200
     4.742    17.187     0.200
     4.804    15.973     0.200
     5.085    16.744     0.200
     5.085    16.568     0.200
     5.085    17.398     0.200
     5.196    16.961     0.200
     5.863    18.495     0.200
     5.863    17.505     0.200
     7.190    20.277     0.200
     7.190    20.888     0.200
     7.704    22.327     0.200
     7.735    23.654     0.200
     7.771    23.571     0.200
     8.664    25.628     0.200
    12.150    30.625     0.200
     2.216    11.696     0.200
     2.308    11.936     0.200
     3.898    15.186     0.200
     5.127    16.721     0.200
     1.654     8.978     0.200
     1.663     9.569     0.200
     1.689     9.771     0.200
     1.751     9.517     0.200
     1.785     9.801     0.200
     1.738     9.979     0.200
     1.768    10.268     0.200
     1.805    10.382     0.200
     1.805    10.273     0.200
     1.873    10.214     0.200
     1.883    10.558     0.200
     1.886    10.868     0.200
     1.886    10.731     0.200
     1.896     9.879     0.200
     1.904    10.532     0.200
     2.101    10.902     0.200
     2.118    11.731     0.200
     2.118    11.324     0.200
     2.137    10.915     0.200
     2.217    11.387     0.200
     2.226    11.130     0.200
     2.226    10.867     0.200
     2.265    11.508     0.200
     2.265    11.821     0.200
     2.359    12.630     0.200
     2.359    11.817     0.200
     2.359    11.618     0.200
     2.353    12.608     0.200
     2.375    11.314     0.200
     2.471    11.962     0.200
     2.471    11.373     0.200
     2.471    11.241     0.200
     2.489    12.342     0.200
     2.489    12.014     0.200
     2.583    10.997     0.200
     2.626    11.889     0.200
     2.643    11.717     0.200
     2.643    12.518     0.200
     2.761    12.905     0.200
     2.761    13.014     0.200
     2.813    12.267     0.200
     2.882    12.453     0.200
     2.882    13.047     0.200
     2.860    11.895     0.200
     2.860    12.126     0.200
     2.978    12.186     0.200
     3.117    12.869     0.200
     3.117    12.709     0.200
     3.120    12.476     0.200
     3.120    12.851     0.200
     3.124    11.982     0.200
     3.124    12.510     0.200
     3.234    12.087     0.200
     3.234    13.259     0.200
     3.221    14.165     0.200
     3.221    14.274     0.200
     3.241    12.634     0.200
     3.345    12.877     0.200
     3.345    13.076     0.200
     3.413    14.041     0.200
     3.413    14.213     0.200
     3.415    13.016     0.200
     3.415    13.703     0.200
     3.443    14.011     0.200
     3.490    12.604     0.200
     3.503    13.257     0.200
     3.539    14.233     0.200
     3.608    13.561     0.200
     3.638    14.933     0.200
     3.638    15.304     0.200
     3.778    15.325     0.200
     3.818    14.244     0.200
     3.818    13.877     0.200
     3.801    13.900     0.200
     3.855    15.808     0.200
     3.926    15.594     0.200
     3.926    15.723     0.200
     3.957    13.862     0.200
     4.012    14.934     0.200
     4.071    14.902     0.200
     4.071    15.097     0.200
     4.114    15.594     0.200
     4.162    15.244     0.200
     4.162    15.388     0.200
     4.326    16.080     0.200
     4.326    15.596     0.200
     4.357    15.973     0.200
     4.357    16.875     0.200
     4.375    15.138     0.200
     4.375    15.321     0.200
     4.391    15.722     0.200
     4.391    15.527     0.200
     4.419    15.250     0.200
     4.387    15.176     0.200
     4.387    14.957     0.200
     4.562    16.488     0.200
     4.562    16.843     0.200
     4.605    15.868     0.200
     4.605    16.247     0.200
     4.646    16.789     0.200
     4.646    16.027     0.200
     4.674    17.212     0.200
     4.753    16.270     0.200
     4.753    16.676     0.200
     4.760    16.954     0.200
     4.760    16.731     0.200
     4.865    16.430     0.200
     4.917    17.204     0.200
     4.969    15.697     0.200
     5.094    17.992     0.200
     5.094    17.512     0.200
     5.122    16.953     0.200
     5.122    17.187     0.200
     5.158    17.248     0.200
     5.158    17.408     0.200
     5.216    17.791     0.200
     5.238    16.831     0.200
     5.256    17.416     0.200
     5.256    18.553     0.200
     5.256    18.327     0.200
     5.333    16.830     0.200
     5.320    16.922     0.200
     5.320    17.215     0.200
     5.413    18.721     0.200
     5.435    18.135     0.200
     5.435    18.502     0.200
     5.500    18.679     0.200
     5.502    18.645     0.200
     5.554    18.291     0.200
     5.657    18.851     0.200
     5.657    18.050     0.200
     5.631    18.995     0.200
     5.631    18.534     0.200
     5.667    19.786     0.200
     5.757    17.993     0.200
     5.757    17.165     0.200
     5.794    17.638     0.200
     5.797    18.268     0.200
     5.806    17.931     0.200
     5.892    20.161     0.200
     5.945    18.259     0.200
     6.044    19.201     0.200
     6.044    19.080     0.200
     6.083    18.990     0.200
     6.083    19.259     0.200
     6.172    19.519     0.200
     6.167    19.924     0.200
     6.251    18.740     0.200
     6.280    20.721     0.200
     6.382    20.689     0.200
     6.555    20.268     0.200
     6.588    21.215     0.200
     6.654    20.959     0.200
     6.654    20.533     0.200
     6.674    20.083     0.200
     6.674    20.411     0.200
     6.754    20.846     0.200
     6.754    21.150     0.200
     6.749    20.644     0.200
     6.762    21.263     0.200
     6.761    20.271     0.200
     6.797    20.722     0.200
     6.797    20.011     0.200
     6.825    20.872     0.200
     6.842    21.590     0.200
     6.842    20.211     0.200
     6.853    22.192     0.200
     6.853    20.707     0.200
     6.920    21.202     0.200
     6.920    21.354     0.200
     6.872    19.224     0.200
     6.928    20.927     0.200
     7.085    20.834     0.200
     7.082    21.033     0.200
     7.120    21.868     0.200
     7.120    21.333     0.200
     7.258    20.861     0.200
     7.289    22.508     0.200
     7.289    21.821     0.200
     7.295    21.647     0.200
     7.289    21.157     0.200
     7.289    21.306     0.200
     7.427    21.284     0.200
     7.427    21.569     0.200
     7.436    21.858     0.200
     7.472    21.874     0.200
     7.612    21.285     0.200
     7.612    21.609     0.200
     7.630    23.844     0.200
     7.630    22.071     0.200
     7.637    22.418     0.200
     7.690    22.107     0.200
     7.690    22.849     0.200
     7.754    20.648     0.200
     7.754    20.957     0.200
     7.838    23.704     0.200
     7.874    22.619     0.200
     7.874    22.263     0.200
     7.941    22.252     0.200
     7.941    23.517     0.200
     7.938    22.959     0.200
     7.958    22.092     0.200
     7.970    23.409     0.200
     7.969    21.935     0.200
     7.969    23.564     0.200
     8.050    23.027     0.200
     8.115    23.672     0.200
     8.122    22.705     0.200
     8.122    23.049     0.200
     8.190    25.132     0.200
     8.190    23.929     0.200
     8.258    23.883     0.200
     8.352    22.367     0.200
     8.352    23.539     0.200
     8.419    24.287     0.200
     8.526    24.946     0.200
     8.526    24.188     0.200
     8.526    24.481     0.200
     8.484    24.690     0.200
     8.549    22.637     0.200
     8.586    24.096     0.200
     8.586    25.975     0.200
     8.619    24.161     0.200
     8.697    24.803     0.200
     8.827    24.154     0.200
     8.855    25.938     0.200
     9.088    25.002     0.200
     9.240    25.659     0.200
     9.359    25.645     0.200
     9.550    27.623     0.200
     9.556    25.961     0.200
     9.652    27.835     0.200
    10.043    27.253     0.200
    10.676    27.947     0.200
    11.293    28.994     0.200
    11.293    28.643     0.200
    12.161    30.005     0.200
    13.154    32.811     0.200
    17.587    39.667     0.200
     2.108    12.177     0.200
     2.270    13.313     0.200
     2.760    12.092     0.200
     3.186    13.016     0.200
     3.732    16.131     0.200
     3.871    16.375     0.200
     1.587     8.732     0.200
     1.635     9.064     0.200
     1.754    10.124     0.200
     1.766    10.154     0.200
     1.804    10.171     0.200
     2.099    11.233     0.200
     2.257    11.586     0.200
     2.257    11.324     0.200
     2.336    11.833     0.200
     2.336    11.599     0.200
     2.332    11.764     0.200
     2.332    11.663     0.200
     2.466    12.035     0.200
     2.466    11.840     0.200
     2.744    12.805     0.200
     2.790    11.764     0.200
     2.863    12.607     0.200
     3.018    13.413     0.200
     3.018    13.288     0.200
     3.097    13.012     0.200
     3.320    13.167     0.200
     3.351    12.450     0.200
     3.391    14.643     0.200
     3.396    13.673     0.200
     3.631    14.792     0.200
     3.800    15.357     0.200
     3.904    15.012     0.200
     4.667    16.956     0.200
     4.667    16.749     0.200
     1.639     8.604     0.200
     1.639     9.127     0.200
     1.667     9.788     0.200
     1.741     9.342     0.200
     1.749    10.104     0.200
     1.751     9.751     0.200
     1.769     9.928     0.200
     1.769    10.178     0.200
     1.798    10.019     0.200
     2.102    11.257     0.200
     2.203    10.623     0.200
     2.252    11.616     0.200
     2.252    11.370     0.200
     2.329    11.813     0.200
     2.336    11.650     0.200
     2.336    10.951     0.200
     2.456    11.279     0.200
     2.467    11.909     0.200
     2.467    11.776     0.200
     2.740    12.642     0.200
     2.740    12.349     0.200
     2.792    11.811     0.200
     2.867    12.076     0.200
     2.874    11.072     0.200
     2.984    11.575     0.200
     3.015    13.294     0.200
     3.256    12.683     0.200
     3.345    12.437     0.200
     3.345    12.765     0.200
     3.345    12.034     0.200
     3.401    13.628     0.200
     3.625    14.385     0.200
     3.763    13.891     0.200
     3.797    15.259     0.200
     3.902    14.818     0.200
     4.149    14.844     0.200
     4.661    16.839     0.200
     4.661    16.725     0.200
     4.889    15.579     0.200
     4.889    16.192     0.200
     5.166    17.586     0.200
     1.721     9.613     0.200
     1.790    10.306     0.200
     1.802    10.496     0.200
     2.054    11.438     0.200
     2.240    11.599     0.200
     2.240    11.334     0.200
     2.285    11.931     0.200
     2.412    12.059     0.200
     2.706    12.824     0.200
     2.706    12.691     0.200
     2.738    12.124     0.200
     2.821    12.700     0.200
     2.920    12.825     0.200
     2.971    13.527     0.200
     2.971    13.410     0.200
     3.014    12.238     0.200
     3.014    12.074     0.200
     3.042    13.342     0.200
     3.319    13.466     0.200
     3.359    13.544     0.200
     3.365    12.851     0.200
     3.365    12.749     0.200
     3.753    15.259     0.200
     3.753    15.400     0.200
     3.852    15.128     0.200
     4.651    16.995     0.200
     1.694     9.187     0.200
     1.713     9.378     0.200
     1.799     9.833     0.200
     2.046    11.392     0.200
     2.108    10.857     0.200
     2.150    11.014     0.200
     2.274    11.410     0.200
     2.242    11.598     0.200
     2.281    11.873     0.200
     2.280    11.488     0.200
     2.336    11.309     0.200
     2.401    11.409     0.200
     2.403    11.637     0.200
     2.729    12.102     0.200
     2.704    12.655     0.200
     2.704    12.444     0.200
     2.929    13.169     0.200
     2.929    11.608     0.200
     2.966    13.545     0.200
     3.031    12.656     0.200
     3.034    12.884     0.200
     3.034    12.413     0.200
     3.022    11.278     0.200
     3.080    12.715     0.200
     3.178    13.038     0.200
     3.178    12.458     0.200
     3.192    13.956     0.200
     3.192    13.366     0.200
     3.330    13.547     0.200
     3.350    13.294     0.200
     3.311    12.999     0.200
     3.323    13.483     0.200
     3.372    12.793     0.200
     3.372    12.233     0.200
     3.615    15.126     0.200
     3.749    15.600     0.200
     3.796    14.822     0.200
     3.796    15.091     0.200
     3.847    15.093     0.200
     3.847    14.783     0.200
     3.985    14.972     0.200
     3.985    14.411     0.200
     4.028    15.480     0.200
     4.289    15.471     0.200
     4.306    15.669     0.200
     4.619    16.371     0.200
     4.667    16.227     0.200
     4.653    16.980     0.200
     5.470    17.961     0.200
     6.084    19.456     0.200
     1.857    10.773     0.200
     1.937    10.525     0.200
     2.190    12.294     0.200
     2.264    12.214     0.200
     2.399    13.467     0.200
     2.399    13.364     0.200
     2.426    13.163     0.200
     2.561    13.477     0.200
     2.952    13.353     0.200
     3.084    15.210     0.200
     3.302    13.481     0.200
     3.480    14.328     0.200
     3.864    16.124     0.200
     3.864    16.599     0.200
     3.982    15.676     0.200
     3.982    16.362     0.200
     1.617     8.778     0.200
     1.666     9.203     0.200
     1.666     9.014     0.200
     1.675     9.384     0.200
     1.702     9.507     0.200
     1.764     9.782     0.200
     1.762    10.123     0.200
     1.762     9.985     0.200
     1.794    10.001     0.200
     1.886    10.216     0.200
     1.896    10.062     0.200
     1.909     9.831     0.200
     1.899    10.168     0.200
     1.917     9.874     0.200
     2.130    11.297     0.200
     2.130    11.139     0.200
     2.149    10.492     0.200
     2.229    10.898     0.200
     2.239    10.495     0.200
     2.213    11.089     0.200
     2.257    11.290     0.200
     2.257    11.509     0.200
     2.353    11.620     0.200
     2.388    10.840     0.200
     2.483    11.328     0.200
     2.497    11.123     0.200
     2.497    12.543     0.200
     2.757    12.328     0.200
     2.757    12.199     0.200
     2.822    11.758     0.200
     2.822    11.865     0.200
     2.766    11.952     0.200
     2.766    12.759     0.200
     2.894    12.127     0.200
     2.894    12.478     0.200
     2.848    10.990     0.200
     2.848    11.301     0.200
     2.965    11.801     0.200
     3.038    13.351     0.200
     3.038    13.166     0.200
     3.127    13.564     0.200
     3.127    12.992     0.200
     3.213    13.341     0.200
     3.174    12.104     0.200
     3.229    11.977     0.200
     3.310    13.093     0.200
     3.333    12.443     0.200
     3.426    13.651     0.200
     3.630    14.520     0.200
     3.630    14.687     0.200
     3.790    13.937     0.200
     3.790    15.134     0.200
     3.820    15.212     0.200
     3.853    14.045     0.200
     3.853    15.506     0.200
     3.863    13.735     0.200
     3.970    13.742     0.200
     4.077    14.403     0.200
     4.077    14.580     0.200
     4.174    14.856     0.200
     4.383    16.117     0.200
     4.677    17.228     0.200
     4.665    16.499     0.200
     4.665    16.776     0.200
     4.761    17.200     0.200
     5.246    18.151     0.200
     5.287    18.834     0.200
     5.287    19.023     0.200
     5.321    18.047     0.200
     5.321    18.211     0.200
     5.321    18.717     0.200
     5.441    18.096     0.200
     5.559    18.338     0.200
     5.559    18.736     0.200
     6.138    19.763     0.200
     6.138    19.538     0.200
     6.172    19.211     0.200
     7.008    20.758     0.200
     1.817    10.953     0.200
     1.839    10.400     0.200
     1.921    10.848     0.200
     1.920    10.812     0.200
     1.924    10.947     0.200
     1.942    11.141     0.200
     2.181    11.601     0.200
     2.173    11.833     0.200
     2.268    12.420     0.200
     2.269    11.439     0.200
     2.334    12.052     0.200
     2.391    12.801     0.200
     2.391    12.235     0.200
     2.391    13.492     0.200
     2.413    11.541     0.200
     2.524    12.418     0.200
     2.545    13.085     0.200
     2.545    12.741     0.200
     2.545    13.663     0.200
     2.720    12.614     0.200
     2.808    12.543     0.200
     2.808    12.414     0.200
     2.787    13.443     0.200
     2.787    13.932     0.200
     2.869    12.908     0.200
     2.869    13.556     0.200
     2.939    12.816     0.200
     2.934    13.194     0.200
     2.937    13.860     0.200
     3.031    14.193     0.200
     3.076    14.341     0.200
     3.076    14.705     0.200
     3.132    13.668     0.200
     3.132    13.477     0.200
     3.188    14.090     0.200
     3.165    13.259     0.200
     3.165    12.384     0.200
     3.171    14.067     0.200
     3.175    14.115     0.200
     3.175    14.244     0.200
     3.227    14.169     0.200
     3.227    14.509     0.200
     3.227    14.821     0.200
     3.306    13.895     0.200
     3.315    12.743     0.200
     3.315    13.204     0.200
     3.315    12.872     0.200
     3.282    13.080     0.200
     3.282    13.677     0.200
     3.463    14.692     0.200
     3.471    14.237     0.200
     3.471    14.827     0.200
     3.545    13.259     0.200
     3.665    14.356     0.200
     3.665    16.173     0.200
     3.640    15.327     0.200
     3.744    17.400     0.200
     3.832    14.832     0.200
     3.832    14.723     0.200
     3.831    15.918     0.200
     3.857    16.031     0.200
     3.857    16.410     0.200
     3.862    13.887     0.200
     3.883    15.204     0.200
     3.972    16.531     0.200
     3.991    14.966     0.200
     3.991    15.157     0.200
     4.068    14.708     0.200
     4.068    15.013     0.200
     4.125    15.530     0.200
     4.125    16.299     0.200
     4.125    15.120     0.200
     4.212    15.607     0.200
     4.349    15.699     0.200
     4.349    15.301     0.200
     4.376    15.283     0.200
     4.376    16.111     0.200
     4.398    15.654     0.200
     4.431    16.689     0.200
     4.462    15.934     0.200
     4.609    17.147     0.200
     4.674    17.642     0.200
     4.655    16.291     0.200
     4.712    17.911     0.200
     4.712    18.360     0.200
     4.700    16.804     0.200
     4.829    17.251     0.200
     4.829    16.680     0.200
     4.808    16.821     0.200
     4.808    17.864     0.200
     4.815    16.477     0.200
     4.815    17.360     0.200
     4.964    19.289     0.200
     5.114    17.602     0.200
     5.114    16.715     0.200
     5.147    18.279     0.200
     5.166    16.404     0.200
     5.166    17.568     0.200
     5.270    18.526     0.200
     5.299    19.119     0.200
     5.299    18.623     0.200
     5.299    19.670     0.200
     5.294    17.875     0.200
     5.294    18.313     0.200
     5.324    19.258     0.200
     5.324    20.012     0.200
     5.365    19.803     0.200
     5.365    19.107     0.200
     5.365    19.662     0.200
     5.373    17.421     0.200
     5.488    19.325     0.200
     5.488    19.430     0.200
     5.557    18.671     0.200
     5.557    18.476     0.200
     5.605    19.201     0.200
     5.605    19.396     0.200
     5.605    19.900     0.200
     5.664    18.302     0.200
     5.750    17.071     0.200
     5.698    20.192     0.200
     5.707    19.909     0.200
     5.813    17.536     0.200
     5.813    19.196     0.200
     5.949    19.283     0.200
     5.984    18.825     0.200
     6.099    19.507     0.200
     6.099    20.620     0.200
     6.137    19.677     0.200
     6.137    20.657     0.200
     6.172    19.699     0.200
     6.172    21.378     0.200
     6.172    22.449     0.200
     6.217    19.576     0.200
     6.217    21.209     0.200
     6.221    18.915     0.200
     6.294    18.036     0.200
     6.336    20.439     0.200
     6.345    20.223     0.200
     6.345    21.801     0.200
     6.405    21.129     0.200
     6.437    19.979     0.200
     6.592    20.423     0.200
     6.592    21.911     0.200
     6.706    21.228     0.200
     6.706    22.048     0.200
     6.730    20.810     0.200
     6.730    21.669     0.200
     6.787    20.702     0.200
     6.788    21.608     0.200
     6.799    22.083     0.200
     6.799    21.900     0.200
     6.810    22.014     0.200
     6.850    22.741     0.200
     6.862    19.263     0.200
     6.889    22.457     0.200
     6.909    20.816     0.200
     6.955    22.820     0.200
     7.047    22.994     0.200
     7.139    23.037     0.200
     7.320    21.802     0.200
     7.320    22.478     0.200
     7.313    22.867     0.200
     7.345    22.098     0.200
     7.345    22.707     0.200
     7.468    22.132     0.200
     7.483    23.154     0.200
     7.527    23.178     0.200
     7.665    21.989     0.200
     7.665    23.082     0.200
     7.690    23.793     0.200
     7.686    23.412     0.200
     7.737    23.379     0.200
     7.773    20.647     0.200
     7.773    22.385     0.200
     7.890    24.333     0.200
     7.910    22.228     0.200
     7.910    23.763     0.200
     7.992    22.489     0.200
     7.992    24.368     0.200
     7.995    23.191     0.200
     7.995    24.246     0.200
     8.001    22.271     0.200
     8.001    24.822     0.200
     8.079    22.424     0.200
     8.164    23.704     0.200
     8.188    24.682     0.200
     8.246    24.710     0.200
     8.313    24.736     0.200
     8.402    23.422     0.200
     8.528    25.094     0.200
     8.595    24.592     0.200
     8.622    23.901     0.200
     8.639    26.791     0.200
     8.837    23.939     0.200
     8.837    25.087     0.200
     8.865    26.274     0.200
     8.910    25.936     0.200
     8.910    26.647     0.200
     8.999    27.470     0.200
     9.122    27.297     0.200
     9.401    25.718     0.200
     1.672     9.651     0.200
     1.732     9.877     0.200
     1.758     9.900     0.200
     1.759    10.263     0.200
     1.757    10.120     0.200
     1.757     9.934     0.200
     1.789    10.327     0.200
     1.793     9.937     0.200
     1.880    10.275     0.200
     1.903     9.839     0.200
     2.110    10.584     0.200
     2.122    11.357     0.200
     2.122    11.089     0.200
     2.147    10.694     0.200
     2.222    11.380     0.200
     2.253    11.436     0.200
     2.343    11.325     0.200
     2.343    11.205     0.200
     2.344    11.646     0.200
     2.384    11.284     0.200
     2.476    11.362     0.200
     2.488    11.792     0.200
     2.592    11.919     0.200
     2.634    11.316     0.200
     2.650    11.299     0.200
     2.650    11.692     0.200
     2.750    12.186     0.200
     2.750    12.406     0.200
     2.750    12.298     0.200
     2.813    11.604     0.200
     2.813    11.717     0.200
     2.886    12.711     0.200
     3.030    13.187     0.200
     3.030    13.317     0.200
     3.114    12.114     0.200
     3.118    13.722     0.200
     3.210    13.739     0.200
     3.309    12.966     0.200
     3.309    13.136     0.200
     3.335    12.645     0.200
     3.335    12.215     0.200
     3.419    13.735     0.200
     3.414    13.323     0.200
     3.414    13.985     0.200
     3.443    14.483     0.200
     3.511    14.645     0.200
     3.627    14.772     0.200
     3.627    14.652     0.200
     3.782    14.683     0.200
     3.811    14.875     0.200
     3.811    15.255     0.200
     3.846    15.297     0.200
     3.846    14.979     0.200
     3.868    14.982     0.200
     3.920    14.721     0.200
     4.068    14.653     0.200
     4.068    14.512     0.200
     4.168    15.289     0.200
     4.373    15.997     0.200
     4.569    15.869     0.200
     4.662    16.778     0.200
     4.662    16.596     0.200
     4.669    17.318     0.200
     4.669    17.217     0.200
     4.751    17.010     0.200
     5.249    17.922     0.200
     5.249    18.862     0.200
     5.279    18.776     0.200
     5.279    18.896     0.200
     5.312    17.823     0.200
     5.312    18.563     0.200
     5.432    17.637     0.200
     5.549    18.696     0.200
     6.104    19.286     0.200
     6.104    19.058     0.200
     6.131    19.899     0.200
     6.162    19.499     0.200
     7.175    21.412     0.200
     1.873    11.341     0.200
     1.945    10.466     0.200
     1.880    11.331     0.200
     2.055    11.943     0.200
     2.069    10.232     0.200
     2.090    12.648     0.200
     2.090    12.097     0.200
     2.092    12.345     0.200
     2.132    12.115     0.200
     2.130    12.000     0.200
     2.130    12.203     0.200
     2.236    12.919     0.200
     2.311    11.827     0.200
     2.336    12.576     0.200
     2.325    12.080     0.200
     2.340    12.520     0.200
     2.477    12.435     0.200
     2.477    12.605     0.200
     2.538    12.512     0.200
     2.538    12.717     0.200
     2.538    12.797     0.200
     2.533    13.322     0.200
     2.533    13.642     0.200
     2.560    12.174     0.200
     2.580    12.659     0.200
     2.580    13.487     0.200
     2.723    13.498     0.200
     2.723    13.800     0.200
     2.777    13.792     0.200
     2.777    13.193     0.200
     2.852    13.599     0.200
     2.856    13.632     0.200
     3.064    13.142     0.200
     3.008    14.523     0.200
     3.032    13.485     0.200
     3.032    13.735     0.200
     3.065    14.425     0.200
     3.065    14.265     0.200
     3.054    13.063     0.200
     3.054    13.479     0.200
     3.054    13.772     0.200
     3.127    13.156     0.200
     3.170    13.020     0.200
     3.170    15.102     0.200
     3.280    14.703     0.200
     3.259    13.955     0.200
     3.259    14.129     0.200
     3.259    13.676     0.200
     3.362    14.247     0.200
     3.362    13.604     0.200
     3.362    13.417     0.200
     3.428    13.886     0.200
     3.443    12.425     0.200
     3.499    15.832     0.200
     3.561    15.796     0.200
     3.611    16.081     0.200
     3.611    15.788     0.200
     3.654    15.813     0.200
     3.654    15.619     0.200
     3.736    14.991     0.200
     3.803    15.945     0.200
     3.936    14.884     0.200
     3.936    15.089     0.200
     4.022    16.306     0.200
     4.022    16.158     0.200
     3.978    15.751     0.200
     4.121    16.485     0.200
     4.121    16.192     0.200
     4.342    16.468     0.200
     4.425    17.408     0.200
     4.425    17.775     0.200
     4.453    16.590     0.200
     4.453    16.805     0.200
     4.474    16.881     0.200
     4.475    16.744     0.200
     4.491    16.478     0.200
     4.491    16.896     0.200
     4.740    17.042     0.200
     4.802    16.538     0.200
     4.988    18.184     0.200
     4.987    18.984     0.200
     4.987    19.406     0.200
     5.035    18.366     0.200
     5.031    18.737     0.200
     5.031    18.956     0.200
     5.045    18.983     0.200
     5.167    20.178     0.200
     5.281    20.057     0.200
     5.276    17.553     0.200
     5.310    18.794     0.200
     5.516    17.595     0.200
     5.516    17.464     0.200
     5.612    18.345     0.200
     5.607    20.254     0.200
     5.706    17.663     0.200
     5.841    19.874     0.200
     5.894    20.823     0.200
     5.894    21.112     0.200
     5.932    18.857     0.200
     5.992    19.911     0.200
     6.728    21.420     0.200
     6.745    22.251     0.200
     6.745    21.620     0.200
     6.777    21.241     0.200
     6.785    22.261     0.200
     6.930    22.736     0.200
     7.209    21.455     0.200
     7.287    22.784     0.200
     7.761    22.596     0.200
     7.997    24.895     0.200
     8.305    23.571     0.200
     1.734    10.021     0.200
     1.735     9.780     0.200
     1.835    10.100     0.200
     2.068    11.065     0.200
     2.296    11.414     0.200
     2.297    11.874     0.200
     2.357    11.799     0.200
     2.427    11.985     0.200
     2.606    11.607     0.200
     2.715    12.070     0.200
     2.715    12.590     0.200
     2.753    11.967     0.200
     2.834    12.551     0.200
     2.982    13.429     0.200
     2.982    13.690     0.200
     3.006    11.841     0.200
     3.006    11.458     0.200
     3.057    13.170     0.200
     3.317    13.515     0.200
     3.370    13.426     0.200
     3.765    15.242     0.200
     3.765    15.417     0.200
     3.866    14.948     0.200
     3.866    15.052     0.200
     4.008    14.764     0.200
     4.625    17.196     0.200
     4.625    17.389     0.200
     5.233    19.149     0.200
     5.257    18.628     0.200
     1.837    11.505     0.200
     1.837    12.091     0.200
     2.297    13.118     0.200
     2.354    12.787     0.200
     2.354    13.315     0.200
     2.354    13.281     0.200
     2.354    13.456     0.200
     2.404    13.271     0.200
     2.404    13.462     0.200
     2.476    12.587     0.200
     2.476    13.216     0.200
     2.507    12.095     0.200
     2.711    13.565     0.200
     2.752    13.581     0.200
     2.797    14.514     0.200
     3.038    15.109     0.200
     3.048    13.818     0.200
     3.279    14.097     0.200
     3.302    14.604     0.200
     3.436    14.907     0.200
     3.823    17.094     0.200
     3.899    16.164     0.200
     4.006    16.348     0.200
     4.689    19.232     0.200
     5.284    19.541     0.200
     5.293    19.920     0.200
     6.091    20.994     0.200
     7.194    23.113     0.200
     1.842    11.434     0.200
     2.204    12.435     0.200
     2.204    12.553     0.200
     2.312    11.906     0.200
     2.402    12.653     0.200
     2.402    13.091     0.200
     2.572    13.862     0.200
     2.690    12.926     0.200
     2.721    12.579     0.200
     2.776    13.731     0.200
     2.790    13.238     0.200
     2.790    13.582     0.200
     3.087    14.735     0.200
     3.287    13.893     0.200
     3.867    16.227     0.200
     3.988    16.292     0.200
     4.721    18.794     0.200
     5.334    20.450     0.200
     5.383    20.042     0.200
     6.178    22.009     0.200
     1.693     9.954     0.200
     1.733     9.352     0.200
     1.741     9.518     0.200
     1.854    10.647     0.200
     1.869    10.384     0.200
     1.887    10.030     0.200
     1.887    10.546     0.200
     1.926    10.000     0.200
     1.975    11.337     0.200
     1.991    11.387     0.200
     2.015    10.527     0.200
     2.054    11.434     0.200
     2.077    10.971     0.200
     2.116    11.350     0.200
     2.156    10.626     0.200
     2.255    11.645     0.200
     2.255    11.528     0.200
     2.255    10.685     0.200
     2.411    12.062     0.200
     2.411    12.429     0.200
     2.474    10.992     0.200
     2.474    10.336     0.200
     2.500    11.906     0.200
     2.561    12.197     0.200
     2.581    12.369     0.200
     2.581    11.440     0.200
     2.651    11.981     0.200
     2.758    11.941     0.200
     2.771    11.704     0.200
     2.803    11.977     0.200
     2.860    12.284     0.200
     2.901    12.551     0.200
     2.902    12.877     0.200
     2.958    12.295     0.200
     3.190    12.251     0.200
     3.245    13.253     0.200
     3.245    14.175     0.200
     3.247    12.785     0.200
     3.247    13.332     0.200
     3.260    13.068     0.200
     3.260    14.021     0.200
     3.260    14.247     0.200
     3.406    13.046     0.200
     3.422    13.627     0.200
     3.685    14.177     0.200
     4.019    15.640     0.200
     4.169    16.570     0.200
     4.169    15.812     0.200
     4.436    14.980     0.200
     4.616    15.129     0.200
     4.675    16.165     0.200
     4.675    16.876     0.200
     4.861    18.213     0.200
     4.971    15.823     0.200
     5.130    16.449     0.200
     5.481    19.534     0.200
     5.920    18.252     0.200
     2.246    12.855     0.200
     2.246    12.706     0.200
     2.306    13.100     0.200
     2.287    12.986     0.200
     2.476    12.693     0.200
     2.447    13.135     0.200
     2.447    11.736     0.200
     2.699    14.592     0.200
     2.698    14.064     0.200
     2.930    14.417     0.200
     3.715    16.063     0.200
     4.583    18.847     0.200
     1.606     9.274     0.200
     1.603     9.134     0.200
     1.646     8.860     0.200
     1.653     8.454     0.200
     1.705     9.999     0.200
     1.770     8.840     0.200
     1.794     8.800     0.200
     1.802    10.166     0.200
     1.815    10.093     0.200
     1.830    10.480     0.200
     1.830    10.183     0.200
     1.836    10.237     0.200
     1.852    10.712     0.200
     1.852     9.911     0.200
     1.852     9.693     0.200
     1.985    10.780     0.200
     1.985    10.667     0.200
     2.083    11.088     0.200
     2.094    10.363     0.200
     2.161    10.944     0.200
     2.226    12.049     0.200
     2.226    11.697     0.200
     2.226    11.877     0.200
     2.230    11.728     0.200
     2.230    11.838     0.200
     2.303    11.314     0.200
     2.334    12.194     0.200
     2.334    11.827     0.200
     2.334    12.014     0.200
     2.344    11.420     0.200
     2.327    11.351     0.200
     2.327    11.171     0.200
     2.381    11.571     0.200
     2.381    11.392     0.200
     2.423    11.231     0.200
     2.423    11.059     0.200
     2.508    11.540     0.200
     2.540    11.702     0.200
     2.540    11.386     0.200
     2.541    11.326     0.200
     2.661    12.156     0.200
     2.661    11.863     0.200
     2.663    12.833     0.200
     2.663    12.501     0.200
     2.663    12.693     0.200
     2.744    12.557     0.200
     2.755    12.731     0.200
     2.755    12.368     0.200
     2.755    12.481     0.200
     2.911    13.164     0.200
     2.911    13.508     0.200
     2.911    13.676     0.200
     2.961    13.042     0.200
     2.965    12.681     0.200
     2.965    12.470     0.200
     2.926    12.734     0.200
     2.926    13.148     0.200
     2.988    11.264     0.200
     2.988    10.983     0.200
     3.043    12.272     0.200
     3.043    12.088     0.200
     3.062    12.059     0.200
     3.062    11.692     0.200
     3.173    14.208     0.200
     3.173    14.028     0.200
     3.260    14.240     0.200
     3.260    14.122     0.200
     3.260    14.001     0.200
     3.298    13.426     0.200
     3.331    13.521     0.200
     3.331    13.626     0.200
     3.317    12.952     0.200
     3.371    12.770     0.200
     3.371    12.199     0.200
     3.414    13.263     0.200
     3.415    11.553     0.200
     3.399    12.947     0.200
     3.399    12.822     0.200
     3.399    12.600     0.200
     3.649    14.420     0.200
     3.649    14.713     0.200
     3.695    15.478     0.200
     3.695    15.611     0.200
     3.726    13.583     0.200
     3.726    13.970     0.200
     3.784    15.230     0.200
     3.866    14.603     0.200
     3.896    13.669     0.200
     3.917    14.823     0.200
     3.917    15.034     0.200
     3.959    14.398     0.200
     3.959    14.167     0.200
     3.952    15.293     0.200
     3.952    14.543     0.200
     3.952    14.695     0.200
     3.973    14.270     0.200
     3.973    14.129     0.200
     3.973    13.828     0.200
     4.044    15.160     0.200
     4.044    14.886     0.200
     4.211    15.038     0.200
     4.220    15.368     0.200
     4.220    15.731     0.200
     4.223    16.354     0.200
     4.223    16.463     0.200
     4.330    15.310     0.200
     4.458    14.702     0.200
     4.458    15.694     0.200
     4.492    15.654     0.200
     4.492    15.181     0.200
     4.465    15.211     0.200
     4.465    15.110     0.200
     4.515    15.486     0.200
     4.515    15.658     0.200
     4.552    16.517     0.200
     4.552    16.747     0.200
     4.559    17.264     0.200
     4.559    17.088     0.200
     4.598    16.364     0.200
     4.598    16.469     0.200
     4.621    16.418     0.200
     4.621    16.184     0.200
     4.754    16.096     0.200
     4.810    16.477     0.200
     4.810    16.613     0.200
     4.962    16.915     0.200
     4.992    16.779     0.200
     5.029    15.918     0.200
     5.083    17.505     0.200
     5.083    16.915     0.200
     5.119    17.737     0.200
     5.119    18.217     0.200
     5.165    18.879     0.200
     5.165    18.395     0.200
     5.165    18.688     0.200
     5.173    17.854     0.200
     5.173    17.577     0.200
     5.173    17.733     0.200
     5.280    18.147     0.200
     5.280    17.913     0.200
     5.280    18.268     0.200
     5.255    16.219     0.200
     5.255    17.153     0.200
     5.305    17.498     0.200
     5.305    17.209     0.200
     5.403    18.750     0.200
     5.403    18.324     0.200
     5.403    17.582     0.200
     5.537    19.149     0.200
     5.551    18.055     0.200
     5.551    18.821     0.200
     5.604    16.259     0.200
     5.604    17.337     0.200
     5.888    16.420     0.200
     5.889    18.033     0.200
     5.973    19.383     0.200
     5.973    19.113     0.200
     6.004    19.192     0.200
     6.004    18.676     0.200
     6.017    19.426     0.200
     6.075    19.757     0.200
     6.141    17.812     0.200
     6.248    20.443     0.200
     6.535    20.810     0.200
     6.606    21.433     0.200
     6.667    21.758     0.200
     6.679    19.852     0.200
     6.736    20.891     0.200
     6.736    20.372     0.200
     6.857    20.408     0.200
     6.879    21.147     0.200
     6.879    20.811     0.200
     6.928    21.479     0.200
     6.951    20.645     0.200
     7.065    20.928     0.200
     7.065    21.315     0.200
     7.065    21.428     0.200
     7.103    21.150     0.200
     7.140    20.926     0.200
     7.140    20.309     0.200
     7.181    20.643     0.200
     7.240    21.257     0.200
     7.240    21.413     0.200
     7.316    21.724     0.200
     7.316    22.318     0.200
     7.331    21.262     0.200
     7.331    21.551     0.200
     7.483    22.713     0.200
     7.487    22.157     0.200
     7.487    22.313     0.200
     7.581    22.402     0.200
     7.581    22.187     0.200
     7.684    23.658     0.200
     7.684    23.443     0.200
     7.738    20.453     0.200
     7.783    23.290     0.200
     7.783    23.591     0.200
     7.807    21.922     0.200
     7.807    23.110     0.200
     8.102    23.942     0.200
     8.102    25.044     0.200
     8.123    23.540     0.200
     8.342    23.449     0.200
     8.345    22.391     0.200
     8.345    24.157     0.200
     8.550    25.558     0.200
     8.558    24.296     0.200
     8.699    25.840     0.200
     8.699    26.102     0.200
     8.759    23.779     0.200
     8.911    25.866     0.200
     9.001    24.864     0.200
     9.239    24.321     0.200
     9.394    26.319     0.200
     1.608     9.143     0.200
     1.751    10.031     0.200
     1.803     9.765     0.200
     1.814    10.275     0.200
     1.884    10.422     0.200
     1.864    10.144     0.200
     1.864    10.519     0.200
     1.969    10.314     0.200
     2.008    10.263     0.200
     2.031    10.486     0.200
     2.111    10.587     0.200
     2.111    10.935     0.200
     2.205    10.503     0.200
     2.216    10.414     0.200
     2.287    10.817     0.200
     2.287    11.693     0.200
     2.326    11.650     0.200
     2.375    11.517     0.200
     2.336    11.526     0.200
     2.473    11.347     0.200
     2.540    10.807     0.200
     2.540    11.357     0.200
     2.516    11.726     0.200
     2.516    12.108     0.200
     2.591    11.200     0.200
     2.591    11.383     0.200
     2.633    11.700     0.200
     2.684    12.404     0.200
     2.683    10.970     0.200
     2.683    12.039     0.200
     2.777    11.604     0.200
     2.892    12.063     0.200
     2.892    12.854     0.200
     2.885    11.765     0.200
     2.885    11.605     0.200
     3.002    11.732     0.200
     3.002    12.433     0.200
     3.042    12.912     0.200
     3.042    13.148     0.200
     3.026    12.525     0.200
     3.201    13.623     0.200
     3.231    12.812     0.200
     3.311    12.531     0.200
     3.315    12.319     0.200
     3.315    12.749     0.200
     3.292    13.879     0.200
     3.292    14.114     0.200
     3.290    12.375     0.200
     3.290    12.140     0.200
     3.321    13.208     0.200
     3.560    13.411     0.200
     3.560    13.582     0.200
     3.544    14.506     0.200
     3.617    14.171     0.200
     3.607    13.031     0.200
     3.633    13.748     0.200
     3.695    14.716     0.200
     3.695    14.877     0.200
     3.763    13.929     0.200
     3.763    14.039     0.200
     3.936    13.829     0.200
     3.936    15.004     0.200
     3.941    14.332     0.200
     3.941    15.857     0.200
     3.980    16.043     0.200
     3.980    15.732     0.200
     3.991    16.264     0.200
     4.037    13.999     0.200
     4.106    15.679     0.200
     4.106    15.383     0.200
     4.265    15.090     0.200
     4.265    14.892     0.200
     4.311    15.134     0.200
     4.298    14.858     0.200
     4.298    14.571     0.200
     4.533    15.995     0.200
     4.568    15.586     0.200
     4.568    16.990     0.200
     4.582    15.421     0.200
     4.749    15.540     0.200
     4.741    15.698     0.200
     4.811    16.551     0.200
     4.831    17.379     0.200
     4.831    17.930     0.200
     4.892    16.697     0.200
     4.935    17.855     0.200
     4.948    16.390     0.200
     4.948    16.684     0.200
     5.241    18.335     0.200
     5.446    19.171     0.200
     5.446    19.341     0.200
     5.501    18.405     0.200
     5.629    18.313     0.200
     6.286    19.739     0.200
     6.285    18.970     0.200
     6.285    20.151     0.200
     7.193    20.206     0.200
     7.173    21.422     0.200
     7.353    21.184     0.200
     7.337    20.890     0.200
     7.337    22.025     0.200
     7.438    21.837     0.200
     7.825    22.213     0.200
     8.108    23.463     0.200
     8.667    25.188     0.200
     1.811    10.599     0.200
     1.912    10.627     0.200
     2.170    11.384     0.200
     2.289    12.273     0.200
     2.352    11.946     0.200
     2.409    12.424     0.200
     2.552    12.635     0.200
     2.682    12.495     0.200
     2.718    12.693     0.200
     2.807    12.781     0.200
     2.930    12.847     0.200
     3.094    13.530     0.200
     3.457    13.908     0.200
     3.875    16.537     0.200
     3.987    16.031     0.200
     4.731    18.338     0.200
     5.343    20.164     0.200
     1.771     9.175     0.200
     1.810    10.299     0.200
     1.810    10.444     0.200
     1.827     9.282     0.200
     1.864    10.461     0.200
     1.864    10.631     0.200
     1.892    10.463     0.200
     1.892    10.656     0.200
     1.963    10.263     0.200
     1.964    10.680     0.200
     2.017     9.941     0.200
     2.296    11.649     0.200
     2.296    12.448     0.200
     2.324    11.867     0.200
     2.324    11.588     0.200
     2.331    11.612     0.200
     2.520    12.705     0.200
     2.786    11.300     0.200
     3.051    13.333     0.200
     3.205    14.331     0.200
     3.205    13.274     0.200
     3.984    16.026     0.200
     4.112    16.184     0.200
     4.721    17.058     0.200
     4.834    17.898     0.200
     5.449    19.927     0.200
     7.340    22.125     0.200
     1.809    10.320     0.200
     1.860    10.608     0.200
     2.290    10.858     0.200
     2.332    11.194     0.200
     3.199    14.263     0.200
     3.977    16.001     0.200
     4.105    16.251     0.200
     4.828    18.072     0.200
     5.443    19.636     0.200
     7.334    22.658     0.200
     1.765     8.992     0.200
     1.754     9.660     0.200
     1.812    10.243     0.200
     1.812    10.444     0.200
     1.806     9.664     0.200
     1.821     9.638     0.200
     1.821     9.468     0.200
     1.864    10.358     0.200
     1.864    10.678     0.200
     1.886    10.591     0.200
     1.893     9.729     0.200
     1.958    10.751     0.200
     1.957    10.690     0.200
     1.957    10.309     0.200
     1.972    10.322     0.200
     1.972    10.452     0.200
     1.997     9.963     0.200
     2.004    10.497     0.200
     2.012    10.441     0.200
     2.034     9.993     0.200
     2.108    10.716     0.200
     2.108    10.923     0.200
     2.219    11.333     0.200
     2.290    11.207     0.200
     2.290    11.506     0.200
     2.290    11.313     0.200
     2.324    11.519     0.200
     2.324    11.839     0.200
     2.324    12.009     0.200
     2.321    11.668     0.200
     2.334    11.607     0.200
     2.378    11.087     0.200
     2.517    12.331     0.200
     2.517    12.222     0.200
     2.517    12.091     0.200
     2.555    13.043     0.200
     2.543    11.617     0.200
     2.543    11.379     0.200
     2.589    11.798     0.200
     2.589    11.470     0.200
     2.636    11.230     0.200
     2.685    12.197     0.200
     2.703    11.855     0.200
     2.703    11.665     0.200
     2.741    11.637     0.200
     2.780    11.678     0.200
     2.892    12.818     0.200
     2.892    13.180     0.200
     2.892    12.990     0.200
     2.882    11.795     0.200
     2.882    11.964     0.200
     3.005    12.136     0.200
     3.005    12.427     0.200
     3.005    12.308     0.200
     3.023    12.886     0.200
     3.023    12.114     0.200
     3.023    12.333     0.200
     3.045    12.881     0.200
     3.045    13.231     0.200
     3.045    13.026     0.200
     3.080    12.951     0.200
     3.202    13.629     0.200
     3.202    13.738     0.200
     3.234    13.013     0.200
     3.234    12.869     0.200
     3.291    13.928     0.200
     3.291    14.297     0.200
     3.287    12.521     0.200
     3.287    12.142     0.200
     3.319    13.467     0.200
     3.319    13.118     0.200
     3.371    12.994     0.200
     3.563    13.658     0.200
     3.609    13.996     0.200
     3.591    13.457     0.200
     3.694    14.516     0.200
     3.694    15.227     0.200
     3.694    14.694     0.200
     3.760    14.470     0.200
     3.944    15.272     0.200
     3.939    14.856     0.200
     3.939    15.038     0.200
     3.981    15.801     0.200
     3.981    15.910     0.200
     3.991    16.157     0.200
     3.991    16.020     0.200
     4.040    14.100     0.200
     4.108    15.539     0.200
     4.108    15.385     0.200
     4.267    15.063     0.200
     4.295    14.756     0.200
     4.314    15.073     0.200
     4.314    15.177     0.200
     4.475    15.500     0.200
     4.536    15.767     0.200
     4.571    15.324     0.200
     4.584    17.075     0.200
     4.722    16.794     0.200
     4.722    17.075     0.200
     4.752    16.482     0.200
     4.814    16.571     0.200
     4.831    17.598     0.200
     4.894    17.101     0.200
     4.950    16.150     0.200
     4.950    16.318     0.200
     5.040    16.205     0.200
     5.244    18.071     0.200
     5.262    17.768     0.200
     5.446    19.259     0.200
     5.446    19.700     0.200
     5.446    18.970     0.200
     5.437    17.362     0.200
     5.503    18.150     0.200
     5.503    20.041     0.200
     5.631    18.567     0.200
     5.657    18.490     0.200
     6.254    20.365     0.200
     6.255    19.749     0.200
     6.286    21.012     0.200
     6.286    20.802     0.200
     6.287    20.651     0.200
     6.287    20.176     0.200
     7.173    22.191     0.200
     7.173    21.558     0.200
     7.337    22.090     0.200
     7.828    23.313     0.200
     7.828    23.837     0.200
     7.829    23.436     0.200
     7.897    23.853     0.200
     8.111    24.123     0.200
     1.891    11.036     0.200
     1.936    10.055     0.200
     1.953    10.953     0.200
     2.039    10.402     0.200
     2.087    11.240     0.200
     2.230    11.877     0.200
     2.264    11.435     0.200
     2.291    10.919     0.200
     2.302    11.413     0.200
     2.347    11.387     0.200
     2.436    11.645     0.200
     2.458    11.241     0.200
     2.458    12.329     0.200
     2.471    11.927     0.200
     2.475    11.108     0.200
     2.475    12.114     0.200
     2.702    13.253     0.200
     2.717    13.333     0.200
     2.949    13.772     0.200
     2.956    12.642     0.200
     3.238    14.479     0.200
     3.345    13.593     0.200
     3.473    13.755     0.200
     3.597    14.193     0.200
     3.734    16.569     0.200
     3.806    15.521     0.200
     3.822    13.840     0.200
     3.986    14.678     0.200
     4.589    14.968     0.200
     5.147    18.093     0.200
     5.191    19.310     0.200
     5.279    19.937     0.200
     5.319    18.930     0.200
     5.486    18.288     0.200
     5.579    17.813     0.200
     5.900    18.316     0.200
     5.999    19.737     0.200
     6.073    19.584     0.200
     6.106    19.708     0.200
     1.713     9.280     0.200
     1.794    10.799     0.200
     1.829    10.898     0.200
     1.846    10.732     0.200
     2.179    11.340     0.200
     2.340    11.720     0.200
     2.405    12.312     0.200
     2.693    11.932     0.200
     2.801    13.215     0.200
     2.801    12.610     0.200
     3.091    13.760     0.200
     3.239    14.590     0.200
     3.871    15.980     0.200
     3.871    15.759     0.200
     4.684    17.380     0.200
     4.727    17.990     0.200
     4.727    17.762     0.200
     5.339    19.409     0.200
     1.678     9.249     0.200
     1.850    10.928     0.200
     2.208    11.127     0.200
     2.389    11.993     0.200
     2.422    12.638     0.200
     2.518    12.034     0.200
     2.523    12.403     0.200
     2.523    13.192     0.200
     2.958    12.823     0.200
     2.922    13.566     0.200
     3.209    14.272     0.200
     3.273    13.496     0.200
     3.990    15.884     0.200
     4.096    16.083     0.200
     4.847    17.198     0.200
     5.458    19.407     0.200
     5.487    19.353     0.200
     1.743    10.319     0.200
     1.795    10.514     0.200
     1.872    10.226     0.200
     1.924    11.237     0.200
     1.928    10.290     0.200
     1.984    10.209     0.200
     2.009    10.852     0.200
     2.057    11.369     0.200
     2.098    11.642     0.200
     2.098    11.403     0.200
     2.119    10.700     0.200
     2.128    11.193     0.200
     2.129    11.062     0.200
     2.151    10.141     0.200
     2.216    11.529     0.200
     2.216    11.849     0.200
     2.216    11.638     0.200
     2.235    11.122     0.200
     2.235    12.082     0.200
     2.235    11.640     0.200
     2.332    10.746     0.200
     2.345    11.423     0.200
     2.391    11.947     0.200
     2.391    12.107     0.200
     2.446    12.215     0.200
     2.485    12.470     0.200
     2.502    12.443     0.200
     2.502    12.894     0.200
     2.593    11.829     0.200
     2.593    12.059     0.200
     2.601    11.771     0.200
     2.669    12.534     0.200
     2.746    13.714     0.200
     2.741    12.205     0.200
     2.756    11.541     0.200
     2.756    12.248     0.200
     2.811    13.380     0.200
     2.845    13.773     0.200
     2.845    13.353     0.200
     2.845    13.017     0.200
     2.898    12.598     0.200
     2.916    10.989     0.200
     2.971    13.268     0.200
     3.151    13.741     0.200
     3.151    13.432     0.200
     3.151    13.192     0.200
     3.155    14.838     0.200
     3.163    12.406     0.200
     3.163    12.986     0.200
     3.185    14.430     0.200
     3.185    14.201     0.200
     3.185    14.658     0.200
     3.205    13.177     0.200
     3.205    14.457     0.200
     3.205    15.000     0.200
     3.360    13.262     0.200
     3.358    13.259     0.200
     3.489    14.179     0.200
     3.636    14.341     0.200
     3.636    14.591     0.200
     3.677    14.365     0.200
     3.676    14.009     0.200
     3.676    14.755     0.200
     3.716    14.779     0.200
     3.742    15.850     0.200
     3.812    15.617     0.200
     3.947    16.996     0.200
     3.960    16.123     0.200
     3.960    15.723     0.200
     3.960    16.551     0.200
     4.048    14.679     0.200
     4.048    16.340     0.200
     4.061    14.164     0.200
     4.061    15.978     0.200
     4.113    16.216     0.200
     4.113    16.503     0.200
     4.170    15.056     0.200
     4.166    14.608     0.200
     4.307    15.835     0.200
     4.307    15.726     0.200
     4.426    16.363     0.200
     4.659    17.215     0.200
     4.801    17.813     0.200
     4.801    17.644     0.200
     4.801    18.124     0.200
     4.815    17.963     0.200
     4.918    18.096     0.200
     4.918    17.196     0.200
     4.918    17.886     0.200
     5.033    18.248     0.200
     5.124    18.617     0.200
     5.366    17.452     0.200
     5.366    19.262     0.200
     5.421    19.938     0.200
     5.421    19.423     0.200
     5.424    18.891     0.200
     5.513    19.033     0.200
     5.562    17.927     0.200
     5.670    18.890     0.200
     5.670    19.399     0.200
     5.775    19.002     0.200
     5.922    20.130     0.200
     6.146    19.266     0.200
     6.248    19.609     0.200
     6.283    19.983     0.200
     6.283    19.693     0.200
     6.283    20.568     0.200
     6.379    19.597     0.200
     6.921    21.657     0.200
     6.947    21.158     0.200
     6.986    23.042     0.200
     7.156    22.517     0.200
     7.307    22.746     0.200
     7.307    22.532     0.200
     7.319    20.716     0.200
     7.481    21.625     0.200
     7.689    22.485     0.200
     7.868    23.750     0.200
     8.064    24.252     0.200
     8.672    26.539     0.200
     9.004    24.519     0.200
     1.786     9.828     0.200
     1.809     9.318     0.200
     1.840    10.900     0.200
     1.828    10.794     0.200
     2.021    11.485     0.200
     2.026    10.971     0.200
     2.122    11.258     0.200
     2.294    12.624     0.200
     2.273    12.313     0.200
     2.311    11.460     0.200
     2.375    11.641     0.200
     2.393    12.046     0.200
     2.393    12.686     0.200
     2.400    12.099     0.200
     2.400    12.269     0.200
     2.556    11.850     0.200
     2.556    11.323     0.200
     2.713    11.837     0.200
     2.725    12.817     0.200
     2.725    13.046     0.200
     2.786    12.919     0.200
     2.979    13.907     0.200
     3.027    12.818     0.200
     3.321    13.848     0.200
     3.357    14.047     0.200
     3.406    13.564     0.200
     3.762    16.088     0.200
     3.852    14.610     0.200
     3.852    15.739     0.200
     4.619    17.724     0.200
     4.626    18.052     0.200
     4.659    17.040     0.200
     5.188    17.888     0.200
     5.232    19.544     0.200
     5.241    17.958     0.200
     6.041    19.352     0.200
     6.041    19.635     0.200
     7.131    21.487     0.200
     1.806     9.824     0.200
     1.809    10.281     0.200
     1.861    10.845     0.200
     1.962    11.146     0.200
     2.064    11.454     0.200
     2.328    12.807     0.200
     2.484    11.951     0.200
     2.817    11.626     0.200
     2.843    12.946     0.200
     3.088    13.936     0.200
     3.168    13.184     0.200
     4.085    15.184     0.200
     1.981    10.730     0.200
     1.981    11.402     0.200
     2.147    13.223     0.200
     2.146    12.561     0.200
     2.146    12.139     0.200
     2.155    12.095     0.200
     2.327    12.414     0.200
     2.327    13.289     0.200
     2.559    13.311     0.200
     2.580    13.186     0.200
     2.756    14.190     0.200
     2.756    14.573     0.200
     2.832    14.197     0.200
     2.912    14.361     0.200
     3.076    13.795     0.200
     3.035    12.864     0.200
     3.308    14.842     0.200
     3.615    15.892     0.200
     3.711    16.723     0.200
     3.859    15.983     0.200
     4.478    18.485     0.200
     5.084    19.637     0.200
     5.102    20.270     0.200
     1.825    10.153     0.200
     1.843    10.841     0.200
     1.876    10.181     0.200
     1.887    10.598     0.200
     1.882    11.118     0.200
     1.882    11.309     0.200
     1.964    10.679     0.200
     1.962    11.267     0.200
     1.962    11.607     0.200
     2.008    11.061     0.200
     2.008    11.381     0.200
     2.024    11.004     0.200
     2.079    10.907     0.200
     2.084    11.140     0.200
     2.107    11.313     0.200
     2.232    12.162     0.200
     2.232    11.912     0.200
     2.234    11.666     0.200
     2.234    11.869     0.200
     2.293    11.851     0.200
     2.310    11.994     0.200
     2.342    12.490     0.200
     2.383    11.205     0.200
     2.383    12.264     0.200
     2.438    12.299     0.200
     2.469    12.516     0.200
     2.469    13.059     0.200
     2.549    12.274     0.200
     2.549    12.875     0.200
     2.549    12.434     0.200
     2.549    11.598     0.200
     2.563    12.534     0.200
     2.556    12.419     0.200
     2.556    11.872     0.200
     2.636    11.983     0.200
     2.640    12.216     0.200
     2.640    11.447     0.200
     2.693    13.038     0.200
     2.697    13.364     0.200
     2.697    12.103     0.200
     2.772    13.108     0.200
     2.823    12.335     0.200
     2.823    12.613     0.200
     2.792    12.109     0.200
     2.792    11.899     0.200
     2.823    14.342     0.200
     2.823    13.280     0.200
     2.823    12.635     0.200
     2.854    12.257     0.200
     2.854    12.460     0.200
     2.963    13.309     0.200
     2.963    12.680     0.200
     3.031    13.040     0.200
     3.019    12.460     0.200
     3.103    13.612     0.200
     3.103    14.112     0.200
     3.103    13.499     0.200
     3.153    14.497     0.200
     3.153    14.215     0.200
     3.200    13.788     0.200
     3.200    14.467     0.200
     3.201    13.906     0.200
     3.201    14.366     0.200
     3.190    13.360     0.200
     3.190    12.599     0.200
     3.219    13.667     0.200
     3.219    13.546     0.200
     3.318    13.938     0.200
     3.318    13.527     0.200
     3.313    13.443     0.200
     3.318    13.322     0.200
     3.317    13.785     0.200
     3.317    13.484     0.200
     3.445    14.319     0.200
     3.497    14.658     0.200
     3.497    13.826     0.200
     3.582    14.046     0.200
     3.630    15.179     0.200
     3.630    14.738     0.200
     3.628    14.413     0.200
     3.600    15.594     0.200
     3.600    15.414     0.200
     3.600    15.109     0.200
     3.676    14.017     0.200
     3.676    13.794     0.200
     3.929    16.532     0.200
     3.929    16.169     0.200
     3.924    16.692     0.200
     4.000    16.045     0.200
     4.074    16.663     0.200
     4.074    16.471     0.200
     4.074    16.327     0.200
     4.131    14.908     0.200
     4.235    15.000     0.200
     4.235    14.430     0.200
     4.205    15.080     0.200
     4.205    14.811     0.200
     4.205    14.928     0.200
     4.261    15.903     0.200
     4.326    15.791     0.200
     4.326    17.369     0.200
     4.380    16.486     0.200
     4.380    15.893     0.200
     4.543    15.987     0.200
     4.583    17.436     0.200
     4.583    16.053     0.200
     4.618    16.337     0.200
     4.618    15.966     0.200
     4.664    16.267     0.200
     4.664    16.622     0.200
     4.771    17.486     0.200
     4.773    18.397     0.200
     4.773    17.980     0.200
     4.821    17.047     0.200
     4.869    17.208     0.200
     4.869    16.794     0.200
     4.953    17.414     0.200
     4.953    16.906     0.200
     5.096    17.383     0.200
     5.096    16.723     0.200
     5.277    17.207     0.200
     5.317    17.932     0.200
     5.325    17.941     0.200
     5.389    19.459     0.200
     5.391    19.680     0.200
     5.391    19.820     0.200
     5.439    18.496     0.200
     5.448    18.677     0.200
     5.473    19.138     0.200
     5.473    18.888     0.200
     5.524    18.048     0.200
     5.726    19.348     0.200
     5.727    19.783     0.200
     5.727    19.568     0.200
     5.860    20.079     0.200
     5.875    20.316     0.200
     5.875    19.980     0.200
     5.972    18.912     0.200
     5.972    18.732     0.200
     6.114    19.744     0.200
     6.223    21.184     0.200
     6.223    21.074     0.200
     6.223    20.414     0.200
     6.247    20.401     0.200
     6.247    20.280     0.200
     6.247    20.077     0.200
     6.306    20.959     0.200
     6.306    21.162     0.200
     6.327    20.563     0.200
     6.327    21.051     0.200
     6.337    20.866     0.200
     6.337    21.288     0.200
     6.741    21.021     0.200
     6.918    22.669     0.200
     6.951    21.114     0.200
     7.295    21.062     0.200
     7.279    22.108     0.200
     7.279    22.471     0.200
     7.778    23.289     0.200
     7.877    21.383     0.200
     8.020    24.424     0.200
     8.129    24.208     0.200
     8.279    24.412     0.200
     8.434    24.060     0.200
     8.607    25.223     0.200
     8.634    25.401     0.200
     8.697    24.402     0.200
     8.686    25.384     0.200
     8.759    25.608     0.200
     8.965    24.938     0.200
     9.306    27.436     0.200
     9.362    27.650     0.200
     9.751    29.436     0.200
     9.838    30.145     0.200
     9.846    29.868     0.200
    10.237    30.438     0.200
    10.494    28.885     0.200
    11.342    30.210     0.200
    12.059    30.847     0.200
     1.925     9.921     0.200
     1.926    10.839     0.200
     1.926    11.099     0.200
     1.928    11.304     0.200
     2.024    10.549     0.200
     2.223    11.648     0.200
     2.223    12.068     0.200
     2.278    11.394     0.200
     2.314    11.994     0.200
     2.296    12.483     0.200
     2.296    12.983     0.200
     2.329    12.286     0.200
     2.407    11.995     0.200
     2.341    12.307     0.200
     2.341    12.937     0.200
     2.445    11.793     0.200
     2.454    11.624     0.200
     2.493    11.993     0.200
     2.493    12.814     0.200
     2.637    13.257     0.200
     2.689    12.825     0.200
     2.689    13.285     0.200
     2.754    13.385     0.200
     2.754    14.025     0.200
     2.945    12.964     0.200
     2.970    12.759     0.200
     2.973    13.606     0.200
     2.973    13.407     0.200
     2.980    14.024     0.200
     2.980    14.734     0.200
     3.157    12.737     0.200
     3.283    15.404     0.200
     3.283    15.284     0.200
     3.444    14.849     0.200
     3.505    14.159     0.200
     3.505    13.999     0.200
     3.713    15.936     0.200
     3.832    16.230     0.200
     3.969    15.760     0.200
     3.946    15.537     0.200
     4.212    16.214     0.200
     4.674    17.121     0.200
     4.635    18.655     0.200
     4.635    18.245     0.200
     5.215    20.019     0.200
     5.294    19.527     0.200
     6.107    19.138     0.200
     6.943    21.409     0.200
     7.138    21.728     0.200
     1.708     9.595     0.200
     1.831     9.861     0.200
     1.854     9.318     0.200
     1.859    10.737     0.200
     1.814    10.418     0.200
     2.068    10.890     0.200
     2.068    11.281     0.200
     2.067    11.078     0.200
     2.110    11.377     0.200
     2.169    10.433     0.200
     2.307    11.762     0.200
     2.259    12.063     0.200
     2.259    11.836     0.200
     2.312    12.193     0.200
     2.312    12.349     0.200
     2.422    10.920     0.200
     2.435    11.518     0.200
     2.435    12.268     0.200
     2.369    12.147     0.200
     2.369    11.803     0.200
     2.446    11.840     0.200
     2.550    11.877     0.200
     2.601    11.208     0.200
     2.601    11.872     0.200
     2.758    12.357     0.200
     2.758    12.208     0.200
     2.732    12.864     0.200
     2.833    12.267     0.200
     2.833    12.822     0.200
     2.831    13.428     0.200
     2.831    13.248     0.200
     2.998    13.703     0.200
     2.998    13.890     0.200
     3.063    11.894     0.200
     3.067    12.776     0.200
     3.089    12.796     0.200
     3.013    11.848     0.200
     3.013    11.973     0.200
     3.192    12.583     0.200
     3.211    13.595     0.200
     3.211    13.946     0.200
     3.360    13.338     0.200
     3.360    13.823     0.200
     3.368    13.637     0.200
     3.368    14.020     0.200
     3.235    13.037     0.200
     3.388    13.386     0.200
     3.331    13.601     0.200
     3.331    13.703     0.200
     3.370    12.970     0.200
     3.370    12.634     0.200
     3.457    12.743     0.200
     3.729    14.244     0.200
     3.729    14.424     0.200
     3.781    15.920     0.200
     3.781    16.037     0.200
     3.825    15.071     0.200
     3.880    15.522     0.200
     3.880    15.702     0.200
     3.773    16.394     0.200
     3.958    13.921     0.200
     3.928    13.944     0.200
     3.928    14.498     0.200
     3.855    15.128     0.200
     3.915    13.679     0.200
     3.915    14.077     0.200
     4.059    14.303     0.200
     4.116    14.681     0.200
     4.116    15.134     0.200
     4.281    15.767     0.200
     4.320    15.701     0.200
     4.320    15.287     0.200
     4.313    16.630     0.200
     4.313    16.896     0.200
     4.336    15.001     0.200
     4.520    14.896     0.200
     4.520    15.505     0.200
     4.420    15.030     0.200
     4.420    15.171     0.200
     4.560    15.732     0.200
     4.597    16.178     0.200
     4.641    17.846     0.200
     4.708    16.619     0.200
     4.669    17.292     0.200
     4.669    17.120     0.200
     5.044    18.103     0.200
     5.166    17.184     0.200
     5.166    18.074     0.200
     5.183    17.048     0.200
     5.183    18.103     0.200
     5.212    17.249     0.200
     5.249    19.077     0.200
     5.249    19.304     0.200
     5.270    18.685     0.200
     5.270    18.240     0.200
     5.299    17.096     0.200
     5.382    18.341     0.200
     5.450    19.404     0.200
     5.610    18.892     0.200
     5.610    19.204     0.200
     5.702    18.256     0.200
     5.702    16.521     0.200
     5.838    20.879     0.200
     5.919    19.134     0.200
     5.989    17.864     0.200
     6.032    19.866     0.200
     6.032    20.273     0.200
     6.070    19.369     0.200
     6.070    19.776     0.200
     6.106    19.834     0.200
     6.106    20.146     0.200
     6.135    19.409     0.200
     6.332    19.514     0.200
     6.377    20.232     0.200
     6.566    20.267     0.200
     6.607    21.049     0.200
     6.622    21.146     0.200
     6.700    20.315     0.200
     6.739    20.212     0.200
     6.799    21.230     0.200
     6.794    20.713     0.200
     6.891    20.197     0.200
     6.967    20.688     0.200
     7.147    19.419     0.200
     7.147    20.700     0.200
     7.265    22.370     0.200
     7.417    21.834     0.200
     7.444    22.380     0.200
     7.584    22.732     0.200
     7.740    20.537     0.200
     7.842    21.809     0.200
     7.941    21.783     0.200
     8.366    23.983     0.200
     8.438    24.143     0.200
     8.548    23.992     0.200
     8.644    23.964     0.200
     8.737    23.701     0.200
     8.801    24.305     0.200
     1.714     9.641     0.200
     1.739     9.895     0.200
     1.748     9.928     0.200
     1.777    10.447     0.200
     1.777    10.189     0.200
     1.809    10.276     0.200
     1.836     9.719     0.200
     1.859     9.246     0.200
     2.073    10.757     0.200
     2.073    11.436     0.200
     2.174    10.452     0.200
     2.254    11.989     0.200
     2.261    11.165     0.200
     2.312    11.314     0.200
     2.312    12.368     0.200
     2.364    11.234     0.200
     2.364    11.992     0.200
     2.427    10.996     0.200
     2.437    10.946     0.200
     2.555    12.264     0.200
     2.607    11.848     0.200
     2.607    11.621     0.200
     2.729    12.118     0.200
     2.729    13.056     0.200
     2.762    12.636     0.200
     2.835    13.886     0.200
     2.838    13.037     0.200
     2.827    12.175     0.200
     2.904    12.583     0.200
     2.929    14.141     0.200
     2.997    14.049     0.200
     3.007    12.750     0.200
     3.065    11.408     0.200
     3.069    11.766     0.200
     3.069    13.898     0.200
     3.095    13.066     0.200
     3.207    13.025     0.200
     3.363    13.911     0.200
     3.364    12.880     0.200
     3.364    13.146     0.200
     3.373    13.670     0.200
     3.373    13.935     0.200
     3.392    14.745     0.200
     3.779    15.878     0.200
     3.880    15.621     0.200
     4.640    17.886     0.200
     5.248    19.575     0.200
     1.470     7.900     0.200
     1.539     8.738     0.200
     1.625     9.101     0.200
     1.688     9.358     0.200
     1.823     9.220     0.200
     1.823     9.329     0.200
     1.877     9.624     0.200
     1.906     9.674     0.200
     1.906    10.596     0.200
     1.956     9.545     0.200
     1.984     9.845     0.200
     2.011    10.341     0.200
     2.011    10.239     0.200
     2.098     9.991     0.200
     2.277    10.173     0.200
     2.273    10.500     0.200
     2.268    10.308     0.200
     2.344    11.018     0.200
     2.344    10.315     0.200
     2.436    10.985     0.200
     2.506    11.327     0.200
     2.506    10.913     0.200
     2.544    11.823     0.200
     2.613    10.967     0.200
     2.643    11.080     0.200
     2.693    10.932     0.200
     2.716    10.856     0.200
     2.755    11.394     0.200
     2.809    11.686     0.200
     2.845    11.507     0.200
     2.812    11.595     0.200
     3.102    12.240     0.200
     3.190    12.750     0.200
     3.190    12.648     0.200
     3.218    12.627     0.200
     3.337    11.788     0.200
     3.624    13.689     0.200
     3.660    14.101     0.200
     3.687    14.898     0.200
     4.006    14.430     0.200
     4.108    14.764     0.200
     4.110    14.313     0.200
     4.375    15.124     0.200
     4.666    15.750     0.200
     4.812    16.400     0.200
     5.757    17.297     0.200
     6.262    19.934     0.200
     6.282    19.345     0.200
     7.318    21.257     0.200
     1.779    10.067     0.200
     1.860    10.638     0.200
     1.920     9.874     0.200
     1.885    11.001     0.200
     2.025    11.950     0.200
     2.071    10.107     0.200
     2.042    11.642     0.200
     2.089    10.968     0.200
     2.185    10.798     0.200
     2.174    12.732     0.200
     2.323    10.883     0.200
     2.372    11.780     0.200
     2.387    11.355     0.200
     2.557    12.441     0.200
     2.752    12.377     0.200
     2.810    12.797     0.200
     2.783    12.923     0.200
     2.816    12.477     0.200
     2.864    12.397     0.200
     2.836    12.493     0.200
     2.919    13.156     0.200
     2.969    13.035     0.200
     2.950    13.621     0.200
     2.950    13.241     0.200
     2.956    13.673     0.200
     2.984    11.939     0.200
     3.012    12.516     0.200
     2.983    13.305     0.200
     3.206    13.429     0.200
     3.396    14.133     0.200
     3.396    14.243     0.200
     3.484    15.190     0.200
     3.539    14.903     0.200
     3.879    14.983     0.200
     5.045    18.309     0.200
     7.444    22.226     0.200
     1.795    10.615     0.200
     1.799    10.700     0.200
     2.128    11.794     0.200
     2.263    11.987     0.200
     2.357    12.296     0.200
     2.348    11.827     0.200
     3.219    14.675     0.200
     3.824    15.926     0.200
     3.932    15.650     0.200
     4.681    18.091     0.200
     5.292    19.827     0.200
     1.774     9.779     0.200
     1.782    10.537     0.200
     1.825     9.668     0.200
     1.841    10.702     0.200
     1.957    11.106     0.200
     2.291    11.883     0.200
     2.265    11.570     0.200
     3.131    12.897     0.200
     3.210    13.792     0.200
     3.909    15.234     0.200
     4.045    15.433     0.200
     4.279    15.617     0.200
     4.756    16.750     0.200
     6.220    19.634     0.200
     1.819     9.940     0.200
     1.819    10.018     0.200
     1.921    11.013     0.200
     1.937    10.226     0.200
     2.009    11.051     0.200
     2.182    10.468     0.200
     2.153    12.524     0.200
     2.351    10.750     0.200
     2.405    11.224     0.200
     2.479    12.963     0.200
     2.454    11.560     0.200
     2.785    13.621     0.200
     2.991    12.066     0.200
     3.147    13.669     0.200
     3.155    12.693     0.200
     3.292    14.069     0.200
     3.635    16.001     0.200
     3.743    15.541     0.200
     3.777    15.160     0.200
     3.890    14.391     0.200
     4.038    16.091     0.200
     4.055    16.260     0.200
     4.901    17.695     0.200
     5.237    19.558     0.200
     1.523     8.290     0.200
     1.593     8.739     0.200
     1.713     9.106     0.200
     1.934     9.333     0.200
     1.981    10.022     0.200
     2.070    10.515     0.200
     2.327     9.928     0.200
     2.390     9.827     0.200
     2.410    11.030     0.200
     2.417     9.991     0.200
     2.711    11.168     0.200
     3.009    11.797     0.200
     3.055    12.961     0.200
     3.331    13.073     0.200
     3.323    12.669     0.200
     5.658    18.291     0.200
     5.658    18.521     0.200
     1.745    10.040     0.200
     1.814     9.698     0.200
     1.854    10.331     0.200
     1.854     9.960     0.200
     1.934    10.186     0.200
     1.938    10.376     0.200
     1.955    10.435     0.200
     2.155    11.118     0.200
     2.183    10.781     0.200
     2.188    11.421     0.200
     2.187    11.869     0.200
     2.167    11.461     0.200
     2.284    11.389     0.200
     2.324    11.956     0.200
     2.324    11.753     0.200
     2.423    11.980     0.200
     2.516    11.474     0.200
     2.539    11.926     0.200
     2.558    12.325     0.200
     2.637    11.684     0.200
     2.682    11.577     0.200
     2.706    12.862     0.200
     2.793    12.765     0.200
     2.793    12.515     0.200
     2.883    12.718     0.200
     2.949    12.737     0.200
     3.179    12.358     0.200
     3.183    13.229     0.200
     3.187    12.845     0.200
     3.173    13.172     0.200
     3.296    12.810     0.200
     3.478    14.209     0.200
     3.484    14.225     0.200
     3.513    14.264     0.200
     3.542    14.147     0.200
     3.635    15.489     0.200
     3.650    15.520     0.200
     3.730    15.900     0.200
     3.886    15.929     0.200
     3.886    16.859     0.200
     3.980    15.659     0.200
     3.980    16.132     0.200
     4.183    15.197     0.200
     4.183    15.357     0.200
     4.227    15.674     0.200
     4.623    16.854     0.200
     4.668    16.851     0.200
     4.715    16.805     0.200
     4.820    16.671     0.200
     4.928    17.210     0.200
     5.100    18.129     0.200
     5.100    17.468     0.200
     5.162    17.245     0.200
     5.180    17.287     0.200
     5.305    17.791     0.200
     5.388    16.849     0.200
     5.571    18.255     0.200
     5.826    18.720     0.200
     5.826    17.048     0.200
     5.826    18.720     0.200
     6.178    19.451     0.200
     6.235    19.788     0.200
     6.808    20.751     0.200
     7.195    20.048     0.200
     7.195    19.439     0.200
     7.332    20.772     0.200
     7.482    21.924     0.200
     7.701    22.503     0.200
     8.010    22.661     0.200
     8.595    23.433     0.200
     8.626    23.576     0.200
     8.626    24.608     0.200
     8.768    24.825     0.200
     9.660    26.246     0.200
    10.303    27.790     0.200
    12.139    30.908     0.200
    12.195    31.780     0.200
     1.751     9.992     0.200
     1.820    10.250     0.200
     1.860     9.932     0.200
     1.944    10.039     0.200
     1.944    10.379     0.200
     1.941    10.359     0.200
     1.962    10.151     0.200
     1.962    10.401     0.200
     2.161    11.154     0.200
     2.194    12.084     0.200
     2.194    12.013     0.200
     2.291    11.570     0.200
     2.319    12.240     0.200
     2.319    12.041     0.200
     2.428    12.121     0.200
     2.545    12.159     0.200
     2.563    12.663     0.200
     2.688    11.721     0.200
     2.700    13.162     0.200
     2.787    12.611     0.200
     2.787    12.381     0.200
     2.956    13.161     0.200
     3.187    13.565     0.200
     3.191    13.001     0.200
     3.303    13.862     0.200
     3.484    14.108     0.200
     3.489    14.008     0.200
     3.982    16.037     0.200
     4.140    15.616     0.200
     4.188    15.485     0.200
     4.234    15.675     0.200
     4.630    17.653     0.200
     4.675    16.743     0.200
     4.721    16.698     0.200
     4.825    17.032     0.200
     4.935    17.160     0.200
     5.093    17.075     0.200
     5.832    19.049     0.200
     7.200    20.035     0.200
     8.627    24.863     0.200
    12.134    31.034     0.200
     1.918    10.607     0.200
     1.918     9.993     0.200
     1.929    10.720     0.200
     1.993    11.167     0.200
     2.020    10.620     0.200
     2.192    13.063     0.200
     2.272    11.827     0.200
     2.303    13.007     0.200
     2.335    11.654     0.200
     2.421    12.230     0.200
     2.409    12.385     0.200
     2.454    12.053     0.200
     2.471    12.468     0.200
     2.471    11.849     0.200
     2.617    12.967     0.200
     2.683    13.721     0.200
     2.941    13.769     0.200
     2.944    13.842     0.200
     2.955    12.424     0.200
     2.976    12.133     0.200
     3.059    12.727     0.200
     3.059    12.897     0.200
     3.220    14.286     0.200
     3.248    13.471     0.200
     3.385    14.114     0.200
     3.440    14.255     0.200
     3.796    16.171     0.200
     3.811    14.756     0.200
     3.800    14.820     0.200
     3.800    15.529     0.200
     3.923    15.033     0.200
     3.923    16.162     0.200
     3.967    15.583     0.200
     4.133    16.598     0.200
     4.187    16.237     0.200
     4.376    16.830     0.200
     4.412    16.292     0.200
     4.446    16.525     0.200
     4.674    17.426     0.200
     5.047    17.558     0.200
     5.339    18.347     0.200
     5.398    19.353     0.200
     5.720    19.566     0.200
     5.925    19.777     0.200
     7.501    22.791     0.200
     8.496    25.252     0.200
     1.517     8.788     0.200
     1.545     8.395     0.200
     1.633     9.038     0.200
     1.673     8.815     0.200
     1.682     9.095     0.200
     1.825     9.310     0.200
     1.825     9.630     0.200
     1.867     9.193     0.200
     1.881     9.746     0.200
     1.928    10.068     0.200
     1.928    10.588     0.200
     1.954     9.472     0.200
     2.016    10.735     0.200
     2.016    10.454     0.200
     2.030    10.535     0.200
     2.057    10.057     0.200
     2.073     9.875     0.200
     2.063    10.235     0.200
     2.048     9.717     0.200
     2.268    10.120     0.200
     2.291    10.405     0.200
     2.350    10.624     0.200
     2.350    10.830     0.200
     2.438    10.877     0.200
     2.595    11.602     0.200
     2.595    11.493     0.200
     2.533    11.812     0.200
     2.696    11.852     0.200
     2.642    10.693     0.200
     2.642    11.033     0.200
     2.733    11.643     0.200
     2.747    11.944     0.200
     2.801    11.712     0.200
     2.825    11.259     0.200
     3.105    13.011     0.200
     3.117    13.551     0.200
     3.211    13.903     0.200
     3.294    13.081     0.200
     3.361    14.133     0.200
     3.483    13.461     0.200
     3.624    13.903     0.200
     3.680    14.685     0.200
     3.999    14.800     0.200
     4.097    14.172     0.200
     4.134    14.544     0.200
     4.134    15.372     0.200
     4.596    15.442     0.200
     4.619    15.363     0.200
     4.694    15.736     0.200
     4.694    16.307     0.200
     4.874    15.816     0.200
     4.929    17.029     0.200
     4.995    15.818     0.200
     5.497    16.299     0.200
     2.085    11.688     0.200
     3.628    15.623     0.200
     4.445    17.705     0.200
     1.900    10.182     0.200
     1.899    10.299     0.200
     1.994    10.935     0.200
     2.005    10.102     0.200
     2.255    11.273     0.200
     2.276    11.617     0.200
     2.420    11.736     0.200
     2.466    11.751     0.200
     2.466    11.991     0.200
     2.667    12.985     0.200
     2.755    13.728     0.200
     2.950    12.505     0.200
     2.913    12.741     0.200
     2.916    13.245     0.200
     2.999    12.614     0.200
     3.038    12.346     0.200
     3.038    12.716     0.200
     3.075    12.377     0.200
     3.207    13.304     0.200
     3.155    12.701     0.200
     3.196    13.964     0.200
     3.223    13.887     0.200
     3.317    13.624     0.200
     3.413    12.905     0.200
     3.403    13.583     0.200
     3.457    13.776     0.200
     3.633    13.822     0.200
     3.664    14.685     0.200
     3.664    15.605     0.200
     3.806    13.916     0.200
     3.789    15.029     0.200
     3.767    15.514     0.200
     3.767    16.084     0.200
     3.900    14.246     0.200
     3.953    15.420     0.200
     3.943    15.286     0.200
     4.160    16.343     0.200
     4.365    16.634     0.200
     4.519    17.773     0.200
     4.546    16.978     0.200
     4.662    16.631     0.200
     4.875    17.409     0.200
     4.999    17.091     0.200
     5.021    16.860     0.200
     5.163    16.434     0.200
     5.447    18.624     0.200
     5.481    17.406     0.200
     5.577    17.266     0.200
     5.542    18.525     0.200
     5.706    19.470     0.200
     5.913    19.519     0.200
     5.982    19.091     0.200
     6.580    20.075     0.200
     2.403    12.219     0.200
     2.947    12.572     0.200
     3.868    15.482     0.200
     4.635    16.519     0.200
     4.693    17.125     0.200
     2.042    10.918     0.200
     2.394    12.301     0.200
     4.688    16.970     0.200
     1.722     9.136     0.200
     1.722    10.104     0.200
     1.659     9.748     0.200
     1.780     9.272     0.200
     1.780     9.417     0.200
     1.780    10.296     0.200
     1.845     9.228     0.200
     1.880    10.376     0.200
     1.915    10.763     0.200
     1.943     9.798     0.200
     1.962    10.188     0.200
     2.161    11.410     0.200
     2.163    10.889     0.200
     2.252    11.317     0.200
     2.252    11.694     0.200
     2.334    11.164     0.200
     2.393    11.501     0.200
     2.486    11.347     0.200
     2.594    11.129     0.200
     2.632    11.534     0.200
     2.669    11.473     0.200
     2.687    12.052     0.200
     2.751    12.526     0.200
     2.751    11.959     0.200
     3.002    12.522     0.200
     2.940    11.662     0.200
     3.068    13.549     0.200
     3.179    12.218     0.200
     3.515    13.074     0.200
     3.535    14.008     0.200
     3.566    14.773     0.200
     3.745    14.631     0.200
     3.982    14.611     0.200
     4.117    15.190     0.200
     4.260    14.707     0.200
     4.482    14.653     0.200
     4.553    15.159     0.200
     4.772    16.337     0.200
     4.774    16.552     0.200
     4.959    17.571     0.200
     5.183    16.724     0.200
     1.477     8.263     0.200
     1.477     8.044     0.200
     1.526     8.663     0.200
     1.536     8.583     0.200
     1.535     8.478     0.200
     1.606     8.856     0.200
     1.712     9.061     0.200
     1.719     9.060     0.200
     1.724     9.039     0.200
     1.734     9.151     0.200
     1.934     9.515     0.200
     1.961     9.500     0.200
     1.888    10.019     0.200
     2.008    10.375     0.200
     2.007    10.482     0.200
     2.090     9.133     0.200
     2.295     9.644     0.200
     2.350    10.361     0.200
     2.416     9.466     0.200
     2.463    10.205     0.200
     2.385    11.434     0.200
     2.453    10.814     0.200
     2.534    11.085     0.200
     2.758    11.939     0.200
     2.861    11.882     0.200
     2.959    11.737     0.200
     3.085    12.405     0.200
     3.101    12.252     0.200
     3.101    11.245     0.200
     3.274    12.874     0.200
     3.321    13.112     0.200
     3.341    12.265     0.200
     3.382    12.404     0.200
     3.658    12.431     0.200
     3.782    12.308     0.200
     3.749    13.619     0.200
     3.822    14.238     0.200
     3.925    13.206     0.200
     3.973    14.893     0.200
     4.026    13.768     0.200
     4.065    14.372     0.200
     4.065    13.720     0.200
     4.258    13.581     0.200
     4.333    14.483     0.200
     4.335    14.101     0.200
     4.463    14.341     0.200
     4.528    15.108     0.200
     4.657    15.149     0.200
     4.841    16.655     0.200
     4.964    15.322     0.200
     5.167    15.258     0.200
     5.201    16.259     0.200
     5.396    17.266     0.200
     5.427    16.804     0.200
     5.455    15.926     0.200
     5.782    19.687     0.200
     5.856    15.991     0.200
     2.021    10.843     0.200
     2.063    11.501     0.200
     2.032    12.671     0.200
     2.384    13.340     0.200
     2.416    14.284     0.200
     2.794    12.660     0.200
     2.889    12.727     0.200
     2.948    13.317     0.200
     3.043    13.002     0.200
     3.059    11.720     0.200
     3.053    13.231     0.200
     3.326    14.181     0.200
     3.419    15.517     0.200
     3.883    16.266     0.200
     4.074    15.632     0.200
     4.007    15.631     0.200
     4.336    15.714     0.200
     4.476    16.652     0.200
     4.517    16.463     0.200
     4.674    17.167     0.200
     4.684    17.190     0.200
     5.129    17.765     0.200
     1.916    10.501     0.200
     1.921    10.555     0.200
     2.168    12.338     0.200
     2.185    12.449     0.200
     2.265    11.107     0.200
     2.334    12.650     0.200
     2.334    12.400     0.200
     2.406    13.436     0.200
     2.519    11.513     0.200
     2.539    11.928     0.200
     2.726    12.944     0.200
     2.813    12.981     0.200
     2.813    13.121     0.200
     2.930    14.008     0.200
     3.025    14.286     0.200
     3.162    13.641     0.200
     3.176    14.559     0.200
     3.459    14.582     0.200
     3.494    15.054     0.200
     3.526    13.275     0.200
     3.966    16.544     0.200
     3.966    16.044     0.200
     4.164    15.952     0.200
     4.208    16.677     0.200
     4.424    18.051     0.200
     4.441    15.779     0.200
     4.605    17.816     0.200
     4.650    17.562     0.200
     4.695    17.394     0.200
     4.747    19.266     0.200
     4.802    17.817     0.200
     4.910    18.220     0.200
     4.960    18.787     0.200
     5.163    17.821     0.200
     5.598    19.052     0.200
     3.165    13.724     0.200
     1.751     9.552     0.200
     1.801     9.682     0.200
     1.801     9.702     0.200
     1.894    10.199     0.200
     1.932    10.970     0.200
     1.932    10.720     0.200
     2.015    10.805     0.200
     2.088    10.998     0.200
     2.266    11.324     0.200
     2.265    11.416     0.200
     2.258    11.534     0.200
     2.262    11.006     0.200
     2.364    11.228     0.200
     2.619    12.347     0.200
     2.618    11.948     0.200
     2.635    13.129     0.200
     2.714    12.621     0.200
     2.714    11.355     0.200
     3.376    13.128     0.200
     3.558    13.540     0.200
     3.581    13.126     0.200
     3.576    14.695     0.200
     3.639    14.215     0.200
     4.011    15.289     0.200
     4.011    15.656     0.200
     4.247    16.998     0.200
     4.247    15.217     0.200
     4.307    15.976     0.200
     4.505    15.738     0.200
     4.749    16.353     0.200
     4.806    16.375     0.200
     4.806    17.335     0.200
     3.238    12.676     0.200
     1.759     9.617     0.200
     1.759     9.757     0.200
     1.808     9.708     0.200
     1.809     9.203     0.200
     1.810    10.294     0.200
     1.903    10.212     0.200
     1.939    10.432     0.200
     1.939    10.791     0.200
     2.023    10.551     0.200
     2.079    11.833     0.200
     2.273    10.863     0.200
     2.273    11.557     0.200
     2.267    10.954     0.200
     2.253    11.151     0.200
     2.371    11.458     0.200
     2.624    12.185     0.200
     2.626    12.203     0.200
     2.630    11.938     0.200
     2.706    13.149     0.200
     2.706    11.438     0.200
     2.839    11.462     0.200
     3.246    14.672     0.200
     3.566    13.407     0.200
     3.569    15.342     0.200
     4.012    15.299     0.200
     4.252    15.887     0.200
     4.252    14.731     0.200
     4.315    15.515     0.200
     4.808    16.079     0.200
     4.808    17.149     0.200
     5.017    16.779     0.200
     3.241    12.080     0.200
     1.999    10.898     0.200
     2.102    11.027     0.200
     2.122    10.204     0.200
     2.175    11.387     0.200
     2.129    12.675     0.200
     2.282    11.816     0.200
     2.364    11.089     0.200
     2.521    11.853     0.200
     2.587    12.281     0.200
     2.897    14.176     0.200
     2.960    12.580     0.200
     2.978    12.601     0.200
     3.114    13.141     0.200
     3.179    14.027     0.200
     3.217    12.858     0.200
     3.479    14.787     0.200
     3.882    14.083     0.200
     3.912    14.478     0.200
     4.528    16.100     0.200
    15.365    36.951     0.200
    15.423    40.060     0.200
    15.433    38.604     0.200
    15.576    38.278     0.200
    15.996    38.370     0.200
    16.205    38.462     0.200
    16.545    40.291     0.200
     1.256     9.513     0.200
     2.282    12.199     0.200
     2.282    12.340     0.200
     2.282    12.059     0.200
     2.978    13.015     0.200
     2.978    13.124     0.200
     3.988    15.840     0.200
     5.207    17.918     0.200
     5.471    18.242     0.200
     6.586    21.441     0.200
     6.702    23.893     0.200
     6.956    24.009     0.200
     7.247    23.305     0.200
     7.247    23.578     0.200
     7.862    25.133     0.200
     8.242    26.297     0.200
     8.322    27.174     0.200
     8.341    26.075     0.200
     8.341    25.653     0.200
     8.634    26.734     0.200
    10.359    30.292     0.200
    12.631    34.030     0.200
    12.937    36.498     0.200
    13.842    36.521     0.200
    13.933    38.383     0.200
    13.985    37.492     0.200
    15.365    39.295     0.200
    15.921    39.142     0.200
    15.996    38.534     0.200
    16.193    39.983     0.200
     1.926    10.666     0.200
     1.961    10.856     0.200
     2.726    14.207     0.200
     2.862    14.175     0.200
     3.166    13.197     0.200
     3.407    14.636     0.200
     3.774    15.783     0.200
     3.787    15.017     0.200
     3.768    14.843     0.200
     4.022    15.271     0.200
     4.011    15.666     0.200
     4.266    15.721     0.200
     4.573    16.379     0.200
     4.865    17.367     0.200
     5.029    16.071     0.200
     5.093    18.494     0.200
     5.379    17.701     0.200
     5.901    20.044     0.200
     6.190    20.547     0.200
     6.191    19.644     0.200
     6.622    22.492     0.200
     7.265    21.694     0.200
     7.366    22.110     0.200
     7.928    23.053     0.200
     8.421    24.274     0.200
     9.430    28.157     0.200
     9.529    28.614     0.200
    11.297    29.816     0.200
    12.714    32.271     0.200
    12.906    33.792     0.200
    15.332    39.410     0.200
    16.018    37.182     0.200
     7.265    21.904     0.200
     1.825    12.036     0.200
     1.881    11.639     0.200
     1.924    11.738     0.200
     2.001    11.921     0.200
     2.277    12.542     0.200
     2.367    12.655     0.200
     2.526    12.433     0.200
     2.591    12.884     0.200
     2.629    14.120     0.200
     3.118    13.020     0.200
     3.182    14.424     0.200
     3.216    15.232     0.200
     3.987    14.772     0.200
     3.911    16.620     0.200
     4.530    17.507     0.200
     4.989    17.000     0.200
     5.033    18.223     0.200
     6.586    20.828     0.200
     6.770    19.450     0.200
     7.337    22.875     0.200
    16.001    37.112     0.200
     1.935    11.440     0.200
     2.119    11.497     0.200
     2.190    11.713     0.200
     2.148    13.132     0.200
     2.385    13.068     0.200
     2.535    12.100     0.200
     2.603    12.603     0.200
     2.650    13.296     0.200
     3.131    13.507     0.200
     3.199    13.494     0.200
     3.238    14.922     0.200
     3.508    14.310     0.200
     3.998    14.617     0.200
     3.933    16.419     0.200
     4.187    16.545     0.200
     5.000    16.574     0.200
     5.843    21.830     0.200
     5.850    19.712     0.200
     6.145    21.059     0.200
     6.835    21.647     0.200
     7.259    22.357     0.200
     7.346    22.333     0.200
     8.276    23.969     0.200
     9.351    27.499     0.200
    10.255    28.633     0.200
    11.289    30.894     0.200
     1.957    11.766     0.200
     1.943    12.963     0.200
     2.054    12.154     0.200
     2.030    11.103     0.200
     2.405    12.040     0.200
     2.439    13.183     0.200
     2.420    13.291     0.200
     2.612    13.319     0.200
     3.011    14.549     0.200
     3.142    14.206     0.200
     3.340    13.807     0.200
     3.313    16.019     0.200
     3.495    13.523     0.200
     3.617    13.796     0.200
     3.533    15.216     0.200
     3.640    15.601     0.200
     3.708    15.747     0.200
     3.845    14.816     0.200
     3.881    15.383     0.200
     3.965    16.265     0.200
     4.323    16.545     0.200
     4.669    18.089     0.200
     4.830    18.079     0.200
     4.875    18.914     0.200
     5.155    18.386     0.200
     5.611    17.812     0.200
     5.625    20.572     0.200
     7.148    21.377     0.200
     7.201    22.290     0.200
     8.154    24.207     0.200
     9.395    26.782     0.200
    10.210    28.634     0.200
    10.560    29.107     0.200
    10.865    30.795     0.200
    15.885    38.493     0.200
     1.880    10.525     0.200
     1.931    11.512     0.200
     2.053    11.809     0.200
     2.156    11.632     0.200
     2.178    11.946     0.200
     2.227    11.751     0.200
     2.232    12.145     0.200
     2.419    12.884     0.200
     2.571    11.890     0.200
     2.641    12.377     0.200
     2.832    12.855     0.200
     3.168    13.290     0.200
     3.235    13.975     0.200
     3.260    15.146     0.200
     3.389    13.971     0.200
     4.035    14.776     0.200
     5.075    18.649     0.200
     6.538    20.258     0.200
     8.313    24.488     0.200
     8.456    24.011     0.200
     8.579    24.707     0.200
     9.625    26.617     0.200
    10.292    28.089     0.200
     2.005    11.886     0.200
     2.054    11.822     0.200
     2.138    12.247     0.200
     2.356    12.050     0.200
     2.394    11.776     0.200
     2.414    12.582     0.200
     2.457    12.855     0.200
     2.550    13.476     0.200
     2.614    14.746     0.200
     2.712    13.456     0.200
     2.913    13.828     0.200
     2.962    13.379     0.200
     3.010    14.595     0.200
     3.110    14.818     0.200
     3.172    14.664     0.200
     3.296    14.287     0.200
     3.272    14.962     0.200
     3.445    13.815     0.200
     3.539    14.184     0.200
     3.628    15.532     0.200
     3.709    15.908     0.200
     3.799    14.652     0.200
     3.851    16.498     0.200
     3.968    16.386     0.200
     3.988    16.222     0.200
     4.300    17.033     0.200
     4.307    18.496     0.200
     4.832    18.096     0.200
     4.908    18.516     0.200
     5.137    19.752     0.200
     5.899    20.775     0.200
     6.448    21.783     0.200
     6.732    19.419     0.200
     8.120    25.565     0.200
     9.143    28.479     0.200
     9.251    28.203     0.200
     1.930    11.119     0.200
     1.915    10.298     0.200
     2.023    11.685     0.200
     1.964    12.010     0.200
     2.037    12.310     0.200
     2.155    11.004     0.200
     2.373    11.929     0.200
     2.413    12.702     0.200
     2.426    13.654     0.200
     2.439    12.404     0.200
     2.609    14.781     0.200
     2.719    13.664     0.200
     2.932    12.980     0.200
     2.980    13.325     0.200
     3.021    14.721     0.200
     3.145    15.918     0.200
     3.160    15.693     0.200
     3.190    13.766     0.200
     3.314    13.635     0.200
     3.291    14.490     0.200
     3.596    14.371     0.200
     3.524    14.885     0.200
     3.562    15.544     0.200
     3.641    15.677     0.200
     3.719    16.078     0.200
     3.817    14.236     0.200
     3.868    15.781     0.200
     3.978    16.628     0.200
     4.039    15.973     0.200
     3.999    16.984     0.200
     4.113    16.211     0.200
     4.069    17.743     0.200
     4.091    16.932     0.200
     4.089    16.158     0.200
     4.202    16.006     0.200
     4.187    16.955     0.200
     4.305    15.480     0.200
     4.321    16.476     0.200
     4.316    16.619     0.200
     4.319    18.044     0.200
     4.407    17.399     0.200
     4.409    18.046     0.200
     4.421    17.828     0.200
     4.588    17.447     0.200
     4.652    18.473     0.200
     4.811    16.185     0.200
     4.892    18.305     0.200
     4.842    18.012     0.200
     4.906    18.845     0.200
     5.143    17.459     0.200
     5.114    18.151     0.200
     5.152    19.256     0.200
     5.354    20.098     0.200
     5.366    18.746     0.200
     5.512    19.004     0.200
     5.584    17.801     0.200
     5.544    18.964     0.200
     5.614    20.614     0.200
     5.646    20.398     0.200
     5.654    20.663     0.200
     5.781    19.214     0.200
     5.927    20.585     0.200
     5.912    20.583     0.200
     6.320    21.748     0.200
     6.345    21.705     0.200
     6.391    20.235     0.200
     6.409    21.334     0.200
     6.469    22.115     0.200
     6.588    20.743     0.200
     6.530    22.308     0.200
     6.793    22.376     0.200
     7.115    21.175     0.200
     7.172    22.330     0.200
     7.260    23.773     0.200
     7.242    23.410     0.200
     7.602    22.952     0.200
     7.702    22.737     0.200
     7.913    23.175     0.200
     8.253    24.246     0.200
     8.323    25.309     0.200
     9.151    28.947     0.200
     9.225    28.657     0.200
     9.286    29.393     0.200
     9.582    26.806     0.200
    10.050    27.838     0.200
    10.301    31.001     0.200
    10.544    28.705     0.200
    10.840    29.564     0.200
    11.140    29.921     0.200
    11.099    31.900     0.200
    12.421    33.136     0.200
     1.917    10.834     0.200
     2.011    11.460     0.200
     2.144    10.453     0.200
     2.048    10.693     0.200
     2.361    12.148     0.200
     2.400    11.698     0.200
     2.419    13.234     0.200
     2.599    13.831     0.200
     2.451    12.682     0.200
     2.715    13.602     0.200
     2.919    11.765     0.200
     2.968    12.449     0.200
     3.014    13.056     0.200
     3.302    13.240     0.200
     3.168    13.895     0.200
     3.278    13.032     0.200
     3.584    13.397     0.200
     3.633    14.077     0.200
     3.534    14.191     0.200
     3.563    15.560     0.200
     3.805    13.841     0.200
     3.712    15.379     0.200
     3.857    14.758     0.200
     3.972    15.211     0.200
     3.992    16.049     0.200
     4.101    15.516     0.200
     4.190    15.133     0.200
     4.097    16.792     0.200
     4.293    15.650     0.200
     4.310    16.447     0.200
     4.311    17.585     0.200
     4.397    16.747     0.200
     4.577    17.013     0.200
     4.640    16.979     0.200
     4.880    17.087     0.200
     4.836    16.380     0.200
     4.908    17.327     0.200
     5.142    18.378     0.200
     5.344    19.778     0.200
     5.504    18.263     0.200
     5.602    20.182     0.200
     5.640    19.530     0.200
     5.904    19.032     0.200
     6.334    21.802     0.200
     7.104    21.133     0.200
     7.239    22.096     0.200
     7.900    22.888     0.200
     8.314    24.244     0.200
     9.146    27.535     0.200
    10.293    30.142     0.200
    10.365    30.270     0.200
     1.938    11.434     0.200
     1.867    11.912     0.200
     2.028    10.283     0.200
     2.290    11.622     0.200
     2.311    11.067     0.200
     2.304    12.485     0.200
     2.641    12.725     0.200
     2.537    11.796     0.200
     2.824    11.913     0.200
     2.861    12.296     0.200
     3.210    11.916     0.200
     3.179    13.320     0.200
     3.482    13.985     0.200
     3.495    15.256     0.200
     3.601    15.189     0.200
     3.720    14.415     0.200
     3.743    15.150     0.200
     3.863    15.650     0.200
     4.089    15.231     0.200
     4.184    15.652     0.200
     4.197    15.878     0.200
     4.188    16.177     0.200
     4.776    17.148     0.200
     4.758    16.959     0.200
     4.725    17.683     0.200
     5.487    19.544     0.200
     5.718    19.632     0.200
     6.040    19.508     0.200
     6.239    20.242     0.200
     7.038    21.189     0.200
     9.937    27.618     0.200
     1.917    10.748     0.200
     2.010    11.992     0.200
     1.965    12.493     0.200
     2.046    11.721     0.200
     2.146    10.974     0.200
     2.360    11.534     0.200
     2.400    11.276     0.200
     2.423    13.268     0.200
     2.558    13.914     0.200
     2.602    13.999     0.200
     2.719    13.426     0.200
     2.722    14.862     0.200
     2.920    12.284     0.200
     2.969    13.036     0.200
     3.018    13.939     0.200
     3.118    14.838     0.200
     3.137    16.002     0.200
     3.164    14.821     0.200
     3.302    13.957     0.200
     3.279    13.860     0.200
     3.449    13.373     0.200
     3.636    15.756     0.200
     3.717    15.277     0.200
     3.804    13.789     0.200
     3.859    15.118     0.200
     3.976    16.295     0.200
     3.996    14.925     0.200
     4.029    15.835     0.200
     4.191    14.936     0.200
     4.191    18.071     0.200
     4.294    16.400     0.200
     4.312    16.489     0.200
     4.309    16.422     0.200
     4.406    18.181     0.200
     4.642    18.054     0.200
     4.799    15.798     0.200
     4.840    17.106     0.200
     4.881    17.372     0.200
     4.912    17.781     0.200
     5.131    17.878     0.200
     5.145    19.374     0.200
     5.348    19.437     0.200
     5.363    17.978     0.200
     5.363    17.470     0.200
     5.507    19.775     0.200
     5.572    17.267     0.200
     5.605    19.368     0.200
     5.778    19.186     0.200
     5.916    19.584     0.200
     5.907    20.046     0.200
     6.083    20.235     0.200
     6.147    20.348     0.200
     6.336    21.151     0.200
     6.530    21.773     0.200
     6.592    22.115     0.200
     6.628    21.874     0.200
     6.756    21.859     0.200
     7.102    20.952     0.200
     7.160    21.877     0.200
     7.243    22.949     0.200
     7.751    23.628     0.200
     7.827    23.779     0.200
     7.916    23.802     0.200
     7.923    23.562     0.200
     8.097    23.925     0.200
     8.100    23.830     0.200
     8.160    24.184     0.200
     8.128    26.082     0.200
     8.189    24.070     0.200
     8.195    24.547     0.200
     8.240    24.490     0.200
     8.290    24.410     0.200
     8.326    24.674     0.200
     8.317    26.913     0.200
     8.318    26.242     0.200
     8.357    24.284     0.200
     8.422    24.836     0.200
     8.493    24.687     0.200
     8.911    25.917     0.200
    10.038    27.982     0.200
    10.370    30.117     0.200
     1.932    10.993     0.200
     1.894    11.722     0.200
     2.060    11.648     0.200
     2.058    13.346     0.200
     2.142    12.071     0.200
     2.299    12.086     0.200
     2.315    12.023     0.200
     2.490    12.411     0.200
     2.544    12.182     0.200
     2.555    13.364     0.200
     2.749    14.236     0.200
     2.821    13.053     0.200
     3.067    13.242     0.200
     3.034    14.060     0.200
     3.122    13.438     0.200
     3.048    13.006     0.200
     3.143    14.808     0.200
     3.447    13.556     0.200
     3.428    14.521     0.200
     3.383    13.776     0.200
     3.618    15.966     0.200
     3.735    14.730     0.200
     3.777    15.452     0.200
     3.838    15.122     0.200
     3.944    14.132     0.200
     4.013    15.893     0.200
     3.955    15.751     0.200
     4.092    16.108     0.200
     4.062    17.202     0.200
     4.123    16.827     0.200
     4.254    16.336     0.200
     4.341    15.784     0.200
     4.448    16.642     0.200
     4.466    16.755     0.200
     4.460    16.861     0.200
     4.447    17.569     0.200
     4.547    17.491     0.200
     4.732    17.322     0.200
     4.942    16.696     0.200
     4.960    18.129     0.200
     5.033    17.915     0.200
     5.279    17.514     0.200
     5.292    18.116     0.200
     5.493    19.683     0.200
     5.490    18.227     0.200
     5.490    18.055     0.200
     5.544    17.740     0.200
     5.643    18.605     0.200
     5.672    18.163     0.200
     5.713    17.794     0.200
     5.758    19.648     0.200
     5.756    18.733     0.200
     5.905    19.093     0.200
     6.069    20.314     0.200
     6.045    19.233     0.200
     6.460    20.790     0.200
     6.489    21.256     0.200
     6.545    21.497     0.200
     6.612    20.638     0.200
     6.631    22.621     0.200
     6.660    21.586     0.200
     7.224    21.384     0.200
     7.296    22.512     0.200
     7.334    23.200     0.200
     7.395    23.413     0.200
     7.627    23.512     0.200
     7.744    22.779     0.200
     8.248    25.434     0.200
     8.373    24.712     0.200
     8.456    26.938     0.200
     9.170    26.032     0.200
     9.258    28.441     0.200
     9.366    28.528     0.200
     9.516    26.839     0.200
    10.474    31.341     0.200
    11.243    29.562     0.200
    12.124    33.674     0.200
    12.466    33.749     0.200
    17.771    40.180     0.200
     1.922    10.687     0.200
     2.050    10.799     0.200
     2.053    11.843     0.200
     2.048    12.562     0.200
     2.137    12.217     0.200
     2.289    11.672     0.200
     2.320    12.118     0.200
     2.485    12.246     0.200
     2.537    12.859     0.200
     2.544    13.407     0.200
     2.739    14.315     0.200
     2.810    13.372     0.200
     2.814    13.863     0.200
     3.060    13.201     0.200
     3.044    14.161     0.200
     3.114    13.559     0.200
     3.058    13.175     0.200
     3.132    14.616     0.200
     3.278    15.975     0.200
     3.440    13.381     0.200
     3.394    14.644     0.200
     3.421    14.096     0.200
     3.570    14.060     0.200
     3.609    16.095     0.200
     3.727    15.098     0.200
     3.766    15.762     0.200
     3.828    15.070     0.200
     3.938    15.032     0.200
     4.003    16.711     0.200
     3.966    15.758     0.200
     4.082    15.512     0.200
     4.112    16.325     0.200
     4.174    17.155     0.200
     4.246    16.495     0.200
     4.333    15.836     0.200
     4.439    17.073     0.200
     4.437    17.953     0.200
     4.450    17.039     0.200
     4.456    16.272     0.200
     4.537    17.565     0.200
     4.723    17.198     0.200
     4.787    18.045     0.200
     4.935    16.542     0.200
     4.949    18.063     0.200
     5.025    18.258     0.200
     5.272    17.119     0.200
     5.491    20.507     0.200
     5.479    17.893     0.200
     5.533    19.801     0.200
     5.632    20.017     0.200
     5.748    20.593     0.200
     5.745    20.948     0.200
     5.894    19.586     0.200
     5.976    20.037     0.200
     6.227    20.538     0.200
     6.290    20.438     0.200
     6.306    21.742     0.200
     6.469    21.988     0.200
     6.479    21.512     0.200
     6.564    21.515     0.200
     6.567    22.510     0.200
     6.602    21.158     0.200
     6.731    21.657     0.200
     6.670    21.484     0.200
     7.220    21.129     0.200
     7.290    22.287     0.200
     7.324    22.965     0.200
     7.616    24.079     0.200
     8.044    23.588     0.200
     8.281    24.353     0.200
     8.368    24.689     0.200
     8.446    27.225     0.200
     8.552    26.243     0.200
     9.331    28.825     0.200
     9.339    29.036     0.200
     9.743    29.631     0.200
    10.110    29.640     0.200
    10.180    28.050     0.200
    10.463    30.669     0.200
    15.290    37.587     0.200
    15.963    36.854     0.200
    16.173    39.172     0.200
     1.979    11.261     0.200
     1.941    12.779     0.200
     2.077    12.086     0.200
     2.015    11.797     0.200
     2.181    11.793     0.200
     2.428    12.635     0.200
     2.427    13.839     0.200
     2.461    12.683     0.200
     2.389    12.630     0.200
     2.624    14.823     0.200
     2.978    13.607     0.200
     3.017    13.913     0.200
    15.382    39.035     0.200
    15.908    38.333     0.200
    16.084    40.314     0.200
     2.389    12.830     0.200
     3.524    16.340     0.200
     5.671    18.773     0.200
     7.171    21.774     0.200
     8.224    24.596     0.200
     8.769    26.486     0.200
    10.290    32.017     0.200
    12.880    33.779     0.200
     1.924    11.694     0.200
     1.927    11.917     0.200
     2.002    11.008     0.200
     2.107    11.840     0.200
     2.180    12.068     0.200
     2.129    11.887     0.200
     2.368    11.994     0.200
     2.277    11.769     0.200
     2.525    12.205     0.200
     2.591    12.888     0.200
     2.631    14.043     0.200
     3.118    13.410     0.200
     1.868    10.377     0.200
     1.913    11.542     0.200
     1.969    11.695     0.200
     2.082    10.440     0.200
     1.876     9.772     0.200
     1.897    10.808     0.200
     1.937    12.652     0.200
     1.994    11.656     0.200
     1.877    11.195     0.200
     1.989    11.499     0.200
     2.110    11.824     0.200
     2.103    11.596     0.200
     2.114    11.680     0.200
     2.179    11.871     0.200
     2.278    11.647     0.200
     2.355    12.346     0.200
     2.525    11.740     0.200
     2.587    12.116     0.200
     2.614    13.015     0.200
     2.768    13.825     0.200
     2.808    14.045     0.200
     2.879    14.180     0.200
     2.975    13.591     0.200
     2.990    12.244     0.200
     3.112    12.752     0.200
     3.174    12.853     0.200
     3.200    13.494     0.200
     3.324    13.068     0.200
     7.254    20.956     0.200
     8.100    23.942     0.200
     8.617    25.522     0.200
    10.235    28.405     0.200
    10.452    29.155     0.200
    10.528    30.767     0.200
     1.864    10.808     0.200
     1.963    11.679     0.200
     1.920    12.292     0.200
     2.082    10.759     0.200
     2.110    12.797     0.200
     2.314    11.723     0.200
     2.346    12.160     0.200
     2.363    13.378     0.200
     2.538    14.517     0.200
     2.670    13.574     0.200
     2.863    12.297     0.200
     2.908    13.398     0.200
     2.961    13.755     0.200
     2.090    11.225     0.200
     2.109    12.894     0.200
     2.333    12.066     0.200
     2.376    11.909     0.200
     2.395    12.080     0.200
     2.453    12.531     0.200
     2.906    13.305     0.200
     2.935    13.448     0.200
     2.924    13.193     0.200
     3.560    14.345     0.200
     3.805    14.558     0.200
     1.874     9.199     0.200
     1.980     9.423     0.200
     2.332    10.018     0.200
     2.355     9.735     0.200
     2.903    11.759     0.200
     3.254    12.357     0.200
     3.222    12.665     0.200
     3.257    12.842     0.200
     3.425    12.780     0.200
     3.284    11.796     0.200
     3.525    12.909     0.200
     3.764    13.764     0.200
     3.618    12.869     0.200
     3.783    14.282     0.200
     3.882    14.652     0.200
     4.132    13.928     0.200
     4.238    15.433     0.200
     4.312    16.236     0.200
     4.819    16.121     0.200
     4.839    16.745     0.200
     5.057    16.681     0.200
     5.269    16.239     0.200
     5.415    16.558     0.200
     5.528    16.642     0.200
     5.551    18.266     0.200
     5.849    18.087     0.200
     5.777    16.819     0.200
     6.256    19.766     0.200
     6.377    19.370     0.200
     6.438    20.078     0.200
     7.080    20.588     0.200
     7.122    21.085     0.200
     7.163    21.039     0.200
     7.400    21.182     0.200
     7.509    21.235     0.200
     7.842    22.208     0.200
     8.056    22.606     0.200
     9.202    26.885     0.200
    10.277    30.522     0.200
    11.101    28.814     0.200
    12.330    32.164     0.200
     2.027    12.070     0.200
     1.951    12.943     0.200
     2.043    12.509     0.200
     2.149    11.244     0.200
     2.377    12.123     0.200
     2.414    12.533     0.200
     2.416    13.223     0.200
     2.437    13.151     0.200
     2.932    12.527     0.200
     2.978    13.618     0.200
     3.010    14.122     0.200
     3.197    13.137     0.200
     3.315    13.497     0.200
     3.290    14.871     0.200
     3.595    14.063     0.200
     3.532    14.164     0.200
     3.548    16.247     0.200
     3.707    15.703     0.200
     3.819    14.344     0.200
     3.966    16.406     0.200
     4.111    16.398     0.200
     4.302    17.068     0.200
     4.317    16.712     0.200
     4.310    16.778     0.200
     4.585    17.433     0.200
     4.812    16.367     0.200
     4.891    18.372     0.200
     4.892    19.513     0.200
     5.502    20.919     0.200
     5.586    17.688     0.200
     5.609    21.015     0.200
     5.924    20.510     0.200
     6.630    21.858     0.200
     6.948    22.837     0.200
     7.251    25.577     0.200
     9.213    28.647     0.200
    15.427    38.149     0.200
    16.066    39.713     0.200
     1.818    10.929     0.200
     1.932    11.648     0.200
     1.935    11.177     0.200
     2.007    11.538     0.200
     2.114    11.796     0.200
     2.131    11.740     0.200
     2.188    11.868     0.200
     2.269    11.658     0.200
     2.373    11.859     0.200
     2.534    12.054     0.200
     2.599    12.814     0.200
     2.633    13.315     0.200
     2.827    14.214     0.200
     2.893    12.788     0.200
     2.956    14.214     0.200
     2.971    12.627     0.200
     3.125    13.439     0.200
     3.189    13.232     0.200
     3.220    14.734     0.200
     3.306    13.521     0.200
     3.503    13.529     0.200
     3.490    14.363     0.200
     3.674    15.425     0.200
     3.798    14.197     0.200
     3.855    15.239     0.200
     3.915    16.054     0.200
     3.877    15.329     0.200
     3.995    14.773     0.200
     4.168    16.258     0.200
     4.201    15.520     0.200
     4.320    16.151     0.200
     4.404    16.071     0.200
     4.515    16.804     0.200
     4.525    17.691     0.200
     4.536    16.500     0.200
     4.536    16.569     0.200
     4.625    17.291     0.200
     4.802    17.676     0.200
     4.864    17.943     0.200
     5.002    18.369     0.200
     5.750    18.134     0.200
     5.982    19.402     0.200
     6.548    19.067     0.200
     6.581    20.476     0.200
    15.237    38.025     0.200
     1.906    10.838     0.200
     2.003    11.612     0.200
     2.122    10.702     0.200
     2.354    11.520     0.200
     2.388    12.127     0.200
     2.394    12.827     0.200
     2.576    14.562     0.200
     2.690    13.101     0.200
     2.906    12.799     0.200
     2.950    13.129     0.200
     2.989    13.987     0.200
     3.289    13.365     0.200
     3.193    15.180     0.200
     3.263    14.149     0.200
     3.223    13.455     0.200
     3.568    14.133     0.200
     3.608    15.593     0.200
     3.557    14.187     0.200
     3.687    15.460     0.200
     3.794    14.174     0.200
     3.946    16.125     0.200
     4.084    15.629     0.200
     4.174    15.875     0.200
     4.122    14.914     0.200
     4.275    16.212     0.200
     4.290    16.455     0.200
     4.284    16.460     0.200
     4.374    17.769     0.200
     4.557    16.895     0.200
     4.622    16.612     0.200
     4.786    15.974     0.200
     4.864    17.201     0.200
     4.810    17.794     0.200
     4.888    18.349     0.200
     5.116    17.791     0.200
     5.081    17.774     0.200
    16.043    40.862     0.200
     2.011    11.520     0.200
     2.114    11.087     0.200
     2.362    12.083     0.200
     2.392    12.473     0.200
     2.376    12.938     0.200
     2.668    13.543     0.200
     2.907    13.105     0.200
     2.947    13.613     0.200
     2.970    14.206     0.200
     3.292    13.312     0.200
     3.263    14.567     0.200
     3.210    15.365     0.200
     3.567    14.399     0.200
     3.593    16.135     0.200
     3.570    14.627     0.200
     3.668    15.303     0.200
     3.799    14.413     0.200
     3.926    16.327     0.200
     4.082    16.251     0.200
     4.174    15.768     0.200
     4.138    16.382     0.200
     4.271    16.171     0.200
     4.284    16.883     0.200
     4.273    16.557     0.200
     4.269    17.948     0.200
     4.238    16.952     0.200
     4.361    17.958     0.200
     4.552    16.825     0.200
     4.617    17.833     0.200
     4.789    16.185     0.200
     4.791    17.249     0.200
     4.862    18.219     0.200
     4.863    18.649     0.200
    15.452    39.480     0.200
     1.890    10.217     0.200
     1.927    11.706     0.200
     1.989    11.028     0.200
     2.106    10.242     0.200
     2.086    11.710     0.200
     2.340    11.492     0.200
     2.373    11.697     0.200
     2.380    12.198     0.200
     2.518    13.135     0.200
     2.477    11.598     0.200
     2.560    14.435     0.200
     2.679    13.732     0.200
     2.890    12.495     0.200
     2.934    13.131     0.200
     2.976    13.488     0.200
     3.593    15.917     0.200
     3.674    15.628     0.200
     3.779    13.949     0.200
     4.363    18.473     0.200
     4.605    18.285     0.200
     4.771    16.206     0.200
     4.798    17.788     0.200
     5.100    17.590     0.200
     5.067    18.164     0.200
     5.545    17.419     0.200
     5.565    19.206     0.200
     5.603    20.128     0.200
     5.864    19.930     0.200
    17.384    40.330     0.200
     2.005    11.288     0.200
     1.925    11.494     0.200
     2.106    12.406     0.200
     2.008    11.862     0.200
     2.192    12.007     0.200
     2.457    12.342     0.200
     2.424    13.579     0.200
     2.629    14.905     0.200
     2.686    13.394     0.200
     3.001    13.322     0.200
     3.035    13.889     0.200
     3.009    13.786     0.200
     3.174    15.801     0.200
     3.167    14.468     0.200
     3.168    13.243     0.200
     3.498    15.190     0.200
     3.650    16.114     0.200
     3.990    17.202     0.200
     4.403    17.975     0.200
     4.415    17.863     0.200
     4.703    18.456     0.200
     4.789    18.147     0.200
     4.952    17.978     0.200
     4.915    17.952     0.200
     5.210    17.891     0.200
     5.109    18.307     0.200
     5.171    19.724     0.200
     5.357    17.906     0.200
     5.659    17.927     0.200
     5.652    20.867     0.200
     5.621    19.764     0.200
     5.771    20.072     0.200
     6.005    20.749     0.200
     6.063    20.802     0.200
     6.077    20.521     0.200
     6.140    20.745     0.200
     6.153    20.344     0.200
     6.194    19.861     0.200
     6.338    22.240     0.200
     6.381    20.887     0.200
     6.457    20.610     0.200
     6.370    20.494     0.200
     6.501    20.508     0.200
     6.498    20.929     0.200
     6.701    23.003     0.200
     7.268    24.635     0.200
     7.496    23.761     0.200
     7.627    22.999     0.200
     7.920    24.041     0.200
     7.975    23.641     0.200
     8.191    24.402     0.200
     8.113    23.281     0.200
    15.359    39.211     0.200
    15.618    38.788     0.200
     1.927    11.683     0.200
     1.930    11.612     0.200
     2.004    11.360     0.200
     2.128    11.914     0.200
     2.183    12.226     0.200
     2.274    11.533     0.200
     2.369    12.223     0.200
     2.529    12.519     0.200
     2.631    13.683     0.200
     2.594    12.996     0.200
     2.824    15.252     0.200
     2.845    14.424     0.200
     2.892    13.499     0.200
     2.974    13.608     0.200
     2.958    13.421     0.200
     3.121    13.683     0.200
     3.218    14.965     0.200
     3.185    13.900     0.200
     3.309    13.768     0.200
     3.499    13.524     0.200
     3.675    15.177     0.200
     3.608    14.550     0.200
     3.853    16.103     0.200
     3.913    15.916     0.200
     3.990    14.999     0.200
     3.987    17.152     0.200
     4.532    17.033     0.200
     4.860    18.280     0.200
     5.003    18.614     0.200
     5.093    17.699     0.200
     5.201    18.562     0.200
     5.446    19.026     0.200
     5.828    20.845     0.200
     6.121    21.338     0.200
     6.955    22.833     0.200
     7.256    21.781     0.200
     7.403    23.500     0.200
     8.532    26.101     0.200
     9.235    26.405     0.200
     9.345    26.423     0.200
    10.244    28.059     0.200
    10.346    30.328     0.200
    10.545    31.568     0.200
    10.455    29.314     0.200
    11.027    31.476     0.200
    11.285    31.191     0.200
    12.892    34.547     0.200
    15.522    40.620     0.200
    16.004    38.820     0.200
     1.922    10.817     0.200
     1.923    11.401     0.200
     2.022    11.653     0.200
     2.128    10.849     0.200
     2.066    11.333     0.200
     2.373    11.945     0.200
     2.389    13.824     0.200
     2.404    12.089     0.200
     2.445    12.095     0.200
     2.577    14.985     0.200
     2.678    13.514     0.200
     2.921    12.707     0.200
     2.961    13.552     0.200
     2.983    13.673     0.200
     3.197    14.716     0.200
     3.305    13.366     0.200
     3.221    13.443     0.200
     3.277    14.262     0.200
     3.524    14.337     0.200
     3.581    14.123     0.200
     3.607    15.986     0.200
     3.555    14.656     0.200
     3.680    15.831     0.200
     3.811    14.276     0.200
     3.938    15.201     0.200
     3.961    16.368     0.200
     4.096    16.000     0.200
     4.187    15.660     0.200
     4.124    16.752     0.200
     4.285    16.858     0.200
     4.282    17.459     0.200
     4.298    16.536     0.200
     4.225    17.876     0.200
     4.375    17.664     0.200
     4.566    17.323     0.200
     4.868    18.483     0.200
     5.328    17.149     0.200
     5.431    19.085     0.200
    15.439    38.633     0.200
     1.902    10.298     0.200
     1.950    10.832     0.200
     1.899    12.077     0.200
     2.054    11.629     0.200
     2.137    10.952     0.200
     2.061    11.158     0.200
     2.405    12.187     0.200
     2.431    11.984     0.200
     2.380    13.345     0.200
     2.945    13.381     0.200
     2.979    12.338     0.200
     2.969    13.083     0.200
     3.208    14.770     0.200
     3.299    13.861     0.200
     3.601    14.636     0.200
     3.922    15.880     0.200
     4.106    17.670     0.200
     4.142    16.185     0.200
     4.293    16.781     0.200
     4.580    16.662     0.200
     4.788    17.395     0.200
     1.811    11.232     0.200
     1.903    10.154     0.200
     2.038    10.699     0.200
     2.031    10.443     0.200
     2.124    10.650     0.200
     2.270    11.188     0.200
     2.472    11.315     0.200
     2.522    11.615     0.200
     2.526    11.708     0.200
     2.798    14.307     0.200
    15.951    38.280     0.200
     1.911    10.158     0.200
     1.915    10.240     0.200
     2.044    10.704     0.200
     2.039    11.721     0.200
     2.129    11.305     0.200
     2.278    11.751     0.200
     2.329    11.488     0.200
     2.477    11.870     0.200
     2.528    11.958     0.200
     2.533    12.021     0.200
     2.728    13.426     0.200
     2.750    13.062     0.200
     2.805    13.349     0.200
    15.310    38.667     0.200
    15.536    37.417     0.200
    15.956    37.845     0.200
    16.432    40.838     0.200
    16.823    40.772     0.200
     2.329    11.738     0.200
     3.603    15.487     0.200
     7.213    21.616     0.200
     8.283    24.330     0.200
     8.696    25.555     0.200
    10.198    31.967     0.200
    10.191    30.758     0.200
    12.077    31.149     0.200
    12.889    32.799     0.200
    14.024    37.993     0.200
     1.895     9.905     0.200
     1.904    10.347     0.200
     1.997    11.845     0.200
     2.136    11.793     0.200
     2.347    12.347     0.200
     2.387    12.640     0.200
     2.418    11.960     0.200
     2.594    13.443     0.200
     2.907    12.778     0.200
     3.015    13.804     0.200
     3.169    13.793     0.200
     3.629    14.849     0.200
     3.713    14.778     0.200
     3.973    15.101     0.200
     4.195    15.320     0.200
     4.918    17.665     0.200
     7.089    21.079     0.200
     2.465    12.101     0.200
     2.465    12.335     0.200
     3.206    13.268     0.200
     3.572    15.190     0.200
     3.572    15.385     0.200
     5.694    18.728     0.200
     6.529    21.393     0.200
     7.089    21.219     0.200
     8.287    23.590     0.200
     8.287    23.692     0.200
     8.839    26.818     0.200
     9.149    27.732     0.200
    10.332    31.551     0.200
    12.252    31.195     0.200
    12.403    32.758     0.200
    12.751    34.697     0.200
    12.963    33.390     0.200
    15.784    38.939     0.200
    16.143    39.640     0.200
    17.479    39.817     0.200
     1.881    10.710     0.200
     1.972    11.162     0.200
     1.976    12.728     0.200
     2.123    10.884     0.200
     2.417    12.469     0.200
     4.385    17.163     0.200
     4.763    15.567     0.200
     4.937    18.813     0.200
     5.097    16.673     0.200
     5.104    18.489     0.200
     5.129    18.559     0.200
     5.334    19.373     0.200
     5.359    18.787     0.200
     5.535    17.233     0.200
     5.533    18.844     0.200
     5.581    20.283     0.200
     5.647    19.517     0.200
     7.063    20.908     0.200
    10.252    27.923     0.200
    11.087    29.775     0.200
    12.690    33.331     0.200
    14.572    36.993     0.200
    15.382    36.322     0.200
    15.801    36.842     0.200
    16.010    38.818     0.200
    16.737    39.754     0.200
    16.922    40.136     0.200
    17.454    39.825     0.200
     1.852    11.357     0.200
     1.893    11.702     0.200
     1.989    11.095     0.200
     2.077    11.380     0.200
     2.109    11.982     0.200
     2.147    11.469     0.200
     2.353    12.014     0.200
     2.311    13.178     0.200
     2.492    12.013     0.200
     2.562    12.557     0.200
     2.631    13.122     0.200
     2.815    13.892     0.200
     2.906    14.061     0.200
     2.955    12.601     0.200
     2.986    13.067     0.200
     3.090    13.850     0.200
     3.161    13.796     0.200
     3.223    14.471     0.200
     3.319    13.252     0.200
     3.467    13.926     0.200
     3.457    14.952     0.200
     3.570    14.382     0.200
     3.766    14.821     0.200
     3.703    14.808     0.200
     3.848    15.261     0.200
     3.955    14.980     0.200
     3.919    15.764     0.200
     4.202    16.719     0.200
     4.289    16.035     0.200
     4.371    16.232     0.200
     4.487    16.663     0.200
     4.512    16.827     0.200
     4.519    16.648     0.200
     4.524    17.635     0.200
     4.613    17.099     0.200
     4.777    17.673     0.200
     4.837    17.699     0.200
     4.958    16.365     0.200
     5.034    18.316     0.200
     2.986    12.357     0.200
     3.703    15.219     0.200
     3.703    14.989     0.200
     3.983    15.614     0.200
     4.837    18.649     0.200
     5.302    18.227     0.200
     5.569    19.309     0.200
     5.560    20.411     0.200
     5.726    18.179     0.200
     5.984    19.358     0.200
     6.543    22.445     0.200
     6.716    22.725     0.200
     6.716    21.739     0.200
     6.952    22.567     0.200
     6.949    23.005     0.200
     7.216    22.791     0.200
     7.216    21.968     0.200
     7.216    22.491     0.200
     7.216    22.601     0.200
     7.862    24.146     0.200
     8.213    25.153     0.200
     8.371    23.001     0.200
     8.371    23.820     0.200
     8.659    26.354     0.200
     8.659    25.804     0.200
     9.343    27.874     0.200
    10.114    31.115     0.200
    12.139    30.534     0.200
    12.621    33.171     0.200
    12.948    34.926     0.200
    12.938    32.421     0.200
    13.939    38.292     0.200
    15.862    40.153     0.200
    16.002    39.963     0.200
    15.940    39.217     0.200
    16.104    39.671     0.200
    16.168    39.458     0.200
     1.982    11.003     0.200
     2.114    13.363     0.200
     2.164    12.072     0.200
     2.293    11.681     0.200
     2.347    12.309     0.200
     2.510    12.394     0.200
     2.573    12.872     0.200
     2.612    12.983     0.200
     2.803    14.065     0.200
     2.877    13.682     0.200
     2.976    13.430     0.200
     2.996    12.843     0.200
     3.099    12.792     0.200
     3.163    13.678     0.200
     3.200    14.045     0.200
     3.330    13.363     0.200
     3.478    13.569     0.200
     3.464    14.069     0.200
     3.590    14.067     0.200
     3.667    15.334     0.200
     3.772    14.591     0.200
     3.833    15.656     0.200
     3.899    14.702     0.200
     3.896    15.909     0.200
     4.294    16.097     0.200
     4.378    15.906     0.200
     4.489    16.792     0.200
     4.511    16.835     0.200
     4.511    16.924     0.200
     4.504    18.028     0.200
     4.601    17.784     0.200
     4.776    17.031     0.200
     4.838    17.509     0.200
     4.971    16.163     0.200
     4.997    19.012     0.200
     5.547    18.143     0.200
     6.137    20.863     0.200
     6.663    21.593     0.200
     6.687    21.971     0.200
     7.390    23.223     0.200
     7.683    23.247     0.200
     9.213    26.104     0.200
    10.531    31.178     0.200
     1.844     9.853     0.200
     1.866    10.398     0.200
     1.923    11.207     0.200
     1.965    11.095     0.200
     2.084    10.479     0.200
     2.107    10.805     0.200
     2.316    10.976     0.200
     2.348    11.437     0.200
     2.366    11.768     0.200
     2.541    13.178     0.200
     2.501    11.562     0.200
     2.676    14.401     0.200
     2.866    12.703     0.200
     2.910    12.552     0.200
     2.964    13.098     0.200
     3.258    12.181     0.200
     3.540    14.388     0.200
     3.592    13.369     0.200
     3.663    14.790     0.200
     3.755    13.680     0.200
     4.153    13.527     0.200
     4.251    15.676     0.200
     4.889    16.396     0.200
    15.796    37.848     0.200
    16.005    38.851     0.200
     1.901    10.023     0.200
     1.932    10.987     0.200
     1.930    11.318     0.200
     2.031    10.709     0.200
     2.055    11.270     0.200
     2.139    10.653     0.200
     2.381    11.514     0.200
     2.414    12.008     0.200
     2.399    12.521     0.200
     2.436    11.841     0.200
     2.587    12.820     0.200
     2.930    12.809     0.200
     2.972    12.499     0.200
     2.992    13.564     0.200
     3.188    13.174     0.200
     3.210    12.968     0.200
     3.314    12.962     0.200
     3.287    14.072     0.200
     3.472    12.981     0.200
     3.545    14.607     0.200
     3.527    14.850     0.200
     3.591    14.233     0.200
     3.617    15.634     0.200
     3.689    15.279     0.200
     3.820    14.151     0.200
     3.855    15.874     0.200
     3.947    15.238     0.200
     3.971    15.968     0.200
     4.114    15.287     0.200
     4.106    15.549     0.200
     4.215    15.735     0.200
     4.198    15.356     0.200
     4.296    15.874     0.200
     4.309    16.071     0.200
     4.291    16.504     0.200
     4.385    16.863     0.200
     4.381    17.849     0.200
     4.393    17.609     0.200
     4.577    16.643     0.200
     4.642    16.973     0.200
     4.812    15.846     0.200
     4.812    17.607     0.200
     4.886    17.245     0.200
     4.872    17.547     0.200
     5.005    17.216     0.200
     1.947    11.488     0.200
     2.065    11.676     0.200
     2.072    11.469     0.200
     2.080    12.377     0.200
     2.144    12.014     0.200
     2.313    12.416     0.200
     2.313    12.714     0.200
     2.491    12.024     0.200
     2.549    12.127     0.200
     2.575    13.931     0.200
     2.726    14.066     0.200
     2.767    14.595     0.200
     2.847    14.647     0.200
     2.924    14.405     0.200
     3.013    14.606     0.200
     3.074    13.356     0.200
     3.031    14.241     0.200
     3.133    14.123     0.200
     3.164    14.240     0.200
     3.285    14.991     0.200
     3.304    16.207     0.200
     3.411    14.653     0.200
     3.366    14.987     0.200
     3.453    13.411     0.200
     3.436    14.921     0.200
     3.573    14.412     0.200
     3.640    14.857     0.200
     3.744    15.102     0.200
     3.796    15.643     0.200
     3.860    15.472     0.200
     3.948    15.206     0.200
     3.935    15.978     0.200
     4.026    15.952     0.200
     4.041    17.983     0.200
     4.114    16.091     0.200
     4.144    16.961     0.200
     4.264    16.162     0.200
     4.350    16.454     0.200
     4.459    16.810     0.200
     4.478    16.733     0.200
     4.476    17.063     0.200
     4.468    17.926     0.200
     4.565    17.604     0.200
     4.745    17.085     0.200
     4.807    16.754     0.200
     4.947    16.644     0.200
     4.981    18.024     0.200
     4.972    18.429     0.200
     5.042    18.441     0.200
     5.157    19.678     0.200
     5.262    18.598     0.200
     5.286    17.839     0.200
     5.269    19.018     0.200
     5.310    19.310     0.200
     2.044    11.611     0.200
     2.148    12.060     0.200
     2.155    12.489     0.200
     2.218    12.176     0.200
     2.239    12.110     0.200
     2.410    12.292     0.200
     2.632    12.769     0.200
     2.667    13.603     0.200
     2.921    13.864     0.200
     2.923    14.431     0.200
     2.935    13.266     0.200
     3.159    13.614     0.200
     3.691    16.019     0.200
     3.834    14.446     0.200
     3.842    15.148     0.200
     3.891    15.580     0.200
     3.947    16.437     0.200
     3.952    16.728     0.200
     4.199    17.022     0.200
     4.233    17.491     0.200
     4.552    17.334     0.200
     4.572    16.914     0.200
     4.661    18.254     0.200
     5.600    21.029     0.200
     5.756    20.666     0.200
     5.797    18.372     0.200
     5.860    20.705     0.200
     5.868    21.041     0.200
     6.158    21.227     0.200
     6.574    23.546     0.200
    10.283    28.555     0.200
    10.574    31.772     0.200
    11.318    30.417     0.200
    12.676    33.030     0.200
    12.880    33.199     0.200
     1.917    10.893     0.200
     2.027    11.970     0.200
     2.092    11.108     0.200
     2.108    11.408     0.200
     2.379    12.091     0.200
     2.398    12.369     0.200
     2.333    12.268     0.200
     2.451    12.405     0.200
     2.937    13.282     0.200
     3.255    14.921     0.200
     3.295    13.063     0.200
     3.267    13.191     0.200
     3.460    15.364     0.200
     3.555    15.193     0.200
     3.620    15.565     0.200
     4.178    17.460     0.200
     4.604    17.882     0.200
     4.742    17.100     0.200
     4.806    18.861     0.200
     5.462    18.657     0.200
     6.279    21.285     0.200
     7.128    21.242     0.200
     8.178    24.511     0.200
     8.841    26.729     0.200
    10.826    29.512     0.200
     3.460    15.172     0.200
     7.128    20.894     0.200
     7.128    21.523     0.200
     8.178    24.683     0.200
     8.841    26.088     0.200
    10.382    32.280     0.200
    12.152    31.264     0.200
    12.880    33.439     0.200
    16.167    40.093     0.200
     1.912    10.640     0.200
     2.020    11.325     0.200
     2.091    10.939     0.200
     2.107    11.907     0.200
     2.336    11.958     0.200
     2.372    11.557     0.200
     2.392    11.894     0.200
     2.456    11.598     0.200
     2.624    12.484     0.200
     2.904    13.013     0.200
     2.934    13.560     0.200
     3.290    13.623     0.200
     3.256    14.358     0.200
     3.251    14.544     0.200
     3.266    13.403     0.200
     3.469    15.283     0.200
     3.558    13.606     0.200
     3.557    15.826     0.200
     3.625    15.464     0.200
     3.602    13.802     0.200
     3.802    14.395     0.200
     3.809    15.739     0.200
     3.882    15.050     0.200
     4.070    15.831     0.200
     4.166    15.880     0.200
     4.257    16.587     0.200
     4.265    16.057     0.200
     4.175    15.004     0.200
     4.329    17.785     0.200
     4.534    17.339     0.200
     4.601    16.992     0.200
     4.747    16.985     0.200
     4.789    15.945     0.200
     4.851    16.957     0.200
     5.023    17.308     0.200
     5.074    18.797     0.200
     5.112    17.262     0.200
     5.424    18.564     0.200
     5.549    19.360     0.200
     5.551    19.991     0.200
     5.566    18.098     0.200
     5.464    18.131     0.200
     5.826    19.149     0.200
     5.764    18.640     0.200
     5.880    19.786     0.200
     6.280    20.436     0.200
     6.398    19.893     0.200
     7.121    21.059     0.200
     7.160    22.460     0.200
     7.176    22.311     0.200
     7.364    22.636     0.200
     7.408    22.980     0.200
     7.528    22.487     0.200
     7.676    22.933     0.200
     7.876    23.930     0.200
     8.077    22.989     0.200
     8.246    23.272     0.200
     8.187    23.794     0.200
     8.974    25.454     0.200
    10.131    28.156     0.200
    10.491    28.965     0.200
    11.141    29.231     0.200
    12.352    32.689     0.200
    12.889    33.095     0.200
     1.922    10.738     0.200
     1.899    11.220     0.200
     2.026    11.119     0.200
     2.080    11.371     0.200
     2.377    11.358     0.200
     2.369    11.366     0.200
     2.404    11.639     0.200
     2.445    11.941     0.200
     2.918    12.157     0.200
     2.954    12.660     0.200
     3.303    12.555     0.200
     3.218    13.850     0.200
     3.272    13.951     0.200
     3.236    13.692     0.200
     3.469    13.875     0.200
     3.499    14.538     0.200
     3.576    13.412     0.200
     3.588    14.564     0.200
     3.572    15.019     0.200
     3.658    14.283     0.200
     3.812    14.267     0.200
     3.833    14.798     0.200
     3.916    15.125     0.200
     3.940    15.660     0.200
     4.089    15.739     0.200
     4.183    15.119     0.200
     4.143    16.702     0.200
     4.277    15.673     0.200
     4.273    16.360     0.200
     4.288    15.927     0.200
     4.556    16.986     0.200
     4.801    16.142     0.200
     4.781    16.480     0.200
     4.870    16.874     0.200
     5.056    17.989     0.200
     5.104    17.903     0.200
     5.127    17.094     0.200
     5.307    18.632     0.200
     5.456    18.559     0.200
     5.486    19.177     0.200
     5.441    18.126     0.200
     5.566    19.524     0.200
     5.577    17.500     0.200
     5.583    19.143     0.200
     5.709    18.645     0.200
     5.733    19.072     0.200
     5.857    20.187     0.200
     5.900    19.388     0.200
     6.271    20.915     0.200
     6.393    19.509     0.200
     6.426    20.872     0.200
     7.207    23.016     0.200
     7.386    23.282     0.200
     7.690    21.741     0.200
     7.893    22.480     0.200
     7.958    23.708     0.200
     8.069    24.404     0.200
     8.104    23.206     0.200
     8.253    23.298     0.200
     8.213    22.720     0.200
     8.507    22.585     0.200
    14.628    35.441     0.200
    15.207    37.730     0.200
    15.438    37.294     0.200
    15.442    37.642     0.200
    15.857    37.619     0.200
    16.148    39.305     0.200
    16.493    38.575     0.200
    16.806    39.714     0.200
    17.636    40.281     0.200
     2.445    12.410     0.200
     3.499    15.058     0.200
     5.733    18.869     0.200
     7.124    20.754     0.200
     8.213    23.732     0.200
     8.830    26.289     0.200
    10.355    30.400     0.200
    12.902    32.481     0.200
    15.762    39.350     0.200
     1.885     9.394     0.200
     1.906     9.614     0.200
     1.942    10.999     0.200
     2.125    10.136     0.200
     2.067    10.779     0.200
     2.353    10.874     0.200
     2.388    11.779     0.200
     2.398    12.230     0.200
     2.462    11.310     0.200
     2.579    12.601     0.200
     2.906    12.376     0.200
     2.952    12.665     0.200
     3.189    13.477     0.200
     3.220    12.727     0.200
     3.264    13.632     0.200
     3.547    14.763     0.200
     3.612    15.047     0.200
     3.554    13.462     0.200
     3.692    15.021     0.200
     3.838    15.354     0.200
     3.951    14.266     0.200
     3.971    16.794     0.200
    15.833    37.991     0.200
    16.041    38.086     0.200
     2.013    11.847     0.200
     2.059    12.570     0.200
     2.134    10.638     0.200
     2.363    12.398     0.200
     2.399    12.463     0.200
     2.403    13.532     0.200
     2.452    12.106     0.200
     2.697    13.646     0.200
     2.917    13.090     0.200
     2.962    13.824     0.200
     3.183    14.650     0.200
     3.212    13.282     0.200
     3.546    14.292     0.200
     3.545    15.476     0.200
     3.696    16.026     0.200
     3.804    14.461     0.200
     3.848    15.893     0.200
     4.210    15.612     0.200
     4.295    17.158     0.200
     4.296    18.476     0.200
     4.890    19.108     0.200
     5.127    17.152     0.200
     5.343    18.605     0.200
     5.429    17.269     0.200
     5.571    17.875     0.200
     5.677    18.440     0.200
     5.697    19.278     0.200
     6.298    22.341     0.200
     7.107    21.558     0.200
     7.221    23.442     0.200
     7.580    23.286     0.200
     8.258    25.032     0.200
     9.984    30.438     0.200
    10.182    29.200     0.200
    10.847    29.590     0.200
    12.399    33.478     0.200
    12.936    34.460     0.200
    15.443    37.877     0.200
    15.843    38.705     0.200
     2.019    11.161     0.200
     2.156    10.622     0.200
     2.035    12.103     0.200
     2.410    11.782     0.200
     2.432    11.897     0.200
     2.632    15.036     0.200
     2.726    12.641     0.200
     2.729    12.440     0.200
     2.930    12.807     0.200
     2.980    12.611     0.200
     3.155    15.138     0.200
     3.312    13.766     0.200
     3.187    13.351     0.200
     3.725    15.675     0.200
     4.084    15.717     0.200
     4.324    16.451     0.200
     4.652    17.012     0.200
     4.915    17.573     0.200
     5.126    18.320     0.200
     5.357    19.413     0.200
     5.410    18.765     0.200
     5.584    17.805     0.200
     5.725    18.982     0.200
     5.842    20.274     0.200
     7.110    21.719     0.200
     7.201    22.101     0.200
     8.816    27.968     0.200
     9.575    27.058     0.200
    10.013    28.763     0.200
    10.306    30.069     0.200
    10.377    30.313     0.200
    10.838    30.005     0.200
    10.864    29.744     0.200
    12.327    33.390     0.200
    12.231    32.995     0.200
    12.423    34.523     0.200
    12.947    32.496     0.200
    14.141    38.312     0.200
    15.430    40.886     0.200
    15.849    38.909     0.200
    16.121    40.876     0.200
     5.677    19.097     0.200
     5.725    21.822     0.200
     8.281    23.347     0.200
    10.322    32.962     0.200
    10.312    31.894     0.200
    12.947    32.644     0.200
    14.141    39.640     0.200
    16.121    39.369     0.200
     5.725    21.083     0.200
     1.975    10.330     0.200
     2.023    11.416     0.200
     1.992    12.094     0.200
     2.124    11.973     0.200
     2.209    11.133     0.200
     2.344    12.314     0.200
     2.475    12.660     0.200
     2.436    13.013     0.200
     2.505    12.724     0.200
     2.644    14.329     0.200
     2.676    15.376     0.200
     2.693    12.969     0.200
     3.019    13.485     0.200
     3.053    14.072     0.200
     3.156    14.033     0.200
     3.153    13.372     0.200
     3.404    13.227     0.200
     3.373    14.554     0.200
     3.491    14.802     0.200
     3.498    15.324     0.200
     3.676    14.527     0.200
     3.664    16.242     0.200
     3.714    16.336     0.200
     3.912    14.729     0.200
     3.928    16.401     0.200
     3.967    16.588     0.200
     4.001    17.138     0.200
     4.072    15.382     0.200
     4.189    16.582     0.200
     4.185    17.505     0.200
     4.283    16.037     0.200
     4.327    18.256     0.200
     4.376    16.901     0.200
     4.385    17.137     0.200
     4.721    18.368     0.200
     4.835    19.096     0.200
     5.186    19.267     0.200
     5.383    19.787     0.200
     5.368    18.928     0.200
     5.413    19.249     0.200
     5.344    17.766     0.200
     5.525    20.762     0.200
     5.553    19.316     0.200
     5.667    21.000     0.200
     5.726    19.341     0.200
     5.782    20.064     0.200
     6.234    20.578     0.200
     6.398    21.323     0.200
     6.453    22.212     0.200
     6.514    21.534     0.200
     7.219    21.555     0.200
     7.207    22.849     0.200
     7.483    23.563     0.200
     7.642    23.145     0.200
     8.123    26.009     0.200
     8.188    24.621     0.200
     9.093    25.685     0.200
    10.245    28.518     0.200
    10.346    31.147     0.200
    10.610    28.353     0.200
    11.242    30.824     0.200
    11.318    31.103     0.200
    12.783    33.991     0.200
    12.832    34.098     0.200
     2.105    11.313     0.200
     2.326    12.415     0.200
     2.416    12.470     0.200
     2.429    12.479     0.200
     2.420    12.910     0.200
     2.938    13.356     0.200
     3.425    15.826     0.200
     3.554    16.310     0.200
     3.826    15.982     0.200
     3.862    15.283     0.200
     3.893    15.464     0.200
     4.218    16.876     0.200
     5.273    20.293     0.200
     5.603    17.932     0.200
     5.445    19.006     0.200
     5.617    19.810     0.200
     5.674    19.767     0.200
     7.166    21.389     0.200
     1.779     9.242     0.200
     1.895    10.046     0.200
     1.994    11.147     0.200
     2.143    10.032     0.200
     2.331    10.698     0.200
     2.378    11.419     0.200
     2.437    11.524     0.200
     2.745    11.229     0.200
     2.900    11.553     0.200
     2.957    12.670     0.200
     3.149    11.723     0.200
     3.195    11.714     0.200
     3.281    12.720     0.200
     3.262    13.725     0.200
     3.604    13.809     0.200
     3.736    13.840     0.200
     3.853    14.641     0.200
     4.014    14.412     0.200
     4.084    13.275     0.200
     4.776    15.190     0.200
     4.867    15.488     0.200
    15.392    37.675     0.200
    15.811    37.423     0.200
     2.477    11.140     0.200
     3.604    15.020     0.200
     5.731    19.007     0.200
     5.679    17.597     0.200
     7.071    21.761     0.200
     8.319    24.263     0.200
    10.324    30.272     0.200
    12.991    33.746     0.200
    16.143    38.440     0.200
     1.992    10.639     0.200
     2.099    11.216     0.200
     2.119    12.167     0.200
     2.174    11.818     0.200
     2.357    11.435     0.200
     2.283    11.717     0.200
     2.520    12.050     0.200
     2.584    12.482     0.200
     2.620    13.034     0.200
     2.873    13.507     0.200
     2.883    13.199     0.200
     2.883    13.320     0.200
     2.969    13.120     0.200
     3.174    13.468     0.200
     3.600    14.637     0.200
     3.669    15.493     0.200
     3.783    14.603     0.200
     3.903    15.740     0.200
     3.891    14.812     0.200
     3.998    15.872     0.200
     4.520    16.944     0.200
     4.998    18.282     0.200
     5.213    17.110     0.200
     5.912    19.437     0.200
    15.431    41.933     0.200
    15.995    37.736     0.200
    15.927    38.722     0.200
    16.204    39.528     0.200
    16.241    42.113     0.200
     2.283    11.967     0.200
     3.669    15.766     0.200
     5.912    19.785     0.200
     7.247    21.199     0.200
     7.247    21.648     0.200
     8.637    26.014     0.200
    10.125    31.913     0.200
    10.111    30.963     0.200
    12.898    32.572     0.200
    13.940    39.999     0.200
     5.912    20.476     0.200
     6.693    22.299     0.200
     8.333    22.921     0.200
     9.321    28.818     0.200
    12.046    32.056     0.200
    12.624    33.195     0.200
    12.928    36.610     0.200
    14.006    40.215     0.200
     1.956    11.201     0.200
     2.095    10.861     0.200
     2.306    11.402     0.200
     2.344    11.604     0.200
     2.387    12.541     0.200
     2.558    14.667     0.200
     2.507    12.561     0.200
     2.864    12.572     0.200
     2.915    13.111     0.200
     2.988    13.489     0.200
     3.246    12.563     0.200
     3.223    13.511     0.200
     3.200    12.993     0.200
     3.244    13.292     0.200
     3.396    13.506     0.200
     3.529    13.730     0.200
     3.595    15.466     0.200
     3.569    15.189     0.200
     3.577    14.114     0.200
     3.749    14.376     0.200
     3.687    15.777     0.200
     3.806    15.221     0.200
     3.964    16.765     0.200
     4.047    15.786     0.200
     4.135    15.306     0.200
     4.134    15.163     0.200
     4.240    15.922     0.200
     4.259    15.954     0.200
     4.225    15.771     0.200
     4.280    16.850     0.200
     4.356    16.514     0.200
     4.525    16.516     0.200
     4.588    16.822     0.200
     4.826    17.127     0.200
     4.811    18.110     0.200
     5.075    17.187     0.200
     5.075    18.570     0.200
     5.100    18.549     0.200
     5.304    19.293     0.200
     5.516    17.293     0.200
     5.470    19.190     0.200
     5.504    18.345     0.200
     5.474    18.433     0.200
     5.697    19.007     0.200
    15.096    37.307     0.200
    15.201    38.858     0.200
    15.367    36.173     0.200
    15.786    36.500     0.200
    15.686    39.636     0.200
    15.684    40.161     0.200
    15.995    37.874     0.200
    16.186    39.366     0.200
     2.507    11.571     0.200
     3.244    12.785     0.200
     3.569    14.888     0.200
     5.681    19.483     0.200
     5.681    19.272     0.200
     5.681    19.678     0.200
     5.729    18.848     0.200
     6.230    21.151     0.200
     6.510    21.328     0.200
     7.049    21.689     0.200
     7.049    22.064     0.200
     8.294    23.611     0.200
     8.294    23.992     0.200
     8.882    26.607     0.200
     9.127    28.088     0.200
    10.372    31.649     0.200
    10.386    31.811     0.200
    12.230    31.410     0.200
    12.234    30.608     0.200
    12.291    31.499     0.200
    12.363    33.660     0.200
    12.728    35.002     0.200
    12.989    32.996     0.200
    14.234    39.478     0.200
    15.096    38.559     0.200
    15.786    38.263     0.200
    15.948    40.266     0.200
    16.186    39.677     0.200
     1.893    10.047     0.200
     1.916    10.547     0.200
     2.013    11.246     0.200
     2.060    12.339     0.200
     2.364    11.595     0.200
     2.399    11.455     0.200
     2.916    11.995     0.200
     2.961    12.555     0.200
     3.300    12.964     0.200
     3.274    13.914     0.200
     3.454    13.293     0.200
     3.804    13.952     0.200
     3.847    15.568     0.200
     4.095    15.974     0.200
     4.286    15.017     0.200
     4.632    17.039     0.200
     1.956    11.315     0.200
     2.085    10.665     0.200
     2.106    12.319     0.200
     2.307    11.232     0.200
     2.342    11.645     0.200
     2.372    12.924     0.200
     2.509    12.641     0.200
     2.860    12.429     0.200
     2.908    12.596     0.200
     2.972    13.259     0.200
     3.243    12.121     0.200
     3.218    13.439     0.200
     3.398    13.865     0.200
     3.524    14.056     0.200
     3.553    16.067     0.200
     3.747    13.944     0.200
     3.671    15.020     0.200
     4.041    15.842     0.200
     4.130    15.991     0.200
     4.233    16.042     0.200
     4.250    16.341     0.200
     4.249    16.374     0.200
     4.517    17.499     0.200
     4.580    17.615     0.200
     4.740    16.221     0.200
     4.820    18.239     0.200
     4.902    18.810     0.200
     5.514    17.779     0.200
     5.769    19.888     0.200
     5.854    20.206     0.200
     5.854    20.241     0.200
    15.368    36.733     0.200
    15.697    38.982     0.200
    15.787    37.291     0.200
    15.996    38.234     0.200
    16.723    39.980     0.200
    17.439    40.291     0.200
     1.929    10.246     0.200
     2.072    10.742     0.200
     2.280    10.926     0.200
     2.318    12.035     0.200
     2.372    12.748     0.200
     2.537    13.430     0.200
     2.837    12.682     0.200
     2.889    12.529     0.200
     2.974    14.032     0.200
     3.197    13.837     0.200
     3.370    13.886     0.200
     3.722    13.714     0.200
     2.534    13.369     0.200
     3.266    14.014     0.200
     3.572    16.647     0.200
     3.572    15.545     0.200
     5.666    19.210     0.200
     5.666    19.636     0.200
     6.246    22.481     0.200
     7.024    21.707     0.200
     7.024    20.367     0.200
    12.340    34.284     0.200
    12.255    32.854     0.200
    12.260    31.962     0.200
    12.717    35.222     0.200
    16.211    40.657     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.929    27.952     0.200
     8.568    59.783     0.200
     8.600    59.797     0.200
     8.597    61.610     0.200
     5.712    40.978     0.200
     2.718    18.193     0.200
     2.642    17.777     0.200
     2.954    19.665     0.200
     2.787    18.901     0.200
     3.076    20.771     0.200
     3.114    21.134     0.200
     2.533    17.437     0.200
     2.561    17.502     0.200
     2.905    19.885     0.200
     2.698    18.369     0.200
     4.583    32.433     0.200
     2.663    17.845     0.200
     2.911    19.535     0.200
     3.173    21.356     0.200
     2.520    17.777     0.200
     2.717    18.432     0.200
     2.801    18.935     0.200
     3.091    20.970     0.200
     2.580    17.210     0.200
     2.629    17.815     0.200
     2.832    18.854     0.200
     2.832    18.986     0.200
     3.615    25.111     0.200
     4.478    31.524     0.200
     2.549    17.094     0.200
     2.823    18.979     0.200
     3.153    21.305     0.200
     4.326    29.201     0.200
     4.806    32.523     0.200
     4.196    28.586     0.200
     3.674    25.205     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.562     4.621     0.200
     1.222     8.020     0.200
     0.322     2.654     0.200
     0.456     2.834     0.200
     0.589     5.118     0.200
     0.732     4.740     0.200
     1.173     7.565     0.200
     0.449     3.024     0.200
     0.580     5.014     0.200
     0.729     4.593     0.200
     1.165     7.445     0.200
     1.204     7.802     0.200
     0.267     1.668     0.200
     0.626     5.223     0.200
     1.106     6.958     0.200
     5.000    31.618     0.200
     0.573     5.339     0.200
     1.156     7.834     0.200
     1.599    10.057     0.200
     2.177    12.316     0.200
     3.992    25.934     0.200
     6.972    46.766     0.200
     0.574     5.290     0.200
     1.159     7.453     0.200
     1.609    10.204     0.200
     2.184    12.422     0.200
     0.438     3.048     0.200
     0.441     3.059     0.200
     0.706     4.562     0.200
     1.176     7.468     0.200
     1.206     7.742     0.200
     1.292     7.085     0.200
     0.263     1.938     0.200
     0.328     2.488     0.200
     0.563     3.651     0.200
     0.752     5.812     0.200
     1.223     8.343     0.200
     1.565     7.915     0.200
     1.595     9.585     0.200
     0.263     2.396     0.200
     0.275     2.561     0.200
     0.468     4.405     0.200
     1.224     8.246     0.200
     1.391     8.431     0.200
     4.905    32.090     0.200
     0.193     1.733     0.200
     0.484     3.431     0.200
     0.597     5.215     0.200
     1.105     7.282     0.200
     1.198     6.392     0.200
     1.232     7.740     0.200
     1.459     9.451     0.200
     1.633     9.824     0.200
     1.661     9.892     0.200
     1.762    10.818     0.200
     0.294     2.006     0.200
     0.537     4.465     0.200
     0.620     4.308     0.200
     1.042     7.571     0.200
     1.405     9.143     0.200
     1.511     8.697     0.200
     0.278     1.807     0.200
     0.327     2.532     0.200
     1.203     8.189     0.200
     1.222     7.968     0.200
     1.421     9.263     0.200
     1.588     9.920     0.200
     1.603     9.902     0.200
     5.249    32.494     0.200
     0.277     2.362     0.200
     0.360     2.828     0.200
     0.569     3.907     0.200
     0.681     5.593     0.200
     1.135     7.091     0.200
     1.191     7.768     0.200
     5.214    32.448     0.200
     0.274     2.510     0.200
     0.369     2.882     0.200
     0.564     4.028     0.200
     0.678     5.651     0.200
     1.146     6.799     0.200
     1.184     7.617     0.200
     5.202    32.299     0.200
     0.228     1.544     0.200
     0.427     3.318     0.200
     0.621     5.058     0.200
     1.253     7.183     0.200
     1.161     7.698     0.200
     1.541     9.520     0.200
     1.699     9.078     0.200
     1.714    10.104     0.200
     1.740    10.601     0.200
     0.219     1.430     0.200
     0.433     3.135     0.200
     0.608     5.083     0.200
     0.865     6.390     0.200
     1.268     7.091     0.200
     1.548     9.623     0.200
     1.713     9.298     0.200
     1.722     9.996     0.200
     0.172     1.063     0.200
     0.303     1.797     0.200
     0.469     4.337     0.200
     1.238     7.718     0.200
     1.377     8.846     0.200
     1.789    10.197     0.200
     1.852    10.654     0.200
     0.244     1.715     0.200
     0.484     3.156     0.200
     0.629     5.111     0.200
     1.137     7.256     0.200
     1.348     8.771     0.200
     1.571     9.643     0.200
     1.724     9.735     0.200
     1.744    10.547     0.200
     0.168     1.501     0.200
     0.539     4.692     0.200
     1.371     8.968     0.200
     1.151     7.462     0.200
     1.329     8.860     0.200
     1.506     9.390     0.200
     1.563     8.585     0.200
     5.297    34.298     0.200
     0.660     5.436     0.200
     1.207     7.845     0.200
     0.298     1.955     0.200
     0.285     1.802     0.200
     0.591     3.665     0.200
     0.683     5.360     0.200
     1.080     5.885     0.200
     1.249     8.379     0.200
     1.521     8.228     0.200
     1.623     8.840     0.200
     1.768     9.270     0.200
     5.283    33.290     0.200
     0.453     3.157     0.200
     0.629     4.800     0.200
     0.879     6.346     0.200
     1.211     7.633     0.200
     1.290     6.819     0.200
     1.338     8.466     0.200
     1.562     9.150     0.200
     3.960    26.244     0.200
     5.079    31.443     0.200
     0.434     3.072     0.200
     0.440     3.152     0.200
     0.614     5.015     0.200
     0.867     6.418     0.200
     1.203     7.506     0.200
     1.289     6.311     0.200
     1.326     8.443     0.200
     1.551     9.176     0.200
     5.087    30.047     0.200
     5.087    32.141     0.200
     8.422    56.370     0.200
     8.616    57.783     0.200
     0.457     3.054     0.200
     0.632     5.135     0.200
     0.876     6.572     0.200
     1.162     7.318     0.200
     1.207     7.926     0.200
     1.285     6.595     0.200
     1.559     9.348     0.200
     5.082    31.695     0.200
     0.482     3.097     0.200
     0.658     5.125     0.200
     0.888     6.690     0.200
     1.139     7.807     0.200
     1.213     7.679     0.200
     1.277     6.910     0.200
     1.570     9.705     0.200
     1.725     8.818     0.200
     5.079    30.501     0.200
     5.079    30.743     0.200
     0.465     2.982     0.200
     1.160     7.495     0.200
     1.203     8.211     0.200
     1.277     7.100     0.200
     1.557     9.559     0.200
     1.723     9.084     0.200
     5.087    30.820     0.200
     0.682     4.349     0.200
     0.686     4.616     0.200
     1.243     8.521     0.200
     1.498     8.906     0.200
     1.618     9.964     0.200
     5.196    32.105     0.200
     0.633     5.035     0.200
     0.872     6.505     0.200
     1.196     7.254     0.200
     1.280     7.029     0.200
     5.087    31.140     0.200
     0.382     2.732     0.200
     0.462     3.158     0.200
     0.643     4.977     0.200
     0.814     6.037     0.200
     0.878     5.376     0.200
     0.939     6.342     0.200
     1.023     5.636     0.200
     1.226     7.555     0.200
     1.238     7.206     0.200
     1.227     7.997     0.200
     1.341     8.121     0.200
     1.420     8.324     0.200
     1.491     9.615     0.200
     1.518     9.400     0.200
     1.626     9.068     0.200
     1.616     9.349     0.200
     1.676     9.234     0.200
     0.226     2.078     0.200
     0.460     3.187     0.200
     0.490     4.286     0.200
     0.656     5.384     0.200
     0.758     5.055     0.200
     0.800     5.537     0.200
     0.947     6.568     0.200
     1.076     7.345     0.200
     1.125     7.750     0.200
     1.167     7.335     0.200
     1.167     7.164     0.200
     1.209     7.108     0.200
     1.280     7.207     0.200
     1.345     7.949     0.200
     1.364     7.281     0.200
     1.378     8.544     0.200
     1.366     8.967     0.200
     1.496    10.310     0.200
     1.429     9.913     0.200
     1.467     8.730     0.200
     1.521     7.953     0.200
     1.580     8.228     0.200
     1.733    10.802     0.200
     1.788    11.066     0.200
     0.373     2.290     0.200
     0.518     3.335     0.200
     0.776     5.333     0.200
     0.959     6.720     0.200
     1.194     7.868     0.200
     1.261     8.648     0.200
     1.632     8.605     0.200
     1.663    10.546     0.200
     1.734    10.701     0.200
     1.757    10.538     0.200
     2.332    14.177     0.200
     4.676    31.043     0.200
     0.331     2.600     0.200
     0.331     2.379     0.200
     0.534     3.723     0.200
     0.583     4.862     0.200
     0.680     5.326     0.200
     0.760     5.864     0.200
     0.812     5.711     0.200
     0.867     6.114     0.200
     0.979     6.960     0.200
     1.163     7.314     0.200
     1.227     7.994     0.200
     1.313     8.063     0.200
     1.283     8.862     0.200
     1.332     8.264     0.200
     1.445     9.020     0.200
     1.549     9.034     0.200
     1.540     8.192     0.200
     1.644    10.216     0.200
     1.710    10.788     0.200
     1.801    11.106     0.200
     1.801    10.575     0.200
     2.312    13.639     0.200
     0.239     1.849     0.200
     0.356     2.336     0.200
     0.356     2.438     0.200
     0.529     3.480     0.200
     0.609     4.640     0.200
     0.681     5.168     0.200
     0.789     5.553     0.200
     0.893     6.063     0.200
     0.963     6.857     0.200
     1.189     8.151     0.200
     1.205     7.789     0.200
     1.205     8.008     0.200
     1.347     9.329     0.200
     1.266     8.930     0.200
     1.575     9.350     0.200
     1.650     9.930     0.200
     1.650    10.299     0.200
     1.719    10.572     0.200
     2.318    13.891     0.200
     5.194    32.508     0.200
     6.235    36.616     0.200
     6.612    38.990     0.200
     0.548     3.383     0.200
     0.548     3.467     0.200
     0.613     4.207     0.200
     0.736     5.670     0.200
     0.845     5.989     0.200
     0.978     7.226     0.200
     1.004     5.160     0.200
     1.038     6.598     0.200
     1.083     7.595     0.200
     1.083     7.325     0.200
     1.095     5.826     0.200
     1.136     7.863     0.200
     1.274     8.766     0.200
     1.287     8.679     0.200
     1.308     7.563     0.200
     1.382     9.205     0.200
     1.474     9.046     0.200
     1.493     8.340     0.200
     1.617     8.732     0.200
     1.608     9.985     0.200
     1.659    10.428     0.200
     1.696    10.686     0.200
     1.696    10.485     0.200
     1.727     9.629     0.200
     1.767    10.598     0.200
     1.769     9.852     0.200
     1.783    11.460     0.200
     1.783    11.290     0.200
     1.826    10.861     0.200
     1.889    10.567     0.200
     1.892    10.540     0.200
     2.749    17.465     0.200
     0.257     1.355     0.200
     0.340     2.203     0.200
     0.588     4.620     0.200
     0.553     3.595     0.200
     0.765     5.487     0.200
     0.867     5.677     0.200
     0.923     4.909     0.200
     0.962     6.823     0.200
     1.072     7.962     0.200
     1.137     6.146     0.200
     1.137     7.337     0.200
     1.166     8.078     0.200
     1.166     8.226     0.200
     1.182     6.348     0.200
     1.182     6.207     0.200
     1.214     8.156     0.200
     1.214     8.345     0.200
     1.267     9.159     0.200
     1.267     8.547     0.200
     1.321     7.219     0.200
     1.408     8.987     0.200
     1.445     9.371     0.200
     1.533     8.024     0.200
     1.533     8.325     0.200
     1.550     9.510     0.200
     1.581     8.162     0.200
     1.610     9.905     0.200
     1.628    10.212     0.200
     1.625    10.658     0.200
     1.683     9.605     0.200
     1.711     9.404     0.200
     1.711     9.283     0.200
     1.823    10.939     0.200
     1.848    10.830     0.200
     1.807    10.725     0.200
     1.807    11.635     0.200
     2.293    14.800     0.200
     0.405     2.604     0.200
     0.416     2.660     0.200
     0.680     5.231     0.200
     0.789     5.572     0.200
     0.985     6.404     0.200
     1.021     7.282     0.200
     1.086     6.068     0.200
     1.216     8.074     0.200
     1.266     8.103     0.200
     1.300     7.256     0.200
     1.315     9.087     0.200
     1.331     7.320     0.200
     1.434     9.962     0.200
     1.668     9.972     0.200
     1.683     9.597     0.200
     1.736     9.494     0.200
     1.782    10.716     0.200
     1.854    10.933     0.200
     0.234     1.880     0.200
     0.332     2.372     0.200
     0.332     2.560     0.200
     0.584     4.640     0.200
     0.584     4.859     0.200
     0.531     3.631     0.200
     0.761     5.841     0.200
     0.801     4.657     0.200
     0.801     4.837     0.200
     0.812     5.760     0.200
     0.870     6.118     0.200
     0.980     6.964     0.200
     1.075     7.370     0.200
     1.165     7.594     0.200
     1.192     6.483     0.200
     1.227     8.029     0.200
     1.227     7.849     0.200
     1.359     9.427     0.200
     1.284     9.152     0.200
     1.335     7.904     0.200
     1.414     7.995     0.200
     1.543     8.320     0.200
     1.543     8.671     0.200
     1.551     9.241     0.200
     1.593     8.421     0.200
     1.647    10.257     0.200
     1.647    10.375     0.200
     1.714    10.549     0.200
     0.177     1.153     0.200
     0.413     2.843     0.200
     0.413     2.796     0.200
     0.431     2.787     0.200
     0.600     4.867     0.200
     0.676     5.267     0.200
     0.776     5.375     0.200
     0.845     6.324     0.200
     0.918     5.335     0.200
     0.977     6.776     0.200
     1.000     7.029     0.200
     1.066     5.795     0.200
     1.184     7.987     0.200
     1.202     7.792     0.200
     1.261     8.293     0.200
     1.280     6.995     0.200
     1.283     6.935     0.200
     1.295     9.190     0.200
     1.410     9.717     0.200
     1.410     9.493     0.200
     1.315     7.133     0.200
     1.380     8.117     0.200
     1.463     8.453     0.200
     1.531     9.259     0.200
     1.555     9.591     0.200
     1.650     9.741     0.200
     1.667     9.053     0.200
     1.706    10.199     0.200
     1.719     9.097     0.200
     1.740    10.179     0.200
     1.756    10.919     0.200
     1.809     9.948     0.200
     1.829    11.263     0.200
     2.130    13.270     0.200
     5.105    32.610     0.200
     0.342     2.181     0.200
     0.404     2.331     0.200
     0.668     4.832     0.200
     0.846     5.496     0.200
     0.940     6.067     0.200
     0.982     6.725     0.200
     1.087     7.269     0.200
     1.117     6.795     0.200
     1.253     8.154     0.200
     1.275     8.781     0.200
     1.289     8.444     0.200
     1.331     8.383     0.200
     1.347     7.721     0.200
     1.380     9.701     0.200
     1.502    10.086     0.200
     1.700     9.478     0.200
     1.756     9.624     0.200
     1.838    11.314     0.200
     1.907    11.886     0.200
     2.213    14.867     0.200
     0.398     2.485     0.200
     0.439     2.631     0.200
     0.703     5.178     0.200
     0.776     5.433     0.200
     0.955     5.856     0.200
     1.009     6.555     0.200
     1.016     7.101     0.200
     1.107     6.308     0.200
     1.204     8.106     0.200
     1.238     7.847     0.200
     1.289     8.430     0.200
     1.321     7.497     0.200
     1.308     9.143     0.200
     1.435     9.872     0.200
     1.706     9.675     0.200
     1.758     9.857     0.200
     1.795    11.424     0.200
     1.869    11.634     0.200
     1.891    11.467     0.200
     0.155     0.795     0.200
     0.393     2.727     0.200
     0.425     2.709     0.200
     0.425     2.768     0.200
     0.689     5.533     0.200
     0.790     5.391     0.200
     0.943     5.429     0.200
     0.943     5.750     0.200
     1.027     7.069     0.200
     1.203     8.031     0.200
     1.218     7.646     0.200
     1.218     8.248     0.200
     1.240     7.660     0.200
     1.275     8.453     0.200
     1.320     8.979     0.200
     1.443     9.811     0.200
     1.402     9.187     0.200
     1.496     8.556     0.200
     1.554     9.209     0.200
     1.696     9.533     0.200
     1.696     9.732     0.200
     1.749     9.748     0.200
     1.749     9.508     0.200
     1.759    10.521     0.200
     1.795    10.872     0.200
     1.868    11.207     0.200
     1.868    11.357     0.200
     0.421     2.735     0.200
     0.515     3.327     0.200
     0.676     4.837     0.200
     0.732     5.321     0.200
     0.890     5.019     0.200
     0.929     6.722     0.200
     1.010     5.517     0.200
     1.152     7.826     0.200
     1.224     7.537     0.200
     1.257     8.197     0.200
     1.238     7.900     0.200
     1.228     8.750     0.200
     1.330     9.238     0.200
     1.276     7.732     0.200
     1.626     9.337     0.200
     1.673     9.452     0.200
     1.676    10.167     0.200
     1.712     9.982     0.200
     1.721    11.537     0.200
     1.751    10.788     0.200
     1.801    10.473     0.200
     2.344    14.667     0.200
     2.943    18.060     0.200
     3.303    21.071     0.200
     0.211     1.691     0.200
     0.377     2.865     0.200
     0.377     2.720     0.200
     0.377     2.853     0.200
     0.491     3.234     0.200
     0.491     3.340     0.200
     0.491     3.394     0.200
     0.635     5.061     0.200
     0.649     5.113     0.200
     0.705     4.158     0.200
     0.809     6.132     0.200
     0.780     5.458     0.200
     0.861     4.857     0.200
     0.998     5.402     0.200
     0.974     6.902     0.200
     0.974     7.031     0.200
     1.038     5.992     0.200
     1.038     6.184     0.200
     1.133     7.615     0.200
     1.213     6.303     0.200
     1.213     6.561     0.200
     1.215     6.492     0.200
     1.218     8.077     0.200
     1.201     7.832     0.200
     1.201     7.961     0.200
     1.253     6.688     0.200
     1.369     9.569     0.200
     1.369     9.448     0.200
     1.275     8.866     0.200
     1.326     7.759     0.200
     1.278     8.200     0.200
     1.396     7.956     0.200
     1.474     7.999     0.200
     1.490     9.343     0.200
     1.505     9.289     0.200
     1.605     9.005     0.200
     1.691    10.378     0.200
     1.691    10.546     0.200
     1.762    10.931     0.200
     1.768    10.736     0.200
     0.325     2.053     0.200
     0.540     3.475     0.200
     0.540     3.513     0.200
     0.552     3.426     0.200
     0.618     4.202     0.200
     0.747     4.403     0.200
     0.747     4.289     0.200
     0.794     6.233     0.200
     0.844     5.879     0.200
     1.042     6.702     0.200
     1.113     7.110     0.200
     1.124     7.162     0.200
     1.136     7.779     0.200
     1.270     8.696     0.200
     1.619     9.669     0.200
     1.625    10.752     0.200
     1.639     9.958     0.200
     1.686    10.338     0.200
     1.716     9.473     0.200
     1.758     9.337     0.200
     1.773    11.309     0.200
     2.108    14.528     0.200
     2.213    13.194     0.200
     2.352    15.167     0.200
     2.513    16.431     0.200
     2.834    17.812     0.200
     3.186    20.366     0.200
     0.374     3.003     0.200
     0.374     3.101     0.200
     0.492     3.584     0.200
     0.514     3.500     0.200
     0.514     3.399     0.200
     0.629     5.126     0.200
     0.681     4.237     0.200
     0.776     5.612     0.200
     0.961     6.911     0.200
     0.977     5.693     0.200
     1.056     6.350     0.200
     1.117     7.217     0.200
     1.192     7.031     0.200
     1.194     6.665     0.200
     1.194     8.063     0.200
     1.194     7.931     0.200
     1.351     9.445     0.200
     1.262     8.829     0.200
     1.286     8.303     0.200
     1.667    10.182     0.200
     1.667    10.026     0.200
     1.738    10.498     0.200
     1.754    10.260     0.200
     1.756    10.324     0.200
     0.234     2.077     0.200
     0.380     2.940     0.200
     0.380     2.905     0.200
     0.380     3.014     0.200
     0.486     3.639     0.200
     0.515     3.384     0.200
     0.634     4.944     0.200
     0.673     5.351     0.200
     0.683     4.132     0.200
     0.770     5.638     0.200
     0.956     7.002     0.200
     0.980     5.815     0.200
     0.980     5.495     0.200
     1.051     6.355     0.200
     1.116     7.276     0.200
     1.195     7.131     0.200
     1.195     6.744     0.200
     1.197     6.499     0.200
     1.188     8.115     0.200
     1.188     7.935     0.200
     1.347     9.472     0.200
     1.257     8.845     0.200
     1.280     8.339     0.200
     1.378     8.291     0.200
     1.591     8.691     0.200
     1.591     8.878     0.200
     1.667     9.976     0.200
     1.739    10.417     0.200
     1.749    10.225     0.200
     2.235    14.000     0.200
     2.984    18.587     0.200
     3.097    19.554     0.200
     0.372     2.730     0.200
     0.372     2.762     0.200
     0.497     3.416     0.200
     0.568     3.820     0.200
     0.617     4.617     0.200
     0.628     3.674     0.200
     0.769     5.623     0.200
     0.930     4.940     0.200
     0.930     6.772     0.200
     1.064     6.860     0.200
     1.097     6.580     0.200
     1.097     6.448     0.200
     1.145     6.346     0.200
     1.147     6.128     0.200
     1.181     7.949     0.200
     1.309     9.203     0.200
     1.309     8.937     0.200
     1.234     8.644     0.200
     1.305     8.473     0.200
     1.547     8.079     0.200
     1.593     8.899     0.200
     1.613    10.091     0.200
     1.684    10.601     0.200
     1.730    10.361     0.200
     1.790    10.501     0.200
     2.281    13.769     0.200
     2.281    13.542     0.200
     2.706    17.504     0.200
     3.014    18.699     0.200
     0.284     2.272     0.200
     0.368     2.770     0.200
     0.503     3.413     0.200
     0.612     4.705     0.200
     0.575     3.706     0.200
     0.619     3.756     0.200
     0.726     5.416     0.200
     0.806     4.623     0.200
     0.806     4.403     0.200
     0.772     5.657     0.200
     0.921     4.920     0.200
     0.930     6.795     0.200
     1.058     6.920     0.200
     1.136     6.201     0.200
     1.106     6.496     0.200
     1.186     7.817     0.200
     1.183     7.934     0.200
     1.183     7.774     0.200
     1.306     9.264     0.200
     1.234     8.719     0.200
     1.319     8.045     0.200
     1.312     8.481     0.200
     1.420     7.640     0.200
     1.538     7.931     0.200
     1.584     7.713     0.200
     1.605    10.218     0.200
     1.630     9.580     0.200
     1.644     9.710     0.200
     1.676    10.568     0.200
     1.730    10.244     0.200
     2.274    13.718     0.200
     4.427    28.015     0.200
     0.431     2.690     0.200
     0.420     2.565     0.200
     0.420     2.558     0.200
     0.468     3.115     0.200
     0.683     5.080     0.200
     0.770     5.160     0.200
     0.777     4.174     0.200
     0.925     6.273     0.200
     0.969     5.551     0.200
     0.969     5.795     0.200
     0.996     6.938     0.200
     1.071     5.870     0.200
     1.197     7.656     0.200
     1.197     7.533     0.200
     1.232     7.767     0.200
     1.269     8.206     0.200
     1.288     8.245     0.200
     1.291     8.746     0.200
     1.322     7.596     0.200
     1.408     9.469     0.200
     1.673     9.713     0.200
     1.674     9.408     0.200
     1.725     9.864     0.200
     1.758    10.751     0.200
     1.758    10.504     0.200
     1.783    10.709     0.200
     1.781    11.845     0.200
     1.832    11.216     0.200
     2.924    18.531     0.200
     0.212     2.117     0.200
     0.389     3.103     0.200
     0.389     3.054     0.200
     0.480     3.559     0.200
     0.480     3.450     0.200
     0.487     3.246     0.200
     0.487     3.586     0.200
     0.648     5.089     0.200
     0.713     4.414     0.200
     0.648     5.260     0.200
     0.771     5.584     0.200
     0.874     5.683     0.200
     0.939     6.384     0.200
     0.969     7.063     0.200
     1.009     5.888     0.200
     1.009     5.997     0.200
     1.025     6.321     0.200
     1.145     7.589     0.200
     1.192     8.057     0.200
     1.224     7.066     0.200
     1.224     7.716     0.200
     1.226     7.335     0.200
     1.231     7.843     0.200
     1.231     8.052     0.200
     1.265     7.228     0.200
     1.265     7.368     0.200
     1.368     9.664     0.200
     1.269     8.978     0.200
     1.265     8.211     0.200
     1.339     8.044     0.200
     1.407     8.409     0.200
     1.487     8.921     0.200
     1.502     8.693     0.200
     1.697    10.639     0.200
     1.769    10.522     0.200
     1.797    10.377     0.200
     1.797    10.528     0.200
     2.965    17.963     0.200
     0.182     1.086     0.200
     0.442     3.055     0.200
     0.406     2.900     0.200
     0.406     2.884     0.200
     0.476     3.245     0.200
     0.609     4.594     0.200
     0.609     5.183     0.200
     0.669     5.183     0.200
     0.669     5.421     0.200
     0.776     5.347     0.200
     0.761     4.265     0.200
     0.908     5.474     0.200
     0.908     5.322     0.200
     0.986     5.821     0.200
     0.986     5.981     0.200
     0.968     6.722     0.200
     0.968     6.979     0.200
     0.994     6.913     0.200
     1.054     5.687     0.200
     1.201     7.546     0.200
     1.201     7.718     0.200
     1.201     7.839     0.200
     1.175     7.394     0.200
     1.245     8.030     0.200
     1.254     7.289     0.200
     1.291     8.813     0.200
     1.268     6.744     0.200
     1.268     6.987     0.200
     1.271     6.781     0.200
     1.402     9.531     0.200
     1.304     6.930     0.200
     1.304     7.332     0.200
     1.371     8.157     0.200
     1.451     7.873     0.200
     1.656     8.912     0.200
     1.656     9.033     0.200
     1.744    10.859     0.200
     1.744    10.968     0.200
     1.791    10.888     0.200
     1.782    10.922     0.200
     1.782    10.793     0.200
     1.782    11.782     0.200
     1.799     9.109     0.200
     2.181    13.437     0.200
     2.413    15.370     0.200
     2.413    14.041     0.200
     3.175    19.845     0.200
     3.595    21.469     0.200
     5.114    30.734     0.200
     0.220     1.917     0.200
     0.388     3.035     0.200
     0.388     3.040     0.200
     0.496     3.315     0.200
     0.480     3.458     0.200
     0.645     5.168     0.200
     0.657     4.707     0.200
     0.704     4.472     0.200
     0.769     5.675     0.200
     0.769     5.785     0.200
     0.935     6.434     0.200
     0.964     7.089     0.200
     1.001     6.073     0.200
     1.001     5.873     0.200
     1.032     6.385     0.200
     1.032     6.200     0.200
     1.135     7.534     0.200
     1.189     7.958     0.200
     1.215     7.122     0.200
     1.218     6.987     0.200
     1.259     7.187     0.200
     1.259     7.357     0.200
     1.268     8.193     0.200
     1.360     9.583     0.200
     1.264     9.037     0.200
     1.399     7.443     0.200
     1.513     9.225     0.200
     1.610     8.918     0.200
     1.688    10.060     0.200
     1.688    10.181     0.200
     1.732    10.327     0.200
     1.759    10.393     0.200
     2.219    13.384     0.200
     3.335    21.215     0.200
     0.465     2.743     0.200
     0.479     2.928     0.200
     0.479     2.942     0.200
     0.476     3.016     0.200
     0.506     3.350     0.200
     0.676     4.819     0.200
     0.712     4.895     0.200
     0.815     4.271     0.200
     0.786     5.464     0.200
     0.765     4.959     0.200
     0.867     5.488     0.200
     0.919     6.918     0.200
     1.025     5.786     0.200
     1.028     5.604     0.200
     1.127     7.940     0.200
     1.090     7.247     0.200
     1.211     6.821     0.200
     1.214     8.504     0.200
     1.214     7.610     0.200
     1.214     8.655     0.200
     1.215     7.083     0.200
     1.215     6.970     0.200
     1.332     8.426     0.200
     1.422     8.783     0.200
     1.422     8.963     0.200
     1.464     7.525     0.200
     1.500     9.424     0.200
     1.615     8.644     0.200
     1.591    10.624     0.200
     1.632     9.003     0.200
     1.646     7.890     0.200
     1.650    10.169     0.200
     1.773     8.556     0.200
     1.747    10.815     0.200
     1.828    10.924     0.200
     1.879    11.830     0.200
     2.090    12.847     0.200
     2.236    13.170     0.200
     2.340    14.102     0.200
     0.374     2.801     0.200
     0.374     2.812     0.200
     0.493     3.436     0.200
     0.554     3.747     0.200
     0.622     4.826     0.200
     0.768     5.617     0.200
     0.824     4.612     0.200
     0.944     5.348     0.200
     0.936     6.814     0.200
     1.078     6.980     0.200
     1.084     6.619     0.200
     1.158     6.907     0.200
     1.161     6.970     0.200
     1.199     7.874     0.200
     1.182     7.801     0.200
     1.182     7.909     0.200
     1.209     6.574     0.200
     1.319     9.208     0.200
     1.319     9.323     0.200
     1.240     8.955     0.200
     1.298     8.528     0.200
     1.559     8.399     0.200
     1.628    10.094     0.200
     1.628    10.390     0.200
     1.698    10.722     0.200
     1.735    10.626     0.200
     1.800    10.626     0.200
     2.296    13.891     0.200
     0.255     1.498     0.200
     0.255     1.504     0.200
     0.503     3.968     0.200
     0.553     3.561     0.200
     0.612     3.588     0.200
     0.881     4.878     0.200
     0.886     5.805     0.200
     1.034     6.860     0.200
     1.034     7.090     0.200
     1.095     6.544     0.200
     1.103     6.944     0.200
     1.121     6.363     0.200
     1.170     6.965     0.200
     1.392     9.292     0.200
     1.296     8.360     0.200
     1.340     9.185     0.200
     1.412     9.011     0.200
     1.412     9.222     0.200
     1.473     8.220     0.200
     1.630    10.116     0.200
     1.630    10.315     0.200
     1.660     9.782     0.200
     1.688    10.463     0.200
     1.736    10.170     0.200
     1.919    11.526     0.200
     0.425     2.635     0.200
     0.433     2.626     0.200
     0.433     2.759     0.200
     0.460     3.152     0.200
     0.696     5.055     0.200
     0.763     5.217     0.200
     0.939     5.396     0.200
     0.955     5.645     0.200
     0.994     6.934     0.200
     1.085     5.881     0.200
     1.190     7.703     0.200
     1.219     7.907     0.200
     1.219     8.094     0.200
     1.210     7.860     0.200
     1.210     8.079     0.200
     1.282     8.220     0.200
     1.282     7.821     0.200
     1.299     7.224     0.200
     1.302     6.890     0.200
     1.410     9.554     0.200
     1.410     9.679     0.200
     1.336     7.855     0.200
     1.688     9.177     0.200
     1.768    11.527     0.200
     1.768    11.331     0.200
     1.773    10.203     0.200
     1.778    11.832     0.200
     1.871    11.030     0.200
     0.247     1.917     0.200
     0.275     2.111     0.200
     0.481     4.395     0.200
     0.485     3.655     0.200
     0.585     4.108     0.200
     0.585     4.092     0.200
     0.769     4.678     0.200
     0.799     5.720     0.200
     0.847     6.221     0.200
     1.105     7.776     0.200
     1.120     7.276     0.200
     1.120     7.386     0.200
     1.127     6.771     0.200
     1.127     6.880     0.200
     1.228     8.252     0.200
     1.297     7.543     0.200
     1.409     8.700     0.200
     1.409     8.872     0.200
     1.429     8.804     0.200
     1.556    10.815     0.200
     1.486     8.341     0.200
     1.486     8.083     0.200
     1.511     8.544     0.200
     1.511     8.701     0.200
     1.514     8.735     0.200
     1.533     8.472     0.200
     1.577     8.905     0.200
     1.748    10.411     0.200
     1.748    10.520     0.200
     1.854    10.982     0.200
     1.975    12.212     0.200
     1.991    11.731     0.200
     2.787    15.985     0.200
     0.522     2.879     0.200
     0.594     3.639     0.200
     0.656     4.230     0.200
     0.842     5.786     0.200
     0.950     6.630     0.200
     0.950     6.739     0.200
     0.993     6.370     0.200
     0.993     6.471     0.200
     1.023     5.232     0.200
     1.026     5.233     0.200
     1.094     6.614     0.200
     1.094     7.450     0.200
     1.290     8.950     0.200
     1.220     7.226     0.200
     1.238     8.526     0.200
     1.523     9.670     0.200
     1.599     8.349     0.200
     1.585     9.622     0.200
     1.756    12.037     0.200
     1.756    12.162     0.200
     1.932    11.736     0.200
     1.932    11.408     0.200
     1.879    10.965     0.200
     2.306    13.561     0.200
     2.287    13.439     0.200
     0.345     2.533     0.200
     0.371     2.902     0.200
     0.371     2.922     0.200
     0.550     3.242     0.200
     0.527     3.332     0.200
     0.527     3.441     0.200
     0.597     4.704     0.200
     0.642     4.118     0.200
     0.642     4.251     0.200
     0.763     3.744     0.200
     0.777     5.480     0.200
     0.788     5.912     0.200
     0.859     4.159     0.200
     0.859     4.339     0.200
     0.853     5.111     0.200
     0.901     6.429     0.200
     0.993     6.417     0.200
     1.073     5.592     0.200
     1.075     5.569     0.200
     1.136     5.647     0.200
     1.259     8.804     0.200
     1.161     7.822     0.200
     1.165     6.917     0.200
     1.209     8.514     0.200
     1.235     7.251     0.200
     1.376     7.459     0.200
     1.347     8.207     0.200
     1.425     8.834     0.200
     1.441     8.928     0.200
     1.484     7.576     0.200
     1.527     7.469     0.200
     1.537     9.494     0.200
     1.537     9.596     0.200
     1.606     9.685     0.200
     1.705    10.456     0.200
     0.136     1.796     0.200
     0.307     2.353     0.200
     0.463     3.500     0.200
     0.489     4.198     0.200
     0.515     3.845     0.200
     0.898     5.719     0.200
     0.894     5.484     0.200
     0.894     5.374     0.200
     1.002     6.373     0.200
     1.092     7.664     0.200
     1.177     7.453     0.200
     1.218     7.632     0.200
     1.259     8.350     0.200
     1.259     8.150     0.200
     1.310     8.458     0.200
     1.310     8.315     0.200
     1.329     8.506     0.200
     1.391     8.689     0.200
     1.393     8.293     0.200
     1.408     7.895     0.200
     1.520    10.521     0.200
     1.608     9.712     0.200
     0.391     2.696     0.200
     0.428     2.767     0.200
     0.496     3.367     0.200
     0.767     4.580     0.200
     1.015     7.200     0.200
     0.992     5.766     0.200
     1.204     7.326     0.200
     1.222     7.725     0.200
     1.240     8.312     0.200
     1.261     8.190     0.200
     1.270     6.955     0.200
     1.421     9.721     0.200
     1.699     9.865     0.200
     1.755    11.188     0.200
     1.803    11.369     0.200
     0.302     2.422     0.200
     0.471     3.409     0.200
     0.471     3.361     0.200
     0.513     3.607     0.200
     0.513     3.785     0.200
     0.734     5.194     0.200
     0.827     5.846     0.200
     0.885     5.313     0.200
     0.906     5.871     0.200
     1.011     6.056     0.200
     1.051     6.748     0.200
     1.094     7.642     0.200
     1.186     7.137     0.200
     1.211     7.604     0.200
     1.211     7.737     0.200
     1.257     8.234     0.200
     1.257     8.125     0.200
     1.318     8.081     0.200
     1.335     8.746     0.200
     1.335     8.411     0.200
     1.381     9.418     0.200
     1.400     8.652     0.200
     1.402     8.556     0.200
     1.417     7.557     0.200
     1.523    10.650     0.200
     1.600     9.260     0.200
     1.600     8.539     0.200
     2.560    16.395     0.200
     2.877    17.713     0.200
     0.309     2.279     0.200
     0.466     3.225     0.200
     0.511     3.751     0.200
     0.899     5.718     0.200
     0.890     5.382     0.200
     1.089     7.580     0.200
     1.213     7.805     0.200
     1.254     7.855     0.200
     1.314     8.008     0.200
     1.328     8.646     0.200
     1.395     7.861     0.200
     1.517    10.460     0.200
     0.138     1.529     0.200
     0.306     2.433     0.200
     0.306     2.283     0.200
     0.466     3.489     0.200
     0.466     3.450     0.200
     0.514     3.757     0.200
     0.514     3.636     0.200
     0.514     3.933     0.200
     0.729     5.522     0.200
     0.827     5.940     0.200
     0.901     5.875     0.200
     0.901     5.675     0.200
     0.886     6.489     0.200
     0.890     5.474     0.200
     0.890     5.355     0.200
     1.005     5.942     0.200
     1.005     6.251     0.200
     1.045     6.839     0.200
     1.092     7.761     0.200
     1.180     7.284     0.200
     1.180     7.165     0.200
     1.215     7.867     0.200
     1.215     7.527     0.200
     1.258     8.478     0.200
     1.258     8.179     0.200
     1.254     7.886     0.200
     1.330     8.679     0.200
     1.313     8.206     0.200
     1.379     9.350     0.200
     1.394     8.190     0.200
     1.394     8.350     0.200
     1.396     8.371     0.200
     1.411     9.425     0.200
     1.521    10.470     0.200
     1.521    10.597     0.200
     1.411     7.303     0.200
     1.411     7.694     0.200
     1.456     8.174     0.200
     1.611     9.020     0.200
     1.605     9.353     0.200
     1.605     9.053     0.200
     1.622     9.382     0.200
     3.317    20.594     0.200
     0.334     2.223     0.200
     0.535     3.247     0.200
     0.535     3.033     0.200
     0.520     3.719     0.200
     0.602     3.669     0.200
     0.641     4.204     0.200
     0.695     3.747     0.200
     0.701     5.458     0.200
     0.779     5.430     0.200
     0.815     4.368     0.200
     0.968     6.901     0.200
     0.968     6.684     0.200
     0.980     6.641     0.200
     1.010     6.584     0.200
     1.029     6.648     0.200
     1.032     5.353     0.200
     1.077     6.448     0.200
     1.086     7.213     0.200
     1.086     7.672     0.200
     1.165     7.991     0.200
     1.309     9.178     0.200
     1.213     7.871     0.200
     1.217     7.057     0.200
     1.253     8.514     0.200
     1.253     8.385     0.200
     1.276     9.330     0.200
     1.309     7.648     0.200
     1.353     9.002     0.200
     1.427     7.793     0.200
     1.418     8.917     0.200
     1.418     8.622     0.200
     1.474     7.603     0.200
     1.535     9.635     0.200
     1.600     9.923     0.200
     1.603     8.813     0.200
     1.705    10.554     0.200
     1.762    10.628     0.200
     1.773    10.395     0.200
     1.773    11.639     0.200
     1.936    12.063     0.200
     2.206    12.637     0.200
     2.264    13.238     0.200
     0.403     2.891     0.200
     0.403     2.823     0.200
     0.428     2.924     0.200
     0.428     2.822     0.200
     0.485     3.410     0.200
     0.666     4.983     0.200
     0.772     4.456     0.200
     0.911     5.617     0.200
     0.968     5.592     0.200
     0.982     6.002     0.200
     1.008     7.109     0.200
     1.062     6.101     0.200
     1.204     7.621     0.200
     1.252     7.667     0.200
     1.252     7.780     0.200
     1.212     8.456     0.200
     1.212     7.931     0.200
     1.249     7.889     0.200
     1.276     7.551     0.200
     1.278     7.588     0.200
     1.309     7.434     0.200
     1.297     8.837     0.200
     1.417     9.809     0.200
     1.661     9.343     0.200
     1.688     9.785     0.200
     1.757    10.704     0.200
     1.757    11.078     0.200
     2.179    13.243     0.200
     2.940    17.123     0.200
     2.940    18.003     0.200
     0.369     2.573     0.200
     0.585     3.602     0.200
     0.850     5.402     0.200
     0.949     5.639     0.200
     0.986     5.721     0.200
     1.107     5.944     0.200
     1.215     8.291     0.200
     1.129     7.665     0.200
     1.324     7.863     0.200
     1.319     7.833     0.200
     1.310     8.702     0.200
     1.322     8.231     0.200
     1.322     8.805     0.200
     1.414    10.002     0.200
     1.423     9.338     0.200
     1.537    10.491     0.200
     1.702    10.347     0.200
     2.518    16.567     0.200
     2.980    18.742     0.200
     3.403    21.441     0.200
     0.264     1.828     0.200
     0.335     2.306     0.200
     0.335     2.176     0.200
     0.428     3.128     0.200
     0.428     3.238     0.200
     0.540     4.686     0.200
     0.589     4.131     0.200
     0.589     3.865     0.200
     0.589     4.024     0.200
     0.743     5.387     0.200
     0.774     4.195     0.200
     0.774     4.865     0.200
     0.774     4.663     0.200
     0.853     6.345     0.200
     0.853     5.765     0.200
     0.967     5.594     0.200
     0.967     5.754     0.200
     1.011     7.312     0.200
     1.045     7.352     0.200
     1.045     7.065     0.200
     1.091     6.556     0.200
     1.091     7.125     0.200
     1.091     7.006     0.200
     1.118     7.073     0.200
     1.172     7.139     0.200
     1.172     7.628     0.200
     1.172     7.779     0.200
     1.166     7.709     0.200
     1.271     7.628     0.200
     1.358     8.472     0.200
     1.374     8.596     0.200
     1.496    10.326     0.200
     1.406     9.478     0.200
     1.437     8.879     0.200
     1.437     9.049     0.200
     1.437     9.175     0.200
     1.486     9.287     0.200
     1.486     9.167     0.200
     1.488     8.323     0.200
     1.520     8.961     0.200
     1.575     9.097     0.200
     1.669     9.171     0.200
     1.702     9.566     0.200
     1.702    10.606     0.200
     1.702    10.476     0.200
     1.728     9.926     0.200
     1.795    10.804     0.200
     1.795    11.909     0.200
     1.984    12.341     0.200
     2.235    14.363     0.200
     2.845    18.303     0.200
     3.185    20.671     0.200
     3.636    22.330     0.200
     3.960    25.393     0.200
     4.170    25.695     0.200
     4.801    30.483     0.200
     0.277     1.792     0.200
     0.334     2.395     0.200
     0.334     2.416     0.200
     0.538     3.553     0.200
     0.577     4.516     0.200
     0.608     3.786     0.200
     0.576     3.571     0.200
     0.756     5.739     0.200
     0.720     5.215     0.200
     0.775     4.506     0.200
     0.806     5.621     0.200
     0.899     4.998     0.200
     0.955     6.775     0.200
     1.060     7.055     0.200
     1.060     6.899     0.200
     1.055     7.218     0.200
     1.113     6.246     0.200
     1.116     6.177     0.200
     1.160     6.301     0.200
     1.152     7.834     0.200
     1.133     6.930     0.200
     1.133     6.688     0.200
     1.324     9.014     0.200
     1.215     8.025     0.200
     1.215     8.140     0.200
     1.243     7.490     0.200
     1.296     7.289     0.200
     1.346     8.748     0.200
     1.611     9.601     0.200
     1.663     9.059     0.200
     1.687    10.534     0.200
     1.757    10.740     0.200
     1.840    11.041     0.200
     0.339     2.566     0.200
     0.448     3.266     0.200
     0.448     3.591     0.200
     0.526     3.520     0.200
     0.526     3.493     0.200
     0.763     5.615     0.200
     0.838     4.780     0.200
     0.790     6.050     0.200
     0.913     5.261     0.200
     1.043     7.251     0.200
     1.043     7.486     0.200
     1.054     6.656     0.200
     1.102     7.397     0.200
     1.193     7.254     0.200
     1.193     8.152     0.200
     1.211     7.121     0.200
     1.319     8.170     0.200
     1.375     9.039     0.200
     1.375     8.836     0.200
     1.482    10.334     0.200
     1.425     8.800     0.200
     1.428     7.923     0.200
     1.456     8.557     0.200
     1.548     8.828     0.200
     1.548     9.449     0.200
     2.259    13.096     0.200
     2.328    13.131     0.200
     2.484    14.318     0.200
     0.447     2.731     0.200
     0.447     3.113     0.200
     0.514     3.031     0.200
     0.514     2.437     0.200
     0.489     3.297     0.200
     0.489     3.078     0.200
     0.660     5.128     0.200
     0.717     5.181     0.200
     0.794     3.700     0.200
     0.851     4.823     0.200
     0.820     5.668     0.200
     0.820     5.816     0.200
     0.897     4.544     0.200
     0.925     5.922     0.200
     1.063     6.091     0.200
     1.066     6.066     0.200
     1.036     6.810     0.200
     1.176     8.250     0.200
     1.149     5.781     0.200
     1.108     7.416     0.200
     1.211     8.594     0.200
     1.211     8.094     0.200
     1.174     7.008     0.200
     1.315     8.248     0.200
     1.492     7.519     0.200
     1.479     9.262     0.200
     1.529     7.855     0.200
     1.555     9.677     0.200
     1.650     8.975     0.200
     1.625    10.722     0.200
     1.625    10.550     0.200
     1.792     8.772     0.200
     1.754    11.103     0.200
     1.879    12.124     0.200
     1.847    11.410     0.200
     1.847    11.293     0.200
     2.147    13.747     0.200
     2.155    14.790     0.200
     2.289    15.415     0.200
     3.035    19.192     0.200
     0.422     2.909     0.200
     0.422     3.151     0.200
     0.550     3.441     0.200
     0.550     3.503     0.200
     0.557     4.694     0.200
     0.736     4.887     0.200
     0.736     5.298     0.200
     0.917     5.223     0.200
     0.917     4.887     0.200
     1.022     7.039     0.200
     1.073     6.477     0.200
     1.073     6.618     0.200
     1.117     7.128     0.200
     1.167     7.616     0.200
     1.222     6.598     0.200
     1.222     6.708     0.200
     1.314     7.952     0.200
     1.314     8.131     0.200
     1.302     8.738     0.200
     1.369     8.988     0.200
     1.465     9.991     0.200
     1.400     8.684     0.200
     1.400     8.883     0.200
     1.436     7.796     0.200
     1.439     7.430     0.200
     1.473     8.143     0.200
     1.473     8.276     0.200
     1.531     8.546     0.200
     1.531     8.866     0.200
     1.527     8.593     0.200
     1.619     9.019     0.200
     1.662    10.142     0.200
     1.702     9.852     0.200
     1.713    10.314     0.200
     1.713    10.654     0.200
     1.713    10.494     0.200
     1.781    10.718     0.200
     1.781    11.921     0.200
     2.792    17.406     0.200
     3.103    19.304     0.200
     3.676    22.369     0.200
     4.205    25.850     0.200
     0.260     1.621     0.200
     0.260     1.520     0.200
     0.319     1.888     0.200
     0.548     3.262     0.200
     0.548     3.491     0.200
     0.634     3.813     0.200
     0.749     5.789     0.200
     0.750     4.820     0.200
     0.750     5.310     0.200
     0.810     4.867     0.200
     0.810     4.677     0.200
     0.891     6.057     0.200
     1.053     6.648     0.200
     1.053     7.409     0.200
     1.024     5.909     0.200
     1.060     5.998     0.200
     1.006     7.086     0.200
     1.035     6.901     0.200
     1.206     7.155     0.200
     1.189     7.935     0.200
     1.345     9.276     0.200
     1.326     8.772     0.200
     1.291     8.346     0.200
     1.315     9.355     0.200
     1.315     9.115     0.200
     1.412     7.828     0.200
     1.461     8.209     0.200
     1.461     8.020     0.200
     1.496     8.827     0.200
     1.447     9.253     0.200
     1.561     8.583     0.200
     1.556    10.078     0.200
     1.556     9.887     0.200
     1.593     9.201     0.200
     1.593     9.311     0.200
     1.614     9.730     0.200
     1.614     9.970     0.200
     1.707     9.013     0.200
     1.928    11.625     0.200
     0.360     2.741     0.200
     0.360     2.608     0.200
     0.505     3.244     0.200
     0.505     3.111     0.200
     0.650     3.945     0.200
     0.694     5.297     0.200
     0.783     5.246     0.200
     0.892     5.996     0.200
     0.946     5.313     0.200
     0.953     6.658     0.200
     0.953     6.776     0.200
     1.091     7.103     0.200
     1.160     6.328     0.200
     1.163     6.399     0.200
     1.207     6.326     0.200
     1.189     7.580     0.200
     1.189     8.087     0.200
     1.335     9.317     0.200
     1.198     7.844     0.200
     1.344     7.492     0.200
     1.307     8.110     0.200
     1.469     9.188     0.200
     1.464     9.194     0.200
     1.557     8.249     0.200
     1.638    10.342     0.200
     1.708    10.327     0.200
     1.752    10.378     0.200
     1.814    10.856     0.200
     0.366     2.608     0.200
     0.366     2.514     0.200
     0.500     3.394     0.200
     0.653     3.739     0.200
     0.694     5.498     0.200
     0.778     5.531     0.200
     0.898     6.243     0.200
     0.950     6.860     0.200
     0.950     4.996     0.200
     1.092     6.992     0.200
     1.080     6.485     0.200
     1.080     6.384     0.200
     1.193     7.195     0.200
     1.193     7.992     0.200
     1.201     8.108     0.200
     1.195     7.607     0.200
     1.195     7.880     0.200
     1.212     7.249     0.200
     1.333     9.385     0.200
     1.253     8.854     0.200
     1.301     8.528     0.200
     1.348     7.713     0.200
     1.640    10.235     0.200
     1.748    10.389     0.200
     1.809    10.753     0.200
     3.007    18.437     0.200
     0.318     2.808     0.200
     0.533     4.113     0.200
     0.533     3.918     0.200
     0.777     5.889     0.200
     0.797     5.927     0.200
     0.934     6.212     0.200
     0.934     6.032     0.200
     0.955     6.775     0.200
     1.062     7.878     0.200
     1.146     7.381     0.200
     1.208     7.962     0.200
     1.208     8.111     0.200
     1.228     7.275     0.200
     1.320     8.395     0.200
     1.405     9.280     0.200
     1.405     8.764     0.200
     0.249     1.590     0.200
     0.431     3.280     0.200
     0.586     3.844     0.200
     0.591     4.561     0.200
     0.679     3.827     0.200
     0.720     4.324     0.200
     0.802     5.119     0.200
     0.828     5.267     0.200
     0.945     6.614     0.200
     0.887     6.480     0.200
     0.927     5.918     0.200
     0.933     6.403     0.200
     1.028     6.035     0.200
     1.064     6.021     0.200
     1.061     6.809     0.200
     1.126     8.079     0.200
     1.370     8.172     0.200
     1.395     7.419     0.200
     1.380     9.599     0.200
     1.468     9.313     0.200
     1.517    10.021     0.200
     1.622     9.905     0.200
     1.650     9.802     0.200
     1.727     9.525     0.200
     1.753     9.442     0.200
     0.384     2.740     0.200
     0.484     3.134     0.200
     0.485     3.280     0.200
     0.714     4.170     0.200
     0.776     5.312     0.200
     0.870     5.124     0.200
     0.935     6.604     0.200
     0.975     6.944     0.200
     1.008     5.595     0.200
     1.148     7.170     0.200
     1.226     7.169     0.200
     1.198     8.023     0.200
     1.263     7.612     0.200
     1.247     8.214     0.200
     1.373     9.365     0.200
     1.274     8.779     0.200
     1.614     9.230     0.200
     1.664     9.421     0.200
     1.699    10.894     0.200
     1.770    10.750     0.200
     0.375     2.849     0.200
     0.434     3.358     0.200
     0.503     3.563     0.200
     0.768     5.567     0.200
     0.747     5.410     0.200
     0.871     5.238     0.200
     1.023     6.404     0.200
     1.013     6.957     0.200
     1.075     7.366     0.200
     1.171     6.647     0.200
     1.157     7.579     0.200
     1.177     8.361     0.200
     1.277     8.216     0.200
     1.354     8.698     0.200
     1.343     9.248     0.200
     1.447     9.935     0.200
     1.421     8.759     0.200
     1.737    10.192     0.200
     0.413     3.146     0.200
     0.413     2.839     0.200
     0.572     4.412     0.200
     0.650     3.023     0.200
     0.650     2.914     0.200
     0.689     4.000     0.200
     0.689     3.883     0.200
     0.767     4.091     0.200
     0.814     5.192     0.200
     0.838     5.440     0.200
     0.841     5.722     0.200
     0.876     6.070     0.200
     0.990     5.032     0.200
     1.088     7.322     0.200
     1.002     7.200     0.200
     1.087     6.068     0.200
     1.170     8.294     0.200
     1.184     8.201     0.200
     1.207     8.031     0.200
     1.331     6.964     0.200
     1.368     7.868     0.200
     1.497     8.496     0.200
     1.488     8.163     0.200
     1.511     7.650     0.200
     1.637     8.166     0.200
     2.003    11.702     0.200
     3.109    19.675     0.200
     3.155    18.177     0.200
     3.190    19.364     0.200
     0.468     4.158     0.200
     0.547     4.184     0.200
     0.644     5.099     0.200
     0.760     6.275     0.200
     0.967     6.931     0.200
     1.051     7.335     0.200
     1.268     7.753     0.200
     1.336     8.267     0.200
     1.314     7.930     0.200
     0.416     2.653     0.200
     0.419     2.799     0.200
     0.434     2.942     0.200
     0.681     5.112     0.200
     0.923     5.985     0.200
     0.923     5.575     0.200
     0.982     6.709     0.200
     0.994     7.068     0.200
     1.068     6.429     0.200
     1.068     6.566     0.200
     1.200     7.403     0.200
     1.267     8.169     0.200
     1.288     7.959     0.200
     1.288     8.580     0.200
     1.319     7.770     0.200
     1.406     9.715     0.200
     1.385     7.983     0.200
     1.465     8.904     0.200
     1.536     8.630     0.200
     1.535     8.897     0.200
     1.560     8.801     0.200
     1.671     9.561     0.200
     1.671     8.772     0.200
     1.676     8.886     0.200
     1.676     9.777     0.200
     1.755    10.438     0.200
     2.793    16.574     0.200
     0.422     2.775     0.200
     0.425     2.725     0.200
     0.431     2.933     0.200
     0.687     5.181     0.200
     0.929     6.487     0.200
     0.929     5.346     0.200
     0.988     6.630     0.200
     0.988     6.513     0.200
     1.074     5.602     0.200
     1.203     7.369     0.200
     1.273     8.187     0.200
     1.326     7.182     0.200
     1.326     7.049     0.200
     1.290     8.354     0.200
     1.290     8.495     0.200
     1.407     9.685     0.200
     1.472     8.057     0.200
     1.543     8.350     0.200
     1.567     8.976     0.200
     1.678     8.875     0.200
     1.669     9.404     0.200
     1.669     9.885     0.200
     1.760    10.785     0.200
     1.860    11.482     0.200
     2.428    15.480     0.200
     5.093    31.126     0.200
     5.093    31.603     0.200
     5.832    37.498     0.200
     0.509     3.852     0.200
     0.509     4.083     0.200
     0.678     3.361     0.200
     0.678     3.710     0.200
     0.656     4.232     0.200
     0.763     4.702     0.200
     0.763     4.843     0.200
     0.797     4.376     0.200
     0.783     5.799     0.200
     0.865     5.704     0.200
     0.971     6.760     0.200
     0.999     6.798     0.200
     1.058     5.693     0.200
     1.071     7.472     0.200
     1.071     6.550     0.200
     1.148     5.880     0.200
     1.151     7.853     0.200
     1.194     6.540     0.200
     1.306     9.204     0.200
     1.261     7.821     0.200
     1.261     8.183     0.200
     1.292     6.676     0.200
     1.280     8.826     0.200
     1.337     8.923     0.200
     1.408     7.301     0.200
     1.525     9.787     0.200
     1.564     8.422     0.200
     1.584     8.532     0.200
     1.714    10.784     0.200
     1.740    11.130     0.200
     1.746    10.919     0.200
     1.937    11.441     0.200
     1.929    11.509     0.200
     2.192    13.272     0.200
     0.289     2.625     0.200
     0.485     4.262     0.200
     0.788     6.139     0.200
     0.807     6.053     0.200
     1.066     6.607     0.200
     1.066     6.814     0.200
     1.093     7.900     0.200
     1.106     7.365     0.200
     1.237     7.376     0.200
     1.237     7.517     0.200
     1.237     8.042     0.200
     1.366     9.154     0.200
     1.374     9.179     0.200
     1.372     8.035     0.200
     1.372     8.285     0.200
     1.432     8.865     0.200
     1.432     9.424     0.200
     1.472     8.763     0.200
     1.472     8.052     0.200
     1.533     9.892     0.200
     1.928    12.236     0.200
     2.595    16.532     0.200
     0.804     5.046     0.200
     0.920     6.408     0.200
     1.018     5.927     0.200
     1.349     7.418     0.200
     1.454    10.259     0.200
     1.486     9.118     0.200
     1.680     9.143     0.200
     1.707     9.431     0.200
     1.814    10.982     0.200
     2.140    12.879     0.200
     2.145    14.141     0.200
     3.286    21.254     0.200
     5.043    25.311     0.200
     0.685     4.526     0.200
     0.776     4.440     0.200
     0.776     4.329     0.200
     0.858     5.800     0.200
     0.952     6.464     0.200
     0.952     6.644     0.200
     0.970     6.554     0.200
     1.045     5.524     0.200
     1.123     7.725     0.200
     1.174     6.526     0.200
     1.281     8.983     0.200
     1.250     8.071     0.200
     1.250     8.331     0.200
     1.261     8.696     0.200
     1.354     8.854     0.200
     1.393     7.334     0.200
     1.393     7.224     0.200
     1.439     7.367     0.200
     1.439     7.373     0.200
     1.496     9.568     0.200
     1.554     7.815     0.200
     1.566     8.655     0.200
     1.566     8.525     0.200
     1.678     8.827     0.200
     1.710    10.319     0.200
     1.742    10.801     0.200
     1.899    11.899     0.200
     2.163    12.301     0.200
     2.163    12.531     0.200
     3.664    24.245     0.200
     0.561     3.582     0.200
     0.812     5.777     0.200
     0.910     4.828     0.200
     0.967     6.905     0.200
     1.076     6.926     0.200
     1.167     6.290     0.200
     1.199     8.225     0.200
     1.223     8.318     0.200
     1.338     9.297     0.200
     1.273     8.893     0.200
     1.518     8.649     0.200
     1.567     9.271     0.200
     1.617    10.043     0.200
     1.697     9.539     0.200
     1.821    10.728     0.200
     2.030    12.052     0.200
     0.553     3.528     0.200
     0.805     5.703     0.200
     0.921     5.229     0.200
     0.965     6.785     0.200
     1.082     6.749     0.200
     1.179     7.277     0.200
     1.201     8.125     0.200
     1.217     8.251     0.200
     1.578     9.578     0.200
     1.625     9.876     0.200
     1.810    10.924     0.200
     0.299     2.275     0.200
     0.878     6.068     0.200
     0.878     6.185     0.200
     1.148     7.050     0.200
     1.128     7.974     0.200
     1.333     8.696     0.200
     1.307     8.741     0.200
     1.307     8.561     0.200
     1.368     7.439     0.200
     1.428     9.818     0.200
     1.419     9.826     0.200
     1.419     9.345     0.200
     1.514     9.132     0.200
     1.540     8.790     0.200
     1.546    10.547     0.200
     0.505     3.814     0.200
     0.909     5.827     0.200
     0.909     6.206     0.200
     1.124     6.527     0.200
     1.314     7.646     0.200
     1.299     7.769     0.200
     1.325     7.392     0.200
     1.342     8.268     0.200
     1.325     9.700     0.200
     1.325     8.880     0.200
     1.369     8.706     0.200
     1.369     8.996     0.200
     1.421     9.914     0.200
     1.421     9.735     0.200
     1.475    10.088     0.200
     1.693    11.185     0.200
     1.693    10.205     0.200
     0.247     0.381     0.200
     0.549     3.530     0.200
     0.563     4.106     0.200
     0.845     6.526     0.200
     0.827     5.508     0.200
     1.142     7.703     0.200
     0.985     7.119     0.200
     1.241     8.615     0.200
     1.423     9.503     0.200
     1.607    10.260     0.200
     1.698    10.046     0.200
     1.629     9.931     0.200
     0.403     2.479     0.200
     0.405     2.472     0.200
     0.448     2.803     0.200
     0.667     4.307     0.200
     0.965     6.596     0.200
     1.048     5.962     0.200
     1.048     6.071     0.200
     1.184     7.911     0.200
     1.252     8.178     0.200
     1.252     7.878     0.200
     1.300     7.835     0.200
     1.277     8.517     0.200
     1.277     8.888     0.200
     1.397     9.562     0.200
     1.445     8.546     0.200
     1.652     9.568     0.200
     1.652     9.080     0.200
     1.703     9.465     0.200
     1.702     9.087     0.200
     1.738    11.223     0.200
     1.738    10.773     0.200
     1.694    10.157     0.200
     1.694    10.325     0.200
     1.795    10.163     0.200
     1.834    10.550     0.200
     1.834    10.952     0.200
     2.406    15.667     0.200
     0.407     2.805     0.200
     0.407     2.672     0.200
     0.491     3.625     0.200
     0.494     3.598     0.200
     0.758     5.870     0.200
     0.986     6.996     0.200
     1.061     7.041     0.200
     1.144     6.252     0.200
     1.144     6.486     0.200
     1.159     8.150     0.200
     1.159     7.783     0.200
     1.243     7.809     0.200
     1.274     8.886     0.200
     1.274     8.527     0.200
     1.311     8.696     0.200
     1.311     8.907     0.200
     1.416     9.790     0.200
     1.344     8.813     0.200
     1.399     7.962     0.200
     1.542     8.954     0.200
     1.807    11.284     0.200
     1.807    11.394     0.200
     2.475    15.673     0.200
     4.247    27.029     0.200
     0.408     2.878     0.200
     0.408     2.761     0.200
     0.500     3.646     0.200
     0.503     3.620     0.200
     0.766     6.001     0.200
     0.766     5.681     0.200
     0.982     7.054     0.200
     1.070     6.884     0.200
     1.070     6.564     0.200
     1.151     6.454     0.200
     1.151     6.563     0.200
     1.153     7.732     0.200
     1.153     7.560     0.200
     1.245     7.847     0.200
     1.269     8.352     0.200
     1.269     8.883     0.200
     1.310     8.849     0.200
     1.310     8.575     0.200
     1.414     9.905     0.200
     1.352     8.842     0.200
     1.352     8.428     0.200
     1.407     7.971     0.200
     1.414     9.757     0.200
     1.549     8.584     0.200
     1.587     8.865     0.200
     1.587     9.224     0.200
     1.810    10.833     0.200
     4.252    26.895     0.200
     4.808    31.853     0.200
     0.497     3.210     0.200
     0.736     4.609     0.200
     0.940     5.509     0.200
     0.995     7.477     0.200
     1.057     6.630     0.200
     1.177     6.354     0.200
     1.256     8.653     0.200
     1.437     7.611     0.200
     1.518     8.267     0.200
     1.552     8.581     0.200
     1.669     9.621     0.200
     1.698     9.737     0.200
     0.486     3.072     0.200
     0.645     4.037     0.200
     0.978     5.702     0.200
     1.287     8.578     0.200
     1.356     8.789     0.200
     1.495     8.136     0.200
     1.592     9.310     0.200
     1.631     8.393     0.200
     1.746    10.696     0.200
     1.751     9.723     0.200
     0.739     4.629     0.200
     0.871     4.736     0.200
     0.945     5.848     0.200
     0.991     6.485     0.200
     1.051     6.934     0.200
     1.261     8.982     0.200
     1.441     9.548     0.200
     1.544     9.992     0.200
     1.521     8.295     0.200
     1.555     8.254     0.200
     1.671    10.517     0.200
     1.702    10.296     0.200
     0.955     5.946     0.200
     1.270     8.767     0.200
     1.321     8.939     0.200
     1.805    11.291     0.200
     0.517     3.048     0.200
     0.669     3.914     0.200
     0.824     4.283     0.200
     0.903     5.652     0.200
     0.897     5.605     0.200
     0.997     5.603     0.200
     1.146     7.575     0.200
     1.357     6.891     0.200
     1.433     9.331     0.200
     1.468     8.696     0.200
     1.524     8.087     0.200
     1.652     8.618     0.200
     1.728    10.754     0.200
     1.784    11.074     0.200
     1.927    11.469     0.200
     0.718     4.546     0.200
     0.923     5.060     0.200
     0.992     4.716     0.200
     1.002     6.734     0.200
     1.016     7.014     0.200
     1.307     8.792     0.200
     1.358     8.776     0.200
     1.492     9.432     0.200
     1.608     8.738     0.200
     1.754     9.968     0.200
     1.772    10.859     0.200
     2.675    15.442     0.200
     0.473     3.126     0.200
     0.642     3.128     0.200
     0.774     3.906     0.200
     0.887     5.482     0.200
     0.960     5.131     0.200
     1.097     7.848     0.200
     1.107     6.096     0.200
     1.327     7.115     0.200
     1.485     7.736     0.200
     1.613     8.084     0.200
     1.683    10.121     0.200
     1.753    11.055     0.200
     1.772    10.323     0.200
     1.897    10.820     0.200
     1.912    11.310     0.200
     1.959    11.761     0.200
     2.594    16.049     0.200
     2.715    16.775     0.200
     3.205    18.038     0.200
     0.480     2.878     0.200
     1.115     8.108     0.200
     1.400     9.224     0.200
     1.504     8.398     0.200
     1.788     9.609     0.200
     5.410    34.930     0.200
     0.474     2.801     0.200
     0.647     3.413     0.200
     1.103     7.777     0.200
     1.491     7.806     0.200
     1.777     9.882     0.200
     0.531     2.573     0.200
     0.718     3.415     0.200
     0.861     4.352     0.200
     1.042     7.394     0.200
     1.141     6.384     0.200
     1.191     6.559     0.200
     1.219     6.432     0.200
     1.331     7.920     0.200
     1.389     6.677     0.200
     1.517     7.197     0.200
     1.601     9.585     0.200
     1.662    10.732     0.200
     1.687    11.083     0.200
     1.660     8.984     0.200
     1.789     9.729     0.200
     1.830    10.221     0.200
     0.470     2.927     0.200
     0.650     3.003     0.200
     1.102     7.807     0.200
     1.387     9.322     0.200
     1.450     8.127     0.200
     1.492     7.966     0.200
     1.620     8.260     0.200
     1.689    10.644     0.200
     1.780     9.712     0.200
     5.420    34.726     0.200
     0.507     2.761     0.200
     0.803     4.509     0.200
     1.227     8.530     0.200
     1.386     8.164     0.200
     1.644     8.182     0.200
     5.266    33.473     0.200
     0.509     2.867     0.200
     0.793     4.415     0.200
     0.809     5.126     0.200
     0.901     5.487     0.200
     0.939     6.755     0.200
     1.112     5.823     0.200
     1.075     7.068     0.200
     1.222     8.346     0.200
     1.251     7.030     0.200
     1.448     7.750     0.200
     1.479     8.184     0.200
     1.636     7.846     0.200
     1.904    11.222     0.200
     5.275    33.977     0.200
     0.534     3.090     0.200
     0.685     3.796     0.200
     1.171     7.890     0.200
     1.123     7.934     0.200
     1.544     7.931     0.200
     1.812    10.513     0.200
     0.501     2.996     0.200
     0.736     4.574     0.200
     0.872     4.679     0.200
     0.944     5.166     0.200
     0.994     7.047     0.200
     1.053     6.877     0.200
     1.261     8.845     0.200
     1.521     8.152     0.200
     1.543    10.173     0.200
     1.556     8.569     0.200
     1.672     9.512     0.200
     1.702     8.251     0.200
     1.881    11.534     0.200
     1.823    10.069     0.200
     0.489     2.864     0.200
     0.585     2.812     0.200
     0.742     3.320     0.200
     0.928     6.326     0.200
     0.934     5.862     0.200
     1.066     6.937     0.200
     1.241     6.475     0.200
     1.272     6.822     0.200
     1.230     7.970     0.200
     1.385     7.896     0.200
     1.435     6.775     0.200
     1.697    10.393     0.200
     1.715     9.048     0.200
     0.483     2.739     0.200
     0.619     3.044     0.200
     0.764     3.444     0.200
     0.941     4.823     0.200
     0.909     5.775     0.200
     0.930     6.735     0.200
     1.088     6.873     0.200
     1.275     6.806     0.200
     1.206     7.758     0.200
     1.305     6.967     0.200
     1.373     9.074     0.200
     1.419     8.417     0.200
     1.668    10.354     0.200
     1.724    11.103     0.200
     1.749     9.229     0.200
     0.510     3.187     0.200
     0.756     4.774     0.200
     0.859     4.826     0.200
     0.943     4.834     0.200
     1.048     7.169     0.200
     1.260     8.348     0.200
     1.302     6.496     0.200
     1.511     7.902     0.200
     1.544     7.972     0.200
     1.544    10.120     0.200
     1.659     9.088     0.200
     1.694     8.513     0.200
     1.821     9.134     0.200
     1.836    10.745     0.200
     0.480     2.915     0.200
     0.585     3.169     0.200
     0.736     3.914     0.200
     0.906     5.085     0.200
     0.928     5.854     0.200
     0.937     6.800     0.200
     1.059     5.523     0.200
     1.060     6.810     0.200
     1.236     8.101     0.200
     1.716     9.430     0.200
     2.504    16.224     0.200
     0.564     3.518     0.200
     0.597     3.177     0.200
     0.805     3.851     0.200
     0.851     5.900     0.200
     0.938     5.049     0.200
     0.986     6.140     0.200
     1.110     5.253     0.200
     1.129     7.252     0.200
     1.263     6.827     0.200
     1.286     7.010     0.200
     1.393     8.363     0.200
     1.467     7.449     0.200
     1.596     8.399     0.200
     0.570     2.810     0.200
     0.527     3.870     0.200
     1.083     7.307     0.200
     1.185     6.776     0.200
     1.432     7.646     0.200
     0.493     2.935     0.200
     0.653     3.527     0.200
     0.895     5.711     0.200
     1.120     8.066     0.200
     1.405     9.266     0.200
     1.453     8.382     0.200
     1.502     8.595     0.200
     1.703    10.841     0.200
     1.758    10.377     0.200
     1.775    11.252     0.200
     1.782    10.419     0.200
     1.932    10.996     0.200
     0.510     3.043     0.200
     0.740     4.679     0.200
     0.877     5.116     0.200
     0.989     7.221     0.200
     1.188     6.211     0.200
     1.269     9.014     0.200
     1.315     7.805     0.200
     1.448     7.656     0.200
     1.709     9.188     0.200
     0.489     2.963     0.200
     0.626     3.036     0.200
     1.098     7.149     0.200
     1.475     7.764     0.200
     1.755     9.893     0.200
     0.512     3.080     0.200
     0.618     3.458     0.200
     1.108     7.446     0.200
     1.224     6.590     0.200
     1.474     7.875     0.200
     1.746    10.043     0.200
     1.910    11.066     0.200
     0.609     3.048     0.200
     0.926     6.168     0.200
     1.085     7.152     0.200
     1.207     7.403     0.200
     1.370     9.202     0.200
     1.409     7.759     0.200
     1.459     8.317     0.200
     1.586     7.923     0.200
     1.737    11.268     0.200
     1.739     9.822     0.200
     0.568     3.536     0.200
     0.878     4.489     0.200
     0.927     5.611     0.200
     1.037     5.832     0.200
     0.849     5.786     0.200
     1.202     9.036     0.200
     1.199     6.037     0.200
     1.318     7.566     0.200
     1.487     9.918     0.200
     1.495     9.087     0.200
     1.565     8.739     0.200
     1.854    12.044     0.200
     1.822    10.508     0.200
     0.505     3.082     0.200
     0.873     5.031     0.200
     0.990     6.914     0.200
     1.049     7.039     0.200
     1.183     6.260     0.200
     1.264     8.971     0.200
     1.547     9.946     0.200
     1.673     9.304     0.200
     1.705     8.729     0.200
     1.884    11.307     0.200
     1.822    10.096     0.200
     0.511     2.651     0.200
     0.632     3.110     0.200
     0.901     6.473     0.200
     0.961     5.008     0.200
     0.922     5.968     0.200
     1.118     7.023     0.200
     1.320     6.902     0.200
     1.403     9.093     0.200
     1.488     7.197     0.200
     1.760    10.164     0.200
     1.891    10.606     0.200
     0.861     6.468     0.200
     1.153     7.183     0.200
     1.438     9.434     0.200
     1.440     8.609     0.200
     1.508     6.722     0.200
     1.637     8.436     0.200
     1.767     9.104     0.200
     0.507     3.285     0.200
     0.774     4.611     0.200
     0.822     5.234     0.200
     0.888     4.777     0.200
     0.933     6.807     0.200
     1.094     5.916     0.200
     1.210     8.580     0.200
     1.619     8.064     0.200
     1.746     8.739     0.200
     0.507     3.118     0.200
     0.782     4.495     0.200
     0.816     5.174     0.200
     0.893     4.731     0.200
     0.936     6.745     0.200
     1.101     5.966     0.200
     1.082     7.009     0.200
     1.214     8.485     0.200
     1.626     7.999     0.200
     0.461     2.867     0.200
     0.640     3.514     0.200
     0.880     5.681     0.200
     0.951     6.536     0.200
     1.088     7.855     0.200
     1.292     6.673     0.200
     1.325     6.934     0.200
     1.373     9.386     0.200
     1.440     8.146     0.200
     1.480     7.647     0.200
     1.608     8.263     0.200
     1.676     9.930     0.200
     1.730    10.551     0.200
     1.088     7.027     0.200
     0.438     2.518     0.200
     0.629     2.903     0.200
     1.062     7.380     0.200
     1.231     7.763     0.200
     1.461     7.034     0.200
     1.760     9.880     0.200
     3.716    23.656     0.200
     0.714     4.444     0.200
     0.859     5.120     0.200
     0.912     5.049     0.200
     1.227     8.745     0.200
     1.280     6.796     0.200
     1.509    10.239     0.200
     1.502     7.898     0.200
     1.539     8.007     0.200
     1.658     9.020     0.200
     1.679     8.360     0.200
     2.834    16.838     0.200
     2.910    17.532     0.200
     0.494     2.956     0.200
     0.748     4.677     0.200
     0.852     4.554     0.200
     0.928     5.094     0.200
     0.987     7.140     0.200
     1.065     6.888     0.200
     1.245     8.693     0.200
     1.289     7.357     0.200
     1.536     8.303     0.200
     1.683     8.224     0.200
     1.844    10.076     0.200
     0.479     2.725     0.200
     0.588     3.040     0.200
     0.737     3.501     0.200
     0.909     4.780     0.200
     0.925     6.008     0.200
     0.937     6.768     0.200
     1.061     7.000     0.200
     1.234     7.764     0.200
     1.435     7.039     0.200
     1.563     8.108     0.200
     1.719     9.300     0.200
     0.511     2.924     0.200
     0.643     3.395     0.200
     0.916     5.995     0.200
     0.901     6.556     0.200
     0.971     5.151     0.200
     1.126     7.471     0.200
     1.127     5.328     0.200
     1.169     7.652     0.200
     1.302     6.941     0.200
     1.498     7.603     0.200
     1.626     8.110     0.200
     1.703    10.359     0.200
     1.771     9.980     0.200
     0.495     2.876     0.200
     0.777     4.893     0.200
     0.817     4.695     0.200
     0.908     4.549     0.200
     0.966     6.902     0.200
     1.076     7.002     0.200
     1.227     8.966     0.200
     1.469     7.539     0.200
     1.502     7.792     0.200
     1.617     8.968     0.200
     1.654     8.578     0.200
     1.780     8.978     0.200
     1.838    11.130     0.200
     1.885    11.752     0.200
     1.878    11.357     0.200
     0.526     3.610     0.200
     0.722     4.515     0.200
     0.914     5.278     0.200
     0.983     5.147     0.200
     1.000     7.059     0.200
     1.022     6.764     0.200
     1.299     9.219     0.200
     1.349     7.100     0.200
     1.745     8.534     0.200
     1.782    10.524     0.200
     0.567     3.519     0.200
     0.598     3.118     0.200
     1.131     7.171     0.200
     1.173     8.026     0.200
     1.721     9.345     0.200
     1.858    12.730     0.200
     0.557     3.476     0.200
     0.597     3.076     0.200
     0.800     3.685     0.200
     0.937     4.927     0.200
     0.858     6.362     0.200
     0.980     6.262     0.200
     1.124     7.236     0.200
     1.262     6.474     0.200
     1.179     7.969     0.200
     1.394     7.877     0.200
     1.466     7.288     0.200
     1.594     8.231     0.200
     1.721     9.901     0.200
     1.866    12.080     0.200
     2.554    15.381     0.200
     0.533     3.617     0.200
     0.621     2.776     0.200
     1.125     7.744     0.200
     1.173     8.005     0.200
     1.483     7.561     0.200
     0.484     3.130     0.200
     0.628     3.386     0.200
     0.772     3.591     0.200
     0.950     4.952     0.200
     0.904     5.767     0.200
     0.928     6.848     0.200
     1.096     7.038     0.200
     1.198     7.875     0.200
     1.476     7.079     0.200
     1.604     8.051     0.200
     1.758     8.999     0.200
     0.490     2.741     0.200
     0.637     3.320     0.200
     0.783     3.613     0.200
     0.903     5.872     0.200
     0.960     5.091     0.200
     0.922     6.362     0.200
     1.035     7.569     0.200
     1.107     7.543     0.200
     1.187     7.595     0.200
     1.294     6.530     0.200
     1.324     6.937     0.200
     1.392     9.084     0.200
     1.486     7.531     0.200
     1.688     9.730     0.200
     1.743    10.521     0.200
     1.767     9.890     0.200
     1.916    10.334     0.200
     1.943    12.854     0.200
     0.660     3.261     0.200
     0.786     4.588     0.200
     0.978     5.383     0.200
     1.110     8.183     0.200
     1.313     6.958     0.200
     1.345     7.226     0.200
     1.395    10.104     0.200
     1.503     7.738     0.200
     1.630     8.392     0.200
     1.790     9.592     0.200
     1.927    11.259     0.200
     1.972    10.615     0.200
     0.577     3.546     0.200
     0.716     3.536     0.200
     0.895     5.156     0.200
     0.843     5.902     0.200
     0.924     5.853     0.200
     1.055     5.626     0.200
     1.074     7.772     0.200
     1.075     7.170     0.200
     1.219     8.367     0.200
     1.381     7.123     0.200
     1.405     7.419     0.200
     1.504     9.968     0.200
     1.583     7.984     0.200
     1.712     8.714     0.200
     1.794    10.244     0.200
     1.852    11.264     0.200
     1.838     9.864     0.200
     1.872    12.053     0.200
     1.930    12.153     0.200
     0.616     3.460     0.200
     0.608     3.780     0.200
     1.172     7.498     0.200
     1.495     7.529     0.200
     1.732     9.904     0.200
     1.835    11.981     0.200
     1.950    11.084     0.200
     2.064    12.504     0.200
     0.429     2.852     0.200
     0.649     3.874     0.200
     1.071     7.745     0.200
     1.478     7.535     0.200
     0.501     2.940     0.200
     0.745     4.487     0.200
     0.862     4.520     0.200
     0.938     4.758     0.200
     0.907     6.821     0.200
     0.987     7.075     0.200
     1.172     5.809     0.200
     1.255     8.751     0.200
     1.511     7.564     0.200
     1.693     7.905     0.200
     1.873    11.661     0.200
     1.917    11.715     0.200
     1.921    12.189     0.200
     1.834    10.501     0.200
     1.255     8.958     0.200
     0.450     2.541     0.200
     0.600     3.407     0.200
     1.049     6.865     0.200
     1.437     7.813     0.200
     1.731     9.663     0.200
     1.861    10.220     0.200
     1.951    11.676     0.200
     1.049     7.453     0.200
     0.492     3.379     0.200
     0.636     3.576     0.200
     0.783     3.538     0.200
     0.960     5.311     0.200
     0.905     5.698     0.200
     0.920     6.420     0.200
     1.107     7.178     0.200
     1.037     7.503     0.200
     1.293     7.332     0.200
     1.486     8.359     0.200
     1.614     8.300     0.200
     1.765     9.528     0.200
     1.941    11.523     0.200
     0.465     2.968     0.200
     0.589     2.901     0.200
     1.052     7.336     0.200
     1.431     7.425     0.200
     1.720     9.457     0.200
     1.859    10.508     0.200
     1.844     9.682     0.200
     1.934    12.310     0.200
     0.441     2.602     0.200
     0.578     2.797     0.200
     1.023     7.270     0.200
     1.411     7.686     0.200
     1.709     9.272     0.200
     1.709     9.144     0.200
     1.835    10.341     0.200
     1.946    12.034     0.200
     1.023     7.759     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.326    40.961     0.200
     1.791    35.323     0.200
     1.821    32.934     0.200
     1.890    34.149     0.200
     2.613    43.324     0.200
     1.786    32.716     0.200
     1.880    33.736     0.200
     2.493    43.473     0.200
     2.603    43.849     0.200
     3.626    56.918     0.200
     1.734    32.660     0.200
     1.762    33.362     0.200
     2.404    42.384     0.200
     2.382    40.799     0.200
     3.327    53.706     0.200
     3.425    54.983     0.200
     1.528    29.738     0.200
     1.885    34.766     0.200
     2.033    35.846     0.200
     2.244    39.247     0.200
     1.633    32.524     0.200
     1.727    32.522     0.200
     2.386    42.803     0.200
     3.938    61.186     0.200
     4.827    74.052     0.200
     1.952    35.857     0.200
     1.588    31.616     0.200
     1.603    32.004     0.200
     2.295    40.940     0.200
     3.852    59.145     0.200
     2.372    41.685     0.200
     2.363    41.591     0.200
     2.411    41.388     0.200
     1.714    34.104     0.200
     1.800    34.697     0.200
     2.305    40.670     0.200
     3.930    63.064     0.200
     4.209    66.986     0.200
     5.108    80.837     0.200
    12.115   169.820     0.200
     1.713    33.798     0.200
     1.722    33.797     0.200
     1.812    34.140     0.200
     2.530    43.563     0.200
     1.852    36.154     0.200
     2.304    42.255     0.200
     2.304    40.786     0.200
     2.668    46.080     0.200
     2.814    47.783     0.200
     1.744    33.797     0.200
     2.276    40.204     0.200
     2.721    45.856     0.200
     3.205    52.156     0.200
     3.312    53.918     0.200
     8.568   118.264     0.200
    12.082   169.446     0.200
     1.506    29.944     0.200
     2.307    41.182     0.200
     2.378    42.074     0.200
     2.518    43.212     0.200
     3.300    53.092     0.200
     3.998    61.781     0.200
     3.874    61.202     0.200
     5.689    82.339     0.200
     2.440    44.517     0.200
     3.850    61.415     0.200
     1.163    24.376     0.200
     2.292    40.132     0.200
     2.780    46.587     0.200
     3.960    62.650     0.200
     8.600   117.828     0.200
    10.118   143.993     0.200
     2.307    39.946     0.200
     2.307    42.008     0.200
     2.783    48.127     0.200
     3.973    62.666     0.200
     8.616   117.588     0.200
     9.997   139.786     0.200
    10.117   144.492     0.200
     2.294    41.215     0.200
     2.546    45.293     0.200
     3.956    61.989     0.200
     8.597   118.883     0.200
     1.570    31.595     0.200
     2.277    41.905     0.200
     2.789    50.918     0.200
     3.932    62.535     0.200
     8.571   119.897     0.200
     8.571   119.167     0.200
     1.557    31.583     0.200
     2.295    41.903     0.200
     2.295    41.239     0.200
     3.949    62.772     0.200
     2.155    37.515     0.200
     2.789    48.088     0.200
     1.341    29.098     0.200
     1.491    30.334     0.200
     1.720    32.761     0.200
     1.518    30.322     0.200
     1.616    31.583     0.200
     1.676    33.047     0.200
     1.896    35.235     0.200
     1.915    36.044     0.200
     2.353    41.607     0.200
     2.238    40.525     0.200
     3.146    53.145     0.200
     3.433    55.122     0.200
     1.378    28.915     0.200
     1.429    28.799     0.200
     1.467    29.276     0.200
     1.850    34.790     0.200
     2.517    43.661     0.200
     1.734    34.052     0.200
     2.356    42.679     0.200
     2.625    44.761     0.200
     3.217    52.402     0.200
     3.900    61.992     0.200
     3.900    62.312     0.200
     4.586    69.561     0.200
     5.107    74.345     0.200
     1.549    30.074     0.200
     1.823    33.927     0.200
     2.398    42.514     0.200
     2.398    41.724     0.200
     2.580    45.055     0.200
     3.171    50.166     0.200
     3.893    60.702     0.200
     4.542    69.637     0.200
     1.347    27.719     0.200
     2.373    41.717     0.200
     2.902    45.916     0.200
     3.196    50.991     0.200
     3.892    61.678     0.200
     8.560   118.335     0.200
     1.696    33.585     0.200
     3.878    59.772     0.200
     1.610    33.145     0.200
     1.807    35.516     0.200
     1.807    35.645     0.200
     2.043    38.693     0.200
     2.145    40.579     0.200
     2.291    42.623     0.200
     2.398    43.316     0.200
     2.391    42.179     0.200
     1.683    33.276     0.200
     1.782    35.716     0.200
     1.854    36.625     0.200
     1.869    36.431     0.200
     2.335    40.953     0.200
     1.691    31.934     0.200
     2.319    40.503     0.200
     2.397    42.356     0.200
     1.719    33.578     0.200
     1.756    34.960     0.200
     1.756    34.831     0.200
     1.829    35.892     0.200
     1.930    36.666     0.200
     2.177    40.146     0.200
     2.172    40.095     0.200
     2.330    42.852     0.200
     2.330    42.186     0.200
     2.700    46.754     0.200
     3.982    62.370     0.200
     1.700    33.948     0.200
     1.756    34.403     0.200
     1.838    36.894     0.200
     2.375    42.853     0.200
     4.016    63.573     0.200
     1.749    34.377     0.200
     4.020    64.178     0.200
     4.689    71.565     0.200
     7.190   100.601     0.200
     2.216    39.833     0.200
     2.308    42.186     0.200
     3.898    61.327     0.200
     1.369    27.780     0.200
     1.369    27.916     0.200
     1.505    31.398     0.200
     1.654    32.189     0.200
     1.751    32.497     0.200
     2.265    40.618     0.200
     2.265    41.086     0.200
     2.643    45.854     0.200
     2.882    49.028     0.200
     3.234    52.056     0.200
     3.221    53.052     0.200
     3.345    53.506     0.200
     3.638    56.636     0.200
     3.855    61.108     0.200
     3.926    59.172     0.200
     4.357    68.164     0.200
     4.674    70.150     0.200
     5.158    74.197     0.200
     5.256    77.713     0.200
     5.757    81.407     0.200
     8.549   117.535     0.200
     8.586   117.576     0.200
     1.686    33.638     0.200
     1.773    35.249     0.200
     2.213    41.049     0.200
     3.871    61.934     0.200
     1.756    33.214     0.200
     2.257    40.016     0.200
     2.257    40.305     0.200
     3.631    55.593     0.200
     3.800    58.697     0.200
     3.904    59.582     0.200
     4.397    65.406     0.200
     1.751    33.149     0.200
     2.252    40.199     0.200
     2.252    40.023     0.200
     2.329    41.094     0.200
     2.984    47.548     0.200
     3.206    51.849     0.200
     3.345    52.175     0.200
     3.625    56.022     0.200
     3.797    59.067     0.200
     3.797    60.321     0.200
     3.902    59.728     0.200
     4.048    60.890     0.200
     4.391    65.510     0.200
     4.661    69.229     0.200
     1.613    32.294     0.200
     1.613    31.723     0.200
     2.054    38.172     0.200
     2.240    40.177     0.200
     2.285    39.963     0.200
     2.706    45.855     0.200
     3.014    48.621     0.200
     3.319    53.404     0.200
     3.365    52.976     0.200
     3.753    58.181     0.200
     3.799    60.239     0.200
     4.651    69.385     0.200
     5.184    77.052     0.200
     1.186    26.008     0.200
     1.605    31.648     0.200
     1.730    32.973     0.200
     2.242    40.397     0.200
     2.281    40.164     0.200
     3.192    51.876     0.200
     3.323    52.782     0.200
     3.749    57.939     0.200
     4.653    69.419     0.200
     1.269    26.274     0.200
     1.781    35.335     0.200
     2.399    43.907     0.200
     2.924    48.529     0.200
     3.480    57.088     0.200
     3.864    59.784     0.200
     1.502    29.253     0.200
     1.617    30.508     0.200
     1.886    34.634     0.200
     2.130    39.350     0.200
     2.257    40.075     0.200
     2.497    43.914     0.200
     2.894    47.951     0.200
     2.848    47.100     0.200
     3.038    50.172     0.200
     3.213    52.245     0.200
     3.213    51.515     0.200
     3.310    52.505     0.200
     3.310    52.363     0.200
     3.333    52.648     0.200
     3.426    54.281     0.200
     3.820    58.732     0.200
     3.853    60.036     0.200
     4.174    64.542     0.200
     4.374    64.911     0.200
     4.677    71.027     0.200
     4.665    68.966     0.200
     5.287    77.933     0.200
     5.321    77.846     0.200
     5.559    78.726     0.200
     6.138    88.302     0.200
     7.008    97.656     0.200
     1.402    29.176     0.200
     1.791    35.451     0.200
     1.782    35.036     0.200
     1.782    35.301     0.200
     1.799    35.969     0.200
     2.181    40.656     0.200
     2.268    41.627     0.200
     2.334    42.513     0.200
     2.391    43.363     0.200
     2.391    43.563     0.200
     4.712    73.962     0.200
     5.299    81.299     0.200
     1.610    31.518     0.200
     1.672    31.771     0.200
     1.757    33.380     0.200
     1.757    33.240     0.200
     1.793    33.910     0.200
     1.880    35.150     0.200
     2.253    39.852     0.200
     2.343    40.655     0.200
     2.343    40.909     0.200
     2.650    44.438     0.200
     2.750    46.306     0.200
     2.750    46.049     0.200
     2.886    48.512     0.200
     3.030    50.777     0.200
     3.210    50.969     0.200
     3.210    52.549     0.200
     3.241    51.120     0.200
     3.309    52.426     0.200
     3.309    52.552     0.200
     3.335    51.635     0.200
     3.335    52.425     0.200
     3.419    54.329     0.200
     3.627    55.722     0.200
     3.811    58.815     0.200
     3.811    60.071     0.200
     3.920    59.750     0.200
     3.920    60.592     0.200
     4.168    64.302     0.200
     4.332    65.599     0.200
     4.378    64.903     0.200
     4.662    68.918     0.200
     4.669    70.956     0.200
     4.669    71.318     0.200
     5.279    78.496     0.200
     5.312    78.403     0.200
     6.104    86.246     0.200
     1.879    37.830     0.200
     1.880    36.261     0.200
     2.130    39.619     0.200
     2.538    44.458     0.200
     3.280    54.267     0.200
     3.654    61.262     0.200
     4.449    67.491     0.200
     4.987    78.894     0.200
     5.031    79.237     0.200
     5.045    79.423     0.200
     5.281    81.607     0.200
     5.894    88.622     0.200
     6.475    96.615     0.200
     6.547    97.226     0.200
     1.628    32.220     0.200
     1.628    31.590     0.200
     2.068    38.324     0.200
     2.243    40.189     0.200
     2.297    40.086     0.200
     2.297    39.939     0.200
     2.357    41.679     0.200
     2.357    41.429     0.200
     2.606    43.923     0.200
     2.715    45.700     0.200
     2.982    48.080     0.200
     3.194    51.726     0.200
     3.194    51.016     0.200
     3.317    53.120     0.200
     3.317    53.575     0.200
     3.370    54.094     0.200
     3.765    57.797     0.200
     3.866    58.821     0.200
     4.625    69.428     0.200
     5.233    77.529     0.200
     5.257    77.979     0.200
     6.051    86.435     0.200
     6.089    87.251     0.200
     7.131    99.506     0.200
     1.630    33.276     0.200
     1.688    33.994     0.200
     1.837    36.173     0.200
     2.354    42.709     0.200
     2.354    43.795     0.200
     2.354    43.023     0.200
     2.354    43.980     0.200
     2.476    44.809     0.200
     2.476    45.837     0.200
     2.507    44.841     0.200
     2.711    47.889     0.200
     3.038    51.695     0.200
     3.038    52.410     0.200
     3.302    55.865     0.200
     3.436    55.946     0.200
     3.823    60.906     0.200
     3.885    63.362     0.200
     3.899    62.196     0.200
     4.006    63.176     0.200
     4.523    69.227     0.200
     4.689    72.361     0.200
     5.239    80.831     0.200
     5.284    82.202     0.200
     5.293    82.478     0.200
     6.091    89.572     0.200
     6.798    99.468     0.200
     7.194   103.016     0.200
     1.282    27.165     0.200
     1.773    34.633     0.200
     1.778    35.027     0.200
     1.778    35.145     0.200
     1.842    35.864     0.200
     1.871    37.593     0.200
     2.312    41.359     0.200
     2.312    42.140     0.200
     2.402    43.786     0.200
     2.721    47.125     0.200
     2.910    48.468     0.200
     3.290    54.324     0.200
     3.867    62.134     0.200
     4.721    73.052     0.200
     5.334    82.685     0.200
     5.383    83.737     0.200
     6.169    89.746     0.200
     1.409    28.349     0.200
     1.511    30.060     0.200
     1.514    29.774     0.200
     1.733    33.086     0.200
     1.869    35.220     0.200
     1.926    35.141     0.200
     2.133    38.346     0.200
     2.411    44.234     0.200
     4.169    64.656     0.200
     1.425    31.520     0.200
     1.756    36.255     0.200
     1.756    34.927     0.200
     1.932    37.775     0.200
     1.879    36.950     0.200
     2.476    44.115     0.200
     2.447    45.729     0.200
     0.788    18.252     0.200
     1.537    30.326     0.200
     1.606    31.614     0.200
     1.852    34.806     0.200
     2.226    39.990     0.200
     2.230    40.474     0.200
     2.327    40.710     0.200
     2.381    42.657     0.200
     2.381    42.064     0.200
     2.423    42.176     0.200
     2.540    44.167     0.200
     3.062    49.246     0.200
     3.260    54.525     0.200
     3.298    53.406     0.200
     3.317    53.514     0.200
     3.601    57.584     0.200
     3.695    59.040     0.200
     3.784    59.984     0.200
     3.973    61.707     0.200
     4.044    63.230     0.200
     4.465    66.410     0.200
     5.119    77.928     0.200
     5.973    85.172     0.200
     1.814    34.201     0.200
     1.864    34.795     0.200
     2.008    37.293     0.200
     2.111    38.266     0.200
     2.287    40.466     0.200
     2.326    41.062     0.200
     2.336    41.233     0.200
     2.516    43.223     0.200
     2.777    46.268     0.200
     3.002    49.746     0.200
     3.042    49.945     0.200
     3.292    52.966     0.200
     3.941    62.394     0.200
     1.755    33.895     0.200
     2.192    40.332     0.200
     2.352    41.774     0.200
     2.682    46.796     0.200
     2.930    50.296     0.200
     3.457    56.154     0.200
     3.875    61.307     0.200
     1.810    34.368     0.200
     1.827    34.001     0.200
     1.864    34.971     0.200
     1.864    35.272     0.200
     1.892    35.133     0.200
     1.963    36.783     0.200
     2.017    37.684     0.200
     2.296    42.168     0.200
     2.324    41.097     0.200
     2.331    41.242     0.200
     1.860    35.072     0.200
     1.411    28.075     0.200
     1.571    31.187     0.200
     1.765    33.162     0.200
     1.812    34.073     0.200
     1.812    33.909     0.200
     1.821    34.189     0.200
     1.864    35.098     0.200
     1.864    34.709     0.200
     2.219    40.564     0.200
     2.290    40.916     0.200
     2.290    40.348     0.200
     2.324    40.712     0.200
     2.334    41.867     0.200
     2.334    40.865     0.200
     2.517    43.960     0.200
     2.780    45.874     0.200
     2.882    46.734     0.200
     2.882    46.840     0.200
     3.005    49.412     0.200
     3.045    50.811     0.200
     3.045    49.701     0.200
     3.291    52.637     0.200
     3.291    53.799     0.200
     3.287    51.790     0.200
     3.563    56.127     0.200
     3.609    56.826     0.200
     3.694    58.014     0.200
     3.944    62.229     0.200
     3.981    61.010     0.200
     3.981    61.428     0.200
     3.991    62.448     0.200
     4.040    60.977     0.200
     4.108    63.865     0.200
     4.267    64.317     0.200
     4.295    65.002     0.200
     4.314    66.128     0.200
     4.475    67.117     0.200
     4.528    69.129     0.200
     4.697    70.067     0.200
     4.722    69.872     0.200
     4.752    71.033     0.200
     4.814    72.776     0.200
     4.831    73.027     0.200
     4.831    73.625     0.200
     1.086    23.443     0.200
     1.086    23.609     0.200
     1.773    35.342     0.200
     1.661    32.753     0.200
     1.713    33.080     0.200
     2.179    39.680     0.200
     2.340    41.200     0.200
     2.340    41.491     0.200
     2.693    45.521     0.200
     2.940    49.563     0.200
     3.467    55.590     0.200
     4.727    72.700     0.200
     1.322    28.859     0.200
     2.389    42.233     0.200
     2.422    42.718     0.200
     2.922    47.406     0.200
     4.792    72.669     0.200
     4.847    73.157     0.200
     5.458    79.827     0.200
     1.496    30.266     0.200
     1.488    30.179     0.200
     1.702    33.586     0.200
     1.702    33.245     0.200
     1.697    33.287     0.200
     1.872    35.086     0.200
     2.057    38.159     0.200
     2.128    39.609     0.200
     2.216    40.109     0.200
     2.216    39.964     0.200
     2.235    39.852     0.200
     2.334    40.332     0.200
     2.334    41.909     0.200
     2.391    41.937     0.200
     2.391    43.265     0.200
     2.502    44.193     0.200
     2.502    44.382     0.200
     2.507    42.890     0.200
     2.507    44.297     0.200
     2.593    43.928     0.200
     2.898    49.249     0.200
     2.916    47.170     0.200
     2.916    48.284     0.200
     3.151    50.732     0.200
     3.151    52.339     0.200
     3.163    50.846     0.200
     3.163    51.480     0.200
     3.185    51.801     0.200
     3.185    53.075     0.200
     3.205    51.026     0.200
     3.205    53.652     0.200
     3.205    51.586     0.200
     3.358    54.214     0.200
     3.636    57.120     0.200
     3.636    57.837     0.200
     3.676    58.605     0.200
     3.960    61.604     0.200
     3.960    62.232     0.200
     4.113    63.366     0.200
     4.113    64.918     0.200
     4.170    62.235     0.200
     4.307    64.795     0.200
     4.426    68.287     0.200
     4.589    71.290     0.200
     4.620    68.010     0.200
     4.620    71.282     0.200
     4.801    71.334     0.200
     4.801    74.345     0.200
     4.815    74.132     0.200
     4.866    74.064     0.200
     4.916    74.237     0.200
     5.421    77.808     0.200
     5.513    80.493     0.200
     6.283    88.943     0.200
     1.757    33.935     0.200
     2.273    41.884     0.200
     2.400    43.616     0.200
     1.325    27.118     0.200
     1.319    27.420     0.200
     1.319    26.517     0.200
     1.382    28.255     0.200
     1.425    28.960     0.200
     1.548    30.355     0.200
     1.806    33.254     0.200
     1.809    34.074     0.200
     1.861    34.927     0.200
     1.884    35.230     0.200
     1.962    35.498     0.200
     1.995    36.852     0.200
     2.263    38.472     0.200
     2.328    40.799     0.200
     2.484    42.240     0.200
     2.656    43.367     0.200
     3.088    50.295     0.200
     3.168    51.005     0.200
     3.425    54.824     0.200
     3.699    56.209     0.200
     3.945    60.612     0.200
     4.230    62.792     0.200
     4.225    64.692     0.200
     4.322    65.389     0.200
     5.408    78.790     0.200
     5.483    79.323     0.200
     1.211    26.187     0.200
     1.625    32.854     0.200
     1.754    35.127     0.200
     1.754    35.557     0.200
     1.847    36.152     0.200
     2.559    46.069     0.200
     1.713    33.873     0.200
     1.713    33.584     0.200
     1.781    35.030     0.200
     1.781    35.269     0.200
     2.024    37.364     0.200
     2.084    39.104     0.200
     2.234    41.236     0.200
     2.234    40.760     0.200
     2.383    42.670     0.200
     2.469    42.512     0.200
     2.556    44.755     0.200
     2.854    48.405     0.200
     3.103    51.483     0.200
     3.201    54.449     0.200
     3.201    52.144     0.200
     3.630    58.386     0.200
     3.628    57.928     0.200
     3.929    62.392     0.200
     4.074    65.061     0.200
     4.380    67.678     0.200
     4.773    74.780     0.200
     5.389    83.850     0.200
     5.391    82.000     0.200
     5.473    83.572     0.200
     5.972    87.197     0.200
     7.279   103.428     0.200
     9.362   130.979     0.200
     3.157    51.787     0.200
     1.335    27.567     0.200
     1.638    32.646     0.200
     1.708    32.305     0.200
     2.110    38.197     0.200
     2.259    40.274     0.200
     2.259    40.422     0.200
     2.266    40.085     0.200
     2.422    39.889     0.200
     2.369    41.413     0.200
     2.369    41.850     0.200
     2.446    42.981     0.200
     2.446    43.293     0.200
     2.601    44.872     0.200
     3.211    52.431     0.200
     3.331    53.742     0.200
     3.370    52.923     0.200
     3.781    59.694     0.200
     4.116    63.884     0.200
     4.281    65.736     0.200
     4.520    69.537     0.200
     4.420    66.827     0.200
     4.560    69.638     0.200
     4.597    70.928     0.200
     1.640    32.290     0.200
     2.254    40.293     0.200
     2.261    41.196     0.200
     2.312    41.790     0.200
     2.364    42.554     0.200
     2.607    44.902     0.200
     2.838    47.944     0.200
     3.373    54.498     0.200
     3.779    59.964     0.200
     1.342    26.402     0.200
     1.641    30.614     0.200
     1.956    35.436     0.200
     2.011    33.341     0.200
     1.622    32.295     0.200
     2.263    41.557     0.200
     2.357    41.745     0.200
     3.042    50.238     0.200
     3.824    60.375     0.200
     3.932    60.962     0.200
     1.577    30.021     0.200
     1.825    34.118     0.200
     1.919    35.701     0.200
     1.957    35.896     0.200
     2.244    40.349     0.200
     2.291    40.524     0.200
     2.265    40.969     0.200
     2.447    42.346     0.200
     2.509    42.840     0.200
     2.691    44.286     0.200
     3.131    50.877     0.200
     3.210    52.202     0.200
     3.229    52.760     0.200
     3.909    60.294     0.200
     4.045    62.213     0.200
     4.756    72.190     0.200
     5.373    79.085     0.200
     5.442    80.640     0.200
     6.220    88.524     0.200
     0.644    15.609     0.200
     0.702    16.426     0.200
     0.967    21.222     0.200
     1.671    32.214     0.200
     1.676    32.296     0.200
     5.100    77.277     0.200
     8.626   117.627     0.200
     8.626   118.768     0.200
     1.678    32.285     0.200
     1.669    32.662     0.200
     1.751    33.332     0.200
     1.820    34.520     0.200
     1.860    35.193     0.200
     1.944    36.270     0.200
     1.941    36.559     0.200
     2.787    46.670     0.200
     3.982    61.826     0.200
     1.918    36.083     0.200
     2.192    39.192     0.200
     2.471    43.080     0.200
     3.796    58.659     0.200
     5.339    78.027     0.200
     1.237    25.343     0.200
     1.366    28.166     0.200
     1.374    28.308     0.200
     1.372    27.352     0.200
     1.517    29.347     0.200
     1.825    33.661     0.200
     1.881    34.605     0.200
     1.454    30.317     0.200
     2.140    38.308     0.200
     1.678    33.277     0.200
     1.710    33.649     0.200
     1.900    34.492     0.200
     2.005    37.622     0.200
     2.255    41.753     0.200
     2.466    44.261     0.200
     2.667    47.445     0.200
     3.038    49.116     0.200
     3.767    61.864     0.200
     1.617    32.254     0.200
     2.403    42.770     0.200
     3.655    57.376     0.200
     3.868    60.662     0.200
     4.635    70.121     0.200
     4.693    70.617     0.200
     1.810    35.294     0.200
     2.042    37.608     0.200
     2.394    43.082     0.200
     4.688    70.560     0.200
     1.307    26.963     0.200
     1.428    28.967     0.200
     1.428    28.826     0.200
     1.419    28.794     0.200
     1.659    31.291     0.200
     1.780    33.702     0.200
     1.780    33.667     0.200
     2.393    41.302     0.200
     1.115    24.675     0.200
     1.115    23.093     0.200
     1.175    25.477     0.200
     1.526    28.522     0.200
     1.536    29.134     0.200
     1.606    30.188     0.200
     1.719    31.368     0.200
     1.724    32.110     0.200
     1.693    31.142     0.200
     1.734    32.120     0.200
     1.934    34.433     0.200
     1.961    34.250     0.200
     2.008    33.156     0.200
     2.090    36.781     0.200
     2.295    38.043     0.200
     2.350    39.431     0.200
     2.416    40.223     0.200
     2.534    41.913     0.200
     4.841    71.706     0.200
     1.397    28.824     0.200
     1.738    34.422     0.200
     1.834    35.600     0.200
     2.185    39.680     0.200
     2.334    41.271     0.200
     2.334    42.220     0.200
     2.406    42.827     0.200
     3.459    56.601     0.200
     3.879    62.831     0.200
     3.966    63.197     0.200
     1.416    28.494     0.200
     1.801    34.088     0.200
     1.932    34.439     0.200
     2.015    36.821     0.200
     2.265    37.424     0.200
     2.714    42.847     0.200
     4.011    62.023     0.200
     4.806    68.773     0.200
     1.414    28.592     0.200
     1.587    30.896     0.200
     1.810    34.294     0.200
     1.939    35.533     0.200
     2.026    37.546     0.200
     2.273    42.051     0.200
     2.273    38.932     0.200
     2.253    38.330     0.200
     2.706    42.907     0.200
     4.012    61.666     0.200
     4.252    65.895     0.200
     4.808    72.032     0.200
     1.746    33.946     0.200
     1.881    37.452     0.200
     1.935    37.440     0.200
     2.119    40.036     0.200
     1.943    38.088     0.200
     1.683    34.176     0.200
     1.737    35.295     0.200
     1.753    36.407     0.200
     1.959    39.182     0.200
     2.457    45.824     0.200
     2.749    49.891     0.200
     1.326    28.036     0.200
     2.165    40.185     0.200
     1.387    29.493     0.200
     1.689    33.754     0.200
     1.932    36.509     0.200
     1.894    37.729     0.200
     2.060    38.852     0.200
     1.826    36.565     0.200
     1.904    36.792     0.200
     1.543    32.414     0.200
     1.881    37.454     0.200
     1.924    38.064     0.200
     1.823    35.519     0.200
     2.320    41.728     0.200
     2.910    49.686     0.200
     2.956    52.911     0.200
     3.190    52.784     0.200
     3.251    58.435     0.200
     3.528    60.382     0.200
     3.796    61.978     0.200
     1.373    28.595     0.200
     1.544    32.021     0.200
     1.836    35.596     0.200
     1.345    28.573     0.200
     1.413    29.661     0.200
     1.685    33.556     0.200
     1.703    33.960     0.200
     1.775    36.381     0.200
     1.552    31.302     0.200
     2.007    37.407     0.200
     2.114    39.696     0.200
     2.131    39.039     0.200
     1.662    33.315     0.200
     1.718    33.946     0.200
     1.737    34.327     0.200
     1.989    35.668     0.200
     2.106    37.594     0.200
     2.086    38.800     0.200
     2.340    40.215     0.200
     2.373    42.920     0.200
     2.518    45.546     0.200
     2.477    43.278     0.200
     2.580    47.059     0.200
     2.718    48.392     0.200
     2.890    49.206     0.200
     2.934    49.912     0.200
     1.487    30.758     0.200
     1.854    37.876     0.200
     2.005    37.967     0.200
     1.925    38.646     0.200
     2.106    39.946     0.200
     2.008    37.963     0.200
     2.192    40.628     0.200
     1.927    37.441     0.200
     1.930    37.413     0.200
     2.127    38.904     0.200
     2.110    39.488     0.200
     2.183    40.452     0.200
     2.369    43.055     0.200
     2.529    44.800     0.200
     2.594    45.598     0.200
     1.751    35.093     0.200
     2.128    39.642     0.200
     2.742    49.605     0.200
     3.242    53.736     0.200
     1.438    29.837     0.200
     1.214    27.466     0.200
     2.038    37.758     0.200
     2.477    43.691     0.200
     2.528    45.470     0.200
     3.103    53.615     0.200
     1.373    29.362     0.200
     1.676    34.086     0.200
     2.123    37.939     0.200
     1.245    27.353     0.200
     1.844    36.897     0.200
     1.061    23.320     0.200
     2.084    38.990     0.200
     1.703    34.180     0.200
     1.760    35.319     0.200
     1.227    26.686     0.200
     2.044    38.770     0.200
     2.168    40.852     0.200
     1.858    37.890     0.200
     2.027    38.033     0.200
     2.092    38.358     0.200
     1.677    33.592     0.200
     1.733    34.991     0.200
     1.392    29.023     0.200
     1.688    33.870     0.200
     1.504    31.226     0.200
     1.794    36.323     0.200
     2.621    47.843     0.200
     2.477    45.249     0.200
     7.071   100.527     0.200
     1.255    26.720     0.200
     1.693    34.334     0.200
     1.820    36.077     0.200
     2.584    47.686     0.200
     3.174    54.089     0.200
     3.669    59.020     0.200
     1.037    23.134     0.200
     1.023    23.022     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    12.231   237.752     0.200
     5.184   102.611     0.200
     5.801   114.912     0.200
     7.143   145.752     0.200
     8.608   169.255     0.200
     5.635   111.664     0.200
     3.677    73.405     0.200
     4.674    91.839     0.200
     6.074   132.285     0.200
     5.249   103.541     0.200
     5.214   103.148     0.200
     5.202   102.749     0.200
     8.576   169.292     0.200
     5.804   115.554     0.200
     6.155   123.951     0.200
     4.115    83.229     0.200
     3.929    78.022     0.200
     5.804   115.119     0.200
     8.568   170.213     0.200
    12.087   239.536     0.200
     3.998    79.586     0.200
     8.693   171.945     0.200
     5.213   103.201     0.200
     8.546   168.061     0.200
    12.181   239.789     0.200
     9.897   200.317     0.200
    12.102   234.165     0.200
    12.102   235.141     0.200
    12.106   234.510     0.200
     8.616   170.135     0.200
     9.902   200.330     0.200
    10.117   201.219     0.200
    10.117   202.476     0.200
    12.117   233.772     0.200
    12.117   236.022     0.200
    12.122   235.118     0.200
    12.348   247.380     0.200
    13.727   270.287     0.200
    14.899   290.666     0.200
    15.653   305.428     0.200
    15.809   317.941     0.200
     3.956    78.106     0.200
     8.597   168.985     0.200
    12.103   234.098     0.200
    12.107   239.795     0.200
     3.932    77.105     0.200
     5.806   116.012     0.200
    12.088   237.945     0.200
     3.954    79.000     0.200
     5.087   100.015     0.200
     2.517    49.442     0.200
     4.661    91.328     0.200
     3.892    79.188     0.200
     5.712   117.779     0.200
     6.235   133.996     0.200
     8.514   167.165     0.200
    12.174   238.373     0.200
     5.095    99.919     0.200
     5.072    99.644     0.200
     5.635   110.612     0.200
     4.689    91.725     0.200
     5.316   104.808     0.200
     2.718    53.783     0.200
     2.761    54.244     0.200
     3.221    64.212     0.200
     3.638    71.504     0.200
     4.674    91.771     0.200
     5.757   113.711     0.200
     9.115   180.182     0.200
     9.410   187.604     0.200
    12.161   235.176     0.200
     2.513    48.781     0.200
     2.513    49.049     0.200
     2.642    52.388     0.200
     2.834    55.442     0.200
     2.954    58.705     0.200
     3.068    60.104     0.200
     3.732    73.011     0.200
     2.744    54.066     0.200
     3.018    59.495     0.200
     3.097    60.473     0.200
     3.800    75.095     0.200
     4.048    77.363     0.200
     5.171   101.529     0.200
     2.740    54.099     0.200
     2.740    53.732     0.200
     3.015    59.603     0.200
     3.797    75.130     0.200
     4.333    85.754     0.200
     2.706    53.465     0.200
     2.971    58.675     0.200
     3.042    59.749     0.200
     3.753    73.517     0.200
     3.799    75.216     0.200
     2.704    53.765     0.200
     2.966    58.715     0.200
     3.034    59.554     0.200
     3.749    73.588     0.200
     3.796    75.511     0.200
     4.282    84.105     0.200
     5.210   102.984     0.200
     2.886    56.368     0.200
     2.924    57.911     0.200
     3.084    61.229     0.200
     3.864    76.784     0.200
     3.038    59.283     0.200
     3.127    61.092     0.200
     3.863    76.225     0.200
     4.358    87.767     0.200
     5.559   108.976     0.200
     2.545    50.140     0.200
     2.939    57.496     0.200
     4.674    91.482     0.200
     4.712    93.532     0.200
     3.030    60.037     0.200
     3.118    61.182     0.200
     3.210    64.459     0.200
     3.309    65.186     0.200
     3.811    74.525     0.200
     4.378    85.803     0.200
     4.662    91.708     0.200
     4.669    92.098     0.200
     5.549   108.696     0.200
     6.162   121.129     0.200
     2.533    49.832     0.200
     2.777    54.921     0.200
     3.065    60.005     0.200
     3.054    59.473     0.200
     3.561    70.105     0.200
     3.978    78.151     0.200
     4.425    87.277     0.200
     5.369   106.464     0.200
     5.607   111.223     0.200
     5.894   116.272     0.200
     2.715    54.009     0.200
     2.908    56.649     0.200
     2.982    58.540     0.200
     3.006    58.568     0.200
     3.765    73.717     0.200
     3.909    76.320     0.200
     4.625    91.529     0.200
     4.919    96.796     0.200
     2.797    55.538     0.200
     2.797    55.096     0.200
     3.038    60.601     0.200
     2.790    54.340     0.200
     3.087    60.735     0.200
     3.867    76.352     0.200
     2.561    50.533     0.200
     2.905    56.963     0.200
     4.861    95.385     0.200
     2.698    53.275     0.200
     2.930    57.667     0.200
     3.227    63.671     0.200
     3.715    73.266     0.200
     2.663    52.470     0.200
     2.663    52.314     0.200
     2.911    56.875     0.200
     2.911    57.223     0.200
     3.173    61.946     0.200
     2.517    50.431     0.200
     2.555    51.092     0.200
     3.291    65.258     0.200
     3.760    73.858     0.200
     4.831    94.998     0.200
     2.940    57.455     0.200
     3.091    60.760     0.200
     2.980    58.952     0.200
     2.756    53.808     0.200
     3.960    77.513     0.200
     4.113    81.386     0.200
     4.225    83.009     0.200
     2.580    51.155     0.200
     2.629    52.330     0.200
     2.832    55.854     0.200
     2.832    56.369     0.200
     3.095    60.276     0.200
     4.478    88.993     0.200
     3.201    62.937     0.200
     4.773    95.620     0.200
     5.972   119.123     0.200
     4.635    91.465     0.200
     3.007    58.570     0.200
     5.826   114.150     0.200
     5.832   116.006     0.200
     3.800    74.609     0.200
     3.286    64.215     0.200
     3.664    71.565     0.200
     3.830    75.130     0.200
     4.635    90.839     0.200
     7.101   152.718     0.200
     2.537    51.921     0.200
     2.504    49.105     0.200
     2.533    49.411     0.200
     2.609    51.715     0.200
     2.620    53.741     0.200
     3.348    65.806     0.200
     3.903    76.720     0.200
     4.188    83.290     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.222    24.219     0.200
     2.269    43.005     0.200
     8.640   167.279     0.200
     1.106    23.060     0.200
     1.835    35.369     0.200
     2.138    41.720     0.200
     3.945    75.927     0.200
     5.000    95.618     0.200
     1.352    24.435     0.200
     3.992    76.035     0.200
     4.664    90.395     0.200
     8.631   165.925     0.200
     1.343    24.426     0.200
     1.609    32.603     0.200
     3.988    75.450     0.200
     5.645   110.307     0.200
     0.438     9.314     0.200
     0.441     9.075     0.200
     0.706    14.320     0.200
     1.176    23.765     0.200
     1.292    24.890     0.200
     1.660    31.722     0.200
     1.829    35.123     0.200
     3.960    76.275     0.200
     4.725    91.852     0.200
     5.696   111.414     0.200
     0.263     5.848     0.200
     0.328     7.538     0.200
     1.223    24.543     0.200
     1.565    29.105     0.200
     1.823    34.043     0.200
     1.700    30.829     0.200
     4.905    93.449     0.200
     0.193     4.631     0.200
     1.105    22.680     0.200
     1.232    24.599     0.200
     4.827    93.751     0.200
     0.294     5.905     0.200
     0.345     6.912     0.200
     1.042    22.071     0.200
     1.405    28.245     0.200
     1.511    29.197     0.200
     0.327     6.634     0.200
     0.748    16.316     0.200
     1.047    22.216     0.200
     1.222    24.835     0.200
     2.407    45.037     0.200
     0.277     6.680     0.200
     0.360     8.187     0.200
     0.274     6.787     0.200
     0.564    12.868     0.200
     1.594    30.720     0.200
     1.650    31.786     0.200
     1.161    23.890     0.200
     0.865    19.491     0.200
     3.185    60.016     0.200
     5.097    98.478     0.200
     1.238    25.478     0.200
     1.377    28.375     0.200
     1.789    33.637     0.200
     5.005    97.119     0.200
     1.137    22.905     0.200
     1.348    27.189     0.200
     1.828    35.885     0.200
     5.079    98.211     0.200
     9.990   195.188     0.200
     1.371    26.617     0.200
     1.151    23.594     0.200
     1.329    26.774     0.200
     1.563    29.874     0.200
     2.526    48.957     0.200
     5.297   101.977     0.200
     1.207    23.802     0.200
     2.382    44.358     0.200
     3.874    73.030     0.200
     5.213   101.971     0.200
     5.689   109.800     0.200
     0.298     6.357     0.200
     1.013    20.844     0.200
     1.249    24.480     0.200
     3.850    73.993     0.200
     0.453     9.743     0.200
     1.734    32.993     0.200
     3.960    75.877     0.200
     5.079    98.529     0.200
     5.079    98.904     0.200
     5.825   113.315     0.200
     8.600   168.218     0.200
     0.440     9.519     0.200
     1.180    23.170     0.200
     3.973    75.533     0.200
     5.087    99.094     0.200
     5.087    97.648     0.200
     5.830   113.102     0.200
     7.623   148.864     0.200
     8.422   161.831     0.200
     8.616   168.783     0.200
     0.457     9.780     0.200
     1.162    23.381     0.200
     1.729    33.978     0.200
     5.082    98.523     0.200
     5.082    97.890     0.200
     1.139    22.475     0.200
     2.277    42.866     0.200
     5.079    99.076     0.200
     5.079    98.411     0.200
     7.639   147.845     0.200
     8.404   163.050     0.200
     8.571   166.495     0.200
    12.084   235.444     0.200
     0.465     9.514     0.200
     1.160    22.979     0.200
     1.203    25.117     0.200
     2.295    45.215     0.200
     3.949    76.507     0.200
     5.087    98.601     0.200
     8.417   162.449     0.200
     0.686    14.756     0.200
     1.243    25.710     0.200
     1.498    29.668     0.200
     1.618    31.794     0.200
     2.272    43.268     0.200
     2.296    43.721     0.200
     5.196   101.436     0.200
     1.196    23.730     0.200
     5.087    97.867     0.200
     6.152   115.786     0.200
     0.382     7.623     0.200
     0.643    14.141     0.200
     0.878    18.111     0.200
     0.939    19.061     0.200
     1.023    19.652     0.200
     1.226    24.696     0.200
     1.238    24.214     0.200
     1.227    25.841     0.200
     1.420    27.285     0.200
     1.720    33.004     0.200
     1.626    31.217     0.200
     1.808    33.038     0.200
     3.954    76.109     0.200
     5.143    98.137     0.200
     0.226     5.840     0.200
     0.226     5.398     0.200
     0.460    10.398     0.200
     0.490    12.243     0.200
     0.758    16.265     0.200
     0.800    17.376     0.200
     0.947    19.240     0.200
     1.076    22.493     0.200
     1.125    22.941     0.200
     1.167    23.234     0.200
     1.345    25.601     0.200
     1.366    27.194     0.200
     1.580    29.256     0.200
     1.733    34.512     0.200
     5.282   102.642     0.200
     0.373     8.560     0.200
     0.776    15.944     0.200
     0.959    19.760     0.200
     1.194    24.078     0.200
     1.261    25.608     0.200
     1.632    30.695     0.200
     1.757    34.087     0.200
     2.242    41.959     0.200
     4.676    90.952     0.200
     5.174   100.109     0.200
     0.331     7.390     0.200
     0.331     7.560     0.200
     0.534    11.683     0.200
     0.812    16.961     0.200
     0.867    18.644     0.200
     0.979    19.989     0.200
     1.227    24.584     0.200
     1.227    24.424     0.200
     1.313    25.764     0.200
     1.283    26.112     0.200
     1.590    31.536     0.200
     1.801    34.545     0.200
     2.020    39.078     0.200
     3.950    73.935     0.200
     5.219   100.887     0.200
     0.239     5.529     0.200
     0.356     7.537     0.200
     0.789    16.322     0.200
     0.789    16.041     0.200
     0.893    19.203     0.200
     0.963    19.726     0.200
     0.963    19.617     0.200
     1.205    23.709     0.200
     1.205    23.908     0.200
     1.266    25.710     0.200
     1.266    25.850     0.200
     1.575    29.770     0.200
     1.777    35.044     0.200
     2.902    54.746     0.200
     5.194   101.558     0.200
     5.712   107.677     0.200
     6.612   123.371     0.200
     8.560   166.405     0.200
     0.548    10.473     0.200
     0.548    11.017     0.200
     0.548    10.908     0.200
     0.613    12.978     0.200
     0.613    12.847     0.200
     0.845    17.579     0.200
     1.004    21.201     0.200
     1.038    21.166     0.200
     1.083    22.354     0.200
     1.136    23.294     0.200
     1.382    27.506     0.200
     1.380    27.494     0.200
     1.608    31.345     0.200
     1.769    33.432     0.200
     1.783    34.540     0.200
     1.892    36.270     0.200
     2.182    41.885     0.200
     2.749    52.657     0.200
     5.013    97.841     0.200
     0.257     5.084     0.200
     0.340     6.783     0.200
     0.340     7.093     0.200
     0.588    13.610     0.200
     0.867    18.918     0.200
     0.923    16.409     0.200
     0.962    18.704     0.200
     1.072    23.122     0.200
     1.214    24.156     0.200
     1.267    25.537     0.200
     1.408    28.888     0.200
     1.533    29.844     0.200
     1.550    30.860     0.200
     1.581    29.922     0.200
     1.625    31.857     0.200
     1.692    31.791     0.200
     1.711    32.664     0.200
     1.711    33.484     0.200
     1.823    35.129     0.200
     2.391    45.189     0.200
     5.222   101.475     0.200
     0.789    16.291     0.200
     0.985    19.802     0.200
     1.021    20.032     0.200
     1.086    21.088     0.200
     1.216    24.234     0.200
     1.266    25.900     0.200
     1.300    25.166     0.200
     1.668    31.722     0.200
     1.736    33.795     0.200
     2.781    52.336     0.200
     0.234     5.599     0.200
     0.332     7.466     0.200
     0.584    14.187     0.200
     0.531    10.999     0.200
     0.801    17.102     0.200
     0.812    16.940     0.200
     0.870    18.657     0.200
     0.980    20.425     0.200
     1.075    21.550     0.200
     1.165    24.000     0.200
     1.192    22.389     0.200
     1.192    22.600     0.200
     1.227    24.443     0.200
     1.227    24.224     0.200
     1.284    25.801     0.200
     1.414    28.113     0.200
     1.543    29.437     0.200
     1.593    29.890     0.200
     1.647    33.289     0.200
     1.724    33.710     0.200
     5.217   101.453     0.200
     0.177     3.883     0.200
     0.413     8.872     0.200
     0.413     9.005     0.200
     0.776    15.875     0.200
     0.776    16.404     0.200
     0.918    19.075     0.200
     0.977    20.596     0.200
     1.000    20.498     0.200
     1.000    20.709     0.200
     1.202    23.923     0.200
     1.202    24.111     0.200
     1.261    25.572     0.200
     1.283    26.122     0.200
     1.295    26.760     0.200
     1.410    28.457     0.200
     1.315    26.043     0.200
     1.531    30.949     0.200
     1.667    32.405     0.200
     1.851    35.695     0.200
     2.130    42.039     0.200
     2.184    42.647     0.200
     2.557    49.024     0.200
     0.342     7.870     0.200
     1.087    22.188     0.200
     1.275    26.201     0.200
     1.289    26.044     0.200
     1.331    26.424     0.200
     1.893    36.031     0.200
     1.907    36.436     0.200
     5.101    98.520     0.200
     0.398     7.645     0.200
     0.776    15.453     0.200
     0.955    19.106     0.200
     1.009    19.895     0.200
     1.016    20.031     0.200
     1.107    21.456     0.200
     1.204    24.686     0.200
     1.238    23.558     0.200
     1.321    25.557     0.200
     1.308    26.402     0.200
     1.435    28.881     0.200
     1.706    32.604     0.200
     1.758    33.719     0.200
     1.795    34.575     0.200
     1.869    35.604     0.200
     1.891    36.278     0.200
     2.315    43.734     0.200
     0.155     3.246     0.200
     0.393     8.336     0.200
     0.425     9.059     0.200
     0.425     9.057     0.200
     0.689    16.143     0.200
     0.790    17.082     0.200
     0.790    16.791     0.200
     0.943    19.890     0.200
     1.027    21.239     0.200
     1.218    24.146     0.200
     1.218    25.291     0.200
     1.240    24.449     0.200
     1.275    26.112     0.200
     1.320    26.579     0.200
     1.443    28.770     0.200
     1.696    33.062     0.200
     1.696    32.923     0.200
     1.868    36.646     0.200
     2.769    52.682     0.200
     3.657    70.532     0.200
     5.085    99.494     0.200
     5.863   114.146     0.200
    12.150   238.300     0.200
     0.421     8.274     0.200
     0.732    14.973     0.200
     0.890    17.476     0.200
     0.929    18.531     0.200
     1.152    22.349     0.200
     1.257    24.986     0.200
     1.228    24.809     0.200
     1.626    31.184     0.200
     1.673    32.209     0.200
     1.676    32.756     0.200
     1.712    32.861     0.200
     1.801    34.562     0.200
     3.303    63.809     0.200
     0.211     5.062     0.200
     0.377     8.001     0.200
     0.377     8.240     0.200
     0.491    10.617     0.200
     0.491     9.934     0.200
     0.491    11.085     0.200
     0.491     9.831     0.200
     0.635    15.202     0.200
     0.705    13.924     0.200
     0.780    16.087     0.200
     0.861    16.595     0.200
     0.998    20.234     0.200
     0.974    20.242     0.200
     0.974    19.589     0.200
     0.974    19.875     0.200
     1.038    20.629     0.200
     1.133    22.806     0.200
     1.213    22.791     0.200
     1.215    24.254     0.200
     1.218    25.011     0.200
     1.201    24.129     0.200
     1.201    23.902     0.200
     1.253    23.977     0.200
     1.275    25.565     0.200
     1.396    26.218     0.200
     1.605    30.618     0.200
     1.691    33.417     0.200
     1.691    33.737     0.200
     1.762    34.240     0.200
     1.785    34.239     0.200
     1.738    34.261     0.200
     1.768    34.506     0.200
     1.805    34.746     0.200
     1.873    35.464     0.200
     1.896    34.266     0.200
     2.860    54.493     0.200
     3.345    65.147     0.200
     5.158    97.725     0.200
     5.158    99.400     0.200
     5.667   110.754     0.200
     8.549   165.336     0.200
     8.586   164.795     0.200
     0.325     6.673     0.200
     0.540    10.878     0.200
     0.540    10.753     0.200
     0.552    10.977     0.200
     0.552    11.364     0.200
     0.618    12.762     0.200
     0.747    14.414     0.200
     0.747    14.186     0.200
     0.844    17.388     0.200
     1.042    20.513     0.200
     1.113    23.187     0.200
     1.124    22.382     0.200
     1.136    22.769     0.200
     1.619    31.462     0.200
     1.619    31.920     0.200
     1.625    32.312     0.200
     1.625    32.108     0.200
     1.639    32.140     0.200
     1.686    33.060     0.200
     1.716    32.444     0.200
     1.758    33.377     0.200
     2.095    40.885     0.200
     2.108    42.007     0.200
     2.108    41.268     0.200
     2.270    44.943     0.200
     2.760    52.642     0.200
     2.834    54.283     0.200
     3.124    60.468     0.200
     3.186    60.546     0.200
     4.064    78.375     0.200
     4.759    91.707     0.200
     5.024    96.724     0.200
     0.374     8.265     0.200
     0.374     8.190     0.200
     0.492    10.572     0.200
     0.514    10.899     0.200
     0.681    13.499     0.200
     0.681    13.335     0.200
     0.776    16.393     0.200
     0.961    19.708     0.200
     0.961    19.860     0.200
     1.056    20.803     0.200
     1.117    22.307     0.200
     1.117    22.045     0.200
     1.194    23.876     0.200
     1.194    23.821     0.200
     1.262    25.618     0.200
     1.286    25.615     0.200
     1.286    25.400     0.200
     1.635    32.435     0.200
     1.667    33.343     0.200
     1.667    32.925     0.200
     1.754    33.893     0.200
     1.754    34.237     0.200
     1.766    34.166     0.200
     1.804    34.214     0.200
     2.989    57.168     0.200
     3.351    64.719     0.200
     4.336    83.492     0.200
     4.397    84.945     0.200
     5.530   108.030     0.200
     0.234     5.808     0.200
     0.380     8.233     0.200
     0.380     8.495     0.200
     0.486    10.560     0.200
     0.486    10.240     0.200
     0.515    10.946     0.200
     0.515    10.595     0.200
     0.515    10.739     0.200
     0.683    13.429     0.200
     0.683    13.014     0.200
     0.770    16.310     0.200
     0.956    19.811     0.200
     0.956    19.498     0.200
     0.980    18.433     0.200
     1.051    20.656     0.200
     1.051    20.789     0.200
     1.116    21.917     0.200
     1.116    22.202     0.200
     1.195    22.763     0.200
     1.197    23.999     0.200
     1.188    23.736     0.200
     1.188    24.029     0.200
     1.257    25.774     0.200
     1.280    25.608     0.200
     1.280    25.440     0.200
     1.378    26.174     0.200
     1.639    32.288     0.200
     1.667    33.257     0.200
     1.749    33.429     0.200
     1.751    33.329     0.200
     1.769    34.201     0.200
     1.798    34.163     0.200
     2.102    39.199     0.200
     2.792    53.311     0.200
     2.796    52.909     0.200
     2.867    54.607     0.200
     2.984    57.283     0.200
     3.015    58.673     0.200
     3.201    61.067     0.200
     3.345    64.987     0.200
     5.166   100.945     0.200
     5.530   108.144     0.200
     0.372     8.113     0.200
     0.372     8.090     0.200
     0.497     9.572     0.200
     0.568    11.211     0.200
     0.568    11.594     0.200
     0.628    11.971     0.200
     0.769    15.271     0.200
     0.930    18.850     0.200
     0.930    18.999     0.200
     1.064    20.884     0.200
     1.097    21.745     0.200
     1.145    21.729     0.200
     1.147    21.870     0.200
     1.181    23.425     0.200
     1.181    23.816     0.200
     1.234    25.214     0.200
     1.305    26.231     0.200
     1.547    29.071     0.200
     1.593    29.672     0.200
     1.684    33.523     0.200
     1.721    32.926     0.200
     1.730    33.337     0.200
     1.730    33.095     0.200
     1.802    34.800     0.200
     2.738    52.593     0.200
     0.284     6.453     0.200
     0.368     8.049     0.200
     0.503    10.233     0.200
     0.575    11.577     0.200
     0.619    11.957     0.200
     0.806    16.432     0.200
     0.930    18.814     0.200
     1.058    20.699     0.200
     1.106    21.477     0.200
     1.183    22.934     0.200
     1.306    26.494     0.200
     1.234    25.030     0.200
     1.312    26.061     0.200
     1.538    28.671     0.200
     1.584    29.082     0.200
     1.676    32.597     0.200
     1.713    32.138     0.200
     1.799    34.903     0.200
     2.929    54.618     0.200
     3.022    58.577     0.200
     3.985    77.363     0.200
     4.427    84.595     0.200
     5.470   106.031     0.200
     6.084   118.106     0.200
     0.431     8.920     0.200
     0.431     8.657     0.200
     0.420     9.118     0.200
     0.420     9.148     0.200
     0.468    10.081     0.200
     0.777    14.024     0.200
     0.925    19.503     0.200
     0.969    18.950     0.200
     0.969    19.113     0.200
     0.996    19.978     0.200
     0.996    20.508     0.200
     1.197    24.255     0.200
     1.232    24.796     0.200
     1.285    25.529     0.200
     1.288    25.864     0.200
     1.291    26.265     0.200
     1.322    25.976     0.200
     1.408    28.559     0.200
     1.408    28.432     0.200
     1.673    32.363     0.200
     1.673    32.652     0.200
     1.674    32.587     0.200
     1.725    33.303     0.200
     1.937    38.001     0.200
     2.190    43.027     0.200
     2.791    53.664     0.200
     2.952    55.873     0.200
     3.084    59.550     0.200
     3.302    63.890     0.200
     3.302    63.632     0.200
     4.334    83.120     0.200
     5.098    98.249     0.200
     0.212     5.758     0.200
     0.389     8.036     0.200
     0.389     8.564     0.200
     0.389     8.845     0.200
     0.480    10.469     0.200
     0.480    10.020     0.200
     0.487     9.607     0.200
     0.487    10.476     0.200
     0.648    14.579     0.200
     0.713    14.004     0.200
     0.713    13.843     0.200
     0.771    16.093     0.200
     0.771    16.314     0.200
     0.874    18.352     0.200
     0.939    19.605     0.200
     0.969    19.893     0.200
     0.969    19.749     0.200
     1.009    18.618     0.200
     1.025    20.241     0.200
     1.025    20.071     0.200
     1.192    23.924     0.200
     1.224    23.146     0.200
     1.231    24.691     0.200
     1.231    24.273     0.200
     1.265    24.878     0.200
     1.269    25.877     0.200
     1.265    25.303     0.200
     1.265    25.111     0.200
     1.617    31.028     0.200
     1.666    31.752     0.200
     1.762    33.362     0.200
     1.797    34.727     0.200
     1.794    33.972     0.200
     1.899    36.396     0.200
     2.766    52.101     0.200
     2.965    57.586     0.200
     3.127    60.230     0.200
     3.710    69.251     0.200
     3.820    74.031     0.200
     4.077    78.502     0.200
     4.358    83.196     0.200
     4.374    84.900     0.200
     4.865    93.390     0.200
     5.145    99.763     0.200
     6.753   131.463     0.200
     0.182     3.774     0.200
     0.442     9.364     0.200
     0.406     8.521     0.200
     0.406     9.091     0.200
     0.476    10.245     0.200
     0.669    16.112     0.200
     0.776    16.527     0.200
     0.776    16.000     0.200
     0.761    14.871     0.200
     0.908    18.435     0.200
     0.986    19.282     0.200
     0.986    18.774     0.200
     0.986    18.614     0.200
     0.968    19.749     0.200
     0.968    20.722     0.200
     0.994    20.472     0.200
     1.054    21.737     0.200
     1.054    21.558     0.200
     1.201    23.792     0.200
     1.201    24.058     0.200
     1.175    24.210     0.200
     1.245    25.433     0.200
     1.245    25.331     0.200
     1.245    25.151     0.200
     1.254    26.274     0.200
     1.291    25.770     0.200
     1.268    25.276     0.200
     1.271    25.731     0.200
     1.304    26.692     0.200
     1.371    28.040     0.200
     1.451    29.174     0.200
     1.656    32.002     0.200
     1.731    32.893     0.200
     1.744    33.226     0.200
     1.799    33.867     0.200
     1.839    36.689     0.200
     1.920    36.792     0.200
     2.173    42.130     0.200
     2.552    48.632     0.200
     3.306    64.207     0.200
     3.315    63.204     0.200
     3.832    73.293     0.200
     4.349    82.898     0.200
     0.220     5.487     0.200
     0.388     8.208     0.200
     0.388     8.410     0.200
     0.388     8.770     0.200
     0.496    10.234     0.200
     0.496     9.996     0.200
     0.480    10.128     0.200
     0.480    10.468     0.200
     0.645    13.838     0.200
     0.704    13.822     0.200
     0.704    13.927     0.200
     0.769    16.345     0.200
     0.935    19.164     0.200
     0.964    19.769     0.200
     1.001    18.823     0.200
     1.032    20.105     0.200
     1.135    22.594     0.200
     1.135    22.804     0.200
     1.135    22.701     0.200
     1.189    23.938     0.200
     1.215    22.842     0.200
     1.228    24.727     0.200
     1.228    24.339     0.200
     1.218    24.239     0.200
     1.259    25.197     0.200
     1.268    25.193     0.200
     1.268    24.853     0.200
     1.268    25.086     0.200
     1.264    25.607     0.200
     1.688    34.231     0.200
     1.688    33.250     0.200
     1.732    33.667     0.200
     1.732    33.467     0.200
     1.759    34.702     0.200
     1.789    34.417     0.200
     2.813    54.040     0.200
     2.970    57.359     0.200
     2.970    57.207     0.200
     4.068    79.153     0.200
     4.872    93.943     0.200
     5.150    99.229     0.200
     6.104   116.646     0.200
     6.131   118.489     0.200
     0.465     9.223     0.200
     0.479     9.432     0.200
     0.479     9.711     0.200
     0.506    10.452     0.200
     0.506    10.342     0.200
     0.676    13.698     0.200
     0.712    14.645     0.200
     0.712    14.844     0.200
     0.815    15.361     0.200
     0.786    15.709     0.200
     0.867    17.887     0.200
     0.867    17.774     0.200
     0.867    17.998     0.200
     1.025    19.696     0.200
     1.028    19.615     0.200
     1.090    21.624     0.200
     1.215    24.034     0.200
     1.215    24.163     0.200
     1.332    26.389     0.200
     1.422    28.810     0.200
     1.422    28.142     0.200
     1.464    27.163     0.200
     1.500    29.254     0.200
     1.615    30.925     0.200
     1.591    31.624     0.200
     1.591    31.466     0.200
     1.945    36.600     0.200
     2.090    43.091     0.200
     2.090    41.218     0.200
     2.092    40.625     0.200
     2.092    40.457     0.200
     2.130    41.295     0.200
     2.130    41.170     0.200
     2.236    43.786     0.200
     2.236    43.110     0.200
     2.340    44.940     0.200
     2.809    53.308     0.200
     3.032    56.985     0.200
     3.362    64.458     0.200
     3.499    67.703     0.200
     4.449    86.032     0.200
     5.260   102.127     0.200
     5.956   113.818     0.200
     0.374     7.963     0.200
     0.374     8.202     0.200
     0.493    10.030     0.200
     0.493    10.618     0.200
     0.554    10.957     0.200
     0.554    11.092     0.200
     0.622    13.336     0.200
     0.768    15.847     0.200
     0.824    16.132     0.200
     0.936    19.245     0.200
     0.936    19.046     0.200
     1.078    21.165     0.200
     1.084    21.391     0.200
     1.084    20.558     0.200
     1.158    21.086     0.200
     1.161    22.852     0.200
     1.199    24.632     0.200
     1.199    23.977     0.200
     1.182    23.974     0.200
     1.182    23.869     0.200
     1.209    22.544     0.200
     1.319    26.942     0.200
     1.319    26.323     0.200
     1.240    24.375     0.200
     1.298    26.194     0.200
     1.298    25.438     0.200
     1.559    29.009     0.200
     1.698    33.052     0.200
     1.734    33.342     0.200
     1.735    33.547     0.200
     1.735    33.426     0.200
     1.800    34.880     0.200
     1.835    34.863     0.200
     2.261    43.696     0.200
     2.982    57.980     0.200
     3.006    58.129     0.200
     3.057    59.304     0.200
     3.057    59.490     0.200
     3.317    63.685     0.200
     4.008    77.783     0.200
     4.412    83.806     0.200
     5.491   106.755     0.200
     6.051   118.505     0.200
     6.089   119.281     0.200
     6.105   119.402     0.200
     0.255     5.275     0.200
     0.255     5.181     0.200
     0.503    10.679     0.200
     0.553    10.252     0.200
     0.553    10.604     0.200
     0.612    12.158     0.200
     0.612    11.935     0.200
     0.881    17.308     0.200
     0.886    18.313     0.200
     1.034    20.360     0.200
     1.034    21.020     0.200
     1.095    21.693     0.200
     1.097    21.321     0.200
     1.103    21.702     0.200
     1.103    22.015     0.200
     1.121    21.933     0.200
     1.170    23.097     0.200
     1.392    28.085     0.200
     1.392    28.272     0.200
     1.296    26.360     0.200
     1.296    25.255     0.200
     1.340    26.966     0.200
     1.412    28.581     0.200
     1.412    28.203     0.200
     1.473    27.399     0.200
     1.660    32.645     0.200
     1.837    35.599     0.200
     2.297    45.813     0.200
     2.297    45.235     0.200
     2.363    46.909     0.200
     3.279    61.976     0.200
     0.425     8.065     0.200
     0.433     8.634     0.200
     0.433     9.228     0.200
     0.460     9.402     0.200
     0.763    15.858     0.200
     0.939    19.412     0.200
     0.955    18.903     0.200
     0.994    20.277     0.200
     0.994    19.629     0.200
     1.190    23.726     0.200
     1.219    24.680     0.200
     1.219    24.227     0.200
     1.210    24.204     0.200
     1.299    25.794     0.200
     1.302    26.116     0.200
     1.410    28.452     0.200
     1.336    26.113     0.200
     1.688    32.747     0.200
     1.768    34.050     0.200
     1.768    34.245     0.200
     2.204    43.068     0.200
     2.204    42.670     0.200
     2.572    49.346     0.200
     2.790    54.183     0.200
     2.910    56.359     0.200
     2.966    56.943     0.200
     3.290    62.706     0.200
     3.290    63.269     0.200
     3.287    63.682     0.200
     4.148    80.271     0.200
     4.321    82.843     0.200
     4.721    92.123     0.200
     4.798    92.502     0.200
     0.247     5.440     0.200
     0.275     6.205     0.200
     0.485    10.647     0.200
     0.585    12.702     0.200
     0.585    12.483     0.200
     0.769    15.561     0.200
     0.769    15.006     0.200
     0.769    14.741     0.200
     0.799    16.111     0.200
     0.847    18.838     0.200
     0.847    18.401     0.200
     1.105    22.643     0.200
     1.120    22.698     0.200
     1.120    22.901     0.200
     1.127    22.607     0.200
     1.127    22.498     0.200
     1.228    24.854     0.200
     1.228    24.619     0.200
     1.228    24.471     0.200
     1.297    25.410     0.200
     1.297    24.989     0.200
     1.409    27.942     0.200
     1.429    28.148     0.200
     1.429    28.413     0.200
     1.486    28.013     0.200
     1.486    27.497     0.200
     1.533    29.456     0.200
     1.748    33.677     0.200
     1.854    36.162     0.200
     1.887    35.804     0.200
     1.975    38.704     0.200
     1.975    37.813     0.200
     1.991    37.692     0.200
     2.077    39.018     0.200
     2.581    48.533     0.200
     2.771    53.165     0.200
     3.190    60.641     0.200
     3.245    63.167     0.200
     3.247    62.543     0.200
     4.185    79.634     0.200
     5.481   105.550     0.200
     0.522     9.551     0.200
     0.522     9.895     0.200
     0.532    11.694     0.200
     0.594    11.889     0.200
     0.594    11.686     0.200
     0.656    13.449     0.200
     0.842    17.505     0.200
     0.950    18.997     0.200
     0.950    19.403     0.200
     0.993    19.518     0.200
     0.993    19.752     0.200
     1.026    18.507     0.200
     1.094    23.029     0.200
     1.290    26.598     0.200
     1.290    26.270     0.200
     1.220    23.711     0.200
     1.238    24.823     0.200
     1.413    26.979     0.200
     1.523    30.342     0.200
     2.246    43.784     0.200
     2.306    46.006     0.200
     2.306    44.537     0.200
     2.287    44.064     0.200
     2.447    46.440     0.200
     4.583    89.503     0.200
     5.185    99.304     0.200
     6.054   117.267     0.200
     0.345     7.771     0.200
     0.371     8.426     0.200
     0.371     8.344     0.200
     0.550    10.492     0.200
     0.550    10.902     0.200
     0.527    10.629     0.200
     0.642    12.673     0.200
     0.777    16.351     0.200
     0.777    16.031     0.200
     0.853    17.799     0.200
     0.901    18.671     0.200
     0.993    19.937     0.200
     0.993    19.647     0.200
     0.993    19.819     0.200
     1.075    20.131     0.200
     1.259    25.285     0.200
     1.259    26.054     0.200
     1.161    23.326     0.200
     1.209    24.393     0.200
     1.347    26.832     0.200
     1.653    30.614     0.200
     1.705    33.066     0.200
     1.705    33.206     0.200
     1.770    33.910     0.200
     1.815    34.956     0.200
     1.815    34.655     0.200
     1.985    39.300     0.200
     2.661    51.480     0.200
     2.747    52.484     0.200
     2.965    57.317     0.200
     3.043    57.881     0.200
     3.173    61.657     0.200
     3.399    66.045     0.200
     3.917    74.760     0.200
     0.136     4.426     0.200
     0.307     6.243     0.200
     0.463     9.578     0.200
     0.515    10.916     0.200
     0.515    11.045     0.200
     0.898    17.487     0.200
     0.894    17.386     0.200
     1.092    22.317     0.200
     1.218    24.486     0.200
     1.259    25.217     0.200
     1.310    26.381     0.200
     1.329    25.995     0.200
     1.393    27.313     0.200
     1.608    30.624     0.200
     2.591    49.060     0.200
     2.683    51.897     0.200
     2.885    55.509     0.200
     3.026    57.803     0.200
     3.290    62.288     0.200
     3.321    63.373     0.200
     3.544    67.549     0.200
     0.391     8.239     0.200
     0.428     8.615     0.200
     0.496    10.254     0.200
     0.767    14.810     0.200
     1.015    20.372     0.200
     1.204    23.939     0.200
     1.222    24.490     0.200
     1.261    25.311     0.200
     1.270    25.408     0.200
     1.421    28.804     0.200
     1.699    32.987     0.200
     1.811    34.829     0.200
     1.912    36.330     0.200
     2.170    42.376     0.200
     2.718    52.626     0.200
     2.952    57.370     0.200
     3.094    59.808     0.200
     3.325    63.714     0.200
     3.332    63.523     0.200
     0.302     6.072     0.200
     0.302     6.178     0.200
     0.471     9.798     0.200
     0.471     9.971     0.200
     0.513    11.047     0.200
     0.734    15.305     0.200
     0.827    16.826     0.200
     0.885    17.269     0.200
     0.906    17.661     0.200
     1.011    20.486     0.200
     1.051    21.238     0.200
     1.094    22.313     0.200
     1.186    22.497     0.200
     1.211    24.214     0.200
     1.211    24.504     0.200
     1.257    25.175     0.200
     1.318    26.100     0.200
     1.335    25.866     0.200
     1.381    28.088     0.200
     1.400    27.042     0.200
     1.402    27.052     0.200
     1.415    27.965     0.200
     1.600    30.000     0.200
     1.600    30.399     0.200
     1.771    32.705     0.200
     1.892    36.627     0.200
     2.103    40.500     0.200
     0.309     6.407     0.200
     0.466     9.461     0.200
     0.511    10.858     0.200
     0.899    17.860     0.200
     0.890    16.933     0.200
     1.089    22.192     0.200
     1.213    24.378     0.200
     1.254    24.882     0.200
     1.314    25.829     0.200
     1.328    25.648     0.200
     1.395    26.908     0.200
     1.605    30.530     0.200
     1.809    34.635     0.200
     1.884    36.502     0.200
     2.290    42.571     0.200
     0.306     6.623     0.200
     0.306     6.449     0.200
     0.466    10.403     0.200
     0.466    10.152     0.200
     0.514    11.146     0.200
     0.729    16.672     0.200
     0.729    15.641     0.200
     0.827    17.248     0.200
     0.827    16.998     0.200
     0.901    17.804     0.200
     0.901    17.996     0.200
     0.886    19.459     0.200
     0.890    17.204     0.200
     0.890    17.017     0.200
     1.005    19.751     0.200
     1.045    21.220     0.200
     1.092    22.421     0.200
     1.180    22.745     0.200
     1.215    24.347     0.200
     1.215    24.605     0.200
     1.258    25.159     0.200
     1.258    25.515     0.200
     1.330    25.599     0.200
     1.330    26.188     0.200
     1.313    26.357     0.200
     1.379    27.150     0.200
     1.394    26.129     0.200
     1.396    27.447     0.200
     1.605    30.642     0.200
     1.605    30.185     0.200
     1.754    34.470     0.200
     1.886    36.201     0.200
     1.958    37.790     0.200
     1.957    36.921     0.200
     1.972    38.263     0.200
     2.108    40.378     0.200
     2.589    49.140     0.200
     2.685    52.001     0.200
     2.703    51.626     0.200
     3.023    57.581     0.200
     3.202    61.857     0.200
     3.234    58.597     0.200
     3.287    62.991     0.200
     3.287    62.486     0.200
     3.317    64.073     0.200
     3.319    63.846     0.200
     3.319    63.577     0.200
     3.694    71.887     0.200
     4.295    82.127     0.200
     4.536    83.361     0.200
     4.722    92.044     0.200
     0.299     5.634     0.200
     0.334     6.893     0.200
     0.535    10.167     0.200
     0.535     9.956     0.200
     0.520    12.330     0.200
     0.602    11.669     0.200
     0.701    16.008     0.200
     0.779    16.971     0.200
     1.010    20.053     0.200
     1.309    26.728     0.200
     1.217    23.897     0.200
     1.253    24.817     0.200
     1.418    27.503     0.200
     1.891    37.120     0.200
     2.264    43.828     0.200
     2.702    51.169     0.200
     0.403     8.501     0.200
     0.403     8.503     0.200
     0.428     8.006     0.200
     0.485    10.169     0.200
     0.666    15.063     0.200
     0.772    15.167     0.200
     0.968    19.812     0.200
     0.982    19.139     0.200
     1.008    20.479     0.200
     1.008    20.773     0.200
     1.062    20.541     0.200
     1.204    23.901     0.200
     1.252    24.475     0.200
     1.212    24.320     0.200
     1.249    24.589     0.200
     1.249    24.992     0.200
     1.276    24.661     0.200
     1.278    24.835     0.200
     1.309    23.614     0.200
     1.297    26.047     0.200
     1.417    28.269     0.200
     1.661    30.593     0.200
     1.688    31.875     0.200
     1.757    34.654     0.200
     1.794    34.268     0.200
     1.794    34.439     0.200
     1.800    34.739     0.200
     1.829    36.538     0.200
     1.846    35.512     0.200
     1.923    37.483     0.200
     2.179    41.060     0.200
     2.940    56.012     0.200
     2.940    57.082     0.200
     3.319    63.161     0.200
     4.727    91.921     0.200
     0.585    12.053     0.200
     0.850    17.070     0.200
     0.893    19.460     0.200
     0.986    19.625     0.200
     1.310    25.100     0.200
     1.310    25.723     0.200
     1.322    26.360     0.200
     1.322    27.186     0.200
     1.423    29.428     0.200
     1.850    36.178     0.200
     1.893    35.885     0.200
     1.893    36.090     0.200
     1.913    35.786     0.200
     1.913    36.706     0.200
     3.383    65.602     0.200
     3.403    66.169     0.200
     0.264     5.507     0.200
     0.335     6.625     0.200
     0.428     9.318     0.200
     0.428     9.016     0.200
     0.589    12.395     0.200
     0.589    12.075     0.200
     0.589    11.564     0.200
     0.743    15.568     0.200
     0.774    14.595     0.200
     0.774    15.175     0.200
     0.853    18.975     0.200
     0.967    18.893     0.200
     0.967    18.775     0.200
     1.045    21.672     0.200
     1.045    21.032     0.200
     1.091    21.936     0.200
     1.091    21.756     0.200
     1.091    22.475     0.200
     1.118    22.224     0.200
     1.118    21.823     0.200
     1.172    23.439     0.200
     1.172    23.748     0.200
     1.172    23.903     0.200
     1.166    22.609     0.200
     1.271    24.818     0.200
     1.271    24.698     0.200
     1.320    26.094     0.200
     1.358    26.642     0.200
     1.374    28.016     0.200
     1.406    27.808     0.200
     1.437    27.749     0.200
     1.437    28.841     0.200
     1.486    28.766     0.200
     1.520    29.950     0.200
     1.669    31.262     0.200
     1.795    34.885     0.200
     1.795    35.098     0.200
     1.924    36.507     0.200
     1.984    37.559     0.200
     2.098    41.499     0.200
     2.845    55.109     0.200
     3.163    61.166     0.200
     3.205    62.285     0.200
     3.205    61.639     0.200
     3.947    76.928     0.200
     4.170    80.815     0.200
     4.170    79.607     0.200
     4.307    82.429     0.200
     0.277     5.952     0.200
     0.334     7.481     0.200
     0.538    10.631     0.200
     0.608    11.956     0.200
     0.576    11.247     0.200
     0.806    16.750     0.200
     0.851    18.273     0.200
     0.955    19.004     0.200
     1.060    20.866     0.200
     1.116    21.076     0.200
     1.152    23.485     0.200
     1.133    21.764     0.200
     1.324    27.110     0.200
     1.215    24.521     0.200
     1.786    33.920     0.200
     1.840    35.552     0.200
     1.828    34.964     0.200
     0.339     7.128     0.200
     0.448     9.743     0.200
     0.448    10.137     0.200
     0.526    10.606     0.200
     0.526    10.501     0.200
     0.763    15.674     0.200
     0.838    16.561     0.200
     0.838    17.233     0.200
     0.790    17.711     0.200
     0.913    17.386     0.200
     1.043    21.321     0.200
     1.043    21.458     0.200
     1.054    21.746     0.200
     1.145    22.087     0.200
     1.145    23.739     0.200
     1.102    22.846     0.200
     1.193    23.902     0.200
     1.375    27.313     0.200
     1.428    28.138     0.200
     1.456    28.987     0.200
     1.548    29.437     0.200
     2.328    43.924     0.200
     4.230    80.913     0.200
     0.447     8.934     0.200
     0.447     9.004     0.200
     0.514    10.007     0.200
     0.514    10.179     0.200
     0.489    10.078     0.200
     0.489     9.968     0.200
     0.707    14.969     0.200
     0.717    14.931     0.200
     0.851    15.745     0.200
     0.820    16.152     0.200
     0.925    18.758     0.200
     0.925    18.938     0.200
     1.063    19.872     0.200
     1.066    20.198     0.200
     1.176    24.179     0.200
     1.108    21.822     0.200
     1.108    21.658     0.200
     1.211    25.922     0.200
     1.174    23.062     0.200
     1.492    26.940     0.200
     1.479    29.176     0.200
     1.555    31.005     0.200
     1.650    31.280     0.200
     1.625    32.682     0.200
     1.792    33.468     0.200
     1.981    37.035     0.200
     2.147    42.598     0.200
     2.147    42.957     0.200
     2.146    42.522     0.200
     2.155    43.236     0.200
     2.155    43.408     0.200
     2.289    45.408     0.200
     2.327    44.437     0.200
     2.327    44.132     0.200
     3.355    63.952     0.200
     0.237     4.924     0.200
     0.422     9.131     0.200
     0.550    11.750     0.200
     0.550    11.855     0.200
     0.550    11.707     0.200
     0.736    15.325     0.200
     0.917    17.168     0.200
     1.022    21.309     0.200
     1.022    20.621     0.200
     1.073    21.766     0.200
     1.117    22.511     0.200
     1.117    22.132     0.200
     1.167    22.944     0.200
     1.167    23.757     0.200
     1.167    23.554     0.200
     1.314    26.811     0.200
     1.314    26.526     0.200
     1.302    26.637     0.200
     1.302    26.090     0.200
     1.400    27.883     0.200
     1.400    27.992     0.200
     1.439    28.622     0.200
     1.473    28.604     0.200
     1.473    27.854     0.200
     1.527    29.824     0.200
     1.619    30.671     0.200
     1.825    35.242     0.200
     1.876    36.173     0.200
     1.882    36.829     0.200
     1.882    35.321     0.200
     1.962    38.568     0.200
     2.008    39.772     0.200
     2.232    43.830     0.200
     2.232    43.264     0.200
     2.234    43.846     0.200
     2.342    44.060     0.200
     2.342    44.498     0.200
     2.640    49.536     0.200
     2.792    54.129     0.200
     3.190    60.454     0.200
     3.219    62.534     0.200
     3.219    62.155     0.200
     3.600    67.691     0.200
     3.676    70.173     0.200
     4.205    80.662     0.200
     4.205    80.412     0.200
     0.260     5.590     0.200
     0.319     6.448     0.200
     0.548     9.871     0.200
     0.634    12.412     0.200
     0.634    12.523     0.200
     0.750    16.420     0.200
     0.810    15.306     0.200
     0.810    15.766     0.200
     0.891    18.758     0.200
     1.053    22.279     0.200
     1.024    19.879     0.200
     1.060    20.048     0.200
     1.006    20.765     0.200
     1.035    20.901     0.200
     1.189    24.345     0.200
     1.291    25.136     0.200
     1.315    26.325     0.200
     1.412    26.048     0.200
     1.461    27.069     0.200
     1.593    28.821     0.200
     1.614    28.751     0.200
     2.296    44.512     0.200
     2.689    50.975     0.200
     2.980    57.654     0.200
     3.283    63.724     0.200
     0.360     7.897     0.200
     0.360     7.803     0.200
     0.505    10.306     0.200
     0.650    12.570     0.200
     0.650    12.758     0.200
     0.783    16.770     0.200
     0.892    18.973     0.200
     0.953    19.619     0.200
     1.091    21.416     0.200
     1.091    21.596     0.200
     1.160    21.211     0.200
     1.163    22.602     0.200
     1.189    24.251     0.200
     1.189    24.525     0.200
     1.198    23.790     0.200
     1.257    25.446     0.200
     1.344    25.570     0.200
     1.307    25.617     0.200
     1.752    34.214     0.200
     1.752    34.074     0.200
     1.831    34.713     0.200
     1.854    33.263     0.200
     1.814    35.371     0.200
     1.814    34.895     0.200
     2.068    39.336     0.200
     2.068    40.539     0.200
     2.758    52.404     0.200
     2.732    53.028     0.200
     2.659    51.414     0.200
     2.833    53.963     0.200
     3.013    58.028     0.200
     0.366     7.928     0.200
     0.366     7.749     0.200
     0.500    10.261     0.200
     0.653    12.176     0.200
     0.778    16.297     0.200
     0.898    19.344     0.200
     0.950    19.485     0.200
     0.950    19.673     0.200
     0.950    19.394     0.200
     1.092    21.477     0.200
     1.080    21.235     0.200
     1.080    21.071     0.200
     1.193    23.726     0.200
     1.201    24.287     0.200
     1.195    24.677     0.200
     1.195    24.435     0.200
     1.212    22.952     0.200
     1.301    25.981     0.200
     1.348    26.236     0.200
     1.714    32.461     0.200
     1.748    33.960     0.200
     1.809    34.768     0.200
     1.836    34.969     0.200
     2.073    39.890     0.200
     2.729    52.900     0.200
     2.762    53.019     0.200
     2.997    58.307     0.200
     3.364    64.763     0.200
     0.318     7.980     0.200
     0.462    11.196     0.200
     0.533    11.652     0.200
     0.533    11.410     0.200
     0.777    17.037     0.200
     0.797    17.325     0.200
     0.797    17.794     0.200
     0.934    18.962     0.200
     0.934    18.173     0.200
     1.146    22.131     0.200
     1.146    22.858     0.200
     1.208    24.283     0.200
     1.228    24.017     0.200
     1.470    27.010     0.200
     0.249     5.210     0.200
     0.586    11.735     0.200
     0.591    12.661     0.200
     0.679    13.286     0.200
     0.828    16.727     0.200
     0.887    18.409     0.200
     0.927    18.908     0.200
     0.933    19.452     0.200
     1.450    27.868     0.200
     1.517    30.422     0.200
     1.650    31.802     0.200
     0.384     7.669     0.200
     0.485    10.421     0.200
     0.714    13.720     0.200
     0.776    15.281     0.200
     0.935    17.925     0.200
     0.975    20.123     0.200
     1.008    20.606     0.200
     1.148    22.850     0.200
     1.198    24.074     0.200
     1.247    25.265     0.200
     1.274    25.838     0.200
     1.664    31.893     0.200
     1.699    32.613     0.200
     1.795    34.161     0.200
     1.799    34.813     0.200
     0.375     8.309     0.200
     0.434     9.488     0.200
     0.503    10.603     0.200
     0.768    16.267     0.200
     0.747    15.810     0.200
     0.871    16.828     0.200
     1.023    20.394     0.200
     1.013    20.647     0.200
     1.075    22.256     0.200
     1.171    23.427     0.200
     1.157    23.209     0.200
     1.177    23.921     0.200
     1.299    26.073     0.200
     1.354    27.068     0.200
     1.421    27.699     0.200
     1.737    33.502     0.200
     1.774    32.938     0.200
     1.782    34.546     0.200
     1.841    34.902     0.200
     2.837    54.034     0.200
     4.249    81.406     0.200
     0.413     9.295     0.200
     0.413     8.816     0.200
     0.572    11.865     0.200
     0.689    13.391     0.200
     0.814    15.278     0.200
     0.838    17.644     0.200
     0.841    17.495     0.200
     1.002    21.403     0.200
     1.207    23.875     0.200
     1.488    27.327     0.200
     3.155    59.888     0.200
     3.190    61.864     0.200
     0.468    11.078     0.200
     0.547    12.094     0.200
     0.760    16.976     0.200
     1.051    21.166     0.200
     0.923    19.704     0.200
     0.923    19.575     0.200
     0.982    20.509     0.200
     0.982    20.787     0.200
     0.994    20.701     0.200
     1.068    21.476     0.200
     1.068    22.077     0.200
     1.200    24.325     0.200
     1.288    26.361     0.200
     1.288    25.951     0.200
     1.319    26.470     0.200
     1.319    25.380     0.200
     1.465    28.283     0.200
     1.536    29.208     0.200
     1.755    34.629     0.200
     2.793    53.484     0.200
     5.100    98.726     0.200
     0.422     9.814     0.200
     0.687    16.138     0.200
     0.929    19.205     0.200
     0.929    19.627     0.200
     0.988    20.532     0.200
     0.994    20.494     0.200
     1.074    21.871     0.200
     1.074    21.653     0.200
     1.273    25.156     0.200
     1.326    26.252     0.200
     1.326    25.241     0.200
     1.290    26.194     0.200
     1.290    26.405     0.200
     1.290    25.444     0.200
     1.472    28.416     0.200
     1.541    29.956     0.200
     1.543    29.581     0.200
     1.678    31.844     0.200
     1.669    31.752     0.200
     1.760    34.707     0.200
     2.194    42.930     0.200
     5.093    97.825     0.200
     0.509    10.143     0.200
     0.656    13.492     0.200
     0.763    16.202     0.200
     0.797    14.165     0.200
     0.797    15.085     0.200
     0.971    19.469     0.200
     0.999    19.689     0.200
     1.058    20.263     0.200
     1.148    23.780     0.200
     1.151    22.783     0.200
     1.194    22.948     0.200
     1.306    26.695     0.200
     1.261    24.972     0.200
     1.261    24.661     0.200
     1.292    26.615     0.200
     1.280    26.076     0.200
     1.280    26.355     0.200
     1.306    26.816     0.200
     1.408    26.651     0.200
     1.525    30.377     0.200
     1.584    28.812     0.200
     2.192    43.381     0.200
     3.059    58.827     0.200
     3.796    72.900     0.200
     0.289     7.433     0.200
     0.788    17.760     0.200
     0.807    17.420     0.200
     0.807    17.311     0.200
     1.066    21.517     0.200
     1.066    21.653     0.200
     1.093    22.779     0.200
     1.106    22.068     0.200
     1.106    22.298     0.200
     1.237    24.165     0.200
     1.237    24.447     0.200
     1.237    25.144     0.200
     1.472    27.232     0.200
     1.673    29.994     0.200
     0.804    15.667     0.200
     0.920    19.767     0.200
     1.018    19.239     0.200
     1.349    24.867     0.200
     1.486    29.126     0.200
     1.680    31.506     0.200
     1.707    31.599     0.200
     1.814    34.443     0.200
     2.085    39.649     0.200
     0.685    13.386     0.200
     0.776    14.249     0.200
     0.776    14.479     0.200
     0.858    17.430     0.200
     0.952    19.943     0.200
     0.970    19.324     0.200
     0.970    19.603     0.200
     1.123    23.335     0.200
     1.281    26.113     0.200
     1.250    24.861     0.200
     1.250    25.081     0.200
     1.261    25.406     0.200
     1.261    25.906     0.200
     1.354    28.034     0.200
     1.393    25.384     0.200
     1.439    26.797     0.200
     1.439    28.342     0.200
     1.496    29.848     0.200
     1.554    29.655     0.200
     1.566    30.555     0.200
     1.994    37.845     0.200
     0.561    10.574     0.200
     0.812    16.468     0.200
     0.910    16.817     0.200
     0.967    19.714     0.200
     1.076    21.387     0.200
     1.167    22.263     0.200
     1.199    24.127     0.200
     1.223    24.361     0.200
     1.273    25.343     0.200
     1.518    28.278     0.200
     1.567    29.674     0.200
     1.697    32.032     0.200
     1.821    34.490     0.200
     5.237   100.701     0.200
     0.553    10.108     0.200
     0.805    17.073     0.200
     0.921    17.189     0.200
     0.965    19.825     0.200
     1.082    21.259     0.200
     1.179    22.038     0.200
     1.201    23.795     0.200
     1.217    24.101     0.200
     1.530    28.472     0.200
     1.578    29.448     0.200
     1.625    31.556     0.200
     5.226    99.171     0.200
     0.299     7.017     0.200
     0.299     7.267     0.200
     0.878    18.365     0.200
     1.148    21.710     0.200
     1.148    21.812     0.200
     1.128    22.954     0.200
     1.333    26.645     0.200
     1.333    26.875     0.200
     1.307    26.432     0.200
     1.368    26.618     0.200
     1.514    29.362     0.200
     1.540    28.911     0.200
     1.722    31.725     0.200
     1.880    37.137     0.200
     2.252    41.631     0.200
     0.505    11.544     0.200
     0.909    17.636     0.200
     0.909    17.936     0.200
     0.954    20.668     0.200
     1.124    22.468     0.200
     1.124    21.378     0.200
     1.175    24.587     0.200
     1.314    24.806     0.200
     1.299    24.979     0.200
     1.325    25.700     0.200
     1.342    26.068     0.200
     1.325    26.532     0.200
     1.369    27.175     0.200
     1.477    28.325     0.200
     1.421    29.774     0.200
     1.421    28.196     0.200
     1.693    34.103     0.200
     0.403     7.807     0.200
     0.405     7.671     0.200
     0.965    20.014     0.200
     1.048    19.763     0.200
     1.048    19.641     0.200
     1.184    23.977     0.200
     1.252    25.307     0.200
     1.277    26.736     0.200
     1.277    26.318     0.200
     1.445    28.397     0.200
     1.703    32.805     0.200
     1.702    33.040     0.200
     1.694    33.247     0.200
     1.694    32.844     0.200
     1.834    35.190     0.200
     2.168    42.221     0.200
     3.966    75.697     0.200
     0.407     8.039     0.200
     0.407     8.469     0.200
     0.491    10.867     0.200
     0.494    10.403     0.200
     0.758    17.268     0.200
     0.986    20.317     0.200
     0.986    19.840     0.200
     1.061    21.158     0.200
     1.144    22.799     0.200
     1.144    22.322     0.200
     1.159    23.682     0.200
     1.159    23.283     0.200
     1.243    25.380     0.200
     1.243    24.708     0.200
     1.274    25.777     0.200
     1.311    26.438     0.200
     1.344    27.352     0.200
     1.344    26.984     0.200
     1.399    26.938     0.200
     1.542    29.900     0.200
     1.751    32.231     0.200
     1.751    33.638     0.200
     1.807    35.011     0.200
     1.807    35.331     0.200
     1.801    32.944     0.200
     1.894    34.215     0.200
     1.932    37.025     0.200
     0.408     8.449     0.200
     0.408     8.581     0.200
     0.500    10.763     0.200
     0.503    10.260     0.200
     0.766    16.212     0.200
     0.766    17.157     0.200
     0.982    20.515     0.200
     0.982    20.000     0.200
     1.070    21.580     0.200
     1.070    21.470     0.200
     1.151    22.375     0.200
     1.151    22.868     0.200
     1.153    23.209     0.200
     1.245    25.324     0.200
     1.245    24.957     0.200
     1.269    26.180     0.200
     1.269    25.820     0.200
     1.310    26.771     0.200
     1.352    26.295     0.200
     1.352    26.998     0.200
     1.407    27.791     0.200
     1.549    30.061     0.200
     1.587    30.435     0.200
     1.759    33.960     0.200
     1.759    32.203     0.200
     1.808    33.309     0.200
     1.809    35.351     0.200
     1.939    37.697     0.200
     2.706    52.024     0.200
     0.497    10.304     0.200
     0.978    20.084     0.200
     1.631    30.573     0.200
     0.504    10.311     0.200
     0.739    14.067     0.200
     0.871    15.916     0.200
     1.261    26.045     0.200
     1.521    28.162     0.200
     1.555    28.574     0.200
     1.671    30.665     0.200
     1.825    35.114     0.200
     0.502     9.428     0.200
     0.955    19.492     0.200
     1.270    26.697     0.200
     1.321    27.493     0.200
     1.573    28.313     0.200
     1.805    34.033     0.200
     1.894    36.026     0.200
     0.669    11.984     0.200
     0.824    15.095     0.200
     0.903    17.792     0.200
     1.148    24.410     0.200
     1.146    23.396     0.200
     1.329    24.112     0.200
     1.357    25.063     0.200
     1.468    27.407     0.200
     1.728    34.051     0.200
     1.784    34.691     0.200
     0.531    10.587     0.200
     0.718    14.015     0.200
     0.923    17.318     0.200
     0.992    20.216     0.200
     1.002    20.898     0.200
     1.016    19.733     0.200
     1.307    28.003     0.200
     1.358    28.042     0.200
     1.492    29.604     0.200
     1.573    29.326     0.200
     1.589    31.507     0.200
     1.608    30.902     0.200
     1.723    32.333     0.200
     1.754    33.538     0.200
     1.772    33.758     0.200
     1.931    37.918     0.200
     1.972    38.075     0.200
     2.161    43.902     0.200
     0.473    10.095     0.200
     0.642    11.582     0.200
     0.887    17.662     0.200
     0.960    17.530     0.200
     1.383    28.769     0.200
     1.442    27.206     0.200
     2.550    48.187     0.200
     3.129    59.590     0.200
     0.480     9.612     0.200
     1.400    28.669     0.200
     1.504    27.531     0.200
     2.037    39.013     0.200
     0.474     8.809     0.200
     1.103    23.988     0.200
     1.491    28.189     0.200
     1.777    33.405     0.200
     2.048    38.919     0.200
     0.515     9.570     0.200
     0.531    10.143     0.200
     0.861    15.907     0.200
     1.042    21.816     0.200
     1.191    22.520     0.200
     1.331    25.061     0.200
     1.389    26.403     0.200
     1.517    27.587     0.200
     1.660    30.874     0.200
     1.830    35.056     0.200
     0.470    10.779     0.200
     0.650    12.206     0.200
     0.778    14.847     0.200
     0.880    16.907     0.200
     0.967    17.898     0.200
     1.102    23.338     0.200
     1.303    23.880     0.200
     1.335    23.929     0.200
     1.450    27.190     0.200
     1.492    27.357     0.200
     1.780    33.283     0.200
     0.507    10.292     0.200
     0.803    15.368     0.200
     1.227    25.686     0.200
     1.644    31.080     0.200
     0.509    10.247     0.200
     0.793    15.135     0.200
     0.809    16.056     0.200
     0.901    18.677     0.200
     0.939    19.695     0.200
     1.075    21.298     0.200
     1.222    26.556     0.200
     1.448    26.840     0.200
     1.479    27.684     0.200
     1.593    30.320     0.200
     1.636    30.746     0.200
     1.763    31.702     0.200
     1.922    36.257     0.200
     2.048    41.082     0.200
     0.534     9.640     0.200
     0.685    12.706     0.200
     0.501     9.316     0.200
     0.736    15.254     0.200
     0.872    15.639     0.200
     1.053    21.237     0.200
     1.261    26.445     0.200
     1.521    28.452     0.200
     1.556    29.349     0.200
     1.672    32.032     0.200
     2.002    38.538     0.200
     2.107    40.379     0.200
     0.489    10.414     0.200
     0.585    10.822     0.200
     0.934    19.721     0.200
     1.241    22.975     0.200
     1.230    25.461     0.200
     2.110    40.164     0.200
     2.351    43.961     0.200
     2.557    48.157     0.200
     2.499    47.181     0.200
     3.072    59.627     0.200
     0.483     9.908     0.200
     0.510    10.577     0.200
     0.756    14.615     0.200
     0.859    16.406     0.200
     0.943    20.614     0.200
     1.048    21.499     0.200
     1.260    26.398     0.200
     1.511    28.922     0.200
     1.544    29.152     0.200
     1.659    31.388     0.200
     1.921    37.737     0.200
     0.480     9.896     0.200
     0.585    10.898     0.200
     0.736    13.334     0.200
     0.906    16.574     0.200
     0.928    18.625     0.200
     0.937    20.500     0.200
     1.060    22.291     0.200
     1.240    23.548     0.200
     1.271    23.837     0.200
     1.236    24.582     0.200
     2.110    40.807     0.200
     0.564    11.678     0.200
     0.597    11.017     0.200
     0.851    18.281     0.200
     0.938    16.870     0.200
     1.129    24.962     0.200
     0.527    10.481     0.200
     0.493     8.825     0.200
     0.653    12.467     0.200
     0.796    15.133     0.200
     1.120    22.806     0.200
     1.340    24.662     0.200
     1.405    29.096     0.200
     1.453    27.673     0.200
     1.782    33.320     0.200
     1.932    37.015     0.200
     0.510    10.053     0.200
     0.740    14.310     0.200
     0.877    16.647     0.200
     0.952    19.528     0.200
     0.989    20.983     0.200
     1.045    20.781     0.200
     1.269    26.854     0.200
     1.315    26.786     0.200
     1.448    28.845     0.200
     1.527    28.258     0.200
     1.561    28.741     0.200
     1.677    31.330     0.200
     1.818    34.839     0.200
     1.889    36.970     0.200
     1.932    37.678     0.200
     0.489     9.531     0.200
     0.626    11.475     0.200
     1.098    22.720     0.200
     0.512     9.467     0.200
     0.618    11.868     0.200
     0.488     9.663     0.200
     0.609    11.115     0.200
     0.760    15.914     0.200
     0.932    17.916     0.200
     0.926    20.336     0.200
     1.085    22.941     0.200
     1.370    28.081     0.200
     1.409    26.642     0.200
     1.459    28.344     0.200
     1.586    28.025     0.200
     1.739    31.904     0.200
     1.866    34.690     0.200
     1.927    38.194     0.200
     0.568    11.626     0.200
     0.699    13.741     0.200
     0.878    17.349     0.200
     0.927    18.099     0.200
     1.037    18.981     0.200
     0.849    18.774     0.200
     1.202    25.446     0.200
     1.364    25.919     0.200
     1.388    26.413     0.200
     1.565    29.520     0.200
     1.693    30.113     0.200
     1.776    34.359     0.200
     1.835    35.544     0.200
     1.822    34.535     0.200
     1.958    36.441     0.200
     0.505    10.484     0.200
     0.873    16.500     0.200
     0.990    21.691     0.200
     0.948    19.504     0.200
     1.049    21.211     0.200
     1.183    22.209     0.200
     1.264    26.951     0.200
     1.310    27.129     0.200
     1.557    28.817     0.200
     1.547    31.458     0.200
     1.673    30.913     0.200
     1.884    36.026     0.200
     1.822    34.889     0.200
     2.004    37.528     0.200
     2.128    42.375     0.200
     2.274    43.744     0.200
     0.632    11.489     0.200
     0.794    16.454     0.200
     0.901    19.004     0.200
     0.961    18.176     0.200
     1.118    23.070     0.200
     1.432    26.930     0.200
     1.488    27.896     0.200
     1.760    32.984     0.200
     1.891    35.324     0.200
     2.066    41.172     0.200
     0.551    12.044     0.200
     0.643    11.457     0.200
     1.153    24.542     0.200
     1.332    24.830     0.200
     1.508    26.664     0.200
     1.767    34.144     0.200
     1.902    35.407     0.200
     1.950    37.441     0.200
     0.507    10.219     0.200
     0.774    14.783     0.200
     0.888    18.477     0.200
     0.933    20.206     0.200
     1.094    19.998     0.200
     1.086    21.329     0.200
     1.903    36.275     0.200
     0.507    10.298     0.200
     0.782    14.936     0.200
     0.816    16.893     0.200
     0.936    19.835     0.200
     1.101    21.068     0.200
     1.082    21.880     0.200
     1.915    37.232     0.200
     2.039    41.893     0.200
     2.129    42.625     0.200
     2.750    53.011     0.200
     2.890    53.730     0.200
     3.055    55.960     0.200
     3.070    59.333     0.200
     0.461     9.039     0.200
     0.640    11.545     0.200
     0.880    16.814     0.200
     1.088    22.699     0.200
     1.292    24.798     0.200
     1.325    25.637     0.200
     1.088    23.551     0.200
     0.438     8.689     0.200
     0.629    10.880     0.200
     1.062    22.575     0.200
     1.461    28.706     0.200
     1.881    36.100     0.200
     1.972    38.326     0.200
     2.067    39.963     0.200
     2.489    47.961     0.200
     0.462     9.228     0.200
     0.859    17.570     0.200
     0.494    10.816     0.200
     0.852    16.144     0.200
     0.928    19.234     0.200
     1.245    26.403     0.200
     1.289    27.177     0.200
     1.683    30.624     0.200
     1.982    36.993     0.200
     0.479     9.693     0.200
     0.588    11.181     0.200
     0.909    16.780     0.200
     0.937    19.936     0.200
     1.234    24.475     0.200
     2.107    40.938     0.200
     2.316    43.269     0.200
     2.348    45.648     0.200
     0.511     9.784     0.200
     0.643    11.762     0.200
     0.802    14.791     0.200
     0.901    19.033     0.200
     1.126    23.697     0.200
     1.169    22.847     0.200
     1.331    25.203     0.200
     1.442    27.652     0.200
     2.551    49.164     0.200
     0.495    10.106     0.200
     0.777    14.623     0.200
     0.817    15.205     0.200
     1.131    21.906     0.200
     1.076    21.292     0.200
     1.469    27.879     0.200
     1.617    31.518     0.200
     0.526    10.860     0.200
     0.722    13.825     0.200
     0.914    17.390     0.200
     0.983    20.088     0.200
     1.022    20.785     0.200
     1.299    27.770     0.200
     1.349    27.660     0.200
     1.483    29.969     0.200
     1.564    29.023     0.200
     1.714    32.502     0.200
     1.745    33.284     0.200
     1.782    33.983     0.200
     2.148    41.310     0.200
     2.218    42.535     0.200
     1.721    31.966     0.200
     2.108    40.736     0.200
     0.557    10.488     0.200
     0.597    10.537     0.200
     0.858    18.502     0.200
     1.262    23.755     0.200
     0.533    11.109     0.200
     0.484     9.567     0.200
     0.628    12.136     0.200
     0.772    15.278     0.200
     0.904    18.822     0.200
     0.928    19.754     0.200
     1.096    23.366     0.200
     1.284    23.993     0.200
     1.198    23.633     0.200
     1.315    25.300     0.200
     1.428    27.222     0.200
     1.604    29.496     0.200
     1.758    33.804     0.200
     1.942    39.694     0.200
     0.490     9.831     0.200
     0.637    12.320     0.200
     0.783    17.632     0.200
     0.660    11.851     0.200
     1.110    23.175     0.200
     0.577    11.304     0.200
     0.716    13.216     0.200
     0.895    18.656     0.200
     1.381    26.381     0.200
     1.405    26.856     0.200
     0.616    11.420     0.200
     0.608    11.820     0.200
     1.172    23.958     0.200
     0.429     9.712     0.200
     0.501    10.568     0.200
     0.745    14.538     0.200
     0.862    16.501     0.200
     0.938    20.668     0.200
     0.907    20.923     0.200
     1.172    22.430     0.200
     1.511    28.326     0.200
     1.662    32.762     0.200
     1.834    35.443     0.200
     1.992    38.350     0.200
     2.119    41.038     0.200
     2.357    44.173     0.200
     2.770    53.184     0.200
     2.967    57.556     0.200
     2.986    57.225     0.200
     3.321    60.201     0.200
     3.488    64.179     0.200
     3.891    72.594     0.200
     3.998    77.083     0.200
     2.283    44.904     0.200
     2.986    55.573     0.200
     2.507    47.167     0.200
     3.244    59.980     0.200
     0.492     9.840     0.200
     0.636    11.856     0.200
     1.293    24.272     0.200
     1.323    24.571     0.200
     0.441     9.481     0.200
     0.578    10.906     0.200
     2.534    48.442     0.200
     3.266    59.766     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
