#!/bin/bash
gmt begin hubbard6.23_tt5s_local_ISLE pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance hubbard6.23'
# Station code
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   110.000 Single station: ISLE 
EOF
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6  0.000
  0.6 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    18.350
     0.900    19.731
     1.000    21.112
     1.100    22.493
     1.200    23.874
     1.300    25.256
     1.400    26.637
     1.500    28.018
     1.600    29.399
     1.700    30.780
     1.800    32.161
     1.900    33.542
     2.000    34.923
     2.100    36.304
     2.200    37.685
     2.300    39.066
     2.400    40.447
     2.500    41.829
     2.600    43.210
     2.700    44.591
     2.800    45.972
     2.900    47.353
     3.000    48.734
     3.100    50.115
     3.200    51.496
     3.300    52.877
     3.400    54.258
     3.500    55.639
     3.600    57.020
     3.700    58.401
     3.800    59.781
     3.900    61.162
     4.000    62.543
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    55.020 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.274
     0.200     3.848
     0.300     5.556
     0.400     7.304
     0.500     9.070
     0.600    10.844
     0.700    12.624
     0.800    14.406
     0.900    16.191
     1.000    17.977
     1.100    19.764
     1.200    21.552
     1.300    23.341
     1.400    25.130
     1.500    26.919
     1.600    28.709
     1.700    30.499
     1.800    32.289
     1.900    34.080
     2.000    35.870
     2.100    37.661
     2.200    39.452
     2.300    41.243
     2.400    43.033
     2.500    44.824
     2.600    46.615
     2.700    48.406
     2.800    50.197
     2.900    51.988
     3.000    53.779
     3.100    55.570
     3.200    57.361
     3.300    59.152
     3.400    60.943
     3.500    62.734
     3.600    64.525
     3.700    66.316
     3.800    68.106
     3.900    69.897
     4.000    71.688
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    63.525 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    32.050
     0.900    34.478
     1.000    36.906
     1.100    39.334
     1.200    41.763
     1.300    44.191
     1.400    46.619
     1.500    49.048
     1.600    51.476
     1.700    53.904
     1.800    56.332
     1.900    58.761
     2.000    61.189
     2.100    63.617
     2.200    66.045
     2.300    68.474
     2.400    70.902
     2.500    73.330
     2.600    75.758
     2.700    78.187
     2.800    80.615
     2.900    83.043
     3.000    85.471
     3.100    87.900
     3.200    90.328
     3.300    92.756
     3.400    95.185
     3.500    97.613
     3.600   100.041
     3.700   102.469
     3.800   104.896
     3.900   107.324
     4.000   109.751
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    98.041 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.972
     0.200     6.721
     0.300     9.704
     0.400    12.757
     0.500    15.840
     0.600    18.939
     0.700    22.047
     0.800    25.160
     0.900    28.277
     1.000    31.396
     1.100    34.517
     1.200    37.640
     1.300    40.764
     1.400    43.889
     1.500    47.014
     1.600    50.140
     1.700    53.266
     1.800    56.393
     1.900    59.520
     2.000    62.647
     2.100    65.774
     2.200    68.902
     2.300    72.029
     2.400    75.157
     2.500    78.285
     2.600    81.413
     2.700    84.541
     2.800    87.669
     2.900    90.797
     3.000    93.925
     3.100    97.052
     3.200   100.180
     3.300   103.308
     3.400   106.436
     3.500   109.563
     3.600   112.691
     3.700   115.819
     3.800   118.947
     3.900   122.074
     4.000   125.202
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   111.691 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    20.623
     1.000    22.005
     1.100    23.386
     1.200    24.767
     1.300    26.148
     1.400    27.529
     1.500    28.910
     1.600    30.291
     1.700    31.672
     1.800    33.053
     1.900    34.434
     2.000    35.816
     2.100    37.197
     2.200    38.578
     2.300    39.959
     2.400    41.340
     2.500    42.721
     2.600    44.102
     2.700    45.483
     2.800    46.864
     2.900    48.245
     3.000    49.626
     3.100    51.008
     3.200    52.389
     3.300    53.770
     3.400    55.151
     3.500    56.532
     3.600    57.913
     3.700    59.293
     3.800    60.674
     3.900    62.055
     4.000    63.435
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.793
     0.200     3.587
     0.300     5.380
     0.400     7.173
     0.500     8.966
     0.600    10.760
     0.700    12.553
     0.800    14.346
     0.900    16.140
     1.000    17.933
     1.100    19.726
     1.200    21.520
     1.300    23.313
     1.400    25.106
     1.500    26.899
     1.600    28.693
     1.700    30.486
     1.800    32.279
     1.900    34.073
     2.000    35.866
     2.100    37.659
     2.200    39.453
     2.300    41.246
     2.400    43.039
     2.500    44.832
     2.600    46.626
     2.700    48.419
     2.800    50.212
     2.900    52.005
     3.000    53.798
     3.100    55.590
     3.200    57.383
     3.300    59.175
     3.400    60.968
     3.500    62.761
     3.600    64.553
     3.700    66.346
     3.800    68.139
     3.900    69.931
     4.000    71.724
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    36.021
     1.000    38.449
     1.100    40.877
     1.200    43.306
     1.300    45.734
     1.400    48.162
     1.500    50.590
     1.600    53.019
     1.700    55.447
     1.800    57.875
     1.900    60.303
     2.000    62.732
     2.100    65.160
     2.200    67.588
     2.300    70.017
     2.400    72.445
     2.500    74.873
     2.600    77.301
     2.700    79.730
     2.800    82.158
     2.900    84.586
     3.000    87.014
     3.100    89.443
     3.200    91.871
     3.300    94.299
     3.400    96.727
     3.500    99.156
     3.600   101.584
     3.700   104.012
     3.800   106.440
     3.900   108.867
     4.000   111.295
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.132
     0.200     6.264
     0.300     9.396
     0.400    12.528
     0.500    15.660
     0.600    18.792
     0.700    21.924
     0.800    25.056
     0.900    28.188
     1.000    31.320
     1.100    34.452
     1.200    37.584
     1.300    40.716
     1.400    43.848
     1.500    46.980
     1.600    50.111
     1.700    53.243
     1.800    56.375
     1.900    59.507
     2.000    62.639
     2.100    65.771
     2.200    68.903
     2.300    72.035
     2.400    75.167
     2.500    78.299
     2.600    81.431
     2.700    84.563
     2.800    87.694
     2.900    90.825
     3.000    93.956
     3.100    97.087
     3.200   100.218
     3.300   103.349
     3.400   106.480
     3.500   109.610
     3.600   112.741
     3.700   115.872
     3.800   119.003
     3.900   122.134
     4.000   125.264
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    15.296
     0.800    16.677
     0.900    18.058
     1.000    19.439
     1.100    20.821
     1.200    22.202
     1.300    23.583
     1.400    24.964
     1.500    26.345
     1.600    27.726
     1.700    29.107
     1.800    30.488
     1.900    31.869
     2.000    33.250
     2.100    34.631
     2.200    36.013
     2.300    37.394
     2.400    38.775
     2.500    40.156
     2.600    41.537
     2.700    42.918
     2.800    44.299
     2.900    45.680
     3.000    47.061
     3.100    48.442
     3.200    49.824
     3.300    51.205
     3.400    52.585
     3.500    53.966
     3.600    55.346
     3.700    56.727
     3.800    58.108
     3.900    59.488
     4.000    60.869
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     4.412
     0.200     5.392
     0.300     6.715
     0.400     8.217
     0.500     9.816
     0.600    11.472
     0.700    13.162
     0.800    14.876
     0.900    16.606
     1.000    18.348
     1.100    20.098
     1.200    21.854
     1.300    23.616
     1.400    25.381
     1.500    27.150
     1.600    28.921
     1.700    30.694
     1.800    32.469
     1.900    34.246
     2.000    36.023
     2.100    37.802
     2.200    39.582
     2.300    41.363
     2.400    43.144
     2.500    44.926
     2.600    46.709
     2.700    48.492
     2.800    50.275
     2.900    52.059
     3.000    53.843
     3.100    55.628
     3.200    57.412
     3.300    59.197
     3.400    60.982
     3.500    62.768
     3.600    64.553
     3.700    66.339
     3.800    68.125
     3.900    69.911
     4.000    71.697
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    26.729
     0.800    29.158
     0.900    31.586
     1.000    34.014
     1.100    36.442
     1.200    38.871
     1.300    41.299
     1.400    43.727
     1.500    46.155
     1.600    48.584
     1.700    51.012
     1.800    53.440
     1.900    55.869
     2.000    58.297
     2.100    60.725
     2.200    63.153
     2.300    65.582
     2.400    68.010
     2.500    70.438
     2.600    72.866
     2.700    75.295
     2.800    77.723
     2.900    80.151
     3.000    82.580
     3.100    85.008
     3.200    87.436
     3.300    89.864
     3.400    92.293
     3.500    94.720
     3.600    97.148
     3.700    99.575
     3.800   102.002
     3.900   104.430
     4.000   106.857
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     7.705
     0.200     9.417
     0.300    11.728
     0.400    14.351
     0.500    17.144
     0.600    20.035
     0.700    22.988
     0.800    25.981
     0.900    29.003
     1.000    32.044
     1.100    35.100
     1.200    38.168
     1.300    41.244
     1.400    44.327
     1.500    47.416
     1.600    50.509
     1.700    53.606
     1.800    56.706
     1.900    59.809
     2.000    62.914
     2.100    66.021
     2.200    69.130
     2.300    72.240
     2.400    75.351
     2.500    78.463
     2.600    81.576
     2.700    84.690
     2.800    87.805
     2.900    90.920
     3.000    94.036
     3.100    97.153
     3.200   100.270
     3.300   103.387
     3.400   106.505
     3.500   109.623
     3.600   112.741
     3.700   115.860
     3.800   118.979
     3.900   122.098
     4.000   125.217
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.733    29.578     0.200
     1.673    28.340     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.491    27.016     0.200
     1.364    23.203     0.200
     1.617    27.604     0.200
     1.408    25.420     0.200
     1.414    24.500     0.200
     1.531    27.123     0.200
     1.554    27.344     0.200
     1.474    25.203     0.200
     1.420    24.213     0.200
     1.487    26.275     0.200
     1.376    23.512     0.200
     1.608    28.480     0.200
     1.611    27.824     0.200
     1.309    22.922     0.200
     1.728    30.094     0.200
     1.314    23.266     0.200
     1.536    26.555     0.200
     1.543    26.352     0.200
     1.292    21.752     0.200
     1.325    22.855     0.200
     1.437    24.375     0.200
     1.495    25.586     0.200
     1.441    26.359     0.200
     1.492    26.844     0.200
     1.141    19.703     0.200
     1.386    24.344     0.200
     1.185    20.605     0.200
     1.448    24.551     0.200
     1.224    20.879     0.200
     1.207    21.488     0.200
     1.318    22.945     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.491    47.734     0.200
     1.733    53.312     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.408    45.320     0.200
     1.414    44.617     0.200
     1.531    48.812     0.200
     1.536    47.133     0.200
     1.543    47.582     0.200
     1.292    41.691     0.200
     1.673    49.520     0.200
     1.325    41.164     0.200
     1.492    47.016     0.200
     1.448    45.740     0.200
     1.483    47.273     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.408    45.320     0.200
     1.414    44.617     0.200
     1.531    48.812     0.200
     1.536    47.133     0.200
     1.543    47.582     0.200
     1.292    41.691     0.200
     1.673    49.520     0.200
     1.325    41.164     0.200
     1.492    47.016     0.200
     1.448    45.740     0.200
     1.483    47.273     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
