#!/bin/bash
gmt begin hubbard6.23_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance hubbard6.23'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6  0.000
  0.6 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    18.350
     0.900    19.731
     1.000    21.112
     1.100    22.493
     1.200    23.874
     1.300    25.256
     1.400    26.637
     1.500    28.018
     1.600    29.399
     1.700    30.780
     1.800    32.161
     1.900    33.542
     2.000    34.923
     2.100    36.304
     2.200    37.685
     2.300    39.066
     2.400    40.447
     2.500    41.829
     2.600    43.210
     2.700    44.591
     2.800    45.972
     2.900    47.353
     3.000    48.734
     3.100    50.115
     3.200    51.496
     3.300    52.877
     3.400    54.258
     3.500    55.639
     3.600    57.020
     3.700    58.401
     3.800    59.781
     3.900    61.162
     4.000    62.543
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    55.020 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.274
     0.200     3.848
     0.300     5.556
     0.400     7.304
     0.500     9.070
     0.600    10.844
     0.700    12.624
     0.800    14.406
     0.900    16.191
     1.000    17.977
     1.100    19.764
     1.200    21.552
     1.300    23.341
     1.400    25.130
     1.500    26.919
     1.600    28.709
     1.700    30.499
     1.800    32.289
     1.900    34.080
     2.000    35.870
     2.100    37.661
     2.200    39.452
     2.300    41.243
     2.400    43.033
     2.500    44.824
     2.600    46.615
     2.700    48.406
     2.800    50.197
     2.900    51.988
     3.000    53.779
     3.100    55.570
     3.200    57.361
     3.300    59.152
     3.400    60.943
     3.500    62.734
     3.600    64.525
     3.700    66.316
     3.800    68.106
     3.900    69.897
     4.000    71.688
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    63.525 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    32.050
     0.900    34.478
     1.000    36.906
     1.100    39.334
     1.200    41.763
     1.300    44.191
     1.400    46.619
     1.500    49.048
     1.600    51.476
     1.700    53.904
     1.800    56.332
     1.900    58.761
     2.000    61.189
     2.100    63.617
     2.200    66.045
     2.300    68.474
     2.400    70.902
     2.500    73.330
     2.600    75.758
     2.700    78.187
     2.800    80.615
     2.900    83.043
     3.000    85.471
     3.100    87.900
     3.200    90.328
     3.300    92.756
     3.400    95.185
     3.500    97.613
     3.600   100.041
     3.700   102.469
     3.800   104.896
     3.900   107.324
     4.000   109.751
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    98.041 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.972
     0.200     6.721
     0.300     9.704
     0.400    12.757
     0.500    15.840
     0.600    18.939
     0.700    22.047
     0.800    25.160
     0.900    28.277
     1.000    31.396
     1.100    34.517
     1.200    37.640
     1.300    40.764
     1.400    43.889
     1.500    47.014
     1.600    50.140
     1.700    53.266
     1.800    56.393
     1.900    59.520
     2.000    62.647
     2.100    65.774
     2.200    68.902
     2.300    72.029
     2.400    75.157
     2.500    78.285
     2.600    81.413
     2.700    84.541
     2.800    87.669
     2.900    90.797
     3.000    93.925
     3.100    97.052
     3.200   100.180
     3.300   103.308
     3.400   106.436
     3.500   109.563
     3.600   112.691
     3.700   115.819
     3.800   118.947
     3.900   122.074
     4.000   125.202
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   111.691 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    20.623
     1.000    22.005
     1.100    23.386
     1.200    24.767
     1.300    26.148
     1.400    27.529
     1.500    28.910
     1.600    30.291
     1.700    31.672
     1.800    33.053
     1.900    34.434
     2.000    35.816
     2.100    37.197
     2.200    38.578
     2.300    39.959
     2.400    41.340
     2.500    42.721
     2.600    44.102
     2.700    45.483
     2.800    46.864
     2.900    48.245
     3.000    49.626
     3.100    51.008
     3.200    52.389
     3.300    53.770
     3.400    55.151
     3.500    56.532
     3.600    57.913
     3.700    59.293
     3.800    60.674
     3.900    62.055
     4.000    63.435
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.793
     0.200     3.587
     0.300     5.380
     0.400     7.173
     0.500     8.966
     0.600    10.760
     0.700    12.553
     0.800    14.346
     0.900    16.140
     1.000    17.933
     1.100    19.726
     1.200    21.520
     1.300    23.313
     1.400    25.106
     1.500    26.899
     1.600    28.693
     1.700    30.486
     1.800    32.279
     1.900    34.073
     2.000    35.866
     2.100    37.659
     2.200    39.453
     2.300    41.246
     2.400    43.039
     2.500    44.832
     2.600    46.626
     2.700    48.419
     2.800    50.212
     2.900    52.005
     3.000    53.798
     3.100    55.590
     3.200    57.383
     3.300    59.175
     3.400    60.968
     3.500    62.761
     3.600    64.553
     3.700    66.346
     3.800    68.139
     3.900    69.931
     4.000    71.724
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    36.021
     1.000    38.449
     1.100    40.877
     1.200    43.306
     1.300    45.734
     1.400    48.162
     1.500    50.590
     1.600    53.019
     1.700    55.447
     1.800    57.875
     1.900    60.303
     2.000    62.732
     2.100    65.160
     2.200    67.588
     2.300    70.017
     2.400    72.445
     2.500    74.873
     2.600    77.301
     2.700    79.730
     2.800    82.158
     2.900    84.586
     3.000    87.014
     3.100    89.443
     3.200    91.871
     3.300    94.299
     3.400    96.727
     3.500    99.156
     3.600   101.584
     3.700   104.012
     3.800   106.440
     3.900   108.867
     4.000   111.295
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.132
     0.200     6.264
     0.300     9.396
     0.400    12.528
     0.500    15.660
     0.600    18.792
     0.700    21.924
     0.800    25.056
     0.900    28.188
     1.000    31.320
     1.100    34.452
     1.200    37.584
     1.300    40.716
     1.400    43.848
     1.500    46.980
     1.600    50.111
     1.700    53.243
     1.800    56.375
     1.900    59.507
     2.000    62.639
     2.100    65.771
     2.200    68.903
     2.300    72.035
     2.400    75.167
     2.500    78.299
     2.600    81.431
     2.700    84.563
     2.800    87.694
     2.900    90.825
     3.000    93.956
     3.100    97.087
     3.200   100.218
     3.300   103.349
     3.400   106.480
     3.500   109.610
     3.600   112.741
     3.700   115.872
     3.800   119.003
     3.900   122.134
     4.000   125.264
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    15.296
     0.800    16.677
     0.900    18.058
     1.000    19.439
     1.100    20.821
     1.200    22.202
     1.300    23.583
     1.400    24.964
     1.500    26.345
     1.600    27.726
     1.700    29.107
     1.800    30.488
     1.900    31.869
     2.000    33.250
     2.100    34.631
     2.200    36.013
     2.300    37.394
     2.400    38.775
     2.500    40.156
     2.600    41.537
     2.700    42.918
     2.800    44.299
     2.900    45.680
     3.000    47.061
     3.100    48.442
     3.200    49.824
     3.300    51.205
     3.400    52.585
     3.500    53.966
     3.600    55.346
     3.700    56.727
     3.800    58.108
     3.900    59.488
     4.000    60.869
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     4.412
     0.200     5.392
     0.300     6.715
     0.400     8.217
     0.500     9.816
     0.600    11.472
     0.700    13.162
     0.800    14.876
     0.900    16.606
     1.000    18.348
     1.100    20.098
     1.200    21.854
     1.300    23.616
     1.400    25.381
     1.500    27.150
     1.600    28.921
     1.700    30.694
     1.800    32.469
     1.900    34.246
     2.000    36.023
     2.100    37.802
     2.200    39.582
     2.300    41.363
     2.400    43.144
     2.500    44.926
     2.600    46.709
     2.700    48.492
     2.800    50.275
     2.900    52.059
     3.000    53.843
     3.100    55.628
     3.200    57.412
     3.300    59.197
     3.400    60.982
     3.500    62.768
     3.600    64.553
     3.700    66.339
     3.800    68.125
     3.900    69.911
     4.000    71.697
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    26.729
     0.800    29.158
     0.900    31.586
     1.000    34.014
     1.100    36.442
     1.200    38.871
     1.300    41.299
     1.400    43.727
     1.500    46.155
     1.600    48.584
     1.700    51.012
     1.800    53.440
     1.900    55.869
     2.000    58.297
     2.100    60.725
     2.200    63.153
     2.300    65.582
     2.400    68.010
     2.500    70.438
     2.600    72.866
     2.700    75.295
     2.800    77.723
     2.900    80.151
     3.000    82.580
     3.100    85.008
     3.200    87.436
     3.300    89.864
     3.400    92.293
     3.500    94.720
     3.600    97.148
     3.700    99.575
     3.800   102.002
     3.900   104.430
     4.000   106.857
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     7.705
     0.200     9.417
     0.300    11.728
     0.400    14.351
     0.500    17.144
     0.600    20.035
     0.700    22.988
     0.800    25.981
     0.900    29.003
     1.000    32.044
     1.100    35.100
     1.200    38.168
     1.300    41.244
     1.400    44.327
     1.500    47.416
     1.600    50.509
     1.700    53.606
     1.800    56.706
     1.900    59.809
     2.000    62.914
     2.100    66.021
     2.200    69.130
     2.300    72.240
     2.400    75.351
     2.500    78.463
     2.600    81.576
     2.700    84.690
     2.800    87.805
     2.900    90.920
     3.000    94.036
     3.100    97.153
     3.200   100.270
     3.300   103.387
     3.400   106.505
     3.500   109.623
     3.600   112.741
     3.700   115.860
     3.800   118.979
     3.900   122.098
     4.000   125.217
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.269    38.484     0.200
     3.817    59.484     0.200
     4.949    75.285     0.200
     8.003   115.385     0.200
     8.388   121.084     0.200
     8.635   125.285     0.200
     9.767   142.984     0.200
    10.799   155.785     0.200
    12.231   173.984     0.200
    13.200   188.484     0.200
    15.855   223.184     0.200
    20.382   279.885     0.200
     2.326    38.910     0.200
     3.758    58.211     0.200
     3.798    57.508     0.200
     4.847    73.008     0.200
     4.884    73.410     0.200
     5.020    75.910     0.200
     5.184    78.309     0.200
     5.246    79.309     0.200
     5.801    86.309     0.200
     7.073   103.609     0.200
     7.143   106.410     0.200
     7.938   115.309     0.200
     8.325   119.410     0.200
     8.640   123.809     0.200
     8.722   127.211     0.200
    12.224   173.309     0.200
    12.286   173.609     0.200
    17.665   243.008     0.200
     2.241    38.008     0.200
     2.518    41.377     0.200
     3.556    54.207     0.200
     3.754    56.906     0.200
     4.923    74.707     0.200
     5.100    76.207     0.200
     5.104    76.906     0.200
     5.322    80.906     0.200
     5.730    85.207     0.200
     6.205    92.707     0.200
     7.159   104.207     0.200
     8.019   116.207     0.200
     8.397   120.707     0.200
     8.608   124.906     0.200
    12.203   173.707     0.200
    12.202   173.307     0.200
    15.839   223.107     0.200
    17.632   244.207     0.200
    18.573   257.107     0.200
    19.816   273.707     0.200
    20.014   275.707     0.200
    20.352   278.207     0.200
    20.670   280.707     0.200
     2.253    37.852     0.200
     2.513    41.289     0.200
     3.545    53.949     0.200
     3.818    60.250     0.200
     3.755    56.852     0.200
     4.954    75.152     0.200
     5.092    76.152     0.200
     5.112    76.051     0.200
     5.736    85.750     0.200
     6.155    90.551     0.200
     6.155    90.652     0.200
     7.067   104.449     0.200
     7.148   103.051     0.200
     8.011   116.152     0.200
     8.391   121.051     0.200
     8.617   124.551     0.200
     8.770   127.949     0.200
     9.938   146.051     0.200
    12.191   173.152     0.200
    12.214   172.551     0.200
    15.847   222.652     0.200
    17.641   243.551     0.200
    18.570   257.051     0.200
    20.020   274.652     0.200
    20.364   276.852     0.200
    20.680   280.750     0.200
     1.835    32.047     0.200
     2.138    36.367     0.200
     2.608    42.508     0.200
     2.728    44.375     0.200
     2.999    47.828     0.200
     3.270    51.531     0.200
     3.555    55.891     0.200
     3.635    57.328     0.200
     3.643    57.070     0.200
     3.648    57.070     0.200
     3.692    59.969     0.200
     3.733    57.789     0.200
     3.945    61.672     0.200
     3.964    60.797     0.200
     4.226    64.781     0.200
     5.000    74.672     0.200
     5.061    76.469     0.200
     6.217    93.969     0.200
     7.265   104.969     0.200
     8.579   123.969     0.200
     8.841   129.969     0.200
     1.795    28.773     0.200
     1.821    30.203     0.200
     1.890    30.715     0.200
     2.502    39.336     0.200
     2.613    41.383     0.200
     2.711    42.305     0.200
     3.255    49.414     0.200
     3.553    54.676     0.200
     3.636    54.926     0.200
     3.709    58.023     0.200
     3.668    57.633     0.200
     3.895    59.543     0.200
     3.917    60.324     0.200
     3.992    61.824     0.200
     4.149    62.863     0.200
     4.240    64.883     0.200
     4.302    64.875     0.200
     4.745    70.766     0.200
     4.664    71.324     0.200
     4.888    72.043     0.200
     5.004    74.543     0.200
     5.055    74.684     0.200
     5.055    75.824     0.200
     5.036    73.523     0.200
     5.093    74.434     0.200
     5.193    77.324     0.200
     5.417    81.023     0.200
     5.462    79.766     0.200
     5.632    82.812     0.200
     5.642    82.285     0.200
     5.635    84.625     0.200
     5.789    85.766     0.200
     6.062    88.855     0.200
     6.224    92.266     0.200
     6.253    91.945     0.200
     6.440    93.504     0.200
     6.455    94.535     0.200
     6.523    94.984     0.200
     6.523    95.715     0.200
     6.554    95.863     0.200
     6.690    97.453     0.200
     6.717    98.113     0.200
     6.718    98.383     0.200
     6.719    98.152     0.200
     6.744    98.953     0.200
     6.800    98.855     0.200
     6.847   100.004     0.200
     6.867    99.586     0.200
     6.901   101.094     0.200
     6.935   101.273     0.200
     7.040   102.645     0.200
     7.190   104.633     0.200
     7.198   104.895     0.200
     7.200   103.934     0.200
     7.213   105.793     0.200
     7.230   104.023     0.200
     7.402   107.273     0.200
     8.111   114.652     0.200
     8.631   125.965     0.200
     1.786    28.516     0.200
     1.811    30.062     0.200
     1.880    30.586     0.200
     2.493    39.195     0.200
     2.603    41.195     0.200
     2.701    41.883     0.200
     3.245    49.062     0.200
     3.543    54.176     0.200
     3.624    54.684     0.200
     3.626    54.555     0.200
     3.677    56.504     0.200
     3.886    59.062     0.200
     3.907    59.984     0.200
     3.988    61.484     0.200
     4.140    62.254     0.200
     4.232    64.254     0.200
     4.293    64.383     0.200
     4.735    70.414     0.200
     4.674    71.285     0.200
     4.879    71.543     0.200
     4.994    74.125     0.200
     5.027    73.293     0.200
     5.045    74.324     0.200
     5.045    75.766     0.200
     5.084    74.484     0.200
     5.183    77.184     0.200
     5.407    80.684     0.200
     5.453    79.266     0.200
     5.633    82.383     0.200
     5.624    83.812     0.200
     5.779    85.543     0.200
     5.645    84.785     0.200
     6.054    88.523     0.200
     6.156    89.176     0.200
     6.235    92.023     0.200
     6.214    91.496     0.200
     6.243    91.676     0.200
     6.232    91.375     0.200
     6.431    92.434     0.200
     6.445    94.773     0.200
     6.472    94.125     0.200
     6.513    94.285     0.200
     6.532    94.766     0.200
     6.514    95.883     0.200
     6.544    94.594     0.200
     6.669    96.664     0.200
     6.681    97.035     0.200
     6.708    97.434     0.200
     6.710    98.105     0.200
     6.709    98.266     0.200
     6.734    98.473     0.200
     6.791    98.793     0.200
     6.838    99.516     0.200
     6.859    99.363     0.200
     6.891   100.266     0.200
     6.926   100.895     0.200
     7.031   102.703     0.200
     7.184   106.355     0.200
     7.189   105.836     0.200
     7.222   103.664     0.200
     7.393   107.105     0.200
     7.678   110.496     0.200
     8.102   115.113     0.200
     8.482   120.355     0.200
     1.660    28.891     0.200
     1.734    29.289     0.200
     1.762    30.281     0.200
     1.829    31.422     0.200
     2.445    39.609     0.200
     2.551    41.641     0.200
     2.654    42.812     0.200
     3.197    50.125     0.200
     3.492    54.820     0.200
     3.576    56.094     0.200
     3.856    60.492     0.200
     4.725    71.891     0.200
     1.823    31.818     0.200
     2.404    40.188     0.200
     2.382    38.718     0.200
     3.049    47.488     0.200
     3.327    52.608     0.200
     3.417    52.788     0.200
     3.416    52.208     0.200
     3.425    53.878     0.200
     3.507    54.648     0.200
     3.867    60.538     0.200
     4.108    62.608     0.200
     4.478    68.108     0.200
     4.519    68.728     0.200
     4.900    72.778     0.200
     5.569    83.678     0.200
     1.528    26.066     0.200
     1.943    31.965     0.200
     2.033    34.164     0.200
     2.244    37.164     0.200
     2.244    36.965     0.200
     2.609    42.164     0.200
     2.775    44.164     0.200
     2.819    45.664     0.200
     3.096    48.504     0.200
     3.420    52.438     0.200
     3.483    56.164     0.200
     3.702    56.566     0.200
     3.771    58.367     0.200
     3.856    59.164     0.200
     4.080    62.164     0.200
     4.178    63.316     0.200
     4.671    70.266     0.200
     4.891    73.617     0.200
     5.193    76.676     0.200
     1.635    27.480     0.200
     1.727    29.578     0.200
     2.346    38.879     0.200
     2.386    39.699     0.200
     2.452    40.480     0.200
     2.554    41.781     0.200
     2.826    45.480     0.200
     3.118    49.129     0.200
     3.391    53.879     0.200
     3.474    55.480     0.200
     3.563    55.199     0.200
     3.757    59.480     0.200
     3.791    58.629     0.200
     3.810    57.801     0.200
     3.938    61.648     0.200
     4.165    64.379     0.200
     4.392    67.031     0.200
     4.583    68.758     0.200
     4.842    72.191     0.200
     4.827    73.480     0.200
     4.879    72.410     0.200
     5.184    77.551     0.200
     5.750    84.031     0.200
     5.750    84.051     0.200
     6.101    88.469     0.200
     7.635   111.730     0.200
     8.686   123.711     0.200
     1.959    33.539     0.200
     1.952    32.234     0.200
     2.632    43.141     0.200
     2.769    44.836     0.200
     2.842    46.438     0.200
     3.389    53.641     0.200
     3.511    57.461     0.200
     3.705    57.938     0.200
     3.747    59.234     0.200
     3.773    58.539     0.200
     3.781    58.141     0.200
     4.074    63.234     0.200
     4.092    63.641     0.200
     4.421    66.641     0.200
     4.470    69.938     0.200
     4.690    70.641     0.200
     4.845    73.539     0.200
     5.167    77.141     0.200
     5.216    77.438     0.200
     5.593    83.336     0.200
     5.933    90.539     0.200
     5.951    89.438     0.200
     6.177    91.734     0.200
     6.382    95.039     0.200
     2.295    38.180     0.200
     2.403    40.047     0.200
     2.770    44.547     0.200
     3.040    47.797     0.200
     3.409    54.031     0.200
     3.673    57.648     0.200
     3.905    60.180     0.200
     4.821    73.938     0.200
     4.965    75.047     0.200
     5.183    79.148     0.200
     5.249    79.203     0.200
     7.110   103.852     0.200
     8.252   119.352     0.200
     1.583    26.391     0.200
     1.639    28.682     0.200
     1.691    28.771     0.200
     2.331    38.320     0.200
     2.400    39.291     0.200
     2.372    39.221     0.200
     2.439    39.570     0.200
     2.538    41.301     0.200
     2.806    44.570     0.200
     3.035    47.480     0.200
     3.348    51.771     0.200
     3.440    53.471     0.200
     3.451    53.570     0.200
     3.531    53.172     0.200
     3.704    56.971     0.200
     3.882    58.371     0.200
     4.139    62.570     0.200
     4.502    68.271     0.200
     5.214    77.820     0.200
     5.589    83.371     0.200
     1.594    27.395     0.200
     1.650    28.848     0.200
     2.363    38.805     0.200
     2.342    38.785     0.200
     2.411    39.117     0.200
     2.450    39.387     0.200
     2.549    41.375     0.200
     2.817    44.875     0.200
     3.359    52.086     0.200
     3.378    53.688     0.200
     3.451    53.688     0.200
     3.462    53.984     0.200
     3.543    53.887     0.200
     3.715    57.785     0.200
     3.776    58.285     0.200
     3.872    58.664     0.200
     4.107    62.188     0.200
     4.150    62.188     0.200
     4.378    65.387     0.200
     4.514    67.688     0.200
     4.553    67.867     0.200
     4.715    70.188     0.200
     4.813    71.285     0.200
     4.939    72.484     0.200
     5.202    76.637     0.200
     5.229    78.586     0.200
     5.606    84.086     0.200
     5.867    88.086     0.200
     5.921    88.086     0.200
     6.346    92.887     0.200
     8.525   123.285     0.200
    12.159   172.586     0.200
     1.800    30.902     0.200
     2.305    38.604     0.200
     2.426    39.902     0.200
     2.516    41.604     0.200
     3.175    49.902     0.200
     3.283    51.502     0.200
     3.461    54.604     0.200
     3.483    56.203     0.200
     3.548    55.604     0.200
     3.553    55.402     0.200
     3.613    57.604     0.200
     3.576    55.104     0.200
     3.820    60.604     0.200
     3.868    59.002     0.200
     3.930    62.002     0.200
     3.767    57.703     0.200
     4.209    64.703     0.200
     4.653    70.803     0.200
     4.966    76.203     0.200
     5.108    77.932     0.200
     5.788    85.102     0.200
     6.139    93.373     0.200
     7.182   104.303     0.200
     8.028   116.604     0.200
     7.877   113.422     0.200
     8.399   121.703     0.200
     8.576   123.553     0.200
    12.115   171.951     0.200
     1.812    31.184     0.200
     2.435    40.184     0.200
     2.530    41.484     0.200
     3.185    49.785     0.200
     3.834    60.484     0.200
     3.751    58.887     0.200
     4.978    76.684     0.200
     5.097    76.684     0.200
     5.339    81.387     0.200
     5.804    87.137     0.200
     6.155    92.594     0.200
     7.185   103.785     0.200
     7.215   104.785     0.200
     8.412   121.684     0.200
     8.589   124.559     0.200
    12.114   172.035     0.200
     2.304    39.715     0.200
     2.304    38.135     0.200
     2.668    43.965     0.200
     2.814    45.455     0.200
     3.331    53.256     0.200
     3.405    53.256     0.200
     3.585    54.875     0.200
     4.115    65.064     0.200
     5.005    75.965     0.200
     5.005    76.945     0.200
     1.828    31.719     0.200
     2.276    39.078     0.200
     2.456    40.426     0.200
     2.541    41.727     0.200
     2.552    41.695     0.200
     2.664    43.246     0.200
     2.721    44.047     0.200
     3.205    50.688     0.200
     3.312    52.656     0.200
     3.845    61.258     0.200
     3.929    62.277     0.200
     3.750    57.059     0.200
     4.994    75.547     0.200
     5.136    77.957     0.200
     5.202    77.766     0.200
     5.079    76.809     0.200
     5.356    81.758     0.200
     5.775    87.406     0.200
     5.804    85.559     0.200
     6.157    91.105     0.200
     7.211   104.957     0.200
     7.241   104.738     0.200
     7.656   112.035     0.200
     8.426   121.105     0.200
     8.568   124.656     0.200
     8.754   126.828     0.200
     8.780   128.816     0.200
    12.082   172.418     0.200
    12.087   172.602     0.200
     2.526    41.148     0.200
     2.224    37.008     0.200
     2.307    37.648     0.200
     2.378    39.414     0.200
     2.433    40.094     0.200
     2.518    40.883     0.200
     3.109    49.008     0.200
     3.300    52.164     0.200
     3.683    57.938     0.200
     3.683    57.844     0.200
     3.998    62.242     0.200
     4.051    62.562     0.200
     4.745    71.789     0.200
     5.297    80.172     0.200
     5.297    80.297     0.200
     5.642    85.867     0.200
     2.382    40.059     0.200
     3.073    46.840     0.200
     3.711    58.137     0.200
     3.874    60.500     0.200
     3.874    60.637     0.200
     3.869    59.398     0.200
     4.346    67.520     0.200
     4.858    73.777     0.200
     5.001    76.840     0.200
     5.213    78.469     0.200
     5.213    78.238     0.200
     5.645    85.469     0.200
     5.689    82.840     0.200
     6.039    89.367     0.200
     8.290   119.539     0.200
     8.546   123.148     0.200
     8.546   123.438     0.200
     8.546   123.840     0.200
     8.528   125.238     0.200
     8.656   126.738     0.200
    12.175   171.840     0.200
    12.175   172.840     0.200
    12.181   173.133     0.200
     2.338    39.148     0.200
     2.440    40.938     0.200
     3.007    48.797     0.200
     3.850    60.949     0.200
     3.850    61.219     0.200
     1.734    29.102     0.200
     2.292    38.422     0.200
     2.551    41.438     0.200
     2.542    40.516     0.200
     2.780    43.883     0.200
     2.966    49.312     0.200
     3.174    49.891     0.200
     3.202    49.750     0.200
     3.315    51.742     0.200
     3.513    54.836     0.200
     3.519    56.234     0.200
     3.567    55.094     0.200
     3.579    55.172     0.200
     3.581    55.336     0.200
     3.593    54.961     0.200
     3.688    56.656     0.200
     3.730    55.641     0.200
     3.730    56.750     0.200
     3.897    59.352     0.200
     3.960    61.766     0.200
     3.960    61.867     0.200
     4.087    62.555     0.200
     4.180    63.984     0.200
     4.242    65.094     0.200
     4.252    63.891     0.200
     4.487    69.406     0.200
     4.642    70.867     0.200
     4.686    70.344     0.200
     4.686    70.727     0.200
     4.945    74.453     0.200
     4.997    75.445     0.200
     5.045    74.562     0.200
     5.079    75.922     0.200
     5.079    75.812     0.200
     5.202    77.586     0.200
     5.411    79.641     0.200
     5.422    82.625     0.200
     5.580    83.836     0.200
     5.737    86.242     0.200
     5.790    86.445     0.200
     5.790    86.586     0.200
     5.825    85.094     0.200
     5.825    84.945     0.200
     5.802    85.117     0.200
     5.999    89.836     0.200
     6.161    91.391     0.200
     6.177    92.945     0.200
     6.177    92.367     0.200
     6.235    91.406     0.200
     6.255    92.633     0.200
     6.275    93.336     0.200
     6.330    91.164     0.200
     6.461    96.188     0.200
     6.666    97.344     0.200
     6.668    97.688     0.200
     6.748    98.383     0.200
     6.798   100.484     0.200
     6.827   100.320     0.200
     6.851   101.172     0.200
     6.888   100.922     0.200
     6.993   103.016     0.200
     7.120   104.891     0.200
     7.153   105.820     0.200
     7.168   105.961     0.200
     7.226   104.523     0.200
     7.642   111.906     0.200
     7.806   113.984     0.200
     8.037   116.422     0.200
     8.098   117.523     0.200
     8.119   117.336     0.200
     8.189   118.641     0.200
     8.431   121.094     0.200
     8.411   123.492     0.200
     8.591   124.570     0.200
     8.600   124.742     0.200
     8.772   126.547     0.200
     9.333   134.625     0.200
    10.118   147.016     0.200
    12.102   172.047     0.200
    12.102   172.406     0.200
    12.106   171.688     0.200
    14.042   198.070     0.200
    14.712   207.266     0.200
    15.229   216.312     0.200
    15.801   222.445     0.200
    15.987   222.523     0.200
    18.311   254.672     0.200
    18.727   260.516     0.200
    19.286   267.156     0.200
    19.558   269.055     0.200
    19.980   273.281     0.200
    20.036   275.922     0.200
    20.214   275.781     0.200
    20.198   275.820     0.200
    20.206   276.406     0.200
    20.632   280.047     0.200
     1.731    28.453     0.200
     2.307    38.148     0.200
     2.307    37.828     0.200
     2.548    41.430     0.200
     2.530    40.711     0.200
     2.783    44.102     0.200
     3.182    49.930     0.200
     3.193    49.719     0.200
     3.308    51.820     0.200
     3.516    55.023     0.200
     3.557    54.312     0.200
     3.572    54.711     0.200
     3.573    55.672     0.200
     3.580    54.430     0.200
     3.681    56.211     0.200
     3.726    56.578     0.200
     3.889    59.086     0.200
     3.973    61.727     0.200
     4.088    62.312     0.200
     4.185    63.523     0.200
     4.238    64.797     0.200
     4.241    63.500     0.200
     4.489    68.883     0.200
     4.681    70.781     0.200
     4.940    74.172     0.200
     4.991    75.180     0.200
     5.034    74.141     0.200
     5.087    75.852     0.200
     5.087    75.680     0.200
     5.087    75.453     0.200
     5.401    79.617     0.200
     5.414    81.992     0.200
     5.521    82.039     0.200
     5.574    82.477     0.200
     5.790    85.828     0.200
     5.791    84.680     0.200
     5.830    85.133     0.200
     5.830    85.031     0.200
     6.002    88.172     0.200
     6.160    90.930     0.200
     6.181    90.922     0.200
     6.248    92.086     0.200
     6.322    92.492     0.200
     6.354    92.953     0.200
     6.386    94.219     0.200
     6.460    94.820     0.200
     6.617    97.289     0.200
     6.656    96.586     0.200
     6.658    97.922     0.200
     6.739    97.703     0.200
     6.788    99.352     0.200
     6.841   100.000     0.200
     6.878   100.336     0.200
     6.982   103.156     0.200
     7.109   105.117     0.200
     7.141   105.469     0.200
     7.195   104.828     0.200
     7.098   103.812     0.200
     7.212   104.492     0.200
     7.631   111.461     0.200
     7.693   112.477     0.200
     7.623   112.477     0.200
     7.793   113.711     0.200
     8.029   115.859     0.200
     8.085   116.836     0.200
     8.107   117.477     0.200
     8.087   117.727     0.200
     8.426   121.180     0.200
     8.422   122.953     0.200
     8.597   124.852     0.200
     8.616   124.602     0.200
     8.616   123.633     0.200
     8.616   124.797     0.200
     8.773   126.477     0.200
     8.800   128.477     0.200
     8.654   125.531     0.200
    10.117   146.828     0.200
    10.117   147.227     0.200
    12.117   170.492     0.200
    12.117   171.531     0.200
    12.122   170.922     0.200
    12.348   179.109     0.200
    12.853   185.680     0.200
    14.040   197.688     0.200
    14.712   207.078     0.200
    15.228   216.258     0.200
    15.809   222.359     0.200
    15.809   222.703     0.200
    15.973   222.367     0.200
    17.510   243.930     0.200
    19.027   264.383     0.200
    19.984   273.492     0.200
    20.033   275.750     0.200
    20.198   275.078     0.200
    20.218   275.703     0.200
    20.644   280.281     0.200
     1.729    28.742     0.200
     1.827    30.922     0.200
     2.294    38.211     0.200
     2.540    40.938     0.200
     2.546    41.766     0.200
     2.785    44.383     0.200
     3.169    50.438     0.200
     3.198    50.023     0.200
     3.310    51.875     0.200
     3.563    54.367     0.200
     3.575    55.328     0.200
     3.735    58.375     0.200
     3.893    59.688     0.200
     3.956    61.984     0.200
     4.082    62.625     0.200
     4.238    65.047     0.200
     4.249    63.742     0.200
     4.482    68.711     0.200
     4.682    71.055     0.200
     4.941    74.766     0.200
     4.993    76.531     0.200
     5.082    76.336     0.200
     5.082    75.875     0.200
     5.082    76.633     0.200
     5.355    81.336     0.200
     5.407    80.461     0.200
     5.785    86.492     0.200
     5.799    85.492     0.200
     5.820    85.875     0.200
     5.820    86.438     0.200
     6.156    91.656     0.200
     6.251    92.773     0.200
     6.456    95.766     0.200
     6.662    98.203     0.200
     6.745    98.586     0.200
     6.990   102.867     0.200
     7.224   104.672     0.200
     7.679   112.852     0.200
     8.427   121.766     0.200
     8.766   126.234     0.200
    12.103   172.602     0.200
    12.107   172.133     0.200
     2.277    38.660     0.200
     2.542    42.160     0.200
     2.664    43.410     0.200
     2.789    44.980     0.200
     3.150    50.172     0.200
     3.205    50.480     0.200
     3.312    52.262     0.200
     3.494    55.250     0.200
     3.571    55.230     0.200
     3.577    56.121     0.200
     3.583    56.621     0.200
     3.687    57.359     0.200
     3.748    58.750     0.200
     3.932    61.891     0.200
     3.932    62.320     0.200
     4.071    62.961     0.200
     4.159    63.852     0.200
     4.236    65.551     0.200
     4.259    64.691     0.200
     4.470    70.191     0.200
     4.640    71.379     0.200
     4.681    71.191     0.200
     4.941    75.242     0.200
     4.994    75.859     0.200
     5.079    77.996     0.200
     5.079    77.762     0.200
     5.202    78.219     0.200
     5.414    81.398     0.200
     5.552    83.320     0.200
     5.674    85.129     0.200
     5.731    86.762     0.200
     5.776    87.129     0.200
     5.806    85.582     0.200
     5.806    85.070     0.200
     5.809    85.949     0.200
     6.026    90.199     0.200
     6.150    91.832     0.200
     6.221    91.660     0.200
     6.254    93.461     0.200
     6.330    94.891     0.200
     6.450    95.531     0.200
     6.630    98.270     0.200
     6.669    98.531     0.200
     6.671    98.750     0.200
     6.751    99.340     0.200
     6.857   101.020     0.200
     6.893   102.371     0.200
     7.122   104.512     0.200
     7.240   105.109     0.200
     7.658   112.840     0.200
     8.111   116.922     0.200
     8.201   119.648     0.200
     8.374   122.109     0.200
     8.404   125.148     0.200
     8.426   121.922     0.200
     8.473   122.992     0.200
     8.571   125.270     0.200
     8.571   124.242     0.200
     8.571   125.121     0.200
     8.570   124.570     0.200
     8.756   126.621     0.200
    10.133   148.020     0.200
    12.084   172.711     0.200
    12.088   172.367     0.200
    18.316   254.031     0.200
     1.822    31.500     0.200
     2.295    38.852     0.200
     2.537    41.930     0.200
     2.540    42.039     0.200
     2.653    43.281     0.200
     2.791    45.352     0.200
     3.194    49.758     0.200
     3.161    50.008     0.200
     3.305    52.211     0.200
     3.742    58.750     0.200
     3.949    62.070     0.200
     3.949    62.219     0.200
     4.074    62.852     0.200
     4.167    64.180     0.200
     4.232    65.570     0.200
     4.676    71.250     0.200
     4.936    75.102     0.200
     6.150    91.469     0.200
     6.450    95.828     0.200
     7.671   112.961     0.200
     1.875    32.871     0.200
     1.913    33.102     0.200
     2.099    36.252     0.200
     2.296    38.711     0.200
     2.600    42.852     0.200
     2.611    42.711     0.200
     3.114    48.961     0.200
     3.189    50.572     0.200
     3.349    53.461     0.200
     3.457    54.621     0.200
     3.732    58.652     0.200
     3.732    58.992     0.200
     3.884    60.701     0.200
     3.955    62.230     0.200
     4.093    63.582     0.200
     4.514    70.891     0.200
     4.543    69.230     0.200
     4.867    74.652     0.200
     5.093    77.342     0.200
     5.611    84.842     0.200
     5.981    89.652     0.200
    10.980   157.971     0.200
    11.591   166.602     0.200
     1.725    28.844     0.200
     2.155    36.328     0.200
     2.298    38.422     0.200
     2.298    38.273     0.200
     2.542    41.359     0.200
     2.789    44.102     0.200
     2.696    43.242     0.200
     2.715    43.523     0.200
     2.923    46.398     0.200
     2.950    47.938     0.200
     3.306    51.852     0.200
     3.954    61.617     0.200
     4.077    61.711     0.200
     4.171    64.461     0.200
     4.430    67.531     0.200
     4.489    68.422     0.200
     4.741    71.500     0.200
     5.087    76.133     0.200
     5.087    75.820     0.200
     4.988    76.211     0.200
     5.037    74.312     0.200
     5.253    77.961     0.200
     5.193    77.523     0.200
     5.402    79.508     0.200
     5.570    83.508     0.200
     5.724    85.234     0.200
     5.795    85.273     0.200
     5.780    87.188     0.200
     6.152    90.430     0.200
     6.186    91.141     0.200
     6.247    91.141     0.200
     6.452    95.164     0.200
     6.725    98.281     0.200
     6.986   102.148     0.200
     7.220   105.094     0.200
     7.809   112.258     0.200
     8.100   117.617     0.200
     8.422   121.148     0.200
     8.597   124.609     0.200
     1.720    29.820     0.200
     1.808    31.594     0.200
     1.896    32.484     0.200
     1.915    33.141     0.200
     2.211    36.094     0.200
     2.353    38.766     0.200
     2.113    35.641     0.200
     2.238    37.438     0.200
     3.146    50.086     0.200
     3.433    54.156     0.200
     1.646    28.031     0.200
     1.719    29.262     0.200
     1.754    30.293     0.200
     1.766    30.414     0.200
     1.787    30.141     0.200
     1.850    32.352     0.200
     1.850    32.504     0.200
     1.968    33.223     0.200
     1.989    33.434     0.200
     2.052    34.762     0.200
     2.086    34.891     0.200
     2.112    36.422     0.200
     2.134    35.371     0.200
     2.400    40.582     0.200
     2.448    39.621     0.200
     2.498    40.281     0.200
     2.517    40.992     0.200
     2.517    41.113     0.200
     2.533    40.773     0.200
     2.993    46.902     0.200
     3.124    48.691     0.200
     3.316    51.973     0.200
     4.008    61.363     0.200
     4.008    62.254     0.200
     4.067    62.113     0.200
     4.111    62.664     0.200
     4.450    68.422     0.200
     2.242    37.959     0.200
     2.356    40.049     0.200
     2.625    42.369     0.200
     3.217    51.919     0.200
     3.900    61.549     0.200
     3.900    61.219     0.200
     4.586    69.979     0.200
     4.676    69.359     0.200
     5.107    76.969     0.200
     1.590    27.058     0.200
     1.629    28.518     0.200
     1.823    31.388     0.200
     2.043    33.928     0.200
     2.020    34.947     0.200
     2.054    34.878     0.200
     2.153    35.907     0.200
     2.170    35.798     0.200
     2.317    37.808     0.200
     2.312    38.438     0.200
     2.419    38.747     0.200
     2.398    39.968     0.200
     2.525    40.718     0.200
     2.580    41.848     0.200
     2.795    44.577     0.200
     3.066    48.397     0.200
     3.171    50.067     0.200
     3.349    52.947     0.200
     3.893    60.737     0.200
     3.950    60.947     0.200
     3.950    59.938     0.200
     4.057    61.957     0.200
     4.098    62.987     0.200
     4.542    68.607     0.200
     4.661    71.207     0.200
     4.854    74.277     0.200
     5.061    75.848     0.200
     5.219    78.657     0.200
     6.018    87.928     0.200
     7.119   102.388     0.200
     1.777    30.967     0.200
     1.849    31.627     0.200
     2.075    35.928     0.200
     2.109    35.447     0.200
     2.196    36.787     0.200
     2.263    38.326     0.200
     2.318    39.156     0.200
     2.343    38.697     0.200
     2.373    39.746     0.200
     2.902    46.467     0.200
     2.902    45.246     0.200
     3.075    48.496     0.200
     3.090    48.586     0.200
     3.196    50.416     0.200
     3.196    50.107     0.200
     3.283    51.406     0.200
     3.373    53.066     0.200
     3.398    54.227     0.200
     3.495    55.826     0.200
     3.495    55.107     0.200
     3.571    55.348     0.200
     3.845    59.236     0.200
     3.892    60.777     0.200
     3.967    61.336     0.200
     4.070    63.297     0.200
     4.070    61.977     0.200
     4.121    63.217     0.200
     4.331    67.287     0.200
     4.523    68.816     0.200
     4.565    69.678     0.200
     4.664    71.297     0.200
     4.878    75.316     0.200
     5.194    78.018     0.200
     5.194    77.896     0.200
     5.458    81.836     0.200
     5.615    86.137     0.200
     5.712    87.297     0.200
     6.000    89.367     0.200
     6.336    94.268     0.200
     6.886   103.018     0.200
     7.144   103.316     0.200
     7.590   111.496     0.200
     8.482   124.316     0.200
     8.514   124.027     0.200
     8.560   123.646     0.200
     8.560   123.406     0.200
    11.210   160.336     0.200
    12.169   171.787     0.200
    12.174   172.643     0.200
    12.174   172.537     0.200
     2.036    35.184     0.200
     2.062    36.654     0.200
     2.084    36.254     0.200
     2.182    37.104     0.200
     2.224    38.914     0.200
     2.258    38.754     0.200
     2.303    38.734     0.200
     2.337    39.334     0.200
     2.361    39.244     0.200
     2.388    40.225     0.200
     2.534    42.443     0.200
     2.585    43.344     0.200
     2.741    44.805     0.200
     2.749    44.344     0.200
     2.778    45.174     0.200
     3.133    50.684     0.200
     3.129    51.123     0.200
     3.129    52.064     0.200
     3.541    56.693     0.200
     3.653    57.984     0.200
     3.878    61.094     0.200
     3.878    61.494     0.200
     3.967    62.504     0.200
     4.155    64.084     0.200
     4.155    65.453     0.200
     4.287    66.834     0.200
     4.681    71.645     0.200
     4.997    76.574     0.200
     5.013    75.984     0.200
     2.043    35.471     0.200
     2.044    35.230     0.200
     2.145    36.480     0.200
     2.172    37.141     0.200
     2.318    38.980     0.200
     2.291    39.271     0.200
     2.398    41.281     0.200
     2.391    40.320     0.200
     2.525    42.330     0.200
     2.576    42.590     0.200
     2.933    47.330     0.200
     3.048    49.211     0.200
     3.048    48.830     0.200
     3.343    53.660     0.200
     3.369    52.932     0.200
     1.869    32.262     0.200
     2.335    39.281     0.200
     4.008    62.301     0.200
     1.631    28.469     0.200
     1.691    29.188     0.200
     1.724    29.758     0.200
     1.826    31.500     0.200
     1.849    31.695     0.200
     2.057    34.406     0.200
     2.085    35.078     0.200
     2.156    36.219     0.200
     2.172    36.445     0.200
     2.319    38.078     0.200
     2.410    39.680     0.200
     2.397    39.820     0.200
     2.397    40.039     0.200
     2.583    41.570     0.200
     2.820    45.969     0.200
     2.922    45.969     0.200
     2.922    47.094     0.200
     3.069    48.266     0.200
     3.069    48.758     0.200
     3.073    47.680     0.200
     3.067    47.695     0.200
     3.174    50.266     0.200
     3.174    50.031     0.200
     3.352    52.258     0.200
     3.387    53.516     0.200
     3.302    51.000     0.200
     3.434    54.125     0.200
     3.444    55.125     0.200
     3.717    57.805     0.200
     3.759    58.570     0.200
     3.895    61.125     0.200
     3.895    60.734     0.200
     4.026    62.094     0.200
     4.060    62.109     0.200
     4.101    62.258     0.200
     4.323    65.438     0.200
     4.361    66.266     0.200
     4.501    67.055     0.200
     4.544    68.797     0.200
     4.664    69.586     0.200
     4.804    72.445     0.200
     5.063    75.516     0.200
     5.701    84.141     0.200
     5.834    86.961     0.200
     5.893    87.359     0.200
     6.053    89.516     0.200
     6.321    93.109     0.200
     6.593    97.930     0.200
     6.614    97.836     0.200
     7.061   103.391     0.200
     7.120   103.227     0.200
     7.593   111.469     0.200
     8.291   119.547     0.200
     8.472   122.086     0.200
     1.851    31.912     0.200
     1.930    32.924     0.200
     1.933    33.262     0.200
     1.953    33.123     0.200
     1.950    33.422     0.200
     2.149    36.582     0.200
     2.184    37.592     0.200
     2.184    37.322     0.200
     2.177    36.453     0.200
     2.172    36.973     0.200
     2.271    38.162     0.200
     2.280    38.422     0.200
     2.330    39.023     0.200
     2.330    38.846     0.200
     2.422    40.242     0.200
     2.508    41.453     0.200
     2.535    41.963     0.200
     2.557    42.902     0.200
     2.557    42.447     0.200
     2.630    44.113     0.200
     2.677    43.412     0.200
     2.700    43.832     0.200
     2.700    43.627     0.200
     2.797    45.193     0.200
     2.882    46.443     0.200
     2.946    48.072     0.200
     2.946    47.785     0.200
     3.183    51.123     0.200
     3.183    51.822     0.200
     3.173    50.062     0.200
     3.187    51.092     0.200
     3.187    50.641     0.200
     3.177    50.953     0.200
     3.291    51.812     0.200
     3.474    55.184     0.200
     3.474    54.695     0.200
     3.483    55.383     0.200
     3.483    54.877     0.200
     3.537    55.672     0.200
     3.554    56.553     0.200
     3.642    57.916     0.200
     3.843    60.693     0.200
     3.843    60.533     0.200
     3.982    62.623     0.200
     3.982    62.480     0.200
     4.080    64.143     0.200
     4.080    63.285     0.200
     4.136    64.043     0.200
     4.182    65.512     0.200
     4.223    65.172     0.200
     4.443    68.553     0.200
     4.443    68.766     0.200
     4.459    69.104     0.200
     4.618    70.893     0.200
     4.665    71.043     0.200
     4.665    70.887     0.200
     4.711    72.062     0.200
     4.711    71.898     0.200
     4.765    73.623     0.200
     4.765    72.820     0.200
     4.820    72.982     0.200
     4.820    72.691     0.200
     4.827    74.492     0.200
     4.924    75.312     0.200
     4.974    76.232     0.200
     5.159    78.248     0.200
     5.306    79.693     0.200
     5.569    84.672     0.200
     6.148    91.363     0.200
     6.231    92.592     0.200
     6.448    95.373     0.200
     6.862   101.123     0.200
     7.189   105.652     0.200
     7.355   107.443     0.200
     7.676   111.723     0.200
     7.696   112.342     0.200
     7.748   112.922     0.200
     8.006   117.662     0.200
     1.893    33.197     0.200
     2.375    40.137     0.200
     2.315    39.445     0.200
     2.463    41.826     0.200
     2.758    45.086     0.200
     4.016    63.166     0.200
     1.951    33.734     0.200
     1.965    34.754     0.200
     2.153    37.145     0.200
     2.153    37.258     0.200
     2.309    38.715     0.200
     2.437    40.994     0.200
     2.464    41.904     0.200
     2.565    42.453     0.200
     2.596    44.045     0.200
     2.724    44.674     0.200
     2.769    45.074     0.200
     2.769    44.654     0.200
     2.823    47.135     0.200
     2.919    47.254     0.200
     2.975    48.625     0.200
     2.975    48.404     0.200
     3.148    50.014     0.200
     3.222    51.184     0.200
     3.222    51.104     0.200
     3.226    51.555     0.200
     3.248    52.834     0.200
     3.303    52.234     0.200
     3.315    52.744     0.200
     3.500    54.424     0.200
     3.521    56.064     0.200
     3.521    55.635     0.200
     3.573    56.703     0.200
     3.657    58.273     0.200
     3.873    61.424     0.200
     3.921    63.564     0.200
     4.020    63.004     0.200
     4.020    63.287     0.200
     4.220    66.693     0.200
     4.220    66.494     0.200
     4.481    69.184     0.200
     4.481    69.711     0.200
     4.497    67.594     0.200
     4.490    68.965     0.200
     4.641    69.715     0.200
     4.689    72.244     0.200
     4.691    71.654     0.200
     4.742    72.523     0.200
     4.804    72.033     0.200
     5.085    76.090     0.200
     5.085    75.914     0.200
     5.085    76.744     0.200
     5.196    77.594     0.200
     5.863    86.914     0.200
     5.863    85.924     0.200
     7.190   104.184     0.200
     7.190   104.795     0.200
     7.704   112.234     0.200
     7.735   113.924     0.200
     7.771   114.264     0.200
     8.664   126.738     0.200
    12.150   172.414     0.200
     2.216    37.562     0.200
     2.308    38.871     0.200
     3.898    60.680     0.200
     5.127    76.551     0.200
     1.654    28.281     0.200
     1.663    28.973     0.200
     1.689    29.480     0.200
     1.751    29.953     0.200
     1.785    30.633     0.200
     1.738    30.262     0.200
     1.768    30.902     0.200
     1.805    31.441     0.200
     1.805    31.332     0.200
     1.873    32.070     0.200
     1.883    32.531     0.200
     1.886    32.883     0.200
     1.886    32.746     0.200
     1.896    32.004     0.200
     1.904    32.754     0.200
     2.101    35.422     0.200
     2.118    36.453     0.200
     2.118    36.047     0.200
     2.137    35.852     0.200
     2.217    37.262     0.200
     2.226    37.113     0.200
     2.226    36.844     0.200
     2.265    37.941     0.200
     2.265    38.254     0.200
     2.359    40.164     0.200
     2.359    39.352     0.200
     2.359    39.152     0.200
     2.353    40.062     0.200
     2.375    39.031     0.200
     2.471    40.801     0.200
     2.471    40.211     0.200
     2.471    40.078     0.200
     2.489    41.391     0.200
     2.489    41.062     0.200
     2.583    41.141     0.200
     2.626    42.531     0.200
     2.643    42.562     0.200
     2.643    43.363     0.200
     2.761    45.121     0.200
     2.761    45.230     0.200
     2.813    45.094     0.200
     2.882    46.082     0.200
     2.882    46.676     0.200
     2.860    45.273     0.200
     2.860    45.504     0.200
     2.978    46.941     0.200
     3.117    49.242     0.200
     3.117    49.082     0.200
     3.120    48.891     0.200
     3.120    49.266     0.200
     3.124    48.441     0.200
     3.124    48.969     0.200
     3.234    49.832     0.200
     3.234    51.004     0.200
     3.221    51.754     0.200
     3.221    51.863     0.200
     3.241    50.453     0.200
     3.345    51.914     0.200
     3.345    52.113     0.200
     3.413    53.871     0.200
     3.413    54.043     0.200
     3.415    52.863     0.200
     3.415    53.551     0.200
     3.443    54.191     0.200
     3.490    53.332     0.200
     3.503    54.133     0.200
     3.539    55.535     0.200
     3.608    55.672     0.200
     3.638    57.391     0.200
     3.638    57.762     0.200
     3.778    59.414     0.200
     3.818    58.801     0.200
     3.818    58.434     0.200
     3.801    58.254     0.200
     3.855    60.801     0.200
     3.926    61.414     0.200
     3.926    61.543     0.200
     3.957    60.039     0.200
     4.012    61.754     0.200
     4.071    62.414     0.200
     4.071    62.609     0.200
     4.114    63.602     0.200
     4.162    63.812     0.200
     4.162    63.957     0.200
     4.326    66.570     0.200
     4.326    66.086     0.200
     4.357    66.820     0.200
     4.357    67.723     0.200
     4.375    66.191     0.200
     4.375    66.375     0.200
     4.391    66.961     0.200
     4.391    66.766     0.200
     4.419    66.820     0.200
     4.387    66.371     0.200
     4.387    66.152     0.200
     4.562    69.723     0.200
     4.562    70.078     0.200
     4.605    69.613     0.200
     4.605    69.992     0.200
     4.646    71.012     0.200
     4.646    70.250     0.200
     4.674    71.754     0.200
     4.753    71.742     0.200
     4.753    72.148     0.200
     4.760    72.504     0.200
     4.760    72.281     0.200
     4.865    73.203     0.200
     4.917    74.582     0.200
     4.969    73.691     0.200
     5.094    77.434     0.200
     5.094    76.953     0.200
     5.122    76.730     0.200
     5.122    76.965     0.200
     5.158    77.441     0.200
     5.158    77.602     0.200
     5.216    78.664     0.200
     5.238    77.953     0.200
     5.256    78.754     0.200
     5.256    79.891     0.200
     5.256    79.664     0.200
     5.333    79.070     0.200
     5.320    79.012     0.200
     5.320    79.305     0.200
     5.413    81.887     0.200
     5.435    81.562     0.200
     5.435    81.930     0.200
     5.500    82.863     0.200
     5.502    82.852     0.200
     5.554    83.105     0.200
     5.657    84.863     0.200
     5.657    84.062     0.200
     5.631    84.703     0.200
     5.631    84.242     0.200
     5.667    85.914     0.200
     5.757    85.172     0.200
     5.757    84.344     0.200
     5.794    85.250     0.200
     5.797    85.918     0.200
     5.806    85.691     0.200
     5.892    88.922     0.200
     5.945    87.641     0.200
     6.044    89.730     0.200
     6.044    89.609     0.200
     6.083    89.973     0.200
     6.083    90.242     0.200
     6.172    91.551     0.200
     6.167    91.898     0.200
     6.251    91.684     0.200
     6.280    94.004     0.200
     6.382    95.172     0.200
     6.555    96.766     0.200
     6.588    98.102     0.200
     6.654    98.613     0.200
     6.654    98.188     0.200
     6.674    97.973     0.200
     6.674    98.301     0.200
     6.754    99.664     0.200
     6.754    99.969     0.200
     6.749    99.406     0.200
     6.762   100.176     0.200
     6.761    99.176     0.200
     6.797   100.043     0.200
     6.797    99.332     0.200
     6.825   100.523     0.200
     6.842   101.434     0.200
     6.842   100.055     0.200
     6.853   102.164     0.200
     6.853   100.680     0.200
     6.920   101.961     0.200
     6.920   102.113     0.200
     6.872    99.422     0.200
     6.928   101.773     0.200
     7.085   103.516     0.200
     7.082   103.680     0.200
     7.120   104.953     0.200
     7.120   104.418     0.200
     7.258   105.566     0.200
     7.289   107.570     0.200
     7.289   106.883     0.200
     7.295   106.785     0.200
     7.289   106.223     0.200
     7.289   106.371     0.200
     7.427   107.953     0.200
     7.427   108.238     0.200
     7.436   108.633     0.200
     7.472   109.066     0.200
     7.612   110.121     0.200
     7.612   110.445     0.200
     7.630   112.891     0.200
     7.630   111.117     0.200
     7.637   111.543     0.200
     7.690   111.844     0.200
     7.690   112.586     0.200
     7.754   111.133     0.200
     7.754   111.441     0.200
     7.838   115.172     0.200
     7.874   114.504     0.200
     7.874   114.148     0.200
     7.941   114.922     0.200
     7.941   116.188     0.200
     7.938   115.598     0.200
     7.958   114.961     0.200
     7.970   116.414     0.200
     7.969   114.934     0.200
     7.969   116.562     0.200
     8.050   116.973     0.200
     8.115   118.379     0.200
     8.122   117.492     0.200
     8.122   117.836     0.200
     8.190   120.711     0.200
     8.190   119.508     0.200
     8.258   120.250     0.200
     8.352   119.832     0.200
     8.352   121.004     0.200
     8.419   122.539     0.200
     8.526   124.441     0.200
     8.526   123.684     0.200
     8.526   123.977     0.200
     8.484   123.703     0.200
     8.549   122.402     0.200
     8.586   124.293     0.200
     8.586   126.172     0.200
     8.619   124.746     0.200
     8.697   126.301     0.200
     8.827   127.168     0.200
     8.855   129.273     0.200
     9.088   131.055     0.200
     9.240   133.488     0.200
     9.359   134.859     0.200
     9.550   139.070     0.200
     9.556   137.484     0.200
     9.652   140.473     0.200
    10.043   144.449     0.200
    10.676   152.531     0.200
    11.293   160.781     0.200
    11.293   160.430     0.200
    12.161   171.922     0.200
    13.154   186.320     0.200
    17.587   244.910     0.200
     2.108    36.779     0.200
     2.270    39.800     0.200
     2.760    44.300     0.200
     3.186    50.199     0.200
     3.732    59.680     0.200
     3.871    61.550     0.200
     1.587    27.250     0.200
     1.635    28.148     0.200
     1.754    30.590     0.200
     1.766    30.758     0.200
     1.804    31.219     0.200
     2.099    35.727     0.200
     2.257    37.930     0.200
     2.257    37.668     0.200
     2.336    39.090     0.200
     2.336    38.855     0.200
     2.332    38.980     0.200
     2.332    38.879     0.200
     2.466    40.809     0.200
     2.466    40.613     0.200
     2.744    44.828     0.200
     2.790    44.324     0.200
     2.863    46.020     0.200
     3.018    48.629     0.200
     3.018    48.504     0.200
     3.097    49.148     0.200
     3.320    51.910     0.200
     3.351    51.559     0.200
     3.391    54.219     0.200
     3.396    53.309     0.200
     3.631    57.160     0.200
     3.800    59.699     0.200
     3.904    60.570     0.200
     4.667    71.418     0.200
     4.667    71.211     0.200
     1.639    27.734     0.200
     1.639    28.258     0.200
     1.667    29.246     0.200
     1.741    29.656     0.200
     1.749    30.516     0.200
     1.751    30.188     0.200
     1.769    30.574     0.200
     1.769    30.824     0.200
     1.798    30.996     0.200
     2.102    35.793     0.200
     2.203    36.336     0.200
     2.252    37.895     0.200
     2.252    37.648     0.200
     2.329    38.996     0.200
     2.336    38.906     0.200
     2.336    38.207     0.200
     2.456    39.945     0.200
     2.467    40.695     0.200
     2.467    40.562     0.200
     2.740    44.617     0.200
     2.740    44.324     0.200
     2.792    44.395     0.200
     2.867    45.535     0.200
     2.874    44.617     0.200
     2.984    46.395     0.200
     3.015    48.477     0.200
     3.256    50.676     0.200
     3.345    51.477     0.200
     3.345    51.805     0.200
     3.345    51.074     0.200
     3.401    53.316     0.200
     3.625    56.688     0.200
     3.763    57.805     0.200
     3.797    59.566     0.200
     3.902    60.355     0.200
     4.149    63.266     0.200
     4.661    71.234     0.200
     4.661    71.121     0.200
     4.889    72.637     0.200
     4.889    73.250     0.200
     5.166    77.875     0.200
     1.721    29.703     0.200
     1.790    31.195     0.200
     1.802    31.523     0.200
     2.054    35.414     0.200
     2.240    37.742     0.200
     2.240    37.477     0.200
     2.285    38.602     0.200
     2.412    40.203     0.200
     2.706    44.406     0.200
     2.706    44.273     0.200
     2.738    44.078     0.200
     2.821    45.625     0.200
     2.920    46.906     0.200
     2.971    48.195     0.200
     2.971    48.078     0.200
     3.014    47.414     0.200
     3.014    47.250     0.200
     3.042    48.844     0.200
     3.319    52.195     0.200
     3.359    52.742     0.200
     3.365    52.125     0.200
     3.365    52.023     0.200
     3.753    59.062     0.200
     3.753    59.203     0.200
     3.852    60.086     0.200
     4.651    71.273     0.200
     1.694    28.953     0.200
     1.713    29.363     0.200
     1.799    30.822     0.200
     2.046    35.264     0.200
     2.108    35.453     0.200
     2.150    36.104     0.200
     2.274    37.943     0.200
     2.242    37.764     0.200
     2.281    38.492     0.200
     2.280    38.092     0.200
     2.336    38.572     0.200
     2.401    39.434     0.200
     2.403    39.684     0.200
     2.729    43.953     0.200
     2.704    44.213     0.200
     2.704    44.002     0.200
     2.929    47.354     0.200
     2.929    45.793     0.200
     2.966    48.162     0.200
     3.031    48.023     0.200
     3.034    48.293     0.200
     3.034    47.822     0.200
     3.022    46.543     0.200
     3.080    48.662     0.200
     3.178    50.123     0.200
     3.178    49.543     0.200
     3.192    51.203     0.200
     3.192    50.613     0.200
     3.330    52.402     0.200
     3.350    52.393     0.200
     3.311    51.643     0.200
     3.323    52.264     0.200
     3.372    52.143     0.200
     3.372    51.582     0.200
     3.615    57.312     0.200
     3.749    59.354     0.200
     3.796    59.123     0.200
     3.796    59.393     0.200
     3.847    59.982     0.200
     3.847    59.672     0.200
     3.985    61.482     0.200
     3.985    60.922     0.200
     4.028    62.492     0.200
     4.289    65.523     0.200
     4.306    65.922     0.200
     4.619    70.273     0.200
     4.667    70.693     0.200
     4.653    71.283     0.200
     5.470    81.793     0.200
     6.084    90.453     0.200
     1.857    32.440     0.200
     1.937    33.128     0.200
     2.190    37.853     0.200
     2.264    38.630     0.200
     2.399    41.460     0.200
     2.399    41.356     0.200
     2.426    41.480     0.200
     2.561    43.360     0.200
     2.952    47.800     0.200
     3.084    51.200     0.200
     3.302    52.021     0.200
     3.480    54.942     0.200
     3.864    61.220     0.200
     3.864    61.695     0.200
     3.982    62.150     0.200
     3.982    62.836     0.200
     1.617    27.646     0.200
     1.666    28.646     0.200
     1.666    28.457     0.200
     1.675    28.936     0.200
     1.702    29.367     0.200
     1.764    30.367     0.200
     1.762    30.686     0.200
     1.762    30.547     0.200
     1.794    30.936     0.200
     1.886    32.221     0.200
     1.896    32.186     0.200
     1.909    32.105     0.200
     1.899    32.330     0.200
     1.917    32.246     0.200
     2.130    36.156     0.200
     2.130    35.998     0.200
     2.149    35.576     0.200
     2.229    36.916     0.200
     2.239    36.627     0.200
     2.213    36.916     0.200
     2.257    37.627     0.200
     2.257    37.846     0.200
     2.353    39.076     0.200
     2.388    38.707     0.200
     2.483    40.307     0.200
     2.497    40.266     0.200
     2.497    41.686     0.200
     2.757    44.506     0.200
     2.757    44.377     0.200
     2.822    44.695     0.200
     2.822    44.803     0.200
     2.766    44.236     0.200
     2.766    45.043     0.200
     2.894    45.896     0.200
     2.894    46.248     0.200
     2.848    44.227     0.200
     2.848    44.537     0.200
     2.965    46.406     0.200
     3.038    48.807     0.200
     3.038    48.621     0.200
     3.127    50.059     0.200
     3.127    49.486     0.200
     3.213    50.842     0.200
     3.174    49.139     0.200
     3.229    49.656     0.200
     3.310    51.717     0.200
     3.333    51.336     0.200
     3.426    53.627     0.200
     3.630    56.881     0.200
     3.630    57.047     0.200
     3.790    58.166     0.200
     3.790    59.363     0.200
     3.820    59.787     0.200
     3.853    59.006     0.200
     3.853    60.467     0.200
     3.863    58.816     0.200
     3.970    60.066     0.200
     4.077    61.986     0.200
     4.077    62.164     0.200
     4.174    63.570     0.200
     4.383    67.266     0.200
     4.677    71.807     0.200
     4.665    70.939     0.200
     4.665    71.217     0.200
     4.761    72.756     0.200
     5.246    79.371     0.200
     5.287    80.537     0.200
     5.287    80.727     0.200
     5.321    80.146     0.200
     5.321    80.311     0.200
     5.321    80.816     0.200
     5.441    81.596     0.200
     5.559    83.207     0.200
     5.559    83.605     0.200
     6.138    91.396     0.200
     6.138    91.172     0.200
     6.172    91.236     0.200
     7.008   102.547     0.200
     1.817    32.152     0.200
     1.839    31.863     0.200
     1.921    33.262     0.200
     1.920    33.219     0.200
     1.924    33.402     0.200
     1.942    33.805     0.200
     2.181    37.059     0.200
     2.173    37.188     0.200
     2.268    38.883     0.200
     2.269    37.922     0.200
     2.334    39.285     0.200
     2.391    40.703     0.200
     2.391    40.137     0.200
     2.391    41.395     0.200
     2.413    39.695     0.200
     2.524    41.875     0.200
     2.545    42.785     0.200
     2.545    42.441     0.200
     2.545    43.363     0.200
     2.720    44.355     0.200
     2.808    45.312     0.200
     2.808    45.184     0.200
     2.787    45.965     0.200
     2.787    46.453     0.200
     2.869    46.395     0.200
     2.869    47.043     0.200
     2.939    47.113     0.200
     2.934    47.438     0.200
     2.937    48.133     0.200
     3.031    49.562     0.200
     3.076    50.242     0.200
     3.076    50.605     0.200
     3.132    50.223     0.200
     3.132    50.031     0.200
     3.188    51.293     0.200
     3.165    50.195     0.200
     3.165    49.320     0.200
     3.171    51.074     0.200
     3.175    51.164     0.200
     3.175    51.293     0.200
     3.227    51.832     0.200
     3.227    52.172     0.200
     3.227    52.484     0.200
     3.306    52.473     0.200
     3.315    51.434     0.200
     3.315    51.895     0.200
     3.315    51.562     0.200
     3.282    51.375     0.200
     3.282    51.973     0.200
     3.463    55.105     0.200
     3.471    54.742     0.200
     3.471    55.332     0.200
     3.545    54.633     0.200
     3.665    57.125     0.200
     3.665    58.941     0.200
     3.640    57.809     0.200
     3.744    61.094     0.200
     3.832    59.555     0.200
     3.832    59.445     0.200
     3.831    60.629     0.200
     3.857    61.043     0.200
     3.857    61.422     0.200
     3.862    58.953     0.200
     3.883    60.523     0.200
     3.972    62.883     0.200
     3.991    61.543     0.200
     3.991    61.734     0.200
     4.068    62.184     0.200
     4.068    62.488     0.200
     4.125    63.664     0.200
     4.125    64.434     0.200
     4.125    63.254     0.200
     4.212    64.766     0.200
     4.349    66.453     0.200
     4.349    66.055     0.200
     4.376    66.355     0.200
     4.376    67.184     0.200
     4.398    66.984     0.200
     4.431    68.395     0.200
     4.462    68.004     0.200
     4.609    70.930     0.200
     4.674    72.184     0.200
     4.655    70.613     0.200
     4.712    72.902     0.200
     4.712    73.352     0.200
     4.700    71.652     0.200
     4.829    73.605     0.200
     4.829    73.035     0.200
     4.808    72.934     0.200
     4.808    73.977     0.200
     4.815    72.672     0.200
     4.815    73.555     0.200
     4.964    77.223     0.200
     5.114    77.281     0.200
     5.114    76.395     0.200
     5.147    78.348     0.200
     5.166    76.695     0.200
     5.166    77.859     0.200
     5.270    80.023     0.200
     5.299    80.953     0.200
     5.299    80.457     0.200
     5.299    81.504     0.200
     5.294    79.652     0.200
     5.294    80.090     0.200
     5.324    81.391     0.200
     5.324    82.145     0.200
     5.365    82.414     0.200
     5.365    81.719     0.200
     5.365    82.273     0.200
     5.373    80.125     0.200
     5.488    83.375     0.200
     5.488    83.480     0.200
     5.557    83.516     0.200
     5.557    83.324     0.200
     5.605    84.605     0.200
     5.605    84.801     0.200
     5.605    85.305     0.200
     5.664    84.402     0.200
     5.750    84.172     0.200
     5.698    86.691     0.200
     5.707    86.516     0.200
     5.813    85.375     0.200
     5.813    87.035     0.200
     5.949    88.703     0.200
     5.984    88.664     0.200
     6.099    90.684     0.200
     6.099    91.797     0.200
     6.137    91.293     0.200
     6.137    92.273     0.200
     6.172    91.723     0.200
     6.172    93.402     0.200
     6.172    94.473     0.200
     6.217    92.133     0.200
     6.217    93.766     0.200
     6.221    91.516     0.200
     6.294    91.492     0.200
     6.336    94.383     0.200
     6.345    94.266     0.200
     6.345    95.844     0.200
     6.405    95.875     0.200
     6.437    95.094     0.200
     6.592    97.355     0.200
     6.592    98.844     0.200
     6.706    99.484     0.200
     6.706   100.305     0.200
     6.730    99.344     0.200
     6.730   100.203     0.200
     6.787    99.902     0.200
     6.788   100.828     0.200
     6.799   101.426     0.200
     6.799   101.242     0.200
     6.810   101.492     0.200
     6.850   102.684     0.200
     6.862    99.344     0.200
     6.889   102.852     0.200
     6.909   101.445     0.200
     6.955   103.984     0.200
     7.047   105.234     0.200
     7.139   106.352     0.200
     7.320   107.223     0.200
     7.320   107.898     0.200
     7.313   108.211     0.200
     7.345   107.812     0.200
     7.345   108.422     0.200
     7.468   109.289     0.200
     7.483   110.477     0.200
     7.527   111.020     0.200
     7.665   111.434     0.200
     7.665   112.527     0.200
     7.690   113.535     0.200
     7.686   113.113     0.200
     7.737   113.676     0.200
     7.773   111.355     0.200
     7.773   113.094     0.200
     7.890   116.410     0.200
     7.910   114.543     0.200
     7.910   116.078     0.200
     7.992   115.754     0.200
     7.992   117.633     0.200
     7.995   116.492     0.200
     7.995   117.547     0.200
     8.001   115.645     0.200
     8.001   118.195     0.200
     8.079   116.703     0.200
     8.164   118.973     0.200
     8.188   120.242     0.200
     8.246   120.945     0.200
     8.313   121.746     0.200
     8.402   121.473     0.200
     8.528   124.617     0.200
     8.595   124.895     0.200
     8.622   124.516     0.200
     8.639   127.609     0.200
     8.837   127.062     0.200
     8.837   128.211     0.200
     8.865   129.723     0.200
     8.910   129.914     0.200
     8.910   130.625     0.200
     8.999   132.488     0.200
     9.122   133.754     0.200
     9.401   135.422     0.200
     1.672    29.164     0.200
     1.732    30.084     0.200
     1.758    30.414     0.200
     1.759    30.794     0.200
     1.757    30.624     0.200
     1.757    30.438     0.200
     1.789    31.204     0.200
     1.793    30.864     0.200
     1.880    32.211     0.200
     1.903    32.044     0.200
     2.110    35.204     0.200
     2.122    36.124     0.200
     2.122    35.856     0.200
     2.147    35.744     0.200
     2.222    37.314     0.200
     2.253    37.734     0.200
     2.343    38.664     0.200
     2.343    38.544     0.200
     2.344    39.004     0.200
     2.384    39.104     0.200
     2.476    40.254     0.200
     2.488    40.824     0.200
     2.592    42.164     0.200
     2.634    42.054     0.200
     2.650    42.224     0.200
     2.650    42.617     0.200
     2.750    44.284     0.200
     2.750    44.504     0.200
     2.750    44.396     0.200
     2.813    44.434     0.200
     2.813    44.547     0.200
     2.886    46.394     0.200
     3.030    48.544     0.200
     3.030    48.674     0.200
     3.114    48.454     0.200
     3.118    50.104     0.200
     3.210    51.194     0.200
     3.309    51.584     0.200
     3.309    51.754     0.200
     3.335    51.564     0.200
     3.335    51.134     0.200
     3.419    53.634     0.200
     3.414    53.164     0.200
     3.414    53.826     0.200
     3.443    54.664     0.200
     3.511    55.614     0.200
     3.627    57.094     0.200
     3.627    56.974     0.200
     3.782    58.824     0.200
     3.811    59.354     0.200
     3.811    59.734     0.200
     3.846    60.174     0.200
     3.846    59.857     0.200
     3.868    60.124     0.200
     3.920    60.464     0.200
     4.068    62.124     0.200
     4.068    61.984     0.200
     4.168    63.924     0.200
     4.373    67.034     0.200
     4.569    69.184     0.200
     4.662    71.184     0.200
     4.662    71.002     0.200
     4.669    71.804     0.200
     4.669    71.703     0.200
     4.751    72.454     0.200
     5.249    79.174     0.200
     5.249    80.114     0.200
     5.279    80.384     0.200
     5.279    80.504     0.200
     5.312    79.814     0.200
     5.312    80.554     0.200
     5.432    81.024     0.200
     5.549    83.454     0.200
     6.104    90.514     0.200
     6.104    90.286     0.200
     6.131    91.444     0.200
     6.162    91.414     0.200
     7.175   105.145     0.200
     1.873    33.203     0.200
     1.945    33.162     0.200
     1.880    33.273     0.200
     2.055    35.922     0.200
     2.069    34.373     0.200
     2.090    37.043     0.200
     2.090    36.492     0.200
     2.092    36.762     0.200
     2.132    36.992     0.200
     2.130    36.854     0.200
     2.130    37.057     0.200
     2.236    39.012     0.200
     2.311    38.793     0.200
     2.336    39.832     0.200
     2.325    39.213     0.200
     2.340    39.832     0.200
     2.477    41.342     0.200
     2.477    41.512     0.200
     2.538    42.133     0.200
     2.538    42.338     0.200
     2.538    42.412     0.200
     2.533    42.883     0.200
     2.533    43.203     0.200
     2.560    42.053     0.200
     2.580    42.762     0.200
     2.580    43.590     0.200
     2.723    45.273     0.200
     2.723    45.576     0.200
     2.777    46.203     0.200
     2.777    45.604     0.200
     2.852    46.883     0.200
     2.856    46.963     0.200
     3.064    48.902     0.200
     3.008    49.623     0.200
     3.032    48.863     0.200
     3.032    49.113     0.200
     3.065    50.193     0.200
     3.065    50.033     0.200
     3.054    48.703     0.200
     3.054    49.119     0.200
     3.054    49.412     0.200
     3.127    49.643     0.200
     3.170    50.012     0.200
     3.170    52.094     0.200
     3.280    52.982     0.200
     3.259    51.992     0.200
     3.259    52.166     0.200
     3.259    51.713     0.200
     3.362    53.482     0.200
     3.362    52.840     0.200
     3.362    52.652     0.200
     3.428    53.893     0.200
     3.443    52.604     0.200
     3.499    56.662     0.200
     3.561    57.354     0.200
     3.611    58.223     0.200
     3.611    57.930     0.200
     3.654    58.453     0.200
     3.654    58.260     0.200
     3.736    58.592     0.200
     3.803    60.322     0.200
     3.936    60.822     0.200
     3.936    61.027     0.200
     4.022    63.242     0.200
     4.022    63.094     0.200
     3.978    62.172     0.200
     4.121    64.582     0.200
     4.121    64.289     0.200
     4.342    67.135     0.200
     4.425    69.053     0.200
     4.425    69.420     0.200
     4.453    68.553     0.200
     4.453    68.768     0.200
     4.474    69.096     0.200
     4.475    68.963     0.200
     4.491    68.893     0.200
     4.491    69.311     0.200
     4.740    72.354     0.200
     4.802    72.572     0.200
     4.988    76.393     0.200
     4.987    77.182     0.200
     4.987    77.604     0.200
     5.035    77.123     0.200
     5.031    77.443     0.200
     5.031    77.662     0.200
     5.045    77.854     0.200
     5.167    80.473     0.200
     5.281    81.682     0.200
     5.276    79.123     0.200
     5.310    80.762     0.200
     5.516    81.973     0.200
     5.516    81.842     0.200
     5.612    83.832     0.200
     5.607    85.693     0.200
     5.706    84.252     0.200
     5.841    88.033     0.200
     5.894    89.604     0.200
     5.894    89.893     0.200
     5.932    88.082     0.200
     5.992    89.832     0.200
     6.728    99.932     0.200
     6.745   100.963     0.200
     6.745   100.332     0.200
     6.777   100.332     0.200
     6.785   101.443     0.200
     6.930   103.613     0.200
     7.209   105.582     0.200
     7.287   107.822     0.200
     7.761   113.162     0.200
     7.997   118.223     0.200
     8.305   120.492     0.200
     1.734    30.263     0.200
     1.735    30.027     0.200
     1.835    31.521     0.200
     2.068    35.193     0.200
     2.296    38.206     0.200
     2.297    38.679     0.200
     2.357    39.303     0.200
     2.427    40.303     0.200
     2.606    42.015     0.200
     2.715    43.753     0.200
     2.715    44.272     0.200
     2.753    44.091     0.200
     2.834    45.622     0.200
     2.982    48.232     0.200
     2.982    48.493     0.200
     3.006    46.916     0.200
     3.006    46.533     0.200
     3.057    48.843     0.200
     3.317    52.223     0.200
     3.370    52.759     0.200
     3.765    59.177     0.200
     3.765    59.353     0.200
     3.866    60.060     0.200
     3.866    60.163     0.200
     4.008    61.533     0.200
     4.625    71.170     0.200
     4.625    71.363     0.200
     5.233    80.223     0.200
     5.257    79.973     0.200
     1.837    32.938     0.200
     1.837    33.523     0.200
     2.297    39.918     0.200
     2.354    40.258     0.200
     2.354    40.785     0.200
     2.354    40.746     0.200
     2.354    40.922     0.200
     2.404    41.324     0.200
     2.404    41.516     0.200
     2.476    41.484     0.200
     2.476    42.113     0.200
     2.507    41.348     0.200
     2.711    45.207     0.200
     2.752    45.699     0.200
     2.797    47.152     0.200
     3.038    50.562     0.200
     3.048    49.383     0.200
     3.279    52.363     0.200
     3.302    53.133     0.200
     3.436    55.004     0.200
     3.823    61.703     0.200
     3.899    61.664     0.200
     4.006    63.094     0.200
     4.689    73.953     0.200
     5.284    81.203     0.200
     5.293    81.684     0.200
     6.091    92.074     0.200
     7.194   107.062     0.200
     1.842    32.930     0.200
     2.204    38.156     0.200
     2.204    38.273     0.200
     2.312    38.891     0.200
     2.402    40.688     0.200
     2.402    41.125     0.200
     2.572    43.875     0.200
     2.690    44.320     0.200
     2.721    44.336     0.200
     2.776    46.133     0.200
     2.790    45.797     0.200
     2.790    46.141     0.200
     3.087    50.766     0.200
     3.287    52.250     0.200
     3.867    61.359     0.200
     3.988    62.836     0.200
     4.721    73.883     0.200
     5.334    82.695     0.200
     5.383    82.859     0.200
     6.178    94.109     0.200
     1.693    29.711     0.200
     1.733    29.578     0.200
     1.741    29.836     0.200
     1.854    32.281     0.200
     1.869    32.195     0.200
     1.887    32.047     0.200
     1.887    32.562     0.200
     1.926    32.477     0.200
     1.975    34.391     0.200
     1.991    34.625     0.200
     2.015    34.047     0.200
     2.054    35.406     0.200
     2.077    35.211     0.200
     2.116    36.039     0.200
     2.156    35.789     0.200
     2.255    37.961     0.200
     2.255    37.844     0.200
     2.255    37.000     0.200
     2.411    40.195     0.200
     2.411    40.562     0.200
     2.474    39.867     0.200
     2.474    39.211     0.200
     2.500    41.078     0.200
     2.561    42.086     0.200
     2.581    42.492     0.200
     2.581    41.562     0.200
     2.651    42.922     0.200
     2.758    44.125     0.200
     2.771    44.039     0.200
     2.803    44.688     0.200
     2.860    45.656     0.200
     2.901    46.406     0.200
     2.902    46.742     0.200
     2.958    46.812     0.200
     3.190    49.477     0.200
     3.245    51.117     0.200
     3.245    52.039     0.200
     3.247    50.672     0.200
     3.247    51.219     0.200
     3.260    51.117     0.200
     3.260    52.070     0.200
     3.260    52.297     0.200
     3.406    52.797     0.200
     3.422    53.562     0.200
     3.685    57.180     0.200
     4.019    62.547     0.200
     4.169    65.227     0.200
     4.169    64.469     0.200
     4.436    66.750     0.200
     4.616    69.000     0.200
     4.675    70.727     0.200
     4.675    71.438     0.200
     4.861    74.945     0.200
     4.971    73.836     0.200
     5.130    76.320     0.200
     5.481    83.500     0.200
     5.920    87.336     0.200
     2.246    39.062     0.200
     2.246    38.914     0.200
     2.306    40.016     0.200
     2.287    39.672     0.200
     2.476    41.594     0.200
     2.447    41.695     0.200
     2.447    40.297     0.200
     2.699    46.086     0.200
     2.698    45.555     0.200
     2.930    48.609     0.200
     3.715    59.414     0.200
     4.583    72.328     0.200
     1.606    28.020     0.200
     1.603    27.840     0.200
     1.646    28.070     0.200
     1.653    27.742     0.200
     1.705    29.902     0.200
     1.770    29.500     0.200
     1.794    29.730     0.200
     1.802    31.199     0.200
     1.815    31.270     0.200
     1.830    31.840     0.200
     1.830    31.543     0.200
     1.836    31.660     0.200
     1.852    32.320     0.200
     1.852    31.520     0.200
     1.852    31.301     0.200
     1.985    33.949     0.200
     1.985    33.836     0.200
     2.083    35.391     0.200
     2.094    34.801     0.200
     2.161    36.160     0.200
     2.226    38.031     0.200
     2.226    37.680     0.200
     2.226    37.859     0.200
     2.230    37.750     0.200
     2.230    37.859     0.200
     2.303    38.191     0.200
     2.334    39.430     0.200
     2.334    39.062     0.200
     2.334    39.250     0.200
     2.344    38.770     0.200
     2.327    38.512     0.200
     2.327    38.332     0.200
     2.381    39.359     0.200
     2.381    39.180     0.200
     2.423    39.512     0.200
     2.423    39.340     0.200
     2.508    40.812     0.200
     2.540    41.340     0.200
     2.540    41.023     0.200
     2.541    40.980     0.200
     2.661    43.211     0.200
     2.661    42.918     0.200
     2.663    43.910     0.200
     2.663    43.578     0.200
     2.663    43.770     0.200
     2.744    44.582     0.200
     2.755    44.883     0.200
     2.755    44.520     0.200
     2.755    44.633     0.200
     2.911    47.141     0.200
     2.911    47.484     0.200
     2.911    47.652     0.200
     2.961    47.602     0.200
     2.965    47.281     0.200
     2.965    47.070     0.200
     2.926    46.883     0.200
     2.926    47.297     0.200
     2.988    46.133     0.200
     2.988    45.852     0.200
     3.043    47.781     0.200
     3.043    47.598     0.200
     3.062    47.789     0.200
     3.062    47.422     0.200
     3.173    51.242     0.200
     3.173    51.062     0.200
     3.260    52.289     0.200
     3.260    52.172     0.200
     3.260    52.051     0.200
     3.298    51.910     0.200
     3.331    52.391     0.200
     3.331    52.496     0.200
     3.317    51.660     0.200
     3.371    52.109     0.200
     3.371    51.539     0.200
     3.414    53.109     0.200
     3.415    51.410     0.200
     3.399    52.609     0.200
     3.399    52.484     0.200
     3.399    52.262     0.200
     3.649    57.000     0.200
     3.649    57.293     0.200
     3.695    58.602     0.200
     3.695    58.734     0.200
     3.726    57.070     0.200
     3.726    57.457     0.200
     3.784    59.391     0.200
     3.866    59.719     0.200
     3.896    59.141     0.200
     3.917    60.531     0.200
     3.917    60.742     0.200
     3.959    60.602     0.200
     3.959    60.371     0.200
     3.952    61.410     0.200
     3.952    60.660     0.200
     3.952    60.812     0.200
     3.973    60.633     0.200
     3.973    60.492     0.200
     3.973    60.191     0.200
     4.044    62.352     0.200
     4.044    62.078     0.200
     4.211    64.180     0.200
     4.220    64.609     0.200
     4.220    64.973     0.200
     4.223    65.633     0.200
     4.223    65.742     0.200
     4.330    65.840     0.200
     4.458    66.723     0.200
     4.458    67.715     0.200
     4.492    68.070     0.200
     4.492    67.598     0.200
     4.465    67.312     0.200
     4.465    67.211     0.200
     4.515    68.180     0.200
     4.515    68.352     0.200
     4.552    69.641     0.200
     4.552    69.871     0.200
     4.559    70.473     0.200
     4.559    70.297     0.200
     4.598    70.020     0.200
     4.598    70.125     0.200
     4.621    70.340     0.200
     4.621    70.105     0.200
     4.754    71.570     0.200
     4.810    72.609     0.200
     4.810    72.746     0.200
     4.962    74.816     0.200
     4.992    75.035     0.200
     5.029    74.602     0.200
     5.083    76.820     0.200
     5.083    76.230     0.200
     5.119    77.480     0.200
     5.119    77.961     0.200
     5.165    79.152     0.200
     5.165    78.668     0.200
     5.165    78.961     0.200
     5.173    78.223     0.200
     5.173    77.945     0.200
     5.173    78.102     0.200
     5.280    79.770     0.200
     5.280    79.535     0.200
     5.280    79.891     0.200
     5.255    77.551     0.200
     5.255    78.484     0.200
     5.305    79.402     0.200
     5.305    79.113     0.200
     5.403    81.801     0.200
     5.403    81.375     0.200
     5.403    80.633     0.200
     5.537    83.762     0.200
     5.551    82.840     0.200
     5.551    83.605     0.200
     5.604    81.652     0.200
     5.604    82.730     0.200
     5.888    85.133     0.200
     5.889    86.762     0.200
     5.973    89.082     0.200
     5.973    88.812     0.200
     6.004    89.262     0.200
     6.004    88.746     0.200
     6.017    89.648     0.200
     6.075    90.652     0.200
     6.141    89.473     0.200
     6.248    93.359     0.200
     6.535    97.070     0.200
     6.606    98.527     0.200
     6.667    99.562     0.200
     6.679    97.801     0.200
     6.736    99.500     0.200
     6.736    98.980     0.200
     6.857   100.430     0.200
     6.879   101.422     0.200
     6.879   101.086     0.200
     6.928   102.332     0.200
     6.951   101.758     0.200
     7.065   103.371     0.200
     7.065   103.758     0.200
     7.065   103.871     0.200
     7.103   104.039     0.200
     7.140   104.250     0.200
     7.140   103.633     0.200
     7.181   104.449     0.200
     7.240   105.742     0.200
     7.240   105.898     0.200
     7.316   107.102     0.200
     7.316   107.695     0.200
     7.331   106.812     0.200
     7.331   107.102     0.200
     7.483   110.039     0.200
     7.487   109.531     0.200
     7.487   109.688     0.200
     7.581   110.871     0.200
     7.581   110.656     0.200
     7.684   113.336     0.200
     7.684   113.121     0.200
     7.738   110.750     0.200
     7.783   114.121     0.200
     7.783   114.422     0.200
     7.807   113.031     0.200
     7.807   114.219     0.200
     8.102   118.492     0.200
     8.102   119.594     0.200
     8.123   118.332     0.200
     8.342   120.801     0.200
     8.345   119.781     0.200
     8.345   121.547     0.200
     8.550   125.340     0.200
     8.558   124.164     0.200
     8.699   127.359     0.200
     8.699   127.621     0.200
     8.759   126.000     0.200
     8.911   129.859     0.200
     9.001   129.910     0.200
     9.239   132.137     0.200
     9.394   135.949     0.200
     1.608    27.911     0.200
     1.751    30.471     0.200
     1.803    30.811     0.200
     1.814    31.440     0.200
     1.884    32.413     0.200
     1.864    31.900     0.200
     1.864    32.275     0.200
     1.969    33.294     0.200
     2.008    33.701     0.200
     2.031    34.190     0.200
     2.111    35.221     0.200
     2.111    35.569     0.200
     2.205    36.241     0.200
     2.216    36.271     0.200
     2.287    37.511     0.200
     2.287    38.387     0.200
     2.326    38.791     0.200
     2.375    39.230     0.200
     2.336    38.791     0.200
     2.473    40.211     0.200
     2.540    40.451     0.200
     2.540    41.001     0.200
     2.516    41.091     0.200
     2.516    41.474     0.200
     2.591    41.440     0.200
     2.591    41.623     0.200
     2.633    42.431     0.200
     2.684    43.721     0.200
     2.683    42.281     0.200
     2.683    43.351     0.200
     2.777    44.014     0.200
     2.892    45.811     0.200
     2.892    46.601     0.200
     2.885    45.431     0.200
     2.885    45.271     0.200
     3.002    46.771     0.200
     3.002    47.471     0.200
     3.042    48.411     0.200
     3.042    48.647     0.200
     3.026    47.841     0.200
     3.201    50.982     0.200
     3.231    50.519     0.200
     3.311    51.171     0.200
     3.315    51.001     0.200
     3.315    51.431     0.200
     3.292    52.301     0.200
     3.292    52.536     0.200
     3.290    50.771     0.200
     3.290    50.535     0.200
     3.321    51.961     0.200
     3.560    54.951     0.200
     3.560    55.122     0.200
     3.544    55.860     0.200
     3.617    56.381     0.200
     3.607    55.121     0.200
     3.633    56.150     0.200
     3.695    57.841     0.200
     3.695    58.002     0.200
     3.763    57.841     0.200
     3.763    57.951     0.200
     3.936    59.761     0.200
     3.936    60.936     0.200
     3.941    60.320     0.200
     3.941    61.845     0.200
     3.980    62.491     0.200
     3.980    62.181     0.200
     3.991    62.841     0.200
     4.037    61.110     0.200
     4.106    63.601     0.200
     4.106    63.304     0.200
     4.265    64.860     0.200
     4.265    64.662     0.200
     4.311    65.440     0.200
     4.298    65.021     0.200
     4.298    64.733     0.200
     4.533    68.897     0.200
     4.568    68.900     0.200
     4.568    70.305     0.200
     4.582    68.891     0.200
     4.749    70.961     0.200
     4.741    71.021     0.200
     4.811    72.691     0.200
     4.831    73.751     0.200
     4.831    74.303     0.200
     4.892    73.791     0.200
     4.935    75.440     0.200
     4.948    74.131     0.200
     4.948    74.425     0.200
     5.241    79.501     0.200
     5.446    82.721     0.200
     5.446    82.891     0.200
     5.501    82.604     0.200
     5.629    83.999     0.200
     6.286    93.092     0.200
     6.285    92.320     0.200
     6.285    93.501     0.200
     7.193   104.151     0.200
     7.173   105.128     0.200
     7.353   106.990     0.200
     7.337   106.511     0.200
     7.337   107.646     0.200
     7.438   108.641     0.200
     7.825   113.536     0.200
     8.108   118.079     0.200
     8.667   126.333     0.200
     1.811    31.734     0.200
     1.912    32.938     0.200
     2.170    36.711     0.200
     2.289    38.984     0.200
     2.352    39.395     0.200
     2.409    40.535     0.200
     2.552    42.418     0.200
     2.682    43.793     0.200
     2.718    44.406     0.200
     2.807    45.539     0.200
     2.930    47.043     0.200
     3.094    49.641     0.200
     3.457    54.246     0.200
     3.875    61.762     0.200
     3.987    62.562     0.200
     4.731    73.551     0.200
     5.343    82.512     0.200
     1.771    29.839     0.200
     1.810    31.419     0.200
     1.810    31.563     0.200
     1.827    30.599     0.200
     1.864    32.219     0.200
     1.864    32.389     0.200
     1.892    32.539     0.200
     1.892    32.731     0.200
     1.963    33.169     0.200
     1.964    33.599     0.200
     2.017    33.482     0.200
     2.296    38.448     0.200
     2.296    39.247     0.200
     2.324    38.988     0.200
     2.324    38.709     0.200
     2.331    38.818     0.200
     2.520    42.119     0.200
     2.786    43.813     0.200
     3.051    48.938     0.200
     3.205    51.738     0.200
     3.205    50.682     0.200
     3.984    62.519     0.200
     4.112    64.169     0.200
     4.721    72.148     0.200
     4.834    74.309     0.200
     5.449    83.519     0.200
     7.340   107.783     0.200
     1.809    31.430     0.200
     1.860    32.316     0.200
     2.290    37.578     0.200
     2.332    38.403     0.200
     3.199    51.593     0.200
     3.977    62.418     0.200
     4.105    64.151     0.200
     4.828    74.410     0.200
     5.443    83.153     0.200
     7.334   108.244     0.200
     1.765    29.586     0.200
     1.754    30.135     0.200
     1.812    31.385     0.200
     1.812    31.586     0.200
     1.806    30.746     0.200
     1.821    30.885     0.200
     1.821    30.715     0.200
     1.864    32.105     0.200
     1.864    32.426     0.200
     1.886    32.605     0.200
     1.893    31.824     0.200
     1.958    33.605     0.200
     1.957    33.525     0.200
     1.957    33.145     0.200
     1.972    33.336     0.200
     1.972    33.467     0.200
     1.997    33.266     0.200
     2.004    33.885     0.200
     2.012    33.916     0.200
     2.034    33.734     0.200
     2.108    35.314     0.200
     2.108    35.521     0.200
     2.219    37.225     0.200
     2.290    37.936     0.200
     2.290    38.234     0.200
     2.290    38.041     0.200
     2.324    38.645     0.200
     2.324    38.965     0.200
     2.324    39.135     0.200
     2.321    38.756     0.200
     2.334    38.846     0.200
     2.378    38.836     0.200
     2.517    41.705     0.200
     2.517    41.596     0.200
     2.517    41.465     0.200
     2.555    42.855     0.200
     2.543    41.295     0.200
     2.543    41.057     0.200
     2.589    42.006     0.200
     2.589    41.678     0.200
     2.636    41.996     0.200
     2.685    43.535     0.200
     2.703    43.404     0.200
     2.703    43.215     0.200
     2.741    43.625     0.200
     2.780    44.125     0.200
     2.892    46.564     0.200
     2.892    46.926     0.200
     2.892    46.736     0.200
     2.882    45.426     0.200
     2.882    45.596     0.200
     3.005    47.205     0.200
     3.005    47.496     0.200
     3.005    47.377     0.200
     3.023    48.166     0.200
     3.023    47.395     0.200
     3.023    47.613     0.200
     3.045    48.416     0.200
     3.045    48.766     0.200
     3.045    48.561     0.200
     3.080    48.895     0.200
     3.202    50.996     0.200
     3.202    51.105     0.200
     3.234    50.756     0.200
     3.234    50.611     0.200
     3.291    52.336     0.200
     3.291    52.705     0.200
     3.287    50.885     0.200
     3.287    50.506     0.200
     3.319    52.195     0.200
     3.319    51.846     0.200
     3.371    52.336     0.200
     3.563    55.234     0.200
     3.609    56.115     0.200
     3.591    55.365     0.200
     3.694    57.625     0.200
     3.694    58.336     0.200
     3.694    57.803     0.200
     3.760    58.346     0.200
     3.944    61.295     0.200
     3.939    60.824     0.200
     3.939    61.006     0.200
     3.981    62.256     0.200
     3.981    62.365     0.200
     3.991    62.734     0.200
     3.991    62.598     0.200
     4.040    61.246     0.200
     4.108    63.475     0.200
     4.108    63.320     0.200
     4.267    64.855     0.200
     4.295    64.885     0.200
     4.314    65.416     0.200
     4.314    65.520     0.200
     4.475    67.729     0.200
     4.536    68.705     0.200
     4.571    68.666     0.200
     4.584    70.574     0.200
     4.722    71.895     0.200
     4.722    72.176     0.200
     4.752    71.939     0.200
     4.814    72.746     0.200
     4.831    73.975     0.200
     4.894    74.215     0.200
     4.950    73.916     0.200
     4.950    74.084     0.200
     5.040    75.016     0.200
     5.244    79.273     0.200
     5.262    79.172     0.200
     5.446    82.814     0.200
     5.446    83.256     0.200
     5.446    82.525     0.200
     5.437    80.814     0.200
     5.503    82.365     0.200
     5.503    84.256     0.200
     5.631    84.275     0.200
     5.657    84.512     0.200
     6.254    93.346     0.200
     6.255    92.744     0.200
     6.286    94.365     0.200
     6.286    94.154     0.200
     6.287    94.016     0.200
     6.287    93.541     0.200
     7.173   105.904     0.200
     7.173   105.271     0.200
     7.337   107.715     0.200
     7.828   114.666     0.200
     7.828   115.189     0.200
     7.829   114.795     0.200
     7.897   116.014     0.200
     8.111   118.773     0.200
     1.891    33.107     0.200
     1.936    32.652     0.200
     1.953    33.742     0.200
     2.039    34.191     0.200
     2.087    35.592     0.200
     2.230    37.902     0.200
     2.264    37.861     0.200
     2.291    37.652     0.200
     2.302    38.281     0.200
     2.347    38.781     0.200
     2.436    40.072     0.200
     2.458    39.922     0.200
     2.458    41.010     0.200
     2.471    40.762     0.200
     2.475    39.992     0.200
     2.475    40.998     0.200
     2.702    44.781     0.200
     2.717    45.041     0.200
     2.949    48.182     0.200
     2.956    47.141     0.200
     3.238    52.270     0.200
     3.345    52.631     0.200
     3.473    54.289     0.200
     3.597    56.172     0.200
     3.734    60.139     0.200
     3.806    59.941     0.200
     3.822    58.441     0.200
     3.986    61.191     0.200
     4.589    68.521     0.200
     5.147    78.162     0.200
     5.191    79.891     0.200
     5.279    81.541     0.200
     5.319    81.002     0.200
     5.486    82.312     0.200
     5.579    82.922     0.200
     5.900    87.172     0.200
     5.999    89.742     0.200
     6.073    90.451     0.200
     6.106    90.971     0.200
     1.713    29.270     0.200
     1.794    31.740     0.200
     1.829    32.240     0.200
     1.846    32.270     0.200
     2.179    36.770     0.200
     2.340    39.030     0.200
     2.405    40.383     0.200
     2.693    43.356     0.200
     2.801    45.900     0.200
     2.801    45.295     0.200
     3.091    49.830     0.200
     3.239    52.390     0.200
     3.871    61.160     0.200
     3.871    60.939     0.200
     4.684    72.045     0.200
     4.727    73.150     0.200
     4.727    72.922     0.200
     5.339    81.710     0.200
     1.678    28.828     0.200
     1.850    32.518     0.200
     2.208    36.898     0.200
     2.389    39.877     0.200
     2.422    40.908     0.200
     2.518    41.418     0.200
     2.523    41.848     0.200
     2.523    42.637     0.200
     2.958    47.348     0.200
     2.922    47.668     0.200
     3.209    51.717     0.200
     3.273    51.697     0.200
     3.990    62.447     0.200
     4.096    63.887     0.200
     4.847    73.758     0.200
     5.458    83.098     0.200
     5.487    83.387     0.200
     1.743    30.664     0.200
     1.795    31.464     0.200
     1.872    32.074     0.200
     1.924    33.694     0.200
     1.928    32.794     0.200
     1.984    33.364     0.200
     2.009    34.294     0.200
     2.057    35.374     0.200
     2.098    36.124     0.200
     2.098    35.885     0.200
     2.119    35.434     0.200
     2.128    36.028     0.200
     2.129    35.904     0.200
     2.151    35.244     0.200
     2.216    37.394     0.200
     2.216    37.714     0.200
     2.216    37.503     0.200
     2.235    37.204     0.200
     2.235    38.164     0.200
     2.235    37.722     0.200
     2.332    37.964     0.200
     2.345    38.784     0.200
     2.391    39.844     0.200
     2.391    40.004     0.200
     2.446    40.764     0.200
     2.485    41.474     0.200
     2.502    41.644     0.200
     2.502    42.094     0.200
     2.593    42.084     0.200
     2.593    42.314     0.200
     2.601    42.124     0.200
     2.669    43.684     0.200
     2.746    45.754     0.200
     2.741    44.194     0.200
     2.756    43.704     0.200
     2.756    44.411     0.200
     2.811    46.184     0.200
     2.845    46.974     0.200
     2.845    46.554     0.200
     2.845    46.218     0.200
     2.898    46.414     0.200
     2.916    45.014     0.200
     2.971    47.944     0.200
     3.151    50.514     0.200
     3.151    50.204     0.200
     3.151    49.964     0.200
     3.155    51.654     0.200
     3.163    49.314     0.200
     3.163    49.895     0.200
     3.185    51.604     0.200
     3.185    51.374     0.200
     3.185    51.831     0.200
     3.205    50.584     0.200
     3.205    51.864     0.200
     3.205    52.407     0.200
     3.360    52.474     0.200
     3.358    52.444     0.200
     3.489    54.894     0.200
     3.636    56.774     0.200
     3.636    57.024     0.200
     3.677    57.274     0.200
     3.676    56.904     0.200
     3.676    57.650     0.200
     3.716    58.144     0.200
     3.742    59.524     0.200
     3.812    60.106     0.200
     3.947    63.054     0.200
     3.960    62.334     0.200
     3.960    61.934     0.200
     3.960    62.762     0.200
     4.048    61.924     0.200
     4.048    63.585     0.200
     4.061    61.554     0.200
     4.061    63.367     0.200
     4.113    64.214     0.200
     4.113    64.501     0.200
     4.170    63.714     0.200
     4.166    63.224     0.200
     4.307    66.094     0.200
     4.307    65.984     0.200
     4.426    68.014     0.200
     4.659    71.584     0.200
     4.801    73.844     0.200
     4.801    73.674     0.200
     4.801    74.154     0.200
     4.815    74.154     0.200
     4.918    75.494     0.200
     4.918    74.594     0.200
     4.918    75.284     0.200
     5.033    76.984     0.200
     5.124    78.414     0.200
     5.366    80.074     0.200
     5.366    81.884     0.200
     5.421    83.204     0.200
     5.421    82.689     0.200
     5.424    82.194     0.200
     5.513    83.364     0.200
     5.562    82.834     0.200
     5.670    85.064     0.200
     5.670    85.573     0.200
     5.775    86.394     0.200
     5.922    89.234     0.200
     6.146    90.994     0.200
     6.248    92.524     0.200
     6.283    93.304     0.200
     6.283    93.014     0.200
     6.283    93.889     0.200
     6.379    94.044     0.200
     6.921   102.424     0.200
     6.947   102.234     0.200
     6.986   104.574     0.200
     7.156   106.024     0.200
     7.307   108.014     0.200
     7.307   107.800     0.200
     7.319   106.124     0.200
     7.481   108.934     0.200
     7.689   112.214     0.200
     7.868   115.574     0.200
     8.064   118.364     0.200
     8.672   127.744     0.200
     9.004   129.594     0.200
     1.786    30.668     0.200
     1.809    30.428     0.200
     1.840    32.377     0.200
     1.828    32.127     0.200
     2.021    35.066     0.200
     2.026    34.617     0.200
     2.122    36.027     0.200
     2.294    39.393     0.200
     2.273    38.838     0.200
     2.311    38.428     0.200
     2.375    39.357     0.200
     2.393    39.967     0.200
     2.393    40.607     0.200
     2.400    40.107     0.200
     2.400    40.277     0.200
     2.556    41.678     0.200
     2.556    41.150     0.200
     2.713    43.502     0.200
     2.725    44.617     0.200
     2.725    44.846     0.200
     2.786    45.430     0.200
     2.979    48.670     0.200
     3.027    48.146     0.200
     3.321    52.607     0.200
     3.357    53.225     0.200
     3.406    53.316     0.200
     3.762    59.996     0.200
     3.852    59.566     0.200
     3.852    60.695     0.200
     4.619    71.625     0.200
     4.626    72.035     0.200
     4.659    71.412     0.200
     5.188    78.428     0.200
     5.232    80.600     0.200
     5.241    79.119     0.200
     6.041    89.848     0.200
     6.041    90.131     0.200
     7.131   104.707     0.200
     1.806    30.898     0.200
     1.809    31.387     0.200
     1.861    32.566     0.200
     1.962    34.047     0.200
     2.064    35.539     0.200
     2.328    39.977     0.200
     2.484    40.938     0.200
     2.817    44.500     0.200
     2.843    46.129     0.200
     3.088    49.969     0.200
     3.168    50.156     0.200
     4.085    62.859     0.200
     1.981    33.844     0.200
     1.981    34.516     0.200
     2.147    38.281     0.200
     2.146    37.609     0.200
     2.146    37.188     0.200
     2.155    37.242     0.200
     2.327    39.570     0.200
     2.327    40.445     0.200
     2.559    43.180     0.200
     2.580    43.289     0.200
     2.756    46.352     0.200
     2.756    46.734     0.200
     2.832    47.242     0.200
     2.912    48.344     0.200
     3.076    49.695     0.200
     3.035    48.281     0.200
     3.308    53.445     0.200
     3.615    58.078     0.200
     3.711    60.031     0.200
     3.859    61.023     0.200
     4.478    70.742     0.200
     5.084    78.969     0.200
     5.102    79.812     0.200
     1.825    31.449     0.200
     1.843    32.348     0.200
     1.876    32.078     0.200
     1.887    32.621     0.200
     1.882    33.078     0.200
     1.882    33.270     0.200
     1.964    33.598     0.200
     1.962    34.168     0.200
     1.962    34.508     0.200
     2.008    34.500     0.200
     2.008    34.820     0.200
     2.024    34.629     0.200
     2.079    35.168     0.200
     2.084    35.457     0.200
     2.107    35.898     0.200
     2.232    38.211     0.200
     2.232    37.961     0.200
     2.234    37.738     0.200
     2.234    37.941     0.200
     2.293    38.609     0.200
     2.310    38.949     0.200
     2.342    39.820     0.200
     2.383    39.020     0.200
     2.383    40.078     0.200
     2.438    40.750     0.200
     2.469    41.328     0.200
     2.469    41.871     0.200
     2.549    42.020     0.200
     2.549    42.621     0.200
     2.549    42.180     0.200
     2.549    41.344     0.200
     2.563    42.441     0.200
     2.556    42.250     0.200
     2.556    41.703     0.200
     2.636    42.750     0.200
     2.640    43.020     0.200
     2.640    42.250     0.200
     2.693    44.469     0.200
     2.697    44.840     0.200
     2.697    43.578     0.200
     2.772    45.461     0.200
     2.823    45.281     0.200
     2.823    45.559     0.200
     2.792    44.691     0.200
     2.792    44.480     0.200
     2.823    47.281     0.200
     2.823    46.219     0.200
     2.823    45.574     0.200
     2.854    45.559     0.200
     2.854    45.762     0.200
     2.963    47.891     0.200
     2.963    47.262     0.200
     3.031    48.410     0.200
     3.019    47.691     0.200
     3.103    49.828     0.200
     3.103    50.328     0.200
     3.103    49.715     0.200
     3.153    51.289     0.200
     3.153    51.008     0.200
     3.200    51.129     0.200
     3.200    51.809     0.200
     3.201    51.258     0.200
     3.201    51.719     0.200
     3.190    50.590     0.200
     3.190    49.828     0.200
     3.219    51.230     0.200
     3.219    51.109     0.200
     3.318    52.660     0.200
     3.318    52.250     0.200
     3.313    52.109     0.200
     3.318    52.039     0.200
     3.317    52.500     0.200
     3.317    52.199     0.200
     3.445    54.520     0.200
     3.497    55.469     0.200
     3.497    54.637     0.200
     3.582    55.848     0.200
     3.630    57.539     0.200
     3.630    57.098     0.200
     3.628    56.750     0.200
     3.600    57.609     0.200
     3.600    57.430     0.200
     3.600    57.125     0.200
     3.676    56.918     0.200
     3.676    56.695     0.200
     3.929    62.379     0.200
     3.929    62.016     0.200
     3.924    62.480     0.200
     4.000    62.730     0.200
     4.074    64.211     0.200
     4.074    64.020     0.200
     4.074    63.875     0.200
     4.131    63.121     0.200
     4.235    64.418     0.200
     4.235    63.848     0.200
     4.205    64.148     0.200
     4.205    63.879     0.200
     4.205    63.996     0.200
     4.261    65.629     0.200
     4.326    66.270     0.200
     4.326    67.848     0.200
     4.380    67.598     0.200
     4.380    67.004     0.200
     4.543    69.004     0.200
     4.583    70.918     0.200
     4.583    69.535     0.200
     4.618    70.230     0.200
     4.618    69.859     0.200
     4.664    70.699     0.200
     4.664    71.055     0.200
     4.771    73.168     0.200
     4.773    74.098     0.200
     4.773    73.680     0.200
     4.821    73.309     0.200
     4.869    74.031     0.200
     4.869    73.617     0.200
     4.953    75.219     0.200
     4.953    74.711     0.200
     5.096    76.859     0.200
     5.096    76.199     0.200
     5.277    78.793     0.200
     5.317    79.977     0.200
     5.325    80.078     0.200
     5.389    82.348     0.200
     5.391    82.598     0.200
     5.391    82.738     0.200
     5.439    81.969     0.200
     5.448    82.258     0.200
     5.473    83.008     0.200
     5.473    82.758     0.200
     5.524    82.508     0.200
     5.726    86.168     0.200
     5.727    86.621     0.200
     5.727    86.406     0.200
     5.860    88.461     0.200
     5.875    88.879     0.200
     5.875    88.543     0.200
     5.972    88.609     0.200
     5.972    88.430     0.200
     6.114    91.090     0.200
     6.223    93.801     0.200
     6.223    93.691     0.200
     6.223    93.031     0.200
     6.247    93.301     0.200
     6.247    93.180     0.200
     6.247    92.977     0.200
     6.306    94.551     0.200
     6.306    94.754     0.200
     6.327    94.398     0.200
     6.327    94.887     0.200
     6.337    94.820     0.200
     6.337    95.242     0.200
     6.741    99.691     0.200
     6.918   103.398     0.200
     6.951   102.230     0.200
     7.295   106.191     0.200
     7.279   107.051     0.200
     7.279   107.414     0.200
     7.778   114.059     0.200
     7.877   113.309     0.200
     8.020   118.020     0.200
     8.129   119.078     0.200
     8.279   121.031     0.200
     8.434   122.488     0.200
     8.607   125.668     0.200
     8.634   126.160     0.200
     8.697   125.898     0.200
     8.686   126.750     0.200
     8.759   127.820     0.200
     8.965   129.559     0.200
     9.306   136.031     0.200
     9.362   136.910     0.200
     9.751   143.230     0.200
     9.838   144.949     0.200
     9.846   144.770     0.200
    10.237   149.898     0.200
    10.494   151.348     0.200
    11.342   162.570     0.200
    12.059   171.578     0.200
     1.925    32.381     0.200
     1.926    33.321     0.200
     1.926    33.581     0.200
     1.928    33.801     0.200
     2.024    34.171     0.200
     2.223    37.591     0.200
     2.223    38.011     0.200
     2.278    37.980     0.200
     2.314    39.001     0.200
     2.296    39.281     0.200
     2.296    39.781     0.200
     2.329    39.461     0.200
     2.407    40.091     0.200
     2.341    39.631     0.200
     2.341    40.261     0.200
     2.445    40.321     0.200
     2.454    40.261     0.200
     2.493    41.081     0.200
     2.493    41.901     0.200
     2.637    44.031     0.200
     2.689    44.201     0.200
     2.689    44.661     0.200
     2.754    45.521     0.200
     2.754    46.161     0.200
     2.945    47.331     0.200
     2.970    47.421     0.200
     2.973    48.301     0.200
     2.973    48.101     0.200
     2.980    48.801     0.200
     2.980    49.511     0.200
     3.157    49.581     0.200
     3.283    53.711     0.200
     3.283    53.591     0.200
     3.444    55.041     0.200
     3.505    55.061     0.200
     3.505    54.901     0.200
     3.713    59.261     0.200
     3.832    60.951     0.200
     3.969    62.081     0.200
     3.946    61.591     0.200
     4.212    65.371     0.200
     4.674    71.661     0.200
     4.635    72.741     0.200
     4.635    72.331     0.200
     5.215    80.881     0.200
     5.294    81.311     0.200
     6.107    90.401     0.200
     6.943   102.431     0.200
     7.138   105.031     0.200
     1.708    29.531     0.200
     1.831    31.227     0.200
     1.854    30.953     0.200
     1.859    32.430     0.200
     1.814    31.586     0.200
     2.068    35.023     0.200
     2.068    35.414     0.200
     2.067    35.203     0.200
     2.110    36.000     0.200
     2.169    35.750     0.200
     2.307    38.680     0.200
     2.259    38.422     0.200
     2.259    38.195     0.200
     2.312    39.180     0.200
     2.312    39.336     0.200
     2.422    39.188     0.200
     2.435    39.930     0.200
     2.435    40.680     0.200
     2.369    39.797     0.200
     2.369    39.453     0.200
     2.446    40.391     0.200
     2.550    41.633     0.200
     2.601    41.562     0.200
     2.601    42.227     0.200
     2.758    44.547     0.200
     2.758    44.398     0.200
     2.732    44.742     0.200
     2.833    45.328     0.200
     2.833    45.883     0.200
     2.831    46.461     0.200
     2.831    46.281     0.200
     2.998    48.688     0.200
     2.998    48.875     0.200
     3.063    47.641     0.200
     3.067    48.562     0.200
     3.089    48.844     0.200
     3.013    47.008     0.200
     3.013    47.133     0.200
     3.192    49.836     0.200
     3.211    51.062     0.200
     3.211    51.414     0.200
     3.360    52.547     0.200
     3.360    53.031     0.200
     3.368    52.938     0.200
     3.368    53.320     0.200
     3.235    50.789     0.200
     3.388    52.930     0.200
     3.331    52.469     0.200
     3.331    52.570     0.200
     3.370    52.297     0.200
     3.370    51.961     0.200
     3.457    53.086     0.200
     3.729    57.758     0.200
     3.729    57.938     0.200
     3.781    60.039     0.200
     3.781    60.156     0.200
     3.825    59.703     0.200
     3.880    60.797     0.200
     3.880    60.977     0.200
     3.773    60.430     0.200
     3.958    60.117     0.200
     3.928    59.789     0.200
     3.928    60.344     0.200
     3.855    60.117     0.200
     3.915    59.367     0.200
     3.915    59.766     0.200
     4.059    61.672     0.200
     4.116    62.711     0.200
     4.116    63.164     0.200
     4.281    65.727     0.200
     4.320    66.117     0.200
     4.320    65.703     0.200
     4.313    66.969     0.200
     4.313    67.234     0.200
     4.336    65.602     0.200
     4.520    67.641     0.200
     4.520    68.250     0.200
     4.420    66.609     0.200
     4.420    66.750     0.200
     4.560    68.953     0.200
     4.597    69.820     0.200
     4.641    72.008     0.200
     4.708    71.562     0.200
     4.669    71.781     0.200
     4.669    71.609     0.200
     5.044    76.961     0.200
     5.166    77.477     0.200
     5.166    78.367     0.200
     5.183    77.531     0.200
     5.183    78.586     0.200
     5.212    78.070     0.200
     5.249    80.336     0.200
     5.249    80.562     0.200
     5.270    80.188     0.200
     5.270    79.742     0.200
     5.299    78.938     0.200
     5.382    81.148     0.200
     5.450    83.008     0.200
     5.610    84.359     0.200
     5.610    84.672     0.200
     5.702    84.797     0.200
     5.702    83.062     0.200
     5.838    89.008     0.200
     5.919    88.203     0.200
     5.989    87.758     0.200
     6.032    90.258     0.200
     6.032    90.664     0.200
     6.070    90.211     0.200
     6.070    90.617     0.200
     6.106    91.086     0.200
     6.106    91.398     0.200
     6.135    91.000     0.200
     6.332    93.406     0.200
     6.377    94.648     0.200
     6.566    96.891     0.200
     6.607    98.148     0.200
     6.622    98.430     0.200
     6.700    98.500     0.200
     6.739    98.852     0.200
     6.799   100.578     0.200
     6.794   100.000     0.200
     6.891   100.617     0.200
     6.967   101.992     0.200
     7.147   102.828     0.200
     7.147   104.109     0.200
     7.265   107.148     0.200
     7.417   108.391     0.200
     7.444   109.250     0.200
     7.584   111.242     0.200
     7.740   110.867     0.200
     7.842   113.328     0.200
     7.941   114.453     0.200
     8.366   121.617     0.200
     8.438   122.617     0.200
     8.548   123.742     0.200
     8.644   124.836     0.200
     8.737   125.656     0.200
     8.801   127.008     0.200
     1.714    29.641     0.200
     1.739    30.195     0.200
     1.748    30.328     0.200
     1.777    31.180     0.200
     1.777    30.922     0.200
     1.809    31.383     0.200
     1.836    31.148     0.200
     1.859    30.945     0.200
     2.073    34.945     0.200
     2.073    35.625     0.200
     2.174    35.828     0.200
     2.254    38.297     0.200
     2.261    37.547     0.200
     2.312    38.289     0.200
     2.312    39.344     0.200
     2.364    38.820     0.200
     2.364    39.578     0.200
     2.427    39.320     0.200
     2.437    39.391     0.200
     2.555    42.086     0.200
     2.607    42.266     0.200
     2.607    42.039     0.200
     2.729    43.969     0.200
     2.729    44.906     0.200
     2.762    44.867     0.200
     2.835    46.969     0.200
     2.838    46.156     0.200
     2.827    45.164     0.200
     2.904    46.469     0.200
     2.929    48.320     0.200
     2.997    49.023     0.200
     3.007    47.844     0.200
     3.065    47.180     0.200
     3.069    47.578     0.200
     3.069    49.711     0.200
     3.095    49.180     0.200
     3.207    50.445     0.200
     3.363    53.156     0.200
     3.364    52.141     0.200
     3.364    52.406     0.200
     3.373    53.031     0.200
     3.373    53.297     0.200
     3.392    54.328     0.200
     3.779    59.984     0.200
     3.880    60.898     0.200
     4.640    72.031     0.200
     5.248    80.820     0.200
     1.470    25.055     0.200
     1.539    26.695     0.200
     1.625    28.062     0.200
     1.688    29.062     0.200
     1.823    30.492     0.200
     1.823    30.602     0.200
     1.877    31.523     0.200
     1.906    31.922     0.200
     1.906    32.844     0.200
     1.956    32.375     0.200
     1.984    33.000     0.200
     2.011    33.805     0.200
     2.011    33.703     0.200
     2.098    34.477     0.200
     2.277    36.742     0.200
     2.273    37.023     0.200
     2.268    36.773     0.200
     2.344    38.375     0.200
     2.344    37.672     0.200
     2.436    39.414     0.200
     2.506    40.570     0.200
     2.506    40.156     0.200
     2.544    41.516     0.200
     2.613    41.461     0.200
     2.643    41.922     0.200
     2.693    42.359     0.200
     2.716    42.555     0.200
     2.755    43.547     0.200
     2.809    44.461     0.200
     2.845    44.703     0.200
     2.812    44.414     0.200
     3.102    48.445     0.200
     3.190    49.977     0.200
     3.190    49.875     0.200
     3.218    50.180     0.200
     3.337    50.727     0.200
     3.624    55.984     0.200
     3.660    56.812     0.200
     3.687    57.930     0.200
     4.006    61.180     0.200
     4.108    62.703     0.200
     4.110    62.273     0.200
     4.375    66.180     0.200
     4.666    70.203     0.200
     4.812    72.555     0.200
     5.757    84.477     0.200
     6.262    93.016     0.200
     6.282    92.656     0.200
     7.318   106.656     0.200
     1.779    30.825     0.200
     1.860    32.345     0.200
     1.920    32.285     0.200
     1.885    32.995     0.200
     2.025    35.585     0.200
     2.071    34.275     0.200
     2.042    35.475     0.200
     2.089    35.345     0.200
     2.185    36.295     0.200
     2.174    38.105     0.200
     2.323    37.995     0.200
     2.372    39.465     0.200
     2.387    39.215     0.200
     2.557    42.285     0.200
     2.752    44.495     0.200
     2.810    45.585     0.200
     2.783    45.405     0.200
     2.816    45.345     0.200
     2.864    45.815     0.200
     2.836    45.585     0.200
     2.919    47.225     0.200
     2.969    47.685     0.200
     2.950    48.045     0.200
     2.950    47.665     0.200
     2.956    48.165     0.200
     2.984    46.765     0.200
     3.012    47.665     0.200
     2.983    48.115     0.200
     3.206    50.845     0.200
     3.396    53.765     0.200
     3.396    53.875     0.200
     3.484    55.845     0.200
     3.539    56.205     0.200
     3.879    60.255     0.200
     5.045    77.185     0.200
     7.444   109.095     0.200
     1.795    31.562     0.200
     1.799    31.699     0.200
     2.128    36.633     0.200
     2.263    38.391     0.200
     2.357    39.801     0.200
     2.348    39.223     0.200
     3.219    52.242     0.200
     3.824    60.551     0.200
     3.932    61.539     0.200
     4.681    72.723     0.200
     5.292    81.582     0.200
     1.774    30.477     0.200
     1.782    31.337     0.200
     1.825    30.967     0.200
     1.841    32.187     0.200
     1.957    33.947     0.200
     2.291    38.617     0.200
     2.265    38.007     0.200
     3.131    49.437     0.200
     3.210    51.257     0.200
     3.909    60.847     0.200
     4.045    62.637     0.200
     4.279    65.557     0.200
     4.756    72.257     0.200
     6.220    92.227     0.200
     1.819    31.172     0.200
     1.819    31.242     0.200
     1.921    33.430     0.200
     1.937    32.836     0.200
     2.009    34.492     0.200
     2.182    35.930     0.200
     2.153    37.648     0.200
     2.351    38.188     0.200
     2.405    39.289     0.200
     2.479    41.898     0.200
     2.454    40.203     0.200
     2.785    46.117     0.200
     2.991    46.977     0.200
     3.147    50.398     0.200
     3.155    49.508     0.200
     3.292    52.492     0.200
     3.635    58.422     0.200
     3.743    59.219     0.200
     3.777    59.242     0.200
     3.890    59.789     0.200
     4.038    63.219     0.200
     4.055    63.586     0.200
     4.901    74.891     0.200
     5.237    80.672     0.200
     1.523    26.064     0.200
     1.593    27.324     0.200
     1.713    29.096     0.200
     1.934    31.904     0.200
     1.981    33.145     0.200
     2.070    34.666     0.200
     2.327    37.086     0.200
     2.390    37.715     0.200
     2.410    39.154     0.200
     2.417    38.195     0.200
     2.711    42.805     0.200
     3.009    46.916     0.200
     3.055    48.615     0.200
     3.331    51.945     0.200
     3.323    51.445     0.200
     5.658    84.314     0.200
     5.658    84.545     0.200
     1.745    30.402     0.200
     1.814    30.863     0.200
     1.854    31.965     0.200
     1.854    31.594     0.200
     1.934    32.762     0.200
     1.938    32.992     0.200
     1.955    33.254     0.200
     2.155    36.262     0.200
     2.183    36.254     0.200
     2.188    36.953     0.200
     2.187    37.395     0.200
     2.167    36.754     0.200
     2.284    38.043     0.200
     2.324    39.074     0.200
     2.324    38.871     0.200
     2.423    40.262     0.200
     2.516    40.832     0.200
     2.539    41.555     0.200
     2.558    42.172     0.200
     2.637    42.453     0.200
     2.682    42.871     0.200
     2.706    44.441     0.200
     2.793    45.363     0.200
     2.793    45.113     0.200
     2.883    46.363     0.200
     2.949    47.152     0.200
     3.179    49.453     0.200
     3.183    50.371     0.200
     3.187    50.031     0.200
     3.173    50.203     0.200
     3.296    51.273     0.200
     3.478    54.793     0.200
     3.484    54.883     0.200
     3.513    55.262     0.200
     3.542    55.484     0.200
     3.635    57.914     0.200
     3.650    58.121     0.200
     3.730    59.434     0.200
     3.886    61.273     0.200
     3.886    62.203     0.200
     3.980    62.102     0.200
     3.980    62.574     0.200
     4.183    64.012     0.200
     4.183    64.172     0.200
     4.227    65.004     0.200
     4.623    70.805     0.200
     4.668    71.332     0.200
     4.715    71.824     0.200
     4.820    72.922     0.200
     4.928    74.723     0.200
     5.100    77.645     0.200
     5.100    76.984     0.200
     5.162    77.484     0.200
     5.180    77.742     0.200
     5.305    79.703     0.200
     5.388    79.723     0.200
     5.571    83.273     0.200
     5.826    86.715     0.200
     5.826    85.043     0.200
     5.826    86.715     0.200
     6.178    91.543     0.200
     6.235    92.555     0.200
     6.808   100.203     0.200
     7.195   104.012     0.200
     7.195   103.402     0.200
     7.332   106.332     0.200
     7.482   109.242     0.200
     7.701   112.371     0.200
     8.010   116.133     0.200
     8.595   123.734     0.200
     8.626   124.242     0.200
     8.626   125.273     0.200
     8.768   127.145     0.200
     9.660   138.973     0.200
    10.303   148.031     0.200
    12.139   172.566     0.200
    12.195   174.094     0.200
     1.751    30.430     0.200
     1.820    31.492     0.200
     1.860    31.641     0.200
     1.944    32.730     0.200
     1.944    33.070     0.200
     1.941    33.012     0.200
     1.962    33.043     0.200
     1.962    33.293     0.200
     2.161    36.371     0.200
     2.194    37.691     0.200
     2.194    37.613     0.200
     2.291    38.301     0.200
     2.319    39.301     0.200
     2.319    39.102     0.200
     2.428    40.453     0.200
     2.545    41.863     0.200
     2.563    42.570     0.200
     2.688    43.090     0.200
     2.700    44.672     0.200
     2.787    45.133     0.200
     2.787    44.902     0.200
     2.956    47.652     0.200
     3.187    50.762     0.200
     3.191    50.242     0.200
     3.303    52.402     0.200
     3.484    54.770     0.200
     3.489    54.730     0.200
     3.982    62.512     0.200
     4.140    63.930     0.200
     4.188    64.363     0.200
     4.234    65.082     0.200
     4.630    71.680     0.200
     4.675    71.301     0.200
     4.721    71.793     0.200
     4.825    73.340     0.200
     4.935    74.750     0.200
     5.093    76.516     0.200
     5.832    87.109     0.200
     7.200   104.059     0.200
     8.627   125.543     0.200
    12.134   172.641     0.200
     1.918    32.992     0.200
     1.918    32.371     0.200
     1.929    33.232     0.200
     1.993    34.422     0.200
     2.020    34.191     0.200
     2.192    38.643     0.200
     2.272    38.342     0.200
     2.303    39.881     0.200
     2.335    38.902     0.200
     2.421    40.482     0.200
     2.409    40.502     0.200
     2.454    40.691     0.200
     2.471    41.301     0.200
     2.471    40.682     0.200
     2.617    43.502     0.200
     2.683    45.031     0.200
     2.941    48.092     0.200
     2.944    48.201     0.200
     2.955    46.912     0.200
     2.976    46.861     0.200
     3.059    48.422     0.200
     3.059    48.592     0.200
     3.220    51.861     0.200
     3.248    51.371     0.200
     3.385    53.621     0.200
     3.440    54.402     0.200
     3.796    60.473     0.200
     3.811    59.232     0.200
     3.800    59.172     0.200
     3.800    59.881     0.200
     3.923    60.812     0.200
     3.923    61.941     0.200
     3.967    61.881     0.200
     4.133    64.832     0.200
     4.187    65.102     0.200
     4.376    67.893     0.200
     4.412    67.781     0.200
     4.446    68.412     0.200
     4.674    71.973     0.200
     5.047    76.461     0.200
     5.339    80.652     0.200
     5.398    82.352     0.200
     5.720    86.322     0.200
     5.925    88.922     0.200
     7.501   110.322     0.200
     8.496   124.402     0.200
     1.517    26.492     0.200
     1.545    26.422     0.200
     1.633    28.090     0.200
     1.673    28.340     0.200
     1.682    28.723     0.200
     1.825    30.609     0.200
     1.825    30.930     0.200
     1.867    30.980     0.200
     1.881    31.691     0.200
     1.928    32.562     0.200
     1.928    33.082     0.200
     1.954    32.281     0.200
     2.016    34.262     0.200
     2.016    33.980     0.200
     2.030    34.223     0.200
     2.057    34.062     0.200
     2.073    34.062     0.200
     2.063    34.312     0.200
     2.048    33.621     0.200
     2.268    36.590     0.200
     2.291    37.141     0.200
     2.350    38.051     0.200
     2.350    38.250     0.200
     2.438    39.332     0.200
     2.595    41.891     0.200
     2.595    41.781     0.200
     2.533    41.371     0.200
     2.696    43.320     0.200
     2.642    41.531     0.200
     2.642    41.871     0.200
     2.733    43.543     0.200
     2.747    44.000     0.200
     2.801    44.402     0.200
     2.825    44.223     0.200
     3.105    49.250     0.200
     3.117    49.922     0.200
     3.211    51.371     0.200
     3.294    51.520     0.200
     3.361    53.352     0.200
     3.483    54.102     0.200
     3.624    56.191     0.200
     3.680    57.633     0.200
     3.999    61.473     0.200
     4.097    61.980     0.200
     4.134    62.793     0.200
     4.134    63.621     0.200
     4.596    69.082     0.200
     4.619    69.270     0.200
     4.694    70.520     0.200
     4.694    71.090     0.200
     4.874    72.691     0.200
     4.929    74.551     0.200
     4.995    74.109     0.200
     5.497    80.453     0.200
     2.085    36.016     0.200
     3.628    57.965     0.200
     4.445    69.574     0.200
     1.900    32.355     0.200
     1.899    32.465     0.200
     1.994    34.205     0.200
     2.005    33.495     0.200
     2.255    37.595     0.200
     2.276    38.175     0.200
     2.420    39.975     0.200
     2.466    40.535     0.200
     2.466    40.775     0.200
     2.667    44.105     0.200
     2.755    45.875     0.200
     2.950    46.935     0.200
     2.913    46.735     0.200
     2.916    47.275     0.200
     2.999    47.615     0.200
     3.038    47.795     0.200
     3.038    48.165     0.200
     3.075    48.265     0.200
     3.207    50.725     0.200
     3.155    49.515     0.200
     3.196    51.265     0.200
     3.223    51.495     0.200
     3.317    52.335     0.200
     3.413    52.735     0.200
     3.403    53.295     0.200
     3.457    54.125     0.200
     3.633    56.225     0.200
     3.664    57.445     0.200
     3.664    58.365     0.200
     3.806    58.335     0.200
     3.789    59.245     0.200
     3.767    59.475     0.200
     3.767    60.045     0.200
     3.900    59.755     0.200
     3.953    61.555     0.200
     3.943    61.305     0.200
     4.160    64.895     0.200
     4.365    67.575     0.200
     4.519    70.515     0.200
     4.546    70.025     0.200
     4.662    71.035     0.200
     4.875    74.305     0.200
     4.999    75.425     0.200
     5.021    75.455     0.200
     5.163    76.685     0.200
     5.447    82.185     0.200
     5.481    81.375     0.200
     5.577    82.355     0.200
     5.542    83.205     0.200
     5.706    86.055     0.200
     5.913    88.525     0.200
     5.982    88.905     0.200
     6.580    96.865     0.200
     2.403    40.266     0.200
     2.947    46.965     0.200
     3.868    60.625     0.200
     4.635    70.605     0.200
     4.693    71.895     0.200
     2.042    34.745     0.200
     2.394    40.245     0.200
     4.688    71.676     0.200
     1.722    29.227     0.200
     1.722    30.195     0.200
     1.659    29.105     0.200
     1.780    30.047     0.200
     1.780    30.188     0.200
     1.780    31.066     0.200
     1.845    30.758     0.200
     1.880    32.316     0.200
     1.915    33.105     0.200
     1.943    32.469     0.200
     1.962    33.086     0.200
     2.161    36.625     0.200
     2.163    36.137     0.200
     2.252    37.598     0.200
     2.252    37.969     0.200
     2.334    38.406     0.200
     2.393    39.426     0.200
     2.486    40.355     0.200
     2.594    41.406     0.200
     2.632    42.246     0.200
     2.669    42.617     0.200
     2.687    43.406     0.200
     2.751    44.625     0.200
     2.751    44.059     0.200
     3.002    47.559     0.200
     2.940    45.969     0.200
     3.068    49.355     0.200
     3.179    49.316     0.200
     3.515    54.098     0.200
     3.535    55.258     0.200
     3.566    56.387     0.200
     3.745    58.336     0.200
     3.982    61.078     0.200
     4.117    63.238     0.200
     4.260    64.418     0.200
     4.482    66.957     0.200
     4.553    68.297     0.200
     4.772    72.027     0.200
     4.774    72.266     0.200
     4.959    75.445     0.200
     5.183    77.207     0.200
     1.477    25.504     0.200
     1.477    25.285     0.200
     1.526    26.477     0.200
     1.536    26.504     0.200
     1.535    26.395     0.200
     1.606    27.594     0.200
     1.712    29.035     0.200
     1.719    29.117     0.200
     1.724    29.164     0.200
     1.734    29.387     0.200
     1.934    32.086     0.200
     1.961    32.387     0.200
     1.888    32.055     0.200
     2.008    33.805     0.200
     2.007    33.906     0.200
     2.090    33.527     0.200
     2.295    36.426     0.200
     2.350    37.785     0.200
     2.416    37.656     0.200
     2.463    38.945     0.200
     2.385    39.266     0.200
     2.453    39.445     0.200
     2.534    40.656     0.200
     2.758    44.125     0.200
     2.861    45.266     0.200
     2.959    46.266     0.200
     3.085    48.406     0.200
     3.101    48.445     0.200
     3.101    47.438     0.200
     3.274    51.086     0.200
     3.321    51.867     0.200
     3.341    51.254     0.200
     3.382    51.875     0.200
     3.658    55.125     0.200
     3.782    56.445     0.200
     3.749    57.367     0.200
     3.822    58.836     0.200
     3.925    59.016     0.200
     3.973    61.254     0.200
     4.026    60.746     0.200
     4.065    61.816     0.200
     4.065    61.164     0.200
     4.258    63.266     0.200
     4.333    65.047     0.200
     4.335    64.688     0.200
     4.463    66.426     0.200
     4.528    67.945     0.200
     4.657    69.496     0.200
     4.841    73.145     0.200
     4.964    73.246     0.200
     5.167    75.555     0.200
     5.201    76.957     0.200
     5.396    80.234     0.200
     5.427    80.137     0.200
     5.455    79.586     0.200
     5.782    87.164     0.200
     5.856    84.336     0.200
     2.021    34.422     0.200
     2.063    35.570     0.200
     2.032    36.383     0.200
     2.384    41.156     0.200
     2.416    42.477     0.200
     2.794    45.266     0.200
     2.889    46.445     0.200
     2.948    47.719     0.200
     3.043    48.508     0.200
     3.059    47.422     0.200
     3.053    48.859     0.200
     3.326    52.992     0.200
     3.419    55.422     0.200
     3.883    61.578     0.200
     4.074    63.180     0.200
     4.007    62.398     0.200
     4.336    66.312     0.200
     4.476    68.883     0.200
     4.517    69.180     0.200
     4.674    71.711     0.200
     4.684    71.852     0.200
     5.129    77.617     0.200
     1.916    32.863     0.200
     1.921    32.977     0.200
     2.168    37.633     0.200
     2.185    37.945     0.200
     2.265    37.535     0.200
     2.334    39.883     0.200
     2.334    39.633     0.200
     2.406    41.516     0.200
     2.519    40.914     0.200
     2.539    41.555     0.200
     2.726    44.754     0.200
     2.813    45.805     0.200
     2.813    45.945     0.200
     2.930    48.195     0.200
     3.025    49.594     0.200
     3.162    50.543     0.200
     3.176    51.625     0.200
     3.459    54.945     0.200
     3.494    55.824     0.200
     3.526    54.426     0.200
     3.966    62.824     0.200
     3.966    62.324     0.200
     4.164    64.543     0.200
     4.208    65.785     0.200
     4.424    69.684     0.200
     4.441    67.605     0.200
     4.605    71.555     0.200
     4.650    71.824     0.200
     4.695    72.184     0.200
     4.747    74.664     0.200
     4.802    73.855     0.200
     4.910    75.516     0.200
     4.960    76.676     0.200
     5.163    78.074     0.200
     5.598    84.383     0.200
     3.165    50.656     0.200
     1.751    29.984     0.200
     1.801    30.703     0.200
     1.801    30.719     0.200
     1.894    32.305     0.200
     1.932    33.516     0.200
     1.932    33.266     0.200
     2.015    34.320     0.200
     2.088    35.359     0.200
     2.266    37.766     0.200
     2.265    37.852     0.200
     2.258    37.883     0.200
     2.262    37.398     0.200
     2.364    38.812     0.200
     2.619    42.914     0.200
     2.618    42.500     0.200
     2.635    43.883     0.200
     2.714    44.289     0.200
     2.714    43.023     0.200
     3.376    52.531     0.200
     3.558    55.062     0.200
     3.581    54.914     0.200
     3.576    56.422     0.200
     3.639    56.680     0.200
     4.011    62.102     0.200
     4.011    62.469     0.200
     4.247    66.562     0.200
     4.247    64.781     0.200
     4.307    66.242     0.200
     4.505    68.312     0.200
     4.749    71.773     0.200
     4.806    72.461     0.200
     4.806    73.422     0.200
     3.238    50.461     0.200
     1.759    30.141     0.200
     1.759    30.281     0.200
     1.808    30.812     0.200
     1.809    30.312     0.200
     1.810    31.422     0.200
     1.903    32.414     0.200
     1.939    33.062     0.200
     1.939    33.422     0.200
     2.023    34.164     0.200
     2.079    36.094     0.200
     2.273    37.391     0.200
     2.273    38.078     0.200
     2.267    37.406     0.200
     2.253    37.445     0.200
     2.371    39.133     0.200
     2.624    42.805     0.200
     2.626    42.844     0.200
     2.630    42.625     0.200
     2.706    44.727     0.200
     2.706    43.016     0.200
     2.839    44.594     0.200
     3.246    52.547     0.200
     3.566    55.023     0.200
     3.569    56.992     0.200
     4.012    62.117     0.200
     4.252    65.508     0.200
     4.252    64.352     0.200
     4.315    65.875     0.200
     4.808    72.188     0.200
     4.808    73.258     0.200
     5.017    75.328     0.200
     3.241    49.906     0.200
     1.999    34.227     0.200
     2.102    35.562     0.200
     2.122    34.969     0.200
     2.175    36.773     0.200
     2.129    37.516     0.200
     2.282    38.445     0.200
     2.364    38.680     0.200
     2.521    41.273     0.200
     2.587    42.469     0.200
     2.897    47.984     0.200
     2.960    47.117     0.200
     2.978    47.359     0.200
     3.114    49.477     0.200
     3.179    51.125     0.200
     3.217    50.398     0.200
     3.479    55.383     0.200
     3.882    59.383     0.200
     3.912    60.133     0.200
     4.528    68.938     0.200
    15.365   216.258     0.200
    15.423   220.047     0.200
    15.433   218.703     0.200
    15.576   220.055     0.200
    15.996   225.039     0.200
    16.205   227.578     0.200
    16.545   233.375     0.200
     1.256    24.172     0.200
     2.282    38.828     0.200
     2.282    38.969     0.200
     2.282    38.688     0.200
     2.978    47.773     0.200
     2.978    47.883     0.200
     3.988    62.383     0.200
     5.207    78.688     0.200
     5.471    82.094     0.200
     6.586    98.305     0.200
     6.702   102.109     0.200
     6.956   105.188     0.200
     7.247   107.883     0.200
     7.247   108.156     0.200
     7.862   116.883     0.200
     8.242   122.484     0.200
     8.322   124.289     0.200
     8.341   123.414     0.200
     8.341   122.992     0.200
     8.634   127.492     0.200
    10.359   151.180     0.200
    12.631   181.438     0.200
    12.937   187.477     0.200
    13.842   198.055     0.200
    13.933   200.977     0.200
    13.985   200.695     0.200
    15.365   218.602     0.200
    15.921   224.945     0.200
    15.996   225.203     0.200
    16.193   228.961     0.200
     1.926    33.141     0.200
     1.961    33.742     0.200
     2.726    46.016     0.200
     2.862    47.570     0.200
     3.166    50.141     0.200
     3.407    54.398     0.200
     3.774    59.828     0.200
     3.787    59.211     0.200
     3.768    58.820     0.200
     4.022    62.211     0.200
     4.011    62.477     0.200
     4.266    65.500     0.200
     4.573    69.742     0.200
     4.865    74.141     0.200
     5.029    74.758     0.200
     5.093    77.930     0.200
     5.379    80.469     0.200
     5.901    88.906     0.200
     6.190    92.789     0.200
     6.191    91.898     0.200
     6.622    99.766     0.200
     7.265   106.477     0.200
     7.366   108.070     0.200
     7.928   115.570     0.200
     8.421   122.547     0.200
     9.430   138.211     0.200
     9.529   139.812     0.200
    11.297   161.656     0.200
    12.714   180.641     0.200
    12.906   184.406     0.200
    15.332   218.336     0.200
    16.018   224.117     0.200
     7.265   106.688     0.200
     1.825    33.328     0.200
     1.881    33.594     0.200
     1.924    34.195     0.200
     2.001    35.273     0.200
     2.277    39.109     0.200
     2.367    40.273     0.200
     2.526    41.914     0.200
     2.591    43.125     0.200
     2.629    44.797     0.200
     3.118    49.406     0.200
     3.182    51.562     0.200
     3.216    52.766     0.200
     3.987    61.305     0.200
     3.911    62.266     0.200
     4.530    70.367     0.200
     4.989    75.219     0.200
     5.033    76.953     0.200
     6.586    97.688     0.200
     6.770    98.453     0.200
     7.337   108.492     0.200
    16.001   223.844     0.200
     1.935    34.023     0.200
     2.119    36.227     0.200
     2.190    37.266     0.200
     2.148    38.195     0.200
     2.385    40.906     0.200
     2.535    41.680     0.200
     2.603    42.984     0.200
     2.650    44.227     0.200
     3.131    50.047     0.200
     3.199    50.820     0.200
     3.238    52.711     0.200
     3.508    55.250     0.200
     3.998    61.273     0.200
     3.933    62.320     0.200
     4.187    65.406     0.200
     5.000    74.930     0.200
     5.843    90.023     0.200
     5.850    87.977     0.200
     6.145    92.773     0.200
     6.835   101.406     0.200
     7.259   107.070     0.200
     7.346   108.062     0.200
     8.276   120.555     0.200
     9.351   136.625     0.200
    10.255   148.305     0.200
    11.289   162.641     0.200
     1.957    34.602     0.200
     1.943    35.641     0.200
     2.054    36.125     0.200
     2.030    34.789     0.200
     2.405    40.102     0.200
     2.439    41.648     0.200
     2.420    41.531     0.200
     2.612    43.797     0.200
     3.011    49.688     0.200
     3.142    50.875     0.200
     3.340    52.781     0.200
     3.313    54.680     0.200
     3.495    54.305     0.200
     3.617    56.008     0.200
     3.533    56.445     0.200
     3.640    58.078     0.200
     3.708    59.016     0.200
     3.845    59.688     0.200
     3.881    60.672     0.200
     3.965    62.531     0.200
     4.323    67.000     0.200
     4.669    72.570     0.200
     4.830    74.445     0.200
     4.875    75.805     0.200
     5.155    78.539     0.200
     5.611    83.297     0.200
     5.625    86.211     0.200
     7.148   104.797     0.200
     7.201   106.328     0.200
     8.154   119.367     0.200
     9.395   136.422     0.200
    10.210   147.781     0.200
    10.560   152.336     0.200
    10.865   157.586     0.200
    15.885   223.867     0.200
     1.880    32.469     0.200
     1.931    34.047     0.200
     2.053    35.773     0.200
     2.156    36.797     0.200
     2.178    37.359     0.200
     2.227    37.734     0.200
     2.232    38.188     0.200
     2.419    41.117     0.200
     2.571    41.898     0.200
     2.641    43.195     0.200
     2.832    45.898     0.200
     3.168    50.266     0.200
     3.235    51.727     0.200
     3.260    53.195     0.200
     3.389    53.523     0.200
     4.035    61.867     0.200
     5.075    77.875     0.200
     6.538    96.555     0.200
     8.313   121.500     0.200
     8.456   122.695     0.200
     8.579   124.820     0.200
     9.625   138.945     0.200
    10.292   148.195     0.200
     2.005    35.289     0.200
     2.054    35.789     0.200
     2.138    37.195     0.200
     2.356    39.539     0.200
     2.394    39.719     0.200
     2.414    40.758     0.200
     2.457    41.531     0.200
     2.550    43.234     0.200
     2.614    45.250     0.200
     2.712    45.102     0.200
     2.913    47.828     0.200
     2.962    47.945     0.200
     3.010    49.727     0.200
     3.110    51.117     0.200
     3.172    51.680     0.200
     3.296    52.750     0.200
     3.272    53.148     0.200
     3.445    54.016     0.200
     3.539    55.484     0.200
     3.628    57.867     0.200
     3.709    59.188     0.200
     3.799    58.984     0.200
     3.851    61.438     0.200
     3.968    62.695     0.200
     3.988    62.766     0.200
     4.300    67.219     0.200
     4.307    68.758     0.200
     4.832    74.484     0.200
     4.908    75.789     0.200
     5.137    79.695     0.200
     5.899    89.617     0.200
     6.448    97.031     0.200
     6.732    97.984     0.200
     8.120   120.328     0.200
     9.143   135.180     0.200
     9.251   136.164     0.200
     1.930    33.641     0.200
     1.915    32.641     0.200
     2.023    35.297     0.200
     1.964    34.930     0.200
     2.037    36.086     0.200
     2.155    36.148     0.200
     2.373    39.625     0.200
     2.413    40.859     0.200
     2.426    41.969     0.200
     2.439    40.867     0.200
     2.609    45.227     0.200
     2.719    45.391     0.200
     2.932    47.195     0.200
     2.980    48.102     0.200
     3.021    49.977     0.200
     3.145    52.617     0.200
     3.160    52.570     0.200
     3.190    50.992     0.200
     3.314    52.312     0.200
     3.291    52.891     0.200
     3.596    56.336     0.200
     3.524    56.008     0.200
     3.562    57.117     0.200
     3.641    58.172     0.200
     3.719    59.477     0.200
     3.817    58.781     0.200
     3.868    60.922     0.200
     3.978    63.047     0.200
     4.039    63.109     0.200
     3.999    63.656     0.200
     4.113    64.211     0.200
     4.069    65.227     0.200
     4.091    64.672     0.200
     4.089    63.875     0.200
     4.202    65.047     0.200
     4.187    65.820     0.200
     4.305    65.719     0.200
     4.321    66.906     0.200
     4.316    66.992     0.200
     4.319    68.445     0.200
     4.407    68.828     0.200
     4.409    69.500     0.200
     4.421    69.422     0.200
     4.588    70.992     0.200
     4.652    72.766     0.200
     4.811    72.328     0.200
     4.892    75.398     0.200
     4.842    74.516     0.200
     4.906    76.102     0.200
     5.143    77.477     0.200
     5.114    77.828     0.200
     5.152    79.375     0.200
     5.354    82.578     0.200
     5.366    81.367     0.200
     5.512    83.328     0.200
     5.584    82.969     0.200
     5.544    83.656     0.200
     5.614    86.125     0.200
     5.646    86.281     0.200
     5.654    86.641     0.200
     5.781    86.680     0.200
     5.927    89.750     0.200
     5.912    89.578     0.200
     6.320    95.508     0.200
     6.345    95.750     0.200
     6.391    94.812     0.200
     6.409    96.125     0.200
     6.469    97.609     0.200
     6.588    97.625     0.200
     6.530    98.508     0.200
     6.793   101.656     0.200
     7.115   104.211     0.200
     7.172   106.031     0.200
     7.260   108.500     0.200
     7.242   107.922     0.200
     7.602   111.672     0.200
     7.702   112.625     0.200
     7.913   115.516     0.200
     8.253   120.562     0.200
     8.323   122.438     0.200
     9.151   135.742     0.200
     9.225   136.312     0.200
     9.286   137.766     0.200
     9.582   138.625     0.200
    10.050   145.117     0.200
    10.301   151.219     0.200
    10.544   151.758     0.200
    10.840   156.070     0.200
    11.140   159.922     0.200
    11.099   161.430     0.200
    12.421   178.086     0.200
     1.917    33.211     0.200
     2.011    34.930     0.200
     2.144    35.469     0.200
     2.048    34.594     0.200
     2.361    39.703     0.200
     2.400    39.711     0.200
     2.419    41.461     0.200
     2.599    44.164     0.200
     2.451    41.289     0.200
     2.715    45.281     0.200
     2.919    45.836     0.200
     2.968    47.086     0.200
     3.014    48.234     0.200
     3.302    51.773     0.200
     3.168    50.859     0.200
     3.278    51.289     0.200
     3.584    55.219     0.200
     3.633    56.469     0.200
     3.534    55.430     0.200
     3.563    57.141     0.200
     3.805    58.242     0.200
     3.712    58.703     0.200
     3.857    59.766     0.200
     3.972    61.562     0.200
     3.992    62.641     0.200
     4.101    63.375     0.200
     4.190    64.031     0.200
     4.097    64.609     0.200
     4.293    65.750     0.200
     4.310    66.742     0.200
     4.311    67.898     0.200
     4.397    68.062     0.200
     4.577    70.422     0.200
     4.640    71.133     0.200
     4.880    74.039     0.200
     4.836    72.812     0.200
     4.908    74.602     0.200
     5.142    78.383     0.200
     5.344    82.148     0.200
     5.504    82.492     0.200
     5.602    85.562     0.200
     5.640    85.352     0.200
     5.904    87.930     0.200
     6.334    95.719     0.200
     7.104   104.031     0.200
     7.239   106.570     0.200
     7.900   115.086     0.200
     8.314   121.273     0.200
     9.146   134.273     0.200
    10.293   150.266     0.200
    10.365   151.234     0.200
     1.938    34.047     0.200
     1.867    33.703     0.200
     2.028    33.945     0.200
     2.290    38.344     0.200
     2.311    38.039     0.200
     2.304    39.367     0.200
     2.641    43.547     0.200
     2.537    41.406     0.200
     2.824    44.875     0.200
     2.861    45.680     0.200
     3.210    49.375     0.200
     3.179    50.414     0.200
     3.482    54.617     0.200
     3.495    56.039     0.200
     3.601    57.219     0.200
     3.720    57.828     0.200
     3.743    58.828     0.200
     3.863    60.734     0.200
     4.089    62.945     0.200
     4.184    64.484     0.200
     4.197    64.859     0.200
     4.188    65.055     0.200
     4.776    72.883     0.200
     4.758    72.484     0.200
     4.725    72.828     0.200
     5.487    83.578     0.200
     5.718    86.359     0.200
     6.040    90.000     0.200
     6.239    93.047     0.200
     7.038   103.328     0.200
     9.937   143.586     0.200
     1.917    33.125     0.200
     2.010    35.453     0.200
     1.965    35.430     0.200
     2.046    35.594     0.200
     2.146    36.016     0.200
     2.360    39.078     0.200
     2.400    39.289     0.200
     2.423    41.539     0.200
     2.558    43.766     0.200
     2.602    44.367     0.200
     2.719    45.156     0.200
     2.722    46.633     0.200
     2.920    46.359     0.200
     2.969    47.688     0.200
     3.018    49.164     0.200
     3.118    51.227     0.200
     3.137    52.609     0.200
     3.164    51.742     0.200
     3.302    52.492     0.200
     3.279    52.125     0.200
     3.449    53.625     0.200
     3.636    58.188     0.200
     3.717    58.648     0.200
     3.804    58.188     0.200
     3.859    60.148     0.200
     3.976    62.695     0.200
     3.996    61.562     0.200
     4.029    62.859     0.200
     4.191    63.844     0.200
     4.191    66.977     0.200
     4.294    66.516     0.200
     4.312    66.805     0.200
     4.309    66.703     0.200
     4.406    69.594     0.200
     4.642    72.227     0.200
     4.799    71.797     0.200
     4.840    73.586     0.200
     4.881    74.336     0.200
     4.912    75.109     0.200
     5.131    77.758     0.200
     5.145    79.414     0.200
     5.348    81.844     0.200
     5.363    80.562     0.200
     5.363    80.055     0.200
     5.507    84.047     0.200
     5.572    82.289     0.200
     5.605    84.773     0.200
     5.778    86.617     0.200
     5.916    88.625     0.200
     5.907    88.984     0.200
     6.083    91.227     0.200
     6.147    92.078     0.200
     6.336    95.094     0.200
     6.530    97.977     0.200
     6.592    99.047     0.200
     6.628    99.219     0.200
     6.756   100.703     0.200
     7.102   103.836     0.200
     7.160   105.430     0.200
     7.243   107.477     0.200
     7.751   114.086     0.200
     7.827   115.117     0.200
     7.916   116.180     0.200
     7.923   116.023     0.200
     8.097   118.414     0.200
     8.100   118.359     0.200
     8.160   119.414     0.200
     8.128   120.938     0.200
     8.189   119.633     0.200
     8.195   120.180     0.200
     8.240   120.656     0.200
     8.290   121.156     0.200
     8.326   121.836     0.200
     8.317   123.969     0.200
     8.318   123.312     0.200
     8.357   121.812     0.200
     8.422   123.117     0.200
     8.493   123.797     0.200
     8.911   129.914     0.200
    10.038   145.125     0.200
    10.370   151.133     0.200
     1.932    33.539     0.200
     1.894    33.820     0.200
     2.060    35.688     0.200
     2.058    37.359     0.200
     2.142    37.070     0.200
     2.299    38.914     0.200
     2.315    39.039     0.200
     2.490    41.469     0.200
     2.544    41.867     0.200
     2.555    43.180     0.200
     2.749    46.320     0.200
     2.821    45.969     0.200
     3.067    49.031     0.200
     3.034    49.461     0.200
     3.122    49.875     0.200
     3.048    48.578     0.200
     3.143    51.484     0.200
     3.447    53.781     0.200
     3.428    54.531     0.200
     3.383    53.258     0.200
     3.618    58.188     0.200
     3.735    58.320     0.200
     3.777    59.531     0.200
     3.838    59.914     0.200
     3.944    60.156     0.200
     4.013    62.719     0.200
     3.955    61.906     0.200
     4.092    63.867     0.200
     4.062    64.609     0.200
     4.123    64.945     0.200
     4.254    65.984     0.200
     4.341    66.445     0.200
     4.448    68.547     0.200
     4.466    68.867     0.200
     4.460    68.906     0.200
     4.447    69.469     0.200
     4.547    70.555     0.200
     4.732    72.547     0.200
     4.942    74.367     0.200
     4.960    76.008     0.200
     5.033    76.648     0.200
     5.279    79.117     0.200
     5.292    79.875     0.200
     5.493    83.781     0.200
     5.490    82.297     0.200
     5.490    82.125     0.200
     5.544    82.438     0.200
     5.643    84.461     0.200
     5.672    84.359     0.200
     5.713    84.461     0.200
     5.758    86.844     0.200
     5.756    85.906     0.200
     5.905    88.000     0.200
     6.069    91.141     0.200
     6.045    89.781     0.200
     6.460    96.180     0.200
     6.489    96.984     0.200
     6.545    97.875     0.200
     6.612    97.805     0.200
     6.631   100.000     0.200
     6.660    99.305     0.200
     7.224   105.688     0.200
     7.296   107.656     0.200
     7.334   108.789     0.200
     7.395   109.719     0.200
     7.627   112.516     0.200
     7.744   113.156     0.200
     8.248   121.688     0.200
     8.373   122.430     0.200
     8.456   125.625     0.200
     9.170   133.047     0.200
     9.258   136.484     0.200
     9.366   137.828     0.200
     9.516   137.891     0.200
    10.474   153.570     0.200
    11.243   160.766     0.200
    12.124   175.156     0.200
    12.466   179.227     0.200
    17.771   247.570     0.200
     1.922    33.117     0.200
     2.050    34.717     0.200
     2.053    35.807     0.200
     2.048    36.457     0.200
     2.137    37.157     0.200
     2.289    38.387     0.200
     2.320    39.197     0.200
     2.485    41.247     0.200
     2.537    42.467     0.200
     2.544    43.097     0.200
     2.739    46.277     0.200
     2.810    46.167     0.200
     2.814    46.707     0.200
     3.060    48.907     0.200
     3.044    49.687     0.200
     3.114    49.897     0.200
     3.058    48.867     0.200
     3.132    51.167     0.200
     3.278    54.227     0.200
     3.440    53.527     0.200
     3.394    54.247     0.200
     3.421    54.017     0.200
     3.570    55.717     0.200
     3.609    58.217     0.200
     3.727    58.597     0.200
     3.766    59.717     0.200
     3.828    59.737     0.200
     3.938    60.987     0.200
     4.003    63.427     0.200
     3.966    62.037     0.200
     4.082    63.147     0.200
     4.112    64.317     0.200
     4.174    65.867     0.200
     4.246    66.047     0.200
     4.333    66.407     0.200
     4.439    68.877     0.200
     4.437    69.727     0.200
     4.450    68.967     0.200
     4.456    68.277     0.200
     4.537    70.507     0.200
     4.723    72.317     0.200
     4.787    73.907     0.200
     4.935    74.137     0.200
     4.949    75.817     0.200
     5.025    76.897     0.200
     5.272    78.637     0.200
     5.491    84.587     0.200
     5.479    81.837     0.200
     5.533    84.367     0.200
     5.632    85.747     0.200
     5.748    87.677     0.200
     5.745    87.997     0.200
     5.894    88.367     0.200
     5.976    89.777     0.200
     6.227    93.207     0.200
     6.290    93.847     0.200
     6.306    95.337     0.200
     6.469    97.477     0.200
     6.479    97.127     0.200
     6.564    98.117     0.200
     6.567    99.147     0.200
     6.602    98.207     0.200
     6.731   100.207     0.200
     6.670    99.327     0.200
     7.220   105.387     0.200
     7.290   107.367     0.200
     7.324   108.437     0.200
     7.616   112.957     0.200
     8.044   117.457     0.200
     8.281   120.987     0.200
     8.368   122.347     0.200
     8.446   125.787     0.200
     8.552   126.047     0.200
     9.331   137.717     0.200
     9.339   138.017     0.200
     9.743   143.337     0.200
    10.110   147.627     0.200
    10.180   146.847     0.200
    10.463   152.777     0.200
    15.290   216.027     0.200
    15.963   223.147     0.200
    16.173   227.907     0.200
     1.979    34.355     0.200
     1.941    35.435     0.200
     2.077    36.325     0.200
     2.015    35.315     0.200
     2.181    37.245     0.200
     2.428    40.965     0.200
     2.427    42.165     0.200
     2.461    41.405     0.200
     2.389    40.505     0.200
     2.624    45.445     0.200
     2.978    48.355     0.200
     3.017    49.125     0.200
    15.382   218.545     0.200
    15.908   223.975     0.200
    16.084   228.015     0.200
     2.389    40.705     0.200
     3.524    57.465     0.200
     5.671    84.955     0.200
     7.171   105.465     0.200
     8.224   120.565     0.200
     8.769   128.825     0.200
    10.290   152.105     0.200
    12.880   184.085     0.200
     1.924    34.146     0.200
     1.927    34.406     0.200
     2.002    34.376     0.200
     2.107    36.426     0.200
     2.180    37.506     0.200
     2.129    36.736     0.200
     2.368    39.626     0.200
     2.277    38.346     0.200
     2.525    41.676     0.200
     2.591    43.126     0.200
     2.631    44.746     0.200
     3.118    49.796     0.200
     1.868    32.183     0.200
     1.913    33.872     0.200
     1.969    34.673     0.200
     2.082    34.732     0.200
     1.876    31.661     0.200
     1.897    32.940     0.200
     1.937    35.261     0.200
     1.994    34.921     0.200
     1.877    33.094     0.200
     1.989    34.714     0.200
     2.110    36.444     0.200
     2.103    36.134     0.200
     2.114    36.354     0.200
     2.179    37.294     0.200
     2.278    38.234     0.200
     2.355    39.834     0.200
     2.525    41.204     0.200
     2.587    42.305     0.200
     2.614    43.515     0.200
     2.768    46.124     0.200
     2.808    46.814     0.200
     2.879    47.774     0.200
     2.975    48.314     0.200
     2.990    47.134     0.200
     3.112    49.074     0.200
     3.174    49.895     0.200
     3.200    50.844     0.200
     3.324    51.864     0.200
     7.254   105.604     0.200
     8.100   118.464     0.200
     8.617   126.084     0.200
    10.235   147.844     0.200
    10.452   151.124     0.200
    10.528   153.624     0.200
     1.864    32.561     0.200
     1.963    34.591     0.200
     1.920    34.701     0.200
     2.082    35.051     0.200
     2.110    37.421     0.200
     2.314    38.730     0.200
     2.346    39.541     0.200
     2.363    40.951     0.200
     2.538    44.141     0.200
     2.670    44.730     0.200
     2.863    45.711     0.200
     2.908    47.331     0.200
     2.961    48.311     0.200
     2.090    35.621     0.200
     2.109    37.501     0.200
     2.333    39.291     0.200
     2.376    39.642     0.200
     2.395    40.031     0.200
     2.453    41.161     0.200
     2.906    47.222     0.200
     2.935    47.701     0.200
     2.924    47.312     0.200
     3.560    55.892     0.200
     3.805    58.962     0.200
     1.874    31.066     0.200
     1.980    32.535     0.200
     2.332    37.236     0.200
     2.355    37.217     0.200
     2.903    45.637     0.200
     3.254    50.326     0.200
     3.222    50.266     0.200
     3.257    50.855     0.200
     3.425    52.756     0.200
     3.284    50.115     0.200
     3.525    54.045     0.200
     3.764    57.686     0.200
     3.618    55.096     0.200
     3.783    58.426     0.200
     3.882    59.955     0.200
     4.132    62.146     0.200
     4.238    64.887     0.200
     4.312    66.557     0.200
     4.819    72.355     0.200
     4.839    73.217     0.200
     5.057    75.695     0.200
     5.269    77.727     0.200
     5.415    79.746     0.200
     5.528    81.156     0.200
     5.551    83.045     0.200
     5.849    86.346     0.200
     5.777    84.236     0.200
     6.256    92.775     0.200
     6.377    93.795     0.200
     6.438    95.205     0.200
     7.080   103.217     0.200
     7.122   104.195     0.200
     7.163   104.637     0.200
     7.400   107.535     0.200
     7.509   108.865     0.200
     7.842   113.727     0.200
     8.056   116.615     0.200
     9.202   134.275     0.200
    10.277   150.455     0.200
    11.101   158.365     0.200
    12.330   176.057     0.200
     2.027    35.727     0.200
     1.951    35.707     0.200
     2.043    36.355     0.200
     2.149    36.326     0.200
     2.377    39.867     0.200
     2.414    40.707     0.200
     2.416    41.416     0.200
     2.437    41.586     0.200
     2.932    46.746     0.200
     2.978    48.367     0.200
     3.010    49.246     0.200
     3.197    50.447     0.200
     3.315    52.186     0.200
     3.290    53.266     0.200
     3.595    56.016     0.200
     3.532    55.377     0.200
     3.548    57.656     0.200
     3.707    58.967     0.200
     3.819    58.916     0.200
     3.966    62.686     0.200
     4.111    64.377     0.200
     4.302    67.275     0.200
     4.317    67.096     0.200
     4.310    67.076     0.200
     4.585    70.936     0.200
     4.812    72.525     0.200
     4.891    75.447     0.200
     4.892    76.605     0.200
     5.502    85.127     0.200
     5.586    82.877     0.200
     5.609    86.467     0.200
     5.924    89.646     0.200
     6.630    99.227     0.200
     6.948   103.916     0.200
     7.251   110.197     0.200
     9.213   136.166     0.200
    15.427   218.186     0.200
    16.066   227.207     0.200
     1.818    32.150     0.200
     1.932    34.191     0.200
     1.935    33.760     0.200
     2.007    34.961     0.200
     2.114    36.471     0.200
     2.131    36.611     0.200
     2.188    37.400     0.200
     2.269    38.141     0.200
     2.373    39.551     0.200
     2.534    41.621     0.200
     2.599    43.141     0.200
     2.633    44.041     0.200
     2.827    47.201     0.200
     2.893    46.551     0.200
     2.956    48.711     0.200
     2.971    47.301     0.200
     3.125    49.910     0.200
     3.189    50.451     0.200
     3.220    52.311     0.200
     3.306    52.100     0.200
     3.503    54.410     0.200
     3.490    55.090     0.200
     3.674    58.301     0.200
     3.798    58.521     0.200
     3.855    60.230     0.200
     3.915    61.740     0.200
     3.877    60.570     0.200
     3.995    61.391     0.200
     4.168    64.900     0.200
     4.201    64.541     0.200
     4.320    66.561     0.200
     4.404    67.461     0.200
     4.515    69.500     0.200
     4.525    70.500     0.200
     4.536    69.430     0.200
     4.536    69.510     0.200
     4.625    71.260     0.200
     4.802    73.721     0.200
     4.864    74.711     0.200
     5.002    76.740     0.200
     5.750    85.240     0.200
     5.982    89.211     0.200
     6.548    95.480     0.200
     6.581    97.281     0.200
    15.237   215.840     0.200
     1.906    33.078     0.200
     2.003    34.988     0.200
     2.122    35.469     0.200
     2.354    38.988     0.200
     2.388    39.998     0.200
     2.394    40.760     0.200
     2.576    44.619     0.200
     2.690    44.488     0.200
     2.906    46.709     0.200
     2.950    47.559     0.200
     2.989    48.869     0.200
     3.289    51.748     0.200
     3.193    52.439     0.200
     3.263    52.229     0.200
     3.223    51.068     0.200
     3.568    55.770     0.200
     3.608    57.699     0.200
     3.557    55.699     0.200
     3.687    58.488     0.200
     3.794    58.449     0.200
     3.946    62.180     0.200
     4.084    63.289     0.200
     4.174    64.590     0.200
     4.122    63.020     0.200
     4.275    66.100     0.200
     4.290    66.520     0.200
     4.284    66.449     0.200
     4.374    68.809     0.200
     4.557    70.078     0.200
     4.622    70.549     0.200
     4.786    71.828     0.200
     4.864    73.959     0.200
     4.810    73.930     0.200
     4.888    75.389     0.200
     5.116    77.498     0.200
     5.081    77.068     0.200
    16.043   228.078     0.200
     2.011    34.988     0.200
     2.114    35.758     0.200
     2.362    39.648     0.200
     2.392    40.387     0.200
     2.376    40.668     0.200
     2.668    44.676     0.200
     2.907    47.035     0.200
     2.947    48.008     0.200
     2.970    48.867     0.200
     3.292    51.727     0.200
     3.263    52.648     0.200
     3.210    52.828     0.200
     3.567    56.027     0.200
     3.593    58.066     0.200
     3.570    56.285     0.200
     3.668    58.105     0.200
     3.799    58.746     0.200
     3.926    62.148     0.200
     4.082    63.887     0.200
     4.174    64.477     0.200
     4.138    64.668     0.200
     4.271    66.016     0.200
     4.284    66.879     0.200
     4.273    66.426     0.200
     4.269    67.766     0.200
     4.238    66.406     0.200
     4.361    68.848     0.200
     4.552    69.945     0.200
     4.617    71.719     0.200
     4.789    72.078     0.200
     4.791    73.156     0.200
     4.862    74.957     0.200
     4.863    75.406     0.200
    15.452   219.809     0.200
     1.890    32.277     0.200
     1.927    34.199     0.200
     1.989    34.238     0.200
     2.106    34.816     0.200
     2.086    36.059     0.200
     2.340    38.797     0.200
     2.373    39.387     0.200
     2.380    39.969     0.200
     2.518    42.520     0.200
     2.477    40.508     0.200
     2.560    44.309     0.200
     2.679    45.000     0.200
     2.890    46.219     0.200
     2.934    47.367     0.200
     2.976    48.219     0.200
     3.593    57.848     0.200
     3.674    58.508     0.200
     3.779    58.047     0.200
     4.363    69.387     0.200
     4.605    72.027     0.200
     4.771    71.879     0.200
     4.798    73.777     0.200
     5.100    77.109     0.200
     5.067    77.297     0.200
     5.545    82.129     0.200
     5.565    84.148     0.200
     5.603    85.520     0.200
     5.864    88.367     0.200
    17.384   243.199     0.200
     2.005    34.684     0.200
     1.925    33.953     0.200
     2.106    36.984     0.200
     2.008    35.293     0.200
     2.192    37.594     0.200
     2.457    41.016     0.200
     2.424    41.863     0.200
     2.629    45.582     0.200
     2.686    44.742     0.200
     3.001    48.344     0.200
     3.035    49.312     0.200
     3.009    48.902     0.200
     3.174    52.844     0.200
     3.167    51.422     0.200
     3.168    50.215     0.200
     3.498    56.016     0.200
     3.650    58.715     0.200
     3.990    63.766     0.200
     4.403    69.363     0.200
     4.415    69.383     0.200
     4.703    73.344     0.200
     4.789    74.035     0.200
     4.952    75.766     0.200
     4.915    75.312     0.200
     5.210    78.695     0.200
     5.109    77.934     0.200
     5.171    80.074     0.200
     5.357    80.422     0.200
     5.659    83.973     0.200
     5.652    86.832     0.200
     5.621    85.363     0.200
     5.771    87.422     0.200
     6.005    90.824     0.200
     6.063    91.555     0.200
     6.077    91.445     0.200
     6.140    92.402     0.200
     6.153    92.145     0.200
     6.194    92.145     0.200
     6.338    96.203     0.200
     6.381    95.355     0.200
     6.457    95.965     0.200
     6.370    94.832     0.200
     6.501    96.375     0.200
     6.498    96.766     0.200
     6.701   101.203     0.200
     7.268   109.453     0.200
     7.496   111.234     0.200
     7.627   112.004     0.200
     7.920   116.465     0.200
     7.975   116.715     0.200
     8.191   119.992     0.200
     8.113   117.965     0.200
    15.359   218.453     0.200
    15.618   221.055     0.200
     1.927    34.172     0.200
     1.930    34.141     0.200
     2.004    34.742     0.200
     2.128    36.742     0.200
     2.183    37.703     0.200
     2.274    38.070     0.200
     2.369    39.871     0.200
     2.529    42.031     0.200
     2.631    44.383     0.200
     2.594    43.270     0.200
     2.824    48.203     0.200
     2.845    47.621     0.200
     2.892    47.250     0.200
     2.974    48.320     0.200
     2.958    47.941     0.200
     3.121    50.102     0.200
     3.218    52.520     0.200
     3.185    51.070     0.200
     3.309    52.383     0.200
     3.499    54.352     0.200
     3.675    58.062     0.200
     3.608    56.660     0.200
     3.853    61.062     0.200
     3.913    61.582     0.200
     3.990    61.562     0.200
     3.987    63.680     0.200
     4.532    69.922     0.200
     4.860    75.000     0.200
     5.003    77.000     0.200
     5.093    77.133     0.200
     5.201    79.262     0.200
     5.446    82.582     0.200
     5.828    88.852     0.200
     6.121    92.770     0.200
     6.955   104.000     0.200
     7.256   106.453     0.200
     7.403   109.891     0.200
     8.532   125.672     0.200
     9.235   134.180     0.200
     9.345   135.480     0.200
    10.244   147.602     0.200
    10.346   151.070     0.200
    10.545   154.633     0.200
    10.455   151.320     0.200
    11.027   160.160     0.200
    11.285   162.891     0.200
    12.892   184.992     0.200
    15.522   221.762     0.200
    16.004   225.582     0.200
     1.922    33.250     0.200
     1.923    33.848     0.200
     2.022    35.250     0.200
     2.128    35.688     0.200
     2.066    35.438     0.200
     2.373    39.637     0.200
     2.389    41.707     0.200
     2.404    40.148     0.200
     2.445    40.629     0.200
     2.577    45.059     0.200
     2.678    44.770     0.200
     2.921    46.789     0.200
     2.961    48.109     0.200
     2.983    48.480     0.200
     3.197    52.027     0.200
     3.305    51.930     0.200
     3.221    51.027     0.200
     3.277    52.500     0.200
     3.524    55.457     0.200
     3.581    55.910     0.200
     3.607    58.078     0.200
     3.555    56.148     0.200
     3.680    58.777     0.200
     3.811    58.750     0.200
     3.938    61.160     0.200
     3.961    62.598     0.200
     4.096    63.797     0.200
     4.187    64.527     0.200
     4.124    64.879     0.200
     4.285    66.867     0.200
     4.282    67.430     0.200
     4.298    66.699     0.200
     4.225    67.180     0.200
     4.375    68.719     0.200
     4.566    70.609     0.200
     4.868    75.297     0.200
     5.328    79.328     0.200
     5.431    82.469     0.200
    15.439   218.809     0.200
     1.902    32.496     0.200
     1.950    33.586     0.200
     1.899    34.234     0.200
     2.054    35.598     0.200
     2.137    35.895     0.200
     2.061    35.207     0.200
     2.405    40.258     0.200
     2.431    40.355     0.200
     2.380    41.117     0.200
     2.945    47.746     0.200
     2.979    47.098     0.200
     2.969    47.734     0.200
     3.208    52.207     0.200
     3.299    52.355     0.200
     3.601    56.664     0.200
     3.922    61.645     0.200
     4.106    65.586     0.200
     4.142    64.527     0.200
     4.293    66.875     0.200
     4.580    70.105     0.200
     4.788    73.266     0.200
     1.811    32.363     0.200
     1.903    32.363     0.200
     2.038    34.484     0.200
     2.031    34.145     0.200
     2.124    35.434     0.200
     2.270    37.684     0.200
     2.472    40.164     0.200
     2.522    41.043     0.200
     2.526    41.184     0.200
     2.798    46.965     0.200
    15.951   224.426     0.200
     1.911    32.457     0.200
     1.915    32.586     0.200
     2.044    34.559     0.200
     2.039    35.516     0.200
     2.129    36.148     0.200
     2.278    38.336     0.200
     2.329    38.668     0.200
     2.477    40.777     0.200
     2.528    41.457     0.200
     2.533    41.586     0.200
     2.728    45.258     0.200
     2.750    45.148     0.200
     2.805    46.086     0.200
    15.310   217.336     0.200
    15.536   218.727     0.200
    15.956   224.047     0.200
    16.432   232.598     0.200
    16.823   237.098     0.200
     2.329    38.918     0.200
     3.603    57.539     0.200
     7.213   105.789     0.200
     8.283   120.996     0.200
     8.696   127.039     0.200
    10.198   150.977     0.200
    10.191   149.688     0.200
    12.077   172.086     0.200
    12.889   183.219     0.200
    14.024   201.656     0.200
     1.895    32.016     0.200
     1.904    32.570     0.200
     1.997    35.148     0.200
     2.136    36.719     0.200
     2.347    39.734     0.200
     2.387    40.500     0.200
     2.418    40.172     0.200
     2.594    43.719     0.200
     2.907    46.703     0.200
     3.015    48.984     0.200
     3.169    50.773     0.200
     3.629    57.203     0.200
     3.713    58.109     0.200
     3.973    61.469     0.200
     4.195    64.281     0.200
     4.918    75.055     0.200
     7.089   103.805     0.200
     2.465    40.867     0.200
     2.465    41.102     0.200
     3.206    50.680     0.200
     3.572    56.875     0.200
     3.572    57.070     0.200
     5.694    85.172     0.200
     6.529    97.586     0.200
     7.089   103.945     0.200
     8.287   120.297     0.200
     8.287   120.398     0.200
     8.839   129.969     0.200
     9.149   134.500     0.200
    10.332   152.125     0.200
    12.252   174.180     0.200
    12.403   177.500     0.200
    12.751   183.500     0.200
    12.963   184.664     0.200
    15.784   223.141     0.200
    16.143   228.023     0.200
    17.479   243.797     0.200
     1.881    32.664     0.200
     1.972    34.172     0.200
     1.976    35.789     0.200
     2.123    35.664     0.200
     2.417    40.672     0.200
     4.385    68.336     0.200
     4.763    71.148     0.200
     4.937    76.422     0.200
     5.097    76.156     0.200
     5.104    78.055     0.200
     5.129    78.414     0.200
     5.334    81.617     0.200
     5.359    81.328     0.200
     5.535    81.828     0.200
     5.533    83.414     0.200
     5.581    85.414     0.200
     5.647    85.422     0.200
     7.063   103.328     0.200
    10.252   147.562     0.200
    11.087   159.164     0.200
    12.690   181.422     0.200
    14.572   207.047     0.200
    15.382   215.828     0.200
    15.801   221.242     0.200
    16.010   225.656     0.200
    16.737   235.078     0.200
    16.922   237.617     0.200
    17.454   243.508     0.200
     1.852    32.971     0.200
     1.893    33.791     0.200
     1.989    34.311     0.200
     2.077    35.621     0.200
     2.109    36.591     0.200
     2.147    36.521     0.200
     2.353    39.471     0.200
     2.311    40.151     0.200
     2.492    41.091     0.200
     2.562    42.451     0.200
     2.631    43.831     0.200
     2.815    46.740     0.200
     2.906    47.971     0.200
     2.955    47.091     0.200
     2.986    47.911     0.200
     3.090    49.911     0.200
     3.161    50.681     0.200
     3.223    52.081     0.200
     3.319    51.980     0.200
     3.467    54.381     0.200
     3.457    55.291     0.200
     3.570    56.041     0.200
     3.766    58.771     0.200
     3.703    58.021     0.200
     3.848    60.171     0.200
     3.955    61.141     0.200
     3.919    61.500     0.200
     4.202    65.760     0.200
     4.289    66.091     0.200
     4.371    67.240     0.200
     4.487    69.031     0.200
     4.512    69.480     0.200
     4.519    69.381     0.200
     4.524    70.431     0.200
     4.613    70.931     0.200
     4.777    73.421     0.200
     4.837    74.151     0.200
     4.958    74.230     0.200
     5.034    77.061     0.200
     2.986    47.201     0.200
     3.703    58.431     0.200
     3.703    58.201     0.200
     3.983    62.101     0.200
     4.837    75.101     0.200
     5.302    80.101     0.200
     5.569    84.301     0.200
     5.560    85.301     0.200
     5.726    85.000     0.200
     5.984    89.195     0.200
     6.543    98.801     0.200
     6.716   101.101     0.200
     6.716   100.115     0.200
     6.952   103.701     0.200
     6.949   104.101     0.200
     7.216   107.000     0.200
     7.216   106.177     0.200
     7.216   106.701     0.200
     7.216   106.811     0.200
     7.862   115.901     0.200
     8.213   121.000     0.200
     8.371   120.692     0.200
     8.371   121.510     0.200
     8.659   127.401     0.200
     8.659   126.851     0.200
     9.343   136.904     0.200
    10.114   149.151     0.200
    12.139   172.196     0.200
    12.621   180.458     0.200
    12.948   186.031     0.200
    12.938   183.411     0.200
    13.939   200.961     0.200
    15.862   225.258     0.200
    16.002   226.701     0.200
    15.940   225.240     0.200
    16.104   227.605     0.200
    16.168   228.143     0.200
     1.982    34.132     0.200
     2.114    38.032     0.200
     2.164    37.322     0.200
     2.293    38.442     0.200
     2.347    39.703     0.200
     2.510    41.683     0.200
     2.573    42.902     0.200
     2.612    43.462     0.200
     2.803    46.772     0.200
     2.877    47.262     0.200
     2.976    48.163     0.200
     2.996    47.802     0.200
     3.099    48.962     0.200
     3.163    50.592     0.200
     3.200    51.393     0.200
     3.330    52.223     0.200
     3.478    54.152     0.200
     3.464    54.493     0.200
     3.590    55.962     0.200
     3.667    58.132     0.200
     3.772    58.612     0.200
     3.833    60.382     0.200
     3.899    60.203     0.200
     3.896    61.373     0.200
     4.294    66.203     0.200
     4.378    66.993     0.200
     4.489    69.183     0.200
     4.511    69.473     0.200
     4.511    69.562     0.200
     4.504    70.592     0.200
     4.601    71.473     0.200
     4.776    72.772     0.200
     4.838    73.973     0.200
     4.971    74.172     0.200
     4.997    77.333     0.200
     5.547    82.882     0.200
     6.137    92.482     0.200
     6.663    99.353     0.200
     6.687   100.012     0.200
     7.390   109.462     0.200
     7.683   112.913     0.200
     9.213   133.623     0.200
    10.531   154.072     0.200
     1.844    31.375     0.200
     1.866    32.176     0.200
     1.923    33.645     0.200
     1.965    34.027     0.200
     2.084    34.805     0.200
     2.107    35.395     0.200
     2.316    38.004     0.200
     2.348    38.844     0.200
     2.366    39.375     0.200
     2.541    42.836     0.200
     2.501    40.754     0.200
     2.676    45.625     0.200
     2.866    46.145     0.200
     2.910    46.516     0.200
     2.964    47.688     0.200
     3.258    50.207     0.200
     3.540    55.695     0.200
     3.592    55.285     0.200
     3.663    57.535     0.200
     3.755    57.496     0.200
     4.153    61.996     0.200
     4.251    65.285     0.200
     4.889    73.445     0.200
    15.796   222.188     0.200
    16.005   225.625     0.200
     1.901    32.211     0.200
     1.932    33.531     0.200
     1.930    33.844     0.200
     2.031    34.406     0.200
     2.055    35.250     0.200
     2.139    35.617     0.200
     2.381    39.305     0.200
     2.414    40.180     0.200
     2.399    40.516     0.200
     2.436    40.266     0.200
     2.587    43.016     0.200
     2.930    47.008     0.200
     2.972    47.180     0.200
     2.992    48.477     0.200
     3.188    50.375     0.200
     3.210    50.430     0.200
     3.314    51.641     0.200
     3.287    52.430     0.200
     3.472    53.500     0.200
     3.545    55.977     0.200
     3.527    56.016     0.200
     3.591    56.141     0.200
     3.617    57.844     0.200
     3.689    58.328     0.200
     3.820    58.734     0.200
     3.855    60.859     0.200
     3.947    61.297     0.200
     3.971    62.305     0.200
     4.114    63.297     0.200
     4.106    63.469     0.200
     4.215    64.930     0.200
     4.198    64.344     0.200
     4.296    66.008     0.200
     4.309    66.359     0.200
     4.291    66.586     0.200
     4.385    68.039     0.200
     4.381    68.977     0.200
     4.393    68.875     0.200
     4.577    70.055     0.200
     4.642    71.148     0.200
     4.812    72.000     0.200
     4.812    73.758     0.200
     4.886    74.266     0.200
     4.872    74.398     0.200
     5.005    75.625     0.200
     1.947    34.214     0.200
     2.065    35.774     0.200
     2.072    35.654     0.200
     2.080    36.654     0.200
     2.144    37.034     0.200
     2.313    39.414     0.200
     2.313    39.704     0.200
     2.491    41.094     0.200
     2.549    41.874     0.200
     2.575    43.984     0.200
     2.726    45.874     0.200
     2.767    46.884     0.200
     2.847    47.874     0.200
     2.924    48.524     0.200
     3.013    49.764     0.200
     3.074    49.224     0.200
     3.031    49.614     0.200
     3.133    50.684     0.200
     3.164    51.164     0.200
     3.285    53.324     0.200
     3.304    54.764     0.200
     3.411    54.464     0.200
     3.366    54.264     0.200
     3.453    53.704     0.200
     3.436    55.024     0.200
     3.573    56.114     0.200
     3.640    57.334     0.200
     3.744    58.794     0.200
     3.796    59.944     0.200
     3.860    60.514     0.200
     3.948    61.274     0.200
     3.935    61.904     0.200
     4.026    62.934     0.200
     4.041    65.144     0.200
     4.114    64.104     0.200
     4.144    65.324     0.200
     4.264    65.924     0.200
     4.350    67.214     0.200
     4.459    68.844     0.200
     4.478    68.994     0.200
     4.476    69.294     0.200
     4.468    70.064     0.200
     4.565    70.874     0.200
     4.745    72.454     0.200
     4.807    72.854     0.200
     4.947    74.374     0.200
     4.981    76.154     0.200
     4.972    76.454     0.200
     5.042    77.284     0.200
     5.157    79.854     0.200
     5.262    80.004     0.200
     5.286    79.524     0.200
     5.269    80.504     0.200
     5.310    81.274     0.200
     2.044    35.465     0.200
     2.148    37.123     0.200
     2.155    37.635     0.200
     2.218    38.064     0.200
     2.239    38.244     0.200
     2.410    40.414     0.200
     2.632    43.484     0.200
     2.667    44.725     0.200
     2.921    47.953     0.200
     2.923    48.545     0.200
     2.935    47.514     0.200
     3.159    50.484     0.200
     3.691    59.094     0.200
     3.834    59.184     0.200
     3.842    59.984     0.200
     3.891    60.984     0.200
     3.947    62.494     0.200
     3.952    62.854     0.200
     4.199    66.023     0.200
     4.233    66.895     0.200
     4.552    70.453     0.200
     4.572    70.273     0.200
     4.661    72.645     0.200
     5.600    86.385     0.200
     5.756    87.834     0.200
     5.797    86.023     0.200
     5.860    89.094     0.200
     5.868    89.523     0.200
     6.158    93.094     0.200
     6.574   100.264     0.200
    10.283   148.555     0.200
    10.574   155.174     0.200
    11.318   162.494     0.200
    12.676   180.965     0.200
    12.880   183.514     0.200
     1.917    33.266     0.200
     2.027    35.625     0.200
     2.092    35.516     0.200
     2.108    36.008     0.200
     2.379    39.855     0.200
     2.398    40.348     0.200
     2.333    39.488     0.200
     2.451    41.008     0.200
     2.937    47.555     0.200
     3.255    52.906     0.200
     3.295    51.516     0.200
     3.267    51.316     0.200
     3.460    55.738     0.200
     3.555    56.676     0.200
     3.620    57.805     0.200
     4.178    66.215     0.200
     4.604    71.605     0.200
     4.742    72.438     0.200
     4.806    74.945     0.200
     5.462    82.398     0.200
     6.279    94.555     0.200
     7.128   104.426     0.200
     8.178   119.945     0.200
     8.841   129.906     0.200
    10.826   155.855     0.200
     3.460    55.547     0.200
     7.128   104.078     0.200
     7.128   104.707     0.200
     8.178   120.117     0.200
     8.841   129.266     0.200
    10.382   153.438     0.200
    12.152   173.078     0.200
    12.880   183.746     0.200
    16.167   228.758     0.200
     1.912    32.949     0.200
     2.020    34.902     0.200
     2.091    35.340     0.200
     2.107    36.500     0.200
     2.336    39.223     0.200
     2.372    39.242     0.200
     2.392    39.812     0.200
     2.456    40.262     0.200
     2.624    43.109     0.200
     2.904    46.902     0.200
     2.934    47.801     0.200
     3.290    52.020     0.200
     3.256    52.359     0.200
     3.251    52.480     0.200
     3.266    51.512     0.200
     3.469    55.762     0.200
     3.558    55.133     0.200
     3.557    57.340     0.200
     3.625    57.762     0.200
     3.602    55.832     0.200
     3.802    58.762     0.200
     3.809    60.191     0.200
     3.882    60.352     0.200
     4.070    63.332     0.200
     4.166    64.492     0.200
     4.257    66.262     0.200
     4.265    65.832     0.200
     4.175    63.723     0.200
     4.329    68.301     0.200
     4.534    70.250     0.200
     4.601    70.691     0.200
     4.747    72.383     0.200
     4.789    71.832     0.200
     4.851    73.570     0.200
     5.023    75.930     0.200
     5.074    78.012     0.200
     5.112    76.922     0.200
     5.424    81.859     0.200
     5.549    84.121     0.200
     5.551    84.770     0.200
     5.566    83.051     0.200
     5.464    81.891     0.200
     5.826    87.133     0.200
     5.764    85.902     0.200
     5.880    88.402     0.200
     6.280    93.723     0.200
     6.398    94.562     0.200
     7.121   104.160     0.200
     7.160   106.020     0.200
     7.176   106.051     0.200
     7.364   108.570     0.200
     7.408   109.430     0.200
     7.528   110.340     0.200
     7.676   112.512     0.200
     7.876   115.840     0.200
     8.077   117.242     0.200
     8.246   119.500     0.200
     8.187   119.340     0.200
     8.974   130.180     0.200
    10.131   146.383     0.200
    10.491   151.391     0.200
    11.141   159.250     0.200
    12.352   176.840     0.200
    12.889   183.512     0.200
     1.922    33.172     0.200
     1.899    33.383     0.200
     2.026    34.762     0.200
     2.080    35.641     0.200
     2.377    39.102     0.200
     2.369    39.012     0.200
     2.404    39.691     0.200
     2.445    40.473     0.200
     2.918    46.211     0.200
     2.954    47.133     0.200
     3.303    51.102     0.200
     3.218    51.402     0.200
     3.272    52.141     0.200
     3.236    51.461     0.200
     3.469    54.363     0.200
     3.499    55.371     0.200
     3.576    55.141     0.200
     3.588    56.441     0.200
     3.572    56.703     0.200
     3.658    56.973     0.200
     3.812    58.750     0.200
     3.833    59.531     0.200
     3.916    60.820     0.200
     3.940    61.641     0.200
     4.089    63.461     0.200
     4.183    63.930     0.200
     4.143    65.051     0.200
     4.277    65.590     0.200
     4.273    66.230     0.200
     4.288    65.973     0.200
     4.556    70.160     0.200
     4.801    72.172     0.200
     4.781    72.270     0.200
     4.870    73.703     0.200
     5.056    76.992     0.200
     5.104    77.461     0.200
     5.127    76.930     0.200
     5.307    80.562     0.200
     5.456    82.230     0.200
     5.486    83.203     0.200
     5.441    81.621     0.200
     5.566    84.480     0.200
     5.577    82.582     0.200
     5.583    84.293     0.200
     5.709    85.270     0.200
     5.733    85.973     0.200
     5.857    88.543     0.200
     5.900    88.242     0.200
     6.271    94.102     0.200
     6.393    94.113     0.200
     6.426    95.863     0.200
     7.207   107.121     0.200
     7.386   109.480     0.200
     7.690   111.480     0.200
     7.893   114.590     0.200
     7.958   116.582     0.200
     8.069   118.570     0.200
     8.104   117.781     0.200
     8.253   119.613     0.200
     8.213   118.570     0.200
     8.507   121.863     0.200
    14.628   206.152     0.200
    15.207   215.191     0.200
    15.438   217.453     0.200
    15.442   217.852     0.200
    15.857   222.672     0.200
    16.148   227.750     0.200
    16.493   231.051     0.200
    16.806   235.840     0.200
    17.636   246.090     0.200
     2.445    40.941     0.200
     3.499    55.891     0.200
     5.733    85.770     0.200
     7.124   103.891     0.200
     8.213   119.582     0.200
     8.830   129.332     0.200
    10.355   151.242     0.200
    12.902   183.043     0.200
    15.762   223.293     0.200
     1.885    31.391     0.200
     1.906    31.852     0.200
     1.942    33.656     0.200
     2.125    34.930     0.200
     2.067    34.906     0.200
     2.353    38.328     0.200
     2.388    39.648     0.200
     2.398    40.211     0.200
     2.462    40.047     0.200
     2.579    42.695     0.200
     2.906    46.289     0.200
     2.952    47.109     0.200
     3.189    50.688     0.200
     3.220    50.305     0.200
     3.264    51.719     0.200
     3.547    56.156     0.200
     3.612    57.195     0.200
     3.554    54.938     0.200
     3.692    58.102     0.200
     3.838    60.148     0.200
     3.951    60.375     0.200
     3.971    63.141     0.200
    15.833   222.758     0.200
    16.041   225.289     0.200
     2.013    35.337     0.200
     2.059    36.597     0.200
     2.134    35.537     0.200
     2.363    39.978     0.200
     2.399    40.457     0.200
     2.403    41.577     0.200
     2.452    40.717     0.200
     2.697    45.117     0.200
     2.917    47.127     0.200
     2.962    48.387     0.200
     3.183    51.797     0.200
     3.212    50.767     0.200
     3.546    55.677     0.200
     3.545    56.847     0.200
     3.696    59.157     0.200
     3.804    58.857     0.200
     3.848    60.797     0.200
     4.210    64.747     0.200
     4.295    67.277     0.200
     4.296    68.607     0.200
     4.890    76.177     0.200
     5.127    76.987     0.200
     5.343    80.957     0.200
     5.429    80.627     0.200
     5.571    82.887     0.200
     5.677    84.688     0.200
     5.697    85.757     0.200
     6.298    95.837     0.200
     7.107   104.497     0.200
     7.221   107.707     0.200
     7.580   111.747     0.200
     8.258   121.407     0.200
     9.984   146.947     0.200
    10.182   148.027     0.200
    10.847   156.177     0.200
    12.399   178.177     0.200
    12.936   185.427     0.200
    15.443   218.097     0.200
    15.843   223.597     0.200
     2.019    34.723     0.200
     2.156    35.785     0.200
     2.035    35.855     0.200
     2.410    39.906     0.200
     2.432    40.273     0.200
     2.632    45.754     0.200
     2.726    44.453     0.200
     2.729    44.293     0.200
     2.930    46.996     0.200
     2.980    47.383     0.200
     3.155    51.953     0.200
     3.312    52.414     0.200
     3.187    50.543     0.200
     3.725    59.145     0.200
     4.084    63.383     0.200
     4.324    66.914     0.200
     4.652    71.305     0.200
     4.915    74.934     0.200
     5.126    78.145     0.200
     5.357    81.934     0.200
     5.410    81.895     0.200
     5.584    82.965     0.200
     5.725    85.793     0.200
     5.842    88.445     0.200
     7.110   104.695     0.200
     7.201   106.133     0.200
     8.816   130.855     0.200
     9.575   138.793     0.200
    10.013   145.613     0.200
    10.306   150.344     0.200
    10.377   151.414     0.200
    10.838   156.484     0.200
    10.864   156.523     0.200
    12.327   177.246     0.200
    12.231   175.734     0.200
    12.423   179.496     0.200
    12.947   183.586     0.200
    14.141   203.336     0.200
    15.430   220.953     0.200
    15.849   223.863     0.200
    16.121   229.004     0.200
     5.677    85.344     0.200
     5.725    88.633     0.200
     8.281   119.984     0.200
    10.322   153.414     0.200
    10.312   152.234     0.200
    12.947   183.734     0.200
    14.141   204.664     0.200
    16.121   227.496     0.200
     5.725    87.895     0.200
     1.975    33.383     0.200
     2.023    35.023     0.200
     1.992    35.344     0.200
     2.124    36.758     0.200
     2.209    36.914     0.200
     2.344    39.672     0.200
     2.475    41.539     0.200
     2.436    41.438     0.200
     2.505    41.953     0.200
     2.644    45.180     0.200
     2.676    46.609     0.200
     2.693    44.398     0.200
     3.019    48.719     0.200
     3.053    49.703     0.200
     3.156    50.859     0.200
     3.153    50.172     0.200
     3.404    52.953     0.200
     3.373    53.922     0.200
     3.491    55.539     0.200
     3.498    56.148     0.200
     3.676    57.430     0.200
     3.664    59.000     0.200
     3.714    59.680     0.200
     3.912    60.383     0.200
     3.928    62.242     0.200
     3.967    62.883     0.200
     4.001    63.828     0.200
     4.072    62.898     0.200
     4.189    65.469     0.200
     4.185    66.344     0.200
     4.283    66.023     0.200
     4.327    68.758     0.200
     4.376    67.969     0.200
     4.385    68.305     0.200
     4.721    73.461     0.200
     4.835    75.523     0.200
     5.186    79.789     0.200
     5.383    82.609     0.200
     5.368    81.570     0.200
     5.413    82.414     0.200
     5.344    80.133     0.200
     5.525    85.242     0.200
     5.553    84.117     0.200
     5.667    87.133     0.200
     5.726    86.164     0.200
     5.782    87.539     0.200
     6.234    93.328     0.200
     6.398    95.984     0.200
     6.453    97.523     0.200
     6.514    97.555     0.200
     7.219   105.805     0.200
     7.207   106.953     0.200
     7.483   110.891     0.200
     7.642   112.328     0.200
     8.123   120.805     0.200
     8.188   120.180     0.200
     9.093   131.805     0.200
    10.245   148.078     0.200
    10.346   151.891     0.200
    10.610   152.172     0.200
    11.242   162.023     0.200
    11.318   163.188     0.200
    12.783   183.164     0.200
    12.832   183.852     0.200
     2.105    35.880     0.200
     2.326    39.560     0.200
     2.416    40.670     0.200
     2.429    40.830     0.200
     2.420    41.150     0.200
     2.938    47.640     0.200
     3.425    55.800     0.200
     3.554    57.780     0.200
     3.826    60.630     0.200
     3.862    60.350     0.200
     3.893    60.890     0.200
     4.218    66.100     0.200
     5.273    81.830     0.200
     5.603    83.320     0.200
     5.445    82.550     0.200
     5.617    85.360     0.200
     5.674    85.980     0.200
     7.166   105.021     0.200
     1.779    30.008     0.200
     1.895    32.156     0.200
     1.994    34.422     0.200
     2.143    35.039     0.200
     2.331    37.906     0.200
     2.378    39.172     0.200
     2.437    39.969     0.200
     2.745    43.266     0.200
     2.900    45.398     0.200
     2.957    47.180     0.200
     3.149    48.477     0.200
     3.195    49.000     0.200
     3.281    51.008     0.200
     3.262    51.789     0.200
     3.604    55.867     0.200
     3.736    57.438     0.200
     3.853    59.602     0.200
     4.014    61.250     0.200
     4.084    60.938     0.200
     4.776    70.930     0.200
     4.867    72.281     0.200
    15.392   217.297     0.200
    15.811   221.938     0.200
     2.477    40.047     0.200
     3.604    57.078     0.200
     5.731    85.891     0.200
     5.679    83.867     0.200
     7.071   104.281     0.200
     8.319   121.352     0.200
    10.324   150.758     0.200
    12.991   185.352     0.200
    16.143   226.828     0.200
     1.992    33.883     0.200
     2.099    35.715     0.200
     2.119    36.895     0.200
     2.174    37.184     0.200
     2.357    38.945     0.200
     2.283    38.363     0.200
     2.520    41.453     0.200
     2.584    42.633     0.200
     2.620    43.605     0.200
     2.873    47.035     0.200
     2.883    46.844     0.200
     2.883    46.965     0.200
     2.969    47.766     0.200
     3.174    50.504     0.200
     3.600    56.645     0.200
     3.669    58.312     0.200
     3.783    58.746     0.200
     3.903    61.285     0.200
     3.891    60.215     0.200
     3.998    62.523     0.200
     4.520    69.695     0.200
     4.998    76.613     0.200
     5.213    77.945     0.200
     5.912    88.426     0.200
    15.431   222.016     0.200
    15.995   224.395     0.200
    15.927   224.586     0.200
    16.204   228.633     0.200
    16.241   231.645     0.200
     2.283    38.613     0.200
     3.669    58.586     0.200
     5.912    88.773     0.200
     7.247   105.773     0.200
     7.247   106.223     0.200
     8.637   126.812     0.200
    10.125   150.074     0.200
    10.111   148.953     0.200
    12.898   183.094     0.200
    13.940   202.684     0.200
     5.912    89.465     0.200
     6.693   100.402     0.200
     8.333   120.164     0.200
     9.321   137.598     0.200
    12.046   172.629     0.200
    12.624   180.520     0.200
    12.928   187.477     0.200
    14.006   203.664     0.200
     1.956    34.023     0.200
     2.095    35.312     0.200
     2.306    38.312     0.200
     2.344    38.963     0.200
     2.387    40.402     0.200
     2.558    44.514     0.200
     2.507    41.822     0.200
     2.864    45.992     0.200
     2.915    47.123     0.200
     2.988    48.354     0.200
     3.246    50.443     0.200
     3.223    51.123     0.200
     3.200    50.332     0.200
     3.244    51.152     0.200
     3.396    53.133     0.200
     3.529    54.912     0.200
     3.595    57.422     0.200
     3.569    56.844     0.200
     3.577    55.854     0.200
     3.749    58.123     0.200
     3.687    58.803     0.200
     3.806    59.643     0.200
     3.964    63.023     0.200
     4.047    63.014     0.200
     4.135    63.562     0.200
     4.134    63.412     0.200
     4.240    65.402     0.200
     4.259    65.652     0.200
     4.225    65.082     0.200
     4.280    66.793     0.200
     4.356    67.344     0.200
     4.525    69.322     0.200
     4.588    70.363     0.200
     4.826    73.443     0.200
     4.811    74.252     0.200
     5.075    76.412     0.200
     5.075    77.793     0.200
     5.100    78.062     0.200
     5.304    81.193     0.200
     5.516    81.662     0.200
     5.470    83.023     0.200
     5.504    82.572     0.200
     5.474    82.312     0.200
     5.697    85.492     0.200
    15.096   213.473     0.200
    15.201   216.252     0.200
    15.367   215.502     0.200
    15.786   220.723     0.200
    15.686   222.693     0.200
    15.684   223.193     0.200
    15.995   224.533     0.200
    16.186   228.252     0.200
     2.507    40.832     0.200
     3.244    50.645     0.200
     3.569    56.543     0.200
     5.681    85.783     0.200
     5.681    85.572     0.200
     5.681    85.979     0.200
     5.729    85.703     0.200
     6.230    93.850     0.200
     6.510    97.297     0.200
     7.049   103.953     0.200
     7.049   104.328     0.200
     8.294   120.402     0.200
     8.294   120.783     0.200
     8.882   130.264     0.200
     9.127   134.604     0.200
    10.372   152.693     0.200
    10.386   153.014     0.200
    12.230   174.133     0.200
    12.234   173.383     0.200
    12.291   174.934     0.200
    12.363   177.936     0.200
    12.728   183.537     0.200
    12.989   184.582     0.200
    14.234   205.588     0.200
    15.096   214.725     0.200
    15.786   222.486     0.200
    15.948   226.385     0.200
    16.186   228.562     0.200
     1.893    32.141     0.200
     1.916    32.910     0.200
     2.013    34.740     0.200
     2.060    36.381     0.200
     2.364    39.180     0.200
     2.399    39.449     0.200
     2.916    46.029     0.200
     2.961    47.109     0.200
     3.300    51.471     0.200
     3.274    52.119     0.200
     3.454    53.600     0.200
     3.804    58.350     0.200
     3.847    60.461     0.200
     4.095    63.760     0.200
     4.286    65.029     0.200
     4.632    71.100     0.200
     1.956    34.146     0.200
     2.085    34.996     0.200
     2.106    36.896     0.200
     2.307    38.156     0.200
     2.342    38.977     0.200
     2.372    40.607     0.200
     2.509    41.916     0.200
     2.860    45.807     0.200
     2.908    46.527     0.200
     2.972    47.938     0.200
     3.243    49.967     0.200
     3.218    50.996     0.200
     3.398    53.516     0.200
     3.524    55.176     0.200
     3.553    57.527     0.200
     3.747    57.676     0.200
     3.671    57.857     0.200
     4.041    62.996     0.200
     4.130    64.188     0.200
     4.233    65.438     0.200
     4.250    65.938     0.200
     4.249    65.957     0.200
     4.517    70.207     0.200
     4.580    71.066     0.200
     4.740    71.537     0.200
     4.820    74.486     0.200
     4.902    76.016     0.200
     5.514    82.127     0.200
     5.769    87.217     0.200
     5.854    88.527     0.200
     5.854    88.557     0.200
    15.368   216.076     0.200
    15.697   222.166     0.200
    15.787   221.527     0.200
    15.996   224.906     0.200
    16.723   235.137     0.200
    17.439   243.807     0.200
     1.929    32.762     0.200
     2.072    34.922     0.200
     2.280    37.531     0.200
     2.318    39.082     0.200
     2.372    40.432     0.200
     2.537    43.041     0.200
     2.837    45.791     0.200
     2.889    46.242     0.200
     2.974    48.742     0.200
     3.197    51.141     0.200
     3.370    53.211     0.200
     3.722    57.150     0.200
     2.534    42.941     0.200
     3.266    52.127     0.200
     3.572    58.332     0.200
     3.572    57.230     0.200
     5.666    85.332     0.200
     5.666    85.758     0.200
     6.246    95.369     0.200
     7.024   103.672     0.200
     7.024   102.332     0.200
    12.340   178.293     0.200
    12.255   175.871     0.200
    12.260   175.031     0.200
    12.717   183.633     0.200
    16.211   229.842     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.929    73.809     0.200
     8.568   159.777     0.200
     8.600   160.164     0.200
     8.597   161.938     0.200
     5.712   107.637     0.200
     2.718    49.910     0.200
     2.642    48.609     0.200
     2.954    54.140     0.200
     2.787    51.422     0.200
     3.076    56.672     0.200
     3.114    57.474     0.200
     2.533    46.998     0.200
     2.561    47.391     0.200
     2.905    53.789     0.200
     2.698    49.859     0.200
     4.583    85.914     0.200
     2.663    48.922     0.200
     2.911    53.512     0.200
     3.173    58.391     0.200
     2.520    47.190     0.200
     2.717    50.141     0.200
     2.801    51.620     0.200
     3.091    57.040     0.200
     2.580    47.312     0.200
     2.629    48.492     0.200
     2.832    51.898     0.200
     2.832    52.031     0.200
     3.615    67.297     0.200
     4.478    83.781     0.200
     2.549    46.840     0.200
     2.823    51.918     0.200
     3.153    58.098     0.200
     4.326    79.680     0.200
     4.806    88.609     0.200
     4.196    77.555     0.200
     3.674    68.082     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.562    11.184     0.200
     1.222    22.285     0.200
     0.322     6.410     0.200
     0.456     8.156     0.200
     0.589    11.996     0.200
     0.732    13.277     0.200
     1.173    21.258     0.200
     0.449     8.270     0.200
     0.580    11.781     0.200
     0.729    13.102     0.200
     1.165    21.039     0.200
     1.204    21.852     0.200
     0.267     4.781     0.200
     0.626    12.531     0.200
     1.106    19.867     0.200
     5.000    89.969     0.200
     0.573    12.023     0.200
     1.156    21.324     0.200
     1.599    28.723     0.200
     2.177    37.723     0.200
     3.992    72.523     0.200
     6.972   128.125     0.200
     0.574    11.984     0.200
     1.159    20.984     0.200
     1.609    28.984     0.200
     2.184    37.906     0.200
     0.438     8.164     0.200
     0.441     8.203     0.200
     0.706    12.805     0.200
     1.176    21.195     0.200
     1.206    21.820     0.200
     1.292    22.164     0.200
     0.263     5.008     0.200
     0.328     6.318     0.200
     0.563    10.218     0.200
     0.752    14.588     0.200
     1.223    22.618     0.200
     1.565    26.178     0.200
     1.595    28.198     0.200
     0.263     5.465     0.200
     0.275     5.766     0.200
     0.468     9.867     0.200
     1.224    22.535     0.200
     1.391    24.664     0.200
     4.905    89.336     0.200
     0.193     3.980     0.200
     0.484     9.078     0.200
     0.597    12.180     0.200
     1.105    20.180     0.200
     1.198    20.379     0.200
     1.232    22.121     0.200
     1.459    26.480     0.200
     1.633    28.879     0.200
     1.661    29.281     0.200
     1.762    31.379     0.200
     0.294     5.438     0.200
     0.537    10.734     0.200
     0.620    11.539     0.200
     1.042    19.734     0.200
     1.405    25.539     0.200
     1.511    26.336     0.200
     0.278     5.047     0.200
     0.327     6.352     0.200
     1.203    22.227     0.200
     1.222    22.227     0.200
     1.421    25.844     0.200
     1.588    28.453     0.200
     1.603    28.609     0.200
     5.249    93.750     0.200
     0.277     5.592     0.200
     0.360     7.031     0.200
     0.569    10.551     0.200
     0.681    13.541     0.200
     1.135    20.342     0.200
     1.191    21.672     0.200
     5.214    93.291     0.200
     0.274     5.707     0.200
     0.369     7.188     0.200
     0.564    10.605     0.200
     0.678    13.566     0.200
     1.146    20.176     0.200
     1.184    21.438     0.200
     5.202    93.008     0.200
     0.228     4.203     0.200
     0.427     8.303     0.200
     0.621    12.303     0.200
     1.253    21.803     0.200
     1.161    21.252     0.200
     1.541    27.502     0.200
     1.699    28.902     0.200
     1.714    30.104     0.200
     1.740    30.902     0.200
     0.219     3.984     0.200
     0.433     8.184     0.200
     0.608    12.184     0.200
     0.865    16.484     0.200
     1.268    21.887     0.200
     1.548    27.684     0.200
     1.713    29.285     0.200
     1.722    30.086     0.200
     0.172     3.064     0.200
     0.303     5.336     0.200
     0.469     9.814     0.200
     1.238    22.166     0.200
     1.377    24.916     0.200
     1.789    31.076     0.200
     1.852    32.266     0.200
     0.244     4.566     0.200
     0.484     8.809     0.200
     0.629    12.457     0.200
     1.137    20.527     0.200
     1.348    24.508     0.200
     1.571    27.977     0.200
     1.724    29.855     0.200
     1.744    30.898     0.200
     0.168     3.461     0.200
     0.539    10.984     0.200
     1.371    24.969     0.200
     1.151    20.891     0.200
     1.329    24.367     0.200
     1.506    26.969     0.200
     1.563    26.828     0.200
     5.297    96.109     0.200
     0.660    13.137     0.200
     1.207    21.930     0.200
     0.298     5.438     0.200
     0.285     5.129     0.200
     0.591    10.559     0.200
     0.683    13.328     0.200
     1.080    18.488     0.200
     1.249    22.957     0.200
     1.521    25.977     0.200
     1.623    27.777     0.200
     1.768    29.906     0.200
     5.283    94.938     0.200
     0.453     8.445     0.200
     0.629    12.141     0.200
     0.879    16.602     0.200
     1.211    21.766     0.200
     1.290    21.867     0.200
     1.338    24.086     0.200
     1.562    27.383     0.200
     3.960    72.461     0.200
     5.079    90.711     0.200
     0.434     8.141     0.200
     0.440     8.289     0.200
     0.614    12.180     0.200
     0.867    16.531     0.200
     1.203    21.539     0.200
     1.289    21.359     0.200
     1.326    23.922     0.200
     1.551    27.273     0.200
     5.087    89.406     0.200
     5.087    91.500     0.200
     8.422   154.656     0.200
     8.616   158.328     0.200
     0.457     8.391     0.200
     0.632    12.516     0.200
     0.876    16.797     0.200
     1.162    20.883     0.200
     1.207    22.016     0.200
     1.285    21.586     0.200
     1.559    27.547     0.200
     5.082    91.008     0.200
     0.482     8.719     0.200
     0.658    12.809     0.200
     0.888    17.059     0.200
     1.139    21.102     0.200
     1.213    21.832     0.200
     1.277    21.809     0.200
     1.570    28.031     0.200
     1.725    28.949     0.200
     5.079    89.770     0.200
     5.079    90.012     0.200
     0.465     8.406     0.200
     1.160    21.031     0.200
     1.203    22.250     0.200
     1.277    22.008     0.200
     1.557    27.727     0.200
     1.723    29.188     0.200
     5.087    90.188     0.200
     0.682    12.311     0.200
     0.686    12.621     0.200
     1.243    23.031     0.200
     1.498    26.391     0.200
     1.618    28.852     0.200
     5.196    92.742     0.200
     0.633    12.422     0.200
     0.872    16.680     0.200
     1.196    21.211     0.200
     1.280    21.969     0.200
     5.087    90.508     0.200
     0.382     7.188     0.200
     0.462     8.547     0.200
     0.643    12.477     0.200
     0.814    15.539     0.200
     0.878    15.625     0.200
     0.939    17.305     0.200
     1.023    17.578     0.200
     1.226    21.867     0.200
     1.238    21.648     0.200
     1.227    22.320     0.200
     1.341    23.773     0.200
     1.420    24.898     0.200
     1.491    27.016     0.200
     1.518    27.117     0.200
     1.626    28.039     0.200
     1.616    28.203     0.200
     1.676    28.797     0.200
     0.226     4.711     0.200
     0.460     8.551     0.200
     0.490    10.004     0.200
     0.656    13.043     0.200
     0.758    13.902     0.200
     0.800    14.871     0.200
     0.947    17.621     0.200
     1.076    19.902     0.200
     1.125    20.883     0.200
     1.167    20.953     0.200
     1.167    20.781     0.200
     1.209    21.223     0.200
     1.280    22.141     0.200
     1.345    23.641     0.200
     1.364    23.203     0.200
     1.378    24.621     0.200
     1.366    24.914     0.200
     1.496    27.773     0.200
     1.429    26.594     0.200
     1.467    25.844     0.200
     1.521    25.703     0.200
     1.580    26.664     0.200
     1.733    31.031     0.200
     1.788    31.934     0.200
     0.373     6.639     0.200
     0.518     9.379     0.200
     0.776    14.389     0.200
     0.959    17.909     0.200
     1.194    21.799     0.200
     1.261    23.359     0.200
     1.632    27.649     0.200
     1.663    29.959     0.200
     1.734    30.938     0.200
     1.757    31.039     0.200
     2.332    41.389     0.200
     4.676    85.609     0.200
     0.331     6.468     0.200
     0.331     6.247     0.200
     0.534     9.957     0.200
     0.583    11.667     0.200
     0.680    13.258     0.200
     0.760    14.728     0.200
     0.812    15.188     0.200
     0.867    16.237     0.200
     0.979    18.388     0.200
     1.163    20.888     0.200
     1.227    22.308     0.200
     1.313    23.388     0.200
     1.283    23.838     0.200
     1.332    23.808     0.200
     1.445    25.888     0.200
     1.549    27.107     0.200
     1.540    26.167     0.200
     1.644    29.397     0.200
     1.710    30.747     0.200
     1.801    32.128     0.200
     1.801    31.598     0.200
     2.312    40.617     0.200
     0.239     4.637     0.200
     0.356     6.496     0.200
     0.356     6.598     0.200
     0.529     9.656     0.200
     0.609    11.746     0.200
     0.681    13.117     0.200
     0.789    14.758     0.200
     0.893    16.486     0.200
     0.963    18.098     0.200
     1.189    22.027     0.200
     1.205    21.848     0.200
     1.205    22.066     0.200
     1.347    25.047     0.200
     1.266    23.707     0.200
     1.575    27.727     0.200
     1.650    29.188     0.200
     1.650    29.557     0.200
     1.719    30.637     0.200
     2.318    40.947     0.200
     5.194    93.127     0.200
     6.235   109.377     0.200
     6.612   116.156     0.200
     0.548     9.773     0.200
     0.548     9.863     0.200
     0.613    11.363     0.200
     0.736    14.264     0.200
     0.845    15.854     0.200
     0.978    18.645     0.200
     1.004    16.873     0.200
     1.038    18.715     0.200
     1.083    20.234     0.200
     1.083    19.965     0.200
     1.095    18.604     0.200
     1.136    21.123     0.200
     1.274    23.635     0.200
     1.287    23.693     0.200
     1.308    22.824     0.200
     1.382    25.334     0.200
     1.474    26.244     0.200
     1.493    25.764     0.200
     1.617    27.604     0.200
     1.608    28.754     0.200
     1.659    29.793     0.200
     1.696    30.475     0.200
     1.696    30.273     0.200
     1.727    29.783     0.200
     1.767    31.215     0.200
     1.769    30.494     0.200
     1.783    32.264     0.200
     1.783    32.094     0.200
     1.826    32.174     0.200
     1.889    32.613     0.200
     1.892    32.623     0.200
     2.749    49.543     0.200
     0.257     4.352     0.200
     0.340     6.170     0.200
     0.588    11.480     0.200
     0.553    10.051     0.200
     0.765    14.420     0.200
     0.867    15.801     0.200
     0.923    15.682     0.200
     0.962    18.051     0.200
     1.072    20.471     0.200
     1.137    19.420     0.200
     1.137    20.611     0.200
     1.166    21.682     0.200
     1.166    21.830     0.200
     1.182    20.141     0.200
     1.182    20.000     0.200
     1.214    22.320     0.200
     1.214    22.510     0.200
     1.267    23.941     0.200
     1.267    23.330     0.200
     1.321    22.631     0.200
     1.408    25.420     0.200
     1.445    26.230     0.200
     1.533    25.910     0.200
     1.533    26.211     0.200
     1.550    27.602     0.200
     1.581    26.611     0.200
     1.610    28.691     0.200
     1.628    29.211     0.200
     1.625    29.621     0.200
     1.683    29.250     0.200
     1.711    29.371     0.200
     1.711    29.250     0.200
     1.823    32.211     0.200
     1.848    32.400     0.200
     1.807    31.811     0.200
     1.807    32.721     0.200
     2.293    41.561     0.200
     0.405     7.332     0.200
     0.416     7.520     0.200
     0.680    13.172     0.200
     0.789    14.781     0.200
     0.985    17.902     0.200
     1.021    19.191     0.200
     1.086    18.742     0.200
     1.216    22.270     0.200
     1.266    22.883     0.200
     1.300    22.430     0.200
     1.315    24.430     0.200
     1.331    22.852     0.200
     1.434    26.699     0.200
     1.668    29.441     0.200
     1.683    29.242     0.200
     1.736    29.750     0.200
     1.782    31.512     0.200
     1.854    32.570     0.200
     0.234     4.609     0.200
     0.332     6.250     0.200
     0.332     6.438     0.200
     0.584    11.461     0.200
     0.584    11.680     0.200
     0.531     9.828     0.200
     0.761    14.719     0.200
     0.801    14.000     0.200
     0.801    14.180     0.200
     0.812    15.234     0.200
     0.870    16.266     0.200
     0.980    18.406     0.200
     1.075    19.914     0.200
     1.165    21.188     0.200
     1.192    20.391     0.200
     1.227    22.344     0.200
     1.227    22.164     0.200
     1.359    25.281     0.200
     1.284    24.141     0.200
     1.335    23.484     0.200
     1.414    24.500     0.200
     1.543    26.328     0.200
     1.543    26.680     0.200
     1.551    27.336     0.200
     1.593    27.008     0.200
     1.647    29.477     0.200
     1.647    29.594     0.200
     1.714    30.547     0.200
     0.177     3.223     0.200
     0.413     7.660     0.200
     0.413     7.613     0.200
     0.431     7.822     0.200
     0.600    11.873     0.200
     0.676    13.152     0.200
     0.776    14.434     0.200
     0.845    16.184     0.200
     0.918    16.053     0.200
     0.977    18.172     0.200
     1.000    18.693     0.200
     1.066    18.232     0.200
     1.184    21.803     0.200
     1.202    21.822     0.200
     1.261    23.012     0.200
     1.280    21.934     0.200
     1.283    21.902     0.200
     1.295    24.303     0.200
     1.410    26.172     0.200
     1.410    25.947     0.200
     1.315    22.482     0.200
     1.380    24.223     0.200
     1.463    25.523     0.200
     1.531    27.123     0.200
     1.555    27.742     0.200
     1.650    29.002     0.200
     1.667    28.512     0.200
     1.706    30.104     0.200
     1.719    29.152     0.200
     1.740    30.482     0.200
     1.756    31.412     0.200
     1.809    31.062     0.200
     1.829    32.604     0.200
     2.130    38.123     0.200
     5.105    92.184     0.200
     0.342     6.178     0.200
     0.404     7.047     0.200
     0.668    12.627     0.200
     0.846    15.367     0.200
     0.940    17.037     0.200
     0.982    18.188     0.200
     1.087    19.957     0.200
     1.117    19.836     0.200
     1.253    22.777     0.200
     1.275    23.656     0.200
     1.289    23.486     0.200
     1.331    23.916     0.200
     1.347    23.438     0.200
     1.380    25.807     0.200
     1.502    27.617     0.200
     1.700    29.316     0.200
     1.756    30.117     0.200
     1.838    32.768     0.200
     1.907    34.137     0.200
     2.213    40.697     0.200
     0.398     7.125     0.200
     0.439     7.756     0.200
     0.703    13.385     0.200
     0.776    14.486     0.200
     0.955    16.996     0.200
     1.009    18.326     0.200
     1.016    18.955     0.200
     1.107    19.227     0.200
     1.204    22.156     0.200
     1.238    22.295     0.200
     1.289    23.477     0.200
     1.321    22.916     0.200
     1.308    24.406     0.200
     1.435    26.615     0.200
     1.706    29.586     0.200
     1.758    30.375     0.200
     1.795    32.375     0.200
     1.869    33.445     0.200
     1.891    33.535     0.200
     0.155     2.604     0.200
     0.393     7.314     0.200
     0.425     7.666     0.200
     0.425     7.725     0.200
     0.689    13.574     0.200
     0.790    14.613     0.200
     0.943    16.434     0.200
     0.943    16.754     0.200
     1.027    19.055     0.200
     1.203    22.074     0.200
     1.218    21.863     0.200
     1.218    22.465     0.200
     1.240    22.135     0.200
     1.275    23.334     0.200
     1.320    24.385     0.200
     1.443    26.654     0.200
     1.402    25.545     0.200
     1.496    26.014     0.200
     1.554    27.344     0.200
     1.696    29.324     0.200
     1.696    29.523     0.200
     1.749    30.154     0.200
     1.749    29.914     0.200
     1.759    31.045     0.200
     1.795    31.824     0.200
     1.868    33.004     0.200
     1.868    33.154     0.200
     0.421     7.652     0.200
     0.515     9.340     0.200
     0.676    12.730     0.200
     0.732    13.859     0.200
     0.890    15.402     0.200
     0.929    17.562     0.200
     1.010    17.301     0.200
     1.152    21.270     0.200
     1.224    21.820     0.200
     1.257    22.871     0.200
     1.238    22.352     0.200
     1.228    23.082     0.200
     1.330    24.762     0.200
     1.276    22.621     0.200
     1.626    28.312     0.200
     1.673    28.973     0.200
     1.676    29.723     0.200
     1.712    29.961     0.200
     1.721    31.621     0.200
     1.751    31.223     0.200
     1.801    31.492     0.200
     2.344    42.020     0.200
     2.943    52.402     0.200
     3.303    59.621     0.200
     0.211     4.152     0.200
     0.377     7.266     0.200
     0.377     7.121     0.200
     0.377     7.254     0.200
     0.491     8.961     0.200
     0.491     9.066     0.200
     0.491     9.121     0.200
     0.635    12.473     0.200
     0.649    12.691     0.200
     0.705    12.383     0.200
     0.809    15.570     0.200
     0.780    14.562     0.200
     0.861    14.902     0.200
     0.998    17.051     0.200
     0.974    18.273     0.200
     0.974    18.402     0.200
     1.038    18.102     0.200
     1.038    18.293     0.200
     1.133    20.832     0.200
     1.213    20.453     0.200
     1.213    20.711     0.200
     1.215    20.672     0.200
     1.218    22.293     0.200
     1.201    21.844     0.200
     1.201    21.973     0.200
     1.253    21.312     0.200
     1.369    25.551     0.200
     1.369    25.430     0.200
     1.275    23.742     0.200
     1.326    23.230     0.200
     1.278    23.113     0.200
     1.396    24.242     0.200
     1.474    25.203     0.200
     1.490    26.730     0.200
     1.505    26.852     0.200
     1.605    27.730     0.200
     1.691    30.113     0.200
     1.691    30.281     0.200
     1.762    31.492     0.200
     1.768    31.371     0.200
     0.325     5.850     0.200
     0.540     9.781     0.200
     0.540     9.819     0.200
     0.552     9.869     0.200
     0.618    11.409     0.200
     0.747    13.119     0.200
     0.747    13.005     0.200
     0.794    15.499     0.200
     0.844    15.729     0.200
     1.042    18.859     0.200
     1.113    20.100     0.200
     1.124    20.279     0.200
     1.136    21.039     0.200
     1.270    23.520     0.200
     1.619    28.566     0.200
     1.625    29.720     0.200
     1.639    29.086     0.200
     1.686    30.020     0.200
     1.716    29.499     0.200
     1.758    29.850     0.200
     1.773    31.999     0.200
     2.108    39.130     0.200
     2.213    39.020     0.200
     2.352    42.619     0.200
     2.513    45.760     0.200
     2.834    50.880     0.200
     3.186    57.550     0.200
     0.374     7.363     0.200
     0.374     7.461     0.200
     0.492     9.320     0.200
     0.514     9.500     0.200
     0.514     9.398     0.200
     0.629    12.461     0.200
     0.681    12.188     0.200
     0.776    14.668     0.200
     0.961    18.121     0.200
     0.977    17.098     0.200
     1.056    18.668     0.200
     1.117    20.258     0.200
     1.192    20.938     0.200
     1.194    20.602     0.200
     1.194    22.000     0.200
     1.194    21.867     0.200
     1.351    25.211     0.200
     1.262    23.559     0.200
     1.286    23.309     0.200
     1.667    29.641     0.200
     1.667    29.484     0.200
     1.738    30.781     0.200
     1.754    30.727     0.200
     1.756    30.820     0.200
     0.234     4.805     0.200
     0.380     7.371     0.200
     0.380     7.336     0.200
     0.380     7.445     0.200
     0.486     9.305     0.200
     0.515     9.395     0.200
     0.634    12.348     0.200
     0.673    13.207     0.200
     0.683    12.098     0.200
     0.770    14.625     0.200
     0.956    18.156     0.200
     0.980    17.258     0.200
     0.980    16.938     0.200
     1.051    18.625     0.200
     1.116    20.305     0.200
     1.195    21.074     0.200
     1.195    20.688     0.200
     1.197    20.473     0.200
     1.188    21.984     0.200
     1.188    21.805     0.200
     1.347    25.195     0.200
     1.257    23.516     0.200
     1.280    23.277     0.200
     1.378    24.375     0.200
     1.591    27.258     0.200
     1.591    27.445     0.200
     1.667    29.434     0.200
     1.739    30.707     0.200
     1.749    30.637     0.200
     2.235    40.078     0.200
     2.984    53.406     0.200
     3.097    55.695     0.200
     0.372     7.070     0.200
     0.372     7.102     0.200
     0.497     9.219     0.200
     0.568    10.445     0.200
     0.617    11.820     0.200
     0.628    11.000     0.200
     0.769    14.594     0.200
     0.930    15.797     0.200
     0.930    17.625     0.200
     1.064    19.281     0.200
     1.097    19.383     0.200
     1.097    19.250     0.200
     1.145    19.703     0.200
     1.147    19.516     0.200
     1.181    21.727     0.200
     1.309    24.477     0.200
     1.309    24.211     0.200
     1.234    23.047     0.200
     1.305    23.703     0.200
     1.547    26.133     0.200
     1.593    27.492     0.200
     1.613    28.914     0.200
     1.684    30.250     0.200
     1.730    30.547     0.200
     1.790    31.391     0.200
     2.281    40.391     0.200
     2.281    40.164     0.200
     2.706    49.086     0.200
     3.014    53.875     0.200
     0.284     5.582     0.200
     0.368     7.062     0.200
     0.503     9.283     0.200
     0.612    11.842     0.200
     0.575    10.412     0.200
     0.619    10.982     0.200
     0.726    13.893     0.200
     0.806    14.033     0.200
     0.806    13.812     0.200
     0.772    14.672     0.200
     0.921    15.672     0.200
     0.930    17.643     0.200
     1.058    19.264     0.200
     1.136    19.453     0.200
     1.106    19.402     0.200
     1.186    21.662     0.200
     1.183    21.742     0.200
     1.183    21.582     0.200
     1.306    24.502     0.200
     1.234    23.123     0.200
     1.319    23.443     0.200
     1.312    23.793     0.200
     1.420    24.213     0.200
     1.538    25.883     0.200
     1.584    26.203     0.200
     1.605    28.953     0.200
     1.630    28.604     0.200
     1.644    28.893     0.200
     1.676    30.123     0.200
     1.730    30.434     0.200
     2.274    40.252     0.200
     4.427    79.684     0.200
     0.431     7.720     0.200
     0.420     7.468     0.200
     0.420     7.460     0.200
     0.468     8.580     0.200
     0.683    13.050     0.200
     0.770    14.150     0.200
     0.777    13.240     0.200
     0.925    17.070     0.200
     0.969    16.860     0.200
     0.969    17.104     0.200
     0.996    18.561     0.200
     1.071    18.370     0.200
     1.197    21.620     0.200
     1.197    21.497     0.200
     1.232    22.141     0.200
     1.269    23.010     0.200
     1.288    23.275     0.200
     1.291    23.811     0.200
     1.322    23.021     0.200
     1.408    25.900     0.200
     1.673    29.240     0.200
     1.674    28.940     0.200
     1.725    29.990     0.200
     1.758    31.271     0.200
     1.758    31.023     0.200
     1.783    31.514     0.200
     1.781    32.630     0.200
     1.832    32.590     0.200
     2.924    52.650     0.200
     0.212     4.596     0.200
     0.389     7.645     0.200
     0.389     7.596     0.200
     0.480     9.156     0.200
     0.480     9.047     0.200
     0.487     8.926     0.200
     0.487     9.266     0.200
     0.648    12.646     0.200
     0.713    12.736     0.200
     0.648    12.826     0.200
     0.771    14.576     0.200
     0.874    15.877     0.200
     0.939    17.346     0.200
     0.969    18.377     0.200
     1.009    17.666     0.200
     1.009    17.775     0.200
     1.025    18.287     0.200
     1.145    20.957     0.200
     1.192    21.967     0.200
     1.224    21.346     0.200
     1.224    21.996     0.200
     1.226    21.645     0.200
     1.231    22.207     0.200
     1.231    22.416     0.200
     1.265    21.996     0.200
     1.265    22.137     0.200
     1.368    25.627     0.200
     1.269    23.787     0.200
     1.265    22.977     0.200
     1.339    23.666     0.200
     1.407    24.826     0.200
     1.487    26.275     0.200
     1.502    26.227     0.200
     1.697    30.445     0.200
     1.769    31.166     0.200
     1.797    31.346     0.200
     1.797    31.496     0.200
     2.965    52.568     0.200
     0.182     3.215     0.200
     0.442     8.215     0.200
     0.406     7.641     0.200
     0.406     7.625     0.200
     0.476     8.805     0.200
     0.609    11.703     0.200
     0.609    12.293     0.200
     0.669    12.984     0.200
     0.669    13.223     0.200
     0.776    14.402     0.200
     0.761    13.145     0.200
     0.908    16.074     0.200
     0.908    15.922     0.200
     0.986    17.332     0.200
     0.986    17.492     0.200
     0.968    18.016     0.200
     0.968    18.273     0.200
     0.994    18.516     0.200
     1.054    17.984     0.200
     1.201    21.562     0.200
     1.201    21.734     0.200
     1.201    21.855     0.200
     1.175    21.105     0.200
     1.245    22.562     0.200
     1.254    21.922     0.200
     1.291    23.875     0.200
     1.268    21.543     0.200
     1.268    21.785     0.200
     1.271    21.609     0.200
     1.402    25.895     0.200
     1.304    22.152     0.200
     1.304    22.555     0.200
     1.371    24.152     0.200
     1.451    24.805     0.200
     1.656    28.242     0.200
     1.656    28.363     0.200
     1.744    31.215     0.200
     1.744    31.324     0.200
     1.791    31.793     0.200
     1.782    31.715     0.200
     1.782    31.586     0.200
     1.782    32.574     0.200
     1.799    30.105     0.200
     2.181    38.895     0.200
     2.413    43.523     0.200
     2.413    42.195     0.200
     3.175    56.895     0.200
     3.595    63.418     0.200
     5.114    90.414     0.200
     0.220     4.484     0.200
     0.388     7.559     0.200
     0.388     7.564     0.200
     0.496     9.104     0.200
     0.480     9.054     0.200
     0.645    12.694     0.200
     0.657    12.374     0.200
     0.704    12.684     0.200
     0.769    14.644     0.200
     0.769    14.754     0.200
     0.935    17.344     0.200
     0.964    18.334     0.200
     1.001    17.754     0.200
     1.001    17.554     0.200
     1.032    18.434     0.200
     1.032    18.249     0.200
     1.135    20.784     0.200
     1.189    21.834     0.200
     1.215    21.304     0.200
     1.218    21.199     0.200
     1.259    21.874     0.200
     1.259    22.044     0.200
     1.268    22.994     0.200
     1.360    25.456     0.200
     1.264    23.784     0.200
     1.399    23.764     0.200
     1.513    26.884     0.200
     1.610    27.704     0.200
     1.688    29.754     0.200
     1.688    29.874     0.200
     1.732    30.534     0.200
     1.759    30.924     0.200
     2.219    39.274     0.200
     3.335    60.134     0.200
     0.465     8.172     0.200
     0.479     8.520     0.200
     0.479     8.533     0.200
     0.476     8.572     0.200
     0.506     9.252     0.200
     0.676    12.713     0.200
     0.712    13.203     0.200
     0.815    13.783     0.200
     0.786    14.633     0.200
     0.765    13.883     0.200
     0.867    15.604     0.200
     0.919    17.643     0.200
     1.025    17.752     0.200
     1.028    17.604     0.200
     1.127    21.092     0.200
     1.090    19.973     0.200
     1.211    20.953     0.200
     1.214    22.672     0.200
     1.214    21.777     0.200
     1.214    22.822     0.200
     1.215    21.262     0.200
     1.215    21.148     0.200
     1.332    23.973     0.200
     1.422    25.383     0.200
     1.422    25.562     0.200
     1.464    24.613     0.200
     1.500    26.932     0.200
     1.615    27.492     0.200
     1.591    29.193     0.200
     1.632    28.043     0.200
     1.646    27.104     0.200
     1.650    29.422     0.200
     1.773    29.246     0.200
     1.747    31.203     0.200
     1.828    32.262     0.200
     1.879    33.758     0.200
     2.090    37.242     0.200
     2.236    39.264     0.200
     2.340    41.414     0.200
     0.374     7.161     0.200
     0.374     7.173     0.200
     0.493     9.190     0.200
     0.554    10.208     0.200
     0.622    12.083     0.200
     0.768    14.583     0.200
     0.824    14.232     0.200
     0.944    16.363     0.200
     0.936    17.740     0.200
     1.078    19.562     0.200
     1.084    19.274     0.200
     1.158    20.423     0.200
     1.161    20.517     0.200
     1.199    21.869     0.200
     1.182    21.596     0.200
     1.182    21.703     0.200
     1.209    20.683     0.200
     1.319    24.598     0.200
     1.319    24.713     0.200
     1.240    23.423     0.200
     1.298    23.673     0.200
     1.559    26.593     0.200
     1.628    29.087     0.200
     1.628    29.383     0.200
     1.698    30.543     0.200
     1.735    30.873     0.200
     1.800    31.633     0.200
     2.296    40.683     0.200
     0.255     4.469     0.200
     0.255     4.475     0.200
     0.503     9.844     0.200
     0.553    10.020     0.200
     0.612    10.734     0.200
     0.881    15.164     0.200
     0.886    16.145     0.200
     1.034    18.922     0.200
     1.034    19.152     0.200
     1.095    19.324     0.200
     1.103    19.812     0.200
     1.121    19.445     0.200
     1.170    20.621     0.200
     1.392    25.535     0.200
     1.296    23.488     0.200
     1.340    24.824     0.200
     1.412    25.492     0.200
     1.412    25.703     0.200
     1.473    25.414     0.200
     1.630    29.133     0.200
     1.630    29.332     0.200
     1.660    29.152     0.200
     1.688    30.164     0.200
     1.736    30.434     0.200
     1.919    33.922     0.200
     0.425     7.594     0.200
     0.433     7.680     0.200
     0.433     7.812     0.200
     0.460     8.516     0.200
     0.696    13.180     0.200
     0.763    14.125     0.200
     0.939    16.359     0.200
     0.955    16.789     0.200
     0.994    18.539     0.200
     1.085    18.539     0.200
     1.190    21.594     0.200
     1.219    22.133     0.200
     1.219    22.320     0.200
     1.210    21.984     0.200
     1.210    22.203     0.200
     1.282    23.180     0.200
     1.282    22.781     0.200
     1.299    22.383     0.200
     1.302    22.078     0.200
     1.410    26.008     0.200
     1.410    26.133     0.200
     1.336    23.445     0.200
     1.688    28.875     0.200
     1.768    32.156     0.200
     1.768    31.961     0.200
     1.773    30.898     0.200
     1.778    32.578     0.200
     1.871    32.859     0.200
     0.247     4.797     0.200
     0.275     5.320     0.200
     0.481    10.008     0.200
     0.485     9.320     0.200
     0.585    10.938     0.200
     0.585    10.922     0.200
     0.769    13.656     0.200
     0.799    15.047     0.200
     0.847    16.102     0.200
     1.105    20.672     0.200
     1.120    20.352     0.200
     1.120    20.461     0.200
     1.127    19.922     0.200
     1.127    20.031     0.200
     1.228    22.578     0.200
     1.297    22.680     0.200
     1.409    25.141     0.200
     1.409    25.312     0.200
     1.429    25.477     0.200
     1.556    28.969     0.200
     1.486    25.680     0.200
     1.486    25.422     0.200
     1.511    26.180     0.200
     1.511    26.336     0.200
     1.514    26.398     0.200
     1.533    26.367     0.200
     1.577    27.312     0.200
     1.748    30.812     0.200
     1.748    30.922     0.200
     1.854    32.617     0.200
     1.975    35.266     0.200
     1.991    34.969     0.200
     2.787    48.508     0.200
     0.522     8.969     0.200
     0.594    10.570     0.200
     0.656    11.883     0.200
     0.842    15.609     0.200
     0.950    17.719     0.200
     0.950    17.828     0.200
     0.993    17.953     0.200
     0.993    18.055     0.200
     1.023    17.172     0.200
     1.026    17.203     0.200
     1.094    19.383     0.200
     1.094    20.219     0.200
     1.290    24.008     0.200
     1.220    21.461     0.200
     1.238    22.977     0.200
     1.523    27.445     0.200
     1.599    27.008     0.200
     1.585    28.125     0.200
     1.756    32.523     0.200
     1.756    32.648     0.200
     1.932    34.281     0.200
     1.932    33.953     0.200
     1.879    32.898     0.200
     2.306    40.477     0.200
     2.287    40.125     0.200
     0.345     6.562     0.200
     0.371     7.230     0.200
     0.371     7.250     0.200
     0.550     9.660     0.200
     0.527     9.480     0.200
     0.527     9.590     0.200
     0.597    11.672     0.200
     0.642    11.609     0.200
     0.642    11.742     0.200
     0.763    12.652     0.200
     0.777    14.551     0.200
     0.788    15.109     0.200
     0.859    14.180     0.200
     0.859    14.359     0.200
     0.853    15.062     0.200
     0.901    16.949     0.200
     0.993    18.000     0.200
     1.073    18.109     0.200
     1.075    18.117     0.200
     1.136    18.902     0.200
     1.259    23.500     0.200
     1.161    21.371     0.200
     1.165    20.512     0.200
     1.209    22.621     0.200
     1.235    21.660     0.200
     1.376    23.512     0.200
     1.347    23.922     0.200
     1.425    25.461     0.200
     1.441    25.742     0.200
     1.484    24.891     0.200
     1.527    25.289     0.200
     1.537    27.430     0.200
     1.537    27.531     0.200
     1.606    28.430     0.200
     1.705    30.359     0.200
     0.136     3.381     0.200
     0.307     5.938     0.200
     0.463     8.898     0.200
     0.489     9.900     0.200
     0.515     9.860     0.200
     0.898    16.201     0.200
     0.894    15.911     0.200
     0.894    15.802     0.200
     1.002    18.061     0.200
     1.092    20.411     0.200
     1.177    21.190     0.200
     1.218    21.841     0.200
     1.259    23.041     0.200
     1.259    22.841     0.200
     1.310    23.741     0.200
     1.310    23.599     0.200
     1.329    24.014     0.200
     1.391    24.921     0.200
     1.393    24.553     0.200
     1.408    24.331     0.200
     1.520    28.261     0.200
     1.608    28.480     0.200
     0.391     7.262     0.200
     0.428     7.762     0.200
     0.496     9.160     0.200
     0.767    13.535     0.200
     1.015    19.047     0.200
     0.992    17.348     0.200
     1.204    21.371     0.200
     1.222    21.988     0.200
     1.240    22.785     0.200
     1.261    22.902     0.200
     1.270    21.781     0.200
     1.421    26.309     0.200
     1.699    29.688     0.200
     1.755    31.668     0.200
     1.803    32.410     0.200
     0.302     5.948     0.200
     0.471     8.906     0.200
     0.471     8.858     0.200
     0.513     9.599     0.200
     0.513     9.777     0.200
     0.734    13.759     0.200
     0.827    15.499     0.200
     0.885    15.639     0.200
     0.906    16.448     0.200
     1.011    17.849     0.200
     1.051    19.009     0.200
     1.094    20.408     0.200
     1.186    20.979     0.200
     1.211    21.738     0.200
     1.211    21.871     0.200
     1.257    22.908     0.200
     1.257    22.799     0.200
     1.318    23.459     0.200
     1.335    24.329     0.200
     1.335    23.994     0.200
     1.381    25.528     0.200
     1.400    24.988     0.200
     1.402    24.921     0.200
     1.417    24.099     0.200
     1.523    28.429     0.200
     1.600    27.929     0.200
     1.600    27.208     0.200
     2.560    46.269     0.200
     2.877    51.289     0.200
     0.309     5.888     0.200
     0.466     8.668     0.200
     0.511     9.713     0.200
     0.899    16.205     0.200
     0.890    15.770     0.200
     1.089    20.285     0.200
     1.213    21.960     0.200
     1.254    22.494     0.200
     1.314    23.339     0.200
     1.328    24.140     0.200
     1.395    24.142     0.200
     1.517    28.166     0.200
     0.138     3.145     0.200
     0.306     6.006     0.200
     0.306     5.855     0.200
     0.466     8.924     0.200
     0.466     8.885     0.200
     0.514     9.756     0.200
     0.514     9.635     0.200
     0.514     9.932     0.200
     0.729    14.025     0.200
     0.827    15.596     0.200
     0.901    16.385     0.200
     0.901    16.186     0.200
     0.886    16.824     0.200
     0.890    15.865     0.200
     0.890    15.746     0.200
     1.005    17.666     0.200
     1.005    17.975     0.200
     1.045    19.035     0.200
     1.092    20.506     0.200
     1.180    21.055     0.200
     1.180    20.936     0.200
     1.215    22.045     0.200
     1.215    21.705     0.200
     1.258    23.154     0.200
     1.258    22.855     0.200
     1.254    22.516     0.200
     1.330    24.205     0.200
     1.313    23.525     0.200
     1.379    25.445     0.200
     1.394    24.455     0.200
     1.394    24.615     0.200
     1.396    24.664     0.200
     1.411    25.895     0.200
     1.521    28.215     0.200
     1.521    28.342     0.200
     1.411    23.775     0.200
     1.411    24.166     0.200
     1.456    25.166     0.200
     1.611    27.824     0.200
     1.605    28.086     0.200
     1.605    27.785     0.200
     1.622    28.305     0.200
     3.317    59.301     0.200
     0.334     6.121     0.200
     0.535     9.492     0.200
     0.535     9.277     0.200
     0.520     9.791     0.200
     0.602    10.691     0.200
     0.641    11.688     0.200
     0.695    11.861     0.200
     0.701    13.641     0.200
     0.779    14.521     0.200
     0.815    13.881     0.200
     0.968    18.191     0.200
     0.968    17.975     0.200
     0.980    18.082     0.200
     1.010    18.371     0.200
     1.029    18.662     0.200
     1.032    17.396     0.200
     1.077    19.012     0.200
     1.086    19.881     0.200
     1.086    20.340     0.200
     1.165    21.592     0.200
     1.309    24.455     0.200
     1.213    22.021     0.200
     1.217    21.256     0.200
     1.253    23.131     0.200
     1.253    23.002     0.200
     1.276    24.221     0.200
     1.309    22.922     0.200
     1.353    24.791     0.200
     1.427    24.441     0.200
     1.418    25.471     0.200
     1.418    25.176     0.200
     1.474    24.801     0.200
     1.535    27.551     0.200
     1.600    28.592     0.200
     1.603    27.521     0.200
     1.705    30.453     0.200
     1.762    31.191     0.200
     1.773    31.082     0.200
     1.773    32.326     0.200
     1.936    34.660     0.200
     2.206    38.381     0.200
     2.264    39.664     0.200
     0.403     7.598     0.200
     0.403     7.530     0.200
     0.428     7.920     0.200
     0.428     7.818     0.200
     0.485     9.070     0.200
     0.666    12.760     0.200
     0.772    13.465     0.200
     0.911    16.250     0.200
     0.968    16.890     0.200
     0.982    17.465     0.200
     1.008    18.870     0.200
     1.062    18.490     0.200
     1.204    21.670     0.200
     1.252    22.280     0.200
     1.252    22.393     0.200
     1.212    22.600     0.200
     1.212    22.075     0.200
     1.249    22.460     0.200
     1.276    22.440     0.200
     1.278    22.506     0.200
     1.309    22.710     0.200
     1.297    23.970     0.200
     1.417    26.340     0.200
     1.661    28.730     0.200
     1.688    29.480     0.200
     1.757    31.210     0.200
     1.757    31.584     0.200
     2.179    38.673     0.200
     2.940    51.430     0.200
     2.940    52.311     0.200
     0.369     6.879     0.200
     0.585    10.428     0.200
     0.850    15.318     0.200
     0.949    16.717     0.200
     0.986    17.223     0.200
     1.107    18.857     0.200
     1.215    22.467     0.200
     1.129    20.836     0.200
     1.324    23.318     0.200
     1.319    23.229     0.200
     1.310    23.988     0.200
     1.322    23.658     0.200
     1.322    24.232     0.200
     1.414    26.498     0.200
     1.423    25.947     0.200
     1.537    28.428     0.200
     1.702    30.207     0.200
     2.518    45.951     0.200
     2.980    53.518     0.200
     3.403    61.158     0.200
     0.264     4.904     0.200
     0.335     6.214     0.200
     0.335     6.084     0.200
     0.428     8.124     0.200
     0.428     8.234     0.200
     0.540    10.984     0.200
     0.589    11.001     0.200
     0.589    10.734     0.200
     0.589    10.894     0.200
     0.743    14.054     0.200
     0.774    13.224     0.200
     0.774    13.894     0.200
     0.774    13.691     0.200
     0.853    16.294     0.200
     0.853    15.714     0.200
     0.967    16.874     0.200
     0.967    17.034     0.200
     1.011    19.114     0.200
     1.045    19.544     0.200
     1.045    19.257     0.200
     1.091    19.284     0.200
     1.091    19.854     0.200
     1.091    19.734     0.200
     1.118    20.124     0.200
     1.172    20.814     0.200
     1.172    21.304     0.200
     1.172    21.454     0.200
     1.166    21.314     0.200
     1.271    22.464     0.200
     1.358    24.314     0.200
     1.374    24.634     0.200
     1.496    27.784     0.200
     1.406    25.884     0.200
     1.437    25.654     0.200
     1.437    25.824     0.200
     1.437    25.950     0.200
     1.486    26.624     0.200
     1.486    26.504     0.200
     1.488    25.689     0.200
     1.520    26.694     0.200
     1.575    27.474     0.200
     1.669    28.644     0.200
     1.702    29.434     0.200
     1.702    30.474     0.200
     1.702    30.344     0.200
     1.728    30.094     0.200
     1.795    31.754     0.200
     1.795    32.858     0.200
     1.984    35.496     0.200
     2.235    40.444     0.200
     2.845    51.504     0.200
     3.185    57.844     0.200
     3.636    64.764     0.200
     3.960    71.604     0.200
     4.170    74.354     0.200
     4.801    86.514     0.200
     0.277     5.027     0.200
     0.334     6.295     0.200
     0.334     6.316     0.200
     0.538     9.828     0.200
     0.577    11.248     0.200
     0.608    10.877     0.200
     0.576    10.297     0.200
     0.756    14.557     0.200
     0.720    13.617     0.200
     0.775    13.547     0.200
     0.806    15.027     0.200
     0.899    15.486     0.200
     0.955    17.926     0.200
     1.060    19.428     0.200
     1.060    19.271     0.200
     1.055    19.527     0.200
     1.113    19.236     0.200
     1.116    19.197     0.200
     1.160    19.838     0.200
     1.152    21.277     0.200
     1.133    20.146     0.200
     1.133    19.904     0.200
     1.324    24.461     0.200
     1.215    22.207     0.200
     1.215    22.322     0.200
     1.243    21.998     0.200
     1.296    22.418     0.200
     1.346    24.457     0.200
     1.611    28.396     0.200
     1.663    28.467     0.200
     1.687    30.227     0.200
     1.757    31.248     0.200
     1.840    32.518     0.200
     0.339     6.527     0.200
     0.448     8.500     0.200
     0.448     8.824     0.200
     0.526     9.656     0.200
     0.526     9.629     0.200
     0.763    14.520     0.200
     0.838    14.559     0.200
     0.790    15.270     0.200
     0.913    15.918     0.200
     1.043    19.418     0.200
     1.043    19.652     0.200
     1.054    18.957     0.200
     1.102    20.258     0.200
     1.193    21.180     0.200
     1.193    22.078     0.200
     1.211    21.250     0.200
     1.319    23.566     0.200
     1.375    25.090     0.200
     1.375    24.887     0.200
     1.482    27.629     0.200
     1.425    25.430     0.200
     1.428    24.582     0.200
     1.456    25.547     0.200
     1.548    26.898     0.200
     1.548    27.520     0.200
     2.259    39.461     0.200
     2.328    40.301     0.200
     2.484    43.305     0.200
     0.447     7.945     0.200
     0.447     8.328     0.200
     0.514     9.023     0.200
     0.514     8.430     0.200
     0.489     9.000     0.200
     0.489     8.781     0.200
     0.660    12.828     0.200
     0.717    13.547     0.200
     0.794    12.969     0.200
     0.851    14.750     0.200
     0.820    15.242     0.200
     0.820    15.391     0.200
     0.897    15.008     0.200
     0.925    16.711     0.200
     1.063    18.492     0.200
     1.066    18.500     0.200
     1.036    18.898     0.200
     1.176    21.977     0.200
     1.149    19.188     0.200
     1.108    20.344     0.200
     1.211    22.727     0.200
     1.211    22.227     0.200
     1.174    20.703     0.200
     1.315    23.594     0.200
     1.492    24.930     0.200
     1.479    26.523     0.200
     1.529    25.703     0.200
     1.555    27.828     0.200
     1.650    28.227     0.200
     1.625    29.688     0.200
     1.625    29.516     0.200
     1.792    29.688     0.200
     1.754    31.578     0.200
     1.879    34.047     0.200
     1.847    32.961     0.200
     1.847    32.844     0.200
     2.147    38.805     0.200
     2.155    39.938     0.200
     2.289    42.133     0.200
     3.035    54.609     0.200
     0.422     7.828     0.200
     0.422     8.070     0.200
     0.550     9.855     0.200
     0.550     9.918     0.200
     0.557    11.191     0.200
     0.736    13.480     0.200
     0.736    13.891     0.200
     0.917    15.930     0.200
     0.917    15.594     0.200
     1.022    18.961     0.200
     1.073    19.000     0.200
     1.073    19.141     0.200
     1.117    20.168     0.200
     1.167    21.230     0.200
     1.222    20.859     0.200
     1.222    20.969     0.200
     1.314    23.281     0.200
     1.314    23.461     0.200
     1.302    23.930     0.200
     1.369    24.969     0.200
     1.465    27.090     0.200
     1.400    25.020     0.200
     1.400    25.219     0.200
     1.436    24.559     0.200
     1.439    24.223     0.200
     1.473    25.328     0.200
     1.473    25.461     0.200
     1.531    26.418     0.200
     1.531    26.738     0.200
     1.527    26.418     0.200
     1.619    27.918     0.200
     1.662    29.539     0.200
     1.702    29.719     0.200
     1.713    30.301     0.200
     1.713    30.641     0.200
     1.713    30.480     0.200
     1.781    31.508     0.200
     1.781    32.711     0.200
     2.792    49.988     0.200
     3.103    55.520     0.200
     3.676    65.270     0.200
     4.205    74.918     0.200
     0.260     4.651     0.200
     0.260     4.551     0.200
     0.319     5.611     0.200
     0.548     9.651     0.200
     0.548     9.881     0.200
     0.634    11.211     0.200
     0.749    14.531     0.200
     0.750    13.571     0.200
     0.750    14.061     0.200
     0.810    14.321     0.200
     0.810    14.131     0.200
     0.891    16.451     0.200
     1.053    18.940     0.200
     1.053    19.701     0.200
     1.024    17.861     0.200
     1.060    18.371     0.200
     1.006    18.831     0.200
     1.035    18.980     0.200
     1.206    21.230     0.200
     1.189    21.811     0.200
     1.345    24.971     0.200
     1.326    24.241     0.200
     1.291    23.411     0.200
     1.315    24.701     0.200
     1.315    24.461     0.200
     1.412    24.301     0.200
     1.461    25.261     0.200
     1.461    25.071     0.200
     1.496    26.291     0.200
     1.447    26.141     0.200
     1.561    26.801     0.200
     1.556    28.241     0.200
     1.556    28.051     0.200
     1.593    27.791     0.200
     1.593    27.901     0.200
     1.614    28.561     0.200
     1.614    28.801     0.200
     1.707    28.931     0.200
     1.928    34.121     0.200
     0.360     6.945     0.200
     0.360     6.812     0.200
     0.505     9.141     0.200
     0.505     9.008     0.200
     0.650    11.531     0.200
     0.694    13.391     0.200
     0.783    14.383     0.200
     0.892    16.406     0.200
     0.946    16.352     0.200
     0.953    17.781     0.200
     0.953    17.898     0.200
     1.091    19.836     0.200
     1.160    19.867     0.200
     1.163    19.969     0.200
     1.207    20.406     0.200
     1.189    21.461     0.200
     1.189    21.969     0.200
     1.335    24.898     0.200
     1.198    21.820     0.200
     1.344    23.172     0.200
     1.307    23.359     0.200
     1.469    26.336     0.200
     1.464    26.281     0.200
     1.557    26.422     0.200
     1.638    29.461     0.200
     1.708    30.258     0.200
     1.752    30.820     0.200
     1.814    32.023     0.200
     0.366     6.875     0.200
     0.366     6.781     0.200
     0.500     9.227     0.200
     0.653    11.359     0.200
     0.694    13.594     0.200
     0.778    14.609     0.200
     0.898    16.719     0.200
     0.950    17.945     0.200
     0.950    16.086     0.200
     1.092    19.734     0.200
     1.080    19.094     0.200
     1.080    18.992     0.200
     1.193    21.117     0.200
     1.193    21.914     0.200
     1.201    22.125     0.200
     1.195    21.555     0.200
     1.195    21.828     0.200
     1.212    21.391     0.200
     1.333    24.945     0.200
     1.253    23.477     0.200
     1.301    23.711     0.200
     1.348    23.445     0.200
     1.640    29.375     0.200
     1.748    30.789     0.200
     1.809    31.859     0.200
     3.007    53.531     0.200
     0.318     6.523     0.200
     0.533    10.336     0.200
     0.533    10.141     0.200
     0.777    14.961     0.200
     0.797    15.227     0.200
     0.934    17.109     0.200
     0.934    16.930     0.200
     0.955    17.922     0.200
     1.062    20.273     0.200
     1.146    20.750     0.200
     1.208    22.055     0.200
     1.208    22.203     0.200
     1.228    21.609     0.200
     1.320    23.797     0.200
     1.405    25.672     0.200
     1.405    25.156     0.200
     0.249     4.495     0.200
     0.431     8.305     0.200
     0.586    10.685     0.200
     0.591    11.455     0.200
     0.679    11.745     0.200
     0.720    12.725     0.200
     0.802    14.475     0.200
     0.828    14.925     0.200
     0.945    17.645     0.200
     0.887    16.835     0.200
     0.927    16.735     0.200
     0.933    17.285     0.200
     1.028    18.035     0.200
     1.064    18.435     0.200
     1.061    19.195     0.200
     1.126    21.225     0.200
     1.370    24.155     0.200
     1.395    23.695     0.200
     1.380    25.705     0.200
     1.468    26.445     0.200
     1.517    27.725     0.200
     1.622    28.835     0.200
     1.650    29.055     0.200
     1.727    29.675     0.200
     1.753    29.895     0.200
     0.384     7.223     0.200
     0.484     8.781     0.200
     0.485     8.941     0.200
     0.714    12.500     0.200
     0.776    14.371     0.200
     0.870    15.281     0.200
     0.935    17.520     0.200
     0.975    18.320     0.200
     1.008    17.359     0.200
     1.148    20.562     0.200
     1.226    21.480     0.200
     1.198    22.000     0.200
     1.263    22.352     0.200
     1.247    22.770     0.200
     1.373    25.383     0.200
     1.274    23.652     0.200
     1.614    28.070     0.200
     1.664    28.840     0.200
     1.699    30.723     0.200
     1.770    31.410     0.200
     0.375     7.227     0.200
     0.434     8.427     0.200
     0.503     9.437     0.200
     0.768    14.527     0.200
     0.747    14.127     0.200
     0.871    15.397     0.200
     1.023    18.337     0.200
     1.013    18.777     0.200
     1.075    19.917     0.200
     1.171    20.317     0.200
     1.157    21.077     0.200
     1.177    22.097     0.200
     1.277    23.117     0.200
     1.354    24.497     0.200
     1.343    24.927     0.200
     1.447    26.817     0.200
     1.421    25.347     0.200
     1.737    30.467     0.200
     0.413     7.969     0.200
     0.413     7.656     0.200
     0.572    11.086     0.200
     0.650    10.609     0.200
     0.650    10.500     0.200
     0.689    12.039     0.200
     0.689    11.922     0.200
     0.767    13.047     0.200
     0.814    14.688     0.200
     0.838    15.219     0.200
     0.841    15.539     0.200
     0.876    16.289     0.200
     0.990    16.586     0.200
     1.088    20.023     0.200
     1.002    18.898     0.200
     1.087    18.750     0.200
     1.170    21.953     0.200
     1.184    22.023     0.200
     1.207    22.117     0.200
     1.331    22.500     0.200
     1.368    23.828     0.200
     1.497    25.969     0.200
     1.488    25.523     0.200
     1.511    25.281     0.200
     1.637    27.273     0.200
     2.003    35.078     0.200
     3.109    55.953     0.200
     3.155    54.992     0.200
     3.190    56.586     0.200
     0.468     9.625     0.200
     0.547    10.564     0.200
     0.644    12.615     0.200
     0.760    15.145     0.200
     0.967    18.215     0.200
     1.051    19.596     0.200
     1.268    22.545     0.200
     1.336    23.855     0.200
     1.314    23.266     0.200
     0.416     7.512     0.200
     0.419     7.684     0.200
     0.434     8.004     0.200
     0.681    13.062     0.200
     0.923    16.754     0.200
     0.923    16.344     0.200
     0.982    18.164     0.200
     0.994    18.672     0.200
     1.068    18.895     0.200
     1.068    19.031     0.200
     1.200    21.402     0.200
     1.267    22.953     0.200
     1.288    22.992     0.200
     1.288    23.613     0.200
     1.319    23.164     0.200
     1.406    26.121     0.200
     1.385    24.145     0.200
     1.465    26.004     0.200
     1.536    26.555     0.200
     1.535    26.812     0.200
     1.560    27.012     0.200
     1.671    29.062     0.200
     1.671    28.273     0.200
     1.676    28.441     0.200
     1.676    29.332     0.200
     1.755    30.922     0.200
     2.793    49.172     0.200
     0.422     7.703     0.200
     0.425     7.680     0.200
     0.431     7.961     0.200
     0.687    13.203     0.200
     0.929    17.332     0.200
     0.929    16.191     0.200
     0.988    18.160     0.200
     0.988    18.043     0.200
     1.074    18.141     0.200
     1.203    21.410     0.200
     1.273    23.043     0.200
     1.326    22.652     0.200
     1.326    22.520     0.200
     1.290    23.410     0.200
     1.290    23.551     0.200
     1.407    26.102     0.200
     1.472    25.230     0.200
     1.543    26.352     0.200
     1.567    27.262     0.200
     1.678    28.453     0.200
     1.669    28.883     0.200
     1.669    29.363     0.200
     1.760    31.320     0.200
     1.860    33.191     0.200
     2.428    43.812     0.200
     5.093    90.566     0.200
     5.093    91.043     0.200
     5.832   105.559     0.200
     0.509     9.791     0.200
     0.509    10.021     0.200
     0.678    11.271     0.200
     0.678    11.621     0.200
     0.656    11.893     0.200
     0.763    13.611     0.200
     0.763    13.752     0.200
     0.797    13.672     0.200
     0.783    14.932     0.200
     0.865    15.801     0.200
     0.971    18.092     0.200
     0.999    18.461     0.200
     1.058    18.041     0.200
     1.071    19.973     0.200
     1.071    19.051     0.200
     1.148    19.281     0.200
     1.151    21.281     0.200
     1.194    20.473     0.200
     1.306    24.451     0.200
     1.261    22.541     0.200
     1.261    22.902     0.200
     1.292    21.752     0.200
     1.280    23.762     0.200
     1.337    24.521     0.200
     1.408    23.732     0.200
     1.525    27.582     0.200
     1.564    26.672     0.200
     1.584    27.021     0.200
     1.714    30.791     0.200
     1.740    31.441     0.200
     1.746    31.301     0.200
     1.937    34.041     0.200
     1.929    34.021     0.200
     2.192    38.852     0.200
     0.289     5.992     0.200
     0.485     9.922     0.200
     0.788    15.340     0.200
     0.807    15.473     0.200
     1.066    19.043     0.200
     1.066    19.250     0.200
     1.093    20.652     0.200
     1.106    20.270     0.200
     1.237    21.812     0.200
     1.237    21.953     0.200
     1.237    22.480     0.200
     1.366    25.090     0.200
     1.374    25.211     0.200
     1.372    24.043     0.200
     1.372    24.293     0.200
     1.432    25.582     0.200
     1.432    26.141     0.200
     1.472    25.941     0.200
     1.472    25.230     0.200
     1.533    27.781     0.200
     1.928    34.730     0.200
     2.595    46.820     0.200
     0.804    14.426     0.200
     0.920    17.145     0.200
     1.018    17.805     0.200
     1.349    23.156     0.200
     1.454    27.227     0.200
     1.486    26.457     0.200
     1.680    28.754     0.200
     1.707    29.348     0.200
     1.814    32.156     0.200
     2.140    37.848     0.200
     2.145    39.176     0.200
     3.286    59.605     0.200
     5.043    84.164     0.200
     0.685    12.515     0.200
     0.776    13.495     0.200
     0.776    13.385     0.200
     0.858    15.815     0.200
     0.952    17.575     0.200
     0.952    17.755     0.200
     0.970    17.875     0.200
     1.045    17.715     0.200
     1.123    20.835     0.200
     1.174    20.225     0.200
     1.281    23.935     0.200
     1.250    22.655     0.200
     1.250    22.915     0.200
     1.261    23.415     0.200
     1.354    24.655     0.200
     1.393    23.595     0.200
     1.393    23.485     0.200
     1.439    24.155     0.200
     1.439    24.165     0.200
     1.496    27.025     0.200
     1.554    25.945     0.200
     1.566    26.935     0.200
     1.566    26.805     0.200
     1.678    28.405     0.200
     1.710    30.275     0.200
     1.742    31.125     0.200
     1.899    34.065     0.200
     2.163    37.545     0.200
     2.163    37.775     0.200
     3.664    67.005     0.200
     0.561    10.125     0.200
     0.812    15.254     0.200
     0.910    15.445     0.200
     0.967    18.195     0.200
     1.076    19.484     0.200
     1.167    19.914     0.200
     1.199    22.215     0.200
     1.223    22.594     0.200
     1.338    24.914     0.200
     1.273    23.746     0.200
     1.518    26.367     0.200
     1.567    27.555     0.200
     1.617    28.914     0.200
     1.697    29.344     0.200
     1.821    31.984     0.200
     2.030    35.746     0.200
     0.553     9.985     0.200
     0.805    15.096     0.200
     0.921    15.976     0.200
     0.965    18.046     0.200
     1.082    19.376     0.200
     1.179    21.035     0.200
     1.201    22.146     0.200
     1.217    22.456     0.200
     1.578    27.995     0.200
     1.625    28.836     0.200
     1.810    32.046     0.200
     0.299     5.766     0.200
     0.878    16.309     0.200
     0.878    16.426     0.200
     1.148    20.445     0.200
     1.128    21.137     0.200
     1.333    24.246     0.200
     1.307    23.996     0.200
     1.307    23.816     0.200
     1.368    23.406     0.200
     1.428    26.488     0.200
     1.419    26.387     0.200
     1.419    25.906     0.200
     1.514    26.797     0.200
     1.540    26.766     0.200
     1.546    28.586     0.200
     0.505     9.707     0.200
     0.909    16.438     0.200
     0.909    16.816     0.200
     1.124    19.645     0.200
     1.314    22.977     0.200
     1.299    22.926     0.200
     1.325    22.855     0.200
     1.342    23.926     0.200
     1.325    25.164     0.200
     1.325    24.344     0.200
     1.369    24.688     0.200
     1.369    24.977     0.200
     1.421    26.496     0.200
     1.421    26.316     0.200
     1.475    27.297     0.200
     1.693    30.938     0.200
     1.693    29.957     0.200
     0.247     3.266     0.200
     0.549     9.938     0.200
     0.563    10.680     0.200
     0.845    16.391     0.200
     0.827    15.156     0.200
     1.142    21.031     0.200
     0.985    18.609     0.200
     1.241    23.102     0.200
     1.423    26.109     0.200
     1.607    29.008     0.200
     1.698    29.859     0.200
     1.629    28.938     0.200
     0.403     7.176     0.200
     0.405     7.195     0.200
     0.448     8.035     0.200
     0.667    12.086     0.200
     0.965    17.855     0.200
     1.048    18.195     0.200
     1.048    18.305     0.200
     1.184    21.727     0.200
     1.252    22.785     0.200
     1.252    22.484     0.200
     1.300    23.004     0.200
     1.277    23.414     0.200
     1.277    23.785     0.200
     1.397    25.863     0.200
     1.445    25.414     0.200
     1.652    28.844     0.200
     1.652    28.355     0.200
     1.703    29.336     0.200
     1.702    28.953     0.200
     1.738    31.504     0.200
     1.738    31.055     0.200
     1.694    29.926     0.200
     1.694    30.094     0.200
     1.795    31.113     0.200
     1.834    31.953     0.200
     1.834    32.355     0.200
     2.406    43.746     0.200
     0.407     7.555     0.200
     0.407     7.422     0.200
     0.491     9.359     0.200
     0.494     9.359     0.200
     0.758    14.711     0.200
     0.986    18.500     0.200
     1.061    19.422     0.200
     1.144    19.602     0.200
     1.144    19.836     0.200
     1.159    21.680     0.200
     1.159    21.312     0.200
     1.243    22.312     0.200
     1.274    23.750     0.200
     1.274    23.391     0.200
     1.311    23.992     0.200
     1.311    24.203     0.200
     1.416    26.312     0.200
     1.344    24.492     0.200
     1.399    24.289     0.200
     1.542    26.945     0.200
     1.807    32.375     0.200
     1.807    32.484     0.200
     2.475    44.555     0.200
     4.247    76.594     0.200
     0.408     7.641     0.200
     0.408     7.523     0.200
     0.500     9.484     0.200
     0.503     9.484     0.200
     0.766    14.945     0.200
     0.766    14.625     0.200
     0.982    18.516     0.200
     1.070    19.367     0.200
     1.070    19.047     0.200
     1.151    19.883     0.200
     1.151    19.992     0.200
     1.153    21.188     0.200
     1.153    21.016     0.200
     1.245    22.375     0.200
     1.269    23.164     0.200
     1.269    23.695     0.200
     1.310    24.141     0.200
     1.310    23.867     0.200
     1.414    26.406     0.200
     1.352    24.625     0.200
     1.352    24.211     0.200
     1.407    24.391     0.200
     1.414    26.258     0.200
     1.549    26.656     0.200
     1.587    27.383     0.200
     1.587    27.742     0.200
     1.810    31.961     0.200
     4.252    76.516     0.200
     4.808    87.961     0.200
     0.497     9.016     0.200
     0.736    13.195     0.200
     0.940    16.477     0.200
     0.995    19.094     0.200
     1.057    18.969     0.200
     1.177    20.094     0.200
     1.256    23.312     0.200
     1.437    24.375     0.200
     1.518    25.977     0.200
     1.552    26.695     0.200
     1.669    29.094     0.200
     1.698    29.555     0.200
     0.486     8.742     0.200
     0.645    11.562     0.200
     0.978    17.117     0.200
     1.287    23.602     0.200
     1.356    24.617     0.200
     1.495    25.586     0.200
     1.592    27.883     0.200
     1.631    27.422     0.200
     1.746    31.070     0.200
     1.751    30.156     0.200
     0.739    13.258     0.200
     0.871    14.898     0.200
     0.945    16.875     0.200
     0.991    18.047     0.200
     1.051    19.203     0.200
     1.261    23.703     0.200
     1.441    26.359     0.200
     1.544    28.016     0.200
     1.521    26.039     0.200
     1.555    26.398     0.200
     1.671    30.016     0.200
     1.702    30.156     0.200
     0.955    17.086     0.200
     1.270    23.586     0.200
     1.321    24.352     0.200
     1.805    32.359     0.200
     0.517     9.078     0.200
     0.669    11.719     0.200
     0.824    13.898     0.200
     0.903    16.195     0.200
     0.897    16.070     0.200
     0.997    17.242     0.200
     1.146    20.945     0.200
     1.357    22.727     0.200
     1.433    26.055     0.200
     1.468    25.828     0.200
     1.524    25.875     0.200
     1.652    27.898     0.200
     1.728    30.922     0.200
     1.784    31.898     0.200
     1.927    33.961     0.200
     0.718    12.930     0.200
     0.923    15.836     0.200
     0.992    16.289     0.200
     1.002    18.430     0.200
     1.016    18.875     0.200
     1.307    24.039     0.200
     1.358    24.625     0.200
     1.492    26.844     0.200
     1.608    27.500     0.200
     1.754    30.438     0.200
     1.772    31.539     0.200
     2.675    46.664     0.200
     0.473     8.641     0.200
     0.642    10.617     0.200
     0.774    12.938     0.200
     0.887    15.836     0.200
     0.960    16.336     0.200
     1.097    20.656     0.200
     1.107    19.016     0.200
     1.327    22.602     0.200
     1.485    25.070     0.200
     1.613    26.906     0.200
     1.683    29.766     0.200
     1.753    31.516     0.200
     1.772    31.000     0.200
     1.897    32.961     0.200
     1.912    33.617     0.200
     1.959    34.617     0.200
     2.594    46.320     0.200
     2.715    48.461     0.200
     3.205    55.445     0.200
     0.480     8.477     0.200
     1.115    21.117     0.200
     1.400    25.562     0.200
     1.504    25.945     0.200
     1.788    30.477     0.200
     5.410    98.062     0.200
     0.474     8.336     0.200
     0.647    10.969     0.200
     1.103    20.648     0.200
     1.491    25.211     0.200
     1.777    30.625     0.200
     0.531     8.773     0.200
     0.718    11.797     0.200
     0.861    14.398     0.200
     1.042    19.555     0.200
     1.141    19.703     0.200
     1.191    20.453     0.200
     1.219    20.656     0.200
     1.331    23.453     0.200
     1.389    22.883     0.200
     1.517    24.898     0.200
     1.601    28.266     0.200
     1.662    30.133     0.200
     1.687    30.766     0.200
     1.660    28.359     0.200
     1.789    30.609     0.200
     1.830    31.578     0.200
     0.470     8.414     0.200
     0.650    10.586     0.200
     1.102    20.664     0.200
     1.387    25.508     0.200
     1.450    25.047     0.200
     1.492    25.383     0.200
     1.620    27.164     0.200
     1.689    30.359     0.200
     1.780    30.484     0.200
     5.420    97.977     0.200
     0.507     8.680     0.200
     0.803    13.875     0.200
     1.227    22.844     0.200
     1.386    24.344     0.200
     1.644    27.367     0.200
     5.266    94.930     0.200
     0.509     8.807     0.200
     0.793    13.667     0.200
     0.809    14.567     0.200
     0.901    16.007     0.200
     0.939    17.717     0.200
     1.112    18.797     0.200
     1.075    19.617     0.200
     1.222    22.607     0.200
     1.251    21.627     0.200
     1.448    24.647     0.200
     1.479    25.447     0.200
     1.636    26.937     0.200
     1.904    33.437     0.200
     5.275    95.537     0.200
     0.534     9.325     0.200
     0.685    11.795     0.200
     1.171    21.555     0.200
     1.123    21.035     0.200
     1.544    25.955     0.200
     1.812    31.655     0.200
     0.501     8.846     0.200
     0.736    13.166     0.200
     0.872    14.856     0.200
     0.944    16.186     0.200
     0.994    18.646     0.200
     1.053    19.166     0.200
     1.261    23.556     0.200
     1.521    25.906     0.200
     1.543    28.186     0.200
     1.556    26.726     0.200
     1.672    29.026     0.200
     1.702    28.116     0.200
     1.881    33.486     0.200
     1.823    31.346     0.200
     0.489     8.572     0.200
     0.585     9.643     0.200
     0.742    11.982     0.200
     0.928    17.152     0.200
     0.934    16.763     0.200
     1.066    19.383     0.200
     1.241    20.963     0.200
     1.272    21.662     0.200
     1.230    22.322     0.200
     1.385    24.062     0.200
     1.435    23.522     0.200
     1.697    30.202     0.200
     1.715    29.062     0.200
     0.483     8.371     0.200
     0.619    10.271     0.200
     0.764    12.360     0.200
     0.941    15.801     0.200
     0.909    16.381     0.200
     0.930    17.591     0.200
     1.088    19.570     0.200
     1.275    21.681     0.200
     1.206    21.831     0.200
     1.305    22.201     0.200
     1.373    25.101     0.200
     1.419    24.980     0.200
     1.668    29.820     0.200
     1.724    31.221     0.200
     1.749    29.641     0.200
     0.510     9.145     0.200
     0.756    13.594     0.200
     0.859    14.854     0.200
     0.943    15.834     0.200
     1.048    19.404     0.200
     1.260    23.055     0.200
     1.302    21.694     0.200
     1.511    25.534     0.200
     1.544    25.994     0.200
     1.544    28.134     0.200
     1.659    28.454     0.200
     1.694    28.284     0.200
     1.821    30.384     0.200
     1.836    32.174     0.200
     0.480     8.521     0.200
     0.585    10.001     0.200
     0.736    12.501     0.200
     0.906    15.661     0.200
     0.928    16.681     0.200
     0.937    17.730     0.200
     1.059    17.881     0.200
     1.060    19.181     0.200
     1.236    22.521     0.200
     1.716    29.451     0.200
     2.504    45.440     0.200
     0.564    10.102     0.200
     0.597    10.142     0.200
     0.805    13.241     0.200
     0.851    15.831     0.200
     0.938    16.001     0.200
     0.986    17.642     0.200
     1.110    18.201     0.200
     1.129    20.422     0.200
     1.263    21.562     0.200
     1.286    22.021     0.200
     1.393    24.621     0.200
     1.467    24.571     0.200
     1.596    27.021     0.200
     0.570     9.467     0.200
     0.527    10.025     0.200
     1.083    19.945     0.200
     1.185    20.605     0.200
     1.432    24.355     0.200
     0.493     8.686     0.200
     0.653    11.146     0.200
     0.895    16.156     0.200
     1.120    21.137     0.200
     1.405    25.666     0.200
     1.453    25.336     0.200
     1.502    26.127     0.200
     1.703    30.717     0.200
     1.758    30.896     0.200
     1.775    31.967     0.200
     1.782    31.217     0.200
     1.932    33.537     0.200
     0.510     8.990     0.200
     0.740    13.311     0.200
     0.877    15.350     0.200
     0.989    18.760     0.200
     1.188    20.070     0.200
     1.269    23.820     0.200
     1.315    23.150     0.200
     1.448    24.551     0.200
     1.709    29.131     0.200
     0.489     8.670     0.200
     0.626    10.340     0.200
     1.098    19.959     0.200
     1.475    24.979     0.200
     1.755    30.379     0.200
     0.512     9.059     0.200
     0.618    10.668     0.200
     1.108    20.379     0.200
     1.224    20.879     0.200
     1.474    25.078     0.200
     1.746    30.418     0.200
     1.910    33.355     0.200
     0.609    10.160     0.200
     0.926    16.969     0.200
     1.085    19.809     0.200
     1.207    21.488     0.200
     1.370    25.188     0.200
     1.409    24.207     0.200
     1.459    25.340     0.200
     1.586    26.438     0.200
     1.737    31.539     0.200
     1.739    30.117     0.200
     0.568    10.164     0.200
     0.878    14.734     0.200
     0.927    16.434     0.200
     1.037    17.934     0.200
     0.849    15.695     0.200
     1.202    23.062     0.200
     1.199    20.035     0.200
     1.318    22.945     0.200
     1.487    27.273     0.200
     1.495    26.535     0.200
     1.565    27.004     0.200
     1.854    33.684     0.200
     1.822    31.766     0.200
     0.505     8.980     0.200
     0.873    15.223     0.200
     0.990    18.473     0.200
     1.049    19.281     0.200
     1.183    20.070     0.200
     1.264    23.723     0.200
     1.547    28.000     0.200
     1.673    28.832     0.200
     1.705    28.621     0.200
     1.884    33.293     0.200
     1.822    31.359     0.200
     0.511     8.617     0.200
     0.632    10.488     0.200
     0.901    16.988     0.200
     0.961    16.219     0.200
     0.922    16.730     0.200
     1.118    20.070     0.200
     1.320    22.309     0.200
     1.403    25.469     0.200
     1.488    24.559     0.200
     1.760    30.707     0.200
     1.891    32.668     0.200
     0.861    16.516     0.200
     1.153    20.637     0.200
     1.438    26.215     0.200
     1.440    25.414     0.200
     1.508    24.324     0.200
     1.637    27.535     0.200
     1.767    29.727     0.200
     0.507     9.203     0.200
     0.774    13.645     0.200
     0.822    14.824     0.200
     0.888    15.145     0.200
     0.933    17.695     0.200
     1.094    18.684     0.200
     1.210    22.695     0.200
     1.619    26.953     0.200
     1.746    29.113     0.200
     0.507     9.039     0.200
     0.782    13.617     0.200
     0.816    14.699     0.200
     0.893    15.156     0.200
     0.936    17.668     0.200
     1.101    18.816     0.200
     1.082    19.637     0.200
     1.214    22.656     0.200
     1.626    26.969     0.200
     0.461     8.250     0.200
     0.640    10.984     0.200
     0.880    15.953     0.200
     0.951    17.633     0.200
     1.088    20.555     0.200
     1.292    21.750     0.200
     1.325    22.391     0.200
     1.373    25.414     0.200
     1.440    24.953     0.200
     1.480    24.922     0.200
     1.608    27.023     0.200
     1.676    29.492     0.200
     1.730    30.734     0.200
     1.088    19.727     0.200
     0.438     7.625     0.200
     0.629    10.242     0.200
     1.062    19.773     0.200
     1.231    22.125     0.200
     1.461    24.086     0.200
     1.760    30.414     0.200
     3.716    67.016     0.200
     0.714    12.771     0.200
     0.859    15.141     0.200
     0.912    15.691     0.200
     1.227    23.061     0.200
     1.280    21.730     0.200
     1.509    27.851     0.200
     1.502    25.431     0.200
     1.539    25.971     0.200
     1.658    28.371     0.200
     1.679    27.951     0.200
     2.834    49.911     0.200
     2.910    51.490     0.200
     0.494     8.723     0.200
     0.748    13.402     0.200
     0.852    14.493     0.200
     0.928    15.922     0.200
     0.987    18.663     0.200
     1.065    19.312     0.200
     1.245    23.223     0.200
     1.289    22.402     0.200
     1.536    26.223     0.200
     1.683    27.862     0.200
     1.844    31.592     0.200
     0.479     8.316     0.200
     0.588     9.906     0.200
     0.737    12.105     0.200
     0.909    15.387     0.200
     0.925    16.805     0.200
     0.937    17.707     0.200
     1.061    19.387     0.200
     1.234    22.164     0.200
     1.435    23.785     0.200
     1.563    26.344     0.200
     1.719    29.355     0.200
     0.511     8.891     0.200
     0.643    10.898     0.200
     0.916    16.680     0.200
     0.901    17.070     0.200
     0.971    16.484     0.200
     1.126    20.609     0.200
     1.127    18.477     0.200
     1.169    21.289     0.200
     1.302    22.141     0.200
     1.498    25.086     0.200
     1.626    27.086     0.200
     1.703    30.234     0.200
     1.771    30.648     0.200
     0.495     8.654     0.200
     0.777    13.964     0.200
     0.817    14.234     0.200
     0.908    15.144     0.200
     0.966    18.174     0.200
     1.076    19.554     0.200
     1.227    23.284     0.200
     1.469    24.684     0.200
     1.502    25.324     0.200
     1.617    27.844     0.200
     1.654    27.874     0.200
     1.780    29.754     0.200
     1.838    32.584     0.200
     1.885    33.744     0.200
     1.878    33.274     0.200
     0.526     9.754     0.200
     0.722    12.943     0.200
     0.914    15.943     0.200
     0.983    16.623     0.200
     1.000    18.725     0.200
     1.022    18.693     0.200
     1.299    24.373     0.200
     1.349    22.844     0.200
     1.745    28.895     0.200
     1.782    31.314     0.200
     0.567    10.137     0.200
     0.598    10.098     0.200
     1.131    20.375     0.200
     1.173    21.715     0.200
     1.721    29.426     0.200
     1.858    34.418     0.200
     0.557     9.980     0.200
     0.597    10.039     0.200
     0.800    13.020     0.200
     0.937    15.859     0.200
     0.858    16.371     0.200
     0.980    17.699     0.200
     1.124    20.352     0.200
     1.262    21.199     0.200
     1.179    21.730     0.200
     1.394    24.141     0.200
     1.466    24.391     0.200
     1.594    26.832     0.200
     1.721    29.980     0.200
     1.866    33.852     0.200
     2.554    45.191     0.200
     0.533     9.840     0.200
     0.621    10.020     0.200
     1.125    20.871     0.200
     1.173    21.691     0.200
     1.483    24.863     0.200
     0.484     8.781     0.200
     0.628    10.719     0.200
     0.772    12.602     0.200
     0.950    16.039     0.200
     0.904    16.320     0.200
     0.928    17.680     0.200
     1.096    19.828     0.200
     1.198    21.852     0.200
     1.476    24.305     0.200
     1.604    26.766     0.200
     1.758    29.516     0.200
     0.490     8.457     0.200
     0.637    10.757     0.200
     0.783    12.747     0.200
     0.903    16.407     0.200
     0.960    16.297     0.200
     0.922    17.127     0.200
     1.035    19.647     0.200
     1.107    20.457     0.200
     1.187    21.447     0.200
     1.294    21.627     0.200
     1.324    22.387     0.200
     1.392    25.327     0.200
     1.486    24.877     0.200
     1.688    29.427     0.200
     1.743    30.867     0.200
     1.767    30.507     0.200
     1.916    32.697     0.200
     1.943    35.527     0.200
     0.660    10.965     0.200
     0.786    13.766     0.200
     0.978    16.793     0.200
     1.110    21.133     0.200
     1.313    22.285     0.200
     1.345    22.926     0.200
     1.395    26.383     0.200
     1.503    25.273     0.200
     1.630    27.414     0.200
     1.790    30.484     0.200
     1.927    33.746     0.200
     1.972    33.625     0.200
     0.577    10.281     0.200
     0.716    11.891     0.200
     0.895    15.602     0.200
     0.843    15.742     0.200
     0.924    16.641     0.200
     1.055    17.938     0.200
     1.074    20.305     0.200
     1.075    19.719     0.200
     1.219    22.594     0.200
     1.381    23.242     0.200
     1.405    23.820     0.200
     1.504    27.523     0.200
     1.583    26.461     0.200
     1.712    28.688     0.200
     1.794    31.180     0.200
     1.852    32.883     0.200
     1.838    31.312     0.200
     1.872    33.898     0.200
     1.930    34.680     0.200
     0.616    10.650     0.200
     0.608    10.880     0.200
     1.172    21.170     0.200
     1.495    24.980     0.200
     1.732    30.120     0.200
     1.835    33.390     0.200
     1.950    33.840     0.200
     2.064    36.590     0.200
     0.429     7.859     0.200
     0.649    11.445     0.200
     1.071    20.242     0.200
     1.478    24.781     0.200
     0.501     8.785     0.200
     0.745    13.184     0.200
     0.862    14.574     0.200
     0.938    15.703     0.200
     0.907    17.402     0.200
     0.987    18.594     0.200
     1.172    19.484     0.200
     1.255    23.395     0.200
     1.511    25.203     0.200
     1.693    27.664     0.200
     1.873    33.523     0.200
     1.917    34.086     0.200
     1.921    34.605     0.200
     1.834    31.902     0.200
     1.255    23.602     0.200
     0.450     7.793     0.200
     0.600    10.412     0.200
     1.049    19.104     0.200
     1.437    24.582     0.200
     1.731    29.863     0.200
     1.861    31.943     0.200
     1.951    34.443     0.200
     1.049    19.691     0.200
     0.492     9.119     0.200
     0.636    11.000     0.200
     0.783    12.680     0.200
     0.960    16.510     0.200
     0.905    16.260     0.200
     0.920    17.160     0.200
     1.107    20.100     0.200
     1.037    19.609     0.200
     1.293    22.420     0.200
     1.486    25.699     0.200
     1.614    27.131     0.200
     1.765    30.131     0.200
     1.941    34.170     0.200
     0.465     8.396     0.200
     0.589     9.777     0.200
     1.052    19.607     0.200
     1.431    24.127     0.200
     1.720    29.527     0.200
     1.859    32.207     0.200
     1.844    31.197     0.200
     1.934    34.877     0.200
     0.441     7.752     0.200
     0.578     9.541     0.200
     1.023    19.211     0.200
     1.411    24.150     0.200
     1.709    29.211     0.200
     1.709    29.082     0.200
     1.835    31.752     0.200
     1.946    34.742     0.200
     1.023    19.699     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.326    68.109     0.200
     1.791    56.219     0.200
     1.821    54.184     0.200
     1.890    56.203     0.200
     2.613    73.812     0.200
     1.786    53.555     0.200
     1.880    55.676     0.200
     2.493    72.562     0.200
     2.603    74.223     0.200
     3.626    99.234     0.200
     1.734    52.898     0.200
     1.762    53.930     0.200
     2.404    70.438     0.200
     2.382    68.598     0.200
     3.327    92.528     0.200
     3.425    94.948     0.200
     1.528    47.566     0.200
     1.885    56.766     0.200
     2.033    59.566     0.200
     2.244    65.438     0.200
     1.633    51.578     0.200
     1.727    52.680     0.200
     2.386    70.648     0.200
     3.938   107.148     0.200
     4.827   130.379     0.200
     1.952    58.641     0.200
     1.588    50.148     0.200
     1.603    50.711     0.200
     2.295    67.719     0.200
     3.852   104.102     0.200
     2.372    69.371     0.200
     2.363    69.164     0.200
     2.411    69.527     0.200
     1.714    54.104     0.200
     1.800    55.703     0.200
     2.305    67.572     0.200
     3.930   108.922     0.200
     4.209   116.104     0.200
     5.108   140.445     0.200
    12.115   311.201     0.200
     1.713    53.785     0.200
     1.722    53.887     0.200
     1.812    55.285     0.200
     2.530    73.086     0.200
     1.852    57.766     0.200
     2.304    69.145     0.200
     2.304    67.676     0.200
     2.668    77.215     0.200
     2.814    80.625     0.200
     1.744    54.148     0.200
     2.276    66.766     0.200
     2.721    77.605     0.200
     3.205    89.559     0.200
     3.312    92.566     0.200
     8.568   218.258     0.200
    12.082   310.445     0.200
     1.506    47.523     0.200
     2.307    68.109     0.200
     2.378    69.820     0.200
     2.518    72.594     0.200
     3.300    91.602     0.200
     3.998   108.438     0.200
     3.874   106.410     0.200
     5.689   148.727     0.200
     2.440    72.988     0.200
     3.850   106.340     0.200
     1.163    37.945     0.200
     2.292    66.883     0.200
     2.780    79.031     0.200
     3.960   108.867     0.200
     8.600   218.195     0.200
    10.118   262.070     0.200
     2.307    66.867     0.200
     2.307    68.930     0.200
     2.783    80.609     0.200
     3.973   109.031     0.200
     8.616   218.133     0.200
     9.997   256.453     0.200
    10.117   262.555     0.200
     2.294    67.984     0.200
     2.546    75.008     0.200
     3.956   108.156     0.200
     8.597   219.211     0.200
     1.570    49.922     0.200
     2.277    68.480     0.200
     2.789    83.461     0.200
     3.932   108.422     0.200
     8.571   219.922     0.200
     8.571   219.191     0.200
     1.557    49.750     0.200
     2.295    68.680     0.200
     2.295    68.016     0.200
     3.949   108.852     0.200
     2.155    62.664     0.200
     2.789    80.641     0.200
     1.341    44.750     0.200
     1.491    47.734     0.200
     1.720    52.836     0.200
     1.518    48.039     0.200
     1.616    50.438     0.200
     1.676    52.609     0.200
     1.896    57.359     0.200
     1.915    58.391     0.200
     2.353    69.070     0.200
     2.238    66.648     0.200
     3.146    89.859     0.200
     3.433    95.180     0.200
     1.378    44.992     0.200
     1.429    45.480     0.200
     1.467    46.391     0.200
     1.850    56.383     0.200
     2.517    73.031     0.200
     1.734    54.289     0.200
     2.356    70.179     0.200
     2.625    75.399     0.200
     3.217    89.938     0.200
     3.900   107.509     0.200
     3.900   107.829     0.200
     4.586   123.079     0.200
     5.107   133.938     0.200
     1.549    48.147     0.200
     1.823    55.207     0.200
     2.398    70.497     0.200
     2.398    69.707     0.200
     2.580    75.167     0.200
     3.171    87.178     0.200
     3.893   106.128     0.200
     4.542   122.638     0.200
     1.347    43.438     0.200
     2.373    69.406     0.200
     2.902    79.787     0.200
     3.196    88.287     0.200
     3.892   107.098     0.200
     8.560   218.227     0.200
     1.696    53.373     0.200
     3.878   105.023     0.200
     1.610    51.932     0.200
     1.807    56.602     0.200
     1.807    56.730     0.200
     2.043    62.531     0.200
     2.145    65.611     0.200
     2.291    69.361     0.200
     2.398    71.301     0.200
     2.391    70.080     0.200
     1.683    52.922     0.200
     1.782    56.512     0.200
     1.854    58.262     0.200
     1.869    58.242     0.200
     2.335    68.199     0.200
     1.691    51.664     0.200
     2.319    67.570     0.200
     2.397    70.328     0.200
     1.719    53.633     0.200
     1.756    55.453     0.200
     1.756    55.324     0.200
     1.829    57.232     0.200
     1.930    59.189     0.200
     2.177    65.553     0.200
     2.172    65.445     0.200
     2.330    70.043     0.200
     2.330    69.377     0.200
     2.700    78.266     0.200
     3.982   108.842     0.200
     1.700    53.787     0.200
     1.756    54.896     0.200
     1.838    58.348     0.200
     2.375    70.566     0.200
     4.016   110.436     0.200
     1.749    54.783     0.200
     4.020   111.094     0.200
     4.689   126.283     0.200
     7.190   184.508     0.200
     2.216    65.699     0.200
     2.308    69.121     0.200
     3.898   106.820     0.200
     1.369    43.762     0.200
     1.369    43.898     0.200
     1.505    48.961     0.200
     1.654    51.492     0.200
     1.751    52.934     0.200
     2.265    67.051     0.200
     2.265    67.520     0.200
     2.643    76.699     0.200
     2.882    82.656     0.200
     3.234    89.801     0.200
     3.221    90.641     0.200
     3.345    92.543     0.200
     3.638    99.094     0.200
     3.855   106.102     0.200
     3.926   104.992     0.200
     4.357   119.012     0.200
     4.674   124.691     0.200
     5.158   134.391     0.200
     5.256   139.051     0.200
     5.757   148.586     0.200
     8.549   217.301     0.200
     8.586   217.773     0.200
     1.686    53.319     0.200
     1.773    55.939     0.200
     2.213    66.874     0.200
     3.871   107.109     0.200
     1.756    53.711     0.200
     2.257    66.359     0.200
     2.257    66.648     0.200
     3.631    97.961     0.200
     3.800   103.039     0.200
     3.904   105.141     0.200
     4.397   116.719     0.200
     1.751    53.586     0.200
     2.252    66.477     0.200
     2.252    66.301     0.200
     2.329    68.277     0.200
     2.984    82.367     0.200
     3.206    89.266     0.200
     3.345    91.215     0.200
     3.625    98.324     0.200
     3.797   103.375     0.200
     3.797   104.629     0.200
     3.902   105.266     0.200
     4.048   108.125     0.200
     4.391   116.758     0.200
     4.661   123.625     0.200
     1.613    51.117     0.200
     1.613    50.547     0.200
     2.054    62.148     0.200
     2.240    66.320     0.200
     2.285    66.633     0.200
     2.706    77.438     0.200
     3.014    83.797     0.200
     3.319    92.133     0.200
     3.365    92.250     0.200
     3.753   101.984     0.200
     3.799   104.570     0.200
     4.651   123.664     0.200
     5.184   137.555     0.200
     1.186    39.854     0.200
     1.605    50.383     0.200
     1.730    53.162     0.200
     2.242    66.562     0.200
     2.281    66.783     0.200
     3.192    89.123     0.200
     3.323    91.562     0.200
     3.749   101.693     0.200
     4.653   123.723     0.200
     1.269    41.078     0.200
     1.781    56.120     0.200
     2.399    71.899     0.200
     2.924    82.648     0.200
     3.480    97.702     0.200
     3.864   104.880     0.200
     1.502    46.787     0.200
     1.617    49.377     0.200
     1.886    56.639     0.200
     2.130    64.209     0.200
     2.257    66.412     0.200
     2.497    73.057     0.200
     2.894    81.721     0.200
     2.848    80.336     0.200
     3.038    85.627     0.200
     3.213    89.746     0.200
     3.213    89.016     0.200
     3.310    91.129     0.200
     3.310    90.986     0.200
     3.333    91.541     0.200
     3.426    94.258     0.200
     3.820   103.307     0.200
     3.853   104.996     0.200
     4.174   113.256     0.200
     4.374   115.957     0.200
     4.677   125.605     0.200
     4.665   123.406     0.200
     5.287   139.637     0.200
     5.321   139.945     0.200
     5.559   143.596     0.200
     6.138   159.936     0.200
     7.008   179.445     0.200
     1.402    45.539     0.200
     1.791    56.355     0.200
     1.782    55.828     0.200
     1.782    56.094     0.200
     1.799    56.965     0.200
     2.181    66.113     0.200
     2.268    68.090     0.200
     2.334    69.746     0.200
     2.391    71.266     0.200
     2.391    71.465     0.200
     4.712   128.953     0.200
     5.299   143.133     0.200
     1.610    50.304     0.200
     1.672    51.284     0.200
     1.757    53.884     0.200
     1.757    53.744     0.200
     1.793    54.837     0.200
     1.880    57.086     0.200
     2.253    66.150     0.200
     2.343    67.994     0.200
     2.343    68.248     0.200
     2.650    75.363     0.200
     2.750    78.404     0.200
     2.750    78.147     0.200
     2.886    82.195     0.200
     3.030    86.134     0.200
     3.210    88.424     0.200
     3.210    90.004     0.200
     3.241    88.944     0.200
     3.309    91.044     0.200
     3.309    91.170     0.200
     3.335    90.554     0.200
     3.335    91.344     0.200
     3.419    94.228     0.200
     3.627    98.044     0.200
     3.811   103.294     0.200
     3.811   104.549     0.200
     3.920   105.494     0.200
     3.920   106.336     0.200
     4.168   112.937     0.200
     4.332   116.157     0.200
     4.378   115.994     0.200
     4.662   123.324     0.200
     4.669   125.442     0.200
     4.669   125.804     0.200
     5.279   140.104     0.200
     5.312   140.394     0.200
     6.104   157.474     0.200
     1.879    59.758     0.200
     1.880    58.203     0.200
     2.130    64.473     0.200
     2.538    74.078     0.200
     3.280    92.547     0.200
     3.654   103.902     0.200
     4.449   119.412     0.200
     4.987   137.092     0.200
     5.031   137.943     0.200
     5.045   138.293     0.200
     5.281   143.232     0.200
     5.894   157.402     0.200
     6.475   172.182     0.200
     6.547   173.633     0.200
     1.628    51.213     0.200
     1.628    50.583     0.200
     2.068    62.452     0.200
     2.243    66.361     0.200
     2.297    66.891     0.200
     2.297    66.743     0.200
     2.357    69.183     0.200
     2.357    68.933     0.200
     2.606    74.331     0.200
     2.715    77.383     0.200
     2.982    82.883     0.200
     3.194    89.003     0.200
     3.194    88.293     0.200
     3.317    91.828     0.200
     3.317    92.283     0.200
     3.370    93.427     0.200
     3.765   101.732     0.200
     3.866   103.933     0.200
     4.625   123.402     0.200
     5.233   138.603     0.200
     5.257   139.323     0.200
     6.051   157.053     0.200
     6.089   158.312     0.200
     7.131   182.723     0.200
     1.630    52.293     0.200
     1.688    53.695     0.200
     1.837    57.605     0.200
     2.354    70.180     0.200
     2.354    71.266     0.200
     2.354    70.488     0.200
     2.354    71.445     0.200
     2.476    73.707     0.200
     2.476    74.734     0.200
     2.507    74.094     0.200
     2.711    79.531     0.200
     3.038    87.148     0.200
     3.038    87.863     0.200
     3.302    94.395     0.200
     3.436    96.043     0.200
     3.823   105.516     0.200
     3.885   108.703     0.200
     3.899   107.695     0.200
     4.006   109.922     0.200
     4.523   122.016     0.200
     4.689   127.082     0.200
     5.239   141.973     0.200
     5.284   143.863     0.200
     5.293   144.242     0.200
     6.091   160.652     0.200
     6.798   178.805     0.200
     7.194   186.965     0.200
     1.282    42.125     0.200
     1.773    55.328     0.200
     1.778    55.773     0.200
     1.778    55.891     0.200
     1.842    57.359     0.200
     1.871    59.422     0.200
     2.312    68.344     0.200
     2.312    69.125     0.200
     2.402    71.820     0.200
     2.721    78.883     0.200
     2.910    82.430     0.200
     3.290    92.719     0.200
     3.867   107.266     0.200
     4.721   128.141     0.200
     5.334   144.930     0.200
     5.383   146.555     0.200
     6.169   161.734     0.200
     1.409    44.789     0.200
     1.511    47.695     0.200
     1.514    47.438     0.200
     1.733    53.312     0.200
     1.869    57.031     0.200
     1.926    57.617     0.200
     2.133    63.242     0.200
     2.411    72.367     0.200
     4.169   113.312     0.200
     1.425    48.148     0.200
     1.756    56.742     0.200
     1.756    55.414     0.200
     1.932    60.320     0.200
     1.879    58.883     0.200
     2.476    73.016     0.200
     2.447    74.289     0.200
     0.788    27.449     0.200
     1.537    48.262     0.200
     1.606    50.359     0.200
     1.852    56.414     0.200
     2.226    65.973     0.200
     2.230    66.496     0.200
     2.327    67.871     0.200
     2.381    70.445     0.200
     2.381    69.852     0.200
     2.423    70.457     0.200
     2.540    73.805     0.200
     3.062    84.977     0.200
     3.260    92.574     0.200
     3.298    91.891     0.200
     3.317    92.223     0.200
     3.601    99.613     0.200
     3.695   102.164     0.200
     3.784   104.145     0.200
     3.973   108.070     0.200
     4.044   110.422     0.200
     4.465   118.512     0.200
     5.119   137.672     0.200
     5.973   154.871     0.200
     1.814    55.366     0.200
     1.864    56.551     0.200
     2.008    60.731     0.200
     2.111    62.900     0.200
     2.287    67.159     0.200
     2.326    68.203     0.200
     2.336    68.498     0.200
     2.516    72.588     0.200
     2.777    78.678     0.200
     3.002    84.784     0.200
     3.042    85.444     0.200
     3.292    91.388     0.200
     3.941   108.382     0.200
     1.755    54.375     0.200
     2.192    65.910     0.200
     2.352    69.223     0.200
     2.682    78.094     0.200
     2.930    84.492     0.200
     3.457    96.492     0.200
     3.875   106.531     0.200
     1.810    55.488     0.200
     1.827    55.318     0.200
     1.864    56.729     0.200
     1.864    57.030     0.200
     1.892    57.209     0.200
     1.963    59.688     0.200
     2.017    61.226     0.200
     2.296    68.967     0.200
     2.324    68.219     0.200
     2.331    68.448     0.200
     1.860    56.780     0.200
     1.411    44.545     0.200
     1.571    49.525     0.200
     1.765    53.756     0.200
     1.812    55.215     0.200
     1.812    55.051     0.200
     1.821    55.436     0.200
     1.864    56.846     0.200
     1.864    56.457     0.200
     2.219    66.455     0.200
     2.290    67.645     0.200
     2.290    67.076     0.200
     2.324    67.838     0.200
     2.334    69.105     0.200
     2.334    68.104     0.200
     2.517    73.334     0.200
     2.780    78.320     0.200
     2.882    80.365     0.200
     2.882    80.471     0.200
     3.005    84.480     0.200
     3.045    86.346     0.200
     3.045    85.236     0.200
     3.291    91.045     0.200
     3.291    92.207     0.200
     3.287    90.154     0.200
     3.563    97.703     0.200
     3.609    98.945     0.200
     3.694   101.123     0.200
     3.944   108.252     0.200
     3.981   107.465     0.200
     3.981   107.883     0.200
     3.991   109.025     0.200
     4.040   108.123     0.200
     4.108   111.801     0.200
     4.267   114.109     0.200
     4.295   115.131     0.200
     4.314   116.471     0.200
     4.475   119.346     0.200
     4.528   121.971     0.200
     4.697   124.877     0.200
     4.722   124.973     0.200
     4.752   126.490     0.200
     4.814   128.951     0.200
     4.831   129.404     0.200
     4.831   130.002     0.200
     1.086    36.111     0.200
     1.086    36.277     0.200
     1.773    56.029     0.200
     1.661    52.140     0.200
     1.713    53.070     0.200
     2.179    65.110     0.200
     2.340    68.510     0.200
     2.340    68.801     0.200
     2.693    76.945     0.200
     2.940    83.870     0.200
     3.467    96.048     0.200
     4.727   127.860     0.200
     1.322    44.281     0.200
     2.389    70.117     0.200
     2.422    70.988     0.200
     2.922    81.508     0.200
     4.792   128.588     0.200
     4.847   129.717     0.200
     5.458   143.518     0.200
     1.496    47.724     0.200
     1.488    47.546     0.200
     1.702    53.454     0.200
     1.702    53.112     0.200
     1.697    53.094     0.200
     1.872    56.934     0.200
     2.057    62.164     0.200
     2.128    64.444     0.200
     2.216    65.974     0.200
     2.216    65.828     0.200
     2.235    65.934     0.200
     2.334    67.574     0.200
     2.334    69.151     0.200
     2.391    69.834     0.200
     2.391    71.162     0.200
     2.502    73.394     0.200
     2.502    73.582     0.200
     2.507    72.144     0.200
     2.507    73.550     0.200
     2.593    74.184     0.200
     2.898    83.065     0.200
     2.916    81.194     0.200
     2.916    82.309     0.200
     3.151    87.504     0.200
     3.151    89.111     0.200
     3.163    87.754     0.200
     3.163    88.389     0.200
     3.185    88.974     0.200
     3.185    90.248     0.200
     3.205    88.434     0.200
     3.205    91.060     0.200
     3.205    88.984     0.200
     3.358    93.399     0.200
     3.636    99.554     0.200
     3.636   100.271     0.200
     3.676   101.500     0.200
     3.960   107.814     0.200
     3.960   108.442     0.200
     4.113   111.364     0.200
     4.113   112.916     0.200
     4.170   110.894     0.200
     4.307   115.054     0.200
     4.426   119.938     0.200
     4.589   124.842     0.200
     4.620   121.924     0.200
     4.620   125.196     0.200
     4.801   127.364     0.200
     4.801   130.375     0.200
     4.815   130.323     0.200
     4.866   130.856     0.200
     4.916   131.611     0.200
     5.421   141.074     0.200
     5.513   144.824     0.200
     6.283   162.264     0.200
     1.757    54.443     0.200
     2.273    68.408     0.200
     2.400    71.625     0.200
     1.325    42.578     0.200
     1.319    42.816     0.200
     1.319    41.914     0.200
     1.382    44.387     0.200
     1.425    45.590     0.200
     1.548    48.426     0.200
     1.806    54.328     0.200
     1.809    55.180     0.200
     1.861    56.648     0.200
     1.884    57.219     0.200
     1.962    58.398     0.200
     1.995    60.129     0.200
     2.263    64.879     0.200
     2.328    67.969     0.200
     2.484    71.227     0.200
     2.656    74.367     0.200
     3.088    86.328     0.200
     3.168    87.977     0.200
     3.425    94.789     0.200
     3.699    99.379     0.200
     3.945   106.648     0.200
     4.230   112.156     0.200
     4.225   114.000     0.200
     4.322   115.828     0.200
     5.408   141.906     0.200
     5.483   143.309     0.200
     1.211    40.320     0.200
     1.625    51.820     0.200
     1.754    55.602     0.200
     1.754    56.031     0.200
     1.847    57.703     0.200
     2.559    75.938     0.200
     1.713    53.859     0.200
     1.713    53.570     0.200
     1.781    55.820     0.200
     1.781    56.059     0.200
     2.024    60.988     0.200
     2.084    63.422     0.200
     2.234    67.309     0.200
     2.234    66.832     0.200
     2.383    70.484     0.200
     2.469    71.324     0.200
     2.556    74.586     0.200
     2.854    81.707     0.200
     3.103    87.699     0.200
     3.201    91.801     0.200
     3.201    89.496     0.200
     3.630   100.746     0.200
     3.628   100.266     0.200
     3.929   108.238     0.200
     4.074   112.609     0.200
     4.380   118.789     0.200
     4.773   130.480     0.200
     5.389   146.738     0.200
     5.391   144.918     0.200
     5.473   147.441     0.200
     5.972   156.895     0.200
     7.279   188.371     0.200
     9.362   240.238     0.200
     3.157    88.631     0.200
     1.335    43.148     0.200
     1.638    51.766     0.200
     1.708    52.242     0.200
     2.110    62.820     0.200
     2.259    66.633     0.200
     2.259    66.781     0.200
     2.266    66.531     0.200
     2.422    68.156     0.200
     2.369    69.062     0.200
     2.369    69.500     0.200
     2.446    71.531     0.200
     2.446    71.844     0.200
     2.601    75.227     0.200
     3.211    89.898     0.200
     3.331    92.609     0.200
     3.370    92.250     0.200
     3.781   103.812     0.200
     4.116   111.914     0.200
     4.281   115.695     0.200
     4.520   122.281     0.200
     4.420   118.406     0.200
     4.560   122.859     0.200
     4.597   124.570     0.200
     1.640    51.430     0.200
     2.254    66.602     0.200
     2.261    67.578     0.200
     2.312    68.766     0.200
     2.364    70.141     0.200
     2.607    75.320     0.200
     2.838    81.062     0.200
     3.373    93.859     0.200
     3.779   104.070     0.200
     1.342    42.062     0.200
     1.641    49.766     0.200
     1.956    58.266     0.200
     2.011    56.805     0.200
     1.622    51.225     0.200
     2.263    67.961     0.200
     2.357    69.250     0.200
     3.042    85.742     0.200
     3.824   105.000     0.200
     3.932   106.852     0.200
     1.577    48.427     0.200
     1.825    55.417     0.200
     1.919    58.097     0.200
     1.957    58.737     0.200
     2.244    66.537     0.200
     2.291    67.257     0.200
     2.265    67.407     0.200
     2.447    70.897     0.200
     2.509    72.117     0.200
     2.691    75.687     0.200
     3.131    87.417     0.200
     3.210    89.667     0.200
     3.229    90.447     0.200
     3.909   105.907     0.200
     4.045   109.417     0.200
     4.756   127.697     0.200
     5.373   141.787     0.200
     5.442   144.147     0.200
     6.220   161.117     0.200
     0.644    23.125     0.200
     0.702    24.615     0.200
     0.967    32.506     0.200
     1.671    51.715     0.200
     1.676    51.852     0.200
     5.100   136.793     0.200
     8.626   218.293     0.200
     8.626   219.434     0.200
     1.678    51.863     0.200
     1.669    52.141     0.200
     1.751    53.770     0.200
     1.820    55.762     0.200
     1.860    56.902     0.200
     1.944    58.961     0.200
     1.941    59.211     0.200
     2.787    79.191     0.200
     3.982   108.301     0.200
     1.918    58.461     0.200
     2.192    64.771     0.200
     2.471    71.912     0.200
     3.796   102.961     0.200
     5.339   140.332     0.200
     1.237    39.781     0.200
     1.366    44.102     0.200
     1.374    44.340     0.200
     1.372    43.359     0.200
     1.517    47.051     0.200
     1.825    54.961     0.200
     1.881    56.551     0.200
     1.454    47.285     0.200
     2.140    63.277     0.200
     1.678    52.855     0.200
     1.710    53.605     0.200
     1.900    56.665     0.200
     2.005    61.015     0.200
     2.255    68.075     0.200
     2.466    73.045     0.200
     2.667    78.565     0.200
     3.038    84.565     0.200
     3.767   105.825     0.200
     1.617    51.125     0.200
     2.403    70.816     0.200
     3.655   100.027     0.200
     3.868   105.805     0.200
     4.635   124.207     0.200
     4.693   125.387     0.200
     1.810    56.416     0.200
     2.042    61.436     0.200
     2.394    71.025     0.200
     4.688   125.266     0.200
     1.307    42.219     0.200
     1.428    45.637     0.200
     1.428    45.496     0.200
     1.419    45.355     0.200
     1.659    50.648     0.200
     1.780    54.477     0.200
     1.780    54.438     0.200
     2.393    69.227     0.200
     1.115    37.688     0.200
     1.115    36.105     0.200
     1.175    39.195     0.200
     1.526    46.336     0.200
     1.536    47.055     0.200
     1.606    48.926     0.200
     1.719    51.426     0.200
     1.724    52.234     0.200
     1.693    50.895     0.200
     1.734    52.355     0.200
     1.934    57.004     0.200
     1.961    57.137     0.200
     2.008    56.586     0.200
     2.090    61.176     0.200
     2.295    64.824     0.200
     2.350    66.855     0.200
     2.416    68.414     0.200
     2.534    71.484     0.200
     4.841   128.195     0.200
     1.397    45.125     0.200
     1.738    54.703     0.200
     1.834    57.004     0.200
     2.185    65.176     0.200
     2.334    68.504     0.200
     2.334    69.453     0.200
     2.406    70.906     0.200
     3.459    96.965     0.200
     3.879   108.094     0.200
     3.966   109.477     0.200
     1.416    45.016     0.200
     1.801    55.109     0.200
     1.932    56.984     0.200
     2.015    60.336     0.200
     2.265    63.859     0.200
     2.714    74.516     0.200
     4.011   108.836     0.200
     4.806   124.859     0.200
     1.414    45.094     0.200
     1.587    49.414     0.200
     1.810    55.422     0.200
     1.939    58.164     0.200
     2.026    61.188     0.200
     2.273    68.578     0.200
     2.273    65.453     0.200
     2.253    64.625     0.200
     2.706    74.484     0.200
     4.012   108.484     0.200
     4.252   115.516     0.200
     4.808   128.141     0.200
     1.746    54.320     0.200
     1.881    59.406     0.200
     1.935    60.023     0.200
     2.119    64.766     0.200
     1.943    60.766     0.200
     1.683    53.820     0.200
     1.737    55.570     0.200
     1.753    56.867     0.200
     1.959    62.039     0.200
     2.457    74.500     0.200
     2.749    81.969     0.200
     1.326    43.516     0.200
     2.165    65.453     0.200
     1.387    45.680     0.200
     1.689    53.469     0.200
     1.932    59.055     0.200
     1.894    59.828     0.200
     2.060    62.891     0.200
     1.826    57.877     0.200
     1.904    59.007     0.200
     1.543    50.426     0.200
     1.881    59.406     0.200
     1.924    60.516     0.200
     1.823    56.796     0.200
     2.320    68.803     0.200
     2.910    83.643     0.200
     2.956    87.412     0.200
     3.190    90.013     0.200
     3.251    96.372     0.200
     3.528   101.553     0.200
     3.796   106.272     0.200
     1.373    44.621     0.200
     1.544    50.034     0.200
     1.836    57.024     0.200
     1.345    44.271     0.200
     1.413    46.151     0.200
     1.685    53.222     0.200
     1.703    53.836     0.200
     1.775    57.096     0.200
     1.552    49.410     0.200
     2.007    60.830     0.200
     2.114    64.371     0.200
     2.131    63.910     0.200
     1.662    52.707     0.200
     1.718    54.000     0.200
     1.737    54.598     0.200
     1.989    58.879     0.200
     2.106    62.168     0.200
     2.086    63.148     0.200
     2.340    67.520     0.200
     2.373    70.609     0.200
     2.518    74.930     0.200
     2.477    72.188     0.200
     2.580    77.168     0.200
     2.718    80.109     0.200
     2.890    82.930     0.200
     2.934    84.148     0.200
     1.487    48.113     0.200
     1.854    59.516     0.200
     2.005    61.363     0.200
     1.925    61.105     0.200
     2.106    64.523     0.200
     2.008    61.395     0.200
     2.192    66.215     0.200
     1.927    59.930     0.200
     1.930    59.941     0.200
     2.127    63.730     0.200
     2.110    64.109     0.200
     2.183    65.930     0.200
     2.369    70.703     0.200
     2.529    74.312     0.200
     2.594    75.871     0.200
     1.751    55.527     0.200
     2.128    64.480     0.200
     2.742    81.609     0.200
     3.242    91.570     0.200
     1.438    46.617     0.200
     1.214    41.637     0.200
     2.038    61.547     0.200
     2.477    72.598     0.200
     2.528    74.969     0.200
     3.103    89.828     0.200
     1.373    45.391     0.200
     1.676    53.648     0.200
     2.123    62.719     0.200
     1.245    41.882     0.200
     1.844    58.413     0.200
     1.061    35.707     0.200
     2.084    63.316     0.200
     1.703    54.055     0.200
     1.760    55.859     0.200
     1.227    41.004     0.200
     2.044    62.623     0.200
     2.168    66.154     0.200
     1.858    59.578     0.200
     2.027    61.688     0.200
     2.092    62.766     0.200
     1.677    53.164     0.200
     1.733    55.211     0.200
     1.392    45.267     0.200
     1.688    53.567     0.200
     1.504    48.781     0.200
     1.794    57.258     0.200
     2.621    78.430     0.200
     2.477    74.156     0.200
     7.071   183.047     0.200
     1.255    41.363     0.200
     1.693    54.094     0.200
     1.820    57.312     0.200
     2.584    77.836     0.200
     3.174    91.125     0.200
     3.669   101.840     0.200
     1.037    35.240     0.200
     1.023    34.963     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.222    38.484     0.200
     2.269    69.484     0.200
     8.640   268.109     0.200
     1.106    35.969     0.200
     1.835    56.781     0.200
     2.138    66.672     0.200
     3.945   121.969     0.200
     5.000   153.969     0.200
     1.352    40.215     0.200
     3.992   122.625     0.200
     4.664   144.824     0.200
     8.631   266.652     0.200
     1.343    40.094     0.200
     1.609    51.383     0.200
     3.988   121.984     0.200
     5.645   176.184     0.200
     0.438    14.430     0.200
     0.441    14.219     0.200
     0.706    22.562     0.200
     1.176    37.492     0.200
     1.292    39.969     0.200
     1.660    51.094     0.200
     1.829    56.469     0.200
     3.960   122.492     0.200
     4.725   146.992     0.200
     5.696   177.891     0.200
     0.263     8.918     0.200
     0.328    11.368     0.200
     1.223    38.818     0.200
     1.565    47.368     0.200
     1.823    55.318     0.200
     1.700    50.664     0.200
     4.905   150.695     0.200
     0.193     6.879     0.200
     1.105    35.578     0.200
     1.232    38.980     0.200
     4.827   150.078     0.200
     0.294     9.336     0.200
     0.345    10.938     0.200
     1.042    34.234     0.200
     1.405    44.641     0.200
     1.511    46.836     0.200
     0.327    10.453     0.200
     0.748    25.047     0.200
     1.047    34.438     0.200
     1.222    39.094     0.200
     2.407    73.133     0.200
     0.277     9.910     0.200
     0.360    12.391     0.200
     0.274     9.984     0.200
     0.564    19.445     0.200
     1.594    49.324     0.200
     1.650    51.047     0.200
     1.161    37.443     0.200
     0.865    29.586     0.200
     3.185    97.184     0.200
     5.097   157.961     0.200
     1.238    39.926     0.200
     1.377    44.445     0.200
     1.789    54.516     0.200
     5.005   155.525     0.200
     1.137    36.176     0.200
     1.348    42.926     0.200
     1.828    57.219     0.200
     5.079   157.480     0.200
     9.990   311.777     0.200
     1.371    42.617     0.200
     1.151    37.023     0.200
     1.329    42.281     0.200
     1.563    48.117     0.200
     2.526    78.438     0.200
     5.297   163.789     0.200
     1.207    37.887     0.200
     2.382    72.160     0.200
     3.874   118.238     0.200
     5.213   162.809     0.200
     5.689   176.188     0.200
     0.298     9.840     0.200
     1.013    32.668     0.200
     1.249    39.059     0.200
     3.850   118.918     0.200
     0.453    15.031     0.200
     1.734    53.227     0.200
     3.960   122.094     0.200
     5.079   157.797     0.200
     5.079   158.172     0.200
     5.825   181.297     0.200
     8.600   268.586     0.200
     0.440    14.656     0.200
     1.180    36.938     0.200
     3.973   121.898     0.200
     5.087   158.453     0.200
     5.087   157.008     0.200
     5.830   181.133     0.200
     7.623   237.828     0.200
     8.422   260.117     0.200
     8.616   269.328     0.200
     0.457    15.117     0.200
     1.162    36.945     0.200
     1.729    54.156     0.200
     5.082   157.836     0.200
     5.082   157.203     0.200
     1.139    35.770     0.200
     2.277    69.441     0.200
     5.079   158.344     0.200
     5.079   157.680     0.200
     7.639   236.992     0.200
     8.404   261.121     0.200
     8.571   266.520     0.200
    12.084   376.461     0.200
     0.465    14.938     0.200
     1.160    36.516     0.200
     1.203    39.156     0.200
     2.295    71.992     0.200
     3.949   122.586     0.200
     5.087   157.969     0.200
     8.417   260.672     0.200
     0.686    22.762     0.200
     1.243    40.221     0.200
     1.498    47.152     0.200
     1.618    50.682     0.200
     2.272    69.781     0.200
     2.296    70.512     0.200
     5.196   162.072     0.200
     1.196    37.688     0.200
     5.087   157.234     0.200
     6.152   187.578     0.200
     0.382    12.078     0.200
     0.643    21.641     0.200
     0.878    28.359     0.200
     0.939    30.023     0.200
     1.023    31.594     0.200
     1.226    39.008     0.200
     1.238    38.656     0.200
     1.227    40.164     0.200
     1.420    43.859     0.200
     1.720    53.078     0.200
     1.626    50.188     0.200
     1.808    54.141     0.200
     3.954   122.258     0.200
     5.143   158.156     0.200
     0.226     8.473     0.200
     0.226     8.031     0.200
     0.460    15.762     0.200
     0.490    17.961     0.200
     0.758    25.113     0.200
     0.800    26.711     0.200
     0.947    30.293     0.200
     1.076    35.051     0.200
     1.125    36.074     0.200
     1.167    36.852     0.200
     1.345    41.293     0.200
     1.366    43.141     0.200
     1.580    47.691     0.200
     1.733    54.742     0.200
     5.282   164.281     0.200
     0.373    12.909     0.200
     0.776    24.999     0.200
     0.959    30.949     0.200
     1.194    38.009     0.200
     1.261    40.319     0.200
     1.632    49.739     0.200
     1.757    54.589     0.200
     2.242    68.129     0.200
     4.676   145.519     0.200
     5.174   160.489     0.200
     0.331    11.258     0.200
     0.331    11.428     0.200
     0.534    17.917     0.200
     0.812    26.438     0.200
     0.867    28.768     0.200
     0.979    31.417     0.200
     1.227    38.897     0.200
     1.227    38.737     0.200
     1.313    41.088     0.200
     1.283    41.088     0.200
     1.590    50.088     0.200
     1.801    55.567     0.200
     2.020    62.647     0.200
     3.950   120.027     0.200
     5.219   161.798     0.200
     0.239     8.316     0.200
     0.356    11.697     0.200
     0.789    25.527     0.200
     0.789    25.246     0.200
     0.893    29.627     0.200
     0.963    30.967     0.200
     0.963    30.857     0.200
     1.205    37.768     0.200
     1.205    37.967     0.200
     1.266    40.486     0.200
     1.266    40.627     0.200
     1.575    48.146     0.200
     1.777    55.787     0.200
     2.902    88.617     0.200
     5.194   162.178     0.200
     5.712   174.336     0.200
     6.612   200.537     0.200
     8.560   266.297     0.200
     0.548    16.863     0.200
     0.548    17.414     0.200
     0.548    17.305     0.200
     0.613    20.135     0.200
     0.613    20.004     0.200
     0.845    27.443     0.200
     1.004    32.914     0.200
     1.038    33.283     0.200
     1.083    34.994     0.200
     1.136    36.555     0.200
     1.382    43.635     0.200
     1.380    43.594     0.200
     1.608    50.113     0.200
     1.769    54.074     0.200
     1.783    55.344     0.200
     1.892    58.354     0.200
     2.182    67.344     0.200
     2.749    84.734     0.200
     5.013   156.344     0.200
     0.257     8.080     0.200
     0.340    10.750     0.200
     0.340    11.061     0.200
     0.588    20.471     0.200
     0.867    29.041     0.200
     0.923    27.182     0.200
     0.962    29.932     0.200
     1.072    35.631     0.200
     1.214    38.320     0.200
     1.267    40.320     0.200
     1.408    45.320     0.200
     1.533    47.730     0.200
     1.550    48.951     0.200
     1.581    48.371     0.200
     1.625    50.820     0.200
     1.692    51.541     0.200
     1.711    52.631     0.200
     1.711    53.451     0.200
     1.823    56.400     0.200
     2.391    73.090     0.200
     5.222   162.420     0.200
     0.789    25.500     0.200
     0.985    31.301     0.200
     1.021    31.941     0.200
     1.086    33.762     0.200
     1.216    38.430     0.200
     1.266    40.680     0.200
     1.300    40.340     0.200
     1.668    51.191     0.200
     1.736    54.051     0.200
     2.781    84.793     0.200
     0.234     8.328     0.200
     0.332    11.344     0.200
     0.584    21.008     0.200
     0.531    17.195     0.200
     0.801    26.445     0.200
     0.812    26.414     0.200
     0.870    28.805     0.200
     0.980    31.867     0.200
     1.075    34.094     0.200
     1.165    37.594     0.200
     1.192    36.297     0.200
     1.192    36.508     0.200
     1.227    38.758     0.200
     1.227    38.539     0.200
     1.284    40.789     0.200
     1.414    44.617     0.200
     1.543    47.445     0.200
     1.593    48.477     0.200
     1.647    52.508     0.200
     1.724    53.828     0.200
     5.217   162.336     0.200
     0.177     5.953     0.200
     0.413    13.689     0.200
     0.413    13.822     0.200
     0.776    24.934     0.200
     0.776    25.463     0.200
     0.918    29.793     0.200
     0.977    31.992     0.200
     1.000    32.162     0.200
     1.000    32.373     0.200
     1.202    37.953     0.200
     1.202    38.141     0.200
     1.261    40.291     0.200
     1.283    41.090     0.200
     1.295    41.873     0.200
     1.410    44.912     0.200
     1.315    41.393     0.200
     1.531    48.812     0.200
     1.667    51.863     0.200
     1.851    57.293     0.200
     2.130    66.893     0.200
     2.184    68.137     0.200
     2.557    78.867     0.200
     0.342    11.867     0.200
     1.087    34.877     0.200
     1.275    41.076     0.200
     1.289    41.086     0.200
     1.331    41.957     0.200
     1.893    58.117     0.200
     1.907    58.688     0.200
     5.101   158.047     0.200
     0.398    12.285     0.200
     0.776    24.506     0.200
     0.955    30.246     0.200
     1.009    31.666     0.200
     1.016    31.885     0.200
     1.107    34.375     0.200
     1.204    38.736     0.200
     1.238    38.006     0.200
     1.321    40.977     0.200
     1.308    41.666     0.200
     1.435    45.625     0.200
     1.706    52.516     0.200
     1.758    54.236     0.200
     1.795    55.525     0.200
     1.869    57.416     0.200
     1.891    58.346     0.200
     2.315    70.756     0.200
     0.155     5.055     0.200
     0.393    12.924     0.200
     0.425    14.016     0.200
     0.425    14.014     0.200
     0.689    24.184     0.200
     0.790    26.305     0.200
     0.790    26.014     0.200
     0.943    30.895     0.200
     1.027    33.225     0.200
     1.218    38.363     0.200
     1.218    39.508     0.200
     1.240    38.924     0.200
     1.275    40.992     0.200
     1.320    41.984     0.200
     1.443    45.613     0.200
     1.696    52.854     0.200
     1.696    52.715     0.200
     1.868    58.443     0.200
     2.769    84.994     0.200
     3.657   113.215     0.200
     5.085   158.840     0.200
     5.863   182.564     0.200
    12.150   380.090     0.200
     0.421    13.191     0.200
     0.732    23.512     0.200
     0.890    27.859     0.200
     0.929    29.371     0.200
     1.152    35.793     0.200
     1.257    39.660     0.200
     1.228    39.141     0.200
     1.626    50.160     0.200
     1.673    51.730     0.200
     1.676    52.312     0.200
     1.712    52.840     0.200
     1.801    55.582     0.200
     3.303   102.359     0.200
     0.211     7.523     0.200
     0.377    12.402     0.200
     0.377    12.641     0.200
     0.491    16.344     0.200
     0.491    15.660     0.200
     0.491    16.812     0.200
     0.491    15.559     0.200
     0.635    22.613     0.200
     0.705    22.148     0.200
     0.780    25.191     0.200
     0.861    26.641     0.200
     0.998    31.883     0.200
     0.974    31.613     0.200
     0.974    30.961     0.200
     0.974    31.246     0.200
     1.038    32.738     0.200
     1.133    36.023     0.200
     1.213    36.941     0.200
     1.215    38.434     0.200
     1.218    39.227     0.200
     1.201    38.141     0.200
     1.201    37.914     0.200
     1.253    38.602     0.200
     1.275    40.441     0.200
     1.396    42.504     0.200
     1.605    49.344     0.200
     1.691    53.152     0.200
     1.691    53.473     0.200
     1.762    54.801     0.200
     1.785    55.070     0.200
     1.738    54.543     0.200
     1.768    55.141     0.200
     1.805    55.805     0.200
     1.873    57.320     0.200
     1.896    56.391     0.200
     2.860    87.871     0.200
     3.345   104.184     0.200
     5.158   157.918     0.200
     5.158   159.594     0.200
     5.667   176.883     0.200
     8.549   265.102     0.200
     8.586   264.992     0.200
     0.325    10.470     0.200
     0.540    17.185     0.200
     0.540    17.060     0.200
     0.552    17.420     0.200
     0.552    17.807     0.200
     0.618    19.970     0.200
     0.747    23.130     0.200
     0.747    22.902     0.200
     0.844    27.239     0.200
     1.042    32.670     0.200
     1.113    36.177     0.200
     1.124    35.499     0.200
     1.136    36.029     0.200
     1.619    50.359     0.200
     1.619    50.817     0.200
     1.625    51.279     0.200
     1.625    51.075     0.200
     1.639    51.269     0.200
     1.686    52.741     0.200
     1.716    52.470     0.200
     1.758    53.890     0.200
     2.095    65.331     0.200
     2.108    66.609     0.200
     2.108    65.870     0.200
     2.270    71.430     0.200
     2.760    84.850     0.200
     2.834    87.351     0.200
     3.124    96.930     0.200
     3.186    97.729     0.200
     4.064   125.800     0.200
     4.759   147.249     0.200
     5.024   155.350     0.200
     0.374    12.625     0.200
     0.374    12.551     0.200
     0.492    16.309     0.200
     0.514    16.898     0.200
     0.681    21.449     0.200
     0.681    21.285     0.200
     0.776    25.449     0.200
     0.961    30.918     0.200
     0.961    31.070     0.200
     1.056    33.121     0.200
     1.117    35.348     0.200
     1.117    35.086     0.200
     1.194    37.812     0.200
     1.194    37.758     0.200
     1.262    40.348     0.200
     1.286    40.621     0.200
     1.286    40.406     0.200
     1.635    51.520     0.200
     1.667    52.801     0.200
     1.667    52.383     0.200
     1.754    54.359     0.200
     1.754    54.703     0.200
     1.766    54.770     0.200
     1.804    55.262     0.200
     2.989    92.051     0.200
     3.351   103.828     0.200
     4.336   134.090     0.200
     4.397   136.258     0.200
     5.530   172.570     0.200
     0.234     8.535     0.200
     0.380    12.664     0.200
     0.380    12.926     0.200
     0.486    16.227     0.200
     0.486    15.906     0.200
     0.515    16.957     0.200
     0.515    16.605     0.200
     0.515    16.750     0.200
     0.683    21.395     0.200
     0.683    20.980     0.200
     0.770    25.297     0.200
     0.956    30.965     0.200
     0.956    30.652     0.200
     0.980    29.875     0.200
     1.051    32.926     0.200
     1.051    33.059     0.200
     1.116    34.945     0.200
     1.116    35.230     0.200
     1.195    36.707     0.200
     1.197    37.973     0.200
     1.188    37.605     0.200
     1.188    37.898     0.200
     1.257    40.445     0.200
     1.280    40.547     0.200
     1.280    40.379     0.200
     1.378    42.258     0.200
     1.639    51.418     0.200
     1.667    52.715     0.200
     1.749    53.840     0.200
     1.751    53.766     0.200
     1.769    54.848     0.200
     1.798    55.141     0.200
     2.102    63.734     0.200
     2.792    85.895     0.200
     2.796    85.543     0.200
     2.867    88.066     0.200
     2.984    92.102     0.200
     3.015    93.855     0.200
     3.201    98.418     0.200
     3.345   104.027     0.200
     5.166   161.234     0.200
     5.530   172.676     0.200
     0.372    12.453     0.200
     0.372    12.430     0.200
     0.497    15.375     0.200
     0.568    17.836     0.200
     0.568    18.219     0.200
     0.628    19.297     0.200
     0.769    24.242     0.200
     0.930    29.703     0.200
     0.930    29.852     0.200
     1.064    33.305     0.200
     1.097    34.547     0.200
     1.145    35.086     0.200
     1.147    35.258     0.200
     1.181    37.203     0.200
     1.181    37.594     0.200
     1.234    39.617     0.200
     1.305    41.461     0.200
     1.547    47.125     0.200
     1.593    48.266     0.200
     1.684    53.172     0.200
     1.721    53.016     0.200
     1.730    53.523     0.200
     1.730    53.281     0.200
     1.802    55.828     0.200
     2.738    84.547     0.200
     0.284     9.764     0.200
     0.368    12.342     0.200
     0.503    16.104     0.200
     0.575    18.283     0.200
     0.619    19.184     0.200
     0.806    25.842     0.200
     0.930    29.662     0.200
     1.058    33.043     0.200
     1.106    34.383     0.200
     1.183    36.742     0.200
     1.306    41.732     0.200
     1.234    39.434     0.200
     1.312    41.373     0.200
     1.538    46.623     0.200
     1.584    47.572     0.200
     1.676    52.152     0.200
     1.713    52.123     0.200
     1.799    55.893     0.200
     2.929    88.803     0.200
     3.022    93.842     0.200
     3.985   123.873     0.200
     4.427   136.264     0.200
     5.470   169.863     0.200
     6.084   189.104     0.200
     0.431    13.950     0.200
     0.431    13.688     0.200
     0.420    14.021     0.200
     0.420    14.050     0.200
     0.468    15.547     0.200
     0.777    23.090     0.200
     0.925    30.300     0.200
     0.969    30.260     0.200
     0.969    30.423     0.200
     0.996    31.601     0.200
     0.996    32.130     0.200
     1.197    38.220     0.200
     1.232    39.170     0.200
     1.285    40.530     0.200
     1.288    40.895     0.200
     1.291    41.330     0.200
     1.322    41.400     0.200
     1.408    44.990     0.200
     1.408    44.863     0.200
     1.673    51.891     0.200
     1.673    52.180     0.200
     1.674    52.120     0.200
     1.725    53.430     0.200
     1.937    60.604     0.200
     2.190    68.586     0.200
     2.791    86.230     0.200
     2.952    90.320     0.200
     3.084    95.540     0.200
     3.302   102.430     0.200
     3.302   102.171     0.200
     4.334   133.700     0.200
     5.098   157.740     0.200
     0.212     8.236     0.200
     0.389    12.578     0.200
     0.389    13.105     0.200
     0.389    13.387     0.200
     0.480    16.066     0.200
     0.480    15.617     0.200
     0.487    15.287     0.200
     0.487    16.156     0.200
     0.648    22.137     0.200
     0.713    22.326     0.200
     0.713    22.166     0.200
     0.771    25.086     0.200
     0.771    25.307     0.200
     0.874    28.547     0.200
     0.939    30.566     0.200
     0.969    31.207     0.200
     0.969    31.062     0.200
     1.009    30.396     0.200
     1.025    32.207     0.200
     1.025    32.037     0.200
     1.192    37.834     0.200
     1.224    37.426     0.200
     1.231    39.055     0.200
     1.231    38.637     0.200
     1.265    39.646     0.200
     1.269    40.686     0.200
     1.265    40.068     0.200
     1.265    39.877     0.200
     1.617    49.896     0.200
     1.666    51.195     0.200
     1.762    53.924     0.200
     1.797    55.695     0.200
     1.794    54.906     0.200
     1.899    58.559     0.200
     2.766    84.385     0.200
     2.965    92.191     0.200
     3.127    96.725     0.200
     3.710   112.543     0.200
     3.820   118.605     0.200
     4.077   126.086     0.200
     4.358   134.057     0.200
     4.374   135.945     0.200
     4.865   150.166     0.200
     5.145   159.807     0.200
     6.753   210.275     0.200
     0.182     5.902     0.200
     0.442    14.523     0.200
     0.406    13.262     0.200
     0.406    13.832     0.200
     0.476    15.805     0.200
     0.669    23.914     0.200
     0.776    25.582     0.200
     0.776    25.055     0.200
     0.761    23.750     0.200
     0.908    29.035     0.200
     0.986    30.793     0.200
     0.986    30.285     0.200
     0.986    30.125     0.200
     0.968    31.043     0.200
     0.968    32.016     0.200
     0.994    32.074     0.200
     1.054    34.035     0.200
     1.054    33.855     0.200
     1.201    37.809     0.200
     1.201    38.074     0.200
     1.175    37.922     0.200
     1.245    39.965     0.200
     1.245    39.863     0.200
     1.245    39.684     0.200
     1.254    40.906     0.200
     1.291    40.832     0.200
     1.268    40.074     0.200
     1.271    40.559     0.200
     1.304    41.914     0.200
     1.371    44.035     0.200
     1.451    46.105     0.200
     1.656    51.332     0.200
     1.731    53.094     0.200
     1.744    53.582     0.200
     1.799    54.863     0.200
     1.839    58.152     0.200
     1.920    59.199     0.200
     2.173    67.484     0.200
     2.552    78.418     0.200
     3.306   102.785     0.200
     3.315   101.895     0.200
     3.832   118.016     0.200
     4.349   133.652     0.200
     0.220     8.054     0.200
     0.388    12.732     0.200
     0.388    12.934     0.200
     0.388    13.294     0.200
     0.496    16.024     0.200
     0.496    15.786     0.200
     0.480    15.724     0.200
     0.480    16.064     0.200
     0.645    21.364     0.200
     0.704    22.034     0.200
     0.704    22.139     0.200
     0.769    25.314     0.200
     0.935    30.074     0.200
     0.964    31.014     0.200
     1.001    30.504     0.200
     1.032    32.154     0.200
     1.135    35.844     0.200
     1.135    36.054     0.200
     1.135    35.951     0.200
     1.189    37.814     0.200
     1.215    37.024     0.200
     1.228    39.052     0.200
     1.228    38.664     0.200
     1.218    38.451     0.200
     1.259    39.884     0.200
     1.268    39.994     0.200
     1.268    39.654     0.200
     1.268    39.887     0.200
     1.264    40.354     0.200
     1.688    53.924     0.200
     1.688    52.943     0.200
     1.732    53.874     0.200
     1.732    53.674     0.200
     1.759    55.234     0.200
     1.789    55.294     0.200
     2.813    86.870     0.200
     2.970    92.014     0.200
     2.970    91.862     0.200
     4.068   126.624     0.200
     4.872   150.794     0.200
     5.150   159.334     0.200
     6.104   187.874     0.200
     6.131   190.034     0.200
     0.465    14.652     0.200
     0.479    15.023     0.200
     0.479    15.303     0.200
     0.506    16.354     0.200
     0.506    16.244     0.200
     0.676    21.592     0.200
     0.712    22.953     0.200
     0.712    23.152     0.200
     0.815    24.873     0.200
     0.786    24.877     0.200
     0.867    28.002     0.200
     0.867    27.889     0.200
     0.867    28.113     0.200
     1.025    31.662     0.200
     1.028    31.615     0.200
     1.090    34.350     0.200
     1.215    38.213     0.200
     1.215    38.342     0.200
     1.332    41.936     0.200
     1.422    45.410     0.200
     1.422    44.742     0.200
     1.464    44.252     0.200
     1.500    46.762     0.200
     1.615    49.773     0.200
     1.591    50.193     0.200
     1.591    50.035     0.200
     1.945    59.297     0.200
     2.090    67.486     0.200
     2.090    65.613     0.200
     2.092    65.041     0.200
     2.092    64.873     0.200
     2.130    66.148     0.200
     2.130    66.023     0.200
     2.236    69.879     0.200
     2.236    69.203     0.200
     2.340    72.252     0.200
     2.809    86.094     0.200
     3.032    92.363     0.200
     3.362   103.693     0.200
     3.499   108.533     0.200
     4.449   137.953     0.200
     5.260   163.512     0.200
     5.956   183.322     0.200
     0.374    12.323     0.200
     0.374    12.562     0.200
     0.493    15.785     0.200
     0.493    16.373     0.200
     0.554    17.418     0.200
     0.554    17.553     0.200
     0.622    20.593     0.200
     0.768    24.812     0.200
     0.824    25.753     0.200
     0.936    30.172     0.200
     0.936    29.973     0.200
     1.078    33.747     0.200
     1.084    34.046     0.200
     1.084    33.213     0.200
     1.158    34.603     0.200
     1.161    36.398     0.200
     1.199    38.627     0.200
     1.199    37.973     0.200
     1.182    37.769     0.200
     1.182    37.663     0.200
     1.209    36.652     0.200
     1.319    42.332     0.200
     1.319    41.713     0.200
     1.240    38.843     0.200
     1.298    41.339     0.200
     1.298    40.583     0.200
     1.559    47.203     0.200
     1.698    52.873     0.200
     1.734    53.583     0.200
     1.735    53.794     0.200
     1.735    53.673     0.200
     1.800    55.887     0.200
     1.835    56.283     0.200
     2.261    70.083     0.200
     2.982    92.783     0.200
     3.006    93.204     0.200
     3.057    94.978     0.200
     3.057    95.163     0.200
     3.317   102.393     0.200
     4.008   124.553     0.200
     4.412   135.293     0.200
     5.491   170.833     0.200
     6.051   189.123     0.200
     6.089   190.343     0.200
     6.105   190.643     0.200
     0.255     8.246     0.200
     0.255     8.152     0.200
     0.503    16.555     0.200
     0.553    16.711     0.200
     0.553    17.062     0.200
     0.612    19.305     0.200
     0.612    19.082     0.200
     0.881    27.594     0.200
     0.886    28.652     0.200
     1.034    32.422     0.200
     1.034    33.082     0.200
     1.095    34.473     0.200
     1.097    34.129     0.200
     1.103    34.570     0.200
     1.103    34.883     0.200
     1.121    35.016     0.200
     1.170    36.754     0.200
     1.392    44.328     0.200
     1.392    44.516     0.200
     1.296    41.488     0.200
     1.296    40.383     0.200
     1.340    42.605     0.200
     1.412    45.062     0.200
     1.412    44.684     0.200
     1.473    44.594     0.200
     1.660    52.016     0.200
     1.837    57.031     0.200
     2.297    72.613     0.200
     2.297    72.035     0.200
     2.363    74.488     0.200
     3.279   100.242     0.200
     0.425    13.023     0.200
     0.433    13.688     0.200
     0.433    14.281     0.200
     0.460    14.766     0.200
     0.763    24.766     0.200
     0.939    30.375     0.200
     0.955    30.047     0.200
     0.994    31.883     0.200
     0.994    31.234     0.200
     1.190    37.617     0.200
     1.219    38.906     0.200
     1.219    38.453     0.200
     1.210    38.328     0.200
     1.299    40.953     0.200
     1.302    41.305     0.200
     1.410    44.906     0.200
     1.336    41.703     0.200
     1.688    52.445     0.200
     1.768    54.680     0.200
     1.768    54.875     0.200
     2.204    68.789     0.200
     2.204    68.391     0.200
     2.572    79.359     0.200
     2.790    86.742     0.200
     2.910    90.320     0.200
     2.966    91.555     0.200
     3.290   101.102     0.200
     3.290   101.664     0.200
     3.287   102.039     0.200
     4.148   128.680     0.200
     4.321   133.266     0.200
     4.721   147.211     0.200
     4.798   148.492     0.200
     0.247     8.320     0.200
     0.275     9.414     0.200
     0.485    16.312     0.200
     0.585    19.531     0.200
     0.585    19.312     0.200
     0.769    24.539     0.200
     0.769    23.984     0.200
     0.769    23.719     0.200
     0.799    25.438     0.200
     0.847    28.719     0.200
     0.847    28.281     0.200
     1.105    35.539     0.200
     1.120    35.773     0.200
     1.120    35.977     0.200
     1.127    35.758     0.200
     1.127    35.648     0.200
     1.228    39.180     0.200
     1.228    38.945     0.200
     1.228    38.797     0.200
     1.297    40.547     0.200
     1.297    40.125     0.200
     1.409    44.383     0.200
     1.429    44.820     0.200
     1.429    45.086     0.200
     1.486    45.352     0.200
     1.486    44.836     0.200
     1.533    47.352     0.200
     1.748    54.078     0.200
     1.854    57.797     0.200
     1.887    57.820     0.200
     1.975    61.758     0.200
     1.975    60.867     0.200
     1.991    60.930     0.200
     2.077    63.258     0.200
     2.581    78.656     0.200
     2.771    85.500     0.200
     3.190    97.867     0.200
     3.245   101.031     0.200
     3.247   100.430     0.200
     4.185   128.477     0.200
     5.481   169.516     0.200
     0.522    15.641     0.200
     0.522    15.984     0.200
     0.532    17.906     0.200
     0.594    18.820     0.200
     0.594    18.617     0.200
     0.656    21.102     0.200
     0.842    27.328     0.200
     0.950    30.086     0.200
     0.950    30.492     0.200
     0.993    31.102     0.200
     0.993    31.336     0.200
     1.026    30.477     0.200
     1.094    35.797     0.200
     1.290    41.656     0.200
     1.290    41.328     0.200
     1.220    37.945     0.200
     1.238    39.273     0.200
     1.413    43.469     0.200
     1.523    48.117     0.200
     2.246    69.992     0.200
     2.306    72.922     0.200
     2.306    71.453     0.200
     2.287    70.750     0.200
     2.447    75.000     0.200
     4.583   142.984     0.200
     5.185   159.812     0.200
     6.054   187.914     0.200
     0.345    11.801     0.200
     0.371    12.754     0.200
     0.371    12.672     0.200
     0.550    16.910     0.200
     0.550    17.320     0.200
     0.527    16.777     0.200
     0.642    20.164     0.200
     0.777    25.422     0.200
     0.777    25.102     0.200
     0.853    27.750     0.200
     0.901    29.191     0.200
     0.993    31.520     0.200
     0.993    31.230     0.200
     0.993    31.402     0.200
     1.075    32.680     0.200
     1.259    39.980     0.200
     1.259    40.750     0.200
     1.161    36.875     0.200
     1.209    38.500     0.200
     1.347    42.547     0.200
     1.653    49.902     0.200
     1.705    52.969     0.200
     1.705    53.109     0.200
     1.770    54.570     0.200
     1.815    56.133     0.200
     1.815    55.832     0.200
     1.985    62.469     0.200
     2.661    82.535     0.200
     2.747    84.543     0.200
     2.965    91.918     0.200
     3.043    93.391     0.200
     3.173    98.691     0.200
     3.399   105.707     0.200
     3.917   120.469     0.200
     0.136     6.011     0.200
     0.307     9.828     0.200
     0.463    14.977     0.200
     0.515    16.931     0.200
     0.515    17.060     0.200
     0.898    27.970     0.200
     0.894    27.813     0.200
     1.092    35.064     0.200
     1.218    38.695     0.200
     1.259    39.908     0.200
     1.310    41.665     0.200
     1.329    41.503     0.200
     1.393    43.573     0.200
     1.608    49.393     0.200
     2.591    79.301     0.200
     2.683    83.208     0.200
     2.885    89.175     0.200
     3.026    93.119     0.200
     3.290   100.684     0.200
     3.321   102.126     0.200
     3.544   108.903     0.200
     0.391    12.805     0.200
     0.428    13.609     0.200
     0.496    16.047     0.200
     0.767    23.766     0.200
     1.015    32.219     0.200
     1.204    37.984     0.200
     1.222    38.754     0.200
     1.261    40.023     0.200
     1.270    40.234     0.200
     1.421    45.391     0.200
     1.699    52.809     0.200
     1.811    55.965     0.200
     1.912    58.641     0.200
     2.170    67.703     0.200
     2.718    84.340     0.200
     2.952    91.816     0.200
     3.094    95.918     0.200
     3.325   102.520     0.200
     3.332   102.402     0.200
     0.302     9.599     0.200
     0.302     9.705     0.200
     0.471    15.295     0.200
     0.471    15.469     0.200
     0.513    17.039     0.200
     0.734    23.869     0.200
     0.827    26.479     0.200
     0.885    27.595     0.200
     0.906    28.238     0.200
     1.011    32.278     0.200
     1.051    33.499     0.200
     1.094    35.079     0.200
     1.186    36.339     0.200
     1.211    38.349     0.200
     1.211    38.639     0.200
     1.257    39.849     0.200
     1.318    41.479     0.200
     1.335    41.448     0.200
     1.381    44.198     0.200
     1.400    43.379     0.200
     1.402    43.416     0.200
     1.415    44.479     0.200
     1.600    48.669     0.200
     1.600    49.067     0.200
     1.771    53.369     0.200
     1.892    58.703     0.200
     2.103    65.038     0.200
     0.309    10.016     0.200
     0.466    14.903     0.200
     0.511    16.819     0.200
     0.899    28.347     0.200
     0.890    27.320     0.200
     1.089    34.897     0.200
     1.213    38.533     0.200
     1.254    39.521     0.200
     1.314    41.160     0.200
     1.328    41.143     0.200
     1.395    43.188     0.200
     1.605    49.256     0.200
     1.809    55.745     0.200
     1.884    58.487     0.200
     2.290    69.291     0.200
     0.306    10.195     0.200
     0.306    10.021     0.200
     0.466    15.838     0.200
     0.466    15.586     0.200
     0.514    17.145     0.200
     0.729    25.176     0.200
     0.729    24.145     0.200
     0.827    26.904     0.200
     0.827    26.654     0.200
     0.901    28.314     0.200
     0.901    28.506     0.200
     0.886    29.795     0.200
     0.890    27.596     0.200
     0.890    27.408     0.200
     1.005    31.475     0.200
     1.045    33.416     0.200
     1.092    35.166     0.200
     1.180    36.516     0.200
     1.215    38.525     0.200
     1.215    38.783     0.200
     1.258    39.836     0.200
     1.258    40.191     0.200
     1.330    41.125     0.200
     1.330    41.715     0.200
     1.313    41.676     0.200
     1.379    43.246     0.200
     1.394    42.395     0.200
     1.396    43.740     0.200
     1.605    49.375     0.200
     1.605    48.918     0.200
     1.754    54.945     0.200
     1.886    58.215     0.200
     1.958    60.645     0.200
     1.957    59.756     0.200
     1.972    61.277     0.200
     2.108    64.977     0.200
     2.589    79.348     0.200
     2.685    83.340     0.200
     2.703    83.176     0.200
     3.023    92.861     0.200
     3.202    99.225     0.200
     3.234    96.340     0.200
     3.287   101.355     0.200
     3.287   100.850     0.200
     3.317   102.779     0.200
     3.319   102.574     0.200
     3.319   102.305     0.200
     3.694   114.996     0.200
     4.295   132.256     0.200
     4.536   136.299     0.200
     4.722   147.145     0.200
     0.299     9.121     0.200
     0.334    10.791     0.200
     0.535    16.412     0.200
     0.535    16.201     0.200
     0.520    18.402     0.200
     0.602    18.691     0.200
     0.701    24.191     0.200
     0.779    26.062     0.200
     1.010    31.840     0.200
     1.309    42.006     0.200
     1.217    38.096     0.200
     1.253    39.434     0.200
     1.418    44.057     0.200
     1.891    59.191     0.200
     2.264    70.254     0.200
     2.702    82.697     0.200
     0.403    13.208     0.200
     0.403    13.210     0.200
     0.428    13.002     0.200
     0.485    15.829     0.200
     0.666    22.840     0.200
     0.772    24.176     0.200
     0.968    31.110     0.200
     0.982    30.602     0.200
     1.008    32.240     0.200
     1.008    32.534     0.200
     1.062    32.930     0.200
     1.204    37.950     0.200
     1.252    39.088     0.200
     1.212    38.464     0.200
     1.249    39.160     0.200
     1.249    39.563     0.200
     1.276    39.550     0.200
     1.278    39.753     0.200
     1.309    38.890     0.200
     1.297    41.180     0.200
     1.417    44.800     0.200
     1.661    49.980     0.200
     1.688    51.570     0.200
     1.757    55.160     0.200
     1.794    55.210     0.200
     1.794    55.380     0.200
     1.800    55.740     0.200
     1.829    57.880     0.200
     1.846    57.050     0.200
     1.923    59.920     0.200
     2.179    66.490     0.200
     2.940    90.319     0.200
     2.940    91.390     0.200
     3.319   101.899     0.200
     4.727   147.080     0.200
     0.585    18.879     0.200
     0.850    26.986     0.200
     0.893    29.887     0.200
     0.986    31.127     0.200
     1.310    40.387     0.200
     1.310    41.010     0.200
     1.322    41.787     0.200
     1.322    42.613     0.200
     1.423    46.037     0.200
     1.850    57.768     0.200
     1.893    57.979     0.200
     1.893    58.184     0.200
     1.913    58.107     0.200
     1.913    59.027     0.200
     3.383   105.078     0.200
     3.403   105.887     0.200
     0.264     8.584     0.200
     0.335    10.533     0.200
     0.428    14.314     0.200
     0.428    14.013     0.200
     0.589    19.265     0.200
     0.589    18.944     0.200
     0.589    18.434     0.200
     0.743    24.234     0.200
     0.774    23.624     0.200
     0.774    24.204     0.200
     0.853    28.924     0.200
     0.967    30.174     0.200
     0.967    30.056     0.200
     1.045    33.864     0.200
     1.045    33.224     0.200
     1.091    34.664     0.200
     1.091    34.484     0.200
     1.091    35.203     0.200
     1.118    35.274     0.200
     1.118    34.874     0.200
     1.172    37.114     0.200
     1.172    37.424     0.200
     1.172    37.578     0.200
     1.166    36.214     0.200
     1.271    39.654     0.200
     1.271    39.534     0.200
     1.320    41.494     0.200
     1.358    42.484     0.200
     1.374    44.054     0.200
     1.406    44.214     0.200
     1.437    44.524     0.200
     1.437    45.616     0.200
     1.486    46.104     0.200
     1.520    47.684     0.200
     1.669    50.734     0.200
     1.795    55.834     0.200
     1.795    56.048     0.200
     1.924    58.964     0.200
     1.984    60.714     0.200
     2.098    65.980     0.200
     2.845    88.310     0.200
     3.163    98.074     0.200
     3.205    99.684     0.200
     3.205    99.038     0.200
     3.947   122.986     0.200
     4.170   129.474     0.200
     4.170   128.266     0.200
     4.307   132.688     0.200
     0.277     9.188     0.200
     0.334    11.381     0.200
     0.538    16.906     0.200
     0.608    19.047     0.200
     0.576    17.973     0.200
     0.806    26.156     0.200
     0.851    28.207     0.200
     0.955    30.154     0.200
     1.060    33.238     0.200
     1.116    34.096     0.200
     1.152    36.928     0.200
     1.133    34.980     0.200
     1.324    42.557     0.200
     1.215    38.703     0.200
     1.786    54.760     0.200
     1.840    57.029     0.200
     1.828    56.297     0.200
     0.339    11.090     0.200
     0.448    14.977     0.200
     0.448    15.371     0.200
     0.526    16.742     0.200
     0.526    16.637     0.200
     0.763    24.578     0.200
     0.838    26.340     0.200
     0.838    27.012     0.200
     0.790    26.930     0.200
     0.913    28.043     0.200
     1.043    33.488     0.200
     1.043    33.625     0.200
     1.054    34.047     0.200
     1.145    35.449     0.200
     1.145    37.102     0.200
     1.102    35.707     0.200
     1.193    37.828     0.200
     1.375    43.363     0.200
     1.428    44.797     0.200
     1.456    45.977     0.200
     1.548    47.508     0.200
     2.328    71.094     0.200
     4.230   130.277     0.200
     0.447    14.148     0.200
     0.447    14.219     0.200
     0.514    16.000     0.200
     0.514    16.172     0.200
     0.489    15.781     0.200
     0.489    15.672     0.200
     0.707    23.219     0.200
     0.717    23.297     0.200
     0.851    25.672     0.200
     0.820    25.727     0.200
     0.925    29.547     0.200
     0.925    29.727     0.200
     1.063    32.273     0.200
     1.066    32.633     0.200
     1.176    37.906     0.200
     1.108    34.750     0.200
     1.108    34.586     0.200
     1.211    40.055     0.200
     1.174    36.758     0.200
     1.492    44.352     0.200
     1.479    46.438     0.200
     1.555    49.156     0.200
     1.650    50.531     0.200
     1.625    51.648     0.200
     1.792    54.383     0.200
     1.981    60.148     0.200
     2.147    67.656     0.200
     2.147    68.016     0.200
     2.146    67.570     0.200
     2.155    68.383     0.200
     2.155    68.555     0.200
     2.289    72.125     0.200
     2.327    71.594     0.200
     2.327    71.289     0.200
     3.355   103.109     0.200
     0.237     7.691     0.200
     0.422    14.051     0.200
     0.550    18.164     0.200
     0.550    18.270     0.200
     0.550    18.121     0.200
     0.736    23.918     0.200
     0.917    27.875     0.200
     1.022    33.230     0.200
     1.022    32.543     0.200
     1.073    34.289     0.200
     1.117    35.551     0.200
     1.117    35.172     0.200
     1.167    36.559     0.200
     1.167    37.371     0.200
     1.167    37.168     0.200
     1.314    42.141     0.200
     1.314    41.855     0.200
     1.302    41.828     0.200
     1.302    41.281     0.200
     1.400    44.219     0.200
     1.400    44.328     0.200
     1.439    45.414     0.200
     1.473    45.789     0.200
     1.473    45.039     0.200
     1.527    47.648     0.200
     1.619    49.570     0.200
     1.825    56.539     0.200
     1.876    58.070     0.200
     1.882    58.789     0.200
     1.882    57.281     0.200
     1.962    61.469     0.200
     2.008    63.211     0.200
     2.232    69.879     0.200
     2.232    69.312     0.200
     2.234    69.918     0.200
     2.342    71.391     0.200
     2.342    71.828     0.200
     2.640    80.340     0.200
     2.792    86.711     0.200
     3.190    97.684     0.200
     3.219   100.098     0.200
     3.219    99.719     0.200
     3.600   109.707     0.200
     3.676   113.074     0.200
     4.205   129.730     0.200
     4.205   129.480     0.200
     0.260     8.621     0.200
     0.319    10.171     0.200
     0.548    16.261     0.200
     0.634    19.811     0.200
     0.634    19.921     0.200
     0.750    25.171     0.200
     0.810    24.761     0.200
     0.810    25.221     0.200
     0.891    29.151     0.200
     1.053    34.571     0.200
     1.024    31.831     0.200
     1.060    32.421     0.200
     1.006    32.511     0.200
     1.035    32.980     0.200
     1.189    38.221     0.200
     1.291    40.201     0.200
     1.315    41.671     0.200
     1.412    42.521     0.200
     1.461    44.121     0.200
     1.593    47.411     0.200
     1.614    47.581     0.200
     2.296    71.311     0.200
     2.689    82.351     0.200
     2.980    92.431     0.200
     3.283   102.031     0.200
     0.360    12.102     0.200
     0.360    12.008     0.200
     0.505    16.203     0.200
     0.650    20.156     0.200
     0.650    20.344     0.200
     0.783    25.906     0.200
     0.892    29.383     0.200
     0.953    30.742     0.200
     1.091    34.148     0.200
     1.091    34.328     0.200
     1.160    34.750     0.200
     1.163    36.172     0.200
     1.189    38.133     0.200
     1.189    38.406     0.200
     1.198    37.766     0.200
     1.257    40.109     0.200
     1.344    41.250     0.200
     1.307    40.867     0.200
     1.752    54.656     0.200
     1.752    54.516     0.200
     1.831    56.078     0.200
     1.854    54.898     0.200
     1.814    56.539     0.200
     1.814    56.062     0.200
     2.068    63.469     0.200
     2.068    64.672     0.200
     2.758    84.594     0.200
     2.732    84.906     0.200
     2.659    82.445     0.200
     2.833    87.023     0.200
     3.013    93.188     0.200
     0.366    12.195     0.200
     0.366    12.016     0.200
     0.500    16.094     0.200
     0.653    19.797     0.200
     0.778    25.375     0.200
     0.898    29.820     0.200
     0.950    30.570     0.200
     0.950    30.758     0.200
     0.950    30.484     0.200
     1.092    34.219     0.200
     1.080    33.844     0.200
     1.080    33.680     0.200
     1.193    37.648     0.200
     1.201    38.305     0.200
     1.195    38.625     0.200
     1.195    38.383     0.200
     1.212    37.094     0.200
     1.301    41.164     0.200
     1.348    41.969     0.200
     1.714    52.461     0.200
     1.748    54.359     0.200
     1.809    55.875     0.200
     1.836    56.398     0.200
     2.073    64.078     0.200
     2.729    84.750     0.200
     2.762    85.250     0.200
     2.997    93.281     0.200
     3.364   104.023     0.200
     0.318    11.695     0.200
     0.462    16.594     0.200
     0.533    17.875     0.200
     0.533    17.633     0.200
     0.777    26.109     0.200
     0.797    26.625     0.200
     0.797    27.094     0.200
     0.934    29.859     0.200
     0.934    29.070     0.200
     1.146    35.500     0.200
     1.146    36.227     0.200
     1.208    38.375     0.200
     1.228    38.352     0.200
     1.470    44.164     0.200
     0.249     8.115     0.200
     0.586    18.575     0.200
     0.591    19.555     0.200
     0.679    21.205     0.200
     0.828    26.385     0.200
     0.887    28.765     0.200
     0.927    29.725     0.200
     0.933    30.335     0.200
     1.450    44.795     0.200
     1.517    48.125     0.200
     1.650    51.055     0.200
     0.384    12.152     0.200
     0.485    16.082     0.200
     0.714    22.051     0.200
     0.776    24.340     0.200
     0.935    28.840     0.200
     0.975    31.500     0.200
     1.008    32.371     0.200
     1.148    36.242     0.200
     1.198    38.051     0.200
     1.247    39.820     0.200
     1.274    40.711     0.200
     1.664    51.312     0.200
     1.699    52.441     0.200
     1.795    55.109     0.200
     1.799    55.812     0.200
     0.375    12.687     0.200
     0.434    14.557     0.200
     0.503    16.477     0.200
     0.768    25.227     0.200
     0.747    24.527     0.200
     0.871    26.987     0.200
     1.023    32.327     0.200
     1.013    32.467     0.200
     1.075    34.807     0.200
     1.171    37.097     0.200
     1.157    36.707     0.200
     1.177    37.657     0.200
     1.299    41.227     0.200
     1.354    42.867     0.200
     1.421    44.287     0.200
     1.737    53.777     0.200
     1.774    53.637     0.200
     1.782    55.347     0.200
     1.841    56.387     0.200
     2.837    87.147     0.200
     4.249   130.997     0.200
     0.413    14.117     0.200
     0.413    13.633     0.200
     0.572    18.539     0.200
     0.689    21.430     0.200
     0.814    24.773     0.200
     0.838    27.422     0.200
     0.841    27.312     0.200
     1.002    33.102     0.200
     1.207    37.961     0.200
     1.488    44.688     0.200
     3.155    96.703     0.200
     3.190    99.086     0.200
     0.468    16.545     0.200
     0.547    18.475     0.200
     0.760    25.846     0.200
     1.051    33.426     0.200
     0.923    30.473     0.200
     0.923    30.344     0.200
     0.982    31.965     0.200
     0.982    32.242     0.200
     0.994    32.305     0.200
     1.068    33.941     0.200
     1.068    34.543     0.200
     1.200    38.324     0.200
     1.288    41.395     0.200
     1.288    40.984     0.200
     1.319    41.863     0.200
     1.319    40.773     0.200
     1.465    45.383     0.200
     1.536    47.133     0.200
     1.755    55.113     0.200
     2.793    86.082     0.200
     5.100   158.242     0.200
     0.422    14.742     0.200
     0.687    24.160     0.200
     0.929    30.051     0.200
     0.929    30.473     0.200
     0.988    32.062     0.200
     0.994    32.090     0.200
     1.074    34.410     0.200
     1.074    34.191     0.200
     1.273    40.012     0.200
     1.326    41.723     0.200
     1.326    40.711     0.200
     1.290    41.250     0.200
     1.290    41.461     0.200
     1.290    40.500     0.200
     1.472    45.590     0.200
     1.541    47.941     0.200
     1.543    47.582     0.200
     1.678    51.422     0.200
     1.669    51.230     0.200
     1.760    55.242     0.200
     2.194    68.531     0.200
     5.093   157.266     0.200
     0.509    16.082     0.200
     0.656    21.152     0.200
     0.763    25.111     0.200
     0.797    23.461     0.200
     0.797    24.381     0.200
     0.971    30.801     0.200
     0.999    31.352     0.200
     1.058    32.611     0.200
     1.148    37.182     0.200
     1.151    36.211     0.200
     1.194    36.881     0.200
     1.306    41.941     0.200
     1.261    39.691     0.200
     1.261    39.381     0.200
     1.292    41.691     0.200
     1.280    41.012     0.200
     1.280    41.291     0.200
     1.306    42.062     0.200
     1.408    43.082     0.200
     1.525    48.172     0.200
     1.584    47.301     0.200
     2.192    68.961     0.200
     3.059    94.521     0.200
     3.796   117.201     0.200
     0.289    10.801     0.200
     0.788    26.961     0.200
     0.807    26.840     0.200
     0.807    26.730     0.200
     1.066    33.953     0.200
     1.066    34.090     0.200
     1.093    35.531     0.200
     1.106    34.973     0.200
     1.106    35.203     0.200
     1.237    38.602     0.200
     1.237    38.883     0.200
     1.237    39.582     0.200
     1.472    44.410     0.200
     1.673    49.520     0.200
     0.804    25.047     0.200
     0.920    30.504     0.200
     1.018    31.117     0.200
     1.349    40.605     0.200
     1.486    46.465     0.200
     1.680    51.117     0.200
     1.707    51.516     0.200
     1.814    55.617     0.200
     2.085    63.977     0.200
     0.685    21.375     0.200
     0.776    23.305     0.200
     0.776    23.535     0.200
     0.858    27.445     0.200
     0.952    31.055     0.200
     0.970    30.645     0.200
     0.970    30.925     0.200
     1.123    36.445     0.200
     1.281    41.065     0.200
     1.250    39.445     0.200
     1.250    39.665     0.200
     1.261    40.125     0.200
     1.261    40.625     0.200
     1.354    43.835     0.200
     1.393    41.645     0.200
     1.439    43.585     0.200
     1.439    45.135     0.200
     1.496    47.305     0.200
     1.554    47.785     0.200
     1.566    48.835     0.200
     1.994    61.115     0.200
     0.561    17.117     0.200
     0.812    25.945     0.200
     0.910    27.434     0.200
     0.967    31.004     0.200
     1.076    33.945     0.200
     1.167    35.887     0.200
     1.199    38.117     0.200
     1.223    38.637     0.200
     1.273    40.195     0.200
     1.518    45.996     0.200
     1.567    47.957     0.200
     1.697    51.836     0.200
     1.821    55.746     0.200
     5.237   161.816     0.200
     0.553    16.565     0.200
     0.805    26.466     0.200
     0.921    27.936     0.200
     0.965    31.086     0.200
     1.082    33.886     0.200
     1.179    35.796     0.200
     1.201    37.815     0.200
     1.217    38.306     0.200
     1.530    46.325     0.200
     1.578    47.865     0.200
     1.625    50.516     0.200
     5.226   160.155     0.200
     0.299    10.508     0.200
     0.299    10.758     0.200
     0.878    28.605     0.200
     1.148    35.105     0.200
     1.148    35.207     0.200
     1.128    36.117     0.200
     1.333    42.195     0.200
     1.333    42.426     0.200
     1.307    41.688     0.200
     1.368    42.586     0.200
     1.514    47.027     0.200
     1.540    46.887     0.200
     1.722    51.816     0.200
     1.880    59.078     0.200
     2.252    67.906     0.200
     0.505    17.438     0.200
     0.909    28.246     0.200
     0.909    28.547     0.200
     0.954    31.805     0.200
     1.124    35.586     0.200
     1.124    34.496     0.200
     1.175    38.305     0.200
     1.314    40.137     0.200
     1.299    40.137     0.200
     1.325    41.164     0.200
     1.342    41.727     0.200
     1.325    41.996     0.200
     1.369    43.156     0.200
     1.477    45.566     0.200
     1.421    46.355     0.200
     1.421    44.777     0.200
     1.693    53.855     0.200
     0.403    12.504     0.200
     0.405    12.395     0.200
     0.965    31.273     0.200
     1.048    31.996     0.200
     1.048    31.875     0.200
     1.184    37.793     0.200
     1.252    39.914     0.200
     1.277    41.633     0.200
     1.277    41.215     0.200
     1.445    45.266     0.200
     1.703    52.676     0.200
     1.702    52.906     0.200
     1.694    53.016     0.200
     1.694    52.613     0.200
     1.834    56.594     0.200
     2.168    67.516     0.200
     3.966   121.977     0.200
     0.407    12.789     0.200
     0.407    13.219     0.200
     0.491    16.602     0.200
     0.494    16.164     0.200
     0.758    26.109     0.200
     0.986    31.820     0.200
     0.986    31.344     0.200
     1.061    33.539     0.200
     1.144    36.148     0.200
     1.144    35.672     0.200
     1.159    37.211     0.200
     1.159    36.812     0.200
     1.243    39.883     0.200
     1.243    39.211     0.200
     1.274    40.641     0.200
     1.311    41.734     0.200
     1.344    43.031     0.200
     1.344    42.664     0.200
     1.399    43.266     0.200
     1.542    47.891     0.200
     1.751    52.664     0.200
     1.751    54.070     0.200
     1.807    56.102     0.200
     1.807    56.422     0.200
     1.801    53.961     0.200
     1.894    56.320     0.200
     1.932    59.570     0.200
     0.408    13.211     0.200
     0.408    13.344     0.200
     0.500    16.602     0.200
     0.503    16.125     0.200
     0.766    25.156     0.200
     0.766    26.102     0.200
     0.982    31.977     0.200
     0.982    31.461     0.200
     1.070    34.062     0.200
     1.070    33.953     0.200
     1.151    35.805     0.200
     1.151    36.297     0.200
     1.153    36.664     0.200
     1.245    39.852     0.200
     1.245    39.484     0.200
     1.269    40.992     0.200
     1.269    40.633     0.200
     1.310    42.062     0.200
     1.352    42.078     0.200
     1.352    42.781     0.200
     1.407    44.211     0.200
     1.549    48.133     0.200
     1.587    48.953     0.200
     1.759    54.484     0.200
     1.759    52.727     0.200
     1.808    54.414     0.200
     1.809    56.461     0.200
     1.939    60.328     0.200
     2.706    83.602     0.200
     0.497    16.109     0.200
     0.978    31.500     0.200
     1.631    49.602     0.200
     0.504    16.188     0.200
     0.739    22.695     0.200
     0.871    26.078     0.200
     1.261    40.766     0.200
     1.521    45.906     0.200
     1.555    46.719     0.200
     1.671    50.164     0.200
     1.825    56.406     0.200
     0.502    15.281     0.200
     0.955    30.633     0.200
     1.270    41.516     0.200
     1.321    42.906     0.200
     1.573    46.672     0.200
     1.805    55.102     0.200
     1.894    58.125     0.200
     0.669    19.789     0.200
     0.824    24.711     0.200
     0.903    28.336     0.200
     1.148    37.805     0.200
     1.146    36.766     0.200
     1.329    39.617     0.200
     1.357    40.898     0.200
     1.468    44.539     0.200
     1.728    54.219     0.200
     1.784    55.516     0.200
     0.531    16.789     0.200
     0.718    22.398     0.200
     0.923    28.094     0.200
     0.992    31.789     0.200
     1.002    32.594     0.200
     1.016    31.594     0.200
     1.307    43.250     0.200
     1.358    43.891     0.200
     1.492    47.016     0.200
     1.573    47.688     0.200
     1.589    50.047     0.200
     1.608    49.664     0.200
     1.723    52.445     0.200
     1.754    54.008     0.200
     1.772    54.438     0.200
     1.931    60.453     0.200
     1.972    61.094     0.200
     2.161    69.125     0.200
     0.473    15.609     0.200
     0.642    19.070     0.200
     0.887    28.016     0.200
     0.960    28.734     0.200
     1.383    44.906     0.200
     1.442    44.031     0.200
     2.550    77.945     0.200
     3.129    96.102     0.200
     0.480    15.211     0.200
     1.400    45.008     0.200
     1.504    45.078     0.200
     2.037    62.789     0.200
     0.474    14.344     0.200
     1.103    36.859     0.200
     1.491    45.594     0.200
     1.777    54.148     0.200
     2.048    62.820     0.200
     0.515    15.578     0.200
     0.531    16.344     0.200
     0.861    25.953     0.200
     1.042    33.977     0.200
     1.191    36.414     0.200
     1.331    40.594     0.200
     1.389    42.609     0.200
     1.517    45.289     0.200
     1.660    50.250     0.200
     1.830    56.414     0.200
     0.470    16.266     0.200
     0.650    19.789     0.200
     0.778    23.930     0.200
     0.880    27.180     0.200
     0.967    29.188     0.200
     1.102    36.195     0.200
     1.303    39.086     0.200
     1.335    39.508     0.200
     1.450    44.109     0.200
     1.492    44.773     0.200
     1.780    54.055     0.200
     0.507    16.211     0.200
     0.803    24.734     0.200
     1.227    40.000     0.200
     1.644    50.266     0.200
     0.509    16.187     0.200
     0.793    24.387     0.200
     0.809    25.497     0.200
     0.901    29.197     0.200
     0.939    30.657     0.200
     1.075    33.847     0.200
     1.222    40.817     0.200
     1.448    43.737     0.200
     1.479    44.947     0.200
     1.593    48.907     0.200
     1.636    49.837     0.200
     1.763    52.277     0.200
     1.922    58.687     0.200
     2.048    64.977     0.200
     0.534    15.875     0.200
     0.685    20.705     0.200
     0.501    15.166     0.200
     0.736    23.846     0.200
     0.872    25.816     0.200
     1.053    33.526     0.200
     1.261    41.156     0.200
     1.521    46.206     0.200
     1.556    47.506     0.200
     1.672    51.546     0.200
     2.002    61.906     0.200
     2.107    64.966     0.200
     0.489    16.122     0.200
     0.585    17.652     0.200
     0.934    30.622     0.200
     1.241    37.463     0.200
     1.230    39.812     0.200
     2.110    64.793     0.200
     2.351    71.393     0.200
     2.557    77.992     0.200
     2.499    76.343     0.200
     3.072    95.473     0.200
     0.483    15.541     0.200
     0.510    16.534     0.200
     0.756    23.435     0.200
     0.859    26.435     0.200
     0.943    31.614     0.200
     1.048    33.734     0.200
     1.260    41.104     0.200
     1.511    46.555     0.200
     1.544    47.174     0.200
     1.659    50.754     0.200
     1.921    60.154     0.200
     0.480    15.501     0.200
     0.585    17.730     0.200
     0.736    21.921     0.200
     0.906    27.150     0.200
     0.928    29.451     0.200
     0.937    31.431     0.200
     1.060    34.661     0.200
     1.240    38.021     0.200
     1.271    38.671     0.200
     1.236    39.001     0.200
     2.110    65.431     0.200
     0.564    18.262     0.200
     0.597    17.981     0.200
     0.851    28.212     0.200
     0.938    27.821     0.200
     1.129    38.132     0.200
     0.527    16.637     0.200
     0.493    14.576     0.200
     0.653    20.086     0.200
     0.796    24.426     0.200
     1.120    35.877     0.200
     1.340    40.297     0.200
     1.405    45.496     0.200
     1.453    44.627     0.200
     1.782    54.117     0.200
     1.932    59.557     0.200
     0.510    16.000     0.200
     0.740    22.941     0.200
     0.877    26.881     0.200
     0.952    30.641     0.200
     0.989    32.521     0.200
     1.045    32.971     0.200
     1.269    41.660     0.200
     1.315    42.131     0.200
     1.448    45.740     0.200
     1.527    46.080     0.200
     1.561    46.961     0.200
     1.677    50.900     0.200
     1.818    56.061     0.200
     1.889    59.010     0.200
     1.932    60.221     0.200
     0.489    15.238     0.200
     0.626    18.779     0.200
     1.098    35.529     0.200
     0.512    15.445     0.200
     0.618    19.078     0.200
     0.488    15.359     0.200
     0.609    18.227     0.200
     0.760    24.789     0.200
     0.932    28.797     0.200
     0.926    31.137     0.200
     1.085    35.598     0.200
     1.370    44.066     0.200
     1.409    43.090     0.200
     1.459    45.367     0.200
     1.586    46.539     0.200
     1.739    52.199     0.200
     1.866    56.469     0.200
     1.927    60.688     0.200
     0.568    18.254     0.200
     0.699    21.895     0.200
     0.878    27.594     0.200
     0.927    28.922     0.200
     1.037    31.082     0.200
     0.849    28.684     0.200
     1.202    39.473     0.200
     1.364    41.832     0.200
     1.388    42.613     0.200
     1.565    47.785     0.200
     1.693    49.875     0.200
     1.776    55.082     0.200
     1.835    56.953     0.200
     1.822    55.793     0.200
     1.958    59.293     0.200
     0.505    16.383     0.200
     0.873    26.691     0.200
     0.990    33.250     0.200
     0.948    30.562     0.200
     1.049    33.453     0.200
     1.183    36.020     0.200
     1.264    41.703     0.200
     1.310    42.422     0.200
     1.557    46.992     0.200
     1.547    49.512     0.200
     1.673    50.441     0.200
     1.884    58.012     0.200
     1.822    56.152     0.200
     2.004    60.910     0.200
     2.128    67.203     0.200
     2.274    70.281     0.200
     0.632    18.867     0.200
     0.794    25.719     0.200
     0.901    29.520     0.200
     0.961    29.387     0.200
     1.118    36.117     0.200
     1.432    43.637     0.200
     1.488    45.258     0.200
     1.760    53.527     0.200
     1.891    57.387     0.200
     2.066    65.277     0.200
     0.551    18.477     0.200
     0.643    18.957     0.200
     1.153    37.996     0.200
     1.332    40.375     0.200
     1.508    44.266     0.200
     1.767    54.766     0.200
     1.902    57.605     0.200
     1.950    60.195     0.200
     0.507    16.137     0.200
     0.774    23.816     0.200
     0.888    28.844     0.200
     0.933    31.094     0.200
     1.094    32.766     0.200
     1.086    34.004     0.200
     1.903    58.484     0.200
     0.507    16.219     0.200
     0.782    24.059     0.200
     0.816    26.418     0.200
     0.936    30.758     0.200
     1.101    33.918     0.200
     1.082    34.508     0.200
     1.915    59.578     0.200
     2.039    65.688     0.200
     2.129    67.469     0.200
     2.750    85.098     0.200
     2.890    87.457     0.200
     3.055    91.609     0.200
     3.070    95.156     0.200
     0.461    14.422     0.200
     0.640    19.016     0.200
     0.880    27.086     0.200
     1.088    35.398     0.200
     1.292    39.875     0.200
     1.325    41.094     0.200
     1.088    36.250     0.200
     0.438    13.797     0.200
     0.629    18.219     0.200
     1.062    34.969     0.200
     1.461    45.758     0.200
     1.881    58.055     0.200
     1.972    61.336     0.200
     2.067    64.086     0.200
     2.489    77.008     0.200
     0.462    14.621     0.200
     0.859    27.591     0.200
     0.494    16.583     0.200
     0.852    26.083     0.200
     0.928    30.062     0.200
     1.245    40.933     0.200
     1.289    42.223     0.200
     1.683    50.262     0.200
     1.982    60.123     0.200
     0.479    15.285     0.200
     0.588    18.047     0.200
     0.909    27.387     0.200
     0.937    30.875     0.200
     1.234    38.875     0.200
     2.107    65.527     0.200
     2.316    70.297     0.200
     2.348    73.055     0.200
     0.511    15.750     0.200
     0.643    19.266     0.200
     0.802    24.148     0.200
     0.901    29.547     0.200
     1.126    36.836     0.200
     1.169    36.484     0.200
     1.331    40.734     0.200
     1.442    44.484     0.200
     2.551    78.938     0.200
     0.495    15.884     0.200
     0.777    23.694     0.200
     0.817    24.744     0.200
     1.131    35.104     0.200
     1.076    33.844     0.200
     1.469    45.024     0.200
     1.617    50.394     0.200
     0.526    17.004     0.200
     0.722    22.254     0.200
     0.914    28.055     0.200
     0.983    31.564     0.200
     1.022    32.715     0.200
     1.299    42.924     0.200
     1.349    43.404     0.200
     1.483    47.273     0.200
     1.564    47.273     0.200
     1.714    52.504     0.200
     1.745    53.645     0.200
     1.782    54.773     0.200
     2.148    66.373     0.200
     2.218    68.424     0.200
     1.721    52.047     0.200
     2.108    65.336     0.200
     0.557    16.992     0.200
     0.597    17.500     0.200
     0.858    28.512     0.200
     1.262    38.480     0.200
     0.533    17.332     0.200
     0.484    15.219     0.200
     0.628    19.469     0.200
     0.772    24.289     0.200
     0.904    29.375     0.200
     0.928    30.586     0.200
     1.096    36.156     0.200
     1.284    38.977     0.200
     1.198    37.609     0.200
     1.315    40.641     0.200
     1.428    43.891     0.200
     1.604    48.211     0.200
     1.758    54.320     0.200
     1.942    62.352     0.200
     0.490    15.547     0.200
     0.637    19.757     0.200
     0.783    26.767     0.200
     0.660    19.555     0.200
     1.110    36.125     0.200
     0.577    18.039     0.200
     0.716    21.570     0.200
     0.895    29.102     0.200
     1.381    42.500     0.200
     1.405    43.258     0.200
     0.616    18.610     0.200
     0.608    18.920     0.200
     1.172    37.630     0.200
     0.429    14.719     0.200
     0.501    16.414     0.200
     0.745    23.234     0.200
     0.862    26.555     0.200
     0.938    31.613     0.200
     0.907    31.504     0.200
     1.172    36.105     0.200
     1.511    45.965     0.200
     1.662    52.152     0.200
     1.834    56.844     0.200
     1.992    61.594     0.200
     2.119    65.766     0.200
     2.357    71.684     0.200
     2.770    85.504     0.200
     2.967    92.176     0.200
     2.986    92.074     0.200
     3.321    98.953     0.200
     3.488   104.883     0.200
     3.891   117.996     0.200
     3.998   123.734     0.200
     2.283    71.551     0.200
     2.986    90.422     0.200
     2.507    76.428     0.200
     3.244    97.840     0.200
     0.492    15.580     0.200
     0.636    19.279     0.200
     1.293    39.359     0.200
     1.323    40.010     0.200
     0.441    14.631     0.200
     0.578    17.650     0.200
     2.534    78.014     0.200
     3.266    97.879     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    12.231   380.484     0.200
     5.184   163.109     0.200
     5.801   182.609     0.200
     7.143   229.109     0.200
     8.608   269.707     0.200
     5.635   177.426     0.200
     3.677   116.312     0.200
     4.674   146.383     0.200
     6.074   203.164     0.200
     5.249   164.797     0.200
     5.214   163.990     0.200
     5.202   163.457     0.200
     8.576   269.377     0.200
     5.804   183.285     0.200
     6.155   195.785     0.200
     4.115   131.246     0.200
     3.929   123.879     0.200
     5.804   182.855     0.200
     8.568   270.207     0.200
    12.087   380.590     0.200
     3.998   126.242     0.200
     8.693   273.391     0.200
     5.213   164.039     0.200
     8.546   267.789     0.200
    12.181   381.938     0.200
     9.897   315.820     0.200
    12.102   375.391     0.200
    12.102   376.367     0.200
    12.106   375.789     0.200
     8.616   270.680     0.200
     9.902   315.883     0.200
    10.117   319.281     0.200
    10.117   320.539     0.200
    12.117   375.180     0.200
    12.117   377.430     0.200
    12.122   376.578     0.200
    12.348   391.477     0.200
    13.727   430.477     0.200
    14.899   464.539     0.200
    15.653   488.102     0.200
    15.809   502.438     0.200
     3.956   124.273     0.200
     8.597   269.312     0.200
    12.103   375.336     0.200
    12.107   381.086     0.200
     3.932   122.992     0.200
     5.806   183.770     0.200
    12.088   379.016     0.200
     3.954   125.148     0.200
     5.087   159.383     0.200
     2.517    78.812     0.200
     4.661   145.718     0.200
     3.892   124.607     0.200
     5.712   184.438     0.200
     6.235   206.758     0.200
     8.514   266.518     0.200
    12.174   380.445     0.200
     5.095   159.383     0.200
     5.072   158.836     0.200
     5.635   176.375     0.200
     4.689   146.443     0.200
     5.316   166.844     0.200
     2.718    85.500     0.200
     2.761    86.461     0.200
     3.221   101.801     0.200
     3.638   113.961     0.200
     4.674   146.312     0.200
     5.757   180.891     0.200
     9.115   286.551     0.200
     9.410   297.414     0.200
    12.161   377.094     0.200
     2.513    78.109     0.200
     2.513    78.378     0.200
     2.642    83.220     0.200
     2.834    88.510     0.200
     2.954    93.180     0.200
     3.068    95.909     0.200
     3.732   116.560     0.200
     2.744    86.090     0.200
     3.018    94.711     0.200
     3.097    96.609     0.200
     3.800   119.438     0.200
     4.048   124.598     0.200
     5.171   161.879     0.200
     2.740    86.074     0.200
     2.740    85.707     0.200
     3.015    94.785     0.200
     3.797   119.438     0.200
     4.333   136.324     0.200
     2.706    85.047     0.200
     2.971    93.344     0.200
     3.042    95.250     0.200
     3.753   117.320     0.200
     3.799   119.547     0.200
     2.704    85.322     0.200
     2.966    93.332     0.200
     3.034    94.963     0.200
     3.749   117.342     0.200
     3.796   119.812     0.200
     4.282   134.072     0.200
     5.210   163.783     0.200
     2.886    90.050     0.200
     2.924    92.030     0.200
     3.084    97.220     0.200
     3.864   121.880     0.200
     3.038    94.738     0.200
     3.127    97.586     0.200
     3.863   121.307     0.200
     4.358   138.627     0.200
     5.559   173.846     0.200
     2.545    79.840     0.200
     2.939    91.793     0.200
     4.674   146.023     0.200
     4.712   148.523     0.200
     3.030    95.394     0.200
     3.118    97.564     0.200
     3.210   101.914     0.200
     3.309   103.804     0.200
     3.811   119.004     0.200
     4.378   136.894     0.200
     4.662   146.114     0.200
     4.669   146.584     0.200
     5.549   173.454     0.200
     6.162   193.044     0.200
     2.533    79.393     0.200
     2.777    87.332     0.200
     3.065    95.773     0.200
     3.054    95.113     0.200
     3.561   111.662     0.200
     3.978   124.572     0.200
     4.425   138.922     0.200
     5.369   169.123     0.200
     5.607   176.662     0.200
     5.894   185.053     0.200
     2.715    85.692     0.200
     2.908    90.583     0.200
     2.982    93.343     0.200
     3.006    93.643     0.200
     3.765   117.652     0.200
     3.909   121.942     0.200
     4.625   145.503     0.200
     4.919   154.203     0.200
     2.797    88.176     0.200
     2.797    87.734     0.200
     3.038    96.055     0.200
     2.790    86.898     0.200
     3.087    96.766     0.200
     3.867   121.484     0.200
     2.561    80.422     0.200
     2.905    90.867     0.200
     4.861   152.117     0.200
     2.698    84.766     0.200
     2.930    91.859     0.200
     3.227   101.328     0.200
     3.715   116.617     0.200
     2.663    83.547     0.200
     2.663    83.391     0.200
     2.911    90.852     0.200
     2.911    91.199     0.200
     3.173    98.980     0.200
     2.517    79.805     0.200
     2.555    80.904     0.200
     3.291   103.666     0.200
     3.760   117.734     0.200
     4.831   151.375     0.200
     2.940    91.763     0.200
     3.091    96.830     0.200
     2.980    93.729     0.200
     2.756    85.971     0.200
     3.960   123.724     0.200
     4.113   129.384     0.200
     4.225   132.316     0.200
     2.580    81.258     0.200
     2.629    83.008     0.200
     2.832    88.898     0.200
     2.832    89.414     0.200
     3.095    96.398     0.200
     4.478   141.250     0.200
     3.201   100.289     0.200
     4.773   151.320     0.200
     5.972   188.820     0.200
     4.635   145.551     0.200
     3.007    93.664     0.200
     5.826   182.145     0.200
     5.832   184.066     0.200
     3.800   118.961     0.200
     3.286   102.566     0.200
     3.664   114.325     0.200
     3.830   119.824     0.200
     4.635   144.926     0.200
     7.101   235.586     0.200
     2.537    81.522     0.200
     2.504    78.321     0.200
     2.533    78.977     0.200
     2.609    82.164     0.200
     2.620    84.312     0.200
     3.348   104.883     0.200
     3.903   122.266     0.200
     4.188   132.164     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.222    38.484     0.200
     2.269    69.484     0.200
     8.640   268.109     0.200
     1.106    35.969     0.200
     1.835    56.781     0.200
     2.138    66.672     0.200
     3.945   121.969     0.200
     5.000   153.969     0.200
     1.352    40.215     0.200
     3.992   122.625     0.200
     4.664   144.824     0.200
     8.631   266.652     0.200
     1.343    40.094     0.200
     1.609    51.383     0.200
     3.988   121.984     0.200
     5.645   176.184     0.200
     0.438    14.430     0.200
     0.441    14.219     0.200
     0.706    22.562     0.200
     1.176    37.492     0.200
     1.292    39.969     0.200
     1.660    51.094     0.200
     1.829    56.469     0.200
     3.960   122.492     0.200
     4.725   146.992     0.200
     5.696   177.891     0.200
     0.263     8.918     0.200
     0.328    11.368     0.200
     1.223    38.818     0.200
     1.565    47.368     0.200
     1.823    55.318     0.200
     1.700    50.664     0.200
     4.905   150.695     0.200
     0.193     6.879     0.200
     1.105    35.578     0.200
     1.232    38.980     0.200
     4.827   150.078     0.200
     0.294     9.336     0.200
     0.345    10.938     0.200
     1.042    34.234     0.200
     1.405    44.641     0.200
     1.511    46.836     0.200
     0.327    10.453     0.200
     0.748    25.047     0.200
     1.047    34.438     0.200
     1.222    39.094     0.200
     2.407    73.133     0.200
     0.277     9.910     0.200
     0.360    12.391     0.200
     0.274     9.984     0.200
     0.564    19.445     0.200
     1.594    49.324     0.200
     1.650    51.047     0.200
     1.161    37.443     0.200
     0.865    29.586     0.200
     3.185    97.184     0.200
     5.097   157.961     0.200
     1.238    39.926     0.200
     1.377    44.445     0.200
     1.789    54.516     0.200
     5.005   155.525     0.200
     1.137    36.176     0.200
     1.348    42.926     0.200
     1.828    57.219     0.200
     5.079   157.480     0.200
     9.990   311.777     0.200
     1.371    42.617     0.200
     1.151    37.023     0.200
     1.329    42.281     0.200
     1.563    48.117     0.200
     2.526    78.438     0.200
     5.297   163.789     0.200
     1.207    37.887     0.200
     2.382    72.160     0.200
     3.874   118.238     0.200
     5.213   162.809     0.200
     5.689   176.188     0.200
     0.298     9.840     0.200
     1.013    32.668     0.200
     1.249    39.059     0.200
     3.850   118.918     0.200
     0.453    15.031     0.200
     1.734    53.227     0.200
     3.960   122.094     0.200
     5.079   157.797     0.200
     5.079   158.172     0.200
     5.825   181.297     0.200
     8.600   268.586     0.200
     0.440    14.656     0.200
     1.180    36.938     0.200
     3.973   121.898     0.200
     5.087   158.453     0.200
     5.087   157.008     0.200
     5.830   181.133     0.200
     7.623   237.828     0.200
     8.422   260.117     0.200
     8.616   269.328     0.200
     0.457    15.117     0.200
     1.162    36.945     0.200
     1.729    54.156     0.200
     5.082   157.836     0.200
     5.082   157.203     0.200
     1.139    35.770     0.200
     2.277    69.441     0.200
     5.079   158.344     0.200
     5.079   157.680     0.200
     7.639   236.992     0.200
     8.404   261.121     0.200
     8.571   266.520     0.200
    12.084   376.461     0.200
     0.465    14.938     0.200
     1.160    36.516     0.200
     1.203    39.156     0.200
     2.295    71.992     0.200
     3.949   122.586     0.200
     5.087   157.969     0.200
     8.417   260.672     0.200
     0.686    22.762     0.200
     1.243    40.221     0.200
     1.498    47.152     0.200
     1.618    50.682     0.200
     2.272    69.781     0.200
     2.296    70.512     0.200
     5.196   162.072     0.200
     1.196    37.688     0.200
     5.087   157.234     0.200
     6.152   187.578     0.200
     0.382    12.078     0.200
     0.643    21.641     0.200
     0.878    28.359     0.200
     0.939    30.023     0.200
     1.023    31.594     0.200
     1.226    39.008     0.200
     1.238    38.656     0.200
     1.227    40.164     0.200
     1.420    43.859     0.200
     1.720    53.078     0.200
     1.626    50.188     0.200
     1.808    54.141     0.200
     3.954   122.258     0.200
     5.143   158.156     0.200
     0.226     8.473     0.200
     0.226     8.031     0.200
     0.460    15.762     0.200
     0.490    17.961     0.200
     0.758    25.113     0.200
     0.800    26.711     0.200
     0.947    30.293     0.200
     1.076    35.051     0.200
     1.125    36.074     0.200
     1.167    36.852     0.200
     1.345    41.293     0.200
     1.366    43.141     0.200
     1.580    47.691     0.200
     1.733    54.742     0.200
     5.282   164.281     0.200
     0.373    12.909     0.200
     0.776    24.999     0.200
     0.959    30.949     0.200
     1.194    38.009     0.200
     1.261    40.319     0.200
     1.632    49.739     0.200
     1.757    54.589     0.200
     2.242    68.129     0.200
     4.676   145.519     0.200
     5.174   160.489     0.200
     0.331    11.258     0.200
     0.331    11.428     0.200
     0.534    17.917     0.200
     0.812    26.438     0.200
     0.867    28.768     0.200
     0.979    31.417     0.200
     1.227    38.897     0.200
     1.227    38.737     0.200
     1.313    41.088     0.200
     1.283    41.088     0.200
     1.590    50.088     0.200
     1.801    55.567     0.200
     2.020    62.647     0.200
     3.950   120.027     0.200
     5.219   161.798     0.200
     0.239     8.316     0.200
     0.356    11.697     0.200
     0.789    25.527     0.200
     0.789    25.246     0.200
     0.893    29.627     0.200
     0.963    30.967     0.200
     0.963    30.857     0.200
     1.205    37.768     0.200
     1.205    37.967     0.200
     1.266    40.486     0.200
     1.266    40.627     0.200
     1.575    48.146     0.200
     1.777    55.787     0.200
     2.902    88.617     0.200
     5.194   162.178     0.200
     5.712   174.336     0.200
     6.612   200.537     0.200
     8.560   266.297     0.200
     0.548    16.863     0.200
     0.548    17.414     0.200
     0.548    17.305     0.200
     0.613    20.135     0.200
     0.613    20.004     0.200
     0.845    27.443     0.200
     1.004    32.914     0.200
     1.038    33.283     0.200
     1.083    34.994     0.200
     1.136    36.555     0.200
     1.382    43.635     0.200
     1.380    43.594     0.200
     1.608    50.113     0.200
     1.769    54.074     0.200
     1.783    55.344     0.200
     1.892    58.354     0.200
     2.182    67.344     0.200
     2.749    84.734     0.200
     5.013   156.344     0.200
     0.257     8.080     0.200
     0.340    10.750     0.200
     0.340    11.061     0.200
     0.588    20.471     0.200
     0.867    29.041     0.200
     0.923    27.182     0.200
     0.962    29.932     0.200
     1.072    35.631     0.200
     1.214    38.320     0.200
     1.267    40.320     0.200
     1.408    45.320     0.200
     1.533    47.730     0.200
     1.550    48.951     0.200
     1.581    48.371     0.200
     1.625    50.820     0.200
     1.692    51.541     0.200
     1.711    52.631     0.200
     1.711    53.451     0.200
     1.823    56.400     0.200
     2.391    73.090     0.200
     5.222   162.420     0.200
     0.789    25.500     0.200
     0.985    31.301     0.200
     1.021    31.941     0.200
     1.086    33.762     0.200
     1.216    38.430     0.200
     1.266    40.680     0.200
     1.300    40.340     0.200
     1.668    51.191     0.200
     1.736    54.051     0.200
     2.781    84.793     0.200
     0.234     8.328     0.200
     0.332    11.344     0.200
     0.584    21.008     0.200
     0.531    17.195     0.200
     0.801    26.445     0.200
     0.812    26.414     0.200
     0.870    28.805     0.200
     0.980    31.867     0.200
     1.075    34.094     0.200
     1.165    37.594     0.200
     1.192    36.297     0.200
     1.192    36.508     0.200
     1.227    38.758     0.200
     1.227    38.539     0.200
     1.284    40.789     0.200
     1.414    44.617     0.200
     1.543    47.445     0.200
     1.593    48.477     0.200
     1.647    52.508     0.200
     1.724    53.828     0.200
     5.217   162.336     0.200
     0.177     5.953     0.200
     0.413    13.689     0.200
     0.413    13.822     0.200
     0.776    24.934     0.200
     0.776    25.463     0.200
     0.918    29.793     0.200
     0.977    31.992     0.200
     1.000    32.162     0.200
     1.000    32.373     0.200
     1.202    37.953     0.200
     1.202    38.141     0.200
     1.261    40.291     0.200
     1.283    41.090     0.200
     1.295    41.873     0.200
     1.410    44.912     0.200
     1.315    41.393     0.200
     1.531    48.812     0.200
     1.667    51.863     0.200
     1.851    57.293     0.200
     2.130    66.893     0.200
     2.184    68.137     0.200
     2.557    78.867     0.200
     0.342    11.867     0.200
     1.087    34.877     0.200
     1.275    41.076     0.200
     1.289    41.086     0.200
     1.331    41.957     0.200
     1.893    58.117     0.200
     1.907    58.688     0.200
     5.101   158.047     0.200
     0.398    12.285     0.200
     0.776    24.506     0.200
     0.955    30.246     0.200
     1.009    31.666     0.200
     1.016    31.885     0.200
     1.107    34.375     0.200
     1.204    38.736     0.200
     1.238    38.006     0.200
     1.321    40.977     0.200
     1.308    41.666     0.200
     1.435    45.625     0.200
     1.706    52.516     0.200
     1.758    54.236     0.200
     1.795    55.525     0.200
     1.869    57.416     0.200
     1.891    58.346     0.200
     2.315    70.756     0.200
     0.155     5.055     0.200
     0.393    12.924     0.200
     0.425    14.016     0.200
     0.425    14.014     0.200
     0.689    24.184     0.200
     0.790    26.305     0.200
     0.790    26.014     0.200
     0.943    30.895     0.200
     1.027    33.225     0.200
     1.218    38.363     0.200
     1.218    39.508     0.200
     1.240    38.924     0.200
     1.275    40.992     0.200
     1.320    41.984     0.200
     1.443    45.613     0.200
     1.696    52.854     0.200
     1.696    52.715     0.200
     1.868    58.443     0.200
     2.769    84.994     0.200
     3.657   113.215     0.200
     5.085   158.840     0.200
     5.863   182.564     0.200
    12.150   380.090     0.200
     0.421    13.191     0.200
     0.732    23.512     0.200
     0.890    27.859     0.200
     0.929    29.371     0.200
     1.152    35.793     0.200
     1.257    39.660     0.200
     1.228    39.141     0.200
     1.626    50.160     0.200
     1.673    51.730     0.200
     1.676    52.312     0.200
     1.712    52.840     0.200
     1.801    55.582     0.200
     3.303   102.359     0.200
     0.211     7.523     0.200
     0.377    12.402     0.200
     0.377    12.641     0.200
     0.491    16.344     0.200
     0.491    15.660     0.200
     0.491    16.812     0.200
     0.491    15.559     0.200
     0.635    22.613     0.200
     0.705    22.148     0.200
     0.780    25.191     0.200
     0.861    26.641     0.200
     0.998    31.883     0.200
     0.974    31.613     0.200
     0.974    30.961     0.200
     0.974    31.246     0.200
     1.038    32.738     0.200
     1.133    36.023     0.200
     1.213    36.941     0.200
     1.215    38.434     0.200
     1.218    39.227     0.200
     1.201    38.141     0.200
     1.201    37.914     0.200
     1.253    38.602     0.200
     1.275    40.441     0.200
     1.396    42.504     0.200
     1.605    49.344     0.200
     1.691    53.152     0.200
     1.691    53.473     0.200
     1.762    54.801     0.200
     1.785    55.070     0.200
     1.738    54.543     0.200
     1.768    55.141     0.200
     1.805    55.805     0.200
     1.873    57.320     0.200
     1.896    56.391     0.200
     2.860    87.871     0.200
     3.345   104.184     0.200
     5.158   157.918     0.200
     5.158   159.594     0.200
     5.667   176.883     0.200
     8.549   265.102     0.200
     8.586   264.992     0.200
     0.325    10.470     0.200
     0.540    17.185     0.200
     0.540    17.060     0.200
     0.552    17.420     0.200
     0.552    17.807     0.200
     0.618    19.970     0.200
     0.747    23.130     0.200
     0.747    22.902     0.200
     0.844    27.239     0.200
     1.042    32.670     0.200
     1.113    36.177     0.200
     1.124    35.499     0.200
     1.136    36.029     0.200
     1.619    50.359     0.200
     1.619    50.817     0.200
     1.625    51.279     0.200
     1.625    51.075     0.200
     1.639    51.269     0.200
     1.686    52.741     0.200
     1.716    52.470     0.200
     1.758    53.890     0.200
     2.095    65.331     0.200
     2.108    66.609     0.200
     2.108    65.870     0.200
     2.270    71.430     0.200
     2.760    84.850     0.200
     2.834    87.351     0.200
     3.124    96.930     0.200
     3.186    97.729     0.200
     4.064   125.800     0.200
     4.759   147.249     0.200
     5.024   155.350     0.200
     0.374    12.625     0.200
     0.374    12.551     0.200
     0.492    16.309     0.200
     0.514    16.898     0.200
     0.681    21.449     0.200
     0.681    21.285     0.200
     0.776    25.449     0.200
     0.961    30.918     0.200
     0.961    31.070     0.200
     1.056    33.121     0.200
     1.117    35.348     0.200
     1.117    35.086     0.200
     1.194    37.812     0.200
     1.194    37.758     0.200
     1.262    40.348     0.200
     1.286    40.621     0.200
     1.286    40.406     0.200
     1.635    51.520     0.200
     1.667    52.801     0.200
     1.667    52.383     0.200
     1.754    54.359     0.200
     1.754    54.703     0.200
     1.766    54.770     0.200
     1.804    55.262     0.200
     2.989    92.051     0.200
     3.351   103.828     0.200
     4.336   134.090     0.200
     4.397   136.258     0.200
     5.530   172.570     0.200
     0.234     8.535     0.200
     0.380    12.664     0.200
     0.380    12.926     0.200
     0.486    16.227     0.200
     0.486    15.906     0.200
     0.515    16.957     0.200
     0.515    16.605     0.200
     0.515    16.750     0.200
     0.683    21.395     0.200
     0.683    20.980     0.200
     0.770    25.297     0.200
     0.956    30.965     0.200
     0.956    30.652     0.200
     0.980    29.875     0.200
     1.051    32.926     0.200
     1.051    33.059     0.200
     1.116    34.945     0.200
     1.116    35.230     0.200
     1.195    36.707     0.200
     1.197    37.973     0.200
     1.188    37.605     0.200
     1.188    37.898     0.200
     1.257    40.445     0.200
     1.280    40.547     0.200
     1.280    40.379     0.200
     1.378    42.258     0.200
     1.639    51.418     0.200
     1.667    52.715     0.200
     1.749    53.840     0.200
     1.751    53.766     0.200
     1.769    54.848     0.200
     1.798    55.141     0.200
     2.102    63.734     0.200
     2.792    85.895     0.200
     2.796    85.543     0.200
     2.867    88.066     0.200
     2.984    92.102     0.200
     3.015    93.855     0.200
     3.201    98.418     0.200
     3.345   104.027     0.200
     5.166   161.234     0.200
     5.530   172.676     0.200
     0.372    12.453     0.200
     0.372    12.430     0.200
     0.497    15.375     0.200
     0.568    17.836     0.200
     0.568    18.219     0.200
     0.628    19.297     0.200
     0.769    24.242     0.200
     0.930    29.703     0.200
     0.930    29.852     0.200
     1.064    33.305     0.200
     1.097    34.547     0.200
     1.145    35.086     0.200
     1.147    35.258     0.200
     1.181    37.203     0.200
     1.181    37.594     0.200
     1.234    39.617     0.200
     1.305    41.461     0.200
     1.547    47.125     0.200
     1.593    48.266     0.200
     1.684    53.172     0.200
     1.721    53.016     0.200
     1.730    53.523     0.200
     1.730    53.281     0.200
     1.802    55.828     0.200
     2.738    84.547     0.200
     0.284     9.764     0.200
     0.368    12.342     0.200
     0.503    16.104     0.200
     0.575    18.283     0.200
     0.619    19.184     0.200
     0.806    25.842     0.200
     0.930    29.662     0.200
     1.058    33.043     0.200
     1.106    34.383     0.200
     1.183    36.742     0.200
     1.306    41.732     0.200
     1.234    39.434     0.200
     1.312    41.373     0.200
     1.538    46.623     0.200
     1.584    47.572     0.200
     1.676    52.152     0.200
     1.713    52.123     0.200
     1.799    55.893     0.200
     2.929    88.803     0.200
     3.022    93.842     0.200
     3.985   123.873     0.200
     4.427   136.264     0.200
     5.470   169.863     0.200
     6.084   189.104     0.200
     0.431    13.950     0.200
     0.431    13.688     0.200
     0.420    14.021     0.200
     0.420    14.050     0.200
     0.468    15.547     0.200
     0.777    23.090     0.200
     0.925    30.300     0.200
     0.969    30.260     0.200
     0.969    30.423     0.200
     0.996    31.601     0.200
     0.996    32.130     0.200
     1.197    38.220     0.200
     1.232    39.170     0.200
     1.285    40.530     0.200
     1.288    40.895     0.200
     1.291    41.330     0.200
     1.322    41.400     0.200
     1.408    44.990     0.200
     1.408    44.863     0.200
     1.673    51.891     0.200
     1.673    52.180     0.200
     1.674    52.120     0.200
     1.725    53.430     0.200
     1.937    60.604     0.200
     2.190    68.586     0.200
     2.791    86.230     0.200
     2.952    90.320     0.200
     3.084    95.540     0.200
     3.302   102.430     0.200
     3.302   102.171     0.200
     4.334   133.700     0.200
     5.098   157.740     0.200
     0.212     8.236     0.200
     0.389    12.578     0.200
     0.389    13.105     0.200
     0.389    13.387     0.200
     0.480    16.066     0.200
     0.480    15.617     0.200
     0.487    15.287     0.200
     0.487    16.156     0.200
     0.648    22.137     0.200
     0.713    22.326     0.200
     0.713    22.166     0.200
     0.771    25.086     0.200
     0.771    25.307     0.200
     0.874    28.547     0.200
     0.939    30.566     0.200
     0.969    31.207     0.200
     0.969    31.062     0.200
     1.009    30.396     0.200
     1.025    32.207     0.200
     1.025    32.037     0.200
     1.192    37.834     0.200
     1.224    37.426     0.200
     1.231    39.055     0.200
     1.231    38.637     0.200
     1.265    39.646     0.200
     1.269    40.686     0.200
     1.265    40.068     0.200
     1.265    39.877     0.200
     1.617    49.896     0.200
     1.666    51.195     0.200
     1.762    53.924     0.200
     1.797    55.695     0.200
     1.794    54.906     0.200
     1.899    58.559     0.200
     2.766    84.385     0.200
     2.965    92.191     0.200
     3.127    96.725     0.200
     3.710   112.543     0.200
     3.820   118.605     0.200
     4.077   126.086     0.200
     4.358   134.057     0.200
     4.374   135.945     0.200
     4.865   150.166     0.200
     5.145   159.807     0.200
     6.753   210.275     0.200
     0.182     5.902     0.200
     0.442    14.523     0.200
     0.406    13.262     0.200
     0.406    13.832     0.200
     0.476    15.805     0.200
     0.669    23.914     0.200
     0.776    25.582     0.200
     0.776    25.055     0.200
     0.761    23.750     0.200
     0.908    29.035     0.200
     0.986    30.793     0.200
     0.986    30.285     0.200
     0.986    30.125     0.200
     0.968    31.043     0.200
     0.968    32.016     0.200
     0.994    32.074     0.200
     1.054    34.035     0.200
     1.054    33.855     0.200
     1.201    37.809     0.200
     1.201    38.074     0.200
     1.175    37.922     0.200
     1.245    39.965     0.200
     1.245    39.863     0.200
     1.245    39.684     0.200
     1.254    40.906     0.200
     1.291    40.832     0.200
     1.268    40.074     0.200
     1.271    40.559     0.200
     1.304    41.914     0.200
     1.371    44.035     0.200
     1.451    46.105     0.200
     1.656    51.332     0.200
     1.731    53.094     0.200
     1.744    53.582     0.200
     1.799    54.863     0.200
     1.839    58.152     0.200
     1.920    59.199     0.200
     2.173    67.484     0.200
     2.552    78.418     0.200
     3.306   102.785     0.200
     3.315   101.895     0.200
     3.832   118.016     0.200
     4.349   133.652     0.200
     0.220     8.054     0.200
     0.388    12.732     0.200
     0.388    12.934     0.200
     0.388    13.294     0.200
     0.496    16.024     0.200
     0.496    15.786     0.200
     0.480    15.724     0.200
     0.480    16.064     0.200
     0.645    21.364     0.200
     0.704    22.034     0.200
     0.704    22.139     0.200
     0.769    25.314     0.200
     0.935    30.074     0.200
     0.964    31.014     0.200
     1.001    30.504     0.200
     1.032    32.154     0.200
     1.135    35.844     0.200
     1.135    36.054     0.200
     1.135    35.951     0.200
     1.189    37.814     0.200
     1.215    37.024     0.200
     1.228    39.052     0.200
     1.228    38.664     0.200
     1.218    38.451     0.200
     1.259    39.884     0.200
     1.268    39.994     0.200
     1.268    39.654     0.200
     1.268    39.887     0.200
     1.264    40.354     0.200
     1.688    53.924     0.200
     1.688    52.943     0.200
     1.732    53.874     0.200
     1.732    53.674     0.200
     1.759    55.234     0.200
     1.789    55.294     0.200
     2.813    86.870     0.200
     2.970    92.014     0.200
     2.970    91.862     0.200
     4.068   126.624     0.200
     4.872   150.794     0.200
     5.150   159.334     0.200
     6.104   187.874     0.200
     6.131   190.034     0.200
     0.465    14.652     0.200
     0.479    15.023     0.200
     0.479    15.303     0.200
     0.506    16.354     0.200
     0.506    16.244     0.200
     0.676    21.592     0.200
     0.712    22.953     0.200
     0.712    23.152     0.200
     0.815    24.873     0.200
     0.786    24.877     0.200
     0.867    28.002     0.200
     0.867    27.889     0.200
     0.867    28.113     0.200
     1.025    31.662     0.200
     1.028    31.615     0.200
     1.090    34.350     0.200
     1.215    38.213     0.200
     1.215    38.342     0.200
     1.332    41.936     0.200
     1.422    45.410     0.200
     1.422    44.742     0.200
     1.464    44.252     0.200
     1.500    46.762     0.200
     1.615    49.773     0.200
     1.591    50.193     0.200
     1.591    50.035     0.200
     1.945    59.297     0.200
     2.090    67.486     0.200
     2.090    65.613     0.200
     2.092    65.041     0.200
     2.092    64.873     0.200
     2.130    66.148     0.200
     2.130    66.023     0.200
     2.236    69.879     0.200
     2.236    69.203     0.200
     2.340    72.252     0.200
     2.809    86.094     0.200
     3.032    92.363     0.200
     3.362   103.693     0.200
     3.499   108.533     0.200
     4.449   137.953     0.200
     5.260   163.512     0.200
     5.956   183.322     0.200
     0.374    12.323     0.200
     0.374    12.562     0.200
     0.493    15.785     0.200
     0.493    16.373     0.200
     0.554    17.418     0.200
     0.554    17.553     0.200
     0.622    20.593     0.200
     0.768    24.812     0.200
     0.824    25.753     0.200
     0.936    30.172     0.200
     0.936    29.973     0.200
     1.078    33.747     0.200
     1.084    34.046     0.200
     1.084    33.213     0.200
     1.158    34.603     0.200
     1.161    36.398     0.200
     1.199    38.627     0.200
     1.199    37.973     0.200
     1.182    37.769     0.200
     1.182    37.663     0.200
     1.209    36.652     0.200
     1.319    42.332     0.200
     1.319    41.713     0.200
     1.240    38.843     0.200
     1.298    41.339     0.200
     1.298    40.583     0.200
     1.559    47.203     0.200
     1.698    52.873     0.200
     1.734    53.583     0.200
     1.735    53.794     0.200
     1.735    53.673     0.200
     1.800    55.887     0.200
     1.835    56.283     0.200
     2.261    70.083     0.200
     2.982    92.783     0.200
     3.006    93.204     0.200
     3.057    94.978     0.200
     3.057    95.163     0.200
     3.317   102.393     0.200
     4.008   124.553     0.200
     4.412   135.293     0.200
     5.491   170.833     0.200
     6.051   189.123     0.200
     6.089   190.343     0.200
     6.105   190.643     0.200
     0.255     8.246     0.200
     0.255     8.152     0.200
     0.503    16.555     0.200
     0.553    16.711     0.200
     0.553    17.062     0.200
     0.612    19.305     0.200
     0.612    19.082     0.200
     0.881    27.594     0.200
     0.886    28.652     0.200
     1.034    32.422     0.200
     1.034    33.082     0.200
     1.095    34.473     0.200
     1.097    34.129     0.200
     1.103    34.570     0.200
     1.103    34.883     0.200
     1.121    35.016     0.200
     1.170    36.754     0.200
     1.392    44.328     0.200
     1.392    44.516     0.200
     1.296    41.488     0.200
     1.296    40.383     0.200
     1.340    42.605     0.200
     1.412    45.062     0.200
     1.412    44.684     0.200
     1.473    44.594     0.200
     1.660    52.016     0.200
     1.837    57.031     0.200
     2.297    72.613     0.200
     2.297    72.035     0.200
     2.363    74.488     0.200
     3.279   100.242     0.200
     0.425    13.023     0.200
     0.433    13.688     0.200
     0.433    14.281     0.200
     0.460    14.766     0.200
     0.763    24.766     0.200
     0.939    30.375     0.200
     0.955    30.047     0.200
     0.994    31.883     0.200
     0.994    31.234     0.200
     1.190    37.617     0.200
     1.219    38.906     0.200
     1.219    38.453     0.200
     1.210    38.328     0.200
     1.299    40.953     0.200
     1.302    41.305     0.200
     1.410    44.906     0.200
     1.336    41.703     0.200
     1.688    52.445     0.200
     1.768    54.680     0.200
     1.768    54.875     0.200
     2.204    68.789     0.200
     2.204    68.391     0.200
     2.572    79.359     0.200
     2.790    86.742     0.200
     2.910    90.320     0.200
     2.966    91.555     0.200
     3.290   101.102     0.200
     3.290   101.664     0.200
     3.287   102.039     0.200
     4.148   128.680     0.200
     4.321   133.266     0.200
     4.721   147.211     0.200
     4.798   148.492     0.200
     0.247     8.320     0.200
     0.275     9.414     0.200
     0.485    16.312     0.200
     0.585    19.531     0.200
     0.585    19.312     0.200
     0.769    24.539     0.200
     0.769    23.984     0.200
     0.769    23.719     0.200
     0.799    25.438     0.200
     0.847    28.719     0.200
     0.847    28.281     0.200
     1.105    35.539     0.200
     1.120    35.773     0.200
     1.120    35.977     0.200
     1.127    35.758     0.200
     1.127    35.648     0.200
     1.228    39.180     0.200
     1.228    38.945     0.200
     1.228    38.797     0.200
     1.297    40.547     0.200
     1.297    40.125     0.200
     1.409    44.383     0.200
     1.429    44.820     0.200
     1.429    45.086     0.200
     1.486    45.352     0.200
     1.486    44.836     0.200
     1.533    47.352     0.200
     1.748    54.078     0.200
     1.854    57.797     0.200
     1.887    57.820     0.200
     1.975    61.758     0.200
     1.975    60.867     0.200
     1.991    60.930     0.200
     2.077    63.258     0.200
     2.581    78.656     0.200
     2.771    85.500     0.200
     3.190    97.867     0.200
     3.245   101.031     0.200
     3.247   100.430     0.200
     4.185   128.477     0.200
     5.481   169.516     0.200
     0.522    15.641     0.200
     0.522    15.984     0.200
     0.532    17.906     0.200
     0.594    18.820     0.200
     0.594    18.617     0.200
     0.656    21.102     0.200
     0.842    27.328     0.200
     0.950    30.086     0.200
     0.950    30.492     0.200
     0.993    31.102     0.200
     0.993    31.336     0.200
     1.026    30.477     0.200
     1.094    35.797     0.200
     1.290    41.656     0.200
     1.290    41.328     0.200
     1.220    37.945     0.200
     1.238    39.273     0.200
     1.413    43.469     0.200
     1.523    48.117     0.200
     2.246    69.992     0.200
     2.306    72.922     0.200
     2.306    71.453     0.200
     2.287    70.750     0.200
     2.447    75.000     0.200
     4.583   142.984     0.200
     5.185   159.812     0.200
     6.054   187.914     0.200
     0.345    11.801     0.200
     0.371    12.754     0.200
     0.371    12.672     0.200
     0.550    16.910     0.200
     0.550    17.320     0.200
     0.527    16.777     0.200
     0.642    20.164     0.200
     0.777    25.422     0.200
     0.777    25.102     0.200
     0.853    27.750     0.200
     0.901    29.191     0.200
     0.993    31.520     0.200
     0.993    31.230     0.200
     0.993    31.402     0.200
     1.075    32.680     0.200
     1.259    39.980     0.200
     1.259    40.750     0.200
     1.161    36.875     0.200
     1.209    38.500     0.200
     1.347    42.547     0.200
     1.653    49.902     0.200
     1.705    52.969     0.200
     1.705    53.109     0.200
     1.770    54.570     0.200
     1.815    56.133     0.200
     1.815    55.832     0.200
     1.985    62.469     0.200
     2.661    82.535     0.200
     2.747    84.543     0.200
     2.965    91.918     0.200
     3.043    93.391     0.200
     3.173    98.691     0.200
     3.399   105.707     0.200
     3.917   120.469     0.200
     0.136     6.011     0.200
     0.307     9.828     0.200
     0.463    14.977     0.200
     0.515    16.931     0.200
     0.515    17.060     0.200
     0.898    27.970     0.200
     0.894    27.813     0.200
     1.092    35.064     0.200
     1.218    38.695     0.200
     1.259    39.908     0.200
     1.310    41.665     0.200
     1.329    41.503     0.200
     1.393    43.573     0.200
     1.608    49.393     0.200
     2.591    79.301     0.200
     2.683    83.208     0.200
     2.885    89.175     0.200
     3.026    93.119     0.200
     3.290   100.684     0.200
     3.321   102.126     0.200
     3.544   108.903     0.200
     0.391    12.805     0.200
     0.428    13.609     0.200
     0.496    16.047     0.200
     0.767    23.766     0.200
     1.015    32.219     0.200
     1.204    37.984     0.200
     1.222    38.754     0.200
     1.261    40.023     0.200
     1.270    40.234     0.200
     1.421    45.391     0.200
     1.699    52.809     0.200
     1.811    55.965     0.200
     1.912    58.641     0.200
     2.170    67.703     0.200
     2.718    84.340     0.200
     2.952    91.816     0.200
     3.094    95.918     0.200
     3.325   102.520     0.200
     3.332   102.402     0.200
     0.302     9.599     0.200
     0.302     9.705     0.200
     0.471    15.295     0.200
     0.471    15.469     0.200
     0.513    17.039     0.200
     0.734    23.869     0.200
     0.827    26.479     0.200
     0.885    27.595     0.200
     0.906    28.238     0.200
     1.011    32.278     0.200
     1.051    33.499     0.200
     1.094    35.079     0.200
     1.186    36.339     0.200
     1.211    38.349     0.200
     1.211    38.639     0.200
     1.257    39.849     0.200
     1.318    41.479     0.200
     1.335    41.448     0.200
     1.381    44.198     0.200
     1.400    43.379     0.200
     1.402    43.416     0.200
     1.415    44.479     0.200
     1.600    48.669     0.200
     1.600    49.067     0.200
     1.771    53.369     0.200
     1.892    58.703     0.200
     2.103    65.038     0.200
     0.309    10.016     0.200
     0.466    14.903     0.200
     0.511    16.819     0.200
     0.899    28.347     0.200
     0.890    27.320     0.200
     1.089    34.897     0.200
     1.213    38.533     0.200
     1.254    39.521     0.200
     1.314    41.160     0.200
     1.328    41.143     0.200
     1.395    43.188     0.200
     1.605    49.256     0.200
     1.809    55.745     0.200
     1.884    58.487     0.200
     2.290    69.291     0.200
     0.306    10.195     0.200
     0.306    10.021     0.200
     0.466    15.838     0.200
     0.466    15.586     0.200
     0.514    17.145     0.200
     0.729    25.176     0.200
     0.729    24.145     0.200
     0.827    26.904     0.200
     0.827    26.654     0.200
     0.901    28.314     0.200
     0.901    28.506     0.200
     0.886    29.795     0.200
     0.890    27.596     0.200
     0.890    27.408     0.200
     1.005    31.475     0.200
     1.045    33.416     0.200
     1.092    35.166     0.200
     1.180    36.516     0.200
     1.215    38.525     0.200
     1.215    38.783     0.200
     1.258    39.836     0.200
     1.258    40.191     0.200
     1.330    41.125     0.200
     1.330    41.715     0.200
     1.313    41.676     0.200
     1.379    43.246     0.200
     1.394    42.395     0.200
     1.396    43.740     0.200
     1.605    49.375     0.200
     1.605    48.918     0.200
     1.754    54.945     0.200
     1.886    58.215     0.200
     1.958    60.645     0.200
     1.957    59.756     0.200
     1.972    61.277     0.200
     2.108    64.977     0.200
     2.589    79.348     0.200
     2.685    83.340     0.200
     2.703    83.176     0.200
     3.023    92.861     0.200
     3.202    99.225     0.200
     3.234    96.340     0.200
     3.287   101.355     0.200
     3.287   100.850     0.200
     3.317   102.779     0.200
     3.319   102.574     0.200
     3.319   102.305     0.200
     3.694   114.996     0.200
     4.295   132.256     0.200
     4.536   136.299     0.200
     4.722   147.145     0.200
     0.299     9.121     0.200
     0.334    10.791     0.200
     0.535    16.412     0.200
     0.535    16.201     0.200
     0.520    18.402     0.200
     0.602    18.691     0.200
     0.701    24.191     0.200
     0.779    26.062     0.200
     1.010    31.840     0.200
     1.309    42.006     0.200
     1.217    38.096     0.200
     1.253    39.434     0.200
     1.418    44.057     0.200
     1.891    59.191     0.200
     2.264    70.254     0.200
     2.702    82.697     0.200
     0.403    13.208     0.200
     0.403    13.210     0.200
     0.428    13.002     0.200
     0.485    15.829     0.200
     0.666    22.840     0.200
     0.772    24.176     0.200
     0.968    31.110     0.200
     0.982    30.602     0.200
     1.008    32.240     0.200
     1.008    32.534     0.200
     1.062    32.930     0.200
     1.204    37.950     0.200
     1.252    39.088     0.200
     1.212    38.464     0.200
     1.249    39.160     0.200
     1.249    39.563     0.200
     1.276    39.550     0.200
     1.278    39.753     0.200
     1.309    38.890     0.200
     1.297    41.180     0.200
     1.417    44.800     0.200
     1.661    49.980     0.200
     1.688    51.570     0.200
     1.757    55.160     0.200
     1.794    55.210     0.200
     1.794    55.380     0.200
     1.800    55.740     0.200
     1.829    57.880     0.200
     1.846    57.050     0.200
     1.923    59.920     0.200
     2.179    66.490     0.200
     2.940    90.319     0.200
     2.940    91.390     0.200
     3.319   101.899     0.200
     4.727   147.080     0.200
     0.585    18.879     0.200
     0.850    26.986     0.200
     0.893    29.887     0.200
     0.986    31.127     0.200
     1.310    40.387     0.200
     1.310    41.010     0.200
     1.322    41.787     0.200
     1.322    42.613     0.200
     1.423    46.037     0.200
     1.850    57.768     0.200
     1.893    57.979     0.200
     1.893    58.184     0.200
     1.913    58.107     0.200
     1.913    59.027     0.200
     3.383   105.078     0.200
     3.403   105.887     0.200
     0.264     8.584     0.200
     0.335    10.533     0.200
     0.428    14.314     0.200
     0.428    14.013     0.200
     0.589    19.265     0.200
     0.589    18.944     0.200
     0.589    18.434     0.200
     0.743    24.234     0.200
     0.774    23.624     0.200
     0.774    24.204     0.200
     0.853    28.924     0.200
     0.967    30.174     0.200
     0.967    30.056     0.200
     1.045    33.864     0.200
     1.045    33.224     0.200
     1.091    34.664     0.200
     1.091    34.484     0.200
     1.091    35.203     0.200
     1.118    35.274     0.200
     1.118    34.874     0.200
     1.172    37.114     0.200
     1.172    37.424     0.200
     1.172    37.578     0.200
     1.166    36.214     0.200
     1.271    39.654     0.200
     1.271    39.534     0.200
     1.320    41.494     0.200
     1.358    42.484     0.200
     1.374    44.054     0.200
     1.406    44.214     0.200
     1.437    44.524     0.200
     1.437    45.616     0.200
     1.486    46.104     0.200
     1.520    47.684     0.200
     1.669    50.734     0.200
     1.795    55.834     0.200
     1.795    56.048     0.200
     1.924    58.964     0.200
     1.984    60.714     0.200
     2.098    65.980     0.200
     2.845    88.310     0.200
     3.163    98.074     0.200
     3.205    99.684     0.200
     3.205    99.038     0.200
     3.947   122.986     0.200
     4.170   129.474     0.200
     4.170   128.266     0.200
     4.307   132.688     0.200
     0.277     9.188     0.200
     0.334    11.381     0.200
     0.538    16.906     0.200
     0.608    19.047     0.200
     0.576    17.973     0.200
     0.806    26.156     0.200
     0.851    28.207     0.200
     0.955    30.154     0.200
     1.060    33.238     0.200
     1.116    34.096     0.200
     1.152    36.928     0.200
     1.133    34.980     0.200
     1.324    42.557     0.200
     1.215    38.703     0.200
     1.786    54.760     0.200
     1.840    57.029     0.200
     1.828    56.297     0.200
     0.339    11.090     0.200
     0.448    14.977     0.200
     0.448    15.371     0.200
     0.526    16.742     0.200
     0.526    16.637     0.200
     0.763    24.578     0.200
     0.838    26.340     0.200
     0.838    27.012     0.200
     0.790    26.930     0.200
     0.913    28.043     0.200
     1.043    33.488     0.200
     1.043    33.625     0.200
     1.054    34.047     0.200
     1.145    35.449     0.200
     1.145    37.102     0.200
     1.102    35.707     0.200
     1.193    37.828     0.200
     1.375    43.363     0.200
     1.428    44.797     0.200
     1.456    45.977     0.200
     1.548    47.508     0.200
     2.328    71.094     0.200
     4.230   130.277     0.200
     0.447    14.148     0.200
     0.447    14.219     0.200
     0.514    16.000     0.200
     0.514    16.172     0.200
     0.489    15.781     0.200
     0.489    15.672     0.200
     0.707    23.219     0.200
     0.717    23.297     0.200
     0.851    25.672     0.200
     0.820    25.727     0.200
     0.925    29.547     0.200
     0.925    29.727     0.200
     1.063    32.273     0.200
     1.066    32.633     0.200
     1.176    37.906     0.200
     1.108    34.750     0.200
     1.108    34.586     0.200
     1.211    40.055     0.200
     1.174    36.758     0.200
     1.492    44.352     0.200
     1.479    46.438     0.200
     1.555    49.156     0.200
     1.650    50.531     0.200
     1.625    51.648     0.200
     1.792    54.383     0.200
     1.981    60.148     0.200
     2.147    67.656     0.200
     2.147    68.016     0.200
     2.146    67.570     0.200
     2.155    68.383     0.200
     2.155    68.555     0.200
     2.289    72.125     0.200
     2.327    71.594     0.200
     2.327    71.289     0.200
     3.355   103.109     0.200
     0.237     7.691     0.200
     0.422    14.051     0.200
     0.550    18.164     0.200
     0.550    18.270     0.200
     0.550    18.121     0.200
     0.736    23.918     0.200
     0.917    27.875     0.200
     1.022    33.230     0.200
     1.022    32.543     0.200
     1.073    34.289     0.200
     1.117    35.551     0.200
     1.117    35.172     0.200
     1.167    36.559     0.200
     1.167    37.371     0.200
     1.167    37.168     0.200
     1.314    42.141     0.200
     1.314    41.855     0.200
     1.302    41.828     0.200
     1.302    41.281     0.200
     1.400    44.219     0.200
     1.400    44.328     0.200
     1.439    45.414     0.200
     1.473    45.789     0.200
     1.473    45.039     0.200
     1.527    47.648     0.200
     1.619    49.570     0.200
     1.825    56.539     0.200
     1.876    58.070     0.200
     1.882    58.789     0.200
     1.882    57.281     0.200
     1.962    61.469     0.200
     2.008    63.211     0.200
     2.232    69.879     0.200
     2.232    69.312     0.200
     2.234    69.918     0.200
     2.342    71.391     0.200
     2.342    71.828     0.200
     2.640    80.340     0.200
     2.792    86.711     0.200
     3.190    97.684     0.200
     3.219   100.098     0.200
     3.219    99.719     0.200
     3.600   109.707     0.200
     3.676   113.074     0.200
     4.205   129.730     0.200
     4.205   129.480     0.200
     0.260     8.621     0.200
     0.319    10.171     0.200
     0.548    16.261     0.200
     0.634    19.811     0.200
     0.634    19.921     0.200
     0.750    25.171     0.200
     0.810    24.761     0.200
     0.810    25.221     0.200
     0.891    29.151     0.200
     1.053    34.571     0.200
     1.024    31.831     0.200
     1.060    32.421     0.200
     1.006    32.511     0.200
     1.035    32.980     0.200
     1.189    38.221     0.200
     1.291    40.201     0.200
     1.315    41.671     0.200
     1.412    42.521     0.200
     1.461    44.121     0.200
     1.593    47.411     0.200
     1.614    47.581     0.200
     2.296    71.311     0.200
     2.689    82.351     0.200
     2.980    92.431     0.200
     3.283   102.031     0.200
     0.360    12.102     0.200
     0.360    12.008     0.200
     0.505    16.203     0.200
     0.650    20.156     0.200
     0.650    20.344     0.200
     0.783    25.906     0.200
     0.892    29.383     0.200
     0.953    30.742     0.200
     1.091    34.148     0.200
     1.091    34.328     0.200
     1.160    34.750     0.200
     1.163    36.172     0.200
     1.189    38.133     0.200
     1.189    38.406     0.200
     1.198    37.766     0.200
     1.257    40.109     0.200
     1.344    41.250     0.200
     1.307    40.867     0.200
     1.752    54.656     0.200
     1.752    54.516     0.200
     1.831    56.078     0.200
     1.854    54.898     0.200
     1.814    56.539     0.200
     1.814    56.062     0.200
     2.068    63.469     0.200
     2.068    64.672     0.200
     2.758    84.594     0.200
     2.732    84.906     0.200
     2.659    82.445     0.200
     2.833    87.023     0.200
     3.013    93.188     0.200
     0.366    12.195     0.200
     0.366    12.016     0.200
     0.500    16.094     0.200
     0.653    19.797     0.200
     0.778    25.375     0.200
     0.898    29.820     0.200
     0.950    30.570     0.200
     0.950    30.758     0.200
     0.950    30.484     0.200
     1.092    34.219     0.200
     1.080    33.844     0.200
     1.080    33.680     0.200
     1.193    37.648     0.200
     1.201    38.305     0.200
     1.195    38.625     0.200
     1.195    38.383     0.200
     1.212    37.094     0.200
     1.301    41.164     0.200
     1.348    41.969     0.200
     1.714    52.461     0.200
     1.748    54.359     0.200
     1.809    55.875     0.200
     1.836    56.398     0.200
     2.073    64.078     0.200
     2.729    84.750     0.200
     2.762    85.250     0.200
     2.997    93.281     0.200
     3.364   104.023     0.200
     0.318    11.695     0.200
     0.462    16.594     0.200
     0.533    17.875     0.200
     0.533    17.633     0.200
     0.777    26.109     0.200
     0.797    26.625     0.200
     0.797    27.094     0.200
     0.934    29.859     0.200
     0.934    29.070     0.200
     1.146    35.500     0.200
     1.146    36.227     0.200
     1.208    38.375     0.200
     1.228    38.352     0.200
     1.470    44.164     0.200
     0.249     8.115     0.200
     0.586    18.575     0.200
     0.591    19.555     0.200
     0.679    21.205     0.200
     0.828    26.385     0.200
     0.887    28.765     0.200
     0.927    29.725     0.200
     0.933    30.335     0.200
     1.450    44.795     0.200
     1.517    48.125     0.200
     1.650    51.055     0.200
     0.384    12.152     0.200
     0.485    16.082     0.200
     0.714    22.051     0.200
     0.776    24.340     0.200
     0.935    28.840     0.200
     0.975    31.500     0.200
     1.008    32.371     0.200
     1.148    36.242     0.200
     1.198    38.051     0.200
     1.247    39.820     0.200
     1.274    40.711     0.200
     1.664    51.312     0.200
     1.699    52.441     0.200
     1.795    55.109     0.200
     1.799    55.812     0.200
     0.375    12.687     0.200
     0.434    14.557     0.200
     0.503    16.477     0.200
     0.768    25.227     0.200
     0.747    24.527     0.200
     0.871    26.987     0.200
     1.023    32.327     0.200
     1.013    32.467     0.200
     1.075    34.807     0.200
     1.171    37.097     0.200
     1.157    36.707     0.200
     1.177    37.657     0.200
     1.299    41.227     0.200
     1.354    42.867     0.200
     1.421    44.287     0.200
     1.737    53.777     0.200
     1.774    53.637     0.200
     1.782    55.347     0.200
     1.841    56.387     0.200
     2.837    87.147     0.200
     4.249   130.997     0.200
     0.413    14.117     0.200
     0.413    13.633     0.200
     0.572    18.539     0.200
     0.689    21.430     0.200
     0.814    24.773     0.200
     0.838    27.422     0.200
     0.841    27.312     0.200
     1.002    33.102     0.200
     1.207    37.961     0.200
     1.488    44.688     0.200
     3.155    96.703     0.200
     3.190    99.086     0.200
     0.468    16.545     0.200
     0.547    18.475     0.200
     0.760    25.846     0.200
     1.051    33.426     0.200
     0.923    30.473     0.200
     0.923    30.344     0.200
     0.982    31.965     0.200
     0.982    32.242     0.200
     0.994    32.305     0.200
     1.068    33.941     0.200
     1.068    34.543     0.200
     1.200    38.324     0.200
     1.288    41.395     0.200
     1.288    40.984     0.200
     1.319    41.863     0.200
     1.319    40.773     0.200
     1.465    45.383     0.200
     1.536    47.133     0.200
     1.755    55.113     0.200
     2.793    86.082     0.200
     5.100   158.242     0.200
     0.422    14.742     0.200
     0.687    24.160     0.200
     0.929    30.051     0.200
     0.929    30.473     0.200
     0.988    32.062     0.200
     0.994    32.090     0.200
     1.074    34.410     0.200
     1.074    34.191     0.200
     1.273    40.012     0.200
     1.326    41.723     0.200
     1.326    40.711     0.200
     1.290    41.250     0.200
     1.290    41.461     0.200
     1.290    40.500     0.200
     1.472    45.590     0.200
     1.541    47.941     0.200
     1.543    47.582     0.200
     1.678    51.422     0.200
     1.669    51.230     0.200
     1.760    55.242     0.200
     2.194    68.531     0.200
     5.093   157.266     0.200
     0.509    16.082     0.200
     0.656    21.152     0.200
     0.763    25.111     0.200
     0.797    23.461     0.200
     0.797    24.381     0.200
     0.971    30.801     0.200
     0.999    31.352     0.200
     1.058    32.611     0.200
     1.148    37.182     0.200
     1.151    36.211     0.200
     1.194    36.881     0.200
     1.306    41.941     0.200
     1.261    39.691     0.200
     1.261    39.381     0.200
     1.292    41.691     0.200
     1.280    41.012     0.200
     1.280    41.291     0.200
     1.306    42.062     0.200
     1.408    43.082     0.200
     1.525    48.172     0.200
     1.584    47.301     0.200
     2.192    68.961     0.200
     3.059    94.521     0.200
     3.796   117.201     0.200
     0.289    10.801     0.200
     0.788    26.961     0.200
     0.807    26.840     0.200
     0.807    26.730     0.200
     1.066    33.953     0.200
     1.066    34.090     0.200
     1.093    35.531     0.200
     1.106    34.973     0.200
     1.106    35.203     0.200
     1.237    38.602     0.200
     1.237    38.883     0.200
     1.237    39.582     0.200
     1.472    44.410     0.200
     1.673    49.520     0.200
     0.804    25.047     0.200
     0.920    30.504     0.200
     1.018    31.117     0.200
     1.349    40.605     0.200
     1.486    46.465     0.200
     1.680    51.117     0.200
     1.707    51.516     0.200
     1.814    55.617     0.200
     2.085    63.977     0.200
     0.685    21.375     0.200
     0.776    23.305     0.200
     0.776    23.535     0.200
     0.858    27.445     0.200
     0.952    31.055     0.200
     0.970    30.645     0.200
     0.970    30.925     0.200
     1.123    36.445     0.200
     1.281    41.065     0.200
     1.250    39.445     0.200
     1.250    39.665     0.200
     1.261    40.125     0.200
     1.261    40.625     0.200
     1.354    43.835     0.200
     1.393    41.645     0.200
     1.439    43.585     0.200
     1.439    45.135     0.200
     1.496    47.305     0.200
     1.554    47.785     0.200
     1.566    48.835     0.200
     1.994    61.115     0.200
     0.561    17.117     0.200
     0.812    25.945     0.200
     0.910    27.434     0.200
     0.967    31.004     0.200
     1.076    33.945     0.200
     1.167    35.887     0.200
     1.199    38.117     0.200
     1.223    38.637     0.200
     1.273    40.195     0.200
     1.518    45.996     0.200
     1.567    47.957     0.200
     1.697    51.836     0.200
     1.821    55.746     0.200
     5.237   161.816     0.200
     0.553    16.565     0.200
     0.805    26.466     0.200
     0.921    27.936     0.200
     0.965    31.086     0.200
     1.082    33.886     0.200
     1.179    35.796     0.200
     1.201    37.815     0.200
     1.217    38.306     0.200
     1.530    46.325     0.200
     1.578    47.865     0.200
     1.625    50.516     0.200
     5.226   160.155     0.200
     0.299    10.508     0.200
     0.299    10.758     0.200
     0.878    28.605     0.200
     1.148    35.105     0.200
     1.148    35.207     0.200
     1.128    36.117     0.200
     1.333    42.195     0.200
     1.333    42.426     0.200
     1.307    41.688     0.200
     1.368    42.586     0.200
     1.514    47.027     0.200
     1.540    46.887     0.200
     1.722    51.816     0.200
     1.880    59.078     0.200
     2.252    67.906     0.200
     0.505    17.438     0.200
     0.909    28.246     0.200
     0.909    28.547     0.200
     0.954    31.805     0.200
     1.124    35.586     0.200
     1.124    34.496     0.200
     1.175    38.305     0.200
     1.314    40.137     0.200
     1.299    40.137     0.200
     1.325    41.164     0.200
     1.342    41.727     0.200
     1.325    41.996     0.200
     1.369    43.156     0.200
     1.477    45.566     0.200
     1.421    46.355     0.200
     1.421    44.777     0.200
     1.693    53.855     0.200
     0.403    12.504     0.200
     0.405    12.395     0.200
     0.965    31.273     0.200
     1.048    31.996     0.200
     1.048    31.875     0.200
     1.184    37.793     0.200
     1.252    39.914     0.200
     1.277    41.633     0.200
     1.277    41.215     0.200
     1.445    45.266     0.200
     1.703    52.676     0.200
     1.702    52.906     0.200
     1.694    53.016     0.200
     1.694    52.613     0.200
     1.834    56.594     0.200
     2.168    67.516     0.200
     3.966   121.977     0.200
     0.407    12.789     0.200
     0.407    13.219     0.200
     0.491    16.602     0.200
     0.494    16.164     0.200
     0.758    26.109     0.200
     0.986    31.820     0.200
     0.986    31.344     0.200
     1.061    33.539     0.200
     1.144    36.148     0.200
     1.144    35.672     0.200
     1.159    37.211     0.200
     1.159    36.812     0.200
     1.243    39.883     0.200
     1.243    39.211     0.200
     1.274    40.641     0.200
     1.311    41.734     0.200
     1.344    43.031     0.200
     1.344    42.664     0.200
     1.399    43.266     0.200
     1.542    47.891     0.200
     1.751    52.664     0.200
     1.751    54.070     0.200
     1.807    56.102     0.200
     1.807    56.422     0.200
     1.801    53.961     0.200
     1.894    56.320     0.200
     1.932    59.570     0.200
     0.408    13.211     0.200
     0.408    13.344     0.200
     0.500    16.602     0.200
     0.503    16.125     0.200
     0.766    25.156     0.200
     0.766    26.102     0.200
     0.982    31.977     0.200
     0.982    31.461     0.200
     1.070    34.062     0.200
     1.070    33.953     0.200
     1.151    35.805     0.200
     1.151    36.297     0.200
     1.153    36.664     0.200
     1.245    39.852     0.200
     1.245    39.484     0.200
     1.269    40.992     0.200
     1.269    40.633     0.200
     1.310    42.062     0.200
     1.352    42.078     0.200
     1.352    42.781     0.200
     1.407    44.211     0.200
     1.549    48.133     0.200
     1.587    48.953     0.200
     1.759    54.484     0.200
     1.759    52.727     0.200
     1.808    54.414     0.200
     1.809    56.461     0.200
     1.939    60.328     0.200
     2.706    83.602     0.200
     0.497    16.109     0.200
     0.978    31.500     0.200
     1.631    49.602     0.200
     0.504    16.188     0.200
     0.739    22.695     0.200
     0.871    26.078     0.200
     1.261    40.766     0.200
     1.521    45.906     0.200
     1.555    46.719     0.200
     1.671    50.164     0.200
     1.825    56.406     0.200
     0.502    15.281     0.200
     0.955    30.633     0.200
     1.270    41.516     0.200
     1.321    42.906     0.200
     1.573    46.672     0.200
     1.805    55.102     0.200
     1.894    58.125     0.200
     0.669    19.789     0.200
     0.824    24.711     0.200
     0.903    28.336     0.200
     1.148    37.805     0.200
     1.146    36.766     0.200
     1.329    39.617     0.200
     1.357    40.898     0.200
     1.468    44.539     0.200
     1.728    54.219     0.200
     1.784    55.516     0.200
     0.531    16.789     0.200
     0.718    22.398     0.200
     0.923    28.094     0.200
     0.992    31.789     0.200
     1.002    32.594     0.200
     1.016    31.594     0.200
     1.307    43.250     0.200
     1.358    43.891     0.200
     1.492    47.016     0.200
     1.573    47.688     0.200
     1.589    50.047     0.200
     1.608    49.664     0.200
     1.723    52.445     0.200
     1.754    54.008     0.200
     1.772    54.438     0.200
     1.931    60.453     0.200
     1.972    61.094     0.200
     2.161    69.125     0.200
     0.473    15.609     0.200
     0.642    19.070     0.200
     0.887    28.016     0.200
     0.960    28.734     0.200
     1.383    44.906     0.200
     1.442    44.031     0.200
     2.550    77.945     0.200
     3.129    96.102     0.200
     0.480    15.211     0.200
     1.400    45.008     0.200
     1.504    45.078     0.200
     2.037    62.789     0.200
     0.474    14.344     0.200
     1.103    36.859     0.200
     1.491    45.594     0.200
     1.777    54.148     0.200
     2.048    62.820     0.200
     0.515    15.578     0.200
     0.531    16.344     0.200
     0.861    25.953     0.200
     1.042    33.977     0.200
     1.191    36.414     0.200
     1.331    40.594     0.200
     1.389    42.609     0.200
     1.517    45.289     0.200
     1.660    50.250     0.200
     1.830    56.414     0.200
     0.470    16.266     0.200
     0.650    19.789     0.200
     0.778    23.930     0.200
     0.880    27.180     0.200
     0.967    29.188     0.200
     1.102    36.195     0.200
     1.303    39.086     0.200
     1.335    39.508     0.200
     1.450    44.109     0.200
     1.492    44.773     0.200
     1.780    54.055     0.200
     0.507    16.211     0.200
     0.803    24.734     0.200
     1.227    40.000     0.200
     1.644    50.266     0.200
     0.509    16.187     0.200
     0.793    24.387     0.200
     0.809    25.497     0.200
     0.901    29.197     0.200
     0.939    30.657     0.200
     1.075    33.847     0.200
     1.222    40.817     0.200
     1.448    43.737     0.200
     1.479    44.947     0.200
     1.593    48.907     0.200
     1.636    49.837     0.200
     1.763    52.277     0.200
     1.922    58.687     0.200
     2.048    64.977     0.200
     0.534    15.875     0.200
     0.685    20.705     0.200
     0.501    15.166     0.200
     0.736    23.846     0.200
     0.872    25.816     0.200
     1.053    33.526     0.200
     1.261    41.156     0.200
     1.521    46.206     0.200
     1.556    47.506     0.200
     1.672    51.546     0.200
     2.002    61.906     0.200
     2.107    64.966     0.200
     0.489    16.122     0.200
     0.585    17.652     0.200
     0.934    30.622     0.200
     1.241    37.463     0.200
     1.230    39.812     0.200
     2.110    64.793     0.200
     2.351    71.393     0.200
     2.557    77.992     0.200
     2.499    76.343     0.200
     3.072    95.473     0.200
     0.483    15.541     0.200
     0.510    16.534     0.200
     0.756    23.435     0.200
     0.859    26.435     0.200
     0.943    31.614     0.200
     1.048    33.734     0.200
     1.260    41.104     0.200
     1.511    46.555     0.200
     1.544    47.174     0.200
     1.659    50.754     0.200
     1.921    60.154     0.200
     0.480    15.501     0.200
     0.585    17.730     0.200
     0.736    21.921     0.200
     0.906    27.150     0.200
     0.928    29.451     0.200
     0.937    31.431     0.200
     1.060    34.661     0.200
     1.240    38.021     0.200
     1.271    38.671     0.200
     1.236    39.001     0.200
     2.110    65.431     0.200
     0.564    18.262     0.200
     0.597    17.981     0.200
     0.851    28.212     0.200
     0.938    27.821     0.200
     1.129    38.132     0.200
     0.527    16.637     0.200
     0.493    14.576     0.200
     0.653    20.086     0.200
     0.796    24.426     0.200
     1.120    35.877     0.200
     1.340    40.297     0.200
     1.405    45.496     0.200
     1.453    44.627     0.200
     1.782    54.117     0.200
     1.932    59.557     0.200
     0.510    16.000     0.200
     0.740    22.941     0.200
     0.877    26.881     0.200
     0.952    30.641     0.200
     0.989    32.521     0.200
     1.045    32.971     0.200
     1.269    41.660     0.200
     1.315    42.131     0.200
     1.448    45.740     0.200
     1.527    46.080     0.200
     1.561    46.961     0.200
     1.677    50.900     0.200
     1.818    56.061     0.200
     1.889    59.010     0.200
     1.932    60.221     0.200
     0.489    15.238     0.200
     0.626    18.779     0.200
     1.098    35.529     0.200
     0.512    15.445     0.200
     0.618    19.078     0.200
     0.488    15.359     0.200
     0.609    18.227     0.200
     0.760    24.789     0.200
     0.932    28.797     0.200
     0.926    31.137     0.200
     1.085    35.598     0.200
     1.370    44.066     0.200
     1.409    43.090     0.200
     1.459    45.367     0.200
     1.586    46.539     0.200
     1.739    52.199     0.200
     1.866    56.469     0.200
     1.927    60.688     0.200
     0.568    18.254     0.200
     0.699    21.895     0.200
     0.878    27.594     0.200
     0.927    28.922     0.200
     1.037    31.082     0.200
     0.849    28.684     0.200
     1.202    39.473     0.200
     1.364    41.832     0.200
     1.388    42.613     0.200
     1.565    47.785     0.200
     1.693    49.875     0.200
     1.776    55.082     0.200
     1.835    56.953     0.200
     1.822    55.793     0.200
     1.958    59.293     0.200
     0.505    16.383     0.200
     0.873    26.691     0.200
     0.990    33.250     0.200
     0.948    30.562     0.200
     1.049    33.453     0.200
     1.183    36.020     0.200
     1.264    41.703     0.200
     1.310    42.422     0.200
     1.557    46.992     0.200
     1.547    49.512     0.200
     1.673    50.441     0.200
     1.884    58.012     0.200
     1.822    56.152     0.200
     2.004    60.910     0.200
     2.128    67.203     0.200
     2.274    70.281     0.200
     0.632    18.867     0.200
     0.794    25.719     0.200
     0.901    29.520     0.200
     0.961    29.387     0.200
     1.118    36.117     0.200
     1.432    43.637     0.200
     1.488    45.258     0.200
     1.760    53.527     0.200
     1.891    57.387     0.200
     2.066    65.277     0.200
     0.551    18.477     0.200
     0.643    18.957     0.200
     1.153    37.996     0.200
     1.332    40.375     0.200
     1.508    44.266     0.200
     1.767    54.766     0.200
     1.902    57.605     0.200
     1.950    60.195     0.200
     0.507    16.137     0.200
     0.774    23.816     0.200
     0.888    28.844     0.200
     0.933    31.094     0.200
     1.094    32.766     0.200
     1.086    34.004     0.200
     1.903    58.484     0.200
     0.507    16.219     0.200
     0.782    24.059     0.200
     0.816    26.418     0.200
     0.936    30.758     0.200
     1.101    33.918     0.200
     1.082    34.508     0.200
     1.915    59.578     0.200
     2.039    65.688     0.200
     2.129    67.469     0.200
     2.750    85.098     0.200
     2.890    87.457     0.200
     3.055    91.609     0.200
     3.070    95.156     0.200
     0.461    14.422     0.200
     0.640    19.016     0.200
     0.880    27.086     0.200
     1.088    35.398     0.200
     1.292    39.875     0.200
     1.325    41.094     0.200
     1.088    36.250     0.200
     0.438    13.797     0.200
     0.629    18.219     0.200
     1.062    34.969     0.200
     1.461    45.758     0.200
     1.881    58.055     0.200
     1.972    61.336     0.200
     2.067    64.086     0.200
     2.489    77.008     0.200
     0.462    14.621     0.200
     0.859    27.591     0.200
     0.494    16.583     0.200
     0.852    26.083     0.200
     0.928    30.062     0.200
     1.245    40.933     0.200
     1.289    42.223     0.200
     1.683    50.262     0.200
     1.982    60.123     0.200
     0.479    15.285     0.200
     0.588    18.047     0.200
     0.909    27.387     0.200
     0.937    30.875     0.200
     1.234    38.875     0.200
     2.107    65.527     0.200
     2.316    70.297     0.200
     2.348    73.055     0.200
     0.511    15.750     0.200
     0.643    19.266     0.200
     0.802    24.148     0.200
     0.901    29.547     0.200
     1.126    36.836     0.200
     1.169    36.484     0.200
     1.331    40.734     0.200
     1.442    44.484     0.200
     2.551    78.938     0.200
     0.495    15.884     0.200
     0.777    23.694     0.200
     0.817    24.744     0.200
     1.131    35.104     0.200
     1.076    33.844     0.200
     1.469    45.024     0.200
     1.617    50.394     0.200
     0.526    17.004     0.200
     0.722    22.254     0.200
     0.914    28.055     0.200
     0.983    31.564     0.200
     1.022    32.715     0.200
     1.299    42.924     0.200
     1.349    43.404     0.200
     1.483    47.273     0.200
     1.564    47.273     0.200
     1.714    52.504     0.200
     1.745    53.645     0.200
     1.782    54.773     0.200
     2.148    66.373     0.200
     2.218    68.424     0.200
     1.721    52.047     0.200
     2.108    65.336     0.200
     0.557    16.992     0.200
     0.597    17.500     0.200
     0.858    28.512     0.200
     1.262    38.480     0.200
     0.533    17.332     0.200
     0.484    15.219     0.200
     0.628    19.469     0.200
     0.772    24.289     0.200
     0.904    29.375     0.200
     0.928    30.586     0.200
     1.096    36.156     0.200
     1.284    38.977     0.200
     1.198    37.609     0.200
     1.315    40.641     0.200
     1.428    43.891     0.200
     1.604    48.211     0.200
     1.758    54.320     0.200
     1.942    62.352     0.200
     0.490    15.547     0.200
     0.637    19.757     0.200
     0.783    26.767     0.200
     0.660    19.555     0.200
     1.110    36.125     0.200
     0.577    18.039     0.200
     0.716    21.570     0.200
     0.895    29.102     0.200
     1.381    42.500     0.200
     1.405    43.258     0.200
     0.616    18.610     0.200
     0.608    18.920     0.200
     1.172    37.630     0.200
     0.429    14.719     0.200
     0.501    16.414     0.200
     0.745    23.234     0.200
     0.862    26.555     0.200
     0.938    31.613     0.200
     0.907    31.504     0.200
     1.172    36.105     0.200
     1.511    45.965     0.200
     1.662    52.152     0.200
     1.834    56.844     0.200
     1.992    61.594     0.200
     2.119    65.766     0.200
     2.357    71.684     0.200
     2.770    85.504     0.200
     2.967    92.176     0.200
     2.986    92.074     0.200
     3.321    98.953     0.200
     3.488   104.883     0.200
     3.891   117.996     0.200
     3.998   123.734     0.200
     2.283    71.551     0.200
     2.986    90.422     0.200
     2.507    76.428     0.200
     3.244    97.840     0.200
     0.492    15.580     0.200
     0.636    19.279     0.200
     1.293    39.359     0.200
     1.323    40.010     0.200
     0.441    14.631     0.200
     0.578    17.650     0.200
     2.534    78.014     0.200
     3.266    97.879     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
