#!/bin/bash
gmt begin hubbard6.23_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source hubbard6.23'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6 -10.0
  0.6 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.562     0.950     0.200
     0.322    -0.138     0.200
     0.456    -0.322     0.200
     0.589     1.229     0.200
     0.732    -0.020     0.200
     0.449    -0.137     0.200
     0.580     1.149     0.200
     0.729    -0.179     0.200
     0.267    -0.200     0.200
     0.626     1.232     0.200
     0.573     1.117     0.200
     0.574     0.952     0.200
     0.438    -0.082     0.200
     0.441    -0.054     0.200
     0.706    -0.074     0.200
     0.263    -0.122     0.200
     0.328     0.050     0.200
     0.563    -0.088     0.200
     0.752     0.905     0.200
     0.263    -0.109     0.200
     0.275    -0.005     0.200
     0.468     0.995     0.200
     0.193    -0.186     0.200
     0.484     0.077     0.200
     0.597     1.250     0.200
     0.294     0.020     0.200
     0.537     1.038     0.200
     0.620     0.313     0.200
     0.278    -0.167     0.200
     0.327     0.238     0.200
     0.277    -0.113     0.200
     0.360    -0.065     0.200
     0.569    -0.052     0.200
     0.681     1.037     0.200
     0.274    -0.120     0.200
     0.369    -0.185     0.200
     0.564     0.011     0.200
     0.678     1.037     0.200
     0.228    -0.111     0.200
     0.427     0.473     0.200
     0.621     1.100     0.200
     0.219    -0.232     0.200
     0.433     0.228     0.200
     0.608     1.182     0.200
     0.865     0.846     0.200
     0.172    -0.105     0.200
     0.303    -0.176     0.200
     0.469     1.373     0.200
     0.244    -0.133     0.200
     0.484    -0.059     0.200
     0.629     1.061     0.200
     0.168    -0.160     0.200
     0.539     1.129     0.200
     0.660     1.038     0.200
     0.298    -0.015     0.200
     0.285    -0.048     0.200
     0.591    -0.087     0.200
     0.683     1.068     0.200
     0.453    -0.070     0.200
     0.629     0.615     0.200
     0.879     0.603     0.200
     0.434    -0.134     0.200
     0.440    -0.054     0.200
     0.614     0.884     0.200
     0.867     0.723     0.200
     0.457    -0.035     0.200
     0.632     1.044     0.200
     0.876     0.928     0.200
     0.482    -0.028     0.200
     0.658     0.953     0.200
     0.888     1.026     0.200
     0.465    -0.062     0.200
     0.682    -0.006     0.200
     0.686     0.201     0.200
     0.633     0.827     0.200
     0.872     0.804     0.200
     0.382     0.004     0.200
     0.462     0.007     0.200
     0.643     0.723     0.200
     0.814     0.753     0.200
     0.878    -0.362     0.200
     0.939     0.256     0.200
     0.226    -0.100     0.200
     0.460    -0.076     0.200
     0.490     0.814     0.200
     0.656     0.965     0.200
     0.758    -0.033     0.200
     0.800     0.228     0.200
     0.947     0.351     0.200
     0.373    -0.231     0.200
     0.518    -0.030     0.200
     0.776     0.295     0.200
     0.959     0.536     0.200
     0.331    -0.093     0.200
     0.331    -0.314     0.200
     0.534     0.003     0.200
     0.583     0.825     0.200
     0.680     0.812     0.200
     0.760     0.806     0.200
     0.812     0.278     0.200
     0.867     0.375     0.200
     0.979     0.510     0.200
     0.239    -0.096     0.200
     0.356    -0.253     0.200
     0.356    -0.152     0.200
     0.529    -0.062     0.200
     0.609     0.587     0.200
     0.681     0.760     0.200
     0.789     0.362     0.200
     0.893     0.259     0.200
     0.963     0.587     0.200
     0.548    -0.087     0.200
     0.548    -0.031     0.200
     0.613     0.240     0.200
     0.736     1.054     0.200
     0.845     0.556     0.200
     0.978     1.031     0.200
     0.257    -0.289     0.200
     0.340     0.006     0.200
     0.588     0.864     0.200
     0.553     0.090     0.200
     0.765     0.626     0.200
     0.867     0.142     0.200
     0.923    -0.976     0.200
     0.962     0.659     0.200
     0.405    -0.014     0.200
     0.416    -0.052     0.200
     0.680     0.876     0.200
     0.789     0.487     0.200
     0.985     0.118     0.200
     0.234    -0.189     0.200
     0.332    -0.199     0.200
     0.332    -0.011     0.200
     0.584     0.668     0.200
     0.584     0.887     0.200
     0.531     0.009     0.200
     0.761     0.833     0.200
     0.801    -0.657     0.200
     0.801    -0.477     0.200
     0.812     0.383     0.200
     0.870     0.416     0.200
     0.980     0.550     0.200
     0.177    -0.184     0.200
     0.413     0.111     0.200
     0.413     0.064     0.200
     0.431    -0.032     0.200
     0.600     1.052     0.200
     0.676     0.916     0.200
     0.776     0.348     0.200
     0.845     0.931     0.200
     0.918    -0.576     0.200
     0.977     0.529     0.200
     1.000     0.602     0.200
     0.342    -0.033     0.200
     0.404    -0.289     0.200
     0.668     0.563     0.200
     0.846     0.065     0.200
     0.940     0.044     0.200
     0.982     0.464     0.200
     0.398    -0.048     0.200
     0.439    -0.186     0.200
     0.703     0.700     0.200
     0.776     0.450     0.200
     0.955    -0.251     0.200
     0.155    -0.371     0.200
     0.393     0.163     0.200
     0.425    -0.073     0.200
     0.425    -0.014     0.200
     0.689     1.113     0.200
     0.790     0.289     0.200
     0.943    -0.625     0.200
     0.943    -0.305     0.200
     0.421    -0.049     0.200
     0.515    -0.002     0.200
     0.676     0.481     0.200
     0.732     0.570     0.200
     0.890    -0.714     0.200
     0.929     0.734     0.200
     0.211    -0.208     0.200
     0.377     0.115     0.200
     0.377    -0.030     0.200
     0.377     0.103     0.200
     0.491    -0.180     0.200
     0.491    -0.075     0.200
     0.491     0.040     0.200
     0.635     0.825     0.200
     0.649     0.869     0.200
     0.705    -0.594     0.200
     0.809     0.858     0.200
     0.780     0.296     0.200
     0.861    -0.797     0.200
     0.998    -1.064     0.200
     0.974     0.545     0.200
     0.974     0.673     0.200
     0.325    -0.109     0.200
     0.540     0.010     0.200
     0.540     0.048     0.200
     0.552    -0.086     0.200
     0.618     0.194     0.200
     0.747    -0.449     0.200
     0.747    -0.563     0.200
     0.794     1.178     0.200
     0.844     0.444     0.200
     0.374     0.107     0.200
     0.374     0.205     0.200
     0.492     0.035     0.200
     0.514    -0.108     0.200
     0.514    -0.209     0.200
     0.629     0.829     0.200
     0.681    -0.471     0.200
     0.776     0.393     0.200
     0.961     0.573     0.200
     0.977    -0.708     0.200
     0.234    -0.071     0.200
     0.380     0.072     0.200
     0.380     0.037     0.200
     0.380     0.146     0.200
     0.486     0.169     0.200
     0.515    -0.187     0.200
     0.634     0.648     0.200
     0.673     0.907     0.200
     0.683    -0.550     0.200
     0.770     0.483     0.200
     0.956     0.716     0.200
     0.980    -0.582     0.200
     0.980    -0.903     0.200
     0.372     0.008     0.200
     0.372     0.040     0.200
     0.497    -0.037     0.200
     0.568     0.020     0.200
     0.617     0.486     0.200
     0.628    -0.622     0.200
     0.769     0.529     0.200
     0.930    -1.111     0.200
     0.930     0.686     0.200
     0.284     0.050     0.200
     0.368     0.070     0.200
     0.503    -0.072     0.200
     0.612     0.607     0.200
     0.575    -0.136     0.200
     0.619    -0.490     0.200
     0.726     0.711     0.200
     0.806    -0.701     0.200
     0.806    -0.922     0.200
     0.772     0.541     0.200
     0.921    -1.076     0.200
     0.930     0.711     0.200
     0.431    -0.151     0.200
     0.420    -0.237     0.200
     0.420    -0.245     0.200
     0.468    -0.007     0.200
     0.683     0.668     0.200
     0.770     0.156     0.200
     0.777    -0.910     0.200
     0.925     0.309     0.200
     0.969    -0.600     0.200
     0.969    -0.356     0.200
     0.996     0.524     0.200
     0.212    -0.138     0.200
     0.389     0.070     0.200
     0.389     0.021     0.200
     0.480     0.026     0.200
     0.480    -0.083     0.200
     0.487    -0.259     0.200
     0.487     0.081     0.200
     0.648     0.645     0.200
     0.713    -0.514     0.200
     0.648     0.894     0.200
     0.771     0.365     0.200
     0.874    -0.148     0.200
     0.939     0.188     0.200
     0.969     0.648     0.200
     0.182    -0.276     0.200
     0.442     0.171     0.200
     0.406     0.207     0.200
     0.406     0.191     0.200
     0.476     0.098     0.200
     0.609     0.724     0.200
     0.609     1.314     0.200
     0.669     0.876     0.200
     0.669     1.114     0.200
     0.776     0.323     0.200
     0.761    -0.706     0.200
     0.908    -0.374     0.200
     0.908    -0.527     0.200
     0.986    -0.427     0.200
     0.986    -0.267     0.200
     0.968     0.529     0.200
     0.968     0.787     0.200
     0.994     0.519     0.200
     0.220    -0.098     0.200
     0.388     0.179     0.200
     0.388     0.184     0.200
     0.496    -0.109     0.200
     0.480     0.065     0.200
     0.645     0.843     0.200
     0.657     0.389     0.200
     0.704    -0.303     0.200
     0.769     0.557     0.200
     0.769     0.667     0.200
     0.935     0.336     0.200
     0.964     0.777     0.200
     0.465    -0.358     0.200
     0.479    -0.156     0.200
     0.479    -0.142     0.200
     0.476    -0.013     0.200
     0.506     0.073     0.200
     0.676     0.497     0.200
     0.712     0.299     0.200
     0.815    -0.947     0.200
     0.786     0.395     0.200
     0.765     0.122     0.200
     0.867    -0.101     0.200
     0.919     1.153     0.200
     0.374     0.069     0.200
     0.374     0.081     0.200
     0.493     0.007     0.200
     0.554     0.029     0.200
     0.622     0.667     0.200
     0.768     0.527     0.200
     0.824    -0.821     0.200
     0.944    -0.787     0.200
     0.936     0.689     0.200
     0.255    -0.184     0.200
     0.255    -0.178     0.200
     0.503     0.733     0.200
     0.553     0.049     0.200
     0.612    -0.345     0.200
     0.881    -0.749     0.200
     0.886     0.129     0.200
     0.425    -0.088     0.200
     0.433    -0.172     0.200
     0.433    -0.040     0.200
     0.460     0.162     0.200
     0.696     0.610     0.200
     0.763     0.302     0.200
     0.939    -0.622     0.200
     0.955    -0.385     0.200
     0.994     0.560     0.200
     0.247    -0.134     0.200
     0.275    -0.086     0.200
     0.481     1.138     0.200
     0.485     0.270     0.200
     0.585     0.177     0.200
     0.585     0.161     0.200
     0.769    -0.331     0.200
     0.799     0.443     0.200
     0.847     0.713     0.200
     0.522    -0.549     0.200
     0.594    -0.167     0.200
     0.656     0.087     0.200
     0.842     0.393     0.200
     0.950     0.542     0.200
     0.950     0.651     0.200
     0.993     0.003     0.200
     0.993     0.105     0.200
     0.345    -0.113     0.200
     0.371     0.079     0.200
     0.371     0.098     0.200
     0.550    -0.677     0.200
     0.527    -0.368     0.200
     0.527    -0.259     0.200
     0.597     0.625     0.200
     0.642    -0.182     0.200
     0.642    -0.050     0.200
     0.763    -1.374     0.200
     0.777     0.283     0.200
     0.788     0.785     0.200
     0.859    -1.503     0.200
     0.859    -1.323     0.200
     0.853    -0.514     0.200
     0.901     0.471     0.200
     0.993    -0.106     0.200
     0.136    -0.101     0.200
     0.307    -0.125     0.200
     0.463     0.191     0.200
     0.489     0.818     0.200
     0.515     0.209     0.200
     0.898    -0.245     0.200
     0.894    -0.322     0.200
     0.894    -0.432     0.200
     0.391    -0.003     0.200
     0.428    -0.117     0.200
     0.496     0.023     0.200
     0.767    -0.481     0.200
     0.992    -0.554     0.200
     0.302     0.150     0.200
     0.471     0.177     0.200
     0.471     0.129     0.200
     0.513     0.097     0.200
     0.513     0.276     0.200
     0.734     0.392     0.200
     0.827     0.423     0.200
     0.885    -0.376     0.200
     0.906    -0.077     0.200
     0.309     0.023     0.200
     0.466     0.056     0.200
     0.511     0.290     0.200
     0.899    -0.164     0.200
     0.890    -0.323     0.200
     0.138    -0.259     0.200
     0.306     0.024     0.200
     0.306    -0.126     0.200
     0.466     0.208     0.200
     0.466     0.169     0.200
     0.514     0.171     0.200
     0.514     0.050     0.200
     0.514     0.346     0.200
     0.729     0.700     0.200
     0.827     0.469     0.200
     0.901    -0.080     0.200
     0.901    -0.280     0.200
     0.886     0.727     0.200
     0.890    -0.291     0.200
     0.890    -0.410     0.200
     0.334    -0.031     0.200
     0.535    -0.357     0.200
     0.535    -0.571     0.200
     0.520     0.301     0.200
     0.602    -0.262     0.200
     0.641     0.085     0.200
     0.695    -0.799     0.200
     0.701     0.939     0.200
     0.779     0.394     0.200
     0.815    -0.892     0.200
     0.968     0.662     0.200
     0.968     0.446     0.200
     0.980     0.328     0.200
     0.403     0.085     0.200
     0.403     0.017     0.200
     0.428     0.004     0.200
     0.428    -0.098     0.200
     0.485     0.101     0.200
     0.666     0.611     0.200
     0.772    -0.653     0.200
     0.911    -0.305     0.200
     0.968    -0.654     0.200
     0.982    -0.268     0.200
     0.369    -0.185     0.200
     0.585    -0.392     0.200
     0.850    -0.246     0.200
     0.949    -0.547     0.200
     0.986    -0.622     0.200
     0.264    -0.120     0.200
     0.335    -0.044     0.200
     0.335    -0.174     0.200
     0.428     0.184     0.200
     0.428     0.294     0.200
     0.540     1.179     0.200
     0.589     0.264     0.200
     0.589    -0.002     0.200
     0.589     0.157     0.200
     0.743     0.519     0.200
     0.774    -0.779     0.200
     0.774    -0.109     0.200
     0.774    -0.311     0.200
     0.853     0.858     0.200
     0.853     0.278     0.200
     0.967    -0.690     0.200
     0.967    -0.530     0.200
     0.277    -0.180     0.200
     0.334     0.061     0.200
     0.334     0.082     0.200
     0.538    -0.012     0.200
     0.577     0.733     0.200
     0.608    -0.280     0.200
     0.576    -0.172     0.200
     0.756     0.869     0.200
     0.720     0.632     0.200
     0.775    -0.544     0.200
     0.806     0.382     0.200
     0.899    -0.792     0.200
     0.955     0.599     0.200
     0.339    -0.008     0.200
     0.448     0.046     0.200
     0.448     0.370     0.200
     0.526    -0.101     0.200
     0.526    -0.129     0.200
     0.763     0.531     0.200
     0.838    -0.667     0.200
     0.790     0.861     0.200
     0.913    -0.769     0.200
     0.447    -0.129     0.200
     0.447     0.254     0.200
     0.514    -0.347     0.200
     0.514    -0.941     0.200
     0.489     0.147     0.200
     0.489    -0.072     0.200
     0.660     0.925     0.200
     0.717     0.568     0.200
     0.794    -1.400     0.200
     0.851    -0.607     0.200
     0.820     0.392     0.200
     0.820     0.541     0.200
     0.897    -1.173     0.200
     0.925    -0.019     0.200
     0.422     0.037     0.200
     0.422     0.279     0.200
     0.550    -0.166     0.200
     0.550    -0.104     0.200
     0.557     1.108     0.200
     0.736     0.076     0.200
     0.736     0.486     0.200
     0.917    -0.743     0.200
     0.917    -1.079     0.200
     0.260    -0.139     0.200
     0.260    -0.240     0.200
     0.319    -0.190     0.200
     0.548    -0.362     0.200
     0.548    -0.132     0.200
     0.634    -0.272     0.200
     0.749     1.077     0.200
     0.750     0.001     0.200
     0.750     0.491     0.200
     0.810    -0.328     0.200
     0.810    -0.519     0.200
     0.891     0.341     0.200
     0.360     0.081     0.200
     0.360    -0.052     0.200
     0.505    -0.255     0.200
     0.505    -0.387     0.200
     0.650    -0.482     0.200
     0.694     0.788     0.200
     0.783     0.068     0.200
     0.892     0.179     0.200
     0.946    -0.833     0.200
     0.953     0.431     0.200
     0.953     0.548     0.200
     0.366    -0.031     0.200
     0.366    -0.125     0.200
     0.500    -0.037     0.200
     0.653    -0.677     0.200
     0.694     1.014     0.200
     0.778     0.406     0.200
     0.898     0.411     0.200
     0.950     0.672     0.200
     0.950    -1.158     0.200
     0.318    -0.086     0.200
     0.533     0.178     0.200
     0.533    -0.017     0.200
     0.777     0.527     0.200
     0.797     0.515     0.200
     0.934    -0.103     0.200
     0.934    -0.283     0.200
     0.955     0.443     0.200
     0.249    -0.309     0.200
     0.431     0.316     0.200
     0.586     0.054     0.200
     0.591     0.623     0.200
     0.679    -0.672     0.200
     0.720    -0.321     0.200
     0.802    -0.004     0.200
     0.828    -0.069     0.200
     0.945     0.571     0.200
     0.887     0.763     0.200
     0.927    -0.095     0.200
     0.933     0.459     0.200
     0.384     0.118     0.200
     0.484    -0.050     0.200
     0.485     0.031     0.200
     0.714    -0.544     0.200
     0.776     0.255     0.200
     0.870    -0.514     0.200
     0.935     0.590     0.200
     0.975     0.648     0.200
     0.375    -0.081     0.200
     0.434     0.061     0.200
     0.503    -0.062     0.200
     0.768     0.425     0.200
     0.747     0.330     0.200
     0.871    -0.613     0.200
     0.413     0.355     0.200
     0.413     0.050     0.200
     0.572     0.660     0.200
     0.650    -1.264     0.200
     0.650    -1.373     0.200
     0.689    -0.499     0.200
     0.689    -0.617     0.200
     0.767    -0.889     0.200
     0.814    -0.005     0.200
     0.838    -0.024     0.200
     0.841     0.266     0.200
     0.876     0.386     0.200
     0.990    -1.351     0.200
     0.468     0.352     0.200
     0.547     0.048     0.200
     0.644     0.418     0.200
     0.760     0.916     0.200
     0.967     0.360     0.200
     0.416    -0.267     0.200
     0.419    -0.134     0.200
     0.434    -0.049     0.200
     0.681     0.626     0.200
     0.923    -0.026     0.200
     0.923    -0.436     0.200
     0.982     0.363     0.200
     0.994     0.607     0.200
     0.422    -0.179     0.200
     0.425    -0.241     0.200
     0.431    -0.040     0.200
     0.687     0.659     0.200
     0.929     0.435     0.200
     0.929    -0.705     0.200
     0.988     0.245     0.200
     0.988     0.128     0.200
     0.509     0.544     0.200
     0.509     0.775     0.200
     0.678    -1.047     0.200
     0.678    -0.698     0.200
     0.656     0.050     0.200
     0.763    -0.212     0.200
     0.763    -0.071     0.200
     0.797    -0.744     0.200
     0.783     0.870     0.200
     0.865     0.137     0.200
     0.971     0.519     0.200
     0.999     0.367     0.200
     0.289     0.007     0.200
     0.485     0.763     0.200
     0.788     0.844     0.200
     0.807     0.589     0.200
     0.804    -0.035     0.200
     0.920     0.588     0.200
     0.685     0.104     0.200
     0.776    -0.611     0.200
     0.776    -0.722     0.200
     0.858     0.224     0.200
     0.952     0.294     0.200
     0.952     0.474     0.200
     0.970     0.259     0.200
     0.561    -0.009     0.200
     0.812     0.540     0.200
     0.910    -0.995     0.200
     0.967     0.687     0.200
     0.553    -0.004     0.200
     0.805     0.520     0.200
     0.921    -0.656     0.200
     0.965     0.590     0.200
     0.299    -0.100     0.200
     0.878     0.294     0.200
     0.878     0.411     0.200
     0.505    -0.055     0.200
     0.909    -0.342     0.200
     0.909     0.036     0.200
     0.247    -1.267     0.200
     0.549     0.025     0.200
     0.563     0.477     0.200
     0.845     1.113     0.200
     0.827     0.190     0.200
     0.985     0.801     0.200
     0.403    -0.148     0.200
     0.405    -0.167     0.200
     0.448    -0.080     0.200
     0.667     0.038     0.200
     0.965     0.439     0.200
     0.407    -0.034     0.200
     0.407    -0.167     0.200
     0.491     0.275     0.200
     0.494     0.235     0.200
     0.758     0.924     0.200
     0.986     0.588     0.200
     0.408     0.034     0.200
     0.408    -0.083     0.200
     0.500     0.245     0.200
     0.503     0.205     0.200
     0.766     1.001     0.200
     0.766     0.681     0.200
     0.982     0.668     0.200
     0.497    -0.058     0.200
     0.736    -0.092     0.200
     0.940    -0.521     0.200
     0.995     1.155     0.200
     0.486    -0.152     0.200
     0.645    -0.124     0.200
     0.978    -0.578     0.200
     0.739    -0.037     0.200
     0.871    -0.819     0.200
     0.945    -0.171     0.200
     0.991     0.231     0.200
     0.955    -0.138     0.200
     0.517    -0.253     0.200
     0.669    -0.381     0.200
     0.824    -0.981     0.200
     0.903    -0.044     0.200
     0.897    -0.063     0.200
     0.997    -0.774     0.200
     0.718    -0.020     0.200
     0.923    -0.848     0.200
     0.992    -1.617     0.200
     0.473     0.107     0.200
     0.642    -0.992     0.200
     0.774    -1.042     0.200
     0.887    -0.110     0.200
     0.960    -1.011     0.200
     0.480    -0.199     0.200
     0.474    -0.326     0.200
     0.647    -0.814     0.200
     0.531    -0.906     0.200
     0.718    -1.218     0.200
     0.861    -1.196     0.200
     0.470    -0.115     0.200
     0.650    -1.195     0.200
     0.507    -0.498     0.200
     0.803    -0.632     0.200
     0.509    -0.393     0.200
     0.793    -0.660     0.200
     0.809     0.018     0.200
     0.901    -0.265     0.200
     0.939     0.818     0.200
     0.534    -0.327     0.200
     0.685    -0.607     0.200
     0.501    -0.216     0.200
     0.736    -0.079     0.200
     0.872    -0.890     0.200
     0.944    -0.853     0.200
     0.994     0.769     0.200
     0.489    -0.331     0.200
     0.585    -1.016     0.200
     0.742    -1.474     0.200
     0.928     0.434     0.200
     0.934    -0.055     0.200
     0.483    -0.381     0.200
     0.619    -0.965     0.200
     0.764    -1.464     0.200
     0.941    -1.214     0.200
     0.909     0.033     0.200
     0.930     0.845     0.200
     0.510    -0.120     0.200
     0.756    -0.025     0.200
     0.859    -0.685     0.200
     0.943    -1.194     0.200
     0.480    -0.226     0.200
     0.585    -0.661     0.200
     0.736    -0.841     0.200
     0.906    -0.755     0.200
     0.928    -0.023     0.200
     0.937     0.854     0.200
     0.564    -0.079     0.200
     0.597    -0.667     0.200
     0.805    -1.291     0.200
     0.851     0.519     0.200
     0.938    -0.959     0.200
     0.986    -0.070     0.200
     0.570    -1.236     0.200
     0.527     0.113     0.200
     0.493    -0.217     0.200
     0.653    -0.667     0.200
     0.895     0.068     0.200
     0.510    -0.259     0.200
     0.740    -0.019     0.200
     0.877    -0.504     0.200
     0.989     0.959     0.200
     0.489    -0.196     0.200
     0.626    -1.014     0.200
     0.512    -0.193     0.200
     0.618    -0.517     0.200
     0.609    -0.912     0.200
     0.926     0.300     0.200
     0.568    -0.091     0.200
     0.878    -1.115     0.200
     0.927    -0.238     0.200
     0.849     0.413     0.200
     0.505    -0.149     0.200
     0.873    -0.543     0.200
     0.990     0.659     0.200
     0.511    -0.622     0.200
     0.632    -0.961     0.200
     0.901     0.776     0.200
     0.961    -1.142     0.200
     0.922     0.152     0.200
     0.861     1.016     0.200
     0.507    -0.066     0.200
     0.774    -0.410     0.200
     0.822    -0.013     0.200
     0.888    -0.947     0.200
     0.933     0.860     0.200
     0.507    -0.141     0.200
     0.782    -0.515     0.200
     0.816     0.016     0.200
     0.893    -0.975     0.200
     0.936     0.824     0.200
     0.461    -0.138     0.200
     0.640    -0.637     0.200
     0.880     0.108     0.200
     0.951     0.509     0.200
     0.438    -0.390     0.200
     0.629    -1.210     0.200
     0.714    -0.068     0.200
     0.859    -0.365     0.200
     0.912    -0.767     0.200
     0.494    -0.235     0.200
     0.748    -0.062     0.200
     0.852    -0.900     0.200
     0.928    -0.834     0.200
     0.987     0.893     0.200
     0.479    -0.458     0.200
     0.588    -0.847     0.200
     0.737    -1.294     0.200
     0.909    -1.101     0.200
     0.925     0.124     0.200
     0.937     0.795     0.200
     0.511    -0.406     0.200
     0.643    -0.788     0.200
     0.916     0.193     0.200
     0.901     0.831     0.200
     0.971    -1.091     0.200
     0.495    -0.297     0.200
     0.777    -0.017     0.200
     0.817    -0.533     0.200
     0.908    -1.243     0.200
     0.966     0.799     0.200
     0.526     0.252     0.200
     0.722    -0.045     0.200
     0.914    -0.548     0.200
     0.983    -1.114     0.200
     1.000     0.749     0.200
     0.567    -0.111     0.200
     0.598    -0.748     0.200
     0.557    -0.105     0.200
     0.597    -0.793     0.200
     0.800    -1.445     0.200
     0.937    -1.086     0.200
     0.858     0.924     0.200
     0.980     0.075     0.200
     0.533     0.170     0.200
     0.621    -1.254     0.200
     0.484    -0.036     0.200
     0.628    -0.706     0.200
     0.772    -1.388     0.200
     0.950    -1.160     0.200
     0.904     0.035     0.200
     0.928     0.954     0.200
     0.490    -0.388     0.200
     0.637    -0.774     0.200
     0.783    -1.391     0.200
     0.903     0.181     0.200
     0.960    -1.053     0.200
     0.922     0.536     0.200
     0.660    -0.975     0.200
     0.786    -0.438     0.200
     0.978    -0.869     0.200
     0.577    -0.133     0.200
     0.716    -1.053     0.200
     0.895    -0.553     0.200
     0.843     0.570     0.200
     0.924     0.026     0.200
     0.616    -0.500     0.200
     0.608    -0.090     0.200
     0.429    -0.101     0.200
     0.649    -0.426     0.200
     0.501    -0.280     0.200
     0.745    -0.228     0.200
     0.862    -0.988     0.200
     0.938    -1.226     0.200
     0.907     1.133     0.200
     0.987     0.837     0.200
     0.450    -0.378     0.200
     0.600    -0.483     0.200
     0.492     0.186     0.200
     0.636    -0.549     0.200
     0.783    -1.499     0.200
     0.960    -0.852     0.200
     0.905    -0.029     0.200
     0.920     0.584     0.200
     0.465    -0.030     0.200
     0.589    -0.911     0.200
     0.441    -0.281     0.200
     0.578    -0.969     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.438     0.058     0.200
     0.441    -0.184     0.200
     0.706     0.083     0.200
     0.263    -0.031     0.200
     0.328     0.449     0.200
     0.193    -0.390     0.200
     0.294    -0.112     0.200
     0.345    -0.087     0.200
     0.327    -0.192     0.200
     0.748     1.414     0.200
     0.277    -0.045     0.200
     0.360     0.022     0.200
     0.274    -0.184     0.200
     0.564     0.960     0.200
     0.865     2.315     0.200
     0.298     0.355     0.200
     0.453     0.177     0.200
     0.440     0.102     0.200
     0.457     0.421     0.200
     0.465     0.169     0.200
     0.686     1.115     0.200
     0.382    -0.437     0.200
     0.643     1.154     0.200
     0.878     0.515     0.200
     0.939     0.311     0.200
     0.226     0.090     0.200
     0.226    -0.351     0.200
     0.460     0.713     0.200
     0.490     1.946     0.200
     0.758     0.847     0.200
     0.800     1.195     0.200
     0.947     0.204     0.200
     0.373     0.945     0.200
     0.776     0.462     0.200
     0.959     0.696     0.200
     0.331    -0.177     0.200
     0.331    -0.007     0.200
     0.534     0.551     0.200
     0.812     0.468     0.200
     0.867     1.122     0.200
     0.979     0.275     0.200
     0.239     0.060     0.200
     0.356    -0.062     0.200
     0.789     0.459     0.200
     0.789     0.177     0.200
     0.893     1.348     0.200
     0.963     0.469     0.200
     0.963     0.360     0.200
     0.548    -0.333     0.200
     0.548     0.175     0.200
     0.548     0.065     0.200
     0.613     0.790     0.200
     0.613     0.659     0.200
     0.845     0.819     0.200
     0.257    -0.008     0.200
     0.340     0.024     0.200
     0.340     0.335     0.200
     0.588     1.977     0.200
     0.867     1.761     0.200
     0.923    -1.842     0.200
     0.962    -0.351     0.200
     0.789     0.616     0.200
     0.985     0.307     0.200
     0.234    -0.043     0.200
     0.332     0.107     0.200
     0.584     2.197     0.200
     0.531     0.065     0.200
     0.801     0.921     0.200
     0.812     0.548     0.200
     0.870     1.183     0.200
     0.980     0.766     0.200
     0.177     0.015     0.200
     0.413     0.540     0.200
     0.413     0.673     0.200
     0.776     0.413     0.200
     0.776     0.942     0.200
     0.918     0.833     0.200
     0.977     1.245     0.200
     1.000     0.656     0.200
     1.000     0.867     0.200
     0.342     1.042     0.200
     0.398    -0.219     0.200
     0.776     0.074     0.200
     0.955     0.210     0.200
     0.155    -0.128     0.200
     0.393     0.456     0.200
     0.425     0.538     0.200
     0.425     0.536     0.200
     0.689     2.466     0.200
     0.790     1.367     0.200
     0.790     1.076     0.200
     0.943     1.185     0.200
     0.421    -0.223     0.200
     0.732     0.380     0.200
     0.890    -0.206     0.200
     0.929     0.071     0.200
     0.211    -0.084     0.200
     0.377    -0.058     0.200
     0.377     0.180     0.200
     0.491     0.424     0.200
     0.491    -0.259     0.200
     0.491     0.971     0.200
     0.491    -0.283     0.200
     0.635     2.310     0.200
     0.705    -0.421     0.200
     0.780     0.348     0.200
     0.861    -0.702     0.200
     0.998     0.309     0.200
     0.974     0.734     0.200
     0.974     0.082     0.200
     0.974     0.367     0.200
     0.325     0.118     0.200
     0.540     0.159     0.200
     0.540     0.034     0.200
     0.552     0.057     0.200
     0.552     0.443     0.200
     0.618     0.463     0.200
     0.747    -0.460     0.200
     0.747    -0.687     0.200
     0.844     0.635     0.200
     0.374    -0.022     0.200
     0.374    -0.096     0.200
     0.492     0.135     0.200
     0.514     0.136     0.200
     0.681    -0.571     0.200
     0.681    -0.735     0.200
     0.776     0.587     0.200
     0.961     0.352     0.200
     0.961     0.505     0.200
     0.234     0.029     0.200
     0.380    -0.057     0.200
     0.380     0.204     0.200
     0.486     0.315     0.200
     0.486    -0.005     0.200
     0.515     0.242     0.200
     0.515    -0.110     0.200
     0.515     0.035     0.200
     0.683    -0.605     0.200
     0.683    -1.019     0.200
     0.770     0.668     0.200
     0.956     0.588     0.200
     0.956     0.276     0.200
     0.980    -1.221     0.200
     0.372     0.148     0.200
     0.372     0.125     0.200
     0.497    -0.744     0.200
     0.568    -0.353     0.200
     0.568     0.030     0.200
     0.628    -0.910     0.200
     0.769    -0.249     0.200
     0.930     0.203     0.200
     0.930     0.351     0.200
     0.284     0.112     0.200
     0.368     0.158     0.200
     0.503    -0.189     0.200
     0.575    -0.119     0.200
     0.619    -0.762     0.200
     0.806     0.184     0.200
     0.930     0.175     0.200
     0.431     0.224     0.200
     0.431    -0.039     0.200
     0.420     0.599     0.200
     0.420     0.629     0.200
     0.468     0.601     0.200
     0.777    -1.520     0.200
     0.925     1.107     0.200
     0.969    -0.208     0.200
     0.969    -0.045     0.200
     0.996     0.188     0.200
     0.996     0.718     0.200
     0.212    -0.024     0.200
     0.389    -0.625     0.200
     0.389    -0.098     0.200
     0.389     0.184     0.200
     0.480     0.162     0.200
     0.480    -0.288     0.200
     0.487    -0.736     0.200
     0.487     0.133     0.200
     0.648     1.213     0.200
     0.713    -0.729     0.200
     0.713    -0.889     0.200
     0.771     0.335     0.200
     0.771     0.556     0.200
     0.874     0.632     0.200
     0.939     0.660     0.200
     0.969     0.323     0.200
     0.969     0.178     0.200
     0.182    -0.184     0.200
     0.442     0.497     0.200
     0.406     0.314     0.200
     0.406     0.884     0.200
     0.476     0.653     0.200
     0.669     2.811     0.200
     0.776     1.071     0.200
     0.776     0.544     0.200
     0.761    -0.335     0.200
     0.908     0.390     0.200
     0.986    -0.196     0.200
     0.986    -0.704     0.200
     0.986    -0.864     0.200
     0.968     0.568     0.200
     0.968     1.541     0.200
     0.994     0.733     0.200
     0.220     0.060     0.200
     0.388    -0.130     0.200
     0.388     0.072     0.200
     0.388     0.432     0.200
     0.496    -0.048     0.200
     0.496    -0.286     0.200
     0.480     0.070     0.200
     0.480     0.410     0.200
     0.645     0.705     0.200
     0.704    -0.556     0.200
     0.704    -0.451     0.200
     0.769     0.782     0.200
     0.935     0.430     0.200
     0.964     0.434     0.200
     0.465    -0.140     0.200
     0.479    -0.089     0.200
     0.479     0.190     0.200
     0.506     0.380     0.200
     0.506     0.271     0.200
     0.676     0.304     0.200
     0.712     0.498     0.200
     0.712     0.697     0.200
     0.815    -0.785     0.200
     0.786     0.101     0.200
     0.867     0.674     0.200
     0.867     0.561     0.200
     0.867     0.786     0.200
     0.374    -0.034     0.200
     0.374     0.206     0.200
     0.493    -0.208     0.200
     0.493     0.380     0.200
     0.554    -0.340     0.200
     0.554    -0.205     0.200
     0.622     0.695     0.200
     0.768     0.336     0.200
     0.824    -0.463     0.200
     0.936     0.476     0.200
     0.936     0.277     0.200
     0.255     0.159     0.200
     0.255     0.065     0.200
     0.503     0.690     0.200
     0.553    -0.679     0.200
     0.553    -0.327     0.200
     0.612     0.014     0.200
     0.612    -0.209     0.200
     0.881    -0.130     0.200
     0.886     0.764     0.200
     0.425    -0.369     0.200
     0.433     0.013     0.200
     0.433     0.607     0.200
     0.460     0.232     0.200
     0.763     0.704     0.200
     0.939     0.801     0.200
     0.955     0.080     0.200
     0.994     0.574     0.200
     0.994    -0.074     0.200
     0.247    -0.281     0.200
     0.275    -0.013     0.200
     0.485     0.552     0.200
     0.585     0.772     0.200
     0.585     0.553     0.200
     0.769     0.135     0.200
     0.769    -0.420     0.200
     0.769    -0.685     0.200
     0.799     0.005     0.200
     0.847     1.885     0.200
     0.847     1.447     0.200
     0.522    -0.872     0.200
     0.522    -0.528     0.200
     0.532     1.161     0.200
     0.594     0.127     0.200
     0.594    -0.076     0.200
     0.656     0.525     0.200
     0.842     0.835     0.200
     0.950     0.180     0.200
     0.950     0.587     0.200
     0.993    -0.145     0.200
     0.993     0.089     0.200
     0.345     0.153     0.200
     0.371     0.290     0.200
     0.371     0.208     0.200
     0.550    -1.059     0.200
     0.550    -0.649     0.200
     0.527    -0.379     0.200
     0.642    -0.411     0.200
     0.777     0.573     0.200
     0.777     0.253     0.200
     0.853     0.606     0.200
     0.901     0.494     0.200
     0.993    -0.012     0.200
     0.993    -0.301     0.200
     0.993    -0.129     0.200
     0.136    -0.064     0.200
     0.307    -0.748     0.200
     0.463    -0.202     0.200
     0.515     0.120     0.200
     0.515     0.249     0.200
     0.898    -0.659     0.200
     0.894    -0.514     0.200
     0.391     0.149     0.200
     0.428    -0.131     0.200
     0.496     0.138     0.200
     0.767    -0.613     0.200
     0.302    -0.512     0.200
     0.302    -0.405     0.200
     0.471     0.081     0.200
     0.471     0.255     0.200
     0.513     0.493     0.200
     0.734     0.566     0.200
     0.827     0.222     0.200
     0.885    -0.350     0.200
     0.906    -0.524     0.200
     0.309    -0.210     0.200
     0.466    -0.105     0.200
     0.511     0.412     0.200
     0.899    -0.141     0.200
     0.890    -0.758     0.200
     0.306    -0.237     0.200
     0.306    -0.411     0.200
     0.466     0.646     0.200
     0.466     0.394     0.200
     0.514     0.450     0.200
     0.729     1.943     0.200
     0.729     0.912     0.200
     0.827     0.557     0.200
     0.827     0.307     0.200
     0.901    -0.345     0.200
     0.901    -0.154     0.200
     0.886     1.721     0.200
     0.890    -0.595     0.200
     0.890    -0.782     0.200
     0.299    -0.593     0.200
     0.334     0.060     0.200
     0.535    -0.690     0.200
     0.535    -0.901     0.200
     0.520     1.872     0.200
     0.602    -0.385     0.200
     0.701     2.049     0.200
     0.779     1.453     0.200
     0.403     0.118     0.200
     0.403     0.120     0.200
     0.428    -0.804     0.200
     0.485     0.213     0.200
     0.666     1.663     0.200
     0.772    -0.383     0.200
     0.968     0.533     0.200
     0.982    -0.343     0.200
     0.585     0.029     0.200
     0.850    -0.100     0.200
     0.893     1.498     0.200
     0.986    -0.014     0.200
     0.264    -0.180     0.200
     0.335    -0.378     0.200
     0.428     0.495     0.200
     0.428     0.194     0.200
     0.589     0.549     0.200
     0.589     0.228     0.200
     0.589    -0.282     0.200
     0.743     0.671     0.200
     0.774    -0.805     0.200
     0.774    -0.224     0.200
     0.853     2.009     0.200
     0.967    -0.400     0.200
     0.967    -0.518     0.200
     0.277     0.106     0.200
     0.334     0.525     0.200
     0.538    -0.227     0.200
     0.608    -0.341     0.200
     0.576    -0.289     0.200
     0.806     0.656     0.200
     0.851     1.325     0.200
     0.955    -0.018     0.200
     0.339    -0.309     0.200
     0.448     0.255     0.200
     0.448     0.650     0.200
     0.526    -0.268     0.200
     0.526    -0.373     0.200
     0.763     0.218     0.200
     0.838    -0.226     0.200
     0.838     0.446     0.200
     0.790     1.807     0.200
     0.913    -1.005     0.200
     0.447     0.087     0.200
     0.447     0.157     0.200
     0.514    -0.257     0.200
     0.514    -0.085     0.200
     0.489     0.379     0.200
     0.489     0.270     0.200
     0.707     1.037     0.200
     0.717     0.713     0.200
     0.851    -1.079     0.200
     0.820    -0.116     0.200
     0.925     0.431     0.200
     0.925     0.610     0.200
     0.237    -0.196     0.200
     0.422     0.493     0.200
     0.550     0.697     0.200
     0.550     0.803     0.200
     0.550     0.654     0.200
     0.736     0.584     0.200
     0.917    -1.142     0.200
     0.260     0.289     0.200
     0.319     0.053     0.200
     0.548    -1.123     0.200
     0.634    -0.187     0.200
     0.634    -0.076     0.200
     0.750     1.538     0.200
     0.810    -0.757     0.200
     0.810    -0.297     0.200
     0.891     1.095     0.200
     0.360     0.140     0.200
     0.360     0.047     0.200
     0.505    -0.159     0.200
     0.650    -0.733     0.200
     0.650    -0.545     0.200
     0.783     0.977     0.200
     0.892     1.104     0.200
     0.953     0.524     0.200
     0.366     0.163     0.200
     0.366    -0.017     0.200
     0.500    -0.037     0.200
     0.653    -1.130     0.200
     0.778     0.642     0.200
     0.898     1.401     0.200
     0.950     0.487     0.200
     0.950     0.675     0.200
     0.950     0.431     0.200
     0.318     0.165     0.200
     0.462     0.896     0.200
     0.533     0.162     0.200
     0.533    -0.080     0.200
     0.777     0.966     0.200
     0.797     0.969     0.200
     0.797     1.437     0.200
     0.934    -0.113     0.200
     0.934    -0.902     0.200
     0.249    -0.235     0.200
     0.586     0.024     0.200
     0.591     0.719     0.200
     0.679    -0.381     0.200
     0.828     0.254     0.200
     0.887     0.758     0.200
     0.927     0.426     0.200
     0.933     0.980     0.200
     0.384    -0.222     0.200
     0.485     0.572     0.200
     0.714    -0.631     0.200
     0.776    -0.236     0.200
     0.935    -0.663     0.200
     0.975     0.723     0.200
     0.375    -0.061     0.200
     0.434    -0.015     0.200
     0.503    -0.084     0.200
     0.768     0.637     0.200
     0.747     0.498     0.200
     0.871    -0.883     0.200
     0.413     0.853     0.200
     0.413     0.383     0.200
     0.572     0.372     0.200
     0.689    -0.405     0.200
     0.814    -0.864     0.200
     0.838     0.895     0.200
     0.841     0.716     0.200
     0.468     0.377     0.200
     0.547     0.124     0.200
     0.760     1.047     0.200
     0.923     1.245     0.200
     0.923     1.116     0.200
     0.982     0.939     0.200
     0.982     1.217     0.200
     0.994     0.839     0.200
     0.422     1.007     0.200
     0.687     2.293     0.200
     0.929     0.619     0.200
     0.929     1.040     0.200
     0.988     0.837     0.200
     0.994     0.645     0.200
     0.509    -0.023     0.200
     0.656     0.492     0.200
     0.763     1.036     0.200
     0.797    -1.649     0.200
     0.797    -0.729     0.200
     0.971     0.201     0.200
     0.999    -0.150     0.200
     0.289     0.360     0.200
     0.788     1.682     0.200
     0.807     0.913     0.200
     0.807     0.803     0.200
     0.804    -0.185     0.200
     0.920     1.620     0.200
     0.685    -0.280     0.200
     0.776    -1.268     0.200
     0.776    -1.038     0.200
     0.858     0.292     0.200
     0.952     0.961     0.200
     0.970    -0.026     0.200
     0.970     0.254     0.200
     0.561    -0.559     0.200
     0.812     0.327     0.200
     0.910    -1.213     0.200
     0.967     0.516     0.200
     0.553    -0.857     0.200
     0.805     1.091     0.200
     0.921    -1.043     0.200
     0.965     0.691     0.200
     0.299     0.278     0.200
     0.299     0.528     0.200
     0.878     0.709     0.200
     0.505     0.403     0.200
     0.909    -1.005     0.200
     0.909    -0.704     0.200
     0.954     1.148     0.200
     0.403    -0.248     0.200
     0.405    -0.427     0.200
     0.965     0.922     0.200
     0.407    -0.446     0.200
     0.407    -0.016     0.200
     0.491     0.768     0.200
     0.494     0.261     0.200
     0.758     2.073     0.200
     0.986     0.623     0.200
     0.986     0.146     0.200
     0.408    -0.056     0.200
     0.408     0.076     0.200
     0.500     0.498     0.200
     0.503    -0.048     0.200
     0.766     0.846     0.200
     0.766     1.791     0.200
     0.982     0.891     0.200
     0.982     0.375     0.200
     0.497     0.299     0.200
     0.978     0.660     0.200
     0.504     0.354     0.200
     0.739    -0.500     0.200
     0.871    -1.303     0.200
     0.502    -0.514     0.200
     0.955     0.618     0.200
     0.669    -1.274     0.200
     0.824    -1.208     0.200
     0.903    -0.002     0.200
     0.531    -0.007     0.200
     0.718    -0.195     0.200
     0.923    -0.978     0.200
     0.992     0.583     0.200
     0.473     0.747     0.200
     0.642    -1.136     0.200
     0.887     0.190     0.200
     0.960    -1.474     0.200
     0.480     0.098     0.200
     0.474    -0.749     0.200
     0.515    -0.699     0.200
     0.531    -0.496     0.200
     0.861    -1.197     0.200
     0.470     1.408     0.200
     0.650    -0.719     0.200
     0.778    -0.592     0.200
     0.880    -0.457     0.200
     0.967    -1.277     0.200
     0.507     0.222     0.200
     0.803    -0.533     0.200
     0.509     0.159     0.200
     0.793    -0.566     0.200
     0.809     0.111     0.200
     0.901     0.846     0.200
     0.939     1.176     0.200
     0.534    -0.943     0.200
     0.685    -0.886     0.200
     0.501    -0.621     0.200
     0.736     0.737     0.200
     0.872    -1.616     0.200
     0.489     0.610     0.200
     0.585    -0.898     0.200
     0.934     1.274     0.200
     0.483     0.294     0.200
     0.510     0.392     0.200
     0.756    -0.327     0.200
     0.859    -0.638     0.200
     0.943     1.942     0.200
     0.480     0.262     0.200
     0.585    -0.825     0.200
     0.736    -1.316     0.200
     0.906    -1.436     0.200
     0.928     0.302     0.200
     0.937     1.988     0.200
     0.564     0.521     0.200
     0.597    -0.827     0.200
     0.851     1.503     0.200
     0.938    -1.712     0.200
     0.527    -0.645     0.200
     0.493    -0.931     0.200
     0.653    -0.478     0.200
     0.796    -0.627     0.200
     0.510    -0.116     0.200
     0.740    -0.315     0.200
     0.877    -0.741     0.200
     0.952     0.668     0.200
     0.989     1.465     0.200
     0.489    -0.207     0.200
     0.626    -0.983     0.200
     0.512    -0.673     0.200
     0.618    -0.388     0.200
     0.488    -0.087     0.200
     0.609    -1.046     0.200
     0.760     0.807     0.200
     0.932    -0.587     0.200
     0.926     2.057     0.200
     0.568     0.383     0.200
     0.699    -0.112     0.200
     0.878    -0.019     0.200
     0.927    -0.171     0.200
     0.849     2.026     0.200
     0.505     0.478     0.200
     0.873    -0.774     0.200
     0.990     2.173     0.200
     0.948     0.774     0.200
     0.632    -1.060     0.200
     0.794     0.734     0.200
     0.901     1.237     0.200
     0.961    -0.847     0.200
     0.551     1.113     0.200
     0.643    -1.311     0.200
     0.507    -0.016     0.200
     0.774    -0.666     0.200
     0.888     0.804     0.200
     0.933     1.724     0.200
     0.507     0.226     0.200
     0.782    -0.555     0.200
     0.816     0.797     0.200
     0.936     1.374     0.200
     0.461    -0.191     0.200
     0.640    -1.214     0.200
     0.880    -0.563     0.200
     0.438    -0.166     0.200
     0.629    -1.719     0.200
     0.462     0.059     0.200
     0.859     0.578     0.200
     0.494     0.977     0.200
     0.852    -0.732     0.200
     0.928     0.865     0.200
     0.479    -0.005     0.200
     0.588    -0.672     0.200
     0.909    -1.325     0.200
     0.937     1.370     0.200
     0.511    -0.449     0.200
     0.643    -1.079     0.200
     0.802    -1.145     0.200
     0.901     1.218     0.200
     0.495     0.291     0.200
     0.777    -0.701     0.200
     0.817    -0.977     0.200
     0.526     0.449     0.200
     0.722    -0.406     0.200
     0.914    -0.677     0.200
     0.983     0.656     0.200
     0.557    -0.583     0.200
     0.597    -1.351     0.200
     0.858     1.565     0.200
     0.533     0.481     0.200
     0.484    -0.143     0.200
     0.628    -0.420     0.200
     0.772    -0.078     0.200
     0.904     0.956     0.200
     0.928     1.408     0.200
     0.490     0.140     0.200
     0.637    -0.312     0.200
     0.783     2.143     0.200
     0.660    -1.228     0.200
     0.577    -0.108     0.200
     0.716    -0.966     0.200
     0.895     0.957     0.200
     0.616    -0.794     0.200
     0.608    -0.198     0.200
     0.429     0.849     0.200
     0.501     0.622     0.200
     0.745    -0.165     0.200
     0.862    -0.556     0.200
     0.938     2.114     0.200
     0.907     3.090     0.200
     0.492     0.017     0.200
     0.636    -0.825     0.200
     0.441     0.638     0.200
     0.578    -0.639     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.788    -3.115     0.200
     0.644    -2.742     0.200
     0.702    -2.848     0.200
     0.967    -1.399     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.009
 0.60   -0.009
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 0.60    0.1
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.6)
     0.050     7.000   Pg = red x; average =  -0.0 (solid red line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
EOF
gmt end
