#!/bin/bash
gmt begin hubbard6.23_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic hubbard6.23'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.725
   137.000     1.817
   137.500     1.911
   138.000     2.010
   138.500     2.111
   139.000     2.216
   139.500     2.325
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.801
   142.000     2.931
   142.500     3.066
   143.000     3.206
   143.500     3.351
   144.000     3.502
   144.500     3.658
   145.000     3.821
   145.500     3.989
   146.000     4.164
   146.500     4.345
   147.000     4.534
   147.500     4.729
   148.000     4.932
   148.500     5.143
   149.000     5.363
   149.500     5.591
   150.000     5.829
   150.500     6.077
   151.000     6.335
   151.500     6.604
   152.000     6.883
   152.500     7.171
   153.000     7.470
   153.500     7.780
   154.000     8.099
   154.500     8.431
   155.000     8.773
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.693
   145.500     0.269
   146.000     1.296
   146.500     2.365
   147.000     3.469
   147.500     4.602
   148.000     5.763
   148.500     6.949
   149.000     8.159
   149.500     9.391
   150.000    10.646
   150.500    11.921
   151.000    13.218
   151.500    14.534
   152.000    15.869
   152.500    17.223
   153.000    18.594
   153.500    19.983
   154.000    21.389
   154.500    22.814
   155.000    24.255
   155.500    25.713
   156.000    27.189
   156.500    28.681
   157.000    30.189
   157.500    31.715
   158.000    33.257
   158.500    34.815
   159.000    36.390
   159.500    37.982
   160.000    39.590
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.695
   145.500     0.072
   146.000     0.766
   146.500     1.408
   147.000     2.007
   147.500     2.567
   148.000     3.092
   148.500     3.585
   149.000     4.051
   149.500     4.497
   150.000     4.927
   150.500     5.344
   151.000     5.751
   151.500     6.148
   152.000     6.537
   152.500     6.918
   153.000     7.294
   153.500     7.665
   154.000     8.034
   154.500     8.401
   155.000     8.765
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   135.924     0.237     0.200
   135.711    -0.365     0.200
   140.224    -0.237     0.200
   142.292    -3.079     0.200
   143.152     0.350     0.200
   148.725    -1.024     0.200
   151.084     0.328     0.200
   140.335    -0.532     0.200
   146.556    -0.898     0.200
   148.725    -1.852     0.200
   149.529     1.543     0.200
   144.332    -0.912     0.200
   159.658    -2.892     0.200
   148.736    -0.662     0.200
   148.732     1.603     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   149.934     3.801     0.200
   149.957     3.531     0.200
   149.949     4.558     0.200
   149.306     4.186     0.200
   149.935     4.147     0.200
   149.922     4.675     0.200
   149.822     3.087     0.200
   149.915     3.655     0.200
   149.100     2.385     0.200
   149.115     3.752     0.200
   149.135     4.167     0.200
   149.568     2.123     0.200
   150.329     5.060     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   159.873    37.132     0.200
   159.921    36.969     0.200
   161.460    43.135     0.200
   157.746    31.933     0.200
   159.859    39.905     0.200
   157.794    32.157     0.200
   158.288    33.000     0.200
   158.556    34.701     0.200
   159.905    39.063     0.200
   161.440    44.278     0.200
   157.811    31.896     0.200
   158.306    33.790     0.200
   159.921    38.371     0.200
   161.455    44.424     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   138.786     2.555     0.200
   139.345     5.588     0.200
   144.312     1.762     0.200
   146.420     3.972     0.200
   151.319     6.453     0.200
   138.406     5.013     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
