#!/bin/bash
gmt begin hubbard6.23_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P hubbard6.23'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.716
    79.000     8.540
    80.000     7.449
    81.000     6.444
    82.000     5.524
    83.000     4.689
    84.000     3.938
    85.000     3.274
    86.000     2.696
    87.000     2.195
    88.000     1.799
    89.000     1.499
    90.000     1.240
    91.000     1.014
    92.000     0.813
    93.000     0.631
    94.000     0.465
    95.000     0.320
    96.000     0.200
    97.000     0.107
    98.000     0.042
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.689     6.545     0.200
    17.547     2.959     0.200
    17.659     1.568     0.200
    18.753    -0.911     0.200
    20.692     0.425     0.200
    21.720    -0.027     0.200
    22.845     0.999     0.200
    25.418    -1.381     0.200
    16.680     5.805     0.200
    17.625     1.477     0.200
    17.541     1.523     0.200
    21.016     1.432     0.200
    21.031     1.671     0.200
    21.446     1.600     0.200
    21.668     0.419     0.200
    21.597     4.172     0.200
    22.214     3.781     0.200
    22.707     2.631     0.200
    23.467     4.321     0.200
    23.628     2.771     0.200
    24.088     2.569     0.200
    25.268     1.318     0.200
    25.363     2.457     0.200
    25.477     1.920     0.200
    25.501     2.202     0.200
    25.546     2.290     0.200
    26.563     3.085     0.200
    33.011    -1.073     0.200
    38.415    -1.444     0.200
    40.569     1.089     0.200
    46.348    -0.015     0.200
    49.088    -0.377     0.200
    49.562     0.096     0.200
    49.562     0.497     0.200
    51.494    -0.304     0.200
    52.400    -0.153     0.200
    55.426     0.623     0.200
    55.618    -0.751     0.200
    58.678     3.700     0.200
    58.797     0.575     0.200
    58.841     3.966     0.200
    59.070    -2.123     0.200
    59.382     3.917     0.200
    59.760    -0.190     0.200
    61.192    -0.672     0.200
    62.318    -0.255     0.200
    62.664     0.430     0.200
    63.687    -0.559     0.200
    65.246    -1.059     0.200
    67.136     0.315     0.200
    67.288    -0.654     0.200
    68.491     0.272     0.200
    68.923     0.581     0.200
    68.989     0.470     0.200
    69.212    -0.013     0.200
    69.428     0.349     0.200
    69.582    -0.003     0.200
    70.351     3.170     0.200
    70.700     0.240     0.200
    71.015     0.226     0.200
    72.705    -0.524     0.200
    72.690    -0.837     0.200
    73.665     0.404     0.200
    76.133     0.135     0.200
    76.133     1.036     0.200
    76.183    -0.151     0.200
    76.183     0.349     0.200
    78.206     0.192     0.200
    78.474     0.511     0.200
    79.453    -0.360     0.200
    79.453     0.441     0.200
    79.496    -1.592     0.200
    81.186     0.313     0.200
    81.186     1.114     0.200
    84.757     0.310     0.200
    14.744     3.911     0.200
    15.688     6.502     0.200
    15.914     6.068     0.200
    17.546     1.439     0.200
    17.614     1.794     0.200
    21.021     1.662     0.200
    21.037     1.193     0.200
    21.253     1.161     0.200
    21.451     1.728     0.200
    21.679     0.384     0.200
    21.597     3.061     0.200
    22.214     2.465     0.200
    22.708     2.011     0.200
    22.771     1.644     0.200
    23.467     0.805     0.200
    24.090     0.044     0.200
    24.811     1.971     0.200
    25.128     1.383     0.200
    25.268     2.008     0.200
    25.365     1.930     0.200
    25.477     2.417     0.200
    25.501     2.397     0.200
    25.549     3.259     0.200
    26.876     3.066     0.200
    29.079     1.579     0.200
    29.215    -0.623     0.200
    29.390     1.021     0.200
    31.247    -1.595     0.200
    31.247    -0.697     0.200
    33.015     1.487     0.200
    33.658     3.282     0.200
    35.284     0.204     0.200
    37.614     0.813     0.200
    39.153     0.363     0.200
    40.552    -2.271     0.200
    40.552    -1.669     0.200
    46.351    -0.038     0.200
    49.086    -1.263     0.200
    49.086    -0.364     0.200
    49.559     1.121     0.200
    49.559     1.321     0.200
    51.503    -0.168     0.200
    52.409    -0.413     0.200
    55.626     2.192     0.200
    56.884    -0.790     0.200
    56.884    -0.189     0.200
    58.438     1.274     0.200
    58.438     1.575     0.200
    58.795     0.789     0.200
    59.079    -1.180     0.200
    62.322     0.717     0.200
    62.659     1.466     0.200
    62.926    -0.308     0.200
    62.926     0.192     0.200
    63.688    -0.062     0.200
    65.076    -0.448     0.200
    65.248    -0.667     0.200
    65.989     0.650     0.200
    66.730    -0.098     0.200
    67.146     0.256     0.200
    67.298    -0.512     0.200
    67.674    -0.091     0.200
    68.222     0.967     0.200
    68.250     0.288     0.200
    68.933     1.025     0.200
    69.467     0.413     0.200
    69.567     0.200     0.200
    69.593    -0.062     0.200
    70.375     0.330     0.200
    70.532     0.174     0.200
    71.012     0.753     0.200
    71.504     0.777     0.200
    73.143     0.485     0.200
    73.143     1.286     0.200
    75.611     0.925     0.200
    76.135     0.130     0.200
    76.135     0.830     0.200
    76.186    -0.159     0.200
    76.186     0.341     0.200
    78.209     0.484     0.200
    78.209     0.586     0.200
    78.352     0.692     0.200
    78.481     0.982     0.200
    79.455    -0.363     0.200
    79.455     0.239     0.200
    81.190     1.298     0.200
    82.665     1.643     0.200
    84.758     1.816     0.200
    84.895     0.129     0.200
    17.799     4.143     0.200
    46.613    -2.976     0.200
    17.405     3.352     0.200
    17.542     3.156     0.200
    21.446     3.983     0.200
    21.819     1.506     0.200
    22.454     1.565     0.200
    25.135     2.659     0.200
    25.511     2.468     0.200
    26.272     1.552     0.200
    37.542     0.542     0.200
    59.626     0.454     0.200
    59.643     0.257     0.200
    88.662    -0.234     0.200
    17.528     2.792     0.200
    25.495     2.245     0.200
    48.124     0.961     0.200
    17.517     3.260     0.200
    21.620     0.017     0.200
    21.657     3.955     0.200
    22.039     1.908     0.200
    22.429     0.572     0.200
    25.109     2.634     0.200
    25.109     3.054     0.200
    25.492     2.132     0.200
    25.915     3.944     0.200
    26.242     2.583     0.200
    53.685    -0.436     0.200
    59.670    -0.108     0.200
    88.687     0.140     0.200
    21.633    -0.632     0.200
    21.633     0.477     0.200
    22.809     1.116     0.200
    25.244     0.697     0.200
    35.162    -0.124     0.200
    41.087    -0.756     0.200
    50.112    -1.221     0.200
    88.553     0.251     0.200
    15.236     3.996     0.200
    16.156     2.192     0.200
    16.806     3.433     0.200
    16.912     3.520     0.200
    17.002     4.321     0.200
    17.230     5.443     0.200
    17.507     3.040     0.200
    17.507     2.415     0.200
    17.550     2.534     0.200
    17.642     1.016     0.200
    18.269     2.586     0.200
    20.197     0.837     0.200
    20.996     0.077     0.200
    21.080     2.766     0.200
    21.080     3.172     0.200
    21.080     1.797     0.200
    21.651     0.524     0.200
    21.651     0.336     0.200
    21.651     0.727     0.200
    21.577     1.568     0.200
    21.683     2.234     0.200
    21.782     1.748     0.200
    21.946     1.258     0.200
    21.946     0.711     0.200
    22.030     1.305     0.200
    22.189     2.764     0.200
    22.189     2.358     0.200
    22.418     0.721     0.200
    22.637     1.155     0.200
    22.723     2.087     0.200
    22.723     1.618     0.200
    22.967     1.789     0.200
    23.055     2.035     0.200
    23.196     2.339     0.200
    23.296     1.074     0.200
    23.296     3.645     0.200
    23.296     1.699     0.200
    23.512     0.442     0.200
    23.586     1.313     0.200
    23.594     1.522     0.200
    23.648     0.881     0.200
    23.797     2.097     0.200
    23.875     1.349     0.200
    23.917     1.672     0.200
    23.966     0.917     0.200
    23.967     1.799     0.200
    24.023     2.022     0.200
    24.048     3.572     0.200
    24.048     0.643     0.200
    24.083     1.239     0.200
    24.176     0.305     0.200
    24.176     0.102     0.200
    24.211     2.878     0.200
    24.211     1.495     0.200
    24.443     0.898     0.200
    24.496     2.282     0.200
    24.496     1.844     0.200
    24.570     3.206     0.200
    24.570     1.714     0.200
    25.012     3.081     0.200
    25.012     0.519     0.200
    25.101     1.598     0.200
    25.101     1.979     0.200
    25.099     1.857     0.200
    25.178     2.280     0.200
    25.178     1.437     0.200
    25.192     0.953     0.200
    25.208     1.333     0.200
    25.474     2.412     0.200
    25.521     2.361     0.200
    25.521     1.650     0.200
    25.682     3.007     0.200
    25.787     1.949     0.200
    25.902     1.943     0.200
    25.994     1.991     0.200
    26.048     2.787     0.200
    26.048     1.897     0.200
    26.100     1.849     0.200
    26.155     1.616     0.200
    26.249     1.139     0.200
    26.249     0.217     0.200
    26.399     1.251     0.200
    26.477     1.165     0.200
    26.487     2.624     0.200
    26.662    -0.114     0.200
    26.662    -0.458     0.200
    27.596     1.057     0.200
    27.602     2.783     0.200
    27.602     1.854     0.200
    27.666     1.395     0.200
    27.741     2.337     0.200
    27.741     0.291     0.200
    27.756     2.205     0.200
    27.756     1.619     0.200
    28.086     1.089     0.200
    28.972     1.266     0.200
    29.159     1.427     0.200
    29.237     1.518     0.200
    29.371     1.430     0.200
    29.410     3.690     0.200
    29.410     0.198     0.200
    29.584     2.258     0.200
    29.935     1.043     0.200
    30.992     1.144     0.200
    31.956     1.067     0.200
    32.975     2.681     0.200
    32.975     2.454     0.200
    32.975     1.642     0.200
    33.442     0.582     0.200
    33.453     0.194     0.200
    33.608     0.259     0.200
    33.608    -0.202     0.200
    33.616     2.988     0.200
    33.616     1.636     0.200
    33.703    -2.064     0.200
    33.924     0.901     0.200
    35.058     1.588     0.200
    35.705     1.261     0.200
    36.219     1.049     0.200
    36.243     1.666     0.200
    36.847    -0.259     0.200
    37.171     0.310     0.200
    37.324     0.003     0.200
    37.536     1.195     0.200
    37.536     0.672     0.200
    37.779     0.054     0.200
    38.311     2.021     0.200
    39.031     0.341     0.200
    39.018     2.735     0.200
    39.018     0.845     0.200
    39.018     1.961     0.200
    39.145    -0.370     0.200
    39.727     1.088     0.200
    40.083     1.541     0.200
    40.279     1.060     0.200
    40.422    -0.319     0.200
    40.584    -0.187     0.200
    40.584    -0.297     0.200
    41.044     0.620     0.200
    41.044    -0.021     0.200
    41.336     0.840     0.200
    41.603     2.181     0.200
    41.756     1.318     0.200
    41.839     1.891     0.200
    41.839     0.946     0.200
    41.971     2.955     0.200
    45.221     0.136     0.200
    45.361    -0.175     0.200
    45.361     0.622     0.200
    45.923     0.581     0.200
    48.695    -2.808     0.200
    49.116    -1.139     0.200
    50.052    -1.575     0.200
    50.185    -0.564     0.200
    53.174    -0.015     0.200
    53.696     0.394     0.200
    55.507     0.901     0.200
    55.507     0.002     0.200
    55.507     0.502     0.200
    55.507     0.205     0.200
    55.648     0.086     0.200
    56.912     0.064     0.200
    57.051    -1.417     0.200
    57.051    -0.440     0.200
    57.596     0.633     0.200
    57.596     0.837     0.200
    57.596     1.032     0.200
    58.247    -0.890     0.200
    58.466     1.936     0.200
    58.824     1.043     0.200
    59.675     0.788     0.200
    59.924     1.161     0.200
    59.957     0.111     0.200
    60.216     0.355     0.200
    60.469    -1.792     0.200
    60.793    -2.507     0.200
    60.940     0.292     0.200
    61.130     0.609     0.200
    61.297     0.875     0.200
    62.328     0.133     0.200
    62.697     0.668     0.200
    63.903     0.381     0.200
    64.464    -0.206     0.200
    64.706    -0.068     0.200
    64.724    -0.598     0.200
    64.994    -0.239     0.200
    65.069    -0.050     0.200
    65.069    -0.449     0.200
    65.273     2.727     0.200
    65.364     0.240     0.200
    65.510     0.296     0.200
    65.760     0.477     0.200
    65.970    -0.477     0.200
    66.170     0.041     0.200
    66.288     0.084     0.200
    66.375     0.027     0.200
    66.427    -0.001     0.200
    66.459    -0.413     0.200
    66.586    -0.124     0.200
    66.702    -1.067     0.200
    66.710    -0.720     0.200
    66.719    -0.069     0.200
    66.971     0.622     0.200
    67.125     0.045     0.200
    67.127     0.130     0.200
    67.204     2.638     0.200
    67.279    -0.031     0.200
    67.628     0.260     0.200
    67.656     0.183     0.200
    67.656     0.081     0.200
    67.661     0.050     0.200
    67.710     0.437     0.200
    67.766     0.082     0.200
    67.944    -0.127     0.200
    67.941    -0.020     0.200
    67.978     0.452     0.200
    67.978     0.452     0.200
    68.016     0.116     0.200
    68.038     1.473     0.200
    68.038    -0.222     0.200
    68.141     0.224     0.200
    68.231     0.068     0.200
    68.263     0.266     0.200
    68.396    -2.468     0.200
    68.479     0.212     0.200
    68.493     0.225     0.200
    68.493    -1.876     0.200
    68.561    -0.596     0.200
    68.585     0.249     0.200
    68.681     0.050     0.200
    68.762     0.147     0.200
    68.787     0.594     0.200
    68.894     0.224     0.200
    68.913     0.604     0.200
    68.964     0.190     0.200
    68.975     0.121     0.200
    68.986     0.151     0.200
    68.986    -0.748     0.200
    69.150    -0.845     0.200
    69.197    -0.158     0.200
    69.210     0.157     0.200
    69.210    -0.054     0.200
    69.303    -0.216     0.200
    69.403    -1.139     0.200
    69.413    -0.096     0.200
    69.443    -0.079     0.200
    69.461    -0.896     0.200
    69.495     0.000     0.200
    69.579    -1.124     0.200
    69.598     0.964     0.200
    69.846     0.539     0.200
    69.957    -0.249     0.200
    70.034    -0.119     0.200
    70.092     0.525     0.200
    70.103    -0.849     0.200
    70.178    -0.408     0.200
    70.225     2.213     0.200
    70.302     0.136     0.200
    70.316     0.553     0.200
    70.313     3.869     0.200
    70.335    -0.668     0.200
    70.357     0.097     0.200
    70.362     1.168     0.200
    70.396     0.860     0.200
    70.544    -0.053     0.200
    70.664    -0.075     0.200
    70.811     4.033     0.200
    70.823    -0.044     0.200
    70.867     0.885     0.200
    71.004     1.056     0.200
    71.047     0.698     0.200
    71.046     1.003     0.200
    71.136    -0.444     0.200
    71.132     3.129     0.200
    71.069    -1.753     0.200
    71.158     0.323     0.200
    71.240     0.689     0.200
    71.257    -0.171     0.200
    71.285     1.651     0.200
    71.325    -0.083     0.200
    71.384     4.207     0.200
    71.456     0.724     0.200
    71.522     3.234     0.200
    71.528    -0.614     0.200
    71.544     0.790     0.200
    71.556    -0.880     0.200
    71.583     0.371     0.200
    71.617     0.451     0.200
    71.892     0.197     0.200
    71.883    -0.343     0.200
    71.807     1.222     0.200
    71.899     0.152     0.200
    71.917     0.544     0.200
    71.928    -0.218     0.200
    71.975    -0.395     0.200
    72.031    -0.936     0.200
    72.137    -0.314     0.200
    72.197     0.071     0.200
    72.305     3.742     0.200
    72.312     0.678     0.200
    72.360    -0.110     0.200
    72.568     2.709     0.200
    72.708    -0.319     0.200
    72.807    -1.066     0.200
    72.846    -0.401     0.200
    72.864    -0.404     0.200
    72.877     3.200     0.200
    72.988    -0.340     0.200
    73.175    -0.144     0.200
    73.210     0.147     0.200
    73.294     0.709     0.200
    73.225     2.068     0.200
    73.387     0.527     0.200
    73.311     2.021     0.200
    73.481    -0.049     0.200
    73.496     0.882     0.200
    73.539     1.544     0.200
    73.539     0.677     0.200
    73.683     0.760     0.200
    73.781     1.070     0.200
    73.795     2.676     0.200
    73.791     1.229     0.200
    73.887     1.364     0.200
    73.897     1.000     0.200
    73.897    -0.289     0.200
    73.887    -0.330     0.200
    73.985     2.057     0.200
    74.026     1.041     0.200
    74.024     0.749     0.200
    74.055     1.060     0.200
    74.065     3.127     0.200
    74.020     1.107     0.200
    74.268     1.311     0.200
    74.272     0.502     0.200
    74.285     1.249     0.200
    74.328     0.628     0.200
    74.396     0.491     0.200
    74.446    -0.092     0.200
    74.508     0.844     0.200
    74.552     1.830     0.200
    74.564     0.015     0.200
    74.572    -2.927     0.200
    74.633     2.648     0.200
    74.947     0.446     0.200
    74.999    -0.297     0.200
    75.033     0.402     0.200
    75.164     0.149     0.200
    75.248     0.318     0.200
    75.305     0.053     0.200
    75.407    -1.549     0.200
    75.397     1.438     0.200
    75.479     0.198     0.200
    75.646     0.379     0.200
    75.654     2.453     0.200
    75.785     0.949     0.200
    75.902     0.940     0.200
    75.953     1.721     0.200
    76.018     0.870     0.200
    76.075     0.069     0.200
    76.161     0.284     0.200
    76.233     0.188     0.200
    76.271     0.314     0.200
    76.271    -0.288     0.200
    76.319    -1.598     0.200
    76.367     0.526     0.200
    76.489     1.078     0.200
    76.548     1.244     0.200
    76.539     1.293     0.200
    76.654    -0.559     0.200
    76.680    -0.320     0.200
    76.914     0.294     0.200
    77.050     0.413     0.200
    77.038     0.701     0.200
    77.535    -0.023     0.200
    77.700     1.774     0.200
    77.709     1.721     0.200
    77.854     0.017     0.200
    77.988    -0.392     0.200
    78.026    -0.497     0.200
    77.947     0.694     0.200
    78.151    -0.445     0.200
    78.169    -0.455     0.200
    78.415     0.028     0.200
    78.449    -0.386     0.200
    78.627    -3.257     0.200
    79.024    -1.440     0.200
    79.137     0.835     0.200
    79.414     4.100     0.200
    80.031     0.871     0.200
    80.031     0.043     0.200
    80.345     0.027     0.200
    81.191     0.456     0.200
    81.391     2.487     0.200
    83.366    -1.031     0.200
    83.767     0.811     0.200
    83.827     0.001     0.200
    83.943     1.014     0.200
    84.780     1.667     0.200
    84.909     1.219     0.200
    85.075     0.884     0.200
    85.077     0.878     0.200
    85.239     0.464     0.200
    85.299     0.963     0.200
    85.612     0.605     0.200
    86.558    -0.670     0.200
    86.626     0.345     0.200
    86.773     0.590     0.200
    87.005    -0.184     0.200
    87.261     0.050     0.200
    87.997     0.661     0.200
    88.377     0.369     0.200
    88.698     1.105     0.200
    90.000     0.500     0.200
    90.712     0.037     0.200
    91.673    -1.370     0.200
    94.967     3.584     0.200
    96.869    -0.149     0.200
    13.977     7.159     0.200
    14.439     6.354     0.200
    14.491     9.928     0.200
    14.611    10.337     0.200
    14.708     7.163     0.200
    14.712     8.991     0.200
    14.899     6.006     0.200
    14.910     7.832     0.200
    14.956     8.260     0.200
    15.328     8.530     0.200
    15.653     6.703     0.200
    16.806     3.349     0.200
    16.911     5.360     0.200
    17.002     4.400     0.200
    17.510     1.971     0.200
    17.942     3.428     0.200
    18.306     0.065     0.200
    18.316     0.518     0.200
    18.316     2.448     0.200
    20.203     0.900     0.200
    21.077     2.857     0.200
    21.077     1.756     0.200
    21.320     3.480     0.200
    21.667     0.064     0.200
    21.667     0.720     0.200
    21.682     1.881     0.200
    21.781     1.915     0.200
    21.950     0.694     0.200
    21.957     3.230     0.200
    22.033     1.274     0.200
    22.186     1.890     0.200
    22.420     1.040     0.200
    22.640     0.555     0.200
    22.673     1.930     0.200
    22.738    -0.231     0.200
    22.738     1.683     0.200
    23.059     0.792     0.200
    23.304     0.429     0.200
    23.300     2.074     0.200
    23.508     0.593     0.200
    23.593     0.841     0.200
    23.597     1.883     0.200
    23.645     0.570     0.200
    23.800     1.943     0.200
    23.878     1.886     0.200
    23.920     1.645     0.200
    23.969     0.552     0.200
    23.970     1.418     0.200
    24.026     1.650     0.200
    24.176     1.090     0.200
    24.176     0.403     0.200
    24.496     2.235     0.200
    25.008     1.459     0.200
    25.104     0.904     0.200
    25.104     2.184     0.200
    25.175     1.851     0.200
    25.210     0.815     0.200
    25.472     2.268     0.200
    25.519     1.459     0.200
    25.903    -0.377     0.200
    25.992     0.869     0.200
    26.153     1.187     0.200
    26.260     1.753     0.200
    26.260     1.402     0.200
    26.476     1.456     0.200
    26.483     0.888     0.200
    27.597     0.397     0.200
    28.090     1.169     0.200
    29.158     2.425     0.200
    33.616     0.932     0.200
    36.221    -0.192     0.200
    37.552     0.801     0.200
    37.787    -1.003     0.200
    39.020     2.209     0.200
    40.584     0.106     0.200
    48.691    -2.784     0.200
    49.117    -0.554     0.200
    53.169     0.116     0.200
    55.644    -0.093     0.200
    57.066     1.040     0.200
    57.598     1.515     0.200
    57.598     0.608     0.200
    58.468     2.119     0.200
    58.826     0.629     0.200
    59.664     0.431     0.200
    59.669     0.793     0.200
    59.761    -0.194     0.200
    59.924     1.895     0.200
    59.968     0.840     0.200
    60.475    -2.438     0.200
    62.338     0.666     0.200
    62.694     2.387     0.200
    63.901    -0.610     0.200
    64.049    -0.888     0.200
    64.714    -0.553     0.200
    65.342    -1.427     0.200
    68.258     0.989     0.200
    69.164    -0.910     0.200
    69.498     0.975     0.200
    69.598     1.358     0.200
    69.659     0.948     0.200
    71.045     1.007     0.200
    73.903     0.267     0.200
    73.903    -0.460     0.200
    74.041     0.775     0.200
    75.176     3.079     0.200
    76.554     1.211     0.200
    78.387     1.254     0.200
    80.043     3.112     0.200
    81.189     2.265     0.200
    81.393     2.887     0.200
    81.393     1.832     0.200
    83.948     1.186     0.200
    84.912     1.209     0.200
    85.078     0.569     0.200
    85.079     0.960     0.200
    85.242     0.555     0.200
    85.301     0.952     0.200
    85.615     0.389     0.200
    88.696     0.851     0.200
    88.696     1.422     0.200
    59.919     0.825     0.200
    17.516     1.347     0.200
    21.622    -0.888     0.200
    21.622     0.362     0.200
    22.039    -0.535     0.200
    22.428     0.969     0.200
    22.708     0.200     0.200
    27.608    -0.983     0.200
    30.999     0.756     0.200
    59.909     0.859     0.200
    21.642    -1.009     0.200
    25.444     1.293     0.200
    68.208    -1.345     0.200
    15.923     4.027     0.200
    23.433     0.660     0.200
    25.548     1.215     0.200
    26.407    -0.952     0.200
    34.030    -2.253     0.200
    37.177     0.485     0.200
    37.403     0.544     0.200
    37.587     0.576     0.200
    37.587     1.037     0.200
    46.479    -1.509     0.200
    50.160    -1.191     0.200
    58.223    -1.197     0.200
    59.594     0.259     0.200
    59.587     0.395     0.200
    59.848    -0.119     0.200
    60.860    -0.510     0.200
    65.274    -1.561     0.200
    68.101    -0.895     0.200
    69.126    -1.317     0.200
    69.810    -0.572     0.200
    74.036    -0.500     0.200
    74.194    -0.560     0.200
    88.619     0.796     0.200
    61.070    -0.948     0.200
    65.586    -1.099     0.200
    21.681    -1.180     0.200
    59.918     0.069     0.200
    60.929    -0.975     0.200
    64.715    -1.086     0.200
    65.448    -0.481     0.200
    68.170    -0.863     0.200
    88.687     0.814     0.200
    65.454    -1.108     0.200
    68.175    -0.354     0.200
    16.731     1.339     0.200
    17.393     1.595     0.200
    18.748     1.268     0.200
    19.307     2.265     0.200
    20.724    -0.105     0.200
    20.997     1.313     0.200
    21.013     1.707     0.200
    21.242     2.634     0.200
    22.692     1.882     0.200
    23.224     2.074     0.200
    23.536     1.690     0.200
    24.437     1.439     0.200
    25.057     2.325     0.200
    26.068     1.704     0.200
    26.676     2.321     0.200
    28.945     1.391     0.200
    30.726     1.721     0.200
    33.178     2.056     0.200
    33.424     2.682     0.200
    33.578     2.704     0.200
    33.845     1.375     0.200
    35.036     1.515     0.200
    36.665     2.475     0.200
    36.950     1.775     0.200
    37.442     0.656     0.200
    39.710     1.138     0.200
    39.878     1.448     0.200
    40.354     1.330     0.200
    40.622     1.079     0.200
    41.065     1.371     0.200
    41.084     2.103     0.200
    41.053     2.093     0.200
    41.301     1.974     0.200
    41.873     2.195     0.200
    42.009     0.950     0.200
    42.017     1.903     0.200
    42.183     2.668     0.200
    43.153     1.176     0.200
    43.281     2.371     0.200
    43.744     1.793     0.200
    44.551     1.660     0.200
    45.220     1.441     0.200
    46.866     3.772     0.200
    49.777     0.940     0.200
    51.930     0.694     0.200
    53.806     1.253     0.200
    55.048     1.549     0.200
    55.389     2.199     0.200
    57.890     2.626     0.200
    59.431     1.236     0.200
    59.521     0.986     0.200
    60.057     2.046     0.200
    62.702     0.889     0.200
    62.917     1.268     0.200
    63.203     1.408     0.200
    64.415     1.077     0.200
    65.060     0.600     0.200
    65.866     1.465     0.200
    67.960     0.426     0.200
    69.575     1.419     0.200
    69.574     1.185     0.200
    70.498     2.356     0.200
    70.998     2.330     0.200
    70.998     2.096     0.200
    71.679     3.207     0.200
    71.920     1.888     0.200
    73.621     1.612     0.200
    73.830     2.874     0.200
    75.869     2.490     0.200
    75.988     2.243     0.200
    77.405     1.220     0.200
    79.746     1.848     0.200
    79.884     2.251     0.200
    84.305     2.319     0.200
    87.465     0.137     0.200
    90.045     3.246     0.200
    92.640     2.558     0.200
    15.886     2.831     0.200
    15.886     3.346     0.200
    16.013     3.773     0.200
    17.649     0.318     0.200
    17.703     3.487     0.200
    18.480     2.808     0.200
    20.415     2.712     0.200
    20.724     1.832     0.200
    21.117     2.507     0.200
    21.117     1.139     0.200
    22.127     2.899     0.200
    22.127     1.743     0.200
    22.626     2.645     0.200
    23.533     2.506     0.200
    23.951     2.507     0.200
    23.951     2.038     0.200
    24.623     2.322     0.200
    24.637     2.316     0.200
    24.720     3.089     0.200
    25.057     2.669     0.200
    25.287     1.907     0.200
    26.116     2.539     0.200
    26.212     1.531     0.200
    26.309     2.806     0.200
    26.312     3.076     0.200
    26.312     2.748     0.200
    26.676     3.337     0.200
    26.676     2.938     0.200
    28.296     2.771     0.200
    28.274     2.786     0.200
    28.945     1.992     0.200
    28.945     2.414     0.200
    29.284     1.986     0.200
    29.417     1.540     0.200
    29.996     2.239     0.200
    30.083     3.664     0.200
    30.394     2.049     0.200
    30.480     2.368     0.200
    30.480     2.157     0.200
    30.726     3.018     0.200
    30.726     2.690     0.200
    30.728     2.999     0.200
    30.771     2.894     0.200
    31.082     1.375     0.200
    31.180     2.774     0.200
    33.178     3.478     0.200
    33.178     2.369     0.200
    33.178     3.127     0.200
    33.424     2.018     0.200
    33.424     2.823     0.200
    33.450     3.181     0.200
    33.578     0.680     0.200
    33.578     1.680     0.200
    33.845     3.563     0.200
    33.845     3.359     0.200
    33.892     3.252     0.200
    34.063     2.021     0.200
    34.367     3.801     0.200
    34.794     2.795     0.200
    35.005     2.398     0.200
    35.036     1.953     0.200
    35.036     2.523     0.200
    35.238     2.550     0.200
    36.279     0.171     0.200
    36.450     2.956     0.200
    36.440     1.546     0.200
    36.638     2.417     0.200
    36.665     3.881     0.200
    36.665     3.241     0.200
    36.665     3.686     0.200
    36.950     2.837     0.200
    37.442     1.570     0.200
    37.442     1.258     0.200
    37.462     2.395     0.200
    37.903     3.034     0.200
    37.904     3.761     0.200
    38.171     1.346     0.200
    38.171     1.456     0.200
    38.341     3.181     0.200
    39.710     2.138     0.200
    39.710     1.607     0.200
    39.823     1.855     0.200
    39.796     2.600     0.200
    39.861     2.359     0.200
    39.878     3.245     0.200
    39.878     3.643     0.200
    40.354     2.369     0.200
    40.354     2.540     0.200
    40.354     1.619     0.200
    40.589     3.352     0.200
    40.589     3.602     0.200
    40.622     1.947     0.200
    40.622     1.618     0.200
    40.701     2.332     0.200
    40.769     1.922     0.200
    40.941     3.050     0.200
    40.998     2.200     0.200
    41.065     3.215     0.200
    41.065     2.566     0.200
    41.084     4.439     0.200
    41.265     3.095     0.200
    41.789     2.374     0.200
    41.786     2.784     0.200
    42.009     1.778     0.200
    42.009     2.169     0.200
    42.009     1.559     0.200
    41.954     2.156     0.200
    42.017     4.458     0.200
    42.183     1.067     0.200
    42.183     4.012     0.200
    42.080     3.918     0.200
    42.227     2.196     0.200
    42.282     2.848     0.200
    42.318     2.877     0.200
    42.382     2.528     0.200
    43.399     2.427     0.200
    43.529     2.321     0.200
    43.744     3.871     0.200
    44.136     2.674     0.200
    44.931     2.426     0.200
    45.220     2.316     0.200
    45.220     2.449     0.200
    45.536     3.635     0.200
    45.472     2.721     0.200
    46.026     3.151     0.200
    46.788     2.992     0.200
    47.047     1.995     0.200
    47.398     2.365     0.200
    47.397     2.179     0.200
    48.514     2.015     0.200
    48.722     2.514     0.200
    48.722     3.021     0.200
    48.722     2.896     0.200
    49.370     3.048     0.200
    49.777     1.448     0.200
    49.777     1.252     0.200
    50.072     1.365     0.200
    50.280     2.586     0.200
    50.280     3.188     0.200
    50.670     2.242     0.200
    50.908     0.986     0.200
    51.904     1.212     0.200
    51.930     3.929     0.200
    51.930     2.843     0.200
    51.930     1.796     0.200
    52.843     0.705     0.200
    53.002     2.305     0.200
    53.487     2.016     0.200
    53.636     1.320     0.200
    53.708     1.138     0.200
    53.806     2.245     0.200
    53.806     1.690     0.200
    54.004     2.519     0.200
    54.021     1.874     0.200
    54.173     2.391     0.200
    54.173     2.602     0.200
    54.348     0.770     0.200
    54.980     0.856     0.200
    55.048     3.650     0.200
    55.048     1.783     0.200
    55.389     3.066     0.200
    55.389     2.574     0.200
    55.389     3.176     0.200
    55.596     3.959     0.200
    56.130     2.326     0.200
    56.455     3.048     0.200
    56.554     2.895     0.200
    56.714     1.355     0.200
    56.921     2.281     0.200
    57.112     1.599     0.200
    57.170     1.605     0.200
    57.373     2.546     0.200
    57.326     2.412     0.200
    57.832     2.591     0.200
    57.890     3.438     0.200
    57.890     3.290     0.200
    57.880     2.819     0.200
    58.042     2.017     0.200
    58.216     3.898     0.200
    58.214     1.462     0.200
    58.341     3.025     0.200
    58.580     2.958     0.200
    58.718     2.824     0.200
    58.974     1.322     0.200
    59.067     1.672     0.200
    59.065     1.457     0.200
    59.073     1.326     0.200
    59.431     2.556     0.200
    59.431     2.853     0.200
    59.431     3.173     0.200
    59.431     2.056     0.200
    59.521     2.212     0.200
    59.521     0.837     0.200
    59.585     1.548     0.200
    59.680     2.258     0.200
    59.742     2.386     0.200
    59.742     3.268     0.200
    59.733     1.692     0.200
    59.903     2.299     0.200
    59.903     2.439     0.200
    59.957     2.351     0.200
    59.961     1.808     0.200
    60.057     2.327     0.200
    60.057     2.648     0.200
    60.174     0.974     0.200
    60.195     0.597     0.200
    60.248     3.001     0.200
    60.248     2.650     0.200
    60.214     1.807     0.200
    60.249     2.077     0.200
    60.465     3.101     0.200
    60.504     3.120     0.200
    60.630     2.791     0.200
    60.630     3.065     0.200
    60.630     3.322     0.200
    60.653     1.800     0.200
    60.653     0.768     0.200
    60.660     1.291     0.200
    60.848     2.275     0.200
    60.831     2.102     0.200
    60.880     4.020     0.200
    60.983     2.113     0.200
    60.983     2.269     0.200
    61.141     0.627     0.200
    61.141     1.900     0.200
    61.105     1.679     0.200
    61.133     2.261     0.200
    61.148     0.898     0.200
    61.209     2.674     0.200
    61.209     3.581     0.200
    61.353     2.514     0.200
    61.439     1.437     0.200
    61.626     2.417     0.200
    61.815     1.225     0.200
    61.757     2.305     0.200
    61.803     4.128     0.200
    61.887     3.851     0.200
    62.042     1.461     0.200
    62.132     2.948     0.200
    62.523     2.864     0.200
    62.630     2.362     0.200
    62.702     1.568     0.200
    62.917     2.448     0.200
    62.988     3.631     0.200
    63.203     0.440     0.200
    63.368     0.726     0.200
    63.361     3.390     0.200
    63.366     2.716     0.200
    63.901     2.197     0.200
    63.953     3.810     0.200
    64.044     2.765     0.200
    64.368     3.266     0.200
    64.415     1.827     0.200
    64.453     3.167     0.200
    64.752     3.015     0.200
    64.753     4.048     0.200
    65.001     2.102     0.200
    65.060     1.217     0.200
    65.060     0.818     0.200
    65.155     2.499     0.200
    65.185     2.686     0.200
    65.342     2.911     0.200
    65.512     3.474     0.200
    65.728     3.675     0.200
    65.731     3.164     0.200
    65.816     3.300     0.200
    65.893     3.071     0.200
    66.011     2.490     0.200
    66.165     3.391     0.200
    66.169     2.764     0.200
    66.378     1.398     0.200
    66.358     3.632     0.200
    66.433     2.977     0.200
    66.458     2.908     0.200
    66.640     1.739     0.200
    66.727     4.050     0.200
    66.876     3.249     0.200
    66.947     1.282     0.200
    66.995     3.236     0.200
    67.205     3.461     0.200
    67.237     2.258     0.200
    67.341     4.032     0.200
    67.400     2.752     0.200
    67.414     1.112     0.200
    67.456     3.198     0.200
    67.615     3.766     0.200
    67.668     3.514     0.200
    67.679     3.572     0.200
    67.688     2.456     0.200
    67.730     3.686     0.200
    67.731     4.033     0.200
    67.885     2.735     0.200
    67.889     3.960     0.200
    67.932     3.960     0.200
    67.960     0.872     0.200
    67.960     1.317     0.200
    67.978     3.378     0.200
    68.077     3.045     0.200
    68.146     3.953     0.200
    68.146     3.187     0.200
    68.093     4.190     0.200
    68.166     4.024     0.200
    68.213     3.353     0.200
    68.218     1.682     0.200
    68.258     3.799     0.200
    68.316     1.872     0.200
    68.333     3.608     0.200
    68.367     3.263     0.200
    68.369     2.693     0.200
    68.378     3.001     0.200
    68.404     3.158     0.200
    68.454     3.812     0.200
    68.459     3.385     0.200
    68.481     2.533     0.200
    68.537     3.405     0.200
    68.553     3.250     0.200
    68.555     1.788     0.200
    68.614     3.656     0.200
    68.614     2.672     0.200
    68.624     3.137     0.200
    68.635     2.969     0.200
    68.662     3.998     0.200
    68.743     2.650     0.200
    68.828     2.008     0.200
    68.828     2.352     0.200
    68.795     1.896     0.200
    68.935     1.814     0.200
    68.970     3.912     0.200
    69.025     3.390     0.200
    69.079     3.495     0.200
    69.208     2.814     0.200
    69.208     1.369     0.200
    69.094     3.252     0.200
    69.094     2.729     0.200
    69.136     2.549     0.200
    69.129     1.809     0.200
    69.154     3.710     0.200
    69.205     3.638     0.200
    69.215     3.357     0.200
    69.352     1.851     0.200
    69.352     2.546     0.200
    69.379     3.168     0.200
    69.535     3.085     0.200
    69.813     4.096     0.200
    69.831     3.736     0.200
    69.940     3.919     0.200
    70.021     3.566     0.200
    70.106     1.540     0.200
    70.173     1.914     0.200
    70.167     1.255     0.200
    70.235     3.521     0.200
    70.260     3.454     0.200
    70.260     4.188     0.200
    70.347     4.256     0.200
    70.471     3.705     0.200
    70.498     4.317     0.200
    70.526     3.399     0.200
    70.525     4.086     0.200
    70.533     3.423     0.200
    70.533     3.923     0.200
    70.613     1.872     0.200
    70.652     0.923     0.200
    70.662     3.317     0.200
    70.743     4.097     0.200
    70.794     3.429     0.200
    70.970     3.821     0.200
    71.021     3.567     0.200
    71.166     4.161     0.200
    71.294     3.849     0.200
    71.370     2.497     0.200
    71.396     3.848     0.200
    71.414     2.371     0.200
    71.480     3.819     0.200
    71.508     4.173     0.200
    71.508     3.306     0.200
    71.525     1.857     0.200
    71.876     2.488     0.200
    71.679     2.355     0.200
    71.679     3.020     0.200
    71.624     3.614     0.200
    71.834     1.795     0.200
    71.856     3.757     0.200
    71.920     2.599     0.200
    71.920     2.216     0.200
    71.893     1.987     0.200
    71.894     1.878     0.200
    71.967     3.445     0.200
    72.087     3.835     0.200
    72.155     3.417     0.200
    72.242     2.282     0.200
    72.254     3.558     0.200
    72.534     3.652     0.200
    72.535     3.052     0.200
    72.537     3.954     0.200
    72.581     3.704     0.200
    72.649     2.272     0.200
    72.649     2.404     0.200
    72.589     2.706     0.200
    72.607     3.827     0.200
    72.646     3.596     0.200
    72.666     3.084     0.200
    72.784     2.564     0.200
    72.812     3.468     0.200
    72.847     3.294     0.200
    72.890     2.278     0.200
    72.923     3.459     0.200
    72.923     2.247     0.200
    72.937     3.398     0.200
    72.975     3.008     0.200
    73.155     1.875     0.200
    73.236     2.134     0.200
    73.427     2.206     0.200
    73.447     1.947     0.200
    73.510     2.657     0.200
    73.559     2.157     0.200
    73.501     3.198     0.200
    73.502     3.965     0.200
    73.575     0.349     0.200
    73.621     2.518     0.200
    73.621     2.744     0.200
    73.621     1.971     0.200
    73.671     1.474     0.200
    73.694     2.064     0.200
    73.745     2.451     0.200
    73.762     3.126     0.200
    73.794     3.378     0.200
    73.830     2.523     0.200
    73.854     3.006     0.200
    73.870     4.158     0.200
    73.909     1.535     0.200
    74.114     4.192     0.200
    74.188     2.819     0.200
    74.188     2.608     0.200
    74.207     3.748     0.200
    74.220     4.261     0.200
    74.367     1.967     0.200
    74.337     3.911     0.200
    74.400     1.692     0.200
    74.467     4.116     0.200
    74.635     4.149     0.200
    74.672    -1.144     0.200
    74.757     3.208     0.200
    74.701     3.475     0.200
    74.710     1.314     0.200
    74.794     1.949     0.200
    74.823     2.167     0.200
    74.884    -1.230     0.200
    74.916     3.381     0.200
    74.950     1.676     0.200
    74.975     1.003     0.200
    75.047     3.414     0.200
    75.072     2.877     0.200
    75.309     3.554     0.200
    75.332     3.868     0.200
    75.404     4.188     0.200
    75.372     2.216     0.200
    75.444     1.943     0.200
    75.556     3.369     0.200
    75.722     4.182     0.200
    75.774     0.401     0.200
    75.869     2.842     0.200
    75.811     3.344     0.200
    75.813     0.419     0.200
    75.837     4.016     0.200
    76.064     3.629     0.200
    76.064     2.473     0.200
    75.988     3.204     0.200
    75.988     2.813     0.200
    75.988     3.063     0.200
    76.008     1.896     0.200
    76.053     3.694     0.200
    76.174     3.043     0.200
    76.165    -0.805     0.200
    76.211     3.040     0.200
    76.279     3.397     0.200
    76.387     2.627     0.200
    76.387     3.322     0.200
    76.397     3.736     0.200
    76.432     2.787     0.200
    76.773     2.734     0.200
    76.855     1.738     0.200
    76.923     3.312     0.200
    77.215     2.463     0.200
    77.405     2.212     0.200
    77.405     2.532     0.200
    77.767     3.245     0.200
    77.914     3.198     0.200
    78.064     3.227     0.200
    78.458     3.292     0.200
    78.532     2.472     0.200
    78.614     2.720     0.200
    78.614     3.947     0.200
    78.707     2.847     0.200
    79.514     3.580     0.200
    79.746     3.066     0.200
    79.746     1.996     0.200
    79.801     3.869     0.200
    79.884     3.977     0.200
    79.884     4.172     0.200
    79.884     3.212     0.200
    80.671     2.827     0.200
    80.701     3.292     0.200
    80.845     4.204     0.200
    81.151     3.487     0.200
    81.251     4.477     0.200
    81.719     3.398     0.200
    81.737     2.934     0.200
    82.311     4.187     0.200
    82.359     3.498     0.200
    82.982     2.533     0.200
    83.137     1.640     0.200
    83.373     3.458     0.200
    83.460     2.754     0.200
    83.516     3.155     0.200
    84.104     2.017     0.200
    84.185     3.108     0.200
    84.305     1.803     0.200
    84.305     1.577     0.200
    84.799     2.780     0.200
    86.322     1.995     0.200
    86.322     1.784     0.200
    86.354     3.507     0.200
    87.148     3.569     0.200
    87.148     2.905     0.200
    87.465     1.684     0.200
    87.465     0.856     0.200
    87.478     2.018     0.200
    87.571     0.980     0.200
    87.763     3.697     0.200
    88.170     2.056     0.200
    88.525     2.222     0.200
    88.604     2.568     0.200
    88.604     3.326     0.200
    89.362     2.487     0.200
    89.362     2.628     0.200
    89.404     4.073     0.200
    90.045     2.355     0.200
    90.144     1.566     0.200
    90.906     2.464     0.200
    90.906     2.284     0.200
    91.022     1.040     0.200
    91.022     0.758     0.200
    91.237     3.373     0.200
    91.666     2.524     0.200
    91.794     3.681     0.200
    92.120     2.673     0.200
    92.640     4.526     0.200
    93.187     3.552     0.200
    93.187     1.333     0.200
    94.004     2.266     0.200
    94.744     0.941     0.200
    95.128     0.203     0.200
    95.662     4.411     0.200
    95.887     1.956     0.200
    96.253     0.667     0.200
    96.305     1.479     0.200
    97.092     3.708     0.200
    97.269     2.799     0.200
    97.359     3.134     0.200
    98.592     4.083     0.200
    98.592     3.309     0.200
    98.691     1.101     0.200
    98.815     3.906     0.200
    98.819     4.226     0.200
    98.819     3.351     0.200
    98.978     3.230     0.200
    19.938    -1.569     0.200
    20.754    -2.180     0.200
    29.020    -0.746     0.200
    75.088     0.680     0.200
    35.134    -1.040     0.200
    39.961     1.390     0.200
    45.290    -0.107     0.200
    48.595    -1.043     0.200
    59.524     0.471     0.200
    60.752    -1.350     0.200
    61.066     0.116     0.200
    62.798    -1.132     0.200
    64.000     0.114     0.200
    65.160    -0.862     0.200
    67.996    -1.193     0.200
    19.305     0.766     0.200
    20.729    -2.580     0.200
    36.892    -0.348     0.200
    33.960    -0.577     0.200
    16.120     3.223     0.200
    20.569    -1.152     0.200
    21.202     2.580     0.200
    22.434     1.303     0.200
    25.094     0.920     0.200
    34.054     1.678     0.200
    37.895     0.281     0.200
    59.222    -0.272     0.200
    59.313    -0.756     0.200
    59.481     0.503     0.200
    60.464    -1.746     0.200
    64.242    -0.276     0.200
    67.706    -1.503     0.200
    67.769    -1.498     0.200
    69.416    -0.753     0.200
    70.476     0.743     0.200
    71.506    -0.082     0.200
    73.437     0.047     0.200
    73.796    -0.502     0.200
    74.647    -0.438     0.200
    74.769     0.254     0.200
    74.802     0.453     0.200
    75.191     0.095     0.200
    76.318    -0.157     0.200
    78.353    -0.499     0.200
    78.804     0.592     0.200
    79.964    -0.276     0.200
    88.280     0.540     0.200
    17.611     0.855     0.200
    17.924     0.732     0.200
    18.493     1.044     0.200
    18.542     2.668     0.200
    18.868     1.172     0.200
    18.969    -0.042     0.200
    19.642     1.080     0.200
    19.730     1.305     0.200
    20.602     0.559     0.200
    21.062     1.054     0.200
    17.922     1.017     0.200
    18.698     3.088     0.200
    19.401     1.651     0.200
    19.445     0.617     0.200
    19.566    -0.180     0.200
    19.638     1.182     0.200
    20.600    -0.045     0.200
    21.333    -0.006     0.200
    21.427    -0.357     0.200
    22.442     0.482     0.200
    36.939    -0.076     0.200
    37.613    -0.193     0.200
    20.448    -0.524     0.200
    22.291     0.049     0.200
    22.547    -1.170     0.200
    59.358    -0.156     0.200
    17.465     1.145     0.200
    17.781     1.717     0.200
    18.644    -0.427     0.200
    21.081     2.175     0.200
    21.189     1.157     0.200
    21.896     0.316     0.200
    21.957     1.358     0.200
    21.952     0.602     0.200
    22.301     0.786     0.200
    23.174    -2.087     0.200
    23.186    -2.659     0.200
    68.820    -1.131     0.200
    17.323     3.146     0.200
    17.571     0.363     0.200
    17.894     1.751     0.200
    18.150     0.906     0.200
    18.214     0.553     0.200
    20.200     1.710     0.200
    20.355     1.118     0.200
    20.468     1.663     0.200
    21.214     0.979     0.200
    21.294     0.502     0.200
    21.362     0.758     0.200
    21.453     1.470     0.200
    21.464     2.193     0.200
    22.314     0.456     0.200
    25.034     2.271     0.200
    25.901     2.714     0.200
    26.850     2.472     0.200
    28.826    -0.069     0.200
    34.044     2.255     0.200
    34.835    -0.025     0.200
    40.155    -1.355     0.200
    40.554     0.252     0.200
    40.587    -0.274     0.200
    40.780    -0.386     0.200
    41.714     0.672     0.200
    41.901     0.245     0.200
    59.343     0.104     0.200
    59.490     0.689     0.200
    60.455    -1.017     0.200
    60.455    -0.968     0.200
    62.523    -0.536     0.200
    64.224    -0.764     0.200
    64.864    -0.816     0.200
    64.967    -1.526     0.200
    67.698    -0.844     0.200
    67.761    -0.943     0.200
    68.743    -0.564     0.200
    69.392     0.039     0.200
    69.392    -0.222     0.200
    70.400     1.347     0.200
    73.424    -0.375     0.200
    73.781    -0.429     0.200
    78.365    -0.179     0.200
    79.924    -0.101     0.200
    17.894     2.401     0.200
    18.662     1.822     0.200
    20.612     1.430     0.200
    21.362     0.408     0.200
    21.294     1.162     0.200
    22.314     1.126     0.200
    22.821     2.091     0.200
    23.753    -0.159     0.200
    23.753     0.361     0.200
    23.717     1.563     0.200
    24.919     2.070     0.200
    25.475     1.786     0.200
    27.943     1.546     0.200
    28.389     0.701     0.200
    30.129     0.978     0.200
    30.639     0.910     0.200
    34.044     2.395     0.200
    34.835    -0.445     0.200
    34.878     0.923     0.200
    36.591     0.649     0.200
    36.645     2.203     0.200
    36.874     1.175     0.200
    36.819     1.243     0.200
    37.603    -0.541     0.200
    38.062    -0.221     0.200
    39.933     0.825     0.200
    40.155    -0.406     0.200
    40.780     0.684     0.200
    40.786     2.351     0.200
    41.052     2.422     0.200
    41.901     0.904     0.200
    42.141     0.547     0.200
    42.529     0.901     0.200
    49.936    -0.777     0.200
    50.769    -0.632     0.200
    51.906    -0.165     0.200
    52.703    -0.806     0.200
    53.490    -0.053     0.200
    53.564    -0.424     0.200
    54.208    -0.587     0.200
    54.842    -0.594     0.200
    56.574    -0.476     0.200
    56.657    -0.543     0.200
    57.033    -0.770     0.200
    57.187    -0.385     0.200
    58.040     2.363     0.200
    58.834    -0.951     0.200
    58.929    -0.736     0.200
    59.231     0.701     0.200
    59.665    -0.050     0.200
    59.824    -0.290     0.200
    60.845    -0.471     0.200
    61.308    -0.286     0.200
    63.380     0.271     0.200
    64.224    -0.264     0.200
    64.864    -0.926     0.200
    64.967    -0.716     0.200
    65.243    -0.044     0.200
    66.076    -0.621     0.200
    66.348    -0.282     0.200
    66.769     0.057     0.200
    66.914    -0.187     0.200
    67.095     0.304     0.200
    67.129    -0.013     0.200
    67.284     0.196     0.200
    67.344     0.225     0.200
    67.553     0.402     0.200
    67.572     0.238     0.200
    67.761    -1.043     0.200
    67.769     0.556     0.200
    67.866    -0.062     0.200
    67.960     0.741     0.200
    68.060     2.436     0.200
    68.101     0.225     0.200
    68.183     0.024     0.200
    68.263     0.323     0.200
    68.346    -0.022     0.200
    68.348     0.230     0.200
    68.364     0.266     0.200
    68.423    -0.169     0.200
    68.429     0.053     0.200
    68.438     0.225     0.200
    68.496     0.770     0.200
    68.496     0.200     0.200
    68.540     0.149     0.200
    68.537     0.034     0.200
    68.552     0.500     0.200
    68.625     0.443     0.200
    68.681    -0.085     0.200
    68.818     0.213     0.200
    68.826     0.088     0.200
    68.937     0.370     0.200
    68.968     0.087     0.200
    69.251    -0.030     0.200
    69.843     1.095     0.200
    70.137     0.626     0.200
    70.400     1.058     0.200
    70.409     0.460     0.200
    70.410     0.496     0.200
    70.425     0.632     0.200
    70.510     1.064     0.200
    70.622     1.225     0.200
    70.622     0.482     0.200
    70.682     0.326     0.200
    70.716     0.415     0.200
    70.785    -0.240     0.200
    71.050     0.068     0.200
    71.053     0.250     0.200
    71.233    -0.250     0.200
    71.256     0.090     0.200
    71.363     0.811     0.200
    71.493     0.718     0.200
    71.574     1.138     0.200
    71.729     1.382     0.200
    71.749     2.595     0.200
    72.136    -0.431     0.200
    72.164     1.458     0.200
    72.187    -0.117     0.200
    72.215    -1.110     0.200
    72.228     0.177     0.200
    72.446    -0.464     0.200
    72.585     0.619     0.200
    72.806     0.465     0.200
    72.867     1.000     0.200
    73.018     0.702     0.200
    73.060     1.008     0.200
    73.095     0.318     0.200
    73.095    -0.380     0.200
    73.257     0.617     0.200
    73.312    -0.289     0.200
    73.302     0.180     0.200
    73.327    -0.151     0.200
    73.368     0.160     0.200
    73.380     1.398     0.200
    73.424     0.625     0.200
    73.424     0.315     0.200
    73.425     0.404     0.200
    73.497    -0.215     0.200
    73.635     0.084     0.200
    73.711    -0.018     0.200
    73.728     0.598     0.200
    74.196     1.223     0.200
    74.204     0.823     0.200
    74.612     1.501     0.200
    74.690     0.205     0.200
    74.755     0.108     0.200
    75.184    -0.324     0.200
    75.177     0.410     0.200
    75.812     0.367     0.200
    75.827     0.173     0.200
    76.661     0.242     0.200
    77.020     1.025     0.200
    78.338    -0.040     0.200
    79.744     1.642     0.200
    80.517     0.908     0.200
    83.984     1.450     0.200
    86.128     0.396     0.200
    87.913     0.226     0.200
    87.976     0.418     0.200
    87.975     0.441     0.200
    91.187    -0.854     0.200
    91.549     1.577     0.200
    16.230     3.685     0.200
    17.699     2.390     0.200
    18.476     4.481     0.200
    20.723     1.900     0.200
    20.849     0.658     0.200
    20.995     1.889     0.200
    21.593     3.416     0.200
    22.124     1.247     0.200
    22.220     2.294     0.200
    22.410     2.033     0.200
    25.283     3.157     0.200
    25.283     3.077     0.200
    36.381     3.047     0.200
    37.959     0.172     0.200
    57.974    -1.225     0.200
    69.575    -0.911     0.200
    16.191     6.622     0.200
    21.272     0.596     0.200
    21.283     2.167     0.200
    25.112     1.714     0.200
    33.711    -0.637     0.200
    36.928     1.671     0.200
    39.508     1.615     0.200
    39.509     2.569     0.200
    49.782    -0.743     0.200
    57.851    -1.138     0.200
    59.241    -0.086     0.200
    59.241    -0.527     0.200
    59.411     1.009     0.200
    60.401    -1.052     0.200
    62.501    -0.944     0.200
    64.186    -0.391     0.200
    64.815    -1.523     0.200
    67.642    -0.795     0.200
    68.757    -1.481     0.200
    68.752    -1.336     0.200
    69.365    -0.086     0.200
    69.365     0.033     0.200
    71.482     0.135     0.200
    73.738     0.078     0.200
    74.710    -0.433     0.200
    76.259     0.237     0.200
    78.322    -0.713     0.200
    79.933     0.137     0.200
    79.942    -1.370     0.200
    25.104     0.923     0.200
    25.466     1.161     0.200
    25.964     2.833     0.200
    30.210     1.075     0.200
    34.092     1.880     0.200
    34.351     0.865     0.200
    34.581     0.213     0.200
    34.912     0.519     0.200
    35.514     0.751     0.200
    36.695     0.414     0.200
    36.930     0.749     0.200
    37.591     1.044     0.200
    37.928     0.614     0.200
    38.650     0.995     0.200
    38.896     0.429     0.200
    39.417     0.318     0.200
    39.471    -0.025     0.200
    39.474     1.595     0.200
    39.475     1.870     0.200
    40.013     1.286     0.200
    41.337    -0.099     0.200
    41.797     1.027     0.200
    43.504     0.160     0.200
    45.086     0.936     0.200
    49.796    -0.729     0.200
    57.865    -1.245     0.200
    59.491    -0.300     0.200
    60.431    -1.097     0.200
    60.431    -1.127     0.200
    62.524    -0.434     0.200
    64.213     0.059     0.200
    64.844    -1.846     0.200
    67.672    -1.161     0.200
    67.736    -1.182     0.200
    68.771    -1.135     0.200
    68.765    -1.220     0.200
    69.389    -0.064     0.200
    69.389    -0.095     0.200
    70.447     0.454     0.200
    71.494     0.163     0.200
    72.793     2.002     0.200
    73.765    -0.315     0.200
    73.818     0.154     0.200
    74.770     0.617     0.200
    76.287     0.265     0.200
    77.346     1.099     0.200
    78.349     0.522     0.200
    78.783     1.298     0.200
    79.948    -0.698     0.200
    15.356     3.230     0.200
    16.743     2.290     0.200
    17.713     0.852     0.200
    21.124    -0.486     0.200
    21.425     1.152     0.200
    22.424     1.403     0.200
    27.644     3.855     0.200
    22.200     0.760     0.200
    22.417     2.536     0.200
    22.479     0.787     0.200
    22.594     1.333     0.200
    22.602     2.470     0.200
    22.882     0.962     0.200
    22.908     2.424     0.200
    23.269     1.672     0.200
    23.671     0.138     0.200
    23.819     3.076     0.200
    24.206    -2.119     0.200
    24.212    -0.963     0.200
    25.121     0.806     0.200
    25.976     0.577     0.200
    26.955     3.329     0.200
    26.983     1.642     0.200
    28.864    -0.247     0.200
    30.995     0.914     0.200
    33.141     0.416     0.200
    33.307    -0.914     0.200
    33.461     1.471     0.200
    34.123     2.239     0.200
    34.615     0.214     0.200
    34.778    -0.659     0.200
    36.334     0.203     0.200
    36.710     0.899     0.200
    36.937     0.923     0.200
    39.764     0.893     0.200
    40.890     0.022     0.200
    41.165    -0.160     0.200
    41.584     0.604     0.200
    42.157     0.792     0.200
    42.199     0.438     0.200
    42.255    -0.583     0.200
    42.457     0.012     0.200
    43.359     0.050     0.200
    43.536    -0.318     0.200
    44.740     0.096     0.200
    46.216     2.124     0.200
    46.623     0.417     0.200
    48.452     0.542     0.200
    49.653    -0.849     0.200
    49.790    -0.978     0.200
    51.792    -1.073     0.200
    51.974    -0.660     0.200
    57.079     0.926     0.200
    57.860    -0.949     0.200
    59.153     0.347     0.200
    59.240    -0.063     0.200
    59.240     0.487     0.200
    60.351    -0.018     0.200
    60.406    -0.878     0.200
    60.406    -0.878     0.200
    62.508    -0.543     0.200
    62.929    -0.745     0.200
    63.589    -1.427     0.200
    64.193    -0.993     0.200
    64.820    -0.749     0.200
    67.647    -1.147     0.200
    67.711    -0.939     0.200
    68.473    -0.336     0.200
    68.596     0.206     0.200
    68.766    -0.995     0.200
    68.760    -0.749     0.200
    72.190     0.930     0.200
    73.282    -0.361     0.200
    73.381    -0.489     0.200
    75.830    -0.524     0.200
    76.024     0.141     0.200
    76.264     0.364     0.200
    77.178    -0.258     0.200
    77.334    -0.292     0.200
    78.327     0.013     0.200
    79.759     0.218     0.200
    18.260     0.820     0.200
    19.047     1.461     0.200
    19.489     0.751     0.200
    19.728     2.191     0.200
    21.383     0.556     0.200
    21.570     1.226     0.200
    23.091     2.255     0.200
    24.682     1.545     0.200
    25.084     1.879     0.200
    25.591     1.092     0.200
    25.934     3.458     0.200
    26.119     1.056     0.200
    26.700     1.238     0.200
    28.919     0.881     0.200
    29.363     1.538     0.200
    34.150     1.714     0.200
    43.159     1.187     0.200
    34.545     0.255     0.200
    36.916     0.743     0.200
    37.893     0.411     0.200
    41.764    -0.015     0.200
    43.166     0.013     0.200
    57.865    -1.221     0.200
    60.452    -1.950     0.200
    62.536    -1.612     0.200
    64.863    -1.156     0.200
    68.766    -1.484     0.200
    68.772    -1.270     0.200
    69.403    -1.069     0.200
    69.403    -1.839     0.200
    70.438     0.704     0.200
    70.463     0.121     0.200
    71.492    -0.253     0.200
    73.783    -0.488     0.200
    16.218     1.814     0.200
    22.406     2.313     0.200
    25.279     2.360     0.200
    36.940     0.413     0.200
    57.969    -1.065     0.200
    69.573    -0.856     0.200
    69.573    -1.118     0.200
    16.476     3.070     0.200
    21.235     3.028     0.200
    36.922     0.187     0.200
    39.468     1.791     0.200
    39.469     1.665     0.200
    40.847    -0.078     0.200
    57.861    -1.197     0.200
    60.432    -1.231     0.200
    60.432    -1.231     0.200
    64.845    -1.046     0.200
    67.674    -0.644     0.200
    68.767    -0.891     0.200
    68.761    -0.984     0.200
    69.389    -0.091     0.200
    69.389    -0.091     0.200
    70.465     0.040     0.200
    71.489    -0.880     0.200
    73.766    -0.160     0.200
    19.680     2.350     0.200
    20.422     2.991     0.200
    21.109     1.335     0.200
    21.252     2.234     0.200
    21.696     0.973     0.200
    25.540     2.046     0.200
    25.974     2.184     0.200
    36.900     1.096     0.200
    37.914     0.646     0.200
    38.886     1.482     0.200
    39.481     1.489     0.200
    40.657     0.602     0.200
    41.779     0.984     0.200
    57.836    -1.268     0.200
    60.413    -1.401     0.200
    60.413    -1.401     0.200
    67.655    -1.262     0.200
    67.718    -1.264     0.200
    68.743    -1.262     0.200
    69.366    -0.532     0.200
    69.366    -0.661     0.200
    70.417     0.861     0.200
    71.465     0.074     0.200
    73.745    -0.800     0.200
    77.320    -0.062     0.200
    79.920    -0.137     0.200
    18.696    -0.184     0.200
    20.974     0.043     0.200
    21.042     0.527     0.200
    21.408     0.364     0.200
    21.675     0.197     0.200
    22.483     1.077     0.200
    22.674     0.641     0.200
    25.103     1.624     0.200
    27.778    -0.629     0.200
    32.508     0.249     0.200
    33.735    -0.626     0.200
    34.589     0.096     0.200
    36.693    -0.308     0.200
    36.925     0.479     0.200
    37.934    -0.064     0.200
    16.146     2.045     0.200
    16.429     3.038     0.200
    17.791     3.529     0.200
    17.830     2.931     0.200
    17.887     2.093     0.200
    18.079    -0.274     0.200
    18.212     1.294     0.200
    18.509     2.293     0.200
    18.566     1.431     0.200
    18.842     0.835     0.200
    18.924     2.567     0.200
    18.974     0.982     0.200
    19.212     0.257     0.200
    19.378     2.401     0.200
    19.619     2.315     0.200
    19.700     1.034     0.200
    20.347     2.588     0.200
    20.558     0.813     0.200
    20.916     2.523     0.200
    20.979     1.230     0.200
    20.959     1.892     0.200
    21.044     2.562     0.200
    21.281     1.362     0.200
    21.330     1.456     0.200
    21.345     1.533     0.200
    21.328    -0.091     0.200
    21.464     1.357     0.200
    21.586     1.317     0.200
    21.621     2.364     0.200
    21.593     2.162     0.200
    21.632     1.006     0.200
    22.132     0.904     0.200
    22.305     1.632     0.200
    22.391     1.921     0.200
    22.599     1.339     0.200
    22.756    -0.090     0.200
    22.777     2.125     0.200
    22.958    -0.449     0.200
    22.999     2.680     0.200
    23.129     1.422     0.200
    23.090     0.415     0.200
    23.424     2.180     0.200
    23.934     1.679     0.200
    23.962     3.011     0.200
    24.135     2.195     0.200
    25.467     2.341     0.200
    25.923     1.919     0.200
    25.968     1.159     0.200
    26.044     0.537     0.200
    26.837     2.543     0.200
    27.807     1.397     0.200
    27.945     1.241     0.200
    31.488     1.434     0.200
    33.834    -1.255     0.200
    34.043     3.091     0.200
    34.484    -0.030     0.200
    34.745     1.000     0.200
    36.037     0.620     0.200
    36.545     0.488     0.200
    36.910     1.270     0.200
    37.585     0.587     0.200
    37.779     2.222     0.200
    37.819     1.370     0.200
    37.819     1.169     0.200
    38.034     0.292     0.200
    38.083     1.263     0.200
    38.312     1.531     0.200
    38.566     1.442     0.200
    38.909     1.922     0.200
    39.293     1.515     0.200
    39.413     1.165     0.200
    40.661     0.667     0.200
    40.761     1.334     0.200
    40.794     2.582     0.200
    40.915     1.024     0.200
    41.030     1.341     0.200
    41.232     1.523     0.200
    41.515     2.049     0.200
    41.534     1.975     0.200
    41.576     0.969     0.200
    41.621     0.650     0.200
    41.929     1.567     0.200
    41.959     1.523     0.200
    42.586     2.062     0.200
    42.907     0.997     0.200
    43.027    -0.325     0.200
    43.027     0.517     0.200
    43.395     1.588     0.200
    43.515     1.848     0.200
    44.171     1.584     0.200
    44.709     1.546     0.200
    44.988     0.077     0.200
    45.357    -0.484     0.200
    45.435     0.046     0.200
    46.009     0.206     0.200
    49.742    -0.830     0.200
    52.087     0.070     0.200
    53.974     1.201     0.200
    55.247    -0.603     0.200
    57.809    -1.397     0.200
    59.231    -0.244     0.200
    60.445    -1.521     0.200
    60.445    -1.521     0.200
    64.852    -1.021     0.200
    66.432    -0.507     0.200
    67.739     0.476     0.200
    68.716    -1.462     0.200
    69.374    -0.550     0.200
    69.374    -0.999     0.200
    70.368     0.595     0.200
    70.393     0.497     0.200
    70.840     0.521     0.200
    71.132    -0.503     0.200
    71.433    -0.234     0.200
    16.229     3.060     0.200
    17.122     2.956     0.200
    17.698     1.485     0.200
    18.743     0.993     0.200
    19.505     0.932     0.200
    20.162     1.625     0.200
    20.265     1.382     0.200
    20.377     0.830     0.200
    20.411     1.980     0.200
    20.722     1.672     0.200
    20.848     1.567     0.200
    21.011     1.368     0.200
    21.143     0.588     0.200
    21.262     1.589     0.200
    21.426     1.281     0.200
    21.411     0.890     0.200
    21.435     0.771     0.200
    21.787     0.775     0.200
    21.872     0.802     0.200
    21.895     0.287     0.200
    21.996     1.328     0.200
    22.219     0.766     0.200
    22.409     1.143     0.200
    22.475     1.767     0.200
    22.592     0.945     0.200
    22.622     1.802     0.200
    23.233     1.005     0.200
    23.528     1.463     0.200
    23.949     1.028     0.200
    25.282     1.920     0.200
    25.282     1.701     0.200
    27.740     1.169     0.200
    27.855     1.772     0.200
    28.116     1.377     0.200
    28.217     1.035     0.200
    37.252     0.439     0.200
    37.725    -0.361     0.200
    37.956    -0.075     0.200
    39.269     0.068     0.200
    39.221     1.559     0.200
    41.307    -0.053     0.200
    41.623     1.038     0.200
    42.968     0.415     0.200
    45.230     0.106     0.200
    45.874     0.306     0.200
    49.907    -1.094     0.200
    60.653    -0.498     0.200
    62.700    -0.642     0.200
    20.968     1.054     0.200
    21.019     0.895     0.200
    21.388     0.268     0.200
    21.388     0.525     0.200
    21.682     0.600     0.200
    25.072     2.057     0.200
    36.900     0.633     0.200
    37.902    -0.374     0.200
    39.547     1.050     0.200
    41.347     0.688     0.200
    43.198     0.505     0.200
    43.520     0.275     0.200
    44.255     0.144     0.200
    49.773    -0.702     0.200
    57.841    -1.181     0.200
    60.425    -0.889     0.200
    64.836    -0.783     0.200
    67.667    -0.453     0.200
    68.748    -1.119     0.200
    70.418     0.578     0.200
    20.968     2.183     0.200
    23.041     1.155     0.200
    24.666     0.178     0.200
    26.086    -0.242     0.200
    26.893     1.573     0.200
    29.309     0.545     0.200
    29.553     0.829     0.200
    30.020     0.223     0.200
    34.091     1.439     0.200
    42.060     0.609     0.200
    59.184     0.411     0.200
    57.904    -1.073     0.200
    59.329    -1.141     0.200
    59.588     0.428     0.200
    60.552    -1.344     0.200
    60.552    -1.453     0.200
    64.317    -1.013     0.200
    67.795    -0.771     0.200
    67.858    -0.091     0.200
    68.806    -0.545     0.200
    68.811     0.091     0.200
    68.903    -0.176     0.200
    69.095     0.150     0.200
    69.481    -0.333     0.200
    69.481    -0.563     0.200
    73.875    -0.878     0.200
    17.476     0.499     0.200
    18.835     0.231     0.200
    19.315     1.493     0.200
    20.125    -0.434     0.200
    20.469     0.810     0.200
    21.108     0.628     0.200
    21.237    -0.059     0.200
    33.357     0.345     0.200
    33.939     0.686     0.200
    34.423     0.026     0.200
    34.941    -0.569     0.200
    40.260    -2.123     0.200
    42.957     0.202     0.200
    43.047     0.243     0.200
    44.929     0.204     0.200
    59.336    -0.662     0.200
    59.596    -1.289     0.200
    60.559    -1.116     0.200
    60.559    -1.335     0.200
    62.616    -0.874     0.200
    64.324    -0.601     0.200
    64.716    -0.278     0.200
    64.967    -1.145     0.200
    68.810    -1.053     0.200
    68.816    -0.738     0.200
    69.487    -0.663     0.200
    69.487    -1.234     0.200
    70.684     0.287     0.200
    73.882    -1.125     0.200
    78.466    -0.546     0.200
    15.925     3.091     0.200
    17.793     1.688     0.200
    18.565     4.334     0.200
    20.255     1.459     0.200
    20.508     1.277     0.200
    21.200     0.619     0.200
    21.397    -0.215     0.200
    22.215     0.521     0.200
    22.718     1.411     0.200
    23.858    -0.003     0.200
    23.858     0.587     0.200
    24.814     2.271     0.200
    25.044     2.507     0.200
    30.058     1.125     0.200
    30.821     4.370     0.200
    30.821     3.120     0.200
    30.992    -0.837     0.200
    33.269     2.173     0.200
    33.502    -0.867     0.200
    33.939     1.655     0.200
    38.118    -0.892     0.200
    40.260     0.729     0.200
    49.277     2.534     0.200
    55.099     4.145     0.200
    57.737     1.721     0.200
    58.972     0.589     0.200
    59.336     2.166     0.200
    60.101     0.299     0.200
    61.955     1.303     0.200
    62.616     0.571     0.200
    63.806    -0.224     0.200
    64.324     1.274     0.200
    64.716     0.168     0.200
    64.716     0.707     0.200
    67.802    -1.490     0.200
    68.161     1.254     0.200
    68.209     1.338     0.200
    68.557     1.534     0.200
    68.816    -0.425     0.200
    68.905     0.609     0.200
    70.473     3.130     0.200
    70.565     1.194     0.200
    71.423     2.023     0.200
    73.389     0.822     0.200
    73.527     0.918     0.200
    73.527     0.145     0.200
    75.915     0.237     0.200
    77.313     2.464     0.200
    78.439     2.126     0.200
    84.090     1.451     0.200
    88.401     0.264     0.200
    18.976     0.805     0.200
    19.535     0.521     0.200
    19.576     0.348     0.200
    19.646     0.649     0.200
    20.343     2.014     0.200
    20.543    -0.488     0.200
    20.996     0.164     0.200
    21.065     0.114     0.200
    22.356     0.286     0.200
    23.727    -0.743     0.200
    26.284    -0.593     0.200
    26.902     0.033     0.200
    28.888    -1.178     0.200
    29.327     1.519     0.200
    30.940     0.010     0.200
    33.405    -0.205     0.200
    34.067     0.159     0.200
    34.832    -1.227     0.200
    36.710     0.343     0.200
    36.949     0.013     0.200
    37.662    -0.285     0.200
    40.132    -0.889     0.200
    40.657    -0.331     0.200
    40.841    -0.309     0.200
    41.360    -0.338     0.200
    41.529     0.624     0.200
    41.795    -0.379     0.200
    42.214    -0.711     0.200
    42.353     0.110     0.200
    42.441     0.043     0.200
    42.725    -0.317     0.200
    43.325     0.212     0.200
    43.510    -0.527     0.200
    44.281     0.091     0.200
    59.209    -0.453     0.200
    59.511    -0.329     0.200
    62.552    -0.780     0.200
    64.242    -0.855     0.200
    64.872    -1.195     0.200
    67.693    -0.628     0.200
    67.764    -1.296     0.200
    68.797    -1.070     0.200
    72.140     0.507     0.200
    73.433    -0.486     0.200
    73.849    -0.198     0.200
    75.869    -0.453     0.200
    75.971     0.552     0.200
    76.097     0.010     0.200
    77.044     0.227     0.200
    77.228    -0.851     0.200
    79.791    -0.713     0.200
    87.707    -0.469     0.200
    14.219     8.994     0.200
    16.082     5.432     0.200
    17.931     2.992     0.200
    18.708     0.689     0.200
    20.395     2.331     0.200
    20.640     1.743     0.200
    21.344     1.357     0.200
    21.344     0.927     0.200
    22.356     1.747     0.200
    22.356     1.107     0.200
    22.853     1.743     0.200
    23.727    -0.079     0.200
    23.727    -0.227     0.200
    24.865     3.419     0.200
    24.944     2.305     0.200
    25.117     1.190     0.200
    25.515     1.826     0.200
    25.980     0.907     0.200
    26.342     0.983     0.200
    26.516     0.804     0.200
    26.516    -0.118     0.200
    26.902     1.728     0.200
    26.902     1.252     0.200
    27.960     1.968     0.200
    28.464     0.654     0.200
    28.513     1.874     0.200
    28.888     0.221     0.200
    29.327     0.730     0.200
    30.200     0.876     0.200
    30.622     2.290     0.200
    30.699     0.547     0.200
    30.940     1.674     0.200
    30.942     2.194     0.200
    30.983     2.069     0.200
    31.914     1.062     0.200
    33.195    -0.006     0.200
    33.405     1.928     0.200
    33.405     2.647     0.200
    33.405     2.404     0.200
    33.633     1.381     0.200
    34.067     2.370     0.200
    34.067     2.706     0.200
    34.287     0.742     0.200
    34.832    -0.539     0.200
    34.937     0.800     0.200
    34.915     0.366     0.200
    36.710     1.304     0.200
    36.710     1.624     0.200
    36.677     2.039     0.200
    36.866     1.166     0.200
    36.949     1.560     0.200
    37.594     1.017     0.200
    37.594     0.892     0.200
    37.662     0.082     0.200
    38.127     0.133     0.200
    39.400     0.463     0.200
    39.794     1.965     0.200
    39.794     1.746     0.200
    40.003     0.263     0.200
    40.132    -0.546     0.200
    40.132    -1.139     0.200
    40.813     2.646     0.200
    40.813     2.747     0.200
    40.841     0.816     0.200
    41.299     0.549     0.200
    41.660    -0.270     0.200
    41.976     1.198     0.200
    42.211     2.374     0.200
    42.435     2.408     0.200
    44.996     0.015     0.200
    45.147     1.010     0.200
    45.605     1.334     0.200
    45.761     2.568     0.200
    48.286    -0.382     0.200
    49.146     0.807     0.200
    49.992    -0.018     0.200
    50.823    -0.043     0.200
    51.958     0.386     0.200
    53.541     0.600     0.200
    54.033     0.894     0.200
    54.033     1.004     0.200
    54.262    -1.013     0.200
    54.896    -0.975     0.200
    56.052     2.256     0.200
    57.967     0.824     0.200
    58.199     0.759     0.200
    58.719     0.996     0.200
    58.887    -1.263     0.200
    59.209     0.617     0.200
    59.511     1.819     0.200
    59.511     1.163     0.200
    59.579     0.811     0.200
    59.741     0.396     0.200
    59.878    -0.264     0.200
    59.957     2.943     0.200
    59.908     1.975     0.200
    60.169     0.552     0.200
    60.404     0.078     0.200
    60.459    -1.042     0.200
    60.899    -1.162     0.200
    61.752     0.856     0.200
    62.043     0.525     0.200
    62.043     0.337     0.200
    62.552    -0.632     0.200
    63.618     1.673     0.200
    64.242    -0.652     0.200
    64.872    -0.906     0.200
    65.024    -0.919     0.200
    65.097     2.174     0.200
    65.473     0.275     0.200
    65.705     1.873     0.200
    65.867     1.921     0.200
    66.136     2.266     0.200
    66.146     1.674     0.200
    66.316     1.262     0.200
    66.396     2.457     0.200
    66.835     0.059     0.200
    66.979    -0.301     0.200
    67.160     0.534     0.200
    67.347     0.466     0.200
    67.563     0.107     0.200
    67.616     0.278     0.200
    67.636    -0.205     0.200
    67.700    -0.590     0.200
    67.693     2.326     0.200
    67.832    -0.009     0.200
    67.930     0.626     0.200
    68.023     0.202     0.200
    68.164     0.154     0.200
    68.245     0.216     0.200
    68.326     0.092     0.200
    68.378     1.064     0.200
    68.378     1.244     0.200
    68.407    -0.096     0.200
    68.412     0.098     0.200
    68.427     0.577     0.200
    68.494     0.469     0.200
    68.500     0.117     0.200
    68.515     2.021     0.200
    68.528     1.686     0.200
    68.559     0.715     0.200
    68.559    -0.113     0.200
    68.602     0.262     0.200
    68.618     0.628     0.200
    68.688     0.517     0.200
    68.745    -0.121     0.200
    68.797    -0.937     0.200
    68.797    -0.781     0.200
    68.880     0.700     0.200
    68.889     0.375     0.200
    68.915     0.503     0.200
    68.926     2.846     0.200
    68.977    -0.617     0.200
    68.999     0.632     0.200
    69.033     0.181     0.200
    69.065     1.278     0.200
    69.102     1.760     0.200
    69.178     2.104     0.200
    69.310    -0.310     0.200
    69.442    -0.063     0.200
    69.810    -1.475     0.200
    69.954     0.887     0.200
    69.971     0.383     0.200
    70.134     2.095     0.200
    70.398     0.582     0.200
    70.420     4.038     0.200
    70.469     1.237     0.200
    70.469    -0.661     0.200
    70.468     1.266     0.200
    70.493     1.372     0.200
    70.621     2.017     0.200
    70.683     1.340     0.200
    70.683     0.324     0.200
    70.746     0.033     0.200
    70.776     1.073     0.200
    70.776     0.050     0.200
    70.842    -0.580     0.200
    71.034     2.204     0.200
    71.113     0.954     0.200
    71.119     0.707     0.200
    71.173    -1.520     0.200
    71.230     0.239     0.200
    71.287    -0.634     0.200
    71.276     2.156     0.200
    71.326     0.638     0.200
    71.321     0.006     0.200
    71.426     0.630     0.200
    71.443     1.326     0.200
    71.550     0.781     0.200
    71.631     0.984     0.200
    71.637     3.558     0.200
    71.967     1.234     0.200
    72.009    -0.213     0.200
    72.143     0.092     0.200
    72.199    -0.571     0.200
    72.199    -0.907     0.200
    72.221     1.444     0.200
    72.140     0.757     0.200
    72.140     0.991     0.200
    72.221     1.469     0.200
    72.250    -0.191     0.200
    72.274     0.672     0.200
    72.287     3.660     0.200
    72.502    -0.630     0.200
    72.512     0.533     0.200
    72.769    -0.620     0.200
    72.893     0.630     0.200
    72.931     1.350     0.200
    73.035     2.833     0.200
    73.078     0.042     0.200
    73.155     0.004     0.200
    73.316     0.945     0.200
    73.358     0.666     0.200
    73.389    -0.367     0.200
    73.433     0.139     0.200
    73.424     0.661     0.200
    73.425     1.225     0.200
    73.436     1.650     0.200
    73.556    -0.563     0.200
    73.590     1.240     0.200
    73.693     1.055     0.200
    73.693     0.555     0.200
    73.722     0.727     0.200
    73.722     0.501     0.200
    73.787     0.378     0.200
    74.143     2.286     0.200
    74.213     1.310     0.200
    74.213     1.411     0.200
    74.254     0.183     0.200
    74.856     1.135     0.200
    75.869     1.109     0.200
    75.869    -0.250     0.200
    75.869     0.094     0.200
    75.998     2.401     0.200
    75.998     1.706     0.200
    75.971     2.692     0.200
    76.322    -0.899     0.200
    77.228     0.103     0.200
    77.581     1.357     0.200
    77.992     0.632     0.200
    78.351     0.454     0.200
    79.393     1.121     0.200
    79.691    -0.144     0.200
    79.786     2.026     0.200
    79.791     1.709     0.200
    79.791     0.920     0.200
    80.577     1.222     0.200
    83.455     2.322     0.200
    83.970     1.142     0.200
    87.882     0.102     0.200
    87.943     0.163     0.200
    87.943    -0.275     0.200
    87.942    -0.247     0.200
    88.426     2.077     0.200
    91.244    -0.466     0.200
    91.244    -0.732     0.200
    93.845     2.686     0.200
    34.588    -1.305     0.200
    16.464     3.190     0.200
    16.967     1.849     0.200
    17.941     0.996     0.200
    18.721     4.146     0.200
    19.547     0.955     0.200
    19.652     0.785     0.200
    21.225     3.114     0.200
    25.144     0.801     0.200
    26.006     2.746     0.200
    26.618     1.345     0.200
    28.910     2.071     0.200
    33.521     1.480     0.200
    34.073     1.634     0.200
    36.974     0.243     0.200
    40.145     2.843     0.200
    41.349     1.098     0.200
    41.352     3.947     0.200
    41.549     0.398     0.200
    43.152     1.504     0.200
    59.204     0.381     0.200
    62.563    -0.828     0.200
    64.249    -1.462     0.200
    64.876    -1.181     0.200
    67.766    -1.612     0.200
    68.816    -1.586     0.200
    69.124    -0.931     0.200
    70.704     0.250     0.200
    71.539    -0.491     0.200
    73.437    -0.028     0.200
    75.884     1.149     0.200
    77.234    -1.081     0.200
    80.943     0.679     0.200
    87.874     0.149     0.200
    18.557     0.214     0.200
    18.759     0.605     0.200
    19.318     0.204     0.200
    19.360    -0.037     0.200
    19.362    -0.159     0.200
    19.412     0.448     0.200
    19.426     0.001     0.200
    20.695    -1.099     0.200
    21.490     0.348     0.200
    21.606     0.291     0.200
    22.724     1.406     0.200
    24.421    -1.090     0.200
    25.092     0.390     0.200
    25.986     0.468     0.200
    26.691     0.553     0.200
    26.713     0.144     0.200
    27.772     0.967     0.200
    28.975    -0.496     0.200
    30.724     0.316     0.200
    33.185     0.312     0.200
    33.847     0.400     0.200
    35.041    -0.771     0.200
    36.700    -0.165     0.200
    37.461    -0.117     0.200
    39.732    -0.255     0.200
    40.234    -0.229     0.200
    40.352    -1.232     0.200
    40.565     0.231     0.200
    40.643    -0.138     0.200
    41.080    -0.087     0.200
    41.310     0.451     0.200
    41.883     0.206     0.200
    42.022    -0.272     0.200
    42.043     0.193     0.200
    42.464    -0.566     0.200
    43.291     0.096     0.200
    43.773    -0.219     0.200
    44.583     1.054     0.200
    46.900     0.065     0.200
    49.804    -0.910     0.200
    51.956    -0.841     0.200
    55.370    -1.052     0.200
    57.921    -0.906     0.200
    59.429    -0.462     0.200
    59.555    -1.000     0.200
    62.720    -1.410     0.200
    63.722    -0.724     0.200
    64.429    -1.189     0.200
    65.071    -1.567     0.200
    66.518     0.067     0.200
    67.763    -0.568     0.200
    67.968    -0.663     0.200
    68.553    -0.817     0.200
    68.910    -1.068     0.200
    69.592    -0.452     0.200
    69.592    -0.792     0.200
    71.939     0.175     0.200
    73.631    -0.527     0.200
    73.865    -0.357     0.200
    75.882     0.180     0.200
    76.011    -0.865     0.200
    77.418    -1.104     0.200
    78.571    -0.491     0.200
    79.769    -0.727     0.200
    79.910    -0.754     0.200
    87.476    -0.263     0.200
    15.886     3.040     0.200
    15.886     2.582     0.200
    17.711     1.978     0.200
    18.243     0.590     0.200
    18.492     2.176     0.200
    20.177     2.475     0.200
    20.420     1.524     0.200
    21.132     1.638     0.200
    21.132     1.258     0.200
    21.467     0.213     0.200
    21.677     4.021     0.200
    22.138     1.009     0.200
    22.138     0.838     0.200
    22.632     1.395     0.200
    23.546     1.832     0.200
    23.948     0.375     0.200
    24.438     1.186     0.200
    24.646     1.571     0.200
    24.724     1.802     0.200
    25.092     0.890     0.200
    25.297     1.460     0.200
    26.122     1.289     0.200
    26.337     0.305     0.200
    26.337     1.045     0.200
    26.304     1.748     0.200
    26.691     1.673     0.200
    26.691     1.573     0.200
    27.742     1.647     0.200
    28.302     0.221     0.200
    28.295     1.914     0.200
    28.975    -0.687     0.200
    29.320     0.395     0.200
    29.428     2.289     0.200
    30.401     1.016     0.200
    30.500     0.569     0.200
    30.500     0.456     0.200
    30.724     1.986     0.200
    30.726     1.664     0.200
    30.724     1.606     0.200
    30.763     1.604     0.200
    31.074    -0.406     0.200
    31.189     1.840     0.200
    31.860     1.057     0.200
    33.185     2.088     0.200
    33.185     1.762     0.200
    33.413     0.022     0.200
    33.479     1.600     0.200
    33.560    -0.004     0.200
    33.847     2.592     0.200
    33.847     2.270     0.200
    34.080     0.953     0.200
    34.402     1.026     0.200
    34.829     0.735     0.200
    35.041    -0.051     0.200
    35.034     0.442     0.200
    35.249     2.595     0.200
    36.457     1.531     0.200
    36.700     1.625     0.200
    36.700     1.052     0.200
    36.700     0.885     0.200
    36.651     1.256     0.200
    36.984     1.111     0.200
    37.496     1.224     0.200
    37.461     0.329     0.200
    37.929     2.034     0.200
    38.202    -0.388     0.200
    38.369     1.130     0.200
    39.191     0.412     0.200
    39.732     0.605     0.200
    39.905     1.133     0.200
    39.905     1.343     0.200
    39.821     1.157     0.200
    39.887     1.752     0.200
    40.352    -0.572     0.200
    40.593     2.389     0.200
    40.643     0.501     0.200
    40.643     0.612     0.200
    40.730     0.973     0.200
    41.088     0.727     0.200
    41.012     1.272     0.200
    41.050     3.376     0.200
    41.300     0.032     0.200
    41.663    -0.438     0.200
    41.814     1.114     0.200
    41.981    -1.748     0.200
    42.022     3.089     0.200
    42.022     2.298     0.200
    42.022     2.688     0.200
    42.260     0.303     0.200
    42.312     1.553     0.200
    42.351     1.061     0.200
    42.404     0.900     0.200
    43.423     1.037     0.200
    43.773     1.011     0.200
    44.952     1.308     0.200
    45.204    -0.400     0.200
    45.204    -0.550     0.200
    45.505     1.115     0.200
    45.505     0.897     0.200
    45.541     2.596     0.200
    46.058     0.921     0.200
    46.900     1.542     0.200
    46.900     2.275     0.200
    46.900     1.405     0.200
    46.810     1.327     0.200
    47.040    -0.421     0.200
    48.503    -0.270     0.200
    49.366     1.204     0.200
    49.804    -0.403     0.200
    50.100    -0.815     0.200
    50.935    -0.629     0.200
    51.930    -0.411     0.200
    51.956    -0.441     0.200
    52.075    -0.507     0.200
    52.871    -0.852     0.200
    53.662    -0.068     0.200
    53.735    -0.431     0.200
    53.819     1.261     0.200
    53.819     0.990     0.200
    53.990     0.438     0.200
    54.375    -0.819     0.200
    54.660    -1.251     0.200
    55.007    -0.637     0.200
    55.076     3.615     0.200
    55.370     0.401     0.200
    55.370     0.228     0.200
    55.606     2.435     0.200
    56.158    -0.882     0.200
    56.488    -0.435     0.200
    56.535    -1.138     0.200
    56.741    -0.505     0.200
    56.825    -0.858     0.200
    57.146     0.056     0.200
    57.164    -0.796     0.200
    57.197    -0.861     0.200
    57.352     0.801     0.200
    57.352     0.388     0.200
    57.352     1.188     0.200
    57.354    -0.426     0.200
    57.835     1.385     0.200
    57.921    -0.136     0.200
    58.028    -1.137     0.200
    58.028    -0.637     0.200
    58.071    -1.008     0.200
    57.899     1.703     0.200
    58.218     1.396     0.200
    58.247    -0.024     0.200
    58.368    -0.647     0.200
    58.581     0.964     0.200
    58.752     0.210     0.200
    59.001    -1.120     0.200
    59.072    -0.049     0.200
    59.098    -0.830     0.200
    59.093    -0.635     0.200
    59.429     0.778     0.200
    59.429     1.187     0.200
    59.429     1.078     0.200
    59.505     0.749     0.200
    59.550    -0.183     0.200
    59.550     0.267     0.200
    59.555     0.204     0.200
    59.555     0.310     0.200
    59.618     0.110     0.200
    59.723     1.063     0.200
    59.767    -0.204     0.200
    59.930    -0.376     0.200
    59.930    -0.106     0.200
    59.989    -0.440     0.200
    59.991    -0.105     0.200
    60.043     0.457     0.200
    60.204    -0.958     0.200
    60.207    -0.030     0.200
    60.247     0.056     0.200
    60.282     0.159     0.200
    60.364     1.157     0.200
    60.532    -0.342     0.200
    60.615     0.889     0.200
    60.615     0.772     0.200
    60.615     0.632     0.200
    60.662    -0.765     0.200
    60.662    -0.586     0.200
    60.555     3.741     0.200
    60.694    -0.255     0.200
    60.866    -0.005     0.200
    60.911     0.516     0.200
    61.011    -0.763     0.200
    61.011    -0.413     0.200
    61.139     0.051     0.200
    61.170    -0.343     0.200
    61.387     0.059     0.200
    61.468    -0.590     0.200
    61.659     0.247     0.200
    61.791     0.250     0.200
    61.837     0.062     0.200
    61.827     0.896     0.200
    61.827     0.477     0.200
    62.060     0.251     0.200
    62.163     0.458     0.200
    62.663     0.291     0.200
    62.720     0.644     0.200
    62.720    -0.270     0.200
    62.813    -0.126     0.200
    63.075    -0.088     0.200
    63.185    -0.189     0.200
    63.227     0.420     0.200
    63.518     0.490     0.200
    63.722     0.166     0.200
    63.908     0.460     0.200
    64.234    -1.081     0.200
    64.401     0.762     0.200
    64.429     0.233     0.200
    64.487    -0.599     0.200
    64.636     0.557     0.200
    64.784     0.787     0.200
    64.784     0.540     0.200
    64.816     0.563     0.200
    65.028    -0.873     0.200
    65.071    -0.411     0.200
    65.071    -0.687     0.200
    65.126    -1.005     0.200
    65.126    -0.715     0.200
    65.185     0.019     0.200
    65.216    -0.325     0.200
    65.316     0.178     0.200
    65.374     0.103     0.200
    65.415     0.145     0.200
    65.471     0.054     0.200
    65.544     0.695     0.200
    65.759     0.753     0.200
    65.763     0.288     0.200
    65.847     0.194     0.200
    65.925     0.313     0.200
    65.986     0.252     0.200
    66.042     0.269     0.200
    66.197     0.504     0.200
    66.202     0.246     0.200
    66.389     0.284     0.200
    66.465     0.129     0.200
    66.490    -0.110     0.200
    66.759     0.127     0.200
    66.854     0.942     0.200
    66.907     0.432     0.200
    67.024     0.069     0.200
    67.057    -0.038     0.200
    67.236     0.372     0.200
    67.269     0.288     0.200
    67.430     0.233     0.200
    67.487     0.353     0.200
    67.358     0.902     0.200
    67.645     0.422     0.200
    67.699     0.474     0.200
    67.711     0.361     0.200
    67.718     0.313     0.200
    67.762     0.537     0.200
    67.763     0.432     0.200
    67.821     0.494     0.200
    67.905    -0.884     0.200
    67.915     0.589     0.200
    67.920     0.278     0.200
    67.968    -0.763     0.200
    68.009     0.364     0.200
    68.107     0.705     0.200
    68.125     0.323     0.200
    68.128     0.897     0.200
    68.128    -0.574     0.200
    68.197     0.448     0.200
    68.248     0.519     0.200
    68.244     0.452     0.200
    68.290     0.378     0.200
    68.336     0.524     0.200
    68.331    -0.069     0.200
    68.371     0.517     0.200
    68.399     0.217     0.200
    68.401     0.362     0.200
    68.408     0.427     0.200
    68.436     0.427     0.200
    68.436     0.321     0.200
    68.486     0.092     0.200
    68.490     0.597     0.200
    68.499    -0.300     0.200
    68.499    -0.079     0.200
    68.512     0.400     0.200
    68.553     0.659     0.200
    68.553     0.553     0.200
    68.553     0.283     0.200
    68.568     0.537     0.200
    68.586     0.297     0.200
    68.584     0.155     0.200
    68.599     0.306     0.200
    68.644     0.181     0.200
    68.665     0.350     0.200
    68.658     0.218     0.200
    68.687     0.377     0.200
    68.693     0.677     0.200
    68.693     0.827     0.200
    68.773     0.238     0.200
    68.825     0.151     0.200
    68.910    -0.672     0.200
    68.910    -0.568     0.200
    68.965    -0.337     0.200
    68.972     0.340     0.200
    68.848     1.520     0.200
    68.848     1.293     0.200
    68.990     0.446     0.200
    69.002     0.325     0.200
    69.056    -0.115     0.200
    69.085     0.723     0.200
    69.110     0.542     0.200
    69.126     0.009     0.200
    69.184     0.219     0.200
    69.237     0.573     0.200
    69.246     0.616     0.200
    69.408     1.236     0.200
    69.408     0.356     0.200
    69.387    -0.123     0.200
    69.507     0.682     0.200
    69.845     0.666     0.200
    69.864     0.872     0.200
    69.972     0.967     0.200
    70.051    -0.667     0.200
    70.047     0.154     0.200
    70.131     1.470     0.200
    70.214     0.571     0.200
    70.290     0.818     0.200
    70.260     3.547     0.200
    70.501     0.915     0.200
    70.530     1.375     0.200
    70.555     0.484     0.200
    70.563     1.037     0.200
    70.563     0.297     0.200
    70.558     1.278     0.200
    70.649     0.873     0.200
    70.687     0.742     0.200
    70.695     0.472     0.200
    70.695     0.260     0.200
    70.773     0.636     0.200
    70.825     0.601     0.200
    70.872    -0.797     0.200
    70.926     0.918     0.200
    70.945    -0.207     0.200
    70.966     0.674     0.200
    71.002     0.354     0.200
    71.041     1.476     0.200
    71.089     0.644     0.200
    71.192     0.074     0.200
    71.196     0.655     0.200
    71.243    -0.526     0.200
    71.302    -0.257     0.200
    71.327     0.756     0.200
    71.397     0.284     0.200
    71.425     0.462     0.200
    71.428     1.415     0.200
    71.510     1.138     0.200
    71.537     1.515     0.200
    71.909    -0.661     0.200
    71.758    -0.295     0.200
    71.773     0.727     0.200
    71.842     0.057     0.200
    72.006     0.436     0.200
    71.939     1.473     0.200
    71.939     1.255     0.200
    72.150     0.370     0.200
    72.188     0.926     0.200
    72.175     1.504     0.200
    72.274     1.329     0.200
    72.284    -0.002     0.200
    72.334     0.319     0.200
    72.567     0.722     0.200
    72.570     1.222     0.200
    72.679     0.467     0.200
    72.875     0.192     0.200
    72.955     0.355     0.200
    73.009     0.587     0.200
    73.131    -0.348     0.200
    73.248     0.120     0.200
    73.457     0.590     0.200
    73.477     0.222     0.200
    73.519     0.415     0.200
    73.522     0.566     0.200
    73.542     0.058     0.200
    73.548     0.287     0.200
    73.631     0.342     0.200
    73.631     0.453     0.200
    73.654    -0.252     0.200
    73.729     0.069     0.200
    73.822     0.481     0.200
    73.865     1.048     0.200
    73.865     0.753     0.200
    74.148     1.357     0.200
    74.172     2.485     0.200
    74.240     0.921     0.200
    74.291     0.013     0.200
    74.321     0.304     0.200
    74.411     1.013     0.200
    74.734     0.858     0.200
    74.741     1.098     0.200
    74.765     0.622     0.200
    74.841     0.577     0.200
    74.858     0.485     0.200
    75.082     0.766     0.200
    75.248     1.301     0.200
    75.248     0.747     0.200
    75.383     1.119     0.200
    75.757     2.753     0.200
    76.011     0.537     0.200
    76.011     0.295     0.200
    76.019     0.773     0.200
    75.882     2.930     0.200
    76.083     0.356     0.200
    76.183     1.346     0.200
    76.235     0.803     0.200
    76.255     0.178     0.200
    76.314     1.394     0.200
    76.417     0.028     0.200
    76.455     0.751     0.200
    76.432     1.204     0.200
    76.550     0.813     0.200
    76.703     0.049     0.200
    76.957     1.402     0.200
    77.155     1.599     0.200
    77.226     1.240     0.200
    77.418     0.984     0.200
    77.418     0.525     0.200
    77.454     1.274     0.200
    77.454     0.774     0.200
    77.655     1.091     0.200
    77.922     0.313     0.200
    77.953    -0.071     0.200
    77.949    -1.047     0.200
    78.064    -1.567     0.200
    78.092     0.256     0.200
    78.284     0.954     0.200
    78.461     2.407     0.200
    78.506     1.049     0.200
    78.544     1.407     0.200
    78.571     0.978     0.200
    78.691     0.998     0.200
    78.743     0.603     0.200
    79.537     2.064     0.200
    79.680     0.778     0.200
    79.769     2.563     0.200
    79.769     2.905     0.200
    79.769     2.383     0.200
    79.826     1.863     0.200
    79.910     0.826     0.200
    80.095     0.395     0.200
    80.612     1.614     0.200
    80.737     0.245     0.200
    80.983     0.337     0.200
    81.603    -0.021     0.200
    81.766    -0.132     0.200
    82.382     1.023     0.200
    83.221    -0.756     0.200
    83.325     0.417     0.200
    84.133     0.002     0.200
    84.187     1.591     0.200
    84.826    -1.704     0.200
    86.315     0.302     0.200
    87.476     0.626     0.200
    87.476     0.317     0.200
    87.789     0.753     0.200
    88.102     0.322     0.200
    88.163     0.198     0.200
    88.163     0.535     0.200
    88.163     0.158     0.200
    88.485     0.915     0.200
    88.551     1.025     0.200
    88.592     0.888     0.200
    89.353     0.634     0.200
    89.353     0.459     0.200
    90.170     1.272     0.200
    90.170     1.021     0.200
    91.041     0.509     0.200
    91.041     0.330     0.200
    91.227     0.632     0.200
    92.378     1.147     0.200
    96.274     0.585     0.200
    98.945     0.597     0.200
    34.587     1.888     0.200
    22.240     1.319     0.200
    25.508     0.208     0.200
    18.712    -1.321     0.200
    21.428     0.965     0.200
    22.407    -0.737     0.200
    25.567     2.242     0.200
    39.504     2.093     0.200
    39.504     2.330     0.200
    57.861    -0.864     0.200
    59.156    -0.237     0.200
    59.416    -0.277     0.200
    60.409    -1.301     0.200
    60.409    -0.731     0.200
    62.510    -0.412     0.200
    64.823    -0.660     0.200
    68.767    -0.275     0.200
    71.492     1.026     0.200
    36.899     0.860     0.200
    57.844    -1.115     0.200
    67.739    -0.843     0.200
    69.382    -0.266     0.200
    69.382    -0.265     0.200
    21.928     0.151     0.200
    57.942    -1.070     0.200
    67.845    -0.871     0.200
    67.858     0.116     0.200
    69.528    -0.794     0.200
    69.528    -0.564     0.200
    17.987     1.304     0.200
    20.447     2.752     0.200
    20.563     1.131     0.200
    21.338     1.157     0.200
    25.887     1.811     0.200
    17.987     2.367     0.200
    18.752     3.904     0.200
    20.707     1.297     0.200
    21.338     1.036     0.200
    21.381     0.558     0.200
    22.915     1.418     0.200
    23.658    -0.137     0.200
    25.014     2.407     0.200
    26.938     4.201     0.200
    28.038     1.600     0.200
    28.779     0.948     0.200
    30.796    -1.022     0.200
    33.465     3.083     0.200
    34.139     2.323     0.200
    34.741    -0.431     0.200
    36.848     1.172     0.200
    38.019    -0.835     0.200
    39.433     0.411     0.200
    40.881     1.898     0.200
    42.605     0.670     0.200
    44.964    -0.613     0.200
    45.657    -0.310     0.200
    48.237    -0.986     0.200
    53.198    -0.515     0.200
    56.595    -0.490     0.200
    58.772    -0.629     0.200
    59.136     1.243     0.200
    59.136     1.013     0.200
    60.182     2.607     0.200
    60.363    -1.108     0.200
    62.443    -0.782     0.200
    63.608    -0.025     0.200
    64.138     0.185     0.200
    64.774    -0.276     0.200
    64.774    -1.413     0.200
    64.913     0.429     0.200
    67.946     0.005     0.200
    68.685    -1.026     0.200
    70.468     0.485     0.200
    70.730    -0.526     0.200
    71.213    -0.225     0.200
    75.088    -1.623     0.200
    83.889     1.185     0.200
    88.204     0.987     0.200
    21.348    -0.463     0.200
    21.430    -0.402     0.200
    22.698    -0.375     0.200
    25.044    -0.475     0.200
    25.516     0.627     0.200
    25.897     0.668     0.200
    16.599     1.481     0.200
    16.990     1.311     0.200
    17.386     0.698     0.200
    17.689     1.016     0.200
    17.860     1.094     0.200
    17.958     0.882     0.200
    18.213     0.664     0.200
    18.277     1.313     0.200
    18.631     1.001     0.200
    18.727     0.707     0.200
    18.908     0.176     0.200
    18.998     0.883     0.200
    19.281     0.874     0.200
    19.443     1.414     0.200
    19.480     0.762     0.200
    19.559     0.942     0.200
    19.594     0.435     0.200
    19.683     0.682     0.200
    20.265     0.667     0.200
    20.291     1.378     0.200
    20.420     0.739     0.200
    20.529     0.721     0.200
    20.632     0.483     0.200
    20.985     0.331     0.200
    21.272     1.760     0.200
    21.368    -0.046     0.200
    21.358     0.858     0.200
    22.040     0.932     0.200
    22.818    -0.457     0.200
    25.056     1.164     0.200
    25.914     1.480     0.200
    26.915     1.423     0.200
    31.271     0.263     0.200
    31.402     0.607     0.200
    32.047    -0.574     0.200
    33.435     0.736     0.200
    34.106     1.924     0.200
    36.879     2.378     0.200
    40.093     1.059     0.200
    40.076     1.062     0.200
    40.089     0.616     0.200
    40.843     0.225     0.200
    41.704    -0.482     0.200
    41.764     0.467     0.200
    41.868     0.176     0.200
    42.012    -0.393     0.200
    17.958     2.460     0.200
    18.727     1.258     0.200
    20.420     1.829     0.200
    20.675     1.713     0.200
    21.368     0.435     0.200
    21.358     1.030     0.200
    22.379     0.425     0.200
    22.884     1.256     0.200
    23.690     0.091     0.200
    23.781     1.451     0.200
    24.892     3.301     0.200
    25.056     1.016     0.200
    24.981     1.966     0.200
    25.540     1.382     0.200
    26.376     4.178     0.200
    26.505    -1.093     0.200
    28.003     1.650     0.200
    28.445     0.531     0.200
    28.815     0.546     0.200
    30.189     1.145     0.200
    30.825    -0.761     0.200
    30.986     2.520     0.200
    31.020     2.198     0.200
    31.859     0.760     0.200
    33.435     2.532     0.200
    33.435     1.693     0.200
    33.610     1.039     0.200
    33.632     0.817     0.200
    34.106     2.674     0.200
    34.868     0.428     0.200
    36.708     2.121     0.200
    36.879     0.867     0.200
    36.884     1.263     0.200
    37.551     1.099     0.200
    38.054    -0.653     0.200
    39.411     0.375     0.200
    40.076     1.163     0.200
    40.093     2.031     0.200
    40.093     1.918     0.200
    40.843     0.444     0.200
    40.849     2.665     0.200
    41.957     0.858     0.200
    42.591     0.792     0.200
    45.147     0.670     0.200
    44.985     0.146     0.200
    45.795     2.704     0.200
    48.264     0.640     0.200
    53.468     2.205     0.200
    58.128     0.051     0.200
    58.813    -1.174     0.200
    58.809    -0.952     0.200
    59.169     2.546     0.200
    59.169     1.847     0.200
    59.169     1.034     0.200
    59.169     1.245     0.200
    59.440     2.141     0.200
    59.672    -0.539     0.200
    59.804    -0.039     0.200
    59.946     1.088     0.200
    60.402    -0.139     0.200
    60.826     0.069     0.200
    60.826    -0.669     0.200
    60.946     1.952     0.200
    63.646     1.062     0.200
    64.813    -0.471     0.200
    66.074    -0.454     0.200
    66.623     1.599     0.200
    67.122     0.250     0.200
    67.759     0.427     0.200
    67.950     0.903     0.200
    68.091    -0.033     0.200
    68.172     0.048     0.200
    68.253     0.111     0.200
    68.544     0.523     0.200
    68.723    -0.845     0.200
    68.993    -1.023     0.200
    70.061     0.494     0.200
    70.124     0.425     0.200
    70.324     3.581     0.200
    70.324     0.178     0.200
    70.396     0.709     0.200
    70.396     2.942     0.200
    70.396     2.442     0.200
    70.423     2.974     0.200
    70.503     0.474     0.200
    70.609     1.527     0.200
    70.609     0.804     0.200
    70.609     0.433     0.200
    70.673     0.687     0.200
    70.673     1.249     0.200
    70.702     0.022     0.200
    70.702     0.170     0.200
    70.768     0.170     0.200
    70.768    -0.412     0.200
    70.961     2.096     0.200
    71.046     2.540     0.200
    71.214     0.808     0.200
    71.248     0.034     0.200
    71.248    -0.243     0.200
    71.476     1.281     0.200
    71.558     0.791     0.200
    71.612    -0.237     0.200
    72.043    -0.034     0.200
    72.149     1.332     0.200
    72.201     0.637     0.200
    72.144     0.653     0.200
    72.440     0.610     0.200
    72.695     3.361     0.200
    73.082     0.702     0.200
    73.082     0.479     0.200
    73.082     0.280     0.200
    73.374    -1.560     0.200
    73.343     0.976     0.200
    73.343    -0.692     0.200
    73.350     0.521     0.200
    73.351     1.128     0.200
    73.432     2.109     0.200
    73.432     0.852     0.200
    73.432     0.109     0.200
    73.482    -0.387     0.200
    73.619     0.621     0.200
    73.619    -1.082     0.200
    73.648     1.270     0.200
    73.648     0.946     0.200
    73.713     1.139     0.200
    74.139     1.103     0.200
    74.153     2.717     0.200
    74.480     1.023     0.200
    74.604     0.111     0.200
    74.678     0.326     0.200
    75.202     0.695     0.200
    75.170     0.297     0.200
    75.925     0.211     0.200
    76.020    -0.089     0.200
    76.488     2.846     0.200
    76.970     3.015     0.200
    77.165     2.928     0.200
    77.508     1.168     0.200
    77.807    -0.018     0.200
    77.918     0.640     0.200
    78.289     3.910     0.200
    78.532     0.800     0.200
    83.924     1.505     0.200
    88.234     0.792     0.200
    21.416     0.321     0.200
    60.437    -0.544     0.200
    60.437    -0.771     0.200
    67.679    -0.009     0.200
    67.742     0.332     0.200
    69.394     0.124     0.200
    69.394     0.241     0.200
    73.771     0.372     0.200
    16.139     1.910     0.200
    20.558    -2.495     0.200
    21.409    -0.254     0.200
    22.456     0.960     0.200
    22.647     0.671     0.200
    22.834     0.734     0.200
    25.091    -0.185     0.200
    25.519     1.543     0.200
    25.953     1.544     0.200
    17.350     2.866     0.200
    17.811     1.389     0.200
    17.912     1.442     0.200
    18.687     1.184     0.200
    18.855     0.880     0.200
    19.704     1.000     0.200
    20.232     0.754     0.200
    20.324     0.104     0.200
    20.375     0.681     0.200
    20.472     1.128     0.200
    20.934     1.385     0.200
    20.991     0.326     0.200
    21.323     0.311     0.200
    21.426    -0.781     0.200
    21.999     0.836     0.200
    22.336     0.905     0.200
    22.405     1.164     0.200
    22.622     1.416     0.200
    22.830     1.479     0.200
    34.329   -92.124     0.200
    24.927     1.384     0.200
    25.102     1.692     0.200
    25.155     0.222     0.200
    25.495     1.323     0.200
    25.920     0.988     0.200
    25.967     0.631     0.200
    26.881     1.894     0.200
    28.961     1.024     0.200
    34.050     1.661     0.200
    39.433     1.036     0.200
    59.226     0.873     0.200
    59.314     1.111     0.200
    60.470     0.133     0.200
    64.250    -0.837     0.200
    64.882    -0.313     0.200
    68.795    -1.314     0.200
    68.789    -0.587     0.200
    69.424    -0.560     0.200
    69.424     0.381     0.200
    71.516     0.908     0.200
    73.803     0.839     0.200
    74.776     1.745     0.200
    74.809     0.496     0.200
    75.198    -0.196     0.200
    77.040     0.809     0.200
    88.283     2.161     0.200
    18.687     0.821     0.200
    20.375     1.923     0.200
    20.622     1.494     0.200
    21.323     0.479     0.200
    21.426    -0.641     0.200
    22.336     0.456     0.200
    23.745     0.909     0.200
    24.927     1.763     0.200
    25.102     3.294     0.200
    25.495     2.586     0.200
    25.967     1.248     0.200
    26.324     3.886     0.200
    26.493     0.147     0.200
    26.881     4.273     0.200
    27.785     3.062     0.200
    27.945     1.456     0.200
    34.050     1.798     0.200
    34.845     0.961     0.200
    36.658     1.509     0.200
    42.217     0.172     0.200
    59.226     1.701     0.200
    64.882     0.546     0.200
    67.153     0.435     0.200
    67.826     0.946     0.200
    68.119     2.117     0.200
    68.521     3.117     0.200
    70.460     0.386     0.200
    70.678     0.730     0.200
    70.771    -0.639     0.200
    70.838    -0.507     0.200
    72.244    -0.831     0.200
    73.421     0.684     0.200
    73.443     1.223     0.200
    74.140     2.465     0.200
    75.831     0.812     0.200
    76.280     0.187     0.200
    76.682     0.420     0.200
    77.040     2.458     0.200
    77.927     2.266     0.200
    79.623     3.181     0.200
    80.524     1.752     0.200
    87.962     5.104     0.200
    87.961     4.959     0.200
    23.745     0.522     0.200
    40.149     0.937     0.200
    47.197     3.178     0.200
    48.306     0.770     0.200
    49.164    -0.725     0.200
    57.635     2.905     0.200
    59.226     2.092     0.200
    61.020     2.190     0.200
    64.250     1.222     0.200
    64.882    -0.513     0.200
    73.443     0.063     0.200
    19.686     0.181     0.200
    20.902     2.497     0.200
    22.722     0.099     0.200
    19.395     2.066     0.200
    21.469     0.148     0.200
    25.146     0.104     0.200
    25.507    -0.505     0.200
    26.011    -0.234     0.200
    39.440     0.212     0.200
    57.923    -1.081     0.200
    59.225     0.775     0.200
    59.297     0.417     0.200
    59.297     0.527     0.200
    59.485     1.048     0.200
    59.543     0.105     0.200
    60.482    -1.163     0.200
    60.482    -1.272     0.200
    62.581    -0.807     0.200
    64.896    -1.028     0.200
    67.723    -0.428     0.200
    67.787    -1.119     0.200
    69.446    -0.378     0.200
    69.446    -0.378     0.200
    73.819    -0.421     0.200
    20.387     2.756     0.200
    21.340     0.509     0.200
    21.469     1.344     0.200
    22.348     1.732     0.200
    23.741     0.722     0.200
    24.930     2.559     0.200
    25.146     1.753     0.200
    26.011     0.750     0.200
    27.813     1.891     0.200
    38.160     0.077     0.200
    42.231     2.808     0.200
    58.231     0.383     0.200
    58.919    -0.966     0.200
    59.225     1.251     0.200
    64.896    -0.317     0.200
    65.425     0.783     0.200
    66.446    -1.033     0.200
    67.787    -0.658     0.200
    68.197     0.599     0.200
    68.829    -0.472     0.200
    70.609     0.947     0.200
    71.354     0.298     0.200
    72.283     1.589     0.200
    73.457     0.776     0.200
    73.736     0.481     0.200
    74.588     1.566     0.200
    74.791     0.541     0.200
    75.846     1.030     0.200
    79.652     2.424     0.200
    83.989     1.786     0.200
    15.441     4.453     0.200
    16.168     3.155     0.200
    16.554     3.420     0.200
    16.710     1.950     0.200
    16.739     2.378     0.200
    17.133     1.854     0.200
    17.154     2.674     0.200
    17.399     0.883     0.200
    17.437     1.256     0.200
    18.024     1.192     0.200
    18.486     1.146     0.200
    18.755     1.087     0.200
    19.314     1.000     0.200
    19.917     1.347     0.200
    20.174     1.342     0.200
    21.426    -0.233     0.200
    22.692     1.106     0.200
    25.052     0.517     0.200
    25.945     0.472     0.200
    26.312     1.503     0.200
    26.682     2.583     0.200
    28.937    -0.019     0.200
    33.185     1.996     0.200
    33.853     1.945     0.200
    37.967     1.166     0.200
    40.427     1.917     0.200
    40.456     1.263     0.200
    41.128     1.277     0.200
    44.551     0.587     0.200
    59.422     0.327     0.200
    62.692    -1.225     0.200
    64.405     1.043     0.200
    64.780    -1.083     0.200
    65.051     0.060     0.200
    68.874    -1.256     0.200
    71.925     1.980     0.200
    73.611    -0.281     0.200
    73.824    -0.481     0.200
    76.823     2.507     0.200
    77.925     1.893     0.200
    80.943     0.673     0.200
    88.101     0.124     0.200
    17.710     2.016     0.200
    18.486     1.876     0.200
    18.569     2.421     0.200
    20.174     2.049     0.200
    20.423     1.353     0.200
    21.123     1.128     0.200
    21.426     0.224     0.200
    22.134     0.993     0.200
    22.634     1.538     0.200
    23.540     1.850     0.200
    23.943    -0.254     0.200
    23.943     0.594     0.200
    24.645     3.161     0.200
    24.729     1.293     0.200
    25.052     0.658     0.200
    25.294     3.473     0.200
    25.945     0.651     0.200
    26.315     2.625     0.200
    26.682     4.052     0.200
    27.602     1.861     0.200
    27.751     1.085     0.200
    29.279     0.038     0.200
    31.074    -1.181     0.200
    31.821     0.793     0.200
    33.185     3.188     0.200
    33.185     1.457     0.200
    33.417     2.087     0.200
    33.573     1.807     0.200
    33.853     2.875     0.200
    34.792     0.196     0.200
    34.996     1.625     0.200
    35.026    -0.993     0.200
    35.026    -0.754     0.200
    37.461     1.479     0.200
    38.163    -0.601     0.200
    40.346    -2.492     0.200
    41.623    -0.097     0.200
    45.214    -0.207     0.200
    47.040     0.914     0.200
    48.507    -1.269     0.200
    49.362     0.267     0.200
    53.627    -0.627     0.200
    54.339    -0.585     0.200
    54.971    -0.731     0.200
    57.342     0.191     0.200
    57.823     0.501     0.200
    58.207     1.307     0.200
    59.058    -0.122     0.200
    59.064    -0.561     0.200
    59.422     0.698     0.200
    60.185    -1.193     0.200
    60.643    -0.924     0.200
    63.892    -0.400     0.200
    64.405     1.832     0.200
    64.780    -0.724     0.200
    64.780    -0.962     0.200
    65.051    -0.682     0.200
    65.723    -0.270     0.200
    65.885    -0.456     0.200
    66.868     0.047     0.200
    67.197     0.884     0.200
    67.392     0.035     0.200
    68.068     0.632     0.200
    68.210     0.366     0.200
    68.370     0.244     0.200
    68.396     0.247     0.200
    68.529     0.267     0.200
    68.617     0.276     0.200
    68.654     0.637     0.200
    68.654     0.458     0.200
    68.874    -0.717     0.200
    69.087     2.814     0.200
    69.387    -0.937     0.200
    69.806    -1.835     0.200
    70.175    -0.591     0.200
    70.491     1.135     0.200
    70.525     0.367     0.200
    70.518     1.018     0.200
    70.786     0.714     0.200
    70.835     0.148     0.200
    71.269    -0.644     0.200
    71.358     0.356     0.200
    72.175    -0.084     0.200
    72.775     0.734     0.200
    73.210     0.144     0.200
    73.493     0.538     0.200
    73.611     0.309     0.200
    73.611    -0.070     0.200
    73.688    -0.357     0.200
    73.824     0.300     0.200
    75.041     2.658     0.200
    77.395     0.290     0.200
    84.176     1.074     0.200
    88.163     0.179     0.200
    88.162     0.155     0.200
    88.484     0.561     0.200
    15.862     5.983     0.200
    15.895     6.552     0.200
    17.648     2.190     0.200
    18.569     3.144     0.200
    21.123     1.917     0.200
    22.134     1.228     0.200
    23.943     0.230     0.200
    26.318     4.157     0.200
    26.682     4.353     0.200
    28.305     4.038     0.200
    28.937     0.204     0.200
    30.737     3.788     0.200
    33.185     3.774     0.200
    33.417     2.353     0.200
    33.853     3.222     0.200
    35.026    -0.536     0.200
    38.163    -0.277     0.200
    39.715     3.223     0.200
    40.597     3.400     0.200
    42.020     3.339     0.200
    42.190     3.046     0.200
    45.470     1.415     0.200
    53.479    -0.332     0.200
    56.549     0.627     0.200
    57.342     0.437     0.200
    59.514    -0.012     0.200
    59.513     0.275     0.200
    60.643    -0.725     0.200
    62.692    -0.377     0.200
    64.405     1.981     0.200
    65.051    -0.491     0.200
    68.396     2.759     0.200
    68.874     0.053     0.200
    71.824     0.311     0.200
    73.508    -0.012     0.200
    73.824     0.827     0.200
    74.818     0.600     0.200
    84.815     0.889     0.200
    18.217     0.767     0.200
    18.749     1.401     0.200
    19.016     1.382     0.200
    20.149     2.126     0.200
    20.501    -0.858     0.200
    20.435     0.974     0.200
    20.677     1.281     0.200
    21.386     0.453     0.200
    21.455     0.339     0.200
    22.112     2.080     0.200
    22.396     0.408     0.200
    22.992    -0.817     0.200
    22.892     0.334     0.200
    23.997     1.180     0.200
    24.203    -2.540     0.200
    16.136     3.488     0.200
    16.136     3.719     0.200
    17.438     0.713     0.200
    17.970     1.980     0.200
    18.749     2.300     0.200
    18.804     4.156     0.200
    18.804     4.016     0.200
    20.435     1.474     0.200
    20.677     1.839     0.200
    21.455     0.769     0.200
    21.386     0.902     0.200
    21.386     1.681     0.200
    22.396     0.997     0.200
    22.396     1.193     0.200
    22.891     1.668     0.200
    23.691    -0.366     0.200
    23.691     0.673     0.200
    23.691    -0.747     0.200
    23.745     2.653     0.200
    23.803     1.586     0.200
    24.905     1.342     0.200
    24.980     2.166     0.200
    25.144     1.216     0.200
    25.555     1.461     0.200
    26.002     1.002     0.200
    26.559     1.021     0.200
    26.559     1.281     0.200
    26.543     2.307     0.200
    26.944     0.971     0.200
    26.944     2.181     0.200
    27.851     0.913     0.200
    27.994     2.066     0.200
    28.507     0.603     0.200
    28.545     2.281     0.200
    28.895     0.647     0.200
    29.351     0.613     0.200
    29.686     2.102     0.200
    30.243     1.323     0.200
    30.816    -1.237     0.200
    30.743     0.589     0.200
    30.743     0.860     0.200
    30.957     0.784     0.200
    30.972     1.556     0.200
    30.974     2.338     0.200
    31.019     2.332     0.200
    31.448     1.914     0.200
    31.946     1.224     0.200
    33.155    -0.098     0.200
    33.155     0.982     0.200
    33.444     2.495     0.200
    33.444     2.740     0.200
    33.675     1.301     0.200
    33.831     2.436     0.200
    34.103     2.882     0.200
    34.103     3.157     0.200
    34.412     1.355     0.200
    34.330     0.742     0.200
    34.803     0.194     0.200
    34.803    -0.587     0.200
    34.803     0.023     0.200
    34.941     0.473     0.200
    34.950     0.505     0.200
    35.507     1.638     0.200
    36.016     0.056     0.200
    36.734     1.444     0.200
    36.734    -1.677     0.200
    36.734     1.643     0.200
    36.715     2.219     0.200
    37.631     0.756     0.200
    37.631     1.164     0.200
    37.706    -0.484     0.200
    37.706     0.397     0.200
    38.136    -0.128     0.200
    38.136     0.102     0.200
    38.151     1.645     0.200
    38.153     2.680     0.200
    38.153     2.827     0.200
    38.574     0.558     0.200
    39.442     0.644     0.200
    39.795     1.504     0.200
    39.795     1.650     0.200
    39.968    -0.133     0.200
    39.968     0.854     0.200
    40.097    -0.915     0.200
    40.097     0.007     0.200
    40.046     0.918     0.200
    40.091     1.110     0.200
    40.850     2.624     0.200
    40.850     3.218     0.200
    40.884     0.651     0.200
    40.884     0.940     0.200
    40.925     0.258     0.200
    40.962     0.533     0.200
    40.928     3.258     0.200
    41.082     3.198     0.200
    41.082     3.484     0.200
    41.322     0.258     0.200
    41.267     1.299     0.200
    41.262     3.649     0.200
    41.362     3.540     0.200
    41.682     0.023     0.200
    42.019     1.028     0.200
    42.035     0.719     0.200
    42.172     0.576     0.200
    42.228     0.243     0.200
    42.200     2.810     0.200
    42.200     2.976     0.200
    42.257    -0.056     0.200
    42.257     0.778     0.200
    42.278     1.390     0.200
    42.278     1.884     0.200
    42.497     1.088     0.200
    42.424     3.744     0.200
    42.502     1.162     0.200
    42.638     0.974     0.200
    43.459     4.336     0.200
    43.650     0.757     0.200
    43.792     0.529     0.200
    43.967     1.186     0.200
    44.379     0.748     0.200
    44.953     0.038     0.200
    44.953     0.689     0.200
    44.953    -0.260     0.200
    45.191    -0.023     0.200
    45.642     0.711     0.200
    45.642     1.073     0.200
    45.798     2.566     0.200
    46.226     0.474     0.200
    46.782    -0.103     0.200
    46.889     1.675     0.200
    46.889     2.150     0.200
    47.044     1.281     0.200
    47.131     0.233     0.200
    48.245     0.016     0.200
    49.029     0.795     0.200
    49.110     0.766     0.200
    49.684    -0.804     0.200
    49.684    -0.564     0.200
    49.684     0.246     0.200
    49.993    -0.603     0.200
    50.233     2.345     0.200
    50.233     2.118     0.200
    50.824    -0.336     0.200
    51.807    -0.206     0.200
    51.823    -2.355     0.200
    51.823    -0.254     0.200
    51.823     0.416     0.200
    51.958    -0.279     0.200
    52.733     0.603     0.200
    52.756    -1.172     0.200
    52.873     0.554     0.200
    53.223     0.891     0.200
    53.540     0.131     0.200
    53.614    -0.117     0.200
    53.631     0.467     0.200
    53.735     0.206     0.200
    54.075     1.083     0.200
    54.075     0.868     0.200
    54.262    -1.022     0.200
    54.897    -0.367     0.200
    55.126     0.428     0.200
    55.126     0.287     0.200
    55.864     2.050     0.200
    56.291     0.680     0.200
    56.291     1.589     0.200
    56.629    -0.284     0.200
    56.706    -0.500     0.200
    57.088    -0.956     0.200
    57.119     0.295     0.200
    57.242    -0.690     0.200
    57.589     0.918     0.200
    57.851     0.277     0.200
    57.851     0.078     0.200
    57.971     1.134     0.200
    57.970    -0.608     0.200
    58.213     0.104     0.200
    58.245    -0.190     0.200
    58.330     0.015     0.200
    58.143     1.469     0.200
    58.736    -0.183     0.200
    58.804     2.365     0.200
    58.887    -1.063     0.200
    58.957    -0.448     0.200
    58.986    -0.432     0.200
    59.175     0.291     0.200
    59.175     1.342     0.200
    59.175     0.961     0.200
    59.251     0.705     0.200
    59.478     1.326     0.200
    59.526     0.451     0.200
    59.595     0.325     0.200
    59.760    -0.070     0.200
    59.810    -0.147     0.200
    59.810     0.013     0.200
    59.788     0.671     0.200
    59.788     0.805     0.200
    59.879    -0.302     0.200
    59.979    -1.209     0.200
    59.974     0.287     0.200
    59.949     1.567     0.200
    60.220     0.097     0.200
    60.251     0.654     0.200
    60.362     0.929     0.200
    60.362     0.732     0.200
    60.434    -0.624     0.200
    60.434    -0.823     0.200
    60.428    -0.188     0.200
    60.510     0.697     0.200
    60.678    -0.065     0.200
    60.847     0.936     0.200
    60.864    -0.120     0.200
    60.900    -0.414     0.200
    60.900    -0.305     0.200
    60.942     0.700     0.200
    60.942     1.261     0.200
    61.008    -0.336     0.200
    61.369    -0.643     0.200
    61.375     0.266     0.200
    61.631     0.326     0.200
    61.767    -0.455     0.200
    61.874     0.107     0.200
    62.084     0.236     0.200
    62.256     1.176     0.200
    62.538    -0.049     0.200
    62.538    -0.180     0.200
    62.641     0.216     0.200
    62.920    -0.223     0.200
    62.937    -0.409     0.200
    62.937     0.089     0.200
    63.211     0.733     0.200
    63.174     0.297     0.200
    63.455     0.386     0.200
    63.620     0.084     0.200
    63.673     0.418     0.200
    63.920     0.919     0.200
    64.142    -0.175     0.200
    64.222     0.002     0.200
    64.222     0.198     0.200
    64.582     0.536     0.200
    64.726     1.013     0.200
    64.733     0.379     0.200
    64.759     0.409     0.200
    64.848    -1.043     0.200
    64.848    -1.693     0.200
    64.848    -0.248     0.200
    64.917     0.458     0.200
    65.027    -0.446     0.200
    65.103     0.228     0.200
    65.153    -0.214     0.200
    65.254     0.057     0.200
    65.323     0.232     0.200
    65.374     0.223     0.200
    65.400    -0.797     0.200
    65.483     0.757     0.200
    65.700     0.513     0.200
    65.717     0.384     0.200
    65.784    -0.241     0.200
    65.879     0.380     0.200
    65.979     0.246     0.200
    65.971    -1.956     0.200
    66.148     0.368     0.200
    66.158     0.121     0.200
    66.325     0.382     0.200
    66.413    -0.505     0.200
    66.406     0.141     0.200
    66.422     0.001     0.200
    66.438    -0.119     0.200
    66.438     0.162     0.200
    66.746    -1.932     0.200
    66.647     0.338     0.200
    66.845     0.070     0.200
    66.934     0.453     0.200
    66.987     0.154     0.200
    67.168     0.203     0.200
    67.203     0.339     0.200
    67.353     0.327     0.200
    67.378     0.385     0.200
    67.416     0.403     0.200
    67.570    -1.541     0.200
    67.623     0.723     0.200
    67.643     0.299     0.200
    67.650     0.454     0.200
    67.674    -0.396     0.200
    67.674    -0.920     0.200
    67.701     0.318     0.200
    67.702     0.103     0.200
    67.738    -1.242     0.200
    67.738    -0.527     0.200
    67.760     0.515     0.200
    67.839     0.559     0.200
    67.859    -0.100     0.200
    67.881     1.302     0.200
    67.881     1.821     0.200
    67.938     0.268     0.200
    67.938    -0.283     0.200
    68.030     0.856     0.200
    68.063     0.388     0.200
    68.135     0.596     0.200
    68.166     0.463     0.200
    68.171     0.793     0.200
    68.183    -0.254     0.200
    68.236     0.161     0.200
    68.252     0.136     0.200
    68.333     0.424     0.200
    68.338     0.157     0.200
    68.340     0.273     0.200
    68.350     0.299     0.200
    68.390     0.229     0.200
    68.390     0.780     0.200
    68.412    -0.162     0.200
    68.412     0.485     0.200
    68.421     0.607     0.200
    68.425    -0.540     0.200
    68.434     0.486     0.200
    68.503     0.312     0.200
    68.507     0.357     0.200
    68.502     0.245     0.200
    68.524     0.119     0.200
    68.538     0.204     0.200
    68.565     0.235     0.200
    68.565    -0.515     0.200
    68.565    -0.021     0.200
    68.584     0.276     0.200
    68.609     0.198     0.200
    68.626     0.483     0.200
    68.623     0.443     0.200
    68.694     0.277     0.200
    68.753     0.273     0.200
    68.797    -0.775     0.200
    68.797    -0.496     0.200
    68.887     0.256     0.200
    68.896    -0.278     0.200
    68.896     0.167     0.200
    68.923     0.332     0.200
    68.935    -0.030     0.200
    68.984     0.131     0.200
    68.984    -0.369     0.200
    69.006     0.467     0.200
    69.041     0.298     0.200
    68.970    -0.919     0.200
    69.077    -0.153     0.200
    69.109    -0.404     0.200
    69.109     0.031     0.200
    69.187     0.399     0.200
    69.091     1.150     0.200
    69.091     1.381     0.200
    69.191     0.604     0.200
    69.091     0.888     0.200
    69.091     1.106     0.200
    69.260     1.320     0.200
    69.150     1.300     0.200
    69.314     0.537     0.200
    69.314     0.227     0.200
    69.400    -0.068     0.200
    69.452     0.080     0.200
    69.482     1.586     0.200
    69.792     0.456     0.200
    69.822     0.584     0.200
    69.923     1.014     0.200
    69.980     0.168     0.200
    70.142    -0.076     0.200
    70.203     0.799     0.200
    70.203     0.148     0.200
    70.400    -0.661     0.200
    70.474     0.220     0.200
    70.474    -0.011     0.200
    70.404     1.776     0.200
    70.481     0.588     0.200
    70.480     0.685     0.200
    70.504     1.126     0.200
    70.419     0.252     0.200
    70.480    -0.415     0.200
    70.585     0.792     0.200
    70.661    -0.064     0.200
    70.661     1.196     0.200
    70.688     0.462     0.200
    70.688     0.081     0.200
    70.682    -2.108     0.200
    70.754     0.471     0.200
    70.780     0.305     0.200
    70.780    -0.275     0.200
    70.844    -0.080     0.200
    70.849     0.702     0.200
    70.849     0.403     0.200
    70.869     1.040     0.200
    70.953     0.162     0.200
    70.974     0.524     0.200
    71.008     0.258     0.200
    71.008     0.139     0.200
    71.041    -0.060     0.200
    71.120     0.511     0.200
    71.120    -0.040     0.200
    71.128    -0.220     0.200
    71.182    -0.841     0.200
    71.238    -0.369     0.200
    71.289     0.724     0.200
    71.330    -0.123     0.200
    71.329     0.090     0.200
    71.343     1.331     0.200
    71.432     0.836     0.200
    71.432     0.266     0.200
    71.447     1.310     0.200
    71.447     0.579     0.200
    71.520     1.192     0.200
    71.869    -0.604     0.200
    71.613     0.378     0.200
    71.672    -0.380     0.200
    71.674    -0.388     0.200
    71.694    -0.452     0.200
    71.699     0.721     0.200
    71.699     0.061     0.200
    71.982     0.268     0.200
    71.943     1.875     0.200
    72.121     0.016     0.200
    72.150     0.994     0.200
    72.139     1.575     0.200
    72.164     0.579     0.200
    72.205    -0.298     0.200
    72.205    -0.677     0.200
    72.234     0.902     0.200
    72.257     0.104     0.200
    72.257    -0.387     0.200
    72.183     0.833     0.200
    72.183     1.249     0.200
    72.333     0.857     0.200
    72.484     0.935     0.200
    72.525     0.313     0.200
    72.536     1.005     0.200
    72.561     0.725     0.200
    72.637     0.493     0.200
    72.771    -0.102     0.200
    72.904     0.170     0.200
    72.984     0.392     0.200
    73.039    -0.183     0.200
    73.160    -0.140     0.200
    73.291     0.256     0.200
    73.395    -0.064     0.200
    73.409     0.000     0.200
    73.409     0.969     0.200
    73.418    -0.164     0.200
    73.426     0.182     0.200
    73.526     1.073     0.200
    73.560    -0.535     0.200
    73.565     0.186     0.200
    73.687     0.936     0.200
    73.724     0.038     0.200
    73.725     0.011     0.200
    73.747    -0.229     0.200
    73.869     0.818     0.200
    73.869     1.139     0.200
    73.921     0.356     0.200
    73.921     0.987     0.200
    74.138     1.077     0.200
    74.195     0.403     0.200
    74.214    -0.329     0.200
    74.422    -0.262     0.200
    74.489     1.197     0.200
    74.525    -0.009     0.200
    74.557    -0.797     0.200
    74.590    -0.519     0.200
    74.674    -0.315     0.200
    74.689     0.480     0.200
    74.757    -0.246     0.200
    74.779     0.465     0.200
    74.865    -0.314     0.200
    74.878     0.683     0.200
    74.950    -0.254     0.200
    75.282     0.436     0.200
    75.018    -0.416     0.200
    75.089     0.764     0.200
    75.189     0.359     0.200
    75.189     0.582     0.200
    75.862    -0.542     0.200
    75.862     0.439     0.200
    75.857     1.095     0.200
    76.005    -0.498     0.200
    76.085     0.367     0.200
    75.990    -0.553     0.200
    76.174    -0.861     0.200
    76.138     1.292     0.200
    76.303     0.925     0.200
    76.326    -0.504     0.200
    76.310     1.236     0.200
    76.470     0.328     0.200
    77.207     0.767     0.200
    77.386     0.399     0.200
    77.386     1.063     0.200
    77.889    -0.569     0.200
    77.982     0.051     0.200
    77.995     0.360     0.200
    78.205     0.034     0.200
    78.311     0.536     0.200
    78.345     1.197     0.200
    78.220     1.822     0.200
    78.220     2.621     0.200
    78.425     0.698     0.200
    78.432     2.538     0.200
    78.653     1.021     0.200
    78.749     0.499     0.200
    78.768    -0.076     0.200
    79.576     0.103     0.200
    79.613     0.820     0.200
    79.613     0.970     0.200
    79.613     1.283     0.200
    79.686     0.445     0.200
    79.790     1.028     0.200
    79.790     1.428     0.200
    79.973     0.670     0.200
    80.288     1.049     0.200
    80.492     0.173     0.200
    80.567     0.396     0.200
    81.012     0.166     0.200
    81.477     0.127     0.200
    81.662    -0.183     0.200
    82.229     0.687     0.200
    82.954    -0.304     0.200
    82.954     0.225     0.200
    83.117    -1.236     0.200
    83.017     1.652     0.200
    83.316     0.676     0.200
    83.460     0.086     0.200
    83.399     1.758     0.200
    83.938     1.000     0.200
    84.436     0.429     0.200
    84.580     1.329     0.200
    84.705     0.018     0.200
    84.993     1.788     0.200
    84.993     2.288     0.200
    86.056     0.042     0.200
    86.932    -0.416     0.200
    86.932     0.605     0.200
    87.045     0.271     0.200
    87.261     0.584     0.200
    87.662     0.639     0.200
    87.844     0.066     0.200
    87.844     0.513     0.200
    87.734    -0.106     0.200
    87.905    -0.272     0.200
    87.905     0.070     0.200
    87.905     0.777     0.200
    87.904    -0.239     0.200
    88.227     0.953     0.200
    88.335     0.551     0.200
    88.335     0.428     0.200
    88.424     0.218     0.200
    89.095     0.159     0.200
    89.095     0.715     0.200
    89.374     0.510     0.200
    89.856     1.094     0.200
    89.856    -0.136     0.200
    89.856     0.201     0.200
    90.045     0.431     0.200
    90.045     0.187     0.200
    90.969     0.770     0.200
    91.287    -0.448     0.200
    91.287    -0.098     0.200
    91.431    -0.374     0.200
    91.530     0.496     0.200
    91.853     0.359     0.200
    92.370    -0.270     0.200
    92.433     0.508     0.200
    92.767     0.997     0.200
    93.004     1.002     0.200
    93.084     0.086     0.200
    93.605    -1.493     0.200
    93.829    -1.128     0.200
    93.829    -0.913     0.200
    95.397    -0.710     0.200
    95.694    -1.027     0.200
    95.694     0.479     0.200
    95.931     1.052     0.200
    96.188     1.005     0.200
    96.300     0.026     0.200
    96.455    -1.507     0.200
    96.513    -0.179     0.200
    96.574     0.353     0.200
    98.795     1.165     0.200
    98.795     2.120     0.200
    98.960    -0.582     0.200
    99.411     0.039     0.200
    34.610     1.951     0.200
    79.973     0.289     0.200
    73.948     1.896     0.200
    17.682     0.046     0.200
    19.027     0.479     0.200
    19.586     0.302     0.200
    19.766    -0.733     0.200
    21.003     0.415     0.200
    20.475     0.490     0.200
    20.425     2.008     0.200
    21.271     1.369     0.200
    24.183     0.930     0.200
    16.154     6.707     0.200
    16.154     6.311     0.200
    17.412     2.410     0.200
    18.820     4.284     0.200
    23.672     0.704     0.200
    26.018    -0.479     0.200
    28.012     2.008     0.200
    28.563     2.232     0.200
    28.902     0.524     0.200
    30.794     0.457     0.200
    30.989     1.879     0.200
    31.039     2.318     0.200
    33.132     1.125     0.200
    33.132     0.801     0.200
    33.465     2.519     0.200
    33.465     2.009     0.200
    33.702     1.600     0.200
    34.122     2.308     0.200
    34.429     1.437     0.200
    34.789     0.120     0.200
    34.789    -0.360     0.200
    34.974    -0.058     0.200
    36.752     1.433     0.200
    36.752     0.572     0.200
    36.752     1.902     0.200
    36.736     2.370     0.200
    36.931     1.245     0.200
    37.656     1.202     0.200
    37.731    -0.477     0.200
    37.731     0.057     0.200
    38.145    -0.062     0.200
    38.145    -0.443     0.200
    38.170     2.616     0.200
    38.170     2.434     0.200
    39.511     2.112     0.200
    39.799     2.290     0.200
    40.078    -0.243     0.200
    40.078    -0.702     0.200
    40.078    -0.513     0.200
    40.073     0.780     0.200
    40.114     1.114     0.200
    40.870     2.303     0.200
    40.870     2.086     0.200
    40.910     0.421     0.200
    40.951    -2.196     0.200
    41.070     2.293     0.200
    41.070     2.703     0.200
    41.070     3.139     0.200
    41.291     1.775     0.200
    41.699    -0.272     0.200
    42.045     0.915     0.200
    42.240     0.157     0.200
    42.189     2.182     0.200
    42.189     2.842     0.200
    42.284     0.642     0.200
    42.284     0.374     0.200
    42.302     1.389     0.200
    42.413     3.246     0.200
    42.418     2.685     0.200
    42.664     0.754     0.200
    43.676     0.537     0.200
    44.928    -0.156     0.200
    44.928    -0.957     0.200
    45.217     0.696     0.200
    45.666     0.942     0.200
    45.666     0.629     0.200
    46.251    -1.094     0.200
    46.761     0.271     0.200
    48.222    -0.299     0.200
    49.090     0.925     0.200
    49.688    -0.385     0.200
    51.825     0.438     0.200
    51.825     0.599     0.200
    51.962    -0.138     0.200
    53.202     0.433     0.200
    53.202     0.134     0.200
    54.099     1.449     0.200
    55.100     0.278     0.200
    55.100    -0.017     0.200
    55.887     1.387     0.200
    56.757    -0.491     0.200
    57.573     0.941     0.200
    57.954     1.361     0.200
    58.313     0.846     0.200
    58.957    -0.544     0.200
    59.156     0.382     0.200
    59.156     0.710     0.200
    59.227     1.215     0.200
    59.452     1.689     0.200
    59.539     2.031     0.200
    59.539     0.891     0.200
    59.764     0.829     0.200
    59.967    -1.921     0.200
    60.337     0.805     0.200
    60.337     1.045     0.200
    60.421    -0.481     0.200
    60.421    -0.731     0.200
    60.437    -0.836     0.200
    60.904    -0.925     0.200
    61.006     0.089     0.200
    61.869    -0.247     0.200
    62.107     0.637     0.200
    62.534    -1.009     0.200
    62.534    -0.038     0.200
    62.912     0.670     0.200
    63.659     0.118     0.200
    64.149    -2.708     0.200
    64.213    -0.933     0.200
    64.213     0.063     0.200
    64.837    -1.410     0.200
    64.837    -0.316     0.200
    64.921     0.241     0.200
    67.661    -0.879     0.200
    67.661    -1.129     0.200
    67.725    -1.532     0.200
    67.725    -0.587     0.200
    67.946    -1.026     0.200
    68.163    -0.185     0.200
    68.401    -0.278     0.200
    68.419     0.051     0.200
    68.513     0.819     0.200
    68.513     0.438     0.200
    68.573    -0.853     0.200
    68.573    -0.185     0.200
    68.801    -0.460     0.200
    68.904    -0.017     0.200
    68.904    -0.125     0.200
    69.117    -0.444     0.200
    68.993    -0.528     0.200
    69.117     1.437     0.200
    69.489     1.053     0.200
    70.150     0.085     0.200
    70.406    -0.483     0.200
    70.436     0.435     0.200
    70.481     0.260     0.200
    70.489     0.410     0.200
    70.673     0.385     0.200
    70.696     0.150     0.200
    70.786    -0.101     0.200
    70.866     0.678     0.200
    71.048     0.006     0.200
    71.128     0.224     0.200
    71.454     0.553     0.200
    71.600     0.266     0.200
    72.213    -1.010     0.200
    72.265    -0.622     0.200
    72.209     0.665     0.200
    72.477     0.797     0.200
    73.398    -0.153     0.200
    73.398     0.767     0.200
    73.674     0.175     0.200
    73.885     0.510     0.200
    75.862     0.052     0.200
    75.862     0.623     0.200
    76.084    -0.917     0.200
    76.303     0.841     0.200
    77.002     0.688     0.200
    77.198     0.555     0.200
    79.612     1.241     0.200
    79.612     1.804     0.200
    79.794     1.074     0.200
    79.976     0.769     0.200
    81.451     0.306     0.200
    84.564     1.227     0.200
    86.035     0.461     0.200
    87.823     0.321     0.200
    87.884    -0.707     0.200
    87.884     0.389     0.200
    87.757    -0.400     0.200
    88.205     0.768     0.200
    89.830     1.524     0.200
    90.048     0.464     0.200
    91.313    -0.477     0.200
    92.984     1.043     0.200
    98.770     1.424     0.200
    73.973     1.763     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
    99.665     2.875     0.200
    99.785     3.113     0.200
    99.785     3.613     0.200
    99.785     2.933     0.200
    99.964     2.919     0.200
    99.964     2.427     0.200
   100.162     4.585     0.200
   100.578     2.065     0.200
   100.758     2.147     0.200
   101.736     0.816     0.200
   102.081     2.711     0.200
   102.673     3.359     0.200
   102.673     2.500     0.200
   102.863     1.758     0.200
   103.927     0.389     0.200
    99.733     0.883     0.200
   101.470     0.068     0.200
   103.245     0.963     0.200
    99.742    -0.523     0.200
    99.742     1.102     0.200
    99.893     0.034     0.200
   100.533     1.133     0.200
   100.617     1.114     0.200
   100.617     2.184     0.200
   103.132     0.764     0.200
   103.132     1.102     0.200
   104.375     2.650     0.200
   105.417     0.318     0.200
   106.155     1.557     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    46.348    97.985     0.200
    58.797    50.374     0.200
    35.284   149.204     0.200
    46.351    94.962     0.200
    32.975   165.454     0.200
    33.703   162.538     0.200
    39.018   130.711     0.200
    45.361   102.224     0.200
    45.923    99.886     0.200
    56.912    56.064     0.200
    62.328    40.633     0.200
    63.903    34.381     0.200
    68.016    25.014     0.200
    69.598    24.261     0.200
    71.046    14.902     0.200
    72.807    14.934     0.200
    76.271     9.814     0.200
    76.548    13.541     0.200
    87.005     1.683     0.200
    39.020   130.787     0.200
    63.901    32.483     0.200
    69.598    24.256     0.200
    71.045    14.804     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
