#!/bin/bash
gmt begin hubbard6.23_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times hubbard6.23'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   324.110
    25.500   328.654
    26.000   333.186
    26.500   337.707
    27.000   342.215
    27.500   346.707
    28.000   351.180
    28.500   355.636
    29.000   360.082
    29.500   364.518
    30.000   368.947
    30.500   373.368
    31.000   377.781
    31.500   382.186
    32.000   386.584
    32.500   390.972
    33.000   395.349
    33.500   399.714
    34.000   404.064
    34.500   408.400
    35.000   412.721
    35.500   417.026
    36.000   421.317
    36.500   425.592
    37.000   429.852
    37.500   434.096
    38.000   438.324
    38.500   442.536
    39.000   446.732
    39.500   450.911
    40.000   455.072
    40.500   459.217
    41.000   463.344
    41.500   467.454
    42.000   471.548
    42.500   475.624
    43.000   479.683
    43.500   483.724
    44.000   487.747
    44.500   491.753
    45.000   495.741
    45.500   499.711
    46.000   503.662
    46.500   507.596
    47.000   511.512
    47.500   515.410
    48.000   519.289
    48.500   523.151
    49.000   526.994
    49.500   530.819
    50.000   534.626
    50.500   538.414
    51.000   542.185
    51.500   545.936
    52.000   549.670
    52.500   553.386
    53.000   557.085
    53.500   560.765
    54.000   564.427
    54.500   568.071
    55.000   571.697
    55.500   575.304
    56.000   578.892
    56.500   582.462
    57.000   586.014
    57.500   589.548
    58.000   593.063
    58.500   596.561
    59.000   600.040
    59.500   603.501
    60.000   606.943
    60.500   610.368
    61.000   613.773
    61.500   617.161
    62.000   620.530
    62.500   623.881
    63.000   627.214
    63.500   630.529
    64.000   633.827
    64.500   637.106
    65.000   640.368
    65.500   643.611
    66.000   646.837
    66.500   650.044
    67.000   653.234
    67.500   656.405
    68.000   659.558
    68.500   662.693
    69.000   665.810
    69.500   668.908
    70.000   671.989
    70.500   675.051
    71.000   678.095
    71.500   681.121
    72.000   684.129
    72.500   687.119
    73.000   690.090
    73.500   693.043
    74.000   695.977
    74.500   698.892
    75.000   701.789
    75.500   704.667
    76.000   707.527
    76.500   710.368
    77.000   713.192
    77.500   715.997
    78.000   718.784
    78.500   721.553
    79.000   724.304
    79.500   727.037
    80.000   729.751
    80.500   732.446
    81.000   735.121
    81.500   737.777
    82.000   740.414
    82.500   743.033
    83.000   745.632
    83.500   748.213
    84.000   750.775
    84.500   753.316
    85.000   755.836
    85.500   758.336
    86.000   760.818
    86.500   763.283
    87.000   765.729
    87.500   768.153
    88.000   770.542
    88.500   772.908
    89.000   775.263
    89.500   777.608
    90.000   779.946
    90.500   782.277
    91.000   784.602
    91.500   786.922
    92.000   789.237
    92.500   791.547
    93.000   793.855
    93.500   796.158
    94.000   798.459
    94.500   800.754
    95.000   803.045
    95.500   805.329
    96.000   807.607
    96.500   809.879
    97.000   812.144
    97.500   814.403
    98.000   816.654
    98.500   818.899
    99.000   821.135
    99.500   823.364
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1122.386
   116.000  1123.348
   116.500  1124.310
   117.000  1125.272
   117.500  1126.234
   118.000  1127.196
   118.500  1128.158
   119.000  1129.119
   119.500  1130.081
   120.000  1131.042
   120.500  1132.003
   121.000  1132.964
   121.500  1133.925
   122.000  1134.885
   122.500  1135.845
   123.000  1136.804
   123.500  1137.763
   124.000  1138.722
   124.500  1139.680
   125.000  1140.638
   125.500  1141.595
   126.000  1142.552
   126.500  1143.507
   127.000  1144.463
   127.500  1145.417
   128.000  1146.371
   128.500  1147.323
   129.000  1148.275
   129.500  1149.226
   130.000  1150.176
   130.500  1151.125
   131.000  1152.073
   131.500  1153.019
   132.000  1153.964
   132.500  1154.908
   133.000  1155.850
   133.500  1156.790
   134.000  1157.729
   134.500  1158.666
   135.000  1159.602
   135.500  1160.535
   136.000  1161.466
   136.500  1162.395
   137.000  1163.321
   137.500  1164.245
   138.000  1165.167
   138.500  1166.085
   139.000  1167.001
   139.500  1167.914
   140.000  1168.823
   140.500  1169.729
   141.000  1170.632
   141.500  1171.531
   142.000  1172.425
   142.500  1173.316
   143.000  1174.202
   143.500  1175.083
   144.000  1175.959
   144.500  1176.830
   145.000  1177.696
   145.500  1178.556
   146.000  1179.410
   146.500  1180.257
   147.000  1181.099
   147.500  1181.933
   148.000  1182.760
   148.500  1183.580
   149.000  1184.391
   149.500  1185.194
   150.000  1185.987
   150.500  1186.770
   151.000  1187.544
   151.500  1188.307
   152.000  1189.061
   152.500  1189.804
   153.000  1190.538
   153.500  1191.260
   154.000  1191.973
   154.500  1192.674
   155.000  1193.365
   155.500  1194.044
   156.000  1194.711
   156.500  1195.367
   157.000  1196.010
   157.500  1196.642
   158.000  1197.261
   158.500  1197.868
   159.000  1198.462
   159.500  1199.043
   160.000  1199.612
   160.500  1200.167
   161.000  1200.710
   161.500  1201.239
   162.000  1201.755
   162.500  1202.258
   163.000  1202.748
   163.500  1203.224
   164.000  1203.686
   164.500  1204.135
   165.000  1204.569
   165.500  1204.990
   166.000  1205.397
   166.500  1205.790
   167.000  1206.169
   167.500  1206.534
   168.000  1206.885
   168.500  1207.223
   169.000  1207.545
   169.500  1207.854
   170.000  1208.149
   170.500  1208.429
   171.000  1208.695
   171.500  1208.947
   172.000  1209.185
   172.500  1209.408
   173.000  1209.617
   173.500  1209.811
   174.000  1209.992
   174.500  1210.157
   175.000  1210.309
   175.500  1210.446
   176.000  1210.569
   176.500  1210.677
   177.000  1210.771
   177.500  1210.850
   178.000  1210.915
   178.500  1210.966
   179.000  1211.002
   179.500  1211.024
   180.000  1211.031
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   993.329
     1.000   993.338
     1.500   993.352
     2.000   993.371
     2.500   993.396
     3.000   993.427
     3.500   993.464
     4.000   993.506
     4.500   993.553
     5.000   993.606
     5.500   993.665
     6.000   993.729
     6.500   993.799
     7.000   993.875
     7.500   993.956
     8.000   994.042
     8.500   994.135
     9.000   994.232
     9.500   994.336
    10.000   994.445
    10.500   994.559
    11.000   994.679
    11.500   994.805
    12.000   994.936
    12.500   995.072
    13.000   995.214
    13.500   995.362
    14.000   995.515
    14.500   995.674
    15.000   995.838
    15.500   996.008
    16.000   996.183
    16.500   996.364
    17.000   996.550
    17.500   996.742
    18.000   996.939
    18.500   997.142
    19.000   997.350
    19.500   997.564
    20.000   997.783
    20.500   998.007
    21.000   998.237
    21.500   998.473
    22.000   998.713
    22.500   998.960
    23.000   999.211
    23.500   999.468
    24.000   999.730
    24.500   999.998
    25.000  1000.271
    25.500  1000.550
    26.000  1000.834
    26.500  1001.123
    27.000  1001.417
    27.500  1001.717
    28.000  1002.022
    28.500  1002.333
    29.000  1002.648
    29.500  1002.969
    30.000  1003.295
    30.500  1003.627
    31.000  1003.964
    31.500  1004.306
    32.000  1004.653
    32.500  1005.005
    33.000  1005.363
    33.500  1005.726
    34.000  1006.093
    34.500  1006.466
    35.000  1006.845
    35.500  1007.228
    36.000  1007.617
    36.500  1008.010
    37.000  1008.409
    37.500  1008.813
    38.000  1009.222
    38.500  1009.635
    39.000  1010.054
    39.500  1010.478
    40.000  1010.907
    40.500  1011.341
    41.000  1011.780
    41.500  1012.224
    42.000  1012.673
    42.500  1013.127
    43.000  1013.586
    43.500  1014.049
    44.000  1014.518
    44.500  1014.991
    45.000  1015.470
    45.500  1015.953
    46.000  1016.441
    46.500  1016.934
    47.000  1017.431
    47.500  1017.934
    48.000  1018.441
    48.500  1018.953
    49.000  1019.469
    49.500  1019.991
    50.000  1020.517
    50.500  1021.048
    51.000  1021.583
    51.500  1022.123
    52.000  1022.668
    52.500  1023.217
    53.000  1023.771
    53.500  1024.330
    54.000  1024.893
    54.500  1025.460
    55.000  1026.032
    55.500  1026.609
    56.000  1027.190
    56.500  1027.776
    57.000  1028.366
    57.500  1028.960
    58.000  1029.559
    58.500  1030.163
    59.000  1030.770
    59.500  1031.382
    60.000  1031.999
    60.500  1032.620
    61.000  1033.245
    61.500  1033.874
    62.000  1034.507
    62.500  1035.145
    63.000  1035.787
    63.500  1036.433
    64.000  1037.084
    64.500  1037.738
    65.000  1038.397
    65.500  1039.060
    66.000  1039.727
    66.500  1040.398
    67.000  1041.073
    67.500  1041.752
    68.000  1042.435
    68.500  1043.122
    69.000  1043.814
    69.500  1044.509
    70.000  1045.208
    70.500  1045.911
    71.000  1046.617
    71.500  1047.328
    72.000  1048.043
    72.500  1048.761
    73.000  1049.483
    73.500  1050.209
    74.000  1050.939
    74.500  1051.673
    75.000  1052.410
    75.500  1053.151
    76.000  1053.895
    76.500  1054.644
    77.000  1055.396
    77.500  1056.151
    78.000  1056.910
    78.500  1057.673
    79.000  1058.439
    79.500  1059.209
    80.000  1059.982
    80.500  1060.759
    81.000  1061.539
    81.500  1062.322
    82.000  1063.109
    82.500  1063.900
    83.000  1064.694
    83.500  1065.491
    84.000  1066.291
    84.500  1067.095
    85.000  1067.902
    85.500  1068.712
    86.000  1069.526
    86.500  1070.342
    87.000  1071.162
    87.500  1071.985
    88.000  1072.811
    88.500  1073.641
    89.000  1074.473
    89.500  1075.308
    90.000  1076.147
    90.500  1076.988
    91.000  1077.833
    91.500  1078.680
    92.000  1079.531
    92.500  1080.384
    93.000  1081.240
    93.500  1082.099
    94.000  1082.961
    94.500  1083.826
    95.000  1084.694
    95.500  1085.564
    96.000  1086.437
    96.500  1087.313
    97.000  1088.192
    97.500  1089.073
    98.000  1089.957
    98.500  1090.843
    99.000  1091.733
    99.500  1092.624
   100.000  1093.519
   100.500  1094.416
   101.000  1095.315
   101.500  1096.217
   102.000  1097.121
   102.500  1098.028
   103.000  1098.937
   103.500  1099.849
   104.000  1100.763
   104.500  1101.679
   105.000  1102.598
   105.500  1103.519
   106.000  1104.443
   106.500  1105.368
   107.000  1106.296
   107.500  1107.226
   108.000  1108.158
   108.500  1109.092
   109.000  1110.029
   109.500  1110.967
   110.000  1111.908
   110.500  1112.851
   111.000  1113.795
   111.500  1114.742
   112.000  1115.691
   112.500  1116.642
   113.000  1117.594
   113.500  1118.549
   114.000  1119.505
   114.500  1120.464
   115.000  1121.424
   115.500  1122.386
   116.000  1123.350
   116.500  1124.315
   117.000  1125.283
   117.500  1126.252
   118.000  1127.223
   118.500  1128.195
   119.000  1129.169
   119.500  1130.145
   120.000  1131.122
   120.500  1132.101
   121.000  1133.081
   121.500  1134.063
   122.000  1135.047
   122.500  1136.032
   123.000  1137.018
   123.500  1138.006
   124.000  1138.996
   124.500  1139.986
   125.000  1140.978
   125.500  1141.972
   126.000  1142.967
   126.500  1143.963
   127.000  1144.960
   127.500  1145.958
   128.000  1146.958
   128.500  1147.959
   129.000  1148.962
   129.500  1149.965
   130.000  1150.969
   130.500  1151.975
   131.000  1152.981
   131.500  1153.989
   132.000  1154.998
   132.500  1156.008
   133.000  1157.019
   133.500  1158.030
   134.000  1159.043
   134.500  1160.057
   135.000  1161.071
   135.500  1162.087
   136.000  1163.103
   136.500  1164.120
   137.000  1165.138
   137.500  1166.156
   138.000  1167.176
   138.500  1168.196
   139.000  1169.217
   139.500  1170.239
   140.000  1171.261
   140.500  1172.284
   141.000  1173.308
   141.500  1174.332
   142.000  1175.357
   142.500  1176.382
   143.000  1177.408
   143.500  1178.434
   144.000  1179.461
   144.500  1180.489
   145.000  1181.517
   145.500  1182.545
   146.000  1183.574
   146.500  1184.603
   147.000  1185.632
   147.500  1186.662
   148.000  1187.692
   148.500  1188.723
   149.000  1189.754
   149.500  1190.785
   150.000  1191.816
   150.500  1192.847
   151.000  1193.879
   151.500  1194.911
   152.000  1195.943
   152.500  1196.975
   153.000  1198.008
   153.500  1199.040
   154.000  1200.073
   154.500  1201.105
   155.000  1202.138
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1177.003
   145.500  1178.825
   146.000  1180.705
   146.500  1182.622
   147.000  1184.567
   147.500  1186.535
   148.000  1188.523
   148.500  1190.528
   149.000  1192.550
   149.500  1194.585
   150.000  1196.633
   150.500  1198.692
   151.000  1200.762
   151.500  1202.841
   152.000  1204.930
   152.500  1207.027
   153.000  1209.131
   153.500  1211.243
   154.000  1213.362
   154.500  1215.488
   155.000  1217.620
   155.500  1219.757
   156.000  1221.900
   156.500  1224.047
   157.000  1226.200
   157.500  1228.357
   158.000  1230.518
   158.500  1232.683
   159.000  1234.852
   159.500  1237.025
   160.000  1239.202
   160.500  1241.381
   161.000  1243.563
   161.500  1245.749
   162.000  1247.937
   162.500  1250.128
   163.000  1252.321
   163.500  1254.516
   164.000  1256.714
   164.500  1258.913
   165.000  1261.115
   165.500  1263.318
   166.000  1265.523
   166.500  1267.730
   167.000  1269.938
   167.500  1272.148
   168.000  1274.359
   168.500  1276.571
   169.000  1278.784
   169.500  1280.999
   170.000  1283.214
   170.500  1285.431
   171.000  1287.648
   171.500  1289.866
   172.000  1292.085
   172.500  1294.304
   173.000  1296.524
   173.500  1298.745
   174.000  1300.965
   174.500  1303.187
   175.000  1305.409
   175.500  1307.631
   176.000  1309.853
   176.500  1312.076
   177.000  1314.298
   177.500  1316.521
   178.000  1318.744
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1177.001
   145.500  1178.628
   146.000  1180.175
   146.500  1181.665
   147.000  1183.105
   147.500  1184.500
   148.000  1185.852
   148.500  1187.164
   149.000  1188.442
   149.500  1189.690
   150.000  1190.914
   150.500  1192.115
   151.000  1193.295
   151.500  1194.455
   152.000  1195.597
   152.500  1196.722
   153.000  1197.831
   153.500  1198.926
   154.000  1200.007
   154.500  1201.075
   155.000  1202.130
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   510.205
     1.000   510.241
     1.500   510.301
     2.000   510.385
     2.500   510.493
     3.000   510.625
     3.500   510.781
     4.000   510.960
     4.500   511.164
     5.000   511.392
     5.500   511.643
     6.000   511.918
     6.500   512.217
     7.000   512.539
     7.500   512.885
     8.000   513.254
     8.500   513.647
     9.000   514.063
     9.500   514.503
    10.000   514.965
    10.500   515.451
    11.000   515.960
    11.500   516.491
    12.000   517.046
    12.500   517.623
    13.000   518.223
    13.500   518.845
    14.000   519.489
    14.500   520.156
    15.000   520.845
    15.500   521.556
    16.000   522.289
    16.500   523.044
    17.000   523.821
    17.500   524.618
    18.000   525.438
    18.500   526.278
    19.000   527.139
    19.500   528.022
    20.000   528.925
    20.500   529.849
    21.000   530.793
    21.500   531.758
    22.000   532.742
    22.500   533.747
    23.000   534.771
    23.500   535.816
    24.000   536.879
    24.500   537.962
    25.000   539.064
    25.500   540.185
    26.000   541.325
    26.500   542.484
    27.000   543.660
    27.500   544.856
    28.000   546.069
    28.500   547.300
    29.000   548.549
    29.500   549.815
    30.000   551.099
    30.500   552.400
    31.000   553.718
    31.500   555.053
    32.000   556.405
    32.500   557.772
    33.000   559.157
    33.500   560.557
    34.000   561.973
    34.500   563.405
    35.000   564.852
    35.500   566.315
    36.000   567.792
    36.500   569.285
    37.000   570.792
    37.500   572.314
    38.000   573.851
    38.500   575.402
    39.000   576.966
    39.500   578.545
    40.000   580.137
    40.500   581.742
    41.000   583.361
    41.500   584.993
    42.000   586.638
    42.500   588.296
    43.000   589.966
    43.500   591.648
    44.000   593.343
    44.500   595.050
    45.000   596.769
    45.500   598.499
    46.000   600.241
    46.500   601.994
    47.000   603.758
    47.500   605.533
    48.000   607.319
    48.500   609.116
    49.000   610.923
    49.500   612.740
    50.000   614.568
    50.500   616.405
    51.000   618.253
    51.500   620.109
    52.000   621.976
    52.500   623.852
    53.000   625.736
    53.500   627.630
    54.000   629.533
    54.500   631.444
    55.000   633.364
    55.500   635.292
    56.000   637.228
    56.500   639.173
    57.000   641.125
    57.500   643.085
    58.000   645.053
    58.500   647.028
    59.000   649.011
    59.500   651.001
    60.000   652.998
    60.500   655.001
    61.000   657.012
    61.500   659.029
    62.000   661.052
    62.500   663.082
    63.000   665.119
    63.500   667.161
    64.000   669.209
    64.500   671.263
    65.000   673.323
    65.500   675.389
    66.000   677.459
    66.500   679.536
    67.000   681.617
    67.500   683.704
    68.000   685.795
    68.500   687.892
    69.000   689.993
    69.500   692.098
    70.000   694.209
    70.500   696.323
    71.000   698.442
    71.500   700.565
    72.000   702.693
    72.500   704.824
    73.000   706.959
    73.500   709.098
    74.000   711.240
    74.500   713.386
    75.000   715.536
    75.500   717.689
    76.000   719.845
    76.500   722.004
    77.000   724.166
    77.500   726.332
    78.000   728.500
    78.500   730.671
    79.000   732.845
    79.500   735.021
    80.000   737.200
    80.500   739.381
    81.000   741.565
    81.500   743.751
    82.000   745.939
    82.500   748.129
    83.000   750.322
    83.500   752.516
    84.000   754.712
    84.500   756.910
    85.000   759.110
    85.500   761.311
    86.000   763.514
    86.500   765.719
    87.000   767.924
    87.500   770.132
    88.000   772.340
    88.500   774.550
    89.000   776.761
    89.500   778.974
    90.000   781.187
    90.500   783.401
    91.000   785.616
    91.500   787.832
    92.000   790.049
    92.500   792.267
    93.000   794.485
    93.500   796.704
    94.000   798.924
    94.500   801.144
    95.000   803.365
    95.500   805.586
    96.000   807.807
    96.500   810.029
    97.000   812.251
    97.500   814.473
    98.000   816.696
    98.500   818.919
    99.000   821.141
    99.500   823.364
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.925
    29.000   425.483
    29.500   431.040
    30.000   436.596
    30.500   442.151
    31.000   447.704
    31.500   453.256
    32.000   458.806
    32.500   464.354
    33.000   469.898
    33.500   475.439
    34.000   480.977
    34.500   486.510
    35.000   492.039
    35.500   497.563
    36.000   503.081
    36.500   508.594
    37.000   514.099
    37.500   519.598
    38.000   525.089
    38.500   530.571
    39.000   536.045
    39.500   541.509
    40.000   546.963
    40.500   552.407
    41.000   557.840
    41.500   563.260
    42.000   568.669
    42.500   574.065
    43.000   579.447
    43.500   584.816
    44.000   590.170
    44.500   595.510
    45.000   600.834
    45.500   606.142
    46.000   611.434
    46.500   616.710
    47.000   621.968
    47.500   626.731
    48.000   631.302
    48.500   635.868
    49.000   640.429
    49.500   644.986
    50.000   649.538
    50.500   654.084
    51.000   658.625
    51.500   663.161
    52.000   667.691
    52.500   672.215
    53.000   676.734
    53.500   681.246
    54.000   685.751
    54.500   690.249
    55.000   694.737
    55.500   699.216
    56.000   703.684
    56.500   708.144
    57.000   712.597
    57.500   717.046
    58.000   721.489
    58.500   725.928
    59.000   730.363
    59.500   734.794
    60.000   739.221
    60.500   743.644
    61.000   748.063
    61.500   752.479
    62.000   756.890
    62.500   761.298
    63.000   765.702
    63.500   770.102
    64.000   774.497
    64.500   778.888
    65.000   783.274
    65.500   787.655
    66.000   792.030
    66.500   796.398
    67.000   800.760
    67.500   805.115
    68.000   809.463
    68.500   813.803
    69.000   818.135
    69.500   822.460
    70.000   826.778
    70.500   831.088
    71.000   835.390
    71.500   839.685
    72.000   843.972
    72.500   848.252
    73.000   852.524
    73.500   856.788
    74.000   861.045
    74.500   865.294
    75.000   869.534
    75.500   873.767
    76.000   877.992
    76.500   882.209
    77.000   886.418
    77.500   890.618
    78.000   894.810
    78.500   898.993
    79.000   903.168
    79.500   907.335
    80.000   911.493
    80.500   915.642
    81.000   919.783
    81.500   923.915
    82.000   928.039
    82.500   932.155
    83.000   936.261
    83.500   940.360
    84.000   944.449
    84.500   948.531
    85.000   952.603
    85.500   956.667
    86.000   960.722
    86.500   964.768
    87.000   968.805
    87.500   972.834
    88.000   976.853
    88.500   980.864
    89.000   984.866
    89.500   988.859
    90.000   992.843
    90.500   996.818
    91.000  1000.784
    91.500  1004.741
    92.000  1008.689
    92.500  1012.628
    93.000  1016.558
    93.500  1020.479
    94.000  1024.391
    94.500  1028.293
    95.000  1032.187
    95.500  1036.072
    96.000  1039.948
    96.500  1043.814
    97.000  1047.672
    97.500  1051.520
    98.000  1055.360
    98.500  1059.190
    99.000  1063.011
    99.500  1066.823
   100.000  1070.626
   100.500  1074.420
   101.000  1078.204
   101.500  1081.979
   102.000  1085.745
   102.500  1089.502
   103.000  1093.250
   103.500  1096.989
   104.000  1100.719
   104.500  1104.440
   105.000  1108.153
   105.500  1111.856
   106.000  1115.550
   106.500  1119.236
   107.000  1122.912
   107.500  1126.580
   108.000  1130.238
   108.500  1133.887
   109.000  1137.527
   109.500  1141.158
   110.000  1144.780
   110.500  1148.392
   111.000  1151.995
   111.500  1155.588
   112.000  1159.173
   112.500  1162.748
   113.000  1166.314
   113.500  1169.871
   114.000  1173.419
   114.500  1176.957
   115.000  1180.487
   115.500  1184.008
   116.000  1187.519
   116.500  1191.022
   117.000  1194.515
   117.500  1198.000
   118.000  1201.475
   118.500  1204.941
   119.000  1208.398
   119.500  1211.845
   120.000  1215.284
   120.500  1218.713
   121.000  1222.133
   121.500  1225.544
   122.000  1228.946
   122.500  1232.339
   123.000  1235.722
   123.500  1239.096
   124.000  1242.461
   124.500  1245.817
   125.000  1249.164
   125.500  1252.502
   126.000  1255.832
   126.500  1259.152
   127.000  1262.463
   127.500  1265.765
   128.000  1269.059
   128.500  1272.343
   129.000  1275.619
   129.500  1278.885
   130.000  1282.143
   130.500  1285.391
   131.000  1288.631
   131.500  1291.862
   132.000  1295.083
   132.500  1298.296
   133.000  1301.499
   133.500  1304.693
   134.000  1307.879
   134.500  1311.055
   135.000  1314.222
   135.500  1317.380
   136.000  1320.529
   136.500  1323.669
   137.000  1326.800
   137.500  1329.922
   138.000  1333.035
   138.500  1336.139
   139.000  1339.233
   139.500  1342.319
   140.000  1345.395
   140.500  1348.462
   141.000  1351.521
   141.500  1354.570
   142.000  1357.610
   142.500  1360.641
   143.000  1363.663
   143.500  1366.676
   144.000  1369.680
   144.500  1372.675
   145.000  1375.660
   145.500  1378.637
   146.000  1381.604
   146.500  1384.562
   147.000  1387.510
   147.500  1390.450
   148.000  1393.379
   148.500  1396.300
   149.000  1399.211
   149.500  1402.112
   150.000  1405.005
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.587
   100.500   827.810
   101.000   830.033
   101.500   832.255
   102.000   834.478
   102.500   836.701
   103.000   838.924
   103.500   841.147
   104.000   843.370
   104.500   845.592
   105.000   847.815
   105.500   850.038
   106.000   852.261
   106.500   854.484
   107.000   856.707
   107.500   858.929
   108.000   861.152
   108.500   863.375
   109.000   865.598
   109.500   867.821
   110.000   870.044
   110.500   872.266
   111.000   874.489
   111.500   876.712
   112.000   878.935
   112.500   881.158
   113.000   883.381
   113.500   885.603
   114.000   887.826
   114.500   890.049
   115.000   892.272
   115.500   894.495
   116.000   896.718
   116.500   898.940
   117.000   901.163
   117.500   903.386
   118.000   905.609
   118.500   907.832
   119.000   910.055
   119.500   912.278
   120.000   914.500
   120.500   916.723
   121.000   918.946
   121.500   921.169
   122.000   923.392
   122.500   925.615
   123.000   927.837
   123.500   930.060
   124.000   932.283
   124.500   934.506
   125.000   936.729
   125.500   938.951
   126.000   941.174
   126.500   943.397
   127.000   945.620
   127.500   947.843
   128.000   950.066
   128.500   952.289
   129.000   954.511
   129.500   956.734
   130.000   958.957
   130.500   961.180
   131.000   963.403
   131.500   965.626
   132.000   967.848
   132.500   970.071
   133.000   972.294
   133.500   974.517
   134.000   976.740
   134.500   978.963
   135.000   981.185
   135.500   983.408
   136.000   985.631
   136.500   987.854
   137.000   990.077
   137.500   992.299
   138.000   994.522
   138.500   996.745
   139.000   998.968
   139.500  1001.191
   140.000  1003.414
   140.500  1005.637
   141.000  1007.859
   141.500  1010.082
   142.000  1012.305
   142.500  1014.528
   143.000  1016.751
   143.500  1018.974
   144.000  1021.196
   144.500  1023.419
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   386.022
    15.000   396.260
    15.500   406.495
    16.000   416.723
    16.500   426.941
    17.000   437.145
    17.500   447.331
    18.000   457.494
    18.500   467.629
    19.000   477.730
    19.500   487.792
    20.000   497.808
    20.500   507.773
    21.000   517.681
    21.500   527.526
    22.000   537.304
    22.500   547.008
    23.000   555.722
    23.500   563.866
    24.000   571.976
    24.500   580.053
    25.000   588.087
    25.500   596.042
    26.000   603.954
    26.500   611.855
    27.000   619.746
    27.500   627.630
    28.000   635.508
    28.500   643.378
    29.000   651.242
    29.500   659.100
    30.000   666.950
    30.500   674.792
    31.000   682.624
    31.500   690.445
    32.000   698.253
    32.500   706.048
    33.000   713.826
    33.500   721.588
    34.000   729.333
    34.500   737.058
    35.000   744.765
    35.500   752.452
    36.000   760.120
    36.500   767.767
    37.000   775.395
    37.500   783.002
    38.000   790.587
    38.500   798.151
    39.000   805.693
    39.500   813.212
    40.000   820.709
    40.500   828.182
    41.000   835.632
    41.500   843.058
    42.000   850.461
    42.500   857.839
    43.000   865.193
    43.500   872.523
    44.000   879.827
    44.500   887.107
    45.000   894.362
    45.500   901.591
    46.000   908.795
    46.500   915.973
    47.000   923.125
    47.500   930.250
    48.000   937.349
    48.500   944.421
    49.000   951.466
    49.500   958.484
    50.000   965.475
    50.500   972.439
    51.000   979.375
    51.500   986.285
    52.000   993.166
    52.500  1000.020
    53.000  1006.847
    53.500  1013.647
    54.000  1020.422
    54.500  1027.171
    55.000  1033.893
    55.500  1040.587
    56.000  1047.255
    56.500  1053.894
    57.000  1060.506
    57.500  1067.089
    58.000  1073.644
    58.500  1080.172
    59.000  1086.671
    59.500  1093.143
    60.000  1099.588
    60.500  1106.005
    61.000  1112.394
    61.500  1118.755
    62.000  1125.087
    62.500  1131.391
    63.000  1137.667
    63.500  1143.914
    64.000  1150.133
    64.500  1156.324
    65.000  1162.486
    65.500  1168.620
    66.000  1174.726
    66.500  1180.803
    67.000  1186.852
    67.500  1192.873
    68.000  1198.865
    68.500  1204.828
    69.000  1210.763
    69.500  1216.669
    70.000  1222.546
    70.500  1228.395
    71.000  1234.215
    71.500  1240.006
    72.000  1245.768
    72.500  1251.500
    73.000  1257.203
    73.500  1262.875
    74.000  1268.518
    74.500  1274.131
    75.000  1279.714
    75.500  1285.267
    76.000  1290.791
    76.500  1296.286
    77.000  1301.751
    77.500  1307.187
    78.000  1312.592
    78.500  1317.966
    79.000  1323.310
    79.500  1328.625
    80.000  1333.911
    80.500  1339.168
    81.000  1344.394
    81.500  1349.589
    82.000  1354.752
    82.500  1359.883
    83.000  1364.983
    83.500  1370.051
    84.000  1375.088
    84.500  1380.094
    85.000  1385.068
    85.500  1390.012
    86.000  1394.923
    86.500  1399.803
    87.000  1404.651
    87.500  1409.465
    88.000  1414.248
    88.500  1418.996
    89.000  1423.712
    89.500  1428.394
    90.000  1433.042
    90.500  1437.657
    91.000  1442.238
    91.500  1446.785
    92.000  1451.298
    92.500  1455.778
    93.000  1460.223
    93.500  1464.635
    94.000  1469.020
    94.500  1473.388
    95.000  1477.743
    95.500  1482.086
    96.000  1486.418
    96.500  1490.737
    97.000  1495.039
    97.500  1499.322
    98.000  1503.584
    98.500  1507.826
    99.000  1512.049
    99.500  1516.252
   100.000  1520.433
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   721.244
     1.000   721.290
     1.500   721.368
     2.000   721.477
     2.500   721.617
     3.000   721.788
     3.500   721.990
     4.000   722.223
     4.500   722.487
     5.000   722.782
     5.500   723.108
     6.000   723.464
     6.500   723.851
     7.000   724.268
     7.500   724.716
     8.000   725.193
     8.500   725.702
     9.000   726.240
     9.500   726.808
    10.000   727.406
    10.500   728.033
    11.000   728.690
    11.500   729.377
    12.000   730.092
    12.500   730.837
    13.000   731.610
    13.500   732.412
    14.000   733.243
    14.500   734.101
    15.000   734.988
    15.500   735.903
    16.000   736.845
    16.500   737.815
    17.000   738.812
    17.500   739.835
    18.000   740.886
    18.500   741.963
    19.000   743.067
    19.500   744.196
    20.000   745.351
    20.500   746.532
    21.000   747.738
    21.500   748.969
    22.000   750.224
    22.500   751.504
    23.000   752.808
    23.500   754.136
    24.000   755.488
    24.500   756.863
    25.000   758.261
    25.500   759.682
    26.000   761.125
    26.500   762.590
    27.000   764.077
    27.500   765.586
    28.000   767.115
    28.500   768.666
    29.000   770.237
    29.500   771.829
    30.000   773.440
    30.500   775.071
    31.000   776.722
    31.500   778.391
    32.000   780.079
    32.500   781.785
    33.000   783.510
    33.500   785.251
    34.000   787.011
    34.500   788.787
    35.000   790.580
    35.500   792.390
    36.000   794.215
    36.500   796.056
    37.000   797.912
    37.500   799.784
    38.000   801.670
    38.500   803.570
    39.000   805.485
    39.500   807.413
    40.000   809.354
    40.500   811.309
    41.000   813.276
    41.500   815.255
    42.000   817.246
    42.500   819.249
    43.000   821.264
    43.500   823.289
    44.000   825.325
    44.500   827.372
    45.000   829.428
    45.500   831.494
    46.000   833.569
    46.500   835.654
    47.000   837.747
    47.500   839.849
    48.000   841.958
    48.500   844.076
    49.000   846.201
    49.500   848.333
    50.000   850.472
    50.500   852.617
    51.000   854.769
    51.500   856.926
    52.000   859.089
    52.500   861.258
    53.000   863.432
    53.500   865.610
    54.000   867.793
    54.500   869.981
    55.000   872.172
    55.500   874.367
    56.000   876.565
    56.500   878.767
    57.000   880.972
    57.500   883.179
    58.000   885.389
    58.500   887.601
    59.000   889.815
    59.500   892.031
    60.000   894.248
    60.500   896.467
    61.000   898.687
    61.500   900.908
    62.000   903.129
    62.500   905.352
    63.000   907.574
    63.500   909.797
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   933.298
     1.000   933.364
     1.500   933.475
     2.000   933.630
     2.500   933.829
     3.000   934.073
     3.500   934.360
     4.000   934.692
     4.500   935.067
     5.000   935.487
     5.500   935.950
     6.000   936.457
     6.500   937.008
     7.000   937.603
     7.500   938.241
     8.000   938.922
     8.500   939.647
     9.000   940.414
     9.500   941.225
    10.000   942.078
    10.500   942.974
    11.000   943.912
    11.500   944.893
    12.000   945.916
    12.500   946.981
    13.000   948.087
    13.500   949.235
    14.000   950.425
    14.500   951.655
    15.000   952.927
    15.500   954.239
    16.000   955.591
    16.500   956.984
    17.000   958.417
    17.500   959.889
    18.000   961.401
    18.500   962.952
    19.000   964.542
    19.500   966.171
    20.000   967.838
    20.500   969.544
    21.000   971.287
    21.500   973.068
    22.000   974.886
    22.500   976.741
    23.000   978.632
    23.500   980.561
    24.000   982.525
    24.500   984.525
    25.000   986.560
    25.500   988.631
    26.000   990.736
    26.500   992.876
    27.000   995.051
    27.500   997.259
    28.000   999.501
    28.500  1001.776
    29.000  1004.084
    29.500  1006.424
    30.000  1008.797
    30.500  1011.202
    31.000  1013.638
    31.500  1016.105
    32.000  1018.604
    32.500  1021.133
    33.000  1023.692
    33.500  1026.282
    34.000  1028.901
    34.500  1031.549
    35.000  1034.226
    35.500  1036.931
    36.000  1039.665
    36.500  1042.427
    37.000  1045.216
    37.500  1048.033
    38.000  1050.876
    38.500  1053.746
    39.000  1056.642
    39.500  1059.564
    40.000  1062.512
    40.500  1065.485
    41.000  1068.483
    41.500  1071.505
    42.000  1074.551
    42.500  1077.622
    43.000  1080.716
    43.500  1083.833
    44.000  1086.973
    44.500  1090.136
    45.000  1093.321
    45.500  1096.528
    46.000  1099.757
    46.500  1103.007
    47.000  1106.278
    47.500  1109.570
    48.000  1112.882
    48.500  1116.214
    49.000  1119.566
    49.500  1122.938
    50.000  1126.328
    50.500  1129.738
    51.000  1133.166
    51.500  1136.613
    52.000  1140.077
    52.500  1143.559
    53.000  1147.059
    53.500  1150.576
    54.000  1154.109
    54.500  1157.659
    55.000  1161.226
    55.500  1164.808
    56.000  1168.406
    56.500  1172.020
    57.000  1175.649
    57.500  1179.292
    58.000  1182.950
    58.500  1186.623
    59.000  1190.310
    59.500  1194.011
    60.000  1197.725
    60.500  1201.453
    61.000  1205.193
    61.500  1208.947
    62.000  1212.713
    62.500  1216.492
    63.000  1220.282
    63.500  1224.085
    64.000  1227.899
    64.500  1231.725
    65.000  1235.561
    65.500  1239.409
    66.000  1243.267
    66.500  1247.136
    67.000  1251.016
    67.500  1254.905
    68.000  1258.804
    68.500  1262.713
    69.000  1266.631
    69.500  1270.558
    70.000  1274.494
    70.500  1278.439
    71.000  1282.392
    71.500  1286.354
    72.000  1290.324
    72.500  1294.302
    73.000  1298.288
    73.500  1302.282
    74.000  1306.282
    74.500  1310.290
    75.000  1314.305
    75.500  1318.327
    76.000  1322.355
    76.500  1326.390
    77.000  1330.431
    77.500  1334.478
    78.000  1338.531
    78.500  1342.590
    79.000  1346.655
    79.500  1350.724
    80.000  1354.800
    80.500  1358.880
    81.000  1362.965
    81.500  1367.055
    82.000  1371.149
    82.500  1375.248
    83.000  1379.351
    83.500  1383.458
    84.000  1387.570
    84.500  1391.685
    85.000  1395.804
    85.500  1399.926
    86.000  1404.052
    86.500  1408.181
    87.000  1412.313
    87.500  1416.449
    88.000  1420.587
    88.500  1424.727
    89.000  1428.871
    89.500  1433.016
    90.000  1437.165
    90.500  1441.315
    91.000  1445.467
    91.500  1449.622
    92.000  1453.778
    92.500  1457.936
    93.000  1462.095
    93.500  1466.256
    94.000  1470.419
    94.500  1474.582
    95.000  1478.747
    95.500  1482.913
    96.000  1487.080
    96.500  1491.247
    97.000  1495.415
    97.500  1499.584
    98.000  1503.753
    98.500  1507.923
    99.000  1512.093
    99.500  1516.263
   100.000  1520.433
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.976
    29.500   784.215
    30.000   794.454
    30.500   804.690
    31.000   814.924
    31.500   825.155
    32.000   835.381
    32.500   845.603
    33.000   855.818
    33.500   866.027
    34.000   876.228
    34.500   886.420
    35.000   896.602
    35.500   906.773
    36.000   916.931
    36.500   927.076
    37.000   937.205
    37.500   947.317
    38.000   957.412
    38.500   967.091
    39.000   977.542
    39.500   987.573
    40.000   997.581
    40.500  1007.562
    41.000  1017.517
    41.500  1027.444
    42.000  1037.340
    42.500  1047.206
    43.000  1057.038
    43.500  1066.837
    44.000  1076.601
    44.500  1086.329
    45.000  1096.020
    45.500  1105.434
    46.000  1113.605
    46.500  1121.758
    47.000  1129.895
    47.500  1138.015
    48.000  1146.119
    48.500  1154.206
    49.000  1162.276
    49.500  1170.325
    50.000  1178.349
    50.500  1186.336
    51.000  1194.267
    51.500  1202.183
    52.000  1210.093
    52.500  1217.996
    53.000  1225.894
    53.500  1233.788
    54.000  1241.678
    54.500  1249.564
    55.000  1257.447
    55.500  1265.326
    56.000  1273.202
    56.500  1281.074
    57.000  1288.944
    57.500  1296.809
    58.000  1304.672
    58.500  1312.531
    59.000  1320.387
    59.500  1328.240
    60.000  1336.088
    60.500  1343.933
    61.000  1351.773
    61.500  1359.608
    62.000  1367.438
    62.500  1375.263
    63.000  1383.081
    63.500  1390.894
    64.000  1398.699
    64.500  1406.498
    65.000  1414.289
    65.500  1422.073
    66.000  1429.848
    66.500  1437.615
    67.000  1445.373
    67.500  1453.123
    68.000  1460.864
    68.500  1468.595
    69.000  1476.317
    69.500  1484.029
    70.000  1491.732
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     1.222    38.484     0.150
     6.161    94.484     0.150
     6.161    94.684     0.150
     8.635   125.285     0.150
    12.231   380.484     0.150
    15.689    35.000     0.150
    17.547   274.484     0.150
    20.382   279.885     0.150
     1.267    24.309     0.150
     5.184   163.109     0.150
     5.801   182.609     0.150
     6.114    97.109     0.150
     6.114    93.309     0.150
     7.143   229.109     0.150
     8.640   268.109     0.150
    18.818   261.109     0.150
    20.756   281.109     0.150
     1.191    22.008     0.150
     3.823    39.906     0.150
     6.155    94.707     0.150
     8.608   269.707     0.150
     8.771   123.707     0.150
     9.932   146.707     0.150
     9.932   146.707     0.150
    12.141   174.207     0.150
    12.202   173.307     0.150
    17.541   552.707     0.150
    18.573   257.107     0.150
    18.740   258.707     0.150
    20.352   278.207     0.150
    21.668   290.707     0.150
    25.123   321.707     0.150
    29.078   365.707     0.150
    33.343   396.707     0.150
    33.343   396.707     0.150
    33.665   383.707     0.150
    33.665   383.707     0.150
    46.348   505.707     0.150
    46.348     5.000     0.150
    49.088   526.607     0.150
    58.797   597.707     0.150
    59.070   607.508     0.150
    61.192   613.707     0.150
    62.318   621.707     0.150
    63.687   630.508     0.150
    63.687  1139.008     0.150
    67.136   654.207     0.150
    73.142   686.707     0.150
    73.142   686.707     0.150
    73.665   693.707     0.150
    78.206   718.707     0.150
    78.474   721.207     0.150
   105.208   876.906     0.150
     8.617   124.551     0.150
     9.938   146.051     0.150
    12.153   174.750     0.150
    18.570   445.551     0.150
    18.570   257.051     0.150
    18.570   445.551     0.150
    18.747   258.551     0.150
    20.364   276.852     0.150
    21.679   290.652     0.150
    24.090   321.551     0.150
    24.090   364.551     0.150
    24.811   606.551     0.150
    25.128   332.051     0.150
    25.128   338.051     0.150
    25.501   355.551     0.150
    25.501   378.551     0.150
    26.371   340.551     0.150
    33.338   403.551     0.150
    33.338    18.000     0.150
    33.338   403.551     0.150
    33.338    18.000     0.150
    33.658   404.051     0.150
    35.284   414.551     0.150
    35.284   740.551     0.150
    38.425   435.250     0.150
    39.153    22.000     0.150
    39.153   447.551     0.150
    39.153    22.000     0.150
    45.317   504.551     0.150
    45.317   504.551     0.150
    45.317   898.352     0.150
    46.351   505.551     0.150
    56.997   586.551     0.150
    56.997   586.551     0.150
    58.795   598.551     0.150
    59.079   598.551     0.150
    59.771   608.352     0.150
    62.322   622.551     0.150
    63.688   630.852     0.150
    65.076   639.551     0.150
    67.298   653.750     0.150
    68.924   660.551     0.150
    78.481   721.551     0.150
     1.340    22.266     0.150
     1.340    43.070     0.150
     1.791    29.352     0.150
     1.352    21.676     0.150
     1.599    51.723     0.150
     1.795    54.633     0.150
     2.177    69.523     0.150
     3.632    56.523     0.150
     4.745    70.766     0.150
     6.679    95.125     0.150
     6.972   128.125     0.150
     8.631   155.613     0.150
     1.343    21.473     0.150
     1.811    54.125     0.150
     2.184    39.906     0.150
     2.184    70.094     0.150
     2.577    39.684     0.150
     3.543    97.293     0.150
     8.629   127.484     0.150
    21.666   295.984     0.150
     1.660    53.391     0.150
     3.890    52.638     0.150
     5.259    81.788     0.150
     0.468    18.465     0.150
     1.391    41.066     0.150
     1.470    25.465     0.150
     1.700    28.367     0.150
     1.885    30.266     0.150
     1.943    58.566     0.150
     2.244    71.266     0.150
     2.244    70.465     0.150
     2.667    43.164     0.150
     3.368    53.766     0.150
     3.755    59.266     0.150
     4.905    75.215     0.150
     6.074    95.766     0.150
    12.075   169.965     0.150
     1.198    37.680     0.150
     1.661    52.281     0.150
     3.582    45.480     0.150
     5.305    77.418     0.150
     5.635    82.910     0.150
     6.090    88.281     0.150
     0.345     5.539     0.150
     0.537    19.039     0.150
     0.620    21.734     0.150
     1.728    28.641     0.150
     1.959    61.336     0.150
     4.896    75.086     0.150
     5.202    76.398     0.150
     5.202   148.680     0.150
     5.564    83.539     0.150
     5.967    89.039     0.150
     0.278     8.047     0.150
     0.748    14.977     0.150
     1.047   -35.750     0.150
     1.047    34.453     0.150
     1.203    40.508     0.150
     1.421    43.562     0.150
     2.407    42.047     0.150
     3.508    44.562     0.150
     3.852    62.602     0.150
     8.532   127.203     0.150
     0.569    20.422     0.150
     0.681    24.910     0.150
     1.135    35.842     0.150
     3.853    55.441     0.150
     4.095    60.570     0.150
     0.678    24.816     0.150
     1.146    36.965     0.150
     2.411    35.086     0.150
     2.411    69.586     0.150
     3.512    55.305     0.150
     3.857    55.234     0.150
     4.873    71.086     0.150
     5.202    74.285     0.150
     5.684    80.586     0.150
    48.002   509.688     0.150
     0.427    14.803     0.150
     0.621    29.803     0.150
     0.859    16.604     0.150
     0.859    29.902     0.150
     1.253    40.402     0.150
     1.541    49.902     0.150
     3.658    55.002     0.150
     5.108   140.445     0.150
     5.108   163.178     0.150
     8.576   221.152     0.150
     8.761   129.703     0.150
    12.115   311.201     0.150
    24.533   321.773     0.150
    36.503   428.873     0.150
     1.268    41.484     0.150
     1.548    49.887     0.150
     3.751   112.184     0.150
     5.118    80.684     0.150
     5.097    90.809     0.150
     8.776   132.684     0.150
    21.432   294.785     0.150
     0.469    18.006     0.150
     1.789    31.064     0.150
     1.789    54.516     0.150
     2.304    38.135     0.150
     2.304    39.715     0.150
     2.304    67.676     0.150
     2.304    69.145     0.150
     5.005    75.965     0.150
     5.005    76.945     0.150
     5.005   155.525     0.150
     2.276    42.457     0.150
     2.276    72.309     0.150
     3.148    51.285     0.150
     5.421    81.219     0.150
     8.634   261.277     0.150
    12.082   310.445     0.150
    21.420   294.008     0.150
    27.519   349.406     0.150
    39.030   446.160     0.150
     1.371    24.969     0.150
     1.371    42.617     0.150
     2.526    72.812     0.150
     2.378    39.414     0.150
     2.378    69.812     0.150
     4.792    75.320     0.150
     6.069    93.484     0.150
     3.176    47.098     0.150
     4.545    67.727     0.150
     5.213    78.438     0.150
     5.213    93.762     0.150
     5.213    93.789     0.150
     5.287    81.828     0.150
     5.689   102.328     0.150
     5.689    82.840     0.150
     5.689   102.328     0.150
     5.689   148.727     0.150
     5.689   176.188     0.150
     6.039    89.367     0.150
     8.546   218.688     0.150
    10.261   147.363     0.150
    10.261   147.367     0.150
    12.175   170.438     0.150
    12.181   176.840     0.150
    12.181   173.137     0.150
    12.181   381.938     0.150
    25.616   331.277     0.150
    25.616   331.281     0.150
    41.087   462.172     0.150
    50.112   533.102     0.150
    58.177   592.738     0.150
    58.177   592.734     0.150
     0.591    20.180     0.150
     0.591    10.566     0.150
     0.591    20.180     0.150
     0.683    24.598     0.150
     1.013    17.609     0.150
     1.080    18.496     0.150
     1.170    20.387     0.150
     1.521    48.008     0.150
     1.521    25.977     0.150
     1.521    48.020     0.150
     3.850    60.949     0.150
     1.163    21.516     0.150
     2.292    38.961     0.150
     2.292    42.414     0.150
     2.292    69.641     0.150
     2.292    72.422     0.150
     5.079    76.016     0.150
     5.359    81.617     0.150
     5.411    79.141     0.150
     5.422    80.641     0.150
     6.627    96.406     0.150
     7.683   112.797     0.150
     8.411   262.625     0.150
     8.600   124.672     0.150
     8.600   257.391     0.150
     8.600   124.602     0.150
     8.600   124.797     0.150
     8.798   126.445     0.150
     8.798   127.945     0.150
     9.897   149.883     0.150
     9.990   147.914     0.150
     9.990   250.445     0.150
    10.118   262.070     0.150
    10.118   315.992     0.150
    10.118   147.016     0.150
    10.118   262.062     0.150
    10.118   315.992     0.150
    12.102   172.445     0.150
    12.106   171.695     0.150
    12.106   375.781     0.150
    17.507   245.875     0.150
    21.782   293.844     0.150
    24.176   321.141     0.150
    24.176   354.844     0.150
    24.176   623.344     0.150
    26.155   336.344     0.150
    31.284   381.242     0.150
    31.956   386.297     0.150
    36.470   424.852     0.150
    37.324   433.742     0.150
    37.779   439.242     0.150
    39.637   452.742     0.150
    39.637   450.625     0.150
    40.584  1030.945     0.150
    45.923   604.844     0.150
    48.695   520.844     0.150
    48.695   966.344     0.150
    53.174     5.297     0.150
    53.174     9.102     0.150
    53.174   557.344     0.150
    53.696     4.477     0.150
    55.648   773.844     0.150
    55.648  1261.445     0.150
    57.051   584.914     0.150
    57.080   588.141     0.150
    57.599   592.047     0.150
    57.599   592.047     0.150
    57.596   803.047     0.150
    58.052   588.945     0.150
    60.469   647.945     0.150
    60.560   605.844     0.150
    60.940   612.617     0.150
    61.130   614.242     0.150
    61.130   614.242     0.150
    63.903   908.445     0.150
    64.464   643.047     0.150
    64.464   782.844     0.150
    64.464   874.742     0.150
    66.710   649.641     0.150
    66.710     4.805     0.150
    66.710   649.641     0.150
    66.710     4.805     0.150
    66.971   652.641     0.150
    67.125   653.047     0.150
    67.125   653.047     0.150
    67.125   653.047     0.150
    67.279   653.945     0.150
    67.279     4.602     0.150
    67.279   876.945     0.150
    67.978   658.844     0.150
    67.978     4.500     0.150
    68.016    13.102     0.150
    68.263    10.297     0.150
    68.263   674.742     0.150
    68.263  1216.844     0.150
    68.410   654.742     0.150
    68.643   660.445     0.150
    68.730   668.742     0.150
    68.762   663.445     0.150
    68.787   664.047     0.150
    68.913   663.844     0.150
    69.134   662.344     0.150
    69.210   666.242     0.150
    69.461   666.742     0.150
    69.548   671.836     0.150
    69.594   672.742     0.150
    69.598   923.945     0.150
    70.268   672.445     0.150
    70.286   678.641     0.150
    70.286     0.000     0.150
    70.302   689.344     0.150
    70.522   680.742     0.150
    70.522     0.000     0.150
    70.599   679.281     0.150
    70.864   680.695     0.150
    70.939   683.344     0.150
    70.939     0.000     0.150
    71.046    10.500     0.150
    71.975   692.547     0.150
    72.708    10.656     0.150
    73.210   735.242     0.150
    73.682   689.641     0.150
    74.024   695.852     0.150
    74.279   691.797     0.150
    76.268   713.844     0.150
    76.548   883.547     0.150
    76.651   715.844     0.150
    76.654  1791.742     0.150
    76.798   717.844     0.150
    77.352   719.844     0.150
    77.854  1616.141     0.150
    78.587   726.844     0.150
    78.687   726.844     0.150
    78.777   732.844     0.150
    78.896   731.844     0.150
    79.305   720.516     0.150
    79.477   733.344     0.150
    83.546   752.242     0.150
    83.572  1690.242     0.150
    84.246   765.531     0.150
    84.246   959.086     0.150
    84.780   932.742     0.150
    87.261   962.641     0.150
    94.967   805.422     0.150
   135.924  1160.477     0.150
     0.434    15.227     0.150
     0.867    30.391     0.150
     1.180    20.578     0.150
     2.307    41.227     0.150
     2.307    72.109     0.150
     6.181    94.477     0.150
     8.422   154.656     0.150
     8.616   158.328     0.150
     9.902   147.852     0.150
     9.997   147.883     0.150
    10.117   262.555     0.150
    11.941   164.867     0.150
    12.117   171.578     0.150
    13.481   418.367     0.150
    13.695   197.633     0.150
    13.695   428.047     0.150
    13.727   198.250     0.150
    14.491   465.062     0.150
    14.611   403.227     0.150
    18.863   262.508     0.150
    22.738   705.828     0.150
    24.176   324.781     0.150
    24.176   351.578     0.150
    31.282   381.477     0.150
    31.973   387.180     0.150
    33.605   395.883     0.150
    33.605   490.578     0.150
    41.926   469.758     0.150
    45.355   503.883     0.150
    50.199   535.328     0.150
    57.066   586.352     0.150
    58.048   592.680     0.150
    58.048     4.102     0.150
    58.261   594.258     0.150
    63.901     7.398     0.150
    63.901   906.383     0.150
    64.049   632.047     0.150
    65.082   645.281     0.150
    65.342   639.953     0.150
    67.141   657.578     0.150
    67.141   657.578     0.150
    67.141   657.578     0.150
    68.010   655.180     0.150
    68.157   661.281     0.150
    68.258    10.305     0.150
    68.258   675.281     0.150
    68.929   670.883     0.150
    68.929   670.180     0.150
    69.498     7.000     0.150
    69.598     2.398     0.150
    69.598     3.898     0.150
    71.045     9.898     0.150
    76.284   711.883     0.150
    76.554   876.977     0.150
    80.359   732.078     0.150
    84.251   765.789     0.150
     2.294    38.234     0.150
     2.294    41.352     0.150
     2.294    67.938     0.150
     2.294    71.383     0.150
     5.418    81.172     0.150
     5.820   186.438     0.150
     6.172    95.781     0.150
     8.597   127.609     0.150
     8.597   127.617     0.150
     8.597   219.211     0.150
     8.597   269.305     0.150
     8.597   127.734     0.150
     8.597   265.672     0.150
     0.888    29.352     0.150
     1.348    25.051     0.150
     2.277    38.621     0.150
     2.277    41.789     0.150
     2.277    72.242     0.150
     3.509    55.031     0.150
     5.079    77.789     0.150
     5.356    80.992     0.150
     8.571   266.609     0.150
     8.782   129.879     0.150
    12.084   173.820     0.150
    12.084   173.879     0.150
    12.088   172.371     0.150
    12.088   379.012     0.150
    20.623   281.789     0.150
    36.476   425.371     0.150
     2.295    38.789     0.150
     0.867    16.721     0.150
     0.867    27.072     0.150
     1.086    19.711     0.150
     1.086    33.842     0.150
     1.086    19.711     0.150
     1.086    33.842     0.150
     2.272    40.041     0.150
     2.296    38.711     0.150
     2.296    70.512     0.150
     2.239    37.002     0.150
     2.941    49.131     0.150
     3.294    54.822     0.150
     5.196    92.742     0.150
     5.196   162.072     0.150
     5.596    86.912     0.150
    10.980   157.971     0.150
    11.591   166.602     0.150
     0.633    22.820     0.150
     2.298    41.664     0.150
     2.298    71.773     0.150
     3.504    56.938     0.150
     3.954    61.688     0.150
     5.087    89.797     0.150
     6.152   187.578     0.150
     6.168    88.312     0.150
    23.304   301.828     0.150
     1.720    29.727     0.150
     2.353    38.773     0.150
     2.353    69.125     0.150
     2.113    64.156     0.150
     3.954    59.758     0.150
     0.226     4.730     0.150
     0.460     8.562     0.150
     0.460    15.812     0.150
     0.947    17.621     0.150
     0.947    30.293     0.150
     1.125    20.883     0.150
     1.125    36.074     0.150
     1.167    36.902     0.150
     1.280    41.082     0.150
     1.366    24.914     0.150
     1.366    43.141     0.150
     1.496    47.824     0.150
     1.496    27.773     0.150
     1.496    47.824     0.150
     1.429    26.594     0.150
     1.429    45.480     0.150
     1.580    26.652     0.150
     1.741    30.562     0.150
     1.733    31.031     0.150
     1.733    54.742     0.150
     1.788    56.773     0.150
     2.112    66.582     0.150
     2.112    36.422     0.150
     2.112    66.582     0.150
     2.349    44.883     0.150
     2.349    73.383     0.150
     2.400    40.582     0.150
     3.124    48.773     0.150
     5.282   164.281     0.150
     5.174    83.619     0.150
     0.534     9.888     0.150
     0.583    21.567     0.150
     1.163    37.997     0.150
     1.227    22.348     0.150
     1.590    26.968     0.150
     1.644    52.768     0.150
     1.710    54.478     0.150
     2.398    39.928     0.150
     3.893    60.667     0.150
     4.057    61.947     0.150
     4.854   140.567     0.150
     5.061   139.888     0.150
     5.219   152.287     0.150
     5.868    84.747     0.150
     6.018   150.378     0.150
     0.356    13.387     0.150
     0.529     9.637     0.150
     0.681    24.396     0.150
     0.789    14.787     0.150
     0.963    18.156     0.150
     1.347    25.127     0.150
     1.266    23.727     0.150
     1.650    54.178     0.150
     1.719    30.646     0.150
     1.719    54.977     0.150
     1.777    30.947     0.150
     2.318    73.387     0.150
     2.373    39.707     0.150
     3.892    60.736     0.150
     3.967    61.268     0.150
     4.346    69.916     0.150
     5.086    78.367     0.150
     5.194    85.871     0.150
     5.194   162.197     0.150
     5.455    84.496     0.150
     5.668    83.018     0.150
     5.712    79.547     0.150
     5.712    87.297     0.150
     5.712   145.547     0.150
     5.712   174.338     0.150
     5.712    79.547     0.150
     5.712   145.547     0.150
     5.712   174.336     0.150
     5.847    90.977     0.150
     6.039    92.348     0.150
     6.612   200.537     0.150
     7.144   179.416     0.150
     8.560   123.646     0.150
     8.560   218.223     0.150
     8.560   266.297     0.150
     9.507   136.717     0.150
    25.592   324.557     0.150
    25.592   324.561     0.150
     0.548     9.734     0.150
     0.548    16.953     0.150
     0.548     9.854     0.150
     0.613    11.385     0.150
     0.845    15.793     0.150
     0.845    27.395     0.150
     1.004    16.725     0.150
     1.038    18.703     0.150
     1.038    33.334     0.150
     1.083    33.783     0.150
     1.095    32.264     0.150
     1.095    18.475     0.150
     1.136    21.094     0.150
     1.136    36.504     0.150
     1.274    23.654     0.150
     1.308    38.734     0.150
     1.308    22.104     0.150
     1.382    25.254     0.150
     1.380    23.064     0.150
     1.608    27.953     0.150
     1.727    54.344     0.150
     1.727    28.645     0.150
     1.769    29.385     0.150
     1.892    31.684     0.150
     2.182    37.135     0.150
     2.361    74.543     0.150
     2.749    44.264     0.150
     3.648    59.064     0.150
     0.340     6.160     0.150
     0.588    11.510     0.150
     0.588    21.070     0.150
     0.553    10.031     0.150
     0.700    24.900     0.150
     0.801    14.090     0.150
     0.867    16.471     0.150
     0.867    29.432     0.150
     0.923    15.590     0.150
     0.923    27.250     0.150
     0.962    18.381     0.150
     1.581    26.611     0.150
     1.683    51.820     0.150
     1.829    32.230     0.150
     2.391    40.301     0.150
     3.343    93.611     0.150
     3.314    54.352     0.150
     1.315    40.551     0.150
     0.332    11.391     0.150
     0.531     9.820     0.150
     0.677    12.320     0.150
     0.677    24.195     0.150
     0.801    24.695     0.150
     0.812    15.320     0.150
     0.870    16.281     0.150
     0.870    28.836     0.150
     0.980    18.430     0.150
     1.165    21.398     0.150
     1.165    37.891     0.150
     1.192    20.477     0.150
     1.359    25.320     0.150
     1.284    24.164     0.150
     1.593    27.055     0.150
     1.714    54.438     0.150
     1.714    30.516     0.150
     1.724    29.734     0.150
     1.836    31.680     0.150
     2.285    71.008     0.150
     6.696    92.656     0.150
     0.413     7.613     0.150
     0.413    13.822     0.150
     0.431     7.822     0.150
     0.676    13.152     0.150
     0.776    14.463     0.150
     0.776    14.434     0.150
     0.776    24.934     0.150
     0.918    16.053     0.150
     0.918    29.793     0.150
     0.977    18.172     0.150
     0.977    31.992     0.150
     1.000    18.662     0.150
     1.000    18.693     0.150
     1.000    32.162     0.150
     1.000    18.715     0.150
     1.000    32.262     0.150
     1.066    18.232     0.150
     1.202    21.822     0.150
     1.202    37.953     0.150
     1.202    21.768     0.150
     1.261    23.012     0.150
     1.261    23.043     0.150
     1.280    41.092     0.150
     1.280    21.934     0.150
     1.280    41.092     0.150
     1.295    24.303     0.150
     1.295    41.873     0.150
     1.410    26.172     0.150
     1.410    44.912     0.150
     1.410    44.949     0.150
     1.315    22.482     0.150
     1.315    41.393     0.150
     1.667    28.512     0.150
     1.667    51.863     0.150
     1.719    29.152     0.150
     1.719    53.633     0.150
     1.756    31.434     0.150
     1.756    31.412     0.150
     1.756    55.453     0.150
     1.756    31.412     0.150
     1.829    32.643     0.150
     1.829    32.604     0.150
     1.829    57.232     0.150
     1.851    31.912     0.150
     1.851    57.293     0.150
     1.928    61.309     0.150
     2.130    38.123     0.150
     2.130    66.893     0.150
     2.330    39.023     0.150
     2.330    70.043     0.150
     2.797    45.193     0.150
     2.882    46.447     0.150
     3.173    51.592     0.150
     3.291    51.812     0.150
     3.982    62.623     0.150
     3.982   108.842     0.150
     4.136    64.098     0.150
     5.105    92.184     0.150
     5.306    79.629     0.150
     8.411   121.223     0.150
     0.846    28.166     0.150
     1.380    45.076     0.150
     2.375    75.268     0.150
     1.289    39.615     0.150
     2.463    76.477     0.150
     0.393     7.344     0.150
     0.425     7.715     0.150
     0.565    10.023     0.150
     0.689    13.604     0.150
     0.790    14.574     0.150
     1.027    19.055     0.150
     1.027    33.135     0.150
     1.027    19.051     0.150
     1.027    33.221     0.150
     1.218    21.943     0.150
     1.275    23.375     0.150
     1.275    23.352     0.150
     1.320    24.354     0.150
     1.795    31.885     0.150
     1.795    57.625     0.150
     1.795    31.824     0.150
     1.868    60.344     0.150
     2.464    41.953     0.150
     2.464    76.523     0.150
     2.464    41.900     0.150
     2.724    44.756     0.150
     2.919    47.254     0.150
     3.191    51.975     0.150
     3.315    52.744     0.150
     3.500    54.396     0.150
     3.574    57.354     0.150
     4.020    63.064     0.150
     4.250    64.264     0.150
     4.742    72.525     0.150
     4.860    73.154     0.150
     4.998    74.094     0.150
     5.085   155.084     0.150
     5.606    82.414     0.150
     7.741   113.273     0.150
     8.664   120.674     0.150
     8.664   219.564     0.150
     0.676    21.082     0.150
     1.010    29.691     0.150
     2.483    45.691     0.150
     0.377    12.641     0.150
     0.491     9.121     0.150
     0.491    16.812     0.150
     0.491     9.109     0.150
     0.635    12.473     0.150
     0.635    22.613     0.150
     0.649    23.301     0.150
     0.705    12.418     0.150
     0.780    14.613     0.150
     0.780    14.613     0.150
     0.780    25.191     0.150
     0.861    14.492     0.150
     0.861    26.473     0.150
     0.998    17.141     0.150
     0.998    30.230     0.150
     0.974    18.402     0.150
     0.974    30.961     0.150
     0.974    18.434     0.150
     1.213    36.941     0.150
     1.218    37.422     0.150
     1.218    22.383     0.150
     1.218    37.422     0.150
     1.218    22.316     0.150
     1.201    21.973     0.150
     1.201    38.141     0.150
     1.201    21.863     0.150
     1.253    21.332     0.150
     1.253    38.602     0.150
     1.369    25.551     0.150
     1.369    43.762     0.150
     1.275    23.820     0.150
     1.278    23.176     0.150
     1.605    27.730     0.150
     1.605    49.344     0.150
     1.654    28.281     0.150
     1.654    51.492     0.150
     1.689    51.121     0.150
     1.691    30.281     0.150
     1.691    53.152     0.150
     1.691    30.152     0.150
     1.762    31.531     0.150
     1.762    31.531     0.150
     1.762    54.801     0.150
     1.785    30.633     0.150
     1.785    55.070     0.150
     1.738    30.281     0.150
     1.738    30.281     0.150
     1.738    54.543     0.150
     1.738    30.289     0.150
     2.226    36.809     0.150
     2.265    37.895     0.150
     2.359    73.320     0.150
     2.359    39.352     0.150
     2.359    73.320     0.150
     2.761    45.137     0.150
     2.813    45.168     0.150
     2.978    46.883     0.150
     3.221    51.793     0.150
     3.345    51.980     0.150
     3.855   120.461     0.150
     3.926    61.469     0.150
     4.419    66.773     0.150
     4.969    72.871     0.150
     5.158    77.461     0.150
     5.158    77.383     0.150
     5.238    76.844     0.150
     6.872    99.422     0.150
     7.436   108.691     0.150
     7.969   114.934     0.150
     8.484   214.320     0.150
     8.484   262.172     0.150
     8.484   123.703     0.150
     8.484   214.320     0.150
     8.484   262.172     0.150
     8.549   122.402     0.150
     8.549   217.301     0.150
     8.549   265.102     0.150
     8.586   216.133     0.150
     8.586   216.133     0.150
     9.115   286.551     0.150
     9.410   297.414     0.150
     9.550   137.062     0.150
     9.621   138.766     0.150
     9.674   139.730     0.150
    12.161   302.867     0.150
    13.154   186.355     0.150
    24.573   320.293     0.150
    26.117   332.973     0.150
    55.249  4151.402     0.150
    56.384  4208.855     0.150
    56.397  4201.508     0.150
    56.401  4212.395     0.150
     0.325     5.819     0.150
     0.325    10.445     0.150
     0.552     9.837     0.150
     0.844    15.670     0.150
     0.844    27.287     0.150
     1.042    18.672     0.150
     1.042    32.746     0.150
     1.113    35.479     0.150
     1.113    19.861     0.150
     1.124    20.223     0.150
     1.124    35.473     0.150
     1.270    23.485     0.150
     1.619    28.140     0.150
     1.625    29.793     0.150
     1.686    29.856     0.150
     2.270    42.020     0.150
     2.270    71.439     0.150
     2.352    74.789     0.150
     2.352    74.013     0.150
     3.124    56.319     0.150
     0.492     9.227     0.150
     0.492    16.320     0.150
     0.514    16.836     0.150
     0.681    12.133     0.150
     0.961    18.148     0.150
     1.056    18.609     0.150
     1.056    33.152     0.150
     1.117    20.340     0.150
     1.192    37.641     0.150
     1.194    37.684     0.150
     1.351    25.211     0.150
     1.286    23.336     0.150
     1.587    49.910     0.150
     1.738    55.020     0.150
     1.756    30.809     0.150
     1.756    53.766     0.150
     2.336    72.500     0.150
     2.336    73.426     0.150
     2.332    73.449     0.150
     2.332    73.105     0.150
     3.800    59.711     0.150
     3.904    60.559     0.150
     0.380    12.926     0.150
     0.486     9.211     0.150
     0.515     9.457     0.150
     0.515     9.395     0.150
     0.634    12.348     0.150
     0.683    12.074     0.150
     0.956    18.137     0.150
     1.051    18.617     0.150
     1.051    18.598     0.150
     1.116    20.281     0.150
     1.188    21.945     0.150
     1.347    25.172     0.150
     1.280    23.254     0.150
     1.591    50.277     0.150
     1.667    52.762     0.150
     1.739    55.188     0.150
     1.749    54.746     0.150
     1.751    30.133     0.150
     2.235    70.086     0.150
     2.329    73.555     0.150
     2.329    38.984     0.150
     2.329    72.668     0.150
     2.336    73.906     0.150
     2.336    72.969     0.150
     2.467    76.652     0.150
     2.792    44.387     0.150
     2.867    45.633     0.150
     2.874    44.688     0.150
     3.015    48.566     0.150
     3.345    91.125     0.150
     3.401    53.367     0.150
     3.401    94.090     0.150
     3.797    59.531     0.150
     3.902    60.383     0.150
     4.391    66.617     0.150
     0.568    10.414     0.150
     0.628    10.953     0.150
     0.628    19.297     0.150
     0.930    27.867     0.150
     0.930    17.617     0.150
     1.064    19.234     0.150
     1.064    33.328     0.150
     1.097    34.453     0.150
     1.181    21.758     0.150
     1.613    28.930     0.150
     1.730    30.617     0.150
     2.240    66.242     0.150
     2.285    71.602     0.150
     2.285    38.570     0.150
     2.412    74.844     0.150
     2.412    40.156     0.150
     2.412    75.242     0.150
     3.319    52.273     0.150
     4.420   139.672     0.150
     0.368     7.143     0.150
     0.726    25.533     0.150
     0.921    15.672     0.150
     1.136    19.393     0.150
     1.106    19.312     0.150
     1.186    21.713     0.150
     2.274    71.482     0.150
     2.242    37.812     0.150
     2.281    71.473     0.150
     2.403    39.643     0.150
     2.403    76.184     0.150
     3.615    57.242     0.150
     4.427    66.123     0.150
     0.431     7.668     0.150
     0.468    15.820     0.150
     0.468     8.542     0.150
     0.683    24.351     0.150
     0.777    13.235     0.150
     0.777    23.152     0.150
     0.996    18.493     0.150
     1.071    34.771     0.150
     1.197    38.203     0.150
     1.232    22.190     0.150
     1.232    39.262     0.150
     1.269    22.977     0.150
     1.285    21.960     0.150
     1.408    25.990     0.150
     1.673    29.320     0.150
     1.783    57.044     0.150
     1.781    32.541     0.150
     1.781    56.116     0.150
     1.857    59.000     0.150
     2.264    38.604     0.150
     2.399    72.590     0.150
     2.561    82.888     0.150
     2.703    84.052     0.150
     3.302    59.930     0.150
     3.302    59.308     0.150
     4.230    66.342     0.150
     0.389     7.656     0.150
     0.480    15.516     0.150
     0.480     9.195     0.150
     0.487     8.852     0.150
     0.648    12.676     0.150
     0.713    12.756     0.150
     0.713    12.746     0.150
     0.713    22.086     0.150
     0.771    14.617     0.150
     0.874    15.887     0.150
     0.939    17.387     0.150
     0.969    18.396     0.150
     0.969    18.436     0.150
     0.969    31.207     0.150
     1.025    18.275     0.150
     1.025    18.756     0.150
     1.192    21.896     0.150
     1.192    22.066     0.150
     1.192    37.156     0.150
     1.231    22.285     0.150
     1.368    43.719     0.150
     1.368    25.775     0.150
     1.368    43.906     0.150
     1.269    23.816     0.150
     1.265    22.902     0.150
     1.265    23.066     0.150
     1.617    27.717     0.150
     1.697    31.018     0.150
     1.769    30.457     0.150
     1.769    56.057     0.150
     1.762    30.775     0.150
     1.762    53.826     0.150
     1.794    30.957     0.150
     2.213    68.955     0.150
     2.257    37.652     0.150
     2.257    66.326     0.150
     2.353    39.082     0.150
     2.353    74.043     0.150
     2.353    39.105     0.150
     2.353    70.617     0.150
     2.353    74.355     0.150
     2.365    74.641     0.150
     2.497    77.818     0.150
     2.757    78.463     0.150
     2.757    44.537     0.150
     2.757    78.076     0.150
     2.965    49.016     0.150
     3.038    48.877     0.150
     3.213    50.807     0.150
     3.310    51.676     0.150
     3.310    51.695     0.150
     3.333    51.281     0.150
     3.333    51.246     0.150
     3.426    53.596     0.150
     3.820    59.783     0.150
     3.820    59.846     0.150
     4.077    62.105     0.150
     4.374    68.016     0.150
     4.677    71.881     0.150
     4.677    71.877     0.150
     5.145    90.557     0.150
     5.257    76.207     0.150
     5.287    80.590     0.150
     6.138    91.467     0.150
     0.442     8.152     0.150
     0.442    14.441     0.150
     0.442     8.273     0.150
     0.406     7.715     0.150
     0.406    14.113     0.150
     0.476     8.844     0.150
     0.476    15.738     0.150
     0.476     8.883     0.150
     0.776    14.363     0.150
     0.761    13.145     0.150
     0.761    13.184     0.150
     0.986    17.453     0.150
     0.994    18.562     0.150
     0.994    18.582     0.150
     0.994    32.055     0.150
     1.054    17.953     0.150
     1.245    22.570     0.150
     1.245    22.645     0.150
     1.254    21.996     0.150
     1.254    22.082     0.150
     1.291    23.914     0.150
     1.402    25.992     0.150
     1.523    26.234     0.150
     1.521    25.055     0.150
     1.656    51.375     0.150
     1.744    31.121     0.150
     1.791    31.746     0.150
     1.817    32.234     0.150
     1.839    31.773     0.150
     1.943    32.105     0.150
     2.181    34.613     0.150
     2.170    34.195     0.150
     2.268    38.801     0.150
     2.268    38.934     0.150
     2.334    39.383     0.150
     2.334    39.375     0.150
     2.334    69.805     0.150
     2.414    39.164     0.150
     2.413    75.652     0.150
     2.720    44.453     0.150
     2.787    45.883     0.150
     2.939    47.145     0.150
     2.939    47.105     0.150
     2.939    53.605     0.150
     3.076    50.188     0.150
     3.188    48.543     0.150
     3.165    51.492     0.150
     3.175    51.285     0.150
     3.306    51.770     0.150
     3.463    55.090     0.150
     3.640    57.754     0.150
     3.744    66.074     0.150
     3.832    59.613     0.150
     3.857    61.129     0.150
     3.862    67.418     0.150
     4.349    66.359     0.150
     4.431    68.453     0.150
     4.462    66.863     0.150
     4.674    72.219     0.150
     4.674    72.113     0.150
     4.655    70.590     0.150
     4.712    73.332     0.150
     4.761    71.809     0.150
     4.829    73.566     0.150
     4.914    72.855     0.150
     5.006    76.023     0.150
     5.114    75.074     0.150
     6.154    90.984     0.150
     6.217    93.715     0.150
     7.468   107.914     0.150
     7.773   113.801     0.150
     7.890   114.465     0.150
     8.164   116.914     0.150
     8.472   122.008     0.150
     8.813   128.543     0.150
     0.388     7.604     0.150
     0.496     9.084     0.150
     0.496     9.052     0.150
     0.496     9.084     0.150
     0.496    16.024     0.150
     0.480     9.074     0.150
     0.480     9.086     0.150
     0.480    14.978     0.150
     0.480     9.074     0.150
     0.480    16.064     0.150
     0.645    12.694     0.150
     0.645    21.364     0.150
     0.657    23.174     0.150
     0.704    12.714     0.150
     0.704    12.710     0.150
     0.704    12.714     0.150
     0.704    22.034     0.150
     0.769    25.224     0.150
     0.769    14.754     0.150
     0.769    25.224     0.150
     0.935    17.344     0.150
     0.935    30.074     0.150
     0.964    18.364     0.150
     0.964    30.934     0.150
     0.964    18.324     0.150
     0.964    30.857     0.150
     0.964    18.364     0.150
     0.964    30.934     0.150
     1.001    30.554     0.150
     1.032    32.384     0.150
     1.032    18.424     0.150
     1.032    32.139     0.150
     1.032    18.424     0.150
     1.032    32.154     0.150
     1.135    20.734     0.150
     1.135    20.726     0.150
     1.135    20.734     0.150
     1.135    36.054     0.150
     1.189    22.064     0.150
     1.189    37.924     0.150
     1.189    21.814     0.150
     1.189    37.864     0.150
     1.189    21.834     0.150
     1.189    37.814     0.150
     1.215    21.344     0.150
     1.215    38.494     0.150
     1.228    19.634     0.150
     1.228    19.134     0.150
     1.259    39.884     0.150
     1.268    22.944     0.150
     1.268    22.891     0.150
     1.268    22.944     0.150
     1.268    39.654     0.150
     1.360    25.604     0.150
     1.360    25.604     0.150
     1.264    23.784     0.150
     1.264    40.354     0.150
     1.610    27.704     0.150
     1.610    50.304     0.150
     1.688    29.724     0.150
     1.688    29.874     0.150
     1.688    53.924     0.150
     1.732    30.484     0.150
     1.732    30.484     0.150
     1.732    53.874     0.150
     1.759    30.794     0.150
     1.759    55.234     0.150
     1.757    30.554     0.150
     1.757    30.554     0.150
     1.757    53.884     0.150
     1.789    31.204     0.150
     1.789    55.294     0.150
     1.793    30.929     0.150
     2.122    65.852     0.150
     2.219    68.856     0.150
     2.236    35.734     0.150
     2.253    37.729     0.150
     2.253    37.734     0.150
     2.253    66.064     0.150
     2.343    38.548     0.150
     2.343    38.544     0.150
     2.343    67.994     0.150
     2.344    39.074     0.150
     2.344    73.864     0.150
     2.344    38.972     0.150
     2.344    73.475     0.150
     2.344    39.074     0.150
     2.344    73.864     0.150
     2.356    74.074     0.150
     2.356    74.197     0.150
     2.356    74.074     0.150
     2.488    78.284     0.150
     2.488    76.718     0.150
     2.488    40.894     0.150
     2.488    78.284     0.150
     2.775    46.584     0.150
     2.750    44.504     0.150
     2.750    78.404     0.150
     2.970    55.634     0.150
     2.970    81.314     0.150
     2.970    81.314     0.150
     2.970    92.014     0.150
     3.030    48.604     0.150
     3.030    48.674     0.150
     3.030    95.394     0.150
     3.118    56.754     0.150
     3.118    50.194     0.150
     3.210    51.114     0.150
     3.210    51.126     0.150
     3.210    51.114     0.150
     3.210    88.424     0.150
     3.210   101.914     0.150
     3.241    88.944     0.150
     3.309    51.584     0.150
     3.309    91.044     0.150
     3.309   103.804     0.150
     3.335    51.564     0.150
     3.335    90.554     0.150
     3.419    53.674     0.150
     3.627    56.984     0.150
     3.627    56.974     0.150
     3.627    98.044     0.150
     3.811    59.711     0.150
     3.811    59.734     0.150
     3.811   103.294     0.150
     3.811   119.004     0.150
     3.846    60.094     0.150
     3.846    60.094     0.150
     3.920    60.544     0.150
     3.920    60.428     0.150
     3.920    60.544     0.150
     3.920   105.494     0.150
     4.378    67.224     0.150
     4.378   115.994     0.150
     4.378   136.894     0.150
     4.611    70.374     0.150
     4.662    71.174     0.150
     4.662   123.274     0.150
     4.662    71.174     0.150
     4.662   123.324     0.150
     4.662   146.114     0.150
     4.669    71.744     0.150
     4.872   150.794     0.150
     5.150   159.334     0.150
     5.249    80.114     0.150
     5.279    79.784     0.150
     5.549    83.454     0.150
     5.549   173.454     0.150
     6.104    90.514     0.150
     6.104   157.474     0.150
     6.104   187.874     0.150
     6.131    91.444     0.150
     6.162    91.414     0.150
     6.162   193.044     0.150
     0.465     8.164     0.150
     0.465    14.656     0.150
     0.465     8.172     0.150
     0.465    14.713     0.150
     0.479     8.512     0.150
     0.479    13.992     0.150
     0.476    15.283     0.150
     0.506     9.273     0.150
     0.506     9.293     0.150
     0.506    16.182     0.150
     0.676    12.773     0.150
     0.712    13.223     0.150
     0.784    12.553     0.150
     0.784    12.443     0.150
     0.815    13.793     0.150
     0.815    24.832     0.150
     0.786    14.652     0.150
     0.786    14.633     0.150
     0.786    24.592     0.150
     0.765    13.867     0.150
     0.765    13.902     0.150
     0.867    15.643     0.150
     0.867    15.672     0.150
     1.025    17.672     0.150
     1.025    31.104     0.150
     1.127    21.113     0.150
     1.125    18.553     0.150
     1.125    18.553     0.150
     1.095    20.342     0.150
     1.095    34.533     0.150
     1.090    19.932     0.150
     1.090    19.953     0.150
     1.090    34.232     0.150
     1.254    20.463     0.150
     1.215    21.232     0.150
     1.385    22.572     0.150
     1.332    23.926     0.150
     1.332    23.963     0.150
     1.332    41.883     0.150
     1.422    25.318     0.150
     1.454    24.822     0.150
     1.464    24.482     0.150
     1.500    26.854     0.150
     1.615    27.492     0.150
     1.591    29.287     0.150
     1.591    29.172     0.150
     1.591    50.072     0.150
     1.773    55.996     0.150
     1.747    54.732     0.150
     1.747    31.107     0.150
     1.747    54.744     0.150
     1.796    29.383     0.150
     1.945    32.428     0.150
     1.880    33.252     0.150
     2.092    36.838     0.150
     2.092    36.773     0.150
     2.130    36.912     0.150
     2.236    39.223     0.150
     2.325    39.262     0.150
     2.325    72.057     0.150
     2.325    39.193     0.150
     2.325    72.332     0.150
     2.856    46.943     0.150
     3.064    48.906     0.150
     3.280    52.969     0.150
     3.561    57.357     0.150
     3.561    57.453     0.150
     3.621   114.113     0.150
     3.654    58.293     0.150
     3.803    61.062     0.150
     3.803    60.354     0.150
     3.803   106.812     0.150
     4.425    69.383     0.150
     4.449    69.402     0.150
     4.449    69.623     0.150
     5.016   156.213     0.150
     5.260    81.492     0.150
     5.841    88.062     0.150
     5.841   155.912     0.150
     7.367   109.883     0.150
     0.493     9.192     0.150
     0.554    10.183     0.150
     0.944    27.793     0.150
     0.936    17.812     0.150
     1.078    19.543     0.150
     1.078    33.683     0.150
     1.084    19.293     0.150
     1.199    21.863     0.150
     1.298    23.692     0.150
     2.296    71.904     0.150
     2.296    71.863     0.150
     2.297    38.593     0.150
     2.357    39.383     0.150
     2.427    76.243     0.150
     3.317    52.232     0.150
     0.553    10.055     0.150
     0.612    10.664     0.150
     1.097    20.457     0.150
     1.103    19.832     0.150
     1.170    20.594     0.150
     1.170    36.363     0.150
     1.392    25.555     0.150
     1.296    23.434     0.150
     1.736    53.434     0.150
     1.919    61.012     0.150
     2.297    39.902     0.150
     2.404    75.918     0.150
     2.404    75.484     0.150
     3.048    49.422     0.150
     0.425     7.500     0.150
     0.425    12.062     0.150
     0.460     8.469     0.150
     0.460    14.805     0.150
     0.955    16.805     0.150
     0.955    29.023     0.150
     0.994    18.570     0.150
     1.085    32.703     0.150
     1.190    21.648     0.150
     1.190    37.570     0.150
     1.210    38.266     0.150
     1.410    44.914     0.150
     1.778    32.609     0.150
     2.312    38.859     0.150
     2.402    75.344     0.150
     0.275     9.172     0.150
     0.275     5.328     0.150
     0.275     9.227     0.150
     0.481    17.461     0.150
     0.485     9.367     0.150
     0.485    15.055     0.150
     0.485     9.336     0.150
     0.585    19.898     0.150
     0.585    10.922     0.150
     0.769    13.703     0.150
     0.769    13.727     0.150
     0.799    15.047     0.150
     0.847    16.008     0.150
     1.105    20.609     0.150
     1.105    20.625     0.150
     1.105    35.617     0.150
     1.120    20.320     0.150
     1.228    22.539     0.150
     1.228    22.469     0.150
     1.297    22.680     0.150
     1.429    25.438     0.150
     1.429    25.352     0.150
     1.429    44.750     0.150
     1.556    49.117     0.150
     1.556    28.922     0.150
     1.556    49.141     0.150
     1.533    26.281     0.150
     1.533    47.320     0.150
     1.693    52.578     0.150
     1.854    32.570     0.150
     1.854    57.750     0.150
     2.077    35.297     0.150
     2.255    69.836     0.150
     2.326    39.422     0.150
     2.411    40.547     0.150
     2.902    46.711     0.150
     2.905    45.859     0.150
     3.167    49.328     0.150
     3.654    56.086     0.150
     4.675   145.297     0.150
     4.922    72.047     0.150
     5.719    82.922     0.150
     5.797    81.125     0.150
     0.522     8.969     0.150
     0.532     9.695     0.150
     0.594    10.617     0.150
     0.656    12.172     0.150
     0.809    10.969     0.150
     0.809    21.219     0.150
     1.023    30.203     0.150
     1.290    24.016     0.150
     1.220    21.555     0.150
     1.238    22.969     0.150
     1.238    39.328     0.150
     1.425    23.227     0.150
     1.413    24.406     0.150
     1.413    24.766     0.150
     1.523    27.359     0.150
     1.599    29.805     0.150
     2.246    71.562     0.150
     2.246    41.805     0.150
     2.930    49.266     0.150
     0.371     7.250     0.150
     0.371    12.672     0.150
     0.550     9.648     0.150
     0.550     9.660     0.150
     0.550    16.910     0.150
     0.527     9.531     0.150
     0.527     9.590     0.150
     0.597    11.672     0.150
     0.642    11.781     0.150
     0.642    11.699     0.150
     0.642    11.781     0.150
     0.763    12.652     0.150
     0.777    14.633     0.150
     0.777    14.633     0.150
     0.777    25.102     0.150
     0.788    15.102     0.150
     0.853    15.062     0.150
     0.853    27.750     0.150
     0.901    16.992     0.150
     0.901    29.152     0.150
     0.901    16.973     0.150
     0.901    29.059     0.150
     0.901    16.992     0.150
     0.901    29.152     0.150
     0.993    18.020     0.150
     0.993    18.020     0.150
     0.993    18.020     0.150
     0.993    31.230     0.150
     1.073    18.109     0.150
     1.136    18.902     0.150
     1.259    23.520     0.150
     1.259    23.500     0.150
     1.259    39.980     0.150
     1.161    21.352     0.150
     1.161    21.371     0.150
     1.165    20.031     0.150
     1.165    20.094     0.150
     1.165    37.562     0.150
     1.165    20.031     0.150
     1.209    22.621     0.150
     1.209    38.500     0.150
     1.347    23.852     0.150
     1.347    23.879     0.150
     1.347    23.852     0.150
     1.484    24.891     0.150
     1.527    25.289     0.150
     1.537    27.352     0.150
     1.606    28.449     0.150
     1.653    27.699     0.150
     1.705    31.449     0.150
     1.705    31.582     0.150
     1.815    31.359     0.150
     1.815    31.371     0.150
     1.830    58.000     0.150
     2.226    41.281     0.150
     2.230    37.746     0.150
     2.334    72.957     0.150
     2.327    38.441     0.150
     2.381    39.133     0.150
     2.661    42.891     0.150
     2.965    47.000     0.150
     2.926    46.961     0.150
     3.062    47.859     0.150
     3.173    51.250     0.150
     3.298    51.969     0.150
     3.331    92.672     0.150
     3.331    52.383     0.150
     3.601    54.812     0.150
     3.695    58.512     0.150
     3.784    59.473     0.150
     3.784    59.449     0.150
     3.866    59.652     0.150
     3.896    59.137     0.150
     3.864    67.742     0.150
     3.917    60.660     0.150
     4.223    64.492     0.150
     4.465    67.410     0.150
     4.552    69.781     0.150
     4.559    70.262     0.150
     4.902    73.641     0.150
     5.083    76.281     0.150
     5.537    83.664     0.150
     5.973    88.984     0.150
     6.017    89.590     0.150
     6.879   100.992     0.150
     0.515     9.836     0.150
     1.520    48.174     0.150
     1.814    31.418     0.150
     1.890    32.431     0.150
     1.884    58.979     0.150
     2.336    38.761     0.150
     2.437    76.252     0.150
     2.591    79.301     0.150
     2.683    83.208     0.150
     2.892    81.657     0.150
     3.002    84.784     0.150
     3.315   101.357     0.150
     3.321    52.002     0.150
     3.560    98.195     0.150
     4.311    65.494     0.150
     4.527    68.271     0.150
     5.005    76.251     0.150
     0.992    30.695     0.150
     1.803    57.078     0.150
     2.409    74.758     0.150
     2.552    82.367     0.150
     2.552    82.367     0.150
     2.718    84.340     0.150
     2.807    86.164     0.150
     0.302     5.967     0.150
     0.513    17.096     0.150
     0.885    26.829     0.150
     0.885    15.714     0.150
     0.906    16.464     0.150
     0.906    28.182     0.150
     1.094    20.367     0.150
     1.094    34.990     0.150
     1.257    39.914     0.150
     1.318    23.514     0.150
     1.318    41.562     0.150
     1.335    41.475     0.150
     1.415    26.839     0.150
     1.523    28.349     0.150
     1.810    55.574     0.150
     2.331    38.849     0.150
     3.984    62.453     0.150
     4.112    64.137     0.150
     4.721    72.246     0.150
     4.834    74.283     0.150
     1.884    34.598     0.150
     0.306     6.025     0.150
     0.466     8.916     0.150
     0.466    15.635     0.150
     0.514    17.135     0.150
     0.514    17.180     0.150
     0.488     8.295     0.150
     0.729    14.006     0.150
     0.827    15.555     0.150
     0.901    16.326     0.150
     0.901    28.584     0.150
     0.890    15.785     0.150
     1.045    18.996     0.150
     1.092    20.455     0.150
     1.092    35.145     0.150
     1.092    20.496     0.150
     1.092    35.166     0.150
     1.215    38.625     0.150
     1.215    21.945     0.150
     1.258    39.904     0.150
     1.258    22.885     0.150
     1.330    24.166     0.150
     1.330    24.225     0.150
     1.313    23.605     0.150
     1.313    23.602     0.150
     1.313    41.717     0.150
     1.379    25.545     0.150
     1.521    48.865     0.150
     1.521    49.205     0.150
     1.605    28.025     0.150
     1.765    29.625     0.150
     1.812    31.375     0.150
     1.864    32.383     0.150
     1.886    32.564     0.150
     1.886    32.529     0.150
     1.886    59.379     0.150
     1.958    33.605     0.150
     2.012    61.641     0.150
     2.209    35.564     0.150
     2.324    74.055     0.150
     2.334    38.916     0.150
     2.334    38.926     0.150
     2.434    74.988     0.150
     2.589    42.016     0.150
     2.589    79.348     0.150
     2.685    43.625     0.150
     2.685    83.340     0.150
     2.780    44.174     0.150
     2.892    81.584     0.150
     2.882    45.459     0.150
     3.005    84.480     0.150
     3.023    92.861     0.150
     3.202    51.072     0.150
     3.234    96.340     0.150
     3.291    52.711     0.150
     3.287    50.809     0.150
     3.319    52.156     0.150
     3.563    55.213     0.150
     3.609    98.945     0.150
     3.981    62.178     0.150
     3.991   125.545     0.150
     4.040    61.266     0.150
     4.040   108.123     0.150
     4.108    63.484     0.150
     4.267    64.865     0.150
     4.267    64.893     0.150
     4.267   114.109     0.150
     4.295    64.914     0.150
     4.528    67.686     0.150
     4.536   136.299     0.150
     4.722    72.148     0.150
     4.737   144.740     0.150
     4.814    72.768     0.150
     4.831    74.045     0.150
     4.831    74.127     0.150
     4.894    74.135     0.150
     4.894    74.180     0.150
     5.503    82.316     0.150
     5.631    84.305     0.150
     5.631    84.182     0.150
     6.286    94.275     0.150
     7.337   107.756     0.150
     7.337   107.801     0.150
     0.299     4.863     0.150
     0.299     4.982     0.150
     0.602    10.623     0.150
     0.602    18.660     0.150
     0.641    11.941     0.150
     0.770    13.982     0.150
     0.968    30.045     0.150
     0.980    30.771     0.150
     1.010    18.402     0.150
     1.217    22.271     0.150
     1.535    48.121     0.150
     1.582    28.822     0.150
     1.891    31.551     0.150
     1.936    62.408     0.150
     2.007    33.172     0.150
     2.206    71.199     0.150
     2.302    73.867     0.150
     2.458    75.145     0.150
     2.949    49.355     0.150
     3.238    50.131     0.150
     3.734    56.801     0.150
     3.806    61.141     0.150
     4.602    69.092     0.150
     4.602    72.727     0.150
     4.714    70.191     0.150
     5.204    81.012     0.150
     7.483   111.842     0.150
     7.687   110.852     0.150
     7.759   111.982     0.150
     0.485     9.148     0.150
     0.982    17.290     0.150
     0.982    30.220     0.150
     1.008    18.861     0.150
     1.204    21.631     0.150
     1.204    37.984     0.150
     1.249    22.557     0.150
     1.417    26.257     0.150
     1.688    29.507     0.150
     1.794    31.815     0.150
     1.800    55.693     0.150
     1.923    34.322     0.150
     2.340    39.060     0.150
     2.405    44.240     0.150
     2.405    75.800     0.150
     2.405    75.251     0.150
     2.940    50.800     0.150
     0.328     5.188     0.150
     0.328     7.898     0.150
     0.328     5.133     0.150
     0.328     8.041     0.150
     0.369    11.176     0.150
     0.369     6.318     0.150
     0.631    10.637     0.150
     0.585    10.490     0.150
     0.850    15.742     0.150
     0.986    16.809     0.150
     0.986    31.205     0.150
     1.215    20.648     0.150
     1.129    20.467     0.150
     1.129    37.299     0.150
     1.322    24.570     0.150
     1.310    24.338     0.150
     1.537    27.945     0.150
     1.702    53.082     0.150
     1.875    33.838     0.150
     1.850    33.383     0.150
     1.918    35.613     0.150
     1.914    32.588     0.150
     1.893    33.559     0.150
     1.893    34.930     0.150
     1.913    33.857     0.150
     1.913    35.633     0.150
     2.208    73.082     0.150
     2.206    71.053     0.150
     2.389    73.951     0.150
     2.422    74.891     0.150
     2.980    85.008     0.150
     0.335     6.212     0.150
     0.428    14.364     0.150
     0.428     8.164     0.150
     0.743    14.024     0.150
     0.774    24.256     0.150
     0.853    26.904     0.150
     0.967    16.859     0.150
     1.045    19.514     0.150
     1.045    33.954     0.150
     1.118    20.204     0.150
     1.166    21.304     0.150
     1.271    22.894     0.150
     1.358    44.054     0.150
     1.358    24.264     0.150
     1.358    24.324     0.150
     1.358    44.086     0.150
     1.496    27.874     0.150
     1.520    27.394     0.150
     1.872    32.794     0.150
     1.880    31.724     0.150
     1.924    33.624     0.150
     2.057    35.854     0.150
     2.216    40.054     0.150
     2.235    70.247     0.150
     2.391    40.093     0.150
     2.502    45.664     0.150
     2.502    42.075     0.150
     2.898    46.446     0.150
     3.205    49.434     0.150
     3.205    51.732     0.150
     3.947   107.134     0.150
     4.113    64.214     0.150
     4.170    64.304     0.150
     4.284    67.834     0.150
     4.307    66.101     0.150
     4.866    74.854     0.150
     4.918   161.018     0.150
     5.421    80.794     0.150
     5.513    81.904     0.150
     5.513    83.314     0.150
     5.936    88.624     0.150
     0.334    10.047     0.150
     0.538    16.088     0.150
     0.538     9.816     0.150
     0.608    10.867     0.150
     0.608    19.137     0.150
     0.576    10.295     0.150
     0.720    23.787     0.150
     1.152    21.225     0.150
     1.346    24.521     0.150
     1.346    41.115     0.150
     1.757    31.201     0.150
     1.828    32.109     0.150
     2.294    73.248     0.150
     2.273    38.816     0.150
     3.024    46.178     0.150
     3.055    83.965     0.150
     3.221    49.816     0.150
     0.339     6.496     0.150
     0.838    15.352     0.150
     0.913    15.922     0.150
     1.145    19.938     0.150
     1.145    21.285     0.150
     1.193    38.418     0.150
     1.211    39.770     0.150
     1.325    23.797     0.150
     1.319    23.625     0.150
     1.375    44.949     0.150
     1.482    26.707     0.150
     1.482    47.508     0.150
     1.482    47.602     0.150
     1.741    29.887     0.150
     1.741    52.379     0.150
     1.741    32.219     0.150
     1.741    55.316     0.150
     1.806    33.316     0.150
     1.806    56.676     0.150
     1.884    33.738     0.150
     1.995    35.238     0.150
     2.064    63.523     0.150
     2.263    36.449     0.150
     2.263    39.867     0.150
     2.263    69.680     0.150
     2.259    36.750     0.150
     2.259    65.090     0.150
     2.259    70.109     0.150
     2.484    74.777     0.150
     2.817    76.738     0.150
     2.843    79.066     0.150
     3.945    60.789     0.150
     4.791    72.000     0.150
     5.408    80.578     0.150
     0.707    13.180     0.150
     0.707    13.227     0.150
     1.149    33.867     0.150
     1.108    20.281     0.150
     1.174    20.539     0.150
     1.174    36.531     0.150
     1.315    23.688     0.150
     1.315    40.711     0.150
     1.479    26.484     0.150
     1.479    46.367     0.150
     1.754    32.141     0.150
     1.847    57.734     0.150
     1.981    60.141     0.150
     2.146    68.117     0.150
     2.756    83.188     0.150
     2.765    88.508     0.150
     3.711    60.047     0.150
     0.237     3.809     0.150
     0.422    14.441     0.150
     0.422     8.020     0.150
     0.422    14.043     0.150
     0.550     9.910     0.150
     0.736    23.820     0.150
     0.917    30.180     0.150
     0.917    15.980     0.150
     0.917    27.301     0.150
     1.022    19.000     0.150
     1.022    33.238     0.150
     1.022    18.961     0.150
     1.117    20.148     0.150
     1.117    20.117     0.150
     1.167    21.219     0.150
     1.167    21.184     0.150
     1.314    23.219     0.150
     1.465    27.070     0.150
     1.400    44.199     0.150
     1.400    25.074     0.150
     1.436    24.570     0.150
     1.473    27.031     0.150
     1.527    26.461     0.150
     1.527    26.500     0.150
     1.781    31.520     0.150
     1.781    31.504     0.150
     1.882    33.223     0.150
     2.024    34.609     0.150
     2.232    38.148     0.150
     2.234    37.801     0.150
     2.342    39.809     0.150
     2.342    39.734     0.150
     2.469    41.422     0.150
     2.697    77.445     0.150
     2.792    44.520     0.150
     2.792    86.793     0.150
     2.823    79.723     0.150
     3.031    48.395     0.150
     3.153    51.320     0.150
     3.201    51.648     0.150
     3.190    49.922     0.150
     3.219    51.309     0.150
     3.628    56.844     0.150
     3.676    56.969     0.150
     3.929    62.391     0.150
     3.929   108.281     0.150
     4.000    62.648     0.150
     4.131    63.117     0.150
     5.096    76.852     0.150
     5.389   146.738     0.150
     5.391    82.609     0.150
     5.802    88.328     0.150
     6.337    94.750     0.150
    10.441   148.520     0.150
    12.060   168.020     0.150
    68.312   662.012     0.150
     0.548    18.001     0.150
     0.749    26.421     0.150
     0.891    16.491     0.150
     1.024    30.741     0.150
     1.024    17.891     0.150
     1.060    31.421     0.150
     1.060    18.321     0.150
     1.006    18.761     0.150
     1.035    18.891     0.150
     1.035    32.881     0.150
     1.206    35.831     0.150
     1.291    23.471     0.150
     1.412    24.230     0.150
     1.447    27.071     0.150
     1.556    46.601     0.150
     1.928    61.161     0.150
     2.445    39.721     0.150
     3.053    97.211     0.150
     3.444    54.980     0.150
     3.765    60.901     0.150
     3.765    60.811     0.150
     3.832    60.891     0.150
     3.839   118.171     0.150
     5.215    78.261     0.150
     5.236    81.821     0.150
     5.236    78.980     0.150
     0.505    15.672     0.150
     0.650    11.578     0.150
     0.694    24.562     0.150
     0.946    27.656     0.150
     0.953    30.734     0.150
     1.207    37.680     0.150
     1.198    22.930     0.150
     1.198    39.391     0.150
     1.307    43.531     0.150
     1.307    23.328     0.150
     1.752    30.906     0.150
     1.859    32.430     0.150
     1.859    59.125     0.150
     2.169    62.297     0.150
     2.307    38.664     0.150
     2.307    72.758     0.150
     2.312    72.500     0.150
     2.266    40.227     0.150
     2.266    40.297     0.150
     2.266    71.250     0.150
     2.435    75.711     0.150
     2.446    38.227     0.150
     2.732    44.766     0.150
     2.909    47.867     0.150
     3.067    48.477     0.150
     3.089    47.109     0.150
     3.368    94.047     0.150
     4.560    65.039     0.150
     4.650    68.461     0.150
     4.641    72.102     0.150
     4.939    74.070     0.150
     5.700    84.742     0.150
     6.874    97.391     0.150
     0.500     9.211     0.150
     0.500    16.094     0.150
     0.653    11.422     0.150
     0.653    19.859     0.150
     0.694    22.344     0.150
     0.950    17.891     0.150
     1.092    19.766     0.150
     1.193    37.922     0.150
     1.301    23.617     0.150
     1.640    29.344     0.150
     1.777    56.820     0.150
     1.864    59.148     0.150
     2.073    33.719     0.150
     2.254    37.008     0.150
     2.437    76.055     0.150
     2.997    47.281     0.150
     3.230    53.188     0.150
     0.318    10.961     0.150
     0.318     6.500     0.150
     0.462     9.656     0.150
     0.462     9.609     0.150
     0.462    16.547     0.150
     0.777    15.016     0.150
     0.797    15.234     0.150
     0.955    31.875     0.150
     1.062    34.836     0.150
     1.062    20.562     0.150
     1.062    34.891     0.150
     1.146    20.773     0.150
     1.228    21.586     0.150
     1.342    24.492     0.150
     1.342    24.562     0.150
     1.503    26.961     0.150
     1.503    48.047     0.150
     1.470    25.094     0.150
     1.539    44.977     0.150
     1.539    26.773     0.150
     1.877    31.523     0.150
     1.906    60.195     0.150
     1.984    32.977     0.150
     2.040    35.602     0.150
     2.273    37.109     0.150
     2.268    36.703     0.150
     3.045    45.703     0.150
     3.190    85.516     0.150
     3.966    60.820     0.150
     3.966    60.844     0.150
     4.226    65.297     0.150
     5.430    81.273     0.150
     5.506    79.992     0.150
     0.720    20.935     0.150
     1.064    31.335     0.150
     1.468    47.055     0.150
     2.709    43.835     0.150
     3.079    49.735     0.150
     3.345    53.575     0.150
     1.614    49.570     0.150
     2.357    74.090     0.150
     1.343    44.607     0.150
     1.577    28.997     0.150
     1.919    33.837     0.150
     5.373    80.997     0.150
     0.767    22.156     0.150
     0.954    16.141     0.150
     0.945    32.242     0.150
     0.990    28.836     0.150
     0.990    16.367     0.150
     1.088    18.828     0.150
     1.250    20.109     0.150
    71.385    39.672     0.150
     3.107    53.070     0.150
     3.155    53.500     0.150
     3.190    54.836     0.150
     0.214     4.695     0.150
     0.214     8.404     0.150
     0.702    14.186     0.150
     0.875    17.605     0.150
     0.875    31.016     0.150
     1.103    20.705     0.150
     1.163    21.984     0.150
     2.306    36.574     0.150
     2.514    39.545     0.150
    71.668    39.346     0.150
     4.254    65.416     0.150
     0.416    11.742     0.150
     0.434     8.023     0.150
     0.434    15.672     0.150
     0.681    12.973     0.150
     0.681    24.613     0.150
     0.982    18.121     0.150
     1.267    22.965     0.150
     1.319    23.965     0.150
     1.385    46.133     0.150
     1.722    41.434     0.150
     2.187    69.012     0.150
    71.686    43.363     0.150
     3.296    51.273     0.150
     3.635    58.012     0.150
     3.886   108.172     0.150
     5.100    77.645     0.150
     5.251    79.633     0.150
     7.195   180.785     0.150
     8.626   264.520     0.150
     8.626   125.352     0.150
    12.139   172.562     0.150
    55.253  4126.590     0.150
    55.258  4127.371     0.150
    55.270  4141.305     0.150
    56.405  4210.465     0.150
    56.422  4210.754     0.150
     0.431     7.953     0.150
     0.431    15.590     0.150
     0.687    13.180     0.150
     0.988    32.020     0.150
     1.074    20.121     0.150
     1.273    22.961     0.150
     1.273    39.992     0.150
     1.567    26.590     0.150
     1.678    30.223     0.150
     1.678    27.961     0.150
     1.669    29.430     0.150
     1.728    41.062     0.150
     1.760    31.340     0.150
     2.189    37.801     0.150
     2.428    40.430     0.150
    71.688    43.691     0.150
     3.633    58.590     0.150
     3.982    62.480     0.150
     4.188    74.000     0.150
     5.832   160.391     0.150
     7.200   182.934     0.150
     8.627   221.441     0.150
     0.509    14.473     0.150
     0.656    11.912     0.150
     0.797    13.652     0.150
     0.865    15.742     0.150
     0.971    18.082     0.150
     0.999    18.512     0.150
     0.999    30.461     0.150
     1.058    17.682     0.150
     1.058    31.121     0.150
     1.071    34.031     0.150
     1.071    31.201     0.150
     1.151    21.291     0.150
     1.280    23.742     0.150
     1.306    24.502     0.150
     1.408    23.602     0.150
     1.408    42.592     0.150
     1.525    27.592     0.150
     1.525    46.791     0.150
     1.584    27.072     0.150
   110.230    35.711     0.150
    71.542    41.512     0.150
     3.796    61.072     0.150
     4.573    71.451     0.150
     0.289     9.461     0.150
     0.485    18.551     0.150
     0.788    15.242     0.150
     0.807    15.461     0.150
     1.093    35.922     0.150
     1.093    20.730     0.150
     1.106    20.270     0.150
     1.237    22.520     0.150
     1.366    25.012     0.150
     1.366    44.141     0.150
     1.374    25.172     0.150
     1.374    44.371     0.150
     1.372    43.359     0.150
     1.533    27.512     0.150
     1.533    48.711     0.150
     1.545    26.340     0.150
     1.545    45.723     0.150
     1.633    49.793     0.150
     2.016    63.250     0.150
     2.291    37.160     0.150
   109.803    38.520     0.150
    71.819    44.973     0.150
     2.085    37.914     0.150
     2.145    64.074     0.150
     5.043    84.164     0.150
     0.685    12.585     0.150
     0.858    15.855     0.150
     0.970    17.875     0.150
     1.045    17.795     0.150
     1.123    20.875     0.150
     1.174    35.325     0.150
     1.261    23.425     0.150
     1.281    23.965     0.150
     1.281    41.015     0.150
     1.496    27.005     0.150
     1.566    48.755     0.150
   110.248    35.525     0.150
   110.248    63.475     0.150
    71.514    71.975     0.150
    71.514    40.495     0.150
     2.466    44.055     0.150
     3.075    48.185     0.150
     3.259    51.925     0.150
     3.789    59.255     0.150
     4.519    70.445     0.150
    81.957    86.665     0.150
     2.030    60.074     0.150
     3.830   104.586     0.150
     1.530    27.256     0.150
     0.299     5.766     0.150
     0.878    28.625     0.150
     1.148    20.375     0.150
     1.128    21.098     0.150
     1.128    36.168     0.150
     1.333    24.309     0.150
     1.368    23.438     0.150
     1.368    25.336     0.150
     1.428    26.398     0.150
     1.419    45.355     0.150
     1.546    49.219     0.150
     1.722    29.316     0.150
     1.659    29.137     0.150
     1.659    50.719     0.150
     1.880    32.238     0.150
     2.393    39.406     0.150
     2.393    43.188     0.150
     2.393    74.707     0.150
    71.827    44.008     0.150
     4.117    62.457     0.150
     4.267    63.266     0.150
     4.289    63.758     0.150
     5.095    89.457     0.150
     0.505     9.734     0.150
     0.505    15.914     0.150
     0.954    18.965     0.150
     0.954    32.734     0.150
     0.954    18.996     0.150
     1.124    19.734     0.150
     1.115    21.836     0.150
     1.115    21.797     0.150
     1.175    22.477     0.150
     1.175    22.496     0.150
     1.325    43.746     0.150
     1.475    26.945     0.150
     1.475    45.504     0.150
     1.369    43.355     0.150
     1.475    47.867     0.150
    71.719    39.406     0.150
    71.719    69.895     0.150
     2.534    40.676     0.150
     3.311    52.555     0.150
     3.973    59.824     0.150
     4.841    72.547     0.150
     5.191    75.906     0.150
     5.554    81.914     0.150
     5.569    81.637     0.150
    81.973    84.707     0.150
     0.313     4.750     0.150
     0.913    18.547     0.150
     1.166    22.641     0.150
     1.090    21.195     0.150
     1.309    25.562     0.150
     1.239    26.250     0.150
     1.517    27.391     0.150
     1.567    28.000     0.150
     1.811    30.742     0.150
     1.801    30.711     0.150
    71.614    42.977     0.150
     2.416    41.977     0.150
     5.242   137.414     0.150
     5.242   152.938     0.150
     5.242   229.367     0.150
     5.678   144.992     0.150
     5.678   251.188     0.150
     7.101   156.508     0.150
    12.214   241.289     0.150
    25.269   377.391     0.150
     0.448     8.055     0.150
     0.667    19.836     0.150
     0.965    17.953     0.150
     0.965    31.363     0.150
     1.252    39.336     0.150
     1.652    50.816     0.150
     1.652    50.895     0.150
     1.738    54.625     0.150
     1.795    52.953     0.150
     1.916    56.945     0.150
     1.921    58.125     0.150
     2.168    35.055     0.150
     2.168    35.785     0.150
     2.406    75.727     0.150
    71.675    43.324     0.150
     3.989    62.836     0.150
     4.164    64.504     0.150
     0.986    18.492     0.150
     1.061    19.398     0.150
     1.061    33.461     0.150
     1.243    22.289     0.150
     1.311    41.648     0.150
     1.344    24.430     0.150
     1.416    25.750     0.150
     1.416    44.953     0.150
     1.751    30.023     0.150
     2.262    37.383     0.150
    71.701    44.633     0.150
     6.062    89.359     0.150
     0.982    18.555     0.150
     1.245    22.297     0.150
     1.310    41.992     0.150
     1.407    25.266     0.150
     1.414    45.102     0.150
     2.253    37.375     0.150
    71.700    44.117     0.150
     3.031    50.016     0.150
     4.012    60.508     0.150
     4.510    67.438     0.150
     4.808   148.703     0.150
     0.869    16.039     0.150
     1.539    28.695     0.150
     1.827    30.023     0.150
     2.629    41.562     0.150
     2.841    49.648     0.150
     4.521    68.594     0.150
    15.365   216.258     0.150
    15.423   220.047     0.150
    15.433   218.703     0.150
    15.576   220.055     0.150
    15.996   225.039     0.150
    16.205   227.578     0.150
    16.545   233.375     0.150
    16.731   236.039     0.150
    17.393   244.594     0.150
    18.560   258.469     0.150
    18.748   260.523     0.150
    19.307   267.656     0.150
    20.724   280.719     0.150
    20.997   285.094     0.150
    21.013   285.656     0.150
    21.242   289.055     0.150
    21.433   289.953     0.150
    22.692   303.812     0.150
    23.224   309.625     0.150
    23.536   312.523     0.150
    23.533   311.828     0.150
    24.437   320.523     0.150
    25.057   327.055     0.150
    26.068   335.609     0.150
    26.676   341.719     0.150
    28.945   361.086     0.150
    30.726   377.188     0.150
    29.765   398.609     0.150
    33.178   399.062     0.150
    33.424   401.836     0.150
    33.578   403.203     0.150
    33.845   404.195     0.150
    35.036   414.648     0.150
    36.665   429.578     0.150
    36.950   431.305     0.150
    37.442   434.367     0.150
    39.710   453.906     0.150
    39.878   455.609     0.150
    40.354   459.445     0.150
    40.622   461.414     0.150
    41.065   465.359     0.150
    41.084   466.242     0.150
    41.053   465.977     0.150
    41.301   467.898     0.150
    41.873   472.812     0.150
    42.009   472.680     0.150
    42.017   473.695     0.150
    42.183   475.812     0.150
    43.153   482.203     0.150
    43.281   484.438     0.150
    43.744   487.586     0.150
    44.551   493.930     0.150
    45.220   499.039     0.150
    46.866   514.344     0.150
    48.722   529.664     0.150
    49.777   533.977     0.150
    50.280   544.523     0.150
    51.930   549.953     0.150
    53.806   564.367     0.150
    55.048   573.703     0.150
    55.389   576.812     0.150
    57.351   591.156     0.150
    57.890   595.023     0.150
    59.431   604.367     0.150
    59.521   604.742     0.150
    60.057   609.492     0.150
    62.702   626.227     0.150
    62.917   628.039     0.150
    63.203   630.078     0.150
    64.044   641.258     0.150
    64.415   637.734     0.150
    65.060   641.469     0.150
    65.866   647.547     0.150
    67.731   663.469     0.150
    67.960   659.844     0.150
    68.520   669.703     0.150
    68.883   666.047     0.150
    77.078   667.773     0.150
    69.575   670.898     0.150
    69.574   670.664     0.150
    70.498   677.508     0.150
    70.998   680.523     0.150
    70.998   680.289     0.150
    71.679   685.516     0.150
    71.920   685.648     0.150
    73.621   695.477     0.150
    73.830   697.969     0.150
    75.869   709.383     0.150
    75.988   709.812     0.150
    77.405   716.797     0.150
    78.143   726.344     0.150
    78.458   725.914     0.150
    79.746   730.336     0.150
    79.884   731.484     0.150
    84.305   754.758     0.150
    85.058   760.562     0.150
    87.465   768.234     0.150
    90.045   783.516     0.150
    92.640   794.867     0.150
     2.282    72.055     0.150
     3.114    51.383     0.150
     3.179    52.086     0.150
     3.678    59.828     0.150
     3.678    60.719     0.150
     3.678    59.883     0.150
     4.854    76.086     0.150
     5.325    81.484     0.150
     5.471    82.484     0.150
     5.564    86.586     0.150
     5.564    85.289     0.150
     5.988    91.086     0.150
     5.988    89.406     0.150
     6.586    98.305     0.150
     6.555   100.984     0.150
     6.702   102.109     0.150
     6.956   105.188     0.150
     6.953   105.883     0.150
     7.247   108.289     0.150
     7.247   107.883     0.150
     7.247   108.156     0.150
     7.247   108.062     0.150
     7.862   116.883     0.150
     8.242   122.484     0.150
     8.355   129.586     0.150
     8.322   124.289     0.150
     8.341   123.414     0.150
     8.341   122.992     0.150
     8.634   127.492     0.150
     9.331   139.344     0.150
    10.103   149.469     0.150
    10.120   150.188     0.150
    10.359   151.180     0.150
    12.046   171.422     0.150
    12.631   181.438     0.150
    12.937   187.477     0.150
    13.842   198.055     0.150
    13.933   200.977     0.150
    13.985   200.695     0.150
    15.365   218.602     0.150
    15.854   226.750     0.150
    15.886   226.711     0.150
    15.886   227.227     0.150
    15.921   224.945     0.150
    15.996   225.203     0.150
    16.013   229.289     0.150
    16.193   228.961     0.150
    17.649   246.500     0.150
    17.703   250.336     0.150
    18.480   259.117     0.150
    18.560   259.125     0.150
    18.560   260.836     0.150
    20.415   280.188     0.150
    20.724   282.656     0.150
    21.117   287.586     0.150
    21.117   286.219     0.150
    21.433   290.719     0.150
    22.127   298.820     0.150
    22.127   297.664     0.150
    22.626   303.875     0.150
    23.476   315.117     0.150
    23.533   313.312     0.150
    34.126   315.438     0.150
    23.951   317.156     0.150
    23.951   316.688     0.150
    23.951   317.188     0.150
    24.623   323.102     0.150
    24.637   323.227     0.150
    24.720   324.758     0.150
    25.057   327.398     0.150
    25.287   328.727     0.150
    25.951   337.430     0.150
    26.116   336.883     0.150
    26.212   336.742     0.150
    26.309   338.891     0.150
    26.312   339.188     0.150
    26.312   338.859     0.150
    26.676   342.734     0.150
    26.676   342.336     0.150
    27.742   351.727     0.150
    28.296   356.695     0.150
    28.274   356.516     0.150
    29.765   361.633     0.150
    28.945   361.688     0.150
    28.945   362.109     0.150
    29.284   364.695     0.150
    29.417   365.430     0.150
    29.996   371.258     0.150
    30.083   373.445     0.150
    30.394   374.586     0.150
    30.480   375.664     0.150
    30.480   375.453     0.150
    30.726   378.484     0.150
    30.726   378.156     0.150
    30.728   378.484     0.150
    30.759   378.812     0.150
    30.771   378.758     0.150
    31.082   379.984     0.150
    31.180   382.242     0.150
    31.825   389.055     0.150
    33.178   400.484     0.150
    33.178   399.375     0.150
    33.178   400.133     0.150
    33.424   401.172     0.150
    33.424   401.977     0.150
    33.450   402.562     0.150
    33.578   403.188     0.150
    33.578   401.180     0.150
    33.578   402.180     0.150
    33.845   406.383     0.150
    33.845   406.180     0.150
    33.892   406.484     0.150
    34.063   406.734     0.150
    34.367   411.156     0.150
    34.794   413.844     0.150
    35.005   415.266     0.150
    35.036   415.086     0.150
    35.036   415.656     0.150
    35.036   415.125     0.150
    35.238   417.430     0.150
    36.279   423.984     0.150
    36.450   428.227     0.150
    36.440   426.734     0.150
    36.638   429.289     0.150
    36.665   432.883     0.150
    36.665   432.883     0.150
    36.665   432.883     0.150
    36.665   432.883     0.150
    36.665   432.883     0.150
    36.665   432.883     0.150
    36.665   430.984     0.150
    36.665   430.344     0.150
    36.665   430.789     0.150
    36.950   432.367     0.150
    37.442   435.281     0.150
    37.442   434.969     0.150
    37.462   436.273     0.150
    37.462   436.336     0.150
    37.903   440.648     0.150
    37.904   441.383     0.150
    38.171   441.219     0.150
    38.171   441.328     0.150
    38.341   444.484     0.150
    39.175   448.664     0.150
    39.710   454.906     0.150
    39.710   454.375     0.150
    39.823   455.562     0.150
    39.796   456.086     0.150
    39.861   456.383     0.150
    39.878   458.586     0.150
    39.878   457.406     0.150
    39.878   457.805     0.150
    40.354   460.484     0.150
    40.354   460.656     0.150
    40.354   459.734     0.150
    40.589   463.406     0.150
    40.589   463.656     0.150
    40.622   462.281     0.150
    40.622   461.953     0.150
    40.701   463.312     0.150
    40.769   463.469     0.150
    40.941   466.016     0.150
    40.998   465.633     0.150
    41.065   467.203     0.150
    41.065   466.555     0.150
    41.084   468.578     0.150
    41.053   468.609     0.150
    41.053   468.227     0.150
    41.265   468.727     0.150
    41.789   472.305     0.150
    41.786   472.688     0.150
    42.009   473.508     0.150
    42.009   473.898     0.150
    42.009   473.289     0.150
    41.954   473.430     0.150
    42.017   476.250     0.150
    42.017   476.688     0.150
    42.183   474.211     0.150
    42.183   477.156     0.150
    42.080   476.227     0.150
    42.227   475.703     0.150
    42.282   476.805     0.150
    42.318   477.125     0.150
    42.382   477.297     0.150
    43.399   485.445     0.150
    43.529   486.383     0.150
    43.744   490.430     0.150
    43.744   489.664     0.150
    44.136   491.617     0.150
    44.931   497.727     0.150
    45.220   499.914     0.150
    45.220   500.047     0.150
    45.220   499.883     0.150
    45.536   503.734     0.150
    45.472   502.312     0.150
    45.472   502.383     0.150
    46.026   507.125     0.150
    46.788   512.953     0.150
    46.866   516.383     0.150
    46.866   515.484     0.150
    46.866   514.930     0.150
    47.047   513.984     0.150
    47.398   517.086     0.150
    47.397   516.891     0.150
    48.514   525.383     0.150
    48.722   527.484     0.150
    48.722   527.992     0.150
    48.722   527.867     0.150
    48.865   531.164     0.150
    49.370   532.984     0.150
    49.777   534.484     0.150
    49.777   534.289     0.150
    49.777   534.375     0.150
    50.072   536.648     0.150
    50.280   539.445     0.150
    50.280   540.047     0.150
    50.670   542.047     0.150
    50.908   542.586     0.150
    51.904   550.273     0.150
    51.930   553.188     0.150
    51.930   552.102     0.150
    51.930   551.055     0.150
    52.843   556.742     0.150
    53.002   559.516     0.150
    53.487   562.797     0.150
    53.636   563.188     0.150
    53.708   563.539     0.150
    53.806   565.359     0.150
    53.806   564.805     0.150
    54.004   567.086     0.150
    54.021   566.562     0.150
    54.173   568.188     0.150
    54.173   568.398     0.150
    54.348   567.844     0.150
    54.980   572.516     0.150
    55.048   575.805     0.150
    55.048   573.938     0.150
    55.389   577.680     0.150
    55.389   577.188     0.150
    55.389   577.789     0.150
    55.596   580.062     0.150
    56.130   582.258     0.150
    56.455   585.297     0.150
    56.554   585.852     0.150
    56.554   585.828     0.150
    56.714   585.445     0.150
    56.803   585.438     0.150
    56.921   587.844     0.150
    56.921   587.930     0.150
    57.112   588.516     0.150
    57.170   588.930     0.150
    57.373   591.305     0.150
    57.351   592.234     0.150
    57.351   591.625     0.150
    57.326   590.844     0.150
    57.832   594.586     0.150
    57.890   595.836     0.150
    57.890   595.688     0.150
    57.880   595.148     0.150
    58.042   595.484     0.150
    58.216   598.586     0.150
    58.214   596.133     0.150
    58.341   598.586     0.150
    58.580   600.188     0.150
    58.718   601.016     0.150
    58.974   601.289     0.150
    59.067   602.289     0.150
    59.065   602.055     0.150
    59.073   601.984     0.150
    59.431   605.688     0.150
    59.431   605.688     0.150
    59.431   605.688     0.150
    59.431   605.688     0.150
    59.431   605.688     0.150
    59.431   605.688     0.150
    59.431   605.984     0.150
    59.431   606.305     0.150
    59.431   605.594     0.150
    59.431   605.188     0.150
    59.521   605.969     0.150
    59.521   604.594     0.150
    59.585   605.742     0.150
    59.680   607.109     0.150
    59.742   607.664     0.150
    59.742   608.547     0.150
    59.733   606.906     0.150
    59.903   608.688     0.150
    59.903   608.828     0.150
    59.957   609.109     0.150
    59.961   608.594     0.150
    60.057   609.773     0.150
    60.057   610.094     0.150
    60.174   609.219     0.150
    60.195   608.984     0.150
    60.248   611.758     0.150
    60.248   611.406     0.150
    60.214   610.328     0.150
    60.249   610.836     0.150
    60.465   613.336     0.150
    60.504   613.625     0.150
    60.630   614.156     0.150
    60.630   614.430     0.150
    60.630   614.688     0.150
    60.653   613.320     0.150
    60.653   612.289     0.150
    60.660   612.859     0.150
    60.848   615.125     0.150
    60.831   614.836     0.150
    60.880   617.086     0.150
    60.983   615.883     0.150
    60.983   616.039     0.150
    61.141   615.469     0.150
    61.141   616.742     0.150
    61.105   616.273     0.150
    61.133   617.047     0.150
    61.148   615.789     0.150
    61.209   617.977     0.150
    61.209   618.883     0.150
    61.353   618.789     0.150
    61.439   618.297     0.150
    61.626   620.539     0.150
    61.815   620.617     0.150
    61.815   620.695     0.150
    61.757   621.312     0.150
    61.803   623.445     0.150
    61.887   623.734     0.150
    62.042   622.383     0.150
    62.132   624.477     0.150
    62.523   627.008     0.150
    62.630   627.219     0.150
    62.702   626.188     0.150
    62.702   626.906     0.150
    62.917   629.219     0.150
    59.016   629.680     0.150
    62.988   630.875     0.150
    63.203   629.109     0.150
    63.203   629.992     0.150
    63.368   630.492     0.150
    63.361   633.109     0.150
    63.366   632.469     0.150
    63.901   635.484     0.150
    64.022   639.594     0.150
    63.953   637.438     0.150
    64.044   636.992     0.150
    27.655   640.016     0.150
    64.368   639.617     0.150
    64.415   638.484     0.150
    64.415   638.578     0.150
    64.453   640.078     0.150
    64.476   641.234     0.150
    64.604   642.086     0.150
    64.752   641.875     0.150
    64.753   642.914     0.150
    64.784   643.234     0.150
    65.001   642.586     0.150
    65.060   642.086     0.150
    65.060   642.109     0.150
    65.060   641.688     0.150
    65.155   643.984     0.150
    65.185   644.367     0.150
    65.342   645.609     0.150
    65.512   647.273     0.150
    65.728   648.867     0.150
    65.731   648.375     0.150
    78.322   649.055     0.150
    65.816   649.062     0.150
    65.893   652.859     0.150
    65.893   649.328     0.150
    66.011   649.508     0.150
    66.165   654.656     0.150
    66.165   651.398     0.150
    66.169   650.797     0.150
    66.378   650.773     0.150
    66.358   652.875     0.150
    66.412   656.859     0.150
    66.433   652.703     0.150
    66.458   652.797     0.150
    66.515   656.758     0.150
    66.640   652.789     0.150
    66.727   658.344     0.150
    66.727   655.656     0.150
    66.788   663.297     0.150
    66.822   656.805     0.150
    66.876   655.805     0.150
    66.901   660.062     0.150
    66.947   654.289     0.150
    66.995   656.547     0.150
    67.026   656.609     0.150
    67.205   658.109     0.150
    67.237   657.109     0.150
    67.260   661.883     0.150
    67.341   659.539     0.150
    67.400   658.633     0.150
    67.414   657.086     0.150
    67.456   659.438     0.150
    67.581   661.805     0.150
    67.615   661.008     0.150
    67.668   661.094     0.150
    67.679   661.219     0.150
    67.688   660.156     0.150
    67.730   664.656     0.150
    67.730   661.656     0.150
    67.731   662.008     0.150
    67.778   664.867     0.150
    67.897   659.586     0.150
    67.885   661.680     0.150
    67.889   662.930     0.150
    67.932   663.203     0.150
    67.960   660.289     0.150
    67.960   660.289     0.150
    67.960   660.289     0.150
    67.960   660.734     0.150
    67.960   659.789     0.150
    67.978   666.086     0.150
    67.978   666.086     0.150
    67.978   666.086     0.150
    67.978   666.086     0.150
    67.978   666.086     0.150
    67.978   666.086     0.150
    67.978   662.906     0.150
    68.077   663.195     0.150
    68.146   664.539     0.150
    68.146   663.773     0.150
    68.093   664.445     0.150
    68.122   667.148     0.150
    33.362   663.656     0.150
    68.166   664.734     0.150
    68.168   667.523     0.150
    68.213   667.609     0.150
    68.213   664.359     0.150
    68.216   667.492     0.150
    68.218   662.719     0.150
    68.258   667.945     0.150
    68.258   665.086     0.150
    68.266   667.883     0.150
    68.300   663.312     0.150
    68.316   663.523     0.150
    68.333   665.367     0.150
    68.367   665.234     0.150
    68.369   664.680     0.150
    68.378   665.039     0.150
    68.404   666.562     0.150
    68.404   666.734     0.150
    68.404   665.359     0.150
    68.454   668.969     0.150
    68.454   666.328     0.150
    68.459   665.930     0.150
    68.469   665.828     0.150
    68.469   665.023     0.150
    68.481   665.219     0.150
    68.510   669.688     0.150
    68.520   669.578     0.150
    68.520   667.508     0.150
    68.537   666.438     0.150
    68.553   666.383     0.150
    68.555   664.938     0.150
    68.597   669.289     0.150
    68.614   669.484     0.150
    68.614   669.484     0.150
    68.614   669.484     0.150
    68.614   669.484     0.150
    68.614   669.484     0.150
    68.614   669.484     0.150
    68.614   667.172     0.150
    68.614   666.188     0.150
    68.622   670.234     0.150
    68.624   666.719     0.150
    68.632   669.445     0.150
    68.635   666.617     0.150
    68.662   667.812     0.150
    68.725   669.477     0.150
    68.743   666.969     0.150
    68.744   676.938     0.150
    68.828   666.859     0.150
    68.828   667.203     0.150
    68.795   669.789     0.150
    68.795   669.789     0.150
    68.795   669.789     0.150
    68.795   669.789     0.150
    68.795   669.789     0.150
    68.795   669.789     0.150
    68.795   666.539     0.150
    68.800   670.938     0.150
   110.513   667.812     0.150
    15.576   667.188     0.150
    68.883   667.508     0.150
    68.883   666.727     0.150
    68.883   666.805     0.150
    68.893   671.656     0.150
    69.033   674.125     0.150
    68.917   672.125     0.150
    68.935   667.328     0.150
    68.941   669.586     0.150
    68.941   669.586     0.150
    68.941   669.586     0.150
    68.941   669.586     0.150
    68.941   669.586     0.150
    68.941   669.586     0.150
    68.941   666.891     0.150
    68.959   669.617     0.150
    68.970   669.648     0.150
    68.997   672.273     0.150
    69.025   669.469     0.150
    69.055   667.883     0.150
    69.079   669.906     0.150
    69.208   670.023     0.150
    69.208   668.578     0.150
    69.094   669.758     0.150
    69.094   669.234     0.150
    69.136   669.312     0.150
    69.129   668.531     0.150
    69.154   670.586     0.150
    69.154   670.586     0.150
    69.154   670.586     0.150
    69.154   670.586     0.150
    69.154   670.586     0.150
    69.154   670.586     0.150
    69.205   670.828     0.150
    69.205   673.945     0.150
    69.215   670.609     0.150
    69.249   674.055     0.150
    69.317   671.836     0.150
    69.352   669.953     0.150
    69.352   670.648     0.150
    69.352   681.117     0.150
    69.379   674.688     0.150
    69.379   674.688     0.150
    69.379   674.688     0.150
    69.379   674.688     0.150
    69.379   674.688     0.150
    69.379   674.688     0.150
    69.379   671.438     0.150
    69.405   675.836     0.150
    69.475   675.703     0.150
    69.530   676.289     0.150
    69.530   676.289     0.150
    69.530   676.289     0.150
    69.530   676.289     0.150
    69.530   676.289     0.150
    69.530   676.289     0.150
    69.535   672.320     0.150
    69.537   655.078     0.150
    69.734   677.492     0.150
    69.747   668.695     0.150
    69.779   677.414     0.150
    69.813   675.047     0.150
    69.813   677.828     0.150
    69.831   674.797     0.150
    69.940   675.648     0.150
    70.021   675.797     0.150
    70.106   674.289     0.150
    70.173   675.078     0.150
    29.765   673.961     0.150
    70.167   674.383     0.150
    70.183   679.586     0.150
    70.183   679.586     0.150
    70.183   679.586     0.150
    70.183   679.586     0.150
    70.183   679.586     0.150
    70.183   679.586     0.150
    70.235   677.062     0.150
    70.260   680.289     0.150
    70.260   680.289     0.150
    70.260   680.289     0.150
    70.260   680.289     0.150
    70.260   680.289     0.150
    70.260   680.289     0.150
    70.260   677.148     0.150
    70.260   677.883     0.150
    70.347   678.484     0.150
    70.470   682.188     0.150
    70.470   682.188     0.150
    70.470   682.188     0.150
    70.470   682.188     0.150
    70.470   682.188     0.150
    70.471   678.688     0.150
    70.471   678.688     0.150
    70.471   678.688     0.150
    70.471   678.688     0.150
    70.471   678.688     0.150
    70.471   678.688     0.150
    70.498   679.469     0.150
    70.525   682.289     0.150
    70.525   682.289     0.150
    70.525   682.289     0.150
    70.525   682.289     0.150
    70.525   679.883     0.150
    70.526   678.719     0.150
    70.525   679.398     0.150
    70.533   681.688     0.150
    70.533   681.688     0.150
    70.533   681.688     0.150
    70.533   681.688     0.150
    70.533   678.789     0.150
    70.533   679.289     0.150
    70.567   681.586     0.150
    70.567   681.586     0.150
    70.567   681.586     0.150
    70.567   681.586     0.150
    70.567   681.586     0.150
    70.613   677.727     0.150
    70.618   679.805     0.150
    70.652   677.016     0.150
    70.662   682.664     0.150
    70.662   679.469     0.150
    70.690   682.984     0.150
    70.690   682.984     0.150
    70.690   682.984     0.150
    70.690   682.984     0.150
    70.690   682.984     0.150
    70.743   683.789     0.150
    70.743   683.789     0.150
    70.743   683.789     0.150
    70.743   683.789     0.150
    70.743   680.742     0.150
    70.743   680.719     0.150
    70.743   680.688     0.150
    70.794   684.586     0.150
    70.794   684.586     0.150
    70.794   684.586     0.150
    70.794   684.586     0.150
    70.794   680.383     0.150
    70.843   681.289     0.150
    70.843   681.289     0.150
    70.843   681.289     0.150
    70.843   681.289     0.150
    70.843   679.539     0.150
    70.843   679.383     0.150
    70.895   685.484     0.150
    70.895   685.484     0.150
    70.895   685.484     0.150
    70.895   685.484     0.150
    70.895   685.484     0.150
    70.895   682.055     0.150
    70.916   681.086     0.150
    70.916   681.086     0.150
    70.916   681.086     0.150
    70.916   681.086     0.150
    70.916   681.086     0.150
    70.916   679.969     0.150
    70.931   676.273     0.150
    70.970   681.844     0.150
    71.059   688.883     0.150
    71.059   688.883     0.150
    71.059   688.883     0.150
    71.059   688.883     0.150
    71.059   682.945     0.150
    71.059   685.883     0.150
    71.021   681.898     0.150
    71.090   685.883     0.150
    71.090   685.883     0.150
    71.090   685.883     0.150
    71.090   685.883     0.150
    71.090   682.984     0.150
    71.116   684.688     0.150
    71.116   684.688     0.150
    71.116   684.688     0.150
    71.116   684.688     0.150
    42.516   681.617     0.150
    71.166   683.375     0.150
    71.168   679.539     0.150
    71.166   689.383     0.150
    71.166   689.383     0.150
    71.166   689.383     0.150
    71.166   686.383     0.150
    29.765   682.062     0.150
    71.277   685.859     0.150
    71.294   683.836     0.150
    71.365   687.289     0.150
    71.365   687.289     0.150
    71.365   687.289     0.150
    71.365   687.289     0.150
    71.365   683.719     0.150
    71.370   682.945     0.150
    71.396   687.383     0.150
    71.396   687.383     0.150
    71.396   687.383     0.150
    71.396   687.383     0.150
    71.396   687.383     0.150
    71.396   686.273     0.150
    71.396   684.453     0.150
    71.398   689.289     0.150
    71.398   689.289     0.150
    71.398   689.289     0.150
    71.398   689.289     0.150
    71.398   689.211     0.150
    71.398   686.383     0.150
    71.414   683.086     0.150
    71.480   684.930     0.150
    71.480   688.188     0.150
    71.480   688.188     0.150
    71.480   688.188     0.150
    71.480   688.188     0.150
    71.480   685.383     0.150
    71.508   686.688     0.150
    71.508   686.688     0.150
    71.508   686.688     0.150
    71.508   686.688     0.150
    71.508   686.688     0.150
    71.508   685.758     0.150
    71.508   685.453     0.150
    71.508   684.586     0.150
    71.525   683.242     0.150
    71.876   685.984     0.150
    71.568   679.492     0.150
    71.679   684.664     0.150
    71.679   685.328     0.150
    71.624   685.594     0.150
    71.630   687.586     0.150
    71.631   686.812     0.150
    71.686   690.086     0.150
    71.686   690.086     0.150
    71.742   690.383     0.150
    71.834   685.039     0.150
    71.856   687.133     0.150
    71.920   686.359     0.150
    71.920   685.977     0.150
    71.893   685.586     0.150
    71.894   685.484     0.150
    71.877   693.719     0.150
    71.964   670.172     0.150
    71.967   687.484     0.150
    72.087   688.594     0.150
    72.120   683.430     0.150
    72.155   688.586     0.150
    72.242   687.969     0.150
    72.254   694.688     0.150
    72.254   694.688     0.150
    72.254   694.688     0.150
    72.254   689.320     0.150
    72.262   690.680     0.150
    72.295   690.648     0.150
    72.304   693.383     0.150
    72.304   693.383     0.150
    72.304   693.383     0.150
    72.356   693.484     0.150
    72.356   693.484     0.150
    72.356   693.484     0.150
    72.356   693.484     0.150
    72.356   691.922     0.150
    72.389   694.586     0.150
    72.389   694.586     0.150
    72.389   694.586     0.150
    72.389   693.820     0.150
    72.531   694.586     0.150
    72.534   691.086     0.150
    72.535   690.492     0.150
    72.537   691.406     0.150
    72.581   691.414     0.150
    72.649   690.391     0.150
    72.649   690.523     0.150
    72.589   690.469     0.150
    72.607   691.695     0.150
    72.646   691.695     0.150
    72.666   691.305     0.150
    72.784   691.484     0.150
    29.765   692.742     0.150
    72.812   692.555     0.150
    72.838   687.117     0.150
    72.841   694.570     0.150
    72.847   695.336     0.150
    72.847   692.586     0.150
    72.854   669.688     0.150
    72.890   691.828     0.150
    72.923   693.203     0.150
    72.864   655.883     0.150
    72.923   691.992     0.150
    72.937   693.227     0.150
    72.975   687.914     0.150
    72.975   693.062     0.150
    73.000   696.055     0.150
    73.053   696.477     0.150
    73.102   698.984     0.150
    73.142   696.273     0.150
    73.155   692.992     0.150
    73.172   697.938     0.150
    29.765   689.109     0.150
    73.236   693.734     0.150
    73.219   698.586     0.150
    73.219   698.586     0.150
    73.219   698.586     0.150
    73.219   694.531     0.150
    73.219   695.383     0.150
    73.268   649.336     0.150
    73.273   696.859     0.150
    34.010   695.102     0.150
    34.010   694.445     0.150
    73.314   699.016     0.150
    73.357   700.406     0.150
    73.384   696.883     0.150
    73.392   705.188     0.150
    73.392   705.188     0.150
    73.392   697.078     0.150
    73.427   694.930     0.150
    73.447   694.789     0.150
    73.435   698.516     0.150
    73.441   666.695     0.150
    73.447   697.445     0.150
    73.476   703.203     0.150
    73.510   695.867     0.150
    73.494   705.484     0.150
    73.494   705.484     0.150
    73.494   705.484     0.150
    73.494   700.008     0.150
    73.494   697.742     0.150
    73.559   695.656     0.150
    73.501   696.359     0.150
    73.502   697.133     0.150
    73.512   698.383     0.150
    73.524   700.781     0.150
    73.548   698.492     0.150
    73.554   697.828     0.150
    73.575   693.945     0.150
    73.621   696.383     0.150
    73.621   696.609     0.150
    73.621   695.836     0.150
    73.671   695.633     0.150
    73.624   700.008     0.150
    73.625   705.984     0.150
    73.625   705.984     0.150
    73.625   705.984     0.150
    73.625   699.102     0.150
    73.627   699.281     0.150
    73.631   703.836     0.150
    73.694   696.359     0.150
    73.695   700.789     0.150
    73.745   697.047     0.150
    73.762   697.820     0.150
    73.766   700.109     0.150
    73.789   679.539     0.150
    73.789   700.211     0.150
    73.794   699.586     0.150
    73.794   698.258     0.150
    73.797   707.484     0.150
    73.797   707.484     0.150
    73.797   707.484     0.150
    73.797   702.430     0.150
    73.797   699.453     0.150
    73.818   655.672     0.150
    29.765   657.211     0.150
    73.830   697.617     0.150
    73.843   701.609     0.150
    73.854   698.242     0.150
    73.870   699.484     0.150
    73.909   697.094     0.150
    73.892   701.266     0.150
    73.903   701.680     0.150
    73.908   704.922     0.150
    73.911   702.836     0.150
    73.916   702.273     0.150
    73.949   701.719     0.150
    73.976   701.273     0.150
    73.979   700.695     0.150
    73.979   700.695     0.150
    73.982   704.008     0.150
    74.037   702.602     0.150
    74.086   706.023     0.150
    74.114   683.570     0.150
    74.114   700.945     0.150
    74.188   700.008     0.150
    74.188   699.797     0.150
    74.145   705.305     0.150
    74.207   701.047     0.150
    74.212   703.820     0.150
    74.220   701.781     0.150
    74.220   701.633     0.150
    74.261   708.070     0.150
    74.294   704.086     0.150
    74.301   704.523     0.150
    74.367   700.195     0.150
    74.326   703.844     0.150
    74.337   703.297     0.150
    74.337   701.969     0.150
    74.342   703.398     0.150
    74.400   700.117     0.150
    74.467   702.930     0.150
    74.631   705.086     0.150
    74.631   704.477     0.150
    74.635   703.938     0.150
    74.659   712.000     0.150
    74.659   704.648     0.150
    74.665   707.891     0.150
    74.672   698.859     0.150
    74.757   703.703     0.150
    74.701   703.648     0.150
    74.710   701.539     0.150
    74.794   702.656     0.150
    74.762   706.641     0.150
    74.774   685.922     0.150
    74.793   712.008     0.150
    74.804   678.391     0.150
    74.811   704.867     0.150
    74.813   706.867     0.150
    74.823   703.047     0.150
    74.878   706.188     0.150
    74.884   700.000     0.150
    74.889   670.562     0.150
    14.703   702.531     0.150
    14.703   703.688     0.150
    74.916   704.797     0.150
    74.938   714.016     0.150
    74.950   703.289     0.150
    74.975   702.758     0.150
    74.991   707.375     0.150
    75.031   708.281     0.150
    75.031   699.500     0.150
    75.047   662.852     0.150
    75.047   705.586     0.150
    75.057   711.195     0.150
    75.072   705.195     0.150
    75.125   710.719     0.150
    75.125   708.641     0.150
    75.183   707.648     0.150
    75.219   708.305     0.150
    75.309   707.234     0.150
    75.310   709.820     0.150
    75.321   710.227     0.150
    75.332   707.680     0.150
    75.404   708.414     0.150
    75.372   706.258     0.150
    75.444   706.398     0.150
    75.556   708.469     0.150
    75.693   704.438     0.150
    75.722   710.234     0.150
    75.757   712.016     0.150
    75.774   706.750     0.150
    75.869   709.734     0.150
    75.811   709.906     0.150
    75.813   706.992     0.150
    29.765   705.156     0.150
    75.837   710.727     0.150
    75.879   674.422     0.150
    76.064   711.633     0.150
    76.064   710.477     0.150
    75.988   710.773     0.150
    75.988   710.383     0.150
    75.988   709.805     0.150
    75.988   710.633     0.150
    76.008   709.578     0.150
    76.053   712.984     0.150
    76.053   711.633     0.150
    76.174   711.672     0.150
    76.126   706.617     0.150
    76.148   712.859     0.150
    76.165   707.773     0.150
    76.211   711.883     0.150
    76.226   714.969     0.150
    76.279   712.625     0.150
    76.387   712.469     0.150
    76.387   713.164     0.150
    76.397   713.633     0.150
    76.432   712.883     0.150
    76.773   714.758     0.150
    76.855   714.227     0.150
    76.923   716.180     0.150
    77.215   716.977     0.150
    77.218   720.898     0.150
    77.226   721.078     0.150
    77.405   717.789     0.150
    77.405   718.109     0.150
    77.423   723.531     0.150
    77.624   721.227     0.150
    77.767   720.844     0.150
    77.914   721.617     0.150
    78.143   727.625     0.150
    51.701   721.961     0.150
    78.064   722.477     0.150
    78.458   727.531     0.150
    78.458   724.727     0.150
    78.532   724.312     0.150
    78.614   725.016     0.150
    78.614   726.242     0.150
    78.707   725.656     0.150
    78.791   736.016     0.150
    79.514   730.805     0.150
    79.746   731.555     0.150
    79.746   730.484     0.150
    79.801   732.656     0.150
    79.884   733.211     0.150
    79.884   733.406     0.150
    79.884   732.445     0.150
    80.671   736.305     0.150
    80.701   736.930     0.150
    80.845   738.609     0.150
    80.845   739.133     0.150
    81.151   739.523     0.150
    81.251   741.047     0.150
    81.719   742.445     0.150
    81.737   742.078     0.150
    82.100   748.055     0.150
    82.311   746.344     0.150
    82.359   745.906     0.150
    82.951   750.430     0.150
    82.951   749.945     0.150
    82.982   748.188     0.150
    83.137   748.094     0.150
    83.373   751.133     0.150
    83.460   750.875     0.150
    83.516   751.562     0.150
    79.282   751.359     0.150
    79.282   753.203     0.150
    84.104   753.438     0.150
    84.185   754.938     0.150
    84.305   754.242     0.150
    84.305   754.016     0.150
    84.799   757.719     0.150
    85.058   760.484     0.150
    57.426   762.688     0.150
    57.426   762.406     0.150
    86.322   764.516     0.150
    86.322   764.305     0.150
    86.354   766.188     0.150
    86.354   766.094     0.150
    87.148   770.133     0.150
    87.148   769.469     0.150
    87.465   769.781     0.150
    87.465   768.953     0.150
    87.478   770.180     0.150
    87.571   769.586     0.150
    87.571   769.586     0.150
    87.763   773.227     0.150
    88.109   773.375     0.150
    88.109   773.945     0.150
    88.170   774.609     0.150
    88.170   773.055     0.150
    88.170   773.516     0.150
    88.492   775.289     0.150
    88.525   775.359     0.150
    88.604   776.078     0.150
    88.604   776.836     0.150
    89.362   779.562     0.150
    89.362   779.703     0.150
    89.404   781.344     0.150
    90.045   785.508     0.150
    90.045   782.625     0.150
    90.144   782.297     0.150
    90.906   786.742     0.150
    90.906   786.562     0.150
    91.022   785.859     0.150
    91.022   785.578     0.150
    91.039   789.664     0.150
    91.237   789.188     0.150
    18.319   791.125     0.150
    91.666   790.328     0.150
    91.794   792.078     0.150
    92.120   792.578     0.150
    92.640   796.836     0.150
    93.107   799.359     0.150
    93.187   798.383     0.150
    93.187   796.164     0.150
    93.276   802.797     0.150
    74.425   799.836     0.150
    94.004   800.859     0.150
    94.004   803.453     0.150
    94.744   809.008     0.150
    94.744   802.930     0.150
    95.128   803.945     0.150
    95.662   810.594     0.150
    95.887   809.164     0.150
    96.253   809.539     0.150
    96.305   810.586     0.150
    33.734   816.156     0.150
    33.734   815.367     0.150
    97.092   816.383     0.150
    97.269   821.664     0.150
    97.269   816.273     0.150
    97.359   817.016     0.150
    98.565   827.453     0.150
    98.592   823.508     0.150
    98.592   822.734     0.150
    98.691   820.969     0.150
    98.814   827.711     0.150
    98.815   824.328     0.150
    98.819   824.664     0.150
    98.819   823.789     0.150
    98.978   824.383     0.150
    29.765   824.305     0.150
    99.665   827.086     0.150
    99.785   827.859     0.150
    99.785   828.359     0.150
    99.785   827.680     0.150
    99.964   828.461     0.150
    99.964   827.969     0.150
   100.162   832.305     0.150
   100.162   831.008     0.150
   100.578   830.336     0.150
   100.773   834.383     0.150
   100.758   836.289     0.150
   100.758   831.219     0.150
   101.736   834.234     0.150
   102.081   837.664     0.150
   102.673   840.945     0.150
   102.673   840.086     0.150
   102.863   840.188     0.150
   103.927   849.008     0.150
   103.927   843.547     0.150
   104.235   852.164     0.150
   105.254   856.906     0.150
   107.957   869.211     0.150
    34.551   414.156     0.150
    29.765  1125.148     0.150
   114.546  1126.438     0.150
   114.689  1127.508     0.150
   115.166  1128.164     0.150
   115.264  1127.586     0.150
   115.333  1122.508     0.150
   115.455  1125.133     0.150
   115.584  1126.586     0.150
   116.043  1129.984     0.150
   116.055  1125.312     0.150
   116.205  1131.438     0.150
   116.613  1124.609     0.150
   117.416  1128.164     0.150
   117.859  1127.062     0.150
   118.576  1131.883     0.150
    29.765  1128.477     0.150
   118.612  1130.914     0.150
   118.932  1135.836     0.150
    29.765  1133.344     0.150
   119.944  1133.109     0.150
   120.897  1135.289     0.150
   120.911  1133.547     0.150
   120.830  1136.781     0.150
   121.893  1137.414     0.150
   122.058  1139.258     0.150
   122.189  1137.273     0.150
   122.829  1138.883     0.150
   123.065  1139.719     0.150
   123.109  1139.562     0.150
   123.253  1144.805     0.150
   124.186  1141.609     0.150
   124.330  1143.008     0.150
   124.365  1140.711     0.150
   124.448  1142.031     0.150
   124.633  1143.234     0.150
   125.239  1147.859     0.150
   125.928  1149.883     0.150
   126.471  1146.633     0.150
   129.274  1148.328     0.150
   132.630  1158.484     0.150
   134.054  1164.305     0.150
   135.711  1160.680     0.150
   136.950  1171.359     0.150
   138.387  1163.703     0.150
   138.786  1169.281     0.150
   139.345  1173.336     0.150
   139.788  1175.234     0.150
   140.224  1169.109     0.150
   140.913  1178.484     0.150
   141.834  1178.055     0.150
   142.292  1169.984     0.150
   143.152  1174.938     0.150
   144.312  1178.383     0.150
   146.420  1184.211     0.150
   148.725  1183.039     0.150
   149.100  1187.055     0.150
   151.084  1188.117     0.150
   151.319  1194.602     0.150
     0.952    15.156     0.150
     1.762    29.477     0.150
     2.255    39.781     0.150
     2.551    43.195     0.150
     4.601    71.445     0.150
     4.612    69.312     0.150
     4.924    73.711     0.150
     9.299   133.500     0.150
    12.297   174.812     0.150
    76.600   711.789     0.150
    24.043   313.492     0.150
    26.265   332.391     0.150
    31.168   375.188     0.150
    33.091   393.789     0.150
    88.579   775.586     0.150
     0.504     7.438     0.150
     0.991    30.938     0.150
     1.051    32.555     0.150
     1.544    48.344     0.150
     1.828    32.359     0.150
     1.828    53.195     0.150
     1.924    57.898     0.150
     5.825    87.008     0.150
    16.211   226.516     0.150
     0.502     7.930     0.150
     0.720    11.711     0.150
     0.890    14.812     0.150
     1.455    27.352     0.150
     1.538    44.914     0.150
     1.690    50.805     0.150
     1.894    30.109     0.150
     5.768    87.914     0.150
    12.248   178.406     0.150
     0.517    13.719     0.150
     0.997    29.289     0.150
     1.148    22.008     0.150
     1.273    21.266     0.150
     1.329    21.742     0.150
     1.433    45.766     0.150
     1.796    32.422     0.150
     2.030    60.297     0.150
     2.165    38.211     0.150
     2.701    40.336     0.150
     2.998    47.305     0.150
     0.531     9.016     0.150
     1.880    56.039     0.150
     7.383   106.453     0.150
     0.774    26.320     0.150
     0.940    28.969     0.150
     0.940    16.352     0.150
     1.097    37.688     0.150
     1.107    31.641     0.150
     1.231    37.289     0.150
     1.231    20.945     0.150
     1.195    21.055     0.150
     1.195    35.859     0.150
     1.383    24.891     0.150
     3.110    92.031     0.150
     3.578    57.875     0.150
     4.304    62.461     0.150
     5.339    83.484     0.150
     0.978    28.758     0.150
     1.250    20.758     0.150
     1.250    37.109     0.150
     1.178    21.516     0.150
     1.915    59.336     0.150
     7.115  3674.672     0.150
    12.169  3742.969     0.150
    23.741  3884.867     0.150
    28.874  3928.672     0.150
    33.682  3972.969     0.150
    49.160  4100.367     0.150
    57.630  4161.672     0.150
    60.464  4180.570     0.150
    62.549  4194.367     0.150
    63.707  4201.867     0.150
    64.242  4205.469     0.150
    64.876  4209.266     0.150
    67.706  4227.766     0.150
    15.434  4233.672     0.150
    73.437  4264.172     0.150
    88.280  4343.867     0.150
     1.237    36.992     0.150
     1.237    20.109     0.150
     1.190    46.320     0.150
     4.306    67.172     0.150
     4.798    72.734     0.150
     6.459    93.062     0.150
    23.732   262.891     0.150
     0.515     7.734     0.150
     0.718    21.164     0.150
     1.025    30.328     0.150
     1.025    16.328     0.150
     1.141    34.273     0.150
     1.326    25.594     0.150
     1.789    53.008     0.150
     2.165    35.727     0.150
     3.996    61.188     0.150
     4.465    67.555     0.150
     0.942    16.078     0.150
     0.942    28.438     0.150
     1.238    20.430     0.150
     1.238    36.094     0.150
     1.191    41.258     0.150
     1.191    35.359     0.150
     1.917    56.969     0.150
     2.010    64.109     0.150
     2.452    42.844     0.150
     2.622    45.992     0.150
     3.585    54.867     0.150
     4.102    62.992     0.150
     4.315    69.234     0.150
     4.578    71.328     0.150
     7.595   112.484     0.150
     8.280   123.148     0.150
     9.151   132.742     0.150
    23.735   264.938     0.150
     1.386    40.891     0.150
     8.291   120.258     0.150
     1.112    33.287     0.150
     1.379    22.777     0.150
     1.763    29.547     0.150
     1.875    59.637     0.150
     2.761    47.617     0.150
    20.457   277.477     0.150
    20.806   283.267     0.150
     1.295    21.175     0.150
     1.941    63.515     0.150
     2.015    64.395     0.150
     2.389    77.105     0.150
    57.837   592.315     0.150
    16.084   227.955     0.150
    26.850   344.245     0.150
    29.607   359.695     0.150
    39.347   450.825     0.150
    68.552   665.355     0.150
    68.743   664.565     0.150
    68.743   664.515     0.150
    69.195   669.125     0.150
    73.369   690.899     0.150
    73.664   694.149     0.150
    73.664   693.535     0.150
    75.425   701.074     0.150
    33.928   811.535     0.150
     1.441    43.946     0.150
     1.441    23.766     0.150
    16.937   231.656     0.150
    17.389   246.726     0.150
    18.744   264.156     0.150
    21.113   290.296     0.150
    21.144   289.566     0.150
    21.430   291.436     0.150
    25.283   332.396     0.150
    29.992   373.306     0.150
     0.742    21.202     0.150
     0.928    30.622     0.150
     1.184    34.402     0.150
     1.184    19.112     0.150
     1.913    61.492     0.150
     2.494    75.633     0.150
     3.251    96.372     0.150
     3.228   100.652     0.150
    21.418   291.072     0.150
    74.741   700.362     0.150
     1.937    62.211     0.150
    23.782   314.041     0.150
     0.976    18.475     0.150
     1.302    41.344     0.150
     1.434    23.954     0.150
    20.737   284.754     0.150
     1.059    31.621     0.150
     1.180    34.730     0.150
     1.920    62.381     0.150
    76.052   297.531     0.150
    29.615   401.440     0.150
    40.106   458.690     0.150
    34.016   809.392     0.150
     0.986    32.602     0.150
     1.110    32.642     0.150
     1.224    20.422     0.150
     0.570    16.416     0.150
     2.514    39.566     0.150
     4.746    67.006     0.150
     9.057   133.387     0.150
   124.474   252.656     0.150
     1.250    20.346     0.150
     1.910    32.197     0.150
     2.622    46.217     0.150
     5.346    85.146     0.150
    67.694   658.926     0.150
     1.935    62.141     0.150
     1.223    20.039     0.150
    15.454   221.549     0.150
    15.680   217.879     0.150
    16.490   237.266     0.150
    39.480   452.688     0.150
     0.488     9.977     0.150
     0.932    16.938     0.150
     1.207    36.148     0.150
     1.890    56.469     0.150
    30.217   371.348     0.150
     0.699    13.203     0.150
     1.199    36.195     0.150
     1.093    33.523     0.150
     1.093    19.152     0.150
     1.318    38.965     0.150
     1.495    46.285     0.150
     2.362    38.695     0.150
     6.057    90.543     0.150
   124.603   254.363     0.150
    20.609   283.793     0.150
    30.621   377.055     0.150
    34.849   411.672     0.150
    39.332   451.984     0.150
     1.443    23.902     0.150
     1.705    50.043     0.150
     1.822    59.730     0.150
    15.241   213.762     0.150
    23.954   264.141     0.150
     0.922    30.098     0.150
     1.238    20.008     0.150
     1.238    37.008     0.150
     4.288    67.398     0.150
    30.186   371.738     0.150
     0.551    10.137     0.150
     0.948    17.598     0.150
     0.861    29.324     0.150
     1.262    20.598     0.150
     1.440    44.074     0.150
     3.555    60.188     0.150
     4.833    73.625     0.150
     5.319    83.375     0.150
    22.019   299.496     0.150
     1.362    22.523     0.150
     1.362    40.375     0.150
     2.032    65.414     0.150
     2.683    45.566     0.150
     2.742    47.656     0.150
     0.893    30.898     0.150
     1.369    41.418     0.150
     1.369    22.457     0.150
     1.866    59.766     0.150
     2.329    72.398     0.150
     3.055    91.609     0.150
    98.184   278.207     0.150
    20.508   279.078     0.150
    57.908   591.445     0.150
    10.198   150.977     0.150
    10.454   155.359     0.150
    26.209   339.566     0.150
    30.852   377.906     0.150
    33.269   400.598     0.150
    34.941   414.488     0.150
    40.260   458.777     0.150
    45.002   500.617     0.150
    48.427   526.086     0.150
    50.841   543.680     0.150
    52.775   557.055     0.150
    54.280   567.867     0.150
    59.336   605.328     0.150
    60.559   610.188     0.150
    64.967   641.688     0.150
    67.151   657.555     0.150
    67.612   660.531     0.150
    67.828   661.508     0.150
    68.243   664.734     0.150
    68.321   664.000     0.150
    68.409   664.836     0.150
    68.608   665.797     0.150
    15.536   665.688     0.150
    68.878   668.648     0.150
    68.998   669.336     0.150
    69.025   668.609     0.150
    70.684   679.445     0.150
    70.782   680.297     0.150
    72.197   687.836     0.150
    73.159   693.867     0.150
    73.436   695.938     0.150
    18.407   789.430     0.150
     1.225    20.133     0.150
     1.225    36.766     0.150
     1.440    45.352     0.150
     1.608    49.523     0.150
     1.730    56.133     0.150
     3.206    51.133     0.150
    18.180   252.891     0.150
    19.735   270.516     0.150
    29.652   399.219     0.150
    39.794   453.125     0.150
    42.213   472.836     0.150
    54.033   564.781     0.150
    87.882   769.398     0.150
   149.529  1187.242     0.150
     6.199    93.844     0.150
     7.089   103.750     0.150
     7.089   103.914     0.150
    10.343   153.320     0.150
    16.103   232.812     0.150
    23.727   312.742     0.150
    23.762   316.500     0.150
    34.350   317.062     0.150
    29.652   359.961     0.150
    30.699   376.031     0.150
    34.832   411.102     0.150
    37.662   435.586     0.150
    38.127   440.039     0.150
    39.794   455.531     0.150
    56.628   584.875     0.150
    56.707   584.805     0.150
    57.241   589.312     0.150
    58.985   601.133     0.150
    59.209   602.539     0.150
    59.209   602.508     0.150
    59.209   602.461     0.150
    64.872   638.992     0.150
    65.312   644.359     0.150
    67.195   656.414     0.150
    67.408   657.992     0.150
    67.692   660.289     0.150
    67.764   657.289     0.150
    67.930   663.445     0.150
    67.930   663.445     0.150
    68.407   663.203     0.150
    68.559   666.641     0.150
    68.559   666.641     0.150
    68.578   662.586     0.150
    68.745   666.539     0.150
    68.745   666.539     0.150
    68.797   664.086     0.150
    68.889   667.945     0.150
    68.889   667.945     0.150
    69.102   668.641     0.150
    69.475   673.445     0.150
    69.475   673.445     0.150
    69.912   674.180     0.150
    70.134   675.344     0.150
    70.398   675.445     0.150
    70.420   679.039     0.150
    70.469   676.539     0.150
    70.474   679.445     0.150
    70.474   679.445     0.150
    70.474   677.195     0.150
    70.497   680.039     0.150
    70.497   680.039     0.150
    70.576   676.359     0.150
    70.621   678.242     0.150
    70.683   677.945     0.150
    70.683   677.016     0.150
    70.746   679.141     0.150
    70.746   679.141     0.150
    70.776   678.242     0.150
    70.842   678.945     0.150
    70.842   678.945     0.150
    70.941   680.164     0.150
    71.034   680.945     0.150
    71.113   683.242     0.150
    71.113   683.242     0.150
    71.326   684.242     0.150
    71.326   684.242     0.150
    71.321   682.242     0.150
    71.321   682.242     0.150
    71.426   685.242     0.150
    71.426   685.242     0.150
    71.443   685.844     0.150
    71.443   685.844     0.150
    71.639   682.047     0.150
    72.199   689.242     0.150
    72.250   689.844     0.150
    72.250   689.844     0.150
    72.287   689.945     0.150
    29.652   688.984     0.150
    29.652   690.969     0.150
    73.155   694.844     0.150
    73.155   691.398     0.150
    73.433   693.203     0.150
    33.789   694.375     0.150
    33.789   694.383     0.150
    74.752   699.070     0.150
     1.204    19.273     0.150
     1.204    34.086     0.150
     1.976    62.656     0.150
     3.993    69.297     0.150
    66.858   251.773     0.150
    23.721   263.773     0.150
    19.590   272.453     0.150
    98.302   278.664     0.150
    20.622   280.898     0.150
    21.462   291.984     0.150
    27.964   354.398     0.150
    33.708   402.188     0.150
    65.044   639.055     0.150
     0.462     9.291     0.150
     0.714    25.371     0.150
     0.912    31.971     0.150
     1.025    18.331     0.150
     1.025    35.131     0.150
     1.415    23.271     0.150
     3.882    59.081     0.150
    21.444   289.510     0.150
    29.789   398.510     0.150
    39.905   454.311     0.150
    42.260   473.431     0.150
    42.381   474.851     0.150
    53.819   563.631     0.150
    57.352   588.081     0.150
    60.043   607.111     0.150
    60.615   610.971     0.150
     1.227    23.140     0.150
     1.227    42.575     0.150
     2.311    37.795     0.150
     2.311    73.029     0.150
     2.311    38.291     0.150
     3.090    50.000     0.150
     2.986    46.486     0.150
     3.161    50.601     0.150
     3.703    58.087     0.150
     4.513    70.301     0.150
    10.137   150.471     0.150
    10.359   152.411     0.150
    13.984   203.381     0.150
    14.000   206.190     0.150
    17.619   246.956     0.150
    18.557   260.683     0.150
    18.557   260.671     0.150
    34.143   315.423     0.150
    23.948   315.651     0.150
    23.948   315.701     0.150
    25.986   334.451     0.150
    29.789   360.621     0.150
    30.021   371.401     0.150
    30.097   375.340     0.150
    33.185   400.000     0.150
    35.041   413.899     0.150
    35.041   413.871     0.150
    37.496   436.111     0.150
    37.461   434.561     0.150
    38.202   440.441     0.150
    39.732   454.391     0.150
    39.905   456.379     0.150
    40.352   458.381     0.150
    40.593   463.291     0.150
    42.381   478.571     0.150
    49.804   533.161     0.150
    49.804   533.181     0.150
    49.938   534.576     0.150
    49.938   534.576     0.150
    49.938   534.576     0.150
    49.938   534.576     0.150
    51.956   549.480     0.150
    51.956   549.711     0.150
    55.370   575.500     0.150
    56.829   584.911     0.150
    57.164   587.363     0.150
    57.164   587.288     0.150
    57.164   587.363     0.150
    57.921   593.201     0.150
    58.003   593.141     0.150
    58.003   593.141     0.150
    58.003   593.141     0.150
    58.003   593.141     0.150
    58.003     5.080     0.150
    58.028   593.038     0.150
    58.028   593.538     0.150
    58.028     3.800     0.150
    59.429   604.961     0.150
    59.550   604.651     0.150
    59.550     6.850     0.150
    59.550   604.576     0.150
    59.550   604.651     0.150
    59.550   605.026     0.150
    59.550     2.900     0.150
    59.550     3.400     0.150
    59.550     6.850     0.150
    59.555   604.951     0.150
    59.723   606.990     0.150
    60.866   613.831     0.150
    64.429   637.701     0.150
    65.071   641.301     0.150
    78.348   647.071     0.150
    67.968   659.684     0.150
    68.009   660.871     0.150
    68.644   664.611     0.150
    68.825   665.760     0.150
    15.546   665.301     0.150
    69.347   670.201     0.150
    69.560   671.500     0.150
    42.536   681.953     0.150
    33.991   695.576     0.150
    33.991   694.380     0.150
    73.529   694.980     0.150
    73.631   694.250     0.150
    74.248   698.871     0.150
    76.011   709.000     0.150
    79.314   755.670     0.150
    87.476   769.371     0.150
    88.102   772.230     0.150
    88.163   772.480     0.150
    18.330   788.951     0.150
    33.740   811.791     0.150
    29.789   823.801     0.150
     1.422    23.913     0.150
     1.422    41.393     0.150
     2.293    71.223     0.150
     0.737    19.324     0.150
     0.925    30.324     0.150
     1.061    31.188     0.150
     1.061    17.344     0.150
     1.183    19.215     0.150
     1.183    34.855     0.150
     1.923    62.465     0.150
     1.965    62.586     0.150
     2.366    73.617     0.150
     2.497    42.906     0.150
     3.249    53.496     0.150
     3.221    53.938     0.150
    16.190   226.414     0.150
    16.510   233.266     0.150
    17.448   241.285     0.150
     0.802    11.898     0.150
     0.916    30.500     0.150
     0.971    28.867     0.150
     1.248    20.016     0.150
     1.248    36.125     0.150
    29.609    63.609     0.150
     1.131    18.414     0.150
     1.264    45.334     0.150
     1.264    20.684     0.150
     1.394    23.664     0.150
     1.885    60.384     0.150
     2.788    47.974     0.150
     1.224    36.885     0.150
     1.224    20.424     0.150
     1.483    24.594     0.150
     1.871    57.395     0.150
     5.606    86.914     0.150
     6.725    98.084     0.150
     1.226    20.438     0.150
     1.469    43.375     0.150
     1.469    24.438     0.150
    36.455   139.938     0.150
    10.266   151.898     0.150
    73.243   171.555     0.150
    11.977   170.875     0.150
     2.451    41.078     0.150
    10.373   154.438     0.150
    10.382   153.438     0.150
    20.447   283.055     0.150
    22.406   302.578     0.150
    23.658   314.277     0.150
    33.465   398.477     0.150
    54.784   572.867     0.150
    67.606   658.875     0.150
    15.439   663.977     0.150
    77.473   719.406     0.150
     0.800    23.430     0.150
     1.106    17.980     0.150
     1.221    20.480     0.150
     7.925   117.621     0.150
    73.245   171.500     0.150
    25.567   329.973     0.150
     0.621    17.930     0.150
     1.125    35.391     0.150
     1.235    20.000     0.150
     1.235    36.160     0.150
     1.747    29.430     0.150
     2.116    34.332     0.150
    29.580   239.602     0.150
    66.762   253.172     0.150
   124.521   253.891     0.150
    29.580   260.902     0.150
    29.580   264.531     0.150
    29.580   266.133     0.150
    23.690   265.211     0.150
    29.580   302.230     0.150
    29.580   381.680     0.150
    73.362   383.230     0.150
    31.859   384.551     0.150
    36.646   431.250     0.150
    14.191   205.230     0.150
    16.148   227.832     0.150
    23.690   314.293     0.150
    26.915   343.270     0.150
    29.580   358.641     0.150
    34.779   413.391     0.150
    34.779   413.012     0.150
    52.682   558.012     0.150
    57.090   589.602     0.150
    58.319   599.090     0.150
    60.390   608.891     0.150
    61.292   618.730     0.150
    62.484   625.891     0.150
    64.178   637.891     0.150
    64.813   640.391     0.150
    66.762   654.512     0.150
    67.087   657.113     0.150
    67.644   659.090     0.150
    67.708   660.492     0.150
    67.708   659.500     0.150
    67.708   659.191     0.150
    68.544   664.691     0.150
    15.438   663.891     0.150
    68.723   664.844     0.150
    69.898   673.973     0.150
    70.061   677.992     0.150
    70.061    -0.059     0.150
    70.396   680.691     0.150
    70.423   682.191     0.150
    70.503   674.348     0.150
    70.609   680.293     0.150
    70.673   681.691     0.150
    70.702   680.590     0.150
    70.768   681.090     0.150
    70.961   684.191     0.150
    71.248   681.590     0.150
    72.043   686.363     0.150
    73.082   694.492     0.150
    73.374   695.492     0.150
    73.374   695.402     0.150
    73.482   697.391     0.150
    73.482   692.902     0.150
    33.785   696.160     0.150
    86.065   764.031     0.150
    85.490   767.543     0.150
    87.850   772.570     0.150
    87.912   772.992     0.150
    87.912   772.863     0.150
    87.912   773.391     0.150
    89.106   778.883     0.150
   157.807  1228.023     0.150
     0.950    28.477     0.150
     1.223    20.055     0.150
     1.476    45.547     0.150
     1.885    58.977     0.150
     2.002    33.438     0.150
    98.038   264.219     0.150
     0.960    28.497     0.150
     1.035    35.747     0.150
     1.234    20.277     0.150
     1.234    36.067     0.150
    10.348   152.978     0.150
    29.626   192.167     0.150
     0.471    17.164     0.150
     0.471     9.453     0.150
     0.874    17.125     0.150
     0.978    29.156     0.150
     0.942    16.906     0.150
     1.007    20.406     0.150
     1.248    37.145     0.150
     1.248    20.895     0.150
     1.916    32.004     0.150
     2.369    39.055     0.150
     2.443    39.965     0.150
     3.571    56.164     0.150
     3.869    60.215     0.150
     7.250   106.566     0.150
     8.281   119.004     0.150
    10.322   151.664     0.150
    29.652   190.684     0.150
    18.578   259.445     0.150
    29.652   264.594     0.150
    19.435   269.184     0.150
    29.652   272.613     0.150
    20.225   277.164     0.150
    20.590   280.996     0.150
    21.356   289.254     0.150
    21.624   292.465     0.150
    22.085   297.844     0.150
    34.329   316.125     0.150
    29.652   338.125     0.150
    29.652   342.113     0.150
    29.652   344.684     0.150
    29.652   356.883     0.150
   103.874   358.375     0.150
    29.652   374.926     0.150
     7.167   394.293     0.150
    57.888   594.113     0.150
    60.470   612.383     0.150
    62.557   627.113     0.150
    67.712   659.504     0.150
    67.775   660.844     0.150
    76.325   709.926     0.150
    88.283   775.996     0.150
     2.443    40.363     0.150
     3.571    56.355     0.150
     7.110   104.656     0.150
     8.816   131.844     0.150
    10.322   153.414     0.150
    23.741   314.344     0.150
    28.442   355.875     0.150
    30.677   374.246     0.150
    36.845   428.656     0.150
    39.378   455.793     0.150
    51.956   553.273     0.150
    54.893   575.023     0.150
    56.706   586.824     0.150
    59.730   609.246     0.150
    59.851   609.523     0.150
    66.828   656.105     0.150
    68.018   660.906     0.150
    68.795   664.605     0.150
    70.569   680.656     0.150
    71.314   684.953     0.150
    83.985   755.945     0.150
    87.900   773.125     0.150
    87.962   776.914     0.150
    87.961   776.766     0.150
    34.845   414.395     0.150
    60.470   612.695     0.150
    62.557   627.496     0.150
    63.713   635.496     0.150
    79.973   734.195     0.150
    88.283   775.895     0.150
     0.924    30.391     0.150
     1.055    31.352     0.150
     1.074    36.891     0.150
     1.218    19.938     0.150
     1.336    22.141     0.150
     1.852    58.859     0.150
     1.256    20.740     0.150
     1.071    37.352     0.150
     1.220    20.211     0.150
     2.477    39.180     0.150
    16.143   225.266     0.150
    25.507   328.195     0.150
    39.440   450.258     0.150
    28.476   357.508     0.150
    30.207   372.898     0.150
     1.921    62.133     0.150
     2.099    65.766     0.150
     3.321    98.953     0.150
     3.488   104.883     0.150
    14.954   216.203     0.150
    15.431   222.016     0.150
    29.756   227.004     0.150
   108.125   230.754     0.150
    29.756   232.836     0.150
    29.756   235.652     0.150
    29.756   237.445     0.150
    29.756   240.926     0.150
    29.756   244.043     0.150
    29.756   260.844     0.150
    29.756   261.836     0.150
    29.756   273.383     0.150
    20.388   278.375     0.150
    29.756   306.965     0.150
    31.821   385.586     0.150
    29.756   400.562     0.150
    29.756   820.734     0.150
   148.732  1186.363     0.150
     5.912    88.824     0.150
    10.125   150.074     0.150
    13.940   202.684     0.150
    30.000   372.004     0.150
    30.485   373.414     0.150
    30.767   378.293     0.150
    36.458   429.953     0.150
    36.644   430.414     0.150
    39.180   450.844     0.150
    40.597   465.266     0.150
    59.422   603.973     0.150
    62.692   624.773     0.150
    65.051   642.973     0.150
    78.313   646.355     0.150
    67.887   661.176     0.150
    15.576   664.973     0.150
    70.610   675.836     0.150
    70.786    -0.605     0.150
    71.358    -0.406     0.150
    71.925   687.785     0.150
    34.005   696.184     0.150
    75.979   711.176     0.150
    88.101   771.863     0.150
    88.163   772.285     0.150
     1.255    41.883     0.150
     2.283    38.605     0.150
     2.986    49.652     0.150
     3.669    58.664     0.150
     7.247   106.246     0.150
    36.241   140.109     0.150
    14.006   203.664     0.150
    34.132   314.785     0.150
    30.485   376.543     0.150
    37.461   436.707     0.150
    40.627   463.621     0.150
    53.812   566.402     0.150
    59.422   604.422     0.150
    71.925   688.168     0.150
    34.005   696.082     0.150
    91.028   787.871     0.150
     1.182    19.713     0.150
     4.742    72.033     0.150
    41.690   216.373     0.150
    29.647   218.393     0.150
   124.456   254.912     0.150
    29.647   256.453     0.150
    19.618   269.672     0.150
     1.049    36.750     0.150
     2.507    40.822     0.150
     3.569    56.783     0.150
     7.049   103.982     0.150
    36.491   140.902     0.150
    12.912   190.084     0.150
    14.254   206.410     0.150
    16.120   230.688     0.150
    33.444   402.283     0.150
    36.734   426.482     0.150
    36.907   431.053     0.150
    39.795   455.482     0.150
    40.097   455.582     0.150
    41.082   465.582     0.150
    42.278   475.783     0.150
    42.429   478.713     0.150
    55.126   573.656     0.150
    59.478   605.236     0.150
    59.526   604.703     0.150
    60.864   613.285     0.150
    62.084   621.963     0.150
    78.224   646.252     0.150
    67.938   659.482     0.150
    68.565   663.184     0.150
    15.367   664.383     0.150
    68.896   665.482     0.150
    69.109   666.684     0.150
    77.049   667.859     0.150
   110.778   668.980     0.150
    69.314   668.582     0.150
    69.482   670.082     0.150
    69.482   670.082     0.150
    70.142   673.383     0.150
    70.203   673.982     0.150
    30.632   672.982     0.150
    70.400   674.383     0.150
    70.474   675.482     0.150
    70.481   675.482     0.150
    70.481   675.482     0.150
    70.688   676.883     0.150
    70.780   677.082     0.150
    70.849   678.184     0.150
    71.008   678.883     0.150
    71.041   678.883     0.150
    71.120   679.383     0.150
    71.343   682.082     0.150
    71.343   682.082     0.150
    71.432   681.582     0.150
    71.447   681.982     0.150
    42.778   682.861     0.150
    71.699   682.982     0.150
    71.943   686.277     0.150
    72.205   685.283     0.150
    72.257   685.883     0.150
    72.333   687.582     0.150
    59.070   686.854     0.150
    59.070   687.541     0.150
    29.647   691.494     0.150
    73.409   694.053     0.150
    33.746   695.203     0.150
    33.746   695.771     0.150
    75.862   707.863     0.150
    77.590   717.062     0.150
    79.259   753.094     0.150
    86.056   762.684     0.150
    85.538   765.783     0.150
    85.538   766.402     0.150
    87.734   769.805     0.150
    18.588   788.283     0.150
    93.004   795.422     0.150
    74.692   796.344     0.150
    33.998   812.223     0.150
    33.998   812.803     0.150
    29.647   823.152     0.150
     0.960    28.439     0.150
     1.234    20.449     0.150
     1.178    19.236     0.150
     3.797    57.727     0.150
     1.155    33.381     0.150
     1.155    18.932     0.150
     2.534    44.922     0.150
     3.266    55.051     0.150
     3.782    66.102     0.150
    29.647   264.662     0.150
    29.647   273.971     0.150
    71.383   274.480     0.150
    29.647   277.602     0.150
     2.534    42.980     0.150
     3.266    97.879     0.150
     6.502    99.615     0.150
     7.024   103.676     0.150
     9.118   136.598     0.150
    12.929   189.684     0.150
    18.820   264.650     0.150
    23.672   313.131     0.150
    25.578   334.131     0.150
    30.989   379.926     0.150
    31.967   385.332     0.150
    33.465   402.326     0.150
    34.122   407.926     0.150
    34.789   411.441     0.150
    36.752   428.730     0.150
    37.656   437.072     0.150
    39.467   451.352     0.150
    40.910   463.451     0.150
    42.302   475.775     0.150
    42.302   475.832     0.150
    44.928   495.381     0.150
    59.813   607.031     0.150
    67.725   656.730     0.150
    67.946   658.631     0.150
    68.573   662.730     0.150
    15.341   664.031     0.150
    68.904   665.631     0.150
    69.117   666.531     0.150
    69.117   666.469     0.150
   110.799   668.990     0.150
    69.489   670.332     0.150
    69.489   670.131     0.150
    70.150   673.432     0.150
    70.406   674.432     0.150
    70.436   675.531     0.150
    70.481   675.631     0.150
    70.489   675.832     0.150
    70.696   676.832     0.150
    70.786   677.131     0.150
    71.048   678.832     0.150
    71.128   679.531     0.150
    71.454   681.832     0.150
    42.804   682.340     0.150
    72.213   684.832     0.150
    72.265   685.531     0.150
    59.075   686.939     0.150
    33.720   695.449     0.150
    85.532   765.193     0.150
    34.019   812.502     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.562    11.184     0.150
     1.222    22.285     0.150
     1.222    38.484     0.150
     2.269    38.484     0.150
     2.269    69.484     0.150
     3.817    59.484     0.150
     4.949    75.285     0.150
     8.003   115.385     0.150
     8.388   121.084     0.150
     8.635   125.285     0.150
     9.767   142.984     0.150
    10.799   155.785     0.150
    12.231   173.984     0.150
    12.231   380.484     0.150
    13.200   188.484     0.150
    15.689   227.484     0.150
    15.855   223.184     0.150
    17.547   247.484     0.150
    17.659   247.484     0.150
    18.753   257.984     0.150
    20.382   279.885     0.150
    20.692   280.484     0.150
   149.934  1189.285     0.150
     0.322     6.410     0.150
     2.326    38.910     0.150
     2.326    68.109     0.150
     3.758    58.211     0.150
     3.798    57.508     0.150
     4.847    73.008     0.150
     4.884    73.410     0.150
     5.020    75.910     0.150
     5.184    78.309     0.150
     5.184   163.109     0.150
     5.246    79.309     0.150
     5.801    86.309     0.150
     5.801   182.609     0.150
     7.073   103.609     0.150
     7.143   106.410     0.150
     7.143   229.109     0.150
     7.938   115.309     0.150
     8.325   119.410     0.150
     8.640   123.809     0.150
     8.640   268.109     0.150
     8.722   127.211     0.150
    12.224   173.309     0.150
    12.286   173.609     0.150
    17.608   254.109     0.150
    17.665   243.008     0.150
    21.720   290.109     0.150
    22.845   303.109     0.150
    25.418   325.109     0.150
     0.456     8.156     0.150
     0.589    11.996     0.150
     0.732    13.277     0.150
     1.173    21.258     0.150
     2.241    38.008     0.150
     2.518    41.377     0.150
     3.556    54.207     0.150
     3.754    56.906     0.150
     4.923    74.707     0.150
     5.100    76.207     0.150
     5.104    76.906     0.150
     5.322    80.906     0.150
     5.730    85.207     0.150
     6.205    92.707     0.150
     7.159   104.207     0.150
     8.019   116.207     0.150
     8.397   120.707     0.150
     8.608   124.906     0.150
     8.608   269.707     0.150
    12.203   173.707     0.150
    12.202   173.307     0.150
    15.839   223.107     0.150
    16.680   239.207     0.150
    17.632   244.207     0.150
    17.625   246.707     0.150
    17.541   245.707     0.150
    18.573   257.107     0.150
    19.816   273.707     0.150
    20.014   275.707     0.150
    20.352   278.207     0.150
    20.670   280.707     0.150
    21.016   284.707     0.150
    21.031   285.107     0.150
    21.446   289.508     0.150
    21.668   290.707     0.150
    21.597   293.707     0.150
    22.214   299.906     0.150
    22.707   304.008     0.150
    23.467   313.707     0.150
    23.628   313.707     0.150
    24.088   317.707     0.150
    25.268   327.207     0.150
    25.363   329.207     0.150
    25.477   329.707     0.150
    25.501   330.207     0.150
    25.546   330.707     0.150
    26.563   340.707     0.150
    33.011   393.707     0.150
    38.415   439.707     0.150
    40.569   460.207     0.150
    46.348   505.707     0.150
    46.348     5.000     0.150
    46.348   603.707     0.150
    49.088   526.607     0.150
    49.562   530.707     0.150
    49.562   531.107     0.150
    51.494   544.906     0.150
    52.400   551.807     0.150
    55.426   574.707     0.150
    55.618   574.707     0.150
    58.678   600.807     0.150
    58.797   598.508     0.150
    58.797   648.307     0.150
    58.841   602.207     0.150
    59.070   597.707     0.150
    59.382   605.906     0.150
    59.760   604.406     0.150
    61.192   613.707     0.150
    62.318   621.707     0.150
    62.664   624.707     0.150
    63.687   630.508     0.150
    63.687  1139.008     0.150
    65.246   640.207     0.150
    67.136   653.707     0.150
    67.288   653.707     0.150
    68.491   662.207     0.150
    68.923   665.207     0.150
    68.989   665.508     0.150
    69.212   666.406     0.150
    69.428   668.107     0.150
    69.582   668.707     0.150
    70.351   676.607     0.150
    70.700   675.807     0.150
    71.015   677.707     0.150
    72.705   687.107     0.150
    72.690   686.707     0.150
    73.665   693.707     0.150
    76.133   707.707     0.150
    76.133   708.607     0.150
    76.183   707.707     0.150
    76.183   708.207     0.150
    78.206   719.406     0.150
    78.474   721.207     0.150
    79.453   725.707     0.150
    79.453   726.508     0.150
    79.496   724.707     0.150
    81.186   735.707     0.150
    81.186   736.508     0.150
    84.757   754.207     0.150
   149.957  1188.707     0.150
     0.449     8.270     0.150
     0.580    11.781     0.150
     0.729    13.102     0.150
     1.165    21.039     0.150
     1.204    21.852     0.150
     2.253    37.852     0.150
     2.513    41.289     0.150
     3.545    53.949     0.150
     3.818    60.250     0.150
     3.755    56.852     0.150
     4.954    75.152     0.150
     5.092    76.152     0.150
     5.112    76.051     0.150
     5.736    85.750     0.150
     6.155    90.551     0.150
     6.155    90.652     0.150
     7.067   104.449     0.150
     7.148   103.051     0.150
     8.011   116.152     0.150
     8.391   121.051     0.150
     8.617   124.551     0.150
     8.770   127.949     0.150
     9.938   146.051     0.150
    12.191   173.152     0.150
    12.214   172.551     0.150
    14.744   211.949     0.150
    15.688   227.051     0.150
    15.847   222.652     0.150
    15.914   229.551     0.150
    17.546   245.551     0.150
    17.641   243.551     0.150
    17.614   246.750     0.150
    18.570   257.051     0.150
    20.020   274.652     0.150
    20.364   276.852     0.150
    20.680   280.750     0.150
    21.021   284.852     0.150
    21.037   284.551     0.150
    21.253   286.852     0.150
    21.451   289.551     0.150
    21.679   290.652     0.150
    21.597   292.449     0.150
    22.214   298.449     0.150
    22.708   303.250     0.150
    22.771   303.551     0.150
    23.467   310.051     0.150
    24.090   315.051     0.150
    24.811   323.551     0.150
    25.128   325.852     0.150
    25.268   327.750     0.150
    25.365   328.551     0.150
    25.477   330.051     0.150
    25.501   330.250     0.150
    25.549   331.551     0.150
    26.876   343.352     0.150
    29.079   361.551     0.150
    29.215   360.551     0.150
    29.390   363.750     0.150
    31.247   377.551     0.150
    31.247   378.449     0.150
    31.247   441.551     0.150
    33.015   396.152     0.150
    33.338  1025.551     0.150
    33.658   403.551     0.150
    35.284   414.551     0.150
    35.284   740.551     0.150
    35.284   563.551     0.150
    37.614   435.051     0.150
    39.153   447.551     0.150
    40.552   456.551     0.150
    40.552   457.152     0.150
    46.351   505.551     0.150
    46.351   600.551     0.150
    49.086   525.551     0.150
    49.086   526.449     0.150
    49.559   531.551     0.150
    49.559   531.750     0.150
    51.503   544.949     0.150
    52.409   551.449     0.150
    55.626   577.551     0.150
    56.884   583.551     0.150
    56.884   584.152     0.150
    58.438   596.551     0.150
    58.438   596.852     0.150
    58.795   598.551     0.150
    59.079   598.551     0.150
    62.322   622.551     0.150
    62.659   625.551     0.150
    62.926   625.551     0.150
    62.926   626.051     0.150
    63.688   630.852     0.150
    63.688  1218.852     0.150
    65.076   639.551     0.150
    65.248   640.449     0.150
    65.989   646.551     0.150
    66.730   650.551     0.150
    67.146   653.551     0.150
    67.298   653.750     0.150
    67.674   656.551     0.150
    68.222   661.051     0.150
    68.250   660.551     0.150
    68.933   665.551     0.150
    69.467   668.250     0.150
    69.567   668.652     0.150
    69.593   668.551     0.150
    70.375   673.750     0.150
    70.532   674.551     0.150
    71.012   678.051     0.150
    71.504   681.051     0.150
    73.143   690.551     0.150
    73.143   691.352     0.150
    75.611   705.352     0.150
    76.135   707.551     0.150
    76.135   708.250     0.150
    76.186   707.551     0.150
    76.186   708.051     0.150
    78.209   719.551     0.150
    78.209   719.652     0.150
    78.352   720.551     0.150
    78.481   721.551     0.150
    79.455   725.551     0.150
    79.455   726.152     0.150
    81.190   736.551     0.150
    82.665   744.652     0.150
    84.758   755.551     0.150
    84.895   754.551     0.150
   149.949  1189.551     0.150
     0.267     4.781     0.150
     0.626    12.531     0.150
     1.106    19.867     0.150
     1.106    35.969     0.150
     1.791    56.219     0.150
     1.835    32.047     0.150
     1.835    56.781     0.150
     2.138    36.367     0.150
     2.138    66.672     0.150
     2.608    42.508     0.150
     2.728    44.375     0.150
     2.999    47.828     0.150
     3.270    51.531     0.150
     3.555    55.891     0.150
     3.635    57.328     0.150
     3.643    57.070     0.150
     3.648    57.070     0.150
     3.692    59.969     0.150
     3.733    57.789     0.150
     3.945    61.672     0.150
     3.945   121.969     0.150
     3.964    60.797     0.150
     4.226    64.781     0.150
     5.000    74.672     0.150
     5.000    89.969     0.150
     5.000   153.969     0.150
     5.061    76.469     0.150
     6.217    93.969     0.150
     7.265   104.969     0.150
     8.579   123.969     0.150
     8.841   129.969     0.150
     0.573    12.023     0.150
     1.156    21.324     0.150
     1.352    40.215     0.150
     1.599    28.723     0.150
     1.795    28.773     0.150
     1.821    30.203     0.150
     1.821    54.184     0.150
     1.890    30.715     0.150
     1.890    56.203     0.150
     2.177    37.723     0.150
     2.502    39.336     0.150
     2.613    41.383     0.150
     2.613    73.812     0.150
     2.711    42.305     0.150
     3.255    49.414     0.150
     3.553    54.676     0.150
     3.636    54.926     0.150
     3.709    58.023     0.150
     3.668    57.633     0.150
     3.895    59.543     0.150
     3.917    60.324     0.150
     3.992    61.824     0.150
     3.992    72.523     0.150
     3.992   122.625     0.150
     4.149    62.863     0.150
     4.240    64.883     0.150
     4.302    64.875     0.150
     4.745    70.766     0.150
     4.664    71.324     0.150
     4.664   144.824     0.150
     4.888    72.043     0.150
     5.004    74.543     0.150
     5.055    74.684     0.150
     5.055    75.824     0.150
     5.036    73.523     0.150
     5.093    74.434     0.150
     5.193    77.324     0.150
     5.417    81.023     0.150
     5.462    79.766     0.150
     5.632    82.812     0.150
     5.642    82.285     0.150
     5.635    84.625     0.150
     5.635   177.426     0.150
     5.789    85.766     0.150
     6.062    88.855     0.150
     6.224    92.266     0.150
     6.253    91.945     0.150
     6.440    93.504     0.150
     6.455    94.535     0.150
     6.523    94.984     0.150
     6.523    95.715     0.150
     6.554    95.863     0.150
     6.690    97.453     0.150
     6.717    98.113     0.150
     6.718    98.383     0.150
     6.719    98.152     0.150
     6.744    98.953     0.150
     6.800    98.855     0.150
     6.847   100.004     0.150
     6.867    99.586     0.150
     6.901   101.094     0.150
     6.935   101.273     0.150
     7.040   102.645     0.150
     7.190   104.633     0.150
     7.198   104.895     0.150
     7.200   103.934     0.150
     7.213   105.793     0.150
     7.230   104.023     0.150
     7.402   107.273     0.150
     8.111   114.652     0.150
     8.631   125.965     0.150
     8.631   266.652     0.150
     0.574    11.984     0.150
     1.159    20.984     0.150
     1.343    40.094     0.150
     1.609    28.984     0.150
     1.609    51.383     0.150
     1.786    28.516     0.150
     1.786    53.555     0.150
     1.811    30.062     0.150
     1.880    30.586     0.150
     1.880    55.676     0.150
     2.184    37.906     0.150
     2.493    39.195     0.150
     2.493    72.562     0.150
     2.603    41.195     0.150
     2.603    74.223     0.150
     2.701    41.883     0.150
     3.245    49.062     0.150
     3.543    54.176     0.150
     3.624    54.684     0.150
     3.626    54.555     0.150
     3.626    99.234     0.150
     3.677    56.504     0.150
     3.677   116.312     0.150
     3.886    59.062     0.150
     3.907    59.984     0.150
     3.988    61.484     0.150
     3.988   121.984     0.150
     4.140    62.254     0.150
     4.232    64.254     0.150
     4.293    64.383     0.150
     4.735    70.414     0.150
     4.674    71.285     0.150
     4.674   146.383     0.150
     4.879    71.543     0.150
     4.994    74.125     0.150
     5.027    73.293     0.150
     5.045    74.324     0.150
     5.045    75.766     0.150
     5.084    74.484     0.150
     5.183    77.184     0.150
     5.407    80.684     0.150
     5.453    79.266     0.150
     5.633    82.383     0.150
     5.624    83.812     0.150
     5.779    85.543     0.150
     5.645    84.785     0.150
     5.645   176.184     0.150
     6.054    88.523     0.150
     6.156    89.176     0.150
     6.235    92.023     0.150
     6.214    91.496     0.150
     6.243    91.676     0.150
     6.232    91.375     0.150
     6.431    92.434     0.150
     6.445    94.773     0.150
     6.472    94.125     0.150
     6.513    94.285     0.150
     6.532    94.766     0.150
     6.514    95.883     0.150
     6.544    94.594     0.150
     6.669    96.664     0.150
     6.681    97.035     0.150
     6.708    97.434     0.150
     6.710    98.105     0.150
     6.709    98.266     0.150
     6.734    98.473     0.150
     6.791    98.793     0.150
     6.838    99.516     0.150
     6.859    99.363     0.150
     6.891   100.266     0.150
     6.926   100.895     0.150
     7.031   102.703     0.150
     7.184   106.355     0.150
     7.189   105.836     0.150
     7.222   103.664     0.150
     7.393   107.105     0.150
     7.678   110.496     0.150
     8.102   115.113     0.150
     8.482   120.355     0.150
     0.438     8.164     0.150
     0.438    14.430     0.150
     0.441     8.203     0.150
     0.441    14.219     0.150
     0.706    12.805     0.150
     0.706    22.562     0.150
     1.176    21.195     0.150
     1.176    37.492     0.150
     1.206    21.820     0.150
     1.292    22.164     0.150
     1.292    39.969     0.150
     1.660    28.891     0.150
     1.660    51.094     0.150
     1.734    29.289     0.150
     1.734    52.898     0.150
     1.762    30.281     0.150
     1.762    53.930     0.150
     1.829    31.422     0.150
     1.829    56.469     0.150
     2.445    39.609     0.150
     2.551    41.641     0.150
     2.654    42.812     0.150
     3.197    50.125     0.150
     3.492    54.820     0.150
     3.576    56.094     0.150
     3.856    60.492     0.150
     3.960   122.492     0.150
     4.725    71.891     0.150
     4.725   146.992     0.150
     5.696   177.891     0.150
     0.263     5.008     0.150
     0.263     8.918     0.150
     0.328     6.318     0.150
     0.328    11.368     0.150
     0.563    10.218     0.150
     0.752    14.588     0.150
     1.223    22.618     0.150
     1.223    38.818     0.150
     1.565    26.178     0.150
     1.565    47.368     0.150
     1.595    28.198     0.150
     1.823    31.818     0.150
     1.823    55.318     0.150
     2.404    40.188     0.150
     2.404    70.438     0.150
     2.382    38.718     0.150
     2.382    68.598     0.150
     3.049    47.488     0.150
     3.327    52.608     0.150
     3.327    92.528     0.150
     3.417    52.788     0.150
     3.416    52.208     0.150
     3.425    53.878     0.150
     3.425    94.948     0.150
     3.507    54.648     0.150
     3.867    60.538     0.150
     4.108    62.608     0.150
     4.478    68.108     0.150
     4.519    68.728     0.150
     4.900    72.778     0.150
     5.569    83.678     0.150
     0.263     5.465     0.150
     0.275     5.766     0.150
     0.468     9.867     0.150
     1.224    22.535     0.150
     1.391    24.664     0.150
     1.528    26.066     0.150
     1.528    47.566     0.150
     1.700    50.664     0.150
     1.885    56.766     0.150
     1.943    31.965     0.150
     2.033    34.164     0.150
     2.033    59.566     0.150
     2.244    37.164     0.150
     2.244    65.438     0.150
     2.244    36.965     0.150
     2.609    42.164     0.150
     2.775    44.164     0.150
     2.819    45.664     0.150
     3.096    48.504     0.150
     3.420    52.438     0.150
     3.483    56.164     0.150
     3.702    56.566     0.150
     3.771    58.367     0.150
     3.856    59.164     0.150
     4.080    62.164     0.150
     4.178    63.316     0.150
     4.671    70.266     0.150
     4.891    73.617     0.150
     4.905    89.336     0.150
     4.905   150.695     0.150
     5.193    76.676     0.150
     6.074   203.164     0.150
    17.799   250.867     0.150
     0.193     3.980     0.150
     0.193     6.879     0.150
     0.484     9.078     0.150
     0.597    12.180     0.150
     1.105    20.180     0.150
     1.105    35.578     0.150
     1.198    20.379     0.150
     1.232    22.121     0.150
     1.232    38.980     0.150
     1.459    26.480     0.150
     1.635    27.480     0.150
     1.633    28.879     0.150
     1.633    51.578     0.150
     1.661    29.281     0.150
     1.727    29.578     0.150
     1.727    52.680     0.150
     1.762    31.379     0.150
     2.346    38.879     0.150
     2.386    39.699     0.150
     2.386    70.648     0.150
     2.452    40.480     0.150
     2.554    41.781     0.150
     2.826    45.480     0.150
     3.118    49.129     0.150
     3.391    53.879     0.150
     3.474    55.480     0.150
     3.563    55.199     0.150
     3.757    59.480     0.150
     3.791    58.629     0.150
     3.810    57.801     0.150
     3.938    61.648     0.150
     3.938   107.148     0.150
     4.165    64.379     0.150
     4.392    67.031     0.150
     4.583    68.758     0.150
     4.842    72.191     0.150
     4.827    73.480     0.150
     4.827   130.379     0.150
     4.827   150.078     0.150
     4.879    72.410     0.150
     5.184    77.551     0.150
     5.750    84.031     0.150
     5.750    84.051     0.150
     6.101    88.469     0.150
     7.635   111.730     0.150
     8.686   123.711     0.150
     0.294     5.438     0.150
     0.294     9.336     0.150
     0.345    10.938     0.150
     0.537    10.734     0.150
     0.620    11.539     0.150
     1.042    19.734     0.150
     1.042    34.234     0.150
     1.405    25.539     0.150
     1.405    44.641     0.150
     1.511    26.336     0.150
     1.511    46.836     0.150
     1.959    33.539     0.150
     1.952    32.234     0.150
     1.952    58.641     0.150
     2.632    43.141     0.150
     2.769    44.836     0.150
     2.842    46.438     0.150
     3.389    53.641     0.150
     3.511    57.461     0.150
     3.705    57.938     0.150
     3.747    59.234     0.150
     3.773    58.539     0.150
     3.781    58.141     0.150
     4.074    63.234     0.150
     4.092    63.641     0.150
     4.421    66.641     0.150
     4.470    69.938     0.150
     4.690    70.641     0.150
     4.845    73.539     0.150
     5.167    77.141     0.150
     5.216    77.438     0.150
     5.593    83.336     0.150
     5.933    90.539     0.150
     5.951    89.438     0.150
     6.177    91.734     0.150
     6.382    95.039     0.150
     0.278     5.047     0.150
     0.327     6.352     0.150
     0.327    10.453     0.150
     0.748    25.047     0.150
     1.047    34.438     0.150
     1.203    22.227     0.150
     1.222    22.227     0.150
     1.222    39.094     0.150
     1.421    25.844     0.150
     1.588    28.453     0.150
     1.588    50.148     0.150
     1.603    28.609     0.150
     1.603    50.711     0.150
     2.295    38.180     0.150
     2.295    67.719     0.150
     2.403    40.047     0.150
     2.407    73.133     0.150
     2.770    44.547     0.150
     3.040    47.797     0.150
     3.409    54.031     0.150
     3.673    57.648     0.150
     3.905    60.180     0.150
     3.852   104.102     0.150
     4.821    73.938     0.150
     4.965    75.047     0.150
     5.183    79.148     0.150
     5.249    79.203     0.150
     5.249    93.750     0.150
     5.249   164.797     0.150
     7.110   103.852     0.150
     8.252   119.352     0.150
     0.277     5.592     0.150
     0.277     9.910     0.150
     0.360     7.031     0.150
     0.360    12.391     0.150
     0.569    10.551     0.150
     0.681    13.541     0.150
     1.135    20.342     0.150
     1.191    21.672     0.150
     1.583    26.391     0.150
     1.639    28.682     0.150
     1.691    28.771     0.150
     2.331    38.320     0.150
     2.400    39.291     0.150
     2.372    39.221     0.150
     2.372    69.371     0.150
     2.439    39.570     0.150
     2.538    41.301     0.150
     2.806    44.570     0.150
     3.035    47.480     0.150
     3.348    51.771     0.150
     3.440    53.471     0.150
     3.451    53.570     0.150
     3.531    53.172     0.150
     3.704    56.971     0.150
     3.882    58.371     0.150
     4.139    62.570     0.150
     4.502    68.271     0.150
     5.214    77.820     0.150
     5.214    93.291     0.150
     5.214   163.990     0.150
     5.589    83.371     0.150
     0.274     5.707     0.150
     0.274     9.984     0.150
     0.369     7.188     0.150
     0.564    10.605     0.150
     0.564    19.445     0.150
     0.678    13.566     0.150
     1.146    20.176     0.150
     1.184    21.438     0.150
     1.594    27.395     0.150
     1.594    49.324     0.150
     1.650    28.848     0.150
     1.650    51.047     0.150
     2.363    38.805     0.150
     2.363    69.164     0.150
     2.342    38.785     0.150
     2.411    39.117     0.150
     2.411    69.527     0.150
     2.450    39.387     0.150
     2.549    41.375     0.150
     2.817    44.875     0.150
     3.359    52.086     0.150
     3.378    53.688     0.150
     3.451    53.688     0.150
     3.462    53.984     0.150
     3.543    53.887     0.150
     3.715    57.785     0.150
     3.776    58.285     0.150
     3.872    58.664     0.150
     4.107    62.188     0.150
     4.150    62.188     0.150
     4.378    65.387     0.150
     4.514    67.688     0.150
     4.553    67.867     0.150
     4.715    70.188     0.150
     4.813    71.285     0.150
     4.939    72.484     0.150
     5.202    76.637     0.150
     5.202    93.008     0.150
     5.202   163.457     0.150
     5.229    78.586     0.150
     5.606    84.086     0.150
     5.867    88.086     0.150
     5.921    88.086     0.150
     6.346    92.887     0.150
     8.525   123.285     0.150
    12.159   172.586     0.150
    46.613   503.887     0.150
     0.228     4.203     0.150
     0.427     8.303     0.150
     0.621    12.303     0.150
     1.253    21.803     0.150
     1.161    21.252     0.150
     1.161    37.443     0.150
     1.541    27.502     0.150
     1.699    28.902     0.150
     1.714    30.104     0.150
     1.714    54.104     0.150
     1.740    30.902     0.150
     1.800    30.902     0.150
     1.800    55.703     0.150
     2.305    38.604     0.150
     2.305    67.572     0.150
     2.426    39.902     0.150
     2.516    41.604     0.150
     3.175    49.902     0.150
     3.283    51.502     0.150
     3.461    54.604     0.150
     3.483    56.203     0.150
     3.548    55.604     0.150
     3.553    55.402     0.150
     3.613    57.604     0.150
     3.576    55.104     0.150
     3.820    60.604     0.150
     3.868    59.002     0.150
     3.930    62.002     0.150
     3.930   108.922     0.150
     3.767    57.703     0.150
     4.209    64.703     0.150
     4.209   116.104     0.150
     4.653    70.803     0.150
     4.966    76.203     0.150
     5.108    77.932     0.150
     5.788    85.102     0.150
     6.139    93.373     0.150
     7.182   104.303     0.150
     8.028   116.604     0.150
     7.877   113.422     0.150
     8.399   121.703     0.150
     8.576   123.553     0.150
     8.576   269.377     0.150
    12.115   171.951     0.150
    17.405   246.502     0.150
    17.542   248.016     0.150
    21.446   292.604     0.150
    21.819   294.133     0.150
    22.454   300.963     0.150
    25.135   328.102     0.150
    25.511   331.326     0.150
    26.272   337.303     0.150
    37.542   435.104     0.150
    59.626   604.934     0.150
    59.643   604.852     0.150
    88.662   773.553     0.150
     0.219     3.984     0.150
     0.433     8.184     0.150
     0.608    12.184     0.150
     0.865    16.484     0.150
     0.865    29.586     0.150
     1.268    21.887     0.150
     1.548    27.684     0.150
     1.713    29.285     0.150
     1.713    53.785     0.150
     1.722    30.086     0.150
     1.722    53.887     0.150
     1.812    31.184     0.150
     1.812    55.285     0.150
     2.435    40.184     0.150
     2.530    41.484     0.150
     2.530    73.086     0.150
     3.185    49.785     0.150
     3.185    97.184     0.150
     3.834    60.484     0.150
     3.751    58.887     0.150
     4.978    76.684     0.150
     5.097    76.684     0.150
     5.097   157.961     0.150
     5.339    81.387     0.150
     5.804    87.137     0.150
     5.804   183.285     0.150
     6.155    92.594     0.150
     6.155   195.785     0.150
     7.185   103.785     0.150
     7.215   104.785     0.150
     8.412   121.684     0.150
     8.589   124.559     0.150
    12.114   172.035     0.150
    17.528   247.348     0.150
    25.495   330.809     0.150
    48.124   521.160     0.150
     0.172     3.064     0.150
     0.303     5.336     0.150
     0.469     9.814     0.150
     1.238    22.166     0.150
     1.238    39.926     0.150
     1.377    24.916     0.150
     1.377    44.445     0.150
     1.789    31.076     0.150
     1.789    54.516     0.150
     1.852    32.266     0.150
     1.852    57.766     0.150
     2.304    39.715     0.150
     2.304    69.145     0.150
     2.304    38.135     0.150
     2.304    67.676     0.150
     2.668    43.965     0.150
     2.668    77.215     0.150
     2.814    45.455     0.150
     2.814    80.625     0.150
     3.331    53.256     0.150
     3.405    53.256     0.150
     3.585    54.875     0.150
     4.115    65.064     0.150
     4.115   131.246     0.150
     5.005    75.965     0.150
     5.005   155.525     0.150
     5.005    76.945     0.150
     0.244     4.566     0.150
     0.484     8.809     0.150
     0.629    12.457     0.150
     1.137    20.527     0.150
     1.137    36.176     0.150
     1.348    24.508     0.150
     1.348    42.926     0.150
     1.571    27.977     0.150
     1.724    29.855     0.150
     1.744    30.898     0.150
     1.744    54.148     0.150
     1.828    31.719     0.150
     1.828    57.219     0.150
     2.276    39.078     0.150
     2.276    66.766     0.150
     2.456    40.426     0.150
     2.541    41.727     0.150
     2.552    41.695     0.150
     2.664    43.246     0.150
     2.721    44.047     0.150
     2.721    77.605     0.150
     3.205    50.688     0.150
     3.205    89.559     0.150
     3.312    52.656     0.150
     3.312    92.566     0.150
     3.845    61.258     0.150
     3.929    62.277     0.150
     3.929    73.809     0.150
     3.929   123.879     0.150
     3.750    57.059     0.150
     4.994    75.547     0.150
     5.136    77.957     0.150
     5.202    77.766     0.150
     5.079    76.809     0.150
     5.079   157.480     0.150
     5.356    81.758     0.150
     5.775    87.406     0.150
     5.804    85.559     0.150
     5.804   182.855     0.150
     6.157    91.105     0.150
     7.211   104.957     0.150
     7.241   104.738     0.150
     7.656   112.035     0.150
     8.426   121.105     0.150
     8.568   124.656     0.150
     8.568   159.777     0.150
     8.568   218.258     0.150
     8.568   270.207     0.150
     8.754   126.828     0.150
     8.780   128.816     0.150
     9.990   311.777     0.150
    12.082   172.418     0.150
    12.087   172.602     0.150
    12.087   380.590     0.150
    17.517   247.543     0.150
    21.620   290.219     0.150
    21.657   294.559     0.150
    22.039   296.605     0.150
    22.429   299.426     0.150
    25.109   327.535     0.150
    25.109   327.957     0.150
    25.492   330.508     0.150
    25.915   336.156     0.150
    26.242   337.758     0.150
    53.685   561.473     0.150
    59.670   604.355     0.150
    88.687   773.707     0.150
     0.168     3.461     0.150
     0.539    10.984     0.150
     1.371    24.969     0.150
     1.371    42.617     0.150
     1.151    20.891     0.150
     1.151    37.023     0.150
     1.329    24.367     0.150
     1.329    42.281     0.150
     1.506    26.969     0.150
     1.506    47.523     0.150
     1.563    26.828     0.150
     1.563    48.117     0.150
     2.526    41.148     0.150
     2.526    78.438     0.150
     2.224    37.008     0.150
     2.307    37.648     0.150
     2.307    68.109     0.150
     2.378    39.414     0.150
     2.378    69.820     0.150
     2.433    40.094     0.150
     2.518    40.883     0.150
     2.518    72.594     0.150
     3.109    49.008     0.150
     3.300    52.164     0.150
     3.300    91.602     0.150
     3.683    57.938     0.150
     3.683    57.844     0.150
     3.998    62.242     0.150
     3.998   108.438     0.150
     3.998   126.242     0.150
     4.051    62.562     0.150
     4.745    71.789     0.150
     5.297    80.172     0.150
     5.297    96.109     0.150
     5.297   163.789     0.150
     5.297    80.297     0.150
     5.642    85.867     0.150
     8.693   273.391     0.150
     0.660    13.137     0.150
     1.207    21.930     0.150
     1.207    37.887     0.150
     2.382    40.059     0.150
     2.382    72.160     0.150
     3.073    46.840     0.150
     3.711    58.137     0.150
     3.874    60.500     0.150
     3.874    60.637     0.150
     3.874   106.410     0.150
     3.874   118.238     0.150
     3.869    59.398     0.150
     4.346    67.520     0.150
     4.858    73.777     0.150
     5.001    76.840     0.150
     5.213    78.469     0.150
     5.213   164.039     0.150
     5.213    78.238     0.150
     5.213   162.809     0.150
     5.645    85.469     0.150
     5.689    82.840     0.150
     5.689   148.727     0.150
     5.689   176.188     0.150
     6.039    89.367     0.150
     8.290   119.539     0.150
     8.546   123.148     0.150
     8.546   123.438     0.150
     8.546   267.789     0.150
     8.546   123.840     0.150
     8.528   125.238     0.150
     8.656   126.738     0.150
    12.175   171.840     0.150
    12.175   172.840     0.150
    12.181   173.133     0.150
    12.181   381.938     0.150
    21.633   288.859     0.150
    21.633   289.969     0.150
    22.809   303.137     0.150
    25.244   325.918     0.150
    35.162   412.867     0.150
    41.087   462.168     0.150
    50.112   533.098     0.150
    88.553   772.188     0.150
     0.298     5.438     0.150
     0.298     9.840     0.150
     0.285     5.129     0.150
     0.591    10.559     0.150
     0.683    13.328     0.150
     1.013    32.668     0.150
     1.080    18.488     0.150
     1.249    22.957     0.150
     1.249    39.059     0.150
     1.521    25.977     0.150
     1.623    27.777     0.150
     1.768    29.906     0.150
     2.338    39.148     0.150
     2.440    40.938     0.150
     2.440    72.988     0.150
     3.007    48.797     0.150
     3.850    60.949     0.150
     3.850    61.219     0.150
     3.850   106.340     0.150
     3.850   118.918     0.150
     5.283    94.938     0.150
     0.453     8.445     0.150
     0.453    15.031     0.150
     0.629    12.141     0.150
     0.879    16.602     0.150
     1.163    37.945     0.150
     1.211    21.766     0.150
     1.290    21.867     0.150
     1.338    24.086     0.150
     1.562    27.383     0.150
     1.734    29.102     0.150
     1.734    53.227     0.150
     2.292    38.422     0.150
     2.292    66.883     0.150
     2.551    41.438     0.150
     2.542    40.516     0.150
     2.780    43.883     0.150
     2.780    79.031     0.150
     2.966    49.312     0.150
     3.174    49.891     0.150
     3.202    49.750     0.150
     3.315    51.742     0.150
     3.513    54.836     0.150
     3.519    56.234     0.150
     3.567    55.094     0.150
     3.579    55.172     0.150
     3.581    55.336     0.150
     3.593    54.961     0.150
     3.688    56.656     0.150
     3.730    55.641     0.150
     3.730    56.750     0.150
     3.897    59.352     0.150
     3.960    61.766     0.150
     3.960    61.867     0.150
     3.960    72.461     0.150
     3.960   108.867     0.150
     3.960   122.094     0.150
     4.087    62.555     0.150
     4.180    63.984     0.150
     4.242    65.094     0.150
     4.252    63.891     0.150
     4.487    69.406     0.150
     4.642    70.867     0.150
     4.686    70.344     0.150
     4.686    70.727     0.150
     4.945    74.453     0.150
     4.997    75.445     0.150
     5.045    74.562     0.150
     5.079    75.922     0.150
     5.079   157.797     0.150
     5.079    75.812     0.150
     5.079    90.711     0.150
     5.079   158.172     0.150
     5.202    77.586     0.150
     5.411    79.641     0.150
     5.422    82.625     0.150
     5.580    83.836     0.150
     5.737    86.242     0.150
     5.790    86.445     0.150
     5.790    86.586     0.150
     5.825    85.094     0.150
     5.825    84.945     0.150
     5.825   181.297     0.150
     5.802    85.117     0.150
     5.999    89.836     0.150
     6.161    91.391     0.150
     6.177    92.945     0.150
     6.177    92.367     0.150
     6.235    91.406     0.150
     6.255    92.633     0.150
     6.275    93.336     0.150
     6.330    91.164     0.150
     6.461    96.188     0.150
     6.666    97.344     0.150
     6.668    97.688     0.150
     6.748    98.383     0.150
     6.798   100.484     0.150
     6.827   100.320     0.150
     6.851   101.172     0.150
     6.888   100.922     0.150
     6.993   103.016     0.150
     7.120   104.891     0.150
     7.153   105.820     0.150
     7.168   105.961     0.150
     7.226   104.523     0.150
     7.642   111.906     0.150
     7.806   113.984     0.150
     8.037   116.422     0.150
     8.098   117.523     0.150
     8.119   117.336     0.150
     8.189   118.641     0.150
     8.431   121.094     0.150
     8.411   123.492     0.150
     8.591   124.570     0.150
     8.600   124.742     0.150
     8.600   218.195     0.150
     8.600   160.164     0.150
     8.600   268.586     0.150
     8.772   126.547     0.150
     9.333   134.625     0.150
     9.897   315.820     0.150
    10.118   147.016     0.150
    12.102   172.047     0.150
    12.102   172.406     0.150
    12.102   375.391     0.150
    12.102   376.367     0.150
    12.106   171.688     0.150
    12.106   375.789     0.150
    14.042   198.070     0.150
    14.712   207.266     0.150
    15.229   216.312     0.150
    15.236   218.516     0.150
    15.801   222.445     0.150
    15.987   222.523     0.150
    16.156   228.656     0.150
    16.806   238.172     0.150
    16.912   239.586     0.150
    17.002   241.516     0.150
    17.230   245.500     0.150
    17.507   246.547     0.150
    17.507   245.922     0.150
    17.550   246.570     0.150
    17.642   246.195     0.150
    18.269   255.484     0.150
    18.311   254.672     0.150
    18.727   260.516     0.150
    19.286   267.156     0.150
    19.558   269.055     0.150
    19.980   273.281     0.150
    20.036   275.922     0.150
    20.197   274.953     0.150
    20.214   275.781     0.150
    20.198   275.820     0.150
    20.206   276.406     0.150
    20.632   280.047     0.150
    20.996   282.852     0.150
    21.080   286.445     0.150
    21.080   286.852     0.150
    21.080   532.070     0.150
    21.080   285.477     0.150
    21.651   290.344     0.150
    21.651   290.156     0.150
    21.651   290.547     0.150
    21.577   290.594     0.150
    21.683   292.406     0.150
    21.782   292.977     0.150
    21.946   294.242     0.150
    21.946   293.695     0.150
    22.030   295.188     0.150
    22.189   298.344     0.150
    22.189   297.938     0.150
    22.418   298.734     0.150
    22.637   301.492     0.150
    22.723   303.344     0.150
    22.723   302.875     0.150
    22.967   305.625     0.150
    23.055   306.797     0.150
    23.196   308.586     0.150
    23.296   308.375     0.150
    23.296   310.945     0.150
    23.296   309.000     0.150
    23.512   310.016     0.150
    23.586   311.562     0.150
    23.594   311.844     0.150
    23.648   311.703     0.150
    23.797   314.273     0.150
    23.875   314.242     0.150
    23.917   314.945     0.150
    23.966   314.641     0.150
    23.967   315.531     0.150
    24.023   316.266     0.150
    24.048   318.047     0.150
    24.048   315.117     0.150
    24.083   316.031     0.150
    24.176   315.945     0.150
    24.176   577.047     0.150
    24.176   315.742     0.150
    24.211   318.844     0.150
    24.211   317.461     0.150
    24.443   318.977     0.150
    24.496   320.844     0.150
    24.496   320.406     0.150
    24.570   322.445     0.150
    24.570   320.953     0.150
    25.012   326.344     0.150
    25.012   323.781     0.150
    25.101   325.664     0.150
    25.101   326.047     0.150
    25.099   325.906     0.150
    25.178   327.047     0.150
    25.178   326.203     0.150
    25.192   325.852     0.150
    25.208   326.375     0.150
    25.474   329.867     0.150
    25.521   330.242     0.150
    25.521   329.531     0.150
    25.682   332.352     0.150
    25.787   332.242     0.150
    25.902   333.281     0.150
    25.994   334.164     0.150
    26.048   335.445     0.150
    26.048   334.555     0.150
    26.100   334.977     0.150
    26.155   335.242     0.150
    26.249   335.617     0.150
    26.249   334.695     0.150
    26.399   337.086     0.150
    26.477   337.703     0.150
    26.487   339.250     0.150
    26.662   338.094     0.150
    26.662   337.750     0.150
    27.596   347.664     0.150
    27.602   349.445     0.150
    27.602   348.516     0.150
    27.666   348.625     0.150
    27.741   350.242     0.150
    27.741   348.195     0.150
    27.756   350.242     0.150
    27.756   349.656     0.150
    28.086   352.070     0.150
    28.972   360.133     0.150
    29.159   361.953     0.150
    29.237   362.742     0.150
    29.371   363.836     0.150
    29.410   366.445     0.150
    29.410   362.953     0.150
    29.584   366.555     0.150
    29.935   368.445     0.150
    30.992   377.883     0.150
    31.956   386.297     0.150
    32.975   396.844     0.150
    32.975   396.617     0.150
    32.975   559.617     0.150
    32.975   395.805     0.150
    33.442   398.820     0.150
    33.453   398.531     0.150
    33.608   399.945     0.150
    33.608   476.742     0.150
    33.608   399.484     0.150
    33.616   402.742     0.150
    33.616   401.391     0.150
    33.703   398.445     0.150
    33.703   563.047     0.150
    33.924   403.336     0.150
    35.058   413.836     0.150
    35.705   419.070     0.150
    36.219   423.266     0.150
    36.243   424.086     0.150
    36.847   427.312     0.150
    37.171   430.641     0.150
    37.324   431.633     0.150
    37.536   434.617     0.150
    37.536   434.094     0.150
    37.779   435.531     0.150
    38.311   441.992     0.150
    39.031   446.352     0.150
    39.018   448.641     0.150
    39.018   446.750     0.150
    39.018   447.867     0.150
    39.018   576.617     0.150
    39.145   446.594     0.150
    39.727   452.906     0.150
    40.083   456.320     0.150
    40.279   457.461     0.150
    40.422   457.273     0.150
    40.584   458.742     0.150
    40.584   552.547     0.150
    40.584   458.633     0.150
    41.044   463.344     0.150
    41.044   462.703     0.150
    41.336   465.961     0.150
    41.603   469.492     0.150
    41.756   469.883     0.150
    41.839   471.141     0.150
    41.839   470.195     0.150
    41.971   473.281     0.150
    45.221   496.641     0.150
    45.361   497.445     0.150
    45.361   599.844     0.150
    45.361   498.242     0.150
    45.923   502.641     0.150
    45.923     7.102     0.150
    45.923   601.945     0.150
    45.923   896.742     0.150
    45.923  1090.445     0.150
    48.695   520.844     0.150
    48.695   636.844     0.150
    49.116   525.742     0.150
    50.052   532.445     0.150
    50.185   534.469     0.150
    53.174   557.344     0.150
    53.174   677.445     0.150
    53.174  1013.742     0.150
    53.174  1228.547     0.150
    53.696   561.594     0.150
    55.507   575.242     0.150
    55.507   574.344     0.150
    55.507   574.844     0.150
    55.507   574.547     0.150
    55.648   575.445     0.150
    55.648   698.844     0.150
    55.648  1036.641     0.150
    56.912   584.445     0.150
    56.912   640.445     0.150
    57.051   583.945     0.150
    57.051   584.922     0.150
    57.596   589.844     0.150
    57.596   590.047     0.150
    57.596   712.344     0.150
    57.596  1069.047     0.150
    57.596   590.242     0.150
    58.052  1070.141     0.150
    58.052  1081.945     0.150
    58.247   592.891     0.150
    58.466   597.242     0.150
    58.824   598.844     0.150
    59.675   604.477     0.150
    59.924   606.562     0.150
    59.957   605.742     0.150
    60.216   607.766     0.150
    60.469   607.344     0.150
    60.793   608.844     0.150
    60.940   612.641     0.150
    61.130   614.242     0.150
    61.297   615.641     0.150
    61.297  1116.641     0.150
    62.328   621.844     0.150
    62.328   662.344     0.150
    62.328  1141.844     0.150
    62.697   624.844     0.150
    62.697  1134.344     0.150
    63.903   632.547     0.150
    63.903   666.547     0.150
    63.903   774.945     0.150
    63.903  1147.945     0.150
    63.903  1157.445     0.150
    63.903  1169.344     0.150
    63.903  1223.047     0.150
    63.903  1395.844     0.150
    64.464   635.641     0.150
    64.706   637.359     0.150
    64.724   636.945     0.150
    64.994   639.062     0.150
    65.069   639.742     0.150
    65.069   639.344     0.150
    65.273   643.844     0.150
    65.364   641.945     0.150
    65.510   642.945     0.150
    65.760   644.742     0.150
    65.970   645.141     0.150
    65.970  1179.602     0.150
    66.170   646.945     0.150
    66.288   647.742     0.150
    66.375   648.242     0.150
    66.427   648.547     0.150
    66.459   648.344     0.150
    66.586   649.445     0.150
    66.702   649.242     0.150
    66.710   649.641     0.150
    66.710     4.805     0.150
    66.719   650.344     0.150
    66.971   652.641     0.150
    67.125   653.047     0.150
    67.127   653.141     0.150
    67.204   656.141     0.150
    67.279   653.945     0.150
    67.279     4.602     0.150
    67.628   656.445     0.150
    67.656   656.547     0.150
    67.656  1198.344     0.150
    67.656   656.445     0.150
    67.661   656.445     0.150
    67.710   657.141     0.150
    67.766   657.141     0.150
    67.944   658.047     0.150
    67.944     4.000     0.150
    67.941   658.141     0.150
    67.978   658.844     0.150
    67.978     4.500     0.150
    67.978   658.844     0.150
    67.978     4.500     0.150
    68.016   658.742     0.150
    68.016   683.641     0.150
    68.016  1199.242     0.150
    68.016  1255.844     0.150
    68.038   660.242     0.150
    68.038   658.547     0.150
    68.141   659.641     0.150
    68.141     4.500     0.150
    68.231   660.047     0.150
    68.231     4.000     0.150
    68.263   660.445     0.150
    68.263   812.547     0.150
    68.263  1198.844     0.150
    68.263  1231.844     0.150
    68.396   658.547     0.150
    68.479   661.742     0.150
    68.493   661.844     0.150
    68.493   659.742     0.150
    68.561   661.445     0.150
    68.585   662.445     0.150
    68.681   662.844     0.150
    68.762   663.445     0.150
    68.787   664.047     0.150
    68.894   664.344     0.150
    68.894     4.398     0.150
    68.913   664.844     0.150
    68.913     3.797     0.150
    68.964   664.742     0.150
    68.975   664.742     0.150
    68.986   664.844     0.150
    68.986   663.945     0.150
    69.150   664.867     0.150
    69.197   665.844     0.150
    69.210   666.242     0.150
    69.210   666.031     0.150
    69.303   666.445     0.150
    69.403   666.141     0.150
    69.413   667.242     0.150
    69.443   667.445     0.150
    69.461   666.742     0.150
    69.495   667.844     0.150
    69.495   823.844     0.150
    69.495  1212.844     0.150
    69.495  1481.844     0.150
    69.579   667.242     0.150
    69.598   669.445     0.150
    69.598   692.742     0.150
    69.598   824.742     0.150
    69.598  1215.242     0.150
    69.598  1266.742     0.150
    69.846   670.547     0.150
    69.957   670.445     0.150
    70.034   671.047     0.150
    70.092   672.047     0.150
    70.092     4.500     0.150
    70.103   670.742     0.150
    70.178   671.641     0.150
    70.225   674.547     0.150
    70.225     6.500     0.150
    70.302   672.945     0.150
    70.302     4.398     0.150
    70.316   673.445     0.150
    70.313   676.742     0.150
    70.335   672.344     0.150
    70.357   673.242     0.150
    70.357     5.000     0.150
    70.362   674.344     0.150
    70.396   674.242     0.150
    70.544   674.234     0.150
    70.664   674.945     0.150
    70.811   679.945     0.150
    70.823   675.945     0.150
    70.823  1228.242     0.150
    70.867   677.141     0.150
    71.004   678.141     0.150
    71.047   678.047     0.150
    71.046   678.344     0.150
    71.046   692.242     0.150
    71.046   836.844     0.150
    71.046  1232.844     0.150
    71.046  1247.844     0.150
    71.046  1507.844     0.150
    71.136   677.445     0.150
    71.132   680.992     0.150
    71.069   675.727     0.150
    71.158   678.344     0.150
    71.240   679.203     0.150
    71.257   678.445     0.150
    71.285   680.438     0.150
    71.325   678.945     0.150
    71.384   683.594     0.150
    71.456   680.547     0.150
    71.456     4.797     0.150
    71.522   683.453     0.150
    71.528   679.641     0.150
    71.544   681.141     0.150
    71.544  1240.844     0.150
    71.556   679.547     0.150
    71.583   680.961     0.150
    71.583     5.016     0.150
    71.617   681.242     0.150
    71.892   682.641     0.150
    71.883   682.047     0.150
    71.807   683.156     0.150
    71.899   682.641     0.150
    71.917   683.141     0.150
    71.917     4.805     0.150
    71.928   682.445     0.150
    71.975   682.547     0.150
    71.975     4.000     0.150
    72.031   682.344     0.150
    72.137   683.602     0.150
    72.197   684.344     0.150
    72.305   688.664     0.150
    72.312   685.641     0.150
    72.312     4.906     0.150
    72.360   685.141     0.150
    72.568   689.195     0.150
    72.708   687.000     0.150
    72.708     4.914     0.150
    72.807   686.844     0.150
    72.807     4.000     0.150
    72.807   702.844     0.150
    72.807  1247.844     0.150
    72.846   687.742     0.150
    72.864   687.844     0.150
    72.877   691.523     0.150
    72.988   688.641     0.150
    73.175   689.945     0.150
    73.210   690.445     0.150
    73.294   691.500     0.150
    73.225   692.453     0.150
    73.387   691.867     0.150
    73.311   692.914     0.150
    73.481   691.844     0.150
    73.496   692.867     0.150
    73.539   693.781     0.150
    73.539   692.914     0.150
    73.683   693.844     0.150
    73.781   694.727     0.150
    73.795   696.414     0.150
    73.791   694.945     0.150
    73.887   695.641     0.150
    73.897   695.336     0.150
    73.897   694.047     0.150
    73.887   693.945     0.150
    73.985   696.906     0.150
    74.026   696.133     0.150
    74.024   695.828     0.150
    74.055   696.320     0.150
    74.065   698.445     0.150
    74.020   696.164     0.150
    74.268   697.812     0.150
    74.272   697.031     0.150
    74.285   697.852     0.150
    74.328   697.484     0.150
    74.396   697.742     0.150
    74.446   697.445     0.150
    74.508   698.742     0.150
    74.552   699.984     0.150
    74.564   698.242     0.150
    74.572   695.344     0.150
    74.633   701.273     0.150
    74.947   700.891     0.150
    74.999   700.445     0.150
    75.033   701.344     0.150
    75.164   701.844     0.150
    75.248   702.500     0.150
    75.305   702.562     0.150
    75.407   701.547     0.150
    75.407  1277.047     0.150
    75.397   704.477     0.150
    75.479   703.703     0.150
    75.646   704.844     0.150
    75.654   706.961     0.150
    75.785   706.211     0.150
    75.902   706.867     0.150
    75.953   707.938     0.150
    76.018   707.461     0.150
    76.075   706.984     0.150
    76.161   707.688     0.150
    76.233   708.000     0.150
    76.271   708.344     0.150
    76.271     3.797     0.150
    76.271   717.844     0.150
    76.271  1300.344     0.150
    76.271   707.742     0.150
    76.319   706.703     0.150
    76.367   709.102     0.150
    76.489   710.344     0.150
    76.548   710.844     0.150
    76.548   723.141     0.150
    76.548  1294.547     0.150
    76.548  1316.742     0.150
    76.548  1324.344     0.150
    76.548  1332.844     0.150
    76.548  1590.445     0.150
    76.539   710.844     0.150
    76.654   709.641     0.150
    76.654   880.547     0.150
    76.654  1294.945     0.150
    76.654  1319.844     0.150
    76.654  1590.742     0.150
    76.680   710.023     0.150
    76.914   711.961     0.150
    77.050   712.844     0.150
    77.050     6.203     0.150
    77.038   713.062     0.150
    77.535   715.125     0.150
    77.700   717.844     0.150
    77.709   717.844     0.150
    77.854   716.945     0.150
    77.988   717.281     0.150
    78.026   717.391     0.150
    77.947   718.141     0.150
    78.151   718.133     0.150
    78.169   718.227     0.150
    78.415   720.070     0.150
    78.449   719.844     0.150
    78.627   717.953     0.150
    79.024   721.953     0.150
    79.137   724.844     0.150
    79.414   729.625     0.150
    80.031   729.742     0.150
    80.031   728.914     0.150
    80.345   730.594     0.150
    81.191   735.547     0.150
    81.191   921.945     0.150
    81.191  1343.047     0.150
    81.191  1350.742     0.150
    81.191  1393.844     0.150
    81.191  1662.547     0.150
    81.391   738.641     0.150
    81.391  1348.742     0.150
    81.391  1664.047     0.150
    83.366   745.445     0.150
    83.546   946.547     0.150
    83.546  1699.445     0.150
    83.767   749.344     0.150
    83.827   748.844     0.150
    83.943   750.445     0.150
    84.780   755.344     0.150
    84.909   755.547     0.150
    85.075   756.047     0.150
    85.077   756.047     0.150
    85.239   756.445     0.150
    85.299   757.242     0.150
    85.612   758.445     0.150
    86.558   761.844     0.150
    86.626   763.195     0.150
    86.773   764.156     0.150
    86.773     3.906     0.150
    87.005   764.516     0.150
    87.005   766.383     0.150
    87.261   765.992     0.150
    87.261     3.070     0.150
    87.997   770.133     0.150
    88.377   771.641     0.150
    88.698   773.891     0.150
    90.000   779.391     0.150
    90.712   782.242     0.150
    91.673   785.297     0.150
    94.967   805.422     0.150
    96.869   810.344     0.150
    96.869  1043.844     0.150
   105.250  1105.328     0.150
   135.924  1160.477     0.150
   149.306  1187.984     0.150
   149.935  1188.945     0.150
     0.434     8.141     0.150
     0.440     8.289     0.150
     0.440    14.656     0.150
     0.614    12.180     0.150
     0.867    16.531     0.150
     1.203    21.539     0.150
     1.180    36.938     0.150
     1.289    21.359     0.150
     1.326    23.922     0.150
     1.551    27.273     0.150
     1.731    28.453     0.150
     2.307    38.148     0.150
     2.307    66.867     0.150
     2.307    37.828     0.150
     2.307    68.930     0.150
     2.548    41.430     0.150
     2.530    40.711     0.150
     2.783    44.102     0.150
     2.783    80.609     0.150
     3.182    49.930     0.150
     3.193    49.719     0.150
     3.308    51.820     0.150
     3.516    55.023     0.150
     3.557    54.312     0.150
     3.572    54.711     0.150
     3.573    55.672     0.150
     3.580    54.430     0.150
     3.681    56.211     0.150
     3.726    56.578     0.150
     3.889    59.086     0.150
     3.973    61.727     0.150
     3.973   109.031     0.150
     3.973   121.898     0.150
     4.088    62.312     0.150
     4.185    63.523     0.150
     4.238    64.797     0.150
     4.241    63.500     0.150
     4.489    68.883     0.150
     4.681    70.781     0.150
     4.940    74.172     0.150
     4.991    75.180     0.150
     5.034    74.141     0.150
     5.087    75.852     0.150
     5.087    89.406     0.150
     5.087   158.453     0.150
     5.087    75.680     0.150
     5.087    75.453     0.150
     5.087    91.500     0.150
     5.087   157.008     0.150
     5.401    79.617     0.150
     5.414    81.992     0.150
     5.521    82.039     0.150
     5.574    82.477     0.150
     5.790    85.828     0.150
     5.791    84.680     0.150
     5.830    85.133     0.150
     5.830    85.031     0.150
     5.830   181.133     0.150
     6.002    88.172     0.150
     6.160    90.930     0.150
     6.181    90.922     0.150
     6.248    92.086     0.150
     6.322    92.492     0.150
     6.354    92.953     0.150
     6.386    94.219     0.150
     6.460    94.820     0.150
     6.617    97.289     0.150
     6.656    96.586     0.150
     6.658    97.922     0.150
     6.739    97.703     0.150
     6.788    99.352     0.150
     6.841   100.000     0.150
     6.878   100.336     0.150
     6.982   103.156     0.150
     7.109   105.117     0.150
     7.141   105.469     0.150
     7.195   104.828     0.150
     7.098   103.812     0.150
     7.212   104.492     0.150
     7.631   111.461     0.150
     7.693   112.477     0.150
     7.623   112.477     0.150
     7.623   237.828     0.150
     7.793   113.711     0.150
     8.029   115.859     0.150
     8.085   116.836     0.150
     8.107   117.477     0.150
     8.087   117.727     0.150
     8.426   121.180     0.150
     8.422   122.953     0.150
     8.422   260.117     0.150
     8.597   124.852     0.150
     8.616   124.602     0.150
     8.616   218.133     0.150
     8.616   269.328     0.150
     8.616   123.633     0.150
     8.616   124.797     0.150
     8.616   270.680     0.150
     8.773   126.477     0.150
     8.800   128.477     0.150
     8.654   125.531     0.150
     9.902   315.883     0.150
     9.997   256.453     0.150
    10.117   146.828     0.150
    10.117   319.281     0.150
    10.117   147.227     0.150
    10.117   320.539     0.150
    12.117   170.492     0.150
    12.117   171.531     0.150
    12.117   375.180     0.150
    12.117   377.430     0.150
    12.122   170.922     0.150
    12.122   376.578     0.150
    12.348   179.109     0.150
    12.348   391.477     0.150
    12.853   185.680     0.150
    13.727   430.477     0.150
    14.040   197.688     0.150
    13.977   204.508     0.150
    14.439   210.000     0.150
    14.491   214.281     0.150
    14.611   216.328     0.150
    14.708   214.477     0.150
    14.712   207.078     0.150
    14.712   216.352     0.150
    14.899   215.922     0.150
    14.899   464.539     0.150
    14.910   217.891     0.150
    14.956   218.953     0.150
    15.228   216.258     0.150
    15.328   224.133     0.150
    15.653   226.547     0.150
    15.653   488.102     0.150
    15.809   222.359     0.150
    15.809   222.703     0.150
    15.809   502.438     0.150
    15.973   222.367     0.150
    16.806   237.953     0.150
    16.911   241.289     0.150
    17.002   241.469     0.150
    17.510   245.383     0.150
    17.510   243.930     0.150
    17.942   252.172     0.150
    18.306   253.281     0.150
    18.316   253.852     0.150
    18.316   255.781     0.150
    19.027   264.383     0.150
    19.984   273.492     0.150
    20.033   275.750     0.150
    20.198   275.078     0.150
    20.203   274.938     0.150
    20.218   275.703     0.150
    20.644   280.281     0.150
    21.077   286.359     0.150
    21.077   285.258     0.150
    21.320   289.602     0.150
    21.667   289.922     0.150
    21.667   290.578     0.150
    21.682   291.891     0.150
    21.781   292.992     0.150
    21.950   293.578     0.150
    21.957   296.188     0.150
    22.033   295.047     0.150
    22.186   297.289     0.150
    22.420   298.930     0.150
    22.640   300.789     0.150
    22.673   302.508     0.150
    22.738   301.039     0.150
    22.738   302.953     0.150
    23.059   305.453     0.150
    23.304   307.672     0.150
    23.300   309.273     0.150
    23.508   309.977     0.150
    23.593   311.000     0.150
    23.597   312.086     0.150
    23.645   311.211     0.150
    23.800   314.000     0.150
    23.878   314.656     0.150
    23.920   314.797     0.150
    23.969   314.156     0.150
    23.970   315.031     0.150
    24.026   315.773     0.150
    24.176   316.578     0.150
    24.176   315.891     0.150
    24.496   320.648     0.150
    25.008   324.531     0.150
    25.104   324.852     0.150
    25.104   326.133     0.150
    25.175   326.438     0.150
    25.210   325.727     0.150
    25.472   329.555     0.150
    25.519   329.172     0.150
    25.903   330.820     0.150
    25.992   332.867     0.150
    26.153   334.648     0.150
    26.260   336.180     0.150
    26.260   335.828     0.150
    26.476   337.836     0.150
    26.483   337.328     0.150
    27.597   346.859     0.150
    28.090   352.039     0.150
    29.158   362.789     0.150
    33.605   712.883     0.150
    33.616   400.531     0.150
    36.221   421.891     0.150
    37.552   434.203     0.150
    37.787   434.391     0.150
    39.020   447.977     0.150
    39.020   576.555     0.150
    40.584   458.883     0.150
    48.691   520.680     0.150
    49.117   526.180     0.150
    53.169   557.281     0.150
    55.644   575.078     0.150
    57.066   586.352     0.150
    57.598   590.578     0.150
    57.598   589.672     0.150
    58.468   597.281     0.150
    58.826   598.281     0.150
    59.664   603.883     0.150
    59.669   604.281     0.150
    59.761   603.930     0.150
    59.924   607.141     0.150
    59.968   606.383     0.150
    60.475   606.578     0.150
    62.338   622.281     0.150
    62.694   626.383     0.150
    63.901   631.383     0.150
    63.901   664.477     0.150
    63.901  1149.477     0.150
    63.901  1156.578     0.150
    63.901  1173.281     0.150
    63.901  1222.180     0.150
    64.049   632.078     0.150
    64.714   636.766     0.150
    65.342   639.977     0.150
    68.258   660.977     0.150
    68.258   813.078     0.150
    68.258  1194.680     0.150
    68.258  1206.680     0.150
    68.258  1217.680     0.150
    69.164   664.727     0.150
    69.498   668.680     0.150
    69.498   824.680     0.150
    69.498  1214.680     0.150
    69.498  1482.680     0.150
    69.598   669.680     0.150
    69.598   692.578     0.150
    69.598   826.781     0.150
    69.598  1219.977     0.150
    69.598  1226.078     0.150
    69.598  1264.281     0.150
    69.659   669.641     0.150
    71.045   678.180     0.150
    71.045   691.977     0.150
    71.045   838.680     0.150
    73.903   694.477     0.150
    73.903   693.750     0.150
    74.041   695.789     0.150
    75.176   704.680     0.150
    76.554   710.680     0.150
    76.554  1294.680     0.150
    76.554  1317.781     0.150
    76.554  1324.281     0.150
    76.554  1333.180     0.150
    76.554  1590.680     0.150
    78.387   720.977     0.150
    80.043   731.883     0.150
    81.189   737.180     0.150
    81.189  1344.477     0.150
    81.393   738.883     0.150
    81.393   737.828     0.150
    83.948   750.477     0.150
    84.912   755.383     0.150
    85.078   755.578     0.150
    85.079   755.977     0.150
    85.242   756.383     0.150
    85.301   757.078     0.150
    85.615   758.078     0.150
    88.696   773.461     0.150
    88.696   774.031     0.150
   149.922  1189.281     0.150
     0.457     8.391     0.150
     0.457    15.117     0.150
     0.632    12.516     0.150
     0.876    16.797     0.150
     1.162    20.883     0.150
     1.162    36.945     0.150
     1.207    22.016     0.150
     1.285    21.586     0.150
     1.559    27.547     0.150
     1.729    28.742     0.150
     1.729    54.156     0.150
     1.827    30.922     0.150
     2.294    38.211     0.150
     2.294    67.984     0.150
     2.540    40.938     0.150
     2.546    41.766     0.150
     2.546    75.008     0.150
     2.785    44.383     0.150
     3.169    50.438     0.150
     3.198    50.023     0.150
     3.310    51.875     0.150
     3.563    54.367     0.150
     3.575    55.328     0.150
     3.735    58.375     0.150
     3.893    59.688     0.150
     3.956    61.984     0.150
     3.956   108.156     0.150
     3.956   124.273     0.150
     4.082    62.625     0.150
     4.238    65.047     0.150
     4.249    63.742     0.150
     4.482    68.711     0.150
     4.682    71.055     0.150
     4.941    74.766     0.150
     4.993    76.531     0.150
     5.082    76.336     0.150
     5.082   157.836     0.150
     5.082    75.875     0.150
     5.082    76.633     0.150
     5.082    91.008     0.150
     5.082   157.203     0.150
     5.355    81.336     0.150
     5.407    80.461     0.150
     5.785    86.492     0.150
     5.799    85.492     0.150
     5.820    85.875     0.150
     5.820    86.438     0.150
     6.156    91.656     0.150
     6.251    92.773     0.150
     6.456    95.766     0.150
     6.662    98.203     0.150
     6.745    98.586     0.150
     6.990   102.867     0.150
     7.224   104.672     0.150
     7.679   112.852     0.150
     8.427   121.766     0.150
     8.597   219.211     0.150
     8.597   269.312     0.150
     8.597   161.938     0.150
     8.766   126.234     0.150
    12.103   172.602     0.150
    12.103   375.336     0.150
    12.107   172.133     0.150
    12.107   381.086     0.150
    59.919   606.836     0.150
     0.482     8.719     0.150
     0.658    12.809     0.150
     0.888    17.059     0.150
     1.139    21.102     0.150
     1.139    35.770     0.150
     1.213    21.832     0.150
     1.277    21.809     0.150
     1.570    28.031     0.150
     1.570    49.922     0.150
     1.725    28.949     0.150
     2.277    38.660     0.150
     2.277    68.480     0.150
     2.277    69.441     0.150
     2.542    42.160     0.150
     2.664    43.410     0.150
     2.789    44.980     0.150
     2.789    83.461     0.150
     3.150    50.172     0.150
     3.205    50.480     0.150
     3.312    52.262     0.150
     3.494    55.250     0.150
     3.571    55.230     0.150
     3.577    56.121     0.150
     3.583    56.621     0.150
     3.687    57.359     0.150
     3.748    58.750     0.150
     3.932    61.891     0.150
     3.932    62.320     0.150
     3.932   108.422     0.150
     3.932   122.992     0.150
     4.071    62.961     0.150
     4.159    63.852     0.150
     4.236    65.551     0.150
     4.259    64.691     0.150
     4.470    70.191     0.150
     4.640    71.379     0.150
     4.681    71.191     0.150
     4.941    75.242     0.150
     4.994    75.859     0.150
     5.079    77.996     0.150
     5.079    89.770     0.150
     5.079   158.344     0.150
     5.079    77.762     0.150
     5.079    90.012     0.150
     5.079   157.680     0.150
     5.202    78.219     0.150
     5.414    81.398     0.150
     5.552    83.320     0.150
     5.674    85.129     0.150
     5.731    86.762     0.150
     5.776    87.129     0.150
     5.806    85.582     0.150
     5.806    85.070     0.150
     5.806   183.770     0.150
     5.809    85.949     0.150
     6.026    90.199     0.150
     6.150    91.832     0.150
     6.221    91.660     0.150
     6.254    93.461     0.150
     6.330    94.891     0.150
     6.450    95.531     0.150
     6.630    98.270     0.150
     6.669    98.531     0.150
     6.671    98.750     0.150
     6.751    99.340     0.150
     6.857   101.020     0.150
     6.893   102.371     0.150
     7.122   104.512     0.150
     7.240   105.109     0.150
     7.639   236.992     0.150
     7.658   112.840     0.150
     8.111   116.922     0.150
     8.201   119.648     0.150
     8.374   122.109     0.150
     8.404   125.148     0.150
     8.404   261.121     0.150
     8.426   121.922     0.150
     8.473   122.992     0.150
     8.571   125.270     0.150
     8.571   219.922     0.150
     8.571   266.520     0.150
     8.571   124.242     0.150
     8.571   125.121     0.150
     8.571   219.191     0.150
     8.570   124.570     0.150
     8.756   126.621     0.150
    10.133   148.020     0.150
    12.084   172.711     0.150
    12.084   376.461     0.150
    12.088   172.367     0.150
    12.088   379.016     0.150
    17.516   246.012     0.150
    18.316   254.031     0.150
    21.622   289.770     0.150
    21.622   291.020     0.150
    22.039   294.582     0.150
    22.428   300.242     0.150
    22.708   302.441     0.150
    27.608   346.949     0.150
    30.999   378.789     0.150
    59.909   607.449     0.150
     0.465     8.406     0.150
     0.465    14.938     0.150
     1.160    21.031     0.150
     1.160    36.516     0.150
     1.203    22.250     0.150
     1.203    39.156     0.150
     1.277    22.008     0.150
     1.557    27.727     0.150
     1.557    49.750     0.150
     1.723    29.188     0.150
     1.822    31.500     0.150
     2.295    38.852     0.150
     2.295    68.680     0.150
     2.295    68.016     0.150
     2.295    71.992     0.150
     2.537    41.930     0.150
     2.540    42.039     0.150
     2.653    43.281     0.150
     2.791    45.352     0.150
     3.194    49.758     0.150
     3.161    50.008     0.150
     3.305    52.211     0.150
     3.742    58.750     0.150
     3.949    62.070     0.150
     3.949    62.219     0.150
     3.949   108.852     0.150
     3.949   122.586     0.150
     4.074    62.852     0.150
     4.167    64.180     0.150
     4.232    65.570     0.150
     4.676    71.250     0.150
     4.936    75.102     0.150
     5.087    90.188     0.150
     5.087   157.969     0.150
     6.150    91.469     0.150
     6.450    95.828     0.150
     7.671   112.961     0.150
     8.417   260.672     0.150
     0.682    12.311     0.150
     0.686    12.621     0.150
     0.686    22.762     0.150
     1.243    23.031     0.150
     1.243    40.221     0.150
     1.498    26.391     0.150
     1.498    47.152     0.150
     1.618    28.852     0.150
     1.618    50.682     0.150
     1.875    32.871     0.150
     1.913    33.102     0.150
     2.099    36.252     0.150
     2.272    69.781     0.150
     2.296    38.711     0.150
     2.296    70.512     0.150
     2.600    42.852     0.150
     2.611    42.711     0.150
     3.114    48.961     0.150
     3.189    50.572     0.150
     3.349    53.461     0.150
     3.457    54.621     0.150
     3.732    58.652     0.150
     3.732    58.992     0.150
     3.884    60.701     0.150
     3.955    62.230     0.150
     4.093    63.582     0.150
     4.514    70.891     0.150
     4.543    69.230     0.150
     4.867    74.652     0.150
     5.093    77.342     0.150
     5.196    92.742     0.150
     5.196   162.072     0.150
     5.611    84.842     0.150
     5.981    89.652     0.150
    10.980   157.971     0.150
    11.591   166.602     0.150
     0.633    12.422     0.150
     0.872    16.680     0.150
     1.196    21.211     0.150
     1.196    37.688     0.150
     1.280    21.969     0.150
     1.725    28.844     0.150
     2.155    36.328     0.150
     2.155    62.664     0.150
     2.298    38.422     0.150
     2.298    38.273     0.150
     2.542    41.359     0.150
     2.789    44.102     0.150
     2.789    80.641     0.150
     2.696    43.242     0.150
     2.715    43.523     0.150
     2.923    46.398     0.150
     2.950    47.938     0.150
     3.306    51.852     0.150
     3.954    61.617     0.150
     3.954   125.148     0.150
     4.077    61.711     0.150
     4.171    64.461     0.150
     4.430    67.531     0.150
     4.489    68.422     0.150
     4.741    71.500     0.150
     5.087    76.133     0.150
     5.087    90.508     0.150
     5.087   157.234     0.150
     5.087    75.820     0.150
     5.087   159.383     0.150
     4.988    76.211     0.150
     5.037    74.312     0.150
     5.253    77.961     0.150
     5.193    77.523     0.150
     5.402    79.508     0.150
     5.570    83.508     0.150
     5.724    85.234     0.150
     5.795    85.273     0.150
     5.780    87.188     0.150
     6.152    90.430     0.150
     6.186    91.141     0.150
     6.247    91.141     0.150
     6.452    95.164     0.150
     6.725    98.281     0.150
     6.986   102.148     0.150
     7.220   105.094     0.150
     7.809   112.258     0.150
     8.100   117.617     0.150
     8.422   121.148     0.150
     8.597   124.609     0.150
     0.382     7.188     0.150
     0.382    12.078     0.150
     0.462     8.547     0.150
     0.643    12.477     0.150
     0.643    21.641     0.150
     0.814    15.539     0.150
     0.878    15.625     0.150
     0.878    28.359     0.150
     0.939    17.305     0.150
     0.939    30.023     0.150
     1.023    17.578     0.150
     1.023    31.594     0.150
     1.226    21.867     0.150
     1.226    39.008     0.150
     1.238    21.648     0.150
     1.238    38.656     0.150
     1.227    22.320     0.150
     1.227    40.164     0.150
     1.341    23.773     0.150
     1.341    44.750     0.150
     1.420    24.898     0.150
     1.420    43.859     0.150
     1.491    27.016     0.150
     1.491    47.734     0.150
     1.720    29.820     0.150
     1.720    52.836     0.150
     1.720    53.078     0.150
     1.518    27.117     0.150
     1.518    48.039     0.150
     1.626    28.039     0.150
     1.626    50.188     0.150
     1.616    28.203     0.150
     1.616    50.438     0.150
     1.676    28.797     0.150
     1.676    52.609     0.150
     1.808    31.594     0.150
     1.808    54.141     0.150
     1.896    32.484     0.150
     1.896    57.359     0.150
     1.915    33.141     0.150
     1.915    58.391     0.150
     2.211    36.094     0.150
     2.353    38.766     0.150
     2.353    69.070     0.150
     2.113    35.641     0.150
     2.238    37.438     0.150
     2.238    66.648     0.150
     3.146    50.086     0.150
     3.146    89.859     0.150
     3.433    54.156     0.150
     3.433    95.180     0.150
     3.954   122.258     0.150
     5.143   158.156     0.150
     0.226     4.711     0.150
     0.226     8.473     0.150
     0.226     8.031     0.150
     0.460     8.551     0.150
     0.460    15.762     0.150
     0.490    10.004     0.150
     0.490    17.961     0.150
     0.656    13.043     0.150
     0.758    13.902     0.150
     0.758    25.113     0.150
     0.800    14.871     0.150
     0.800    26.711     0.150
     0.947    17.621     0.150
     0.947    30.293     0.150
     1.076    19.902     0.150
     1.076    35.051     0.150
     1.125    20.883     0.150
     1.125    36.074     0.150
     1.167    20.953     0.150
     1.167    36.852     0.150
     1.167    20.781     0.150
     1.209    21.223     0.150
     1.280    22.141     0.150
     1.345    23.641     0.150
     1.345    41.293     0.150
     1.364    23.203     0.150
     1.378    24.621     0.150
     1.378    44.992     0.150
     1.366    24.914     0.150
     1.366    43.141     0.150
     1.496    27.773     0.150
     1.429    26.594     0.150
     1.429    45.480     0.150
     1.467    25.844     0.150
     1.467    46.391     0.150
     1.521    25.703     0.150
     1.580    26.664     0.150
     1.580    47.691     0.150
     1.646    28.031     0.150
     1.719    29.262     0.150
     1.733    31.031     0.150
     1.733    54.742     0.150
     1.754    30.293     0.150
     1.766    30.414     0.150
     1.787    30.141     0.150
     1.788    31.934     0.150
     1.850    32.352     0.150
     1.850    32.504     0.150
     1.850    56.383     0.150
     1.968    33.223     0.150
     1.989    33.434     0.150
     2.052    34.762     0.150
     2.086    34.891     0.150
     2.112    36.422     0.150
     2.134    35.371     0.150
     2.400    40.582     0.150
     2.448    39.621     0.150
     2.498    40.281     0.150
     2.517    40.992     0.150
     2.517    41.113     0.150
     2.517    73.031     0.150
     2.517    78.812     0.150
     2.533    40.773     0.150
     2.993    46.902     0.150
     3.124    48.691     0.150
     3.316    51.973     0.150
     4.008    61.363     0.150
     4.008    62.254     0.150
     4.067    62.113     0.150
     4.111    62.664     0.150
     4.450    68.422     0.150
     5.282   164.281     0.150
     0.373     6.639     0.150
     0.373    12.909     0.150
     0.518     9.379     0.150
     0.776    14.389     0.150
     0.776    24.999     0.150
     0.959    17.909     0.150
     0.959    30.949     0.150
     1.194    21.799     0.150
     1.194    38.009     0.150
     1.261    23.359     0.150
     1.261    40.319     0.150
     1.632    27.649     0.150
     1.632    49.739     0.150
     1.663    29.959     0.150
     1.734    30.938     0.150
     1.734    54.289     0.150
     1.757    31.039     0.150
     1.757    54.589     0.150
     2.242    37.959     0.150
     2.242    68.129     0.150
     2.332    41.389     0.150
     2.356    40.049     0.150
     2.356    70.179     0.150
     2.625    42.369     0.150
     2.625    75.399     0.150
     3.217    51.919     0.150
     3.217    89.938     0.150
     3.900    61.549     0.150
     3.900   107.509     0.150
     3.900    61.219     0.150
     3.900   107.829     0.150
     4.586    69.979     0.150
     4.586   123.079     0.150
     4.676    69.359     0.150
     4.676    85.609     0.150
     4.676   145.519     0.150
     5.107    76.969     0.150
     5.107   133.938     0.150
     5.174   160.489     0.150
     0.331     6.468     0.150
     0.331    11.258     0.150
     0.331     6.247     0.150
     0.331    11.428     0.150
     0.534     9.957     0.150
     0.534    17.917     0.150
     0.583    11.667     0.150
     0.680    13.258     0.150
     0.760    14.728     0.150
     0.812    15.188     0.150
     0.812    26.438     0.150
     0.867    16.237     0.150
     0.867    28.768     0.150
     0.979    18.388     0.150
     0.979    31.417     0.150
     1.163    20.888     0.150
     1.227    22.308     0.150
     1.227    38.897     0.150
     1.227    38.737     0.150
     1.313    23.388     0.150
     1.313    41.088     0.150
     1.283    23.838     0.150
     1.283    41.088     0.150
     1.332    23.808     0.150
     1.445    25.888     0.150
     1.549    27.107     0.150
     1.549    48.147     0.150
     1.540    26.167     0.150
     1.590    27.058     0.150
     1.590    50.088     0.150
     1.629    28.518     0.150
     1.644    29.397     0.150
     1.710    30.747     0.150
     1.801    32.128     0.150
     1.801    55.567     0.150
     1.801    31.598     0.150
     1.823    31.388     0.150
     1.823    55.207     0.150
     2.043    33.928     0.150
     2.020    34.947     0.150
     2.020    62.647     0.150
     2.054    34.878     0.150
     2.153    35.907     0.150
     2.170    35.798     0.150
     2.317    37.808     0.150
     2.312    40.617     0.150
     2.312    38.438     0.150
     2.419    38.747     0.150
     2.398    39.968     0.150
     2.398    70.497     0.150
     2.398    69.707     0.150
     2.525    40.718     0.150
     2.580    41.848     0.150
     2.580    75.167     0.150
     2.795    44.577     0.150
     3.066    48.397     0.150
     3.171    50.067     0.150
     3.171    87.178     0.150
     3.349    52.947     0.150
     3.893    60.737     0.150
     3.893   106.128     0.150
     3.950    60.947     0.150
     3.950    59.938     0.150
     3.950   120.027     0.150
     4.057    61.957     0.150
     4.098    62.987     0.150
     4.542    68.607     0.150
     4.542   122.638     0.150
     4.661    71.207     0.150
     4.661   145.718     0.150
     4.854    74.277     0.150
     5.061    75.848     0.150
     5.219   161.798     0.150
     5.219    78.657     0.150
     6.018    87.928     0.150
     7.119   102.388     0.150
     0.239     4.637     0.150
     0.239     8.316     0.150
     0.356     6.496     0.150
     0.356     6.598     0.150
     0.356    11.697     0.150
     0.529     9.656     0.150
     0.609    11.746     0.150
     0.681    13.117     0.150
     0.789    14.758     0.150
     0.789    25.527     0.150
     0.789    25.246     0.150
     0.893    16.486     0.150
     0.893    29.627     0.150
     0.963    18.098     0.150
     0.963    30.967     0.150
     0.963    30.857     0.150
     1.189    22.027     0.150
     1.205    21.848     0.150
     1.205    37.768     0.150
     1.205    22.066     0.150
     1.205    37.967     0.150
     1.347    25.047     0.150
     1.347    43.438     0.150
     1.266    23.707     0.150
     1.266    40.486     0.150
     1.266    40.627     0.150
     1.575    27.727     0.150
     1.575    48.146     0.150
     1.650    29.188     0.150
     1.650    29.557     0.150
     1.719    30.637     0.150
     1.777    30.967     0.150
     1.777    55.787     0.150
     1.849    31.627     0.150
     2.075    35.928     0.150
     2.109    35.447     0.150
     2.196    36.787     0.150
     2.263    38.326     0.150
     2.318    39.156     0.150
     2.318    40.947     0.150
     2.343    38.697     0.150
     2.373    39.746     0.150
     2.373    69.406     0.150
     2.902    46.467     0.150
     2.902    45.246     0.150
     2.902    79.787     0.150
     2.902    88.617     0.150
     3.075    48.496     0.150
     3.090    48.586     0.150
     3.196    50.416     0.150
     3.196    50.107     0.150
     3.196    88.287     0.150
     3.283    51.406     0.150
     3.373    53.066     0.150
     3.398    54.227     0.150
     3.495    55.826     0.150
     3.495    55.107     0.150
     3.571    55.348     0.150
     3.845    59.236     0.150
     3.892    60.777     0.150
     3.892   107.098     0.150
     3.892   124.607     0.150
     3.967    61.336     0.150
     4.070    63.297     0.150
     4.070    61.977     0.150
     4.121    63.217     0.150
     4.331    67.287     0.150
     4.523    68.816     0.150
     4.565    69.678     0.150
     4.664    71.297     0.150
     4.878    75.316     0.150
     5.194    78.018     0.150
     5.194    93.127     0.150
     5.194   162.178     0.150
     5.194    77.896     0.150
     5.458    81.836     0.150
     5.615    86.137     0.150
     5.712   107.637     0.150
     5.712   184.438     0.150
     5.712    87.297     0.150
     6.000    89.367     0.150
     6.235   109.377     0.150
     6.235   206.758     0.150
     6.336    94.268     0.150
     6.612   116.156     0.150
     6.886   103.018     0.150
     7.144   103.316     0.150
     7.590   111.496     0.150
     8.482   124.316     0.150
     8.514   124.027     0.150
     8.514   266.518     0.150
     8.560   123.646     0.150
     8.560   218.227     0.150
     8.560   266.297     0.150
     8.560   123.406     0.150
    11.210   160.336     0.150
    12.169   171.787     0.150
    12.174   172.643     0.150
    12.174   380.445     0.150
    12.174   172.537     0.150
    21.642   289.146     0.150
     0.548     9.773     0.150
     0.548    16.863     0.150
     0.548     9.863     0.150
     0.548    17.414     0.150
     0.548    17.305     0.150
     0.613    11.363     0.150
     0.613    20.135     0.150
     0.613    20.004     0.150
     0.736    14.264     0.150
     0.845    15.854     0.150
     0.845    27.443     0.150
     0.978    18.645     0.150
     1.004    16.873     0.150
     1.004    32.914     0.150
     1.038    18.715     0.150
     1.038    33.283     0.150
     1.083    20.234     0.150
     1.083    19.965     0.150
     1.083    34.994     0.150
     1.095    18.604     0.150
     1.136    21.123     0.150
     1.136    36.555     0.150
     1.274    23.635     0.150
     1.287    23.693     0.150
     1.308    22.824     0.150
     1.382    25.334     0.150
     1.382    43.635     0.150
     1.380    43.594     0.150
     1.474    26.244     0.150
     1.493    25.764     0.150
     1.617    27.604     0.150
     1.608    28.754     0.150
     1.608    50.113     0.150
     1.659    29.793     0.150
     1.696    30.475     0.150
     1.696    53.373     0.150
     1.696    30.273     0.150
     1.727    29.783     0.150
     1.767    31.215     0.150
     1.769    30.494     0.150
     1.769    54.074     0.150
     1.783    32.264     0.150
     1.783    55.344     0.150
     1.783    32.094     0.150
     1.826    32.174     0.150
     1.889    32.613     0.150
     1.892    32.623     0.150
     1.892    58.354     0.150
     2.036    35.184     0.150
     2.062    36.654     0.150
     2.084    36.254     0.150
     2.182    37.104     0.150
     2.182    67.344     0.150
     2.224    38.914     0.150
     2.258    38.754     0.150
     2.303    38.734     0.150
     2.337    39.334     0.150
     2.361    39.244     0.150
     2.388    40.225     0.150
     2.534    42.443     0.150
     2.585    43.344     0.150
     2.741    44.805     0.150
     2.749    44.344     0.150
     2.749    84.734     0.150
     2.749    49.543     0.150
     2.778    45.174     0.150
     3.133    50.684     0.150
     3.129    51.123     0.150
     3.129    52.064     0.150
     3.541    56.693     0.150
     3.653    57.984     0.150
     3.878    61.094     0.150
     3.878   105.023     0.150
     3.878    61.494     0.150
     3.967    62.504     0.150
     4.155    64.084     0.150
     4.155    65.453     0.150
     4.287    66.834     0.150
     4.681    71.645     0.150
     4.997    76.574     0.150
     5.013   156.344     0.150
     5.013    75.984     0.150
     0.257     4.352     0.150
     0.257     8.080     0.150
     0.340     6.170     0.150
     0.340    10.750     0.150
     0.340    11.061     0.150
     0.588    11.480     0.150
     0.588    20.471     0.150
     0.553    10.051     0.150
     0.765    14.420     0.150
     0.867    15.801     0.150
     0.867    29.041     0.150
     0.923    15.682     0.150
     0.923    27.182     0.150
     0.962    29.932     0.150
     0.962    18.051     0.150
     1.072    20.471     0.150
     1.072    35.631     0.150
     1.137    19.420     0.150
     1.137    20.611     0.150
     1.166    21.682     0.150
     1.166    21.830     0.150
     1.182    20.141     0.150
     1.182    20.000     0.150
     1.214    22.320     0.150
     1.214    38.320     0.150
     1.214    22.510     0.150
     1.267    23.941     0.150
     1.267    40.320     0.150
     1.267    23.330     0.150
     1.321    22.631     0.150
     1.408    25.420     0.150
     1.408    45.320     0.150
     1.445    26.230     0.150
     1.533    25.910     0.150
     1.533    47.730     0.150
     1.533    26.211     0.150
     1.550    27.602     0.150
     1.550    48.951     0.150
     1.581    26.611     0.150
     1.581    48.371     0.150
     1.610    28.691     0.150
     1.610    51.932     0.150
     1.628    29.211     0.150
     1.625    29.621     0.150
     1.625    50.820     0.150
     1.683    29.250     0.150
     1.692    51.541     0.150
     1.711    29.371     0.150
     1.711    52.631     0.150
     1.711    29.250     0.150
     1.711    53.451     0.150
     1.823    32.211     0.150
     1.823    56.400     0.150
     1.848    32.400     0.150
     1.807    31.811     0.150
     1.807    56.602     0.150
     1.807    32.721     0.150
     1.807    56.730     0.150
     2.043    35.471     0.150
     2.043    62.531     0.150
     2.044    35.230     0.150
     2.145    36.480     0.150
     2.145    65.611     0.150
     2.172    37.141     0.150
     2.293    41.561     0.150
     2.318    38.980     0.150
     2.291    69.361     0.150
     2.291    39.271     0.150
     2.398    41.281     0.150
     2.398    71.301     0.150
     2.391    40.320     0.150
     2.391    70.080     0.150
     2.391    73.090     0.150
     2.525    42.330     0.150
     2.576    42.590     0.150
     2.933    47.330     0.150
     3.048    49.211     0.150
     3.048    48.830     0.150
     3.343    53.660     0.150
     3.369    52.932     0.150
     5.222   162.420     0.150
     0.405     7.332     0.150
     0.416     7.520     0.150
     0.680    13.172     0.150
     0.789    14.781     0.150
     0.789    25.500     0.150
     0.985    17.902     0.150
     0.985    31.301     0.150
     1.021    19.191     0.150
     1.021    31.941     0.150
     1.086    18.742     0.150
     1.086    33.762     0.150
     1.216    22.270     0.150
     1.216    38.430     0.150
     1.266    22.883     0.150
     1.266    40.680     0.150
     1.300    22.430     0.150
     1.300    40.340     0.150
     1.315    24.430     0.150
     1.331    22.852     0.150
     1.434    26.699     0.150
     1.668    29.441     0.150
     1.668    51.191     0.150
     1.683    29.242     0.150
     1.683    52.922     0.150
     1.736    29.750     0.150
     1.736    54.051     0.150
     1.782    31.512     0.150
     1.782    56.512     0.150
     1.854    32.570     0.150
     1.854    58.262     0.150
     1.869    32.262     0.150
     1.869    58.242     0.150
     2.335    39.281     0.150
     2.335    68.199     0.150
     2.781    84.793     0.150
     4.008    62.301     0.150
     5.095   159.383     0.150
     0.234     4.609     0.150
     0.234     8.328     0.150
     0.332     6.250     0.150
     0.332    11.344     0.150
     0.332     6.438     0.150
     0.584    11.461     0.150
     0.584    21.008     0.150
     0.584    11.680     0.150
     0.531     9.828     0.150
     0.531    17.195     0.150
     0.761    14.719     0.150
     0.801    14.000     0.150
     0.801    26.445     0.150
     0.801    14.180     0.150
     0.812    15.234     0.150
     0.812    26.414     0.150
     0.870    16.266     0.150
     0.870    28.805     0.150
     0.980    18.406     0.150
     0.980    31.867     0.150
     1.075    19.914     0.150
     1.075    34.094     0.150
     1.165    21.188     0.150
     1.165    37.594     0.150
     1.192    20.391     0.150
     1.192    36.297     0.150
     1.192    36.508     0.150
     1.227    22.344     0.150
     1.227    38.758     0.150
     1.227    22.164     0.150
     1.227    38.539     0.150
     1.359    25.281     0.150
     1.284    24.141     0.150
     1.284    40.789     0.150
     1.335    23.484     0.150
     1.414    24.500     0.150
     1.414    44.617     0.150
     1.543    26.328     0.150
     1.543    47.445     0.150
     1.543    26.680     0.150
     1.551    27.336     0.150
     1.593    27.008     0.150
     1.593    48.477     0.150
     1.647    29.477     0.150
     1.647    52.508     0.150
     1.647    29.594     0.150
     1.631    28.469     0.150
     1.714    30.547     0.150
     1.691    29.188     0.150
     1.691    51.664     0.150
     1.724    29.758     0.150
     1.724    53.828     0.150
     1.826    31.500     0.150
     1.849    31.695     0.150
     2.057    34.406     0.150
     2.085    35.078     0.150
     2.156    36.219     0.150
     2.172    36.445     0.150
     2.319    38.078     0.150
     2.319    67.570     0.150
     2.410    39.680     0.150
     2.397    39.820     0.150
     2.397    70.328     0.150
     2.397    40.039     0.150
     2.583    41.570     0.150
     2.820    45.969     0.150
     2.922    45.969     0.150
     2.922    47.094     0.150
     3.069    48.266     0.150
     3.069    48.758     0.150
     3.073    47.680     0.150
     3.067    47.695     0.150
     3.174    50.266     0.150
     3.174    50.031     0.150
     3.352    52.258     0.150
     3.387    53.516     0.150
     3.302    51.000     0.150
     3.434    54.125     0.150
     3.444    55.125     0.150
     3.717    57.805     0.150
     3.759    58.570     0.150
     3.895    61.125     0.150
     3.895    60.734     0.150
     4.026    62.094     0.150
     4.060    62.109     0.150
     4.101    62.258     0.150
     4.323    65.438     0.150
     4.361    66.266     0.150
     4.501    67.055     0.150
     4.544    68.797     0.150
     4.664    69.586     0.150
     4.804    72.445     0.150
     5.063    75.516     0.150
     5.217   162.336     0.150
     5.701    84.141     0.150
     5.834    86.961     0.150
     5.893    87.359     0.150
     6.053    89.516     0.150
     6.321    93.109     0.150
     6.593    97.930     0.150
     6.614    97.836     0.150
     7.061   103.391     0.150
     7.120   103.227     0.150
     7.593   111.469     0.150
     8.291   119.547     0.150
     8.472   122.086     0.150
     0.177     3.223     0.150
     0.177     5.953     0.150
     0.413     7.660     0.150
     0.413    13.689     0.150
     0.413     7.613     0.150
     0.413    13.822     0.150
     0.431     7.822     0.150
     0.600    11.873     0.150
     0.676    13.152     0.150
     0.776    14.434     0.150
     0.776    24.934     0.150
     0.776    25.463     0.150
     0.845    16.184     0.150
     0.918    16.053     0.150
     0.918    29.793     0.150
     0.977    18.172     0.150
     0.977    31.992     0.150
     1.000    18.693     0.150
     1.000    32.162     0.150
     1.000    32.373     0.150
     1.066    18.232     0.150
     1.184    21.803     0.150
     1.202    21.822     0.150
     1.202    37.953     0.150
     1.202    38.141     0.150
     1.261    23.012     0.150
     1.261    40.291     0.150
     1.280    21.934     0.150
     1.283    21.902     0.150
     1.283    41.090     0.150
     1.295    24.303     0.150
     1.295    41.873     0.150
     1.410    26.172     0.150
     1.410    44.912     0.150
     1.410    25.947     0.150
     1.315    22.482     0.150
     1.315    41.393     0.150
     1.380    24.223     0.150
     1.463    25.523     0.150
     1.531    27.123     0.150
     1.531    48.812     0.150
     1.555    27.742     0.150
     1.650    29.002     0.150
     1.667    28.512     0.150
     1.667    51.863     0.150
     1.706    30.104     0.150
     1.719    29.152     0.150
     1.719    53.633     0.150
     1.740    30.482     0.150
     1.756    31.412     0.150
     1.756    55.453     0.150
     1.756    55.324     0.150
     1.809    31.062     0.150
     1.829    32.604     0.150
     1.829    57.232     0.150
     1.851    31.912     0.150
     1.851    57.293     0.150
     1.930    32.924     0.150
     1.930    59.189     0.150
     1.933    33.262     0.150
     1.953    33.123     0.150
     1.950    33.422     0.150
     2.130    38.123     0.150
     2.130    66.893     0.150
     2.149    36.582     0.150
     2.184    37.592     0.150
     2.184    37.322     0.150
     2.184    68.137     0.150
     2.177    36.453     0.150
     2.177    65.553     0.150
     2.172    36.973     0.150
     2.172    65.445     0.150
     2.271    38.162     0.150
     2.280    38.422     0.150
     2.330    39.023     0.150
     2.330    70.043     0.150
     2.330    38.846     0.150
     2.330    69.377     0.150
     2.422    40.242     0.150
     2.508    41.453     0.150
     2.535    41.963     0.150
     2.557    42.902     0.150
     2.557    42.447     0.150
     2.557    78.867     0.150
     2.630    44.113     0.150
     2.677    43.412     0.150
     2.700    43.832     0.150
     2.700    43.627     0.150
     2.700    78.266     0.150
     2.797    45.193     0.150
     2.882    46.443     0.150
     2.946    48.072     0.150
     2.946    47.785     0.150
     3.183    51.123     0.150
     3.183    51.822     0.150
     3.173    50.062     0.150
     3.187    51.092     0.150
     3.187    50.641     0.150
     3.177    50.953     0.150
     3.291    51.812     0.150
     3.474    55.184     0.150
     3.474    54.695     0.150
     3.483    55.383     0.150
     3.483    54.877     0.150
     3.537    55.672     0.150
     3.554    56.553     0.150
     3.642    57.916     0.150
     3.843    60.693     0.150
     3.843    60.533     0.150
     3.982    62.623     0.150
     3.982   108.842     0.150
     3.982    62.480     0.150
     4.080    64.143     0.150
     4.080    63.285     0.150
     4.136    64.043     0.150
     4.182    65.512     0.150
     4.223    65.172     0.150
     4.443    68.553     0.150
     4.443    68.766     0.150
     4.459    69.104     0.150
     4.618    70.893     0.150
     4.665    71.043     0.150
     4.665    70.887     0.150
     4.711    72.062     0.150
     4.711    71.898     0.150
     4.765    73.623     0.150
     4.765    72.820     0.150
     4.820    72.982     0.150
     4.820    72.691     0.150
     4.827    74.492     0.150
     4.924    75.312     0.150
     4.974    76.232     0.150
     5.105    92.184     0.150
     5.159    78.248     0.150
     5.306    79.693     0.150
     5.569    84.672     0.150
     6.148    91.363     0.150
     6.231    92.592     0.150
     6.448    95.373     0.150
     6.862   101.123     0.150
     7.189   105.652     0.150
     7.355   107.443     0.150
     7.676   111.723     0.150
     7.696   112.342     0.150
     7.748   112.922     0.150
     8.006   117.662     0.150
     0.342     6.178     0.150
     0.342    11.867     0.150
     0.404     7.047     0.150
     0.668    12.627     0.150
     0.846    15.367     0.150
     0.940    17.037     0.150
     0.982    18.188     0.150
     1.087    19.957     0.150
     1.087    34.877     0.150
     1.117    19.836     0.150
     1.253    22.777     0.150
     1.275    23.656     0.150
     1.275    41.076     0.150
     1.289    23.486     0.150
     1.289    41.086     0.150
     1.331    23.916     0.150
     1.331    41.957     0.150
     1.347    23.438     0.150
     1.380    25.807     0.150
     1.502    27.617     0.150
     1.700    29.316     0.150
     1.700    53.787     0.150
     1.756    30.117     0.150
     1.756    54.896     0.150
     1.838    32.768     0.150
     1.838    58.348     0.150
     1.893    33.197     0.150
     1.893    58.117     0.150
     1.907    34.137     0.150
     1.907    58.688     0.150
     2.213    40.697     0.150
     2.375    40.137     0.150
     2.375    70.566     0.150
     5.101   158.047     0.150
     0.398     7.125     0.150
     0.398    12.285     0.150
     0.439     7.756     0.150
     0.703    13.385     0.150
     0.776    14.486     0.150
     0.776    24.506     0.150
     0.955    16.996     0.150
     0.955    30.246     0.150
     1.009    18.326     0.150
     1.009    31.666     0.150
     1.016    18.955     0.150
     1.016    31.885     0.150
     1.107    19.227     0.150
     1.107    34.375     0.150
     1.204    22.156     0.150
     1.204    38.736     0.150
     1.238    22.295     0.150
     1.238    38.006     0.150
     1.289    23.477     0.150
     1.321    22.916     0.150
     1.321    40.977     0.150
     1.308    24.406     0.150
     1.308    41.666     0.150
     1.435    26.615     0.150
     1.435    45.625     0.150
     1.706    29.586     0.150
     1.706    52.516     0.150
     1.758    30.375     0.150
     1.758    54.236     0.150
     1.795    32.375     0.150
     1.795    55.525     0.150
     1.869    33.445     0.150
     1.869    57.416     0.150
     1.891    33.535     0.150
     1.891    58.346     0.150
     2.315    39.445     0.150
     2.315    70.756     0.150
     2.463    41.826     0.150
     2.758    45.086     0.150
     4.016    63.166     0.150
     4.016   110.436     0.150
     5.072   158.836     0.150
     5.635   176.375     0.150
     0.155     2.604     0.150
     0.155     5.055     0.150
     0.393     7.314     0.150
     0.393    12.924     0.150
     0.425     7.666     0.150
     0.425    14.016     0.150
     0.425     7.725     0.150
     0.425    14.014     0.150
     0.689    13.574     0.150
     0.689    24.184     0.150
     0.790    14.613     0.150
     0.790    26.305     0.150
     0.790    26.014     0.150
     0.943    16.434     0.150
     0.943    16.754     0.150
     0.943    30.895     0.150
     1.027    19.055     0.150
     1.027    33.225     0.150
     1.203    22.074     0.150
     1.218    21.863     0.150
     1.218    38.363     0.150
     1.218    22.465     0.150
     1.218    39.508     0.150
     1.240    22.135     0.150
     1.240    38.924     0.150
     1.275    23.334     0.150
     1.275    40.992     0.150
     1.320    24.385     0.150
     1.320    41.984     0.150
     1.443    26.654     0.150
     1.443    45.613     0.150
     1.402    25.545     0.150
     1.496    26.014     0.150
     1.554    27.344     0.150
     1.696    29.324     0.150
     1.696    52.854     0.150
     1.696    29.523     0.150
     1.696    52.715     0.150
     1.749    30.154     0.150
     1.749    29.914     0.150
     1.749    54.783     0.150
     1.759    31.045     0.150
     1.795    31.824     0.150
     1.868    33.004     0.150
     1.868    58.443     0.150
     1.868    33.154     0.150
     1.951    33.734     0.150
     1.965    34.754     0.150
     2.153    37.145     0.150
     2.153    37.258     0.150
     2.309    38.715     0.150
     2.437    40.994     0.150
     2.464    41.904     0.150
     2.565    42.453     0.150
     2.596    44.045     0.150
     2.724    44.674     0.150
     2.769    45.074     0.150
     2.769    44.654     0.150
     2.769    84.994     0.150
     2.823    47.135     0.150
     2.919    47.254     0.150
     2.975    48.625     0.150
     2.975    48.404     0.150
     3.148    50.014     0.150
     3.222    51.184     0.150
     3.222    51.104     0.150
     3.226    51.555     0.150
     3.248    52.834     0.150
     3.303    52.234     0.150
     3.315    52.744     0.150
     3.500    54.424     0.150
     3.521    56.064     0.150
     3.521    55.635     0.150
     3.573    56.703     0.150
     3.657    58.273     0.150
     3.657   113.215     0.150
     3.873    61.424     0.150
     3.921    63.564     0.150
     4.020    63.004     0.150
     4.020   111.094     0.150
     4.020    63.287     0.150
     4.220    66.693     0.150
     4.220    66.494     0.150
     4.481    69.184     0.150
     4.481    69.711     0.150
     4.497    67.594     0.150
     4.490    68.965     0.150
     4.641    69.715     0.150
     4.689    72.244     0.150
     4.689   126.283     0.150
     4.689   146.443     0.150
     4.691    71.654     0.150
     4.742    72.523     0.150
     4.804    72.033     0.150
     5.085    76.090     0.150
     5.085   158.840     0.150
     5.085    75.914     0.150
     5.085    76.744     0.150
     5.196    77.594     0.150
     5.316   166.844     0.150
     5.863    86.914     0.150
     5.863   182.564     0.150
     5.863    85.924     0.150
     7.190   104.184     0.150
     7.190   184.508     0.150
     7.190   104.795     0.150
     7.704   112.234     0.150
     7.735   113.924     0.150
     7.771   114.264     0.150
     8.664   126.738     0.150
    12.150   172.414     0.150
    12.150   380.090     0.150
    25.444   329.842     0.150
    68.208   659.953     0.150
     0.421     7.652     0.150
     0.421    13.191     0.150
     0.515     9.340     0.150
     0.676    12.730     0.150
     0.732    13.859     0.150
     0.732    23.512     0.150
     0.890    15.402     0.150
     0.890    27.859     0.150
     0.929    17.562     0.150
     0.929    29.371     0.150
     1.010    17.301     0.150
     1.152    21.270     0.150
     1.152    35.793     0.150
     1.224    21.820     0.150
     1.257    22.871     0.150
     1.257    39.660     0.150
     1.238    22.352     0.150
     1.228    23.082     0.150
     1.228    39.141     0.150
     1.330    24.762     0.150
     1.276    22.621     0.150
     1.626    28.312     0.150
     1.626    50.160     0.150
     1.673    28.973     0.150
     1.673    51.730     0.150
     1.676    29.723     0.150
     1.676    52.312     0.150
     1.712    29.961     0.150
     1.712    52.840     0.150
     1.721    31.621     0.150
     1.751    31.223     0.150
     1.801    31.492     0.150
     1.801    55.582     0.150
     2.216    37.562     0.150
     2.216    65.699     0.150
     2.308    38.871     0.150
     2.308    69.121     0.150
     2.344    42.020     0.150
     2.718    49.910     0.150
     2.718    85.500     0.150
     2.943    52.402     0.150
     3.303    59.621     0.150
     3.303   102.359     0.150
     3.898    60.680     0.150
     3.898   106.820     0.150
     5.127    76.551     0.150
     0.211     4.152     0.150
     0.211     7.523     0.150
     0.377     7.266     0.150
     0.377    12.402     0.150
     0.377     7.121     0.150
     0.377    12.641     0.150
     0.377     7.254     0.150
     0.491     8.961     0.150
     0.491    16.344     0.150
     0.491     9.066     0.150
     0.491    15.660     0.150
     0.491     9.121     0.150
     0.491    16.812     0.150
     0.491    15.559     0.150
     0.635    12.473     0.150
     0.635    22.613     0.150
     0.649    12.691     0.150
     0.705    12.383     0.150
     0.705    22.148     0.150
     0.809    15.570     0.150
     0.780    14.562     0.150
     0.780    25.191     0.150
     0.861    14.902     0.150
     0.861    26.641     0.150
     0.998    17.051     0.150
     0.998    31.883     0.150
     0.974    18.273     0.150
     0.974    31.613     0.150
     0.974    18.402     0.150
     0.974    30.961     0.150
     0.974    31.246     0.150
     1.038    18.102     0.150
     1.038    18.293     0.150
     1.038    32.738     0.150
     1.133    20.832     0.150
     1.133    36.023     0.150
     1.213    20.453     0.150
     1.213    36.941     0.150
     1.213    20.711     0.150
     1.215    20.672     0.150
     1.215    38.434     0.150
     1.218    22.293     0.150
     1.218    39.227     0.150
     1.201    21.844     0.150
     1.201    21.973     0.150
     1.201    38.141     0.150
     1.201    37.914     0.150
     1.253    21.312     0.150
     1.253    38.602     0.150
     1.369    25.551     0.150
     1.369    43.762     0.150
     1.369    25.430     0.150
     1.369    43.898     0.150
     1.275    23.742     0.150
     1.275    40.441     0.150
     1.326    23.230     0.150
     1.278    23.113     0.150
     1.396    24.242     0.150
     1.396    42.504     0.150
     1.474    25.203     0.150
     1.490    26.730     0.150
     1.505    26.852     0.150
     1.505    48.961     0.150
     1.605    27.730     0.150
     1.605    49.344     0.150
     1.654    28.281     0.150
     1.654    51.492     0.150
     1.663    28.973     0.150
     1.689    29.480     0.150
     1.691    30.113     0.150
     1.691    30.281     0.150
     1.691    53.152     0.150
     1.691    53.473     0.150
     1.751    29.953     0.150
     1.751    52.934     0.150
     1.762    31.492     0.150
     1.762    54.801     0.150
     1.785    30.633     0.150
     1.785    55.070     0.150
     1.738    30.262     0.150
     1.738    54.543     0.150
     1.768    31.371     0.150
     1.768    30.902     0.150
     1.768    55.141     0.150
     1.805    31.441     0.150
     1.805    31.332     0.150
     1.805    55.805     0.150
     1.873    32.070     0.150
     1.873    57.320     0.150
     1.883    32.531     0.150
     1.886    32.883     0.150
     1.886    32.746     0.150
     1.896    32.004     0.150
     1.896    56.391     0.150
     1.904    32.754     0.150
     2.101    35.422     0.150
     2.118    36.453     0.150
     2.118    36.047     0.150
     2.137    35.852     0.150
     2.217    37.262     0.150
     2.226    37.113     0.150
     2.226    36.844     0.150
     2.265    37.941     0.150
     2.265    38.254     0.150
     2.265    67.051     0.150
     2.265    67.520     0.150
     2.359    40.164     0.150
     2.359    39.352     0.150
     2.359    39.152     0.150
     2.353    40.062     0.150
     2.375    39.031     0.150
     2.471    40.801     0.150
     2.471    40.211     0.150
     2.471    40.078     0.150
     2.489    41.391     0.150
     2.489    41.062     0.150
     2.583    41.141     0.150
     2.626    42.531     0.150
     2.643    42.562     0.150
     2.643    43.363     0.150
     2.643    76.699     0.150
     2.761    45.121     0.150
     2.761    45.230     0.150
     2.761    86.461     0.150
     2.813    45.094     0.150
     2.882    46.082     0.150
     2.882    46.676     0.150
     2.882    82.656     0.150
     2.860    45.273     0.150
     2.860    45.504     0.150
     2.860    87.871     0.150
     2.978    46.941     0.150
     3.117    49.242     0.150
     3.117    49.082     0.150
     3.120    48.891     0.150
     3.120    49.266     0.150
     3.124    48.441     0.150
     3.124    48.969     0.150
     3.234    49.832     0.150
     3.234    51.004     0.150
     3.234    89.801     0.150
     3.221    51.754     0.150
     3.221    51.863     0.150
     3.221    90.641     0.150
     3.221   101.801     0.150
     3.241    50.453     0.150
     3.345    51.914     0.150
     3.345    52.113     0.150
     3.345    92.543     0.150
     3.345   104.184     0.150
     3.413    53.871     0.150
     3.413    54.043     0.150
     3.415    52.863     0.150
     3.415    53.551     0.150
     3.443    54.191     0.150
     3.490    53.332     0.150
     3.503    54.133     0.150
     3.539    55.535     0.150
     3.608    55.672     0.150
     3.638    57.391     0.150
     3.638    57.762     0.150
     3.638    99.094     0.150
     3.638   113.961     0.150
     3.778    59.414     0.150
     3.818    58.801     0.150
     3.818    58.434     0.150
     3.801    58.254     0.150
     3.855    60.801     0.150
     3.855   106.102     0.150
     3.926    61.414     0.150
     3.926    61.543     0.150
     3.926   104.992     0.150
     3.957    60.039     0.150
     4.012    61.754     0.150
     4.071    62.414     0.150
     4.071    62.609     0.150
     4.114    63.602     0.150
     4.162    63.812     0.150
     4.162    63.957     0.150
     4.326    66.570     0.150
     4.326    66.086     0.150
     4.357    66.820     0.150
     4.357    67.723     0.150
     4.357   119.012     0.150
     4.375    66.191     0.150
     4.375    66.375     0.150
     4.391    66.961     0.150
     4.391    66.766     0.150
     4.419    66.820     0.150
     4.387    66.371     0.150
     4.387    66.152     0.150
     4.562    69.723     0.150
     4.562    70.078     0.150
     4.605    69.613     0.150
     4.605    69.992     0.150
     4.646    71.012     0.150
     4.646    70.250     0.150
     4.674    71.754     0.150
     4.674   124.691     0.150
     4.674   146.312     0.150
     4.753    71.742     0.150
     4.753    72.148     0.150
     4.760    72.504     0.150
     4.760    72.281     0.150
     4.865    73.203     0.150
     4.917    74.582     0.150
     4.969    73.691     0.150
     5.094    77.434     0.150
     5.094    76.953     0.150
     5.122    76.730     0.150
     5.122    76.965     0.150
     5.158    77.441     0.150
     5.158   134.391     0.150
     5.158   157.918     0.150
     5.158    77.602     0.150
     5.158   159.594     0.150
     5.216    78.664     0.150
     5.238    77.953     0.150
     5.256    78.754     0.150
     5.256    79.891     0.150
     5.256   139.051     0.150
     5.256    79.664     0.150
     5.333    79.070     0.150
     5.320    79.012     0.150
     5.320    79.305     0.150
     5.413    81.887     0.150
     5.435    81.562     0.150
     5.435    81.930     0.150
     5.500    82.863     0.150
     5.502    82.852     0.150
     5.554    83.105     0.150
     5.657    84.863     0.150
     5.657    84.062     0.150
     5.631    84.703     0.150
     5.631    84.242     0.150
     5.667    85.914     0.150
     5.667   176.883     0.150
     5.757    85.172     0.150
     5.757    84.344     0.150
     5.757   148.586     0.150
     5.757   180.891     0.150
     5.794    85.250     0.150
     5.797    85.918     0.150
     5.806    85.691     0.150
     5.892    88.922     0.150
     5.945    87.641     0.150
     6.044    89.730     0.150
     6.044    89.609     0.150
     6.083    89.973     0.150
     6.083    90.242     0.150
     6.172    91.551     0.150
     6.167    91.898     0.150
     6.251    91.684     0.150
     6.280    94.004     0.150
     6.382    95.172     0.150
     6.555    96.766     0.150
     6.588    98.102     0.150
     6.654    98.613     0.150
     6.654    98.188     0.150
     6.674    97.973     0.150
     6.674    98.301     0.150
     6.754    99.664     0.150
     6.754    99.969     0.150
     6.749    99.406     0.150
     6.762   100.176     0.150
     6.761    99.176     0.150
     6.797   100.043     0.150
     6.797    99.332     0.150
     6.825   100.523     0.150
     6.842   101.434     0.150
     6.842   100.055     0.150
     6.853   102.164     0.150
     6.853   100.680     0.150
     6.920   101.961     0.150
     6.920   102.113     0.150
     6.872    99.422     0.150
     6.928   101.773     0.150
     7.085   103.516     0.150
     7.082   103.680     0.150
     7.120   104.953     0.150
     7.120   104.418     0.150
     7.258   105.566     0.150
     7.289   107.570     0.150
     7.289   106.883     0.150
     7.295   106.785     0.150
     7.289   106.223     0.150
     7.289   106.371     0.150
     7.427   107.953     0.150
     7.427   108.238     0.150
     7.436   108.633     0.150
     7.472   109.066     0.150
     7.612   110.121     0.150
     7.612   110.445     0.150
     7.630   112.891     0.150
     7.630   111.117     0.150
     7.637   111.543     0.150
     7.690   111.844     0.150
     7.690   112.586     0.150
     7.754   111.133     0.150
     7.754   111.441     0.150
     7.838   115.172     0.150
     7.874   114.504     0.150
     7.874   114.148     0.150
     7.941   114.922     0.150
     7.941   116.188     0.150
     7.938   115.598     0.150
     7.958   114.961     0.150
     7.970   116.414     0.150
     7.969   114.934     0.150
     7.969   116.562     0.150
     8.050   116.973     0.150
     8.115   118.379     0.150
     8.122   117.492     0.150
     8.122   117.836     0.150
     8.190   120.711     0.150
     8.190   119.508     0.150
     8.258   120.250     0.150
     8.352   119.832     0.150
     8.352   121.004     0.150
     8.419   122.539     0.150
     8.526   124.441     0.150
     8.526   123.684     0.150
     8.526   123.977     0.150
     8.484   123.703     0.150
     8.549   122.402     0.150
     8.549   217.301     0.150
     8.549   265.102     0.150
     8.586   124.293     0.150
     8.586   217.773     0.150
     8.586   264.992     0.150
     8.586   126.172     0.150
     8.619   124.746     0.150
     8.697   126.301     0.150
     8.827   127.168     0.150
     8.855   129.273     0.150
     9.088   131.055     0.150
     9.115   286.551     0.150
     9.240   133.488     0.150
     9.359   134.859     0.150
     9.410   297.414     0.150
     9.550   139.070     0.150
     9.556   137.484     0.150
     9.652   140.473     0.150
    10.043   144.449     0.150
    10.676   152.531     0.150
    11.293   160.781     0.150
    11.293   160.430     0.150
    12.161   171.922     0.150
    12.161   377.094     0.150
    13.154   186.320     0.150
    15.923   227.742     0.150
    17.587   244.910     0.150
    23.433   309.691     0.150
    25.548   329.645     0.150
    26.407   335.254     0.150
    34.030   401.410     0.150
    37.177   431.172     0.150
    37.403   433.152     0.150
    37.587   434.742     0.150
    37.587   435.203     0.150
    46.479   505.242     0.150
    50.160   533.965     0.150
    55.231  4150.633     0.150
    55.237  4150.996     0.150
    58.223   592.738     0.150
    59.594   603.715     0.150
    59.587   603.801     0.150
    59.848   605.082     0.150
    60.860   611.617     0.150
    65.274   639.883     0.150
    68.101   658.594     0.150
    69.126   664.570     0.150
    69.810   669.543     0.150
    74.036   694.980     0.150
    74.194   695.844     0.150
    88.619   773.543     0.150
     0.325     5.850     0.150
     0.325    10.470     0.150
     0.540     9.781     0.150
     0.540    17.185     0.150
     0.540     9.819     0.150
     0.540    17.060     0.150
     0.552     9.869     0.150
     0.552    17.420     0.150
     0.552    17.807     0.150
     0.618    11.409     0.150
     0.618    19.970     0.150
     0.747    13.119     0.150
     0.747    23.130     0.150
     0.747    13.005     0.150
     0.747    22.902     0.150
     0.794    15.499     0.150
     0.844    15.729     0.150
     0.844    27.239     0.150
     1.042    18.859     0.150
     1.042    32.670     0.150
     1.113    20.100     0.150
     1.113    36.177     0.150
     1.124    20.279     0.150
     1.124    35.499     0.150
     1.136    21.039     0.150
     1.136    36.029     0.150
     1.270    23.520     0.150
     1.619    50.359     0.150
     1.619    28.566     0.150
     1.619    50.817     0.150
     1.625    29.720     0.150
     1.625    51.279     0.150
     1.625    51.075     0.150
     1.639    29.086     0.150
     1.639    51.269     0.150
     1.686    30.020     0.150
     1.686    53.319     0.150
     1.686    52.741     0.150
     1.716    29.499     0.150
     1.716    52.470     0.150
     1.758    29.850     0.150
     1.758    53.890     0.150
     1.773    31.999     0.150
     1.773    55.939     0.150
     2.095    65.331     0.150
     2.108    36.779     0.150
     2.108    39.130     0.150
     2.108    66.609     0.150
     2.108    65.870     0.150
     2.213    39.020     0.150
     2.213    66.874     0.150
     2.270    39.800     0.150
     2.270    71.430     0.150
     2.352    42.619     0.150
     2.513    45.760     0.150
     2.513    78.109     0.150
     2.513    78.378     0.150
     2.642    48.609     0.150
     2.642    83.220     0.150
     2.760    44.300     0.150
     2.760    84.850     0.150
     2.834    50.880     0.150
     2.834    88.510     0.150
     2.834    87.351     0.150
     2.954    54.140     0.150
     2.954    93.180     0.150
     3.068    95.909     0.150
     3.124    96.930     0.150
     3.186    50.199     0.150
     3.186    57.550     0.150
     3.186    97.729     0.150
     3.732    59.680     0.150
     3.732   116.560     0.150
     3.871    61.550     0.150
     3.871   107.109     0.150
     4.064   125.800     0.150
     4.759   147.249     0.150
     5.024   155.350     0.150
     0.374     7.363     0.150
     0.374    12.625     0.150
     0.374     7.461     0.150
     0.374    12.551     0.150
     0.492     9.320     0.150
     0.492    16.309     0.150
     0.514     9.500     0.150
     0.514    16.898     0.150
     0.514     9.398     0.150
     0.629    12.461     0.150
     0.681    12.188     0.150
     0.681    21.449     0.150
     0.681    21.285     0.150
     0.776    14.668     0.150
     0.776    25.449     0.150
     0.961    18.121     0.150
     0.961    30.918     0.150
     0.961    31.070     0.150
     0.977    17.098     0.150
     1.056    18.668     0.150
     1.056    33.121     0.150
     1.117    20.258     0.150
     1.117    35.348     0.150
     1.117    35.086     0.150
     1.192    20.938     0.150
     1.194    20.602     0.150
     1.194    37.812     0.150
     1.194    22.000     0.150
     1.194    37.758     0.150
     1.194    21.867     0.150
     1.351    25.211     0.150
     1.262    23.559     0.150
     1.262    40.348     0.150
     1.286    23.309     0.150
     1.286    40.621     0.150
     1.286    40.406     0.150
     1.587    27.250     0.150
     1.635    28.148     0.150
     1.635    51.520     0.150
     1.667    29.641     0.150
     1.667    52.801     0.150
     1.667    29.484     0.150
     1.667    52.383     0.150
     1.738    30.781     0.150
     1.754    30.590     0.150
     1.754    54.359     0.150
     1.754    30.727     0.150
     1.754    54.703     0.150
     1.766    30.758     0.150
     1.766    54.770     0.150
     1.756    30.820     0.150
     1.756    53.711     0.150
     1.804    31.219     0.150
     1.804    55.262     0.150
     2.099    35.727     0.150
     2.257    37.930     0.150
     2.257    66.359     0.150
     2.257    37.668     0.150
     2.257    66.648     0.150
     2.336    39.090     0.150
     2.336    38.855     0.150
     2.332    38.980     0.150
     2.332    38.879     0.150
     2.466    40.809     0.150
     2.466    40.613     0.150
     2.744    44.828     0.150
     2.744    86.090     0.150
     2.790    44.324     0.150
     2.863    46.020     0.150
     2.989    92.051     0.150
     3.018    48.629     0.150
     3.018    94.711     0.150
     3.018    48.504     0.150
     3.097    49.148     0.150
     3.097    96.609     0.150
     3.320    51.910     0.150
     3.351    51.559     0.150
     3.351   103.828     0.150
     3.391    54.219     0.150
     3.396    53.309     0.150
     3.631    57.160     0.150
     3.631    97.961     0.150
     3.800    59.699     0.150
     3.800   103.039     0.150
     3.800   119.438     0.150
     3.904    60.570     0.150
     3.904   105.141     0.150
     4.048   124.598     0.150
     4.336   134.090     0.150
     4.397   116.719     0.150
     4.397   136.258     0.150
     4.667    71.418     0.150
     4.667    71.211     0.150
     5.171   161.879     0.150
     5.530   172.570     0.150
     0.234     4.805     0.150
     0.234     8.535     0.150
     0.380     7.371     0.150
     0.380    12.664     0.150
     0.380     7.336     0.150
     0.380    12.926     0.150
     0.380     7.445     0.150
     0.486     9.305     0.150
     0.486    16.227     0.150
     0.486    15.906     0.150
     0.515     9.395     0.150
     0.515    16.957     0.150
     0.515    16.605     0.150
     0.515    16.750     0.150
     0.634    12.348     0.150
     0.673    13.207     0.150
     0.683    12.098     0.150
     0.683    21.395     0.150
     0.683    20.980     0.150
     0.770    14.625     0.150
     0.770    25.297     0.150
     0.956    18.156     0.150
     0.956    30.965     0.150
     0.956    30.652     0.150
     0.980    17.258     0.150
     0.980    16.938     0.150
     0.980    29.875     0.150
     1.051    18.625     0.150
     1.051    32.926     0.150
     1.051    33.059     0.150
     1.116    20.305     0.150
     1.116    34.945     0.150
     1.116    35.230     0.150
     1.195    21.074     0.150
     1.195    20.688     0.150
     1.195    36.707     0.150
     1.197    20.473     0.150
     1.197    37.973     0.150
     1.188    21.984     0.150
     1.188    37.605     0.150
     1.188    21.805     0.150
     1.188    37.898     0.150
     1.347    25.195     0.150
     1.257    23.516     0.150
     1.257    40.445     0.150
     1.280    23.277     0.150
     1.280    40.547     0.150
     1.280    40.379     0.150
     1.378    24.375     0.150
     1.378    42.258     0.150
     1.591    27.258     0.150
     1.591    27.445     0.150
     1.639    27.734     0.150
     1.639    28.258     0.150
     1.639    51.418     0.150
     1.667    29.246     0.150
     1.667    52.715     0.150
     1.667    29.434     0.150
     1.741    29.656     0.150
     1.739    30.707     0.150
     1.749    30.637     0.150
     1.749    30.516     0.150
     1.749    53.840     0.150
     1.751    30.188     0.150
     1.751    53.766     0.150
     1.751    53.586     0.150
     1.769    30.574     0.150
     1.769    30.824     0.150
     1.769    54.848     0.150
     1.798    30.996     0.150
     1.798    55.141     0.150
     2.102    35.793     0.150
     2.102    63.734     0.150
     2.203    36.336     0.150
     2.235    40.078     0.150
     2.252    37.895     0.150
     2.252    66.477     0.150
     2.252    37.648     0.150
     2.252    66.301     0.150
     2.329    38.996     0.150
     2.329    68.277     0.150
     2.336    38.906     0.150
     2.336    38.207     0.150
     2.456    39.945     0.150
     2.467    40.695     0.150
     2.467    40.562     0.150
     2.740    44.617     0.150
     2.740    86.074     0.150
     2.740    44.324     0.150
     2.740    85.707     0.150
     2.792    44.395     0.150
     2.792    85.895     0.150
     2.796    85.543     0.150
     2.867    45.535     0.150
     2.867    88.066     0.150
     2.874    44.617     0.150
     2.984    46.395     0.150
     2.984    53.406     0.150
     2.984    82.367     0.150
     2.984    92.102     0.150
     3.015    48.477     0.150
     3.015    94.785     0.150
     3.015    93.855     0.150
     3.097    55.695     0.150
     3.201    98.418     0.150
     3.206    89.266     0.150
     3.256    50.676     0.150
     3.345    51.477     0.150
     3.345    51.805     0.150
     3.345    91.215     0.150
     3.345   104.027     0.150
     3.345    51.074     0.150
     3.401    53.316     0.150
     3.625    56.688     0.150
     3.625    98.324     0.150
     3.763    57.805     0.150
     3.797    59.566     0.150
     3.797   103.375     0.150
     3.797   119.438     0.150
     3.797   104.629     0.150
     3.902    60.355     0.150
     3.902   105.266     0.150
     4.048   108.125     0.150
     4.149    63.266     0.150
     4.333   136.324     0.150
     4.391   116.758     0.150
     4.661    71.234     0.150
     4.661   123.625     0.150
     4.661    71.121     0.150
     4.889    72.637     0.150
     4.889    73.250     0.150
     5.166    77.875     0.150
     5.166   161.234     0.150
     5.530   172.676     0.150
     0.372     7.070     0.150
     0.372    12.453     0.150
     0.372     7.102     0.150
     0.372    12.430     0.150
     0.497     9.219     0.150
     0.497    15.375     0.150
     0.568    10.445     0.150
     0.568    17.836     0.150
     0.568    18.219     0.150
     0.617    11.820     0.150
     0.628    11.000     0.150
     0.628    19.297     0.150
     0.769    14.594     0.150
     0.769    24.242     0.150
     0.930    15.797     0.150
     0.930    17.625     0.150
     0.930    29.703     0.150
     0.930    29.852     0.150
     1.064    19.281     0.150
     1.064    33.305     0.150
     1.097    19.383     0.150
     1.097    34.547     0.150
     1.097    19.250     0.150
     1.145    19.703     0.150
     1.145    35.086     0.150
     1.147    19.516     0.150
     1.147    35.258     0.150
     1.181    21.727     0.150
     1.181    37.203     0.150
     1.181    37.594     0.150
     1.309    24.477     0.150
     1.309    24.211     0.150
     1.234    23.047     0.150
     1.234    39.617     0.150
     1.305    23.703     0.150
     1.305    41.461     0.150
     1.547    26.133     0.150
     1.547    47.125     0.150
     1.593    27.492     0.150
     1.593    48.266     0.150
     1.613    28.914     0.150
     1.613    51.117     0.150
     1.613    50.547     0.150
     1.684    30.250     0.150
     1.684    53.172     0.150
     1.721    29.703     0.150
     1.721    53.016     0.150
     1.730    30.547     0.150
     1.730    53.523     0.150
     1.730    53.281     0.150
     1.790    31.195     0.150
     1.790    31.391     0.150
     1.802    31.523     0.150
     1.802    55.828     0.150
     2.054    35.414     0.150
     2.054    62.148     0.150
     2.240    37.742     0.150
     2.240    66.320     0.150
     2.240    37.477     0.150
     2.281    40.391     0.150
     2.281    40.164     0.150
     2.285    38.602     0.150
     2.285    66.633     0.150
     2.412    40.203     0.150
     2.706    44.406     0.150
     2.706    49.086     0.150
     2.706    85.047     0.150
     2.706    44.273     0.150
     2.706    77.438     0.150
     2.738    44.078     0.150
     2.738    84.547     0.150
     2.821    45.625     0.150
     2.920    46.906     0.150
     2.971    48.195     0.150
     2.971    93.344     0.150
     2.971    48.078     0.150
     3.014    47.414     0.150
     3.014    53.875     0.150
     3.014    83.797     0.150
     3.014    47.250     0.150
     3.042    48.844     0.150
     3.042    95.250     0.150
     3.319    52.195     0.150
     3.319    92.133     0.150
     3.359    52.742     0.150
     3.365    52.125     0.150
     3.365    92.250     0.150
     3.365    52.023     0.150
     3.753    59.062     0.150
     3.753   101.984     0.150
     3.753   117.320     0.150
     3.753    59.203     0.150
     3.799   104.570     0.150
     3.799   119.547     0.150
     3.852    60.086     0.150
     4.651    71.273     0.150
     4.651   123.664     0.150
     5.184   137.555     0.150
     0.284     5.582     0.150
     0.284     9.764     0.150
     0.368     7.062     0.150
     0.368    12.342     0.150
     0.503     9.283     0.150
     0.503    16.104     0.150
     0.612    11.842     0.150
     0.575    10.412     0.150
     0.575    18.283     0.150
     0.619    10.982     0.150
     0.619    19.184     0.150
     0.726    13.893     0.150
     0.806    14.033     0.150
     0.806    13.812     0.150
     0.806    25.842     0.150
     0.772    14.672     0.150
     0.921    15.672     0.150
     0.930    17.643     0.150
     0.930    29.662     0.150
     1.058    19.264     0.150
     1.058    33.043     0.150
     1.136    19.453     0.150
     1.106    19.402     0.150
     1.106    34.383     0.150
     1.186    21.662     0.150
     1.186    39.854     0.150
     1.183    21.742     0.150
     1.183    21.582     0.150
     1.183    36.742     0.150
     1.306    24.502     0.150
     1.306    41.732     0.150
     1.234    23.123     0.150
     1.234    39.434     0.150
     1.319    23.443     0.150
     1.312    23.793     0.150
     1.312    41.373     0.150
     1.420    24.213     0.150
     1.538    25.883     0.150
     1.538    46.623     0.150
     1.584    26.203     0.150
     1.584    47.572     0.150
     1.605    28.953     0.150
     1.605    50.383     0.150
     1.630    28.604     0.150
     1.644    28.893     0.150
     1.676    30.123     0.150
     1.676    52.152     0.150
     1.694    28.953     0.150
     1.713    29.363     0.150
     1.713    52.123     0.150
     1.730    30.434     0.150
     1.730    53.162     0.150
     1.799    30.822     0.150
     1.799    55.893     0.150
     2.046    35.264     0.150
     2.108    35.453     0.150
     2.150    36.104     0.150
     2.274    37.943     0.150
     2.274    40.252     0.150
     2.242    37.764     0.150
     2.242    66.562     0.150
     2.281    38.492     0.150
     2.281    66.783     0.150
     2.280    38.092     0.150
     2.336    38.572     0.150
     2.401    39.434     0.150
     2.403    39.684     0.150
     2.729    43.953     0.150
     2.704    44.213     0.150
     2.704    44.002     0.150
     2.704    85.322     0.150
     2.929    47.354     0.150
     2.929    45.793     0.150
     2.929    88.803     0.150
     2.966    48.162     0.150
     2.966    93.332     0.150
     3.031    48.023     0.150
     3.034    48.293     0.150
     3.034    47.822     0.150
     3.034    94.963     0.150
     3.022    46.543     0.150
     3.022    93.842     0.150
     3.080    48.662     0.150
     3.178    50.123     0.150
     3.178    49.543     0.150
     3.192    51.203     0.150
     3.192    50.613     0.150
     3.192    89.123     0.150
     3.330    52.402     0.150
     3.350    52.393     0.150
     3.311    51.643     0.150
     3.323    52.264     0.150
     3.323    91.562     0.150
     3.372    52.143     0.150
     3.372    51.582     0.150
     3.615    57.312     0.150
     3.749    59.354     0.150
     3.749   101.693     0.150
     3.749   117.342     0.150
     3.796    59.123     0.150
     3.796    59.393     0.150
     3.796   119.812     0.150
     3.847    59.982     0.150
     3.847    59.672     0.150
     3.985    61.482     0.150
     3.985    60.922     0.150
     3.985   123.873     0.150
     4.028    62.492     0.150
     4.289    65.523     0.150
     4.282   134.072     0.150
     4.306    65.922     0.150
     4.427    79.684     0.150
     4.427   136.264     0.150
     4.619    70.273     0.150
     4.667    70.693     0.150
     4.653    71.283     0.150
     4.653   123.723     0.150
     5.210   163.783     0.150
     5.470    81.793     0.150
     5.470   169.863     0.150
     6.084    90.453     0.150
     6.084   189.104     0.150
     0.431     7.720     0.150
     0.431    13.950     0.150
     0.431    13.688     0.150
     0.420     7.468     0.150
     0.420    14.021     0.150
     0.420     7.460     0.150
     0.420    14.050     0.150
     0.468     8.580     0.150
     0.468    15.547     0.150
     0.683    13.050     0.150
     0.770    14.150     0.150
     0.777    13.240     0.150
     0.777    23.090     0.150
     0.925    17.070     0.150
     0.925    30.300     0.150
     0.969    16.860     0.150
     0.969    30.260     0.150
     0.969    17.104     0.150
     0.969    30.423     0.150
     0.996    18.561     0.150
     0.996    31.601     0.150
     0.996    32.130     0.150
     1.071    18.370     0.150
     1.197    21.620     0.150
     1.197    38.220     0.150
     1.197    21.497     0.150
     1.232    22.141     0.150
     1.232    39.170     0.150
     1.269    23.010     0.150
     1.269    41.078     0.150
     1.285    40.530     0.150
     1.288    23.275     0.150
     1.288    40.895     0.150
     1.291    23.811     0.150
     1.291    41.330     0.150
     1.322    23.021     0.150
     1.322    41.400     0.150
     1.408    25.900     0.150
     1.408    44.990     0.150
     1.408    44.863     0.150
     1.673    29.240     0.150
     1.673    51.891     0.150
     1.673    52.180     0.150
     1.674    28.940     0.150
     1.674    52.120     0.150
     1.725    29.990     0.150
     1.725    53.430     0.150
     1.758    31.271     0.150
     1.758    31.023     0.150
     1.783    31.514     0.150
     1.781    32.630     0.150
     1.781    56.120     0.150
     1.832    32.590     0.150
     1.857    32.440     0.150
     1.937    33.128     0.150
     1.937    60.604     0.150
     2.190    37.853     0.150
     2.190    68.586     0.150
     2.264    38.630     0.150
     2.399    41.460     0.150
     2.399    41.356     0.150
     2.399    71.899     0.150
     2.426    41.480     0.150
     2.561    43.360     0.150
     2.791    86.230     0.150
     2.886    90.050     0.150
     2.924    52.650     0.150
     2.924    92.030     0.150
     2.924    82.648     0.150
     2.952    47.800     0.150
     2.952    90.320     0.150
     3.084    51.200     0.150
     3.084    97.220     0.150
     3.084    95.540     0.150
     3.302    52.021     0.150
     3.302   102.430     0.150
     3.302   102.171     0.150
     3.480    54.942     0.150
     3.480    97.702     0.150
     3.864    61.220     0.150
     3.864   104.880     0.150
     3.864   121.880     0.150
     3.864    61.695     0.150
     3.982    62.150     0.150
     3.982    62.836     0.150
     4.334   133.700     0.150
     5.098   157.740     0.150
     0.212     4.596     0.150
     0.212     8.236     0.150
     0.389     7.645     0.150
     0.389    12.578     0.150
     0.389     7.596     0.150
     0.389    13.105     0.150
     0.389    13.387     0.150
     0.480     9.156     0.150
     0.480    16.066     0.150
     0.480     9.047     0.150
     0.480    15.617     0.150
     0.487     8.926     0.150
     0.487    15.287     0.150
     0.487     9.266     0.150
     0.487    16.156     0.150
     0.648    12.646     0.150
     0.648    22.137     0.150
     0.713    12.736     0.150
     0.713    22.326     0.150
     0.713    22.166     0.150
     0.648    12.826     0.150
     0.771    14.576     0.150
     0.771    25.086     0.150
     0.771    25.307     0.150
     0.874    15.877     0.150
     0.874    28.547     0.150
     0.939    17.346     0.150
     0.939    30.566     0.150
     0.969    18.377     0.150
     0.969    31.207     0.150
     0.969    31.062     0.150
     1.009    17.666     0.150
     1.009    17.775     0.150
     1.009    30.396     0.150
     1.025    18.287     0.150
     1.025    32.207     0.150
     1.025    32.037     0.150
     1.145    20.957     0.150
     1.192    21.967     0.150
     1.192    37.834     0.150
     1.224    21.346     0.150
     1.224    21.996     0.150
     1.224    37.426     0.150
     1.226    21.645     0.150
     1.231    22.207     0.150
     1.231    39.055     0.150
     1.231    22.416     0.150
     1.231    38.637     0.150
     1.265    21.996     0.150
     1.265    22.137     0.150
     1.265    39.646     0.150
     1.368    25.627     0.150
     1.269    23.787     0.150
     1.269    40.686     0.150
     1.265    22.977     0.150
     1.265    40.068     0.150
     1.265    39.877     0.150
     1.339    23.666     0.150
     1.407    24.826     0.150
     1.487    26.275     0.150
     1.502    26.227     0.150
     1.502    46.787     0.150
     1.617    27.646     0.150
     1.617    49.896     0.150
     1.617    49.377     0.150
     1.666    28.646     0.150
     1.666    28.457     0.150
     1.666    51.195     0.150
     1.675    28.936     0.150
     1.697    30.445     0.150
     1.702    29.367     0.150
     1.769    31.166     0.150
     1.764    30.367     0.150
     1.762    30.686     0.150
     1.762    30.547     0.150
     1.762    53.924     0.150
     1.797    31.346     0.150
     1.797    31.496     0.150
     1.797    55.695     0.150
     1.794    30.936     0.150
     1.794    54.906     0.150
     1.886    32.221     0.150
     1.886    56.639     0.150
     1.896    32.186     0.150
     1.909    32.105     0.150
     1.899    32.330     0.150
     1.899    58.559     0.150
     1.917    32.246     0.150
     2.130    36.156     0.150
     2.130    35.998     0.150
     2.130    64.209     0.150
     2.149    35.576     0.150
     2.229    36.916     0.150
     2.239    36.627     0.150
     2.213    36.916     0.150
     2.257    37.627     0.150
     2.257    66.412     0.150
     2.257    37.846     0.150
     2.353    39.076     0.150
     2.388    38.707     0.150
     2.483    40.307     0.150
     2.497    40.266     0.150
     2.497    41.686     0.150
     2.497    73.057     0.150
     2.757    44.506     0.150
     2.757    44.377     0.150
     2.822    44.695     0.150
     2.822    44.803     0.150
     2.766    44.236     0.150
     2.766    45.043     0.150
     2.766    84.385     0.150
     2.894    45.896     0.150
     2.894    46.248     0.150
     2.894    81.721     0.150
     2.848    44.227     0.150
     2.848    44.537     0.150
     2.848    80.336     0.150
     2.965    52.568     0.150
     2.965    92.191     0.150
     2.965    46.406     0.150
     3.038    48.807     0.150
     3.038    48.621     0.150
     3.038    94.738     0.150
     3.038    85.627     0.150
     3.127    50.059     0.150
     3.127    96.725     0.150
     3.127    49.486     0.150
     3.127    97.586     0.150
     3.213    50.842     0.150
     3.213    89.746     0.150
     3.213    89.016     0.150
     3.174    49.139     0.150
     3.229    49.656     0.150
     3.310    51.717     0.150
     3.310    91.129     0.150
     3.310    90.986     0.150
     3.333    51.336     0.150
     3.333    91.541     0.150
     3.426    53.627     0.150
     3.426    94.258     0.150
     3.630    56.881     0.150
     3.630    57.047     0.150
     3.710   112.543     0.150
     3.790    58.166     0.150
     3.790    59.363     0.150
     3.820    59.787     0.150
     3.820   103.307     0.150
     3.820   118.605     0.150
     3.853    59.006     0.150
     3.853    60.467     0.150
     3.853   104.996     0.150
     3.863    58.816     0.150
     3.863   121.307     0.150
     3.970    60.066     0.150
     4.077    61.986     0.150
     4.077    62.164     0.150
     4.077   126.086     0.150
     4.174   113.256     0.150
     4.174    63.570     0.150
     4.358   138.627     0.150
     4.358   134.057     0.150
     4.383    67.266     0.150
     4.374   115.957     0.150
     4.374   135.945     0.150
     4.677    71.807     0.150
     4.677   125.605     0.150
     4.665    70.939     0.150
     4.665    71.217     0.150
     4.665   123.406     0.150
     4.761    72.756     0.150
     4.865   150.166     0.150
     5.145   159.807     0.150
     5.246    79.371     0.150
     5.287    80.537     0.150
     5.287    80.727     0.150
     5.287   139.637     0.150
     5.321    80.146     0.150
     5.321    80.311     0.150
     5.321    80.816     0.150
     5.321   139.945     0.150
     5.441    81.596     0.150
     5.559    83.207     0.150
     5.559    83.605     0.150
     5.559   143.596     0.150
     5.559   173.846     0.150
     6.138    91.396     0.150
     6.138    91.172     0.150
     6.138   159.936     0.150
     6.172    91.236     0.150
     6.753   210.275     0.150
     7.008   102.547     0.150
     7.008   179.445     0.150
     0.182     3.215     0.150
     0.182     5.902     0.150
     0.442     8.215     0.150
     0.442    14.523     0.150
     0.406     7.641     0.150
     0.406    13.262     0.150
     0.406     7.625     0.150
     0.406    13.832     0.150
     0.476     8.805     0.150
     0.476    15.805     0.150
     0.609    11.703     0.150
     0.609    12.293     0.150
     0.669    12.984     0.150
     0.669    13.223     0.150
     0.669    23.914     0.150
     0.776    14.402     0.150
     0.776    25.582     0.150
     0.776    25.055     0.150
     0.761    13.145     0.150
     0.761    23.750     0.150
     0.908    16.074     0.150
     0.908    29.035     0.150
     0.908    15.922     0.150
     0.986    17.332     0.150
     0.986    30.793     0.150
     0.986    17.492     0.150
     0.986    30.285     0.150
     0.986    30.125     0.150
     0.968    18.016     0.150
     0.968    31.043     0.150
     0.968    18.273     0.150
     0.968    32.016     0.150
     0.994    18.516     0.150
     0.994    32.074     0.150
     1.054    17.984     0.150
     1.054    34.035     0.150
     1.054    33.855     0.150
     1.201    21.562     0.150
     1.201    21.734     0.150
     1.201    37.809     0.150
     1.201    21.855     0.150
     1.201    38.074     0.150
     1.175    21.105     0.150
     1.175    37.922     0.150
     1.245    22.562     0.150
     1.245    39.965     0.150
     1.245    39.863     0.150
     1.245    39.684     0.150
     1.254    21.922     0.150
     1.254    40.906     0.150
     1.291    23.875     0.150
     1.291    40.832     0.150
     1.268    21.543     0.150
     1.268    21.785     0.150
     1.268    40.074     0.150
     1.271    21.609     0.150
     1.271    40.559     0.150
     1.402    25.895     0.150
     1.402    45.539     0.150
     1.304    22.152     0.150
     1.304    41.914     0.150
     1.304    22.555     0.150
     1.371    24.152     0.150
     1.371    44.035     0.150
     1.451    24.805     0.150
     1.451    46.105     0.150
     1.656    28.242     0.150
     1.656    51.332     0.150
     1.656    28.363     0.150
     1.731    53.094     0.150
     1.744    31.215     0.150
     1.744    53.582     0.150
     1.744    31.324     0.150
     1.791    31.793     0.150
     1.791    56.355     0.150
     1.782    31.715     0.150
     1.782    31.586     0.150
     1.782    55.828     0.150
     1.782    32.574     0.150
     1.782    56.094     0.150
     1.799    30.105     0.150
     1.799    54.863     0.150
     1.799    56.965     0.150
     1.817    32.152     0.150
     1.839    31.863     0.150
     1.839    58.152     0.150
     1.921    33.262     0.150
     1.920    33.219     0.150
     1.920    59.199     0.150
     1.924    33.402     0.150
     1.942    33.805     0.150
     2.181    38.895     0.150
     2.181    37.059     0.150
     2.181    66.113     0.150
     2.173    37.188     0.150
     2.173    67.484     0.150
     2.268    38.883     0.150
     2.268    68.090     0.150
     2.269    37.922     0.150
     2.334    39.285     0.150
     2.334    69.746     0.150
     2.391    40.703     0.150
     2.391    40.137     0.150
     2.391    71.266     0.150
     2.391    41.395     0.150
     2.391    71.465     0.150
     2.413    39.695     0.150
     2.413    43.523     0.150
     2.413    42.195     0.150
     2.552    78.418     0.150
     2.524    41.875     0.150
     2.545    42.785     0.150
     2.545    42.441     0.150
     2.545    79.840     0.150
     2.545    43.363     0.150
     2.720    44.355     0.150
     2.808    45.312     0.150
     2.808    45.184     0.150
     2.787    45.965     0.150
     2.787    46.453     0.150
     2.787    51.422     0.150
     2.869    46.395     0.150
     2.869    47.043     0.150
     2.939    47.113     0.150
     2.939    91.793     0.150
     2.934    47.438     0.150
     2.937    48.133     0.150
     3.031    49.562     0.150
     3.076    50.242     0.150
     3.076    50.605     0.150
     3.076    56.672     0.150
     3.132    50.223     0.150
     3.132    50.031     0.150
     3.188    51.293     0.150
     3.165    50.195     0.150
     3.165    49.320     0.150
     3.171    51.074     0.150
     3.175    51.164     0.150
     3.175    51.293     0.150
     3.175    56.895     0.150
     3.227    51.832     0.150
     3.227    52.172     0.150
     3.227    52.484     0.150
     3.306    52.473     0.150
     3.306   102.785     0.150
     3.315    51.434     0.150
     3.315    51.895     0.150
     3.315    51.562     0.150
     3.315   101.895     0.150
     3.282    51.375     0.150
     3.282    51.973     0.150
     3.463    55.105     0.150
     3.471    54.742     0.150
     3.471    55.332     0.150
     3.545    54.633     0.150
     3.595    63.418     0.150
     3.665    57.125     0.150
     3.665    58.941     0.150
     3.640    57.809     0.150
     3.744    61.094     0.150
     3.832    59.555     0.150
     3.832    59.445     0.150
     3.832   118.016     0.150
     3.831    60.629     0.150
     3.857    61.043     0.150
     3.857    61.422     0.150
     3.862    58.953     0.150
     3.883    60.523     0.150
     3.972    62.883     0.150
     3.991    61.543     0.150
     3.991    61.734     0.150
     4.068    62.184     0.150
     4.068    62.488     0.150
     4.125    63.664     0.150
     4.125    64.434     0.150
     4.125    63.254     0.150
     4.212    64.766     0.150
     4.349    66.453     0.150
     4.349    66.055     0.150
     4.349   133.652     0.150
     4.376    66.355     0.150
     4.376    67.184     0.150
     4.398    66.984     0.150
     4.431    68.395     0.150
     4.462    68.004     0.150
     4.609    70.930     0.150
     4.674    72.184     0.150
     4.674   146.023     0.150
     4.655    70.613     0.150
     4.712    72.902     0.150
     4.712    73.352     0.150
     4.712   128.953     0.150
     4.712   148.523     0.150
     4.700    71.652     0.150
     4.829    73.605     0.150
     4.829    73.035     0.150
     4.808    72.934     0.150
     4.808    73.977     0.150
     4.815    72.672     0.150
     4.815    73.555     0.150
     4.964    77.223     0.150
     5.114    77.281     0.150
     5.114    76.395     0.150
     5.114    90.414     0.150
     5.147    78.348     0.150
     5.166    76.695     0.150
     5.166    77.859     0.150
     5.270    80.023     0.150
     5.299    80.953     0.150
     5.299    80.457     0.150
     5.299    81.504     0.150
     5.299   143.133     0.150
     5.294    79.652     0.150
     5.294    80.090     0.150
     5.324    81.391     0.150
     5.324    82.145     0.150
     5.365    82.414     0.150
     5.365    81.719     0.150
     5.365    82.273     0.150
     5.373    80.125     0.150
     5.488    83.375     0.150
     5.488    83.480     0.150
     5.557    83.516     0.150
     5.557    83.324     0.150
     5.605    84.605     0.150
     5.605    84.801     0.150
     5.605    85.305     0.150
     5.664    84.402     0.150
     5.750    84.172     0.150
     5.698    86.691     0.150
     5.707    86.516     0.150
     5.813    85.375     0.150
     5.813    87.035     0.150
     5.949    88.703     0.150
     5.984    88.664     0.150
     6.099    90.684     0.150
     6.099    91.797     0.150
     6.137    91.293     0.150
     6.137    92.273     0.150
     6.172    91.723     0.150
     6.172    93.402     0.150
     6.172    94.473     0.150
     6.217    92.133     0.150
     6.217    93.766     0.150
     6.221    91.516     0.150
     6.294    91.492     0.150
     6.336    94.383     0.150
     6.345    94.266     0.150
     6.345    95.844     0.150
     6.405    95.875     0.150
     6.437    95.094     0.150
     6.592    97.355     0.150
     6.592    98.844     0.150
     6.706    99.484     0.150
     6.706   100.305     0.150
     6.730    99.344     0.150
     6.730   100.203     0.150
     6.787    99.902     0.150
     6.788   100.828     0.150
     6.799   101.426     0.150
     6.799   101.242     0.150
     6.810   101.492     0.150
     6.850   102.684     0.150
     6.862    99.344     0.150
     6.889   102.852     0.150
     6.909   101.445     0.150
     6.955   103.984     0.150
     7.047   105.234     0.150
     7.139   106.352     0.150
     7.320   107.223     0.150
     7.320   107.898     0.150
     7.313   108.211     0.150
     7.345   107.812     0.150
     7.345   108.422     0.150
     7.468   109.289     0.150
     7.483   110.477     0.150
     7.527   111.020     0.150
     7.665   111.434     0.150
     7.665   112.527     0.150
     7.690   113.535     0.150
     7.686   113.113     0.150
     7.737   113.676     0.150
     7.773   111.355     0.150
     7.773   113.094     0.150
     7.890   116.410     0.150
     7.910   114.543     0.150
     7.910   116.078     0.150
     7.992   115.754     0.150
     7.992   117.633     0.150
     7.995   116.492     0.150
     7.995   117.547     0.150
     8.001   115.645     0.150
     8.001   118.195     0.150
     8.079   116.703     0.150
     8.164   118.973     0.150
     8.188   120.242     0.150
     8.246   120.945     0.150
     8.313   121.746     0.150
     8.402   121.473     0.150
     8.528   124.617     0.150
     8.595   124.895     0.150
     8.622   124.516     0.150
     8.639   127.609     0.150
     8.837   127.062     0.150
     8.837   128.211     0.150
     8.865   129.723     0.150
     8.910   129.914     0.150
     8.910   130.625     0.150
     8.999   132.488     0.150
     9.122   133.754     0.150
     9.401   135.422     0.150
     0.220     4.484     0.150
     0.220     8.054     0.150
     0.388     7.559     0.150
     0.388    12.732     0.150
     0.388     7.564     0.150
     0.388    12.934     0.150
     0.388    13.294     0.150
     0.496     9.104     0.150
     0.496    16.024     0.150
     0.496    15.786     0.150
     0.480     9.054     0.150
     0.480    15.724     0.150
     0.480    16.064     0.150
     0.645    12.694     0.150
     0.645    21.364     0.150
     0.657    12.374     0.150
     0.704    12.684     0.150
     0.704    22.034     0.150
     0.704    22.139     0.150
     0.769    14.644     0.150
     0.769    25.314     0.150
     0.769    14.754     0.150
     0.935    17.344     0.150
     0.935    30.074     0.150
     0.964    18.334     0.150
     0.964    31.014     0.150
     1.001    17.754     0.150
     1.001    30.504     0.150
     1.001    17.554     0.150
     1.032    18.434     0.150
     1.032    32.154     0.150
     1.032    18.249     0.150
     1.135    20.784     0.150
     1.135    35.844     0.150
     1.135    36.054     0.150
     1.135    35.951     0.150
     1.189    21.834     0.150
     1.189    37.814     0.150
     1.215    21.304     0.150
     1.215    37.024     0.150
     1.228    39.052     0.150
     1.228    38.664     0.150
     1.218    21.199     0.150
     1.218    38.451     0.150
     1.259    21.874     0.150
     1.259    39.884     0.150
     1.259    22.044     0.150
     1.268    22.994     0.150
     1.268    39.994     0.150
     1.268    39.654     0.150
     1.268    39.887     0.150
     1.360    25.456     0.150
     1.264    23.784     0.150
     1.264    40.354     0.150
     1.399    23.764     0.150
     1.513    26.884     0.150
     1.610    27.704     0.150
     1.610    50.304     0.150
     1.672    29.164     0.150
     1.672    51.284     0.150
     1.688    29.754     0.150
     1.688    29.874     0.150
     1.688    53.924     0.150
     1.688    52.943     0.150
     1.732    30.534     0.150
     1.732    53.874     0.150
     1.732    30.084     0.150
     1.732    53.674     0.150
     1.758    30.414     0.150
     1.759    30.924     0.150
     1.759    30.794     0.150
     1.759    55.234     0.150
     1.757    30.624     0.150
     1.757    53.884     0.150
     1.757    30.438     0.150
     1.757    53.744     0.150
     1.789    31.204     0.150
     1.789    55.294     0.150
     1.793    30.864     0.150
     1.793    54.837     0.150
     1.880    32.211     0.150
     1.880    57.086     0.150
     1.903    32.044     0.150
     2.110    35.204     0.150
     2.122    36.124     0.150
     2.122    35.856     0.150
     2.147    35.744     0.150
     2.219    39.274     0.150
     2.222    37.314     0.150
     2.253    37.734     0.150
     2.253    66.150     0.150
     2.343    38.664     0.150
     2.343    38.544     0.150
     2.343    67.994     0.150
     2.343    68.248     0.150
     2.344    39.004     0.150
     2.384    39.104     0.150
     2.476    40.254     0.150
     2.488    40.824     0.150
     2.592    42.164     0.150
     2.634    42.054     0.150
     2.650    42.224     0.150
     2.650    42.617     0.150
     2.650    75.363     0.150
     2.750    44.284     0.150
     2.750    44.504     0.150
     2.750    78.404     0.150
     2.750    44.396     0.150
     2.750    78.147     0.150
     2.813    44.434     0.150
     2.813    44.547     0.150
     2.813    86.870     0.150
     2.886    46.394     0.150
     2.886    82.195     0.150
     2.970    92.014     0.150
     2.970    91.862     0.150
     3.030    48.544     0.150
     3.030    48.674     0.150
     3.030    95.394     0.150
     3.030    86.134     0.150
     3.114    48.454     0.150
     3.114    57.474     0.150
     3.118    50.104     0.150
     3.118    97.564     0.150
     3.210    51.194     0.150
     3.210    88.424     0.150
     3.210   101.914     0.150
     3.210    90.004     0.150
     3.241    88.944     0.150
     3.309    51.584     0.150
     3.309    91.044     0.150
     3.309   103.804     0.150
     3.309    51.754     0.150
     3.309    91.170     0.150
     3.335    60.134     0.150
     3.335    51.564     0.150
     3.335    90.554     0.150
     3.335    51.134     0.150
     3.335    91.344     0.150
     3.419    53.634     0.150
     3.419    94.228     0.150
     3.414    53.164     0.150
     3.414    53.826     0.150
     3.443    54.664     0.150
     3.511    55.614     0.150
     3.627    57.094     0.150
     3.627    56.974     0.150
     3.627    98.044     0.150
     3.782    58.824     0.150
     3.811    59.354     0.150
     3.811    59.734     0.150
     3.811   103.294     0.150
     3.811   119.004     0.150
     3.811   104.549     0.150
     3.846    60.174     0.150
     3.846    59.857     0.150
     3.868    60.124     0.150
     3.920    60.464     0.150
     3.920   105.494     0.150
     3.920   106.336     0.150
     4.068    62.124     0.150
     4.068    61.984     0.150
     4.068   126.624     0.150
     4.168    63.924     0.150
     4.168   112.937     0.150
     4.332   116.157     0.150
     4.378   115.994     0.150
     4.378   136.894     0.150
     4.373    67.034     0.150
     4.569    69.184     0.150
     4.662    71.184     0.150
     4.662   123.324     0.150
     4.662   146.114     0.150
     4.662    71.002     0.150
     4.669    71.804     0.150
     4.669    71.703     0.150
     4.669   125.442     0.150
     4.669   125.804     0.150
     4.669   146.584     0.150
     4.751    72.454     0.150
     4.872   150.794     0.150
     5.150   159.334     0.150
     5.249    79.174     0.150
     5.249    80.114     0.150
     5.279    80.384     0.150
     5.279    80.504     0.150
     5.279   140.104     0.150
     5.312    79.814     0.150
     5.312    80.554     0.150
     5.312   140.394     0.150
     5.432    81.024     0.150
     5.549    83.454     0.150
     5.549   173.454     0.150
     6.104    90.514     0.150
     6.104   157.474     0.150
     6.104   187.874     0.150
     6.104    90.286     0.150
     6.131    91.444     0.150
     6.131   190.034     0.150
     6.162    91.414     0.150
     6.162   193.044     0.150
     7.175   105.145     0.150
     0.465     8.172     0.150
     0.465    14.652     0.150
     0.479     8.520     0.150
     0.479    15.023     0.150
     0.479     8.533     0.150
     0.479    15.303     0.150
     0.476     8.572     0.150
     0.506     9.252     0.150
     0.506    16.354     0.150
     0.506    16.244     0.150
     0.676    12.713     0.150
     0.676    21.592     0.150
     0.712    13.203     0.150
     0.712    22.953     0.150
     0.712    23.152     0.150
     0.815    13.783     0.150
     0.815    24.873     0.150
     0.786    14.633     0.150
     0.786    24.877     0.150
     0.765    13.883     0.150
     0.867    15.604     0.150
     0.867    28.002     0.150
     0.867    27.889     0.150
     0.867    28.113     0.150
     0.919    17.643     0.150
     1.025    17.752     0.150
     1.025    31.662     0.150
     1.028    17.604     0.150
     1.028    31.615     0.150
     1.127    21.092     0.150
     1.090    19.973     0.150
     1.090    34.350     0.150
     1.211    20.953     0.150
     1.214    22.672     0.150
     1.214    21.777     0.150
     1.214    22.822     0.150
     1.215    21.262     0.150
     1.215    21.148     0.150
     1.215    38.213     0.150
     1.215    38.342     0.150
     1.332    23.973     0.150
     1.332    41.936     0.150
     1.422    25.383     0.150
     1.422    45.410     0.150
     1.422    25.562     0.150
     1.422    44.742     0.150
     1.464    24.613     0.150
     1.464    44.252     0.150
     1.500    26.932     0.150
     1.500    46.762     0.150
     1.615    27.492     0.150
     1.615    49.773     0.150
     1.591    29.193     0.150
     1.591    50.193     0.150
     1.591    50.035     0.150
     1.632    28.043     0.150
     1.646    27.104     0.150
     1.650    29.422     0.150
     1.773    29.246     0.150
     1.747    31.203     0.150
     1.828    32.262     0.150
     1.873    33.203     0.150
     1.879    33.758     0.150
     1.879    59.758     0.150
     1.945    33.162     0.150
     1.945    59.297     0.150
     1.880    33.273     0.150
     1.880    58.203     0.150
     2.055    35.922     0.150
     2.069    34.373     0.150
     2.090    37.043     0.150
     2.090    37.242     0.150
     2.090    67.486     0.150
     2.090    36.492     0.150
     2.090    65.613     0.150
     2.092    36.762     0.150
     2.092    65.041     0.150
     2.092    64.873     0.150
     2.132    36.992     0.150
     2.130    36.854     0.150
     2.130    64.473     0.150
     2.130    37.057     0.150
     2.130    66.148     0.150
     2.130    66.023     0.150
     2.236    39.012     0.150
     2.236    39.264     0.150
     2.236    69.879     0.150
     2.236    69.203     0.150
     2.311    38.793     0.150
     2.336    39.832     0.150
     2.325    39.213     0.150
     2.340    39.832     0.150
     2.340    41.414     0.150
     2.340    72.252     0.150
     2.477    41.342     0.150
     2.477    41.512     0.150
     2.538    42.133     0.150
     2.538    42.338     0.150
     2.538    74.078     0.150
     2.538    42.412     0.150
     2.533    42.883     0.150
     2.533    46.998     0.150
     2.533    43.203     0.150
     2.533    79.393     0.150
     2.560    42.053     0.150
     2.580    42.762     0.150
     2.580    43.590     0.150
     2.723    45.273     0.150
     2.723    45.576     0.150
     2.777    46.203     0.150
     2.777    45.604     0.150
     2.777    87.332     0.150
     2.852    46.883     0.150
     2.856    46.963     0.150
     2.809    86.094     0.150
     3.064    48.902     0.150
     3.008    49.623     0.150
     3.032    48.863     0.150
     3.032    49.113     0.150
     3.032    92.363     0.150
     3.065    50.193     0.150
     3.065    50.033     0.150
     3.065    95.773     0.150
     3.054    48.703     0.150
     3.054    49.119     0.150
     3.054    49.412     0.150
     3.054    95.113     0.150
     3.127    49.643     0.150
     3.170    50.012     0.150
     3.170    52.094     0.150
     3.280    52.982     0.150
     3.280    92.547     0.150
     3.259    51.992     0.150
     3.259    52.166     0.150
     3.259    51.713     0.150
     3.362    53.482     0.150
     3.362    52.840     0.150
     3.362    52.652     0.150
     3.362   103.693     0.150
     3.428    53.893     0.150
     3.443    52.604     0.150
     3.499    56.662     0.150
     3.499   108.533     0.150
     3.561    57.354     0.150
     3.561   111.662     0.150
     3.611    58.223     0.150
     3.611    57.930     0.150
     3.654    58.453     0.150
     3.654    58.260     0.150
     3.654   103.902     0.150
     3.736    58.592     0.150
     3.803    60.322     0.150
     3.936    60.822     0.150
     3.936    61.027     0.150
     4.022    63.242     0.150
     4.022    63.094     0.150
     3.978    62.172     0.150
     3.978   124.572     0.150
     4.121    64.582     0.150
     4.121    64.289     0.150
     4.342    67.135     0.150
     4.425    69.053     0.150
     4.425    69.420     0.150
     4.425   138.922     0.150
     4.453    68.553     0.150
     4.453    68.768     0.150
     4.474    69.096     0.150
     4.475    68.963     0.150
     4.491    68.893     0.150
     4.491    69.311     0.150
     4.449   119.412     0.150
     4.449   137.953     0.150
     4.740    72.354     0.150
     4.802    72.572     0.150
     4.988    76.393     0.150
     4.987    77.182     0.150
     4.987    77.604     0.150
     4.987   137.092     0.150
     5.035    77.123     0.150
     5.031    77.443     0.150
     5.031    77.662     0.150
     5.031   137.943     0.150
     5.045    77.854     0.150
     5.045   138.293     0.150
     5.167    80.473     0.150
     5.281    81.682     0.150
     5.281   143.232     0.150
     5.276    79.123     0.150
     5.310    80.762     0.150
     5.260   163.512     0.150
     5.369   169.123     0.150
     5.516    81.973     0.150
     5.516    81.842     0.150
     5.612    83.832     0.150
     5.607    85.693     0.150
     5.607   176.662     0.150
     5.706    84.252     0.150
     5.841    88.033     0.150
     5.894    89.604     0.150
     5.894   157.402     0.150
     5.894    89.893     0.150
     5.894   185.053     0.150
     5.932    88.082     0.150
     5.992    89.832     0.150
     5.956   183.322     0.150
     6.475   172.182     0.150
     6.547   173.633     0.150
     6.728    99.932     0.150
     6.745   100.963     0.150
     6.745   100.332     0.150
     6.777   100.332     0.150
     6.785   101.443     0.150
     6.930   103.613     0.150
     7.209   105.582     0.150
     7.287   107.822     0.150
     7.761   113.162     0.150
     7.997   118.223     0.150
     8.305   120.492     0.150
     0.374     7.161     0.150
     0.374    12.323     0.150
     0.374     7.173     0.150
     0.374    12.562     0.150
     0.493     9.190     0.150
     0.493    15.785     0.150
     0.493    16.373     0.150
     0.554    10.208     0.150
     0.554    17.418     0.150
     0.554    17.553     0.150
     0.622    12.083     0.150
     0.622    20.593     0.150
     0.768    14.583     0.150
     0.768    24.812     0.150
     0.824    14.232     0.150
     0.824    25.753     0.150
     0.944    16.363     0.150
     0.936    17.740     0.150
     0.936    30.172     0.150
     0.936    29.973     0.150
     1.078    19.562     0.150
     1.078    33.747     0.150
     1.084    19.274     0.150
     1.084    34.046     0.150
     1.084    33.213     0.150
     1.158    20.423     0.150
     1.158    34.603     0.150
     1.161    20.517     0.150
     1.161    36.398     0.150
     1.199    21.869     0.150
     1.199    38.627     0.150
     1.199    37.973     0.150
     1.182    21.596     0.150
     1.182    37.769     0.150
     1.182    21.703     0.150
     1.182    37.663     0.150
     1.209    20.683     0.150
     1.209    36.652     0.150
     1.319    24.598     0.150
     1.319    42.332     0.150
     1.319    24.713     0.150
     1.319    41.713     0.150
     1.240    23.423     0.150
     1.240    38.843     0.150
     1.298    23.673     0.150
     1.298    41.339     0.150
     1.298    40.583     0.150
     1.559    26.593     0.150
     1.559    47.203     0.150
     1.628    29.087     0.150
     1.628    51.213     0.150
     1.628    29.383     0.150
     1.628    50.583     0.150
     1.698    30.543     0.150
     1.698    52.873     0.150
     1.734    30.263     0.150
     1.734    53.583     0.150
     1.735    30.027     0.150
     1.735    53.794     0.150
     1.735    30.873     0.150
     1.735    53.673     0.150
     1.800    31.633     0.150
     1.800    55.887     0.150
     1.835    31.521     0.150
     1.835    56.283     0.150
     2.068    35.193     0.150
     2.068    62.452     0.150
     2.243    66.361     0.150
     2.261    70.083     0.150
     2.296    38.206     0.150
     2.296    40.683     0.150
     2.297    38.679     0.150
     2.297    66.891     0.150
     2.297    66.743     0.150
     2.357    39.303     0.150
     2.357    69.183     0.150
     2.357    68.933     0.150
     2.427    40.303     0.150
     2.606    42.015     0.150
     2.606    74.331     0.150
     2.715    43.753     0.150
     2.715    44.272     0.150
     2.715    77.383     0.150
     2.715    85.692     0.150
     2.753    44.091     0.150
     2.834    45.622     0.150
     2.908    90.583     0.150
     2.982    48.232     0.150
     2.982    92.783     0.150
     2.982    48.493     0.150
     2.982    82.883     0.150
     2.982    93.343     0.150
     3.006    46.916     0.150
     3.006    93.204     0.150
     3.006    46.533     0.150
     3.006    93.643     0.150
     3.057    94.978     0.150
     3.057    48.843     0.150
     3.057    95.163     0.150
     3.194    89.003     0.150
     3.194    88.293     0.150
     3.317    52.223     0.150
     3.317    91.828     0.150
     3.317    92.283     0.150
     3.317   102.393     0.150
     3.370    52.759     0.150
     3.370    93.427     0.150
     3.765    59.177     0.150
     3.765    59.353     0.150
     3.765   101.732     0.150
     3.765   117.652     0.150
     3.866    60.060     0.150
     3.866    60.163     0.150
     3.866   103.933     0.150
     3.909   121.942     0.150
     4.008    61.533     0.150
     4.008   124.553     0.150
     4.412   135.293     0.150
     4.625    71.170     0.150
     4.625    71.363     0.150
     4.625   123.402     0.150
     4.625   145.503     0.150
     4.919   154.203     0.150
     5.233    80.223     0.150
     5.233   138.603     0.150
     5.257    79.973     0.150
     5.257   139.323     0.150
     5.491   170.833     0.150
     6.051   157.053     0.150
     6.051   189.123     0.150
     6.089   158.312     0.150
     6.089   190.343     0.150
     6.105   190.643     0.150
     7.131   182.723     0.150
     0.255     4.469     0.150
     0.255     8.246     0.150
     0.255     4.475     0.150
     0.255     8.152     0.150
     0.503     9.844     0.150
     0.503    16.555     0.150
     0.553    10.020     0.150
     0.553    16.711     0.150
     0.553    17.062     0.150
     0.612    10.734     0.150
     0.612    19.305     0.150
     0.612    19.082     0.150
     0.881    15.164     0.150
     0.881    27.594     0.150
     0.886    16.145     0.150
     0.886    28.652     0.150
     1.034    18.922     0.150
     1.034    32.422     0.150
     1.034    19.152     0.150
     1.034    33.082     0.150
     1.095    19.324     0.150
     1.095    34.473     0.150
     1.097    34.129     0.150
     1.103    19.812     0.150
     1.103    34.570     0.150
     1.103    34.883     0.150
     1.121    19.445     0.150
     1.121    35.016     0.150
     1.170    20.621     0.150
     1.170    36.754     0.150
     1.392    25.535     0.150
     1.392    44.328     0.150
     1.392    44.516     0.150
     1.296    23.488     0.150
     1.296    41.488     0.150
     1.296    40.383     0.150
     1.340    24.824     0.150
     1.340    42.605     0.150
     1.412    25.492     0.150
     1.412    45.062     0.150
     1.412    25.703     0.150
     1.412    44.684     0.150
     1.473    25.414     0.150
     1.473    44.594     0.150
     1.630    29.133     0.150
     1.630    29.332     0.150
     1.630    52.293     0.150
     1.660    29.152     0.150
     1.660    52.016     0.150
     1.688    30.164     0.150
     1.688    53.695     0.150
     1.736    30.434     0.150
     1.837    32.938     0.150
     1.837    57.031     0.150
     1.837    33.523     0.150
     1.837    57.605     0.150
     1.919    33.922     0.150
     2.297    39.918     0.150
     2.297    72.613     0.150
     2.297    72.035     0.150
     2.363    74.488     0.150
     2.354    40.258     0.150
     2.354    70.180     0.150
     2.354    40.785     0.150
     2.354    71.266     0.150
     2.354    40.746     0.150
     2.354    70.488     0.150
     2.354    40.922     0.150
     2.354    71.445     0.150
     2.404    41.324     0.150
     2.404    41.516     0.150
     2.476    41.484     0.150
     2.476    73.707     0.150
     2.476    42.113     0.150
     2.476    74.734     0.150
     2.507    41.348     0.150
     2.507    74.094     0.150
     2.711    45.207     0.150
     2.711    79.531     0.150
     2.752    45.699     0.150
     2.797    88.176     0.150
     2.797    47.152     0.150
     2.797    87.734     0.150
     3.038    87.148     0.150
     3.038    50.562     0.150
     3.038    87.863     0.150
     3.038    96.055     0.150
     3.048    49.383     0.150
     3.279    52.363     0.150
     3.279   100.242     0.150
     3.302    53.133     0.150
     3.302    94.395     0.150
     3.436    55.004     0.150
     3.436    96.043     0.150
     3.823    61.703     0.150
     3.823   105.516     0.150
     3.885   108.703     0.150
     3.899    61.664     0.150
     3.899   107.695     0.150
     4.006    63.094     0.150
     4.006   109.922     0.150
     4.523   122.016     0.150
     4.689    73.953     0.150
     4.689   127.082     0.150
     5.239   141.973     0.150
     5.284    81.203     0.150
     5.284   143.863     0.150
     5.293    81.684     0.150
     5.293   144.242     0.150
     6.091    92.074     0.150
     6.091   160.652     0.150
     6.798   178.805     0.150
     7.194   107.062     0.150
     7.194   186.965     0.150
     0.425     7.594     0.150
     0.425    13.023     0.150
     0.433     7.680     0.150
     0.433    13.688     0.150
     0.433     7.812     0.150
     0.433    14.281     0.150
     0.460     8.516     0.150
     0.460    14.766     0.150
     0.696    13.180     0.150
     0.763    14.125     0.150
     0.763    24.766     0.150
     0.939    16.359     0.150
     0.939    30.375     0.150
     0.955    16.789     0.150
     0.955    30.047     0.150
     0.994    18.539     0.150
     0.994    31.883     0.150
     0.994    31.234     0.150
     1.085    18.539     0.150
     1.190    21.594     0.150
     1.190    37.617     0.150
     1.219    22.133     0.150
     1.219    38.906     0.150
     1.219    22.320     0.150
     1.219    38.453     0.150
     1.210    21.984     0.150
     1.210    38.328     0.150
     1.210    22.203     0.150
     1.282    23.180     0.150
     1.282    42.125     0.150
     1.282    22.781     0.150
     1.299    22.383     0.150
     1.299    40.953     0.150
     1.302    22.078     0.150
     1.302    41.305     0.150
     1.410    26.008     0.150
     1.410    44.906     0.150
     1.410    26.133     0.150
     1.336    23.445     0.150
     1.336    41.703     0.150
     1.688    28.875     0.150
     1.688    52.445     0.150
     1.768    32.156     0.150
     1.768    54.680     0.150
     1.768    31.961     0.150
     1.768    54.875     0.150
     1.773    30.898     0.150
     1.773    55.328     0.150
     1.778    32.578     0.150
     1.778    55.773     0.150
     1.778    55.891     0.150
     1.842    32.930     0.150
     1.842    57.359     0.150
     1.871    32.859     0.150
     1.871    59.422     0.150
     2.204    38.156     0.150
     2.204    68.789     0.150
     2.204    38.273     0.150
     2.204    68.391     0.150
     2.312    38.891     0.150
     2.312    68.344     0.150
     2.312    69.125     0.150
     2.402    40.688     0.150
     2.402    41.125     0.150
     2.402    71.820     0.150
     2.572    43.875     0.150
     2.572    79.359     0.150
     2.690    44.320     0.150
     2.721    44.336     0.150
     2.721    78.883     0.150
     2.776    46.133     0.150
     2.790    45.797     0.150
     2.790    86.898     0.150
     2.790    46.141     0.150
     2.790    86.742     0.150
     2.910    82.430     0.150
     2.910    90.320     0.150
     2.966    91.555     0.150
     3.087    50.766     0.150
     3.087    96.766     0.150
     3.290   101.102     0.150
     3.290    92.719     0.150
     3.290   101.664     0.150
     3.287    52.250     0.150
     3.287   102.039     0.150
     3.867    61.359     0.150
     3.867   107.266     0.150
     3.867   121.484     0.150
     3.988    62.836     0.150
     4.148   128.680     0.150
     4.321   133.266     0.150
     4.721    73.883     0.150
     4.721   128.141     0.150
     4.721   147.211     0.150
     4.798   148.492     0.150
     5.334    82.695     0.150
     5.334   144.930     0.150
     5.383    82.859     0.150
     5.383   146.555     0.150
     6.169   161.734     0.150
     6.178    94.109     0.150
     0.247     4.797     0.150
     0.247     8.320     0.150
     0.275     5.320     0.150
     0.275     9.414     0.150
     0.481    10.008     0.150
     0.485     9.320     0.150
     0.485    16.312     0.150
     0.585    10.938     0.150
     0.585    19.531     0.150
     0.585    10.922     0.150
     0.585    19.312     0.150
     0.769    13.656     0.150
     0.769    24.539     0.150
     0.769    23.984     0.150
     0.769    23.719     0.150
     0.799    15.047     0.150
     0.799    25.438     0.150
     0.847    16.102     0.150
     0.847    28.719     0.150
     0.847    28.281     0.150
     1.105    20.672     0.150
     1.105    35.539     0.150
     1.120    20.352     0.150
     1.120    20.461     0.150
     1.120    35.773     0.150
     1.120    35.977     0.150
     1.127    19.922     0.150
     1.127    35.758     0.150
     1.127    20.031     0.150
     1.127    35.648     0.150
     1.228    22.578     0.150
     1.228    39.180     0.150
     1.228    38.945     0.150
     1.228    38.797     0.150
     1.297    22.680     0.150
     1.297    40.547     0.150
     1.297    40.125     0.150
     1.409    25.141     0.150
     1.409    44.383     0.150
     1.409    25.312     0.150
     1.409    44.789     0.150
     1.429    25.477     0.150
     1.429    44.820     0.150
     1.429    45.086     0.150
     1.556    28.969     0.150
     1.486    25.680     0.150
     1.486    45.352     0.150
     1.486    25.422     0.150
     1.486    44.836     0.150
     1.511    26.180     0.150
     1.511    47.695     0.150
     1.511    26.336     0.150
     1.514    26.398     0.150
     1.514    47.438     0.150
     1.533    26.367     0.150
     1.533    47.352     0.150
     1.577    27.312     0.150
     1.693    29.711     0.150
     1.733    29.578     0.150
     1.733    53.312     0.150
     1.741    29.836     0.150
     1.748    30.812     0.150
     1.748    30.922     0.150
     1.748    54.078     0.150
     1.854    32.281     0.150
     1.854    32.617     0.150
     1.854    57.797     0.150
     1.869    32.195     0.150
     1.869    57.031     0.150
     1.887    32.047     0.150
     1.887    32.562     0.150
     1.887    57.820     0.150
     1.926    32.477     0.150
     1.926    57.617     0.150
     1.975    35.266     0.150
     1.975    61.758     0.150
     1.975    34.391     0.150
     1.975    60.867     0.150
     1.991    34.625     0.150
     1.991    34.969     0.150
     1.991    60.930     0.150
     2.015    34.047     0.150
     2.054    35.406     0.150
     2.077    35.211     0.150
     2.077    63.258     0.150
     2.116    36.039     0.150
     2.133    63.242     0.150
     2.156    35.789     0.150
     2.255    37.961     0.150
     2.255    37.844     0.150
     2.255    37.000     0.150
     2.411    40.195     0.150
     2.411    40.562     0.150
     2.411    72.367     0.150
     2.474    39.867     0.150
     2.474    39.211     0.150
     2.500    41.078     0.150
     2.561    42.086     0.150
     2.561    47.391     0.150
     2.561    80.422     0.150
     2.581    42.492     0.150
     2.581    41.562     0.150
     2.581    78.656     0.150
     2.651    42.922     0.150
     2.758    44.125     0.150
     2.771    44.039     0.150
     2.771    85.500     0.150
     2.787    48.508     0.150
     2.803    44.688     0.150
     2.860    45.656     0.150
     2.901    46.406     0.150
     2.902    46.742     0.150
     2.905    53.789     0.150
     2.905    90.867     0.150
     2.958    46.812     0.150
     3.190    49.477     0.150
     3.190    97.867     0.150
     3.245    51.117     0.150
     3.245    52.039     0.150
     3.245   101.031     0.150
     3.247    50.672     0.150
     3.247    51.219     0.150
     3.247   100.430     0.150
     3.260    51.117     0.150
     3.260    52.070     0.150
     3.260    52.297     0.150
     3.406    52.797     0.150
     3.422    53.562     0.150
     3.685    57.180     0.150
     4.019    62.547     0.150
     4.169    65.227     0.150
     4.169    64.469     0.150
     4.169   113.312     0.150
     4.185   128.477     0.150
     4.436    66.750     0.150
     4.616    69.000     0.150
     4.675    70.727     0.150
     4.675    71.438     0.150
     4.861    74.945     0.150
     4.861   152.117     0.150
     4.971    73.836     0.150
     5.130    76.320     0.150
     5.481    83.500     0.150
     5.481   169.516     0.150
     5.920    87.336     0.150
     0.522     8.969     0.150
     0.522    15.641     0.150
     0.522    15.984     0.150
     0.532    17.906     0.150
     0.594    10.570     0.150
     0.594    18.820     0.150
     0.594    18.617     0.150
     0.656    11.883     0.150
     0.656    21.102     0.150
     0.842    15.609     0.150
     0.842    27.328     0.150
     0.950    17.719     0.150
     0.950    30.086     0.150
     0.950    17.828     0.150
     0.950    30.492     0.150
     0.993    17.953     0.150
     0.993    31.102     0.150
     0.993    18.055     0.150
     0.993    31.336     0.150
     1.023    17.172     0.150
     1.026    17.203     0.150
     1.026    30.477     0.150
     1.094    19.383     0.150
     1.094    20.219     0.150
     1.094    35.797     0.150
     1.290    24.008     0.150
     1.290    41.656     0.150
     1.290    41.328     0.150
     1.220    21.461     0.150
     1.220    37.945     0.150
     1.238    22.977     0.150
     1.238    39.273     0.150
     1.425    48.148     0.150
     1.413    43.469     0.150
     1.523    27.445     0.150
     1.523    48.117     0.150
     1.599    27.008     0.150
     1.585    28.125     0.150
     1.756    32.523     0.150
     1.756    56.742     0.150
     1.756    32.648     0.150
     1.756    55.414     0.150
     1.932    34.281     0.150
     1.932    60.320     0.150
     1.932    33.953     0.150
     1.879    32.898     0.150
     1.879    58.883     0.150
     2.246    39.062     0.150
     2.246    38.914     0.150
     2.246    69.992     0.150
     2.306    40.016     0.150
     2.306    72.922     0.150
     2.306    40.477     0.150
     2.306    71.453     0.150
     2.287    40.125     0.150
     2.287    70.750     0.150
     2.287    39.672     0.150
     2.476    41.594     0.150
     2.476    73.016     0.150
     2.447    41.695     0.150
     2.447    75.000     0.150
     2.447    40.297     0.150
     2.447    74.289     0.150
     2.699    46.086     0.150
     2.698    45.555     0.150
     2.698    49.859     0.150
     2.698    84.766     0.150
     2.930    48.609     0.150
     2.930    91.859     0.150
     3.227   101.328     0.150
     3.715    59.414     0.150
     3.715   116.617     0.150
     4.583    72.328     0.150
     4.583    85.914     0.150
     4.583   142.984     0.150
     5.185   159.812     0.150
     6.054   187.914     0.150
     0.345     6.562     0.150
     0.345    11.801     0.150
     0.371     7.230     0.150
     0.371    12.754     0.150
     0.371     7.250     0.150
     0.371    12.672     0.150
     0.550     9.660     0.150
     0.550    16.910     0.150
     0.550    17.320     0.150
     0.527     9.480     0.150
     0.527     9.590     0.150
     0.527    16.777     0.150
     0.597    11.672     0.150
     0.642    11.609     0.150
     0.642    11.742     0.150
     0.642    20.164     0.150
     0.763    12.652     0.150
     0.777    14.551     0.150
     0.777    25.422     0.150
     0.777    25.102     0.150
     0.788    15.109     0.150
     0.788    27.449     0.150
     0.859    14.180     0.150
     0.859    14.359     0.150
     0.853    15.062     0.150
     0.853    27.750     0.150
     0.901    16.949     0.150
     0.901    29.191     0.150
     0.993    18.000     0.150
     0.993    31.520     0.150
     0.993    31.230     0.150
     0.993    31.402     0.150
     1.073    18.109     0.150
     1.075    18.117     0.150
     1.075    32.680     0.150
     1.136    18.902     0.150
     1.259    23.500     0.150
     1.259    39.980     0.150
     1.259    40.750     0.150
     1.161    21.371     0.150
     1.161    36.875     0.150
     1.165    20.512     0.150
     1.209    22.621     0.150
     1.209    38.500     0.150
     1.235    21.660     0.150
     1.376    23.512     0.150
     1.347    23.922     0.150
     1.347    42.547     0.150
     1.425    25.461     0.150
     1.441    25.742     0.150
     1.484    24.891     0.150
     1.527    25.289     0.150
     1.537    27.430     0.150
     1.537    48.262     0.150
     1.537    27.531     0.150
     1.606    28.430     0.150
     1.606    50.359     0.150
     1.606    28.020     0.150
     1.603    27.840     0.150
     1.646    28.070     0.150
     1.653    27.742     0.150
     1.653    49.902     0.150
     1.705    30.359     0.150
     1.705    52.969     0.150
     1.705    29.902     0.150
     1.705    53.109     0.150
     1.770    29.500     0.150
     1.770    54.570     0.150
     1.794    29.730     0.150
     1.802    31.199     0.150
     1.815    31.270     0.150
     1.815    56.133     0.150
     1.815    55.832     0.150
     1.830    31.840     0.150
     1.830    31.543     0.150
     1.836    31.660     0.150
     1.852    32.320     0.150
     1.852    31.520     0.150
     1.852    56.414     0.150
     1.852    31.301     0.150
     1.985    33.949     0.150
     1.985    33.836     0.150
     1.985    62.469     0.150
     2.083    35.391     0.150
     2.094    34.801     0.150
     2.161    36.160     0.150
     2.226    38.031     0.150
     2.226    37.680     0.150
     2.226    65.973     0.150
     2.226    37.859     0.150
     2.230    37.750     0.150
     2.230    66.496     0.150
     2.230    37.859     0.150
     2.303    38.191     0.150
     2.334    39.430     0.150
     2.334    39.062     0.150
     2.334    39.250     0.150
     2.344    38.770     0.150
     2.327    38.512     0.150
     2.327    38.332     0.150
     2.327    67.871     0.150
     2.381    39.359     0.150
     2.381    39.180     0.150
     2.381    70.445     0.150
     2.381    69.852     0.150
     2.423    39.512     0.150
     2.423    39.340     0.150
     2.423    70.457     0.150
     2.508    40.812     0.150
     2.540    41.340     0.150
     2.540    41.023     0.150
     2.540    73.805     0.150
     2.541    40.980     0.150
     2.661    43.211     0.150
     2.661    42.918     0.150
     2.661    82.535     0.150
     2.663    43.910     0.150
     2.663    43.578     0.150
     2.663    83.547     0.150
     2.663    43.770     0.150
     2.663    48.922     0.150
     2.663    83.391     0.150
     2.744    44.582     0.150
     2.755    44.883     0.150
     2.755    44.520     0.150
     2.755    44.633     0.150
     2.747    84.543     0.150
     2.911    47.141     0.150
     2.911    47.484     0.150
     2.911    90.852     0.150
     2.911    47.652     0.150
     2.911    53.512     0.150
     2.911    91.199     0.150
     2.961    47.602     0.150
     2.965    47.281     0.150
     2.965    47.070     0.150
     2.965    91.918     0.150
     2.926    46.883     0.150
     2.926    47.297     0.150
     2.988    46.133     0.150
     2.988    45.852     0.150
     3.043    47.781     0.150
     3.043    47.598     0.150
     3.043    93.391     0.150
     3.062    47.789     0.150
     3.062    84.977     0.150
     3.062    47.422     0.150
     3.173    51.242     0.150
     3.173    98.980     0.150
     3.173    51.062     0.150
     3.173    58.391     0.150
     3.173    98.691     0.150
     3.260    52.289     0.150
     3.260    52.172     0.150
     3.260    92.574     0.150
     3.260    52.051     0.150
     3.298    51.910     0.150
     3.298    91.891     0.150
     3.331    52.391     0.150
     3.331    52.496     0.150
     3.317    51.660     0.150
     3.317    92.223     0.150
     3.371    52.109     0.150
     3.371    51.539     0.150
     3.414    53.109     0.150
     3.415    51.410     0.150
     3.399    52.609     0.150
     3.399    52.484     0.150
     3.399   105.707     0.150
     3.399    52.262     0.150
     3.601    99.613     0.150
     3.649    57.000     0.150
     3.649    57.293     0.150
     3.695    58.602     0.150
     3.695    58.734     0.150
     3.695   102.164     0.150
     3.726    57.070     0.150
     3.726    57.457     0.150
     3.784    59.391     0.150
     3.784   104.145     0.150
     3.866    59.719     0.150
     3.896    59.141     0.150
     3.917    60.531     0.150
     3.917    60.742     0.150
     3.917   120.469     0.150
     3.959    60.602     0.150
     3.959    60.371     0.150
     3.952    61.410     0.150
     3.952    60.660     0.150
     3.952    60.812     0.150
     3.973    60.633     0.150
     3.973    60.492     0.150
     3.973   108.070     0.150
     3.973    60.191     0.150
     4.044    62.352     0.150
     4.044    62.078     0.150
     4.044   110.422     0.150
     4.211    64.180     0.150
     4.220    64.609     0.150
     4.220    64.973     0.150
     4.223    65.633     0.150
     4.223    65.742     0.150
     4.330    65.840     0.150
     4.458    66.723     0.150
     4.458    67.715     0.150
     4.492    68.070     0.150
     4.492    67.598     0.150
     4.465    67.312     0.150
     4.465    67.211     0.150
     4.465   118.512     0.150
     4.515    68.180     0.150
     4.515    68.352     0.150
     4.552    69.641     0.150
     4.552    69.871     0.150
     4.559    70.473     0.150
     4.559    70.297     0.150
     4.598    70.020     0.150
     4.598    70.125     0.150
     4.621    70.340     0.150
     4.621    70.105     0.150
     4.754    71.570     0.150
     4.810    72.609     0.150
     4.810    72.746     0.150
     4.962    74.816     0.150
     4.992    75.035     0.150
     5.029    74.602     0.150
     5.083    76.820     0.150
     5.083    76.230     0.150
     5.119    77.480     0.150
     5.119    77.961     0.150
     5.119   137.672     0.150
     5.165    79.152     0.150
     5.165    78.668     0.150
     5.165    78.961     0.150
     5.173    78.223     0.150
     5.173    77.945     0.150
     5.173    78.102     0.150
     5.280    79.770     0.150
     5.280    79.535     0.150
     5.280    79.891     0.150
     5.255    77.551     0.150
     5.255    78.484     0.150
     5.305    79.402     0.150
     5.305    79.113     0.150
     5.403    81.801     0.150
     5.403    81.375     0.150
     5.403    80.633     0.150
     5.537    83.762     0.150
     5.551    82.840     0.150
     5.551    83.605     0.150
     5.604    81.652     0.150
     5.604    82.730     0.150
     5.888    85.133     0.150
     5.889    86.762     0.150
     5.973    89.082     0.150
     5.973    88.812     0.150
     5.973   154.871     0.150
     6.004    89.262     0.150
     6.004    88.746     0.150
     6.017    89.648     0.150
     6.075    90.652     0.150
     6.141    89.473     0.150
     6.248    93.359     0.150
     6.535    97.070     0.150
     6.606    98.527     0.150
     6.667    99.562     0.150
     6.679    97.801     0.150
     6.736    99.500     0.150
     6.736    98.980     0.150
     6.857   100.430     0.150
     6.879   101.422     0.150
     6.879   101.086     0.150
     6.928   102.332     0.150
     6.951   101.758     0.150
     7.065   103.371     0.150
     7.065   103.758     0.150
     7.065   103.871     0.150
     7.103   104.039     0.150
     7.140   104.250     0.150
     7.140   103.633     0.150
     7.181   104.449     0.150
     7.240   105.742     0.150
     7.240   105.898     0.150
     7.316   107.102     0.150
     7.316   107.695     0.150
     7.331   106.812     0.150
     7.331   107.102     0.150
     7.483   110.039     0.150
     7.487   109.531     0.150
     7.487   109.688     0.150
     7.581   110.871     0.150
     7.581   110.656     0.150
     7.684   113.336     0.150
     7.684   113.121     0.150
     7.738   110.750     0.150
     7.783   114.121     0.150
     7.783   114.422     0.150
     7.807   113.031     0.150
     7.807   114.219     0.150
     8.102   118.492     0.150
     8.102   119.594     0.150
     8.123   118.332     0.150
     8.342   120.801     0.150
     8.345   119.781     0.150
     8.345   121.547     0.150
     8.550   125.340     0.150
     8.558   124.164     0.150
     8.699   127.359     0.150
     8.699   127.621     0.150
     8.759   126.000     0.150
     8.911   129.859     0.150
     9.001   129.910     0.150
     9.239   132.137     0.150
     9.394   135.949     0.150
     0.136     3.381     0.150
     0.136     6.011     0.150
     0.307     5.938     0.150
     0.307     9.828     0.150
     0.463     8.898     0.150
     0.463    14.977     0.150
     0.489     9.900     0.150
     0.515     9.860     0.150
     0.515    16.931     0.150
     0.515    17.060     0.150
     0.898    16.201     0.150
     0.898    27.970     0.150
     0.894    15.911     0.150
     0.894    15.802     0.150
     0.894    27.813     0.150
     1.002    18.061     0.150
     1.092    20.411     0.150
     1.092    35.064     0.150
     1.177    21.190     0.150
     1.218    21.841     0.150
     1.218    38.695     0.150
     1.259    23.041     0.150
     1.259    22.841     0.150
     1.259    39.908     0.150
     1.310    23.741     0.150
     1.310    23.599     0.150
     1.310    41.665     0.150
     1.329    24.014     0.150
     1.329    41.503     0.150
     1.391    24.921     0.150
     1.393    24.553     0.150
     1.393    43.573     0.150
     1.408    24.331     0.150
     1.520    28.261     0.150
     1.608    28.480     0.150
     1.608    27.911     0.150
     1.608    49.393     0.150
     1.751    30.471     0.150
     1.803    30.811     0.150
     1.814    31.440     0.150
     1.814    55.366     0.150
     1.884    32.413     0.150
     1.864    31.900     0.150
     1.864    32.275     0.150
     1.864    56.551     0.150
     1.969    33.294     0.150
     2.008    33.701     0.150
     2.008    60.731     0.150
     2.031    34.190     0.150
     2.111    35.221     0.150
     2.111    35.569     0.150
     2.111    62.900     0.150
     2.205    36.241     0.150
     2.216    36.271     0.150
     2.287    37.511     0.150
     2.287    38.387     0.150
     2.287    67.159     0.150
     2.326    38.791     0.150
     2.326    68.203     0.150
     2.375    39.230     0.150
     2.336    38.791     0.150
     2.336    68.498     0.150
     2.473    40.211     0.150
     2.540    40.451     0.150
     2.540    41.001     0.150
     2.516    41.091     0.150
     2.516    41.474     0.150
     2.516    72.588     0.150
     2.591    41.440     0.150
     2.591    41.623     0.150
     2.591    79.301     0.150
     2.633    42.431     0.150
     2.684    43.721     0.150
     2.683    42.281     0.150
     2.683    43.351     0.150
     2.683    83.208     0.150
     2.777    44.014     0.150
     2.777    78.678     0.150
     2.892    45.811     0.150
     2.892    46.601     0.150
     2.885    45.431     0.150
     2.885    45.271     0.150
     2.885    89.175     0.150
     3.002    46.771     0.150
     3.002    47.471     0.150
     3.002    84.784     0.150
     3.042    48.411     0.150
     3.042    48.647     0.150
     3.042    85.444     0.150
     3.026    47.841     0.150
     3.026    93.119     0.150
     3.201    50.982     0.150
     3.231    50.519     0.150
     3.311    51.171     0.150
     3.315    51.001     0.150
     3.315    51.431     0.150
     3.292    52.301     0.150
     3.292    52.536     0.150
     3.292    91.388     0.150
     3.290    50.771     0.150
     3.290    50.535     0.150
     3.290   100.684     0.150
     3.321    51.961     0.150
     3.321   102.126     0.150
     3.560    54.951     0.150
     3.560    55.122     0.150
     3.544    55.860     0.150
     3.544   108.903     0.150
     3.617    56.381     0.150
     3.607    55.121     0.150
     3.633    56.150     0.150
     3.695    57.841     0.150
     3.695    58.002     0.150
     3.763    57.841     0.150
     3.763    57.951     0.150
     3.936    59.761     0.150
     3.936    60.936     0.150
     3.941    60.320     0.150
     3.941    61.845     0.150
     3.941   108.382     0.150
     3.980    62.491     0.150
     3.980    62.181     0.150
     3.991    62.841     0.150
     4.037    61.110     0.150
     4.106    63.601     0.150
     4.106    63.304     0.150
     4.265    64.860     0.150
     4.265    64.662     0.150
     4.311    65.440     0.150
     4.298    65.021     0.150
     4.298    64.733     0.150
     4.533    68.897     0.150
     4.568    68.900     0.150
     4.568    70.305     0.150
     4.582    68.891     0.150
     4.749    70.961     0.150
     4.741    71.021     0.150
     4.811    72.691     0.150
     4.831    73.751     0.150
     4.831    74.303     0.150
     4.892    73.791     0.150
     4.935    75.440     0.150
     4.948    74.131     0.150
     4.948    74.425     0.150
     5.241    79.501     0.150
     5.446    82.721     0.150
     5.446    82.891     0.150
     5.501    82.604     0.150
     5.629    83.999     0.150
     6.286    93.092     0.150
     6.285    92.320     0.150
     6.285    93.501     0.150
     7.193   104.151     0.150
     7.173   105.128     0.150
     7.353   106.990     0.150
     7.337   106.511     0.150
     7.337   107.646     0.150
     7.438   108.641     0.150
     7.825   113.536     0.150
     8.108   118.079     0.150
     8.667   126.333     0.150
     0.391     7.262     0.150
     0.391    12.805     0.150
     0.428     7.762     0.150
     0.428    13.609     0.150
     0.496     9.160     0.150
     0.496    16.047     0.150
     0.767    13.535     0.150
     0.767    23.766     0.150
     1.015    19.047     0.150
     1.015    32.219     0.150
     0.992    17.348     0.150
     1.204    21.371     0.150
     1.204    37.984     0.150
     1.222    21.988     0.150
     1.222    38.754     0.150
     1.240    22.785     0.150
     1.261    22.902     0.150
     1.261    40.023     0.150
     1.270    21.781     0.150
     1.270    40.234     0.150
     1.421    26.309     0.150
     1.421    45.391     0.150
     1.699    29.688     0.150
     1.699    52.809     0.150
     1.755    31.668     0.150
     1.755    54.375     0.150
     1.803    32.410     0.150
     1.811    31.734     0.150
     1.811    55.965     0.150
     1.912    32.938     0.150
     1.912    58.641     0.150
     2.170    36.711     0.150
     2.170    67.703     0.150
     2.192    65.910     0.150
     2.289    38.984     0.150
     2.352    39.395     0.150
     2.352    69.223     0.150
     2.409    40.535     0.150
     2.552    42.418     0.150
     2.682    43.793     0.150
     2.682    78.094     0.150
     2.718    44.406     0.150
     2.718    84.340     0.150
     2.807    45.539     0.150
     2.930    47.043     0.150
     2.930    84.492     0.150
     2.952    91.816     0.150
     3.094    49.641     0.150
     3.094    95.918     0.150
     3.325   102.520     0.150
     3.332   102.402     0.150
     3.457    54.246     0.150
     3.457    96.492     0.150
     3.875    61.762     0.150
     3.875   106.531     0.150
     3.987    62.562     0.150
     4.731    73.551     0.150
     5.343    82.512     0.150
     0.302     5.948     0.150
     0.302     9.599     0.150
     0.302     9.705     0.150
     0.471     8.906     0.150
     0.471    15.295     0.150
     0.471     8.858     0.150
     0.471    15.469     0.150
     0.513     9.599     0.150
     0.513    17.039     0.150
     0.513     9.777     0.150
     0.734    13.759     0.150
     0.734    23.869     0.150
     0.827    15.499     0.150
     0.827    26.479     0.150
     0.885    15.639     0.150
     0.885    27.595     0.150
     0.906    16.448     0.150
     0.906    28.238     0.150
     1.011    17.849     0.150
     1.011    32.278     0.150
     1.051    19.009     0.150
     1.051    33.499     0.150
     1.094    20.408     0.150
     1.094    35.079     0.150
     1.186    20.979     0.150
     1.186    36.339     0.150
     1.211    21.738     0.150
     1.211    38.349     0.150
     1.211    21.871     0.150
     1.211    38.639     0.150
     1.257    22.908     0.150
     1.257    39.849     0.150
     1.257    22.799     0.150
     1.318    23.459     0.150
     1.318    41.479     0.150
     1.335    24.329     0.150
     1.335    41.448     0.150
     1.335    23.994     0.150
     1.381    25.528     0.150
     1.381    44.198     0.150
     1.400    24.988     0.150
     1.400    43.379     0.150
     1.402    24.921     0.150
     1.402    43.416     0.150
     1.417    24.099     0.150
     1.415    44.479     0.150
     1.523    28.429     0.150
     1.600    27.929     0.150
     1.600    48.669     0.150
     1.600    27.208     0.150
     1.600    49.067     0.150
     1.771    29.839     0.150
     1.771    53.369     0.150
     1.810    31.419     0.150
     1.810    55.488     0.150
     1.810    31.563     0.150
     1.827    30.599     0.150
     1.827    55.318     0.150
     1.864    32.219     0.150
     1.864    56.729     0.150
     1.864    32.389     0.150
     1.864    57.030     0.150
     1.892    32.539     0.150
     1.892    57.209     0.150
     1.892    32.731     0.150
     1.892    58.703     0.150
     1.963    33.169     0.150
     1.963    59.688     0.150
     1.964    33.599     0.150
     2.017    33.482     0.150
     2.017    61.226     0.150
     2.103    65.038     0.150
     2.296    38.448     0.150
     2.296    39.247     0.150
     2.296    68.967     0.150
     2.324    38.988     0.150
     2.324    68.219     0.150
     2.324    38.709     0.150
     2.331    38.818     0.150
     2.331    68.448     0.150
     2.520    42.119     0.150
     2.520    47.190     0.150
     2.560    46.269     0.150
     2.786    43.813     0.150
     2.877    51.289     0.150
     3.051    48.938     0.150
     3.205    51.738     0.150
     3.205    50.682     0.150
     3.984    62.519     0.150
     4.112    64.169     0.150
     4.721    72.148     0.150
     4.834    74.309     0.150
     5.449    83.519     0.150
     7.340   107.783     0.150
     0.309     5.888     0.150
     0.309    10.016     0.150
     0.466     8.668     0.150
     0.466    14.903     0.150
     0.511     9.713     0.150
     0.511    16.819     0.150
     0.899    16.205     0.150
     0.899    28.347     0.150
     0.890    15.770     0.150
     0.890    27.320     0.150
     1.089    20.285     0.150
     1.089    34.897     0.150
     1.213    21.960     0.150
     1.213    38.533     0.150
     1.254    22.494     0.150
     1.254    39.521     0.150
     1.314    23.339     0.150
     1.314    41.160     0.150
     1.328    24.140     0.150
     1.328    41.143     0.150
     1.395    24.142     0.150
     1.395    43.188     0.150
     1.517    28.166     0.150
     1.605    49.256     0.150
     1.809    31.430     0.150
     1.809    55.745     0.150
     1.860    32.316     0.150
     1.860    56.780     0.150
     1.884    58.487     0.150
     2.290    37.578     0.150
     2.290    69.291     0.150
     2.332    38.403     0.150
     3.199    51.593     0.150
     3.977    62.418     0.150
     4.105    64.151     0.150
     4.828    74.410     0.150
     5.443    83.153     0.150
     7.334   108.244     0.150
     0.138     3.145     0.150
     0.306     6.006     0.150
     0.306     5.855     0.150
     0.306    10.195     0.150
     0.306    10.021     0.150
     0.466     8.924     0.150
     0.466    15.838     0.150
     0.466     8.885     0.150
     0.466    15.586     0.150
     0.514     9.756     0.150
     0.514    17.145     0.150
     0.514     9.635     0.150
     0.514     9.932     0.150
     0.729    14.025     0.150
     0.729    25.176     0.150
     0.729    24.145     0.150
     0.827    15.596     0.150
     0.827    26.904     0.150
     0.827    26.654     0.150
     0.901    16.385     0.150
     0.901    28.314     0.150
     0.901    16.186     0.150
     0.901    28.506     0.150
     0.886    16.824     0.150
     0.886    29.795     0.150
     0.890    15.865     0.150
     0.890    15.746     0.150
     0.890    27.596     0.150
     0.890    27.408     0.150
     1.005    17.666     0.150
     1.005    17.975     0.150
     1.005    31.475     0.150
     1.045    19.035     0.150
     1.045    33.416     0.150
     1.092    20.506     0.150
     1.092    35.166     0.150
     1.180    21.055     0.150
     1.180    20.936     0.150
     1.180    36.516     0.150
     1.215    22.045     0.150
     1.215    38.525     0.150
     1.215    21.705     0.150
     1.215    38.783     0.150
     1.258    23.154     0.150
     1.258    39.836     0.150
     1.258    22.855     0.150
     1.258    40.191     0.150
     1.254    22.516     0.150
     1.330    24.205     0.150
     1.330    41.125     0.150
     1.330    41.715     0.150
     1.313    23.525     0.150
     1.313    41.676     0.150
     1.379    25.445     0.150
     1.379    43.246     0.150
     1.394    24.455     0.150
     1.394    24.615     0.150
     1.394    42.395     0.150
     1.396    24.664     0.150
     1.396    43.740     0.150
     1.411    25.895     0.150
     1.411    44.545     0.150
     1.521    28.215     0.150
     1.521    28.342     0.150
     1.411    23.775     0.150
     1.411    24.166     0.150
     1.456    25.166     0.150
     1.571    49.525     0.150
     1.611    27.824     0.150
     1.605    28.086     0.150
     1.605    49.375     0.150
     1.605    27.785     0.150
     1.605    48.918     0.150
     1.622    28.305     0.150
     1.765    29.586     0.150
     1.765    53.756     0.150
     1.754    30.135     0.150
     1.754    54.945     0.150
     1.812    31.385     0.150
     1.812    55.215     0.150
     1.812    31.586     0.150
     1.812    55.051     0.150
     1.806    30.746     0.150
     1.821    30.885     0.150
     1.821    30.715     0.150
     1.821    55.436     0.150
     1.864    32.105     0.150
     1.864    32.426     0.150
     1.864    56.846     0.150
     1.864    56.457     0.150
     1.886    32.605     0.150
     1.886    58.215     0.150
     1.893    31.824     0.150
     1.958    33.605     0.150
     1.958    60.645     0.150
     1.957    33.525     0.150
     1.957    33.145     0.150
     1.957    59.756     0.150
     1.972    33.336     0.150
     1.972    33.467     0.150
     1.972    61.277     0.150
     1.997    33.266     0.150
     2.004    33.885     0.150
     2.012    33.916     0.150
     2.034    33.734     0.150
     2.108    35.314     0.150
     2.108    35.521     0.150
     2.108    64.977     0.150
     2.219    37.225     0.150
     2.219    66.455     0.150
     2.290    37.936     0.150
     2.290    38.234     0.150
     2.290    67.645     0.150
     2.290    38.041     0.150
     2.290    67.076     0.150
     2.324    38.645     0.150
     2.324    38.965     0.150
     2.324    39.135     0.150
     2.324    67.838     0.150
     2.321    38.756     0.150
     2.334    38.846     0.150
     2.334    69.105     0.150
     2.334    68.104     0.150
     2.378    38.836     0.150
     2.517    41.705     0.150
     2.517    41.596     0.150
     2.517    79.805     0.150
     2.517    41.465     0.150
     2.517    73.334     0.150
     2.555    42.855     0.150
     2.555    80.904     0.150
     2.543    41.295     0.150
     2.543    41.057     0.150
     2.589    42.006     0.150
     2.589    41.678     0.150
     2.589    79.348     0.150
     2.636    41.996     0.150
     2.685    43.535     0.150
     2.685    83.340     0.150
     2.703    43.404     0.150
     2.703    43.215     0.150
     2.703    83.176     0.150
     2.741    43.625     0.150
     2.780    44.125     0.150
     2.780    78.320     0.150
     2.892    46.564     0.150
     2.892    46.926     0.150
     2.892    46.736     0.150
     2.882    45.426     0.150
     2.882    45.596     0.150
     2.882    80.365     0.150
     2.882    80.471     0.150
     3.005    47.205     0.150
     3.005    47.496     0.150
     3.005    47.377     0.150
     3.005    84.480     0.150
     3.023    48.166     0.150
     3.023    47.395     0.150
     3.023    47.613     0.150
     3.023    92.861     0.150
     3.045    48.416     0.150
     3.045    48.766     0.150
     3.045    86.346     0.150
     3.045    48.561     0.150
     3.045    85.236     0.150
     3.080    48.895     0.150
     3.202    50.996     0.150
     3.202    51.105     0.150
     3.202    99.225     0.150
     3.234    50.756     0.150
     3.234    50.611     0.150
     3.291    52.336     0.150
     3.291    52.705     0.150
     3.291    91.045     0.150
     3.291   103.666     0.150
     3.291    92.207     0.150
     3.287    50.885     0.150
     3.287    50.506     0.150
     3.287    90.154     0.150
     3.287   101.355     0.150
     3.287   100.850     0.150
     3.317    59.301     0.150
     3.317   102.779     0.150
     3.319    52.195     0.150
     3.319    51.846     0.150
     3.319   102.574     0.150
     3.319   102.305     0.150
     3.371    52.336     0.150
     3.563    55.234     0.150
     3.563    97.703     0.150
     3.609    56.115     0.150
     3.609    98.945     0.150
     3.591    55.365     0.150
     3.694    57.625     0.150
     3.694    58.336     0.150
     3.694   114.996     0.150
     3.694    57.803     0.150
     3.694   101.123     0.150
     3.760    58.346     0.150
     3.760   117.734     0.150
     3.944    61.295     0.150
     3.944   108.252     0.150
     3.939    60.824     0.150
     3.939    61.006     0.150
     3.981    62.256     0.150
     3.981    62.365     0.150
     3.981   107.465     0.150
     3.981   107.883     0.150
     3.991    62.734     0.150
     3.991    62.598     0.150
     3.991   109.025     0.150
     4.040    61.246     0.150
     4.040   108.123     0.150
     4.108    63.475     0.150
     4.108    63.320     0.150
     4.108   111.801     0.150
     4.267    64.855     0.150
     4.267   114.109     0.150
     4.295    64.885     0.150
     4.295   132.256     0.150
     4.295   115.131     0.150
     4.314    65.416     0.150
     4.314    65.520     0.150
     4.314   116.471     0.150
     4.475    67.729     0.150
     4.475   119.346     0.150
     4.528   121.971     0.150
     4.536    68.705     0.150
     4.571    68.666     0.150
     4.584    70.574     0.150
     4.697   124.877     0.150
     4.722    71.895     0.150
     4.722    72.176     0.150
     4.722   147.145     0.150
     4.722   124.973     0.150
     4.752    71.939     0.150
     4.752   126.490     0.150
     4.814    72.746     0.150
     4.814   128.951     0.150
     4.831    73.975     0.150
     4.831   129.404     0.150
     4.831   151.375     0.150
     4.831   130.002     0.150
     4.894    74.215     0.150
     4.950    73.916     0.150
     4.950    74.084     0.150
     5.040    75.016     0.150
     5.244    79.273     0.150
     5.262    79.172     0.150
     5.446    82.814     0.150
     5.446    83.256     0.150
     5.446    82.525     0.150
     5.437    80.814     0.150
     5.503    82.365     0.150
     5.503    84.256     0.150
     5.631    84.275     0.150
     5.657    84.512     0.150
     6.254    93.346     0.150
     6.255    92.744     0.150
     6.286    94.365     0.150
     6.286    94.154     0.150
     6.287    94.016     0.150
     6.287    93.541     0.150
     7.173   105.904     0.150
     7.173   105.271     0.150
     7.337   107.715     0.150
     7.828   114.666     0.150
     7.828   115.189     0.150
     7.829   114.795     0.150
     7.897   116.014     0.150
     8.111   118.773     0.150
     0.299     9.121     0.150
     0.334     6.121     0.150
     0.334    10.791     0.150
     0.535     9.492     0.150
     0.535    16.412     0.150
     0.535     9.277     0.150
     0.535    16.201     0.150
     0.520     9.791     0.150
     0.520    18.402     0.150
     0.602    10.691     0.150
     0.602    18.691     0.150
     0.641    11.688     0.150
     0.695    11.861     0.150
     0.701    13.641     0.150
     0.701    24.191     0.150
     0.779    14.521     0.150
     0.779    26.062     0.150
     0.815    13.881     0.150
     0.968    18.191     0.150
     0.968    17.975     0.150
     0.980    18.082     0.150
     1.010    18.371     0.150
     1.010    31.840     0.150
     1.029    18.662     0.150
     1.032    17.396     0.150
     1.077    19.012     0.150
     1.086    19.881     0.150
     1.086    36.111     0.150
     1.086    20.340     0.150
     1.086    36.277     0.150
     1.165    21.592     0.150
     1.309    24.455     0.150
     1.309    42.006     0.150
     1.213    22.021     0.150
     1.217    21.256     0.150
     1.217    38.096     0.150
     1.253    23.131     0.150
     1.253    23.002     0.150
     1.253    39.434     0.150
     1.276    24.221     0.150
     1.309    22.922     0.150
     1.353    24.791     0.150
     1.427    24.441     0.150
     1.418    25.471     0.150
     1.418    25.176     0.150
     1.418    44.057     0.150
     1.474    24.801     0.150
     1.535    27.551     0.150
     1.600    28.592     0.150
     1.603    27.521     0.150
     1.705    30.453     0.150
     1.762    31.191     0.150
     1.773    31.082     0.150
     1.773    32.326     0.150
     1.773    56.029     0.150
     1.891    33.107     0.150
     1.891    59.191     0.150
     1.936    32.652     0.150
     1.936    34.660     0.150
     1.953    33.742     0.150
     2.039    34.191     0.150
     2.087    35.592     0.150
     2.206    38.381     0.150
     2.230    37.902     0.150
     2.264    37.861     0.150
     2.264    39.664     0.150
     2.264    70.254     0.150
     2.291    37.652     0.150
     2.302    38.281     0.150
     2.347    38.781     0.150
     2.436    40.072     0.150
     2.458    39.922     0.150
     2.458    41.010     0.150
     2.471    40.762     0.150
     2.475    39.992     0.150
     2.475    40.998     0.150
     2.702    44.781     0.150
     2.702    82.697     0.150
     2.717    45.041     0.150
     2.717    50.141     0.150
     2.949    48.182     0.150
     2.956    47.141     0.150
     3.238    52.270     0.150
     3.345    52.631     0.150
     3.473    54.289     0.150
     3.597    56.172     0.150
     3.734    60.139     0.150
     3.806    59.941     0.150
     3.822    58.441     0.150
     3.986    61.191     0.150
     4.589    68.521     0.150
     5.147    78.162     0.150
     5.191    79.891     0.150
     5.279    81.541     0.150
     5.319    81.002     0.150
     5.486    82.312     0.150
     5.579    82.922     0.150
     5.900    87.172     0.150
     5.999    89.742     0.150
     6.073    90.451     0.150
     6.106    90.971     0.150
     0.403     7.598     0.150
     0.403    13.208     0.150
     0.403     7.530     0.150
     0.403    13.210     0.150
     0.428     7.920     0.150
     0.428     7.818     0.150
     0.428    13.002     0.150
     0.485     9.070     0.150
     0.485    15.829     0.150
     0.666    12.760     0.150
     0.666    22.840     0.150
     0.772    13.465     0.150
     0.772    24.176     0.150
     0.911    16.250     0.150
     0.968    16.890     0.150
     0.968    31.110     0.150
     0.982    17.465     0.150
     0.982    30.602     0.150
     1.008    18.870     0.150
     1.008    32.240     0.150
     1.008    32.534     0.150
     1.062    18.490     0.150
     1.062    32.930     0.150
     1.204    21.670     0.150
     1.204    37.950     0.150
     1.252    22.280     0.150
     1.252    22.393     0.150
     1.252    39.088     0.150
     1.212    22.600     0.150
     1.212    22.075     0.150
     1.212    38.464     0.150
     1.249    22.460     0.150
     1.249    39.160     0.150
     1.249    39.563     0.150
     1.276    22.440     0.150
     1.276    39.550     0.150
     1.278    22.506     0.150
     1.278    39.753     0.150
     1.309    22.710     0.150
     1.309    38.890     0.150
     1.297    23.970     0.150
     1.297    41.180     0.150
     1.417    26.340     0.150
     1.417    44.800     0.150
     1.661    28.730     0.150
     1.661    49.980     0.150
     1.661    52.140     0.150
     1.688    29.480     0.150
     1.688    51.570     0.150
     1.713    29.270     0.150
     1.713    53.070     0.150
     1.757    31.210     0.150
     1.757    55.160     0.150
     1.757    31.584     0.150
     1.794    31.740     0.150
     1.794    55.210     0.150
     1.794    55.380     0.150
     1.800    55.740     0.150
     1.829    32.240     0.150
     1.829    57.880     0.150
     1.846    32.270     0.150
     1.846    57.050     0.150
     1.923    59.920     0.150
     2.179    36.770     0.150
     2.179    66.490     0.150
     2.179    38.673     0.150
     2.179    65.110     0.150
     2.340    39.030     0.150
     2.340    68.510     0.150
     2.340    68.801     0.150
     2.405    40.383     0.150
     2.693    43.356     0.150
     2.693    76.945     0.150
     2.801    45.900     0.150
     2.801    51.620     0.150
     2.801    45.295     0.150
     2.940    83.870     0.150
     2.940    51.430     0.150
     2.940    90.319     0.150
     2.940    91.390     0.150
     2.940    52.311     0.150
     2.940    91.763     0.150
     3.091    49.830     0.150
     3.091    57.040     0.150
     3.091    96.830     0.150
     3.239    52.390     0.150
     3.319   101.899     0.150
     3.467    96.048     0.150
     3.871    61.160     0.150
     3.871    60.939     0.150
     4.684    72.045     0.150
     4.727    73.150     0.150
     4.727   127.860     0.150
     4.727   147.080     0.150
     4.727    72.922     0.150
     5.339    81.710     0.150
     0.369     6.879     0.150
     0.585    10.428     0.150
     0.585    18.879     0.150
     0.850    15.318     0.150
     0.850    26.986     0.150
     0.949    16.717     0.150
     0.893    29.887     0.150
     0.986    31.127     0.150
     0.986    17.223     0.150
     1.107    18.857     0.150
     1.215    22.467     0.150
     1.129    20.836     0.150
     1.324    23.318     0.150
     1.319    23.229     0.150
     1.322    44.281     0.150
     1.310    40.387     0.150
     1.310    23.988     0.150
     1.310    41.010     0.150
     1.322    23.658     0.150
     1.322    41.787     0.150
     1.322    24.232     0.150
     1.322    42.613     0.150
     1.414    26.498     0.150
     1.423    25.947     0.150
     1.423    46.037     0.150
     1.537    28.428     0.150
     1.678    28.828     0.150
     1.702    30.207     0.150
     1.850    32.518     0.150
     1.850    57.768     0.150
     1.893    57.979     0.150
     1.893    58.184     0.150
     1.913    58.107     0.150
     1.913    59.027     0.150
     2.208    36.898     0.150
     2.389    39.877     0.150
     2.389    70.117     0.150
     2.422    40.908     0.150
     2.422    70.988     0.150
     2.518    41.418     0.150
     2.518    45.951     0.150
     2.523    41.848     0.150
     2.523    42.637     0.150
     2.958    47.348     0.150
     2.922    47.668     0.150
     2.922    81.508     0.150
     2.980    53.518     0.150
     2.980    93.729     0.150
     3.209    51.717     0.150
     3.273    51.697     0.150
     3.383   105.078     0.150
     3.403    61.158     0.150
     3.403   105.887     0.150
     3.990    62.447     0.150
     4.096    63.887     0.150
     4.792   128.588     0.150
     4.847    73.758     0.150
     4.847   129.717     0.150
     5.458    83.098     0.150
     5.458   143.518     0.150
     5.487    83.387     0.150
     0.264     4.904     0.150
     0.264     8.584     0.150
     0.335     6.214     0.150
     0.335     6.084     0.150
     0.335    10.533     0.150
     0.428     8.124     0.150
     0.428    14.314     0.150
     0.428     8.234     0.150
     0.428    14.013     0.150
     0.540    10.984     0.150
     0.589    11.001     0.150
     0.589    19.265     0.150
     0.589    10.734     0.150
     0.589    18.944     0.150
     0.589    10.894     0.150
     0.589    18.434     0.150
     0.743    14.054     0.150
     0.743    24.234     0.150
     0.774    13.224     0.150
     0.774    23.624     0.150
     0.774    13.894     0.150
     0.774    24.204     0.150
     0.774    13.691     0.150
     0.853    16.294     0.150
     0.853    28.924     0.150
     0.853    15.714     0.150
     0.967    16.874     0.150
     0.967    17.034     0.150
     0.967    30.174     0.150
     0.967    30.056     0.150
     1.011    19.114     0.150
     1.045    19.544     0.150
     1.045    33.864     0.150
     1.045    33.224     0.150
     1.045    19.257     0.150
     1.091    19.284     0.150
     1.091    34.664     0.150
     1.091    19.854     0.150
     1.091    34.484     0.150
     1.091    19.734     0.150
     1.091    35.203     0.150
     1.118    20.124     0.150
     1.118    35.274     0.150
     1.118    34.874     0.150
     1.172    20.814     0.150
     1.172    37.114     0.150
     1.172    21.304     0.150
     1.172    37.424     0.150
     1.172    21.454     0.150
     1.172    37.578     0.150
     1.166    21.314     0.150
     1.166    36.214     0.150
     1.271    39.654     0.150
     1.271    22.464     0.150
     1.271    39.534     0.150
     1.320    41.494     0.150
     1.358    24.314     0.150
     1.358    42.484     0.150
     1.374    24.634     0.150
     1.374    44.054     0.150
     1.496    27.784     0.150
     1.496    47.724     0.150
     1.406    25.884     0.150
     1.406    44.214     0.150
     1.437    25.654     0.150
     1.437    25.824     0.150
     1.437    44.524     0.150
     1.437    25.950     0.150
     1.437    45.616     0.150
     1.486    26.624     0.150
     1.486    26.504     0.150
     1.486    46.104     0.150
     1.488    25.689     0.150
     1.488    47.546     0.150
     1.520    26.694     0.150
     1.520    47.684     0.150
     1.575    27.474     0.150
     1.669    28.644     0.150
     1.669    50.734     0.150
     1.702    29.434     0.150
     1.702    30.474     0.150
     1.702    53.454     0.150
     1.702    30.344     0.150
     1.702    53.112     0.150
     1.697    53.094     0.150
     1.728    30.094     0.150
     1.743    30.664     0.150
     1.795    31.464     0.150
     1.795    31.754     0.150
     1.795    55.834     0.150
     1.795    32.858     0.150
     1.795    56.048     0.150
     1.872    32.074     0.150
     1.872    56.934     0.150
     1.924    33.694     0.150
     1.924    58.964     0.150
     1.928    32.794     0.150
     1.984    33.364     0.150
     1.984    35.496     0.150
     1.984    60.714     0.150
     2.009    34.294     0.150
     2.057    35.374     0.150
     2.057    62.164     0.150
     2.098    36.124     0.150
     2.098    35.885     0.150
     2.098    65.980     0.150
     2.119    35.434     0.150
     2.128    36.028     0.150
     2.128    64.444     0.150
     2.129    35.904     0.150
     2.151    35.244     0.150
     2.216    37.394     0.150
     2.216    37.714     0.150
     2.216    65.974     0.150
     2.216    37.503     0.150
     2.216    65.828     0.150
     2.235    37.204     0.150
     2.235    38.164     0.150
     2.235    40.444     0.150
     2.235    65.934     0.150
     2.235    37.722     0.150
     2.332    37.964     0.150
     2.334    67.574     0.150
     2.334    69.151     0.150
     2.345    38.784     0.150
     2.391    39.844     0.150
     2.391    40.004     0.150
     2.391    69.834     0.150
     2.391    71.162     0.150
     2.446    40.764     0.150
     2.485    41.474     0.150
     2.502    41.644     0.150
     2.502    42.094     0.150
     2.502    73.394     0.150
     2.502    73.582     0.150
     2.507    72.144     0.150
     2.507    73.550     0.150
     2.593    42.084     0.150
     2.593    42.314     0.150
     2.593    74.184     0.150
     2.601    42.124     0.150
     2.669    43.684     0.150
     2.746    45.754     0.150
     2.741    44.194     0.150
     2.756    43.704     0.150
     2.756    44.411     0.150
     2.756    85.971     0.150
     2.811    46.184     0.150
     2.845    46.974     0.150
     2.845    46.554     0.150
     2.845    51.504     0.150
     2.845    46.218     0.150
     2.845    88.310     0.150
     2.898    46.414     0.150
     2.898    83.065     0.150
     2.916    45.014     0.150
     2.916    81.194     0.150
     2.916    82.309     0.150
     2.971    47.944     0.150
     3.151    50.514     0.150
     3.151    50.204     0.150
     3.151    87.504     0.150
     3.151    49.964     0.150
     3.151    89.111     0.150
     3.155    51.654     0.150
     3.163    49.314     0.150
     3.163    87.754     0.150
     3.163    98.074     0.150
     3.163    49.895     0.150
     3.163    88.389     0.150
     3.185    51.604     0.150
     3.185    51.374     0.150
     3.185    57.844     0.150
     3.185    88.974     0.150
     3.185    51.831     0.150
     3.185    90.248     0.150
     3.205    50.584     0.150
     3.205    51.864     0.150
     3.205    88.434     0.150
     3.205    52.407     0.150
     3.205    91.060     0.150
     3.205    88.984     0.150
     3.205    99.684     0.150
     3.205    99.038     0.150
     3.360    52.474     0.150
     3.358    52.444     0.150
     3.358    93.399     0.150
     3.489    54.894     0.150
     3.636    56.774     0.150
     3.636    57.024     0.150
     3.636    64.764     0.150
     3.636    99.554     0.150
     3.636   100.271     0.150
     3.677    57.274     0.150
     3.676    56.904     0.150
     3.676    57.650     0.150
     3.676   101.500     0.150
     3.716    58.144     0.150
     3.742    59.524     0.150
     3.812    60.106     0.150
     3.947    63.054     0.150
     3.947   122.986     0.150
     3.960    62.334     0.150
     3.960    61.934     0.150
     3.960    71.604     0.150
     3.960   107.814     0.150
     3.960   123.724     0.150
     3.960    62.762     0.150
     3.960   108.442     0.150
     4.048    61.924     0.150
     4.048    63.585     0.150
     4.061    61.554     0.150
     4.061    63.367     0.150
     4.113    64.214     0.150
     4.113   111.364     0.150
     4.113   129.384     0.150
     4.113    64.501     0.150
     4.113   112.916     0.150
     4.170    63.714     0.150
     4.170    74.354     0.150
     4.170   110.894     0.150
     4.170   129.474     0.150
     4.170   128.266     0.150
     4.166    63.224     0.150
     4.307    66.094     0.150
     4.307    65.984     0.150
     4.307   115.054     0.150
     4.307   132.688     0.150
     4.426    68.014     0.150
     4.426   119.938     0.150
     4.589   124.842     0.150
     4.620   121.924     0.150
     4.620   125.196     0.150
     4.659    71.584     0.150
     4.801    73.844     0.150
     4.801    73.674     0.150
     4.801    86.514     0.150
     4.801   127.364     0.150
     4.801    74.154     0.150
     4.801   130.375     0.150
     4.815    74.154     0.150
     4.815   130.323     0.150
     4.866   130.856     0.150
     4.918    75.494     0.150
     4.918    74.594     0.150
     4.918    75.284     0.150
     4.916   131.611     0.150
     5.033    76.984     0.150
     5.124    78.414     0.150
     5.366    80.074     0.150
     5.366    81.884     0.150
     5.421    83.204     0.150
     5.421   141.074     0.150
     5.421    82.689     0.150
     5.424    82.194     0.150
     5.513    83.364     0.150
     5.513   144.824     0.150
     5.562    82.834     0.150
     5.670    85.064     0.150
     5.670    85.573     0.150
     5.775    86.394     0.150
     5.922    89.234     0.150
     6.146    90.994     0.150
     6.248    92.524     0.150
     6.283    93.304     0.150
     6.283    93.014     0.150
     6.283   162.264     0.150
     6.283    93.889     0.150
     6.379    94.044     0.150
     6.921   102.424     0.150
     6.947   102.234     0.150
     6.986   104.574     0.150
     7.156   106.024     0.150
     7.307   108.014     0.150
     7.307   107.800     0.150
     7.319   106.124     0.150
     7.481   108.934     0.150
     7.689   112.214     0.150
     7.868   115.574     0.150
     8.064   118.364     0.150
     8.672   127.744     0.150
     9.004   129.594     0.150
     0.277     5.027     0.150
     0.277     9.188     0.150
     0.334     6.295     0.150
     0.334    11.381     0.150
     0.334     6.316     0.150
     0.538     9.828     0.150
     0.538    16.906     0.150
     0.577    11.248     0.150
     0.608    10.877     0.150
     0.608    19.047     0.150
     0.576    10.297     0.150
     0.576    17.973     0.150
     0.756    14.557     0.150
     0.720    13.617     0.150
     0.775    13.547     0.150
     0.806    15.027     0.150
     0.806    26.156     0.150
     0.851    28.207     0.150
     0.899    15.486     0.150
     0.955    17.926     0.150
     0.955    30.154     0.150
     1.060    19.428     0.150
     1.060    19.271     0.150
     1.060    33.238     0.150
     1.055    19.527     0.150
     1.113    19.236     0.150
     1.116    19.197     0.150
     1.116    34.096     0.150
     1.160    19.838     0.150
     1.152    21.277     0.150
     1.152    36.928     0.150
     1.133    20.146     0.150
     1.133    19.904     0.150
     1.133    34.980     0.150
     1.324    24.461     0.150
     1.324    42.557     0.150
     1.215    22.207     0.150
     1.215    22.322     0.150
     1.215    38.703     0.150
     1.243    21.998     0.150
     1.296    22.418     0.150
     1.346    24.457     0.150
     1.611    28.396     0.150
     1.663    28.467     0.150
     1.687    30.227     0.150
     1.757    31.248     0.150
     1.757    54.443     0.150
     1.786    30.668     0.150
     1.786    54.760     0.150
     1.809    30.428     0.150
     1.840    32.377     0.150
     1.840    32.518     0.150
     1.840    57.029     0.150
     1.828    32.127     0.150
     1.828    56.297     0.150
     2.021    35.066     0.150
     2.026    34.617     0.150
     2.122    36.027     0.150
     2.294    39.393     0.150
     2.273    38.838     0.150
     2.273    68.408     0.150
     2.311    38.428     0.150
     2.375    39.357     0.150
     2.393    39.967     0.150
     2.393    40.607     0.150
     2.400    40.107     0.150
     2.400    40.277     0.150
     2.400    71.625     0.150
     2.556    41.678     0.150
     2.556    41.150     0.150
     2.713    43.502     0.150
     2.725    44.617     0.150
     2.725    44.846     0.150
     2.786    45.430     0.150
     2.979    48.670     0.150
     3.027    48.146     0.150
     3.321    52.607     0.150
     3.357    53.225     0.150
     3.406    53.316     0.150
     3.762    59.996     0.150
     3.852    59.566     0.150
     3.852    60.695     0.150
     4.619    71.625     0.150
     4.626    72.035     0.150
     4.659    71.412     0.150
     5.188    78.428     0.150
     5.232    80.600     0.150
     5.241    79.119     0.150
     6.041    89.848     0.150
     6.041    90.131     0.150
     7.131   104.707     0.150
     0.339     6.527     0.150
     0.339    11.090     0.150
     0.448     8.500     0.150
     0.448    14.977     0.150
     0.448     8.824     0.150
     0.448    15.371     0.150
     0.526     9.656     0.150
     0.526    16.742     0.150
     0.526     9.629     0.150
     0.526    16.637     0.150
     0.763    14.520     0.150
     0.763    24.578     0.150
     0.838    14.559     0.150
     0.838    26.340     0.150
     0.838    27.012     0.150
     0.790    15.270     0.150
     0.790    26.930     0.150
     0.913    15.918     0.150
     0.913    28.043     0.150
     1.043    19.418     0.150
     1.043    33.488     0.150
     1.043    19.652     0.150
     1.043    33.625     0.150
     1.054    18.957     0.150
     1.054    34.047     0.150
     1.145    35.449     0.150
     1.145    37.102     0.150
     1.102    20.258     0.150
     1.102    35.707     0.150
     1.193    21.180     0.150
     1.193    37.828     0.150
     1.193    22.078     0.150
     1.211    21.250     0.150
     1.325    42.578     0.150
     1.319    23.566     0.150
     1.319    42.816     0.150
     1.319    41.914     0.150
     1.375    25.090     0.150
     1.375    24.887     0.150
     1.375    43.363     0.150
     1.482    27.629     0.150
     1.382    44.387     0.150
     1.425    25.430     0.150
     1.425    45.590     0.150
     1.428    24.582     0.150
     1.428    44.797     0.150
     1.456    25.547     0.150
     1.456    45.977     0.150
     1.548    26.898     0.150
     1.548    47.508     0.150
     1.548    27.520     0.150
     1.548    48.426     0.150
     1.806    30.898     0.150
     1.806    54.328     0.150
     1.809    31.387     0.150
     1.809    55.180     0.150
     1.861    32.566     0.150
     1.861    56.648     0.150
     1.884    57.219     0.150
     1.962    34.047     0.150
     1.962    58.398     0.150
     1.995    60.129     0.150
     2.064    35.539     0.150
     2.263    64.879     0.150
     2.259    39.461     0.150
     2.328    39.977     0.150
     2.328    67.969     0.150
     2.328    40.301     0.150
     2.328    71.094     0.150
     2.484    40.938     0.150
     2.484    71.227     0.150
     2.484    43.305     0.150
     2.656    74.367     0.150
     2.817    44.500     0.150
     2.843    46.129     0.150
     3.088    49.969     0.150
     3.088    86.328     0.150
     3.168    50.156     0.150
     3.168    87.977     0.150
     3.425    94.789     0.150
     3.699    99.379     0.150
     3.945   106.648     0.150
     4.085    62.859     0.150
     4.230   112.156     0.150
     4.230   130.277     0.150
     4.225   114.000     0.150
     4.225   132.316     0.150
     4.322   115.828     0.150
     5.408   141.906     0.150
     5.483   143.309     0.150
     0.447     7.945     0.150
     0.447    14.148     0.150
     0.447     8.328     0.150
     0.447    14.219     0.150
     0.514     9.023     0.150
     0.514    16.000     0.150
     0.514     8.430     0.150
     0.514    16.172     0.150
     0.489     9.000     0.150
     0.489    15.781     0.150
     0.489     8.781     0.150
     0.489    15.672     0.150
     0.660    12.828     0.150
     0.707    23.219     0.150
     0.717    13.547     0.150
     0.717    23.297     0.150
     0.794    12.969     0.150
     0.851    14.750     0.150
     0.851    25.672     0.150
     0.820    15.242     0.150
     0.820    15.391     0.150
     0.820    25.727     0.150
     0.897    15.008     0.150
     0.925    16.711     0.150
     0.925    29.547     0.150
     0.925    29.727     0.150
     1.063    18.492     0.150
     1.063    32.273     0.150
     1.066    18.500     0.150
     1.066    32.633     0.150
     1.036    18.898     0.150
     1.176    21.977     0.150
     1.176    37.906     0.150
     1.149    19.188     0.150
     1.108    20.344     0.150
     1.108    34.750     0.150
     1.108    34.586     0.150
     1.211    22.727     0.150
     1.211    40.320     0.150
     1.211    22.227     0.150
     1.211    40.055     0.150
     1.174    20.703     0.150
     1.174    36.758     0.150
     1.315    23.594     0.150
     1.492    24.930     0.150
     1.492    44.352     0.150
     1.479    26.523     0.150
     1.479    46.438     0.150
     1.529    25.703     0.150
     1.555    27.828     0.150
     1.555    49.156     0.150
     1.650    28.227     0.150
     1.650    50.531     0.150
     1.625    29.688     0.150
     1.625    51.820     0.150
     1.625    29.516     0.150
     1.625    51.648     0.150
     1.792    29.688     0.150
     1.792    54.383     0.150
     1.754    31.578     0.150
     1.754    55.602     0.150
     1.754    56.031     0.150
     1.879    34.047     0.150
     1.847    32.961     0.150
     1.847    57.703     0.150
     1.847    32.844     0.150
     1.981    33.844     0.150
     1.981    60.148     0.150
     1.981    34.516     0.150
     2.147    38.281     0.150
     2.147    67.656     0.150
     2.147    38.805     0.150
     2.147    68.016     0.150
     2.146    37.609     0.150
     2.146    67.570     0.150
     2.146    37.188     0.150
     2.155    37.242     0.150
     2.155    68.383     0.150
     2.155    39.938     0.150
     2.155    68.555     0.150
     2.289    42.133     0.150
     2.289    72.125     0.150
     2.327    39.570     0.150
     2.327    71.594     0.150
     2.327    40.445     0.150
     2.327    71.289     0.150
     2.559    43.180     0.150
     2.559    75.938     0.150
     2.580    43.289     0.150
     2.580    47.312     0.150
     2.580    81.258     0.150
     2.629    48.492     0.150
     2.629    83.008     0.150
     2.756    46.352     0.150
     2.756    46.734     0.150
     2.832    47.242     0.150
     2.832    51.898     0.150
     2.832    88.898     0.150
     2.832    52.031     0.150
     2.832    89.414     0.150
     2.912    48.344     0.150
     3.076    49.695     0.150
     3.035    48.281     0.150
     3.035    54.609     0.150
     3.095    96.398     0.150
     3.308    53.445     0.150
     3.355   103.109     0.150
     3.615    58.078     0.150
     3.615    67.297     0.150
     3.711    60.031     0.150
     3.859    61.023     0.150
     4.478    70.742     0.150
     4.478    83.781     0.150
     4.478   141.250     0.150
     5.084    78.969     0.150
     5.102    79.812     0.150
     0.237     7.691     0.150
     0.422     7.828     0.150
     0.422     8.070     0.150
     0.422    14.051     0.150
     0.550     9.855     0.150
     0.550    18.164     0.150
     0.550     9.918     0.150
     0.550    18.270     0.150
     0.550    18.121     0.150
     0.557    11.191     0.150
     0.736    13.480     0.150
     0.736    23.918     0.150
     0.736    13.891     0.150
     0.917    15.930     0.150
     0.917    15.594     0.150
     0.917    27.875     0.150
     1.022    18.961     0.150
     1.022    33.230     0.150
     1.022    32.543     0.150
     1.073    19.000     0.150
     1.073    19.141     0.150
     1.073    34.289     0.150
     1.117    20.168     0.150
     1.117    35.551     0.150
     1.117    35.172     0.150
     1.167    21.230     0.150
     1.167    36.559     0.150
     1.167    37.371     0.150
     1.167    37.168     0.150
     1.222    20.859     0.150
     1.222    20.969     0.150
     1.314    23.281     0.150
     1.314    23.461     0.150
     1.314    42.141     0.150
     1.314    41.855     0.150
     1.302    41.828     0.150
     1.302    23.930     0.150
     1.302    41.281     0.150
     1.369    24.969     0.150
     1.465    27.090     0.150
     1.400    25.020     0.150
     1.400    44.219     0.150
     1.400    25.219     0.150
     1.400    44.328     0.150
     1.436    24.559     0.150
     1.439    24.223     0.150
     1.439    45.414     0.150
     1.473    25.328     0.150
     1.473    45.789     0.150
     1.473    25.461     0.150
     1.473    45.039     0.150
     1.531    26.418     0.150
     1.531    26.738     0.150
     1.527    26.418     0.150
     1.527    47.648     0.150
     1.619    27.918     0.150
     1.619    49.570     0.150
     1.662    29.539     0.150
     1.702    29.719     0.150
     1.713    30.301     0.150
     1.713    30.641     0.150
     1.713    53.859     0.150
     1.713    30.480     0.150
     1.713    53.570     0.150
     1.781    31.508     0.150
     1.781    32.711     0.150
     1.781    55.820     0.150
     1.781    56.059     0.150
     1.825    31.449     0.150
     1.825    56.539     0.150
     1.843    32.348     0.150
     1.876    32.078     0.150
     1.876    58.070     0.150
     1.887    32.621     0.150
     1.882    33.078     0.150
     1.882    33.270     0.150
     1.882    58.789     0.150
     1.882    57.281     0.150
     1.964    33.598     0.150
     1.962    34.168     0.150
     1.962    34.508     0.150
     1.962    61.469     0.150
     2.008    34.500     0.150
     2.008    34.820     0.150
     2.008    63.211     0.150
     2.024    34.629     0.150
     2.024    60.988     0.150
     2.079    35.168     0.150
     2.084    35.457     0.150
     2.084    63.422     0.150
     2.107    35.898     0.150
     2.232    38.211     0.150
     2.232    69.879     0.150
     2.232    37.961     0.150
     2.232    69.312     0.150
     2.234    37.738     0.150
     2.234    37.941     0.150
     2.234    67.309     0.150
     2.234    69.918     0.150
     2.234    66.832     0.150
     2.293    38.609     0.150
     2.310    38.949     0.150
     2.342    39.820     0.150
     2.342    71.391     0.150
     2.342    71.828     0.150
     2.383    39.020     0.150
     2.383    40.078     0.150
     2.383    70.484     0.150
     2.438    40.750     0.150
     2.469    41.328     0.150
     2.469    41.871     0.150
     2.469    71.324     0.150
     2.549    42.020     0.150
     2.549    42.621     0.150
     2.549    42.180     0.150
     2.549    46.840     0.150
     2.549    41.344     0.150
     2.563    42.441     0.150
     2.556    42.250     0.150
     2.556    41.703     0.150
     2.556    74.586     0.150
     2.636    42.750     0.150
     2.640    43.020     0.150
     2.640    42.250     0.150
     2.640    80.340     0.150
     2.693    44.469     0.150
     2.697    44.840     0.150
     2.697    43.578     0.150
     2.772    45.461     0.150
     2.823    45.281     0.150
     2.823    45.559     0.150
     2.792    44.691     0.150
     2.792    44.480     0.150
     2.792    49.988     0.150
     2.792    86.711     0.150
     2.823    47.281     0.150
     2.823    46.219     0.150
     2.823    51.918     0.150
     2.823    45.574     0.150
     2.854    45.559     0.150
     2.854    45.762     0.150
     2.854    81.707     0.150
     2.963    47.891     0.150
     2.963    47.262     0.150
     3.031    48.410     0.150
     3.019    47.691     0.150
     3.103    49.828     0.150
     3.103    50.328     0.150
     3.103    55.520     0.150
     3.103    49.715     0.150
     3.103    87.699     0.150
     3.153    51.289     0.150
     3.153    58.098     0.150
     3.153    51.008     0.150
     3.200    51.129     0.150
     3.200    51.809     0.150
     3.201    51.258     0.150
     3.201    51.719     0.150
     3.201    91.801     0.150
     3.201   100.289     0.150
     3.201    89.496     0.150
     3.190    50.590     0.150
     3.190    49.828     0.150
     3.190    97.684     0.150
     3.219    51.230     0.150
     3.219   100.098     0.150
     3.219    51.109     0.150
     3.219    99.719     0.150
     3.318    52.660     0.150
     3.318    52.250     0.150
     3.313    52.109     0.150
     3.318    52.039     0.150
     3.317    52.500     0.150
     3.317    52.199     0.150
     3.445    54.520     0.150
     3.497    55.469     0.150
     3.497    54.637     0.150
     3.582    55.848     0.150
     3.630    57.539     0.150
     3.630    57.098     0.150
     3.630   100.746     0.150
     3.628    56.750     0.150
     3.628   100.266     0.150
     3.600    57.609     0.150
     3.600    57.430     0.150
     3.600    57.125     0.150
     3.600   109.707     0.150
     3.676    56.918     0.150
     3.676    65.270     0.150
     3.676    56.695     0.150
     3.676   113.074     0.150
     3.929    62.379     0.150
     3.929   108.238     0.150
     3.929    62.016     0.150
     3.924    62.480     0.150
     4.000    62.730     0.150
     4.074    64.211     0.150
     4.074    64.020     0.150
     4.074   112.609     0.150
     4.074    63.875     0.150
     4.131    63.121     0.150
     4.235    64.418     0.150
     4.235    63.848     0.150
     4.205    64.148     0.150
     4.205    63.879     0.150
     4.205    74.918     0.150
     4.205   129.730     0.150
     4.205    63.996     0.150
     4.205   129.480     0.150
     4.261    65.629     0.150
     4.326    66.270     0.150
     4.326    67.848     0.150
     4.326    79.680     0.150
     4.380    67.598     0.150
     4.380    67.004     0.150
     4.380   118.789     0.150
     4.543    69.004     0.150
     4.583    70.918     0.150
     4.583    69.535     0.150
     4.618    70.230     0.150
     4.618    69.859     0.150
     4.664    70.699     0.150
     4.664    71.055     0.150
     4.771    73.168     0.150
     4.773    74.098     0.150
     4.773   130.480     0.150
     4.773   151.320     0.150
     4.773    73.680     0.150
     4.821    73.309     0.150
     4.869    74.031     0.150
     4.869    73.617     0.150
     4.953    75.219     0.150
     4.953    74.711     0.150
     5.096    76.859     0.150
     5.096    76.199     0.150
     5.277    78.793     0.150
     5.317    79.977     0.150
     5.325    80.078     0.150
     5.389    82.348     0.150
     5.391    82.598     0.150
     5.391    82.738     0.150
     5.391   144.918     0.150
     5.439    81.969     0.150
     5.448    82.258     0.150
     5.473    83.008     0.150
     5.473   147.441     0.150
     5.473    82.758     0.150
     5.524    82.508     0.150
     5.726    86.168     0.150
     5.727    86.621     0.150
     5.727    86.406     0.150
     5.860    88.461     0.150
     5.875    88.879     0.150
     5.875    88.543     0.150
     5.972    88.609     0.150
     5.972   156.895     0.150
     5.972   188.820     0.150
     5.972    88.430     0.150
     6.114    91.090     0.150
     6.223    93.801     0.150
     6.223    93.691     0.150
     6.223    93.031     0.150
     6.247    93.301     0.150
     6.247    93.180     0.150
     6.247    92.977     0.150
     6.306    94.551     0.150
     6.306    94.754     0.150
     6.327    94.398     0.150
     6.327    94.887     0.150
     6.337    94.820     0.150
     6.337    95.242     0.150
     6.741    99.691     0.150
     6.918   103.398     0.150
     6.951   102.230     0.150
     7.295   106.191     0.150
     7.279   107.051     0.150
     7.279   188.371     0.150
     7.279   107.414     0.150
     7.778   114.059     0.150
     7.877   113.309     0.150
     8.020   118.020     0.150
     8.129   119.078     0.150
     8.279   121.031     0.150
     8.434   122.488     0.150
     8.607   125.668     0.150
     8.634   126.160     0.150
     8.697   125.898     0.150
     8.686   126.750     0.150
     8.759   127.820     0.150
     8.965   129.559     0.150
     9.306   136.031     0.150
     9.362   136.910     0.150
     9.362   240.238     0.150
     9.751   143.230     0.150
     9.838   144.949     0.150
     9.846   144.770     0.150
    10.237   149.898     0.150
    10.494   151.348     0.150
    11.342   162.570     0.150
    12.059   171.578     0.150
    61.070   613.246     0.150
    65.586   643.016     0.150
   149.822  1188.738     0.150
     0.260     4.651     0.150
     0.260     8.621     0.150
     0.260     4.551     0.150
     0.319     5.611     0.150
     0.319    10.171     0.150
     0.548     9.651     0.150
     0.548    16.261     0.150
     0.548     9.881     0.150
     0.634    11.211     0.150
     0.634    19.811     0.150
     0.634    19.921     0.150
     0.749    14.531     0.150
     0.750    13.571     0.150
     0.750    14.061     0.150
     0.750    25.171     0.150
     0.810    14.321     0.150
     0.810    24.761     0.150
     0.810    14.131     0.150
     0.810    25.221     0.150
     0.891    16.451     0.150
     0.891    29.151     0.150
     1.053    18.940     0.150
     1.053    19.701     0.150
     1.053    34.571     0.150
     1.024    17.861     0.150
     1.024    31.831     0.150
     1.060    18.371     0.150
     1.060    32.421     0.150
     1.006    18.831     0.150
     1.006    32.511     0.150
     1.035    18.980     0.150
     1.035    32.980     0.150
     1.206    21.230     0.150
     1.189    21.811     0.150
     1.189    38.221     0.150
     1.345    24.971     0.150
     1.326    24.241     0.150
     1.291    23.411     0.150
     1.291    40.201     0.150
     1.315    24.701     0.150
     1.315    24.461     0.150
     1.315    41.671     0.150
     1.412    24.301     0.150
     1.412    42.521     0.150
     1.461    25.261     0.150
     1.461    25.071     0.150
     1.461    44.121     0.150
     1.496    26.291     0.150
     1.447    26.141     0.150
     1.561    26.801     0.150
     1.556    28.241     0.150
     1.556    28.051     0.150
     1.593    27.791     0.150
     1.593    27.901     0.150
     1.593    47.411     0.150
     1.614    28.561     0.150
     1.614    28.801     0.150
     1.614    47.581     0.150
     1.707    28.931     0.150
     1.925    32.381     0.150
     1.926    33.321     0.150
     1.926    33.581     0.150
     1.928    33.801     0.150
     1.928    34.121     0.150
     2.024    34.171     0.150
     2.223    37.591     0.150
     2.223    38.011     0.150
     2.278    37.980     0.150
     2.314    39.001     0.150
     2.296    39.281     0.150
     2.296    39.781     0.150
     2.296    71.311     0.150
     2.329    39.461     0.150
     2.407    40.091     0.150
     2.341    39.631     0.150
     2.341    40.261     0.150
     2.445    40.321     0.150
     2.454    40.261     0.150
     2.493    41.081     0.150
     2.493    41.901     0.150
     2.637    44.031     0.150
     2.689    44.201     0.150
     2.689    44.661     0.150
     2.689    82.351     0.150
     2.754    45.521     0.150
     2.754    46.161     0.150
     2.945    47.331     0.150
     2.970    47.421     0.150
     2.973    48.301     0.150
     2.973    48.101     0.150
     2.980    48.801     0.150
     2.980    49.511     0.150
     2.980    92.431     0.150
     3.157    49.581     0.150
     3.157    88.631     0.150
     3.283    53.711     0.150
     3.283    53.591     0.150
     3.283   102.031     0.150
     3.444    55.041     0.150
     3.505    55.061     0.150
     3.505    54.901     0.150
     3.713    59.261     0.150
     3.832    60.951     0.150
     3.969    62.081     0.150
     3.946    61.591     0.150
     4.212    65.371     0.150
     4.674    71.661     0.150
     4.635    72.741     0.150
     4.635    72.331     0.150
     4.635   145.551     0.150
     5.215    80.881     0.150
     5.294    81.311     0.150
     6.107    90.401     0.150
     6.943   102.431     0.150
     7.138   105.031     0.150
     0.360     6.945     0.150
     0.360    12.102     0.150
     0.360     6.812     0.150
     0.360    12.008     0.150
     0.505     9.141     0.150
     0.505    16.203     0.150
     0.505     9.008     0.150
     0.650    11.531     0.150
     0.650    20.156     0.150
     0.650    20.344     0.150
     0.694    13.391     0.150
     0.783    14.383     0.150
     0.783    25.906     0.150
     0.892    16.406     0.150
     0.892    29.383     0.150
     0.946    16.352     0.150
     0.953    17.781     0.150
     0.953    30.742     0.150
     0.953    17.898     0.150
     1.091    34.148     0.150
     1.091    19.836     0.150
     1.091    34.328     0.150
     1.160    19.867     0.150
     1.160    34.750     0.150
     1.163    19.969     0.150
     1.163    36.172     0.150
     1.207    20.406     0.150
     1.189    21.461     0.150
     1.189    38.133     0.150
     1.189    21.969     0.150
     1.189    38.406     0.150
     1.335    24.898     0.150
     1.335    43.148     0.150
     1.198    21.820     0.150
     1.198    37.766     0.150
     1.257    40.109     0.150
     1.344    23.172     0.150
     1.344    41.250     0.150
     1.307    23.359     0.150
     1.307    40.867     0.150
     1.469    26.336     0.150
     1.464    26.281     0.150
     1.557    26.422     0.150
     1.638    29.461     0.150
     1.638    51.766     0.150
     1.708    30.258     0.150
     1.708    29.531     0.150
     1.708    52.242     0.150
     1.752    54.656     0.150
     1.752    30.820     0.150
     1.752    54.516     0.150
     1.831    31.227     0.150
     1.831    56.078     0.150
     1.854    30.953     0.150
     1.854    54.898     0.150
     1.859    32.430     0.150
     1.814    32.023     0.150
     1.814    56.539     0.150
     1.814    31.586     0.150
     1.814    56.062     0.150
     2.068    35.023     0.150
     2.068    63.469     0.150
     2.068    35.414     0.150
     2.068    64.672     0.150
     2.067    35.203     0.150
     2.110    36.000     0.150
     2.110    62.820     0.150
     2.169    35.750     0.150
     2.307    38.680     0.150
     2.259    38.422     0.150
     2.259    66.633     0.150
     2.259    38.195     0.150
     2.259    66.781     0.150
     2.312    39.180     0.150
     2.312    39.336     0.150
     2.266    66.531     0.150
     2.422    39.188     0.150
     2.422    68.156     0.150
     2.435    39.930     0.150
     2.435    40.680     0.150
     2.369    39.797     0.150
     2.369    69.062     0.150
     2.369    39.453     0.150
     2.369    69.500     0.150
     2.446    71.531     0.150
     2.446    40.391     0.150
     2.446    71.844     0.150
     2.550    41.633     0.150
     2.601    41.562     0.150
     2.601    42.227     0.150
     2.601    75.227     0.150
     2.758    44.547     0.150
     2.758    44.398     0.150
     2.758    84.594     0.150
     2.732    44.742     0.150
     2.732    84.906     0.150
     2.659    82.445     0.150
     2.833    45.328     0.150
     2.833    45.883     0.150
     2.833    87.023     0.150
     2.831    46.461     0.150
     2.831    46.281     0.150
     2.998    48.688     0.150
     2.998    48.875     0.150
     3.063    47.641     0.150
     3.067    48.562     0.150
     3.089    48.844     0.150
     3.013    47.008     0.150
     3.013    47.133     0.150
     3.013    93.188     0.150
     3.192    49.836     0.150
     3.211    51.062     0.150
     3.211    51.414     0.150
     3.211    89.898     0.150
     3.360    52.547     0.150
     3.360    53.031     0.150
     3.368    52.938     0.150
     3.368    53.320     0.150
     3.235    50.789     0.150
     3.388    52.930     0.150
     3.331    52.469     0.150
     3.331    52.570     0.150
     3.331    92.609     0.150
     3.370    52.297     0.150
     3.370    51.961     0.150
     3.370    92.250     0.150
     3.457    53.086     0.150
     3.729    57.758     0.150
     3.729    57.938     0.150
     3.781    60.039     0.150
     3.781    60.156     0.150
     3.781   103.812     0.150
     3.825    59.703     0.150
     3.880    60.797     0.150
     3.880    60.977     0.150
     3.773    60.430     0.150
     3.958    60.117     0.150
     3.928    59.789     0.150
     3.928    60.344     0.150
     3.855    60.117     0.150
     3.915    59.367     0.150
     3.915    59.766     0.150
     4.059    61.672     0.150
     4.116    62.711     0.150
     4.116    63.164     0.150
     4.116   111.914     0.150
     4.281    65.727     0.150
     4.281   115.695     0.150
     4.320    66.117     0.150
     4.320    65.703     0.150
     4.313    66.969     0.150
     4.313    67.234     0.150
     4.336    65.602     0.150
     4.520    67.641     0.150
     4.520    68.250     0.150
     4.520   122.281     0.150
     4.420    66.609     0.150
     4.420    66.750     0.150
     4.420   118.406     0.150
     4.560    68.953     0.150
     4.560   122.859     0.150
     4.597    69.820     0.150
     4.597   124.570     0.150
     4.641    72.008     0.150
     4.708    71.562     0.150
     4.669    71.781     0.150
     4.669    71.609     0.150
     5.044    76.961     0.150
     5.166    77.477     0.150
     5.166    78.367     0.150
     5.183    77.531     0.150
     5.183    78.586     0.150
     5.212    78.070     0.150
     5.249    80.336     0.150
     5.249    80.562     0.150
     5.270    80.188     0.150
     5.270    79.742     0.150
     5.299    78.938     0.150
     5.382    81.148     0.150
     5.450    83.008     0.150
     5.610    84.359     0.150
     5.610    84.672     0.150
     5.702    84.797     0.150
     5.702    83.062     0.150
     5.838    89.008     0.150
     5.919    88.203     0.150
     5.989    87.758     0.150
     6.032    90.258     0.150
     6.032    90.664     0.150
     6.070    90.211     0.150
     6.070    90.617     0.150
     6.106    91.086     0.150
     6.106    91.398     0.150
     6.135    91.000     0.150
     6.332    93.406     0.150
     6.377    94.648     0.150
     6.566    96.891     0.150
     6.607    98.148     0.150
     6.622    98.430     0.150
     6.700    98.500     0.150
     6.739    98.852     0.150
     6.799   100.578     0.150
     6.794   100.000     0.150
     6.891   100.617     0.150
     6.967   101.992     0.150
     7.147   102.828     0.150
     7.147   104.109     0.150
     7.265   107.148     0.150
     7.417   108.391     0.150
     7.444   109.250     0.150
     7.584   111.242     0.150
     7.740   110.867     0.150
     7.842   113.328     0.150
     7.941   114.453     0.150
     8.366   121.617     0.150
     8.438   122.617     0.150
     8.548   123.742     0.150
     8.644   124.836     0.150
     8.737   125.656     0.150
     8.801   127.008     0.150
     0.366     6.875     0.150
     0.366    12.195     0.150
     0.366     6.781     0.150
     0.366    12.016     0.150
     0.500     9.227     0.150
     0.500    16.094     0.150
     0.653    11.359     0.150
     0.653    19.797     0.150
     0.694    13.594     0.150
     0.778    14.609     0.150
     0.778    25.375     0.150
     0.898    16.719     0.150
     0.898    29.820     0.150
     0.950    17.945     0.150
     0.950    30.570     0.150
     0.950    30.758     0.150
     0.950    16.086     0.150
     0.950    30.484     0.150
     1.092    19.734     0.150
     1.092    34.219     0.150
     1.080    19.094     0.150
     1.080    33.844     0.150
     1.080    18.992     0.150
     1.080    33.680     0.150
     1.193    21.117     0.150
     1.193    37.648     0.150
     1.193    21.914     0.150
     1.201    22.125     0.150
     1.201    38.305     0.150
     1.195    21.555     0.150
     1.195    38.625     0.150
     1.195    21.828     0.150
     1.195    38.383     0.150
     1.212    21.391     0.150
     1.212    37.094     0.150
     1.333    24.945     0.150
     1.253    23.477     0.150
     1.301    23.711     0.150
     1.301    41.164     0.150
     1.348    23.445     0.150
     1.348    41.969     0.150
     1.640    29.375     0.150
     1.640    51.430     0.150
     1.714    29.641     0.150
     1.714    52.461     0.150
     1.739    30.195     0.150
     1.748    30.328     0.150
     1.748    30.789     0.150
     1.748    54.359     0.150
     1.777    31.180     0.150
     1.777    30.922     0.150
     1.809    31.859     0.150
     1.809    31.383     0.150
     1.809    55.875     0.150
     1.836    31.148     0.150
     1.836    56.398     0.150
     1.859    30.945     0.150
     2.073    34.945     0.150
     2.073    35.625     0.150
     2.073    64.078     0.150
     2.174    35.828     0.150
     2.254    38.297     0.150
     2.254    66.602     0.150
     2.261    37.547     0.150
     2.261    67.578     0.150
     2.312    38.289     0.150
     2.312    39.344     0.150
     2.312    68.766     0.150
     2.364    38.820     0.150
     2.364    39.578     0.150
     2.364    70.141     0.150
     2.427    39.320     0.150
     2.437    39.391     0.150
     2.555    42.086     0.150
     2.607    42.266     0.150
     2.607    42.039     0.150
     2.607    75.320     0.150
     2.729    43.969     0.150
     2.729    44.906     0.150
     2.729    84.750     0.150
     2.762    44.867     0.150
     2.762    85.250     0.150
     2.835    46.969     0.150
     2.838    46.156     0.150
     2.838    81.062     0.150
     2.827    45.164     0.150
     2.904    46.469     0.150
     2.929    48.320     0.150
     2.997    49.023     0.150
     2.997    93.281     0.150
     3.007    47.844     0.150
     3.007    53.531     0.150
     3.007    93.664     0.150
     3.065    47.180     0.150
     3.069    47.578     0.150
     3.069    49.711     0.150
     3.095    49.180     0.150
     3.207    50.445     0.150
     3.363    53.156     0.150
     3.364    52.141     0.150
     3.364    52.406     0.150
     3.364   104.023     0.150
     3.373    53.031     0.150
     3.373    53.297     0.150
     3.373    93.859     0.150
     3.392    54.328     0.150
     3.779    59.984     0.150
     3.779   104.070     0.150
     3.880    60.898     0.150
     4.640    72.031     0.150
     5.248    80.820     0.150
     0.318     6.523     0.150
     0.318    11.695     0.150
     0.462    16.594     0.150
     0.533    10.336     0.150
     0.533    17.875     0.150
     0.533    10.141     0.150
     0.533    17.633     0.150
     0.777    14.961     0.150
     0.777    26.109     0.150
     0.797    15.227     0.150
     0.797    26.625     0.150
     0.797    27.094     0.150
     0.934    17.109     0.150
     0.934    29.859     0.150
     0.934    16.930     0.150
     0.934    29.070     0.150
     0.955    17.922     0.150
     1.062    20.273     0.150
     1.146    20.750     0.150
     1.146    35.500     0.150
     1.146    36.227     0.150
     1.208    22.055     0.150
     1.208    22.203     0.150
     1.208    38.375     0.150
     1.228    21.609     0.150
     1.228    38.352     0.150
     1.320    23.797     0.150
     1.342    42.062     0.150
     1.405    25.672     0.150
     1.405    25.156     0.150
     1.470    25.055     0.150
     1.470    44.164     0.150
     1.539    26.695     0.150
     1.625    28.062     0.150
     1.641    49.766     0.150
     1.688    29.062     0.150
     1.823    30.492     0.150
     1.823    30.602     0.150
     1.877    31.523     0.150
     1.906    31.922     0.150
     1.906    32.844     0.150
     1.956    32.375     0.150
     1.956    58.266     0.150
     1.984    33.000     0.150
     2.011    33.805     0.150
     2.011    56.805     0.150
     2.011    33.703     0.150
     2.098    34.477     0.150
     2.277    36.742     0.150
     2.273    37.023     0.150
     2.268    36.773     0.150
     2.344    38.375     0.150
     2.344    37.672     0.150
     2.436    39.414     0.150
     2.506    40.570     0.150
     2.506    40.156     0.150
     2.544    41.516     0.150
     2.613    41.461     0.150
     2.643    41.922     0.150
     2.693    42.359     0.150
     2.716    42.555     0.150
     2.755    43.547     0.150
     2.809    44.461     0.150
     2.845    44.703     0.150
     2.812    44.414     0.150
     3.102    48.445     0.150
     3.190    49.977     0.150
     3.190    49.875     0.150
     3.218    50.180     0.150
     3.337    50.727     0.150
     3.624    55.984     0.150
     3.660    56.812     0.150
     3.687    57.930     0.150
     4.006    61.180     0.150
     4.108    62.703     0.150
     4.110    62.273     0.150
     4.375    66.180     0.150
     4.666    70.203     0.150
     4.812    72.555     0.150
     5.757    84.477     0.150
     6.262    93.016     0.150
     6.282    92.656     0.150
     7.318   106.656     0.150
     0.249     4.495     0.150
     0.249     8.115     0.150
     0.431     8.305     0.150
     0.586    10.685     0.150
     0.586    18.575     0.150
     0.591    11.455     0.150
     0.591    19.555     0.150
     0.679    11.745     0.150
     0.679    21.205     0.150
     0.720    12.725     0.150
     0.802    14.475     0.150
     0.828    14.925     0.150
     0.828    26.385     0.150
     0.945    17.645     0.150
     0.887    16.835     0.150
     0.887    28.765     0.150
     0.927    16.735     0.150
     0.927    29.725     0.150
     0.933    17.285     0.150
     0.933    30.335     0.150
     1.028    18.035     0.150
     1.064    18.435     0.150
     1.061    19.195     0.150
     1.126    21.225     0.150
     1.370    24.155     0.150
     1.395    23.695     0.150
     1.380    25.705     0.150
     1.450    44.795     0.150
     1.468    26.445     0.150
     1.517    27.725     0.150
     1.517    48.125     0.150
     1.622    28.835     0.150
     1.622    51.225     0.150
     1.650    29.055     0.150
     1.650    51.055     0.150
     1.727    29.675     0.150
     1.753    29.895     0.150
     1.779    30.825     0.150
     1.860    32.345     0.150
     1.920    32.285     0.150
     1.885    32.995     0.150
     2.025    35.585     0.150
     2.071    34.275     0.150
     2.042    35.475     0.150
     2.089    35.345     0.150
     2.185    36.295     0.150
     2.174    38.105     0.150
     2.323    37.995     0.150
     2.372    39.465     0.150
     2.387    39.215     0.150
     2.557    42.285     0.150
     2.752    44.495     0.150
     2.810    45.585     0.150
     2.783    45.405     0.150
     2.816    45.345     0.150
     2.864    45.815     0.150
     2.836    45.585     0.150
     2.919    47.225     0.150
     2.969    47.685     0.150
     2.950    48.045     0.150
     2.950    47.665     0.150
     2.956    48.165     0.150
     2.984    46.765     0.150
     3.012    47.665     0.150
     2.983    48.115     0.150
     3.206    50.845     0.150
     3.396    53.765     0.150
     3.396    53.875     0.150
     3.484    55.845     0.150
     3.539    56.205     0.150
     3.879    60.255     0.150
     5.045    77.185     0.150
     7.444   109.095     0.150
     0.384     7.223     0.150
     0.384    12.152     0.150
     0.484     8.781     0.150
     0.485     8.941     0.150
     0.485    16.082     0.150
     0.714    12.500     0.150
     0.714    22.051     0.150
     0.776    14.371     0.150
     0.776    24.340     0.150
     0.870    15.281     0.150
     0.935    17.520     0.150
     0.935    28.840     0.150
     0.975    18.320     0.150
     0.975    31.500     0.150
     1.008    17.359     0.150
     1.008    32.371     0.150
     1.148    20.562     0.150
     1.148    36.242     0.150
     1.226    21.480     0.150
     1.198    22.000     0.150
     1.198    38.051     0.150
     1.263    22.352     0.150
     1.247    22.770     0.150
     1.247    39.820     0.150
     1.373    25.383     0.150
     1.274    23.652     0.150
     1.274    40.711     0.150
     1.614    28.070     0.150
     1.664    28.840     0.150
     1.664    51.312     0.150
     1.699    30.723     0.150
     1.699    52.441     0.150
     1.770    31.410     0.150
     1.795    31.562     0.150
     1.795    55.109     0.150
     1.799    31.699     0.150
     1.799    55.812     0.150
     2.128    36.633     0.150
     2.263    38.391     0.150
     2.263    67.961     0.150
     2.357    39.801     0.150
     2.357    69.250     0.150
     2.348    39.223     0.150
     3.042    85.742     0.150
     3.219    52.242     0.150
     3.824    60.551     0.150
     3.824   105.000     0.150
     3.932    61.539     0.150
     3.932   106.852     0.150
     4.681    72.723     0.150
     5.292    81.582     0.150
     0.375     7.227     0.150
     0.375    12.687     0.150
     0.434     8.427     0.150
     0.434    14.557     0.150
     0.503     9.437     0.150
     0.503    16.477     0.150
     0.768    14.527     0.150
     0.768    25.227     0.150
     0.747    14.127     0.150
     0.747    24.527     0.150
     0.871    15.397     0.150
     0.871    26.987     0.150
     1.023    18.337     0.150
     1.023    32.327     0.150
     1.013    18.777     0.150
     1.013    32.467     0.150
     1.075    19.917     0.150
     1.075    34.807     0.150
     1.171    20.317     0.150
     1.171    37.097     0.150
     1.157    21.077     0.150
     1.157    36.707     0.150
     1.177    22.097     0.150
     1.177    37.657     0.150
     1.277    23.117     0.150
     1.299    41.227     0.150
     1.354    24.497     0.150
     1.354    42.867     0.150
     1.343    24.927     0.150
     1.447    26.817     0.150
     1.421    25.347     0.150
     1.421    44.287     0.150
     1.577    48.427     0.150
     1.737    30.467     0.150
     1.737    53.777     0.150
     1.774    30.477     0.150
     1.774    53.637     0.150
     1.782    31.337     0.150
     1.782    55.347     0.150
     1.825    30.967     0.150
     1.825    55.417     0.150
     1.841    32.187     0.150
     1.841    56.387     0.150
     1.919    58.097     0.150
     1.957    33.947     0.150
     1.957    58.737     0.150
     2.244    66.537     0.150
     2.291    38.617     0.150
     2.291    67.257     0.150
     2.265    38.007     0.150
     2.265    67.407     0.150
     2.447    70.897     0.150
     2.509    72.117     0.150
     2.691    75.687     0.150
     2.837    87.147     0.150
     3.131    49.437     0.150
     3.131    87.417     0.150
     3.210    51.257     0.150
     3.210    89.667     0.150
     3.229    90.447     0.150
     3.909    60.847     0.150
     3.909   105.907     0.150
     4.045    62.637     0.150
     4.045   109.417     0.150
     4.249   130.997     0.150
     4.279    65.557     0.150
     4.756    72.257     0.150
     4.756   127.697     0.150
     5.373   141.787     0.150
     5.442   144.147     0.150
     6.220    92.227     0.150
     6.220   161.117     0.150
     0.413     7.969     0.150
     0.413    14.117     0.150
     0.413     7.656     0.150
     0.413    13.633     0.150
     0.572    11.086     0.150
     0.572    18.539     0.150
     0.650    10.609     0.150
     0.650    10.500     0.150
     0.689    12.039     0.150
     0.689    21.430     0.150
     0.689    11.922     0.150
     0.767    13.047     0.150
     0.814    14.688     0.150
     0.814    24.773     0.150
     0.838    15.219     0.150
     0.838    27.422     0.150
     0.841    15.539     0.150
     0.841    27.312     0.150
     0.876    16.289     0.150
     0.990    16.586     0.150
     1.088    20.023     0.150
     1.002    18.898     0.150
     1.002    33.102     0.150
     1.087    18.750     0.150
     1.170    21.953     0.150
     1.184    22.023     0.150
     1.207    22.117     0.150
     1.207    37.961     0.150
     1.331    22.500     0.150
     1.368    23.828     0.150
     1.497    25.969     0.150
     1.488    25.523     0.150
     1.488    44.688     0.150
     1.511    25.281     0.150
     1.637    27.273     0.150
     1.819    31.172     0.150
     1.819    31.242     0.150
     1.921    33.430     0.150
     1.937    32.836     0.150
     2.003    35.078     0.150
     2.009    34.492     0.150
     2.182    35.930     0.150
     2.153    37.648     0.150
     2.351    38.188     0.150
     2.405    39.289     0.150
     2.479    41.898     0.150
     2.454    40.203     0.150
     2.785    46.117     0.150
     2.991    46.977     0.150
     3.109    55.953     0.150
     3.147    50.398     0.150
     3.155    49.508     0.150
     3.155    54.992     0.150
     3.155    96.703     0.150
     3.190    56.586     0.150
     3.190    99.086     0.150
     3.292    52.492     0.150
     3.635    58.422     0.150
     3.743    59.219     0.150
     3.777    59.242     0.150
     3.890    59.789     0.150
     4.038    63.219     0.150
     4.055    63.586     0.150
     4.901    74.891     0.150
     5.237    80.672     0.150
     0.468     9.625     0.150
     0.468    16.545     0.150
     0.547    10.564     0.150
     0.547    18.475     0.150
     0.644    12.615     0.150
     0.644    23.125     0.150
     0.702    24.615     0.150
     0.760    15.145     0.150
     0.760    25.846     0.150
     0.967    18.215     0.150
     0.967    32.506     0.150
     1.051    19.596     0.150
     1.051    33.426     0.150
     1.268    22.545     0.150
     1.336    23.855     0.150
     1.314    23.266     0.150
     1.523    26.064     0.150
     1.593    27.324     0.150
     1.713    29.096     0.150
     1.934    31.904     0.150
     1.981    33.145     0.150
     2.070    34.666     0.150
     2.327    37.086     0.150
     2.390    37.715     0.150
     2.410    39.154     0.150
     2.417    38.195     0.150
     2.711    42.805     0.150
     3.009    46.916     0.150
     3.055    48.615     0.150
     3.331    51.945     0.150
     3.323    51.445     0.150
     5.658    84.314     0.150
     5.658    84.545     0.150
     0.416     7.512     0.150
     0.419     7.684     0.150
     0.434     8.004     0.150
     0.681    13.062     0.150
     0.923    16.754     0.150
     0.923    30.473     0.150
     0.923    16.344     0.150
     0.923    30.344     0.150
     0.982    18.164     0.150
     0.982    31.965     0.150
     0.982    32.242     0.150
     0.994    18.672     0.150
     0.994    32.305     0.150
     1.068    18.895     0.150
     1.068    33.941     0.150
     1.068    19.031     0.150
     1.068    34.543     0.150
     1.200    21.402     0.150
     1.200    38.324     0.150
     1.267    22.953     0.150
     1.288    22.992     0.150
     1.288    41.395     0.150
     1.288    23.613     0.150
     1.288    40.984     0.150
     1.319    41.863     0.150
     1.319    23.164     0.150
     1.319    40.773     0.150
     1.406    26.121     0.150
     1.385    24.145     0.150
     1.465    26.004     0.150
     1.465    45.383     0.150
     1.536    26.555     0.150
     1.536    47.133     0.150
     1.535    26.812     0.150
     1.560    27.012     0.150
     1.671    29.062     0.150
     1.671    51.715     0.150
     1.671    28.273     0.150
     1.676    28.441     0.150
     1.676    29.332     0.150
     1.676    51.852     0.150
     1.745    30.402     0.150
     1.755    30.922     0.150
     1.755    55.113     0.150
     1.814    30.863     0.150
     1.854    31.965     0.150
     1.854    31.594     0.150
     1.934    32.762     0.150
     1.938    32.992     0.150
     1.955    33.254     0.150
     2.155    36.262     0.150
     2.183    36.254     0.150
     2.188    36.953     0.150
     2.187    37.395     0.150
     2.167    36.754     0.150
     2.284    38.043     0.150
     2.324    39.074     0.150
     2.324    38.871     0.150
     2.423    40.262     0.150
     2.516    40.832     0.150
     2.539    41.555     0.150
     2.558    42.172     0.150
     2.637    42.453     0.150
     2.682    42.871     0.150
     2.706    44.441     0.150
     2.793    45.363     0.150
     2.793    45.113     0.150
     2.793    49.172     0.150
     2.793    86.082     0.150
     2.883    46.363     0.150
     2.949    47.152     0.150
     3.179    49.453     0.150
     3.183    50.371     0.150
     3.187    50.031     0.150
     3.173    50.203     0.150
     3.296    51.273     0.150
     3.478    54.793     0.150
     3.484    54.883     0.150
     3.513    55.262     0.150
     3.542    55.484     0.150
     3.635    57.914     0.150
     3.650    58.121     0.150
     3.730    59.434     0.150
     3.886    61.273     0.150
     3.886    62.203     0.150
     3.980    62.102     0.150
     3.980    62.574     0.150
     4.183    64.012     0.150
     4.183    64.172     0.150
     4.227    65.004     0.150
     4.623    70.805     0.150
     4.668    71.332     0.150
     4.715    71.824     0.150
     4.820    72.922     0.150
     4.928    74.723     0.150
     5.100    77.645     0.150
     5.100   136.793     0.150
     5.100   158.242     0.150
     5.100    76.984     0.150
     5.162    77.484     0.150
     5.180    77.742     0.150
     5.305    79.703     0.150
     5.388    79.723     0.150
     5.571    83.273     0.150
     5.826    86.715     0.150
     5.826    85.043     0.150
     5.826   182.145     0.150
     5.826    86.715     0.150
     6.178    91.543     0.150
     6.235    92.555     0.150
     6.808   100.203     0.150
     7.195   104.012     0.150
     7.195   103.402     0.150
     7.332   106.332     0.150
     7.482   109.242     0.150
     7.701   112.371     0.150
     8.010   116.133     0.150
     8.595   123.734     0.150
     8.626   124.242     0.150
     8.626   218.293     0.150
     8.626   125.273     0.150
     8.626   219.434     0.150
     8.768   127.145     0.150
     9.660   138.973     0.150
    10.303   148.031     0.150
    12.139   172.566     0.150
    12.195   174.094     0.150
    21.681   289.395     0.150
    56.418  4226.836     0.150
    59.918   605.914     0.150
    60.929   611.781     0.150
    64.715   636.887     0.150
    65.448   642.258     0.150
    68.170   659.223     0.150
    88.687   774.051     0.150
   149.915  1188.938     0.150
     0.422     7.703     0.150
     0.422    14.742     0.150
     0.425     7.680     0.150
     0.431     7.961     0.150
     0.687    13.203     0.150
     0.687    24.160     0.150
     0.929    17.332     0.150
     0.929    30.051     0.150
     0.929    16.191     0.150
     0.929    30.473     0.150
     0.988    18.160     0.150
     0.988    32.062     0.150
     0.988    18.043     0.150
     0.994    32.090     0.150
     1.074    18.141     0.150
     1.074    34.410     0.150
     1.074    34.191     0.150
     1.203    21.410     0.150
     1.273    23.043     0.150
     1.273    40.012     0.150
     1.326    22.652     0.150
     1.326    41.723     0.150
     1.326    22.520     0.150
     1.326    40.711     0.150
     1.290    23.410     0.150
     1.290    41.250     0.150
     1.290    41.461     0.150
     1.290    23.551     0.150
     1.290    40.500     0.150
     1.407    26.102     0.150
     1.472    25.230     0.150
     1.472    45.590     0.150
     1.541    47.941     0.150
     1.543    26.352     0.150
     1.543    47.582     0.150
     1.567    27.262     0.150
     1.678    51.863     0.150
     1.678    28.453     0.150
     1.678    51.422     0.150
     1.669    28.883     0.150
     1.669    29.363     0.150
     1.669    52.141     0.150
     1.669    51.230     0.150
     1.751    30.430     0.150
     1.751    53.770     0.150
     1.760    31.320     0.150
     1.760    55.242     0.150
     1.820    31.492     0.150
     1.820    55.762     0.150
     1.860    33.191     0.150
     1.860    56.902     0.150
     1.860    31.641     0.150
     1.944    32.730     0.150
     1.944    33.070     0.150
     1.944    58.961     0.150
     1.941    33.012     0.150
     1.941    59.211     0.150
     1.962    33.043     0.150
     1.962    33.293     0.150
     2.161    36.371     0.150
     2.194    37.691     0.150
     2.194    37.613     0.150
     2.194    68.531     0.150
     2.291    38.301     0.150
     2.319    39.301     0.150
     2.319    39.102     0.150
     2.428    40.453     0.150
     2.428    43.812     0.150
     2.545    41.863     0.150
     2.563    42.570     0.150
     2.688    43.090     0.150
     2.700    44.672     0.150
     2.787    45.133     0.150
     2.787    44.902     0.150
     2.787    79.191     0.150
     2.956    47.652     0.150
     3.187    50.762     0.150
     3.191    50.242     0.150
     3.303    52.402     0.150
     3.484    54.770     0.150
     3.489    54.730     0.150
     3.982    62.512     0.150
     3.982   108.301     0.150
     4.140    63.930     0.150
     4.188    64.363     0.150
     4.234    65.082     0.150
     4.630    71.680     0.150
     4.675    71.301     0.150
     4.721    71.793     0.150
     4.825    73.340     0.150
     4.935    74.750     0.150
     5.093    76.516     0.150
     5.093    90.566     0.150
     5.093   157.266     0.150
     5.093    91.043     0.150
     5.832    87.109     0.150
     5.832   105.559     0.150
     5.832   184.066     0.150
     7.200   104.059     0.150
     8.627   125.543     0.150
    12.134   172.641     0.150
    65.454   641.664     0.150
    68.175   659.766     0.150
     0.509     9.791     0.150
     0.509    10.021     0.150
     0.509    16.082     0.150
     0.678    11.271     0.150
     0.678    11.621     0.150
     0.656    11.893     0.150
     0.656    21.152     0.150
     0.763    13.611     0.150
     0.763    13.752     0.150
     0.763    25.111     0.150
     0.797    13.672     0.150
     0.797    23.461     0.150
     0.797    24.381     0.150
     0.783    14.932     0.150
     0.865    15.801     0.150
     0.971    18.092     0.150
     0.971    30.801     0.150
     0.999    18.461     0.150
     0.999    31.352     0.150
     1.058    18.041     0.150
     1.058    32.611     0.150
     1.071    19.973     0.150
     1.071    19.051     0.150
     1.148    19.281     0.150
     1.148    37.182     0.150
     1.151    21.281     0.150
     1.151    36.211     0.150
     1.194    20.473     0.150
     1.194    36.881     0.150
     1.306    24.451     0.150
     1.306    41.941     0.150
     1.261    22.541     0.150
     1.261    39.691     0.150
     1.261    22.902     0.150
     1.261    39.381     0.150
     1.292    21.752     0.150
     1.292    41.691     0.150
     1.280    23.762     0.150
     1.280    41.012     0.150
     1.280    41.291     0.150
     1.306    42.062     0.150
     1.337    24.521     0.150
     1.408    23.732     0.150
     1.408    43.082     0.150
     1.525    27.582     0.150
     1.525    48.172     0.150
     1.564    26.672     0.150
     1.584    27.021     0.150
     1.584    47.301     0.150
     1.714    30.791     0.150
     1.740    31.441     0.150
     1.746    31.301     0.150
     1.918    32.992     0.150
     1.918    32.371     0.150
     1.918    58.461     0.150
     1.937    34.041     0.150
     1.929    34.021     0.150
     1.929    33.232     0.150
     1.993    34.422     0.150
     2.020    34.191     0.150
     2.192    38.643     0.150
     2.192    38.852     0.150
     2.192    64.771     0.150
     2.192    68.961     0.150
     2.272    38.342     0.150
     2.303    39.881     0.150
     2.335    38.902     0.150
     2.421    40.482     0.150
     2.409    40.502     0.150
     2.454    40.691     0.150
     2.471    41.301     0.150
     2.471    40.682     0.150
     2.471    71.912     0.150
     2.617    43.502     0.150
     2.683    45.031     0.150
     2.941    48.092     0.150
     2.944    48.201     0.150
     2.955    46.912     0.150
     2.976    46.861     0.150
     3.059    48.422     0.150
     3.059    48.592     0.150
     3.059    94.521     0.150
     3.220    51.861     0.150
     3.248    51.371     0.150
     3.385    53.621     0.150
     3.440    54.402     0.150
     3.796    60.473     0.150
     3.796   102.961     0.150
     3.796   117.201     0.150
     3.811    59.232     0.150
     3.800    59.172     0.150
     3.800    59.881     0.150
     3.800   118.961     0.150
     3.923    60.812     0.150
     3.923    61.941     0.150
     3.967    61.881     0.150
     4.133    64.832     0.150
     4.187    65.102     0.150
     4.376    67.893     0.150
     4.412    67.781     0.150
     4.446    68.412     0.150
     4.674    71.973     0.150
     5.047    76.461     0.150
     5.339    80.652     0.150
     5.339   140.332     0.150
     5.398    82.352     0.150
     5.720    86.322     0.150
     5.925    88.922     0.150
     7.501   110.322     0.150
     8.496   124.402     0.150
     0.289     5.992     0.150
     0.289    10.801     0.150
     0.485     9.922     0.150
     0.788    15.340     0.150
     0.788    26.961     0.150
     0.807    15.473     0.150
     0.807    26.840     0.150
     0.807    26.730     0.150
     1.066    19.043     0.150
     1.066    33.953     0.150
     1.066    19.250     0.150
     1.066    34.090     0.150
     1.093    20.652     0.150
     1.093    35.531     0.150
     1.106    20.270     0.150
     1.106    34.973     0.150
     1.106    35.203     0.150
     1.237    21.812     0.150
     1.237    38.602     0.150
     1.237    21.953     0.150
     1.237    38.883     0.150
     1.237    22.480     0.150
     1.237    39.582     0.150
     1.237    39.781     0.150
     1.366    25.090     0.150
     1.366    44.102     0.150
     1.374    25.211     0.150
     1.374    44.340     0.150
     1.372    24.043     0.150
     1.372    43.359     0.150
     1.372    24.293     0.150
     1.432    25.582     0.150
     1.432    26.141     0.150
     1.472    25.941     0.150
     1.472    25.230     0.150
     1.472    44.410     0.150
     1.533    27.781     0.150
     1.517    26.492     0.150
     1.517    47.051     0.150
     1.545    26.422     0.150
     1.633    28.090     0.150
     1.673    28.340     0.150
     1.673    49.520     0.150
     1.682    28.723     0.150
     1.825    30.609     0.150
     1.825    30.930     0.150
     1.825    54.961     0.150
     1.867    30.980     0.150
     1.881    31.691     0.150
     1.881    56.551     0.150
     1.928    32.562     0.150
     1.928    33.082     0.150
     1.928    34.730     0.150
     1.954    32.281     0.150
     2.016    34.262     0.150
     2.016    33.980     0.150
     2.030    34.223     0.150
     2.057    34.062     0.150
     2.073    34.062     0.150
     2.063    34.312     0.150
     2.048    33.621     0.150
     2.268    36.590     0.150
     2.291    37.141     0.150
     2.350    38.051     0.150
     2.350    38.250     0.150
     2.438    39.332     0.150
     2.595    41.891     0.150
     2.595    41.781     0.150
     2.595    46.820     0.150
     2.533    41.371     0.150
     2.696    43.320     0.150
     2.642    41.531     0.150
     2.642    41.871     0.150
     2.733    43.543     0.150
     2.747    44.000     0.150
     2.801    44.402     0.150
     2.825    44.223     0.150
     3.105    49.250     0.150
     3.117    49.922     0.150
     3.211    51.371     0.150
     3.294    51.520     0.150
     3.361    53.352     0.150
     3.483    54.102     0.150
     3.624    56.191     0.150
     3.680    57.633     0.150
     3.999    61.473     0.150
     4.097    61.980     0.150
     4.134    62.793     0.150
     4.134    63.621     0.150
     4.596    69.082     0.150
     4.619    69.270     0.150
     4.694    70.520     0.150
     4.694    71.090     0.150
     4.874    72.691     0.150
     4.929    74.551     0.150
     4.995    74.109     0.150
     5.497    80.453     0.150
     0.804    14.426     0.150
     0.804    25.047     0.150
     0.920    17.145     0.150
     0.920    30.504     0.150
     1.018    17.805     0.150
     1.018    31.117     0.150
     1.349    23.156     0.150
     1.349    40.605     0.150
     1.454    27.227     0.150
     1.454    47.285     0.150
     1.486    26.457     0.150
     1.486    46.465     0.150
     1.680    28.754     0.150
     1.680    51.117     0.150
     1.707    29.348     0.150
     1.707    51.516     0.150
     1.814    32.156     0.150
     1.814    55.617     0.150
     2.140    37.848     0.150
     2.140    63.277     0.150
     2.085    36.016     0.150
     2.085    63.977     0.150
     2.145    39.176     0.150
     3.286    59.605     0.150
     3.286   102.566     0.150
     3.628    57.965     0.150
     4.445    69.574     0.150
     0.685    12.515     0.150
     0.685    21.375     0.150
     0.776    13.495     0.150
     0.776    23.305     0.150
     0.776    13.385     0.150
     0.776    23.535     0.150
     0.858    15.815     0.150
     0.858    27.445     0.150
     0.952    17.575     0.150
     0.952    31.055     0.150
     0.952    17.755     0.150
     0.970    17.875     0.150
     0.970    30.645     0.150
     0.970    30.925     0.150
     1.045    17.715     0.150
     1.123    20.835     0.150
     1.123    36.445     0.150
     1.174    20.225     0.150
     1.281    23.935     0.150
     1.281    41.065     0.150
     1.250    22.655     0.150
     1.250    39.445     0.150
     1.250    22.915     0.150
     1.250    39.665     0.150
     1.261    23.415     0.150
     1.261    40.125     0.150
     1.261    40.625     0.150
     1.354    24.655     0.150
     1.354    43.835     0.150
     1.393    23.595     0.150
     1.393    23.485     0.150
     1.393    41.645     0.150
     1.439    24.155     0.150
     1.439    43.585     0.150
     1.439    24.165     0.150
     1.439    45.135     0.150
     1.496    27.025     0.150
     1.496    47.305     0.150
     1.554    47.785     0.150
     1.554    25.945     0.150
     1.566    26.935     0.150
     1.566    48.835     0.150
     1.566    26.805     0.150
     1.678    28.405     0.150
     1.678    52.855     0.150
     1.710    30.275     0.150
     1.710    53.605     0.150
     1.742    31.125     0.150
     1.900    32.355     0.150
     1.900    56.665     0.150
     1.899    32.465     0.150
     1.899    34.065     0.150
     1.994    61.115     0.150
     1.994    34.205     0.150
     2.005    61.015     0.150
     2.005    33.495     0.150
     2.163    37.545     0.150
     2.163    37.775     0.150
     2.255    68.075     0.150
     2.255    37.595     0.150
     2.276    38.175     0.150
     2.420    39.975     0.150
     2.466    40.535     0.150
     2.466    40.775     0.150
     2.466    73.045     0.150
     2.667    44.105     0.150
     2.667    78.565     0.150
     2.755    45.875     0.150
     2.950    46.935     0.150
     2.913    46.735     0.150
     2.916    47.275     0.150
     2.999    47.615     0.150
     3.038    47.795     0.150
     3.038    84.565     0.150
     3.038    48.165     0.150
     3.075    48.265     0.150
     3.207    50.725     0.150
     3.155    49.515     0.150
     3.196    51.265     0.150
     3.223    51.495     0.150
     3.317    52.335     0.150
     3.413    52.735     0.150
     3.403    53.295     0.150
     3.457    54.125     0.150
     3.633    56.225     0.150
     3.664    57.445     0.150
     3.664    58.365     0.150
     3.664    67.005     0.150
     3.664   114.325     0.150
     3.806    58.335     0.150
     3.789    59.245     0.150
     3.767    59.475     0.150
     3.767    60.045     0.150
     3.767   105.825     0.150
     3.900    59.755     0.150
     3.953    61.555     0.150
     3.943    61.305     0.150
     4.160    64.895     0.150
     4.365    67.575     0.150
     4.519    70.515     0.150
     4.546    70.025     0.150
     4.662    71.035     0.150
     4.875    74.305     0.150
     4.999    75.425     0.150
     5.021    75.455     0.150
     5.163    76.685     0.150
     5.447    82.185     0.150
     5.481    81.375     0.150
     5.577    82.355     0.150
     5.542    83.205     0.150
     5.706    86.055     0.150
     5.913    88.525     0.150
     5.982    88.905     0.150
     6.580    96.865     0.150
     0.561    10.125     0.150
     0.561    17.117     0.150
     0.812    15.254     0.150
     0.812    25.945     0.150
     0.910    15.445     0.150
     0.910    27.434     0.150
     0.967    18.195     0.150
     0.967    31.004     0.150
     1.076    19.484     0.150
     1.076    33.945     0.150
     1.167    19.914     0.150
     1.167    35.887     0.150
     1.199    22.215     0.150
     1.199    38.117     0.150
     1.223    22.594     0.150
     1.223    38.637     0.150
     1.338    24.914     0.150
     1.273    23.746     0.150
     1.273    40.195     0.150
     1.518    26.367     0.150
     1.518    45.996     0.150
     1.567    27.555     0.150
     1.567    47.957     0.150
     1.617    28.914     0.150
     1.617    51.125     0.150
     1.697    29.344     0.150
     1.697    51.836     0.150
     1.821    31.984     0.150
     1.821    55.746     0.150
     2.030    35.746     0.150
     2.403    40.266     0.150
     2.403    70.816     0.150
     2.947    46.965     0.150
     3.655   100.027     0.150
     3.830   119.824     0.150
     3.868    60.625     0.150
     3.868   105.805     0.150
     4.635    70.605     0.150
     4.635   124.207     0.150
     4.635   144.926     0.150
     4.693    71.895     0.150
     4.693   125.387     0.150
     5.237   161.816     0.150
     0.553     9.985     0.150
     0.553    16.565     0.150
     0.805    15.096     0.150
     0.805    26.466     0.150
     0.921    15.976     0.150
     0.921    27.936     0.150
     0.965    18.046     0.150
     0.965    31.086     0.150
     1.082    19.376     0.150
     1.082    33.886     0.150
     1.179    21.035     0.150
     1.179    35.796     0.150
     1.201    22.146     0.150
     1.201    37.815     0.150
     1.217    22.456     0.150
     1.217    38.306     0.150
     1.530    46.325     0.150
     1.578    27.995     0.150
     1.578    47.865     0.150
     1.625    28.836     0.150
     1.625    50.516     0.150
     1.810    32.046     0.150
     1.810    56.416     0.150
     2.042    34.745     0.150
     2.042    61.436     0.150
     2.394    40.245     0.150
     2.394    71.025     0.150
     4.688    71.676     0.150
     4.688   125.266     0.150
     5.226   160.155     0.150
     0.299     5.766     0.150
     0.299    10.508     0.150
     0.299    10.758     0.150
     0.878    16.309     0.150
     0.878    28.605     0.150
     0.878    16.426     0.150
     1.148    20.445     0.150
     1.148    35.105     0.150
     1.148    35.207     0.150
     1.128    21.137     0.150
     1.128    36.117     0.150
     1.333    24.246     0.150
     1.333    42.195     0.150
     1.333    42.426     0.150
     1.307    23.996     0.150
     1.307    42.219     0.150
     1.307    23.816     0.150
     1.307    41.688     0.150
     1.368    23.406     0.150
     1.368    42.586     0.150
     1.428    26.488     0.150
     1.428    45.637     0.150
     1.428    45.496     0.150
     1.419    26.387     0.150
     1.419    45.355     0.150
     1.419    25.906     0.150
     1.514    26.797     0.150
     1.514    47.027     0.150
     1.540    26.766     0.150
     1.540    46.887     0.150
     1.546    28.586     0.150
     1.722    29.227     0.150
     1.722    30.195     0.150
     1.722    51.816     0.150
     1.659    29.105     0.150
     1.659    50.648     0.150
     1.780    30.047     0.150
     1.780    54.477     0.150
     1.780    30.188     0.150
     1.780    31.066     0.150
     1.780    54.438     0.150
     1.845    30.758     0.150
     1.880    32.316     0.150
     1.880    59.078     0.150
     1.915    33.105     0.150
     1.943    32.469     0.150
     1.962    33.086     0.150
     2.161    36.625     0.150
     2.163    36.137     0.150
     2.252    37.598     0.150
     2.252    37.969     0.150
     2.252    67.906     0.150
     2.334    38.406     0.150
     2.393    39.426     0.150
     2.393    69.227     0.150
     2.486    40.355     0.150
     2.594    41.406     0.150
     2.632    42.246     0.150
     2.669    42.617     0.150
     2.687    43.406     0.150
     2.751    44.625     0.150
     2.751    44.059     0.150
     3.002    47.559     0.150
     2.940    45.969     0.150
     3.068    49.355     0.150
     3.179    49.316     0.150
     3.515    54.098     0.150
     3.535    55.258     0.150
     3.566    56.387     0.150
     3.745    58.336     0.150
     3.982    61.078     0.150
     4.117    63.238     0.150
     4.260    64.418     0.150
     4.482    66.957     0.150
     4.553    68.297     0.150
     4.772    72.027     0.150
     4.774    72.266     0.150
     4.959    75.445     0.150
     5.183    77.207     0.150
     0.505     9.707     0.150
     0.505    17.438     0.150
     0.909    16.438     0.150
     0.909    28.246     0.150
     0.909    16.816     0.150
     0.909    28.547     0.150
     0.954    31.805     0.150
     1.124    19.645     0.150
     1.124    35.586     0.150
     1.124    34.496     0.150
     1.115    37.688     0.150
     1.115    36.105     0.150
     1.175    39.195     0.150
     1.175    38.305     0.150
     1.314    22.977     0.150
     1.314    40.137     0.150
     1.299    22.926     0.150
     1.299    40.137     0.150
     1.325    22.855     0.150
     1.325    41.164     0.150
     1.342    23.926     0.150
     1.342    41.727     0.150
     1.325    25.164     0.150
     1.325    24.344     0.150
     1.325    41.996     0.150
     1.369    24.688     0.150
     1.369    24.977     0.150
     1.369    43.156     0.150
     1.477    25.504     0.150
     1.477    45.566     0.150
     1.477    25.285     0.150
     1.421    26.496     0.150
     1.421    46.355     0.150
     1.421    26.316     0.150
     1.421    44.777     0.150
     1.526    26.477     0.150
     1.526    46.336     0.150
     1.475    27.297     0.150
     1.536    26.504     0.150
     1.536    47.055     0.150
     1.535    26.395     0.150
     1.606    27.594     0.150
     1.606    48.926     0.150
     1.712    29.035     0.150
     1.719    29.117     0.150
     1.719    51.426     0.150
     1.724    29.164     0.150
     1.724    52.234     0.150
     1.693    30.938     0.150
     1.693    53.855     0.150
     1.693    29.957     0.150
     1.693    50.895     0.150
     1.734    29.387     0.150
     1.734    52.355     0.150
     1.934    32.086     0.150
     1.934    57.004     0.150
     1.961    32.387     0.150
     1.961    57.137     0.150
     1.888    32.055     0.150
     2.008    33.805     0.150
     2.008    56.586     0.150
     2.007    33.906     0.150
     2.090    61.176     0.150
     2.090    33.527     0.150
     2.295    36.426     0.150
     2.295    64.824     0.150
     2.350    37.785     0.150
     2.350    66.855     0.150
     2.416    37.656     0.150
     2.416    68.414     0.150
     2.463    38.945     0.150
     2.385    39.266     0.150
     2.453    39.445     0.150
     2.534    40.656     0.150
     2.534    71.484     0.150
     2.758    44.125     0.150
     2.861    45.266     0.150
     2.959    46.266     0.150
     3.085    48.406     0.150
     3.101    48.445     0.150
     3.101    47.438     0.150
     3.274    51.086     0.150
     3.321    51.867     0.150
     3.341    51.254     0.150
     3.382    51.875     0.150
     3.658    55.125     0.150
     3.782    56.445     0.150
     3.749    57.367     0.150
     3.822    58.836     0.150
     3.925    59.016     0.150
     3.973    61.254     0.150
     4.026    60.746     0.150
     4.065    61.816     0.150
     4.065    61.164     0.150
     4.258    63.266     0.150
     4.333    65.047     0.150
     4.335    64.688     0.150
     4.463    66.426     0.150
     4.528    67.945     0.150
     4.657    69.496     0.150
     4.841    73.145     0.150
     4.841   128.195     0.150
     4.964    73.246     0.150
     5.167    75.555     0.150
     5.201    76.957     0.150
     5.396    80.234     0.150
     5.427    80.137     0.150
     5.455    79.586     0.150
     5.782    87.164     0.150
     5.856    84.336     0.150
     0.247     3.266     0.150
     0.549     9.938     0.150
     0.563    10.680     0.150
     0.845    16.391     0.150
     0.827    15.156     0.150
     1.142    21.031     0.150
     0.985    18.609     0.150
     1.241    23.102     0.150
     1.423    26.109     0.150
     1.607    29.008     0.150
     1.698    29.859     0.150
     1.629    28.938     0.150
     2.021    34.422     0.150
     2.063    35.570     0.150
     2.032    36.383     0.150
     2.384    41.156     0.150
     2.416    42.477     0.150
     2.794    45.266     0.150
     2.889    46.445     0.150
     2.948    47.719     0.150
     3.043    48.508     0.150
     3.059    47.422     0.150
     3.053    48.859     0.150
     3.326    52.992     0.150
     3.419    55.422     0.150
     3.883    61.578     0.150
     4.074    63.180     0.150
     4.007    62.398     0.150
     4.336    66.312     0.150
     4.476    68.883     0.150
     4.517    69.180     0.150
     4.674    71.711     0.150
     4.684    71.852     0.150
     5.129    77.617     0.150
     7.101   235.586     0.150
     0.403     7.176     0.150
     0.403    12.504     0.150
     0.405     7.195     0.150
     0.405    12.395     0.150
     0.448     8.035     0.150
     0.667    12.086     0.150
     0.965    17.855     0.150
     0.965    31.273     0.150
     1.048    18.195     0.150
     1.048    31.996     0.150
     1.048    18.305     0.150
     1.048    31.875     0.150
     1.184    21.727     0.150
     1.184    37.793     0.150
     1.252    22.785     0.150
     1.252    22.484     0.150
     1.252    39.914     0.150
     1.300    23.004     0.150
     1.277    23.414     0.150
     1.277    41.633     0.150
     1.277    23.785     0.150
     1.277    41.215     0.150
     1.397    25.863     0.150
     1.397    45.125     0.150
     1.445    25.414     0.150
     1.445    45.266     0.150
     1.652    28.844     0.150
     1.652    28.355     0.150
     1.703    29.336     0.150
     1.703    52.676     0.150
     1.702    28.953     0.150
     1.702    52.906     0.150
     1.738    31.504     0.150
     1.738    54.703     0.150
     1.738    31.055     0.150
     1.694    29.926     0.150
     1.694    53.016     0.150
     1.694    30.094     0.150
     1.694    52.613     0.150
     1.795    31.113     0.150
     1.834    31.953     0.150
     1.834    56.594     0.150
     1.834    32.355     0.150
     1.834    57.004     0.150
     1.916    32.863     0.150
     1.921    32.977     0.150
     2.168    37.633     0.150
     2.168    67.516     0.150
     2.185    37.945     0.150
     2.185    65.176     0.150
     2.265    37.535     0.150
     2.334    39.883     0.150
     2.334    68.504     0.150
     2.334    39.633     0.150
     2.334    69.453     0.150
     2.406    41.516     0.150
     2.406    43.746     0.150
     2.406    70.906     0.150
     2.519    40.914     0.150
     2.539    41.555     0.150
     2.726    44.754     0.150
     2.813    45.805     0.150
     2.813    45.945     0.150
     2.930    48.195     0.150
     3.025    49.594     0.150
     3.162    50.543     0.150
     3.176    51.625     0.150
     3.459    54.945     0.150
     3.459    96.965     0.150
     3.494    55.824     0.150
     3.526    54.426     0.150
     3.879   108.094     0.150
     3.966    62.824     0.150
     3.966    62.324     0.150
     3.966   109.477     0.150
     3.966   121.977     0.150
     4.164    64.543     0.150
     4.208    65.785     0.150
     4.424    69.684     0.150
     4.441    67.605     0.150
     4.605    71.555     0.150
     4.650    71.824     0.150
     4.695    72.184     0.150
     4.747    74.664     0.150
     4.802    73.855     0.150
     4.910    75.516     0.150
     4.960    76.676     0.150
     5.163    78.074     0.150
     5.598    84.383     0.150
     3.165    50.656     0.150
     0.407     7.555     0.150
     0.407    12.789     0.150
     0.407     7.422     0.150
     0.407    13.219     0.150
     0.491     9.359     0.150
     0.491    16.602     0.150
     0.494     9.359     0.150
     0.494    16.164     0.150
     0.758    14.711     0.150
     0.758    26.109     0.150
     0.986    18.500     0.150
     0.986    31.820     0.150
     0.986    31.344     0.150
     1.061    19.422     0.150
     1.061    33.539     0.150
     1.144    19.602     0.150
     1.144    36.148     0.150
     1.144    19.836     0.150
     1.144    35.672     0.150
     1.159    21.680     0.150
     1.159    37.211     0.150
     1.159    21.312     0.150
     1.159    36.812     0.150
     1.243    22.312     0.150
     1.243    39.883     0.150
     1.243    39.211     0.150
     1.274    23.750     0.150
     1.274    40.641     0.150
     1.274    23.391     0.150
     1.311    23.992     0.150
     1.311    41.734     0.150
     1.311    24.203     0.150
     1.416    26.312     0.150
     1.416    45.016     0.150
     1.344    24.492     0.150
     1.344    43.031     0.150
     1.344    42.664     0.150
     1.399    24.289     0.150
     1.399    43.266     0.150
     1.542    26.945     0.150
     1.542    47.891     0.150
     1.751    29.984     0.150
     1.751    52.664     0.150
     1.751    54.070     0.150
     1.807    32.375     0.150
     1.807    56.102     0.150
     1.807    32.484     0.150
     1.807    56.422     0.150
     1.801    30.703     0.150
     1.801    55.109     0.150
     1.801    30.719     0.150
     1.801    53.961     0.150
     1.894    32.305     0.150
     1.894    56.320     0.150
     1.932    33.516     0.150
     1.932    56.984     0.150
     1.932    33.266     0.150
     1.932    59.570     0.150
     2.015    34.320     0.150
     2.015    60.336     0.150
     2.088    35.359     0.150
     2.266    37.766     0.150
     2.265    37.852     0.150
     2.265    63.859     0.150
     2.258    37.883     0.150
     2.262    37.398     0.150
     2.364    38.812     0.150
     2.475    44.555     0.150
     2.619    42.914     0.150
     2.618    42.500     0.150
     2.635    43.883     0.150
     2.714    44.289     0.150
     2.714    43.023     0.150
     2.714    74.516     0.150
     3.376    52.531     0.150
     3.558    55.062     0.150
     3.581    54.914     0.150
     3.576    56.422     0.150
     3.639    56.680     0.150
     4.011    62.102     0.150
     4.011    62.469     0.150
     4.011   108.836     0.150
     4.247    66.562     0.150
     4.247    76.594     0.150
     4.247    64.781     0.150
     4.307    66.242     0.150
     4.505    68.312     0.150
     4.749    71.773     0.150
     4.806    72.461     0.150
     4.806    73.422     0.150
     4.806    88.609     0.150
     4.806   124.859     0.150
     3.238    50.461     0.150
     0.408     7.641     0.150
     0.408    13.211     0.150
     0.408     7.523     0.150
     0.408    13.344     0.150
     0.500     9.484     0.150
     0.500    16.602     0.150
     0.503     9.484     0.150
     0.503    16.125     0.150
     0.766    14.945     0.150
     0.766    25.156     0.150
     0.766    14.625     0.150
     0.766    26.102     0.150
     0.982    18.516     0.150
     0.982    31.977     0.150
     0.982    31.461     0.150
     1.070    19.367     0.150
     1.070    34.062     0.150
     1.070    19.047     0.150
     1.070    33.953     0.150
     1.151    19.883     0.150
     1.151    35.805     0.150
     1.151    19.992     0.150
     1.151    36.297     0.150
     1.153    21.188     0.150
     1.153    21.016     0.150
     1.153    36.664     0.150
     1.245    22.375     0.150
     1.245    39.852     0.150
     1.245    39.484     0.150
     1.269    23.164     0.150
     1.269    40.992     0.150
     1.269    23.695     0.150
     1.269    40.633     0.150
     1.310    24.141     0.150
     1.310    42.062     0.150
     1.310    23.867     0.150
     1.414    26.406     0.150
     1.414    45.094     0.150
     1.352    24.625     0.150
     1.352    42.078     0.150
     1.352    24.211     0.150
     1.352    42.781     0.150
     1.407    44.211     0.150
     1.407    24.391     0.150
     1.414    26.258     0.150
     1.549    26.656     0.150
     1.549    48.133     0.150
     1.587    27.383     0.150
     1.587    49.414     0.150
     1.587    27.742     0.150
     1.587    48.953     0.150
     1.759    30.141     0.150
     1.759    54.484     0.150
     1.759    30.281     0.150
     1.759    52.727     0.150
     1.808    30.812     0.150
     1.808    54.414     0.150
     1.809    30.312     0.150
     1.809    56.461     0.150
     1.810    31.961     0.150
     1.810    31.422     0.150
     1.810    55.422     0.150
     1.903    32.414     0.150
     1.939    33.062     0.150
     1.939    60.328     0.150
     1.939    33.422     0.150
     1.939    58.164     0.150
     2.023    34.164     0.150
     2.026    61.188     0.150
     2.079    36.094     0.150
     2.273    37.391     0.150
     2.273    68.578     0.150
     2.273    38.078     0.150
     2.273    65.453     0.150
     2.267    37.406     0.150
     2.253    37.445     0.150
     2.253    64.625     0.150
     2.371    39.133     0.150
     2.624    42.805     0.150
     2.626    42.844     0.150
     2.630    42.625     0.150
     2.706    44.727     0.150
     2.706    43.016     0.150
     2.706    74.484     0.150
     2.706    83.602     0.150
     2.839    44.594     0.150
     3.246    52.547     0.150
     3.566    55.023     0.150
     3.569    56.992     0.150
     4.012    62.117     0.150
     4.012   108.484     0.150
     4.252    65.508     0.150
     4.252    76.516     0.150
     4.252   115.516     0.150
     4.252    64.352     0.150
     4.315    65.875     0.150
     4.808    72.188     0.150
     4.808    73.258     0.150
     4.808    87.961     0.150
     4.808   128.141     0.150
     5.017    75.328     0.150
     3.241    49.906     0.150
     0.497     9.016     0.150
     0.497    16.109     0.150
     0.736    13.195     0.150
     0.940    16.477     0.150
     0.995    19.094     0.150
     1.057    18.969     0.150
     1.177    20.094     0.150
     1.256    23.312     0.150
     1.437    24.375     0.150
     1.518    25.977     0.150
     1.552    26.695     0.150
     1.669    29.094     0.150
     1.698    29.555     0.150
     1.999    34.227     0.150
     2.102    35.562     0.150
     2.122    34.969     0.150
     2.175    36.773     0.150
     2.129    37.516     0.150
     2.282    38.445     0.150
     2.364    38.680     0.150
     2.521    41.273     0.150
     2.587    42.469     0.150
     2.897    47.984     0.150
     2.960    47.117     0.150
     2.978    47.359     0.150
     3.114    49.477     0.150
     3.179    51.125     0.150
     3.217    50.398     0.150
     3.479    55.383     0.150
     3.882    59.383     0.150
     3.912    60.133     0.150
     4.528    68.938     0.150
     1.256    24.172     0.150
     2.282    38.828     0.150
     2.282    38.969     0.150
     2.282    38.688     0.150
     2.978    47.773     0.150
     2.978    47.883     0.150
     3.988    62.383     0.150
     5.207    78.688     0.150
     5.471    82.094     0.150
     0.486     8.742     0.150
     0.645    11.562     0.150
     0.978    31.500     0.150
     0.978    17.117     0.150
     1.287    23.602     0.150
     1.356    24.617     0.150
     1.495    25.586     0.150
     1.592    27.883     0.150
     1.631    27.422     0.150
     1.631    49.602     0.150
     1.746    54.320     0.150
     1.746    31.070     0.150
     1.751    30.156     0.150
     1.926    33.141     0.150
     1.961    33.742     0.150
     2.726    46.016     0.150
     2.862    47.570     0.150
     3.166    50.141     0.150
     3.407    54.398     0.150
     3.774    59.828     0.150
     3.787    59.211     0.150
     3.768    58.820     0.150
     4.022    62.211     0.150
     4.011    62.477     0.150
     4.266    65.500     0.150
     4.573    69.742     0.150
     4.865    74.141     0.150
     5.029    74.758     0.150
     5.093    77.930     0.150
     5.379    80.469     0.150
     5.901    88.906     0.150
     6.190    92.789     0.150
     6.191    91.898     0.150
     6.622    99.766     0.150
     7.265   106.477     0.150
     7.366   108.070     0.150
     7.928   115.570     0.150
     8.421   122.547     0.150
     9.430   138.211     0.150
     9.529   139.812     0.150
    11.297   161.656     0.150
    12.714   180.641     0.150
    12.906   184.406     0.150
    15.332   218.336     0.150
    16.018   224.117     0.150
    19.938   270.578     0.150
    20.754   278.828     0.150
    29.020   359.469     0.150
    75.088   702.922     0.150
     7.265   106.688     0.150
    35.134   412.789     0.150
    39.961   456.086     0.150
    45.290   497.891     0.150
    48.595   522.789     0.150
    59.524   604.086     0.150
    60.752   610.688     0.150
    61.066   614.289     0.150
    62.798   624.688     0.150
    64.000   633.891     0.150
    65.160   640.492     0.150
    67.996   658.289     0.150
     0.504    16.188     0.150
     0.739    22.695     0.150
     0.739    13.258     0.150
     0.871    26.078     0.150
     0.871    14.898     0.150
     0.945    16.875     0.150
     0.991    18.047     0.150
     1.051    19.203     0.150
     1.261    40.766     0.150
     1.261    23.703     0.150
     1.441    26.359     0.150
     1.544    28.016     0.150
     1.521    45.906     0.150
     1.521    26.039     0.150
     1.555    26.398     0.150
     1.555    46.719     0.150
     1.671    30.016     0.150
     1.671    50.164     0.150
     1.702    30.156     0.150
     1.825    56.406     0.150
     1.825    33.328     0.150
     1.881    33.594     0.150
     1.881    59.406     0.150
     1.924    34.195     0.150
     2.001    35.273     0.150
     2.277    39.109     0.150
     2.367    40.273     0.150
     2.526    41.914     0.150
     2.591    43.125     0.150
     2.629    44.797     0.150
     3.118    49.406     0.150
     3.182    51.562     0.150
     3.216    52.766     0.150
     3.987    61.305     0.150
     3.911    62.266     0.150
     4.530    70.367     0.150
     4.989    75.219     0.150
     5.033    76.953     0.150
     6.586    97.688     0.150
     6.770    98.453     0.150
     7.337   108.492     0.150
    16.001   223.844     0.150
    19.305   267.266     0.150
    20.729   279.438     0.150
     0.502    15.281     0.150
     0.955    17.086     0.150
     0.955    30.633     0.150
     1.270    41.516     0.150
     1.270    23.586     0.150
     1.321    42.906     0.150
     1.321    24.352     0.150
     1.573    46.672     0.150
     1.805    55.102     0.150
     1.805    32.359     0.150
     1.894    58.125     0.150
     1.935    60.023     0.150
     1.935    34.023     0.150
     2.119    36.227     0.150
     2.119    64.766     0.150
     2.190    37.266     0.150
     2.148    38.195     0.150
     2.385    40.906     0.150
     2.535    41.680     0.150
     2.603    42.984     0.150
     2.650    44.227     0.150
     3.131    50.047     0.150
     3.199    50.820     0.150
     3.238    52.711     0.150
     3.508    55.250     0.150
     3.998    61.273     0.150
     3.933    62.320     0.150
     4.187    65.406     0.150
     5.000    74.930     0.150
     5.843    90.023     0.150
     5.850    87.977     0.150
     6.145    92.773     0.150
     6.835   101.406     0.150
     7.259   107.070     0.150
     7.346   108.062     0.150
     8.276   120.555     0.150
     9.351   136.625     0.150
    10.255   148.305     0.150
    11.289   162.641     0.150
     0.517     9.078     0.150
     0.669    19.789     0.150
     0.669    11.719     0.150
     0.824    13.898     0.150
     0.824    24.711     0.150
     0.903    28.336     0.150
     0.903    16.195     0.150
     0.897    16.070     0.150
     0.997    17.242     0.150
     1.148    37.805     0.150
     1.146    20.945     0.150
     1.146    36.766     0.150
     1.329    39.617     0.150
     1.357    40.898     0.150
     1.357    22.727     0.150
     1.433    26.055     0.150
     1.468    44.539     0.150
     1.468    25.828     0.150
     1.524    25.875     0.150
     1.652    27.898     0.150
     1.728    54.219     0.150
     1.728    30.922     0.150
     1.784    55.516     0.150
     1.784    31.898     0.150
     1.957    34.602     0.150
     1.927    33.961     0.150
     1.943    60.766     0.150
     1.943    35.641     0.150
     2.054    36.125     0.150
     2.030    34.789     0.150
     2.405    40.102     0.150
     2.439    41.648     0.150
     2.420    41.531     0.150
     2.612    43.797     0.150
     3.011    49.688     0.150
     3.142    50.875     0.150
     3.340    52.781     0.150
     3.313    54.680     0.150
     3.495    54.305     0.150
     3.617    56.008     0.150
     3.533    56.445     0.150
     3.640    58.078     0.150
     3.708    59.016     0.150
     3.845    59.688     0.150
     3.881    60.672     0.150
     3.965    62.531     0.150
     4.323    67.000     0.150
     4.669    72.570     0.150
     4.830    74.445     0.150
     4.875    75.805     0.150
     5.155    78.539     0.150
     5.611    83.297     0.150
     5.625    86.211     0.150
     7.148   104.797     0.150
     7.201   106.328     0.150
     8.154   119.367     0.150
     9.395   136.422     0.150
    10.210   147.781     0.150
    10.560   152.336     0.150
    10.865   157.586     0.150
    15.885   223.867     0.150
    36.892   429.617     0.150
     0.531    16.789     0.150
     0.718    22.398     0.150
     0.718    12.930     0.150
     0.923    15.836     0.150
     0.923    28.094     0.150
     0.992    16.289     0.150
     0.992    31.789     0.150
     1.002    32.594     0.150
     1.002    18.430     0.150
     1.016    31.594     0.150
     1.016    18.875     0.150
     1.307    43.250     0.150
     1.307    24.039     0.150
     1.358    43.891     0.150
     1.358    24.625     0.150
     1.492    26.844     0.150
     1.492    47.016     0.150
     1.573    47.688     0.150
     1.589    50.047     0.150
     1.608    49.664     0.150
     1.608    27.500     0.150
     1.723    52.445     0.150
     1.754    30.438     0.150
     1.754    54.008     0.150
     1.772    54.438     0.150
     1.772    31.539     0.150
     1.880    32.469     0.150
     1.931    34.047     0.150
     1.931    60.453     0.150
     1.972    61.094     0.150
     2.053    35.773     0.150
     2.156    36.797     0.150
     2.161    69.125     0.150
     2.178    37.359     0.150
     2.227    37.734     0.150
     2.232    38.188     0.150
     2.419    41.117     0.150
     2.571    41.898     0.150
     2.641    43.195     0.150
     2.675    46.664     0.150
     2.832    45.898     0.150
     3.168    50.266     0.150
     3.235    51.727     0.150
     3.260    53.195     0.150
     3.389    53.523     0.150
     4.035    61.867     0.150
     5.075    77.875     0.150
     6.538    96.555     0.150
     8.313   121.500     0.150
     8.456   122.695     0.150
     8.579   124.820     0.150
     9.625   138.945     0.150
    10.292   148.195     0.150
     0.473     8.641     0.150
     0.473    15.609     0.150
     0.642    10.617     0.150
     0.642    19.070     0.150
     0.774    12.938     0.150
     0.887    15.836     0.150
     0.887    28.016     0.150
     0.960    16.336     0.150
     0.960    28.734     0.150
     1.097    20.656     0.150
     1.107    19.016     0.150
     1.327    22.602     0.150
     1.383    44.906     0.150
     1.442    44.031     0.150
     1.485    25.070     0.150
     1.613    26.906     0.150
     1.683    53.820     0.150
     1.683    29.766     0.150
     1.737    55.570     0.150
     1.753    56.867     0.150
     1.753    31.516     0.150
     1.772    31.000     0.150
     1.897    32.961     0.150
     1.912    33.617     0.150
     1.959    62.039     0.150
     1.959    34.617     0.150
     2.005    35.289     0.150
     2.054    35.789     0.150
     2.138    37.195     0.150
     2.356    39.539     0.150
     2.394    39.719     0.150
     2.414    40.758     0.150
     2.457    74.500     0.150
     2.457    41.531     0.150
     2.550    77.945     0.150
     2.550    43.234     0.150
     2.594    46.320     0.150
     2.614    45.250     0.150
     2.712    45.102     0.150
     2.715    48.461     0.150
     2.749    81.969     0.150
     2.913    47.828     0.150
     2.962    47.945     0.150
     3.010    49.727     0.150
     3.110    51.117     0.150
     3.129    96.102     0.150
     3.172    51.680     0.150
     3.205    55.445     0.150
     3.296    52.750     0.150
     3.272    53.148     0.150
     3.445    54.016     0.150
     3.539    55.484     0.150
     3.628    57.867     0.150
     3.709    59.188     0.150
     3.799    58.984     0.150
     3.851    61.438     0.150
     3.968    62.695     0.150
     3.988    62.766     0.150
     4.300    67.219     0.150
     4.307    68.758     0.150
     4.832    74.484     0.150
     4.908    75.789     0.150
     5.137    79.695     0.150
     5.899    89.617     0.150
     6.448    97.031     0.150
     6.732    97.984     0.150
     8.120   120.328     0.150
     9.143   135.180     0.150
     9.251   136.164     0.150
    33.960   404.477     0.150
     0.480     8.477     0.150
     0.480    15.211     0.150
     1.115    21.117     0.150
     1.400    25.562     0.150
     1.400    45.008     0.150
     1.504    25.945     0.150
     1.504    45.078     0.150
     1.788    30.477     0.150
     1.930    33.641     0.150
     1.915    32.641     0.150
     2.023    35.297     0.150
     1.964    34.930     0.150
     2.037    36.086     0.150
     2.037    62.789     0.150
     2.155    36.148     0.150
     2.373    39.625     0.150
     2.413    40.859     0.150
     2.426    41.969     0.150
     2.439    40.867     0.150
     2.609    45.227     0.150
     2.719    45.391     0.150
     2.932    47.195     0.150
     2.980    48.102     0.150
     3.021    49.977     0.150
     3.145    52.617     0.150
     3.160    52.570     0.150
     3.190    50.992     0.150
     3.314    52.312     0.150
     3.291    52.891     0.150
     3.596    56.336     0.150
     3.524    56.008     0.150
     3.562    57.117     0.150
     3.641    58.172     0.150
     3.719    59.477     0.150
     3.817    58.781     0.150
     3.868    60.922     0.150
     3.978    63.047     0.150
     4.039    63.109     0.150
     3.999    63.656     0.150
     4.113    64.211     0.150
     4.069    65.227     0.150
     4.091    64.672     0.150
     4.089    63.875     0.150
     4.202    65.047     0.150
     4.187    65.820     0.150
     4.305    65.719     0.150
     4.321    66.906     0.150
     4.316    66.992     0.150
     4.319    68.445     0.150
     4.407    68.828     0.150
     4.409    69.500     0.150
     4.421    69.422     0.150
     4.588    70.992     0.150
     4.652    72.766     0.150
     4.811    72.328     0.150
     4.892    75.398     0.150
     4.842    74.516     0.150
     4.906    76.102     0.150
     5.143    77.477     0.150
     5.114    77.828     0.150
     5.152    79.375     0.150
     5.354    82.578     0.150
     5.366    81.367     0.150
     5.410    98.062     0.150
     5.512    83.328     0.150
     5.584    82.969     0.150
     5.544    83.656     0.150
     5.614    86.125     0.150
     5.646    86.281     0.150
     5.654    86.641     0.150
     5.781    86.680     0.150
     5.927    89.750     0.150
     5.912    89.578     0.150
     6.320    95.508     0.150
     6.345    95.750     0.150
     6.391    94.812     0.150
     6.409    96.125     0.150
     6.469    97.609     0.150
     6.588    97.625     0.150
     6.530    98.508     0.150
     6.793   101.656     0.150
     7.115   104.211     0.150
     7.172   106.031     0.150
     7.260   108.500     0.150
     7.242   107.922     0.150
     7.602   111.672     0.150
     7.702   112.625     0.150
     7.913   115.516     0.150
     8.253   120.562     0.150
     8.323   122.438     0.150
     9.151   135.742     0.150
     9.225   136.312     0.150
     9.286   137.766     0.150
     9.582   138.625     0.150
    10.050   145.117     0.150
    10.301   151.219     0.150
    10.544   151.758     0.150
    10.840   156.070     0.150
    11.140   159.922     0.150
    11.099   161.430     0.150
    12.421   178.086     0.150
    16.120   230.766     0.150
    20.569   278.711     0.150
    21.202   289.289     0.150
    22.434   301.211     0.150
    25.094   326.742     0.150
    34.054   407.086     0.150
    37.895   438.602     0.150
    59.222   602.219     0.150
    59.313   602.367     0.150
    59.481   604.789     0.150
    60.464   609.289     0.150
    64.242   636.062     0.150
    67.706   657.125     0.150
    67.769   657.531     0.150
    69.416   668.562     0.150
    70.476   676.578     0.150
    71.506   682.008     0.150
    73.437   693.648     0.150
    73.796   695.211     0.150
    74.647   700.242     0.150
    74.769   701.641     0.150
    74.802   702.031     0.150
    75.191   703.922     0.150
    76.318   710.117     0.150
    78.353   721.180     0.150
    78.804   724.758     0.150
    79.964   730.219     0.150
    88.280   773.359     0.150
     0.474     8.336     0.150
     0.474    14.344     0.150
     0.647    10.969     0.150
     1.103    20.648     0.150
     1.103    36.859     0.150
     1.491    25.211     0.150
     1.491    45.594     0.150
     1.777    30.625     0.150
     1.777    54.148     0.150
     1.917    33.211     0.150
     2.011    34.930     0.150
     2.144    35.469     0.150
     2.048    62.820     0.150
     2.048    34.594     0.150
     2.361    39.703     0.150
     2.400    39.711     0.150
     2.419    41.461     0.150
     2.599    44.164     0.150
     2.451    41.289     0.150
     2.715    45.281     0.150
     2.919    45.836     0.150
     2.968    47.086     0.150
     3.014    48.234     0.150
     3.302    51.773     0.150
     3.168    50.859     0.150
     3.278    51.289     0.150
     3.584    55.219     0.150
     3.633    56.469     0.150
     3.534    55.430     0.150
     3.563    57.141     0.150
     3.805    58.242     0.150
     3.712    58.703     0.150
     3.857    59.766     0.150
     3.972    61.562     0.150
     3.992    62.641     0.150
     4.101    63.375     0.150
     4.190    64.031     0.150
     4.097    64.609     0.150
     4.293    65.750     0.150
     4.310    66.742     0.150
     4.311    67.898     0.150
     4.397    68.062     0.150
     4.577    70.422     0.150
     4.640    71.133     0.150
     4.880    74.039     0.150
     4.836    72.812     0.150
     4.908    74.602     0.150
     5.142    78.383     0.150
     5.344    82.148     0.150
     5.504    82.492     0.150
     5.602    85.562     0.150
     5.640    85.352     0.150
     5.904    87.930     0.150
     6.334    95.719     0.150
     7.104   104.031     0.150
     7.239   106.570     0.150
     7.900   115.086     0.150
     8.314   121.273     0.150
     9.146   134.273     0.150
    10.293   150.266     0.150
    10.365   151.234     0.150
    17.611   246.570     0.150
    17.924   250.320     0.150
    18.493   257.500     0.150
    18.542   259.664     0.150
    18.868   261.750     0.150
    18.969   261.641     0.150
    19.642   270.133     0.150
    19.730   271.320     0.150
    20.602   280.070     0.150
    21.062   285.531     0.150
     0.515    15.578     0.150
     0.531     8.773     0.150
     0.531    16.344     0.150
     0.718    11.797     0.150
     0.861    25.953     0.150
     0.861    14.398     0.150
     1.042    33.977     0.150
     1.042    19.555     0.150
     1.141    19.703     0.150
     1.191    36.414     0.150
     1.191    20.453     0.150
     1.219    20.656     0.150
     1.326    43.516     0.150
     1.331    23.453     0.150
     1.331    40.594     0.150
     1.389    22.883     0.150
     1.389    42.609     0.150
     1.517    24.898     0.150
     1.517    45.289     0.150
     1.601    28.266     0.150
     1.662    30.133     0.150
     1.687    30.766     0.150
     1.660    28.359     0.150
     1.660    50.250     0.150
     1.789    30.609     0.150
     1.830    56.414     0.150
     1.830    31.578     0.150
     1.938    34.047     0.150
     1.867    33.703     0.150
     2.028    33.945     0.150
     2.290    38.344     0.150
     2.311    38.039     0.150
     2.165    65.453     0.150
     2.304    39.367     0.150
     2.641    43.547     0.150
     2.537    41.406     0.150
     2.824    44.875     0.150
     2.861    45.680     0.150
     3.210    49.375     0.150
     3.179    50.414     0.150
     3.482    54.617     0.150
     3.495    56.039     0.150
     3.601    57.219     0.150
     3.720    57.828     0.150
     3.743    58.828     0.150
     3.863    60.734     0.150
     4.089    62.945     0.150
     4.184    64.484     0.150
     4.197    64.859     0.150
     4.188    65.055     0.150
     4.776    72.883     0.150
     4.758    72.484     0.150
     4.725    72.828     0.150
     5.487    83.578     0.150
     5.718    86.359     0.150
     6.040    90.000     0.150
     6.239    93.047     0.150
     7.038   103.328     0.150
     9.937   143.586     0.150
     0.470     8.414     0.150
     0.470    16.266     0.150
     0.650    19.789     0.150
     0.650    10.586     0.150
     0.778    23.930     0.150
     0.880    27.180     0.150
     0.967    29.188     0.150
     1.102    36.195     0.150
     1.102    20.664     0.150
     1.303    39.086     0.150
     1.335    39.508     0.150
     1.387    45.680     0.150
     1.387    25.508     0.150
     1.450    25.047     0.150
     1.450    44.109     0.150
     1.492    44.773     0.150
     1.492    25.383     0.150
     1.620    27.164     0.150
     1.689    30.359     0.150
     1.689    53.469     0.150
     1.780    30.484     0.150
     1.780    54.055     0.150
     1.917    33.125     0.150
     2.010    35.453     0.150
     1.965    35.430     0.150
     2.046    35.594     0.150
     2.146    36.016     0.150
     2.360    39.078     0.150
     2.400    39.289     0.150
     2.423    41.539     0.150
     2.558    43.766     0.150
     2.602    44.367     0.150
     2.719    45.156     0.150
     2.722    46.633     0.150
     2.920    46.359     0.150
     2.969    47.688     0.150
     3.018    49.164     0.150
     3.118    51.227     0.150
     3.137    52.609     0.150
     3.164    51.742     0.150
     3.302    52.492     0.150
     3.279    52.125     0.150
     3.449    53.625     0.150
     3.636    58.188     0.150
     3.717    58.648     0.150
     3.804    58.188     0.150
     3.859    60.148     0.150
     3.976    62.695     0.150
     3.996    61.562     0.150
     4.029    62.859     0.150
     4.191    63.844     0.150
     4.191    66.977     0.150
     4.294    66.516     0.150
     4.312    66.805     0.150
     4.309    66.703     0.150
     4.406    69.594     0.150
     4.642    72.227     0.150
     4.799    71.797     0.150
     4.840    73.586     0.150
     4.881    74.336     0.150
     4.912    75.109     0.150
     5.131    77.758     0.150
     5.145    79.414     0.150
     5.348    81.844     0.150
     5.363    80.562     0.150
     5.363    80.055     0.150
     5.420    97.977     0.150
     5.507    84.047     0.150
     5.572    82.289     0.150
     5.605    84.773     0.150
     5.778    86.617     0.150
     5.916    88.625     0.150
     5.907    88.984     0.150
     6.083    91.227     0.150
     6.147    92.078     0.150
     6.336    95.094     0.150
     6.530    97.977     0.150
     6.592    99.047     0.150
     6.628    99.219     0.150
     6.756   100.703     0.150
     7.102   103.836     0.150
     7.160   105.430     0.150
     7.243   107.477     0.150
     7.751   114.086     0.150
     7.827   115.117     0.150
     7.916   116.180     0.150
     7.923   116.023     0.150
     8.097   118.414     0.150
     8.100   118.359     0.150
     8.160   119.414     0.150
     8.128   120.938     0.150
     8.189   119.633     0.150
     8.195   120.180     0.150
     8.240   120.656     0.150
     8.290   121.156     0.150
     8.326   121.836     0.150
     8.317   123.969     0.150
     8.318   123.312     0.150
     8.357   121.812     0.150
     8.422   123.117     0.150
     8.493   123.797     0.150
     8.911   129.914     0.150
    10.038   145.125     0.150
    10.370   151.133     0.150
    17.922   250.969     0.150
    18.698   262.219     0.150
    19.401   268.492     0.150
    19.445   267.945     0.150
    19.566   268.469     0.150
    19.638   270.625     0.150
    20.600   279.867     0.150
    21.333   287.828     0.150
    21.427   288.492     0.150
    22.442   300.188     0.150
    36.939   429.828     0.150
    37.613   435.430     0.150
     0.507     8.680     0.150
     0.507    16.211     0.150
     0.803    24.734     0.150
     0.803    13.875     0.150
     1.227    40.000     0.150
     1.227    22.844     0.150
     1.386    24.344     0.150
     1.644    27.367     0.150
     1.644    50.266     0.150
     1.932    33.539     0.150
     1.932    59.055     0.150
     1.894    33.820     0.150
     1.894    59.828     0.150
     2.060    62.891     0.150
     2.060    35.688     0.150
     2.058    37.359     0.150
     2.142    37.070     0.150
     2.299    38.914     0.150
     2.315    39.039     0.150
     2.490    41.469     0.150
     2.544    41.867     0.150
     2.555    43.180     0.150
     2.749    46.320     0.150
     2.821    45.969     0.150
     3.067    49.031     0.150
     3.034    49.461     0.150
     3.122    49.875     0.150
     3.048    48.578     0.150
     3.143    51.484     0.150
     3.447    53.781     0.150
     3.428    54.531     0.150
     3.383    53.258     0.150
     3.618    58.188     0.150
     3.735    58.320     0.150
     3.777    59.531     0.150
     3.838    59.914     0.150
     3.944    60.156     0.150
     4.013    62.719     0.150
     3.955    61.906     0.150
     4.092    63.867     0.150
     4.062    64.609     0.150
     4.123    64.945     0.150
     4.254    65.984     0.150
     4.341    66.445     0.150
     4.448    68.547     0.150
     4.466    68.867     0.150
     4.460    68.906     0.150
     4.447    69.469     0.150
     4.547    70.555     0.150
     4.732    72.547     0.150
     4.942    74.367     0.150
     4.960    76.008     0.150
     5.033    76.648     0.150
     5.279    79.117     0.150
     5.292    79.875     0.150
     5.266    94.930     0.150
     5.493    83.781     0.150
     5.490    82.297     0.150
     5.490    82.125     0.150
     5.544    82.438     0.150
     5.643    84.461     0.150
     5.672    84.359     0.150
     5.713    84.461     0.150
     5.758    86.844     0.150
     5.756    85.906     0.150
     5.905    88.000     0.150
     6.069    91.141     0.150
     6.045    89.781     0.150
     6.460    96.180     0.150
     6.489    96.984     0.150
     6.545    97.875     0.150
     6.612    97.805     0.150
     6.631   100.000     0.150
     6.660    99.305     0.150
     7.224   105.688     0.150
     7.296   107.656     0.150
     7.334   108.789     0.150
     7.395   109.719     0.150
     7.627   112.516     0.150
     7.744   113.156     0.150
     8.248   121.688     0.150
     8.373   122.430     0.150
     8.456   125.625     0.150
     9.170   133.047     0.150
     9.258   136.484     0.150
     9.366   137.828     0.150
     9.516   137.891     0.150
    10.474   153.570     0.150
    11.243   160.766     0.150
    12.124   175.156     0.150
    12.466   179.227     0.150
    17.771   247.570     0.150
    20.448   277.875     0.150
    22.291   298.289     0.150
    22.547   299.797     0.150
    59.358   603.117     0.150
     0.509     8.807     0.150
     0.509    16.187     0.150
     0.793    13.667     0.150
     0.793    24.387     0.150
     0.809    25.497     0.150
     0.809    14.567     0.150
     0.901    29.197     0.150
     0.901    16.007     0.150
     0.939    17.717     0.150
     0.939    30.657     0.150
     1.112    18.797     0.150
     1.075    33.847     0.150
     1.075    19.617     0.150
     1.222    40.817     0.150
     1.222    22.607     0.150
     1.251    21.627     0.150
     1.448    43.737     0.150
     1.448    24.647     0.150
     1.479    44.947     0.150
     1.479    25.447     0.150
     1.593    48.907     0.150
     1.636    26.937     0.150
     1.636    49.837     0.150
     1.763    52.277     0.150
     1.826    57.877     0.150
     1.922    58.687     0.150
     1.922    33.117     0.150
     1.904    33.437     0.150
     1.904    59.007     0.150
     2.050    34.717     0.150
     2.053    35.807     0.150
     2.048    64.977     0.150
     2.048    36.457     0.150
     2.137    37.157     0.150
     2.289    38.387     0.150
     2.320    39.197     0.150
     2.485    41.247     0.150
     2.537    42.467     0.150
     2.544    43.097     0.150
     2.739    46.277     0.150
     2.810    46.167     0.150
     2.814    46.707     0.150
     3.060    48.907     0.150
     3.044    49.687     0.150
     3.114    49.897     0.150
     3.058    48.867     0.150
     3.132    51.167     0.150
     3.278    54.227     0.150
     3.440    53.527     0.150
     3.394    54.247     0.150
     3.421    54.017     0.150
     3.570    55.717     0.150
     3.609    58.217     0.150
     3.727    58.597     0.150
     3.766    59.717     0.150
     3.828    59.737     0.150
     3.938    60.987     0.150
     4.003    63.427     0.150
     3.966    62.037     0.150
     4.082    63.147     0.150
     4.112    64.317     0.150
     4.174    65.867     0.150
     4.246    66.047     0.150
     4.333    66.407     0.150
     4.439    68.877     0.150
     4.437    69.727     0.150
     4.450    68.967     0.150
     4.456    68.277     0.150
     4.537    70.507     0.150
     4.723    72.317     0.150
     4.787    73.907     0.150
     4.935    74.137     0.150
     4.949    75.817     0.150
     5.025    76.897     0.150
     5.272    78.637     0.150
     5.275    95.537     0.150
     5.491    84.587     0.150
     5.479    81.837     0.150
     5.533    84.367     0.150
     5.632    85.747     0.150
     5.748    87.677     0.150
     5.745    87.997     0.150
     5.894    88.367     0.150
     5.976    89.777     0.150
     6.227    93.207     0.150
     6.290    93.847     0.150
     6.306    95.337     0.150
     6.469    97.477     0.150
     6.479    97.127     0.150
     6.564    98.117     0.150
     6.567    99.147     0.150
     6.602    98.207     0.150
     6.731   100.207     0.150
     6.670    99.327     0.150
     7.220   105.387     0.150
     7.290   107.367     0.150
     7.324   108.437     0.150
     7.616   112.957     0.150
     8.044   117.457     0.150
     8.281   120.987     0.150
     8.368   122.347     0.150
     8.446   125.787     0.150
     8.552   126.047     0.150
     9.331   137.717     0.150
     9.339   138.017     0.150
     9.743   143.337     0.150
    10.110   147.627     0.150
    10.180   146.847     0.150
    10.463   152.777     0.150
    15.290   216.027     0.150
    15.963   223.147     0.150
    16.173   227.907     0.150
    17.465   245.697     0.150
    17.781   250.197     0.150
    18.644   258.397     0.150
    21.081   287.577     0.150
    21.189   287.717     0.150
    21.896   294.477     0.150
    21.957   296.177     0.150
    21.952   295.367     0.150
    22.301   299.277     0.150
    23.174   305.657     0.150
    23.186   305.217     0.150
    68.820   664.487     0.150
     0.534     9.325     0.150
     0.534    15.875     0.150
     0.685    11.795     0.150
     0.685    20.705     0.150
     1.171    21.555     0.150
     1.123    21.035     0.150
     1.544    25.955     0.150
     1.812    31.655     0.150
     1.979    34.355     0.150
     1.941    35.435     0.150
     2.077    36.325     0.150
     2.015    35.315     0.150
     2.181    37.245     0.150
     2.428    40.965     0.150
     2.427    42.165     0.150
     2.461    41.405     0.150
     2.389    40.505     0.150
     2.624    45.445     0.150
     2.978    48.355     0.150
     3.017    49.125     0.150
    15.382   218.545     0.150
    15.908   223.975     0.150
    16.084   228.015     0.150
    17.323   245.935     0.150
    17.571   246.235     0.150
    17.894   251.625     0.150
    18.150   253.935     0.150
    18.214   254.365     0.150
    20.200   277.565     0.150
    20.355   278.655     0.150
    20.468   280.425     0.150
    21.214   287.815     0.150
    21.294   288.195     0.150
    21.362   289.185     0.150
    21.453   290.875     0.150
    21.464   291.725     0.150
    22.314   299.085     0.150
    25.034   327.555     0.150
    25.901   335.865     0.150
    26.850   344.205     0.150
    28.826   359.335     0.150
    34.044   407.575     0.150
    34.835   412.145     0.150
    40.155   455.885     0.150
    40.554   460.795     0.150
    40.587   460.545     0.150
    40.780   462.025     0.150
    41.714   470.765     0.150
    41.901   471.865     0.150
    59.343   603.435     0.150
    59.490   605.035     0.150
    60.455   609.955     0.150
    60.455   610.005     0.150
    62.523   624.415     0.150
    64.224   635.455     0.150
    64.864   639.585     0.150
    64.967   639.545     0.150
    67.698   657.735     0.150
    67.761   658.035     0.150
    68.743   664.575     0.150
    69.392   669.205     0.150
    69.392   668.945     0.150
    70.400   676.715     0.150
    73.424   693.155     0.150
    73.781   695.195     0.150
    78.365   721.565     0.150
    79.924   730.175     0.150
     2.389    40.705     0.150
     3.524    57.465     0.150
     5.671    84.955     0.150
     7.171   105.465     0.150
     8.224   120.565     0.150
     8.769   128.825     0.150
    10.290   152.105     0.150
    12.880   184.085     0.150
    17.894   252.275     0.150
    18.662   260.845     0.150
    20.612   281.755     0.150
    21.362   288.835     0.150
    21.294   288.855     0.150
    22.314   299.755     0.150
    22.821   306.105     0.150
    23.753   313.435     0.150
    23.753   313.955     0.150
    23.717   314.825     0.150
    24.919   326.305     0.150
    25.475   331.075     0.150
    27.943   353.085     0.150
    28.389   356.215     0.150
    30.129   371.935     0.150
    30.639   376.375     0.150
    34.044   407.715     0.150
    34.835   411.725     0.150
    34.878   413.465     0.150
    36.591   427.895     0.150
    36.645   429.905     0.150
    36.874   430.835     0.150
    36.819   430.435     0.150
    37.603   435.305     0.150
    38.062   439.505     0.150
    39.933   456.225     0.150
    40.155   456.835     0.150
    40.780   463.095     0.150
    40.786   464.815     0.150
    41.052   467.075     0.150
    41.901   472.525     0.150
    42.141   474.135     0.150
    42.529   477.645     0.150
    49.936   534.265     0.150
    50.769   540.715     0.150
    51.906   549.705     0.150
    52.703   554.985     0.150
    53.490   561.545     0.150
    53.564   561.715     0.150
    54.208   566.265     0.150
    54.842   570.865     0.150
    56.574   583.425     0.150
    56.657   583.945     0.150
    57.033   586.385     0.150
    57.187   587.865     0.150
    58.040   596.615     0.150
    58.834   598.845     0.150
    58.929   599.725     0.150
    59.231   603.255     0.150
    59.665   605.505     0.150
    59.824   606.355     0.150
    60.845   613.165     0.150
    61.308   616.495     0.150
    63.380   630.925     0.150
    64.224   635.955     0.150
    64.864   639.475     0.150
    64.967   640.355     0.150
    65.243   642.825     0.150
    66.076   647.625     0.150
    66.348   649.715     0.150
    66.769   652.745     0.150
    66.914   653.425     0.150
    67.095   655.065     0.150
    67.129   654.965     0.150
    67.284   656.155     0.150
    67.344   656.565     0.150
    67.553   658.065     0.150
    67.572   658.025     0.150
    67.761   657.935     0.150
    67.769   659.585     0.150
    67.866   659.575     0.150
    67.960   660.975     0.150
    68.060   663.295     0.150
    68.101   661.345     0.150
    68.183   661.655     0.150
    68.263   662.455     0.150
    68.346   662.635     0.150
    68.348   662.895     0.150
    68.364   663.035     0.150
    68.423   662.965     0.150
    68.429   663.225     0.150
    68.438   663.455     0.150
    68.496   664.365     0.150
    68.496   663.795     0.150
    68.540   664.015     0.150
    68.537   663.885     0.150
    68.552   664.445     0.150
    68.625   664.845     0.150
    68.681   664.665     0.150
    68.818   665.815     0.150
    68.826   665.739     0.150
    68.937   666.715     0.150
    68.968   666.625     0.150
    69.251   668.265     0.150
    69.843   673.045     0.150
    70.137   674.385     0.150
    70.400   676.425     0.150
    70.409   675.885     0.150
    70.410   675.925     0.150
    70.425   676.155     0.150
    70.510   677.105     0.150
    70.622   677.948     0.150
    70.622   677.205     0.150
    70.682   677.415     0.150
    70.716   677.715     0.150
    70.785   677.475     0.150
    71.050   679.395     0.150
    71.053   679.595     0.150
    71.233   680.186     0.150
    71.256   680.665     0.150
    71.363   682.035     0.150
    71.493   682.724     0.150
    71.574   683.633     0.150
    71.729   684.813     0.150
    71.749   686.144     0.150
    72.136   685.445     0.150
    72.164   687.500     0.150
    72.187   686.065     0.150
    72.215   685.239     0.150
    72.228   686.604     0.150
    72.446   687.263     0.150
    72.585   689.175     0.150
    72.806   690.336     0.150
    72.867   691.231     0.150
    73.018   691.828     0.150
    73.060   692.384     0.150
    73.095   691.903     0.150
    73.095   691.205     0.150
    73.257   693.159     0.150
    73.312   692.575     0.150
    73.302   692.987     0.150
    73.327   692.805     0.150
    73.368   693.355     0.150
    73.380   694.664     0.150
    73.424   694.155     0.150
    73.424   693.845     0.150
    73.425   693.935     0.150
    73.497   693.745     0.150
    73.635   694.855     0.150
    73.711   695.195     0.150
    73.728   695.913     0.150
    74.196   699.277     0.150
    74.204   698.925     0.150
    74.612   701.975     0.150
    74.690   701.135     0.150
    74.755   701.415     0.150
    75.184   703.460     0.150
    75.177   704.155     0.150
    75.812   707.755     0.150
    75.827   707.645     0.150
    76.661   712.455     0.150
    77.020   715.265     0.150
    78.338   721.555     0.150
    79.744   730.943     0.150
    80.517   734.385     0.150
    83.984   753.085     0.150
    86.128   762.795     0.150
    87.913   771.305     0.150
    87.976   771.795     0.150
    87.975   771.815     0.150
    91.187   785.565     0.150
    91.549   789.675     0.150
    99.733   826.235     0.150
   101.470   833.145     0.150
     0.501    15.166     0.150
     0.501     8.846     0.150
     0.736    13.166     0.150
     0.736    23.846     0.150
     0.872    14.856     0.150
     0.872    25.816     0.150
     0.944    16.186     0.150
     0.994    18.646     0.150
     1.053    33.526     0.150
     1.053    19.166     0.150
     1.261    23.556     0.150
     1.261    41.156     0.150
     1.521    25.906     0.150
     1.521    46.206     0.150
     1.543    28.186     0.150
     1.543    50.426     0.150
     1.556    26.726     0.150
     1.556    47.506     0.150
     1.672    29.026     0.150
     1.672    51.546     0.150
     1.702    28.116     0.150
     1.881    33.486     0.150
     1.881    59.406     0.150
     1.924    34.146     0.150
     1.924    60.516     0.150
     1.927    34.406     0.150
     1.823    31.346     0.150
     1.823    56.796     0.150
     2.002    34.376     0.150
     2.002    61.906     0.150
     2.107    64.966     0.150
     2.107    36.426     0.150
     2.180    37.506     0.150
     2.129    36.736     0.150
     2.368    39.626     0.150
     2.277    38.346     0.150
     2.525    41.676     0.150
     2.591    43.126     0.150
     2.631    44.746     0.150
     3.118    49.796     0.150
    16.230   232.636     0.150
    17.699   249.856     0.150
    18.476   261.456     0.150
    20.723   283.426     0.150
    20.849   283.546     0.150
    20.995   286.356     0.150
    21.593   294.326     0.150
    22.124   297.846     0.150
    22.220   299.916     0.150
    22.410   301.686     0.150
    25.283   330.706     0.150
    25.283   330.626     0.150
    36.381   428.496     0.150
    37.959   439.026     0.150
    57.974   592.566     0.150
    69.575   669.386     0.150
     0.489     8.572     0.150
     0.489    16.122     0.150
     0.585     9.643     0.150
     0.585    17.652     0.150
     0.742    11.982     0.150
     0.928    17.152     0.150
     0.934    16.763     0.150
     0.934    30.622     0.150
     1.066    19.383     0.150
     1.241    20.963     0.150
     1.241    37.463     0.150
     1.272    21.662     0.150
     1.230    22.322     0.150
     1.230    39.812     0.150
     1.385    24.062     0.150
     1.435    23.522     0.150
     1.697    30.202     0.150
     1.715    29.062     0.150
     1.868    32.183     0.150
     1.913    33.872     0.150
     1.969    34.673     0.150
     2.082    34.732     0.150
     2.110    64.793     0.150
     2.320    68.803     0.150
     2.351    71.393     0.150
     2.537    81.522     0.150
     2.557    77.992     0.150
     2.499    76.343     0.150
     2.910    83.643     0.150
     2.956    87.412     0.150
     3.072    95.473     0.150
     3.190    90.013     0.150
     3.528   101.553     0.150
     3.796   106.272     0.150
    16.191   234.562     0.150
    21.272   287.482     0.150
    21.283   289.173     0.150
    25.112   327.103     0.150
    33.711   401.173     0.150
    36.928   431.173     0.150
    39.508   452.853     0.150
    39.509   453.812     0.150
    49.782   532.492     0.150
    57.851   591.152     0.150
    59.241   601.893     0.150
    59.241   601.452     0.150
    59.411   604.162     0.150
    60.401   608.912     0.150
    62.501   623.213     0.150
    64.186   634.933     0.150
    64.815   637.912     0.150
    67.642   656.782     0.150
    68.757   663.093     0.150
    68.752   663.202     0.150
    69.365   668.263     0.150
    69.365   668.383     0.150
    71.482   681.423     0.150
    73.738   694.793     0.150
    74.710   699.952     0.150
    76.259   709.513     0.150
    78.322   720.133     0.150
    79.933   729.803     0.150
    79.942   728.343     0.150
     0.483     8.371     0.150
     0.483    15.541     0.150
     0.619    10.271     0.150
     0.764    12.360     0.150
     0.941    15.801     0.150
     0.909    16.381     0.150
     0.930    17.591     0.150
     1.088    19.570     0.150
     1.275    21.681     0.150
     1.206    21.831     0.150
     1.305    22.201     0.150
     1.373    25.101     0.150
     1.373    44.621     0.150
     1.419    24.980     0.150
     1.668    29.820     0.150
     1.724    31.221     0.150
     1.749    29.641     0.150
     1.876    31.661     0.150
     1.897    32.940     0.150
     1.937    35.261     0.150
     1.994    34.921     0.150
    25.104   326.541     0.150
    25.466   330.061     0.150
    25.964   336.251     0.150
    30.210   372.440     0.150
    34.092   407.311     0.150
    34.351   408.541     0.150
    34.581   409.881     0.150
    34.912   413.051     0.150
    35.514   418.461     0.150
    36.695   428.241     0.150
    36.930   430.570     0.150
    37.591   436.480     0.150
    37.928   438.900     0.150
    38.650   445.360     0.150
    38.896   446.860     0.150
    39.417   451.110     0.150
    39.471   451.211     0.150
    39.474   452.860     0.150
    39.475   453.141     0.150
    40.013   457.041     0.150
    41.337   466.591     0.150
    41.797   471.491     0.150
    43.504   484.491     0.150
    45.086   497.940     0.150
    49.796   532.931     0.150
    57.865   591.461     0.150
    59.491   603.730     0.150
    60.431   609.391     0.150
    60.431   609.360     0.150
    62.524   624.201     0.150
    64.213   635.881     0.150
    64.844   638.101     0.150
    67.672   656.931     0.150
    67.736   657.311     0.150
    68.771   663.851     0.150
    68.765   663.730     0.150
    69.389   668.761     0.150
    69.389   668.730     0.150
    70.447   675.780     0.150
    71.494   681.851     0.150
    72.793   691.471     0.150
    73.765   694.891     0.150
    73.818   695.671     0.150
    74.770   701.681     0.150
    76.287   710.030     0.150
    77.346   716.841     0.150
    78.349   721.851     0.150
    78.783   725.021     0.150
    79.948   729.381     0.150
     0.510     9.145     0.150
     0.510    16.534     0.150
     0.756    13.594     0.150
     0.756    23.435     0.150
     0.859    14.854     0.150
     0.859    26.435     0.150
     0.943    31.614     0.150
     0.943    15.834     0.150
     1.048    19.404     0.150
     1.048    33.734     0.150
     1.260    41.104     0.150
     1.260    23.055     0.150
     1.302    21.694     0.150
     1.511    46.555     0.150
     1.511    25.534     0.150
     1.544    47.174     0.150
     1.544    25.994     0.150
     1.544    28.134     0.150
     1.544    50.034     0.150
     1.659    50.754     0.150
     1.659    28.454     0.150
     1.694    28.284     0.150
     1.821    30.384     0.150
     1.877    33.094     0.150
     1.836    32.174     0.150
     1.836    57.024     0.150
     1.921    60.154     0.150
     1.989    34.714     0.150
     2.110    36.444     0.150
     2.103    36.134     0.150
     2.114    36.354     0.150
     2.179    37.294     0.150
     2.278    38.234     0.150
     2.355    39.834     0.150
     2.525    41.204     0.150
     2.587    42.305     0.150
     2.614    43.515     0.150
     2.768    46.124     0.150
     2.808    46.814     0.150
     2.879    47.774     0.150
     2.975    48.314     0.150
     2.990    47.134     0.150
     3.112    49.074     0.150
     3.174    49.895     0.150
     3.200    50.844     0.150
     3.324    51.864     0.150
     7.254   105.604     0.150
     8.100   118.464     0.150
     8.617   126.084     0.150
    10.235   147.844     0.150
    10.452   151.124     0.150
    10.528   153.624     0.150
    15.356   220.454     0.150
    16.743   237.395     0.150
    17.713   248.094     0.150
    21.124   284.954     0.150
    21.425   289.834     0.150
    22.424   300.774     0.150
    27.644   352.265     0.150
     0.480     8.521     0.150
     0.480    15.501     0.150
     0.585    17.730     0.150
     0.585    10.001     0.150
     0.736    21.921     0.150
     0.736    12.501     0.150
     0.906    15.661     0.150
     0.906    27.150     0.150
     0.928    16.681     0.150
     0.928    29.451     0.150
     0.937    17.730     0.150
     0.937    31.431     0.150
     1.059    17.881     0.150
     1.060    19.181     0.150
     1.060    34.661     0.150
     1.240    38.021     0.150
     1.271    38.671     0.150
     1.236    22.521     0.150
     1.236    39.001     0.150
     1.345    44.271     0.150
     1.716    29.451     0.150
     1.864    32.561     0.150
     1.963    34.591     0.150
     1.920    34.701     0.150
     2.082    35.051     0.150
     2.110    65.431     0.150
     2.110    37.421     0.150
     2.314    38.730     0.150
     2.346    39.541     0.150
     2.363    40.951     0.150
     2.538    44.141     0.150
     2.504    78.321     0.150
     2.504    45.440     0.150
     2.670    44.730     0.150
     2.863    45.711     0.150
     2.908    47.331     0.150
     2.961    48.311     0.150
    22.200   297.601     0.150
    22.417   301.690     0.150
    22.479   300.601     0.150
    22.594   302.371     0.150
    22.602   303.591     0.150
    22.882   305.051     0.150
    22.908   306.791     0.150
    23.269   309.841     0.150
    23.671   312.381     0.150
    23.819   316.671     0.150
    24.206   315.011     0.150
    24.212   316.221     0.150
    25.121   326.271     0.150
    25.976   333.801     0.150
    26.955   345.391     0.150
    26.983   343.961     0.150
    28.864   358.881     0.150
    30.995   378.911     0.150
    33.141   397.251     0.150
    33.307   397.371     0.150
    33.461   401.101     0.150
    34.123   407.631     0.150
    34.615   409.871     0.150
    34.778   410.400     0.150
    36.334   424.641     0.150
    36.710   428.541     0.150
    36.937   430.501     0.150
    39.764   454.261     0.150
    40.890   462.721     0.150
    41.165   464.801     0.150
    41.584   469.011     0.150
    42.157   473.881     0.150
    42.199   473.871     0.150
    42.255   473.311     0.150
    42.457   475.551     0.150
    43.359   482.900     0.150
    43.536   483.961     0.150
    44.740   494.031     0.150
    46.216   507.751     0.150
    46.623   509.241     0.150
    48.452   523.591     0.150
    49.653   531.400     0.150
    49.790   532.321     0.150
    51.792   547.311     0.150
    51.974   549.081     0.150
    57.079   587.771     0.150
    57.860   591.400     0.150
    59.153   601.721     0.150
    59.240   601.911     0.150
    59.240   602.461     0.150
    60.351   609.601     0.150
    60.406   609.121     0.150
    60.406   609.121     0.150
    62.508   623.661     0.150
    62.929   626.271     0.150
    63.589   629.961     0.150
    64.193   634.371     0.150
    64.820   638.721     0.150
    67.647   656.461     0.150
    67.711   657.071     0.150
    68.473   662.461     0.150
    68.596   663.771     0.150
    68.766   663.631     0.150
    68.760   663.841     0.150
    72.190   686.471     0.150
    73.282   691.671     0.150
    73.381   692.131     0.150
    75.830   706.311     0.150
    76.024   708.081     0.150
    76.264   709.671     0.150
    77.178   714.211     0.150
    77.334   715.051     0.150
    78.327   720.891     0.150
    79.759   728.940     0.150
     0.564    18.262     0.150
     0.564    10.102     0.150
     0.597    17.981     0.150
     0.597    10.142     0.150
     0.805    13.241     0.150
     0.851    28.212     0.150
     0.851    15.831     0.150
     0.938    27.821     0.150
     0.938    16.001     0.150
     0.986    17.642     0.150
     1.110    18.201     0.150
     1.129    20.422     0.150
     1.129    38.132     0.150
     1.263    21.562     0.150
     1.286    22.021     0.150
     1.393    24.621     0.150
     1.413    46.151     0.150
     1.467    24.571     0.150
     1.596    27.021     0.150
     1.685    53.222     0.150
     2.090    35.621     0.150
     2.109    37.501     0.150
     2.333    39.291     0.150
     2.376    39.642     0.150
     2.395    40.031     0.150
     2.453    41.161     0.150
     2.906    47.222     0.150
     2.935    47.701     0.150
     2.924    47.312     0.150
     3.560    55.892     0.150
     3.805    58.962     0.150
     0.570     9.467     0.150
     0.527    16.637     0.150
     0.527    10.025     0.150
     1.083    19.945     0.150
     1.185    20.605     0.150
     1.432    24.355     0.150
     1.874    31.066     0.150
     1.980    32.535     0.150
     2.332    37.236     0.150
     2.355    37.217     0.150
     2.903    45.637     0.150
     3.254    50.326     0.150
     3.222    50.266     0.150
     3.257    50.855     0.150
     3.425    52.756     0.150
     3.284    50.115     0.150
     3.525    54.045     0.150
     3.764    57.686     0.150
     3.618    55.096     0.150
     3.783    58.426     0.150
     3.882    59.955     0.150
     4.132    62.146     0.150
     4.238    64.887     0.150
     4.312    66.557     0.150
     4.819    72.355     0.150
     4.839    73.217     0.150
     5.057    75.695     0.150
     5.269    77.727     0.150
     5.415    79.746     0.150
     5.528    81.156     0.150
     5.551    83.045     0.150
     5.849    86.346     0.150
     5.777    84.236     0.150
     6.256    92.775     0.150
     6.377    93.795     0.150
     6.438    95.205     0.150
     7.080   103.217     0.150
     7.122   104.195     0.150
     7.163   104.637     0.150
     7.400   107.535     0.150
     7.509   108.865     0.150
     7.842   113.727     0.150
     8.056   116.615     0.150
     9.202   134.275     0.150
    10.277   150.455     0.150
    11.101   158.365     0.150
    12.330   176.057     0.150
    18.260   253.336     0.150
    19.047   262.736     0.150
    19.489   266.865     0.150
    19.728   270.916     0.150
    21.383   287.217     0.150
    21.570   289.896     0.150
    23.091   307.115     0.150
    24.682   321.496     0.150
    25.084   325.486     0.150
    25.591   329.307     0.150
    25.934   334.785     0.150
    26.119   334.057     0.150
    26.700   339.486     0.150
    28.919   358.977     0.150
    29.363   363.566     0.150
    34.150   405.807     0.150
    43.159   480.855     0.150
     0.493     8.686     0.150
     0.493    14.576     0.150
     0.653    20.086     0.150
     0.653    11.146     0.150
     0.796    24.426     0.150
     0.895    16.156     0.150
     1.120    21.137     0.150
     1.120    35.877     0.150
     1.340    40.297     0.150
     1.405    25.666     0.150
     1.405    45.496     0.150
     1.453    25.336     0.150
     1.453    44.627     0.150
     1.502    26.127     0.150
     1.703    53.836     0.150
     1.703    30.717     0.150
     1.758    30.896     0.150
     1.775    57.096     0.150
     1.775    31.967     0.150
     1.782    31.217     0.150
     1.782    54.117     0.150
     1.932    59.557     0.150
     1.932    33.537     0.150
     2.027    35.727     0.150
     1.951    35.707     0.150
     2.043    36.355     0.150
     2.149    36.326     0.150
     2.377    39.867     0.150
     2.414    40.707     0.150
     2.416    41.416     0.150
     2.437    41.586     0.150
     2.932    46.746     0.150
     2.978    48.367     0.150
     3.010    49.246     0.150
     3.197    50.447     0.150
     3.315    52.186     0.150
     3.290    53.266     0.150
     3.595    56.016     0.150
     3.532    55.377     0.150
     3.548    57.656     0.150
     3.707    58.967     0.150
     3.819    58.916     0.150
     3.966    62.686     0.150
     4.111    64.377     0.150
     4.302    67.275     0.150
     4.317    67.096     0.150
     4.310    67.076     0.150
     4.585    70.936     0.150
     4.812    72.525     0.150
     4.891    75.447     0.150
     4.892    76.605     0.150
     5.502    85.127     0.150
     5.586    82.877     0.150
     5.609    86.467     0.150
     5.924    89.646     0.150
     6.630    99.227     0.150
     6.948   103.916     0.150
     7.251   110.197     0.150
     9.213   136.166     0.150
    15.427   218.186     0.150
    16.066   227.207     0.150
    34.545   410.076     0.150
    36.916   430.916     0.150
    37.893   438.867     0.150
    41.764   470.646     0.150
    43.166   482.086     0.150
    57.865   591.967     0.150
    60.452   609.166     0.150
    62.536   623.586     0.150
    64.863   639.406     0.150
    68.766   663.957     0.150
    68.772   664.207     0.150
    69.403   668.326     0.150
    69.403   667.557     0.150
    70.438   676.467     0.150
    70.463   676.037     0.150
    71.492   681.916     0.150
    73.783   695.316     0.150
     0.510     8.990     0.150
     0.510    16.000     0.150
     0.740    13.311     0.150
     0.740    22.941     0.150
     0.877    15.350     0.150
     0.877    26.881     0.150
     0.952    30.641     0.150
     0.989    18.760     0.150
     0.989    32.521     0.150
     1.045    32.971     0.150
     1.188    20.070     0.150
     1.269    23.820     0.150
     1.269    41.660     0.150
     1.315    23.150     0.150
     1.315    42.131     0.150
     1.448    24.551     0.150
     1.448    45.740     0.150
     1.527    46.080     0.150
     1.552    49.410     0.150
     1.561    46.961     0.150
     1.677    50.900     0.150
     1.709    29.131     0.150
     1.818    56.061     0.150
     1.818    32.150     0.150
     1.889    59.010     0.150
     1.932    34.191     0.150
     1.932    60.221     0.150
     1.935    33.760     0.150
     2.007    34.961     0.150
     2.007    60.830     0.150
     2.114    64.371     0.150
     2.114    36.471     0.150
     2.131    63.910     0.150
     2.131    36.611     0.150
     2.188    37.400     0.150
     2.269    38.141     0.150
     2.373    39.551     0.150
     2.534    41.621     0.150
     2.599    43.141     0.150
     2.633    44.041     0.150
     2.827    47.201     0.150
     2.893    46.551     0.150
     2.956    48.711     0.150
     2.971    47.301     0.150
     3.125    49.910     0.150
     3.189    50.451     0.150
     3.220    52.311     0.150
     3.306    52.100     0.150
     3.503    54.410     0.150
     3.490    55.090     0.150
     3.674    58.301     0.150
     3.798    58.521     0.150
     3.855    60.230     0.150
     3.915    61.740     0.150
     3.877    60.570     0.150
     3.995    61.391     0.150
     4.168    64.900     0.150
     4.201    64.541     0.150
     4.320    66.561     0.150
     4.404    67.461     0.150
     4.515    69.500     0.150
     4.525    70.500     0.150
     4.536    69.430     0.150
     4.536    69.510     0.150
     4.625    71.260     0.150
     4.802    73.721     0.150
     4.864    74.711     0.150
     5.002    76.740     0.150
     5.750    85.240     0.150
     5.982    89.211     0.150
     6.548    95.480     0.150
     6.581    97.281     0.150
    15.237   215.840     0.150
    16.218   230.230     0.150
    22.406   301.490     0.150
    25.279   329.410     0.150
    36.940   430.170     0.150
    57.969   592.211     0.150
    69.573   668.941     0.150
    69.573   668.680     0.150
     0.489     8.670     0.150
     0.489    15.238     0.150
     0.626    10.340     0.150
     0.626    18.779     0.150
     1.098    19.959     0.150
     1.098    35.529     0.150
     1.475    24.979     0.150
     1.755    30.379     0.150
     1.906    33.078     0.150
     2.003    34.988     0.150
     2.122    35.469     0.150
     2.354    38.988     0.150
     2.388    39.998     0.150
     2.394    40.760     0.150
     2.576    44.619     0.150
     2.690    44.488     0.150
     2.906    46.709     0.150
     2.950    47.559     0.150
     2.989    48.869     0.150
     3.289    51.748     0.150
     3.193    52.439     0.150
     3.263    52.229     0.150
     3.223    51.068     0.150
     3.568    55.770     0.150
     3.608    57.699     0.150
     3.557    55.699     0.150
     3.687    58.488     0.150
     3.794    58.449     0.150
     3.946    62.180     0.150
     4.084    63.289     0.150
     4.174    64.590     0.150
     4.122    63.020     0.150
     4.275    66.100     0.150
     4.290    66.520     0.150
     4.284    66.449     0.150
     4.374    68.809     0.150
     4.557    70.078     0.150
     4.622    70.549     0.150
     4.786    71.828     0.150
     4.864    73.959     0.150
     4.810    73.930     0.150
     4.888    75.389     0.150
     5.116    77.498     0.150
     5.081    77.068     0.150
    16.043   228.078     0.150
    16.476   234.920     0.150
    21.235   289.809     0.150
    36.922   429.947     0.150
    39.468   453.010     0.150
    39.469   452.889     0.150
    40.847   462.580     0.150
    57.861   591.479     0.150
    60.432   609.268     0.150
    60.432   609.268     0.150
    64.845   638.908     0.150
    67.674   657.459     0.150
    68.767   664.068     0.150
    68.761   663.939     0.150
    69.389   668.729     0.150
    69.389   668.729     0.150
    70.465   675.479     0.150
    71.489   680.779     0.150
    73.766   695.049     0.150
     0.512     9.059     0.150
     0.512    15.445     0.150
     0.618    10.668     0.150
     0.618    19.078     0.150
     1.108    20.379     0.150
     1.224    20.879     0.150
     1.474    25.078     0.150
     1.746    30.418     0.150
     1.910    33.355     0.150
     2.011    34.988     0.150
     2.114    35.758     0.150
     2.362    39.648     0.150
     2.392    40.387     0.150
     2.376    40.668     0.150
     2.668    44.676     0.150
     2.907    47.035     0.150
     2.947    48.008     0.150
     2.970    48.867     0.150
     3.292    51.727     0.150
     3.263    52.648     0.150
     3.210    52.828     0.150
     3.567    56.027     0.150
     3.593    58.066     0.150
     3.570    56.285     0.150
     3.668    58.105     0.150
     3.799    58.746     0.150
     3.926    62.148     0.150
     4.082    63.887     0.150
     4.174    64.477     0.150
     4.138    64.668     0.150
     4.271    66.016     0.150
     4.284    66.879     0.150
     4.273    66.426     0.150
     4.269    67.766     0.150
     4.238    66.406     0.150
     4.361    68.848     0.150
     4.552    69.945     0.150
     4.617    71.719     0.150
     4.789    72.078     0.150
     4.791    73.156     0.150
     4.862    74.957     0.150
     4.863    75.406     0.150
    15.452   219.809     0.150
    19.680   272.668     0.150
    20.422   281.398     0.150
    21.109   287.176     0.150
    21.252   289.617     0.150
    21.696   293.137     0.150
    25.540   332.078     0.150
    25.974   336.148     0.150
    36.900   431.129     0.150
    37.914   439.277     0.150
    38.886   448.297     0.150
    39.481   453.277     0.150
    40.657   462.156     0.150
    41.779   471.766     0.150
    57.836   591.719     0.150
    60.413   609.445     0.150
    60.413   609.445     0.150
    67.655   657.207     0.150
    67.718   657.605     0.150
    68.743   664.035     0.150
    69.366   668.637     0.150
    69.366   668.508     0.150
    70.417   676.496     0.150
    71.465   682.078     0.150
    73.745   694.777     0.150
    77.320   716.027     0.150
    79.920   730.285     0.150
     0.488    15.359     0.150
     0.609    10.160     0.150
     0.609    18.227     0.150
     0.760    24.789     0.150
     0.932    28.797     0.150
     0.926    16.969     0.150
     0.926    31.137     0.150
     1.085    19.809     0.150
     1.085    35.598     0.150
     1.207    21.488     0.150
     1.370    25.188     0.150
     1.370    44.066     0.150
     1.409    24.207     0.150
     1.409    43.090     0.150
     1.459    25.340     0.150
     1.459    45.367     0.150
     1.586    46.539     0.150
     1.586    26.438     0.150
     1.662    52.707     0.150
     1.718    54.000     0.150
     1.737    54.598     0.150
     1.737    31.539     0.150
     1.739    30.117     0.150
     1.739    52.199     0.150
     1.866    56.469     0.150
     1.890    32.277     0.150
     1.927    34.199     0.150
     1.927    60.688     0.150
     1.989    58.879     0.150
     1.989    34.238     0.150
     2.106    34.816     0.150
     2.106    62.168     0.150
     2.086    36.059     0.150
     2.086    63.148     0.150
     2.340    38.797     0.150
     2.340    67.520     0.150
     2.373    39.387     0.150
     2.373    70.609     0.150
     2.380    39.969     0.150
     2.518    74.930     0.150
     2.518    42.520     0.150
     2.477    40.508     0.150
     2.477    72.188     0.150
     2.560    44.309     0.150
     2.580    77.168     0.150
     2.718    80.109     0.150
     2.679    45.000     0.150
     2.890    46.219     0.150
     2.890    82.930     0.150
     2.934    47.367     0.150
     2.934    84.148     0.150
     2.976    48.219     0.150
     3.593    57.848     0.150
     3.674    58.508     0.150
     3.779    58.047     0.150
     4.363    69.387     0.150
     4.605    72.027     0.150
     4.771    71.879     0.150
     4.798    73.777     0.150
     5.100    77.109     0.150
     5.067    77.297     0.150
     5.545    82.129     0.150
     5.565    84.148     0.150
     5.603    85.520     0.150
     5.864    88.367     0.150
    17.384   243.199     0.150
    18.696   258.789     0.150
    20.974   283.859     0.150
    21.042   285.078     0.150
    21.408   288.859     0.150
    21.675   291.566     0.150
    22.483   301.078     0.150
    22.674   302.668     0.150
    25.103   327.078     0.150
    27.778   348.977     0.150
    32.508   391.699     0.150
    33.735   401.547     0.150
    34.589   409.680     0.150
    36.693   427.348     0.150
    36.925   430.109     0.150
    37.934   438.117     0.150
     0.568    10.164     0.150
     0.568    18.254     0.150
     0.699    21.895     0.150
     0.878    27.594     0.150
     0.878    14.734     0.150
     0.927    28.922     0.150
     0.927    16.434     0.150
     1.037    17.934     0.150
     1.037    31.082     0.150
     0.849    28.684     0.150
     0.849    15.695     0.150
     1.202    39.473     0.150
     1.202    23.062     0.150
     1.199    20.035     0.150
     1.318    22.945     0.150
     1.364    41.832     0.150
     1.388    42.613     0.150
     1.487    48.113     0.150
     1.487    27.273     0.150
     1.495    26.535     0.150
     1.565    27.004     0.150
     1.565    47.785     0.150
     1.693    49.875     0.150
     1.776    55.082     0.150
     1.835    56.953     0.150
     1.854    33.684     0.150
     1.854    59.516     0.150
     1.822    55.793     0.150
     1.822    31.766     0.150
     2.005    61.363     0.150
     2.005    34.684     0.150
     1.958    59.293     0.150
     1.925    61.105     0.150
     1.925    33.953     0.150
     2.106    36.984     0.150
     2.106    64.523     0.150
     2.008    35.293     0.150
     2.008    61.395     0.150
     2.192    66.215     0.150
     2.192    37.594     0.150
     2.457    41.016     0.150
     2.424    41.863     0.150
     2.629    45.582     0.150
     2.686    44.742     0.150
     3.001    48.344     0.150
     3.035    49.312     0.150
     3.009    48.902     0.150
     3.174    52.844     0.150
     3.167    51.422     0.150
     3.168    50.215     0.150
     3.498    56.016     0.150
     3.650    58.715     0.150
     3.990    63.766     0.150
     4.403    69.363     0.150
     4.415    69.383     0.150
     4.703    73.344     0.150
     4.789    74.035     0.150
     4.952    75.766     0.150
     4.915    75.312     0.150
     5.210    78.695     0.150
     5.109    77.934     0.150
     5.171    80.074     0.150
     5.357    80.422     0.150
     5.659    83.973     0.150
     5.652    86.832     0.150
     5.621    85.363     0.150
     5.771    87.422     0.150
     6.005    90.824     0.150
     6.063    91.555     0.150
     6.077    91.445     0.150
     6.140    92.402     0.150
     6.153    92.145     0.150
     6.194    92.145     0.150
     6.338    96.203     0.150
     6.381    95.355     0.150
     6.457    95.965     0.150
     6.370    94.832     0.150
     6.501    96.375     0.150
     6.498    96.766     0.150
     6.701   101.203     0.150
     7.268   109.453     0.150
     7.496   111.234     0.150
     7.627   112.004     0.150
     7.920   116.465     0.150
     7.975   116.715     0.150
     8.191   119.992     0.150
     8.113   117.965     0.150
    15.359   218.453     0.150
    15.618   221.055     0.150
    16.146   229.914     0.150
    16.429   234.535     0.150
    17.791   252.133     0.150
    17.830   252.016     0.150
    17.887   251.883     0.150
    18.079   251.883     0.150
    18.212   255.082     0.150
    18.509   259.625     0.150
    18.566   259.395     0.150
    18.842   261.832     0.150
    18.924   264.465     0.150
    18.974   263.434     0.150
    19.212   265.312     0.150
    19.378   269.273     0.150
    19.619   271.832     0.150
    19.700   271.434     0.150
    20.347   280.035     0.150
    20.558   280.555     0.150
    20.916   286.145     0.150
    20.979   285.523     0.150
    20.959   285.973     0.150
    21.044   287.562     0.150
    21.281   288.914     0.150
    21.330   289.543     0.150
    21.345   289.785     0.150
    21.328   287.973     0.150
    21.464   290.883     0.150
    21.586   292.152     0.150
    21.621   293.574     0.150
    21.593   293.074     0.150
    21.632   292.344     0.150
    22.132   297.594     0.150
    22.305   300.164     0.150
    22.391   301.375     0.150
    22.599   303.004     0.150
    22.756   303.242     0.150
    22.777   305.672     0.150
    22.958   305.016     0.150
    22.999   308.574     0.150
    23.129   308.695     0.150
    23.090   307.273     0.150
    23.424   312.555     0.150
    23.934   316.934     0.150
    23.962   318.516     0.150
    24.135   319.285     0.150
    25.467   331.555     0.150
    25.923   335.273     0.150
    25.968   334.922     0.150
    26.044   334.984     0.150
    26.837   344.152     0.150
    27.807   351.715     0.150
    27.945   352.793     0.150
    31.488   384.383     0.150
    33.834   402.242     0.150
    34.043   408.402     0.150
    34.484   409.105     0.150
    34.745   412.395     0.150
    36.037   423.133     0.150
    36.545   427.344     0.150
    36.910   431.234     0.150
    37.585   436.285     0.150
    37.779   439.555     0.150
    37.819   439.043     0.150
    37.819   438.844     0.150
    38.034   439.785     0.150
    38.083   441.164     0.150
    38.312   443.363     0.150
    38.566   445.414     0.150
    38.909   448.773     0.150
    39.293   451.582     0.150
    39.413   452.234     0.150
    40.661   462.094     0.150
    40.761   463.594     0.150
    40.794   465.113     0.150
    40.915   464.555     0.150
    41.030   465.812     0.150
    41.232   467.664     0.150
    41.515   470.516     0.150
    41.534   470.594     0.150
    41.576   469.934     0.150
    41.621   469.984     0.150
    41.929   473.422     0.150
    41.959   473.625     0.150
    42.586   479.273     0.150
    42.907   480.812     0.150
    43.027   480.465     0.150
    43.027   481.305     0.150
    43.395   485.355     0.150
    43.515   486.582     0.150
    44.171   491.594     0.150
    44.709   495.855     0.150
    44.988   496.613     0.150
    45.357   498.984     0.150
    45.435   500.133     0.150
    46.009   504.832     0.150
    49.742   532.734     0.150
    52.087   551.293     0.150
    53.974   566.344     0.150
    55.247   573.785     0.150
    57.809   591.234     0.150
    59.231   602.312     0.150
    60.445   609.383     0.150
    60.445   609.383     0.150
    64.852   639.305     0.150
    66.432   650.023     0.150
    67.739   659.312     0.150
    68.716   663.504     0.150
    69.374   668.504     0.150
    69.374   668.055     0.150
    70.368   675.766     0.150
    70.393   675.824     0.150
    70.840   678.574     0.150
    71.132   679.324     0.150
    71.433   681.414     0.150
     0.505    16.383     0.150
     0.505     8.980     0.150
     0.873    15.223     0.150
     0.873    26.691     0.150
     0.990    18.473     0.150
     0.990    33.250     0.150
     0.948    30.562     0.150
     1.049    19.281     0.150
     1.049    33.453     0.150
     1.183    20.070     0.150
     1.183    36.020     0.150
     1.264    41.703     0.150
     1.264    23.723     0.150
     1.310    42.422     0.150
     1.557    46.992     0.150
     1.547    49.512     0.150
     1.547    28.000     0.150
     1.673    50.441     0.150
     1.673    28.832     0.150
     1.705    28.621     0.150
     1.884    33.293     0.150
     1.884    58.012     0.150
     1.822    56.152     0.150
     1.822    31.359     0.150
     1.927    34.172     0.150
     1.927    59.930     0.150
     1.930    34.141     0.150
     1.930    59.941     0.150
     2.004    34.742     0.150
     2.004    60.910     0.150
     2.128    36.742     0.150
     2.128    67.203     0.150
     2.127    63.730     0.150
     2.110    64.109     0.150
     2.183    37.703     0.150
     2.183    65.930     0.150
     2.274    38.070     0.150
     2.274    70.281     0.150
     2.369    70.703     0.150
     2.369    39.871     0.150
     2.529    42.031     0.150
     2.529    74.312     0.150
     2.631    44.383     0.150
     2.594    75.871     0.150
     2.594    43.270     0.150
     2.824    48.203     0.150
     2.845    47.621     0.150
     2.892    47.250     0.150
     2.974    48.320     0.150
     2.958    47.941     0.150
     3.121    50.102     0.150
     3.218    52.520     0.150
     3.185    51.070     0.150
     3.309    52.383     0.150
     3.499    54.352     0.150
     3.675    58.062     0.150
     3.608    56.660     0.150
     3.853    61.062     0.150
     3.913    61.582     0.150
     3.990    61.562     0.150
     3.987    63.680     0.150
     4.532    69.922     0.150
     4.860    75.000     0.150
     5.003    77.000     0.150
     5.093    77.133     0.150
     5.201    79.262     0.150
     5.446    82.582     0.150
     5.828    88.852     0.150
     6.121    92.770     0.150
     6.955   104.000     0.150
     7.256   106.453     0.150
     7.403   109.891     0.150
     8.532   125.672     0.150
     9.235   134.180     0.150
     9.345   135.480     0.150
    10.244   147.602     0.150
    10.346   151.070     0.150
    10.545   154.633     0.150
    10.455   151.320     0.150
    11.027   160.160     0.150
    11.285   162.891     0.150
    12.892   184.992     0.150
    15.522   221.762     0.150
    16.004   225.582     0.150
    16.229   232.133     0.150
    17.122   243.352     0.150
    17.698   249.070     0.150
    18.743   261.043     0.150
    19.505   269.340     0.150
    20.162   277.203     0.150
    20.265   278.082     0.150
    20.377   278.742     0.150
    20.411   280.270     0.150
    20.722   283.332     0.150
    20.848   284.590     0.150
    21.011   286.152     0.150
    21.143   286.801     0.150
    21.262   289.082     0.150
    21.426   290.543     0.150
    21.411   289.992     0.150
    21.435   290.133     0.150
    21.787   293.910     0.150
    21.872   294.852     0.150
    21.895   294.582     0.150
    21.996   296.703     0.150
    22.219   298.520     0.150
    22.409   300.930     0.150
    22.475   302.250     0.150
    22.592   302.680     0.150
    22.622   303.852     0.150
    23.233   309.520     0.150
    23.528   313.082     0.150
    23.949   316.570     0.150
    25.282   329.609     0.150
    25.282   329.391     0.150
    27.740   351.043     0.150
    27.855   352.672     0.150
    28.116   354.609     0.150
    28.217   355.172     0.150
    37.252   433.461     0.150
    37.725   436.672     0.150
    37.956   438.910     0.150
    39.269   450.082     0.150
    39.221   451.172     0.150
    41.307   466.859     0.150
    41.623   470.543     0.150
    42.968   480.883     0.150
    45.230   498.723     0.150
    45.874   504.020     0.150
    49.907   533.883     0.150
    60.653   611.992     0.150
    62.700   625.652     0.150
     0.511     8.617     0.150
     0.632    10.488     0.150
     0.632    18.867     0.150
     0.794    25.719     0.150
     0.901    29.520     0.150
     0.901    16.988     0.150
     0.961    16.219     0.150
     0.961    29.387     0.150
     0.922    16.730     0.150
     1.118    20.070     0.150
     1.118    36.117     0.150
     1.320    22.309     0.150
     1.403    25.469     0.150
     1.432    43.637     0.150
     1.488    45.258     0.150
     1.488    24.559     0.150
     1.751    55.527     0.150
     1.760    53.527     0.150
     1.760    30.707     0.150
     1.891    57.387     0.150
     1.891    32.668     0.150
     1.922    33.250     0.150
     1.923    33.848     0.150
     2.022    35.250     0.150
     2.128    64.480     0.150
     2.128    35.688     0.150
     2.066    35.438     0.150
     2.066    65.277     0.150
     2.373    39.637     0.150
     2.389    41.707     0.150
     2.404    40.148     0.150
     2.445    40.629     0.150
     2.577    45.059     0.150
     2.678    44.770     0.150
     2.742    81.609     0.150
     2.921    46.789     0.150
     2.961    48.109     0.150
     2.983    48.480     0.150
     3.242    91.570     0.150
     3.197    52.027     0.150
     3.305    51.930     0.150
     3.221    51.027     0.150
     3.277    52.500     0.150
     3.524    55.457     0.150
     3.581    55.910     0.150
     3.607    58.078     0.150
     3.555    56.148     0.150
     3.680    58.777     0.150
     3.811    58.750     0.150
     3.938    61.160     0.150
     3.961    62.598     0.150
     4.096    63.797     0.150
     4.187    64.527     0.150
     4.124    64.879     0.150
     4.285    66.867     0.150
     4.282    67.430     0.150
     4.298    66.699     0.150
     4.225    67.180     0.150
     4.375    68.719     0.150
     4.566    70.609     0.150
     4.868    75.297     0.150
     5.328    79.328     0.150
     5.431    82.469     0.150
    15.439   218.809     0.150
    20.968   285.238     0.150
    21.019   285.629     0.150
    21.388   288.980     0.150
    21.388   289.230     0.150
    21.682   292.469     0.150
    25.072   327.688     0.150
    36.900   430.508     0.150
    37.902   438.000     0.150
    39.547   453.230     0.150
    41.347   467.770     0.150
    43.198   482.680     0.150
    43.520   485.047     0.150
    44.255   490.828     0.150
    49.773   533.098     0.150
    57.841   591.680     0.150
    60.425   609.879     0.150
    64.836   639.438     0.150
    67.667   657.930     0.150
    68.748   664.047     0.150
    70.418   676.059     0.150
     0.551    18.477     0.150
     0.643    18.957     0.150
     0.861    16.516     0.150
     1.153    20.637     0.150
     1.153    37.996     0.150
     1.332    40.375     0.150
     1.438    46.617     0.150
     1.438    26.215     0.150
     1.440    25.414     0.150
     1.508    44.266     0.150
     1.508    24.324     0.150
     1.637    27.535     0.150
     1.767    29.727     0.150
     1.767    54.766     0.150
     1.902    32.496     0.150
     1.902    57.605     0.150
     1.950    33.586     0.150
     1.950    60.195     0.150
     1.899    34.234     0.150
     2.054    35.598     0.150
     2.137    35.895     0.150
     2.061    35.207     0.150
     2.405    40.258     0.150
     2.431    40.355     0.150
     2.380    41.117     0.150
     2.945    47.746     0.150
     2.979    47.098     0.150
     2.969    47.734     0.150
     3.208    52.207     0.150
     3.299    52.355     0.150
     3.601    56.664     0.150
     3.922    61.645     0.150
     4.106    65.586     0.150
     4.142    64.527     0.150
     4.293    66.875     0.150
     4.580    70.105     0.150
     4.788    73.266     0.150
    20.968   286.215     0.150
    23.041   307.355     0.150
    24.666   321.957     0.150
    26.086   334.438     0.150
    26.893   343.535     0.150
    29.309   364.086     0.150
    29.553   366.535     0.150
    30.020   370.066     0.150
    34.091   407.016     0.150
    42.060   473.375     0.150
    59.184   602.477     0.150
     0.507     9.203     0.150
     0.507    16.137     0.150
     0.774    13.645     0.150
     0.774    23.816     0.150
     0.822    14.824     0.150
     0.888    28.844     0.150
     0.888    15.145     0.150
     0.933    31.094     0.150
     0.933    17.695     0.150
     1.094    32.766     0.150
     1.094    18.684     0.150
     1.086    34.004     0.150
     1.210    22.695     0.150
     1.619    26.953     0.150
     1.746    29.113     0.150
     1.811    32.363     0.150
     1.903    58.484     0.150
     1.903    32.363     0.150
     2.038    34.484     0.150
     2.031    34.145     0.150
     2.124    35.434     0.150
     2.270    37.684     0.150
     2.472    40.164     0.150
     2.522    41.043     0.150
     2.526    41.184     0.150
     2.798    46.965     0.150
    15.951   224.426     0.150
    57.904   591.266     0.150
    59.329   601.125     0.150
    59.588   604.484     0.150
    60.552   609.324     0.150
    60.552   609.215     0.150
    64.317   634.844     0.150
    67.795   657.445     0.150
    67.858   658.523     0.150
    68.806   664.004     0.150
    68.811   664.676     0.150
    68.903   664.977     0.150
    69.095   666.496     0.150
    69.481   668.406     0.150
    69.481   668.176     0.150
    73.875   694.316     0.150
     0.507    16.219     0.150
     0.507     9.039     0.150
     0.782    24.059     0.150
     0.782    13.617     0.150
     0.816    26.418     0.150
     0.816    14.699     0.150
     0.893    15.156     0.150
     0.936    30.758     0.150
     0.936    17.668     0.150
     1.101    33.918     0.150
     1.101    18.816     0.150
     1.082    34.508     0.150
     1.082    19.637     0.150
     1.214    22.656     0.150
     1.214    41.637     0.150
     1.626    26.969     0.150
     1.911    32.457     0.150
     1.915    32.586     0.150
     1.915    59.578     0.150
     2.038    61.547     0.150
     2.044    34.559     0.150
     2.039    35.516     0.150
     2.039    65.688     0.150
     2.129    36.148     0.150
     2.129    67.469     0.150
     2.278    38.336     0.150
     2.329    38.668     0.150
     2.477    72.598     0.150
     2.477    40.777     0.150
     2.528    41.457     0.150
     2.528    74.969     0.150
     2.533    41.586     0.150
     2.533    78.977     0.150
     2.728    45.258     0.150
     2.750    85.098     0.150
     2.750    45.148     0.150
     2.805    46.086     0.150
     2.890    87.457     0.150
     3.103    89.828     0.150
     3.070    95.156     0.150
    15.310   217.336     0.150
    15.536   218.727     0.150
    15.956   224.047     0.150
    16.432   232.598     0.150
    16.823   237.098     0.150
    17.476   245.059     0.150
    18.835   261.008     0.150
    19.315   267.539     0.150
    20.125   274.457     0.150
    20.469   279.438     0.150
    21.108   286.176     0.150
    21.237   286.879     0.150
    33.357   399.527     0.150
    33.939   404.938     0.150
    34.423   408.477     0.150
    34.941   412.359     0.150
    40.260   455.836     0.150
    42.957   480.266     0.150
    43.047   481.039     0.150
    44.929   496.109     0.150
    59.336   602.461     0.150
    59.596   603.625     0.150
    60.559   610.406     0.150
    60.559   610.188     0.150
    62.616   624.539     0.150
    64.324   636.109     0.150
    64.716   639.000     0.150
    64.967   639.766     0.150
    68.810   664.336     0.150
    68.816   664.688     0.150
    69.487   668.930     0.150
    69.487   668.359     0.150
    70.684   677.227     0.150
    73.882   694.930     0.150
    78.466   721.594     0.150
     2.329    38.918     0.150
     3.603    57.539     0.150
     7.213   105.789     0.150
     8.283   120.996     0.150
     8.696   127.039     0.150
    10.191   149.688     0.150
    12.077   172.086     0.150
    12.889   183.219     0.150
    14.024   201.656     0.150
    15.925   227.988     0.150
    17.793   250.176     0.150
    18.565   262.148     0.150
    20.255   277.766     0.150
    20.508   280.328     0.150
    21.200   287.156     0.150
    21.397   288.449     0.150
    22.215   297.949     0.150
    22.718   304.188     0.150
    23.858   314.398     0.150
    23.858   314.988     0.150
    24.814   325.398     0.150
    25.044   327.727     0.150
    30.058   371.297     0.150
    30.821   381.289     0.150
    30.821   380.039     0.150
    30.992   377.586     0.150
    33.269   400.586     0.150
    33.502   399.586     0.150
    33.939   405.906     0.150
    38.118   439.148     0.150
    40.260   458.688     0.150
    49.277   532.391     0.150
    55.099   577.305     0.150
    57.737   593.688     0.150
    58.972   601.188     0.150
    59.336   605.289     0.150
    60.101   608.688     0.150
    61.955   622.289     0.150
    62.616   625.984     0.150
    63.806   633.086     0.150
    64.324   637.984     0.150
    64.716   639.445     0.150
    64.716   639.984     0.150
    67.802   657.586     0.150
    68.161   662.586     0.150
    68.209   662.969     0.150
    68.557   665.344     0.150
    68.816   665.000     0.150
    68.905   666.594     0.150
    70.473   678.781     0.150
    70.565   677.406     0.150
    71.423   683.445     0.150
    73.389   693.977     0.150
    73.527   694.891     0.150
    73.527   694.117     0.150
    75.915   708.047     0.150
    77.313   718.188     0.150
    78.439   724.117     0.150
    84.090   753.461     0.150
    88.401   773.484     0.150
     0.461     8.250     0.150
     0.461    14.422     0.150
     0.640    19.016     0.150
     0.640    10.984     0.150
     0.880    15.953     0.150
     0.880    27.086     0.150
     0.951    17.633     0.150
     1.088    20.555     0.150
     1.088    35.398     0.150
     1.292    21.750     0.150
     1.292    39.875     0.150
     1.325    22.391     0.150
     1.325    41.094     0.150
     1.373    25.414     0.150
     1.373    45.391     0.150
     1.440    24.953     0.150
     1.480    24.922     0.150
     1.608    27.023     0.150
     1.676    53.648     0.150
     1.676    29.492     0.150
     1.730    30.734     0.150
     1.895    32.016     0.150
     1.904    32.570     0.150
     1.997    35.148     0.150
     2.136    36.719     0.150
     2.347    39.734     0.150
     2.387    40.500     0.150
     2.418    40.172     0.150
     2.594    43.719     0.150
     2.907    46.703     0.150
     3.015    48.984     0.150
     3.169    50.773     0.150
     3.629    57.203     0.150
     3.713    58.109     0.150
     3.973    61.469     0.150
     4.195    64.281     0.150
     4.918    75.055     0.150
     7.089   103.805     0.150
    18.976   262.852     0.150
    19.535   268.695     0.150
    19.576   268.969     0.150
    19.646   270.031     0.150
    20.343   278.992     0.150
    20.543   278.664     0.150
    20.996   284.219     0.150
    21.065   284.914     0.150
    22.356   298.930     0.150
    23.727   312.164     0.150
    26.284   335.570     0.150
    26.902   341.773     0.150
    28.888   358.320     0.150
    29.327   364.914     0.150
    30.940   377.672     0.150
    33.405   399.094     0.150
    34.067   405.219     0.150
    34.832   410.453     0.150
    36.710   428.141     0.150
    36.949   429.844     0.150
    37.662   435.602     0.150
    40.132   455.695     0.150
    40.657   460.602     0.150
    40.841   462.141     0.150
    41.360   466.383     0.150
    41.529   468.734     0.150
    41.795   469.914     0.150
    42.214   473.000     0.150
    42.353   474.953     0.150
    42.441   475.609     0.150
    42.725   477.555     0.150
    43.325   482.945     0.150
    43.510   483.695     0.150
    44.281   490.516     0.150
    59.209   601.469     0.150
    59.511   603.680     0.150
    62.552   623.883     0.150
    64.242   634.992     0.150
    64.872   638.773     0.150
    67.693   657.430     0.150
    67.764   657.211     0.150
    68.797   663.914     0.150
    72.140   685.914     0.150
    73.433   692.602     0.150
    73.849   695.336     0.150
    75.869   706.766     0.150
    75.971   708.352     0.150
    76.097   708.531     0.150
    77.044   714.109     0.150
    77.228   714.062     0.150
    79.791   728.352     0.150
    87.707   769.125     0.150
   120.729  1132.500     0.150
   140.335  1169.359     0.150
   146.556  1179.914     0.150
   148.725  1182.555     0.150
   149.115  1188.789     0.150
   159.873  1237.062     0.150
     1.088    19.727     0.150
     1.088    36.250     0.150
     2.465    40.867     0.150
     2.465    41.102     0.150
     3.206    50.680     0.150
     3.572    56.875     0.150
     3.572    57.070     0.150
     5.694    85.172     0.150
     6.529    97.586     0.150
     7.089   103.945     0.150
     8.287   120.297     0.150
     8.287   120.398     0.150
     8.839   129.969     0.150
     9.149   134.500     0.150
    10.332   152.125     0.150
    12.252   174.180     0.150
    12.403   177.500     0.150
    12.751   183.500     0.150
    12.963   184.664     0.150
    14.219   210.852     0.150
    15.784   223.141     0.150
    16.082   232.094     0.150
    16.143   228.023     0.150
    17.479   243.797     0.150
    17.931   252.922     0.150
    18.708   259.789     0.150
    20.395   279.875     0.150
    20.640   281.945     0.150
    21.344   289.164     0.150
    21.344   288.734     0.150
    22.356   300.391     0.150
    22.356   299.750     0.150
    22.853   305.664     0.150
    23.727   312.828     0.150
    23.727   312.680     0.150
    24.865   326.711     0.150
    24.944   326.312     0.150
    25.117   326.773     0.150
    25.515   331.023     0.150
    25.980   334.320     0.150
    26.342   337.672     0.150
    26.516   339.062     0.150
    26.516   338.141     0.150
    26.902   343.469     0.150
    26.902   342.992     0.150
    27.960   353.203     0.150
    28.464   356.383     0.150
    28.513   358.031     0.150
    28.888   359.719     0.150
    29.327   364.125     0.150
    30.200   372.000     0.150
    30.622   377.141     0.150
    30.699   376.086     0.150
    30.940   379.336     0.150
    30.942   379.875     0.150
    30.983   380.109     0.150
    31.914   387.305     0.150
    33.195   397.461     0.150
    33.405   401.227     0.150
    33.405   401.945     0.150
    33.405   401.703     0.150
    33.633   402.664     0.150
    34.067   407.430     0.150
    34.067   407.766     0.150
    34.287   407.711     0.150
    34.832   411.141     0.150
    34.937   413.391     0.150
    34.915   412.766     0.150
    36.710   429.102     0.150
    36.710   429.422     0.150
    36.677   429.555     0.150
    36.866   430.289     0.150
    36.949   431.391     0.150
    37.594   436.328     0.150
    37.594   436.203     0.150
    37.662   435.969     0.150
    38.127   439.945     0.150
    39.400   450.953     0.150
    39.794   455.742     0.150
    39.794   455.523     0.150
    40.003   455.773     0.150
    40.132   456.039     0.150
    40.132   455.445     0.150
    40.813   464.867     0.150
    40.813   464.969     0.150
    40.841   463.266     0.150
    41.299   466.773     0.150
    41.660   468.914     0.150
    41.976   472.969     0.150
    42.211   476.062     0.150
    42.435   477.922     0.150
    44.996   496.141     0.150
    45.147   498.344     0.150
    45.605   502.297     0.150
    45.761   504.766     0.150
    48.286   521.539     0.150
    49.146   529.344     0.150
    49.992   534.969     0.150
    50.823   541.234     0.150
    51.958   550.172     0.150
    53.541   562.094     0.150
    54.033   565.992     0.150
    54.033   566.102     0.150
    54.262   565.750     0.150
    54.896   570.398     0.150
    56.052   581.945     0.150
    57.967   594.086     0.150
    58.199   595.648     0.150
    58.719   599.516     0.150
    58.887   598.422     0.150
    59.209   602.539     0.150
    59.511   605.828     0.150
    59.511   605.172     0.150
    59.579   605.289     0.150
    59.741   605.992     0.150
    59.878   606.273     0.150
    59.957   610.023     0.150
    59.908   608.719     0.150
    60.169   609.086     0.150
    60.404   610.219     0.150
    60.459   609.477     0.150
    60.899   612.359     0.150
    61.752   620.148     0.150
    62.043   621.773     0.150
    62.043   621.586     0.150
    62.552   624.031     0.150
    63.618   633.414     0.150
    64.242   635.195     0.150
    64.872   639.062     0.150
    65.024   640.039     0.150
    65.097   643.609     0.150
    65.473   644.148     0.150
    65.705   647.242     0.150
    65.867   648.336     0.150
    66.136   650.414     0.150
    66.146   649.883     0.150
    66.316   650.562     0.150
    66.396   652.273     0.150
    66.835   652.680     0.150
    66.979   653.234     0.150
    67.160   655.219     0.150
    67.347   656.336     0.150
    67.563   657.344     0.150
    67.616   657.852     0.150
    67.636   657.492     0.150
    67.700   657.516     0.150
    67.693   660.383     0.150
    67.832   658.930     0.150
    67.930   660.180     0.150
    68.023   660.344     0.150
    68.164   661.180     0.150
    68.245   661.750     0.150
    68.326   662.133     0.150
    68.378   663.430     0.150
    68.378   663.609     0.150
    68.407   662.453     0.150
    68.412   662.680     0.150
    68.427   663.250     0.150
    68.494   663.562     0.150
    68.500   663.250     0.150
    68.515   665.242     0.150
    68.528   664.992     0.150
    68.559   664.211     0.150
    68.559   663.383     0.150
    68.602   664.031     0.150
    68.618   664.492     0.150
    68.688   664.820     0.150
    68.745   664.539     0.150
    68.797   664.047     0.150
    68.797   664.203     0.150
    68.880   666.203     0.150
    68.889   665.930     0.150
    68.915   666.219     0.150
    68.926   668.633     0.150
    68.977   665.484     0.150
    68.999   666.875     0.150
    69.033   666.633     0.150
    69.065   667.930     0.150
    69.102   668.641     0.150
    69.178   669.453     0.150
    69.310   667.859     0.150
    69.442   668.922     0.150
    69.810   669.781     0.150
    69.954   673.031     0.150
    69.971   672.633     0.150
    70.134   675.344     0.150
    70.398   675.445     0.150
    70.420   679.039     0.150
    70.469   676.539     0.150
    70.469   674.641     0.150
    70.468   676.562     0.150
    70.493   676.820     0.150
    70.621   678.242     0.150
    70.683   677.945     0.150
    70.683   676.930     0.150
    70.746   677.023     0.150
    70.776   678.242     0.150
    70.776   677.219     0.150
    70.842   676.992     0.150
    71.034   680.945     0.150
    71.113   680.172     0.150
    71.119   679.961     0.150
    71.173   678.062     0.150
    71.230   680.164     0.150
    71.287   679.641     0.150
    71.276   682.359     0.150
    71.326   681.148     0.150
    71.321   680.484     0.150
    71.426   681.742     0.150
    71.443   682.539     0.150
    71.550   682.641     0.150
    71.631   683.336     0.150
    71.637   685.945     0.150
    71.967   685.602     0.150
    72.009   684.406     0.150
    72.143   685.516     0.150
    72.199   685.188     0.150
    72.199   684.852     0.150
    72.221   687.336     0.150
    72.140   686.164     0.150
    72.140   686.398     0.150
    72.221   687.359     0.150
    72.250   685.875     0.150
    72.274   686.883     0.150
    72.287   689.945     0.150
    72.502   686.938     0.150
    72.512   688.164     0.150
    72.769   688.539     0.150
    72.893   690.523     0.150
    72.931   691.469     0.150
    73.035   693.570     0.150
    73.078   691.031     0.150
    73.155   691.453     0.150
    73.316   693.344     0.150
    73.358   693.312     0.150
    73.389   692.461     0.150
    73.433   693.227     0.150
    73.424   693.695     0.150
    73.425   694.266     0.150
    73.436   694.758     0.150
    73.556   693.250     0.150
    73.590   695.250     0.150
    73.693   695.672     0.150
    73.693   695.172     0.150
    73.722   695.516     0.150
    73.722   695.289     0.150
    73.787   695.547     0.150
    74.143   699.539     0.150
    74.213   698.969     0.150
    74.213   699.070     0.150
    74.254   698.086     0.150
    74.856   702.531     0.150
    75.869   708.328     0.150
    75.869   706.969     0.150
    75.869   707.312     0.150
    75.998   710.359     0.150
    75.998   709.664     0.150
    75.971   710.492     0.150
    76.322   708.898     0.150
    77.228   715.016     0.150
    77.581   718.250     0.150
    77.992   719.812     0.150
    78.351   721.625     0.150
    79.393   728.016     0.150
    79.691   728.375     0.150
    79.786   731.062     0.150
    79.791   730.773     0.150
    79.791   729.984     0.150
    80.577   734.523     0.150
    83.455   750.750     0.150
    83.970   752.211     0.150
    87.882   770.531     0.150
    87.943   770.883     0.150
    87.943   770.445     0.150
    87.942   770.469     0.150
    88.426   775.086     0.150
    91.244   785.719     0.150
    91.244   785.453     0.150
    93.845   800.883     0.150
    34.588   408.266     0.150
     0.438    13.797     0.150
     0.438     7.625     0.150
     0.629    18.219     0.150
     0.629    10.242     0.150
     1.062    19.773     0.150
     1.062    34.969     0.150
     1.231    22.125     0.150
     1.461    24.086     0.150
     1.461    45.758     0.150
     1.760    30.414     0.150
     1.881    58.055     0.150
     1.881    32.664     0.150
     1.972    34.172     0.150
     1.972    61.336     0.150
     1.976    35.789     0.150
     2.123    35.664     0.150
     2.123    62.719     0.150
     2.067    64.086     0.150
     2.417    40.672     0.150
     2.489    77.008     0.150
     3.716    67.016     0.150
     4.196    77.555     0.150
     4.385    68.336     0.150
     4.763    71.148     0.150
     4.937    76.422     0.150
     5.097    76.156     0.150
     5.104    78.055     0.150
     5.129    78.414     0.150
     5.334    81.617     0.150
     5.359    81.328     0.150
     5.535    81.828     0.150
     5.533    83.414     0.150
     5.581    85.414     0.150
     5.647    85.422     0.150
     7.063   103.328     0.150
    10.252   147.562     0.150
    11.087   159.164     0.150
    12.690   181.422     0.150
    14.572   207.047     0.150
    15.382   215.828     0.150
    15.801   221.242     0.150
    16.010   225.656     0.150
    16.464   234.492     0.150
    16.737   235.078     0.150
    16.922   237.617     0.150
    16.967   239.516     0.150
    17.454   243.508     0.150
    17.941   250.789     0.150
    18.721   263.109     0.150
    19.547   268.977     0.150
    19.652   269.953     0.150
    21.225   289.359     0.150
    25.144   326.328     0.150
    26.006   336.094     0.150
    26.618   340.219     0.150
    28.910   361.453     0.150
    33.521   401.484     0.150
    34.073   406.438     0.150
    36.974   429.977     0.150
    40.145   459.227     0.150
    41.349   467.422     0.150
    41.352   470.297     0.150
    41.549   468.359     0.150
    43.152   482.523     0.150
    59.204   601.945     0.150
    62.563   623.586     0.150
    64.249   634.109     0.150
    64.876   638.492     0.150
    67.766   656.586     0.150
    68.816   663.188     0.150
    69.124   665.758     0.150
    70.704   676.656     0.150
    71.539   680.977     0.150
    73.437   692.758     0.150
    75.884   708.125     0.150
    77.234   713.539     0.150
    80.943   735.609     0.150
    87.874   770.203     0.150
     0.462    14.621     0.150
     0.714    12.771     0.150
     0.859    15.141     0.150
     0.859    27.591     0.150
     0.912    15.691     0.150
     1.227    23.061     0.150
     1.280    21.730     0.150
     1.509    27.851     0.150
     1.502    25.431     0.150
     1.539    25.971     0.150
     1.658    28.371     0.150
     1.679    27.951     0.150
     1.852    32.971     0.150
     1.893    33.791     0.150
     1.989    34.311     0.150
     2.077    35.621     0.150
     2.109    36.591     0.150
     2.147    36.521     0.150
     2.353    39.471     0.150
     2.311    40.151     0.150
     2.492    41.091     0.150
     2.562    42.451     0.150
     2.631    43.831     0.150
     2.815    46.740     0.150
     2.834    49.911     0.150
     2.906    47.971     0.150
     2.910    51.490     0.150
     2.955    47.091     0.150
     2.986    47.911     0.150
     3.090    49.911     0.150
     3.161    50.681     0.150
     3.223    52.081     0.150
     3.319    51.980     0.150
     3.467    54.381     0.150
     3.457    55.291     0.150
     3.570    56.041     0.150
     3.766    58.771     0.150
     3.703    58.021     0.150
     3.848    60.171     0.150
     3.955    61.141     0.150
     3.919    61.500     0.150
     4.202    65.760     0.150
     4.289    66.091     0.150
     4.371    67.240     0.150
     4.487    69.031     0.150
     4.512    69.480     0.150
     4.519    69.381     0.150
     4.524    70.431     0.150
     4.613    70.931     0.150
     4.777    73.421     0.150
     4.837    74.151     0.150
     4.958    74.230     0.150
     5.034    77.061     0.150
    18.557   258.081     0.150
    18.759   260.691     0.150
    19.318   266.421     0.150
    19.360   266.641     0.150
    19.362   266.541     0.150
    19.412   267.701     0.150
    19.426   267.401     0.150
    20.695   280.121     0.150
    21.490   290.151     0.150
    21.606   291.351     0.150
    22.724   304.391     0.150
    24.421   318.611     0.150
    25.092   326.201     0.150
    25.986   334.391     0.150
    26.691   340.851     0.150
    26.713   340.641     0.150
    27.772   350.980     0.150
    28.975   360.230     0.150
    30.724   376.531     0.150
    33.185   398.151     0.150
    33.847   404.010     0.150
    35.041   413.181     0.150
    36.700   428.010     0.150
    37.461   434.531     0.150
    39.732   453.471     0.150
    40.234   457.671     0.150
    40.352   457.641     0.150
    40.565   460.871     0.150
    40.643   461.141     0.150
    41.080   464.801     0.150
    41.310   467.230     0.150
    41.883   471.681     0.150
    42.022   472.341     0.150
    42.043   472.980     0.150
    42.464   475.651     0.150
    43.291   483.021     0.150
    43.773   486.591     0.150
    44.583   494.361     0.150
    46.900   511.691     0.150
    49.804   533.121     0.150
    51.956   549.401     0.150
    55.370   574.221     0.150
    57.921   592.510     0.150
    59.429   603.461     0.150
    59.555   603.791     0.150
    62.720   624.861     0.150
    63.722   632.191     0.150
    64.429   636.371     0.150
    65.071   640.181     0.150
    66.518   651.151     0.150
    67.763   658.421     0.150
    67.968   659.621     0.150
    68.553   663.131     0.150
    68.910   665.111     0.150
    69.592   669.951     0.150
    69.592   669.611     0.150
    71.939   684.871     0.150
    73.631   694.221     0.150
    73.865   695.761     0.150
    75.882   707.971     0.150
    76.011   707.661     0.150
    77.418   715.371     0.150
    78.571   722.391     0.150
    79.769   728.710     0.150
    79.910   729.451     0.150
    87.476   768.721     0.150
   117.385  1125.440     0.150
   120.856  1133.281     0.150
   129.280  1147.710     0.150
   144.332  1176.601     0.150
   149.135  1189.750     0.150
   149.568  1188.400     0.150
   159.658  1197.311     0.150
     2.986    47.201     0.150
     3.703    58.431     0.150
     3.703    58.201     0.150
     3.983    62.101     0.150
     4.837    75.101     0.150
     5.302    80.101     0.150
     5.569    84.301     0.150
     5.560    85.301     0.150
     5.726    85.000     0.150
     5.984    89.195     0.150
     6.543    98.801     0.150
     6.716   101.101     0.150
     6.716   100.115     0.150
     6.952   103.701     0.150
     6.949   104.101     0.150
     7.216   107.000     0.150
     7.216   106.177     0.150
     7.216   106.701     0.150
     7.216   106.811     0.150
     7.862   115.901     0.150
     8.213   121.000     0.150
     8.371   120.692     0.150
     8.371   121.510     0.150
     8.659   127.401     0.150
     8.659   126.851     0.150
     9.343   136.904     0.150
    10.114   149.151     0.150
    12.139   172.196     0.150
    12.621   180.458     0.150
    12.948   186.031     0.150
    12.938   183.411     0.150
    13.939   200.961     0.150
    15.862   225.258     0.150
    16.002   226.701     0.150
    15.886   227.550     0.150
    15.886   227.091     0.150
    15.940   225.240     0.150
    16.104   227.605     0.150
    16.168   228.143     0.150
    17.711   249.591     0.150
    18.243   254.756     0.150
    18.492   259.331     0.150
    20.177   278.071     0.150
    20.420   279.760     0.150
    21.132   287.591     0.150
    21.132   287.211     0.150
    21.467   289.771     0.150
    21.677   295.842     0.150
    22.138   297.761     0.150
    22.138   297.591     0.150
    22.632   303.411     0.150
    23.546   313.490     0.150
    23.948   315.750     0.150
    24.438   321.036     0.150
    24.646   323.321     0.150
    24.724   324.260     0.150
    25.092   326.701     0.150
    25.297   329.131     0.150
    26.122   336.441     0.150
    26.337   337.401     0.150
    26.337   338.141     0.150
    26.304   338.545     0.150
    26.691   341.971     0.150
    26.691   341.871     0.150
    27.742   351.391     0.150
    28.302   354.961     0.150
    28.295   356.594     0.150
    28.975   360.040     0.150
    29.320   364.181     0.150
    29.428   367.041     0.150
    30.401   374.381     0.150
    30.500   374.803     0.150
    30.500   374.691     0.150
    30.724   378.201     0.150
    30.726   377.898     0.150
    30.724   377.821     0.150
    30.763   378.161     0.150
    31.074   378.901     0.150
    31.189   382.161     0.150
    31.860   387.281     0.150
    33.185   399.927     0.150
    33.185   399.601     0.150
    33.413   399.851     0.150
    33.479   402.000     0.150
    33.560   401.101     0.150
    33.847   406.203     0.150
    33.847   405.881     0.150
    34.080   406.581     0.150
    34.402   409.451     0.150
    34.829   412.851     0.150
    35.041   413.901     0.150
    35.034   414.331     0.150
    35.249   418.341     0.150
    36.457   427.631     0.150
    36.700   429.801     0.150
    36.700   429.228     0.150
    36.700   429.061     0.150
    36.651   429.010     0.150
    36.984   431.701     0.150
    37.496   436.162     0.150
    37.461   434.977     0.150
    37.929   440.641     0.150
    38.202   440.521     0.150
    38.369   443.441     0.150
    39.191   449.621     0.150
    39.732   454.331     0.150
    39.905   456.301     0.150
    39.905   456.510     0.150
    39.821   455.621     0.150
    39.887   456.771     0.150
    40.352   458.301     0.150
    40.593   463.258     0.150
    40.643   461.780     0.150
    40.643   461.891     0.150
    40.730   462.971     0.150
    41.088   465.681     0.150
    41.012   465.601     0.150
    41.050   468.021     0.150
    41.300   466.730     0.150
    41.663   469.240     0.150
    41.814   472.031     0.150
    41.981   470.531     0.150
    42.022   475.702     0.150
    42.022   474.911     0.150
    42.022   475.301     0.150
    42.260   474.861     0.150
    42.312   476.531     0.150
    42.351   476.361     0.150
    42.404   476.631     0.150
    43.423   485.031     0.150
    43.773   487.821     0.150
    44.952   497.561     0.150
    45.204   497.851     0.150
    45.204   497.701     0.150
    45.505   501.759     0.150
    45.505   501.541     0.150
    45.541   503.521     0.150
    46.058   505.931     0.150
    46.900   513.167     0.150
    46.900   513.901     0.150
    46.900   513.031     0.150
    46.810   512.250     0.150
    47.040   512.301     0.150
    48.503   523.801     0.150
    49.366   531.901     0.150
    49.804   533.628     0.150
    50.100   535.471     0.150
    50.935   541.971     0.150
    51.930   549.641     0.150
    51.956   549.801     0.150
    52.075   550.621     0.150
    52.871   556.181     0.150
    53.662   562.791     0.150
    53.735   562.961     0.150
    53.819   565.271     0.150
    53.819   565.000     0.150
    53.990   565.701     0.150
    54.375   567.250     0.150
    54.660   568.891     0.150
    55.007   572.021     0.150
    55.076   576.771     0.150
    55.370   575.674     0.150
    55.370   575.500     0.150
    55.606   579.409     0.150
    56.158   580.051     0.150
    56.488   582.851     0.150
    56.535   582.480     0.150
    56.741   584.581     0.150
    56.825   584.826     0.150
    57.146   588.010     0.150
    57.164   587.288     0.150
    57.197   587.461     0.150
    57.352   590.214     0.150
    57.352   589.801     0.150
    57.352   590.601     0.150
    57.354   589.000     0.150
    57.835   594.201     0.150
    57.921   593.281     0.150
    58.028   593.038     0.150
    58.028   593.538     0.150
    58.071   593.461     0.150
    57.899   594.971     0.150
    58.218   596.901     0.150
    58.247   595.681     0.150
    58.368   595.901     0.150
    58.581   599.000     0.150
    58.752   599.441     0.150
    59.001   599.841     0.150
    59.072   601.401     0.150
    59.098   600.801     0.150
    59.093   600.961     0.150
    59.429   604.701     0.150
    59.429   605.110     0.150
    59.429   605.000     0.150
    59.505   605.197     0.150
    59.550   604.576     0.150
    59.550   605.026     0.150
    59.550     2.900     0.150
    59.550     3.400     0.150
    59.555   604.995     0.150
    59.555   605.101     0.150
    59.618   605.341     0.150
    59.723   607.018     0.150
    59.767   606.051     0.150
    59.930   607.000     0.150
    59.930   607.271     0.150
    59.989   607.341     0.150
    59.991   607.691     0.150
    60.043   608.611     0.150
    60.204   608.301     0.150
    60.207   609.250     0.150
    60.247   609.611     0.150
    60.282   609.951     0.150
    60.364   611.510     0.150
    60.532   611.161     0.150
    60.615   612.958     0.150
    60.615   612.841     0.150
    60.615   612.701     0.150
    60.662   611.622     0.150
    60.662   611.801     0.150
    60.555   615.401     0.150
    60.694   612.351     0.150
    60.866   613.770     0.150
    60.911   614.601     0.150
    61.011   614.000     0.150
    61.011   614.351     0.150
    61.139   615.681     0.150
    61.170   615.500     0.150
    61.387   617.371     0.150
    61.468   617.271     0.150
    61.659   619.401     0.150
    61.791   620.291     0.150
    61.837   620.411     0.150
    61.827   621.180     0.150
    61.827   620.760     0.150
    62.060   622.101     0.150
    62.163   623.000     0.150
    62.663   626.181     0.150
    62.720   626.915     0.150
    62.720   626.000     0.150
    62.813   626.760     0.150
    63.075   628.541     0.150
    63.185   629.171     0.150
    63.227   630.061     0.150
    63.518   632.061     0.150
    63.722   633.081     0.150
    63.908   634.601     0.150
    64.234   635.201     0.150
    64.401   638.141     0.150
    64.429   637.792     0.150
    64.487   637.341     0.150
    64.636   639.471     0.150
    64.784   640.671     0.150
    64.784   640.421     0.150
    64.816   640.651     0.150
    65.028   640.601     0.150
    65.071   641.337     0.150
    65.071   641.061     0.150
    65.126   641.101     0.150
    65.126   641.391     0.150
    65.185   642.510     0.150
    65.216   642.371     0.150
    65.316   643.521     0.150
    65.374   643.821     0.150
    65.415   644.131     0.150
    65.471   644.401     0.150
    65.544   645.510     0.150
    65.759   646.961     0.150
    65.763   646.521     0.150
    65.847   646.971     0.150
    65.925   647.591     0.150
    65.986   647.921     0.150
    66.042   648.301     0.150
    66.197   649.531     0.150
    66.202   649.301     0.150
    66.389   650.541     0.150
    66.465   650.871     0.150
    66.490   650.791     0.150
    66.759   652.750     0.150
    66.854   654.171     0.150
    66.907   654.000     0.150
    67.024   654.381     0.150
    67.057   654.480     0.150
    67.236   656.031     0.150
    67.269   656.151     0.150
    67.430   657.121     0.150
    67.487   657.601     0.150
    67.358   657.331     0.150
    67.645   658.671     0.150
    67.699   659.061     0.150
    67.711   659.021     0.150
    67.718   659.021     0.150
    67.762   659.521     0.150
    67.763   659.421     0.150
    67.821   659.851     0.150
    67.905   659.000     0.150
    67.915   660.541     0.150
    67.920   660.260     0.150
    67.968   659.521     0.150
    68.009   660.901     0.150
    68.107   661.861     0.150
    68.125   661.591     0.150
    68.128   662.182     0.150
    68.128   660.711     0.150
    68.197   662.171     0.150
    68.248   662.561     0.150
    68.244   662.471     0.150
    68.290   662.681     0.150
    68.336   663.118     0.150
    68.331   662.490     0.150
    68.371   663.331     0.150
    68.399   663.201     0.150
    68.401   663.361     0.150
    68.408   663.471     0.150
    68.436   663.646     0.150
    68.436   663.541     0.150
    68.486   663.621     0.150
    68.490   664.151     0.150
    68.499   663.310     0.150
    68.499   663.531     0.150
    68.512   664.091     0.150
    68.553   664.607     0.150
    68.553   664.500     0.150
    68.553   664.230     0.150
    68.568   664.581     0.150
    68.586   664.451     0.150
    68.584   664.301     0.150
    68.599   664.541     0.150
    68.644   664.701     0.150
    68.665   665.000     0.150
    68.658   664.821     0.150
    68.687   665.161     0.150
    68.693   665.500     0.150
    68.693   665.651     0.150
    68.773   665.561     0.150
    68.825   665.801     0.150
    68.910   665.508     0.150
    68.910   665.611     0.150
    68.965   666.181     0.150
    68.972   666.901     0.150
    68.848   667.308     0.150
    68.848   667.081     0.150
    68.990   667.121     0.150
    69.002   667.071     0.150
    69.056   666.971     0.150
    69.085   667.990     0.150
    69.110   667.961     0.150
    69.126   667.531     0.150
    69.184   668.101     0.150
    69.237   668.781     0.150
    69.246   668.881     0.150
    69.408   670.500     0.150
    69.408   669.621     0.150
    69.387   669.010     0.150
    69.507   670.561     0.150
    69.845   672.631     0.150
    69.864   672.951     0.150
    69.972   673.711     0.150
    70.051   672.561     0.150
    70.047   673.361     0.150
    70.131   675.191     0.150
    70.214   674.801     0.150
    70.290   675.510     0.150
    70.260   678.061     0.150
    70.501   676.901     0.150
    70.530   677.541     0.150
    70.555   676.801     0.150
    70.563   677.401     0.150
    70.563   676.661     0.150
    70.558   677.611     0.150
    70.649   677.760     0.150
    70.687   677.861     0.150
    70.695   677.643     0.150
    70.695   677.431     0.150
    70.773   678.281     0.150
    70.825   678.561     0.150
    70.872   677.451     0.150
    70.926   679.490     0.150
    70.945   678.480     0.150
    70.966   679.490     0.150
    71.002   679.391     0.150
    71.041   680.748     0.150
    71.089   680.211     0.150
    71.192   680.260     0.150
    71.196   680.871     0.150
    71.243   679.971     0.150
    71.302   680.601     0.150
    71.327   681.760     0.150
    71.397   681.711     0.150
    71.425   682.061     0.150
    71.428   683.031     0.150
    71.510   683.250     0.150
    71.537   683.791     0.150
    71.909   683.851     0.150
    71.758   683.311     0.150
    71.773   684.421     0.150
    71.842   684.171     0.150
    72.006   685.531     0.150
    71.939   686.169     0.150
    71.939   685.951     0.150
    72.150   686.331     0.150
    72.188   687.110     0.150
    72.175   687.610     0.150
    72.274   688.031     0.150
    72.284   686.761     0.150
    72.334   687.380     0.150
    72.567   689.170     0.150
    72.570   689.690     0.150
    72.679   689.581     0.150
    72.875   690.471     0.150
    72.955   691.110     0.150
    73.009   691.661     0.150
    73.131   691.451     0.150
    73.248   692.610     0.150
    73.457   694.311     0.150
    73.477   694.061     0.150
    73.519   694.500     0.150
    73.522   694.670     0.150
    73.542   694.281     0.150
    73.548   694.545     0.150
    73.631   695.089     0.150
    73.631   695.201     0.150
    73.654   694.630     0.150
    73.729   695.391     0.150
    73.822   696.351     0.150
    73.865   697.166     0.150
    73.865   696.871     0.150
    74.148   699.130     0.150
    74.172   700.400     0.150
    74.240   699.230     0.150
    74.291   698.621     0.150
    74.321   699.091     0.150
    74.411   700.321     0.150
    74.734   702.041     0.150
    74.741   702.321     0.150
    74.765   701.987     0.150
    74.841   702.380     0.150
    74.858   702.390     0.150
    75.082   703.960     0.150
    75.248   705.455     0.150
    75.248   704.900     0.150
    75.383   706.051     0.150
    75.757   709.825     0.150
    76.011   709.062     0.150
    76.011   708.821     0.150
    76.019   709.341     0.150
    75.882   710.721     0.150
    76.083   709.291     0.150
    76.183   710.851     0.150
    76.235   710.601     0.150
    76.255   710.091     0.150
    76.314   711.641     0.150
    76.417   710.860     0.150
    76.455   711.801     0.150
    76.432   712.121     0.150
    76.550   712.400     0.150
    76.703   712.500     0.150
    76.957   715.291     0.150
    77.155   716.601     0.150
    77.226   716.641     0.150
    77.418   717.459     0.150
    77.418   717.000     0.150
    77.454   717.951     0.150
    77.454   717.451     0.150
    77.655   718.891     0.150
    77.922   719.601     0.150
    77.953   719.391     0.150
    77.949   718.391     0.150
    78.064   718.511     0.150
    78.092   720.491     0.150
    78.284   722.250     0.150
    78.461   724.681     0.150
    78.506   723.571     0.150
    78.544   724.141     0.150
    78.571   723.859     0.150
    78.691   724.541     0.150
    78.743   724.431     0.150
    79.537   730.241     0.150
    79.680   729.730     0.150
    79.769   732.000     0.150
    79.769   732.343     0.150
    79.769   731.821     0.150
    79.826   731.610     0.150
    79.910   731.031     0.150
    80.095   731.601     0.150
    80.612   735.601     0.150
    80.737   734.900     0.150
    80.983   736.311     0.150
    81.603   739.241     0.150
    81.766   739.991     0.150
    82.382   744.380     0.150
    83.221   746.960     0.150
    83.325   748.670     0.150
    84.133   752.400     0.150
    84.187   754.261     0.150
    84.826   754.201     0.150
    86.315   763.621     0.150
    87.476   769.610     0.150
    87.476   769.301     0.150
    87.789   771.241     0.150
    88.102   772.299     0.150
    88.163   772.464     0.150
    88.163   772.801     0.150
    88.163   772.420     0.150
    88.485   774.701     0.150
    88.551   775.121     0.150
    88.592   775.181     0.150
    89.353   778.505     0.150
    89.353   778.331     0.150
    90.170   782.961     0.150
    90.170   782.710     0.150
    91.041   786.250     0.150
    91.041   786.071     0.150
    91.227   787.241     0.150
    92.378   793.081     0.150
    96.274   810.391     0.150
    98.945   822.440     0.150
   103.245   841.931     0.150
    34.587   411.911     0.150
   129.280  1151.701     0.150
   138.406  1171.900     0.150
     0.494     8.723     0.150
     0.494    16.583     0.150
     0.748    13.402     0.150
     0.852    14.493     0.150
     0.852    26.083     0.150
     0.928    30.062     0.150
     0.928    15.922     0.150
     0.987    18.663     0.150
     1.065    19.312     0.150
     1.245    23.223     0.150
     1.245    41.882     0.150
     1.245    40.933     0.150
     1.289    42.223     0.150
     1.289    22.402     0.150
     1.536    26.223     0.150
     1.683    27.862     0.150
     1.683    50.262     0.150
     1.844    31.592     0.150
     1.844    58.413     0.150
     1.982    34.132     0.150
     1.982    60.123     0.150
     2.114    38.032     0.150
     2.164    37.322     0.150
     2.293    38.442     0.150
     2.347    39.703     0.150
     2.510    41.683     0.150
     2.573    42.902     0.150
     2.612    43.462     0.150
     2.803    46.772     0.150
     2.877    47.262     0.150
     2.976    48.163     0.150
     2.996    47.802     0.150
     3.099    48.962     0.150
     3.163    50.592     0.150
     3.200    51.393     0.150
     3.330    52.223     0.150
     3.478    54.152     0.150
     3.464    54.493     0.150
     3.590    55.962     0.150
     3.667    58.132     0.150
     3.772    58.612     0.150
     3.833    60.382     0.150
     3.899    60.203     0.150
     3.896    61.373     0.150
     4.294    66.203     0.150
     4.378    66.993     0.150
     4.489    69.183     0.150
     4.511    69.473     0.150
     4.511    69.562     0.150
     4.504    70.592     0.150
     4.601    71.473     0.150
     4.776    72.772     0.150
     4.838    73.973     0.150
     4.971    74.172     0.150
     4.997    77.333     0.150
     5.547    82.882     0.150
     6.137    92.482     0.150
     6.663    99.353     0.150
     6.687   100.012     0.150
     7.390   109.462     0.150
     7.683   112.913     0.150
     9.213   133.623     0.150
    10.531   154.072     0.150
    22.240   298.873     0.150
    25.508   329.493     0.150
     0.479     8.316     0.150
     0.479    15.285     0.150
     0.588     9.906     0.150
     0.588    18.047     0.150
     0.737    12.105     0.150
     0.909    27.387     0.150
     0.909    15.387     0.150
     0.925    16.805     0.150
     0.937    17.707     0.150
     0.937    30.875     0.150
     1.061    35.707     0.150
     1.061    19.387     0.150
     1.234    22.164     0.150
     1.234    38.875     0.150
     1.435    23.785     0.150
     1.563    26.344     0.150
     1.719    29.355     0.150
     1.844    31.375     0.150
     1.866    32.176     0.150
     1.923    33.645     0.150
     1.965    34.027     0.150
     2.084    34.805     0.150
     2.084    63.316     0.150
     2.107    35.395     0.150
     2.107    65.527     0.150
     2.316    70.297     0.150
     2.316    38.004     0.150
     2.348    38.844     0.150
     2.348    73.055     0.150
     2.366    39.375     0.150
     2.541    42.836     0.150
     2.501    40.754     0.150
     2.676    45.625     0.150
     2.866    46.145     0.150
     2.910    46.516     0.150
     2.964    47.688     0.150
     3.258    50.207     0.150
     3.540    55.695     0.150
     3.592    55.285     0.150
     3.663    57.535     0.150
     3.755    57.496     0.150
     4.153    61.996     0.150
     4.251    65.285     0.150
     4.889    73.445     0.150
    15.796   222.188     0.150
    16.005   225.625     0.150
    18.712   257.406     0.150
    21.428   289.246     0.150
    22.407   298.027     0.150
    25.567   331.457     0.150
    39.504   452.984     0.150
    39.504   453.227     0.150
    57.861   591.176     0.150
    59.156   600.836     0.150
    59.416   602.594     0.150
    60.409   608.395     0.150
    60.409   608.965     0.150
    62.510   623.484     0.150
    64.823   638.504     0.150
    68.767   664.035     0.150
    71.492   682.047     0.150
     0.511     8.891     0.150
     0.511    15.750     0.150
     0.643    10.898     0.150
     0.643    19.266     0.150
     0.802    24.148     0.150
     0.916    16.680     0.150
     0.901    29.547     0.150
     0.901    17.070     0.150
     0.971    16.484     0.150
     1.126    20.609     0.150
     1.126    36.836     0.150
     1.127    18.477     0.150
     1.169    36.484     0.150
     1.169    21.289     0.150
     1.302    22.141     0.150
     1.331    40.734     0.150
     1.442    44.484     0.150
     1.498    25.086     0.150
     1.626    27.086     0.150
     1.703    30.234     0.150
     1.703    54.055     0.150
     1.760    55.859     0.150
     1.771    30.648     0.150
     1.901    32.211     0.150
     1.932    33.531     0.150
     1.930    33.844     0.150
     2.031    34.406     0.150
     2.055    35.250     0.150
     2.139    35.617     0.150
     2.381    39.305     0.150
     2.414    40.180     0.150
     2.399    40.516     0.150
     2.436    40.266     0.150
     2.551    78.938     0.150
     2.587    43.016     0.150
     2.609    82.164     0.150
     2.930    47.008     0.150
     2.972    47.180     0.150
     2.992    48.477     0.150
     3.188    50.375     0.150
     3.210    50.430     0.150
     3.314    51.641     0.150
     3.287    52.430     0.150
     3.472    53.500     0.150
     3.545    55.977     0.150
     3.527    56.016     0.150
     3.591    56.141     0.150
     3.617    57.844     0.150
     3.689    58.328     0.150
     3.820    58.734     0.150
     3.855    60.859     0.150
     3.947    61.297     0.150
     3.971    62.305     0.150
     4.114    63.297     0.150
     4.106    63.469     0.150
     4.215    64.930     0.150
     4.198    64.344     0.150
     4.296    66.008     0.150
     4.309    66.359     0.150
     4.291    66.586     0.150
     4.385    68.039     0.150
     4.381    68.977     0.150
     4.393    68.875     0.150
     4.577    70.055     0.150
     4.642    71.148     0.150
     4.812    72.000     0.150
     4.812    73.758     0.150
     4.886    74.266     0.150
     4.872    74.398     0.150
     5.005    75.625     0.150
    36.899   430.109     0.150
    57.844   591.125     0.150
    67.739   657.344     0.150
    69.382   668.188     0.150
    69.382   668.188     0.150
     0.495     8.654     0.150
     0.495    15.884     0.150
     0.777    23.694     0.150
     0.777    13.964     0.150
     0.817    14.234     0.150
     0.817    24.744     0.150
     0.908    15.144     0.150
     0.966    18.174     0.150
     1.131    35.104     0.150
     1.076    33.844     0.150
     1.076    19.554     0.150
     1.227    23.284     0.150
     1.227    41.004     0.150
     1.469    24.684     0.150
     1.469    45.024     0.150
     1.502    25.324     0.150
     1.617    50.394     0.150
     1.617    27.844     0.150
     1.654    27.874     0.150
     1.780    29.754     0.150
     1.838    32.584     0.150
     1.885    33.744     0.150
     1.878    33.274     0.150
     1.947    34.214     0.150
     2.065    35.774     0.150
     2.072    35.654     0.150
     2.080    36.654     0.150
     2.144    37.034     0.150
     2.313    39.414     0.150
     2.313    39.704     0.150
     2.491    41.094     0.150
     2.549    41.874     0.150
     2.575    43.984     0.150
     2.726    45.874     0.150
     2.767    46.884     0.150
     2.847    47.874     0.150
     2.924    48.524     0.150
     3.013    49.764     0.150
     3.074    49.224     0.150
     3.031    49.614     0.150
     3.133    50.684     0.150
     3.164    51.164     0.150
     3.285    53.324     0.150
     3.304    54.764     0.150
     3.411    54.464     0.150
     3.366    54.264     0.150
     3.453    53.704     0.150
     3.436    55.024     0.150
     3.573    56.114     0.150
     3.640    57.334     0.150
     3.744    58.794     0.150
     3.796    59.944     0.150
     3.860    60.514     0.150
     3.948    61.274     0.150
     3.935    61.904     0.150
     4.026    62.934     0.150
     4.041    65.144     0.150
     4.114    64.104     0.150
     4.144    65.324     0.150
     4.264    65.924     0.150
     4.350    67.214     0.150
     4.459    68.844     0.150
     4.478    68.994     0.150
     4.476    69.294     0.150
     4.468    70.064     0.150
     4.565    70.874     0.150
     4.745    72.454     0.150
     4.807    72.854     0.150
     4.947    74.374     0.150
     4.981    76.154     0.150
     4.972    76.454     0.150
     5.042    77.284     0.150
     5.157    79.854     0.150
     5.262    80.004     0.150
     5.286    79.524     0.150
     5.269    80.504     0.150
     5.310    81.274     0.150
    21.928   294.654     0.150
    57.942   592.494     0.150
    67.845   658.634     0.150
    67.858   659.704     0.150
    69.528   669.214     0.150
    69.528   669.444     0.150
     0.526     9.754     0.150
     0.526    17.004     0.150
     0.722    12.943     0.150
     0.722    22.254     0.150
     0.914    28.055     0.150
     0.914    15.943     0.150
     0.983    16.623     0.150
     0.983    31.564     0.150
     1.000    18.725     0.150
     1.022    18.693     0.150
     1.022    32.715     0.150
     1.299    24.373     0.150
     1.299    42.924     0.150
     1.349    43.404     0.150
     1.349    22.844     0.150
     1.483    47.273     0.150
     1.564    47.273     0.150
     1.714    52.504     0.150
     1.745    53.645     0.150
     1.745    28.895     0.150
     1.782    54.773     0.150
     1.782    31.314     0.150
     2.044    62.623     0.150
     2.044    35.465     0.150
     2.148    66.373     0.150
     2.148    37.123     0.150
     2.155    37.635     0.150
     2.168    66.154     0.150
     2.218    68.424     0.150
     2.218    38.064     0.150
     2.239    38.244     0.150
     2.410    40.414     0.150
     2.632    43.484     0.150
     2.667    44.725     0.150
     2.921    47.953     0.150
     2.923    48.545     0.150
     2.935    47.514     0.150
     3.159    50.484     0.150
     3.691    59.094     0.150
     3.834    59.184     0.150
     3.842    59.984     0.150
     3.891    60.984     0.150
     3.947    62.494     0.150
     3.952    62.854     0.150
     4.199    66.023     0.150
     4.233    66.895     0.150
     4.552    70.453     0.150
     4.572    70.273     0.150
     4.661    72.645     0.150
     5.600    86.385     0.150
     5.756    87.834     0.150
     5.797    86.023     0.150
     5.860    89.094     0.150
     5.868    89.523     0.150
     6.158    93.094     0.150
     6.574   100.264     0.150
    10.283   148.555     0.150
    10.574   155.174     0.150
    11.318   162.494     0.150
    12.676   180.965     0.150
    12.880   183.514     0.150
     0.567    10.137     0.150
     0.598    10.098     0.150
     1.131    20.375     0.150
     1.173    21.715     0.150
     1.721    29.426     0.150
     1.721    52.047     0.150
     1.917    33.266     0.150
     1.858    34.418     0.150
     1.858    59.578     0.150
     2.027    61.688     0.150
     2.027    35.625     0.150
     2.092    62.766     0.150
     2.092    35.516     0.150
     2.108    36.008     0.150
     2.108    65.336     0.150
     2.379    39.855     0.150
     2.398    40.348     0.150
     2.333    39.488     0.150
     2.451    41.008     0.150
     2.937    47.555     0.150
     3.255    52.906     0.150
     3.295    51.516     0.150
     3.267    51.316     0.150
     3.460    55.738     0.150
     3.555    56.676     0.150
     3.620    57.805     0.150
     4.178    66.215     0.150
     4.604    71.605     0.150
     4.742    72.438     0.150
     4.806    74.945     0.150
     5.462    82.398     0.150
     6.279    94.555     0.150
     7.128   104.426     0.150
     8.178   119.945     0.150
     8.841   129.906     0.150
    10.826   155.855     0.150
    17.987   252.195     0.150
    20.447   281.148     0.150
    20.563   280.785     0.150
    21.338   289.188     0.150
    25.887   334.688     0.150
     3.460    55.547     0.150
     7.128   104.078     0.150
     7.128   104.707     0.150
     8.178   120.117     0.150
     8.841   129.266     0.150
    12.152   173.078     0.150
    12.880   183.746     0.150
    16.167   228.758     0.150
    17.987   253.258     0.150
    18.752   263.777     0.150
    20.707   282.508     0.150
    21.338   289.066     0.150
    21.381   289.055     0.150
    22.915   306.285     0.150
    23.658   312.438     0.150
    25.014   327.355     0.150
    26.938   346.566     0.150
    28.038   353.836     0.150
    28.779   359.777     0.150
    30.796   375.676     0.150
    33.465   403.207     0.150
    34.139   408.316     0.150
    34.741   410.777     0.150
    36.848   430.457     0.150
    38.019   438.375     0.150
    39.433   451.488     0.150
    40.881   464.988     0.150
    42.605   477.875     0.150
    44.964   495.578     0.150
    45.657   501.375     0.150
    48.237   520.875     0.150
    53.198   558.777     0.150
    56.595   583.398     0.150
    58.772   598.578     0.150
    59.136   602.977     0.150
    59.136   602.746     0.150
    60.182   611.555     0.150
    60.363   609.078     0.150
    62.443   623.477     0.150
    63.608   631.977     0.150
    64.138   635.676     0.150
    64.774   639.375     0.150
    64.774   638.238     0.150
    64.913   640.988     0.150
    67.946   659.988     0.150
    68.685   663.586     0.150
    70.468   676.105     0.150
    70.730   676.695     0.150
    71.213   679.926     0.150
    75.088   701.445     0.150
    83.889   752.168     0.150
    88.204   773.277     0.150
     0.557    16.992     0.150
     0.557     9.980     0.150
     0.597    17.500     0.150
     0.597    10.039     0.150
     0.800    13.020     0.150
     0.937    15.859     0.150
     0.858    28.512     0.150
     0.858    16.371     0.150
     0.980    17.699     0.150
     1.124    20.352     0.150
     1.262    38.480     0.150
     1.262    21.199     0.150
     1.179    21.730     0.150
     1.394    24.141     0.150
     1.466    24.391     0.150
     1.594    26.832     0.150
     1.721    29.980     0.150
     1.912    32.949     0.150
     1.866    33.852     0.150
     2.020    34.902     0.150
     2.091    35.340     0.150
     2.107    36.500     0.150
     2.336    39.223     0.150
     2.372    39.242     0.150
     2.392    39.812     0.150
     2.554    45.191     0.150
     2.456    40.262     0.150
     2.624    43.109     0.150
     2.904    46.902     0.150
     2.934    47.801     0.150
     3.290    52.020     0.150
     3.256    52.359     0.150
     3.251    52.480     0.150
     3.266    51.512     0.150
     3.469    55.762     0.150
     3.558    55.133     0.150
     3.557    57.340     0.150
     3.625    57.762     0.150
     3.602    55.832     0.150
     3.802    58.762     0.150
     3.809    60.191     0.150
     3.882    60.352     0.150
     4.070    63.332     0.150
     4.166    64.492     0.150
     4.257    66.262     0.150
     4.265    65.832     0.150
     4.175    63.723     0.150
     4.329    68.301     0.150
     4.534    70.250     0.150
     4.601    70.691     0.150
     4.747    72.383     0.150
     4.789    71.832     0.150
     4.851    73.570     0.150
     5.023    75.930     0.150
     5.074    78.012     0.150
     5.112    76.922     0.150
     5.424    81.859     0.150
     5.549    84.121     0.150
     5.551    84.770     0.150
     5.566    83.051     0.150
     5.464    81.891     0.150
     5.826    87.133     0.150
     5.764    85.902     0.150
     5.880    88.402     0.150
     6.280    93.723     0.150
     6.398    94.562     0.150
     7.121   104.160     0.150
     7.160   106.020     0.150
     7.176   106.051     0.150
     7.364   108.570     0.150
     7.408   109.430     0.150
     7.528   110.340     0.150
     7.676   112.512     0.150
     7.876   115.840     0.150
     8.077   117.242     0.150
     8.246   119.500     0.150
     8.187   119.340     0.150
     8.974   130.180     0.150
    10.131   146.383     0.150
    10.491   151.391     0.150
    11.141   159.250     0.150
    12.352   176.840     0.150
    12.889   183.512     0.150
    21.348   287.531     0.150
    21.430   288.473     0.150
    22.698   302.051     0.150
    25.044   324.590     0.150
    25.516   329.980     0.150
    25.897   333.480     0.150
     0.533     9.840     0.150
     0.533    17.332     0.150
     0.621    10.020     0.150
     1.125    20.871     0.150
     1.173    21.691     0.150
     1.483    24.863     0.150
     1.922    33.172     0.150
     1.899    33.383     0.150
     2.026    34.762     0.150
     2.080    35.641     0.150
     2.377    39.102     0.150
     2.369    39.012     0.150
     2.404    39.691     0.150
     2.445    40.473     0.150
     2.918    46.211     0.150
     2.954    47.133     0.150
     3.303    51.102     0.150
     3.218    51.402     0.150
     3.272    52.141     0.150
     3.236    51.461     0.150
     3.469    54.363     0.150
     3.499    55.371     0.150
     3.576    55.141     0.150
     3.588    56.441     0.150
     3.572    56.703     0.150
     3.658    56.973     0.150
     3.812    58.750     0.150
     3.833    59.531     0.150
     3.916    60.820     0.150
     3.940    61.641     0.150
     4.089    63.461     0.150
     4.183    63.930     0.150
     4.143    65.051     0.150
     4.277    65.590     0.150
     4.273    66.230     0.150
     4.288    65.973     0.150
     4.556    70.160     0.150
     4.801    72.172     0.150
     4.781    72.270     0.150
     4.870    73.703     0.150
     5.056    76.992     0.150
     5.104    77.461     0.150
     5.127    76.930     0.150
     5.307    80.562     0.150
     5.456    82.230     0.150
     5.486    83.203     0.150
     5.441    81.621     0.150
     5.566    84.480     0.150
     5.577    82.582     0.150
     5.583    84.293     0.150
     5.709    85.270     0.150
     5.733    85.973     0.150
     5.857    88.543     0.150
     5.900    88.242     0.150
     6.271    94.102     0.150
     6.393    94.113     0.150
     6.426    95.863     0.150
     7.207   107.121     0.150
     7.386   109.480     0.150
     7.690   111.480     0.150
     7.893   114.590     0.150
     7.958   116.582     0.150
     8.069   118.570     0.150
     8.104   117.781     0.150
     8.253   119.613     0.150
     8.213   118.570     0.150
     8.507   121.863     0.150
    14.628   206.152     0.150
    15.207   215.191     0.150
    15.438   217.453     0.150
    15.442   217.852     0.150
    15.857   222.672     0.150
    16.148   227.750     0.150
    16.493   231.051     0.150
    16.599   234.762     0.150
    16.806   235.840     0.150
    16.990   239.531     0.150
    17.386   243.871     0.150
    17.636   246.090     0.150
    17.689   247.961     0.150
    17.860   250.152     0.150
    17.958   251.152     0.150
    18.213   254.070     0.150
    18.277   255.492     0.150
    18.631   259.262     0.150
    18.727   260.020     0.150
    18.908   261.473     0.150
    18.998   263.172     0.150
    19.281   266.262     0.150
    19.443   268.582     0.150
    19.480   268.332     0.150
    19.559   269.371     0.150
    19.594   269.250     0.150
    19.683   270.473     0.150
    20.265   276.801     0.150
    20.291   277.793     0.150
    20.420   278.551     0.150
    20.529   279.723     0.150
    20.632   280.602     0.150
    20.985   284.262     0.150
    21.272   288.793     0.150
    21.368   288.020     0.150
    21.358   288.820     0.150
    22.040   296.203     0.150
    22.818   303.102     0.150
    25.056   326.191     0.150
    25.914   334.293     0.150
    26.915   343.281     0.150
    31.271   380.840     0.150
    31.402   382.340     0.150
    32.047   386.832     0.150
    33.435   400.293     0.150
    34.106   407.320     0.150
    36.879   431.613     0.150
    40.093   457.320     0.150
    40.076   457.180     0.150
    40.089   456.840     0.150
    40.843   462.691     0.150
    41.704   469.062     0.150
    41.764   470.500     0.150
    41.868   471.062     0.150
    42.012   471.672     0.150
     2.445    40.941     0.150
     3.499    55.891     0.150
     5.733    85.770     0.150
     7.124   103.891     0.150
     8.213   119.582     0.150
     8.830   129.332     0.150
    10.355   151.242     0.150
    12.902   183.043     0.150
    15.762   223.293     0.150
    17.958   252.730     0.150
    18.727   260.570     0.150
    20.420   279.641     0.150
    20.675   282.293     0.150
    21.368   288.500     0.150
    21.358   288.992     0.150
    22.379   299.312     0.150
    22.884   305.512     0.150
    23.690   312.660     0.150
    23.781   314.852     0.150
    24.892   326.840     0.150
    25.056   326.043     0.150
    24.981   326.312     0.150
    25.540   330.801     0.150
    26.376   341.172     0.150
    26.505   337.070     0.150
    28.003   353.270     0.150
    28.445   356.090     0.150
    28.815   359.391     0.150
    30.189   372.172     0.150
    30.825   375.891     0.150
    30.986   380.590     0.150
    31.020   380.562     0.150
    31.859   386.520     0.150
    33.435   402.090     0.150
    33.435   401.250     0.150
    33.610   402.121     0.150
    33.632   402.090     0.150
    34.106   408.070     0.150
    34.868   412.422     0.150
    36.708   429.902     0.150
    36.879   430.102     0.150
    36.884   430.543     0.150
    37.551   436.043     0.150
    38.054   438.543     0.150
    39.411   450.961     0.150
    40.076   457.281     0.150
    40.093   458.293     0.150
    40.093   458.180     0.150
    40.843   462.910     0.150
    40.849   465.180     0.150
    41.957   472.473     0.150
    42.591   477.570     0.150
    45.147   498.000     0.150
    44.985   496.191     0.150
    45.795   505.172     0.150
    48.264   522.391     0.150
    53.468   563.160     0.150
    58.128   594.441     0.150
    58.813   598.000     0.150
    58.809   598.191     0.150
    59.169   604.191     0.150
    59.169   603.492     0.150
    59.169   602.680     0.150
    59.169   602.891     0.150
    59.440   605.660     0.150
    59.672   604.582     0.150
    59.804   605.992     0.150
    59.946   608.090     0.150
    60.402   609.992     0.150
    60.826   613.090     0.150
    60.826   612.352     0.150
    60.946   615.793     0.150
    63.646   632.992     0.150
    64.813   639.113     0.150
    66.074   647.293     0.150
    66.623   652.863     0.150
    67.122   654.691     0.150
    67.759   658.902     0.150
    67.950   660.582     0.150
    68.091   660.531     0.150
    68.172   661.121     0.150
    68.253   661.691     0.150
    68.544   663.930     0.150
    68.723   663.680     0.150
    68.993   665.180     0.150
    69.273   667.379     0.150
    70.039   672.977     0.150
    70.058   672.918     0.150
    70.061   673.293     0.150
    70.116   673.137     0.150
    70.124   673.613     0.150
    70.324   677.992     0.150
    70.324   674.590     0.150
    70.396   675.562     0.150
    70.396   677.793     0.150
    70.396   677.293     0.150
    70.423   677.992     0.150
    70.503   675.980     0.150
    70.609   677.684     0.150
    70.609   676.961     0.150
    70.609   676.590     0.150
    70.662   676.910     0.150
    70.673   677.230     0.150
    70.673   677.793     0.150
    70.702   676.742     0.150
    70.702   676.891     0.150
    70.768   677.293     0.150
    70.768   676.711     0.150
    70.961   680.391     0.150
    71.046   681.352     0.150
    71.158   679.957     0.150
    71.214   680.637     0.150
    71.248   680.070     0.150
    71.248   679.793     0.150
    71.476   682.695     0.150
    71.558   682.699     0.150
    71.612   682.000     0.150
    72.043   684.793     0.150
    72.149   686.793     0.150
    72.201   686.406     0.150
    72.144   686.082     0.150
    72.440   687.812     0.150
    72.695   692.082     0.150
    73.082   691.715     0.150
    73.082   691.492     0.150
    73.082   691.293     0.150
    73.374   691.180     0.150
    73.343   693.531     0.150
    73.343   691.863     0.150
    73.350   693.121     0.150
    73.351   693.734     0.150
    73.432   695.191     0.150
    73.432   693.934     0.150
    73.432   693.191     0.150
    73.482   692.992     0.150
    73.619   694.805     0.150
    73.619   693.102     0.150
    73.648   695.625     0.150
    73.648   695.301     0.150
    73.713   695.875     0.150
    74.139   698.332     0.150
    74.153   700.031     0.150
    74.480   700.238     0.150
    74.604   700.051     0.150
    74.678   700.691     0.150
    75.202   704.090     0.150
    75.170   703.508     0.150
    75.925   707.750     0.150
    76.020   707.992     0.150
    76.488   713.590     0.150
    76.970   716.480     0.150
    77.165   717.492     0.150
    77.508   717.652     0.150
    77.807   718.133     0.150
    77.918   719.410     0.150
    78.289   724.742     0.150
    78.532   722.973     0.150
    83.924   752.340     0.150
    88.234   772.891     0.150
   159.921  1236.953     0.150
   161.460  1244.793     0.150
     0.484     8.781     0.150
     0.484    15.219     0.150
     0.628    10.719     0.150
     0.628    19.469     0.150
     0.772    24.289     0.150
     0.772    12.602     0.150
     0.950    16.039     0.150
     0.904    16.320     0.150
     0.904    29.375     0.150
     0.928    17.680     0.150
     0.928    30.586     0.150
     1.096    36.156     0.150
     1.096    19.828     0.150
     1.284    38.977     0.150
     1.198    21.852     0.150
     1.198    37.609     0.150
     1.315    40.641     0.150
     1.428    43.891     0.150
     1.476    24.305     0.150
     1.604    48.211     0.150
     1.604    26.766     0.150
     1.677    53.164     0.150
     1.733    55.211     0.150
     1.758    54.320     0.150
     1.758    29.516     0.150
     1.885    31.391     0.150
     1.906    31.852     0.150
     1.942    33.656     0.150
     1.942    62.352     0.150
     2.125    34.930     0.150
     2.067    34.906     0.150
     2.353    38.328     0.150
     2.388    39.648     0.150
     2.398    40.211     0.150
     2.462    40.047     0.150
     2.579    42.695     0.150
     2.906    46.289     0.150
     2.952    47.109     0.150
     3.189    50.688     0.150
     3.220    50.305     0.150
     3.264    51.719     0.150
     3.547    56.156     0.150
     3.612    57.195     0.150
     3.554    54.938     0.150
     3.692    58.102     0.150
     3.838    60.148     0.150
     3.951    60.375     0.150
     3.971    63.141     0.150
    15.833   222.758     0.150
    16.041   225.289     0.150
    21.416   288.758     0.150
    60.437   609.664     0.150
    60.437   609.438     0.150
    67.679   657.797     0.150
    67.742   658.539     0.150
    69.394   668.648     0.150
    69.394   668.766     0.150
    73.771   695.281     0.150
     0.490     8.457     0.150
     0.490    15.547     0.150
     0.637    10.757     0.150
     0.637    19.757     0.150
     0.783    26.767     0.150
     0.783    12.747     0.150
     0.903    16.407     0.150
     0.960    16.297     0.150
     0.922    17.127     0.150
     1.035    19.647     0.150
     1.107    20.457     0.150
     1.187    21.447     0.150
     1.294    21.627     0.150
     1.324    22.387     0.150
     1.392    25.327     0.150
     1.392    45.267     0.150
     1.486    24.877     0.150
     1.688    53.567     0.150
     1.688    29.427     0.150
     1.743    30.867     0.150
     1.767    30.507     0.150
     1.916    32.697     0.150
     1.943    35.527     0.150
     2.013    35.337     0.150
     2.059    36.597     0.150
     2.134    35.537     0.150
     2.363    39.978     0.150
     2.399    40.457     0.150
     2.403    41.577     0.150
     2.452    40.717     0.150
     2.697    45.117     0.150
     2.917    47.127     0.150
     2.962    48.387     0.150
     3.183    51.797     0.150
     3.212    50.767     0.150
     3.546    55.677     0.150
     3.545    56.847     0.150
     3.696    59.157     0.150
     3.804    58.857     0.150
     3.848    60.797     0.150
     4.210    64.747     0.150
     4.295    67.277     0.150
     4.296    68.607     0.150
     4.890    76.177     0.150
     5.127    76.987     0.150
     5.343    80.957     0.150
     5.429    80.627     0.150
     5.571    82.887     0.150
     5.677    84.688     0.150
     5.697    85.757     0.150
     6.298    95.837     0.150
     7.107   104.497     0.150
     7.221   107.707     0.150
     7.580   111.747     0.150
     8.258   121.407     0.150
     9.984   146.947     0.150
    10.182   148.027     0.150
    10.847   156.177     0.150
    12.399   178.177     0.150
    12.936   185.427     0.150
    15.443   218.097     0.150
    15.843   223.597     0.150
    16.139   229.947     0.150
    20.558   277.527     0.150
    21.409   288.967     0.150
    22.456   301.387     0.150
    22.647   303.127     0.150
    22.834   305.177     0.150
    25.091   325.917     0.150
    25.519   331.537     0.150
    25.953   335.467     0.150
     0.660    19.555     0.150
     0.660    10.965     0.150
     0.786    13.766     0.150
     0.978    16.793     0.150
     1.110    36.125     0.150
     1.110    21.133     0.150
     1.313    22.285     0.150
     1.345    22.926     0.150
     1.395    26.383     0.150
     1.503    25.273     0.150
     1.630    27.414     0.150
     1.790    30.484     0.150
     1.927    33.746     0.150
     2.019    34.723     0.150
     1.972    33.625     0.150
     2.156    35.785     0.150
     2.035    35.855     0.150
     2.410    39.906     0.150
     2.432    40.273     0.150
     2.632    45.754     0.150
     2.726    44.453     0.150
     2.729    44.293     0.150
     2.930    46.996     0.150
     2.980    47.383     0.150
     3.155    51.953     0.150
     3.312    52.414     0.150
     3.187    50.543     0.150
     3.725    59.145     0.150
     4.084    63.383     0.150
     4.324    66.914     0.150
     4.652    71.305     0.150
     4.915    74.934     0.150
     5.126    78.145     0.150
     5.357    81.934     0.150
     5.410    81.895     0.150
     5.584    82.965     0.150
     5.725    85.793     0.150
     5.842    88.445     0.150
     7.110   104.695     0.150
     7.201   106.133     0.150
     8.816   130.855     0.150
     9.575   138.793     0.150
    10.013   145.613     0.150
    10.306   150.344     0.150
    10.377   151.414     0.150
    10.838   156.484     0.150
    10.864   156.523     0.150
    12.327   177.246     0.150
    12.231   175.734     0.150
    12.423   179.496     0.150
    12.947   183.586     0.150
    14.141   203.336     0.150
    15.430   220.953     0.150
    15.849   223.863     0.150
    16.121   229.004     0.150
    17.350   246.375     0.150
    17.811   250.625     0.150
    17.912   251.926     0.150
    18.687   260.906     0.150
    18.855   262.445     0.150
    19.704   271.863     0.150
    20.232   277.375     0.150
    20.324   277.723     0.150
    20.375   278.863     0.150
    20.472   280.363     0.150
    20.934   285.625     0.150
    20.991   285.184     0.150
    21.323   288.746     0.150
    21.426   288.766     0.150
    21.999   296.535     0.150
    22.336   300.195     0.150
    22.405   301.195     0.150
    22.622   303.754     0.150
    22.830   306.023     0.150
    24.927   326.145     0.150
    25.102   328.043     0.150
    25.155   327.055     0.150
    25.495   331.254     0.150
    25.920   334.766     0.150
    25.967   334.836     0.150
    26.881   344.355     0.150
    28.961   362.086     0.150
    34.050   407.496     0.150
    39.433   452.734     0.150
    59.226   603.875     0.150
    59.314   604.723     0.150
    60.470   611.695     0.150
    64.250   636.035     0.150
    64.882   640.695     0.150
    68.795   664.633     0.150
    68.789   665.324     0.150
    69.424   669.293     0.150
    69.424   670.234     0.150
    71.516   683.543     0.150
    73.803   697.086     0.150
    74.776   703.664     0.150
    74.809   702.605     0.150
    75.198   704.164     0.150
    77.040   715.656     0.150
    88.283   775.496     0.150
   148.736  1184.793     0.150
   150.329  1193.055     0.150
     5.677    85.344     0.150
     5.725    88.633     0.150
     8.281   119.984     0.150
    10.312   152.234     0.150
    12.947   183.734     0.150
    14.141   204.664     0.150
    16.121   227.496     0.150
    18.687   260.543     0.150
    20.375   280.105     0.150
    20.622   282.355     0.150
    21.323   288.914     0.150
    21.426   288.906     0.150
    22.336   299.746     0.150
    23.745   314.883     0.150
    24.927   326.523     0.150
    25.102   329.645     0.150
    25.495   332.516     0.150
    25.967   335.453     0.150
    26.324   341.324     0.150
    26.493   339.113     0.150
    26.881   346.734     0.150
    27.785   353.645     0.150
    27.945   353.465     0.150
    34.050   407.633     0.150
    34.845   413.676     0.150
    36.658   429.793     0.150
    42.217   474.844     0.150
    59.226   604.703     0.150
    64.882   641.555     0.150
    67.153   656.055     0.150
    67.826   660.824     0.150
    68.119   663.836     0.150
    68.521   667.355     0.150
    70.460   676.613     0.150
    70.678   678.285     0.150
    70.771   677.484     0.150
    70.838   678.023     0.150
    72.244   686.184     0.150
    73.421   694.684     0.150
    73.443   695.355     0.150
    74.140   700.684     0.150
    75.831   708.805     0.150
    76.280   710.734     0.150
    76.682   713.246     0.150
    77.040   717.305     0.150
    77.927   722.074     0.150
    79.623   732.324     0.150
    80.524   735.766     0.150
   157.746  1230.375     0.150
   159.859  1240.852     0.150
     5.725    87.895     0.150
    23.745   314.496     0.150
    40.149   458.594     0.150
    47.197   517.594     0.150
    48.306   523.793     0.150
    49.164   528.895     0.150
    57.635   594.793     0.150
    59.226   605.094     0.150
    61.020   617.496     0.150
    64.250   638.094     0.150
    64.882   640.496     0.150
    73.443   694.195     0.150
     0.577    10.281     0.150
     0.577    18.039     0.150
     0.716    11.891     0.150
     0.716    21.570     0.150
     0.895    29.102     0.150
     0.895    15.602     0.150
     0.843    15.742     0.150
     0.924    16.641     0.150
     1.055    17.938     0.150
     1.074    20.305     0.150
     1.075    19.719     0.150
     1.219    22.594     0.150
     1.381    23.242     0.150
     1.381    42.500     0.150
     1.405    23.820     0.150
     1.405    43.258     0.150
     1.504    48.781     0.150
     1.504    27.523     0.150
     1.583    26.461     0.150
     1.712    28.688     0.150
     1.794    57.258     0.150
     1.794    31.180     0.150
     1.852    32.883     0.150
     1.838    31.312     0.150
     1.872    33.898     0.150
     1.975    33.383     0.150
     1.930    34.680     0.150
     2.023    35.023     0.150
     1.992    35.344     0.150
     2.124    36.758     0.150
     2.209    36.914     0.150
     2.344    39.672     0.150
     2.475    41.539     0.150
     2.436    41.438     0.150
     2.505    41.953     0.150
     2.621    78.430     0.150
     2.644    45.180     0.150
     2.676    46.609     0.150
     2.693    44.398     0.150
     3.019    48.719     0.150
     3.053    49.703     0.150
     3.156    50.859     0.150
     3.153    50.172     0.150
     3.404    52.953     0.150
     3.373    53.922     0.150
     3.491    55.539     0.150
     3.498    56.148     0.150
     3.676    57.430     0.150
     3.664    59.000     0.150
     3.714    59.680     0.150
     3.912    60.383     0.150
     3.928    62.242     0.150
     3.967    62.883     0.150
     4.001    63.828     0.150
     4.072    62.898     0.150
     4.189    65.469     0.150
     4.185    66.344     0.150
     4.283    66.023     0.150
     4.327    68.758     0.150
     4.376    67.969     0.150
     4.385    68.305     0.150
     4.721    73.461     0.150
     4.835    75.523     0.150
     5.186    79.789     0.150
     5.383    82.609     0.150
     5.368    81.570     0.150
     5.413    82.414     0.150
     5.344    80.133     0.150
     5.525    85.242     0.150
     5.553    84.117     0.150
     5.667    87.133     0.150
     5.726    86.164     0.150
     5.782    87.539     0.150
     6.234    93.328     0.150
     6.398    95.984     0.150
     6.453    97.523     0.150
     6.514    97.555     0.150
     7.219   105.805     0.150
     7.207   106.953     0.150
     7.483   110.891     0.150
     7.642   112.328     0.150
     8.123   120.805     0.150
     8.188   120.180     0.150
     9.093   131.805     0.150
    10.245   148.078     0.150
    10.346   151.891     0.150
    10.610   152.172     0.150
    11.242   162.023     0.150
    11.318   163.188     0.150
    12.783   183.164     0.150
    12.832   183.852     0.150
    19.686   270.562     0.150
    20.902   286.102     0.150
    22.722   303.211     0.150
     0.616    10.650     0.150
     0.616    18.610     0.150
     0.608    10.880     0.150
     0.608    18.920     0.150
     1.172    21.170     0.150
     1.172    37.630     0.150
     1.495    24.980     0.150
     1.732    30.120     0.150
     1.835    33.390     0.150
     1.950    33.840     0.150
     2.064    36.590     0.150
     2.105    35.880     0.150
     2.326    39.560     0.150
     2.416    40.670     0.150
     2.429    40.830     0.150
     2.420    41.150     0.150
     2.938    47.640     0.150
     3.425    55.800     0.150
     3.554    57.780     0.150
     3.826    60.630     0.150
     3.862    60.350     0.150
     3.893    60.890     0.150
     4.218    66.100     0.150
     5.273    81.830     0.150
     5.603    83.320     0.150
     5.445    82.550     0.150
     5.617    85.360     0.150
     5.674    85.980     0.150
     7.166   105.021     0.150
     0.429     7.859     0.150
     0.429    14.719     0.150
     0.649    11.445     0.150
     1.071    20.242     0.150
     1.478    24.781     0.150
     1.779    30.008     0.150
     1.895    32.156     0.150
     1.994    34.422     0.150
     2.143    35.039     0.150
     2.331    37.906     0.150
     2.378    39.172     0.150
     2.437    39.969     0.150
     2.745    43.266     0.150
     2.900    45.398     0.150
     2.957    47.180     0.150
     3.149    48.477     0.150
     3.195    49.000     0.150
     3.281    51.008     0.150
     3.262    51.789     0.150
     3.604    55.867     0.150
     3.736    57.438     0.150
     3.853    59.602     0.150
     4.014    61.250     0.150
     4.084    60.938     0.150
     4.776    70.930     0.150
     4.867    72.281     0.150
    15.392   217.297     0.150
    15.811   221.938     0.150
    19.395   268.000     0.150
    21.469   288.586     0.150
    25.146   325.188     0.150
    25.507   327.859     0.150
    26.011   332.695     0.150
    39.440   450.266     0.150
    57.923   591.070     0.150
    59.225   602.000     0.150
    59.297   602.141     0.150
    59.297   602.250     0.150
    59.485   604.070     0.150
    59.543   603.531     0.150
    60.482   608.711     0.150
    60.482   608.602     0.150
    62.581   623.242     0.150
    64.896   638.289     0.150
    67.723   657.008     0.150
    67.787   656.719     0.150
    69.446   667.820     0.150
    69.446   667.820     0.150
    73.819   694.117     0.150
     2.477    40.047     0.150
     2.477    74.156     0.150
     3.604    57.078     0.150
     5.731    85.891     0.150
     5.679    83.867     0.150
     7.071   104.281     0.150
     7.071   183.047     0.150
     8.319   121.352     0.150
    10.324   150.758     0.150
    12.991   185.352     0.150
    16.143   226.828     0.150
    20.387   279.500     0.150
    21.340   287.562     0.150
    21.469   289.781     0.150
    22.348   299.578     0.150
    23.741   313.000     0.150
    24.930   325.680     0.150
    25.146   326.836     0.150
    26.011   333.680     0.150
    27.813   351.047     0.150
    38.160   439.391     0.150
    42.231   475.883     0.150
    58.231   594.695     0.150
    58.919   598.141     0.150
    59.225   602.477     0.150
    64.896   639.000     0.150
    65.425   643.531     0.150
    66.446   648.289     0.150
    67.787   657.180     0.150
    68.197   661.016     0.150
    68.829   663.898     0.150
    70.609   676.281     0.150
    71.354   680.156     0.150
    72.283   687.031     0.150
    73.457   693.188     0.150
    73.736   694.531     0.150
    74.588   700.586     0.150
    74.791   700.742     0.150
    75.846   707.297     0.150
    79.652   729.906     0.150
    83.989   752.117     0.150
     0.501     8.785     0.150
     0.501    16.414     0.150
     0.745    23.234     0.150
     0.745    13.184     0.150
     0.862    14.574     0.150
     0.862    26.555     0.150
     0.938    15.703     0.150
     0.938    31.613     0.150
     0.907    31.504     0.150
     0.907    17.402     0.150
     0.987    18.594     0.150
     1.172    36.105     0.150
     1.172    19.484     0.150
     1.255    23.395     0.150
     1.255    41.363     0.150
     1.511    25.203     0.150
     1.511    45.965     0.150
     1.662    52.152     0.150
     1.693    27.664     0.150
     1.693    54.094     0.150
     1.820    57.312     0.150
     1.873    33.523     0.150
     1.917    34.086     0.150
     1.921    34.605     0.150
     1.834    56.844     0.150
     1.834    31.902     0.150
     1.992    33.883     0.150
     1.992    61.594     0.150
     2.099    35.715     0.150
     2.119    36.895     0.150
     2.119    65.766     0.150
     2.174    37.184     0.150
     2.357    38.945     0.150
     2.357    71.684     0.150
     2.283    38.363     0.150
     2.520    41.453     0.150
     2.584    77.836     0.150
     2.584    42.633     0.150
     2.620    43.605     0.150
     2.620    84.312     0.150
     2.770    85.504     0.150
     2.873    47.035     0.150
     2.883    46.844     0.150
     2.883    46.965     0.150
     2.967    92.176     0.150
     2.969    47.766     0.150
     2.986    92.074     0.150
     3.174    50.504     0.150
     3.174    91.125     0.150
     3.348   104.883     0.150
     3.600    56.645     0.150
     3.669    58.312     0.150
     3.783    58.746     0.150
     3.903   122.266     0.150
     3.903    61.285     0.150
     3.891   117.996     0.150
     3.891    60.215     0.150
     3.998   123.734     0.150
     3.998    62.523     0.150
     4.188   132.164     0.150
     4.520    69.695     0.150
     4.998    76.613     0.150
     5.213    77.945     0.150
     5.912    88.426     0.150
    15.441   223.043     0.150
    15.995   224.395     0.150
    15.927   224.586     0.150
    16.204   228.633     0.150
    16.168   231.184     0.150
    16.241   231.645     0.150
    16.554   236.383     0.150
    16.710   236.895     0.150
    16.739   237.695     0.150
    17.133   242.133     0.150
    17.154   243.215     0.150
    17.399   244.484     0.150
    17.437   245.336     0.150
    18.024   252.535     0.150
    18.486   258.094     0.150
    18.755   260.984     0.150
    19.314   267.035     0.150
    19.917   273.973     0.150
    20.174   276.766     0.150
    21.426   288.746     0.150
    22.692   303.613     0.150
    25.052   325.812     0.150
    25.945   333.875     0.150
    26.312   338.223     0.150
    26.682   342.645     0.150
    28.937   360.215     0.150
    33.185   399.684     0.150
    33.853   405.453     0.150
    37.967   439.934     0.150
    40.427   461.254     0.150
    40.456   460.844     0.150
    41.128   466.402     0.150
    44.551   493.484     0.150
    59.422   604.043     0.150
    62.692   624.695     0.150
    64.405   638.285     0.150
    64.780   638.613     0.150
    65.051   641.516     0.150
    68.874   664.535     0.150
    71.925   686.426     0.150
    73.611   694.184     0.150
    73.824   695.234     0.150
    76.823   715.473     0.150
    77.925   721.035     0.150
    80.943   736.266     0.150
    88.101   771.926     0.150
     2.283    38.613     0.150
     3.669    58.586     0.150
     5.912    88.773     0.150
     7.247   105.773     0.150
     7.247   106.223     0.150
     8.637   126.812     0.150
    10.111   148.953     0.150
    12.898   183.094     0.150
    17.710   249.484     0.150
    18.486   258.824     0.150
    18.569   260.273     0.150
    20.174   277.473     0.150
    20.423   279.484     0.150
    21.123   286.844     0.150
    21.426   289.203     0.150
    22.134   297.562     0.150
    22.634   303.426     0.150
    23.540   313.305     0.150
    23.943   314.926     0.150
    23.943   315.773     0.150
    24.645   324.746     0.150
    24.729   323.645     0.150
    25.052   325.953     0.150
    25.294   330.965     0.150
    25.945   334.055     0.150
    26.315   339.375     0.150
    26.682   344.113     0.150
    27.602   350.195     0.150
    27.751   350.754     0.150
    29.279   363.312     0.150
    31.074   377.973     0.150
    31.821   386.523     0.150
    33.185   400.875     0.150
    33.185   399.145     0.150
    33.417   401.793     0.150
    33.573   402.875     0.150
    33.853   406.383     0.150
    34.792   411.844     0.150
    34.996   415.035     0.150
    35.026   412.676     0.150
    35.026   412.914     0.150
    37.461   435.965     0.150
    38.163   439.824     0.150
    40.346   456.176     0.150
    41.623   469.094     0.150
    45.214   497.973     0.150
    47.040   513.473     0.150
    48.507   522.676     0.150
    49.362   530.773     0.150
    53.627   561.812     0.150
    54.339   567.062     0.150
    54.971   571.504     0.150
    57.342   589.375     0.150
    57.823   593.074     0.150
    58.207   596.574     0.150
    59.058   601.074     0.150
    59.064   600.676     0.150
    59.422   604.414     0.150
    60.185   607.773     0.150
    60.643   611.176     0.150
    63.892   633.473     0.150
    64.405   639.074     0.150
    64.780   638.973     0.150
    64.780   638.734     0.150
    65.051   640.773     0.150
    65.723   645.543     0.150
    65.885   646.402     0.150
    66.868   653.203     0.150
    67.197   656.133     0.150
    67.392   656.516     0.150
    68.068   661.383     0.150
    68.210   662.004     0.150
    68.370   662.883     0.150
    68.396   663.055     0.150
    68.529   663.902     0.150
    68.617   664.465     0.150
    68.654   665.055     0.150
    68.654   664.875     0.150
    68.874   665.074     0.150
    69.087   669.926     0.150
    69.387   668.039     0.150
    69.806   669.723     0.150
    69.970   672.082     0.150
    70.032   672.758     0.150
    70.062   672.949     0.150
    70.061   673.430     0.150
    70.108   674.008     0.150
    70.141   673.238     0.150
    70.163   674.488     0.150
    70.175   673.238     0.150
    70.216   674.297     0.150
    70.491   676.895     0.150
    70.525   676.336     0.150
    70.518   676.945     0.150
    70.772   677.473     0.150
    70.786   678.273     0.150
    70.792   677.676     0.150
    70.835   678.004     0.150
    71.094   679.250     0.150
    71.269   679.848     0.150
    71.358   681.383     0.150
    72.175   685.863     0.150
    72.775   690.254     0.150
    73.210   692.246     0.150
    73.493   694.305     0.150
    73.611   694.773     0.150
    73.611   694.395     0.150
    73.688   694.562     0.150
    73.824   696.016     0.150
    75.041   705.453     0.150
    77.395   716.473     0.150
    84.176   753.523     0.150
    88.163   772.273     0.150
    88.162   772.246     0.150
    88.484   774.176     0.150
     1.255    23.602     0.150
     2.283    71.551     0.150
     2.986    90.422     0.150
     3.669   101.840     0.150
     5.912    89.465     0.150
     6.693   100.402     0.150
     8.333   120.164     0.150
     9.321   137.598     0.150
    12.046   172.629     0.150
    12.624   180.520     0.150
    12.928   187.477     0.150
    15.862   230.059     0.150
    15.895   231.055     0.150
    17.648   248.887     0.150
    18.569   260.996     0.150
    21.123   287.633     0.150
    22.134   297.797     0.150
    23.943   315.410     0.150
    26.318   340.934     0.150
    26.682   344.414     0.150
    28.305   358.652     0.150
    28.937   360.438     0.150
    30.737   379.965     0.150
    33.185   401.461     0.150
    33.417   402.059     0.150
    33.853   406.730     0.150
    35.026   413.133     0.150
    38.163   440.148     0.150
    39.715   456.648     0.150
    40.597   464.145     0.150
    42.020   475.777     0.150
    42.190   476.875     0.150
    45.470   501.625     0.150
    53.479   561.027     0.150
    56.549   584.188     0.150
    57.342   589.621     0.150
    59.514   604.340     0.150
    59.513   604.621     0.150
    60.643   611.375     0.150
    62.692   625.543     0.150
    64.405   639.223     0.150
    65.051   640.965     0.150
    68.396   665.566     0.150
    68.874   665.844     0.150
    71.824   684.152     0.150
    73.508   693.844     0.150
    73.824   696.543     0.150
    74.818   702.105     0.150
    84.815   756.574     0.150
     0.450     7.793     0.150
     0.600    10.412     0.150
     1.049    19.104     0.150
     1.437    24.582     0.150
     1.731    29.863     0.150
     1.861    31.943     0.150
     1.956    34.023     0.150
     1.951    34.443     0.150
     2.095    35.312     0.150
     2.306    38.312     0.150
     2.344    38.963     0.150
     2.387    40.402     0.150
     2.558    44.514     0.150
     2.507    41.822     0.150
     2.864    45.992     0.150
     2.915    47.123     0.150
     2.988    48.354     0.150
     3.246    50.443     0.150
     3.223    51.123     0.150
     3.200    50.332     0.150
     3.244    51.152     0.150
     3.396    53.133     0.150
     3.529    54.912     0.150
     3.595    57.422     0.150
     3.569    56.844     0.150
     3.577    55.854     0.150
     3.749    58.123     0.150
     3.687    58.803     0.150
     3.806    59.643     0.150
     3.964    63.023     0.150
     4.047    63.014     0.150
     4.135    63.562     0.150
     4.134    63.412     0.150
     4.240    65.402     0.150
     4.259    65.652     0.150
     4.225    65.082     0.150
     4.280    66.793     0.150
     4.356    67.344     0.150
     4.525    69.322     0.150
     4.588    70.363     0.150
     4.826    73.443     0.150
     4.811    74.252     0.150
     5.075    76.412     0.150
     5.075    77.793     0.150
     5.100    78.062     0.150
     5.304    81.193     0.150
     5.516    81.662     0.150
     5.470    83.023     0.150
     5.504    82.572     0.150
     5.474    82.312     0.150
     5.697    85.492     0.150
    15.096   213.473     0.150
    15.201   216.252     0.150
    15.367   215.502     0.150
    15.786   220.723     0.150
    15.686   222.693     0.150
    15.684   223.193     0.150
    15.995   224.533     0.150
    16.186   228.252     0.150
    18.217   254.344     0.150
    18.749   261.094     0.150
    19.016   264.014     0.150
    20.149   277.133     0.150
    20.501   277.982     0.150
    20.435   279.094     0.150
    20.677   282.023     0.150
    21.386   288.854     0.150
    21.455   289.482     0.150
    22.112   298.264     0.150
    22.396   299.623     0.150
    22.992   304.723     0.150
    22.892   304.812     0.150
    23.997   316.703     0.150
    24.203   314.863     0.150
     1.049    19.691     0.150
     2.507    40.832     0.150
     2.507    76.428     0.150
     3.244    50.645     0.150
     3.244    97.840     0.150
     3.569    56.543     0.150
     5.681    85.783     0.150
     5.681    85.572     0.150
     5.681    85.979     0.150
     5.729    85.703     0.150
     6.230    93.850     0.150
     6.510    97.297     0.150
     7.049   103.953     0.150
     7.049   104.328     0.150
     8.294   120.402     0.150
     8.294   120.783     0.150
     8.882   130.264     0.150
     9.127   134.604     0.150
    10.372   152.693     0.150
    10.386   153.014     0.150
    12.230   174.133     0.150
    12.234   173.383     0.150
    12.291   174.934     0.150
    12.363   177.936     0.150
    12.728   183.537     0.150
    12.989   184.582     0.150
    14.234   205.588     0.150
    15.096   214.725     0.150
    15.786   222.486     0.150
    15.948   226.385     0.150
    16.136   230.982     0.150
    16.136   231.213     0.150
    16.186   228.562     0.150
    17.438   244.670     0.150
    17.970   252.523     0.150
    18.749   261.992     0.150
    18.804   264.453     0.150
    18.804   264.312     0.150
    20.435   279.594     0.150
    20.677   282.582     0.150
    21.455   289.912     0.150
    21.386   289.303     0.150
    21.386   290.082     0.150
    22.396   300.213     0.150
    22.396   300.408     0.150
    22.891   306.133     0.150
    23.691   312.363     0.150
    23.691   313.402     0.150
    23.691   311.982     0.150
    23.745   315.873     0.150
    23.803   315.332     0.150
    24.905   325.143     0.150
    24.980   326.652     0.150
    25.144   327.193     0.150
    25.555   331.172     0.150
    26.002   334.764     0.150
    26.559   339.822     0.150
    26.559   340.082     0.150
    26.543   340.965     0.150
    26.944   343.242     0.150
    26.944   344.453     0.150
    27.851   351.322     0.150
    27.994   353.752     0.150
    28.507   356.863     0.150
    28.545   358.883     0.150
    28.895   360.354     0.150
    29.351   364.373     0.150
    29.686   368.832     0.150
    30.243   372.982     0.150
    30.816   375.482     0.150
    30.743   376.662     0.150
    30.743   376.934     0.150
    30.957   378.752     0.150
    30.972   379.652     0.150
    30.974   380.453     0.150
    31.019   380.844     0.150
    31.448   384.203     0.150
    31.946   387.893     0.150
    33.155   397.172     0.150
    33.155   398.252     0.150
    33.444   402.283     0.150
    33.444   402.527     0.150
    33.675   403.104     0.150
    33.831   405.594     0.150
    34.103   408.402     0.150
    34.103   408.678     0.150
    34.412   409.562     0.150
    34.330   408.232     0.150
    34.803   411.783     0.150
    34.803   411.002     0.150
    34.803   411.611     0.150
    34.941   413.252     0.150
    34.950   413.363     0.150
    35.507   419.293     0.150
    36.016   422.082     0.150
    36.734   429.604     0.150
    36.734   426.482     0.150
    36.734   429.803     0.150
    36.715   430.213     0.150
    37.631   436.533     0.150
    37.631   436.941     0.150
    37.706   435.922     0.150
    37.706   436.803     0.150
    38.136   439.912     0.150
    38.136   440.143     0.150
    38.151   441.812     0.150
    38.153   442.863     0.150
    38.153   443.010     0.150
    38.574   444.283     0.150
    39.442   451.643     0.150
    39.795   455.443     0.150
    39.795   455.590     0.150
    39.968   455.242     0.150
    39.968   456.229     0.150
    40.097   455.533     0.150
    40.097   456.455     0.150
    40.046   456.943     0.150
    40.091   457.514     0.150
    40.850   465.303     0.150
    40.850   465.896     0.150
    40.884   463.613     0.150
    40.884   463.902     0.150
    40.925   463.553     0.150
    40.962   464.133     0.150
    40.928   466.580     0.150
    41.082   467.793     0.150
    41.082   468.078     0.150
    41.322   466.822     0.150
    41.267   467.412     0.150
    41.262   469.723     0.150
    41.362   470.434     0.150
    41.682   469.543     0.150
    42.019   473.303     0.150
    42.035   473.123     0.150
    42.172   474.104     0.150
    42.228   474.223     0.150
    42.200   476.562     0.150
    42.200   476.729     0.150
    42.257   474.162     0.150
    42.257   474.996     0.150
    42.278   475.783     0.150
    42.278   476.277     0.150
    42.497   477.264     0.150
    42.424   479.322     0.150
    42.502   477.373     0.150
    42.638   478.293     0.150
    43.459   488.303     0.150
    43.650   486.264     0.150
    43.792   487.184     0.150
    43.967   489.242     0.150
    44.379   492.113     0.150
    44.953   495.982     0.150
    44.953   496.633     0.150
    44.953   495.684     0.150
    45.191   497.812     0.150
    45.642   502.123     0.150
    45.642   502.484     0.150
    45.798   505.213     0.150
    46.226   506.492     0.150
    46.782   510.283     0.150
    46.889   512.902     0.150
    46.889   513.377     0.150
    47.044   513.713     0.150
    47.131   513.348     0.150
    48.245   521.783     0.150
    49.029   528.594     0.150
    49.110   529.184     0.150
    49.684   532.002     0.150
    49.684   532.242     0.150
    49.684   533.053     0.150
    49.993   534.553     0.150
    50.233   539.322     0.150
    50.233   539.096     0.150
    50.824   541.104     0.150
    51.807   548.613     0.150
    51.823   546.582     0.150
    51.823   548.684     0.150
    51.823   549.354     0.150
    51.958   549.662     0.150
    52.733   556.303     0.150
    52.756   554.693     0.150
    52.873   557.283     0.150
    53.223   560.203     0.150
    53.540   561.773     0.150
    53.614   562.072     0.150
    53.631   562.783     0.150
    53.735   563.283     0.150
    54.075   566.643     0.150
    54.075   566.428     0.150
    54.262   565.902     0.150
    54.897   571.172     0.150
    55.126   573.623     0.150
    55.126   573.482     0.150
    55.864   580.559     0.150
    56.291   582.242     0.150
    56.291   583.150     0.150
    56.629   583.684     0.150
    56.706   584.014     0.150
    57.088   586.273     0.150
    57.119   587.742     0.150
    57.242   587.623     0.150
    57.589   591.684     0.150
    57.851   592.883     0.150
    57.851   592.684     0.150
    57.971   594.582     0.150
    57.970   592.832     0.150
    58.213   595.252     0.150
    58.245   595.184     0.150
    58.330   595.982     0.150
    58.143   596.123     0.150
    58.736   598.613     0.150
    58.804   601.633     0.150
    58.887   598.783     0.150
    58.957   599.883     0.150
    58.986   600.104     0.150
    59.175   602.133     0.150
    59.175   603.184     0.150
    59.175   602.803     0.150
    59.251   603.076     0.150
    59.478   605.264     0.150
    59.526   604.723     0.150
    59.595   605.072     0.150
    59.760   605.812     0.150
    59.810   606.082     0.150
    59.810   606.242     0.150
    59.788   606.752     0.150
    59.788   606.887     0.150
    59.879   606.402     0.150
    59.979   606.184     0.150
    59.974   607.643     0.150
    59.949   608.752     0.150
    60.220   609.143     0.150
    60.251   609.912     0.150
    60.362   610.943     0.150
    60.362   610.746     0.150
    60.434   609.883     0.150
    60.434   609.684     0.150
    60.428   610.283     0.150
    60.510   611.723     0.150
    60.678   612.113     0.150
    60.847   614.264     0.150
    60.864   613.322     0.150
    60.900   613.273     0.150
    60.900   613.383     0.150
    60.942   614.672     0.150
    60.942   615.232     0.150
    61.008   614.082     0.150
    61.369   616.223     0.150
    61.375   617.172     0.150
    61.631   618.963     0.150
    61.767   619.104     0.150
    61.874   620.383     0.150
    62.084   621.922     0.150
    62.256   624.016     0.150
    62.538   624.684     0.150
    62.538   624.553     0.150
    62.641   625.633     0.150
    62.920   627.053     0.150
    62.937   626.982     0.150
    62.937   627.480     0.150
    63.211   629.943     0.150
    63.174   629.264     0.150
    63.455   631.213     0.150
    63.620   632.002     0.150
    63.673   632.684     0.150
    63.920   634.812     0.150
    64.142   635.184     0.150
    64.222   635.883     0.150
    64.222   636.078     0.150
    64.582   638.773     0.150
    64.726   640.193     0.150
    64.733   639.604     0.150
    64.759   639.803     0.150
    64.848   638.934     0.150
    64.848   638.283     0.150
    64.848   639.729     0.150
    64.917   640.883     0.150
    65.027   640.693     0.150
    65.103   641.863     0.150
    65.153   641.742     0.150
    65.254   642.672     0.150
    65.323   643.293     0.150
    65.374   643.613     0.150
    65.400   642.764     0.150
    65.483   644.854     0.150
    65.700   646.014     0.150
    65.717   645.992     0.150
    65.784   645.803     0.150
    65.879   647.033     0.150
    65.979   647.543     0.150
    65.971   645.293     0.150
    66.148   648.752     0.150
    66.158   648.572     0.150
    66.325   649.902     0.150
    66.413   649.582     0.150
    66.406   650.184     0.150
    66.422   650.143     0.150
    66.438   650.123     0.150
    66.438   650.404     0.150
    66.746   650.283     0.150
    66.647   651.922     0.150
    66.845   652.912     0.150
    66.934   653.863     0.150
    66.987   653.902     0.150
    67.168   655.104     0.150
    67.203   655.463     0.150
    67.353   656.402     0.150
    67.378   656.613     0.150
    67.416   656.873     0.150
    67.570   655.902     0.150
    67.623   658.502     0.150
    67.643   658.203     0.150
    67.650   658.402     0.150
    67.674   657.707     0.150
    67.674   657.184     0.150
    67.701   658.594     0.150
    67.702   658.383     0.150
    67.738   657.264     0.150
    67.738   657.979     0.150
    67.760   659.162     0.150
    67.839   659.703     0.150
    67.859   659.172     0.150
    67.881   660.713     0.150
    67.881   661.232     0.150
    67.938   660.033     0.150
    67.938   659.482     0.150
    68.030   661.203     0.150
    68.063   660.943     0.150
    68.135   661.604     0.150
    68.166   661.662     0.150
    68.171   662.023     0.150
    68.183   661.053     0.150
    68.236   661.803     0.150
    68.252   661.873     0.150
    68.333   662.672     0.150
    68.338   662.434     0.150
    68.340   662.562     0.150
    68.350   662.652     0.150
    68.390   662.832     0.150
    68.390   663.383     0.150
    68.412   662.582     0.150
    68.412   663.229     0.150
    68.421   663.402     0.150
    68.425   662.283     0.150
    68.434   663.363     0.150
    68.503   663.623     0.150
    68.507   663.693     0.150
    68.502   663.553     0.150
    68.524   663.562     0.150
    68.538   663.732     0.150
    68.565   663.934     0.150
    68.565   663.184     0.150
    68.565   663.678     0.150
    68.584   664.094     0.150
    68.609   664.172     0.150
    68.626   664.562     0.150
    68.623   664.502     0.150
    68.694   664.783     0.150
    68.753   665.143     0.150
    68.797   664.373     0.150
    68.797   664.652     0.150
    68.887   665.963     0.150
    68.896   665.482     0.150
    68.896   665.928     0.150
    68.923   666.264     0.150
    68.935   665.973     0.150
    68.984   666.443     0.150
    68.984   665.943     0.150
    69.006   666.912     0.150
    69.041   666.963     0.150
    68.970   665.303     0.150
    69.077   666.732     0.150
    69.109   666.684     0.150
    69.109   667.119     0.150
    69.187   667.973     0.150
    69.091   668.123     0.150
    69.091   668.354     0.150
    69.191   668.203     0.150
    69.091   667.863     0.150
    69.091   668.082     0.150
    69.260   669.344     0.150
    69.150   668.641     0.150
    69.314   668.893     0.150
    69.314   668.582     0.150
    69.400   668.822     0.150
    69.452   669.293     0.150
    69.482   670.980     0.150
    69.792   671.764     0.150
    69.822   672.082     0.150
    69.923   673.133     0.150
    69.980   672.633     0.150
    70.142   673.383     0.150
    70.203   674.633     0.150
    70.203   673.982     0.150
    70.400   674.383     0.150
    70.474   675.713     0.150
    70.474   675.482     0.150
    70.404   676.844     0.150
    70.481   676.123     0.150
    70.480   676.213     0.150
    70.504   676.803     0.150
    70.419   675.412     0.150
    70.480   675.113     0.150
    70.585   676.963     0.150
    70.661   676.572     0.150
    70.661   677.832     0.150
    70.688   677.264     0.150
    70.688   676.883     0.150
    70.682   674.652     0.150
    70.754   677.672     0.150
    70.780   677.662     0.150
    70.780   677.082     0.150
    70.844   677.672     0.150
    70.849   678.482     0.150
    70.849   678.184     0.150
    70.869   678.943     0.150
    70.953   678.572     0.150
    70.974   679.062     0.150
    71.008   679.002     0.150
    71.008   678.883     0.150
    71.041   678.883     0.150
    71.120   679.934     0.150
    71.120   679.383     0.150
    71.128   679.252     0.150
    71.182   678.963     0.150
    71.238   679.773     0.150
    71.289   681.172     0.150
    71.330   680.572     0.150
    71.329   680.783     0.150
    71.343   682.104     0.150
    71.432   682.152     0.150
    71.432   681.582     0.150
    71.447   682.713     0.150
    71.447   681.982     0.150
    71.520   683.033     0.150
    71.869   683.344     0.150
    71.613   682.783     0.150
    71.672   682.383     0.150
    71.674   682.383     0.150
    71.694   682.443     0.150
    71.699   683.643     0.150
    71.699   682.982     0.150
    71.982   684.893     0.150
    71.943   686.264     0.150
    72.121   685.473     0.150
    72.150   686.623     0.150
    72.139   687.143     0.150
    72.164   686.293     0.150
    72.205   685.662     0.150
    72.205   685.283     0.150
    72.234   687.033     0.150
    72.257   686.373     0.150
    72.257   685.883     0.150
    72.183   686.662     0.150
    72.183   687.078     0.150
    72.333   687.582     0.150
    72.484   688.564     0.150
    72.525   688.184     0.150
    72.536   688.943     0.150
    72.561   688.812     0.150
    72.637   689.033     0.150
    72.771   689.232     0.150
    72.904   690.293     0.150
    72.984   690.992     0.150
    73.039   690.742     0.150
    73.160   691.502     0.150
    73.291   692.672     0.150
    73.395   692.963     0.150
    73.409   693.113     0.150
    73.409   694.082     0.150
    73.418   693.002     0.150
    73.426   693.393     0.150
    73.526   694.873     0.150
    73.560   693.463     0.150
    73.565   694.213     0.150
    73.687   695.684     0.150
    73.724   695.002     0.150
    73.725   694.982     0.150
    73.747   694.873     0.150
    73.869   696.633     0.150
    73.869   696.953     0.150
    73.921   696.473     0.150
    73.921   697.104     0.150
    74.138   698.463     0.150
    74.195   698.123     0.150
    74.214   697.502     0.150
    74.422   698.783     0.150
    74.489   700.633     0.150
    74.525   699.633     0.150
    74.557   699.033     0.150
    74.590   699.502     0.150
    74.674   700.193     0.150
    74.689   701.072     0.150
    74.757   700.742     0.150
    74.779   701.582     0.150
    74.865   701.303     0.150
    74.878   702.371     0.150
    74.950   701.854     0.150
    75.282   704.453     0.150
    75.018   702.082     0.150
    75.089   703.672     0.150
    75.189   703.844     0.150
    75.189   704.066     0.150
    75.862   706.803     0.150
    75.862   707.783     0.150
    75.857   708.412     0.150
    76.005   707.662     0.150
    76.085   708.982     0.150
    75.990   707.523     0.150
    76.174   708.264     0.150
    76.138   710.213     0.150
    76.303   710.783     0.150
    76.326   709.482     0.150
    76.310   711.133     0.150
    76.470   711.133     0.150
    77.207   715.729     0.150
    77.386   716.363     0.150
    77.386   717.027     0.150
    77.889   718.203     0.150
    77.982   719.344     0.150
    77.995   719.723     0.150
    78.205   720.562     0.150
    78.311   721.652     0.150
    78.345   722.502     0.150
    78.220   722.434     0.150
    78.220   723.232     0.150
    78.425   722.443     0.150
    78.432   724.322     0.150
    78.653   724.023     0.150
    78.749   724.033     0.150
    78.768   723.562     0.150
    79.576   728.162     0.150
    79.613   729.082     0.150
    79.613   729.232     0.150
    79.613   729.545     0.150
    79.686   729.104     0.150
    79.790   730.252     0.150
    79.790   730.652     0.150
    79.973   730.883     0.150
    80.288   732.963     0.150
    80.492   733.184     0.150
    80.567   733.812     0.150
    81.012   735.963     0.150
    81.477   738.395     0.150
    81.662   739.062     0.150
    82.229   742.912     0.150
    82.954   745.703     0.150
    82.954   746.232     0.150
    83.117   745.613     0.150
    83.017   747.982     0.150
    83.316   748.553     0.150
    83.460   748.703     0.150
    83.399   750.062     0.150
    83.938   752.072     0.150
    84.436   754.033     0.150
    84.580   755.662     0.150
    84.705   754.982     0.150
    84.993   758.203     0.150
    84.993   758.703     0.150
    86.056   761.752     0.150
    86.932   765.594     0.150
    86.932   766.615     0.150
    87.045   766.832     0.150
    87.261   768.193     0.150
    87.662   770.184     0.150
    87.844   770.482     0.150
    87.844   770.930     0.150
    87.734   769.783     0.150
    87.905   770.434     0.150
    87.905   770.775     0.150
    87.905   771.482     0.150
    87.904   770.463     0.150
    88.227   773.184     0.150
    88.335   773.293     0.150
    88.335   773.170     0.150
    88.424   773.383     0.150
    89.095   776.482     0.150
    89.095   777.039     0.150
    89.374   778.143     0.150
    89.856   780.982     0.150
    89.856   779.752     0.150
    89.856   780.090     0.150
    90.045   781.203     0.150
    90.045   780.959     0.150
    90.969   785.844     0.150
    91.287   786.104     0.150
    91.287   786.453     0.150
    91.431   786.844     0.150
    91.530   788.172     0.150
    91.853   789.533     0.150
    92.370   791.293     0.150
    92.433   792.363     0.150
    92.767   794.393     0.150
    93.004   795.492     0.150
    93.084   794.943     0.150
    93.605   795.764     0.150
    93.829   797.162     0.150
    93.829   797.377     0.150
    95.397   804.764     0.150
    95.694   805.803     0.150
    95.694   807.309     0.150
    95.931   808.963     0.150
    96.188   810.082     0.150
    96.300   809.613     0.150
    96.455   808.783     0.150
    96.513   810.373     0.150
    96.574   811.184     0.150
    98.795   822.002     0.150
    98.795   822.957     0.150
    98.960   820.992     0.150
    99.411   823.623     0.150
    99.742   824.533     0.150
    99.742   826.158     0.150
    99.893   825.764     0.150
   100.533   829.707     0.150
   100.617   830.062     0.150
   100.617   831.133     0.150
   103.132   840.893     0.150
   103.132   841.230     0.150
   104.375   848.303     0.150
   105.417   850.604     0.150
   106.155   855.123     0.150
    34.610   411.873     0.150
   157.794  1229.797     0.150
   157.794  1233.557     0.150
   158.288  1231.246     0.150
   158.288  1235.854     0.150
   158.556  1233.270     0.150
   158.556  1236.676     0.150
   159.905  1239.201     0.150
   161.440  1246.088     0.150
    79.973   730.500     0.150
    73.948   698.172     0.150
     0.492     9.119     0.150
     0.492    15.580     0.150
     0.636    11.000     0.150
     0.636    19.279     0.150
     0.783    12.680     0.150
     0.960    16.510     0.150
     0.905    16.260     0.150
     0.920    17.160     0.150
     1.107    20.100     0.150
     1.037    35.240     0.150
     1.037    19.609     0.150
     1.293    39.359     0.150
     1.293    22.420     0.150
     1.323    40.010     0.150
     1.486    25.699     0.150
     1.614    27.131     0.150
     1.765    30.131     0.150
     1.893    32.141     0.150
     1.916    32.910     0.150
     1.941    34.170     0.150
     2.013    34.740     0.150
     2.060    36.381     0.150
     2.364    39.180     0.150
     2.399    39.449     0.150
     2.916    46.029     0.150
     2.961    47.109     0.150
     3.300    51.471     0.150
     3.274    52.119     0.150
     3.454    53.600     0.150
     3.804    58.350     0.150
     3.847    60.461     0.150
     4.095    63.760     0.150
     4.286    65.029     0.150
     4.632    71.100     0.150
     0.465     8.396     0.150
     0.589     9.777     0.150
     1.052    19.607     0.150
     1.431    24.127     0.150
     1.720    29.527     0.150
     1.859    32.207     0.150
     1.844    31.197     0.150
     1.956    34.146     0.150
     1.934    34.877     0.150
     2.085    34.996     0.150
     2.106    36.896     0.150
     2.307    38.156     0.150
     2.342    38.977     0.150
     2.372    40.607     0.150
     2.509    41.916     0.150
     2.860    45.807     0.150
     2.908    46.527     0.150
     2.972    47.938     0.150
     3.243    49.967     0.150
     3.218    50.996     0.150
     3.398    53.516     0.150
     3.524    55.176     0.150
     3.553    57.527     0.150
     3.747    57.676     0.150
     3.671    57.857     0.150
     4.041    62.996     0.150
     4.130    64.188     0.150
     4.233    65.438     0.150
     4.250    65.938     0.150
     4.249    65.957     0.150
     4.517    70.207     0.150
     4.580    71.066     0.150
     4.740    71.537     0.150
     4.820    74.486     0.150
     4.902    76.016     0.150
     5.514    82.127     0.150
     5.769    87.217     0.150
     5.854    88.527     0.150
     5.854    88.557     0.150
    15.368   216.076     0.150
    15.697   222.166     0.150
    15.787   221.527     0.150
    15.996   224.906     0.150
    16.723   235.137     0.150
    17.439   243.807     0.150
    17.682   247.166     0.150
    19.027   263.367     0.150
    19.586   269.316     0.150
    19.766   270.246     0.150
    21.003   284.826     0.150
     0.441    14.631     0.150
     0.441     7.752     0.150
     0.578     9.541     0.150
     0.578    17.650     0.150
     1.023    19.211     0.150
     1.411    24.150     0.150
     1.709    29.211     0.150
     1.709    29.082     0.150
     1.835    31.752     0.150
     1.929    32.762     0.150
     1.946    34.742     0.150
     2.072    34.922     0.150
     2.280    37.531     0.150
     2.318    39.082     0.150
     2.372    40.432     0.150
     2.537    43.041     0.150
     2.837    45.791     0.150
     2.889    46.242     0.150
     2.974    48.742     0.150
     3.197    51.141     0.150
     3.370    53.211     0.150
     3.722    57.150     0.150
     3.674    68.082     0.150
    20.475   278.900     0.150
    20.425   279.881     0.150
    21.271   288.391     0.150
    24.183   318.002     0.150
     1.023    19.699     0.150
     1.023    34.963     0.150
     2.534    42.941     0.150
     2.534    78.014     0.150
     3.266    52.127     0.150
     3.572    58.332     0.150
     3.572    57.230     0.150
     5.666    85.332     0.150
     5.666    85.758     0.150
     6.246    95.369     0.150
     7.024   103.672     0.150
     7.024   102.332     0.150
    12.340   178.293     0.150
    12.255   175.871     0.150
    12.260   175.031     0.150
    12.717   183.633     0.150
    16.154   234.301     0.150
    16.154   233.904     0.150
    16.211   229.842     0.150
    17.412   245.910     0.150
    18.820   264.621     0.150
    23.672   313.102     0.150
    26.018   333.281     0.150
    28.012   353.701     0.150
    28.563   358.836     0.150
    28.902   360.146     0.150
    30.794   376.832     0.150
    30.989   379.971     0.150
    31.039   380.852     0.150
    33.132   398.041     0.150
    33.132   397.717     0.150
    33.465   402.342     0.150
    33.465   401.832     0.150
    33.702   403.480     0.150
    34.122   407.842     0.150
    34.429   409.631     0.150
    34.789   411.432     0.150
    34.789   410.951     0.150
    34.974   412.852     0.150
    36.752   429.592     0.150
    36.752   428.730     0.150
    36.752   430.061     0.150
    36.736   430.391     0.150
    36.931   430.922     0.150
    37.656   437.031     0.150
    37.731   435.992     0.150
    37.731   436.525     0.150
    38.145   439.900     0.150
    38.145   439.520     0.150
    38.170   442.791     0.150
    38.170   442.609     0.150
    39.511   453.531     0.150
    39.799   456.111     0.150
    40.078   455.891     0.150
    40.078   455.432     0.150
    40.078   455.621     0.150
    40.073   456.871     0.150
    40.114   457.551     0.150
    40.870   464.992     0.150
    40.870   464.775     0.150
    40.910   463.441     0.150
    40.951   461.162     0.150
    41.070   466.631     0.150
    41.070   467.041     0.150
    41.070   467.477     0.150
    41.291   467.932     0.150
    41.699   469.230     0.150
    42.045   473.252     0.150
    42.240   474.082     0.150
    42.189   475.691     0.150
    42.189   476.352     0.150
    42.284   474.922     0.150
    42.284   474.654     0.150
    42.302   475.820     0.150
    42.413   478.582     0.150
    42.418   478.061     0.150
    42.664   478.131     0.150
    43.676   486.102     0.150
    44.928   495.432     0.150
    44.928   494.631     0.150
    45.217   498.582     0.150
    45.666   502.391     0.150
    45.666   502.078     0.150
    46.251   504.971     0.150
    46.761   510.332     0.150
    48.222   521.131     0.150
    49.090   529.031     0.150
    49.688   532.289     0.150
    51.825   549.230     0.150
    51.825   549.391     0.150
    51.962   549.672     0.150
    53.202   559.430     0.150
    53.202   559.131     0.150
    54.099   567.025     0.150
    55.100   573.127     0.150
    55.100   572.832     0.150
    55.887   579.898     0.150
    56.757   584.230     0.150
    57.573   591.432     0.150
    57.954   594.531     0.150
    58.313   596.531     0.150
    58.957   599.631     0.150
    59.156   601.932     0.150
    59.156   602.260     0.150
    59.227   603.256     0.150
    59.452   605.289     0.150
    59.539   606.230     0.150
    59.539   605.090     0.150
    59.764   606.582     0.150
    59.967   605.230     0.150
    60.337   610.490     0.150
    60.337   610.730     0.150
    60.421   609.781     0.150
    60.421   609.531     0.150
    60.437   609.531     0.150
    60.904   612.631     0.150
    61.006   614.332     0.150
    61.869   619.832     0.150
    62.107   622.320     0.150
    62.534   623.531     0.150
    62.534   624.502     0.150
    62.912   627.730     0.150
    63.659   632.131     0.150
    64.149   632.531     0.150
    64.213   634.730     0.150
    64.213   635.727     0.150
    64.837   638.332     0.150
    64.837   639.426     0.150
    64.921   640.531     0.150
    67.661   656.980     0.150
    67.661   656.730     0.150
    67.725   656.730     0.150
    67.725   657.676     0.150
    67.946   658.631     0.150
    68.163   660.832     0.150
    68.401   662.230     0.150
    68.419   662.676     0.150
    68.513   664.031     0.150
    68.513   663.650     0.150
    68.573   662.730     0.150
    68.573   663.398     0.150
    68.801   664.551     0.150
    68.904   665.631     0.150
    68.904   665.523     0.150
    69.117   666.531     0.150
    68.993   665.674     0.150
    69.117   668.410     0.150
    69.489   670.332     0.150
    70.150   673.432     0.150
    70.406   674.432     0.150
    70.436   675.531     0.150
    70.481   675.631     0.150
    70.489   675.832     0.150
    70.673   676.932     0.150
    70.696   676.832     0.150
    70.786   677.131     0.150
    70.866   678.398     0.150
    71.048   678.832     0.150
    71.128   679.531     0.150
    71.454   681.832     0.150
    71.600   682.432     0.150
    72.213   684.832     0.150
    72.265   685.531     0.150
    72.209   686.484     0.150
    72.477   688.221     0.150
    73.398   692.730     0.150
    73.398   693.650     0.150
    73.674   694.684     0.150
    73.885   696.252     0.150
    75.862   707.230     0.150
    75.862   707.801     0.150
    76.084   707.531     0.150
    76.303   710.531     0.150
    77.002   714.332     0.150
    77.198   715.301     0.150
    79.612   729.332     0.150
    79.612   729.895     0.150
    79.794   730.150     0.150
    79.976   730.832     0.150
    81.451   738.266     0.150
    84.564   755.311     0.150
    86.035   761.898     0.150
    87.823   770.471     0.150
    87.884   769.730     0.150
    87.884   770.826     0.150
    87.757   769.432     0.150
    88.205   772.730     0.150
    89.830   781.127     0.150
    90.048   781.082     0.150
    91.313   786.025     0.150
    92.984   795.271     0.150
    98.770   821.980     0.150
   157.811  1229.385     0.150
   158.306  1231.885     0.150
   159.921  1238.355     0.150
   161.455  1246.078     0.150
    73.973   698.021     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
