#!/bin/bash
gmt begin hubbard6.23_sel1 pdf,ps
proj=-JM16.0c+
reg=-R-140.1/-139.3/60.2/60.8
gmt basemap $proj $reg -Bxa0.2f0.1 -Bya0.2f0.1 -BWeSn+t'Base Map hubbard6.23'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -139.467    60.401 97
  -139.381    60.311 98
  -139.457    60.405 99
  -139.434    60.386 100
  -139.764    60.550 101
  -139.359    60.384 102
  -139.853    60.523 103
  -139.816    60.522 104
  -139.841    60.522 105
  -140.027    60.597 106
  -139.841    60.518 107
  -139.551    60.462 108
  -139.564    60.471 109
  -139.720    60.558 110
  -139.458    60.402 111
  -139.944    60.559 112
  -139.885    60.541 113
  -139.465    60.421 114
  -139.952    60.551 115
  -139.860    60.623 116
  -139.939    60.598 117
  -139.814    60.536 118
  -139.442    60.405 119
  -139.867    60.544 120
  -139.861    60.568 121
  -139.898    60.550 122
  -139.670    60.583 123
  -139.452    60.405 124
  -139.835    60.561 125
  -139.784    60.594 126
  -139.595    60.482 127
  -139.583    60.477 128
  -139.867    60.514 129
  -139.913    60.498 130
  -139.519    60.377 131
  -139.493    60.412 132
  -139.948    60.549 133
  -139.815    60.557 134
  -139.541    60.440 135
  -139.376    60.388 136
  -139.856    60.626 137
  -139.865    60.617 138
  -139.838    60.586 139
  -139.867    60.539 140
  -139.845    60.540 141
  -139.821    60.514 142
  -139.634    60.582 143
  -139.795    60.658 144
  -139.885    60.483 145
  -139.472    60.410 146
  -139.954    60.519 147
  -139.845    60.543 148
  -139.960    60.536 149
  -140.008    60.519 150
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -139.546    60.359
  -139.467    60.401
>
  -139.443    60.245
  -139.381    60.311
>
  -139.567    60.315
  -139.457    60.405
>
  -139.492    60.289
  -139.434    60.386
>
  -139.840    60.481
  -139.764    60.550
>
  -139.365    60.376
  -139.359    60.384
>
  -139.922    60.518
  -139.853    60.523
>
  -139.949    60.478
  -139.816    60.522
>
  -140.086    60.476
  -139.841    60.522
>
  -140.230    60.555
  -140.027    60.597
>
  -139.932    60.507
  -139.841    60.518
>
  -139.684    60.444
  -139.551    60.462
>
  -139.634    60.475
  -139.564    60.471
>
  -139.899    60.566
  -139.720    60.558
>
  -139.649    60.415
  -139.458    60.402
>
  -140.095    60.563
  -139.944    60.559
>
  -139.990    60.554
  -139.885    60.541
>
  -139.530    60.453
  -139.465    60.421
>
  -140.051    60.539
  -139.952    60.551
>
  -139.941    60.627
  -139.860    60.623
>
  -140.131    60.592
  -139.939    60.598
>
  -139.951    60.478
  -139.814    60.536
>
  -139.487    60.420
  -139.442    60.405
>
  -140.077    60.499
  -139.867    60.544
>
  -140.042    60.536
  -139.861    60.568
>
  -140.000    60.529
  -139.898    60.550
>
  -139.873    60.493
  -139.670    60.583
>
  -139.475    60.507
  -139.452    60.405
>
  -139.935    60.580
  -139.835    60.561
>
  -139.997    60.548
  -139.784    60.594
>
  -139.614    60.445
  -139.595    60.482
>
  -139.651    60.479
  -139.583    60.477
>
  -139.865    60.509
  -139.867    60.514
>
  -140.075    60.450
  -139.913    60.498
>
  -139.594    60.340
  -139.519    60.377
>
  -139.499    60.372
  -139.493    60.412
>
  -140.021    60.542
  -139.948    60.549
>
  -139.830    60.519
  -139.815    60.557
>
  -139.605    60.429
  -139.541    60.440
>
  -139.385    60.395
  -139.376    60.388
>
  -139.956    60.533
  -139.856    60.626
>
  -139.995    60.614
  -139.865    60.617
>
  -139.967    60.582
  -139.838    60.586
>
  -139.983    60.524
  -139.867    60.539
>
  -139.895    60.495
  -139.845    60.540
>
  -140.003    60.504
  -139.821    60.514
>
  -139.746    60.549
  -139.634    60.582
>
  -139.986    60.636
  -139.795    60.658
>
  -139.809    60.494
  -139.885    60.483
>
  -139.613    60.421
  -139.472    60.410
>
  -140.124    60.476
  -139.954    60.519
>
  -140.021    60.544
  -139.845    60.543
>
  -140.073    60.470
  -139.960    60.536
>
  -140.293    60.479
  -140.008    60.519
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -139.467    60.401
  -139.467    60.401
>
  -139.381    60.311
  -139.381    60.311
>
  -139.457    60.405
  -139.457    60.405
>
  -139.438    60.387
  -139.434    60.386
>
  -139.763    60.549
  -139.764    60.550
>
  -139.360    60.384
  -139.359    60.384
>
  -139.851    60.523
  -139.853    60.523
>
  -139.815    60.522
  -139.816    60.522
>
  -139.841    60.522
  -139.841    60.522
>
  -140.034    60.596
  -140.027    60.597
>
  -139.838    60.517
  -139.841    60.518
>
  -139.550    60.463
  -139.551    60.462
>
  -139.564    60.471
  -139.564    60.471
>
  -139.719    60.558
  -139.720    60.558
>
  -139.458    60.402
  -139.458    60.402
>
  -139.946    60.559
  -139.944    60.559
>
  -139.886    60.541
  -139.885    60.541
>
  -139.464    60.421
  -139.465    60.421
>
  -139.954    60.550
  -139.952    60.551
>
  -139.859    60.623
  -139.860    60.623
>
  -139.939    60.597
  -139.939    60.598
>
  -139.813    60.536
  -139.814    60.536
>
  -139.439    60.405
  -139.442    60.405
>
  -139.866    60.544
  -139.867    60.544
>
  -139.860    60.568
  -139.861    60.568
>
  -139.897    60.549
  -139.898    60.550
>
  -139.670    60.582
  -139.670    60.583
>
  -139.451    60.404
  -139.452    60.405
>
  -139.834    60.562
  -139.835    60.561
>
  -139.782    60.594
  -139.784    60.594
>
  -139.596    60.482
  -139.595    60.482
>
  -139.583    60.477
  -139.583    60.477
>
  -139.866    60.514
  -139.867    60.514
>
  -139.913    60.498
  -139.913    60.498
>
  -139.517    60.377
  -139.519    60.377
>
  -139.496    60.412
  -139.493    60.412
>
  -139.947    60.549
  -139.948    60.549
>
  -139.816    60.557
  -139.815    60.557
>
  -139.540    60.440
  -139.541    60.440
>
  -139.376    60.388
  -139.376    60.388
>
  -139.854    60.625
  -139.856    60.626
>
  -139.864    60.617
  -139.865    60.617
>
  -139.839    60.586
  -139.838    60.586
>
  -139.870    60.539
  -139.867    60.539
>
  -139.844    60.540
  -139.845    60.540
>
  -139.820    60.514
  -139.821    60.514
>
  -139.633    60.582
  -139.634    60.582
>
  -139.795    60.658
  -139.795    60.658
>
  -139.885    60.482
  -139.885    60.483
>
  -139.471    60.410
  -139.472    60.410
>
  -139.954    60.519
  -139.954    60.519
>
  -139.845    60.543
  -139.845    60.543
>
  -139.961    60.537
  -139.960    60.536
>
  -140.009    60.519
  -140.008    60.519
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -139.467    60.401   -42.985     2.207     2.716
  -139.381    60.311   -39.779     1.852     2.888
  -139.457    60.405   -42.848     1.905     2.899
  -139.434    60.386   -80.744     3.523     6.135
  -139.764    60.550   -52.243     1.756     2.403
  -139.359    60.384   -59.714     1.667     2.153
  -139.853    60.523   -40.376     1.375     3.022
  -139.816    60.522   -27.344     2.163     2.232
  -139.841    60.522   -51.035     2.504     3.343
  -140.027    60.597    89.835     2.103     3.377
  -139.841    60.518   -33.229     2.345     2.953
  -139.551    60.462   -63.426     2.235     2.918
  -139.564    60.471   -49.910     1.122     1.503
  -139.720    60.558   -63.320     1.466     1.814
  -139.458    60.402   -74.182     1.384     2.059
  -139.944    60.559   -46.828     1.984     2.580
  -139.885    60.541   -40.651     1.649     1.910
  -139.465    60.421   -63.300     1.569     2.246
  -139.952    60.551   -80.743     1.416     1.756
  -139.860    60.623   -42.540     2.164     3.697
  -139.939    60.598   -53.871     2.858     4.318
  -139.814    60.536   -66.879     1.563     2.223
  -139.442    60.405   -50.947     1.280     1.590
  -139.867    60.544   -59.171     2.307     2.670
  -139.861    60.568   -63.819     2.003     2.333
  -139.898    60.550   -76.311     1.734     3.218
  -139.670    60.583   -61.862     1.064     1.663
  -139.452    60.405   -82.236     1.063     1.942
  -139.835    60.561   -52.471     1.247     2.192
  -139.784    60.594    88.621     2.355     4.103
  -139.595    60.482   -18.199     2.252     2.635
  -139.583    60.477   -57.981     2.037     2.167
  -139.867    60.514   -44.661     1.319     1.599
  -139.913    60.498   -85.230     1.622     2.513
  -139.519    60.377   -59.042     1.047     1.354
  -139.493    60.412   -48.381     1.631     2.275
  -139.948    60.549   -51.213     1.982     2.411
  -139.815    60.557   -54.220     1.457     1.883
  -139.541    60.440   -47.821     1.440     1.755
  -139.376    60.388   -72.274     1.319     1.809
  -139.856    60.626   -77.326     1.806     2.582
  -139.865    60.617   -46.954     1.496     2.276
  -139.838    60.586   -69.817     1.425     2.172
  -139.867    60.539   -50.728     2.154     2.816
  -139.845    60.540   -39.594     1.703     2.573
  -139.821    60.514   -70.812     2.380     4.949
  -139.634    60.582   -37.596     1.315     1.973
  -139.795    60.658   -10.757     2.924     3.818
  -139.885    60.483    65.454     3.167     3.744
  -139.472    60.410   -41.329     1.342     1.643
  -139.954    60.519   -66.861     1.056     1.416
  -139.845    60.543   -38.882     1.920     4.659
  -139.960    60.536   -32.264     3.154     4.070
  -140.008    60.519   -72.088     1.814     2.233
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -139.467    60.401     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -140.025    60.265    64.907     2.210     2.379
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -140.003    60.265   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -140.025    60.265     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -140.025    60.265     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -140.025    60.220   5 km
EOF
gmt end
