#!/bin/bash
gmt begin hubbard6.23_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-20/20/-20/20
gmt basemap $proj $reg -Bxa10f5+l'km' -Bya10f5+l'km' -BWeSn+t'Epicentral Mislocation hubbard6.23'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     8.977     8.977
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.386    -5.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.023     2.498
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.940     6.101
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.371     5.325
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.799    -3.459
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.779    12.655
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.779    12.655 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.172    -1.069
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.172    -1.069 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.207     1.125
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.165    -4.873
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.968     8.919
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.968     8.919 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.295     2.097
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.765    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.269    -3.849
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.953     1.582
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.742     5.623
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.629    12.071
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.629    12.071 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.694     2.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.721    -3.865
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.094    10.445
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.094    10.445 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.000     5.161
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.000     5.161 20
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.285     5.926
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.753     3.653
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.519     7.146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.725     6.359
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.220    -0.262
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.441    -0.370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.804    -4.560
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.982    -3.001
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.583    -7.145
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.583    -7.145 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.343     9.436
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.343     9.436 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.631    -0.653
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.276    -0.802
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.645    -3.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.518    -0.863
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.317    -1.747
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.573     1.255
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.460    -1.337
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.392     6.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.185     2.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.011    -2.234
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.507    -1.223
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.094     1.788
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.968    -3.276
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.490     2.016
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.798    -1.880
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.786    -0.124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.263    -0.885
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.144    -0.535
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.932     1.009
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.089    -2.566
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.417     3.692
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.447    -2.363
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.771    -1.815
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.626     3.129
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.199    -0.147
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.413    -1.658
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.097    -2.859
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.285    -0.474
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.197     1.445
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.139     2.682
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.851    -0.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.666     2.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.842    -2.193
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.056     1.610
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.446     2.814
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.707     1.587
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.242    -1.690
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.166    -5.350
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.548     2.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.006     3.088
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.401    -4.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.265    -0.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.602     0.697
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.568    -3.963
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.447     7.400
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.027     1.525
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.422     2.565
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.890    -1.949
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.345    -0.414
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.010    -2.010
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.412    -4.541
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.708    -0.947
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.525     0.814
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.439    -2.785
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.951     2.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.759     4.794
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.950    -1.208
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.315    -3.252
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.986    -3.849
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.347    -1.165
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.044     2.940
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.857    -0.596
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.156   -15.859
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.156   -15.859 93
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.815     1.240
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.311     4.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.055     1.985
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.401    -4.719
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.434    -7.365
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.056   -10.079
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.056   -10.079 99
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.301   -10.797
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.301   -10.797 100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.149    -7.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.345    -0.947
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.796    -0.601
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.319    -4.937
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.464    -5.168
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.464    -5.168 105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.103    -4.713
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.103    -4.713 106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.056    -1.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.340    -2.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.863     0.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.826     0.860
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.826     0.860 110
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.539     1.481
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.539     1.481 111
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.294     0.435
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.757     1.435
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.564     3.564
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.431    -1.354
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.460     0.390
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.546    -0.737
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.546    -0.737 117
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.521    -6.538
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.521    -6.538 118
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.461     1.598
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.502    -5.121
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.502    -5.121 120
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.935    -3.616
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.935    -3.616 121
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.573    -2.252
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.156   -10.045
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.156   -10.045 123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.403    11.427
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.403    11.427 124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.507     2.004
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.690    -5.205
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.690    -5.205 126
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.028    -4.124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.741     0.196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.091    -0.576
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.933    -5.367
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.933    -5.367 130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.166    -4.166
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.315    -4.509
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.054    -0.788
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.835    -4.294
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.512    -1.209
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.478     0.708
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.506   -10.354
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.506   -10.354 137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.128    -0.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.068    -0.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.393    -1.713
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.773    -5.002
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.990    -1.050
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.990    -1.050 142
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.177    -3.711
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.398    -2.593
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.398    -2.593 144
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.189     1.281
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.787     1.094
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.394    -4.786
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.394    -4.786 147
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.663     0.169
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.663     0.169 148
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.199    -7.388
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.199    -7.388 149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.656    -4.489
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -15.656    -4.489 150
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -3.057    -0.540     0.000     1.500     1.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -18.500    18.500 Author: all ( 150 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -18.500   -18.500 Average =   3.1 km at 260.0 deg; median =    4.5 km
EOF
gmt end
