#!/bin/bash
gmt begin hubbard6.23_ell pdf,ps
proj=-JM16.0c+
reg=-R-140.1/-138.9/59.8/60.8
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map hubbard6.23'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -139.487    60.100    22.679     2.218     3.866
  -139.615    60.112    17.932     0.492     1.938
  -139.443    60.123    -7.354     1.436     2.153
  -139.464    60.115    -8.086     1.400     2.127
  -139.228    60.124    33.385     2.358     3.557
  -139.277    60.077   -72.477     1.610     2.405
  -139.294    60.081   -69.032     1.708     2.760
  -139.382    60.108   -62.179     1.201     1.894
  -139.646    60.215   -40.399     1.411     1.907
  -139.122    59.905     6.478     3.287     4.286
  -139.574    60.143   -17.131     1.693     2.384
  -139.051    59.965   -24.216     3.376     4.235
  -139.659    60.230   -83.839     1.893     2.571
  -139.587    60.228   -25.218     1.720     2.471
  -139.565    60.224   -29.924     1.713     3.047
  -139.411    60.151    20.342     2.170     2.399
  -139.397    60.136   -29.074     1.789     3.223
  -139.295    59.967    25.426     2.769     3.277
  -139.350    60.151     1.624     1.710     2.314
  -139.834    60.088   -55.348     1.723     2.505
  -139.598    60.207    -0.975     2.721     3.259
  -139.727    60.234   -27.390     1.278     1.544
  -139.367    60.120   -64.758     0.921     1.300
  -139.390    60.107   -57.657     0.977     1.397
  -139.373    60.124   -16.322     1.588     1.880
  -139.352    60.148   -35.320     1.444     1.625
  -139.378    60.132    -4.697     1.610     2.042
  -139.477    60.347   -44.359     2.005     3.432
  -139.382    60.126   -61.969     2.014     3.511
  -139.497    60.126   -53.649     1.340     2.886
  -139.808    60.077    84.908     0.928     1.364
  -139.531    60.180    37.621     1.490     1.860
  -139.621    60.189    64.347     1.038     1.273
  -139.569    60.189    30.534     0.821     1.199
  -139.183    60.204    51.858     1.142     1.614
  -139.616    60.209    36.148     1.327     1.380
  -139.428    60.072    36.196     1.535     1.759
  -139.618    60.186    41.505     0.907     1.053
  -139.433    60.098    42.392     0.718     1.058
  -139.471    60.008    13.778     1.895     2.352
  -139.383    60.065    27.261     1.182     1.529
  -139.413    60.060    45.691     1.040     1.544
  -139.433    60.182    57.272     1.308     1.607
  -139.513    60.154    68.800     0.582     0.711
  -139.201    60.210    87.569     0.927     0.992
  -139.528    60.177   -22.698     0.722     0.806
  -139.516    60.179     9.806     0.625     0.642
  -139.562    60.228   -29.662     0.743     0.799
  -139.575    60.234    -2.855     0.744     0.911
  -139.419    60.098   -75.021     1.195     1.384
  -139.487    60.152   -34.017     0.657     0.687
  -139.446    60.109    82.436     0.772     0.912
  -139.493    60.161   -48.494     0.653     0.696
  -139.562    60.426   -84.662     0.823     0.885
  -139.549    60.215    79.500     0.817     0.900
  -139.780    60.186    61.751     1.025     1.144
  -139.393    60.092   -82.111     0.943     0.999
  -139.151    59.913    86.763     0.854     1.234
  -139.768    60.295   -15.374     1.189     1.519
  -139.633    60.297    35.729     0.722     0.743
  -139.368    59.975   -78.330     0.793     1.019
  -139.476    60.093   -47.954     1.139     1.187
  -139.354    59.969   -83.882     1.026     1.219
  -139.360    59.976     0.812     1.387     1.516
  -139.363    59.973   -76.782     0.630     0.778
  -139.782    60.278   -16.269     1.237     1.304
  -139.452    60.095   -44.201     0.796     0.802
  -139.556    59.985   -78.076     2.029     3.241
  -139.112    59.970    75.034     0.753     0.972
  -139.644    60.230    25.509     0.825     0.921
  -139.229    59.996    83.194     1.304     1.488
  -139.549    60.369    81.885     1.120     1.349
  -139.176    60.008    85.423     0.701     1.148
  -139.844    60.254    65.288     1.011     1.038
  -139.568    60.201    77.402     0.714     1.158
  -139.557    60.201    86.458     0.938     1.203
  -139.224    59.974    73.765     1.577     2.148
  -138.990    60.441    41.282     1.172     1.460
  -139.497    60.148    52.418     1.327     1.567
  -139.261    60.036    64.064     1.371     1.662
  -139.831    60.450    53.139     1.469     1.764
  -139.847    60.165   -57.244     2.808     5.350
  -139.422    60.101    74.504     1.460     1.519
  -139.410    60.098   -50.480     1.487     1.619
  -139.813    60.289    70.046     1.081     1.318
  -139.253    59.947    45.812     1.514     1.973
  -139.080    60.454    -9.921     1.703     2.332
  -139.816    60.318    80.535     0.995     1.299
  -139.644    60.214    -8.337     1.230     1.623
  -139.623    60.208    -0.718     2.107     2.738
  -139.480    59.964    30.683     1.494     1.604
  -139.864    60.114    89.541     1.415     1.788
  -139.663    60.199   -16.070     2.907     3.079
  -139.450    60.115     6.324     1.666     1.769
  -139.274    60.070    23.118     1.061     1.417
  -139.256    60.069    24.375     1.045     1.357
  -139.467    60.401   -42.985     2.207     2.716
  -139.381    60.311   -39.779     1.852     2.888
  -139.457    60.405   -42.848     1.905     2.899
  -139.434    60.386   -80.744     3.523     6.135
  -139.764    60.550   -52.243     1.756     2.403
  -139.359    60.384   -59.714     1.667     2.153
  -139.853    60.523   -40.376     1.375     3.022
  -139.816    60.522   -27.344     2.163     2.232
  -139.841    60.522   -51.035     2.504     3.343
  -140.027    60.597    89.835     2.103     3.377
  -139.841    60.518   -33.229     2.345     2.953
  -139.551    60.462   -63.426     2.235     2.918
  -139.564    60.471   -49.910     1.122     1.503
  -139.720    60.558   -63.320     1.466     1.814
  -139.458    60.402   -74.182     1.384     2.059
  -139.944    60.559   -46.828     1.984     2.580
  -139.885    60.541   -40.651     1.649     1.910
  -139.465    60.421   -63.300     1.569     2.246
  -139.952    60.551   -80.743     1.416     1.756
  -139.860    60.623   -42.540     2.164     3.697
  -139.939    60.598   -53.871     2.858     4.318
  -139.814    60.536   -66.879     1.563     2.223
  -139.442    60.405   -50.947     1.280     1.590
  -139.867    60.544   -59.171     2.307     2.670
  -139.861    60.568   -63.819     2.003     2.333
  -139.898    60.550   -76.311     1.734     3.218
  -139.670    60.583   -61.862     1.064     1.663
  -139.452    60.405   -82.236     1.063     1.942
  -139.835    60.561   -52.471     1.247     2.192
  -139.784    60.594    88.621     2.355     4.103
  -139.595    60.482   -18.199     2.252     2.635
  -139.583    60.477   -57.981     2.037     2.167
  -139.867    60.514   -44.661     1.319     1.599
  -139.913    60.498   -85.230     1.622     2.513
  -139.519    60.377   -59.042     1.047     1.354
  -139.493    60.412   -48.381     1.631     2.275
  -139.948    60.549   -51.213     1.982     2.411
  -139.815    60.557   -54.220     1.457     1.883
  -139.541    60.440   -47.821     1.440     1.755
  -139.376    60.388   -72.274     1.319     1.809
  -139.856    60.626   -77.326     1.806     2.582
  -139.865    60.617   -46.954     1.496     2.276
  -139.838    60.586   -69.817     1.425     2.172
  -139.867    60.539   -50.728     2.154     2.816
  -139.845    60.540   -39.594     1.703     2.573
  -139.821    60.514   -70.812     2.380     4.949
  -139.634    60.582   -37.596     1.315     1.973
  -139.795    60.658   -10.757     2.924     3.818
  -139.885    60.483    65.454     3.167     3.744
  -139.472    60.410   -41.329     1.342     1.643
  -139.954    60.519   -66.861     1.056     1.416
  -139.845    60.543   -38.882     1.920     4.659
  -139.960    60.536   -32.264     3.154     4.070
  -140.008    60.519   -72.088     1.814     2.233
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -139.467    60.401     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -140.027    59.858    64.907     2.210     2.379
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -140.004    59.858   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -140.027    59.858     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -140.027    59.858     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -140.027    59.814   5 km
EOF
gmt end
