#!/bin/bash
gmt begin hubbard6.23_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-20/15/0/16
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation hubbard6.23' << EOF
    -0.000
    -7.000
    -2.000
    -3.000
    -3.000
   -13.000
   -15.000
    -4.000
    -2.000
    -8.800
   -14.000
    -7.000
    -4.000
    -7.000
   -11.300
     2.000
     1.000
    -3.000
    -0.000
    -5.200
    -9.000
    -3.000
    -1.500
    -8.200
    -1.000
     3.000
    -7.000
    -6.000
    -5.000
    -2.000
   -10.000
    -5.900
   -12.100
     3.200
    -1.000
     3.000
    -0.000
    -8.100
    -4.000
    -3.000
    -1.000
    -1.500
    -6.000
    -2.300
    -3.000
   -10.300
    -7.500
    -7.800
    -8.600
    -7.000
   -10.500
    -4.700
     3.100
     1.000
    -6.700
    -2.000
    -3.000
    -2.800
     1.000
   -10.900
   -12.000
   -10.000
    -3.900
    -1.600
    -3.700
    -6.900
    -6.900
   -14.000
    -4.300
    -7.100
    -7.500
    -0.000
    -7.100
     7.500
    -5.000
    -5.000
    -3.400
    -4.000
    -9.000
   -12.400
    -4.400
   -13.000
    -1.400
    -3.400
    -4.500
   -13.000
     1.000
    -9.500
    -4.900
    -4.000
    -5.600
   -12.200
    -5.000
    -0.800
    -3.200
     0.100
     2.000
     1.000
    10.000
     7.000
     8.000
    -1.200
     5.000
    10.100
     2.000
     4.000
     5.000
     6.000
     7.000
     2.000
     2.000
    -2.000
    -0.000
    -1.000
    -2.000
     3.000
    -7.000
     8.000
     4.000
     5.000
     8.000
     4.000
     7.000
     3.000
     2.000
     6.000
     1.000
     4.200
     0.300
    -3.000
     7.000
    -1.500
    -5.000
    -3.500
     2.000
     4.000
     1.000
    -1.200
    -1.700
     0.700
     4.000
     5.000
     3.000
     5.000
    -1.000
     1.000
     4.000
    -3.300
     1.000
    -1.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -2.000    13.840 Median =  -2.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -2.0  0.
 -2.0  13.6
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -19.000    15.160 Author: all ( 150 samples)
EOF
gmt end
