#!/bin/bash
gmt begin hubbard6.23_dcal pdf,ps
proj=-JM16.0c+
reg=-R-143.8/-135.3/58.0/62.6
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration hubbard6.23'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -139.729    59.553
  -139.487    60.100
>
  -140.257    60.097
  -139.615    60.112
>
  -139.397    59.669
  -139.443    60.123
>
  -139.729    59.553
  -139.443    60.123
>
  -139.397    59.669
  -139.464    60.115
>
  -139.729    59.553
  -139.464    60.115
>
  -139.635    59.953
  -139.228    60.124
>
  -139.729    59.553
  -139.277    60.077
>
  -139.729    59.553
  -139.294    60.081
>
  -140.257    60.097
  -139.382    60.108
>
  -140.257    60.097
  -139.382    60.108
>
  -139.397    59.669
  -139.382    60.108
>
  -139.397    59.669
  -139.382    60.108
>
  -139.635    59.953
  -139.646    60.215
>
  -139.635    59.953
  -139.646    60.215
>
  -140.257    60.097
  -139.646    60.215
>
  -140.257    60.097
  -139.646    60.215
>
  -139.397    59.669
  -139.646    60.215
>
  -139.635    59.953
  -139.122    59.905
>
  -139.397    59.669
  -139.122    59.905
>
  -139.729    59.553
  -139.122    59.905
>
  -139.635    59.953
  -139.574    60.143
>
  -139.635    59.953
  -139.574    60.143
>
  -139.397    59.669
  -139.574    60.143
>
  -139.729    59.553
  -139.574    60.143
>
  -139.635    59.953
  -139.051    59.965
>
  -139.635    59.953
  -139.051    59.965
>
  -139.397    59.669
  -139.051    59.965
>
  -139.729    59.553
  -139.051    59.965
>
  -139.635    59.953
  -139.659    60.230
>
  -140.257    60.097
  -139.659    60.230
>
  -140.257    60.097
  -139.659    60.230
>
  -139.635    59.953
  -139.587    60.228
>
  -139.635    59.953
  -139.587    60.228
>
  -140.257    60.097
  -139.587    60.228
>
  -140.257    60.097
  -139.587    60.228
>
  -139.397    59.669
  -139.587    60.228
>
  -139.635    59.953
  -139.565    60.224
>
  -139.635    59.953
  -139.565    60.224
>
  -140.257    60.097
  -139.565    60.224
>
  -139.397    59.669
  -139.565    60.224
>
  -139.397    59.669
  -139.565    60.224
>
  -139.635    59.953
  -139.411    60.151
>
  -140.257    60.097
  -139.411    60.151
>
  -139.635    59.953
  -139.397    60.136
>
  -140.257    60.097
  -139.397    60.136
>
  -139.635    59.953
  -139.295    59.967
>
  -139.397    59.669
  -139.295    59.967
>
  -139.729    59.553
  -139.295    59.967
>
  -139.635    59.953
  -139.350    60.151
>
  -139.397    59.669
  -139.350    60.151
>
  -139.635    59.953
  -139.834    60.088
>
  -139.729    59.553
  -139.834    60.088
>
  -140.257    60.097
  -139.727    60.234
>
  -140.257    60.097
  -139.727    60.234
>
  -139.635    59.953
  -139.727    60.234
>
  -139.397    59.669
  -139.727    60.234
>
  -139.397    59.669
  -139.367    60.120
>
  -139.397    59.669
  -139.367    60.120
>
  -140.257    60.097
  -139.390    60.107
>
  -139.397    59.669
  -139.390    60.107
>
  -139.397    59.669
  -139.390    60.107
>
  -139.397    59.669
  -139.373    60.124
>
  -139.397    59.669
  -139.373    60.124
>
  -139.397    59.669
  -139.352    60.148
>
  -139.397    59.669
  -139.378    60.132
>
  -139.397    59.669
  -139.378    60.132
>
  -140.257    60.097
  -139.497    60.126
>
  -140.257    60.097
  -139.497    60.126
>
  -139.397    59.669
  -139.497    60.126
>
  -140.257    60.097
  -139.808    60.077
>
  -140.257    60.097
  -139.808    60.077
>
  -140.257    60.097
  -139.808    60.077
>
  -139.397    59.669
  -139.808    60.077
>
  -139.397    59.669
  -139.808    60.077
>
  -140.781    60.130
  -139.808    60.077
>
  -140.781    60.130
  -139.808    60.077
>
  -140.257    60.097
  -139.531    60.180
>
  -140.257    60.097
  -139.531    60.180
>
  -139.397    59.669
  -139.531    60.180
>
  -140.257    60.097
  -139.621    60.189
>
  -140.257    60.097
  -139.621    60.189
>
  -140.257    60.097
  -139.621    60.189
>
  -140.257    60.097
  -139.621    60.189
>
  -139.397    59.669
  -139.621    60.189
>
  -139.397    59.669
  -139.621    60.189
>
  -140.781    60.130
  -139.621    60.189
>
  -139.635    59.953
  -139.569    60.189
>
  -139.635    59.953
  -139.569    60.189
>
  -140.257    60.097
  -139.569    60.189
>
  -140.257    60.097
  -139.569    60.189
>
  -140.257    60.097
  -139.569    60.189
>
  -139.397    59.669
  -139.569    60.189
>
  -139.397    59.669
  -139.183    60.204
>
  -139.397    59.669
  -139.183    60.204
>
  -140.257    60.097
  -139.183    60.204
>
  -140.257    60.097
  -139.183    60.204
>
  -140.257    60.097
  -139.183    60.204
>
  -139.635    59.953
  -139.616    60.209
>
  -139.635    59.953
  -139.616    60.209
>
  -140.257    60.097
  -139.616    60.209
>
  -140.257    60.097
  -139.616    60.209
>
  -140.257    60.097
  -139.616    60.209
>
  -140.781    60.130
  -139.616    60.209
>
  -140.781    60.130
  -139.616    60.209
>
  -139.397    59.669
  -139.616    60.209
>
  -139.397    59.669
  -139.428    60.072
>
  -140.257    60.097
  -139.428    60.072
>
  -139.635    59.953
  -139.618    60.186
>
  -139.635    59.953
  -139.618    60.186
>
  -140.257    60.097
  -139.618    60.186
>
  -140.257    60.097
  -139.618    60.186
>
  -140.257    60.097
  -139.618    60.186
>
  -140.781    60.130
  -139.618    60.186
>
  -140.781    60.130
  -139.618    60.186
>
  -140.781    60.130
  -139.618    60.186
>
  -139.397    59.669
  -139.618    60.186
>
  -139.397    59.669
  -139.618    60.186
>
  -139.635    59.953
  -139.433    60.098
>
  -139.635    59.953
  -139.433    60.098
>
  -140.257    60.097
  -139.433    60.098
>
  -140.257    60.097
  -139.433    60.098
>
  -140.257    60.097
  -139.433    60.098
>
  -140.257    60.097
  -139.433    60.098
>
  -139.397    59.669
  -139.433    60.098
>
  -139.397    59.669
  -139.471    60.008
>
  -139.397    59.669
  -139.471    60.008
>
  -140.257    60.097
  -139.471    60.008
>
  -139.397    59.669
  -139.383    60.065
>
  -139.397    59.669
  -139.383    60.065
>
  -140.257    60.097
  -139.383    60.065
>
  -139.635    59.953
  -139.413    60.060
>
  -139.635    59.953
  -139.413    60.060
>
  -139.397    59.669
  -139.413    60.060
>
  -139.397    59.669
  -139.413    60.060
>
  -140.257    60.097
  -139.413    60.060
>
  -140.257    60.097
  -139.413    60.060
>
  -140.257    60.097
  -139.413    60.060
>
  -140.257    60.097
  -139.413    60.060
>
  -140.257    60.097
  -139.433    60.182
>
  -140.257    60.097
  -139.433    60.182
>
  -139.397    59.669
  -139.433    60.182
>
  -139.635    59.953
  -139.513    60.154
>
  -139.635    59.953
  -139.513    60.154
>
  -140.257    60.097
  -139.513    60.154
>
  -140.257    60.097
  -139.513    60.154
>
  -140.257    60.097
  -139.513    60.154
>
  -140.257    60.097
  -139.513    60.154
>
  -140.257    60.097
  -139.513    60.154
>
  -138.576    60.302
  -139.513    60.154
>
  -138.576    60.302
  -139.513    60.154
>
  -138.576    60.302
  -139.513    60.154
>
  -138.576    60.302
  -139.513    60.154
>
  -139.397    59.669
  -139.513    60.154
>
  -139.397    59.669
  -139.513    60.154
>
  -139.397    59.669
  -139.513    60.154
>
  -138.576    60.302
  -139.201    60.210
>
  -138.576    60.302
  -139.201    60.210
>
  -140.257    60.097
  -139.201    60.210
>
  -140.257    60.097
  -139.201    60.210
>
  -140.257    60.097
  -139.201    60.210
>
  -140.257    60.097
  -139.201    60.210
>
  -139.397    59.669
  -139.201    60.210
>
  -139.397    59.669
  -139.201    60.210
>
  -139.397    59.669
  -139.201    60.210
>
  -140.257    60.097
  -139.528    60.177
>
  -140.257    60.097
  -139.528    60.177
>
  -140.257    60.097
  -139.528    60.177
>
  -140.257    60.097
  -139.528    60.177
>
  -138.576    60.302
  -139.528    60.177
>
  -138.576    60.302
  -139.528    60.177
>
  -139.397    59.669
  -139.528    60.177
>
  -139.397    59.669
  -139.528    60.177
>
  -139.397    59.669
  -139.528    60.177
>
  -139.635    59.953
  -139.516    60.179
>
  -139.635    59.953
  -139.516    60.179
>
  -140.257    60.097
  -139.516    60.179
>
  -140.257    60.097
  -139.516    60.179
>
  -140.257    60.097
  -139.516    60.179
>
  -140.257    60.097
  -139.516    60.179
>
  -140.257    60.097
  -139.516    60.179
>
  -138.576    60.302
  -139.516    60.179
>
  -138.576    60.302
  -139.516    60.179
>
  -138.576    60.302
  -139.516    60.179
>
  -139.397    59.669
  -139.516    60.179
>
  -139.397    59.669
  -139.516    60.179
>
  -139.397    59.669
  -139.516    60.179
>
  -139.397    59.669
  -139.516    60.179
>
  -140.257    60.097
  -139.562    60.228
>
  -140.257    60.097
  -139.562    60.228
>
  -140.257    60.097
  -139.562    60.228
>
  -140.257    60.097
  -139.562    60.228
>
  -138.576    60.302
  -139.562    60.228
>
  -138.576    60.302
  -139.562    60.228
>
  -139.397    59.669
  -139.562    60.228
>
  -139.397    59.669
  -139.562    60.228
>
  -139.397    59.669
  -139.562    60.228
>
  -139.635    59.953
  -139.575    60.234
>
  -139.635    59.953
  -139.575    60.234
>
  -140.257    60.097
  -139.575    60.234
>
  -140.257    60.097
  -139.575    60.234
>
  -138.576    60.302
  -139.575    60.234
>
  -138.576    60.302
  -139.575    60.234
>
  -139.397    59.669
  -139.575    60.234
>
  -139.397    59.669
  -139.575    60.234
>
  -139.397    59.669
  -139.419    60.098
>
  -139.397    59.669
  -139.419    60.098
>
  -139.397    59.669
  -139.419    60.098
>
  -140.257    60.097
  -139.419    60.098
>
  -140.257    60.097
  -139.419    60.098
>
  -140.257    60.097
  -139.419    60.098
>
  -140.257    60.097
  -139.419    60.098
>
  -138.576    60.302
  -139.419    60.098
>
  -138.576    60.302
  -139.419    60.098
>
  -139.635    59.953
  -139.487    60.152
>
  -139.635    59.953
  -139.487    60.152
>
  -140.257    60.097
  -139.487    60.152
>
  -140.257    60.097
  -139.487    60.152
>
  -140.257    60.097
  -139.487    60.152
>
  -140.257    60.097
  -139.487    60.152
>
  -140.257    60.097
  -139.487    60.152
>
  -138.576    60.302
  -139.487    60.152
>
  -138.576    60.302
  -139.487    60.152
>
  -138.576    60.302
  -139.487    60.152
>
  -138.576    60.302
  -139.487    60.152
>
  -139.397    59.669
  -139.487    60.152
>
  -139.397    59.669
  -139.487    60.152
>
  -139.397    59.669
  -139.487    60.152
>
  -139.397    59.669
  -139.487    60.152
>
  -139.635    59.953
  -139.446    60.109
>
  -139.635    59.953
  -139.446    60.109
>
  -139.397    59.669
  -139.446    60.109
>
  -139.397    59.669
  -139.446    60.109
>
  -140.257    60.097
  -139.446    60.109
>
  -140.257    60.097
  -139.446    60.109
>
  -140.257    60.097
  -139.446    60.109
>
  -140.257    60.097
  -139.446    60.109
>
  -138.576    60.302
  -139.446    60.109
>
  -138.576    60.302
  -139.446    60.109
>
  -139.635    59.953
  -139.493    60.161
>
  -139.635    59.953
  -139.493    60.161
>
  -140.257    60.097
  -139.493    60.161
>
  -140.257    60.097
  -139.493    60.161
>
  -140.257    60.097
  -139.493    60.161
>
  -140.257    60.097
  -139.493    60.161
>
  -140.257    60.097
  -139.493    60.161
>
  -139.397    59.669
  -139.493    60.161
>
  -139.397    59.669
  -139.493    60.161
>
  -139.397    59.669
  -139.493    60.161
>
  -138.576    60.302
  -139.493    60.161
>
  -138.576    60.302
  -139.493    60.161
>
  -138.576    60.302
  -139.493    60.161
>
  -140.191    60.772
  -139.562    60.426
>
  -140.191    60.772
  -139.562    60.426
>
  -140.257    60.097
  -139.562    60.426
>
  -140.257    60.097
  -139.562    60.426
>
  -140.257    60.097
  -139.562    60.426
>
  -140.257    60.097
  -139.562    60.426
>
  -139.635    59.953
  -139.562    60.426
>
  -138.576    60.302
  -139.562    60.426
>
  -138.576    60.302
  -139.562    60.426
>
  -138.576    60.302
  -139.562    60.426
>
  -140.257    60.097
  -139.549    60.215
>
  -140.257    60.097
  -139.549    60.215
>
  -140.257    60.097
  -139.549    60.215
>
  -140.257    60.097
  -139.549    60.215
>
  -138.576    60.302
  -139.549    60.215
>
  -138.576    60.302
  -139.549    60.215
>
  -138.576    60.302
  -139.549    60.215
>
  -139.397    59.669
  -139.549    60.215
>
  -139.397    59.669
  -139.549    60.215
>
  -139.397    59.669
  -139.549    60.215
>
  -140.257    60.097
  -139.780    60.186
>
  -140.257    60.097
  -139.780    60.186
>
  -140.257    60.097
  -139.780    60.186
>
  -140.257    60.097
  -139.780    60.186
>
  -140.781    60.130
  -139.780    60.186
>
  -140.781    60.130
  -139.780    60.186
>
  -139.397    59.669
  -139.780    60.186
>
  -139.397    59.669
  -139.780    60.186
>
  -139.397    59.669
  -139.780    60.186
>
  -139.397    59.669
  -139.393    60.092
>
  -139.397    59.669
  -139.393    60.092
>
  -140.257    60.097
  -139.393    60.092
>
  -140.257    60.097
  -139.393    60.092
>
  -140.257    60.097
  -139.393    60.092
>
  -140.257    60.097
  -139.393    60.092
>
  -138.576    60.302
  -139.393    60.092
>
  -138.576    60.302
  -139.393    60.092
>
  -139.635    59.953
  -139.151    59.913
>
  -139.635    59.953
  -139.151    59.913
>
  -139.397    59.669
  -139.151    59.913
>
  -139.397    59.669
  -139.151    59.913
>
  -139.671    59.512
  -139.151    59.913
>
  -138.576    60.302
  -139.151    59.913
>
  -138.576    60.302
  -139.151    59.913
>
  -140.257    60.097
  -139.151    59.913
>
  -140.257    60.097
  -139.151    59.913
>
  -140.257    60.097
  -139.151    59.913
>
  -140.257    60.097
  -139.151    59.913
>
  -140.191    60.772
  -139.768    60.295
>
  -140.191    60.772
  -139.768    60.295
>
  -140.191    60.772
  -139.768    60.295
>
  -140.781    60.130
  -139.768    60.295
>
  -138.576    60.302
  -139.768    60.295
>
  -138.576    60.302
  -139.768    60.295
>
  -138.576    60.302
  -139.768    60.295
>
  -139.635    59.953
  -139.633    60.297
>
  -139.635    59.953
  -139.633    60.297
>
  -140.257    60.097
  -139.633    60.297
>
  -140.257    60.097
  -139.633    60.297
>
  -140.257    60.097
  -139.633    60.297
>
  -140.257    60.097
  -139.633    60.297
>
  -140.191    60.772
  -139.633    60.297
>
  -140.191    60.772
  -139.633    60.297
>
  -140.191    60.772
  -139.633    60.297
>
  -138.576    60.302
  -139.633    60.297
>
  -138.576    60.302
  -139.633    60.297
>
  -138.576    60.302
  -139.633    60.297
>
  -140.781    60.130
  -139.633    60.297
>
  -139.635    59.953
  -139.368    59.975
>
  -139.635    59.953
  -139.368    59.975
>
  -139.397    59.669
  -139.368    59.975
>
  -139.397    59.669
  -139.368    59.975
>
  -140.257    60.097
  -139.368    59.975
>
  -140.257    60.097
  -139.368    59.975
>
  -139.671    59.512
  -139.368    59.975
>
  -138.576    60.302
  -139.368    59.975
>
  -138.576    60.302
  -139.368    59.975
>
  -138.576    60.302
  -139.368    59.975
>
  -140.257    60.097
  -139.476    60.093
>
  -140.257    60.097
  -139.476    60.093
>
  -139.397    59.669
  -139.476    60.093
>
  -139.397    59.669
  -139.476    60.093
>
  -138.576    60.302
  -139.476    60.093
>
  -138.576    60.302
  -139.476    60.093
>
  -139.397    59.669
  -139.354    59.969
>
  -139.397    59.669
  -139.354    59.969
>
  -139.397    59.669
  -139.354    59.969
>
  -140.257    60.097
  -139.354    59.969
>
  -140.257    60.097
  -139.354    59.969
>
  -140.257    60.097
  -139.354    59.969
>
  -140.257    60.097
  -139.354    59.969
>
  -138.576    60.302
  -139.354    59.969
>
  -138.576    60.302
  -139.354    59.969
>
  -138.576    60.302
  -139.354    59.969
>
  -139.397    59.669
  -139.360    59.976
>
  -139.397    59.669
  -139.360    59.976
>
  -140.257    60.097
  -139.360    59.976
>
  -140.257    60.097
  -139.360    59.976
>
  -138.576    60.302
  -139.360    59.976
>
  -138.576    60.302
  -139.360    59.976
>
  -139.635    59.953
  -139.363    59.973
>
  -139.397    59.669
  -139.363    59.973
>
  -139.397    59.669
  -139.363    59.973
>
  -139.397    59.669
  -139.363    59.973
>
  -139.397    59.669
  -139.363    59.973
>
  -140.257    60.097
  -139.363    59.973
>
  -140.257    60.097
  -139.363    59.973
>
  -140.257    60.097
  -139.363    59.973
>
  -140.257    60.097
  -139.363    59.973
>
  -138.576    60.302
  -139.363    59.973
>
  -138.576    60.302
  -139.363    59.973
>
  -138.576    60.302
  -139.363    59.973
>
  -138.576    60.302
  -139.363    59.973
>
  -140.257    60.097
  -139.782    60.278
>
  -139.635    59.953
  -139.782    60.278
>
  -139.635    59.953
  -139.782    60.278
>
  -140.191    60.772
  -139.782    60.278
>
  -140.191    60.772
  -139.782    60.278
>
  -140.191    60.772
  -139.782    60.278
>
  -140.191    60.772
  -139.782    60.278
>
  -140.781    60.130
  -139.782    60.278
>
  -140.781    60.130
  -139.782    60.278
>
  -140.257    60.097
  -139.452    60.095
>
  -140.257    60.097
  -139.452    60.095
>
  -140.257    60.097
  -139.452    60.095
>
  -140.257    60.097
  -139.452    60.095
>
  -139.397    59.669
  -139.452    60.095
>
  -139.397    59.669
  -139.452    60.095
>
  -139.397    59.669
  -139.452    60.095
>
  -138.576    60.302
  -139.452    60.095
>
  -138.576    60.302
  -139.452    60.095
>
  -140.257    60.097
  -139.556    59.985
>
  -138.576    60.302
  -139.556    59.985
>
  -138.576    60.302
  -139.556    59.985
>
  -139.635    59.953
  -139.112    59.970
>
  -139.635    59.953
  -139.112    59.970
>
  -139.397    59.669
  -139.112    59.970
>
  -139.397    59.669
  -139.112    59.970
>
  -139.397    59.669
  -139.112    59.970
>
  -138.576    60.302
  -139.112    59.970
>
  -138.576    60.302
  -139.112    59.970
>
  -138.576    60.302
  -139.112    59.970
>
  -138.576    60.302
  -139.112    59.970
>
  -139.671    59.512
  -139.112    59.970
>
  -140.257    60.097
  -139.112    59.970
>
  -140.257    60.097
  -139.112    59.970
>
  -140.257    60.097
  -139.112    59.970
>
  -140.257    60.097
  -139.112    59.970
>
  -140.257    60.097
  -139.112    59.970
>
  -140.257    60.097
  -139.112    59.970
>
  -139.635    59.953
  -139.644    60.230
>
  -139.635    59.953
  -139.644    60.230
>
  -140.257    60.097
  -139.644    60.230
>
  -140.257    60.097
  -139.644    60.230
>
  -140.257    60.097
  -139.644    60.230
>
  -138.576    60.302
  -139.644    60.230
>
  -138.576    60.302
  -139.644    60.230
>
  -140.781    60.130
  -139.644    60.230
>
  -139.397    59.669
  -139.644    60.230
>
  -139.397    59.669
  -139.644    60.230
>
  -139.397    59.669
  -139.229    59.996
>
  -139.397    59.669
  -139.229    59.996
>
  -138.576    60.302
  -139.229    59.996
>
  -138.576    60.302
  -139.229    59.996
>
  -138.576    60.302
  -139.229    59.996
>
  -138.576    60.302
  -139.229    59.996
>
  -140.257    60.097
  -139.229    59.996
>
  -140.257    60.097
  -139.229    59.996
>
  -140.257    60.097
  -139.229    59.996
>
  -140.257    60.097
  -139.229    59.996
>
  -140.257    60.097
  -139.549    60.369
>
  -140.257    60.097
  -139.549    60.369
>
  -140.257    60.097
  -139.549    60.369
>
  -140.257    60.097
  -139.549    60.369
>
  -140.191    60.772
  -139.549    60.369
>
  -140.191    60.772
  -139.549    60.369
>
  -140.191    60.772
  -139.549    60.369
>
  -140.191    60.772
  -139.549    60.369
>
  -138.576    60.302
  -139.549    60.369
>
  -138.576    60.302
  -139.549    60.369
>
  -138.576    60.302
  -139.549    60.369
>
  -138.576    60.302
  -139.549    60.369
>
  -139.635    59.953
  -139.176    60.008
>
  -138.576    60.302
  -139.176    60.008
>
  -138.576    60.302
  -139.176    60.008
>
  -138.576    60.302
  -139.176    60.008
>
  -140.257    60.097
  -139.176    60.008
>
  -140.257    60.097
  -139.176    60.008
>
  -140.257    60.097
  -139.176    60.008
>
  -140.257    60.097
  -139.176    60.008
>
  -140.257    60.097
  -139.176    60.008
>
  -139.671    59.512
  -139.176    60.008
>
  -140.257    60.097
  -139.844    60.254
>
  -140.257    60.097
  -139.844    60.254
>
  -140.257    60.097
  -139.844    60.254
>
  -139.635    59.953
  -139.844    60.254
>
  -139.635    59.953
  -139.844    60.254
>
  -140.191    60.772
  -139.844    60.254
>
  -140.191    60.772
  -139.844    60.254
>
  -140.191    60.772
  -139.844    60.254
>
  -140.257    60.097
  -139.568    60.201
>
  -140.257    60.097
  -139.568    60.201
>
  -140.257    60.097
  -139.568    60.201
>
  -140.257    60.097
  -139.568    60.201
>
  -138.576    60.302
  -139.568    60.201
>
  -138.576    60.302
  -139.568    60.201
>
  -138.576    60.302
  -139.568    60.201
>
  -140.257    60.097
  -139.557    60.201
>
  -140.257    60.097
  -139.557    60.201
>
  -140.257    60.097
  -139.557    60.201
>
  -140.257    60.097
  -139.557    60.201
>
  -138.576    60.302
  -139.557    60.201
>
  -138.576    60.302
  -139.557    60.201
>
  -139.397    59.669
  -139.224    59.974
>
  -139.397    59.669
  -139.224    59.974
>
  -138.576    60.302
  -139.224    59.974
>
  -140.257    60.097
  -139.224    59.974
>
  -140.257    60.097
  -139.224    59.974
>
  -140.257    60.097
  -139.224    59.974
>
  -140.257    60.097
  -139.224    59.974
>
  -138.576    60.302
  -138.990    60.441
>
  -138.576    60.302
  -138.990    60.441
>
  -138.140    60.531
  -138.990    60.441
>
  -139.635    59.953
  -138.990    60.441
>
  -139.635    59.953
  -138.990    60.441
>
  -138.363    60.943
  -138.990    60.441
>
  -138.363    60.943
  -138.990    60.441
>
  -140.257    60.097
  -139.497    60.148
>
  -140.257    60.097
  -139.497    60.148
>
  -139.397    59.669
  -139.497    60.148
>
  -138.576    60.302
  -139.497    60.148
>
  -138.576    60.302
  -139.497    60.148
>
  -139.397    59.669
  -139.261    60.036
>
  -139.397    59.669
  -139.261    60.036
>
  -138.576    60.302
  -139.261    60.036
>
  -138.576    60.302
  -139.261    60.036
>
  -140.257    60.097
  -139.261    60.036
>
  -140.257    60.097
  -139.261    60.036
>
  -140.257    60.097
  -139.831    60.450
>
  -140.257    60.097
  -139.831    60.450
>
  -140.253    60.096
  -139.831    60.450
>
  -140.253    60.096
  -139.831    60.450
>
  -140.781    60.130
  -139.831    60.450
>
  -140.781    60.130
  -139.831    60.450
>
  -140.781    60.130
  -139.847    60.165
>
  -140.781    60.130
  -139.847    60.165
>
  -139.397    59.669
  -139.847    60.165
>
  -139.397    59.669
  -139.847    60.165
>
  -140.253    60.096
  -139.422    60.101
>
  -140.257    60.097
  -139.422    60.101
>
  -139.397    59.669
  -139.422    60.101
>
  -140.253    60.096
  -139.410    60.098
>
  -140.253    60.096
  -139.410    60.098
>
  -140.257    60.097
  -139.410    60.098
>
  -139.397    59.669
  -139.410    60.098
>
  -140.781    60.130
  -139.813    60.289
>
  -140.781    60.130
  -139.813    60.289
>
  -140.781    60.130
  -139.813    60.289
>
  -139.397    59.669
  -139.253    59.947
>
  -139.397    59.669
  -139.253    59.947
>
  -139.671    59.512
  -139.253    59.947
>
  -139.397    59.669
  -139.644    60.214
>
  -139.397    59.669
  -139.644    60.214
>
  -139.397    59.669
  -139.623    60.208
>
  -139.397    59.669
  -139.623    60.208
>
  -139.397    59.669
  -139.480    59.964
>
  -139.397    59.669
  -139.480    59.964
>
  -139.397    59.669
  -139.480    59.964
>
  -139.397    59.669
  -139.864    60.114
>
  -139.397    59.669
  -139.864    60.114
>
  -139.637    59.953
  -139.663    60.199
>
  -139.397    59.669
  -139.663    60.199
>
  -140.781    60.130
  -139.663    60.199
>
  -140.253    60.096
  -139.450    60.115
>
  -140.253    60.096
  -139.450    60.115
>
  -140.257    60.097
  -139.450    60.115
>
  -140.257    60.097
  -139.450    60.115
>
  -139.397    59.669
  -139.450    60.115
>
  -139.397    59.669
  -139.274    60.070
>
  -139.397    59.669
  -139.274    60.070
>
  -139.397    59.669
  -139.274    60.070
>
  -139.397    59.669
  -139.274    60.070
>
  -140.253    60.096
  -139.274    60.070
>
  -140.253    60.096
  -139.274    60.070
>
  -140.257    60.097
  -139.274    60.070
>
  -140.257    60.097
  -139.274    60.070
>
  -139.397    59.669
  -139.256    60.069
>
  -139.397    59.669
  -139.256    60.069
>
  -139.397    59.669
  -139.256    60.069
>
  -139.397    59.669
  -139.256    60.069
>
  -140.253    60.096
  -139.256    60.069
>
  -140.253    60.096
  -139.256    60.069
>
  -140.257    60.097
  -139.256    60.069
>
  -140.257    60.097
  -139.256    60.069
>
  -140.253    60.096
  -139.467    60.401
>
  -140.253    60.096
  -139.467    60.401
>
  -140.253    60.096
  -139.381    60.311
>
  -140.253    60.096
  -139.457    60.405
>
  -140.253    60.096
  -139.434    60.386
>
  -140.253    60.096
  -139.764    60.550
>
  -140.253    60.096
  -139.359    60.384
>
  -140.253    60.096
  -139.853    60.523
>
  -140.253    60.096
  -139.853    60.523
>
  -140.253    60.096
  -139.816    60.522
>
  -140.253    60.096
  -139.816    60.522
>
  -140.253    60.096
  -139.841    60.522
>
  -140.253    60.096
  -139.841    60.522
>
  -140.253    60.096
  -140.027    60.597
>
  -141.003    60.825
  -140.027    60.597
>
  -141.003    60.825
  -140.027    60.597
>
  -140.253    60.096
  -139.841    60.518
>
  -140.253    60.096
  -139.841    60.518
>
  -140.253    60.096
  -139.551    60.462
>
  -140.253    60.096
  -139.551    60.462
>
  -140.253    60.096
  -139.564    60.471
>
  -140.253    60.096
  -139.564    60.471
>
  -140.253    60.096
  -139.720    60.558
>
  -140.253    60.096
  -139.720    60.558
>
  -140.253    60.096
  -139.458    60.402
>
  -140.253    60.096
  -139.458    60.402
>
  -140.253    60.096
  -139.944    60.559
>
  -140.253    60.096
  -139.944    60.559
>
  -141.003    60.825
  -139.944    60.559
>
  -141.003    60.825
  -139.944    60.559
>
  -140.253    60.096
  -139.885    60.541
>
  -140.253    60.096
  -139.885    60.541
>
  -140.253    60.096
  -139.465    60.421
>
  -140.253    60.096
  -139.465    60.421
>
  -140.253    60.096
  -139.952    60.551
>
  -140.253    60.096
  -139.952    60.551
>
  -141.003    60.825
  -139.952    60.551
>
  -141.003    60.825
  -139.952    60.551
>
  -140.253    60.096
  -139.860    60.623
>
  -140.253    60.096
  -139.860    60.623
>
  -141.003    60.825
  -139.860    60.623
>
  -141.003    60.825
  -139.860    60.623
>
  -141.003    60.825
  -139.939    60.598
>
  -140.253    60.096
  -139.939    60.598
>
  -140.253    60.096
  -139.939    60.598
>
  -140.253    60.096
  -139.814    60.536
>
  -140.253    60.096
  -139.814    60.536
>
  -140.253    60.096
  -139.442    60.405
>
  -140.253    60.096
  -139.442    60.405
>
  -140.253    60.096
  -139.867    60.544
>
  -140.253    60.096
  -139.867    60.544
>
  -140.253    60.096
  -139.861    60.568
>
  -140.253    60.096
  -139.861    60.568
>
  -140.253    60.096
  -139.898    60.550
>
  -140.253    60.096
  -139.670    60.583
>
  -140.253    60.096
  -139.670    60.583
>
  -140.253    60.096
  -139.452    60.405
>
  -140.253    60.096
  -139.452    60.405
>
  -140.253    60.096
  -139.835    60.561
>
  -140.253    60.096
  -139.784    60.594
>
  -140.253    60.096
  -139.595    60.482
>
  -140.253    60.096
  -139.595    60.482
>
  -140.253    60.096
  -139.583    60.477
>
  -140.253    60.096
  -139.583    60.477
>
  -140.253    60.096
  -139.867    60.514
>
  -140.253    60.096
  -139.867    60.514
>
  -140.253    60.096
  -139.913    60.498
>
  -140.253    60.096
  -139.913    60.498
>
  -140.253    60.096
  -139.519    60.377
>
  -140.253    60.096
  -139.493    60.412
>
  -140.253    60.096
  -139.493    60.412
>
  -140.253    60.096
  -139.948    60.549
>
  -140.253    60.096
  -139.948    60.549
>
  -141.003    60.825
  -139.948    60.549
>
  -141.003    60.825
  -139.948    60.549
>
  -140.253    60.096
  -139.815    60.557
>
  -140.253    60.096
  -139.815    60.557
>
  -140.253    60.096
  -139.541    60.440
>
  -140.253    60.096
  -139.541    60.440
>
  -140.253    60.096
  -139.376    60.388
>
  -140.253    60.096
  -139.376    60.388
>
  -140.253    60.096
  -139.856    60.626
>
  -141.003    60.825
  -139.856    60.626
>
  -140.253    60.096
  -139.865    60.617
>
  -140.253    60.096
  -139.865    60.617
>
  -141.003    60.825
  -139.865    60.617
>
  -141.003    60.825
  -139.865    60.617
>
  -140.253    60.096
  -139.838    60.586
>
  -140.253    60.096
  -139.838    60.586
>
  -140.253    60.096
  -139.867    60.539
>
  -140.253    60.096
  -139.867    60.539
>
  -140.253    60.096
  -139.845    60.540
>
  -140.253    60.096
  -139.845    60.540
>
  -140.253    60.096
  -139.634    60.582
>
  -140.253    60.096
  -139.634    60.582
>
  -140.253    60.096
  -139.885    60.483
>
  -140.253    60.096
  -139.885    60.483
>
  -140.253    60.096
  -139.472    60.410
>
  -140.253    60.096
  -139.472    60.410
>
  -140.253    60.096
  -139.954    60.519
>
  -140.253    60.096
  -139.845    60.543
>
  -140.253    60.096
  -139.845    60.543
>
  -140.253    60.096
  -139.960    60.536
>
  -141.003    60.825
  -139.960    60.536
>
  -140.253    60.096
  -140.008    60.519
>
  -140.253    60.096
  -140.008    60.519
>
  -141.003    60.825
  -140.008    60.519
>
  -141.003    60.825
  -140.008    60.519
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -139.729    59.553     0.300
  -140.257    60.097     0.300
  -139.397    59.669     0.300
  -139.635    59.953     0.300
  -140.781    60.130     0.300
  -140.257    60.097     0.300
  -138.576    60.302     0.300
  -140.191    60.772     0.300
  -139.671    59.512     0.300
  -138.140    60.531     0.300
  -138.363    60.943     0.300
  -140.253    60.096     0.300
  -139.637    59.953     0.300
  -141.003    60.825     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -139.487    60.100     0.200
>
  -139.615    60.112     0.200
>
  -139.443    60.123     0.200
>
  -139.464    60.115     0.200
>
  -139.228    60.124     0.200
>
  -139.277    60.077     0.200
>
  -139.294    60.081     0.200
>
  -139.382    60.108     0.200
>
  -139.646    60.215     0.200
>
  -139.122    59.905     0.200
>
  -139.574    60.143     0.200
>
  -139.051    59.965     0.200
>
  -139.659    60.230     0.200
>
  -139.587    60.228     0.200
>
  -139.565    60.224     0.200
>
  -139.411    60.151     0.200
>
  -139.397    60.136     0.200
>
  -139.295    59.967     0.200
>
  -139.350    60.151     0.200
>
  -139.834    60.088     0.200
>
  -139.598    60.207     0.200
>
  -139.727    60.234     0.200
>
  -139.367    60.120     0.200
>
  -139.390    60.107     0.200
>
  -139.373    60.124     0.200
>
  -139.352    60.148     0.200
>
  -139.378    60.132     0.200
>
  -139.477    60.347     0.200
>
  -139.382    60.126     0.200
>
  -139.497    60.126     0.200
>
  -139.808    60.077     0.200
>
  -139.531    60.180     0.200
>
  -139.621    60.189     0.200
>
  -139.569    60.189     0.200
>
  -139.183    60.204     0.200
>
  -139.616    60.209     0.200
>
  -139.428    60.072     0.200
>
  -139.618    60.186     0.200
>
  -139.433    60.098     0.200
>
  -139.471    60.008     0.200
>
  -139.383    60.065     0.200
>
  -139.413    60.060     0.200
>
  -139.433    60.182     0.200
>
  -139.513    60.154     0.200
>
  -139.201    60.210     0.200
>
  -139.528    60.177     0.200
>
  -139.516    60.179     0.200
>
  -139.562    60.228     0.200
>
  -139.575    60.234     0.200
>
  -139.419    60.098     0.200
>
  -139.487    60.152     0.200
>
  -139.446    60.109     0.200
>
  -139.493    60.161     0.200
>
  -139.562    60.426     0.200
>
  -139.549    60.215     0.200
>
  -139.780    60.186     0.200
>
  -139.393    60.092     0.200
>
  -139.151    59.913     0.200
>
  -139.768    60.295     0.200
>
  -139.633    60.297     0.200
>
  -139.368    59.975     0.200
>
  -139.476    60.093     0.200
>
  -139.354    59.969     0.200
>
  -139.360    59.976     0.200
>
  -139.363    59.973     0.200
>
  -139.782    60.278     0.200
>
  -139.452    60.095     0.200
>
  -139.556    59.985     0.200
>
  -139.112    59.970     0.200
>
  -139.644    60.230     0.200
>
  -139.229    59.996     0.200
>
  -139.549    60.369     0.200
>
  -139.176    60.008     0.200
>
  -139.844    60.254     0.200
>
  -139.568    60.201     0.200
>
  -139.557    60.201     0.200
>
  -139.224    59.974     0.200
>
  -138.990    60.441     0.200
>
  -139.497    60.148     0.200
>
  -139.261    60.036     0.200
>
  -139.831    60.450     0.200
>
  -139.847    60.165     0.200
>
  -139.422    60.101     0.200
>
  -139.410    60.098     0.200
>
  -139.813    60.289     0.200
>
  -139.253    59.947     0.200
>
  -139.080    60.454     0.200
>
  -139.816    60.318     0.200
>
  -139.644    60.214     0.200
>
  -139.623    60.208     0.200
>
  -139.480    59.964     0.200
>
  -139.864    60.114     0.200
>
  -139.663    60.199     0.200
>
  -139.450    60.115     0.200
>
  -139.274    60.070     0.200
>
  -139.256    60.069     0.200
>
  -139.467    60.401     0.200
>
  -139.381    60.311     0.200
>
  -139.457    60.405     0.200
>
  -139.434    60.386     0.200
>
  -139.764    60.550     0.200
>
  -139.359    60.384     0.200
>
  -139.853    60.523     0.200
>
  -139.816    60.522     0.200
>
  -139.841    60.522     0.200
>
  -140.027    60.597     0.200
>
  -139.841    60.518     0.200
>
  -139.551    60.462     0.200
>
  -139.564    60.471     0.200
>
  -139.720    60.558     0.200
>
  -139.458    60.402     0.200
>
  -139.944    60.559     0.200
>
  -139.885    60.541     0.200
>
  -139.465    60.421     0.200
>
  -139.952    60.551     0.200
>
  -139.860    60.623     0.200
>
  -139.939    60.598     0.200
>
  -139.814    60.536     0.200
>
  -139.442    60.405     0.200
>
  -139.867    60.544     0.200
>
  -139.861    60.568     0.200
>
  -139.898    60.550     0.200
>
  -139.670    60.583     0.200
>
  -139.452    60.405     0.200
>
  -139.835    60.561     0.200
>
  -139.784    60.594     0.200
>
  -139.595    60.482     0.200
>
  -139.583    60.477     0.200
>
  -139.867    60.514     0.200
>
  -139.913    60.498     0.200
>
  -139.519    60.377     0.200
>
  -139.493    60.412     0.200
>
  -139.948    60.549     0.200
>
  -139.815    60.557     0.200
>
  -139.541    60.440     0.200
>
  -139.376    60.388     0.200
>
  -139.856    60.626     0.200
>
  -139.865    60.617     0.200
>
  -139.838    60.586     0.200
>
  -139.867    60.539     0.200
>
  -139.845    60.540     0.200
>
  -139.821    60.514     0.200
>
  -139.634    60.582     0.200
>
  -139.795    60.658     0.200
>
  -139.885    60.483     0.200
>
  -139.472    60.410     0.200
>
  -139.954    60.519     0.200
>
  -139.845    60.543     0.200
>
  -139.960    60.536     0.200
>
  -140.008    60.519     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -139.566    60.274     0.000   222.000   222.000
  -139.566    60.274     0.000   444.000   444.000
EOF
gmt end
