#!/bin/bash
gmt begin hubbard6.23_base pdf,ps
proj=-JM16.0c+
reg=-R-140.1/-138.9/59.8/60.8
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map hubbard6.23'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -139.487    60.100 1
  -139.615    60.112 2
  -139.443    60.123 3
  -139.464    60.115 4
  -139.228    60.124 5
  -139.277    60.077 6
  -139.294    60.081 7
  -139.382    60.108 8
  -139.646    60.215 9
  -139.122    59.905 10
  -139.574    60.143 11
  -139.051    59.965 12
  -139.659    60.230 13
  -139.587    60.228 14
  -139.565    60.224 15
  -139.411    60.151 16
  -139.397    60.136 17
  -139.295    59.967 18
  -139.350    60.151 19
  -139.834    60.088 20
  -139.598    60.207 21
  -139.727    60.234 22
  -139.367    60.120 23
  -139.390    60.107 24
  -139.373    60.124 25
  -139.352    60.148 26
  -139.378    60.132 27
  -139.477    60.347 28
  -139.382    60.126 29
  -139.497    60.126 30
  -139.808    60.077 31
  -139.531    60.180 32
  -139.621    60.189 33
  -139.569    60.189 34
  -139.183    60.204 35
  -139.616    60.209 36
  -139.428    60.072 37
  -139.618    60.186 38
  -139.433    60.098 39
  -139.471    60.008 40
  -139.383    60.065 41
  -139.413    60.060 42
  -139.433    60.182 43
  -139.513    60.154 44
  -139.201    60.210 45
  -139.528    60.177 46
  -139.516    60.179 47
  -139.562    60.228 48
  -139.575    60.234 49
  -139.419    60.098 50
  -139.487    60.152 51
  -139.446    60.109 52
  -139.493    60.161 53
  -139.562    60.426 54
  -139.549    60.215 55
  -139.780    60.186 56
  -139.393    60.092 57
  -139.151    59.913 58
  -139.768    60.295 59
  -139.633    60.297 60
  -139.368    59.975 61
  -139.476    60.093 62
  -139.354    59.969 63
  -139.360    59.976 64
  -139.363    59.973 65
  -139.782    60.278 66
  -139.452    60.095 67
  -139.556    59.985 68
  -139.112    59.970 69
  -139.644    60.230 70
  -139.229    59.996 71
  -139.549    60.369 72
  -139.176    60.008 73
  -139.844    60.254 74
  -139.568    60.201 75
  -139.557    60.201 76
  -139.224    59.974 77
  -138.990    60.441 78
  -139.497    60.148 79
  -139.261    60.036 80
  -139.831    60.450 81
  -139.847    60.165 82
  -139.422    60.101 83
  -139.410    60.098 84
  -139.813    60.289 85
  -139.253    59.947 86
  -139.080    60.454 87
  -139.816    60.318 88
  -139.644    60.214 89
  -139.623    60.208 90
  -139.480    59.964 91
  -139.864    60.114 92
  -139.663    60.199 93
  -139.450    60.115 94
  -139.274    60.070 95
  -139.256    60.069 96
  -139.467    60.401 97
  -139.381    60.311 98
  -139.457    60.405 99
  -139.434    60.386 100
  -139.764    60.550 101
  -139.359    60.384 102
  -139.853    60.523 103
  -139.816    60.522 104
  -139.841    60.522 105
  -140.027    60.597 106
  -139.841    60.518 107
  -139.551    60.462 108
  -139.564    60.471 109
  -139.720    60.558 110
  -139.458    60.402 111
  -139.944    60.559 112
  -139.885    60.541 113
  -139.465    60.421 114
  -139.952    60.551 115
  -139.860    60.623 116
  -139.939    60.598 117
  -139.814    60.536 118
  -139.442    60.405 119
  -139.867    60.544 120
  -139.861    60.568 121
  -139.898    60.550 122
  -139.670    60.583 123
  -139.452    60.405 124
  -139.835    60.561 125
  -139.784    60.594 126
  -139.595    60.482 127
  -139.583    60.477 128
  -139.867    60.514 129
  -139.913    60.498 130
  -139.519    60.377 131
  -139.493    60.412 132
  -139.948    60.549 133
  -139.815    60.557 134
  -139.541    60.440 135
  -139.376    60.388 136
  -139.856    60.626 137
  -139.865    60.617 138
  -139.838    60.586 139
  -139.867    60.539 140
  -139.845    60.540 141
  -139.821    60.514 142
  -139.634    60.582 143
  -139.795    60.658 144
  -139.885    60.483 145
  -139.472    60.410 146
  -139.954    60.519 147
  -139.845    60.543 148
  -139.960    60.536 149
  -140.008    60.519 150
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -139.480    60.051
  -139.487    60.100
>
  -139.579    60.134
  -139.615    60.112
>
  -139.531    60.178
  -139.443    60.123
>
  -139.506    60.163
  -139.464    60.115
>
  -139.213    60.093
  -139.228    60.124
>
  -139.311    60.190
  -139.277    60.077
>
  -139.477    60.072
  -139.294    60.081
>
  -139.404    60.118
  -139.382    60.108
>
  -139.588    60.172
  -139.646    60.215
>
  -139.247    59.984
  -139.122    59.905
>
  -139.579    60.162
  -139.574    60.143
>
  -139.208    59.965
  -139.051    59.965
>
  -139.654    60.195
  -139.659    60.230
>
  -139.622    60.242
  -139.587    60.228
>
  -139.515    60.274
  -139.565    60.224
>
  -139.512    60.259
  -139.411    60.151
>
  -139.517    60.159
  -139.397    60.136
>
  -139.264    59.932
  -139.295    59.967
>
  -139.441    60.245
  -139.350    60.151
>
  -139.511    60.135
  -139.834    60.088
>
  -139.539    60.261
  -139.598    60.207
>
  -139.777    60.266
  -139.727    60.234
>
  -139.394    60.184
  -139.367    60.120
>
  -139.493    60.165
  -139.390    60.107
>
  -139.377    60.122
  -139.373    60.124
>
  -139.344    60.145
  -139.352    60.148
>
  -139.393    60.091
  -139.378    60.132
>
  -139.406    60.320
  -139.477    60.347
>
  -139.281    60.062
  -139.382    60.126
>
  -139.202    60.210
  -139.497    60.126
>
  -139.820    60.072
  -139.808    60.077
>
  -139.527    60.173
  -139.531    60.180
>
  -139.651    60.159
  -139.621    60.189
>
  -139.578    60.181
  -139.569    60.189
>
  -139.206    60.188
  -139.183    60.204
>
  -139.662    60.220
  -139.616    60.209
>
  -139.436    60.060
  -139.428    60.072
>
  -139.643    60.240
  -139.618    60.186
>
  -139.454    60.122
  -139.433    60.098
>
  -139.507    59.988
  -139.471    60.008
>
  -139.428    60.054
  -139.383    60.065
>
  -139.414    60.076
  -139.413    60.060
>
  -139.468    60.153
  -139.433    60.182
>
  -139.557    60.172
  -139.513    60.154
>
  -139.215    60.193
  -139.201    60.210
>
  -139.542    60.176
  -139.528    60.177
>
  -139.539    60.171
  -139.516    60.179
>
  -139.600    60.224
  -139.562    60.228
>
  -139.628    60.243
  -139.575    60.234
>
  -139.438    60.075
  -139.419    60.098
>
  -139.513    60.185
  -139.487    60.152
>
  -139.402    60.088
  -139.446    60.109
>
  -139.507    60.145
  -139.493    60.161
>
  -139.609    60.454
  -139.562    60.426
>
  -139.570    60.214
  -139.549    60.215
>
  -139.788    60.171
  -139.780    60.186
>
  -139.413    60.067
  -139.393    60.092
>
  -139.156    59.909
  -139.151    59.913
>
  -139.844    60.308
  -139.768    60.295
>
  -139.654    60.321
  -139.633    60.297
>
  -139.419    59.974
  -139.368    59.975
>
  -139.464    60.117
  -139.476    60.093
>
  -139.369    59.950
  -139.354    59.969
>
  -139.359    59.991
  -139.360    59.976
>
  -139.355    59.999
  -139.363    59.973
>
  -139.795    60.292
  -139.782    60.278
>
  -139.492    60.079
  -139.452    60.095
>
  -139.649    59.937
  -139.556    59.985
>
  -139.102    59.990
  -139.112    59.970
>
  -139.680    60.257
  -139.644    60.230
>
  -139.168    59.954
  -139.229    59.996
>
  -139.626    60.368
  -139.549    60.369
>
  -139.223    60.014
  -139.176    60.008
>
  -139.908    60.218
  -139.844    60.254
>
  -139.649    60.268
  -139.568    60.201
>
  -139.556    60.215
  -139.557    60.201
>
  -139.249    59.997
  -139.224    59.974
>
  -139.043    60.424
  -138.990    60.441
>
  -139.539    60.145
  -139.497    60.148
>
  -139.297    60.018
  -139.261    60.036
>
  -139.930    60.410
  -139.831    60.450
>
  -139.816    60.156
  -139.847    60.165
>
  -139.485    60.108
  -139.422    60.101
>
  -139.471    60.073
  -139.410    60.098
>
  -139.848    60.308
  -139.813    60.289
>
  -139.267    59.990
  -139.253    59.947
>
  -139.152    60.443
  -139.080    60.454
>
  -139.893    60.289
  -139.816    60.318
>
  -139.715    60.179
  -139.644    60.214
>
  -139.702    60.198
  -139.623    60.208
>
  -139.534    59.990
  -139.480    59.964
>
  -139.951    60.108
  -139.864    60.114
>
  -139.830    60.058
  -139.663    60.199
>
  -139.518    60.126
  -139.450    60.115
>
  -139.298    60.113
  -139.274    60.070
>
  -139.293    60.087
  -139.256    60.069
>
  -139.546    60.359
  -139.467    60.401
>
  -139.443    60.245
  -139.381    60.311
>
  -139.567    60.315
  -139.457    60.405
>
  -139.492    60.289
  -139.434    60.386
>
  -139.840    60.481
  -139.764    60.550
>
  -139.365    60.376
  -139.359    60.384
>
  -139.922    60.518
  -139.853    60.523
>
  -139.949    60.478
  -139.816    60.522
>
  -140.086    60.476
  -139.841    60.522
>
  -140.230    60.555
  -140.027    60.597
>
  -139.932    60.507
  -139.841    60.518
>
  -139.684    60.444
  -139.551    60.462
>
  -139.634    60.475
  -139.564    60.471
>
  -139.899    60.566
  -139.720    60.558
>
  -139.649    60.415
  -139.458    60.402
>
  -140.095    60.563
  -139.944    60.559
>
  -139.990    60.554
  -139.885    60.541
>
  -139.530    60.453
  -139.465    60.421
>
  -140.051    60.539
  -139.952    60.551
>
  -139.941    60.627
  -139.860    60.623
>
  -140.131    60.592
  -139.939    60.598
>
  -139.951    60.478
  -139.814    60.536
>
  -139.487    60.420
  -139.442    60.405
>
  -140.077    60.499
  -139.867    60.544
>
  -140.042    60.536
  -139.861    60.568
>
  -140.000    60.529
  -139.898    60.550
>
  -139.873    60.493
  -139.670    60.583
>
  -139.475    60.507
  -139.452    60.405
>
  -139.935    60.580
  -139.835    60.561
>
  -139.997    60.548
  -139.784    60.594
>
  -139.614    60.445
  -139.595    60.482
>
  -139.651    60.479
  -139.583    60.477
>
  -139.865    60.509
  -139.867    60.514
>
  -140.075    60.450
  -139.913    60.498
>
  -139.594    60.340
  -139.519    60.377
>
  -139.499    60.372
  -139.493    60.412
>
  -140.021    60.542
  -139.948    60.549
>
  -139.830    60.519
  -139.815    60.557
>
  -139.605    60.429
  -139.541    60.440
>
  -139.385    60.395
  -139.376    60.388
>
  -139.956    60.533
  -139.856    60.626
>
  -139.995    60.614
  -139.865    60.617
>
  -139.967    60.582
  -139.838    60.586
>
  -139.983    60.524
  -139.867    60.539
>
  -139.895    60.495
  -139.845    60.540
>
  -140.003    60.504
  -139.821    60.514
>
  -139.746    60.549
  -139.634    60.582
>
  -139.986    60.636
  -139.795    60.658
>
  -139.809    60.494
  -139.885    60.483
>
  -139.613    60.421
  -139.472    60.410
>
  -140.124    60.476
  -139.954    60.519
>
  -140.021    60.544
  -139.845    60.543
>
  -140.073    60.470
  -139.960    60.536
>
  -140.293    60.479
  -140.008    60.519
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -139.486    60.100
  -139.487    60.100
>
  -139.617    60.113
  -139.615    60.112
>
  -139.442    60.123
  -139.443    60.123
>
  -139.462    60.116
  -139.464    60.115
>
  -139.230    60.125
  -139.228    60.124
>
  -139.279    60.077
  -139.277    60.077
>
  -139.295    60.080
  -139.294    60.081
>
  -139.382    60.108
  -139.382    60.108
>
  -139.647    60.215
  -139.646    60.215
>
  -139.122    59.905
  -139.122    59.905
>
  -139.571    60.142
  -139.574    60.143
>
  -139.052    59.965
  -139.051    59.965
>
  -139.660    60.229
  -139.659    60.230
>
  -139.586    60.228
  -139.587    60.228
>
  -139.564    60.223
  -139.565    60.224
>
  -139.410    60.150
  -139.411    60.151
>
  -139.397    60.136
  -139.397    60.136
>
  -139.295    59.967
  -139.295    59.967
>
  -139.353    60.151
  -139.350    60.151
>
  -139.835    60.088
  -139.834    60.088
>
  -139.599    60.207
  -139.598    60.207
>
  -139.727    60.234
  -139.727    60.234
>
  -139.367    60.120
  -139.367    60.120
>
  -139.390    60.107
  -139.390    60.107
>
  -139.373    60.124
  -139.373    60.124
>
  -139.352    60.149
  -139.352    60.148
>
  -139.378    60.132
  -139.378    60.132
>
  -139.480    60.347
  -139.477    60.347
>
  -139.382    60.126
  -139.382    60.126
>
  -139.497    60.126
  -139.497    60.126
>
  -139.808    60.077
  -139.808    60.077
>
  -139.530    60.180
  -139.531    60.180
>
  -139.621    60.189
  -139.621    60.189
>
  -139.568    60.189
  -139.569    60.189
>
  -139.183    60.203
  -139.183    60.204
>
  -139.615    60.209
  -139.616    60.209
>
  -139.430    60.073
  -139.428    60.072
>
  -139.618    60.186
  -139.618    60.186
>
  -139.434    60.098
  -139.433    60.098
>
  -139.471    60.008
  -139.471    60.008
>
  -139.383    60.065
  -139.383    60.065
>
  -139.413    60.060
  -139.413    60.060
>
  -139.433    60.182
  -139.433    60.182
>
  -139.512    60.155
  -139.513    60.154
>
  -139.201    60.211
  -139.201    60.210
>
  -139.528    60.176
  -139.528    60.177
>
  -139.516    60.179
  -139.516    60.179
>
  -139.562    60.229
  -139.562    60.228
>
  -139.575    60.235
  -139.575    60.234
>
  -139.419    60.098
  -139.419    60.098
>
  -139.487    60.152
  -139.487    60.152
>
  -139.446    60.109
  -139.446    60.109
>
  -139.493    60.161
  -139.493    60.161
>
  -139.562    60.426
  -139.562    60.426
>
  -139.548    60.215
  -139.549    60.215
>
  -139.780    60.185
  -139.780    60.186
>
  -139.393    60.092
  -139.393    60.092
>
  -139.151    59.913
  -139.151    59.913
>
  -139.768    60.295
  -139.768    60.295
>
  -139.633    60.297
  -139.633    60.297
>
  -139.368    59.975
  -139.368    59.975
>
  -139.476    60.093
  -139.476    60.093
>
  -139.354    59.969
  -139.354    59.969
>
  -139.359    59.976
  -139.360    59.976
>
  -139.363    59.973
  -139.363    59.973
>
  -139.783    60.277
  -139.782    60.278
>
  -139.452    60.094
  -139.452    60.095
>
  -139.557    59.986
  -139.556    59.985
>
  -139.112    59.970
  -139.112    59.970
>
  -139.644    60.229
  -139.644    60.230
>
  -139.229    59.997
  -139.229    59.996
>
  -139.549    60.370
  -139.549    60.369
>
  -139.176    60.007
  -139.176    60.008
>
  -139.844    60.253
  -139.844    60.254
>
  -139.567    60.202
  -139.568    60.201
>
  -139.557    60.201
  -139.557    60.201
>
  -139.223    59.974
  -139.224    59.974
>
  -138.990    60.441
  -138.990    60.441
>
  -139.498    60.148
  -139.497    60.148
>
  -139.261    60.036
  -139.261    60.036
>
  -139.831    60.450
  -139.831    60.450
>
  -139.844    60.166
  -139.847    60.165
>
  -139.423    60.100
  -139.422    60.101
>
  -139.410    60.098
  -139.410    60.098
>
  -139.812    60.289
  -139.813    60.289
>
  -139.253    59.947
  -139.253    59.947
>
  -139.079    60.454
  -139.080    60.454
>
  -139.815    60.318
  -139.816    60.318
>
  -139.644    60.214
  -139.644    60.214
>
  -139.625    60.208
  -139.623    60.208
>
  -139.479    59.964
  -139.480    59.964
>
  -139.864    60.113
  -139.864    60.114
>
  -139.664    60.200
  -139.663    60.199
>
  -139.462    60.108
  -139.450    60.115
>
  -139.273    60.070
  -139.274    60.070
>
  -139.256    60.069
  -139.256    60.069
>
  -139.467    60.401
  -139.467    60.401
>
  -139.381    60.311
  -139.381    60.311
>
  -139.457    60.405
  -139.457    60.405
>
  -139.438    60.387
  -139.434    60.386
>
  -139.763    60.549
  -139.764    60.550
>
  -139.360    60.384
  -139.359    60.384
>
  -139.851    60.523
  -139.853    60.523
>
  -139.815    60.522
  -139.816    60.522
>
  -139.841    60.522
  -139.841    60.522
>
  -140.034    60.596
  -140.027    60.597
>
  -139.838    60.517
  -139.841    60.518
>
  -139.550    60.463
  -139.551    60.462
>
  -139.564    60.471
  -139.564    60.471
>
  -139.719    60.558
  -139.720    60.558
>
  -139.458    60.402
  -139.458    60.402
>
  -139.946    60.559
  -139.944    60.559
>
  -139.886    60.541
  -139.885    60.541
>
  -139.464    60.421
  -139.465    60.421
>
  -139.954    60.550
  -139.952    60.551
>
  -139.859    60.623
  -139.860    60.623
>
  -139.939    60.597
  -139.939    60.598
>
  -139.813    60.536
  -139.814    60.536
>
  -139.439    60.405
  -139.442    60.405
>
  -139.866    60.544
  -139.867    60.544
>
  -139.860    60.568
  -139.861    60.568
>
  -139.897    60.549
  -139.898    60.550
>
  -139.670    60.582
  -139.670    60.583
>
  -139.451    60.404
  -139.452    60.405
>
  -139.834    60.562
  -139.835    60.561
>
  -139.782    60.594
  -139.784    60.594
>
  -139.596    60.482
  -139.595    60.482
>
  -139.583    60.477
  -139.583    60.477
>
  -139.866    60.514
  -139.867    60.514
>
  -139.913    60.498
  -139.913    60.498
>
  -139.517    60.377
  -139.519    60.377
>
  -139.496    60.412
  -139.493    60.412
>
  -139.947    60.549
  -139.948    60.549
>
  -139.816    60.557
  -139.815    60.557
>
  -139.540    60.440
  -139.541    60.440
>
  -139.376    60.388
  -139.376    60.388
>
  -139.854    60.625
  -139.856    60.626
>
  -139.864    60.617
  -139.865    60.617
>
  -139.839    60.586
  -139.838    60.586
>
  -139.870    60.539
  -139.867    60.539
>
  -139.844    60.540
  -139.845    60.540
>
  -139.820    60.514
  -139.821    60.514
>
  -139.633    60.582
  -139.634    60.582
>
  -139.795    60.658
  -139.795    60.658
>
  -139.885    60.482
  -139.885    60.483
>
  -139.471    60.410
  -139.472    60.410
>
  -139.954    60.519
  -139.954    60.519
>
  -139.845    60.543
  -139.845    60.543
>
  -139.961    60.537
  -139.960    60.536
>
  -140.009    60.519
  -140.008    60.519
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -139.487    60.100    22.679     2.218     3.866
  -139.615    60.112    17.932     0.492     1.938
  -139.443    60.123    -7.354     1.436     2.153
  -139.464    60.115    -8.086     1.400     2.127
  -139.228    60.124    33.385     2.358     3.557
  -139.277    60.077   -72.477     1.610     2.405
  -139.294    60.081   -69.032     1.708     2.760
  -139.382    60.108   -62.179     1.201     1.894
  -139.646    60.215   -40.399     1.411     1.907
  -139.122    59.905     6.478     3.287     4.286
  -139.574    60.143   -17.131     1.693     2.384
  -139.051    59.965   -24.216     3.376     4.235
  -139.659    60.230   -83.839     1.893     2.571
  -139.587    60.228   -25.218     1.720     2.471
  -139.565    60.224   -29.924     1.713     3.047
  -139.411    60.151    20.342     2.170     2.399
  -139.397    60.136   -29.074     1.789     3.223
  -139.295    59.967    25.426     2.769     3.277
  -139.350    60.151     1.624     1.710     2.314
  -139.834    60.088   -55.348     1.723     2.505
  -139.598    60.207    -0.975     2.721     3.259
  -139.727    60.234   -27.390     1.278     1.544
  -139.367    60.120   -64.758     0.921     1.300
  -139.390    60.107   -57.657     0.977     1.397
  -139.373    60.124   -16.322     1.588     1.880
  -139.352    60.148   -35.320     1.444     1.625
  -139.378    60.132    -4.697     1.610     2.042
  -139.477    60.347   -44.359     2.005     3.432
  -139.382    60.126   -61.969     2.014     3.511
  -139.497    60.126   -53.649     1.340     2.886
  -139.808    60.077    84.908     0.928     1.364
  -139.531    60.180    37.621     1.490     1.860
  -139.621    60.189    64.347     1.038     1.273
  -139.569    60.189    30.534     0.821     1.199
  -139.183    60.204    51.858     1.142     1.614
  -139.616    60.209    36.148     1.327     1.380
  -139.428    60.072    36.196     1.535     1.759
  -139.618    60.186    41.505     0.907     1.053
  -139.433    60.098    42.392     0.718     1.058
  -139.471    60.008    13.778     1.895     2.352
  -139.383    60.065    27.261     1.182     1.529
  -139.413    60.060    45.691     1.040     1.544
  -139.433    60.182    57.272     1.308     1.607
  -139.513    60.154    68.800     0.582     0.711
  -139.201    60.210    87.569     0.927     0.992
  -139.528    60.177   -22.698     0.722     0.806
  -139.516    60.179     9.806     0.625     0.642
  -139.562    60.228   -29.662     0.743     0.799
  -139.575    60.234    -2.855     0.744     0.911
  -139.419    60.098   -75.021     1.195     1.384
  -139.487    60.152   -34.017     0.657     0.687
  -139.446    60.109    82.436     0.772     0.912
  -139.493    60.161   -48.494     0.653     0.696
  -139.562    60.426   -84.662     0.823     0.885
  -139.549    60.215    79.500     0.817     0.900
  -139.780    60.186    61.751     1.025     1.144
  -139.393    60.092   -82.111     0.943     0.999
  -139.151    59.913    86.763     0.854     1.234
  -139.768    60.295   -15.374     1.189     1.519
  -139.633    60.297    35.729     0.722     0.743
  -139.368    59.975   -78.330     0.793     1.019
  -139.476    60.093   -47.954     1.139     1.187
  -139.354    59.969   -83.882     1.026     1.219
  -139.360    59.976     0.812     1.387     1.516
  -139.363    59.973   -76.782     0.630     0.778
  -139.782    60.278   -16.269     1.237     1.304
  -139.452    60.095   -44.201     0.796     0.802
  -139.556    59.985   -78.076     2.029     3.241
  -139.112    59.970    75.034     0.753     0.972
  -139.644    60.230    25.509     0.825     0.921
  -139.229    59.996    83.194     1.304     1.488
  -139.549    60.369    81.885     1.120     1.349
  -139.176    60.008    85.423     0.701     1.148
  -139.844    60.254    65.288     1.011     1.038
  -139.568    60.201    77.402     0.714     1.158
  -139.557    60.201    86.458     0.938     1.203
  -139.224    59.974    73.765     1.577     2.148
  -138.990    60.441    41.282     1.172     1.460
  -139.497    60.148    52.418     1.327     1.567
  -139.261    60.036    64.064     1.371     1.662
  -139.831    60.450    53.139     1.469     1.764
  -139.847    60.165   -57.244     2.808     5.350
  -139.422    60.101    74.504     1.460     1.519
  -139.410    60.098   -50.480     1.487     1.619
  -139.813    60.289    70.046     1.081     1.318
  -139.253    59.947    45.812     1.514     1.973
  -139.080    60.454    -9.921     1.703     2.332
  -139.816    60.318    80.535     0.995     1.299
  -139.644    60.214    -8.337     1.230     1.623
  -139.623    60.208    -0.718     2.107     2.738
  -139.480    59.964    30.683     1.494     1.604
  -139.864    60.114    89.541     1.415     1.788
  -139.663    60.199   -16.070     2.907     3.079
  -139.450    60.115     6.324     1.666     1.769
  -139.274    60.070    23.118     1.061     1.417
  -139.256    60.069    24.375     1.045     1.357
  -139.467    60.401   -42.985     2.207     2.716
  -139.381    60.311   -39.779     1.852     2.888
  -139.457    60.405   -42.848     1.905     2.899
  -139.434    60.386   -80.744     3.523     6.135
  -139.764    60.550   -52.243     1.756     2.403
  -139.359    60.384   -59.714     1.667     2.153
  -139.853    60.523   -40.376     1.375     3.022
  -139.816    60.522   -27.344     2.163     2.232
  -139.841    60.522   -51.035     2.504     3.343
  -140.027    60.597    89.835     2.103     3.377
  -139.841    60.518   -33.229     2.345     2.953
  -139.551    60.462   -63.426     2.235     2.918
  -139.564    60.471   -49.910     1.122     1.503
  -139.720    60.558   -63.320     1.466     1.814
  -139.458    60.402   -74.182     1.384     2.059
  -139.944    60.559   -46.828     1.984     2.580
  -139.885    60.541   -40.651     1.649     1.910
  -139.465    60.421   -63.300     1.569     2.246
  -139.952    60.551   -80.743     1.416     1.756
  -139.860    60.623   -42.540     2.164     3.697
  -139.939    60.598   -53.871     2.858     4.318
  -139.814    60.536   -66.879     1.563     2.223
  -139.442    60.405   -50.947     1.280     1.590
  -139.867    60.544   -59.171     2.307     2.670
  -139.861    60.568   -63.819     2.003     2.333
  -139.898    60.550   -76.311     1.734     3.218
  -139.670    60.583   -61.862     1.064     1.663
  -139.452    60.405   -82.236     1.063     1.942
  -139.835    60.561   -52.471     1.247     2.192
  -139.784    60.594    88.621     2.355     4.103
  -139.595    60.482   -18.199     2.252     2.635
  -139.583    60.477   -57.981     2.037     2.167
  -139.867    60.514   -44.661     1.319     1.599
  -139.913    60.498   -85.230     1.622     2.513
  -139.519    60.377   -59.042     1.047     1.354
  -139.493    60.412   -48.381     1.631     2.275
  -139.948    60.549   -51.213     1.982     2.411
  -139.815    60.557   -54.220     1.457     1.883
  -139.541    60.440   -47.821     1.440     1.755
  -139.376    60.388   -72.274     1.319     1.809
  -139.856    60.626   -77.326     1.806     2.582
  -139.865    60.617   -46.954     1.496     2.276
  -139.838    60.586   -69.817     1.425     2.172
  -139.867    60.539   -50.728     2.154     2.816
  -139.845    60.540   -39.594     1.703     2.573
  -139.821    60.514   -70.812     2.380     4.949
  -139.634    60.582   -37.596     1.315     1.973
  -139.795    60.658   -10.757     2.924     3.818
  -139.885    60.483    65.454     3.167     3.744
  -139.472    60.410   -41.329     1.342     1.643
  -139.954    60.519   -66.861     1.056     1.416
  -139.845    60.543   -38.882     1.920     4.659
  -139.960    60.536   -32.264     3.154     4.070
  -140.008    60.519   -72.088     1.814     2.233
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -139.467    60.401     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -140.027    59.858    64.907     2.210     2.379
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -140.004    59.858   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -140.027    59.858     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -140.027    59.858     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -140.027    59.814   5 km
EOF
gmt end
