#!/bin/bash
gmt begin hubbard5.7_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases hubbard5.7'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.500     1.381
     2.000    -2.148
     2.500    -5.676
     3.000    -9.205
     3.500   -12.735
     4.000   -16.270
     4.500   -19.806
     5.000   -23.345
     5.500   -26.889
     6.000   -30.436
     6.500   -33.989
     7.000   -37.546
     7.500   -41.109
     8.000   -44.678
     8.500   -48.254
     9.000   -51.836
     9.500   -55.427
    10.000   -59.025
    10.500   -62.632
    11.000   -66.248
    11.500   -69.870
    12.000   -73.500
    12.500   -77.138
    13.000   -80.786
    13.500   -84.443
    14.000   -88.110
    14.500   -91.787
    15.000   -95.476
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -77.786 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.927
     1.000     1.171
     1.500    -0.824
     2.000    -2.819
     2.500    -4.815
     3.000    -6.812
     3.500    -8.810
     4.000   -10.810
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -13.810 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    12.246    -7.117     0.200
     5.192    -0.892     0.200
     5.809    -0.956     0.200
     7.150     3.034     0.200
     8.638    -5.133     0.200
     8.600    -2.318     0.200
     3.926    -1.710     0.200
     4.997    -3.662     0.200
     3.997    -4.552     0.200
     4.708    -4.877     0.200
     5.677    -2.985     0.200
     8.650    -7.998     0.200
     3.721    -1.740     0.200
     3.972    -4.034     0.200
     4.729    -3.635     0.200
     5.699    -4.589     0.200
     3.962    -2.679     0.200
     4.736    -2.717     0.200
     5.707    -2.594     0.200
     6.055    11.345     0.200
     4.842    -2.729     0.200
     5.274    -1.456     0.200
     5.224    -1.008     0.200
     5.218    -1.475     0.200
     8.547    -0.637     0.200
     3.175    -3.094     0.200
     5.106    -3.544     0.200
     5.802    -0.269     0.200
     6.153     1.102     0.200
     4.088     2.248     0.200
     5.012    -2.774     0.200
     3.908     0.700     0.200
     5.092    -3.209     0.200
     5.783     0.262     0.200
     8.550    -0.111     0.200
    10.004    -4.622     0.200
    12.086    -1.817     0.200
     2.530    -1.343     0.200
     3.994     0.049     0.200
     5.303    -3.877     0.200
     8.691    -1.671     0.200
     3.898    -5.567     0.200
     5.224    -1.823     0.200
     5.224    -3.053     0.200
     5.698    -4.697     0.200
     8.573    -4.224     0.200
    12.206    -5.247     0.200
     3.855    -2.789     0.200
     3.941    -2.084     0.200
     5.085    -2.625     0.200
     5.085    -2.250     0.200
     5.809    -2.090     0.200
     8.412    -3.280     0.200
     8.582    -2.711     0.200
     9.907     2.518     0.200
    12.095    -7.268     0.200
    12.095    -6.291     0.200
    12.100    -7.016     0.200
     3.957    -2.857     0.200
     5.091    -2.229     0.200
     5.816    -2.554     0.200
     7.635    -3.491     0.200
     8.423    -6.185     0.200
     8.601    -2.618     0.200
     8.601    -1.267     0.200
     9.909     2.456     0.200
    10.128    -1.089     0.200
    10.128     0.169     0.200
    12.111    -8.058     0.200
    12.111    -5.808     0.200
    12.116    -6.805     0.200
    12.359     0.382     0.200
    13.736    -4.257     0.200
    14.909    -7.393     0.200
    15.662    -7.699     0.200
    15.814     1.844     0.200
     3.947    -0.232     0.200
     5.091    -2.937     0.200
     5.091    -3.570     0.200
     5.809     2.911     0.200
     8.590    -2.377     0.200
    12.106    -7.789     0.200
    12.110    -2.185     0.200
     3.927    -0.944     0.200
     5.090    -2.477     0.200
     5.090    -3.141     0.200
     5.796     0.582     0.200
     7.650    -4.975     0.200
     8.414    -5.074     0.200
     8.569    -4.567     0.200
    12.092    -6.299     0.200
    12.096    -3.893     0.200
     3.910    -0.165     0.200
     5.106    -2.704     0.200
     8.426    -5.257     0.200
     5.220    -2.979     0.200
     3.945     0.706     0.200
     5.087    -3.416     0.200
     5.087    -1.268     0.200
     3.946    -2.099     0.200
     5.140    -4.069     0.200
     2.534    -1.227     0.200
     5.289    -3.072     0.200
     4.651    -1.166     0.200
     5.186    -3.157     0.200
     3.941    -4.693     0.200
     4.663    -1.895     0.200
     5.236    -3.993     0.200
     2.912    -3.116     0.200
     3.881     2.156     0.200
     5.201    -2.132     0.200
     5.700     4.302     0.200
     5.700    -5.800     0.200
     6.223    10.040     0.200
     8.518    -2.923     0.200
     8.550    -4.162     0.200
    12.173    -4.887     0.200
     2.762    -1.957     0.200
     5.022    -1.965     0.200
     5.233    -2.301     0.200
     2.792    -2.969     0.200
     5.100    -1.520     0.200
     5.227    -2.914     0.200
     2.537    -0.867     0.200
     5.113    -3.242     0.200
     5.085    -1.554     0.200
     5.627    -1.218     0.200
     2.778    -2.472     0.200
     3.652    -1.983     0.200
     4.684    -1.464     0.200
     5.091    -1.973     0.200
     5.318    -1.152     0.200
     5.851    -2.332     0.200
    12.148    -4.429     0.200
     2.697     0.917     0.200
     3.304    -1.465     0.200
     2.755    -0.323     0.200
     2.871    -2.582     0.200
     3.219     0.296     0.200
     3.351    -1.489     0.200
     3.637    -0.795     0.200
     4.673    -1.282     0.200
     5.167    -5.318     0.200
     5.669    -2.291     0.200
     5.745    -0.679     0.200
     8.491    -6.446     0.200
     8.554    -5.526     0.200
     8.578    -6.390     0.200
     9.123    -2.088     0.200
     9.416    -0.536     0.200
    12.163    -7.932     0.200
     2.501    -0.376     0.200
     2.501    -0.108     0.200
     2.627     0.746     0.200
     2.766    -2.040     0.200
     2.834    -0.516     0.200
     2.834    -1.675     0.200
     2.939     0.828     0.200
     3.056    -0.158     0.200
     3.111    -0.896     0.200
     3.183    -2.366     0.200
     3.716    -0.441     0.200
     4.050    -1.786     0.200
     4.764    -2.953     0.200
     5.026    -3.157     0.200
     2.740    -0.321     0.200
     2.992    -2.352     0.200
     3.012    -0.340     0.200
     3.090    -0.919     0.200
     3.353    -2.014     0.200
     3.794    -0.408     0.200
     4.041    -3.077     0.200
     4.330    -2.739     0.200
     4.399    -2.768     0.200
     5.175    -1.720     0.200
     5.524    -2.116     0.200
     2.763    -1.253     0.200
     2.763    -1.620     0.200
     2.794    -2.409     0.200
     2.796    -2.839     0.200
     2.859    -2.308     0.200
     3.001    -2.753     0.200
     3.034    -1.145     0.200
     3.034    -2.075     0.200
     3.208    -3.008     0.200
     3.366    -2.407     0.200
     3.817    -1.293     0.200
     4.352    -1.364     0.200
     5.181    -2.733     0.200
     5.542    -2.758     0.200
     2.686     0.657     0.200
     2.723    -1.036     0.200
     2.949     0.603     0.200
     3.023     0.150     0.200
     3.732    -0.234     0.200
     3.778     0.536     0.200
     2.699     0.337     0.200
     2.937    -3.715     0.200
     2.960     0.093     0.200
     3.025    -0.361     0.200
     3.027    -1.540     0.200
     3.743    -0.720     0.200
     3.791     0.221     0.200
     3.977    -1.610     0.200
     4.275    -0.849     0.200
     4.433    -3.665     0.200
     5.216    -0.981     0.200
     5.461    -2.680     0.200
     6.076    -2.907     0.200
     2.719    -1.304     0.200
     2.799    -1.654     0.200
     2.869    -0.055     0.200
     2.921     0.261     0.200
     2.943    -2.132     0.200
     3.058     1.119     0.200
     3.058    -0.561     0.200
     3.295    -1.169     0.200
     3.295    -1.428     0.200
     3.838     1.045     0.200
     4.331    -2.753     0.200
     5.099    -3.051     0.200
     2.764    -2.986     0.200
     2.974    -1.834     0.200
     3.051    -1.741     0.200
     3.134    -2.383     0.200
     3.134    -1.522     0.200
     3.709    -4.787     0.200
     3.833    -2.652     0.200
     3.870    -1.129     0.200
     4.085    -3.172     0.200
     4.371     0.322     0.200
     4.371    -4.248     0.200
     4.383    -2.752     0.200
     4.870    -3.966     0.200
     5.152    -3.266     0.200
     5.568    -2.416     0.200
     6.763    -3.873     0.200
     2.555    -2.038     0.200
     2.544    -0.274     0.200
     2.942    -0.939     0.200
     3.309    -1.572     0.200
     3.318    -2.774     0.200
     3.835    -3.035     0.200
     4.352    -3.783     0.200
     4.676    -1.684     0.200
     4.713    -0.359     0.200
     2.815    -2.009     0.200
     2.975    -1.935     0.200
     2.975    -2.087     0.200
     3.037    -0.529     0.200
     3.121    -1.032     0.200
     3.218     0.250     0.200
     3.317    -0.996     0.200
     3.819    -1.699     0.200
     4.072    -2.110     0.200
     4.383    -1.710     0.200
     4.670    -1.593     0.200
     4.676    -1.312     0.200
     4.875    -3.385     0.200
     5.155    -3.719     0.200
     5.554    -2.265     0.200
     6.138    -4.207     0.200
     6.168    -2.121     0.200
     2.524     0.275     0.200
     2.764     0.586     0.200
     2.825    -2.570     0.200
     3.046    -3.310     0.200
     3.061    -0.386     0.200
     3.064    -1.142     0.200
     3.369    -2.230     0.200
     3.496    -1.413     0.200
     3.548     0.065     0.200
     3.610     0.548     0.200
     3.989    -1.001     0.200
     4.413    -0.098     0.200
     4.459    -2.500     0.200
     5.029    -2.318     0.200
     5.271    -2.707     0.200
     5.376    -0.409     0.200
     5.610    -0.291     0.200
     5.882    -0.534     0.200
     5.970    -5.029     0.200
     2.708     0.367     0.200
     2.921    -1.483     0.200
     2.972    -0.920     0.200
     2.972    -0.360     0.200
     3.015    -1.857     0.200
     3.015    -1.418     0.200
     3.043    -0.967     0.200
     3.043    -0.781     0.200
     3.320    -2.339     0.200
     3.755    -0.865     0.200
     3.920    -1.804     0.200
     3.994    -1.541     0.200
     4.421    -4.334     0.200
     4.616    -0.304     0.200
     4.931    -1.593     0.200
     5.478    -2.297     0.200
     6.040    -1.825     0.200
     6.081    -1.900     0.200
     6.092    -1.949     0.200
     2.771     1.165     0.200
     2.771     0.723     0.200
     3.011     1.441     0.200
     3.272    -2.640     0.200
     2.555    -0.745     0.200
     2.768     0.020     0.200
     2.768    -0.136     0.200
     2.908    -0.990     0.200
     2.958    -1.337     0.200
     3.065     0.473     0.200
     3.284    -2.104     0.200
     3.284    -1.542     0.200
     3.275    -0.880     0.200
     3.845     0.471     0.200
     4.129    -1.321     0.200
     4.318    -2.739     0.200
     4.699    -0.849     0.200
     4.802    -2.851     0.200
     2.573    -0.723     0.200
     2.576    -2.597     0.200
     2.770    -1.915     0.200
     2.916    -1.165     0.200
     3.192    -2.911     0.200
     3.256    -1.777     0.200
     3.252    -2.246     0.200
     4.185    -3.783     0.200
     4.873    -1.937     0.200
     5.492    -4.189     0.200
     2.681     0.787     0.200
     2.908     0.684     0.200
     3.217     0.357     0.200
     3.693     0.555     0.200
     4.562    -0.620     0.200
     5.164    -2.858     0.200
     6.034    -2.342     0.200
     2.650    -0.844     0.200
     2.658    -0.072     0.200
     2.658    -0.229     0.200
     2.758    -2.247     0.200
     2.904    -0.566     0.200
     2.904    -0.218     0.200
     2.954    -1.098     0.200
     3.036    -2.217     0.200
     3.172    -0.943     0.200
     3.172    -1.232     0.200
     3.404    -1.576     0.200
     3.906    -2.726     0.200
     2.595    -2.565     0.200
     2.680    -1.346     0.200
     2.888    -1.970     0.200
     3.030    -2.531     0.200
     3.292    -3.291     0.200
     3.322    -2.792     0.200
     3.547    -3.153     0.200
     2.733    -1.582     0.200
     2.788    -1.480     0.200
     2.954    -1.088     0.200
     3.073    -0.780     0.200
     3.317    -1.895     0.200
     3.329    -2.400     0.200
     2.509     0.733     0.200
     2.545     0.685     0.200
     2.598    -2.535     0.200
     2.676    -1.024     0.200
     2.711    -2.300     0.200
     3.031    -2.757     0.200
     3.194    -1.563     0.200
     3.288    -0.087     0.200
     3.290    -2.474     0.200
     3.290    -2.980     0.200
     3.307    -1.598     0.200
     3.318    -2.158     0.200
     3.318    -2.427     0.200
     3.691    -1.548     0.200
     3.765    -1.161     0.200
     3.984    -0.301     0.200
     4.300    -3.585     0.200
     4.530    -6.857     0.200
     4.719    -1.987     0.200
     4.823    -1.066     0.200
     2.687    -1.635     0.200
     2.930    -1.932     0.200
     2.943    -1.244     0.200
     2.943    -0.871     0.200
     3.075    -0.007     0.200
     3.319    -2.658     0.200
     4.711    -1.625     0.200
     2.999    -0.502     0.200
     3.403    -1.958     0.200
     3.424    -1.816     0.200
     2.756    -0.844     0.200
     2.838    -1.107     0.200
     3.161    -1.580     0.200
     3.201    -1.238     0.200
     3.201    -1.884     0.200
     3.952    -1.025     0.200
     4.106    -0.223     0.200
     4.169    -2.144     0.200
     4.230    -3.279     0.200
     4.217    -0.821     0.200
     2.555     1.248     0.200
     2.602     1.497     0.200
     2.738    -2.626     0.200
     2.802     1.034     0.200
     2.802     1.550     0.200
     3.079    -0.240     0.200
     3.359    -2.410     0.200
     4.450     1.166     0.200
     2.641    -2.513     0.200
     2.791    -0.921     0.200
     3.197    -0.211     0.200
     3.189    -2.546     0.200
     3.216    -1.008     0.200
     3.216    -1.387     0.200
     3.597    -3.466     0.200
     3.676    -2.603     0.200
     4.769     0.997     0.200
     5.970     0.434     0.200
     2.668    -1.325     0.200
     2.962    -0.560     0.200
     3.277    -0.950     0.200
     4.618     0.074     0.200
     2.751    -2.238     0.200
     2.736    -1.446     0.200
     2.668    -1.778     0.200
     2.823    -2.091     0.200
     3.024    -2.308     0.200
     2.715    -0.727     0.200
     2.744    -1.128     0.200
     2.980    -0.585     0.200
     3.015    -1.320     0.200
     3.368    -2.156     0.200
     2.844    -2.709     0.200
     4.256    -3.620     0.200
     3.150    -2.581     0.200
     3.188    -1.377     0.200
     2.804    -2.318     0.200
     5.113    -3.351     0.200
     5.821    -1.891     0.200
     5.105    -4.014     0.200
     5.819     0.135     0.200
     3.067    -1.899     0.200
     3.769    -1.477     0.200
     3.774     0.138     0.200
     3.293    -0.956     0.200
     3.660    -0.473     0.200
     3.803     0.449     0.200
     4.603     0.184     0.200
     5.248    -3.388     0.200
     5.238    -4.827     0.200
     7.084    11.870     0.200
     3.944    -2.227     0.200
     2.713    -1.886     0.200
     2.537    -1.561     0.200
     3.116    -1.734     0.200
     2.517     3.121     0.200
     2.538    -1.069     0.200
     2.501    -1.573     0.200
     3.054     0.042     0.200
     3.251    -1.027     0.200
     2.523    -0.779     0.200
     2.521     0.210     0.200
     2.740    -0.612     0.200
     2.884    -2.801     0.200
     3.079    -1.283     0.200
     2.501    -1.294     0.200
     2.543    -0.510     0.200
     2.600     0.915     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.788     0.333     0.200
     1.839    -0.743     0.200
     2.124     0.124     0.200
     1.319    -2.053     0.200
     1.665    -1.496     0.200
     1.733    -1.477     0.200
     1.825    -2.270     0.200
     1.672     0.831     0.200
     1.724    -1.332     0.200
     1.750    -1.116     0.200
     1.818    -0.720     0.200
     2.365    -5.585     0.200
     3.313   -11.684     0.200
     3.416   -12.543     0.200
     1.506    -0.064     0.200
     1.861    -2.118     0.200
     2.009    -3.991     0.200
     1.626     0.713     0.200
     1.651     0.630     0.200
     1.713    -0.935     0.200
     3.914   -16.248     0.200
     4.842   -22.429     0.200
     1.942    -2.376     0.200
     1.573     1.220     0.200
     1.582     1.483     0.200
     3.819   -16.051     0.200
     1.577    -0.198     0.200
     1.636    -0.332     0.200
     1.706     0.972     0.200
     1.782     0.149     0.200
     2.304    -4.540     0.200
     3.898   -13.700     0.200
     4.188   -15.724     0.200
     5.123   -21.034     0.200
     8.547   -48.861     0.200
    12.110   -71.743     0.200
     1.706     0.065     0.200
     1.711     0.020     0.200
     1.804    -1.520     0.200
     1.835     0.173     0.200
     2.296    -4.529     0.200
     2.803    -7.645     0.200
     1.736    -0.154     0.200
     1.814     0.442     0.200
     2.707    -7.473     0.200
     3.194   -10.977     0.200
     3.298   -11.249     0.200
     8.550   -52.060     0.200
    12.081   -71.810     0.200
     1.501     0.380     0.200
     3.293   -12.369     0.200
     3.994   -17.756     0.200
     3.898   -17.395     0.200
     5.698   -32.158     0.200
     8.573   -53.326     0.200
     3.855   -15.367     0.200
     1.152     2.196     0.200
     1.723    -0.624     0.200
     2.791    -8.685     0.200
     3.941   -15.311     0.200
     8.582   -53.101     0.200
    10.133   -58.376     0.200
     3.957   -15.724     0.200
     8.601   -53.813     0.200
    10.002   -59.909     0.200
    10.128   -57.815     0.200
     1.719     0.302     0.200
     3.947   -16.349     0.200
     8.590   -52.479     0.200
     1.560     1.017     0.200
     3.927   -15.515     0.200
     8.569   -51.165     0.200
     8.569   -51.895     0.200
     1.549     1.839     0.200
     2.293    -2.822     0.200
     2.293    -3.486     0.200
     2.293     0.491     0.200
     3.910   -13.899     0.200
     1.344     2.871     0.200
     1.493     1.124     0.200
     1.719    -0.922     0.200
     1.719    -0.680     0.200
     1.522     0.524     0.200
     1.620    -0.200     0.200
     1.676     0.206     0.200
     1.899    -2.132     0.200
     1.919    -1.730     0.200
     2.117    -2.233     0.200
     3.433   -12.939     0.200
     1.371     1.814     0.200
     1.453    -0.293     0.200
     1.458     0.484     0.200
     1.752    -0.505     0.200
     1.855    -2.138     0.200
     1.709     0.847     0.200
     2.612    -6.664     0.200
     3.203   -10.861     0.200
     3.876   -14.615     0.200
     3.876   -14.294     0.200
     4.571   -21.075     0.200
     5.095   -26.837     0.200
     1.530    -0.170     0.200
     1.577     0.300     0.200
     1.817    -1.830     0.200
     1.806    -1.841     0.200
     2.021    -1.206     0.200
     3.156   -12.658     0.200
     3.898   -17.238     0.200
     4.527   -20.661     0.200
     1.338     1.601     0.200
     1.785    -0.244     0.200
     2.912   -11.946     0.200
     3.189   -12.223     0.200
     3.881   -15.354     0.200
     8.550   -52.232     0.200
     1.676     1.122     0.200
     1.716     0.836     0.200
     1.764     0.319     0.200
     1.879    -0.335     0.200
     2.180    -0.875     0.200
     3.858   -16.384     0.200
     1.609     2.108     0.200
     1.822     0.016     0.200
     1.822     0.145     0.200
     2.037    -0.888     0.200
     2.127    -0.646     0.200
     2.303    -2.474     0.200
     2.385    -4.355     0.200
     3.327   -10.692     0.200
     1.675    -1.154     0.200
     1.672     0.670     0.200
     1.723     0.184     0.200
     1.758     1.547     0.200
     1.831     0.981     0.200
     1.855     0.189     0.200
     1.641     0.920     0.200
     1.681    -1.184     0.200
     1.714    -0.084     0.200
     1.705     0.274     0.200
     1.734     1.153     0.200
     1.734     1.024     0.200
     1.808     0.615     0.200
     1.836    -0.228     0.200
     1.920    -1.009     0.200
     2.108     0.755     0.200
     2.169     0.046     0.200
     2.175    -2.714     0.200
     2.180    -2.973     0.200
     3.960   -16.013     0.200
     1.677     1.401     0.200
     1.732     0.782     0.200
     1.803     1.991     0.200
     1.867    -0.282     0.200
     1.872     0.142     0.200
     1.761     0.487     0.200
     1.836     0.017     0.200
     1.867    -0.042     0.200
     3.981   -14.980     0.200
     1.687    -0.040     0.200
     1.739     0.236     0.200
     1.856     0.206     0.200
     4.008   -15.385     0.200
     4.684   -21.624     0.200
     7.190   -42.816     0.200
     8.653   -54.166     0.200
     1.786    -0.127     0.200
     2.203    -3.228     0.200
     3.874   -15.078     0.200
     1.363     1.115     0.200
     1.363     1.252     0.200
     1.497     2.056     0.200
     1.643    -0.058     0.200
     1.680     0.439     0.200
     1.680     0.759     0.200
     1.742    -1.733     0.200
     1.751    -0.144     0.200
     1.774    -0.625     0.200
     1.748    -0.308     0.200
     1.765    -0.266     0.200
     1.807    -0.929     0.200
     1.864    -1.207     0.200
     3.225   -11.887     0.200
     3.219   -10.864     0.200
     3.351   -13.129     0.200
     3.637   -15.662     0.200
     3.849   -15.376     0.200
     3.917   -18.621     0.200
     4.348   -18.284     0.200
     4.673   -22.903     0.200
     5.167   -28.846     0.200
     5.247   -26.731     0.200
     5.745   -32.983     0.200
     8.554   -53.326     0.200
     8.578   -53.609     0.200
     1.673     1.084     0.200
     1.760     0.938     0.200
     2.097    -0.354     0.200
     2.097     0.952     0.200
     2.097     0.213     0.200
     2.207    -2.275     0.200
     2.254     0.777     0.200
     3.856   -14.318     0.200
     1.582     0.188     0.200
     1.631     0.266     0.200
     1.661     0.577     0.200
     1.661     0.159     0.200
     1.758    -0.922     0.200
     1.758    -0.578     0.200
     1.761    -0.603     0.200
     1.753    -1.427     0.200
     1.803    -1.461     0.200
     3.628   -16.622     0.200
     3.794   -16.806     0.200
     3.898   -17.989     0.200
     4.399   -22.307     0.200
     1.632    -0.046     0.200
     1.678    -0.202     0.200
     1.761    -1.718     0.200
     1.776    -2.276     0.200
     1.776    -2.455     0.200
     1.763    -0.778     0.200
     1.821    -2.337     0.200
     3.001   -12.487     0.200
     3.231   -12.909     0.200
     3.366   -15.219     0.200
     3.390   -13.119     0.200
     3.650   -17.121     0.200
     3.817   -17.356     0.200
     3.817   -16.102     0.200
     3.918   -18.685     0.200
     4.057   -20.235     0.200
     4.409   -22.746     0.200
     4.686   -24.668     0.200
     1.593     1.346     0.200
     1.593     0.776     0.200
     1.665     1.125     0.200
     1.711     0.012     0.200
     1.711    -0.230     0.200
     1.791    -0.210     0.200
     2.045    -1.947     0.200
     3.014   -11.002     0.200
     3.308   -11.987     0.200
     3.360   -13.534     0.200
     3.732   -15.570     0.200
     3.778   -14.440     0.200
     4.636   -22.546     0.200
     5.163   -25.365     0.200
     1.182     2.953     0.200
     1.597     0.347     0.200
     1.667    -0.105     0.200
     1.727    -1.010     0.200
     1.806    -0.761     0.200
     3.190   -11.413     0.200
     3.325   -13.241     0.200
     3.743   -16.369     0.200
     4.652   -23.172     0.200
     1.267     2.005     0.200
     1.767     1.857     0.200
     1.758     1.238     0.200
     1.846     1.319     0.200
     1.933     0.160     0.200
     2.179     0.338     0.200
     2.921    -9.121     0.200
     3.474   -11.592     0.200
     3.838   -15.955     0.200
     1.492    -0.251     0.200
     1.614    -1.000     0.200
     1.614    -1.519     0.200
     1.664    -1.292     0.200
     1.777    -2.169     0.200
     1.795    -0.962     0.200
     1.808    -2.150     0.200
     1.880    -2.697     0.200
     1.889    -1.064     0.200
     2.772    -9.552     0.200
     3.229   -12.357     0.200
     3.229   -13.088     0.200
     3.323   -13.972     0.200
     3.323   -14.115     0.200
     3.344   -14.210     0.200
     3.421   -13.941     0.200
     3.833   -17.951     0.200
     3.867   -17.348     0.200
     4.170   -18.688     0.200
     4.383   -22.740     0.200
     4.691   -22.841     0.200
     4.680   -24.703     0.200
     5.301   -28.153     0.200
     5.332   -28.838     0.200
     5.568   -32.666     0.200
     6.153   -34.850     0.200
     7.022   -42.888     0.200
     1.403     1.583     0.200
     1.794     0.006     0.200
     1.784    -0.190     0.200
     1.784     0.076     0.200
     1.796     0.540     0.200
     1.837     0.447     0.200
     1.917    -1.057     0.200
     2.184    -2.604     0.200
     2.170    -0.793     0.200
     4.713   -19.929     0.200
     5.299   -24.319     0.200
     1.608    -0.309     0.200
     1.666    -1.194     0.200
     1.692     0.643     0.200
     1.692    -0.338     0.200
     1.735    -0.773     0.200
     1.735    -0.973     0.200
     1.763    -0.300     0.200
     1.765    -1.734     0.200
     1.765    -1.874     0.200
     1.788    -1.032     0.200
     1.801    -1.909     0.200
     1.876    -2.041     0.200
     3.218   -13.240     0.200
     3.218   -11.660     0.200
     3.238   -13.344     0.200
     3.317   -13.756     0.200
     3.317   -13.630     0.200
     3.341   -15.022     0.200
     3.341   -14.232     0.200
     3.416   -13.719     0.200
     3.635   -16.839     0.200
     3.819   -17.409     0.200
     3.819   -16.154     0.200
     3.926   -18.609     0.200
     3.926   -17.767     0.200
     4.165   -18.745     0.200
     4.330   -20.745     0.200
     4.383   -22.611     0.200
     4.670   -24.383     0.200
     4.676   -22.454     0.200
     4.676   -22.092     0.200
     5.287   -27.132     0.200
     5.318   -27.835     0.200
     6.110   -35.866     0.200
     1.763     0.994     0.200
     1.751     0.123     0.200
     1.874     1.231     0.200
     1.894    -0.946     0.200
     2.074     2.624     0.200
     2.074     0.751     0.200
     2.079     0.007     0.200
     2.079    -0.161     0.200
     2.128    -2.096     0.200
     2.128    -0.420     0.200
     2.128    -0.545     0.200
     2.219     0.408     0.200
     2.219    -0.268     0.200
     3.268   -10.168     0.200
     3.786   -12.329     0.200
     4.459   -21.041     0.200
     4.973   -19.661     0.200
     5.018   -20.242     0.200
     5.029   -20.254     0.200
     5.265   -22.774     0.200
     5.826   -27.894     0.200
     5.878   -28.044     0.200
     6.460   -31.702     0.200
     6.533   -32.578     0.200
     1.614     0.568     0.200
     1.614    -0.062     0.200
     1.685    -0.008     0.200
     1.721    -0.464     0.200
     1.732    -0.576     0.200
     1.732    -0.698     0.200
     1.803    -0.762     0.200
     1.824    -1.033     0.200
     2.054    -2.152     0.200
     2.595    -7.397     0.200
     2.972   -10.820     0.200
     3.192   -11.674     0.200
     3.192   -12.384     0.200
     3.320   -12.904     0.200
     3.320   -12.449     0.200
     3.358   -12.518     0.200
     3.755   -16.784     0.200
     3.854   -17.715     0.200
     4.616   -22.405     0.200
     5.224   -26.474     0.200
     5.244   -26.407     0.200
     6.040   -33.896     0.200
     6.081   -33.930     0.200
     7.122   -42.516     0.200
     1.605     2.265     0.200
     1.664     1.770     0.200
     1.814     0.356     0.200
     1.814     0.930     0.200
     2.272     1.435     0.200
     2.272     0.857     0.200
     3.422   -11.614     0.200
     3.796   -13.970     0.200
     3.859   -12.802     0.200
     3.872   -14.215     0.200
     3.981   -15.447     0.200
     4.521   -20.478     0.200
     4.662   -19.876     0.200
     5.212   -22.420     0.200
     5.257   -21.957     0.200
     5.266   -21.842     0.200
     6.064   -30.739     0.200
     6.771   -35.013     0.200
     7.167   -39.386     0.200
     1.285     2.274     0.200
     1.760     0.407     0.200
     1.758     0.930     0.200
     1.758     1.047     0.200
     1.824     0.428     0.200
     1.861     1.299     0.200
     2.195     0.098     0.200
     2.195    -0.300     0.200
     2.718    -6.397     0.200
     2.908    -8.881     0.200
     3.284   -10.487     0.200
     3.845   -13.748     0.200
     4.699   -19.919     0.200
     5.312   -22.569     0.200
     5.362   -22.522     0.200
     6.147   -32.238     0.200
     1.420     0.185     0.200
     1.519    -0.051     0.200
     1.521    -0.386     0.200
     1.701    -0.925     0.200
     1.738    -1.364     0.200
     1.754    -1.132     0.200
     1.864    -0.879     0.200
     1.871    -1.860     0.200
     1.893    -1.769     0.200
     1.929    -3.130     0.200
     1.986    -0.798     0.200
     1.986    -1.689     0.200
     1.989    -1.730     0.200
     2.084    -2.400     0.200
     2.138    -4.121     0.200
     4.181   -18.813     0.200
     1.272     2.348     0.200
     1.408     4.543     0.200
     1.744     2.464     0.200
     1.744     1.136     0.200
     1.912     0.723     0.200
     1.880     0.318     0.200
     2.224     2.067     0.200
     2.224     0.497     0.200
     2.282     1.614     0.200
     2.282     0.145     0.200
     2.279    -0.492     0.200
     1.175     0.945     0.200
     1.526     0.507     0.200
     1.595     0.414     0.200
     1.703    -0.391     0.200
     1.703    -0.251     0.200
     1.762    -0.661     0.200
     1.817    -0.852     0.200
     1.817    -1.153     0.200
     1.861    -1.947     0.200
     1.975     0.483     0.200
     3.069   -11.688     0.200
     3.289   -11.730     0.200
     3.327   -12.618     0.200
     3.601   -13.903     0.200
     3.688   -14.105     0.200
     3.775   -14.890     0.200
     3.981   -17.501     0.200
     4.035   -16.845     0.200
     4.472   -22.608     0.200
     5.111   -23.709     0.200
     5.964   -33.548     0.200
     1.611    -1.299     0.200
     1.815    -1.769     0.200
     1.864    -2.137     0.200
     2.005    -2.437     0.200
     2.114    -3.719     0.200
     2.891    -9.580     0.200
     3.038   -10.481     0.200
     3.292   -12.589     0.200
     3.556   -14.142     0.200
     3.937   -16.034     0.200
     1.735     0.109     0.200
     1.786     1.183     0.200
     1.802    -0.432     0.200
     1.905    -1.015     0.200
     2.158     0.024     0.200
     2.197    -2.995     0.200
     3.448   -12.077     0.200
     3.854   -14.928     0.200
     1.216     0.655     0.200
     1.326    -0.019     0.200
     1.389    -0.106     0.200
     1.392    -0.145     0.200
     1.811    -1.362     0.200
     1.817    -1.708     0.200
     1.861    -1.702     0.200
     1.861    -1.400     0.200
     1.882    -1.879     0.200
     1.882    -0.385     0.200
     1.953    -1.649     0.200
     2.008    -1.875     0.200
     2.110    -1.300     0.200
     1.309     0.200     0.200
     1.385    -0.184     0.200
     1.806    -0.988     0.200
     1.853    -1.427     0.200
     1.872    -0.336     0.200
     1.403     0.533     0.200
     1.567     0.311     0.200
     1.611    -1.242     0.200
     1.757    -1.472     0.200
     1.750    -0.058     0.200
     1.811    -1.726     0.200
     1.811    -1.890     0.200
     1.812    -1.557     0.200
     1.859    -1.609     0.200
     1.859    -1.997     0.200
     1.877    -0.822     0.200
     1.949    -0.673     0.200
     1.948    -1.545     0.200
     1.968    -0.635     0.200
     2.005    -1.445     0.200
     2.113    -1.553     0.200
     2.774    -9.140     0.200
     2.885    -9.414     0.200
     2.886   -10.668     0.200
     2.886   -10.563     0.200
     2.996   -10.022     0.200
     3.037   -10.575     0.200
     3.288   -12.708     0.200
     3.288   -11.546     0.200
     3.290   -13.675     0.200
     3.555   -14.539     0.200
     3.600   -14.706     0.200
     3.691   -15.421     0.200
     3.936   -16.047     0.200
     3.973   -18.013     0.200
     3.973   -17.595     0.200
     3.984   -16.821     0.200
     4.036   -19.349     0.200
     4.099   -17.668     0.200
     4.257   -20.384     0.200
     4.300   -20.710     0.200
     4.306   -19.582     0.200
     4.468   -21.834     0.200
     4.520   -20.839     0.200
     4.690   -23.337     0.200
     4.719   -24.159     0.200
     4.745   -23.465     0.200
     4.806   -22.923     0.200
     4.823   -23.037     0.200
     4.823   -22.439     0.200
     1.765     0.935     0.200
     1.892     0.069     0.200
     1.652     0.401     0.200
     1.694    -1.486     0.200
     1.703    -0.281     0.200
     1.742     0.599     0.200
     1.782    -0.648     0.200
     1.782    -0.478     0.200
     1.794    -0.477     0.200
     1.814     1.034     0.200
     1.835    -0.485     0.200
     1.916    -0.179     0.200
     2.169    -1.616     0.200
     2.169    -2.996     0.200
     2.686    -7.571     0.200
     3.459   -12.962     0.200
     4.711   -20.845     0.200
     1.314     3.461     0.200
     1.852    -0.108     0.200
     1.913    -1.847     0.200
     1.913    -1.642     0.200
     1.930    -1.318     0.200
     2.936   -10.750     0.200
     4.811   -23.093     0.200
     4.858   -23.464     0.200
     5.469   -29.010     0.200
     1.489     1.078     0.200
     1.484     1.050     0.200
     1.698     0.170     0.200
     1.698    -0.172     0.200
     1.698    -0.176     0.200
     1.789    -0.318     0.200
     1.789    -0.104     0.200
     1.869    -1.773     0.200
     1.921    -1.387     0.200
     1.985    -1.664     0.200
     2.053    -2.382     0.200
     2.098     0.016     0.200
     2.126    -2.411     0.200
     2.338    -6.009     0.200
     2.512    -6.938     0.200
     2.595    -7.549     0.200
     2.919   -10.787     0.200
     2.919    -9.673     0.200
     3.148   -11.737     0.200
     3.148   -10.130     0.200
     3.161   -11.900     0.200
     3.161   -11.266     0.200
     3.178   -11.226     0.200
     3.199   -12.446     0.200
     3.201   -11.938     0.200
     3.357   -12.477     0.200
     3.637   -15.190     0.200
     3.637   -14.473     0.200
     3.673   -14.396     0.200
     3.940   -17.207     0.200
     3.952   -16.934     0.200
     3.952   -16.306     0.200
     4.106   -18.242     0.200
     4.106   -16.691     0.200
     4.169   -20.724     0.200
     4.300   -20.713     0.200
     4.423   -19.738     0.200
     4.586   -20.004     0.200
     4.622   -24.044     0.200
     4.622   -20.772     0.200
     4.794   -24.060     0.200
     4.794   -21.049     0.200
     4.813   -21.715     0.200
     4.864   -22.794     0.200
     4.917   -23.721     0.200
     5.414   -30.005     0.200
     5.505   -29.151     0.200
     6.276   -36.126     0.200
     1.739     0.148     0.200
     1.832    -0.199     0.200
     1.837    -1.102     0.200
     1.313     1.483     0.200
     1.307     1.913     0.200
     1.307     1.010     0.200
     1.375     1.896     0.200
     1.369     1.505     0.200
     1.417     1.196     0.200
     1.552    -0.229     0.200
     1.795    -2.031     0.200
     1.803    -1.442     0.200
     1.855    -1.627     0.200
     1.872    -1.609     0.200
     1.951    -2.922     0.200
     1.988    -2.355     0.200
     2.257    -6.154     0.200
     2.471    -6.575     0.200
     2.662    -9.485     0.200
     2.831   -10.152     0.200
     3.082   -10.832     0.200
     3.155   -11.516     0.200
     3.421   -13.129     0.200
     3.701   -17.412     0.200
     3.932   -17.466     0.200
     4.230   -21.400     0.200
     4.217   -19.137     0.200
     4.312   -20.324     0.200
     5.396   -28.605     0.200
     5.470   -29.566     0.200
     1.607     1.850     0.200
     1.751     1.077     0.200
     1.751     1.507     0.200
     1.865    -0.449     0.200
     1.961    -1.041     0.200
     2.116     1.535     0.200
     2.116     1.895     0.200
     2.117     1.425     0.200
     2.117     1.972     0.200
     2.141     1.469     0.200
     2.141     1.641     0.200
     2.260     1.443     0.200
     1.310     1.180     0.200
     1.298     0.990     0.200
     1.400     0.686     0.200
     1.472    -0.003     0.200
     1.618    -0.856     0.200
     1.710     0.508     0.200
     1.710     0.219     0.200
     1.778     0.319     0.200
     1.778     0.557     0.200
     1.824    -0.419     0.200
     1.875    -0.513     0.200
     1.879     0.096     0.200
     1.959     0.213     0.200
     2.007     0.446     0.200
     2.024    -2.328     0.200
     2.083    -1.760     0.200
     2.229     0.080     0.200
     2.229    -0.486     0.200
     2.232    -2.590     0.200
     2.232     0.019     0.200
     2.232    -3.066     0.200
     2.465    -5.961     0.200
     2.819    -8.774     0.200
     2.853    -7.881     0.200
     3.102    -9.781     0.200
     3.197   -11.004     0.200
     3.629   -13.436     0.200
     3.625   -13.798     0.200
     3.925   -15.319     0.200
     4.071   -15.575     0.200
     4.379   -19.164     0.200
     4.769   -19.843     0.200
     5.385   -23.113     0.200
     5.388   -25.011     0.200
     5.469   -25.079     0.200
     5.970   -31.492     0.200
     7.275   -41.386     0.200
     9.359   -55.576     0.200
     1.932     0.841     0.200
     3.171   -10.983     0.200
     1.178     1.146     0.200
     1.178     1.419     0.200
     1.338     1.103     0.200
     1.318     2.120     0.200
     1.318    -0.544     0.200
     1.634     0.332     0.200
     1.697    -1.199     0.200
     1.758    -0.712     0.200
     1.758    -0.852     0.200
     1.820    -1.243     0.200
     1.824    -0.909     0.200
     1.824    -1.386     0.200
     2.058    -1.408     0.200
     2.058    -0.205     0.200
     2.099    -3.346     0.200
     2.159    -5.779     0.200
     2.412    -7.939     0.200
     3.218   -11.748     0.200
     3.341   -12.920     0.200
     3.381   -14.558     0.200
     3.782   -15.704     0.200
     4.105   -17.851     0.200
     4.270   -19.308     0.200
     4.509   -20.277     0.200
     4.431   -21.691     0.200
     4.550   -21.001     0.200
     4.587   -20.459     0.200
     1.190     1.499     0.200
     1.190     1.257     0.200
     1.621     0.648     0.200
     1.738    -0.136     0.200
     1.807    -0.815     0.200
     1.825    -0.866     0.200
     2.058    -0.547     0.200
     3.360   -12.061     0.200
     3.763   -14.609     0.200
     1.338    -0.191     0.200
     1.632    -1.805     0.200
     1.947    -3.297     0.200
     1.434     0.292     0.200
     1.604     1.354     0.200
     1.667    -0.824     0.200
     1.265     1.236     0.200
     1.796    -0.479     0.200
     3.030    -9.681     0.200
     3.812   -15.202     0.200
     3.920   -16.767     0.200
     1.584    -1.480     0.200
     1.742    -1.158     0.200
     1.785    -0.934     0.200
     1.819    -1.943     0.200
     1.838    -1.565     0.200
     1.915    -2.315     0.200
     1.951    -2.817     0.200
     2.697    -9.512     0.200
     3.131   -11.524     0.200
     3.214   -11.912     0.200
     3.236   -11.823     0.200
     3.908   -17.687     0.200
     4.043   -18.454     0.200
     4.757   -22.786     0.200
     5.373   -28.232     0.200
     5.440   -28.003     0.200
     6.219   -35.735     0.200
     1.660    -0.423     0.200
     1.688    -1.168     0.200
     1.754    -0.001     0.200
     3.894   -14.781     0.200
     5.113   -24.800     0.200
     8.633   -54.870     0.200
     8.633   -53.729     0.200
     1.665    -0.377     0.200
     1.681    -0.610     0.200
     1.740    -0.859     0.200
     1.748     0.366     0.200
     1.808    -1.018     0.200
     1.847    -1.117     0.200
     1.934    -1.792     0.200
     1.929    -1.403     0.200
     2.181    -0.060     0.200
     2.799    -9.012     0.200
     3.973   -17.108     0.200
     8.621   -51.291     0.200
     1.280     2.176     0.200
     1.257     1.967     0.200
     1.257     2.247     0.200
     1.280     2.298     0.200
     1.907    -1.188     0.200
     2.168    -3.129     0.200
     2.168     1.061     0.200
     3.769   -15.717     0.200
     5.340   -28.136     0.200
     1.256     0.086     0.200
     1.395    -0.001     0.200
     1.397     0.157     0.200
     1.381    -0.312     0.200
     1.532    -1.393     0.200
     1.533    -2.748     0.200
     1.656    -2.579     0.200
     1.845    -3.401     0.200
     1.901    -3.601     0.200
     1.439     2.523     0.200
     2.118    -3.009     0.200
     2.100    -1.730     0.200
     2.127    -2.475     0.200
     1.266     2.133     0.200
     1.254     2.083     0.200
     1.662     1.377     0.200
     1.698     0.979     0.200
     1.879    -1.693     0.200
     1.987    -0.650     0.200
     1.985    -0.712     0.200
     2.236    -1.581     0.200
     3.021   -10.006     0.200
     1.586     2.031     0.200
     1.676    -0.125     0.200
     3.639   -14.143     0.200
     3.803   -14.790     0.200
     3.837   -14.649     0.200
     4.603   -20.535     0.200
     4.678   -21.727     0.200
     1.826    -0.411     0.200
     2.020    -1.527     0.200
     4.673   -21.794     0.200
     1.319     0.620     0.200
     1.438     0.257     0.200
     1.438     0.117     0.200
     1.431     0.213     0.200
     1.507    -0.531     0.200
     1.664    -1.889     0.200
     1.779    -1.723     0.200
     1.779    -1.750     0.200
     1.886    -0.515     0.200
     1.160     0.909     0.200
     1.160    -0.673     0.200
     1.208     0.902     0.200
     1.281    -0.468     0.200
     1.307    -0.271     0.200
     1.317    -0.035     0.200
     1.516    -2.581     0.200
     1.414    -1.476     0.200
     1.468    -0.971     0.200
     1.466    -0.124     0.200
     1.466    -1.702     0.200
     1.502    -1.288     0.200
     1.529    -1.420     0.200
     1.589    -1.450     0.200
     1.693    -2.259     0.200
     1.706    -1.867     0.200
     1.717    -0.596     0.200
     1.717    -3.557     0.200
     1.705    -1.702     0.200
     2.003    -6.913     0.200
     2.574   -10.122     0.200
     4.885   -26.681     0.200
     1.379     2.250     0.200
     1.715     1.160     0.200
     1.815     0.287     0.200
     1.910    -1.592     0.200
     2.149     0.230     0.200
     2.335    -4.680     0.200
     3.443   -11.341     0.200
     3.862   -13.499     0.200
     3.944   -14.727     0.200
     1.407     0.948     0.200
     1.748    -0.824     0.200
     1.799    -0.419     0.200
     1.799    -0.099     0.200
     1.798    -1.368     0.200
     1.928    -1.033     0.200
     2.014    -2.976     0.200
     2.262    -7.310     0.200
     2.716   -11.074     0.200
     4.003   -17.521     0.200
     4.798   -26.703     0.200
     1.405     1.091     0.200
     1.593    -0.554     0.200
     1.751    -0.514     0.200
     1.801    -0.115     0.200
     1.800    -1.113     0.200
     1.931    -0.368     0.200
     1.931    -2.532     0.200
     2.021    -2.366     0.200
     2.265    -5.808     0.200
     2.252    -6.254     0.200
     2.713   -11.003     0.200
     4.002   -17.843     0.200
     4.242   -18.430     0.200
     4.797   -23.414     0.200
     1.756    -0.836     0.200
     1.876     0.950     0.200
     1.885    -0.758     0.200
     1.925    -0.152     0.200
     2.110    -1.255     0.200
     1.932     0.746     0.200
     1.932     0.246     0.200
     1.975    -0.474     0.200
     2.145     2.167     0.200
     1.675     1.647     0.200
     1.730     1.649     0.200
     1.747     2.407     0.200
     1.946     1.287     0.200
     2.055    -1.741     0.200
     2.058    -1.545     0.200
     1.302     3.211     0.200
     1.808     0.087     0.200
     2.178    -2.624     0.200
     1.382     2.781     0.200
     1.682     1.061     0.200
     1.934    -1.310     0.200
     1.891     0.831     0.200
     2.058    -1.380     0.200
     1.819     1.433     0.200
     1.918    -0.569     0.200
     2.031     1.807     0.200
     1.545     2.600     0.200
     1.877     1.051     0.200
     1.922     0.742     0.200
     1.837    -0.307     0.200
     1.988     0.029     0.200
     2.103    -0.561     0.200
     2.128    -1.271     0.200
     3.180    -9.421     0.200
     3.781   -12.215     0.200
     1.357     2.676     0.200
     1.557     1.919     0.200
     1.839    -0.023     0.200
     1.932     0.176     0.200
     1.328     3.071     0.200
     2.129    -1.188     0.200
     1.406     2.661     0.200
     1.674     1.264     0.200
     1.689     1.344     0.200
     1.762     2.276     0.200
     1.917    -0.179     0.200
     1.554     1.177     0.200
     1.824    -0.729     0.200
     1.888     0.184     0.200
     1.932    -0.004     0.200
     2.001    -1.583     0.200
     2.114    -1.621     0.200
     2.127    -2.473     0.200
     1.659     1.514     0.200
     1.715     1.022     0.200
     1.733     1.039     0.200
     1.931     0.872     0.200
     2.087    -1.631     0.200
     2.336    -5.143     0.200
     2.481    -5.066     0.200
     2.887    -7.201     0.200
     2.932    -7.403     0.200
     1.478     2.169     0.200
     1.823     0.064     0.200
     1.844     1.971     0.200
     1.993    -0.902     0.200
     1.913     1.371     0.200
     2.095    -0.999     0.200
     2.023    -1.835     0.200
     2.177    -1.906     0.200
     1.924    -0.128     0.200
     1.928    -0.246     0.200
     2.119     0.969     0.200
     2.121    -2.570     0.200
     2.106    -1.725     0.200
     2.181    -2.268     0.200
     2.276    -0.938     0.200
     1.737     1.721     0.200
     1.874    -0.738     0.200
     2.111    -1.183     0.200
     2.083     0.531     0.200
     3.226    -9.419     0.200
     1.427     2.692     0.200
     1.746     0.742     0.200
     1.934     0.194     0.200
     1.892    -0.552     0.200
     1.923    -0.215     0.200
     2.032    -1.711     0.200
     2.024     2.679     0.200
     2.131     1.081     0.200
     2.480    -4.841     0.200
     1.365     3.007     0.200
     1.664     1.790     0.200
     1.869    -0.195     0.200
     1.960     0.177     0.200
     2.109    -3.145     0.200
     2.082    -0.921     0.200
     1.249     3.320     0.200
     1.845     0.952     0.200
     2.081    -1.390     0.200
     2.111    -0.151     0.200
     1.699     1.351     0.200
     1.757     1.317     0.200
     1.876    -1.158     0.200
     2.045    -1.267     0.200
     2.155    -1.029     0.200
     2.170    -1.721     0.200
     2.228    -1.278     0.200
     1.852     1.754     0.200
     2.014    -1.270     0.200
     2.077    -2.198     0.200
     2.122    -1.057     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.235    -0.088     0.200
     2.284    -2.342     0.200
     2.332    -5.225     0.200
     1.087     2.287     0.200
     1.757    -1.515     0.200
     1.773    -2.478     0.200
     1.845    -2.753     0.200
     2.574    -8.231     0.200
     1.293    -0.997     0.200
     2.437    -4.807     0.200
     2.550    -6.709     0.200
     3.489   -13.401     0.200
     3.570   -14.054     0.200
     0.425     1.384     0.200
     0.439     0.737     0.200
     0.709     0.502     0.200
     1.188     0.268     0.200
     1.284    -0.294     0.200
     1.672    -1.466     0.200
     0.289     0.557     0.200
     0.335     1.537     0.200
     1.213     1.169     0.200
     1.548    -0.912     0.200
     1.836    -2.094     0.200
     2.401    -4.889     0.200
     1.367    -2.147     0.200
     1.676    -2.344     0.200
     2.263    -6.181     0.200
     0.216     0.708     0.200
     1.095     1.562     0.200
     1.223     0.880     0.200
     2.386    -4.296     0.200
     0.293     0.607     0.200
     0.357     0.188     0.200
     1.039     1.859     0.200
     1.399     0.859     0.200
     1.500    -0.163     0.200
     5.195   -15.445     0.200
     0.328     0.972     0.200
     0.740     2.497     0.200
     1.027     2.805     0.200
     1.219     1.360     0.200
     2.276    -3.513     0.200
     2.416    -2.542     0.200
     0.291     1.281     0.200
     0.360     1.589     0.200
     2.376    -5.331     0.200
     0.284     1.462     0.200
     0.577     1.633     0.200
     2.373    -5.591     0.200
     2.394    -5.895     0.200
     1.149     1.967     0.200
     0.854     2.889     0.200
     2.523    -6.537     0.200
     1.220     1.841     0.200
     1.375     1.460     0.200
     1.785    -1.469     0.200
     2.296    -3.060     0.200
     2.652    -6.258     0.200
     1.131     1.054     0.200
     1.343     1.087     0.200
     2.278    -4.727     0.200
     1.373    -0.490     0.200
     1.144     1.176     0.200
     1.323     0.757     0.200
     1.557    -0.802     0.200
     2.302    -4.442     0.200
     2.371    -4.913     0.200
     2.511    -6.587     0.200
     1.235    -1.502     0.200
     2.405    -4.338     0.200
     0.291     1.138     0.200
     1.008     1.218     0.200
     1.257    -0.279     0.200
     2.447    -4.057     0.200
     0.472     0.819     0.200
     2.288    -4.888     0.200
     0.435     2.142     0.200
     0.456     0.903     0.200
     1.170     0.536     0.200
     2.303    -5.438     0.200
     2.303    -3.375     0.200
     2.792    -7.191     0.200
     0.466     0.973     0.200
     1.162     0.721     0.200
     2.298    -4.242     0.200
     2.536    -4.749     0.200
     1.145     0.031     0.200
     2.286    -3.449     0.200
     2.286    -2.488     0.200
     2.800    -4.767     0.200
     0.503     0.164     0.200
     1.144     1.449     0.200
     1.187     2.720     0.200
     0.655     2.416     0.200
     1.214     2.171     0.200
     1.470     0.961     0.200
     1.589     0.717     0.200
     2.295    -2.537     0.200
     2.326    -2.806     0.200
     0.643     3.048     0.200
     1.203     0.165     0.200
     2.155    -5.041     0.200
     2.792    -7.260     0.200
     0.388     0.504     0.200
     0.648     1.821     0.200
     0.880     1.185     0.200
     0.943     0.854     0.200
     1.021    -0.055     0.200
     1.231     0.704     0.200
     1.235     0.213     0.200
     1.232     1.825     0.200
     1.418    -0.381     0.200
     1.626    -0.628     0.200
     1.807    -2.429     0.200
     2.346    -4.576     0.200
     2.238    -3.592     0.200
     3.140    -8.944     0.200
     0.216     1.907     0.200
     0.216     1.466     0.200
     0.447     1.894     0.200
     0.481     3.018     0.200
     0.758     1.374     0.200
     0.795     1.817     0.200
     0.968    -0.103     0.200
     1.066     1.540     0.200
     1.149    -0.068     0.200
     1.176    -0.119     0.200
     1.352    -1.279     0.200
     1.389    -0.579     0.200
     1.584    -2.212     0.200
     2.131    -0.685     0.200
     2.534    -7.008     0.200
     0.374     1.806     0.200
     0.770     1.342     0.200
     0.942     1.817     0.200
     1.185     1.194     0.200
     1.245     1.583     0.200
     1.614    -0.687     0.200
     1.771    -0.821     0.200
     2.255    -2.606     0.200
     2.356    -3.760     0.200
     0.312     1.558     0.200
     0.312     1.728     0.200
     0.534     1.190     0.200
     0.831     0.291     0.200
     0.850     2.029     0.200
     0.995     0.080     0.200
     1.245    -0.369     0.200
     1.245    -0.530     0.200
     1.320    -0.548     0.200
     1.299     0.094     0.200
     2.417    -5.931     0.200
     2.417    -6.721     0.200
     2.564    -5.927     0.200
     4.838   -12.599     0.200
     5.236   -13.504     0.200
     0.250     0.968     0.200
     0.356     0.980     0.200
     0.692     3.019     0.200
     0.787     1.141     0.200
     0.787     0.860     0.200
     0.888     2.045     0.200
     0.957     1.212     0.200
     0.957     1.102     0.200
     1.202     0.240     0.200
     1.202     0.440     0.200
     1.260     1.108     0.200
     1.260     1.249     0.200
     1.570    -1.064     0.200
     2.374    -5.272     0.200
     0.567    -0.218     0.200
     0.549     0.879     0.200
     0.549     0.770     0.200
     0.605     1.827     0.200
     0.605     1.696     0.200
     0.829     2.035     0.200
     0.996     2.219     0.200
     1.029     1.554     0.200
     1.078     1.693     0.200
     1.122     1.879     0.200
     1.379     0.793     0.200
     1.369     1.075     0.200
     1.620    -0.359     0.200
     1.757    -0.728     0.200
     0.291     0.036     0.200
     0.351     0.786     0.200
     0.351     1.096     0.200
     0.592     2.881     0.200
     0.734     2.813     0.200
     0.863     2.861     0.200
     0.899    -0.164     0.200
     0.937     1.388     0.200
     1.066     3.019     0.200
     1.198     1.519     0.200
     1.243     2.086     0.200
     1.515     0.864     0.200
     1.547     1.062     0.200
     1.562     0.036     0.200
     1.592     1.527     0.200
     1.670     0.032     0.200
     1.660     0.080     0.200
     1.690     0.224     0.200
     1.690     1.045     0.200
     1.816    -0.011     0.200
     2.379    -2.934     0.200
     2.385    -1.345     0.200
     0.772     1.787     0.200
     0.982     0.931     0.200
     0.997     1.098     0.200
     1.070     0.605     0.200
     1.198     1.208     0.200
     1.267     1.279     0.200
     1.284     0.389     0.200
     1.292     0.352     0.200
     2.325    -4.743     0.200
     0.237     1.241     0.200
     0.325     1.490     0.200
     0.576     3.190     0.200
     0.537     0.625     0.200
     0.680     3.069     0.200
     0.791     1.812     0.200
     0.818     0.910     0.200
     0.860     1.976     0.200
     0.983     1.135     0.200
     1.065     0.758     0.200
     1.156     1.392     0.200
     1.182    -0.738     0.200
     1.182    -0.527     0.200
     1.232     0.131     0.200
     1.232    -0.088     0.200
     1.288     0.409     0.200
     1.534    -0.729     0.200
     1.583    -1.272     0.200
     2.310    -5.223     0.200
     2.405    -5.467     0.200
     0.195     0.454     0.200
     0.412     1.321     0.200
     0.412     1.454     0.200
     0.765     1.353     0.200
     0.765     1.883     0.200
     0.909     1.673     0.200
     0.970     1.918     0.200
     0.982     1.724     0.200
     0.982     1.935     0.200
     1.190     0.911     0.200
     1.190     1.098     0.200
     1.258     1.095     0.200
     1.266     1.631     0.200
     1.278     2.033     0.200
     1.389     1.547     0.200
     1.303     0.770     0.200
     1.655     0.091     0.200
     2.326    -2.998     0.200
     2.326    -3.664     0.200
     2.691    -6.351     0.200
     0.379     0.645     0.200
     1.058     2.133     0.200
     1.254     2.116     0.200
     1.253     2.162     0.200
     1.303     1.450     0.200
     1.352     2.993     0.200
     2.367    -3.681     0.200
     0.432    -0.605     0.200
     0.759     1.253     0.200
     0.938     1.323     0.200
     0.997     0.863     0.200
     0.988     1.358     0.200
     1.081     0.919     0.200
     1.185     1.958     0.200
     1.204     0.648     0.200
     1.295     0.726     0.200
     1.282     1.817     0.200
     1.403     1.942     0.200
     1.685    -0.105     0.200
     1.735     0.018     0.200
     2.310    -1.663     0.200
     0.161     0.526     0.200
     0.405     0.666     0.200
     0.421     1.265     0.200
     0.421     1.263     0.200
     0.685     3.065     0.200
     0.786     1.982     0.200
     0.786     1.691     0.200
     0.935     1.834     0.200
     1.018     1.527     0.200
     1.213     0.492     0.200
     1.213     1.636     0.200
     1.228     0.576     0.200
     1.271     1.295     0.200
     1.312     0.972     0.200
     1.433     0.775     0.200
     1.687    -0.178     0.200
     0.425     0.606     0.200
     0.677     0.521     0.200
     0.721     1.541     0.200
     0.881     0.828     0.200
     0.910     1.437     0.200
     1.139     0.572     0.200
     1.256     0.754     0.200
     1.210     1.685     0.200
     1.613    -0.075     0.200
     1.658     0.055     0.200
     1.652     0.850     0.200
     1.724    -0.897     0.200
     2.304    -3.010     0.200
     0.218     1.144     0.200
     0.372     1.144     0.200
     0.372     1.382     0.200
     0.494     1.235     0.200
     0.494     0.551     0.200
     0.501     1.472     0.200
     0.501     0.218     0.200
     0.629     3.218     0.200
     0.658     2.982     0.200
     0.693     0.720     0.200
     0.781     0.981     0.200
     0.852     0.194     0.200
     0.987     1.143     0.200
     0.970     0.751     0.200
     0.970     1.037     0.200
     1.048     0.064     0.200
     1.124     0.926     0.200
     1.201    -0.593     0.200
     1.204     0.819     0.200
     1.211     1.371     0.200
     1.200     0.635     0.200
     1.200     0.409     0.200
     1.243    -0.253     0.200
     1.271     0.690     0.200
     1.384    -0.834     0.200
     1.594    -0.647     0.200
     1.681    -1.612     0.200
     1.887    -2.868     0.200
     2.264    -4.177     0.200
     2.264    -3.708     0.200
     2.634    -6.247     0.200
     2.871    -7.810     0.200
     0.319     1.171     0.200
     0.546     0.672     0.200
     0.546     0.547     0.200
     0.568     0.232     0.200
     0.568     0.618     0.200
     0.607     1.518     0.200
     0.737     0.569     0.200
     0.737     0.341     0.200
     0.830     1.748     0.200
     1.031     0.807     0.200
     1.099     2.144     0.200
     1.122     0.721     0.200
     1.122     1.257     0.200
     1.624    -0.313     0.200
     1.624     0.145     0.200
     1.612     0.989     0.200
     1.612     0.785     0.200
     1.631     0.365     0.200
     1.673     0.506     0.200
     1.712    -0.988     0.200
     1.753    -0.864     0.200
     0.373     1.233     0.200
     0.373     1.159     0.200
     0.492     1.157     0.200
     0.520     0.847     0.200
     0.675     0.481     0.200
     0.675     0.317     0.200
     0.775     1.323     0.200
     0.957     1.021     0.200
     0.957     1.173     0.200
     1.060    -0.047     0.200
     1.111     0.552     0.200
     1.111     0.290     0.200
     1.189     0.561     0.200
     1.192     0.394     0.200
     1.259     0.881     0.200
     1.288     0.235     0.200
     1.288     0.020     0.200
     2.255    -4.695     0.200
     2.255    -4.406     0.200
     0.214     2.019     0.200
     0.357     1.595     0.200
     0.357     1.857     0.200
     0.509     0.364     0.200
     0.502     1.306     0.200
     0.502     0.955     0.200
     0.502     1.099     0.200
     0.688    -0.138     0.200
     0.688    -0.552     0.200
     0.795     0.363     0.200
     0.980     0.155     0.200
     0.980    -0.158     0.200
     0.977    -0.834     0.200
     1.060    -0.424     0.200
     1.060    -0.291     0.200
     1.130    -0.626     0.200
     1.130    -0.341     0.200
     1.191    -0.795     0.200
     1.194     0.390     0.200
     1.214    -0.602     0.200
     1.214    -0.309     0.200
     1.282     0.071     0.200
     1.299    -0.379     0.200
     1.299    -0.547     0.200
     1.374    -1.040     0.200
     2.096    -2.462     0.200
     2.277    -5.440     0.200
     2.277    -5.616     0.200
     2.349    -5.925     0.200
     0.384     1.034     0.200
     0.384     1.011     0.200
     0.490     0.572     0.200
     0.588    -0.071     0.200
     0.588     0.312     0.200
     0.611     0.660     0.200
     0.757     1.000     0.200
     0.911     1.570     0.200
     0.911     1.719     0.200
     1.043     0.970     0.200
     1.105     0.253     0.200
     1.134    -0.112     0.200
     1.136    -0.024     0.200
     1.166     0.978     0.200
     1.166     1.369     0.200
     1.216     1.823     0.200
     1.303     0.914     0.200
     1.541    -0.973     0.200
     1.586    -1.255     0.200
     1.713    -0.531     0.200
     2.224    -3.452     0.200
     2.264    -4.382     0.200
     2.686    -6.952     0.200
     0.291     1.124     0.200
     0.367     1.295     0.200
     0.506     0.643     0.200
     0.583     0.387     0.200
     0.610     0.416     0.200
     0.734     2.856     0.200
     0.800     1.058     0.200
     0.926     0.882     0.200
     1.050     0.352     0.200
     1.114    -0.335     0.200
     1.183    -0.171     0.200
     1.300     1.100     0.200
     1.231     0.982     0.200
     1.317     0.214     0.200
     1.531    -1.325     0.200
     1.577    -1.827     0.200
     1.705    -1.330     0.200
     2.241    -3.894     0.200
     2.274    -4.732     0.200
     0.456     0.326     0.200
     0.456     0.064     0.200
     0.427     1.336     0.200
     0.427     1.366     0.200
     0.452     2.047     0.200
     0.688     3.385     0.200
     0.758    -0.093     0.200
     0.921     1.935     0.200
     0.976     0.150     0.200
     0.976     0.313     0.200
     0.971     1.651     0.200
     0.971     2.180     0.200
     1.058     2.066     0.200
     1.176     1.766     0.200
     1.225     1.171     0.200
     1.273     1.578     0.200
     1.272     1.031     0.200
     1.275     1.314     0.200
     1.314     0.571     0.200
     1.382     2.017     0.200
     1.382     1.890     0.200
     1.677    -0.440     0.200
     1.677    -0.151     0.200
     1.666     0.149     0.200
     1.715    -0.108     0.200
     2.373    -1.786     0.200
     2.373    -2.476     0.200
     0.198     2.208     0.200
     0.377     0.867     0.200
     0.377     1.394     0.200
     0.377     1.675     0.200
     0.493     0.682     0.200
     0.477     0.434     0.200
     0.477     1.303     0.200
     0.637     2.197     0.200
     0.718    -0.190     0.200
     0.718    -0.350     0.200
     0.785     0.441     0.200
     0.785     0.662     0.200
     0.868     1.291     0.200
     0.931     1.304     0.200
     0.985     0.241     0.200
     0.985     0.096     0.200
     1.009    -1.350     0.200
     1.029    -0.156     0.200
     1.029    -0.326     0.200
     1.207    -0.179     0.200
     1.207    -0.857     0.200
     1.224    -1.115     0.200
     1.221     0.605     0.200
     1.221     0.187     0.200
     1.262    -0.100     0.200
     1.284     0.222     0.200
     1.276    -0.121     0.200
     1.276    -0.312     0.200
     2.129    -3.019     0.200
     2.272    -5.360     0.200
     2.366    -4.133     0.200
     2.503    -6.030     0.200
     2.772    -9.165     0.200
     2.891    -9.674     0.200
     2.851    -9.789     0.200
     3.051   -10.852     0.200
     0.181     0.694     0.200
     0.442     1.028     0.200
     0.403     1.000     0.200
     0.403     1.570     0.200
     0.403     1.851     0.200
     0.479     1.140     0.200
     0.666     3.339     0.200
     0.778     1.429     0.200
     0.778     0.902     0.200
     0.760     0.197     0.200
     0.906     0.851     0.200
     0.989    -0.034     0.200
     0.989    -0.541     0.200
     0.989    -0.702     0.200
     0.965     0.979     0.200
     0.965     1.951     0.200
     0.996     1.029     0.200
     1.052     1.219     0.200
     1.052     1.040     0.200
     1.203     0.182     0.200
     1.203     0.448     0.200
     1.172     1.290     0.200
     1.248     0.920     0.200
     1.248     0.818     0.200
     1.248     0.639     0.200
     1.251     1.776     0.200
     1.292     0.385     0.200
     1.266     0.465     0.200
     1.269     0.870     0.200
     1.302     1.168     0.200
     1.368     1.198     0.200
     1.449     0.705     0.200
     1.654    -0.573     0.200
     1.728    -1.165     0.200
     1.744    -1.165     0.200
     1.796    -1.561     0.200
     2.270    -3.345     0.200
     2.336    -3.795     0.200
     2.392    -4.024     0.200
     2.392    -3.825     0.200
     0.212     1.665     0.200
     0.381     1.006     0.200
     0.381     1.208     0.200
     0.381     1.568     0.200
     0.491     0.811     0.200
     0.491     0.573     0.200
     0.487     0.970     0.200
     0.639     1.461     0.200
     0.650     2.906     0.200
     0.706    -0.004     0.200
     0.706     0.101     0.200
     0.777     1.037     0.200
     0.930     0.939     0.200
     0.972     0.549     0.200
     1.001    -0.869     0.200
     1.035    -0.300     0.200
     1.141     0.031     0.200
     1.141     0.241     0.200
     1.141     0.138     0.200
     1.197     0.202     0.200
     1.215    -1.144     0.200
     1.222     0.667     0.200
     1.222     0.279     0.200
     1.217     0.203     0.200
     1.256     0.410     0.200
     1.274    -0.053     0.200
     1.274    -0.393     0.200
     1.274    -0.160     0.200
     1.272     0.375     0.200
     2.121    -1.042     0.200
     2.223    -1.253     0.200
     2.262    -5.206     0.200
     2.350    -6.155     0.200
     2.350    -5.901     0.200
     2.646    -8.184     0.200
     2.759    -8.696     0.200
     2.759    -8.953     0.200
     2.884    -8.898     0.200
     3.037    -9.789     0.200
     0.449     1.292     0.200
     0.485     0.547     0.200
     0.485     0.826     0.200
     0.491     0.617     0.200
     0.516     0.873     0.200
     0.516     0.763     0.200
     0.677     1.022     0.200
     0.717     1.120     0.200
     0.717     1.319     0.200
     0.802     0.348     0.200
     0.781     1.004     0.200
     0.851     1.907     0.200
     0.851     1.794     0.200
     0.851     2.019     0.200
     1.011     0.485     0.200
     1.014     0.345     0.200
     1.091     0.638     0.200
     1.230     0.106     0.200
     1.230     0.235     0.200
     1.342     0.271     0.200
     1.406     1.724     0.200
     1.406     1.056     0.200
     1.452    -0.906     0.200
     1.484     0.613     0.200
     1.602    -0.114     0.200
     1.587     0.786     0.200
     1.587     0.628     0.200
     1.931    -1.035     0.200
     2.353    -1.442     0.200
     2.528    -5.164     0.200
     3.639   -10.570     0.200
     0.370     1.102     0.200
     0.370     1.341     0.200
     0.499     0.497     0.200
     0.499     1.085     0.200
     0.567    -0.023     0.200
     0.567     0.112     0.200
     0.616     1.587     0.200
     0.770     0.912     0.200
     0.814     0.478     0.200
     0.932     1.154     0.200
     0.932     0.955     0.200
     1.066     0.487     0.200
     1.097    -0.219     0.200
     1.097    -1.052     0.200
     1.145    -1.162     0.200
     1.147     0.551     0.200
     1.192     1.366     0.200
     1.192     0.712     0.200
     1.182     0.808     0.200
     1.182     0.703     0.200
     1.197    -0.769     0.200
     1.311     1.308     0.200
     1.311     0.689     0.200
     1.236     0.181     0.200
     1.306     0.455     0.200
     1.306    -0.301     0.200
     1.547    -1.307     0.200
     2.242    -4.188     0.200
     2.272    -1.424     0.200
     2.287    -5.087     0.200
     2.287    -5.234     0.200
     2.362    -5.162     0.200
     2.362    -5.412     0.200
     2.708    -7.942     0.200
     0.269     0.539     0.200
     0.269     0.445     0.200
     0.512     1.165     0.200
     0.577    -0.734     0.200
     0.577    -0.382     0.200
     0.603     1.035     0.200
     0.603     0.813     0.200
     0.866     0.990     0.200
     0.871     1.878     0.200
     1.011     1.220     0.200
     1.011     1.880     0.200
     1.080     1.084     0.200
     1.082     0.663     0.200
     1.076     1.294     0.200
     1.076     1.606     0.200
     1.112     0.591     0.200
     1.178     0.236     0.200
     1.366     1.869     0.200
     1.366     2.057     0.200
     1.279     1.791     0.200
     1.279     0.685     0.200
     1.318     1.671     0.200
     1.408     1.260     0.200
     1.408     0.881     0.200
     1.464    -0.982     0.200
     1.647     0.628     0.200
     2.366     0.324     0.200
     2.335    -2.990     0.200
     2.335    -1.904     0.200
     2.327    -2.428     0.200
     2.327    -1.471     0.200
     2.465    -3.611     0.200
     2.465    -2.583     0.200
     2.502    -4.393     0.200
     2.692    -4.973     0.200
     3.011    -7.466     0.200
     3.011    -6.751     0.200
     3.281    -8.767     0.200
     0.446    -0.246     0.200
     0.438     0.687     0.200
     0.438     1.281     0.200
     0.446     1.520     0.200
     0.747     1.968     0.200
     0.936     1.593     0.200
     0.961     0.460     0.200
     0.974     1.905     0.200
     0.974     1.257     0.200
     1.173     1.311     0.200
     1.214     1.319     0.200
     1.214     0.866     0.200
     1.190     1.496     0.200
     1.288     1.012     0.200
     1.290     1.282     0.200
     1.388     1.790     0.200
     1.330     0.440     0.200
     1.681     0.039     0.200
     1.749     0.135     0.200
     1.749     0.330     0.200
     2.302    -3.742     0.200
     2.302    -2.960     0.200
     2.380    -2.749     0.200
     0.265     1.431     0.200
     0.471     2.929     0.200
     0.495     1.027     0.200
     0.589     1.280     0.200
     0.589     1.647     0.200
     0.589     1.061     0.200
     0.766     0.672     0.200
     0.766     0.117     0.200
     0.766    -0.149     0.200
     0.808     0.216     0.200
     0.849     2.199     0.200
     0.849     1.762     0.200
     1.116     0.570     0.200
     1.123     0.573     0.200
     1.123     0.776     0.200
     1.132     0.278     0.200
     1.132     0.168     0.200
     1.237     0.388     0.200
     1.237     0.153     0.200
     1.237     0.005     0.200
     1.305    -0.413     0.200
     1.305    -0.835     0.200
     1.420    -0.221     0.200
     1.431    -0.125     0.200
     1.431     0.141     0.200
     1.483    -1.251     0.200
     1.483    -1.767     0.200
     1.539    -1.042     0.200
     2.418    -3.867     0.200
     0.497     0.908     0.200
     0.497     1.252     0.200
     0.534     2.006     0.200
     0.601     0.788     0.200
     0.601     0.585     0.200
     0.681     0.529     0.200
     0.842     1.661     0.200
     0.939     1.343     0.200
     0.939     1.749     0.200
     0.968     1.420     0.200
     0.968     1.655     0.200
     1.004    -0.348     0.200
     1.090     2.271     0.200
     1.272     2.020     0.200
     1.239    -0.307     0.200
     1.234     1.172     0.200
     1.423    -0.613     0.200
     1.498     1.648     0.200
     2.462    -4.029     0.200
     2.450    -1.644     0.200
     2.450    -2.355     0.200
     0.355     1.185     0.200
     0.371     1.614     0.200
     0.371     1.532     0.200
     0.539     0.455     0.200
     0.539     0.865     0.200
     0.533     0.523     0.200
     0.652     0.116     0.200
     0.780     1.328     0.200
     0.780     1.008     0.200
     0.797     2.800     0.200
     0.847     1.534     0.200
     0.899     1.332     0.200
     0.983     0.994     0.200
     0.983     0.705     0.200
     0.983     0.876     0.200
     1.065    -0.447     0.200
     1.253     0.884     0.200
     1.253     1.654     0.200
     1.156     0.855     0.200
     1.206     0.885     0.200
     1.353     0.272     0.200
     1.643    -1.543     0.200
     2.219    -3.733     0.200
     2.229    -3.546     0.200
     2.336    -5.550     0.200
     2.385    -4.533     0.200
     2.385    -5.126     0.200
     2.419    -5.589     0.200
     2.531    -5.809     0.200
     3.249    -9.803     0.200
     0.134     2.164     0.200
     0.310     0.404     0.200
     0.459     0.803     0.200
     0.516     0.973     0.200
     0.516     1.102     0.200
     0.895    -0.005     0.200
     0.897    -0.225     0.200
     1.091     0.865     0.200
     1.220     0.421     0.200
     1.259     0.390     0.200
     1.307     0.634     0.200
     1.326    -0.138     0.200
     1.390    -0.090     0.200
     2.284    -4.845     0.200
     2.326    -5.136     0.200
     2.338    -5.223     0.200
     2.514    -6.722     0.200
     2.774    -8.863     0.200
     2.999    -9.889     0.200
     0.392     1.093     0.200
     0.449     0.102     0.200
     0.487     1.338     0.200
     0.749     0.749     0.200
     0.997     1.345     0.200
     1.183     1.223     0.200
     1.209     1.164     0.200
     1.259     0.834     0.200
     1.256     1.134     0.200
     1.401     1.706     0.200
     1.705    -0.526     0.200
     2.346    -4.405     0.200
     2.675    -5.978     0.200
     2.919    -7.324     0.200
     0.311     0.316     0.200
     0.311     0.423     0.200
     0.463     1.181     0.200
     0.463     1.355     0.200
     0.512     1.357     0.200
     0.726     1.412     0.200
     0.826     0.868     0.200
     0.894    -0.172     0.200
     0.896     0.398     0.200
     1.001     1.105     0.200
     1.042     1.025     0.200
     1.089     1.123     0.200
     1.176    -0.367     0.200
     1.216     0.365     0.200
     1.256     0.602     0.200
     1.310     0.502     0.200
     1.376     1.129     0.200
     1.407     0.436     0.200
     1.608    -1.747     0.200
     1.608    -1.348     0.200
     1.761    -1.889     0.200
     2.286    -2.947     0.200
     2.323    -4.847     0.200
     2.334    -4.983     0.200
     0.320     0.394     0.200
     0.461     0.832     0.200
     0.506     1.308     0.200
     0.887     0.749     0.200
     0.897    -0.589     0.200
     1.080     1.189     0.200
     1.214     0.567     0.200
     1.249     0.460     0.200
     1.316    -0.050     0.200
     1.611    -1.279     0.200
     2.280    -2.461     0.200
     0.315     0.677     0.200
     0.315     0.504     0.200
     0.460     1.721     0.200
     0.460     1.469     0.200
     0.511     1.403     0.200
     0.723     2.711     0.200
     0.723     1.680     0.200
     0.824     1.243     0.200
     0.824     0.993     0.200
     0.891     0.527     0.200
     0.891     0.719     0.200
     0.881     2.325     0.200
     0.897    -0.381     0.200
     0.897    -0.569     0.200
     0.997     0.323     0.200
     1.039     0.947     0.200
     1.086     1.206     0.200
     1.171    -0.146     0.200
     1.217     0.399     0.200
     1.217     0.657     0.200
     1.254     0.539     0.200
     1.254     0.895     0.200
     1.321    -0.296     0.200
     1.321     0.294     0.200
     1.308     0.685     0.200
     1.374     0.162     0.200
     1.385    -1.046     0.200
     1.387     0.223     0.200
     1.611    -1.699     0.200
     2.214    -3.279     0.200
     2.282    -4.232     0.200
     2.282    -4.800     0.200
     2.321    -5.281     0.200
     2.335    -4.440     0.200
     2.335    -5.442     0.200
     2.442    -1.967     0.200
     2.509    -5.738     0.200
     3.037    -9.466     0.200
     3.229    -5.547     0.200
     0.305     0.294     0.200
     0.353     0.464     0.200
     0.516     0.897     0.200
     0.516     0.686     0.200
     0.520     2.775     0.200
     0.607     0.301     0.200
     0.701     2.822     0.200
     0.773     2.425     0.200
     0.992     1.238     0.200
     1.081     2.696     0.200
     1.081     2.862     0.200
     1.296     1.775     0.200
     1.231    -0.077     0.200
     1.250     0.665     0.200
     1.426    -0.299     0.200
     2.249    -0.184     0.200
     0.403     1.080     0.200
     0.403     1.082     0.200
     0.444    -0.437     0.200
     0.479     1.298     0.200
     0.665     2.402     0.200
     0.758     0.806     0.200
     0.964     1.194     0.200
     0.990    -0.146     0.200
     0.994     1.361     0.200
     0.994     1.655     0.200
     1.050     0.289     0.200
     1.188     0.940     0.200
     1.250     0.098     0.200
     1.203     0.985     0.200
     1.249     0.224     0.200
     1.249     0.627     0.200
     1.264     0.116     0.200
     1.267     0.239     0.200
     1.300    -1.691     0.200
     1.281     1.218     0.200
     1.401     1.020     0.200
     1.652    -1.759     0.200
     2.336    -4.907     0.200
     2.336    -4.616     0.200
     2.930    -8.381     0.200
     0.353     0.820     0.200
     0.605     0.541     0.200
     0.849     0.905     0.200
     0.913     1.784     0.200
     1.002     0.204     0.200
     1.144     1.858     0.200
     1.330    -0.943     0.200
     1.330    -0.320     0.200
     1.341     0.110     0.200
     1.341     0.936     0.200
     1.440     1.227     0.200
     1.718    -0.568     0.200
     1.930    -2.238     0.200
     2.408    -5.396     0.200
     2.443    -5.623     0.200
     0.265     0.723     0.200
     0.342     0.240     0.200
     0.422     1.486     0.200
     0.422     1.184     0.200
     0.588     1.168     0.200
     0.588     0.848     0.200
     0.588     0.337     0.200
     0.736     1.432     0.200
     0.776    -0.430     0.200
     0.776     0.150     0.200
     0.852     2.456     0.200
     0.961     0.251     0.200
     0.961     0.133     0.200
     1.038     1.517     0.200
     1.038     0.876     0.200
     1.089     0.698     0.200
     1.089     0.519     0.200
     1.089     1.237     0.200
     1.116     0.440     0.200
     1.116     0.040     0.200
     1.166     0.702     0.200
     1.166     1.011     0.200
     1.166     1.166     0.200
     1.165    -0.160     0.200
     1.267     0.034     0.200
     1.267    -0.086     0.200
     1.313     0.425     0.200
     1.351     0.211     0.200
     1.373     1.075     0.200
     1.398     0.426     0.200
     1.437    -0.492     0.200
     1.437     0.600     0.200
     1.481    -0.312     0.200
     1.517     0.149     0.200
     1.664    -1.486     0.200
     2.213    -3.633     0.200
     2.213    -3.778     0.200
     2.229    -4.186     0.200
     2.338    -4.432     0.200
     2.387    -5.284     0.200
     2.387    -3.956     0.200
     2.495    -5.148     0.200
     2.495    -4.960     0.200
     2.512    -5.532     0.200
     2.896    -8.189     0.200
     3.178    -9.951     0.200
     3.199    -9.820     0.200
     0.302     0.457     0.200
     0.346     1.263     0.200
     0.346    -0.071     0.200
     0.534     0.006     0.200
     0.534     0.824     0.200
     0.586     1.302     0.200
     0.600    -0.214     0.200
     0.796     1.762     0.200
     0.850     2.091     0.200
     0.936     1.307     0.200
     1.036     1.242     0.200
     1.100     0.058     0.200
     1.154     1.186     0.200
     1.145    -0.467     0.200
     1.301     2.159     0.200
     1.202     1.430     0.200
     1.347    -0.741     0.200
     1.779    -0.802     0.200
     2.258    -2.332     0.200
     2.394    -3.426     0.200
     0.352     0.450     0.200
     0.439     1.597     0.200
     0.439     1.991     0.200
     0.525     0.637     0.200
     0.525     0.531     0.200
     0.753     1.236     0.200
     0.842     0.166     0.200
     0.842     0.838     0.200
     0.789     2.443     0.200
     0.903    -0.051     0.200
     1.030     1.356     0.200
     1.030     1.493     0.200
     1.050     1.298     0.200
     1.142    -0.230     0.200
     1.142     1.423     0.200
     1.100     1.376     0.200
     1.183     0.844     0.200
     1.375     0.310     0.200
     1.420     0.323     0.200
     1.450     0.529     0.200
     1.552    -1.147     0.200
     2.321    -5.088     0.200
     2.321    -1.963     0.200
     2.471    -3.024     0.200
     0.463     0.427     0.200
     0.463     0.497     0.200
     0.487     1.534     0.200
     0.487     1.706     0.200
     0.498     0.979     0.200
     0.498     0.869     0.200
     0.738     0.786     0.200
     0.714     1.633     0.200
     0.831     0.305     0.200
     0.802     1.286     0.200
     0.893     2.200     0.200
     0.893     2.380     0.200
     1.042     0.213     0.200
     1.045     0.481     0.200
     1.150     2.431     0.200
     1.098     0.899     0.200
     1.098     0.735     0.200
     1.212     2.870     0.200
     1.212     2.604     0.200
     1.196    -0.188     0.200
     1.476    -1.484     0.200
     1.448     1.493     0.200
     1.525     1.770     0.200
     1.630    -0.186     0.200
     1.607     1.678     0.200
     1.781    -1.113     0.200
     2.326    -1.175     0.200
     2.326    -1.480     0.200
     2.547    -3.848     0.200
     0.418     1.649     0.200
     0.550     1.585     0.200
     0.550     1.690     0.200
     0.550     1.542     0.200
     0.733     1.539     0.200
     0.915     2.035     0.200
     0.915    -0.844     0.200
     0.915    -0.270     0.200
     1.018     1.824     0.200
     1.018     1.136     0.200
     1.072     1.148     0.200
     1.116     1.029     0.200
     1.116     0.650     0.200
     1.163     0.540     0.200
     1.163     1.353     0.200
     1.163     1.149     0.200
     1.310     1.465     0.200
     1.298     1.537     0.200
     1.400     0.796     0.200
     1.437     0.714     0.200
     1.472    -0.753     0.200
     1.528     0.074     0.200
     1.879    -1.412     0.200
     2.340    -1.945     0.200
     2.340    -1.508     0.200
     2.385    -4.268     0.200
     2.559    -5.665     0.200
     3.197    -8.699     0.200
     0.265     1.122     0.200
     0.343     0.218     0.200
     0.524     0.562     0.200
     0.643     0.340     0.200
     0.643     0.450     0.200
     0.772     2.871     0.200
     0.738     2.682     0.200
     0.788     0.705     0.200
     0.788     1.165     0.200
     0.894     1.724     0.200
     1.044     2.378     0.200
     1.002     0.987     0.200
     1.041    -0.673     0.200
     1.041     0.327     0.200
     0.999     1.741     0.200
     1.014     1.741     0.200
     1.172     1.968     0.200
     1.291     0.199     0.200
     1.308     1.108     0.200
     1.392    -0.693     0.200
     1.441    -0.637     0.200
     1.572    -1.503     0.200
     1.590    -1.914     0.200
     2.279    -0.017     0.200
     0.350     1.372     0.200
     0.350     1.278     0.200
     0.516     0.216     0.200
     0.644     0.121     0.200
     0.644     0.309     0.200
     0.694     2.922     0.200
     0.792     1.156     0.200
     0.881     1.828     0.200
     0.959     0.712     0.200
     1.089     0.004     0.200
     1.089     0.184     0.200
     1.151    -1.369     0.200
     1.154    -0.028     0.200
     1.206    -0.105     0.200
     1.263     0.445     0.200
     1.334    -0.678     0.200
     1.843    -3.156     0.200
     2.267    -4.859     0.200
     2.267    -4.710     0.200
     2.277    -5.290     0.200
     2.380    -6.011     0.200
     2.380    -5.573     0.200
     2.436    -5.307     0.200
     2.436    -4.995     0.200
     2.590    -6.512     0.200
     0.366     1.184     0.200
     0.366     1.004     0.200
     0.501     0.802     0.200
     0.634     0.291     0.200
     0.775     1.415     0.200
     0.890     2.195     0.200
     0.939     1.418     0.200
     0.939     1.605     0.200
     0.934     1.473     0.200
     1.073     0.806     0.200
     1.095    -0.251     0.200
     1.095    -0.415     0.200
     1.188     0.604     0.200
     1.184     1.366     0.200
     1.199    -0.308     0.200
     1.307     0.329     0.200
     1.332     0.340     0.200
     1.703    -0.909     0.200
     2.248    -4.045     0.200
     2.271    -3.817     0.200
     2.295    -3.374     0.200
     2.365    -4.221     0.200
     2.596    -6.357     0.200
     2.824    -7.851     0.200
     0.318     1.014     0.200
     0.318     1.749     0.200
     0.467     1.931     0.200
     0.524     1.428     0.200
     0.524     1.186     0.200
     0.782     1.469     0.200
     0.787     1.819     0.200
     0.787     2.288     0.200
     0.927     0.626     0.200
     0.927    -0.163     0.200
     1.154    -0.948     0.200
     1.154    -0.222     0.200
     1.212     0.095     0.200
     1.220    -0.170     0.200
     1.461    -1.990     0.200
     2.002    -6.501     0.200
     0.266     0.645     0.200
     0.593     0.735     0.200
     0.583     2.029     0.200
     0.662     1.187     0.200
     0.830     1.049     0.200
     0.882     1.771     0.200
     0.909     1.883     0.200
     0.917     2.228     0.200
     1.474     1.280     0.200
     1.499     1.582     0.200
     0.385     0.582     0.200
     0.482     1.432     0.200
     0.702     0.423     0.200
     0.771     0.536     0.200
     0.932    -0.076     0.200
     0.965     1.541     0.200
     0.999     1.343     0.200
     1.135     0.899     0.200
     1.191     0.922     0.200
     1.235     1.305     0.200
     1.656    -0.556     0.200
     1.687    -0.392     0.200
     1.787    -0.895     0.200
     2.256    -2.907     0.200
     2.345    -4.444     0.200
     0.376     1.080     0.200
     0.438     0.956     0.200
     0.497     1.029     0.200
     0.761     1.397     0.200
     0.751     1.029     0.200
     0.866    -0.160     0.200
     1.016     0.418     0.200
     1.014     0.614     0.200
     1.069     1.223     0.200
     1.166     0.446     0.200
     1.163     0.141     0.200
     1.181     0.529     0.200
     1.301     0.297     0.200
     1.347     0.458     0.200
     1.415    -0.271     0.200
     1.767    -2.090     0.200
     2.248    -4.419     0.200
     2.285    -4.869     0.200
     2.271    -4.286     0.200
     2.446    -6.341     0.200
     2.505    -7.002     0.200
     0.407     1.789     0.200
     0.407     1.320     0.200
     0.568     1.111     0.200
     0.693     0.046     0.200
     0.807    -0.218     0.200
     0.845     1.224     0.200
     0.842     1.216     0.200
     0.993    -2.041     0.200
     1.009     1.708     0.200
     1.209     0.220     0.200
     1.492    -2.008     0.200
     0.209     2.066     0.200
     0.465     2.085     0.200
     0.540     1.652     0.200
     0.640     3.121     0.200
     0.703     2.622     0.200
     0.759     2.070     0.200
     0.966     2.164     0.200
     1.048     0.486     0.200
     0.911     2.099     0.200
     0.911     1.970     0.200
     0.968     1.766     0.200
     0.968     2.043     0.200
     1.004     0.955     0.200
     1.060     0.836     0.200
     1.060     1.438     0.200
     1.201     0.755     0.200
     1.293     0.888     0.200
     1.293     0.478     0.200
     1.308     0.891     0.200
     1.308    -0.199     0.200
     1.457    -0.300     0.200
     0.413     2.182     0.200
     0.678     3.213     0.200
     0.917     1.510     0.200
     0.917     1.932     0.200
     0.977     1.628     0.200
     0.990     1.231     0.200
     1.061     1.304     0.200
     1.061     1.085     0.200
     1.263     0.509     0.200
     1.313     0.638     0.200
     1.313    -0.374     0.200
     1.282     1.143     0.200
     1.282     1.354     0.200
     1.282     0.393     0.200
     1.459    -0.108     0.200
     1.532    -0.080     0.200
     1.665    -0.819     0.200
     1.681    -1.520     0.200
     0.524     0.292     0.200
     0.680     0.423     0.200
     0.770     1.524     0.200
     0.784    -0.566     0.200
     0.784     0.353     0.200
     0.948     1.553     0.200
     0.973     1.327     0.200
     1.053     0.049     0.200
     1.150     1.541     0.200
     1.123     1.409     0.200
     1.182     0.238     0.200
     1.244     1.071     0.200
     1.244     0.760     0.200
     1.291     1.564     0.200
     1.402    -0.534     0.200
     1.500     1.427     0.200
     1.574    -1.792     0.200
     2.459    -5.239     0.200
     0.262     2.622     0.200
     0.800     1.725     0.200
     0.826     0.764     0.200
     0.826     0.655     0.200
     1.083    -0.269     0.200
     1.083    -0.133     0.200
     1.118     0.202     0.200
     1.119    -0.401     0.200
     1.119    -0.170     0.200
     1.261    -1.251     0.200
     1.261    -0.970     0.200
     1.256    -0.113     0.200
     1.491    -2.753     0.200
     1.689    -3.902     0.200
     0.813     0.127     0.200
     0.908     2.598     0.200
     0.997     0.376     0.200
     1.329    -0.657     0.200
     1.466     0.841     0.200
     1.660    -0.646     0.200
     1.686    -1.062     0.200
     1.793    -0.367     0.200
     0.709     0.115     0.200
     0.754     0.614     0.200
     0.754     0.844     0.200
     0.862     1.328     0.200
     0.945     2.318     0.200
     0.948     1.801     0.200
     0.948     2.081     0.200
     1.106     2.605     0.200
     1.249     1.053     0.200
     1.249     1.274     0.200
     1.254     1.583     0.200
     1.348     2.312     0.200
     1.375    -0.724     0.200
     1.419    -0.179     0.200
     1.419     1.357     0.200
     1.472     1.851     0.200
     1.538     0.252     0.200
     1.546     1.047     0.200
     2.472    -4.113     0.200
     2.647    -4.131     0.200
     3.745   -11.687     0.200
     0.592    -0.482     0.200
     0.803     1.673     0.200
     0.886     0.509     0.200
     0.946     2.202     0.200
     1.044     2.008     0.200
     1.151     0.585     0.200
     1.169     2.234     0.200
     1.210     1.457     0.200
     1.252     1.685     0.200
     1.501    -0.399     0.200
     1.547     0.081     0.200
     1.837    -1.308     0.200
     2.399    -4.073     0.200
     0.586    -0.933     0.200
     0.796     2.308     0.200
     0.897     0.576     0.200
     0.943     2.261     0.200
     1.050     1.672     0.200
     1.161     0.048     0.200
     1.171     1.753     0.200
     1.204     1.203     0.200
     1.511    -0.516     0.200
     1.558    -0.455     0.200
     1.593     1.093     0.200
     2.391    -3.710     0.200
     0.292     1.461     0.200
     0.292     1.711     0.200
     0.889     0.629     0.200
     1.149    -1.119     0.200
     1.149    -1.017     0.200
     1.139     0.212     0.200
     1.340    -0.082     0.200
     1.340     0.148     0.200
     1.319     0.089     0.200
     1.367    -0.535     0.200
     1.541    -1.761     0.200
     1.720    -2.505     0.200
     2.251    -3.249     0.200
     2.403    -6.743     0.200
     0.496     1.711     0.200
     0.914    -0.734     0.200
     0.914    -0.433     0.200
     0.998     0.163     0.200
     1.114     0.245     0.200
     1.114    -0.845     0.200
     1.208     0.011     0.200
     1.300    -1.074     0.200
     1.364    -1.264     0.200
     1.414    -1.675     0.200
     1.907    -3.454     0.200
     1.928    -4.002     0.200
     2.080    -4.773     0.200
     2.260    -6.840     0.200
     2.341    -7.380     0.200
     2.387    -7.280     0.200
     0.397     0.757     0.200
     0.399     0.579     0.200
     0.954     1.878     0.200
     1.028     0.228     0.200
     1.028     0.107     0.200
     1.162     1.800     0.200
     1.243     1.337     0.200
     1.257     2.633     0.200
     1.257     2.216     0.200
     1.426     0.899     0.200
     1.685     0.100     0.200
     1.684     0.343     0.200
     1.709    -0.317     0.200
     1.709    -0.719     0.200
     1.780    -2.655     0.200
     1.815    -0.123     0.200
     1.902    -2.513     0.200
     2.198    -3.655     0.200
     2.335    -3.730     0.200
     2.384    -3.820     0.200
     0.416     0.122     0.200
     0.416     0.552     0.200
     0.493     1.495     0.200
     0.495     0.985     0.200
     0.759     2.575     0.200
     0.977     1.377     0.200
     0.977     0.901     0.200
     1.061     0.429     0.200
     1.140     0.548     0.200
     1.140     0.071     0.200
     1.152     1.221     0.200
     1.152     0.822     0.200
     1.234     1.273     0.200
     1.234     0.602     0.200
     1.265     1.061     0.200
     1.302     0.994     0.200
     1.345     0.924     0.200
     1.345     0.556     0.200
     1.397    -0.483     0.200
     1.537    -0.322     0.200
     1.748    -2.230     0.200
     1.798    -2.504     0.200
     1.893    -3.156     0.200
     1.928    -3.619     0.200
     0.418     0.491     0.200
     0.418     0.623     0.200
     0.497     1.357     0.200
     0.500     0.809     0.200
     0.763     1.485     0.200
     0.763     2.431     0.200
     0.974     1.624     0.200
     0.974     1.108     0.200
     1.065     0.824     0.200
     1.065     0.715     0.200
     1.142     0.122     0.200
     1.142     0.614     0.200
     1.148     0.798     0.200
     1.234     1.246     0.200
     1.234     0.879     0.200
     1.262     1.514     0.200
     1.262     1.155     0.200
     1.300     1.365     0.200
     1.349    -0.164     0.200
     1.349     0.539     0.200
     1.400     0.356     0.200
     1.540    -0.164     0.200
     1.593    -1.015     0.200
     1.751    -2.272     0.200
     1.801    -2.149     0.200
     2.265    -2.701     0.200
     0.497     1.122     0.200
     0.964     1.462     0.200
     1.620    -1.227     0.200
     0.508     1.079     0.200
     0.753    -0.182     0.200
     0.860    -0.170     0.200
     1.259     1.863     0.200
     1.511    -0.986     0.200
     1.545    -1.237     0.200
     1.660    -1.447     0.200
     1.836    -0.777     0.200
     0.489     0.650     0.200
     0.944     1.554     0.200
     1.259     2.462     0.200
     1.312     2.172     0.200
     1.568    -2.187     0.200
     1.809    -1.395     0.200
     0.665    -0.079     0.200
     0.829    -0.350     0.200
     0.915     0.560     0.200
     1.153     2.473     0.200
     1.141     1.825     0.200
     1.327    -1.215     0.200
     1.354    -0.800     0.200
     1.464    -0.649     0.200
     1.730     0.590     0.200
     1.788     0.071     0.200
     0.543     0.614     0.200
     0.736     0.095     0.200
     0.917     0.080     0.200
     0.995     1.282     0.200
     0.984     2.434     0.200
     1.007     0.723     0.200
     1.311     2.727     0.200
     1.358     1.867     0.200
     1.569    -1.005     0.200
     1.594     0.562     0.200
     1.602    -0.078     0.200
     1.717    -0.930     0.200
     1.752    -0.486     0.200
     1.779    -0.933     0.200
     1.878    -2.466     0.200
     0.479     1.350     0.200
     0.629     0.061     0.200
     0.900     0.410     0.200
     0.949    -0.431     0.200
     1.222    -0.518     0.200
     1.378     2.149     0.200
     1.429    -0.340     0.200
     2.465    -2.700     0.200
     2.737    -3.854     0.200
     3.099    -5.265     0.200
     0.468     1.000     0.200
     0.957    -0.976     0.200
     1.228    -1.200     0.200
     1.378     1.934     0.200
     1.482    -1.298     0.200
     0.472     0.275     0.200
     1.093     3.079     0.200
     1.227    -1.008     0.200
     1.481    -0.461     0.200
     1.767    -0.992     0.200
     0.500     0.720     0.200
     0.517     0.927     0.200
     0.842     0.250     0.200
     1.002    -0.469     0.200
     1.018     2.689     0.200
     1.120    -0.256     0.200
     1.173     0.196     0.200
     1.317    -0.185     0.200
     1.369     0.192     0.200
     1.497    -1.186     0.200
     1.647    -0.990     0.200
     1.774    -2.238     0.200
     0.473     2.162     0.200
     0.640     0.423     0.200
     0.773     0.334     0.200
     0.889    -0.106     0.200
     0.958    -0.282     0.200
     1.097     2.341     0.200
     1.293    -1.007     0.200
     1.325    -1.586     0.200
     1.440    -0.619     0.200
     1.484    -1.349     0.200
     1.770    -1.136     0.200
     0.499     1.339     0.200
     0.805     0.182     0.200
     1.222     2.205     0.200
     1.385    -2.068     0.200
     1.644    -0.880     0.200
     0.515     1.062     0.200
     0.780     0.890     0.200
     0.825     0.564     0.200
     0.897     1.973     0.200
     0.927     2.488     0.200
     1.101    -0.401     0.200
     1.077     0.916     0.200
     1.218     3.407     0.200
     1.436    -0.572     0.200
     1.467    -0.329     0.200
     1.579     0.059     0.200
     1.626    -0.488     0.200
     1.753    -2.084     0.200
     1.908    -0.589     0.200
     0.542    -0.125     0.200
     0.674     0.501     0.200
     0.513     0.045     0.200
     0.759     0.925     0.200
     0.858    -0.246     0.200
     1.047     1.493     0.200
     1.261     2.316     0.200
     1.434    -0.373     0.200
     1.510    -0.525     0.200
     1.543    -0.275     0.200
     1.658     0.122     0.200
     0.513     1.249     0.200
     0.570     0.977     0.200
     0.960     1.556     0.200
     1.229    -0.123     0.200
     1.228     2.256     0.200
     2.322    -3.430     0.200
     2.347    -1.635     0.200
     2.899    -6.881     0.200
     2.932    -4.146     0.200
     3.246    -5.159     0.200
     3.520    -8.645     0.200
     0.484     1.267     0.200
     0.532     0.929     0.200
     0.777     0.051     0.200
     0.858     0.503     0.200
     0.955     2.599     0.200
     1.031     2.303     0.200
     1.274     1.987     0.200
     1.512    -0.132     0.200
     1.544    -0.517     0.200
     1.657    -0.533     0.200
     0.478     1.223     0.200
     0.566     0.678     0.200
     0.718     0.036     0.200
     0.886    -0.042     0.200
     0.938     0.605     0.200
     0.943     2.433     0.200
     1.039    -0.431     0.200
     1.043     2.499     0.200
     1.160    -1.161     0.200
     1.220     0.240     0.200
     1.251    -0.102     0.200
     1.254     0.131     0.200
     0.573     1.182     0.200
     0.580     0.694     0.200
     0.845     2.534     0.200
     0.924    -0.373     0.200
     1.003     1.913     0.200
     1.122     3.651     0.200
     0.522     0.739     0.200
     0.493    -0.001     0.200
     0.637     0.947     0.200
     0.785     0.602     0.200
     1.109     1.786     0.200
     1.324    -0.616     0.200
     1.394     2.362     0.200
     1.437     0.132     0.200
     1.766    -0.819     0.200
     0.517     0.647     0.200
     0.751     0.164     0.200
     0.872     0.285     0.200
     0.954     1.441     0.200
     0.977     2.571     0.200
     1.040     1.051     0.200
     1.271     2.405     0.200
     1.314     1.501     0.200
     1.523    -1.175     0.200
     1.557    -1.350     0.200
     1.672    -1.058     0.200
     0.466     0.916     0.200
     0.613    -0.189     0.200
     1.071     2.034     0.200
     0.490     0.402     0.200
     0.598     0.632     0.200
     0.483     1.419     0.200
     0.609     0.319     0.200
     0.756     2.197     0.200
     0.930     0.692     0.200
     0.930     3.027     0.200
     1.080     2.733     0.200
     1.204    -0.641     0.200
     1.366     2.159     0.200
     1.409    -0.179     0.200
     1.456     0.584     0.200
     1.584    -2.293     0.200
     1.738    -1.524     0.200
     1.865    -1.266     0.200
     1.985    -2.666     0.200
     2.105    -3.171     0.200
     2.370    -3.121     0.200
     2.517    -3.475     0.200
     2.580    -3.232     0.200
     2.717    -4.621     0.200
     0.569     1.124     0.200
     0.684     1.120     0.200
     0.868     0.965     0.200
     0.938     0.099     0.200
     1.023    -0.446     0.200
     0.846     2.767     0.200
     1.193     2.569     0.200
     1.187    -0.540     0.200
     1.305    -1.497     0.200
     1.349    -0.031     0.200
     1.373    -0.019     0.200
     1.551    -0.492     0.200
     1.680    -2.469     0.200
     1.764     0.081     0.200
     1.806    -0.568     0.200
     1.943    -1.408     0.200
     0.508     1.220     0.200
     0.866     0.158     0.200
     0.983     3.012     0.200
     0.945     1.538     0.200
     1.049     1.139     0.200
     1.178    -0.385     0.200
     1.262     2.630     0.200
     1.306     1.943     0.200
     1.551    -1.239     0.200
     1.545     1.461     0.200
     1.667    -1.454     0.200
     1.699    -2.896     0.200
     1.880    -0.659     0.200
     1.829    -0.893     0.200
     1.997    -1.447     0.200
     2.362    -3.252     0.200
     2.527    -4.853     0.200
     2.590    -5.313     0.200
     0.615     0.632     0.200
     0.783     2.180     0.200
     0.900     2.254     0.200
     0.945     0.715     0.200
     0.934     1.763     0.200
     1.107     2.302     0.200
     1.222    -0.470     0.200
     1.415     0.062     0.200
     1.472    -0.129     0.200
     1.743    -0.468     0.200
     2.726    -3.522     0.200
     0.557     2.121     0.200
     0.622     0.556     0.200
     1.142     3.101     0.200
     1.311     0.118     0.200
     1.490    -1.651     0.200
     1.881    -0.722     0.200
     0.512     0.836     0.200
     0.763     0.558     0.200
     0.885     1.736     0.200
     0.924     2.756     0.200
     1.085    -0.700     0.200
     1.088     0.452     0.200
     1.355    -1.644     0.200
     0.519     0.944     0.200
     0.775     0.668     0.200
     0.831     1.231     0.200
     0.922     2.707     0.200
     1.097     0.302     0.200
     1.077     1.520     0.200
     1.218     4.205     0.200
     1.367    -0.752     0.200
     2.527    -3.987     0.200
     3.099    -7.245     0.200
     3.067    -4.459     0.200
     0.467     0.508     0.200
     0.624     0.145     0.200
     0.895    -0.389     0.200
     1.080     2.058     0.200
     1.212    -0.756     0.200
     1.276     0.311     0.200
     1.308     0.514     0.200
     1.594    -0.093     0.200
     1.080     2.909     0.200
     0.439     0.858     0.200
     0.614    -0.270     0.200
     1.052     2.615     0.200
     1.447     0.866     0.200
     0.462     0.208     0.200
     0.842     1.136     0.200
     0.501     1.725     0.200
     0.850     0.165     0.200
     0.931     1.568     0.200
     1.249     2.370     0.200
     1.291     2.319     0.200
     1.684    -2.076     0.200
     1.980    -1.620     0.200
     0.492     0.942     0.200
     0.584     0.774     0.200
     0.908    -0.158     0.200
     0.937     1.886     0.200
     0.925     2.808     0.200
     1.068     3.106     0.200
     1.229     1.182     0.200
     2.321    -2.034     0.200
     2.351    -0.226     0.200
     2.357     0.161     0.200
     0.519     0.462     0.200
     0.635     0.306     0.200
     0.801    -0.081     0.200
     0.927     2.281     0.200
     0.894     2.379     0.200
     1.125     2.331     0.200
     1.170     0.539     0.200
     1.323    -0.044     0.200
     1.434     0.193     0.200
     0.498     1.060     0.200
     0.787    -0.306     0.200
     0.808     0.074     0.200
     1.123     0.450     0.200
     1.077     0.636     0.200
     1.223     3.175     0.200
     1.461    -0.335     0.200
     1.608     0.363     0.200
     0.540     0.801     0.200
     0.735    -0.123     0.200
     0.915    -0.025     0.200
     0.993     1.024     0.200
     1.009     1.637     0.200
     1.308     2.370     0.200
     1.356     1.340     0.200
     1.567    -1.475     0.200
     1.715    -0.937     0.200
     1.750    -0.897     0.200
     1.781    -0.762     0.200
     1.706    -1.168     0.200
     0.566     0.270     0.200
     0.590     0.026     0.200
     0.850     2.772     0.200
     1.256    -0.105     0.200
     0.546     1.021     0.200
     1.226    -1.683     0.200
EOF
gmt end
