#!/bin/bash
gmt begin hubbard5.7_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional hubbard5.7'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.948
    15.000    42.669
    15.500    42.388
    16.000    42.104
    16.500    41.815
    17.000    41.519
    17.500    41.214
    18.000    40.900
    18.500    40.573
    19.000    40.232
    19.500    39.874
    20.000    39.497
    20.500    39.099
    21.000    38.678
    21.500    38.231
    22.000    37.756
    22.500    37.251
    23.000    36.715
    23.500    36.145
    24.000    34.946
    24.500    33.675
    25.000    32.394
    25.500    31.102
    26.000    29.799
    26.500    28.485
    27.000    27.159
    27.500    25.816
    28.000    24.453
    28.500    23.075
    29.000    21.685
    29.500    20.287
    30.000    18.880
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.453 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    10.651
     2.000    11.716
     2.500    12.781
     3.000    13.846
     3.500    14.912
     4.000    15.975
     4.500    17.038
     5.000    18.100
     5.500    19.161
     6.000    20.221
     6.500    21.279
     7.000    22.336
     7.500    23.392
     8.000    24.446
     8.500    25.497
     9.000    26.548
     9.500    27.595
    10.000    28.641
    10.500    29.684
    11.000    30.725
    11.500    31.764
    12.000    32.799
    12.500    33.832
    13.000    34.861
    13.500    35.888
    14.000    36.714
    14.500    37.452
    15.000    38.161
    15.500    38.836
    16.000    39.406
    16.500    39.907
    17.000    40.348
    17.500    40.048
    18.000    40.398
    18.500    40.689
    19.000    40.922
    19.500    41.097
    20.000    41.213
    20.500    41.271
    21.000    41.269
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    31.861 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.855
     1.000     7.349
     1.500     9.546
     2.000    11.743
     2.500    13.940
     3.000    16.136
     3.500    18.330
     4.000    20.524
     4.500    22.717
     5.000    24.909
     5.500    27.099
     6.000    29.288
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    22.909 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    31.426
     2.000    37.912
     2.500    44.399
     3.000    50.885
     3.500    57.370
     4.000    63.850
     4.500    70.329
     5.000    76.805
     5.500    83.276
     6.000    89.744
     6.500    96.206
     7.000   102.664
     7.500   109.116
     8.000   115.562
     8.500   122.001
     9.000   128.434
     9.500   134.858
    10.000   141.275
    10.500   147.683
    11.000   154.082
    11.500   160.475
    12.000   166.860
    12.500   173.237
    13.000   179.604
    13.500   185.963
    14.000   192.310
    14.500   198.648
    15.000   204.974
    15.500   211.289
    16.000   217.592
    16.500   223.884
    17.000   230.166
    17.500   234.978
    18.000   241.250
    18.500   247.510
    19.000   253.757
    19.500   259.990
    20.000   266.210
    20.500   272.415
    21.000   278.605
    21.500   284.781
    22.000   290.940
    22.500   297.084
    23.000   303.212
    23.500   309.322
    24.000   315.416
    24.500   321.492
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    61.850 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.942
     1.000    21.201
     1.500    29.221
     2.000    37.241
     2.500    45.260
     3.000    53.278
     3.500    61.295
     4.000    69.310
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    59.295 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    17.616    49.111     0.150
    17.244    45.024     0.150
    21.096   286.641     0.150
    24.162   295.830     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.702    44.825     0.200
    17.561    43.136     0.200
    17.664    41.932     0.200
    18.769    39.540     0.200
    20.708    39.401     0.200
    21.720    37.215     0.200
    22.850    37.029     0.200
    25.425    28.974     0.200
    16.685    45.098     0.200
    17.627    41.610     0.200
    17.545    41.569     0.200
    21.020    40.017     0.200
    21.034    40.245     0.200
    21.449    39.800     0.200
    21.661    38.530     0.200
    21.604    42.201     0.200
    22.219    41.213     0.200
    22.713    39.551     0.200
    23.473    40.390     0.200
    23.631    38.536     0.200
    24.093    37.153     0.200
    25.126    29.089     0.200
    25.274    32.872     0.200
    25.368    33.775     0.200
    25.483    32.930     0.200
    25.507    33.150     0.200
    25.552    33.127     0.200
    26.566    31.291     0.200
    14.752    40.449     0.200
    15.695    44.548     0.200
    15.923    44.387     0.200
    17.552    41.375     0.200
    17.616    41.818     0.200
    21.027    40.119     0.200
    21.042    39.643     0.200
    21.259    39.415     0.200
    21.457    39.800     0.200
    21.668    38.436     0.200
    21.607    40.948     0.200
    22.223    39.756     0.200
    22.717    38.790     0.200
    22.767    38.512     0.200
    23.477    36.732     0.200
    24.098    34.479     0.200
    24.820    34.549     0.200
    25.134    33.192     0.200
    25.278    33.412     0.200
    25.373    33.100     0.200
    25.486    33.277     0.200
    25.510    33.195     0.200
    25.558    33.942     0.200
    26.381    33.340     0.200
    26.885    30.253     0.200
    29.088    22.743     0.200
    29.203    20.408     0.200
    29.399    21.317     0.200
    17.798    43.281     0.200
    17.429    44.036     0.200
    17.566    43.958     0.200
    21.468    43.004     0.200
    21.847    40.113     0.200
    22.478    39.574     0.200
    25.157    35.447     0.200
    25.540    34.207     0.200
    26.281    31.541     0.200
    17.535    43.082     0.200
    25.499    33.603     0.200
    17.535    43.631     0.200
    21.605    38.802     0.200
    21.674    42.343     0.200
    22.057    39.919     0.200
    22.448    38.178     0.200
    25.126    35.033     0.200
    25.126    35.453     0.200
    25.512    33.498     0.200
    25.933    34.231     0.200
    26.250    32.135     0.200
    21.663    35.809     0.200
    21.663    36.918     0.200
    22.833    36.429     0.200
    25.248    31.023     0.200
    15.251    41.293     0.200
    16.169    40.720     0.200
    16.820    42.638     0.200
    16.926    42.820     0.200
    17.015    43.710     0.200
    17.518    42.865     0.200
    17.518    42.240     0.200
    17.562    42.376     0.200
    17.645    41.035     0.200
    18.284    42.871     0.200
    20.210    39.862     0.200
    21.006    38.474     0.200
    21.096    41.016     0.200
    21.096    41.422     0.200
    21.096    40.047     0.200
    21.635    38.626     0.200
    21.635    38.439     0.200
    21.635    38.830     0.200
    21.593    39.360     0.200
    21.698    39.944     0.200
    21.796    40.240     0.200
    21.796    39.373     0.200
    21.956    38.772     0.200
    21.956    38.225     0.200
    22.041    38.726     0.200
    22.205    39.967     0.200
    22.205    39.560     0.200
    22.430    37.736     0.200
    22.647    37.961     0.200
    22.719    38.975     0.200
    22.719    38.506     0.200
    22.977    38.239     0.200
    23.065    38.389     0.200
    23.206    38.531     0.200
    23.301    37.208     0.200
    23.306    39.726     0.200
    23.306    37.780     0.200
    23.529    36.195     0.200
    23.593    36.988     0.200
    23.604    37.140     0.200
    23.664    36.297     0.200
    23.807    37.203     0.200
    23.886    36.252     0.200
    23.927    36.472     0.200
    23.976    35.593     0.200
    23.977    36.474     0.200
    24.033    36.554     0.200
    24.062    37.999     0.200
    24.062    35.069     0.200
    24.099    35.551     0.200
    24.162    34.729     0.200
    24.162    34.525     0.200
    24.227    36.876     0.200
    24.227    35.493     0.200
    24.454    34.356     0.200
    24.509    35.578     0.200
    24.509    35.141     0.200
    24.582    36.327     0.200
    24.582    34.835     0.200
    25.029    35.017     0.200
    25.029    32.454     0.200
    25.111    33.377     0.200
    25.111    33.757     0.200
    25.111    33.621     0.200
    25.193    33.798     0.200
    25.193    32.954     0.200
    25.205    32.473     0.200
    25.220    32.821     0.200
    25.489    33.172     0.200
    25.536    33.000     0.200
    25.536    32.289     0.200
    25.694    33.265     0.200
    25.799    31.929     0.200
    25.914    31.617     0.200
    26.010    31.391     0.200
    26.064    32.036     0.200
    26.064    31.145     0.200
    26.112    31.012     0.200
    26.169    30.602     0.200
    26.251    30.030     0.200
    26.251    29.108     0.200
    26.411    29.622     0.200
    26.491    29.311     0.200
    26.503    30.719     0.200
    26.659    27.737     0.200
    26.659    27.394     0.200
    27.609    26.225     0.200
    27.615    27.934     0.200
    27.615    27.004     0.200
    27.681    26.346     0.200
    27.753    27.119     0.200
    27.753    25.072     0.200
    27.770    26.930     0.200
    27.770    26.344     0.200
    28.095    24.958     0.200
    28.984    22.652     0.200
    29.173    22.260     0.200
    29.247    22.183     0.200
    29.382    21.702     0.200
    29.426    23.805     0.200
    29.426    20.313     0.200
    29.599    21.897     0.200
    29.936    19.846     0.200
    13.989    41.953     0.200
    14.450    42.063     0.200
    14.498    45.781     0.200
    14.622    46.381     0.200
    14.719    43.401     0.200
    14.723    45.234     0.200
    14.909    42.625     0.200
    14.917    44.505     0.200
    14.967    44.981     0.200
    15.340    45.812     0.200
    15.662    44.463     0.200
    16.817    42.396     0.200
    16.922    44.503     0.200
    17.012    43.630     0.200
    17.519    41.633     0.200
    17.953    43.361     0.200
    18.318    40.201     0.200
    18.323    40.721     0.200
    18.323    42.651     0.200
    20.215    39.718     0.200
    21.089    40.943     0.200
    21.089    39.842     0.200
    21.332    41.350     0.200
    21.654    37.914     0.200
    21.654    38.570     0.200
    21.693    39.424     0.200
    21.792    39.370     0.200
    21.958    38.026     0.200
    21.969    40.501     0.200
    22.042    38.516     0.200
    22.198    38.929     0.200
    22.429    37.879     0.200
    22.648    37.180     0.200
    22.680    38.531     0.200
    22.734    36.431     0.200
    22.734    38.345     0.200
    23.066    36.963     0.200
    23.308    36.365     0.200
    23.307    37.971     0.200
    23.521    36.183     0.200
    23.598    36.307     0.200
    23.605    37.306     0.200
    23.658    35.820     0.200
    23.808    36.854     0.200
    23.887    36.596     0.200
    23.928    36.251     0.200
    23.978    35.034     0.200
    23.978    35.898     0.200
    24.034    35.987     0.200
    24.165    35.267     0.200
    24.165    34.580     0.200
    24.507    35.350     0.200
    25.021    33.230     0.200
    25.112    32.487     0.200
    25.112    33.766     0.200
    25.187    33.200     0.200
    25.219    32.113     0.200
    25.484    32.856     0.200
    25.531    31.925     0.200
    25.913    29.111     0.200
    26.004    30.098     0.200
    26.165    29.999     0.200
    26.261    30.410     0.200
    26.261    30.059     0.200
    26.487    29.424     0.200
    26.496    28.817     0.200
    27.607    25.379     0.200
    28.098    24.835     0.200
    29.169    23.081     0.200
    17.528    42.004     0.200
    18.328    40.686     0.200
    21.623    37.970     0.200
    21.623    39.220     0.200
    22.050    37.797     0.200
    22.440    38.911     0.200
    22.716    37.883     0.200
    27.620    25.171     0.200
    21.634    37.243     0.200
    25.455    33.369     0.200
    15.918    42.524     0.200
    23.443    36.655     0.200
    25.559    31.918     0.200
    26.418    27.502     0.200
    21.691    36.753     0.200
    15.435    40.707     0.200
    16.557    40.937     0.200
    16.743    41.433     0.200
    17.403    42.281     0.200
    18.758    42.394     0.200
    19.318    42.998     0.200
    20.718    39.725     0.200
    21.009    40.704     0.200
    21.024    41.084     0.200
    21.253    41.809     0.200
    22.697    39.725     0.200
    23.217    39.462     0.200
    23.547    38.513     0.200
    24.430    36.205     0.200
    25.055    35.439     0.200
    26.077    32.072     0.200
    26.686    31.074     0.200
    28.938    24.163     0.200
    15.898    41.964     0.200
    15.898    42.479     0.200
    16.002    43.330     0.200
    16.186    40.853     0.200
    17.644    41.379     0.200
    17.714    44.396     0.200
    18.490    44.116     0.200
    20.426    42.593     0.200
    20.718    41.663     0.200
    21.128    41.809     0.200
    21.128    40.442     0.200
    22.138    41.249     0.200
    22.138    40.093     0.200
    22.637    40.479     0.200
    23.487    41.803     0.200
    23.544    39.334     0.200
    23.940    38.563     0.200
    23.940    38.094     0.200
    24.635    36.398     0.200
    24.648    36.361     0.200
    24.732    36.916     0.200
    25.055    35.783     0.200
    25.298    34.285     0.200
    25.948    35.396     0.200
    26.128    32.751     0.200
    26.205    31.717     0.200
    26.321    32.510     0.200
    26.320    32.817     0.200
    26.320    32.489     0.200
    26.686    32.089     0.200
    26.686    31.691     0.200
    28.308    27.124     0.200
    28.281    27.258     0.200
    28.938    24.764     0.200
    28.938    25.186     0.200
    29.282    23.756     0.200
    29.428    22.784     0.200
    19.949    38.297     0.200
    20.739    37.325     0.200
    29.028    21.234     0.200
    19.316    42.858     0.200
    20.726    38.574     0.200
    16.141    43.019     0.200
    20.547    39.542     0.200
    21.215    42.329     0.200
    22.451    39.821     0.200
    25.111    34.315     0.200
    17.622    41.806     0.200
    17.935    41.907     0.200
    18.502    42.464     0.200
    18.552    44.045     0.200
    18.878    42.332     0.200
    18.979    41.040     0.200
    19.651    41.689     0.200
    19.739    41.844     0.200
    20.613    40.402     0.200
    21.071    40.521     0.200
    17.932    42.605     0.200
    18.708    44.805     0.200
    19.411    42.870     0.200
    19.455    41.806     0.200
    19.576    40.924     0.200
    19.649    42.226     0.200
    20.610    40.250     0.200
    21.343    39.661     0.200
    21.425    39.368     0.200
    22.452    39.074     0.200
    17.768    41.166     0.200
    20.445    40.231     0.200
    22.288    39.138     0.200
    22.544    37.656     0.200
    17.478    42.946     0.200
    17.796    43.733     0.200
    18.660    41.843     0.200
    21.097    42.583     0.200
    21.201    41.514     0.200
    21.912    39.972     0.200
    21.974    40.957     0.200
    21.966    40.240     0.200
    22.315    40.070     0.200
    23.168    36.504     0.200
    23.180    35.918     0.200
    17.337    44.789     0.200
    17.582    42.226     0.200
    17.907    43.829     0.200
    18.163    43.142     0.200
    18.227    42.825     0.200
    20.212    42.864     0.200
    20.367    42.143     0.200
    20.481    42.581     0.200
    21.228    41.259     0.200
    21.305    40.745     0.200
    21.355    41.151     0.200
    21.467    41.534     0.200
    21.478    42.253     0.200
    22.326    39.715     0.200
    25.030    36.625     0.200
    25.895    34.844     0.200
    26.861    31.908     0.200
    28.816    24.227     0.200
    17.907    44.479     0.200
    18.674    44.096     0.200
    20.625    42.234     0.200
    21.355    40.801     0.200
    21.305    41.405     0.200
    22.326    40.385     0.200
    22.834    40.811     0.200
    23.740    37.567     0.200
    23.740    38.087     0.200
    23.728    39.092     0.200
    24.932    36.520     0.200
    25.487    34.815     0.200
    27.957    28.003     0.200
    28.395    26.022     0.200
    16.247    44.177     0.200
    17.715    44.270     0.200
    18.489    46.833     0.200
    20.739    42.546     0.200
    20.865    41.194     0.200
    21.014    42.268     0.200
    21.607    43.318     0.200
    22.138    40.643     0.200
    22.234    41.584     0.200
    22.426    41.124     0.200
    25.298    36.626     0.200
    25.298    36.546     0.200
    16.202    46.864     0.200
    21.294    40.359     0.200
    21.306    41.911     0.200
    25.097    35.598     0.200
    25.113    34.539     0.200
    25.486    33.698     0.200
    25.969    34.254     0.200
    15.355    42.512     0.200
    16.748    43.194     0.200
    17.717    42.587     0.200
    21.124    39.692     0.200
    21.427    41.030     0.200
    22.428    40.288     0.200
    27.651    30.831     0.200
    22.216    39.221     0.200
    22.432    40.799     0.200
    22.497    38.942     0.200
    22.575    39.809     0.200
    22.618    40.521     0.200
    22.900    38.689     0.200
    22.927    40.117     0.200
    23.288    38.954     0.200
    23.654    37.230     0.200
    23.839    39.360     0.200
    24.186    33.643     0.200
    24.192    34.785     0.200
    25.132    33.863     0.200
    25.985    31.443     0.200
    26.975    31.481     0.200
    27.003    29.722     0.200
    28.865    22.910     0.200
    18.253    40.982     0.200
    19.042    41.184     0.200
    19.483    40.163     0.200
    19.722    41.426     0.200
    21.387    38.296     0.200
    21.564    38.913     0.200
    23.085    38.383     0.200
    24.675    34.204     0.200
    25.077    33.498     0.200
    25.584    31.405     0.200
    25.937    32.760     0.200
    26.112    29.989     0.200
    26.694    28.636     0.200
    28.913    22.230     0.200
    29.356    21.648     0.200
    16.221    41.969     0.200
    22.412    40.974     0.200
    25.284    35.375     0.200
    16.017    41.623     0.200
    16.484    43.014     0.200
    21.239    42.408     0.200
    19.693    43.358     0.200
    20.429    43.496     0.200
    21.123    41.170     0.200
    21.261    42.004     0.200
    21.710    40.281     0.200
    25.558    34.316     0.200
    25.983    33.427     0.200
    17.384    41.716     0.200
    18.696    41.995     0.200
    20.973    40.493     0.200
    21.043    40.892     0.200
    21.408    40.407     0.200
    21.676    39.990     0.200
    22.484    40.075     0.200
    22.674    39.441     0.200
    25.108    35.451     0.200
    27.778    26.188     0.200
    16.135    42.520     0.200
    16.444    43.540     0.200
    17.807    45.231     0.200
    17.846    44.660     0.200
    17.903    43.861     0.200
    18.094    41.626     0.200
    18.227    43.271     0.200
    18.524    44.355     0.200
    18.581    43.456     0.200
    18.857    42.673     0.200
    18.939    44.348     0.200
    18.989    42.729     0.200
    19.227    41.836     0.200
    19.393    43.862     0.200
    19.634    43.600     0.200
    19.715    42.257     0.200
    20.362    43.311     0.200
    20.573    41.365     0.200
    20.932    42.774     0.200
    20.993    41.433     0.200
    20.974    42.108     0.200
    21.059    42.704     0.200
    21.296    41.297     0.200
    21.345    41.344     0.200
    21.361    41.409     0.200
    21.327    39.985     0.200
    21.479    41.127     0.200
    21.601    40.976     0.200
    21.635    41.991     0.200
    21.608    41.811     0.200
    21.648    40.618     0.200
    22.147    40.041     0.200
    22.320    40.590     0.200
    22.407    40.792     0.200
    22.615    39.994     0.200
    22.745    38.716     0.200
    22.792    40.592     0.200
    22.972    37.834     0.200
    23.013    40.915     0.200
    23.144    39.511     0.200
    23.105    38.540     0.200
    23.439    39.926     0.200
    23.950    38.344     0.200
    23.977    39.605     0.200
    24.151    38.350     0.200
    25.482    35.082     0.200
    25.938    33.480     0.200
    25.983    32.602     0.200
    26.058    31.785     0.200
    26.852    31.694     0.200
    27.822    27.936     0.200
    27.960    27.408     0.200
    16.237    43.579     0.200
    17.130    44.383     0.200
    17.706    43.378     0.200
    18.750    43.169     0.200
    19.513    42.562     0.200
    20.169    42.764     0.200
    20.273    42.428     0.200
    20.383    41.801     0.200
    20.419    42.913     0.200
    20.730    42.351     0.200
    20.856    42.139     0.200
    21.019    41.792     0.200
    21.150    40.912     0.200
    21.270    41.797     0.200
    21.421    41.496     0.200
    21.418    40.977     0.200
    21.443    40.827     0.200
    21.793    40.516     0.200
    21.879    40.460     0.200
    21.902    39.920     0.200
    22.003    40.858     0.200
    22.226    40.079     0.200
    22.416    40.263     0.200
    22.482    40.820     0.200
    22.599    39.878     0.200
    22.630    40.698     0.200
    23.241    39.236     0.200
    23.535    39.362     0.200
    23.956    37.933     0.200
    25.289    35.418     0.200
    25.289    35.199     0.200
    27.748    28.157     0.200
    27.862    28.453     0.200
    28.124    27.338     0.200
    28.225    26.718     0.200
    20.985    41.610     0.200
    21.035    41.414     0.200
    21.389    40.642     0.200
    21.405    40.709     0.200
    21.699    40.515     0.200
    25.077    36.307     0.200
    20.990    42.580     0.200
    22.040    43.597     0.200
    23.063    39.527     0.200
    24.687    35.168     0.200
    26.108    31.070     0.200
    26.914    30.766     0.200
    29.331    23.107     0.200
    29.575    22.709     0.200
    16.441    41.890     0.200
    16.833    41.826     0.200
    17.482    42.203     0.200
    18.842    42.283     0.200
    19.323    43.200     0.200
    20.136    40.630     0.200
    20.476    41.644     0.200
    21.120    40.869     0.200
    21.245    40.113     0.200
    15.918    43.391     0.200
    17.801    43.599     0.200
    18.572    46.575     0.200
    20.263    42.459     0.200
    20.518    42.052     0.200
    21.206    40.850     0.200
    21.384    40.060     0.200
    22.223    39.776     0.200
    22.727    40.128     0.200
    23.847    37.263     0.200
    23.847    37.853     0.200
    24.824    36.863     0.200
    25.033    36.750     0.200
    18.197    41.436     0.200
    18.992    42.108     0.200
    19.552    41.423     0.200
    19.592    41.225     0.200
    19.663    41.463     0.200
    20.348    42.434     0.200
    20.533    39.945     0.200
    21.013    39.895     0.200
    21.082    39.785     0.200
    22.372    38.744     0.200
    23.710    36.364     0.200
    26.298    29.568     0.200
    26.918    28.542     0.200
    28.880    22.189     0.200
    29.326    23.577     0.200
    14.236    45.611     0.200
    16.099    45.122     0.200
    17.470    40.824     0.200
    17.948    44.372     0.200
    18.724    42.178     0.200
    20.412    42.569     0.200
    20.657    41.777     0.200
    21.360    40.795     0.200
    21.360    40.365     0.200
    22.372    40.205     0.200
    22.372    39.565     0.200
    22.870    39.674     0.200
    23.710    37.028     0.200
    23.710    36.879     0.200
    24.882    37.235     0.200
    24.961    35.915     0.200
    25.117    34.551     0.200
    25.532    33.967     0.200
    25.978    32.055     0.200
    26.359    30.958     0.200
    26.529    30.371     0.200
    26.529    29.449     0.200
    26.918    30.237     0.200
    26.918    29.761     0.200
    27.977    27.605     0.200
    28.476    24.968     0.200
    28.530    25.989     0.200
    28.880    23.588     0.200
    29.326    22.788     0.200
    16.478    43.179     0.200
    16.726    40.867     0.200
    16.981    42.331     0.200
    17.442    40.939     0.200
    17.956    42.230     0.200
    18.736    45.449     0.200
    19.562    41.673     0.200
    19.667    41.429     0.200
    21.239    42.487     0.200
    25.149    33.828     0.200
    26.009    33.557     0.200
    26.632    30.412     0.200
    28.906    25.101     0.200
    18.575    41.553     0.200
    18.775    41.825     0.200
    19.334    41.032     0.200
    19.377    40.746     0.200
    19.378    40.645     0.200
    19.430    41.193     0.200
    19.443    40.739     0.200
    20.686    38.959     0.200
    21.507    39.401     0.200
    21.623    39.251     0.200
    22.730    39.367     0.200
    24.411    33.977     0.200
    25.090    33.639     0.200
    25.981    31.427     0.200
    26.707    29.425     0.200
    26.729    28.949     0.200
    27.784    26.983     0.200
    28.964    22.456     0.200
    15.903    42.198     0.200
    15.903    41.739     0.200
    17.728    42.944     0.200
    18.235    42.194     0.200
    18.508    43.579     0.200
    20.193    42.657     0.200
    20.437    41.503     0.200
    21.147    41.039     0.200
    21.147    40.659     0.200
    21.460    39.567     0.200
    21.668    43.213     0.200
    22.154    39.459     0.200
    22.154    39.288     0.200
    22.649    39.332     0.200
    23.562    38.764     0.200
    23.930    36.724     0.200
    24.427    36.211     0.200
    24.663    35.746     0.200
    24.741    35.770     0.200
    25.090    34.139     0.200
    25.313    33.965     0.200
    26.139    31.639     0.200
    26.348    30.155     0.200
    26.348    30.895     0.200
    26.321    31.615     0.200
    26.707    30.545     0.200
    26.707    30.445     0.200
    27.760    27.672     0.200
    28.312    24.801     0.200
    28.313    26.422     0.200
    28.964    22.265     0.200
    29.316    22.303     0.200
    29.445    23.660     0.200
    22.242    40.343     0.200
    25.513    32.789     0.200
    18.720    40.197     0.200
    21.416    40.581     0.200
    22.412    37.737     0.200
    25.572    34.289     0.200
    21.937    39.598     0.200
    18.001    42.995     0.200
    20.462    43.237     0.200
    20.576    41.540     0.200
    21.343    40.990     0.200
    25.894    33.385     0.200
    18.001    44.057     0.200
    18.767    45.643     0.200
    20.462    45.144     0.200
    20.720    41.580     0.200
    21.343    40.869     0.200
    21.396    40.237     0.200
    22.929    39.583     0.200
    23.645    37.378     0.200
    25.027    36.164     0.200
    26.952    32.908     0.200
    28.051    27.359     0.200
    28.779    24.797     0.200
    15.425   484.839     0.200
    21.341    39.697     0.200
    21.438    39.500     0.200
    22.707    38.274     0.200
    25.039    33.601     0.200
    25.526    33.310     0.200
    25.891    32.547     0.200
    16.617    41.855     0.200
    17.008    42.063     0.200
    17.404    41.776     0.200
    17.651    41.115     0.200
    17.707    42.327     0.200
    17.878    42.530     0.200
    17.976    42.390     0.200
    18.231    42.321     0.200
    18.295    43.003     0.200
    18.650    42.633     0.200
    18.743    42.302     0.200
    18.926    41.620     0.200
    19.014    42.286     0.200
    23.672   -10.031     0.200
    19.298    42.062     0.200
    19.462    42.478     0.200
    19.497    41.814     0.200
    19.575    41.942     0.200
    19.610    41.418     0.200
    19.702    41.566     0.200
    20.281    41.132     0.200
    20.310    41.785     0.200
    20.436    41.070     0.200
    20.548    40.939     0.200
    20.649    40.645     0.200
    21.002    40.177     0.200
    21.291    41.333     0.200
    21.357    39.794     0.200
    21.373    40.407     0.200
    22.056    39.827     0.200
    22.822    37.779     0.200
    25.050    34.872     0.200
    25.905    32.994     0.200
    26.930    30.022     0.200
    17.976    43.968     0.200
    18.743    42.853     0.200
    20.436    42.160     0.200
    20.693    41.818     0.200
    21.357    40.274     0.200
    21.373    40.579     0.200
    22.395    38.974     0.200
    22.902    39.256     0.200
    23.672    37.419     0.200
    23.797    38.150     0.200
    24.910    37.158     0.200
    25.050    34.724     0.200
    25.000    35.578     0.200
    25.556    33.573     0.200
    26.394    34.166     0.200
    26.515    28.651     0.200
    28.022    27.259     0.200
    28.453    25.057     0.200
    28.800    24.308     0.200
    15.433   484.795     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.284    12.411     0.200
     3.804    15.676     0.200
     4.934    18.293     0.200
     7.988    22.750     0.200
     8.373    23.951     0.200
     8.639    25.049     0.200
     9.771    29.546     0.200
    10.804    30.284     0.200
    12.246    31.662     0.200
    13.206    34.957     0.200
    15.870    38.563     0.200
    20.396    42.450     0.200
     3.750    15.032     0.200
     3.806    13.670     0.200
     4.839    17.113     0.200
     4.877    17.079     0.200
     5.013    17.991     0.200
     5.192    18.299     0.200
     5.238    18.759     0.200
     5.809    19.096     0.200
     6.107    22.618     0.200
     7.068    21.708     0.200
     7.150    23.548     0.200
     7.931    23.337     0.200
     8.317    22.930     0.200
     8.638    23.583     0.200
     8.715    26.088     0.200
    12.229    31.174     0.200
    12.291    30.757     0.200
    17.663    37.458     0.200
    18.826    41.989     0.200
    20.763    39.384     0.200
     3.557    13.300     0.200
     3.760    13.632     0.200
     4.920    17.894     0.200
     5.098    17.325     0.200
     5.105    17.934     0.200
     5.320    19.431     0.200
     5.734    18.903     0.200
     6.200    20.966     0.200
     7.161    21.240     0.200
     8.018    23.248     0.200
     8.394    23.356     0.200
     8.600    25.147     0.200
    12.205    31.885     0.200
    12.199    31.553     0.200
    15.840    38.856     0.200
    17.624    39.137     0.200
    18.568    41.028     0.200
    18.742    40.597     0.200
    19.821    43.005     0.200
    20.018    42.705     0.200
    20.348    41.358     0.200
    20.669    40.103     0.200
     3.547    13.207     0.200
     3.812    16.420     0.200
     3.764    13.576     0.200
     4.950    18.040     0.200
     5.089    17.419     0.200
     5.114    17.018     0.200
     5.741    19.403     0.200
     6.146    19.485     0.200
     6.146    19.586     0.200
     7.068    22.623     0.200
     7.151    20.249     0.200
     8.009    23.345     0.200
     8.386    23.837     0.200
     8.605    24.778     0.200
     8.761    26.362     0.200
     9.943    30.666     0.200
    12.194    31.496     0.200
    12.209    30.723     0.200
    15.850    38.340     0.200
    17.630    38.466     0.200
    18.562    41.086     0.200
    18.751    40.384     0.200
    20.025    41.609     0.200
    20.357    39.932     0.200
    20.679    40.073     0.200
     1.839    11.364     0.200
     2.124    12.362     0.200
     2.604    12.895     0.200
     2.734    13.247     0.200
     3.005    13.546     0.200
     3.275    14.090     0.200
     3.554    15.195     0.200
     3.641    15.614     0.200
     3.645    15.313     0.200
     3.653    15.227     0.200
     3.703    17.538     0.200
     3.736    14.974     0.200
     3.926    16.635     0.200
     3.967    15.279     0.200
     4.234    16.155     0.200
     4.997    17.136     0.200
     5.062    18.179     0.200
     6.206    22.322     0.200
     7.277    20.822     0.200
     8.558    24.875     0.200
     8.832    27.675     0.200
     1.757     7.814     0.200
     1.845     8.722     0.200
     2.453    10.257     0.200
     2.574    10.891     0.200
     2.662    10.786     0.200
     3.206    11.542     0.200
     3.511    13.251     0.200
     3.590    12.571     0.200
     3.692    14.484     0.200
     3.693    14.075     0.200
     3.861    14.023     0.200
     3.879    14.603     0.200
     3.997    14.716     0.200
     4.119    14.335     0.200
     4.220    15.181     0.200
     4.260    14.700     0.200
     4.702    15.436     0.200
     4.708    15.924     0.200
     4.840    15.102     0.200
     4.960    16.199     0.200
     5.010    15.758     0.200
     5.010    16.899     0.200
     4.987    14.867     0.200
     5.043    15.127     0.200
     5.146    16.812     0.200
     5.372    17.880     0.200
     5.413    16.141     0.200
     5.607    16.918     0.200
     5.607    16.389     0.200
     5.677    17.920     0.200
     5.743    18.289     0.200
     6.012    18.241     0.200
     6.187    19.606     0.200
     6.209    19.034     0.200
     6.393    18.435     0.200
     6.408    19.294     0.200
     6.487    18.827     0.200
     6.476    19.685     0.200
     6.507    19.472     0.200
     6.641    19.497     0.200
     6.668    19.844     0.200
     6.669    20.095     0.200
     6.670    19.859     0.200
     6.695    20.370     0.200
     6.751    19.613     0.200
     6.797    20.223     0.200
     6.816    19.587     0.200
     6.851    20.690     0.200
     6.885    20.467     0.200
     6.990    20.619     0.200
     7.139    20.865     0.200
     7.147    21.027     0.200
     7.150    20.041     0.200
     7.162    21.751     0.200
     7.179    19.788     0.200
     7.351    21.033     0.200
     8.064    20.094     0.200
     8.650    24.567     0.200
     1.733     8.190     0.200
     1.825     9.187     0.200
     2.437    10.646     0.200
     2.524    10.123     0.200
     2.550    11.335     0.200
     2.646    10.898     0.200
     3.190    11.734     0.200
     3.489    13.358     0.200
     3.573    12.883     0.200
     3.570    12.782     0.200
     3.721    12.977     0.200
     3.836    14.195     0.200
     3.855    14.896     0.200
     3.972    15.026     0.200
     4.092    14.389     0.200
     4.192    15.229     0.200
     4.238    14.820     0.200
     4.680    15.688     0.200
     4.729    15.991     0.200
     4.823    15.156     0.200
     4.939    16.379     0.200
     4.971    15.170     0.200
     4.990    15.989     0.200
     4.990    17.430     0.200
     5.029    15.690     0.200
     5.127    17.244     0.200
     5.351    18.129     0.200
     5.397    16.176     0.200
     5.582    17.136     0.200
     5.580    18.591     0.200
     5.723    18.644     0.200
     5.699    18.169     0.200
     6.000    18.397     0.200
     6.120    17.653     0.200
     6.181    19.785     0.200
     6.162    19.479     0.200
     6.188    19.359     0.200
     6.189    19.046     0.200
     6.375    17.932     0.200
     6.389    20.104     0.200
     6.417    19.137     0.200
     6.458    18.819     0.200
     6.476    19.085     0.200
     6.462    20.367     0.200
     6.488    18.769     0.200
     6.614    19.376     0.200
     6.625    19.614     0.200
     6.652    19.698     0.200
     6.654    20.346     0.200
     6.654    20.512     0.200
     6.679    20.425     0.200
     6.735    20.089     0.200
     6.783    20.253     0.200
     6.807    19.817     0.200
     6.836    20.380     0.200
     6.871    20.607     0.200
     6.977    21.179     0.200
     7.130    23.044     0.200
     7.136    22.458     0.200
     7.173    19.846     0.200
     7.340    21.340     0.200
     7.625    21.410     0.200
     8.046    21.113     0.200
     8.428    21.900     0.200
     2.433    11.650     0.200
     2.541    12.413     0.200
     2.641    12.420     0.200
     3.184    13.393     0.200
     3.481    14.625     0.200
     3.564    14.933     0.200
     3.846    16.037     0.200
     4.736    17.048     0.200
     2.401    12.963     0.200
     2.365    11.914     0.200
     3.042    12.790     0.200
     3.313    14.749     0.200
     3.411    13.780     0.200
     3.405    13.275     0.200
     3.416    14.812     0.200
     3.496    14.649     0.200
     3.841    16.516     0.200
     4.098    15.589     0.200
     4.467    16.779     0.200
     4.506    16.945     0.200
     4.895    16.452     0.200
     5.554    19.660     0.200
     1.919     9.692     0.200
     2.009    10.840     0.200
     2.263    10.873     0.200
     2.263    10.673     0.200
     2.585    12.118     0.200
     2.643    12.434     0.200
     2.752    12.166     0.200
     2.795    13.161     0.200
     3.072    12.767     0.200
     3.404    12.825     0.200
     3.502    15.409     0.200
     3.678    13.758     0.200
     3.731    15.839     0.200
     3.747    14.762     0.200
     3.832    14.564     0.200
     4.057    14.934     0.200
     4.170    14.766     0.200
     4.647    16.149     0.200
     4.868    16.930     0.200
     4.930    17.804     0.200
     5.169    16.469     0.200
     2.338    12.279     0.200
     2.386    12.539     0.200
     2.434    12.757     0.200
     2.545    12.756     0.200
     2.816    13.300     0.200
     3.093    13.716     0.200
     3.375    15.174     0.200
     3.460    15.780     0.200
     3.550    14.452     0.200
     3.739    16.530     0.200
     3.780    15.199     0.200
     3.833    13.751     0.200
     3.914    16.651     0.200
     4.152    16.609     0.200
     4.381    16.586     0.200
     4.567    16.139     0.200
     4.827    16.545     0.200
     4.842    17.656     0.200
     4.870    16.254     0.200
     5.196    17.590     0.200
     5.726    17.889     0.200
     5.726    17.909     0.200
     6.078    18.221     0.200
     7.609    23.608     0.200
     8.664    23.286     0.200
     1.953    11.300     0.200
     2.627    13.033     0.200
     2.759    13.189     0.200
     2.837    13.882     0.200
     3.384    14.707     0.200
     3.524    16.893     0.200
     3.697    15.352     0.200
     3.742    16.115     0.200
     3.768    15.127     0.200
     3.774    14.649     0.200
     4.064    16.360     0.200
     4.086    16.517     0.200
     4.418    15.643     0.200
     4.463    18.403     0.200
     4.684    16.533     0.200
     4.838    17.632     0.200
     5.162    17.450     0.200
     5.213    17.159     0.200
     5.588    18.675     0.200
     5.926    21.934     0.200
     5.942    20.650     0.200
     6.175    20.229     0.200
     6.371    21.241     0.200
     2.276    12.539     0.200
     2.391    13.069     0.200
     2.749    13.386     0.200
     3.019    13.486     0.200
     3.389    15.399     0.200
     3.641    16.081     0.200
     3.942    15.102     0.200
     4.794    18.908     0.200
     4.941    18.313     0.200
     5.156    19.895     0.200
     5.274    18.581     0.200
     7.103    21.880     0.200
     8.223    24.308     0.200
     2.323    11.813     0.200
     2.386    12.048     0.200
     2.376    12.103     0.200
     2.434    11.768     0.200
     2.530    12.385     0.200
     2.797    12.532     0.200
     3.018    12.861     0.200
     3.336    13.452     0.200
     3.429    14.061     0.200
     3.441    14.017     0.200
     3.520    12.693     0.200
     3.690    14.511     0.200
     3.898    13.486     0.200
     4.132    14.950     0.200
     4.491    16.468     0.200
     5.224    17.461     0.200
     5.576    18.899     0.200
     2.373    11.583     0.200
     2.328    12.089     0.200
     2.394    11.650     0.200
     2.438    11.411     0.200
     2.535    12.268     0.200
     2.803    12.642     0.200
     3.343    13.550     0.200
     3.360    14.944     0.200
     3.435    14.069     0.200
     3.447    14.231     0.200
     3.527    13.201     0.200
     3.698    15.101     0.200
     3.761    14.871     0.200
     3.889    13.749     0.200
     4.090    14.928     0.200
     4.137    14.383     0.200
     4.363    14.942     0.200
     4.498    15.674     0.200
     4.536    15.405     0.200
     4.700    15.813     0.200
     4.797    15.779     0.200
     4.926    15.475     0.200
     5.218    16.218     0.200
     5.213    18.223     0.200
     5.590    19.324     0.200
     5.853    20.256     0.200
     5.908    19.613     0.200
     6.330    19.485     0.200
     8.518    24.354     0.200
    12.167    31.064     0.200
     2.416    12.646     0.200
     3.163    13.925     0.200
     3.266    14.323     0.200
     3.440    15.389     0.200
     3.531    15.332     0.200
     3.539    15.034     0.200
     3.581    16.747     0.200
     3.574    14.327     0.200
     3.797    17.232     0.200
     3.854    14.963     0.200
     3.898    17.450     0.200
     3.797    14.321     0.200
     4.188    16.762     0.200
     4.633    17.665     0.200
     4.947    19.400     0.200
     5.123    19.075     0.200
     5.757    18.850     0.200
     6.109    23.012     0.200
     7.183    21.414     0.200
     8.014    24.018     0.200
     7.908    22.066     0.200
     8.378    24.861     0.200
     8.547    24.740     0.200
    12.110    31.564     0.200
     2.425    12.256     0.200
     2.523    12.404     0.200
     3.175    13.101     0.200
     3.828    16.179     0.200
     3.754    15.447     0.200
     4.969    19.062     0.200
     5.106    17.459     0.200
     5.331    19.544     0.200
     5.802    19.795     0.200
     6.153    21.155     0.200
     7.173    20.439     0.200
     7.203    21.091     0.200
     8.404    23.972     0.200
     8.596    24.607     0.200
    12.126    30.893     0.200
     1.835    11.434     0.200
     2.296    11.924     0.200
     2.652    13.606     0.200
     2.803    13.330     0.200
     3.306    15.266     0.200
     3.394    14.233     0.200
     3.606    13.374     0.200
     4.088    17.945     0.200
     5.012    18.059     0.200
     5.012    19.039     0.200
     2.446    12.595     0.200
     2.546    12.707     0.200
     2.654    12.994     0.200
     2.707    13.180     0.200
     3.194    14.131     0.200
     3.298    14.892     0.200
     3.827    17.310     0.200
     3.908    17.384     0.200
     3.771    13.769     0.200
     4.979    18.158     0.200
     5.123    18.895     0.200
     5.189    17.928     0.200
     5.092    18.107     0.200
     5.341    20.146     0.200
     5.755    20.964     0.200
     5.783    18.793     0.200
     6.136    20.222     0.200
     7.209    21.546     0.200
     7.239    20.983     0.200
     7.634    23.670     0.200
     8.410    23.680     0.200
     8.550    25.596     0.200
     8.733    25.627     0.200
     8.760    27.310     0.200
    12.081    32.149     0.200
    12.086    32.277     0.200
     2.530    12.050     0.200
     2.218    11.549     0.200
     2.302    11.211     0.200
     2.428    12.193     0.200
     2.511    12.005     0.200
     3.102    13.234     0.200
     3.293    14.160     0.200
     3.677    15.459     0.200
     3.676    15.374     0.200
     3.994    16.057     0.200
     4.045    15.790     0.200
     4.739    16.914     0.200
     5.303    18.719     0.200
     5.303    18.844     0.200
     5.636    20.526     0.200
     6.063    23.159     0.200
     3.059    10.893     0.200
     3.709    14.608     0.200
     3.898    14.767     0.200
     3.898    14.904     0.200
     3.861    14.092     0.200
     4.352    16.484     0.200
     4.849    16.940     0.200
     4.990    18.358     0.200
     5.224    17.253     0.200
     5.224    17.023     0.200
     5.648    19.311     0.200
     5.698    16.094     0.200
     6.047    18.552     0.200
     8.284    22.618     0.200
     8.573    22.854     0.200
     8.573    23.143     0.200
     8.573    23.546     0.200
     8.546    25.262     0.200
     8.662    25.410     0.200
    12.201    29.207     0.200
    12.201    30.207     0.200
    12.206    30.440     0.200
     2.447    12.897     0.200
     3.011    14.175     0.200
     3.855    16.467     0.200
     3.855    16.737     0.200
     1.562     9.917     0.200
     1.723     9.756     0.200
     2.288    12.479     0.200
     2.542    11.606     0.200
     2.791    12.070     0.200
     3.156    13.822     0.200
     3.198    13.191     0.200
     3.307    13.906     0.200
     3.496    14.792     0.200
     3.507    16.067     0.200
     3.563    14.268     0.200
     3.572    14.249     0.200
     3.576    14.360     0.200
     3.595    13.762     0.200
     3.682    14.449     0.200
     3.746    12.688     0.200
     3.746    13.797     0.200
     3.892    14.695     0.200
     3.941    16.530     0.200
     3.941    16.631     0.200
     4.072    15.790     0.200
     4.163    16.162     0.200
     4.233    16.454     0.200
     4.251    15.042     0.200
     4.471    17.983     0.200
     4.635    17.540     0.200
     4.677    16.520     0.200
     4.677    16.902     0.200
     4.937    17.596     0.200
     4.989    17.977     0.200
     5.042    16.476     0.200
     5.085    17.343     0.200
     5.085    17.234     0.200
     5.196    17.709     0.200
     5.351    19.928     0.200
     5.407    17.301     0.200
     5.416    20.182     0.200
     5.567    19.631     0.200
     5.727    20.163     0.200
     5.776    19.798     0.200
     5.776    19.939     0.200
     5.809    18.061     0.200
     5.809    17.912     0.200
     5.801    18.177     0.200
     5.984    20.766     0.200
     6.149    20.390     0.200
     6.161    21.804     0.200
     6.161    21.226     0.200
     6.221    19.563     0.200
     6.249    20.470     0.200
     6.274    20.875     0.200
     6.324    18.121     0.200
     6.449    21.685     0.200
     6.623    19.878     0.200
     6.662    20.358     0.200
     6.664    20.679     0.200
     6.744    20.436     0.200
     6.795    21.942     0.200
     6.829    21.383     0.200
     6.849    22.005     0.200
     6.886    21.324     0.200
     6.992    22.181     0.200
     7.120    22.562     0.200
     7.152    23.111     0.200
     7.167    23.082     0.200
     7.229    20.915     0.200
     7.642    23.486     0.200
     7.806    23.642     0.200
     8.031    23.453     0.200
     8.099    23.762     0.200
     8.119    23.339     0.200
     8.190    23.825     0.200
     8.422    23.568     0.200
     8.412    26.081     0.200
     8.574    25.267     0.200
     8.582    25.346     0.200
     8.757    25.114     0.200
     9.321    26.608     0.200
    10.133    29.526     0.200
    12.095    31.654     0.200
    12.095    32.014     0.200
    12.100    31.241     0.200
    14.031    35.089     0.200
    14.726    36.169     0.200
    15.244    39.170     0.200
    15.807    38.736     0.200
    15.990    36.677     0.200
    18.320    41.636     0.200
    18.742    42.560     0.200
    19.302    42.665     0.200
    19.574    41.379     0.200
    19.991    40.748     0.200
    20.052    42.674     0.200
    20.224    40.528     0.200
    20.214    40.677     0.200
    20.222    41.176     0.200
    20.632    40.027     0.200
     2.303    11.970     0.200
     2.303    11.649     0.200
     2.531    11.875     0.200
     2.792    12.218     0.200
     3.167    13.665     0.200
     3.190    13.189     0.200
     3.303    13.975     0.200
     3.503    14.833     0.200
     3.555    13.527     0.200
     3.567    13.784     0.200
     3.569    14.715     0.200
     3.582    13.322     0.200
     3.676    14.005     0.200
     3.739    13.640     0.200
     3.885    14.443     0.200
     3.957    16.239     0.200
     4.077    15.434     0.200
     4.171    15.538     0.200
     4.231    16.122     0.200
     4.241    14.708     0.200
     4.477    17.333     0.200
     4.674    16.930     0.200
     4.933    17.294     0.200
     4.985    17.699     0.200
     5.033    16.106     0.200
     5.091    17.138     0.200
     5.091    16.966     0.200
     5.091    16.739     0.200
     5.398    17.313     0.200
     5.410    19.558     0.200
     5.517    18.348     0.200
     5.561    18.271     0.200
     5.779    19.083     0.200
     5.790    17.801     0.200
     5.816    17.950     0.200
     5.816    17.848     0.200
     5.990    18.966     0.200
     6.150    19.853     0.200
     6.168    23.194     0.200
     6.168    19.639     0.200
     6.243    19.924     0.200
     6.318    19.461     0.200
     6.341    19.647     0.200
     6.382    20.435     0.200
     6.450    20.243     0.200
     6.615    20.792     0.200
     6.653    19.635     0.200
     6.655    20.948     0.200
     6.736    19.789     0.200
     6.786    20.856     0.200
     6.839    20.880     0.200
     6.876    20.785     0.200
     6.981    22.380     0.200
     7.109    22.854     0.200
     7.141    22.825     0.200
     7.184    21.689     0.200
     7.111    21.518     0.200
     7.215    20.990     0.200
     7.631    23.108     0.200
     7.678    23.575     0.200
     7.635    24.077     0.200
     7.794    23.450     0.200
     8.025    22.906     0.200
     8.087    23.159     0.200
     8.107    23.557     0.200
     8.100    23.889     0.200
     8.419    23.622     0.200
     8.423    25.356     0.200
     8.583    25.383     0.200
     8.601    24.927     0.200
     8.601    23.958     0.200
     8.601    25.122     0.200
     8.761    24.925     0.200
     8.788    26.615     0.200
     8.667    25.083     0.200
    10.128    29.327     0.200
    10.128    29.725     0.200
    12.111    29.847     0.200
    12.111    30.886     0.200
    12.116    30.223     0.200
    12.359    35.572     0.200
    12.865    36.244     0.200
    13.705    38.387     0.200
    13.736    38.647     0.200
    14.031    34.640     0.200
    14.723    35.960     0.200
    15.240    39.108     0.200
    15.814    38.511     0.200
    15.814    38.854     0.200
    15.976    36.621     0.200
    17.519    40.180     0.200
    18.875    42.928     0.200
    19.039    42.892     0.200
    19.992    40.882     0.200
    20.046    42.511     0.200
    20.208    39.945     0.200
    20.225    40.368     0.200
    20.644    40.066     0.200
     2.298    12.016     0.200
     2.533    12.002     0.200
     2.536    12.799     0.200
     2.795    12.387     0.200
     3.158    14.204     0.200
     3.190    13.421     0.200
     3.301    13.978     0.200
     3.555    13.502     0.200
     3.565    14.347     0.200
     3.746    15.286     0.200
     3.884    14.980     0.200
     3.947    16.544     0.200
     4.071    15.746     0.200
     4.228    16.334     0.200
     4.242    14.861     0.200
     4.470    17.165     0.200
     4.672    17.161     0.200
     4.931    17.842     0.200
     4.983    19.001     0.200
     5.091    17.544     0.200
     5.091    17.083     0.200
     5.091    17.841     0.200
     5.345    19.585     0.200
     5.399    18.080     0.200
     5.774    19.739     0.200
     5.792    18.521     0.200
     5.809    18.707     0.200
     5.809    19.269     0.200
     6.146    20.562     0.200
     6.242    20.554     0.200
     6.446    21.170     0.200
     6.654    21.176     0.200
     6.736    20.597     0.200
     6.983    22.001     0.200
     7.219    21.048     0.200
     7.668    23.987     0.200
     8.417    24.168     0.200
     8.755    24.684     0.200
    12.106    31.953     0.200
    12.110    31.431     0.200
     2.652    12.999     0.200
     2.800    12.843     0.200
     3.141    14.054     0.200
     3.193    13.759     0.200
     3.300    14.290     0.200
     3.483    15.143     0.200
     3.497    14.765     0.200
     3.560    14.234     0.200
     3.565    15.060     0.200
     3.571    15.490     0.200
     3.675    15.010     0.200
     3.758    15.433     0.200
     3.927    16.608     0.200
     3.927    17.038     0.200
     4.060    16.120     0.200
     4.149    15.971     0.200
     4.225    16.793     0.200
     4.248    15.658     0.200
     4.459    18.697     0.200
     4.628    17.916     0.200
     4.669    17.244     0.200
     4.929    18.259     0.200
     4.982    18.259     0.200
     5.090    19.135     0.200
     5.090    18.901     0.200
     5.190    18.192     0.200
     5.344    19.170     0.200
     5.403    18.892     0.200
     5.542    19.189     0.200
     5.662    19.592     0.200
     5.719    20.567     0.200
     5.765    20.398     0.200
     5.796    18.487     0.200
     5.796    17.975     0.200
     5.799    18.821     0.200
     6.015    20.545     0.200
     6.139    20.737     0.200
     6.210    19.736     0.200
     6.242    21.157     0.200
     6.318    21.698     0.200
     6.439    20.934     0.200
     6.618    21.577     0.200
     6.658    21.378     0.200
     6.660    21.576     0.200
     6.740    21.229     0.200
     6.845    21.676     0.200
     6.882    22.597     0.200
     7.133    21.818     0.200
     7.231    21.270     0.200
     7.650    24.103     0.200
     8.121    22.691     0.200
     8.211    24.365     0.200
     8.364    25.047     0.200
     8.414    27.495     0.200
     8.414    24.277     0.200
     8.463    24.773     0.200
     8.569    25.815     0.200
     8.569    24.788     0.200
     8.569    25.667     0.200
     8.561    25.210     0.200
     8.745    25.114     0.200
    10.144    30.176     0.200
    12.092    32.145     0.200
    12.092    33.255     0.200
    12.096    31.747     0.200
     2.530    13.588     0.200
     2.639    13.673     0.200
     2.819    13.639     0.200
     3.179    13.846     0.200
     3.121    14.768     0.200
     3.284    15.078     0.200
     3.779    15.837     0.200
     3.910    17.631     0.200
     3.910    17.780     0.200
     4.040    16.892     0.200
     4.129    17.183     0.200
     4.207    17.667     0.200
     4.652    18.152     0.200
     4.912    18.964     0.200
     6.119    21.246     0.200
     6.419    22.102     0.200
     7.631    25.097     0.200
     1.847    11.732     0.200
     1.884    11.530     0.200
     2.071    12.498     0.200
     2.295    13.682     0.200
     2.326    11.984     0.200
     2.575    13.217     0.200
     2.584    12.973     0.200
     2.942    15.216     0.200
     3.087    13.358     0.200
     3.165    14.054     0.200
     3.287    16.878     0.200
     3.327    15.050     0.200
     3.432    14.984     0.200
     3.745    15.371     0.200
     3.745    15.710     0.200
     3.872    15.929     0.200
     3.951    16.543     0.200
     4.072    16.484     0.200
     4.521    18.543     0.200
     4.521    16.883     0.200
     4.843    18.549     0.200
     5.067    18.622     0.200
     5.587    20.057     0.200
     5.964    20.466     0.200
    11.011    29.892     0.200
    11.622    31.395     0.200
     2.539    12.342     0.200
     2.792    12.127     0.200
     2.696    12.384     0.200
     2.714    12.463     0.200
     2.924    12.882     0.200
     2.946    14.162     0.200
     3.305    13.892     0.200
     3.945    16.190     0.200
     4.072    14.796     0.200
     4.164    16.474     0.200
     4.423    16.527     0.200
     4.490    16.634     0.200
     4.732    16.883     0.200
     5.087    17.376     0.200
     5.087    17.064     0.200
     4.987    18.619     0.200
     5.039    16.118     0.200
     5.257    17.222     0.200
     5.193    17.528     0.200
     5.404    17.055     0.200
     5.566    19.159     0.200
     5.723    19.054     0.200
     5.797    18.227     0.200
     5.776    20.394     0.200
     6.148    19.289     0.200
     6.162    17.013     0.200
     6.184    19.578     0.200
     6.246    18.857     0.200
     6.448    20.521     0.200
     6.723    20.435     0.200
     6.988    21.207     0.200
     7.225    21.388     0.200
     7.814    21.678     0.200
     8.107    23.618     0.200
     8.420    23.493     0.200
     8.587    25.013     0.200
     1.807    11.222     0.200
     1.899    11.037     0.200
     1.919    11.462     0.200
     2.208    11.046     0.200
     2.346    12.108     0.200
     2.117    11.654     0.200
     2.238    12.033     0.200
     3.140    14.167     0.200
     3.433    14.808     0.200
     1.855    10.995     0.200
     1.855    11.148     0.200
     1.960    10.645     0.200
     1.978    10.647     0.200
     2.057    11.053     0.200
     2.076    10.960     0.200
     2.131    11.846     0.200
     2.136    10.743     0.200
     2.418    12.662     0.200
     2.439    11.453     0.200
     2.491    11.503     0.200
     2.534    11.714     0.200
     2.534    11.835     0.200
     2.530    11.539     0.200
     2.986    12.358     0.200
     3.121    12.564     0.200
     3.315    13.581     0.200
     4.030    14.635     0.200
     4.030    15.525     0.200
     4.067    14.948     0.200
     4.124    14.834     0.200
     4.446    16.829     0.200
     2.255    12.388     0.200
     2.356    13.299     0.200
     2.612    12.628     0.200
     3.203    15.280     0.200
     3.876    17.060     0.200
     3.876    16.730     0.200
     4.571    17.379     0.200
     4.651    15.829     0.200
     5.095    18.251     0.200
     2.025    10.495     0.200
     2.021    11.564     0.200
     2.042    11.241     0.200
     2.139    11.138     0.200
     2.152    10.883     0.200
     2.299    11.170     0.200
     2.312    11.655     0.200
     2.400    10.932     0.200
     2.417    11.956     0.200
     2.507    11.658     0.200
     2.564    12.118     0.200
     2.777    12.367     0.200
     3.065    12.828     0.200
     3.156    13.438     0.200
     3.334    14.232     0.200
     3.898    15.445     0.200
     3.941    15.157     0.200
     3.941    14.147     0.200
     4.052    14.868     0.200
     4.083    15.531     0.200
     4.527    15.978     0.200
     4.663    16.989     0.200
     4.838    18.015     0.200
     5.044    17.178     0.200
     5.236    17.747     0.200
     6.006    18.029     0.200
     7.099    19.734     0.200
     1.843    10.680     0.200
     2.065    12.394     0.200
     2.106    11.440     0.200
     2.192    11.776     0.200
     2.270    12.403     0.200
     2.306    12.807     0.200
     2.338    11.973     0.200
     2.374    12.612     0.200
     2.912    13.054     0.200
     2.912    11.834     0.200
     3.063    13.321     0.200
     3.085    13.151     0.200
     3.189    13.772     0.200
     3.189    13.464     0.200
     3.293    13.545     0.200
     3.364    14.372     0.200
     3.387    15.268     0.200
     3.485    15.728     0.200
     3.485    15.009     0.200
     3.564    14.320     0.200
     3.857    14.793     0.200
     3.881    16.056     0.200
     3.956    15.732     0.200
     4.058    16.509     0.200
     4.058    15.189     0.200
     4.112    15.792     0.200
     4.319    17.449     0.200
     4.516    16.681     0.200
     4.557    17.063     0.200
     4.653    17.568     0.200
     4.870    19.046     0.200
     5.201    17.887     0.200
     5.201    17.765     0.200
     5.448    18.829     0.200
     5.608    21.262     0.200
     5.700    21.340     0.200
     5.988    20.050     0.200
     6.326    21.010     0.200
     6.874    23.370     0.200
     7.143    20.524     0.200
     7.578    23.624     0.200
     8.470    26.040     0.200
     8.518    25.194     0.200
     8.550    24.438     0.200
     8.550    24.198     0.200
    11.205    30.144     0.200
    12.168    30.349     0.200
    12.173    31.145     0.200
    12.173    31.040     0.200
     2.027    12.403     0.200
     2.042    13.698     0.200
     2.094    12.702     0.200
     2.180    12.545     0.200
     2.211    13.995     0.200
     2.253    13.341     0.200
     2.300    12.771     0.200
     2.325    13.081     0.200
     2.342    12.796     0.200
     2.384    13.279     0.200
     2.529    13.803     0.200
     2.572    14.206     0.200
     2.736    13.756     0.200
     2.762    12.985     0.200
     2.772    13.704     0.200
     3.147    14.833     0.200
     3.110    15.712     0.200
     3.110    16.654     0.200
     3.531    16.371     0.200
     3.646    16.310     0.200
     3.858    16.954     0.200
     3.858    17.355     0.200
     3.959    17.180     0.200
     4.137    16.690     0.200
     4.137    18.059     0.200
     4.276    17.813     0.200
     4.661    18.126     0.200
     4.987    19.255     0.200
     5.022    18.260     0.200
     2.037    12.860     0.200
     2.023    12.787     0.200
     2.127    12.825     0.200
     2.169    12.994     0.200
     2.314    13.143     0.200
     2.303    13.563     0.200
     2.379    14.689     0.200
     2.385    13.655     0.200
     2.520    14.084     0.200
     2.564    13.838     0.200
     2.952    14.045     0.200
     3.016    15.185     0.200
     3.016    14.804     0.200
     3.327    15.999     0.200
     3.334    16.610     0.200
     3.340    15.121     0.200
     2.325    12.905     0.200
     3.982    16.582     0.200
     2.048    10.944     0.200
     2.076    11.290     0.200
     2.146    11.610     0.200
     2.163    11.642     0.200
     2.310    11.556     0.200
     2.400    12.106     0.200
     2.405    12.193     0.200
     2.405    12.412     0.200
     2.573    11.979     0.200
     2.811    13.606     0.200
     2.931    12.199     0.200
     2.931    13.324     0.200
     3.063    12.957     0.200
     3.063    13.449     0.200
     3.066    12.333     0.200
     3.058    12.451     0.200
     3.164    13.775     0.200
     3.164    13.541     0.200
     3.342    13.692     0.200
     3.379    14.517     0.200
     3.312    12.790     0.200
     3.425    14.596     0.200
     3.435    15.478     0.200
     3.707    14.980     0.200
     3.750    15.248     0.200
     3.892    16.143     0.200
     3.892    15.752     0.200
     4.020    15.614     0.200
     4.053    15.254     0.200
     4.091    14.955     0.200
     4.315    15.514     0.200
     4.351    15.925     0.200
     4.492    15.073     0.200
     4.535    16.315     0.200
     4.659    15.655     0.200
     4.794    16.933     0.200
     5.054    16.976     0.200
     5.693    18.139     0.200
     5.826    19.412     0.200
     5.885    19.124     0.200
     6.044    19.424     0.200
     6.312    19.887     0.200
     6.583    21.543     0.200
     6.605    21.197     0.200
     7.052    21.531     0.200
     7.112    20.670     0.200
     7.587    23.365     0.200
     8.281    23.347     0.200
     8.465    23.740     0.200
     2.144    12.243     0.200
     2.169    12.956     0.200
     2.169    12.686     0.200
     2.175    11.752     0.200
     2.180    12.216     0.200
     2.267    12.386     0.200
     2.267    12.642     0.200
     2.326    12.565     0.200
     2.326    12.387     0.200
     2.417    12.718     0.200
     2.508    12.872     0.200
     2.522    13.215     0.200
     2.537    13.980     0.200
     2.537    13.525     0.200
     2.625    14.157     0.200
     2.670    12.934     0.200
     2.691    13.112     0.200
     2.691    12.907     0.200
     2.810    13.084     0.200
     2.863    13.716     0.200
     2.932    14.536     0.200
     2.932    14.248     0.200
     3.162    14.907     0.200
     3.162    15.606     0.200
     3.168    13.777     0.200
     3.165    14.832     0.200
     3.165    14.381     0.200
     3.190    14.406     0.200
     3.282    14.193     0.200
     3.462    15.460     0.200
     3.462    14.972     0.200
     3.463    15.646     0.200
     3.463    15.141     0.200
     3.532    15.134     0.200
     3.547    15.835     0.200
     3.629    16.246     0.200
     3.829    16.694     0.200
     3.829    16.533     0.200
     3.960    17.090     0.200
     3.960    16.947     0.200
     4.063    17.410     0.200
     4.063    16.552     0.200
     4.115    16.705     0.200
     4.162    17.620     0.200
     4.211    16.706     0.200
     4.422    17.624     0.200
     4.422    17.837     0.200
     4.440    17.971     0.200
     4.609    17.785     0.200
     4.654    17.408     0.200
     4.654    17.251     0.200
     4.697    17.928     0.200
     4.697    17.764     0.200
     4.743    18.959     0.200
     4.743    18.156     0.200
     4.799    17.657     0.200
     4.799    17.366     0.200
     4.811    19.026     0.200
     4.914    18.653     0.200
     4.965    18.976     0.200
     5.144    18.894     0.200
     5.286    18.689     0.200
     5.550    20.585     0.200
     6.134    20.466     0.200
     6.222    20.660     0.200
     6.433    20.977     0.200
     6.848    21.892     0.200
     7.192    22.404     0.200
     7.344    22.416     0.200
     7.663    22.981     0.200
     7.674    23.467     0.200
     7.738    23.305     0.200
     7.992    25.079     0.200
     2.367    13.300     0.200
     2.310    13.289     0.200
     2.429    14.271     0.200
     2.779    13.448     0.200
     3.981    17.499     0.200
     1.960    12.462     0.200
     2.159    12.536     0.200
     2.159    12.650     0.200
     2.300    12.457     0.200
     2.432    13.196     0.200
     2.451    13.881     0.200
     2.556    13.209     0.200
     2.584    14.476     0.200
     2.716    13.559     0.200
     2.778    13.244     0.200
     2.778    12.824     0.200
     2.814    14.884     0.200
     2.907    13.911     0.200
     2.966    14.599     0.200
     2.966    14.378     0.200
     3.157    13.760     0.200
     3.210    14.306     0.200
     3.210    14.226     0.200
     3.214    14.635     0.200
     3.242    15.580     0.200
     3.305    14.249     0.200
     3.307    14.730     0.200
     3.492    14.261     0.200
     3.509    15.696     0.200
     3.509    15.266     0.200
     3.567    15.657     0.200
     3.652    16.234     0.200
     3.863    16.924     0.200
     3.911    18.504     0.200
     4.008    16.811     0.200
     4.008    17.094     0.200
     4.208    18.165     0.200
     4.208    17.965     0.200
     4.469    17.610     0.200
     4.469    18.137     0.200
     4.485    15.835     0.200
     4.484    17.223     0.200
     4.634    16.218     0.200
     4.684    18.163     0.200
     4.683    17.589     0.200
     4.732    17.882     0.200
     4.792    16.700     0.200
     4.850    17.141     0.200
     5.091    17.257     0.200
     5.091    17.082     0.200
     5.091    17.912     0.200
     5.189    17.619     0.200
     5.594    17.714     0.200
     5.851    19.216     0.200
     5.851    18.225     0.200
     7.190    20.866     0.200
     7.190    21.477     0.200
     7.695    23.015     0.200
     7.723    24.382     0.200
     7.729    23.663     0.200
     7.764    24.242     0.200
     8.653    26.336     0.200
    12.148    31.227     0.200
     2.203    12.755     0.200
     2.304    12.885     0.200
     3.874    16.372     0.200
     5.135    17.522     0.200
     2.093    11.538     0.200
     2.108    12.405     0.200
     2.108    11.999     0.200
     2.131    11.535     0.200
     2.207    12.055     0.200
     2.219    11.759     0.200
     2.235    11.311     0.200
     2.264    12.065     0.200
     2.264    12.378     0.200
     2.348    13.305     0.200
     2.348    12.493     0.200
     2.348    12.294     0.200
     2.344    13.249     0.200
     2.368    11.947     0.200
     2.461    12.633     0.200
     2.465    11.988     0.200
     2.465    11.855     0.200
     2.478    13.023     0.200
     2.478    12.695     0.200
     2.575    11.632     0.200
     2.618    12.531     0.200
     2.634    12.372     0.200
     2.634    13.173     0.200
     2.755    13.518     0.200
     2.755    13.627     0.200
     2.801    12.949     0.200
     2.871    13.123     0.200
     2.871    13.717     0.200
     2.871    12.320     0.200
     2.871    12.550     0.200
     2.986    12.643     0.200
     3.106    13.547     0.200
     3.106    13.387     0.200
     3.109    13.154     0.200
     3.109    13.529     0.200
     3.116    12.622     0.200
     3.116    13.149     0.200
     3.225    12.743     0.200
     3.225    13.914     0.200
     3.219    14.732     0.200
     3.219    14.841     0.200
     3.251    13.057     0.200
     3.351    13.357     0.200
     3.351    13.557     0.200
     3.403    14.704     0.200
     3.403    14.875     0.200
     3.403    13.698     0.200
     3.403    14.385     0.200
     3.432    14.693     0.200
     3.483    13.238     0.200
     3.494    13.901     0.200
     3.528    14.910     0.200
     3.599    14.213     0.200
     3.637    15.490     0.200
     3.637    15.861     0.200
     3.767    15.996     0.200
     3.810    14.891     0.200
     3.810    14.523     0.200
     3.812    14.312     0.200
     3.849    16.426     0.200
     3.917    16.253     0.200
     3.917    16.382     0.200
     3.950    14.485     0.200
     4.001    15.614     0.200
     4.060    15.578     0.200
     4.060    15.773     0.200
     4.102    16.276     0.200
     4.152    15.908     0.200
     4.152    16.053     0.200
     4.317    16.743     0.200
     4.317    16.259     0.200
     4.348    16.622     0.200
     4.348    17.524     0.200
     4.363    15.819     0.200
     4.363    16.002     0.200
     4.379    16.404     0.200
     4.379    16.209     0.200
     4.411    15.894     0.200
     4.394    15.637     0.200
     4.394    15.418     0.200
     4.552    17.143     0.200
     4.552    17.498     0.200
     4.596    16.530     0.200
     4.596    16.909     0.200
     4.636    17.461     0.200
     4.636    16.699     0.200
     4.673    17.764     0.200
     4.742    16.949     0.200
     4.742    17.355     0.200
     4.749    17.631     0.200
     4.749    17.408     0.200
     4.855    17.090     0.200
     4.907    17.860     0.200
     4.963    15.505     0.200
     4.963    16.325     0.200
     5.083    18.665     0.200
     5.083    18.185     0.200
     5.114    17.600     0.200
     5.114    17.835     0.200
     5.167    17.693     0.200
     5.167    17.853     0.200
     5.205    18.463     0.200
     5.226    17.513     0.200
     5.247    18.069     0.200
     5.247    19.205     0.200
     5.247    18.979     0.200
     5.326    17.466     0.200
     5.332    17.339     0.200
     5.332    17.632     0.200
     5.403    19.378     0.200
     5.424    18.811     0.200
     5.424    19.179     0.200
     5.488    19.361     0.200
     5.491    19.321     0.200
     5.543    18.961     0.200
     5.646    19.517     0.200
     5.646    18.716     0.200
     5.624    19.616     0.200
     5.624    19.155     0.200
     5.669    20.299     0.200
     5.745    18.675     0.200
     5.745    17.847     0.200
     5.786    18.279     0.200
     5.807    18.695     0.200
     5.818    18.343     0.200
     5.881    20.843     0.200
     5.939    18.878     0.200
     6.032    19.882     0.200
     6.032    19.761     0.200
     6.072    19.664     0.200
     6.072    19.934     0.200
     6.161    20.201     0.200
     6.157    20.593     0.200
     6.242    19.387     0.200
     6.268    21.402     0.200
     6.372    21.363     0.200
     6.548    20.898     0.200
     6.581    21.851     0.200
     6.644    21.627     0.200
     6.644    21.201     0.200
     6.663    20.760     0.200
     6.663    21.088     0.200
     6.742    21.527     0.200
     6.742    21.832     0.200
     6.739    21.312     0.200
     6.751    21.942     0.200
     6.756    20.876     0.200
     6.786    21.394     0.200
     6.786    20.683     0.200
     6.818    21.502     0.200
     6.832    22.246     0.200
     6.832    20.867     0.200
     6.841    22.874     0.200
     6.841    21.389     0.200
     6.914    21.826     0.200
     6.914    21.979     0.200
     6.884    19.636     0.200
     6.916    21.605     0.200
     7.074    21.508     0.200
     7.071    21.707     0.200
     7.108    22.549     0.200
     7.108    22.013     0.200
     7.247    21.540     0.200
     7.277    23.190     0.200
     7.277    22.503     0.200
     7.286    22.309     0.200
     7.284    21.771     0.200
     7.284    21.919     0.200
     7.419    21.926     0.200
     7.419    22.211     0.200
     7.426    22.513     0.200
     7.460    22.554     0.200
     7.602    21.954     0.200
     7.602    22.278     0.200
     7.619    24.524     0.200
     7.619    22.750     0.200
     7.626    23.093     0.200
     7.680    22.765     0.200
     7.680    23.507     0.200
     7.750    21.235     0.200
     7.750    21.543     0.200
     7.827    24.377     0.200
     7.867    23.249     0.200
     7.867    22.893     0.200
     7.930    22.926     0.200
     7.930    24.191     0.200
     7.927    23.636     0.200
     7.949    22.738     0.200
     7.963    24.033     0.200
     7.981    22.346     0.200
     7.981    23.975     0.200
     8.045    23.639     0.200
     8.105    24.338     0.200
     8.114    23.346     0.200
     8.114    23.690     0.200
     8.179    25.813     0.200
     8.179    24.610     0.200
     8.246    24.563     0.200
     8.342    23.030     0.200
     8.342    24.202     0.200
     8.408    24.963     0.200
     8.514    25.628     0.200
     8.514    24.870     0.200
     8.514    25.163     0.200
     8.491    25.160     0.200
     8.554    23.120     0.200
     8.578    24.732     0.200
     8.578    26.611     0.200
     8.613    24.784     0.200
     8.686    25.483     0.200
     8.820    24.784     0.200
     8.843    26.617     0.200
     9.083    25.605     0.200
     9.228    26.341     0.200
     9.351    26.274     0.200
     9.538    28.303     0.200
     9.548    26.601     0.200
     9.641    28.510     0.200
     9.663    27.506     0.200
    10.031    27.933     0.200
    10.672    28.540     0.200
    11.287    29.604     0.200
    11.287    29.253     0.200
    12.163    30.525     0.200
    13.147    33.439     0.200
    17.598    40.091     0.200
     2.097    13.116     0.200
     2.254    14.298     0.200
     2.766    12.820     0.200
     3.183    13.858     0.200
     3.716    17.115     0.200
     3.856    17.356     0.200
     2.255    12.048     0.200
     2.329    12.342     0.200
     2.327    12.264     0.200
     2.460    12.544     0.200
     2.740    13.293     0.200
     2.784    12.270     0.200
     2.858    13.099     0.200
     3.012    13.913     0.200
     3.012    13.788     0.200
     3.090    13.521     0.200
     3.320    13.608     0.200
     3.353    12.870     0.200
     3.385    15.150     0.200
     3.392    14.159     0.200
     3.628    15.254     0.200
     3.794    15.856     0.200
     3.898    15.518     0.200
     4.665    17.416     0.200
     4.665    17.209     0.200
     1.821    10.002     0.200
     2.195    10.986     0.200
     2.277    11.584     0.200
     2.349    11.845     0.200
     2.346    11.792     0.200
     2.346    11.093     0.200
     2.449    11.629     0.200
     2.472    12.105     0.200
     2.763    12.634     0.200
     2.763    12.341     0.200
     2.794    12.052     0.200
     2.859    12.430     0.200
     2.883    11.238     0.200
     3.001    11.640     0.200
     3.034    13.326     0.200
     3.263    12.857     0.200
     3.366    12.459     0.200
     3.366    12.788     0.200
     3.366    12.057     0.200
     3.390    14.014     0.200
     3.650    14.353     0.200
     3.756    14.237     0.200
     3.817    15.286     0.200
     3.918    14.890     0.200
     4.139    15.224     0.200
     4.409    15.426     0.200
     4.686    16.807     0.200
     4.686    16.694     0.200
     4.901    15.708     0.200
     4.901    16.321     0.200
     5.181    17.678     0.200
     2.224    12.525     0.200
     2.264    12.927     0.200
     2.394    13.002     0.200
     2.686    13.808     0.200
     2.723    13.041     0.200
     2.814    13.531     0.200
     2.929    13.473     0.200
     2.949    14.523     0.200
     3.014    12.984     0.200
     3.014    12.820     0.200
     3.023    14.303     0.200
     3.308    14.334     0.200
     3.354    14.347     0.200
     3.360    13.651     0.200
     3.360    13.549     0.200
     3.732    16.255     0.200
     3.732    16.396     0.200
     3.831    16.120     0.200
     4.636    17.917     0.200
     1.806    10.335     0.200
     2.038    12.069     0.200
     2.104    11.486     0.200
     2.142    11.685     0.200
     2.265    12.094     0.200
     2.241    12.195     0.200
     2.274    12.534     0.200
     2.286    11.998     0.200
     2.331    11.949     0.200
     2.394    12.083     0.200
     2.395    12.323     0.200
     2.721    12.788     0.200
     2.699    13.295     0.200
     2.699    13.084     0.200
     2.937    13.663     0.200
     2.937    12.102     0.200
     2.960    14.206     0.200
     3.022    13.341     0.200
     3.025    13.570     0.200
     3.025    13.099     0.200
     3.027    11.798     0.200
     3.075    13.361     0.200
     3.171    13.698     0.200
     3.171    13.118     0.200
     3.190    14.561     0.200
     3.190    13.971     0.200
     3.321    14.233     0.200
     3.343    13.961     0.200
     3.319    13.492     0.200
     3.325    14.050     0.200
     3.376    13.332     0.200
     3.376    12.772     0.200
     3.614    15.724     0.200
     3.743    16.259     0.200
     3.791    15.466     0.200
     3.791    15.735     0.200
     3.839    15.766     0.200
     3.839    15.456     0.200
     3.977    15.656     0.200
     3.977    15.096     0.200
     4.020    16.167     0.200
     4.280    16.158     0.200
     4.297    16.355     0.200
     4.611    17.051     0.200
     4.658    16.913     0.200
     4.652    17.574     0.200
     5.461    18.642     0.200
     6.076    20.136     0.200
     2.243    13.293     0.200
     2.373    14.609     0.200
     2.404    14.267     0.200
     2.541    14.549     0.200
     2.943    14.295     0.200
     3.058    16.352     0.200
     3.295    14.412     0.200
     3.474    15.237     0.200
     3.838    17.266     0.200
     3.838    17.741     0.200
     3.957    16.811     0.200
     3.957    17.497     0.200
     4.223    17.897     0.200
     1.888    10.409     0.200
     1.903    10.152     0.200
     1.908    10.235     0.200
     2.129    11.566     0.200
     2.139    10.867     0.200
     2.226    11.187     0.200
     2.230    10.859     0.200
     2.220    11.261     0.200
     2.272    11.364     0.200
     2.272    11.583     0.200
     2.366    11.717     0.200
     2.379    11.198     0.200
     2.481    11.608     0.200
     2.503    11.310     0.200
     2.772    12.406     0.200
     2.772    12.277     0.200
     2.826    11.972     0.200
     2.826    12.079     0.200
     2.764    12.231     0.200
     2.891    12.410     0.200
     2.891    12.761     0.200
     2.851    11.207     0.200
     2.851    11.518     0.200
     2.974    11.951     0.200
     3.051    13.448     0.200
     3.051    13.263     0.200
     3.134    13.732     0.200
     3.134    13.160     0.200
     3.229    13.413     0.200
     3.176    12.329     0.200
     3.231    12.200     0.200
     3.323    13.184     0.200
     3.344    12.564     0.200
     3.421    13.954     0.200
     3.645    14.594     0.200
     3.645    14.760     0.200
     3.788    14.215     0.200
     3.788    15.413     0.200
     3.833    15.307     0.200
     3.867    14.125     0.200
     3.867    15.586     0.200
     3.870    13.902     0.200
     3.959    14.113     0.200
     4.085    14.561     0.200
     4.085    14.738     0.200
     4.170    15.156     0.200
     4.388    16.306     0.200
     4.691    17.317     0.200
     4.680    16.574     0.200
     4.680    16.851     0.200
     4.767    17.373     0.200
     5.251    18.345     0.200
     5.301    18.926     0.200
     5.301    19.116     0.200
     5.332    18.170     0.200
     5.332    18.334     0.200
     5.332    18.840     0.200
     5.449    18.255     0.200
     5.568    18.478     0.200
     5.568    18.876     0.200
     6.153    19.848     0.200
     6.153    19.623     0.200
     6.182    19.347     0.200
     7.022    20.857     0.200
     1.816    11.488     0.200
     1.837    10.951     0.200
     1.918    11.406     0.200
     1.917    11.367     0.200
     1.921    11.504     0.200
     1.939    11.698     0.200
     2.184    12.092     0.200
     2.170    12.383     0.200
     2.270    12.916     0.200
     2.267    11.991     0.200
     2.336    12.543     0.200
     2.392    13.317     0.200
     2.392    12.750     0.200
     2.392    14.008     0.200
     2.411    11.556     0.200
     2.412    12.073     0.200
     2.522    12.969     0.200
     2.544    13.623     0.200
     2.544    13.279     0.200
     2.544    14.201     0.200
     2.722    13.116     0.200
     2.811    13.037     0.200
     2.811    12.908     0.200
     2.788    13.951     0.200
     2.788    14.439     0.200
     2.868    13.450     0.200
     2.868    14.099     0.200
     2.942    13.306     0.200
     2.932    13.746     0.200
     2.935    14.409     0.200
     3.029    14.742     0.200
     3.077    14.857     0.200
     3.077    15.220     0.200
     3.135    14.163     0.200
     3.135    13.972     0.200
     3.190    14.585     0.200
     3.162    13.817     0.200
     3.162    12.942     0.200
     3.170    14.601     0.200
     3.174    14.649     0.200
     3.174    14.778     0.200
     3.230    14.666     0.200
     3.230    15.006     0.200
     3.230    15.318     0.200
     3.309    13.682     0.200
     3.309    14.386     0.200
     3.318    13.232     0.200
     3.318    13.693     0.200
     3.318    13.361     0.200
     3.279    13.635     0.200
     3.279    14.232     0.200
     3.460    15.246     0.200
     3.469    14.777     0.200
     3.469    15.367     0.200
     3.542    13.815     0.200
     3.667    14.856     0.200
     3.667    16.672     0.200
     3.643    15.823     0.200
     3.746    17.903     0.200
     3.835    15.322     0.200
     3.835    15.213     0.200
     3.829    16.470     0.200
     3.858    16.546     0.200
     3.858    16.925     0.200
     3.859    14.444     0.200
     3.885    15.712     0.200
     3.972    17.054     0.200
     3.988    15.523     0.200
     3.988    15.715     0.200
     4.066    15.254     0.200
     4.066    15.559     0.200
     4.124    16.062     0.200
     4.124    16.832     0.200
     4.124    15.652     0.200
     4.210    16.160     0.200
     4.352    16.189     0.200
     4.352    15.790     0.200
     4.374    15.837     0.200
     4.374    16.665     0.200
     4.399    16.172     0.200
     4.429    17.227     0.200
     4.459    15.350     0.200
     4.459    16.490     0.200
     4.606    17.703     0.200
     4.676    18.137     0.200
     4.652    16.845     0.200
     4.713    18.424     0.200
     4.713    18.873     0.200
     4.698    17.355     0.200
     4.832    17.743     0.200
     4.832    17.173     0.200
     4.807    17.356     0.200
     4.807    18.399     0.200
     4.813    17.026     0.200
     4.813    17.909     0.200
     4.962    19.844     0.200
     5.117    18.092     0.200
     5.117    17.205     0.200
     5.145    18.830     0.200
     5.164    16.960     0.200
     5.164    18.124     0.200
     5.267    19.077     0.200
     5.299    19.638     0.200
     5.299    19.142     0.200
     5.299    20.189     0.200
     5.292    18.414     0.200
     5.292    18.852     0.200
     5.325    19.772     0.200
     5.325    20.526     0.200
     5.365    20.326     0.200
     5.365    19.631     0.200
     5.365    20.186     0.200
     5.370    17.978     0.200
     5.488    19.857     0.200
     5.488    19.963     0.200
     5.555    19.213     0.200
     5.555    19.025     0.200
     5.604    19.729     0.200
     5.604    19.924     0.200
     5.604    20.428     0.200
     5.661    18.860     0.200
     5.752    17.573     0.200
     5.696    20.748     0.200
     5.705    20.463     0.200
     5.812    18.078     0.200
     5.812    19.738     0.200
     5.947    19.827     0.200
     5.983    19.368     0.200
     6.098    20.044     0.200
     6.098    21.157     0.200
     6.135    20.227     0.200
     6.135    21.207     0.200
     6.154    19.687     0.200
     6.173    20.209     0.200
     6.173    21.889     0.200
     6.173    22.959     0.200
     6.217    20.103     0.200
     6.217    21.736     0.200
     6.218    19.471     0.200
     6.292    18.592     0.200
     6.335    20.982     0.200
     6.343    20.768     0.200
     6.343    22.346     0.200
     6.406    21.645     0.200
     6.434    20.529     0.200
     6.589    20.981     0.200
     6.589    22.469     0.200
     6.703    21.780     0.200
     6.703    22.601     0.200
     6.727    21.359     0.200
     6.727    22.218     0.200
     6.784    21.260     0.200
     6.785    22.166     0.200
     6.799    22.610     0.200
     6.799    22.427     0.200
     6.809    22.558     0.200
     6.848    23.293     0.200
     6.859    19.821     0.200
     6.886    23.012     0.200
     6.908    21.356     0.200
     6.952    23.378     0.200
     7.048    23.510     0.200
     7.137    23.587     0.200
     7.317    22.360     0.200
     7.317    23.036     0.200
     7.312    23.402     0.200
     7.342    22.652     0.200
     7.342    23.262     0.200
     7.466    22.689     0.200
     7.480    23.709     0.200
     7.526    23.715     0.200
     7.662    22.541     0.200
     7.662    23.635     0.200
     7.689    24.325     0.200
     7.685    23.958     0.200
     7.735    23.934     0.200
     7.770    21.204     0.200
     7.770    22.942     0.200
     7.890    24.863     0.200
     7.908    22.785     0.200
     7.908    24.320     0.200
     7.991    23.022     0.200
     7.991    24.901     0.200
     7.993    23.742     0.200
     7.993    24.796     0.200
     7.998    22.828     0.200
     7.998    25.379     0.200
     8.076    22.982     0.200
     8.161    24.261     0.200
     8.186    25.240     0.200
     8.244    25.256     0.200
     8.312    25.272     0.200
     8.399    23.975     0.200
     8.526    25.646     0.200
     8.592    25.147     0.200
     8.622    24.415     0.200
     8.636    27.348     0.200
     8.834    24.492     0.200
     8.834    25.640     0.200
     8.862    26.831     0.200
     8.909    26.472     0.200
     8.909    27.183     0.200
     8.997    28.014     0.200
     9.121    27.834     0.200
     9.398    26.272     0.200
     1.801    10.192     0.200
     1.876    10.662     0.200
     1.899    10.226     0.200
     2.105    10.988     0.200
     2.121    11.716     0.200
     2.121    11.448     0.200
     2.141    11.110     0.200
     2.220    11.750     0.200
     2.262    11.684     0.200
     2.350    11.585     0.200
     2.350    11.465     0.200
     2.351    11.909     0.200
     2.379    11.691     0.200
     2.474    11.728     0.200
     2.490    12.107     0.200
     2.587    12.325     0.200
     2.629    11.716     0.200
     2.646    11.686     0.200
     2.646    12.079     0.200
     2.774    14.552     0.200
     2.759    12.437     0.200
     2.759    12.657     0.200
     2.759    12.550     0.200
     2.815    11.933     0.200
     2.815    12.046     0.200
     2.884    13.078     0.200
     3.037    13.449     0.200
     3.037    13.580     0.200
     3.118    12.417     0.200
     3.121    14.026     0.200
     3.218    13.986     0.200
     3.317    13.222     0.200
     3.317    13.392     0.200
     3.341    12.916     0.200
     3.341    12.486     0.200
     3.416    14.113     0.200
     3.416    13.645     0.200
     3.416    14.307     0.200
     3.445    14.809     0.200
     3.506    15.043     0.200
     3.635    15.019     0.200
     3.635    14.900     0.200
     3.781    15.048     0.200
     3.819    15.137     0.200
     3.819    15.517     0.200
     3.853    15.549     0.200
     3.853    15.232     0.200
     3.872    15.278     0.200
     3.926    14.996     0.200
     4.072    14.951     0.200
     4.072    14.810     0.200
     4.165    15.665     0.200
     4.376    16.311     0.200
     4.565    16.256     0.200
     4.609    16.938     0.200
     4.670    17.026     0.200
     4.670    16.844     0.200
     4.676    17.576     0.200
     4.676    17.475     0.200
     4.754    17.317     0.200
     5.255    18.192     0.200
     5.255    19.132     0.200
     5.287    19.036     0.200
     5.287    19.156     0.200
     5.318    18.101     0.200
     5.318    18.841     0.200
     5.436    17.935     0.200
     5.554    18.984     0.200
     6.110    19.557     0.200
     6.110    19.329     0.200
     6.138    20.155     0.200
     6.168    19.785     0.200
     7.182    21.671     0.200
     1.821    11.896     0.200
     1.867    12.298     0.200
     1.931    11.511     0.200
     1.894    12.058     0.200
     2.048    12.912     0.200
     2.056    11.264     0.200
     2.074    13.724     0.200
     2.074    13.173     0.200
     2.079    13.379     0.200
     2.127    13.056     0.200
     2.128    12.906     0.200
     2.219    13.996     0.200
     2.297    12.866     0.200
     2.329    13.541     0.200
     2.330    12.907     0.200
     2.353    13.261     0.200
     2.473    13.370     0.200
     2.528    13.520     0.200
     2.530    13.767     0.200
     2.524    14.316     0.200
     2.524    14.636     0.200
     2.552    13.157     0.200
     2.563    13.731     0.200
     2.710    14.536     0.200
     2.764    14.828     0.200
     2.764    14.228     0.200
     2.836    14.676     0.200
     2.840    14.710     0.200
     3.056    14.123     0.200
     3.024    15.219     0.200
     3.046    14.201     0.200
     3.046    14.451     0.200
     3.061    15.352     0.200
     3.061    15.192     0.200
     3.064    13.827     0.200
     3.064    14.243     0.200
     3.064    14.536     0.200
     3.116    14.166     0.200
     3.153    14.096     0.200
     3.268    15.728     0.200
     3.262    14.808     0.200
     3.262    14.982     0.200
     3.262    14.529     0.200
     3.369    15.047     0.200
     3.369    14.405     0.200
     3.369    14.217     0.200
     3.419    14.877     0.200
     3.435    13.399     0.200
     3.496    16.746     0.200
     3.548    16.829     0.200
     3.597    17.126     0.200
     3.597    16.833     0.200
     3.639    16.870     0.200
     3.639    16.677     0.200
     3.727    15.987     0.200
     3.786    17.021     0.200
     3.930    15.841     0.200
     3.930    16.046     0.200
     4.009    17.337     0.200
     4.009    17.188     0.200
     3.989    16.502     0.200
     4.105    17.562     0.200
     4.105    17.269     0.200
     4.332    17.462     0.200
     4.413    18.433     0.200
     4.413    18.800     0.200
     4.442    17.603     0.200
     4.442    17.818     0.200
     4.460    17.929     0.200
     4.463    17.770     0.200
     4.475    17.555     0.200
     4.475    17.973     0.200
     4.728    18.065     0.200
     4.790    17.555     0.200
     4.971    19.262     0.200
     4.973    20.034     0.200
     4.973    20.456     0.200
     5.025    19.367     0.200
     5.018    19.768     0.200
     5.018    19.987     0.200
     5.029    20.045     0.200
     5.150    21.254     0.200
     5.265    21.127     0.200
     5.268    18.536     0.200
     5.295    19.852     0.200
     5.500    18.670     0.200
     5.500    18.540     0.200
     5.605    19.304     0.200
     5.610    21.109     0.200
     5.699    18.624     0.200
     5.826    20.926     0.200
     5.878    21.893     0.200
     5.882    22.130     0.200
     5.926    19.811     0.200
     5.980    20.933     0.200
     6.716    22.437     0.200
     6.732    23.291     0.200
     6.732    22.660     0.200
     6.773    22.176     0.200
     6.778    23.234     0.200
     6.918    23.762     0.200
     7.206    22.370     0.200
     7.281    23.732     0.200
     7.746    23.648     0.200
     7.981    25.973     0.200
     8.291    24.618     0.200
     1.803    11.106     0.200
     1.824    10.748     0.200
     2.412    12.669     0.200
     2.595    12.255     0.200
     2.708    12.669     0.200
     2.708    13.189     0.200
     2.739    12.650     0.200
     2.821    13.218     0.200
     2.972    14.325     0.200
     3.015    12.248     0.200
     3.015    11.865     0.200
     3.043    13.850     0.200
     3.320    13.994     0.200
     3.358    14.084     0.200
     3.755    15.874     0.200
     3.755    16.050     0.200
     3.854    15.604     0.200
     3.854    15.708     0.200
     3.994    15.441     0.200
     4.616    17.820     0.200
     4.616    18.014     0.200
     5.224    19.779     0.200
     5.244    19.289     0.200
     1.814    12.601     0.200
     1.814    13.187     0.200
     1.906    12.518     0.200
     2.335    14.377     0.200
     2.327    14.607     0.200
     2.382    14.557     0.200
     2.465    14.178     0.200
     2.502    12.982     0.200
     2.771    15.648     0.200
     3.011    16.260     0.200
     3.024    14.930     0.200
     3.272    15.017     0.200
     3.281    15.683     0.200
     3.422    15.899     0.200
     3.796    18.244     0.200
     3.872    17.312     0.200
     3.981    17.469     0.200
     4.662    20.380     0.200
     5.257    20.686     0.200
     5.266    21.070     0.200
     6.064    22.144     0.200
     7.167    24.262     0.200
     1.824    12.529     0.200
     1.861    12.020     0.200
     2.195    13.544     0.200
     2.380    14.231     0.200
     2.555    14.943     0.200
     2.704    13.647     0.200
     2.718    13.499     0.200
     2.784    14.531     0.200
     2.768    14.371     0.200
     2.768    14.715     0.200
     3.065    15.875     0.200
     3.275    14.919     0.200
     3.845    17.368     0.200
     3.967    17.426     0.200
     4.699    19.934     0.200
     5.312    21.590     0.200
     5.362    21.173     0.200
     6.156    23.148     0.200
     1.864    10.937     0.200
     1.864    11.273     0.200
     1.871    10.772     0.200
     1.893    10.366     0.200
     1.893    10.882     0.200
     1.929    10.370     0.200
     1.986    11.618     0.200
     1.989    11.814     0.200
     2.020    10.878     0.200
     2.065    11.719     0.200
     2.084    11.296     0.200
     2.118    11.723     0.200
     2.161    10.981     0.200
     2.260    11.998     0.200
     2.260    11.037     0.200
     2.418    12.387     0.200
     2.466    11.499     0.200
     2.466    10.843     0.200
     2.506    12.242     0.200
     2.573    12.470     0.200
     2.576    12.836     0.200
     2.576    11.907     0.200
     2.651    12.386     0.200
     2.764    12.273     0.200
     2.770    12.115     0.200
     2.805    12.360     0.200
     2.862    12.658     0.200
     2.895    13.025     0.200
     2.906    13.234     0.200
     2.916    12.236     0.200
     2.952    12.767     0.200
     3.192    12.633     0.200
     3.256    13.526     0.200
     3.256    14.448     0.200
     3.252    13.130     0.200
     3.252    13.677     0.200
     3.269    13.373     0.200
     3.269    14.326     0.200
     3.269    14.553     0.200
     3.417    13.329     0.200
     3.414    14.122     0.200
     3.690    14.524     0.200
     4.031    15.914     0.200
     4.181    16.843     0.200
     4.181    16.085     0.200
     4.441    15.326     0.200
     4.612    15.581     0.200
     4.683    16.483     0.200
     4.683    17.194     0.200
     4.873    18.489     0.200
     4.982    16.099     0.200
     5.135    16.802     0.200
     5.492    19.809     0.200
     5.920    18.655     0.200
     1.880    11.980     0.200
     2.224    13.972     0.200
     2.279    14.086     0.200
     2.450    12.723     0.200
     2.681    15.281     0.200
     2.908    15.686     0.200
     3.693    17.329     0.200
     4.562    20.104     0.200
     1.817    10.688     0.200
     1.825    11.169     0.200
     1.825    10.872     0.200
     1.830    10.935     0.200
     1.861    11.233     0.200
     1.861    10.432     0.200
     1.975    11.527     0.200
     1.975    11.414     0.200
     2.078    11.775     0.200
     2.085    11.103     0.200
     2.155    11.641     0.200
     2.219    12.767     0.200
     2.219    12.416     0.200
     2.219    12.595     0.200
     2.229    12.362     0.200
     2.229    12.472     0.200
     2.297    12.016     0.200
     2.323    12.951     0.200
     2.323    12.584     0.200
     2.323    12.771     0.200
     2.334    12.164     0.200
     2.336    11.880     0.200
     2.336    11.700     0.200
     2.385    12.154     0.200
     2.385    11.975     0.200
     2.419    11.914     0.200
     2.419    11.742     0.200
     2.502    12.244     0.200
     2.531    12.428     0.200
     2.531    12.112     0.200
     2.534    12.038     0.200
     2.650    12.913     0.200
     2.650    12.620     0.200
     2.658    13.524     0.200
     2.658    13.192     0.200
     2.658    13.383     0.200
     2.734    13.307     0.200
     2.745    13.474     0.200
     2.745    13.111     0.200
     2.745    13.224     0.200
     2.904    13.884     0.200
     2.904    14.227     0.200
     2.904    14.395     0.200
     2.951    13.797     0.200
     2.954    13.436     0.200
     2.954    13.225     0.200
     2.937    13.235     0.200
     2.937    13.649     0.200
     2.998    11.776     0.200
     2.998    11.495     0.200
     3.036    12.982     0.200
     3.036    12.798     0.200
     3.069    12.601     0.200
     3.069    12.233     0.200
     3.172    14.854     0.200
     3.172    14.674     0.200
     3.249    14.997     0.200
     3.249    14.880     0.200
     3.249    14.759     0.200
     3.289    14.161     0.200
     3.333    14.118     0.200
     3.333    14.224     0.200
     3.327    13.462     0.200
     3.381    13.281     0.200
     3.381    12.710     0.200
     3.407    13.979     0.200
     3.409    12.258     0.200
     3.404    13.512     0.200
     3.404    13.387     0.200
     3.404    13.164     0.200
     3.639    15.165     0.200
     3.639    15.458     0.200
     3.688    16.196     0.200
     3.688    16.329     0.200
     3.719    14.301     0.200
     3.719    14.688     0.200
     3.775    15.967     0.200
     3.855    15.358     0.200
     3.891    14.364     0.200
     3.906    15.576     0.200
     3.906    15.787     0.200
     3.948    15.155     0.200
     3.948    14.925     0.200
     3.963    15.793     0.200
     3.963    15.043     0.200
     3.963    15.196     0.200
     3.981    14.803     0.200
     3.981    14.662     0.200
     3.981    14.361     0.200
     4.035    15.897     0.200
     4.035    15.624     0.200
     4.202    15.774     0.200
     4.209    16.125     0.200
     4.209    16.488     0.200
     4.214    17.081     0.200
     4.214    17.191     0.200
     4.322    16.026     0.200
     4.449    15.429     0.200
     4.449    16.422     0.200
     4.483    16.388     0.200
     4.483    15.916     0.200
     4.472    15.758     0.200
     4.472    15.657     0.200
     4.505    16.233     0.200
     4.505    16.405     0.200
     4.542    17.264     0.200
     4.542    17.495     0.200
     4.552    17.976     0.200
     4.552    17.800     0.200
     4.587    17.120     0.200
     4.587    17.225     0.200
     4.610    17.170     0.200
     4.610    16.936     0.200
     4.745    16.829     0.200
     4.801    17.206     0.200
     4.801    17.343     0.200
     4.896    17.133     0.200
     4.951    17.662     0.200
     5.001    17.301     0.200
     5.021    16.638     0.200
     5.072    18.262     0.200
     5.072    17.673     0.200
     5.111    18.467     0.200
     5.111    18.948     0.200
     5.157    19.596     0.200
     5.157    19.112     0.200
     5.157    19.405     0.200
     5.163    18.594     0.200
     5.163    18.317     0.200
     5.163    18.473     0.200
     5.270    18.901     0.200
     5.270    18.666     0.200
     5.270    19.022     0.200
     5.264    16.752     0.200
     5.264    17.686     0.200
     5.296    18.228     0.200
     5.296    17.939     0.200
     5.393    19.497     0.200
     5.393    19.072     0.200
     5.393    18.329     0.200
     5.527    19.888     0.200
     5.543    18.780     0.200
     5.543    19.546     0.200
     5.593    17.016     0.200
     5.593    18.094     0.200
     5.877    17.177     0.200
     5.884    18.725     0.200
     5.964    20.115     0.200
     5.964    19.846     0.200
     5.995    19.924     0.200
     5.995    19.408     0.200
     6.007    20.172     0.200
     6.067    20.482     0.200
     6.130    18.568     0.200
     6.238    21.191     0.200
     6.524    21.561     0.200
     6.595    22.189     0.200
     6.657    22.503     0.200
     6.671    20.584     0.200
     6.727    21.620     0.200
     6.727    21.101     0.200
     6.851    21.105     0.200
     6.871    21.871     0.200
     6.871    21.535     0.200
     6.918    22.230     0.200
     6.940    21.394     0.200
     7.057    21.641     0.200
     7.057    22.028     0.200
     7.057    22.141     0.200
     7.092    21.905     0.200
     7.137    21.592     0.200
     7.137    20.974     0.200
     7.172    21.378     0.200
     7.235    21.944     0.200
     7.235    22.100     0.200
     7.305    22.481     0.200
     7.305    23.075     0.200
     7.322    21.991     0.200
     7.322    22.280     0.200
     7.472    23.465     0.200
     7.477    22.900     0.200
     7.477    23.056     0.200
     7.572    23.134     0.200
     7.572    22.919     0.200
     7.674    24.409     0.200
     7.674    24.194     0.200
     7.735    21.114     0.200
     7.773    24.044     0.200
     7.773    24.345     0.200
     7.797    22.670     0.200
     7.797    23.858     0.200
     8.091    24.699     0.200
     8.091    25.800     0.200
     8.134    24.040     0.200
     8.333    24.188     0.200
     8.335    23.136     0.200
     8.335    24.902     0.200
     8.539    26.313     0.200
     8.552    24.992     0.200
     8.688    26.596     0.200
     8.688    26.858     0.200
     8.751    24.501     0.200
     8.900    26.623     0.200
     8.992    25.606     0.200
     9.230    25.055     0.200
     9.383    27.075     0.200
     1.815    10.654     0.200
     1.887    10.802     0.200
     1.881    10.850     0.200
     1.864    10.543     0.200
     1.864    10.918     0.200
     2.028    10.916     0.200
     2.114    10.943     0.200
     2.202    10.930     0.200
     2.213    10.837     0.200
     2.284    11.251     0.200
     2.326    12.040     0.200
     2.371    11.950     0.200
     2.338    11.899     0.200
     2.470    11.773     0.200
     2.538    11.229     0.200
     2.538    11.779     0.200
     2.514    12.141     0.200
     2.595    11.550     0.200
     2.595    11.733     0.200
     2.630    12.133     0.200
     2.681    12.830     0.200
     2.680    11.401     0.200
     2.680    12.470     0.200
     2.774    12.034     0.200
     2.891    12.470     0.200
     2.891    13.260     0.200
     2.888    12.124     0.200
     2.888    11.964     0.200
     2.999    12.165     0.200
     2.999    12.865     0.200
     3.038    13.345     0.200
     3.038    13.581     0.200
     3.030    12.876     0.200
     3.199    14.039     0.200
     3.228    13.239     0.200
     3.308    12.960     0.200
     3.311    12.749     0.200
     3.311    13.178     0.200
     3.292    14.270     0.200
     3.292    14.506     0.200
     3.292    12.741     0.200
     3.292    12.506     0.200
     3.322    13.584     0.200
     3.556    13.843     0.200
     3.556    14.014     0.200
     3.547    14.856     0.200
     3.614    14.599     0.200
     3.603    13.463     0.200
     3.630    14.181     0.200
     3.696    15.104     0.200
     3.696    15.265     0.200
     3.766    14.285     0.200
     3.766    14.395     0.200
     3.933    14.257     0.200
     3.933    15.432     0.200
     3.937    14.765     0.200
     3.937    16.290     0.200
     3.978    16.458     0.200
     3.978    16.147     0.200
     3.990    16.671     0.200
     4.034    14.422     0.200
     4.104    16.101     0.200
     4.104    15.804     0.200
     4.262    15.519     0.200
     4.262    15.321     0.200
     4.307    15.565     0.200
     4.301    15.218     0.200
     4.301    14.931     0.200
     4.530    16.423     0.200
     4.565    16.017     0.200
     4.565    17.422     0.200
     4.578    15.854     0.200
     4.746    15.971     0.200
     4.744    16.051     0.200
     4.807    16.984     0.200
     4.829    17.791     0.200
     4.829    18.342     0.200
     4.889    17.122     0.200
     4.931    18.288     0.200
     4.945    16.820     0.200
     4.945    17.114     0.200
     5.002    18.270     0.200
     5.238    18.763     0.200
     5.444    19.585     0.200
     5.444    19.755     0.200
     5.499    18.828     0.200
     5.625    18.742     0.200
     6.283    20.158     0.200
     6.284    19.380     0.200
     6.284    20.560     0.200
     7.191    20.620     0.200
     7.171    21.838     0.200
     7.350    21.604     0.200
     7.335    21.302     0.200
     7.335    22.437     0.200
     7.435    22.268     0.200
     7.822    22.644     0.200
     8.104    23.897     0.200
     8.665    25.607     0.200
     1.905    11.435     0.200
     2.675    13.302     0.200
     2.733    13.234     0.200
     2.788    13.733     0.200
     2.919    13.701     0.200
     3.073    14.501     0.200
     3.448    14.737     0.200
     3.854    17.507     0.200
     3.966    17.005     0.200
     4.711    19.305     0.200
     5.322    21.132     0.200
     1.811    10.844     0.200
     1.811    10.989     0.200
     1.861    11.062     0.200
     1.861    11.232     0.200
     1.882    11.141     0.200
     1.882    11.333     0.200
     1.953    10.942     0.200
     1.954    11.360     0.200
     2.008    10.607     0.200
     2.286    12.328     0.200
     2.323    12.444     0.200
     2.334    12.140     0.200
     2.513    13.354     0.200
     2.777    11.965     0.200
     3.041    14.009     0.200
     3.198    14.979     0.200
     3.198    13.923     0.200
     3.977    16.671     0.200
     4.103    16.846     0.200
     4.720    17.625     0.200
     4.827    18.537     0.200
     5.442    20.570     0.200
     7.333    22.763     0.200
     1.853    11.223     0.200
     2.280    11.499     0.200
     2.331    11.733     0.200
     3.188    14.916     0.200
     3.967    16.652     0.200
     4.093    16.912     0.200
     4.818    18.718     0.200
     5.433    20.285     0.200
     7.324    23.304     0.200
     1.812    10.195     0.200
     1.812    10.025     0.200
     1.859    10.877     0.200
     1.859    11.198     0.200
     1.877    11.163     0.200
     1.886    10.272     0.200
     1.949    11.323     0.200
     1.948    11.250     0.200
     1.948    10.869     0.200
     1.968    10.835     0.200
     1.968    10.966     0.200
     1.991    10.491     0.200
     1.999    11.018     0.200
     2.005    10.983     0.200
     2.027    10.535     0.200
     2.113    11.114     0.200
     2.113    11.321     0.200
     2.214    11.844     0.200
     2.282    11.766     0.200
     2.282    12.065     0.200
     2.282    11.872     0.200
     2.321    12.018     0.200
     2.321    12.338     0.200
     2.321    12.508     0.200
     2.316    12.185     0.200
     2.335    12.062     0.200
     2.370    11.640     0.200
     2.509    12.887     0.200
     2.509    12.778     0.200
     2.509    12.647     0.200
     2.545    13.615     0.200
     2.539    12.122     0.200
     2.539    11.884     0.200
     2.598    12.153     0.200
     2.598    11.825     0.200
     2.628    11.785     0.200
     2.676    12.769     0.200
     2.711    12.229     0.200
     2.711    12.039     0.200
     2.735    12.165     0.200
     2.774    12.219     0.200
     2.885    13.356     0.200
     2.885    13.717     0.200
     2.885    13.528     0.200
     2.886    12.204     0.200
     2.886    12.374     0.200
     2.996    12.706     0.200
     2.996    12.997     0.200
     2.996    12.878     0.200
     3.031    13.256     0.200
     3.031    12.485     0.200
     3.031    12.704     0.200
     3.037    13.435     0.200
     3.037    13.785     0.200
     3.037    13.580     0.200
     3.088    13.322     0.200
     3.194    14.184     0.200
     3.194    14.293     0.200
     3.229    13.539     0.200
     3.229    13.394     0.200
     3.288    14.432     0.200
     3.288    14.801     0.200
     3.290    12.952     0.200
     3.290    12.574     0.200
     3.318    13.931     0.200
     3.318    13.581     0.200
     3.364    13.534     0.200
     3.555    14.205     0.200
     3.600    14.567     0.200
     3.586    13.977     0.200
     3.691    15.012     0.200
     3.691    15.723     0.200
     3.691    15.190     0.200
     3.765    14.867     0.200
     3.936    15.827     0.200
     3.933    15.387     0.200
     3.933    15.568     0.200
     3.973    16.354     0.200
     3.973    16.463     0.200
     3.984    16.697     0.200
     3.984    16.560     0.200
     4.036    14.610     0.200
     4.099    16.103     0.200
     4.099    15.949     0.200
     4.257    15.634     0.200
     4.300    15.168     0.200
     4.306    15.621     0.200
     4.306    15.724     0.200
     4.468    16.046     0.200
     4.530    16.295     0.200
     4.561    15.896     0.200
     4.575    17.646     0.200
     4.719    17.285     0.200
     4.719    17.566     0.200
     4.745    17.027     0.200
     4.806    17.127     0.200
     4.823    18.146     0.200
     4.885    17.671     0.200
     4.940    16.722     0.200
     4.940    16.890     0.200
     5.045    16.600     0.200
     5.238    18.602     0.200
     5.254    18.324     0.200
     5.438    19.810     0.200
     5.438    20.252     0.200
     5.438    19.521     0.200
     5.432    17.883     0.200
     5.494    18.716     0.200
     5.494    20.607     0.200
     5.621    19.138     0.200
     5.658    18.948     0.200
     6.245    20.923     0.200
     6.248    20.290     0.200
     6.278    21.557     0.200
     6.278    21.346     0.200
     6.278    21.212     0.200
     6.278    20.737     0.200
     7.165    22.746     0.200
     7.165    22.113     0.200
     7.330    22.638     0.200
     7.820    23.868     0.200
     7.820    24.392     0.200
     7.822    23.976     0.200
     7.890    24.402     0.200
     8.102    24.680     0.200
     1.892    11.881     0.200
     1.921    13.096     0.200
     1.945    11.894     0.200
     2.025    11.418     0.200
     2.081    12.165     0.200
     2.223    12.812     0.200
     2.249    12.470     0.200
     2.276    11.943     0.200
     2.298    12.322     0.200
     2.344    12.285     0.200
     2.429    12.585     0.200
     2.460    12.065     0.200
     2.462    12.882     0.200
     2.464    12.093     0.200
     2.687    14.275     0.200
     2.705    14.329     0.200
     2.933    14.808     0.200
     2.937    13.715     0.200
     3.225    15.483     0.200
     3.336    14.554     0.200
     3.479    14.545     0.200
     3.582    15.219     0.200
     3.789    16.579     0.200
     3.816    14.759     0.200
     3.973    15.686     0.200
     4.570    16.040     0.200
     5.130    19.144     0.200
     5.173    20.372     0.200
     5.260    21.010     0.200
     5.303    19.970     0.200
     5.475    19.270     0.200
     5.561    18.879     0.200
     5.885    19.351     0.200
     5.982    20.791     0.200
     6.058    20.605     0.200
     6.089    20.765     0.200
     7.743    22.470     0.200
     1.782    11.584     0.200
     1.814    11.720     0.200
     1.835    11.496     0.200
     2.169    12.105     0.200
     2.336    12.409     0.200
     2.686    12.650     0.200
     2.787    14.025     0.200
     2.787    13.420     0.200
     3.075    14.588     0.200
     3.229    15.357     0.200
     3.856    16.806     0.200
     3.856    16.585     0.200
     4.675    18.129     0.200
     4.711    18.813     0.200
     4.711    18.585     0.200
     5.323    20.234     0.200
     1.852    11.733     0.200
     1.913    12.056     0.200
     1.930    12.164     0.200
     2.198    12.074     0.200
     2.408    12.600     0.200
     2.443    13.227     0.200
     2.520    12.841     0.200
     2.533    13.110     0.200
     2.946    13.789     0.200
     2.936    14.226     0.200
     3.219    14.980     0.200
     3.273    14.322     0.200
     4.001    16.586     0.200
     4.103    16.831     0.200
     4.858    17.888     0.200
     5.469    20.106     0.200
     5.493    20.111     0.200
     1.869    10.806     0.200
     1.921    11.820     0.200
     1.927    10.847     0.200
     1.985    10.744     0.200
     2.007    11.421     0.200
     2.053    11.956     0.200
     2.098    12.184     0.200
     2.119    11.254     0.200
     2.128    11.610     0.200
     2.149    10.708     0.200
     2.213    12.112     0.200
     2.213    12.433     0.200
     2.229    11.734     0.200
     2.229    12.694     0.200
     2.332    11.297     0.200
     2.345    11.962     0.200
     2.387    12.534     0.200
     2.387    12.694     0.200
     2.446    12.759     0.200
     2.482    13.050     0.200
     2.495    13.073     0.200
     2.495    13.523     0.200
     2.595    12.339     0.200
     2.595    12.569     0.200
     2.601    12.318     0.200
     2.670    13.069     0.200
     2.740    14.327     0.200
     2.738    12.787     0.200
     2.756    12.088     0.200
     2.756    12.795     0.200
     2.811    13.929     0.200
     2.838    14.399     0.200
     2.838    13.980     0.200
     2.838    13.644     0.200
     2.896    13.163     0.200
     2.919    11.496     0.200
     2.975    13.775     0.200
     3.148    14.323     0.200
     3.148    14.013     0.200
     3.148    13.773     0.200
     3.151    15.428     0.200
     3.161    12.972     0.200
     3.161    13.552     0.200
     3.178    15.060     0.200
     3.178    14.831     0.200
     3.199    13.790     0.200
     3.199    15.070     0.200
     3.354    13.881     0.200
     3.357    13.811     0.200
     3.487    14.745     0.200
     3.637    14.877     0.200
     3.637    15.127     0.200
     3.671    14.975     0.200
     3.673    14.582     0.200
     3.673    15.328     0.200
     3.716    15.326     0.200
     3.741    16.405     0.200
     3.808    16.210     0.200
     3.940    17.623     0.200
     3.952    16.753     0.200
     3.952    16.353     0.200
     3.952    17.181     0.200
     4.045    15.262     0.200
     4.045    16.923     0.200
     4.060    14.721     0.200
     4.060    16.535     0.200
     4.106    16.844     0.200
     4.106    17.131     0.200
     4.169    15.604     0.200
     4.166    15.146     0.200
     4.300    16.456     0.200
     4.300    16.347     0.200
     4.423    16.937     0.200
     4.658    17.770     0.200
     4.794    18.442     0.200
     4.794    18.272     0.200
     4.794    18.753     0.200
     4.813    18.527     0.200
     4.911    18.721     0.200
     4.911    17.821     0.200
     4.911    18.511     0.200
     5.029    18.840     0.200
     5.122    19.186     0.200
     5.365    18.009     0.200
     5.365    19.819     0.200
     5.414    20.567     0.200
     5.414    20.052     0.200
     5.417    19.521     0.200
     5.505    19.661     0.200
     5.505    18.201     0.200
     5.562    18.475     0.200
     5.664    19.512     0.200
     5.664    20.021     0.200
     5.771    19.593     0.200
     5.919    20.705     0.200
     6.147    19.800     0.200
     6.241    20.237     0.200
     6.276    20.613     0.200
     6.276    20.322     0.200
     6.276    21.197     0.200
     6.372    20.223     0.200
     6.918    22.234     0.200
     6.943    21.750     0.200
     6.979    23.672     0.200
     7.148    23.147     0.200
     7.299    23.375     0.200
     7.299    23.161     0.200
     7.321    21.232     0.200
     7.483    22.155     0.200
     7.687    23.049     0.200
     7.862    24.373     0.200
     8.058    24.875     0.200
     8.665    27.167     0.200
     9.003    25.068     0.200
     1.832    11.837     0.200
     1.832    11.978     0.200
     1.837    11.524     0.200
     2.007    12.480     0.200
     2.025    11.825     0.200
     2.111    12.225     0.200
     2.258    13.324     0.200
     2.317    12.219     0.200
     2.363    12.620     0.200
     2.371    13.134     0.200
     2.394    13.007     0.200
     2.549    12.766     0.200
     2.549    12.239     0.200
     2.694    12.900     0.200
     2.703    13.909     0.200
     2.774    13.895     0.200
     3.004    13.920     0.200
     3.312    14.794     0.200
     3.348    14.985     0.200
     3.404    14.424     0.200
     3.738    17.204     0.200
     3.828    15.733     0.200
     3.828    16.862     0.200
     4.595    18.842     0.200
     4.602    19.164     0.200
     4.637    18.138     0.200
     5.163    19.010     0.200
     5.208    20.660     0.200
     5.216    19.080     0.200
     6.016    20.474     0.200
     6.016    20.757     0.200
     7.107    22.600     0.200
     1.795    10.484     0.200
     1.803    10.875     0.200
     1.855    11.446     0.200
     1.951    11.806     0.200
     2.321    13.415     0.200
     2.471    12.629     0.200
     2.817    12.152     0.200
     2.831    13.617     0.200
     3.082    14.533     0.200
     3.155    13.863     0.200
     4.072    15.861     0.200
     2.116    14.552     0.200
     2.117    13.871     0.200
     2.141    13.221     0.200
     2.326    13.393     0.200
     2.555    14.447     0.200
     2.738    15.372     0.200
     2.802    15.508     0.200
     2.882    15.684     0.200
     3.069    14.846     0.200
     3.045    13.709     0.200
     3.292    15.991     0.200
     3.586    17.200     0.200
     3.680    18.053     0.200
     3.829    17.312     0.200
     4.450    19.784     0.200
     5.055    20.943     0.200
     5.071    21.603     0.200
     1.824    11.021     0.200
     1.843    11.690     0.200
     1.875    11.052     0.200
     1.887    11.454     0.200
     1.879    12.011     0.200
     1.879    12.203     0.200
     1.963    11.542     0.200
     1.959    12.158     0.200
     1.959    12.498     0.200
     2.007    11.934     0.200
     2.007    12.255     0.200
     2.024    11.860     0.200
     2.079    11.762     0.200
     2.083    12.001     0.200
     2.106    12.175     0.200
     2.229    13.056     0.200
     2.229    12.806     0.200
     2.232    12.546     0.200
     2.232    12.750     0.200
     2.293    12.704     0.200
     2.311    12.841     0.200
     2.340    13.363     0.200
     2.385    12.041     0.200
     2.385    13.100     0.200
     2.437    13.168     0.200
     2.465    13.417     0.200
     2.465    13.960     0.200
     2.546    13.167     0.200
     2.546    13.327     0.200
     2.546    12.492     0.200
     2.563    13.386     0.200
     2.559    13.247     0.200
     2.559    12.700     0.200
     2.637    12.828     0.200
     2.641    13.059     0.200
     2.641    12.289     0.200
     2.692    13.908     0.200
     2.694    14.253     0.200
     2.694    12.992     0.200
     2.773    13.960     0.200
     2.823    13.191     0.200
     2.823    13.468     0.200
     2.791    12.971     0.200
     2.791    12.760     0.200
     2.819    15.243     0.200
     2.819    14.180     0.200
     2.819    13.536     0.200
     2.853    13.118     0.200
     2.853    13.321     0.200
     2.965    14.150     0.200
     2.965    13.521     0.200
     3.028    13.925     0.200
     3.020    13.302     0.200
     3.102    14.482     0.200
     3.102    14.982     0.200
     3.102    14.369     0.200
     3.149    15.397     0.200
     3.149    15.116     0.200
     3.198    14.663     0.200
     3.198    15.343     0.200
     3.197    14.800     0.200
     3.197    15.261     0.200
     3.189    14.232     0.200
     3.189    13.470     0.200
     3.216    14.550     0.200
     3.216    14.429     0.200
     3.318    14.791     0.200
     3.318    14.381     0.200
     3.310    14.336     0.200
     3.314    14.214     0.200
     3.314    14.677     0.200
     3.314    14.376     0.200
     3.444    15.180     0.200
     3.499    15.491     0.200
     3.499    14.659     0.200
     3.584    14.872     0.200
     3.629    16.045     0.200
     3.629    15.603     0.200
     3.625    15.299     0.200
     3.597    16.486     0.200
     3.597    16.307     0.200
     3.597    16.002     0.200
     3.676    14.873     0.200
     3.676    14.651     0.200
     3.925    17.433     0.200
     3.925    17.070     0.200
     3.920    17.593     0.200
     3.999    16.916     0.200
     4.071    17.562     0.200
     4.071    17.370     0.200
     4.071    17.226     0.200
     4.132    15.755     0.200
     4.233    15.880     0.200
     4.233    15.310     0.200
     4.204    15.943     0.200
     4.204    15.674     0.200
     4.204    15.791     0.200
     4.258    16.797     0.200
     4.323    16.679     0.200
     4.323    18.257     0.200
     4.379    17.352     0.200
     4.379    16.759     0.200
     4.542    16.852     0.200
     4.580    18.325     0.200
     4.580    16.942     0.200
     4.618    17.193     0.200
     4.618    16.822     0.200
     4.665    17.115     0.200
     4.665    17.471     0.200
     4.771    18.347     0.200
     4.769    19.298     0.200
     4.769    18.880     0.200
     4.820    17.912     0.200
     4.868    18.079     0.200
     4.868    17.665     0.200
     4.950    18.305     0.200
     4.950    17.797     0.200
     5.098    18.218     0.200
     5.098    17.558     0.200
     5.278    18.058     0.200
     5.315    18.805     0.200
     5.324    18.798     0.200
     5.385    20.359     0.200
     5.388    20.581     0.200
     5.388    20.721     0.200
     5.438    19.367     0.200
     5.445    19.565     0.200
     5.469    20.037     0.200
     5.469    19.787     0.200
     5.524    18.900     0.200
     5.724    20.223     0.200
     5.724    20.679     0.200
     5.724    20.465     0.200
     5.803    21.463     0.200
     5.859    20.939     0.200
     5.874    21.183     0.200
     5.874    20.847     0.200
     5.970    19.797     0.200
     5.970    19.618     0.200
     6.115    20.589     0.200
     6.219    22.084     0.200
     6.219    21.975     0.200
     6.219    21.315     0.200
     6.243    21.301     0.200
     6.243    21.180     0.200
     6.243    20.977     0.200
     6.305    21.832     0.200
     6.305    22.035     0.200
     6.326    21.425     0.200
     6.326    21.913     0.200
     6.334    21.763     0.200
     6.334    22.185     0.200
     6.742    21.873     0.200
     6.914    23.566     0.200
     6.947    22.014     0.200
     7.296    21.897     0.200
     7.275    23.009     0.200
     7.275    23.372     0.200
     7.774    24.190     0.200
     7.879    22.217     0.200
     8.017    25.319     0.200
     8.126    25.102     0.200
     8.276    25.310     0.200
     8.431    24.960     0.200
     8.604    26.118     0.200
     8.630    26.300     0.200
     8.696    25.272     0.200
     8.682    26.285     0.200
     8.758    26.469     0.200
     8.965    25.790     0.200
     9.302    28.334     0.200
     9.359    28.550     0.200
     9.748    30.327     0.200
     9.834    31.040     0.200
     9.842    30.765     0.200
    10.233    31.334     0.200
    10.494    29.732     0.200
    11.338    31.110     0.200
    12.057    31.730     0.200
     1.905    11.998     0.200
     1.905    12.258     0.200
     1.932    12.170     0.200
     1.932    12.490     0.200
     2.200    12.828     0.200
     2.200    13.248     0.200
     2.258    12.543     0.200
     2.279    13.598     0.200
     2.279    14.098     0.200
     2.305    13.474     0.200
     2.338    13.252     0.200
     2.338    13.882     0.200
     2.431    12.264     0.200
     2.431    12.865     0.200
     2.437    12.731     0.200
     2.499    12.832     0.200
     2.499    13.653     0.200
     2.613    14.442     0.200
     2.668    13.972     0.200
     2.668    14.432     0.200
     2.741    14.446     0.200
     2.741    15.086     0.200
     2.932    14.030     0.200
     2.947    13.944     0.200
     2.949    14.791     0.200
     2.949    14.592     0.200
     2.962    15.142     0.200
     2.962    15.852     0.200
     3.171    13.484     0.200
     3.277    16.374     0.200
     3.277    16.254     0.200
     3.447    15.719     0.200
     3.515    14.956     0.200
     3.515    14.797     0.200
     3.709    16.888     0.200
     3.811    17.382     0.200
     3.950    16.892     0.200
     3.923    16.725     0.200
     4.188    17.402     0.200
     4.656    18.240     0.200
     4.618    19.760     0.200
     4.618    19.350     0.200
     5.194    21.180     0.200
     5.194    18.560     0.200
     5.271    20.711     0.200
     6.091    20.234     0.200
     6.924    22.538     0.200
     7.121    22.838     0.200
     2.058    11.372     0.200
     2.056    11.576     0.200
     2.099    11.873     0.200
     2.159    10.921     0.200
     2.302    12.179     0.200
     2.267    12.335     0.200
     2.314    12.547     0.200
     2.412    11.406     0.200
     2.428    11.958     0.200
     2.380    12.392     0.200
     2.539    12.375     0.200
     2.590    11.703     0.200
     2.590    12.368     0.200
     2.751    12.813     0.200
     2.751    12.664     0.200
     2.736    13.185     0.200
     2.823    12.754     0.200
     2.823    13.308     0.200
     2.839    13.700     0.200
     2.999    14.058     0.200
     3.058    12.320     0.200
     3.061    13.202     0.200
     3.078    13.294     0.200
     3.024    12.084     0.200
     3.024    12.209     0.200
     3.181    13.079     0.200
     3.218    13.875     0.200
     3.218    14.226     0.200
     3.353    13.786     0.200
     3.353    14.271     0.200
     3.357    14.129     0.200
     3.357    14.512     0.200
     3.245    13.287     0.200
     3.381    13.840     0.200
     3.341    13.851     0.200
     3.341    13.953     0.200
     3.381    13.209     0.200
     3.381    12.873     0.200
     3.446    13.241     0.200
     3.719    14.729     0.200
     3.719    14.908     0.200
     3.782    16.272     0.200
     3.782    16.390     0.200
     3.828    15.397     0.200
     3.878    15.903     0.200
     3.878    16.083     0.200
     3.782    16.657     0.200
     3.950    14.389     0.200
     3.917    14.441     0.200
     3.917    14.996     0.200
     3.863    15.404     0.200
     3.926    13.916     0.200
     3.926    14.315     0.200
     4.052    14.749     0.200
     4.105    15.171     0.200
     4.105    15.624     0.200
     4.270    16.259     0.200
     4.314    16.142     0.200
     4.314    15.728     0.200
     4.314    16.996     0.200
     4.314    17.262     0.200
     4.329    15.453     0.200
     4.509    15.391     0.200
     4.509    16.001     0.200
     4.431    15.266     0.200
     4.431    15.407     0.200
     4.550    16.225     0.200
     4.587    16.662     0.200
     4.643    18.190     0.200
     4.699    17.095     0.200
     4.677    17.562     0.200
     4.677    17.390     0.200
     4.928    16.930     0.200
     5.034    18.586     0.200
     5.157    17.667     0.200
     5.157    18.558     0.200
     5.176    17.493     0.200
     5.176    18.547     0.200
     5.211    17.620     0.200
     5.251    19.427     0.200
     5.251    19.654     0.200
     5.268    19.073     0.200
     5.268    18.628     0.200
     5.288    17.594     0.200
     5.377    18.760     0.200
     5.441    19.881     0.200
     5.599    19.382     0.200
     5.599    19.694     0.200
     5.695    18.708     0.200
     5.695    16.974     0.200
     5.830    21.341     0.200
     5.907    19.630     0.200
     5.983    18.301     0.200
     6.022    20.347     0.200
     6.022    20.753     0.200
     6.060    19.863     0.200
     6.060    20.269     0.200
     6.108    20.171     0.200
     6.108    20.483     0.200
     6.124    19.906     0.200
     6.322    19.995     0.200
     6.366    20.730     0.200
     6.555    20.765     0.200
     6.596    21.537     0.200
     6.613    21.622     0.200
     6.692    20.776     0.200
     6.728    20.705     0.200
     6.788    21.725     0.200
     6.783    21.211     0.200
     6.880    20.694     0.200
     6.968    21.047     0.200
     7.137    19.908     0.200
     7.137    21.189     0.200
     7.254    22.866     0.200
     7.411    22.271     0.200
     7.442    22.766     0.200
     7.580    23.149     0.200
     7.730    21.024     0.200
     7.831    22.307     0.200
     7.930    22.280     0.200
     8.362    24.401     0.200
     8.437    24.527     0.200
     8.549    24.341     0.200
     8.635    24.431     0.200
     8.725    24.199     0.200
     8.795    24.737     0.200
     1.825    10.447     0.200
     2.058    11.535     0.200
     2.161    11.213     0.200
     2.271    11.644     0.200
     2.295    12.112     0.200
     2.365    11.825     0.200
     2.365    12.583     0.200
     2.413    11.764     0.200
     2.419    11.768     0.200
     2.548    12.949     0.200
     2.596    12.577     0.200
     2.596    12.350     0.200
     2.715    12.881     0.200
     2.715    13.819     0.200
     2.744    13.448     0.200
     2.819    14.671     0.200
     2.824    13.804     0.200
     2.844    12.571     0.200
     2.918    13.019     0.200
     2.913    14.927     0.200
     2.980    13.106     0.200
     2.980    14.848     0.200
     3.015    13.256     0.200
     3.046    12.233     0.200
     3.050    12.590     0.200
     3.050    14.723     0.200
     3.087    13.761     0.200
     3.198    13.722     0.200
     3.344    14.728     0.200
     3.368    13.432     0.200
     3.368    13.698     0.200
     3.360    14.418     0.200
     3.360    14.684     0.200
     3.374    15.559     0.200
     3.763    16.674     0.200
     3.861    16.437     0.200
     4.624    18.675     0.200
     5.232    20.370     0.200
     1.814     9.476     0.200
     1.814     9.586     0.200
     1.867     9.879     0.200
     1.901     9.885     0.200
     1.901    10.806     0.200
     1.947     9.805     0.200
     1.978    10.064     0.200
     2.002    10.593     0.200
     2.002    10.492     0.200
     2.049    11.834     0.200
     2.089    10.252     0.200
     2.267    10.435     0.200
     2.278    10.590     0.200
     2.276    10.363     0.200
     2.335    11.270     0.200
     2.335    10.567     0.200
     2.427    11.242     0.200
     2.505    11.490     0.200
     2.505    11.076     0.200
     2.552    11.879     0.200
     2.604    11.225     0.200
     2.652    11.118     0.200
     2.684    11.187     0.200
     2.710    11.081     0.200
     2.745    11.656     0.200
     2.799    11.947     0.200
     2.835    11.768     0.200
     2.822    11.632     0.200
     3.093    12.496     0.200
     3.189    12.911     0.200
     3.189    12.809     0.200
     3.227    12.671     0.200
     3.331    12.003     0.200
     3.615    13.949     0.200
     3.650    14.362     0.200
     3.678    15.160     0.200
     3.996    14.692     0.200
     4.105    14.945     0.200
     4.100    14.573     0.200
     4.365    15.383     0.200
     4.672    15.832     0.200
     4.812    16.549     0.200
     5.752    17.494     0.200
     6.263    20.076     0.200
     6.280    19.518     0.200
     7.318    21.406     0.200
     1.844    11.790     0.200
     1.884    11.970     0.200
     2.012    13.077     0.200
     2.058    11.225     0.200
     2.050    12.512     0.200
     2.105    11.746     0.200
     2.169    11.954     0.200
     2.156    13.909     0.200
     2.308    12.028     0.200
     2.354    12.962     0.200
     2.378    12.430     0.200
     2.542    13.593     0.200
     2.695    13.350     0.200
     2.734    13.557     0.200
     2.796    13.922     0.200
     2.798    13.724     0.200
     2.834    13.237     0.200
     2.882    13.149     0.200
     2.834    13.482     0.200
     2.902    14.322     0.200
     2.953    14.188     0.200
     2.932    14.800     0.200
     2.932    14.420     0.200
     2.937    14.853     0.200
     2.967    13.108     0.200
     2.995    13.681     0.200
     2.989    14.205     0.200
     3.224    14.188     0.200
     3.382    15.261     0.200
     3.382    15.372     0.200
     3.471    16.308     0.200
     3.524    16.045     0.200
     3.861    16.158     0.200
     5.029    19.462     0.200
     7.426    23.397     0.200
     1.796    11.376     0.200
     2.120    12.525     0.200
     2.256    12.701     0.200
     2.345    13.071     0.200
     2.345    12.485     0.200
     3.211    15.397     0.200
     3.812    16.700     0.200
     3.920    16.430     0.200
     4.670    18.862     0.200
     5.280    20.601     0.200
     1.785    10.806     0.200
     1.819    10.039     0.200
     1.838    11.042     0.200
     1.915    11.786     0.200
     1.951    11.475     0.200
     2.285    12.253     0.200
     2.271    11.803     0.200
     3.131    13.202     0.200
     3.214    14.051     0.200
     3.908    15.536     0.200
     4.043    15.751     0.200
     4.275    15.969     0.200
     4.757    17.047     0.200
     6.219    19.947     0.200
     2.005    11.679     0.200
     2.186    11.011     0.200
     2.159    13.035     0.200
     2.350    11.348     0.200
     2.405    11.806     0.200
     2.485    13.481     0.200
     2.455    12.140     0.200
     2.791    14.128     0.200
     2.994    12.626     0.200
     3.150    14.221     0.200
     3.150    13.328     0.200
     3.294    14.640     0.200
     3.642    16.506     0.200
     3.750    16.047     0.200
     3.784    15.673     0.200
     3.893    14.940     0.200
     4.045    16.602     0.200
     4.061    16.775     0.200
     4.907    18.207     0.200
     5.244    20.062     0.200
     1.933     9.639     0.200
     1.985    10.271     0.200
     2.072    10.776     0.200
     2.330    10.185     0.200
     2.390    10.116     0.200
     2.417    11.239     0.200
     2.415    10.298     0.200
     2.717    11.389     0.200
     3.007    12.112     0.200
     3.063    13.163     0.200
     3.328    13.393     0.200
     3.321    12.978     0.200
     4.253    16.071     0.200
     5.664    18.511     0.200
     5.664    18.742     0.200
     1.844    10.936     0.200
     1.844    10.565     0.200
     1.922    10.823     0.200
     1.924    11.026     0.200
     1.941    11.090     0.200
     2.141    11.771     0.200
     2.168    11.441     0.200
     2.178    12.025     0.200
     2.178    12.473     0.200
     2.180    11.800     0.200
     2.273    12.006     0.200
     2.338    12.277     0.200
     2.338    12.074     0.200
     2.422    12.485     0.200
     2.501    12.136     0.200
     2.529    12.538     0.200
     2.554    12.861     0.200
     2.623    12.337     0.200
     2.668    12.226     0.200
     2.713    13.275     0.200
     2.804    13.131     0.200
     2.804    12.881     0.200
     2.877    13.279     0.200
     2.939    13.351     0.200
     3.165    13.009     0.200
     3.181    13.745     0.200
     3.184    13.361     0.200
     3.184    13.542     0.200
     3.284    13.447     0.200
     3.466    14.836     0.200
     3.479    14.773     0.200
     3.508    14.821     0.200
     3.528    14.802     0.200
     3.649    15.827     0.200
     3.659    15.916     0.200
     3.737    16.319     0.200
     3.894    16.321     0.200
     3.894    17.250     0.200
     3.983    16.116     0.200
     3.983    16.588     0.200
     4.178    15.742     0.200
     4.178    15.902     0.200
     4.216    16.299     0.200
     4.610    17.492     0.200
     4.657    17.480     0.200
     4.705    17.414     0.200
     4.818    17.193     0.200
     4.916    17.842     0.200
     5.113    18.467     0.200
     5.113    17.807     0.200
     5.152    17.853     0.200
     5.167    17.932     0.200
     5.310    18.233     0.200
     5.374    17.502     0.200
     5.562    18.853     0.200
     5.821    19.275     0.200
     5.821    17.603     0.200
     5.821    19.275     0.200
     6.165    20.084     0.200
     6.223    20.429     0.200
     6.809    21.230     0.200
     7.180    20.713     0.200
     7.180    20.103     0.200
     7.317    21.434     0.200
     7.469    22.574     0.200
     7.700    23.005     0.200
     8.000    23.267     0.200
     8.590    23.976     0.200
     8.633    23.991     0.200
     8.633    25.023     0.200
     8.760    25.403     0.200
     9.646    26.893     0.200
    10.290    28.443     0.200
    12.153    31.231     0.200
    12.209    32.102     0.200
     2.150    11.816     0.200
     2.179    12.905     0.200
     2.181    12.775     0.200
     2.181    12.703     0.200
     2.278    12.257     0.200
     2.325    12.707     0.200
     2.325    12.507     0.200
     2.416    12.794     0.200
     2.533    12.847     0.200
     2.550    13.347     0.200
     2.677    12.388     0.200
     2.713    13.549     0.200
     2.799    13.002     0.200
     2.799    12.772     0.200
     2.943    13.849     0.200
     3.175    14.243     0.200
     3.179    13.679     0.200
     3.291    14.540     0.200
     3.472    14.792     0.200
     3.477    14.696     0.200
     3.634    16.722     0.200
     3.973    16.685     0.200
     4.128    16.290     0.200
     4.176    16.172     0.200
     4.221    16.360     0.200
     4.618    18.330     0.200
     4.663    17.425     0.200
     4.708    17.387     0.200
     4.813    17.712     0.200
     4.923    17.841     0.200
     5.105    17.483     0.200
     5.819    19.738     0.200
     7.193    20.653     0.200
     8.621    25.480     0.200
    12.139    31.515     0.200
     1.908    11.540     0.200
     2.013    11.516     0.200
     2.168    14.159     0.200
     2.263    12.739     0.200
     2.282    14.067     0.200
     2.345    12.352     0.200
     2.426    12.989     0.200
     2.412    13.171     0.200
     2.456    12.837     0.200
     2.459    13.412     0.200
     2.459    12.793     0.200
     2.598    13.991     0.200
     2.675    14.630     0.200
     2.918    14.852     0.200
     2.921    14.924     0.200
     2.958    13.201     0.200
     2.992    12.756     0.200
     3.067    13.439     0.200
     3.067    13.609     0.200
     3.215    15.158     0.200
     3.229    14.499     0.200
     3.395    14.814     0.200
     3.450    14.959     0.200
     3.769    17.296     0.200
     3.796    15.744     0.200
     3.774    15.942     0.200
     3.774    16.651     0.200
     3.903    16.079     0.200
     3.903    17.208     0.200
     3.961    16.463     0.200
     4.128    17.470     0.200
     4.166    17.293     0.200
     4.373    17.668     0.200
     4.407    17.159     0.200
     4.437    17.449     0.200
     4.670    18.285     0.200
     5.027    18.607     0.200
     5.340    19.146     0.200
     5.373    20.461     0.200
     5.714    20.455     0.200
     5.921    20.633     0.200
     7.497    23.644     0.200
     8.469    26.383     0.200
     1.845     9.196     0.200
     1.845     9.516     0.200
     1.879     9.162     0.200
     1.901     9.619     0.200
     1.956     9.844     0.200
     1.956    10.364     0.200
     1.971     9.395     0.200
     2.038    10.597     0.200
     2.038    10.316     0.200
     2.037    10.563     0.200
     2.069    10.034     0.200
     2.088     9.805     0.200
     2.073    10.237     0.200
     2.039     9.942     0.200
     2.279    10.110     0.200
     2.298    10.441     0.200
     2.372    10.487     0.200
     2.371    10.692     0.200
     2.458    10.764     0.200
     2.624    11.377     0.200
     2.624    11.268     0.200
     2.508    12.215     0.200
     2.717    11.730     0.200
     2.625    11.011     0.200
     2.625    11.350     0.200
     2.761    11.433     0.200
     2.757    11.944     0.200
     2.813    11.691     0.200
     2.819    11.444     0.200
     3.125    12.894     0.200
     3.139    13.405     0.200
     3.233    13.757     0.200
     3.304    13.071     0.200
     3.389    13.912     0.200
     3.460    13.839     0.200
     3.641    13.816     0.200
     3.692    14.662     0.200
     4.012    14.771     0.200
     4.103    14.215     0.200
     4.164    14.317     0.200
     4.164    15.145     0.200
     4.608    15.422     0.200
     4.647    15.154     0.200
     4.709    15.673     0.200
     4.709    16.244     0.200
     4.894    15.691     0.200
     4.958    16.800     0.200
     5.023    15.600     0.200
     5.507    16.305     0.200
     2.100    12.372     0.200
     3.615    16.646     0.200
     4.428    18.757     0.200
     2.236    12.717     0.200
     2.251    13.111     0.200
     2.436    12.755     0.200
     2.472    12.894     0.200
     2.472    13.135     0.200
     2.938    13.859     0.200
     2.889    14.235     0.200
     2.892    14.739     0.200
     3.023    13.552     0.200
     3.021    13.744     0.200
     3.021    14.115     0.200
     3.095    13.352     0.200
     3.189    14.724     0.200
     3.168    13.751     0.200
     3.172    15.456     0.200
     3.199    15.378     0.200
     3.295    15.092     0.200
     3.408    14.169     0.200
     3.424    14.551     0.200
     3.478    14.747     0.200
     3.619    15.197     0.200
     3.660    15.948     0.200
     3.660    16.868     0.200
     3.797    15.231     0.200
     3.766    16.507     0.200
     3.745    16.979     0.200
     3.745    17.549     0.200
     3.923    15.178     0.200
     3.935    16.845     0.200
     3.966    16.233     0.200
     4.136    17.837     0.200
     4.349    18.033     0.200
     4.496    19.257     0.200
     4.521    18.472     0.200
     4.645    18.044     0.200
     4.855    18.862     0.200
     4.978    18.541     0.200
     4.997    18.353     0.200
     5.151    17.786     0.200
     5.428    20.054     0.200
     5.473    18.721     0.200
     5.568    18.585     0.200
     5.564    19.478     0.200
     5.687    20.901     0.200
     5.896    20.930     0.200
     5.967    20.484     0.200
     6.560    21.524     0.200
     2.399    13.436     0.200
     2.966    13.520     0.200
     3.837    17.022     0.200
     4.603    18.061     0.200
     4.678    18.477     0.200
     2.020    12.238     0.200
     2.391    13.404     0.200
     4.673    18.209     0.200
     1.886    10.509     0.200
     1.908    11.050     0.200
     1.937    10.066     0.200
     1.959    10.435     0.200
     2.154    11.700     0.200
     2.169    11.026     0.200
     2.252    11.528     0.200
     2.251    11.905     0.200
     2.333    11.389     0.200
     2.403    11.589     0.200
     2.478    11.643     0.200
     2.593    11.350     0.200
     2.626    11.811     0.200
     2.673    11.628     0.200
     2.681    12.320     0.200
     2.753    12.699     0.200
     2.753    12.133     0.200
     3.001    12.746     0.200
     2.947    11.786     0.200
     3.071    13.729     0.200
     3.173    12.491     0.200
     3.513    13.313     0.200
     3.528    14.287     0.200
     3.561    15.042     0.200
     3.757    14.703     0.200
     3.974    14.903     0.200
     4.126    15.297     0.200
     4.266    14.843     0.200
     4.477    14.922     0.200
     4.558    15.317     0.200
     4.771    16.557     0.200
     4.785    16.626     0.200
     4.956    17.818     0.200
     5.183    16.925     0.200
     1.907     9.822     0.200
     1.928     9.872     0.200
     1.910     9.750     0.200
     2.003    10.421     0.200
     2.002    10.528     0.200
     2.080     9.242     0.200
     2.260    10.036     0.200
     2.341    10.449     0.200
     2.387     9.783     0.200
     2.437    10.489     0.200
     2.410    11.127     0.200
     2.469    10.620     0.200
     2.574    10.606     0.200
     2.748    12.040     0.200
     2.861    11.864     0.200
     2.932    12.037     0.200
     3.066    12.620     0.200
     3.121    12.007     0.200
     3.121    11.000     0.200
     3.259    13.040     0.200
     3.292    13.436     0.200
     3.324    13.752     0.200
     3.316    12.543     0.200
     3.391    12.290     0.200
     3.634    12.699     0.200
     3.750    12.674     0.200
     3.745    13.650     0.200
     3.827    14.168     0.200
     3.927    13.177     0.200
     4.005    14.506     0.200
     4.011    13.926     0.200
     4.077    14.223     0.200
     4.077    13.570     0.200
     4.233    13.860     0.200
     4.342    14.363     0.200
     4.349    13.928     0.200
     4.447    14.521     0.200
     4.519    15.196     0.200
     4.653    15.179     0.200
     4.885    16.121     0.200
     4.940    15.587     0.200
     5.139    15.575     0.200
     5.178    16.523     0.200
     5.391    17.308     0.200
     5.448    16.547     0.200
     5.422    16.300     0.200
     5.768    19.838     0.200
     5.862    15.916     0.200
     2.003    11.896     0.200
     2.045    12.553     0.200
     2.017    13.693     0.200
     2.368    14.369     0.200
     2.407    15.234     0.200
     2.778    13.690     0.200
     2.875    13.742     0.200
     2.964    13.972     0.200
     3.025    14.055     0.200
     3.077    12.354     0.200
     3.046    14.159     0.200
     3.309    15.222     0.200
     3.402    16.569     0.200
     3.882    17.121     0.200
     4.058    16.671     0.200
     4.001    16.548     0.200
     4.318    16.766     0.200
     4.458    17.699     0.200
     4.500    17.505     0.200
     4.659    18.180     0.200
     4.676    18.127     0.200
     5.113    18.791     0.200
     1.902    11.500     0.200
     1.910    11.518     0.200
     2.149    13.388     0.200
     2.198    13.132     0.200
     2.247    12.140     0.200
     2.335    13.467     0.200
     2.335    13.217     0.200
     2.384    14.532     0.200
     2.501    12.554     0.200
     2.516    13.021     0.200
     2.747    13.528     0.200
     2.830    13.611     0.200
     2.830    13.752     0.200
     2.912    15.046     0.200
     3.006    15.344     0.200
     3.151    14.600     0.200
     3.154    15.654     0.200
     3.443    15.599     0.200
     3.472    16.140     0.200
     3.516    14.222     0.200
     3.944    17.626     0.200
     3.944    17.126     0.200
     4.142    17.042     0.200
     4.192    17.699     0.200
     4.402    19.144     0.200
     4.419    16.867     0.200
     4.591    18.813     0.200
     4.634    18.576     0.200
     4.677    18.439     0.200
     4.725    20.358     0.200
     4.779    18.912     0.200
     4.894    19.230     0.200
     4.946    19.789     0.200
     5.150    18.800     0.200
     5.576    20.144     0.200
     3.142    14.819     0.200
     1.893    10.740     0.200
     1.928    11.536     0.200
     1.928    11.286     0.200
     2.014    11.343     0.200
     2.088    11.518     0.200
     2.262    11.890     0.200
     2.262    11.982     0.200
     2.260    12.036     0.200
     2.257    11.584     0.200
     2.361    11.784     0.200
     2.612    12.950     0.200
     2.615    12.508     0.200
     2.641    13.585     0.200
     2.716    13.111     0.200
     2.716    11.845     0.200
     3.375    13.666     0.200
     3.556    14.087     0.200
     3.575    13.720     0.200
     3.580    15.163     0.200
     3.639    14.739     0.200
     4.003    15.916     0.200
     4.003    16.283     0.200
     4.241    17.599     0.200
     4.241    15.817     0.200
     4.305    16.525     0.200
     4.498    16.342     0.200
     4.747    16.898     0.200
     4.798    16.996     0.200
     4.798    17.957     0.200
     3.230    13.288     0.200
     1.896    10.807     0.200
     1.931    11.049     0.200
     1.931    11.408     0.200
     2.017    11.144     0.200
     2.084    12.298     0.200
     2.265    11.481     0.200
     2.265    12.175     0.200
     2.264    11.509     0.200
     2.252    11.683     0.200
     2.364    12.067     0.200
     2.614    12.827     0.200
     2.618    12.816     0.200
     2.639    12.350     0.200
     2.713    13.586     0.200
     2.713    11.875     0.200
     2.843    11.942     0.200
     3.235    15.316     0.200
     3.559    14.008     0.200
     3.578    15.761     0.200
     4.002    15.942     0.200
     4.242    16.528     0.200
     4.242    15.372     0.200
     4.309    16.118     0.200
     4.797    16.725     0.200
     4.797    17.795     0.200
     5.011    17.377     0.200
     3.231    12.726     0.200
     1.988    11.808     0.200
     2.095    11.896     0.200
     2.112    11.108     0.200
     2.169    12.240     0.200
     2.118    13.585     0.200
     2.288    12.529     0.200
     2.353    11.996     0.200
     2.515    12.702     0.200
     2.579    13.151     0.200
     2.617    11.804     0.200
     2.886    15.088     0.200
     2.971    13.224     0.200
     2.990    13.250     0.200
     3.105    14.017     0.200
     3.169    14.920     0.200
     3.205    13.776     0.200
     3.470    15.669     0.200
     3.893    14.727     0.200
     3.901    15.395     0.200
     4.517    17.010     0.200
    15.354    37.857     0.200
    15.444    39.249     0.200
    15.571    39.119     0.200
    15.990    39.212     0.200
    16.200    39.305     0.200
     1.250    10.360     0.200
     2.990    13.664     0.200
     2.990    13.774     0.200
     4.000    16.484     0.200
     5.217    18.585     0.200
     5.483    18.887     0.200
     6.598    22.085     0.200
     6.544    25.399     0.200
     6.691    24.805     0.200
     6.945    24.922     0.200
     6.941    25.664     0.200
     7.243    24.140     0.200
     7.243    24.413     0.200
     7.874    25.778     0.200
     8.236    27.147     0.200
     8.310    28.091     0.200
     8.334    26.938     0.200
     8.334    26.516     0.200
     8.642    27.424     0.200
    10.114    32.215     0.200
    10.129    32.759     0.200
    10.371    30.937     0.200
    12.620    34.939     0.200
    12.926    37.412     0.200
    13.831    37.433     0.200
    13.944    39.032     0.200
    13.997    38.136     0.200
    15.354    40.201     0.200
    15.931    39.813     0.200
    15.990    39.376     0.200
     1.912    11.349     0.200
     1.947    11.544     0.200
     2.720    14.794     0.200
     2.867    14.640     0.200
     3.152    13.879     0.200
     3.396    15.292     0.200
     3.778    16.259     0.200
     3.794    15.462     0.200
     3.772    15.319     0.200
     4.008    15.960     0.200
     4.007    16.234     0.200
     4.262    16.280     0.200
     4.560    17.045     0.200
     4.853    18.026     0.200
     5.015    16.758     0.200
     5.098    18.955     0.200
     5.386    18.137     0.200
     5.890    20.693     0.200
     6.176    21.236     0.200
     6.179    20.313     0.200
     6.613    23.112     0.200
     7.250    22.389     0.200
     7.351    22.802     0.200
     7.914    23.738     0.200
     8.417    24.838     0.200
     9.429    28.702     0.200
     9.530    29.117     0.200
    11.283    30.511     0.200
    12.285    31.975     0.200
    12.704    32.913     0.200
    12.891    34.487     0.200
    15.340    39.839     0.200
    16.004    37.877     0.200
     7.250    22.600     0.200
     1.836    12.914     0.200
     1.876    12.711     0.200
     1.920    12.795     0.200
     1.990    13.060     0.200
     2.279    13.517     0.200
     2.356    13.788     0.200
     2.524    13.471     0.200
     2.586    13.953     0.200
     2.615    15.289     0.200
     3.112    14.099     0.200
     3.174    15.530     0.200
     3.202    16.406     0.200
     3.983    15.829     0.200
     3.897    17.795     0.200
     4.518    18.649     0.200
     4.984    18.066     0.200
     5.018    19.399     0.200
     6.600    21.679     0.200
     6.764    20.521     0.200
     7.333    23.923     0.200
    15.999    38.140     0.200
     1.925    12.413     0.200
     2.110    12.465     0.200
     2.179    12.695     0.200
     2.153    13.928     0.200
     2.381    13.977     0.200
     2.524    13.084     0.200
     2.594    13.569     0.200
     2.651    14.145     0.200
     3.122    14.468     0.200
     3.192    14.432     0.200
     3.240    15.757     0.200
     3.499    15.275     0.200
     3.988    15.592     0.200
     3.936    17.249     0.200
     4.190    17.367     0.200
     4.991    17.543     0.200
     5.839    22.744     0.200
     5.853    20.527     0.200
     6.138    21.998     0.200
     6.824    22.633     0.200
     7.247    23.352     0.200
     7.336    23.313     0.200
     8.266    24.955     0.200
     9.355    28.308     0.200
    10.246    29.590     0.200
    11.278    31.887     0.200
    12.242    36.405     0.200
     1.959    12.964     0.200
     1.924    12.730     0.200
     1.932    14.320     0.200
     2.058    13.331     0.200
     2.034    12.274     0.200
     2.161    14.216     0.200
     2.409    13.215     0.200
     2.441    14.385     0.200
     2.412    14.615     0.200
     2.606    14.615     0.200
     3.002    15.882     0.200
     3.140    15.462     0.200
     3.341    15.013     0.200
     3.313    17.241     0.200
     3.500    14.691     0.200
     3.617    15.022     0.200
     3.521    16.584     0.200
     3.633    16.911     0.200
     3.698    17.083     0.200
     3.848    16.009     0.200
     3.878    16.644     0.200
     3.955    17.606     0.200
     4.319    17.828     0.200
     4.667    19.337     0.200
     4.821    19.417     0.200
     4.863    20.282     0.200
     5.149    19.682     0.200
     5.614    19.010     0.200
     5.621    21.840     0.200
     7.154    22.542     0.200
     7.204    23.479     0.200
     8.149    25.490     0.200
     9.394    28.016     0.200
    10.204    29.922     0.200
    10.557    30.359     0.200
    10.866    32.007     0.200
    15.889    39.668     0.200
     1.878    11.587     0.200
     1.932    12.539     0.200
     2.046    12.935     0.200
     2.158    12.654     0.200
     2.172    13.050     0.200
     2.231    12.743     0.200
     2.227    13.239     0.200
     2.413    13.999     0.200
     2.576    12.876     0.200
     2.642    13.401     0.200
     2.825    13.970     0.200
     3.169    14.326     0.200
     3.232    15.049     0.200
     3.247    16.345     0.200
     3.384    15.066     0.200
     4.038    15.784     0.200
     5.061    19.856     0.200
     6.550    21.159     0.200
     8.318    25.471     0.200
     8.461    24.998     0.200
     8.583    25.700     0.200
     9.624    27.678     0.200
    10.291    29.133     0.200
     1.885    11.891     0.200
     1.904    12.332     0.200
     1.946    12.840     0.200
     1.999    12.886     0.200
     2.067    12.602     0.200
     2.125    13.324     0.200
     2.350    13.047     0.200
     2.386    12.801     0.200
     2.400    13.675     0.200
     2.465    13.698     0.200
     2.537    14.552     0.200
     2.600    15.832     0.200
     2.698    14.540     0.200
     2.904    14.863     0.200
     2.951    14.436     0.200
     2.997    15.686     0.200
     3.099    15.886     0.200
     3.186    15.431     0.200
     3.287    15.317     0.200
     3.262    16.005     0.200
     3.440    14.805     0.200
     3.552    14.957     0.200
     3.614    16.623     0.200
     3.695    16.999     0.200
     3.791    15.669     0.200
     3.839    17.570     0.200
     3.955    17.476     0.200
     3.974    17.314     0.200
     4.287    18.115     0.200
     4.293    19.588     0.200
     4.818    19.187     0.200
     4.898    19.561     0.200
     5.123    20.839     0.200
     5.885    21.867     0.200
     6.434    22.874     0.200
     6.718    20.510     0.200
     8.106    26.656     0.200
     9.130    29.566     0.200
     9.238    29.283     0.200
     1.908    11.994     0.200
     2.001    12.560     0.200
     1.961    12.660     0.200
     2.055    12.720     0.200
     2.136    11.836     0.200
     2.351    12.804     0.200
     2.391    13.577     0.200
     2.415    14.403     0.200
     2.461    12.762     0.200
     2.593    15.579     0.200
     2.714    14.336     0.200
     2.910    13.853     0.200
     2.959    14.183     0.200
     3.012    15.449     0.200
     3.128    16.736     0.200
     3.171    16.179     0.200
     3.206    14.191     0.200
     3.292    14.509     0.200
     3.269    15.359     0.200
     3.575    15.237     0.200
     3.540    15.316     0.200
     3.566    16.117     0.200
     3.628    16.455     0.200
     3.710    16.800     0.200
     3.795    15.112     0.200
     3.849    16.623     0.200
     3.970    17.337     0.200
     4.020    16.817     0.200
     3.989    17.719     0.200
     4.092    17.073     0.200
     4.079    18.243     0.200
     4.101    17.432     0.200
     4.102    16.619     0.200
     4.181    16.873     0.200
     4.198    17.446     0.200
     4.284    16.336     0.200
     4.302    17.322     0.200
     4.299    17.438     0.200
     4.308    18.794     0.200
     4.391    18.198     0.200
     4.398    18.790     0.200
     4.410    18.571     0.200
     4.568    18.296     0.200
     4.632    19.327     0.200
     4.789    17.060     0.200
     4.871    19.168     0.200
     4.833    18.729     0.200
     4.912    19.399     0.200
     5.121    18.330     0.200
     5.102    18.900     0.200
     5.136    20.057     0.200
     5.339    20.890     0.200
     5.356    19.483     0.200
     5.500    19.765     0.200
     5.562    18.677     0.200
     5.532    19.716     0.200
     5.595    21.450     0.200
     5.639    21.096     0.200
     5.666    21.132     0.200
     5.771    19.949     0.200
     5.906    21.443     0.200
     5.899    21.351     0.200
     6.305    22.544     0.200
     6.327    22.537     0.200
     6.369    21.105     0.200
     6.387    22.205     0.200
     6.452    22.934     0.200
     6.566    21.616     0.200
     6.525    22.982     0.200
     6.807    22.838     0.200
     7.094    22.046     0.200
     7.150    23.206     0.200
     7.247    24.550     0.200
     7.239    24.063     0.200
     7.586    23.763     0.200
     7.681    23.610     0.200
     7.891    24.042     0.200
     8.231    25.122     0.200
     8.310    26.079     0.200
     9.145    29.637     0.200
     9.217    29.373     0.200
     9.286    30.018     0.200
     9.561    27.662     0.200
    10.028    28.707     0.200
    10.289    31.761     0.200
    10.524    29.555     0.200
    10.818    30.437     0.200
    11.118    30.795     0.200
    11.082    32.721     0.200
    12.403    33.961     0.200
     2.001    12.459     0.200
     2.133    11.457     0.200
     2.058    11.456     0.200
     2.351    13.146     0.200
     2.390    12.704     0.200
     2.411    14.211     0.200
     2.590    14.826     0.200
     2.462    13.444     0.200
     2.709    14.548     0.200
     2.909    12.773     0.200
     2.957    13.458     0.200
     3.007    14.025     0.200
     3.291    14.247     0.200
     3.176    14.683     0.200
     3.267    14.040     0.200
     3.573    14.405     0.200
     3.624    15.064     0.200
     3.543    14.961     0.200
     3.562    16.460     0.200
     3.794    14.845     0.200
     3.705    16.345     0.200
     3.846    15.764     0.200
     3.965    16.172     0.200
     3.985    17.021     0.200
     4.090    16.525     0.200
     4.179    16.142     0.200
     4.106    17.572     0.200
     4.282    16.659     0.200
     4.299    17.454     0.200
     4.296    17.922     0.200
     4.303    18.563     0.200
     4.388    17.741     0.200
     4.566    18.020     0.200
     4.630    17.986     0.200
     4.869    18.096     0.200
     4.829    17.345     0.200
     4.907    18.217     0.200
     5.132    19.373     0.200
     5.335    20.770     0.200
     5.495    19.244     0.200
     5.592    21.187     0.200
     5.634    20.486     0.200
     5.895    20.016     0.200
     6.324    22.806     0.200
     7.094    22.127     0.200
     7.234    23.033     0.200
     7.890    23.897     0.200
     8.306    25.228     0.200
     9.140    28.489     0.200
    10.285    31.123     0.200
    10.360    31.220     0.200
     1.914    12.687     0.200
     1.874    12.811     0.200
     2.266    12.877     0.200
     2.289    12.303     0.200
     2.300    13.507     0.200
     2.625    13.887     0.200
     2.560    12.512     0.200
     2.803    13.138     0.200
     2.842    13.487     0.200
     3.188    13.147     0.200
     3.158    14.535     0.200
     3.462    15.193     0.200
     3.508    16.082     0.200
     3.600    16.178     0.200
     3.697    15.656     0.200
     3.727    16.309     0.200
     3.864    16.623     0.200
     3.977    15.756     0.200
     4.069    16.440     0.200
     4.166    16.838     0.200
     4.181    17.045     0.200
     4.176    17.299     0.200
     4.757    18.349     0.200
     4.746    18.080     0.200
     4.725    18.668     0.200
     5.472    20.692     0.200
     5.701    20.804     0.200
     6.021    20.707     0.200
     6.218    21.457     0.200
     7.014    22.447     0.200
     9.917    28.831     0.200
     1.910    11.741     0.200
     2.004    12.970     0.200
     1.956    13.504     0.200
     2.056    12.507     0.200
     2.136    11.999     0.200
     2.354    12.508     0.200
     2.393    12.270     0.200
     2.412    14.297     0.200
     2.548    14.939     0.200
     2.592    15.029     0.200
     2.710    14.442     0.200
     2.713    15.879     0.200
     2.912    13.285     0.200
     2.960    14.050     0.200
     3.008    14.965     0.200
     3.108    15.858     0.200
     3.126    17.030     0.200
     3.174    15.605     0.200
     3.294    14.954     0.200
     3.270    14.865     0.200
     3.444    14.343     0.200
     3.625    16.786     0.200
     3.706    16.302     0.200
     3.797    14.778     0.200
     3.849    16.140     0.200
     3.966    17.319     0.200
     3.986    15.952     0.200
     4.020    16.857     0.200
     4.093    16.132     0.200
     4.182    15.944     0.200
     4.201    18.855     0.200
     4.285    17.415     0.200
     4.302    17.509     0.200
     4.298    17.450     0.200
     4.395    19.209     0.200
     4.632    19.072     0.200
     4.791    16.792     0.200
     4.830    18.131     0.200
     4.872    18.383     0.200
     4.906    18.761     0.200
     5.123    18.881     0.200
     5.134    20.404     0.200
     5.337    20.467     0.200
     5.352    19.005     0.200
     5.352    18.497     0.200
     5.497    20.805     0.200
     5.564    18.258     0.200
     5.594    20.393     0.200
     5.768    20.213     0.200
     5.907    20.599     0.200
     5.897    21.076     0.200
     6.074    21.247     0.200
     6.138    21.359     0.200
     6.326    22.176     0.200
     6.520    22.790     0.200
     6.584    23.113     0.200
     6.620    22.873     0.200
     6.749    22.852     0.200
     7.097    21.919     0.200
     7.153    22.862     0.200
     7.234    23.961     0.200
     7.745    24.609     0.200
     7.820    24.761     0.200
     7.909    24.783     0.200
     7.916    24.547     0.200
     8.090    24.905     0.200
     8.094    24.809     0.200
     8.154    25.166     0.200
     8.118    27.107     0.200
     8.183    25.049     0.200
     8.188    25.528     0.200
     8.234    25.470     0.200
     8.284    25.389     0.200
     8.319    25.655     0.200
     8.306    27.943     0.200
     8.307    27.272     0.200
     8.351    25.268     0.200
     8.415    25.815     0.200
     8.486    25.669     0.200
     8.905    26.895     0.200
    10.029    28.987     0.200
    10.360    31.135     0.200
     1.934    11.919     0.200
     1.891    12.703     0.200
     2.058    12.629     0.200
     2.065    14.209     0.200
     2.139    13.067     0.200
     2.301    13.017     0.200
     2.318    12.936     0.200
     2.486    13.410     0.200
     2.541    13.162     0.200
     2.560    14.254     0.200
     2.753    15.148     0.200
     2.828    13.920     0.200
     3.065    14.215     0.200
     3.028    15.080     0.200
     3.122    14.391     0.200
     3.045    13.997     0.200
     3.149    15.690     0.200
     3.445    14.533     0.200
     3.427    15.488     0.200
     3.380    14.771     0.200
     3.627    16.816     0.200
     3.734    15.693     0.200
     3.782    16.353     0.200
     3.844    16.002     0.200
     3.941    15.119     0.200
     4.014    16.830     0.200
     3.950    16.761     0.200
     4.099    16.984     0.200
     4.056    18.224     0.200
     4.129    17.712     0.200
     4.254    17.294     0.200
     4.340    16.748     0.200
     4.448    17.593     0.200
     4.467    17.696     0.200
     4.462    17.783     0.200
     4.453    18.459     0.200
     4.551    18.402     0.200
     4.733    18.265     0.200
     4.939    17.677     0.200
     4.966    19.007     0.200
     5.032    18.874     0.200
     5.277    18.486     0.200
     5.296    19.027     0.200
     5.497    20.589     0.200
     5.496    19.112     0.200
     5.496    18.940     0.200
     5.540    18.744     0.200
     5.648    19.499     0.200
     5.678    19.053     0.200
     5.710    18.779     0.200
     5.760    20.581     0.200
     5.763    19.606     0.200
     5.911    19.977     0.200
     6.069    21.267     0.200
     6.050    20.129     0.200
     6.464    21.699     0.200
     6.491    22.186     0.200
     6.543    22.468     0.200
     6.615    21.560     0.200
     6.638    23.487     0.200
     6.655    22.596     0.200
     7.219    22.393     0.200
     7.293    23.503     0.200
     7.342    24.062     0.200
     7.400    24.313     0.200
     7.632    24.403     0.200
     7.748    23.695     0.200
     8.254    26.312     0.200
     8.370    25.709     0.200
     8.461    27.835     0.200
     9.171    26.979     0.200
     9.265    29.310     0.200
     9.374    29.384     0.200
     9.515    27.798     0.200
    10.481    32.209     0.200
    11.245    30.485     0.200
    12.129    34.565     0.200
    12.469    34.665     0.200
     1.908    12.062     0.200
     1.918    12.271     0.200
     2.046    13.140     0.200
     2.031    13.969     0.200
     2.132    13.486     0.200
     2.276    13.041     0.200
     2.326    13.267     0.200
     2.481    13.510     0.200
     2.530    14.157     0.200
     2.528    14.811     0.200
     2.724    15.703     0.200
     2.793    14.780     0.200
     2.798    15.271     0.200
     3.051    14.512     0.200
     3.061    15.181     0.200
     3.103    14.900     0.200
     3.073    14.215     0.200
     3.115    16.023     0.200
     3.264    17.354     0.200
     3.432    14.684     0.200
     3.409    15.681     0.200
     3.412    15.417     0.200
     3.566    15.313     0.200
     3.595    17.482     0.200
     3.718    16.425     0.200
     3.751    17.160     0.200
     3.811    16.478     0.200
     3.932    16.320     0.200
     3.990    18.072     0.200
     3.982    16.783     0.200
     4.065    16.921     0.200
     4.096    17.731     0.200
     4.162    18.513     0.200
     4.236    17.830     0.200
     4.324    17.161     0.200
     4.428    18.417     0.200
     4.420    19.357     0.200
     4.436    18.418     0.200
     4.444    17.628     0.200
     4.521    18.955     0.200
     4.711    18.551     0.200
     4.775    19.393     0.200
     4.928    17.841     0.200
     4.932    19.472     0.200
     5.015    19.590     0.200
     5.263    18.432     0.200
     5.478    21.873     0.200
     5.463    19.299     0.200
     5.549    20.825     0.200
     5.616    21.419     0.200
     5.735    21.960     0.200
     5.729    22.356     0.200
     5.877    20.993     0.200
     5.964    21.390     0.200
     6.217    21.871     0.200
     6.280    21.772     0.200
     6.296    23.077     0.200
     6.458    23.325     0.200
     6.466    22.882     0.200
     6.555    22.831     0.200
     6.550    23.918     0.200
     6.588    22.537     0.200
     6.723    22.963     0.200
     6.686    22.510     0.200
     7.217    22.375     0.200
     7.285    23.567     0.200
     7.308    24.371     0.200
     7.600    25.483     0.200
     8.034    24.912     0.200
     8.266    25.732     0.200
     8.363    25.960     0.200
     8.430    28.625     0.200
     8.535    27.652     0.200
     9.314    30.234     0.200
     9.322    30.442     0.200
     9.727    31.034     0.200
    10.094    31.049     0.200
    10.171    29.369     0.200
    10.447    32.078     0.200
    15.277    38.955     0.200
    15.960    38.112     0.200
    16.169    40.431     0.200
     1.973    12.505     0.200
     1.928    14.113     0.200
     2.073    13.307     0.200
     2.028    12.828     0.200
     2.170    13.100     0.200
     2.424    13.852     0.200
     2.413    15.174     0.200
     2.455    13.931     0.200
     2.394    13.737     0.200
     2.611    16.146     0.200
     2.970    14.865     0.200
     3.008    15.197     0.200
    15.390    40.122     0.200
    15.904    39.550     0.200
    16.094    41.374     0.200
     5.685    19.791     0.200
     7.169    22.980     0.200
     8.214    25.886     0.200
     8.777    27.571     0.200
    10.302    33.051     0.200
    12.876    34.999     0.200
     1.922    12.864     0.200
     1.927    13.064     0.200
     1.988    12.319     0.200
     2.103    13.026     0.200
     2.180    13.215     0.200
     2.107    13.295     0.200
     2.354    13.294     0.200
     2.277    12.915     0.200
     2.526    13.343     0.200
     2.587    14.076     0.200
     2.611    15.417     0.200
     3.113    14.615     0.200
     1.887    13.232     0.200
     1.971    13.057     0.200
     2.066    12.004     0.200
     1.876    12.105     0.200
     1.924    13.873     0.200
     1.975    12.931     0.200
     1.885    12.346     0.200
     1.839    11.965     0.200
     1.987    12.784     0.200
     2.092    13.285     0.200
     2.112    12.741     0.200
     2.114    12.935     0.200
     2.191    12.980     0.200
     2.266    13.046     0.200
     2.354    13.617     0.200
     2.538    12.842     0.200
     2.596    13.264     0.200
     2.603    14.395     0.200
     2.766    15.097     0.200
     2.802    15.368     0.200
     2.862    15.628     0.200
     2.988    14.701     0.200
     2.995    13.437     0.200
     3.120    13.917     0.200
     3.177    14.067     0.200
     3.188    14.898     0.200
     3.331    14.251     0.200
     7.269    22.034     0.200
     8.106    25.125     0.200
     8.601    26.966     0.200
    10.241    29.582     0.200
    10.465    30.246     0.200
    10.511    32.217     0.200
     1.844    11.925     0.200
     1.945    12.783     0.200
     1.912    13.275     0.200
     2.062    11.875     0.200
     2.129    13.456     0.200
     2.296    12.825     0.200
     2.326    13.278     0.200
     2.347    14.443     0.200
     2.520    15.616     0.200
     2.660    14.578     0.200
     2.843    13.419     0.200
     2.887    14.523     0.200
     2.947    14.803     0.200
     2.073    12.525     0.200
     2.127    13.771     0.200
     2.314    13.384     0.200
     2.368    13.104     0.200
     2.383    13.312     0.200
     2.465    13.483     0.200
     2.893    14.551     0.200
     2.920    14.724     0.200
     2.905    14.508     0.200
     3.546    15.609     0.200
     3.794    15.783     0.200
     1.982    10.070     0.200
     2.334    10.666     0.200
     2.358    10.367     0.200
     2.907    12.372     0.200
     3.257    12.986     0.200
     3.226    13.287     0.200
     3.251    13.586     0.200
     3.427    13.432     0.200
     3.277    12.531     0.200
     3.529    13.528     0.200
     3.766    14.400     0.200
     3.612    13.606     0.200
     3.788    14.885     0.200
     3.889    15.235     0.200
     4.136    14.547     0.200
     4.243    16.038     0.200
     4.318    16.827     0.200
     4.823    16.737     0.200
     4.845    17.343     0.200
     5.063    17.272     0.200
     5.276    16.823     0.200
     5.421    17.144     0.200
     5.531    17.275     0.200
     5.558    18.849     0.200
     5.854    18.699     0.200
     5.770    17.559     0.200
     6.262    20.365     0.200
     6.383    19.966     0.200
     6.444    20.662     0.200
     7.081    21.241     0.200
     7.124    21.724     0.200
     7.170    21.627     0.200
     7.406    21.767     0.200
     7.515    21.828     0.200
     7.846    22.828     0.200
     8.062    23.201     0.200
     9.209    27.472     0.200
    10.284    31.106     0.200
    11.102    29.463     0.200
    12.336    32.761     0.200
     1.917    12.209     0.200
     2.014    13.267     0.200
     1.940    14.113     0.200
     2.059    13.370     0.200
     2.133    12.481     0.200
     2.365    13.317     0.200
     2.400    13.748     0.200
     2.401    14.440     0.200
     2.450    14.039     0.200
     2.918    13.748     0.200
     2.962    14.850     0.200
     2.996    15.331     0.200
     3.213    14.001     0.200
     3.301    14.714     0.200
     3.275    16.097     0.200
     3.580    15.290     0.200
     3.547    15.029     0.200
     3.542    17.369     0.200
     3.694    16.908     0.200
     3.806    15.554     0.200
     3.953    17.606     0.200
     4.096    17.629     0.200
     4.286    18.301     0.200
     4.301    17.947     0.200
     4.294    18.013     0.200
     4.569    18.668     0.200
     4.798    17.583     0.200
     4.875    19.601     0.200
     4.887    20.622     0.200
     5.487    22.140     0.200
     5.572    18.900     0.200
     5.592    22.252     0.200
     5.909    21.742     0.200
     6.615    23.074     0.200
     6.934    24.047     0.200
     7.236    26.803     0.200
     9.200    29.850     0.200
    15.442    39.026     0.200
    16.054    40.908     0.200
     1.824    11.897     0.200
     1.932    12.673     0.200
     1.937    12.190     0.200
     2.001    12.637     0.200
     2.114    12.829     0.200
     2.127    12.826     0.200
     2.190    12.882     0.200
     2.267    12.714     0.200
     2.368    12.953     0.200
     2.536    13.064     0.200
     2.599    13.848     0.200
     2.624    14.451     0.200
     2.820    15.328     0.200
     2.882    13.946     0.200
     2.965    15.139     0.200
     2.978    13.583     0.200
     3.124    14.482     0.200
     3.186    14.299     0.200
     3.210    15.878     0.200
     3.313    14.473     0.200
     3.503    14.566     0.200
     3.488    15.413     0.200
     3.662    16.593     0.200
     3.796    15.251     0.200
     3.847    16.364     0.200
     3.905    17.200     0.200
     3.885    16.265     0.200
     3.995    15.797     0.200
     4.158    17.408     0.200
     4.191    16.662     0.200
     4.317    17.212     0.200
     4.402    17.124     0.200
     4.512    17.873     0.200
     4.516    18.827     0.200
     4.530    17.603     0.200
     4.532    17.649     0.200
     4.618    18.407     0.200
     4.799    18.753     0.200
     4.861    19.016     0.200
     4.990    19.536     0.200
     5.742    19.270     0.200
     5.973    20.545     0.200
     6.547    20.114     0.200
     6.590    21.412     0.200
    15.237    39.055     0.200
     1.978    12.370     0.200
     2.109    11.320     0.200
     2.328    12.281     0.200
     2.365    12.860     0.200
     2.392    13.309     0.200
     2.567    15.121     0.200
     2.697    13.480     0.200
     2.884    13.518     0.200
     2.932    13.805     0.200
     2.990    14.439     0.200
     3.266    14.092     0.200
     3.195    15.618     0.200
     3.242    14.854     0.200
     3.233    13.799     0.200
     3.548    14.831     0.200
     3.603    16.118     0.200
     3.566    14.542     0.200
     3.689    15.904     0.200
     3.770    14.916     0.200
     3.949    16.551     0.200
     4.065    16.314     0.200
     4.154    16.575     0.200
     4.127    15.316     0.200
     4.257    16.883     0.200
     4.274    17.102     0.200
     4.272    17.054     0.200
     4.365    18.327     0.200
     4.541    17.548     0.200
     4.604    17.276     0.200
     4.763    16.705     0.200
     4.844    17.891     0.200
     4.812    18.233     0.200
     4.906    18.599     0.200
     5.095    18.506     0.200
     5.079    18.255     0.200
     1.881    11.910     0.200
     1.981    12.379     0.200
     2.094    11.823     0.200
     2.332    12.943     0.200
     2.363    13.314     0.200
     2.369    13.529     0.200
     2.670    14.017     0.200
     2.880    13.934     0.200
     2.923    14.405     0.200
     2.966    14.763     0.200
     3.263    14.147     0.200
     3.236    15.385     0.200
     3.218    15.783     0.200
     3.541    15.210     0.200
     3.582    16.772     0.200
     3.585    14.957     0.200
     3.664    15.850     0.200
     3.769    15.260     0.200
     3.924    16.855     0.200
     4.057    17.051     0.200
     4.147    16.581     0.200
     4.148    16.761     0.200
     4.247    16.956     0.200
     4.262    17.646     0.200
     4.256    17.267     0.200
     4.261    18.541     0.200
     4.244    17.379     0.200
     4.346    18.631     0.200
     4.529    17.594     0.200
     4.594    18.612     0.200
     4.761    17.023     0.200
     4.787    17.790     0.200
     4.836    19.022     0.200
     4.880    18.965     0.200
    15.480    39.660     0.200
     1.931    13.053     0.200
     1.985    12.455     0.200
     2.105    11.636     0.200
     2.087    13.084     0.200
     2.336    12.921     0.200
     2.370    13.117     0.200
     2.381    13.567     0.200
     2.517    14.529     0.200
     2.481    12.942     0.200
     2.560    15.818     0.200
     2.682    15.083     0.200
     2.887    13.912     0.200
     2.932    14.537     0.200
     2.978    14.851     0.200
     3.594    17.293     0.200
     3.676    16.990     0.200
     3.775    15.371     0.200
     4.364    19.840     0.200
     4.603    19.689     0.200
     4.767    17.626     0.200
     4.800    19.149     0.200
     5.097    19.005     0.200
     5.068    19.532     0.200
     5.542    18.840     0.200
     5.564    20.602     0.200
     5.606    21.485     0.200
     5.865    21.304     0.200
     1.993    12.332     0.200
     1.913    12.533     0.200
     2.095    13.433     0.200
     2.023    12.586     0.200
     2.177    13.086     0.200
     2.447    13.366     0.200
     2.409    14.652     0.200
     2.613    15.986     0.200
     2.674    14.441     0.200
     2.988    14.376     0.200
     3.021    14.959     0.200
     2.995    14.852     0.200
     3.159    16.881     0.200
     3.181    15.204     0.200
     3.183    13.968     0.200
     3.490    16.185     0.200
     3.635    17.192     0.200
     3.976    18.270     0.200
     4.389    19.046     0.200
     4.400    18.933     0.200
     4.689    19.529     0.200
     4.774    19.227     0.200
     4.938    19.044     0.200
     4.900    19.032     0.200
     5.197    18.949     0.200
     5.095    19.378     0.200
     5.156    20.805     0.200
     5.343    18.975     0.200
     5.647    18.972     0.200
     5.637    21.946     0.200
     5.608    20.819     0.200
     5.757    21.139     0.200
     5.990    21.818     0.200
     6.049    21.871     0.200
     6.063    21.588     0.200
     6.126    21.812     0.200
     6.138    21.411     0.200
     6.208    20.596     0.200
     6.323    23.319     0.200
     6.366    21.966     0.200
     6.444    21.668     0.200
     6.355    21.567     0.200
     6.488    21.567     0.200
     6.483    22.010     0.200
     6.688    24.053     0.200
     7.253    25.712     0.200
     7.481    24.834     0.200
     7.612    24.080     0.200
     7.908    25.076     0.200
     7.962    24.704     0.200
     8.180    25.433     0.200
     8.100    24.343     0.200
    15.372    39.960     0.200
    15.634    39.513     0.200
     1.880    12.284     0.200
     1.924    12.652     0.200
     1.928    12.573     0.200
     1.997    12.376     0.200
     2.119    12.949     0.200
     2.181    13.187     0.200
     2.276    12.442     0.200
     2.362    13.235     0.200
     2.527    13.477     0.200
     2.622    14.714     0.200
     2.590    13.972     0.200
     2.816    16.275     0.200
     2.837    15.445     0.200
     2.883    14.534     0.200
     2.982    14.455     0.200
     2.967    14.256     0.200
     3.117    14.665     0.200
     3.209    15.999     0.200
     3.180    14.897     0.200
     3.317    14.612     0.200
     3.495    14.502     0.200
     3.667    16.204     0.200
     3.607    15.501     0.200
     3.845    17.130     0.200
     3.905    16.950     0.200
     3.987    15.967     0.200
     3.995    17.986     0.200
     4.525    18.050     0.200
     4.855    19.281     0.200
     4.995    19.637     0.200
     5.088    18.691     0.200
     5.207    19.429     0.200
     5.454    19.862     0.200
     5.821    21.855     0.200
     6.113    22.367     0.200
     6.947    23.862     0.200
     7.254    22.727     0.200
     7.394    24.535     0.200
     8.524    27.130     0.200
     9.229    27.406     0.200
     9.343    27.380     0.200
    10.239    29.044     0.200
    10.345    31.282     0.200
    10.537    32.603     0.200
    10.453    30.267     0.200
    11.023    32.455     0.200
    11.284    32.141     0.200
    12.890    35.499     0.200
    15.530    41.461     0.200
    16.002    39.772     0.200
     1.874    12.072     0.200
     1.908    12.254     0.200
     1.912    12.806     0.200
     2.009    13.071     0.200
     2.111    12.316     0.200
     2.083    12.404     0.200
     2.360    13.360     0.200
     2.374    15.275     0.200
     2.390    13.528     0.200
     2.459    13.199     0.200
     2.560    16.450     0.200
     2.666    14.931     0.200
     2.905    14.153     0.200
     2.945    15.012     0.200
     2.968    15.116     0.200
     3.213    15.805     0.200
     3.290    14.809     0.200
     3.237    14.516     0.200
     3.261    15.714     0.200
     3.516    15.693     0.200
     3.565    15.578     0.200
     3.591    17.446     0.200
     3.572    15.730     0.200
     3.665    17.272     0.200
     3.797    15.709     0.200
     3.924    16.636     0.200
     3.946    17.814     0.200
     4.080    17.458     0.200
     4.172    17.114     0.200
     4.140    17.833     0.200
     4.269    18.320     0.200
     4.266    18.911     0.200
     4.282    18.002     0.200
     4.240    18.967     0.200
     4.358    19.129     0.200
     4.549    18.788     0.200
     4.862    19.824     0.200
     5.313    18.596     0.200
     5.448    20.159     0.200
    15.454    39.724     0.200
     1.881    11.853     0.200
     1.934    12.326     0.200
     1.881    13.601     0.200
     2.041    13.093     0.200
     2.116    12.513     0.200
     2.393    13.648     0.200
     2.415    13.483     0.200
     2.358    14.909     0.200
     2.928    14.893     0.200
     2.959    13.879     0.200
     2.948    14.642     0.200
     3.229    15.832     0.200
     3.281    15.384     0.200
     3.583    16.164     0.200
     3.901    17.431     0.200
     4.127    18.738     0.200
     4.163    17.252     0.200
     4.271    18.347     0.200
     4.559    18.214     0.200
     4.767    18.950     0.200
     1.805    12.241     0.200
     1.892    11.222     0.200
     2.032    11.706     0.200
     2.021    11.501     0.200
     2.120    11.636     0.200
     2.260    12.252     0.200
     2.468    12.296     0.200
     2.516    12.623     0.200
     2.513    12.797     0.200
     2.785    15.399     0.200
    15.947    39.257     0.200
     2.024    13.055     0.200
     2.131    12.444     0.200
     2.271    12.998     0.200
     2.328    12.668     0.200
     2.480    13.005     0.200
     2.527    13.126     0.200
     2.521    13.325     0.200
     2.718    14.702     0.200
     2.740    14.331     0.200
     2.791    14.678     0.200
    15.311    39.818     0.200
    15.539    38.546     0.200
    15.959    38.974     0.200
     2.328    12.918     0.200
     3.588    16.827     0.200
     7.217    22.734     0.200
     8.269    25.663     0.200
     8.698    26.703     0.200
    10.203    33.073     0.200
    10.199    31.832     0.200
    12.072    32.371     0.200
    12.879    34.086     0.200
    14.034    39.048     0.200
     1.893    11.383     0.200
     1.987    12.856     0.200
     2.120    12.882     0.200
     2.337    13.355     0.200
     2.375    13.678     0.200
     2.401    13.055     0.200
     2.577    14.540     0.200
     2.894    13.826     0.200
     2.998    14.896     0.200
     3.186    14.494     0.200
     3.612    15.947     0.200
     3.697    15.869     0.200
     3.957    16.188     0.200
     4.212    16.022     0.200
     4.908    18.682     0.200
     7.081    22.072     0.200
     2.476    12.870     0.200
     2.476    13.105     0.200
     3.223    13.970     0.200
     3.561    16.218     0.200
     3.561    16.414     0.200
     5.711    19.428     0.200
     6.514    22.470     0.200
     7.081    22.213     0.200
     8.279    24.581     0.200
     8.279    24.683     0.200
     8.852    27.564     0.200
     9.133    28.814     0.200
    10.348    32.257     0.200
    12.260    32.007     0.200
    12.386    33.850     0.200
    12.735    35.782     0.200
    12.963    34.286     0.200
    15.768    40.030     0.200
    16.157    40.364     0.200
     1.869    11.842     0.200
     1.960    12.279     0.200
     1.967    13.824     0.200
     2.109    12.039     0.200
     2.404    13.607     0.200
     4.371    18.315     0.200
     4.750    16.701     0.200
     4.931    19.856     0.200
     5.084    17.814     0.200
     5.091    19.628     0.200
     5.115    19.711     0.200
     5.319    20.523     0.200
     5.346    19.922     0.200
     5.523    18.363     0.200
     5.520    19.984     0.200
     5.566    21.438     0.200
     5.636    20.636     0.200
     7.052    22.013     0.200
    10.241    29.035     0.200
    11.077    30.884     0.200
    12.679    34.443     0.200
    14.561    38.105     0.200
    15.371    37.434     0.200
    15.790    37.955     0.200
    15.999    39.932     0.200
    16.936    40.959     0.200
     1.840    11.733     0.200
     1.882    12.064     0.200
     1.973    11.528     0.200
     2.066    11.752     0.200
     2.093    12.406     0.200
     2.137    11.816     0.200
     2.337    12.442     0.200
     2.320    13.318     0.200
     2.483    12.354     0.200
     2.550    12.929     0.200
     2.614    13.568     0.200
     2.798    14.333     0.200
     2.889    14.497     0.200
     2.973    12.635     0.200
     3.003    13.110     0.200
     3.078    14.232     0.200
     3.146    14.204     0.200
     3.205    14.915     0.200
     3.336    13.293     0.200
     3.455    14.302     0.200
     3.444    15.342     0.200
     3.562    14.710     0.200
     3.753    15.216     0.200
     3.689    15.208     0.200
     3.831    15.706     0.200
     3.945    15.340     0.200
     3.902    16.208     0.200
     4.185    17.164     0.200
     4.275    16.436     0.200
     4.358    16.625     0.200
     4.473    17.072     0.200
     4.497    17.246     0.200
     4.502    17.082     0.200
     4.506    18.081     0.200
     4.596    17.540     0.200
     4.762    18.090     0.200
     4.823    18.111     0.200
     4.947    16.735     0.200
     5.021    18.704     0.200
     3.003    12.400     0.200
     3.689    15.618     0.200
     3.689    15.388     0.200
     4.001    15.649     0.200
     4.823    19.061     0.200
     5.290    18.610     0.200
     5.552    19.754     0.200
     5.543    20.853     0.200
     5.715    18.542     0.200
     6.002    19.392     0.200
     6.527    22.873     0.200
     6.699    23.160     0.200
     6.699    22.174     0.200
     6.935    23.012     0.200
     6.932    23.442     0.200
     7.209    23.110     0.200
     7.209    22.287     0.200
     7.209    22.810     0.200
     7.209    22.920     0.200
     7.880    24.180     0.200
     8.204    25.496     0.200
     8.361    23.363     0.200
     8.361    24.182     0.200
     8.670    26.459     0.200
     8.670    25.908     0.200
     9.326    28.313     0.200
    10.131    31.165     0.200
    12.144    30.713     0.200
    12.605    33.602     0.200
    12.931    35.366     0.200
    12.936    32.688     0.200
    13.956    38.334     0.200
    15.878    40.195     0.200
    15.985    40.392     0.200
    15.954    39.292     0.200
    16.096    40.001     0.200
    16.157    39.831     0.200
     1.980    12.055     0.200
     2.107    14.473     0.200
     2.167    13.062     0.200
     2.289    12.758     0.200
     2.346    13.356     0.200
     2.514    13.381     0.200
     2.576    13.876     0.200
     2.607    14.067     0.200
     2.800    15.130     0.200
     2.871    14.789     0.200
     2.981    14.407     0.200
     2.998    13.848     0.200
     3.101    13.801     0.200
     3.164    14.705     0.200
     3.195    15.137     0.200
     3.333    14.365     0.200
     3.480    14.575     0.200
     3.465    15.084     0.200
     3.594    15.048     0.200
     3.660    16.459     0.200
     3.773    15.609     0.200
     3.829    16.731     0.200
     3.903    15.690     0.200
     3.891    17.003     0.200
     4.294    17.121     0.200
     4.379    16.923     0.200
     4.490    17.820     0.200
     4.510    17.872     0.200
     4.509    17.979     0.200
     4.500    19.113     0.200
     4.598    18.849     0.200
     4.776    18.066     0.200
     4.838    18.541     0.200
     4.973    17.165     0.200
     4.989    20.139     0.200
     5.543    19.233     0.200
     6.140    21.862     0.200
     6.661    22.648     0.200
     6.681    23.079     0.200
     7.383    24.336     0.200
     7.679    24.330     0.200
     9.213    27.136     0.200
    10.524    32.285     0.200
     2.081    11.776     0.200
     2.111    12.008     0.200
     2.321    12.168     0.200
     2.351    12.659     0.200
     2.357    13.125     0.200
     2.535    14.504     0.200
     2.498    12.855     0.200
     2.664    15.788     0.200
     2.867    13.936     0.200
     2.910    13.815     0.200
     2.954    14.465     0.200
     3.264    13.371     0.200
     3.527    15.793     0.200
     3.598    14.554     0.200
     3.653    16.160     0.200
     3.758    14.893     0.200
     4.161    14.693     0.200
     4.249    16.957     0.200
     4.876    17.802     0.200
    15.801    39.041     0.200
    16.010    40.045     0.200
    17.453    38.862     0.200
     2.028    11.890     0.200
     2.064    12.319     0.200
     2.131    11.909     0.200
     2.379    12.693     0.200
     2.410    13.212     0.200
     2.388    13.804     0.200
     2.439    12.954     0.200
     2.578    14.091     0.200
     2.926    14.023     0.200
     2.965    13.734     0.200
     2.981    14.850     0.200
     3.199    14.203     0.200
     3.220    14.011     0.200
     3.310    14.171     0.200
     3.281    15.293     0.200
     3.471    14.154     0.200
     3.555    15.648     0.200
     3.517    16.124     0.200
     3.585    15.458     0.200
     3.607    16.911     0.200
     3.678    16.565     0.200
     3.817    15.348     0.200
     3.847    17.125     0.200
     3.936    16.525     0.200
     3.960    17.253     0.200
     4.125    16.320     0.200
     4.100    16.781     0.200
     4.226    16.763     0.200
     4.192    16.581     0.200
     4.289    17.113     0.200
     4.301    17.319     0.200
     4.281    17.787     0.200
     4.375    18.135     0.200
     4.370    19.133     0.200
     4.382    18.893     0.200
     4.569    17.888     0.200
     4.635    18.215     0.200
     4.808    17.052     0.200
     4.800    18.894     0.200
     4.880    18.474     0.200
     4.862    18.816     0.200
     4.994    18.502     0.200
     2.059    12.689     0.200
     2.064    12.519     0.200
     2.070    13.446     0.200
     2.140    13.011     0.200
     2.304    13.471     0.200
     2.317    13.610     0.200
     2.487    13.018     0.200
     2.543    13.142     0.200
     2.565    15.003     0.200
     2.716    15.120     0.200
     2.757    15.660     0.200
     2.837    15.718     0.200
     2.915    15.454     0.200
     3.023    15.429     0.200
     3.067    14.378     0.200
     3.041    15.073     0.200
     3.125    15.162     0.200
     3.153    15.313     0.200
     3.276    16.038     0.200
     3.294    17.267     0.200
     3.404    15.689     0.200
     3.376    15.817     0.200
     3.447    14.428     0.200
     3.430    15.948     0.200
     3.570    15.398     0.200
     3.631    15.910     0.200
     3.737    16.132     0.200
     3.786    16.712     0.200
     3.849    16.544     0.200
     3.942    16.213     0.200
     3.946    16.803     0.200
     4.017    17.002     0.200
     4.052    18.805     0.200
     4.104    17.163     0.200
     4.134    18.034     0.200
     4.257    17.197     0.200
     4.343    17.483     0.200
     4.451    17.851     0.200
     4.470    17.780     0.200
     4.466    18.122     0.200
     4.457    18.998     0.200
     4.555    18.669     0.200
     4.736    18.131     0.200
     4.799    17.797     0.200
     4.941    17.657     0.200
     4.970    19.096     0.200
     4.964    19.476     0.200
     5.035    19.474     0.200
     5.146    20.746     0.200
     5.251    19.669     0.200
     5.279    18.862     0.200
     5.259    20.081     0.200
     5.300    20.375     0.200
     2.045    12.527     0.200
     2.155    12.892     0.200
     2.145    13.519     0.200
     2.228    12.987     0.200
     2.230    13.147     0.200
     2.411    13.198     0.200
     2.640    13.602     0.200
     2.662    14.578     0.200
     2.913    14.886     0.200
     2.929    15.287     0.200
     2.936    14.177     0.200
     3.166    14.456     0.200
     3.678    17.088     0.200
     3.839    15.302     0.200
     3.846    16.025     0.200
     3.888    16.537     0.200
     3.940    17.433     0.200
     3.958    17.581     0.200
     4.192    18.026     0.200
     4.228    18.479     0.200
     4.556    18.208     0.200
     4.572    17.835     0.200
     4.659    19.193     0.200
     5.595    22.017     0.200
     5.751    21.636     0.200
     5.805    19.196     0.200
     5.852    21.718     0.200
     5.870    21.943     0.200
     6.154    22.193     0.200
     6.572    24.488     0.200
    10.289    29.403     0.200
    10.566    32.795     0.200
    11.329    31.212     0.200
    12.677    33.945     0.200
    12.866    34.291     0.200
     2.077    12.153     0.200
     2.122    12.119     0.200
     2.366    13.120     0.200
     2.383    13.411     0.200
     2.321    13.279     0.200
     2.465    13.112     0.200
     2.922    14.331     0.200
     3.266    15.665     0.200
     3.281    14.107     0.200
     3.281    13.907     0.200
     3.457    16.266     0.200
     3.542    16.216     0.200
     3.609    16.560     0.200
     4.190    18.191     0.200
     4.589    18.931     0.200
     4.732    18.092     0.200
     4.805    19.750     0.200
     5.477    19.359     0.200
     6.267    22.297     0.200
     7.115    22.267     0.200
     8.179    25.373     0.200
     8.856    27.432     0.200
    10.258    33.066     0.200
    10.811    30.561     0.200
    11.962    32.157     0.200
     3.457    16.074     0.200
     7.115    21.919     0.200
     7.115    22.548     0.200
     8.179    25.545     0.200
     8.856    26.791     0.200
    10.388    34.090     0.200
    10.396    32.988     0.200
    12.165    31.992     0.200
    12.888    34.219     0.200
    16.182    40.794     0.200
     2.083    12.245     0.200
     2.116    13.021     0.200
     2.326    13.295     0.200
     2.371    12.782     0.200
     2.389    13.145     0.200
     2.459    12.776     0.200
     2.613    13.828     0.200
     2.900    14.274     0.200
     2.928    14.844     0.200
     3.287    14.879     0.200
     3.252    15.627     0.200
     3.261    15.635     0.200
     3.275    14.510     0.200
     3.458    16.616     0.200
     3.553    14.879     0.200
     3.547    17.157     0.200
     3.614    16.805     0.200
     3.611    14.907     0.200
     3.799    15.640     0.200
     3.802    17.039     0.200
     3.871    16.392     0.200
     4.065    17.112     0.200
     4.161    17.153     0.200
     4.250    17.874     0.200
     4.258    17.354     0.200
     4.185    16.100     0.200
     4.319    19.109     0.200
     4.527    18.634     0.200
     4.595    18.283     0.200
     4.736    18.327     0.200
     4.786    17.199     0.200
     4.846    18.236     0.200
     5.013    18.646     0.200
     5.065    20.120     0.200
     5.108    18.527     0.200
     5.413    19.899     0.200
     5.545    20.632     0.200
     5.543    21.296     0.200
     5.563    19.348     0.200
     5.471    19.264     0.200
     5.815    20.482     0.200
     5.774    19.739     0.200
     5.874    21.072     0.200
     6.272    21.744     0.200
     6.390    21.208     0.200
     7.121    22.278     0.200
     7.158    23.702     0.200
     7.166    23.643     0.200
     7.357    23.931     0.200
     7.397    24.316     0.200
     7.519    23.806     0.200
     7.672    24.194     0.200
     7.871    25.204     0.200
     8.068    24.305     0.200
     8.244    24.508     0.200
     8.178    25.112     0.200
     8.967    26.748     0.200
    10.122    29.475     0.200
    10.484    30.260     0.200
    11.141    30.455     0.200
    12.344    34.002     0.200
    12.885    34.364     0.200
     2.097    12.186     0.200
     2.373    12.417     0.200
     2.350    12.605     0.200
     2.396    12.742     0.200
     2.452    12.864     0.200
     2.909    13.277     0.200
     2.941    13.818     0.200
     3.294    13.667     0.200
     3.237    14.633     0.200
     3.262    15.085     0.200
     3.254    14.498     0.200
     3.466    14.924     0.200
     3.482    15.752     0.200
     3.565    14.553     0.200
     3.570    15.794     0.200
     3.590    15.822     0.200
     3.638    15.526     0.200
     3.805    15.359     0.200
     3.818    15.984     0.200
     3.896    16.368     0.200
     3.920    16.901     0.200
     4.077    16.892     0.200
     4.172    16.259     0.200
     4.162    17.492     0.200
     4.264    16.837     0.200
     4.257    17.567     0.200
     4.274    17.107     0.200
     4.542    18.162     0.200
     4.793    17.250     0.200
     4.761    17.723     0.200
     4.858    18.023     0.200
     5.037    19.228     0.200
     5.086    19.122     0.200
     5.117    18.220     0.200
     5.287    19.873     0.200
     5.437    19.795     0.200
     5.467    20.415     0.200
     5.455    18.973     0.200
     5.555    20.661     0.200
     5.569    18.600     0.200
     5.563    20.387     0.200
     5.728    19.432     0.200
     5.751    19.866     0.200
     5.838    21.421     0.200
     5.887    20.550     0.200
     6.253    22.137     0.200
     6.383    20.637     0.200
     6.409    22.080     0.200
     7.188    24.247     0.200
     7.372    24.458     0.200
     7.681    22.859     0.200
     7.882    23.620     0.200
     7.939    24.947     0.200
     8.049    25.648     0.200
     8.087    24.414     0.200
     8.248    24.374     0.200
     8.199    23.902     0.200
     8.506    23.614     0.200
    14.624    36.503     0.200
    15.225    38.522     0.200
    15.433    38.358     0.200
    15.452    38.540     0.200
    15.853    38.683     0.200
    16.161    40.163     0.200
    16.512    39.373     0.200
    16.824    40.513     0.200
     3.482    16.272     0.200
     5.751    19.663     0.200
     7.121    21.800     0.200
     8.199    24.914     0.200
     8.840    27.183     0.200
    10.371    31.220     0.200
    12.895    33.566     0.200
    14.209    40.426     0.200
    15.746    40.551     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.997    25.416     0.200
     3.908    28.916     0.200
     8.550    60.717     0.200
     5.303    34.656     0.200
     5.287    33.754     0.200
     3.941    27.225     0.200
     8.582    60.768     0.200
     8.423    57.059     0.200
     8.601    58.654     0.200
     8.590    62.313     0.200
     5.106    31.788     0.200
     5.087    31.751     0.200
     5.700    41.680     0.200
     2.762    18.184     0.200
     2.697    19.339     0.200
     2.948    18.893     0.200
     3.304    21.967     0.200
     2.501    17.374     0.200
     2.627    18.756     0.200
     2.834    18.614     0.200
     2.939    20.649     0.200
     3.183    21.209     0.200
     3.001    18.652     0.200
     3.105    19.717     0.200
     2.686    18.488     0.200
     3.014    19.445     0.200
     4.433    28.539     0.200
     2.921    19.397     0.200
     3.295    22.321     0.200
     3.295    21.699     0.200
     2.974    18.113     0.200
     2.788    19.408     0.200
     2.942    19.798     0.200
     3.077    21.287     0.200
     3.174    20.379     0.200
     3.592    22.017     0.200
     3.341    21.486     0.200
     2.524    18.431     0.200
     2.573    17.775     0.200
     2.916    20.165     0.200
     2.681    19.585     0.200
     4.562    33.690     0.200
     2.658    18.536     0.200
     2.904    20.255     0.200
     3.172    22.002     0.200
     2.513    18.425     0.200
     2.550    17.072     0.200
     2.884    18.195     0.200
     3.307    21.167     0.200
     2.705    19.429     0.200
     2.787    19.745     0.200
     2.943    18.616     0.200
     3.075    21.798     0.200
     2.520    17.374     0.200
     2.999    19.350     0.200
     3.424    22.030     0.200
     2.838    18.930     0.200
     3.178    21.300     0.200
     3.637    22.866     0.200
     3.952    26.023     0.200
     4.169    26.244     0.200
     4.794    31.112     0.200
     2.555    18.470     0.200
     2.602    19.097     0.200
     2.802    20.164     0.200
     2.802    20.297     0.200
     3.045    20.037     0.200
     3.586    26.419     0.200
     4.450    32.823     0.200
     2.546    17.988     0.200
     2.791    18.268     0.200
     2.819    19.879     0.200
     3.102    20.174     0.200
     3.676    23.225     0.200
     4.204    26.713     0.200
     4.323    30.089     0.200
     3.015    18.944     0.200
     3.115    20.192     0.200
     3.188    19.972     0.200
     4.176    25.809     0.200
     2.624    16.307     0.200
     3.293    22.040     0.200
     4.241    27.630     0.200
     4.798    33.144     0.200
     4.242    27.536     0.200
     4.797    32.499     0.200
     2.580    17.136     0.200
     2.702    17.859     0.200
     5.430    35.313     0.200
     5.430    35.520     0.200
     5.266    34.433     0.200
     5.287    35.053     0.200
     2.523    16.880     0.200
     3.703    24.785     0.200
     4.209    29.416     0.200
     2.546    16.700     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.559     5.244     0.200
     1.235     8.454     0.200
     0.315     3.309     0.200
     2.332    12.278     0.200
     6.107    26.419     0.200
     0.463     3.355     0.200
     0.597     5.640     0.200
     0.738     5.269     0.200
     1.172     8.189     0.200
     2.239    12.491     0.200
     2.514    12.648     0.200
     0.462     3.535     0.200
     0.592     5.526     0.200
     0.740     5.118     0.200
     1.163     8.123     0.200
     1.196     8.545     0.200
     2.249    12.259     0.200
     2.507    12.686     0.200
     0.286     2.227     0.200
     0.647     5.757     0.200
     1.087     7.961     0.200
     0.549     5.160     0.200
     1.198     6.884     0.200
     1.645     9.073     0.200
     1.773     9.055     0.200
     2.227    11.278     0.200
     7.022    45.722     0.200
     0.569     5.233     0.200
     1.191     6.977     0.200
     1.665     9.451     0.200
     1.756     9.469     0.200
     2.230    11.780     0.200
     0.425     3.633     0.200
     0.439     3.512     0.200
     0.709     4.955     0.200
     1.188     7.763     0.200
     1.194     8.317     0.200
     1.284     7.613     0.200
     1.672     9.813     0.200
     1.724     9.596     0.200
     1.750    10.288     0.200
     1.818    10.640     0.200
     0.289     2.435     0.200
     0.335     3.204     0.200
     0.589     4.149     0.200
     0.754     6.586     0.200
     1.213     9.263     0.200
     1.548     8.910     0.200
     1.592    10.421     0.200
     1.836    11.188     0.200
     0.239     2.793     0.200
     0.270     2.727     0.200
     0.459     4.628     0.200
     1.234     8.254     0.200
     1.367     8.830     0.200
     1.446     8.708     0.200
     1.506     8.606     0.200
     0.216     2.138     0.200
     0.509     3.817     0.200
     0.620     5.619     0.200
     1.095     8.086     0.200
     1.177     7.319     0.200
     1.223     8.524     0.200
     1.454    10.190     0.200
     1.617     9.292     0.200
     1.626    10.583     0.200
     1.651    10.696     0.200
     1.713    10.270     0.200
     1.776    11.328     0.200
     0.293     2.574     0.200
     0.547     4.903     0.200
     0.615     4.922     0.200
     1.039     8.166     0.200
     1.399     9.772     0.200
     1.500     9.384     0.200
     1.942    10.122     0.200
     0.312     2.325     0.200
     1.192     9.235     0.200
     1.219     8.918     0.200
     1.408    10.335     0.200
     1.573    11.023     0.200
     1.582    11.069     0.200
     0.291     2.798     0.200
     0.360     3.437     0.200
     0.585     4.326     0.200
     0.695     6.032     0.200
     1.121     7.870     0.200
     1.189     8.397     0.200
     1.569     8.682     0.200
     1.630    10.262     0.200
     1.679     9.780     0.200
     0.284     2.868     0.200
     0.361     3.451     0.200
     0.577     4.347     0.200
     0.688     6.011     0.200
     1.129     7.474     0.200
     1.190     8.026     0.200
     1.577     9.462     0.200
     1.636    10.232     0.200
     0.253     2.184     0.200
     0.650     5.652     0.200
     1.226     8.425     0.200
     1.149     8.782     0.200
     1.535    10.526     0.200
     1.676    10.282     0.200
     1.706    11.134     0.200
     1.726    11.688     0.200
     1.782    11.041     0.200
     2.304    12.646     0.200
     2.493    13.449     0.200
     3.459    16.774     0.200
     0.209     1.914     0.200
     0.421     3.634     0.200
     0.601     5.540     0.200
     0.854     6.888     0.200
     1.263     7.515     0.200
     1.537    10.118     0.200
     1.706     9.741     0.200
     1.711    10.488     0.200
     1.804    10.503     0.200
     5.106    31.584     0.200
     0.175     1.611     0.200
     0.330     2.076     0.200
     0.493     4.650     0.200
     1.220     8.516     0.200
     1.375     9.462     0.200
     1.785    10.836     0.200
     2.296    13.504     0.200
     0.258     2.279     0.200
     0.505     3.634     0.200
     0.647     5.622     0.200
     1.131     8.052     0.200
     1.343     9.560     0.200
     1.564    10.442     0.200
     1.707    10.658     0.200
     1.736    11.362     0.200
     1.814    11.271     0.200
     2.278    13.213     0.200
     2.524    12.994     0.200
     3.126    15.528     0.200
     0.174     1.857     0.200
     0.544     5.071     0.200
     1.373     9.371     0.200
     1.144     7.965     0.200
     1.323     9.352     0.200
     1.501     9.885     0.200
     1.557     9.091     0.200
     2.371    12.173     0.200
     0.635     5.481     0.200
     1.235     7.274     0.200
     2.405    11.741     0.200
     0.291     2.557     0.200
     0.281     2.367     0.200
     0.587     4.220     0.200
     0.677     5.937     0.200
     1.080     6.401     0.200
     1.257     8.799     0.200
     1.519     8.761     0.200
     1.619     9.393     0.200
     1.765     9.825     0.200
     2.336    12.397     0.200
     0.472     3.692     0.200
     0.647     5.343     0.200
     0.879     7.100     0.200
     1.206     8.448     0.200
     1.276     7.732     0.200
     1.339     9.223     0.200
     2.540    12.556     0.200
     2.952    15.615     0.200
     0.435     3.763     0.200
     0.456     3.665     0.200
     0.629     5.534     0.200
     0.867     7.107     0.200
     1.199     8.244     0.200
     1.170     7.617     0.200
     1.279     7.131     0.200
     1.327     9.134     0.200
     1.551     9.874     0.200
     1.722     9.048     0.200
     2.540    12.489     0.200
     0.466     3.579     0.200
     0.639     5.680     0.200
     0.870     7.270     0.200
     1.162     7.942     0.200
     1.199     8.651     0.200
     1.274     7.348     0.200
     1.553    10.052     0.200
     1.719     9.311     0.200
     1.818    10.334     0.200
     0.487     3.583     0.200
     0.661     5.639     0.200
     0.878     7.351     0.200
     1.145     8.288     0.200
     1.201     8.355     0.200
     1.265     7.587     0.200
     1.560    10.371     0.200
     1.713     9.499     0.200
     2.286    12.523     0.200
     2.530    13.174     0.200
     0.503     3.718     0.200
     1.144     8.872     0.200
     1.187     9.587     0.200
     1.245     8.662     0.200
     1.549    10.839     0.200
     1.694    10.601     0.200
     1.800    11.682     0.200
     2.293    13.279     0.200
     2.511    13.918     0.200
     0.673     4.877     0.200
     0.655     5.395     0.200
     1.214     9.288     0.200
     1.470     9.650     0.200
     1.589    10.722     0.200
     0.643     5.528     0.200
     0.875     7.075     0.200
     1.203     7.783     0.200
     1.276     7.689     0.200
     1.722     9.362     0.200
     2.155    11.788     0.200
     2.292    12.278     0.200
     2.292    12.130     0.200
     3.497    16.734     0.200
     0.388     3.381     0.200
     0.470     3.780     0.200
     0.648     5.634     0.200
     0.820     6.687     0.200
     0.880     6.075     0.200
     0.943     7.021     0.200
     1.021     6.381     0.200
     1.231     8.220     0.200
     1.235     7.950     0.200
     1.232     8.660     0.200
     1.344     8.810     0.200
     1.418     9.066     0.200
     1.493    10.311     0.200
     1.719    10.484     0.200
     1.522    10.079     0.200
     1.626     9.786     0.200
     1.620    10.016     0.200
     1.676     9.959     0.200
     0.216     2.482     0.200
     0.447     3.633     0.200
     0.481     4.690     0.200
     0.644     5.822     0.200
     0.758     5.350     0.200
     0.795     5.894     0.200
     0.968     6.619     0.200
     1.066     7.753     0.200
     1.149     7.765     0.200
     1.176     7.530     0.200
     1.176     7.358     0.200
     1.206     7.447     0.200
     1.271     7.599     0.200
     1.352     8.156     0.200
     1.362     7.606     0.200
     1.371     8.913     0.200
     1.389     9.007     0.200
     1.521    10.323     0.200
     1.453     9.930     0.200
     1.458     9.131     0.200
     1.523     8.222     0.200
     1.584     8.480     0.200
     1.645     9.134     0.200
     1.724     9.441     0.200
     1.730    10.673     0.200
     1.752    10.880     0.200
     1.747    10.200     0.200
     1.757    10.203     0.200
     1.785     9.607     0.200
     1.805    11.164     0.200
     0.374     3.021     0.200
     0.543     3.787     0.200
     0.770     6.149     0.200
     0.942     7.654     0.200
     1.185     8.715     0.200
     1.245     9.569     0.200
     1.614     9.555     0.200
     1.638    11.582     0.200
     1.709    11.734     0.200
     1.771    11.110     0.200
     2.307    15.213     0.200
     0.312     3.021     0.200
     0.312     2.800     0.200
     0.534     3.923     0.200
     0.564     5.281     0.200
     0.674     5.583     0.200
     0.740     6.284     0.200
     0.831     5.686     0.200
     0.850     6.518     0.200
     0.995     6.975     0.200
     1.144     7.728     0.200
     1.245     7.976     0.200
     1.320     8.184     0.200
     1.299     8.871     0.200
     1.321     8.584     0.200
     1.428     9.421     0.200
     1.530     9.444     0.200
     1.526     8.550     0.200
     1.577     8.853     0.200
     1.612     9.907     0.200
     1.644    10.410     0.200
     1.709    11.005     0.200
     1.817    11.122     0.200
     1.817    10.591     0.200
     1.806    10.510     0.200
     2.312    13.835     0.200
     0.250     2.289     0.200
     0.356     2.909     0.200
     0.356     3.010     0.200
     0.541     3.908     0.200
     0.606     5.237     0.200
     0.692     5.605     0.200
     0.787     6.138     0.200
     0.888     6.690     0.200
     0.957     7.502     0.200
     1.185     8.762     0.200
     1.202     8.390     0.200
     1.202     8.609     0.200
     1.338    10.003     0.200
     1.260     9.568     0.200
     1.570     9.968     0.200
     1.638    10.636     0.200
     1.638    11.005     0.200
     1.707    11.279     0.200
     1.785    10.698     0.200
     2.306    14.598     0.200
     5.201    25.740     0.200
     0.567     4.041     0.200
     0.549     4.331     0.200
     0.605     5.179     0.200
     0.754     6.341     0.200
     0.829     7.055     0.200
     0.978     8.107     0.200
     0.996     6.128     0.200
     1.029     7.589     0.200
     1.078     8.530     0.200
     1.078     8.261     0.200
     1.081     6.867     0.200
     1.122     8.913     0.200
     1.256     9.862     0.200
     1.281     9.623     0.200
     1.294     8.607     0.200
     1.379    10.118     0.200
     1.467    10.008     0.200
     1.479     9.383     0.200
     1.609     9.706     0.200
     1.620    10.728     0.200
     1.654    11.373     0.200
     1.676    11.794     0.200
     1.676    11.593     0.200
     1.716    10.640     0.200
     1.763    11.523     0.200
     1.757    10.875     0.200
     1.764    12.562     0.200
     1.764    12.392     0.200
     1.823    11.777     0.200
     1.880    11.552     0.200
     1.879    11.573     0.200
     0.291     2.127     0.200
     0.351     3.238     0.200
     0.587     4.370     0.200
     0.771     6.591     0.200
     0.789     6.045     0.200
     0.863     6.900     0.200
     0.899     6.351     0.200
     0.937     8.280     0.200
     1.066     9.202     0.200
     1.114     7.589     0.200
     1.114     8.780     0.200
     1.165     9.252     0.200
     1.165     9.400     0.200
     1.165     7.706     0.200
     1.198     9.509     0.200
     1.198     9.699     0.200
     1.243    10.603     0.200
     1.243     9.991     0.200
     1.297     8.655     0.200
     1.397    10.284     0.200
     1.438    10.611     0.200
     1.515     9.394     0.200
     1.515     9.694     0.200
     1.547    10.709     0.200
     1.562     9.554     0.200
     1.609    11.086     0.200
     1.621    11.460     0.200
     1.592    12.211     0.200
     1.670    10.921     0.200
     1.690    10.815     0.200
     1.690    10.694     0.200
     1.816    12.180     0.200
     1.845    12.036     0.200
     1.822    11.716     0.200
     1.822    12.626     0.200
     2.260    16.353     0.200
     0.431     3.054     0.200
     0.418     3.393     0.200
     0.681     5.977     0.200
     0.772     6.528     0.200
     0.982     7.198     0.200
     0.997     8.313     0.200
     1.070     7.012     0.200
     1.198     9.043     0.200
     1.267     8.854     0.200
     1.284     8.199     0.200
     1.292    10.107     0.200
     1.320     8.200     0.200
     1.408    11.017     0.200
     1.675    10.647     0.200
     1.672    10.482     0.200
     1.723    10.396     0.200
     1.758    11.754     0.200
     1.831    11.959     0.200
     1.855    11.367     0.200
     0.237     2.277     0.200
     0.325     2.899     0.200
     0.325     3.087     0.200
     0.576     5.178     0.200
     0.576     5.397     0.200
     0.537     4.004     0.200
     0.680     4.819     0.200
     0.752     6.376     0.200
     0.791     5.208     0.200
     0.791     5.387     0.200
     0.818     6.122     0.200
     0.860     6.665     0.200
     0.983     7.369     0.200
     1.065     7.918     0.200
     1.156     8.137     0.200
     1.182     7.033     0.200
     1.232     8.400     0.200
     1.232     8.220     0.200
     1.359     9.864     0.200
     1.288     9.551     0.200
     1.326     8.448     0.200
     1.405     8.546     0.200
     1.534     8.870     0.200
     1.534     9.221     0.200
     1.541     9.785     0.200
     1.583     8.970     0.200
     1.641    10.762     0.200
     1.641    10.879     0.200
     1.622     9.981     0.200
     1.707    11.063     0.200
     1.681    10.009     0.200
     1.714    10.187     0.200
     1.816    10.744     0.200
     1.840    10.662     0.200
     0.195     1.629     0.200
     0.412     3.538     0.200
     0.412     3.491     0.200
     0.454     3.211     0.200
     0.622     5.300     0.200
     0.673     5.979     0.200
     0.765     6.183     0.200
     0.844     7.014     0.200
     0.909     6.131     0.200
     0.970     7.531     0.200
     0.982     7.919     0.200
     1.049     6.668     0.200
     1.177     8.748     0.200
     1.190     8.616     0.200
     1.258     9.013     0.200
     1.264     7.868     0.200
     1.266     7.807     0.200
     1.278    10.067     0.200
     1.389    10.638     0.200
     1.389    10.413     0.200
     1.303     7.958     0.200
     1.372     8.894     0.200
     1.447     9.322     0.200
     1.522    10.048     0.200
     1.549    10.347     0.200
     1.646    10.470     0.200
     1.655     9.883     0.200
     1.702    10.917     0.200
     1.705     9.940     0.200
     1.733    10.937     0.200
     1.734    11.853     0.200
     1.799    10.746     0.200
     1.808    12.191     0.200
     1.836    11.167     0.200
     1.920    11.193     0.200
     1.927    11.458     0.200
     1.944    11.123     0.200
     1.946    11.397     0.200
     2.108    14.206     0.200
     0.379     2.542     0.200
     0.394     3.230     0.200
     0.659     5.724     0.200
     0.826     6.511     0.200
     0.921     7.078     0.200
     0.968     7.671     0.200
     1.058     8.399     0.200
     1.089     7.916     0.200
     1.245     9.036     0.200
     1.254     9.810     0.200
     1.253     9.653     0.200
     1.303     9.500     0.200
     1.324     8.767     0.200
     1.352    10.810     0.200
     1.469    11.263     0.200
     1.677    10.527     0.200
     1.732    10.692     0.200
     1.803    12.517     0.200
     1.867    12.194     0.200
     1.872    13.080     0.200
     2.177    16.072     0.200
     0.432     2.883     0.200
     0.434     3.490     0.200
     0.697     6.052     0.200
     0.759     6.430     0.200
     0.938     6.852     0.200
     0.997     7.490     0.200
     0.988     8.220     0.200
     1.081     7.414     0.200
     1.185     9.120     0.200
     1.204     9.046     0.200
     1.282     9.311     0.200
     1.295     8.602     0.200
     1.282    10.240     0.200
     1.403    11.037     0.200
     1.685    10.718     0.200
     1.735    10.919     0.200
     1.761    12.617     0.200
     1.836    12.818     0.200
     1.867    12.544     0.200
     0.161     1.305     0.200
     0.405     3.171     0.200
     0.421     3.341     0.200
     0.421     3.399     0.200
     0.576     3.882     0.200
     0.685     6.169     0.200
     0.786     6.028     0.200
     0.935     6.104     0.200
     0.935     6.424     0.200
     1.018     7.755     0.200
     1.197     8.687     0.200
     1.213     8.290     0.200
     1.213     8.892     0.200
     1.228     8.386     0.200
     1.271     9.089     0.200
     1.312     9.656     0.200
     1.433    10.517     0.200
     1.395     9.851     0.200
     1.486     9.261     0.200
     1.547     9.879     0.200
     1.687    10.221     0.200
     1.687    10.420     0.200
     1.739    10.442     0.200
     1.739    10.202     0.200
     1.753    11.174     0.200
     1.783    11.599     0.200
     1.856    11.933     0.200
     1.856    12.084     0.200
     1.945    11.617     0.200
     0.425     3.587     0.200
     0.540     3.937     0.200
     0.677     5.729     0.200
     0.721     6.339     0.200
     0.881     6.019     0.200
     0.910     7.846     0.200
     0.993     6.614     0.200
     1.139     8.871     0.200
     1.207     8.635     0.200
     1.256     9.116     0.200
     1.241     8.769     0.200
     1.210     9.861     0.200
     1.307    10.403     0.200
     1.264     8.773     0.200
     1.613    10.387     0.200
     1.658    10.517     0.200
     1.652    11.345     0.200
     1.724    10.746     0.200
     1.704    12.639     0.200
     1.728    11.959     0.200
     1.786    11.551     0.200
     2.320    15.846     0.200
     0.218     2.149     0.200
     0.372     3.466     0.200
     0.372     3.322     0.200
     0.372     3.455     0.200
     0.494     3.744     0.200
     0.494     3.850     0.200
     0.501     3.819     0.200
     0.629     5.678     0.200
     0.658     5.557     0.200
     0.693     4.840     0.200
     0.804     6.740     0.200
     0.781     5.995     0.200
     0.852     5.512     0.200
     0.987     6.080     0.200
     0.970     7.498     0.200
     1.048     6.419     0.200
     1.048     6.610     0.200
     1.124     8.257     0.200
     1.201     6.981     0.200
     1.201     7.239     0.200
     1.204     7.170     0.200
     1.211     8.702     0.200
     1.200     8.382     0.200
     1.200     8.511     0.200
     1.243     7.354     0.200
     1.363    10.196     0.200
     1.363    10.075     0.200
     1.271     9.454     0.200
     1.317     8.407     0.200
     1.284     8.672     0.200
     1.384     8.633     0.200
     1.465     8.652     0.200
     1.484     9.960     0.200
     1.497     9.930     0.200
     1.594     9.673     0.200
     1.643     9.649     0.200
     1.656    10.194     0.200
     1.681    10.413     0.200
     1.680    11.053     0.200
     1.680    11.221     0.200
     1.742    10.174     0.200
     1.751    11.610     0.200
     1.774    10.475     0.200
     1.748    10.414     0.200
     1.765    11.319     0.200
     1.765    10.850     0.200
     1.807    10.901     0.200
     1.807    10.792     0.200
     1.864    10.870     0.200
     1.875    11.198     0.200
     1.880    11.490     0.200
     1.880    11.353     0.200
     1.887    10.534     0.200
     1.897    11.163     0.200
     0.319     2.934     0.200
     0.546     4.210     0.200
     0.546     4.248     0.200
     0.568     4.049     0.200
     0.607     5.124     0.200
     0.737     5.321     0.200
     0.737     5.207     0.200
     0.798     6.988     0.200
     0.830     6.853     0.200
     1.031     7.637     0.200
     1.099     8.079     0.200
     1.122     7.984     0.200
     1.122     8.746     0.200
     1.255     9.680     0.200
     1.624    10.420     0.200
     1.612    11.714     0.200
     1.631    10.854     0.200
     1.673    11.298     0.200
     1.712    10.327     0.200
     1.753    10.201     0.200
     1.760    12.259     0.200
     2.097    15.467     0.200
     2.207    14.071     0.200
     2.339    16.128     0.200
     0.373     3.446     0.200
     0.373     3.544     0.200
     0.492     4.019     0.200
     0.520     3.867     0.200
     0.520     3.766     0.200
     0.627     5.580     0.200
     0.675     4.745     0.200
     0.775     6.063     0.200
     0.957     7.391     0.200
     0.972     6.192     0.200
     1.060     6.734     0.200
     1.111     7.725     0.200
     1.186     7.530     0.200
     1.189     7.164     0.200
     1.192     8.521     0.200
     1.192     8.389     0.200
     1.346     9.940     0.200
     1.259     9.306     0.200
     1.288     8.717     0.200
     1.582     9.222     0.200
     1.631     9.557     0.200
     1.661    10.692     0.200
     1.661    10.535     0.200
     1.732    11.007     0.200
     1.758    10.515     0.200
     1.758    10.652     0.200
     1.761    10.649     0.200
     1.753    10.798     0.200
     1.803    10.613     0.200
     2.094    11.729     0.200
     2.255    11.787     0.200
     2.329    12.108     0.200
     2.327    12.163     0.200
     2.460    12.348     0.200
     0.214     2.571     0.200
     0.357     3.462     0.200
     0.357     3.426     0.200
     0.357     3.536     0.200
     0.509     3.631     0.200
     0.502     3.798     0.200
     0.614     5.443     0.200
     0.655     5.821     0.200
     0.688     4.336     0.200
     0.795     5.611     0.200
     0.980     6.979     0.200
     0.977     6.118     0.200
     0.977     5.798     0.200
     1.060     6.513     0.200
     1.130     7.375     0.200
     1.191     7.434     0.200
     1.191     7.047     0.200
     1.194     6.803     0.200
     1.214     8.084     0.200
     1.214     7.904     0.200
     1.369     9.479     0.200
     1.282     8.818     0.200
     1.299     8.376     0.200
     1.374     8.601     0.200
     1.582     9.058     0.200
     1.582     9.246     0.200
     1.632     8.954     0.200
     1.632     9.477     0.200
     1.678     9.931     0.200
     1.678    10.118     0.200
     1.728     9.749     0.200
     1.747    10.587     0.200
     1.761    10.349     0.200
     1.761    10.228     0.200
     1.776     9.722     0.200
     1.763    10.261     0.200
     1.763    10.511     0.200
     2.096    11.589     0.200
     2.249    14.097     0.200
     2.277    11.338     0.200
     2.472    11.972     0.200
     0.384     3.336     0.200
     0.384     3.367     0.200
     0.490     4.238     0.200
     0.588     4.322     0.200
     0.625     5.271     0.200
     0.611     4.608     0.200
     0.757     6.506     0.200
     0.920     5.807     0.200
     0.911     7.737     0.200
     1.043     7.846     0.200
     1.105     7.227     0.200
     1.105     7.094     0.200
     1.134     7.214     0.200
     1.136     6.996     0.200
     1.166     8.860     0.200
     1.287    10.194     0.200
     1.287     9.928     0.200
     1.216     9.602     0.200
     1.303     9.245     0.200
     1.541     8.895     0.200
     1.586     9.731     0.200
     1.593    11.060     0.200
     1.665    11.559     0.200
     1.713    10.460     0.200
     1.711    11.316     0.200
     1.795    10.987     0.200
     1.795    11.183     0.200
     1.791    11.363     0.200
     2.045    12.287     0.200
     2.224    12.260     0.200
     2.262    14.738     0.200
     2.262    14.512     0.200
     2.686    13.675     0.200
     2.949    14.406     0.200
     0.291     2.770     0.200
     0.367     3.365     0.200
     0.506     3.961     0.200
     0.609     5.322     0.200
     0.583     4.193     0.200
     0.610     4.442     0.200
     0.734     5.913     0.200
     0.800     5.278     0.200
     0.800     5.057     0.200
     0.773     6.231     0.200
     0.913     5.600     0.200
     0.926     7.417     0.200
     1.050     7.598     0.200
     1.127     6.881     0.200
     1.114     6.990     0.200
     1.182     8.447     0.200
     1.183     8.522     0.200
     1.183     8.362     0.200
     1.300     9.913     0.200
     1.231     9.337     0.200
     1.311     8.725     0.200
     1.317     9.010     0.200
     1.414     8.297     0.200
     1.531     8.600     0.200
     1.577     8.386     0.200
     1.597    10.902     0.200
     1.626    10.212     0.200
     1.638    10.356     0.200
     1.667    11.254     0.200
     1.687     9.847     0.200
     1.705    10.054     0.200
     1.727    10.860     0.200
     2.265    14.402     0.200
     0.456     3.234     0.200
     0.427     3.328     0.200
     0.427     3.320     0.200
     0.452     4.140     0.200
     0.688     5.862     0.200
     0.751     6.222     0.200
     0.758     5.236     0.200
     0.921     7.158     0.200
     0.976     6.306     0.200
     0.976     6.550     0.200
     0.971     8.065     0.200
     1.058     6.860     0.200
     1.176     8.730     0.200
     1.176     8.607     0.200
     1.225     8.682     0.200
     1.273     8.998     0.200
     1.275     9.234     0.200
     1.267     9.863     0.200
     1.314     8.520     0.200
     1.382    10.610     0.200
     1.677    10.505     0.200
     1.666    10.338     0.200
     1.715    10.811     0.200
     1.736    11.854     0.200
     1.736    11.607     0.200
     1.767    11.727     0.200
     1.758    12.956     0.200
     1.810    12.303     0.200
     1.846    11.736     0.200
     1.933    11.406     0.200
     2.179    13.258     0.200
     2.373    14.506     0.200
     0.198     2.536     0.200
     0.377     3.492     0.200
     0.377     3.443     0.200
     0.493     3.652     0.200
     0.493     3.543     0.200
     0.477     3.617     0.200
     0.477     3.957     0.200
     0.637     5.465     0.200
     0.718     4.607     0.200
     0.636     5.661     0.200
     0.785     5.663     0.200
     0.868     6.002     0.200
     0.931     6.732     0.200
     0.985     7.136     0.200
     1.009     6.138     0.200
     1.009     6.247     0.200
     1.029     6.532     0.200
     1.138     7.933     0.200
     1.207     8.132     0.200
     1.224     7.317     0.200
     1.224     7.967     0.200
     1.226     7.586     0.200
     1.221     8.211     0.200
     1.221     8.420     0.200
     1.262     7.523     0.200
     1.262     7.664     0.200
     1.382     9.750     0.200
     1.284     9.050     0.200
     1.276     8.341     0.200
     1.332     8.377     0.200
     1.407     8.664     0.200
     1.481     9.245     0.200
     1.492     9.069     0.200
     1.614     9.069     0.200
     1.664     9.483     0.200
     1.664     9.294     0.200
     1.665     9.752     0.200
     1.705    10.796     0.200
     1.694     9.852     0.200
     1.776     9.985     0.200
     1.776    10.694     0.200
     1.758    10.099     0.200
     1.777    10.195     0.200
     1.777    10.056     0.200
     1.795    10.647     0.200
     1.795    10.797     0.200
     1.808    10.090     0.200
     1.880    10.536     0.200
     1.889    10.540     0.200
     2.129    11.408     0.200
     2.503    12.730     0.200
     2.764    13.037     0.200
     0.181     1.628     0.200
     0.442     3.577     0.200
     0.403     3.457     0.200
     0.403     3.442     0.200
     0.479     3.737     0.200
     0.609     5.124     0.200
     0.609     5.714     0.200
     0.666     5.741     0.200
     0.666     5.979     0.200
     0.778     5.841     0.200
     0.760     4.804     0.200
     0.906     6.029     0.200
     0.906     5.877     0.200
     0.989     6.314     0.200
     0.989     6.474     0.200
     0.965     7.278     0.200
     0.965     7.536     0.200
     0.996     7.417     0.200
     1.052     6.234     0.200
     1.203     8.041     0.200
     1.203     8.213     0.200
     1.203     8.334     0.200
     1.172     7.951     0.200
     1.248     8.519     0.200
     1.251     7.847     0.200
     1.292     9.316     0.200
     1.266     7.292     0.200
     1.266     7.534     0.200
     1.269     7.329     0.200
     1.403    10.043     0.200
     1.302     7.483     0.200
     1.302     7.885     0.200
     1.368     8.713     0.200
     1.449     8.422     0.200
     1.654     9.465     0.200
     1.654     9.586     0.200
     1.744    11.391     0.200
     1.744    11.500     0.200
     1.794    11.379     0.200
     1.784    11.423     0.200
     1.784    11.294     0.200
     1.784    12.283     0.200
     1.796     9.664     0.200
     2.184    13.928     0.200
     2.412    15.901     0.200
     2.412    14.573     0.200
     3.746    22.884     0.200
     0.212     2.350     0.200
     0.381     3.461     0.200
     0.381     3.465     0.200
     0.491     3.722     0.200
     0.487     3.716     0.200
     0.639     5.585     0.200
     0.650     5.131     0.200
     0.706     4.790     0.200
     0.777     5.925     0.200
     0.777     6.035     0.200
     0.930     6.837     0.200
     0.972     7.337     0.200
     1.001     6.423     0.200
     1.001     6.223     0.200
     1.035     6.705     0.200
     1.035     6.520     0.200
     1.141     7.818     0.200
     1.197     8.206     0.200
     1.215     7.471     0.200
     1.217     7.337     0.200
     1.256     7.561     0.200
     1.256     7.731     0.200
     1.274     8.469     0.200
     1.368     9.839     0.200
     1.272     9.285     0.200
     1.398     7.795     0.200
     1.508     9.626     0.200
     1.608     9.290     0.200
     1.666    10.063     0.200
     1.692    10.358     0.200
     1.692    10.478     0.200
     1.735    10.635     0.200
     1.735    10.185     0.200
     1.754    10.285     0.200
     1.763    10.698     0.200
     1.763    10.568     0.200
     1.765    10.367     0.200
     1.765    10.181     0.200
     1.788    10.687     0.200
     2.223    13.683     0.200
     0.449     3.813     0.200
     0.485     3.749     0.200
     0.485     3.763     0.200
     0.491     3.732     0.200
     0.516     4.112     0.200
     0.677     5.699     0.200
     0.717     5.725     0.200
     0.777     4.374     0.200
     0.802     5.314     0.200
     0.781     6.403     0.200
     0.780     5.660     0.200
     0.851     6.556     0.200
     0.934     7.633     0.200
     1.011     6.834     0.200
     1.014     6.651     0.200
     1.117     8.946     0.200
     1.091     8.121     0.200
     1.197     7.868     0.200
     1.210     9.435     0.200
     1.210     8.541     0.200
     1.210     9.586     0.200
     1.230     7.792     0.200
     1.230     7.679     0.200
     1.342     9.193     0.200
     1.406     9.859     0.200
     1.406    10.039     0.200
     1.452     8.548     0.200
     1.484    10.502     0.200
     1.602     9.686     0.200
     1.587    11.564     0.200
     1.624     9.975     0.200
     1.636     8.893     0.200
     1.645    11.112     0.200
     1.763     9.557     0.200
     1.751    11.658     0.200
     1.874    12.771     0.200
     1.931    10.776     0.200
     2.074    13.923     0.200
     2.128    13.109     0.200
     2.219    14.248     0.200
     2.353    14.844     0.200
     2.473    13.540     0.200
     2.528    13.725     0.200
     2.563    14.559     0.200
     2.710    14.839     0.200
     3.153    16.178     0.200
     0.370     3.358     0.200
     0.370     3.369     0.200
     0.499     3.890     0.200
     0.567     4.115     0.200
     0.616     5.414     0.200
     0.770     6.112     0.200
     0.814     5.255     0.200
     0.930     6.025     0.200
     0.932     7.385     0.200
     1.066     7.646     0.200
     1.097     6.988     0.200
     1.145     7.584     0.200
     1.147     7.647     0.200
     1.192     8.480     0.200
     1.182     8.317     0.200
     1.182     8.424     0.200
     1.197     7.234     0.200
     1.311     9.823     0.200
     1.311     9.938     0.200
     1.236     9.518     0.200
     1.306     8.949     0.200
     1.547     9.062     0.200
     1.614    10.770     0.200
     1.614    11.066     0.200
     1.685    11.403     0.200
     1.721    10.693     0.200
     1.732    10.339     0.200
     1.732    11.185     0.200
     2.054    11.738     0.200
     2.282    12.091     0.200
     2.282    14.567     0.200
     2.287    12.509     0.200
     2.362    12.261     0.200
     2.972    14.064     0.200
     0.269     2.160     0.200
     0.269     2.166     0.200
     0.512     4.706     0.200
     0.577     4.126     0.200
     0.603     4.537     0.200
     0.866     5.899     0.200
     0.871     6.816     0.200
     1.011     7.963     0.200
     1.011     8.194     0.200
     1.080     7.561     0.200
     1.082     8.665     0.200
     1.076     8.090     0.200
     1.112     7.301     0.200
     1.178     7.706     0.200
     1.366    10.433     0.200
     1.279     9.402     0.200
     1.318    10.283     0.200
     1.408     9.895     0.200
     1.408    10.106     0.200
     1.464     9.164     0.200
     1.605    11.244     0.200
     1.605    11.443     0.200
     1.647    10.763     0.200
     1.664    11.577     0.200
     1.732    11.058     0.200
     2.272    14.243     0.200
     2.335    13.849     0.200
     2.327    14.431     0.200
     2.382    14.366     0.200
     2.465    13.549     0.200
     2.692    14.626     0.200
     2.742    14.537     0.200
     0.446     3.266     0.200
     0.438     3.452     0.200
     0.438     3.584     0.200
     0.446     4.197     0.200
     0.700     5.895     0.200
     0.747     6.290     0.200
     0.936     6.322     0.200
     0.961     6.455     0.200
     0.974     8.061     0.200
     1.073     6.894     0.200
     1.173     8.786     0.200
     1.214     8.853     0.200
     1.214     9.041     0.200
     1.190     8.983     0.200
     1.190     9.202     0.200
     1.285     9.067     0.200
     1.285     8.668     0.200
     1.288     8.237     0.200
     1.290     7.902     0.200
     1.388    10.693     0.200
     1.388    10.818     0.200
     1.330     8.813     0.200
     1.681    10.140     0.200
     1.749    12.634     0.200
     1.749    12.439     0.200
     1.760    11.238     0.200
     1.758    12.946     0.200
     2.195    13.426     0.200
     2.302    12.911     0.200
     2.380    13.793     0.200
     0.249     2.303     0.200
     0.265     2.638     0.200
     0.471     4.915     0.200
     0.495     3.950     0.200
     0.589     4.475     0.200
     0.589     4.460     0.200
     0.766     5.126     0.200
     0.808     6.019     0.200
     0.849     6.595     0.200
     1.116     8.055     0.200
     1.123     7.650     0.200
     1.123     7.759     0.200
     1.132     7.117     0.200
     1.132     7.226     0.200
     1.237     8.554     0.200
     1.305     7.857     0.200
     1.420     8.977     0.200
     1.420     9.149     0.200
     1.431     9.187     0.200
     1.567    11.089     0.200
     1.483     8.780     0.200
     1.483     8.522     0.200
     1.519     8.859     0.200
     1.519     9.016     0.200
     1.521     9.049     0.200
     1.539     8.808     0.200
     1.581     9.264     0.200
     1.701    10.271     0.200
     1.738     9.706     0.200
     1.744     9.888     0.200
     1.754    10.744     0.200
     1.754    10.853     0.200
     1.986    12.493     0.200
     1.989    12.158     0.200
     2.260    11.881     0.200
     2.418    12.754     0.200
     2.797    16.275     0.200
     0.497     4.187     0.200
     0.534     4.484     0.200
     0.601     4.574     0.200
     0.681     4.951     0.200
     0.681     5.240     0.200
     0.842     6.802     0.200
     0.939     7.779     0.200
     0.939     7.888     0.200
     0.968     7.668     0.200
     0.968     7.770     0.200
     1.002     6.496     0.200
     1.004     6.497     0.200
     1.090     7.683     0.200
     1.090     8.518     0.200
     1.272    10.179     0.200
     1.239     8.021     0.200
     1.234     9.592     0.200
     1.423     9.179     0.200
     1.498    10.980     0.200
     1.579     9.594     0.200
     1.560    10.932     0.200
     1.744    13.183     0.200
     1.744    13.308     0.200
     1.912    12.983     0.200
     1.912    12.655     0.200
     2.224    14.120     0.200
     2.282    14.406     0.200
     2.282    14.867     0.200
     2.279    14.540     0.200
     2.462    13.873     0.200
     2.450    14.122     0.200
     2.680    15.824     0.200
     0.355     3.052     0.200
     0.371     3.527     0.200
     0.371     3.546     0.200
     0.539     4.000     0.200
     0.533     3.894     0.200
     0.533     4.003     0.200
     0.594     5.367     0.200
     0.652     4.626     0.200
     0.652     4.759     0.200
     0.756     4.461     0.200
     0.780     6.078     0.200
     0.797     6.432     0.200
     0.848     4.909     0.200
     0.848     5.089     0.200
     0.847     5.809     0.200
     0.899     7.090     0.200
     0.983     7.160     0.200
     1.062     6.343     0.200
     1.065     6.319     0.200
     1.127     6.381     0.200
     1.253     9.505     0.200
     1.156     8.508     0.200
     1.175     7.429     0.200
     1.175     6.948     0.200
     1.206     9.171     0.200
     1.227     7.966     0.200
     1.368     8.180     0.200
     1.353     8.756     0.200
     1.418     9.541     0.200
     1.436     9.610     0.200
     1.474     8.314     0.200
     1.517     8.211     0.200
     1.526    10.247     0.200
     1.526    10.348     0.200
     1.595    10.440     0.200
     1.599     9.983     0.200
     1.598     9.824     0.200
     1.638     9.586     0.200
     1.643     9.200     0.200
     1.703    11.113     0.200
     1.703    10.656     0.200
     1.762     9.565     0.200
     1.785     9.524     0.200
     1.796    10.874     0.200
     1.861    10.213     0.200
     0.134     2.212     0.200
     0.459     3.928     0.200
     0.490     4.571     0.200
     0.516     4.233     0.200
     0.895     6.150     0.200
     0.897     5.837     0.200
     0.897     5.727     0.200
     0.998     6.804     0.200
     1.091     8.069     0.200
     1.174     7.887     0.200
     1.220     7.998     0.200
     1.259     8.740     0.200
     1.259     8.540     0.200
     1.307     8.883     0.200
     1.307     8.741     0.200
     1.326     8.931     0.200
     1.387     9.122     0.200
     1.390     8.726     0.200
     1.405     8.327     0.200
     1.518    10.934     0.200
     1.605    10.143     0.200
     1.611     9.497     0.200
     1.749    10.456     0.200
     1.800    10.193     0.200
     1.966    10.738     0.200
     2.005    10.694     0.200
     2.114    11.292     0.200
     2.284    12.126     0.200
     2.514    12.524     0.200
     0.392     3.409     0.200
     0.449     3.248     0.200
     0.487     4.204     0.200
     0.749     5.521     0.200
     0.997     8.140     0.200
     1.002     6.386     0.200
     1.183     8.297     0.200
     1.209     8.609     0.200
     1.239     9.048     0.200
     1.259     8.934     0.200
     1.256     7.846     0.200
     1.401    10.686     0.200
     1.705    10.512     0.200
     1.735    12.150     0.200
     1.786    12.292     0.200
     1.802    11.431     0.200
     2.158    12.255     0.200
     2.275    13.163     0.200
     2.346    12.749     0.200
     2.388    13.395     0.200
     2.533    13.579     0.200
     0.311     2.885     0.200
     0.463     4.065     0.200
     0.463     4.017     0.200
     0.512     4.180     0.200
     0.512     4.358     0.200
     0.726     5.846     0.200
     0.826     6.425     0.200
     0.894     5.771     0.200
     0.896     6.554     0.200
     1.001     6.727     0.200
     1.042     7.408     0.200
     1.089     8.262     0.200
     1.176     7.820     0.200
     1.216     8.109     0.200
     1.216     8.242     0.200
     1.256     8.814     0.200
     1.256     8.705     0.200
     1.310     8.728     0.200
     1.326     9.417     0.200
     1.326     9.083     0.200
     1.376    10.027     0.200
     1.389     9.334     0.200
     1.392     9.239     0.200
     1.408     8.232     0.200
     1.517    11.290     0.200
     1.608     9.723     0.200
     1.608     9.002     0.200
     1.761     9.850     0.200
     1.817     9.959     0.200
     2.286    13.127     0.200
     2.323    12.165     0.200
     0.320     2.681     0.200
     0.461     3.823     0.200
     0.506     4.338     0.200
     0.887     6.380     0.200
     0.897     5.830     0.200
     1.080     8.211     0.200
     1.214     8.318     0.200
     1.249     8.449     0.200
     1.309     8.595     0.200
     1.316     9.310     0.200
     1.385     8.509     0.200
     1.507    11.108     0.200
     1.806    10.879     0.200
     0.136     2.013     0.200
     0.315     2.793     0.200
     0.315     2.643     0.200
     0.460     4.018     0.200
     0.460     3.979     0.200
     0.511     4.252     0.200
     0.511     4.131     0.200
     0.511     4.428     0.200
     0.723     6.046     0.200
     0.824     6.440     0.200
     0.891     6.447     0.200
     0.891     6.247     0.200
     0.881     7.003     0.200
     0.897     5.857     0.200
     0.897     5.738     0.200
     0.997     6.489     0.200
     0.997     6.798     0.200
     1.039     7.373     0.200
     1.086     8.295     0.200
     1.171     7.849     0.200
     1.171     7.730     0.200
     1.217     8.300     0.200
     1.217     7.961     0.200
     1.254     8.979     0.200
     1.254     8.680     0.200
     1.247     8.420     0.200
     1.321     9.248     0.200
     1.308     8.727     0.200
     1.374     9.876     0.200
     1.385     8.754     0.200
     1.385     8.914     0.200
     1.387     8.935     0.200
     1.403     9.983     0.200
     1.513    11.020     0.200
     1.513    11.147     0.200
     1.404     7.856     0.200
     1.404     8.247     0.200
     1.449     8.712     0.200
     1.604     9.561     0.200
     1.611     9.743     0.200
     1.611     9.442     0.200
     1.616     9.912     0.200
     1.757     9.546     0.200
     1.750    10.177     0.200
     1.811    10.714     0.200
     1.811    10.915     0.200
     1.801    10.195     0.200
     0.305     2.272     0.200
     0.353     2.859     0.200
     0.516     4.320     0.200
     0.516     4.105     0.200
     0.520     4.577     0.200
     0.607     4.460     0.200
     0.660     5.092     0.200
     0.660     4.838     0.200
     0.685     4.717     0.200
     0.701     6.313     0.200
     0.773     6.359     0.200
     0.789     5.632     0.200
     0.799     5.414     0.200
     0.960     7.847     0.200
     0.960     7.631     0.200
     0.973     7.583     0.200
     0.992     7.645     0.200
     1.013     7.693     0.200
     1.016     6.398     0.200
     1.064     7.454     0.200
     1.081     8.119     0.200
     1.081     8.578     0.200
     1.156     8.953     0.200
     1.296    10.184     0.200
     1.196     8.914     0.200
     1.231     7.742     0.200
     1.250     9.398     0.200
     1.250     9.269     0.200
     1.268    10.273     0.200
     1.298     8.624     0.200
     1.345     9.947     0.200
     1.413     8.805     0.200
     1.426     9.681     0.200
     1.426     9.386     0.200
     1.459     8.626     0.200
     1.527    10.585     0.200
     1.581    10.996     0.200
     1.588     9.845     0.200
     1.694    11.536     0.200
     1.756    11.557     0.200
     1.765    11.339     0.200
     1.765    12.583     0.200
     1.921    11.088     0.200
     2.187    13.709     0.200
     2.249    14.272     0.200
     2.460    13.153     0.200
     2.464    13.099     0.200
     3.718    17.604     0.200
     3.789    17.778     0.200
     0.403     3.540     0.200
     0.403     3.472     0.200
     0.444     3.380     0.200
     0.444     3.278     0.200
     0.479     4.128     0.200
     0.665     5.643     0.200
     0.758     5.269     0.200
     0.904     6.340     0.200
     0.964     6.284     0.200
     0.990     6.552     0.200
     0.994     7.909     0.200
     1.050     6.881     0.200
     1.188     8.452     0.200
     1.250     8.333     0.200
     1.250     8.446     0.200
     1.203     9.210     0.200
     1.203     8.685     0.200
     1.249     8.533     0.200
     1.264     8.330     0.200
     1.267     8.366     0.200
     1.300     8.178     0.200
     1.281     9.666     0.200
     1.401    10.630     0.200
     1.652    10.090     0.200
     1.694    10.355     0.200
     1.703    10.037     0.200
     1.742    11.531     0.200
     1.742    11.905     0.200
     2.169    14.007     0.200
     2.390    13.139     0.200
     2.930    17.876     0.200
     0.327     2.198     0.200
     0.353     3.028     0.200
     0.605     4.199     0.200
     0.849     6.239     0.200
     0.849     6.663     0.200
     0.933     6.650     0.200
     1.002     6.361     0.200
     1.099     6.856     0.200
     1.197     9.326     0.200
     1.144     7.942     0.200
     1.144     8.311     0.200
     1.312     8.828     0.200
     1.312     8.749     0.200
     1.330     9.645     0.200
     1.330     9.295     0.200
     1.341     8.837     0.200
     1.341     9.411     0.200
     1.423    10.714     0.200
     1.440     9.973     0.200
     1.549    11.175     0.200
     1.549    10.692     0.200
     1.666    10.215     0.200
     1.718    10.978     0.200
     2.533    13.899     0.200
     0.265     2.354     0.200
     0.342     2.768     0.200
     0.342     2.638     0.200
     0.422     3.745     0.200
     0.422     3.855     0.200
     0.546     5.152     0.200
     0.588     4.683     0.200
     0.588     4.416     0.200
     0.588     4.575     0.200
     0.736     6.003     0.200
     0.776     4.712     0.200
     0.776     5.382     0.200
     0.776     5.180     0.200
     0.852     6.894     0.200
     0.961     6.202     0.200
     0.961     6.362     0.200
     1.012     7.854     0.200
     1.038     7.979     0.200
     1.038     7.692     0.200
     1.089     7.124     0.200
     1.089     7.693     0.200
     1.089     7.574     0.200
     1.116     7.644     0.200
     1.166     7.753     0.200
     1.166     8.243     0.200
     1.166     8.393     0.200
     1.165     8.267     0.200
     1.267     8.651     0.200
     1.267     8.222     0.200
     1.351     9.096     0.200
     1.373     9.155     0.200
     1.489    10.956     0.200
     1.398    10.107     0.200
     1.437     9.426     0.200
     1.437     9.596     0.200
     1.437     9.722     0.200
     1.481     9.880     0.200
     1.481     9.760     0.200
     1.484     8.916     0.200
     1.517     9.539     0.200
     1.573     9.660     0.200
     1.664     9.763     0.200
     1.698    10.161     0.200
     1.698    11.201     0.200
     1.698    11.072     0.200
     1.726    10.492     0.200
     1.742    10.874     0.200
     1.789    11.136     0.200
     1.789    11.426     0.200
     1.789    12.530     0.200
     1.985    12.876     0.200
     2.098    11.944     0.200
     2.126    11.760     0.200
     2.213    12.222     0.200
     2.229    14.974     0.200
     2.229    12.251     0.200
     3.178    15.288     0.200
     3.199    15.613     0.200
     0.302     2.342     0.200
     0.346     3.098     0.200
     0.346     3.120     0.200
     0.534     4.436     0.200
     0.582     5.287     0.200
     0.586     4.872     0.200
     0.600     4.130     0.200
     0.762     6.499     0.200
     0.745     5.764     0.200
     0.769     5.408     0.200
     0.796     6.575     0.200
     0.883     6.015     0.200
     0.936     7.834     0.200
     1.036     8.177     0.200
     1.036     8.020     0.200
     1.053     8.079     0.200
     1.098     7.264     0.200
     1.100     7.195     0.200
     1.150     7.253     0.200
     1.154     8.648     0.200
     1.145     7.625     0.200
     1.145     7.383     0.200
     1.301    10.117     0.200
     1.202     9.014     0.200
     1.202     9.129     0.200
     1.239     8.376     0.200
     1.281     8.301     0.200
     1.347     9.576     0.200
     1.608    10.469     0.200
     1.656     9.980     0.200
     1.674    11.527     0.200
     1.739    11.788     0.200
     1.779    10.742     0.200
     1.802    10.231     0.200
     2.270    13.741     0.200
     2.371    13.775     0.200
     2.394    13.176     0.200
     2.703    14.138     0.200
     2.955    15.024     0.200
     0.352     2.944     0.200
     0.439     3.908     0.200
     0.439     4.232     0.200
     0.525     4.060     0.200
     0.525     4.033     0.200
     0.753     6.260     0.200
     0.842     5.256     0.200
     0.842     6.049     0.200
     0.789     6.588     0.200
     0.903     5.909     0.200
     1.030     7.922     0.200
     1.030     8.156     0.200
     1.050     7.234     0.200
     1.142     7.136     0.200
     1.142     8.484     0.200
     1.100     7.952     0.200
     1.183     7.898     0.200
     1.183     8.796     0.200
     1.203     7.741     0.200
     1.313     9.002     0.200
     1.307     8.841     0.200
     1.375     9.574     0.200
     1.375     9.370     0.200
     1.469    10.089     0.200
     1.469    11.011     0.200
     1.417     9.420     0.200
     1.420     8.543     0.200
     1.450     9.149     0.200
     1.552     9.320     0.200
     1.552     9.941     0.200
     1.734    10.176     0.200
     2.060    12.025     0.200
     2.250    13.737     0.200
     2.321    13.739     0.200
     2.471    14.996     0.200
     0.463     3.506     0.200
     0.463     3.889     0.200
     0.487     4.310     0.200
     0.487     3.716     0.200
     0.498     4.163     0.200
     0.498     3.944     0.200
     0.668     6.002     0.200
     0.738     5.533     0.200
     0.714     6.183     0.200
     0.788     4.744     0.200
     0.831     6.024     0.200
     0.802     6.857     0.200
     0.802     7.005     0.200
     0.895     5.528     0.200
     0.893     7.256     0.200
     1.042     7.302     0.200
     1.045     7.276     0.200
     1.007     8.118     0.200
     1.150     9.529     0.200
     1.135     6.909     0.200
     1.098     8.494     0.200
     1.212     9.552     0.200
     1.212     9.052     0.200
     1.196     7.714     0.200
     1.324     9.107     0.200
     1.476     8.668     0.200
     1.448    10.590     0.200
     1.512     9.026     0.200
     1.525    10.995     0.200
     1.630    10.168     0.200
     1.607    11.904     0.200
     1.607    11.732     0.200
     1.781     9.869     0.200
     1.751    12.118     0.200
     1.751    12.680     0.200
     1.878    13.097     0.200
     1.865    12.165     0.200
     1.865    12.048     0.200
     1.961    11.930     0.200
     1.961    12.602     0.200
     2.116    15.075     0.200
     2.117    13.449     0.200
     2.141    15.916     0.200
     2.260    16.724     0.200
     2.326    14.268     0.200
     2.547    14.420     0.200
     2.738    15.755     0.200
     0.239     1.876     0.200
     0.418     3.803     0.200
     0.418     4.045     0.200
     0.550     4.292     0.200
     0.550     4.355     0.200
     0.561     5.506     0.200
     0.733     5.782     0.200
     0.733     6.193     0.200
     0.915     6.109     0.200
     0.915     5.773     0.200
     1.018     7.939     0.200
     1.072     7.340     0.200
     1.072     7.481     0.200
     1.116     8.000     0.200
     1.163     8.511     0.200
     1.220     7.475     0.200
     1.220     7.585     0.200
     1.310     8.847     0.200
     1.310     9.027     0.200
     1.298     9.638     0.200
     1.366     9.888     0.200
     1.461    10.892     0.200
     1.400     9.534     0.200
     1.400     9.733     0.200
     1.435     8.673     0.200
     1.437     8.307     0.200
     1.472     9.011     0.200
     1.472     9.144     0.200
     1.531     9.405     0.200
     1.531     9.726     0.200
     1.528     9.444     0.200
     1.618     9.895     0.200
     1.663    10.989     0.200
     1.702    10.708     0.200
     1.710    11.201     0.200
     1.710    11.540     0.200
     1.710    11.380     0.200
     1.778    11.616     0.200
     1.778    12.819     0.200
     2.546    13.769     0.200
     0.265     2.466     0.200
     0.265     2.365     0.200
     0.343     2.522     0.200
     0.524     4.447     0.200
     0.524     4.677     0.200
     0.643     4.618     0.200
     0.772     6.437     0.200
     0.738     5.867     0.200
     0.738     6.357     0.200
     0.788     6.040     0.200
     0.788     5.850     0.200
     0.894     6.929     0.200
     1.044     7.664     0.200
     1.044     8.425     0.200
     1.002     7.081     0.200
     1.041     7.131     0.200
     0.999     8.078     0.200
     1.014     8.055     0.200
     1.184     8.325     0.200
     1.172     9.040     0.200
     1.331    10.349     0.200
     1.312     9.835     0.200
     1.291     9.260     0.200
     1.308    10.344     0.200
     1.308    10.103     0.200
     1.392     8.967     0.200
     1.441     9.359     0.200
     1.441     9.169     0.200
     1.487     9.851     0.200
     1.459    10.022     0.200
     1.459    10.953     0.200
     1.544     9.692     0.200
     1.533    11.256     0.200
     1.533    11.065     0.200
     1.572    10.359     0.200
     1.572    10.469     0.200
     1.590    10.915     0.200
     1.590    11.155     0.200
     1.690    10.118     0.200
     1.912    10.977     0.200
     2.004    11.691     0.200
     2.306    12.998     0.200
     2.395    13.049     0.200
     0.350     3.227     0.200
     0.350     3.094     0.200
     0.516     3.487     0.200
     0.516     3.354     0.200
     0.644     4.388     0.200
     0.694     5.656     0.200
     0.792     5.503     0.200
     0.881     6.494     0.200
     0.937     5.788     0.200
     0.959     6.958     0.200
     0.959     7.075     0.200
     1.089     7.498     0.200
     1.151     6.802     0.200
     1.154     6.874     0.200
     1.196     6.816     0.200
     1.178     8.077     0.200
     1.178     8.584     0.200
     1.338     9.652     0.200
     1.206     8.111     0.200
     1.334     7.968     0.200
     1.318     8.346     0.200
     1.458     9.686     0.200
     1.453     9.689     0.200
     1.547     8.738     0.200
     1.634    10.758     0.200
     1.703    10.756     0.200
     1.697    10.089     0.200
     1.758    10.669     0.200
     1.820    10.357     0.200
     1.843     9.813     0.200
     1.848    11.234     0.200
     1.824    11.106     0.200
     1.824    10.669     0.200
     2.058    11.762     0.200
     2.267    12.109     0.200
     2.314    12.704     0.200
     2.428    12.708     0.200
     2.380    12.048     0.200
     2.436    12.335     0.200
     2.839    13.521     0.200
     2.999    14.245     0.200
     0.366     3.201     0.200
     0.366     3.108     0.200
     0.501     3.977     0.200
     0.634     4.558     0.200
     0.712     5.890     0.200
     0.775     6.169     0.200
     0.890     6.929     0.200
     0.939     7.593     0.200
     0.934     5.786     0.200
     1.073     7.814     0.200
     1.095     6.922     0.200
     1.095     6.821     0.200
     1.188     7.860     0.200
     1.188     8.657     0.200
     1.184     8.907     0.200
     1.190     8.267     0.200
     1.190     8.541     0.200
     1.199     8.002     0.200
     1.318    10.164     0.200
     1.243     9.577     0.200
     1.307     9.058     0.200
     1.332     8.500     0.200
     1.621    11.060     0.200
     1.703    10.373     0.200
     1.725    10.672     0.200
     1.738    10.646     0.200
     1.738    11.107     0.200
     1.789    10.906     0.200
     1.789    10.648     0.200
     1.807    11.370     0.200
     1.807    10.893     0.200
     1.849     9.974     0.200
     2.058    12.214     0.200
     2.248    12.669     0.200
     2.295    13.166     0.200
     0.318     2.956     0.200
     0.467     4.352     0.200
     0.524     4.375     0.200
     0.524     4.180     0.200
     0.782     5.984     0.200
     0.787     6.188     0.200
     0.927     6.441     0.200
     0.927     6.262     0.200
     0.946     7.036     0.200
     1.064     8.010     0.200
     1.154     7.426     0.200
     1.212     8.056     0.200
     1.212     8.204     0.200
     1.220     7.522     0.200
     1.310     8.657     0.200
     1.403     9.451     0.200
     1.403     8.935     0.200
     1.503     9.570     0.200
     1.461     8.157     0.200
     1.548     8.773     0.200
     1.616     9.350     0.200
     1.679     9.620     0.200
     0.266     2.356     0.200
     0.438     4.162     0.200
     0.593     4.728     0.200
     0.583     5.614     0.200
     0.662     4.986     0.200
     0.718     5.311     0.200
     0.814     5.944     0.200
     0.830     6.208     0.200
     0.940     7.638     0.200
     0.882     7.509     0.200
     0.909     7.097     0.200
     0.917     7.549     0.200
     1.047     6.787     0.200
     1.048     7.166     0.200
     1.076     7.608     0.200
     1.122     9.102     0.200
     1.360     9.253     0.200
     1.381     8.544     0.200
     1.376    10.617     0.200
     1.474    10.205     0.200
     1.499    11.201     0.200
     1.604    11.086     0.200
     1.667    10.567     0.200
     1.712    10.661     0.200
     1.737    10.586     0.200
     1.771    11.122     0.200
     1.907    10.994     0.200
     0.385     3.363     0.200
     0.497     3.619     0.200
     0.482     3.948     0.200
     0.702     4.938     0.200
     0.771     6.008     0.200
     0.865     5.819     0.200
     0.932     7.274     0.200
     0.965     7.691     0.200
     0.999     6.336     0.200
     1.135     7.951     0.200
     1.225     7.820     0.200
     1.191     8.731     0.200
     1.256     8.326     0.200
     1.235     8.990     0.200
     1.361    10.134     0.200
     1.265     9.520     0.200
     1.607     9.946     0.200
     1.656    10.145     0.200
     1.687    11.673     0.200
     1.758    11.525     0.200
     1.787    11.345     0.200
     0.376     3.143     0.200
     0.438     3.609     0.200
     0.497     3.939     0.200
     0.761     5.943     0.200
     0.751     5.665     0.200
     0.866     5.592     0.200
     1.016     6.779     0.200
     1.014     7.240     0.200
     1.069     7.742     0.200
     1.166     7.013     0.200
     1.163     7.804     0.200
     1.181     8.617     0.200
     1.274     8.547     0.200
     1.347     9.074     0.200
     1.342     9.559     0.200
     1.447    10.233     0.200
     1.415     9.132     0.200
     1.742    10.432     0.200
     1.767    10.151     0.200
     0.407     3.800     0.200
     0.407     3.494     0.200
     0.568     5.040     0.200
     0.650     3.606     0.200
     0.650     3.496     0.200
     0.693     4.537     0.200
     0.693     4.420     0.200
     0.766     4.688     0.200
     0.807     5.857     0.200
     0.845     5.945     0.200
     0.842     6.302     0.200
     0.879     6.612     0.200
     0.993     5.589     0.200
     1.087     6.728     0.200
     1.087     7.924     0.200
     1.009     7.711     0.200
     1.091     6.604     0.200
     1.176     8.812     0.200
     1.188     8.741     0.200
     1.209     8.593     0.200
     1.334     7.515     0.200
     1.371     8.414     0.200
     1.498     9.076     0.200
     1.492     8.703     0.200
     1.513     8.214     0.200
     1.639     8.731     0.200
     1.823    10.479     0.200
     1.823    10.557     0.200
     1.921    11.595     0.200
     1.941    10.774     0.200
     2.002    12.298     0.200
     3.150    18.812     0.200
     0.209     2.546     0.200
     0.465     4.486     0.200
     0.540     4.555     0.200
     0.640     5.435     0.200
     0.759     6.575     0.200
     0.966     7.229     0.200
     1.048     7.653     0.200
     1.163     8.707     0.200
     1.272     7.991     0.200
     1.343     8.479     0.200
     1.315     8.213     0.200
     1.522     8.589     0.200
     1.594     9.017     0.200
     1.714     9.388     0.200
     0.402     3.314     0.200
     0.404     3.459     0.200
     0.431     3.461     0.200
     0.667     5.770     0.200
     0.911     6.619     0.200
     0.911     6.209     0.200
     0.968     7.358     0.200
     1.004     7.442     0.200
     1.060     7.018     0.200
     1.060     7.155     0.200
     1.201     7.883     0.200
     1.253     8.826     0.200
     1.293     8.391     0.200
     1.293     9.012     0.200
     1.308     8.391     0.200
     1.413    10.123     0.200
     1.372     8.626     0.200
     1.457     9.497     0.200
     1.523     9.268     0.200
     1.521     9.558     0.200
     1.547     9.450     0.200
     1.660    10.180     0.200
     1.660     9.391     0.200
     1.688     9.234     0.200
     1.688    10.124     0.200
     1.731    10.688     0.200
     1.754    10.943     0.200
     1.801    10.332     0.200
     2.804    16.939     0.200
     0.413     3.420     0.200
     0.415     3.370     0.200
     0.440     3.360     0.200
     0.678     5.832     0.200
     0.917     7.166     0.200
     0.917     6.025     0.200
     0.977     7.297     0.200
     0.977     7.180     0.200
     1.061     6.293     0.200
     1.061     8.274     0.200
     1.193     8.031     0.200
     1.263     8.841     0.200
     1.313     7.868     0.200
     1.313     7.735     0.200
     1.282     8.986     0.200
     1.282     9.127     0.200
     1.401    10.296     0.200
     1.459     8.748     0.200
     1.531     9.028     0.200
     1.556     9.643     0.200
     1.665     9.562     0.200
     1.681     9.804     0.200
     1.681    10.284     0.200
     1.740    10.660     0.200
     1.748    11.459     0.200
     1.808    10.930     0.200
     1.847    12.173     0.200
     1.847    10.622     0.200
     1.934    10.705     0.200
     1.934    11.045     0.200
     1.929    11.038     0.200
     1.951    10.809     0.200
     1.951    11.059     0.200
     2.416    16.153     0.200
     0.524     4.492     0.200
     0.524     4.722     0.200
     0.679     4.166     0.200
     0.679     4.515     0.200
     0.680     4.775     0.200
     0.770     5.441     0.200
     0.770     5.582     0.200
     0.784     5.340     0.200
     0.808     6.310     0.200
     0.852     6.676     0.200
     0.948     7.838     0.200
     0.973     7.921     0.200
     1.053     6.567     0.200
     1.080     8.179     0.200
     1.080     7.257     0.200
     1.150     6.674     0.200
     1.123     8.983     0.200
     1.182     7.496     0.200
     1.280    10.326     0.200
     1.244     8.837     0.200
     1.244     9.198     0.200
     1.291     7.493     0.200
     1.257     9.901     0.200
     1.341     9.690     0.200
     1.402     8.189     0.200
     1.500    10.887     0.200
     1.562     9.259     0.200
     1.574     9.462     0.200
     1.718    11.555     0.200
     1.749    11.843     0.200
     1.753    11.660     0.200
     1.907    10.925     0.200
     1.941    12.201     0.200
     1.934    12.262     0.200
     1.934    11.473     0.200
     2.001    11.878     0.200
     2.168    14.368     0.200
     0.262     3.053     0.200
     0.461     4.658     0.200
     0.800     6.121     0.200
     0.826     5.945     0.200
     1.083     6.516     0.200
     1.083     6.723     0.200
     1.118     7.718     0.200
     1.119     7.319     0.200
     1.261     7.213     0.200
     1.261     7.353     0.200
     1.256     7.939     0.200
     1.395     8.926     0.200
     1.397     9.017     0.200
     1.381     8.037     0.200
     1.381     8.287     0.200
     1.461     8.643     0.200
     1.461     9.201     0.200
     1.561     9.414     0.200
     1.491     8.650     0.200
     1.491     7.940     0.200
     1.561     9.683     0.200
     1.532     8.730     0.200
     1.533     8.649     0.200
     1.656     8.881     0.200
     1.689     8.745     0.200
     1.694     9.063     0.200
     1.956    12.012     0.200
     0.813     5.797     0.200
     0.908     7.417     0.200
     0.997     7.033     0.200
     1.329     8.511     0.200
     1.439    11.293     0.200
     1.466    10.207     0.200
     1.660    10.243     0.200
     1.686    10.537     0.200
     1.793    12.092     0.200
     2.118    13.990     0.200
     2.127    15.222     0.200
     5.064    25.934     0.200
     0.709     5.454     0.200
     0.754     5.907     0.200
     0.754     5.796     0.200
     0.862     6.965     0.200
     0.945     7.761     0.200
     0.945     7.941     0.200
     0.948     8.021     0.200
     1.027     6.943     0.200
     1.106     9.142     0.200
     1.152     7.991     0.200
     1.266    10.368     0.200
     1.249     9.286     0.200
     1.249     9.547     0.200
     1.254     9.991     0.200
     1.348    10.133     0.200
     1.375     8.762     0.200
     1.375     8.652     0.200
     1.419     8.808     0.200
     1.419     8.814     0.200
     1.472    11.057     0.200
     1.538     9.211     0.200
     1.546    10.107     0.200
     1.546     9.977     0.200
     1.662    10.219     0.200
     1.698    11.666     0.200
     1.734    12.099     0.200
     1.879    11.636     0.200
     1.879    11.753     0.200
     1.879    13.353     0.200
     1.987    12.232     0.200
     1.985    11.536     0.200
     2.139    13.791     0.200
     2.139    14.021     0.200
     2.647    14.426     0.200
     2.733    15.191     0.200
     0.592     4.386     0.200
     0.803     7.059     0.200
     0.886     6.274     0.200
     0.946     8.333     0.200
     1.044     8.468     0.200
     1.151     7.659     0.200
     1.169     9.745     0.200
     1.210     9.647     0.200
     1.310    10.793     0.200
     1.252    10.310     0.200
     1.501    10.028     0.200
     1.547    10.670     0.200
     1.586    11.581     0.200
     1.676    10.955     0.200
     1.837    11.721     0.200
     2.009    13.470     0.200
     0.586     4.215     0.200
     0.796     6.874     0.200
     0.897     6.575     0.200
     0.943     8.106     0.200
     1.050     8.188     0.200
     1.161     8.546     0.200
     1.171     9.541     0.200
     1.204     9.469     0.200
     1.511    10.683     0.200
     1.558    10.878     0.200
     1.593    11.313     0.200
     1.826    11.797     0.200
     0.292     2.566     0.200
     0.889     6.140     0.200
     0.889     6.257     0.200
     1.149     7.241     0.200
     1.139     8.049     0.200
     1.340     8.813     0.200
     1.319     8.813     0.200
     1.319     8.633     0.200
     1.367     7.663     0.200
     1.438     9.913     0.200
     1.431     9.899     0.200
     1.431     9.418     0.200
     1.507     9.420     0.200
     1.541     8.987     0.200
     1.556    10.632     0.200
     1.720     9.360     0.200
     1.720    10.328     0.200
     1.664     9.895     0.200
     1.779     9.489     0.200
     1.779     9.633     0.200
     1.779    10.512     0.200
     1.842     9.472     0.200
     0.496     3.910     0.200
     0.914     5.761     0.200
     0.914     6.140     0.200
     0.998     7.309     0.200
     1.114     6.627     0.200
     1.160     8.289     0.200
     1.208     8.372     0.200
     1.281     8.021     0.200
     1.300     7.747     0.200
     1.307     7.594     0.200
     1.317     8.544     0.200
     1.364     9.231     0.200
     1.364     8.411     0.200
     1.516     9.236     0.200
     1.414     8.176     0.200
     1.414     8.465     0.200
     1.468     8.364     0.200
     1.468     8.145     0.200
     1.466     9.378     0.200
     1.466     9.198     0.200
     1.502     8.937     0.200
     1.516     9.588     0.200
     1.529     8.651     0.200
     1.528     8.546     0.200
     1.589     9.041     0.200
     1.679     9.424     0.200
     1.693     9.346     0.200
     1.706     9.240     0.200
     1.717    10.884     0.200
     1.717     9.904     0.200
     1.705     9.479     0.200
     0.250     1.187     0.200
     0.296     2.136     0.200
     0.555     4.301     0.200
     0.546     5.155     0.200
     0.827     7.580     0.200
     0.842     6.169     0.200
     1.124     8.756     0.200
     0.995     7.841     0.200
     1.224     9.666     0.200
     1.088     9.346     0.200
     1.405    10.557     0.200
     1.501    10.723     0.200
     1.589    11.313     0.200
     1.683    11.068     0.200
     1.793    10.656     0.200
     1.783    10.746     0.200
     1.623    10.841     0.200
     0.397     3.377     0.200
     0.399     3.371     0.200
     0.470     3.379     0.200
     0.659     5.227     0.200
     0.954     7.560     0.200
     1.028     7.026     0.200
     1.028     7.135     0.200
     1.162     9.002     0.200
     1.243     9.109     0.200
     1.243     8.809     0.200
     1.283     8.861     0.200
     1.257     9.583     0.200
     1.257     9.954     0.200
     1.379    10.605     0.200
     1.426     9.607     0.200
     1.635    10.599     0.200
     1.635    10.111     0.200
     1.685    10.507     0.200
     1.684    10.128     0.200
     1.715    12.318     0.200
     1.715    11.869     0.200
     1.709    10.818     0.200
     1.709    10.986     0.200
     1.780    11.167     0.200
     1.815    11.599     0.200
     1.815    12.002     0.200
     2.384    16.762     0.200
     0.416     3.222     0.200
     0.416     3.089     0.200
     0.493     4.129     0.200
     0.495     4.102     0.200
     0.759     6.378     0.200
     0.977     7.623     0.200
     1.061     7.564     0.200
     1.140     6.826     0.200
     1.140     7.061     0.200
     1.152     8.761     0.200
     1.152     8.394     0.200
     1.234     8.430     0.200
     1.265     9.510     0.200
     1.265     9.151     0.200
     1.302     9.325     0.200
     1.302     9.536     0.200
     1.407    10.420     0.200
     1.345     9.321     0.200
     1.397     8.514     0.200
     1.407     9.858     0.200
     1.537     9.527     0.200
     1.748    10.106     0.200
     1.799    11.898     0.200
     1.799    12.008     0.200
     1.798    10.242     0.200
     1.798    10.263     0.200
     2.467    16.288     0.200
     0.418     3.289     0.200
     0.418     3.171     0.200
     0.497     4.203     0.200
     0.500     4.177     0.200
     0.763     6.562     0.200
     0.763     6.242     0.200
     0.974     7.672     0.200
     1.065     7.462     0.200
     1.065     7.141     0.200
     1.142     7.077     0.200
     1.142     7.187     0.200
     1.148     8.315     0.200
     1.148     8.143     0.200
     1.234     8.493     0.200
     1.262     8.961     0.200
     1.262     9.493     0.200
     1.300     9.489     0.200
     1.300     9.216     0.200
     1.405    10.538     0.200
     1.349     9.405     0.200
     1.349     8.991     0.200
     1.400     9.452     0.200
     1.400     8.577     0.200
     1.405    10.389     0.200
     1.540     9.207     0.200
     1.593     9.318     0.200
     1.593     9.678     0.200
     1.751    10.224     0.200
     1.751    10.365     0.200
     1.801    10.320     0.200
     1.801     9.816     0.200
     1.800    11.479     0.200
     1.800    10.940     0.200
     0.497     3.992     0.200
     0.745     5.278     0.200
     0.858     6.811     0.200
     0.933     6.364     0.200
     0.988     8.345     0.200
     1.060     7.378     0.200
     1.168     7.248     0.200
     1.250     9.501     0.200
     1.428     8.493     0.200
     1.507     9.167     0.200
     1.542     9.485     0.200
     1.658    10.529     0.200
     1.689    10.626     0.200
     2.288    12.912     0.200
     2.288    13.053     0.200
     2.288    12.771     0.200
     3.105    15.923     0.200
     3.169    15.881     0.200
     3.669    17.789     0.200
     0.471     3.764     0.200
     0.641     4.608     0.200
     0.964     6.390     0.200
     1.273     9.270     0.200
     1.343     9.468     0.200
     1.482     8.810     0.200
     1.580     9.965     0.200
     1.620     9.040     0.200
     1.756    11.096     0.200
     1.750     9.579     0.200
     1.741    10.362     0.200
     0.753     5.473     0.200
     0.860     5.872     0.200
     0.942     6.895     0.200
     0.978     7.640     0.200
     1.050     7.956     0.200
     1.259    10.018     0.200
     1.434    10.636     0.200
     1.542    11.024     0.200
     1.511     9.413     0.200
     1.545     9.381     0.200
     1.660    11.652     0.200
     1.694    11.395     0.200
     0.886     5.329     0.200
     0.944     6.924     0.200
     1.259     9.752     0.200
     1.312     9.899     0.200
     1.809    12.104     0.200
     0.528     4.141     0.200
     0.665     5.179     0.200
     0.829     5.448     0.200
     0.915     6.745     0.200
     0.885     6.968     0.200
     0.997     6.837     0.200
     1.141     8.857     0.200
     1.354     8.151     0.200
     1.439    10.494     0.200
     1.464     9.968     0.200
     1.524     9.315     0.200
     1.652     9.845     0.200
     1.730    11.954     0.200
     1.788    12.262     0.200
     0.736     5.375     0.200
     0.917     6.179     0.200
     0.995     5.715     0.200
     0.984     7.983     0.200
     1.007     8.167     0.200
     1.311     9.778     0.200
     1.358     9.811     0.200
     1.491    10.482     0.200
     1.602     9.844     0.200
     1.752    11.033     0.200
     1.779    11.812     0.200
     2.663    16.628     0.200
     0.479     3.979     0.200
     0.629     4.206     0.200
     0.769     4.893     0.200
     0.900     6.261     0.200
     0.949     6.186     0.200
     1.093     8.832     0.200
     1.099     7.122     0.200
     1.315     8.187     0.200
     1.475     8.785     0.200
     1.603     9.132     0.200
     1.675    11.146     0.200
     1.747    12.054     0.200
     1.759    11.403     0.200
     3.219    18.813     0.200
     0.468     3.635     0.200
     1.093     8.979     0.200
     1.378    10.095     0.200
     1.482     9.262     0.200
     1.771    10.432     0.200
     1.895    11.139     0.200
     0.472     3.715     0.200
     0.637     4.416     0.200
     1.093     8.771     0.200
     1.481     8.814     0.200
     1.767    10.883     0.200
     1.907    11.839     0.200
     0.517     3.715     0.200
     0.694     4.675     0.200
     0.842     5.553     0.200
     1.002     5.608     0.200
     1.018     8.654     0.200
     1.120     7.609     0.200
     1.173     7.737     0.200
     1.203     7.590     0.200
     1.317     9.058     0.200
     1.369     7.885     0.200
     1.497     8.406     0.200
     1.578    10.822     0.200
     1.639    11.979     0.200
     1.663    12.337     0.200
     1.647    10.113     0.200
     1.774    10.888     0.200
     1.808    11.459     0.200
     2.013    11.426     0.200
     0.473     3.795     0.200
     0.640     4.029     0.200
     1.097     8.773     0.200
     1.382    10.288     0.200
     1.440     9.153     0.200
     1.484     8.976     0.200
     1.611     9.269     0.200
     1.682    11.639     0.200
     1.770    10.739     0.200
     0.499     3.807     0.200
     0.805     5.438     0.200
     1.222     9.532     0.200
     1.385     9.131     0.200
     1.644     9.141     0.200
     0.515     4.006     0.200
     0.780     5.783     0.200
     0.825     6.155     0.200
     0.897     6.751     0.200
     0.927     8.114     0.200
     1.101     7.162     0.200
     1.077     8.261     0.200
     1.218     9.602     0.200
     1.243     8.334     0.200
     1.436     9.102     0.200
     1.467     9.546     0.200
     1.626     9.177     0.200
     1.753    10.302     0.200
     2.037    12.160     0.200
     0.542     4.177     0.200
     0.674     5.099     0.200
     1.168     9.093     0.200
     1.126     9.068     0.200
     1.536     9.204     0.200
     1.800    11.824     0.200
     2.394    13.937     0.200
     3.512    17.655     0.200
     0.513     4.003     0.200
     0.759     5.451     0.200
     0.858     5.984     0.200
     0.944     6.318     0.200
     0.972     8.444     0.200
     1.047     8.096     0.200
     1.261     9.980     0.200
     1.510     9.426     0.200
     1.545    11.302     0.200
     1.543     9.859     0.200
     1.658    10.818     0.200
     1.694     9.491     0.200
     1.877    12.726     0.200
     1.837    11.047     0.200
     0.513     3.969     0.200
     0.570     4.376     0.200
     0.747     4.640     0.200
     0.907     7.949     0.200
     0.960     6.934     0.200
     1.072     8.258     0.200
     1.229     7.998     0.200
     1.257     8.368     0.200
     1.228     9.368     0.200
     1.369     9.465     0.200
     1.427     8.253     0.200
     1.697    11.780     0.200
     1.698    10.625     0.200
     1.866    11.789     0.200
     0.484     3.787     0.200
     0.597     4.369     0.200
     0.747     4.700     0.200
     0.919     6.143     0.200
     0.923     6.666     0.200
     0.931     7.783     0.200
     1.071     8.128     0.200
     1.252     8.130     0.200
     1.224     8.612     0.200
     1.283     8.293     0.200
     1.357    10.330     0.200
     1.397     9.742     0.200
     1.648    11.653     0.200
     1.705    12.390     0.200
     1.727    10.553     0.200
     1.853    11.098     0.200
     0.532     4.192     0.200
     0.777     5.778     0.200
     0.858     6.100     0.200
     0.955     5.945     0.200
     1.031     8.626     0.200
     1.274     9.446     0.200
     1.311     7.655     0.200
     1.512     9.139     0.200
     1.544     9.229     0.200
     1.557    11.213     0.200
     1.657    10.366     0.200
     1.699     9.713     0.200
     1.826    10.331     0.200
     0.478     3.824     0.200
     0.566     4.283     0.200
     0.718     5.004     0.200
     0.886     6.210     0.200
     0.938     6.621     0.200
     0.943     7.615     0.200
     1.039     6.641     0.200
     1.043     7.900     0.200
     1.254     8.770     0.200
     1.696    10.542     0.200
     0.573     4.505     0.200
     0.580     4.469     0.200
     0.799     5.015     0.200
     0.845     7.069     0.200
     0.924     6.313     0.200
     1.003     7.035     0.200
     1.098     6.477     0.200
     1.122     8.419     0.200
     1.247     8.108     0.200
     1.269     8.301     0.200
     1.375     9.663     0.200
     1.453     8.710     0.200
     1.581     9.659     0.200
     0.576     3.412     0.200
     0.522     4.592     0.200
     1.084     7.965     0.200
     1.188     7.403     0.200
     1.436     8.265     0.200
     1.876     9.833     0.200
     0.493     3.982     0.200
     0.637     4.763     0.200
     0.905     6.639     0.200
     1.109     9.249     0.200
     1.394    10.449     0.200
     1.437     9.618     0.200
     1.487     9.824     0.200
     1.689    12.055     0.200
     1.745    11.583     0.200
     1.762    12.448     0.200
     1.766    11.655     0.200
     0.517     3.991     0.200
     0.751     5.578     0.200
     0.872     6.211     0.200
     0.977     8.387     0.200
     1.185     7.280     0.200
     1.271    10.022     0.200
     1.314     8.846     0.200
     1.446     8.707     0.200
     1.706    10.249     0.200
     0.466     3.689     0.200
     0.613     3.648     0.200
     1.071     7.919     0.200
     1.455     8.457     0.200
     1.743    10.495     0.200
     1.882    11.574     0.200
     0.490     3.839     0.200
     0.598     4.196     0.200
     1.077     8.311     0.200
     1.197     7.417     0.200
     1.448     8.684     0.200
     1.727    10.763     0.200
     0.609     4.442     0.200
     0.930     7.465     0.200
     0.930     7.494     0.200
     1.080     8.583     0.200
     1.204     8.819     0.200
     1.366    10.634     0.200
     1.409     9.152     0.200
     1.456     9.727     0.200
     1.584     9.334     0.200
     1.733    12.696     0.200
     1.738    11.213     0.200
     1.887    11.638     0.200
     0.569     4.428     0.200
     0.868     5.502     0.200
     1.023     6.897     0.200
     0.846     6.724     0.200
     1.193    10.047     0.200
     1.187     7.082     0.200
     1.305     8.620     0.200
     1.478    10.930     0.200
     1.480    10.165     0.200
     1.551     9.801     0.200
     1.844    13.069     0.200
     1.806    11.587     0.200
     0.508     3.988     0.200
     0.866     6.045     0.200
     0.983     7.931     0.200
     1.049     7.975     0.200
     1.178     7.258     0.200
     1.262     9.928     0.200
     1.545    10.901     0.200
     1.667    10.317     0.200
     1.699     9.722     0.200
     1.829    10.949     0.200
     0.513     3.901     0.200
     0.615     4.577     0.200
     0.900     7.753     0.200
     0.945     6.466     0.200
     0.934     7.102     0.200
     1.107     8.424     0.200
     1.303     8.369     0.200
     1.392    10.495     0.200
     1.472     8.652     0.200
     1.743    11.631     0.200
     0.855     7.846     0.200
     1.142     8.620     0.200
     1.427    10.874     0.200
     1.419    10.170     0.200
     1.490     8.250     0.200
     1.618     9.963     0.200
     1.746    10.668     0.200
     2.083    12.216     0.200
     0.512     4.163     0.200
     0.763     5.675     0.200
     0.834     6.025     0.200
     0.885     5.757     0.200
     0.924     7.855     0.200
     1.085     6.956     0.200
     1.206     9.553     0.200
     1.610     9.098     0.200
     1.738     9.772     0.200
     0.519     4.151     0.200
     0.775     5.742     0.200
     0.831     6.162     0.200
     0.896     5.864     0.200
     0.922     8.077     0.200
     1.097     7.177     0.200
     1.077     8.228     0.200
     1.218     9.612     0.200
     1.622     9.201     0.200
     1.903    11.413     0.200
     1.923    11.309     0.200
     2.044    11.869     0.200
     0.467     3.695     0.200
     0.624     4.605     0.200
     0.895     6.406     0.200
     0.945     7.498     0.200
     1.080     8.848     0.200
     1.276     7.753     0.200
     1.308     8.019     0.200
     1.365    10.379     0.200
     1.424     9.237     0.200
     1.466     8.711     0.200
     1.594     9.325     0.200
     1.664    10.969     0.200
     1.719    11.575     0.200
     1.879    10.990     0.200
     1.080     8.020     0.200
     0.439     3.484     0.200
     0.614     4.058     0.200
     1.052     8.485     0.200
     1.241     8.626     0.200
     1.447     8.181     0.200
     1.745    11.034     0.200
     0.462     4.136     0.200
     0.842     5.553     0.200
     0.902     5.403     0.200
     1.218     9.085     0.200
     1.267     7.179     0.200
     1.501    10.575     0.200
     1.487     8.317     0.200
     1.523     8.432     0.200
     1.642     9.452     0.200
     1.665     8.763     0.200
     2.817    17.276     0.200
     2.893    17.969     0.200
     0.501     3.906     0.200
     0.755     5.621     0.200
     0.850     5.604     0.200
     0.931     6.085     0.200
     0.979     8.269     0.200
     1.059     7.987     0.200
     1.249     9.679     0.200
     1.291     8.365     0.200
     1.535     9.346     0.200
     1.684     9.247     0.200
     1.845    11.092     0.200
     0.492     3.828     0.200
     0.584     4.340     0.200
     0.744     4.679     0.200
     0.908     6.039     0.200
     0.937     7.128     0.200
     0.925     8.167     0.200
     1.068     8.177     0.200
     1.229     9.080     0.200
     1.435     8.291     0.200
     1.563     9.357     0.200
     1.714    10.606     0.200
     1.841    11.141     0.200
     1.869    11.616     0.200
     1.911    12.600     0.200
     1.970    12.290     0.200
     0.519     3.993     0.200
     0.635     4.649     0.200
     0.927     7.022     0.200
     0.894     7.799     0.200
     0.965     6.382     0.200
     1.125     8.637     0.200
     1.123     6.531     0.200
     1.170     8.787     0.200
     1.295     8.183     0.200
     1.492     8.829     0.200
     1.620     9.336     0.200
     1.699    11.563     0.200
     1.762    11.241     0.200
     1.893    11.274     0.200
     1.928    12.188     0.200
     1.919    12.604     0.200
     0.498     3.795     0.200
     0.787     5.728     0.200
     0.808     5.751     0.200
     0.904     5.545     0.200
     0.959     7.935     0.200
     1.077     7.928     0.200
     1.223     9.956     0.200
     1.258     6.955     0.200
     1.461     8.585     0.200
     1.493     8.843     0.200
     1.608    10.024     0.200
     1.646     9.612     0.200
     1.773    10.011     0.200
     1.833    12.146     0.200
     1.879    12.758     0.200
     1.888    12.194     0.200
     1.938    12.546     0.200
     0.540     4.372     0.200
     0.735     5.288     0.200
     0.915     6.189     0.200
     0.993     5.962     0.200
     0.986     8.141     0.200
     1.009     7.835     0.200
     1.308    10.026     0.200
     1.356     7.941     0.200
     1.750     9.398     0.200
     1.781    11.452     0.200
     0.565     4.416     0.200
     0.583     4.166     0.200
     1.119     8.188     0.200
     1.187     8.741     0.200
     1.706    10.388     0.200
     1.903    11.934     0.200
     1.852    13.684     0.200
     2.014    13.001     0.200
     0.566     4.592     0.200
     0.590     4.374     0.200
     0.801     4.892     0.200
     0.932     6.201     0.200
     0.850     7.663     0.200
     0.991     7.349     0.200
     1.104     6.314     0.200
     1.124     8.445     0.200
     1.256     7.762     0.200
     1.181     9.164     0.200
     1.386     9.183     0.200
     1.461     8.560     0.200
     1.589     9.502     0.200
     1.712    11.212     0.200
     1.909    11.887     0.200
     1.855    13.423     0.200
     2.019    12.553     0.200
     0.546     4.474     0.200
     0.606     3.963     0.200
     1.123     8.777     0.200
     1.178     8.962     0.200
     1.472     8.702     0.200
     1.915    11.836     0.200
     1.880    12.459     0.200
     2.021    12.183     0.200
     2.452    13.333     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.788    36.139     0.200
     1.839    36.098     0.200
     2.124    42.667     0.200
     1.319    24.366     0.200
     1.665    31.849     0.200
     1.733    33.229     0.200
     1.825    34.277     0.200
     1.672    34.313     0.200
     1.724    33.205     0.200
     1.750    33.937     0.200
     1.818    35.687     0.200
     2.365    41.794     0.200
     3.313    54.669     0.200
     3.416    55.882     0.200
     1.506    30.106     0.200
     1.861    35.162     0.200
     2.009    36.243     0.200
     1.626    33.282     0.200
     1.651    33.696     0.200
     1.713    33.371     0.200
     3.914    62.151     0.200
     4.842    74.554     0.200
     1.942    36.528     0.200
     1.573    32.718     0.200
     1.582    33.171     0.200
     3.819    60.451     0.200
     1.577    31.392     0.200
     1.636    32.431     0.200
     1.706    35.134     0.200
     1.782    35.841     0.200
     2.304    41.615     0.200
     3.898    64.370     0.200
     4.188    68.163     0.200
     5.123    81.588     0.200
     8.547   122.340     0.200
    12.110   170.814     0.200
     1.706    34.241     0.200
     1.711    34.288     0.200
     1.804    34.605     0.200
     1.835    36.934     0.200
     2.296    41.465     0.200
     2.803    48.499     0.200
     1.736    34.612     0.200
     1.814    36.771     0.200
     2.707    46.739     0.200
     3.194    53.002     0.200
     3.298    54.802     0.200
     8.550   119.197     0.200
    12.081   170.176     0.200
     1.501    30.440     0.200
     3.293    53.597     0.200
     3.994    62.252     0.200
     3.898    60.677     0.200
     5.698    81.980     0.200
     8.573   118.393     0.200
     3.855    61.858     0.200
     1.152    25.264     0.200
     1.723    33.881     0.200
     2.791    47.218     0.200
     3.941    63.631     0.200
     8.582   118.799     0.200
    10.133   144.581     0.200
     3.957    63.543     0.200
     8.601   118.458     0.200
    10.002   140.427     0.200
    10.128   145.053     0.200
     1.719    34.725     0.200
     3.947    62.716     0.200
     8.590   119.586     0.200
     1.560    32.261     0.200
     3.927    63.139     0.200
     8.569   120.467     0.200
     8.569   119.737     0.200
     1.549    32.862     0.200
     2.293    43.108     0.200
     2.293    42.444     0.200
     2.293    46.420     0.200
     3.910    64.413     0.200
     1.344    29.787     0.200
     1.493    31.029     0.200
     1.719    33.500     0.200
     1.719    33.742     0.200
     1.522    31.001     0.200
     1.620    32.250     0.200
     1.676    33.772     0.200
     1.899    35.912     0.200
     1.919    36.712     0.200
     2.117    40.170     0.200
     3.433    55.831     0.200
     1.371    29.284     0.200
     1.453    28.817     0.200
     1.458    29.678     0.200
     1.752    34.591     0.200
     1.855    35.027     0.200
     1.709    35.085     0.200
     2.612    45.658     0.200
     3.203    53.300     0.200
     3.876    63.020     0.200
     3.876    63.340     0.200
     4.571    70.480     0.200
     5.095    75.220     0.200
     1.530    30.484     0.200
     1.577    31.883     0.200
     1.817    34.561     0.200
     1.806    34.329     0.200
     2.021    39.264     0.200
     3.156    50.549     0.200
     3.898    60.836     0.200
     4.527    70.008     0.200
     1.338    28.394     0.200
     1.785    35.518     0.200
     2.912    46.375     0.200
     3.189    51.643     0.200
     3.881    62.377     0.200
     8.550   119.018     0.200
     1.676    34.693     0.200
     1.716    35.201     0.200
     1.764    35.642     0.200
     1.879    37.303     0.200
     2.180    42.785     0.200
     3.858    60.884     0.200
     1.609    34.326     0.200
     1.822    36.507     0.200
     1.822    36.636     0.200
     2.037    39.921     0.200
     2.127    41.956     0.200
     2.303    43.653     0.200
     2.385    43.414     0.200
     3.327    55.950     0.200
     1.675    32.397     0.200
     1.672    34.162     0.200
     1.723    34.697     0.200
     1.758    36.754     0.200
     1.831    37.651     0.200
     1.855    37.347     0.200
     1.641    33.793     0.200
     1.681    32.485     0.200
     1.714    34.258     0.200
     1.705    34.420     0.200
     1.734    35.894     0.200
     1.734    35.765     0.200
     1.808    36.820     0.200
     1.836    36.548     0.200
     1.920    37.459     0.200
     2.108    42.975     0.200
     2.169    43.501     0.200
     2.175    40.852     0.200
     2.180    40.688     0.200
     3.960    63.309     0.200
     1.677    34.998     0.200
     1.732    35.471     0.200
     1.803    38.097     0.200
     1.867    37.114     0.200
     1.872    37.631     0.200
     1.761    35.767     0.200
     1.836    36.789     0.200
     1.867    37.354     0.200
     3.981    64.769     0.200
     1.687    33.750     0.200
     1.739    35.071     0.200
     1.856    37.373     0.200
     4.008    64.901     0.200
     4.684    72.202     0.200
     7.190   101.190     0.200
     8.653   119.163     0.200
     1.786    35.641     0.200
     2.203    40.892     0.200
     3.874    62.513     0.200
     1.363    28.407     0.200
     1.363    28.544     0.200
     1.497    32.039     0.200
     1.643    32.860     0.200
     1.680    34.092     0.200
     1.680    34.412     0.200
     1.742    33.154     0.200
     1.751    34.919     0.200
     1.774    34.912     0.200
     1.748    34.696     0.200
     1.765    35.089     0.200
     1.807    35.264     0.200
     1.864    36.120     0.200
     3.225    52.711     0.200
     3.219    53.618     0.200
     3.351    53.986     0.200
     3.637    57.193     0.200
     3.849    61.727     0.200
     3.917    59.831     0.200
     4.348    68.813     0.200
     4.673    70.702     0.200
     5.167    74.643     0.200
     5.247    78.365     0.200
     5.745    82.089     0.200
     8.554   118.018     0.200
     8.578   118.213     0.200
     1.673    34.597     0.200
     1.760    36.199     0.200
     2.097    41.658     0.200
     2.097    42.946     0.200
     2.097    42.207     0.200
     2.207    41.925     0.200
     2.254    45.928     0.200
     3.856    62.915     0.200
     1.582    31.882     0.200
     1.631    32.928     0.200
     1.661    33.852     0.200
     1.661    33.434     0.200
     1.758    34.285     0.200
     1.758    34.628     0.200
     1.761    34.661     0.200
     1.753    33.689     0.200
     1.803    34.656     0.200
     3.628    56.055     0.200
     3.794    59.196     0.200
     3.898    60.088     0.200
     4.399    65.814     0.200
     1.632    32.637     0.200
     1.678    33.399     0.200
     1.761    33.552     0.200
     1.776    33.300     0.200
     1.776    33.120     0.200
     1.763    34.535     0.200
     1.821    34.146     0.200
     3.001    47.613     0.200
     3.231    51.817     0.200
     3.366    52.198     0.200
     3.390    54.787     0.200
     3.650    55.990     0.200
     3.817    59.095     0.200
     3.817    60.349     0.200
     3.918    59.800     0.200
     4.057    61.036     0.200
     4.409    65.566     0.200
     4.686    69.198     0.200
     1.593    33.264     0.200
     1.593    32.693     0.200
     1.665    34.480     0.200
     1.711    34.293     0.200
     1.711    34.051     0.200
     1.791    35.667     0.200
     2.045    39.022     0.200
     3.014    49.367     0.200
     3.308    54.271     0.200
     3.360    53.776     0.200
     3.732    59.177     0.200
     3.778    61.227     0.200
     4.636    70.307     0.200
     5.163    78.047     0.200
     1.182    26.638     0.200
     1.597    32.332     0.200
     1.667    33.283     0.200
     1.727    33.588     0.200
     1.806    35.405     0.200
     3.190    52.481     0.200
     3.325    53.349     0.200
     3.743    58.599     0.200
     4.652    70.014     0.200
     1.267    27.383     0.200
     1.767    37.258     0.200
     1.758    36.446     0.200
     1.846    38.296     0.200
     1.933    38.883     0.200
     2.179    43.991     0.200
     2.921    49.395     0.200
     3.474    57.997     0.200
     3.838    60.926     0.200
     1.492    29.630     0.200
     1.614    31.319     0.200
     1.614    30.799     0.200
     1.664    32.032     0.200
     1.777    33.433     0.200
     1.795    34.997     0.200
     1.808    34.061     0.200
     1.880    34.954     0.200
     1.889    36.768     0.200
     2.772    45.976     0.200
     3.229    52.317     0.200
     3.229    51.587     0.200
     3.323    52.596     0.200
     3.323    52.454     0.200
     3.344    52.769     0.200
     3.421    54.585     0.200
     3.833    58.826     0.200
     3.867    60.116     0.200
     4.170    64.841     0.200
     4.383    65.056     0.200
     4.691    71.116     0.200
     4.680    69.041     0.200
     5.301    78.026     0.200
     5.332    77.969     0.200
     5.568    78.866     0.200
     6.153    88.387     0.200
     7.022    97.755     0.200
     1.403    29.688     0.200
     1.794    35.942     0.200
     1.784    35.536     0.200
     1.784    35.802     0.200
     1.796    36.523     0.200
     1.837    37.240     0.200
     1.917    37.347     0.200
     2.184    41.147     0.200
     2.170    42.680     0.200
     4.713    74.474     0.200
     5.299    81.818     0.200
     1.608    31.890     0.200
     1.666    32.183     0.200
     1.692    34.528     0.200
     1.692    33.547     0.200
     1.735    33.975     0.200
     1.735    33.775     0.200
     1.763    35.008     0.200
     1.765    33.627     0.200
     1.765    33.487     0.200
     1.788    34.777     0.200
     1.801    34.165     0.200
     1.876    35.537     0.200
     3.218    51.216     0.200
     3.218    52.796     0.200
     3.238    51.506     0.200
     3.317    52.682     0.200
     3.317    52.808     0.200
     3.341    51.906     0.200
     3.341    52.696     0.200
     3.416    54.707     0.200
     3.635    55.969     0.200
     3.819    59.077     0.200
     3.819    60.332     0.200
     3.926    60.025     0.200
     3.926    60.867     0.200
     4.165    64.678     0.200
     4.330    65.976     0.200
     4.383    65.187     0.200
     4.670    69.166     0.200
     4.676    71.214     0.200
     4.676    71.576     0.200
     5.287    78.756     0.200
     5.318    78.681     0.200
     6.110    86.517     0.200
     1.763    36.307     0.200
     1.751    35.188     0.200
     1.874    38.771     0.200
     1.894    36.987     0.200
     2.074    44.167     0.200
     2.074    42.294     0.200
     2.079    41.659     0.200
     2.079    41.491     0.200
     2.128    40.525     0.200
     2.128    42.201     0.200
     2.128    42.076     0.200
     2.219    44.863     0.200
     2.219    44.187     0.200
     3.268    55.293     0.200
     3.786    63.511     0.200
     4.459    68.265     0.200
     4.973    79.944     0.200
     5.018    80.268     0.200
     5.029    80.485     0.200
     5.265    82.678     0.200
     5.826    88.805     0.200
     5.878    89.691     0.200
     6.460    97.683     0.200
     6.533    98.278     0.200
     1.614    32.896     0.200
     1.614    32.266     0.200
     1.685    33.733     0.200
     1.721    34.014     0.200
     1.732    34.106     0.200
     1.732    33.985     0.200
     1.803    35.360     0.200
     1.824    35.511     0.200
     2.054    38.996     0.200
     2.595    44.572     0.200
     2.972    48.715     0.200
     3.192    52.268     0.200
     3.192    51.558     0.200
     3.320    53.600     0.200
     3.320    54.055     0.200
     3.358    54.752     0.200
     3.755    58.429     0.200
     3.854    59.477     0.200
     4.616    70.053     0.200
     5.224    78.159     0.200
     5.244    78.639     0.200
     6.040    87.085     0.200
     6.081    87.868     0.200
     7.122   100.131     0.200
     1.605    34.404     0.200
     1.664    35.108     0.200
     1.814    36.695     0.200
     1.814    37.269     0.200
     2.272    46.938     0.200
     2.272    46.360     0.200
     3.422    56.938     0.200
     3.796    62.057     0.200
     3.859    64.501     0.200
     3.872    63.344     0.200
     3.981    64.297     0.200
     4.521    70.086     0.200
     4.662    73.509     0.200
     5.212    81.982     0.200
     5.257    83.346     0.200
     5.266    83.628     0.200
     6.064    90.722     0.200
     6.771   100.618     0.200
     7.167   104.165     0.200
     1.285    28.012     0.200
     1.760    35.667     0.200
     1.758    36.141     0.200
     1.758    36.258     0.200
     1.824    36.959     0.200
     1.861    38.582     0.200
     2.195    44.059     0.200
     2.195    43.661     0.200
     2.718    48.046     0.200
     2.908    49.373     0.200
     3.284    55.282     0.200
     3.845    63.274     0.200
     4.699    74.192     0.200
     5.312    83.825     0.200
     5.362    84.869     0.200
     6.147    90.883     0.200
     1.420    28.625     0.200
     1.519    30.375     0.200
     1.521    30.089     0.200
     1.701    33.138     0.200
     1.738    33.441     0.200
     1.754    34.010     0.200
     1.864    36.453     0.200
     1.871    35.608     0.200
     1.893    36.140     0.200
     1.929    35.511     0.200
     1.986    38.985     0.200
     1.986    38.095     0.200
     1.989    38.119     0.200
     2.084    39.343     0.200
     2.138    38.700     0.200
     4.181    64.929     0.200
     1.272    27.827     0.200
     1.408    32.737     0.200
     1.744    37.402     0.200
     1.744    36.074     0.200
     1.912    39.022     0.200
     1.880    37.964     0.200
     2.224    46.620     0.200
     2.224    45.050     0.200
     2.282    47.312     0.200
     2.282    45.844     0.200
     2.279    45.165     0.200
     1.175    24.479     0.200
     1.526    31.079     0.200
     1.595    32.370     0.200
     1.703    33.722     0.200
     1.703    33.863     0.200
     1.762    34.635     0.200
     1.817    35.552     0.200
     1.817    35.251     0.200
     1.861    35.326     0.200
     1.975    40.047     0.200
     3.069    49.788     0.200
     3.289    54.141     0.200
     3.327    54.024     0.200
     3.601    58.221     0.200
     3.688    59.758     0.200
     3.775    60.721     0.200
     3.981    62.240     0.200
     4.035    63.967     0.200
     4.472    66.957     0.200
     5.111    78.659     0.200
     5.964    85.904     0.200
     1.611    30.979     0.200
     1.815    34.580     0.200
     1.864    35.193     0.200
     2.005    37.724     0.200
     2.114    38.623     0.200
     2.891    48.317     0.200
     3.038    50.378     0.200
     3.292    53.357     0.200
     3.556    57.087     0.200
     3.937    62.827     0.200
     1.735    34.857     0.200
     1.786    36.960     0.200
     1.802    35.662     0.200
     1.905    37.138     0.200
     2.158    43.247     0.200
     2.197    41.003     0.200
     3.448    56.983     0.200
     3.854    62.277     0.200
     1.216    25.010     0.200
     1.326    26.537     0.200
     1.389    27.725     0.200
     1.392    27.734     0.200
     1.811    34.914     0.200
     1.817    34.679     0.200
     1.861    35.572     0.200
     1.861    35.874     0.200
     1.882    35.810     0.200
     1.882    37.305     0.200
     1.953    37.462     0.200
     2.008    38.350     0.200
     2.110    40.971     0.200
     1.309    26.416     0.200
     1.385    27.556     0.200
     1.806    35.195     0.200
     1.853    35.687     0.200
     1.872    37.167     0.200
     1.403    28.634     0.200
     1.567    31.699     0.200
     1.611    31.032     0.200
     1.757    33.715     0.200
     1.750    34.988     0.200
     1.811    34.544     0.200
     1.811    34.380     0.200
     1.812    34.746     0.200
     1.859    35.618     0.200
     1.859    35.229     0.200
     1.877    36.772     0.200
     1.949    38.362     0.200
     1.948    37.480     0.200
     1.968    38.776     0.200
     2.005    38.708     0.200
     2.113    40.776     0.200
     2.774    46.414     0.200
     2.885    48.375     0.200
     2.886    47.144     0.200
     2.886    47.249     0.200
     2.996    49.982     0.200
     3.037    50.256     0.200
     3.288    53.141     0.200
     3.288    54.303     0.200
     3.290    52.222     0.200
     3.555    56.674     0.200
     3.600    57.397     0.200
     3.691    58.510     0.200
     3.936    62.784     0.200
     3.973    61.563     0.200
     3.973    61.981     0.200
     3.984    62.988     0.200
     4.036    61.487     0.200
     4.099    64.430     0.200
     4.257    64.888     0.200
     4.300    65.414     0.200
     4.306    66.676     0.200
     4.468    67.663     0.200
     4.520    69.688     0.200
     4.690    70.605     0.200
     4.719    70.363     0.200
     4.745    71.577     0.200
     4.806    73.332     0.200
     4.823    73.576     0.200
     4.823    74.174     0.200
     1.765    36.286     0.200
     1.892    37.965     0.200
     1.652    33.500     0.200
     1.694    32.445     0.200
     1.703    33.837     0.200
     1.742    35.481     0.200
     1.782    35.054     0.200
     1.782    35.224     0.200
     1.794    35.452     0.200
     1.814    37.360     0.200
     1.835    36.276     0.200
     1.916    38.202     0.200
     2.169    41.824     0.200
     2.169    40.444     0.200
     2.686    46.239     0.200
     3.459    56.324     0.200
     4.711    73.523     0.200
     1.314    29.776     0.200
     1.852    36.983     0.200
     1.913    36.476     0.200
     1.913    36.681     0.200
     1.930    37.334     0.200
     2.936    48.066     0.200
     4.811    73.270     0.200
     4.858    73.847     0.200
     5.469    80.525     0.200
     1.489    30.895     0.200
     1.484    30.773     0.200
     1.698    34.182     0.200
     1.698    33.840     0.200
     1.698    33.827     0.200
     1.789    35.506     0.200
     1.789    35.720     0.200
     1.869    35.665     0.200
     1.921    37.090     0.200
     1.985    38.094     0.200
     2.053    38.746     0.200
     2.098    42.040     0.200
     2.126    40.176     0.200
     2.338    40.829     0.200
     2.512    43.374     0.200
     2.595    44.438     0.200
     2.919    47.676     0.200
     2.919    48.790     0.200
     3.148    51.313     0.200
     3.148    52.921     0.200
     3.161    51.411     0.200
     3.161    52.046     0.200
     3.178    52.430     0.200
     3.199    51.640     0.200
     3.201    52.175     0.200
     3.357    54.766     0.200
     3.637    57.656     0.200
     3.637    58.373     0.200
     3.673    59.178     0.200
     3.940    61.703     0.200
     3.952    62.233     0.200
     3.952    62.861     0.200
     4.106    63.995     0.200
     4.106    65.546     0.200
     4.169    62.784     0.200
     4.300    65.416     0.200
     4.423    68.861     0.200
     4.586    71.862     0.200
     4.622    68.531     0.200
     4.622    71.803     0.200
     4.794    71.963     0.200
     4.794    74.974     0.200
     4.813    74.696     0.200
     4.864    74.635     0.200
     4.917    74.771     0.200
     5.414    78.437     0.200
     5.505    81.121     0.200
     6.276    89.572     0.200
     1.739    34.983     0.200
     1.832    36.490     0.200
     1.837    35.694     0.200
     1.313    27.783     0.200
     1.307    28.091     0.200
     1.307    27.189     0.200
     1.375    29.433     0.200
     1.369    28.933     0.200
     1.417    29.580     0.200
     1.552    30.847     0.200
     1.795    33.913     0.200
     1.803    34.668     0.200
     1.855    35.528     0.200
     1.872    35.895     0.200
     1.951    36.157     0.200
     1.988    37.459     0.200
     2.257    39.062     0.200
     2.471    42.918     0.200
     2.662    43.831     0.200
     2.831    46.555     0.200
     3.082    50.893     0.200
     3.155    51.683     0.200
     3.421    55.393     0.200
     3.701    56.717     0.200
     3.932    61.290     0.200
     4.230    63.322     0.200
     4.217    65.320     0.200
     4.312    66.038     0.200
     5.396    79.468     0.200
     5.470    80.000     0.200
     1.607    34.037     0.200
     1.751    36.141     0.200
     1.751    36.571     0.200
     1.865    36.907     0.200
     1.961    38.234     0.200
     2.116    43.927     0.200
     2.116    44.286     0.200
     2.117    43.832     0.200
     2.117    44.379     0.200
     2.141    44.361     0.200
     2.141    44.533     0.200
     2.260    46.716     0.200
     1.310    27.422     0.200
     1.298    26.989     0.200
     1.400    28.733     0.200
     1.472    29.472     0.200
     1.618    31.547     0.200
     1.710    34.759     0.200
     1.710    34.470     0.200
     1.778    35.929     0.200
     1.778    36.167     0.200
     1.824    36.111     0.200
     1.875    37.044     0.200
     1.879    37.722     0.200
     1.959    39.459     0.200
     2.007    40.645     0.200
     2.024    38.220     0.200
     2.083    39.966     0.200
     2.229    44.724     0.200
     2.229    44.157     0.200
     2.232    42.117     0.200
     2.232    44.726     0.200
     2.232    41.640     0.200
     2.465    43.413     0.200
     2.819    47.684     0.200
     2.853    49.267     0.200
     3.102    52.353     0.200
     3.197    53.039     0.200
     3.629    59.252     0.200
     3.625    58.815     0.200
     3.925    63.292     0.200
     4.071    65.960     0.200
     4.379    68.544     0.200
     4.769    75.681     0.200
     5.385    84.750     0.200
     5.388    82.901     0.200
     5.469    84.471     0.200
     5.970    88.083     0.200
     7.275   104.329     0.200
     9.359   131.878     0.200
     1.932    39.530     0.200
     3.171    52.534     0.200
     1.178    24.749     0.200
     1.178    25.022     0.200
     1.338    27.902     0.200
     1.318    28.518     0.200
     1.318    25.854     0.200
     1.634    33.063     0.200
     1.697    32.800     0.200
     1.758    34.505     0.200
     1.758    34.365     0.200
     1.820    35.208     0.200
     1.824    35.622     0.200
     1.824    35.145     0.200
     2.058    39.817     0.200
     2.058    41.020     0.200
     2.099    38.694     0.200
     2.159    37.468     0.200
     2.412    40.375     0.200
     3.218    52.711     0.200
     3.341    53.992     0.200
     3.381    53.162     0.200
     3.782    60.046     0.200
     4.105    64.374     0.200
     4.270    66.227     0.200
     4.509    70.032     0.200
     4.431    67.063     0.200
     4.550    70.131     0.200
     4.587    71.412     0.200
     1.190    25.338     0.200
     1.190    25.096     0.200
     1.621    33.115     0.200
     1.738    34.678     0.200
     1.807    35.385     0.200
     1.825    35.697     0.200
     2.058    40.667     0.200
     3.360    55.246     0.200
     3.763    60.760     0.200
     1.338    26.601     0.200
     1.632    30.874     0.200
     1.947    35.696     0.200
     1.434    29.022     0.200
     1.604    33.476     0.200
     1.667    32.567     0.200
     1.265    26.579     0.200
     1.796    35.489     0.200
     3.030    51.013     0.200
     3.812    61.149     0.200
     3.920    61.743     0.200
     1.584    30.243     0.200
     1.742    33.742     0.200
     1.785    34.816     0.200
     1.819    34.489     0.200
     1.838    35.241     0.200
     1.915    36.046     0.200
     1.951    36.265     0.200
     2.697    44.511     0.200
     3.131    51.182     0.200
     3.214    52.461     0.200
     3.236    52.986     0.200
     3.908    60.596     0.200
     4.043    62.532     0.200
     4.757    72.487     0.200
     5.373    79.385     0.200
     5.440    80.961     0.200
     6.219    88.837     0.200
     1.660    32.832     0.200
     1.688    32.644     0.200
     1.754    35.135     0.200
     3.894    63.219     0.200
     5.113    77.615     0.200
     8.633   118.042     0.200
     8.633   119.183     0.200
     1.665    32.972     0.200
     1.681    33.062     0.200
     1.740    33.999     0.200
     1.748    35.381     0.200
     1.808    35.199     0.200
     1.847    35.884     0.200
     1.934    36.936     0.200
     1.929    37.237     0.200
     2.181    43.621     0.200
     2.799    47.061     0.200
     3.973    62.474     0.200
     8.621   121.379     0.200
     1.280    27.816     0.200
     1.257    27.151     0.200
     1.257    27.431     0.200
     1.280    27.937     0.200
     1.907    37.015     0.200
     2.168    40.288     0.200
     2.168    44.478     0.200
     3.769    59.784     0.200
     5.340    78.826     0.200
     1.256    25.240     0.200
     1.395    27.937     0.200
     1.397    28.146     0.200
     1.381    27.354     0.200
     1.532    29.288     0.200
     1.533    27.950     0.200
     1.656    30.584     0.200
     1.845    33.547     0.200
     1.901    34.478     0.200
     1.439    31.352     0.200
     2.118    39.420     0.200
     2.100    40.333     0.200
     2.127    40.120     0.200
     1.266    27.498     0.200
     1.254    27.201     0.200
     1.662    34.669     0.200
     1.698    34.996     0.200
     1.879    35.946     0.200
     1.987    39.142     0.200
     1.985    39.056     0.200
     2.236    43.197     0.200
     3.021    50.514     0.200
     1.586    33.792     0.200
     1.676    33.448     0.200
     3.639    58.737     0.200
     3.803    61.380     0.200
     3.837    62.201     0.200
     4.603    71.662     0.200
     4.678    71.969     0.200
     1.826    36.167     0.200
     2.020    38.928     0.200
     4.673    71.799     0.200
     1.319    27.035     0.200
     1.438    29.062     0.200
     1.438    28.921     0.200
     1.431    28.868     0.200
     1.507    29.650     0.200
     1.664    31.438     0.200
     1.779    33.918     0.200
     1.779    33.883     0.200
     1.886    37.270     0.200
     1.160    24.140     0.200
     1.160    22.558     0.200
     1.208    25.091     0.200
     1.281    25.181     0.200
     1.307    25.903     0.200
     1.317    26.345     0.200
     1.516    27.795     0.200
     1.414    26.844     0.200
     1.468    28.427     0.200
     1.466    29.237     0.200
     1.466    27.659     0.200
     1.502    28.796     0.200
     1.529    29.202     0.200
     1.589    30.373     0.200
     1.693    31.655     0.200
     1.706    32.310     0.200
     1.717    33.802     0.200
     1.717    30.841     0.200
     1.705    32.447     0.200
     2.003    33.202     0.200
     2.574    41.434     0.200
     4.885    71.172     0.200
     1.379    29.867     0.200
     1.715    35.517     0.200
     1.815    36.650     0.200
     1.910    36.667     0.200
     2.149    43.271     0.200
     2.335    42.088     0.200
     3.443    57.619     0.200
     3.862    63.856     0.200
     3.944    64.278     0.200
     1.407    29.123     0.200
     1.748    34.192     0.200
     1.799    35.625     0.200
     1.799    35.945     0.200
     1.798    34.649     0.200
     1.928    37.591     0.200
     2.014    37.359     0.200
     2.262    37.990     0.200
     2.716    43.338     0.200
     4.003    62.650     0.200
     4.798    69.394     0.200
     1.405    29.225     0.200
     1.593    31.350     0.200
     1.751    34.568     0.200
     1.801    35.964     0.200
     1.800    34.940     0.200
     1.931    38.314     0.200
     1.931    36.150     0.200
     2.021    38.122     0.200
     2.265    39.550     0.200
     2.252    38.863     0.200
     2.713    43.344     0.200
     4.002    62.309     0.200
     4.242    66.536     0.200
     4.797    72.678     0.200
     1.756    34.346     0.200
     1.876    38.523     0.200
     1.885    36.991     0.200
     1.925    38.413     0.200
     2.110    41.004     0.200
     1.932    39.445     0.200
     1.932    38.945     0.200
     1.975    39.085     0.200
     2.145    45.132     0.200
     1.675    35.201     0.200
     1.730    36.307     0.200
     1.747    37.406     0.200
     1.946    40.261     0.200
     2.055    39.423     0.200
     2.058    39.683     0.200
     1.302    29.295     0.200
     1.808    36.295     0.200
     2.178    41.008     0.200
     1.382    30.460     0.200
     1.682    34.748     0.200
     1.934    37.434     0.200
     1.891    38.711     0.200
     2.058    39.832     0.200
     1.819    37.865     0.200
     1.918    37.841     0.200
     2.031    42.489     0.200
     1.545    33.542     0.200
     1.877    38.646     0.200
     1.922    39.234     0.200
     1.837    36.497     0.200
     1.988    39.850     0.200
     2.103    41.566     0.200
     2.128    41.344     0.200
     3.180    54.279     0.200
     3.781    63.525     0.200
     1.357    29.850     0.200
     1.557    33.113     0.200
     1.839    36.815     0.200
     1.932    38.866     0.200
     1.328    29.663     0.200
     2.129    41.465     0.200
     1.406    30.832     0.200
     1.674    34.785     0.200
     1.689    35.174     0.200
     1.762    37.577     0.200
     1.917    38.228     0.200
     1.554    32.306     0.200
     1.824    35.807     0.200
     1.888    38.007     0.200
     1.932    38.703     0.200
     2.001    38.506     0.200
     2.114    40.730     0.200
     2.127    40.125     0.200
     1.659    34.735     0.200
     1.715    35.370     0.200
     1.733    35.754     0.200
     1.931    39.541     0.200
     2.087    40.174     0.200
     2.336    41.643     0.200
     2.481    44.621     0.200
     2.887    50.623     0.200
     2.932    51.319     0.200
     1.478    31.770     0.200
     1.823    36.580     0.200
     1.844    38.901     0.200
     1.993    39.011     0.200
     1.913    39.685     0.200
     2.095    40.972     0.200
     2.023    38.688     0.200
     2.177    41.707     0.200
     1.924    38.410     0.200
     1.928    38.374     0.200
     2.119    43.410     0.200
     2.121    39.912     0.200
     2.106    40.463     0.200
     2.181    41.413     0.200
     2.276    44.652     0.200
     1.737    36.521     0.200
     1.874    36.791     0.200
     2.111    41.109     0.200
     2.083    42.244     0.200
     3.226    55.194     0.200
     1.427    31.276     0.200
     1.746    35.707     0.200
     1.934    38.936     0.200
     1.892    37.343     0.200
     1.923    38.301     0.200
     2.032    38.995     0.200
     2.024    43.227     0.200
     2.131    43.764     0.200
     2.480    44.825     0.200
     1.365    30.355     0.200
     1.664    35.125     0.200
     1.869    37.233     0.200
     1.960    39.443     0.200
     2.109    39.094     0.200
     2.082    40.776     0.200
     1.249    28.339     0.200
     1.845    37.912     0.200
     2.081    40.288     0.200
     2.111    42.141     0.200
     1.699    35.383     0.200
     1.757    36.511     0.200
     1.876    36.422     0.200
     2.045    39.685     0.200
     2.155    42.142     0.200
     2.170    41.749     0.200
     2.228    43.347     0.200
     1.852    38.844     0.200
     2.014    39.063     0.200
     2.077    39.403     0.200
     2.122    41.447     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    12.246   238.162     0.200
     5.192   103.099     0.200
     5.809   115.397     0.200
     7.150   146.248     0.200
     8.638   167.884     0.200
     8.600   169.948     0.200
     3.926    76.932     0.200
     4.997    96.433     0.200
     3.997    75.517     0.200
     4.708    89.424     0.200
     5.677   110.721     0.200
     8.650   165.254     0.200
     3.721    72.786     0.200
     3.972    75.526     0.200
     4.729    91.089     0.200
     5.699   109.567     0.200
     3.962    76.683     0.200
     4.736    92.150     0.200
     5.707   111.719     0.200
     6.055   132.622     0.200
     4.842    94.253     0.200
     5.274   104.175     0.200
     5.224   103.631     0.200
     5.218   103.038     0.200
     8.547   170.564     0.200
     3.175    60.499     0.200
     5.106    98.737     0.200
     5.802   115.944     0.200
     6.153   124.347     0.200
     4.088    84.127     0.200
     5.012    97.620     0.200
     3.908    78.986     0.200
     5.092    98.779     0.200
     5.783   116.090     0.200
     8.550   171.147     0.200
    10.004   195.753     0.200
    12.086   240.265     0.200
     2.530    49.339     0.200
     3.994    80.057     0.200
     5.303   102.336     0.200
     8.691   172.401     0.200
     3.898    72.505     0.200
     5.224   102.823     0.200
     5.224   101.593     0.200
     5.698   109.441     0.200
     8.573   167.495     0.200
    12.206   239.244     0.200
     3.855    74.436     0.200
     3.941    76.858     0.200
     5.085    99.218     0.200
     5.085    99.593     0.200
     5.809   114.264     0.200
     8.412   165.214     0.200
     8.582   169.190     0.200
     9.907   200.960     0.200
    12.095   234.998     0.200
    12.095   235.975     0.200
    12.100   235.343     0.200
     3.957    76.410     0.200
     5.091    99.739     0.200
     5.816   113.950     0.200
     7.635   149.429     0.200
     8.423   162.520     0.200
     8.601   169.654     0.200
     8.601   171.005     0.200
     9.909   200.938     0.200
    10.128   201.780     0.200
    10.128   203.038     0.200
    12.111   234.534     0.200
    12.111   236.784     0.200
    12.116   235.879     0.200
    12.359   247.939     0.200
    13.736   270.874     0.200
    14.909   291.242     0.200
    15.662   306.018     0.200
    15.814   318.589     0.200
     3.947    78.833     0.200
     5.091    99.044     0.200
     5.091    98.411     0.200
     5.809   119.269     0.200
     8.590   169.688     0.200
    12.106   234.688     0.200
    12.110   240.384     0.200
     3.927    77.709     0.200
     5.090    99.483     0.200
     5.090    98.819     0.200
     5.796   116.674     0.200
     7.650   148.258     0.200
     8.414   163.468     0.200
     8.569   167.065     0.200
    12.092   235.895     0.200
    12.096   238.395     0.200
     3.910    78.147     0.200
     5.106    99.569     0.200
     8.426   163.523     0.200
     5.220   101.575     0.200
     3.945    79.721     0.200
     5.087    98.478     0.200
     5.087   100.626     0.200
     3.946    76.931     0.200
     5.140    98.889     0.200
     2.534    49.535     0.200
     5.289   102.860     0.200
     4.651    91.988     0.200
     5.186   100.714     0.200
     3.941    74.237     0.200
     4.663    91.500     0.200
     5.236   100.888     0.200
     2.912    55.205     0.200
     3.881    79.886     0.200
     5.201   102.047     0.200
     5.700   118.480     0.200
     5.700   108.379     0.200
     6.223   134.696     0.200
     8.518   167.684     0.200
     8.550   167.089     0.200
    12.173   238.947     0.200
     2.762    53.375     0.200
     5.022    98.620     0.200
     5.233   102.517     0.200
     2.792    52.961     0.200
     5.100   100.625     0.200
     5.227   101.778     0.200
     2.537    49.945     0.200
     5.113    99.166     0.200
     5.085   100.294     0.200
     5.627   111.500     0.200
     2.778    53.164     0.200
     3.652    71.175     0.200
     4.684    92.362     0.200
     5.091   100.007     0.200
     5.318   105.367     0.200
     5.851   114.866     0.200
    12.148   238.903     0.200
     2.697    54.929     0.200
     3.304    64.705     0.200
     2.755    54.858     0.200
     2.871    54.917     0.200
     3.219    64.778     0.200
     3.351    65.627     0.200
     3.637    72.060     0.200
     4.673    92.323     0.200
     5.167    98.170     0.200
     5.669   111.267     0.200
     5.745   114.393     0.200
     8.491   163.629     0.200
     8.554   165.819     0.200
     8.578   165.432     0.200
     9.123   180.637     0.200
     9.416   188.073     0.200
    12.163   235.696     0.200
     2.501    49.724     0.200
     2.501    49.992     0.200
     2.627    53.366     0.200
     2.766    53.370     0.200
     2.834    56.244     0.200
     2.834    55.085     0.200
     2.939    59.689     0.200
     3.056    61.051     0.200
     3.111    61.424     0.200
     3.183    61.388     0.200
     3.716    73.995     0.200
     4.050    79.338     0.200
     4.764    92.462     0.200
     5.026    97.505     0.200
     2.740    54.555     0.200
     2.992    57.574     0.200
     3.012    59.996     0.200
     3.090    60.982     0.200
     3.353    65.140     0.200
     3.794    75.594     0.200
     4.041    77.872     0.200
     4.330    83.994     0.200
     4.399    85.353     0.200
     5.175   101.928     0.200
     5.524   108.538     0.200
     2.763    54.091     0.200
     2.763    53.724     0.200
     2.794    53.552     0.200
     2.796    53.171     0.200
     2.859    54.961     0.200
     3.001    57.347     0.200
     3.034    59.635     0.200
     3.034    58.705     0.200
     3.208    61.245     0.200
     3.366    65.010     0.200
     3.817    75.157     0.200
     4.352    85.801     0.200
     5.181   101.037     0.200
     5.542   108.257     0.200
     2.686    54.449     0.200
     2.723    53.510     0.200
     2.949    59.671     0.200
     3.023    60.709     0.200
     3.732    74.513     0.200
     3.778    76.203     0.200
     2.699    54.405     0.200
     2.937    55.112     0.200
     2.960    59.376     0.200
     3.025    60.240     0.200
     3.027    59.097     0.200
     3.743    74.248     0.200
     3.791    76.155     0.200
     3.977    78.047     0.200
     4.275    84.771     0.200
     4.433    85.120     0.200
     5.216   103.496     0.200
     5.461   106.712     0.200
     6.076   118.786     0.200
     2.719    53.159     0.200
     2.799    54.407     0.200
     2.869    57.409     0.200
     2.921    58.777     0.200
     2.943    56.815     0.200
     3.058    62.371     0.200
     3.058    60.692     0.200
     3.295    64.821     0.200
     3.295    64.562     0.200
     3.838    77.926     0.200
     4.331    83.997     0.200
     5.099    99.077     0.200
     2.764    52.379     0.200
     2.974    57.736     0.200
     3.051    59.380     0.200
     3.134    60.398     0.200
     3.134    61.260     0.200
     3.709    69.508     0.200
     3.833    74.125     0.200
     3.870    76.392     0.200
     4.085    78.660     0.200
     4.371    87.871     0.200
     4.371    83.301     0.200
     4.383    85.045     0.200
     4.870    93.583     0.200
     5.152    99.933     0.200
     5.568   109.116     0.200
     6.763   131.598     0.200
     2.555    49.130     0.200
     2.544    50.678     0.200
     2.942    57.985     0.200
     3.309    64.698     0.200
     3.318    63.693     0.200
     3.835    73.783     0.200
     4.352    83.388     0.200
     4.676    91.977     0.200
     4.713    94.045     0.200
     2.815    54.369     0.200
     2.975    57.646     0.200
     2.975    57.494     0.200
     3.037    60.299     0.200
     3.121    61.486     0.200
     3.218    64.706     0.200
     3.317    65.442     0.200
     3.819    74.787     0.200
     4.072    79.451     0.200
     4.383    86.087     0.200
     4.670    91.956     0.200
     4.676    92.356     0.200
     4.875    94.253     0.200
     5.155    99.526     0.200
     5.554   108.984     0.200
     6.138   118.745     0.200
     6.168   121.415     0.200
     2.524    50.826     0.200
     2.764    55.957     0.200
     2.825    54.012     0.200
     3.046    57.701     0.200
     3.061    60.932     0.200
     3.064    60.237     0.200
     3.369    65.258     0.200
     3.496    68.617     0.200
     3.548    71.138     0.200
     3.610    72.865     0.200
     3.989    78.903     0.200
     4.413    88.302     0.200
     4.459    86.806     0.200
     5.029    98.411     0.200
     5.271   102.879     0.200
     5.376   107.271     0.200
     5.610   112.078     0.200
     5.882   117.290     0.200
     5.970   114.542     0.200
     2.708    54.609     0.200
     2.921    57.018     0.200
     2.972    58.615     0.200
     2.972    59.175     0.200
     3.015    58.536     0.200
     3.015    58.975     0.200
     3.043    59.984     0.200
     3.043    60.170     0.200
     3.320    64.164     0.200
     3.755    74.349     0.200
     3.920    76.714     0.200
     3.994    78.460     0.200
     4.421    84.218     0.200
     4.616    92.153     0.200
     4.931    97.176     0.200
     5.478   107.425     0.200
     6.040   119.155     0.200
     6.081   119.899     0.200
     6.092   120.070     0.200
     2.771    56.672     0.200
     2.771    56.230     0.200
     3.011    61.752     0.200
     3.272    62.895     0.200
     2.555    50.428     0.200
     2.768    55.473     0.200
     2.768    55.317     0.200
     2.908    57.263     0.200
     2.958    57.916     0.200
     3.065    61.875     0.200
     3.284    63.665     0.200
     3.284    64.228     0.200
     3.275    64.708     0.200
     3.845    77.493     0.200
     4.129    81.379     0.200
     4.318    83.755     0.200
     4.699    93.262     0.200
     4.802    93.335     0.200
     2.573    50.806     0.200
     2.576    49.000     0.200
     2.770    53.576     0.200
     2.916    57.243     0.200
     3.192    61.023     0.200
     3.256    63.440     0.200
     3.252    62.888     0.200
     4.185    80.043     0.200
     4.873    95.661     0.200
     5.492   105.825     0.200
     2.681    54.492     0.200
     2.908    58.936     0.200
     3.217    64.799     0.200
     3.693    74.532     0.200
     4.562    90.760     0.200
     5.164   100.569     0.200
     6.034   118.515     0.200
     2.650    52.237     0.200
     2.658    53.161     0.200
     2.658    53.005     0.200
     2.758    52.990     0.200
     2.904    57.595     0.200
     2.904    57.942     0.200
     2.954    58.073     0.200
     3.036    58.591     0.200
     3.172    62.592     0.200
     3.172    62.303     0.200
     3.404    66.609     0.200
     3.906    75.513     0.200
     2.595    49.410     0.200
     2.680    52.328     0.200
     2.888    55.868     0.200
     3.030    58.154     0.200
     3.292    62.654     0.200
     3.322    63.749     0.200
     3.547    67.899     0.200
     2.733    53.168     0.200
     2.788    54.358     0.200
     2.954    58.074     0.200
     3.073    60.779     0.200
     3.317    64.540     0.200
     3.329    64.280     0.200
     2.509    50.987     0.200
     2.545    51.664     0.200
     2.598    49.495     0.200
     2.676    52.573     0.200
     2.711    52.000     0.200
     3.031    57.952     0.200
     3.194    62.412     0.200
     3.288    65.762     0.200
     3.290    63.423     0.200
     3.290    62.917     0.200
     3.307    64.645     0.200
     3.318    64.310     0.200
     3.318    64.040     0.200
     3.691    72.383     0.200
     3.765    74.256     0.200
     3.984    79.507     0.200
     4.300    82.539     0.200
     4.530    83.889     0.200
     4.719    92.535     0.200
     4.823    95.547     0.200
     2.687    52.191     0.200
     2.930    56.765     0.200
     2.943    57.695     0.200
     2.943    58.068     0.200
     3.075    61.588     0.200
     3.319    63.815     0.200
     4.711    92.743     0.200
     2.999    59.561     0.200
     3.403    66.196     0.200
     3.424    66.759     0.200
     2.756    54.355     0.200
     2.838    55.735     0.200
     3.161    61.731     0.200
     3.201    62.874     0.200
     3.201    62.228     0.200
     3.952    78.143     0.200
     4.106    82.014     0.200
     4.169    81.364     0.200
     4.230    81.443     0.200
     4.217    83.637     0.200
     2.555    52.415     0.200
     2.602    53.613     0.200
     2.738    52.208     0.200
     2.802    57.164     0.200
     2.802    57.680     0.200
     3.079    61.434     0.200
     3.359    64.876     0.200
     4.450    90.292     0.200
     2.641    50.379     0.200
     2.791    54.991     0.200
     3.197    63.832     0.200
     3.189    61.326     0.200
     3.216    63.417     0.200
     3.216    63.038     0.200
     3.597    68.584     0.200
     3.676    71.029     0.200
     4.769    96.521     0.200
     5.970   120.008     0.200
     2.668    52.122     0.200
     2.962    58.772     0.200
     3.277    64.695     0.200
     4.618    92.570     0.200
     2.751    52.860     0.200
     2.736    53.349     0.200
     2.668    51.672     0.200
     2.823    54.449     0.200
     3.024    58.264     0.200
     2.715    53.663     0.200
     2.744    53.831     0.200
     2.980    59.106     0.200
     3.015    59.077     0.200
     3.368    65.315     0.200
     2.844    54.256     0.200
     4.256    81.628     0.200
     3.150    60.523     0.200
     3.188    62.472     0.200
     2.804    53.850     0.200
     5.113    99.065     0.200
     5.821   114.705     0.200
     5.105    98.233     0.200
     5.819   116.695     0.200
     3.067    59.539     0.200
     3.769    74.024     0.200
     3.774    75.731     0.200
     3.293    65.001     0.200
     3.660    72.828     0.200
     3.803    76.618     0.200
     4.603    92.381     0.200
     5.248   101.739     0.200
     5.238   100.090     0.200
     7.084   153.761     0.200
     3.944    76.778     0.200
     2.713    52.461     0.200
     2.537    49.263     0.200
     3.116    60.672     0.200
     2.517    53.532     0.200
     2.538    49.759     0.200
     2.501    48.531     0.200
     3.054    61.213     0.200
     3.251    64.092     0.200
     2.523    49.761     0.200
     2.521    50.715     0.200
     2.740    54.280     0.200
     2.884    54.965     0.200
     3.079    60.389     0.200
     2.501    48.804     0.200
     2.543    50.421     0.200
     2.600    52.984     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.235    24.654     0.200
     2.284    43.411     0.200
     2.332    41.477     0.200
     1.087    24.063     0.200
     1.757    33.674     0.200
     1.773    33.036     0.200
     1.845    34.210     0.200
     2.574    43.320     0.200
     1.293    24.900     0.200
     2.437    44.013     0.200
     2.550    44.362     0.200
     3.489    56.475     0.200
     3.570    57.462     0.200
     0.425     9.899     0.200
     0.439     9.527     0.200
     0.709    14.713     0.200
     1.188    24.060     0.200
     1.284    25.418     0.200
     1.672    32.016     0.200
     0.289     6.346     0.200
     0.335     8.254     0.200
     1.213    25.463     0.200
     1.548    30.100     0.200
     1.836    34.688     0.200
     2.401    43.213     0.200
     1.367    25.232     0.200
     1.676    31.224     0.200
     2.263    39.146     0.200
     0.216     5.037     0.200
     1.095    23.485     0.200
     1.223    25.384     0.200
     2.386    43.488     0.200
     0.293     6.473     0.200
     0.357     7.331     0.200
     1.039    22.666     0.200
     1.399    28.873     0.200
     1.500    29.884     0.200
     5.195    88.609     0.200
     0.328     7.545     0.200
     0.740    17.328     0.200
     1.027    23.375     0.200
     1.219    25.785     0.200
     2.276    42.078     0.200
     2.416    45.857     0.200
     0.291     7.116     0.200
     0.360     8.797     0.200
     2.376    42.253     0.200
     0.284     7.145     0.200
     0.577    13.186     0.200
     2.373    41.942     0.200
     2.394    42.060     0.200
     1.149    24.973     0.200
     0.854    19.990     0.200
     2.523    44.006     0.200
     1.220    26.275     0.200
     1.375    28.991     0.200
     1.785    34.276     0.200
     2.296    42.933     0.200
     2.652    46.856     0.200
     1.131    23.700     0.200
     1.343    27.978     0.200
     2.278    40.900     0.200
     1.373    27.019     0.200
     1.144    24.098     0.200
     1.323    27.266     0.200
     1.557    30.380     0.200
     2.302    41.672     0.200
     2.371    42.580     0.200
     2.511    43.716     0.200
     1.235    23.231     0.200
     2.405    43.843     0.200
     0.291     6.960     0.200
     1.008    21.413     0.200
     1.257    24.900     0.200
     2.447    44.948     0.200
     0.472    10.278     0.200
     2.288    40.940     0.200
     0.435    10.849     0.200
     0.456    10.033     0.200
     1.170    23.976     0.200
     2.303    40.688     0.200
     2.303    42.751     0.200
     2.792    48.726     0.200
     0.466    10.305     0.200
     1.162    24.005     0.200
     2.298    41.790     0.200
     2.536    46.041     0.200
     1.145    22.956     0.200
     2.286    42.344     0.200
     2.286    43.305     0.200
     2.800    51.324     0.200
     0.503    10.249     0.200
     1.144    24.357     0.200
     1.187    26.493     0.200
     0.655    15.536     0.200
     1.214    26.477     0.200
     1.470    30.412     0.200
     1.589    32.552     0.200
     2.295    43.422     0.200
     2.326    43.785     0.200
     0.643    15.926     0.200
     1.203    24.259     0.200
     2.155    38.124     0.200
     2.792    48.666     0.200
     0.388     8.271     0.200
     0.648    14.798     0.200
     0.880    18.809     0.200
     0.943    19.739     0.200
     1.021    20.397     0.200
     1.231    25.361     0.200
     1.235    24.958     0.200
     1.232    26.504     0.200
     1.418    28.027     0.200
     1.626    31.935     0.200
     1.807    33.769     0.200
     2.346    42.412     0.200
     2.238    41.244     0.200
     3.140    53.940     0.200
     0.216     6.243     0.200
     0.216     5.802     0.200
     0.447    10.844     0.200
     0.481    12.647     0.200
     0.758    16.561     0.200
     0.795    17.734     0.200
     0.968    19.291     0.200
     1.066    22.902     0.200
     1.149    22.956     0.200
     1.176    23.429     0.200
     1.352    25.808     0.200
     1.389    27.233     0.200
     1.584    29.508     0.200
     2.131    42.006     0.200
     2.534    43.753     0.200
     0.374     9.291     0.200
     0.770    16.760     0.200
     0.942    20.694     0.200
     1.185    24.925     0.200
     1.245    26.529     0.200
     1.614    31.645     0.200
     1.771    34.660     0.200
     2.255    42.558     0.200
     2.356    43.428     0.200
     0.312     7.811     0.200
     0.312     7.981     0.200
     0.534    11.883     0.200
     0.831    16.936     0.200
     0.850    19.048     0.200
     0.995    20.005     0.200
     1.245    24.566     0.200
     1.245    24.406     0.200
     1.320    25.884     0.200
     1.299    26.121     0.200
     2.417    42.485     0.200
     2.417    41.695     0.200
     2.564    45.437     0.200
     4.838    84.305     0.200
     5.236    91.377     0.200
     0.250     5.969     0.200
     0.356     8.110     0.200
     0.692    16.884     0.200
     0.787    16.908     0.200
     0.787    16.626     0.200
     0.888    19.831     0.200
     0.957    20.371     0.200
     0.957    20.261     0.200
     1.202    24.310     0.200
     1.202    24.509     0.200
     1.260    26.348     0.200
     1.260    26.488     0.200
     1.570    30.388     0.200
     2.374    42.272     0.200
     0.567    11.130     0.200
     0.549    11.882     0.200
     0.549    11.773     0.200
     0.605    13.950     0.200
     0.605    13.820     0.200
     0.829    18.645     0.200
     0.996    22.169     0.200
     1.029    22.158     0.200
     1.078    23.290     0.200
     1.122    24.345     0.200
     1.379    28.418     0.200
     1.369    28.496     0.200
     1.620    32.088     0.200
     1.757    34.455     0.200
     0.291     5.855     0.200
     0.351     7.818     0.200
     0.351     8.129     0.200
     0.592    14.732     0.200
     0.734    17.506     0.200
     0.863    20.140     0.200
     0.899    17.851     0.200
     0.937    20.161     0.200
     1.066    24.362     0.200
     1.198    25.509     0.200
     1.243    26.982     0.200
     1.515    31.214     0.200
     1.547    32.058     0.200
     1.562    31.314     0.200
     1.592    33.410     0.200
     1.670    33.492     0.200
     1.660    33.333     0.200
     1.690    34.075     0.200
     1.690    34.895     0.200
     1.816    36.370     0.200
     2.379    44.709     0.200
     2.385    46.424     0.200
     0.772    17.247     0.200
     0.982    20.597     0.200
     0.997    21.063     0.200
     1.070    22.032     0.200
     1.198    25.203     0.200
     1.267    26.651     0.200
     1.284    26.109     0.200
     1.292    26.228     0.200
     2.325    41.823     0.200
     0.237     5.996     0.200
     0.325     7.993     0.200
     0.576    14.725     0.200
     0.537    11.371     0.200
     0.680    16.694     0.200
     0.791    17.653     0.200
     0.818    17.301     0.200
     0.860    19.205     0.200
     0.983    20.830     0.200
     1.065    22.098     0.200
     1.156    24.543     0.200
     1.182    22.939     0.200
     1.182    23.150     0.200
     1.232    24.814     0.200
     1.232    24.595     0.200
     1.288    26.200     0.200
     1.534    29.987     0.200
     1.583    30.439     0.200
     2.310    41.049     0.200
     2.405    42.701     0.200
     0.195     4.359     0.200
     0.412     9.567     0.200
     0.412     9.700     0.200
     0.765    16.683     0.200
     0.765    17.213     0.200
     0.909    19.872     0.200
     0.970    21.351     0.200
     0.982    21.387     0.200
     0.982    21.598     0.200
     1.190    24.747     0.200
     1.190    24.935     0.200
     1.258    26.292     0.200
     1.266    26.994     0.200
     1.278    27.637     0.200
     1.389    29.378     0.200
     1.303    26.868     0.200
     1.655    33.235     0.200
     2.326    43.584     0.200
     2.326    42.918     0.200
     2.691    47.546     0.200
     0.379     8.232     0.200
     1.058    23.319     0.200
     1.254    27.229     0.200
     1.253    27.252     0.200
     1.303    27.541     0.200
     1.352    30.080     0.200
     2.367    43.729     0.200
     0.432     8.043     0.200
     0.759    16.449     0.200
     0.938    20.102     0.200
     0.997    20.830     0.200
     0.988    21.150     0.200
     1.081    22.562     0.200
     1.185    25.700     0.200
     1.204    24.757     0.200
     1.295    26.662     0.200
     1.282    27.500     0.200
     1.403    30.047     0.200
     1.685    33.648     0.200
     1.735    34.780     0.200
     2.310    44.599     0.200
     0.161     3.757     0.200
     0.405     8.780     0.200
     0.421     9.690     0.200
     0.421     9.689     0.200
     0.685    16.778     0.200
     0.786    17.719     0.200
     0.786    17.428     0.200
     0.935    20.565     0.200
     1.018    21.925     0.200
     1.213    24.790     0.200
     1.213    25.935     0.200
     1.228    25.175     0.200
     1.271    26.747     0.200
     1.312    27.255     0.200
     1.433    29.476     0.200
     1.687    33.612     0.200
     0.425     9.126     0.200
     0.677    14.080     0.200
     0.721    15.991     0.200
     0.881    18.476     0.200
     0.910    19.655     0.200
     1.139    23.395     0.200
     1.256    25.905     0.200
     1.210    25.919     0.200
     1.613    32.235     0.200
     1.658    33.274     0.200
     1.652    33.935     0.200
     1.724    33.625     0.200
     2.304    43.135     0.200
     0.218     5.521     0.200
     0.372     8.603     0.200
     0.372     8.841     0.200
     0.494    11.127     0.200
     0.494    10.443     0.200
     0.501    11.511     0.200
     0.501    10.257     0.200
     0.629    15.819     0.200
     0.658    16.166     0.200
     0.693    14.605     0.200
     0.781    16.624     0.200
     0.852    17.250     0.200
     0.987    20.912     0.200
     0.970    20.185     0.200
     0.970    20.470     0.200
     1.048    21.055     0.200
     1.124    23.448     0.200
     1.201    23.469     0.200
     1.204    24.932     0.200
     1.211    25.636     0.200
     1.200    24.679     0.200
     1.200    24.452     0.200
     1.243    24.643     0.200
     1.271    26.153     0.200
     1.384    26.895     0.200
     1.594    31.286     0.200
     1.681    32.054     0.200
     1.887    34.921     0.200
     2.264    41.175     0.200
     2.264    41.643     0.200
     2.634    46.509     0.200
     2.871    49.698     0.200
     0.319     7.554     0.200
     0.546    11.614     0.200
     0.546    11.489     0.200
     0.568    11.600     0.200
     0.568    11.987     0.200
     0.607    13.685     0.200
     0.737    15.332     0.200
     0.737    15.104     0.200
     0.830    18.363     0.200
     1.031    21.448     0.200
     1.099    24.156     0.200
     1.122    23.204     0.200
     1.122    23.736     0.200
     1.624    32.213     0.200
     1.624    32.671     0.200
     1.612    33.273     0.200
     1.612    33.069     0.200
     1.631    33.037     0.200
     1.673    34.019     0.200
     1.712    33.298     0.200
     1.753    34.241     0.200
     0.373     8.708     0.200
     0.373     8.633     0.200
     0.492    11.007     0.200
     0.520    11.266     0.200
     0.675    14.006     0.200
     0.675    13.842     0.200
     0.775    16.844     0.200
     0.957    20.188     0.200
     0.957    20.341     0.200
     1.060    21.187     0.200
     1.111    22.815     0.200
     1.111    22.553     0.200
     1.189    24.375     0.200
     1.192    24.279     0.200
     1.259    26.095     0.200
     1.288    26.030     0.200
     1.288    25.815     0.200
     2.255    40.478     0.200
     2.255    40.767     0.200
     0.214     6.301     0.200
     0.357     8.754     0.200
     0.357     9.016     0.200
     0.509    10.552     0.200
     0.502    11.361     0.200
     0.502    11.009     0.200
     0.502    11.154     0.200
     0.688    13.633     0.200
     0.688    13.219     0.200
     0.795    16.283     0.200
     0.980    19.788     0.200
     0.980    19.475     0.200
     0.977    18.735     0.200
     1.060    20.814     0.200
     1.060    20.947     0.200
     1.130    22.016     0.200
     1.130    22.301     0.200
     1.191    23.066     0.200
     1.194    24.303     0.200
     1.214    23.705     0.200
     1.214    23.998     0.200
     1.282    25.747     0.200
     1.299    25.646     0.200
     1.299    25.478     0.200
     1.374    26.484     0.200
     2.096    39.530     0.200
     2.277    40.166     0.200
     2.277    39.991     0.200
     2.349    41.126     0.200
     0.384     8.718     0.200
     0.384     8.695     0.200
     0.490    10.395     0.200
     0.588    11.713     0.200
     0.588    12.096     0.200
     0.611    12.905     0.200
     0.757    16.155     0.200
     0.911    19.815     0.200
     0.911    19.964     0.200
     1.043    21.870     0.200
     1.105    22.391     0.200
     1.134    22.597     0.200
     1.136    22.738     0.200
     1.166    24.336     0.200
     1.166    24.727     0.200
     1.216    26.173     0.200
     1.303    27.003     0.200
     1.541    29.887     0.200
     1.586    30.504     0.200
     1.713    33.772     0.200
     2.224    41.103     0.200
     2.264    40.959     0.200
     2.686    46.839     0.200
     0.291     6.952     0.200
     0.367     8.644     0.200
     0.506    10.781     0.200
     0.583    12.064     0.200
     0.610    12.644     0.200
     0.734    17.554     0.200
     0.800    17.087     0.200
     0.926    19.436     0.200
     1.050    21.377     0.200
     1.114    21.971     0.200
     1.183    23.522     0.200
     1.300    27.143     0.200
     1.231    25.647     0.200
     1.317    26.590     0.200
     1.531    29.341     0.200
     1.577    29.755     0.200
     1.705    32.814     0.200
     2.241    40.994     0.200
     2.274    40.825     0.200
     0.456     9.465     0.200
     0.456     9.202     0.200
     0.427     9.881     0.200
     0.427     9.910     0.200
     0.452    11.107     0.200
     0.688    17.163     0.200
     0.758    15.085     0.200
     0.921    20.388     0.200
     0.976    19.705     0.200
     0.976    19.868     0.200
     0.971    21.105     0.200
     0.971    21.634     0.200
     1.058    23.261     0.200
     1.176    25.330     0.200
     1.225    25.711     0.200
     1.273    27.067     0.200
     1.272    26.519     0.200
     1.275    26.853     0.200
     1.314    26.900     0.200
     1.382    29.700     0.200
     1.382    29.573     0.200
     1.677    33.156     0.200
     1.677    33.445     0.200
     1.666    33.518     0.200
     1.715    34.250     0.200
     2.373    45.739     0.200
     2.373    45.049     0.200
     0.198     6.176     0.200
     0.377     8.426     0.200
     0.377     8.953     0.200
     0.377     9.234     0.200
     0.493    10.562     0.200
     0.477     9.978     0.200
     0.477    10.847     0.200
     0.637    14.955     0.200
     0.718    14.196     0.200
     0.718    14.036     0.200
     0.785    16.173     0.200
     0.785    16.393     0.200
     0.868    18.672     0.200
     0.931    19.953     0.200
     0.985    19.966     0.200
     0.985    19.822     0.200
     1.009    18.868     0.200
     1.029    20.452     0.200
     1.029    20.282     0.200
     1.207    23.999     0.200
     1.207    23.321     0.200
     1.224    23.397     0.200
     1.221    25.059     0.200
     1.221    24.641     0.200
     1.262    25.173     0.200
     1.284    25.948     0.200
     1.276    25.432     0.200
     1.276    25.241     0.200
     2.129    39.619     0.200
     2.272    40.149     0.200
     2.366    43.258     0.200
     2.503    44.101     0.200
     2.772    46.363     0.200
     2.891    48.234     0.200
     2.851    47.317     0.200
     3.051    50.268     0.200
     0.181     4.316     0.200
     0.442     9.886     0.200
     0.403     9.078     0.200
     0.403     9.649     0.200
     0.403     9.930     0.200
     0.479    10.737     0.200
     0.666    16.670     0.200
     0.778    17.021     0.200
     0.778    16.494     0.200
     0.760    15.410     0.200
     0.906    18.990     0.200
     0.989    19.775     0.200
     0.989    19.267     0.200
     0.989    19.107     0.200
     0.965    20.306     0.200
     0.965    21.278     0.200
     0.996    20.976     0.200
     1.052    22.285     0.200
     1.052    22.105     0.200
     1.203    24.288     0.200
     1.203    24.553     0.200
     1.172    24.767     0.200
     1.248    25.922     0.200
     1.248    25.820     0.200
     1.248    25.640     0.200
     1.251    26.832     0.200
     1.292    26.273     0.200
     1.266    25.823     0.200
     1.269    26.278     0.200
     1.302    27.245     0.200
     1.368    28.596     0.200
     1.449    29.722     0.200
     1.654    32.554     0.200
     1.728    33.450     0.200
     1.744    33.758     0.200
     1.796    34.422     0.200
     2.270    42.123     0.200
     2.336    43.004     0.200
     2.392    43.879     0.200
     2.392    44.079     0.200
     0.212     5.921     0.200
     0.381     8.633     0.200
     0.381     8.836     0.200
     0.381     9.195     0.200
     0.491    10.642     0.200
     0.491    10.404     0.200
     0.487    10.726     0.200
     0.639    14.255     0.200
     0.650    15.931     0.200
     0.706    14.140     0.200
     0.706    14.245     0.200
     0.777    16.595     0.200
     0.930    19.567     0.200
     0.972    20.017     0.200
     1.001    19.173     0.200
     1.035    20.425     0.200
     1.141    22.878     0.200
     1.141    23.088     0.200
     1.141    22.985     0.200
     1.197    24.186     0.200
     1.215    23.191     0.200
     1.222    25.140     0.200
     1.222    24.752     0.200
     1.217    24.589     0.200
     1.256    25.571     0.200
     1.274    25.469     0.200
     1.274    25.130     0.200
     1.274    25.363     0.200
     1.272    25.855     0.200
     2.121    41.444     0.200
     2.223    43.265     0.200
     2.262    40.100     0.200
     2.350    40.915     0.200
     2.350    41.169     0.200
     2.646    44.825     0.200
     2.759    46.558     0.200
     2.759    46.300     0.200
     2.884    48.879     0.200
     3.037    51.039     0.200
     0.449    10.293     0.200
     0.485    10.253     0.200
     0.485    10.532     0.200
     0.491    10.443     0.200
     0.516    11.213     0.200
     0.516    11.104     0.200
     0.677    14.578     0.200
     0.717    15.475     0.200
     0.717    15.674     0.200
     0.802    16.403     0.200
     0.781    16.647     0.200
     0.851    18.955     0.200
     0.851    18.841     0.200
     0.851    19.066     0.200
     1.011    20.744     0.200
     1.014    20.663     0.200
     1.091    22.498     0.200
     1.230    24.743     0.200
     1.230    24.872     0.200
     1.342    27.156     0.200
     1.406    29.887     0.200
     1.406    29.219     0.200
     1.452    28.187     0.200
     1.484    30.332     0.200
     1.602    31.967     0.200
     1.587    32.564     0.200
     1.587    32.405     0.200
     1.931    37.645     0.200
     2.353    45.681     0.200
     2.528    45.465     0.200
     3.639    62.320     0.200
     0.370     8.520     0.200
     0.370     8.759     0.200
     0.499    10.485     0.200
     0.499    11.073     0.200
     0.567    11.325     0.200
     0.567    11.460     0.200
     0.616    13.923     0.200
     0.770    16.341     0.200
     0.814    16.776     0.200
     0.932    19.817     0.200
     0.932    19.618     0.200
     1.066    21.830     0.200
     1.097    21.759     0.200
     1.097    20.926     0.200
     1.145    21.764     0.200
     1.147    23.529     0.200
     1.192    25.237     0.200
     1.192    24.583     0.200
     1.182    24.490     0.200
     1.182    24.384     0.200
     1.197    23.204     0.200
     1.311    27.557     0.200
     1.311    26.938     0.200
     1.236    24.938     0.200
     1.306    26.615     0.200
     1.306    25.860     0.200
     1.547    29.672     0.200
     2.242    40.717     0.200
     2.272    44.086     0.200
     2.287    40.721     0.200
     2.287    40.573     0.200
     2.362    42.141     0.200
     2.362    41.891     0.200
     2.708    46.299     0.200
     0.269     5.937     0.200
     0.269     5.843     0.200
     0.512    11.417     0.200
     0.577    10.817     0.200
     0.577    11.169     0.200
     0.603    13.107     0.200
     0.603    12.885     0.200
     0.866    18.328     0.200
     0.871    19.324     0.200
     1.011    21.463     0.200
     1.011    22.124     0.200
     1.080    22.709     0.200
     1.082    22.337     0.200
     1.076    22.848     0.200
     1.076    23.161     0.200
     1.112    22.871     0.200
     1.178    23.839     0.200
     1.366    29.226     0.200
     1.366    29.413     0.200
     1.279    27.402     0.200
     1.279    26.297     0.200
     1.318    28.064     0.200
     1.408    29.465     0.200
     1.408    29.086     0.200
     1.464    28.344     0.200
     1.647    33.626     0.200
     2.366    47.714     0.200
     2.335    43.771     0.200
     2.335    44.857     0.200
     2.327    44.173     0.200
     2.327    45.130     0.200
     2.465    45.772     0.200
     2.465    46.799     0.200
     2.502    45.728     0.200
     2.692    48.950     0.200
     3.011    52.845     0.200
     3.011    53.560     0.200
     3.281    56.945     0.200
     0.446     8.696     0.200
     0.438     9.459     0.200
     0.438    10.053     0.200
     0.446    10.447     0.200
     0.747    16.931     0.200
     0.936    20.337     0.200
     0.961    19.713     0.200
     0.974    21.405     0.200
     0.974    20.756     0.200
     1.173    24.809     0.200
     1.214    25.627     0.200
     1.214    25.174     0.200
     1.190    25.327     0.200
     1.288    26.807     0.200
     1.290    27.128     0.200
     1.388    29.591     0.200
     1.330    27.070     0.200
     1.681    33.710     0.200
     1.749    35.157     0.200
     1.749    35.353     0.200
     2.302    42.364     0.200
     2.302    43.145     0.200
     2.380    44.926     0.200
     0.265     6.732     0.200
     0.471    12.368     0.200
     0.495    10.942     0.200
     0.589    13.069     0.200
     0.589    13.436     0.200
     0.589    12.850     0.200
     0.766    16.009     0.200
     0.766    15.455     0.200
     0.766    15.189     0.200
     0.808    16.409     0.200
     0.849    19.213     0.200
     0.849    18.775     0.200
     1.116    22.922     0.200
     1.123    23.071     0.200
     1.123    23.275     0.200
     1.132    22.953     0.200
     1.132    22.844     0.200
     1.237    25.156     0.200
     1.237    24.921     0.200
     1.237    24.773     0.200
     1.305    25.725     0.200
     1.305    25.303     0.200
     1.420    28.219     0.200
     1.431    28.531     0.200
     1.431    28.797     0.200
     1.483    28.452     0.200
     1.483    27.936     0.200
     1.539    29.793     0.200
     2.418    44.559     0.200
     0.497    10.859     0.200
     0.497    11.203     0.200
     0.534    12.695     0.200
     0.601    12.824     0.200
     0.601    12.620     0.200
     0.681    14.170     0.200
     0.842    18.521     0.200
     0.939    20.146     0.200
     0.939    20.553     0.200
     0.968    20.816     0.200
     0.968    21.051     0.200
     1.004    19.771     0.200
     1.090    24.097     0.200
     1.272    27.499     0.200
     1.239    24.505     0.200
     1.234    25.888     0.200
     1.423    27.882     0.200
     1.498    31.652     0.200
     2.462    45.294     0.200
     2.450    47.426     0.200
     2.450    46.715     0.200
     0.355     8.290     0.200
     0.371     9.050     0.200
     0.371     8.968     0.200
     0.539    11.250     0.200
     0.539    11.660     0.200
     0.533    11.191     0.200
     0.652    13.181     0.200
     0.780    16.949     0.200
     0.780    16.629     0.200
     0.797    18.772     0.200
     0.847    18.496     0.200
     0.899    19.333     0.200
     0.983    20.679     0.200
     0.983    20.390     0.200
     0.983    20.562     0.200
     1.065    20.882     0.200
     1.253    25.985     0.200
     1.253    26.755     0.200
     1.156    24.012     0.200
     1.206    25.050     0.200
     1.353    27.381     0.200
     1.643    31.361     0.200
     2.219    40.709     0.200
     2.229    41.108     0.200
     2.336    41.239     0.200
     2.385    43.240     0.200
     2.385    42.647     0.200
     2.419    42.859     0.200
     2.531    44.893     0.200
     3.249    55.283     0.200
     0.134     4.842     0.200
     0.310     6.606     0.200
     0.459    10.006     0.200
     0.516    11.304     0.200
     0.516    11.432     0.200
     0.895    17.919     0.200
     0.897    17.739     0.200
     1.091    22.722     0.200
     1.220    24.853     0.200
     1.259    25.608     0.200
     1.307    26.807     0.200
     1.326    26.421     0.200
     1.390    27.747     0.200
     2.284    40.899     0.200
     2.326    41.452     0.200
     2.338    41.606     0.200
     2.514    43.638     0.200
     2.774    46.698     0.200
     2.999    50.179     0.200
     0.392     8.952     0.200
     0.449     9.096     0.200
     0.487    11.091     0.200
     0.749    15.751     0.200
     0.997    21.312     0.200
     1.183    24.910     0.200
     1.209    25.375     0.200
     1.259    26.055     0.200
     1.256    26.299     0.200
     1.401    29.768     0.200
     1.705    33.633     0.200
     2.346    42.577     0.200
     2.675    47.603     0.200
     2.919    51.150     0.200
     0.311     6.536     0.200
     0.311     6.642     0.200
     0.463    10.453     0.200
     0.463    10.627     0.200
     0.512    11.620     0.200
     0.726    15.956     0.200
     0.826    17.405     0.200
     0.894    17.727     0.200
     0.896    18.344     0.200
     1.001    21.156     0.200
     1.042    21.898     0.200
     1.089    22.933     0.200
     1.176    23.180     0.200
     1.216    24.720     0.200
     1.256    25.755     0.200
     1.310    26.748     0.200
     1.376    28.697     0.200
     1.407    28.619     0.200
     1.608    30.463     0.200
     1.608    30.862     0.200
     1.761    33.381     0.200
     2.286    42.847     0.200
     2.323    41.674     0.200
     2.334    41.769     0.200
     0.320     6.809     0.200
     0.461    10.058     0.200
     0.506    11.444     0.200
     0.887    18.522     0.200
     0.897    17.381     0.200
     1.080    22.823     0.200
     1.214    24.891     0.200
     1.249    25.477     0.200
     1.316    26.313     0.200
     1.611    30.987     0.200
     2.280    43.211     0.200
     0.315     6.983     0.200
     0.315     6.809     0.200
     0.460    10.932     0.200
     0.460    10.680     0.200
     0.511    11.641     0.200
     0.723    17.197     0.200
     0.723    16.166     0.200
     0.824    17.748     0.200
     0.824    17.498     0.200
     0.891    18.376     0.200
     0.891    18.568     0.200
     0.881    19.973     0.200
     0.897    17.587     0.200
     0.897    17.400     0.200
     0.997    20.298     0.200
     1.039    21.754     0.200
     1.086    22.955     0.200
     1.171    23.310     0.200
     1.217    24.781     0.200
     1.217    25.039     0.200
     1.254    25.661     0.200
     1.254    26.016     0.200
     1.321    26.168     0.200
     1.321    26.758     0.200
     1.308    26.877     0.200
     1.374    27.676     0.200
     1.385    26.694     0.200
     1.387    28.011     0.200
     1.611    30.575     0.200
     2.214    41.075     0.200
     2.282    41.475     0.200
     2.282    40.907     0.200
     2.321    41.211     0.200
     2.335    42.322     0.200
     2.335    41.320     0.200
     2.442    46.949     0.200
     2.509    44.516     0.200
     3.037    51.365     0.200
     3.229    59.122     0.200
     0.305     6.411     0.200
     0.353     7.528     0.200
     0.516    11.240     0.200
     0.516    11.029     0.200
     0.520    13.189     0.200
     0.607    12.460     0.200
     0.701    16.864     0.200
     0.773    17.900     0.200
     0.992    21.113     0.200
     1.081    24.349     0.200
     1.081    24.515     0.200
     1.296    27.735     0.200
     1.231    24.582     0.200
     1.250    25.701     0.200
     1.426    28.267     0.200
     2.249    44.862     0.200
     0.403     9.150     0.200
     0.403     9.152     0.200
     0.444     8.462     0.200
     0.479    10.887     0.200
     0.665    15.723     0.200
     0.758    15.980     0.200
     0.964    20.504     0.200
     0.990    19.690     0.200
     0.994    21.279     0.200
     0.994    21.573     0.200
     1.050    21.321     0.200
     1.188    24.732     0.200
     1.250    25.141     0.200
     1.203    25.074     0.200
     1.249    25.233     0.200
     1.249    25.636     0.200
     1.264    25.440     0.200
     1.267    25.613     0.200
     1.300    24.358     0.200
     1.281    26.876     0.200
     1.401    29.090     0.200
     1.652    31.340     0.200
     2.336    41.889     0.200
     2.336    42.180     0.200
     2.930    50.316     0.200
     0.353     7.886     0.200
     0.605    12.650     0.200
     0.849    17.907     0.200
     0.913    20.063     0.200
     1.002    20.265     0.200
     1.144    24.774     0.200
     1.330    25.694     0.200
     1.330    26.317     0.200
     1.341    26.966     0.200
     1.341    27.792     0.200
     1.440    30.063     0.200
     1.718    33.853     0.200
     1.930    36.414     0.200
     2.408    42.840     0.200
     2.443    43.307     0.200
     0.265     6.034     0.200
     0.342     7.087     0.200
     0.422     9.935     0.200
     0.422     9.634     0.200
     0.588    12.946     0.200
     0.588    12.626     0.200
     0.588    12.115     0.200
     0.736    16.184     0.200
     0.776    15.112     0.200
     0.776    15.692     0.200
     0.852    19.524     0.200
     0.961    19.502     0.200
     0.961    19.384     0.200
     1.038    22.300     0.200
     1.038    21.659     0.200
     1.089    22.504     0.200
     1.089    22.324     0.200
     1.089    23.043     0.200
     1.116    22.794     0.200
     1.116    22.394     0.200
     1.166    24.053     0.200
     1.166    24.363     0.200
     1.166    24.517     0.200
     1.165    23.167     0.200
     1.267    25.412     0.200
     1.267    25.292     0.200
     1.313    26.719     0.200
     1.351    27.265     0.200
     1.373    28.575     0.200
     1.398    28.437     0.200
     1.437    28.296     0.200
     1.437    29.388     0.200
     1.481    29.360     0.200
     1.517    30.528     0.200
     1.664    31.854     0.200
     2.213    40.692     0.200
     2.213    40.547     0.200
     2.229    40.463     0.200
     2.338    42.406     0.200
     2.387    42.524     0.200
     2.387    43.852     0.200
     2.495    44.823     0.200
     2.495    45.011     0.200
     2.512    44.781     0.200
     2.896    49.815     0.200
     3.178    53.705     0.200
     3.199    54.266     0.200
     0.302     6.502     0.200
     0.346     8.184     0.200
     0.346     6.850     0.200
     0.534    10.696     0.200
     0.534    11.514     0.200
     0.586    13.042     0.200
     0.600    11.805     0.200
     0.796    17.704     0.200
     0.850    19.121     0.200
     0.936    20.063     0.200
     1.036    21.987     0.200
     1.100    22.093     0.200
     1.154    24.298     0.200
     1.145    22.459     0.200
     1.301    28.213     0.200
     1.202    25.510     0.200
     1.347    26.234     0.200
     1.779    34.834     0.200
     2.258    42.894     0.200
     2.394    44.524     0.200
     0.352     7.506     0.200
     0.439    10.384     0.200
     0.439    10.779     0.200
     0.525    11.146     0.200
     0.525    11.041     0.200
     0.753    16.318     0.200
     0.842    17.037     0.200
     0.842    17.709     0.200
     0.789    18.248     0.200
     0.903    18.034     0.200
     1.030    21.992     0.200
     1.030    22.129     0.200
     1.050    22.324     0.200
     1.142    22.648     0.200
     1.142    24.300     0.200
     1.100    23.401     0.200
     1.183    24.546     0.200
     1.375    27.847     0.200
     1.420    28.757     0.200
     1.450    29.579     0.200
     1.552    29.929     0.200
     2.321    41.407     0.200
     2.321    44.532     0.200
     2.471    46.469     0.200
     0.463     9.709     0.200
     0.463     9.779     0.200
     0.487    11.287     0.200
     0.487    11.458     0.200
     0.498    10.944     0.200
     0.498    10.835     0.200
     0.738    15.572     0.200
     0.714    15.933     0.200
     0.831    16.945     0.200
     0.802    17.341     0.200
     0.893    20.092     0.200
     0.893    20.271     0.200
     1.042    21.083     0.200
     1.045    21.408     0.200
     1.150    25.459     0.200
     1.098    22.900     0.200
     1.098    22.736     0.200
     1.212    27.145     0.200
     1.212    26.880     0.200
     1.196    23.769     0.200
     1.476    28.090     0.200
     1.448    30.504     0.200
     1.525    32.324     0.200
     1.630    32.472     0.200
     1.607    33.865     0.200
     1.781    34.565     0.200
     2.326    45.417     0.200
     2.326    45.112     0.200
     2.547    47.178     0.200
     0.418    10.026     0.200
     0.550    12.601     0.200
     0.550    12.706     0.200
     0.550    12.558     0.200
     0.733    16.220     0.200
     0.915    20.359     0.200
     0.915    17.480     0.200
     0.915    18.054     0.200
     1.018    22.209     0.200
     1.018    21.521     0.200
     1.072    22.629     0.200
     1.116    23.383     0.200
     1.116    23.004     0.200
     1.163    23.839     0.200
     1.163    24.652     0.200
     1.163    24.449     0.200
     1.310    27.707     0.200
     1.298    27.536     0.200
     1.400    28.843     0.200
     1.437    29.499     0.200
     1.472    28.722     0.200
     1.528    30.675     0.200
     1.879    36.214     0.200
     2.340    44.933     0.200
     2.340    45.371     0.200
     2.385    43.506     0.200
     2.559    45.583     0.200
     3.197    55.343     0.200
     0.265     6.435     0.200
     0.343     7.082     0.200
     0.524    11.057     0.200
     0.643    13.218     0.200
     0.643    13.328     0.200
     0.772    18.326     0.200
     0.738    17.467     0.200
     0.788    16.480     0.200
     0.788    16.940     0.200
     0.894    19.629     0.200
     1.044    23.295     0.200
     1.002    21.051     0.200
     1.041    20.181     0.200
     1.041    21.181     0.200
     0.999    21.758     0.200
     1.014    22.055     0.200
     1.172    25.450     0.200
     1.291    26.050     0.200
     1.308    27.313     0.200
     1.392    27.187     0.200
     1.441    28.219     0.200
     1.572    29.979     0.200
     1.590    29.935     0.200
     2.279    45.627     0.200
     0.350     8.383     0.200
     0.350     8.290     0.200
     0.516    10.550     0.200
     0.644    13.013     0.200
     0.644    13.200     0.200
     0.694    16.828     0.200
     0.792    17.027     0.200
     0.881    19.471     0.200
     0.959    19.919     0.200
     1.089    21.811     0.200
     1.089    21.990     0.200
     1.151    21.685     0.200
     1.154    23.077     0.200
     1.206    24.056     0.200
     1.263    25.739     0.200
     1.334    26.047     0.200
     1.843    33.759     0.200
     2.267    40.546     0.200
     2.267    40.695     0.200
     2.277    40.323     0.200
     2.380    41.657     0.200
     2.380    42.095     0.200
     2.436    43.476     0.200
     2.436    43.789     0.200
     2.590    45.368     0.200
     0.366     8.522     0.200
     0.366     8.342     0.200
     0.501    10.844     0.200
     0.634    12.996     0.200
     0.775    16.935     0.200
     0.890    20.030     0.200
     0.939    20.218     0.200
     0.939    20.406     0.200
     0.934    20.184     0.200
     1.073    22.298     0.200
     1.095    21.672     0.200
     1.095    21.508     0.200
     1.188    24.391     0.200
     1.184    25.086     0.200
     1.199    23.705     0.200
     1.307    26.511     0.200
     1.332    27.024     0.200
     1.703    33.193     0.200
     2.248    40.974     0.200
     2.271    41.675     0.200
     2.295    42.588     0.200
     2.365    43.145     0.200
     2.596    45.632     0.200
     2.824    48.710     0.200
     0.318     7.393     0.200
     0.318     8.127     0.200
     0.467    11.290     0.200
     0.524    11.914     0.200
     0.524    11.672     0.200
     0.782    17.132     0.200
     0.787    17.587     0.200
     0.787    18.056     0.200
     0.927    19.191     0.200
     0.927    18.402     0.200
     1.154    22.176     0.200
     1.154    22.902     0.200
     1.212    24.376     0.200
     1.220    24.264     0.200
     1.461    27.267     0.200
     2.002    33.593     0.200
     0.266     5.976     0.200
     0.593    12.618     0.200
     0.583    13.714     0.200
     0.662    14.446     0.200
     0.830    17.668     0.200
     0.882    19.438     0.200
     0.909    20.086     0.200
     0.917    20.598     0.200
     1.474    30.814     0.200
     1.499    31.602     0.200
     0.385     8.293     0.200
     0.482    11.089     0.200
     0.702    14.489     0.200
     0.771    15.976     0.200
     0.932    18.595     0.200
     0.965    20.871     0.200
     0.999    21.348     0.200
     1.135    23.631     0.200
     1.191    24.782     0.200
     1.235    26.041     0.200
     1.656    32.617     0.200
     1.687    33.391     0.200
     1.787    34.892     0.200
     2.256    42.272     0.200
     2.345    42.520     0.200
     0.376     8.603     0.200
     0.438     9.739     0.200
     0.497    10.979     0.200
     0.761    16.643     0.200
     0.751    16.065     0.200
     0.866    17.182     0.200
     1.016    20.769     0.200
     1.014    20.930     0.200
     1.069    22.632     0.200
     1.166    23.793     0.200
     1.163    23.435     0.200
     1.181    24.177     0.200
     1.301    26.348     0.200
     1.347    27.443     0.200
     1.415    28.072     0.200
     1.767    33.311     0.200
     2.248    40.604     0.200
     2.285    40.893     0.200
     2.271    41.203     0.200
     2.446    42.652     0.200
     2.505    43.179     0.200
     0.407     9.949     0.200
     0.407     9.470     0.200
     0.568    12.494     0.200
     0.693    13.928     0.200
     0.807    15.943     0.200
     0.845    18.148     0.200
     0.842    18.076     0.200
     0.993    17.839     0.200
     1.009    21.915     0.200
     1.209    24.437     0.200
     1.492    27.867     0.200
     0.209     6.255     0.200
     0.465    11.405     0.200
     0.540    12.465     0.200
     0.640    15.945     0.200
     0.703    16.702     0.200
     0.759    17.277     0.200
     0.966    21.520     0.200
     1.048    21.483     0.200
     0.911    20.338     0.200
     0.911    20.209     0.200
     0.968    21.158     0.200
     0.968    21.436     0.200
     1.004    21.074     0.200
     1.060    22.065     0.200
     1.060    22.667     0.200
     1.201    24.805     0.200
     1.293    26.794     0.200
     1.293    26.383     0.200
     1.308    27.091     0.200
     1.308    26.001     0.200
     1.457    28.876     0.200
     0.413    10.459     0.200
     0.678    16.789     0.200
     0.917    19.885     0.200
     0.917    20.306     0.200
     0.977    21.199     0.200
     0.990    21.070     0.200
     1.061    22.563     0.200
     1.061    22.344     0.200
     1.263    25.810     0.200
     1.313    26.938     0.200
     1.313    25.927     0.200
     1.282    26.826     0.200
     1.282    27.037     0.200
     1.282    26.076     0.200
     1.459    29.107     0.200
     1.532    30.603     0.200
     1.665    32.531     0.200
     1.681    32.151     0.200
     0.524    10.783     0.200
     0.680    14.034     0.200
     0.770    16.941     0.200
     0.784    15.129     0.200
     0.784    16.049     0.200
     0.948    20.547     0.200
     0.973    20.812     0.200
     1.053    21.137     0.200
     1.150    24.574     0.200
     1.123    23.912     0.200
     1.182    23.905     0.200
     1.244    25.987     0.200
     1.244    25.677     0.200
     1.291    27.432     0.200
     1.402    27.539     0.200
     1.500    31.477     0.200
     1.574    29.741     0.200
     2.459    44.023     0.200
     0.262     7.861     0.200
     0.800    17.742     0.200
     0.826    17.312     0.200
     0.826    17.203     0.200
     1.083    21.426     0.200
     1.083    21.563     0.200
     1.118    22.597     0.200
     1.119    22.022     0.200
     1.119    22.252     0.200
     1.261    24.002     0.200
     1.261    24.283     0.200
     1.256    25.040     0.200
     1.491    27.119     0.200
     1.689    29.925     0.200
     0.813    16.419     0.200
     0.908    20.776     0.200
     0.997    20.346     0.200
     1.329    25.961     0.200
     1.466    30.214     0.200
     1.660    32.607     0.200
     1.686    32.705     0.200
     1.793    35.553     0.200
     0.709    14.313     0.200
     0.754    15.716     0.200
     0.754    15.946     0.200
     0.862    18.595     0.200
     0.945    21.241     0.200
     0.948    20.791     0.200
     0.948    21.071     0.200
     1.106    24.752     0.200
     1.249    26.076     0.200
     1.249    26.297     0.200
     1.254    26.701     0.200
     1.348    29.314     0.200
     1.375    26.812     0.200
     1.419    28.239     0.200
     1.419    29.783     0.200
     1.472    31.336     0.200
     1.538    31.051     0.200
     1.546    32.007     0.200
     2.472    45.405     0.200
     2.647    48.886     0.200
     3.745    63.329     0.200
     0.592    11.379     0.200
     0.803    17.750     0.200
     0.886    18.262     0.200
     0.946    21.141     0.200
     1.044    22.929     0.200
     1.151    23.631     0.200
     1.169    25.648     0.200
     1.210    25.690     0.200
     1.252    26.759     0.200
     1.501    29.657     0.200
     1.547    31.072     0.200
     1.837    35.483     0.200
     2.399    43.987     0.200
     0.586    10.795     0.200
     0.796    18.244     0.200
     0.897    18.535     0.200
     0.943    21.146     0.200
     1.050    22.698     0.200
     1.161    23.307     0.200
     1.171    25.211     0.200
     1.204    25.318     0.200
     1.511    29.752     0.200
     1.558    30.748     0.200
     1.593    32.992     0.200
     2.391    44.184     0.200
     0.292     7.308     0.200
     0.292     7.558     0.200
     0.889    18.437     0.200
     1.149    21.901     0.200
     1.149    22.002     0.200
     1.139    23.030     0.200
     1.340    26.762     0.200
     1.340    26.992     0.200
     1.319    26.504     0.200
     1.367    26.842     0.200
     1.541    29.108     0.200
     1.720    31.950     0.200
     2.251    41.842     0.200
     2.403    41.390     0.200
     0.496    11.641     0.200
     0.914    17.570     0.200
     0.914    17.871     0.200
     0.998    20.149     0.200
     1.114    22.568     0.200
     1.114    21.478     0.200
     1.208    24.200     0.200
     1.300    24.958     0.200
     1.364    26.063     0.200
     1.414    26.645     0.200
     1.907    34.740     0.200
     1.928    34.622     0.200
     2.080    36.890     0.200
     2.260    38.435     0.200
     2.341    39.519     0.200
     2.387    40.541     0.200
     0.397     8.705     0.200
     0.399     8.571     0.200
     0.954    20.977     0.200
     1.028    20.827     0.200
     1.028    20.706     0.200
     1.162    25.068     0.200
     1.243    26.238     0.200
     1.257    27.801     0.200
     1.257    27.383     0.200
     1.426    29.458     0.200
     1.685    33.846     0.200
     1.684    34.082     0.200
     1.709    33.908     0.200
     1.709    33.505     0.200
     1.780    33.007     0.200
     1.815    36.240     0.200
     1.902    35.582     0.200
     2.198    40.362     0.200
     2.335    43.037     0.200
     2.384    43.922     0.200
     0.416     8.457     0.200
     0.416     8.886     0.200
     0.493    11.371     0.200
     0.495    10.907     0.200
     0.759    17.776     0.200
     0.977    20.944     0.200
     0.977    20.467     0.200
     1.061    21.681     0.200
     1.140    23.373     0.200
     1.140    22.897     0.200
     1.152    24.292     0.200
     1.152    23.894     0.200
     1.234    26.000     0.200
     1.234    25.328     0.200
     1.265    26.401     0.200
     1.302    27.067     0.200
     1.345    27.861     0.200
     1.345    27.493     0.200
     1.397    27.491     0.200
     1.537    30.472     0.200
     1.748    32.786     0.200
     1.798    33.505     0.200
     1.893    34.756     0.200
     1.928    35.005     0.200
     0.418     8.859     0.200
     0.418     8.992     0.200
     0.497    11.320     0.200
     0.500    10.817     0.200
     0.763    16.773     0.200
     0.763    17.718     0.200
     0.974    21.133     0.200
     0.974    20.618     0.200
     1.065    22.157     0.200
     1.065    22.048     0.200
     1.142    22.999     0.200
     1.142    23.491     0.200
     1.148    23.791     0.200
     1.234    25.970     0.200
     1.234    25.603     0.200
     1.262    26.789     0.200
     1.262    26.430     0.200
     1.300    27.411     0.200
     1.349    26.858     0.200
     1.349    27.561     0.200
     1.400    28.397     0.200
     1.540    30.684     0.200
     1.593    30.889     0.200
     1.751    32.810     0.200
     1.801    33.922     0.200
     2.265    42.668     0.200
     0.497    11.085     0.200
     0.964    20.773     0.200
     1.620    31.220     0.200
     0.508    11.262     0.200
     0.753    14.910     0.200
     0.860    17.052     0.200
     1.259    27.081     0.200
     1.511    29.280     0.200
     1.545    29.701     0.200
     1.660    31.801     0.200
     1.836    35.992     0.200
     0.489    10.438     0.200
     0.944    20.471     0.200
     1.259    27.682     0.200
     1.312    28.454     0.200
     1.568    29.228     0.200
     1.809    34.846     0.200
     0.665    13.250     0.200
     0.829    16.260     0.200
     0.915    18.885     0.200
     1.153    25.573     0.200
     1.141    24.677     0.200
     1.327    25.360     0.200
     1.354    26.323     0.200
     1.464    28.679     0.200
     1.730    35.251     0.200
     1.788    35.879     0.200
     0.543    11.491     0.200
     0.736    14.844     0.200
     0.917    18.437     0.200
     0.995    21.215     0.200
     0.984    22.147     0.200
     1.007    20.886     0.200
     1.311    28.989     0.200
     1.358    29.077     0.200
     1.569    30.418     0.200
     1.594    32.486     0.200
     1.602    32.009     0.200
     1.717    33.452     0.200
     1.752    34.603     0.200
     1.779    34.710     0.200
     1.878    35.158     0.200
     0.479    10.947     0.200
     0.629    12.660     0.200
     0.900    18.440     0.200
     0.949    18.585     0.200
     1.222    23.958     0.200
     1.378    29.753     0.200
     1.429    28.284     0.200
     2.465    46.667     0.200
     2.737    50.961     0.200
     3.099    56.800     0.200
     0.468    10.369     0.200
     0.957    18.202     0.200
     1.228    23.396     0.200
     1.378    29.541     0.200
     1.482    28.395     0.200
     0.472     9.722     0.200
     1.093    24.981     0.200
     1.227    23.561     0.200
     1.481    29.197     0.200
     1.767    34.407     0.200
     0.500    10.725     0.200
     0.517    11.285     0.200
     0.842    17.108     0.200
     1.002    19.608     0.200
     1.018    23.075     0.200
     1.120    22.179     0.200
     1.173    23.698     0.200
     1.317    26.199     0.200
     1.369    27.611     0.200
     1.497    28.797     0.200
     1.647    32.004     0.200
     1.774    33.287     0.200
     0.473    11.646     0.200
     0.640    13.232     0.200
     0.773    15.816     0.200
     0.889    17.707     0.200
     0.958    18.911     0.200
     1.097    24.305     0.200
     1.293    24.899     0.200
     1.325    24.952     0.200
     1.440    28.216     0.200
     1.484    28.367     0.200
     1.770    34.310     0.200
     0.499    11.338     0.200
     0.805    16.298     0.200
     1.222    26.688     0.200
     1.385    25.678     0.200
     1.644    32.039     0.200
     0.515    11.386     0.200
     0.780    16.503     0.200
     0.825    17.085     0.200
     0.897    19.941     0.200
     0.927    21.054     0.200
     1.101    21.652     0.200
     1.077    22.491     0.200
     1.218    27.812     0.200
     1.436    28.192     0.200
     1.467    29.046     0.200
     1.579    31.691     0.200
     1.626    32.077     0.200
     1.753    33.031     0.200
     1.908    37.632     0.200
     0.542    10.726     0.200
     0.674    14.009     0.200
     0.513    10.322     0.200
     0.759    16.131     0.200
     0.858    16.944     0.200
     1.047    22.456     0.200
     1.261    27.580     0.200
     1.434    28.353     0.200
     1.510    29.725     0.200
     1.543    30.639     0.200
     1.658    33.338     0.200
     0.513    11.519     0.200
     0.570    12.385     0.200
     0.960    20.794     0.200
     1.229    24.498     0.200
     1.228    26.858     0.200
     2.322    43.083     0.200
     2.347    45.380     0.200
     2.899    51.189     0.200
     2.932    54.578     0.200
     3.246    59.866     0.200
     3.520    61.857     0.200
     0.484    10.957     0.200
     0.532    11.582     0.200
     0.777    15.618     0.200
     0.858    17.680     0.200
     0.955    21.725     0.200
     1.031    22.956     0.200
     1.274    27.496     0.200
     1.512    30.160     0.200
     1.544    30.409     0.200
     1.657    32.666     0.200
     0.478    10.804     0.200
     0.566    12.013     0.200
     0.718    14.424     0.200
     0.886    17.700     0.200
     0.938    19.392     0.200
     0.943    21.315     0.200
     1.039    20.381     0.200
     1.043    23.381     0.200
     1.160    22.077     0.200
     1.220    24.672     0.200
     1.251    24.957     0.200
     1.254    25.251     0.200
     0.573    12.665     0.200
     0.580    12.308     0.200
     0.845    19.450     0.200
     0.924    18.133     0.200
     1.003    21.995     0.200
     1.122    26.129     0.200
     0.522    11.204     0.200
     0.493     9.872     0.200
     0.637    13.703     0.200
     0.785    16.318     0.200
     1.109    23.989     0.200
     1.324    25.898     0.200
     1.394    30.279     0.200
     1.437    28.909     0.200
     1.766    34.556     0.200
     0.517    11.001     0.200
     0.751    15.209     0.200
     0.872    17.743     0.200
     0.954    20.544     0.200
     0.977    22.148     0.200
     1.040    21.873     0.200
     1.271    27.862     0.200
     1.314    27.826     0.200
     1.523    29.336     0.200
     1.557    29.828     0.200
     1.672    32.425     0.200
     0.466    10.257     0.200
     0.613    12.087     0.200
     1.071    23.490     0.200
     0.490    10.226     0.200
     0.598    12.606     0.200
     0.483    11.101     0.200
     0.609    12.508     0.200
     0.756    17.346     0.200
     0.930    19.324     0.200
     0.930    21.662     0.200
     1.080    24.372     0.200
     1.204    23.479     0.200
     1.366    29.513     0.200
     1.409    28.035     0.200
     1.456    29.754     0.200
     1.584    29.436     0.200
     1.738    33.295     0.200
     1.865    36.088     0.200
     1.985    37.096     0.200
     2.105    38.988     0.200
     2.370    44.340     0.200
     2.517    46.940     0.200
     2.580    48.443     0.200
     2.717    49.791     0.200
     0.569    12.518     0.200
     0.684    14.817     0.200
     0.868    18.361     0.200
     0.938    18.881     0.200
     1.023    20.046     0.200
     0.846    19.713     0.200
     1.193    26.457     0.200
     1.187    23.242     0.200
     1.305    24.640     0.200
     1.349    26.991     0.200
     1.373    27.489     0.200
     1.551    30.583     0.200
     1.680    31.175     0.200
     1.764    35.404     0.200
     1.806    35.615     0.200
     1.943    37.517     0.200
     0.508    11.391     0.200
     0.866    17.514     0.200
     0.983    22.708     0.200
     0.945    20.468     0.200
     1.049    22.147     0.200
     1.178    23.207     0.200
     1.262    27.909     0.200
     1.306    28.110     0.200
     1.551    29.826     0.200
     1.545    32.412     0.200
     1.667    31.927     0.200
     1.699    31.144     0.200
     1.880    37.003     0.200
     1.829    35.742     0.200
     1.997    38.544     0.200
     2.362    44.067     0.200
     2.527    45.758     0.200
     2.590    46.574     0.200
     0.615    12.956     0.200
     0.783    17.856     0.200
     0.900    20.284     0.200
     0.945    19.634     0.200
     0.934    20.469     0.200
     1.107    24.471     0.200
     1.222    24.013     0.200
     1.415    28.397     0.200
     1.472    29.351     0.200
     1.743    34.452     0.200
     2.726    51.072     0.200
     0.557    13.285     0.200
     0.622    13.012     0.200
     1.142    25.979     0.200
     1.311    26.384     0.200
     1.490    28.191     0.200
     1.881    36.962     0.200
     0.512    11.096     0.200
     0.763    15.846     0.200
     0.885    19.457     0.200
     0.924    21.254     0.200
     1.085    21.038     0.200
     1.088    22.244     0.200
     1.355    25.499     0.200
     0.519    11.331     0.200
     0.775    16.183     0.200
     0.831    17.881     0.200
     0.922    21.167     0.200
     1.097    22.278     0.200
     1.077    23.099     0.200
     1.218    28.592     0.200
     1.367    26.629     0.200
     2.527    46.638     0.200
     3.099    54.827     0.200
     3.067    56.978     0.200
     0.467     9.867     0.200
     0.624    12.636     0.200
     0.895    17.539     0.200
     1.080    23.692     0.200
     1.212    23.520     0.200
     1.276    25.878     0.200
     1.308    26.723     0.200
     1.594    31.825     0.200
     1.080    24.544     0.200
     0.439     9.655     0.200
     0.614    12.034     0.200
     1.052    23.680     0.200
     1.447    29.853     0.200
     0.462     9.466     0.200
     0.842    18.003     0.200
     0.501    11.766     0.200
     0.850    17.194     0.200
     0.931    20.225     0.200
     1.249    27.389     0.200
     1.291    28.185     0.200
     1.684    31.647     0.200
     1.980    38.046     0.200
     0.492    10.797     0.200
     0.584    12.480     0.200
     0.908    18.039     0.200
     0.937    20.647     0.200
     0.925    21.335     0.200
     1.068    24.498     0.200
     1.229    25.791     0.200
     2.321    44.461     0.200
     2.351    46.870     0.200
     2.357    47.367     0.200
     0.519    10.853     0.200
     0.635    13.017     0.200
     0.801    15.959     0.200
     0.927    20.842     0.200
     0.894    20.276     0.200
     1.125    24.864     0.200
     1.170    23.982     0.200
     1.323    26.453     0.200
     1.434    28.910     0.200
     0.498    11.025     0.200
     0.787    15.458     0.200
     0.808    16.261     0.200
     1.123    22.945     0.200
     1.077    22.218     0.200
     1.223    27.676     0.200
     1.461    28.925     0.200
     1.608    32.574     0.200
     0.540    11.622     0.200
     0.735    14.599     0.200
     0.915    18.300     0.200
     0.993    20.904     0.200
     1.009    21.856     0.200
     1.308    28.577     0.200
     1.356    28.501     0.200
     1.567    29.910     0.200
     1.715    33.413     0.200
     1.750    34.148     0.200
     1.781    34.911     0.200
     1.706    33.009     0.200
     0.566    11.604     0.200
     0.590    11.835     0.200
     0.850    19.804     0.200
     1.256    25.043     0.200
     0.546    11.966     0.200
     1.226    22.868     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
