#!/bin/bash
gmt begin hubbard5.7_tt5s_local_ISLE pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance hubbard5.7'
# Station code
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   110.000 Single station: ISLE 
EOF
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.1  0.000
  1.1 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.100    22.636
     1.200    24.016
     1.300    25.396
     1.400    26.776
     1.500    28.156
     1.600    29.536
     1.700    30.916
     1.800    32.296
     1.900    33.676
     2.000    35.056
     2.100    36.436
     2.200    37.816
     2.300    39.196
     2.400    40.576
     2.500    41.956
     2.600    43.336
     2.700    44.716
     2.800    46.096
     2.900    47.476
     3.000    48.856
     3.100    50.236
     3.200    51.617
     3.300    52.997
     3.400    54.377
     3.500    55.757
     3.600    57.136
     3.700    58.516
     3.800    59.895
     3.900    61.275
     4.000    62.655
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    55.136 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.408
     0.200     4.100
     0.300     5.930
     0.400     7.801
     0.500     9.690
     0.600    11.588
     0.700    13.490
     0.800    15.396
     0.900    17.304
     1.000    19.019
     1.100    20.625
     1.200    22.232
     1.300    23.838
     1.400    25.445
     1.500    27.051
     1.600    28.657
     1.700    30.264
     1.800    31.870
     1.900    33.476
     2.000    35.083
     2.100    36.689
     2.200    38.296
     2.300    39.902
     2.400    41.508
     2.500    43.115
     2.600    44.721
     2.700    46.327
     2.800    47.934
     2.900    49.540
     3.000    51.146
     3.100    52.751
     3.200    54.357
     3.300    55.963
     3.400    57.569
     3.500    59.175
     3.600    60.781
     3.700    62.387
     3.800    63.993
     3.900    65.599
     4.000    67.204
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    59.781 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.300    44.003
     1.400    46.467
     1.500    48.931
     1.600    51.395
     1.700    53.860
     1.800    56.324
     1.900    58.788
     2.000    61.252
     2.100    63.717
     2.200    66.181
     2.300    68.645
     2.400    71.109
     2.500    73.574
     2.600    76.038
     2.700    78.502
     2.800    80.966
     2.900    83.431
     3.000    85.895
     3.100    88.359
     3.200    90.823
     3.300    93.287
     3.400    95.751
     3.500    98.215
     3.600   100.678
     3.700   103.141
     3.800   105.604
     3.900   108.067
     4.000   110.530
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    98.678 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.169
     0.200     7.099
     0.300    10.267
     0.400    13.506
     0.500    16.777
     0.600    20.062
     0.700    23.356
     0.800    26.656
     0.900    29.960
     1.000    32.871
     1.100    35.642
     1.200    38.413
     1.300    41.184
     1.400    43.955
     1.500    46.726
     1.600    49.497
     1.700    52.268
     1.800    55.039
     1.900    57.810
     2.000    60.581
     2.100    63.352
     2.200    66.122
     2.300    68.893
     2.400    71.664
     2.500    74.435
     2.600    77.206
     2.700    79.978
     2.800    82.748
     2.900    85.518
     3.000    88.288
     3.100    91.059
     3.200    93.829
     3.300    96.600
     3.400    99.370
     3.500   102.140
     3.600   104.911
     3.700   107.681
     3.800   110.451
     3.900   113.221
     4.000   115.990
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   103.911 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.200    25.028
     1.300    26.408
     1.400    27.788
     1.500    29.168
     1.600    30.548
     1.700    31.928
     1.800    33.308
     1.900    34.688
     2.000    36.068
     2.100    37.448
     2.200    38.828
     2.300    40.208
     2.400    41.588
     2.500    42.968
     2.600    44.348
     2.700    45.728
     2.800    47.108
     2.900    48.488
     3.000    49.868
     3.100    51.248
     3.200    52.628
     3.300    54.008
     3.400    55.388
     3.500    56.768
     3.600    58.148
     3.700    59.528
     3.800    60.908
     3.900    62.287
     4.000    63.667
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.917
     0.200     3.834
     0.300     5.751
     0.400     7.668
     0.500     9.585
     0.600    11.502
     0.700    13.419
     0.800    15.337
     0.900    17.254
     1.000    19.171
     1.100    21.088
     1.200    23.005
     1.300    24.633
     1.400    26.240
     1.500    27.846
     1.600    29.452
     1.700    31.059
     1.800    32.665
     1.900    34.271
     2.000    35.878
     2.100    37.484
     2.200    39.091
     2.300    40.697
     2.400    42.303
     2.500    43.910
     2.600    45.516
     2.700    47.122
     2.800    48.729
     2.900    50.335
     3.000    51.941
     3.100    53.547
     3.200    55.153
     3.300    56.759
     3.400    58.365
     3.500    59.971
     3.600    61.577
     3.700    63.183
     3.800    64.789
     3.900    66.394
     4.000    68.000
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.300    45.694
     1.400    48.158
     1.500    50.622
     1.600    53.086
     1.700    55.551
     1.800    58.015
     1.900    60.479
     2.000    62.943
     2.100    65.408
     2.200    67.872
     2.300    70.336
     2.400    72.800
     2.500    75.265
     2.600    77.729
     2.700    80.193
     2.800    82.657
     2.900    85.122
     3.000    87.586
     3.100    90.050
     3.200    92.514
     3.300    94.979
     3.400    97.442
     3.500    99.906
     3.600   102.369
     3.700   104.833
     3.800   107.296
     3.900   109.759
     4.000   112.222
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.319
     0.200     6.638
     0.300     9.957
     0.400    13.276
     0.500    16.595
     0.600    19.915
     0.700    23.234
     0.800    26.553
     0.900    29.872
     1.000    33.191
     1.100    36.510
     1.200    39.801
     1.300    42.572
     1.400    45.343
     1.500    48.114
     1.600    50.885
     1.700    53.656
     1.800    56.427
     1.900    59.198
     2.000    61.969
     2.100    64.740
     2.200    67.511
     2.300    70.282
     2.400    73.053
     2.500    75.824
     2.600    78.595
     2.700    81.366
     2.800    84.137
     2.900    86.907
     3.000    89.677
     3.100    92.448
     3.200    95.218
     3.300    97.988
     3.400   100.759
     3.500   103.529
     3.600   106.300
     3.700   109.070
     3.800   111.840
     3.900   114.610
     4.000   117.380
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    16.378
     0.900    17.758
     1.000    19.138
     1.100    20.518
     1.200    21.898
     1.300    23.278
     1.400    24.658
     1.500    26.038
     1.600    27.418
     1.700    28.798
     1.800    30.178
     1.900    31.558
     2.000    32.938
     2.100    34.318
     2.200    35.698
     2.300    37.078
     2.400    38.458
     2.500    39.838
     2.600    41.218
     2.700    42.598
     2.800    43.978
     2.900    45.358
     3.000    46.738
     3.100    48.118
     3.200    49.498
     3.300    50.878
     3.400    52.258
     3.500    53.638
     3.600    55.017
     3.700    56.397
     3.800    57.777
     3.900    59.156
     4.000    60.536
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.219
     0.200     6.079
     0.300     7.282
     0.400     8.673
     0.500    10.162
     0.600    11.700
     0.700    13.265
     0.800    14.843
     0.900    16.429
     1.000    18.020
     1.100    19.615
     1.200    21.211
     1.300    22.810
     1.400    24.409
     1.500    26.010
     1.600    27.611
     1.700    29.212
     1.800    30.814
     1.900    32.417
     2.000    34.019
     2.100    35.622
     2.200    37.225
     2.300    38.829
     2.400    40.432
     2.500    42.036
     2.600    43.639
     2.700    45.243
     2.800    46.847
     2.900    48.450
     3.000    50.054
     3.100    51.658
     3.200    53.262
     3.300    54.866
     3.400    56.470
     3.500    58.074
     3.600    59.678
     3.700    61.282
     3.800    62.886
     3.900    64.489
     4.000    66.093
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    33.169
     1.100    35.633
     1.200    38.097
     1.300    40.562
     1.400    43.026
     1.500    45.490
     1.600    47.954
     1.700    50.419
     1.800    52.883
     1.900    55.347
     2.000    57.811
     2.100    60.276
     2.200    62.740
     2.300    65.204
     2.400    67.668
     2.500    70.133
     2.600    72.597
     2.700    75.061
     2.800    77.525
     2.900    79.990
     3.000    82.454
     3.100    84.917
     3.200    87.380
     3.300    89.844
     3.400    92.307
     3.500    94.770
     3.600    97.233
     3.700    99.696
     3.800   102.159
     3.900   104.623
     4.000   107.085
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     9.026
     0.200    10.513
     0.300    12.591
     0.400    14.994
     0.500    17.565
     0.600    20.220
     0.700    22.920
     0.800    25.643
     0.900    28.379
     1.000    31.124
     1.100    33.874
     1.200    36.629
     1.300    39.386
     1.400    42.145
     1.500    44.906
     1.600    47.668
     1.700    50.431
     1.800    53.194
     1.900    55.958
     2.000    58.723
     2.100    61.488
     2.200    64.253
     2.300    67.019
     2.400    69.785
     2.500    72.551
     2.600    75.317
     2.700    78.084
     2.800    80.850
     2.900    83.617
     3.000    86.384
     3.100    89.150
     3.200    91.917
     3.300    94.684
     3.400    97.451
     3.500   100.217
     3.600   102.984
     3.700   105.751
     3.800   108.517
     3.900   111.284
     4.000   114.051
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.493    27.734     0.200
     1.362    23.500     0.200
     1.609    28.482     0.200
     1.397    26.586     0.200
     1.405    24.938     0.200
     1.522    27.805     0.200
     1.547    27.928     0.200
     1.465    25.750     0.200
     1.414    24.797     0.200
     1.481    26.527     0.200
     1.738    29.984     0.200
     1.368    24.141     0.200
     1.605    28.872     0.200
     1.604    28.285     0.200
     1.298    23.775     0.200
     1.726    30.638     0.200
     1.315    23.557     0.200
     1.523    27.047     0.200
     1.531    26.891     0.200
     1.291    22.564     0.200
     1.689    28.453     0.200
     1.307    22.844     0.200
     1.428    25.156     0.200
     1.482    26.109     0.200
     1.434    27.367     0.200
     1.491    27.883     0.200
     1.120    20.680     0.200
     1.385    25.297     0.200
     1.188    21.270     0.200
     1.446    25.584     0.200
     1.197    21.383     0.200
     1.204    22.871     0.200
     1.305    23.848     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.493    48.453     0.200
     1.738    53.719     0.200
     1.307    41.152     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.291    42.504     0.200
     1.689    49.633     0.200
     1.222    38.219     0.200
     1.228    37.727     0.200
     1.227    37.875     0.200
     1.120    35.250     0.200
     1.385    41.844     0.200
     1.434    45.090     0.200
     1.160    35.616     0.200
     1.204    37.531     0.200
     1.305    39.867     0.200
     1.222    38.277     0.200
     1.355    41.312     0.200
     1.367    42.582     0.200
     1.212    37.664     0.200
     1.226    37.172     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.291    42.504     0.200
     1.689    49.633     0.200
     1.222    38.219     0.200
     1.228    37.727     0.200
     1.227    37.875     0.200
     1.120    35.250     0.200
     1.385    41.844     0.200
     1.434    45.090     0.200
     1.160    35.616     0.200
     1.204    37.531     0.200
     1.305    39.867     0.200
     1.222    38.277     0.200
     1.355    41.312     0.200
     1.367    42.582     0.200
     1.212    37.664     0.200
     1.226    37.172     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
