#!/bin/bash
gmt begin hubbard5.7_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance hubbard5.7'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.1  0.000
  1.1 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.100    22.636
     1.200    24.016
     1.300    25.396
     1.400    26.776
     1.500    28.156
     1.600    29.536
     1.700    30.916
     1.800    32.296
     1.900    33.676
     2.000    35.056
     2.100    36.436
     2.200    37.816
     2.300    39.196
     2.400    40.576
     2.500    41.956
     2.600    43.336
     2.700    44.716
     2.800    46.096
     2.900    47.476
     3.000    48.856
     3.100    50.236
     3.200    51.617
     3.300    52.997
     3.400    54.377
     3.500    55.757
     3.600    57.136
     3.700    58.516
     3.800    59.895
     3.900    61.275
     4.000    62.655
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    55.136 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.408
     0.200     4.100
     0.300     5.930
     0.400     7.801
     0.500     9.690
     0.600    11.588
     0.700    13.490
     0.800    15.396
     0.900    17.304
     1.000    19.019
     1.100    20.625
     1.200    22.232
     1.300    23.838
     1.400    25.445
     1.500    27.051
     1.600    28.657
     1.700    30.264
     1.800    31.870
     1.900    33.476
     2.000    35.083
     2.100    36.689
     2.200    38.296
     2.300    39.902
     2.400    41.508
     2.500    43.115
     2.600    44.721
     2.700    46.327
     2.800    47.934
     2.900    49.540
     3.000    51.146
     3.100    52.751
     3.200    54.357
     3.300    55.963
     3.400    57.569
     3.500    59.175
     3.600    60.781
     3.700    62.387
     3.800    63.993
     3.900    65.599
     4.000    67.204
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    59.781 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.300    44.003
     1.400    46.467
     1.500    48.931
     1.600    51.395
     1.700    53.860
     1.800    56.324
     1.900    58.788
     2.000    61.252
     2.100    63.717
     2.200    66.181
     2.300    68.645
     2.400    71.109
     2.500    73.574
     2.600    76.038
     2.700    78.502
     2.800    80.966
     2.900    83.431
     3.000    85.895
     3.100    88.359
     3.200    90.823
     3.300    93.287
     3.400    95.751
     3.500    98.215
     3.600   100.678
     3.700   103.141
     3.800   105.604
     3.900   108.067
     4.000   110.530
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    98.678 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.169
     0.200     7.099
     0.300    10.267
     0.400    13.506
     0.500    16.777
     0.600    20.062
     0.700    23.356
     0.800    26.656
     0.900    29.960
     1.000    32.871
     1.100    35.642
     1.200    38.413
     1.300    41.184
     1.400    43.955
     1.500    46.726
     1.600    49.497
     1.700    52.268
     1.800    55.039
     1.900    57.810
     2.000    60.581
     2.100    63.352
     2.200    66.122
     2.300    68.893
     2.400    71.664
     2.500    74.435
     2.600    77.206
     2.700    79.978
     2.800    82.748
     2.900    85.518
     3.000    88.288
     3.100    91.059
     3.200    93.829
     3.300    96.600
     3.400    99.370
     3.500   102.140
     3.600   104.911
     3.700   107.681
     3.800   110.451
     3.900   113.221
     4.000   115.990
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   103.911 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.200    25.028
     1.300    26.408
     1.400    27.788
     1.500    29.168
     1.600    30.548
     1.700    31.928
     1.800    33.308
     1.900    34.688
     2.000    36.068
     2.100    37.448
     2.200    38.828
     2.300    40.208
     2.400    41.588
     2.500    42.968
     2.600    44.348
     2.700    45.728
     2.800    47.108
     2.900    48.488
     3.000    49.868
     3.100    51.248
     3.200    52.628
     3.300    54.008
     3.400    55.388
     3.500    56.768
     3.600    58.148
     3.700    59.528
     3.800    60.908
     3.900    62.287
     4.000    63.667
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.917
     0.200     3.834
     0.300     5.751
     0.400     7.668
     0.500     9.585
     0.600    11.502
     0.700    13.419
     0.800    15.337
     0.900    17.254
     1.000    19.171
     1.100    21.088
     1.200    23.005
     1.300    24.633
     1.400    26.240
     1.500    27.846
     1.600    29.452
     1.700    31.059
     1.800    32.665
     1.900    34.271
     2.000    35.878
     2.100    37.484
     2.200    39.091
     2.300    40.697
     2.400    42.303
     2.500    43.910
     2.600    45.516
     2.700    47.122
     2.800    48.729
     2.900    50.335
     3.000    51.941
     3.100    53.547
     3.200    55.153
     3.300    56.759
     3.400    58.365
     3.500    59.971
     3.600    61.577
     3.700    63.183
     3.800    64.789
     3.900    66.394
     4.000    68.000
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.300    45.694
     1.400    48.158
     1.500    50.622
     1.600    53.086
     1.700    55.551
     1.800    58.015
     1.900    60.479
     2.000    62.943
     2.100    65.408
     2.200    67.872
     2.300    70.336
     2.400    72.800
     2.500    75.265
     2.600    77.729
     2.700    80.193
     2.800    82.657
     2.900    85.122
     3.000    87.586
     3.100    90.050
     3.200    92.514
     3.300    94.979
     3.400    97.442
     3.500    99.906
     3.600   102.369
     3.700   104.833
     3.800   107.296
     3.900   109.759
     4.000   112.222
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.319
     0.200     6.638
     0.300     9.957
     0.400    13.276
     0.500    16.595
     0.600    19.915
     0.700    23.234
     0.800    26.553
     0.900    29.872
     1.000    33.191
     1.100    36.510
     1.200    39.801
     1.300    42.572
     1.400    45.343
     1.500    48.114
     1.600    50.885
     1.700    53.656
     1.800    56.427
     1.900    59.198
     2.000    61.969
     2.100    64.740
     2.200    67.511
     2.300    70.282
     2.400    73.053
     2.500    75.824
     2.600    78.595
     2.700    81.366
     2.800    84.137
     2.900    86.907
     3.000    89.677
     3.100    92.448
     3.200    95.218
     3.300    97.988
     3.400   100.759
     3.500   103.529
     3.600   106.300
     3.700   109.070
     3.800   111.840
     3.900   114.610
     4.000   117.380
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    16.378
     0.900    17.758
     1.000    19.138
     1.100    20.518
     1.200    21.898
     1.300    23.278
     1.400    24.658
     1.500    26.038
     1.600    27.418
     1.700    28.798
     1.800    30.178
     1.900    31.558
     2.000    32.938
     2.100    34.318
     2.200    35.698
     2.300    37.078
     2.400    38.458
     2.500    39.838
     2.600    41.218
     2.700    42.598
     2.800    43.978
     2.900    45.358
     3.000    46.738
     3.100    48.118
     3.200    49.498
     3.300    50.878
     3.400    52.258
     3.500    53.638
     3.600    55.017
     3.700    56.397
     3.800    57.777
     3.900    59.156
     4.000    60.536
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.219
     0.200     6.079
     0.300     7.282
     0.400     8.673
     0.500    10.162
     0.600    11.700
     0.700    13.265
     0.800    14.843
     0.900    16.429
     1.000    18.020
     1.100    19.615
     1.200    21.211
     1.300    22.810
     1.400    24.409
     1.500    26.010
     1.600    27.611
     1.700    29.212
     1.800    30.814
     1.900    32.417
     2.000    34.019
     2.100    35.622
     2.200    37.225
     2.300    38.829
     2.400    40.432
     2.500    42.036
     2.600    43.639
     2.700    45.243
     2.800    46.847
     2.900    48.450
     3.000    50.054
     3.100    51.658
     3.200    53.262
     3.300    54.866
     3.400    56.470
     3.500    58.074
     3.600    59.678
     3.700    61.282
     3.800    62.886
     3.900    64.489
     4.000    66.093
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    33.169
     1.100    35.633
     1.200    38.097
     1.300    40.562
     1.400    43.026
     1.500    45.490
     1.600    47.954
     1.700    50.419
     1.800    52.883
     1.900    55.347
     2.000    57.811
     2.100    60.276
     2.200    62.740
     2.300    65.204
     2.400    67.668
     2.500    70.133
     2.600    72.597
     2.700    75.061
     2.800    77.525
     2.900    79.990
     3.000    82.454
     3.100    84.917
     3.200    87.380
     3.300    89.844
     3.400    92.307
     3.500    94.770
     3.600    97.233
     3.700    99.696
     3.800   102.159
     3.900   104.623
     4.000   107.085
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     9.026
     0.200    10.513
     0.300    12.591
     0.400    14.994
     0.500    17.565
     0.600    20.220
     0.700    22.920
     0.800    25.643
     0.900    28.379
     1.000    31.124
     1.100    33.874
     1.200    36.629
     1.300    39.386
     1.400    42.145
     1.500    44.906
     1.600    47.668
     1.700    50.431
     1.800    53.194
     1.900    55.958
     2.000    58.723
     2.100    61.488
     2.200    64.253
     2.300    67.019
     2.400    69.785
     2.500    72.551
     2.600    75.317
     2.700    78.084
     2.800    80.850
     2.900    83.617
     3.000    86.384
     3.100    89.150
     3.200    91.917
     3.300    94.684
     3.400    97.451
     3.500   100.217
     3.600   102.984
     3.700   105.751
     3.800   108.517
     3.900   111.284
     4.000   114.051
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.284    39.068     0.200
     3.804    60.068     0.200
     4.934    75.869     0.200
     7.988   115.969     0.200
     8.373   121.668     0.200
     8.639   125.869     0.200
     9.771   143.568     0.200
    10.804   156.369     0.200
    12.246   174.568     0.200
    13.206   189.068     0.200
    15.870   223.768     0.200
    20.396   280.469     0.200
     3.750    58.789     0.200
     3.806    58.086     0.200
     4.839    73.586     0.200
     4.877    73.988     0.200
     5.013    76.488     0.200
     5.192    78.887     0.200
     5.238    79.887     0.200
     5.809    86.887     0.200
     6.107    93.887     0.200
     7.068   104.188     0.200
     7.150   106.988     0.200
     7.931   115.887     0.200
     8.317   119.988     0.200
     8.638   124.387     0.200
     8.715   127.789     0.200
    12.229   173.887     0.200
    12.291   174.188     0.200
    17.663   243.586     0.200
    18.826   261.688     0.200
    20.763   281.688     0.200
     3.557    54.814     0.200
     3.760    57.514     0.200
     4.920    75.314     0.200
     5.098    76.814     0.200
     5.105    77.514     0.200
     5.320    81.514     0.200
     5.734    85.814     0.200
     6.200    93.314     0.200
     7.161   104.814     0.200
     8.018   116.814     0.200
     8.394   121.314     0.200
     8.600   125.514     0.200
    12.205   174.314     0.200
    12.199   173.914     0.200
    15.840   223.715     0.200
    17.624   244.814     0.200
    18.568   257.715     0.200
    18.742   259.314     0.200
    19.821   274.314     0.200
    20.018   276.314     0.200
    20.348   278.814     0.200
    20.669   281.314     0.200
     3.547    54.602     0.200
     3.812    60.902     0.200
     3.764    57.504     0.200
     4.950    75.805     0.200
     5.089    76.805     0.200
     5.114    76.703     0.200
     5.741    86.402     0.200
     6.146    91.203     0.200
     6.146    91.305     0.200
     7.068   105.102     0.200
     7.151   103.703     0.200
     8.009   116.805     0.200
     8.386   121.703     0.200
     8.605   125.203     0.200
     8.761   128.602     0.200
     9.943   146.703     0.200
    12.194   173.805     0.200
    12.209   173.203     0.200
    15.850   223.305     0.200
    17.630   244.203     0.200
    18.562   257.703     0.200
    18.751   259.203     0.200
    20.025   275.305     0.200
    20.357   277.504     0.200
    20.679   281.402     0.200
     1.839    32.828     0.200
     2.124    37.148     0.200
     2.604    43.289     0.200
     2.734    45.156     0.200
     3.005    48.609     0.200
     3.275    52.312     0.200
     3.554    56.672     0.200
     3.641    58.109     0.200
     3.645    57.852     0.200
     3.653    57.852     0.200
     3.703    60.750     0.200
     3.736    58.570     0.200
     3.926    62.453     0.200
     3.967    61.578     0.200
     4.234    65.562     0.200
     4.997    75.453     0.200
     5.062    77.250     0.200
     6.206    94.750     0.200
     7.277   105.750     0.200
     8.558   124.750     0.200
     8.832   130.750     0.200
     1.757    28.316     0.200
     1.845    30.258     0.200
     2.453    38.879     0.200
     2.574    40.926     0.200
     2.662    41.848     0.200
     3.206    48.957     0.200
     3.511    54.219     0.200
     3.590    54.469     0.200
     3.692    57.566     0.200
     3.693    57.176     0.200
     3.861    59.086     0.200
     3.879    59.867     0.200
     3.997    61.367     0.200
     4.119    62.406     0.200
     4.220    64.426     0.200
     4.260    64.418     0.200
     4.702    70.309     0.200
     4.708    70.867     0.200
     4.840    71.586     0.200
     4.960    74.086     0.200
     5.010    74.227     0.200
     5.010    75.367     0.200
     4.987    73.066     0.200
     5.043    73.977     0.200
     5.146    76.867     0.200
     5.372    80.566     0.200
     5.413    79.309     0.200
     5.607    82.355     0.200
     5.607    81.828     0.200
     5.677    84.168     0.200
     5.743    85.309     0.200
     6.012    88.398     0.200
     6.187    91.809     0.200
     6.209    91.488     0.200
     6.393    93.047     0.200
     6.408    94.078     0.200
     6.487    94.527     0.200
     6.476    95.258     0.200
     6.507    95.406     0.200
     6.641    96.996     0.200
     6.668    97.656     0.200
     6.669    97.926     0.200
     6.670    97.695     0.200
     6.695    98.496     0.200
     6.751    98.398     0.200
     6.797    99.547     0.200
     6.816    99.129     0.200
     6.851   100.637     0.200
     6.885   100.816     0.200
     6.990   102.188     0.200
     7.139   104.176     0.200
     7.147   104.438     0.200
     7.150   103.477     0.200
     7.162   105.336     0.200
     7.179   103.566     0.200
     7.351   106.816     0.200
     8.064   114.195     0.200
     8.650   125.508     0.200
     1.733    28.410     0.200
     1.825    30.480     0.200
     2.437    39.090     0.200
     2.524    39.578     0.200
     2.550    41.090     0.200
     2.646    41.777     0.200
     3.190    48.957     0.200
     3.489    54.070     0.200
     3.573    54.578     0.200
     3.570    54.449     0.200
     3.721    56.398     0.200
     3.836    58.957     0.200
     3.855    59.879     0.200
     3.972    61.379     0.200
     4.092    62.148     0.200
     4.192    64.148     0.200
     4.238    64.277     0.200
     4.680    70.309     0.200
     4.729    71.180     0.200
     4.823    71.438     0.200
     4.939    74.020     0.200
     4.971    73.188     0.200
     4.990    74.219     0.200
     4.990    75.660     0.200
     5.029    74.379     0.200
     5.127    77.078     0.200
     5.351    80.578     0.200
     5.397    79.160     0.200
     5.582    82.277     0.200
     5.580    83.707     0.200
     5.723    85.438     0.200
     5.699    84.680     0.200
     6.000    88.418     0.200
     6.120    89.070     0.200
     6.181    91.918     0.200
     6.162    91.391     0.200
     6.188    91.570     0.200
     6.189    91.270     0.200
     6.375    92.328     0.200
     6.389    94.668     0.200
     6.417    94.020     0.200
     6.458    94.180     0.200
     6.476    94.660     0.200
     6.462    95.777     0.200
     6.488    94.488     0.200
     6.614    96.559     0.200
     6.625    96.930     0.200
     6.652    97.328     0.200
     6.654    98.000     0.200
     6.654    98.160     0.200
     6.679    98.367     0.200
     6.735    98.688     0.200
     6.783    99.410     0.200
     6.807    99.258     0.200
     6.836   100.160     0.200
     6.871   100.789     0.200
     6.977   102.598     0.200
     7.130   106.250     0.200
     7.136   105.730     0.200
     7.173   103.559     0.200
     7.340   107.000     0.200
     7.625   110.391     0.200
     8.046   115.008     0.200
     8.428   120.250     0.200
     2.433    40.039     0.200
     2.541    42.070     0.200
     2.641    43.242     0.200
     3.184    50.555     0.200
     3.481    55.250     0.200
     3.564    56.523     0.200
     3.846    60.922     0.200
     4.736    72.320     0.200
     2.401    40.988     0.200
     2.365    39.518     0.200
     3.042    48.288     0.200
     3.313    53.408     0.200
     3.411    53.588     0.200
     3.405    53.008     0.200
     3.416    54.678     0.200
     3.496    55.448     0.200
     3.841    61.338     0.200
     4.098    63.408     0.200
     4.467    68.908     0.200
     4.506    69.528     0.200
     4.895    73.578     0.200
     5.554    84.478     0.200
     1.919    32.082     0.200
     2.009    34.281     0.200
     2.263    37.281     0.200
     2.263    37.082     0.200
     2.585    42.281     0.200
     2.643    43.281     0.200
     2.752    44.281     0.200
     2.795    45.781     0.200
     3.072    48.621     0.200
     3.404    52.555     0.200
     3.502    56.281     0.200
     3.678    56.684     0.200
     3.731    59.383     0.200
     3.747    58.484     0.200
     3.832    59.281     0.200
     4.057    62.281     0.200
     4.170    63.434     0.200
     4.647    70.383     0.200
     4.868    73.734     0.200
     4.930    75.332     0.200
     5.169    76.793     0.200
     2.338    39.559     0.200
     2.386    40.379     0.200
     2.434    41.160     0.200
     2.545    42.461     0.200
     2.816    46.160     0.200
     3.093    49.809     0.200
     3.375    54.559     0.200
     3.460    56.160     0.200
     3.550    55.879     0.200
     3.739    60.160     0.200
     3.780    59.309     0.200
     3.833    58.480     0.200
     3.914    62.328     0.200
     4.152    65.059     0.200
     4.381    67.711     0.200
     4.567    69.438     0.200
     4.827    72.871     0.200
     4.842    74.160     0.200
     4.870    73.090     0.200
     5.196    78.230     0.200
     5.726    84.711     0.200
     5.726    84.730     0.200
     6.078    89.148     0.200
     7.609   112.410     0.200
     8.664   124.391     0.200
     1.953    34.094     0.200
     2.627    43.695     0.200
     2.759    45.391     0.200
     2.837    46.992     0.200
     3.384    54.195     0.200
     3.524    58.016     0.200
     3.697    58.492     0.200
     3.742    59.789     0.200
     3.768    59.094     0.200
     3.774    58.695     0.200
     4.064    63.789     0.200
     4.086    64.195     0.200
     4.418    67.195     0.200
     4.463    70.492     0.200
     4.684    71.195     0.200
     4.838    74.094     0.200
     5.162    77.695     0.200
     5.213    77.992     0.200
     5.588    83.891     0.200
     5.926    91.094     0.200
     5.942    89.992     0.200
     6.175    92.289     0.200
     6.371    95.594     0.200
     2.276    39.102     0.200
     2.391    40.969     0.200
     2.749    45.469     0.200
     3.019    48.719     0.200
     3.389    54.953     0.200
     3.641    58.570     0.200
     3.942    61.102     0.200
     4.794    74.859     0.200
     4.941    75.969     0.200
     5.156    80.070     0.200
     5.274    80.125     0.200
     7.103   104.773     0.200
     8.223   120.273     0.200
     2.323    38.926     0.200
     2.386    39.896     0.200
     2.376    39.826     0.200
     2.434    40.176     0.200
     2.530    41.906     0.200
     2.797    45.176     0.200
     3.018    48.086     0.200
     3.336    52.377     0.200
     3.429    54.076     0.200
     3.441    54.176     0.200
     3.520    53.777     0.200
     3.690    57.576     0.200
     3.898    58.977     0.200
     4.132    63.176     0.200
     4.491    68.877     0.200
     5.224    78.426     0.200
     5.576    83.977     0.200
     2.373    39.277     0.200
     2.328    39.258     0.200
     2.394    39.590     0.200
     2.438    39.859     0.200
     2.535    41.848     0.200
     2.803    45.348     0.200
     3.343    52.559     0.200
     3.360    54.160     0.200
     3.435    54.160     0.200
     3.447    54.457     0.200
     3.527    54.359     0.200
     3.698    58.258     0.200
     3.761    58.758     0.200
     3.889    59.137     0.200
     4.090    62.660     0.200
     4.137    62.660     0.200
     4.363    65.859     0.200
     4.498    68.160     0.200
     4.536    68.340     0.200
     4.700    70.660     0.200
     4.797    71.758     0.200
     4.926    72.957     0.200
     5.218    77.109     0.200
     5.213    79.059     0.200
     5.590    84.559     0.200
     5.853    88.559     0.200
     5.908    88.559     0.200
     6.330    93.359     0.200
     8.518   123.758     0.200
    12.167   173.059     0.200
     2.416    40.836     0.200
     3.163    50.836     0.200
     3.266    52.436     0.200
     3.440    55.537     0.200
     3.531    56.537     0.200
     3.539    56.336     0.200
     3.581    58.537     0.200
     3.574    56.037     0.200
     3.797    61.537     0.200
     3.854    59.936     0.200
     3.898    62.936     0.200
     3.797    58.637     0.200
     4.188    65.637     0.200
     4.633    71.736     0.200
     4.947    77.137     0.200
     5.123    78.865     0.200
     5.757    86.035     0.200
     6.109    94.307     0.200
     7.183   105.236     0.200
     8.014   117.537     0.200
     7.908   114.355     0.200
     8.378   122.637     0.200
     8.547   124.486     0.200
    12.110   172.885     0.200
     2.425    40.551     0.200
     2.523    41.852     0.200
     3.175    50.152     0.200
     3.828    60.852     0.200
     3.754    59.254     0.200
     4.969    77.051     0.200
     5.106    77.051     0.200
     5.331    81.754     0.200
     5.802    87.504     0.200
     6.153    92.961     0.200
     7.173   104.152     0.200
     7.203   105.152     0.200
     8.404   122.051     0.200
     8.596   124.926     0.200
    12.126   172.402     0.200
     1.835    32.852     0.200
     2.296    38.721     0.200
     2.652    44.551     0.200
     2.803    46.041     0.200
     3.306    53.842     0.200
     3.394    53.842     0.200
     3.606    55.461     0.200
     4.088    65.650     0.200
     5.012    76.551     0.200
     5.012    77.531     0.200
     2.446    41.145     0.200
     2.546    42.414     0.200
     2.654    43.965     0.200
     2.707    44.766     0.200
     3.194    51.406     0.200
     3.298    53.375     0.200
     3.827    61.977     0.200
     3.908    62.996     0.200
     3.771    57.777     0.200
     4.979    76.266     0.200
     5.123    78.676     0.200
     5.189    78.484     0.200
     5.092    77.527     0.200
     5.341    82.477     0.200
     5.755    88.125     0.200
     5.783    86.277     0.200
     6.136    91.824     0.200
     7.209   105.676     0.200
     7.239   105.457     0.200
     7.634   112.754     0.200
     8.410   121.824     0.200
     8.550   125.375     0.200
     8.733   127.547     0.200
     8.760   129.535     0.200
    12.081   173.137     0.200
    12.086   173.320     0.200
     2.530    41.578     0.200
     2.218    37.438     0.200
     2.302    38.078     0.200
     2.428    40.523     0.200
     2.511    41.312     0.200
     3.102    49.438     0.200
     3.293    52.594     0.200
     3.677    58.367     0.200
     3.676    58.273     0.200
     3.994    62.672     0.200
     4.045    62.992     0.200
     4.739    72.219     0.200
     5.303    80.602     0.200
     5.303    80.727     0.200
     5.636    86.297     0.200
     6.063    93.914     0.200
     3.059    46.594     0.200
     3.709    57.891     0.200
     3.898    60.254     0.200
     3.898    60.391     0.200
     3.861    59.152     0.200
     4.352    67.273     0.200
     4.849    73.531     0.200
     4.990    76.594     0.200
     5.224    78.223     0.200
     5.224    77.992     0.200
     5.648    85.223     0.200
     5.698    82.594     0.200
     6.047    89.121     0.200
     8.284   119.293     0.200
     8.573   122.902     0.200
     8.573   123.191     0.200
     8.573   123.594     0.200
     8.546   124.992     0.200
     8.662   126.492     0.200
    12.201   171.594     0.200
    12.201   172.594     0.200
    12.206   172.887     0.200
     2.447    41.449     0.200
     3.011    49.309     0.200
     3.855    61.461     0.200
     3.855    61.730     0.200
     1.562    28.141     0.200
     1.723    29.859     0.200
     2.288    39.180     0.200
     2.542    41.273     0.200
     2.791    44.641     0.200
     3.156    50.648     0.200
     3.198    50.508     0.200
     3.307    52.500     0.200
     3.496    55.594     0.200
     3.507    56.992     0.200
     3.563    55.852     0.200
     3.572    55.930     0.200
     3.576    56.094     0.200
     3.595    55.719     0.200
     3.682    57.414     0.200
     3.746    56.398     0.200
     3.746    57.508     0.200
     3.892    60.109     0.200
     3.941    62.523     0.200
     3.941    62.625     0.200
     4.072    63.312     0.200
     4.163    64.742     0.200
     4.233    65.852     0.200
     4.251    64.648     0.200
     4.471    70.164     0.200
     4.635    71.625     0.200
     4.677    71.102     0.200
     4.677    71.484     0.200
     4.937    75.211     0.200
     4.989    76.203     0.200
     5.042    75.320     0.200
     5.085    76.680     0.200
     5.085    76.570     0.200
     5.196    78.344     0.200
     5.351    82.375     0.200
     5.407    80.398     0.200
     5.416    83.383     0.200
     5.567    84.594     0.200
     5.727    87.000     0.200
     5.776    87.203     0.200
     5.776    87.344     0.200
     5.809    85.852     0.200
     5.809    85.703     0.200
     5.801    85.875     0.200
     5.984    90.594     0.200
     6.149    92.148     0.200
     6.161    93.703     0.200
     6.161    93.125     0.200
     6.221    92.164     0.200
     6.249    93.391     0.200
     6.274    94.094     0.200
     6.324    91.922     0.200
     6.449    96.945     0.200
     6.623    97.164     0.200
     6.662    98.102     0.200
     6.664    98.445     0.200
     6.744    99.141     0.200
     6.795   101.242     0.200
     6.829   101.078     0.200
     6.849   101.930     0.200
     6.886   101.680     0.200
     6.992   103.773     0.200
     7.120   105.648     0.200
     7.152   106.578     0.200
     7.167   106.719     0.200
     7.229   105.281     0.200
     7.642   112.664     0.200
     7.806   114.742     0.200
     8.031   117.180     0.200
     8.099   118.281     0.200
     8.119   118.094     0.200
     8.190   119.398     0.200
     8.422   121.852     0.200
     8.412   124.250     0.200
     8.574   125.328     0.200
     8.582   125.500     0.200
     8.757   127.305     0.200
     9.321   135.383     0.200
    10.133   147.773     0.200
    12.095   172.805     0.200
    12.095   173.164     0.200
    12.100   172.445     0.200
    14.031   198.828     0.200
    14.726   208.023     0.200
    15.244   217.070     0.200
    15.807   223.203     0.200
    15.990   223.281     0.200
    18.320   255.430     0.200
    18.742   261.273     0.200
    19.302   267.914     0.200
    19.574   269.812     0.200
    19.991   274.039     0.200
    20.052   276.680     0.200
    20.224   276.539     0.200
    20.214   276.578     0.200
    20.222   277.164     0.200
    20.632   280.805     0.200
     2.303    38.844     0.200
     2.303    38.523     0.200
     2.531    41.406     0.200
     2.792    44.797     0.200
     3.167    50.625     0.200
     3.190    50.414     0.200
     3.303    52.516     0.200
     3.503    55.719     0.200
     3.555    55.008     0.200
     3.567    55.406     0.200
     3.569    56.367     0.200
     3.582    55.125     0.200
     3.676    56.906     0.200
     3.739    57.273     0.200
     3.885    59.781     0.200
     3.957    62.422     0.200
     4.077    63.008     0.200
     4.171    64.219     0.200
     4.231    65.492     0.200
     4.241    64.195     0.200
     4.477    69.578     0.200
     4.674    71.477     0.200
     4.933    74.867     0.200
     4.985    75.875     0.200
     5.033    74.836     0.200
     5.091    76.547     0.200
     5.091    76.375     0.200
     5.091    76.148     0.200
     5.398    80.312     0.200
     5.410    82.688     0.200
     5.517    82.734     0.200
     5.561    83.172     0.200
     5.779    86.523     0.200
     5.790    85.375     0.200
     5.816    85.828     0.200
     5.816    85.727     0.200
     5.990    88.867     0.200
     6.150    91.625     0.200
     6.168    95.172     0.200
     6.168    91.617     0.200
     6.243    92.781     0.200
     6.318    93.188     0.200
     6.341    93.648     0.200
     6.382    94.914     0.200
     6.450    95.516     0.200
     6.615    97.984     0.200
     6.653    97.281     0.200
     6.655    98.617     0.200
     6.736    98.398     0.200
     6.786   100.047     0.200
     6.839   100.695     0.200
     6.876   101.031     0.200
     6.981   103.852     0.200
     7.109   105.812     0.200
     7.141   106.164     0.200
     7.184   105.523     0.200
     7.111   104.508     0.200
     7.215   105.188     0.200
     7.631   112.156     0.200
     7.678   113.172     0.200
     7.635   113.172     0.200
     7.794   114.406     0.200
     8.025   116.555     0.200
     8.087   117.531     0.200
     8.107   118.172     0.200
     8.100   118.422     0.200
     8.419   121.875     0.200
     8.423   123.648     0.200
     8.583   125.547     0.200
     8.601   125.297     0.200
     8.601   124.328     0.200
     8.601   125.492     0.200
     8.761   127.172     0.200
     8.788   129.172     0.200
     8.667   126.227     0.200
    10.128   147.523     0.200
    10.128   147.922     0.200
    12.111   171.188     0.200
    12.111   172.227     0.200
    12.116   171.617     0.200
    12.359   179.805     0.200
    12.865   186.375     0.200
    13.705   198.328     0.200
    13.736   198.945     0.200
    14.031   198.383     0.200
    14.723   207.773     0.200
    15.240   216.953     0.200
    15.814   223.055     0.200
    15.814   223.398     0.200
    15.976   223.062     0.200
    17.519   244.625     0.200
    18.875   263.203     0.200
    19.039   265.078     0.200
    19.992   274.188     0.200
    20.046   276.445     0.200
    20.208   275.773     0.200
    20.225   276.398     0.200
    20.644   280.977     0.200
     2.298    38.836     0.200
     2.533    41.562     0.200
     2.536    42.391     0.200
     2.795    45.008     0.200
     3.158    51.062     0.200
     3.190    50.648     0.200
     3.301    52.500     0.200
     3.555    54.992     0.200
     3.565    55.953     0.200
     3.746    59.000     0.200
     3.884    60.312     0.200
     3.947    62.609     0.200
     4.071    63.250     0.200
     4.228    65.672     0.200
     4.242    64.367     0.200
     4.470    69.336     0.200
     4.672    71.680     0.200
     4.931    75.391     0.200
     4.983    77.156     0.200
     5.091    76.961     0.200
     5.091    76.500     0.200
     5.091    77.258     0.200
     5.345    81.961     0.200
     5.399    81.086     0.200
     5.774    87.117     0.200
     5.792    86.117     0.200
     5.809    86.500     0.200
     5.809    87.062     0.200
     6.146    92.281     0.200
     6.242    93.398     0.200
     6.446    96.391     0.200
     6.654    98.828     0.200
     6.736    99.211     0.200
     6.983   103.492     0.200
     7.219   105.297     0.200
     7.668   113.477     0.200
     8.417   122.391     0.200
     8.755   126.859     0.200
    12.106   173.227     0.200
    12.110   172.758     0.200
     2.652    43.953     0.200
     2.800    45.523     0.200
     3.141    50.715     0.200
     3.193    51.023     0.200
     3.300    52.805     0.200
     3.483    55.793     0.200
     3.497    55.574     0.200
     3.560    55.773     0.200
     3.565    56.664     0.200
     3.571    57.164     0.200
     3.675    57.902     0.200
     3.758    59.293     0.200
     3.927    62.434     0.200
     3.927    62.863     0.200
     4.060    63.504     0.200
     4.149    64.395     0.200
     4.225    66.094     0.200
     4.248    65.234     0.200
     4.459    70.734     0.200
     4.628    71.922     0.200
     4.669    71.734     0.200
     4.929    75.785     0.200
     4.982    76.402     0.200
     5.090    78.539     0.200
     5.090    78.305     0.200
     5.190    78.762     0.200
     5.344    81.535     0.200
     5.403    81.941     0.200
     5.542    83.863     0.200
     5.662    85.672     0.200
     5.719    87.305     0.200
     5.765    87.672     0.200
     5.796    86.125     0.200
     5.796    85.613     0.200
     5.799    86.492     0.200
     6.015    90.742     0.200
     6.139    92.375     0.200
     6.210    92.203     0.200
     6.242    94.004     0.200
     6.318    95.434     0.200
     6.439    96.074     0.200
     6.618    98.812     0.200
     6.658    99.074     0.200
     6.660    99.293     0.200
     6.740    99.883     0.200
     6.845   101.562     0.200
     6.882   102.914     0.200
     7.133   105.055     0.200
     7.231   105.652     0.200
     7.650   113.383     0.200
     8.121   117.465     0.200
     8.211   120.191     0.200
     8.364   122.652     0.200
     8.414   125.691     0.200
     8.414   122.465     0.200
     8.463   123.535     0.200
     8.569   125.812     0.200
     8.569   124.785     0.200
     8.569   125.664     0.200
     8.561   125.113     0.200
     8.745   127.164     0.200
    10.144   148.562     0.200
    12.092   173.254     0.200
    12.092   174.363     0.200
    12.096   172.910     0.200
     2.530    43.117     0.200
     2.639    44.469     0.200
     2.819    46.539     0.200
     3.179    50.945     0.200
     3.121    51.195     0.200
     3.284    53.398     0.200
     3.779    59.938     0.200
     3.910    63.258     0.200
     3.910    63.406     0.200
     4.040    64.039     0.200
     4.129    65.367     0.200
     4.207    66.758     0.200
     4.652    72.438     0.200
     4.912    76.289     0.200
     6.119    92.656     0.200
     6.419    97.016     0.200
     7.631   114.148     0.200
     1.847    33.289     0.200
     1.884    33.520     0.200
     2.071    36.670     0.200
     2.295    40.459     0.200
     2.326    39.129     0.200
     2.575    43.270     0.200
     2.584    43.129     0.200
     2.942    49.549     0.200
     3.087    49.379     0.200
     3.165    50.990     0.200
     3.287    55.240     0.200
     3.327    53.879     0.200
     3.432    55.039     0.200
     3.745    59.070     0.200
     3.745    59.410     0.200
     3.872    61.119     0.200
     3.951    62.648     0.200
     4.072    64.000     0.200
     4.521    71.309     0.200
     4.521    69.648     0.200
     4.843    75.070     0.200
     5.067    77.760     0.200
     5.587    85.260     0.200
     5.964    90.070     0.200
    11.011   158.389     0.200
    11.622   167.020     0.200
     2.539    41.969     0.200
     2.792    44.711     0.200
     2.696    43.852     0.200
     2.714    44.133     0.200
     2.924    47.008     0.200
     2.946    48.547     0.200
     3.305    52.461     0.200
     3.945    62.227     0.200
     4.072    62.320     0.200
     4.164    65.070     0.200
     4.423    68.141     0.200
     4.490    69.031     0.200
     4.732    72.109     0.200
     5.087    76.742     0.200
     5.087    76.430     0.200
     4.987    76.820     0.200
     5.039    74.922     0.200
     5.257    78.570     0.200
     5.193    78.133     0.200
     5.404    80.117     0.200
     5.566    84.117     0.200
     5.723    85.844     0.200
     5.797    85.883     0.200
     5.776    87.797     0.200
     6.148    91.039     0.200
     6.162    88.922     0.200
     6.184    91.750     0.200
     6.246    91.750     0.200
     6.448    95.773     0.200
     6.723    98.891     0.200
     6.988   102.758     0.200
     7.225   105.703     0.200
     7.814   112.867     0.200
     8.107   118.227     0.200
     8.420   121.758     0.200
     8.587   125.219     0.200
     1.807    32.312     0.200
     1.899    33.203     0.200
     1.919    33.859     0.200
     2.208    36.812     0.200
     2.346    39.484     0.200
     2.117    36.359     0.200
     2.238    38.156     0.200
     3.140    50.805     0.200
     3.433    54.875     0.200
     1.855    32.648     0.200
     1.855    32.801     0.200
     1.960    33.520     0.200
     1.978    33.730     0.200
     2.057    35.059     0.200
     2.076    35.188     0.200
     2.131    36.719     0.200
     2.136    35.668     0.200
     2.418    40.879     0.200
     2.439    39.918     0.200
     2.491    40.578     0.200
     2.534    41.289     0.200
     2.534    41.410     0.200
     2.530    41.070     0.200
     2.986    47.199     0.200
     3.121    48.988     0.200
     3.315    52.270     0.200
     4.030    61.660     0.200
     4.030    62.551     0.200
     4.067    62.410     0.200
     4.124    62.961     0.200
     4.446    68.719     0.200
     2.255    38.702     0.200
     2.356    40.792     0.200
     2.612    43.112     0.200
     3.203    52.662     0.200
     3.876    62.292     0.200
     3.876    61.962     0.200
     4.571    70.722     0.200
     4.651    70.103     0.200
     5.095    77.712     0.200
     2.025    34.124     0.200
     2.021    35.144     0.200
     2.042    35.074     0.200
     2.139    36.104     0.200
     2.152    35.994     0.200
     2.299    38.004     0.200
     2.312    38.634     0.200
     2.400    38.943     0.200
     2.417    40.164     0.200
     2.507    40.914     0.200
     2.564    42.044     0.200
     2.777    44.773     0.200
     3.065    48.594     0.200
     3.156    50.264     0.200
     3.334    53.144     0.200
     3.898    60.934     0.200
     3.941    61.144     0.200
     3.941    60.134     0.200
     4.052    62.153     0.200
     4.083    63.184     0.200
     4.527    68.804     0.200
     4.663    71.403     0.200
     4.838    74.474     0.200
     5.044    76.044     0.200
     5.236    78.854     0.200
     6.006    88.124     0.200
     7.099   102.584     0.200
     1.843    32.193     0.200
     2.065    36.494     0.200
     2.106    36.014     0.200
     2.192    37.354     0.200
     2.270    38.893     0.200
     2.306    39.723     0.200
     2.338    39.264     0.200
     2.374    40.312     0.200
     2.912    47.033     0.200
     2.912    45.812     0.200
     3.063    49.062     0.200
     3.085    49.152     0.200
     3.189    50.982     0.200
     3.189    50.674     0.200
     3.293    51.973     0.200
     3.364    53.633     0.200
     3.387    54.793     0.200
     3.485    56.393     0.200
     3.485    55.674     0.200
     3.564    55.914     0.200
     3.857    59.803     0.200
     3.881    61.344     0.200
     3.956    61.902     0.200
     4.058    63.863     0.200
     4.058    62.543     0.200
     4.112    63.783     0.200
     4.319    67.854     0.200
     4.516    69.383     0.200
     4.557    70.244     0.200
     4.653    71.863     0.200
     4.870    75.883     0.200
     5.201    78.584     0.200
     5.201    78.463     0.200
     5.448    82.402     0.200
     5.608    86.703     0.200
     5.700    87.863     0.200
     5.988    89.934     0.200
     6.326    94.834     0.200
     6.874   103.584     0.200
     7.143   103.883     0.200
     7.578   112.062     0.200
     8.470   124.883     0.200
     8.518   124.594     0.200
     8.550   124.213     0.200
     8.550   123.973     0.200
    11.205   160.902     0.200
    12.168   172.354     0.200
    12.173   173.209     0.200
    12.173   173.104     0.200
     2.027    36.062     0.200
     2.042    37.533     0.200
     2.094    37.133     0.200
     2.180    37.982     0.200
     2.211    39.793     0.200
     2.253    39.633     0.200
     2.300    39.613     0.200
     2.325    40.213     0.200
     2.342    40.123     0.200
     2.384    41.104     0.200
     2.529    43.322     0.200
     2.572    44.223     0.200
     2.736    45.684     0.200
     2.762    45.223     0.200
     2.772    46.053     0.200
     3.147    51.562     0.200
     3.110    52.002     0.200
     3.110    52.943     0.200
     3.531    57.572     0.200
     3.646    58.863     0.200
     3.858    61.973     0.200
     3.858    62.373     0.200
     3.959    63.383     0.200
     4.137    64.963     0.200
     4.137    66.332     0.200
     4.276    67.713     0.200
     4.661    72.523     0.200
     4.987    77.453     0.200
     5.022    76.863     0.200
     2.037    36.637     0.200
     2.023    36.396     0.200
     2.127    37.646     0.200
     2.169    38.307     0.200
     2.314    40.146     0.200
     2.303    40.438     0.200
     2.379    42.447     0.200
     2.385    41.486     0.200
     2.520    43.496     0.200
     2.564    43.756     0.200
     2.952    48.496     0.200
     3.016    50.377     0.200
     3.016    49.996     0.200
     3.327    54.826     0.200
     3.334    55.518     0.200
     3.340    54.098     0.200
     2.325    40.035     0.200
     3.982    63.055     0.200
     2.048    34.844     0.200
     2.076    35.516     0.200
     2.146    36.656     0.200
     2.163    36.883     0.200
     2.310    38.516     0.200
     2.400    40.117     0.200
     2.405    40.258     0.200
     2.405    40.477     0.200
     2.573    42.008     0.200
     2.811    46.406     0.200
     2.931    46.406     0.200
     2.931    47.531     0.200
     3.063    48.703     0.200
     3.063    49.195     0.200
     3.066    48.117     0.200
     3.058    48.133     0.200
     3.164    50.703     0.200
     3.164    50.469     0.200
     3.342    52.695     0.200
     3.379    53.953     0.200
     3.312    51.438     0.200
     3.425    54.562     0.200
     3.435    55.562     0.200
     3.707    58.242     0.200
     3.750    59.008     0.200
     3.892    61.562     0.200
     3.892    61.172     0.200
     4.020    62.531     0.200
     4.053    62.547     0.200
     4.091    62.695     0.200
     4.315    65.875     0.200
     4.351    66.703     0.200
     4.492    67.492     0.200
     4.535    69.234     0.200
     4.659    70.023     0.200
     4.794    72.883     0.200
     5.054    75.953     0.200
     5.693    84.578     0.200
     5.826    87.398     0.200
     5.885    87.797     0.200
     6.044    89.953     0.200
     6.312    93.547     0.200
     6.583    98.367     0.200
     6.605    98.273     0.200
     7.052   103.828     0.200
     7.112   103.664     0.200
     7.587   111.906     0.200
     8.281   119.984     0.200
     8.465   122.523     0.200
     2.144    37.264     0.200
     2.169    38.273     0.200
     2.169    38.004     0.200
     2.175    37.135     0.200
     2.180    37.654     0.200
     2.267    38.844     0.200
     2.267    39.104     0.200
     2.326    39.705     0.200
     2.326    39.527     0.200
     2.417    40.924     0.200
     2.508    42.135     0.200
     2.522    42.645     0.200
     2.537    43.584     0.200
     2.537    43.129     0.200
     2.625    44.795     0.200
     2.670    44.094     0.200
     2.691    44.514     0.200
     2.691    44.309     0.200
     2.810    45.875     0.200
     2.863    47.125     0.200
     2.932    48.754     0.200
     2.932    48.467     0.200
     3.162    51.805     0.200
     3.162    52.504     0.200
     3.168    50.744     0.200
     3.165    51.773     0.200
     3.165    51.322     0.200
     3.190    51.635     0.200
     3.282    52.494     0.200
     3.462    55.865     0.200
     3.462    55.377     0.200
     3.463    56.064     0.200
     3.463    55.559     0.200
     3.532    56.354     0.200
     3.547    57.234     0.200
     3.629    58.598     0.200
     3.829    61.375     0.200
     3.829    61.215     0.200
     3.960    63.305     0.200
     3.960    63.162     0.200
     4.063    64.824     0.200
     4.063    63.967     0.200
     4.115    64.725     0.200
     4.162    66.193     0.200
     4.211    65.854     0.200
     4.422    69.234     0.200
     4.422    69.447     0.200
     4.440    69.785     0.200
     4.609    71.574     0.200
     4.654    71.725     0.200
     4.654    71.568     0.200
     4.697    72.744     0.200
     4.697    72.580     0.200
     4.743    74.305     0.200
     4.743    73.502     0.200
     4.799    73.664     0.200
     4.799    73.373     0.200
     4.811    75.174     0.200
     4.914    75.994     0.200
     4.965    76.914     0.200
     5.144    78.930     0.200
     5.286    80.375     0.200
     5.550    85.354     0.200
     6.134    92.045     0.200
     6.222    93.273     0.200
     6.433    96.055     0.200
     6.848   101.805     0.200
     7.192   106.334     0.200
     7.344   108.125     0.200
     7.663   112.404     0.200
     7.674   113.023     0.200
     7.738   113.604     0.200
     7.992   118.344     0.200
     2.367    40.922     0.200
     2.310    40.242     0.200
     2.429    42.623     0.200
     2.779    45.883     0.200
     3.981    63.963     0.200
     1.960    35.338     0.200
     2.159    37.729     0.200
     2.159    37.842     0.200
     2.300    39.299     0.200
     2.432    41.578     0.200
     2.451    42.488     0.200
     2.556    43.037     0.200
     2.584    44.629     0.200
     2.716    45.258     0.200
     2.778    45.658     0.200
     2.778    45.238     0.200
     2.814    47.719     0.200
     2.907    47.838     0.200
     2.966    49.209     0.200
     2.966    48.988     0.200
     3.157    50.598     0.200
     3.210    51.768     0.200
     3.210    51.688     0.200
     3.214    52.139     0.200
     3.242    53.418     0.200
     3.305    52.818     0.200
     3.307    53.328     0.200
     3.492    55.008     0.200
     3.509    56.648     0.200
     3.509    56.219     0.200
     3.567    57.287     0.200
     3.652    58.857     0.200
     3.863    62.008     0.200
     3.911    64.148     0.200
     4.008    63.588     0.200
     4.008    63.871     0.200
     4.208    67.277     0.200
     4.208    67.078     0.200
     4.469    69.768     0.200
     4.469    70.295     0.200
     4.485    68.178     0.200
     4.484    69.549     0.200
     4.634    70.299     0.200
     4.684    72.828     0.200
     4.683    72.238     0.200
     4.732    73.107     0.200
     4.792    72.617     0.200
     4.850    73.738     0.200
     5.091    76.674     0.200
     5.091    76.498     0.200
     5.091    77.328     0.200
     5.189    78.178     0.200
     5.594    82.998     0.200
     5.851    87.498     0.200
     5.851    86.508     0.200
     7.190   104.768     0.200
     7.190   105.379     0.200
     7.695   112.818     0.200
     7.723   114.508     0.200
     7.729   113.857     0.200
     7.764   114.848     0.200
     8.653   127.322     0.200
    12.148   172.998     0.200
     2.203    38.461     0.200
     2.304    39.770     0.200
     3.874    61.578     0.200
     5.135    77.449     0.200
     2.093    35.969     0.200
     2.108    37.000     0.200
     2.108    36.594     0.200
     2.131    36.398     0.200
     2.207    37.809     0.200
     2.219    37.660     0.200
     2.235    37.391     0.200
     2.264    38.488     0.200
     2.264    38.801     0.200
     2.348    40.711     0.200
     2.348    39.898     0.200
     2.348    39.699     0.200
     2.344    40.609     0.200
     2.368    39.578     0.200
     2.461    41.348     0.200
     2.465    40.758     0.200
     2.465    40.625     0.200
     2.478    41.938     0.200
     2.478    41.609     0.200
     2.575    41.688     0.200
     2.618    43.078     0.200
     2.634    43.109     0.200
     2.634    43.910     0.200
     2.755    45.668     0.200
     2.755    45.777     0.200
     2.801    45.641     0.200
     2.871    46.629     0.200
     2.871    47.223     0.200
     2.871    45.820     0.200
     2.871    46.051     0.200
     2.986    47.488     0.200
     3.106    49.789     0.200
     3.106    49.629     0.200
     3.109    49.438     0.200
     3.109    49.812     0.200
     3.116    48.988     0.200
     3.116    49.516     0.200
     3.225    50.379     0.200
     3.225    51.551     0.200
     3.219    52.301     0.200
     3.219    52.410     0.200
     3.251    51.000     0.200
     3.351    52.461     0.200
     3.351    52.660     0.200
     3.403    54.418     0.200
     3.403    54.590     0.200
     3.403    53.410     0.200
     3.403    54.098     0.200
     3.432    54.738     0.200
     3.483    53.879     0.200
     3.494    54.680     0.200
     3.528    56.082     0.200
     3.599    56.219     0.200
     3.637    57.938     0.200
     3.637    58.309     0.200
     3.767    59.961     0.200
     3.810    59.348     0.200
     3.810    58.980     0.200
     3.812    58.801     0.200
     3.849    61.348     0.200
     3.917    61.961     0.200
     3.917    62.090     0.200
     3.950    60.586     0.200
     4.001    62.301     0.200
     4.060    62.961     0.200
     4.060    63.156     0.200
     4.102    64.148     0.200
     4.152    64.359     0.200
     4.152    64.504     0.200
     4.317    67.117     0.200
     4.317    66.633     0.200
     4.348    67.367     0.200
     4.348    68.270     0.200
     4.363    66.738     0.200
     4.363    66.922     0.200
     4.379    67.508     0.200
     4.379    67.312     0.200
     4.411    67.367     0.200
     4.394    66.918     0.200
     4.394    66.699     0.200
     4.552    70.270     0.200
     4.552    70.625     0.200
     4.596    70.160     0.200
     4.596    70.539     0.200
     4.636    71.559     0.200
     4.636    70.797     0.200
     4.673    72.301     0.200
     4.742    72.289     0.200
     4.742    72.695     0.200
     4.749    73.051     0.200
     4.749    72.828     0.200
     4.855    73.750     0.200
     4.907    75.129     0.200
     4.963    73.418     0.200
     4.963    74.238     0.200
     5.083    77.980     0.200
     5.083    77.500     0.200
     5.114    77.277     0.200
     5.114    77.512     0.200
     5.167    77.988     0.200
     5.167    78.148     0.200
     5.205    79.211     0.200
     5.226    78.500     0.200
     5.247    79.301     0.200
     5.247    80.438     0.200
     5.247    80.211     0.200
     5.326    79.617     0.200
     5.332    79.559     0.200
     5.332    79.852     0.200
     5.403    82.434     0.200
     5.424    82.109     0.200
     5.424    82.477     0.200
     5.488    83.410     0.200
     5.491    83.398     0.200
     5.543    83.652     0.200
     5.646    85.410     0.200
     5.646    84.609     0.200
     5.624    85.250     0.200
     5.624    84.789     0.200
     5.669    86.461     0.200
     5.745    85.719     0.200
     5.745    84.891     0.200
     5.786    85.797     0.200
     5.807    86.465     0.200
     5.818    86.238     0.200
     5.881    89.469     0.200
     5.939    88.188     0.200
     6.032    90.277     0.200
     6.032    90.156     0.200
     6.072    90.520     0.200
     6.072    90.789     0.200
     6.161    92.098     0.200
     6.157    92.445     0.200
     6.242    92.230     0.200
     6.268    94.551     0.200
     6.372    95.719     0.200
     6.548    97.312     0.200
     6.581    98.648     0.200
     6.644    99.160     0.200
     6.644    98.734     0.200
     6.663    98.520     0.200
     6.663    98.848     0.200
     6.742   100.211     0.200
     6.742   100.516     0.200
     6.739    99.953     0.200
     6.751   100.723     0.200
     6.756    99.723     0.200
     6.786   100.590     0.200
     6.786    99.879     0.200
     6.818   101.070     0.200
     6.832   101.980     0.200
     6.832   100.602     0.200
     6.841   102.711     0.200
     6.841   101.227     0.200
     6.914   102.508     0.200
     6.914   102.660     0.200
     6.884    99.969     0.200
     6.916   102.320     0.200
     7.074   104.062     0.200
     7.071   104.227     0.200
     7.108   105.500     0.200
     7.108   104.965     0.200
     7.247   106.113     0.200
     7.277   108.117     0.200
     7.277   107.430     0.200
     7.286   107.332     0.200
     7.284   106.770     0.200
     7.284   106.918     0.200
     7.419   108.500     0.200
     7.419   108.785     0.200
     7.426   109.180     0.200
     7.460   109.613     0.200
     7.602   110.668     0.200
     7.602   110.992     0.200
     7.619   113.438     0.200
     7.619   111.664     0.200
     7.626   112.090     0.200
     7.680   112.391     0.200
     7.680   113.133     0.200
     7.750   111.680     0.200
     7.750   111.988     0.200
     7.827   115.719     0.200
     7.867   115.051     0.200
     7.867   114.695     0.200
     7.930   115.469     0.200
     7.930   116.734     0.200
     7.927   116.145     0.200
     7.949   115.508     0.200
     7.963   116.961     0.200
     7.981   115.480     0.200
     7.981   117.109     0.200
     8.045   117.520     0.200
     8.105   118.926     0.200
     8.114   118.039     0.200
     8.114   118.383     0.200
     8.179   121.258     0.200
     8.179   120.055     0.200
     8.246   120.797     0.200
     8.342   120.379     0.200
     8.342   121.551     0.200
     8.408   123.086     0.200
     8.514   124.988     0.200
     8.514   124.230     0.200
     8.514   124.523     0.200
     8.491   124.250     0.200
     8.554   122.949     0.200
     8.578   124.840     0.200
     8.578   126.719     0.200
     8.613   125.293     0.200
     8.686   126.848     0.200
     8.820   127.715     0.200
     8.843   129.820     0.200
     9.083   131.602     0.200
     9.228   134.035     0.200
     9.351   135.406     0.200
     9.538   139.617     0.200
     9.548   138.031     0.200
     9.641   141.020     0.200
     9.663   140.277     0.200
    10.031   144.996     0.200
    10.672   153.078     0.200
    11.287   161.328     0.200
    11.287   160.977     0.200
    12.163   172.469     0.200
    13.147   186.867     0.200
    17.598   245.457     0.200
     2.097    37.583     0.200
     2.254    40.604     0.200
     2.766    45.104     0.200
     3.183    51.003     0.200
     3.716    60.483     0.200
     3.856    62.354     0.200
     2.255    38.367     0.200
     2.329    39.527     0.200
     2.327    39.418     0.200
     2.460    41.246     0.200
     2.740    45.266     0.200
     2.784    44.762     0.200
     2.858    46.457     0.200
     3.012    49.066     0.200
     3.012    48.941     0.200
     3.090    49.586     0.200
     3.320    52.348     0.200
     3.353    51.996     0.200
     3.385    54.656     0.200
     3.392    53.746     0.200
     3.628    57.598     0.200
     3.794    60.137     0.200
     3.898    61.008     0.200
     4.665    71.855     0.200
     4.665    71.648     0.200
     1.821    31.258     0.200
     2.195    36.598     0.200
     2.277    38.156     0.200
     2.349    39.258     0.200
     2.346    39.168     0.200
     2.346    38.469     0.200
     2.449    40.207     0.200
     2.472    40.957     0.200
     2.763    44.879     0.200
     2.763    44.586     0.200
     2.794    44.656     0.200
     2.859    45.797     0.200
     2.883    44.879     0.200
     3.001    46.656     0.200
     3.034    48.738     0.200
     3.263    50.938     0.200
     3.366    51.738     0.200
     3.366    52.066     0.200
     3.366    51.336     0.200
     3.390    53.578     0.200
     3.650    56.949     0.200
     3.756    58.066     0.200
     3.817    59.828     0.200
     3.918    60.617     0.200
     4.139    63.527     0.200
     4.409    66.879     0.200
     4.686    71.496     0.200
     4.686    71.383     0.200
     4.901    72.898     0.200
     4.901    73.512     0.200
     5.181    78.137     0.200
     2.224    38.484     0.200
     2.264    39.344     0.200
     2.394    40.945     0.200
     2.686    45.148     0.200
     2.723    44.820     0.200
     2.814    46.367     0.200
     2.929    47.648     0.200
     2.949    48.938     0.200
     3.014    48.156     0.200
     3.014    47.992     0.200
     3.023    49.586     0.200
     3.308    52.938     0.200
     3.354    53.484     0.200
     3.360    52.867     0.200
     3.360    52.766     0.200
     3.732    59.805     0.200
     3.732    59.945     0.200
     3.831    60.828     0.200
     4.636    72.016     0.200
     1.806    31.406     0.200
     2.038    35.848     0.200
     2.104    36.037     0.200
     2.142    36.688     0.200
     2.265    38.527     0.200
     2.241    38.348     0.200
     2.274    39.076     0.200
     2.286    38.676     0.200
     2.331    39.156     0.200
     2.394    40.018     0.200
     2.395    40.268     0.200
     2.721    44.537     0.200
     2.699    44.797     0.200
     2.699    44.586     0.200
     2.937    47.938     0.200
     2.937    46.377     0.200
     2.960    48.746     0.200
     3.022    48.607     0.200
     3.025    48.877     0.200
     3.025    48.406     0.200
     3.027    47.127     0.200
     3.075    49.246     0.200
     3.171    50.707     0.200
     3.171    50.127     0.200
     3.190    51.787     0.200
     3.190    51.197     0.200
     3.321    52.986     0.200
     3.343    52.977     0.200
     3.319    52.227     0.200
     3.325    52.848     0.200
     3.376    52.727     0.200
     3.376    52.166     0.200
     3.614    57.896     0.200
     3.743    59.938     0.200
     3.791    59.707     0.200
     3.791    59.977     0.200
     3.839    60.566     0.200
     3.839    60.256     0.200
     3.977    62.066     0.200
     3.977    61.506     0.200
     4.020    63.076     0.200
     4.280    66.107     0.200
     4.297    66.506     0.200
     4.611    70.857     0.200
     4.658    71.277     0.200
     4.652    71.867     0.200
     5.461    82.377     0.200
     6.076    91.037     0.200
     2.243    39.469     0.200
     2.373    42.299     0.200
     2.404    42.319     0.200
     2.541    44.199     0.200
     2.943    48.639     0.200
     3.058    52.039     0.200
     3.295    52.859     0.200
     3.474    55.781     0.200
     3.838    62.059     0.200
     3.838    62.534     0.200
     3.957    62.989     0.200
     3.957    63.675     0.200
     4.223    67.181     0.200
     1.888    32.438     0.200
     1.903    32.357     0.200
     1.908    32.498     0.200
     2.129    36.408     0.200
     2.139    35.828     0.200
     2.226    37.168     0.200
     2.230    36.879     0.200
     2.220    37.168     0.200
     2.272    37.879     0.200
     2.272    38.098     0.200
     2.366    39.328     0.200
     2.379    38.959     0.200
     2.481    40.559     0.200
     2.503    40.518     0.200
     2.772    44.758     0.200
     2.772    44.629     0.200
     2.826    44.947     0.200
     2.826    45.055     0.200
     2.764    44.488     0.200
     2.891    46.148     0.200
     2.891    46.500     0.200
     2.851    44.479     0.200
     2.851    44.789     0.200
     2.974    46.658     0.200
     3.051    49.059     0.200
     3.051    48.873     0.200
     3.134    50.311     0.200
     3.134    49.738     0.200
     3.229    51.094     0.200
     3.176    49.391     0.200
     3.231    49.908     0.200
     3.323    51.969     0.200
     3.344    51.588     0.200
     3.421    53.879     0.200
     3.645    57.133     0.200
     3.645    57.299     0.200
     3.788    58.418     0.200
     3.788    59.615     0.200
     3.833    60.039     0.200
     3.867    59.258     0.200
     3.867    60.719     0.200
     3.870    59.068     0.200
     3.959    60.318     0.200
     4.085    62.238     0.200
     4.085    62.416     0.200
     4.170    63.822     0.200
     4.388    67.518     0.200
     4.691    72.059     0.200
     4.680    71.191     0.200
     4.680    71.469     0.200
     4.767    73.008     0.200
     5.251    79.623     0.200
     5.301    80.789     0.200
     5.301    80.979     0.200
     5.332    80.398     0.200
     5.332    80.562     0.200
     5.332    81.068     0.200
     5.449    81.848     0.200
     5.568    83.459     0.200
     5.568    83.857     0.200
     6.153    91.648     0.200
     6.153    91.424     0.200
     6.182    91.488     0.200
     7.022   102.799     0.200
     1.816    32.676     0.200
     1.837    32.387     0.200
     1.918    33.785     0.200
     1.917    33.742     0.200
     1.921    33.926     0.200
     1.939    34.328     0.200
     2.184    37.582     0.200
     2.170    37.711     0.200
     2.270    39.406     0.200
     2.267    38.445     0.200
     2.336    39.809     0.200
     2.392    41.227     0.200
     2.392    40.660     0.200
     2.392    41.918     0.200
     2.411    39.688     0.200
     2.412    40.219     0.200
     2.522    42.398     0.200
     2.544    43.309     0.200
     2.544    42.965     0.200
     2.544    43.887     0.200
     2.722    44.879     0.200
     2.811    45.836     0.200
     2.811    45.707     0.200
     2.788    46.488     0.200
     2.788    46.977     0.200
     2.868    46.918     0.200
     2.868    47.566     0.200
     2.942    47.637     0.200
     2.932    47.961     0.200
     2.935    48.656     0.200
     3.029    50.086     0.200
     3.077    50.766     0.200
     3.077    51.129     0.200
     3.135    50.746     0.200
     3.135    50.555     0.200
     3.190    51.816     0.200
     3.162    50.719     0.200
     3.162    49.844     0.200
     3.170    51.598     0.200
     3.174    51.688     0.200
     3.174    51.816     0.200
     3.230    52.355     0.200
     3.230    52.695     0.200
     3.230    53.008     0.200
     3.309    52.293     0.200
     3.309    52.996     0.200
     3.318    51.957     0.200
     3.318    52.418     0.200
     3.318    52.086     0.200
     3.279    51.898     0.200
     3.279    52.496     0.200
     3.460    55.629     0.200
     3.469    55.266     0.200
     3.469    55.855     0.200
     3.542    55.156     0.200
     3.667    57.648     0.200
     3.667    59.465     0.200
     3.643    58.332     0.200
     3.746    61.617     0.200
     3.835    60.078     0.200
     3.835    59.969     0.200
     3.829    61.152     0.200
     3.858    61.566     0.200
     3.858    61.945     0.200
     3.859    59.477     0.200
     3.885    61.047     0.200
     3.972    63.406     0.200
     3.988    62.066     0.200
     3.988    62.258     0.200
     4.066    62.707     0.200
     4.066    63.012     0.200
     4.124    64.188     0.200
     4.124    64.957     0.200
     4.124    63.777     0.200
     4.210    65.289     0.200
     4.352    66.977     0.200
     4.352    66.578     0.200
     4.374    66.879     0.200
     4.374    67.707     0.200
     4.399    67.508     0.200
     4.429    68.918     0.200
     4.459    67.387     0.200
     4.459    68.527     0.200
     4.606    71.453     0.200
     4.676    72.707     0.200
     4.652    71.137     0.200
     4.713    73.426     0.200
     4.713    73.875     0.200
     4.698    72.176     0.200
     4.832    74.129     0.200
     4.832    73.559     0.200
     4.807    73.457     0.200
     4.807    74.500     0.200
     4.813    73.195     0.200
     4.813    74.078     0.200
     4.962    77.746     0.200
     5.117    77.805     0.200
     5.117    76.918     0.200
     5.145    78.871     0.200
     5.164    77.219     0.200
     5.164    78.383     0.200
     5.267    80.547     0.200
     5.299    81.477     0.200
     5.299    80.980     0.200
     5.299    82.027     0.200
     5.292    80.176     0.200
     5.292    80.613     0.200
     5.325    81.914     0.200
     5.325    82.668     0.200
     5.365    82.938     0.200
     5.365    82.242     0.200
     5.365    82.797     0.200
     5.370    80.648     0.200
     5.488    83.898     0.200
     5.488    84.004     0.200
     5.555    84.039     0.200
     5.555    83.848     0.200
     5.604    85.129     0.200
     5.604    85.324     0.200
     5.604    85.828     0.200
     5.661    84.926     0.200
     5.752    84.695     0.200
     5.696    87.215     0.200
     5.705    87.039     0.200
     5.812    85.898     0.200
     5.812    87.559     0.200
     5.947    89.227     0.200
     5.983    89.188     0.200
     6.098    91.207     0.200
     6.098    92.320     0.200
     6.135    91.816     0.200
     6.135    92.797     0.200
     6.154    91.508     0.200
     6.173    92.246     0.200
     6.173    93.926     0.200
     6.173    94.996     0.200
     6.217    92.656     0.200
     6.217    94.289     0.200
     6.218    92.039     0.200
     6.292    92.016     0.200
     6.335    94.906     0.200
     6.343    94.789     0.200
     6.343    96.367     0.200
     6.406    96.398     0.200
     6.434    95.617     0.200
     6.589    97.879     0.200
     6.589    99.367     0.200
     6.703   100.008     0.200
     6.703   100.828     0.200
     6.727    99.867     0.200
     6.727   100.727     0.200
     6.784   100.426     0.200
     6.785   101.352     0.200
     6.799   101.949     0.200
     6.799   101.766     0.200
     6.809   102.016     0.200
     6.848   103.207     0.200
     6.859    99.867     0.200
     6.886   103.375     0.200
     6.908   101.969     0.200
     6.952   104.508     0.200
     7.048   105.758     0.200
     7.137   106.875     0.200
     7.317   107.746     0.200
     7.317   108.422     0.200
     7.312   108.734     0.200
     7.342   108.336     0.200
     7.342   108.945     0.200
     7.466   109.812     0.200
     7.480   111.000     0.200
     7.526   111.543     0.200
     7.662   111.957     0.200
     7.662   113.051     0.200
     7.689   114.059     0.200
     7.685   113.637     0.200
     7.735   114.199     0.200
     7.770   111.879     0.200
     7.770   113.617     0.200
     7.890   116.934     0.200
     7.908   115.066     0.200
     7.908   116.602     0.200
     7.991   116.277     0.200
     7.991   118.156     0.200
     7.993   117.016     0.200
     7.993   118.070     0.200
     7.998   116.168     0.200
     7.998   118.719     0.200
     8.076   117.227     0.200
     8.161   119.496     0.200
     8.186   120.766     0.200
     8.244   121.469     0.200
     8.312   122.270     0.200
     8.399   121.996     0.200
     8.526   125.141     0.200
     8.592   125.418     0.200
     8.622   125.039     0.200
     8.636   128.133     0.200
     8.834   127.586     0.200
     8.834   128.734     0.200
     8.862   130.246     0.200
     8.909   130.438     0.200
     8.909   131.148     0.200
     8.997   133.012     0.200
     9.121   134.277     0.200
     9.398   135.945     0.200
     1.801    31.210     0.200
     1.876    32.557     0.200
     1.899    32.390     0.200
     2.105    35.550     0.200
     2.121    36.470     0.200
     2.121    36.202     0.200
     2.141    36.090     0.200
     2.220    37.660     0.200
     2.262    38.080     0.200
     2.350    39.010     0.200
     2.350    38.890     0.200
     2.351    39.350     0.200
     2.379    39.450     0.200
     2.474    40.600     0.200
     2.490    41.170     0.200
     2.587    42.510     0.200
     2.629    42.400     0.200
     2.646    42.570     0.200
     2.646    42.963     0.200
     2.774    46.930     0.200
     2.759    44.630     0.200
     2.759    44.850     0.200
     2.759    44.742     0.200
     2.815    44.780     0.200
     2.815    44.893     0.200
     2.884    46.740     0.200
     3.037    48.890     0.200
     3.037    49.020     0.200
     3.118    48.800     0.200
     3.121    50.450     0.200
     3.218    51.540     0.200
     3.317    51.930     0.200
     3.317    52.100     0.200
     3.341    51.910     0.200
     3.341    51.480     0.200
     3.416    53.980     0.200
     3.416    53.510     0.200
     3.416    54.172     0.200
     3.445    55.010     0.200
     3.506    55.960     0.200
     3.635    57.440     0.200
     3.635    57.320     0.200
     3.781    59.170     0.200
     3.819    59.700     0.200
     3.819    60.080     0.200
     3.853    60.520     0.200
     3.853    60.203     0.200
     3.872    60.470     0.200
     3.926    60.810     0.200
     4.072    62.470     0.200
     4.072    62.330     0.200
     4.165    64.270     0.200
     4.376    67.380     0.200
     4.565    69.530     0.200
     4.609    70.720     0.200
     4.670    71.530     0.200
     4.670    71.348     0.200
     4.676    72.150     0.200
     4.676    72.049     0.200
     4.754    72.800     0.200
     5.255    79.520     0.200
     5.255    80.460     0.200
     5.287    80.730     0.200
     5.287    80.850     0.200
     5.318    80.160     0.200
     5.318    80.900     0.200
     5.436    81.370     0.200
     5.554    83.800     0.200
     6.110    90.860     0.200
     6.110    90.632     0.200
     6.138    91.790     0.200
     6.168    91.760     0.200
     7.182   105.491     0.200
     1.821    33.146     0.200
     1.867    34.088     0.200
     1.931    34.047     0.200
     1.894    34.158     0.200
     2.048    36.807     0.200
     2.056    35.258     0.200
     2.074    37.928     0.200
     2.074    37.377     0.200
     2.079    37.646     0.200
     2.127    37.877     0.200
     2.128    37.738     0.200
     2.219    39.896     0.200
     2.297    39.678     0.200
     2.329    40.717     0.200
     2.330    40.098     0.200
     2.353    40.717     0.200
     2.473    42.227     0.200
     2.528    43.018     0.200
     2.530    43.297     0.200
     2.524    43.768     0.200
     2.524    44.088     0.200
     2.552    42.938     0.200
     2.563    43.646     0.200
     2.710    46.158     0.200
     2.764    47.088     0.200
     2.764    46.488     0.200
     2.836    47.768     0.200
     2.840    47.848     0.200
     3.056    49.787     0.200
     3.024    50.508     0.200
     3.046    49.748     0.200
     3.046    49.998     0.200
     3.061    51.078     0.200
     3.061    50.918     0.200
     3.064    49.588     0.200
     3.064    50.004     0.200
     3.064    50.297     0.200
     3.116    50.527     0.200
     3.153    50.896     0.200
     3.268    53.867     0.200
     3.262    52.877     0.200
     3.262    53.051     0.200
     3.262    52.598     0.200
     3.369    54.367     0.200
     3.369    53.725     0.200
     3.369    53.537     0.200
     3.419    54.777     0.200
     3.435    53.488     0.200
     3.496    57.547     0.200
     3.548    58.238     0.200
     3.597    59.107     0.200
     3.597    58.814     0.200
     3.639    59.338     0.200
     3.639    59.145     0.200
     3.727    59.477     0.200
     3.786    61.207     0.200
     3.930    61.707     0.200
     3.930    61.912     0.200
     4.009    64.127     0.200
     4.009    63.979     0.200
     3.989    63.057     0.200
     4.105    65.467     0.200
     4.105    65.174     0.200
     4.332    68.020     0.200
     4.413    69.938     0.200
     4.413    70.305     0.200
     4.442    69.438     0.200
     4.442    69.652     0.200
     4.460    69.980     0.200
     4.463    69.848     0.200
     4.475    69.777     0.200
     4.475    70.195     0.200
     4.728    73.238     0.200
     4.790    73.457     0.200
     4.971    77.277     0.200
     4.973    78.066     0.200
     4.973    78.488     0.200
     5.025    78.008     0.200
     5.018    78.328     0.200
     5.018    78.547     0.200
     5.029    78.738     0.200
     5.150    81.357     0.200
     5.265    82.566     0.200
     5.268    80.008     0.200
     5.295    81.646     0.200
     5.500    82.857     0.200
     5.500    82.727     0.200
     5.605    84.717     0.200
     5.610    86.578     0.200
     5.699    85.137     0.200
     5.826    88.918     0.200
     5.878    90.488     0.200
     5.882    90.777     0.200
     5.926    88.967     0.200
     5.980    90.717     0.200
     6.716   100.816     0.200
     6.732   101.848     0.200
     6.732   101.217     0.200
     6.773   101.217     0.200
     6.778   102.328     0.200
     6.918   104.498     0.200
     7.206   106.467     0.200
     7.281   108.707     0.200
     7.746   114.047     0.200
     7.981   119.107     0.200
     8.291   121.377     0.200
     1.803    32.151     0.200
     1.824    32.039     0.200
     2.412    40.821     0.200
     2.595    42.533     0.200
     2.708    44.271     0.200
     2.708    44.791     0.200
     2.739    44.609     0.200
     2.821    46.141     0.200
     2.972    49.012     0.200
     3.015    47.435     0.200
     3.015    47.052     0.200
     3.043    49.361     0.200
     3.320    52.741     0.200
     3.358    53.277     0.200
     3.755    59.695     0.200
     3.755    59.871     0.200
     3.854    60.578     0.200
     3.854    60.682     0.200
     3.994    62.052     0.200
     4.616    71.688     0.200
     4.616    71.882     0.200
     5.224    80.741     0.200
     5.244    80.491     0.200
     1.814    33.773     0.200
     1.814    34.359     0.200
     1.906    34.758     0.200
     2.335    41.621     0.200
     2.327    41.758     0.200
     2.382    42.352     0.200
     2.465    42.949     0.200
     2.502    42.184     0.200
     2.771    47.988     0.200
     3.011    51.398     0.200
     3.024    50.219     0.200
     3.272    53.199     0.200
     3.281    53.969     0.200
     3.422    55.840     0.200
     3.796    62.539     0.200
     3.872    62.500     0.200
     3.981    63.930     0.200
     4.662    74.789     0.200
     5.257    82.039     0.200
     5.266    82.520     0.200
     6.064    92.910     0.200
     7.167   107.898     0.200
     1.824    33.812     0.200
     1.861    33.742     0.200
     2.195    39.156     0.200
     2.380    42.008     0.200
     2.555    44.758     0.200
     2.704    45.203     0.200
     2.718    45.219     0.200
     2.784    47.016     0.200
     2.768    46.680     0.200
     2.768    47.023     0.200
     3.065    51.648     0.200
     3.275    53.133     0.200
     3.845    62.242     0.200
     3.967    63.719     0.200
     4.699    74.766     0.200
     5.312    83.578     0.200
     5.362    83.742     0.200
     6.156    94.992     0.200
     1.864    32.688     0.200
     1.864    33.023     0.200
     1.871    32.602     0.200
     1.893    32.453     0.200
     1.893    32.969     0.200
     1.929    32.883     0.200
     1.986    34.797     0.200
     1.989    35.031     0.200
     2.020    34.453     0.200
     2.065    35.812     0.200
     2.084    35.617     0.200
     2.118    36.445     0.200
     2.161    36.195     0.200
     2.260    38.367     0.200
     2.260    37.406     0.200
     2.418    40.602     0.200
     2.466    40.273     0.200
     2.466    39.617     0.200
     2.506    41.484     0.200
     2.573    42.492     0.200
     2.576    42.898     0.200
     2.576    41.969     0.200
     2.651    43.328     0.200
     2.764    44.531     0.200
     2.770    44.445     0.200
     2.805    45.094     0.200
     2.862    46.062     0.200
     2.895    46.812     0.200
     2.906    47.148     0.200
     2.916    46.266     0.200
     2.952    47.219     0.200
     3.192    49.883     0.200
     3.256    51.523     0.200
     3.256    52.445     0.200
     3.252    51.078     0.200
     3.252    51.625     0.200
     3.269    51.523     0.200
     3.269    52.477     0.200
     3.269    52.703     0.200
     3.417    53.203     0.200
     3.414    53.969     0.200
     3.690    57.586     0.200
     4.031    62.953     0.200
     4.181    65.633     0.200
     4.181    64.875     0.200
     4.441    67.156     0.200
     4.612    69.406     0.200
     4.683    71.133     0.200
     4.683    71.844     0.200
     4.873    75.352     0.200
     4.982    74.242     0.200
     5.135    76.727     0.200
     5.492    83.906     0.200
     5.920    87.742     0.200
     1.880    33.914     0.200
     2.224    39.930     0.200
     2.279    40.688     0.200
     2.450    41.312     0.200
     2.681    46.570     0.200
     2.908    49.625     0.200
     3.693    60.430     0.200
     4.562    73.344     0.200
     1.817    31.898     0.200
     1.825    32.469     0.200
     1.825    32.172     0.200
     1.830    32.289     0.200
     1.861    32.949     0.200
     1.861    32.148     0.200
     1.975    34.578     0.200
     1.975    34.465     0.200
     2.078    36.020     0.200
     2.085    35.430     0.200
     2.155    36.789     0.200
     2.219    38.660     0.200
     2.219    38.309     0.200
     2.219    38.488     0.200
     2.229    38.379     0.200
     2.229    38.488     0.200
     2.297    38.820     0.200
     2.323    40.059     0.200
     2.323    39.691     0.200
     2.323    39.879     0.200
     2.334    39.398     0.200
     2.336    39.141     0.200
     2.336    38.961     0.200
     2.385    39.988     0.200
     2.385    39.809     0.200
     2.419    40.141     0.200
     2.419    39.969     0.200
     2.502    41.441     0.200
     2.531    41.969     0.200
     2.531    41.652     0.200
     2.534    41.609     0.200
     2.650    43.840     0.200
     2.650    43.547     0.200
     2.658    44.539     0.200
     2.658    44.207     0.200
     2.658    44.398     0.200
     2.734    45.211     0.200
     2.745    45.512     0.200
     2.745    45.148     0.200
     2.745    45.262     0.200
     2.904    47.770     0.200
     2.904    48.113     0.200
     2.904    48.281     0.200
     2.951    48.230     0.200
     2.954    47.910     0.200
     2.954    47.699     0.200
     2.937    47.512     0.200
     2.937    47.926     0.200
     2.998    46.762     0.200
     2.998    46.480     0.200
     3.036    48.410     0.200
     3.036    48.227     0.200
     3.069    48.418     0.200
     3.069    48.051     0.200
     3.172    51.871     0.200
     3.172    51.691     0.200
     3.249    52.918     0.200
     3.249    52.801     0.200
     3.249    52.680     0.200
     3.289    52.539     0.200
     3.333    53.020     0.200
     3.333    53.125     0.200
     3.327    52.289     0.200
     3.381    52.738     0.200
     3.381    52.168     0.200
     3.407    53.738     0.200
     3.409    52.039     0.200
     3.404    53.238     0.200
     3.404    53.113     0.200
     3.404    52.891     0.200
     3.639    57.629     0.200
     3.639    57.922     0.200
     3.688    59.230     0.200
     3.688    59.363     0.200
     3.719    57.699     0.200
     3.719    58.086     0.200
     3.775    60.020     0.200
     3.855    60.348     0.200
     3.891    59.770     0.200
     3.906    61.160     0.200
     3.906    61.371     0.200
     3.948    61.230     0.200
     3.948    61.000     0.200
     3.963    62.039     0.200
     3.963    61.289     0.200
     3.963    61.441     0.200
     3.981    61.262     0.200
     3.981    61.121     0.200
     3.981    60.820     0.200
     4.035    62.980     0.200
     4.035    62.707     0.200
     4.202    64.809     0.200
     4.209    65.238     0.200
     4.209    65.602     0.200
     4.214    66.262     0.200
     4.214    66.371     0.200
     4.322    66.469     0.200
     4.449    67.352     0.200
     4.449    68.344     0.200
     4.483    68.699     0.200
     4.483    68.227     0.200
     4.472    67.941     0.200
     4.472    67.840     0.200
     4.505    68.809     0.200
     4.505    68.980     0.200
     4.542    70.270     0.200
     4.542    70.500     0.200
     4.552    71.102     0.200
     4.552    70.926     0.200
     4.587    70.648     0.200
     4.587    70.754     0.200
     4.610    70.969     0.200
     4.610    70.734     0.200
     4.745    72.199     0.200
     4.801    73.238     0.200
     4.801    73.375     0.200
     4.896    74.270     0.200
     4.951    75.445     0.200
     5.001    75.664     0.200
     5.021    75.230     0.200
     5.072    77.449     0.200
     5.072    76.859     0.200
     5.111    78.109     0.200
     5.111    78.590     0.200
     5.157    79.781     0.200
     5.157    79.297     0.200
     5.157    79.590     0.200
     5.163    78.852     0.200
     5.163    78.574     0.200
     5.163    78.730     0.200
     5.270    80.398     0.200
     5.270    80.164     0.200
     5.270    80.520     0.200
     5.264    78.180     0.200
     5.264    79.113     0.200
     5.296    80.031     0.200
     5.296    79.742     0.200
     5.393    82.430     0.200
     5.393    82.004     0.200
     5.393    81.262     0.200
     5.527    84.391     0.200
     5.543    83.469     0.200
     5.543    84.234     0.200
     5.593    82.281     0.200
     5.593    83.359     0.200
     5.877    85.762     0.200
     5.884    87.391     0.200
     5.964    89.711     0.200
     5.964    89.441     0.200
     5.995    89.891     0.200
     5.995    89.375     0.200
     6.007    90.277     0.200
     6.067    91.281     0.200
     6.130    90.102     0.200
     6.238    93.988     0.200
     6.524    97.699     0.200
     6.595    99.156     0.200
     6.657   100.191     0.200
     6.671    98.430     0.200
     6.727   100.129     0.200
     6.727    99.609     0.200
     6.851   101.059     0.200
     6.871   102.051     0.200
     6.871   101.715     0.200
     6.918   102.961     0.200
     6.940   102.387     0.200
     7.057   104.000     0.200
     7.057   104.387     0.200
     7.057   104.500     0.200
     7.092   104.668     0.200
     7.137   104.879     0.200
     7.137   104.262     0.200
     7.172   105.078     0.200
     7.235   106.371     0.200
     7.235   106.527     0.200
     7.305   107.730     0.200
     7.305   108.324     0.200
     7.322   107.441     0.200
     7.322   107.730     0.200
     7.472   110.668     0.200
     7.477   110.160     0.200
     7.477   110.316     0.200
     7.572   111.500     0.200
     7.572   111.285     0.200
     7.674   113.965     0.200
     7.674   113.750     0.200
     7.735   111.379     0.200
     7.773   114.750     0.200
     7.773   115.051     0.200
     7.797   113.660     0.200
     7.797   114.848     0.200
     8.091   119.121     0.200
     8.091   120.223     0.200
     8.134   118.961     0.200
     8.333   121.430     0.200
     8.335   120.410     0.200
     8.335   122.176     0.200
     8.539   125.969     0.200
     8.552   124.793     0.200
     8.688   127.988     0.200
     8.688   128.250     0.200
     8.751   126.629     0.200
     8.900   130.488     0.200
     8.992   130.539     0.200
     9.230   132.766     0.200
     9.383   136.578     0.200
     1.815    31.832     0.200
     1.887    32.822     0.200
     1.881    32.805     0.200
     1.864    32.292     0.200
     1.864    32.667     0.200
     2.028    34.582     0.200
     2.114    35.612     0.200
     2.202    36.633     0.200
     2.213    36.662     0.200
     2.284    37.902     0.200
     2.326    39.183     0.200
     2.371    39.622     0.200
     2.338    39.183     0.200
     2.470    40.603     0.200
     2.538    40.843     0.200
     2.538    41.393     0.200
     2.514    41.482     0.200
     2.595    41.832     0.200
     2.595    42.015     0.200
     2.630    42.822     0.200
     2.681    44.112     0.200
     2.680    42.673     0.200
     2.680    43.742     0.200
     2.774    44.405     0.200
     2.891    46.202     0.200
     2.891    46.992     0.200
     2.888    45.822     0.200
     2.888    45.662     0.200
     2.999    47.162     0.200
     2.999    47.862     0.200
     3.038    48.803     0.200
     3.038    49.039     0.200
     3.030    48.232     0.200
     3.199    51.374     0.200
     3.228    50.910     0.200
     3.308    51.562     0.200
     3.311    51.393     0.200
     3.311    51.822     0.200
     3.292    52.692     0.200
     3.292    52.928     0.200
     3.292    51.162     0.200
     3.292    50.927     0.200
     3.322    52.353     0.200
     3.556    55.343     0.200
     3.556    55.514     0.200
     3.547    56.252     0.200
     3.614    56.772     0.200
     3.603    55.513     0.200
     3.630    56.542     0.200
     3.696    58.232     0.200
     3.696    58.394     0.200
     3.766    58.232     0.200
     3.766    58.343     0.200
     3.933    60.152     0.200
     3.933    61.327     0.200
     3.937    60.712     0.200
     3.937    62.236     0.200
     3.978    62.883     0.200
     3.978    62.572     0.200
     3.990    63.232     0.200
     4.034    61.502     0.200
     4.104    63.992     0.200
     4.104    63.695     0.200
     4.262    65.252     0.200
     4.262    65.054     0.200
     4.307    65.832     0.200
     4.301    65.412     0.200
     4.301    65.125     0.200
     4.530    69.289     0.200
     4.565    69.292     0.200
     4.565    70.696     0.200
     4.578    69.282     0.200
     4.746    71.353     0.200
     4.744    71.412     0.200
     4.807    73.083     0.200
     4.829    74.143     0.200
     4.829    74.694     0.200
     4.889    74.183     0.200
     4.931    75.832     0.200
     4.945    74.522     0.200
     4.945    74.816     0.200
     5.002    76.643     0.200
     5.238    79.893     0.200
     5.444    83.112     0.200
     5.444    83.282     0.200
     5.499    82.996     0.200
     5.625    84.391     0.200
     6.283    93.483     0.200
     6.284    92.712     0.200
     6.284    93.893     0.200
     7.191   104.543     0.200
     7.171   105.520     0.200
     7.350   107.382     0.200
     7.335   106.902     0.200
     7.335   108.037     0.200
     7.435   109.032     0.200
     7.822   113.928     0.200
     8.104   118.471     0.200
     8.665   126.725     0.200
     1.905    33.664     0.200
     2.675    44.520     0.200
     2.733    45.133     0.200
     2.788    46.266     0.200
     2.919    47.770     0.200
     3.073    50.367     0.200
     3.448    54.973     0.200
     3.854    62.488     0.200
     3.966    63.289     0.200
     4.711    74.277     0.200
     5.322    83.238     0.200
     1.811    31.979     0.200
     1.811    32.124     0.200
     1.861    32.779     0.200
     1.861    32.949     0.200
     1.882    33.100     0.200
     1.882    33.292     0.200
     1.953    33.729     0.200
     1.954    34.159     0.200
     2.008    34.043     0.200
     2.286    39.009     0.200
     2.323    39.549     0.200
     2.334    39.379     0.200
     2.513    42.680     0.200
     2.777    44.374     0.200
     3.041    49.499     0.200
     3.198    52.299     0.200
     3.198    51.242     0.200
     3.977    63.079     0.200
     4.103    64.729     0.200
     4.720    72.709     0.200
     4.827    74.869     0.200
     5.442    84.079     0.200
     7.333   108.344     0.200
     1.853    32.847     0.200
     2.280    38.108     0.200
     2.331    38.934     0.200
     3.188    52.123     0.200
     3.967    62.948     0.200
     4.093    64.682     0.200
     4.818    74.940     0.200
     5.433    83.684     0.200
     7.324   108.774     0.200
     1.812    31.346     0.200
     1.812    31.176     0.200
     1.859    32.566     0.200
     1.859    32.887     0.200
     1.877    33.066     0.200
     1.886    32.285     0.200
     1.949    34.066     0.200
     1.948    33.986     0.200
     1.948    33.605     0.200
     1.968    33.797     0.200
     1.968    33.928     0.200
     1.991    33.727     0.200
     1.999    34.346     0.200
     2.005    34.377     0.200
     2.027    34.195     0.200
     2.113    35.775     0.200
     2.113    35.982     0.200
     2.214    37.686     0.200
     2.282    38.396     0.200
     2.282    38.695     0.200
     2.282    38.502     0.200
     2.321    39.105     0.200
     2.321    39.426     0.200
     2.321    39.596     0.200
     2.316    39.217     0.200
     2.335    39.307     0.200
     2.370    39.297     0.200
     2.509    42.166     0.200
     2.509    42.057     0.200
     2.509    41.926     0.200
     2.545    43.316     0.200
     2.539    41.756     0.200
     2.539    41.518     0.200
     2.598    42.467     0.200
     2.598    42.139     0.200
     2.628    42.457     0.200
     2.676    43.996     0.200
     2.711    43.865     0.200
     2.711    43.676     0.200
     2.735    44.086     0.200
     2.774    44.586     0.200
     2.885    47.025     0.200
     2.885    47.387     0.200
     2.885    47.197     0.200
     2.886    45.887     0.200
     2.886    46.057     0.200
     2.996    47.666     0.200
     2.996    47.957     0.200
     2.996    47.838     0.200
     3.031    48.627     0.200
     3.031    47.855     0.200
     3.031    48.074     0.200
     3.037    48.877     0.200
     3.037    49.227     0.200
     3.037    49.021     0.200
     3.088    49.355     0.200
     3.194    51.457     0.200
     3.194    51.566     0.200
     3.229    51.217     0.200
     3.229    51.072     0.200
     3.288    52.797     0.200
     3.288    53.166     0.200
     3.290    51.346     0.200
     3.290    50.967     0.200
     3.318    52.656     0.200
     3.318    52.307     0.200
     3.364    52.797     0.200
     3.555    55.695     0.200
     3.600    56.576     0.200
     3.586    55.826     0.200
     3.691    58.086     0.200
     3.691    58.797     0.200
     3.691    58.264     0.200
     3.765    58.807     0.200
     3.936    61.756     0.200
     3.933    61.285     0.200
     3.933    61.467     0.200
     3.973    62.717     0.200
     3.973    62.826     0.200
     3.984    63.195     0.200
     3.984    63.059     0.200
     4.036    61.707     0.200
     4.099    63.936     0.200
     4.099    63.781     0.200
     4.257    65.316     0.200
     4.300    65.346     0.200
     4.306    65.877     0.200
     4.306    65.980     0.200
     4.468    68.189     0.200
     4.530    69.166     0.200
     4.561    69.127     0.200
     4.575    71.035     0.200
     4.719    72.355     0.200
     4.719    72.637     0.200
     4.745    72.400     0.200
     4.806    73.207     0.200
     4.823    74.436     0.200
     4.885    74.676     0.200
     4.940    74.377     0.200
     4.940    74.545     0.200
     5.045    75.477     0.200
     5.238    79.734     0.200
     5.254    79.633     0.200
     5.438    83.275     0.200
     5.438    83.717     0.200
     5.438    82.986     0.200
     5.432    81.275     0.200
     5.494    82.826     0.200
     5.494    84.717     0.200
     5.621    84.736     0.200
     5.658    84.973     0.200
     6.245    93.807     0.200
     6.248    93.205     0.200
     6.278    94.826     0.200
     6.278    94.615     0.200
     6.278    94.477     0.200
     6.278    94.002     0.200
     7.165   106.365     0.200
     7.165   105.732     0.200
     7.330   108.176     0.200
     7.820   115.127     0.200
     7.820   115.650     0.200
     7.822   115.256     0.200
     7.890   116.475     0.200
     8.102   119.234     0.200
     1.892    33.961     0.200
     1.921    35.514     0.200
     1.945    34.596     0.200
     2.025    35.045     0.200
     2.081    36.445     0.200
     2.223    38.756     0.200
     2.249    38.715     0.200
     2.276    38.506     0.200
     2.298    39.135     0.200
     2.344    39.635     0.200
     2.429    40.926     0.200
     2.460    40.775     0.200
     2.462    41.615     0.200
     2.464    40.846     0.200
     2.687    45.635     0.200
     2.705    45.895     0.200
     2.933    49.035     0.200
     2.937    47.994     0.200
     3.225    53.123     0.200
     3.336    53.484     0.200
     3.479    55.143     0.200
     3.582    57.025     0.200
     3.789    60.795     0.200
     3.816    59.295     0.200
     3.973    62.045     0.200
     4.570    69.375     0.200
     5.130    79.016     0.200
     5.173    80.744     0.200
     5.260    82.395     0.200
     5.303    81.855     0.200
     5.475    83.166     0.200
     5.561    83.775     0.200
     5.885    88.025     0.200
     5.982    90.596     0.200
     6.058    91.305     0.200
     6.089    91.824     0.200
     7.743   112.836     0.200
     1.782    32.384     0.200
     1.814    32.884     0.200
     1.835    32.914     0.200
     2.169    37.414     0.200
     2.336    39.674     0.200
     2.686    44.000     0.200
     2.787    46.544     0.200
     2.787    45.939     0.200
     3.075    50.474     0.200
     3.229    53.034     0.200
     3.856    61.804     0.200
     3.856    61.583     0.200
     4.675    72.689     0.200
     4.711    73.794     0.200
     4.711    73.566     0.200
     5.323    82.354     0.200
     1.852    33.344     0.200
     1.913    34.385     0.200
     1.930    34.684     0.200
     2.198    37.725     0.200
     2.408    40.703     0.200
     2.443    41.734     0.200
     2.520    42.244     0.200
     2.533    42.674     0.200
     2.946    48.174     0.200
     2.936    48.494     0.200
     3.219    52.543     0.200
     3.273    52.523     0.200
     4.001    63.273     0.200
     4.103    64.713     0.200
     4.858    74.584     0.200
     5.469    83.924     0.200
     5.493    84.213     0.200
     1.869    32.618     0.200
     1.921    34.238     0.200
     1.927    33.338     0.200
     1.985    33.908     0.200
     2.007    34.838     0.200
     2.053    35.918     0.200
     2.098    36.668     0.200
     2.119    35.978     0.200
     2.128    36.448     0.200
     2.149    35.788     0.200
     2.213    37.938     0.200
     2.213    38.258     0.200
     2.229    37.748     0.200
     2.229    38.708     0.200
     2.332    38.508     0.200
     2.345    39.328     0.200
     2.387    40.388     0.200
     2.387    40.548     0.200
     2.446    41.308     0.200
     2.482    42.018     0.200
     2.495    42.188     0.200
     2.495    42.638     0.200
     2.595    42.628     0.200
     2.595    42.858     0.200
     2.601    42.668     0.200
     2.670    44.228     0.200
     2.740    46.298     0.200
     2.738    44.738     0.200
     2.756    44.248     0.200
     2.756    44.955     0.200
     2.811    46.728     0.200
     2.838    47.518     0.200
     2.838    47.098     0.200
     2.838    46.762     0.200
     2.896    46.958     0.200
     2.919    45.558     0.200
     2.975    48.488     0.200
     3.148    51.058     0.200
     3.148    50.748     0.200
     3.148    50.508     0.200
     3.151    52.198     0.200
     3.161    49.858     0.200
     3.161    50.438     0.200
     3.178    52.147     0.200
     3.178    51.918     0.200
     3.199    51.128     0.200
     3.199    52.408     0.200
     3.354    53.018     0.200
     3.357    52.988     0.200
     3.487    55.438     0.200
     3.637    57.318     0.200
     3.637    57.568     0.200
     3.671    57.818     0.200
     3.673    57.448     0.200
     3.673    58.194     0.200
     3.716    58.688     0.200
     3.741    60.068     0.200
     3.808    60.650     0.200
     3.940    63.598     0.200
     3.952    62.878     0.200
     3.952    62.478     0.200
     3.952    63.306     0.200
     4.045    62.468     0.200
     4.045    64.129     0.200
     4.060    62.098     0.200
     4.060    63.911     0.200
     4.106    64.758     0.200
     4.106    65.045     0.200
     4.169    64.258     0.200
     4.166    63.768     0.200
     4.300    66.638     0.200
     4.300    66.528     0.200
     4.423    68.558     0.200
     4.658    72.128     0.200
     4.794    74.388     0.200
     4.794    74.218     0.200
     4.794    74.698     0.200
     4.813    74.698     0.200
     4.911    76.038     0.200
     4.911    75.138     0.200
     4.911    75.828     0.200
     5.029    77.528     0.200
     5.122    78.958     0.200
     5.365    80.618     0.200
     5.365    82.428     0.200
     5.414    83.748     0.200
     5.414    83.233     0.200
     5.417    82.738     0.200
     5.505    83.908     0.200
     5.505    82.448     0.200
     5.562    83.378     0.200
     5.664    85.608     0.200
     5.664    86.117     0.200
     5.771    86.938     0.200
     5.919    89.778     0.200
     6.147    91.538     0.200
     6.241    93.068     0.200
     6.276    93.848     0.200
     6.276    93.558     0.200
     6.276    94.433     0.200
     6.372    94.588     0.200
     6.918   102.968     0.200
     6.943   102.778     0.200
     6.979   105.118     0.200
     7.148   106.568     0.200
     7.299   108.558     0.200
     7.299   108.344     0.200
     7.321   106.668     0.200
     7.483   109.478     0.200
     7.687   112.758     0.200
     7.862   116.118     0.200
     8.058   118.908     0.200
     8.665   128.288     0.200
     9.003   130.138     0.200
     1.832    33.213     0.200
     1.832    33.354     0.200
     1.837    32.963     0.200
     2.007    35.902     0.200
     2.025    35.453     0.200
     2.111    36.863     0.200
     2.258    39.674     0.200
     2.317    39.264     0.200
     2.363    40.193     0.200
     2.371    40.803     0.200
     2.394    40.943     0.200
     2.549    42.514     0.200
     2.549    41.986     0.200
     2.694    44.338     0.200
     2.703    45.453     0.200
     2.774    46.266     0.200
     3.004    48.982     0.200
     3.312    53.443     0.200
     3.348    54.061     0.200
     3.404    54.152     0.200
     3.738    60.832     0.200
     3.828    60.402     0.200
     3.828    61.531     0.200
     4.595    72.461     0.200
     4.602    72.871     0.200
     4.637    72.248     0.200
     5.163    79.264     0.200
     5.208    81.436     0.200
     5.216    79.955     0.200
     6.016    90.684     0.200
     6.016    90.967     0.200
     7.107   105.543     0.200
     1.795    31.426     0.200
     1.803    31.914     0.200
     1.855    33.094     0.200
     1.951    34.574     0.200
     2.321    40.504     0.200
     2.471    41.465     0.200
     2.817    45.027     0.200
     2.831    46.656     0.200
     3.082    50.496     0.200
     3.155    50.684     0.200
     4.072    63.387     0.200
     2.116    39.250     0.200
     2.117    38.578     0.200
     2.141    38.211     0.200
     2.326    40.539     0.200
     2.555    44.258     0.200
     2.738    47.320     0.200
     2.802    48.211     0.200
     2.882    49.312     0.200
     3.069    50.664     0.200
     3.045    49.250     0.200
     3.292    54.414     0.200
     3.586    59.047     0.200
     3.680    61.000     0.200
     3.829    61.992     0.200
     4.450    71.711     0.200
     5.055    79.938     0.200
     5.071    80.781     0.200
     1.824    32.305     0.200
     1.843    33.203     0.200
     1.875    32.934     0.200
     1.887    33.477     0.200
     1.879    33.934     0.200
     1.879    34.125     0.200
     1.963    34.453     0.200
     1.959    35.023     0.200
     1.959    35.363     0.200
     2.007    35.355     0.200
     2.007    35.676     0.200
     2.024    35.484     0.200
     2.079    36.023     0.200
     2.083    36.312     0.200
     2.106    36.754     0.200
     2.229    39.066     0.200
     2.229    38.816     0.200
     2.232    38.594     0.200
     2.232    38.797     0.200
     2.293    39.465     0.200
     2.311    39.805     0.200
     2.340    40.676     0.200
     2.385    39.875     0.200
     2.385    40.934     0.200
     2.437    41.605     0.200
     2.465    42.184     0.200
     2.465    42.727     0.200
     2.546    42.875     0.200
     2.546    43.035     0.200
     2.546    42.199     0.200
     2.563    43.297     0.200
     2.559    43.105     0.200
     2.559    42.559     0.200
     2.637    43.605     0.200
     2.641    43.875     0.200
     2.641    43.105     0.200
     2.692    45.324     0.200
     2.694    45.695     0.200
     2.694    44.434     0.200
     2.773    46.316     0.200
     2.823    46.137     0.200
     2.823    46.414     0.200
     2.791    45.547     0.200
     2.791    45.336     0.200
     2.819    48.137     0.200
     2.819    47.074     0.200
     2.819    46.430     0.200
     2.853    46.414     0.200
     2.853    46.617     0.200
     2.965    48.746     0.200
     2.965    48.117     0.200
     3.028    49.266     0.200
     3.020    48.547     0.200
     3.102    50.684     0.200
     3.102    51.184     0.200
     3.102    50.570     0.200
     3.149    52.145     0.200
     3.149    51.863     0.200
     3.198    51.984     0.200
     3.198    52.664     0.200
     3.197    52.113     0.200
     3.197    52.574     0.200
     3.189    51.445     0.200
     3.189    50.684     0.200
     3.216    52.086     0.200
     3.216    51.965     0.200
     3.318    53.516     0.200
     3.318    53.105     0.200
     3.310    52.965     0.200
     3.314    52.895     0.200
     3.314    53.355     0.200
     3.314    53.055     0.200
     3.444    55.375     0.200
     3.499    56.324     0.200
     3.499    55.492     0.200
     3.584    56.703     0.200
     3.629    58.395     0.200
     3.629    57.953     0.200
     3.625    57.605     0.200
     3.597    58.465     0.200
     3.597    58.285     0.200
     3.597    57.980     0.200
     3.676    57.773     0.200
     3.676    57.551     0.200
     3.925    63.234     0.200
     3.925    62.871     0.200
     3.920    63.336     0.200
     3.999    63.586     0.200
     4.071    65.066     0.200
     4.071    64.875     0.200
     4.071    64.730     0.200
     4.132    63.977     0.200
     4.233    65.273     0.200
     4.233    64.703     0.200
     4.204    65.004     0.200
     4.204    64.734     0.200
     4.204    64.852     0.200
     4.258    66.484     0.200
     4.323    67.125     0.200
     4.323    68.703     0.200
     4.379    68.453     0.200
     4.379    67.859     0.200
     4.542    69.859     0.200
     4.580    71.773     0.200
     4.580    70.391     0.200
     4.618    71.086     0.200
     4.618    70.715     0.200
     4.665    71.555     0.200
     4.665    71.910     0.200
     4.771    74.023     0.200
     4.769    74.953     0.200
     4.769    74.535     0.200
     4.820    74.164     0.200
     4.868    74.887     0.200
     4.868    74.473     0.200
     4.950    76.074     0.200
     4.950    75.566     0.200
     5.098    77.715     0.200
     5.098    77.055     0.200
     5.278    79.648     0.200
     5.315    80.832     0.200
     5.324    80.934     0.200
     5.385    83.203     0.200
     5.388    83.453     0.200
     5.388    83.594     0.200
     5.438    82.824     0.200
     5.445    83.113     0.200
     5.469    83.863     0.200
     5.469    83.613     0.200
     5.524    83.363     0.200
     5.724    87.023     0.200
     5.724    87.477     0.200
     5.724    87.262     0.200
     5.803    89.184     0.200
     5.859    89.316     0.200
     5.874    89.734     0.200
     5.874    89.398     0.200
     5.970    89.465     0.200
     5.970    89.285     0.200
     6.115    91.945     0.200
     6.219    94.656     0.200
     6.219    94.547     0.200
     6.219    93.887     0.200
     6.243    94.156     0.200
     6.243    94.035     0.200
     6.243    93.832     0.200
     6.305    95.406     0.200
     6.305    95.609     0.200
     6.326    95.254     0.200
     6.326    95.742     0.200
     6.334    95.676     0.200
     6.334    96.098     0.200
     6.742   100.547     0.200
     6.914   104.254     0.200
     6.947   103.086     0.200
     7.296   107.047     0.200
     7.275   107.906     0.200
     7.275   108.270     0.200
     7.774   114.914     0.200
     7.879   114.164     0.200
     8.017   118.875     0.200
     8.126   119.934     0.200
     8.276   121.887     0.200
     8.431   123.344     0.200
     8.604   126.523     0.200
     8.630   127.016     0.200
     8.696   126.754     0.200
     8.682   127.605     0.200
     8.758   128.676     0.200
     8.965   130.414     0.200
     9.302   136.887     0.200
     9.359   137.766     0.200
     9.748   144.086     0.200
     9.834   145.805     0.200
     9.842   145.625     0.200
    10.233   150.754     0.200
    10.494   152.203     0.200
    11.338   163.426     0.200
    12.057   172.434     0.200
     1.905    34.231     0.200
     1.905    34.491     0.200
     1.932    34.711     0.200
     1.932    35.031     0.200
     2.200    38.501     0.200
     2.200    38.921     0.200
     2.258    38.891     0.200
     2.279    40.191     0.200
     2.279    40.691     0.200
     2.305    40.371     0.200
     2.338    40.541     0.200
     2.338    41.171     0.200
     2.431    40.631     0.200
     2.431    41.231     0.200
     2.437    41.171     0.200
     2.499    41.991     0.200
     2.499    42.812     0.200
     2.613    44.941     0.200
     2.668    45.111     0.200
     2.668    45.571     0.200
     2.741    46.431     0.200
     2.741    47.071     0.200
     2.932    48.241     0.200
     2.947    48.331     0.200
     2.949    49.211     0.200
     2.949    49.011     0.200
     2.962    49.711     0.200
     2.962    50.421     0.200
     3.171    50.491     0.200
     3.277    54.621     0.200
     3.277    54.501     0.200
     3.447    55.951     0.200
     3.515    55.971     0.200
     3.515    55.812     0.200
     3.709    60.171     0.200
     3.811    61.861     0.200
     3.950    62.991     0.200
     3.923    62.501     0.200
     4.188    66.281     0.200
     4.656    72.571     0.200
     4.618    73.651     0.200
     4.618    73.241     0.200
     5.194    81.791     0.200
     5.194    79.171     0.200
     5.271    82.221     0.200
     6.091    91.312     0.200
     6.924   103.341     0.200
     7.121   105.941     0.200
     2.058    35.391     0.200
     2.056    35.570     0.200
     2.099    36.367     0.200
     2.159    36.117     0.200
     2.302    39.047     0.200
     2.267    38.789     0.200
     2.314    39.547     0.200
     2.412    39.555     0.200
     2.428    40.297     0.200
     2.380    40.164     0.200
     2.539    42.000     0.200
     2.590    41.930     0.200
     2.590    42.594     0.200
     2.751    44.914     0.200
     2.751    44.766     0.200
     2.736    45.109     0.200
     2.823    45.695     0.200
     2.823    46.250     0.200
     2.839    46.828     0.200
     2.999    49.055     0.200
     3.058    48.008     0.200
     3.061    48.930     0.200
     3.078    49.211     0.200
     3.024    47.375     0.200
     3.024    47.500     0.200
     3.181    50.203     0.200
     3.218    51.430     0.200
     3.218    51.781     0.200
     3.353    52.914     0.200
     3.353    53.398     0.200
     3.357    53.305     0.200
     3.357    53.688     0.200
     3.245    51.156     0.200
     3.381    53.297     0.200
     3.341    52.836     0.200
     3.341    52.938     0.200
     3.381    52.664     0.200
     3.381    52.328     0.200
     3.446    53.453     0.200
     3.719    58.125     0.200
     3.719    58.305     0.200
     3.782    60.406     0.200
     3.782    60.523     0.200
     3.828    60.070     0.200
     3.878    61.164     0.200
     3.878    61.344     0.200
     3.782    60.797     0.200
     3.950    60.484     0.200
     3.917    60.156     0.200
     3.917    60.711     0.200
     3.863    60.484     0.200
     3.926    59.734     0.200
     3.926    60.133     0.200
     4.052    62.039     0.200
     4.105    63.078     0.200
     4.105    63.531     0.200
     4.270    66.094     0.200
     4.314    66.484     0.200
     4.314    66.070     0.200
     4.314    67.336     0.200
     4.314    67.602     0.200
     4.329    65.969     0.200
     4.509    68.008     0.200
     4.509    68.617     0.200
     4.431    66.977     0.200
     4.431    67.117     0.200
     4.550    69.320     0.200
     4.587    70.188     0.200
     4.643    72.375     0.200
     4.699    71.930     0.200
     4.677    72.148     0.200
     4.677    71.977     0.200
     4.928    74.438     0.200
     5.034    77.328     0.200
     5.157    77.844     0.200
     5.157    78.734     0.200
     5.176    77.898     0.200
     5.176    78.953     0.200
     5.211    78.438     0.200
     5.251    80.703     0.200
     5.251    80.930     0.200
     5.268    80.555     0.200
     5.268    80.109     0.200
     5.288    79.305     0.200
     5.377    81.516     0.200
     5.441    83.375     0.200
     5.599    84.727     0.200
     5.599    85.039     0.200
     5.695    85.164     0.200
     5.695    83.430     0.200
     5.830    89.375     0.200
     5.907    88.570     0.200
     5.983    88.125     0.200
     6.022    90.625     0.200
     6.022    91.031     0.200
     6.060    90.578     0.200
     6.060    90.984     0.200
     6.108    91.453     0.200
     6.108    91.766     0.200
     6.124    91.367     0.200
     6.322    93.773     0.200
     6.366    95.016     0.200
     6.555    97.258     0.200
     6.596    98.516     0.200
     6.613    98.797     0.200
     6.692    98.867     0.200
     6.728    99.219     0.200
     6.788   100.945     0.200
     6.783   100.367     0.200
     6.880   100.984     0.200
     6.968   102.359     0.200
     7.137   103.195     0.200
     7.137   104.477     0.200
     7.254   107.516     0.200
     7.411   108.758     0.200
     7.442   109.617     0.200
     7.580   111.609     0.200
     7.730   111.234     0.200
     7.831   113.695     0.200
     7.930   114.820     0.200
     8.362   121.984     0.200
     8.437   122.984     0.200
     8.549   124.109     0.200
     8.635   125.203     0.200
     8.725   126.023     0.200
     8.795   127.375     0.200
     1.825    31.750     0.200
     2.058    35.547     0.200
     2.161    36.430     0.200
     2.271    38.148     0.200
     2.295    38.891     0.200
     2.365    39.422     0.200
     2.365    40.180     0.200
     2.413    39.922     0.200
     2.419    39.992     0.200
     2.548    42.688     0.200
     2.596    42.867     0.200
     2.596    42.641     0.200
     2.715    44.570     0.200
     2.715    45.508     0.200
     2.744    45.469     0.200
     2.819    47.570     0.200
     2.824    46.758     0.200
     2.844    45.766     0.200
     2.918    47.070     0.200
     2.913    48.922     0.200
     2.980    47.883     0.200
     2.980    49.625     0.200
     3.015    48.445     0.200
     3.046    47.781     0.200
     3.050    48.180     0.200
     3.050    50.312     0.200
     3.087    49.781     0.200
     3.198    51.047     0.200
     3.344    53.758     0.200
     3.368    52.742     0.200
     3.368    53.008     0.200
     3.360    53.633     0.200
     3.360    53.898     0.200
     3.374    54.930     0.200
     3.763    60.586     0.200
     3.861    61.500     0.200
     4.624    72.633     0.200
     5.232    81.422     0.200
     1.814    30.641     0.200
     1.814    30.750     0.200
     1.867    31.672     0.200
     1.901    32.070     0.200
     1.901    32.992     0.200
     1.947    32.523     0.200
     1.978    33.148     0.200
     2.002    33.953     0.200
     2.002    33.852     0.200
     2.049    35.750     0.200
     2.089    34.625     0.200
     2.267    36.891     0.200
     2.278    37.172     0.200
     2.276    36.922     0.200
     2.335    38.523     0.200
     2.335    37.820     0.200
     2.427    39.562     0.200
     2.505    40.719     0.200
     2.505    40.305     0.200
     2.552    41.664     0.200
     2.604    41.609     0.200
     2.652    42.070     0.200
     2.684    42.508     0.200
     2.710    42.703     0.200
     2.745    43.695     0.200
     2.799    44.609     0.200
     2.835    44.852     0.200
     2.822    44.562     0.200
     3.093    48.594     0.200
     3.189    50.125     0.200
     3.189    50.023     0.200
     3.227    50.328     0.200
     3.331    50.875     0.200
     3.615    56.133     0.200
     3.650    56.961     0.200
     3.678    58.078     0.200
     3.996    61.328     0.200
     4.105    62.852     0.200
     4.100    62.422     0.200
     4.365    66.328     0.200
     4.672    70.352     0.200
     4.812    72.703     0.200
     5.752    84.625     0.200
     6.263    93.164     0.200
     6.280    92.805     0.200
     7.318   106.805     0.200
     1.844    33.312     0.200
     1.884    33.962     0.200
     2.012    36.552     0.200
     2.058    35.242     0.200
     2.050    36.441     0.200
     2.105    36.312     0.200
     2.169    37.262     0.200
     2.156    39.072     0.200
     2.308    38.962     0.200
     2.354    40.432     0.200
     2.378    40.182     0.200
     2.542    43.252     0.200
     2.695    44.802     0.200
     2.734    45.462     0.200
     2.796    46.552     0.200
     2.798    46.372     0.200
     2.834    46.312     0.200
     2.882    46.782     0.200
     2.834    46.552     0.200
     2.902    48.191     0.200
     2.953    48.651     0.200
     2.932    49.012     0.200
     2.932    48.632     0.200
     2.937    49.132     0.200
     2.967    47.731     0.200
     2.995    48.632     0.200
     2.989    49.082     0.200
     3.224    51.812     0.200
     3.382    54.731     0.200
     3.382    54.842     0.200
     3.471    56.812     0.200
     3.524    57.172     0.200
     3.861    61.222     0.200
     5.029    78.151     0.200
     7.426   110.062     0.200
     1.796    32.332     0.200
     2.120    37.266     0.200
     2.256    39.023     0.200
     2.345    40.434     0.200
     2.345    39.855     0.200
     3.211    52.875     0.200
     3.812    61.184     0.200
     3.920    62.172     0.200
     4.670    73.355     0.200
     5.280    82.215     0.200
     1.785    31.636     0.200
     1.819    31.266     0.200
     1.838    32.486     0.200
     1.915    34.136     0.200
     1.951    34.246     0.200
     2.285    38.916     0.200
     2.271    38.306     0.200
     3.131    49.736     0.200
     3.214    51.556     0.200
     3.908    61.146     0.200
     4.043    62.936     0.200
     4.275    65.855     0.200
     4.757    72.556     0.200
     6.219    92.526     0.200
     2.005    35.078     0.200
     2.186    36.516     0.200
     2.159    38.234     0.200
     2.350    38.773     0.200
     2.405    39.875     0.200
     2.485    42.484     0.200
     2.455    40.789     0.200
     2.791    46.703     0.200
     2.994    47.562     0.200
     3.150    50.984     0.200
     3.150    50.094     0.200
     3.294    53.078     0.200
     3.642    59.008     0.200
     3.750    59.805     0.200
     3.784    59.828     0.200
     3.893    60.375     0.200
     4.045    63.805     0.200
     4.061    64.172     0.200
     4.907    75.477     0.200
     5.244    81.258     0.200
     1.933    32.195     0.200
     1.985    33.436     0.200
     2.072    34.957     0.200
     2.330    37.377     0.200
     2.390    38.006     0.200
     2.417    39.445     0.200
     2.415    38.486     0.200
     2.717    43.096     0.200
     3.007    47.207     0.200
     3.063    48.906     0.200
     3.328    52.236     0.200
     3.321    51.736     0.200
     4.253    65.707     0.200
     5.664    84.605     0.200
     5.664    84.836     0.200
     1.844    32.457     0.200
     1.844    32.086     0.200
     1.922    33.254     0.200
     1.924    33.484     0.200
     1.941    33.746     0.200
     2.141    36.754     0.200
     2.168    36.746     0.200
     2.178    37.445     0.200
     2.178    37.887     0.200
     2.180    37.246     0.200
     2.273    38.535     0.200
     2.338    39.566     0.200
     2.338    39.363     0.200
     2.422    40.754     0.200
     2.501    41.324     0.200
     2.529    42.047     0.200
     2.554    42.664     0.200
     2.623    42.945     0.200
     2.668    43.363     0.200
     2.713    44.934     0.200
     2.804    45.855     0.200
     2.804    45.605     0.200
     2.877    46.855     0.200
     2.939    47.645     0.200
     3.165    49.945     0.200
     3.181    50.863     0.200
     3.184    50.523     0.200
     3.184    50.695     0.200
     3.284    51.766     0.200
     3.466    55.285     0.200
     3.479    55.375     0.200
     3.508    55.754     0.200
     3.528    55.977     0.200
     3.649    58.406     0.200
     3.659    58.613     0.200
     3.737    59.926     0.200
     3.894    61.766     0.200
     3.894    62.695     0.200
     3.983    62.594     0.200
     3.983    63.066     0.200
     4.178    64.504     0.200
     4.178    64.664     0.200
     4.216    65.496     0.200
     4.610    71.297     0.200
     4.657    71.824     0.200
     4.705    72.316     0.200
     4.818    73.414     0.200
     4.916    75.215     0.200
     5.113    78.137     0.200
     5.113    77.477     0.200
     5.152    77.977     0.200
     5.167    78.234     0.200
     5.310    80.195     0.200
     5.374    80.215     0.200
     5.562    83.766     0.200
     5.821    87.207     0.200
     5.821    85.535     0.200
     5.821    87.207     0.200
     6.165    92.035     0.200
     6.223    93.047     0.200
     6.809   100.695     0.200
     7.180   104.504     0.200
     7.180   103.895     0.200
     7.317   106.824     0.200
     7.469   109.734     0.200
     7.700   112.863     0.200
     8.000   116.625     0.200
     8.590   124.227     0.200
     8.633   124.734     0.200
     8.633   125.766     0.200
     8.760   127.637     0.200
     9.646   139.465     0.200
    10.290   148.523     0.200
    12.153   173.059     0.200
    12.209   174.586     0.200
     2.150    36.910     0.200
     2.179    38.340     0.200
     2.181    38.230     0.200
     2.181    38.152     0.200
     2.278    38.840     0.200
     2.325    39.840     0.200
     2.325    39.641     0.200
     2.416    40.992     0.200
     2.533    42.402     0.200
     2.550    43.109     0.200
     2.677    43.629     0.200
     2.713    45.211     0.200
     2.799    45.672     0.200
     2.799    45.441     0.200
     2.943    48.191     0.200
     3.175    51.301     0.200
     3.179    50.781     0.200
     3.291    52.941     0.200
     3.472    55.309     0.200
     3.477    55.270     0.200
     3.634    59.129     0.200
     3.973    63.051     0.200
     4.128    64.469     0.200
     4.176    64.902     0.200
     4.221    65.621     0.200
     4.618    72.219     0.200
     4.663    71.840     0.200
     4.708    72.332     0.200
     4.813    73.879     0.200
     4.923    75.289     0.200
     5.105    77.055     0.200
     5.819    87.648     0.200
     7.193   104.598     0.200
     8.621   126.082     0.200
    12.139   173.180     0.200
     1.908    33.805     0.200
     2.013    35.004     0.200
     2.168    39.455     0.200
     2.263    39.154     0.200
     2.282    40.693     0.200
     2.345    39.715     0.200
     2.426    41.295     0.200
     2.412    41.314     0.200
     2.456    41.504     0.200
     2.459    42.113     0.200
     2.459    41.494     0.200
     2.598    44.314     0.200
     2.675    45.844     0.200
     2.918    48.904     0.200
     2.921    49.014     0.200
     2.958    47.725     0.200
     2.992    47.674     0.200
     3.067    49.234     0.200
     3.067    49.404     0.200
     3.215    52.674     0.200
     3.229    52.184     0.200
     3.395    54.434     0.200
     3.450    55.215     0.200
     3.769    61.285     0.200
     3.796    60.045     0.200
     3.774    59.984     0.200
     3.774    60.693     0.200
     3.903    61.625     0.200
     3.903    62.754     0.200
     3.961    62.693     0.200
     4.128    65.645     0.200
     4.166    65.914     0.200
     4.373    68.705     0.200
     4.407    68.594     0.200
     4.437    69.225     0.200
     4.670    72.785     0.200
     5.027    77.273     0.200
     5.340    81.465     0.200
     5.373    83.164     0.200
     5.714    87.135     0.200
     5.921    89.734     0.200
     7.497   111.135     0.200
     8.469   125.215     0.200
     1.845    30.723     0.200
     1.845    31.043     0.200
     1.879    31.094     0.200
     1.901    31.805     0.200
     1.956    32.676     0.200
     1.956    33.195     0.200
     1.971    32.395     0.200
     2.038    34.375     0.200
     2.038    34.094     0.200
     2.037    34.336     0.200
     2.069    34.176     0.200
     2.088    34.176     0.200
     2.073    34.426     0.200
     2.039    33.734     0.200
     2.279    36.703     0.200
     2.298    37.254     0.200
     2.372    38.164     0.200
     2.371    38.363     0.200
     2.458    39.445     0.200
     2.624    42.004     0.200
     2.624    41.895     0.200
     2.508    41.484     0.200
     2.717    43.434     0.200
     2.625    41.645     0.200
     2.625    41.984     0.200
     2.761    43.656     0.200
     2.757    44.113     0.200
     2.813    44.516     0.200
     2.819    44.336     0.200
     3.125    49.363     0.200
     3.139    50.035     0.200
     3.233    51.484     0.200
     3.304    51.633     0.200
     3.389    53.465     0.200
     3.460    54.215     0.200
     3.641    56.305     0.200
     3.692    57.746     0.200
     4.012    61.586     0.200
     4.103    62.094     0.200
     4.164    62.906     0.200
     4.164    63.734     0.200
     4.608    69.195     0.200
     4.647    69.383     0.200
     4.709    70.633     0.200
     4.709    71.203     0.200
     4.894    72.805     0.200
     4.958    74.664     0.200
     5.023    74.223     0.200
     5.507    80.566     0.200
     2.100    36.879     0.200
     3.615    58.828     0.200
     4.428    70.438     0.200
     2.236    38.805     0.200
     2.251    39.385     0.200
     2.436    41.186     0.200
     2.472    41.745     0.200
     2.472    41.985     0.200
     2.938    48.146     0.200
     2.889    47.945     0.200
     2.892    48.485     0.200
     3.023    48.825     0.200
     3.021    49.005     0.200
     3.021    49.375     0.200
     3.095    49.476     0.200
     3.189    51.936     0.200
     3.168    50.726     0.200
     3.172    52.476     0.200
     3.199    52.706     0.200
     3.295    53.545     0.200
     3.408    53.945     0.200
     3.424    54.505     0.200
     3.478    55.335     0.200
     3.619    57.436     0.200
     3.660    58.655     0.200
     3.660    59.575     0.200
     3.797    59.545     0.200
     3.766    60.456     0.200
     3.745    60.686     0.200
     3.745    61.255     0.200
     3.923    60.965     0.200
     3.935    62.765     0.200
     3.966    62.515     0.200
     4.136    66.105     0.200
     4.349    68.785     0.200
     4.496    71.726     0.200
     4.521    71.235     0.200
     4.645    72.245     0.200
     4.855    75.515     0.200
     4.978    76.635     0.200
     4.997    76.666     0.200
     5.151    77.896     0.200
     5.428    83.396     0.200
     5.473    82.585     0.200
     5.568    83.565     0.200
     5.564    84.416     0.200
     5.687    87.265     0.200
     5.896    89.735     0.200
     5.967    90.115     0.200
     6.560    98.075     0.200
     2.399    41.438     0.200
     2.966    48.137     0.200
     3.837    61.797     0.200
     4.603    71.777     0.200
     4.678    73.066     0.200
     2.020    35.808     0.200
     2.391    41.308     0.200
     4.673    72.738     0.200
     1.886    32.523     0.200
     1.908    33.312     0.200
     1.937    32.676     0.200
     1.959    33.293     0.200
     2.154    36.832     0.200
     2.169    36.344     0.200
     2.252    37.805     0.200
     2.251    38.176     0.200
     2.333    38.613     0.200
     2.403    39.633     0.200
     2.478    40.562     0.200
     2.593    41.613     0.200
     2.626    42.453     0.200
     2.673    42.824     0.200
     2.681    43.613     0.200
     2.753    44.832     0.200
     2.753    44.266     0.200
     3.001    47.766     0.200
     2.947    46.176     0.200
     3.071    49.562     0.200
     3.173    49.523     0.200
     3.513    54.305     0.200
     3.528    55.465     0.200
     3.561    56.594     0.200
     3.757    58.543     0.200
     3.974    61.285     0.200
     4.126    63.445     0.200
     4.266    64.625     0.200
     4.477    67.164     0.200
     4.558    68.504     0.200
     4.771    72.234     0.200
     4.785    72.473     0.200
     4.956    75.652     0.200
     5.183    77.414     0.200
     1.907    32.074     0.200
     1.928    32.375     0.200
     1.910    32.043     0.200
     2.003    33.793     0.200
     2.002    33.895     0.200
     2.080    33.516     0.200
     2.260    36.414     0.200
     2.341    37.773     0.200
     2.387    37.645     0.200
     2.437    38.934     0.200
     2.410    39.254     0.200
     2.469    39.434     0.200
     2.574    40.645     0.200
     2.748    44.113     0.200
     2.861    45.254     0.200
     2.932    46.254     0.200
     3.066    48.395     0.200
     3.121    48.434     0.200
     3.121    47.426     0.200
     3.259    51.074     0.200
     3.292    51.855     0.200
     3.324    52.543     0.200
     3.316    51.242     0.200
     3.391    51.863     0.200
     3.634    55.113     0.200
     3.750    56.434     0.200
     3.745    57.355     0.200
     3.827    58.824     0.200
     3.927    59.004     0.200
     4.005    61.242     0.200
     4.011    60.734     0.200
     4.077    61.805     0.200
     4.077    61.152     0.200
     4.233    63.254     0.200
     4.342    65.035     0.200
     4.349    64.676     0.200
     4.447    66.414     0.200
     4.519    67.934     0.200
     4.653    69.484     0.200
     4.885    73.133     0.200
     4.940    73.234     0.200
     5.139    75.543     0.200
     5.178    76.945     0.200
     5.391    80.223     0.200
     5.448    80.125     0.200
     5.422    79.574     0.200
     5.768    87.152     0.200
     5.862    84.324     0.200
     2.003    35.266     0.200
     2.045    36.414     0.200
     2.017    37.227     0.200
     2.368    42.000     0.200
     2.407    43.320     0.200
     2.778    46.109     0.200
     2.875    47.289     0.200
     2.964    48.562     0.200
     3.025    49.352     0.200
     3.077    48.266     0.200
     3.046    49.703     0.200
     3.309    53.836     0.200
     3.402    56.266     0.200
     3.882    62.422     0.200
     4.058    64.023     0.200
     4.001    63.242     0.200
     4.318    67.156     0.200
     4.458    69.727     0.200
     4.500    70.023     0.200
     4.659    72.555     0.200
     4.676    72.695     0.200
     5.113    78.461     0.200
     1.902    33.695     0.200
     1.910    33.809     0.200
     2.149    38.465     0.200
     2.198    38.777     0.200
     2.247    38.367     0.200
     2.335    40.715     0.200
     2.335    40.465     0.200
     2.384    42.348     0.200
     2.501    41.746     0.200
     2.516    42.387     0.200
     2.747    45.586     0.200
     2.830    46.637     0.200
     2.830    46.777     0.200
     2.912    49.027     0.200
     3.006    50.426     0.200
     3.151    51.375     0.200
     3.154    52.457     0.200
     3.443    55.777     0.200
     3.472    56.656     0.200
     3.516    55.258     0.200
     3.944    63.656     0.200
     3.944    63.156     0.200
     4.142    65.375     0.200
     4.192    66.617     0.200
     4.402    70.516     0.200
     4.419    68.438     0.200
     4.591    72.387     0.200
     4.634    72.656     0.200
     4.677    73.016     0.200
     4.725    75.496     0.200
     4.779    74.688     0.200
     4.894    76.348     0.200
     4.946    77.508     0.200
     5.150    78.906     0.200
     5.576    85.215     0.200
     3.142    51.488     0.200
     1.893    32.828     0.200
     1.928    34.039     0.200
     1.928    33.789     0.200
     2.014    34.844     0.200
     2.088    35.883     0.200
     2.262    38.289     0.200
     2.262    38.375     0.200
     2.260    38.406     0.200
     2.257    37.922     0.200
     2.361    39.336     0.200
     2.612    43.438     0.200
     2.615    43.023     0.200
     2.641    44.406     0.200
     2.716    44.812     0.200
     2.716    43.547     0.200
     3.375    53.055     0.200
     3.556    55.586     0.200
     3.575    55.438     0.200
     3.580    56.945     0.200
     3.639    57.203     0.200
     4.003    62.625     0.200
     4.003    62.992     0.200
     4.241    67.086     0.200
     4.241    65.305     0.200
     4.305    66.766     0.200
     4.498    68.836     0.200
     4.747    72.297     0.200
     4.798    72.984     0.200
     4.798    73.945     0.200
     3.230    50.984     0.200
     1.896    32.938     0.200
     1.931    33.586     0.200
     1.931    33.945     0.200
     2.017    34.688     0.200
     2.084    36.617     0.200
     2.265    37.914     0.200
     2.265    38.602     0.200
     2.264    37.930     0.200
     2.252    37.969     0.200
     2.364    39.656     0.200
     2.614    43.328     0.200
     2.618    43.367     0.200
     2.639    43.148     0.200
     2.713    45.250     0.200
     2.713    43.539     0.200
     2.843    45.117     0.200
     3.235    53.070     0.200
     3.559    55.547     0.200
     3.578    57.516     0.200
     4.002    62.641     0.200
     4.242    66.031     0.200
     4.242    64.875     0.200
     4.309    66.398     0.200
     4.797    72.711     0.200
     4.797    73.781     0.200
     5.011    75.852     0.200
     3.231    50.430     0.200
     1.988    35.008     0.200
     2.095    36.344     0.200
     2.112    35.750     0.200
     2.169    37.555     0.200
     2.118    38.297     0.200
     2.288    39.227     0.200
     2.353    39.461     0.200
     2.515    42.055     0.200
     2.579    43.250     0.200
     2.617    42.344     0.200
     2.886    48.766     0.200
     2.971    47.898     0.200
     2.990    48.141     0.200
     3.105    50.258     0.200
     3.169    51.906     0.200
     3.205    51.180     0.200
     3.470    56.164     0.200
     3.893    60.164     0.200
     3.901    60.914     0.200
     4.517    69.719     0.200
    15.354   217.039     0.200
    15.444   219.484     0.200
    15.571   220.836     0.200
    15.990   225.820     0.200
    16.200   228.359     0.200
     1.250    24.953     0.200
     2.990    48.555     0.200
     2.990    48.664     0.200
     4.000    63.164     0.200
     5.217    79.469     0.200
     5.483    82.875     0.200
     6.598    99.086     0.200
     6.544   101.766     0.200
     6.691   102.891     0.200
     6.945   105.969     0.200
     6.941   106.664     0.200
     7.243   108.664     0.200
     7.243   108.938     0.200
     7.874   117.664     0.200
     8.236   123.266     0.200
     8.310   125.070     0.200
     8.334   124.195     0.200
     8.334   123.773     0.200
     8.642   128.273     0.200
    10.114   150.250     0.200
    10.129   150.969     0.200
    10.371   151.961     0.200
    12.620   182.219     0.200
    12.926   188.258     0.200
    13.831   198.836     0.200
    13.944   201.758     0.200
    13.997   201.477     0.200
    15.354   219.383     0.200
    15.931   225.727     0.200
    15.990   225.984     0.200
     1.912    33.664     0.200
     1.947    34.266     0.200
     2.720    46.539     0.200
     2.867    48.094     0.200
     3.152    50.664     0.200
     3.396    54.922     0.200
     3.778    60.352     0.200
     3.794    59.734     0.200
     3.772    59.344     0.200
     4.008    62.734     0.200
     4.007    63.000     0.200
     4.262    66.023     0.200
     4.560    70.266     0.200
     4.853    74.664     0.200
     5.015    75.281     0.200
     5.098    78.453     0.200
     5.386    80.992     0.200
     5.890    89.430     0.200
     6.176    93.312     0.200
     6.179    92.422     0.200
     6.613   100.289     0.200
     7.250   107.000     0.200
     7.351   108.594     0.200
     7.914   116.094     0.200
     8.417   123.070     0.200
     9.429   138.734     0.200
     9.530   140.336     0.200
    11.283   162.180     0.200
    12.285   175.336     0.200
    12.704   181.164     0.200
    12.891   184.930     0.200
    15.340   218.859     0.200
    16.004   224.641     0.200
     7.250   107.211     0.200
     1.836    34.336     0.200
     1.876    34.602     0.200
     1.920    35.203     0.200
     1.990    36.281     0.200
     2.279    40.117     0.200
     2.356    41.281     0.200
     2.524    42.922     0.200
     2.586    44.133     0.200
     2.615    45.805     0.200
     3.112    50.414     0.200
     3.174    52.570     0.200
     3.202    53.773     0.200
     3.983    62.312     0.200
     3.897    63.273     0.200
     4.518    71.375     0.200
     4.984    76.227     0.200
     5.018    77.961     0.200
     6.600    98.695     0.200
     6.764    99.461     0.200
     7.333   109.500     0.200
    15.999   224.852     0.200
     1.925    34.883     0.200
     2.110    37.086     0.200
     2.179    38.125     0.200
     2.153    39.055     0.200
     2.381    41.766     0.200
     2.524    42.539     0.200
     2.594    43.844     0.200
     2.651    45.086     0.200
     3.122    50.906     0.200
     3.192    51.680     0.200
     3.240    53.570     0.200
     3.499    56.109     0.200
     3.988    62.133     0.200
     3.936    63.180     0.200
     4.190    66.266     0.200
     4.991    75.789     0.200
     5.839    90.883     0.200
     5.853    88.836     0.200
     6.138    93.633     0.200
     6.824   102.266     0.200
     7.247   107.930     0.200
     7.336   108.922     0.200
     8.266   121.414     0.200
     9.355   137.484     0.200
    10.246   149.164     0.200
    11.278   163.500     0.200
    12.242   179.266     0.200
     1.959    35.828     0.200
     1.924    35.188     0.200
     1.932    36.867     0.200
     2.058    37.352     0.200
     2.034    36.016     0.200
     2.161    39.438     0.200
     2.409    41.328     0.200
     2.441    42.875     0.200
     2.412    42.758     0.200
     2.606    45.023     0.200
     3.002    50.914     0.200
     3.140    52.102     0.200
     3.341    54.008     0.200
     3.313    55.906     0.200
     3.500    55.531     0.200
     3.617    57.234     0.200
     3.521    57.672     0.200
     3.633    59.305     0.200
     3.698    60.242     0.200
     3.848    60.914     0.200
     3.878    61.898     0.200
     3.955    63.758     0.200
     4.319    68.227     0.200
     4.667    73.797     0.200
     4.821    75.672     0.200
     4.863    77.031     0.200
     5.149    79.766     0.200
     5.614    84.523     0.200
     5.621    87.438     0.200
     7.154   106.023     0.200
     7.204   107.555     0.200
     8.149   120.594     0.200
     9.394   137.648     0.200
    10.204   149.008     0.200
    10.557   153.562     0.200
    10.866   158.812     0.200
    15.889   225.094     0.200
     1.878    33.508     0.200
     1.932    35.086     0.200
     2.046    36.812     0.200
     2.158    37.836     0.200
     2.172    38.398     0.200
     2.231    38.773     0.200
     2.227    39.227     0.200
     2.413    42.156     0.200
     2.576    42.938     0.200
     2.642    44.234     0.200
     2.825    46.938     0.200
     3.169    51.305     0.200
     3.232    52.766     0.200
     3.247    54.234     0.200
     3.384    54.562     0.200
     4.038    62.906     0.200
     5.061    78.914     0.200
     6.550    97.594     0.200
     8.318   122.539     0.200
     8.461   123.734     0.200
     8.583   125.859     0.200
     9.624   139.984     0.200
    10.291   149.234     0.200
     1.885    33.891     0.200
     1.904    34.547     0.200
     1.946    35.547     0.200
     1.999    36.219     0.200
     2.067    36.719     0.200
     2.125    38.125     0.200
     2.350    40.469     0.200
     2.386    40.648     0.200
     2.400    41.688     0.200
     2.465    42.461     0.200
     2.537    44.164     0.200
     2.600    46.180     0.200
     2.698    46.031     0.200
     2.904    48.758     0.200
     2.951    48.875     0.200
     2.997    50.656     0.200
     3.099    52.047     0.200
     3.186    52.609     0.200
     3.287    53.680     0.200
     3.262    54.078     0.200
     3.440    54.945     0.200
     3.552    56.414     0.200
     3.614    58.797     0.200
     3.695    60.117     0.200
     3.791    59.914     0.200
     3.839    62.367     0.200
     3.955    63.625     0.200
     3.974    63.695     0.200
     4.287    68.148     0.200
     4.293    69.688     0.200
     4.818    75.414     0.200
     4.898    76.719     0.200
     5.123    80.625     0.200
     5.885    90.547     0.200
     6.434    97.961     0.200
     6.718    98.914     0.200
     8.106   121.258     0.200
     9.130   136.109     0.200
     9.238   137.094     0.200
     1.908    34.258     0.200
     2.001    35.914     0.200
     1.961    35.547     0.200
     2.055    36.703     0.200
     2.136    36.766     0.200
     2.351    40.242     0.200
     2.391    41.477     0.200
     2.415    42.586     0.200
     2.461    41.484     0.200
     2.593    45.844     0.200
     2.714    46.008     0.200
     2.910    47.812     0.200
     2.959    48.719     0.200
     3.012    50.594     0.200
     3.128    53.234     0.200
     3.171    53.188     0.200
     3.206    51.609     0.200
     3.292    52.930     0.200
     3.269    53.508     0.200
     3.575    56.953     0.200
     3.540    56.625     0.200
     3.566    57.734     0.200
     3.628    58.789     0.200
     3.710    60.094     0.200
     3.795    59.398     0.200
     3.849    61.539     0.200
     3.970    63.664     0.200
     4.020    63.727     0.200
     3.989    64.273     0.200
     4.092    64.828     0.200
     4.079    65.844     0.200
     4.101    65.289     0.200
     4.102    64.492     0.200
     4.181    65.664     0.200
     4.198    66.438     0.200
     4.284    66.336     0.200
     4.302    67.523     0.200
     4.299    67.609     0.200
     4.308    69.062     0.200
     4.391    69.445     0.200
     4.398    70.117     0.200
     4.410    70.039     0.200
     4.568    71.609     0.200
     4.632    73.383     0.200
     4.789    72.945     0.200
     4.871    76.016     0.200
     4.833    75.133     0.200
     4.912    76.719     0.200
     5.121    78.094     0.200
     5.102    78.445     0.200
     5.136    79.992     0.200
     5.339    83.195     0.200
     5.356    81.984     0.200
     5.500    83.945     0.200
     5.562    83.586     0.200
     5.532    84.273     0.200
     5.595    86.742     0.200
     5.639    86.898     0.200
     5.666    87.258     0.200
     5.771    87.297     0.200
     5.906    90.367     0.200
     5.899    90.195     0.200
     6.305    96.125     0.200
     6.327    96.367     0.200
     6.369    95.430     0.200
     6.387    96.742     0.200
     6.452    98.227     0.200
     6.566    98.242     0.200
     6.525    99.125     0.200
     6.807   102.273     0.200
     7.094   104.828     0.200
     7.150   106.648     0.200
     7.247   109.117     0.200
     7.239   108.539     0.200
     7.586   112.289     0.200
     7.681   113.242     0.200
     7.891   116.133     0.200
     8.231   121.180     0.200
     8.310   123.055     0.200
     9.145   136.359     0.200
     9.217   136.930     0.200
     9.286   138.383     0.200
     9.561   139.242     0.200
    10.028   145.734     0.200
    10.289   151.836     0.200
    10.524   152.375     0.200
    10.818   156.688     0.200
    11.118   160.539     0.200
    11.082   162.047     0.200
    12.403   178.703     0.200
     2.001    35.812     0.200
     2.133    36.352     0.200
     2.058    35.477     0.200
     2.351    40.586     0.200
     2.390    40.594     0.200
     2.411    42.344     0.200
     2.590    45.047     0.200
     2.462    42.172     0.200
     2.709    46.164     0.200
     2.909    46.719     0.200
     2.957    47.969     0.200
     3.007    49.117     0.200
     3.291    52.656     0.200
     3.176    51.742     0.200
     3.267    52.172     0.200
     3.573    56.102     0.200
     3.624    57.352     0.200
     3.543    56.312     0.200
     3.562    58.023     0.200
     3.794    59.125     0.200
     3.705    59.586     0.200
     3.846    60.648     0.200
     3.965    62.445     0.200
     3.985    63.523     0.200
     4.090    64.258     0.200
     4.179    64.914     0.200
     4.106    65.492     0.200
     4.282    66.633     0.200
     4.299    67.625     0.200
     4.296    68.055     0.200
     4.303    68.781     0.200
     4.388    68.945     0.200
     4.566    71.305     0.200
     4.630    72.016     0.200
     4.869    74.922     0.200
     4.829    73.695     0.200
     4.907    75.484     0.200
     5.132    79.266     0.200
     5.335    83.031     0.200
     5.495    83.375     0.200
     5.592    86.445     0.200
     5.634    86.234     0.200
     5.895    88.812     0.200
     6.324    96.602     0.200
     7.094   104.914     0.200
     7.234   107.453     0.200
     7.890   115.969     0.200
     8.306   122.156     0.200
     9.140   135.156     0.200
    10.285   151.148     0.200
    10.360   152.117     0.200
     1.914    35.023     0.200
     1.874    34.680     0.200
     2.266    39.320     0.200
     2.289    39.016     0.200
     2.300    40.344     0.200
     2.625    44.523     0.200
     2.560    42.383     0.200
     2.803    45.852     0.200
     2.842    46.656     0.200
     3.188    50.352     0.200
     3.158    51.391     0.200
     3.462    55.594     0.200
     3.508    57.016     0.200
     3.600    58.195     0.200
     3.697    58.805     0.200
     3.727    59.805     0.200
     3.864    61.711     0.200
     3.977    62.164     0.200
     4.069    63.922     0.200
     4.166    65.461     0.200
     4.181    65.836     0.200
     4.176    66.031     0.200
     4.757    73.859     0.200
     4.746    73.461     0.200
     4.725    73.805     0.200
     5.472    84.555     0.200
     5.701    87.336     0.200
     6.021    90.977     0.200
     6.218    94.023     0.200
     7.014   104.305     0.200
     9.917   144.562     0.200
     1.910    34.031     0.200
     2.004    36.359     0.200
     1.956    36.336     0.200
     2.056    36.500     0.200
     2.136    36.922     0.200
     2.354    39.984     0.200
     2.393    40.195     0.200
     2.412    42.445     0.200
     2.548    44.672     0.200
     2.592    45.273     0.200
     2.710    46.062     0.200
     2.713    47.539     0.200
     2.912    47.266     0.200
     2.960    48.594     0.200
     3.008    50.070     0.200
     3.108    52.133     0.200
     3.126    53.516     0.200
     3.174    52.648     0.200
     3.294    53.398     0.200
     3.270    53.031     0.200
     3.444    54.531     0.200
     3.625    59.094     0.200
     3.706    59.555     0.200
     3.797    59.094     0.200
     3.849    61.055     0.200
     3.966    63.602     0.200
     3.986    62.469     0.200
     4.020    63.766     0.200
     4.093    63.898     0.200
     4.182    64.750     0.200
     4.201    67.883     0.200
     4.285    67.422     0.200
     4.302    67.711     0.200
     4.298    67.609     0.200
     4.395    70.500     0.200
     4.632    73.133     0.200
     4.791    72.703     0.200
     4.830    74.492     0.200
     4.872    75.242     0.200
     4.906    76.016     0.200
     5.123    78.664     0.200
     5.134    80.320     0.200
     5.337    82.750     0.200
     5.352    81.469     0.200
     5.352    80.961     0.200
     5.497    84.953     0.200
     5.564    83.195     0.200
     5.594    85.680     0.200
     5.768    87.523     0.200
     5.907    89.531     0.200
     5.897    89.891     0.200
     6.074    92.133     0.200
     6.138    92.984     0.200
     6.326    96.000     0.200
     6.520    98.883     0.200
     6.584    99.953     0.200
     6.620   100.125     0.200
     6.749   101.609     0.200
     7.097   104.742     0.200
     7.153   106.336     0.200
     7.234   108.383     0.200
     7.745   114.992     0.200
     7.820   116.023     0.200
     7.909   117.086     0.200
     7.916   116.930     0.200
     8.090   119.320     0.200
     8.094   119.266     0.200
     8.154   120.320     0.200
     8.118   121.844     0.200
     8.183   120.539     0.200
     8.188   121.086     0.200
     8.234   121.562     0.200
     8.284   122.062     0.200
     8.319   122.742     0.200
     8.306   124.875     0.200
     8.307   124.219     0.200
     8.351   122.719     0.200
     8.415   124.023     0.200
     8.486   124.703     0.200
     8.905   130.820     0.200
    10.029   146.031     0.200
    10.360   152.039     0.200
     1.934    34.492     0.200
     1.891    34.773     0.200
     2.058    36.641     0.200
     2.065    38.312     0.200
     2.139    38.023     0.200
     2.301    39.867     0.200
     2.318    39.992     0.200
     2.486    42.422     0.200
     2.541    42.820     0.200
     2.560    44.133     0.200
     2.753    47.273     0.200
     2.828    46.922     0.200
     3.065    49.984     0.200
     3.028    50.414     0.200
     3.122    50.828     0.200
     3.045    49.531     0.200
     3.149    52.438     0.200
     3.445    54.734     0.200
     3.427    55.484     0.200
     3.380    54.211     0.200
     3.627    59.141     0.200
     3.734    59.273     0.200
     3.782    60.484     0.200
     3.844    60.867     0.200
     3.941    61.109     0.200
     4.014    63.672     0.200
     3.950    62.859     0.200
     4.099    64.820     0.200
     4.056    65.562     0.200
     4.129    65.898     0.200
     4.254    66.938     0.200
     4.340    67.398     0.200
     4.448    69.500     0.200
     4.467    69.820     0.200
     4.462    69.859     0.200
     4.453    70.422     0.200
     4.551    71.508     0.200
     4.733    73.500     0.200
     4.939    75.320     0.200
     4.966    76.961     0.200
     5.032    77.602     0.200
     5.277    80.070     0.200
     5.296    80.828     0.200
     5.497    84.734     0.200
     5.496    83.250     0.200
     5.496    83.078     0.200
     5.540    83.391     0.200
     5.648    85.414     0.200
     5.678    85.312     0.200
     5.710    85.414     0.200
     5.760    87.797     0.200
     5.763    86.859     0.200
     5.911    88.953     0.200
     6.069    92.094     0.200
     6.050    90.734     0.200
     6.464    97.133     0.200
     6.491    97.938     0.200
     6.543    98.828     0.200
     6.615    98.758     0.200
     6.638   100.953     0.200
     6.655   100.258     0.200
     7.219   106.641     0.200
     7.293   108.609     0.200
     7.342   109.742     0.200
     7.400   110.672     0.200
     7.632   113.469     0.200
     7.748   114.109     0.200
     8.254   122.641     0.200
     8.370   123.383     0.200
     8.461   126.578     0.200
     9.171   134.000     0.200
     9.265   137.438     0.200
     9.374   138.781     0.200
     9.515   138.844     0.200
    10.481   154.523     0.200
    11.245   161.719     0.200
    12.129   176.109     0.200
    12.469   180.180     0.200
     1.908    34.330     0.200
     1.918    34.650     0.200
     2.046    37.020     0.200
     2.031    37.670     0.200
     2.132    38.370     0.200
     2.276    39.600     0.200
     2.326    40.410     0.200
     2.481    42.460     0.200
     2.530    43.680     0.200
     2.528    44.310     0.200
     2.724    47.490     0.200
     2.793    47.380     0.200
     2.798    47.920     0.200
     3.051    50.120     0.200
     3.061    50.900     0.200
     3.103    51.110     0.200
     3.073    50.080     0.200
     3.115    52.380     0.200
     3.264    55.440     0.200
     3.432    54.740     0.200
     3.409    55.460     0.200
     3.412    55.230     0.200
     3.566    56.930     0.200
     3.595    59.430     0.200
     3.718    59.810     0.200
     3.751    60.930     0.200
     3.811    60.950     0.200
     3.932    62.200     0.200
     3.990    64.640     0.200
     3.982    63.250     0.200
     4.065    64.360     0.200
     4.096    65.530     0.200
     4.162    67.080     0.200
     4.236    67.260     0.200
     4.324    67.620     0.200
     4.428    70.090     0.200
     4.420    70.940     0.200
     4.436    70.180     0.200
     4.444    69.490     0.200
     4.521    71.720     0.200
     4.711    73.530     0.200
     4.775    75.120     0.200
     4.928    75.350     0.200
     4.932    77.030     0.200
     5.015    78.110     0.200
     5.263    79.850     0.200
     5.478    85.800     0.200
     5.463    83.050     0.200
     5.549    85.580     0.200
     5.616    86.960     0.200
     5.735    88.890     0.200
     5.729    89.210     0.200
     5.877    89.580     0.200
     5.964    90.990     0.200
     6.217    94.420     0.200
     6.280    95.060     0.200
     6.296    96.550     0.200
     6.458    98.690     0.200
     6.466    98.340     0.200
     6.555    99.330     0.200
     6.550   100.360     0.200
     6.588    99.420     0.200
     6.723   101.420     0.200
     6.686   100.540     0.200
     7.217   106.600     0.200
     7.285   108.580     0.200
     7.308   109.650     0.200
     7.600   114.170     0.200
     8.034   118.670     0.200
     8.266   122.200     0.200
     8.363   123.560     0.200
     8.430   127.000     0.200
     8.535   127.260     0.200
     9.314   138.930     0.200
     9.322   139.230     0.200
     9.727   144.550     0.200
    10.094   148.840     0.200
    10.171   148.060     0.200
    10.447   153.990     0.200
    15.277   217.240     0.200
    15.960   224.360     0.200
    16.169   229.120     0.200
     1.973    35.529     0.200
     1.928    36.609     0.200
     2.073    37.499     0.200
     2.028    36.489     0.200
     2.170    38.419     0.200
     2.424    42.139     0.200
     2.413    43.339     0.200
     2.455    42.579     0.200
     2.394    41.679     0.200
     2.611    46.619     0.200
     2.970    49.529     0.200
     3.008    50.299     0.200
    15.390   219.719     0.200
    15.904   225.149     0.200
    16.094   229.189     0.200
     5.685    86.129     0.200
     7.169   106.639     0.200
     8.214   121.739     0.200
     8.777   129.999     0.200
    10.302   153.279     0.200
    12.876   185.259     0.200
     1.922    35.290     0.200
     1.927    35.550     0.200
     1.988    35.520     0.200
     2.103    37.570     0.200
     2.180    38.650     0.200
     2.107    37.880     0.200
     2.354    40.770     0.200
     2.277    39.490     0.200
     2.526    42.820     0.200
     2.587    44.270     0.200
     2.611    45.890     0.200
     3.113    50.940     0.200
     1.887    35.252     0.200
     1.971    36.053     0.200
     2.066    36.112     0.200
     1.876    34.002     0.200
     1.924    36.322     0.200
     1.975    35.982     0.200
     1.885    34.348     0.200
     1.839    33.428     0.200
     1.987    35.968     0.200
     2.092    37.698     0.200
     2.112    37.388     0.200
     2.114    37.608     0.200
     2.191    38.548     0.200
     2.266    39.488     0.200
     2.354    41.088     0.200
     2.538    42.458     0.200
     2.596    43.559     0.200
     2.603    44.769     0.200
     2.766    47.378     0.200
     2.802    48.068     0.200
     2.862    49.028     0.200
     2.988    49.568     0.200
     2.995    48.388     0.200
     3.120    50.328     0.200
     3.177    51.148     0.200
     3.188    52.098     0.200
     3.331    53.118     0.200
     7.269   106.858     0.200
     8.106   119.718     0.200
     8.601   127.338     0.200
    10.241   149.098     0.200
    10.465   152.378     0.200
    10.511   154.878     0.200
     1.844    33.446     0.200
     1.945    35.477     0.200
     1.912    35.587     0.200
     2.062    35.937     0.200
     2.129    38.307     0.200
     2.296    39.616     0.200
     2.326    40.427     0.200
     2.347    41.837     0.200
     2.520    45.026     0.200
     2.660    45.616     0.200
     2.843    46.597     0.200
     2.887    48.217     0.200
     2.947    49.196     0.200
     2.073    36.715     0.200
     2.127    38.595     0.200
     2.314    40.385     0.200
     2.368    40.735     0.200
     2.383    41.125     0.200
     2.465    42.255     0.200
     2.893    48.315     0.200
     2.920    48.795     0.200
     2.905    48.405     0.200
     3.546    56.985     0.200
     3.794    60.056     0.200
     1.982    33.199     0.200
     2.334    37.900     0.200
     2.358    37.881     0.200
     2.907    46.301     0.200
     3.257    50.990     0.200
     3.226    50.930     0.200
     3.251    51.520     0.200
     3.427    53.420     0.200
     3.277    50.779     0.200
     3.529    54.709     0.200
     3.766    58.350     0.200
     3.612    55.760     0.200
     3.788    59.090     0.200
     3.889    60.619     0.200
     4.136    62.811     0.200
     4.243    65.551     0.200
     4.318    67.221     0.200
     4.823    73.020     0.200
     4.845    73.881     0.200
     5.063    76.359     0.200
     5.276    78.391     0.200
     5.421    80.410     0.200
     5.531    81.820     0.200
     5.558    83.709     0.200
     5.854    87.010     0.200
     5.770    84.900     0.200
     6.262    93.439     0.200
     6.383    94.459     0.200
     6.444    95.869     0.200
     7.081   103.881     0.200
     7.124   104.859     0.200
     7.170   105.301     0.200
     7.406   108.199     0.200
     7.515   109.529     0.200
     7.846   114.391     0.200
     8.062   117.279     0.200
     9.209   134.939     0.200
    10.284   151.119     0.200
    11.102   159.029     0.200
    12.336   176.721     0.200
     1.917    34.586     0.200
     2.014    36.775     0.200
     1.940    36.756     0.200
     2.059    37.404     0.200
     2.133    37.375     0.200
     2.365    40.916     0.200
     2.400    41.756     0.200
     2.401    42.465     0.200
     2.450    42.635     0.200
     2.918    47.795     0.200
     2.962    49.416     0.200
     2.996    50.295     0.200
     3.213    51.496     0.200
     3.301    53.234     0.200
     3.275    54.314     0.200
     3.580    57.064     0.200
     3.547    56.426     0.200
     3.542    58.705     0.200
     3.694    60.016     0.200
     3.806    59.965     0.200
     3.953    63.734     0.200
     4.096    65.426     0.200
     4.286    68.324     0.200
     4.301    68.145     0.200
     4.294    68.125     0.200
     4.569    71.984     0.200
     4.798    73.574     0.200
     4.875    76.496     0.200
     4.887    77.654     0.200
     5.487    86.176     0.200
     5.572    83.926     0.200
     5.592    87.516     0.200
     5.909    90.695     0.200
     6.615   100.275     0.200
     6.934   104.965     0.200
     7.236   111.246     0.200
     9.200   137.215     0.200
    15.442   219.234     0.200
    16.054   228.256     0.200
     1.824    33.184     0.200
     1.932    35.225     0.200
     1.937    34.793     0.200
     2.001    35.994     0.200
     2.114    37.504     0.200
     2.127    37.645     0.200
     2.190    38.434     0.200
     2.267    39.174     0.200
     2.368    40.584     0.200
     2.536    42.654     0.200
     2.599    44.174     0.200
     2.624    45.074     0.200
     2.820    48.234     0.200
     2.882    47.584     0.200
     2.965    49.744     0.200
     2.978    48.334     0.200
     3.124    50.943     0.200
     3.186    51.484     0.200
     3.210    53.344     0.200
     3.313    53.133     0.200
     3.503    55.443     0.200
     3.488    56.123     0.200
     3.662    59.334     0.200
     3.796    59.555     0.200
     3.847    61.264     0.200
     3.905    62.773     0.200
     3.885    61.604     0.200
     3.995    62.424     0.200
     4.158    65.934     0.200
     4.191    65.574     0.200
     4.317    67.594     0.200
     4.402    68.494     0.200
     4.512    70.533     0.200
     4.516    71.533     0.200
     4.530    70.463     0.200
     4.532    70.543     0.200
     4.618    72.293     0.200
     4.799    74.754     0.200
     4.861    75.744     0.200
     4.990    77.773     0.200
     5.742    86.273     0.200
     5.973    90.244     0.200
     6.547    96.514     0.200
     6.590    98.314     0.200
    15.237   216.873     0.200
     1.978    35.449     0.200
     2.109    35.930     0.200
     2.328    39.449     0.200
     2.365    40.459     0.200
     2.392    41.221     0.200
     2.567    45.080     0.200
     2.697    44.949     0.200
     2.884    47.170     0.200
     2.932    48.020     0.200
     2.990    49.330     0.200
     3.266    52.209     0.200
     3.195    52.900     0.200
     3.242    52.689     0.200
     3.233    51.529     0.200
     3.548    56.230     0.200
     3.603    58.160     0.200
     3.566    56.160     0.200
     3.689    58.949     0.200
     3.770    58.910     0.200
     3.949    62.641     0.200
     4.065    63.750     0.200
     4.154    65.051     0.200
     4.127    63.480     0.200
     4.257    66.561     0.200
     4.274    66.980     0.200
     4.272    66.910     0.200
     4.365    69.270     0.200
     4.541    70.539     0.200
     4.604    71.010     0.200
     4.763    72.289     0.200
     4.844    74.420     0.200
     4.812    74.391     0.200
     4.906    75.850     0.200
     5.095    77.959     0.200
     5.079    77.529     0.200
     1.881    33.859     0.200
     1.981    35.492     0.200
     2.094    36.262     0.200
     2.332    40.152     0.200
     2.363    40.891     0.200
     2.369    41.172     0.200
     2.670    45.180     0.200
     2.880    47.539     0.200
     2.923    48.512     0.200
     2.966    49.371     0.200
     3.263    52.230     0.200
     3.236    53.152     0.200
     3.218    53.332     0.200
     3.541    56.531     0.200
     3.582    58.570     0.200
     3.585    56.789     0.200
     3.664    58.609     0.200
     3.769    59.250     0.200
     3.924    62.652     0.200
     4.057    64.391     0.200
     4.147    64.980     0.200
     4.148    65.172     0.200
     4.247    66.520     0.200
     4.262    67.383     0.200
     4.256    66.930     0.200
     4.261    68.270     0.200
     4.244    66.910     0.200
     4.346    69.352     0.200
     4.529    70.449     0.200
     4.594    72.223     0.200
     4.761    72.582     0.200
     4.787    73.660     0.200
     4.836    75.461     0.200
     4.880    75.910     0.200
    15.480   220.312     0.200
     1.931    35.582     0.200
     1.985    35.621     0.200
     2.105    36.199     0.200
     2.087    37.441     0.200
     2.336    40.180     0.200
     2.370    40.770     0.200
     2.381    41.352     0.200
     2.517    43.902     0.200
     2.481    41.891     0.200
     2.560    45.691     0.200
     2.682    46.383     0.200
     2.887    47.602     0.200
     2.932    48.750     0.200
     2.978    49.602     0.200
     3.594    59.230     0.200
     3.676    59.891     0.200
     3.775    59.430     0.200
     4.364    70.770     0.200
     4.603    73.410     0.200
     4.767    73.262     0.200
     4.800    75.160     0.200
     5.097    78.492     0.200
     5.068    78.680     0.200
     5.542    83.512     0.200
     5.564    85.531     0.200
     5.606    86.902     0.200
     5.865    89.750     0.200
     1.993    35.586     0.200
     1.913    34.855     0.200
     2.095    37.887     0.200
     2.023    36.195     0.200
     2.177    38.496     0.200
     2.447    41.918     0.200
     2.409    42.766     0.200
     2.613    46.484     0.200
     2.674    45.645     0.200
     2.988    49.246     0.200
     3.021    50.215     0.200
     2.995    49.805     0.200
     3.159    53.746     0.200
     3.181    52.324     0.200
     3.183    51.117     0.200
     3.490    56.918     0.200
     3.635    59.617     0.200
     3.976    64.668     0.200
     4.389    70.266     0.200
     4.400    70.285     0.200
     4.689    74.246     0.200
     4.774    74.938     0.200
     4.938    76.668     0.200
     4.900    76.215     0.200
     5.197    79.598     0.200
     5.095    78.836     0.200
     5.156    80.977     0.200
     5.343    81.324     0.200
     5.647    84.875     0.200
     5.637    87.734     0.200
     5.608    86.266     0.200
     5.757    88.324     0.200
     5.990    91.727     0.200
     6.049    92.457     0.200
     6.063    92.348     0.200
     6.126    93.305     0.200
     6.138    93.047     0.200
     6.208    93.047     0.200
     6.323    97.105     0.200
     6.366    96.258     0.200
     6.444    96.867     0.200
     6.355    95.734     0.200
     6.488    97.277     0.200
     6.483    97.668     0.200
     6.688   102.105     0.200
     7.253   110.355     0.200
     7.481   112.137     0.200
     7.612   112.906     0.200
     7.908   117.367     0.200
     7.962   117.617     0.200
     8.180   120.895     0.200
     8.100   118.867     0.200
    15.372   219.355     0.200
    15.634   221.957     0.200
     1.880    34.227     0.200
     1.924    35.105     0.200
     1.928    35.074     0.200
     1.997    35.676     0.200
     2.119    37.676     0.200
     2.181    38.637     0.200
     2.276    39.004     0.200
     2.362    40.805     0.200
     2.527    42.965     0.200
     2.622    45.316     0.200
     2.590    44.203     0.200
     2.816    49.137     0.200
     2.837    48.555     0.200
     2.883    48.184     0.200
     2.982    49.254     0.200
     2.967    48.875     0.200
     3.117    51.035     0.200
     3.209    53.453     0.200
     3.180    52.004     0.200
     3.317    53.316     0.200
     3.495    55.285     0.200
     3.667    58.996     0.200
     3.607    57.594     0.200
     3.845    61.996     0.200
     3.905    62.516     0.200
     3.987    62.496     0.200
     3.995    64.613     0.200
     4.525    70.855     0.200
     4.855    75.934     0.200
     4.995    77.934     0.200
     5.088    78.066     0.200
     5.207    80.195     0.200
     5.454    83.516     0.200
     5.821    89.785     0.200
     6.113    93.703     0.200
     6.947   104.934     0.200
     7.254   107.387     0.200
     7.394   110.824     0.200
     8.524   126.605     0.200
     9.229   135.113     0.200
     9.343   136.414     0.200
    10.239   148.535     0.200
    10.345   152.004     0.200
    10.537   155.566     0.200
    10.453   152.254     0.200
    11.023   161.094     0.200
    11.284   163.824     0.200
    12.890   185.926     0.200
    15.530   222.695     0.200
    16.002   226.516     0.200
     1.874    33.938     0.200
     1.908    34.520     0.200
     1.912    35.117     0.200
     2.009    36.520     0.200
     2.111    36.957     0.200
     2.083    36.707     0.200
     2.360    40.906     0.200
     2.374    42.977     0.200
     2.390    41.418     0.200
     2.459    41.898     0.200
     2.560    46.328     0.200
     2.666    46.039     0.200
     2.905    48.059     0.200
     2.945    49.379     0.200
     2.968    49.750     0.200
     3.213    53.297     0.200
     3.290    53.199     0.200
     3.237    52.297     0.200
     3.261    53.770     0.200
     3.516    56.727     0.200
     3.565    57.180     0.200
     3.591    59.348     0.200
     3.572    57.418     0.200
     3.665    60.047     0.200
     3.797    60.020     0.200
     3.924    62.430     0.200
     3.946    63.867     0.200
     4.080    65.066     0.200
     4.172    65.797     0.200
     4.140    66.148     0.200
     4.269    68.137     0.200
     4.266    68.699     0.200
     4.282    67.969     0.200
     4.240    68.449     0.200
     4.358    69.988     0.200
     4.549    71.879     0.200
     4.862    76.566     0.200
     5.313    80.598     0.200
     5.448    83.738     0.200
    15.454   220.078     0.200
     1.881    33.809     0.200
     1.934    34.898     0.200
     1.881    35.547     0.200
     2.041    36.910     0.200
     2.116    37.207     0.200
     2.393    41.570     0.200
     2.415    41.668     0.200
     2.358    42.430     0.200
     2.928    49.059     0.200
     2.959    48.410     0.200
     2.948    49.047     0.200
     3.229    53.520     0.200
     3.281    53.668     0.200
     3.583    57.977     0.200
     3.901    62.957     0.200
     4.127    66.898     0.200
     4.163    65.840     0.200
     4.271    68.188     0.200
     4.559    71.418     0.200
     4.767    74.578     0.200
     1.805    33.301     0.200
     1.892    33.301     0.200
     2.032    35.422     0.200
     2.021    35.082     0.200
     2.120    36.371     0.200
     2.260    38.621     0.200
     2.468    41.102     0.200
     2.516    41.980     0.200
     2.513    42.121     0.200
     2.785    47.902     0.200
    15.947   225.363     0.200
     2.024    36.680     0.200
     2.131    37.312     0.200
     2.271    39.500     0.200
     2.328    39.832     0.200
     2.480    41.941     0.200
     2.527    42.621     0.200
     2.521    42.750     0.200
     2.718    46.422     0.200
     2.740    46.312     0.200
     2.791    47.250     0.200
    15.311   218.500     0.200
    15.539   219.891     0.200
    15.959   225.211     0.200
     2.328    40.082     0.200
     3.588    58.703     0.200
     7.217   106.953     0.200
     8.269   122.160     0.200
     8.698   128.203     0.200
    10.203   152.141     0.200
    10.199   150.852     0.200
    12.072   173.250     0.200
    12.879   184.383     0.200
    14.034   202.820     0.200
     1.893    33.469     0.200
     1.987    36.047     0.200
     2.120    37.617     0.200
     2.337    40.633     0.200
     2.375    41.398     0.200
     2.401    41.070     0.200
     2.577    44.617     0.200
     2.894    47.602     0.200
     2.998    49.883     0.200
     3.186    51.672     0.200
     3.612    58.102     0.200
     3.697    59.008     0.200
     3.957    62.367     0.200
     4.212    65.180     0.200
     4.908    75.953     0.200
     7.081   104.703     0.200
     2.476    41.766     0.200
     2.476    42.000     0.200
     3.223    51.578     0.200
     3.561    57.773     0.200
     3.561    57.969     0.200
     5.711    86.070     0.200
     6.514    98.484     0.200
     7.081   104.844     0.200
     8.279   121.195     0.200
     8.279   121.297     0.200
     8.852   130.867     0.200
     9.133   135.398     0.200
    10.348   153.023     0.200
    12.260   175.078     0.200
    12.386   178.398     0.200
    12.735   184.398     0.200
    12.963   185.562     0.200
    15.768   224.039     0.200
    16.157   228.922     0.200
     1.869    33.648     0.200
     1.960    35.156     0.200
     1.967    36.773     0.200
     2.109    36.648     0.200
     2.404    41.656     0.200
     4.371    69.320     0.200
     4.750    72.133     0.200
     4.931    77.406     0.200
     5.084    77.141     0.200
     5.091    79.039     0.200
     5.115    79.398     0.200
     5.319    82.602     0.200
     5.346    82.312     0.200
     5.523    82.812     0.200
     5.520    84.398     0.200
     5.566    86.398     0.200
     5.636    86.406     0.200
     7.052   104.312     0.200
    10.241   148.547     0.200
    11.077   160.148     0.200
    12.679   182.406     0.200
    14.561   208.031     0.200
    15.371   216.812     0.200
    15.790   222.227     0.200
    15.999   226.641     0.200
    16.936   238.602     0.200
     1.840    33.210     0.200
     1.882    34.030     0.200
     1.973    34.550     0.200
     2.066    35.860     0.200
     2.093    36.830     0.200
     2.137    36.760     0.200
     2.337    39.710     0.200
     2.320    40.390     0.200
     2.483    41.330     0.200
     2.550    42.690     0.200
     2.614    44.070     0.200
     2.798    46.980     0.200
     2.889    48.210     0.200
     2.973    47.330     0.200
     3.003    48.150     0.200
     3.078    50.150     0.200
     3.146    50.920     0.200
     3.205    52.320     0.200
     3.336    52.220     0.200
     3.455    54.620     0.200
     3.444    55.530     0.200
     3.562    56.280     0.200
     3.753    59.010     0.200
     3.689    58.260     0.200
     3.831    60.410     0.200
     3.945    61.380     0.200
     3.902    61.740     0.200
     4.185    66.000     0.200
     4.275    66.330     0.200
     4.358    67.480     0.200
     4.473    69.270     0.200
     4.497    69.720     0.200
     4.502    69.620     0.200
     4.506    70.670     0.200
     4.596    71.170     0.200
     4.762    73.660     0.200
     4.823    74.390     0.200
     4.947    74.470     0.200
     5.021    77.300     0.200
     3.003    47.440     0.200
     3.689    58.670     0.200
     3.689    58.440     0.200
     4.001    62.340     0.200
     4.823    75.340     0.200
     5.290    80.340     0.200
     5.552    84.540     0.200
     5.543    85.540     0.200
     5.715    85.240     0.200
     6.002    89.434     0.200
     6.527    99.040     0.200
     6.699   101.340     0.200
     6.699   100.354     0.200
     6.935   103.940     0.200
     6.932   104.340     0.200
     7.209   107.240     0.200
     7.209   106.417     0.200
     7.209   106.940     0.200
     7.209   107.050     0.200
     7.880   116.140     0.200
     8.204   121.240     0.200
     8.361   120.931     0.200
     8.361   121.750     0.200
     8.670   127.640     0.200
     8.670   127.090     0.200
     9.326   137.143     0.200
    10.131   149.390     0.200
    12.144   172.435     0.200
    12.605   180.698     0.200
    12.931   186.270     0.200
    12.936   183.650     0.200
    13.956   201.200     0.200
    15.878   225.497     0.200
    15.985   226.940     0.200
    15.954   225.480     0.200
    16.096   227.845     0.200
    16.157   228.382     0.200
     1.980    35.166     0.200
     2.107    39.065     0.200
     2.167    38.355     0.200
     2.289    39.476     0.200
     2.346    40.736     0.200
     2.514    42.716     0.200
     2.576    43.936     0.200
     2.607    44.496     0.200
     2.800    47.806     0.200
     2.871    48.295     0.200
     2.981    49.196     0.200
     2.998    48.835     0.200
     3.101    49.996     0.200
     3.164    51.625     0.200
     3.195    52.426     0.200
     3.333    53.256     0.200
     3.480    55.186     0.200
     3.465    55.526     0.200
     3.594    56.996     0.200
     3.660    59.166     0.200
     3.773    59.646     0.200
     3.829    61.416     0.200
     3.903    61.236     0.200
     3.891    62.406     0.200
     4.294    67.236     0.200
     4.379    68.026     0.200
     4.490    70.216     0.200
     4.510    70.506     0.200
     4.509    70.596     0.200
     4.500    71.625     0.200
     4.598    72.506     0.200
     4.776    73.806     0.200
     4.838    75.006     0.200
     4.973    75.206     0.200
     4.989    78.366     0.200
     5.543    83.916     0.200
     6.140    93.516     0.200
     6.661   100.386     0.200
     6.681   101.045     0.200
     7.383   110.496     0.200
     7.679   113.946     0.200
     9.213   134.656     0.200
    10.524   155.105     0.200
     2.081    36.059     0.200
     2.111    36.648     0.200
     2.321    39.258     0.200
     2.351    40.098     0.200
     2.357    40.629     0.200
     2.535    44.090     0.200
     2.498    42.008     0.200
     2.664    46.879     0.200
     2.867    47.398     0.200
     2.910    47.770     0.200
     2.954    48.941     0.200
     3.264    51.461     0.200
     3.527    56.949     0.200
     3.598    56.539     0.200
     3.653    58.789     0.200
     3.758    58.750     0.200
     4.161    63.250     0.200
     4.249    66.539     0.200
     4.876    74.699     0.200
    15.801   223.441     0.200
    16.010   226.879     0.200
    17.453   242.539     0.200
     2.028    35.562     0.200
     2.064    36.406     0.200
     2.131    36.773     0.200
     2.379    40.461     0.200
     2.410    41.336     0.200
     2.388    41.672     0.200
     2.439    41.422     0.200
     2.578    44.172     0.200
     2.926    48.164     0.200
     2.965    48.336     0.200
     2.981    49.633     0.200
     3.199    51.531     0.200
     3.220    51.586     0.200
     3.310    52.797     0.200
     3.281    53.586     0.200
     3.471    54.656     0.200
     3.555    57.133     0.200
     3.517    57.172     0.200
     3.585    57.297     0.200
     3.607    59.000     0.200
     3.678    59.484     0.200
     3.817    59.891     0.200
     3.847    62.016     0.200
     3.936    62.453     0.200
     3.960    63.461     0.200
     4.125    64.453     0.200
     4.100    64.625     0.200
     4.226    66.086     0.200
     4.192    65.500     0.200
     4.289    67.164     0.200
     4.301    67.516     0.200
     4.281    67.742     0.200
     4.375    69.195     0.200
     4.370    70.133     0.200
     4.382    70.031     0.200
     4.569    71.211     0.200
     4.635    72.305     0.200
     4.808    73.156     0.200
     4.800    74.914     0.200
     4.880    75.422     0.200
     4.862    75.555     0.200
     4.994    76.781     0.200
     2.059    36.722     0.200
     2.064    36.602     0.200
     2.070    37.602     0.200
     2.140    37.982     0.200
     2.304    40.362     0.200
     2.317    40.652     0.200
     2.487    42.042     0.200
     2.543    42.822     0.200
     2.565    44.932     0.200
     2.716    46.822     0.200
     2.757    47.832     0.200
     2.837    48.822     0.200
     2.915    49.472     0.200
     3.023    50.712     0.200
     3.067    50.172     0.200
     3.041    50.562     0.200
     3.125    51.632     0.200
     3.153    52.112     0.200
     3.276    54.272     0.200
     3.294    55.712     0.200
     3.404    55.412     0.200
     3.376    55.212     0.200
     3.447    54.652     0.200
     3.430    55.972     0.200
     3.570    57.062     0.200
     3.631    58.282     0.200
     3.737    59.742     0.200
     3.786    60.892     0.200
     3.849    61.462     0.200
     3.942    62.222     0.200
     3.946    62.852     0.200
     4.017    63.882     0.200
     4.052    66.092     0.200
     4.104    65.052     0.200
     4.134    66.272     0.200
     4.257    66.872     0.200
     4.343    68.162     0.200
     4.451    69.792     0.200
     4.470    69.942     0.200
     4.466    70.242     0.200
     4.457    71.012     0.200
     4.555    71.822     0.200
     4.736    73.402     0.200
     4.799    73.802     0.200
     4.941    75.322     0.200
     4.970    77.102     0.200
     4.964    77.402     0.200
     5.035    78.232     0.200
     5.146    80.802     0.200
     5.251    80.952     0.200
     5.279    80.472     0.200
     5.259    81.452     0.200
     5.300    82.222     0.200
     2.045    36.387     0.200
     2.155    38.045     0.200
     2.145    38.557     0.200
     2.228    38.986     0.200
     2.230    39.166     0.200
     2.411    41.336     0.200
     2.640    44.406     0.200
     2.662    45.646     0.200
     2.913    48.875     0.200
     2.929    49.467     0.200
     2.936    48.436     0.200
     3.166    51.406     0.200
     3.678    60.016     0.200
     3.839    60.105     0.200
     3.846    60.906     0.200
     3.888    61.906     0.200
     3.940    63.416     0.200
     3.958    63.775     0.200
     4.192    66.945     0.200
     4.228    67.816     0.200
     4.556    71.375     0.200
     4.572    71.195     0.200
     4.659    73.566     0.200
     5.595    87.307     0.200
     5.751    88.756     0.200
     5.805    86.945     0.200
     5.852    90.016     0.200
     5.870    90.445     0.200
     6.154    94.016     0.200
     6.572   101.186     0.200
    10.289   149.477     0.200
    10.566   156.096     0.200
    11.329   163.416     0.200
    12.677   181.887     0.200
    12.866   184.436     0.200
     2.077    36.391     0.200
     2.122    36.883     0.200
     2.366    40.730     0.200
     2.383    41.223     0.200
     2.321    40.363     0.200
     2.465    41.883     0.200
     2.922    48.430     0.200
     3.266    53.781     0.200
     3.281    52.391     0.200
     3.281    52.191     0.200
     3.457    56.613     0.200
     3.542    57.551     0.200
     3.609    58.680     0.200
     4.190    67.090     0.200
     4.589    72.480     0.200
     4.732    73.312     0.200
     4.805    75.820     0.200
     5.477    83.273     0.200
     6.267    95.430     0.200
     7.115   105.301     0.200
     8.179   120.820     0.200
     8.856   130.781     0.200
    10.258   152.773     0.200
    10.811   156.730     0.200
    11.962   171.750     0.200
     3.457    56.422     0.200
     7.115   104.953     0.200
     7.115   105.582     0.200
     8.179   120.992     0.200
     8.856   130.141     0.200
    10.388   155.312     0.200
    10.396   154.312     0.200
    12.165   173.953     0.200
    12.888   184.621     0.200
    16.182   229.633     0.200
     2.083    36.555     0.200
     2.116    37.715     0.200
     2.326    40.438     0.200
     2.371    40.457     0.200
     2.389    41.027     0.200
     2.459    41.477     0.200
     2.613    44.324     0.200
     2.900    48.117     0.200
     2.928    49.016     0.200
     3.287    53.234     0.200
     3.252    53.574     0.200
     3.261    53.695     0.200
     3.275    52.727     0.200
     3.458    56.977     0.200
     3.553    56.348     0.200
     3.547    58.555     0.200
     3.614    58.977     0.200
     3.611    57.047     0.200
     3.799    59.977     0.200
     3.802    61.406     0.200
     3.871    61.566     0.200
     4.065    64.547     0.200
     4.161    65.707     0.200
     4.250    67.477     0.200
     4.258    67.047     0.200
     4.185    64.938     0.200
     4.319    69.516     0.200
     4.527    71.465     0.200
     4.595    71.906     0.200
     4.736    73.598     0.200
     4.786    73.047     0.200
     4.846    74.785     0.200
     5.013    77.145     0.200
     5.065    79.227     0.200
     5.108    78.137     0.200
     5.413    83.074     0.200
     5.545    85.336     0.200
     5.543    85.984     0.200
     5.563    84.266     0.200
     5.471    83.105     0.200
     5.815    88.348     0.200
     5.774    87.117     0.200
     5.874    89.617     0.200
     6.272    94.938     0.200
     6.390    95.777     0.200
     7.121   105.375     0.200
     7.158   107.234     0.200
     7.166   107.266     0.200
     7.357   109.785     0.200
     7.397   110.645     0.200
     7.519   111.555     0.200
     7.672   113.727     0.200
     7.871   117.055     0.200
     8.068   118.457     0.200
     8.244   120.715     0.200
     8.178   120.555     0.200
     8.967   131.395     0.200
    10.122   147.598     0.200
    10.484   152.605     0.200
    11.141   160.465     0.200
    12.344   178.055     0.200
    12.885   184.727     0.200
     2.097    36.652     0.200
     2.373    40.113     0.200
     2.350    40.023     0.200
     2.396    40.703     0.200
     2.452    41.484     0.200
     2.909    47.223     0.200
     2.941    48.145     0.200
     3.294    52.113     0.200
     3.237    52.414     0.200
     3.262    53.152     0.200
     3.254    52.473     0.200
     3.466    55.375     0.200
     3.482    56.383     0.200
     3.565    56.152     0.200
     3.570    57.453     0.200
     3.590    57.715     0.200
     3.638    57.984     0.200
     3.805    59.762     0.200
     3.818    60.543     0.200
     3.896    61.832     0.200
     3.920    62.652     0.200
     4.077    64.473     0.200
     4.172    64.941     0.200
     4.162    66.062     0.200
     4.264    66.602     0.200
     4.257    67.242     0.200
     4.274    66.984     0.200
     4.542    71.172     0.200
     4.793    73.184     0.200
     4.761    73.281     0.200
     4.858    74.715     0.200
     5.037    78.004     0.200
     5.086    78.473     0.200
     5.117    77.941     0.200
     5.287    81.574     0.200
     5.437    83.242     0.200
     5.467    84.215     0.200
     5.455    82.633     0.200
     5.555    85.492     0.200
     5.569    83.594     0.200
     5.563    85.305     0.200
     5.728    86.281     0.200
     5.751    86.984     0.200
     5.838    89.555     0.200
     5.887    89.254     0.200
     6.253    95.113     0.200
     6.383    95.125     0.200
     6.409    96.875     0.200
     7.188   108.133     0.200
     7.372   110.492     0.200
     7.681   112.492     0.200
     7.882   115.602     0.200
     7.939   117.594     0.200
     8.049   119.582     0.200
     8.087   118.793     0.200
     8.248   120.625     0.200
     8.199   119.582     0.200
     8.506   122.875     0.200
    14.624   207.164     0.200
    15.225   216.203     0.200
    15.433   218.465     0.200
    15.452   218.863     0.200
    15.853   223.684     0.200
    16.161   228.762     0.200
    16.512   232.062     0.200
    16.824   236.852     0.200
     3.482    56.902     0.200
     5.751    86.781     0.200
     7.121   104.902     0.200
     8.199   120.594     0.200
     8.840   130.344     0.200
    10.371   152.254     0.200
    12.895   184.055     0.200
    14.209   206.242     0.200
    15.746   224.305     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.997    72.066     0.200
     3.908    74.527     0.200
     8.550   160.496     0.200
     5.303    96.539     0.200
     5.287    95.449     0.200
     3.941    73.219     0.200
     8.582   160.922     0.200
     8.423   155.352     0.200
     8.601   159.023     0.200
     8.590   162.562     0.200
     5.106    91.375     0.200
     5.087    91.117     0.200
     5.700   108.203     0.200
     2.762    50.422     0.200
     2.697    50.809     0.200
     2.948    53.301     0.200
     3.304    60.520     0.200
     2.501    46.563     0.200
     2.627    49.413     0.200
     2.834    51.684     0.200
     2.939    54.943     0.200
     3.183    58.354     0.200
     3.001    53.668     0.200
     3.105    55.957     0.200
     2.686    49.828     0.200
     3.014    54.617     0.200
     4.433    80.268     0.200
     2.921    53.489     0.200
     3.295    60.769     0.200
     3.295    60.146     0.200
     2.974    52.820     0.200
     2.788    51.945     0.200
     2.942    54.129     0.200
     3.077    57.195     0.200
     3.174    57.418     0.200
     3.592    63.941     0.200
     3.341    60.480     0.200
     2.524    47.883     0.200
     2.573    47.797     0.200
     2.916    54.195     0.200
     2.681    50.875     0.200
     4.562    86.930     0.200
     2.658    49.551     0.200
     2.904    54.141     0.200
     3.172    59.020     0.200
     2.513    47.751     0.200
     2.550    46.829     0.200
     2.884    51.850     0.200
     3.307    59.762     0.200
     2.705    50.994     0.200
     2.787    52.264     0.200
     2.943    52.955     0.200
     3.075    57.684     0.200
     2.520    46.777     0.200
     2.999    54.344     0.200
     3.424    61.984     0.200
     2.838    52.048     0.200
     3.178    58.388     0.200
     3.637    65.308     0.200
     3.952    72.147     0.200
     4.169    74.897     0.200
     4.794    87.058     0.200
     2.555    48.281     0.200
     2.602    49.461     0.200
     2.802    52.867     0.200
     2.802    53.000     0.200
     3.045    55.578     0.200
     3.586    68.266     0.200
     4.450    84.750     0.200
     2.546    47.695     0.200
     2.791    50.844     0.200
     2.819    52.773     0.200
     3.102    56.375     0.200
     3.676    66.125     0.200
     4.204    75.773     0.200
     4.323    80.535     0.200
     3.015    54.133     0.200
     3.115    56.539     0.200
     3.188    57.172     0.200
     4.176    74.539     0.200
     2.624    46.934     0.200
     3.293    60.469     0.200
     4.241    77.117     0.200
     4.798    89.133     0.200
     4.242    77.039     0.200
     4.797    88.484     0.200
     2.580    47.250     0.200
     2.702    49.391     0.200
     5.430    98.680     0.200
     5.430    98.883     0.200
     5.266    95.883     0.200
     5.287    96.750     0.200
     2.523    46.326     0.200
     3.703    68.000     0.200
     4.209    78.539     0.200
     2.546    46.406     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.559    11.768     0.200
     1.235    22.869     0.200
     0.315     6.988     0.200
     2.332    39.488     0.200
     6.107    97.688     0.200
     0.463     8.764     0.200
     0.597    12.604     0.200
     0.738    13.885     0.200
     1.172    21.865     0.200
     2.239    38.615     0.200
     2.514    41.984     0.200
     0.462     8.922     0.200
     0.592    12.434     0.200
     0.740    13.754     0.200
     1.163    21.691     0.200
     1.196    22.504     0.200
     2.249    38.504     0.200
     2.507    41.941     0.200
     0.286     5.562     0.200
     0.647    13.312     0.200
     1.087    20.648     0.200
     0.549    11.566     0.200
     1.198    20.867     0.200
     1.645    28.266     0.200
     1.773    29.746     0.200
     2.227    37.266     0.200
     7.022   127.668     0.200
     0.569    11.879     0.200
     1.191    20.879     0.200
     1.665    28.879     0.200
     1.756    29.957     0.200
     2.230    37.801     0.200
     0.425     8.594     0.200
     0.439     8.633     0.200
     0.709    13.234     0.200
     1.188    21.625     0.200
     1.194    22.250     0.200
     1.284    22.594     0.200
     1.672    29.320     0.200
     1.724    29.719     0.200
     1.750    30.711     0.200
     1.818    31.852     0.200
     0.289     5.808     0.200
     0.335     7.118     0.200
     0.589    11.018     0.200
     0.754    15.388     0.200
     1.213    23.418     0.200
     1.548    26.978     0.200
     1.592    28.998     0.200
     1.836    32.618     0.200
     0.239     5.582     0.200
     0.270     5.883     0.200
     0.459     9.984     0.200
     1.234    22.652     0.200
     1.367    24.781     0.200
     1.446    25.582     0.200
     1.506    26.184     0.200
     0.216     4.660     0.200
     0.509     9.758     0.200
     0.620    12.859     0.200
     1.095    20.859     0.200
     1.177    21.059     0.200
     1.223    22.801     0.200
     1.454    27.160     0.200
     1.617    28.160     0.200
     1.626    29.559     0.200
     1.651    29.961     0.200
     1.713    30.258     0.200
     1.776    32.059     0.200
     0.293     5.992     0.200
     0.547    11.289     0.200
     0.615    12.094     0.200
     1.039    20.289     0.200
     1.399    26.094     0.200
     1.500    26.891     0.200
     1.942    32.789     0.200
     0.312     5.969     0.200
     1.192    23.148     0.200
     1.219    23.148     0.200
     1.408    26.766     0.200
     1.573    29.375     0.200
     1.582    29.531     0.200
     0.291     6.197     0.200
     0.360     7.637     0.200
     0.585    11.156     0.200
     0.695    14.146     0.200
     1.121    20.947     0.200
     1.189    22.277     0.200
     1.569    26.996     0.200
     1.630    29.287     0.200
     1.679    29.377     0.200
     0.284     6.180     0.200
     0.361     7.660     0.200
     0.577    11.078     0.200
     0.688    14.039     0.200
     1.129    20.648     0.200
     1.190    21.910     0.200
     1.577    27.867     0.200
     1.636    29.320     0.200
     0.253     5.137     0.200
     0.650    13.236     0.200
     1.226    22.736     0.200
     1.149    22.186     0.200
     1.535    28.436     0.200
     1.676    29.836     0.200
     1.706    31.037     0.200
     1.726    31.836     0.200
     1.782    31.836     0.200
     2.304    39.537     0.200
     2.493    42.537     0.200
     3.459    57.137     0.200
     0.209     4.352     0.200
     0.421     8.551     0.200
     0.601    12.551     0.200
     0.854    16.852     0.200
     1.263    22.254     0.200
     1.537    28.051     0.200
     1.706    29.652     0.200
     1.711    30.453     0.200
     1.804    31.551     0.200
     5.106    91.176     0.200
     0.175     3.650     0.200
     0.330     5.922     0.200
     0.493    10.400     0.200
     1.220    22.752     0.200
     1.375    25.502     0.200
     1.785    31.662     0.200
     2.296    40.301     0.200
     0.258     5.285     0.200
     0.505     9.527     0.200
     0.647    13.176     0.200
     1.131    21.246     0.200
     1.343    25.227     0.200
     1.564    28.695     0.200
     1.707    30.574     0.200
     1.736    31.617     0.200
     1.814    32.438     0.200
     2.278    39.797     0.200
     2.524    42.445     0.200
     3.126    52.004     0.200
     0.174     3.891     0.200
     0.544    11.414     0.200
     1.373    25.398     0.200
     1.144    21.320     0.200
     1.323    24.797     0.200
     1.501    27.398     0.200
     1.557    27.258     0.200
     2.371    39.844     0.200
     0.635    12.891     0.200
     1.235    21.684     0.200
     2.405    39.812     0.200
     0.291     5.949     0.200
     0.281     5.641     0.200
     0.587    11.070     0.200
     0.677    13.840     0.200
     1.080    19.000     0.200
     1.257    23.469     0.200
     1.519    26.488     0.200
     1.619    28.289     0.200
     1.765    30.418     0.200
     2.336    39.660     0.200
     0.472     9.203     0.200
     0.647    12.898     0.200
     0.879    17.359     0.200
     1.206    22.523     0.200
     1.276    22.625     0.200
     1.339    24.844     0.200
     2.540    42.195     0.200
     2.952    50.070     0.200
     0.435     8.836     0.200
     0.456     8.984     0.200
     0.629    12.875     0.200
     0.867    17.227     0.200
     1.199    22.234     0.200
     1.170    21.273     0.200
     1.279    22.055     0.200
     1.327    24.617     0.200
     1.551    27.969     0.200
     1.722    29.148     0.200
     2.540    42.125     0.200
     0.466     9.016     0.200
     0.639    13.141     0.200
     0.870    17.422     0.200
     1.162    21.508     0.200
     1.199    22.641     0.200
     1.274    22.211     0.200
     1.553    28.172     0.200
     1.719    29.367     0.200
     1.818    31.547     0.200
     0.487     9.262     0.200
     0.661    13.352     0.200
     0.878    17.602     0.200
     1.145    21.645     0.200
     1.201    22.375     0.200
     1.265    22.352     0.200
     1.560    28.574     0.200
     1.713    29.492     0.200
     2.286    39.203     0.200
     2.530    42.703     0.200
     0.503     9.594     0.200
     1.144    22.219     0.200
     1.187    23.438     0.200
     1.245    23.195     0.200
     1.549    28.914     0.200
     1.694    30.375     0.200
     1.800    32.688     0.200
     2.293    40.039     0.200
     2.511    43.227     0.200
     0.673    12.729     0.200
     0.655    13.039     0.200
     1.214    23.449     0.200
     1.470    26.809     0.200
     1.589    29.270     0.200
     0.643    13.031     0.200
     0.875    17.289     0.200
     1.203    21.820     0.200
     1.276    22.578     0.200
     1.722    29.453     0.200
     2.155    36.938     0.200
     2.292    39.031     0.200
     2.292    38.883     0.200
     3.497    57.547     0.200
     0.388     7.906     0.200
     0.470     9.266     0.200
     0.648    13.195     0.200
     0.820    16.258     0.200
     0.880    16.344     0.200
     0.943    18.023     0.200
     1.021    18.297     0.200
     1.231    22.586     0.200
     1.235    22.367     0.200
     1.232    23.039     0.200
     1.344    24.492     0.200
     1.418    25.617     0.200
     1.493    27.734     0.200
     1.719    30.539     0.200
     1.522    27.836     0.200
     1.626    28.758     0.200
     1.620    28.922     0.200
     1.676    29.516     0.200
     0.216     5.008     0.200
     0.447     8.848     0.200
     0.481    10.301     0.200
     0.644    13.340     0.200
     0.758    14.199     0.200
     0.795    15.168     0.200
     0.968    17.918     0.200
     1.066    20.199     0.200
     1.149    21.180     0.200
     1.176    21.250     0.200
     1.176    21.078     0.200
     1.206    21.520     0.200
     1.271    22.438     0.200
     1.352    23.938     0.200
     1.362    23.500     0.200
     1.371    24.918     0.200
     1.389    25.211     0.200
     1.521    28.070     0.200
     1.453    26.891     0.200
     1.458    26.141     0.200
     1.523    26.000     0.200
     1.584    26.961     0.200
     1.645    28.328     0.200
     1.724    29.559     0.200
     1.730    30.859     0.200
     1.752    31.328     0.200
     1.747    30.590     0.200
     1.757    30.711     0.200
     1.785    30.438     0.200
     1.805    32.230     0.200
     0.374     7.382     0.200
     0.543    10.122     0.200
     0.770    15.132     0.200
     0.942    18.652     0.200
     1.185    22.542     0.200
     1.245    24.103     0.200
     1.614    28.393     0.200
     1.638    30.702     0.200
     1.709    31.682     0.200
     1.771    31.782     0.200
     2.307    42.132     0.200
     0.312     6.664     0.200
     0.312     6.443     0.200
     0.534    10.153     0.200
     0.564    11.863     0.200
     0.674    13.454     0.200
     0.740    14.924     0.200
     0.831    15.384     0.200
     0.850    16.434     0.200
     0.995    18.584     0.200
     1.144    21.084     0.200
     1.245    22.504     0.200
     1.320    23.584     0.200
     1.299    24.034     0.200
     1.321    24.004     0.200
     1.428    26.084     0.200
     1.530    27.304     0.200
     1.526    26.363     0.200
     1.577    27.254     0.200
     1.612    28.714     0.200
     1.644    29.594     0.200
     1.709    30.943     0.200
     1.817    32.324     0.200
     1.817    31.794     0.200
     1.806    31.584     0.200
     2.312    40.813     0.200
     0.250     5.203     0.200
     0.356     7.062     0.200
     0.356     7.164     0.200
     0.541    10.223     0.200
     0.606    12.312     0.200
     0.692    13.684     0.200
     0.787    15.324     0.200
     0.888    17.053     0.200
     0.957    18.664     0.200
     1.185    22.594     0.200
     1.202    22.414     0.200
     1.202    22.633     0.200
     1.338    25.613     0.200
     1.260    24.273     0.200
     1.570    28.293     0.200
     1.638    29.754     0.200
     1.638    30.123     0.200
     1.707    31.203     0.200
     1.785    31.533     0.200
     2.306    41.514     0.200
     5.201    86.438     0.200
     0.567    10.652     0.200
     0.549    10.742     0.200
     0.605    12.242     0.200
     0.754    15.143     0.200
     0.829    16.732     0.200
     0.978    19.523     0.200
     0.996    17.752     0.200
     1.029    19.594     0.200
     1.078    21.113     0.200
     1.078    20.844     0.200
     1.081    19.482     0.200
     1.122    22.002     0.200
     1.256    24.514     0.200
     1.281    24.572     0.200
     1.294    23.703     0.200
     1.379    26.213     0.200
     1.467    27.123     0.200
     1.479    26.643     0.200
     1.609    28.482     0.200
     1.620    29.633     0.200
     1.654    30.672     0.200
     1.676    31.354     0.200
     1.676    31.152     0.200
     1.716    30.662     0.200
     1.763    32.094     0.200
     1.757    31.373     0.200
     1.764    33.143     0.200
     1.764    32.973     0.200
     1.823    33.053     0.200
     1.880    33.492     0.200
     1.879    33.502     0.200
     0.291     5.518     0.200
     0.351     7.336     0.200
     0.587    11.217     0.200
     0.771    15.586     0.200
     0.789    15.256     0.200
     0.863    16.967     0.200
     0.899    16.848     0.200
     0.937    19.217     0.200
     1.066    21.637     0.200
     1.114    20.586     0.200
     1.114    21.777     0.200
     1.165    22.848     0.200
     1.165    22.996     0.200
     1.165    21.307     0.200
     1.198    23.486     0.200
     1.198    23.676     0.200
     1.243    25.107     0.200
     1.243    24.496     0.200
     1.297    23.797     0.200
     1.397    26.586     0.200
     1.438    27.396     0.200
     1.515    27.076     0.200
     1.515    27.377     0.200
     1.547    28.768     0.200
     1.562    27.777     0.200
     1.609    29.857     0.200
     1.621    30.377     0.200
     1.592    30.787     0.200
     1.670    30.416     0.200
     1.690    30.537     0.200
     1.690    30.416     0.200
     1.816    33.377     0.200
     1.845    33.566     0.200
     1.822    32.977     0.200
     1.822    33.887     0.200
     2.260    42.727     0.200
     0.431     8.086     0.200
     0.418     8.273     0.200
     0.681    13.926     0.200
     0.772    15.535     0.200
     0.982    18.656     0.200
     0.997    19.945     0.200
     1.070    19.496     0.200
     1.198    23.023     0.200
     1.267    23.637     0.200
     1.284    23.184     0.200
     1.292    25.184     0.200
     1.320    23.605     0.200
     1.408    27.453     0.200
     1.675    30.195     0.200
     1.672    29.996     0.200
     1.723    30.504     0.200
     1.758    32.266     0.200
     1.831    33.324     0.200
     1.855    33.016     0.200
     0.237     5.047     0.200
     0.325     6.688     0.200
     0.325     6.875     0.200
     0.576    11.898     0.200
     0.576    12.117     0.200
     0.537    10.266     0.200
     0.680    12.758     0.200
     0.752    15.156     0.200
     0.791    14.438     0.200
     0.791    14.617     0.200
     0.818    15.672     0.200
     0.860    16.703     0.200
     0.983    18.844     0.200
     1.065    20.352     0.200
     1.156    21.625     0.200
     1.182    20.828     0.200
     1.232    22.781     0.200
     1.232    22.602     0.200
     1.359    25.719     0.200
     1.288    24.578     0.200
     1.326    23.922     0.200
     1.405    24.938     0.200
     1.534    26.766     0.200
     1.534    27.117     0.200
     1.541    27.773     0.200
     1.583    27.445     0.200
     1.641    29.914     0.200
     1.641    30.031     0.200
     1.622    28.906     0.200
     1.707    30.984     0.200
     1.681    29.625     0.200
     1.714    30.195     0.200
     1.816    31.938     0.200
     1.840    32.133     0.200
     0.195     3.904     0.200
     0.412     8.342     0.200
     0.412     8.295     0.200
     0.454     8.504     0.200
     0.622    12.555     0.200
     0.673    13.834     0.200
     0.765    15.115     0.200
     0.844    16.865     0.200
     0.909    16.734     0.200
     0.970    18.854     0.200
     0.982    19.375     0.200
     1.049    18.914     0.200
     1.177    22.484     0.200
     1.190    22.504     0.200
     1.258    23.693     0.200
     1.264    22.615     0.200
     1.266    22.584     0.200
     1.278    24.984     0.200
     1.389    26.854     0.200
     1.389    26.629     0.200
     1.303    23.164     0.200
     1.372    24.904     0.200
     1.447    26.205     0.200
     1.522    27.805     0.200
     1.549    28.424     0.200
     1.646    29.684     0.200
     1.655    29.193     0.200
     1.702    30.785     0.200
     1.705    29.834     0.200
     1.733    31.164     0.200
     1.734    32.094     0.200
     1.799    31.744     0.200
     1.808    33.285     0.200
     1.836    32.594     0.200
     1.920    33.605     0.200
     1.927    33.943     0.200
     1.944    33.805     0.200
     1.946    34.104     0.200
     2.108    38.805     0.200
     0.379     6.963     0.200
     0.394     7.832     0.200
     0.659    13.412     0.200
     0.826    16.152     0.200
     0.921    17.822     0.200
     0.968    18.973     0.200
     1.058    20.742     0.200
     1.089    20.621     0.200
     1.245    23.562     0.200
     1.254    24.441     0.200
     1.253    24.271     0.200
     1.303    24.701     0.200
     1.324    24.223     0.200
     1.352    26.592     0.200
     1.469    28.402     0.200
     1.677    30.102     0.200
     1.732    30.902     0.200
     1.803    33.553     0.200
     1.867    33.982     0.200
     1.872    34.922     0.200
     2.177    41.482     0.200
     0.432     7.922     0.200
     0.434     8.553     0.200
     0.697    14.182     0.200
     0.759    15.283     0.200
     0.938    17.793     0.200
     0.997    19.123     0.200
     0.988    19.752     0.200
     1.081    20.023     0.200
     1.185    22.953     0.200
     1.204    23.092     0.200
     1.282    24.273     0.200
     1.295    23.713     0.200
     1.282    25.203     0.200
     1.403    27.412     0.200
     1.685    30.383     0.200
     1.735    31.172     0.200
     1.761    33.172     0.200
     1.836    34.242     0.200
     1.867    34.332     0.200
     0.161     3.188     0.200
     0.405     7.898     0.200
     0.421     8.250     0.200
     0.421     8.309     0.200
     0.576    10.607     0.200
     0.685    14.158     0.200
     0.786    15.197     0.200
     0.935    17.018     0.200
     0.935    17.338     0.200
     1.018    19.639     0.200
     1.197    22.658     0.200
     1.213    22.447     0.200
     1.213    23.049     0.200
     1.228    22.719     0.200
     1.271    23.918     0.200
     1.312    24.969     0.200
     1.433    27.238     0.200
     1.395    26.129     0.200
     1.486    26.598     0.200
     1.547    27.928     0.200
     1.687    29.908     0.200
     1.687    30.107     0.200
     1.739    30.738     0.200
     1.739    30.498     0.200
     1.753    31.629     0.200
     1.783    32.408     0.200
     1.856    33.588     0.200
     1.856    33.738     0.200
     1.945    34.318     0.200
     0.425     8.551     0.200
     0.540    10.238     0.200
     0.677    13.629     0.200
     0.721    14.758     0.200
     0.881    16.301     0.200
     0.910    18.461     0.200
     0.993    18.199     0.200
     1.139    22.168     0.200
     1.207    22.719     0.200
     1.256    23.770     0.200
     1.241    23.250     0.200
     1.210    23.980     0.200
     1.307    25.660     0.200
     1.264    23.520     0.200
     1.613    29.211     0.200
     1.658    29.871     0.200
     1.652    30.621     0.200
     1.724    30.859     0.200
     1.704    32.520     0.200
     1.728    32.121     0.200
     1.786    32.391     0.200
     2.320    42.918     0.200
     0.218     4.699     0.200
     0.372     7.812     0.200
     0.372     7.668     0.200
     0.372     7.801     0.200
     0.494     9.508     0.200
     0.494     9.613     0.200
     0.501     9.668     0.200
     0.629    13.020     0.200
     0.658    13.238     0.200
     0.693    12.930     0.200
     0.804    16.117     0.200
     0.781    15.109     0.200
     0.852    15.449     0.200
     0.987    17.598     0.200
     0.970    18.820     0.200
     1.048    18.648     0.200
     1.048    18.840     0.200
     1.124    21.379     0.200
     1.201    21.000     0.200
     1.201    21.258     0.200
     1.204    21.219     0.200
     1.211    22.840     0.200
     1.200    22.391     0.200
     1.200    22.520     0.200
     1.243    21.859     0.200
     1.363    26.098     0.200
     1.363    25.977     0.200
     1.271    24.289     0.200
     1.317    23.777     0.200
     1.284    23.660     0.200
     1.384    24.789     0.200
     1.465    25.750     0.200
     1.484    27.277     0.200
     1.497    27.398     0.200
     1.594    28.277     0.200
     1.643    28.828     0.200
     1.656    29.520     0.200
     1.681    30.027     0.200
     1.680    30.660     0.200
     1.680    30.828     0.200
     1.742    30.500     0.200
     1.751    32.039     0.200
     1.774    31.180     0.200
     1.748    30.809     0.200
     1.765    31.918     0.200
     1.765    31.449     0.200
     1.807    31.988     0.200
     1.807    31.879     0.200
     1.864    32.617     0.200
     1.875    33.078     0.200
     1.880    33.430     0.200
     1.880    33.293     0.200
     1.887    32.551     0.200
     1.897    33.301     0.200
     0.319     6.653     0.200
     0.546    10.585     0.200
     0.546    10.623     0.200
     0.568    10.673     0.200
     0.607    12.213     0.200
     0.737    13.923     0.200
     0.737    13.809     0.200
     0.798    16.303     0.200
     0.830    16.533     0.200
     1.031    19.663     0.200
     1.099    20.903     0.200
     1.122    21.083     0.200
     1.122    21.843     0.200
     1.255    24.323     0.200
     1.624    29.370     0.200
     1.612    30.523     0.200
     1.631    29.890     0.200
     1.673    30.823     0.200
     1.712    30.303     0.200
     1.753    30.653     0.200
     1.760    32.803     0.200
     2.097    39.934     0.200
     2.207    39.823     0.200
     2.339    43.423     0.200
     0.373     7.801     0.200
     0.373     7.898     0.200
     0.492     9.758     0.200
     0.520     9.938     0.200
     0.520     9.836     0.200
     0.627    12.898     0.200
     0.675    12.625     0.200
     0.775    15.105     0.200
     0.957    18.559     0.200
     0.972    17.535     0.200
     1.060    19.105     0.200
     1.111    20.695     0.200
     1.186    21.375     0.200
     1.189    21.039     0.200
     1.192    22.438     0.200
     1.192    22.305     0.200
     1.346    25.648     0.200
     1.259    23.996     0.200
     1.288    23.746     0.200
     1.582    27.688     0.200
     1.631    28.586     0.200
     1.661    30.078     0.200
     1.661    29.922     0.200
     1.732    31.219     0.200
     1.758    31.027     0.200
     1.758    31.164     0.200
     1.761    31.195     0.200
     1.753    31.258     0.200
     1.803    31.656     0.200
     2.094    36.164     0.200
     2.255    38.105     0.200
     2.329    39.293     0.200
     2.327    39.316     0.200
     2.460    41.051     0.200
     0.214     5.066     0.200
     0.357     7.633     0.200
     0.357     7.598     0.200
     0.357     7.707     0.200
     0.509     9.566     0.200
     0.502     9.656     0.200
     0.614    12.609     0.200
     0.655    13.469     0.200
     0.688    12.359     0.200
     0.795    14.887     0.200
     0.980    18.418     0.200
     0.977    17.520     0.200
     0.977    17.199     0.200
     1.060    18.887     0.200
     1.130    20.566     0.200
     1.191    21.336     0.200
     1.191    20.949     0.200
     1.194    20.734     0.200
     1.214    22.246     0.200
     1.214    22.066     0.200
     1.369    25.457     0.200
     1.282    23.777     0.200
     1.299    23.539     0.200
     1.374    24.637     0.200
     1.582    27.520     0.200
     1.582    27.707     0.200
     1.632    27.996     0.200
     1.632    28.520     0.200
     1.678    29.508     0.200
     1.678    29.695     0.200
     1.728    29.918     0.200
     1.747    30.969     0.200
     1.761    30.898     0.200
     1.761    30.777     0.200
     1.776    30.449     0.200
     1.763    30.836     0.200
     1.763    31.086     0.200
     2.096    36.055     0.200
     2.249    40.340     0.200
     2.277    37.910     0.200
     2.472    40.824     0.200
     0.384     7.812     0.200
     0.384     7.844     0.200
     0.490     9.961     0.200
     0.588    11.188     0.200
     0.625    12.562     0.200
     0.611    11.742     0.200
     0.757    15.336     0.200
     0.920    16.539     0.200
     0.911    18.367     0.200
     1.043    20.023     0.200
     1.105    20.125     0.200
     1.105    19.992     0.200
     1.134    20.445     0.200
     1.136    20.258     0.200
     1.166    22.469     0.200
     1.287    25.219     0.200
     1.287    24.953     0.200
     1.216    23.789     0.200
     1.303    24.445     0.200
     1.541    26.875     0.200
     1.586    28.234     0.200
     1.593    29.656     0.200
     1.665    30.992     0.200
     1.713    30.445     0.200
     1.711    31.289     0.200
     1.795    31.938     0.200
     1.795    32.133     0.200
     1.791    32.266     0.200
     2.045    36.156     0.200
     2.224    38.219     0.200
     2.262    41.133     0.200
     2.262    40.906     0.200
     2.686    45.016     0.200
     2.949    48.820     0.200
     0.291     6.166     0.200
     0.367     7.646     0.200
     0.506     9.867     0.200
     0.609    12.426     0.200
     0.583    10.996     0.200
     0.610    11.566     0.200
     0.734    14.477     0.200
     0.800    14.617     0.200
     0.800    14.396     0.200
     0.773    15.256     0.200
     0.913    16.256     0.200
     0.926    18.227     0.200
     1.050    19.848     0.200
     1.127    20.037     0.200
     1.114    19.986     0.200
     1.182    22.246     0.200
     1.183    22.326     0.200
     1.183    22.166     0.200
     1.300    25.086     0.200
     1.231    23.707     0.200
     1.311    24.027     0.200
     1.317    24.377     0.200
     1.414    24.797     0.200
     1.531    26.467     0.200
     1.577    26.787     0.200
     1.597    29.537     0.200
     1.626    29.188     0.200
     1.638    29.477     0.200
     1.667    30.707     0.200
     1.687    29.537     0.200
     1.705    29.947     0.200
     1.727    31.018     0.200
     2.265    40.836     0.200
     0.456     8.559     0.200
     0.427     8.307     0.200
     0.427     8.299     0.200
     0.452     9.419     0.200
     0.688    13.889     0.200
     0.751    14.989     0.200
     0.758    14.079     0.200
     0.921    17.909     0.200
     0.976    17.699     0.200
     0.976    17.943     0.200
     0.971    19.399     0.200
     1.058    19.209     0.200
     1.176    22.459     0.200
     1.176    22.336     0.200
     1.225    22.979     0.200
     1.273    23.849     0.200
     1.275    24.114     0.200
     1.267    24.649     0.200
     1.314    23.859     0.200
     1.382    26.739     0.200
     1.677    30.079     0.200
     1.666    29.779     0.200
     1.715    30.829     0.200
     1.736    32.109     0.200
     1.736    31.862     0.200
     1.767    32.353     0.200
     1.758    33.469     0.200
     1.810    33.429     0.200
     1.846    33.279     0.200
     1.933    33.967     0.200
     2.179    38.691     0.200
     2.373    42.195     0.200
     0.198     4.848     0.200
     0.377     7.896     0.200
     0.377     7.848     0.200
     0.493     9.408     0.200
     0.493     9.299     0.200
     0.477     9.178     0.200
     0.477     9.518     0.200
     0.637    12.898     0.200
     0.718    12.988     0.200
     0.636    13.078     0.200
     0.785    14.828     0.200
     0.868    16.129     0.200
     0.931    17.598     0.200
     0.985    18.629     0.200
     1.009    17.918     0.200
     1.009    18.027     0.200
     1.029    18.539     0.200
     1.138    21.209     0.200
     1.207    22.219     0.200
     1.224    21.598     0.200
     1.224    22.248     0.200
     1.226    21.896     0.200
     1.221    22.459     0.200
     1.221    22.668     0.200
     1.262    22.248     0.200
     1.262    22.389     0.200
     1.382    25.879     0.200
     1.284    24.039     0.200
     1.276    23.229     0.200
     1.332    23.918     0.200
     1.407    25.078     0.200
     1.481    26.527     0.200
     1.492    26.479     0.200
     1.614    27.898     0.200
     1.664    28.898     0.200
     1.664    28.709     0.200
     1.665    29.188     0.200
     1.705    30.697     0.200
     1.694    29.619     0.200
     1.776    30.709     0.200
     1.776    31.418     0.200
     1.758    30.619     0.200
     1.777    30.938     0.200
     1.777    30.799     0.200
     1.795    31.598     0.200
     1.795    31.748     0.200
     1.808    31.188     0.200
     1.880    32.473     0.200
     1.889    32.582     0.200
     2.129    36.250     0.200
     2.503    41.938     0.200
     2.764    45.295     0.200
     0.181     3.738     0.200
     0.442     8.738     0.200
     0.403     8.164     0.200
     0.403     8.148     0.200
     0.479     9.328     0.200
     0.609    12.227     0.200
     0.609    12.816     0.200
     0.666    13.508     0.200
     0.666    13.746     0.200
     0.778    14.926     0.200
     0.760    13.668     0.200
     0.906    16.598     0.200
     0.906    16.445     0.200
     0.989    17.855     0.200
     0.989    18.016     0.200
     0.965    18.539     0.200
     0.965    18.797     0.200
     0.996    19.039     0.200
     1.052    18.508     0.200
     1.203    22.086     0.200
     1.203    22.258     0.200
     1.203    22.379     0.200
     1.172    21.629     0.200
     1.248    23.086     0.200
     1.251    22.445     0.200
     1.292    24.398     0.200
     1.266    22.066     0.200
     1.266    22.309     0.200
     1.269    22.133     0.200
     1.403    26.418     0.200
     1.302    22.676     0.200
     1.302    23.078     0.200
     1.368    24.676     0.200
     1.449    25.328     0.200
     1.654    28.766     0.200
     1.654    28.887     0.200
     1.744    31.738     0.200
     1.744    31.848     0.200
     1.794    32.316     0.200
     1.784    32.238     0.200
     1.784    32.109     0.200
     1.784    33.098     0.200
     1.796    30.629     0.200
     2.184    39.418     0.200
     2.412    44.047     0.200
     2.412    42.719     0.200
     3.746    66.598     0.200
     0.212     4.830     0.200
     0.381     7.905     0.200
     0.381     7.910     0.200
     0.491     9.450     0.200
     0.487     9.400     0.200
     0.639    13.040     0.200
     0.650    12.720     0.200
     0.706    13.030     0.200
     0.777    14.990     0.200
     0.777    15.100     0.200
     0.930    17.690     0.200
     0.972    18.680     0.200
     1.001    18.100     0.200
     1.001    17.900     0.200
     1.035    18.780     0.200
     1.035    18.595     0.200
     1.141    21.130     0.200
     1.197    22.180     0.200
     1.215    21.650     0.200
     1.217    21.545     0.200
     1.256    22.220     0.200
     1.256    22.390     0.200
     1.274    23.340     0.200
     1.368    25.802     0.200
     1.272    24.130     0.200
     1.398    24.110     0.200
     1.508    27.230     0.200
     1.608    28.050     0.200
     1.666    29.510     0.200
     1.692    30.100     0.200
     1.692    30.220     0.200
     1.735    30.880     0.200
     1.735    30.430     0.200
     1.754    30.760     0.200
     1.763    31.270     0.200
     1.763    31.140     0.200
     1.765    30.970     0.200
     1.765    30.784     0.200
     1.788    31.550     0.200
     2.223    39.620     0.200
     0.449     9.057     0.200
     0.485     9.404     0.200
     0.485     9.418     0.200
     0.491     9.457     0.200
     0.516    10.137     0.200
     0.677    13.598     0.200
     0.717    14.088     0.200
     0.777    13.438     0.200
     0.802    14.668     0.200
     0.781    15.518     0.200
     0.780    14.768     0.200
     0.851    16.488     0.200
     0.934    18.527     0.200
     1.011    18.637     0.200
     1.014    18.488     0.200
     1.117    21.977     0.200
     1.091    20.857     0.200
     1.197    21.838     0.200
     1.210    23.557     0.200
     1.210    22.662     0.200
     1.210    23.707     0.200
     1.230    22.146     0.200
     1.230    22.033     0.200
     1.342    24.857     0.200
     1.406    26.268     0.200
     1.406    26.447     0.200
     1.452    25.498     0.200
     1.484    27.816     0.200
     1.602    28.377     0.200
     1.587    30.078     0.200
     1.624    28.928     0.200
     1.636    27.988     0.200
     1.645    30.307     0.200
     1.763    30.131     0.200
     1.751    32.088     0.200
     1.874    34.643     0.200
     1.931    33.312     0.200
     2.074    38.127     0.200
     2.128    37.941     0.200
     2.219    40.148     0.200
     2.353    42.299     0.200
     2.473    42.396     0.200
     2.528    43.223     0.200
     2.563    44.475     0.200
     2.710    46.461     0.200
     3.153    52.979     0.200
     0.370     7.680     0.200
     0.370     7.691     0.200
     0.499     9.709     0.200
     0.567    10.727     0.200
     0.616    12.602     0.200
     0.770    15.102     0.200
     0.814    14.751     0.200
     0.930    16.882     0.200
     0.932    18.259     0.200
     1.066    20.081     0.200
     1.097    19.793     0.200
     1.145    20.941     0.200
     1.147    21.035     0.200
     1.192    22.388     0.200
     1.182    22.114     0.200
     1.182    22.222     0.200
     1.197    21.201     0.200
     1.311    25.116     0.200
     1.311    25.231     0.200
     1.236    23.941     0.200
     1.306    24.191     0.200
     1.547    27.111     0.200
     1.614    29.605     0.200
     1.614    29.901     0.200
     1.685    31.062     0.200
     1.721    30.781     0.200
     1.732    30.546     0.200
     1.732    31.392     0.200
     2.054    35.712     0.200
     2.282    38.725     0.200
     2.282    41.201     0.200
     2.287    39.197     0.200
     2.362    39.821     0.200
     2.972    48.751     0.200
     0.269     5.305     0.200
     0.269     5.311     0.200
     0.512    10.680     0.200
     0.577    10.855     0.200
     0.603    11.570     0.200
     0.866    16.000     0.200
     0.871    16.980     0.200
     1.011    19.758     0.200
     1.011    19.988     0.200
     1.080    20.160     0.200
     1.082    21.293     0.200
     1.076    20.648     0.200
     1.112    20.281     0.200
     1.178    21.457     0.200
     1.366    26.371     0.200
     1.279    24.324     0.200
     1.318    25.660     0.200
     1.408    26.328     0.200
     1.408    26.539     0.200
     1.464    26.250     0.200
     1.605    29.969     0.200
     1.605    30.168     0.200
     1.647    29.988     0.200
     1.664    31.000     0.200
     1.732    31.270     0.200
     2.272    40.754     0.200
     2.335    41.094     0.200
     2.327    41.582     0.200
     2.382    42.160     0.200
     2.465    42.320     0.200
     2.692    46.043     0.200
     2.742    46.535     0.200
     0.446     8.477     0.200
     0.438     8.562     0.200
     0.438     8.695     0.200
     0.446     9.398     0.200
     0.700    14.062     0.200
     0.747    15.008     0.200
     0.936    17.242     0.200
     0.961    17.672     0.200
     0.974    19.422     0.200
     1.073    19.422     0.200
     1.173    22.477     0.200
     1.214    23.016     0.200
     1.214    23.203     0.200
     1.190    22.867     0.200
     1.190    23.086     0.200
     1.285    24.062     0.200
     1.285    23.664     0.200
     1.288    23.266     0.200
     1.290    22.961     0.200
     1.388    26.891     0.200
     1.388    27.016     0.200
     1.330    24.328     0.200
     1.681    29.758     0.200
     1.749    33.039     0.200
     1.749    32.844     0.200
     1.760    31.781     0.200
     1.758    33.461     0.200
     2.195    39.039     0.200
     2.302    39.773     0.200
     2.380    41.570     0.200
     0.249     5.203     0.200
     0.265     5.727     0.200
     0.471    10.414     0.200
     0.495     9.727     0.200
     0.589    11.344     0.200
     0.589    11.328     0.200
     0.766    14.062     0.200
     0.808    15.453     0.200
     0.849    16.508     0.200
     1.116    21.078     0.200
     1.123    20.758     0.200
     1.123    20.867     0.200
     1.132    20.328     0.200
     1.132    20.438     0.200
     1.237    22.984     0.200
     1.305    23.086     0.200
     1.420    25.547     0.200
     1.420    25.719     0.200
     1.431    25.883     0.200
     1.567    29.375     0.200
     1.483    26.086     0.200
     1.483    25.828     0.200
     1.519    26.586     0.200
     1.519    26.742     0.200
     1.521    26.805     0.200
     1.539    26.773     0.200
     1.581    27.719     0.200
     1.701    30.117     0.200
     1.738    29.984     0.200
     1.744    30.242     0.200
     1.754    31.219     0.200
     1.754    31.328     0.200
     1.986    35.672     0.200
     1.989    35.375     0.200
     2.260    38.250     0.200
     2.418    40.969     0.200
     2.797    48.914     0.200
     0.497     9.984     0.200
     0.534    10.711     0.200
     0.601    11.586     0.200
     0.681    12.898     0.200
     0.681    13.188     0.200
     0.842    16.625     0.200
     0.939    18.734     0.200
     0.939    18.844     0.200
     0.968    18.969     0.200
     0.968    19.070     0.200
     1.002    18.188     0.200
     1.004    18.219     0.200
     1.090    20.398     0.200
     1.090    21.234     0.200
     1.272    25.023     0.200
     1.239    22.477     0.200
     1.234    23.992     0.200
     1.423    25.781     0.200
     1.498    28.461     0.200
     1.579    28.023     0.200
     1.560    29.141     0.200
     1.744    33.539     0.200
     1.744    33.664     0.200
     1.912    35.297     0.200
     1.912    34.969     0.200
     2.224    40.078     0.200
     2.282    41.031     0.200
     2.282    41.492     0.200
     2.279    41.141     0.200
     2.462    42.609     0.200
     2.450    42.711     0.200
     2.680    47.102     0.200
     0.355     7.191     0.200
     0.371     7.859     0.200
     0.371     7.879     0.200
     0.539    10.289     0.200
     0.533    10.109     0.200
     0.533    10.219     0.200
     0.594    12.301     0.200
     0.652    12.238     0.200
     0.652    12.371     0.200
     0.756    13.281     0.200
     0.780    15.180     0.200
     0.797    15.738     0.200
     0.848    14.809     0.200
     0.848    14.988     0.200
     0.847    15.691     0.200
     0.899    17.578     0.200
     0.983    18.629     0.200
     1.062    18.738     0.200
     1.065    18.746     0.200
     1.127    19.531     0.200
     1.253    24.129     0.200
     1.156    22.000     0.200
     1.175    21.141     0.200
     1.175    20.660     0.200
     1.206    23.250     0.200
     1.227    22.289     0.200
     1.368    24.141     0.200
     1.353    24.551     0.200
     1.418    26.090     0.200
     1.436    26.371     0.200
     1.474    25.520     0.200
     1.517    25.918     0.200
     1.526    28.059     0.200
     1.526    28.160     0.200
     1.595    29.059     0.200
     1.599    28.648     0.200
     1.598    28.469     0.200
     1.638    28.699     0.200
     1.643    28.371     0.200
     1.703    30.988     0.200
     1.703    30.531     0.200
     1.762    30.129     0.200
     1.785    30.359     0.200
     1.796    31.828     0.200
     1.861    31.930     0.200
     0.134     3.772     0.200
     0.459     9.290     0.200
     0.490    10.292     0.200
     0.516    10.252     0.200
     0.895    16.593     0.200
     0.897    16.303     0.200
     0.897    16.193     0.200
     0.998    18.452     0.200
     1.091    20.803     0.200
     1.174    21.582     0.200
     1.220    22.232     0.200
     1.259    23.433     0.200
     1.259    23.232     0.200
     1.307    24.133     0.200
     1.307    23.990     0.200
     1.326    24.405     0.200
     1.387    25.312     0.200
     1.390    24.944     0.200
     1.405    24.723     0.200
     1.518    28.652     0.200
     1.605    28.872     0.200
     1.611    28.303     0.200
     1.749    30.862     0.200
     1.800    31.202     0.200
     1.966    33.686     0.200
     2.005    34.093     0.200
     2.114    35.961     0.200
     2.284    38.778     0.200
     2.514    41.865     0.200
     0.392     7.988     0.200
     0.449     8.488     0.200
     0.487     9.887     0.200
     0.749    14.262     0.200
     0.997    19.773     0.200
     1.002    18.074     0.200
     1.183    22.098     0.200
     1.209    22.715     0.200
     1.239    23.512     0.200
     1.259    23.629     0.200
     1.256    22.508     0.200
     1.401    27.035     0.200
     1.705    30.414     0.200
     1.735    32.395     0.200
     1.786    33.137     0.200
     1.802    32.461     0.200
     2.158    37.438     0.200
     2.275    39.711     0.200
     2.346    40.121     0.200
     2.388    41.262     0.200
     2.533    43.145     0.200
     0.311     6.509     0.200
     0.463     9.467     0.200
     0.463     9.419     0.200
     0.512    10.159     0.200
     0.512    10.338     0.200
     0.726    14.319     0.200
     0.826    16.060     0.200
     0.894    16.199     0.200
     0.896    17.009     0.200
     1.001    18.409     0.200
     1.042    19.569     0.200
     1.089    20.969     0.200
     1.176    21.539     0.200
     1.216    22.299     0.200
     1.216    22.432     0.200
     1.256    23.469     0.200
     1.256    23.359     0.200
     1.310    24.020     0.200
     1.326    24.890     0.200
     1.326    24.555     0.200
     1.376    26.089     0.200
     1.389    25.549     0.200
     1.392    25.481     0.200
     1.408    24.659     0.200
     1.517    28.989     0.200
     1.608    28.489     0.200
     1.608    27.769     0.200
     1.761    30.399     0.200
     1.817    31.159     0.200
     2.286    39.808     0.200
     2.323    39.270     0.200
     0.320     6.418     0.200
     0.461     9.198     0.200
     0.506    10.243     0.200
     0.887    16.735     0.200
     0.897    16.300     0.200
     1.080    20.815     0.200
     1.214    22.490     0.200
     1.249    23.024     0.200
     1.309    23.869     0.200
     1.316    24.670     0.200
     1.385    24.672     0.200
     1.507    28.696     0.200
     1.806    31.960     0.200
     0.136     3.605     0.200
     0.315     6.467     0.200
     0.315     6.316     0.200
     0.460     9.385     0.200
     0.460     9.346     0.200
     0.511    10.217     0.200
     0.511    10.096     0.200
     0.511    10.393     0.200
     0.723    14.486     0.200
     0.824    16.057     0.200
     0.891    16.846     0.200
     0.891    16.646     0.200
     0.881    17.285     0.200
     0.897    16.326     0.200
     0.897    16.207     0.200
     0.997    18.127     0.200
     0.997    18.436     0.200
     1.039    19.496     0.200
     1.086    20.967     0.200
     1.171    21.516     0.200
     1.171    21.396     0.200
     1.217    22.506     0.200
     1.217    22.166     0.200
     1.254    23.615     0.200
     1.254    23.316     0.200
     1.247    22.977     0.200
     1.321    24.666     0.200
     1.308    23.986     0.200
     1.374    25.906     0.200
     1.385    24.916     0.200
     1.385    25.076     0.200
     1.387    25.125     0.200
     1.403    26.355     0.200
     1.513    28.676     0.200
     1.513    28.803     0.200
     1.404    24.236     0.200
     1.404    24.627     0.200
     1.449    25.627     0.200
     1.604    28.285     0.200
     1.611    28.547     0.200
     1.611    28.246     0.200
     1.616    28.766     0.200
     1.757    30.047     0.200
     1.750    30.596     0.200
     1.811    31.846     0.200
     1.811    32.047     0.200
     1.801    31.207     0.200
     0.305     5.836     0.200
     0.353     6.975     0.200
     0.516    10.346     0.200
     0.516    10.131     0.200
     0.520    10.645     0.200
     0.607    11.545     0.200
     0.660    12.795     0.200
     0.660    12.541     0.200
     0.685    12.715     0.200
     0.701    14.494     0.200
     0.773    15.375     0.200
     0.789    14.836     0.200
     0.799    14.734     0.200
     0.960    19.045     0.200
     0.960    18.828     0.200
     0.973    18.936     0.200
     0.992    19.225     0.200
     1.013    19.516     0.200
     1.016    18.250     0.200
     1.064    19.865     0.200
     1.081    20.734     0.200
     1.081    21.193     0.200
     1.156    22.445     0.200
     1.296    25.309     0.200
     1.196    22.875     0.200
     1.231    22.109     0.200
     1.250    23.984     0.200
     1.250    23.855     0.200
     1.268    25.074     0.200
     1.298    23.775     0.200
     1.345    25.645     0.200
     1.413    25.295     0.200
     1.426    26.324     0.200
     1.426    26.029     0.200
     1.459    25.654     0.200
     1.527    28.404     0.200
     1.581    29.445     0.200
     1.588    28.375     0.200
     1.694    31.307     0.200
     1.756    32.045     0.200
     1.765    31.936     0.200
     1.765    33.180     0.200
     1.921    33.506     0.200
     2.187    39.234     0.200
     2.249    40.518     0.200
     2.460    41.863     0.200
     2.464    41.852     0.200
     3.718    60.992     0.200
     3.789    61.994     0.200
     0.403     8.242     0.200
     0.403     8.174     0.200
     0.444     8.564     0.200
     0.444     8.462     0.200
     0.479     9.714     0.200
     0.665    13.404     0.200
     0.758    14.109     0.200
     0.904    16.894     0.200
     0.964    17.534     0.200
     0.990    18.109     0.200
     0.994    19.514     0.200
     1.050    19.134     0.200
     1.188    22.314     0.200
     1.250    22.924     0.200
     1.250    23.037     0.200
     1.203    23.244     0.200
     1.203    22.719     0.200
     1.249    23.104     0.200
     1.264    23.084     0.200
     1.267    23.150     0.200
     1.300    23.354     0.200
     1.281    24.614     0.200
     1.401    26.984     0.200
     1.652    29.374     0.200
     1.694    30.124     0.200
     1.703    29.914     0.200
     1.742    31.854     0.200
     1.742    32.228     0.200
     2.169    39.317     0.200
     2.390    41.027     0.200
     2.930    52.074     0.200
     0.327     6.014     0.200
     0.353     7.145     0.200
     0.605    11.254     0.200
     0.849    16.145     0.200
     0.849    16.568     0.200
     0.933    17.543     0.200
     1.002    18.049     0.200
     1.099    19.684     0.200
     1.197    23.293     0.200
     1.144    21.293     0.200
     1.144    21.662     0.200
     1.312    24.145     0.200
     1.312    24.055     0.200
     1.330    25.164     0.200
     1.330    24.814     0.200
     1.341    24.484     0.200
     1.341    25.059     0.200
     1.423    27.324     0.200
     1.440    26.773     0.200
     1.549    29.254     0.200
     1.549    28.771     0.200
     1.666    29.654     0.200
     1.718    31.033     0.200
     2.533    43.463     0.200
     0.265     5.448     0.200
     0.342     6.758     0.200
     0.342     6.628     0.200
     0.422     8.668     0.200
     0.422     8.778     0.200
     0.546    11.528     0.200
     0.588    11.545     0.200
     0.588    11.278     0.200
     0.588    11.438     0.200
     0.736    14.598     0.200
     0.776    13.768     0.200
     0.776    14.438     0.200
     0.776    14.235     0.200
     0.852    16.838     0.200
     0.961    17.418     0.200
     0.961    17.578     0.200
     1.012    19.658     0.200
     1.038    20.088     0.200
     1.038    19.801     0.200
     1.089    19.828     0.200
     1.089    20.397     0.200
     1.089    20.278     0.200
     1.116    20.668     0.200
     1.166    21.358     0.200
     1.166    21.848     0.200
     1.166    21.998     0.200
     1.165    21.858     0.200
     1.267    23.438     0.200
     1.267    23.008     0.200
     1.351    24.858     0.200
     1.373    25.178     0.200
     1.489    28.328     0.200
     1.398    26.428     0.200
     1.437    26.198     0.200
     1.437    26.368     0.200
     1.437    26.494     0.200
     1.481    27.168     0.200
     1.481    27.048     0.200
     1.484    26.233     0.200
     1.517    27.238     0.200
     1.573    28.018     0.200
     1.664    29.188     0.200
     1.698    29.978     0.200
     1.698    31.018     0.200
     1.698    30.888     0.200
     1.726    30.638     0.200
     1.742    31.208     0.200
     1.789    32.008     0.200
     1.789    32.298     0.200
     1.789    33.402     0.200
     1.985    36.040     0.200
     2.098    36.429     0.200
     2.126    36.572     0.200
     2.213    38.047     0.200
     2.229    40.988     0.200
     2.229    38.266     0.200
     3.178    52.375     0.200
     3.199    52.951     0.200
     0.302     5.863     0.200
     0.346     7.131     0.200
     0.346     7.152     0.200
     0.534    10.664     0.200
     0.582    12.084     0.200
     0.586    11.713     0.200
     0.600    11.133     0.200
     0.762    15.393     0.200
     0.745    14.453     0.200
     0.769    14.383     0.200
     0.796    15.863     0.200
     0.883    16.322     0.200
     0.936    18.762     0.200
     1.036    20.264     0.200
     1.036    20.107     0.200
     1.053    20.363     0.200
     1.098    20.072     0.200
     1.100    20.033     0.200
     1.150    20.674     0.200
     1.154    22.113     0.200
     1.145    20.982     0.200
     1.145    20.740     0.200
     1.301    25.297     0.200
     1.202    23.043     0.200
     1.202    23.158     0.200
     1.239    22.834     0.200
     1.281    23.254     0.200
     1.347    25.293     0.200
     1.608    29.232     0.200
     1.656    29.303     0.200
     1.674    31.062     0.200
     1.739    32.084     0.200
     1.779    31.504     0.200
     1.802    31.264     0.200
     2.270    40.229     0.200
     2.371    41.443     0.200
     2.394    41.113     0.200
     2.703    45.682     0.200
     2.955    49.506     0.200
     0.352     7.055     0.200
     0.439     9.027     0.200
     0.439     9.352     0.200
     0.525    10.184     0.200
     0.525    10.156     0.200
     0.753    15.047     0.200
     0.842    15.086     0.200
     0.842    15.879     0.200
     0.789    15.797     0.200
     0.903    16.445     0.200
     1.030    19.945     0.200
     1.030    20.180     0.200
     1.050    19.484     0.200
     1.142    20.465     0.200
     1.142    21.812     0.200
     1.100    20.785     0.200
     1.183    21.707     0.200
     1.183    22.605     0.200
     1.203    21.777     0.200
     1.313    24.324     0.200
     1.307    24.094     0.200
     1.375    25.617     0.200
     1.375    25.414     0.200
     1.469    27.234     0.200
     1.469    28.156     0.200
     1.417    25.957     0.200
     1.420    25.109     0.200
     1.450    26.074     0.200
     1.552    27.426     0.200
     1.552    28.047     0.200
     1.734    30.414     0.200
     2.060    36.066     0.200
     2.250    39.988     0.200
     2.321    40.828     0.200
     2.471    43.832     0.200
     0.463     8.914     0.200
     0.463     9.297     0.200
     0.487     9.992     0.200
     0.487     9.398     0.200
     0.498     9.969     0.200
     0.498     9.750     0.200
     0.668    13.797     0.200
     0.738    14.148     0.200
     0.714    14.516     0.200
     0.788    13.938     0.200
     0.831    15.719     0.200
     0.802    16.211     0.200
     0.802    16.359     0.200
     0.895    15.977     0.200
     0.893    17.680     0.200
     1.042    19.461     0.200
     1.045    19.469     0.200
     1.007    19.867     0.200
     1.150    22.945     0.200
     1.135    20.156     0.200
     1.098    21.312     0.200
     1.212    23.695     0.200
     1.212    23.195     0.200
     1.196    21.672     0.200
     1.324    24.562     0.200
     1.476    25.898     0.200
     1.448    27.492     0.200
     1.512    26.672     0.200
     1.525    28.797     0.200
     1.630    29.195     0.200
     1.607    30.656     0.200
     1.607    30.484     0.200
     1.781    30.656     0.200
     1.751    32.547     0.200
     1.751    33.109     0.200
     1.878    35.016     0.200
     1.865    33.930     0.200
     1.865    33.812     0.200
     1.961    34.812     0.200
     1.961    35.484     0.200
     2.116    39.773     0.200
     2.117    38.156     0.200
     2.141    40.906     0.200
     2.260    43.102     0.200
     2.326    41.414     0.200
     2.547    44.148     0.200
     2.738    47.703     0.200
     0.239     4.664     0.200
     0.418     8.684     0.200
     0.418     8.926     0.200
     0.550    10.711     0.200
     0.550    10.773     0.200
     0.561    12.047     0.200
     0.733    14.336     0.200
     0.733    14.746     0.200
     0.915    16.785     0.200
     0.915    16.449     0.200
     1.018    19.816     0.200
     1.072    19.855     0.200
     1.072    19.996     0.200
     1.116    21.023     0.200
     1.163    22.086     0.200
     1.220    21.715     0.200
     1.220    21.824     0.200
     1.310    24.137     0.200
     1.310    24.316     0.200
     1.298    24.785     0.200
     1.366    25.824     0.200
     1.461    27.945     0.200
     1.400    25.875     0.200
     1.400    26.074     0.200
     1.435    25.414     0.200
     1.437    25.078     0.200
     1.472    26.184     0.200
     1.472    26.316     0.200
     1.531    27.273     0.200
     1.531    27.594     0.200
     1.528    27.273     0.200
     1.618    28.773     0.200
     1.663    30.395     0.200
     1.702    30.574     0.200
     1.710    31.156     0.200
     1.710    31.496     0.200
     1.710    31.336     0.200
     1.778    32.363     0.200
     1.778    33.566     0.200
     2.546    43.477     0.200
     0.265     5.562     0.200
     0.265     5.461     0.200
     0.343     6.521     0.200
     0.524    10.562     0.200
     0.524    10.791     0.200
     0.643    12.121     0.200
     0.772    15.441     0.200
     0.738    14.481     0.200
     0.738    14.971     0.200
     0.788    15.231     0.200
     0.788    15.041     0.200
     0.894    17.361     0.200
     1.044    19.851     0.200
     1.044    20.611     0.200
     1.002    18.771     0.200
     1.041    19.281     0.200
     0.999    19.741     0.200
     1.014    19.891     0.200
     1.184    22.141     0.200
     1.172    22.721     0.200
     1.331    25.881     0.200
     1.312    25.151     0.200
     1.291    24.321     0.200
     1.308    25.611     0.200
     1.308    25.371     0.200
     1.392    25.211     0.200
     1.441    26.171     0.200
     1.441    25.981     0.200
     1.487    27.201     0.200
     1.459    27.051     0.200
     1.459    27.981     0.200
     1.544    27.711     0.200
     1.533    29.151     0.200
     1.533    28.961     0.200
     1.572    28.701     0.200
     1.572    28.812     0.200
     1.590    29.471     0.200
     1.590    29.711     0.200
     1.690    29.841     0.200
     1.912    33.291     0.200
     2.004    35.081     0.200
     2.306    39.911     0.200
     2.395    41.001     0.200
     0.350     7.312     0.200
     0.350     7.180     0.200
     0.516     9.508     0.200
     0.516     9.375     0.200
     0.644    11.898     0.200
     0.694    13.758     0.200
     0.792    14.750     0.200
     0.881    16.773     0.200
     0.937    16.719     0.200
     0.959    18.148     0.200
     0.959    18.266     0.200
     1.089    20.203     0.200
     1.151    20.234     0.200
     1.154    20.336     0.200
     1.196    20.773     0.200
     1.178    21.828     0.200
     1.178    22.336     0.200
     1.338    25.266     0.200
     1.206    22.188     0.200
     1.334    23.539     0.200
     1.318    23.727     0.200
     1.458    26.703     0.200
     1.453    26.648     0.200
     1.547    26.789     0.200
     1.634    29.828     0.200
     1.703    30.625     0.200
     1.697    29.898     0.200
     1.758    31.188     0.200
     1.820    31.594     0.200
     1.843    31.320     0.200
     1.848    32.797     0.200
     1.824    32.391     0.200
     1.824    31.953     0.200
     2.058    35.781     0.200
     2.267    38.562     0.200
     2.314    39.703     0.200
     2.428    41.047     0.200
     2.380    39.820     0.200
     2.436    40.758     0.200
     2.839    46.648     0.200
     2.999    49.242     0.200
     0.366     7.477     0.200
     0.366     7.383     0.200
     0.501     9.828     0.200
     0.634    11.961     0.200
     0.712    14.195     0.200
     0.775    15.211     0.200
     0.890    17.320     0.200
     0.939    18.547     0.200
     0.934    16.688     0.200
     1.073    20.336     0.200
     1.095    19.695     0.200
     1.095    19.594     0.200
     1.188    21.719     0.200
     1.188    22.516     0.200
     1.184    22.727     0.200
     1.190    22.156     0.200
     1.190    22.430     0.200
     1.199    21.992     0.200
     1.318    25.547     0.200
     1.243    24.078     0.200
     1.307    24.312     0.200
     1.332    24.047     0.200
     1.621    29.977     0.200
     1.703    30.242     0.200
     1.725    30.797     0.200
     1.738    30.930     0.200
     1.738    31.391     0.200
     1.789    31.781     0.200
     1.789    31.523     0.200
     1.807    32.461     0.200
     1.807    31.984     0.200
     1.849    31.547     0.200
     2.058    36.227     0.200
     2.248    38.898     0.200
     2.295    39.945     0.200
     0.318     6.672     0.200
     0.467     9.805     0.200
     0.524    10.484     0.200
     0.524    10.289     0.200
     0.782    15.109     0.200
     0.787    15.375     0.200
     0.927    17.258     0.200
     0.927    17.078     0.200
     0.946    18.070     0.200
     1.064    20.422     0.200
     1.154    20.898     0.200
     1.212    22.203     0.200
     1.212    22.352     0.200
     1.220    21.758     0.200
     1.310    23.945     0.200
     1.403    25.820     0.200
     1.403    25.305     0.200
     1.503    27.109     0.200
     1.461    25.203     0.200
     1.548    26.844     0.200
     1.616    28.211     0.200
     1.679    29.211     0.200
     0.266     5.462     0.200
     0.438     9.271     0.200
     0.593    11.651     0.200
     0.583    12.422     0.200
     0.662    12.712     0.200
     0.718    13.691     0.200
     0.814    15.441     0.200
     0.830    15.892     0.200
     0.940    18.611     0.200
     0.882    17.802     0.200
     0.909    17.702     0.200
     0.917    18.252     0.200
     1.047    19.002     0.200
     1.048    19.401     0.200
     1.076    20.162     0.200
     1.122    22.191     0.200
     1.360    25.122     0.200
     1.381    24.662     0.200
     1.376    26.672     0.200
     1.474    27.412     0.200
     1.499    28.691     0.200
     1.604    29.802     0.200
     1.667    30.021     0.200
     1.712    30.642     0.200
     1.737    30.861     0.200
     1.771    31.792     0.200
     1.907    33.252     0.200
     0.385     7.855     0.200
     0.497     9.414     0.200
     0.482     9.574     0.200
     0.702    13.133     0.200
     0.771    15.004     0.200
     0.865    15.914     0.200
     0.932    18.152     0.200
     0.965    18.953     0.200
     0.999    17.992     0.200
     1.135    21.195     0.200
     1.225    22.113     0.200
     1.191    22.633     0.200
     1.256    22.984     0.200
     1.235    23.402     0.200
     1.361    26.016     0.200
     1.265    24.285     0.200
     1.607    28.703     0.200
     1.656    29.473     0.200
     1.687    31.355     0.200
     1.758    32.043     0.200
     1.787    32.195     0.200
     0.376     7.526     0.200
     0.438     8.726     0.200
     0.497     9.736     0.200
     0.761    14.826     0.200
     0.751    14.426     0.200
     0.866    15.696     0.200
     1.016    18.636     0.200
     1.014    19.076     0.200
     1.069    20.216     0.200
     1.166    20.616     0.200
     1.163    21.375     0.200
     1.181    22.396     0.200
     1.274    23.416     0.200
     1.347    24.796     0.200
     1.342    25.226     0.200
     1.447    27.116     0.200
     1.415    25.646     0.200
     1.742    30.766     0.200
     1.767    30.776     0.200
     0.407     8.555     0.200
     0.407     8.242     0.200
     0.568    11.672     0.200
     0.650    11.195     0.200
     0.650    11.086     0.200
     0.693    12.625     0.200
     0.693    12.508     0.200
     0.766    13.633     0.200
     0.807    15.273     0.200
     0.845    15.805     0.200
     0.842    16.125     0.200
     0.879    16.875     0.200
     0.993    17.172     0.200
     1.087    19.414     0.200
     1.087    20.609     0.200
     1.009    19.484     0.200
     1.091    19.336     0.200
     1.176    22.539     0.200
     1.188    22.609     0.200
     1.209    22.703     0.200
     1.334    23.086     0.200
     1.371    24.414     0.200
     1.498    26.555     0.200
     1.492    26.109     0.200
     1.513    25.867     0.200
     1.639    27.859     0.200
     1.823    31.758     0.200
     1.823    31.828     0.200
     1.921    34.016     0.200
     1.941    33.422     0.200
     2.002    35.664     0.200
     3.150    55.578     0.200
     0.209     4.986     0.200
     0.465     9.916     0.200
     0.540    10.855     0.200
     0.640    12.906     0.200
     0.759    15.436     0.200
     0.966    18.506     0.200
     1.048    19.887     0.200
     1.163    22.275     0.200
     1.272    22.836     0.200
     1.343    24.146     0.200
     1.315    23.557     0.200
     1.522    26.355     0.200
     1.594    27.615     0.200
     1.714    29.387     0.200
     0.402     8.004     0.200
     0.404     8.176     0.200
     0.431     8.496     0.200
     0.667    13.555     0.200
     0.911    17.246     0.200
     0.911    16.836     0.200
     0.968    18.656     0.200
     1.004    19.164     0.200
     1.060    19.387     0.200
     1.060    19.523     0.200
     1.201    21.895     0.200
     1.253    23.445     0.200
     1.293    23.484     0.200
     1.293    24.105     0.200
     1.308    23.656     0.200
     1.413    26.613     0.200
     1.372    24.637     0.200
     1.457    26.496     0.200
     1.523    27.047     0.200
     1.521    27.305     0.200
     1.547    27.504     0.200
     1.660    29.555     0.200
     1.660    28.766     0.200
     1.688    28.934     0.200
     1.688    29.824     0.200
     1.731    30.895     0.200
     1.754    31.414     0.200
     1.801    31.355     0.200
     2.804    49.664     0.200
     0.413     8.242     0.200
     0.415     8.219     0.200
     0.440     8.500     0.200
     0.678    13.742     0.200
     0.917    17.871     0.200
     0.917    16.730     0.200
     0.977    18.699     0.200
     0.977    18.582     0.200
     1.061    18.680     0.200
     1.061    20.660     0.200
     1.193    21.949     0.200
     1.263    23.582     0.200
     1.313    23.191     0.200
     1.313    23.059     0.200
     1.282    23.949     0.200
     1.282    24.090     0.200
     1.401    26.641     0.200
     1.459    25.770     0.200
     1.531    26.891     0.200
     1.556    27.801     0.200
     1.665    28.992     0.200
     1.681    29.422     0.200
     1.681    29.902     0.200
     1.740    30.969     0.200
     1.748    31.859     0.200
     1.808    32.031     0.200
     1.847    33.730     0.200
     1.847    32.180     0.200
     1.934    33.270     0.200
     1.934    33.609     0.200
     1.929    33.551     0.200
     1.951    33.582     0.200
     1.951    33.832     0.200
     2.416    44.352     0.200
     0.524    10.604     0.200
     0.524    10.834     0.200
     0.679    12.084     0.200
     0.679    12.434     0.200
     0.680    12.705     0.200
     0.770    14.424     0.200
     0.770    14.564     0.200
     0.784    14.484     0.200
     0.808    15.744     0.200
     0.852    16.613     0.200
     0.948    18.904     0.200
     0.973    19.273     0.200
     1.053    18.854     0.200
     1.080    20.785     0.200
     1.080    19.863     0.200
     1.150    20.094     0.200
     1.123    22.094     0.200
     1.182    21.285     0.200
     1.280    25.264     0.200
     1.244    23.354     0.200
     1.244    23.715     0.200
     1.291    22.564     0.200
     1.257    24.574     0.200
     1.341    25.334     0.200
     1.402    24.545     0.200
     1.500    28.395     0.200
     1.562    27.484     0.200
     1.574    27.834     0.200
     1.718    31.604     0.200
     1.749    32.254     0.200
     1.753    32.113     0.200
     1.907    33.184     0.200
     1.941    34.854     0.200
     1.934    34.834     0.200
     1.934    34.045     0.200
     2.001    35.234     0.200
     2.168    39.664     0.200
     0.262     6.105     0.200
     0.461    10.035     0.200
     0.800    15.453     0.200
     0.826    15.586     0.200
     1.083    19.156     0.200
     1.083    19.363     0.200
     1.118    20.766     0.200
     1.119    20.383     0.200
     1.261    21.926     0.200
     1.261    22.066     0.200
     1.256    22.594     0.200
     1.395    25.203     0.200
     1.397    25.324     0.200
     1.381    24.156     0.200
     1.381    24.406     0.200
     1.461    25.695     0.200
     1.461    26.254     0.200
     1.561    27.625     0.200
     1.491    26.055     0.200
     1.491    25.344     0.200
     1.561    27.895     0.200
     1.532    26.605     0.200
     1.533    26.535     0.200
     1.656    28.203     0.200
     1.689    28.453     0.200
     1.694    28.836     0.200
     1.956    34.844     0.200
     0.813    15.289     0.200
     0.908    18.008     0.200
     0.997    18.668     0.200
     1.329    24.020     0.200
     1.439    28.090     0.200
     1.466    27.320     0.200
     1.660    29.617     0.200
     1.686    30.211     0.200
     1.793    33.020     0.200
     2.118    38.711     0.200
     2.127    40.039     0.200
     5.064    85.027     0.200
     0.709    13.726     0.200
     0.754    14.706     0.200
     0.754    14.595     0.200
     0.862    17.025     0.200
     0.945    18.785     0.200
     0.945    18.965     0.200
     0.948    19.085     0.200
     1.027    18.925     0.200
     1.106    22.045     0.200
     1.152    21.436     0.200
     1.266    25.146     0.200
     1.249    23.865     0.200
     1.249    24.125     0.200
     1.254    24.625     0.200
     1.348    25.865     0.200
     1.375    24.805     0.200
     1.375    24.695     0.200
     1.419    25.365     0.200
     1.419    25.375     0.200
     1.472    28.235     0.200
     1.538    27.155     0.200
     1.546    28.146     0.200
     1.546    28.015     0.200
     1.662    29.615     0.200
     1.698    31.485     0.200
     1.734    32.335     0.200
     1.879    33.565     0.200
     1.879    33.675     0.200
     1.879    35.275     0.200
     1.987    35.416     0.200
     1.985    34.706     0.200
     2.139    38.755     0.200
     2.139    38.985     0.200
     2.647    45.315     0.200
     2.733    47.085     0.200
     0.592    11.297     0.200
     0.803    16.426     0.200
     0.886    16.617     0.200
     0.946    19.367     0.200
     1.044    20.656     0.200
     1.151    21.086     0.200
     1.169    23.387     0.200
     1.210    23.766     0.200
     1.310    26.086     0.200
     1.252    24.918     0.200
     1.501    27.539     0.200
     1.547    28.727     0.200
     1.586    30.086     0.200
     1.676    30.516     0.200
     1.837    33.156     0.200
     2.009    36.918     0.200
     0.586    11.048     0.200
     0.796    16.158     0.200
     0.897    17.038     0.200
     0.943    19.108     0.200
     1.050    20.438     0.200
     1.161    22.098     0.200
     1.171    23.208     0.200
     1.204    23.519     0.200
     1.511    28.318     0.200
     1.558    29.058     0.200
     1.593    29.898     0.200
     1.826    33.108     0.200
     0.292     5.973     0.200
     0.889    16.516     0.200
     0.889    16.633     0.200
     1.149    20.652     0.200
     1.139    21.344     0.200
     1.340    24.453     0.200
     1.319    24.203     0.200
     1.319    24.023     0.200
     1.367    23.613     0.200
     1.438    26.695     0.200
     1.431    26.594     0.200
     1.431    26.113     0.200
     1.507    27.004     0.200
     1.541    26.973     0.200
     1.556    28.793     0.200
     1.720    29.434     0.200
     1.720    30.402     0.200
     1.664    29.312     0.200
     1.779    30.254     0.200
     1.779    30.395     0.200
     1.779    31.273     0.200
     1.842    30.965     0.200
     0.496     9.695     0.200
     0.914    16.426     0.200
     0.914    16.805     0.200
     0.998    18.953     0.200
     1.114    19.633     0.200
     1.160    21.824     0.200
     1.208    22.465     0.200
     1.281    22.965     0.200
     1.300    22.914     0.200
     1.307    22.844     0.200
     1.317    23.914     0.200
     1.364    25.152     0.200
     1.364    24.332     0.200
     1.516    26.934     0.200
     1.414    24.676     0.200
     1.414    24.965     0.200
     1.468    25.492     0.200
     1.468    25.273     0.200
     1.466    26.484     0.200
     1.466    26.305     0.200
     1.502    26.465     0.200
     1.516    27.285     0.200
     1.529    26.492     0.200
     1.528    26.383     0.200
     1.589    27.582     0.200
     1.679    29.023     0.200
     1.693    29.105     0.200
     1.706    29.152     0.200
     1.717    30.926     0.200
     1.717    29.945     0.200
     1.705    29.375     0.200
     0.250     4.109     0.200
     0.296     5.594     0.200
     0.555    10.781     0.200
     0.546    11.523     0.200
     0.827    17.234     0.200
     0.842    16.000     0.200
     1.124    21.875     0.200
     0.995    19.453     0.200
     1.224    23.945     0.200
     1.088    22.039     0.200
     1.405    26.953     0.200
     1.501    28.234     0.200
     1.589    29.852     0.200
     1.683    30.703     0.200
     1.793    31.586     0.200
     1.783    31.555     0.200
     1.623    29.781     0.200
     0.397     8.008     0.200
     0.399     8.027     0.200
     0.470     8.867     0.200
     0.659    12.918     0.200
     0.954    18.688     0.200
     1.028    19.027     0.200
     1.028    19.137     0.200
     1.162    22.559     0.200
     1.243    23.617     0.200
     1.243    23.316     0.200
     1.283    23.836     0.200
     1.257    24.246     0.200
     1.257    24.617     0.200
     1.379    26.695     0.200
     1.426    26.246     0.200
     1.635    29.676     0.200
     1.635    29.188     0.200
     1.685    30.168     0.200
     1.684    29.785     0.200
     1.715    32.336     0.200
     1.715    31.887     0.200
     1.709    30.758     0.200
     1.709    30.926     0.200
     1.780    31.945     0.200
     1.815    32.785     0.200
     1.815    33.188     0.200
     2.384    44.578     0.200
     0.416     8.078     0.200
     0.416     7.945     0.200
     0.493     9.883     0.200
     0.495     9.883     0.200
     0.759    15.234     0.200
     0.977    19.023     0.200
     1.061    19.945     0.200
     1.140    20.125     0.200
     1.140    20.359     0.200
     1.152    22.203     0.200
     1.152    21.836     0.200
     1.234    22.836     0.200
     1.265    24.273     0.200
     1.265    23.914     0.200
     1.302    24.516     0.200
     1.302    24.727     0.200
     1.407    26.836     0.200
     1.345    25.016     0.200
     1.397    24.812     0.200
     1.407    26.273     0.200
     1.537    27.469     0.200
     1.748    30.508     0.200
     1.799    32.898     0.200
     1.799    33.008     0.200
     1.798    31.227     0.200
     1.798    31.242     0.200
     2.467    45.078     0.200
     0.418     8.164     0.200
     0.418     8.047     0.200
     0.497    10.008     0.200
     0.500    10.008     0.200
     0.763    15.469     0.200
     0.763    15.148     0.200
     0.974    19.039     0.200
     1.065    19.891     0.200
     1.065    19.570     0.200
     1.142    20.406     0.200
     1.142    20.516     0.200
     1.148    21.711     0.200
     1.148    21.539     0.200
     1.234    22.898     0.200
     1.262    23.688     0.200
     1.262    24.219     0.200
     1.300    24.664     0.200
     1.300    24.391     0.200
     1.405    26.930     0.200
     1.349    25.148     0.200
     1.349    24.734     0.200
     1.400    25.789     0.200
     1.400    24.914     0.200
     1.405    26.781     0.200
     1.540    27.180     0.200
     1.593    27.906     0.200
     1.593    28.266     0.200
     1.751    30.664     0.200
     1.751    30.805     0.200
     1.801    31.336     0.200
     1.801    30.836     0.200
     1.800    32.484     0.200
     1.800    31.945     0.200
     0.497     9.797     0.200
     0.745    13.977     0.200
     0.858    16.820     0.200
     0.933    17.258     0.200
     0.988    19.875     0.200
     1.060    19.750     0.200
     1.168    20.875     0.200
     1.250    24.094     0.200
     1.428    25.156     0.200
     1.507    26.758     0.200
     1.542    27.477     0.200
     1.658    29.875     0.200
     1.689    30.336     0.200
     2.288    39.609     0.200
     2.288    39.750     0.200
     2.288    39.469     0.200
     3.105    52.164     0.200
     3.169    52.867     0.200
     3.669    60.609     0.200
     0.471     9.266     0.200
     0.641    12.086     0.200
     0.964    17.641     0.200
     1.273    24.125     0.200
     1.343    25.141     0.200
     1.482    26.109     0.200
     1.580    28.406     0.200
     1.620    27.945     0.200
     1.756    31.594     0.200
     1.750    30.000     0.200
     1.741    30.680     0.200
     0.753    14.266     0.200
     0.860    15.906     0.200
     0.942    17.883     0.200
     0.978    19.055     0.200
     1.050    20.211     0.200
     1.259    24.711     0.200
     1.434    27.367     0.200
     1.542    29.023     0.200
     1.511    27.047     0.200
     1.545    27.406     0.200
     1.660    31.023     0.200
     1.694    31.164     0.200
     0.886    15.672     0.200
     0.944    17.945     0.200
     1.259    24.445     0.200
     1.312    25.211     0.200
     1.809    33.219     0.200
     0.528    10.305     0.200
     0.665    12.945     0.200
     0.829    15.125     0.200
     0.915    17.422     0.200
     0.885    17.297     0.200
     0.997    18.469     0.200
     1.141    22.172     0.200
     1.354    23.953     0.200
     1.439    27.281     0.200
     1.464    27.055     0.200
     1.524    27.102     0.200
     1.652    29.125     0.200
     1.730    32.148     0.200
     1.788    33.125     0.200
     0.736    13.969     0.200
     0.917    16.875     0.200
     0.995    17.328     0.200
     0.984    19.469     0.200
     1.007    19.914     0.200
     1.311    25.078     0.200
     1.358    25.664     0.200
     1.491    27.883     0.200
     1.602    28.539     0.200
     1.752    31.477     0.200
     1.779    32.578     0.200
     2.663    47.703     0.200
     0.479     9.570     0.200
     0.629    11.547     0.200
     0.769    13.867     0.200
     0.900    16.766     0.200
     0.949    17.266     0.200
     1.093    21.586     0.200
     1.099    19.945     0.200
     1.315    23.531     0.200
     1.475    26.000     0.200
     1.603    27.836     0.200
     1.675    30.695     0.200
     1.747    32.445     0.200
     1.759    31.930     0.200
     3.219    56.375     0.200
     0.468     9.094     0.200
     1.093    21.734     0.200
     1.378    26.180     0.200
     1.482    26.562     0.200
     1.771    31.094     0.200
     1.895    33.258     0.200
     0.472     9.219     0.200
     0.637    11.852     0.200
     1.093    21.531     0.200
     1.481    26.094     0.200
     1.767    31.508     0.200
     1.907    34.094     0.200
     0.517     9.750     0.200
     0.694    12.773     0.200
     0.842    15.375     0.200
     1.002    17.305     0.200
     1.018    20.531     0.200
     1.120    20.680     0.200
     1.173    21.430     0.200
     1.203    21.633     0.200
     1.317    24.430     0.200
     1.369    23.859     0.200
     1.497    25.875     0.200
     1.578    29.242     0.200
     1.639    31.109     0.200
     1.663    31.742     0.200
     1.647    29.336     0.200
     1.774    31.586     0.200
     1.808    32.555     0.200
     2.013    34.922     0.200
     0.473     9.320     0.200
     0.640    11.492     0.200
     1.097    21.570     0.200
     1.382    26.414     0.200
     1.440    25.953     0.200
     1.484    26.289     0.200
     1.611    28.070     0.200
     1.682    31.266     0.200
     1.770    31.391     0.200
     0.499     9.633     0.200
     0.805    14.828     0.200
     1.222    23.797     0.200
     1.385    25.297     0.200
     1.644    28.320     0.200
     0.515    10.020     0.200
     0.780    14.880     0.200
     0.825    15.780     0.200
     0.897    17.220     0.200
     0.927    18.930     0.200
     1.101    20.010     0.200
     1.077    20.830     0.200
     1.218    23.820     0.200
     1.243    22.840     0.200
     1.436    25.860     0.200
     1.467    26.660     0.200
     1.626    28.150     0.200
     1.753    30.760     0.200
     2.037    35.930     0.200
     0.542    10.499     0.200
     0.674    12.969     0.200
     1.168    22.729     0.200
     1.126    22.209     0.200
     1.536    27.129     0.200
     1.800    32.829     0.200
     2.394    41.879     0.200
     3.512    58.639     0.200
     0.513     9.990     0.200
     0.759    14.310     0.200
     0.858    16.000     0.200
     0.944    17.330     0.200
     0.972    19.790     0.200
     1.047    20.310     0.200
     1.261    24.700     0.200
     1.510    27.050     0.200
     1.545    29.330     0.200
     1.543    27.870     0.200
     1.658    30.170     0.200
     1.694    29.260     0.200
     1.877    34.630     0.200
     1.837    32.490     0.200
     0.513     9.952     0.200
     0.570    11.022     0.200
     0.747    13.362     0.200
     0.907    18.532     0.200
     0.960    18.143     0.200
     1.072    20.763     0.200
     1.229    22.343     0.200
     1.257    23.042     0.200
     1.228    23.702     0.200
     1.369    25.442     0.200
     1.427    24.902     0.200
     1.697    31.582     0.200
     1.698    30.442     0.200
     1.866    33.562     0.200
     0.484     9.433     0.200
     0.597    11.332     0.200
     0.747    13.422     0.200
     0.919    16.862     0.200
     0.923    17.442     0.200
     0.931    18.652     0.200
     1.071    20.632     0.200
     1.252    22.742     0.200
     1.224    22.893     0.200
     1.283    23.263     0.200
     1.357    26.162     0.200
     1.397    26.042     0.200
     1.648    30.882     0.200
     1.705    32.282     0.200
     1.727    30.702     0.200
     1.853    32.723     0.200
     0.532    10.398     0.200
     0.777    14.848     0.200
     0.858    16.108     0.200
     0.955    17.088     0.200
     1.031    20.658     0.200
     1.274    24.309     0.200
     1.311    22.948     0.200
     1.512    26.788     0.200
     1.544    27.248     0.200
     1.557    29.388     0.200
     1.657    29.708     0.200
     1.699    29.538     0.200
     1.826    31.638     0.200
     0.478     9.406     0.200
     0.566    10.887     0.200
     0.718    13.387     0.200
     0.886    16.547     0.200
     0.938    17.566     0.200
     0.943    18.616     0.200
     1.039    18.767     0.200
     1.043    20.066     0.200
     1.254    23.406     0.200
     1.696    30.337     0.200
     0.573    11.195     0.200
     0.580    11.235     0.200
     0.799    14.335     0.200
     0.845    16.925     0.200
     0.924    17.095     0.200
     1.003    18.735     0.200
     1.098    19.295     0.200
     1.122    21.516     0.200
     1.247    22.655     0.200
     1.269    23.115     0.200
     1.375    25.715     0.200
     1.453    25.665     0.200
     1.581    28.115     0.200
     0.576    10.131     0.200
     0.522    10.689     0.200
     1.084    20.609     0.200
     1.188    21.270     0.200
     1.436    25.020     0.200
     1.876    31.730     0.200
     0.493     9.734     0.200
     0.637    12.195     0.200
     0.905    17.205     0.200
     1.109    22.186     0.200
     1.394    26.715     0.200
     1.437    26.385     0.200
     1.487    27.176     0.200
     1.689    31.766     0.200
     1.745    31.945     0.200
     1.762    33.016     0.200
     1.766    32.266     0.200
     0.517    10.023     0.200
     0.751    14.344     0.200
     0.872    16.383     0.200
     0.977    19.793     0.200
     1.185    21.104     0.200
     1.271    24.854     0.200
     1.314    24.184     0.200
     1.446    25.584     0.200
     1.706    30.164     0.200
     0.466     9.131     0.200
     0.613    10.801     0.200
     1.071    20.420     0.200
     1.455    25.439     0.200
     1.743    30.840     0.200
     1.882    33.539     0.200
     0.490     9.562     0.200
     0.598    11.172     0.200
     1.077    20.883     0.200
     1.197    21.383     0.200
     1.448    25.582     0.200
     1.727    30.922     0.200
     0.609    11.543     0.200
     0.930    18.320     0.200
     0.930    18.352     0.200
     1.080    21.191     0.200
     1.204    22.871     0.200
     1.366    26.570     0.200
     1.409    25.590     0.200
     1.456    26.723     0.200
     1.584    27.820     0.200
     1.733    32.922     0.200
     1.738    31.500     0.200
     1.887    33.660     0.200
     0.569    11.066     0.200
     0.868    15.637     0.200
     1.023    18.836     0.200
     0.846    16.598     0.200
     1.193    23.965     0.200
     1.187    20.938     0.200
     1.305    23.848     0.200
     1.478    28.176     0.200
     1.480    27.438     0.200
     1.551    27.906     0.200
     1.844    34.586     0.200
     1.806    32.668     0.200
     0.508     9.914     0.200
     0.866    16.156     0.200
     0.983    19.406     0.200
     1.049    20.215     0.200
     1.178    21.004     0.200
     1.262    24.656     0.200
     1.545    28.934     0.200
     1.667    29.766     0.200
     1.699    29.555     0.200
     1.829    32.293     0.200
     0.513     9.887     0.200
     0.615    11.758     0.200
     0.900    18.258     0.200
     0.945    17.488     0.200
     0.934    18.000     0.200
     1.107    21.340     0.200
     1.303    23.578     0.200
     1.392    26.738     0.200
     1.472    25.828     0.200
     1.743    31.977     0.200
     0.855    17.828     0.200
     1.142    21.949     0.200
     1.427    27.527     0.200
     1.419    26.727     0.200
     1.490    25.637     0.200
     1.618    28.848     0.200
     1.746    31.039     0.200
     2.083    36.520     0.200
     0.512    10.141     0.200
     0.763    14.582     0.200
     0.834    15.762     0.200
     0.885    16.082     0.200
     0.924    18.633     0.200
     1.085    19.621     0.200
     1.206    23.633     0.200
     1.610    27.891     0.200
     1.738    30.051     0.200
     0.519    10.203     0.200
     0.775    14.781     0.200
     0.831    15.863     0.200
     0.896    16.320     0.200
     0.922    18.832     0.200
     1.097    19.980     0.200
     1.077    20.801     0.200
     1.218    23.820     0.200
     1.622    28.133     0.200
     1.903    33.621     0.200
     1.923    33.750     0.200
     2.044    35.723     0.200
     0.467     9.148     0.200
     0.624    11.883     0.200
     0.895    16.852     0.200
     0.945    18.531     0.200
     1.080    21.453     0.200
     1.276    22.648     0.200
     1.308    23.289     0.200
     1.365    26.312     0.200
     1.424    25.852     0.200
     1.466    25.820     0.200
     1.594    27.922     0.200
     1.664    30.391     0.200
     1.719    31.633     0.200
     1.879    32.914     0.200
     1.080    20.625     0.200
     0.439     8.609     0.200
     0.614    11.227     0.200
     1.052    20.758     0.200
     1.241    23.109     0.200
     1.447    25.070     0.200
     1.745    31.398     0.200
     0.462     9.530     0.200
     0.842    15.380     0.200
     0.902    15.930     0.200
     1.218    23.300     0.200
     1.267    21.970     0.200
     1.501    28.090     0.200
     1.487    25.670     0.200
     1.523    26.210     0.200
     1.642    28.610     0.200
     1.665    28.190     0.200
     2.817    50.150     0.200
     2.893    51.730     0.200
     0.501     9.756     0.200
     0.755    14.436     0.200
     0.850    15.526     0.200
     0.931    16.956     0.200
     0.979    19.696     0.200
     1.059    20.346     0.200
     1.249    24.256     0.200
     1.291    23.436     0.200
     1.535    27.256     0.200
     1.684    28.896     0.200
     1.845    32.625     0.200
     0.492     9.570     0.200
     0.584    11.160     0.200
     0.744    13.359     0.200
     0.908    16.641     0.200
     0.937    18.059     0.200
     0.925    18.961     0.200
     1.068    20.641     0.200
     1.229    23.418     0.200
     1.435    25.039     0.200
     1.563    27.598     0.200
     1.714    30.609     0.200
     1.841    32.629     0.200
     1.869    33.430     0.200
     1.911    34.898     0.200
     1.970    35.281     0.200
     0.519    10.047     0.200
     0.635    12.055     0.200
     0.927    17.836     0.200
     0.894    18.227     0.200
     0.965    17.641     0.200
     1.125    21.766     0.200
     1.123    19.633     0.200
     1.170    22.445     0.200
     1.295    23.297     0.200
     1.492    26.242     0.200
     1.620    28.242     0.200
     1.699    31.391     0.200
     1.762    31.805     0.200
     1.893    33.367     0.200
     1.928    34.688     0.200
     1.919    35.000     0.200
     0.498     9.602     0.200
     0.787    14.912     0.200
     0.808    15.182     0.200
     0.904    16.092     0.200
     0.959    19.122     0.200
     1.077    20.502     0.200
     1.223    24.232     0.200
     1.258    21.632     0.200
     1.461    25.632     0.200
     1.493    26.272     0.200
     1.608    28.792     0.200
     1.646    28.822     0.200
     1.773    30.702     0.200
     1.833    33.532     0.200
     1.879    34.692     0.200
     1.888    34.222     0.200
     1.938    35.162     0.200
     0.540    10.676     0.200
     0.735    13.865     0.200
     0.915    16.865     0.200
     0.993    17.545     0.200
     0.986    19.646     0.200
     1.009    19.615     0.200
     1.308    25.295     0.200
     1.356    23.766     0.200
     1.750    29.816     0.200
     1.781    32.236     0.200
     0.565    11.012     0.200
     0.583    10.973     0.200
     1.119    21.250     0.200
     1.187    22.590     0.200
     1.706    30.301     0.200
     1.903    34.141     0.200
     1.852    35.293     0.200
     2.014    36.500     0.200
     0.566    11.195     0.200
     0.590    11.254     0.200
     0.801    14.234     0.200
     0.932    17.074     0.200
     0.850    17.586     0.200
     0.991    18.914     0.200
     1.104    19.195     0.200
     1.124    21.566     0.200
     1.256    22.414     0.200
     1.181    22.945     0.200
     1.386    25.355     0.200
     1.461    25.605     0.200
     1.589    28.047     0.200
     1.712    31.195     0.200
     1.909    34.164     0.200
     1.855    35.066     0.200
     2.019    36.117     0.200
     0.546    10.852     0.200
     0.606    11.031     0.200
     1.123    21.883     0.200
     1.178    22.703     0.200
     1.472    25.875     0.200
     1.915    34.184     0.200
     1.880    34.395     0.200
     2.021    35.773     0.200
     2.452    41.953     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.788    57.000     0.200
     1.839    57.562     0.200
     2.124    67.453     0.200
     1.319    39.758     0.200
     1.665    51.277     0.200
     1.733    53.449     0.200
     1.825    55.570     0.200
     1.672    53.820     0.200
     1.724    53.328     0.200
     1.750    54.359     0.200
     1.818    56.898     0.200
     2.365    69.398     0.200
     3.313    93.328     0.200
     3.416    95.748     0.200
     1.506    47.684     0.200
     1.861    56.883     0.200
     2.009    59.684     0.200
     1.626    52.258     0.200
     1.651    52.961     0.200
     1.713    53.359     0.200
     3.914   107.828     0.200
     4.842   131.059     0.200
     1.942    59.195     0.200
     1.573    51.070     0.200
     1.582    51.633     0.200
     3.819   105.023     0.200
     1.577    49.797     0.200
     1.636    51.520     0.200
     1.706    55.037     0.200
     1.782    56.637     0.200
     2.304    68.506     0.200
     3.898   109.855     0.200
     4.188   117.037     0.200
     5.123   141.379     0.200
     8.547   222.086     0.200
    12.110   312.135     0.200
     1.706    54.152     0.200
     1.711    54.254     0.200
     1.804    55.652     0.200
     1.835    58.352     0.200
     2.296    68.262     0.200
     2.803    81.211     0.200
     1.736    54.867     0.200
     1.814    57.938     0.200
     2.707    78.324     0.200
     3.194    90.277     0.200
     3.298    93.285     0.200
     8.550   218.977     0.200
    12.081   311.164     0.200
     1.501    47.953     0.200
     3.293    92.031     0.200
     3.994   108.867     0.200
     3.898   106.164     0.200
     5.698   148.480     0.200
     8.573   218.441     0.200
     3.855   106.852     0.200
     1.152    38.703     0.200
     1.723    53.984     0.200
     2.791    79.789     0.200
     3.941   109.625     0.200
     8.582   218.953     0.200
    10.133   262.828     0.200
     3.957   109.727     0.200
     8.601   218.828     0.200
    10.002   257.148     0.200
    10.128   263.250     0.200
     1.719    54.781     0.200
     3.947   108.781     0.200
     8.590   219.836     0.200
     1.560    50.465     0.200
     3.927   108.965     0.200
     8.569   220.465     0.200
     8.569   219.734     0.200
     1.549    50.938     0.200
     2.293    69.867     0.200
     2.293    69.203     0.200
     2.293    73.180     0.200
     3.910   110.039     0.200
     1.344    45.469     0.200
     1.493    48.453     0.200
     1.719    53.555     0.200
     1.719    53.797     0.200
     1.522    48.758     0.200
     1.620    51.156     0.200
     1.676    53.328     0.200
     1.899    58.078     0.200
     1.919    59.109     0.200
     2.117    64.875     0.200
     3.433    95.898     0.200
     1.371    45.289     0.200
     1.453    45.777     0.200
     1.458    46.688     0.200
     1.752    55.039     0.200
     1.855    56.680     0.200
     1.709    55.032     0.200
     2.612    76.143     0.200
     3.203    90.682     0.200
     3.876   108.252     0.200
     3.876   108.572     0.200
     4.571   123.822     0.200
     5.095   134.682     0.200
     1.530    48.344     0.200
     1.577    50.284     0.200
     1.817    55.764     0.200
     1.806    55.403     0.200
     2.021    62.844     0.200
     3.156    87.374     0.200
     3.898   106.324     0.200
     4.527   122.834     0.200
     1.338    44.004     0.200
     1.785    56.354     0.200
     2.912    80.354     0.200
     3.189    88.854     0.200
     3.881   107.664     0.200
     8.550   218.793     0.200
     1.676    54.252     0.200
     1.716    55.223     0.200
     1.764    56.223     0.200
     1.879    59.232     0.200
     2.180    68.223     0.200
     3.858   105.902     0.200
     1.609    53.098     0.200
     1.822    57.768     0.200
     1.822    57.896     0.200
     2.037    63.697     0.200
     2.127    66.777     0.200
     2.303    70.527     0.200
     2.385    71.246     0.200
     3.327    94.777     0.200
     1.675    51.945     0.200
     1.672    53.676     0.200
     1.723    54.805     0.200
     1.758    57.266     0.200
     1.831    59.016     0.200
     1.855    58.996     0.200
     1.641    52.945     0.200
     1.681    52.102     0.200
     1.714    54.266     0.200
     1.705    54.314     0.200
     1.734    56.135     0.200
     1.734    56.006     0.200
     1.808    57.914     0.200
     1.836    57.975     0.200
     1.920    59.871     0.200
     2.108    67.574     0.200
     2.169    68.818     0.200
     2.175    66.234     0.200
     2.180    66.127     0.200
     3.960   109.523     0.200
     1.677    54.572     0.200
     1.732    55.682     0.200
     1.803    59.133     0.200
     1.867    58.902     0.200
     1.872    59.473     0.200
     1.761    56.322     0.200
     1.836    58.213     0.200
     1.867    59.143     0.200
     3.981   111.232     0.200
     1.687    53.438     0.200
     1.739    55.367     0.200
     1.856    59.027     0.200
     4.008   111.678     0.200
     4.684   126.867     0.200
     7.190   185.092     0.200
     8.653   220.148     0.200
     1.786    56.480     0.200
     2.203    66.598     0.200
     3.874   107.719     0.200
     1.363    44.309     0.200
     1.363    44.445     0.200
     1.497    49.508     0.200
     1.643    52.039     0.200
     1.680    53.699     0.200
     1.680    54.020     0.200
     1.742    53.480     0.200
     1.751    55.348     0.200
     1.774    55.617     0.200
     1.748    55.090     0.200
     1.765    55.688     0.200
     1.807    56.352     0.200
     1.864    57.867     0.200
     3.225    90.348     0.200
     3.219    91.188     0.200
     3.351    93.090     0.200
     3.637    99.641     0.200
     3.849   106.648     0.200
     3.917   105.539     0.200
     4.348   119.559     0.200
     4.673   125.238     0.200
     5.167   134.938     0.200
     5.247   139.598     0.200
     5.745   149.133     0.200
     8.554   217.848     0.200
     8.578   218.320     0.200
     1.673    54.123     0.200
     1.760    56.743     0.200
     2.097    66.135     0.200
     2.097    67.413     0.200
     2.097    66.674     0.200
     2.207    67.678     0.200
     2.254    72.233     0.200
     3.856   107.913     0.200
     1.582    50.348     0.200
     1.631    51.957     0.200
     1.661    53.238     0.200
     1.661    52.820     0.200
     1.758    54.797     0.200
     1.758    55.141     0.200
     1.761    55.207     0.200
     1.753    54.148     0.200
     1.803    55.699     0.200
     3.628    98.398     0.200
     3.794   103.477     0.200
     3.898   105.578     0.200
     4.399   117.156     0.200
     1.632    51.680     0.200
     1.678    52.977     0.200
     1.761    54.102     0.200
     1.776    54.027     0.200
     1.776    53.848     0.200
     1.763    55.109     0.200
     1.821    55.402     0.200
     3.001    82.629     0.200
     3.231    89.527     0.200
     3.366    91.477     0.200
     3.390    94.352     0.200
     3.650    98.586     0.200
     3.817   103.637     0.200
     3.817   104.891     0.200
     3.918   105.527     0.200
     4.057   108.387     0.200
     4.409   117.020     0.200
     4.686   123.887     0.200
     1.593    51.859     0.200
     1.593    51.289     0.200
     1.665    53.914     0.200
     1.711    54.266     0.200
     1.711    54.023     0.200
     1.791    56.570     0.200
     2.045    62.891     0.200
     3.014    84.539     0.200
     3.308    92.875     0.200
     3.360    92.992     0.200
     3.732   102.727     0.200
     3.778   105.312     0.200
     4.636   124.406     0.200
     5.163   138.297     0.200
     1.182    40.438     0.200
     1.597    50.967     0.200
     1.667    52.736     0.200
     1.727    53.746     0.200
     1.806    56.477     0.200
     3.190    89.707     0.200
     3.325    92.146     0.200
     3.743   102.277     0.200
     4.652   124.307     0.200
     1.267    42.169     0.200
     1.767    57.883     0.200
     1.758    56.959     0.200
     1.846    59.839     0.200
     1.933    61.443     0.200
     2.179    69.425     0.200
     2.921    83.487     0.200
     3.474    98.541     0.200
     3.838   105.719     0.200
     1.492    47.039     0.200
     1.614    50.148     0.200
     1.614    49.629     0.200
     1.664    51.447     0.200
     1.777    54.176     0.200
     1.795    55.947     0.200
     1.808    55.158     0.200
     1.880    56.891     0.200
     1.889    58.811     0.200
     2.772    78.328     0.200
     3.229    89.998     0.200
     3.229    89.268     0.200
     3.323    91.381     0.200
     3.323    91.238     0.200
     3.344    91.793     0.200
     3.421    94.510     0.200
     3.833   103.559     0.200
     3.867   105.248     0.200
     4.170   113.508     0.200
     4.383   116.209     0.200
     4.691   125.857     0.200
     4.680   123.658     0.200
     5.301   139.889     0.200
     5.332   140.197     0.200
     5.568   143.848     0.200
     6.153   160.188     0.200
     7.022   179.697     0.200
     1.403    46.062     0.200
     1.794    56.879     0.200
     1.784    56.352     0.200
     1.784    56.617     0.200
     1.796    57.488     0.200
     1.837    58.676     0.200
     1.917    59.723     0.200
     2.184    66.637     0.200
     2.170    68.008     0.200
     4.713   129.477     0.200
     5.299   143.656     0.200
     1.608    50.650     0.200
     1.666    51.630     0.200
     1.692    54.270     0.200
     1.692    53.289     0.200
     1.735    54.220     0.200
     1.735    54.020     0.200
     1.763    55.580     0.200
     1.765    54.230     0.200
     1.765    54.090     0.200
     1.788    55.640     0.200
     1.801    55.183     0.200
     1.876    57.432     0.200
     3.218    88.770     0.200
     3.218    90.350     0.200
     3.238    89.290     0.200
     3.317    91.390     0.200
     3.317    91.516     0.200
     3.341    90.900     0.200
     3.341    91.690     0.200
     3.416    94.574     0.200
     3.635    98.390     0.200
     3.819   103.640     0.200
     3.819   104.895     0.200
     3.926   105.840     0.200
     3.926   106.682     0.200
     4.165   113.283     0.200
     4.330   116.503     0.200
     4.383   116.340     0.200
     4.670   123.670     0.200
     4.676   125.788     0.200
     4.676   126.150     0.200
     5.287   140.450     0.200
     5.318   140.740     0.200
     6.110   157.820     0.200
     1.763    56.881     0.200
     1.751    55.617     0.200
     1.874    60.643     0.200
     1.894    59.088     0.200
     2.074    68.371     0.200
     2.074    66.498     0.200
     2.079    65.926     0.200
     2.079    65.758     0.200
     2.128    65.357     0.200
     2.128    67.033     0.200
     2.128    66.908     0.200
     2.219    70.764     0.200
     2.219    70.088     0.200
     3.268    93.432     0.200
     3.786   107.697     0.200
     4.459   120.297     0.200
     4.973   137.977     0.200
     5.018   138.828     0.200
     5.029   139.178     0.200
     5.265   144.117     0.200
     5.826   156.797     0.200
     5.878   158.287     0.200
     6.460   173.066     0.200
     6.533   174.518     0.200
     1.614    51.731     0.200
     1.614    51.102     0.200
     1.685    53.392     0.200
     1.721    54.102     0.200
     1.732    54.312     0.200
     1.732    54.191     0.200
     1.803    56.405     0.200
     1.824    56.802     0.200
     2.054    62.971     0.200
     2.595    74.850     0.200
     2.972    83.401     0.200
     3.192    89.521     0.200
     3.192    88.812     0.200
     3.320    92.347     0.200
     3.320    92.802     0.200
     3.358    93.945     0.200
     3.755   102.251     0.200
     3.854   104.451     0.200
     4.616   123.921     0.200
     5.224   139.121     0.200
     5.244   139.842     0.200
     6.040   157.571     0.200
     6.081   158.831     0.200
     7.122   183.241     0.200
     1.605    53.129     0.200
     1.664    54.531     0.200
     1.814    57.867     0.200
     1.814    58.441     0.200
     2.272    73.449     0.200
     2.272    72.871     0.200
     3.422    96.879     0.200
     3.796   106.352     0.200
     3.859   109.539     0.200
     3.872   108.531     0.200
     3.981   110.758     0.200
     4.521   122.852     0.200
     4.662   127.918     0.200
     5.212   142.809     0.200
     5.257   144.699     0.200
     5.266   145.078     0.200
     6.064   161.488     0.200
     6.771   179.641     0.200
     7.167   187.801     0.200
     1.285    43.008     0.200
     1.760    56.211     0.200
     1.758    56.656     0.200
     1.758    56.773     0.200
     1.824    58.242     0.200
     1.861    60.305     0.200
     2.195    69.672     0.200
     2.195    69.273     0.200
     2.718    79.766     0.200
     2.908    83.312     0.200
     3.284    93.602     0.200
     3.845   108.148     0.200
     4.699   129.023     0.200
     5.312   145.812     0.200
     5.362   147.438     0.200
     6.147   162.617     0.200
     1.420    45.195     0.200
     1.519    48.102     0.200
     1.521    47.844     0.200
     1.701    52.984     0.200
     1.738    53.719     0.200
     1.754    54.484     0.200
     1.864    58.203     0.200
     1.871    57.438     0.200
     1.893    58.227     0.200
     1.929    58.023     0.200
     1.986    62.164     0.200
     1.986    61.273     0.200
     1.989    61.336     0.200
     2.084    63.664     0.200
     2.138    63.648     0.200
     4.181   113.719     0.200
     1.272    42.672     0.200
     1.408    49.164     0.200
     1.744    57.758     0.200
     1.744    56.430     0.200
     1.912    61.336     0.200
     1.880    59.898     0.200
     2.224    72.578     0.200
     2.224    71.008     0.200
     2.282    73.938     0.200
     2.282    72.469     0.200
     2.279    71.766     0.200
     1.175    38.191     0.200
     1.526    48.891     0.200
     1.595    50.988     0.200
     1.703    53.598     0.200
     1.703    53.738     0.200
     1.762    55.199     0.200
     1.817    56.762     0.200
     1.817    56.461     0.200
     1.861    57.043     0.200
     1.975    63.098     0.200
     3.069    85.605     0.200
     3.289    92.520     0.200
     3.327    92.852     0.200
     3.601   100.242     0.200
     3.688   102.793     0.200
     3.775   104.773     0.200
     3.981   108.699     0.200
     4.035   111.051     0.200
     4.472   119.141     0.200
     5.111   138.301     0.200
     5.964   155.500     0.200
     1.611    49.784     0.200
     1.815    55.758     0.200
     1.864    56.942     0.200
     2.005    61.123     0.200
     2.114    63.292     0.200
     2.891    82.049     0.200
     3.038    85.836     0.200
     3.292    91.779     0.200
     3.556    98.587     0.200
     3.937   108.773     0.200
     1.735    55.102     0.200
     1.786    57.805     0.200
     1.802    56.691     0.200
     1.905    59.367     0.200
     2.158    68.430     0.200
     2.197    66.637     0.200
     3.448    97.219     0.200
     3.854   107.258     0.200
     1.216    39.199     0.200
     1.326    42.009     0.200
     1.389    43.939     0.200
     1.392    43.977     0.200
     1.811    56.049     0.200
     1.817    55.879     0.200
     1.861    57.289     0.200
     1.861    57.591     0.200
     1.882    57.770     0.200
     1.882    59.264     0.200
     1.953    60.249     0.200
     2.008    61.786     0.200
     2.110    65.599     0.200
     1.309    41.690     0.200
     1.385    43.719     0.200
     1.806    56.275     0.200
     1.853    57.311     0.200
     1.872    59.018     0.200
     1.403    45.006     0.200
     1.567    49.986     0.200
     1.611    49.836     0.200
     1.757    54.217     0.200
     1.750    55.406     0.200
     1.811    55.676     0.200
     1.811    55.512     0.200
     1.812    55.896     0.200
     1.859    57.307     0.200
     1.859    56.918     0.200
     1.877    58.676     0.200
     1.949    61.105     0.200
     1.948    60.217     0.200
     1.968    61.738     0.200
     2.005    62.102     0.200
     2.113    65.438     0.200
     2.774    78.781     0.200
     2.885    82.045     0.200
     2.886    80.826     0.200
     2.886    80.932     0.200
     2.996    84.941     0.200
     3.037    85.697     0.200
     3.288    91.506     0.200
     3.288    92.668     0.200
     3.290    90.615     0.200
     3.555    98.164     0.200
     3.600    99.406     0.200
     3.691   101.584     0.200
     3.936   108.713     0.200
     3.973   107.926     0.200
     3.973   108.344     0.200
     3.984   109.486     0.200
     4.036   108.584     0.200
     4.099   112.262     0.200
     4.257   114.570     0.200
     4.300   115.592     0.200
     4.306   116.932     0.200
     4.468   119.807     0.200
     4.520   122.432     0.200
     4.690   125.338     0.200
     4.719   125.434     0.200
     4.745   126.951     0.200
     4.806   129.412     0.200
     4.823   129.865     0.200
     4.823   130.463     0.200
     1.765    56.883     0.200
     1.892    60.045     0.200
     1.652    52.784     0.200
     1.694    52.214     0.200
     1.703    53.714     0.200
     1.742    55.804     0.200
     1.782    55.854     0.200
     1.782    56.024     0.200
     1.794    56.384     0.200
     1.814    58.524     0.200
     1.835    57.694     0.200
     1.916    60.564     0.200
     2.169    67.134     0.200
     2.169    65.754     0.200
     2.686    77.589     0.200
     3.459    96.692     0.200
     4.711   128.504     0.200
     1.314    45.107     0.200
     1.852    58.594     0.200
     1.913    58.805     0.200
     1.913    59.010     0.200
     1.930    59.854     0.200
     2.936    82.334     0.200
     4.811   129.414     0.200
     4.858   130.543     0.200
     5.469   144.344     0.200
     1.489    48.268     0.200
     1.484    48.090     0.200
     1.698    53.998     0.200
     1.698    53.656     0.200
     1.698    53.638     0.200
     1.789    56.378     0.200
     1.789    56.592     0.200
     1.869    57.478     0.200
     1.921    59.508     0.200
     1.985    61.258     0.200
     2.053    62.708     0.200
     2.098    66.524     0.200
     2.126    64.988     0.200
     2.338    68.118     0.200
     2.512    72.688     0.200
     2.595    74.728     0.200
     2.919    81.738     0.200
     2.919    82.853     0.200
     3.148    88.048     0.200
     3.148    89.655     0.200
     3.161    88.298     0.200
     3.161    88.933     0.200
     3.178    89.518     0.200
     3.199    88.978     0.200
     3.201    89.528     0.200
     3.357    93.943     0.200
     3.637   100.098     0.200
     3.637   100.814     0.200
     3.673   102.044     0.200
     3.940   107.678     0.200
     3.952   108.358     0.200
     3.952   108.986     0.200
     4.106   111.908     0.200
     4.106   113.460     0.200
     4.169   111.438     0.200
     4.300   115.598     0.200
     4.423   120.481     0.200
     4.586   125.386     0.200
     4.622   122.468     0.200
     4.622   125.740     0.200
     4.794   127.908     0.200
     4.794   130.919     0.200
     4.813   130.867     0.200
     4.864   131.400     0.200
     4.917   132.155     0.200
     5.414   141.618     0.200
     5.505   145.368     0.200
     6.276   162.808     0.200
     1.739    55.279     0.200
     1.832    57.865     0.200
     1.837    57.133     0.200
     1.313    43.105     0.200
     1.307    43.344     0.200
     1.307    42.441     0.200
     1.375    45.477     0.200
     1.369    44.914     0.200
     1.417    46.117     0.200
     1.552    48.953     0.200
     1.795    54.855     0.200
     1.803    55.707     0.200
     1.855    57.176     0.200
     1.872    57.746     0.200
     1.951    58.926     0.200
     1.988    60.656     0.200
     2.257    65.406     0.200
     2.471    71.754     0.200
     2.662    74.895     0.200
     2.831    79.594     0.200
     3.082    86.855     0.200
     3.155    88.504     0.200
     3.421    95.316     0.200
     3.701    99.906     0.200
     3.932   107.176     0.200
     4.230   112.684     0.200
     4.217   114.527     0.200
     4.312   116.355     0.200
     5.396   142.434     0.200
     5.470   143.836     0.200
     1.607    52.789     0.200
     1.751    56.570     0.200
     1.751    57.000     0.200
     1.865    58.672     0.200
     1.961    61.117     0.200
     2.116    68.625     0.200
     2.116    68.984     0.200
     2.117    68.539     0.200
     2.117    69.086     0.200
     2.141    69.352     0.200
     2.141    69.523     0.200
     2.260    73.094     0.200
     1.310    42.711     0.200
     1.298    42.137     0.200
     1.400    45.074     0.200
     1.472    46.645     0.200
     1.618    50.426     0.200
     1.710    54.715     0.200
     1.710    54.426     0.200
     1.778    56.676     0.200
     1.778    56.914     0.200
     1.824    57.395     0.200
     1.875    58.926     0.200
     1.879    59.645     0.200
     1.959    62.324     0.200
     2.007    64.066     0.200
     2.024    61.844     0.200
     2.083    64.277     0.200
     2.229    70.734     0.200
     2.229    70.168     0.200
     2.232    68.164     0.200
     2.232    70.773     0.200
     2.232    67.688     0.200
     2.465    72.180     0.200
     2.819    80.578     0.200
     2.853    82.562     0.200
     3.102    88.555     0.200
     3.197    90.352     0.200
     3.629   101.602     0.200
     3.625   101.121     0.200
     3.925   109.094     0.200
     4.071   113.465     0.200
     4.379   119.645     0.200
     4.769   131.336     0.200
     5.385   147.594     0.200
     5.388   145.773     0.200
     5.469   148.297     0.200
     5.970   157.750     0.200
     7.275   189.227     0.200
     9.359   241.094     0.200
     1.932    62.071     0.200
     3.171    89.541     0.200
     1.178    38.500     0.200
     1.178    38.773     0.200
     1.338    43.516     0.200
     1.318    43.898     0.200
     1.318    41.234     0.200
     1.634    52.133     0.200
     1.697    52.609     0.200
     1.758    55.023     0.200
     1.758    54.883     0.200
     1.820    56.445     0.200
     1.824    56.906     0.200
     1.824    56.430     0.200
     2.058    63.836     0.200
     2.058    65.039     0.200
     2.099    63.188     0.200
     2.159    62.664     0.200
     2.412    68.523     0.200
     3.218    90.266     0.200
     3.341    92.977     0.200
     3.381    92.617     0.200
     3.782   104.180     0.200
     4.105   112.281     0.200
     4.270   116.062     0.200
     4.509   122.648     0.200
     4.431   118.773     0.200
     4.550   123.227     0.200
     4.587   124.938     0.200
     1.190    39.227     0.200
     1.190    38.984     0.200
     1.621    52.031     0.200
     1.738    54.961     0.200
     1.807    56.477     0.200
     1.825    57.000     0.200
     2.058    64.680     0.200
     3.360    94.461     0.200
     3.763   104.672     0.200
     1.338    42.211     0.200
     1.632    49.914     0.200
     1.947    58.414     0.200
     1.434    45.762     0.200
     1.604    52.191     0.200
     1.667    52.021     0.200
     1.265    41.344     0.200
     1.796    56.445     0.200
     3.030    86.375     0.200
     3.812   105.633     0.200
     3.920   107.484     0.200
     1.584    48.726     0.200
     1.742    54.076     0.200
     1.785    55.646     0.200
     1.819    55.716     0.200
     1.838    56.686     0.200
     1.915    58.396     0.200
     1.951    59.036     0.200
     2.697    75.986     0.200
     3.131    87.716     0.200
     3.214    89.966     0.200
     3.236    90.746     0.200
     3.908   106.206     0.200
     4.043   109.716     0.200
     4.757   127.996     0.200
     5.373   142.085     0.200
     5.440   144.446     0.200
     6.219   161.416     0.200
     1.660    52.207     0.200
     1.688    52.344     0.200
     1.754    55.605     0.200
     3.894   108.664     0.200
     5.113   137.285     0.200
     8.633   218.785     0.200
     8.633   219.926     0.200
     1.665    52.402     0.200
     1.681    52.680     0.200
     1.740    54.309     0.200
     1.748    55.781     0.200
     1.808    56.301     0.200
     1.847    57.441     0.200
     1.934    59.500     0.200
     1.929    59.750     0.200
     2.181    69.070     0.200
     2.799    79.730     0.200
     3.973   108.840     0.200
     8.621   221.980     0.200
     1.280    42.754     0.200
     1.257    41.824     0.200
     1.257    42.104     0.200
     1.280    42.875     0.200
     1.907    59.273     0.200
     2.168    65.584     0.200
     2.168    69.773     0.200
     3.769   103.773     0.200
     5.340   141.145     0.200
     1.256    39.895     0.200
     1.395    44.215     0.200
     1.397    44.453     0.200
     1.381    43.473     0.200
     1.532    47.164     0.200
     1.533    45.836     0.200
     1.656    49.906     0.200
     1.845    55.074     0.200
     1.901    56.664     0.200
     1.439    48.148     0.200
     2.118    64.141     0.200
     2.100    64.840     0.200
     2.127    64.938     0.200
     1.266    42.275     0.200
     1.254    41.835     0.200
     1.662    54.065     0.200
     1.698    54.815     0.200
     1.879    57.875     0.200
     1.987    62.325     0.200
     1.985    62.226     0.200
     2.236    69.285     0.200
     3.021    85.775     0.200
     1.586    52.297     0.200
     1.676    53.008     0.200
     3.639   101.199     0.200
     3.803   105.758     0.200
     3.837   106.977     0.200
     4.603   125.379     0.200
     4.678   126.559     0.200
     1.826    57.479     0.200
     2.020    62.498     0.200
     4.673   126.328     0.200
     1.319    42.426     0.200
     1.438    45.844     0.200
     1.438    45.703     0.200
     1.431    45.562     0.200
     1.507    47.234     0.200
     1.664    50.855     0.200
     1.779    54.684     0.200
     1.779    54.645     0.200
     1.886    59.285     0.200
     1.160    37.676     0.200
     1.160    36.094     0.200
     1.208    39.184     0.200
     1.281    40.125     0.200
     1.307    41.152     0.200
     1.317    41.715     0.200
     1.516    45.492     0.200
     1.414    43.344     0.200
     1.468    45.555     0.200
     1.466    46.344     0.200
     1.466    44.766     0.200
     1.502    46.324     0.200
     1.529    47.043     0.200
     1.589    48.914     0.200
     1.693    51.414     0.200
     1.706    52.223     0.200
     1.717    53.844     0.200
     1.717    50.883     0.200
     1.705    52.344     0.200
     2.003    56.574     0.200
     2.574    71.473     0.200
     4.885   128.184     0.200
     1.379    45.957     0.200
     1.715    55.535     0.200
     1.815    57.836     0.200
     1.910    58.957     0.200
     2.149    68.348     0.200
     2.335    69.336     0.200
     3.443    97.797     0.200
     3.862   108.926     0.200
     3.944   110.309     0.200
     1.407    45.539     0.200
     1.748    54.594     0.200
     1.799    56.625     0.200
     1.799    56.945     0.200
     1.798    55.633     0.200
     1.928    60.094     0.200
     2.014    60.859     0.200
     2.262    64.383     0.200
     2.716    75.039     0.200
     4.003   109.359     0.200
     4.798   125.383     0.200
     1.405    45.617     0.200
     1.593    49.938     0.200
     1.751    55.008     0.200
     1.801    56.984     0.200
     1.800    55.945     0.200
     1.931    60.852     0.200
     1.931    58.688     0.200
     2.021    61.711     0.200
     2.265    65.977     0.200
     2.252    65.148     0.200
     2.713    75.008     0.200
     4.002   109.008     0.200
     4.242   116.039     0.200
     4.797   128.664     0.200
     1.756    54.844     0.200
     1.876    60.414     0.200
     1.885    58.984     0.200
     1.925    60.883     0.200
     2.110    65.625     0.200
     1.932    61.992     0.200
     1.932    61.492     0.200
     1.975    62.133     0.200
     2.145    70.164     0.200
     1.675    54.750     0.200
     1.730    56.500     0.200
     1.747    57.797     0.200
     1.946    62.969     0.200
     2.055    63.406     0.200
     2.058    63.703     0.200
     1.302    44.492     0.200
     1.808    57.391     0.200
     2.178    66.430     0.200
     1.382    46.586     0.200
     1.682    54.375     0.200
     1.934    60.008     0.200
     1.891    60.781     0.200
     2.058    63.844     0.200
     1.819    59.090     0.200
     1.918    60.220     0.200
     2.031    66.190     0.200
     1.545    51.570     0.200
     1.877    60.550     0.200
     1.922    61.660     0.200
     1.837    57.940     0.200
     1.988    63.050     0.200
     2.103    66.110     0.200
     2.128    66.173     0.200
     3.180    91.393     0.200
     3.781   107.652     0.200
     1.357    45.683     0.200
     1.557    51.288     0.200
     1.839    58.278     0.200
     1.932    61.408     0.200
     1.328    45.156     0.200
     2.129    66.316     0.200
     1.406    47.245     0.200
     1.674    54.315     0.200
     1.689    54.885     0.200
     1.762    58.145     0.200
     1.917    60.605     0.200
     1.554    50.443     0.200
     1.824    57.094     0.200
     1.888    60.043     0.200
     1.932    61.254     0.200
     2.001    61.863     0.200
     2.114    65.404     0.200
     2.127    64.943     0.200
     1.659    54.090     0.200
     1.715    55.383     0.200
     1.733    55.980     0.200
     1.931    62.070     0.200
     2.087    64.531     0.200
     2.336    68.902     0.200
     2.481    73.570     0.200
     2.887    84.312     0.200
     2.932    85.531     0.200
     1.478    49.016     0.200
     1.823    57.855     0.200
     1.844    60.418     0.200
     1.993    62.266     0.200
     1.913    62.008     0.200
     2.095    65.426     0.200
     2.023    62.297     0.200
     2.177    67.117     0.200
     1.924    60.863     0.200
     1.928    60.875     0.200
     2.119    68.137     0.200
     2.121    64.664     0.200
     2.106    65.043     0.200
     2.181    66.863     0.200
     2.276    71.215     0.200
     1.737    56.797     0.200
     1.874    58.656     0.200
     2.111    65.750     0.200
     2.083    66.547     0.200
     3.226    92.840     0.200
     1.427    47.930     0.200
     1.746    56.078     0.200
     1.934    61.508     0.200
     1.892    59.422     0.200
     1.923    60.742     0.200
     2.032    62.711     0.200
     2.024    66.852     0.200
     2.131    68.633     0.200
     2.480    73.762     0.200
     1.365    46.289     0.200
     1.664    54.547     0.200
     1.869    59.039     0.200
     1.960    62.320     0.200
     2.109    63.703     0.200
     2.082    65.070     0.200
     1.249    42.916     0.200
     1.845    59.446     0.200
     2.081    64.570     0.200
     2.111    66.781     0.200
     1.699    55.211     0.200
     1.757    57.016     0.200
     1.876    58.316     0.200
     2.045    63.545     0.200
     2.155    67.295     0.200
     2.170    67.076     0.200
     2.228    69.346     0.200
     1.852    60.453     0.200
     2.014    62.562     0.200
     2.077    63.641     0.200
     2.122    66.211     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.235    39.068     0.200
     2.284    70.068     0.200
     2.332    68.688     0.200
     1.087    36.750     0.200
     1.757    54.176     0.200
     1.773    53.727     0.200
     1.845    55.746     0.200
     2.574    73.355     0.200
     1.293    39.988     0.200
     2.437    72.457     0.200
     2.550    74.117     0.200
     3.489    97.188     0.200
     3.570    99.129     0.200
     0.425    14.859     0.200
     0.439    14.648     0.200
     0.709    22.992     0.200
     1.188    37.922     0.200
     1.284    40.398     0.200
     1.672    51.523     0.200
     0.289     9.718     0.200
     0.335    12.168     0.200
     1.213    39.618     0.200
     1.548    48.168     0.200
     1.836    56.118     0.200
     2.401    71.238     0.200
     1.367    41.184     0.200
     1.676    50.781     0.200
     2.263    65.555     0.200
     0.216     7.559     0.200
     1.095    36.258     0.200
     1.223    39.660     0.200
     2.386    71.328     0.200
     0.293     9.891     0.200
     0.357    11.492     0.200
     1.039    34.789     0.200
     1.399    45.195     0.200
     1.500    47.391     0.200
     5.195   149.234     0.200
     0.328    11.375     0.200
     0.740    25.969     0.200
     1.027    35.359     0.200
     1.219    40.016     0.200
     2.276    68.641     0.200
     2.416    74.055     0.200
     0.291    10.516     0.200
     0.360    12.996     0.200
     2.376    69.977     0.200
     0.284    10.457     0.200
     0.577    19.918     0.200
     2.373    69.637     0.200
     2.394    70.000     0.200
     1.149    38.377     0.200
     0.854    29.953     0.200
     2.523    73.453     0.200
     1.220    40.512     0.200
     1.375    45.031     0.200
     1.785    55.102     0.200
     2.296    69.730     0.200
     2.652    77.801     0.200
     1.131    36.895     0.200
     1.343    43.645     0.200
     2.278    67.484     0.200
     1.373    43.047     0.200
     1.144    37.453     0.200
     1.323    42.711     0.200
     1.557    48.547     0.200
     2.302    68.539     0.200
     2.371    70.250     0.200
     2.511    73.023     0.200
     1.235    37.641     0.200
     2.405    71.914     0.200
     0.291    10.352     0.200
     1.008    33.180     0.200
     1.257    39.570     0.200
     2.447    73.500     0.200
     0.472    15.789     0.200
     2.288    67.641     0.200
     0.435    15.922     0.200
     0.456    15.352     0.200
     1.170    37.633     0.200
     2.303    67.562     0.200
     2.303    69.625     0.200
     2.792    81.305     0.200
     0.466    15.742     0.200
     1.162    37.570     0.200
     2.298    68.609     0.200
     2.536    75.633     0.200
     1.145    36.312     0.200
     2.286    69.023     0.200
     2.286    69.984     0.200
     2.800    84.004     0.200
     0.503    16.125     0.200
     1.144    37.703     0.200
     1.187    40.344     0.200
     0.655    23.180     0.200
     1.214    40.639     0.200
     1.470    47.570     0.200
     1.589    51.100     0.200
     2.295    70.199     0.200
     2.326    70.930     0.200
     0.643    23.430     0.200
     1.203    38.297     0.200
     2.155    63.273     0.200
     2.792    81.250     0.200
     0.388    12.797     0.200
     0.648    22.359     0.200
     0.880    29.078     0.200
     0.943    30.742     0.200
     1.021    32.312     0.200
     1.231    39.727     0.200
     1.235    39.375     0.200
     1.232    40.883     0.200
     1.418    44.578     0.200
     1.626    50.906     0.200
     1.807    54.859     0.200
     2.346    69.789     0.200
     2.238    67.367     0.200
     3.140    90.578     0.200
     0.216     8.770     0.200
     0.216     8.328     0.200
     0.447    16.059     0.200
     0.481    18.258     0.200
     0.758    25.410     0.200
     0.795    27.008     0.200
     0.968    30.590     0.200
     1.066    35.348     0.200
     1.149    36.371     0.200
     1.176    37.148     0.200
     1.352    41.590     0.200
     1.389    43.438     0.200
     1.584    47.988     0.200
     2.131    66.879     0.200
     2.534    73.328     0.200
     0.374    13.652     0.200
     0.770    25.742     0.200
     0.942    31.692     0.200
     1.185    38.752     0.200
     1.245    41.062     0.200
     1.614    50.482     0.200
     1.771    55.332     0.200
     2.255    68.872     0.200
     2.356    70.922     0.200
     0.312    11.454     0.200
     0.312    11.624     0.200
     0.534    18.113     0.200
     0.831    26.634     0.200
     0.850    28.964     0.200
     0.995    31.613     0.200
     1.245    39.094     0.200
     1.245    38.934     0.200
     1.320    41.284     0.200
     1.299    41.284     0.200
     2.417    70.693     0.200
     2.417    69.903     0.200
     2.564    75.363     0.200
     4.838   140.764     0.200
     5.236   152.483     0.200
     0.250     8.883     0.200
     0.356    12.264     0.200
     0.692    24.963     0.200
     0.787    26.094     0.200
     0.787    25.812     0.200
     0.888    30.193     0.200
     0.957    31.533     0.200
     0.957    31.424     0.200
     1.202    38.334     0.200
     1.202    38.533     0.200
     1.260    41.053     0.200
     1.260    41.193     0.200
     1.570    48.713     0.200
     2.374    69.973     0.200
     0.567    17.742     0.200
     0.549    18.293     0.200
     0.549    18.184     0.200
     0.605    21.014     0.200
     0.605    20.883     0.200
     0.829    28.322     0.200
     0.996    33.793     0.200
     1.029    34.162     0.200
     1.078    35.873     0.200
     1.122    37.434     0.200
     1.379    44.514     0.200
     1.369    44.473     0.200
     1.620    50.992     0.200
     1.757    54.953     0.200
     0.291     9.246     0.200
     0.351    11.916     0.200
     0.351    12.227     0.200
     0.592    21.637     0.200
     0.734    26.066     0.200
     0.863    30.207     0.200
     0.899    28.348     0.200
     0.937    31.098     0.200
     1.066    36.797     0.200
     1.198    39.486     0.200
     1.243    41.486     0.200
     1.515    48.896     0.200
     1.547    50.117     0.200
     1.562    49.537     0.200
     1.592    51.986     0.200
     1.670    52.986     0.200
     1.660    52.707     0.200
     1.690    53.797     0.200
     1.690    54.617     0.200
     1.816    57.566     0.200
     2.379    72.467     0.200
     2.385    74.256     0.200
     0.772    26.254     0.200
     0.982    32.055     0.200
     0.997    32.695     0.200
     1.070    34.516     0.200
     1.198    39.184     0.200
     1.267    41.434     0.200
     1.284    41.094     0.200
     1.292    41.305     0.200
     2.325    68.953     0.200
     0.237     8.766     0.200
     0.325    11.781     0.200
     0.576    21.445     0.200
     0.537    17.633     0.200
     0.680    24.633     0.200
     0.791    26.883     0.200
     0.818    26.852     0.200
     0.860    29.242     0.200
     0.983    32.305     0.200
     1.065    34.531     0.200
     1.156    38.031     0.200
     1.182    36.734     0.200
     1.182    36.945     0.200
     1.232    39.195     0.200
     1.232    38.977     0.200
     1.288    41.227     0.200
     1.534    47.883     0.200
     1.583    48.914     0.200
     2.310    68.008     0.200
     2.405    70.766     0.200
     0.195     6.635     0.200
     0.412    14.371     0.200
     0.412    14.504     0.200
     0.765    25.615     0.200
     0.765    26.145     0.200
     0.909    30.475     0.200
     0.970    32.674     0.200
     0.982    32.844     0.200
     0.982    33.055     0.200
     1.190    38.635     0.200
     1.190    38.822     0.200
     1.258    40.973     0.200
     1.266    41.771     0.200
     1.278    42.555     0.200
     1.389    45.594     0.200
     1.303    42.074     0.200
     1.655    52.545     0.200
     2.326    70.725     0.200
     2.326    70.059     0.200
     2.691    78.947     0.200
     0.379    12.652     0.200
     1.058    35.662     0.200
     1.254    41.861     0.200
     1.253    41.871     0.200
     1.303    42.742     0.200
     1.352    45.861     0.200
     2.367    71.352     0.200
     0.432    13.082     0.200
     0.759    25.303     0.200
     0.938    31.043     0.200
     0.997    32.463     0.200
     0.988    32.682     0.200
     1.081    35.172     0.200
     1.185    39.533     0.200
     1.204    38.803     0.200
     1.295    41.773     0.200
     1.282    42.463     0.200
     1.403    46.422     0.200
     1.685    53.312     0.200
     1.735    55.033     0.200
     2.310    71.553     0.200
     0.161     5.639     0.200
     0.405    13.508     0.200
     0.421    14.600     0.200
     0.421    14.598     0.200
     0.685    24.768     0.200
     0.786    26.889     0.200
     0.786    26.598     0.200
     0.935    31.479     0.200
     1.018    33.809     0.200
     1.213    38.947     0.200
     1.213    40.092     0.200
     1.228    39.508     0.200
     1.271    41.576     0.200
     1.312    42.568     0.200
     1.433    46.197     0.200
     1.687    53.299     0.200
     0.425    14.090     0.200
     0.677    21.980     0.200
     0.721    24.410     0.200
     0.881    28.758     0.200
     0.910    30.270     0.200
     1.139    36.691     0.200
     1.256    40.559     0.200
     1.210    40.039     0.200
     1.613    51.059     0.200
     1.658    52.629     0.200
     1.652    53.211     0.200
     1.724    53.738     0.200
     2.304    70.020     0.200
     0.218     8.070     0.200
     0.372    12.949     0.200
     0.372    13.188     0.200
     0.494    16.891     0.200
     0.494    16.207     0.200
     0.501    17.359     0.200
     0.501    16.105     0.200
     0.629    23.160     0.200
     0.658    23.848     0.200
     0.693    22.695     0.200
     0.781    25.738     0.200
     0.852    27.188     0.200
     0.987    32.430     0.200
     0.970    31.508     0.200
     0.970    31.793     0.200
     1.048    33.285     0.200
     1.124    36.570     0.200
     1.201    37.488     0.200
     1.204    38.980     0.200
     1.211    39.773     0.200
     1.200    38.688     0.200
     1.200    38.461     0.200
     1.243    39.148     0.200
     1.271    40.988     0.200
     1.384    43.051     0.200
     1.594    49.891     0.200
     1.681    51.668     0.200
     1.887    56.938     0.200
     2.264    67.598     0.200
     2.264    68.066     0.200
     2.634    77.246     0.200
     2.871    83.203     0.200
     0.319    11.273     0.200
     0.546    17.988     0.200
     0.546    17.863     0.200
     0.568    18.224     0.200
     0.568    18.610     0.200
     0.607    20.773     0.200
     0.737    23.934     0.200
     0.737    23.706     0.200
     0.830    28.043     0.200
     1.031    33.474     0.200
     1.099    36.980     0.200
     1.122    36.303     0.200
     1.122    36.833     0.200
     1.624    51.163     0.200
     1.624    51.621     0.200
     1.612    52.083     0.200
     1.612    51.879     0.200
     1.631    52.072     0.200
     1.673    53.545     0.200
     1.712    53.273     0.200
     1.753    54.693     0.200
     0.373    13.062     0.200
     0.373    12.988     0.200
     0.492    16.746     0.200
     0.520    17.336     0.200
     0.675    21.887     0.200
     0.675    21.723     0.200
     0.775    25.887     0.200
     0.957    31.355     0.200
     0.957    31.508     0.200
     1.060    33.559     0.200
     1.111    35.785     0.200
     1.111    35.523     0.200
     1.189    38.250     0.200
     1.192    38.195     0.200
     1.259    40.785     0.200
     1.288    41.059     0.200
     1.288    40.844     0.200
     2.255    66.797     0.200
     2.255    67.086     0.200
     0.214     8.797     0.200
     0.357    12.926     0.200
     0.357    13.188     0.200
     0.509    16.488     0.200
     0.502    17.219     0.200
     0.502    16.867     0.200
     0.502    17.012     0.200
     0.688    21.656     0.200
     0.688    21.242     0.200
     0.795    25.559     0.200
     0.980    31.227     0.200
     0.980    30.914     0.200
     0.977    30.137     0.200
     1.060    33.188     0.200
     1.060    33.320     0.200
     1.130    35.207     0.200
     1.130    35.492     0.200
     1.191    36.969     0.200
     1.194    38.234     0.200
     1.214    37.867     0.200
     1.214    38.160     0.200
     1.282    40.707     0.200
     1.299    40.809     0.200
     1.299    40.641     0.200
     1.374    42.520     0.200
     2.096    63.996     0.200
     2.277    66.738     0.200
     2.277    66.562     0.200
     2.349    68.539     0.200
     0.384    13.195     0.200
     0.384    13.172     0.200
     0.490    16.117     0.200
     0.588    18.578     0.200
     0.588    18.961     0.200
     0.611    20.039     0.200
     0.757    24.984     0.200
     0.911    30.445     0.200
     0.911    30.594     0.200
     1.043    34.047     0.200
     1.105    35.289     0.200
     1.134    35.828     0.200
     1.136    36.000     0.200
     1.166    37.945     0.200
     1.166    38.336     0.200
     1.216    40.359     0.200
     1.303    42.203     0.200
     1.541    47.867     0.200
     1.586    49.008     0.200
     1.713    53.758     0.200
     2.224    67.062     0.200
     2.264    67.375     0.200
     2.686    78.180     0.200
     0.291    10.348     0.200
     0.367    12.926     0.200
     0.506    16.688     0.200
     0.583    18.867     0.200
     0.610    19.768     0.200
     0.734    26.117     0.200
     0.800    26.426     0.200
     0.926    30.246     0.200
     1.050    33.627     0.200
     1.114    34.967     0.200
     1.183    37.326     0.200
     1.300    42.316     0.200
     1.231    40.018     0.200
     1.317    41.957     0.200
     1.531    47.207     0.200
     1.577    48.156     0.200
     1.705    52.707     0.200
     2.241    67.146     0.200
     2.274    67.367     0.200
     0.456    14.789     0.200
     0.456    14.526     0.200
     0.427    14.859     0.200
     0.427    14.889     0.200
     0.452    16.386     0.200
     0.688    25.189     0.200
     0.758    23.929     0.200
     0.921    31.139     0.200
     0.976    31.099     0.200
     0.976    31.262     0.200
     0.971    32.439     0.200
     0.971    32.969     0.200
     1.058    35.609     0.200
     1.176    39.059     0.200
     1.225    40.009     0.200
     1.273    41.917     0.200
     1.272    41.369     0.200
     1.275    41.733     0.200
     1.314    42.239     0.200
     1.382    45.829     0.200
     1.382    45.702     0.200
     1.677    52.729     0.200
     1.677    53.019     0.200
     1.666    52.959     0.200
     1.715    54.269     0.200
     2.373    73.429     0.200
     2.373    72.738     0.200
     0.198     8.488     0.200
     0.377    12.830     0.200
     0.377    13.357     0.200
     0.377    13.639     0.200
     0.493    16.318     0.200
     0.477    15.539     0.200
     0.477    16.408     0.200
     0.637    22.389     0.200
     0.718    22.578     0.200
     0.718    22.418     0.200
     0.785    25.338     0.200
     0.785    25.559     0.200
     0.868    28.799     0.200
     0.931    30.818     0.200
     0.985    31.459     0.200
     0.985    31.314     0.200
     1.009    30.648     0.200
     1.029    32.459     0.200
     1.029    32.289     0.200
     1.207    38.086     0.200
     1.207    37.408     0.200
     1.224    37.678     0.200
     1.221    39.307     0.200
     1.221    38.889     0.200
     1.262    39.898     0.200
     1.284    40.938     0.200
     1.276    40.320     0.200
     1.276    40.129     0.200
     2.129    64.461     0.200
     2.272    66.664     0.200
     2.366    70.869     0.200
     2.503    73.309     0.200
     2.772    78.715     0.200
     2.891    81.973     0.200
     2.851    80.588     0.200
     3.051    85.879     0.200
     0.181     6.426     0.200
     0.442    15.047     0.200
     0.403    13.785     0.200
     0.403    14.355     0.200
     0.403    14.637     0.200
     0.479    16.328     0.200
     0.666    24.438     0.200
     0.778    26.105     0.200
     0.778    25.578     0.200
     0.760    24.273     0.200
     0.906    29.559     0.200
     0.989    31.316     0.200
     0.989    30.809     0.200
     0.989    30.648     0.200
     0.965    31.566     0.200
     0.965    32.539     0.200
     0.996    32.598     0.200
     1.052    34.559     0.200
     1.052    34.379     0.200
     1.203    38.332     0.200
     1.203    38.598     0.200
     1.172    38.445     0.200
     1.248    40.488     0.200
     1.248    40.387     0.200
     1.248    40.207     0.200
     1.251    41.430     0.200
     1.292    41.355     0.200
     1.266    40.598     0.200
     1.269    41.082     0.200
     1.302    42.438     0.200
     1.368    44.559     0.200
     1.449    46.629     0.200
     1.654    51.855     0.200
     1.728    53.617     0.200
     1.744    54.105     0.200
     1.796    55.387     0.200
     2.270    68.613     0.200
     2.336    70.270     0.200
     2.392    71.789     0.200
     2.392    71.988     0.200
     0.212     8.400     0.200
     0.381    13.078     0.200
     0.381    13.280     0.200
     0.381    13.640     0.200
     0.491    16.370     0.200
     0.491    16.132     0.200
     0.487    16.410     0.200
     0.639    21.710     0.200
     0.650    23.520     0.200
     0.706    22.380     0.200
     0.706    22.485     0.200
     0.777    25.660     0.200
     0.930    30.420     0.200
     0.972    31.360     0.200
     1.001    30.850     0.200
     1.035    32.500     0.200
     1.141    36.190     0.200
     1.141    36.400     0.200
     1.141    36.297     0.200
     1.197    38.160     0.200
     1.215    37.370     0.200
     1.222    39.398     0.200
     1.222    39.010     0.200
     1.217    38.797     0.200
     1.256    40.230     0.200
     1.274    40.340     0.200
     1.274    40.000     0.200
     1.274    40.233     0.200
     1.272    40.700     0.200
     2.121    66.198     0.200
     2.223    69.202     0.200
     2.262    66.496     0.200
     2.350    68.340     0.200
     2.350    68.594     0.200
     2.646    75.709     0.200
     2.759    78.750     0.200
     2.759    78.493     0.200
     2.884    82.541     0.200
     3.037    86.480     0.200
     0.449    15.537     0.200
     0.485    15.908     0.200
     0.485    16.188     0.200
     0.491    16.168     0.200
     0.516    17.238     0.200
     0.516    17.129     0.200
     0.677    22.477     0.200
     0.717    23.838     0.200
     0.717    24.037     0.200
     0.802    25.758     0.200
     0.781    25.762     0.200
     0.851    28.887     0.200
     0.851    28.773     0.200
     0.851    28.998     0.200
     1.011    32.547     0.200
     1.014    32.500     0.200
     1.091    35.234     0.200
     1.230    39.098     0.200
     1.230    39.227     0.200
     1.342    42.820     0.200
     1.406    46.295     0.200
     1.406    45.627     0.200
     1.452    45.137     0.200
     1.484    47.646     0.200
     1.602    50.658     0.200
     1.587    51.078     0.200
     1.587    50.920     0.200
     1.931    60.182     0.200
     2.353    73.137     0.200
     2.528    74.963     0.200
     3.639   104.787     0.200
     0.370    12.842     0.200
     0.370    13.081     0.200
     0.499    16.304     0.200
     0.499    16.892     0.200
     0.567    17.937     0.200
     0.567    18.071     0.200
     0.616    21.111     0.200
     0.770    25.331     0.200
     0.814    26.271     0.200
     0.932    30.690     0.200
     0.932    30.491     0.200
     1.066    34.266     0.200
     1.097    34.564     0.200
     1.097    33.731     0.200
     1.145    35.121     0.200
     1.147    36.917     0.200
     1.192    39.146     0.200
     1.192    38.491     0.200
     1.182    38.287     0.200
     1.182    38.182     0.200
     1.197    37.171     0.200
     1.311    42.851     0.200
     1.311    42.231     0.200
     1.236    39.361     0.200
     1.306    41.857     0.200
     1.306    41.102     0.200
     1.547    47.722     0.200
     2.242    66.880     0.200
     2.272    70.602     0.200
     2.287    67.409     0.200
     2.287    67.262     0.200
     2.362    69.701     0.200
     2.362    69.451     0.200
     2.708    77.901     0.200
     0.269     9.082     0.200
     0.269     8.988     0.200
     0.512    17.391     0.200
     0.577    17.547     0.200
     0.577    17.898     0.200
     0.603    20.141     0.200
     0.603    19.918     0.200
     0.866    28.430     0.200
     0.871    29.488     0.200
     1.011    33.258     0.200
     1.011    33.918     0.200
     1.080    35.309     0.200
     1.082    34.965     0.200
     1.076    35.406     0.200
     1.076    35.719     0.200
     1.112    35.852     0.200
     1.178    37.590     0.200
     1.366    45.164     0.200
     1.366    45.352     0.200
     1.279    42.324     0.200
     1.279    41.219     0.200
     1.318    43.441     0.200
     1.408    45.898     0.200
     1.408    45.520     0.200
     1.464    45.430     0.200
     1.647    52.852     0.200
     2.366    75.324     0.200
     2.335    71.016     0.200
     2.335    72.102     0.200
     2.327    71.324     0.200
     2.327    72.281     0.200
     2.465    74.543     0.200
     2.465    75.570     0.200
     2.502    74.930     0.200
     2.692    80.367     0.200
     3.011    87.984     0.200
     3.011    88.699     0.200
     3.281    95.230     0.200
     0.446    13.906     0.200
     0.438    14.570     0.200
     0.438    15.164     0.200
     0.446    15.648     0.200
     0.747    25.648     0.200
     0.936    31.258     0.200
     0.961    30.930     0.200
     0.974    32.766     0.200
     0.974    32.117     0.200
     1.173    38.500     0.200
     1.214    39.789     0.200
     1.214    39.336     0.200
     1.190    39.211     0.200
     1.288    41.836     0.200
     1.290    42.188     0.200
     1.388    45.789     0.200
     1.330    42.586     0.200
     1.681    53.328     0.200
     1.749    55.562     0.200
     1.749    55.758     0.200
     2.302    69.227     0.200
     2.302    70.008     0.200
     2.380    72.703     0.200
     0.265     9.820     0.200
     0.471    17.867     0.200
     0.495    16.719     0.200
     0.589    19.938     0.200
     0.589    20.305     0.200
     0.589    19.719     0.200
     0.766    24.945     0.200
     0.766    24.391     0.200
     0.766    24.125     0.200
     0.808    25.844     0.200
     0.849    29.125     0.200
     0.849    28.688     0.200
     1.116    35.945     0.200
     1.123    36.180     0.200
     1.123    36.383     0.200
     1.132    36.164     0.200
     1.132    36.055     0.200
     1.237    39.586     0.200
     1.237    39.352     0.200
     1.237    39.203     0.200
     1.305    40.953     0.200
     1.305    40.531     0.200
     1.420    44.789     0.200
     1.431    45.227     0.200
     1.431    45.492     0.200
     1.483    45.758     0.200
     1.483    45.242     0.200
     1.539    47.758     0.200
     2.418    72.773     0.200
     0.497    16.656     0.200
     0.497    17.000     0.200
     0.534    18.922     0.200
     0.601    19.836     0.200
     0.601    19.633     0.200
     0.681    22.117     0.200
     0.842    28.344     0.200
     0.939    31.102     0.200
     0.939    31.508     0.200
     0.968    32.117     0.200
     0.968    32.352     0.200
     1.004    31.492     0.200
     1.090    36.812     0.200
     1.272    42.344     0.200
     1.239    38.961     0.200
     1.234    40.289     0.200
     1.423    44.484     0.200
     1.498    49.133     0.200
     2.462    74.031     0.200
     2.450    76.016     0.200
     2.450    75.305     0.200
     0.355    12.430     0.200
     0.371    13.383     0.200
     0.371    13.301     0.200
     0.539    17.539     0.200
     0.539    17.949     0.200
     0.533    17.406     0.200
     0.652    20.793     0.200
     0.780    26.051     0.200
     0.780    25.730     0.200
     0.797    28.078     0.200
     0.847    28.379     0.200
     0.899    29.820     0.200
     0.983    32.148     0.200
     0.983    31.859     0.200
     0.983    32.031     0.200
     1.065    33.309     0.200
     1.253    40.609     0.200
     1.253    41.379     0.200
     1.156    37.504     0.200
     1.206    39.129     0.200
     1.353    43.176     0.200
     1.643    50.531     0.200
     2.219    66.602     0.200
     2.229    67.125     0.200
     2.336    68.500     0.200
     2.385    71.074     0.200
     2.385    70.480     0.200
     2.419    71.086     0.200
     2.531    74.434     0.200
     3.249    93.203     0.200
     0.134     6.402     0.200
     0.310    10.220     0.200
     0.459    15.368     0.200
     0.516    17.322     0.200
     0.516    17.451     0.200
     0.895    28.361     0.200
     0.897    28.205     0.200
     1.091    35.456     0.200
     1.220    39.087     0.200
     1.259    40.300     0.200
     1.307    42.057     0.200
     1.326    41.895     0.200
     1.390    43.965     0.200
     2.284    67.551     0.200
     2.326    68.595     0.200
     2.338    68.890     0.200
     2.514    72.979     0.200
     2.774    79.069     0.200
     2.999    85.176     0.200
     0.392    13.531     0.200
     0.449    14.336     0.200
     0.487    16.773     0.200
     0.749    24.492     0.200
     0.997    32.945     0.200
     1.183    38.711     0.200
     1.209    39.480     0.200
     1.259    40.750     0.200
     1.256    40.961     0.200
     1.401    46.117     0.200
     1.705    53.535     0.200
     2.346    69.949     0.200
     2.675    78.820     0.200
     2.919    85.219     0.200
     0.311    10.159     0.200
     0.311    10.266     0.200
     0.463    15.855     0.200
     0.463    16.029     0.200
     0.512    17.600     0.200
     0.726    24.430     0.200
     0.826    27.039     0.200
     0.894    28.155     0.200
     0.896    28.799     0.200
     1.001    32.839     0.200
     1.042    34.060     0.200
     1.089    35.640     0.200
     1.176    36.899     0.200
     1.216    38.909     0.200
     1.256    40.409     0.200
     1.310    42.039     0.200
     1.376    44.759     0.200
     1.407    45.039     0.200
     1.608    49.229     0.200
     1.608    49.628     0.200
     1.761    53.930     0.200
     2.286    69.527     0.200
     2.323    68.779     0.200
     2.334    69.009     0.200
     0.320    10.546     0.200
     0.461    15.434     0.200
     0.506    17.350     0.200
     0.887    28.877     0.200
     0.897    27.851     0.200
     1.080    35.428     0.200
     1.214    39.063     0.200
     1.249    40.052     0.200
     1.316    41.673     0.200
     1.611    49.786     0.200
     2.280    69.821     0.200
     0.315    10.656     0.200
     0.315    10.482     0.200
     0.460    16.299     0.200
     0.460    16.047     0.200
     0.511    17.605     0.200
     0.723    25.637     0.200
     0.723    24.605     0.200
     0.824    27.365     0.200
     0.824    27.115     0.200
     0.891    28.775     0.200
     0.891    28.967     0.200
     0.881    30.256     0.200
     0.897    28.057     0.200
     0.897    27.869     0.200
     0.997    31.936     0.200
     1.039    33.877     0.200
     1.086    35.627     0.200
     1.171    36.977     0.200
     1.217    38.986     0.200
     1.217    39.244     0.200
     1.254    40.297     0.200
     1.254    40.652     0.200
     1.321    41.586     0.200
     1.321    42.176     0.200
     1.308    42.137     0.200
     1.374    43.707     0.200
     1.385    42.855     0.200
     1.387    44.201     0.200
     1.611    49.379     0.200
     2.214    66.916     0.200
     2.282    68.105     0.200
     2.282    67.537     0.200
     2.321    68.299     0.200
     2.335    69.566     0.200
     2.335    68.564     0.200
     2.442    75.449     0.200
     2.509    73.795     0.200
     3.037    86.807     0.200
     3.229    96.801     0.200
     0.305     9.975     0.200
     0.353    11.645     0.200
     0.516    17.266     0.200
     0.516    17.055     0.200
     0.520    19.256     0.200
     0.607    19.545     0.200
     0.701    25.045     0.200
     0.773    26.916     0.200
     0.992    32.693     0.200
     1.081    36.965     0.200
     1.081    37.131     0.200
     1.296    42.859     0.200
     1.231    38.949     0.200
     1.250    40.287     0.200
     1.426    44.910     0.200
     2.249    71.107     0.200
     0.403    13.852     0.200
     0.403    13.854     0.200
     0.444    13.646     0.200
     0.479    16.473     0.200
     0.665    23.484     0.200
     0.758    24.820     0.200
     0.964    31.754     0.200
     0.990    31.246     0.200
     0.994    32.884     0.200
     0.994    33.178     0.200
     1.050    33.574     0.200
     1.188    38.594     0.200
     1.250    39.732     0.200
     1.203    39.108     0.200
     1.249    39.804     0.200
     1.249    40.207     0.200
     1.264    40.194     0.200
     1.267    40.397     0.200
     1.300    39.534     0.200
     1.281    41.824     0.200
     1.401    45.444     0.200
     1.652    50.624     0.200
     2.336    69.154     0.200
     2.336    69.445     0.200
     2.930    84.514     0.200
     0.353    12.002     0.200
     0.605    19.705     0.200
     0.849    27.812     0.200
     0.913    30.713     0.200
     1.002    31.953     0.200
     1.144    38.125     0.200
     1.330    41.213     0.200
     1.330    41.836     0.200
     1.341    42.613     0.200
     1.341    43.439     0.200
     1.440    46.863     0.200
     1.718    53.908     0.200
     1.930    58.934     0.200
     2.408    70.943     0.200
     2.443    71.814     0.200
     0.265     9.128     0.200
     0.342    11.077     0.200
     0.422    14.858     0.200
     0.422    14.557     0.200
     0.588    19.809     0.200
     0.588    19.488     0.200
     0.588    18.978     0.200
     0.736    24.778     0.200
     0.776    24.168     0.200
     0.776    24.748     0.200
     0.852    29.468     0.200
     0.961    30.718     0.200
     0.961    30.600     0.200
     1.038    34.408     0.200
     1.038    33.768     0.200
     1.089    35.208     0.200
     1.089    35.028     0.200
     1.089    35.747     0.200
     1.116    35.818     0.200
     1.116    35.418     0.200
     1.166    37.658     0.200
     1.166    37.968     0.200
     1.166    38.122     0.200
     1.165    36.758     0.200
     1.267    40.198     0.200
     1.267    40.078     0.200
     1.313    42.038     0.200
     1.351    43.028     0.200
     1.373    44.598     0.200
     1.398    44.758     0.200
     1.437    45.068     0.200
     1.437    46.160     0.200
     1.481    46.647     0.200
     1.517    48.228     0.200
     1.664    51.278     0.200
     2.213    66.518     0.200
     2.213    66.372     0.200
     2.229    66.478     0.200
     2.338    69.695     0.200
     2.387    70.378     0.200
     2.387    71.706     0.200
     2.495    73.938     0.200
     2.495    74.126     0.200
     2.512    74.094     0.200
     2.896    83.609     0.200
     3.178    90.792     0.200
     3.199    91.604     0.200
     0.302    10.023     0.200
     0.346    12.217     0.200
     0.346    10.883     0.200
     0.534    16.924     0.200
     0.534    17.742     0.200
     0.586    19.883     0.200
     0.600    18.809     0.200
     0.796    26.992     0.200
     0.850    29.043     0.200
     0.936    30.990     0.200
     1.036    34.074     0.200
     1.100    34.932     0.200
     1.154    37.764     0.200
     1.145    35.816     0.200
     1.301    43.393     0.200
     1.202    39.539     0.200
     1.347    41.951     0.200
     1.779    55.596     0.200
     2.258    69.244     0.200
     2.394    72.461     0.200
     0.352    11.617     0.200
     0.439    15.504     0.200
     0.439    15.898     0.200
     0.525    17.270     0.200
     0.525    17.164     0.200
     0.753    25.105     0.200
     0.842    26.867     0.200
     0.842    27.539     0.200
     0.789    27.457     0.200
     0.903    28.570     0.200
     1.030    34.016     0.200
     1.030    34.152     0.200
     1.050    34.574     0.200
     1.142    35.977     0.200
     1.142    37.629     0.200
     1.100    36.234     0.200
     1.183    38.355     0.200
     1.375    43.891     0.200
     1.420    45.324     0.200
     1.450    46.504     0.200
     1.552    48.035     0.200
     2.321    68.496     0.200
     2.321    71.621     0.200
     2.471    75.305     0.200
     0.463    15.117     0.200
     0.463    15.188     0.200
     0.487    16.969     0.200
     0.487    17.141     0.200
     0.498    16.750     0.200
     0.498    16.641     0.200
     0.738    24.188     0.200
     0.714    24.266     0.200
     0.831    26.641     0.200
     0.802    26.695     0.200
     0.893    30.516     0.200
     0.893    30.695     0.200
     1.042    33.242     0.200
     1.045    33.602     0.200
     1.150    38.875     0.200
     1.098    35.719     0.200
     1.098    35.555     0.200
     1.212    41.289     0.200
     1.212    41.023     0.200
     1.196    37.727     0.200
     1.476    45.320     0.200
     1.448    47.406     0.200
     1.525    50.125     0.200
     1.630    51.500     0.200
     1.607    52.617     0.200
     1.781    55.352     0.200
     2.326    72.562     0.200
     2.326    72.258     0.200
     2.547    76.906     0.200
     0.418    14.906     0.200
     0.550    19.020     0.200
     0.550    19.125     0.200
     0.550    18.977     0.200
     0.733    24.773     0.200
     0.915    31.035     0.200
     0.915    28.156     0.200
     0.915    28.730     0.200
     1.018    34.086     0.200
     1.018    33.398     0.200
     1.072    35.145     0.200
     1.116    36.406     0.200
     1.116    36.027     0.200
     1.163    37.414     0.200
     1.163    38.227     0.200
     1.163    38.023     0.200
     1.310    42.996     0.200
     1.298    42.684     0.200
     1.400    45.184     0.200
     1.437    46.270     0.200
     1.472    45.895     0.200
     1.528    48.504     0.200
     1.879    58.137     0.200
     2.340    72.246     0.200
     2.340    72.684     0.200
     2.385    71.340     0.200
     2.559    75.441     0.200
     3.197    92.656     0.200
     0.265     9.531     0.200
     0.343    11.081     0.200
     0.524    17.171     0.200
     0.643    20.721     0.200
     0.643    20.831     0.200
     0.772    27.331     0.200
     0.738    26.081     0.200
     0.788    25.671     0.200
     0.788    26.131     0.200
     0.894    30.062     0.200
     1.044    35.481     0.200
     1.002    32.741     0.200
     1.041    32.331     0.200
     1.041    33.331     0.200
     0.999    33.421     0.200
     1.014    33.891     0.200
     1.172    39.131     0.200
     1.291    41.111     0.200
     1.308    42.581     0.200
     1.392    43.431     0.200
     1.441    45.031     0.200
     1.572    48.321     0.200
     1.590    48.491     0.200
     2.279    72.221     0.200
     0.350    12.469     0.200
     0.350    12.375     0.200
     0.516    16.570     0.200
     0.644    20.523     0.200
     0.644    20.711     0.200
     0.694    24.930     0.200
     0.792    26.273     0.200
     0.881    29.750     0.200
     0.959    31.109     0.200
     1.089    34.516     0.200
     1.089    34.695     0.200
     1.151    35.117     0.200
     1.154    36.539     0.200
     1.206    38.133     0.200
     1.263    40.477     0.200
     1.334    41.617     0.200
     1.843    55.266     0.200
     2.267    67.000     0.200
     2.267    67.148     0.200
     2.277    66.898     0.200
     2.380    69.430     0.200
     2.380    69.867     0.200
     2.436    71.898     0.200
     2.436    72.211     0.200
     2.590    75.594     0.200
     0.366    12.797     0.200
     0.366    12.617     0.200
     0.501    16.695     0.200
     0.634    20.398     0.200
     0.775    25.977     0.200
     0.890    30.422     0.200
     0.939    31.172     0.200
     0.939    31.359     0.200
     0.934    31.086     0.200
     1.073    34.820     0.200
     1.095    34.445     0.200
     1.095    34.281     0.200
     1.188    38.250     0.200
     1.184    38.906     0.200
     1.199    37.695     0.200
     1.307    41.766     0.200
     1.332    42.570     0.200
     1.703    53.062     0.200
     2.248    67.203     0.200
     2.271    68.180     0.200
     2.295    69.367     0.200
     2.365    70.742     0.200
     2.596    75.922     0.200
     2.824    81.664     0.200
     0.318    11.109     0.200
     0.318    11.844     0.200
     0.467    16.742     0.200
     0.524    18.023     0.200
     0.524    17.781     0.200
     0.782    26.258     0.200
     0.787    26.773     0.200
     0.787    27.242     0.200
     0.927    30.008     0.200
     0.927    29.219     0.200
     1.154    35.648     0.200
     1.154    36.375     0.200
     1.212    38.523     0.200
     1.220    38.500     0.200
     1.461    44.312     0.200
     2.002    56.953     0.200
     0.266     9.082     0.200
     0.593    19.542     0.200
     0.583    20.521     0.200
     0.662    22.172     0.200
     0.830    27.352     0.200
     0.882    29.731     0.200
     0.909    30.691     0.200
     0.917    31.302     0.200
     1.474    48.021     0.200
     1.499    49.092     0.200
     0.385    12.785     0.200
     0.482    16.715     0.200
     0.702    22.684     0.200
     0.771    24.973     0.200
     0.932    29.473     0.200
     0.965    32.133     0.200
     0.999    33.004     0.200
     1.135    36.875     0.200
     1.191    38.684     0.200
     1.235    40.453     0.200
     1.656    51.945     0.200
     1.687    53.074     0.200
     1.787    55.742     0.200
     2.256    68.594     0.200
     2.345    69.883     0.200
     0.376    12.986     0.200
     0.438    14.855     0.200
     0.497    16.776     0.200
     0.761    25.526     0.200
     0.751    24.826     0.200
     0.866    27.286     0.200
     1.016    32.625     0.200
     1.014    32.766     0.200
     1.069    35.105     0.200
     1.166    37.396     0.200
     1.163    37.006     0.200
     1.181    37.956     0.200
     1.301    41.526     0.200
     1.347    43.166     0.200
     1.415    44.585     0.200
     1.767    53.936     0.200
     2.248    66.835     0.200
     2.285    67.556     0.200
     2.271    67.706     0.200
     2.446    71.196     0.200
     2.505    72.416     0.200
     0.407    14.703     0.200
     0.407    14.219     0.200
     0.568    19.125     0.200
     0.693    22.016     0.200
     0.807    25.359     0.200
     0.845    28.008     0.200
     0.842    27.898     0.200
     0.993    29.422     0.200
     1.009    33.688     0.200
     1.209    38.547     0.200
     1.492    45.273     0.200
     0.209     8.695     0.200
     0.465    16.836     0.200
     0.540    18.766     0.200
     0.640    23.416     0.200
     0.703    24.906     0.200
     0.759    26.137     0.200
     0.966    32.797     0.200
     1.048    33.717     0.200
     0.911    30.965     0.200
     0.911    30.836     0.200
     0.968    32.457     0.200
     0.968    32.734     0.200
     1.004    32.797     0.200
     1.060    34.434     0.200
     1.060    35.035     0.200
     1.201    38.816     0.200
     1.293    41.887     0.200
     1.293    41.477     0.200
     1.308    42.355     0.200
     1.308    41.266     0.200
     1.457    45.875     0.200
     0.413    15.281     0.200
     0.678    24.699     0.200
     0.917    30.590     0.200
     0.917    31.012     0.200
     0.977    32.602     0.200
     0.990    32.629     0.200
     1.061    34.949     0.200
     1.061    34.730     0.200
     1.263    40.551     0.200
     1.313    42.262     0.200
     1.313    41.250     0.200
     1.282    41.789     0.200
     1.282    42.000     0.200
     1.282    41.039     0.200
     1.459    46.129     0.200
     1.532    48.480     0.200
     1.665    51.961     0.200
     1.681    51.770     0.200
     0.524    16.895     0.200
     0.680    21.965     0.200
     0.770    25.924     0.200
     0.784    24.273     0.200
     0.784    25.193     0.200
     0.948    31.613     0.200
     0.973    32.164     0.200
     1.053    33.424     0.200
     1.150    37.994     0.200
     1.123    37.023     0.200
     1.182    37.693     0.200
     1.244    40.504     0.200
     1.244    40.193     0.200
     1.291    42.504     0.200
     1.402    43.895     0.200
     1.500    48.984     0.200
     1.574    48.113     0.200
     2.459    72.725     0.200
     0.262    10.914     0.200
     0.800    27.074     0.200
     0.826    26.953     0.200
     0.826    26.844     0.200
     1.083    34.066     0.200
     1.083    34.203     0.200
     1.118    35.645     0.200
     1.119    35.086     0.200
     1.119    35.316     0.200
     1.261    38.715     0.200
     1.261    38.996     0.200
     1.256    39.695     0.200
     1.491    44.523     0.200
     1.689    49.633     0.200
     0.813    25.910     0.200
     0.908    31.367     0.200
     0.997    31.980     0.200
     1.329    41.469     0.200
     1.466    47.328     0.200
     1.660    51.980     0.200
     1.686    52.379     0.200
     1.793    56.480     0.200
     0.709    22.585     0.200
     0.754    24.515     0.200
     0.754    24.745     0.200
     0.862    28.655     0.200
     0.945    32.265     0.200
     0.948    31.855     0.200
     0.948    32.135     0.200
     1.106    37.655     0.200
     1.249    40.655     0.200
     1.249    40.875     0.200
     1.254    41.335     0.200
     1.348    45.045     0.200
     1.375    42.855     0.200
     1.419    44.795     0.200
     1.419    46.345     0.200
     1.472    48.515     0.200
     1.538    48.995     0.200
     1.546    50.045     0.200
     2.472    74.255     0.200
     2.647    79.775     0.200
     3.745   107.035     0.200
     0.592    18.289     0.200
     0.803    27.117     0.200
     0.886    28.605     0.200
     0.946    32.176     0.200
     1.044    35.117     0.200
     1.151    37.059     0.200
     1.169    39.289     0.200
     1.210    39.809     0.200
     1.252    41.367     0.200
     1.501    47.168     0.200
     1.547    49.129     0.200
     1.837    56.918     0.200
     2.399    71.988     0.200
     0.586    17.628     0.200
     0.796    27.528     0.200
     0.897    28.998     0.200
     0.943    32.148     0.200
     1.050    34.948     0.200
     1.161    36.858     0.200
     1.171    38.878     0.200
     1.204    39.368     0.200
     1.511    47.388     0.200
     1.558    48.928     0.200
     1.593    51.578     0.200
     2.391    72.088     0.200
     0.292    10.715     0.200
     0.292    10.965     0.200
     0.889    28.812     0.200
     1.149    35.312     0.200
     1.149    35.414     0.200
     1.139    36.324     0.200
     1.340    42.402     0.200
     1.340    42.633     0.200
     1.319    41.895     0.200
     1.367    42.793     0.200
     1.541    47.094     0.200
     1.720    52.023     0.200
     2.251    68.113     0.200
     2.403    69.434     0.200
     0.496    17.426     0.200
     0.914    28.234     0.200
     0.914    28.535     0.200
     0.998    31.793     0.200
     1.114    35.574     0.200
     1.114    34.484     0.200
     1.208    38.293     0.200
     1.300    40.125     0.200
     1.364    41.984     0.200
     1.414    43.145     0.200
     1.907    56.992     0.200
     1.928    57.125     0.200
     2.080    61.164     0.200
     2.260    64.812     0.200
     2.341    66.844     0.200
     2.387    68.402     0.200
     0.397    13.336     0.200
     0.399    13.227     0.200
     0.954    32.105     0.200
     1.028    32.828     0.200
     1.028    32.707     0.200
     1.162    38.625     0.200
     1.243    40.746     0.200
     1.257    42.465     0.200
     1.257    42.047     0.200
     1.426    46.098     0.200
     1.685    53.508     0.200
     1.684    53.738     0.200
     1.709    53.848     0.200
     1.709    53.445     0.200
     1.780    53.785     0.200
     1.815    57.426     0.200
     1.902    57.777     0.200
     2.198    66.008     0.200
     2.335    70.285     0.200
     2.384    71.738     0.200
     0.416    13.312     0.200
     0.416    13.742     0.200
     0.493    17.125     0.200
     0.495    16.688     0.200
     0.759    26.633     0.200
     0.977    32.344     0.200
     0.977    31.867     0.200
     1.061    34.062     0.200
     1.140    36.672     0.200
     1.140    36.195     0.200
     1.152    37.734     0.200
     1.152    37.336     0.200
     1.234    40.406     0.200
     1.234    39.734     0.200
     1.265    41.164     0.200
     1.302    42.258     0.200
     1.345    43.555     0.200
     1.345    43.188     0.200
     1.397    43.789     0.200
     1.537    48.414     0.200
     1.748    53.188     0.200
     1.798    54.484     0.200
     1.893    56.844     0.200
     1.928    57.508     0.200
     0.418    13.734     0.200
     0.418    13.867     0.200
     0.497    17.125     0.200
     0.500    16.648     0.200
     0.763    25.680     0.200
     0.763    26.625     0.200
     0.974    32.500     0.200
     0.974    31.984     0.200
     1.065    34.586     0.200
     1.065    34.477     0.200
     1.142    36.328     0.200
     1.142    36.820     0.200
     1.148    37.188     0.200
     1.234    40.375     0.200
     1.234    40.008     0.200
     1.262    41.516     0.200
     1.262    41.156     0.200
     1.300    42.586     0.200
     1.349    42.602     0.200
     1.349    43.305     0.200
     1.400    44.734     0.200
     1.540    48.656     0.200
     1.593    49.477     0.200
     1.751    53.250     0.200
     1.801    54.938     0.200
     2.265    69.102     0.200
     0.497    16.891     0.200
     0.964    32.023     0.200
     1.620    50.125     0.200
     0.508    17.195     0.200
     0.753    23.703     0.200
     0.860    27.086     0.200
     1.259    41.773     0.200
     1.511    46.914     0.200
     1.545    47.727     0.200
     1.660    51.172     0.200
     1.836    57.414     0.200
     0.489    16.141     0.200
     0.944    31.492     0.200
     1.259    42.375     0.200
     1.312    43.766     0.200
     1.568    47.531     0.200
     1.809    55.961     0.200
     0.665    21.016     0.200
     0.829    25.938     0.200
     0.915    29.562     0.200
     1.153    39.031     0.200
     1.141    37.992     0.200
     1.327    40.844     0.200
     1.354    42.125     0.200
     1.464    45.766     0.200
     1.730    55.445     0.200
     1.788    56.742     0.200
     0.543    17.828     0.200
     0.736    23.438     0.200
     0.917    29.133     0.200
     0.995    32.828     0.200
     0.984    33.633     0.200
     1.007    32.633     0.200
     1.311    44.289     0.200
     1.358    44.930     0.200
     1.569    48.727     0.200
     1.594    51.086     0.200
     1.602    50.703     0.200
     1.717    53.484     0.200
     1.752    55.047     0.200
     1.779    55.477     0.200
     1.878    57.078     0.200
     0.479    16.539     0.200
     0.629    20.000     0.200
     0.900    28.945     0.200
     0.949    29.664     0.200
     1.222    38.219     0.200
     1.378    45.836     0.200
     1.429    44.961     0.200
     2.465    75.430     0.200
     2.737    82.898     0.200
     3.099    92.961     0.200
     0.468    15.828     0.200
     0.957    29.375     0.200
     1.228    37.727     0.200
     1.378    45.625     0.200
     1.482    45.695     0.200
     0.472    15.227     0.200
     1.093    37.742     0.200
     1.227    37.875     0.200
     1.481    46.477     0.200
     1.767    55.031     0.200
     0.500    16.555     0.200
     0.517    17.320     0.200
     0.842    26.930     0.200
     1.002    31.305     0.200
     1.018    34.953     0.200
     1.120    35.250     0.200
     1.173    37.391     0.200
     1.317    41.570     0.200
     1.369    43.586     0.200
     1.497    46.266     0.200
     1.647    51.227     0.200
     1.774    53.984     0.200
     0.473    17.172     0.200
     0.640    20.695     0.200
     0.773    24.836     0.200
     0.889    28.086     0.200
     0.958    30.094     0.200
     1.097    37.102     0.200
     1.293    39.992     0.200
     1.325    40.414     0.200
     1.440    45.016     0.200
     1.484    45.680     0.200
     1.770    54.961     0.200
     0.499    17.164     0.200
     0.805    25.688     0.200
     1.222    40.953     0.200
     1.385    41.844     0.200
     1.644    51.219     0.200
     0.515    17.400     0.200
     0.780    25.600     0.200
     0.825    26.710     0.200
     0.897    30.410     0.200
     0.927    31.870     0.200
     1.101    34.500     0.200
     1.077    35.060     0.200
     1.218    42.030     0.200
     1.436    44.950     0.200
     1.467    46.160     0.200
     1.579    50.120     0.200
     1.626    51.050     0.200
     1.753    53.490     0.200
     1.908    59.900     0.200
     0.542    17.049     0.200
     0.674    21.879     0.200
     0.513    16.310     0.200
     0.759    24.990     0.200
     0.858    26.960     0.200
     1.047    34.670     0.200
     1.261    42.300     0.200
     1.434    45.090     0.200
     1.510    47.350     0.200
     1.543    48.650     0.200
     1.658    52.690     0.200
     0.513    17.502     0.200
     0.570    19.032     0.200
     0.960    32.002     0.200
     1.229    38.843     0.200
     1.228    41.192     0.200
     2.322    70.183     0.200
     2.347    72.772     0.200
     2.899    85.022     0.200
     2.932    88.792     0.200
     3.246    97.752     0.200
     3.520   102.933     0.200
     0.484    16.603     0.200
     0.532    17.788     0.200
     0.777    24.688     0.200
     0.858    27.688     0.200
     0.955    32.868     0.200
     1.031    34.988     0.200
     1.274    42.358     0.200
     1.512    47.809     0.200
     1.544    48.428     0.200
     1.657    52.008     0.200
     0.478    16.387     0.200
     0.566    18.616     0.200
     0.718    22.807     0.200
     0.886    28.036     0.200
     0.938    30.337     0.200
     0.943    32.316     0.200
     1.039    32.507     0.200
     1.043    35.547     0.200
     1.160    35.616     0.200
     1.220    38.906     0.200
     1.251    39.557     0.200
     1.254    39.887     0.200
     0.573    19.355     0.200
     0.580    19.075     0.200
     0.845    29.306     0.200
     0.924    28.915     0.200
     1.003    33.695     0.200
     1.122    39.226     0.200
     0.522    17.301     0.200
     0.493    15.625     0.200
     0.637    21.135     0.200
     0.785    25.475     0.200
     1.109    36.926     0.200
     1.324    41.346     0.200
     1.394    46.545     0.200
     1.437    45.676     0.200
     1.766    55.166     0.200
     0.517    17.033     0.200
     0.751    23.975     0.200
     0.872    27.914     0.200
     0.954    31.674     0.200
     0.977    33.555     0.200
     1.040    34.004     0.200
     1.271    42.693     0.200
     1.314    43.164     0.200
     1.523    47.113     0.200
     1.557    47.994     0.200
     1.672    51.934     0.200
     0.466    15.699     0.200
     0.613    19.240     0.200
     1.071    35.990     0.200
     0.490    15.949     0.200
     0.598    19.582     0.200
     0.483    16.742     0.200
     0.609    19.609     0.200
     0.756    26.172     0.200
     0.930    30.180     0.200
     0.930    32.520     0.200
     1.080    36.980     0.200
     1.204    37.531     0.200
     1.366    45.449     0.200
     1.409    44.473     0.200
     1.456    46.750     0.200
     1.584    47.922     0.200
     1.738    53.582     0.200
     1.865    57.852     0.200
     1.985    60.262     0.200
     2.105    63.551     0.200
     2.370    71.992     0.200
     2.517    76.312     0.200
     2.580    78.551     0.200
     2.717    81.492     0.200
     0.569    19.156     0.200
     0.684    22.797     0.200
     0.868    28.496     0.200
     0.938    29.824     0.200
     1.023    31.984     0.200
     0.846    29.586     0.200
     1.193    40.375     0.200
     1.187    37.098     0.200
     1.305    39.867     0.200
     1.349    42.734     0.200
     1.373    43.516     0.200
     1.551    48.688     0.200
     1.680    50.777     0.200
     1.764    55.984     0.200
     1.806    56.695     0.200
     1.943    60.195     0.200
     0.508    17.316     0.200
     0.866    27.625     0.200
     0.983    34.184     0.200
     0.945    31.496     0.200
     1.049    34.387     0.200
     1.178    36.953     0.200
     1.262    42.637     0.200
     1.306    43.355     0.200
     1.551    47.926     0.200
     1.545    50.445     0.200
     1.667    51.375     0.200
     1.699    50.977     0.200
     1.880    58.945     0.200
     1.829    57.086     0.200
     1.997    61.844     0.200
     2.362    71.637     0.200
     2.527    75.246     0.200
     2.590    76.805     0.200
     0.615    20.137     0.200
     0.783    26.988     0.200
     0.900    30.789     0.200
     0.945    30.656     0.200
     0.934    31.367     0.200
     1.107    37.387     0.200
     1.222    38.277     0.200
     1.415    44.906     0.200
     1.472    46.527     0.200
     1.743    54.797     0.200
     2.726    82.879     0.200
     0.557    19.789     0.200
     0.622    20.270     0.200
     1.142    39.309     0.200
     1.311    41.688     0.200
     1.490    45.578     0.200
     1.881    58.918     0.200
     0.512    17.074     0.200
     0.763    24.754     0.200
     0.885    29.781     0.200
     0.924    32.031     0.200
     1.085    33.703     0.200
     1.088    34.941     0.200
     1.355    41.312     0.200
     0.519    17.383     0.200
     0.775    25.223     0.200
     0.831    27.582     0.200
     0.922    31.922     0.200
     1.097    35.082     0.200
     1.077    35.672     0.200
     1.218    42.801     0.200
     1.367    42.582     0.200
     2.527    76.133     0.200
     3.099    90.992     0.200
     3.067    92.773     0.200
     0.467    15.320     0.200
     0.624    19.914     0.200
     0.895    27.984     0.200
     1.080    36.297     0.200
     1.212    37.664     0.200
     1.276    40.773     0.200
     1.308    41.992     0.200
     1.594    50.422     0.200
     1.080    37.148     0.200
     0.439    14.781     0.200
     0.614    19.203     0.200
     1.052    35.953     0.200
     1.447    46.742     0.200
     0.462    14.860     0.200
     0.842    27.830     0.200
     0.501    17.616     0.200
     0.850    27.116     0.200
     0.931    31.096     0.200
     1.249    41.966     0.200
     1.291    43.256     0.200
     1.684    51.295     0.200
     1.980    61.156     0.200
     0.492    16.539     0.200
     0.584    19.301     0.200
     0.908    28.641     0.200
     0.937    31.578     0.200
     0.925    32.129     0.200
     1.068    36.961     0.200
     1.229    40.129     0.200
     2.321    71.551     0.200
     2.351    74.309     0.200
     2.357    74.871     0.200
     0.519    16.906     0.200
     0.635    20.422     0.200
     0.801    25.305     0.200
     0.927    31.656     0.200
     0.894    30.703     0.200
     1.125    37.992     0.200
     1.170    37.641     0.200
     1.323    41.891     0.200
     1.434    45.641     0.200
     0.498    16.832     0.200
     0.787    24.642     0.200
     0.808    25.692     0.200
     1.123    36.052     0.200
     1.077    34.792     0.200
     1.223    41.952     0.200
     1.461    45.972     0.200
     1.608    51.342     0.200
     0.540    17.926     0.200
     0.735    23.176     0.200
     0.915    28.977     0.200
     0.993    32.486     0.200
     1.009    33.637     0.200
     1.308    43.846     0.200
     1.356    44.326     0.200
     1.567    48.195     0.200
     1.715    53.426     0.200
     1.750    54.566     0.200
     1.781    55.695     0.200
     1.706    52.922     0.200
     0.566    18.207     0.200
     0.590    18.715     0.200
     0.850    29.727     0.200
     1.256    39.695     0.200
     0.546    18.344     0.200
     1.226    37.172     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    12.246   381.068     0.200
     5.192   163.688     0.200
     5.809   183.188     0.200
     7.150   229.688     0.200
     8.638   268.688     0.200
     8.600   270.314     0.200
     3.926   122.750     0.200
     4.997   154.750     0.200
     3.997   122.168     0.200
     4.708   144.367     0.200
     5.677   176.969     0.200
     8.650   266.195     0.200
     3.721   116.207     0.200
     3.972   121.879     0.200
     4.729   146.277     0.200
     5.699   176.078     0.200
     3.962   122.922     0.200
     4.736   147.422     0.200
     5.707   178.320     0.200
     6.055   203.281     0.200
     4.842   150.758     0.200
     5.274   165.719     0.200
     5.224   164.596     0.200
     5.218   163.930     0.200
     8.547   270.311     0.200
     3.175    97.551     0.200
     5.106   158.328     0.200
     5.802   183.652     0.200
     6.153   196.152     0.200
     4.088   131.832     0.200
     5.012   156.111     0.200
     3.908   124.598     0.200
     5.092   158.199     0.200
     5.783   183.574     0.200
     8.550   270.926     0.200
    10.004   312.496     0.200
    12.086   381.309     0.200
     2.530    78.867     0.200
     3.994   126.672     0.200
     5.303   164.219     0.200
     8.691   273.820     0.200
     3.898   117.992     0.200
     5.224   163.793     0.200
     5.224   162.562     0.200
     5.698   175.941     0.200
     8.573   267.543     0.200
    12.206   381.691     0.200
     3.855   119.430     0.200
     3.941   122.852     0.200
     5.085   158.555     0.200
     5.085   158.930     0.200
     5.809   182.055     0.200
     8.412   263.383     0.200
     8.582   269.344     0.200
     9.907   316.578     0.200
    12.095   376.148     0.200
    12.095   377.125     0.200
    12.100   376.547     0.200
     3.957   122.594     0.200
     5.091   159.148     0.200
     5.816   181.828     0.200
     7.635   238.523     0.200
     8.423   260.812     0.200
     8.601   270.023     0.200
     8.601   271.375     0.200
     9.909   316.578     0.200
    10.128   319.977     0.200
    10.128   321.234     0.200
    12.111   375.875     0.200
    12.111   378.125     0.200
    12.116   377.273     0.200
    12.359   392.172     0.200
    13.736   431.172     0.200
    14.909   465.234     0.200
    15.662   488.797     0.200
    15.814   503.133     0.200
     3.947   124.898     0.200
     5.091   158.461     0.200
     5.091   157.828     0.200
     5.809   187.062     0.200
     8.590   269.938     0.200
    12.106   375.961     0.200
    12.110   381.711     0.200
     3.927   123.535     0.200
     5.090   158.887     0.200
     5.090   158.223     0.200
     5.796   184.312     0.200
     7.650   237.535     0.200
     8.414   261.664     0.200
     8.569   267.062     0.200
    12.092   377.004     0.200
    12.096   379.559     0.200
     3.910   123.773     0.200
     5.106   159.156     0.200
     8.426   261.859     0.200
     5.220   162.490     0.200
     3.945   125.758     0.200
     5.087   157.844     0.200
     5.087   159.992     0.200
     3.946   122.977     0.200
     5.140   158.875     0.200
     2.534    79.109     0.200
     5.289   164.578     0.200
     4.651   146.262     0.200
     5.186   161.232     0.200
     3.941   120.224     0.200
     4.663   145.914     0.200
     5.236   161.994     0.200
     2.912    89.184     0.200
     3.881   125.174     0.200
     5.201   162.744     0.200
     5.700   185.004     0.200
     5.700   174.902     0.200
     6.223   207.324     0.200
     8.518   267.084     0.200
     8.550   266.863     0.200
    12.173   381.012     0.200
     2.762    85.613     0.200
     5.022   157.223     0.200
     5.233   163.586     0.200
     2.792    85.547     0.200
     5.100   160.137     0.200
     5.227   162.773     0.200
     2.537    79.549     0.200
     5.113   158.832     0.200
     5.085   159.633     0.200
     5.627   177.172     0.200
     2.778    85.578     0.200
     3.652   113.799     0.200
     4.684   147.027     0.200
     5.091   159.424     0.200
     5.318   167.428     0.200
     5.851   183.148     0.200
    12.148   380.674     0.200
     2.697    86.398     0.200
     3.304   103.258     0.200
     2.755    87.008     0.200
     2.871    88.418     0.200
     3.219   102.348     0.200
     3.351   104.730     0.200
     3.637   114.508     0.200
     4.673   146.859     0.200
     5.167   158.465     0.200
     5.669   177.430     0.200
     5.745   181.438     0.200
     8.491   262.719     0.200
     8.554   265.648     0.200
     8.578   265.539     0.200
     9.123   287.098     0.200
     9.416   297.961     0.200
    12.163   377.641     0.200
     2.501    78.913     0.200
     2.501    79.182     0.200
     2.627    84.023     0.200
     2.766    85.653     0.200
     2.834    89.313     0.200
     2.834    88.154     0.200
     2.939    93.983     0.200
     3.056    96.713     0.200
     3.111    97.733     0.200
     3.183    98.533     0.200
     3.716   117.363     0.200
     4.050   126.604     0.200
     4.764   148.053     0.200
     5.026   156.153     0.200
     2.740    86.527     0.200
     2.992    92.488     0.200
     3.012    95.148     0.200
     3.090    97.047     0.200
     3.353   104.266     0.200
     3.794   119.875     0.200
     4.041   125.035     0.200
     4.330   134.527     0.200
     4.399   136.695     0.200
     5.175   162.316     0.200
     5.524   173.008     0.200
     2.763    86.336     0.200
     2.763    85.969     0.200
     2.794    86.156     0.200
     2.796    85.805     0.200
     2.859    88.328     0.200
     3.001    92.363     0.200
     3.034    95.047     0.200
     3.034    94.117     0.200
     3.208    98.680     0.200
     3.366   104.289     0.200
     3.817   119.699     0.200
     4.352   136.586     0.200
     5.181   161.496     0.200
     5.542   172.938     0.200
     2.686    85.789     0.200
     2.723    85.289     0.200
     2.949    94.086     0.200
     3.023    95.992     0.200
     3.732   118.062     0.200
     3.778   120.289     0.200
     2.699    85.906     0.200
     2.937    89.387     0.200
     2.960    93.916     0.200
     3.025    95.547     0.200
     3.027    94.426     0.200
     3.743   117.926     0.200
     3.791   120.396     0.200
     3.977   124.457     0.200
     4.275   134.656     0.200
     4.433   136.848     0.200
     5.216   164.367     0.200
     5.461   170.447     0.200
     6.076   189.688     0.200
     2.719    84.891     0.200
     2.799    87.069     0.200
     2.869    90.889     0.200
     2.921    92.869     0.200
     2.943    91.159     0.200
     3.058    98.059     0.200
     3.058    96.379     0.200
     3.295   103.269     0.200
     3.295   103.010     0.200
     3.838   122.719     0.200
     4.331   134.539     0.200
     5.099   158.579     0.200
     2.764    84.637     0.200
     2.974    92.443     0.200
     3.051    94.990     0.200
     3.134    96.977     0.200
     3.134    97.838     0.200
     3.709   112.795     0.200
     3.833   118.857     0.200
     3.870   121.559     0.200
     4.085   126.338     0.200
     4.371   138.879     0.200
     4.371   134.309     0.200
     4.383   136.197     0.200
     4.870   150.418     0.200
     5.152   160.059     0.200
     5.568   174.098     0.200
     6.763   210.527     0.200
     2.555    78.941     0.200
     2.544    80.363     0.200
     2.942    92.316     0.200
     3.309   103.309     0.200
     3.318   102.418     0.200
     3.835   118.539     0.200
     4.352   134.176     0.200
     4.676   146.547     0.200
     4.713   149.047     0.200
     2.815    87.216     0.200
     2.975    92.360     0.200
     2.975    92.208     0.200
     3.037    95.740     0.200
     3.121    97.910     0.200
     3.218   102.260     0.200
     3.317   104.150     0.200
     3.819   119.350     0.200
     4.072   126.970     0.200
     4.383   137.240     0.200
     4.670   146.460     0.200
     4.676   146.930     0.200
     4.875   151.140     0.200
     5.155   159.680     0.200
     5.554   173.800     0.200
     6.138   190.380     0.200
     6.168   193.390     0.200
     2.524    80.277     0.200
     2.764    88.217     0.200
     2.825    86.979     0.200
     3.046    93.248     0.200
     3.061    96.658     0.200
     3.064    95.998     0.200
     3.369   104.578     0.200
     3.496   109.418     0.200
     3.548   112.547     0.200
     3.610   114.998     0.200
     3.989   125.457     0.200
     4.413   139.807     0.200
     4.459   138.838     0.200
     5.029   157.098     0.200
     5.271   164.396     0.200
     5.376   170.008     0.200
     5.610   177.547     0.200
     5.882   185.938     0.200
     5.970   184.207     0.200
     2.708    86.211     0.200
     2.921    91.102     0.200
     2.972    93.302     0.200
     2.972    93.861     0.200
     3.015    93.723     0.200
     3.015    94.161     0.200
     3.043    95.496     0.200
     3.043    95.682     0.200
     3.320   102.911     0.200
     3.755   118.171     0.200
     3.920   122.461     0.200
     3.994   125.071     0.200
     4.421   135.812     0.200
     4.616   146.021     0.200
     4.931   154.722     0.200
     5.478   171.352     0.200
     6.040   189.642     0.200
     6.081   190.861     0.200
     6.092   191.161     0.200
     2.771    89.012     0.200
     2.771    88.570     0.200
     3.011    96.891     0.200
     3.272   101.078     0.200
     2.555    80.242     0.200
     2.768    87.781     0.200
     2.768    87.625     0.200
     2.908    91.203     0.200
     2.958    92.438     0.200
     3.065    97.648     0.200
     3.284   101.984     0.200
     3.284   102.547     0.200
     3.275   102.922     0.200
     3.845   122.367     0.200
     4.129   129.562     0.200
     4.318   134.148     0.200
     4.699   148.094     0.200
     4.802   149.375     0.200
     2.573    80.828     0.200
     2.576    79.062     0.200
     2.770    85.906     0.200
     2.916    91.273     0.200
     3.192    98.273     0.200
     3.256   101.438     0.200
     3.252   100.836     0.200
     4.185   128.883     0.200
     4.873   152.523     0.200
     5.492   169.922     0.200
     2.681    85.781     0.200
     2.908    92.875     0.200
     3.217   102.344     0.200
     3.693   117.633     0.200
     4.562   144.000     0.200
     5.164   160.828     0.200
     6.034   188.930     0.200
     2.650    83.164     0.200
     2.658    84.176     0.200
     2.658    84.020     0.200
     2.758    85.172     0.200
     2.904    91.480     0.200
     2.904    91.828     0.200
     2.954    92.547     0.200
     3.036    94.020     0.200
     3.172    99.609     0.200
     3.172    99.320     0.200
     3.404   106.336     0.200
     3.906   121.098     0.200
     2.595    79.692     0.200
     2.680    83.600     0.200
     2.888    89.566     0.200
     3.030    93.511     0.200
     3.292   101.075     0.200
     3.322   102.518     0.200
     3.547   109.295     0.200
     2.733    85.066     0.200
     2.788    86.891     0.200
     2.954    92.543     0.200
     3.073    96.645     0.200
     3.317   103.246     0.200
     3.329   103.129     0.200
     2.509    80.266     0.200
     2.545    81.365     0.200
     2.598    79.809     0.200
     2.676    83.801     0.200
     2.711    83.637     0.200
     3.031    93.322     0.200
     3.194    99.686     0.200
     3.288   104.127     0.200
     3.290   101.816     0.200
     3.290   101.311     0.200
     3.307   103.240     0.200
     3.318   103.035     0.200
     3.318   102.766     0.200
     3.691   115.457     0.200
     3.765   118.195     0.200
     3.984   126.006     0.200
     4.300   132.717     0.200
     4.530   136.760     0.200
     4.719   147.605     0.200
     4.823   151.836     0.200
     2.687    83.551     0.200
     2.930    90.963     0.200
     2.943    92.034     0.200
     2.943    92.407     0.200
     3.075    97.474     0.200
     3.319   102.543     0.200
     4.711   147.724     0.200
     2.999    94.555     0.200
     3.403   105.904     0.200
     3.424   106.713     0.200
     2.756    86.515     0.200
     2.838    88.854     0.200
     3.161    98.618     0.200
     3.201   100.228     0.200
     3.201    99.582     0.200
     3.952   124.268     0.200
     4.106   129.928     0.200
     4.169   130.018     0.200
     4.230   130.805     0.200
     4.217   132.844     0.200
     2.555    82.227     0.200
     2.602    83.977     0.200
     2.738    84.156     0.200
     2.802    89.867     0.200
     2.802    90.383     0.200
     3.079    97.367     0.200
     3.359   104.078     0.200
     4.450   142.219     0.200
     2.641    81.195     0.200
     2.791    87.566     0.200
     3.197   101.145     0.200
     3.189    98.539     0.200
     3.216   100.953     0.200
     3.216   100.574     0.200
     3.597   110.562     0.200
     3.676   113.930     0.200
     4.769   152.176     0.200
     5.970   189.676     0.200
     2.668    83.261     0.200
     2.962    93.341     0.200
     3.277   102.941     0.200
     4.618   146.461     0.200
     2.751    84.961     0.200
     2.736    85.273     0.200
     2.668    82.812     0.200
     2.823    87.391     0.200
     3.024    93.555     0.200
     2.715    85.352     0.200
     2.744    85.852     0.200
     2.980    93.883     0.200
     3.015    94.266     0.200
     3.368   104.625     0.200
     2.844    87.446     0.200
     4.256   131.296     0.200
     3.150    97.289     0.200
     3.188    99.672     0.200
     2.804    86.574     0.200
     5.113   158.734     0.200
     5.821   182.637     0.200
     5.105   157.805     0.200
     5.819   184.605     0.200
     3.067    95.334     0.200
     3.769   118.014     0.200
     3.774   119.773     0.200
     3.293   103.430     0.200
     3.660   115.535     0.200
     3.803   120.996     0.200
     4.603   146.098     0.200
     5.248   162.988     0.200
     5.238   161.218     0.200
     7.084   236.430     0.200
     3.944   122.809     0.200
     2.713    84.125     0.200
     2.537    78.875     0.200
     3.116    97.031     0.200
     2.517    82.902     0.200
     2.538    79.372     0.200
     2.501    77.723     0.200
     3.054    96.853     0.200
     3.251   102.032     0.200
     2.523    79.207     0.200
     2.521    80.141     0.200
     2.740    86.262     0.200
     2.884    88.621     0.200
     3.079    96.320     0.200
     2.501    77.992     0.200
     2.543    80.094     0.200
     2.600    83.320     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.235    39.068     0.200
     2.284    70.068     0.200
     2.332    68.688     0.200
     1.087    36.750     0.200
     1.757    54.176     0.200
     1.773    53.727     0.200
     1.845    55.746     0.200
     2.574    73.355     0.200
     1.293    39.988     0.200
     2.437    72.457     0.200
     2.550    74.117     0.200
     3.489    97.188     0.200
     3.570    99.129     0.200
     0.425    14.859     0.200
     0.439    14.648     0.200
     0.709    22.992     0.200
     1.188    37.922     0.200
     1.284    40.398     0.200
     1.672    51.523     0.200
     0.289     9.718     0.200
     0.335    12.168     0.200
     1.213    39.618     0.200
     1.548    48.168     0.200
     1.836    56.118     0.200
     2.401    71.238     0.200
     1.367    41.184     0.200
     1.676    50.781     0.200
     2.263    65.555     0.200
     0.216     7.559     0.200
     1.095    36.258     0.200
     1.223    39.660     0.200
     2.386    71.328     0.200
     0.293     9.891     0.200
     0.357    11.492     0.200
     1.039    34.789     0.200
     1.399    45.195     0.200
     1.500    47.391     0.200
     5.195   149.234     0.200
     0.328    11.375     0.200
     0.740    25.969     0.200
     1.027    35.359     0.200
     1.219    40.016     0.200
     2.276    68.641     0.200
     2.416    74.055     0.200
     0.291    10.516     0.200
     0.360    12.996     0.200
     2.376    69.977     0.200
     0.284    10.457     0.200
     0.577    19.918     0.200
     2.373    69.637     0.200
     2.394    70.000     0.200
     1.149    38.377     0.200
     0.854    29.953     0.200
     2.523    73.453     0.200
     1.220    40.512     0.200
     1.375    45.031     0.200
     1.785    55.102     0.200
     2.296    69.730     0.200
     2.652    77.801     0.200
     1.131    36.895     0.200
     1.343    43.645     0.200
     2.278    67.484     0.200
     1.373    43.047     0.200
     1.144    37.453     0.200
     1.323    42.711     0.200
     1.557    48.547     0.200
     2.302    68.539     0.200
     2.371    70.250     0.200
     2.511    73.023     0.200
     1.235    37.641     0.200
     2.405    71.914     0.200
     0.291    10.352     0.200
     1.008    33.180     0.200
     1.257    39.570     0.200
     2.447    73.500     0.200
     0.472    15.789     0.200
     2.288    67.641     0.200
     0.435    15.922     0.200
     0.456    15.352     0.200
     1.170    37.633     0.200
     2.303    67.562     0.200
     2.303    69.625     0.200
     2.792    81.305     0.200
     0.466    15.742     0.200
     1.162    37.570     0.200
     2.298    68.609     0.200
     2.536    75.633     0.200
     1.145    36.312     0.200
     2.286    69.023     0.200
     2.286    69.984     0.200
     2.800    84.004     0.200
     0.503    16.125     0.200
     1.144    37.703     0.200
     1.187    40.344     0.200
     0.655    23.180     0.200
     1.214    40.639     0.200
     1.470    47.570     0.200
     1.589    51.100     0.200
     2.295    70.199     0.200
     2.326    70.930     0.200
     0.643    23.430     0.200
     1.203    38.297     0.200
     2.155    63.273     0.200
     2.792    81.250     0.200
     0.388    12.797     0.200
     0.648    22.359     0.200
     0.880    29.078     0.200
     0.943    30.742     0.200
     1.021    32.312     0.200
     1.231    39.727     0.200
     1.235    39.375     0.200
     1.232    40.883     0.200
     1.418    44.578     0.200
     1.626    50.906     0.200
     1.807    54.859     0.200
     2.346    69.789     0.200
     2.238    67.367     0.200
     3.140    90.578     0.200
     0.216     8.770     0.200
     0.216     8.328     0.200
     0.447    16.059     0.200
     0.481    18.258     0.200
     0.758    25.410     0.200
     0.795    27.008     0.200
     0.968    30.590     0.200
     1.066    35.348     0.200
     1.149    36.371     0.200
     1.176    37.148     0.200
     1.352    41.590     0.200
     1.389    43.438     0.200
     1.584    47.988     0.200
     2.131    66.879     0.200
     2.534    73.328     0.200
     0.374    13.652     0.200
     0.770    25.742     0.200
     0.942    31.692     0.200
     1.185    38.752     0.200
     1.245    41.062     0.200
     1.614    50.482     0.200
     1.771    55.332     0.200
     2.255    68.872     0.200
     2.356    70.922     0.200
     0.312    11.454     0.200
     0.312    11.624     0.200
     0.534    18.113     0.200
     0.831    26.634     0.200
     0.850    28.964     0.200
     0.995    31.613     0.200
     1.245    39.094     0.200
     1.245    38.934     0.200
     1.320    41.284     0.200
     1.299    41.284     0.200
     2.417    70.693     0.200
     2.417    69.903     0.200
     2.564    75.363     0.200
     4.838   140.764     0.200
     5.236   152.483     0.200
     0.250     8.883     0.200
     0.356    12.264     0.200
     0.692    24.963     0.200
     0.787    26.094     0.200
     0.787    25.812     0.200
     0.888    30.193     0.200
     0.957    31.533     0.200
     0.957    31.424     0.200
     1.202    38.334     0.200
     1.202    38.533     0.200
     1.260    41.053     0.200
     1.260    41.193     0.200
     1.570    48.713     0.200
     2.374    69.973     0.200
     0.567    17.742     0.200
     0.549    18.293     0.200
     0.549    18.184     0.200
     0.605    21.014     0.200
     0.605    20.883     0.200
     0.829    28.322     0.200
     0.996    33.793     0.200
     1.029    34.162     0.200
     1.078    35.873     0.200
     1.122    37.434     0.200
     1.379    44.514     0.200
     1.369    44.473     0.200
     1.620    50.992     0.200
     1.757    54.953     0.200
     0.291     9.246     0.200
     0.351    11.916     0.200
     0.351    12.227     0.200
     0.592    21.637     0.200
     0.734    26.066     0.200
     0.863    30.207     0.200
     0.899    28.348     0.200
     0.937    31.098     0.200
     1.066    36.797     0.200
     1.198    39.486     0.200
     1.243    41.486     0.200
     1.515    48.896     0.200
     1.547    50.117     0.200
     1.562    49.537     0.200
     1.592    51.986     0.200
     1.670    52.986     0.200
     1.660    52.707     0.200
     1.690    53.797     0.200
     1.690    54.617     0.200
     1.816    57.566     0.200
     2.379    72.467     0.200
     2.385    74.256     0.200
     0.772    26.254     0.200
     0.982    32.055     0.200
     0.997    32.695     0.200
     1.070    34.516     0.200
     1.198    39.184     0.200
     1.267    41.434     0.200
     1.284    41.094     0.200
     1.292    41.305     0.200
     2.325    68.953     0.200
     0.237     8.766     0.200
     0.325    11.781     0.200
     0.576    21.445     0.200
     0.537    17.633     0.200
     0.680    24.633     0.200
     0.791    26.883     0.200
     0.818    26.852     0.200
     0.860    29.242     0.200
     0.983    32.305     0.200
     1.065    34.531     0.200
     1.156    38.031     0.200
     1.182    36.734     0.200
     1.182    36.945     0.200
     1.232    39.195     0.200
     1.232    38.977     0.200
     1.288    41.227     0.200
     1.534    47.883     0.200
     1.583    48.914     0.200
     2.310    68.008     0.200
     2.405    70.766     0.200
     0.195     6.635     0.200
     0.412    14.371     0.200
     0.412    14.504     0.200
     0.765    25.615     0.200
     0.765    26.145     0.200
     0.909    30.475     0.200
     0.970    32.674     0.200
     0.982    32.844     0.200
     0.982    33.055     0.200
     1.190    38.635     0.200
     1.190    38.822     0.200
     1.258    40.973     0.200
     1.266    41.771     0.200
     1.278    42.555     0.200
     1.389    45.594     0.200
     1.303    42.074     0.200
     1.655    52.545     0.200
     2.326    70.725     0.200
     2.326    70.059     0.200
     2.691    78.947     0.200
     0.379    12.652     0.200
     1.058    35.662     0.200
     1.254    41.861     0.200
     1.253    41.871     0.200
     1.303    42.742     0.200
     1.352    45.861     0.200
     2.367    71.352     0.200
     0.432    13.082     0.200
     0.759    25.303     0.200
     0.938    31.043     0.200
     0.997    32.463     0.200
     0.988    32.682     0.200
     1.081    35.172     0.200
     1.185    39.533     0.200
     1.204    38.803     0.200
     1.295    41.773     0.200
     1.282    42.463     0.200
     1.403    46.422     0.200
     1.685    53.312     0.200
     1.735    55.033     0.200
     2.310    71.553     0.200
     0.161     5.639     0.200
     0.405    13.508     0.200
     0.421    14.600     0.200
     0.421    14.598     0.200
     0.685    24.768     0.200
     0.786    26.889     0.200
     0.786    26.598     0.200
     0.935    31.479     0.200
     1.018    33.809     0.200
     1.213    38.947     0.200
     1.213    40.092     0.200
     1.228    39.508     0.200
     1.271    41.576     0.200
     1.312    42.568     0.200
     1.433    46.197     0.200
     1.687    53.299     0.200
     0.425    14.090     0.200
     0.677    21.980     0.200
     0.721    24.410     0.200
     0.881    28.758     0.200
     0.910    30.270     0.200
     1.139    36.691     0.200
     1.256    40.559     0.200
     1.210    40.039     0.200
     1.613    51.059     0.200
     1.658    52.629     0.200
     1.652    53.211     0.200
     1.724    53.738     0.200
     2.304    70.020     0.200
     0.218     8.070     0.200
     0.372    12.949     0.200
     0.372    13.188     0.200
     0.494    16.891     0.200
     0.494    16.207     0.200
     0.501    17.359     0.200
     0.501    16.105     0.200
     0.629    23.160     0.200
     0.658    23.848     0.200
     0.693    22.695     0.200
     0.781    25.738     0.200
     0.852    27.188     0.200
     0.987    32.430     0.200
     0.970    31.508     0.200
     0.970    31.793     0.200
     1.048    33.285     0.200
     1.124    36.570     0.200
     1.201    37.488     0.200
     1.204    38.980     0.200
     1.211    39.773     0.200
     1.200    38.688     0.200
     1.200    38.461     0.200
     1.243    39.148     0.200
     1.271    40.988     0.200
     1.384    43.051     0.200
     1.594    49.891     0.200
     1.681    51.668     0.200
     1.887    56.938     0.200
     2.264    67.598     0.200
     2.264    68.066     0.200
     2.634    77.246     0.200
     2.871    83.203     0.200
     0.319    11.273     0.200
     0.546    17.988     0.200
     0.546    17.863     0.200
     0.568    18.224     0.200
     0.568    18.610     0.200
     0.607    20.773     0.200
     0.737    23.934     0.200
     0.737    23.706     0.200
     0.830    28.043     0.200
     1.031    33.474     0.200
     1.099    36.980     0.200
     1.122    36.303     0.200
     1.122    36.833     0.200
     1.624    51.163     0.200
     1.624    51.621     0.200
     1.612    52.083     0.200
     1.612    51.879     0.200
     1.631    52.072     0.200
     1.673    53.545     0.200
     1.712    53.273     0.200
     1.753    54.693     0.200
     0.373    13.062     0.200
     0.373    12.988     0.200
     0.492    16.746     0.200
     0.520    17.336     0.200
     0.675    21.887     0.200
     0.675    21.723     0.200
     0.775    25.887     0.200
     0.957    31.355     0.200
     0.957    31.508     0.200
     1.060    33.559     0.200
     1.111    35.785     0.200
     1.111    35.523     0.200
     1.189    38.250     0.200
     1.192    38.195     0.200
     1.259    40.785     0.200
     1.288    41.059     0.200
     1.288    40.844     0.200
     2.255    66.797     0.200
     2.255    67.086     0.200
     0.214     8.797     0.200
     0.357    12.926     0.200
     0.357    13.188     0.200
     0.509    16.488     0.200
     0.502    17.219     0.200
     0.502    16.867     0.200
     0.502    17.012     0.200
     0.688    21.656     0.200
     0.688    21.242     0.200
     0.795    25.559     0.200
     0.980    31.227     0.200
     0.980    30.914     0.200
     0.977    30.137     0.200
     1.060    33.188     0.200
     1.060    33.320     0.200
     1.130    35.207     0.200
     1.130    35.492     0.200
     1.191    36.969     0.200
     1.194    38.234     0.200
     1.214    37.867     0.200
     1.214    38.160     0.200
     1.282    40.707     0.200
     1.299    40.809     0.200
     1.299    40.641     0.200
     1.374    42.520     0.200
     2.096    63.996     0.200
     2.277    66.738     0.200
     2.277    66.562     0.200
     2.349    68.539     0.200
     0.384    13.195     0.200
     0.384    13.172     0.200
     0.490    16.117     0.200
     0.588    18.578     0.200
     0.588    18.961     0.200
     0.611    20.039     0.200
     0.757    24.984     0.200
     0.911    30.445     0.200
     0.911    30.594     0.200
     1.043    34.047     0.200
     1.105    35.289     0.200
     1.134    35.828     0.200
     1.136    36.000     0.200
     1.166    37.945     0.200
     1.166    38.336     0.200
     1.216    40.359     0.200
     1.303    42.203     0.200
     1.541    47.867     0.200
     1.586    49.008     0.200
     1.713    53.758     0.200
     2.224    67.062     0.200
     2.264    67.375     0.200
     2.686    78.180     0.200
     0.291    10.348     0.200
     0.367    12.926     0.200
     0.506    16.688     0.200
     0.583    18.867     0.200
     0.610    19.768     0.200
     0.734    26.117     0.200
     0.800    26.426     0.200
     0.926    30.246     0.200
     1.050    33.627     0.200
     1.114    34.967     0.200
     1.183    37.326     0.200
     1.300    42.316     0.200
     1.231    40.018     0.200
     1.317    41.957     0.200
     1.531    47.207     0.200
     1.577    48.156     0.200
     1.705    52.707     0.200
     2.241    67.146     0.200
     2.274    67.367     0.200
     0.456    14.789     0.200
     0.456    14.526     0.200
     0.427    14.859     0.200
     0.427    14.889     0.200
     0.452    16.386     0.200
     0.688    25.189     0.200
     0.758    23.929     0.200
     0.921    31.139     0.200
     0.976    31.099     0.200
     0.976    31.262     0.200
     0.971    32.439     0.200
     0.971    32.969     0.200
     1.058    35.609     0.200
     1.176    39.059     0.200
     1.225    40.009     0.200
     1.273    41.917     0.200
     1.272    41.369     0.200
     1.275    41.733     0.200
     1.314    42.239     0.200
     1.382    45.829     0.200
     1.382    45.702     0.200
     1.677    52.729     0.200
     1.677    53.019     0.200
     1.666    52.959     0.200
     1.715    54.269     0.200
     2.373    73.429     0.200
     2.373    72.738     0.200
     0.198     8.488     0.200
     0.377    12.830     0.200
     0.377    13.357     0.200
     0.377    13.639     0.200
     0.493    16.318     0.200
     0.477    15.539     0.200
     0.477    16.408     0.200
     0.637    22.389     0.200
     0.718    22.578     0.200
     0.718    22.418     0.200
     0.785    25.338     0.200
     0.785    25.559     0.200
     0.868    28.799     0.200
     0.931    30.818     0.200
     0.985    31.459     0.200
     0.985    31.314     0.200
     1.009    30.648     0.200
     1.029    32.459     0.200
     1.029    32.289     0.200
     1.207    38.086     0.200
     1.207    37.408     0.200
     1.224    37.678     0.200
     1.221    39.307     0.200
     1.221    38.889     0.200
     1.262    39.898     0.200
     1.284    40.938     0.200
     1.276    40.320     0.200
     1.276    40.129     0.200
     2.129    64.461     0.200
     2.272    66.664     0.200
     2.366    70.869     0.200
     2.503    73.309     0.200
     2.772    78.715     0.200
     2.891    81.973     0.200
     2.851    80.588     0.200
     3.051    85.879     0.200
     0.181     6.426     0.200
     0.442    15.047     0.200
     0.403    13.785     0.200
     0.403    14.355     0.200
     0.403    14.637     0.200
     0.479    16.328     0.200
     0.666    24.438     0.200
     0.778    26.105     0.200
     0.778    25.578     0.200
     0.760    24.273     0.200
     0.906    29.559     0.200
     0.989    31.316     0.200
     0.989    30.809     0.200
     0.989    30.648     0.200
     0.965    31.566     0.200
     0.965    32.539     0.200
     0.996    32.598     0.200
     1.052    34.559     0.200
     1.052    34.379     0.200
     1.203    38.332     0.200
     1.203    38.598     0.200
     1.172    38.445     0.200
     1.248    40.488     0.200
     1.248    40.387     0.200
     1.248    40.207     0.200
     1.251    41.430     0.200
     1.292    41.355     0.200
     1.266    40.598     0.200
     1.269    41.082     0.200
     1.302    42.438     0.200
     1.368    44.559     0.200
     1.449    46.629     0.200
     1.654    51.855     0.200
     1.728    53.617     0.200
     1.744    54.105     0.200
     1.796    55.387     0.200
     2.270    68.613     0.200
     2.336    70.270     0.200
     2.392    71.789     0.200
     2.392    71.988     0.200
     0.212     8.400     0.200
     0.381    13.078     0.200
     0.381    13.280     0.200
     0.381    13.640     0.200
     0.491    16.370     0.200
     0.491    16.132     0.200
     0.487    16.410     0.200
     0.639    21.710     0.200
     0.650    23.520     0.200
     0.706    22.380     0.200
     0.706    22.485     0.200
     0.777    25.660     0.200
     0.930    30.420     0.200
     0.972    31.360     0.200
     1.001    30.850     0.200
     1.035    32.500     0.200
     1.141    36.190     0.200
     1.141    36.400     0.200
     1.141    36.297     0.200
     1.197    38.160     0.200
     1.215    37.370     0.200
     1.222    39.398     0.200
     1.222    39.010     0.200
     1.217    38.797     0.200
     1.256    40.230     0.200
     1.274    40.340     0.200
     1.274    40.000     0.200
     1.274    40.233     0.200
     1.272    40.700     0.200
     2.121    66.198     0.200
     2.223    69.202     0.200
     2.262    66.496     0.200
     2.350    68.340     0.200
     2.350    68.594     0.200
     2.646    75.709     0.200
     2.759    78.750     0.200
     2.759    78.493     0.200
     2.884    82.541     0.200
     3.037    86.480     0.200
     0.449    15.537     0.200
     0.485    15.908     0.200
     0.485    16.188     0.200
     0.491    16.168     0.200
     0.516    17.238     0.200
     0.516    17.129     0.200
     0.677    22.477     0.200
     0.717    23.838     0.200
     0.717    24.037     0.200
     0.802    25.758     0.200
     0.781    25.762     0.200
     0.851    28.887     0.200
     0.851    28.773     0.200
     0.851    28.998     0.200
     1.011    32.547     0.200
     1.014    32.500     0.200
     1.091    35.234     0.200
     1.230    39.098     0.200
     1.230    39.227     0.200
     1.342    42.820     0.200
     1.406    46.295     0.200
     1.406    45.627     0.200
     1.452    45.137     0.200
     1.484    47.646     0.200
     1.602    50.658     0.200
     1.587    51.078     0.200
     1.587    50.920     0.200
     1.931    60.182     0.200
     2.353    73.137     0.200
     2.528    74.963     0.200
     3.639   104.787     0.200
     0.370    12.842     0.200
     0.370    13.081     0.200
     0.499    16.304     0.200
     0.499    16.892     0.200
     0.567    17.937     0.200
     0.567    18.071     0.200
     0.616    21.111     0.200
     0.770    25.331     0.200
     0.814    26.271     0.200
     0.932    30.690     0.200
     0.932    30.491     0.200
     1.066    34.266     0.200
     1.097    34.564     0.200
     1.097    33.731     0.200
     1.145    35.121     0.200
     1.147    36.917     0.200
     1.192    39.146     0.200
     1.192    38.491     0.200
     1.182    38.287     0.200
     1.182    38.182     0.200
     1.197    37.171     0.200
     1.311    42.851     0.200
     1.311    42.231     0.200
     1.236    39.361     0.200
     1.306    41.857     0.200
     1.306    41.102     0.200
     1.547    47.722     0.200
     2.242    66.880     0.200
     2.272    70.602     0.200
     2.287    67.409     0.200
     2.287    67.262     0.200
     2.362    69.701     0.200
     2.362    69.451     0.200
     2.708    77.901     0.200
     0.269     9.082     0.200
     0.269     8.988     0.200
     0.512    17.391     0.200
     0.577    17.547     0.200
     0.577    17.898     0.200
     0.603    20.141     0.200
     0.603    19.918     0.200
     0.866    28.430     0.200
     0.871    29.488     0.200
     1.011    33.258     0.200
     1.011    33.918     0.200
     1.080    35.309     0.200
     1.082    34.965     0.200
     1.076    35.406     0.200
     1.076    35.719     0.200
     1.112    35.852     0.200
     1.178    37.590     0.200
     1.366    45.164     0.200
     1.366    45.352     0.200
     1.279    42.324     0.200
     1.279    41.219     0.200
     1.318    43.441     0.200
     1.408    45.898     0.200
     1.408    45.520     0.200
     1.464    45.430     0.200
     1.647    52.852     0.200
     2.366    75.324     0.200
     2.335    71.016     0.200
     2.335    72.102     0.200
     2.327    71.324     0.200
     2.327    72.281     0.200
     2.465    74.543     0.200
     2.465    75.570     0.200
     2.502    74.930     0.200
     2.692    80.367     0.200
     3.011    87.984     0.200
     3.011    88.699     0.200
     3.281    95.230     0.200
     0.446    13.906     0.200
     0.438    14.570     0.200
     0.438    15.164     0.200
     0.446    15.648     0.200
     0.747    25.648     0.200
     0.936    31.258     0.200
     0.961    30.930     0.200
     0.974    32.766     0.200
     0.974    32.117     0.200
     1.173    38.500     0.200
     1.214    39.789     0.200
     1.214    39.336     0.200
     1.190    39.211     0.200
     1.288    41.836     0.200
     1.290    42.188     0.200
     1.388    45.789     0.200
     1.330    42.586     0.200
     1.681    53.328     0.200
     1.749    55.562     0.200
     1.749    55.758     0.200
     2.302    69.227     0.200
     2.302    70.008     0.200
     2.380    72.703     0.200
     0.265     9.820     0.200
     0.471    17.867     0.200
     0.495    16.719     0.200
     0.589    19.938     0.200
     0.589    20.305     0.200
     0.589    19.719     0.200
     0.766    24.945     0.200
     0.766    24.391     0.200
     0.766    24.125     0.200
     0.808    25.844     0.200
     0.849    29.125     0.200
     0.849    28.688     0.200
     1.116    35.945     0.200
     1.123    36.180     0.200
     1.123    36.383     0.200
     1.132    36.164     0.200
     1.132    36.055     0.200
     1.237    39.586     0.200
     1.237    39.352     0.200
     1.237    39.203     0.200
     1.305    40.953     0.200
     1.305    40.531     0.200
     1.420    44.789     0.200
     1.431    45.227     0.200
     1.431    45.492     0.200
     1.483    45.758     0.200
     1.483    45.242     0.200
     1.539    47.758     0.200
     2.418    72.773     0.200
     0.497    16.656     0.200
     0.497    17.000     0.200
     0.534    18.922     0.200
     0.601    19.836     0.200
     0.601    19.633     0.200
     0.681    22.117     0.200
     0.842    28.344     0.200
     0.939    31.102     0.200
     0.939    31.508     0.200
     0.968    32.117     0.200
     0.968    32.352     0.200
     1.004    31.492     0.200
     1.090    36.812     0.200
     1.272    42.344     0.200
     1.239    38.961     0.200
     1.234    40.289     0.200
     1.423    44.484     0.200
     1.498    49.133     0.200
     2.462    74.031     0.200
     2.450    76.016     0.200
     2.450    75.305     0.200
     0.355    12.430     0.200
     0.371    13.383     0.200
     0.371    13.301     0.200
     0.539    17.539     0.200
     0.539    17.949     0.200
     0.533    17.406     0.200
     0.652    20.793     0.200
     0.780    26.051     0.200
     0.780    25.730     0.200
     0.797    28.078     0.200
     0.847    28.379     0.200
     0.899    29.820     0.200
     0.983    32.148     0.200
     0.983    31.859     0.200
     0.983    32.031     0.200
     1.065    33.309     0.200
     1.253    40.609     0.200
     1.253    41.379     0.200
     1.156    37.504     0.200
     1.206    39.129     0.200
     1.353    43.176     0.200
     1.643    50.531     0.200
     2.219    66.602     0.200
     2.229    67.125     0.200
     2.336    68.500     0.200
     2.385    71.074     0.200
     2.385    70.480     0.200
     2.419    71.086     0.200
     2.531    74.434     0.200
     3.249    93.203     0.200
     0.134     6.402     0.200
     0.310    10.220     0.200
     0.459    15.368     0.200
     0.516    17.322     0.200
     0.516    17.451     0.200
     0.895    28.361     0.200
     0.897    28.205     0.200
     1.091    35.456     0.200
     1.220    39.087     0.200
     1.259    40.300     0.200
     1.307    42.057     0.200
     1.326    41.895     0.200
     1.390    43.965     0.200
     2.284    67.551     0.200
     2.326    68.595     0.200
     2.338    68.890     0.200
     2.514    72.979     0.200
     2.774    79.069     0.200
     2.999    85.176     0.200
     0.392    13.531     0.200
     0.449    14.336     0.200
     0.487    16.773     0.200
     0.749    24.492     0.200
     0.997    32.945     0.200
     1.183    38.711     0.200
     1.209    39.480     0.200
     1.259    40.750     0.200
     1.256    40.961     0.200
     1.401    46.117     0.200
     1.705    53.535     0.200
     2.346    69.949     0.200
     2.675    78.820     0.200
     2.919    85.219     0.200
     0.311    10.159     0.200
     0.311    10.266     0.200
     0.463    15.855     0.200
     0.463    16.029     0.200
     0.512    17.600     0.200
     0.726    24.430     0.200
     0.826    27.039     0.200
     0.894    28.155     0.200
     0.896    28.799     0.200
     1.001    32.839     0.200
     1.042    34.060     0.200
     1.089    35.640     0.200
     1.176    36.899     0.200
     1.216    38.909     0.200
     1.256    40.409     0.200
     1.310    42.039     0.200
     1.376    44.759     0.200
     1.407    45.039     0.200
     1.608    49.229     0.200
     1.608    49.628     0.200
     1.761    53.930     0.200
     2.286    69.527     0.200
     2.323    68.779     0.200
     2.334    69.009     0.200
     0.320    10.546     0.200
     0.461    15.434     0.200
     0.506    17.350     0.200
     0.887    28.877     0.200
     0.897    27.851     0.200
     1.080    35.428     0.200
     1.214    39.063     0.200
     1.249    40.052     0.200
     1.316    41.673     0.200
     1.611    49.786     0.200
     2.280    69.821     0.200
     0.315    10.656     0.200
     0.315    10.482     0.200
     0.460    16.299     0.200
     0.460    16.047     0.200
     0.511    17.605     0.200
     0.723    25.637     0.200
     0.723    24.605     0.200
     0.824    27.365     0.200
     0.824    27.115     0.200
     0.891    28.775     0.200
     0.891    28.967     0.200
     0.881    30.256     0.200
     0.897    28.057     0.200
     0.897    27.869     0.200
     0.997    31.936     0.200
     1.039    33.877     0.200
     1.086    35.627     0.200
     1.171    36.977     0.200
     1.217    38.986     0.200
     1.217    39.244     0.200
     1.254    40.297     0.200
     1.254    40.652     0.200
     1.321    41.586     0.200
     1.321    42.176     0.200
     1.308    42.137     0.200
     1.374    43.707     0.200
     1.385    42.855     0.200
     1.387    44.201     0.200
     1.611    49.379     0.200
     2.214    66.916     0.200
     2.282    68.105     0.200
     2.282    67.537     0.200
     2.321    68.299     0.200
     2.335    69.566     0.200
     2.335    68.564     0.200
     2.442    75.449     0.200
     2.509    73.795     0.200
     3.037    86.807     0.200
     3.229    96.801     0.200
     0.305     9.975     0.200
     0.353    11.645     0.200
     0.516    17.266     0.200
     0.516    17.055     0.200
     0.520    19.256     0.200
     0.607    19.545     0.200
     0.701    25.045     0.200
     0.773    26.916     0.200
     0.992    32.693     0.200
     1.081    36.965     0.200
     1.081    37.131     0.200
     1.296    42.859     0.200
     1.231    38.949     0.200
     1.250    40.287     0.200
     1.426    44.910     0.200
     2.249    71.107     0.200
     0.403    13.852     0.200
     0.403    13.854     0.200
     0.444    13.646     0.200
     0.479    16.473     0.200
     0.665    23.484     0.200
     0.758    24.820     0.200
     0.964    31.754     0.200
     0.990    31.246     0.200
     0.994    32.884     0.200
     0.994    33.178     0.200
     1.050    33.574     0.200
     1.188    38.594     0.200
     1.250    39.732     0.200
     1.203    39.108     0.200
     1.249    39.804     0.200
     1.249    40.207     0.200
     1.264    40.194     0.200
     1.267    40.397     0.200
     1.300    39.534     0.200
     1.281    41.824     0.200
     1.401    45.444     0.200
     1.652    50.624     0.200
     2.336    69.154     0.200
     2.336    69.445     0.200
     2.930    84.514     0.200
     0.353    12.002     0.200
     0.605    19.705     0.200
     0.849    27.812     0.200
     0.913    30.713     0.200
     1.002    31.953     0.200
     1.144    38.125     0.200
     1.330    41.213     0.200
     1.330    41.836     0.200
     1.341    42.613     0.200
     1.341    43.439     0.200
     1.440    46.863     0.200
     1.718    53.908     0.200
     1.930    58.934     0.200
     2.408    70.943     0.200
     2.443    71.814     0.200
     0.265     9.128     0.200
     0.342    11.077     0.200
     0.422    14.858     0.200
     0.422    14.557     0.200
     0.588    19.809     0.200
     0.588    19.488     0.200
     0.588    18.978     0.200
     0.736    24.778     0.200
     0.776    24.168     0.200
     0.776    24.748     0.200
     0.852    29.468     0.200
     0.961    30.718     0.200
     0.961    30.600     0.200
     1.038    34.408     0.200
     1.038    33.768     0.200
     1.089    35.208     0.200
     1.089    35.028     0.200
     1.089    35.747     0.200
     1.116    35.818     0.200
     1.116    35.418     0.200
     1.166    37.658     0.200
     1.166    37.968     0.200
     1.166    38.122     0.200
     1.165    36.758     0.200
     1.267    40.198     0.200
     1.267    40.078     0.200
     1.313    42.038     0.200
     1.351    43.028     0.200
     1.373    44.598     0.200
     1.398    44.758     0.200
     1.437    45.068     0.200
     1.437    46.160     0.200
     1.481    46.647     0.200
     1.517    48.228     0.200
     1.664    51.278     0.200
     2.213    66.518     0.200
     2.213    66.372     0.200
     2.229    66.478     0.200
     2.338    69.695     0.200
     2.387    70.378     0.200
     2.387    71.706     0.200
     2.495    73.938     0.200
     2.495    74.126     0.200
     2.512    74.094     0.200
     2.896    83.609     0.200
     3.178    90.792     0.200
     3.199    91.604     0.200
     0.302    10.023     0.200
     0.346    12.217     0.200
     0.346    10.883     0.200
     0.534    16.924     0.200
     0.534    17.742     0.200
     0.586    19.883     0.200
     0.600    18.809     0.200
     0.796    26.992     0.200
     0.850    29.043     0.200
     0.936    30.990     0.200
     1.036    34.074     0.200
     1.100    34.932     0.200
     1.154    37.764     0.200
     1.145    35.816     0.200
     1.301    43.393     0.200
     1.202    39.539     0.200
     1.347    41.951     0.200
     1.779    55.596     0.200
     2.258    69.244     0.200
     2.394    72.461     0.200
     0.352    11.617     0.200
     0.439    15.504     0.200
     0.439    15.898     0.200
     0.525    17.270     0.200
     0.525    17.164     0.200
     0.753    25.105     0.200
     0.842    26.867     0.200
     0.842    27.539     0.200
     0.789    27.457     0.200
     0.903    28.570     0.200
     1.030    34.016     0.200
     1.030    34.152     0.200
     1.050    34.574     0.200
     1.142    35.977     0.200
     1.142    37.629     0.200
     1.100    36.234     0.200
     1.183    38.355     0.200
     1.375    43.891     0.200
     1.420    45.324     0.200
     1.450    46.504     0.200
     1.552    48.035     0.200
     2.321    68.496     0.200
     2.321    71.621     0.200
     2.471    75.305     0.200
     0.463    15.117     0.200
     0.463    15.188     0.200
     0.487    16.969     0.200
     0.487    17.141     0.200
     0.498    16.750     0.200
     0.498    16.641     0.200
     0.738    24.188     0.200
     0.714    24.266     0.200
     0.831    26.641     0.200
     0.802    26.695     0.200
     0.893    30.516     0.200
     0.893    30.695     0.200
     1.042    33.242     0.200
     1.045    33.602     0.200
     1.150    38.875     0.200
     1.098    35.719     0.200
     1.098    35.555     0.200
     1.212    41.289     0.200
     1.212    41.023     0.200
     1.196    37.727     0.200
     1.476    45.320     0.200
     1.448    47.406     0.200
     1.525    50.125     0.200
     1.630    51.500     0.200
     1.607    52.617     0.200
     1.781    55.352     0.200
     2.326    72.562     0.200
     2.326    72.258     0.200
     2.547    76.906     0.200
     0.418    14.906     0.200
     0.550    19.020     0.200
     0.550    19.125     0.200
     0.550    18.977     0.200
     0.733    24.773     0.200
     0.915    31.035     0.200
     0.915    28.156     0.200
     0.915    28.730     0.200
     1.018    34.086     0.200
     1.018    33.398     0.200
     1.072    35.145     0.200
     1.116    36.406     0.200
     1.116    36.027     0.200
     1.163    37.414     0.200
     1.163    38.227     0.200
     1.163    38.023     0.200
     1.310    42.996     0.200
     1.298    42.684     0.200
     1.400    45.184     0.200
     1.437    46.270     0.200
     1.472    45.895     0.200
     1.528    48.504     0.200
     1.879    58.137     0.200
     2.340    72.246     0.200
     2.340    72.684     0.200
     2.385    71.340     0.200
     2.559    75.441     0.200
     3.197    92.656     0.200
     0.265     9.531     0.200
     0.343    11.081     0.200
     0.524    17.171     0.200
     0.643    20.721     0.200
     0.643    20.831     0.200
     0.772    27.331     0.200
     0.738    26.081     0.200
     0.788    25.671     0.200
     0.788    26.131     0.200
     0.894    30.062     0.200
     1.044    35.481     0.200
     1.002    32.741     0.200
     1.041    32.331     0.200
     1.041    33.331     0.200
     0.999    33.421     0.200
     1.014    33.891     0.200
     1.172    39.131     0.200
     1.291    41.111     0.200
     1.308    42.581     0.200
     1.392    43.431     0.200
     1.441    45.031     0.200
     1.572    48.321     0.200
     1.590    48.491     0.200
     2.279    72.221     0.200
     0.350    12.469     0.200
     0.350    12.375     0.200
     0.516    16.570     0.200
     0.644    20.523     0.200
     0.644    20.711     0.200
     0.694    24.930     0.200
     0.792    26.273     0.200
     0.881    29.750     0.200
     0.959    31.109     0.200
     1.089    34.516     0.200
     1.089    34.695     0.200
     1.151    35.117     0.200
     1.154    36.539     0.200
     1.206    38.133     0.200
     1.263    40.477     0.200
     1.334    41.617     0.200
     1.843    55.266     0.200
     2.267    67.000     0.200
     2.267    67.148     0.200
     2.277    66.898     0.200
     2.380    69.430     0.200
     2.380    69.867     0.200
     2.436    71.898     0.200
     2.436    72.211     0.200
     2.590    75.594     0.200
     0.366    12.797     0.200
     0.366    12.617     0.200
     0.501    16.695     0.200
     0.634    20.398     0.200
     0.775    25.977     0.200
     0.890    30.422     0.200
     0.939    31.172     0.200
     0.939    31.359     0.200
     0.934    31.086     0.200
     1.073    34.820     0.200
     1.095    34.445     0.200
     1.095    34.281     0.200
     1.188    38.250     0.200
     1.184    38.906     0.200
     1.199    37.695     0.200
     1.307    41.766     0.200
     1.332    42.570     0.200
     1.703    53.062     0.200
     2.248    67.203     0.200
     2.271    68.180     0.200
     2.295    69.367     0.200
     2.365    70.742     0.200
     2.596    75.922     0.200
     2.824    81.664     0.200
     0.318    11.109     0.200
     0.318    11.844     0.200
     0.467    16.742     0.200
     0.524    18.023     0.200
     0.524    17.781     0.200
     0.782    26.258     0.200
     0.787    26.773     0.200
     0.787    27.242     0.200
     0.927    30.008     0.200
     0.927    29.219     0.200
     1.154    35.648     0.200
     1.154    36.375     0.200
     1.212    38.523     0.200
     1.220    38.500     0.200
     1.461    44.312     0.200
     2.002    56.953     0.200
     0.266     9.082     0.200
     0.593    19.542     0.200
     0.583    20.521     0.200
     0.662    22.172     0.200
     0.830    27.352     0.200
     0.882    29.731     0.200
     0.909    30.691     0.200
     0.917    31.302     0.200
     1.474    48.021     0.200
     1.499    49.092     0.200
     0.385    12.785     0.200
     0.482    16.715     0.200
     0.702    22.684     0.200
     0.771    24.973     0.200
     0.932    29.473     0.200
     0.965    32.133     0.200
     0.999    33.004     0.200
     1.135    36.875     0.200
     1.191    38.684     0.200
     1.235    40.453     0.200
     1.656    51.945     0.200
     1.687    53.074     0.200
     1.787    55.742     0.200
     2.256    68.594     0.200
     2.345    69.883     0.200
     0.376    12.986     0.200
     0.438    14.855     0.200
     0.497    16.776     0.200
     0.761    25.526     0.200
     0.751    24.826     0.200
     0.866    27.286     0.200
     1.016    32.625     0.200
     1.014    32.766     0.200
     1.069    35.105     0.200
     1.166    37.396     0.200
     1.163    37.006     0.200
     1.181    37.956     0.200
     1.301    41.526     0.200
     1.347    43.166     0.200
     1.415    44.585     0.200
     1.767    53.936     0.200
     2.248    66.835     0.200
     2.285    67.556     0.200
     2.271    67.706     0.200
     2.446    71.196     0.200
     2.505    72.416     0.200
     0.407    14.703     0.200
     0.407    14.219     0.200
     0.568    19.125     0.200
     0.693    22.016     0.200
     0.807    25.359     0.200
     0.845    28.008     0.200
     0.842    27.898     0.200
     0.993    29.422     0.200
     1.009    33.688     0.200
     1.209    38.547     0.200
     1.492    45.273     0.200
     0.209     8.695     0.200
     0.465    16.836     0.200
     0.540    18.766     0.200
     0.640    23.416     0.200
     0.703    24.906     0.200
     0.759    26.137     0.200
     0.966    32.797     0.200
     1.048    33.717     0.200
     0.911    30.965     0.200
     0.911    30.836     0.200
     0.968    32.457     0.200
     0.968    32.734     0.200
     1.004    32.797     0.200
     1.060    34.434     0.200
     1.060    35.035     0.200
     1.201    38.816     0.200
     1.293    41.887     0.200
     1.293    41.477     0.200
     1.308    42.355     0.200
     1.308    41.266     0.200
     1.457    45.875     0.200
     0.413    15.281     0.200
     0.678    24.699     0.200
     0.917    30.590     0.200
     0.917    31.012     0.200
     0.977    32.602     0.200
     0.990    32.629     0.200
     1.061    34.949     0.200
     1.061    34.730     0.200
     1.263    40.551     0.200
     1.313    42.262     0.200
     1.313    41.250     0.200
     1.282    41.789     0.200
     1.282    42.000     0.200
     1.282    41.039     0.200
     1.459    46.129     0.200
     1.532    48.480     0.200
     1.665    51.961     0.200
     1.681    51.770     0.200
     0.524    16.895     0.200
     0.680    21.965     0.200
     0.770    25.924     0.200
     0.784    24.273     0.200
     0.784    25.193     0.200
     0.948    31.613     0.200
     0.973    32.164     0.200
     1.053    33.424     0.200
     1.150    37.994     0.200
     1.123    37.023     0.200
     1.182    37.693     0.200
     1.244    40.504     0.200
     1.244    40.193     0.200
     1.291    42.504     0.200
     1.402    43.895     0.200
     1.500    48.984     0.200
     1.574    48.113     0.200
     2.459    72.725     0.200
     0.262    10.914     0.200
     0.800    27.074     0.200
     0.826    26.953     0.200
     0.826    26.844     0.200
     1.083    34.066     0.200
     1.083    34.203     0.200
     1.118    35.645     0.200
     1.119    35.086     0.200
     1.119    35.316     0.200
     1.261    38.715     0.200
     1.261    38.996     0.200
     1.256    39.695     0.200
     1.491    44.523     0.200
     1.689    49.633     0.200
     0.813    25.910     0.200
     0.908    31.367     0.200
     0.997    31.980     0.200
     1.329    41.469     0.200
     1.466    47.328     0.200
     1.660    51.980     0.200
     1.686    52.379     0.200
     1.793    56.480     0.200
     0.709    22.585     0.200
     0.754    24.515     0.200
     0.754    24.745     0.200
     0.862    28.655     0.200
     0.945    32.265     0.200
     0.948    31.855     0.200
     0.948    32.135     0.200
     1.106    37.655     0.200
     1.249    40.655     0.200
     1.249    40.875     0.200
     1.254    41.335     0.200
     1.348    45.045     0.200
     1.375    42.855     0.200
     1.419    44.795     0.200
     1.419    46.345     0.200
     1.472    48.515     0.200
     1.538    48.995     0.200
     1.546    50.045     0.200
     2.472    74.255     0.200
     2.647    79.775     0.200
     3.745   107.035     0.200
     0.592    18.289     0.200
     0.803    27.117     0.200
     0.886    28.605     0.200
     0.946    32.176     0.200
     1.044    35.117     0.200
     1.151    37.059     0.200
     1.169    39.289     0.200
     1.210    39.809     0.200
     1.252    41.367     0.200
     1.501    47.168     0.200
     1.547    49.129     0.200
     1.837    56.918     0.200
     2.399    71.988     0.200
     0.586    17.628     0.200
     0.796    27.528     0.200
     0.897    28.998     0.200
     0.943    32.148     0.200
     1.050    34.948     0.200
     1.161    36.858     0.200
     1.171    38.878     0.200
     1.204    39.368     0.200
     1.511    47.388     0.200
     1.558    48.928     0.200
     1.593    51.578     0.200
     2.391    72.088     0.200
     0.292    10.715     0.200
     0.292    10.965     0.200
     0.889    28.812     0.200
     1.149    35.312     0.200
     1.149    35.414     0.200
     1.139    36.324     0.200
     1.340    42.402     0.200
     1.340    42.633     0.200
     1.319    41.895     0.200
     1.367    42.793     0.200
     1.541    47.094     0.200
     1.720    52.023     0.200
     2.251    68.113     0.200
     2.403    69.434     0.200
     0.496    17.426     0.200
     0.914    28.234     0.200
     0.914    28.535     0.200
     0.998    31.793     0.200
     1.114    35.574     0.200
     1.114    34.484     0.200
     1.208    38.293     0.200
     1.300    40.125     0.200
     1.364    41.984     0.200
     1.414    43.145     0.200
     1.907    56.992     0.200
     1.928    57.125     0.200
     2.080    61.164     0.200
     2.260    64.812     0.200
     2.341    66.844     0.200
     2.387    68.402     0.200
     0.397    13.336     0.200
     0.399    13.227     0.200
     0.954    32.105     0.200
     1.028    32.828     0.200
     1.028    32.707     0.200
     1.162    38.625     0.200
     1.243    40.746     0.200
     1.257    42.465     0.200
     1.257    42.047     0.200
     1.426    46.098     0.200
     1.685    53.508     0.200
     1.684    53.738     0.200
     1.709    53.848     0.200
     1.709    53.445     0.200
     1.780    53.785     0.200
     1.815    57.426     0.200
     1.902    57.777     0.200
     2.198    66.008     0.200
     2.335    70.285     0.200
     2.384    71.738     0.200
     0.416    13.312     0.200
     0.416    13.742     0.200
     0.493    17.125     0.200
     0.495    16.688     0.200
     0.759    26.633     0.200
     0.977    32.344     0.200
     0.977    31.867     0.200
     1.061    34.062     0.200
     1.140    36.672     0.200
     1.140    36.195     0.200
     1.152    37.734     0.200
     1.152    37.336     0.200
     1.234    40.406     0.200
     1.234    39.734     0.200
     1.265    41.164     0.200
     1.302    42.258     0.200
     1.345    43.555     0.200
     1.345    43.188     0.200
     1.397    43.789     0.200
     1.537    48.414     0.200
     1.748    53.188     0.200
     1.798    54.484     0.200
     1.893    56.844     0.200
     1.928    57.508     0.200
     0.418    13.734     0.200
     0.418    13.867     0.200
     0.497    17.125     0.200
     0.500    16.648     0.200
     0.763    25.680     0.200
     0.763    26.625     0.200
     0.974    32.500     0.200
     0.974    31.984     0.200
     1.065    34.586     0.200
     1.065    34.477     0.200
     1.142    36.328     0.200
     1.142    36.820     0.200
     1.148    37.188     0.200
     1.234    40.375     0.200
     1.234    40.008     0.200
     1.262    41.516     0.200
     1.262    41.156     0.200
     1.300    42.586     0.200
     1.349    42.602     0.200
     1.349    43.305     0.200
     1.400    44.734     0.200
     1.540    48.656     0.200
     1.593    49.477     0.200
     1.751    53.250     0.200
     1.801    54.938     0.200
     2.265    69.102     0.200
     0.497    16.891     0.200
     0.964    32.023     0.200
     1.620    50.125     0.200
     0.508    17.195     0.200
     0.753    23.703     0.200
     0.860    27.086     0.200
     1.259    41.773     0.200
     1.511    46.914     0.200
     1.545    47.727     0.200
     1.660    51.172     0.200
     1.836    57.414     0.200
     0.489    16.141     0.200
     0.944    31.492     0.200
     1.259    42.375     0.200
     1.312    43.766     0.200
     1.568    47.531     0.200
     1.809    55.961     0.200
     0.665    21.016     0.200
     0.829    25.938     0.200
     0.915    29.562     0.200
     1.153    39.031     0.200
     1.141    37.992     0.200
     1.327    40.844     0.200
     1.354    42.125     0.200
     1.464    45.766     0.200
     1.730    55.445     0.200
     1.788    56.742     0.200
     0.543    17.828     0.200
     0.736    23.438     0.200
     0.917    29.133     0.200
     0.995    32.828     0.200
     0.984    33.633     0.200
     1.007    32.633     0.200
     1.311    44.289     0.200
     1.358    44.930     0.200
     1.569    48.727     0.200
     1.594    51.086     0.200
     1.602    50.703     0.200
     1.717    53.484     0.200
     1.752    55.047     0.200
     1.779    55.477     0.200
     1.878    57.078     0.200
     0.479    16.539     0.200
     0.629    20.000     0.200
     0.900    28.945     0.200
     0.949    29.664     0.200
     1.222    38.219     0.200
     1.378    45.836     0.200
     1.429    44.961     0.200
     2.465    75.430     0.200
     2.737    82.898     0.200
     3.099    92.961     0.200
     0.468    15.828     0.200
     0.957    29.375     0.200
     1.228    37.727     0.200
     1.378    45.625     0.200
     1.482    45.695     0.200
     0.472    15.227     0.200
     1.093    37.742     0.200
     1.227    37.875     0.200
     1.481    46.477     0.200
     1.767    55.031     0.200
     0.500    16.555     0.200
     0.517    17.320     0.200
     0.842    26.930     0.200
     1.002    31.305     0.200
     1.018    34.953     0.200
     1.120    35.250     0.200
     1.173    37.391     0.200
     1.317    41.570     0.200
     1.369    43.586     0.200
     1.497    46.266     0.200
     1.647    51.227     0.200
     1.774    53.984     0.200
     0.473    17.172     0.200
     0.640    20.695     0.200
     0.773    24.836     0.200
     0.889    28.086     0.200
     0.958    30.094     0.200
     1.097    37.102     0.200
     1.293    39.992     0.200
     1.325    40.414     0.200
     1.440    45.016     0.200
     1.484    45.680     0.200
     1.770    54.961     0.200
     0.499    17.164     0.200
     0.805    25.688     0.200
     1.222    40.953     0.200
     1.385    41.844     0.200
     1.644    51.219     0.200
     0.515    17.400     0.200
     0.780    25.600     0.200
     0.825    26.710     0.200
     0.897    30.410     0.200
     0.927    31.870     0.200
     1.101    34.500     0.200
     1.077    35.060     0.200
     1.218    42.030     0.200
     1.436    44.950     0.200
     1.467    46.160     0.200
     1.579    50.120     0.200
     1.626    51.050     0.200
     1.753    53.490     0.200
     1.908    59.900     0.200
     0.542    17.049     0.200
     0.674    21.879     0.200
     0.513    16.310     0.200
     0.759    24.990     0.200
     0.858    26.960     0.200
     1.047    34.670     0.200
     1.261    42.300     0.200
     1.434    45.090     0.200
     1.510    47.350     0.200
     1.543    48.650     0.200
     1.658    52.690     0.200
     0.513    17.502     0.200
     0.570    19.032     0.200
     0.960    32.002     0.200
     1.229    38.843     0.200
     1.228    41.192     0.200
     2.322    70.183     0.200
     2.347    72.772     0.200
     2.899    85.022     0.200
     2.932    88.792     0.200
     3.246    97.752     0.200
     3.520   102.933     0.200
     0.484    16.603     0.200
     0.532    17.788     0.200
     0.777    24.688     0.200
     0.858    27.688     0.200
     0.955    32.868     0.200
     1.031    34.988     0.200
     1.274    42.358     0.200
     1.512    47.809     0.200
     1.544    48.428     0.200
     1.657    52.008     0.200
     0.478    16.387     0.200
     0.566    18.616     0.200
     0.718    22.807     0.200
     0.886    28.036     0.200
     0.938    30.337     0.200
     0.943    32.316     0.200
     1.039    32.507     0.200
     1.043    35.547     0.200
     1.160    35.616     0.200
     1.220    38.906     0.200
     1.251    39.557     0.200
     1.254    39.887     0.200
     0.573    19.355     0.200
     0.580    19.075     0.200
     0.845    29.306     0.200
     0.924    28.915     0.200
     1.003    33.695     0.200
     1.122    39.226     0.200
     0.522    17.301     0.200
     0.493    15.625     0.200
     0.637    21.135     0.200
     0.785    25.475     0.200
     1.109    36.926     0.200
     1.324    41.346     0.200
     1.394    46.545     0.200
     1.437    45.676     0.200
     1.766    55.166     0.200
     0.517    17.033     0.200
     0.751    23.975     0.200
     0.872    27.914     0.200
     0.954    31.674     0.200
     0.977    33.555     0.200
     1.040    34.004     0.200
     1.271    42.693     0.200
     1.314    43.164     0.200
     1.523    47.113     0.200
     1.557    47.994     0.200
     1.672    51.934     0.200
     0.466    15.699     0.200
     0.613    19.240     0.200
     1.071    35.990     0.200
     0.490    15.949     0.200
     0.598    19.582     0.200
     0.483    16.742     0.200
     0.609    19.609     0.200
     0.756    26.172     0.200
     0.930    30.180     0.200
     0.930    32.520     0.200
     1.080    36.980     0.200
     1.204    37.531     0.200
     1.366    45.449     0.200
     1.409    44.473     0.200
     1.456    46.750     0.200
     1.584    47.922     0.200
     1.738    53.582     0.200
     1.865    57.852     0.200
     1.985    60.262     0.200
     2.105    63.551     0.200
     2.370    71.992     0.200
     2.517    76.312     0.200
     2.580    78.551     0.200
     2.717    81.492     0.200
     0.569    19.156     0.200
     0.684    22.797     0.200
     0.868    28.496     0.200
     0.938    29.824     0.200
     1.023    31.984     0.200
     0.846    29.586     0.200
     1.193    40.375     0.200
     1.187    37.098     0.200
     1.305    39.867     0.200
     1.349    42.734     0.200
     1.373    43.516     0.200
     1.551    48.688     0.200
     1.680    50.777     0.200
     1.764    55.984     0.200
     1.806    56.695     0.200
     1.943    60.195     0.200
     0.508    17.316     0.200
     0.866    27.625     0.200
     0.983    34.184     0.200
     0.945    31.496     0.200
     1.049    34.387     0.200
     1.178    36.953     0.200
     1.262    42.637     0.200
     1.306    43.355     0.200
     1.551    47.926     0.200
     1.545    50.445     0.200
     1.667    51.375     0.200
     1.699    50.977     0.200
     1.880    58.945     0.200
     1.829    57.086     0.200
     1.997    61.844     0.200
     2.362    71.637     0.200
     2.527    75.246     0.200
     2.590    76.805     0.200
     0.615    20.137     0.200
     0.783    26.988     0.200
     0.900    30.789     0.200
     0.945    30.656     0.200
     0.934    31.367     0.200
     1.107    37.387     0.200
     1.222    38.277     0.200
     1.415    44.906     0.200
     1.472    46.527     0.200
     1.743    54.797     0.200
     2.726    82.879     0.200
     0.557    19.789     0.200
     0.622    20.270     0.200
     1.142    39.309     0.200
     1.311    41.688     0.200
     1.490    45.578     0.200
     1.881    58.918     0.200
     0.512    17.074     0.200
     0.763    24.754     0.200
     0.885    29.781     0.200
     0.924    32.031     0.200
     1.085    33.703     0.200
     1.088    34.941     0.200
     1.355    41.312     0.200
     0.519    17.383     0.200
     0.775    25.223     0.200
     0.831    27.582     0.200
     0.922    31.922     0.200
     1.097    35.082     0.200
     1.077    35.672     0.200
     1.218    42.801     0.200
     1.367    42.582     0.200
     2.527    76.133     0.200
     3.099    90.992     0.200
     3.067    92.773     0.200
     0.467    15.320     0.200
     0.624    19.914     0.200
     0.895    27.984     0.200
     1.080    36.297     0.200
     1.212    37.664     0.200
     1.276    40.773     0.200
     1.308    41.992     0.200
     1.594    50.422     0.200
     1.080    37.148     0.200
     0.439    14.781     0.200
     0.614    19.203     0.200
     1.052    35.953     0.200
     1.447    46.742     0.200
     0.462    14.860     0.200
     0.842    27.830     0.200
     0.501    17.616     0.200
     0.850    27.116     0.200
     0.931    31.096     0.200
     1.249    41.966     0.200
     1.291    43.256     0.200
     1.684    51.295     0.200
     1.980    61.156     0.200
     0.492    16.539     0.200
     0.584    19.301     0.200
     0.908    28.641     0.200
     0.937    31.578     0.200
     0.925    32.129     0.200
     1.068    36.961     0.200
     1.229    40.129     0.200
     2.321    71.551     0.200
     2.351    74.309     0.200
     2.357    74.871     0.200
     0.519    16.906     0.200
     0.635    20.422     0.200
     0.801    25.305     0.200
     0.927    31.656     0.200
     0.894    30.703     0.200
     1.125    37.992     0.200
     1.170    37.641     0.200
     1.323    41.891     0.200
     1.434    45.641     0.200
     0.498    16.832     0.200
     0.787    24.642     0.200
     0.808    25.692     0.200
     1.123    36.052     0.200
     1.077    34.792     0.200
     1.223    41.952     0.200
     1.461    45.972     0.200
     1.608    51.342     0.200
     0.540    17.926     0.200
     0.735    23.176     0.200
     0.915    28.977     0.200
     0.993    32.486     0.200
     1.009    33.637     0.200
     1.308    43.846     0.200
     1.356    44.326     0.200
     1.567    48.195     0.200
     1.715    53.426     0.200
     1.750    54.566     0.200
     1.781    55.695     0.200
     1.706    52.922     0.200
     0.566    18.207     0.200
     0.590    18.715     0.200
     0.850    29.727     0.200
     1.256    39.695     0.200
     0.546    18.344     0.200
     1.226    37.172     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
