#!/bin/bash
gmt begin hubbard5.7_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.1/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source hubbard5.7'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.1 -10.0
  1.1 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.559     0.892     0.200
     0.315     0.123     0.200
     0.463    -0.462     0.200
     0.597     0.924     0.200
     0.738    -0.446     0.200
     0.462    -0.269     0.200
     0.592     0.844     0.200
     0.740    -0.605     0.200
     0.286    -0.103     0.200
     0.647     0.832     0.200
     1.087     0.053     0.200
     0.549     0.654     0.200
     0.569     0.778     0.200
     0.425     0.053     0.200
     0.439    -0.139     0.200
     0.709    -0.577     0.200
     0.289     0.039     0.200
     0.335     0.468     0.200
     0.589    -0.379     0.200
     0.754     0.832     0.200
     0.239     0.015     0.200
     0.270    -0.205     0.200
     0.459     0.664     0.200
     0.216     0.078     0.200
     0.509    -0.197     0.200
     0.620     0.824     0.200
     1.095     0.359     0.200
     0.293     0.152     0.200
     0.547     0.691     0.200
     0.615     0.193     0.200
     1.039     0.597     0.200
     0.312    -0.086     0.200
     0.291     0.019     0.200
     0.360     0.216     0.200
     0.585    -0.370     0.200
     0.695     0.632     0.200
     0.284    -0.026     0.200
     0.361     0.091     0.200
     0.577    -0.398     0.200
     0.688     0.831     0.200
     0.253     0.200     0.200
     0.650     0.751     0.200
     0.209    -0.185     0.200
     0.421     0.176     0.200
     0.601     0.859     0.200
     0.854     0.413     0.200
     0.175     0.125     0.200
     0.330    -0.494     0.200
     0.493     0.901     0.200
     0.258     0.091     0.200
     0.505    -0.289     0.200
     0.647     0.677     0.200
     0.174    -0.072     0.200
     0.544     0.798     0.200
     0.635     0.771     0.200
     0.291     0.122     0.200
     0.281     0.027     0.200
     0.587    -0.296     0.200
     0.677     0.773     0.200
     1.080    -1.394     0.200
     0.472    -0.184     0.200
     0.647     0.267     0.200
     0.879     0.700     0.200
     0.435     0.068     0.200
     0.456    -0.148     0.200
     0.629     0.555     0.200
     0.867     0.854     0.200
     0.466    -0.130     0.200
     0.639     0.748     0.200
     0.870     0.631     0.200
     0.487    -0.206     0.200
     0.661     0.595     0.200
     0.878     0.682     0.200
     0.503    -0.063     0.200
     0.673    -0.230     0.200
     0.655     0.409     0.200
     0.643     0.450     0.200
     0.875     0.786     0.200
     0.388     0.197     0.200
     0.470     0.043     0.200
     0.648     0.608     0.200
     0.820     0.408     0.200
     0.880    -0.701     0.200
     0.943     0.006     0.200
     1.021    -0.979     0.200
     0.216    -0.166     0.200
     0.447    -0.229     0.200
     0.481     0.579     0.200
     0.644     0.736     0.200
     0.758    -0.329     0.200
     0.795     0.092     0.200
     0.968     0.022     0.200
     1.066     0.731     0.200
     0.374     0.091     0.200
     0.543    -0.363     0.200
     0.770     0.300     0.200
     0.942     0.520     0.200
     0.312    -0.068     0.200
     0.312    -0.289     0.200
     0.534    -0.509     0.200
     0.564     0.619     0.200
     0.674     0.463     0.200
     0.740     0.776     0.200
     0.831    -0.308     0.200
     0.850     0.474     0.200
     0.995     0.239     0.200
     0.250    -0.035     0.200
     0.356    -0.113     0.200
     0.356    -0.011     0.200
     0.541    -0.367     0.200
     0.606     0.479     0.200
     0.692     0.264     0.200
     0.787     0.053     0.200
     0.888     0.010     0.200
     0.957     0.465     0.200
     0.567    -0.225     0.200
     0.549     0.190     0.200
     0.605     0.610     0.200
     0.754     0.677     0.200
     0.829     0.811     0.200
     0.978     0.757     0.200
     0.996    -1.362     0.200
     1.029    -0.140     0.200
     1.078     0.428     0.200
     1.078     0.158     0.200
     1.081    -1.257     0.200
     0.291    -0.053     0.200
     0.351     0.604     0.200
     0.587    -0.031     0.200
     0.771     0.807     0.200
     0.789     0.121     0.200
     0.863     0.426     0.200
     0.899    -0.398     0.200
     0.937     1.246     0.200
     1.066     1.205     0.200
     0.431    -0.279     0.200
     0.418     0.142     0.200
     0.681     0.798     0.200
     0.772     0.663     0.200
     0.982    -0.220     0.200
     0.997     0.631     0.200
     1.070    -0.937     0.200
     0.237    -0.132     0.200
     0.325    -0.044     0.200
     0.325     0.144     0.200
     0.576     0.564     0.200
     0.576     0.783     0.200
     0.537    -0.313     0.200
     0.680    -0.491     0.200
     0.752     0.533     0.200
     0.791    -0.896     0.200
     0.791    -0.717     0.200
     0.818    -0.098     0.200
     0.860     0.295     0.200
     0.983     0.403     0.200
     1.065     0.600     0.200
     0.195    -0.043     0.200
     0.412     0.335     0.200
     0.412     0.288     0.200
     0.454    -0.285     0.200
     0.622     0.582     0.200
     0.673     0.859     0.200
     0.765     0.366     0.200
     0.844     0.629     0.200
     0.909    -0.748     0.200
     0.970     0.199     0.200
     0.982     0.493     0.200
     1.049    -1.192     0.200
     0.379    -0.304     0.200
     0.394     0.265     0.200
     0.659     0.777     0.200
     0.826     0.305     0.200
     0.921     0.164     0.200
     0.968     0.399     0.200
     1.058     0.458     0.200
     1.089    -0.255     0.200
     0.432    -0.377     0.200
     0.434     0.210     0.200
     0.697     0.809     0.200
     0.759     0.715     0.200
     0.938    -0.201     0.200
     0.997    -0.003     0.200
     0.988     0.788     0.200
     1.081    -0.707     0.200
     0.161    -0.224     0.200
     0.405    -0.003     0.200
     0.421     0.043     0.200
     0.421     0.102     0.200
     0.576    -0.520     0.200
     0.685     0.945     0.200
     0.786     0.043     0.200
     0.935    -0.988     0.200
     0.935    -0.667     0.200
     1.018     0.072     0.200
     0.425     0.334     0.200
     0.540    -0.154     0.200
     0.677     0.611     0.200
     0.721     0.879     0.200
     0.881    -0.631     0.200
     0.910     0.982     0.200
     0.993    -0.865     0.200
     0.218    -0.080     0.200
     0.372     0.284     0.200
     0.372     0.140     0.200
     0.372     0.272     0.200
     0.494    -0.273     0.200
     0.494    -0.167     0.200
     0.501    -0.213     0.200
     0.629     0.726     0.200
     0.658     0.434     0.200
     0.693    -0.617     0.200
     0.804     0.579     0.200
     0.781    -0.154     0.200
     0.852    -0.952     0.200
     0.987    -0.943     0.200
     0.970     0.495     0.200
     1.048    -0.780     0.200
     1.048    -0.588     0.200
     0.319     0.449     0.200
     0.546     0.065     0.200
     0.546     0.103     0.200
     0.568    -0.247     0.200
     0.607     0.510     0.200
     0.737    -0.264     0.200
     0.737    -0.378     0.200
     0.798     0.968     0.200
     0.830     0.585     0.200
     1.031    -0.120     0.200
     1.099    -0.261     0.200
     0.373     0.202     0.200
     0.373     0.300     0.200
     0.492    -0.028     0.200
     0.520    -0.337     0.200
     0.520    -0.439     0.200
     0.627     0.606     0.200
     0.675    -0.620     0.200
     0.775     0.034     0.200
     0.957     0.540     0.200
     0.972    -0.672     0.200
     1.060    -0.424     0.200
     0.214    -0.219     0.200
     0.357    -0.027     0.200
     0.357    -0.063     0.200
     0.357     0.047     0.200
     0.509    -0.707     0.200
     0.502    -0.430     0.200
     0.614     0.669     0.200
     0.655     0.972     0.200
     0.688    -0.900     0.200
     0.795    -0.037     0.200
     0.980     0.494     0.200
     0.977    -0.300     0.200
     0.977    -0.620     0.200
     1.060    -0.178     0.200
     0.384     0.264     0.200
     0.384     0.296     0.200
     0.490     0.396     0.200
     0.588    -0.204     0.200
     0.625     0.464     0.200
     0.611    -0.138     0.200
     0.757     0.715     0.200
     0.920    -1.296     0.200
     0.911     0.805     0.200
     1.043     0.126     0.200
     0.291     0.134     0.200
     0.367     0.218     0.200
     0.506    -0.140     0.200
     0.609     0.513     0.200
     0.583    -0.413     0.200
     0.610    -0.430     0.200
     0.734     0.245     0.200
     0.800    -0.961     0.200
     0.800    -1.182     0.200
     0.773     0.116     0.200
     0.913    -1.099     0.200
     0.926     0.607     0.200
     1.050     0.225     0.200
     0.456    -0.208     0.200
     0.427     0.101     0.200
     0.427     0.093     0.200
     0.452     0.716     0.200
     0.688     0.684     0.200
     0.751     0.562     0.200
     0.758    -0.478     0.200
     0.921     0.227     0.200
     0.976    -1.026     0.200
     0.976    -0.782     0.200
     0.971     0.758     0.200
     1.058    -1.092     0.200
     0.198    -0.209     0.200
     0.377    -0.107     0.200
     0.377    -0.156     0.200
     0.493    -0.618     0.200
     0.493    -0.727     0.200
     0.477    -0.500     0.200
     0.477    -0.160     0.200
     0.637     0.591     0.200
     0.718    -0.765     0.200
     0.636     0.898     0.200
     0.785     0.056     0.200
     0.868     0.028     0.200
     0.931     0.518     0.200
     0.985     0.631     0.200
     1.009    -0.422     0.200
     1.009    -0.313     0.200
     1.029    -0.021     0.200
     0.181    -0.162     0.200
     0.442     0.072     0.200
     0.403     0.209     0.200
     0.403     0.194     0.200
     0.479    -0.059     0.200
     0.609     0.441     0.200
     0.609     1.031     0.200
     0.666     0.612     0.200
     0.666     0.850     0.200
     0.778    -0.132     0.200
     0.760    -1.045     0.200
     0.906    -0.954     0.200
     0.906    -1.106     0.200
     0.989    -0.906     0.200
     0.989    -0.746     0.200
     0.965     0.073     0.200
     0.965     0.331     0.200
     0.996     0.021     0.200
     1.052    -1.354     0.200
     0.212    -0.224     0.200
     0.381    -0.018     0.200
     0.381    -0.013     0.200
     0.491    -0.425     0.200
     0.487    -0.452     0.200
     0.639     0.516     0.200
     0.650     0.118     0.200
     0.706    -0.715     0.200
     0.777     0.170     0.200
     0.777     0.279     0.200
     0.930     0.440     0.200
     0.972     0.701     0.200
     1.001    -0.286     0.200
     1.001    -0.486     0.200
     1.035    -0.060     0.200
     1.035    -0.245     0.200
     0.449     0.375     0.200
     0.485     0.077     0.200
     0.485     0.091     0.200
     0.491     0.024     0.200
     0.516     0.198     0.200
     0.677     0.594     0.200
     0.717     0.313     0.200
     0.777    -1.486     0.200
     0.802    -0.728     0.200
     0.781     0.509     0.200
     0.780    -0.211     0.200
     0.851     0.137     0.200
     0.934     0.622     0.200
     1.011    -0.775     0.200
     1.014    -0.969     0.200
     1.091    -0.182     0.200
     0.370     0.189     0.200
     0.370     0.201     0.200
     0.499    -0.159     0.200
     0.567    -0.374     0.200
     0.616     0.555     0.200
     0.770     0.010     0.200
     0.814    -1.043     0.200
     0.930    -0.749     0.200
     0.932     0.551     0.200
     1.066     0.203     0.200
     1.097    -0.427     0.200
     0.269     0.115     0.200
     0.269     0.121     0.200
     0.512     0.853     0.200
     0.577    -0.208     0.200
     0.603     0.002     0.200
     0.866    -0.606     0.200
     0.871     0.268     0.200
     1.011     0.368     0.200
     1.011     0.599     0.200
     1.080    -0.547     0.200
     1.082     0.546     0.200
     1.076     0.003     0.200
     0.446    -0.103     0.200
     0.438     0.140     0.200
     0.438     0.273     0.200
     0.446     0.823     0.200
     0.700     0.627     0.200
     0.747     0.662     0.200
     0.936    -0.718     0.200
     0.961    -0.764     0.200
     0.974     0.737     0.200
     1.073    -1.173     0.200
     0.249    -0.246     0.200
     0.265    -0.009     0.200
     0.471     1.027     0.200
     0.495    -0.166     0.200
     0.589    -0.260     0.200
     0.589    -0.275     0.200
     0.766    -0.645     0.200
     0.808    -0.064     0.200
     0.849     0.414     0.200
     0.497     0.434     0.200
     0.534     0.467     0.200
     0.601     0.052     0.200
     0.681    -0.164     0.200
     0.681     0.125     0.200
     0.842     0.474     0.200
     0.939     0.722     0.200
     0.939     0.832     0.200
     0.968     0.388     0.200
     0.968     0.490     0.200
     1.002    -1.028     0.200
     1.004    -1.041     0.200
     1.090    -0.503     0.200
     1.090     0.333     0.200
     0.355     0.016     0.200
     0.371     0.352     0.200
     0.371     0.372     0.200
     0.539    -0.375     0.200
     0.533    -0.390     0.200
     0.533    -0.281     0.200
     0.594     0.662     0.200
     0.652    -0.472     0.200
     0.652    -0.340     0.200
     0.756    -1.428     0.200
     0.780    -0.066     0.200
     0.797     0.398     0.200
     0.848    -1.504     0.200
     0.848    -1.325     0.200
     0.847    -0.597     0.200
     0.899     0.402     0.200
     0.983     0.080     0.200
     1.062    -1.000     0.200
     1.065    -0.937     0.200
     0.134    -0.041     0.200
     0.459     0.018     0.200
     0.490     0.508     0.200
     0.516    -0.070     0.200
     0.895    -0.278     0.200
     0.897    -0.417     0.200
     0.897    -0.526     0.200
     0.998    -0.023     0.200
     1.091     0.815     0.200
     0.392     0.345     0.200
     0.449    -0.215     0.200
     0.487     0.445     0.200
     0.749    -0.186     0.200
     0.997     0.458     0.200
     1.002    -1.171     0.200
     0.311     0.178     0.200
     0.463     0.322     0.200
     0.463     0.274     0.200
     0.512     0.076     0.200
     0.512     0.255     0.200
     0.726     0.227     0.200
     0.826    -0.013     0.200
     0.894    -0.843     0.200
     0.896    -0.253     0.200
     1.001    -0.488     0.200
     1.042     0.051     0.200
     1.089     0.644     0.200
     0.320    -0.033     0.200
     0.461     0.136     0.200
     0.506     0.316     0.200
     0.887    -0.482     0.200
     0.897    -0.893     0.200
     1.080     0.538     0.200
     0.136     0.001     0.200
     0.315    -0.065     0.200
     0.315    -0.215     0.200
     0.460     0.207     0.200
     0.460     0.168     0.200
     0.511     0.074     0.200
     0.511    -0.047     0.200
     0.511     0.249     0.200
     0.723     0.325     0.200
     0.824     0.195     0.200
     0.891    -0.152     0.200
     0.891    -0.351     0.200
     0.881     0.595     0.200
     0.897    -0.585     0.200
     0.897    -0.704     0.200
     0.997    -0.522     0.200
     0.997    -0.213     0.200
     1.039     0.218     0.200
     1.086     0.878     0.200
     0.305    -0.174     0.200
     0.353     0.097     0.200
     0.516     0.318     0.200
     0.516     0.103     0.200
     0.520     0.584     0.200
     0.607    -0.178     0.200
     0.660     0.079     0.200
     0.660    -0.175     0.200
     0.685    -0.511     0.200
     0.701     0.988     0.200
     0.773     0.494     0.200
     0.789    -0.324     0.200
     0.799    -0.645     0.200
     0.960     0.587     0.200
     0.960     0.370     0.200
     0.973     0.225     0.200
     0.992    -0.039     0.200
     1.013     0.004     0.200
     1.016    -1.205     0.200
     1.064    -0.511     0.200
     1.081     0.096     0.200
     1.081     0.555     0.200
     0.403     0.334     0.200
     0.403     0.266     0.200
     0.444    -0.106     0.200
     0.444    -0.208     0.200
     0.479     0.369     0.200
     0.665     0.542     0.200
     0.758    -0.543     0.200
     0.904    -0.541     0.200
     0.964    -1.012     0.200
     0.990    -0.767     0.200
     0.994     0.425     0.200
     1.050    -0.794     0.200
     0.327    -0.510     0.200
     0.353     0.128     0.200
     0.605    -0.494     0.200
     0.849    -0.264     0.200
     0.849     0.160     0.200
     0.933    -0.418     0.200
     1.002    -0.915     0.200
     1.099    -0.941     0.200
     0.265     0.002     0.200
     0.342    -0.089     0.200
     0.342    -0.219     0.200
     0.422     0.309     0.200
     0.422     0.420     0.200
     0.546     0.892     0.200
     0.588     0.092     0.200
     0.588    -0.174     0.200
     0.588    -0.015     0.200
     0.736     0.312     0.200
     0.776    -1.234     0.200
     0.776    -0.564     0.200
     0.776    -0.766     0.200
     0.852     0.325     0.200
     0.961    -0.985     0.200
     0.961    -0.825     0.200
     1.012     0.591     0.200
     1.038     0.493     0.200
     1.038     0.206     0.200
     1.089    -0.460     0.200
     1.089     0.109     0.200
     1.089    -0.010     0.200
     0.302    -0.024     0.200
     0.346     0.402     0.200
     0.346     0.423     0.200
     0.534     0.357     0.200
     0.582     0.854     0.200
     0.586     0.385     0.200
     0.600    -0.423     0.200
     0.762     0.736     0.200
     0.745     0.148     0.200
     0.769    -0.421     0.200
     0.796     0.547     0.200
     0.883    -0.657     0.200
     0.936     0.758     0.200
     1.036     0.209     0.200
     1.036     0.052     0.200
     1.053     0.067     0.200
     1.098    -0.890     0.200
     0.352    -0.033     0.200
     0.439     0.312     0.200
     0.439     0.636     0.200
     0.525    -0.113     0.200
     0.525    -0.140     0.200
     0.753     0.422     0.200
     0.842    -1.132     0.200
     0.842    -0.339     0.200
     0.789     0.512     0.200
     0.903    -0.928     0.200
     1.030     0.562     0.200
     1.030     0.796     0.200
     1.050    -0.195     0.200
     1.100     0.342     0.200
     0.463     0.029     0.200
     0.463     0.411     0.200
     0.487     0.654     0.200
     0.487     0.060     0.200
     0.498     0.429     0.200
     0.498     0.210     0.200
     0.668     0.991     0.200
     0.738    -0.005     0.200
     0.714     0.825     0.200
     0.788    -1.169     0.200
     0.831    -0.211     0.200
     0.802     0.841     0.200
     0.802     0.989     0.200
     0.895    -1.191     0.200
     0.893     0.551     0.200
     1.042    -0.517     0.200
     1.045    -0.562     0.200
     1.007     0.566     0.200
     1.098     0.252     0.200
     0.239    -0.089     0.200
     0.418     0.541     0.200
     0.418     0.783     0.200
     0.550     0.082     0.200
     0.550     0.145     0.200
     0.561     1.239     0.200
     0.733     0.205     0.200
     0.733     0.615     0.200
     0.915    -0.826     0.200
     0.915    -1.162     0.200
     1.018     0.165     0.200
     1.072    -0.657     0.200
     1.072    -0.517     0.200
     0.265     0.407     0.200
     0.265     0.306     0.200
     0.343    -0.090     0.200
     0.524     0.460     0.200
     0.524     0.689     0.200
     0.643    -0.238     0.200
     0.772     0.637     0.200
     0.738     0.299     0.200
     0.738     0.789     0.200
     0.788     0.103     0.200
     0.788    -0.087     0.200
     0.894     0.194     0.200
     1.044    -0.194     0.200
     1.044     0.567     0.200
     1.002    -0.455     0.200
     1.041    -0.705     0.200
     0.999     0.553     0.200
     1.014     0.417     0.200
     0.350     0.066     0.200
     0.350    -0.067     0.200
     0.516    -0.769     0.200
     0.516    -0.902     0.200
     0.644    -0.794     0.200
     0.694     0.262     0.200
     0.792    -0.508     0.200
     0.881     0.127     0.200
     0.937    -0.827     0.200
     0.959     0.192     0.200
     0.959     0.309     0.200
     1.089     0.141     0.200
     0.366     0.162     0.200
     0.366     0.068     0.200
     0.501    -0.012     0.200
     0.634    -0.413     0.200
     0.712     0.431     0.200
     0.775     0.199     0.200
     0.890     0.144     0.200
     0.939     0.542     0.200
     0.934    -1.193     0.200
     1.073     0.151     0.200
     1.095    -0.668     0.200
     1.095    -0.769     0.200
     0.318    -0.373     0.200
     0.467     0.290     0.200
     0.524     0.108     0.200
     0.524    -0.088     0.200
     0.782     0.485     0.200
     0.787     0.747     0.200
     0.927     0.247     0.200
     0.927     0.067     0.200
     0.946     0.905     0.200
     1.064     1.252     0.200
     0.266     0.163     0.200
     0.438     0.744     0.200
     0.593     0.211     0.200
     0.583     1.132     0.200
     0.662    -0.080     0.200
     0.718    -0.138     0.200
     0.814    -0.209     0.200
     0.830    -0.076     0.200
     0.940     0.537     0.200
     0.882     0.833     0.200
     0.909     0.209     0.200
     0.917     0.625     0.200
     1.047    -0.968     0.200
     1.048    -0.690     0.200
     1.076    -0.294     0.200
     0.385     0.283     0.200
     0.497    -0.243     0.200
     0.482     0.165     0.200
     0.702    -0.469     0.200
     0.771     0.112     0.200
     0.865    -0.771     0.200
     0.932     0.119     0.200
     0.965     0.336     0.200
     0.999    -1.113     0.200
     0.376    -0.152     0.200
     0.438    -0.135     0.200
     0.497    -0.168     0.200
     0.761     0.148     0.200
     0.751    -0.163     0.200
     0.866    -0.801     0.200
     1.016    -0.221     0.200
     1.014     0.230     0.200
     1.069     0.548     0.200
     0.407     0.389     0.200
     0.407     0.085     0.200
     0.568     0.518     0.200
     0.650    -1.529     0.200
     0.650    -1.638     0.200
     0.693    -0.888     0.200
     0.693    -1.006     0.200
     0.766    -1.364     0.200
     0.807    -0.272     0.200
     0.845    -0.529     0.200
     0.842    -0.114     0.200
     0.879     0.007     0.200
     0.993    -1.501     0.200
     1.087    -0.758     0.200
     1.087     0.437     0.200
     1.009     0.674     0.200
     1.091    -0.899     0.200
     0.209    -0.183     0.200
     0.465     0.415     0.200
     0.540     0.067     0.200
     0.640     0.459     0.200
     0.759     1.022     0.200
     0.966     0.720     0.200
     1.048     0.805     0.200
     0.402    -0.061     0.200
     0.404     0.069     0.200
     0.431    -0.093     0.200
     0.667     0.547     0.200
     0.911    -0.104     0.200
     0.911    -0.515     0.200
     0.968     0.419     0.200
     1.004     0.288     0.200
     1.060    -0.325     0.200
     1.060    -0.188     0.200
     0.413     0.103     0.200
     0.415     0.038     0.200
     0.440    -0.132     0.200
     0.678     0.615     0.200
     0.917     0.131     0.200
     0.917    -1.009     0.200
     0.977     0.038     0.200
     0.977    -0.079     0.200
     1.061    -1.338     0.200
     1.061     0.643     0.200
     0.524     0.470     0.200
     0.524     0.701     0.200
     0.679    -1.012     0.200
     0.679    -0.662     0.200
     0.680    -0.382     0.200
     0.770    -0.402     0.200
     0.770    -0.262     0.200
     0.784    -0.607     0.200
     0.808     0.208     0.200
     0.852     0.221     0.200
     0.948     0.660     0.200
     0.973     0.558     0.200
     1.053    -1.351     0.200
     1.080     0.159     0.200
     1.080    -0.762     0.200
     0.262    -0.261     0.200
     0.461     0.703     0.200
     0.800     0.605     0.200
     0.826     0.233     0.200
     1.083    -0.323     0.200
     1.083    -0.116     0.200
     0.813    -0.320     0.200
     0.908     0.592     0.200
     0.997    -0.468     0.200
     0.709     0.116     0.200
     0.754     0.220     0.200
     0.754     0.110     0.200
     0.862     0.469     0.200
     0.945     0.644     0.200
     0.945     0.824     0.200
     0.948     0.877     0.200
     1.027    -0.786     0.200
     0.592    -0.063     0.200
     0.803     1.023     0.200
     0.886    -0.387     0.200
     0.946     1.225     0.200
     1.044     0.618     0.200
     0.586    -0.193     0.200
     0.796     0.883     0.200
     0.897    -0.169     0.200
     0.943     1.012     0.200
     1.050     0.292     0.200
     0.292    -0.305     0.200
     0.889    -0.203     0.200
     0.889    -0.086     0.200
     0.496    -0.336     0.200
     0.914    -0.334     0.200
     0.914     0.045     0.200
     0.998     0.820     0.200
     0.250    -0.749     0.200
     0.296    -0.149     0.200
     0.555     0.109     0.200
     0.546     1.027     0.200
     0.827     1.347     0.200
     0.842    -0.182     0.200
     0.995     0.348     0.200
     1.088     0.961     0.200
     0.397     0.372     0.200
     0.399     0.350     0.200
     0.470    -0.168     0.200
     0.659     0.265     0.200
     0.954     0.390     0.200
     1.028    -0.704     0.200
     1.028    -0.594     0.200
     0.416    -0.139     0.200
     0.416    -0.272     0.200
     0.493     0.214     0.200
     0.495     0.172     0.200
     0.759     0.545     0.200
     0.977     0.404     0.200
     1.061     0.029     0.200
     0.418    -0.084     0.200
     0.418    -0.201     0.200
     0.497     0.258     0.200
     0.500     0.216     0.200
     0.763     0.698     0.200
     0.763     0.378     0.200
     0.974     0.465     0.200
     1.065    -0.090     0.200
     1.065    -0.410     0.200
     0.497     0.141     0.200
     0.745    -0.382     0.200
     0.858     0.300     0.200
     0.933    -0.708     0.200
     0.988     0.930     0.200
     1.060    -0.412     0.200
     0.471     0.038     0.200
     0.641    -0.325     0.200
     0.964    -0.812     0.200
     0.753    -0.180     0.200
     0.860    -0.580     0.200
     0.942    -0.171     0.200
     0.978     0.301     0.200
     1.050     0.077     0.200
     0.886    -1.337     0.200
     0.944    -0.177     0.200
     0.528     0.178     0.200
     0.665     0.185     0.200
     0.829    -0.776     0.200
     0.915    -0.119     0.200
     0.885     0.328     0.200
     0.997    -0.644     0.200
     0.736    -0.167     0.200
     0.917    -0.721     0.200
     0.995    -1.773     0.200
     0.984     0.586     0.200
     1.007     0.596     0.200
     0.479     0.383     0.200
     0.629    -0.514     0.200
     0.769    -0.878     0.200
     0.900    -0.492     0.200
     0.949    -0.939     0.200
     1.093     0.631     0.200
     1.099    -1.120     0.200
     0.468     0.087     0.200
     1.093     0.622     0.200
     0.472     0.101     0.200
     0.637    -0.430     0.200
     1.093     0.599     0.200
     0.517    -0.209     0.200
     0.694    -0.564     0.200
     0.842    -0.792     0.200
     1.002    -1.918     0.200
     1.018     0.994     0.200
     0.473     0.205     0.200
     0.640    -0.804     0.200
     1.097     0.400     0.200
     0.499     0.026     0.200
     0.805    -0.626     0.200
     0.515     0.138     0.200
     0.780    -0.067     0.200
     0.825    -0.033     0.200
     0.897     0.019     0.200
     0.927     1.160     0.200
     1.077     0.179     0.200
     0.542     0.111     0.200
     0.674     0.038     0.200
     0.513     0.153     0.200
     0.759    -0.244     0.200
     0.858    -0.456     0.200
     0.944    -0.762     0.200
     0.972     1.149     0.200
     1.047     0.243     0.200
     0.513     0.110     0.200
     0.570     0.086     0.200
     0.747    -0.980     0.200
     0.907     1.140     0.200
     0.960    -0.274     0.200
     1.072     0.208     0.200
     0.484     0.135     0.200
     0.597    -0.134     0.200
     0.747    -0.926     0.200
     0.919    -0.768     0.200
     0.923    -0.269     0.200
     0.931     0.786     0.200
     1.071     0.073     0.200
     0.532     0.181     0.200
     0.777    -0.063     0.200
     0.858    -0.351     0.200
     0.955    -1.234     0.200
     1.031     0.878     0.200
     0.478     0.181     0.200
     0.566    -0.018     0.200
     0.718    -0.429     0.200
     0.886    -0.475     0.200
     0.938    -0.435     0.200
     0.943     0.520     0.200
     1.039    -1.165     0.200
     1.043     0.048     0.200
     0.573     0.193     0.200
     0.580     0.103     0.200
     0.799    -0.988     0.200
     0.845     0.727     0.200
     0.924    -0.632     0.200
     1.003    -0.489     0.200
     1.098    -1.761     0.200
     0.576    -1.430     0.200
     0.522     0.216     0.200
     1.084     0.868     0.200
     0.493     0.283     0.200
     0.637    -0.016     0.200
     0.905    -0.153     0.200
     0.517     0.079     0.200
     0.751    -0.075     0.200
     0.872    -0.353     0.200
     0.977     1.040     0.200
     0.466     0.090     0.200
     0.613    -1.039     0.200
     1.071    -0.060     0.200
     0.490     0.124     0.200
     0.598    -0.327     0.200
     1.077     0.207     0.200
     0.609    -0.131     0.200
     0.930     0.478     0.200
     0.930     0.512     0.200
     1.080     0.474     0.200
     0.569     0.150     0.200
     0.868    -1.025     0.200
     1.023    -0.790     0.200
     0.846     0.372     0.200
     0.508     0.167     0.200
     0.866    -0.467     0.200
     0.983     0.549     0.200
     1.049     0.099     0.200
     0.513     0.052     0.200
     0.615    -0.040     0.200
     0.900     0.999     0.200
     0.945    -0.623     0.200
     0.934     0.096     0.200
     0.855     1.429     0.200
     0.512     0.229     0.200
     0.763    -0.121     0.200
     0.834    -0.279     0.200
     0.885    -0.939     0.200
     0.924     0.884     0.200
     1.085    -1.104     0.200
     0.519     0.260     0.200
     0.775    -0.072     0.200
     0.831    -0.074     0.200
     0.896    -0.859     0.200
     0.922     1.163     0.200
     1.097    -1.057     0.200
     1.077     0.145     0.200
     0.467     0.134     0.200
     0.624    -0.124     0.200
     0.895    -0.330     0.200
     0.945     0.384     0.200
     1.080     0.642     0.200
     1.080    -0.186     0.200
     0.439     0.107     0.200
     0.614    -0.620     0.200
     1.052     0.497     0.200
     0.462     0.591     0.200
     0.842    -0.813     0.200
     0.902    -1.410     0.200
     0.501     0.110     0.200
     0.755    -0.063     0.200
     0.850    -0.800     0.200
     0.931    -0.927     0.200
     0.979     0.909     0.200
     1.059     0.023     0.200
     0.492     0.101     0.200
     0.584    -0.084     0.200
     0.744    -0.931     0.200
     0.908    -0.806     0.200
     0.937     0.088     0.200
     0.925     1.213     0.200
     1.068     0.143     0.200
     0.519     0.068     0.200
     0.635    -0.147     0.200
     0.927     0.057     0.200
     0.894     1.080     0.200
     0.965    -0.883     0.200
     0.498     0.050     0.200
     0.787    -0.181     0.200
     0.808    -0.323     0.200
     0.904    -1.245     0.200
     0.959     0.740     0.200
     1.077    -0.163     0.200
     0.540     0.307     0.200
     0.735    -0.231     0.200
     0.915    -0.686     0.200
     0.993    -1.493     0.200
     0.986     0.741     0.200
     1.009     0.253     0.200
     0.565     0.157     0.200
     0.583    -0.236     0.200
     0.566     0.336     0.200
     0.590    -0.065     0.200
     0.801    -1.125     0.200
     0.932    -0.803     0.200
     0.850     1.278     0.200
     0.991    -0.089     0.200
     0.546     0.342     0.200
     0.606    -0.619     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     1.087     1.181     0.200
     0.425     0.113     0.200
     0.439    -0.514     0.200
     0.709    -0.917     0.200
     0.289    -0.251     0.200
     0.335     0.708     0.200
     0.216    -0.365     0.200
     1.095     0.871     0.200
     0.293    -0.201     0.200
     0.357    -0.654     0.200
     1.039     0.775     0.200
     0.328     0.326     0.200
     0.740     1.283     0.200
     1.027     1.104     0.200
     0.291    -0.171     0.200
     0.360     0.178     0.200
     0.284    -0.280     0.200
     0.577     0.085     0.200
     0.854     1.557     0.200
     0.291     0.310     0.200
     1.008    -0.144     0.200
     0.472    -0.434     0.200
     0.435     0.779     0.200
     0.456    -0.436     0.200
     0.466    -0.074     0.200
     0.503    -0.630     0.200
     0.655     1.276     0.200
     0.643     1.648     0.200
     0.388    -0.494     0.200
     0.648     0.561     0.200
     0.880    -0.350     0.200
     0.943    -0.370     0.200
     1.021    -0.970     0.200
     0.216    -0.172     0.200
     0.216    -0.614     0.200
     0.447     0.363     0.200
     0.481     1.468     0.200
     0.758     0.335     0.200
     0.795     0.982     0.200
     0.968    -0.296     0.200
     1.066     1.750     0.200
     0.374     1.030     0.200
     0.770    -0.011     0.200
     0.942     0.207     0.200
     0.312    -0.179     0.200
     0.312    -0.010     0.200
     0.534    -0.321     0.200
     0.831    -0.449     0.200
     0.850     1.414     0.200
     0.995    -0.042     0.200
     0.250    -0.176     0.200
     0.356    -0.119     0.200
     0.692     1.729     0.200
     0.787    -0.368     0.200
     0.787    -0.649     0.200
     0.888     0.765     0.200
     0.957     0.119     0.200
     0.957     0.010     0.200
     0.567    -1.121     0.200
     0.549    -0.027     0.200
     0.549    -0.136     0.200
     0.605     0.768     0.200
     0.605     0.637     0.200
     0.829     0.632     0.200
     0.996     0.583     0.200
     1.029    -0.086     0.200
     1.078    -0.036     0.200
     0.291    -0.426     0.200
     0.351     0.192     0.200
     0.351     0.502     0.200
     0.592     1.917     0.200
     0.734     1.719     0.200
     0.863     1.456     0.200
     0.899    -1.626     0.200
     0.937    -0.170     0.200
     1.066     1.276     0.200
     0.772     0.432     0.200
     0.982    -0.793     0.200
     0.997    -0.652     0.200
     1.070    -0.771     0.200
     0.237    -0.193     0.200
     0.325     0.155     0.200
     0.576     1.865     0.200
     0.537    -0.652     0.200
     0.680     1.695     0.200
     0.791     0.413     0.200
     0.818    -0.371     0.200
     0.860     0.912     0.200
     0.983     0.477     0.200
     1.065     0.442     0.200
     0.195    -0.185     0.200
     0.412     0.501     0.200
     0.412     0.634     0.200
     0.765     0.007     0.200
     0.765     0.536     0.200
     0.909     0.123     0.200
     0.970     0.308     0.200
     0.982    -0.086     0.200
     0.982     0.125     0.200
     0.379     0.035     0.200
     1.058     0.395     0.200
     0.432    -1.314     0.200
     0.759    -0.030     0.200
     0.938    -0.227     0.200
     0.997    -0.746     0.200
     0.988    -0.280     0.200
     1.081    -0.815     0.200
     0.161    -0.259     0.200
     0.405    -0.169     0.200
     0.421     0.393     0.200
     0.421     0.391     0.200
     0.685     1.860     0.200
     0.786     0.586     0.200
     0.786     0.295     0.200
     0.935     0.229     0.200
     1.018     0.027     0.200
     0.425    -0.165     0.200
     0.677    -0.608     0.200
     0.721     0.291     0.200
     0.881    -0.656     0.200
     0.910    -0.101     0.200
     0.218    -0.197     0.200
     0.372    -0.048     0.200
     0.372     0.190     0.200
     0.494     0.035     0.200
     0.494    -0.648     0.200
     0.501     0.282     0.200
     0.501    -0.972     0.200
     0.629     1.892     0.200
     0.658     1.679     0.200
     0.693    -0.747     0.200
     0.781    -0.613     0.200
     0.852    -1.127     0.200
     0.987     0.419     0.200
     0.970    -0.122     0.200
     0.970     0.163     0.200
     1.048    -0.272     0.200
     0.319     0.511     0.200
     0.546    -0.263     0.200
     0.546    -0.388     0.200
     0.568    -0.706     0.200
     0.568    -0.319     0.200
     0.607     0.429     0.200
     0.737    -0.748     0.200
     0.737    -0.976     0.200
     0.830     0.325     0.200
     1.031    -0.849     0.200
     1.099     0.441     0.200
     0.373    -0.059     0.200
     0.373    -0.133     0.200
     0.492    -0.117     0.200
     0.520    -0.415     0.200
     0.675    -1.005     0.200
     0.675    -1.169     0.200
     0.775    -0.132     0.200
     0.957     0.258     0.200
     0.957     0.410     0.200
     1.060    -0.171     0.200
     0.214    -0.348     0.200
     0.357    -0.314     0.200
     0.357    -0.052     0.200
     0.509    -1.252     0.200
     0.502    -0.213     0.200
     0.502    -0.565     0.200
     0.502    -0.420     0.200
     0.688    -1.217     0.200
     0.688    -1.631     0.200
     0.795    -0.195     0.200
     0.980     0.301     0.200
     0.980    -0.012     0.200
     0.977    -0.617     0.200
     1.060     0.270     0.200
     1.060     0.403     0.200
     0.384     0.154     0.200
     0.384     0.130     0.200
     0.490    -0.443     0.200
     0.588    -1.152     0.200
     0.588    -0.770     0.200
     0.611    -0.570     0.200
     0.757    -0.381     0.200
     0.911    -0.195     0.200
     0.911    -0.046     0.200
     1.043    -0.299     0.200
     0.291    -0.085     0.200
     0.367     0.101     0.200
     0.506    -0.570     0.200
     0.583    -0.872     0.200
     0.610    -0.955     0.200
     0.734     1.478     0.200
     0.800    -0.468     0.200
     0.926    -0.167     0.200
     1.050    -0.237     0.200
     0.456    -0.418     0.200
     0.456    -0.681     0.200
     0.427     0.607     0.200
     0.427     0.636     0.200
     0.452     1.249     0.200
     0.688     2.266     0.200
     0.758    -1.419     0.200
     0.921     0.409     0.200
     0.976    -1.359     0.200
     0.976    -1.196     0.200
     0.971     0.038     0.200
     0.971     0.567     0.200
     1.058     0.365     0.200
     0.198    -0.260     0.200
     0.377    -1.003     0.200
     0.377    -0.475     0.200
     0.377    -0.194     0.200
     0.493    -0.996     0.200
     0.477    -1.187     0.200
     0.477    -0.318     0.200
     0.637     1.134     0.200
     0.718    -1.145     0.200
     0.718    -1.306     0.200
     0.785    -0.154     0.200
     0.785     0.066     0.200
     0.868     1.015     0.200
     0.931     1.340     0.200
     0.985     0.405     0.200
     0.985     0.261     0.200
     1.009    -1.004     0.200
     1.029     0.412     0.200
     1.029     0.242     0.200
     0.181    -0.317     0.200
     0.442     0.056     0.200
     0.403     0.050     0.200
     0.403     0.620     0.200
     0.403     0.901     0.200
     0.479     0.095     0.200
     0.666     2.095     0.200
     0.778    -0.007     0.200
     0.778    -0.535     0.200
     0.760    -1.254     0.200
     0.906    -0.745     0.200
     0.989    -1.096     0.200
     0.989    -1.604     0.200
     0.989    -1.764     0.200
     0.965    -0.321     0.200
     0.965     0.651     0.200
     0.996    -0.234     0.200
     1.052     0.263     0.200
     1.052     0.083     0.200
     0.212    -0.343     0.200
     0.381    -0.612     0.200
     0.381    -0.410     0.200
     0.381    -0.050     0.200
     0.491    -0.704     0.200
     0.491    -0.942     0.200
     0.487    -0.594     0.200
     0.639     0.078     0.200
     0.650     1.735     0.200
     0.706    -1.334     0.200
     0.706    -1.229     0.200
     0.777     0.080     0.200
     0.930     0.644     0.200
     0.972     0.336     0.200
     1.001    -0.885     0.200
     1.035    -0.035     0.200
     0.449     0.401     0.200
     0.485    -0.282     0.200
     0.485    -0.003     0.200
     0.491    -0.181     0.200
     0.516    -0.031     0.200
     0.516    -0.141     0.200
     0.677    -0.092     0.200
     0.717    -0.111     0.200
     0.717     0.088     0.200
     0.802    -0.983     0.200
     0.781    -0.338     0.200
     0.851     0.448     0.200
     0.851     0.335     0.200
     0.851     0.560     0.200
     1.011    -1.144     0.200
     1.014    -1.214     0.200
     1.091    -1.108     0.200
     0.370    -0.091     0.200
     0.370     0.149     0.200
     0.499    -0.708     0.200
     0.499    -0.120     0.200
     0.567    -1.267     0.200
     0.567    -1.132     0.200
     0.616     0.273     0.200
     0.770    -0.724     0.200
     0.814    -0.994     0.200
     0.932     0.127     0.200
     0.932    -0.072     0.200
     1.066    -0.039     0.200
     1.097    -0.358     0.200
     1.097    -1.191     0.200
     0.269     0.051     0.200
     0.269    -0.043     0.200
     0.512     0.312     0.200
     0.577    -1.642     0.200
     0.577    -1.291     0.200
     0.603     0.029     0.200
     0.603    -0.194     0.200
     0.866    -0.422     0.200
     0.871     0.434     0.200
     1.011    -0.448     0.200
     1.011     0.212     0.200
     1.080    -0.637     0.200
     1.082    -0.987     0.200
     1.076    -0.487     0.200
     1.076    -0.175     0.200
     0.446    -0.977     0.200
     0.438    -0.059     0.200
     0.438     0.535     0.200
     0.446     0.733     0.200
     0.747     0.702     0.200
     0.936     0.046     0.200
     0.961    -1.027     0.200
     0.974     0.289     0.200
     0.974    -0.359     0.200
     0.265    -0.097     0.200
     0.471     1.615     0.200
     0.495    -0.341     0.200
     0.589    -0.105     0.200
     0.589     0.262     0.200
     0.589    -0.324     0.200
     0.766    -0.464     0.200
     0.766    -1.018     0.200
     0.766    -1.284     0.200
     0.808    -0.941     0.200
     0.849     1.330     0.200
     0.849     0.893     0.200
     0.497    -0.028     0.200
     0.497     0.316     0.200
     0.534     1.121     0.200
     0.601    -0.216     0.200
     0.601    -0.419     0.200
     0.681    -0.534     0.200
     0.842     0.260     0.200
     0.939    -0.218     0.200
     0.939     0.188     0.200
     0.968    -0.201     0.200
     0.968     0.034     0.200
     1.004    -1.883     0.200
     1.090     0.509     0.200
     0.355     0.020     0.200
     0.371     0.422     0.200
     0.371     0.340     0.200
     0.539    -0.832     0.200
     0.539    -0.421     0.200
     0.533    -0.719     0.200
     0.652    -1.208     0.200
     0.780    -0.270     0.200
     0.780    -0.590     0.200
     0.797     1.562     0.200
     0.847     0.254     0.200
     0.899     0.173     0.200
     0.983     0.137     0.200
     0.983    -0.152     0.200
     0.983     0.020     0.200
     1.065    -0.691     0.200
     0.134    -0.196     0.200
     0.310    -1.162     0.200
     0.459    -0.649     0.200
     0.516    -0.485     0.200
     0.516    -0.356     0.200
     0.895    -0.746     0.200
     0.897    -0.673     0.200
     1.091     0.965     0.200
     0.392     0.295     0.200
     0.449    -0.740     0.200
     0.487     0.400     0.200
     0.749    -0.617     0.200
     0.997    -0.404     0.200
     0.311    -0.782     0.200
     0.311    -0.675     0.200
     0.463     0.071     0.200
     0.463     0.244     0.200
     0.512     0.184     0.200
     0.726     0.024     0.200
     0.826    -0.711     0.200
     0.894    -1.288     0.200
     0.896    -0.993     0.200
     1.001     0.217     0.200
     1.042     0.360     0.200
     1.089     0.558     0.200
     0.320    -0.600     0.200
     0.461    -0.225     0.200
     0.506     0.188     0.200
     0.887    -0.840     0.200
     0.897    -1.855     0.200
     1.080     0.426     0.200
     0.315    -0.636     0.200
     0.315    -0.810     0.200
     0.460     0.455     0.200
     0.460     0.203     0.200
     0.511     0.138     0.200
     0.723     1.175     0.200
     0.723     0.144     0.200
     0.824    -0.016     0.200
     0.824    -0.266     0.200
     0.891    -0.555     0.200
     0.891    -0.364     0.200
     0.881     1.430     0.200
     0.897    -1.156     0.200
     0.897    -1.343     0.200
     0.997    -0.253     0.200
     1.039     0.596     0.200
     1.086     0.957     0.200
     0.305    -0.409     0.200
     0.353    -0.261     0.200
     0.516    -0.152     0.200
     0.516    -0.363     0.200
     0.520     1.812     0.200
     0.607    -0.793     0.200
     0.701     1.625     0.200
     0.773     1.091     0.200
     0.992    -0.563     0.200
     1.081     1.328     0.200
     1.081     1.494     0.200
     0.403     0.181     0.200
     0.403     0.183     0.200
     0.444    -1.360     0.200
     0.479     0.296     0.200
     0.665     1.192     0.200
     0.758    -0.616     0.200
     0.964    -0.273     0.200
     0.990    -1.367     0.200
     0.994    -0.071     0.200
     0.994     0.223     0.200
     1.050    -0.838     0.200
     0.353    -0.088     0.200
     0.605    -0.645     0.200
     0.849    -0.662     0.200
     0.913     0.225     0.200
     1.002    -0.808     0.200
     0.265    -0.289     0.200
     0.342    -0.751     0.200
     0.422     0.457     0.200
     0.422     0.155     0.200
     0.588    -0.017     0.200
     0.588    -0.337     0.200
     0.588    -0.848     0.200
     0.736     0.018     0.200
     0.776    -1.815     0.200
     0.776    -1.235     0.200
     0.852     0.944     0.200
     0.961    -1.043     0.200
     0.961    -1.162     0.200
     1.038     0.584     0.200
     1.038    -0.056     0.200
     1.089     0.167     0.200
     1.089    -0.012     0.200
     1.089     0.706     0.200
     0.302    -0.167     0.200
     0.346     0.559     0.200
     0.346    -0.775     0.200
     0.534    -0.965     0.200
     0.534    -0.147     0.200
     0.586     0.181     0.200
     0.600    -1.219     0.200
     0.796     0.390     0.200
     0.850     0.665     0.200
     0.936    -0.281     0.200
     1.036    -0.550     0.200
     0.352    -0.630     0.200
     0.439     0.518     0.200
     0.439     0.912     0.200
     0.525    -0.532     0.200
     0.525    -0.637     0.200
     0.753    -0.232     0.200
     0.842    -1.154     0.200
     0.842    -0.483     0.200
     0.789     0.981     0.200
     0.903    -1.414     0.200
     1.030     0.558     0.200
     1.030     0.695     0.200
     1.050     0.604     0.200
     1.100     0.940     0.200
     0.463    -0.335     0.200
     0.463    -0.264     0.200
     0.487     0.618     0.200
     0.487     0.790     0.200
     0.498     0.134     0.200
     0.498     0.025     0.200
     0.738    -0.357     0.200
     0.714     0.424     0.200
     0.831    -1.054     0.200
     0.802    -0.070     0.200
     0.893     0.691     0.200
     0.893     0.871     0.200
     1.042    -1.453     0.200
     1.045    -1.114     0.200
     1.098    -0.841     0.200
     1.098    -1.005     0.200
     0.418     0.796     0.200
     0.550     0.593     0.200
     0.550     0.699     0.200
     0.550     0.550     0.200
     0.733     0.237     0.200
     0.915     0.437     0.200
     0.915    -2.442     0.200
     0.915    -1.868     0.200
     1.018     0.158     0.200
     1.018    -0.530     0.200
     1.072    -0.273     0.200
     0.265     0.589     0.200
     0.343    -0.378     0.200
     0.524    -0.435     0.200
     0.643    -0.745     0.200
     0.643    -0.635     0.200
     0.772     1.699     0.200
     0.738     1.444     0.200
     0.788    -0.606     0.200
     0.788    -0.146     0.200
     0.894     0.235     0.200
     1.044     0.674     0.200
     1.002    -0.629     0.200
     1.041    -2.385     0.200
     1.041    -1.385     0.200
     0.999     0.081     0.200
     1.014     0.044     0.200
     0.350    -0.050     0.200
     0.350    -0.143     0.200
     0.516    -1.149     0.200
     0.644    -1.369     0.200
     0.644    -1.182     0.200
     0.694     1.600     0.200
     0.792    -0.065     0.200
     0.881     1.011     0.200
     0.959     0.120     0.200
     1.089    -0.103     0.200
     1.089     0.077     0.200
     0.366     0.182     0.200
     0.366     0.002     0.200
     0.501    -0.312     0.200
     0.634    -1.034     0.200
     0.775    -0.046     0.200
     0.890     0.761     0.200
     0.939     0.091     0.200
     0.939     0.278     0.200
     0.934     0.211     0.200
     1.073    -0.018     0.200
     1.095    -0.728     0.200
     1.095    -0.892     0.200
     0.318    -1.074     0.200
     0.318    -0.340     0.200
     0.467     0.312     0.200
     0.524     0.099     0.200
     0.524    -0.143     0.200
     0.782     1.023     0.200
     0.787     1.519     0.200
     0.787     1.987     0.200
     0.927     0.666     0.200
     0.927    -0.123     0.200
     0.266    -0.025     0.200
     0.593    -0.276     0.200
     0.583     0.914     0.200
     0.662    -0.060     0.200
     0.830    -0.349     0.200
     0.882     0.287     0.200
     0.909     0.304     0.200
     0.917     0.750     0.200
     0.385    -0.300     0.200
     0.482     0.426     0.200
     0.702    -0.925     0.200
     0.771    -0.864     0.200
     0.932    -1.671     0.200
     0.965    -0.008     0.200
     0.999     0.011     0.200
     0.376    -0.288     0.200
     0.438    -0.429     0.200
     0.497    -0.324     0.200
     0.761     0.176     0.200
     0.751    -0.358     0.200
     0.866    -1.180     0.200
     1.016     0.080     0.200
     1.014     0.243     0.200
     1.069     1.155     0.200
     0.407     0.608     0.200
     0.407     0.139     0.200
     0.568    -0.155     0.200
     0.693    -1.373     0.200
     0.807    -1.502     0.200
     0.845    -0.182     0.200
     0.842    -0.135     0.200
     0.993    -2.808     0.200
     1.009     1.198     0.200
     0.209    -0.239     0.200
     0.465     0.425     0.200
     0.540     0.120     0.200
     0.640     1.918     0.200
     0.703     1.525     0.200
     0.759     1.257     0.200
     0.966     2.106     0.200
     1.048     0.787     0.200
     0.911     1.014     0.200
     0.911     0.885     0.200
     0.968     0.970     0.200
     0.968     1.247     0.200
     1.004     0.218     0.200
     1.060     0.403     0.200
     1.060     1.005     0.200
     0.413     1.222     0.200
     0.678     1.955     0.200
     0.917    -0.039     0.200
     0.917     0.383     0.200
     0.977     0.377     0.200
     0.990    -0.053     0.200
     1.061     0.386     0.200
     1.061     0.167     0.200
     0.524    -0.675     0.200
     0.680    -0.713     0.200
     0.770     0.194     0.200
     0.784    -1.917     0.200
     0.784    -0.997     0.200
     0.948    -0.066     0.200
     0.973    -0.342     0.200
     1.053    -1.460     0.200
     0.262    -0.092     0.200
     0.800     1.440     0.200
     0.826     0.461     0.200
     0.826     0.351     0.200
     1.083     0.457     0.200
     1.083     0.593     0.200
     0.813    -1.145     0.200
     0.908     1.173     0.200
     0.997    -1.240     0.200
     0.709    -1.006     0.200
     0.754    -0.648     0.200
     0.754    -0.418     0.200
     0.862    -0.114     0.200
     0.945     0.739     0.200
     0.948     0.200     0.200
     0.948     0.480     0.200
     0.592    -1.413     0.200
     0.803     0.331     0.200
     0.886    -0.934     0.200
     0.946     0.631     0.200
     1.044     0.274     0.200
     0.586    -1.864     0.200
     0.796     0.971     0.200
     0.897    -0.886     0.200
     0.943     0.690     0.200
     1.050    -0.072     0.200
     0.292    -0.141     0.200
     0.292     0.109     0.200
     0.889    -0.043     0.200
     0.496     0.094     0.200
     0.914    -0.690     0.200
     0.914    -0.389     0.200
     0.998     0.504     0.200
     0.397     0.070     0.200
     0.399    -0.111     0.200
     0.954     0.333     0.200
     1.028    -1.429     0.200
     1.028    -1.550     0.200
     0.416    -0.884     0.200
     0.416    -0.454     0.200
     0.493     0.407     0.200
     0.495    -0.105     0.200
     0.759     1.183     0.200
     0.977     0.203     0.200
     0.977    -0.274     0.200
     1.061    -0.324     0.200
     0.418    -0.516     0.200
     0.418    -0.384     0.200
     0.497     0.266     0.200
     0.500    -0.285     0.200
     0.763     0.089     0.200
     0.763     1.034     0.200
     0.974     0.438     0.200
     0.974    -0.078     0.200
     1.065     0.087     0.200
     1.065    -0.022     0.200
     0.497     0.162     0.200
     0.964     0.159     0.200
     0.508     0.251     0.200
     0.753    -1.347     0.200
     0.860    -1.573     0.200
     0.489    -0.168     0.200
     0.944     0.023     0.200
     0.665    -1.192     0.200
     0.829    -1.705     0.200
     0.915    -0.846     0.200
     0.543    -0.298     0.200
     0.736    -1.066     0.200
     0.917    -1.419     0.200
     0.995    -0.330     0.200
     0.984     0.898     0.200
     1.007    -0.889     0.200
     0.479     0.565     0.200
     0.629    -0.997     0.200
     0.900    -0.974     0.200
     0.949    -2.000     0.200
     0.468     0.195     0.200
     0.957    -2.566     0.200
     0.472    -0.585     0.200
     1.093     1.597     0.200
     0.500    -0.130     0.200
     0.517     0.005     0.200
     0.842    -1.171     0.200
     1.002    -1.979     0.200
     1.018     1.025     0.200
     0.473     1.349     0.200
     0.640    -0.674     0.200
     0.773    -0.955     0.200
     0.889    -1.489     0.200
     0.958    -1.873     0.200
     1.097     0.542     0.200
     0.499     0.489     0.200
     0.805    -1.154     0.200
     0.515     0.223     0.200
     0.780    -0.393     0.200
     0.825    -0.707     0.200
     0.897     0.516     0.200
     0.927     1.048     0.200
     1.077    -0.792     0.200
     0.542    -1.004     0.200
     0.674    -0.625     0.200
     0.513    -0.790     0.200
     0.759    -0.248     0.200
     0.858    -1.646     0.200
     1.047    -0.169     0.200
     0.513     0.407     0.200
     0.570     0.002     0.200
     0.960     0.081     0.200
     0.484     0.456     0.200
     0.532     0.048     0.200
     0.777    -1.159     0.200
     0.858    -0.902     0.200
     0.955     1.052     0.200
     1.031     0.660     0.200
     0.478     0.381     0.200
     0.566    -0.330     0.200
     0.718    -1.187     0.200
     0.886    -1.537     0.200
     0.938    -0.858     0.200
     0.943     0.947     0.200
     1.039    -2.004     0.200
     1.043     0.649     0.200
     0.573     0.250     0.200
     0.580    -0.296     0.200
     0.845     1.214     0.200
     0.924    -1.904     0.200
     1.003     0.376     0.200
     0.522    -0.791     0.200
     0.493    -0.807     0.200
     0.637    -0.123     0.200
     0.785    -0.686     0.200
     0.517    -0.227     0.200
     0.751    -1.018     0.200
     0.872    -1.148     0.200
     0.954    -0.110     0.200
     0.977     1.044     0.200
     1.040    -0.609     0.200
     0.466     0.030     0.200
     0.613    -1.307     0.200
     1.071     0.627     0.200
     0.490    -0.435     0.200
     0.598    -0.405     0.200
     0.483     0.626     0.200
     0.609    -0.709     0.200
     0.756     0.950     0.200
     0.930    -0.848     0.200
     0.930     1.582     0.200
     1.080     0.984     0.200
     0.569     0.199     0.200
     0.684    -0.024     0.200
     0.868    -0.450     0.200
     0.938    -1.343     0.200
     1.023    -2.124     0.200
     0.846     1.445     0.200
     0.508     0.385     0.200
     0.866    -1.255     0.200
     0.983     1.487     0.200
     0.945     0.010     0.200
     1.049    -0.527     0.200
     0.615    -0.405     0.200
     0.783     0.895     0.200
     0.900     0.854     0.200
     0.945    -0.846     0.200
     0.934     0.329     0.200
     0.557     1.219     0.200
     0.622    -0.492     0.200
     0.512    -0.107     0.200
     0.763    -0.764     0.200
     0.885     0.246     0.200
     0.924     1.269     0.200
     1.085    -2.080     0.200
     1.088    -0.815     0.200
     0.519     0.101     0.200
     0.775    -0.608     0.200
     0.831    -0.050     0.200
     0.922     1.275     0.200
     1.097    -1.486     0.200
     1.077    -0.188     0.200
     0.467    -0.320     0.200
     0.624    -0.944     0.200
     0.895    -1.791     0.200
     1.080     0.358     0.200
     1.080     1.209     0.200
     0.439     0.039     0.200
     0.614    -1.366     0.200
     1.052     0.965     0.200
     0.462    -0.640     0.200
     0.842    -0.279     0.200
     0.501     0.873     0.200
     0.850    -1.237     0.200
     0.931     0.048     0.200
     0.492     0.103     0.200
     0.584    -0.244     0.200
     0.908    -1.677     0.200
     0.937     0.434     0.200
     0.925     1.358     0.200
     1.068     1.368     0.200
     0.519    -0.414     0.200
     0.635    -0.783     0.200
     0.801    -1.410     0.200
     0.927     0.844     0.200
     0.894     0.974     0.200
     0.498     0.239     0.200
     0.787    -1.524     0.200
     0.808    -1.253     0.200
     1.077    -1.072     0.200
     0.540    -0.082     0.200
     0.735    -1.265     0.200
     0.915    -1.511     0.200
     0.993    -0.575     0.200
     1.009     0.029     0.200
     0.566    -0.651     0.200
     0.590    -0.978     0.200
     0.850     1.444     0.200
     0.546     0.104     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.004
 1.10    0.004
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00   -0.1
 1.10   -0.1
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.1)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050    -7.500   Sg = red circles; average =  -0.1 (dashed red line)
EOF
gmt end
