#!/bin/bash
gmt begin hubbard5.7_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic hubbard5.7'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.725
   137.000     1.817
   137.500     1.911
   138.000     2.009
   138.500     2.111
   139.000     2.216
   139.500     2.325
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.801
   142.000     2.931
   142.500     3.066
   143.000     3.206
   143.500     3.352
   144.000     3.502
   144.500     3.658
   145.000     3.821
   145.500     3.989
   146.000     4.164
   146.500     4.345
   147.000     4.534
   147.500     4.729
   148.000     4.932
   148.500     5.143
   149.000     5.362
   149.500     5.591
   150.000     5.829
   150.500     6.077
   151.000     6.335
   151.500     6.604
   152.000     6.882
   152.500     7.171
   153.000     7.470
   153.500     7.779
   154.000     8.099
   154.500     8.431
   155.000     8.773
   155.500     9.126
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.693
   145.500     0.269
   146.000     1.295
   146.500     2.364
   147.000     3.468
   147.500     4.601
   148.000     5.762
   148.500     6.948
   149.000     8.158
   149.500     9.391
   150.000    10.645
   150.500    11.921
   151.000    13.217
   151.500    14.533
   152.000    15.868
   152.500    17.222
   153.000    18.593
   153.500    19.982
   154.000    21.389
   154.500    22.813
   155.000    24.254
   155.500    25.713
   156.000    27.188
   156.500    28.680
   157.000    30.189
   157.500    31.714
   158.000    33.256
   158.500    34.814
   159.000    36.390
   159.500    37.981
   160.000    39.589
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.696
   145.500     0.071
   146.000     0.765
   146.500     1.407
   147.000     2.006
   147.500     2.567
   148.000     3.092
   148.500     3.584
   149.000     4.050
   149.500     4.496
   150.000     4.927
   150.500     5.344
   151.000     5.751
   151.500     6.148
   152.000     6.537
   152.500     6.918
   153.000     7.294
   153.500     7.665
   154.000     8.034
   154.500     8.401
   155.000     8.765
   155.500     9.126
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   140.235     0.525     0.200
   142.299    -2.309     0.200
   143.147     1.142     0.200
   148.729    -0.250     0.200
   151.095     1.091     0.200
   140.330     0.204     0.200
   146.550    -0.161     0.200
   148.730    -1.132     0.200
   144.316    -0.130     0.200
   159.676    -2.156     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   149.934     4.385     0.200
   149.964     4.298     0.200
   149.954     4.703     0.200
   149.826     3.593     0.200
   149.912     4.323     0.200
   149.097     3.172     0.200
   149.527     2.271     0.200
   149.569     2.877     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   159.890    37.839     0.200
   157.826    31.183     0.200
   159.940    37.615     0.200
   161.479    43.782     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   149.962     5.191     0.200
   135.908     0.852     0.200
   149.291     4.797     0.200
   149.938     5.174     0.200
   135.707     0.424     0.200
   138.783     3.343     0.200
   139.334     6.390     0.200
   139.791     7.456     0.200
   141.841     6.578     0.200
   144.302     2.561     0.200
   146.413     4.765     0.200
   151.313     7.242     0.200
   149.112     4.484     0.200
   149.129     4.931     0.200
   138.391     5.796     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
