#!/bin/bash
gmt begin hubbard5.7_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P hubbard5.7'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.716
    79.000     8.541
    80.000     7.450
    81.000     6.444
    82.000     5.525
    83.000     4.690
    84.000     3.938
    85.000     3.274
    86.000     2.696
    87.000     2.195
    88.000     1.799
    89.000     1.499
    90.000     1.241
    91.000     1.014
    92.000     0.813
    93.000     0.631
    94.000     0.465
    95.000     0.320
    96.000     0.200
    97.000     0.107
    98.000     0.042
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.702     6.958     0.200
    17.561     3.375     0.200
    17.664     2.097     0.200
    18.769    -0.494     0.200
    20.708     0.835     0.200
    21.720     0.552     0.200
    22.850     1.521     0.200
    25.425    -0.874     0.200
    16.685     6.474     0.200
    17.627     2.195     0.200
    17.545     2.215     0.200
    21.020     2.144     0.200
    21.034     2.386     0.200
    21.449     2.313     0.200
    21.661     1.240     0.200
    21.604     4.857     0.200
    22.219     4.468     0.200
    22.713     3.320     0.200
    23.473     5.011     0.200
    23.631     3.497     0.200
    24.093     3.281     0.200
    25.126    -2.138     0.200
    25.274     2.024     0.200
    25.368     3.171     0.200
    25.483     2.625     0.200
    25.507     2.906     0.200
    25.552     3.000     0.200
    26.566     3.822     0.200
    33.015    -0.348     0.200
    38.408    -0.621     0.200
    40.568     1.864     0.200
    46.341     0.804     0.200
    49.082     0.429     0.200
    49.558     0.898     0.200
    49.558     1.298     0.200
    51.487     0.518     0.200
    52.393     0.669     0.200
    55.419     1.443     0.200
    55.610     0.069     0.200
    58.671     4.515     0.200
    58.791     1.381     0.200
    58.834     4.781     0.200
    59.062    -1.304     0.200
    59.375     4.732     0.200
    59.753     0.625     0.200
    61.185     0.140     0.200
    62.310     0.562     0.200
    62.660     1.225     0.200
    63.681     0.252     0.200
    65.240    -0.247     0.200
    67.128     1.130     0.200
    67.128     1.630     0.200
    67.281     0.162     0.200
    68.484     1.086     0.200
    68.916     1.396     0.200
    68.982     1.283     0.200
    69.205     0.800     0.200
    69.421     1.161     0.200
    69.575     0.809     0.200
    70.345     3.982     0.200
    70.694     1.051     0.200
    71.011     1.025     0.200
    72.699     0.286     0.200
    72.684    -0.027     0.200
    73.135    -2.704     0.200
    73.658     1.215     0.200
    76.126     0.945     0.200
    76.126     1.846     0.200
    76.176     0.660     0.200
    76.176     1.160     0.200
    78.199     1.003     0.200
    78.466     1.325     0.200
    79.446     0.450     0.200
    79.446     1.250     0.200
    79.488    -0.779     0.200
    81.178     1.124     0.200
    81.178     1.925     0.200
    84.751     1.115     0.200
    14.752     4.453     0.200
    15.695     7.070     0.200
    15.923     6.614     0.200
    17.552     2.015     0.200
    17.616     2.411     0.200
    21.027     2.253     0.200
    21.042     1.790     0.200
    21.259     1.754     0.200
    21.457     2.320     0.200
    21.668     1.153     0.200
    21.607     3.607     0.200
    22.223     3.015     0.200
    22.717     2.564     0.200
    22.767     2.339     0.200
    23.477     1.358     0.200
    24.098     0.621     0.200
    24.820     2.534     0.200
    25.134     1.984     0.200
    25.278     2.575     0.200
    25.373     2.509     0.200
    25.486     2.981     0.200
    25.510     2.961     0.200
    25.558     3.832     0.200
    26.381     5.382     0.200
    26.885     3.632     0.200
    29.088     2.150     0.200
    29.203     0.135     0.200
    29.399     1.593     0.200
    31.241    -0.885     0.200
    31.241     0.013     0.200
    33.022     2.083     0.200
    33.655     3.959     0.200
    35.274     0.941     0.200
    37.608     1.513     0.200
    39.141     1.117     0.200
    40.544    -1.552     0.200
    40.544    -0.951     0.200
    46.340     0.702     0.200
    49.078    -0.545     0.200
    49.078     0.354     0.200
    49.552     1.832     0.200
    49.552     2.031     0.200
    51.491     0.575     0.200
    52.396     0.329     0.200
    55.614     2.932     0.200
    56.875    -0.075     0.200
    56.875     0.526     0.200
    56.985     2.146     0.200
    58.429     1.990     0.200
    58.429     2.290     0.200
    58.786     1.502     0.200
    59.066    -0.443     0.200
    62.311     1.449     0.200
    62.653     2.160     0.200
    62.914     0.423     0.200
    62.914     0.923     0.200
    63.678     0.659     0.200
    65.064     0.284     0.200
    65.237     0.055     0.200
    65.977     1.376     0.200
    66.718     0.629     0.200
    67.134     0.983     0.200
    67.286     0.215     0.200
    67.663     0.637     0.200
    68.217     1.650     0.200
    68.238     1.014     0.200
    68.921     1.750     0.200
    69.457     1.126     0.200
    69.559     0.903     0.200
    69.581     0.664     0.200
    70.363     1.055     0.200
    70.520     0.899     0.200
    71.004     1.451     0.200
    71.498     1.463     0.200
    73.133     1.200     0.200
    73.133     2.000     0.200
    75.604     1.618     0.200
    76.124     0.845     0.200
    76.124     1.544     0.200
    76.175     0.557     0.200
    76.175     1.057     0.200
    78.198     1.199     0.200
    78.198     1.301     0.200
    78.346     1.379     0.200
    78.468     1.702     0.200
    79.444     0.349     0.200
    79.444     0.950     0.200
    81.178     2.013     0.200
    82.653     2.356     0.200
    84.748     2.519     0.200
    84.887     0.822     0.200
    17.798     4.274     0.200
    46.598    -2.699     0.200
    17.429     3.589     0.200
    17.566     3.406     0.200
    21.468     4.251     0.200
    21.847     1.714     0.200
    22.478     1.805     0.200
    25.157     2.934     0.200
    25.540     2.684     0.200
    26.281     1.951     0.200
    37.535     1.071     0.200
    59.598     1.095     0.200
    59.624     0.840     0.200
    88.638     0.314     0.200
    17.535     3.472     0.200
    25.499     3.035     0.200
    48.121     1.828     0.200
    17.535     3.628     0.200
    21.605     0.746     0.200
    21.674     4.352     0.200
    22.057     2.296     0.200
    22.448     0.950     0.200
    25.126     3.046     0.200
    25.126     3.466     0.200
    25.512     2.510     0.200
    25.933     4.340     0.200
    26.250     3.074     0.200
    53.666     0.260     0.200
    59.655     0.553     0.200
    88.668     0.778     0.200
    21.663    -0.025     0.200
    21.663     1.084     0.200
    22.833     1.792     0.200
    25.248     1.672     0.200
    35.172     0.828     0.200
    41.113     0.084     0.200
    50.138    -0.338     0.200
    88.552     1.418     0.200
    15.251     4.435     0.200
    16.169     2.648     0.200
    16.820     3.886     0.200
    16.926     3.971     0.200
    17.015     4.782     0.200
    17.518     3.529     0.200
    17.518     2.904     0.200
    17.562     3.008     0.200
    17.645     1.608     0.200
    18.284     3.035     0.200
    20.210     1.314     0.200
    21.006     0.590     0.200
    21.096     3.210     0.200
    21.096     3.616     0.200
    21.096     2.241     0.200
    21.635     1.312     0.200
    21.635     1.124     0.200
    21.635     1.515     0.200
    21.593     2.007     0.200
    21.698     2.689     0.200
    21.796     3.079     0.200
    21.796     2.211     0.200
    21.956     1.766     0.200
    21.956     1.219     0.200
    22.041     1.803     0.200
    22.205     3.208     0.200
    22.205     2.801     0.200
    22.430     1.207     0.200
    22.647     1.660     0.200
    22.719     2.750     0.200
    22.719     2.281     0.200
    22.977     2.296     0.200
    23.065     2.543     0.200
    23.206     2.845     0.200
    23.301     1.630     0.200
    23.306     4.153     0.200
    23.306     2.208     0.200
    23.529     0.897     0.200
    23.593     1.852     0.200
    23.604     2.032     0.200
    23.664     1.342     0.200
    23.807     2.608     0.200
    23.886     1.856     0.200
    23.927     2.181     0.200
    23.976     1.426     0.200
    23.977     2.309     0.200
    24.033     2.531     0.200
    24.062     4.049     0.200
    24.062     1.119     0.200
    24.099     1.695     0.200
    24.162     1.033     0.200
    24.162     0.830     0.200
    24.227     3.345     0.200
    24.227     1.962     0.200
    24.454     1.404     0.200
    24.509     2.767     0.200
    24.509     2.329     0.200
    24.582     3.702     0.200
    24.582     2.210     0.200
    25.029     3.537     0.200
    25.029     0.975     0.200
    25.111     2.109     0.200
    25.111     2.490     0.200
    25.111     2.353     0.200
    25.193     2.743     0.200
    25.193     1.899     0.200
    25.205     1.447     0.200
    25.220     1.833     0.200
    25.489     2.881     0.200
    25.536     2.831     0.200
    25.536     2.120     0.200
    25.694     3.507     0.200
    25.799     2.445     0.200
    25.914     2.435     0.200
    26.010     2.458     0.200
    26.064     3.246     0.200
    26.064     2.355     0.200
    26.112     2.347     0.200
    26.169     2.088     0.200
    26.251     1.730     0.200
    26.251     0.808     0.200
    26.411     1.745     0.200
    26.491     1.644     0.200
    26.503     3.083     0.200
    26.659     0.516     0.200
    26.659     0.172     0.200
    27.609     1.548     0.200
    27.615     3.274     0.200
    27.615     2.345     0.200
    27.681     1.865     0.200
    27.753     2.835     0.200
    27.753     0.789     0.200
    27.770     2.690     0.200
    27.770     2.104     0.200
    28.095     1.611     0.200
    28.984     1.767     0.200
    29.173     1.904     0.200
    29.247     2.035     0.200
    29.382     1.932     0.200
    29.426     4.157     0.200
    29.426     0.664     0.200
    29.599     2.733     0.200
    29.936     1.633     0.200
    31.002     1.655     0.200
    31.945     1.768     0.200
    32.987     3.183     0.200
    32.987     2.957     0.200
    32.987     2.144     0.200
    33.454     1.082     0.200
    33.465     0.695     0.200
    33.598     0.954     0.200
    33.598     0.493     0.200
    33.630     3.473     0.200
    33.630     2.122     0.200
    33.697    -1.407     0.200
    33.931     1.445     0.200
    35.068     2.106     0.200
    35.716     1.768     0.200
    36.231     1.553     0.200
    36.255     2.167     0.200
    36.833     0.463     0.200
    37.155     1.052     0.200
    37.330     0.560     0.200
    37.528     1.861     0.200
    37.528     1.337     0.200
    37.784     0.612     0.200
    38.311     2.629     0.200
    39.038     0.882     0.200
    39.030     3.238     0.200
    39.030     1.348     0.200
    39.030     2.464     0.200
    39.149     0.196     0.200
    39.647     2.186     0.200
    39.647     0.069     0.200
    39.729     1.673     0.200
    40.084     2.137     0.200
    40.277     1.677     0.200
    40.422     0.285     0.200
    40.570     0.529     0.200
    40.570     0.420     0.200
    41.050     1.172     0.200
    41.050     0.532     0.200
    41.334     1.455     0.200
    41.601     2.798     0.200
    41.755     1.924     0.200
    41.849     2.418     0.200
    41.849     1.472     0.200
    41.972     3.552     0.200
    45.224     0.709     0.200
    45.354     0.484     0.200
    45.354     1.281     0.200
    45.910     1.285     0.200
    48.685    -2.131     0.200
    49.101    -0.427     0.200
    50.033    -0.832     0.200
    50.167     0.179     0.200
    53.164     0.653     0.200
    53.684     1.082     0.200
    55.501     1.539     0.200
    55.501     0.640     0.200
    55.501     1.140     0.200
    55.501     0.843     0.200
    55.638     0.756     0.200
    56.898     0.768     0.200
    57.033    -0.691     0.200
    57.033     0.286     0.200
    57.581     1.336     0.200
    57.581     1.540     0.200
    57.581     1.735     0.200
    58.228    -0.161     0.200
    58.450     2.641     0.200
    58.809     1.744     0.200
    59.666     1.441     0.200
    59.910     1.854     0.200
    59.938     0.839     0.200
    60.208     1.011     0.200
    60.451    -1.076     0.200
    60.777    -1.800     0.200
    60.923     1.006     0.200
    61.112     1.326     0.200
    61.287     1.538     0.200
    62.309     0.856     0.200
    62.686     1.339     0.200
    63.891     1.057     0.200
    64.445     0.514     0.200
    64.688     0.648     0.200
    64.711     0.079     0.200
    64.976     0.470     0.200
    65.050     0.669     0.200
    65.050     0.271     0.200
    65.254     3.445     0.200
    65.345     0.956     0.200
    65.500     0.958     0.200
    65.742     1.187     0.200
    65.953     0.230     0.200
    66.154     0.740     0.200
    66.271     0.789     0.200
    66.358     0.732     0.200
    66.411     0.698     0.200
    66.443     0.288     0.200
    66.570     0.574     0.200
    66.686    -0.367     0.200
    66.692    -0.010     0.200
    66.702     0.630     0.200
    66.953     1.328     0.200
    67.107     0.753     0.200
    67.109     0.835     0.200
    67.187     3.343     0.200
    67.261     0.677     0.200
    67.611     0.965     0.200
    67.638     0.892     0.200
    67.638     0.791     0.200
    67.644     0.757     0.200
    67.692     1.146     0.200
    67.749     0.787     0.200
    67.925     0.582     0.200
    67.924     0.682     0.200
    67.960     1.158     0.200
    67.960     1.158     0.200
    68.007     0.765     0.200
    68.021     2.177     0.200
    68.021     0.482     0.200
    68.123     0.933     0.200
    68.213     0.775     0.200
    68.254     0.919     0.200
    68.379    -1.766     0.200
    68.461     0.915     0.200
    68.476     0.928     0.200
    68.476    -1.173     0.200
    68.544     0.101     0.200
    68.569     0.948     0.200
    68.664     0.752     0.200
    68.745     0.850     0.200
    68.769     1.300     0.200
    68.876     0.932     0.200
    68.895     0.310     0.200
    68.895     1.310     0.200
    68.946     0.892     0.200
    68.958     0.820     0.200
    68.969     0.852     0.200
    68.969    -0.046     0.200
    69.131    -0.133     0.200
    69.180     0.541     0.200
    69.193     0.863     0.200
    69.193     0.652     0.200
    69.287     0.482     0.200
    69.386    -0.438     0.200
    69.396     0.602     0.200
    69.426     0.620     0.200
    69.444    -0.193     0.200
    69.478     0.695     0.200
    69.561    -0.416     0.200
    69.576     4.992     0.200
    69.584     1.646     0.200
    69.829     1.236     0.200
    69.940     0.450     0.200
    70.017     0.578     0.200
    70.074     1.231     0.200
    70.087    -0.152     0.200
    70.161     0.288     0.200
    70.206     2.920     0.200
    70.250     0.550     0.200
    70.284     0.842     0.200
    70.298     1.255     0.200
    70.297     4.558     0.200
    70.319     0.026     0.200
    70.339     0.803     0.200
    70.344     1.870     0.200
    70.378     1.562     0.200
    70.527     0.648     0.200
    70.584     5.345     0.200
    70.648     0.620     0.200
    70.796     4.718     0.200
    70.812     0.622     0.200
    70.849     1.588     0.200
    70.848     5.152     0.200
    70.985     1.762     0.200
    71.029     1.401     0.200
    71.033     1.676     0.200
    71.119     0.254     0.200
    71.117     3.815     0.200
    71.075    -1.198     0.200
    71.141     1.020     0.200
    71.222     1.391     0.200
    71.241     0.514     0.200
    71.267     2.349     0.200
    71.308     0.613     0.200
    71.368     4.898     0.200
    71.441     1.408     0.200
    71.504     3.935     0.200
    71.511     0.082     0.200
    71.534     1.445     0.200
    71.540    -0.190     0.200
    71.565     1.073     0.200
    71.599     1.153     0.200
    71.873     0.903     0.200
    71.866     0.351     0.200
    71.814     1.772     0.200
    71.882     0.848     0.200
    71.902     1.227     0.200
    71.912     0.472     0.200
    71.957     0.306     0.200
    72.015    -0.245     0.200
    72.119     0.387     0.200
    72.180     0.764     0.200
    72.289     4.433     0.200
    72.297     1.361     0.200
    72.343     0.585     0.200
    72.574     3.263     0.200
    72.690     0.381     0.200
    72.788    -0.360     0.200
    72.832     0.280     0.200
    72.847     0.292     0.200
    72.885     3.745     0.200
    72.971     0.355     0.200
    73.158     0.550     0.200
    73.196     0.826     0.200
    73.276     1.407     0.200
    73.232     2.622     0.200
    73.369     1.224     0.200
    73.319     2.571     0.200
    73.462     0.653     0.200
    73.479     1.580     0.200
    73.546     2.096     0.200
    73.546     1.228     0.200
    73.666     1.457     0.200
    73.665    -2.741     0.200
    73.763     1.767     0.200
    73.779     3.365     0.200
    73.777     1.908     0.200
    73.869     2.060     0.200
    73.879     1.697     0.200
    73.879     0.408     0.200
    73.872     0.349     0.200
    73.970     2.737     0.200
    74.008     1.739     0.200
    74.008     1.433     0.200
    74.037     1.757     0.200
    74.046     3.830     0.200
    74.027     1.659     0.200
    74.250     2.007     0.200
    74.255     1.198     0.200
    74.267     1.946     0.200
    74.313     1.314     0.200
    74.382     1.169     0.200
    74.428     0.601     0.200
    74.490     1.540     0.200
    74.534     2.526     0.200
    74.545     0.717     0.200
    74.557    -2.250     0.200
    74.641     3.194     0.200
    74.930     1.141     0.200
    74.984     0.382     0.200
    75.019     1.080     0.200
    75.145     0.853     0.200
    75.233     0.999     0.200
    75.288     0.747     0.200
    75.388    -0.846     0.200
    75.382     2.121     0.200
    75.463     0.879     0.200
    75.634     1.043     0.200
    75.638     3.136     0.200
    75.768     1.643     0.200
    75.887     1.619     0.200
    75.937     2.404     0.200
    76.003     1.550     0.200
    76.060     0.747     0.200
    76.143     0.978     0.200
    76.215     0.881     0.200
    76.252     1.016     0.200
    76.252     0.414     0.200
    76.304    -0.919     0.200
    76.352     1.205     0.200
    76.474     1.760     0.200
    76.531     1.936     0.200
    76.524     1.972     0.200
    76.635     0.143     0.200
    76.665     0.358     0.200
    76.899     0.974     0.200
    77.032     1.109     0.200
    77.022     1.381     0.200
    77.517     0.669     0.200
    77.681     2.470     0.200
    77.691     2.417     0.200
    77.873     0.505     0.200
    77.970     0.299     0.200
    78.008     0.198     0.200
    77.966     1.183     0.200
    78.132     0.250     0.200
    78.151     0.240     0.200
    78.397     0.723     0.200
    78.430     0.313     0.200
    78.608    -2.561     0.200
    79.006    -0.747     0.200
    79.120     1.516     0.200
    79.396     4.790     0.200
    80.011     1.567     0.200
    80.011     0.739     0.200
    80.326     0.721     0.200
    81.179     1.112     0.200
    81.377     3.156     0.200
    83.349    -0.351     0.200
    83.536     5.483     0.200
    83.750     1.490     0.200
    83.808     0.691     0.200
    83.926     1.692     0.200
    84.763     2.342     0.200
    84.894     1.887     0.200
    85.060     1.553     0.200
    85.061     1.548     0.200
    85.224     1.132     0.200
    85.283     1.632     0.200
    85.596     1.275     0.200
    86.541     0.003     0.200
    86.610     1.019     0.200
    86.756     1.263     0.200
    86.988     0.489     0.200
    87.244     0.722     0.200
    87.978     1.342     0.200
    88.365     1.017     0.200
    88.686     1.752     0.200
    90.006     1.065     0.200
    90.700     0.680     0.200
    91.657    -0.703     0.200
    94.976     4.135     0.200
    96.853     0.513     0.200
    13.989     7.578     0.200
    14.450     6.780     0.200
    14.498    10.403     0.200
    14.622    10.760     0.200
    14.719     7.590     0.200
    14.723     9.416     0.200
    14.909     6.441     0.200
    14.917     8.306     0.200
    14.967     8.684     0.200
    15.340     8.950     0.200
    15.662     7.155     0.200
    16.817     3.777     0.200
    16.922     5.787     0.200
    17.012     4.834     0.200
    17.519     2.429     0.200
    17.953     3.857     0.200
    18.318     0.478     0.200
    18.323     0.996     0.200
    18.323     2.926     0.200
    20.215     1.317     0.200
    21.089     3.274     0.200
    21.089     2.173     0.200
    21.332     3.898     0.200
    21.654     0.760     0.200
    21.654     1.416     0.200
    21.693     2.307     0.200
    21.792     2.348     0.200
    21.958     1.164     0.200
    21.969     3.650     0.200
    22.042     1.736     0.200
    22.198     2.306     0.200
    22.429     1.492     0.200
    22.648     1.023     0.200
    22.680     2.408     0.200
    22.734     0.366     0.200
    22.734     2.280     0.200
    23.066     1.263     0.200
    23.308     0.939     0.200
    23.307     2.545     0.200
    23.521     1.017     0.200
    23.598     1.335     0.200
    23.605     2.353     0.200
    23.658     0.999     0.200
    23.808     2.413     0.200
    23.887     2.353     0.200
    23.928     2.113     0.200
    23.978     1.021     0.200
    23.978     1.888     0.200
    24.034     2.119     0.200
    24.165     1.730     0.200
    24.165     1.043     0.200
    24.507     2.684     0.200
    25.021     1.883     0.200
    25.112     1.375     0.200
    25.112     2.654     0.200
    25.187     2.281     0.200
    25.219     1.277     0.200
    25.484     2.704     0.200
    25.531     1.895     0.200
    25.913     0.078     0.200
    26.004     1.302     0.200
    26.165     1.626     0.200
    26.261     2.289     0.200
    26.261     1.937     0.200
    26.487     1.899     0.200
    26.496     1.315     0.200
    27.607     0.850     0.200
    28.098     1.648     0.200
    29.169     2.867     0.200
    33.627     1.380     0.200
    36.230     0.272     0.200
    37.545     1.396     0.200
    37.791    -0.494     0.200
    39.030     2.672     0.200
    40.574     0.736     0.200
    41.940     0.379     0.200
    48.683    -2.187     0.200
    49.105     0.072     0.200
    53.162     0.705     0.200
    55.637     0.498     0.200
    57.051     1.680     0.200
    57.586     2.133     0.200
    57.586     1.227     0.200
    58.456     2.739     0.200
    58.814     1.246     0.200
    59.653     1.041     0.200
    59.663     1.370     0.200
    59.747     0.435     0.200
    59.913     2.506     0.200
    59.952     1.480     0.200
    60.461    -1.808     0.200
    62.323     1.302     0.200
    62.686     2.979     0.200
    63.892    -0.014     0.200
    64.035    -0.258     0.200
    64.699     0.077     0.200
    65.328    -0.802     0.200
    68.251     1.566     0.200
    69.149    -0.282     0.200
    69.486     1.588     0.200
    69.587     1.958     0.200
    69.643     1.574     0.200
    71.035     1.600     0.200
    73.889     0.881     0.200
    73.889     0.154     0.200
    74.028     1.380     0.200
    75.161     3.699     0.200
    76.540     1.821     0.200
    78.379     1.832     0.200
    80.027     3.726     0.200
    81.180     2.844     0.200
    81.381     3.478     0.200
    81.381     2.423     0.200
    83.934     1.784     0.200
    84.899     1.799     0.200
    85.066     1.159     0.200
    85.067     1.551     0.200
    85.229     1.145     0.200
    85.289     1.542     0.200
    85.602     0.980     0.200
    88.687     1.424     0.200
    88.687     1.994     0.200
    59.908     1.526     0.200
    17.528     2.006     0.200
    18.328     0.163     0.200
    21.623    -0.069     0.200
    21.623     1.181     0.200
    22.050     0.168     0.200
    22.440     1.675     0.200
    22.716     0.938     0.200
    27.620    -0.239     0.200
    31.011     1.501     0.200
    59.898     1.801     0.200
    21.634    -0.358     0.200
    25.455     2.080     0.200
    68.196    -0.360     0.200
    15.918     4.629     0.200
    23.443     1.098     0.200
    25.559     1.658     0.200
    26.418    -0.510     0.200
    34.021    -1.630     0.200
    37.171     1.077     0.200
    37.412     1.018     0.200
    37.589     1.109     0.200
    37.589     1.570     0.200
    46.468    -0.873     0.200
    50.151    -0.577     0.200
    58.215    -0.589     0.200
    59.585     0.872     0.200
    59.576     1.020     0.200
    59.836     0.505     0.200
    60.849     0.116     0.200
    65.262    -0.939     0.200
    68.089    -0.275     0.200
    69.117    -0.715     0.200
    69.799     0.042     0.200
    74.032     0.073     0.200
    74.183     0.053     0.200
    88.608     1.394     0.200
    61.067    -0.396     0.200
    65.583    -0.548     0.200
    21.691    -0.651     0.200
    59.910     0.778     0.200
    60.925    -0.293     0.200
    64.713    -0.419     0.200
    65.445     0.196     0.200
    68.166    -0.180     0.200
    88.677     1.520     0.200
    65.441    -0.813     0.200
    68.163    -0.061     0.200
    15.435     2.830     0.200
    16.557     1.668     0.200
    16.743     1.977     0.200
    17.403     2.247     0.200
    18.758     1.930     0.200
    19.318     2.926     0.200
    20.718     0.741     0.200
    21.009     1.968     0.200
    21.024     2.361     0.200
    21.253     3.289     0.200
    22.697     2.615     0.200
    23.217     2.925     0.200
    23.547     2.357     0.200
    24.430     2.282     0.200
    25.055     3.119     0.200
    26.077     2.405     0.200
    26.686     3.010     0.200
    28.938     2.234     0.200
    30.738     2.399     0.200
    33.189     2.739     0.200
    33.413     3.558     0.200
    33.569     3.568     0.200
    33.856     2.055     0.200
    35.024     2.398     0.200
    36.663     3.274     0.200
    36.945     2.594     0.200
    37.452     1.358     0.200
    39.719     1.847     0.200
    39.870     2.296     0.200
    40.343     2.207     0.200
    40.632     1.785     0.200
    41.065     2.159     0.200
    41.089     2.844     0.200
    41.052     2.881     0.200
    41.312     2.665     0.200
    41.884     2.886     0.200
    42.020     1.644     0.200
    42.024     2.626     0.200
    42.188     3.403     0.200
    43.158     1.914     0.200
    43.293     3.063     0.200
    43.750     2.526     0.200
    44.556     2.406     0.200
    45.210     2.302     0.200
    46.862     4.585     0.200
    49.768     1.785     0.200
    51.921     1.541     0.200
    53.816     1.957     0.200
    55.055     2.283     0.200
    55.380     3.047     0.200
    57.883     3.453     0.200
    59.419     2.097     0.200
    59.516     1.800     0.200
    60.047     2.899     0.200
    62.691     1.740     0.200
    62.926     1.992     0.200
    63.193     2.254     0.200
    64.403     1.931     0.200
    65.049     1.455     0.200
    65.874     2.193     0.200
    67.948     1.281     0.200
    69.564     2.266     0.200
    69.564     2.032     0.200
    70.493     3.172     0.200
    70.986     3.181     0.200
    70.986     2.947     0.200
    71.690     3.920     0.200
    71.929     2.613     0.200
    73.609     2.460     0.200
    73.827     3.676     0.200
    75.880     3.211     0.200
    75.979     3.078     0.200
    77.394     2.064     0.200
    79.737     2.681     0.200
    79.875     3.077     0.200
    84.303     3.109     0.200
    87.476     0.866     0.200
    90.041     4.045     0.200
    92.641     3.336     0.200
    15.898     3.460     0.200
    15.898     3.975     0.200
    16.002     4.695     0.200
    16.186     1.995     0.200
    17.644     1.164     0.200
    17.714     4.130     0.200
    18.490     3.472     0.200
    20.426     3.369     0.200
    20.718     2.678     0.200
    21.128     3.177     0.200
    21.128     1.810     0.200
    22.138     3.564     0.200
    22.138     2.408     0.200
    22.637     3.306     0.200
    23.487     5.577     0.200
    23.544     3.175     0.200
    23.940     3.394     0.200
    23.940     2.925     0.200
    24.635     2.997     0.200
    24.648     2.996     0.200
    24.732     3.765     0.200
    25.055     3.462     0.200
    25.298     2.589     0.200
    25.948     5.391     0.200
    26.128     3.217     0.200
    26.205     2.383     0.200
    26.321     3.482     0.200
    26.320     3.787     0.200
    26.320     3.459     0.200
    26.686     4.026     0.200
    26.686     3.628     0.200
    28.308     3.448     0.200
    28.281     3.508     0.200
    28.938     2.835     0.200
    28.938     3.257     0.200
    29.282     2.788     0.200
    29.428     2.225     0.200
    30.004     2.952     0.200
    30.093     4.354     0.200
    30.406     2.730     0.200
    30.489     3.068     0.200
    30.489     2.857     0.200
    30.738     3.696     0.200
    30.738     3.368     0.200
    30.740     3.677     0.200
    30.775     3.643     0.200
    31.071     2.255     0.200
    31.191     3.459     0.200
    33.189     4.161     0.200
    33.189     3.052     0.200
    33.189     3.809     0.200
    33.413     2.894     0.200
    33.413     3.699     0.200
    33.456     3.909     0.200
    33.569     1.544     0.200
    33.569     2.544     0.200
    33.856     4.243     0.200
    33.856     4.040     0.200
    33.881     4.134     0.200
    34.073     2.716     0.200
    34.364     4.610     0.200
    34.796     3.559     0.200
    34.997     3.243     0.200
    35.024     2.835     0.200
    35.024     3.405     0.200
    35.249     3.237     0.200
    36.270     1.032     0.200
    36.461     3.640     0.200
    36.449     2.252     0.200
    36.648     3.108     0.200
    36.663     4.681     0.200
    36.663     4.040     0.200
    36.663     4.485     0.200
    36.945     3.656     0.200
    37.452     2.272     0.200
    37.452     1.959     0.200
    37.465     3.153     0.200
    37.915     3.716     0.200
    37.912     4.477     0.200
    38.165     2.182     0.200
    38.165     2.291     0.200
    38.348     3.906     0.200
    39.719     2.847     0.200
    39.719     2.316     0.200
    39.834     2.545     0.200
    39.804     3.315     0.200
    39.868     3.080     0.200
    39.870     5.273     0.200
    39.870     4.093     0.200
    39.870     4.491     0.200
    40.343     3.246     0.200
    40.343     3.418     0.200
    40.343     2.496     0.200
    40.600     4.038     0.200
    40.600     4.288     0.200
    40.632     2.652     0.200
    40.632     2.324     0.200
    40.707     3.063     0.200
    40.773     2.669     0.200
    40.946     3.795     0.200
    41.008     2.895     0.200
    41.065     4.003     0.200
    41.065     3.354     0.200
    41.089     5.179     0.200
    41.052     5.514     0.200
    41.052     5.131     0.200
    41.262     3.898     0.200
    41.797     3.093     0.200
    41.793     3.511     0.200
    42.020     2.472     0.200
    42.020     2.863     0.200
    42.020     2.254     0.200
    41.945     3.003     0.200
    42.024     5.180     0.200
    42.024     5.618     0.200
    42.188     1.802     0.200
    42.188     4.747     0.200
    42.079     4.708     0.200
    42.222     3.018     0.200
    42.288     3.583     0.200
    42.321     3.631     0.200
    42.390     3.240     0.200
    43.407     3.144     0.200
    43.538     3.027     0.200
    43.750     5.370     0.200
    43.750     4.604     0.200
    44.143     3.395     0.200
    44.940     3.136     0.200
    45.210     3.177     0.200
    45.210     3.309     0.200
    45.547     4.325     0.200
    45.474     3.480     0.200
    46.030     3.897     0.200
    46.797     3.707     0.200
    46.862     6.624     0.200
    46.862     5.726     0.200
    46.862     5.171     0.200
    47.036     2.864     0.200
    47.388     3.222     0.200
    47.387     3.035     0.200
    48.503     2.880     0.200
    48.713     3.367     0.200
    48.713     3.875     0.200
    48.713     3.750     0.200
    48.868     5.860     0.200
    49.359     3.917     0.200
    49.768     2.293     0.200
    49.768     2.097     0.200
    50.064     2.207     0.200
    50.289     3.298     0.200
    50.289     3.900     0.200
    50.660     3.095     0.200
    50.900     1.828     0.200
    51.895     2.057     0.200
    51.921     4.776     0.200
    51.921     3.690     0.200
    51.921     2.643     0.200
    52.835     1.547     0.200
    52.992     3.165     0.200
    53.476     2.881     0.200
    53.627     2.163     0.200
    53.700     1.981     0.200
    53.816     2.949     0.200
    53.816     2.395     0.200
    53.994     3.376     0.200
    54.031     2.584     0.200
    54.163     3.242     0.200
    54.163     3.453     0.200
    54.340     1.611     0.200
    54.972     1.695     0.200
    55.055     4.385     0.200
    55.055     2.518     0.200
    55.380     3.915     0.200
    55.380     3.422     0.200
    55.380     4.024     0.200
    55.607     4.661     0.200
    56.122     3.164     0.200
    56.450     3.865     0.200
    56.545     3.743     0.200
    56.705     2.194     0.200
    56.912     3.129     0.200
    57.107     2.414     0.200
    57.162     2.443     0.200
    57.364     3.390     0.200
    57.318     3.251     0.200
    57.821     3.455     0.200
    57.883     4.265     0.200
    57.883     4.117     0.200
    57.889     3.535     0.200
    58.034     2.853     0.200
    58.205     4.761     0.200
    58.209     2.278     0.200
    58.333     3.866     0.200
    58.569     3.821     0.200
    58.714     3.635     0.200
    58.966     2.160     0.200
    59.056     2.534     0.200
    59.057     2.293     0.200
    59.064     2.171     0.200
    59.419     3.418     0.200
    59.419     3.715     0.200
    59.419     4.035     0.200
    59.419     2.918     0.200
    59.516     3.027     0.200
    59.516     1.652     0.200
    59.580     2.361     0.200
    59.691     2.966     0.200
    59.732     3.232     0.200
    59.732     4.115     0.200
    59.729     2.501     0.200
    59.895     3.138     0.200
    59.895     3.278     0.200
    59.953     3.162     0.200
    59.953     2.645     0.200
    60.047     3.180     0.200
    60.047     3.500     0.200
    60.169     1.787     0.200
    60.183     1.457     0.200
    60.258     3.720     0.200
    60.258     3.369     0.200
    60.209     2.621     0.200
    60.244     2.892     0.200
    60.473     3.821     0.200
    60.496     3.955     0.200
    60.620     3.642     0.200
    60.620     3.916     0.200
    60.620     4.174     0.200
    60.641     2.660     0.200
    60.641     1.628     0.200
    60.656     2.101     0.200
    60.856     2.999     0.200
    60.827     2.908     0.200
    60.873     4.844     0.200
    60.975     2.949     0.200
    60.975     3.105     0.200
    61.133     1.462     0.200
    61.133     2.736     0.200
    61.100     2.490     0.200
    61.128     3.075     0.200
    61.139     1.746     0.200
    61.199     3.523     0.200
    61.199     4.429     0.200
    61.349     3.323     0.200
    61.432     2.270     0.200
    61.621     3.231     0.200
    61.825     1.935     0.200
    61.753     3.117     0.200
    61.799     4.942     0.200
    61.882     4.666     0.200
    62.031     2.313     0.200
    62.126     3.774     0.200
    62.512     3.720     0.200
    62.625     3.173     0.200
    62.691     2.419     0.200
    62.926     3.171     0.200
    62.980     4.462     0.200
    63.193     1.285     0.200
    63.379     1.436     0.200
    63.356     4.202     0.200
    63.359     3.542     0.200
    63.890     3.055     0.200
    64.033     6.223     0.200
    63.947     4.632     0.200
    64.055     3.476     0.200
    64.363     4.080     0.200
    64.403     2.681     0.200
    64.448     3.980     0.200
    64.470     4.995     0.200
    64.598     5.011     0.200
    64.746     3.834     0.200
    64.747     4.869     0.200
    64.778     4.985     0.200
    64.993     2.936     0.200
    65.049     2.073     0.200
    65.049     1.674     0.200
    65.148     3.325     0.200
    65.179     3.508     0.200
    65.336     3.730     0.200
    65.506     4.295     0.200
    65.722     4.496     0.200
    65.725     3.981     0.200
    65.810     4.122     0.200
    65.887     7.420     0.200
    65.887     3.889     0.200
    66.005     3.312     0.200
    66.159     4.209     0.200
    66.164     3.580     0.200
    66.389     2.112     0.200
    66.351     4.454     0.200
    66.427     3.797     0.200
    66.452     3.730     0.200
    66.509     7.327     0.200
    66.628     2.595     0.200
    66.721     7.556     0.200
    66.721     4.869     0.200
    66.816     5.412     0.200
    66.870     4.070     0.200
    66.936     2.135     0.200
    66.987     4.063     0.200
    67.199     4.283     0.200
    67.231     3.079     0.200
    67.335     4.851     0.200
    67.393     3.576     0.200
    67.405     1.955     0.200
    67.450     4.021     0.200
    67.572     5.615     0.200
    67.608     4.590     0.200
    67.662     4.338     0.200
    67.673     4.393     0.200
    67.681     3.279     0.200
    67.724     7.506     0.200
    67.724     4.506     0.200
    67.725     4.853     0.200
    67.772     7.417     0.200
    67.878     3.559     0.200
    67.883     4.780     0.200
    67.927     4.778     0.200
    67.948     1.726     0.200
    67.948     2.171     0.200
    67.971     4.201     0.200
    68.070     3.869     0.200
    68.137     4.794     0.200
    68.137     4.028     0.200
    68.087     5.010     0.200
    68.160     4.844     0.200
    68.207     4.173     0.200
    68.210     7.289     0.200
    68.211     2.506     0.200
    68.252     4.617     0.200
    68.260     7.362     0.200
    68.306     2.717     0.200
    68.327     4.425     0.200
    68.361     4.083     0.200
    68.363     3.513     0.200
    68.371     3.825     0.200
    68.398     5.177     0.200
    68.398     5.349     0.200
    68.398     3.974     0.200
    68.448     7.272     0.200
    68.448     4.631     0.200
    68.452     4.206     0.200
    68.474     3.357     0.200
    68.515     5.393     0.200
    68.530     4.225     0.200
    68.547     4.069     0.200
    68.548     2.612     0.200
    68.591     6.698     0.200
    68.607     4.480     0.200
    68.607     3.496     0.200
    68.616     7.488     0.200
    68.619     3.950     0.200
    68.627     6.631     0.200
    68.628     3.794     0.200
    68.655     4.819     0.200
    68.733     6.001     0.200
    68.736     3.474     0.200
    68.837     2.731     0.200
    68.837     3.075     0.200
    68.788     2.719     0.200
    68.795     7.076     0.200
    68.911     7.538     0.200
    68.928     2.638     0.200
    68.964     4.733     0.200
    68.991     7.190     0.200
    69.019     4.212     0.200
    69.072     4.317     0.200
    69.208     3.596     0.200
    69.208     2.151     0.200
    69.089     4.069     0.200
    69.089     3.545     0.200
    69.136     3.331     0.200
    69.119     2.656     0.200
    69.147     4.533     0.200
    69.199     4.453     0.200
    69.209     4.176     0.200
    69.243     7.407     0.200
    69.349     2.651     0.200
    69.349     3.346     0.200
    69.371     3.996     0.200
    69.532     3.885     0.200
    69.773     7.489     0.200
    69.807     4.913     0.200
    69.807     7.695     0.200
    69.826     4.550     0.200
    69.934     4.736     0.200
    70.014     4.392     0.200
    70.102     2.343     0.200
    70.181     2.648     0.200
    70.164     2.055     0.200
    70.177     7.183     0.200
    70.243     4.256     0.200
    70.253     4.279     0.200
    70.253     5.014     0.200
    70.355     4.990     0.200
    70.463     4.533     0.200
    70.493     5.133     0.200
    70.518     5.393     0.200
    70.520     4.216     0.200
    70.518     4.909     0.200
    70.526     4.248     0.200
    70.526     4.748     0.200
    70.559     6.842     0.200
    70.610     2.672     0.200
    70.649     1.728     0.200
    70.657     4.129     0.200
    70.736     4.921     0.200
    70.787     4.250     0.200
    70.888     5.307     0.200
    70.964     4.637     0.200
    71.052     5.202     0.200
    71.010     4.410     0.200
    71.108     6.607     0.200
    71.159     4.984     0.200
    71.269     6.802     0.200
    71.289     4.662     0.200
    71.362     3.326     0.200
    71.389     6.495     0.200
    71.389     4.674     0.200
    71.391     6.589     0.200
    71.403     3.221     0.200
    71.473     4.641     0.200
    71.473     5.094     0.200
    71.501     6.233     0.200
    71.501     5.303     0.200
    71.501     4.999     0.200
    71.501     4.132     0.200
    71.521     2.663     0.200
    71.871     3.301     0.200
    71.690     3.068     0.200
    71.690     3.732     0.200
    71.616     4.441     0.200
    71.623     6.394     0.200
    71.624     5.616     0.200
    71.822     2.646     0.200
    71.848     4.583     0.200
    71.929     3.324     0.200
    71.929     2.941     0.200
    71.881     2.838     0.200
    71.883     2.729     0.200
    71.959     4.272     0.200
    72.079     4.663     0.200
    72.150     4.230     0.200
    72.236     3.095     0.200
    72.247     4.380     0.200
    72.254     5.699     0.200
    72.288     5.467     0.200
    72.349     6.375     0.200
    72.529     4.465     0.200
    72.527     3.881     0.200
    72.532     4.765     0.200
    72.573     4.532     0.200
    72.639     3.112     0.200
    72.639     3.244     0.200
    72.581     3.534     0.200
    72.600     4.651     0.200
    72.641     4.409     0.200
    72.655     3.930     0.200
    72.772     3.414     0.200
    72.804     4.296     0.200
    72.834     6.135     0.200
    72.839     6.872     0.200
    72.839     4.122     0.200
    72.879     3.127     0.200
    72.913     4.300     0.200
    72.917     3.062     0.200
    72.929     4.225     0.200
    72.971     3.817     0.200
    72.992     6.681     0.200
    73.046     6.783     0.200
    73.135     6.053     0.200
    73.150     2.682     0.200
    73.226     2.974     0.200
    73.265     5.871     0.200
    73.376     5.238     0.200
    73.385     5.384     0.200
    73.415     3.055     0.200
    73.435     2.796     0.200
    73.428     6.568     0.200
    73.440     5.426     0.200
    73.498     3.506     0.200
    73.486     5.451     0.200
    73.549     2.997     0.200
    73.493     4.025     0.200
    73.494     4.792     0.200
    73.504     5.984     0.200
    73.541     5.876     0.200
    73.546     5.185     0.200
    73.571     1.155     0.200
    73.609     3.366     0.200
    73.609     3.593     0.200
    73.609     2.820     0.200
    73.660     2.321     0.200
    73.616     6.949     0.200
    73.619     6.207     0.200
    73.691     2.862     0.200
    73.688     7.310     0.200
    73.734     3.300     0.200
    73.758     3.932     0.200
    73.758     6.220     0.200
    73.782     6.183     0.200
    73.786     4.204     0.200
    73.789     5.381     0.200
    73.827     3.324     0.200
    73.835     7.267     0.200
    73.847     3.831     0.200
    73.862     4.986     0.200
    73.898     2.384     0.200
    73.884     6.637     0.200
    73.896     6.981     0.200
    73.908     7.503     0.200
    73.941     6.758     0.200
    73.968     6.151     0.200
    73.971     5.556     0.200
    74.030     7.119     0.200
    74.110     4.997     0.200
    74.178     3.659     0.200
    74.178     3.448     0.200
    74.202     4.561     0.200
    74.204     7.321     0.200
    74.212     5.236     0.200
    74.212     5.087     0.200
    74.286     7.110     0.200
    74.293     7.505     0.200
    74.357     2.807     0.200
    74.318     6.680     0.200
    74.329     6.068     0.200
    74.329     4.739     0.200
    74.334     6.141     0.200
    74.389     2.540     0.200
    74.459     4.942     0.200
    74.623     6.149     0.200
    74.623     5.540     0.200
    74.627     4.976     0.200
    74.652     5.546     0.200
    74.669    -0.343     0.200
    74.747     4.047     0.200
    74.696     4.289     0.200
    74.706     2.118     0.200
    74.783     2.790     0.200
    74.754     6.942     0.200
    74.805     6.875     0.200
    74.821     2.964     0.200
    74.870     5.821     0.200
    74.876    -0.403     0.200
    74.908     4.208     0.200
    74.939     2.523     0.200
    74.971     1.807     0.200
    74.984     6.348     0.200
    75.023     7.031     0.200
    75.044     4.215     0.200
    75.065     3.702     0.200
    75.118     6.843     0.200
    75.176     5.516     0.200
    75.211     5.966     0.200
    75.302     4.377     0.200
    75.302     6.960     0.200
    75.313     7.301     0.200
    75.324     4.693     0.200
    75.401     4.985     0.200
    75.360     3.063     0.200
    75.440     2.746     0.200
    75.548     4.194     0.200
    75.718     4.990     0.200
    75.749     6.591     0.200
    75.770     1.205     0.200
    75.880     3.563     0.200
    75.811     4.130     0.200
    75.810     1.220     0.200
    75.833     4.821     0.200
    76.066     4.399     0.200
    76.066     3.243     0.200
    75.979     4.039     0.200
    75.979     3.648     0.200
    75.979     3.898     0.200
    75.996     2.742     0.200
    76.046     5.866     0.200
    76.046     4.514     0.200
    76.185     3.764     0.200
    76.145     5.175     0.200
    76.162    -0.005     0.200
    76.202     3.875     0.200
    76.218     6.871     0.200
    76.275     4.200     0.200
    76.380     3.449     0.200
    76.380     4.145     0.200
    76.394     4.536     0.200
    76.423     3.622     0.200
    76.765     3.559     0.200
    76.844     2.584     0.200
    76.920     4.110     0.200
    77.204     3.308     0.200
    77.210     7.196     0.200
    77.218     7.330     0.200
    77.394     3.056     0.200
    77.394     3.376     0.200
    77.759     4.070     0.200
    77.911     3.997     0.200
    78.056     4.050     0.200
    78.462     4.051     0.200
    78.520     3.316     0.200
    78.604     3.560     0.200
    78.604     4.786     0.200
    78.705     3.642     0.200
    79.504     4.412     0.200
    79.737     3.900     0.200
    79.737     2.830     0.200
    79.792     4.699     0.200
    79.875     4.804     0.200
    79.875     4.999     0.200
    79.875     4.038     0.200
    80.662     3.657     0.200
    80.701     4.077     0.200
    80.836     5.034     0.200
    80.836     5.557     0.200
    81.139     4.331     0.200
    81.241     5.309     0.200
    81.712     4.218     0.200
    81.730     3.756     0.200
    82.302     5.014     0.200
    82.349     4.329     0.200
    82.956     5.694     0.200
    82.956     5.210     0.200
    82.989     3.281     0.200
    83.133     2.440     0.200
    83.363     4.295     0.200
    83.463     3.523     0.200
    83.511     3.960     0.200
    84.097     2.837     0.200
    84.173     3.949     0.200
    84.303     2.593     0.200
    84.303     2.367     0.200
    84.791     3.604     0.200
    86.311     2.832     0.200
    86.311     2.621     0.200
    86.346     4.330     0.200
    87.143     4.377     0.200
    87.143     3.713     0.200
    87.476     2.412     0.200
    87.476     1.584     0.200
    87.473     2.826     0.200
    87.559     1.816     0.200
    87.755     4.520     0.200
    88.158     2.891     0.200
    88.516     3.044     0.200
    88.593     3.401     0.200
    88.593     4.158     0.200
    89.351     3.321     0.200
    89.351     3.462     0.200
    89.412     4.816     0.200
    90.041     6.037     0.200
    90.041     3.154     0.200
    90.135     2.387     0.200
    90.898     3.281     0.200
    90.898     3.102     0.200
    91.032     1.776     0.200
    91.032     1.495     0.200
    91.028     5.599     0.200
    91.226     4.205     0.200
    91.659     3.337     0.200
    91.785     4.506     0.200
    92.109     3.506     0.200
    92.641     5.305     0.200
    93.108     5.676     0.200
    93.188     4.330     0.200
    93.188     2.112     0.200
    93.994     3.097     0.200
    93.994     5.691     0.200
    94.736     1.760     0.200
    95.138     0.936     0.200
    95.673     5.144     0.200
    95.883     2.756     0.200
    96.262     1.408     0.200
    96.315     2.212     0.200
    97.081     4.540     0.200
    97.266     3.596     0.200
    97.356     3.931     0.200
    98.582     4.908     0.200
    98.582     4.134     0.200
    98.702     1.834     0.200
    98.812     4.699     0.200
    98.816     5.021     0.200
    98.816     4.146     0.200
    98.975     4.028     0.200
    34.549     6.010     0.200
    19.949    -1.021     0.200
    20.739    -1.357     0.200
    29.028    -0.138     0.200
    75.085     1.383     0.200
    35.130    -0.325     0.200
    39.967     2.018     0.200
    45.278     0.669     0.200
    48.585    -0.282     0.200
    59.517     1.206     0.200
    60.749    -0.644     0.200
    61.073     0.760     0.200
    62.800    -0.456     0.200
    63.996     0.826     0.200
    65.157    -0.160     0.200
    67.993    -0.485     0.200
    19.316     1.653     0.200
    20.726    -1.541     0.200
    36.881     0.667     0.200
    33.974     0.236     0.200
    16.141     3.703     0.200
    20.547    -0.152     0.200
    21.215     3.204     0.200
    22.451     1.880     0.200
    25.111     1.530     0.200
    34.069     2.323     0.200
    37.918     0.866     0.200
    59.208     0.603     0.200
    59.294     0.156     0.200
    59.467     1.377     0.200
    60.456    -0.912     0.200
    64.237     0.536     0.200
    67.697    -0.668     0.200
    67.761    -0.664     0.200
    69.413     0.044     0.200
    70.487     1.460     0.200
    71.513     0.659     0.200
    73.429     0.871     0.200
    73.790     0.315     0.200
    74.657     0.285     0.200
    74.762     1.074     0.200
    74.795     1.278     0.200
    75.185     0.913     0.200
    76.312     0.664     0.200
    78.347     0.318     0.200
    78.806     1.365     0.200
    79.968     0.482     0.200
    88.264     1.401     0.200
    17.622     1.344     0.200
    17.935     1.228     0.200
    18.502     1.545     0.200
    18.552     3.160     0.200
    18.878     1.668     0.200
    18.979     0.446     0.200
    19.651     1.578     0.200
    19.739     1.799     0.200
    20.613     1.046     0.200
    21.071     1.554     0.200
    17.932     1.663     0.200
    18.708     3.742     0.200
    19.411     2.300     0.200
    19.455     1.268     0.200
    19.576     0.474     0.200
    19.649     1.831     0.200
    20.610     0.608     0.200
    21.343     0.651     0.200
    21.425     0.432     0.200
    22.452     1.134     0.200
    36.937     0.698     0.200
    37.623     0.475     0.200
    17.768     0.336     0.200
    20.445     0.453     0.200
    22.288     1.031     0.200
    22.544    -0.188     0.200
    59.363     0.766     0.200
    17.478     1.806     0.200
    17.796     2.357     0.200
    18.660     0.183     0.200
    21.097     2.786     0.200
    21.201     1.807     0.200
    21.912     0.921     0.200
    21.974     1.965     0.200
    21.966     1.241     0.200
    22.315     1.417     0.200
    23.168    -1.241     0.200
    23.180    -1.813     0.200
    68.806    -0.320     0.200
    17.337     3.762     0.200
    17.582     1.005     0.200
    17.907     2.376     0.200
    18.163     1.523     0.200
    18.227     1.168     0.200
    20.212     2.332     0.200
    20.367     1.734     0.200
    20.481     2.264     0.200
    21.228     1.576     0.200
    21.305     1.130     0.200
    21.355     1.581     0.200
    21.467     2.065     0.200
    21.478     2.795     0.200
    22.326     1.073     0.200
    25.030     3.026     0.200
    25.895     3.485     0.200
    26.861     3.093     0.200
    28.816     0.737     0.200
    34.057     2.852     0.200
    34.821     0.808     0.200
    40.142    -0.537     0.200
    40.561     0.901     0.200
    40.594     0.372     0.200
    40.789     0.244     0.200
    41.717     1.350     0.200
    41.906     0.903     0.200
    59.332     0.871     0.200
    59.477     1.474     0.200
    60.441    -0.231     0.200
    60.441    -0.181     0.200
    62.509     0.242     0.200
    64.210     0.015     0.200
    64.850    -0.037     0.200
    64.956    -0.768     0.200
    67.684    -0.070     0.200
    67.747    -0.169     0.200
    68.732     0.192     0.200
    69.378     0.807     0.200
    69.378     0.547     0.200
    70.391     2.086     0.200
    73.410     0.390     0.200
    73.767     0.335     0.200
    78.351     0.577     0.200
    79.912     0.640     0.200
    17.907     3.026     0.200
    18.674     2.445     0.200
    20.625     2.035     0.200
    21.355     1.231     0.200
    21.305     1.790     0.200
    22.326     1.742     0.200
    22.834     2.698     0.200
    23.740     0.681     0.200
    23.740     1.201     0.200
    23.728     2.176     0.200
    24.932     2.668     0.200
    25.487     2.395     0.200
    27.957     2.141     0.200
    28.395     1.365     0.200
    30.136     1.628     0.200
    30.649     1.541     0.200
    34.057     2.991     0.200
    34.821     0.388     0.200
    34.867     1.727     0.200
    36.600     1.285     0.200
    36.657     2.805     0.200
    36.867     1.949     0.200
    36.831     1.856     0.200
    37.613     0.087     0.200
    38.052     0.570     0.200
    39.357     0.933     0.200
    39.941     1.470     0.200
    40.142     0.413     0.200
    40.789     1.314     0.200
    40.799     2.950     0.200
    41.053     3.116     0.200
    41.906     1.562     0.200
    42.133     1.319     0.200
    42.537     1.538     0.200
    49.925     0.007     0.200
    50.758     0.152     0.200
    51.894     0.618     0.200
    52.691    -0.025     0.200
    53.479     0.729     0.200
    53.552     0.357     0.200
    54.197     0.192     0.200
    54.831     0.183     0.200
    56.563     0.298     0.200
    56.645     0.234     0.200
    57.021     0.003     0.200
    57.176     0.389     0.200
    58.049     2.988     0.200
    58.822    -0.180     0.200
    58.918     0.033     0.200
    59.218     1.486     0.200
    59.658     0.690     0.200
    59.812     0.479     0.200
    60.834     0.296     0.200
    61.298     0.477     0.200
    63.371     1.022     0.200
    64.210     0.515     0.200
    64.850    -0.147     0.200
    64.956     0.042     0.200
    65.234     0.701     0.200
    66.067     0.121     0.200
    66.339     0.466     0.200
    66.760     0.804     0.200
    66.905     0.561     0.200
    67.085     1.051     0.200
    67.119     0.734     0.200
    67.274     0.945     0.200
    67.334     0.972     0.200
    67.543     1.151     0.200
    67.562     0.987     0.200
    67.747    -0.269     0.200
    67.759     1.304     0.200
    67.856     0.685     0.200
    67.950     1.489     0.200
    68.050     3.181     0.200
    68.091     0.973     0.200
    68.173     0.772     0.200
    68.253     1.070     0.200
    68.336     0.728     0.200
    68.338     0.975     0.200
    68.354     1.014     0.200
    68.414     0.572     0.200
    68.419     0.798     0.200
    68.428     0.973     0.200
    68.486     1.518     0.200
    68.486     0.948     0.200
    68.530     0.897     0.200
    68.529     0.770     0.200
    68.543     2.154     0.200
    68.543     1.245     0.200
    68.615     1.191     0.200
    68.671     0.661     0.200
    68.808     0.960     0.200
    68.816     0.835     0.200
    68.927     1.117     0.200
    68.959     0.832     0.200
    69.240     0.721     0.200
    69.834     1.833     0.200
    70.127     1.374     0.200
    70.391     1.796     0.200
    70.399     1.208     0.200
    70.400     1.240     0.200
    70.416     1.371     0.200
    70.501     1.806     0.200
    70.612     1.971     0.200
    70.612     1.228     0.200
    70.672     1.069     0.200
    70.706     1.163     0.200
    70.774     0.510     0.200
    71.040     0.812     0.200
    71.043     0.990     0.200
    71.222     0.502     0.200
    71.246     0.831     0.200
    71.353     1.555     0.200
    71.482     1.467     0.200
    71.563     1.886     0.200
    71.718     2.129     0.200
    71.738     3.342     0.200
    72.126     0.312     0.200
    72.153     2.206     0.200
    72.177     0.625     0.200
    72.205    -0.364     0.200
    72.218     0.924     0.200
    72.435     0.285     0.200
    72.571     1.385     0.200
    72.795     1.212     0.200
    72.856     1.747     0.200
    73.007     1.446     0.200
    73.049     1.754     0.200
    73.085     1.062     0.200
    73.085     0.364     0.200
    73.246     1.362     0.200
    73.298     0.475     0.200
    73.291     0.927     0.200
    73.317     0.591     0.200
    73.357     0.906     0.200
    73.369     2.145     0.200
    73.410     1.390     0.200
    73.410     1.080     0.200
    73.414     1.148     0.200
    73.487     0.529     0.200
    73.624     0.829     0.200
    73.696     0.747     0.200
    73.717     1.342     0.200
    74.185     1.968     0.200
    74.190     1.586     0.200
    74.601     2.244     0.200
    74.680     0.945     0.200
    74.741     0.870     0.200
    75.174     0.417     0.200
    75.163     1.172     0.200
    75.798     1.128     0.200
    75.814     0.925     0.200
    76.647     1.001     0.200
    77.006     1.784     0.200
    78.324     0.716     0.200
    79.731     2.388     0.200
    80.505     1.651     0.200
    83.970     2.196     0.200
    86.116     1.132     0.200
    87.901     0.959     0.200
    87.963     1.151     0.200
    87.963     1.174     0.200
    91.197    -0.228     0.200
    91.543     2.277     0.200
    16.247     4.223     0.200
    17.715     2.952     0.200
    18.489     5.059     0.200
    20.739     2.441     0.200
    20.865     1.196     0.200
    21.014     2.398     0.200
    21.607     3.979     0.200
    22.138     1.812     0.200
    22.234     2.849     0.200
    22.426     2.583     0.200
    25.298     3.716     0.200
    25.298     3.636     0.200
    36.393     3.624     0.200
    37.964     0.805     0.200
    57.952    -0.407     0.200
    69.552    -0.116     0.200
    16.202     7.219     0.200
    21.294     1.020     0.200
    21.306     2.583     0.200
    25.097     2.475     0.200
    33.700     0.074     0.200
    36.908     2.453     0.200
    39.527     2.061     0.200
    39.528     3.015     0.200
    49.757     0.040     0.200
    57.826    -0.382     0.200
    59.227     0.587     0.200
    59.227     0.147     0.200
    59.389     1.733     0.200
    60.376    -0.305     0.200
    62.474    -0.195     0.200
    64.160     0.351     0.200
    64.789    -0.787     0.200
    67.617    -0.071     0.200
    68.732    -0.758     0.200
    68.726    -0.612     0.200
    69.339     0.642     0.200
    69.339     0.762     0.200
    71.457     0.847     0.200
    73.712     0.789     0.200
    74.684     0.274     0.200
    76.233     0.940     0.200
    78.296    -0.015     0.200
    79.907     0.829     0.200
    79.923    -0.718     0.200
    25.113     1.607     0.200
    25.486     1.731     0.200
    25.969     3.544     0.200
    30.231     1.644     0.200
    34.114     2.448     0.200
    34.373     1.433     0.200
    34.603     0.777     0.200
    34.908     1.312     0.200
    35.535     1.319     0.200
    36.702     1.109     0.200
    36.932     1.483     0.200
    37.606     1.670     0.200
    37.948     1.198     0.200
    38.671     1.568     0.200
    38.917     1.001     0.200
    39.440     0.880     0.200
    39.490     0.561     0.200
    39.496     2.162     0.200
    39.497     2.436     0.200
    40.035     1.860     0.200
    41.358     0.479     0.200
    41.815     1.632     0.200
    43.524     0.748     0.200
    45.108     1.510     0.200
    49.790     0.067     0.200
    57.859    -0.461     0.200
    59.492     0.431     0.200
    60.413    -0.235     0.200
    60.413    -0.265     0.200
    62.511     0.392     0.200
    64.197     0.899     0.200
    64.826    -0.996     0.200
    67.654    -0.309     0.200
    67.718    -0.332     0.200
    68.765    -0.360     0.200
    68.759    -0.444     0.200
    69.376     0.757     0.200
    69.376     0.726     0.200
    70.446     1.193     0.200
    71.489     0.928     0.200
    72.792     2.742     0.200
    73.749     0.515     0.200
    73.822     0.864     0.200
    74.752     1.452     0.200
    76.270     1.094     0.200
    77.335     1.891     0.200
    78.333     1.345     0.200
    78.773     2.085     0.200
    79.941     0.073     0.200
    15.355     4.122     0.200
    16.748     3.085     0.200
    17.717     1.661     0.200
    21.124     0.345     0.200
    21.427     1.954     0.200
    22.428     2.180     0.200
    27.651     4.592     0.200
    22.216     1.184     0.200
    22.432     2.981     0.200
    22.497     1.193     0.200
    22.575     2.140     0.200
    22.618     2.898     0.200
    22.900     1.368     0.200
    22.927     2.825     0.200
    23.288     2.065     0.200
    23.654     0.884     0.200
    23.839     3.481     0.200
    24.186    -1.356     0.200
    24.192    -0.199     0.200
    25.132     1.285     0.200
    25.985     1.079     0.200
    26.975     3.729     0.200
    27.003     2.045     0.200
    28.865     0.321     0.200
    31.011     1.352     0.200
    33.121     1.165     0.200
    33.286    -0.157     0.200
    33.480     1.885     0.200
    34.141     2.664     0.200
    34.636     0.615     0.200
    34.763     0.045     0.200
    36.355     0.608     0.200
    36.720     1.390     0.200
    36.944     1.446     0.200
    39.762     1.478     0.200
    40.126     2.887     0.200
    40.910     0.427     0.200
    41.185     0.246     0.200
    41.603     1.020     0.200
    42.176     1.209     0.200
    42.204     0.970     0.200
    42.275    -0.173     0.200
    42.476     0.432     0.200
    43.378     0.470     0.200
    43.556     0.096     0.200
    44.758     0.524     0.200
    46.234     2.552     0.200
    46.641     0.848     0.200
    48.432     1.270     0.200
    49.651    -0.264     0.200
    49.789    -0.395     0.200
    51.788    -0.481     0.200
    51.954     0.057     0.200
    57.063     1.608     0.200
    57.859    -0.375     0.200
    59.136     1.032     0.200
    59.220     0.641     0.200
    59.220     1.191     0.200
    60.331     0.684     0.200
    60.393    -0.223     0.200
    60.393    -0.223     0.200
    62.500     0.073     0.200
    62.909    -0.046     0.200
    63.588    -0.862     0.200
    64.182    -0.361     0.200
    64.808    -0.106     0.200
    67.634    -0.501     0.200
    67.697    -0.293     0.200
    68.477     0.200     0.200
    68.598     0.751     0.200
    68.764    -0.426     0.200
    68.759    -0.180     0.200
    72.210     1.366     0.200
    73.261     0.317     0.200
    73.369     0.142     0.200
    75.826     0.060     0.200
    76.044     0.583     0.200
    76.252     0.990     0.200
    77.167     0.361     0.200
    77.328     0.295     0.200
    78.316     0.633     0.200
    79.757     0.785     0.200
    18.253     1.561     0.200
    19.042     2.187     0.200
    19.483     1.484     0.200
    19.722     2.925     0.200
    21.387     1.179     0.200
    21.564     1.959     0.200
    23.085     2.991     0.200
    24.675     2.271     0.200
    25.077     2.599     0.200
    25.584     1.818     0.200
    25.937     4.094     0.200
    26.112     1.781     0.200
    26.694     1.962     0.200
    28.913     1.605     0.200
    29.356     2.262     0.200
    34.144     2.434     0.200
    43.154     1.888     0.200
    34.561     0.862     0.200
    36.917     1.475     0.200
    37.907     1.033     0.200
    41.777     0.622     0.200
    43.182     0.625     0.200
    57.860    -0.457     0.200
    60.439    -1.134     0.200
    62.526    -0.821     0.200
    64.851    -0.349     0.200
    68.761    -0.729     0.200
    68.766    -0.515     0.200
    69.392    -0.283     0.200
    69.392    -1.053     0.200
    70.437     1.433     0.200
    70.462     0.851     0.200
    71.488     0.495     0.200
    73.771     0.304     0.200
    16.221     2.558     0.200
    22.412     2.993     0.200
    25.284     3.038     0.200
    36.930     1.224     0.200
    57.958    -0.273     0.200
    69.562    -0.080     0.200
    69.562    -0.342     0.200
    16.017     2.841     0.200
    16.484     3.692     0.200
    21.239     3.732     0.200
    36.947     0.749     0.200
    39.478     2.481     0.200
    39.479     2.355     0.200
    40.866     0.537     0.200
    57.879    -0.543     0.200
    60.435    -0.464     0.200
    60.435    -0.464     0.200
    64.848    -0.284     0.200
    67.676     0.132     0.200
    68.785    -0.216     0.200
    68.779    -0.309     0.200
    69.398     0.639     0.200
    69.398     0.639     0.200
    70.487     0.691     0.200
    71.508    -0.207     0.200
    73.771     0.599     0.200
    19.693     2.995     0.200
    20.429     3.705     0.200
    21.123     1.965     0.200
    21.261     2.921     0.200
    21.710     1.609     0.200
    25.558     2.688     0.200
    25.983     2.906     0.200
    36.925     1.698     0.200
    37.943     1.211     0.200
    38.914     2.066     0.200
    39.497     2.172     0.200
    40.685     1.188     0.200
    41.810     1.549     0.200
    57.853    -0.557     0.200
    60.410    -0.557     0.200
    60.410    -0.557     0.200
    67.651    -0.411     0.200
    67.715    -0.414     0.200
    68.759    -0.532     0.200
    69.371     0.266     0.200
    69.371     0.136     0.200
    70.439     1.556     0.200
    71.483     0.800     0.200
    73.745     0.029     0.200
    77.330     0.714     0.200
    79.935     0.617     0.200
    17.384     0.782     0.200
    18.696     0.500     0.200
    20.973     0.729     0.200
    21.043     1.189     0.200
    21.408     1.028     0.200
    21.676     0.857     0.200
    22.484     1.737     0.200
    22.674     1.302     0.200
    25.108     2.204     0.200
    27.778    -0.010     0.200
    32.508     0.860     0.200
    33.733     0.005     0.200
    34.591     0.689     0.200
    36.698     0.261     0.200
    36.930     1.047     0.200
    37.937     0.516     0.200
    16.135     2.955     0.200
    16.444     3.618     0.200
    17.807     4.111     0.200
    17.846     3.513     0.200
    17.903     2.675     0.200
    18.094     0.315     0.200
    18.227     1.879     0.200
    18.524     2.886     0.200
    18.581     2.026     0.200
    18.857     1.430     0.200
    18.939     3.161     0.200
    18.989     1.576     0.200
    19.227     0.850     0.200
    19.393     2.996     0.200
    19.634     2.911     0.200
    19.715     1.628     0.200
    20.362     3.183     0.200
    20.573     1.408     0.200
    20.932     3.118     0.200
    20.993     1.829     0.200
    20.974     2.488     0.200
    21.059     3.158     0.200
    21.296     1.960     0.200
    21.345     2.051     0.200
    21.361     2.129     0.200
    21.327     0.676     0.200
    21.479     1.955     0.200
    21.601     1.916     0.200
    21.635     2.964     0.200
    21.608     2.758     0.200
    21.648     1.603     0.200
    22.147     1.506     0.200
    22.320     2.228     0.200
    22.407     2.518     0.200
    22.615     1.936     0.200
    22.745     0.795     0.200
    22.792     2.722     0.200
    22.972     0.160     0.200
    23.013     3.286     0.200
    23.144     2.026     0.200
    23.105     1.013     0.200
    23.439     2.778     0.200
    23.950     2.291     0.200
    23.977     3.622     0.200
    24.151     2.806     0.200
    25.482     2.953     0.200
    25.938     2.537     0.200
    25.983     1.776     0.200
    26.058     1.157     0.200
    26.852     3.158     0.200
    27.822     2.010     0.200
    27.960     1.858     0.200
    31.502     2.055     0.200
    33.820    -0.380     0.200
    34.058     3.709     0.200
    34.498     0.597     0.200
    34.758     1.640     0.200
    34.843     0.179     0.200
    36.052     1.245     0.200
    36.559     1.119     0.200
    36.925     1.895     0.200
    37.600     1.212     0.200
    37.792     2.853     0.200
    37.833     1.994     0.200
    37.831     1.815     0.200
    38.049     0.918     0.200
    38.096     1.896     0.200
    38.326     2.161     0.200
    38.580     2.071     0.200
    38.924     2.546     0.200
    39.306     2.158     0.200
    39.429     1.785     0.200
    40.674     1.302     0.200
    40.776     1.963     0.200
    40.807     3.223     0.200
    40.930     1.647     0.200
    41.043     1.976     0.200
    41.245     2.162     0.200
    41.530     2.680     0.200
    41.547     2.618     0.200
    41.591     1.597     0.200
    41.635     1.284     0.200
    41.942     2.205     0.200
    41.972     2.168     0.200
    42.599     2.704     0.200
    42.921     1.630     0.200
    43.042     0.303     0.200
    43.039     1.164     0.200
    43.407     2.236     0.200
    43.529     2.485     0.200
    44.182     2.245     0.200
    44.722     2.182     0.200
    45.002     0.711     0.200
    45.371     0.154     0.200
    45.449     0.682     0.200
    46.023     0.841     0.200
    49.735    -0.034     0.200
    52.072     0.926     0.200
    53.989     1.834     0.200
    55.233     0.243     0.200
    57.802    -0.609     0.200
    59.216     0.601     0.200
    60.431    -0.687     0.200
    60.431    -0.687     0.200
    64.839    -0.195     0.200
    66.418     0.321     0.200
    67.734     1.244     0.200
    68.709    -0.682     0.200
    69.363     0.258     0.200
    69.362    -0.190     0.200
    70.365     1.352     0.200
    70.390     1.255     0.200
    70.837     1.277     0.200
    71.129     0.259     0.200
    71.427     0.541     0.200
    16.237     3.893     0.200
    17.130     3.791     0.200
    17.706     2.329     0.200
    18.750     1.852     0.200
    19.513     1.783     0.200
    20.169     2.482     0.200
    20.273     2.228     0.200
    20.383     1.690     0.200
    20.419     2.830     0.200
    20.730     2.524     0.200
    20.856     2.418     0.200
    21.019     2.211     0.200
    21.150     1.445     0.200
    21.270     2.436     0.200
    21.421     2.271     0.200
    21.418     1.750     0.200
    21.443     1.622     0.200
    21.793     1.637     0.200
    21.879     1.663     0.200
    21.902     1.145     0.200
    22.003     2.181     0.200
    22.226     1.623     0.200
    22.416     1.999     0.200
    22.482     2.624     0.200
    22.599     1.805     0.200
    22.630     2.656     0.200
    23.241     1.861     0.200
    23.535     2.327     0.200
    23.956     1.897     0.200
    25.289     2.790     0.200
    25.289     2.571     0.200
    27.748     2.030     0.200
    27.862     2.638     0.200
    28.124     2.240     0.200
    28.225     1.898     0.200
    37.256     1.339     0.200
    37.728     0.550     0.200
    37.960     0.823     0.200
    39.271     0.979     0.200
    39.228     2.430     0.200
    41.312     0.842     0.200
    41.624     1.961     0.200
    42.973     1.311     0.200
    45.234     1.006     0.200
    45.878     1.203     0.200
    49.899    -0.102     0.200
    60.645     0.495     0.200
    62.691     0.349     0.200
    20.985     1.715     0.200
    21.035     1.562     0.200
    21.389     1.103     0.200
    21.405     1.184     0.200
    21.699     1.261     0.200
    25.077     2.828     0.200
    36.900     1.438     0.200
    37.916     0.312     0.200
    39.563     1.713     0.200
    41.362     1.365     0.200
    43.212     1.191     0.200
    43.534     0.961     0.200
    44.268     0.843     0.200
    49.767     0.141     0.200
    57.835    -0.350     0.200
    60.410    -0.004     0.200
    64.822     0.091     0.200
    67.652     0.420     0.200
    68.742    -0.299     0.200
    70.416     1.370     0.200
    20.990     2.688     0.200
    22.040     4.670     0.200
    23.063     1.665     0.200
    24.687     0.689     0.200
    26.108     0.268     0.200
    26.914     2.090     0.200
    29.331     1.053     0.200
    29.575     1.339     0.200
    30.042     0.733     0.200
    34.113     1.946     0.200
    42.062     1.280     0.200
    59.162     1.233     0.200
    57.893    -0.380     0.200
    59.316    -0.437     0.200
    59.575     1.131     0.200
    60.538    -0.637     0.200
    60.538    -0.747     0.200
    64.304    -0.313     0.200
    67.782    -0.075     0.200
    67.845     0.605     0.200
    68.795     0.135     0.200
    68.801     0.771     0.200
    68.893     0.493     0.200
    69.085     0.821     0.200
    69.468     0.358     0.200
    69.468     0.128     0.200
    73.862    -0.191     0.200
    16.441     1.713     0.200
    16.833     1.247     0.200
    17.482     1.059     0.200
    18.842     0.747     0.200
    19.323     2.001     0.200
    20.136     0.038     0.200
    20.476     1.323     0.200
    21.120     1.091     0.200
    21.245     0.445     0.200
    33.359     0.875     0.200
    33.949     1.143     0.200
    34.426     0.550     0.200
    34.928     0.090     0.200
    40.250    -1.493     0.200
    42.961     0.705     0.200
    43.051     0.754     0.200
    44.931     0.719     0.200
    59.326    -0.067     0.200
    59.585    -0.694     0.200
    60.545    -0.505     0.200
    60.545    -0.723     0.200
    62.601    -0.257     0.200
    64.309     0.009     0.200
    64.701     0.337     0.200
    64.953    -0.540     0.200
    68.795    -0.448     0.200
    68.801    -0.133     0.200
    69.472    -0.061     0.200
    69.473    -0.632     0.200
    70.670     0.886     0.200
    73.868    -0.535     0.200
    78.452     0.035     0.200
    15.918     3.845     0.200
    17.801     2.219     0.200
    18.572     4.856     0.200
    20.263     1.968     0.200
    20.518     1.765     0.200
    21.206     1.147     0.200
    21.384     0.516     0.200
    22.223     1.030     0.200
    22.727     1.902     0.200
    23.847     0.648     0.200
    23.847     1.238     0.200
    24.824     2.734     0.200
    25.033     3.159     0.200
    30.059     1.669     0.200
    30.833     4.818     0.200
    30.833     3.568     0.200
    30.983    -0.207     0.200
    33.278     2.645     0.200
    33.498    -0.279     0.200
    33.949     2.112     0.200
    38.103    -0.227     0.200
    40.250     1.359     0.200
    49.267     3.143     0.200
    50.826     2.594     0.200
    52.760     1.524     0.200
    54.265     1.284     0.200
    55.098     4.677     0.200
    57.725     2.328     0.200
    58.960     1.196     0.200
    59.326     2.761     0.200
    60.087     0.913     0.200
    61.941     1.921     0.200
    62.601     1.188     0.200
    63.793     0.379     0.200
    64.309     1.884     0.200
    64.701     0.782     0.200
    64.701     1.321     0.200
    67.789    -0.893     0.200
    68.147     1.857     0.200
    68.195     1.938     0.200
    68.307     2.265     0.200
    68.542     2.137     0.200
    68.594     2.266     0.200
    68.801     0.180     0.200
    68.863     3.439     0.200
    68.891     1.209     0.200
    69.011     2.483     0.200
    70.458     3.730     0.200
    70.551     1.791     0.200
    70.670     3.105     0.200
    71.409     2.620     0.200
    72.182     2.357     0.200
    73.374     1.416     0.200
    73.514     1.507     0.200
    73.514     0.734     0.200
    75.901     0.822     0.200
    77.299     3.048     0.200
    78.425     2.708     0.200
    84.078     2.010     0.200
    88.391     0.803     0.200
    18.197     0.459     0.200
    18.992     1.382     0.200
    19.552     1.097     0.200
    19.592     0.929     0.200
    19.663     1.220     0.200
    20.348     2.719     0.200
    20.533     0.381     0.200
    21.013     0.736     0.200
    21.082     0.686     0.200
    22.372     0.866     0.200
    23.710     0.160     0.200
    26.298     0.025     0.200
    26.918     0.638     0.200
    28.880    -0.359     0.200
    29.326     2.274     0.200
    30.957     0.605     0.200
    33.422     0.393     0.200
    34.084     0.755     0.200
    34.815    -0.338     0.200
    36.709     1.095     0.200
    36.944     0.794     0.200
    37.677     0.334     0.200
    39.784     0.174     0.200
    40.115    -0.004     0.200
    40.670     0.306     0.200
    40.855     0.314     0.200
    41.373     0.299     0.200
    41.546     1.230     0.200
    41.804     0.291     0.200
    42.226    -0.067     0.200
    42.208    -0.086     0.200
    42.359     0.800     0.200
    42.448     0.733     0.200
    42.731     0.373     0.200
    43.335     0.876     0.200
    43.526     0.081     0.200
    44.291     0.760     0.200
    54.049     0.305     0.200
    59.192     0.403     0.200
    59.506     0.443     0.200
    62.538     0.051     0.200
    64.226    -0.018     0.200
    64.856    -0.354     0.200
    67.685     0.153     0.200
    67.747    -0.457     0.200
    68.787    -0.270     0.200
    72.155     1.153     0.200
    73.417     0.343     0.200
    73.846     0.553     0.200
    75.856     0.351     0.200
    75.987     1.194     0.200
    76.113     0.652     0.200
    77.060     0.870     0.200
    77.212    -0.030     0.200
    79.781     0.078     0.200
    87.690     0.343     0.200
    14.236     9.538     0.200
    16.099     5.985     0.200
    17.470     0.346     0.200
    17.948     3.552     0.200
    18.724     1.268     0.200
    20.412     2.907     0.200
    20.657     2.315     0.200
    21.360     1.942     0.200
    21.360     1.513     0.200
    22.372     2.327     0.200
    22.372     1.686     0.200
    22.870     2.319     0.200
    23.710     0.825     0.200
    23.710     0.676     0.200
    24.882     4.013     0.200
    24.961     2.896     0.200
    25.117     1.935     0.200
    25.532     2.422     0.200
    25.978     1.673     0.200
    26.359     1.575     0.200
    26.529     1.435     0.200
    26.529     0.513     0.200
    26.918     2.333     0.200
    26.918     1.856     0.200
    27.977     2.562     0.200
    28.476     1.298     0.200
    28.530     2.468     0.200
    28.880     1.040     0.200
    29.326     1.485     0.200
    30.213     1.509     0.200
    30.638     2.886     0.200
    30.714     1.163     0.200
    30.957     2.270     0.200
    30.959     2.789     0.200
    31.000     2.664     0.200
    31.917     1.785     0.200
    33.179     0.883     0.200
    33.422     2.526     0.200
    33.422     3.245     0.200
    33.422     3.002     0.200
    33.644     2.033     0.200
    34.084     2.966     0.200
    34.084     3.302     0.200
    34.303     1.353     0.200
    34.815     0.350     0.200
    34.928     1.623     0.200
    34.920     1.067     0.200
    36.709     2.056     0.200
    36.709     2.376     0.200
    36.694     2.639     0.200
    36.882     1.772     0.200
    36.944     2.341     0.200
    37.601     1.710     0.200
    37.601     1.585     0.200
    37.677     0.701     0.200
    38.120     0.939     0.200
    39.415     1.076     0.200
    39.784     2.792     0.200
    39.784     2.573     0.200
    40.016     0.898     0.200
    40.115     0.339     0.200
    40.115    -0.254     0.200
    40.830     3.248     0.200
    40.830     3.349     0.200
    40.855     1.439     0.200
    41.298     1.306     0.200
    41.658     0.489     0.200
    41.988     1.847     0.200
    42.217     3.064     0.200
    42.442     3.098     0.200
    44.980     0.880     0.200
    45.162     1.638     0.200
    45.611     2.027     0.200
    45.778     3.175     0.200
    48.269     0.486     0.200
    49.129     1.678     0.200
    49.982     0.797     0.200
    50.813     0.773     0.200
    51.948     1.204     0.200
    53.530     1.418     0.200
    54.049     1.516     0.200
    54.049     1.625     0.200
    54.251    -0.199     0.200
    54.886    -0.163     0.200
    56.042     3.064     0.200
    56.618     1.882     0.200
    57.231     1.973     0.200
    57.958     1.629     0.200
    58.194     1.534     0.200
    58.715     1.764     0.200
    58.877    -0.454     0.200
    59.192     1.473     0.200
    59.506     2.592     0.200
    59.506     1.935     0.200
    59.574     1.581     0.200
    59.738     1.159     0.200
    59.868     0.542     0.200
    59.953     3.710     0.200
    59.924     2.600     0.200
    60.164     1.321     0.200
    60.388     0.924     0.200
    60.443    -0.193     0.200
    60.889    -0.356     0.200
    61.747     1.625     0.200
    62.059     1.152     0.200
    62.059     0.965     0.200
    62.538     0.199     0.200
    63.608     2.473     0.200
    64.226     0.185     0.200
    64.856    -0.065     0.200
    65.015    -0.122     0.200
    65.089     2.965     0.200
    65.305     2.311     0.200
    65.466     1.057     0.200
    65.698     2.649     0.200
    65.861     2.697     0.200
    66.130     3.043     0.200
    66.140     2.448     0.200
    66.309     2.045     0.200
    66.389     3.237     0.200
    66.828     0.841     0.200
    66.971     0.484     0.200
    67.152     1.317     0.200
    67.339     1.253     0.200
    67.555     0.893     0.200
    67.608     1.065     0.200
    67.628     0.581     0.200
    67.684     0.250     0.200
    67.685     3.017     0.200
    67.685     3.106     0.200
    67.824     0.778     0.200
    67.922     1.410     0.200
    68.015     0.989     0.200
    68.156     0.940     0.200
    68.237     1.003     0.200
    68.318     0.878     0.200
    68.372     1.839     0.200
    68.372     2.018     0.200
    68.398     0.694     0.200
    68.405     0.881     0.200
    68.419     1.363     0.200
    68.487     1.250     0.200
    68.492     0.904     0.200
    68.508     2.801     0.200
    68.521     2.466     0.200
    68.550     1.502     0.200
    68.550     0.674     0.200
    68.570    -0.244     0.200
    68.594     1.048     0.200
    68.610     1.410     0.200
    68.680     1.304     0.200
    68.737     0.664     0.200
    68.787    -0.138     0.200
    68.787     0.019     0.200
    68.872     1.486     0.200
    68.881     1.160     0.200
    68.907     1.284     0.200
    68.919     3.628     0.200
    68.969     0.166     0.200
    68.991     1.419     0.200
    69.025     0.964     0.200
    69.059     2.053     0.200
    69.094     2.544     0.200
    69.171     2.883     0.200
    69.301     0.482     0.200
    69.435     0.713     0.200
    69.467     5.039     0.200
    69.804    -0.704     0.200
    69.906     3.069     0.200
    69.945     1.678     0.200
    69.964     1.164     0.200
    70.126     2.878     0.200
    70.388     1.375     0.200
    70.412     4.821     0.200
    70.461     2.026     0.200
    70.461     0.128     0.200
    70.466     4.901     0.200
    70.462     2.041     0.200
    70.466     2.651     0.200
    70.487     2.148     0.200
    70.612     2.807     0.200
    70.674     2.127     0.200
    70.674     1.111     0.200
    70.738     0.815     0.200
    70.767     1.863     0.200
    70.767     0.839     0.200
    70.832     0.213     0.200
    70.935     2.760     0.200
    71.026     2.989     0.200
    71.105     1.738     0.200
    71.105     4.808     0.200
    71.112     1.486     0.200
    71.166    -0.742     0.200
    71.222     1.018     0.200
    71.277     0.161     0.200
    71.270     2.924     0.200
    71.317     4.522     0.200
    71.317     1.428     0.200
    71.314     0.786     0.200
    71.418     1.414     0.200
    71.434     2.115     0.200
    71.540     1.573     0.200
    71.622     0.484     0.200
    71.622     1.775     0.200
    71.630     4.339     0.200
    71.962     1.997     0.200
    71.999     0.580     0.200
    72.140     0.841     0.200
    72.190     4.268     0.200
    72.190     0.213     0.200
    72.190    -0.123     0.200
    72.212     2.235     0.200
    72.155     1.403     0.200
    72.155     1.638     0.200
    72.215     2.238     0.200
    72.242     0.592     0.200
    72.265     1.461     0.200
    72.278     4.449     0.200
    72.492     0.163     0.200
    72.506     1.303     0.200
    72.759     0.172     0.200
    72.886     1.403     0.200
    72.921     2.140     0.200
    73.026     3.621     0.200
    73.069     0.829     0.200
    73.147     0.790     0.200
    73.307     1.733     0.200
    73.348     1.457     0.200
    73.380     0.417     0.200
    73.417     0.968     0.200
    73.414     1.452     0.200
    73.415     2.016     0.200
    73.427     2.441     0.200
    73.547     0.225     0.200
    73.684     1.844     0.200
    73.684     1.344     0.200
    73.713     1.516     0.200
    73.713     1.290     0.200
    73.778     1.165     0.200
    74.133     3.076     0.200
    74.203     2.102     0.200
    74.203     2.203     0.200
    74.244     0.976     0.200
    74.854     1.880     0.200
    75.856     1.914     0.200
    75.856     0.554     0.200
    75.856     0.898     0.200
    75.990     3.182     0.200
    75.990     2.486     0.200
    75.987     3.334     0.200
    76.313    -0.115     0.200
    77.212     0.924     0.200
    77.574     2.132     0.200
    77.982     1.417     0.200
    78.335     1.275     0.200
    79.380     1.922     0.200
    79.679     0.653     0.200
    79.774     2.825     0.200
    79.781     2.500     0.200
    79.781     1.711     0.200
    80.566     2.013     0.200
    83.446     3.100     0.200
    83.953     1.961     0.200
    87.865     0.914     0.200
    87.926     0.975     0.200
    87.926     0.537     0.200
    87.926     0.564     0.200
    88.415     2.861     0.200
    91.259     0.195     0.200
    91.259    -0.070     0.200
    93.831     3.484     0.200
    34.586    -0.547     0.200
    16.478     3.735     0.200
    16.726     1.168     0.200
    16.981     2.392     0.200
    17.442     0.613     0.200
    17.956     1.537     0.200
    18.736     4.687     0.200
    19.562     1.496     0.200
    19.667     1.330     0.200
    21.239     3.668     0.200
    25.149     1.444     0.200
    26.009     3.406     0.200
    26.632     1.900     0.200
    28.906     2.779     0.200
    33.535     2.038     0.200
    34.087     2.188     0.200
    36.974     0.915     0.200
    40.156     3.426     0.200
    41.362     1.664     0.200
    41.366     4.510     0.200
    41.563     0.957     0.200
    43.164     2.075     0.200
    59.190     1.142     0.200
    62.554    -0.105     0.200
    64.238    -0.730     0.200
    64.865    -0.444     0.200
    67.754    -0.875     0.200
    68.811    -0.896     0.200
    69.121    -0.255     0.200
    70.700     0.929     0.200
    71.535     0.193     0.200
    73.426     0.698     0.200
    75.877     1.846     0.200
    77.223    -0.364     0.200
    80.937     1.365     0.200
    87.859     0.868     0.200
    18.575     0.683     0.200
    18.775     1.090     0.200
    19.334     0.689     0.200
    19.377     0.434     0.200
    19.378     0.333     0.200
    19.430     0.920     0.200
    19.443     0.475     0.200
    20.686    -0.337     0.200
    21.507     0.826     0.200
    21.623     0.784     0.200
    22.730     2.006     0.200
    24.411    -0.299     0.200
    25.090     1.104     0.200
    25.981     1.205     0.200
    26.707     1.112     0.200
    26.729     0.696     0.200
    27.784     1.563     0.200
    28.964     0.296     0.200
    30.742     0.859     0.200
    33.202     0.864     0.200
    33.865     0.949     0.200
    35.024     0.082     0.200
    36.697     0.566     0.200
    37.475     0.468     0.200
    39.745     0.342     0.200
    39.893    -0.050     0.200
    40.247     0.371     0.200
    40.334    -0.381     0.200
    40.577     0.837     0.200
    40.656     0.456     0.200
    41.090     0.536     0.200
    41.327     1.021     0.200
    41.899     0.778     0.200
    42.038     0.306     0.200
    42.054     0.813     0.200
    42.253    -0.356     0.200
    42.390    -0.056     0.200
    42.473     0.071     0.200
    43.308     0.671     0.200
    43.782     0.419     0.200
    44.590     1.711     0.200
    46.894     0.826     0.200
    49.791    -0.100     0.200
    51.942    -0.025     0.200
    53.835     0.223     0.200
    55.356    -0.232     0.200
    57.911    -0.116     0.200
    59.411     0.382     0.200
    59.547    -0.227     0.200
    60.600    -0.270     0.200
    62.705    -0.580     0.200
    63.710     0.078     0.200
    64.412    -0.353     0.200
    65.053    -0.729     0.200
    66.530     0.718     0.200
    67.753     0.219     0.200
    67.951     0.175     0.200
    68.544    -0.034     0.200
    68.898    -0.263     0.200
    69.576     0.377     0.200
    69.576     0.036     0.200
    71.953     0.823     0.200
    73.614     0.307     0.200
    73.860     0.406     0.200
    75.898     0.823     0.200
    75.997    -0.051     0.200
    77.401    -0.276     0.200
    78.554     0.338     0.200
    79.754     0.088     0.200
    79.898     0.050     0.200
    87.492     0.398     0.200
    15.903     3.433     0.200
    15.903     2.974     0.200
    17.728     2.405     0.200
    18.235     1.327     0.200
    18.508     2.664     0.200
    20.193     2.961     0.200
    20.437     2.003     0.200
    21.147     2.140     0.200
    21.147     1.760     0.200
    21.460     0.949     0.200
    21.668     4.788     0.200
    22.154     1.504     0.200
    22.154     1.333     0.200
    22.649     1.885     0.200
    23.562     2.338     0.200
    23.930     1.228     0.200
    24.427     1.977     0.200
    24.663     2.114     0.200
    24.741     2.339     0.200
    25.090     1.604     0.200
    25.313     2.006     0.200
    26.139     1.829     0.200
    26.348     0.896     0.200
    26.348     1.636     0.200
    26.321     2.285     0.200
    26.707     2.232     0.200
    26.707     2.132     0.200
    27.760     2.187     0.200
    28.312     0.831     0.200
    28.313     2.455     0.200
    28.964     0.105     0.200
    29.316     1.125     0.200
    29.445     2.843     0.200
    30.113     5.227     0.200
    30.418     1.565     0.200
    30.514     1.145     0.200
    30.514     1.033     0.200
    30.742     2.529     0.200
    30.744     2.207     0.200
    30.742     2.149     0.200
    30.780     2.150     0.200
    31.058     0.442     0.200
    31.206     2.394     0.200
    31.860     1.755     0.200
    33.202     2.641     0.200
    33.202     2.314     0.200
    33.397     0.864     0.200
    33.488     2.221     0.200
    33.545     0.820     0.200
    33.865     3.141     0.200
    33.865     2.819     0.200
    34.094     1.525     0.200
    34.397     1.769     0.200
    34.831     1.412     0.200
    35.024     0.802     0.200
    35.023     1.241     0.200
    35.266     3.157     0.200
    36.474     2.089     0.200
    36.697     2.356     0.200
    36.697     1.783     0.200
    36.697     1.616     0.200
    36.667     1.824     0.200
    36.977     1.872     0.200
    37.500     1.894     0.200
    37.475     0.914     0.200
    37.941     2.641     0.200
    38.192     0.397     0.200
    38.378     1.751     0.200
    39.206     0.992     0.200
    39.745     1.202     0.200
    39.893     1.940     0.200
    39.893     2.150     0.200
    39.833     1.764     0.200
    39.898     2.368     0.200
    40.334     0.279     0.200
    40.610     2.953     0.200
    40.656     1.095     0.200
    40.656     1.206     0.200
    40.739     1.605     0.200
    41.087     1.445     0.200
    41.028     1.851     0.200
    41.058     4.021     0.200
    41.296     0.773     0.200
    41.659     0.305     0.200
    41.826     1.729     0.200
    41.969    -0.941     0.200
    42.038     3.667     0.200
    42.038     2.876     0.200
    42.038     3.266     0.200
    42.253     1.074     0.200
    42.320     2.191     0.200
    42.356     1.730     0.200
    42.417     1.504     0.200
    42.390     3.664     0.200
    43.435     1.649     0.200
    43.782     1.649     0.200
    44.966     1.912     0.200
    45.189     0.429     0.200
    45.189     0.279     0.200
    45.509     1.793     0.200
    45.509     1.575     0.200
    45.558     3.170     0.200
    46.064     1.580     0.200
    46.894     2.303     0.200
    46.894     3.036     0.200
    46.894     2.166     0.200
    46.823     1.939     0.200
    47.023     0.423     0.200
    48.487     0.568     0.200
    49.349     2.050     0.200
    49.791     0.407     0.200
    50.088    -0.010     0.200
    50.923     0.179     0.200
    51.917     0.401     0.200
    51.942     0.375     0.200
    52.062     0.303     0.200
    52.858    -0.044     0.200
    53.649     0.744     0.200
    53.722     0.380     0.200
    53.835     1.864     0.200
    53.835     1.593     0.200
    53.975     1.270     0.200
    54.363    -0.011     0.200
    54.647    -0.434     0.200
    54.995     0.170     0.200
    55.086     4.264     0.200
    55.356     1.220     0.200
    55.356     1.047     0.200
    55.622     3.036     0.200
    56.146    -0.077     0.200
    56.480     0.340     0.200
    56.521    -0.319     0.200
    56.729     0.302     0.200
    56.816     0.009     0.200
    56.815    -0.065     0.200
    57.138     0.828     0.200
    57.153    -0.003     0.200
    57.185    -0.055     0.200
    57.334     1.646     0.200
    57.334     1.233     0.200
    57.334     2.033     0.200
    57.341     0.381     0.200
    57.817     2.230     0.200
    57.911     0.654     0.200
    58.018    -0.342     0.200
    58.018     0.158     0.200
    58.059    -0.205     0.200
    57.913     2.326     0.200
    58.201     2.241     0.200
    58.239     0.751     0.200
    58.355     0.164     0.200
    58.563     1.808     0.200
    58.746     0.978     0.200
    58.989    -0.312     0.200
    59.054     0.796     0.200
    59.084    -0.012     0.200
    59.081     0.170     0.200
    59.411     1.622     0.200
    59.411     2.030     0.200
    59.411     1.921     0.200
    59.489     1.577     0.200
    59.542     0.590     0.200
    59.542     1.040     0.200
    59.547     0.977     0.200
    59.547     1.083     0.200
    59.611     0.881     0.200
    59.709     1.883     0.200
    59.761     0.561     0.200
    59.917     0.434     0.200
    59.917     0.704     0.200
    59.977     0.366     0.200
    59.984     0.664     0.200
    60.028     1.287     0.200
    60.187    -0.117     0.200
    60.200     0.741     0.200
    60.240     0.829     0.200
    60.275     0.933     0.200
    60.354     1.946     0.200
    60.520     0.461     0.200
    60.600     1.716     0.200
    60.600     1.600     0.200
    60.600     1.460     0.200
    60.644     0.077     0.200
    60.644     0.256     0.200
    60.569     4.367     0.200
    60.687     0.513     0.200
    60.860     0.757     0.200
    60.902     1.304     0.200
    60.999     0.043     0.200
    60.999     0.393     0.200
    61.132     0.821     0.200
    61.155     0.481     0.200
    61.380     0.825     0.200
    61.456     0.212     0.200
    61.652     1.021     0.200
    61.784     1.021     0.200
    61.830     0.835     0.200
    61.843     1.513     0.200
    61.843     1.094     0.200
    62.044     1.082     0.200
    62.153     1.249     0.200
    62.656     1.062     0.200
    62.705     1.474     0.200
    62.705     0.560     0.200
    62.805     0.650     0.200
    63.064     0.706     0.200
    63.170     0.632     0.200
    63.220     1.189     0.200
    63.509     1.278     0.200
    63.710     0.968     0.200
    63.890     1.301     0.200
    64.223    -0.283     0.200
    64.393     1.538     0.200
    64.412     1.068     0.200
    64.479     0.176     0.200
    64.627     1.341     0.200
    64.775     1.573     0.200
    64.775     1.324     0.200
    64.807     1.348     0.200
    65.016    -0.067     0.200
    65.053     0.427     0.200
    65.053     0.151     0.200
    65.114    -0.204     0.200
    65.114     0.086     0.200
    65.175     0.814     0.200
    65.207     0.463     0.200
    65.307     0.966     0.200
    65.365     0.886     0.200
    65.407     0.924     0.200
    65.461     0.845     0.200
    65.534     1.482     0.200
    65.750     1.539     0.200
    65.755     1.070     0.200
    65.838     0.982     0.200
    65.917     1.095     0.200
    65.979     1.021     0.200
    66.033     1.057     0.200
    66.188     1.287     0.200
    66.193     1.026     0.200
    66.379     1.073     0.200
    66.456     0.915     0.200
    66.480     0.680     0.200
    66.750     0.911     0.200
    66.846     1.723     0.200
    66.898     1.220     0.200
    67.013     0.868     0.200
    67.047     0.752     0.200
    67.227     1.162     0.200
    67.259     1.076     0.200
    67.420     1.026     0.200
    67.477     1.144     0.200
    67.373     1.533     0.200
    67.635     1.215     0.200
    67.689     1.267     0.200
    67.701     1.148     0.200
    67.708     1.106     0.200
    67.753     1.324     0.200
    67.753     1.219     0.200
    67.812     1.281     0.200
    67.887    -0.046     0.200
    67.905     1.382     0.200
    67.911     1.065     0.200
    67.951     0.075     0.200
    67.999     1.155     0.200
    68.097     1.498     0.200
    68.115     1.110     0.200
    68.113     1.715     0.200
    68.113     0.244     0.200
    68.188     1.236     0.200
    68.238     1.312     0.200
    68.235     1.240     0.200
    68.281     1.162     0.200
    68.321     1.348     0.200
    68.320     0.725     0.200
    68.364     1.289     0.200
    68.389     1.004     0.200
    68.392     1.149     0.200
    68.398     1.219     0.200
    68.428     1.209     0.200
    68.428     1.103     0.200
    68.476     0.879     0.200
    68.480     1.387     0.200
    68.488     0.496     0.200
    68.488     0.717     0.200
    68.501     1.193     0.200
    68.544     1.442     0.200
    68.544     1.336     0.200
    68.544     1.066     0.200
    68.558     1.326     0.200
    68.575     1.091     0.200
    68.575     0.942     0.200
    68.589     1.093     0.200
    68.634     0.975     0.200
    68.655     1.144     0.200
    68.650     0.995     0.200
    68.676     1.170     0.200
    68.683     1.466     0.200
    68.683     1.616     0.200
    68.763     1.031     0.200
    68.815     0.943     0.200
    68.898     0.134     0.200
    68.898     0.237     0.200
    68.955     0.456     0.200
    68.962     1.133     0.200
    68.862     2.162     0.200
    68.862     1.935     0.200
    68.980     1.235     0.200
    68.992     1.114     0.200
    69.046     0.676     0.200
    69.075     1.517     0.200
    69.100     1.332     0.200
    69.118     0.792     0.200
    69.174     1.012     0.200
    69.229     1.355     0.200
    69.237     1.402     0.200
    69.396     2.035     0.200
    69.396     1.155     0.200
    69.382     0.635     0.200
    69.498     1.467     0.200
    69.836     1.451     0.200
    69.856     1.652     0.200
    69.963     1.749     0.200
    70.039     0.132     0.200
    70.038     0.943     0.200
    70.121     2.262     0.200
    70.204     1.362     0.200
    70.279     1.614     0.200
    70.272     4.208     0.200
    70.491     1.706     0.200
    70.522     2.159     0.200
    70.545     1.276     0.200
    70.552     1.834     0.200
    70.552     1.094     0.200
    70.549     2.063     0.200
    70.639     1.661     0.200
    70.681     1.508     0.200
    70.688     1.249     0.200
    70.688     1.037     0.200
    70.762     1.432     0.200
    70.815     1.392     0.200
    70.861     0.001     0.200
    70.915     1.711     0.200
    70.933     0.594     0.200
    70.961     1.435     0.200
    70.993     1.137     0.200
    71.026     2.299     0.200
    71.079     1.438     0.200
    71.182     0.862     0.200
    71.186     1.448     0.200
    71.234     0.261     0.200
    71.293     0.532     0.200
    71.319     1.535     0.200
    71.387     1.074     0.200
    71.414     1.261     0.200
    71.417     2.211     0.200
    71.500     1.931     0.200
    71.526     2.313     0.200
    71.901     0.118     0.200
    71.748     0.493     0.200
    71.763     1.518     0.200
    71.825     0.893     0.200
    71.999     1.210     0.200
    71.953     2.121     0.200
    71.953     1.903     0.200
    72.146     1.129     0.200
    72.180     1.705     0.200
    72.167     2.282     0.200
    72.266     2.109     0.200
    72.274     0.792     0.200
    72.324     1.112     0.200
    72.559     1.503     0.200
    72.563     1.999     0.200
    72.670     1.247     0.200
    72.863     0.993     0.200
    72.946     1.139     0.200
    73.002     1.361     0.200
    73.120     0.449     0.200
    73.237     0.917     0.200
    73.440     1.424     0.200
    73.466     1.016     0.200
    73.501     1.249     0.200
    73.510     1.367     0.200
    73.518     1.634     0.200
    73.527     0.877     0.200
    73.544     1.045     0.200
    73.614     1.175     0.200
    73.614     1.287     0.200
    73.643     0.546     0.200
    73.725     0.827     0.200
    73.811     1.281     0.200
    73.860     1.811     0.200
    73.860     1.516     0.200
    74.142     2.126     0.200
    74.157     3.305     0.200
    74.231     1.702     0.200
    74.280     0.810     0.200
    74.309     1.107     0.200
    74.394     1.846     0.200
    74.725     1.639     0.200
    74.726     1.917     0.200
    74.761     1.378     0.200
    74.830     1.371     0.200
    74.854     1.243     0.200
    75.077     1.529     0.200
    75.239     2.087     0.200
    75.239     1.533     0.200
    75.366     1.950     0.200
    75.772     3.396     0.200
    75.997     1.351     0.200
    75.997     1.110     0.200
    76.001     1.605     0.200
    75.898     3.573     0.200
    76.073     1.148     0.200
    76.179     2.106     0.200
    76.220     1.617     0.200
    76.244     0.971     0.200
    76.308     2.161     0.200
    76.406     0.825     0.200
    76.441     1.566     0.200
    76.427     1.966     0.200
    76.540     1.606     0.200
    76.689     0.863     0.200
    76.953     2.163     0.200
    77.141     2.414     0.200
    77.209     2.070     0.200
    77.401     1.813     0.200
    77.401     1.354     0.200
    77.444     2.063     0.200
    77.444     1.563     0.200
    77.645     1.879     0.200
    77.907     1.128     0.200
    77.944     0.716     0.200
    77.944    -0.285     0.200
    78.054    -0.773     0.200
    78.081     1.055     0.200
    78.273     1.747     0.200
    78.446     3.221     0.200
    78.495     1.842     0.200
    78.527     2.236     0.200
    78.554     1.806     0.200
    78.680     1.791     0.200
    78.739     1.359     0.200
    79.523     2.877     0.200
    79.668     1.578     0.200
    79.754     3.378     0.200
    79.754     3.720     0.200
    79.754     3.198     0.200
    79.812     2.674     0.200
    79.898     1.630     0.200
    80.083     1.200     0.200
    80.599     2.419     0.200
    80.736     0.988     0.200
    80.980     1.093     0.200
    81.592     0.772     0.200
    81.754     0.668     0.200
    82.367     1.836     0.200
    83.209     0.043     0.200
    83.312     1.218     0.200
    84.122     0.799     0.200
    84.169     2.419     0.200
    84.813    -0.901     0.200
    86.298     1.125     0.200
    87.492     1.288     0.200
    87.492     0.979     0.200
    87.776     1.556     0.200
    88.085     1.144     0.200
    88.147     1.020     0.200
    88.147     1.356     0.200
    88.146     0.979     0.200
    88.468     1.736     0.200
    88.538     1.827     0.200
    88.576     1.705     0.200
    89.337     1.454     0.200
    89.337     1.279     0.200
    90.157     2.074     0.200
    90.157     1.823     0.200
    91.055     1.184     0.200
    91.055     1.005     0.200
    91.211     1.451     0.200
    92.372     1.916     0.200
    96.288     1.267     0.200
    98.940     1.363     0.200
    34.583     2.624     0.200
    22.242     2.189     0.200
    25.513     1.043     0.200
    18.720    -0.858     0.200
    21.416     1.637     0.200
    22.412    -0.245     0.200
    25.572     2.696     0.200
    39.509     2.524     0.200
    39.510     2.761     0.200
    57.848    -0.321     0.200
    59.149     0.263     0.200
    59.409     0.223     0.200
    60.399    -0.783     0.200
    60.399    -0.213     0.200
    62.498     0.115     0.200
    64.813    -0.148     0.200
    68.754     0.245     0.200
    71.479     1.540     0.200
    36.892     1.611     0.200
    57.835    -0.373     0.200
    67.728    -0.105     0.200
    69.371     0.470     0.200
    69.371     0.470     0.200
    21.937     0.857     0.200
    57.933    -0.225     0.200
    67.834    -0.019     0.200
    67.851     0.945     0.200
    69.518     0.053     0.200
    69.518     0.284     0.200
    18.001     1.875     0.200
    20.462     3.331     0.200
    20.576     1.727     0.200
    21.343     1.838     0.200
    25.894     2.478     0.200
    18.001     2.938     0.200
    18.767     4.479     0.200
    20.462     5.237     0.200
    20.720     1.886     0.200
    21.343     1.717     0.200
    21.396     1.132     0.200
    22.929     2.005     0.200
    23.645     0.707     0.200
    25.027     3.012     0.200
    26.952     4.791     0.200
    28.051     2.212     0.200
    28.779     1.663     0.200
    30.782    -0.177     0.200
    33.478     3.684     0.200
    34.152     2.933     0.200
    34.731     0.383     0.200
    36.853     1.856     0.200
    38.021    -0.128     0.200
    39.448     1.008     0.200
    40.894     2.508     0.200
    42.620     1.267     0.200
    44.950     0.223     0.200
    45.642     0.526     0.200
    48.223    -0.158     0.200
    53.185     0.301     0.200
    56.593     0.239     0.200
    58.761     0.164     0.200
    59.123     2.046     0.200
    59.123     1.815     0.200
    60.184     3.310     0.200
    60.353    -0.327     0.200
    62.437    -0.028     0.200
    63.598     0.757     0.200
    64.130     0.951     0.200
    64.764     0.497     0.200
    64.764    -0.640     0.200
    64.912     1.145     0.200
    67.948     0.706     0.200
    15.425   446.347     0.200
    68.684    -0.306     0.200
    70.470     1.186     0.200
    70.730     0.188     0.200
    71.214     0.477     0.200
    75.080    -0.862     0.200
    83.877     1.954     0.200
    88.190     1.760     0.200
    21.341     0.400     0.200
    21.438     0.292     0.200
    22.707     0.314     0.200
    25.039     0.327     0.200
    25.526     1.294     0.200
    25.891     1.482     0.200
    16.617     2.007     0.200
    17.008     1.840     0.200
    17.404     1.218     0.200
    17.651     0.369     0.200
    17.707     1.540     0.200
    17.878     1.625     0.200
    17.976     1.419     0.200
    66.748  -398.208     0.200
    18.231     1.190     0.200
    18.295     1.835     0.200
    18.650     1.531     0.200
    18.743     1.263     0.200
    18.926     0.706     0.200
    19.014     1.434     0.200
    23.672   -46.482     0.200
    19.298     1.411     0.200
    19.462     1.944     0.200
    19.497     1.307     0.200
    19.575     1.491     0.200
    19.610     0.994     0.200
    19.702     1.210     0.200
    20.281     1.222     0.200
    20.310     1.899     0.200
    20.436     1.286     0.200
    20.548     1.245     0.200
    20.649     1.034     0.200
    21.002     0.866     0.200
    21.291     2.277     0.200
    21.357     0.797     0.200
    21.373     1.424     0.200
    22.056     1.487     0.200
    22.822     0.230     0.200
    25.050     1.930     0.200
    25.905     2.269     0.200
    26.930     1.998     0.200
    31.290     0.800     0.200
    31.421     1.141     0.200
    73.347  -308.670     0.200
    32.066    -0.038     0.200
    33.452     1.289     0.200
    34.124     2.467     0.200
    36.868     3.177     0.200
    40.075     1.914     0.200
    40.092     1.625     0.200
    40.093     1.281     0.200
    40.855     0.823     0.200
    41.715     0.129     0.200
    41.768     1.133     0.200
    41.872     0.840     0.200
    42.022     0.227     0.200
    17.976     2.997     0.200
    18.743     1.814     0.200
    20.436     2.375     0.200
    20.693     2.244     0.200
    21.357     1.277     0.200
    21.373     1.596     0.200
    22.395     0.975     0.200
    22.902     1.793     0.200
    23.672     0.968     0.200
    23.797     2.015     0.200
    24.910     3.855     0.200
    25.050     1.781     0.200
    25.000     2.507     0.200
    25.556     1.939     0.200
    26.394     4.723     0.200
    26.515    -0.473     0.200
    28.022     2.187     0.200
    28.453     1.171     0.200
    28.800     1.384     0.200
    30.198     1.766     0.200
    30.808     0.098     0.200
    31.006     3.056     0.200
    31.038     2.742     0.200
    31.856     1.499     0.200
    33.452     3.085     0.200
    33.452     2.246     0.200
    33.616     1.686     0.200
    33.613     1.681     0.200
    34.124     3.217     0.200
    34.867     1.138     0.200
    36.726     2.673     0.200
    36.868     1.665     0.200
    36.900     1.833     0.200
    37.552     1.797     0.200
    38.040     0.168     0.200
    39.426     0.957     0.200
    40.092     1.726     0.200
    40.075     2.886     0.200
    40.075     2.773     0.200
    40.855     1.042     0.200
    40.867     3.216     0.200
    41.965     1.497     0.200
    42.602     1.400     0.200
    45.159     1.273     0.200
    44.971     0.957     0.200
    45.813     3.259     0.200
    48.247     1.462     0.200
    52.666     3.666     0.200
    53.451     3.023     0.200
    58.116     0.827     0.200
    58.797    -0.368     0.200
    58.789    -0.126     0.200
    59.151     3.366     0.200
    59.151     2.666     0.200
    59.151     1.854     0.200
    59.151     2.065     0.200
    59.428     2.913     0.200
    59.662     0.223     0.200
    59.788     0.764     0.200
    59.926     1.914     0.200
    60.382     0.687     0.200
    60.375    -0.364     0.200
    60.809     0.871     0.200
    60.809     0.132     0.200
    60.928     2.768     0.200
    63.627     1.880     0.200
    64.793     0.345     0.200
    66.061     0.316     0.200
    66.609     2.371     0.200
    67.107     1.025     0.200
    67.744     1.206     0.200
    67.935     1.681     0.200
    68.076     0.745     0.200
    68.157     0.827     0.200
    68.238     0.889     0.200
    68.530     2.059     0.200
    68.530     1.297     0.200
    15.433   446.418     0.200
    68.707    -0.056     0.200
    68.980    -0.255     0.200
    69.884     2.945     0.200
    70.046     5.967     0.200
    70.046     1.268     0.200
    70.109     1.204     0.200
    70.308     4.362     0.200
    70.308     0.960     0.200
    70.383     1.475     0.200
    70.380     6.619     0.200
    70.380     3.721     0.200
    70.380     3.221     0.200
    70.407     7.954     0.200
    70.407     3.755     0.200
    70.489     1.244     0.200
    70.594     2.304     0.200
    70.594     1.581     0.200
    70.594     1.210     0.200
    70.658     5.920     0.200
    70.658     1.459     0.200
    70.658     2.022     0.200
    70.686     0.801     0.200
    70.686     0.950     0.200
    70.752     0.951     0.200
    70.752     0.369     0.200
    70.946     6.671     0.200
    70.946     2.871     0.200
    71.032     3.310     0.200
    71.197     1.591     0.200
    71.234     0.805     0.200
    71.234     0.527     0.200
    71.460     2.061     0.200
    71.542     1.571     0.200
    71.598     0.531     0.200
    72.028     2.314     0.200
    72.028     0.744     0.200
    72.136     2.092     0.200
    72.185     1.414     0.200
    72.156     1.261     0.200
    72.428     1.370     0.200
    72.679     4.141     0.200
    73.066     1.476     0.200
    73.066     1.253     0.200
    73.066     1.054     0.200
    73.364    -0.817     0.200
    73.327     1.755     0.200
    73.327     0.087     0.200
    73.334     1.300     0.200
    73.335     1.906     0.200
    73.416     2.884     0.200
    73.416     1.626     0.200
    73.416     0.884     0.200
    73.467     0.389     0.200
    73.603     1.397     0.200
    73.603    -0.306     0.200
    73.633     2.046     0.200
    73.633     1.722     0.200
    33.772   294.369     0.200
    73.698     1.913     0.200
    74.123     1.881     0.200
    74.134     3.516     0.200
    74.464     1.801     0.200
    74.592     0.869     0.200
    74.663     1.096     0.200
    75.187     1.464     0.200
    75.155     1.069     0.200
    75.910     0.978     0.200
    76.002     0.697     0.200
    76.470     3.631     0.200
    76.950     3.809     0.200
    77.146     3.722     0.200
    77.494     1.928     0.200
    77.793     0.742     0.200
    77.902     1.409     0.200
    78.270     4.701     0.200
    78.517     1.563     0.200
    83.905     2.283     0.200
    85.470     9.588     0.200
    88.216     1.552     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
    99.656     3.694     0.200
    99.782     3.908     0.200
    99.782     4.408     0.200
    99.782     3.728     0.200
    99.958     3.727     0.200
    99.958     3.235     0.200
   100.572     2.874     0.200
   100.752     2.955     0.200
   101.742     1.572     0.200
   102.075     3.518     0.200
   102.663     4.189     0.200
   102.663     3.329     0.200
   102.874     2.492     0.200
   103.918     1.207     0.200
    99.732     1.559     0.200
   101.482     0.687     0.200
   103.239     1.732     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    46.341    98.804     0.200
    58.791    51.180     0.200
    35.274   149.941     0.200
    46.340    95.702     0.200
    32.987   165.957     0.200
    33.697   163.195     0.200
    39.030   131.214     0.200
    45.910   100.590     0.200
    56.898    56.768     0.200
    62.309    41.356     0.200
    63.891    35.057     0.200
    68.007    25.663     0.200
    69.584    24.943     0.200
    70.284    17.240     0.200
    71.033    15.575     0.200
    72.788    15.640     0.200
    76.252    10.516     0.200
    76.531    14.233     0.200
    86.988     2.356     0.200
    39.030   131.250     0.200
    63.892    33.079     0.200
    69.587    24.857     0.200
    71.035    15.397     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
