#!/bin/bash
gmt begin hubbard5.7_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times hubbard5.7'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   324.144
    25.500   328.687
    26.000   333.219
    26.500   337.740
    27.000   342.249
    27.500   346.741
    28.000   351.213
    28.500   355.670
    29.000   360.115
    29.500   364.552
    30.000   368.980
    30.500   373.401
    31.000   377.815
    31.500   382.220
    32.000   386.617
    32.500   391.005
    33.000   395.383
    33.500   399.747
    34.000   404.098
    34.500   408.434
    35.000   412.755
    35.500   417.060
    36.000   421.351
    36.500   425.626
    37.000   429.886
    37.500   434.130
    38.000   438.358
    38.500   442.570
    39.000   446.766
    39.500   450.945
    40.000   455.106
    40.500   459.251
    41.000   463.378
    41.500   467.489
    42.000   471.582
    42.500   475.658
    43.000   479.717
    43.500   483.758
    44.000   487.782
    44.500   491.787
    45.000   495.775
    45.500   499.745
    46.000   503.697
    46.500   507.631
    47.000   511.547
    47.500   515.444
    48.000   519.324
    48.500   523.186
    49.000   527.029
    49.500   530.854
    50.000   534.661
    50.500   538.449
    51.000   542.219
    51.500   545.971
    52.000   549.705
    52.500   553.421
    53.000   557.120
    53.500   560.800
    54.000   564.462
    54.500   568.106
    55.000   571.732
    55.500   575.339
    56.000   578.927
    56.500   582.497
    57.000   586.049
    57.500   589.583
    58.000   593.099
    58.500   596.596
    59.000   600.075
    59.500   603.536
    60.000   606.979
    60.500   610.403
    61.000   613.809
    61.500   617.196
    62.000   620.565
    62.500   623.917
    63.000   627.250
    63.500   630.565
    64.000   633.862
    64.500   637.142
    65.000   640.403
    65.500   643.647
    66.000   646.872
    66.500   650.080
    67.000   653.269
    67.500   656.441
    68.000   659.594
    68.500   662.729
    69.000   665.846
    69.500   668.944
    70.000   672.025
    70.500   675.087
    71.000   678.131
    71.500   681.157
    72.000   684.165
    72.500   687.155
    73.000   690.126
    73.500   693.079
    74.000   696.013
    74.500   698.928
    75.000   701.825
    75.500   704.703
    76.000   707.563
    76.500   710.404
    77.000   713.228
    77.500   716.033
    78.000   718.821
    78.500   721.590
    79.000   724.341
    79.500   727.073
    80.000   729.787
    80.500   732.482
    81.000   735.158
    81.500   737.814
    82.000   740.451
    82.500   743.069
    83.000   745.669
    83.500   748.250
    84.000   750.811
    84.500   753.352
    85.000   755.872
    85.500   758.373
    86.000   760.855
    86.500   763.319
    87.000   765.766
    87.500   768.189
    88.000   770.578
    88.500   772.945
    89.000   775.299
    89.500   777.645
    90.000   779.983
    90.500   782.314
    91.000   784.639
    91.500   786.959
    92.000   789.273
    92.500   791.584
    93.000   793.891
    93.500   796.195
    94.000   798.495
    94.500   800.791
    95.000   803.081
    95.500   805.366
    96.000   807.644
    96.500   809.916
    97.000   812.181
    97.500   814.440
    98.000   816.691
    98.500   818.935
    99.000   821.172
    99.500   823.401
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1122.424
   116.000  1123.386
   116.500  1124.348
   117.000  1125.310
   117.500  1126.272
   118.000  1127.234
   118.500  1128.195
   119.000  1129.157
   119.500  1130.119
   120.000  1131.080
   120.500  1132.041
   121.000  1133.002
   121.500  1133.962
   122.000  1134.922
   122.500  1135.882
   123.000  1136.842
   123.500  1137.801
   124.000  1138.760
   124.500  1139.718
   125.000  1140.676
   125.500  1141.633
   126.000  1142.589
   126.500  1143.545
   127.000  1144.500
   127.500  1145.455
   128.000  1146.408
   128.500  1147.361
   129.000  1148.313
   129.500  1149.264
   130.000  1150.214
   130.500  1151.163
   131.000  1152.110
   131.500  1153.057
   132.000  1154.002
   132.500  1154.945
   133.000  1155.887
   133.500  1156.828
   134.000  1157.767
   134.500  1158.704
   135.000  1159.639
   135.500  1160.573
   136.000  1161.504
   136.500  1162.432
   137.000  1163.359
   137.500  1164.283
   138.000  1165.204
   138.500  1166.123
   139.000  1167.039
   139.500  1167.951
   140.000  1168.861
   140.500  1169.767
   141.000  1170.670
   141.500  1171.568
   142.000  1172.463
   142.500  1173.353
   143.000  1174.239
   143.500  1175.121
   144.000  1175.997
   144.500  1176.868
   145.000  1177.734
   145.500  1178.594
   146.000  1179.448
   146.500  1180.295
   147.000  1181.136
   147.500  1181.971
   148.000  1182.798
   148.500  1183.617
   149.000  1184.429
   149.500  1185.231
   150.000  1186.025
   150.500  1186.808
   151.000  1187.582
   151.500  1188.345
   152.000  1189.098
   152.500  1189.842
   153.000  1190.575
   153.500  1191.298
   154.000  1192.011
   154.500  1192.712
   155.000  1193.403
   155.500  1194.082
   156.000  1194.749
   156.500  1195.405
   157.000  1196.048
   157.500  1196.680
   158.000  1197.299
   158.500  1197.906
   159.000  1198.500
   159.500  1199.081
   160.000  1199.650
   160.500  1200.205
   161.000  1200.748
   161.500  1201.277
   162.000  1201.793
   162.500  1202.296
   163.000  1202.786
   163.500  1203.262
   164.000  1203.724
   164.500  1204.172
   165.000  1204.607
   165.500  1205.028
   166.000  1205.435
   166.500  1205.828
   167.000  1206.207
   167.500  1206.572
   168.000  1206.923
   168.500  1207.260
   169.000  1207.583
   169.500  1207.892
   170.000  1208.187
   170.500  1208.467
   171.000  1208.733
   171.500  1208.985
   172.000  1209.223
   172.500  1209.446
   173.000  1209.655
   173.500  1209.849
   174.000  1210.030
   174.500  1210.195
   175.000  1210.347
   175.500  1210.484
   176.000  1210.607
   176.500  1210.715
   177.000  1210.809
   177.500  1210.888
   178.000  1210.953
   178.500  1211.004
   179.000  1211.040
   179.500  1211.062
   180.000  1211.069
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   993.367
     1.000   993.376
     1.500   993.390
     2.000   993.409
     2.500   993.434
     3.000   993.465
     3.500   993.502
     4.000   993.543
     4.500   993.591
     5.000   993.644
     5.500   993.703
     6.000   993.767
     6.500   993.837
     7.000   993.913
     7.500   993.994
     8.000   994.080
     8.500   994.172
     9.000   994.270
     9.500   994.373
    10.000   994.482
    10.500   994.597
    11.000   994.717
    11.500   994.842
    12.000   994.974
    12.500   995.110
    13.000   995.252
    13.500   995.400
    14.000   995.553
    14.500   995.712
    15.000   995.876
    15.500   996.046
    16.000   996.221
    16.500   996.402
    17.000   996.588
    17.500   996.780
    18.000   996.977
    18.500   997.180
    19.000   997.388
    19.500   997.602
    20.000   997.821
    20.500   998.045
    21.000   998.275
    21.500   998.510
    22.000   998.751
    22.500   998.997
    23.000   999.249
    23.500   999.506
    24.000   999.768
    24.500  1000.036
    25.000  1000.309
    25.500  1000.588
    26.000  1000.872
    26.500  1001.161
    27.000  1001.455
    27.500  1001.755
    28.000  1002.060
    28.500  1002.370
    29.000  1002.686
    29.500  1003.007
    30.000  1003.333
    30.500  1003.665
    31.000  1004.002
    31.500  1004.343
    32.000  1004.691
    32.500  1005.043
    33.000  1005.401
    33.500  1005.763
    34.000  1006.131
    34.500  1006.504
    35.000  1006.883
    35.500  1007.266
    36.000  1007.655
    36.500  1008.048
    37.000  1008.447
    37.500  1008.851
    38.000  1009.259
    38.500  1009.673
    39.000  1010.092
    39.500  1010.516
    40.000  1010.945
    40.500  1011.379
    41.000  1011.818
    41.500  1012.262
    42.000  1012.711
    42.500  1013.165
    43.000  1013.624
    43.500  1014.087
    44.000  1014.556
    44.500  1015.029
    45.000  1015.508
    45.500  1015.991
    46.000  1016.479
    46.500  1016.972
    47.000  1017.469
    47.500  1017.972
    48.000  1018.479
    48.500  1018.991
    49.000  1019.507
    49.500  1020.029
    50.000  1020.555
    50.500  1021.086
    51.000  1021.621
    51.500  1022.161
    52.000  1022.706
    52.500  1023.255
    53.000  1023.809
    53.500  1024.367
    54.000  1024.931
    54.500  1025.498
    55.000  1026.070
    55.500  1026.647
    56.000  1027.228
    56.500  1027.814
    57.000  1028.404
    57.500  1028.998
    58.000  1029.597
    58.500  1030.200
    59.000  1030.808
    59.500  1031.420
    60.000  1032.037
    60.500  1032.657
    61.000  1033.282
    61.500  1033.912
    62.000  1034.545
    62.500  1035.183
    63.000  1035.825
    63.500  1036.471
    64.000  1037.122
    64.500  1037.776
    65.000  1038.435
    65.500  1039.098
    66.000  1039.765
    66.500  1040.436
    67.000  1041.111
    67.500  1041.790
    68.000  1042.473
    68.500  1043.160
    69.000  1043.851
    69.500  1044.547
    70.000  1045.245
    70.500  1045.948
    71.000  1046.655
    71.500  1047.366
    72.000  1048.081
    72.500  1048.799
    73.000  1049.521
    73.500  1050.247
    74.000  1050.977
    74.500  1051.710
    75.000  1052.448
    75.500  1053.188
    76.000  1053.933
    76.500  1054.681
    77.000  1055.433
    77.500  1056.189
    78.000  1056.948
    78.500  1057.710
    79.000  1058.477
    79.500  1059.246
    80.000  1060.020
    80.500  1060.796
    81.000  1061.577
    81.500  1062.360
    82.000  1063.147
    82.500  1063.938
    83.000  1064.731
    83.500  1065.528
    84.000  1066.329
    84.500  1067.133
    85.000  1067.940
    85.500  1068.750
    86.000  1069.563
    86.500  1070.380
    87.000  1071.200
    87.500  1072.023
    88.000  1072.849
    88.500  1073.678
    89.000  1074.511
    89.500  1075.346
    90.000  1076.185
    90.500  1077.026
    91.000  1077.871
    91.500  1078.718
    92.000  1079.568
    92.500  1080.422
    93.000  1081.278
    93.500  1082.137
    94.000  1082.999
    94.500  1083.864
    95.000  1084.731
    95.500  1085.602
    96.000  1086.475
    96.500  1087.351
    97.000  1088.229
    97.500  1089.111
    98.000  1089.995
    98.500  1090.881
    99.000  1091.770
    99.500  1092.662
   100.000  1093.557
   100.500  1094.453
   101.000  1095.353
   101.500  1096.255
   102.000  1097.159
   102.500  1098.066
   103.000  1098.975
   103.500  1099.887
   104.000  1100.801
   104.500  1101.717
   105.000  1102.636
   105.500  1103.557
   106.000  1104.480
   106.500  1105.406
   107.000  1106.333
   107.500  1107.264
   108.000  1108.196
   108.500  1109.130
   109.000  1110.067
   109.500  1111.005
   110.000  1111.946
   110.500  1112.888
   111.000  1113.833
   111.500  1114.780
   112.000  1115.729
   112.500  1116.679
   113.000  1117.632
   113.500  1118.587
   114.000  1119.543
   114.500  1120.501
   115.000  1121.462
   115.500  1122.424
   116.000  1123.387
   116.500  1124.353
   117.000  1125.320
   117.500  1126.289
   118.000  1127.260
   118.500  1128.233
   119.000  1129.207
   119.500  1130.182
   120.000  1131.160
   120.500  1132.139
   121.000  1133.119
   121.500  1134.101
   122.000  1135.085
   122.500  1136.070
   123.000  1137.056
   123.500  1138.044
   124.000  1139.033
   124.500  1140.024
   125.000  1141.016
   125.500  1142.010
   126.000  1143.004
   126.500  1144.000
   127.000  1144.998
   127.500  1145.996
   128.000  1146.996
   128.500  1147.997
   129.000  1148.999
   129.500  1150.003
   130.000  1151.007
   130.500  1152.012
   131.000  1153.019
   131.500  1154.027
   132.000  1155.036
   132.500  1156.045
   133.000  1157.056
   133.500  1158.068
   134.000  1159.081
   134.500  1160.094
   135.000  1161.109
   135.500  1162.124
   136.000  1163.141
   136.500  1164.158
   137.000  1165.176
   137.500  1166.194
   138.000  1167.214
   138.500  1168.234
   139.000  1169.255
   139.500  1170.276
   140.000  1171.299
   140.500  1172.322
   141.000  1173.345
   141.500  1174.370
   142.000  1175.394
   142.500  1176.420
   143.000  1177.446
   143.500  1178.472
   144.000  1179.499
   144.500  1180.526
   145.000  1181.554
   145.500  1182.583
   146.000  1183.611
   146.500  1184.641
   147.000  1185.670
   147.500  1186.700
   148.000  1187.730
   148.500  1188.760
   149.000  1189.791
   149.500  1190.822
   150.000  1191.854
   150.500  1192.885
   151.000  1193.917
   151.500  1194.949
   152.000  1195.981
   152.500  1197.013
   153.000  1198.045
   153.500  1199.078
   154.000  1200.110
   154.500  1201.143
   155.000  1202.175
   155.500  1203.208
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1177.040
   145.500  1178.863
   146.000  1180.743
   146.500  1182.659
   147.000  1184.604
   147.500  1186.572
   148.000  1188.560
   148.500  1190.565
   149.000  1192.587
   149.500  1194.622
   150.000  1196.670
   150.500  1198.729
   151.000  1200.799
   151.500  1202.878
   152.000  1204.967
   152.500  1207.064
   153.000  1209.168
   153.500  1211.280
   154.000  1213.399
   154.500  1215.525
   155.000  1217.657
   155.500  1219.794
   156.000  1221.937
   156.500  1224.084
   157.000  1226.237
   157.500  1228.394
   158.000  1230.555
   158.500  1232.720
   159.000  1234.889
   159.500  1237.062
   160.000  1239.238
   160.500  1241.418
   161.000  1243.600
   161.500  1245.786
   162.000  1247.974
   162.500  1250.165
   163.000  1252.358
   163.500  1254.553
   164.000  1256.751
   164.500  1258.950
   165.000  1261.152
   165.500  1263.355
   166.000  1265.560
   166.500  1267.767
   167.000  1269.975
   167.500  1272.185
   168.000  1274.396
   168.500  1276.608
   169.000  1278.821
   169.500  1281.036
   170.000  1283.251
   170.500  1285.468
   171.000  1287.685
   171.500  1289.903
   172.000  1292.121
   172.500  1294.341
   173.000  1296.561
   173.500  1298.781
   174.000  1301.002
   174.500  1303.224
   175.000  1305.446
   175.500  1307.667
   176.000  1309.890
   176.500  1312.112
   177.000  1314.335
   177.500  1316.558
   178.000  1318.781
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1177.038
   145.500  1178.665
   146.000  1180.213
   146.500  1181.703
   147.000  1183.143
   147.500  1184.537
   148.000  1185.889
   148.500  1187.202
   149.000  1188.479
   149.500  1189.728
   150.000  1190.951
   150.500  1192.152
   151.000  1193.332
   151.500  1194.493
   152.000  1195.635
   152.500  1196.760
   153.000  1197.869
   153.500  1198.964
   154.000  1200.045
   154.500  1201.113
   155.000  1202.168
   155.500  1203.208
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   510.243
     1.000   510.279
     1.500   510.339
     2.000   510.423
     2.500   510.531
     3.000   510.663
     3.500   510.819
     4.000   510.998
     4.500   511.202
     5.000   511.430
     5.500   511.681
     6.000   511.956
     6.500   512.254
     7.000   512.577
     7.500   512.923
     8.000   513.292
     8.500   513.685
     9.000   514.101
     9.500   514.540
    10.000   515.003
    10.500   515.489
    11.000   515.997
    11.500   516.529
    12.000   517.083
    12.500   517.661
    13.000   518.260
    13.500   518.883
    14.000   519.527
    14.500   520.194
    15.000   520.883
    15.500   521.594
    16.000   522.327
    16.500   523.082
    17.000   523.858
    17.500   524.656
    18.000   525.475
    18.500   526.316
    19.000   527.177
    19.500   528.060
    20.000   528.963
    20.500   529.887
    21.000   530.831
    21.500   531.795
    22.000   532.780
    22.500   533.785
    23.000   534.809
    23.500   535.853
    24.000   536.917
    24.500   538.000
    25.000   539.102
    25.500   540.223
    26.000   541.363
    26.500   542.521
    27.000   543.698
    27.500   544.893
    28.000   546.107
    28.500   547.338
    29.000   548.587
    29.500   549.853
    30.000   551.137
    30.500   552.438
    31.000   553.756
    31.500   555.091
    32.000   556.442
    32.500   557.810
    33.000   559.194
    33.500   560.594
    34.000   562.010
    34.500   563.442
    35.000   564.889
    35.500   566.352
    36.000   567.830
    36.500   569.322
    37.000   570.830
    37.500   572.352
    38.000   573.888
    38.500   575.439
    39.000   577.004
    39.500   578.582
    40.000   580.174
    40.500   581.780
    41.000   583.399
    41.500   585.031
    42.000   586.675
    42.500   588.333
    43.000   590.003
    43.500   591.686
    44.000   593.381
    44.500   595.087
    45.000   596.806
    45.500   598.536
    46.000   600.278
    46.500   602.031
    47.000   603.795
    47.500   605.571
    48.000   607.357
    48.500   609.153
    49.000   610.960
    49.500   612.778
    50.000   614.605
    50.500   616.443
    51.000   618.290
    51.500   620.147
    52.000   622.013
    52.500   623.889
    53.000   625.773
    53.500   627.667
    54.000   629.570
    54.500   631.481
    55.000   633.401
    55.500   635.329
    56.000   637.266
    56.500   639.210
    57.000   641.162
    57.500   643.122
    58.000   645.090
    58.500   647.065
    59.000   649.048
    59.500   651.038
    60.000   653.035
    60.500   655.038
    61.000   657.049
    61.500   659.066
    62.000   661.090
    62.500   663.120
    63.000   665.156
    63.500   667.198
    64.000   669.246
    64.500   671.300
    65.000   673.360
    65.500   675.426
    66.000   677.497
    66.500   679.573
    67.000   681.654
    67.500   683.741
    68.000   685.832
    68.500   687.929
    69.000   690.030
    69.500   692.135
    70.000   694.246
    70.500   696.360
    71.000   698.479
    71.500   700.602
    72.000   702.730
    72.500   704.861
    73.000   706.996
    73.500   709.135
    74.000   711.277
    74.500   713.423
    75.000   715.573
    75.500   717.726
    76.000   719.882
    76.500   722.041
    77.000   724.203
    77.500   726.369
    78.000   728.537
    78.500   730.708
    79.000   732.882
    79.500   735.058
    80.000   737.237
    80.500   739.418
    81.000   741.602
    81.500   743.788
    82.000   745.976
    82.500   748.166
    83.000   750.358
    83.500   752.553
    84.000   754.749
    84.500   756.947
    85.000   759.147
    85.500   761.348
    86.000   763.551
    86.500   765.755
    87.000   767.961
    87.500   770.169
    88.000   772.377
    88.500   774.587
    89.000   776.798
    89.500   779.010
    90.000   781.224
    90.500   783.438
    91.000   785.653
    91.500   787.869
    92.000   790.086
    92.500   792.304
    93.000   794.522
    93.500   796.741
    94.000   798.961
    94.500   801.181
    95.000   803.401
    95.500   805.622
    96.000   807.844
    96.500   810.066
    97.000   812.288
    97.500   814.510
    98.000   816.733
    98.500   818.955
    99.000   821.178
    99.500   823.401
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.956
    29.000   425.513
    29.500   431.070
    30.000   436.627
    30.500   442.182
    31.000   447.735
    31.500   453.287
    32.000   458.837
    32.500   464.384
    33.000   469.929
    33.500   475.470
    34.000   481.008
    34.500   486.541
    35.000   492.070
    35.500   497.594
    36.000   503.112
    36.500   508.625
    37.000   514.130
    37.500   519.629
    38.000   525.120
    38.500   530.602
    39.000   536.076
    39.500   541.540
    40.000   546.994
    40.500   552.438
    41.000   557.871
    41.500   563.292
    42.000   568.700
    42.500   574.096
    43.000   579.479
    43.500   584.847
    44.000   590.202
    44.500   595.541
    45.000   600.865
    45.500   606.174
    46.000   611.466
    46.500   616.741
    47.000   622.000
    47.500   626.764
    48.000   631.335
    48.500   635.901
    49.000   640.463
    49.500   645.019
    50.000   649.571
    50.500   654.117
    51.000   658.659
    51.500   663.194
    52.000   667.724
    52.500   672.249
    53.000   676.767
    53.500   681.280
    54.000   685.785
    54.500   690.282
    55.000   694.771
    55.500   699.249
    56.000   703.717
    56.500   708.177
    57.000   712.631
    57.500   717.079
    58.000   721.523
    58.500   725.962
    59.000   730.397
    59.500   734.827
    60.000   739.254
    60.500   743.677
    61.000   748.097
    61.500   752.512
    62.000   756.924
    62.500   761.332
    63.000   765.736
    63.500   770.136
    64.000   774.531
    64.500   778.922
    65.000   783.308
    65.500   787.688
    66.000   792.063
    66.500   796.432
    67.000   800.794
    67.500   805.149
    68.000   809.496
    68.500   813.837
    69.000   818.169
    69.500   822.494
    70.000   826.812
    70.500   831.122
    71.000   835.424
    71.500   839.719
    72.000   844.006
    72.500   848.286
    73.000   852.558
    73.500   856.822
    74.000   861.079
    74.500   865.328
    75.000   869.568
    75.500   873.801
    76.000   878.026
    76.500   882.243
    77.000   886.452
    77.500   890.652
    78.000   894.844
    78.500   899.027
    79.000   903.203
    79.500   907.369
    80.000   911.527
    80.500   915.676
    81.000   919.817
    81.500   923.950
    82.000   928.073
    82.500   932.189
    83.000   936.296
    83.500   940.394
    84.000   944.484
    84.500   948.565
    85.000   952.637
    85.500   956.701
    86.000   960.756
    86.500   964.802
    87.000   968.840
    87.500   972.868
    88.000   976.888
    88.500   980.899
    89.000   984.900
    89.500   988.893
    90.000   992.877
    90.500   996.852
    91.000  1000.818
    91.500  1004.775
    92.000  1008.723
    92.500  1012.662
    93.000  1016.592
    93.500  1020.513
    94.000  1024.425
    94.500  1028.328
    95.000  1032.222
    95.500  1036.107
    96.000  1039.983
    96.500  1043.849
    97.000  1047.707
    97.500  1051.555
    98.000  1055.395
    98.500  1059.225
    99.000  1063.046
    99.500  1066.858
   100.000  1070.661
   100.500  1074.454
   101.000  1078.239
   101.500  1082.014
   102.000  1085.780
   102.500  1089.537
   103.000  1093.285
   103.500  1097.024
   104.000  1100.754
   104.500  1104.475
   105.000  1108.188
   105.500  1111.891
   106.000  1115.585
   106.500  1119.271
   107.000  1122.947
   107.500  1126.615
   108.000  1130.273
   108.500  1133.922
   109.000  1137.562
   109.500  1141.193
   110.000  1144.815
   110.500  1148.427
   111.000  1152.030
   111.500  1155.623
   112.000  1159.208
   112.500  1162.783
   113.000  1166.349
   113.500  1169.906
   114.000  1173.454
   114.500  1176.993
   115.000  1180.522
   115.500  1184.043
   116.000  1187.554
   116.500  1191.057
   117.000  1194.550
   117.500  1198.035
   118.000  1201.510
   118.500  1204.976
   119.000  1208.433
   119.500  1211.881
   120.000  1215.319
   120.500  1218.749
   121.000  1222.169
   121.500  1225.580
   122.000  1228.981
   122.500  1232.374
   123.000  1235.757
   123.500  1239.132
   124.000  1242.497
   124.500  1245.853
   125.000  1249.200
   125.500  1252.538
   126.000  1255.867
   126.500  1259.187
   127.000  1262.499
   127.500  1265.801
   128.000  1269.094
   128.500  1272.379
   129.000  1275.654
   129.500  1278.921
   130.000  1282.179
   130.500  1285.427
   131.000  1288.667
   131.500  1291.897
   132.000  1295.119
   132.500  1298.331
   133.000  1301.535
   133.500  1304.729
   134.000  1307.915
   134.500  1311.091
   135.000  1314.258
   135.500  1317.416
   136.000  1320.565
   136.500  1323.705
   137.000  1326.836
   137.500  1329.958
   138.000  1333.071
   138.500  1336.174
   139.000  1339.269
   139.500  1342.355
   140.000  1345.431
   140.500  1348.498
   141.000  1351.557
   141.500  1354.606
   142.000  1357.646
   142.500  1360.677
   143.000  1363.699
   143.500  1366.712
   144.000  1369.716
   144.500  1372.711
   145.000  1375.696
   145.500  1378.673
   146.000  1381.640
   146.500  1384.598
   147.000  1387.546
   147.500  1390.486
   148.000  1393.416
   148.500  1396.336
   149.000  1399.247
   149.500  1402.149
   150.000  1405.041
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.624
   100.500   827.847
   101.000   830.069
   101.500   832.292
   102.000   834.515
   102.500   836.738
   103.000   838.961
   103.500   841.184
   104.000   843.406
   104.500   845.629
   105.000   847.852
   105.500   850.075
   106.000   852.298
   106.500   854.521
   107.000   856.743
   107.500   858.966
   108.000   861.189
   108.500   863.412
   109.000   865.635
   109.500   867.858
   110.000   870.081
   110.500   872.303
   111.000   874.526
   111.500   876.749
   112.000   878.972
   112.500   881.195
   113.000   883.417
   113.500   885.640
   114.000   887.863
   114.500   890.086
   115.000   892.309
   115.500   894.532
   116.000   896.755
   116.500   898.977
   117.000   901.200
   117.500   903.423
   118.000   905.646
   118.500   907.869
   119.000   910.091
   119.500   912.314
   120.000   914.537
   120.500   916.760
   121.000   918.983
   121.500   921.206
   122.000   923.429
   122.500   925.651
   123.000   927.874
   123.500   930.097
   124.000   932.320
   124.500   934.543
   125.000   936.766
   125.500   938.988
   126.000   941.211
   126.500   943.434
   127.000   945.657
   127.500   947.880
   128.000   950.103
   128.500   952.325
   129.000   954.548
   129.500   956.771
   130.000   958.994
   130.500   961.217
   131.000   963.440
   131.500   965.662
   132.000   967.885
   132.500   970.108
   133.000   972.331
   133.500   974.554
   134.000   976.777
   134.500   978.999
   135.000   981.222
   135.500   983.445
   136.000   985.668
   136.500   987.891
   137.000   990.114
   137.500   992.336
   138.000   994.559
   138.500   996.782
   139.000   999.005
   139.500  1001.228
   140.000  1003.451
   140.500  1005.673
   141.000  1007.896
   141.500  1010.119
   142.000  1012.342
   142.500  1014.565
   143.000  1016.788
   143.500  1019.010
   144.000  1021.233
   144.500  1023.456
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   386.071
    15.000   396.309
    15.500   406.544
    16.000   416.772
    16.500   426.990
    17.000   437.194
    17.500   447.380
    18.000   457.543
    18.500   467.678
    19.000   477.779
    19.500   487.842
    20.000   497.858
    20.500   507.823
    21.000   517.731
    21.500   527.577
    22.000   537.354
    22.500   547.059
    23.000   555.777
    23.500   563.920
    24.000   572.031
    24.500   580.108
    25.000   588.142
    25.500   596.098
    26.000   604.010
    26.500   611.910
    27.000   619.802
    27.500   627.686
    28.000   635.563
    28.500   643.434
    29.000   651.298
    29.500   659.155
    30.000   667.005
    30.500   674.847
    31.000   682.679
    31.500   690.500
    32.000   698.309
    32.500   706.103
    33.000   713.882
    33.500   721.644
    34.000   729.388
    34.500   737.114
    35.000   744.821
    35.500   752.508
    36.000   760.176
    36.500   767.823
    37.000   775.451
    37.500   783.057
    38.000   790.643
    38.500   798.207
    39.000   805.749
    39.500   813.268
    40.000   820.765
    40.500   828.238
    41.000   835.688
    41.500   843.115
    42.000   850.517
    42.500   857.896
    43.000   865.250
    43.500   872.579
    44.000   879.884
    44.500   887.164
    45.000   894.419
    45.500   901.648
    46.000   908.852
    46.500   916.030
    47.000   923.182
    47.500   930.307
    48.000   937.406
    48.500   944.478
    49.000   951.523
    49.500   958.541
    50.000   965.532
    50.500   972.496
    51.000   979.433
    51.500   986.342
    52.000   993.224
    52.500  1000.077
    53.000  1006.904
    53.500  1013.705
    54.000  1020.480
    54.500  1027.228
    55.000  1033.950
    55.500  1040.645
    56.000  1047.312
    56.500  1053.952
    57.000  1060.564
    57.500  1067.147
    58.000  1073.702
    58.500  1080.230
    59.000  1086.729
    59.500  1093.202
    60.000  1099.646
    60.500  1106.063
    61.000  1112.452
    61.500  1118.813
    62.000  1125.146
    62.500  1131.450
    63.000  1137.726
    63.500  1143.973
    64.000  1150.192
    64.500  1156.382
    65.000  1162.545
    65.500  1168.679
    66.000  1174.784
    66.500  1180.862
    67.000  1186.911
    67.500  1192.932
    68.000  1198.924
    68.500  1204.887
    69.000  1210.822
    69.500  1216.728
    70.000  1222.605
    70.500  1228.454
    71.000  1234.274
    71.500  1240.065
    72.000  1245.827
    72.500  1251.560
    73.000  1257.262
    73.500  1262.935
    74.000  1268.578
    74.500  1274.190
    75.000  1279.773
    75.500  1285.327
    76.000  1290.851
    76.500  1296.346
    77.000  1301.811
    77.500  1307.247
    78.000  1312.651
    78.500  1318.026
    79.000  1323.370
    79.500  1328.685
    80.000  1333.971
    80.500  1339.228
    81.000  1344.454
    81.500  1349.649
    82.000  1354.812
    82.500  1359.943
    83.000  1365.043
    83.500  1370.111
    84.000  1375.148
    84.500  1380.154
    85.000  1385.129
    85.500  1390.072
    86.000  1394.984
    86.500  1399.864
    87.000  1404.711
    87.500  1409.526
    88.000  1414.308
    88.500  1419.057
    89.000  1423.773
    89.500  1428.455
    90.000  1433.103
    90.500  1437.718
    91.000  1442.299
    91.500  1446.846
    92.000  1451.359
    92.500  1455.839
    93.000  1460.284
    93.500  1464.696
    94.000  1469.081
    94.500  1473.449
    95.000  1477.804
    95.500  1482.148
    96.000  1486.479
    96.500  1490.798
    97.000  1495.101
    97.500  1499.383
    98.000  1503.645
    98.500  1507.887
    99.000  1512.110
    99.500  1516.313
   100.000  1520.495
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   721.307
     1.000   721.354
     1.500   721.432
     2.000   721.541
     2.500   721.681
     3.000   721.852
     3.500   722.054
     4.000   722.287
     4.500   722.551
     5.000   722.846
     5.500   723.171
     6.000   723.527
     6.500   723.914
     7.000   724.331
     7.500   724.779
     8.000   725.257
     8.500   725.765
     9.000   726.303
     9.500   726.872
    10.000   727.469
    10.500   728.097
    11.000   728.754
    11.500   729.440
    12.000   730.156
    12.500   730.900
    13.000   731.674
    13.500   732.476
    14.000   733.306
    14.500   734.165
    15.000   735.052
    15.500   735.966
    16.000   736.908
    16.500   737.878
    17.000   738.875
    17.500   739.899
    18.000   740.949
    18.500   742.027
    19.000   743.130
    19.500   744.259
    20.000   745.414
    20.500   746.595
    21.000   747.801
    21.500   749.032
    22.000   750.287
    22.500   751.567
    23.000   752.872
    23.500   754.200
    24.000   755.551
    24.500   756.926
    25.000   758.324
    25.500   759.745
    26.000   761.188
    26.500   762.653
    27.000   764.140
    27.500   765.649
    28.000   767.179
    28.500   768.729
    29.000   770.300
    29.500   771.892
    30.000   773.503
    30.500   775.134
    31.000   776.785
    31.500   778.454
    32.000   780.142
    32.500   781.848
    33.000   783.573
    33.500   785.315
    34.000   787.074
    34.500   788.850
    35.000   790.643
    35.500   792.453
    36.000   794.278
    36.500   796.119
    37.000   797.976
    37.500   799.847
    38.000   801.733
    38.500   803.633
    39.000   805.548
    39.500   807.476
    40.000   809.417
    40.500   811.372
    41.000   813.339
    41.500   815.318
    42.000   817.310
    42.500   819.312
    43.000   821.327
    43.500   823.352
    44.000   825.388
    44.500   827.435
    45.000   829.491
    45.500   831.557
    46.000   833.632
    46.500   835.717
    47.000   837.810
    47.500   839.912
    48.000   842.021
    48.500   844.139
    49.000   846.264
    49.500   848.396
    50.000   850.534
    50.500   852.680
    51.000   854.832
    51.500   856.989
    52.000   859.152
    52.500   861.321
    53.000   863.495
    53.500   865.673
    54.000   867.856
    54.500   870.044
    55.000   872.235
    55.500   874.430
    56.000   876.628
    56.500   878.830
    57.000   881.035
    57.500   883.242
    58.000   885.452
    58.500   887.664
    59.000   889.878
    59.500   892.094
    60.000   894.311
    60.500   896.530
    61.000   898.750
    61.500   900.971
    62.000   903.192
    62.500   905.415
    63.000   907.637
    63.500   909.860
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   933.361
     1.000   933.428
     1.500   933.539
     2.000   933.694
     2.500   933.893
     3.000   934.136
     3.500   934.424
     4.000   934.755
     4.500   935.131
     5.000   935.550
     5.500   936.014
     6.000   936.521
     6.500   937.072
     7.000   937.666
     7.500   938.304
     8.000   938.985
     8.500   939.710
     9.000   940.478
     9.500   941.288
    10.000   942.141
    10.500   943.037
    11.000   943.976
    11.500   944.956
    12.000   945.979
    12.500   947.044
    13.000   948.151
    13.500   949.299
    14.000   950.488
    14.500   951.718
    15.000   952.990
    15.500   954.302
    16.000   955.654
    16.500   957.047
    17.000   958.480
    17.500   959.952
    18.000   961.464
    18.500   963.015
    19.000   964.606
    19.500   966.234
    20.000   967.901
    20.500   969.607
    21.000   971.350
    21.500   973.131
    22.000   974.949
    22.500   976.804
    23.000   978.695
    23.500   980.624
    24.000   982.588
    24.500   984.588
    25.000   986.623
    25.500   988.694
    26.000   990.799
    26.500   992.939
    27.000   995.114
    27.500   997.322
    28.000   999.564
    28.500  1001.839
    29.000  1004.147
    29.500  1006.487
    30.000  1008.860
    30.500  1011.264
    31.000  1013.701
    31.500  1016.168
    32.000  1018.667
    32.500  1021.196
    33.000  1023.755
    33.500  1026.344
    34.000  1028.963
    34.500  1031.611
    35.000  1034.288
    35.500  1036.994
    36.000  1039.728
    36.500  1042.489
    37.000  1045.279
    37.500  1048.095
    38.000  1050.939
    38.500  1053.809
    39.000  1056.705
    39.500  1059.627
    40.000  1062.574
    40.500  1065.547
    41.000  1068.545
    41.500  1071.567
    42.000  1074.614
    42.500  1077.684
    43.000  1080.778
    43.500  1083.895
    44.000  1087.036
    44.500  1090.198
    45.000  1093.383
    45.500  1096.590
    46.000  1099.819
    46.500  1103.069
    47.000  1106.340
    47.500  1109.632
    48.000  1112.944
    48.500  1116.276
    49.000  1119.628
    49.500  1123.000
    50.000  1126.391
    50.500  1129.800
    51.000  1133.228
    51.500  1136.675
    52.000  1140.139
    52.500  1143.621
    53.000  1147.121
    53.500  1150.638
    54.000  1154.171
    54.500  1157.721
    55.000  1161.288
    55.500  1164.870
    56.000  1168.468
    56.500  1172.082
    57.000  1175.710
    57.500  1179.354
    58.000  1183.012
    58.500  1186.685
    59.000  1190.372
    59.500  1194.073
    60.000  1197.787
    60.500  1201.514
    61.000  1205.255
    61.500  1209.009
    62.000  1212.775
    62.500  1216.553
    63.000  1220.344
    63.500  1224.147
    64.000  1227.961
    64.500  1231.786
    65.000  1235.623
    65.500  1239.471
    66.000  1243.329
    66.500  1247.198
    67.000  1251.077
    67.500  1254.966
    68.000  1258.865
    68.500  1262.774
    69.000  1266.692
    69.500  1270.619
    70.000  1274.556
    70.500  1278.501
    71.000  1282.454
    71.500  1286.416
    72.000  1290.386
    72.500  1294.364
    73.000  1298.350
    73.500  1302.343
    74.000  1306.344
    74.500  1310.352
    75.000  1314.367
    75.500  1318.388
    76.000  1322.417
    76.500  1326.451
    77.000  1330.493
    77.500  1334.540
    78.000  1338.593
    78.500  1342.652
    79.000  1346.716
    79.500  1350.786
    80.000  1354.861
    80.500  1358.941
    81.000  1363.026
    81.500  1367.116
    82.000  1371.211
    82.500  1375.309
    83.000  1379.413
    83.500  1383.520
    84.000  1387.631
    84.500  1391.746
    85.000  1395.865
    85.500  1399.988
    86.000  1404.113
    86.500  1408.243
    87.000  1412.375
    87.500  1416.510
    88.000  1420.648
    88.500  1424.789
    89.000  1428.932
    89.500  1433.078
    90.000  1437.226
    90.500  1441.376
    91.000  1445.529
    91.500  1449.683
    92.000  1453.839
    92.500  1457.997
    93.000  1462.157
    93.500  1466.318
    94.000  1470.480
    94.500  1474.644
    95.000  1478.808
    95.500  1482.974
    96.000  1487.141
    96.500  1491.308
    97.000  1495.477
    97.500  1499.645
    98.000  1503.815
    98.500  1507.984
    99.000  1512.154
    99.500  1516.325
   100.000  1520.495
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   774.025
    29.500   784.264
    30.000   794.503
    30.500   804.739
    31.000   814.973
    31.500   825.204
    32.000   835.430
    32.500   845.652
    33.000   855.867
    33.500   866.076
    34.000   876.277
    34.500   886.469
    35.000   896.651
    35.500   906.822
    36.000   916.980
    36.500   927.125
    37.000   937.254
    37.500   947.367
    38.000   957.462
    38.500   967.135
    39.000   977.591
    39.500   987.623
    40.000   997.630
    40.500  1007.612
    41.000  1017.567
    41.500  1027.494
    42.000  1037.391
    42.500  1047.256
    43.000  1057.089
    43.500  1066.888
    44.000  1076.652
    44.500  1086.380
    45.000  1096.070
    45.500  1105.489
    46.000  1113.659
    46.500  1121.813
    47.000  1129.950
    47.500  1138.070
    48.000  1146.173
    48.500  1154.261
    49.000  1162.331
    49.500  1170.380
    50.000  1178.404
    50.500  1186.391
    51.000  1194.323
    51.500  1202.239
    52.000  1210.148
    52.500  1218.051
    53.000  1225.949
    53.500  1233.843
    54.000  1241.733
    54.500  1249.620
    55.000  1257.502
    55.500  1265.381
    56.000  1273.257
    56.500  1281.130
    57.000  1288.999
    57.500  1296.865
    58.000  1304.728
    58.500  1312.587
    59.000  1320.443
    59.500  1328.295
    60.000  1336.144
    60.500  1343.988
    61.000  1351.828
    61.500  1359.664
    62.000  1367.494
    62.500  1375.318
    63.000  1383.137
    63.500  1390.949
    64.000  1398.755
    64.500  1406.553
    65.000  1414.345
    65.500  1422.128
    66.000  1429.904
    66.500  1437.671
    67.000  1445.429
    67.500  1453.179
    68.000  1460.919
    68.500  1468.651
    69.000  1476.373
    69.500  1484.085
    70.000  1491.788
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     1.235    39.068     0.150
     6.152    95.068     0.150
     6.152    95.268     0.150
     8.639   125.869     0.150
    12.246   381.068     0.150
    15.702    35.000     0.150
    17.561   275.068     0.150
    20.396   280.469     0.150
     1.270    24.887     0.150
     5.192   163.688     0.150
     5.809   183.188     0.150
     6.107    93.887     0.150
     7.150   229.688     0.150
     8.638   268.688     0.150
     1.187    22.615     0.150
     3.819    40.514     0.150
     6.149    95.314     0.150
     8.600   270.314     0.150
     8.766   124.314     0.150
     9.936   147.314     0.150
     9.936   147.314     0.150
    12.137   174.814     0.150
    12.199   173.914     0.150
    17.545   553.314     0.150
    18.568   257.715     0.150
    20.348   278.814     0.150
    21.661   291.314     0.150
    29.084   366.314     0.150
    33.340   397.314     0.150
    33.340   397.314     0.150
    33.664   384.314     0.150
    33.664   384.314     0.150
    46.341   506.314     0.150
    46.341     5.000     0.150
    49.082   527.215     0.150
    58.791   598.314     0.150
    58.834   602.814     0.150
    59.062   608.115     0.150
    59.375   606.514     0.150
    61.185   614.314     0.150
    62.310   622.314     0.150
    63.681   631.115     0.150
    63.681  1139.615     0.150
    73.135   687.314     0.150
    73.135   687.314     0.150
    73.658   694.314     0.150
    78.199   719.314     0.150
    78.466   721.814     0.150
   105.210   877.514     0.150
     8.605   125.203     0.150
     9.943   146.703     0.150
    12.148   175.402     0.150
    18.562   446.203     0.150
    18.562   257.703     0.150
    18.562   446.203     0.150
    20.357   277.504     0.150
    21.668   291.305     0.150
    24.098   322.203     0.150
    24.098   365.203     0.150
    24.820   607.203     0.150
    25.134   332.703     0.150
    25.134   338.703     0.150
    25.510   356.203     0.150
    25.510   379.203     0.150
    26.381   341.203     0.150
    33.332   404.203     0.150
    33.332    18.000     0.150
    33.332   404.203     0.150
    33.332    18.000     0.150
    33.655   404.703     0.150
    35.274   415.203     0.150
    35.274   741.203     0.150
    38.413   435.902     0.150
    39.141    22.000     0.150
    39.141   448.203     0.150
    39.141    22.000     0.150
    45.314   505.203     0.150
    45.314   505.203     0.150
    45.314   899.004     0.150
    46.340   506.203     0.150
    56.985   587.203     0.150
    58.786   599.203     0.150
    59.066   599.203     0.150
    59.760   609.004     0.150
    62.311   623.203     0.150
    63.678   631.504     0.150
    65.064   640.203     0.150
    67.286   654.402     0.150
    68.912   661.203     0.150
    78.468   722.203     0.150
     1.334    23.047     0.150
     1.334    43.852     0.150
     1.788    30.133     0.150
     4.997    90.750     0.150
     1.319    21.219     0.150
     1.645    51.266     0.150
     2.227    69.066     0.150
     3.581    56.066     0.150
     4.702    70.309     0.150
     6.630    94.668     0.150
     7.022   127.668     0.150
     8.650   155.156     0.150
     1.293    21.367     0.150
     1.756    54.020     0.150
     2.230    39.801     0.150
     2.230    69.988     0.150
     8.628   127.379     0.150
    21.680   295.879     0.150
     3.912    53.438     0.150
     5.252    82.588     0.150
     0.459    18.582     0.150
     1.676    28.484     0.150
     1.861    30.383     0.150
     1.919    58.684     0.150
     2.263    71.383     0.150
     2.263    70.582     0.150
     3.344    53.883     0.150
     4.930    89.453     0.150
     4.930   150.812     0.150
     6.055    95.883     0.150
    12.093   170.082     0.150
     1.177    38.359     0.150
     3.567    46.160     0.150
     5.296    78.098     0.150
     5.619    83.590     0.150
     6.076    88.961     0.150
     0.357     6.094     0.150
     0.547    19.594     0.150
     0.615    22.289     0.150
     1.725    29.195     0.150
     1.953    61.891     0.150
     4.888    75.641     0.150
     5.195    76.953     0.150
     5.556    84.094     0.150
     5.964    89.594     0.150
     0.312     8.969     0.150
     0.328     7.273     0.150
     0.740    15.898     0.150
     1.027   -34.828     0.150
     1.027    35.375     0.150
     1.192    41.430     0.150
     1.408    44.484     0.150
     2.416    42.969     0.150
     3.480    45.484     0.150
     3.819    63.523     0.150
     5.274    94.672     0.150
     8.504   128.125     0.150
     0.585    21.027     0.150
     0.695    25.516     0.150
     1.121    36.447     0.150
     3.838    56.047     0.150
     4.083    61.176     0.150
     5.224    93.896     0.150
     0.688    25.289     0.150
     1.129    37.438     0.150
     2.394    35.559     0.150
     2.394    70.059     0.150
     3.501    55.777     0.150
     3.846    55.707     0.150
     4.858    71.559     0.150
     5.218    93.480     0.150
     5.218    74.758     0.150
     5.667    81.059     0.150
    47.985   510.160     0.150
     0.425     9.236     0.150
     0.425    15.736     0.150
     0.650    30.736     0.150
     0.856    17.537     0.150
     0.856    30.836     0.150
     1.226    41.336     0.150
     1.535    50.836     0.150
     3.642    55.936     0.150
     5.123   164.111     0.150
     8.732   130.637     0.150
    24.559   322.707     0.150
    36.524   429.807     0.150
     1.263    41.852     0.150
     1.537    50.254     0.150
     3.754   112.551     0.150
     5.109    81.051     0.150
     5.106    91.176     0.150
     8.773   133.051     0.150
    21.440   295.152     0.150
     0.493    18.592     0.150
     1.785    31.650     0.150
     1.785    55.102     0.150
     2.296    38.721     0.150
     2.296    40.301     0.150
     2.296    68.262     0.150
     2.296    69.730     0.150
     5.012    76.551     0.150
     5.012    77.531     0.150
     5.012   156.111     0.150
     2.278    43.176     0.150
     2.278    73.027     0.150
     5.409    81.938     0.150
     8.642   261.996     0.150
    21.437   294.727     0.150
    27.539   350.125     0.150
    39.048   446.879     0.150
     1.373    25.398     0.150
     1.373    43.047     0.150
     2.530    73.242     0.150
     2.371    39.844     0.150
     2.371    70.242     0.150
     4.786    75.750     0.150
     6.063    93.914     0.150
     3.167    46.852     0.150
     4.538    67.480     0.150
     5.224    78.191     0.150
     5.224    93.516     0.150
     5.224    93.543     0.150
     5.276    81.582     0.150
     5.698   102.082     0.150
     5.698    82.594     0.150
     5.698   102.082     0.150
     5.698   148.480     0.150
     5.698   175.941     0.150
     6.047    89.121     0.150
    10.257   147.117     0.150
    10.257   147.121     0.150
    12.201   170.191     0.150
    12.206   176.594     0.150
    12.206   172.891     0.150
    12.206   381.691     0.150
    25.610   331.031     0.150
    25.610   331.035     0.150
    41.113   461.926     0.150
    50.138   532.855     0.150
    58.202   592.492     0.150
    58.202   592.488     0.150
     0.587    20.691     0.150
     0.587    11.078     0.150
     0.587    20.691     0.150
     0.677    25.109     0.150
     1.008    18.121     0.150
     1.080    19.008     0.150
     1.163    20.898     0.150
     1.519    48.520     0.150
     1.519    26.488     0.150
     1.519    48.531     0.150
     3.855    61.461     0.150
     1.152    22.273     0.150
     2.288    39.719     0.150
     2.288    43.172     0.150
     2.288    70.398     0.150
     2.288    73.180     0.150
     5.085    76.773     0.150
     5.085    91.469     0.150
     5.407    79.898     0.150
     5.416    81.398     0.150
     7.665   113.555     0.150
     8.582   125.430     0.150
     8.582   258.148     0.150
     8.582   125.359     0.150
     8.582   125.555     0.150
     8.783   127.203     0.150
     8.783   128.703     0.150
     9.907   150.641     0.150
     9.996   148.672     0.150
     9.996   251.203     0.150
    10.133   316.750     0.150
    10.133   147.773     0.150
    10.133   262.820     0.150
    10.133   316.750     0.150
    12.095   173.203     0.150
    12.100   172.453     0.150
    12.100   376.539     0.150
    17.518   246.633     0.150
    24.162   321.898     0.150
    24.162   355.602     0.150
    24.162   624.102     0.150
    26.169   337.102     0.150
    31.272   382.000     0.150
    31.945   387.055     0.150
    36.479   425.609     0.150
    37.330   434.500     0.150
    37.784   440.000     0.150
    40.570  1031.703     0.150
    45.910  1091.203     0.150
    48.685   521.602     0.150
    48.685   967.102     0.150
    53.164     5.297     0.150
    53.164     9.102     0.150
    53.164   558.102     0.150
    53.684     4.477     0.150
    55.638   774.602     0.150
    55.638  1262.203     0.150
    57.033   585.672     0.150
    57.061   588.898     0.150
    57.580   592.805     0.150
    57.580   592.805     0.150
    57.581   803.805     0.150
    58.042   589.703     0.150
    60.451   648.703     0.150
    60.544   606.602     0.150
    60.923   613.375     0.150
    61.112   615.000     0.150
    61.112   615.000     0.150
    63.891   909.203     0.150
    64.445   643.805     0.150
    64.445   783.602     0.150
    64.445   875.500     0.150
    66.692   650.398     0.150
    66.692     4.805     0.150
    66.692   650.398     0.150
    66.692     4.805     0.150
    66.953   653.398     0.150
    67.107   653.805     0.150
    67.107   653.805     0.150
    67.107   653.805     0.150
    67.261   654.703     0.150
    67.261     4.602     0.150
    67.261   877.703     0.150
    67.960   659.602     0.150
    67.960     4.500     0.150
    68.007    13.102     0.150
    68.254    10.297     0.150
    68.254   675.500     0.150
    68.254  1217.602     0.150
    68.392   655.500     0.150
    68.626   661.203     0.150
    68.712   669.500     0.150
    68.745   664.203     0.150
    68.769   664.805     0.150
    69.117   663.102     0.150
    69.193   667.000     0.150
    69.444   667.500     0.150
    69.534   672.594     0.150
    69.576   673.500     0.150
    69.584   924.703     0.150
    70.267   679.398     0.150
    70.267     0.000     0.150
    70.503   681.500     0.150
    70.503     0.000     0.150
    70.584   680.039     0.150
    70.848   681.453     0.150
    70.921   684.102     0.150
    70.921     0.000     0.150
    71.033    10.500     0.150
    71.957   693.305     0.150
    72.690    10.656     0.150
    73.196   736.000     0.150
    73.665   690.398     0.150
    74.008   696.609     0.150
    74.286   692.555     0.150
    76.252  1301.102     0.150
    76.250   714.602     0.150
    76.531   884.305     0.150
    76.632   716.602     0.150
    76.635  1792.500     0.150
    76.780   718.602     0.150
    77.334   720.602     0.150
    77.873  1616.898     0.150
    78.571   727.602     0.150
    78.671   727.602     0.150
    78.761   733.602     0.150
    78.880   732.602     0.150
    79.287   721.273     0.150
    79.462   734.102     0.150
    83.536   753.000     0.150
    83.591  1691.000     0.150
    84.229   766.289     0.150
    84.229   959.844     0.150
    84.763   933.500     0.150
    87.244   963.398     0.150
    94.976   806.180     0.150
   135.908  1161.234     0.150
     0.867    31.086     0.150
     2.303    41.922     0.150
     2.303    72.805     0.150
     5.091    90.102     0.150
     5.091    92.195     0.150
     5.091   157.703     0.150
     6.168    95.172     0.150
     9.909   148.547     0.150
    10.002   148.578     0.150
    11.953   165.562     0.150
    12.111   172.273     0.150
    13.492   419.062     0.150
    13.705   428.742     0.150
    14.498   465.758     0.150
    14.622   403.922     0.150
    22.734   706.523     0.150
    24.165   325.477     0.150
    24.165   352.273     0.150
    31.273   382.172     0.150
    31.964   387.875     0.150
    33.597   396.578     0.150
    33.597   491.273     0.150
    45.349   504.578     0.150
    50.184   536.023     0.150
    57.051   587.047     0.150
    58.041   593.375     0.150
    58.041     4.102     0.150
    58.246   594.953     0.150
    63.892     7.398     0.150
    63.892   907.078     0.150
    64.035   632.742     0.150
    65.067   645.977     0.150
    65.328   640.648     0.150
    67.126   658.273     0.150
    67.126   658.273     0.150
    67.126   658.273     0.150
    68.004   655.875     0.150
    68.142   661.977     0.150
    68.251    10.305     0.150
    68.251   675.977     0.150
    68.914   671.578     0.150
    68.914   670.875     0.150
    69.486     7.000     0.150
    69.587     2.398     0.150
    69.587     3.898     0.150
    71.035     9.898     0.150
    76.268   712.578     0.150
    76.540   877.672     0.150
    80.343   732.773     0.150
    84.237   766.484     0.150
     2.298    38.859     0.150
     2.298    41.977     0.150
     2.298    68.562     0.150
     2.298    72.008     0.150
     5.091    91.633     0.150
     5.409    81.797     0.150
     6.161    96.406     0.150
     8.590   128.234     0.150
     8.590   128.242     0.150
     8.590   219.836     0.150
     8.590   269.930     0.150
     8.590   128.359     0.150
     8.590   266.297     0.150
     0.878    29.895     0.150
     1.337    25.594     0.150
     2.286    39.164     0.150
     2.286    42.332     0.150
     2.286    72.785     0.150
     5.090    90.312     0.150
     5.090    78.332     0.150
     5.090    90.555     0.150
     8.569   267.152     0.150
     8.771   130.422     0.150
    12.092   174.422     0.150
    12.096   172.914     0.150
    12.096   379.555     0.150
    20.634   282.332     0.150
    36.488   425.914     0.150
     2.293    39.977     0.150
     0.836    17.139     0.150
     0.836    27.490     0.150
     1.117    20.129     0.150
     1.117    34.260     0.150
     1.117    20.129     0.150
     1.117    34.260     0.150
     2.326    39.129     0.150
     2.326    70.930     0.150
     2.210    37.420     0.150
     5.220    93.160     0.150
     5.220    93.160     0.150
     5.220   162.490     0.150
     5.582    87.330     0.150
    11.011   158.389     0.150
    11.622   167.020     0.150
     2.292    42.273     0.150
     2.292    72.383     0.150
     3.945    62.297     0.150
     5.087    90.406     0.150
     6.148   188.188     0.150
    23.304   302.438     0.150
     1.719    30.445     0.150
     2.346    39.492     0.150
     2.346    69.844     0.150
     3.946    60.477     0.150
     0.216     5.027     0.150
     0.447     8.859     0.150
     0.447    16.109     0.150
     0.968    17.918     0.150
     0.968    30.590     0.150
     1.149    21.180     0.150
     1.149    36.371     0.150
     1.176    37.199     0.150
     1.271    41.379     0.150
     1.389    25.211     0.150
     1.389    43.438     0.150
     1.521    48.121     0.150
     1.521    28.070     0.150
     1.521    48.121     0.150
     1.453    26.891     0.150
     1.453    45.777     0.150
     1.584    26.949     0.150
     1.752    31.328     0.150
     1.752    55.039     0.150
     1.805    57.070     0.150
     2.131    66.879     0.150
     2.131    36.719     0.150
     2.131    66.879     0.150
     2.356    45.180     0.150
     2.356    73.680     0.150
     2.418    40.879     0.150
     3.121    49.070     0.150
     5.289   164.578     0.150
     4.651    86.353     0.150
     5.186    84.362     0.150
     0.534    10.084     0.150
     0.564    21.764     0.150
     1.144    38.193     0.150
     1.245    22.544     0.150
     1.577    27.164     0.150
     1.644    52.964     0.150
     1.709    54.674     0.150
     2.417    40.124     0.150
     3.898    60.863     0.150
     4.052    62.144     0.150
     5.044   140.084     0.150
     5.236   152.483     0.150
     5.876    84.943     0.150
     6.006   150.574     0.150
     0.356    13.953     0.150
     0.541    10.203     0.150
     0.787    15.354     0.150
     0.957    18.723     0.150
     1.338    25.693     0.150
     1.260    24.293     0.150
     1.638    54.744     0.150
     1.707    31.213     0.150
     1.707    55.543     0.150
     1.785    31.514     0.150
     2.306    73.953     0.150
     2.374    40.273     0.150
     3.881    61.303     0.150
     3.956    61.834     0.150
     4.334    70.482     0.150
     5.080    78.934     0.150
     5.201    93.693     0.150
     5.201   162.764     0.150
     5.444    85.062     0.150
     5.658    83.584     0.150
     5.700    80.113     0.150
     5.700    87.863     0.150
     5.700   146.113     0.150
     5.700   174.904     0.150
     5.700    80.113     0.150
     5.700   146.113     0.150
     5.836    91.543     0.150
     6.029    92.914     0.150
     6.223   109.943     0.150
     6.603   116.723     0.150
     6.603   201.104     0.150
     7.143   179.982     0.150
     8.550   124.213     0.150
     8.550   218.789     0.150
     8.550   266.863     0.150
     9.495   137.283     0.150
    25.603   325.123     0.150
    25.603   325.127     0.150
     0.567    10.613     0.150
     0.567    17.832     0.150
     0.549    10.732     0.150
     0.605    12.264     0.150
     0.829    16.672     0.150
     0.829    28.273     0.150
     0.996    17.604     0.150
     1.029    19.582     0.150
     1.029    34.213     0.150
     1.078    34.662     0.150
     1.081    33.143     0.150
     1.081    19.354     0.150
     1.122    21.973     0.150
     1.122    37.383     0.150
     1.256    24.533     0.150
     1.294    39.613     0.150
     1.294    22.982     0.150
     1.379    26.133     0.150
     1.369    23.943     0.150
     1.620    28.832     0.150
     1.716    29.523     0.150
     1.757    30.264     0.150
     1.879    32.562     0.150
     2.180    38.014     0.150
     2.342    75.422     0.150
     2.762    45.143     0.150
     3.643    59.943     0.150
     0.351     7.326     0.150
     0.592    12.646     0.150
     0.592    12.676     0.150
     0.592    22.236     0.150
     0.587    11.197     0.150
     0.863    17.637     0.150
     0.863    30.598     0.150
     0.899    16.756     0.150
     0.899    28.416     0.150
     0.937    19.547     0.150
     1.165    21.166     0.150
     1.397    46.486     0.150
     1.562    27.777     0.150
     1.817    33.396     0.150
     2.385    41.467     0.150
     0.325    11.828     0.150
     0.537    10.258     0.150
     0.791    25.133     0.150
     0.818    15.758     0.150
     0.860    16.719     0.150
     0.860    29.273     0.150
     0.983    18.867     0.150
     1.156    21.836     0.150
     1.156    38.328     0.150
     1.182    20.914     0.150
     1.359    25.758     0.150
     1.288    24.602     0.150
     1.405    45.055     0.150
     1.583    27.492     0.150
     1.707    54.875     0.150
     1.707    30.953     0.150
     1.714    30.172     0.150
     1.826    32.117     0.150
     2.295    71.445     0.150
     6.688    93.094     0.150
     0.412     8.295     0.150
     0.412    14.504     0.150
     0.454     8.504     0.150
     0.673    13.834     0.150
     0.765    15.145     0.150
     0.765    15.115     0.150
     0.765    25.615     0.150
     0.909    16.734     0.150
     0.909    30.475     0.150
     0.970    18.854     0.150
     0.970    32.674     0.150
     0.982    19.344     0.150
     0.982    19.375     0.150
     0.982    32.844     0.150
     0.982    19.396     0.150
     0.982    32.943     0.150
     1.049    18.914     0.150
     1.190    22.504     0.150
     1.190    38.635     0.150
     1.190    22.449     0.150
     1.258    23.693     0.150
     1.258    23.725     0.150
     1.264    41.773     0.150
     1.264    22.615     0.150
     1.264    41.773     0.150
     1.278    24.984     0.150
     1.278    42.555     0.150
     1.389    26.854     0.150
     1.389    45.594     0.150
     1.389    45.631     0.150
     1.303    23.164     0.150
     1.303    42.074     0.150
     1.522    49.494     0.150
     1.655    29.193     0.150
     1.655    52.545     0.150
     1.705    29.834     0.150
     1.705    54.314     0.150
     1.734    32.115     0.150
     1.734    32.094     0.150
     1.734    56.135     0.150
     1.734    32.094     0.150
     1.808    33.324     0.150
     1.808    33.285     0.150
     1.808    57.914     0.150
     1.836    32.594     0.150
     1.836    57.975     0.150
     1.925    61.990     0.150
     2.108    38.805     0.150
     2.108    67.574     0.150
     2.326    39.705     0.150
     2.326    70.725     0.150
     2.810    45.875     0.150
     2.863    47.129     0.150
     3.168    52.273     0.150
     3.282    52.494     0.150
     3.960    63.305     0.150
     3.960   109.523     0.150
     4.115    64.779     0.150
     5.112    92.865     0.150
     5.112    92.865     0.150
     5.286    80.311     0.150
     8.400   121.904     0.150
     0.826    28.951     0.150
     2.367    76.053     0.150
     1.282    40.412     0.150
     2.429    77.273     0.150
     0.405     7.928     0.150
     0.421     8.299     0.150
     0.685    14.188     0.150
     0.786    15.158     0.150
     1.018    19.639     0.150
     1.018    33.719     0.150
     1.018    19.635     0.150
     1.018    33.805     0.150
     1.213    22.527     0.150
     1.271    23.959     0.150
     1.271    23.936     0.150
     1.312    24.938     0.150
     1.783    32.469     0.150
     1.783    58.209     0.150
     1.783    32.408     0.150
     1.856    60.928     0.150
     2.451    42.537     0.150
     2.451    77.107     0.150
     2.451    42.484     0.150
     2.716    45.340     0.150
     2.907    47.838     0.150
     3.185    52.559     0.150
     3.307    53.328     0.150
     3.492    54.980     0.150
     3.564    57.938     0.150
     4.008    63.648     0.150
     4.242    64.848     0.150
     4.732    73.109     0.150
     4.991    74.678     0.150
     5.091   155.668     0.150
     8.653   121.258     0.150
     8.653   220.148     0.150
     0.993    30.590     0.150
     2.460    46.590     0.150
     0.372    13.188     0.150
     0.501     9.668     0.150
     0.501    17.359     0.150
     0.501     9.656     0.150
     0.629    13.020     0.150
     0.629    23.160     0.150
     0.693    12.965     0.150
     0.781    15.160     0.150
     0.781    15.160     0.150
     0.781    25.738     0.150
     0.852    15.039     0.150
     0.852    27.020     0.150
     0.987    17.688     0.150
     0.987    30.777     0.150
     0.970    32.160     0.150
     0.970    18.949     0.150
     0.970    18.949     0.150
     0.970    31.508     0.150
     0.970    18.980     0.150
     1.201    37.488     0.150
     1.211    37.969     0.150
     1.211    22.930     0.150
     1.211    37.969     0.150
     1.211    22.863     0.150
     1.200    22.520     0.150
     1.200    38.688     0.150
     1.200    22.410     0.150
     1.243    21.879     0.150
     1.243    39.148     0.150
     1.363    26.098     0.150
     1.363    44.309     0.150
     1.271    24.367     0.150
     1.284    23.723     0.150
     1.594    28.277     0.150
     1.594    49.891     0.150
     1.643    28.828     0.150
     1.643    52.039     0.150
     1.680    30.828     0.150
     1.680    53.699     0.150
     1.680    30.699     0.150
     1.751    32.078     0.150
     1.751    32.078     0.150
     1.751    55.348     0.150
     1.774    31.180     0.150
     1.774    55.617     0.150
     1.748    30.828     0.150
     1.748    30.828     0.150
     1.748    55.090     0.150
     1.748    30.836     0.150
     2.235    37.355     0.150
     2.264    38.441     0.150
     2.348    73.867     0.150
     2.348    39.898     0.150
     2.348    73.867     0.150
     2.755    45.684     0.150
     2.801    45.715     0.150
     2.986    47.430     0.150
     3.219    52.340     0.150
     3.351    52.527     0.150
     3.849   121.008     0.150
     3.917    62.016     0.150
     4.411    67.320     0.150
     5.167    78.008     0.150
     5.167   160.141     0.150
     5.167    77.930     0.150
     5.226    77.391     0.150
     6.884    99.969     0.150
     7.426   109.238     0.150
     7.981   115.480     0.150
     8.491   214.867     0.150
     8.491   124.250     0.150
     8.491   214.867     0.150
     8.491   262.719     0.150
     8.554   122.949     0.150
     8.554   217.848     0.150
     8.554   265.648     0.150
     8.578   216.680     0.150
     8.578   216.680     0.150
     9.123   287.098     0.150
     9.416   297.961     0.150
     9.538   137.609     0.150
     9.609   139.312     0.150
    12.163   303.414     0.150
    13.147   186.902     0.150
    24.585   320.840     0.150
    26.129   333.520     0.150
    55.247  4151.949     0.150
    56.382  4209.402     0.150
    56.395  4202.055     0.150
    56.399  4212.941     0.150
     0.319     6.623     0.150
     0.319    11.249     0.150
     0.568    10.641     0.150
     0.830    16.474     0.150
     0.830    28.091     0.150
     1.031    19.476     0.150
     1.031    33.550     0.150
     1.099    36.283     0.150
     1.099    20.665     0.150
     1.122    21.026     0.150
     1.122    36.276     0.150
     1.255    24.289     0.150
     1.624    28.943     0.150
     1.612    30.597     0.150
     1.673    30.660     0.150
     2.254    42.823     0.150
     2.254    72.243     0.150
     2.339    75.593     0.150
     2.339    74.816     0.150
     3.111    57.123     0.150
     0.492     9.664     0.150
     0.492    16.758     0.150
     0.520    17.273     0.150
     0.675    12.570     0.150
     0.957    18.586     0.150
     1.060    19.047     0.150
     1.060    33.590     0.150
     1.111    20.777     0.150
     1.186    38.078     0.150
     1.192    38.121     0.150
     1.346    25.648     0.150
     1.288    23.773     0.150
     1.732    55.457     0.150
     1.753    31.246     0.150
     1.753    54.203     0.150
     2.329    72.938     0.150
     2.329    73.863     0.150
     2.327    73.887     0.150
     2.327    73.543     0.150
     3.794    60.148     0.150
     3.898    60.996     0.150
     0.357    13.188     0.150
     0.509     9.473     0.150
     0.509    16.168     0.150
     0.502     9.719     0.150
     0.502     9.656     0.150
     0.614    12.609     0.150
     0.688    12.336     0.150
     0.980    18.398     0.150
     1.060    18.879     0.150
     1.060    18.859     0.150
     1.130    20.543     0.150
     1.214    22.207     0.150
     1.369    25.434     0.150
     1.299    23.516     0.150
     1.582    50.539     0.150
     1.678    53.023     0.150
     1.747    55.449     0.150
     1.761    55.008     0.150
     1.776    30.395     0.150
     2.249    70.348     0.150
     2.349    73.816     0.150
     2.349    39.246     0.150
     2.349    72.930     0.150
     2.346    74.168     0.150
     2.346    73.230     0.150
     2.472    76.914     0.150
     2.794    44.648     0.150
     2.859    45.895     0.150
     2.883    44.949     0.150
     3.034    48.828     0.150
     3.366    91.387     0.150
     3.390    53.629     0.150
     3.817    59.793     0.150
     3.918    60.645     0.150
     0.588    11.156     0.150
     0.611    11.695     0.150
     0.611    20.039     0.150
     0.920    28.609     0.150
     0.911    18.359     0.150
     1.043    19.977     0.150
     1.043    34.070     0.150
     1.105    35.195     0.150
     1.166    22.500     0.150
     1.593    29.672     0.150
     1.711    31.359     0.150
     2.224    66.984     0.150
     2.264    72.344     0.150
     2.264    39.312     0.150
     2.394    75.586     0.150
     2.394    40.898     0.150
     2.394    75.984     0.150
     3.308    53.016     0.150
     4.419   140.414     0.150
     0.367     7.727     0.150
     0.913    16.256     0.150
     1.127    19.977     0.150
     1.114    19.896     0.150
     1.182    22.297     0.150
     2.265    72.066     0.150
     2.241    38.396     0.150
     2.274    72.057     0.150
     2.395    40.227     0.150
     2.395    76.768     0.150
     3.614    57.826     0.150
     4.433    66.707     0.150
     0.456     8.507     0.150
     0.452    16.659     0.150
     0.452     9.381     0.150
     0.758    14.074     0.150
     0.758    23.991     0.150
     0.971    19.332     0.150
     1.176    39.042     0.150
     1.225    23.029     0.150
     1.225    40.101     0.150
     1.273    23.815     0.150
     1.272    22.799     0.150
     1.382    26.829     0.150
     1.677    30.159     0.150
     1.758    33.380     0.150
     1.758    56.955     0.150
     2.243    39.442     0.150
     2.541    83.727     0.150
     0.377     7.908     0.150
     0.493    15.768     0.150
     0.493     9.447     0.150
     0.493    15.869     0.150
     0.477     9.104     0.150
     0.637    12.928     0.150
     0.718    13.008     0.150
     0.718    12.998     0.150
     0.718    22.338     0.150
     0.785    14.869     0.150
     0.868    16.139     0.150
     0.931    17.639     0.150
     0.985    18.648     0.150
     0.985    18.688     0.150
     0.985    31.459     0.150
     1.029    18.527     0.150
     1.029    19.008     0.150
     1.207    22.148     0.150
     1.207    22.318     0.150
     1.221    22.537     0.150
     1.382    43.971     0.150
     1.382    26.027     0.150
     1.382    44.158     0.150
     1.284    24.068     0.150
     1.276    23.154     0.150
     1.276    23.318     0.150
     1.614    27.969     0.150
     1.705    31.270     0.150
     1.776    56.309     0.150
     1.777    31.027     0.150
     1.777    54.078     0.150
     1.808    31.209     0.150
     2.220    69.207     0.150
     2.272    37.904     0.150
     2.272    66.578     0.150
     2.366    39.334     0.150
     2.366    74.295     0.150
     2.366    39.357     0.150
     2.366    74.607     0.150
     2.374    74.893     0.150
     2.503    78.070     0.150
     2.772    44.789     0.150
     2.974    49.268     0.150
     3.051    49.129     0.150
     3.229    51.059     0.150
     3.323    51.928     0.150
     3.323    51.947     0.150
     3.344    51.533     0.150
     3.344    51.498     0.150
     3.421    53.848     0.150
     3.833    60.035     0.150
     3.833    60.098     0.150
     4.085    62.357     0.150
     4.383    68.268     0.150
     4.691    72.133     0.150
     4.691    72.129     0.150
     5.152    90.809     0.150
     5.270    76.459     0.150
     5.301    80.842     0.150
     6.153    91.719     0.150
     0.442     8.676     0.150
     0.442    14.965     0.150
     0.442     8.797     0.150
     0.403     8.238     0.150
     0.479     9.367     0.150
     0.479    16.262     0.150
     0.479     9.406     0.150
     0.778    14.887     0.150
     0.760    13.668     0.150
     0.760    13.707     0.150
     0.989    17.977     0.150
     0.996    19.086     0.150
     0.996    19.105     0.150
     0.996    32.578     0.150
     1.052    18.477     0.150
     1.248    23.094     0.150
     1.248    23.168     0.150
     1.251    22.520     0.150
     1.251    22.605     0.150
     1.292    24.438     0.150
     1.403    26.516     0.150
     1.520    26.758     0.150
     1.518    25.578     0.150
     1.654    51.898     0.150
     1.744    31.645     0.150
     1.794    32.270     0.150
     1.816    32.758     0.150
     1.837    32.297     0.150
     1.940    32.629     0.150
     2.184    35.137     0.150
     2.167    34.719     0.150
     2.270    39.324     0.150
     2.270    39.457     0.150
     2.336    39.906     0.150
     2.336    39.898     0.150
     2.336    70.328     0.150
     2.412    76.176     0.150
     2.722    44.977     0.150
     2.788    46.406     0.150
     2.942    47.668     0.150
     2.942    47.629     0.150
     3.077    50.711     0.150
     3.190    49.066     0.150
     3.162    52.016     0.150
     3.174    51.809     0.150
     3.460    55.613     0.150
     3.643    58.277     0.150
     3.746    66.598     0.150
     3.835    60.137     0.150
     3.858    61.652     0.150
     3.859    67.941     0.150
     4.352    66.883     0.150
     4.429    68.977     0.150
     4.676    72.742     0.150
     4.676    72.637     0.150
     4.652    71.113     0.150
     4.713    73.855     0.150
     4.759    72.332     0.150
     4.832    74.090     0.150
     4.911    73.379     0.150
     5.003    76.547     0.150
     5.117    75.598     0.150
     5.117    90.938     0.150
     6.217    94.238     0.150
     7.466   108.438     0.150
     7.770   114.324     0.150
     7.890   114.988     0.150
     8.161   117.438     0.150
     8.472   122.531     0.150
     8.810   129.066     0.150
     0.381     7.950     0.150
     0.491     9.430     0.150
     0.491     9.398     0.150
     0.491     9.430     0.150
     0.491    16.370     0.150
     0.487    16.070     0.150
     0.487     9.420     0.150
     0.487     9.432     0.150
     0.487    15.324     0.150
     0.487     9.420     0.150
     0.487    16.410     0.150
     0.639    13.040     0.150
     0.639    21.710     0.150
     0.706    13.060     0.150
     0.706    13.056     0.150
     0.706    13.060     0.150
     0.706    22.380     0.150
     0.777    25.570     0.150
     0.777    15.100     0.150
     0.777    25.570     0.150
     0.930    17.690     0.150
     0.930    30.420     0.150
     0.972    18.710     0.150
     0.972    31.280     0.150
     0.972    18.670     0.150
     0.972    31.203     0.150
     0.972    18.710     0.150
     0.972    31.280     0.150
     1.001    30.900     0.150
     1.035    32.730     0.150
     1.035    18.770     0.150
     1.035    32.485     0.150
     1.035    18.770     0.150
     1.035    32.500     0.150
     1.141    21.080     0.150
     1.141    21.072     0.150
     1.141    21.080     0.150
     1.141    36.400     0.150
     1.197    22.410     0.150
     1.197    38.270     0.150
     1.197    22.160     0.150
     1.197    38.210     0.150
     1.197    22.180     0.150
     1.197    38.160     0.150
     1.215    21.690     0.150
     1.215    38.840     0.150
     1.222    19.980     0.150
     1.222    19.480     0.150
     1.256    40.230     0.150
     1.274    23.290     0.150
     1.274    23.237     0.150
     1.274    23.290     0.150
     1.274    40.000     0.150
     1.368    25.950     0.150
     1.368    25.950     0.150
     1.272    24.130     0.150
     1.272    40.700     0.150
     1.608    28.050     0.150
     1.608    50.650     0.150
     1.692    30.070     0.150
     1.692    30.220     0.150
     1.692    54.270     0.150
     1.735    30.830     0.150
     1.735    30.830     0.150
     1.735    54.220     0.150
     1.763    31.140     0.150
     1.763    55.580     0.150
     1.765    30.900     0.150
     1.765    30.900     0.150
     1.765    54.230     0.150
     1.788    31.550     0.150
     1.788    55.640     0.150
     1.801    31.275     0.150
     2.121    66.198     0.150
     2.223    69.202     0.150
     2.230    36.080     0.150
     2.262    38.075     0.150
     2.262    38.080     0.150
     2.262    66.410     0.150
     2.350    38.894     0.150
     2.350    38.890     0.150
     2.350    68.340     0.150
     2.351    39.420     0.150
     2.351    74.210     0.150
     2.351    39.318     0.150
     2.351    73.821     0.150
     2.351    39.420     0.150
     2.351    74.210     0.150
     2.360    74.420     0.150
     2.360    74.543     0.150
     2.360    74.420     0.150
     2.490    78.630     0.150
     2.490    77.064     0.150
     2.490    41.240     0.150
     2.490    78.630     0.150
     2.759    44.850     0.150
     2.759    78.750     0.150
     2.975    55.980     0.150
     2.975    81.660     0.150
     2.975    81.660     0.150
     2.975    92.360     0.150
     3.037    48.950     0.150
     3.037    49.020     0.150
     3.037    95.740     0.150
     3.118    57.820     0.150
     3.121    57.100     0.150
     3.121    50.540     0.150
     3.218    51.460     0.150
     3.218    51.472     0.150
     3.218    51.460     0.150
     3.218    88.770     0.150
     3.218   102.260     0.150
     3.238    89.290     0.150
     3.317    51.930     0.150
     3.317    91.390     0.150
     3.317   104.150     0.150
     3.341    51.910     0.150
     3.341    90.900     0.150
     3.416    54.020     0.150
     3.635    57.330     0.150
     3.635    57.320     0.150
     3.635    98.390     0.150
     3.819    60.057     0.150
     3.819    60.080     0.150
     3.819   103.640     0.150
     3.819   119.350     0.150
     3.853    60.440     0.150
     3.853    60.440     0.150
     3.926    60.890     0.150
     3.926    60.774     0.150
     3.926    60.890     0.150
     3.926   105.840     0.150
     4.383    67.570     0.150
     4.383   116.340     0.150
     4.383   137.240     0.150
     4.670    71.520     0.150
     4.670   123.620     0.150
     4.670    71.520     0.150
     4.670   123.670     0.150
     4.670   146.460     0.150
     4.676    72.090     0.150
     4.875   151.140     0.150
     5.155   159.680     0.150
     5.255    80.460     0.150
     5.287    80.130     0.150
     5.554    83.800     0.150
     5.554   173.800     0.150
     6.110   188.220     0.150
     6.110    90.860     0.150
     6.110   157.820     0.150
     6.110   188.220     0.150
     6.138    91.790     0.150
     6.168    91.760     0.150
     6.168   193.390     0.150
     0.449     9.049     0.150
     0.449    15.541     0.150
     0.449     9.057     0.150
     0.449    15.598     0.150
     0.485     9.396     0.150
     0.485    14.877     0.150
     0.516    10.158     0.150
     0.516    10.178     0.150
     0.516    17.066     0.150
     0.677    13.658     0.150
     0.717    14.107     0.150
     0.777    13.328     0.150
     0.802    14.678     0.150
     0.802    25.717     0.150
     0.781    15.537     0.150
     0.781    15.518     0.150
     0.781    25.477     0.150
     0.780    14.752     0.150
     0.780    14.787     0.150
     0.851    16.527     0.150
     0.851    16.557     0.150
     1.011    18.557     0.150
     1.011    31.988     0.150
     1.117    21.998     0.150
     1.114    19.438     0.150
     1.114    19.438     0.150
     1.090    21.227     0.150
     1.090    35.418     0.150
     1.091    20.816     0.150
     1.091    20.838     0.150
     1.091    35.117     0.150
     1.246    21.348     0.150
     1.230    22.117     0.150
     1.376    23.457     0.150
     1.342    24.811     0.150
     1.342    24.848     0.150
     1.342    42.768     0.150
     1.406    26.203     0.150
     1.447    25.707     0.150
     1.452    25.367     0.150
     1.484    27.738     0.150
     1.602    28.377     0.150
     1.587    30.172     0.150
     1.587    30.057     0.150
     1.587    50.957     0.150
     1.751    31.992     0.150
     1.751    55.629     0.150
     1.786    30.268     0.150
     1.894    34.137     0.150
     2.079    37.723     0.150
     2.079    37.658     0.150
     2.128    37.797     0.150
     2.219    40.107     0.150
     2.330    40.146     0.150
     2.330    72.941     0.150
     2.330    40.078     0.150
     2.330    73.217     0.150
     2.840    47.828     0.150
     3.056    49.791     0.150
     3.268    53.854     0.150
     3.548    58.242     0.150
     3.548    58.338     0.150
     3.639    59.178     0.150
     3.786    61.947     0.150
     3.786    61.238     0.150
     4.413    70.268     0.150
     4.459    70.287     0.150
     4.459    70.508     0.150
     5.271    82.377     0.150
     5.826    88.947     0.150
     7.351   110.768     0.150
     0.499     9.711     0.150
     0.567    10.701     0.150
     0.930    28.312     0.150
     0.932    18.331     0.150
     1.066    20.062     0.150
     1.066    34.201     0.150
     1.097    19.812     0.150
     1.192    22.382     0.150
     1.306    24.211     0.150
     2.282    72.423     0.150
     2.282    72.382     0.150
     2.287    39.111     0.150
     2.362    39.901     0.150
     2.412    76.762     0.150
     3.320    52.751     0.150
     0.577    10.891     0.150
     0.603    11.500     0.150
     1.076    20.668     0.150
     1.178    21.430     0.150
     1.178    37.199     0.150
     1.366    26.391     0.150
     1.279    24.270     0.150
     1.732    54.270     0.150
     1.906    61.848     0.150
     2.272    40.738     0.150
     2.366    75.324     0.150
     2.382    76.754     0.150
     2.382    76.320     0.150
     3.024    50.258     0.150
     0.446     8.383     0.150
     0.446    12.945     0.150
     0.446     9.352     0.150
     0.446    15.688     0.150
     0.961    17.688     0.150
     0.961    29.906     0.150
     0.974    19.453     0.150
     1.073    33.586     0.150
     1.173    22.531     0.150
     1.173    38.453     0.150
     1.190    39.148     0.150
     1.388    45.797     0.150
     1.758    33.492     0.150
     2.302    39.742     0.150
     2.380    76.227     0.150
     0.249     8.727     0.150
     0.265     9.578     0.150
     0.265     5.734     0.150
     0.265     9.633     0.150
     0.495     9.773     0.150
     0.495    15.461     0.150
     0.495     9.742     0.150
     0.589    11.328     0.150
     0.766    14.109     0.150
     0.766    14.133     0.150
     0.808    15.453     0.150
     0.849    16.414     0.150
     1.116    21.016     0.150
     1.116    21.031     0.150
     1.116    36.023     0.150
     1.123    20.727     0.150
     1.237    22.945     0.150
     1.237    22.875     0.150
     1.305    23.086     0.150
     1.431    25.844     0.150
     1.431    25.758     0.150
     1.431    45.156     0.150
     1.567    49.523     0.150
     1.567    29.328     0.150
     1.567    49.547     0.150
     1.539    26.688     0.150
     1.539    47.727     0.150
     1.864    32.977     0.150
     1.864    58.156     0.150
     2.084    35.703     0.150
     2.260    70.242     0.150
     2.328    39.828     0.150
     2.418    40.953     0.150
     2.906    47.117     0.150
     3.173    49.734     0.150
     3.662    56.492     0.150
     4.683   145.703     0.150
     4.920    72.453     0.150
     5.730    83.328     0.150
     5.805    81.531     0.150
     0.497     9.984     0.150
     0.601    11.633     0.150
     0.788    11.984     0.150
     0.788    22.234     0.150
     1.002    31.219     0.150
     1.272    25.031     0.150
     1.239    22.570     0.150
     1.234    23.984     0.150
     1.234    40.344     0.150
     1.408    24.242     0.150
     1.423    25.422     0.150
     1.498    28.375     0.150
     1.579    30.820     0.150
     2.224    42.820     0.150
     2.908    50.281     0.150
     0.371     7.879     0.150
     0.371    13.301     0.150
     0.539    10.277     0.150
     0.539    10.289     0.150
     0.539    17.539     0.150
     0.533    10.160     0.150
     0.533    10.219     0.150
     0.594    12.301     0.150
     0.652    12.410     0.150
     0.652    12.328     0.150
     0.652    12.410     0.150
     0.756    13.281     0.150
     0.780    15.262     0.150
     0.780    15.262     0.150
     0.780    25.730     0.150
     0.797    15.730     0.150
     0.847    15.691     0.150
     0.847    28.379     0.150
     0.899    17.621     0.150
     0.899    29.781     0.150
     0.899    17.602     0.150
     0.899    29.688     0.150
     0.899    17.621     0.150
     0.899    29.781     0.150
     0.983    18.648     0.150
     0.983    18.648     0.150
     0.983    18.648     0.150
     0.983    31.859     0.150
     1.062    18.738     0.150
     1.127    19.531     0.150
     1.253    24.148     0.150
     1.253    24.129     0.150
     1.253    40.609     0.150
     1.156    21.980     0.150
     1.156    22.000     0.150
     1.175    20.723     0.150
     1.175    20.660     0.150
     1.206    23.250     0.150
     1.206    39.129     0.150
     1.353    24.480     0.150
     1.353    24.508     0.150
     1.353    24.480     0.150
     1.474    25.520     0.150
     1.517    25.918     0.150
     1.526    27.980     0.150
     1.595    29.078     0.150
     1.643    28.328     0.150
     1.703    32.078     0.150
     1.703    32.211     0.150
     1.817    31.988     0.150
     1.817    32.000     0.150
     1.825    58.629     0.150
     2.219    41.910     0.150
     2.229    38.375     0.150
     2.323    73.586     0.150
     2.336    39.070     0.150
     2.385    39.762     0.150
     2.650    43.520     0.150
     2.954    47.629     0.150
     2.937    47.590     0.150
     3.069    48.488     0.150
     3.172    51.879     0.150
     3.289    52.598     0.150
     3.333    93.301     0.150
     3.333    53.012     0.150
     3.601    55.441     0.150
     3.688    59.141     0.150
     3.775    60.102     0.150
     3.775    60.078     0.150
     3.855    60.281     0.150
     3.891    59.766     0.150
     3.875    68.371     0.150
     3.906    61.289     0.150
     4.214    65.121     0.150
     4.472    68.039     0.150
     4.542    70.410     0.150
     4.552    70.891     0.150
     5.072    76.910     0.150
     5.527    84.293     0.150
     5.964    89.613     0.150
     6.007    90.219     0.150
     6.871   101.621     0.150
     0.310     6.330     0.150
     0.516    10.228     0.150
     1.518    48.565     0.150
     1.815    31.810     0.150
     1.881    59.370     0.150
     2.338    39.152     0.150
     2.440    76.644     0.150
     2.595    79.692     0.150
     2.680    83.600     0.150
     2.999    85.176     0.150
     3.311   101.749     0.150
     3.322    52.394     0.150
     4.307    65.886     0.150
     4.525    68.662     0.150
     1.002    31.422     0.150
     2.388    75.484     0.150
     2.533    83.094     0.150
     2.533    83.094     0.150
     2.733    85.066     0.150
     0.311     6.527     0.150
     0.512    17.656     0.150
     0.894    27.390     0.150
     0.894    16.274     0.150
     0.896    17.024     0.150
     0.896    28.742     0.150
     1.089    20.928     0.150
     1.089    35.551     0.150
     1.256    40.475     0.150
     1.310    24.074     0.150
     1.310    42.122     0.150
     1.326    42.035     0.150
     1.407    27.399     0.150
     1.517    28.909     0.150
     1.811    56.135     0.150
     2.334    39.409     0.150
     3.977    63.014     0.150
     4.103    64.697     0.150
     4.720    72.807     0.150
     4.827    74.844     0.150
     1.872    35.128     0.150
     0.315     6.486     0.150
     0.460     9.377     0.150
     0.460    16.096     0.150
     0.511    17.596     0.150
     0.511    17.641     0.150
     0.496     8.756     0.150
     0.723    14.467     0.150
     0.824    16.016     0.150
     0.891    16.787     0.150
     0.891    29.045     0.150
     0.897    16.246     0.150
     1.039    19.457     0.150
     1.086    20.916     0.150
     1.086    35.605     0.150
     1.086    20.957     0.150
     1.086    35.627     0.150
     1.217    39.086     0.150
     1.217    22.406     0.150
     1.254    40.365     0.150
     1.254    23.346     0.150
     1.321    24.627     0.150
     1.321    24.686     0.150
     1.308    24.066     0.150
     1.308    24.062     0.150
     1.308    42.178     0.150
     1.374    26.006     0.150
     1.513    49.326     0.150
     1.513    49.666     0.150
     1.611    28.486     0.150
     1.757    30.086     0.150
     1.811    31.836     0.150
     1.859    32.844     0.150
     1.877    33.025     0.150
     1.877    32.990     0.150
     1.877    59.840     0.150
     1.949    34.066     0.150
     2.203    36.025     0.150
     2.321    74.516     0.150
     2.335    39.377     0.150
     2.335    39.387     0.150
     2.442    75.449     0.150
     2.598    42.477     0.150
     2.598    79.809     0.150
     2.676    44.086     0.150
     2.676    83.801     0.150
     2.774    44.635     0.150
     2.886    45.920     0.150
     2.996    84.941     0.150
     3.031    93.322     0.150
     3.194    51.533     0.150
     3.288    53.172     0.150
     3.290    51.270     0.150
     3.318    52.617     0.150
     3.555    55.674     0.150
     3.600    99.406     0.150
     3.973    62.639     0.150
     4.036    61.727     0.150
     4.036   108.584     0.150
     4.099    63.945     0.150
     4.257    65.326     0.150
     4.257    65.354     0.150
     4.257   114.570     0.150
     4.300    65.375     0.150
     4.520    68.146     0.150
     4.719    72.609     0.150
     4.744   145.201     0.150
     4.806    73.229     0.150
     4.823    74.506     0.150
     4.823    74.588     0.150
     4.885    74.596     0.150
     4.885    74.641     0.150
     5.494    82.777     0.150
     5.621    84.766     0.150
     5.621    84.643     0.150
     6.278    94.736     0.150
     7.330   108.217     0.150
     7.330   108.262     0.150
     0.305     5.717     0.150
     0.607    11.477     0.150
     0.607    19.514     0.150
     0.960    30.898     0.150
     0.973    31.625     0.150
     0.992    19.256     0.150
     1.231    23.125     0.150
     1.527    48.975     0.150
     1.570    29.676     0.150
     1.892    32.404     0.150
     1.921    63.262     0.150
     2.002    34.025     0.150
     2.187    72.053     0.150
     2.298    74.721     0.150
     2.460    75.998     0.150
     2.933    50.209     0.150
     3.225    50.984     0.150
     3.718    57.654     0.150
     4.587    69.945     0.150
     4.587    73.580     0.150
     4.710    71.045     0.150
     5.188    81.865     0.150
     7.464   112.695     0.150
     7.668   111.705     0.150
     0.479     9.792     0.150
     0.990    17.934     0.150
     0.990    30.864     0.150
     0.994    19.505     0.150
     1.188    22.275     0.150
     1.188    38.628     0.150
     1.249    23.201     0.150
     1.401    26.901     0.150
     1.694    30.151     0.150
     1.782    32.459     0.150
     1.794    56.337     0.150
     1.916    34.966     0.150
     2.336    39.704     0.150
     2.390    44.884     0.150
     2.390    76.444     0.150
     2.390    75.895     0.150
     2.930    51.444     0.150
     0.327     8.725     0.150
     0.327     5.959     0.150
     0.327     8.867     0.150
     0.353     7.705     0.150
     0.614    11.463     0.150
     0.605    11.316     0.150
     1.002    17.635     0.150
     1.002    32.031     0.150
     1.197    21.475     0.150
     1.314    25.396     0.150
     1.865    34.664     0.150
     1.852    34.209     0.150
     1.903    36.439     0.150
     1.914    33.414     0.150
     1.913    35.756     0.150
     1.930    36.459     0.150
     2.198    73.908     0.150
     2.223    71.879     0.150
     2.408    74.777     0.150
     2.443    75.717     0.150
     2.999    85.834     0.150
     0.342     6.756     0.150
     0.422    14.908     0.150
     0.422     8.708     0.150
     0.736    14.568     0.150
     0.776    24.800     0.150
     0.852    16.258     0.150
     0.852    27.448     0.150
     0.961    17.403     0.150
     1.038    20.058     0.150
     1.038    34.498     0.150
     1.116    20.748     0.150
     1.165    21.848     0.150
     1.351    44.598     0.150
     1.351    24.808     0.150
     1.351    24.868     0.150
     1.351    44.630     0.150
     1.489    28.418     0.150
     1.517    27.938     0.150
     1.869    33.338     0.150
     1.880    32.268     0.150
     1.921    34.168     0.150
     2.053    36.397     0.150
     2.213    40.598     0.150
     2.229    70.791     0.150
     2.387    40.637     0.150
     2.495    46.208     0.150
     2.495    42.619     0.150
     2.896    46.990     0.150
     3.201    49.978     0.150
     3.201    52.276     0.150
     3.940   123.530     0.150
     4.106    64.758     0.150
     4.169    64.848     0.150
     4.169   128.810     0.150
     4.279    68.378     0.150
     4.300    66.645     0.150
     4.300   133.231     0.150
     4.864    75.397     0.150
     4.911   161.562     0.150
     5.414    81.338     0.150
     5.505    83.858     0.150
     5.937    89.168     0.150
     0.534    10.652     0.150
     0.586    11.703     0.150
     0.586    19.973     0.150
     0.600    11.131     0.150
     0.745    24.623     0.150
     1.154    22.061     0.150
     1.347    25.357     0.150
     1.739    32.037     0.150
     1.837    32.945     0.150
     2.270    74.084     0.150
     2.258    39.652     0.150
     3.001    47.014     0.150
     3.058    84.801     0.150
     3.205    50.652     0.150
     0.352     7.023     0.150
     0.903    16.449     0.150
     1.183    38.945     0.150
     1.203    40.297     0.150
     1.307    24.152     0.150
     1.469    48.035     0.150
     1.469    48.129     0.150
     1.734    52.906     0.150
     1.734    32.746     0.150
     1.734    55.844     0.150
     1.795    33.844     0.150
     1.795    57.203     0.150
     1.872    34.266     0.150
     1.988    35.766     0.150
     2.060    64.051     0.150
     2.257    36.977     0.150
     2.257    40.395     0.150
     2.257    70.207     0.150
     2.250    37.277     0.150
     2.250    65.617     0.150
     2.250    70.637     0.150
     2.817    77.266     0.150
     3.932    61.316     0.150
     4.778    72.527     0.150
     5.396    81.105     0.150
     0.738    14.195     0.150
     1.135    34.836     0.150
     1.098    21.250     0.150
     1.196    21.508     0.150
     1.196    37.500     0.150
     1.324    24.656     0.150
     1.324    41.680     0.150
     1.448    27.453     0.150
     1.448    47.336     0.150
     1.865    58.703     0.150
     1.961    61.109     0.150
     2.789    89.477     0.150
     3.680    61.016     0.150
     0.239     8.547     0.150
     0.418    15.297     0.150
     0.418     8.875     0.150
     0.418    14.898     0.150
     0.550    10.766     0.150
     0.733    24.676     0.150
     0.915    16.836     0.150
     1.018    19.855     0.150
     1.018    34.094     0.150
     1.018    19.816     0.150
     1.116    21.004     0.150
     1.116    20.973     0.150
     1.163    22.074     0.150
     1.163    22.039     0.150
     1.310    24.074     0.150
     1.461    27.926     0.150
     1.400    45.055     0.150
     1.400    25.930     0.150
     1.435    25.426     0.150
     1.472    27.887     0.150
     1.528    27.316     0.150
     1.528    27.355     0.150
     1.778    32.375     0.150
     1.778    32.359     0.150
     1.879    34.078     0.150
     2.024    35.465     0.150
     2.229    39.004     0.150
     2.232    38.656     0.150
     2.340    40.664     0.150
     2.340    40.590     0.150
     2.465    42.277     0.150
     2.694    78.301     0.150
     2.791    45.375     0.150
     2.791    87.648     0.150
     3.028    49.250     0.150
     3.149    52.176     0.150
     3.149    58.953     0.150
     3.197    52.504     0.150
     3.189    50.777     0.150
     3.216    52.164     0.150
     3.625    57.699     0.150
     3.676    57.824     0.150
     3.925    63.246     0.150
     3.925   109.137     0.150
     3.999    63.504     0.150
     4.132    63.973     0.150
     4.204   130.586     0.150
     4.204   130.336     0.150
     5.098    77.707     0.150
     5.388    83.465     0.150
     6.334    95.605     0.150
    10.441   149.375     0.150
    12.058   168.875     0.150
    68.309   662.867     0.150
     0.524    18.911     0.150
     0.894    17.401     0.150
     1.002    31.651     0.150
     1.002    18.801     0.150
     1.041    19.231     0.150
     0.999    19.671     0.150
     1.014    19.801     0.150
     1.014    33.791     0.150
     1.184    36.741     0.150
     1.291    24.381     0.150
     1.392    25.141     0.150
     1.533    47.511     0.150
     3.073    98.121     0.150
     3.447    55.891     0.150
     3.748    61.812     0.150
     3.748    61.721     0.150
     3.811    61.801     0.150
     3.825   119.081     0.150
     5.218    82.731     0.150
     5.218    79.891     0.150
     0.516    16.039     0.150
     0.644    11.945     0.150
     0.937    28.023     0.150
     0.959    31.102     0.150
     1.196    38.047     0.150
     1.206    23.297     0.150
     1.206    39.758     0.150
     1.318    23.695     0.150
     1.758    31.273     0.150
     1.848    32.797     0.150
     1.848    59.492     0.150
     2.302    39.031     0.150
     2.302    73.125     0.150
     2.314    72.867     0.150
     2.277    40.594     0.150
     2.277    40.664     0.150
     2.277    71.617     0.150
     2.428    76.078     0.150
     2.436    38.594     0.150
     2.736    45.133     0.150
     2.919    48.234     0.150
     3.061    48.844     0.150
     3.078    47.477     0.150
     3.357    94.414     0.150
     4.550    65.406     0.150
     4.642    68.828     0.150
     4.643    72.469     0.150
     5.689    85.109     0.150
     6.869    97.758     0.150
     0.501     9.812     0.150
     0.501    16.695     0.150
     0.634    12.023     0.150
     0.634    20.461     0.150
     0.712    22.945     0.150
     0.939    18.492     0.150
     1.073    20.367     0.150
     1.188    38.523     0.150
     1.307    24.219     0.150
     1.621    29.945     0.150
     1.789    57.422     0.150
     1.860    59.750     0.150
     2.066    34.320     0.150
     2.248    37.609     0.150
     2.419    76.656     0.150
     3.245    53.789     0.150
     0.318     6.648     0.150
     0.467     9.758     0.150
     0.467    16.695     0.150
     0.782    15.164     0.150
     0.787    15.383     0.150
     0.946    32.023     0.150
     1.064    34.984     0.150
     1.064    20.711     0.150
     1.064    35.039     0.150
     1.154    20.922     0.150
     1.220    21.734     0.150
     1.338    24.641     0.150
     1.338    24.711     0.150
     1.503    48.195     0.150
     1.461    25.242     0.150
     1.548    45.125     0.150
     1.548    26.922     0.150
     1.867    31.672     0.150
     1.901    60.344     0.150
     1.978    33.125     0.150
     2.278    37.258     0.150
     2.276    36.852     0.150
     3.037    45.852     0.150
     3.189    85.664     0.150
     3.966    60.969     0.150
     3.966    60.992     0.150
     4.235    65.445     0.150
     5.429    81.422     0.150
     5.502    80.141     0.150
     0.718    21.901     0.150
     1.048    32.302     0.150
     3.090    50.702     0.150
     3.334    54.542     0.150
     1.607    50.203     0.150
     2.345    74.723     0.150
     1.342    44.906     0.150
     1.584    29.296     0.150
     5.373    81.296     0.150
     0.766    22.742     0.150
     0.954    16.727     0.150
     0.938    32.828     0.150
     0.993    16.953     0.150
     1.252    20.695     0.150
    71.392    40.258     0.150
     3.102    53.656     0.150
     3.150    54.086     0.150
     3.188    55.422     0.150
     0.703    14.477     0.150
     0.880    17.896     0.150
     0.880    31.307     0.150
     1.106    20.996     0.150
     2.303    36.865     0.150
     2.518    39.836     0.150
    71.677    39.637     0.150
     0.402    12.234     0.150
     0.431     8.516     0.150
     0.431    16.164     0.150
     0.667    13.465     0.150
     0.667    25.105     0.150
     0.968    18.613     0.150
     1.253    23.457     0.150
     1.308    24.457     0.150
     1.372    46.625     0.150
     1.523    47.625     0.150
     1.712    41.926     0.150
     2.178    69.504     0.150
    71.692    43.855     0.150
     3.284    51.766     0.150
     3.649    58.504     0.150
     5.113    78.137     0.150
     5.260    80.125     0.150
     7.180   181.277     0.150
     8.633   218.785     0.150
     8.633   265.012     0.150
     8.633   125.844     0.150
    12.153   173.055     0.150
    55.238  4127.082     0.150
    55.243  4127.863     0.150
    55.256  4141.797     0.150
    56.390  4210.957     0.150
    56.408  4211.246     0.150
     0.440     8.492     0.150
     0.440    16.129     0.150
     0.678    13.719     0.150
     0.977    32.559     0.150
     1.263    23.500     0.150
     1.263    40.531     0.150
     1.531    48.121     0.150
     1.556    27.129     0.150
     1.665    30.762     0.150
     1.665    28.500     0.150
     1.681    29.969     0.150
     1.716    41.602     0.150
     1.748    31.879     0.150
     2.416    40.969     0.150
    71.680    44.230     0.150
     3.973    63.020     0.150
     5.105    91.105     0.150
     5.105    91.582     0.150
     5.819   106.098     0.150
     5.819   160.930     0.150
     7.193   183.473     0.150
     0.524    15.285     0.150
     0.680    12.725     0.150
     0.784    14.465     0.150
     0.852    16.555     0.150
     0.948    18.895     0.150
     0.973    19.324     0.150
     0.973    31.273     0.150
     1.053    18.494     0.150
     1.053    31.934     0.150
     1.080    34.844     0.150
     1.080    32.014     0.150
     1.123    22.104     0.150
     1.257    24.555     0.150
     1.280    25.314     0.150
     1.402    24.414     0.150
     1.402    43.404     0.150
     1.500    28.404     0.150
     1.500    47.604     0.150
     1.574    27.885     0.150
   110.240    36.523     0.150
    71.515    42.324     0.150
     3.769    61.885     0.150
     4.551    72.264     0.150
     0.262     9.574     0.150
     0.461    18.664     0.150
     0.800    15.355     0.150
     0.826    15.574     0.150
     1.118    36.035     0.150
     1.118    20.844     0.150
     1.119    20.383     0.150
     1.256    22.633     0.150
     1.395    25.125     0.150
     1.395    44.254     0.150
     1.397    25.285     0.150
     1.397    44.484     0.150
     1.381    43.473     0.150
     1.561    48.824     0.150
     1.533    26.453     0.150
     2.038    63.363     0.150
     2.298    37.273     0.150
   109.782    38.633     0.150
    71.847    45.086     0.150
     2.100    38.777     0.150
     0.709    13.795     0.150
     0.862    17.065     0.150
     0.948    19.085     0.150
     1.027    19.005     0.150
     1.106    22.085     0.150
     1.152    36.535     0.150
     1.254    24.635     0.150
     1.266    25.175     0.150
     1.266    42.226     0.150
     1.472    28.215     0.150
     1.546    49.965     0.150
   110.269    36.735     0.150
   110.269    64.686     0.150
    71.494    73.186     0.150
    71.494    41.706     0.150
     2.472    45.265     0.150
     3.095    49.396     0.150
     3.238    53.135     0.150
     3.660    68.215     0.150
     3.766    60.465     0.150
     4.496    71.655     0.150
    81.943    87.875     0.150
     2.009    61.246     0.150
     0.292     5.973     0.150
     0.889    28.832     0.150
     1.149    20.582     0.150
     1.139    21.305     0.150
     1.139    36.375     0.150
     1.340    24.516     0.150
     1.367    23.645     0.150
     1.367    25.543     0.150
     1.438    26.605     0.150
     1.431    45.562     0.150
     1.556    49.426     0.150
     1.720    29.523     0.150
     1.664    29.344     0.150
     1.664    50.926     0.150
     1.886    32.445     0.150
     2.403    39.613     0.150
     2.403    43.395     0.150
     2.403    74.914     0.150
    71.837    44.215     0.150
     4.126    62.664     0.150
     4.264    63.473     0.150
     4.293    63.965     0.150
     5.100    89.664     0.150
     0.496     9.723     0.150
     0.496    15.902     0.150
     0.998    32.723     0.150
     0.998    18.984     0.150
     1.114    19.723     0.150
     1.160    21.785     0.150
     1.208    22.484     0.150
     1.364    43.734     0.150
     1.516    47.855     0.150
    71.755    39.395     0.150
    71.755    69.883     0.150
     2.574    40.664     0.150
     4.005    59.812     0.150
     4.885    72.535     0.150
     5.203    75.895     0.150
     5.521    81.902     0.150
     5.595    81.625     0.150
    81.946    84.695     0.150
     0.899    19.391     0.150
     1.149    23.484     0.150
     1.295    26.406     0.150
     1.253    27.094     0.150
     1.551    28.844     0.150
    71.617    43.820     0.150
     2.433    42.820     0.150
     5.260   138.258     0.150
     5.260   153.781     0.150
     5.260   230.211     0.150
     5.667   145.836     0.150
     5.667   252.031     0.150
     7.084   157.352     0.150
    12.230   242.133     0.150
    25.285   378.234     0.150
     0.470     8.887     0.150
     0.659    20.668     0.150
     0.954    18.785     0.150
     0.954    32.195     0.150
     1.243    40.168     0.150
     1.635    51.648     0.150
     1.635    51.727     0.150
     1.715    55.457     0.150
     2.149    35.887     0.150
     2.161    36.617     0.150
     2.384    76.559     0.150
    71.656    44.156     0.150
     3.982    63.668     0.150
     4.142    65.336     0.150
     0.977    19.016     0.150
     1.061    19.922     0.150
     1.061    33.984     0.150
     1.234    22.812     0.150
     1.302    42.172     0.150
     1.345    24.953     0.150
     1.407    45.477     0.150
     1.748    30.547     0.150
     2.257    37.906     0.150
    71.692    45.156     0.150
     6.060    89.883     0.150
     0.974    19.078     0.150
     1.234    22.820     0.150
     1.300    42.516     0.150
     1.405    45.625     0.150
     2.252    37.898     0.150
    71.690    44.641     0.150
     3.039    50.539     0.150
     4.002    61.031     0.150
     4.499    67.961     0.150
     4.797   149.227     0.150
     1.534    29.477     0.150
     1.838    30.805     0.150
     2.829    50.430     0.150
     4.509    69.375     0.150
    15.354   217.039     0.150
    15.435   220.828     0.150
    15.444   219.484     0.150
    15.571   220.836     0.150
    15.990   225.820     0.150
    16.200   228.359     0.150
    16.557   234.156     0.150
    16.743   236.820     0.150
    17.403   245.375     0.150
    18.571   259.250     0.150
    18.758   261.305     0.150
    19.318   268.438     0.150
    20.718   281.500     0.150
    21.009   285.875     0.150
    21.024   286.438     0.150
    21.253   289.836     0.150
    21.429   290.734     0.150
    22.697   304.594     0.150
    23.217   310.406     0.150
    23.547   313.305     0.150
    23.544   312.609     0.150
    24.430   321.305     0.150
    25.055   327.836     0.150
    26.077   336.391     0.150
    26.686   342.500     0.150
    28.938   361.867     0.150
    30.738   377.969     0.150
    29.756   399.391     0.150
    33.189   399.844     0.150
    33.413   402.617     0.150
    33.569   403.984     0.150
    33.856   404.977     0.150
    35.024   415.430     0.150
    36.663   430.359     0.150
    36.945   432.086     0.150
    37.452   435.148     0.150
    39.719   454.688     0.150
    39.870   456.391     0.150
    40.343   460.227     0.150
    40.632   462.195     0.150
    41.065   466.141     0.150
    41.089   467.023     0.150
    41.052   466.758     0.150
    41.312   468.680     0.150
    41.884   473.594     0.150
    42.020   473.461     0.150
    42.024   474.477     0.150
    42.188   476.594     0.150
    43.158   482.984     0.150
    43.293   485.219     0.150
    43.750   488.367     0.150
    44.556   494.711     0.150
    45.210   499.820     0.150
    46.862   515.125     0.150
    48.713   530.445     0.150
    49.768   534.758     0.150
    50.289   545.305     0.150
    51.921   550.734     0.150
    53.816   565.148     0.150
    55.055   574.484     0.150
    55.380   577.594     0.150
    57.339   591.938     0.150
    57.883   595.805     0.150
    59.419   605.148     0.150
    59.516   605.523     0.150
    60.047   610.273     0.150
    62.691   627.008     0.150
    62.926   628.820     0.150
    63.193   630.859     0.150
    64.055   642.039     0.150
    64.403   638.516     0.150
    65.049   642.250     0.150
    65.874   648.328     0.150
    67.725   664.250     0.150
    67.948   660.625     0.150
    68.515   670.484     0.150
    68.875   666.828     0.150
    77.072   668.555     0.150
    69.564   671.680     0.150
    69.564   671.445     0.150
    70.493   678.289     0.150
    70.986   681.305     0.150
    70.986   681.070     0.150
    71.690   686.297     0.150
    71.929   686.430     0.150
    73.609   696.258     0.150
    73.827   698.750     0.150
    75.880   710.164     0.150
    75.979   710.594     0.150
    77.394   717.578     0.150
    78.151   727.125     0.150
    78.462   726.695     0.150
    79.737   731.117     0.150
    79.875   732.266     0.150
    84.303   755.539     0.150
    85.060   761.344     0.150
    87.476   769.016     0.150
    90.041   784.297     0.150
    92.641   795.648     0.150
     2.288    72.836     0.150
     3.669    61.500     0.150
     3.669    60.664     0.150
     4.845    76.867     0.150
     5.317    82.266     0.150
     5.483    83.266     0.150
     5.553    87.367     0.150
     5.552    86.070     0.150
     5.999    91.867     0.150
     5.999    90.188     0.150
     6.598    99.086     0.150
     6.544   101.766     0.150
     6.691   102.891     0.150
     6.945   105.969     0.150
     6.941   106.664     0.150
     7.243   109.070     0.150
     7.243   108.664     0.150
     7.243   108.938     0.150
     7.243   108.844     0.150
     7.874   117.664     0.150
     8.236   123.266     0.150
     8.367   130.367     0.150
     8.310   125.070     0.150
     8.334   124.195     0.150
     8.334   123.773     0.150
     8.642   128.273     0.150
     9.320   140.125     0.150
    10.114   150.250     0.150
    10.129   150.969     0.150
    10.371   151.961     0.150
    12.050   172.203     0.150
    12.620   182.219     0.150
    12.926   188.258     0.150
    13.831   198.836     0.150
    13.944   201.758     0.150
    13.997   201.477     0.150
    15.354   219.383     0.150
    15.866   227.531     0.150
    15.898   227.492     0.150
    15.898   228.008     0.150
    15.931   225.727     0.150
    15.990   225.984     0.150
    16.002   230.070     0.150
    16.186   229.742     0.150
    17.644   247.281     0.150
    17.714   251.117     0.150
    18.490   259.898     0.150
    18.571   259.906     0.150
    18.571   261.617     0.150
    20.426   280.969     0.150
    20.718   283.438     0.150
    21.128   288.367     0.150
    21.128   287.000     0.150
    21.429   291.500     0.150
    22.138   299.602     0.150
    22.138   298.445     0.150
    22.637   304.656     0.150
    23.487   315.898     0.150
    23.544   314.094     0.150
    34.136   316.219     0.150
    23.940   317.938     0.150
    23.940   317.469     0.150
    23.940   317.969     0.150
    24.635   323.883     0.150
    24.648   324.008     0.150
    24.732   325.539     0.150
    25.055   328.180     0.150
    25.298   329.508     0.150
    25.948   338.211     0.150
    26.128   337.664     0.150
    26.205   337.523     0.150
    26.321   339.672     0.150
    26.320   339.969     0.150
    26.320   339.641     0.150
    26.686   343.516     0.150
    26.686   343.117     0.150
    27.754   352.508     0.150
    28.308   357.477     0.150
    28.281   357.297     0.150
    29.756   362.414     0.150
    28.938   362.469     0.150
    28.938   362.891     0.150
    29.282   365.477     0.150
    29.428   366.211     0.150
    30.004   372.039     0.150
    30.093   374.227     0.150
    30.406   375.367     0.150
    30.489   376.445     0.150
    30.489   376.234     0.150
    30.738   379.266     0.150
    30.738   378.938     0.150
    30.740   379.266     0.150
    30.771   379.594     0.150
    30.775   379.539     0.150
    31.071   380.766     0.150
    31.191   383.023     0.150
    31.825   389.836     0.150
    33.189   401.266     0.150
    33.189   400.156     0.150
    33.189   400.914     0.150
    33.413   401.953     0.150
    33.413   402.758     0.150
    33.456   403.344     0.150
    33.569   403.969     0.150
    33.569   401.961     0.150
    33.569   402.961     0.150
    33.856   407.164     0.150
    33.856   406.961     0.150
    33.881   407.266     0.150
    34.073   407.516     0.150
    34.364   411.938     0.150
    34.796   414.625     0.150
    34.997   416.047     0.150
    35.024   415.867     0.150
    35.024   416.438     0.150
    35.024   415.906     0.150
    35.249   418.211     0.150
    36.270   424.766     0.150
    36.461   429.008     0.150
    36.449   427.516     0.150
    36.648   430.070     0.150
    36.663   433.664     0.150
    36.663   433.664     0.150
    36.663   433.664     0.150
    36.663   433.664     0.150
    36.663   433.664     0.150
    36.663   433.664     0.150
    36.663   431.766     0.150
    36.663   431.125     0.150
    36.663   431.570     0.150
    36.945   433.148     0.150
    37.452   436.062     0.150
    37.452   435.750     0.150
    37.465   437.055     0.150
    37.465   437.117     0.150
    37.915   441.430     0.150
    37.912   442.164     0.150
    38.165   442.000     0.150
    38.165   442.109     0.150
    38.348   445.266     0.150
    39.185   449.445     0.150
    39.719   455.688     0.150
    39.719   455.156     0.150
    39.834   456.344     0.150
    39.804   456.867     0.150
    39.868   457.164     0.150
    39.870   459.367     0.150
    39.870   458.188     0.150
    39.870   458.586     0.150
    40.343   461.266     0.150
    40.343   461.438     0.150
    40.343   460.516     0.150
    40.600   464.188     0.150
    40.600   464.438     0.150
    40.632   463.062     0.150
    40.632   462.734     0.150
    40.707   464.094     0.150
    40.773   464.250     0.150
    40.946   466.797     0.150
    41.008   466.414     0.150
    41.065   467.984     0.150
    41.065   467.336     0.150
    41.089   469.359     0.150
    41.052   469.391     0.150
    41.052   469.008     0.150
    41.262   469.508     0.150
    41.797   473.086     0.150
    41.793   473.469     0.150
    42.020   474.289     0.150
    42.020   474.680     0.150
    42.020   474.070     0.150
    41.945   474.211     0.150
    42.024   477.031     0.150
    42.024   477.469     0.150
    42.188   474.992     0.150
    42.188   477.938     0.150
    42.079   477.008     0.150
    42.222   476.484     0.150
    42.288   477.586     0.150
    42.321   477.906     0.150
    42.390   478.078     0.150
    43.407   486.227     0.150
    43.538   487.164     0.150
    43.750   491.211     0.150
    43.750   490.445     0.150
    44.143   492.398     0.150
    44.940   498.508     0.150
    45.210   500.695     0.150
    45.210   500.828     0.150
    45.210   500.664     0.150
    45.547   504.516     0.150
    45.474   503.094     0.150
    45.474   503.164     0.150
    46.030   507.906     0.150
    46.797   513.734     0.150
    46.862   517.164     0.150
    46.862   516.266     0.150
    46.862   515.711     0.150
    47.036   514.766     0.150
    47.388   517.867     0.150
    47.387   517.672     0.150
    48.503   526.164     0.150
    48.713   528.266     0.150
    48.713   528.773     0.150
    48.713   528.648     0.150
    48.868   531.945     0.150
    49.359   533.766     0.150
    49.768   535.266     0.150
    49.768   535.070     0.150
    49.768   535.156     0.150
    50.064   537.430     0.150
    50.289   540.227     0.150
    50.289   540.828     0.150
    50.660   542.828     0.150
    50.900   543.367     0.150
    51.895   551.055     0.150
    51.921   553.969     0.150
    51.921   552.883     0.150
    51.921   551.836     0.150
    52.835   557.523     0.150
    52.992   560.297     0.150
    53.476   563.578     0.150
    53.627   563.969     0.150
    53.700   564.320     0.150
    53.816   566.141     0.150
    53.816   565.586     0.150
    53.994   567.867     0.150
    54.031   567.344     0.150
    54.163   568.969     0.150
    54.163   569.180     0.150
    54.340   568.625     0.150
    54.972   573.297     0.150
    55.055   576.586     0.150
    55.055   574.719     0.150
    55.380   578.461     0.150
    55.380   577.969     0.150
    55.380   578.570     0.150
    55.607   580.844     0.150
    56.122   583.039     0.150
    56.450   586.078     0.150
    56.545   586.633     0.150
    56.545   586.609     0.150
    56.705   586.227     0.150
    56.795   586.219     0.150
    56.912   588.625     0.150
    56.912   588.711     0.150
    57.107   589.297     0.150
    57.162   589.711     0.150
    57.364   592.086     0.150
    57.339   593.016     0.150
    57.339   592.406     0.150
    57.318   591.625     0.150
    57.821   595.367     0.150
    57.883   596.617     0.150
    57.883   596.469     0.150
    57.889   595.930     0.150
    58.034   596.266     0.150
    58.205   599.367     0.150
    58.209   596.914     0.150
    58.333   599.367     0.150
    58.569   600.969     0.150
    58.714   601.797     0.150
    58.966   602.070     0.150
    59.056   603.070     0.150
    59.057   602.836     0.150
    59.064   602.766     0.150
    59.419   606.469     0.150
    59.419   606.469     0.150
    59.419   606.469     0.150
    59.419   606.469     0.150
    59.419   606.469     0.150
    59.419   606.469     0.150
    59.419   606.766     0.150
    59.419   607.086     0.150
    59.419   606.375     0.150
    59.419   605.969     0.150
    59.516   606.750     0.150
    59.516   605.375     0.150
    59.580   606.523     0.150
    59.691   607.891     0.150
    59.732   608.445     0.150
    59.732   609.328     0.150
    59.729   607.688     0.150
    59.895   609.469     0.150
    59.895   609.609     0.150
    59.953   609.891     0.150
    59.953   609.375     0.150
    60.047   610.555     0.150
    60.047   610.875     0.150
    60.169   610.000     0.150
    60.183   609.766     0.150
    60.258   612.539     0.150
    60.258   612.188     0.150
    60.209   611.109     0.150
    60.244   611.617     0.150
    60.473   614.117     0.150
    60.496   614.406     0.150
    60.620   614.938     0.150
    60.620   615.211     0.150
    60.620   615.469     0.150
    60.641   614.102     0.150
    60.641   613.070     0.150
    60.656   613.641     0.150
    60.856   615.906     0.150
    60.827   615.617     0.150
    60.873   617.867     0.150
    60.975   616.664     0.150
    60.975   616.820     0.150
    61.133   616.250     0.150
    61.133   617.523     0.150
    61.100   617.055     0.150
    61.128   617.828     0.150
    61.139   616.570     0.150
    61.199   618.758     0.150
    61.199   619.664     0.150
    61.349   619.570     0.150
    61.432   619.078     0.150
    61.621   621.320     0.150
    61.825   621.398     0.150
    61.825   621.477     0.150
    61.753   622.094     0.150
    61.799   624.227     0.150
    61.882   624.516     0.150
    62.031   623.164     0.150
    62.126   625.258     0.150
    62.512   627.789     0.150
    62.625   628.000     0.150
    62.691   626.969     0.150
    62.691   627.688     0.150
    62.926   630.000     0.150
    59.008   630.461     0.150
    62.980   631.656     0.150
    63.193   629.891     0.150
    63.193   630.773     0.150
    63.379   631.273     0.150
    63.356   633.891     0.150
    63.359   633.250     0.150
    63.890   636.266     0.150
    64.033   640.375     0.150
    63.947   638.219     0.150
    64.055   637.773     0.150
    27.644   640.797     0.150
    64.363   640.398     0.150
    64.403   639.266     0.150
    64.403   639.359     0.150
    64.448   640.859     0.150
    64.470   642.016     0.150
    64.598   642.867     0.150
    64.746   642.656     0.150
    64.747   643.695     0.150
    64.778   644.016     0.150
    64.993   643.367     0.150
    65.049   642.867     0.150
    65.049   642.891     0.150
    65.049   642.469     0.150
    65.148   644.766     0.150
    65.179   645.148     0.150
    65.336   646.391     0.150
    65.506   648.055     0.150
    65.722   649.648     0.150
    65.725   649.156     0.150
    78.313   649.836     0.150
    65.810   649.844     0.150
    65.887   653.641     0.150
    65.887   650.109     0.150
    66.005   650.289     0.150
    66.159   655.438     0.150
    66.159   652.180     0.150
    66.164   651.578     0.150
    66.389   651.555     0.150
    66.351   653.656     0.150
    66.406   657.641     0.150
    66.427   653.484     0.150
    66.452   653.578     0.150
    66.509   657.539     0.150
    66.628   653.570     0.150
    66.721   659.125     0.150
    66.721   656.438     0.150
    66.782   664.078     0.150
    66.816   657.586     0.150
    66.870   656.586     0.150
    66.895   660.844     0.150
    66.936   655.070     0.150
    66.987   657.328     0.150
    67.019   657.391     0.150
    67.199   658.891     0.150
    67.231   657.891     0.150
    67.254   662.664     0.150
    67.335   660.320     0.150
    67.393   659.414     0.150
    67.405   657.867     0.150
    67.450   660.219     0.150
    67.572   662.586     0.150
    67.608   661.789     0.150
    67.662   661.875     0.150
    67.673   662.000     0.150
    67.681   660.938     0.150
    67.724   665.438     0.150
    67.724   662.438     0.150
    67.725   662.789     0.150
    67.772   665.648     0.150
    67.885   660.367     0.150
    67.878   662.461     0.150
    67.883   663.711     0.150
    67.927   663.984     0.150
    67.948   661.070     0.150
    67.948   661.070     0.150
    67.948   661.070     0.150
    67.948   661.516     0.150
    67.948   660.570     0.150
    67.971   666.867     0.150
    67.971   666.867     0.150
    67.971   666.867     0.150
    67.971   666.867     0.150
    67.971   666.867     0.150
    67.971   666.867     0.150
    67.971   663.688     0.150
    68.070   663.977     0.150
    68.137   665.320     0.150
    68.137   664.555     0.150
    68.087   665.227     0.150
    68.116   667.930     0.150
    33.352   664.438     0.150
    68.160   665.516     0.150
    68.162   668.305     0.150
    68.207   668.391     0.150
    68.207   665.141     0.150
    68.210   668.273     0.150
    68.211   663.500     0.150
    68.252   668.727     0.150
    68.252   665.867     0.150
    68.260   668.664     0.150
    68.294   664.094     0.150
    68.306   664.305     0.150
    68.327   666.148     0.150
    68.361   666.016     0.150
    68.363   665.461     0.150
    68.371   665.820     0.150
    68.398   667.344     0.150
    68.398   667.516     0.150
    68.398   666.141     0.150
    68.448   669.750     0.150
    68.448   667.109     0.150
    68.452   666.711     0.150
    68.462   666.609     0.150
    68.462   665.805     0.150
    68.474   666.000     0.150
    68.504   670.469     0.150
    68.515   670.359     0.150
    68.515   668.289     0.150
    68.530   667.219     0.150
    68.547   667.164     0.150
    68.548   665.719     0.150
    68.591   670.070     0.150
    68.607   670.266     0.150
    68.607   670.266     0.150
    68.607   670.266     0.150
    68.607   670.266     0.150
    68.607   670.266     0.150
    68.607   670.266     0.150
    68.607   667.953     0.150
    68.607   666.969     0.150
    68.616   671.016     0.150
    68.619   667.500     0.150
    68.627   670.227     0.150
    68.628   667.398     0.150
    68.655   668.594     0.150
    68.733   670.258     0.150
    68.736   667.750     0.150
    68.739   677.719     0.150
    68.837   667.641     0.150
    68.837   667.984     0.150
    68.788   670.570     0.150
    68.788   670.570     0.150
    68.788   670.570     0.150
    68.788   670.570     0.150
    68.788   670.570     0.150
    68.788   670.570     0.150
    68.788   667.320     0.150
    68.795   671.719     0.150
   110.524   668.594     0.150
    15.571   667.969     0.150
    68.875   668.289     0.150
    68.875   667.508     0.150
    68.875   667.586     0.150
    68.888   672.438     0.150
    69.042   674.906     0.150
    68.911   672.906     0.150
    68.928   668.109     0.150
    68.935   670.367     0.150
    68.935   670.367     0.150
    68.935   670.367     0.150
    68.935   670.367     0.150
    68.935   670.367     0.150
    68.935   670.367     0.150
    68.935   667.672     0.150
    68.953   670.398     0.150
    68.964   670.430     0.150
    68.991   673.055     0.150
    69.019   670.250     0.150
    69.048   668.664     0.150
    69.072   670.688     0.150
    69.208   670.805     0.150
    69.208   669.359     0.150
    69.089   670.539     0.150
    69.089   670.016     0.150
    69.136   670.094     0.150
    69.119   669.312     0.150
    69.147   671.367     0.150
    69.147   671.367     0.150
    69.147   671.367     0.150
    69.147   671.367     0.150
    69.147   671.367     0.150
    69.147   671.367     0.150
    69.199   671.609     0.150
    69.199   674.727     0.150
    69.209   671.391     0.150
    69.243   674.836     0.150
    69.310   672.617     0.150
    69.349   670.734     0.150
    69.349   671.430     0.150
    69.346   681.898     0.150
    69.371   675.469     0.150
    69.371   675.469     0.150
    69.371   675.469     0.150
    69.371   675.469     0.150
    69.371   675.469     0.150
    69.371   675.469     0.150
    69.371   672.219     0.150
    69.399   676.617     0.150
    69.469   676.484     0.150
    69.523   677.070     0.150
    69.523   677.070     0.150
    69.523   677.070     0.150
    69.523   677.070     0.150
    69.523   677.070     0.150
    69.523   677.070     0.150
    69.532   673.102     0.150
    69.534   655.859     0.150
    69.728   678.273     0.150
    69.744   669.477     0.150
    69.773   678.195     0.150
    69.807   675.828     0.150
    69.807   678.609     0.150
    69.826   675.578     0.150
    69.934   676.430     0.150
    70.014   676.578     0.150
    70.102   675.070     0.150
    70.181   675.859     0.150
    29.756   674.742     0.150
    70.164   675.164     0.150
    70.177   680.367     0.150
    70.177   680.367     0.150
    70.177   680.367     0.150
    70.177   680.367     0.150
    70.177   680.367     0.150
    70.177   680.367     0.150
    70.243   677.844     0.150
    70.253   681.070     0.150
    70.253   681.070     0.150
    70.253   681.070     0.150
    70.253   681.070     0.150
    70.253   681.070     0.150
    70.253   681.070     0.150
    70.253   677.930     0.150
    70.253   678.664     0.150
    70.355   679.266     0.150
    70.464   682.969     0.150
    70.464   682.969     0.150
    70.464   682.969     0.150
    70.464   682.969     0.150
    70.464   682.969     0.150
    70.463   679.469     0.150
    70.463   679.469     0.150
    70.463   679.469     0.150
    70.463   679.469     0.150
    70.463   679.469     0.150
    70.463   679.469     0.150
    70.493   680.250     0.150
    70.518   683.070     0.150
    70.518   683.070     0.150
    70.518   683.070     0.150
    70.518   683.070     0.150
    70.518   680.664     0.150
    70.520   679.500     0.150
    70.518   680.180     0.150
    70.526   682.469     0.150
    70.526   682.469     0.150
    70.526   682.469     0.150
    70.526   682.469     0.150
    70.526   679.570     0.150
    70.526   680.070     0.150
    70.559   682.367     0.150
    70.559   682.367     0.150
    70.559   682.367     0.150
    70.559   682.367     0.150
    70.559   682.367     0.150
    70.610   678.508     0.150
    70.611   680.586     0.150
    70.649   677.797     0.150
    70.657   683.445     0.150
    70.657   680.250     0.150
    70.682   683.766     0.150
    70.682   683.766     0.150
    70.682   683.766     0.150
    70.682   683.766     0.150
    70.682   683.766     0.150
    70.736   684.570     0.150
    70.736   684.570     0.150
    70.736   684.570     0.150
    70.736   684.570     0.150
    70.736   681.523     0.150
    70.736   681.500     0.150
    70.736   681.469     0.150
    70.787   685.367     0.150
    70.787   685.367     0.150
    70.787   685.367     0.150
    70.787   685.367     0.150
    70.787   681.164     0.150
    70.836   682.070     0.150
    70.836   682.070     0.150
    70.836   682.070     0.150
    70.836   682.070     0.150
    70.836   680.320     0.150
    70.836   680.164     0.150
    70.888   686.266     0.150
    70.888   686.266     0.150
    70.888   686.266     0.150
    70.888   686.266     0.150
    70.888   686.266     0.150
    70.888   682.836     0.150
    70.908   681.867     0.150
    70.908   681.867     0.150
    70.908   681.867     0.150
    70.908   681.867     0.150
    70.908   681.867     0.150
    70.908   680.750     0.150
    70.928   677.055     0.150
    70.964   682.625     0.150
    71.052   689.664     0.150
    71.052   689.664     0.150
    71.052   689.664     0.150
    71.052   689.664     0.150
    71.052   683.727     0.150
    71.052   686.664     0.150
    71.010   682.680     0.150
    71.083   686.664     0.150
    71.083   686.664     0.150
    71.083   686.664     0.150
    71.083   686.664     0.150
    71.083   683.766     0.150
    71.108   685.469     0.150
    71.108   685.469     0.150
    71.108   685.469     0.150
    71.108   685.469     0.150
    42.525   682.398     0.150
    71.159   684.156     0.150
    71.164   680.320     0.150
    71.159   690.164     0.150
    71.159   690.164     0.150
    71.159   690.164     0.150
    71.159   687.164     0.150
    29.756   682.844     0.150
    71.269   686.641     0.150
    71.289   684.617     0.150
    71.359   688.070     0.150
    71.359   688.070     0.150
    71.359   688.070     0.150
    71.359   688.070     0.150
    71.359   684.500     0.150
    71.362   683.727     0.150
    71.389   688.164     0.150
    71.389   688.164     0.150
    71.389   688.164     0.150
    71.389   688.164     0.150
    71.389   688.164     0.150
    71.389   687.055     0.150
    71.389   685.234     0.150
    71.391   690.070     0.150
    71.391   690.070     0.150
    71.391   690.070     0.150
    71.391   690.070     0.150
    71.391   689.992     0.150
    71.391   687.164     0.150
    71.403   683.867     0.150
    71.473   685.711     0.150
    71.473   688.969     0.150
    71.473   688.969     0.150
    71.473   688.969     0.150
    71.473   688.969     0.150
    71.473   686.164     0.150
    71.501   687.469     0.150
    71.501   687.469     0.150
    71.501   687.469     0.150
    71.501   687.469     0.150
    71.501   687.469     0.150
    71.501   686.539     0.150
    71.501   686.234     0.150
    71.501   685.367     0.150
    71.521   684.023     0.150
    71.871   686.766     0.150
    71.564   680.273     0.150
    71.690   685.445     0.150
    71.690   686.109     0.150
    71.616   686.375     0.150
    71.623   688.367     0.150
    71.624   687.594     0.150
    71.680   690.867     0.150
    71.680   690.867     0.150
    71.735   691.164     0.150
    71.822   685.820     0.150
    71.848   687.914     0.150
    71.929   687.141     0.150
    71.929   686.758     0.150
    71.881   686.367     0.150
    71.883   686.266     0.150
    71.870   694.500     0.150
    71.960   670.953     0.150
    71.959   688.266     0.150
    72.079   689.375     0.150
    72.115   684.211     0.150
    72.150   689.367     0.150
    72.236   688.750     0.150
    72.247   695.469     0.150
    72.247   695.469     0.150
    72.247   695.469     0.150
    72.247   690.102     0.150
    72.254   691.461     0.150
    72.288   691.430     0.150
    72.297   694.164     0.150
    72.297   694.164     0.150
    72.297   694.164     0.150
    72.349   694.266     0.150
    72.349   694.266     0.150
    72.349   694.266     0.150
    72.349   694.266     0.150
    72.349   692.703     0.150
    72.382   695.367     0.150
    72.382   695.367     0.150
    72.382   695.367     0.150
    72.382   694.602     0.150
    72.524   695.367     0.150
    72.529   691.867     0.150
    72.527   691.273     0.150
    72.532   692.188     0.150
    72.573   692.195     0.150
    72.639   691.172     0.150
    72.639   691.305     0.150
    72.581   691.250     0.150
    72.600   692.477     0.150
    72.641   692.477     0.150
    72.655   692.086     0.150
    72.772   692.266     0.150
    29.756   693.523     0.150
    72.804   693.336     0.150
    72.834   687.898     0.150
    72.834   695.352     0.150
    72.839   696.117     0.150
    72.839   693.367     0.150
    72.851   670.469     0.150
    72.879   692.609     0.150
    72.913   693.984     0.150
    72.861   656.664     0.150
    72.917   692.773     0.150
    72.929   694.008     0.150
    72.971   688.695     0.150
    72.971   693.844     0.150
    72.992   696.836     0.150
    73.046   697.258     0.150
    73.095   699.766     0.150
    73.135   697.055     0.150
    73.150   693.773     0.150
    73.164   698.719     0.150
    29.756   689.891     0.150
    73.226   694.516     0.150
    73.211   699.367     0.150
    73.211   699.367     0.150
    73.211   699.367     0.150
    73.211   695.312     0.150
    73.211   696.164     0.150
    73.265   650.117     0.150
    73.265   697.641     0.150
    34.000   695.883     0.150
    34.000   695.227     0.150
    73.307   699.797     0.150
    73.349   701.188     0.150
    73.376   697.664     0.150
    73.385   705.969     0.150
    73.385   705.969     0.150
    73.385   697.859     0.150
    73.415   695.711     0.150
    73.435   695.570     0.150
    73.428   699.297     0.150
    73.437   667.477     0.150
    73.440   698.227     0.150
    73.468   703.984     0.150
    73.498   696.648     0.150
    73.486   706.266     0.150
    73.486   706.266     0.150
    73.486   706.266     0.150
    73.486   700.789     0.150
    73.486   698.523     0.150
    73.549   696.438     0.150
    73.493   697.141     0.150
    73.494   697.914     0.150
    73.504   699.164     0.150
    73.516   701.562     0.150
    73.541   699.273     0.150
    73.546   698.609     0.150
    73.571   694.727     0.150
    73.609   697.164     0.150
    73.609   697.391     0.150
    73.609   696.617     0.150
    73.660   696.414     0.150
    73.616   700.789     0.150
    73.618   706.766     0.150
    73.618   706.766     0.150
    73.618   706.766     0.150
    73.618   699.883     0.150
    73.619   700.062     0.150
    73.624   704.617     0.150
    73.691   697.141     0.150
    73.688   701.570     0.150
    73.734   697.828     0.150
    73.758   698.602     0.150
    73.758   700.891     0.150
    73.786   680.320     0.150
    73.782   700.992     0.150
    73.786   700.367     0.150
    73.786   699.039     0.150
    73.789   708.266     0.150
    73.789   708.266     0.150
    73.789   708.266     0.150
    73.789   703.211     0.150
    73.789   700.234     0.150
    73.815   656.453     0.150
    29.756   657.992     0.150
    73.827   698.398     0.150
    73.835   702.391     0.150
    73.847   699.023     0.150
    73.862   700.266     0.150
    73.898   697.875     0.150
    73.884   702.047     0.150
    73.896   702.461     0.150
    73.900   705.703     0.150
    73.904   703.617     0.150
    73.908   703.055     0.150
    73.941   702.500     0.150
    73.968   702.055     0.150
    73.971   701.477     0.150
    73.971   701.477     0.150
    73.974   704.789     0.150
    74.030   703.383     0.150
    74.078   706.805     0.150
    74.110   684.352     0.150
    74.110   701.727     0.150
    74.178   700.789     0.150
    74.178   700.578     0.150
    74.137   706.086     0.150
    74.202   701.828     0.150
    74.204   704.602     0.150
    74.212   702.562     0.150
    74.212   702.414     0.150
    74.254   708.852     0.150
    74.286   704.867     0.150
    74.293   705.305     0.150
    74.357   700.977     0.150
    74.318   704.625     0.150
    74.329   704.078     0.150
    74.329   702.750     0.150
    74.334   704.180     0.150
    74.389   700.898     0.150
    74.459   703.711     0.150
    74.623   705.867     0.150
    74.623   705.258     0.150
    74.627   704.719     0.150
    74.652   712.781     0.150
    74.652   705.430     0.150
    74.657   708.672     0.150
    74.669   699.641     0.150
    74.747   704.484     0.150
    74.696   704.430     0.150
    74.706   702.320     0.150
    74.783   703.438     0.150
    74.754   707.422     0.150
    74.772   686.703     0.150
    74.785   712.789     0.150
    74.801   679.172     0.150
    74.804   705.648     0.150
    74.805   707.648     0.150
    74.821   703.828     0.150
    74.870   706.969     0.150
    74.876   700.781     0.150
    74.886   671.344     0.150
    14.714   703.312     0.150
    14.714   704.469     0.150
    74.908   705.578     0.150
    74.930   714.797     0.150
    74.939   704.070     0.150
    74.971   703.539     0.150
    74.984   708.156     0.150
    75.023   709.062     0.150
    75.023   700.281     0.150
    75.044   663.633     0.150
    75.044   706.367     0.150
    75.049   711.977     0.150
    75.065   705.977     0.150
    75.117   711.500     0.150
    75.118   709.422     0.150
    75.176   708.430     0.150
    75.211   709.086     0.150
    75.302   708.016     0.150
    75.302   710.602     0.150
    75.313   711.008     0.150
    75.324   708.461     0.150
    75.401   709.195     0.150
    75.360   707.039     0.150
    75.440   707.180     0.150
    75.548   709.250     0.150
    75.689   705.219     0.150
    75.718   711.016     0.150
    75.749   712.797     0.150
    75.770   707.531     0.150
    75.880   710.516     0.150
    75.811   710.688     0.150
    75.810   707.773     0.150
    29.756   705.938     0.150
    75.833   711.508     0.150
    75.876   675.203     0.150
    76.066   712.414     0.150
    76.066   711.258     0.150
    75.979   711.555     0.150
    75.979   711.164     0.150
    75.979   710.586     0.150
    75.979   711.414     0.150
    75.996   710.359     0.150
    76.046   713.766     0.150
    76.046   712.414     0.150
    76.185   712.453     0.150
    76.122   707.398     0.150
    76.145   713.641     0.150
    76.162   708.555     0.150
    76.202   712.664     0.150
    76.218   715.750     0.150
    76.275   713.406     0.150
    76.380   713.250     0.150
    76.380   713.945     0.150
    76.394   714.414     0.150
    76.423   713.664     0.150
    76.765   715.539     0.150
    76.844   715.008     0.150
    76.920   716.961     0.150
    77.204   717.758     0.150
    77.210   721.680     0.150
    77.218   721.859     0.150
    77.394   718.570     0.150
    77.394   718.891     0.150
    77.417   724.312     0.150
    77.617   722.008     0.150
    77.759   721.625     0.150
    77.911   722.398     0.150
    78.151   728.406     0.150
    51.692   722.742     0.150
    78.056   723.258     0.150
    78.462   728.312     0.150
    78.462   725.508     0.150
    78.520   725.094     0.150
    78.604   725.797     0.150
    78.604   727.023     0.150
    78.705   726.438     0.150
    78.783   736.797     0.150
    79.504   731.586     0.150
    79.737   732.336     0.150
    79.737   731.266     0.150
    79.792   733.438     0.150
    79.875   733.992     0.150
    79.875   734.188     0.150
    79.875   733.227     0.150
    80.662   737.086     0.150
    80.701   737.711     0.150
    80.836   739.391     0.150
    80.836   739.914     0.150
    81.139   740.305     0.150
    81.241   741.828     0.150
    81.712   743.227     0.150
    81.730   742.859     0.150
    82.092   748.836     0.150
    82.302   747.125     0.150
    82.349   746.688     0.150
    82.956   751.211     0.150
    82.956   750.727     0.150
    82.989   748.969     0.150
    83.133   748.875     0.150
    83.363   751.914     0.150
    83.463   751.656     0.150
    83.511   752.344     0.150
    79.276   752.141     0.150
    79.276   753.984     0.150
    84.097   754.219     0.150
    84.173   755.719     0.150
    84.303   755.023     0.150
    84.303   754.797     0.150
    84.791   758.500     0.150
    85.060   761.266     0.150
    57.419   763.469     0.150
    57.419   763.188     0.150
    86.311   765.297     0.150
    86.311   765.086     0.150
    86.346   766.969     0.150
    86.346   766.875     0.150
    87.143   770.914     0.150
    87.143   770.250     0.150
    87.476   770.562     0.150
    87.476   769.734     0.150
    87.473   770.961     0.150
    87.559   770.367     0.150
    87.559   770.367     0.150
    87.755   774.008     0.150
    88.097   774.156     0.150
    88.097   774.727     0.150
    88.159   775.391     0.150
    88.159   773.836     0.150
    88.158   774.297     0.150
    88.481   776.070     0.150
    88.516   776.141     0.150
    88.593   776.859     0.150
    88.593   777.617     0.150
    89.351   780.344     0.150
    89.351   780.484     0.150
    89.412   782.125     0.150
    90.041   786.289     0.150
    90.041   783.406     0.150
    90.135   783.078     0.150
    90.898   787.523     0.150
    90.898   787.344     0.150
    91.032   786.641     0.150
    91.032   786.359     0.150
    91.028   790.445     0.150
    91.226   789.969     0.150
    18.330   791.906     0.150
    91.659   791.109     0.150
    91.785   792.859     0.150
    92.109   793.359     0.150
    92.641   797.617     0.150
    93.108   800.141     0.150
    93.188   799.164     0.150
    93.188   796.945     0.150
    93.276   803.578     0.150
    74.435   800.617     0.150
    93.994   801.641     0.150
    93.994   804.234     0.150
    94.736   809.789     0.150
    94.736   803.711     0.150
    95.138   804.727     0.150
    95.673   811.375     0.150
    95.883   809.945     0.150
    96.262   810.320     0.150
    96.315   811.367     0.150
    33.745   816.938     0.150
    33.745   816.148     0.150
    97.081   817.164     0.150
    97.266   822.445     0.150
    97.266   817.055     0.150
    97.356   817.797     0.150
    98.572   828.234     0.150
    98.582   824.289     0.150
    98.582   823.516     0.150
    98.702   821.750     0.150
    98.812   828.492     0.150
    98.812   825.109     0.150
    98.816   825.445     0.150
    98.816   824.570     0.150
    98.975   825.164     0.150
    29.756   825.086     0.150
    99.656   827.867     0.150
    99.782   828.641     0.150
    99.782   829.141     0.150
    99.782   828.461     0.150
    99.958   829.242     0.150
    99.958   828.750     0.150
   100.152   833.086     0.150
   100.152   831.789     0.150
   100.572   831.117     0.150
   100.771   835.164     0.150
   100.752   837.070     0.150
   100.752   832.000     0.150
   101.742   835.016     0.150
   102.075   838.445     0.150
   102.663   841.727     0.150
   102.663   840.867     0.150
   102.874   840.969     0.150
   103.918   849.789     0.150
   103.918   844.328     0.150
   104.233   852.945     0.150
   105.249   857.688     0.150
   107.950   869.992     0.150
    34.549   414.938     0.150
    29.756  1125.930     0.150
   114.544  1127.219     0.150
   114.686  1128.289     0.150
   115.165  1128.945     0.150
   115.262  1128.367     0.150
   115.329  1123.289     0.150
   115.454  1125.914     0.150
   115.581  1127.367     0.150
   116.040  1130.766     0.150
   116.053  1126.094     0.150
   116.203  1132.219     0.150
   116.624  1125.391     0.150
   117.411  1128.945     0.150
   117.854  1127.844     0.150
   118.575  1132.664     0.150
    29.756  1129.258     0.150
   118.605  1131.695     0.150
   118.944  1136.617     0.150
    29.756  1134.125     0.150
   119.938  1133.891     0.150
   120.892  1136.070     0.150
   120.905  1134.328     0.150
   120.821  1137.562     0.150
   121.887  1138.195     0.150
   122.049  1140.039     0.150
   122.183  1138.055     0.150
   122.823  1139.664     0.150
   123.060  1140.500     0.150
   123.102  1140.344     0.150
   123.242  1145.586     0.150
   124.180  1142.391     0.150
   124.323  1143.789     0.150
   124.358  1141.492     0.150
   124.442  1142.812     0.150
   124.627  1144.016     0.150
   125.250  1148.641     0.150
   125.922  1150.664     0.150
   126.465  1147.414     0.150
   129.285  1149.109     0.150
   132.620  1159.266     0.150
   134.047  1165.086     0.150
   135.707  1161.461     0.150
   136.961  1172.141     0.150
   138.376  1164.484     0.150
   138.783  1170.062     0.150
   139.334  1174.117     0.150
   139.791  1176.016     0.150
   140.235  1169.891     0.150
   140.924  1179.266     0.150
   141.841  1178.836     0.150
   142.299  1170.766     0.150
   143.147  1175.719     0.150
   144.302  1179.164     0.150
   146.413  1184.992     0.150
   148.729  1183.820     0.150
   149.097  1187.836     0.150
   151.095  1188.898     0.150
   151.313  1195.383     0.150
     0.943    15.680     0.150
     2.270    40.305     0.150
     2.537    43.719     0.150
     4.589    71.969     0.150
     4.603    69.836     0.150
     4.912    74.234     0.150
     9.287   134.023     0.150
    76.598   712.312     0.150
    24.035   314.016     0.150
    26.279   332.914     0.150
    31.159   375.711     0.150
    33.100   394.312     0.150
    88.570   776.109     0.150
     0.508     8.445     0.150
     0.978    31.945     0.150
     1.050    33.562     0.150
     1.542    49.352     0.150
     1.821    33.367     0.150
     1.821    54.203     0.150
     1.920    58.906     0.150
     5.814    88.016     0.150
    16.209   227.523     0.150
     0.489     8.789     0.150
     0.712    12.570     0.150
     1.447    28.211     0.150
     1.532    45.773     0.150
     1.686    51.664     0.150
     1.885    30.969     0.150
     5.759    88.773     0.150
     0.528    14.945     0.150
     0.997    30.516     0.150
     1.153    23.234     0.150
     1.274    22.492     0.150
     1.327    22.969     0.150
     1.439    46.992     0.150
     1.792    33.648     0.150
     2.034    61.523     0.150
     2.690    41.562     0.150
     2.997    48.531     0.150
     0.543    10.055     0.150
     1.491    48.055     0.150
     2.145    70.164     0.150
     7.387   107.492     0.150
     0.769    27.250     0.150
     0.933    29.898     0.150
     0.933    17.281     0.150
     1.093    38.617     0.150
     1.099    32.570     0.150
     1.222    21.875     0.150
     1.201    21.984     0.150
     1.201    36.789     0.150
     1.378    25.820     0.150
     3.568    58.805     0.150
     4.292    63.391     0.150
     5.326    84.414     0.150
     1.228    21.375     0.150
     1.200    22.133     0.150
     1.895    59.953     0.150
     7.094  3675.289     0.150
    12.191  3743.586     0.150
    23.726  3885.484     0.150
    28.882  3929.289     0.150
    33.667  3973.586     0.150
    49.145  4100.984     0.150
    57.618  4162.289     0.150
    60.456  4181.188     0.150
    62.547  4194.984     0.150
    63.697  4202.484     0.150
    64.237  4206.086     0.150
    64.868  4209.883     0.150
    67.697  4228.383     0.150
    15.412  4234.289     0.150
    73.429  4264.789     0.150
    88.264  4344.484     0.150
     1.227    20.992     0.150
     1.200    47.203     0.150
     4.788    73.617     0.150
     6.449    93.945     0.150
    23.722   263.773     0.150
     0.500     8.711     0.150
     0.694    22.141     0.150
     1.302    26.570     0.150
     2.178    36.703     0.150
     4.448    68.531     0.150
     0.939    16.984     0.150
     0.939    29.344     0.150
     1.230    21.336     0.150
     1.230    37.000     0.150
     1.196    42.164     0.150
     1.196    36.266     0.150
     1.910    57.875     0.150
     2.004    65.016     0.150
     2.459    43.750     0.150
     2.612    46.898     0.150
     3.576    55.773     0.150
     4.305    70.141     0.150
     4.569    72.234     0.150
     7.584   113.391     0.150
     8.275   124.055     0.150
     9.141   133.648     0.150
    23.724   265.844     0.150
     8.293   121.211     0.150
     1.370    23.990     0.150
     1.869    60.850     0.150
     2.746    48.830     0.150
    20.471   278.690     0.150
    20.821   284.480     0.150
     1.287    22.349     0.150
     1.928    64.689     0.150
     2.028    65.569     0.150
     2.394    78.279     0.150
    57.825   593.489     0.150
    16.094   229.129     0.150
    26.861   345.419     0.150
    29.595   360.869     0.150
    68.732   665.739     0.150
    68.732   665.689     0.150
    69.184   670.299     0.150
    73.358   692.073     0.150
    73.653   695.323     0.150
    73.653   694.709     0.150
    75.414   702.248     0.150
    33.941   812.709     0.150
     1.434    24.910     0.150
    16.939   232.800     0.150
    17.401   247.870     0.150
    18.758   265.300     0.150
    21.125   291.440     0.150
    21.159   290.710     0.150
    21.412   292.580     0.150
    25.298   333.540     0.150
    29.996   374.450     0.150
     0.747    22.582     0.150
     0.907    32.002     0.150
     1.178    35.782     0.150
     1.178    20.492     0.150
     1.887    62.872     0.150
     2.478    77.013     0.150
    21.398   292.452     0.150
    74.716   701.742     0.150
     1.924    63.272     0.150
    23.804   315.103     0.150
     0.952    19.729     0.150
     1.311    42.598     0.150
     1.440    25.208     0.150
    20.743   286.008     0.150
     1.912    63.267     0.150
    76.032   298.417     0.150
    29.611   402.326     0.150
    34.035   810.277     0.150
     1.098    33.735     0.150
     1.211    21.516     0.150
     0.576    17.080     0.150
     2.520    40.230     0.150
     4.753    67.670     0.150
     9.064   134.051     0.150
   124.476   253.320     0.150
     1.235    21.395     0.150
     1.894    33.246     0.150
     2.606    47.266     0.150
     5.330    86.195     0.150
    67.681   659.975     0.150
     1.446    46.773     0.150
     1.937    63.174     0.150
     1.201    20.500     0.150
    15.476   222.010     0.150
    15.694   218.383     0.150
    16.503   237.770     0.150
    39.496   453.191     0.150
     0.483    11.359     0.150
     1.887    57.852     0.150
    30.220   372.730     0.150
     0.684    14.105     0.150
     0.938    17.336     0.150
     1.103    34.426     0.150
     1.103    20.055     0.150
     1.480    47.188     0.150
     2.375    39.598     0.150
     6.045    91.445     0.150
   124.592   255.266     0.150
    20.624   284.695     0.150
    30.636   377.957     0.150
    39.347   452.887     0.150
     1.439    24.836     0.150
     1.829    60.664     0.150
    15.245   214.695     0.150
    23.947   265.074     0.150
     1.222    21.277     0.150
     4.271    68.668     0.150
    30.201   373.008     0.150
     0.557    11.449     0.150
     0.966    18.910     0.150
     0.855    30.637     0.150
     1.245    21.910     0.150
     1.419    45.387     0.150
     3.577    61.500     0.150
     4.821    74.938     0.150
     5.297    84.688     0.150
     1.355    23.461     0.150
     2.019    66.352     0.150
     2.672    46.504     0.150
     2.730    48.594     0.150
     0.896    32.062     0.150
     1.367    23.621     0.150
     1.867    60.930     0.150
     2.328    73.562     0.150
    98.176   279.371     0.150
    20.518   280.242     0.150
    57.893   592.609     0.150
    10.465   156.523     0.150
    26.219   340.730     0.150
    30.863   379.070     0.150
    33.278   401.762     0.150
    34.928   415.652     0.150
    40.250   459.941     0.150
    45.005   501.781     0.150
    48.419   527.250     0.150
    59.326   606.492     0.150
    60.545   611.352     0.150
    64.953   642.852     0.150
    67.137   658.719     0.150
    67.598   661.695     0.150
    67.814   662.672     0.150
    68.229   665.898     0.150
    68.395   666.000     0.150
    15.539   666.852     0.150
    68.983   670.500     0.150
    70.767   681.461     0.150
    73.144   695.031     0.150
    73.422   697.102     0.150
    18.415   790.594     0.150
     1.212    21.031     0.150
     1.424    46.250     0.150
     1.719    57.031     0.150
     3.223    52.031     0.150
    19.752   271.414     0.150
    29.640   400.117     0.150
    87.865   770.297     0.150
     6.215    94.742     0.150
     7.081   104.648     0.150
     7.081   104.812     0.150
    10.358   154.219     0.150
    16.120   233.711     0.150
    23.710   313.641     0.150
    23.778   317.398     0.150
    34.366   317.961     0.150
    29.640   360.859     0.150
    30.714   376.930     0.150
    34.815   412.000     0.150
    37.677   436.484     0.150
    38.120   440.938     0.150
    39.784   456.430     0.150
    56.696   585.703     0.150
    58.975   602.031     0.150
    59.192   603.438     0.150
    59.192   603.406     0.150
    59.192   603.359     0.150
    64.856   639.891     0.150
    67.187   657.312     0.150
    67.400   658.891     0.150
    67.747   658.188     0.150
    67.922   664.344     0.150
    67.922   664.344     0.150
    68.398   664.102     0.150
    68.550   667.539     0.150
    68.550   667.539     0.150
    68.737   667.438     0.150
    68.737   667.438     0.150
    68.787   664.984     0.150
    68.881   668.844     0.150
    68.881   668.844     0.150
    69.094   669.539     0.150
    69.467   674.344     0.150
    69.467   674.344     0.150
    70.126   676.242     0.150
    70.388   676.344     0.150
    70.412   679.938     0.150
    70.461   677.438     0.150
    70.466   680.344     0.150
    70.466   680.344     0.150
    70.487   680.938     0.150
    70.487   680.938     0.150
    70.569   677.258     0.150
    70.612   679.141     0.150
    70.674   678.844     0.150
    70.674   677.914     0.150
    70.738   680.039     0.150
    70.738   680.039     0.150
    70.767   679.141     0.150
    70.832   679.844     0.150
    70.832   679.844     0.150
    71.026   681.844     0.150
    71.105   684.141     0.150
    71.105   684.141     0.150
    71.317   685.141     0.150
    71.314   683.141     0.150
    71.314   683.141     0.150
    71.418   686.141     0.150
    71.418   686.141     0.150
    71.434   686.742     0.150
    71.434   686.742     0.150
    72.242   690.742     0.150
    72.242   690.742     0.150
    72.278   690.844     0.150
    29.640   689.883     0.150
    29.640   691.867     0.150
    73.147   695.742     0.150
    73.147   692.297     0.150
    73.417   694.102     0.150
    29.640   696.148     0.150
    33.774   695.273     0.150
    33.774   695.281     0.150
    74.743   699.969     0.150
     1.191    20.258     0.150
     1.191    35.070     0.150
     1.967    63.641     0.150
     3.980    70.281     0.150
    66.856   252.758     0.150
    23.707   264.758     0.150
    19.605   273.438     0.150
    98.308   279.648     0.150
    20.637   281.883     0.150
    21.463   292.969     0.150
    27.978   355.383     0.150
    33.723   403.172     0.150
    65.040   640.039     0.150
     0.728    13.010     0.150
     0.728    25.610     0.150
     0.902    32.210     0.150
     1.014    18.570     0.150
     1.014    35.370     0.150
     1.402    23.510     0.150
     3.900    59.320     0.150
    21.461   289.750     0.150
    29.775   398.750     0.150
    57.334   588.320     0.150
    60.028   607.350     0.150
     1.218    23.379     0.150
     1.218    42.814     0.150
     2.320    38.034     0.150
     2.320    73.268     0.150
     2.320    38.530     0.150
     3.078    50.240     0.150
     3.003    46.725     0.150
     3.146    50.840     0.150
     3.689    58.326     0.150
     4.497    70.540     0.150
    10.152   150.710     0.150
    10.376   152.650     0.150
    14.002   203.620     0.150
    14.017   206.429     0.150
    17.611   247.195     0.150
    18.575   260.922     0.150
    18.575   260.910     0.150
    34.158   315.662     0.150
    23.930   315.890     0.150
    23.930   315.940     0.150
    25.981   334.690     0.150
    29.775   360.860     0.150
    30.033   371.640     0.150
    30.113   375.579     0.150
    33.202   400.240     0.150
    35.024   414.138     0.150
    35.024   414.110     0.150
    37.500   436.350     0.150
    37.475   434.800     0.150
    38.192   440.680     0.150
    39.745   454.630     0.150
    39.893   456.618     0.150
    40.334   458.620     0.150
    40.610   463.530     0.150
    49.791   533.400     0.150
    49.791   533.420     0.150
    49.926   534.815     0.150
    49.926   534.815     0.150
    49.926   534.815     0.150
    49.926   534.815     0.150
    51.942   549.720     0.150
    51.942   549.950     0.150
    55.356   575.740     0.150
    57.153   587.602     0.150
    57.153   587.527     0.150
    57.153   587.602     0.150
    57.911   593.440     0.150
    57.990   593.380     0.150
    57.990   593.380     0.150
    57.990   593.380     0.150
    57.990   593.380     0.150
    57.990     5.080     0.150
    58.018   593.277     0.150
    58.018   593.777     0.150
    59.411   605.200     0.150
    59.542   604.890     0.150
    59.542     6.850     0.150
    59.542   604.815     0.150
    59.542   604.890     0.150
    59.542   605.265     0.150
    59.542     2.900     0.150
    59.542     3.400     0.150
    59.542     6.850     0.150
    59.547   605.190     0.150
    59.709   607.230     0.150
    60.860   614.070     0.150
    64.412   637.940     0.150
    65.053   641.540     0.150
    78.335   647.310     0.150
    67.951   659.923     0.150
    67.999   661.110     0.150
    68.634   664.850     0.150
    68.815   666.000     0.150
    15.538   665.540     0.150
    69.336   670.440     0.150
    69.550   671.740     0.150
    42.550   682.192     0.150
    33.977   695.815     0.150
    33.977   694.620     0.150
    73.614   694.490     0.150
    74.236   699.110     0.150
    75.997   709.240     0.150
    79.305   755.910     0.150
    87.492   769.610     0.150
    88.085   772.470     0.150
    88.147   772.720     0.150
    18.346   789.190     0.150
    33.757   812.030     0.150
    29.775   824.041     0.150
     1.423    24.946     0.150
     1.423    42.426     0.150
     2.289    72.256     0.150
     0.744    20.578     0.150
     1.064    32.441     0.150
     1.064    18.598     0.150
     1.184    20.469     0.150
     1.184    36.109     0.150
     1.911    63.719     0.150
     1.970    63.840     0.150
     2.357    74.871     0.150
     2.493    44.160     0.150
     3.251    54.750     0.150
     3.230    55.191     0.150
    16.191   227.668     0.150
    16.516   234.520     0.150
     0.801    13.055     0.150
     0.965    30.023     0.150
     1.243    21.172     0.150
     1.243    37.281     0.150
    29.598    64.766     0.150
     1.123    19.362     0.150
     1.258    46.282     0.150
     1.388    24.612     0.150
     1.879    61.332     0.150
     2.778    48.922     0.150
     1.228    37.807     0.150
     1.228    21.346     0.150
     1.489    25.516     0.150
     1.489    48.195     0.150
     5.604    87.836     0.150
     6.725    99.006     0.150
     1.211    21.312     0.150
     1.454    44.250     0.150
     1.454    25.312     0.150
    36.469   140.812     0.150
    10.258   152.773     0.150
    73.258   172.430     0.150
     2.465    41.953     0.150
    10.388   155.312     0.150
    20.462   283.930     0.150
    22.420   303.453     0.150
    23.645   315.152     0.150
    33.478   399.352     0.150
    54.783   573.742     0.150
    67.596   659.750     0.150
    15.425   664.852     0.150
    77.475   720.281     0.150
     0.801    24.645     0.150
     1.217    21.695     0.150
     7.914   118.836     0.150
    73.252   172.715     0.150
    25.575   331.188     0.150
     0.606    18.941     0.150
     1.123    36.402     0.150
     1.226    21.012     0.150
     1.731    30.441     0.150
     2.101    35.344     0.150
    29.562   240.613     0.150
    66.748   254.184     0.150
   124.515   254.902     0.150
    29.562   261.914     0.150
    29.562   265.543     0.150
    29.562   267.145     0.150
    23.672   266.223     0.150
    29.562   303.242     0.150
    29.562   382.691     0.150
    73.347   384.242     0.150
    31.856   385.562     0.150
    36.639   432.262     0.150
    16.161   228.844     0.150
    23.672   315.305     0.150
    26.930   344.281     0.150
    29.562   359.652     0.150
    34.760   414.402     0.150
    34.760   414.023     0.150
    57.071   590.613     0.150
    58.300   600.102     0.150
    61.276   619.742     0.150
    62.465   626.902     0.150
    64.158   638.902     0.150
    64.793   641.402     0.150
    66.748   655.523     0.150
    67.072   658.125     0.150
    67.625   660.102     0.150
    67.688   661.504     0.150
    67.688   660.512     0.150
    67.688   660.203     0.150
    15.433   664.902     0.150
    68.707   665.855     0.150
    70.046   679.004     0.150
    70.046    -0.059     0.150
    70.380   681.703     0.150
    70.407   683.203     0.150
    70.489   675.359     0.150
    70.594   681.305     0.150
    70.658   682.703     0.150
    70.686   681.602     0.150
    70.752   682.102     0.150
    70.946   685.203     0.150
    71.234   682.602     0.150
    73.066   695.504     0.150
    73.354   696.504     0.150
    73.354   696.414     0.150
    73.467   698.402     0.150
    73.467   693.914     0.150
    33.772   697.172     0.150
    86.047   765.043     0.150
    85.470   768.555     0.150
    87.832   773.582     0.150
    87.895   774.004     0.150
    87.894   773.875     0.150
    87.895   774.402     0.150
    89.089   779.895     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.559    11.768     0.150
     1.235    22.869     0.150
     1.235    39.068     0.150
     2.284    39.068     0.150
     2.284    70.068     0.150
     3.804    60.068     0.150
     4.934    75.869     0.150
     7.988   115.969     0.150
     8.373   121.668     0.150
     8.639   125.869     0.150
     9.771   143.568     0.150
    10.804   156.369     0.150
    12.246   174.568     0.150
    12.246   381.068     0.150
    13.206   189.068     0.150
    15.702   228.068     0.150
    15.870   223.768     0.150
    17.561   248.068     0.150
    17.664   248.068     0.150
    18.769   258.568     0.150
    20.396   280.469     0.150
    20.708   281.068     0.150
   149.934  1189.869     0.150
     0.315     6.988     0.150
     2.332    39.488     0.150
     2.332    68.688     0.150
     3.750    58.789     0.150
     3.806    58.086     0.150
     4.839    73.586     0.150
     4.877    73.988     0.150
     5.013    76.488     0.150
     5.192    78.887     0.150
     5.192   163.688     0.150
     5.238    79.887     0.150
     5.809    86.887     0.150
     5.809   183.188     0.150
     6.107    97.688     0.150
     7.068   104.188     0.150
     7.150   106.988     0.150
     7.150   229.688     0.150
     7.931   115.887     0.150
     8.317   119.988     0.150
     8.638   124.387     0.150
     8.638   268.688     0.150
     8.715   127.789     0.150
    12.229   173.887     0.150
    12.291   174.188     0.150
    17.616   254.688     0.150
    17.663   243.586     0.150
    18.826   261.688     0.150
    20.763   281.688     0.150
    21.720   290.688     0.150
    22.850   303.688     0.150
    25.425   325.688     0.150
     0.463     8.764     0.150
     0.597    12.604     0.150
     0.738    13.885     0.150
     1.172    21.865     0.150
     2.239    38.615     0.150
     2.514    41.984     0.150
     3.557    54.814     0.150
     3.760    57.514     0.150
     4.920    75.314     0.150
     5.098    76.814     0.150
     5.105    77.514     0.150
     5.320    81.514     0.150
     5.734    85.814     0.150
     6.200    93.314     0.150
     7.161   104.814     0.150
     8.018   116.814     0.150
     8.394   121.314     0.150
     8.600   125.514     0.150
     8.600   270.314     0.150
    12.205   174.314     0.150
    12.199   173.914     0.150
    15.840   223.715     0.150
    16.685   239.814     0.150
    17.624   244.814     0.150
    17.627   247.314     0.150
    17.545   246.314     0.150
    18.568   257.715     0.150
    18.742   259.314     0.150
    19.821   274.314     0.150
    20.018   276.314     0.150
    20.348   278.814     0.150
    20.669   281.314     0.150
    21.020   285.314     0.150
    21.034   285.715     0.150
    21.449   290.115     0.150
    21.661   291.314     0.150
    21.604   294.314     0.150
    22.219   300.514     0.150
    22.713   304.615     0.150
    23.473   314.314     0.150
    23.631   314.314     0.150
    24.093   318.314     0.150
    25.126   322.314     0.150
    25.274   327.814     0.150
    25.368   329.814     0.150
    25.483   330.314     0.150
    25.507   330.814     0.150
    25.552   331.314     0.150
    26.566   341.314     0.150
    33.015   394.314     0.150
    38.408   440.314     0.150
    40.568   460.814     0.150
    46.341   506.314     0.150
    46.341     5.000     0.150
    46.341   604.314     0.150
    49.082   527.215     0.150
    49.558   531.314     0.150
    49.558   531.715     0.150
    51.487   545.514     0.150
    52.393   552.414     0.150
    55.419   575.314     0.150
    55.610   575.314     0.150
    58.671   601.414     0.150
    58.791   599.115     0.150
    58.791   648.914     0.150
    59.062   598.314     0.150
    59.753   605.014     0.150
    61.185   614.314     0.150
    62.310   622.314     0.150
    62.660   625.314     0.150
    63.681   631.115     0.150
    63.681  1139.615     0.150
    65.240   640.814     0.150
    67.128   654.314     0.150
    67.128   654.814     0.150
    67.281   654.314     0.150
    68.484   662.814     0.150
    68.916   665.814     0.150
    68.982   666.115     0.150
    69.205   667.014     0.150
    69.421   668.715     0.150
    69.575   669.314     0.150
    70.345   677.215     0.150
    70.694   676.414     0.150
    71.011   678.314     0.150
    72.699   687.715     0.150
    72.684   687.314     0.150
    73.658   694.314     0.150
    76.126   708.314     0.150
    76.126   709.215     0.150
    76.176   708.314     0.150
    76.176   708.814     0.150
    78.199   720.014     0.150
    78.466   721.814     0.150
    79.446   726.314     0.150
    79.446   727.115     0.150
    79.488   725.314     0.150
    81.178   736.314     0.150
    81.178   737.115     0.150
    84.751   754.814     0.150
   149.964  1189.314     0.150
     0.462     8.922     0.150
     0.592    12.434     0.150
     0.740    13.754     0.150
     1.163    21.691     0.150
     1.196    22.504     0.150
     2.249    38.504     0.150
     2.507    41.941     0.150
     3.547    54.602     0.150
     3.812    60.902     0.150
     3.764    57.504     0.150
     4.950    75.805     0.150
     5.089    76.805     0.150
     5.114    76.703     0.150
     5.741    86.402     0.150
     6.146    91.203     0.150
     6.146    91.305     0.150
     7.068   105.102     0.150
     7.151   103.703     0.150
     8.009   116.805     0.150
     8.386   121.703     0.150
     8.605   125.203     0.150
     8.761   128.602     0.150
     9.943   146.703     0.150
    12.194   173.805     0.150
    12.209   173.203     0.150
    14.752   212.602     0.150
    15.695   227.703     0.150
    15.850   223.305     0.150
    15.923   230.203     0.150
    17.552   246.203     0.150
    17.630   244.203     0.150
    17.616   247.402     0.150
    18.562   257.703     0.150
    18.751   259.203     0.150
    20.025   275.305     0.150
    20.357   277.504     0.150
    20.679   281.402     0.150
    21.027   285.504     0.150
    21.042   285.203     0.150
    21.259   287.504     0.150
    21.457   290.203     0.150
    21.668   291.305     0.150
    21.607   293.102     0.150
    22.223   299.102     0.150
    22.717   303.902     0.150
    22.767   304.203     0.150
    23.477   310.703     0.150
    24.098   315.703     0.150
    24.820   324.203     0.150
    25.134   326.504     0.150
    25.278   328.402     0.150
    25.373   329.203     0.150
    25.486   330.703     0.150
    25.510   330.902     0.150
    25.558   332.203     0.150
    26.885   344.004     0.150
    29.088   362.203     0.150
    29.203   361.203     0.150
    29.399   364.402     0.150
    31.241   378.203     0.150
    31.241   379.102     0.150
    31.241   442.203     0.150
    33.022   396.805     0.150
    33.332  1026.203     0.150
    33.655   404.203     0.150
    35.274   415.203     0.150
    35.274   741.203     0.150
    35.274   564.203     0.150
    37.608   435.703     0.150
    39.141   448.203     0.150
    40.544   457.203     0.150
    40.544   457.805     0.150
    46.340   506.203     0.150
    46.340   601.203     0.150
    49.078   526.203     0.150
    49.078   527.102     0.150
    49.552   532.203     0.150
    49.552   532.402     0.150
    51.491   545.602     0.150
    52.396   552.102     0.150
    55.614   578.203     0.150
    56.875   584.203     0.150
    56.875   584.805     0.150
    56.985   587.203     0.150
    58.429   597.203     0.150
    58.429   597.504     0.150
    58.786   599.203     0.150
    59.066   599.203     0.150
    62.311   623.203     0.150
    62.653   626.203     0.150
    62.914   626.203     0.150
    62.914   626.703     0.150
    63.678   631.504     0.150
    63.678  1219.504     0.150
    65.064   640.203     0.150
    65.237   641.102     0.150
    65.977   647.203     0.150
    66.718   651.203     0.150
    67.134   654.203     0.150
    67.286   654.402     0.150
    67.663   657.203     0.150
    68.217   661.703     0.150
    68.238   661.203     0.150
    68.921   666.203     0.150
    69.457   668.902     0.150
    69.559   669.305     0.150
    69.581   669.203     0.150
    70.363   674.402     0.150
    70.520   675.203     0.150
    71.004   678.703     0.150
    71.498   681.703     0.150
    73.133   691.203     0.150
    73.133   692.004     0.150
    75.604   706.004     0.150
    76.124   708.203     0.150
    76.124   708.902     0.150
    76.175   708.203     0.150
    76.175   708.703     0.150
    78.198   720.203     0.150
    78.198   720.305     0.150
    78.346   721.203     0.150
    78.468   722.203     0.150
    79.444   726.203     0.150
    79.444   726.805     0.150
    81.178   737.203     0.150
    82.653   745.305     0.150
    84.748   756.203     0.150
    84.887   755.203     0.150
   149.962  1190.203     0.150
     0.286     5.562     0.150
     0.647    13.312     0.150
     1.087    20.648     0.150
     1.087    36.750     0.150
     1.788    57.000     0.150
     1.839    32.828     0.150
     1.839    57.562     0.150
     2.124    37.148     0.150
     2.124    67.453     0.150
     2.604    43.289     0.150
     2.734    45.156     0.150
     3.005    48.609     0.150
     3.275    52.312     0.150
     3.554    56.672     0.150
     3.641    58.109     0.150
     3.645    57.852     0.150
     3.653    57.852     0.150
     3.703    60.750     0.150
     3.736    58.570     0.150
     3.926    62.453     0.150
     3.926   122.750     0.150
     3.967    61.578     0.150
     4.234    65.562     0.150
     4.997    75.453     0.150
     4.997   154.750     0.150
     5.062    77.250     0.150
     6.206    94.750     0.150
     7.277   105.750     0.150
     8.558   124.750     0.150
     8.832   130.750     0.150
     0.549    11.566     0.150
     1.198    20.867     0.150
     1.319    39.758     0.150
     1.645    28.266     0.150
     1.757    28.316     0.150
     1.757    54.176     0.150
     1.773    29.746     0.150
     1.773    53.727     0.150
     1.845    30.258     0.150
     1.845    55.746     0.150
     2.227    37.266     0.150
     2.453    38.879     0.150
     2.574    40.926     0.150
     2.574    73.355     0.150
     2.662    41.848     0.150
     3.206    48.957     0.150
     3.511    54.219     0.150
     3.590    54.469     0.150
     3.692    57.566     0.150
     3.693    57.176     0.150
     3.861    59.086     0.150
     3.879    59.867     0.150
     3.997    61.367     0.150
     3.997    72.066     0.150
     3.997   122.168     0.150
     4.119    62.406     0.150
     4.220    64.426     0.150
     4.260    64.418     0.150
     4.702    70.309     0.150
     4.708    70.867     0.150
     4.708   144.367     0.150
     4.840    71.586     0.150
     4.960    74.086     0.150
     5.010    74.227     0.150
     5.010    75.367     0.150
     4.987    73.066     0.150
     5.043    73.977     0.150
     5.146    76.867     0.150
     5.372    80.566     0.150
     5.413    79.309     0.150
     5.607    82.355     0.150
     5.607    81.828     0.150
     5.677    84.168     0.150
     5.677   176.969     0.150
     5.743    85.309     0.150
     6.012    88.398     0.150
     6.187    91.809     0.150
     6.209    91.488     0.150
     6.393    93.047     0.150
     6.408    94.078     0.150
     6.487    94.527     0.150
     6.476    95.258     0.150
     6.507    95.406     0.150
     6.641    96.996     0.150
     6.668    97.656     0.150
     6.669    97.926     0.150
     6.670    97.695     0.150
     6.695    98.496     0.150
     6.751    98.398     0.150
     6.797    99.547     0.150
     6.816    99.129     0.150
     6.851   100.637     0.150
     6.885   100.816     0.150
     6.990   102.188     0.150
     7.139   104.176     0.150
     7.147   104.438     0.150
     7.150   103.477     0.150
     7.162   105.336     0.150
     7.179   103.566     0.150
     7.351   106.816     0.150
     8.064   114.195     0.150
     8.650   125.508     0.150
     8.650   266.195     0.150
     0.569    11.879     0.150
     1.191    20.879     0.150
     1.293    39.988     0.150
     1.665    28.879     0.150
     1.665    51.277     0.150
     1.733    28.410     0.150
     1.733    53.449     0.150
     1.756    29.957     0.150
     1.825    30.480     0.150
     1.825    55.570     0.150
     2.230    37.801     0.150
     2.437    39.090     0.150
     2.437    72.457     0.150
     2.524    39.578     0.150
     2.550    41.090     0.150
     2.550    74.117     0.150
     2.646    41.777     0.150
     3.190    48.957     0.150
     3.489    54.070     0.150
     3.489    97.188     0.150
     3.573    54.578     0.150
     3.570    54.449     0.150
     3.570    99.129     0.150
     3.721    56.398     0.150
     3.721   116.207     0.150
     3.836    58.957     0.150
     3.855    59.879     0.150
     3.972    61.379     0.150
     3.972   121.879     0.150
     4.092    62.148     0.150
     4.192    64.148     0.150
     4.238    64.277     0.150
     4.680    70.309     0.150
     4.729    71.180     0.150
     4.729   146.277     0.150
     4.823    71.438     0.150
     4.939    74.020     0.150
     4.971    73.188     0.150
     4.990    74.219     0.150
     4.990    75.660     0.150
     5.029    74.379     0.150
     5.127    77.078     0.150
     5.351    80.578     0.150
     5.397    79.160     0.150
     5.582    82.277     0.150
     5.580    83.707     0.150
     5.723    85.438     0.150
     5.699    84.680     0.150
     5.699   176.078     0.150
     6.000    88.418     0.150
     6.120    89.070     0.150
     6.181    91.918     0.150
     6.162    91.391     0.150
     6.188    91.570     0.150
     6.189    91.270     0.150
     6.375    92.328     0.150
     6.389    94.668     0.150
     6.417    94.020     0.150
     6.458    94.180     0.150
     6.476    94.660     0.150
     6.462    95.777     0.150
     6.488    94.488     0.150
     6.614    96.559     0.150
     6.625    96.930     0.150
     6.652    97.328     0.150
     6.654    98.000     0.150
     6.654    98.160     0.150
     6.679    98.367     0.150
     6.735    98.688     0.150
     6.783    99.410     0.150
     6.807    99.258     0.150
     6.836   100.160     0.150
     6.871   100.789     0.150
     6.977   102.598     0.150
     7.130   106.250     0.150
     7.136   105.730     0.150
     7.173   103.559     0.150
     7.340   107.000     0.150
     7.625   110.391     0.150
     8.046   115.008     0.150
     8.428   120.250     0.150
     0.425     8.594     0.150
     0.425    14.859     0.150
     0.439     8.633     0.150
     0.439    14.648     0.150
     0.709    13.234     0.150
     0.709    22.992     0.150
     1.188    21.625     0.150
     1.188    37.922     0.150
     1.194    22.250     0.150
     1.284    22.594     0.150
     1.284    40.398     0.150
     1.672    29.320     0.150
     1.672    51.523     0.150
     1.672    53.820     0.150
     1.724    29.719     0.150
     1.724    53.328     0.150
     1.750    30.711     0.150
     1.750    54.359     0.150
     1.818    31.852     0.150
     1.818    56.898     0.150
     2.433    40.039     0.150
     2.541    42.070     0.150
     2.641    43.242     0.150
     3.184    50.555     0.150
     3.481    55.250     0.150
     3.564    56.523     0.150
     3.846    60.922     0.150
     3.962   122.922     0.150
     4.736    72.320     0.150
     4.736   147.422     0.150
     5.707   178.320     0.150
     0.289     5.808     0.150
     0.289     9.718     0.150
     0.335     7.118     0.150
     0.335    12.168     0.150
     0.589    11.018     0.150
     0.754    15.388     0.150
     1.213    23.418     0.150
     1.213    39.618     0.150
     1.548    26.978     0.150
     1.548    48.168     0.150
     1.592    28.998     0.150
     1.836    32.618     0.150
     1.836    56.118     0.150
     2.401    40.988     0.150
     2.401    71.238     0.150
     2.365    39.518     0.150
     2.365    69.398     0.150
     3.042    48.288     0.150
     3.313    53.408     0.150
     3.313    93.328     0.150
     3.411    53.588     0.150
     3.405    53.008     0.150
     3.416    54.678     0.150
     3.416    95.748     0.150
     3.496    55.448     0.150
     3.841    61.338     0.150
     4.098    63.408     0.150
     4.467    68.908     0.150
     4.506    69.528     0.150
     4.895    73.578     0.150
     5.554    84.478     0.150
     0.239     5.582     0.150
     0.270     5.883     0.150
     0.459     9.984     0.150
     1.234    22.652     0.150
     1.367    24.781     0.150
     1.367    41.184     0.150
     1.446    25.582     0.150
     1.506    26.184     0.150
     1.506    47.684     0.150
     1.676    50.781     0.150
     1.861    56.883     0.150
     1.919    32.082     0.150
     2.009    34.281     0.150
     2.009    59.684     0.150
     2.263    37.281     0.150
     2.263    65.555     0.150
     2.263    37.082     0.150
     2.585    42.281     0.150
     2.643    43.281     0.150
     2.752    44.281     0.150
     2.795    45.781     0.150
     3.072    48.621     0.150
     3.404    52.555     0.150
     3.502    56.281     0.150
     3.678    56.684     0.150
     3.731    59.383     0.150
     3.747    58.484     0.150
     3.832    59.281     0.150
     4.057    62.281     0.150
     4.170    63.434     0.150
     4.647    70.383     0.150
     4.868    73.734     0.150
     4.930    75.332     0.150
     5.169    76.793     0.150
     6.055   203.281     0.150
    17.798   250.984     0.150
     0.216     4.660     0.150
     0.216     7.559     0.150
     0.509     9.758     0.150
     0.620    12.859     0.150
     1.095    20.859     0.150
     1.095    36.258     0.150
     1.177    21.059     0.150
     1.223    22.801     0.150
     1.223    39.660     0.150
     1.454    27.160     0.150
     1.617    28.160     0.150
     1.626    29.559     0.150
     1.626    52.258     0.150
     1.651    29.961     0.150
     1.651    52.961     0.150
     1.713    30.258     0.150
     1.713    53.359     0.150
     1.776    32.059     0.150
     2.338    39.559     0.150
     2.386    40.379     0.150
     2.386    71.328     0.150
     2.434    41.160     0.150
     2.545    42.461     0.150
     2.816    46.160     0.150
     3.093    49.809     0.150
     3.375    54.559     0.150
     3.460    56.160     0.150
     3.550    55.879     0.150
     3.739    60.160     0.150
     3.780    59.309     0.150
     3.833    58.480     0.150
     3.914    62.328     0.150
     3.914   107.828     0.150
     4.152    65.059     0.150
     4.381    67.711     0.150
     4.567    69.438     0.150
     4.827    72.871     0.150
     4.842    74.160     0.150
     4.842   131.059     0.150
     4.842   150.758     0.150
     4.870    73.090     0.150
     5.196    78.230     0.150
     5.726    84.711     0.150
     5.726    84.730     0.150
     6.078    89.148     0.150
     7.609   112.410     0.150
     8.664   124.391     0.150
     0.293     5.992     0.150
     0.293     9.891     0.150
     0.357    11.492     0.150
     0.547    11.289     0.150
     0.615    12.094     0.150
     1.039    20.289     0.150
     1.039    34.789     0.150
     1.399    26.094     0.150
     1.399    45.195     0.150
     1.500    26.891     0.150
     1.500    47.391     0.150
     1.953    34.094     0.150
     1.942    32.789     0.150
     1.942    59.195     0.150
     2.627    43.695     0.150
     2.759    45.391     0.150
     2.837    46.992     0.150
     3.384    54.195     0.150
     3.524    58.016     0.150
     3.697    58.492     0.150
     3.742    59.789     0.150
     3.768    59.094     0.150
     3.774    58.695     0.150
     4.064    63.789     0.150
     4.086    64.195     0.150
     4.418    67.195     0.150
     4.463    70.492     0.150
     4.684    71.195     0.150
     4.838    74.094     0.150
     5.162    77.695     0.150
     5.195   149.234     0.150
     5.213    77.992     0.150
     5.588    83.891     0.150
     5.926    91.094     0.150
     5.942    89.992     0.150
     6.175    92.289     0.150
     6.371    95.594     0.150
     0.312     5.969     0.150
     0.328    11.375     0.150
     0.740    25.969     0.150
     1.027    35.359     0.150
     1.192    23.148     0.150
     1.219    23.148     0.150
     1.219    40.016     0.150
     1.408    26.766     0.150
     1.573    29.375     0.150
     1.573    51.070     0.150
     1.582    29.531     0.150
     1.582    51.633     0.150
     2.276    39.102     0.150
     2.276    68.641     0.150
     2.391    40.969     0.150
     2.416    74.055     0.150
     2.749    45.469     0.150
     3.019    48.719     0.150
     3.389    54.953     0.150
     3.641    58.570     0.150
     3.942    61.102     0.150
     3.819   105.023     0.150
     4.794    74.859     0.150
     4.941    75.969     0.150
     5.156    80.070     0.150
     5.274    80.125     0.150
     5.274   165.719     0.150
     7.103   104.773     0.150
     8.223   120.273     0.150
     0.291     6.197     0.150
     0.291    10.516     0.150
     0.360     7.637     0.150
     0.360    12.996     0.150
     0.585    11.156     0.150
     0.695    14.146     0.150
     1.121    20.947     0.150
     1.189    22.277     0.150
     1.569    26.996     0.150
     1.630    29.287     0.150
     1.679    29.377     0.150
     2.323    38.926     0.150
     2.386    39.896     0.150
     2.376    39.826     0.150
     2.376    69.977     0.150
     2.434    40.176     0.150
     2.530    41.906     0.150
     2.797    45.176     0.150
     3.018    48.086     0.150
     3.336    52.377     0.150
     3.429    54.076     0.150
     3.441    54.176     0.150
     3.520    53.777     0.150
     3.690    57.576     0.150
     3.898    58.977     0.150
     4.132    63.176     0.150
     4.491    68.877     0.150
     5.224    78.426     0.150
     5.224   164.596     0.150
     5.576    83.977     0.150
     0.284     6.180     0.150
     0.284    10.457     0.150
     0.361     7.660     0.150
     0.577    11.078     0.150
     0.577    19.918     0.150
     0.688    14.039     0.150
     1.129    20.648     0.150
     1.190    21.910     0.150
     1.577    27.867     0.150
     1.577    49.797     0.150
     1.636    29.320     0.150
     1.636    51.520     0.150
     2.373    39.277     0.150
     2.373    69.637     0.150
     2.328    39.258     0.150
     2.394    39.590     0.150
     2.394    70.000     0.150
     2.438    39.859     0.150
     2.535    41.848     0.150
     2.803    45.348     0.150
     3.343    52.559     0.150
     3.360    54.160     0.150
     3.435    54.160     0.150
     3.447    54.457     0.150
     3.527    54.359     0.150
     3.698    58.258     0.150
     3.761    58.758     0.150
     3.889    59.137     0.150
     4.090    62.660     0.150
     4.137    62.660     0.150
     4.363    65.859     0.150
     4.498    68.160     0.150
     4.536    68.340     0.150
     4.700    70.660     0.150
     4.797    71.758     0.150
     4.926    72.957     0.150
     5.218    77.109     0.150
     5.218   163.930     0.150
     5.213    79.059     0.150
     5.590    84.559     0.150
     5.853    88.559     0.150
     5.908    88.559     0.150
     6.330    93.359     0.150
     8.518   123.758     0.150
    12.167   173.059     0.150
    46.598   504.359     0.150
     0.253     5.137     0.150
     0.650    13.236     0.150
     1.226    22.736     0.150
     1.149    22.186     0.150
     1.149    38.377     0.150
     1.535    28.436     0.150
     1.676    29.836     0.150
     1.706    31.037     0.150
     1.706    55.037     0.150
     1.726    31.836     0.150
     1.782    31.836     0.150
     1.782    56.637     0.150
     2.304    39.537     0.150
     2.304    68.506     0.150
     2.416    40.836     0.150
     2.493    42.537     0.150
     3.163    50.836     0.150
     3.266    52.436     0.150
     3.440    55.537     0.150
     3.459    57.137     0.150
     3.531    56.537     0.150
     3.539    56.336     0.150
     3.581    58.537     0.150
     3.574    56.037     0.150
     3.797    61.537     0.150
     3.854    59.936     0.150
     3.898    62.936     0.150
     3.898   109.855     0.150
     3.797    58.637     0.150
     4.188    65.637     0.150
     4.188   117.037     0.150
     4.633    71.736     0.150
     4.947    77.137     0.150
     5.123    78.865     0.150
     5.123   141.379     0.150
     5.757    86.035     0.150
     6.109    94.307     0.150
     7.183   105.236     0.150
     8.014   117.537     0.150
     7.908   114.355     0.150
     8.378   122.637     0.150
     8.547   124.486     0.150
     8.547   222.086     0.150
     8.547   270.311     0.150
    12.110   172.885     0.150
    12.110   312.135     0.150
    17.429   247.436     0.150
    17.566   248.949     0.150
    21.468   293.537     0.150
    21.847   295.066     0.150
    22.478   301.896     0.150
    25.157   329.035     0.150
    25.540   332.260     0.150
    26.281   338.236     0.150
    37.535   436.037     0.150
    59.598   605.867     0.150
    59.624   605.785     0.150
    88.638   774.486     0.150
     0.209     4.352     0.150
     0.421     8.551     0.150
     0.601    12.551     0.150
     0.854    16.852     0.150
     0.854    29.953     0.150
     1.263    22.254     0.150
     1.537    28.051     0.150
     1.706    29.652     0.150
     1.706    54.152     0.150
     1.711    30.453     0.150
     1.711    54.254     0.150
     1.804    31.551     0.150
     1.804    55.652     0.150
     2.425    40.551     0.150
     2.523    41.852     0.150
     2.523    73.453     0.150
     3.175    50.152     0.150
     3.175    97.551     0.150
     3.828    60.852     0.150
     3.754    59.254     0.150
     4.969    77.051     0.150
     5.106    77.051     0.150
     5.106   158.328     0.150
     5.331    81.754     0.150
     5.802    87.504     0.150
     5.802   183.652     0.150
     6.153    92.961     0.150
     6.153   196.152     0.150
     7.173   104.152     0.150
     7.203   105.152     0.150
     8.404   122.051     0.150
     8.596   124.926     0.150
    12.126   172.402     0.150
    17.535   247.715     0.150
    25.499   331.176     0.150
    48.121   521.527     0.150
     0.175     3.650     0.150
     0.330     5.922     0.150
     0.493    10.400     0.150
     1.220    22.752     0.150
     1.220    40.512     0.150
     1.375    25.502     0.150
     1.375    45.031     0.150
     1.785    31.662     0.150
     1.785    55.102     0.150
     1.835    32.852     0.150
     1.835    58.352     0.150
     2.296    40.301     0.150
     2.296    69.730     0.150
     2.296    38.721     0.150
     2.296    68.262     0.150
     2.652    44.551     0.150
     2.652    77.801     0.150
     2.803    46.041     0.150
     2.803    81.211     0.150
     3.306    53.842     0.150
     3.394    53.842     0.150
     3.606    55.461     0.150
     4.088    65.650     0.150
     4.088   131.832     0.150
     5.012    76.551     0.150
     5.012   156.111     0.150
     5.012    77.531     0.150
     0.258     5.285     0.150
     0.505     9.527     0.150
     0.647    13.176     0.150
     1.131    21.246     0.150
     1.131    36.895     0.150
     1.343    25.227     0.150
     1.343    43.645     0.150
     1.564    28.695     0.150
     1.707    30.574     0.150
     1.736    31.617     0.150
     1.736    54.867     0.150
     1.814    32.438     0.150
     1.814    57.938     0.150
     2.278    39.797     0.150
     2.278    67.484     0.150
     2.446    41.145     0.150
     2.524    42.445     0.150
     2.546    42.414     0.150
     2.654    43.965     0.150
     2.707    44.766     0.150
     2.707    78.324     0.150
     3.126    52.004     0.150
     3.194    51.406     0.150
     3.194    90.277     0.150
     3.298    53.375     0.150
     3.298    93.285     0.150
     3.827    61.977     0.150
     3.908    62.996     0.150
     3.908    74.527     0.150
     3.908   124.598     0.150
     3.771    57.777     0.150
     4.979    76.266     0.150
     5.123    78.676     0.150
     5.189    78.484     0.150
     5.092    77.527     0.150
     5.092   158.199     0.150
     5.341    82.477     0.150
     5.755    88.125     0.150
     5.783    86.277     0.150
     5.783   183.574     0.150
     6.136    91.824     0.150
     7.209   105.676     0.150
     7.239   105.457     0.150
     7.634   112.754     0.150
     8.410   121.824     0.150
     8.550   125.375     0.150
     8.550   160.496     0.150
     8.550   218.977     0.150
     8.550   270.926     0.150
     8.733   127.547     0.150
     8.760   129.535     0.150
    10.004   312.496     0.150
    12.081   173.137     0.150
    12.081   311.164     0.150
    12.086   173.320     0.150
    12.086   381.309     0.150
    17.535   248.262     0.150
    21.605   290.938     0.150
    21.674   295.277     0.150
    22.057   297.324     0.150
    22.448   300.145     0.150
    25.126   328.254     0.150
    25.126   328.676     0.150
    25.512   331.227     0.150
    25.933   336.875     0.150
    26.250   338.477     0.150
    53.666   562.191     0.150
    59.655   605.074     0.150
    88.668   774.426     0.150
     0.174     3.891     0.150
     0.544    11.414     0.150
     1.373    25.398     0.150
     1.373    43.047     0.150
     1.144    21.320     0.150
     1.144    37.453     0.150
     1.323    24.797     0.150
     1.323    42.711     0.150
     1.501    27.398     0.150
     1.501    47.953     0.150
     1.557    27.258     0.150
     1.557    48.547     0.150
     2.530    41.578     0.150
     2.530    78.867     0.150
     2.218    37.438     0.150
     2.302    38.078     0.150
     2.302    68.539     0.150
     2.371    39.844     0.150
     2.371    70.250     0.150
     2.428    40.523     0.150
     2.511    41.312     0.150
     2.511    73.023     0.150
     3.102    49.438     0.150
     3.293    52.594     0.150
     3.293    92.031     0.150
     3.677    58.367     0.150
     3.676    58.273     0.150
     3.994    62.672     0.150
     3.994   108.867     0.150
     3.994   126.672     0.150
     4.045    62.992     0.150
     4.739    72.219     0.150
     5.303    80.602     0.150
     5.303    96.539     0.150
     5.303   164.219     0.150
     5.303    80.727     0.150
     5.636    86.297     0.150
     8.691   273.820     0.150
     0.635    12.891     0.150
     1.235    21.684     0.150
     1.235    37.641     0.150
     2.405    39.812     0.150
     2.405    71.914     0.150
     3.059    46.594     0.150
     3.709    57.891     0.150
     3.898    60.254     0.150
     3.898    60.391     0.150
     3.898   106.164     0.150
     3.898   117.992     0.150
     3.861    59.152     0.150
     4.352    67.273     0.150
     4.849    73.531     0.150
     4.990    76.594     0.150
     5.224    78.223     0.150
     5.224   163.793     0.150
     5.224    77.992     0.150
     5.224   162.562     0.150
     5.648    85.223     0.150
     5.698    82.594     0.150
     5.698   148.480     0.150
     5.698   175.941     0.150
     6.047    89.121     0.150
     8.284   119.293     0.150
     8.573   122.902     0.150
     8.573   123.191     0.150
     8.573   218.441     0.150
     8.573   267.543     0.150
     8.573   123.594     0.150
     8.546   124.992     0.150
     8.662   126.492     0.150
    12.201   171.594     0.150
    12.201   172.594     0.150
    12.206   172.887     0.150
    12.206   381.691     0.150
    21.663   288.613     0.150
    21.663   289.723     0.150
    22.833   302.891     0.150
    25.248   325.672     0.150
    35.172   412.621     0.150
    41.113   461.922     0.150
    50.138   532.852     0.150
    88.552   771.941     0.150
     0.291     5.949     0.150
     0.291    10.352     0.150
     0.281     5.641     0.150
     0.587    11.070     0.150
     0.677    13.840     0.150
     1.008    33.180     0.150
     1.080    19.000     0.150
     1.257    23.469     0.150
     1.257    39.570     0.150
     1.519    26.488     0.150
     1.619    28.289     0.150
     1.765    30.418     0.150
     2.336    39.660     0.150
     2.447    41.449     0.150
     2.447    73.500     0.150
     3.011    49.309     0.150
     3.855    61.461     0.150
     3.855    61.730     0.150
     3.855   106.852     0.150
     3.855   119.430     0.150
     5.287    95.449     0.150
     0.472     9.203     0.150
     0.472    15.789     0.150
     0.647    12.898     0.150
     0.879    17.359     0.150
     1.152    38.703     0.150
     1.206    22.523     0.150
     1.276    22.625     0.150
     1.339    24.844     0.150
     1.562    28.141     0.150
     1.723    29.859     0.150
     1.723    53.984     0.150
     2.288    39.180     0.150
     2.288    67.641     0.150
     2.540    42.195     0.150
     2.542    41.273     0.150
     2.791    44.641     0.150
     2.791    79.789     0.150
     2.952    50.070     0.150
     3.156    50.648     0.150
     3.198    50.508     0.150
     3.307    52.500     0.150
     3.496    55.594     0.150
     3.507    56.992     0.150
     3.563    55.852     0.150
     3.572    55.930     0.150
     3.576    56.094     0.150
     3.595    55.719     0.150
     3.682    57.414     0.150
     3.746    56.398     0.150
     3.746    57.508     0.150
     3.892    60.109     0.150
     3.941    62.523     0.150
     3.941    62.625     0.150
     3.941    73.219     0.150
     3.941   109.625     0.150
     3.941   122.852     0.150
     4.072    63.312     0.150
     4.163    64.742     0.150
     4.233    65.852     0.150
     4.251    64.648     0.150
     4.471    70.164     0.150
     4.635    71.625     0.150
     4.677    71.102     0.150
     4.677    71.484     0.150
     4.937    75.211     0.150
     4.989    76.203     0.150
     5.042    75.320     0.150
     5.085    76.680     0.150
     5.085   158.555     0.150
     5.085    76.570     0.150
     5.085   158.930     0.150
     5.196    78.344     0.150
     5.351    82.375     0.150
     5.407    80.398     0.150
     5.416    83.383     0.150
     5.567    84.594     0.150
     5.727    87.000     0.150
     5.776    87.203     0.150
     5.776    87.344     0.150
     5.809    85.852     0.150
     5.809    85.703     0.150
     5.809   182.055     0.150
     5.801    85.875     0.150
     5.984    90.594     0.150
     6.149    92.148     0.150
     6.161    93.703     0.150
     6.161    93.125     0.150
     6.221    92.164     0.150
     6.249    93.391     0.150
     6.274    94.094     0.150
     6.324    91.922     0.150
     6.449    96.945     0.150
     6.623    97.164     0.150
     6.662    98.102     0.150
     6.664    98.445     0.150
     6.744    99.141     0.150
     6.795   101.242     0.150
     6.829   101.078     0.150
     6.849   101.930     0.150
     6.886   101.680     0.150
     6.992   103.773     0.150
     7.120   105.648     0.150
     7.152   106.578     0.150
     7.167   106.719     0.150
     7.229   105.281     0.150
     7.642   112.664     0.150
     7.806   114.742     0.150
     8.031   117.180     0.150
     8.099   118.281     0.150
     8.119   118.094     0.150
     8.190   119.398     0.150
     8.422   121.852     0.150
     8.412   124.250     0.150
     8.412   263.383     0.150
     8.574   125.328     0.150
     8.582   125.500     0.150
     8.582   218.953     0.150
     8.582   160.922     0.150
     8.582   269.344     0.150
     8.757   127.305     0.150
     9.321   135.383     0.150
     9.907   316.578     0.150
    10.133   147.773     0.150
    10.133   262.828     0.150
    12.095   172.805     0.150
    12.095   173.164     0.150
    12.095   376.148     0.150
    12.095   377.125     0.150
    12.100   172.445     0.150
    12.100   376.547     0.150
    14.031   198.828     0.150
    14.726   208.023     0.150
    15.244   217.070     0.150
    15.251   219.273     0.150
    15.807   223.203     0.150
    15.990   223.281     0.150
    16.169   229.414     0.150
    16.820   238.930     0.150
    16.926   240.344     0.150
    17.015   242.273     0.150
    17.244   246.258     0.150
    17.518   247.305     0.150
    17.518   246.680     0.150
    17.562   247.328     0.150
    17.645   246.953     0.150
    18.284   256.242     0.150
    18.320   255.430     0.150
    18.742   261.273     0.150
    19.302   267.914     0.150
    19.574   269.812     0.150
    19.991   274.039     0.150
    20.052   276.680     0.150
    20.210   275.711     0.150
    20.224   276.539     0.150
    20.214   276.578     0.150
    20.222   277.164     0.150
    20.632   280.805     0.150
    21.006   283.609     0.150
    21.096   287.203     0.150
    21.096   287.609     0.150
    21.096   532.828     0.150
    21.096   286.234     0.150
    21.635   291.102     0.150
    21.635   290.914     0.150
    21.635   291.305     0.150
    21.593   291.352     0.150
    21.698   293.164     0.150
    21.796   294.602     0.150
    21.796   293.734     0.150
    21.956   295.000     0.150
    21.956   294.453     0.150
    22.041   295.945     0.150
    22.205   299.102     0.150
    22.205   298.695     0.150
    22.430   299.492     0.150
    22.647   302.250     0.150
    22.719   304.102     0.150
    22.719   303.633     0.150
    22.977   306.383     0.150
    23.065   307.555     0.150
    23.206   309.344     0.150
    23.301   309.133     0.150
    23.306   311.703     0.150
    23.306   309.758     0.150
    23.529   310.773     0.150
    23.593   312.320     0.150
    23.604   312.602     0.150
    23.664   312.461     0.150
    23.807   315.031     0.150
    23.886   315.000     0.150
    23.927   315.703     0.150
    23.976   315.398     0.150
    23.977   316.289     0.150
    24.033   317.023     0.150
    24.062   318.805     0.150
    24.062   315.875     0.150
    24.099   316.789     0.150
    24.162   316.703     0.150
    24.162   577.805     0.150
    24.162   316.500     0.150
    24.227   319.602     0.150
    24.227   318.219     0.150
    24.454   319.734     0.150
    24.509   321.602     0.150
    24.509   321.164     0.150
    24.582   323.203     0.150
    24.582   321.711     0.150
    25.029   327.102     0.150
    25.029   324.539     0.150
    25.111   326.422     0.150
    25.111   326.805     0.150
    25.111   326.664     0.150
    25.193   327.805     0.150
    25.193   326.961     0.150
    25.205   326.609     0.150
    25.220   327.133     0.150
    25.489   330.625     0.150
    25.536   331.000     0.150
    25.536   330.289     0.150
    25.694   333.109     0.150
    25.799   333.000     0.150
    25.914   334.039     0.150
    26.010   334.922     0.150
    26.064   336.203     0.150
    26.064   335.312     0.150
    26.112   335.734     0.150
    26.169   336.000     0.150
    26.251   336.375     0.150
    26.251   335.453     0.150
    26.411   337.844     0.150
    26.491   338.461     0.150
    26.503   340.008     0.150
    26.659   338.852     0.150
    26.659   338.508     0.150
    27.609   348.422     0.150
    27.615   350.203     0.150
    27.615   349.273     0.150
    27.681   349.383     0.150
    27.753   351.000     0.150
    27.753   348.953     0.150
    27.770   351.000     0.150
    27.770   350.414     0.150
    28.095   352.828     0.150
    28.984   360.891     0.150
    29.173   362.711     0.150
    29.247   363.500     0.150
    29.382   364.594     0.150
    29.426   367.203     0.150
    29.426   363.711     0.150
    29.599   367.312     0.150
    29.936   369.203     0.150
    31.002   378.641     0.150
    31.945   387.055     0.150
    32.987   397.602     0.150
    32.987   397.375     0.150
    32.987   560.375     0.150
    32.987   396.562     0.150
    33.454   399.578     0.150
    33.465   399.289     0.150
    33.598   400.703     0.150
    33.598   477.500     0.150
    33.598   400.242     0.150
    33.630   403.500     0.150
    33.630   402.148     0.150
    33.697   399.203     0.150
    33.697   563.805     0.150
    33.931   404.094     0.150
    35.068   414.594     0.150
    35.716   419.828     0.150
    36.231   424.023     0.150
    36.255   424.844     0.150
    36.833   428.070     0.150
    37.155   431.398     0.150
    37.330   432.391     0.150
    37.528   435.375     0.150
    37.528   434.852     0.150
    37.784   436.289     0.150
    38.311   442.750     0.150
    39.038   447.109     0.150
    39.030   449.398     0.150
    39.030   447.508     0.150
    39.030   448.625     0.150
    39.030   577.375     0.150
    39.149   447.352     0.150
    39.647   453.500     0.150
    39.647   451.383     0.150
    39.729   453.664     0.150
    40.084   457.078     0.150
    40.277   458.219     0.150
    40.422   458.031     0.150
    40.570   459.500     0.150
    40.570   553.305     0.150
    40.570   459.391     0.150
    41.050   464.102     0.150
    41.050   463.461     0.150
    41.334   466.719     0.150
    41.601   470.250     0.150
    41.755   470.641     0.150
    41.849   471.898     0.150
    41.849   470.953     0.150
    41.972   474.039     0.150
    45.224   497.398     0.150
    45.354   498.203     0.150
    45.354   600.602     0.150
    45.354   499.000     0.150
    45.910   503.398     0.150
    45.910     7.102     0.150
    45.910   602.703     0.150
    45.910   605.602     0.150
    45.910   897.500     0.150
    48.685   521.602     0.150
    48.685   637.602     0.150
    49.101   526.500     0.150
    50.033   533.203     0.150
    50.167   535.227     0.150
    53.164   558.102     0.150
    53.164   678.203     0.150
    53.164  1014.500     0.150
    53.164  1229.305     0.150
    53.684   562.352     0.150
    55.501   576.000     0.150
    55.501   575.102     0.150
    55.501   575.602     0.150
    55.501   575.305     0.150
    55.638   576.203     0.150
    55.638   699.602     0.150
    55.638  1037.398     0.150
    56.898   585.203     0.150
    56.898   641.203     0.150
    57.033   584.703     0.150
    57.033   585.680     0.150
    57.581   590.602     0.150
    57.581   590.805     0.150
    57.581   713.102     0.150
    57.581  1069.805     0.150
    57.581   591.000     0.150
    58.042  1070.898     0.150
    58.042  1082.703     0.150
    58.228   593.648     0.150
    58.450   598.000     0.150
    58.809   599.602     0.150
    59.666   605.234     0.150
    59.910   607.320     0.150
    59.938   606.500     0.150
    60.208   608.523     0.150
    60.451   608.102     0.150
    60.777   609.602     0.150
    60.923   613.398     0.150
    61.112   615.000     0.150
    61.287   616.398     0.150
    61.287  1117.398     0.150
    62.309   622.602     0.150
    62.309   663.102     0.150
    62.309  1142.602     0.150
    62.686   625.602     0.150
    62.686  1135.102     0.150
    63.891   633.305     0.150
    63.891   667.305     0.150
    63.891   775.703     0.150
    63.891  1148.703     0.150
    63.891  1158.203     0.150
    63.891  1170.102     0.150
    63.891  1223.805     0.150
    63.891  1396.602     0.150
    64.445   636.398     0.150
    64.688   638.117     0.150
    64.711   637.703     0.150
    64.976   639.820     0.150
    65.050   640.500     0.150
    65.050   640.102     0.150
    65.254   644.602     0.150
    65.345   642.703     0.150
    65.500   643.703     0.150
    65.742   645.500     0.150
    65.953   645.898     0.150
    65.953  1180.359     0.150
    66.154   647.703     0.150
    66.271   648.500     0.150
    66.358   649.000     0.150
    66.411   649.305     0.150
    66.443   649.102     0.150
    66.570   650.203     0.150
    66.686   650.000     0.150
    66.692   650.398     0.150
    66.692     4.805     0.150
    66.702   651.102     0.150
    66.953   653.398     0.150
    67.107   653.805     0.150
    67.109   653.898     0.150
    67.187   656.898     0.150
    67.261   654.703     0.150
    67.261     4.602     0.150
    67.611   657.203     0.150
    67.638   657.305     0.150
    67.638  1199.102     0.150
    67.638   657.203     0.150
    67.644   657.203     0.150
    67.692   657.898     0.150
    67.749   657.898     0.150
    67.925   658.805     0.150
    67.925     4.000     0.150
    67.924   658.898     0.150
    67.960   659.602     0.150
    67.960     4.500     0.150
    67.960   659.602     0.150
    67.960     4.500     0.150
    68.007   659.500     0.150
    68.007   684.398     0.150
    68.007  1200.000     0.150
    68.007  1256.602     0.150
    68.021   661.000     0.150
    68.021   659.305     0.150
    68.123   660.398     0.150
    68.123     4.500     0.150
    68.213   660.805     0.150
    68.213     4.000     0.150
    68.254   661.203     0.150
    68.254   813.305     0.150
    68.254  1199.602     0.150
    68.254  1232.602     0.150
    68.379   659.305     0.150
    68.461   662.500     0.150
    68.476   662.602     0.150
    68.476   660.500     0.150
    68.544   662.203     0.150
    68.569   663.203     0.150
    68.664   663.602     0.150
    68.745   664.203     0.150
    68.769   664.805     0.150
    68.876   665.102     0.150
    68.876     4.398     0.150
    68.895   664.602     0.150
    68.895   665.602     0.150
    68.895     3.797     0.150
    68.946   665.500     0.150
    68.958   665.500     0.150
    68.969   665.602     0.150
    68.969   664.703     0.150
    69.131   665.625     0.150
    69.180   666.602     0.150
    69.193   667.000     0.150
    69.193   666.789     0.150
    69.287   667.203     0.150
    69.386   666.898     0.150
    69.396   668.000     0.150
    69.426   668.203     0.150
    69.444   667.500     0.150
    69.478   668.602     0.150
    69.478   824.602     0.150
    69.478  1213.602     0.150
    69.478  1482.602     0.150
    69.561   668.000     0.150
    69.584   670.203     0.150
    69.584   693.500     0.150
    69.584   825.500     0.150
    69.584  1216.000     0.150
    69.584  1267.500     0.150
    69.829   671.305     0.150
    69.940   671.203     0.150
    70.017   671.805     0.150
    70.074   672.805     0.150
    70.074     4.500     0.150
    70.087   671.500     0.150
    70.161   672.398     0.150
    70.206   675.305     0.150
    70.206     6.500     0.150
    70.250   673.203     0.150
    70.284   673.703     0.150
    70.284     4.398     0.150
    70.284   690.102     0.150
    70.298   674.203     0.150
    70.297   677.500     0.150
    70.319   673.102     0.150
    70.339   674.000     0.150
    70.339     5.000     0.150
    70.344   675.102     0.150
    70.378   675.000     0.150
    70.527   674.992     0.150
    70.648   675.703     0.150
    70.796   680.703     0.150
    70.812   676.703     0.150
    70.812  1229.000     0.150
    70.849   677.898     0.150
    70.985   678.898     0.150
    71.029   678.805     0.150
    71.033   679.102     0.150
    71.033   693.000     0.150
    71.033   837.602     0.150
    71.033  1233.602     0.150
    71.033  1248.602     0.150
    71.033  1508.602     0.150
    71.119   678.203     0.150
    71.117   681.750     0.150
    71.075   676.484     0.150
    71.141   679.102     0.150
    71.222   679.961     0.150
    71.241   679.203     0.150
    71.267   681.195     0.150
    71.308   679.703     0.150
    71.368   684.352     0.150
    71.441   681.305     0.150
    71.441     4.797     0.150
    71.504   684.211     0.150
    71.511   680.398     0.150
    71.534   681.898     0.150
    71.534  1241.602     0.150
    71.540   680.305     0.150
    71.565   681.719     0.150
    71.565     5.016     0.150
    71.599   682.000     0.150
    71.873   683.398     0.150
    71.866   682.805     0.150
    71.814   683.914     0.150
    71.882   683.398     0.150
    71.902   683.898     0.150
    71.902     4.805     0.150
    71.912   683.203     0.150
    71.957   683.305     0.150
    71.957     4.000     0.150
    72.015   683.102     0.150
    72.119   684.359     0.150
    72.180   685.102     0.150
    72.289   689.422     0.150
    72.297   686.398     0.150
    72.297     4.906     0.150
    72.343   685.898     0.150
    72.574   689.953     0.150
    72.690   687.758     0.150
    72.690     4.914     0.150
    72.788   687.602     0.150
    72.788     4.000     0.150
    72.788   703.602     0.150
    72.788  1248.602     0.150
    72.832   688.500     0.150
    72.847   688.602     0.150
    72.885   692.281     0.150
    72.971   689.398     0.150
    73.158   690.703     0.150
    73.196   691.203     0.150
    73.276   692.258     0.150
    73.232   693.211     0.150
    73.369   692.625     0.150
    73.319   693.672     0.150
    73.462   692.602     0.150
    73.479   693.625     0.150
    73.546   694.539     0.150
    73.546   693.672     0.150
    73.666   694.602     0.150
    73.763   695.484     0.150
    73.779   697.172     0.150
    73.777   695.703     0.150
    73.869   696.398     0.150
    73.879   696.094     0.150
    73.879   694.805     0.150
    73.872   694.703     0.150
    73.970   697.664     0.150
    74.008   696.891     0.150
    74.008   696.586     0.150
    74.037   697.078     0.150
    74.046   699.203     0.150
    74.027   696.922     0.150
    74.250   698.570     0.150
    74.255   697.789     0.150
    74.267   698.609     0.150
    74.313   698.242     0.150
    74.382   698.500     0.150
    74.428   698.203     0.150
    74.490   699.500     0.150
    74.534   700.742     0.150
    74.545   699.000     0.150
    74.557   696.102     0.150
    74.641   702.031     0.150
    74.930   701.648     0.150
    74.984   701.203     0.150
    75.019   702.102     0.150
    75.145   702.602     0.150
    75.233   703.258     0.150
    75.288   703.320     0.150
    75.388   702.305     0.150
    75.388  1277.805     0.150
    75.382   705.234     0.150
    75.463   704.461     0.150
    75.634   705.602     0.150
    75.638   707.719     0.150
    75.768   706.969     0.150
    75.887   707.625     0.150
    75.937   708.695     0.150
    76.003   708.219     0.150
    76.060   707.742     0.150
    76.143   708.445     0.150
    76.215   708.758     0.150
    76.252   709.102     0.150
    76.252     3.797     0.150
    76.252   718.602     0.150
    76.252   708.500     0.150
    76.304   707.461     0.150
    76.352   709.859     0.150
    76.474   711.102     0.150
    76.531   711.602     0.150
    76.531   723.898     0.150
    76.531  1295.305     0.150
    76.531  1317.500     0.150
    76.531  1325.102     0.150
    76.531  1333.602     0.150
    76.531  1591.203     0.150
    76.524   711.602     0.150
    76.635   710.398     0.150
    76.635   881.305     0.150
    76.635  1295.703     0.150
    76.635  1320.602     0.150
    76.635  1591.500     0.150
    76.665   710.781     0.150
    76.899   712.719     0.150
    77.032   713.602     0.150
    77.032     6.203     0.150
    77.022   713.820     0.150
    77.517   715.883     0.150
    77.681   718.602     0.150
    77.691   718.602     0.150
    77.873   717.703     0.150
    77.970   718.039     0.150
    78.008   718.148     0.150
    77.966   718.898     0.150
    78.132   718.891     0.150
    78.151   718.984     0.150
    78.397   720.828     0.150
    78.430   720.602     0.150
    78.608   718.711     0.150
    79.006   722.711     0.150
    79.120   725.602     0.150
    79.396   730.383     0.150
    80.011   730.500     0.150
    80.011   729.672     0.150
    80.326   731.352     0.150
    81.179   736.305     0.150
    81.179   922.703     0.150
    81.179  1343.805     0.150
    81.179  1351.500     0.150
    81.179  1394.602     0.150
    81.179  1663.305     0.150
    81.377   739.398     0.150
    81.377  1349.500     0.150
    81.377  1664.805     0.150
    83.349   746.203     0.150
    83.536   947.305     0.150
    83.536  1700.203     0.150
    83.750   750.102     0.150
    83.808   749.602     0.150
    83.926   751.203     0.150
    84.763   756.102     0.150
    84.894   756.305     0.150
    85.060   756.805     0.150
    85.061   756.805     0.150
    85.224   757.203     0.150
    85.283   758.000     0.150
    85.596   759.203     0.150
    86.541   762.602     0.150
    86.610   763.953     0.150
    86.756   764.914     0.150
    86.756     3.906     0.150
    86.988   765.273     0.150
    86.988   767.141     0.150
    87.244   766.750     0.150
    87.244     3.070     0.150
    87.978   770.891     0.150
    88.365   772.398     0.150
    88.686   774.648     0.150
    90.006   780.148     0.150
    90.700   783.000     0.150
    91.657   786.055     0.150
    94.976   806.180     0.150
    96.853   811.102     0.150
    96.853  1044.602     0.150
   105.254  1106.086     0.150
   135.908  1161.234     0.150
   149.291  1188.742     0.150
   149.954  1189.703     0.150
     0.435     8.836     0.150
     0.435    15.922     0.150
     0.456     8.984     0.150
     0.456    15.352     0.150
     0.629    12.875     0.150
     0.867    17.227     0.150
     1.199    22.234     0.150
     1.170    21.273     0.150
     1.170    37.633     0.150
     1.279    22.055     0.150
     1.327    24.617     0.150
     1.551    27.969     0.150
     1.722    29.148     0.150
     2.303    38.844     0.150
     2.303    67.562     0.150
     2.303    38.523     0.150
     2.303    69.625     0.150
     2.540    42.125     0.150
     2.531    41.406     0.150
     2.792    44.797     0.150
     2.792    81.305     0.150
     3.167    50.625     0.150
     3.190    50.414     0.150
     3.303    52.516     0.150
     3.503    55.719     0.150
     3.555    55.008     0.150
     3.567    55.406     0.150
     3.569    56.367     0.150
     3.582    55.125     0.150
     3.676    56.906     0.150
     3.739    57.273     0.150
     3.885    59.781     0.150
     3.957    62.422     0.150
     3.957   109.727     0.150
     3.957   122.594     0.150
     4.077    63.008     0.150
     4.171    64.219     0.150
     4.231    65.492     0.150
     4.241    64.195     0.150
     4.477    69.578     0.150
     4.674    71.477     0.150
     4.933    74.867     0.150
     4.985    75.875     0.150
     5.033    74.836     0.150
     5.091    76.547     0.150
     5.091   159.148     0.150
     5.091    76.375     0.150
     5.091    76.148     0.150
     5.398    80.312     0.150
     5.410    82.688     0.150
     5.517    82.734     0.150
     5.561    83.172     0.150
     5.779    86.523     0.150
     5.790    85.375     0.150
     5.816    85.828     0.150
     5.816    85.727     0.150
     5.816   181.828     0.150
     5.990    88.867     0.150
     6.150    91.625     0.150
     6.168    91.617     0.150
     6.243    92.781     0.150
     6.318    93.188     0.150
     6.341    93.648     0.150
     6.382    94.914     0.150
     6.450    95.516     0.150
     6.615    97.984     0.150
     6.653    97.281     0.150
     6.655    98.617     0.150
     6.736    98.398     0.150
     6.786   100.047     0.150
     6.839   100.695     0.150
     6.876   101.031     0.150
     6.981   103.852     0.150
     7.109   105.812     0.150
     7.141   106.164     0.150
     7.184   105.523     0.150
     7.111   104.508     0.150
     7.215   105.188     0.150
     7.631   112.156     0.150
     7.678   113.172     0.150
     7.635   113.172     0.150
     7.635   238.523     0.150
     7.794   114.406     0.150
     8.025   116.555     0.150
     8.087   117.531     0.150
     8.107   118.172     0.150
     8.100   118.422     0.150
     8.419   121.875     0.150
     8.423   123.648     0.150
     8.423   155.352     0.150
     8.423   260.812     0.150
     8.583   125.547     0.150
     8.601   125.297     0.150
     8.601   218.828     0.150
     8.601   270.023     0.150
     8.601   124.328     0.150
     8.601   125.492     0.150
     8.601   159.023     0.150
     8.601   271.375     0.150
     8.761   127.172     0.150
     8.788   129.172     0.150
     8.667   126.227     0.150
     9.909   316.578     0.150
    10.002   257.148     0.150
    10.128   147.523     0.150
    10.128   263.250     0.150
    10.128   319.977     0.150
    10.128   147.922     0.150
    10.128   321.234     0.150
    12.111   171.188     0.150
    12.111   172.227     0.150
    12.111   375.875     0.150
    12.111   378.125     0.150
    12.116   171.617     0.150
    12.116   377.273     0.150
    12.359   179.805     0.150
    12.359   392.172     0.150
    12.865   186.375     0.150
    13.705   198.328     0.150
    13.736   198.945     0.150
    13.736   431.172     0.150
    14.031   198.383     0.150
    13.989   205.203     0.150
    14.450   210.695     0.150
    14.498   214.977     0.150
    14.622   217.023     0.150
    14.719   215.172     0.150
    14.723   207.773     0.150
    14.723   217.047     0.150
    14.909   216.617     0.150
    14.909   465.234     0.150
    14.917   218.586     0.150
    14.967   219.648     0.150
    15.240   216.953     0.150
    15.340   224.828     0.150
    15.662   227.242     0.150
    15.662   488.797     0.150
    15.814   223.055     0.150
    15.814   223.398     0.150
    15.814   503.133     0.150
    15.976   223.062     0.150
    16.817   238.648     0.150
    16.922   241.984     0.150
    17.012   242.164     0.150
    17.519   246.078     0.150
    17.519   244.625     0.150
    17.953   252.867     0.150
    18.318   253.977     0.150
    18.323   254.547     0.150
    18.323   256.477     0.150
    18.875   263.203     0.150
    19.039   265.078     0.150
    19.992   274.188     0.150
    20.046   276.445     0.150
    20.208   275.773     0.150
    20.215   275.633     0.150
    20.225   276.398     0.150
    20.644   280.977     0.150
    21.089   287.055     0.150
    21.089   285.953     0.150
    21.332   290.297     0.150
    21.654   290.617     0.150
    21.654   291.273     0.150
    21.693   292.586     0.150
    21.792   293.688     0.150
    21.958   294.273     0.150
    21.969   296.883     0.150
    22.042   295.742     0.150
    22.198   297.984     0.150
    22.429   299.625     0.150
    22.648   301.484     0.150
    22.680   303.203     0.150
    22.734   301.734     0.150
    22.734   303.648     0.150
    23.066   306.148     0.150
    23.308   308.367     0.150
    23.307   309.969     0.150
    23.521   310.672     0.150
    23.598   311.695     0.150
    23.605   312.781     0.150
    23.658   311.906     0.150
    23.808   314.695     0.150
    23.887   315.352     0.150
    23.928   315.492     0.150
    23.978   314.852     0.150
    23.978   315.727     0.150
    24.034   316.469     0.150
    24.165   317.273     0.150
    24.165   316.586     0.150
    24.507   321.344     0.150
    25.021   325.227     0.150
    25.112   325.547     0.150
    25.112   326.828     0.150
    25.187   327.133     0.150
    25.219   326.422     0.150
    25.484   330.250     0.150
    25.531   329.867     0.150
    25.913   331.516     0.150
    26.004   333.562     0.150
    26.165   335.344     0.150
    26.261   336.875     0.150
    26.261   336.523     0.150
    26.487   338.531     0.150
    26.496   338.023     0.150
    27.607   347.555     0.150
    28.098   352.734     0.150
    29.169   363.484     0.150
    33.597   713.578     0.150
    33.627   401.227     0.150
    36.230   422.586     0.150
    37.545   434.898     0.150
    37.791   435.086     0.150
    39.030   448.672     0.150
    39.030   577.250     0.150
    40.574   459.578     0.150
    41.940   470.453     0.150
    48.683   521.375     0.150
    49.105   526.875     0.150
    53.162   557.977     0.150
    55.637   575.773     0.150
    57.051   587.047     0.150
    57.586   591.273     0.150
    57.586   590.367     0.150
    58.456   597.977     0.150
    58.814   598.977     0.150
    59.653   604.578     0.150
    59.663   604.977     0.150
    59.747   604.625     0.150
    59.913   607.836     0.150
    59.952   607.078     0.150
    60.461   607.273     0.150
    62.323   622.977     0.150
    62.686   627.078     0.150
    63.892   632.078     0.150
    63.892   665.172     0.150
    63.892  1150.172     0.150
    63.892  1157.273     0.150
    63.892  1173.977     0.150
    63.892  1222.875     0.150
    64.035   632.773     0.150
    64.699   637.461     0.150
    65.328   640.672     0.150
    68.251   661.672     0.150
    68.251   813.773     0.150
    68.251  1195.375     0.150
    68.251  1207.375     0.150
    68.251  1218.375     0.150
    69.149   665.422     0.150
    69.486   669.375     0.150
    69.486   825.375     0.150
    69.486  1215.375     0.150
    69.486  1483.375     0.150
    69.587   670.375     0.150
    69.587   693.273     0.150
    69.587   827.477     0.150
    69.587  1220.672     0.150
    69.587  1226.773     0.150
    69.587  1264.977     0.150
    69.643   670.336     0.150
    71.035   678.875     0.150
    71.035   692.672     0.150
    71.035   839.375     0.150
    73.889   695.172     0.150
    73.889   694.445     0.150
    74.028   696.484     0.150
    75.161   705.375     0.150
    76.540   711.375     0.150
    76.540  1295.375     0.150
    76.540  1318.477     0.150
    76.540  1324.977     0.150
    76.540  1333.875     0.150
    76.540  1591.375     0.150
    78.379   721.672     0.150
    80.027   732.578     0.150
    81.180   737.875     0.150
    81.180  1345.172     0.150
    81.381   739.578     0.150
    81.381   738.523     0.150
    83.934   751.172     0.150
    84.899   756.078     0.150
    85.066   756.273     0.150
    85.067   756.672     0.150
    85.229   757.078     0.150
    85.289   757.773     0.150
    85.602   758.773     0.150
    88.687   774.156     0.150
    88.687   774.727     0.150
   149.938  1189.977     0.150
     0.466     9.016     0.150
     0.466    15.742     0.150
     0.639    13.141     0.150
     0.870    17.422     0.150
     1.162    21.508     0.150
     1.162    37.570     0.150
     1.199    22.641     0.150
     1.274    22.211     0.150
     1.553    28.172     0.150
     1.719    29.367     0.150
     1.719    54.781     0.150
     1.818    31.547     0.150
     2.298    38.836     0.150
     2.298    68.609     0.150
     2.533    41.562     0.150
     2.536    42.391     0.150
     2.536    75.633     0.150
     2.795    45.008     0.150
     3.158    51.062     0.150
     3.190    50.648     0.150
     3.301    52.500     0.150
     3.555    54.992     0.150
     3.565    55.953     0.150
     3.746    59.000     0.150
     3.884    60.312     0.150
     3.947    62.609     0.150
     3.947   108.781     0.150
     3.947   124.898     0.150
     4.071    63.250     0.150
     4.228    65.672     0.150
     4.242    64.367     0.150
     4.470    69.336     0.150
     4.672    71.680     0.150
     4.931    75.391     0.150
     4.983    77.156     0.150
     5.091    76.961     0.150
     5.091   158.461     0.150
     5.091    76.500     0.150
     5.091    77.258     0.150
     5.091   157.828     0.150
     5.345    81.961     0.150
     5.399    81.086     0.150
     5.774    87.117     0.150
     5.792    86.117     0.150
     5.809    86.500     0.150
     5.809    87.062     0.150
     5.809   187.062     0.150
     6.146    92.281     0.150
     6.242    93.398     0.150
     6.446    96.391     0.150
     6.654    98.828     0.150
     6.736    99.211     0.150
     6.983   103.492     0.150
     7.219   105.297     0.150
     7.668   113.477     0.150
     8.417   122.391     0.150
     8.590   219.836     0.150
     8.590   269.938     0.150
     8.590   162.562     0.150
     8.755   126.859     0.150
    12.106   173.227     0.150
    12.106   375.961     0.150
    12.110   172.758     0.150
    12.110   381.711     0.150
    59.908   607.461     0.150
     0.487     9.262     0.150
     0.661    13.352     0.150
     0.878    17.602     0.150
     1.145    21.645     0.150
     1.145    36.312     0.150
     1.201    22.375     0.150
     1.265    22.352     0.150
     1.560    28.574     0.150
     1.560    50.465     0.150
     1.713    29.492     0.150
     2.286    39.203     0.150
     2.286    69.023     0.150
     2.286    69.984     0.150
     2.530    42.703     0.150
     2.652    43.953     0.150
     2.800    45.523     0.150
     2.800    84.004     0.150
     3.141    50.715     0.150
     3.193    51.023     0.150
     3.300    52.805     0.150
     3.483    55.793     0.150
     3.497    55.574     0.150
     3.560    55.773     0.150
     3.565    56.664     0.150
     3.571    57.164     0.150
     3.675    57.902     0.150
     3.758    59.293     0.150
     3.927    62.434     0.150
     3.927    62.863     0.150
     3.927   108.965     0.150
     3.927   123.535     0.150
     4.060    63.504     0.150
     4.149    64.395     0.150
     4.225    66.094     0.150
     4.248    65.234     0.150
     4.459    70.734     0.150
     4.628    71.922     0.150
     4.669    71.734     0.150
     4.929    75.785     0.150
     4.982    76.402     0.150
     5.090    78.539     0.150
     5.090   158.887     0.150
     5.090    78.305     0.150
     5.090   158.223     0.150
     5.190    78.762     0.150
     5.344    81.535     0.150
     5.403    81.941     0.150
     5.542    83.863     0.150
     5.662    85.672     0.150
     5.719    87.305     0.150
     5.765    87.672     0.150
     5.796    86.125     0.150
     5.796    85.613     0.150
     5.796   184.312     0.150
     5.799    86.492     0.150
     6.015    90.742     0.150
     6.139    92.375     0.150
     6.210    92.203     0.150
     6.242    94.004     0.150
     6.318    95.434     0.150
     6.439    96.074     0.150
     6.618    98.812     0.150
     6.658    99.074     0.150
     6.660    99.293     0.150
     6.740    99.883     0.150
     6.845   101.562     0.150
     6.882   102.914     0.150
     7.133   105.055     0.150
     7.231   105.652     0.150
     7.650   237.535     0.150
     7.650   113.383     0.150
     8.121   117.465     0.150
     8.211   120.191     0.150
     8.364   122.652     0.150
     8.414   125.691     0.150
     8.414   261.664     0.150
     8.414   122.465     0.150
     8.463   123.535     0.150
     8.569   125.812     0.150
     8.569   220.465     0.150
     8.569   267.062     0.150
     8.569   124.785     0.150
     8.569   125.664     0.150
     8.569   219.734     0.150
     8.561   125.113     0.150
     8.745   127.164     0.150
    10.144   148.562     0.150
    12.092   173.254     0.150
    12.092   174.363     0.150
    12.092   377.004     0.150
    12.096   172.910     0.150
    12.096   379.559     0.150
    17.528   246.555     0.150
    18.328   254.574     0.150
    21.623   290.312     0.150
    21.623   291.562     0.150
    22.050   295.125     0.150
    22.440   300.785     0.150
    22.716   302.984     0.150
    27.620   347.492     0.150
    31.011   379.332     0.150
    59.898   607.992     0.150
     0.503     9.594     0.150
     0.503    16.125     0.150
     1.144    22.219     0.150
     1.144    37.703     0.150
     1.187    23.438     0.150
     1.187    40.344     0.150
     1.245    23.195     0.150
     1.549    28.914     0.150
     1.549    50.938     0.150
     1.694    30.375     0.150
     1.800    32.688     0.150
     2.293    40.039     0.150
     2.293    69.867     0.150
     2.293    69.203     0.150
     2.293    73.180     0.150
     2.530    43.117     0.150
     2.511    43.227     0.150
     2.639    44.469     0.150
     2.819    46.539     0.150
     3.179    50.945     0.150
     3.121    51.195     0.150
     3.284    53.398     0.150
     3.779    59.938     0.150
     3.910    63.258     0.150
     3.910    63.406     0.150
     3.910   110.039     0.150
     3.910   123.773     0.150
     4.040    64.039     0.150
     4.129    65.367     0.150
     4.207    66.758     0.150
     4.652    72.438     0.150
     4.912    76.289     0.150
     5.106    91.375     0.150
     5.106   159.156     0.150
     6.119    92.656     0.150
     6.419    97.016     0.150
     7.631   114.148     0.150
     8.426   261.859     0.150
     0.673    12.729     0.150
     0.655    13.039     0.150
     0.655    23.180     0.150
     1.214    23.449     0.150
     1.214    40.639     0.150
     1.470    26.809     0.150
     1.470    47.570     0.150
     1.589    29.270     0.150
     1.589    51.100     0.150
     1.847    33.289     0.150
     1.884    33.520     0.150
     2.071    36.670     0.150
     2.295    40.459     0.150
     2.295    70.199     0.150
     2.326    39.129     0.150
     2.326    70.930     0.150
     2.575    43.270     0.150
     2.584    43.129     0.150
     2.942    49.549     0.150
     3.087    49.379     0.150
     3.165    50.990     0.150
     3.287    55.240     0.150
     3.327    53.879     0.150
     3.432    55.039     0.150
     3.745    59.070     0.150
     3.745    59.410     0.150
     3.872    61.119     0.150
     3.951    62.648     0.150
     4.072    64.000     0.150
     4.521    71.309     0.150
     4.521    69.648     0.150
     4.843    75.070     0.150
     5.067    77.760     0.150
     5.220   162.490     0.150
     5.587    85.260     0.150
     5.964    90.070     0.150
    11.011   158.389     0.150
    11.622   167.020     0.150
     0.643    13.031     0.150
     0.643    23.430     0.150
     0.875    17.289     0.150
     1.203    21.820     0.150
     1.203    38.297     0.150
     1.276    22.578     0.150
     1.722    29.453     0.150
     2.155    36.938     0.150
     2.155    63.273     0.150
     2.292    39.031     0.150
     2.292    38.883     0.150
     2.539    41.969     0.150
     2.792    44.711     0.150
     2.792    81.250     0.150
     2.696    43.852     0.150
     2.714    44.133     0.150
     2.924    47.008     0.150
     2.946    48.547     0.150
     3.305    52.461     0.150
     3.497    57.547     0.150
     3.945    62.227     0.150
     3.945   125.758     0.150
     4.072    62.320     0.150
     4.164    65.070     0.150
     4.423    68.141     0.150
     4.490    69.031     0.150
     4.732    72.109     0.150
     5.087    76.742     0.150
     5.087    91.117     0.150
     5.087   157.844     0.150
     5.087    76.430     0.150
     5.087   159.992     0.150
     4.987    76.820     0.150
     5.039    74.922     0.150
     5.257    78.570     0.150
     5.193    78.133     0.150
     5.404    80.117     0.150
     5.566    84.117     0.150
     5.723    85.844     0.150
     5.797    85.883     0.150
     5.776    87.797     0.150
     6.148    91.039     0.150
     6.162    88.922     0.150
     6.184    91.750     0.150
     6.246    91.750     0.150
     6.448    95.773     0.150
     6.723    98.891     0.150
     6.988   102.758     0.150
     7.225   105.703     0.150
     7.814   112.867     0.150
     8.107   118.227     0.150
     8.420   121.758     0.150
     8.587   125.219     0.150
     0.388     7.906     0.150
     0.388    12.797     0.150
     0.470     9.266     0.150
     0.648    13.195     0.150
     0.648    22.359     0.150
     0.820    16.258     0.150
     0.880    16.344     0.150
     0.880    29.078     0.150
     0.943    18.023     0.150
     0.943    30.742     0.150
     1.021    18.297     0.150
     1.021    32.312     0.150
     1.231    22.586     0.150
     1.231    39.727     0.150
     1.235    22.367     0.150
     1.235    39.375     0.150
     1.232    23.039     0.150
     1.232    40.883     0.150
     1.344    24.492     0.150
     1.344    45.469     0.150
     1.418    25.617     0.150
     1.418    44.578     0.150
     1.493    27.734     0.150
     1.493    48.453     0.150
     1.719    30.539     0.150
     1.719    53.555     0.150
     1.719    53.797     0.150
     1.522    27.836     0.150
     1.522    48.758     0.150
     1.626    28.758     0.150
     1.626    50.906     0.150
     1.620    28.922     0.150
     1.620    51.156     0.150
     1.676    29.516     0.150
     1.676    53.328     0.150
     1.807    32.312     0.150
     1.807    54.859     0.150
     1.899    33.203     0.150
     1.899    58.078     0.150
     1.919    33.859     0.150
     1.919    59.109     0.150
     2.208    36.812     0.150
     2.346    39.484     0.150
     2.346    69.789     0.150
     2.117    36.359     0.150
     2.117    64.875     0.150
     2.238    38.156     0.150
     2.238    67.367     0.150
     3.140    50.805     0.150
     3.140    90.578     0.150
     3.433    54.875     0.150
     3.433    95.898     0.150
     3.946   122.977     0.150
     5.140   158.875     0.150
     0.216     5.008     0.150
     0.216     8.770     0.150
     0.216     8.328     0.150
     0.447     8.848     0.150
     0.447    16.059     0.150
     0.481    10.301     0.150
     0.481    18.258     0.150
     0.644    13.340     0.150
     0.758    14.199     0.150
     0.758    25.410     0.150
     0.795    15.168     0.150
     0.795    27.008     0.150
     0.968    17.918     0.150
     0.968    30.590     0.150
     1.066    20.199     0.150
     1.066    35.348     0.150
     1.149    21.180     0.150
     1.149    36.371     0.150
     1.176    21.250     0.150
     1.176    37.148     0.150
     1.176    21.078     0.150
     1.206    21.520     0.150
     1.271    22.438     0.150
     1.352    23.938     0.150
     1.352    41.590     0.150
     1.362    23.500     0.150
     1.371    24.918     0.150
     1.371    45.289     0.150
     1.389    25.211     0.150
     1.389    43.438     0.150
     1.521    28.070     0.150
     1.453    26.891     0.150
     1.453    45.777     0.150
     1.458    26.141     0.150
     1.458    46.688     0.150
     1.523    26.000     0.150
     1.584    26.961     0.150
     1.584    47.988     0.150
     1.645    28.328     0.150
     1.724    29.559     0.150
     1.730    30.859     0.150
     1.752    31.328     0.150
     1.752    55.039     0.150
     1.747    30.590     0.150
     1.757    30.711     0.150
     1.785    30.438     0.150
     1.805    32.230     0.150
     1.855    32.648     0.150
     1.855    32.801     0.150
     1.855    56.680     0.150
     1.960    33.520     0.150
     1.978    33.730     0.150
     2.057    35.059     0.150
     2.076    35.188     0.150
     2.131    36.719     0.150
     2.136    35.668     0.150
     2.418    40.879     0.150
     2.439    39.918     0.150
     2.491    40.578     0.150
     2.534    41.289     0.150
     2.534    41.410     0.150
     2.534    73.328     0.150
     2.534    79.109     0.150
     2.530    41.070     0.150
     2.986    47.199     0.150
     3.121    48.988     0.150
     3.315    52.270     0.150
     4.030    61.660     0.150
     4.030    62.551     0.150
     4.067    62.410     0.150
     4.124    62.961     0.150
     4.446    68.719     0.150
     5.289   164.578     0.150
     0.374     7.382     0.150
     0.374    13.652     0.150
     0.543    10.122     0.150
     0.770    15.132     0.150
     0.770    25.742     0.150
     0.942    18.652     0.150
     0.942    31.692     0.150
     1.185    22.542     0.150
     1.185    38.752     0.150
     1.245    24.103     0.150
     1.245    41.062     0.150
     1.614    28.393     0.150
     1.614    50.482     0.150
     1.638    30.702     0.150
     1.709    31.682     0.150
     1.709    55.032     0.150
     1.771    31.782     0.150
     1.771    55.332     0.150
     2.255    38.702     0.150
     2.255    68.872     0.150
     2.307    42.132     0.150
     2.356    40.792     0.150
     2.356    70.922     0.150
     2.612    43.112     0.150
     2.612    76.143     0.150
     3.203    52.662     0.150
     3.203    90.682     0.150
     3.876    62.292     0.150
     3.876   108.252     0.150
     3.876    61.962     0.150
     3.876   108.572     0.150
     4.571    70.722     0.150
     4.571   123.822     0.150
     4.651    70.103     0.150
     4.651   146.262     0.150
     5.095    77.712     0.150
     5.095   134.682     0.150
     5.186   161.232     0.150
     0.312     6.664     0.150
     0.312    11.454     0.150
     0.312     6.443     0.150
     0.312    11.624     0.150
     0.534    10.153     0.150
     0.534    18.113     0.150
     0.564    11.863     0.150
     0.674    13.454     0.150
     0.740    14.924     0.150
     0.831    15.384     0.150
     0.831    26.634     0.150
     0.850    16.434     0.150
     0.850    28.964     0.150
     0.995    18.584     0.150
     0.995    31.613     0.150
     1.144    21.084     0.150
     1.245    22.504     0.150
     1.245    39.094     0.150
     1.245    38.934     0.150
     1.320    23.584     0.150
     1.320    41.284     0.150
     1.299    24.034     0.150
     1.299    41.284     0.150
     1.321    24.004     0.150
     1.428    26.084     0.150
     1.530    27.304     0.150
     1.530    48.344     0.150
     1.526    26.363     0.150
     1.577    27.254     0.150
     1.577    50.284     0.150
     1.612    28.714     0.150
     1.644    29.594     0.150
     1.709    30.943     0.150
     1.817    32.324     0.150
     1.817    55.764     0.150
     1.817    31.794     0.150
     1.806    31.584     0.150
     1.806    55.403     0.150
     2.025    34.124     0.150
     2.021    35.144     0.150
     2.021    62.844     0.150
     2.042    35.074     0.150
     2.139    36.104     0.150
     2.152    35.994     0.150
     2.299    38.004     0.150
     2.312    40.813     0.150
     2.312    38.634     0.150
     2.400    38.943     0.150
     2.417    40.164     0.150
     2.417    70.693     0.150
     2.417    69.903     0.150
     2.507    40.914     0.150
     2.564    42.044     0.150
     2.564    75.363     0.150
     2.777    44.773     0.150
     3.065    48.594     0.150
     3.156    50.264     0.150
     3.156    87.374     0.150
     3.334    53.144     0.150
     3.898    60.934     0.150
     3.898   106.324     0.150
     3.941    61.144     0.150
     3.941    60.134     0.150
     3.941   120.224     0.150
     4.052    62.153     0.150
     4.083    63.184     0.150
     4.527    68.804     0.150
     4.527   122.834     0.150
     4.663    71.403     0.150
     4.663   145.914     0.150
     4.838    74.474     0.150
     4.838   140.764     0.150
     5.044    76.044     0.150
     5.236   161.994     0.150
     5.236    78.854     0.150
     6.006    88.124     0.150
     7.099   102.584     0.150
     0.250     5.203     0.150
     0.250     8.883     0.150
     0.356     7.062     0.150
     0.356     7.164     0.150
     0.356    12.264     0.150
     0.541    10.223     0.150
     0.606    12.312     0.150
     0.692    13.684     0.150
     0.692    24.963     0.150
     0.787    15.324     0.150
     0.787    26.094     0.150
     0.787    25.812     0.150
     0.888    17.053     0.150
     0.888    30.193     0.150
     0.957    18.664     0.150
     0.957    31.533     0.150
     0.957    31.424     0.150
     1.185    22.594     0.150
     1.202    22.414     0.150
     1.202    38.334     0.150
     1.202    22.633     0.150
     1.202    38.533     0.150
     1.338    25.613     0.150
     1.338    44.004     0.150
     1.260    24.273     0.150
     1.260    41.053     0.150
     1.260    41.193     0.150
     1.570    28.293     0.150
     1.570    48.713     0.150
     1.638    29.754     0.150
     1.638    30.123     0.150
     1.707    31.203     0.150
     1.785    31.533     0.150
     1.785    56.354     0.150
     1.843    32.193     0.150
     2.065    36.494     0.150
     2.106    36.014     0.150
     2.192    37.354     0.150
     2.270    38.893     0.150
     2.306    39.723     0.150
     2.306    41.514     0.150
     2.338    39.264     0.150
     2.374    40.312     0.150
     2.374    69.973     0.150
     2.912    47.033     0.150
     2.912    45.812     0.150
     2.912    80.354     0.150
     2.912    89.184     0.150
     3.063    49.062     0.150
     3.085    49.152     0.150
     3.189    50.982     0.150
     3.189    50.674     0.150
     3.189    88.854     0.150
     3.293    51.973     0.150
     3.364    53.633     0.150
     3.387    54.793     0.150
     3.485    56.393     0.150
     3.485    55.674     0.150
     3.564    55.914     0.150
     3.857    59.803     0.150
     3.881    61.344     0.150
     3.881   107.664     0.150
     3.881   125.174     0.150
     3.956    61.902     0.150
     4.058    63.863     0.150
     4.058    62.543     0.150
     4.112    63.783     0.150
     4.319    67.854     0.150
     4.516    69.383     0.150
     4.557    70.244     0.150
     4.653    71.863     0.150
     4.870    75.883     0.150
     5.201    78.584     0.150
     5.201   162.744     0.150
     5.201    78.463     0.150
     5.201    86.438     0.150
     5.448    82.402     0.150
     5.608    86.703     0.150
     5.700   108.203     0.150
     5.700   185.004     0.150
     5.700    87.863     0.150
     5.700   174.902     0.150
     5.988    89.934     0.150
     6.223   207.324     0.150
     6.326    94.834     0.150
     6.874   103.584     0.150
     7.143   103.883     0.150
     7.578   112.062     0.150
     8.470   124.883     0.150
     8.518   124.594     0.150
     8.518   267.084     0.150
     8.550   124.213     0.150
     8.550   218.793     0.150
     8.550   266.863     0.150
     8.550   123.973     0.150
    11.205   160.902     0.150
    12.168   172.354     0.150
    12.173   173.209     0.150
    12.173   381.012     0.150
    12.173   173.104     0.150
    21.634   289.713     0.150
     0.567    10.652     0.150
     0.567    17.742     0.150
     0.549    10.742     0.150
     0.549    18.293     0.150
     0.549    18.184     0.150
     0.605    12.242     0.150
     0.605    21.014     0.150
     0.605    20.883     0.150
     0.754    15.143     0.150
     0.829    16.732     0.150
     0.829    28.322     0.150
     0.978    19.523     0.150
     0.996    17.752     0.150
     0.996    33.793     0.150
     1.029    19.594     0.150
     1.029    34.162     0.150
     1.078    21.113     0.150
     1.078    20.844     0.150
     1.078    35.873     0.150
     1.081    19.482     0.150
     1.122    22.002     0.150
     1.122    37.434     0.150
     1.256    24.514     0.150
     1.281    24.572     0.150
     1.294    23.703     0.150
     1.379    26.213     0.150
     1.379    44.514     0.150
     1.369    44.473     0.150
     1.467    27.123     0.150
     1.479    26.643     0.150
     1.609    28.482     0.150
     1.620    29.633     0.150
     1.620    50.992     0.150
     1.654    30.672     0.150
     1.676    31.354     0.150
     1.676    54.252     0.150
     1.676    31.152     0.150
     1.716    30.662     0.150
     1.716    55.223     0.150
     1.763    32.094     0.150
     1.757    31.373     0.150
     1.757    54.953     0.150
     1.764    33.143     0.150
     1.764    56.223     0.150
     1.764    32.973     0.150
     1.823    33.053     0.150
     1.880    33.492     0.150
     1.879    33.502     0.150
     1.879    59.232     0.150
     2.027    36.062     0.150
     2.042    37.533     0.150
     2.094    37.133     0.150
     2.180    37.982     0.150
     2.180    68.223     0.150
     2.211    39.793     0.150
     2.253    39.633     0.150
     2.300    39.613     0.150
     2.325    40.213     0.150
     2.342    40.123     0.150
     2.384    41.104     0.150
     2.529    43.322     0.150
     2.572    44.223     0.150
     2.736    45.684     0.150
     2.762    45.223     0.150
     2.762    85.613     0.150
     2.762    50.422     0.150
     2.772    46.053     0.150
     3.147    51.562     0.150
     3.110    52.002     0.150
     3.110    52.943     0.150
     3.531    57.572     0.150
     3.646    58.863     0.150
     3.858    61.973     0.150
     3.858   105.902     0.150
     3.858    62.373     0.150
     3.959    63.383     0.150
     4.137    64.963     0.150
     4.137    66.332     0.150
     4.276    67.713     0.150
     4.661    72.523     0.150
     4.987    77.453     0.150
     5.022   157.223     0.150
     5.022    76.863     0.150
     0.291     5.518     0.150
     0.291     9.246     0.150
     0.351     7.336     0.150
     0.351    11.916     0.150
     0.351    12.227     0.150
     0.592    21.637     0.150
     0.587    11.217     0.150
     0.734    26.066     0.150
     0.771    15.586     0.150
     0.789    15.256     0.150
     0.863    16.967     0.150
     0.863    30.207     0.150
     0.899    16.848     0.150
     0.899    28.348     0.150
     0.937    31.098     0.150
     0.937    19.217     0.150
     1.066    21.637     0.150
     1.066    36.797     0.150
     1.114    20.586     0.150
     1.114    21.777     0.150
     1.165    22.848     0.150
     1.165    22.996     0.150
     1.165    21.307     0.150
     1.198    23.486     0.150
     1.198    39.486     0.150
     1.198    23.676     0.150
     1.243    25.107     0.150
     1.243    41.486     0.150
     1.243    24.496     0.150
     1.297    23.797     0.150
     1.397    26.586     0.150
     1.438    27.396     0.150
     1.515    27.076     0.150
     1.515    48.896     0.150
     1.515    27.377     0.150
     1.547    28.768     0.150
     1.547    50.117     0.150
     1.562    27.777     0.150
     1.562    49.537     0.150
     1.609    29.857     0.150
     1.609    53.098     0.150
     1.621    30.377     0.150
     1.592    30.787     0.150
     1.592    51.986     0.150
     1.670    30.416     0.150
     1.670    52.986     0.150
     1.660    52.707     0.150
     1.690    30.537     0.150
     1.690    53.797     0.150
     1.690    30.416     0.150
     1.690    54.617     0.150
     1.816    33.377     0.150
     1.816    57.566     0.150
     1.845    33.566     0.150
     1.822    32.977     0.150
     1.822    57.768     0.150
     1.822    33.887     0.150
     1.822    57.896     0.150
     2.037    36.637     0.150
     2.037    63.697     0.150
     2.023    36.396     0.150
     2.127    37.646     0.150
     2.127    66.777     0.150
     2.169    38.307     0.150
     2.260    42.727     0.150
     2.314    40.146     0.150
     2.303    70.527     0.150
     2.303    40.438     0.150
     2.379    42.447     0.150
     2.379    72.467     0.150
     2.385    41.486     0.150
     2.385    71.246     0.150
     2.385    74.256     0.150
     2.520    43.496     0.150
     2.564    43.756     0.150
     2.952    48.496     0.150
     3.016    50.377     0.150
     3.016    49.996     0.150
     3.327    54.826     0.150
     3.327    94.777     0.150
     3.334    55.518     0.150
     3.340    54.098     0.150
     5.233   163.586     0.150
     0.431     8.086     0.150
     0.418     8.273     0.150
     0.681    13.926     0.150
     0.772    15.535     0.150
     0.772    26.254     0.150
     0.982    18.656     0.150
     0.982    32.055     0.150
     0.997    19.945     0.150
     0.997    32.695     0.150
     1.070    19.496     0.150
     1.070    34.516     0.150
     1.198    23.023     0.150
     1.198    39.184     0.150
     1.267    23.637     0.150
     1.267    41.434     0.150
     1.284    23.184     0.150
     1.284    41.094     0.150
     1.292    25.184     0.150
     1.292    41.305     0.150
     1.320    23.605     0.150
     1.408    27.453     0.150
     1.675    30.195     0.150
     1.675    51.945     0.150
     1.672    29.996     0.150
     1.672    53.676     0.150
     1.723    30.504     0.150
     1.723    54.805     0.150
     1.758    32.266     0.150
     1.758    57.266     0.150
     1.831    33.324     0.150
     1.831    59.016     0.150
     1.855    33.016     0.150
     1.855    58.996     0.150
     2.325    40.035     0.150
     2.325    68.953     0.150
     2.792    85.547     0.150
     3.982    63.055     0.150
     5.100   160.137     0.150
     0.237     5.047     0.150
     0.237     8.766     0.150
     0.325     6.688     0.150
     0.325    11.781     0.150
     0.325     6.875     0.150
     0.576    11.898     0.150
     0.576    21.445     0.150
     0.576    12.117     0.150
     0.537    10.266     0.150
     0.537    17.633     0.150
     0.680    12.758     0.150
     0.680    24.633     0.150
     0.752    15.156     0.150
     0.791    14.438     0.150
     0.791    26.883     0.150
     0.791    14.617     0.150
     0.818    15.672     0.150
     0.818    26.852     0.150
     0.860    16.703     0.150
     0.860    29.242     0.150
     0.983    18.844     0.150
     0.983    32.305     0.150
     1.065    20.352     0.150
     1.065    34.531     0.150
     1.156    21.625     0.150
     1.156    38.031     0.150
     1.182    20.828     0.150
     1.182    36.734     0.150
     1.182    36.945     0.150
     1.232    22.781     0.150
     1.232    39.195     0.150
     1.232    22.602     0.150
     1.232    38.977     0.150
     1.359    25.719     0.150
     1.288    24.578     0.150
     1.288    41.227     0.150
     1.326    23.922     0.150
     1.405    24.938     0.150
     1.534    26.766     0.150
     1.534    47.883     0.150
     1.534    27.117     0.150
     1.541    27.773     0.150
     1.583    27.445     0.150
     1.583    48.914     0.150
     1.641    29.914     0.150
     1.641    52.945     0.150
     1.641    30.031     0.150
     1.622    28.906     0.150
     1.707    30.984     0.150
     1.681    29.625     0.150
     1.681    52.102     0.150
     1.714    30.195     0.150
     1.714    54.266     0.150
     1.816    31.938     0.150
     1.840    32.133     0.150
     2.048    34.844     0.150
     2.076    35.516     0.150
     2.146    36.656     0.150
     2.163    36.883     0.150
     2.310    38.516     0.150
     2.310    68.008     0.150
     2.400    40.117     0.150
     2.405    40.258     0.150
     2.405    70.766     0.150
     2.405    40.477     0.150
     2.573    42.008     0.150
     2.811    46.406     0.150
     2.931    46.406     0.150
     2.931    47.531     0.150
     3.063    48.703     0.150
     3.063    49.195     0.150
     3.066    48.117     0.150
     3.058    48.133     0.150
     3.164    50.703     0.150
     3.164    50.469     0.150
     3.342    52.695     0.150
     3.379    53.953     0.150
     3.312    51.438     0.150
     3.425    54.562     0.150
     3.435    55.562     0.150
     3.707    58.242     0.150
     3.750    59.008     0.150
     3.892    61.562     0.150
     3.892    61.172     0.150
     4.020    62.531     0.150
     4.053    62.547     0.150
     4.091    62.695     0.150
     4.315    65.875     0.150
     4.351    66.703     0.150
     4.492    67.492     0.150
     4.535    69.234     0.150
     4.659    70.023     0.150
     4.794    72.883     0.150
     5.054    75.953     0.150
     5.227   162.773     0.150
     5.693    84.578     0.150
     5.826    87.398     0.150
     5.885    87.797     0.150
     6.044    89.953     0.150
     6.312    93.547     0.150
     6.583    98.367     0.150
     6.605    98.273     0.150
     7.052   103.828     0.150
     7.112   103.664     0.150
     7.587   111.906     0.150
     8.281   119.984     0.150
     8.465   122.523     0.150
     0.195     3.904     0.150
     0.195     6.635     0.150
     0.412     8.342     0.150
     0.412    14.371     0.150
     0.412     8.295     0.150
     0.412    14.504     0.150
     0.454     8.504     0.150
     0.622    12.555     0.150
     0.673    13.834     0.150
     0.765    15.115     0.150
     0.765    25.615     0.150
     0.765    26.145     0.150
     0.844    16.865     0.150
     0.909    16.734     0.150
     0.909    30.475     0.150
     0.970    18.854     0.150
     0.970    32.674     0.150
     0.982    19.375     0.150
     0.982    32.844     0.150
     0.982    33.055     0.150
     1.049    18.914     0.150
     1.177    22.484     0.150
     1.190    22.504     0.150
     1.190    38.635     0.150
     1.190    38.822     0.150
     1.258    23.693     0.150
     1.258    40.973     0.150
     1.264    22.615     0.150
     1.266    22.584     0.150
     1.266    41.771     0.150
     1.278    24.984     0.150
     1.278    42.555     0.150
     1.389    26.854     0.150
     1.389    45.594     0.150
     1.389    26.629     0.150
     1.303    23.164     0.150
     1.303    42.074     0.150
     1.372    24.904     0.150
     1.447    26.205     0.150
     1.522    27.805     0.150
     1.549    28.424     0.150
     1.646    29.684     0.150
     1.655    29.193     0.150
     1.655    52.545     0.150
     1.702    30.785     0.150
     1.705    29.834     0.150
     1.705    54.314     0.150
     1.733    31.164     0.150
     1.734    32.094     0.150
     1.734    56.135     0.150
     1.734    56.006     0.150
     1.799    31.744     0.150
     1.808    33.285     0.150
     1.808    57.914     0.150
     1.836    32.594     0.150
     1.836    57.975     0.150
     1.920    33.605     0.150
     1.920    59.871     0.150
     1.927    33.943     0.150
     1.944    33.805     0.150
     1.946    34.104     0.150
     2.108    38.805     0.150
     2.108    67.574     0.150
     2.144    37.264     0.150
     2.169    38.273     0.150
     2.169    38.004     0.150
     2.169    68.818     0.150
     2.175    37.135     0.150
     2.175    66.234     0.150
     2.180    37.654     0.150
     2.180    66.127     0.150
     2.267    38.844     0.150
     2.267    39.104     0.150
     2.326    39.705     0.150
     2.326    70.725     0.150
     2.326    39.527     0.150
     2.326    70.059     0.150
     2.417    40.924     0.150
     2.508    42.135     0.150
     2.522    42.645     0.150
     2.537    43.584     0.150
     2.537    43.129     0.150
     2.537    79.549     0.150
     2.625    44.795     0.150
     2.670    44.094     0.150
     2.691    44.514     0.150
     2.691    44.309     0.150
     2.691    78.947     0.150
     2.810    45.875     0.150
     2.863    47.125     0.150
     2.932    48.754     0.150
     2.932    48.467     0.150
     3.162    51.805     0.150
     3.162    52.504     0.150
     3.168    50.744     0.150
     3.165    51.773     0.150
     3.165    51.322     0.150
     3.190    51.635     0.150
     3.282    52.494     0.150
     3.462    55.865     0.150
     3.462    55.377     0.150
     3.463    56.064     0.150
     3.463    55.559     0.150
     3.532    56.354     0.150
     3.547    57.234     0.150
     3.629    58.598     0.150
     3.829    61.375     0.150
     3.829    61.215     0.150
     3.960    63.305     0.150
     3.960   109.523     0.150
     3.960    63.162     0.150
     4.063    64.824     0.150
     4.063    63.967     0.150
     4.115    64.725     0.150
     4.162    66.193     0.150
     4.211    65.854     0.150
     4.422    69.234     0.150
     4.422    69.447     0.150
     4.440    69.785     0.150
     4.609    71.574     0.150
     4.654    71.725     0.150
     4.654    71.568     0.150
     4.697    72.744     0.150
     4.697    72.580     0.150
     4.743    74.305     0.150
     4.743    73.502     0.150
     4.799    73.664     0.150
     4.799    73.373     0.150
     4.811    75.174     0.150
     4.914    75.994     0.150
     4.965    76.914     0.150
     5.144    78.930     0.150
     5.286    80.375     0.150
     5.550    85.354     0.150
     6.134    92.045     0.150
     6.222    93.273     0.150
     6.433    96.055     0.150
     6.848   101.805     0.150
     7.192   106.334     0.150
     7.344   108.125     0.150
     7.663   112.404     0.150
     7.674   113.023     0.150
     7.738   113.604     0.150
     7.992   118.344     0.150
     0.379     6.963     0.150
     0.379    12.652     0.150
     0.394     7.832     0.150
     0.659    13.412     0.150
     0.826    16.152     0.150
     0.921    17.822     0.150
     0.968    18.973     0.150
     1.058    20.742     0.150
     1.058    35.662     0.150
     1.089    20.621     0.150
     1.245    23.562     0.150
     1.254    24.441     0.150
     1.254    41.861     0.150
     1.253    24.271     0.150
     1.253    41.871     0.150
     1.303    24.701     0.150
     1.303    42.742     0.150
     1.324    24.223     0.150
     1.352    26.592     0.150
     1.352    45.861     0.150
     1.469    28.402     0.150
     1.677    30.102     0.150
     1.677    54.572     0.150
     1.732    30.902     0.150
     1.732    55.682     0.150
     1.803    33.553     0.150
     1.803    59.133     0.150
     1.867    33.982     0.150
     1.867    58.902     0.150
     1.872    34.922     0.150
     1.872    59.473     0.150
     2.177    41.482     0.150
     2.367    40.922     0.150
     2.367    71.352     0.150
     5.113   158.832     0.150
     0.432     7.922     0.150
     0.432    13.082     0.150
     0.434     8.553     0.150
     0.697    14.182     0.150
     0.759    15.283     0.150
     0.759    25.303     0.150
     0.938    17.793     0.150
     0.938    31.043     0.150
     0.997    19.123     0.150
     0.997    32.463     0.150
     0.988    19.752     0.150
     0.988    32.682     0.150
     1.081    20.023     0.150
     1.081    35.172     0.150
     1.185    22.953     0.150
     1.185    39.533     0.150
     1.204    23.092     0.150
     1.204    38.803     0.150
     1.282    24.273     0.150
     1.295    23.713     0.150
     1.295    41.773     0.150
     1.282    25.203     0.150
     1.282    42.463     0.150
     1.403    27.412     0.150
     1.403    46.422     0.150
     1.685    30.383     0.150
     1.685    53.312     0.150
     1.735    31.172     0.150
     1.735    55.033     0.150
     1.761    33.172     0.150
     1.761    56.322     0.150
     1.836    34.242     0.150
     1.836    58.213     0.150
     1.867    34.332     0.150
     1.867    59.143     0.150
     2.310    40.242     0.150
     2.310    71.553     0.150
     2.429    42.623     0.150
     2.779    45.883     0.150
     3.981    63.963     0.150
     3.981   111.232     0.150
     5.085   159.633     0.150
     5.627   177.172     0.150
     0.161     3.188     0.150
     0.161     5.639     0.150
     0.405     7.898     0.150
     0.405    13.508     0.150
     0.421     8.250     0.150
     0.421    14.600     0.150
     0.421     8.309     0.150
     0.421    14.598     0.150
     0.576    10.607     0.150
     0.685    14.158     0.150
     0.685    24.768     0.150
     0.786    15.197     0.150
     0.786    26.889     0.150
     0.786    26.598     0.150
     0.935    17.018     0.150
     0.935    17.338     0.150
     0.935    31.479     0.150
     1.018    19.639     0.150
     1.018    33.809     0.150
     1.197    22.658     0.150
     1.213    22.447     0.150
     1.213    38.947     0.150
     1.213    23.049     0.150
     1.213    40.092     0.150
     1.228    22.719     0.150
     1.228    39.508     0.150
     1.271    23.918     0.150
     1.271    41.576     0.150
     1.312    24.969     0.150
     1.312    42.568     0.150
     1.433    27.238     0.150
     1.433    46.197     0.150
     1.395    26.129     0.150
     1.486    26.598     0.150
     1.547    27.928     0.150
     1.687    29.908     0.150
     1.687    53.438     0.150
     1.687    30.107     0.150
     1.687    53.299     0.150
     1.739    30.738     0.150
     1.739    30.498     0.150
     1.739    55.367     0.150
     1.753    31.629     0.150
     1.783    32.408     0.150
     1.856    33.588     0.150
     1.856    59.027     0.150
     1.856    33.738     0.150
     1.945    34.318     0.150
     1.960    35.338     0.150
     2.159    37.729     0.150
     2.159    37.842     0.150
     2.300    39.299     0.150
     2.432    41.578     0.150
     2.451    42.488     0.150
     2.556    43.037     0.150
     2.584    44.629     0.150
     2.716    45.258     0.150
     2.778    45.658     0.150
     2.778    45.238     0.150
     2.778    85.578     0.150
     2.814    47.719     0.150
     2.907    47.838     0.150
     2.966    49.209     0.150
     2.966    48.988     0.150
     3.157    50.598     0.150
     3.210    51.768     0.150
     3.210    51.688     0.150
     3.214    52.139     0.150
     3.242    53.418     0.150
     3.305    52.818     0.150
     3.307    53.328     0.150
     3.492    55.008     0.150
     3.509    56.648     0.150
     3.509    56.219     0.150
     3.567    57.287     0.150
     3.652    58.857     0.150
     3.652   113.799     0.150
     3.863    62.008     0.150
     3.911    64.148     0.150
     4.008    63.588     0.150
     4.008   111.678     0.150
     4.008    63.871     0.150
     4.208    67.277     0.150
     4.208    67.078     0.150
     4.469    69.768     0.150
     4.469    70.295     0.150
     4.485    68.178     0.150
     4.484    69.549     0.150
     4.634    70.299     0.150
     4.684    72.828     0.150
     4.684   126.867     0.150
     4.684   147.027     0.150
     4.683    72.238     0.150
     4.732    73.107     0.150
     4.792    72.617     0.150
     4.850    73.738     0.150
     5.091    76.674     0.150
     5.091   159.424     0.150
     5.091    76.498     0.150
     5.091    77.328     0.150
     5.189    78.178     0.150
     5.318   167.428     0.150
     5.594    82.998     0.150
     5.851    87.498     0.150
     5.851   183.148     0.150
     5.851    86.508     0.150
     7.190   104.768     0.150
     7.190   185.092     0.150
     7.190   105.379     0.150
     7.695   112.818     0.150
     7.723   114.508     0.150
     7.729   113.857     0.150
     7.764   114.848     0.150
     8.653   127.322     0.150
    12.148   172.998     0.150
    12.148   380.674     0.150
    25.455   330.426     0.150
    68.196   660.537     0.150
     0.425     8.551     0.150
     0.425    14.090     0.150
     0.540    10.238     0.150
     0.677    13.629     0.150
     0.677    21.980     0.150
     0.721    14.758     0.150
     0.721    24.410     0.150
     0.881    16.301     0.150
     0.881    28.758     0.150
     0.910    18.461     0.150
     0.910    30.270     0.150
     0.993    18.199     0.150
     1.139    22.168     0.150
     1.139    36.691     0.150
     1.207    22.719     0.150
     1.256    23.770     0.150
     1.256    40.559     0.150
     1.241    23.250     0.150
     1.210    23.980     0.150
     1.210    40.039     0.150
     1.307    25.660     0.150
     1.264    23.520     0.150
     1.613    29.211     0.150
     1.613    51.059     0.150
     1.658    29.871     0.150
     1.658    52.629     0.150
     1.652    30.621     0.150
     1.652    53.211     0.150
     1.724    30.859     0.150
     1.724    53.738     0.150
     1.704    32.520     0.150
     1.728    32.121     0.150
     1.786    32.391     0.150
     1.786    56.480     0.150
     2.203    38.461     0.150
     2.203    66.598     0.150
     2.304    39.770     0.150
     2.304    70.020     0.150
     2.320    42.918     0.150
     2.697    50.809     0.150
     2.697    86.398     0.150
     2.948    53.301     0.150
     3.304    60.520     0.150
     3.304   103.258     0.150
     3.874    61.578     0.150
     3.874   107.719     0.150
     5.135    77.449     0.150
     0.218     4.699     0.150
     0.218     8.070     0.150
     0.372     7.812     0.150
     0.372    12.949     0.150
     0.372     7.668     0.150
     0.372    13.188     0.150
     0.372     7.801     0.150
     0.494     9.508     0.150
     0.494    16.891     0.150
     0.494     9.613     0.150
     0.494    16.207     0.150
     0.501     9.668     0.150
     0.501    17.359     0.150
     0.501    16.105     0.150
     0.629    13.020     0.150
     0.629    23.160     0.150
     0.658    13.238     0.150
     0.658    23.848     0.150
     0.693    12.930     0.150
     0.693    22.695     0.150
     0.804    16.117     0.150
     0.781    15.109     0.150
     0.781    25.738     0.150
     0.852    15.449     0.150
     0.852    27.188     0.150
     0.987    17.598     0.150
     0.987    32.430     0.150
     0.970    18.820     0.150
     0.970    31.508     0.150
     0.970    31.793     0.150
     1.048    18.648     0.150
     1.048    18.840     0.150
     1.048    33.285     0.150
     1.124    21.379     0.150
     1.124    36.570     0.150
     1.201    21.000     0.150
     1.201    37.488     0.150
     1.201    21.258     0.150
     1.204    21.219     0.150
     1.204    38.980     0.150
     1.211    22.840     0.150
     1.211    39.773     0.150
     1.200    22.391     0.150
     1.200    22.520     0.150
     1.200    38.688     0.150
     1.200    38.461     0.150
     1.243    21.859     0.150
     1.243    39.148     0.150
     1.363    26.098     0.150
     1.363    44.309     0.150
     1.363    25.977     0.150
     1.363    44.445     0.150
     1.271    24.289     0.150
     1.271    40.988     0.150
     1.317    23.777     0.150
     1.284    23.660     0.150
     1.384    24.789     0.150
     1.384    43.051     0.150
     1.465    25.750     0.150
     1.484    27.277     0.150
     1.497    27.398     0.150
     1.497    49.508     0.150
     1.594    28.277     0.150
     1.594    49.891     0.150
     1.643    28.828     0.150
     1.643    52.039     0.150
     1.656    29.520     0.150
     1.681    30.027     0.150
     1.681    51.668     0.150
     1.680    30.660     0.150
     1.680    30.828     0.150
     1.680    53.699     0.150
     1.680    54.020     0.150
     1.742    30.500     0.150
     1.742    53.480     0.150
     1.751    32.039     0.150
     1.751    55.348     0.150
     1.774    31.180     0.150
     1.774    55.617     0.150
     1.748    30.809     0.150
     1.748    55.090     0.150
     1.765    31.918     0.150
     1.765    31.449     0.150
     1.765    55.688     0.150
     1.807    31.988     0.150
     1.807    31.879     0.150
     1.807    56.352     0.150
     1.864    32.617     0.150
     1.864    57.867     0.150
     1.875    33.078     0.150
     1.880    33.430     0.150
     1.880    33.293     0.150
     1.887    32.551     0.150
     1.887    56.938     0.150
     1.897    33.301     0.150
     2.093    35.969     0.150
     2.108    37.000     0.150
     2.108    36.594     0.150
     2.131    36.398     0.150
     2.207    37.809     0.150
     2.219    37.660     0.150
     2.235    37.391     0.150
     2.264    38.488     0.150
     2.264    38.801     0.150
     2.264    67.598     0.150
     2.264    68.066     0.150
     2.348    40.711     0.150
     2.348    39.898     0.150
     2.348    39.699     0.150
     2.344    40.609     0.150
     2.368    39.578     0.150
     2.461    41.348     0.150
     2.465    40.758     0.150
     2.465    40.625     0.150
     2.478    41.938     0.150
     2.478    41.609     0.150
     2.575    41.688     0.150
     2.618    43.078     0.150
     2.634    43.109     0.150
     2.634    43.910     0.150
     2.634    77.246     0.150
     2.755    45.668     0.150
     2.755    45.777     0.150
     2.755    87.008     0.150
     2.801    45.641     0.150
     2.871    46.629     0.150
     2.871    47.223     0.150
     2.871    83.203     0.150
     2.871    45.820     0.150
     2.871    46.051     0.150
     2.871    88.418     0.150
     2.986    47.488     0.150
     3.106    49.789     0.150
     3.106    49.629     0.150
     3.109    49.438     0.150
     3.109    49.812     0.150
     3.116    48.988     0.150
     3.116    49.516     0.150
     3.225    50.379     0.150
     3.225    51.551     0.150
     3.225    90.348     0.150
     3.219    52.301     0.150
     3.219    52.410     0.150
     3.219    91.188     0.150
     3.219   102.348     0.150
     3.251    51.000     0.150
     3.351    52.461     0.150
     3.351    52.660     0.150
     3.351    93.090     0.150
     3.351   104.730     0.150
     3.403    54.418     0.150
     3.403    54.590     0.150
     3.403    53.410     0.150
     3.403    54.098     0.150
     3.432    54.738     0.150
     3.483    53.879     0.150
     3.494    54.680     0.150
     3.528    56.082     0.150
     3.599    56.219     0.150
     3.637    57.938     0.150
     3.637    58.309     0.150
     3.637    99.641     0.150
     3.637   114.508     0.150
     3.767    59.961     0.150
     3.810    59.348     0.150
     3.810    58.980     0.150
     3.812    58.801     0.150
     3.849    61.348     0.150
     3.849   106.648     0.150
     3.917    61.961     0.150
     3.917    62.090     0.150
     3.917   105.539     0.150
     3.950    60.586     0.150
     4.001    62.301     0.150
     4.060    62.961     0.150
     4.060    63.156     0.150
     4.102    64.148     0.150
     4.152    64.359     0.150
     4.152    64.504     0.150
     4.317    67.117     0.150
     4.317    66.633     0.150
     4.348    67.367     0.150
     4.348    68.270     0.150
     4.348   119.559     0.150
     4.363    66.738     0.150
     4.363    66.922     0.150
     4.379    67.508     0.150
     4.379    67.312     0.150
     4.411    67.367     0.150
     4.394    66.918     0.150
     4.394    66.699     0.150
     4.552    70.270     0.150
     4.552    70.625     0.150
     4.596    70.160     0.150
     4.596    70.539     0.150
     4.636    71.559     0.150
     4.636    70.797     0.150
     4.673    72.301     0.150
     4.673   125.238     0.150
     4.673   146.859     0.150
     4.742    72.289     0.150
     4.742    72.695     0.150
     4.749    73.051     0.150
     4.749    72.828     0.150
     4.855    73.750     0.150
     4.907    75.129     0.150
     4.963    73.418     0.150
     4.963    74.238     0.150
     5.083    77.980     0.150
     5.083    77.500     0.150
     5.114    77.277     0.150
     5.114    77.512     0.150
     5.167    77.988     0.150
     5.167   134.938     0.150
     5.167   158.465     0.150
     5.167    78.148     0.150
     5.205    79.211     0.150
     5.226    78.500     0.150
     5.247    79.301     0.150
     5.247    80.438     0.150
     5.247   139.598     0.150
     5.247    80.211     0.150
     5.326    79.617     0.150
     5.332    79.559     0.150
     5.332    79.852     0.150
     5.403    82.434     0.150
     5.424    82.109     0.150
     5.424    82.477     0.150
     5.488    83.410     0.150
     5.491    83.398     0.150
     5.543    83.652     0.150
     5.646    85.410     0.150
     5.646    84.609     0.150
     5.624    85.250     0.150
     5.624    84.789     0.150
     5.669    86.461     0.150
     5.669   177.430     0.150
     5.745    85.719     0.150
     5.745    84.891     0.150
     5.745   149.133     0.150
     5.745   181.438     0.150
     5.786    85.797     0.150
     5.807    86.465     0.150
     5.818    86.238     0.150
     5.881    89.469     0.150
     5.939    88.188     0.150
     6.032    90.277     0.150
     6.032    90.156     0.150
     6.072    90.520     0.150
     6.072    90.789     0.150
     6.161    92.098     0.150
     6.157    92.445     0.150
     6.242    92.230     0.150
     6.268    94.551     0.150
     6.372    95.719     0.150
     6.548    97.312     0.150
     6.581    98.648     0.150
     6.644    99.160     0.150
     6.644    98.734     0.150
     6.663    98.520     0.150
     6.663    98.848     0.150
     6.742   100.211     0.150
     6.742   100.516     0.150
     6.739    99.953     0.150
     6.751   100.723     0.150
     6.756    99.723     0.150
     6.786   100.590     0.150
     6.786    99.879     0.150
     6.818   101.070     0.150
     6.832   101.980     0.150
     6.832   100.602     0.150
     6.841   102.711     0.150
     6.841   101.227     0.150
     6.914   102.508     0.150
     6.914   102.660     0.150
     6.884    99.969     0.150
     6.916   102.320     0.150
     7.074   104.062     0.150
     7.071   104.227     0.150
     7.108   105.500     0.150
     7.108   104.965     0.150
     7.247   106.113     0.150
     7.277   108.117     0.150
     7.277   107.430     0.150
     7.286   107.332     0.150
     7.284   106.770     0.150
     7.284   106.918     0.150
     7.419   108.500     0.150
     7.419   108.785     0.150
     7.426   109.180     0.150
     7.460   109.613     0.150
     7.602   110.668     0.150
     7.602   110.992     0.150
     7.619   113.438     0.150
     7.619   111.664     0.150
     7.626   112.090     0.150
     7.680   112.391     0.150
     7.680   113.133     0.150
     7.750   111.680     0.150
     7.750   111.988     0.150
     7.827   115.719     0.150
     7.867   115.051     0.150
     7.867   114.695     0.150
     7.930   115.469     0.150
     7.930   116.734     0.150
     7.927   116.145     0.150
     7.949   115.508     0.150
     7.963   116.961     0.150
     7.981   115.480     0.150
     7.981   117.109     0.150
     8.045   117.520     0.150
     8.105   118.926     0.150
     8.114   118.039     0.150
     8.114   118.383     0.150
     8.179   121.258     0.150
     8.179   120.055     0.150
     8.246   120.797     0.150
     8.342   120.379     0.150
     8.342   121.551     0.150
     8.408   123.086     0.150
     8.514   124.988     0.150
     8.514   124.230     0.150
     8.514   124.523     0.150
     8.491   124.250     0.150
     8.491   262.719     0.150
     8.554   122.949     0.150
     8.554   217.848     0.150
     8.554   265.648     0.150
     8.578   124.840     0.150
     8.578   218.320     0.150
     8.578   265.539     0.150
     8.578   126.719     0.150
     8.613   125.293     0.150
     8.686   126.848     0.150
     8.820   127.715     0.150
     8.843   129.820     0.150
     9.083   131.602     0.150
     9.123   287.098     0.150
     9.228   134.035     0.150
     9.351   135.406     0.150
     9.416   297.961     0.150
     9.538   139.617     0.150
     9.548   138.031     0.150
     9.641   141.020     0.150
     9.663   140.277     0.150
    10.031   144.996     0.150
    10.672   153.078     0.150
    11.287   161.328     0.150
    11.287   160.977     0.150
    12.163   172.469     0.150
    12.163   377.641     0.150
    13.147   186.867     0.150
    15.918   228.289     0.150
    17.598   245.457     0.150
    23.443   310.238     0.150
    25.559   330.191     0.150
    26.418   335.801     0.150
    34.021   401.957     0.150
    37.171   431.719     0.150
    37.412   433.699     0.150
    37.589   435.289     0.150
    37.589   435.750     0.150
    46.468   505.789     0.150
    50.151   534.512     0.150
    55.229  4151.180     0.150
    55.234  4151.543     0.150
    58.215   593.285     0.150
    59.585   604.262     0.150
    59.576   604.348     0.150
    59.836   605.629     0.150
    60.849   612.164     0.150
    65.262   640.430     0.150
    68.089   659.141     0.150
    69.117   665.117     0.150
    69.799   670.090     0.150
    74.032   695.527     0.150
    74.183   696.391     0.150
    88.608   774.090     0.150
     0.319     6.653     0.150
     0.319    11.273     0.150
     0.546    10.585     0.150
     0.546    17.988     0.150
     0.546    10.623     0.150
     0.546    17.863     0.150
     0.568    10.673     0.150
     0.568    18.224     0.150
     0.568    18.610     0.150
     0.607    12.213     0.150
     0.607    20.773     0.150
     0.737    13.923     0.150
     0.737    23.934     0.150
     0.737    13.809     0.150
     0.737    23.706     0.150
     0.798    16.303     0.150
     0.830    16.533     0.150
     0.830    28.043     0.150
     1.031    19.663     0.150
     1.031    33.474     0.150
     1.099    20.903     0.150
     1.099    36.980     0.150
     1.122    21.083     0.150
     1.122    36.303     0.150
     1.122    21.843     0.150
     1.122    36.833     0.150
     1.255    24.323     0.150
     1.624    51.163     0.150
     1.624    29.370     0.150
     1.624    51.621     0.150
     1.612    30.523     0.150
     1.612    52.083     0.150
     1.612    51.879     0.150
     1.631    29.890     0.150
     1.631    52.072     0.150
     1.673    30.823     0.150
     1.673    54.123     0.150
     1.673    53.545     0.150
     1.712    30.303     0.150
     1.712    53.273     0.150
     1.753    30.653     0.150
     1.753    54.693     0.150
     1.760    32.803     0.150
     1.760    56.743     0.150
     2.097    66.135     0.150
     2.097    37.583     0.150
     2.097    39.934     0.150
     2.097    67.413     0.150
     2.097    66.674     0.150
     2.207    39.823     0.150
     2.207    67.678     0.150
     2.254    40.604     0.150
     2.254    72.233     0.150
     2.339    43.423     0.150
     2.501    46.563     0.150
     2.501    78.913     0.150
     2.501    79.182     0.150
     2.627    49.413     0.150
     2.627    84.023     0.150
     2.766    45.104     0.150
     2.766    85.653     0.150
     2.834    51.684     0.150
     2.834    89.313     0.150
     2.834    88.154     0.150
     2.939    54.943     0.150
     2.939    93.983     0.150
     3.056    96.713     0.150
     3.111    97.733     0.150
     3.183    51.003     0.150
     3.183    58.354     0.150
     3.183    98.533     0.150
     3.716    60.483     0.150
     3.716   117.363     0.150
     3.856    62.354     0.150
     3.856   107.913     0.150
     4.050   126.604     0.150
     4.764   148.053     0.150
     5.026   156.153     0.150
     0.373     7.801     0.150
     0.373    13.062     0.150
     0.373     7.898     0.150
     0.373    12.988     0.150
     0.492     9.758     0.150
     0.492    16.746     0.150
     0.520     9.938     0.150
     0.520    17.336     0.150
     0.520     9.836     0.150
     0.627    12.898     0.150
     0.675    12.625     0.150
     0.675    21.887     0.150
     0.675    21.723     0.150
     0.775    15.105     0.150
     0.775    25.887     0.150
     0.957    18.559     0.150
     0.957    31.355     0.150
     0.957    31.508     0.150
     0.972    17.535     0.150
     1.060    19.105     0.150
     1.060    33.559     0.150
     1.111    20.695     0.150
     1.111    35.785     0.150
     1.111    35.523     0.150
     1.186    21.375     0.150
     1.189    21.039     0.150
     1.189    38.250     0.150
     1.192    22.438     0.150
     1.192    38.195     0.150
     1.192    22.305     0.150
     1.346    25.648     0.150
     1.259    23.996     0.150
     1.259    40.785     0.150
     1.288    23.746     0.150
     1.288    41.059     0.150
     1.288    40.844     0.150
     1.582    27.688     0.150
     1.582    50.348     0.150
     1.631    28.586     0.150
     1.631    51.957     0.150
     1.661    30.078     0.150
     1.661    53.238     0.150
     1.661    29.922     0.150
     1.661    52.820     0.150
     1.732    31.219     0.150
     1.758    31.027     0.150
     1.758    54.797     0.150
     1.758    31.164     0.150
     1.758    55.141     0.150
     1.761    31.195     0.150
     1.761    55.207     0.150
     1.753    31.258     0.150
     1.753    54.148     0.150
     1.803    31.656     0.150
     1.803    55.699     0.150
     2.094    36.164     0.150
     2.255    38.367     0.150
     2.255    66.797     0.150
     2.255    38.105     0.150
     2.255    67.086     0.150
     2.329    39.527     0.150
     2.329    39.293     0.150
     2.327    39.418     0.150
     2.327    39.316     0.150
     2.460    41.246     0.150
     2.460    41.051     0.150
     2.740    45.266     0.150
     2.740    86.527     0.150
     2.784    44.762     0.150
     2.858    46.457     0.150
     2.992    92.488     0.150
     3.012    49.066     0.150
     3.012    95.148     0.150
     3.012    48.941     0.150
     3.090    49.586     0.150
     3.090    97.047     0.150
     3.320    52.348     0.150
     3.353    51.996     0.150
     3.353   104.266     0.150
     3.385    54.656     0.150
     3.392    53.746     0.150
     3.628    57.598     0.150
     3.628    98.398     0.150
     3.794    60.137     0.150
     3.794   103.477     0.150
     3.794   119.875     0.150
     3.898    61.008     0.150
     3.898   105.578     0.150
     4.041   125.035     0.150
     4.330   134.527     0.150
     4.399   117.156     0.150
     4.399   136.695     0.150
     4.665    71.855     0.150
     4.665    71.648     0.150
     5.175   162.316     0.150
     5.524   173.008     0.150
     0.214     5.066     0.150
     0.214     8.797     0.150
     0.357     7.633     0.150
     0.357    12.926     0.150
     0.357     7.598     0.150
     0.357    13.188     0.150
     0.357     7.707     0.150
     0.509     9.566     0.150
     0.509    16.488     0.150
     0.502     9.656     0.150
     0.502    17.219     0.150
     0.502    16.867     0.150
     0.502    17.012     0.150
     0.614    12.609     0.150
     0.655    13.469     0.150
     0.688    12.359     0.150
     0.688    21.656     0.150
     0.688    21.242     0.150
     0.795    14.887     0.150
     0.795    25.559     0.150
     0.980    18.418     0.150
     0.980    31.227     0.150
     0.980    30.914     0.150
     0.977    17.520     0.150
     0.977    17.199     0.150
     0.977    30.137     0.150
     1.060    18.887     0.150
     1.060    33.188     0.150
     1.060    33.320     0.150
     1.130    20.566     0.150
     1.130    35.207     0.150
     1.130    35.492     0.150
     1.191    21.336     0.150
     1.191    20.949     0.150
     1.191    36.969     0.150
     1.194    20.734     0.150
     1.194    38.234     0.150
     1.214    22.246     0.150
     1.214    37.867     0.150
     1.214    22.066     0.150
     1.214    38.160     0.150
     1.369    25.457     0.150
     1.282    23.777     0.150
     1.282    40.707     0.150
     1.299    23.539     0.150
     1.299    40.809     0.150
     1.299    40.641     0.150
     1.374    24.637     0.150
     1.374    42.520     0.150
     1.582    27.520     0.150
     1.582    27.707     0.150
     1.632    27.996     0.150
     1.632    28.520     0.150
     1.632    51.680     0.150
     1.678    29.508     0.150
     1.678    52.977     0.150
     1.678    29.695     0.150
     1.728    29.918     0.150
     1.747    30.969     0.150
     1.761    30.898     0.150
     1.761    30.777     0.150
     1.761    54.102     0.150
     1.776    30.449     0.150
     1.776    54.027     0.150
     1.776    53.848     0.150
     1.763    30.836     0.150
     1.763    31.086     0.150
     1.763    55.109     0.150
     1.821    31.258     0.150
     1.821    55.402     0.150
     2.096    36.055     0.150
     2.096    63.996     0.150
     2.195    36.598     0.150
     2.249    40.340     0.150
     2.277    38.156     0.150
     2.277    66.738     0.150
     2.277    37.910     0.150
     2.277    66.562     0.150
     2.349    39.258     0.150
     2.349    68.539     0.150
     2.346    39.168     0.150
     2.346    38.469     0.150
     2.449    40.207     0.150
     2.472    40.957     0.150
     2.472    40.824     0.150
     2.763    44.879     0.150
     2.763    86.336     0.150
     2.763    44.586     0.150
     2.763    85.969     0.150
     2.794    44.656     0.150
     2.794    86.156     0.150
     2.796    85.805     0.150
     2.859    45.797     0.150
     2.859    88.328     0.150
     2.883    44.879     0.150
     3.001    46.656     0.150
     3.001    53.668     0.150
     3.001    82.629     0.150
     3.001    92.363     0.150
     3.034    48.738     0.150
     3.034    95.047     0.150
     3.034    94.117     0.150
     3.105    55.957     0.150
     3.208    98.680     0.150
     3.231    89.527     0.150
     3.263    50.938     0.150
     3.366    51.738     0.150
     3.366    52.066     0.150
     3.366    91.477     0.150
     3.366   104.289     0.150
     3.366    51.336     0.150
     3.390    53.578     0.150
     3.390    94.352     0.150
     3.650    56.949     0.150
     3.650    98.586     0.150
     3.756    58.066     0.150
     3.817    59.828     0.150
     3.817   103.637     0.150
     3.817   119.699     0.150
     3.817   104.891     0.150
     3.918    60.617     0.150
     3.918   105.527     0.150
     4.057   108.387     0.150
     4.139    63.527     0.150
     4.352   136.586     0.150
     4.409    66.879     0.150
     4.409   117.020     0.150
     4.686    71.496     0.150
     4.686   123.887     0.150
     4.686    71.383     0.150
     4.901    72.898     0.150
     4.901    73.512     0.150
     5.181    78.137     0.150
     5.181   161.496     0.150
     5.542   172.938     0.150
     0.384     7.812     0.150
     0.384    13.195     0.150
     0.384     7.844     0.150
     0.384    13.172     0.150
     0.490     9.961     0.150
     0.490    16.117     0.150
     0.588    11.188     0.150
     0.588    18.578     0.150
     0.588    18.961     0.150
     0.625    12.562     0.150
     0.611    11.742     0.150
     0.611    20.039     0.150
     0.757    15.336     0.150
     0.757    24.984     0.150
     0.920    16.539     0.150
     0.911    18.367     0.150
     0.911    30.445     0.150
     0.911    30.594     0.150
     1.043    20.023     0.150
     1.043    34.047     0.150
     1.105    20.125     0.150
     1.105    35.289     0.150
     1.105    19.992     0.150
     1.134    20.445     0.150
     1.134    35.828     0.150
     1.136    20.258     0.150
     1.136    36.000     0.150
     1.166    22.469     0.150
     1.166    37.945     0.150
     1.166    38.336     0.150
     1.287    25.219     0.150
     1.287    24.953     0.150
     1.216    23.789     0.150
     1.216    40.359     0.150
     1.303    24.445     0.150
     1.303    42.203     0.150
     1.541    26.875     0.150
     1.541    47.867     0.150
     1.586    28.234     0.150
     1.586    49.008     0.150
     1.593    29.656     0.150
     1.593    51.859     0.150
     1.593    51.289     0.150
     1.665    30.992     0.150
     1.665    53.914     0.150
     1.713    30.445     0.150
     1.713    53.758     0.150
     1.711    31.289     0.150
     1.711    54.266     0.150
     1.711    54.023     0.150
     1.795    31.938     0.150
     1.795    32.133     0.150
     1.791    32.266     0.150
     1.791    56.570     0.150
     2.045    36.156     0.150
     2.045    62.891     0.150
     2.224    38.484     0.150
     2.224    67.062     0.150
     2.224    38.219     0.150
     2.262    41.133     0.150
     2.262    40.906     0.150
     2.264    39.344     0.150
     2.264    67.375     0.150
     2.394    40.945     0.150
     2.686    45.148     0.150
     2.686    49.828     0.150
     2.686    85.789     0.150
     2.686    45.016     0.150
     2.686    78.180     0.150
     2.723    44.820     0.150
     2.723    85.289     0.150
     2.814    46.367     0.150
     2.929    47.648     0.150
     2.949    48.938     0.150
     2.949    94.086     0.150
     2.949    48.820     0.150
     3.014    48.156     0.150
     3.014    54.617     0.150
     3.014    84.539     0.150
     3.014    47.992     0.150
     3.023    49.586     0.150
     3.023    95.992     0.150
     3.308    52.938     0.150
     3.308    92.875     0.150
     3.354    53.484     0.150
     3.360    52.867     0.150
     3.360    92.992     0.150
     3.360    52.766     0.150
     3.732    59.805     0.150
     3.732   102.727     0.150
     3.732   118.062     0.150
     3.732    59.945     0.150
     3.778   105.312     0.150
     3.778   120.289     0.150
     3.831    60.828     0.150
     4.636    72.016     0.150
     4.636   124.406     0.150
     5.163   138.297     0.150
     0.291     6.166     0.150
     0.291    10.348     0.150
     0.367     7.646     0.150
     0.367    12.926     0.150
     0.506     9.867     0.150
     0.506    16.688     0.150
     0.609    12.426     0.150
     0.583    10.996     0.150
     0.583    18.867     0.150
     0.610    11.566     0.150
     0.610    19.768     0.150
     0.734    14.477     0.150
     0.734    26.117     0.150
     0.800    14.617     0.150
     0.800    14.396     0.150
     0.800    26.426     0.150
     0.773    15.256     0.150
     0.913    16.256     0.150
     0.926    18.227     0.150
     0.926    30.246     0.150
     1.050    19.848     0.150
     1.050    33.627     0.150
     1.127    20.037     0.150
     1.114    19.986     0.150
     1.114    34.967     0.150
     1.182    22.246     0.150
     1.182    40.438     0.150
     1.183    22.326     0.150
     1.183    22.166     0.150
     1.183    37.326     0.150
     1.300    25.086     0.150
     1.300    42.316     0.150
     1.231    23.707     0.150
     1.231    40.018     0.150
     1.311    24.027     0.150
     1.317    24.377     0.150
     1.317    41.957     0.150
     1.414    24.797     0.150
     1.531    26.467     0.150
     1.531    47.207     0.150
     1.577    26.787     0.150
     1.577    48.156     0.150
     1.597    29.537     0.150
     1.597    50.967     0.150
     1.626    29.188     0.150
     1.638    29.477     0.150
     1.667    30.707     0.150
     1.667    52.736     0.150
     1.687    29.537     0.150
     1.705    29.947     0.150
     1.705    52.707     0.150
     1.727    31.018     0.150
     1.727    53.746     0.150
     1.806    31.406     0.150
     1.806    56.477     0.150
     2.038    35.848     0.150
     2.104    36.037     0.150
     2.142    36.688     0.150
     2.265    38.527     0.150
     2.265    40.836     0.150
     2.241    38.348     0.150
     2.241    67.146     0.150
     2.274    39.076     0.150
     2.274    67.367     0.150
     2.286    38.676     0.150
     2.331    39.156     0.150
     2.394    40.018     0.150
     2.395    40.268     0.150
     2.721    44.537     0.150
     2.699    44.797     0.150
     2.699    44.586     0.150
     2.699    85.906     0.150
     2.937    47.938     0.150
     2.937    46.377     0.150
     2.937    89.387     0.150
     2.960    48.746     0.150
     2.960    93.916     0.150
     3.022    48.607     0.150
     3.025    48.877     0.150
     3.025    48.406     0.150
     3.025    95.547     0.150
     3.027    47.127     0.150
     3.027    94.426     0.150
     3.075    49.246     0.150
     3.171    50.707     0.150
     3.171    50.127     0.150
     3.190    51.787     0.150
     3.190    51.197     0.150
     3.190    89.707     0.150
     3.321    52.986     0.150
     3.343    52.977     0.150
     3.319    52.227     0.150
     3.325    52.848     0.150
     3.325    92.146     0.150
     3.376    52.727     0.150
     3.376    52.166     0.150
     3.614    57.896     0.150
     3.743    59.938     0.150
     3.743   102.277     0.150
     3.743   117.926     0.150
     3.791    59.707     0.150
     3.791    59.977     0.150
     3.791   120.396     0.150
     3.839    60.566     0.150
     3.839    60.256     0.150
     3.977    62.066     0.150
     3.977    61.506     0.150
     3.977   124.457     0.150
     4.020    63.076     0.150
     4.280    66.107     0.150
     4.275   134.656     0.150
     4.297    66.506     0.150
     4.433    80.268     0.150
     4.433   136.848     0.150
     4.611    70.857     0.150
     4.658    71.277     0.150
     4.652    71.867     0.150
     4.652   124.307     0.150
     5.216   164.367     0.150
     5.461    82.377     0.150
     5.461   170.447     0.150
     6.076    91.037     0.150
     6.076   189.688     0.150
     0.456     8.559     0.150
     0.456    14.789     0.150
     0.456    14.526     0.150
     0.427     8.307     0.150
     0.427    14.859     0.150
     0.427     8.299     0.150
     0.427    14.889     0.150
     0.452     9.419     0.150
     0.452    16.386     0.150
     0.688    13.889     0.150
     0.688    25.189     0.150
     0.751    14.989     0.150
     0.758    14.079     0.150
     0.758    23.929     0.150
     0.921    17.909     0.150
     0.921    31.139     0.150
     0.976    17.699     0.150
     0.976    31.099     0.150
     0.976    17.943     0.150
     0.976    31.262     0.150
     0.971    19.399     0.150
     0.971    32.439     0.150
     0.971    32.969     0.150
     1.058    19.209     0.150
     1.058    35.609     0.150
     1.176    22.459     0.150
     1.176    39.059     0.150
     1.176    22.336     0.150
     1.225    22.979     0.150
     1.225    40.009     0.150
     1.273    23.849     0.150
     1.273    41.917     0.150
     1.272    41.369     0.150
     1.275    24.114     0.150
     1.275    41.733     0.150
     1.267    24.649     0.150
     1.267    42.169     0.150
     1.314    23.859     0.150
     1.314    42.239     0.150
     1.382    26.739     0.150
     1.382    45.829     0.150
     1.382    45.702     0.150
     1.677    30.079     0.150
     1.677    52.729     0.150
     1.677    53.019     0.150
     1.666    29.779     0.150
     1.666    52.959     0.150
     1.715    30.829     0.150
     1.715    54.269     0.150
     1.736    32.109     0.150
     1.736    31.862     0.150
     1.767    32.353     0.150
     1.767    57.883     0.150
     1.758    33.469     0.150
     1.758    56.959     0.150
     1.810    33.429     0.150
     1.846    33.279     0.150
     1.846    59.839     0.150
     1.933    33.967     0.150
     1.933    61.443     0.150
     2.179    38.691     0.150
     2.179    69.425     0.150
     2.243    39.469     0.150
     2.373    42.299     0.150
     2.373    73.429     0.150
     2.373    42.195     0.150
     2.373    72.738     0.150
     2.404    42.319     0.150
     2.541    44.199     0.150
     2.719    84.891     0.150
     2.799    87.069     0.150
     2.869    90.889     0.150
     2.921    53.489     0.150
     2.921    92.869     0.150
     2.921    83.487     0.150
     2.943    48.639     0.150
     2.943    91.159     0.150
     3.058    52.039     0.150
     3.058    98.059     0.150
     3.058    96.379     0.150
     3.295    52.859     0.150
     3.295    60.769     0.150
     3.295   103.269     0.150
     3.295    60.146     0.150
     3.295   103.010     0.150
     3.474    55.781     0.150
     3.474    98.541     0.150
     3.838    62.059     0.150
     3.838   105.719     0.150
     3.838   122.719     0.150
     3.838    62.534     0.150
     3.957    62.989     0.150
     3.957    63.675     0.150
     4.223    67.181     0.150
     4.331   134.539     0.150
     5.099   158.579     0.150
     0.198     4.848     0.150
     0.198     8.488     0.150
     0.377     7.896     0.150
     0.377    12.830     0.150
     0.377     7.848     0.150
     0.377    13.357     0.150
     0.377    13.639     0.150
     0.493     9.408     0.150
     0.493    16.318     0.150
     0.493     9.299     0.150
     0.477     9.178     0.150
     0.477    15.539     0.150
     0.477     9.518     0.150
     0.477    16.408     0.150
     0.637    12.898     0.150
     0.637    22.389     0.150
     0.718    12.988     0.150
     0.718    22.578     0.150
     0.718    22.418     0.150
     0.636    13.078     0.150
     0.785    14.828     0.150
     0.785    25.338     0.150
     0.785    25.559     0.150
     0.868    16.129     0.150
     0.868    28.799     0.150
     0.931    17.598     0.150
     0.931    30.818     0.150
     0.985    18.629     0.150
     0.985    31.459     0.150
     0.985    31.314     0.150
     1.009    17.918     0.150
     1.009    18.027     0.150
     1.009    30.648     0.150
     1.029    18.539     0.150
     1.029    32.459     0.150
     1.029    32.289     0.150
     1.138    21.209     0.150
     1.207    22.219     0.150
     1.207    38.086     0.150
     1.207    37.408     0.150
     1.224    21.598     0.150
     1.224    22.248     0.150
     1.224    37.678     0.150
     1.226    21.896     0.150
     1.221    22.459     0.150
     1.221    39.307     0.150
     1.221    22.668     0.150
     1.221    38.889     0.150
     1.262    22.248     0.150
     1.262    22.389     0.150
     1.262    39.898     0.150
     1.382    25.879     0.150
     1.284    24.039     0.150
     1.284    40.938     0.150
     1.276    23.229     0.150
     1.276    40.320     0.150
     1.276    40.129     0.150
     1.332    23.918     0.150
     1.407    25.078     0.150
     1.481    26.527     0.150
     1.492    26.479     0.150
     1.492    47.039     0.150
     1.614    27.898     0.150
     1.614    50.148     0.150
     1.614    49.629     0.150
     1.664    28.898     0.150
     1.664    28.709     0.150
     1.664    51.447     0.150
     1.665    29.188     0.150
     1.705    30.697     0.150
     1.694    29.619     0.150
     1.776    30.709     0.150
     1.776    31.418     0.150
     1.758    30.619     0.150
     1.777    30.938     0.150
     1.777    30.799     0.150
     1.777    54.176     0.150
     1.795    31.598     0.150
     1.795    31.748     0.150
     1.795    55.947     0.150
     1.808    31.188     0.150
     1.808    55.158     0.150
     1.880    32.473     0.150
     1.880    56.891     0.150
     1.888    32.438     0.150
     1.903    32.357     0.150
     1.889    32.582     0.150
     1.889    58.811     0.150
     1.908    32.498     0.150
     2.129    36.408     0.150
     2.129    36.250     0.150
     2.129    64.461     0.150
     2.139    35.828     0.150
     2.226    37.168     0.150
     2.230    36.879     0.150
     2.220    37.168     0.150
     2.272    37.879     0.150
     2.272    66.664     0.150
     2.272    38.098     0.150
     2.366    39.328     0.150
     2.366    70.869     0.150
     2.379    38.959     0.150
     2.481    40.559     0.150
     2.503    40.518     0.150
     2.503    41.938     0.150
     2.503    73.309     0.150
     2.772    44.758     0.150
     2.772    44.629     0.150
     2.772    78.715     0.150
     2.772    78.328     0.150
     2.826    44.947     0.150
     2.826    45.055     0.150
     2.764    44.488     0.150
     2.764    45.295     0.150
     2.764    84.637     0.150
     2.891    46.148     0.150
     2.891    46.500     0.150
     2.891    81.973     0.150
     2.851    44.479     0.150
     2.851    44.789     0.150
     2.851    80.588     0.150
     2.974    52.820     0.150
     2.974    92.443     0.150
     2.974    46.658     0.150
     3.051    49.059     0.150
     3.051    48.873     0.150
     3.051    94.990     0.150
     3.051    85.879     0.150
     3.134    50.311     0.150
     3.134    96.977     0.150
     3.134    49.738     0.150
     3.134    97.838     0.150
     3.229    51.094     0.150
     3.229    89.998     0.150
     3.229    89.268     0.150
     3.176    49.391     0.150
     3.231    49.908     0.150
     3.323    51.969     0.150
     3.323    91.381     0.150
     3.323    91.238     0.150
     3.344    51.588     0.150
     3.344    91.793     0.150
     3.421    53.879     0.150
     3.421    94.510     0.150
     3.645    57.133     0.150
     3.645    57.299     0.150
     3.709   112.795     0.150
     3.788    58.418     0.150
     3.788    59.615     0.150
     3.833    60.039     0.150
     3.833   103.559     0.150
     3.833   118.857     0.150
     3.867    59.258     0.150
     3.867    60.719     0.150
     3.867   105.248     0.150
     3.870    59.068     0.150
     3.870   121.559     0.150
     3.959    60.318     0.150
     4.085    62.238     0.150
     4.085    62.416     0.150
     4.085   126.338     0.150
     4.170   113.508     0.150
     4.170    63.822     0.150
     4.371   138.879     0.150
     4.371   134.309     0.150
     4.388    67.518     0.150
     4.383   116.209     0.150
     4.383   136.197     0.150
     4.691    72.059     0.150
     4.691   125.857     0.150
     4.680    71.191     0.150
     4.680    71.469     0.150
     4.680   123.658     0.150
     4.767    73.008     0.150
     4.870   150.418     0.150
     5.152   160.059     0.150
     5.251    79.623     0.150
     5.301    80.789     0.150
     5.301    80.979     0.150
     5.301   139.889     0.150
     5.332    80.398     0.150
     5.332    80.562     0.150
     5.332    81.068     0.150
     5.332   140.197     0.150
     5.449    81.848     0.150
     5.568    83.459     0.150
     5.568    83.857     0.150
     5.568   143.848     0.150
     5.568   174.098     0.150
     6.153    91.648     0.150
     6.153    91.424     0.150
     6.153   160.188     0.150
     6.182    91.488     0.150
     6.763   210.527     0.150
     7.022   102.799     0.150
     7.022   179.697     0.150
     0.181     3.738     0.150
     0.181     6.426     0.150
     0.442     8.738     0.150
     0.442    15.047     0.150
     0.403     8.164     0.150
     0.403    13.785     0.150
     0.403     8.148     0.150
     0.403    14.355     0.150
     0.403    14.637     0.150
     0.479     9.328     0.150
     0.479    16.328     0.150
     0.609    12.227     0.150
     0.609    12.816     0.150
     0.666    13.508     0.150
     0.666    13.746     0.150
     0.666    24.438     0.150
     0.778    14.926     0.150
     0.778    26.105     0.150
     0.778    25.578     0.150
     0.760    13.668     0.150
     0.760    24.273     0.150
     0.906    16.598     0.150
     0.906    29.559     0.150
     0.906    16.445     0.150
     0.989    17.855     0.150
     0.989    31.316     0.150
     0.989    18.016     0.150
     0.989    30.809     0.150
     0.989    30.648     0.150
     0.965    18.539     0.150
     0.965    31.566     0.150
     0.965    18.797     0.150
     0.965    32.539     0.150
     0.996    19.039     0.150
     0.996    32.598     0.150
     1.052    18.508     0.150
     1.052    34.559     0.150
     1.052    34.379     0.150
     1.203    22.086     0.150
     1.203    22.258     0.150
     1.203    38.332     0.150
     1.203    22.379     0.150
     1.203    38.598     0.150
     1.172    21.629     0.150
     1.172    38.445     0.150
     1.248    23.086     0.150
     1.248    40.488     0.150
     1.248    40.387     0.150
     1.248    40.207     0.150
     1.251    22.445     0.150
     1.251    41.430     0.150
     1.292    24.398     0.150
     1.292    41.355     0.150
     1.266    22.066     0.150
     1.266    22.309     0.150
     1.266    40.598     0.150
     1.269    22.133     0.150
     1.269    41.082     0.150
     1.403    26.418     0.150
     1.403    46.062     0.150
     1.302    22.676     0.150
     1.302    42.438     0.150
     1.302    23.078     0.150
     1.368    24.676     0.150
     1.368    44.559     0.150
     1.449    25.328     0.150
     1.449    46.629     0.150
     1.654    28.766     0.150
     1.654    51.855     0.150
     1.654    28.887     0.150
     1.728    53.617     0.150
     1.744    31.738     0.150
     1.744    54.105     0.150
     1.744    31.848     0.150
     1.794    32.316     0.150
     1.794    56.879     0.150
     1.784    32.238     0.150
     1.784    32.109     0.150
     1.784    56.352     0.150
     1.784    33.098     0.150
     1.784    56.617     0.150
     1.796    30.629     0.150
     1.796    55.387     0.150
     1.796    57.488     0.150
     1.816    32.676     0.150
     1.837    32.387     0.150
     1.837    58.676     0.150
     1.918    33.785     0.150
     1.917    33.742     0.150
     1.917    59.723     0.150
     1.921    33.926     0.150
     1.939    34.328     0.150
     2.184    39.418     0.150
     2.184    37.582     0.150
     2.184    66.637     0.150
     2.170    37.711     0.150
     2.170    68.008     0.150
     2.270    39.406     0.150
     2.270    68.613     0.150
     2.267    38.445     0.150
     2.336    39.809     0.150
     2.336    70.270     0.150
     2.392    41.227     0.150
     2.392    40.660     0.150
     2.392    71.789     0.150
     2.392    41.918     0.150
     2.392    71.988     0.150
     2.411    39.688     0.150
     2.412    40.219     0.150
     2.412    44.047     0.150
     2.412    42.719     0.150
     2.555    78.941     0.150
     2.522    42.398     0.150
     2.544    43.309     0.150
     2.544    42.965     0.150
     2.544    80.363     0.150
     2.544    43.887     0.150
     2.722    44.879     0.150
     2.811    45.836     0.150
     2.811    45.707     0.150
     2.788    46.488     0.150
     2.788    46.977     0.150
     2.788    51.945     0.150
     2.868    46.918     0.150
     2.868    47.566     0.150
     2.942    47.637     0.150
     2.942    54.129     0.150
     2.942    92.316     0.150
     2.932    47.961     0.150
     2.935    48.656     0.150
     3.029    50.086     0.150
     3.077    50.766     0.150
     3.077    51.129     0.150
     3.077    57.195     0.150
     3.135    50.746     0.150
     3.135    50.555     0.150
     3.190    51.816     0.150
     3.162    50.719     0.150
     3.162    49.844     0.150
     3.170    51.598     0.150
     3.174    51.688     0.150
     3.174    51.816     0.150
     3.174    57.418     0.150
     3.230    52.355     0.150
     3.230    52.695     0.150
     3.230    53.008     0.150
     3.309    52.293     0.150
     3.309    52.996     0.150
     3.309   103.309     0.150
     3.318    51.957     0.150
     3.318    52.418     0.150
     3.318    52.086     0.150
     3.318   102.418     0.150
     3.279    51.898     0.150
     3.279    52.496     0.150
     3.460    55.629     0.150
     3.469    55.266     0.150
     3.469    55.855     0.150
     3.542    55.156     0.150
     3.592    63.941     0.150
     3.667    57.648     0.150
     3.667    59.465     0.150
     3.643    58.332     0.150
     3.746    61.617     0.150
     3.835    60.078     0.150
     3.835    59.969     0.150
     3.835   118.539     0.150
     3.829    61.152     0.150
     3.858    61.566     0.150
     3.858    61.945     0.150
     3.859    59.477     0.150
     3.885    61.047     0.150
     3.972    63.406     0.150
     3.988    62.066     0.150
     3.988    62.258     0.150
     4.066    62.707     0.150
     4.066    63.012     0.150
     4.124    64.188     0.150
     4.124    64.957     0.150
     4.124    63.777     0.150
     4.210    65.289     0.150
     4.352    66.977     0.150
     4.352    66.578     0.150
     4.352   134.176     0.150
     4.374    66.879     0.150
     4.374    67.707     0.150
     4.399    67.508     0.150
     4.429    68.918     0.150
     4.459    67.387     0.150
     4.459    68.527     0.150
     4.606    71.453     0.150
     4.676    72.707     0.150
     4.676   146.547     0.150
     4.652    71.137     0.150
     4.713    73.426     0.150
     4.713    73.875     0.150
     4.713   129.477     0.150
     4.713   149.047     0.150
     4.698    72.176     0.150
     4.832    74.129     0.150
     4.832    73.559     0.150
     4.807    73.457     0.150
     4.807    74.500     0.150
     4.813    73.195     0.150
     4.813    74.078     0.150
     4.962    77.746     0.150
     5.117    77.805     0.150
     5.117    76.918     0.150
     5.145    78.871     0.150
     5.164    77.219     0.150
     5.164    78.383     0.150
     5.267    80.547     0.150
     5.299    81.477     0.150
     5.299    80.980     0.150
     5.299    82.027     0.150
     5.299   143.656     0.150
     5.292    80.176     0.150
     5.292    80.613     0.150
     5.325    81.914     0.150
     5.325    82.668     0.150
     5.365    82.938     0.150
     5.365    82.242     0.150
     5.365    82.797     0.150
     5.370    80.648     0.150
     5.488    83.898     0.150
     5.488    84.004     0.150
     5.555    84.039     0.150
     5.555    83.848     0.150
     5.604    85.129     0.150
     5.604    85.324     0.150
     5.604    85.828     0.150
     5.661    84.926     0.150
     5.752    84.695     0.150
     5.696    87.215     0.150
     5.705    87.039     0.150
     5.812    85.898     0.150
     5.812    87.559     0.150
     5.947    89.227     0.150
     5.983    89.188     0.150
     6.098    91.207     0.150
     6.098    92.320     0.150
     6.135    91.816     0.150
     6.135    92.797     0.150
     6.154    91.508     0.150
     6.173    92.246     0.150
     6.173    93.926     0.150
     6.173    94.996     0.150
     6.217    92.656     0.150
     6.217    94.289     0.150
     6.218    92.039     0.150
     6.292    92.016     0.150
     6.335    94.906     0.150
     6.343    94.789     0.150
     6.343    96.367     0.150
     6.406    96.398     0.150
     6.434    95.617     0.150
     6.589    97.879     0.150
     6.589    99.367     0.150
     6.703   100.008     0.150
     6.703   100.828     0.150
     6.727    99.867     0.150
     6.727   100.727     0.150
     6.784   100.426     0.150
     6.785   101.352     0.150
     6.799   101.949     0.150
     6.799   101.766     0.150
     6.809   102.016     0.150
     6.848   103.207     0.150
     6.859    99.867     0.150
     6.886   103.375     0.150
     6.908   101.969     0.150
     6.952   104.508     0.150
     7.048   105.758     0.150
     7.137   106.875     0.150
     7.317   107.746     0.150
     7.317   108.422     0.150
     7.312   108.734     0.150
     7.342   108.336     0.150
     7.342   108.945     0.150
     7.466   109.812     0.150
     7.480   111.000     0.150
     7.526   111.543     0.150
     7.662   111.957     0.150
     7.662   113.051     0.150
     7.689   114.059     0.150
     7.685   113.637     0.150
     7.735   114.199     0.150
     7.770   111.879     0.150
     7.770   113.617     0.150
     7.890   116.934     0.150
     7.908   115.066     0.150
     7.908   116.602     0.150
     7.991   116.277     0.150
     7.991   118.156     0.150
     7.993   117.016     0.150
     7.993   118.070     0.150
     7.998   116.168     0.150
     7.998   118.719     0.150
     8.076   117.227     0.150
     8.161   119.496     0.150
     8.186   120.766     0.150
     8.244   121.469     0.150
     8.312   122.270     0.150
     8.399   121.996     0.150
     8.526   125.141     0.150
     8.592   125.418     0.150
     8.622   125.039     0.150
     8.636   128.133     0.150
     8.834   127.586     0.150
     8.834   128.734     0.150
     8.862   130.246     0.150
     8.909   130.438     0.150
     8.909   131.148     0.150
     8.997   133.012     0.150
     9.121   134.277     0.150
     9.398   135.945     0.150
     0.212     4.830     0.150
     0.212     8.400     0.150
     0.381     7.905     0.150
     0.381    13.078     0.150
     0.381     7.910     0.150
     0.381    13.280     0.150
     0.381    13.640     0.150
     0.491     9.450     0.150
     0.491    16.370     0.150
     0.491    16.132     0.150
     0.487     9.400     0.150
     0.487    16.410     0.150
     0.639    13.040     0.150
     0.639    21.710     0.150
     0.650    12.720     0.150
     0.650    23.520     0.150
     0.706    13.030     0.150
     0.706    22.380     0.150
     0.706    22.485     0.150
     0.777    14.990     0.150
     0.777    25.660     0.150
     0.777    15.100     0.150
     0.930    17.690     0.150
     0.930    30.420     0.150
     0.972    18.680     0.150
     0.972    31.360     0.150
     1.001    18.100     0.150
     1.001    30.850     0.150
     1.001    17.900     0.150
     1.035    18.780     0.150
     1.035    32.500     0.150
     1.035    18.595     0.150
     1.141    21.130     0.150
     1.141    36.190     0.150
     1.141    36.400     0.150
     1.141    36.297     0.150
     1.197    22.180     0.150
     1.197    38.160     0.150
     1.215    21.650     0.150
     1.215    37.370     0.150
     1.222    39.398     0.150
     1.222    39.010     0.150
     1.217    21.545     0.150
     1.217    38.797     0.150
     1.256    22.220     0.150
     1.256    40.230     0.150
     1.256    22.390     0.150
     1.274    23.340     0.150
     1.274    40.340     0.150
     1.274    40.000     0.150
     1.274    40.233     0.150
     1.368    25.802     0.150
     1.272    24.130     0.150
     1.272    40.700     0.150
     1.398    24.110     0.150
     1.508    27.230     0.150
     1.608    28.050     0.150
     1.608    50.650     0.150
     1.666    29.510     0.150
     1.666    51.630     0.150
     1.692    30.100     0.150
     1.692    30.220     0.150
     1.692    54.270     0.150
     1.692    53.289     0.150
     1.735    30.880     0.150
     1.735    54.220     0.150
     1.735    30.430     0.150
     1.735    54.020     0.150
     1.754    30.760     0.150
     1.763    31.270     0.150
     1.763    31.140     0.150
     1.763    55.580     0.150
     1.765    30.970     0.150
     1.765    54.230     0.150
     1.765    30.784     0.150
     1.765    54.090     0.150
     1.788    31.550     0.150
     1.788    55.640     0.150
     1.801    31.210     0.150
     1.801    55.183     0.150
     1.876    32.557     0.150
     1.876    57.432     0.150
     1.899    32.390     0.150
     2.105    35.550     0.150
     2.121    36.470     0.150
     2.121    36.202     0.150
     2.141    36.090     0.150
     2.223    39.620     0.150
     2.220    37.660     0.150
     2.262    38.080     0.150
     2.262    66.496     0.150
     2.350    39.010     0.150
     2.350    38.890     0.150
     2.350    68.340     0.150
     2.350    68.594     0.150
     2.351    39.350     0.150
     2.379    39.450     0.150
     2.474    40.600     0.150
     2.490    41.170     0.150
     2.587    42.510     0.150
     2.629    42.400     0.150
     2.646    42.570     0.150
     2.646    42.963     0.150
     2.646    75.709     0.150
     2.774    46.930     0.150
     2.759    44.630     0.150
     2.759    44.850     0.150
     2.759    78.750     0.150
     2.759    44.742     0.150
     2.759    78.493     0.150
     2.815    44.780     0.150
     2.815    44.893     0.150
     2.815    87.216     0.150
     2.884    46.740     0.150
     2.884    82.541     0.150
     2.975    92.360     0.150
     2.975    92.208     0.150
     3.037    48.890     0.150
     3.037    49.020     0.150
     3.037    95.740     0.150
     3.037    86.480     0.150
     3.118    48.800     0.150
     3.121    50.450     0.150
     3.121    97.910     0.150
     3.218    51.540     0.150
     3.218    88.770     0.150
     3.218   102.260     0.150
     3.218    90.350     0.150
     3.238    89.290     0.150
     3.317    51.930     0.150
     3.317    91.390     0.150
     3.317   104.150     0.150
     3.317    52.100     0.150
     3.317    91.516     0.150
     3.341    60.480     0.150
     3.341    51.910     0.150
     3.341    90.900     0.150
     3.341    51.480     0.150
     3.341    91.690     0.150
     3.416    53.980     0.150
     3.416    94.574     0.150
     3.416    53.510     0.150
     3.416    54.172     0.150
     3.445    55.010     0.150
     3.506    55.960     0.150
     3.635    57.440     0.150
     3.635    57.320     0.150
     3.635    98.390     0.150
     3.781    59.170     0.150
     3.819    59.700     0.150
     3.819    60.080     0.150
     3.819   103.640     0.150
     3.819   119.350     0.150
     3.819   104.895     0.150
     3.853    60.520     0.150
     3.853    60.203     0.150
     3.872    60.470     0.150
     3.926    60.810     0.150
     3.926   105.840     0.150
     3.926   106.682     0.150
     4.072    62.470     0.150
     4.072    62.330     0.150
     4.072   126.970     0.150
     4.165    64.270     0.150
     4.165   113.283     0.150
     4.330   116.503     0.150
     4.383   116.340     0.150
     4.383   137.240     0.150
     4.376    67.380     0.150
     4.565    69.530     0.150
     4.609    70.720     0.150
     4.670    71.530     0.150
     4.670   123.670     0.150
     4.670   146.460     0.150
     4.670    71.348     0.150
     4.676    72.150     0.150
     4.676    72.049     0.150
     4.676   125.788     0.150
     4.676   126.150     0.150
     4.676   146.930     0.150
     4.754    72.800     0.150
     4.875   151.140     0.150
     5.155   159.680     0.150
     5.255    79.520     0.150
     5.255    80.460     0.150
     5.287    80.730     0.150
     5.287    80.850     0.150
     5.287   140.450     0.150
     5.318    80.160     0.150
     5.318    80.900     0.150
     5.318   140.740     0.150
     5.436    81.370     0.150
     5.554    83.800     0.150
     5.554   173.800     0.150
     6.110    90.860     0.150
     6.110   157.820     0.150
     6.110    90.632     0.150
     6.138    91.790     0.150
     6.138   190.380     0.150
     6.168    91.760     0.150
     6.168   193.390     0.150
     7.182   105.491     0.150
     0.449     9.057     0.150
     0.449    15.537     0.150
     0.485     9.404     0.150
     0.485    15.908     0.150
     0.485     9.418     0.150
     0.485    16.188     0.150
     0.491     9.457     0.150
     0.491    16.168     0.150
     0.516    10.137     0.150
     0.516    17.238     0.150
     0.516    17.129     0.150
     0.677    13.598     0.150
     0.677    22.477     0.150
     0.717    14.088     0.150
     0.717    23.838     0.150
     0.717    24.037     0.150
     0.777    13.438     0.150
     0.802    14.668     0.150
     0.802    25.758     0.150
     0.781    15.518     0.150
     0.781    25.762     0.150
     0.780    14.768     0.150
     0.851    16.488     0.150
     0.851    28.887     0.150
     0.851    28.773     0.150
     0.851    28.998     0.150
     0.934    18.527     0.150
     1.011    18.637     0.150
     1.011    32.547     0.150
     1.014    18.488     0.150
     1.014    32.500     0.150
     1.117    21.977     0.150
     1.091    20.857     0.150
     1.091    35.234     0.150
     1.197    21.838     0.150
     1.210    23.557     0.150
     1.210    22.662     0.150
     1.210    23.707     0.150
     1.230    22.146     0.150
     1.230    22.033     0.150
     1.230    39.098     0.150
     1.230    39.227     0.150
     1.342    24.857     0.150
     1.342    42.820     0.150
     1.406    26.268     0.150
     1.406    46.295     0.150
     1.406    26.447     0.150
     1.406    45.627     0.150
     1.452    25.498     0.150
     1.452    45.137     0.150
     1.484    27.816     0.150
     1.484    47.646     0.150
     1.602    28.377     0.150
     1.602    50.658     0.150
     1.587    30.078     0.150
     1.587    51.078     0.150
     1.587    50.920     0.150
     1.624    28.928     0.150
     1.636    27.988     0.150
     1.645    30.307     0.150
     1.763    30.131     0.150
     1.763    56.881     0.150
     1.751    32.088     0.150
     1.751    55.617     0.150
     1.821    33.146     0.150
     1.867    34.088     0.150
     1.874    34.643     0.150
     1.874    60.643     0.150
     1.931    34.047     0.150
     1.931    33.312     0.150
     1.931    60.182     0.150
     1.894    34.158     0.150
     1.894    59.088     0.150
     2.048    36.807     0.150
     2.056    35.258     0.150
     2.074    37.928     0.150
     2.074    38.127     0.150
     2.074    68.371     0.150
     2.074    37.377     0.150
     2.074    66.498     0.150
     2.079    37.646     0.150
     2.079    65.926     0.150
     2.079    65.758     0.150
     2.127    37.877     0.150
     2.128    37.738     0.150
     2.128    65.357     0.150
     2.128    37.941     0.150
     2.128    67.033     0.150
     2.128    66.908     0.150
     2.219    39.896     0.150
     2.219    40.148     0.150
     2.219    70.764     0.150
     2.219    70.088     0.150
     2.297    39.678     0.150
     2.329    40.717     0.150
     2.330    40.098     0.150
     2.353    40.717     0.150
     2.353    42.299     0.150
     2.353    73.137     0.150
     2.473    42.227     0.150
     2.473    42.396     0.150
     2.528    43.018     0.150
     2.528    43.223     0.150
     2.528    74.963     0.150
     2.530    43.297     0.150
     2.524    43.768     0.150
     2.524    47.883     0.150
     2.524    44.088     0.150
     2.524    80.277     0.150
     2.552    42.938     0.150
     2.563    43.646     0.150
     2.563    44.475     0.150
     2.710    46.158     0.150
     2.710    46.461     0.150
     2.764    47.088     0.150
     2.764    46.488     0.150
     2.764    88.217     0.150
     2.836    47.768     0.150
     2.840    47.848     0.150
     2.825    86.979     0.150
     3.056    49.787     0.150
     3.024    50.508     0.150
     3.046    49.748     0.150
     3.046    49.998     0.150
     3.046    93.248     0.150
     3.061    51.078     0.150
     3.061    50.918     0.150
     3.061    96.658     0.150
     3.064    49.588     0.150
     3.064    50.004     0.150
     3.064    50.297     0.150
     3.064    95.998     0.150
     3.116    50.527     0.150
     3.153    50.896     0.150
     3.153    52.979     0.150
     3.268    53.867     0.150
     3.268    93.432     0.150
     3.262    52.877     0.150
     3.262    53.051     0.150
     3.262    52.598     0.150
     3.369    54.367     0.150
     3.369    53.725     0.150
     3.369    53.537     0.150
     3.369   104.578     0.150
     3.419    54.777     0.150
     3.435    53.488     0.150
     3.496    57.547     0.150
     3.496   109.418     0.150
     3.548    58.238     0.150
     3.548   112.547     0.150
     3.597    59.107     0.150
     3.597    58.814     0.150
     3.610   114.998     0.150
     3.639    59.338     0.150
     3.639    59.145     0.150
     3.639   104.787     0.150
     3.727    59.477     0.150
     3.786    61.207     0.150
     3.786   107.697     0.150
     3.930    61.707     0.150
     3.930    61.912     0.150
     4.009    64.127     0.150
     4.009    63.979     0.150
     3.989    63.057     0.150
     3.989   125.457     0.150
     4.105    65.467     0.150
     4.105    65.174     0.150
     4.332    68.020     0.150
     4.413    69.938     0.150
     4.413    70.305     0.150
     4.413   139.807     0.150
     4.442    69.438     0.150
     4.442    69.652     0.150
     4.460    69.980     0.150
     4.463    69.848     0.150
     4.475    69.777     0.150
     4.475    70.195     0.150
     4.459   120.297     0.150
     4.459   138.838     0.150
     4.728    73.238     0.150
     4.790    73.457     0.150
     4.971    77.277     0.150
     4.973    78.066     0.150
     4.973    78.488     0.150
     4.973   137.977     0.150
     5.025    78.008     0.150
     5.018    78.328     0.150
     5.018    78.547     0.150
     5.018   138.828     0.150
     5.029    78.738     0.150
     5.029   139.178     0.150
     5.029   157.098     0.150
     5.150    81.357     0.150
     5.265    82.566     0.150
     5.265   144.117     0.150
     5.268    80.008     0.150
     5.295    81.646     0.150
     5.271   164.396     0.150
     5.376   170.008     0.150
     5.500    82.857     0.150
     5.500    82.727     0.150
     5.605    84.717     0.150
     5.610    86.578     0.150
     5.610   177.547     0.150
     5.699    85.137     0.150
     5.826    88.918     0.150
     5.826   156.797     0.150
     5.878    90.488     0.150
     5.878   158.287     0.150
     5.882    90.777     0.150
     5.882   185.938     0.150
     5.926    88.967     0.150
     5.980    90.717     0.150
     5.970   184.207     0.150
     6.460   173.066     0.150
     6.533   174.518     0.150
     6.716   100.816     0.150
     6.732   101.848     0.150
     6.732   101.217     0.150
     6.773   101.217     0.150
     6.778   102.328     0.150
     6.918   104.498     0.150
     7.206   106.467     0.150
     7.281   108.707     0.150
     7.746   114.047     0.150
     7.981   119.107     0.150
     8.291   121.377     0.150
     0.370     7.680     0.150
     0.370    12.842     0.150
     0.370     7.691     0.150
     0.370    13.081     0.150
     0.499     9.709     0.150
     0.499    16.304     0.150
     0.499    16.892     0.150
     0.567    10.727     0.150
     0.567    17.937     0.150
     0.567    18.071     0.150
     0.616    12.602     0.150
     0.616    21.111     0.150
     0.770    15.102     0.150
     0.770    25.331     0.150
     0.814    14.751     0.150
     0.814    26.271     0.150
     0.930    16.882     0.150
     0.932    18.259     0.150
     0.932    30.690     0.150
     0.932    30.491     0.150
     1.066    20.081     0.150
     1.066    34.266     0.150
     1.097    19.793     0.150
     1.097    34.564     0.150
     1.097    33.731     0.150
     1.145    20.941     0.150
     1.145    35.121     0.150
     1.147    21.035     0.150
     1.147    36.917     0.150
     1.192    22.388     0.150
     1.192    39.146     0.150
     1.192    38.491     0.150
     1.182    22.114     0.150
     1.182    38.287     0.150
     1.182    22.222     0.150
     1.182    38.182     0.150
     1.197    21.201     0.150
     1.197    37.171     0.150
     1.311    25.116     0.150
     1.311    42.851     0.150
     1.311    25.231     0.150
     1.311    42.231     0.150
     1.236    23.941     0.150
     1.236    39.361     0.150
     1.306    24.191     0.150
     1.306    41.857     0.150
     1.306    41.102     0.150
     1.547    27.111     0.150
     1.547    47.722     0.150
     1.614    29.605     0.150
     1.614    51.731     0.150
     1.614    29.901     0.150
     1.614    51.102     0.150
     1.685    31.062     0.150
     1.685    53.392     0.150
     1.721    30.781     0.150
     1.721    54.102     0.150
     1.732    30.546     0.150
     1.732    54.312     0.150
     1.732    31.392     0.150
     1.732    54.191     0.150
     1.803    32.151     0.150
     1.803    56.405     0.150
     1.824    32.039     0.150
     1.824    56.802     0.150
     2.054    35.712     0.150
     2.054    62.971     0.150
     2.242    66.880     0.150
     2.272    70.602     0.150
     2.282    38.725     0.150
     2.282    41.201     0.150
     2.287    39.197     0.150
     2.287    67.409     0.150
     2.287    67.262     0.150
     2.362    39.821     0.150
     2.362    69.701     0.150
     2.362    69.451     0.150
     2.412    40.821     0.150
     2.595    42.533     0.150
     2.595    74.850     0.150
     2.708    44.271     0.150
     2.708    44.791     0.150
     2.708    77.901     0.150
     2.708    86.211     0.150
     2.739    44.609     0.150
     2.821    46.141     0.150
     2.921    91.102     0.150
     2.972    48.751     0.150
     2.972    93.302     0.150
     2.972    49.012     0.150
     2.972    83.401     0.150
     2.972    93.861     0.150
     3.015    47.435     0.150
     3.015    93.723     0.150
     3.015    47.052     0.150
     3.015    94.161     0.150
     3.043    95.496     0.150
     3.043    49.361     0.150
     3.043    95.682     0.150
     3.192    89.521     0.150
     3.192    88.812     0.150
     3.320    52.741     0.150
     3.320    92.347     0.150
     3.320    92.802     0.150
     3.320   102.911     0.150
     3.358    53.277     0.150
     3.358    93.945     0.150
     3.755    59.695     0.150
     3.755    59.871     0.150
     3.755   102.251     0.150
     3.755   118.171     0.150
     3.854    60.578     0.150
     3.854    60.682     0.150
     3.854   104.451     0.150
     3.920   122.461     0.150
     3.994    62.052     0.150
     3.994   125.071     0.150
     4.421   135.812     0.150
     4.616    71.688     0.150
     4.616    71.882     0.150
     4.616   123.921     0.150
     4.616   146.021     0.150
     4.931   154.722     0.150
     5.224    80.741     0.150
     5.224   139.121     0.150
     5.244    80.491     0.150
     5.244   139.842     0.150
     5.478   171.352     0.150
     6.040   157.571     0.150
     6.040   189.642     0.150
     6.081   158.831     0.150
     6.081   190.861     0.150
     6.092   191.161     0.150
     7.122   183.241     0.150
     0.269     5.305     0.150
     0.269     9.082     0.150
     0.269     5.311     0.150
     0.269     8.988     0.150
     0.512    10.680     0.150
     0.512    17.391     0.150
     0.577    10.855     0.150
     0.577    17.547     0.150
     0.577    17.898     0.150
     0.603    11.570     0.150
     0.603    20.141     0.150
     0.603    19.918     0.150
     0.866    16.000     0.150
     0.866    28.430     0.150
     0.871    16.980     0.150
     0.871    29.488     0.150
     1.011    19.758     0.150
     1.011    33.258     0.150
     1.011    19.988     0.150
     1.011    33.918     0.150
     1.080    20.160     0.150
     1.080    35.309     0.150
     1.082    21.293     0.150
     1.082    34.965     0.150
     1.076    20.648     0.150
     1.076    35.406     0.150
     1.076    35.719     0.150
     1.112    20.281     0.150
     1.112    35.852     0.150
     1.178    21.457     0.150
     1.178    37.590     0.150
     1.366    26.371     0.150
     1.366    45.164     0.150
     1.366    45.352     0.150
     1.279    24.324     0.150
     1.279    42.324     0.150
     1.279    41.219     0.150
     1.318    25.660     0.150
     1.318    43.441     0.150
     1.408    26.328     0.150
     1.408    45.898     0.150
     1.408    26.539     0.150
     1.408    45.520     0.150
     1.464    26.250     0.150
     1.464    45.430     0.150
     1.605    29.969     0.150
     1.605    30.168     0.150
     1.605    53.129     0.150
     1.647    29.988     0.150
     1.647    52.852     0.150
     1.664    31.000     0.150
     1.664    54.531     0.150
     1.732    31.270     0.150
     1.814    33.773     0.150
     1.814    57.867     0.150
     1.814    34.359     0.150
     1.814    58.441     0.150
     1.906    34.758     0.150
     2.272    40.754     0.150
     2.272    73.449     0.150
     2.272    72.871     0.150
     2.335    41.094     0.150
     2.335    71.016     0.150
     2.335    41.621     0.150
     2.335    72.102     0.150
     2.327    41.582     0.150
     2.327    71.324     0.150
     2.327    41.758     0.150
     2.327    72.281     0.150
     2.382    42.160     0.150
     2.382    42.352     0.150
     2.465    42.320     0.150
     2.465    74.543     0.150
     2.465    42.949     0.150
     2.465    75.570     0.150
     2.502    42.184     0.150
     2.502    74.930     0.150
     2.692    46.043     0.150
     2.692    80.367     0.150
     2.742    46.535     0.150
     2.771    89.012     0.150
     2.771    47.988     0.150
     2.771    88.570     0.150
     3.011    87.984     0.150
     3.011    51.398     0.150
     3.011    88.699     0.150
     3.011    96.891     0.150
     3.024    50.219     0.150
     3.272    53.199     0.150
     3.272   101.078     0.150
     3.281    53.969     0.150
     3.281    95.230     0.150
     3.422    55.840     0.150
     3.422    96.879     0.150
     3.796    62.539     0.150
     3.796   106.352     0.150
     3.859   109.539     0.150
     3.872    62.500     0.150
     3.872   108.531     0.150
     3.981    63.930     0.150
     3.981   110.758     0.150
     4.521   122.852     0.150
     4.662    74.789     0.150
     4.662   127.918     0.150
     5.212   142.809     0.150
     5.257    82.039     0.150
     5.257   144.699     0.150
     5.266    82.520     0.150
     5.266   145.078     0.150
     6.064    92.910     0.150
     6.064   161.488     0.150
     6.771   179.641     0.150
     7.167   107.898     0.150
     7.167   187.801     0.150
     0.446     8.477     0.150
     0.446    13.906     0.150
     0.438     8.562     0.150
     0.438    14.570     0.150
     0.438     8.695     0.150
     0.438    15.164     0.150
     0.446     9.398     0.150
     0.446    15.648     0.150
     0.700    14.062     0.150
     0.747    15.008     0.150
     0.747    25.648     0.150
     0.936    17.242     0.150
     0.936    31.258     0.150
     0.961    17.672     0.150
     0.961    30.930     0.150
     0.974    19.422     0.150
     0.974    32.766     0.150
     0.974    32.117     0.150
     1.073    19.422     0.150
     1.173    22.477     0.150
     1.173    38.500     0.150
     1.214    23.016     0.150
     1.214    39.789     0.150
     1.214    23.203     0.150
     1.214    39.336     0.150
     1.190    22.867     0.150
     1.190    39.211     0.150
     1.190    23.086     0.150
     1.285    24.062     0.150
     1.285    43.008     0.150
     1.285    23.664     0.150
     1.288    23.266     0.150
     1.288    41.836     0.150
     1.290    22.961     0.150
     1.290    42.188     0.150
     1.388    26.891     0.150
     1.388    45.789     0.150
     1.388    27.016     0.150
     1.330    24.328     0.150
     1.330    42.586     0.150
     1.681    29.758     0.150
     1.681    53.328     0.150
     1.749    33.039     0.150
     1.749    55.562     0.150
     1.749    32.844     0.150
     1.749    55.758     0.150
     1.760    31.781     0.150
     1.760    56.211     0.150
     1.758    33.461     0.150
     1.758    56.656     0.150
     1.758    56.773     0.150
     1.824    33.812     0.150
     1.824    58.242     0.150
     1.861    33.742     0.150
     1.861    60.305     0.150
     2.195    39.039     0.150
     2.195    69.672     0.150
     2.195    39.156     0.150
     2.195    69.273     0.150
     2.302    39.773     0.150
     2.302    69.227     0.150
     2.302    70.008     0.150
     2.380    41.570     0.150
     2.380    42.008     0.150
     2.380    72.703     0.150
     2.555    44.758     0.150
     2.555    80.242     0.150
     2.704    45.203     0.150
     2.718    45.219     0.150
     2.718    79.766     0.150
     2.784    47.016     0.150
     2.768    46.680     0.150
     2.768    87.781     0.150
     2.768    47.023     0.150
     2.768    87.625     0.150
     2.908    83.312     0.150
     2.908    91.203     0.150
     2.958    92.438     0.150
     3.065    51.648     0.150
     3.065    97.648     0.150
     3.284   101.984     0.150
     3.284    93.602     0.150
     3.284   102.547     0.150
     3.275    53.133     0.150
     3.275   102.922     0.150
     3.845    62.242     0.150
     3.845   108.148     0.150
     3.845   122.367     0.150
     3.967    63.719     0.150
     4.129   129.562     0.150
     4.318   134.148     0.150
     4.699    74.766     0.150
     4.699   129.023     0.150
     4.699   148.094     0.150
     4.802   149.375     0.150
     5.312    83.578     0.150
     5.312   145.812     0.150
     5.362    83.742     0.150
     5.362   147.438     0.150
     6.147   162.617     0.150
     6.156    94.992     0.150
     0.249     5.203     0.150
     0.265     5.727     0.150
     0.265     9.820     0.150
     0.471    10.414     0.150
     0.471    17.867     0.150
     0.495     9.727     0.150
     0.495    16.719     0.150
     0.589    11.344     0.150
     0.589    19.938     0.150
     0.589    11.328     0.150
     0.589    20.305     0.150
     0.589    19.719     0.150
     0.766    14.062     0.150
     0.766    24.945     0.150
     0.766    24.391     0.150
     0.766    24.125     0.150
     0.808    15.453     0.150
     0.808    25.844     0.150
     0.849    16.508     0.150
     0.849    29.125     0.150
     0.849    28.688     0.150
     1.116    21.078     0.150
     1.116    35.945     0.150
     1.123    20.758     0.150
     1.123    20.867     0.150
     1.123    36.180     0.150
     1.123    36.383     0.150
     1.132    20.328     0.150
     1.132    36.164     0.150
     1.132    20.438     0.150
     1.132    36.055     0.150
     1.237    22.984     0.150
     1.237    39.586     0.150
     1.237    39.352     0.150
     1.237    39.203     0.150
     1.305    23.086     0.150
     1.305    40.953     0.150
     1.305    40.531     0.150
     1.420    25.547     0.150
     1.420    44.789     0.150
     1.420    25.719     0.150
     1.420    45.195     0.150
     1.431    25.883     0.150
     1.431    45.227     0.150
     1.431    45.492     0.150
     1.567    29.375     0.150
     1.483    26.086     0.150
     1.483    45.758     0.150
     1.483    25.828     0.150
     1.483    45.242     0.150
     1.519    26.586     0.150
     1.519    48.102     0.150
     1.519    26.742     0.150
     1.521    26.805     0.150
     1.521    47.844     0.150
     1.539    26.773     0.150
     1.539    47.758     0.150
     1.581    27.719     0.150
     1.701    30.117     0.150
     1.701    52.984     0.150
     1.738    29.984     0.150
     1.738    53.719     0.150
     1.744    30.242     0.150
     1.754    31.219     0.150
     1.754    31.328     0.150
     1.754    54.484     0.150
     1.864    32.688     0.150
     1.864    33.023     0.150
     1.864    58.203     0.150
     1.871    32.602     0.150
     1.871    57.438     0.150
     1.893    32.453     0.150
     1.893    32.969     0.150
     1.893    58.227     0.150
     1.929    32.883     0.150
     1.929    58.023     0.150
     1.986    35.672     0.150
     1.986    62.164     0.150
     1.986    34.797     0.150
     1.986    61.273     0.150
     1.989    35.031     0.150
     1.989    35.375     0.150
     1.989    61.336     0.150
     2.020    34.453     0.150
     2.065    35.812     0.150
     2.084    35.617     0.150
     2.084    63.664     0.150
     2.118    36.445     0.150
     2.138    63.648     0.150
     2.161    36.195     0.150
     2.260    38.367     0.150
     2.260    38.250     0.150
     2.260    37.406     0.150
     2.418    40.602     0.150
     2.418    40.969     0.150
     2.418    72.773     0.150
     2.466    40.273     0.150
     2.466    39.617     0.150
     2.506    41.484     0.150
     2.573    42.492     0.150
     2.573    47.797     0.150
     2.573    80.828     0.150
     2.576    42.898     0.150
     2.576    41.969     0.150
     2.576    79.062     0.150
     2.651    43.328     0.150
     2.764    44.531     0.150
     2.770    44.445     0.150
     2.770    85.906     0.150
     2.797    48.914     0.150
     2.805    45.094     0.150
     2.862    46.062     0.150
     2.895    46.812     0.150
     2.906    47.148     0.150
     2.916    46.266     0.150
     2.916    54.195     0.150
     2.916    91.273     0.150
     2.952    47.219     0.150
     3.192    49.883     0.150
     3.192    98.273     0.150
     3.256    51.523     0.150
     3.256    52.445     0.150
     3.256   101.438     0.150
     3.252    51.078     0.150
     3.252    51.625     0.150
     3.252   100.836     0.150
     3.269    51.523     0.150
     3.269    52.477     0.150
     3.269    52.703     0.150
     3.417    53.203     0.150
     3.414    53.969     0.150
     3.690    57.586     0.150
     4.031    62.953     0.150
     4.181    65.633     0.150
     4.181    64.875     0.150
     4.181   113.719     0.150
     4.185   128.883     0.150
     4.441    67.156     0.150
     4.612    69.406     0.150
     4.683    71.133     0.150
     4.683    71.844     0.150
     4.873    75.352     0.150
     4.873   152.523     0.150
     4.982    74.242     0.150
     5.135    76.727     0.150
     5.492    83.906     0.150
     5.492   169.922     0.150
     5.920    87.742     0.150
     0.497     9.984     0.150
     0.497    16.656     0.150
     0.497    17.000     0.150
     0.534    10.711     0.150
     0.534    18.922     0.150
     0.601    11.586     0.150
     0.601    19.836     0.150
     0.601    19.633     0.150
     0.681    12.898     0.150
     0.681    22.117     0.150
     0.681    13.188     0.150
     0.842    16.625     0.150
     0.842    28.344     0.150
     0.939    18.734     0.150
     0.939    31.102     0.150
     0.939    18.844     0.150
     0.939    31.508     0.150
     0.968    18.969     0.150
     0.968    32.117     0.150
     0.968    19.070     0.150
     0.968    32.352     0.150
     1.002    18.188     0.150
     1.004    18.219     0.150
     1.004    31.492     0.150
     1.090    20.398     0.150
     1.090    21.234     0.150
     1.090    36.812     0.150
     1.272    25.023     0.150
     1.272    42.672     0.150
     1.272    42.344     0.150
     1.239    22.477     0.150
     1.239    38.961     0.150
     1.234    23.992     0.150
     1.234    40.289     0.150
     1.408    49.164     0.150
     1.423    44.484     0.150
     1.423    25.781     0.150
     1.498    28.461     0.150
     1.498    49.133     0.150
     1.579    28.023     0.150
     1.560    29.141     0.150
     1.744    33.539     0.150
     1.744    57.758     0.150
     1.744    33.664     0.150
     1.744    56.430     0.150
     1.912    35.297     0.150
     1.912    61.336     0.150
     1.912    34.969     0.150
     1.880    33.914     0.150
     1.880    59.898     0.150
     2.224    40.078     0.150
     2.224    72.578     0.150
     2.224    39.930     0.150
     2.224    71.008     0.150
     2.282    41.031     0.150
     2.282    73.938     0.150
     2.282    41.492     0.150
     2.282    72.469     0.150
     2.279    41.141     0.150
     2.279    71.766     0.150
     2.279    40.688     0.150
     2.462    42.609     0.150
     2.462    74.031     0.150
     2.450    42.711     0.150
     2.450    76.016     0.150
     2.450    41.312     0.150
     2.450    75.305     0.150
     2.680    47.102     0.150
     2.681    46.570     0.150
     2.681    50.875     0.150
     2.681    85.781     0.150
     2.908    49.625     0.150
     2.908    92.875     0.150
     3.217   102.344     0.150
     3.693    60.430     0.150
     3.693   117.633     0.150
     4.562    73.344     0.150
     4.562    86.930     0.150
     4.562   144.000     0.150
     5.164   160.828     0.150
     6.034   188.930     0.150
     0.355     7.191     0.150
     0.355    12.430     0.150
     0.371     7.859     0.150
     0.371    13.383     0.150
     0.371     7.879     0.150
     0.371    13.301     0.150
     0.539    10.289     0.150
     0.539    17.539     0.150
     0.539    17.949     0.150
     0.533    10.109     0.150
     0.533    10.219     0.150
     0.533    17.406     0.150
     0.594    12.301     0.150
     0.652    12.238     0.150
     0.652    12.371     0.150
     0.652    20.793     0.150
     0.756    13.281     0.150
     0.780    15.180     0.150
     0.780    26.051     0.150
     0.780    25.730     0.150
     0.797    15.738     0.150
     0.797    28.078     0.150
     0.848    14.809     0.150
     0.848    14.988     0.150
     0.847    15.691     0.150
     0.847    28.379     0.150
     0.899    17.578     0.150
     0.899    29.820     0.150
     0.983    18.629     0.150
     0.983    32.148     0.150
     0.983    31.859     0.150
     0.983    32.031     0.150
     1.062    18.738     0.150
     1.065    18.746     0.150
     1.065    33.309     0.150
     1.127    19.531     0.150
     1.253    24.129     0.150
     1.253    40.609     0.150
     1.253    41.379     0.150
     1.156    22.000     0.150
     1.156    37.504     0.150
     1.175    21.141     0.150
     1.175    20.660     0.150
     1.175    38.191     0.150
     1.206    23.250     0.150
     1.206    39.129     0.150
     1.227    22.289     0.150
     1.368    24.141     0.150
     1.353    24.551     0.150
     1.353    43.176     0.150
     1.418    26.090     0.150
     1.436    26.371     0.150
     1.474    25.520     0.150
     1.517    25.918     0.150
     1.526    28.059     0.150
     1.526    48.891     0.150
     1.526    28.160     0.150
     1.595    29.059     0.150
     1.595    50.988     0.150
     1.599    28.648     0.150
     1.598    28.469     0.150
     1.638    28.699     0.150
     1.643    28.371     0.150
     1.643    50.531     0.150
     1.703    30.988     0.150
     1.703    53.598     0.150
     1.703    30.531     0.150
     1.703    53.738     0.150
     1.762    30.129     0.150
     1.762    55.199     0.150
     1.785    30.359     0.150
     1.796    31.828     0.150
     1.817    31.898     0.150
     1.817    56.762     0.150
     1.817    56.461     0.150
     1.825    32.469     0.150
     1.825    32.172     0.150
     1.830    32.289     0.150
     1.861    32.949     0.150
     1.861    32.148     0.150
     1.861    57.043     0.150
     1.861    31.930     0.150
     1.975    34.578     0.150
     1.975    34.465     0.150
     1.975    63.098     0.150
     2.078    36.020     0.150
     2.085    35.430     0.150
     2.155    36.789     0.150
     2.219    38.660     0.150
     2.219    38.309     0.150
     2.219    66.602     0.150
     2.219    38.488     0.150
     2.229    38.379     0.150
     2.229    67.125     0.150
     2.229    38.488     0.150
     2.297    38.820     0.150
     2.323    40.059     0.150
     2.323    39.691     0.150
     2.323    39.879     0.150
     2.334    39.398     0.150
     2.336    39.141     0.150
     2.336    38.961     0.150
     2.336    68.500     0.150
     2.385    39.988     0.150
     2.385    39.809     0.150
     2.385    71.074     0.150
     2.385    70.480     0.150
     2.419    40.141     0.150
     2.419    39.969     0.150
     2.419    71.086     0.150
     2.502    41.441     0.150
     2.531    41.969     0.150
     2.531    41.652     0.150
     2.531    74.434     0.150
     2.534    41.609     0.150
     2.650    43.840     0.150
     2.650    43.547     0.150
     2.650    83.164     0.150
     2.658    44.539     0.150
     2.658    44.207     0.150
     2.658    84.176     0.150
     2.658    44.398     0.150
     2.658    49.551     0.150
     2.658    84.020     0.150
     2.734    45.211     0.150
     2.745    45.512     0.150
     2.745    45.148     0.150
     2.745    45.262     0.150
     2.758    85.172     0.150
     2.904    47.770     0.150
     2.904    48.113     0.150
     2.904    91.480     0.150
     2.904    48.281     0.150
     2.904    54.141     0.150
     2.904    91.828     0.150
     2.951    48.230     0.150
     2.954    47.910     0.150
     2.954    47.699     0.150
     2.954    92.547     0.150
     2.937    47.512     0.150
     2.937    47.926     0.150
     2.998    46.762     0.150
     2.998    46.480     0.150
     3.036    48.410     0.150
     3.036    48.227     0.150
     3.036    94.020     0.150
     3.069    48.418     0.150
     3.069    85.605     0.150
     3.069    48.051     0.150
     3.172    51.871     0.150
     3.172    99.609     0.150
     3.172    51.691     0.150
     3.172    59.020     0.150
     3.172    99.320     0.150
     3.249    52.918     0.150
     3.249    52.801     0.150
     3.249    93.203     0.150
     3.249    52.680     0.150
     3.289    52.539     0.150
     3.289    92.520     0.150
     3.333    53.020     0.150
     3.333    53.125     0.150
     3.327    52.289     0.150
     3.327    92.852     0.150
     3.381    52.738     0.150
     3.381    52.168     0.150
     3.407    53.738     0.150
     3.409    52.039     0.150
     3.404    53.238     0.150
     3.404    53.113     0.150
     3.404   106.336     0.150
     3.404    52.891     0.150
     3.601   100.242     0.150
     3.639    57.629     0.150
     3.639    57.922     0.150
     3.688    59.230     0.150
     3.688    59.363     0.150
     3.688   102.793     0.150
     3.719    57.699     0.150
     3.719    58.086     0.150
     3.775    60.020     0.150
     3.775   104.773     0.150
     3.855    60.348     0.150
     3.891    59.770     0.150
     3.906    61.160     0.150
     3.906    61.371     0.150
     3.906   121.098     0.150
     3.948    61.230     0.150
     3.948    61.000     0.150
     3.963    62.039     0.150
     3.963    61.289     0.150
     3.963    61.441     0.150
     3.981    61.262     0.150
     3.981    61.121     0.150
     3.981   108.699     0.150
     3.981    60.820     0.150
     4.035    62.980     0.150
     4.035    62.707     0.150
     4.035   111.051     0.150
     4.202    64.809     0.150
     4.209    65.238     0.150
     4.209    65.602     0.150
     4.214    66.262     0.150
     4.214    66.371     0.150
     4.322    66.469     0.150
     4.449    67.352     0.150
     4.449    68.344     0.150
     4.483    68.699     0.150
     4.483    68.227     0.150
     4.472    67.941     0.150
     4.472    67.840     0.150
     4.472   119.141     0.150
     4.505    68.809     0.150
     4.505    68.980     0.150
     4.542    70.270     0.150
     4.542    70.500     0.150
     4.552    71.102     0.150
     4.552    70.926     0.150
     4.587    70.648     0.150
     4.587    70.754     0.150
     4.610    70.969     0.150
     4.610    70.734     0.150
     4.745    72.199     0.150
     4.801    73.238     0.150
     4.801    73.375     0.150
     4.896    74.270     0.150
     4.951    75.445     0.150
     5.001    75.664     0.150
     5.021    75.230     0.150
     5.072    77.449     0.150
     5.072    76.859     0.150
     5.111    78.109     0.150
     5.111    78.590     0.150
     5.111   138.301     0.150
     5.157    79.781     0.150
     5.157    79.297     0.150
     5.157    79.590     0.150
     5.163    78.852     0.150
     5.163    78.574     0.150
     5.163    78.730     0.150
     5.270    80.398     0.150
     5.270    80.164     0.150
     5.270    80.520     0.150
     5.264    78.180     0.150
     5.264    79.113     0.150
     5.296    80.031     0.150
     5.296    79.742     0.150
     5.393    82.430     0.150
     5.393    82.004     0.150
     5.393    81.262     0.150
     5.527    84.391     0.150
     5.543    83.469     0.150
     5.543    84.234     0.150
     5.593    82.281     0.150
     5.593    83.359     0.150
     5.877    85.762     0.150
     5.884    87.391     0.150
     5.964    89.711     0.150
     5.964    89.441     0.150
     5.964   155.500     0.150
     5.995    89.891     0.150
     5.995    89.375     0.150
     6.007    90.277     0.150
     6.067    91.281     0.150
     6.130    90.102     0.150
     6.238    93.988     0.150
     6.524    97.699     0.150
     6.595    99.156     0.150
     6.657   100.191     0.150
     6.671    98.430     0.150
     6.727   100.129     0.150
     6.727    99.609     0.150
     6.851   101.059     0.150
     6.871   102.051     0.150
     6.871   101.715     0.150
     6.918   102.961     0.150
     6.940   102.387     0.150
     7.057   104.000     0.150
     7.057   104.387     0.150
     7.057   104.500     0.150
     7.092   104.668     0.150
     7.137   104.879     0.150
     7.137   104.262     0.150
     7.172   105.078     0.150
     7.235   106.371     0.150
     7.235   106.527     0.150
     7.305   107.730     0.150
     7.305   108.324     0.150
     7.322   107.441     0.150
     7.322   107.730     0.150
     7.472   110.668     0.150
     7.477   110.160     0.150
     7.477   110.316     0.150
     7.572   111.500     0.150
     7.572   111.285     0.150
     7.674   113.965     0.150
     7.674   113.750     0.150
     7.735   111.379     0.150
     7.773   114.750     0.150
     7.773   115.051     0.150
     7.797   113.660     0.150
     7.797   114.848     0.150
     8.091   119.121     0.150
     8.091   120.223     0.150
     8.134   118.961     0.150
     8.333   121.430     0.150
     8.335   120.410     0.150
     8.335   122.176     0.150
     8.539   125.969     0.150
     8.552   124.793     0.150
     8.688   127.988     0.150
     8.688   128.250     0.150
     8.751   126.629     0.150
     8.900   130.488     0.150
     8.992   130.539     0.150
     9.230   132.766     0.150
     9.383   136.578     0.150
     0.134     3.772     0.150
     0.134     6.402     0.150
     0.310    10.220     0.150
     0.459     9.290     0.150
     0.459    15.368     0.150
     0.490    10.292     0.150
     0.516    10.252     0.150
     0.516    17.322     0.150
     0.516    17.451     0.150
     0.895    16.593     0.150
     0.895    28.361     0.150
     0.897    16.303     0.150
     0.897    16.193     0.150
     0.897    28.205     0.150
     0.998    18.452     0.150
     1.091    20.803     0.150
     1.091    35.456     0.150
     1.174    21.582     0.150
     1.220    22.232     0.150
     1.220    39.087     0.150
     1.259    23.433     0.150
     1.259    23.232     0.150
     1.259    40.300     0.150
     1.307    24.133     0.150
     1.307    23.990     0.150
     1.307    42.057     0.150
     1.326    24.405     0.150
     1.326    41.895     0.150
     1.387    25.312     0.150
     1.390    24.944     0.150
     1.390    43.965     0.150
     1.405    24.723     0.150
     1.518    28.652     0.150
     1.605    28.872     0.150
     1.611    28.303     0.150
     1.611    49.784     0.150
     1.749    30.862     0.150
     1.800    31.202     0.150
     1.815    31.832     0.150
     1.815    55.758     0.150
     1.887    32.822     0.150
     1.881    32.805     0.150
     1.864    32.292     0.150
     1.864    32.667     0.150
     1.864    56.942     0.150
     1.966    33.686     0.150
     2.005    34.093     0.150
     2.005    61.123     0.150
     2.028    34.582     0.150
     2.114    35.612     0.150
     2.114    35.961     0.150
     2.114    63.292     0.150
     2.202    36.633     0.150
     2.213    36.662     0.150
     2.284    37.902     0.150
     2.284    38.778     0.150
     2.284    67.551     0.150
     2.326    39.183     0.150
     2.326    68.595     0.150
     2.371    39.622     0.150
     2.338    39.183     0.150
     2.338    68.890     0.150
     2.470    40.603     0.150
     2.538    40.843     0.150
     2.538    41.393     0.150
     2.514    41.482     0.150
     2.514    41.865     0.150
     2.514    72.979     0.150
     2.595    41.832     0.150
     2.595    42.015     0.150
     2.595    79.692     0.150
     2.630    42.822     0.150
     2.681    44.112     0.150
     2.680    42.673     0.150
     2.680    43.742     0.150
     2.680    83.600     0.150
     2.774    44.405     0.150
     2.774    79.069     0.150
     2.891    46.202     0.150
     2.891    46.992     0.150
     2.891    82.049     0.150
     2.888    45.822     0.150
     2.888    45.662     0.150
     2.888    89.566     0.150
     2.999    47.162     0.150
     2.999    47.862     0.150
     2.999    85.176     0.150
     3.038    48.803     0.150
     3.038    49.039     0.150
     3.038    85.836     0.150
     3.030    48.232     0.150
     3.030    93.511     0.150
     3.199    51.374     0.150
     3.228    50.910     0.150
     3.308    51.562     0.150
     3.311    51.393     0.150
     3.311    51.822     0.150
     3.292    52.692     0.150
     3.292    52.928     0.150
     3.292    91.779     0.150
     3.292    51.162     0.150
     3.292    50.927     0.150
     3.292   101.075     0.150
     3.322    52.353     0.150
     3.322   102.518     0.150
     3.556    55.343     0.150
     3.556    55.514     0.150
     3.556    98.587     0.150
     3.547    56.252     0.150
     3.547   109.295     0.150
     3.614    56.772     0.150
     3.603    55.513     0.150
     3.630    56.542     0.150
     3.696    58.232     0.150
     3.696    58.394     0.150
     3.766    58.232     0.150
     3.766    58.343     0.150
     3.933    60.152     0.150
     3.933    61.327     0.150
     3.937    60.712     0.150
     3.937    62.236     0.150
     3.937   108.773     0.150
     3.978    62.883     0.150
     3.978    62.572     0.150
     3.990    63.232     0.150
     4.034    61.502     0.150
     4.104    63.992     0.150
     4.104    63.695     0.150
     4.262    65.252     0.150
     4.262    65.054     0.150
     4.307    65.832     0.150
     4.301    65.412     0.150
     4.301    65.125     0.150
     4.530    69.289     0.150
     4.565    69.292     0.150
     4.565    70.696     0.150
     4.578    69.282     0.150
     4.746    71.353     0.150
     4.744    71.412     0.150
     4.807    73.083     0.150
     4.829    74.143     0.150
     4.829    74.694     0.150
     4.889    74.183     0.150
     4.931    75.832     0.150
     4.945    74.522     0.150
     4.945    74.816     0.150
     5.002    76.643     0.150
     5.238    79.893     0.150
     5.444    83.112     0.150
     5.444    83.282     0.150
     5.499    82.996     0.150
     5.625    84.391     0.150
     6.283    93.483     0.150
     6.284    92.712     0.150
     6.284    93.893     0.150
     7.191   104.543     0.150
     7.171   105.520     0.150
     7.350   107.382     0.150
     7.335   106.902     0.150
     7.335   108.037     0.150
     7.435   109.032     0.150
     7.822   113.928     0.150
     8.104   118.471     0.150
     8.665   126.725     0.150
     0.392     7.988     0.150
     0.392    13.531     0.150
     0.449     8.488     0.150
     0.449    14.336     0.150
     0.487     9.887     0.150
     0.487    16.773     0.150
     0.749    14.262     0.150
     0.749    24.492     0.150
     0.997    19.773     0.150
     0.997    32.945     0.150
     1.002    18.074     0.150
     1.183    22.098     0.150
     1.183    38.711     0.150
     1.209    22.715     0.150
     1.209    39.480     0.150
     1.239    23.512     0.150
     1.259    23.629     0.150
     1.259    40.750     0.150
     1.256    22.508     0.150
     1.256    40.961     0.150
     1.401    27.035     0.150
     1.401    46.117     0.150
     1.705    30.414     0.150
     1.705    53.535     0.150
     1.735    32.395     0.150
     1.735    55.102     0.150
     1.786    33.137     0.150
     1.786    57.805     0.150
     1.802    32.461     0.150
     1.802    56.691     0.150
     1.905    33.664     0.150
     1.905    59.367     0.150
     2.158    37.438     0.150
     2.158    68.430     0.150
     2.197    66.637     0.150
     2.275    39.711     0.150
     2.346    40.121     0.150
     2.346    69.949     0.150
     2.388    41.262     0.150
     2.533    43.145     0.150
     2.675    44.520     0.150
     2.675    78.820     0.150
     2.733    45.133     0.150
     2.733    85.066     0.150
     2.788    46.266     0.150
     2.788    86.891     0.150
     2.919    47.770     0.150
     2.919    85.219     0.150
     2.954    92.543     0.150
     3.073    50.367     0.150
     3.073    96.645     0.150
     3.317   103.246     0.150
     3.329   103.129     0.150
     3.448    54.973     0.150
     3.448    97.219     0.150
     3.854    62.488     0.150
     3.854   107.258     0.150
     3.966    63.289     0.150
     4.711    74.277     0.150
     5.322    83.238     0.150
     0.311     6.509     0.150
     0.311    10.159     0.150
     0.311    10.266     0.150
     0.463     9.467     0.150
     0.463    15.855     0.150
     0.463     9.419     0.150
     0.463    16.029     0.150
     0.512    10.159     0.150
     0.512    17.600     0.150
     0.512    10.338     0.150
     0.726    14.319     0.150
     0.726    24.430     0.150
     0.826    16.060     0.150
     0.826    27.039     0.150
     0.894    16.199     0.150
     0.894    28.155     0.150
     0.896    17.009     0.150
     0.896    28.799     0.150
     1.001    18.409     0.150
     1.001    32.839     0.150
     1.042    19.569     0.150
     1.042    34.060     0.150
     1.089    20.969     0.150
     1.089    35.640     0.150
     1.176    21.539     0.150
     1.176    36.899     0.150
     1.216    22.299     0.150
     1.216    38.909     0.150
     1.216    22.432     0.150
     1.216    39.199     0.150
     1.256    23.469     0.150
     1.256    40.409     0.150
     1.256    23.359     0.150
     1.310    24.020     0.150
     1.310    42.039     0.150
     1.326    24.890     0.150
     1.326    42.009     0.150
     1.326    24.555     0.150
     1.376    26.089     0.150
     1.376    44.759     0.150
     1.389    25.549     0.150
     1.389    43.939     0.150
     1.392    25.481     0.150
     1.392    43.977     0.150
     1.408    24.659     0.150
     1.407    45.039     0.150
     1.517    28.989     0.150
     1.608    28.489     0.150
     1.608    49.229     0.150
     1.608    27.769     0.150
     1.608    49.628     0.150
     1.761    30.399     0.150
     1.761    53.930     0.150
     1.811    31.979     0.150
     1.811    56.049     0.150
     1.811    32.124     0.150
     1.817    31.159     0.150
     1.817    55.879     0.150
     1.861    32.779     0.150
     1.861    57.289     0.150
     1.861    32.949     0.150
     1.861    57.591     0.150
     1.882    33.100     0.150
     1.882    57.770     0.150
     1.882    33.292     0.150
     1.882    59.264     0.150
     1.953    33.729     0.150
     1.953    60.249     0.150
     1.954    34.159     0.150
     2.008    34.043     0.150
     2.008    61.786     0.150
     2.110    65.599     0.150
     2.286    39.009     0.150
     2.286    39.808     0.150
     2.286    69.527     0.150
     2.323    39.549     0.150
     2.323    68.779     0.150
     2.323    39.270     0.150
     2.334    39.379     0.150
     2.334    69.009     0.150
     2.513    42.680     0.150
     2.513    47.751     0.150
     2.550    46.829     0.150
     2.777    44.374     0.150
     2.884    51.850     0.150
     3.041    49.499     0.150
     3.198    52.299     0.150
     3.198    51.242     0.150
     3.977    63.079     0.150
     4.103    64.729     0.150
     4.720    72.709     0.150
     4.827    74.869     0.150
     5.442    84.079     0.150
     7.333   108.344     0.150
     0.320     6.418     0.150
     0.320    10.546     0.150
     0.461     9.198     0.150
     0.461    15.434     0.150
     0.506    10.243     0.150
     0.506    17.350     0.150
     0.887    16.735     0.150
     0.887    28.877     0.150
     0.897    16.300     0.150
     0.897    27.851     0.150
     1.080    20.815     0.150
     1.080    35.428     0.150
     1.214    22.490     0.150
     1.214    39.063     0.150
     1.249    23.024     0.150
     1.249    40.052     0.150
     1.309    23.869     0.150
     1.309    41.690     0.150
     1.316    24.670     0.150
     1.316    41.673     0.150
     1.385    24.672     0.150
     1.385    43.719     0.150
     1.507    28.696     0.150
     1.611    49.786     0.150
     1.806    31.960     0.150
     1.806    56.275     0.150
     1.853    32.847     0.150
     1.853    57.311     0.150
     1.872    59.018     0.150
     2.280    38.108     0.150
     2.280    69.821     0.150
     2.331    38.934     0.150
     3.188    52.123     0.150
     3.967    62.948     0.150
     4.093    64.682     0.150
     4.818    74.940     0.150
     5.433    83.684     0.150
     7.324   108.774     0.150
     0.136     3.605     0.150
     0.315     6.467     0.150
     0.315     6.316     0.150
     0.315    10.656     0.150
     0.315    10.482     0.150
     0.460     9.385     0.150
     0.460    16.299     0.150
     0.460     9.346     0.150
     0.460    16.047     0.150
     0.511    10.217     0.150
     0.511    17.605     0.150
     0.511    10.096     0.150
     0.511    10.393     0.150
     0.723    14.486     0.150
     0.723    25.637     0.150
     0.723    24.605     0.150
     0.824    16.057     0.150
     0.824    27.365     0.150
     0.824    27.115     0.150
     0.891    16.846     0.150
     0.891    28.775     0.150
     0.891    16.646     0.150
     0.891    28.967     0.150
     0.881    17.285     0.150
     0.881    30.256     0.150
     0.897    16.326     0.150
     0.897    16.207     0.150
     0.897    28.057     0.150
     0.897    27.869     0.150
     0.997    18.127     0.150
     0.997    18.436     0.150
     0.997    31.936     0.150
     1.039    19.496     0.150
     1.039    33.877     0.150
     1.086    20.967     0.150
     1.086    35.627     0.150
     1.171    21.516     0.150
     1.171    21.396     0.150
     1.171    36.977     0.150
     1.217    22.506     0.150
     1.217    38.986     0.150
     1.217    22.166     0.150
     1.217    39.244     0.150
     1.254    23.615     0.150
     1.254    40.297     0.150
     1.254    23.316     0.150
     1.254    40.652     0.150
     1.247    22.977     0.150
     1.321    24.666     0.150
     1.321    41.586     0.150
     1.321    42.176     0.150
     1.308    23.986     0.150
     1.308    42.137     0.150
     1.374    25.906     0.150
     1.374    43.707     0.150
     1.385    24.916     0.150
     1.385    25.076     0.150
     1.385    42.855     0.150
     1.387    25.125     0.150
     1.387    44.201     0.150
     1.403    26.355     0.150
     1.403    45.006     0.150
     1.513    28.676     0.150
     1.513    28.803     0.150
     1.404    24.236     0.150
     1.404    24.627     0.150
     1.449    25.627     0.150
     1.567    49.986     0.150
     1.604    28.285     0.150
     1.611    28.547     0.150
     1.611    49.836     0.150
     1.611    28.246     0.150
     1.611    49.379     0.150
     1.616    28.766     0.150
     1.757    30.047     0.150
     1.757    54.217     0.150
     1.750    30.596     0.150
     1.750    55.406     0.150
     1.811    31.846     0.150
     1.811    55.676     0.150
     1.811    32.047     0.150
     1.811    55.512     0.150
     1.801    31.207     0.150
     1.812    31.346     0.150
     1.812    31.176     0.150
     1.812    55.896     0.150
     1.859    32.566     0.150
     1.859    32.887     0.150
     1.859    57.307     0.150
     1.859    56.918     0.150
     1.877    33.066     0.150
     1.877    58.676     0.150
     1.886    32.285     0.150
     1.949    34.066     0.150
     1.949    61.105     0.150
     1.948    33.986     0.150
     1.948    33.605     0.150
     1.948    60.217     0.150
     1.968    33.797     0.150
     1.968    33.928     0.150
     1.968    61.738     0.150
     1.991    33.727     0.150
     1.999    34.346     0.150
     2.005    34.377     0.150
     2.005    62.102     0.150
     2.027    34.195     0.150
     2.113    35.775     0.150
     2.113    35.982     0.150
     2.113    65.438     0.150
     2.214    37.686     0.150
     2.214    66.916     0.150
     2.282    38.396     0.150
     2.282    38.695     0.150
     2.282    68.105     0.150
     2.282    38.502     0.150
     2.282    67.537     0.150
     2.321    39.105     0.150
     2.321    39.426     0.150
     2.321    39.596     0.150
     2.321    68.299     0.150
     2.316    39.217     0.150
     2.335    39.307     0.150
     2.335    69.566     0.150
     2.335    68.564     0.150
     2.370    39.297     0.150
     2.509    42.166     0.150
     2.509    42.057     0.150
     2.509    80.266     0.150
     2.509    41.926     0.150
     2.509    73.795     0.150
     2.545    43.316     0.150
     2.545    81.365     0.150
     2.539    41.756     0.150
     2.539    41.518     0.150
     2.598    42.467     0.150
     2.598    42.139     0.150
     2.598    79.809     0.150
     2.628    42.457     0.150
     2.676    43.996     0.150
     2.676    83.801     0.150
     2.711    43.865     0.150
     2.711    43.676     0.150
     2.711    83.637     0.150
     2.735    44.086     0.150
     2.774    44.586     0.150
     2.774    78.781     0.150
     2.885    47.025     0.150
     2.885    47.387     0.150
     2.885    47.197     0.150
     2.885    82.045     0.150
     2.886    45.887     0.150
     2.886    46.057     0.150
     2.886    80.826     0.150
     2.886    80.932     0.150
     2.996    47.666     0.150
     2.996    47.957     0.150
     2.996    47.838     0.150
     2.996    84.941     0.150
     3.031    48.627     0.150
     3.031    47.855     0.150
     3.031    48.074     0.150
     3.031    93.322     0.150
     3.037    48.877     0.150
     3.037    49.227     0.150
     3.037    86.807     0.150
     3.037    49.021     0.150
     3.037    85.697     0.150
     3.088    49.355     0.150
     3.194    51.457     0.150
     3.194    51.566     0.150
     3.194    99.686     0.150
     3.229    51.217     0.150
     3.229    51.072     0.150
     3.229    96.801     0.150
     3.288    52.797     0.150
     3.288    53.166     0.150
     3.288    91.506     0.150
     3.288   104.127     0.150
     3.288    92.668     0.150
     3.290    51.346     0.150
     3.290    50.967     0.150
     3.290    90.615     0.150
     3.290   101.816     0.150
     3.290   101.311     0.150
     3.307    59.762     0.150
     3.307   103.240     0.150
     3.318    52.656     0.150
     3.318    52.307     0.150
     3.318   103.035     0.150
     3.318   102.766     0.150
     3.364    52.797     0.150
     3.555    55.695     0.150
     3.555    98.164     0.150
     3.600    56.576     0.150
     3.600    99.406     0.150
     3.586    55.826     0.150
     3.691    58.086     0.150
     3.691    58.797     0.150
     3.691   115.457     0.150
     3.691    58.264     0.150
     3.691   101.584     0.150
     3.765    58.807     0.150
     3.765   118.195     0.150
     3.936    61.756     0.150
     3.936   108.713     0.150
     3.933    61.285     0.150
     3.933    61.467     0.150
     3.973    62.717     0.150
     3.973    62.826     0.150
     3.973   107.926     0.150
     3.973   108.344     0.150
     3.984    63.195     0.150
     3.984   126.006     0.150
     3.984    63.059     0.150
     3.984   109.486     0.150
     4.036    61.707     0.150
     4.036   108.584     0.150
     4.099    63.936     0.150
     4.099    63.781     0.150
     4.099   112.262     0.150
     4.257    65.316     0.150
     4.257   114.570     0.150
     4.300    65.346     0.150
     4.300   132.717     0.150
     4.300   115.592     0.150
     4.306    65.877     0.150
     4.306    65.980     0.150
     4.306   116.932     0.150
     4.468    68.189     0.150
     4.468   119.807     0.150
     4.520   122.432     0.150
     4.530    69.166     0.150
     4.530   136.760     0.150
     4.561    69.127     0.150
     4.575    71.035     0.150
     4.690   125.338     0.150
     4.719    72.355     0.150
     4.719    72.637     0.150
     4.719   147.605     0.150
     4.719   125.434     0.150
     4.745    72.400     0.150
     4.745   126.951     0.150
     4.806    73.207     0.150
     4.806   129.412     0.150
     4.823    74.436     0.150
     4.823   129.865     0.150
     4.823   151.836     0.150
     4.823   130.463     0.150
     4.885    74.676     0.150
     4.940    74.377     0.150
     4.940    74.545     0.150
     5.045    75.477     0.150
     5.238    79.734     0.150
     5.254    79.633     0.150
     5.438    83.275     0.150
     5.438    83.717     0.150
     5.438    82.986     0.150
     5.432    81.275     0.150
     5.494    82.826     0.150
     5.494    84.717     0.150
     5.621    84.736     0.150
     5.658    84.973     0.150
     6.245    93.807     0.150
     6.248    93.205     0.150
     6.278    94.826     0.150
     6.278    94.615     0.150
     6.278    94.477     0.150
     6.278    94.002     0.150
     7.165   106.365     0.150
     7.165   105.732     0.150
     7.330   108.176     0.150
     7.820   115.127     0.150
     7.820   115.650     0.150
     7.822   115.256     0.150
     7.890   116.475     0.150
     8.102   119.234     0.150
     0.305     9.975     0.150
     0.305     5.836     0.150
     0.353     6.975     0.150
     0.353    11.645     0.150
     0.516    10.346     0.150
     0.516    17.266     0.150
     0.516    10.131     0.150
     0.516    17.055     0.150
     0.520    10.645     0.150
     0.520    19.256     0.150
     0.607    11.545     0.150
     0.607    19.545     0.150
     0.660    12.795     0.150
     0.660    12.541     0.150
     0.685    12.715     0.150
     0.701    14.494     0.150
     0.701    25.045     0.150
     0.773    15.375     0.150
     0.773    26.916     0.150
     0.789    14.836     0.150
     0.799    14.734     0.150
     0.960    19.045     0.150
     0.960    18.828     0.150
     0.973    18.936     0.150
     0.992    19.225     0.150
     0.992    32.693     0.150
     1.013    19.516     0.150
     1.016    18.250     0.150
     1.064    19.865     0.150
     1.081    20.734     0.150
     1.081    36.965     0.150
     1.081    21.193     0.150
     1.081    37.131     0.150
     1.156    22.445     0.150
     1.296    25.309     0.150
     1.296    42.859     0.150
     1.196    22.875     0.150
     1.231    22.109     0.150
     1.231    38.949     0.150
     1.250    23.984     0.150
     1.250    23.855     0.150
     1.250    40.287     0.150
     1.268    25.074     0.150
     1.298    23.775     0.150
     1.345    25.645     0.150
     1.413    25.295     0.150
     1.426    26.324     0.150
     1.426    26.029     0.150
     1.426    44.910     0.150
     1.459    25.654     0.150
     1.527    28.404     0.150
     1.581    29.445     0.150
     1.588    28.375     0.150
     1.694    31.307     0.150
     1.756    32.045     0.150
     1.765    31.936     0.150
     1.765    33.180     0.150
     1.765    56.883     0.150
     1.892    33.961     0.150
     1.892    60.045     0.150
     1.921    33.506     0.150
     1.921    35.514     0.150
     1.945    34.596     0.150
     2.025    35.045     0.150
     2.081    36.445     0.150
     2.187    39.234     0.150
     2.223    38.756     0.150
     2.249    38.715     0.150
     2.249    40.518     0.150
     2.249    71.107     0.150
     2.276    38.506     0.150
     2.298    39.135     0.150
     2.344    39.635     0.150
     2.429    40.926     0.150
     2.460    40.775     0.150
     2.460    41.863     0.150
     2.462    41.615     0.150
     2.464    40.846     0.150
     2.464    41.852     0.150
     2.687    45.635     0.150
     2.687    83.551     0.150
     2.705    45.895     0.150
     2.705    50.994     0.150
     2.933    49.035     0.150
     2.937    47.994     0.150
     3.225    53.123     0.150
     3.336    53.484     0.150
     3.479    55.143     0.150
     3.582    57.025     0.150
     3.718    60.992     0.150
     3.789    60.795     0.150
     3.789    61.994     0.150
     3.816    59.295     0.150
     3.973    62.045     0.150
     4.570    69.375     0.150
     5.130    79.016     0.150
     5.173    80.744     0.150
     5.260    82.395     0.150
     5.303    81.855     0.150
     5.475    83.166     0.150
     5.561    83.775     0.150
     5.885    88.025     0.150
     5.982    90.596     0.150
     6.058    91.305     0.150
     6.089    91.824     0.150
     7.743   112.836     0.150
     0.403     8.242     0.150
     0.403    13.852     0.150
     0.403     8.174     0.150
     0.403    13.854     0.150
     0.444     8.564     0.150
     0.444     8.462     0.150
     0.444    13.646     0.150
     0.479     9.714     0.150
     0.479    16.473     0.150
     0.665    13.404     0.150
     0.665    23.484     0.150
     0.758    14.109     0.150
     0.758    24.820     0.150
     0.904    16.894     0.150
     0.964    17.534     0.150
     0.964    31.754     0.150
     0.990    18.109     0.150
     0.990    31.246     0.150
     0.994    19.514     0.150
     0.994    32.884     0.150
     0.994    33.178     0.150
     1.050    19.134     0.150
     1.050    33.574     0.150
     1.188    22.314     0.150
     1.188    38.594     0.150
     1.250    22.924     0.150
     1.250    23.037     0.150
     1.250    39.732     0.150
     1.203    23.244     0.150
     1.203    22.719     0.150
     1.203    39.108     0.150
     1.249    23.104     0.150
     1.249    39.804     0.150
     1.249    40.207     0.150
     1.264    23.084     0.150
     1.264    40.194     0.150
     1.267    23.150     0.150
     1.267    40.397     0.150
     1.300    23.354     0.150
     1.300    39.534     0.150
     1.281    24.614     0.150
     1.281    41.824     0.150
     1.401    26.984     0.150
     1.401    45.444     0.150
     1.652    29.374     0.150
     1.652    50.624     0.150
     1.652    52.784     0.150
     1.694    30.124     0.150
     1.694    52.214     0.150
     1.703    29.914     0.150
     1.703    53.714     0.150
     1.742    31.854     0.150
     1.742    55.804     0.150
     1.742    32.228     0.150
     1.782    32.384     0.150
     1.782    55.854     0.150
     1.782    56.024     0.150
     1.794    56.384     0.150
     1.814    32.884     0.150
     1.814    58.524     0.150
     1.835    32.914     0.150
     1.835    57.694     0.150
     1.916    60.564     0.150
     2.169    37.414     0.150
     2.169    67.134     0.150
     2.169    39.317     0.150
     2.169    65.754     0.150
     2.336    39.674     0.150
     2.336    69.154     0.150
     2.336    69.445     0.150
     2.390    41.027     0.150
     2.686    44.000     0.150
     2.686    77.589     0.150
     2.787    46.544     0.150
     2.787    52.264     0.150
     2.787    45.939     0.150
     2.930    84.514     0.150
     2.930    52.074     0.150
     2.930    90.963     0.150
     2.943    92.034     0.150
     2.943    52.955     0.150
     2.943    92.407     0.150
     3.075    50.474     0.150
     3.075    57.684     0.150
     3.075    97.474     0.150
     3.229    53.034     0.150
     3.319   102.543     0.150
     3.459    96.692     0.150
     3.856    61.804     0.150
     3.856    61.583     0.150
     4.675    72.689     0.150
     4.711    73.794     0.150
     4.711   128.504     0.150
     4.711   147.724     0.150
     4.711    73.566     0.150
     5.323    82.354     0.150
     0.327     6.014     0.150
     0.353    12.002     0.150
     0.353     7.145     0.150
     0.605    11.254     0.150
     0.605    19.705     0.150
     0.849    16.145     0.150
     0.849    16.568     0.150
     0.849    27.812     0.150
     0.933    17.543     0.150
     0.913    30.713     0.150
     1.002    31.953     0.150
     1.002    18.049     0.150
     1.099    19.684     0.150
     1.197    23.293     0.150
     1.144    21.293     0.150
     1.144    21.662     0.150
     1.144    38.125     0.150
     1.312    24.145     0.150
     1.312    24.055     0.150
     1.314    45.107     0.150
     1.330    25.164     0.150
     1.330    41.213     0.150
     1.330    24.814     0.150
     1.330    41.836     0.150
     1.341    24.484     0.150
     1.341    42.613     0.150
     1.341    25.059     0.150
     1.341    43.439     0.150
     1.423    27.324     0.150
     1.440    26.773     0.150
     1.440    46.863     0.150
     1.549    29.254     0.150
     1.549    28.771     0.150
     1.666    29.654     0.150
     1.718    31.033     0.150
     1.718    53.908     0.150
     1.852    33.344     0.150
     1.852    58.594     0.150
     1.913    34.385     0.150
     1.913    58.805     0.150
     1.913    59.010     0.150
     1.930    34.684     0.150
     1.930    58.934     0.150
     1.930    59.854     0.150
     2.198    37.725     0.150
     2.408    40.703     0.150
     2.408    70.943     0.150
     2.443    41.734     0.150
     2.443    71.814     0.150
     2.520    42.244     0.150
     2.520    46.777     0.150
     2.533    42.674     0.150
     2.533    43.463     0.150
     2.946    48.174     0.150
     2.936    48.494     0.150
     2.936    82.334     0.150
     2.999    54.344     0.150
     2.999    94.555     0.150
     3.219    52.543     0.150
     3.273    52.523     0.150
     3.403   105.904     0.150
     3.424    61.984     0.150
     3.424   106.713     0.150
     4.001    63.273     0.150
     4.103    64.713     0.150
     4.811   129.414     0.150
     4.858    74.584     0.150
     4.858   130.543     0.150
     5.469    83.924     0.150
     5.469   144.344     0.150
     5.493    84.213     0.150
     0.265     5.448     0.150
     0.265     9.128     0.150
     0.342     6.758     0.150
     0.342     6.628     0.150
     0.342    11.077     0.150
     0.422     8.668     0.150
     0.422    14.858     0.150
     0.422     8.778     0.150
     0.422    14.557     0.150
     0.546    11.528     0.150
     0.588    11.545     0.150
     0.588    19.809     0.150
     0.588    11.278     0.150
     0.588    19.488     0.150
     0.588    11.438     0.150
     0.588    18.978     0.150
     0.736    14.598     0.150
     0.736    24.778     0.150
     0.776    13.768     0.150
     0.776    24.168     0.150
     0.776    14.438     0.150
     0.776    24.748     0.150
     0.776    14.235     0.150
     0.852    16.838     0.150
     0.852    29.468     0.150
     0.961    17.418     0.150
     0.961    17.578     0.150
     0.961    30.718     0.150
     0.961    30.600     0.150
     1.012    19.658     0.150
     1.038    20.088     0.150
     1.038    34.408     0.150
     1.038    33.768     0.150
     1.038    19.801     0.150
     1.089    19.828     0.150
     1.089    35.208     0.150
     1.089    20.397     0.150
     1.089    35.028     0.150
     1.089    20.278     0.150
     1.089    35.747     0.150
     1.116    20.668     0.150
     1.116    35.818     0.150
     1.116    35.418     0.150
     1.166    21.358     0.150
     1.166    37.658     0.150
     1.166    21.848     0.150
     1.166    37.968     0.150
     1.166    21.998     0.150
     1.166    38.122     0.150
     1.165    21.858     0.150
     1.165    36.758     0.150
     1.267    23.438     0.150
     1.267    40.198     0.150
     1.267    23.008     0.150
     1.267    40.078     0.150
     1.313    42.038     0.150
     1.351    24.858     0.150
     1.351    43.028     0.150
     1.373    25.178     0.150
     1.373    44.598     0.150
     1.489    28.328     0.150
     1.489    48.268     0.150
     1.398    26.428     0.150
     1.398    44.758     0.150
     1.437    26.198     0.150
     1.437    26.368     0.150
     1.437    45.068     0.150
     1.437    26.494     0.150
     1.437    46.160     0.150
     1.481    27.168     0.150
     1.481    27.048     0.150
     1.481    46.647     0.150
     1.484    26.233     0.150
     1.484    48.090     0.150
     1.517    27.238     0.150
     1.517    48.228     0.150
     1.573    28.018     0.150
     1.664    29.188     0.150
     1.664    51.278     0.150
     1.698    29.978     0.150
     1.698    31.018     0.150
     1.698    53.998     0.150
     1.698    30.888     0.150
     1.698    53.656     0.150
     1.698    53.638     0.150
     1.726    30.638     0.150
     1.742    31.208     0.150
     1.789    32.008     0.150
     1.789    32.298     0.150
     1.789    56.378     0.150
     1.789    33.402     0.150
     1.789    56.592     0.150
     1.869    32.618     0.150
     1.869    57.478     0.150
     1.921    34.238     0.150
     1.921    59.508     0.150
     1.927    33.338     0.150
     1.985    33.908     0.150
     1.985    36.040     0.150
     1.985    61.258     0.150
     2.007    34.838     0.150
     2.053    35.918     0.150
     2.053    62.708     0.150
     2.098    36.668     0.150
     2.098    36.429     0.150
     2.098    66.524     0.150
     2.119    35.978     0.150
     2.126    36.572     0.150
     2.126    64.988     0.150
     2.128    36.448     0.150
     2.149    35.788     0.150
     2.213    37.938     0.150
     2.213    38.258     0.150
     2.213    66.518     0.150
     2.213    38.047     0.150
     2.213    66.372     0.150
     2.229    37.748     0.150
     2.229    38.708     0.150
     2.229    40.988     0.150
     2.229    66.478     0.150
     2.229    38.266     0.150
     2.332    38.508     0.150
     2.338    68.118     0.150
     2.338    69.695     0.150
     2.345    39.328     0.150
     2.387    40.388     0.150
     2.387    40.548     0.150
     2.387    70.378     0.150
     2.387    71.706     0.150
     2.446    41.308     0.150
     2.482    42.018     0.150
     2.495    42.188     0.150
     2.495    42.638     0.150
     2.495    73.938     0.150
     2.495    74.126     0.150
     2.512    72.688     0.150
     2.512    74.094     0.150
     2.595    42.628     0.150
     2.595    42.858     0.150
     2.595    74.728     0.150
     2.601    42.668     0.150
     2.670    44.228     0.150
     2.740    46.298     0.150
     2.738    44.738     0.150
     2.756    44.248     0.150
     2.756    44.955     0.150
     2.756    86.515     0.150
     2.811    46.728     0.150
     2.838    47.518     0.150
     2.838    47.098     0.150
     2.838    52.048     0.150
     2.838    46.762     0.150
     2.838    88.854     0.150
     2.896    46.958     0.150
     2.896    83.609     0.150
     2.919    45.558     0.150
     2.919    81.738     0.150
     2.919    82.853     0.150
     2.975    48.488     0.150
     3.148    51.058     0.150
     3.148    50.748     0.150
     3.148    88.048     0.150
     3.148    50.508     0.150
     3.148    89.655     0.150
     3.151    52.198     0.150
     3.161    49.858     0.150
     3.161    88.298     0.150
     3.161    98.618     0.150
     3.161    50.438     0.150
     3.161    88.933     0.150
     3.178    52.147     0.150
     3.178    51.918     0.150
     3.178    58.388     0.150
     3.178    89.518     0.150
     3.178    52.375     0.150
     3.178    90.792     0.150
     3.199    51.128     0.150
     3.199    52.408     0.150
     3.199    88.978     0.150
     3.199    52.951     0.150
     3.199    91.604     0.150
     3.201    89.528     0.150
     3.201   100.228     0.150
     3.201    99.582     0.150
     3.354    53.018     0.150
     3.357    52.988     0.150
     3.357    93.943     0.150
     3.487    55.438     0.150
     3.637    57.318     0.150
     3.637    57.568     0.150
     3.637    65.308     0.150
     3.637   100.098     0.150
     3.637   100.814     0.150
     3.671    57.818     0.150
     3.673    57.448     0.150
     3.673    58.194     0.150
     3.673   102.044     0.150
     3.716    58.688     0.150
     3.741    60.068     0.150
     3.808    60.650     0.150
     3.940    63.598     0.150
     3.940   107.678     0.150
     3.952    62.878     0.150
     3.952    62.478     0.150
     3.952    72.147     0.150
     3.952   108.358     0.150
     3.952   124.268     0.150
     3.952    63.306     0.150
     3.952   108.986     0.150
     4.045    62.468     0.150
     4.045    64.129     0.150
     4.060    62.098     0.150
     4.060    63.911     0.150
     4.106    64.758     0.150
     4.106   111.908     0.150
     4.106   129.928     0.150
     4.106    65.045     0.150
     4.106   113.460     0.150
     4.169    64.258     0.150
     4.169    74.897     0.150
     4.169   111.438     0.150
     4.169   130.018     0.150
     4.166    63.768     0.150
     4.300    66.638     0.150
     4.300    66.528     0.150
     4.300   115.598     0.150
     4.423    68.558     0.150
     4.423   120.481     0.150
     4.586   125.386     0.150
     4.622   122.468     0.150
     4.622   125.740     0.150
     4.658    72.128     0.150
     4.794    74.388     0.150
     4.794    74.218     0.150
     4.794    87.058     0.150
     4.794   127.908     0.150
     4.794    74.698     0.150
     4.794   130.919     0.150
     4.813    74.698     0.150
     4.813   130.867     0.150
     4.864   131.400     0.150
     4.911    76.038     0.150
     4.911    75.138     0.150
     4.911    75.828     0.150
     4.917   132.155     0.150
     5.029    77.528     0.150
     5.122    78.958     0.150
     5.365    80.618     0.150
     5.365    82.428     0.150
     5.414    83.748     0.150
     5.414   141.618     0.150
     5.414    83.233     0.150
     5.417    82.738     0.150
     5.505    83.908     0.150
     5.505    82.448     0.150
     5.505   145.368     0.150
     5.562    83.378     0.150
     5.664    85.608     0.150
     5.664    86.117     0.150
     5.771    86.938     0.150
     5.919    89.778     0.150
     6.147    91.538     0.150
     6.241    93.068     0.150
     6.276    93.848     0.150
     6.276    93.558     0.150
     6.276   162.808     0.150
     6.276    94.433     0.150
     6.372    94.588     0.150
     6.918   102.968     0.150
     6.943   102.778     0.150
     6.979   105.118     0.150
     7.148   106.568     0.150
     7.299   108.558     0.150
     7.299   108.344     0.150
     7.321   106.668     0.150
     7.483   109.478     0.150
     7.687   112.758     0.150
     7.862   116.118     0.150
     8.058   118.908     0.150
     8.665   128.288     0.150
     9.003   130.138     0.150
     0.302     5.863     0.150
     0.302    10.023     0.150
     0.346     7.131     0.150
     0.346    12.217     0.150
     0.346     7.152     0.150
     0.346    10.883     0.150
     0.534    10.664     0.150
     0.534    16.924     0.150
     0.534    17.742     0.150
     0.582    12.084     0.150
     0.586    11.713     0.150
     0.586    19.883     0.150
     0.600    11.133     0.150
     0.600    18.809     0.150
     0.762    15.393     0.150
     0.745    14.453     0.150
     0.769    14.383     0.150
     0.796    15.863     0.150
     0.796    26.992     0.150
     0.850    29.043     0.150
     0.883    16.322     0.150
     0.936    18.762     0.150
     0.936    30.990     0.150
     1.036    20.264     0.150
     1.036    20.107     0.150
     1.036    34.074     0.150
     1.053    20.363     0.150
     1.098    20.072     0.150
     1.100    20.033     0.150
     1.100    34.932     0.150
     1.150    20.674     0.150
     1.154    22.113     0.150
     1.154    37.764     0.150
     1.145    20.982     0.150
     1.145    20.740     0.150
     1.145    35.816     0.150
     1.301    25.297     0.150
     1.301    43.393     0.150
     1.202    23.043     0.150
     1.202    23.158     0.150
     1.202    39.539     0.150
     1.239    22.834     0.150
     1.281    23.254     0.150
     1.347    25.293     0.150
     1.347    41.951     0.150
     1.608    29.232     0.150
     1.656    29.303     0.150
     1.674    31.062     0.150
     1.739    32.084     0.150
     1.739    55.279     0.150
     1.779    31.504     0.150
     1.779    55.596     0.150
     1.802    31.264     0.150
     1.832    33.213     0.150
     1.832    33.354     0.150
     1.832    57.865     0.150
     1.837    32.963     0.150
     1.837    57.133     0.150
     2.007    35.902     0.150
     2.025    35.453     0.150
     2.111    36.863     0.150
     2.270    40.229     0.150
     2.258    39.674     0.150
     2.258    69.244     0.150
     2.317    39.264     0.150
     2.363    40.193     0.150
     2.371    40.803     0.150
     2.371    41.443     0.150
     2.394    40.943     0.150
     2.394    41.113     0.150
     2.394    72.461     0.150
     2.549    42.514     0.150
     2.549    41.986     0.150
     2.694    44.338     0.150
     2.703    45.453     0.150
     2.703    45.682     0.150
     2.774    46.266     0.150
     2.955    49.506     0.150
     3.004    48.982     0.150
     3.312    53.443     0.150
     3.348    54.061     0.150
     3.404    54.152     0.150
     3.738    60.832     0.150
     3.828    60.402     0.150
     3.828    61.531     0.150
     4.595    72.461     0.150
     4.602    72.871     0.150
     4.637    72.248     0.150
     5.163    79.264     0.150
     5.208    81.436     0.150
     5.216    79.955     0.150
     6.016    90.684     0.150
     6.016    90.967     0.150
     7.107   105.543     0.150
     0.352     7.055     0.150
     0.352    11.617     0.150
     0.439     9.027     0.150
     0.439    15.504     0.150
     0.439     9.352     0.150
     0.439    15.898     0.150
     0.525    10.184     0.150
     0.525    17.270     0.150
     0.525    10.156     0.150
     0.525    17.164     0.150
     0.753    15.047     0.150
     0.753    25.105     0.150
     0.842    15.086     0.150
     0.842    26.867     0.150
     0.842    15.879     0.150
     0.842    27.539     0.150
     0.789    15.797     0.150
     0.789    27.457     0.150
     0.903    16.445     0.150
     0.903    28.570     0.150
     1.030    19.945     0.150
     1.030    34.016     0.150
     1.030    20.180     0.150
     1.030    34.152     0.150
     1.050    19.484     0.150
     1.050    34.574     0.150
     1.142    20.465     0.150
     1.142    35.977     0.150
     1.142    21.812     0.150
     1.142    37.629     0.150
     1.100    20.785     0.150
     1.100    36.234     0.150
     1.183    21.707     0.150
     1.183    38.355     0.150
     1.183    22.605     0.150
     1.203    21.777     0.150
     1.313    24.324     0.150
     1.313    43.105     0.150
     1.307    24.094     0.150
     1.307    43.344     0.150
     1.307    42.441     0.150
     1.375    25.617     0.150
     1.375    45.477     0.150
     1.375    25.414     0.150
     1.375    43.891     0.150
     1.469    27.234     0.150
     1.469    28.156     0.150
     1.369    44.914     0.150
     1.417    25.957     0.150
     1.417    46.117     0.150
     1.420    25.109     0.150
     1.420    45.324     0.150
     1.450    26.074     0.150
     1.450    46.504     0.150
     1.552    27.426     0.150
     1.552    48.035     0.150
     1.552    28.047     0.150
     1.552    48.953     0.150
     1.734    30.414     0.150
     1.795    31.426     0.150
     1.795    54.855     0.150
     1.803    31.914     0.150
     1.803    55.707     0.150
     1.855    33.094     0.150
     1.855    57.176     0.150
     1.872    57.746     0.150
     1.951    34.574     0.150
     1.951    58.926     0.150
     1.988    60.656     0.150
     2.060    36.066     0.150
     2.257    65.406     0.150
     2.250    39.988     0.150
     2.321    40.504     0.150
     2.321    68.496     0.150
     2.321    40.828     0.150
     2.321    71.621     0.150
     2.471    41.465     0.150
     2.471    71.754     0.150
     2.471    43.832     0.150
     2.471    75.305     0.150
     2.662    74.895     0.150
     2.817    45.027     0.150
     2.831    46.656     0.150
     2.831    79.594     0.150
     3.082    50.496     0.150
     3.082    86.855     0.150
     3.155    50.684     0.150
     3.155    88.504     0.150
     3.421    95.316     0.150
     3.701    99.906     0.150
     3.932   107.176     0.150
     4.072    63.387     0.150
     4.230   112.684     0.150
     4.230   130.805     0.150
     4.217   114.527     0.150
     4.217   132.844     0.150
     4.312   116.355     0.150
     5.396   142.434     0.150
     5.470   143.836     0.150
     0.463     8.914     0.150
     0.463    15.117     0.150
     0.463     9.297     0.150
     0.463    15.188     0.150
     0.487     9.992     0.150
     0.487    16.969     0.150
     0.487     9.398     0.150
     0.487    17.141     0.150
     0.498     9.969     0.150
     0.498    16.750     0.150
     0.498     9.750     0.150
     0.498    16.641     0.150
     0.668    13.797     0.150
     0.738    14.148     0.150
     0.738    24.188     0.150
     0.714    14.516     0.150
     0.714    24.266     0.150
     0.788    13.938     0.150
     0.831    15.719     0.150
     0.831    26.641     0.150
     0.802    16.211     0.150
     0.802    16.359     0.150
     0.802    26.695     0.150
     0.895    15.977     0.150
     0.893    17.680     0.150
     0.893    30.516     0.150
     0.893    30.695     0.150
     1.042    19.461     0.150
     1.042    33.242     0.150
     1.045    19.469     0.150
     1.045    33.602     0.150
     1.007    19.867     0.150
     1.150    22.945     0.150
     1.150    38.875     0.150
     1.135    20.156     0.150
     1.098    21.312     0.150
     1.098    35.719     0.150
     1.098    35.555     0.150
     1.212    23.695     0.150
     1.212    41.289     0.150
     1.212    23.195     0.150
     1.212    41.023     0.150
     1.196    21.672     0.150
     1.196    37.727     0.150
     1.324    24.562     0.150
     1.476    25.898     0.150
     1.476    45.320     0.150
     1.448    27.492     0.150
     1.448    47.406     0.150
     1.512    26.672     0.150
     1.525    28.797     0.150
     1.525    50.125     0.150
     1.630    29.195     0.150
     1.630    51.500     0.150
     1.607    30.656     0.150
     1.607    52.789     0.150
     1.607    30.484     0.150
     1.607    52.617     0.150
     1.781    30.656     0.150
     1.781    55.352     0.150
     1.751    32.547     0.150
     1.751    56.570     0.150
     1.751    33.109     0.150
     1.751    57.000     0.150
     1.878    35.016     0.150
     1.865    33.930     0.150
     1.865    58.672     0.150
     1.865    33.812     0.150
     1.961    34.812     0.150
     1.961    61.117     0.150
     1.961    35.484     0.150
     2.116    39.250     0.150
     2.116    68.625     0.150
     2.116    39.773     0.150
     2.116    68.984     0.150
     2.117    38.578     0.150
     2.117    68.539     0.150
     2.117    38.156     0.150
     2.117    69.086     0.150
     2.141    38.211     0.150
     2.141    69.352     0.150
     2.141    40.906     0.150
     2.141    69.523     0.150
     2.260    43.102     0.150
     2.260    73.094     0.150
     2.326    40.539     0.150
     2.326    72.562     0.150
     2.326    41.414     0.150
     2.326    72.258     0.150
     2.547    44.148     0.150
     2.547    76.906     0.150
     2.555    44.258     0.150
     2.555    48.281     0.150
     2.555    82.227     0.150
     2.602    49.461     0.150
     2.602    83.977     0.150
     2.738    47.320     0.150
     2.738    47.703     0.150
     2.738    84.156     0.150
     2.802    48.211     0.150
     2.802    52.867     0.150
     2.802    89.867     0.150
     2.802    53.000     0.150
     2.802    90.383     0.150
     2.882    49.312     0.150
     3.069    50.664     0.150
     3.045    49.250     0.150
     3.045    55.578     0.150
     3.079    97.367     0.150
     3.292    54.414     0.150
     3.359   104.078     0.150
     3.586    59.047     0.150
     3.586    68.266     0.150
     3.680    61.000     0.150
     3.829    61.992     0.150
     4.450    71.711     0.150
     4.450    84.750     0.150
     4.450   142.219     0.150
     5.055    79.938     0.150
     5.071    80.781     0.150
     0.239     4.664     0.150
     0.418     8.684     0.150
     0.418     8.926     0.150
     0.418    14.906     0.150
     0.550    10.711     0.150
     0.550    19.020     0.150
     0.550    10.773     0.150
     0.550    19.125     0.150
     0.550    18.977     0.150
     0.561    12.047     0.150
     0.733    14.336     0.150
     0.733    24.773     0.150
     0.733    14.746     0.150
     0.915    16.785     0.150
     0.915    31.035     0.150
     0.915    28.156     0.150
     0.915    16.449     0.150
     0.915    28.730     0.150
     1.018    19.816     0.150
     1.018    34.086     0.150
     1.018    33.398     0.150
     1.072    19.855     0.150
     1.072    19.996     0.150
     1.072    35.145     0.150
     1.116    21.023     0.150
     1.116    36.406     0.150
     1.116    36.027     0.150
     1.163    22.086     0.150
     1.163    37.414     0.150
     1.163    38.227     0.150
     1.163    38.023     0.150
     1.220    21.715     0.150
     1.220    21.824     0.150
     1.310    24.137     0.150
     1.310    24.316     0.150
     1.310    42.996     0.150
     1.310    42.711     0.150
     1.298    42.684     0.150
     1.298    24.785     0.150
     1.298    42.137     0.150
     1.366    25.824     0.150
     1.461    27.945     0.150
     1.400    25.875     0.150
     1.400    45.074     0.150
     1.400    26.074     0.150
     1.400    45.184     0.150
     1.435    25.414     0.150
     1.437    25.078     0.150
     1.437    46.270     0.150
     1.472    26.184     0.150
     1.472    46.645     0.150
     1.472    26.316     0.150
     1.472    45.895     0.150
     1.531    27.273     0.150
     1.531    27.594     0.150
     1.528    27.273     0.150
     1.528    48.504     0.150
     1.618    28.773     0.150
     1.618    50.426     0.150
     1.663    30.395     0.150
     1.702    30.574     0.150
     1.710    31.156     0.150
     1.710    31.496     0.150
     1.710    54.715     0.150
     1.710    31.336     0.150
     1.710    54.426     0.150
     1.778    32.363     0.150
     1.778    33.566     0.150
     1.778    56.676     0.150
     1.778    56.914     0.150
     1.824    32.305     0.150
     1.824    57.395     0.150
     1.843    33.203     0.150
     1.875    32.934     0.150
     1.875    58.926     0.150
     1.887    33.477     0.150
     1.879    33.934     0.150
     1.879    34.125     0.150
     1.879    59.645     0.150
     1.879    58.137     0.150
     1.963    34.453     0.150
     1.959    35.023     0.150
     1.959    35.363     0.150
     1.959    62.324     0.150
     2.007    35.355     0.150
     2.007    35.676     0.150
     2.007    64.066     0.150
     2.024    35.484     0.150
     2.024    61.844     0.150
     2.079    36.023     0.150
     2.083    36.312     0.150
     2.083    64.277     0.150
     2.106    36.754     0.150
     2.229    39.066     0.150
     2.229    70.734     0.150
     2.229    38.816     0.150
     2.229    70.168     0.150
     2.232    38.594     0.150
     2.232    38.797     0.150
     2.232    68.164     0.150
     2.232    70.773     0.150
     2.232    67.688     0.150
     2.293    39.465     0.150
     2.311    39.805     0.150
     2.340    40.676     0.150
     2.340    72.246     0.150
     2.340    72.684     0.150
     2.385    39.875     0.150
     2.385    40.934     0.150
     2.385    71.340     0.150
     2.437    41.605     0.150
     2.465    42.184     0.150
     2.465    42.727     0.150
     2.465    72.180     0.150
     2.546    42.875     0.150
     2.546    43.477     0.150
     2.546    43.035     0.150
     2.546    47.695     0.150
     2.546    42.199     0.150
     2.563    43.297     0.150
     2.559    43.105     0.150
     2.559    42.559     0.150
     2.559    75.441     0.150
     2.637    43.605     0.150
     2.641    43.875     0.150
     2.641    43.105     0.150
     2.641    81.195     0.150
     2.692    45.324     0.150
     2.694    45.695     0.150
     2.694    44.434     0.150
     2.773    46.316     0.150
     2.823    46.137     0.150
     2.823    46.414     0.150
     2.791    45.547     0.150
     2.791    45.336     0.150
     2.791    50.844     0.150
     2.791    87.566     0.150
     2.819    48.137     0.150
     2.819    47.074     0.150
     2.819    52.773     0.150
     2.819    46.430     0.150
     2.819    80.578     0.150
     2.853    46.414     0.150
     2.853    46.617     0.150
     2.853    82.562     0.150
     2.965    48.746     0.150
     2.965    48.117     0.150
     3.028    49.266     0.150
     3.020    48.547     0.150
     3.102    50.684     0.150
     3.102    51.184     0.150
     3.102    56.375     0.150
     3.102    50.570     0.150
     3.102    88.555     0.150
     3.149    52.145     0.150
     3.149    51.863     0.150
     3.198    51.984     0.150
     3.198    52.664     0.150
     3.197    52.113     0.150
     3.197    52.574     0.150
     3.197    92.656     0.150
     3.197   101.145     0.150
     3.197    90.352     0.150
     3.189    51.445     0.150
     3.189    50.684     0.150
     3.189    98.539     0.150
     3.216    52.086     0.150
     3.216   100.953     0.150
     3.216    51.965     0.150
     3.216   100.574     0.150
     3.318    53.516     0.150
     3.318    53.105     0.150
     3.310    52.965     0.150
     3.314    52.895     0.150
     3.314    53.355     0.150
     3.314    53.055     0.150
     3.444    55.375     0.150
     3.499    56.324     0.150
     3.499    55.492     0.150
     3.584    56.703     0.150
     3.629    58.395     0.150
     3.629    57.953     0.150
     3.629   101.602     0.150
     3.625    57.605     0.150
     3.625   101.121     0.150
     3.597    58.465     0.150
     3.597    58.285     0.150
     3.597    57.980     0.150
     3.597   110.562     0.150
     3.676    57.773     0.150
     3.676    66.125     0.150
     3.676    57.551     0.150
     3.676   113.930     0.150
     3.925    63.234     0.150
     3.925   109.094     0.150
     3.925    62.871     0.150
     3.920    63.336     0.150
     3.999    63.586     0.150
     4.071    65.066     0.150
     4.071    64.875     0.150
     4.071   113.465     0.150
     4.071    64.730     0.150
     4.132    63.977     0.150
     4.233    65.273     0.150
     4.233    64.703     0.150
     4.204    65.004     0.150
     4.204    64.734     0.150
     4.204    75.773     0.150
     4.204    64.852     0.150
     4.258    66.484     0.150
     4.323    67.125     0.150
     4.323    68.703     0.150
     4.323    80.535     0.150
     4.379    68.453     0.150
     4.379    67.859     0.150
     4.379   119.645     0.150
     4.542    69.859     0.150
     4.580    71.773     0.150
     4.580    70.391     0.150
     4.618    71.086     0.150
     4.618    70.715     0.150
     4.665    71.555     0.150
     4.665    71.910     0.150
     4.771    74.023     0.150
     4.769    74.953     0.150
     4.769   131.336     0.150
     4.769   152.176     0.150
     4.769    74.535     0.150
     4.820    74.164     0.150
     4.868    74.887     0.150
     4.868    74.473     0.150
     4.950    76.074     0.150
     4.950    75.566     0.150
     5.098    77.715     0.150
     5.098    77.055     0.150
     5.278    79.648     0.150
     5.315    80.832     0.150
     5.324    80.934     0.150
     5.385    83.203     0.150
     5.385   147.594     0.150
     5.388    83.453     0.150
     5.388    83.594     0.150
     5.388   145.773     0.150
     5.438    82.824     0.150
     5.445    83.113     0.150
     5.469    83.863     0.150
     5.469   148.297     0.150
     5.469    83.613     0.150
     5.524    83.363     0.150
     5.724    87.023     0.150
     5.724    87.477     0.150
     5.724    87.262     0.150
     5.803    89.184     0.150
     5.859    89.316     0.150
     5.874    89.734     0.150
     5.874    89.398     0.150
     5.970    89.465     0.150
     5.970   157.750     0.150
     5.970   189.676     0.150
     5.970    89.285     0.150
     6.115    91.945     0.150
     6.219    94.656     0.150
     6.219    94.547     0.150
     6.219    93.887     0.150
     6.243    94.156     0.150
     6.243    94.035     0.150
     6.243    93.832     0.150
     6.305    95.406     0.150
     6.305    95.609     0.150
     6.326    95.254     0.150
     6.326    95.742     0.150
     6.334    95.676     0.150
     6.334    96.098     0.150
     6.742   100.547     0.150
     6.914   104.254     0.150
     6.947   103.086     0.150
     7.296   107.047     0.150
     7.275   107.906     0.150
     7.275   189.227     0.150
     7.275   108.270     0.150
     7.774   114.914     0.150
     7.879   114.164     0.150
     8.017   118.875     0.150
     8.126   119.934     0.150
     8.276   121.887     0.150
     8.431   123.344     0.150
     8.604   126.523     0.150
     8.630   127.016     0.150
     8.696   126.754     0.150
     8.682   127.605     0.150
     8.758   128.676     0.150
     8.965   130.414     0.150
     9.302   136.887     0.150
     9.359   137.766     0.150
     9.359   241.094     0.150
     9.748   144.086     0.150
     9.834   145.805     0.150
     9.842   145.625     0.150
    10.233   150.754     0.150
    10.494   152.203     0.150
    11.338   163.426     0.150
    12.057   172.434     0.150
    61.067   614.102     0.150
    65.583   643.871     0.150
   149.826  1189.594     0.150
     0.265     5.562     0.150
     0.265     9.531     0.150
     0.265     5.461     0.150
     0.343     6.521     0.150
     0.343    11.081     0.150
     0.524    10.562     0.150
     0.524    17.171     0.150
     0.524    10.791     0.150
     0.643    12.121     0.150
     0.643    20.721     0.150
     0.643    20.831     0.150
     0.772    15.441     0.150
     0.772    27.331     0.150
     0.738    14.481     0.150
     0.738    14.971     0.150
     0.738    26.081     0.150
     0.788    15.231     0.150
     0.788    25.671     0.150
     0.788    15.041     0.150
     0.788    26.131     0.150
     0.894    17.361     0.150
     0.894    30.062     0.150
     1.044    19.851     0.150
     1.044    20.611     0.150
     1.044    35.481     0.150
     1.002    18.771     0.150
     1.002    32.741     0.150
     1.041    19.281     0.150
     1.041    32.331     0.150
     1.041    33.331     0.150
     0.999    19.741     0.150
     0.999    33.421     0.150
     1.014    19.891     0.150
     1.014    33.891     0.150
     1.184    22.141     0.150
     1.172    22.721     0.150
     1.172    39.131     0.150
     1.331    25.881     0.150
     1.312    25.151     0.150
     1.291    24.321     0.150
     1.291    41.111     0.150
     1.308    25.611     0.150
     1.308    25.371     0.150
     1.308    42.581     0.150
     1.392    25.211     0.150
     1.392    43.431     0.150
     1.441    26.171     0.150
     1.441    25.981     0.150
     1.441    45.031     0.150
     1.487    27.201     0.150
     1.459    27.051     0.150
     1.459    27.981     0.150
     1.544    27.711     0.150
     1.533    29.151     0.150
     1.533    28.961     0.150
     1.572    28.701     0.150
     1.572    28.812     0.150
     1.572    48.321     0.150
     1.590    29.471     0.150
     1.590    29.711     0.150
     1.590    48.491     0.150
     1.690    29.841     0.150
     1.912    33.291     0.150
     1.905    34.231     0.150
     1.905    34.491     0.150
     1.932    34.711     0.150
     1.932    35.031     0.150
     1.932    62.071     0.150
     2.004    35.081     0.150
     2.200    38.501     0.150
     2.200    38.921     0.150
     2.258    38.891     0.150
     2.306    39.911     0.150
     2.279    40.191     0.150
     2.279    40.691     0.150
     2.279    72.221     0.150
     2.305    40.371     0.150
     2.395    41.001     0.150
     2.338    40.541     0.150
     2.338    41.171     0.150
     2.431    40.631     0.150
     2.431    41.231     0.150
     2.437    41.171     0.150
     2.499    41.991     0.150
     2.499    42.812     0.150
     2.613    44.941     0.150
     2.668    45.111     0.150
     2.668    45.571     0.150
     2.668    83.261     0.150
     2.741    46.431     0.150
     2.741    47.071     0.150
     2.932    48.241     0.150
     2.947    48.331     0.150
     2.949    49.211     0.150
     2.949    49.011     0.150
     2.962    49.711     0.150
     2.962    50.421     0.150
     2.962    93.341     0.150
     3.171    50.491     0.150
     3.171    89.541     0.150
     3.277    54.621     0.150
     3.277    54.501     0.150
     3.277   102.941     0.150
     3.447    55.951     0.150
     3.515    55.971     0.150
     3.515    55.812     0.150
     3.709    60.171     0.150
     3.811    61.861     0.150
     3.950    62.991     0.150
     3.923    62.501     0.150
     4.188    66.281     0.150
     4.656    72.571     0.150
     4.618    73.651     0.150
     4.618    73.241     0.150
     4.618   146.461     0.150
     5.194    81.791     0.150
     5.194    79.171     0.150
     5.271    82.221     0.150
     6.091    91.312     0.150
     6.924   103.341     0.150
     7.121   105.941     0.150
     0.350     7.312     0.150
     0.350    12.469     0.150
     0.350     7.180     0.150
     0.350    12.375     0.150
     0.516     9.508     0.150
     0.516    16.570     0.150
     0.516     9.375     0.150
     0.644    11.898     0.150
     0.644    20.523     0.150
     0.644    20.711     0.150
     0.694    13.758     0.150
     0.694    24.930     0.150
     0.792    14.750     0.150
     0.792    26.273     0.150
     0.881    16.773     0.150
     0.881    29.750     0.150
     0.937    16.719     0.150
     0.959    18.148     0.150
     0.959    31.109     0.150
     0.959    18.266     0.150
     1.089    34.516     0.150
     1.089    20.203     0.150
     1.089    34.695     0.150
     1.151    20.234     0.150
     1.151    35.117     0.150
     1.154    20.336     0.150
     1.154    36.539     0.150
     1.196    20.773     0.150
     1.178    21.828     0.150
     1.178    38.500     0.150
     1.178    22.336     0.150
     1.178    38.773     0.150
     1.338    25.266     0.150
     1.338    43.516     0.150
     1.206    22.188     0.150
     1.206    38.133     0.150
     1.263    40.477     0.150
     1.334    23.539     0.150
     1.334    41.617     0.150
     1.318    23.727     0.150
     1.318    43.898     0.150
     1.318    41.234     0.150
     1.458    26.703     0.150
     1.453    26.648     0.150
     1.547    26.789     0.150
     1.634    29.828     0.150
     1.634    52.133     0.150
     1.703    30.625     0.150
     1.697    29.898     0.150
     1.697    52.609     0.150
     1.758    55.023     0.150
     1.758    31.188     0.150
     1.758    54.883     0.150
     1.820    31.594     0.150
     1.820    56.445     0.150
     1.843    31.320     0.150
     1.843    55.266     0.150
     1.848    32.797     0.150
     1.824    32.391     0.150
     1.824    56.906     0.150
     1.824    31.953     0.150
     1.824    56.430     0.150
     2.058    35.391     0.150
     2.058    63.836     0.150
     2.058    35.781     0.150
     2.058    65.039     0.150
     2.056    35.570     0.150
     2.099    36.367     0.150
     2.099    63.188     0.150
     2.159    36.117     0.150
     2.159    62.664     0.150
     2.302    39.047     0.150
     2.267    38.789     0.150
     2.267    67.000     0.150
     2.267    38.562     0.150
     2.267    67.148     0.150
     2.314    39.547     0.150
     2.314    39.703     0.150
     2.277    66.898     0.150
     2.412    39.555     0.150
     2.412    68.523     0.150
     2.428    40.297     0.150
     2.428    41.047     0.150
     2.380    40.164     0.150
     2.380    69.430     0.150
     2.380    39.820     0.150
     2.380    69.867     0.150
     2.436    71.898     0.150
     2.436    40.758     0.150
     2.436    72.211     0.150
     2.539    42.000     0.150
     2.590    41.930     0.150
     2.590    42.594     0.150
     2.590    75.594     0.150
     2.751    44.914     0.150
     2.751    44.766     0.150
     2.751    84.961     0.150
     2.736    45.109     0.150
     2.736    85.273     0.150
     2.668    82.812     0.150
     2.823    45.695     0.150
     2.823    46.250     0.150
     2.823    87.391     0.150
     2.839    46.828     0.150
     2.839    46.648     0.150
     2.999    49.055     0.150
     2.999    49.242     0.150
     3.058    48.008     0.150
     3.061    48.930     0.150
     3.078    49.211     0.150
     3.024    47.375     0.150
     3.024    47.500     0.150
     3.024    93.555     0.150
     3.181    50.203     0.150
     3.218    51.430     0.150
     3.218    51.781     0.150
     3.218    90.266     0.150
     3.353    52.914     0.150
     3.353    53.398     0.150
     3.357    53.305     0.150
     3.357    53.688     0.150
     3.245    51.156     0.150
     3.381    53.297     0.150
     3.341    52.836     0.150
     3.341    52.938     0.150
     3.341    92.977     0.150
     3.381    52.664     0.150
     3.381    52.328     0.150
     3.381    92.617     0.150
     3.446    53.453     0.150
     3.719    58.125     0.150
     3.719    58.305     0.150
     3.782    60.406     0.150
     3.782    60.523     0.150
     3.782   104.180     0.150
     3.828    60.070     0.150
     3.878    61.164     0.150
     3.878    61.344     0.150
     3.782    60.797     0.150
     3.950    60.484     0.150
     3.917    60.156     0.150
     3.917    60.711     0.150
     3.863    60.484     0.150
     3.926    59.734     0.150
     3.926    60.133     0.150
     4.052    62.039     0.150
     4.105    63.078     0.150
     4.105    63.531     0.150
     4.105   112.281     0.150
     4.270    66.094     0.150
     4.270   116.062     0.150
     4.314    66.484     0.150
     4.314    66.070     0.150
     4.314    67.336     0.150
     4.314    67.602     0.150
     4.329    65.969     0.150
     4.509    68.008     0.150
     4.509    68.617     0.150
     4.509   122.648     0.150
     4.431    66.977     0.150
     4.431    67.117     0.150
     4.431   118.773     0.150
     4.550    69.320     0.150
     4.550   123.227     0.150
     4.587    70.188     0.150
     4.587   124.938     0.150
     4.643    72.375     0.150
     4.699    71.930     0.150
     4.677    72.148     0.150
     4.677    71.977     0.150
     4.928    74.438     0.150
     5.034    77.328     0.150
     5.157    77.844     0.150
     5.157    78.734     0.150
     5.176    77.898     0.150
     5.176    78.953     0.150
     5.211    78.438     0.150
     5.251    80.703     0.150
     5.251    80.930     0.150
     5.268    80.555     0.150
     5.268    80.109     0.150
     5.288    79.305     0.150
     5.377    81.516     0.150
     5.441    83.375     0.150
     5.599    84.727     0.150
     5.599    85.039     0.150
     5.695    85.164     0.150
     5.695    83.430     0.150
     5.830    89.375     0.150
     5.907    88.570     0.150
     5.983    88.125     0.150
     6.022    90.625     0.150
     6.022    91.031     0.150
     6.060    90.578     0.150
     6.060    90.984     0.150
     6.108    91.453     0.150
     6.108    91.766     0.150
     6.124    91.367     0.150
     6.322    93.773     0.150
     6.366    95.016     0.150
     6.555    97.258     0.150
     6.596    98.516     0.150
     6.613    98.797     0.150
     6.692    98.867     0.150
     6.728    99.219     0.150
     6.788   100.945     0.150
     6.783   100.367     0.150
     6.880   100.984     0.150
     6.968   102.359     0.150
     7.137   103.195     0.150
     7.137   104.477     0.150
     7.254   107.516     0.150
     7.411   108.758     0.150
     7.442   109.617     0.150
     7.580   111.609     0.150
     7.730   111.234     0.150
     7.831   113.695     0.150
     7.930   114.820     0.150
     8.362   121.984     0.150
     8.437   122.984     0.150
     8.549   124.109     0.150
     8.635   125.203     0.150
     8.725   126.023     0.150
     8.795   127.375     0.150
     0.366     7.477     0.150
     0.366    12.797     0.150
     0.366     7.383     0.150
     0.366    12.617     0.150
     0.501     9.828     0.150
     0.501    16.695     0.150
     0.634    11.961     0.150
     0.634    20.398     0.150
     0.712    14.195     0.150
     0.775    15.211     0.150
     0.775    25.977     0.150
     0.890    17.320     0.150
     0.890    30.422     0.150
     0.939    18.547     0.150
     0.939    31.172     0.150
     0.939    31.359     0.150
     0.934    16.688     0.150
     0.934    31.086     0.150
     1.073    20.336     0.150
     1.073    34.820     0.150
     1.095    19.695     0.150
     1.095    34.445     0.150
     1.095    19.594     0.150
     1.095    34.281     0.150
     1.188    21.719     0.150
     1.188    38.250     0.150
     1.188    22.516     0.150
     1.184    22.727     0.150
     1.184    38.906     0.150
     1.190    22.156     0.150
     1.190    39.227     0.150
     1.190    22.430     0.150
     1.190    38.984     0.150
     1.199    21.992     0.150
     1.199    37.695     0.150
     1.318    25.547     0.150
     1.243    24.078     0.150
     1.307    24.312     0.150
     1.307    41.766     0.150
     1.332    24.047     0.150
     1.332    42.570     0.150
     1.621    29.977     0.150
     1.621    52.031     0.150
     1.703    30.242     0.150
     1.703    53.062     0.150
     1.725    30.797     0.150
     1.738    30.930     0.150
     1.738    31.391     0.150
     1.738    54.961     0.150
     1.789    31.781     0.150
     1.789    31.523     0.150
     1.807    32.461     0.150
     1.807    31.984     0.150
     1.807    56.477     0.150
     1.825    31.750     0.150
     1.825    57.000     0.150
     1.849    31.547     0.150
     2.058    35.547     0.150
     2.058    36.227     0.150
     2.058    64.680     0.150
     2.161    36.430     0.150
     2.248    38.898     0.150
     2.248    67.203     0.150
     2.271    38.148     0.150
     2.271    68.180     0.150
     2.295    38.891     0.150
     2.295    39.945     0.150
     2.295    69.367     0.150
     2.365    39.422     0.150
     2.365    40.180     0.150
     2.365    70.742     0.150
     2.413    39.922     0.150
     2.419    39.992     0.150
     2.548    42.688     0.150
     2.596    42.867     0.150
     2.596    42.641     0.150
     2.596    75.922     0.150
     2.715    44.570     0.150
     2.715    45.508     0.150
     2.715    85.352     0.150
     2.744    45.469     0.150
     2.744    85.852     0.150
     2.819    47.570     0.150
     2.824    46.758     0.150
     2.824    81.664     0.150
     2.844    45.766     0.150
     2.918    47.070     0.150
     2.913    48.922     0.150
     2.980    47.883     0.150
     2.980    49.625     0.150
     2.980    93.883     0.150
     3.015    48.445     0.150
     3.015    54.133     0.150
     3.015    94.266     0.150
     3.046    47.781     0.150
     3.050    48.180     0.150
     3.050    50.312     0.150
     3.087    49.781     0.150
     3.198    51.047     0.150
     3.344    53.758     0.150
     3.368    52.742     0.150
     3.368    53.008     0.150
     3.368   104.625     0.150
     3.360    53.633     0.150
     3.360    53.898     0.150
     3.360    94.461     0.150
     3.374    54.930     0.150
     3.763    60.586     0.150
     3.763   104.672     0.150
     3.861    61.500     0.150
     4.624    72.633     0.150
     5.232    81.422     0.150
     0.318     6.672     0.150
     0.318    11.109     0.150
     0.318    11.844     0.150
     0.467     9.805     0.150
     0.467    16.742     0.150
     0.524    10.484     0.150
     0.524    18.023     0.150
     0.524    10.289     0.150
     0.524    17.781     0.150
     0.782    15.109     0.150
     0.782    26.258     0.150
     0.787    15.375     0.150
     0.787    26.773     0.150
     0.787    27.242     0.150
     0.927    17.258     0.150
     0.927    30.008     0.150
     0.927    17.078     0.150
     0.927    29.219     0.150
     0.946    18.070     0.150
     1.064    20.422     0.150
     1.154    20.898     0.150
     1.154    35.648     0.150
     1.154    36.375     0.150
     1.212    22.203     0.150
     1.212    22.352     0.150
     1.212    38.523     0.150
     1.220    21.758     0.150
     1.220    38.500     0.150
     1.310    23.945     0.150
     1.338    42.211     0.150
     1.403    25.820     0.150
     1.403    25.305     0.150
     1.503    27.109     0.150
     1.461    25.203     0.150
     1.461    44.312     0.150
     1.548    26.844     0.150
     1.616    28.211     0.150
     1.632    49.914     0.150
     1.679    29.211     0.150
     1.814    30.641     0.150
     1.814    30.750     0.150
     1.867    31.672     0.150
     1.901    32.070     0.150
     1.901    32.992     0.150
     1.947    32.523     0.150
     1.947    58.414     0.150
     1.978    33.148     0.150
     2.002    33.953     0.150
     2.002    56.953     0.150
     2.002    33.852     0.150
     2.049    35.750     0.150
     2.089    34.625     0.150
     2.267    36.891     0.150
     2.278    37.172     0.150
     2.276    36.922     0.150
     2.335    38.523     0.150
     2.335    37.820     0.150
     2.427    39.562     0.150
     2.505    40.719     0.150
     2.505    40.305     0.150
     2.552    41.664     0.150
     2.604    41.609     0.150
     2.652    42.070     0.150
     2.684    42.508     0.150
     2.710    42.703     0.150
     2.745    43.695     0.150
     2.799    44.609     0.150
     2.835    44.852     0.150
     2.822    44.562     0.150
     3.093    48.594     0.150
     3.189    50.125     0.150
     3.189    50.023     0.150
     3.227    50.328     0.150
     3.331    50.875     0.150
     3.615    56.133     0.150
     3.650    56.961     0.150
     3.678    58.078     0.150
     3.996    61.328     0.150
     4.105    62.852     0.150
     4.100    62.422     0.150
     4.365    66.328     0.150
     4.672    70.352     0.150
     4.812    72.703     0.150
     5.752    84.625     0.150
     6.263    93.164     0.150
     6.280    92.805     0.150
     7.318   106.805     0.150
     0.266     5.462     0.150
     0.266     9.082     0.150
     0.438     9.271     0.150
     0.593    11.651     0.150
     0.593    19.542     0.150
     0.583    12.422     0.150
     0.583    20.521     0.150
     0.662    12.712     0.150
     0.662    22.172     0.150
     0.718    13.691     0.150
     0.814    15.441     0.150
     0.830    15.892     0.150
     0.830    27.352     0.150
     0.940    18.611     0.150
     0.882    17.802     0.150
     0.882    29.731     0.150
     0.909    17.702     0.150
     0.909    30.691     0.150
     0.917    18.252     0.150
     0.917    31.302     0.150
     1.047    19.002     0.150
     1.048    19.401     0.150
     1.076    20.162     0.150
     1.122    22.191     0.150
     1.360    25.122     0.150
     1.381    24.662     0.150
     1.376    26.672     0.150
     1.434    45.762     0.150
     1.474    27.412     0.150
     1.474    48.021     0.150
     1.499    28.691     0.150
     1.499    49.092     0.150
     1.604    29.802     0.150
     1.604    52.191     0.150
     1.667    30.021     0.150
     1.667    52.021     0.150
     1.712    30.642     0.150
     1.737    30.861     0.150
     1.771    31.792     0.150
     1.844    33.312     0.150
     1.907    33.252     0.150
     1.884    33.962     0.150
     2.012    36.552     0.150
     2.058    35.242     0.150
     2.050    36.441     0.150
     2.105    36.312     0.150
     2.169    37.262     0.150
     2.156    39.072     0.150
     2.308    38.962     0.150
     2.354    40.432     0.150
     2.378    40.182     0.150
     2.542    43.252     0.150
     2.695    44.802     0.150
     2.734    45.462     0.150
     2.796    46.552     0.150
     2.798    46.372     0.150
     2.834    46.312     0.150
     2.882    46.782     0.150
     2.834    46.552     0.150
     2.902    48.191     0.150
     2.953    48.651     0.150
     2.932    49.012     0.150
     2.932    48.632     0.150
     2.937    49.132     0.150
     2.967    47.731     0.150
     2.995    48.632     0.150
     2.989    49.082     0.150
     3.224    51.812     0.150
     3.382    54.731     0.150
     3.382    54.842     0.150
     3.471    56.812     0.150
     3.524    57.172     0.150
     3.861    61.222     0.150
     5.029    78.151     0.150
     7.426   110.062     0.150
     0.385     7.855     0.150
     0.385    12.785     0.150
     0.497     9.414     0.150
     0.482     9.574     0.150
     0.482    16.715     0.150
     0.702    13.133     0.150
     0.702    22.684     0.150
     0.771    15.004     0.150
     0.771    24.973     0.150
     0.865    15.914     0.150
     0.932    18.152     0.150
     0.932    29.473     0.150
     0.965    18.953     0.150
     0.965    32.133     0.150
     0.999    17.992     0.150
     0.999    33.004     0.150
     1.135    21.195     0.150
     1.135    36.875     0.150
     1.225    22.113     0.150
     1.191    22.633     0.150
     1.191    38.684     0.150
     1.256    22.984     0.150
     1.235    23.402     0.150
     1.235    40.453     0.150
     1.361    26.016     0.150
     1.265    24.285     0.150
     1.265    41.344     0.150
     1.607    28.703     0.150
     1.656    29.473     0.150
     1.656    51.945     0.150
     1.687    31.355     0.150
     1.687    53.074     0.150
     1.758    32.043     0.150
     1.787    32.195     0.150
     1.787    55.742     0.150
     1.796    32.332     0.150
     1.796    56.445     0.150
     2.120    37.266     0.150
     2.256    39.023     0.150
     2.256    68.594     0.150
     2.345    40.434     0.150
     2.345    69.883     0.150
     2.345    39.855     0.150
     3.030    86.375     0.150
     3.211    52.875     0.150
     3.812    61.184     0.150
     3.812   105.633     0.150
     3.920    62.172     0.150
     3.920   107.484     0.150
     4.670    73.355     0.150
     5.280    82.215     0.150
     0.376     7.526     0.150
     0.376    12.986     0.150
     0.438     8.726     0.150
     0.438    14.855     0.150
     0.497     9.736     0.150
     0.497    16.776     0.150
     0.761    14.826     0.150
     0.761    25.526     0.150
     0.751    14.426     0.150
     0.751    24.826     0.150
     0.866    15.696     0.150
     0.866    27.286     0.150
     1.016    18.636     0.150
     1.016    32.625     0.150
     1.014    19.076     0.150
     1.014    32.766     0.150
     1.069    20.216     0.150
     1.069    35.105     0.150
     1.166    20.616     0.150
     1.166    37.396     0.150
     1.163    21.375     0.150
     1.163    37.006     0.150
     1.181    22.396     0.150
     1.181    37.956     0.150
     1.274    23.416     0.150
     1.301    41.526     0.150
     1.347    24.796     0.150
     1.347    43.166     0.150
     1.342    25.226     0.150
     1.447    27.116     0.150
     1.415    25.646     0.150
     1.415    44.585     0.150
     1.584    48.726     0.150
     1.742    30.766     0.150
     1.742    54.076     0.150
     1.767    30.776     0.150
     1.767    53.936     0.150
     1.785    31.636     0.150
     1.785    55.646     0.150
     1.819    31.266     0.150
     1.819    55.716     0.150
     1.838    32.486     0.150
     1.838    56.686     0.150
     1.915    34.136     0.150
     1.915    58.396     0.150
     1.951    34.246     0.150
     1.951    59.036     0.150
     2.248    66.835     0.150
     2.285    38.916     0.150
     2.285    67.556     0.150
     2.271    38.306     0.150
     2.271    67.706     0.150
     2.446    71.196     0.150
     2.505    72.416     0.150
     2.697    75.986     0.150
     2.844    87.446     0.150
     3.131    49.736     0.150
     3.131    87.716     0.150
     3.214    51.556     0.150
     3.214    89.966     0.150
     3.236    90.746     0.150
     3.908    61.146     0.150
     3.908   106.206     0.150
     4.043    62.936     0.150
     4.043   109.716     0.150
     4.256   131.296     0.150
     4.275    65.855     0.150
     4.757    72.556     0.150
     4.757   127.996     0.150
     5.373   142.085     0.150
     5.440   144.446     0.150
     6.219    92.526     0.150
     6.219   161.416     0.150
     0.407     8.555     0.150
     0.407    14.703     0.150
     0.407     8.242     0.150
     0.407    14.219     0.150
     0.568    11.672     0.150
     0.568    19.125     0.150
     0.650    11.195     0.150
     0.650    11.086     0.150
     0.693    12.625     0.150
     0.693    22.016     0.150
     0.693    12.508     0.150
     0.766    13.633     0.150
     0.807    15.273     0.150
     0.807    25.359     0.150
     0.845    15.805     0.150
     0.845    28.008     0.150
     0.842    16.125     0.150
     0.842    27.898     0.150
     0.879    16.875     0.150
     0.993    17.172     0.150
     0.993    29.422     0.150
     1.087    19.414     0.150
     1.087    20.609     0.150
     1.009    19.484     0.150
     1.009    33.688     0.150
     1.091    19.336     0.150
     1.176    22.539     0.150
     1.188    22.609     0.150
     1.209    22.703     0.150
     1.209    38.547     0.150
     1.334    23.086     0.150
     1.371    24.414     0.150
     1.498    26.555     0.150
     1.492    26.109     0.150
     1.492    45.273     0.150
     1.513    25.867     0.150
     1.639    27.859     0.150
     1.823    31.758     0.150
     1.823    31.828     0.150
     1.921    34.016     0.150
     1.941    33.422     0.150
     2.002    35.664     0.150
     2.005    35.078     0.150
     2.186    36.516     0.150
     2.159    38.234     0.150
     2.350    38.773     0.150
     2.405    39.875     0.150
     2.485    42.484     0.150
     2.455    40.789     0.150
     2.791    46.703     0.150
     2.994    47.562     0.150
     3.115    56.539     0.150
     3.150    50.984     0.150
     3.150    50.094     0.150
     3.150    55.578     0.150
     3.150    97.289     0.150
     3.188    57.172     0.150
     3.188    99.672     0.150
     3.294    53.078     0.150
     3.642    59.008     0.150
     3.750    59.805     0.150
     3.784    59.828     0.150
     3.893    60.375     0.150
     4.045    63.805     0.150
     4.061    64.172     0.150
     4.907    75.477     0.150
     5.244    81.258     0.150
     0.209     4.986     0.150
     0.209     8.695     0.150
     0.465     9.916     0.150
     0.465    16.836     0.150
     0.540    10.855     0.150
     0.540    18.766     0.150
     0.640    12.906     0.150
     0.640    23.416     0.150
     0.703    24.906     0.150
     0.759    15.436     0.150
     0.759    26.137     0.150
     0.966    18.506     0.150
     0.966    32.797     0.150
     1.048    19.887     0.150
     1.048    33.717     0.150
     1.163    22.275     0.150
     1.272    22.836     0.150
     1.343    24.146     0.150
     1.315    23.557     0.150
     1.522    26.355     0.150
     1.594    27.615     0.150
     1.714    29.387     0.150
     1.933    32.195     0.150
     1.985    33.436     0.150
     2.072    34.957     0.150
     2.330    37.377     0.150
     2.390    38.006     0.150
     2.417    39.445     0.150
     2.415    38.486     0.150
     2.717    43.096     0.150
     3.007    47.207     0.150
     3.063    48.906     0.150
     3.328    52.236     0.150
     3.321    51.736     0.150
     4.253    65.707     0.150
     5.664    84.605     0.150
     5.664    84.836     0.150
     0.402     8.004     0.150
     0.404     8.176     0.150
     0.431     8.496     0.150
     0.667    13.555     0.150
     0.911    17.246     0.150
     0.911    30.965     0.150
     0.911    16.836     0.150
     0.911    30.836     0.150
     0.968    18.656     0.150
     0.968    32.457     0.150
     0.968    32.734     0.150
     1.004    19.164     0.150
     1.004    32.797     0.150
     1.060    19.387     0.150
     1.060    34.434     0.150
     1.060    19.523     0.150
     1.060    35.035     0.150
     1.201    21.895     0.150
     1.201    38.816     0.150
     1.253    23.445     0.150
     1.293    23.484     0.150
     1.293    41.887     0.150
     1.293    24.105     0.150
     1.293    41.477     0.150
     1.308    42.355     0.150
     1.308    23.656     0.150
     1.308    41.266     0.150
     1.413    26.613     0.150
     1.372    24.637     0.150
     1.457    26.496     0.150
     1.457    45.875     0.150
     1.523    27.047     0.150
     1.521    27.305     0.150
     1.547    27.504     0.150
     1.660    29.555     0.150
     1.660    52.207     0.150
     1.660    28.766     0.150
     1.688    28.934     0.150
     1.688    29.824     0.150
     1.688    52.344     0.150
     1.731    30.895     0.150
     1.754    31.414     0.150
     1.754    55.605     0.150
     1.801    31.355     0.150
     1.844    32.457     0.150
     1.844    32.086     0.150
     1.922    33.254     0.150
     1.924    33.484     0.150
     1.941    33.746     0.150
     2.141    36.754     0.150
     2.168    36.746     0.150
     2.178    37.445     0.150
     2.178    37.887     0.150
     2.180    37.246     0.150
     2.273    38.535     0.150
     2.338    39.566     0.150
     2.338    39.363     0.150
     2.422    40.754     0.150
     2.501    41.324     0.150
     2.529    42.047     0.150
     2.554    42.664     0.150
     2.623    42.945     0.150
     2.668    43.363     0.150
     2.713    44.934     0.150
     2.804    45.855     0.150
     2.804    45.605     0.150
     2.804    49.664     0.150
     2.804    86.574     0.150
     2.877    46.855     0.150
     2.939    47.645     0.150
     3.165    49.945     0.150
     3.181    50.863     0.150
     3.184    50.523     0.150
     3.184    50.695     0.150
     3.284    51.766     0.150
     3.466    55.285     0.150
     3.479    55.375     0.150
     3.508    55.754     0.150
     3.528    55.977     0.150
     3.649    58.406     0.150
     3.659    58.613     0.150
     3.737    59.926     0.150
     3.894    61.766     0.150
     3.894    62.695     0.150
     3.894   108.664     0.150
     3.983    62.594     0.150
     3.983    63.066     0.150
     4.178    64.504     0.150
     4.178    64.664     0.150
     4.216    65.496     0.150
     4.610    71.297     0.150
     4.657    71.824     0.150
     4.705    72.316     0.150
     4.818    73.414     0.150
     4.916    75.215     0.150
     5.113    78.137     0.150
     5.113   137.285     0.150
     5.113   158.734     0.150
     5.113    77.477     0.150
     5.152    77.977     0.150
     5.167    78.234     0.150
     5.310    80.195     0.150
     5.374    80.215     0.150
     5.562    83.766     0.150
     5.821    87.207     0.150
     5.821    85.535     0.150
     5.821   182.637     0.150
     5.821    87.207     0.150
     6.165    92.035     0.150
     6.223    93.047     0.150
     6.809   100.695     0.150
     7.180   104.504     0.150
     7.180   103.895     0.150
     7.317   106.824     0.150
     7.469   109.734     0.150
     7.700   112.863     0.150
     8.000   116.625     0.150
     8.590   124.227     0.150
     8.633   124.734     0.150
     8.633   125.766     0.150
     8.633   219.926     0.150
     8.760   127.637     0.150
     9.646   139.465     0.150
    10.290   148.523     0.150
    12.153   173.059     0.150
    12.209   174.586     0.150
    21.691   289.887     0.150
    56.403  4227.328     0.150
    59.910   606.406     0.150
    60.925   612.273     0.150
    64.713   637.379     0.150
    65.445   642.750     0.150
    68.166   659.715     0.150
    88.677   774.543     0.150
   149.912  1189.430     0.150
     0.413     8.242     0.150
     0.413    15.281     0.150
     0.415     8.219     0.150
     0.440     8.500     0.150
     0.678    13.742     0.150
     0.678    24.699     0.150
     0.917    17.871     0.150
     0.917    30.590     0.150
     0.917    16.730     0.150
     0.917    31.012     0.150
     0.977    18.699     0.150
     0.977    32.602     0.150
     0.977    18.582     0.150
     0.990    32.629     0.150
     1.061    18.680     0.150
     1.061    34.949     0.150
     1.061    20.660     0.150
     1.061    34.730     0.150
     1.193    21.949     0.150
     1.263    23.582     0.150
     1.263    40.551     0.150
     1.313    23.191     0.150
     1.313    42.262     0.150
     1.313    23.059     0.150
     1.313    41.250     0.150
     1.282    23.949     0.150
     1.282    41.789     0.150
     1.282    42.000     0.150
     1.282    24.090     0.150
     1.282    41.039     0.150
     1.401    26.641     0.150
     1.459    25.770     0.150
     1.459    46.129     0.150
     1.532    48.480     0.150
     1.531    26.891     0.150
     1.556    27.801     0.150
     1.665    52.402     0.150
     1.665    28.992     0.150
     1.665    51.961     0.150
     1.681    29.422     0.150
     1.681    29.902     0.150
     1.681    52.680     0.150
     1.681    51.770     0.150
     1.740    30.969     0.150
     1.740    54.309     0.150
     1.748    31.859     0.150
     1.748    55.781     0.150
     1.808    32.031     0.150
     1.808    56.301     0.150
     1.847    33.730     0.150
     1.847    57.441     0.150
     1.847    32.180     0.150
     1.934    33.270     0.150
     1.934    33.609     0.150
     1.934    59.500     0.150
     1.929    33.551     0.150
     1.929    59.750     0.150
     1.951    33.582     0.150
     1.951    33.832     0.150
     2.150    36.910     0.150
     2.179    38.340     0.150
     2.181    38.230     0.150
     2.181    38.152     0.150
     2.181    69.070     0.150
     2.278    38.840     0.150
     2.325    39.840     0.150
     2.325    39.641     0.150
     2.416    40.992     0.150
     2.416    44.352     0.150
     2.533    42.402     0.150
     2.550    43.109     0.150
     2.677    43.629     0.150
     2.713    45.211     0.150
     2.799    45.672     0.150
     2.799    45.441     0.150
     2.799    79.730     0.150
     2.943    48.191     0.150
     3.175    51.301     0.150
     3.179    50.781     0.150
     3.291    52.941     0.150
     3.472    55.309     0.150
     3.477    55.270     0.150
     3.634    59.129     0.150
     3.973    63.051     0.150
     3.973   108.840     0.150
     4.128    64.469     0.150
     4.176    64.902     0.150
     4.176    74.539     0.150
     4.221    65.621     0.150
     4.618    72.219     0.150
     4.663    71.840     0.150
     4.708    72.332     0.150
     4.813    73.879     0.150
     4.923    75.289     0.150
     5.105    77.055     0.150
     5.105   157.805     0.150
     5.819    87.648     0.150
     5.819   184.605     0.150
     7.193   104.598     0.150
     8.621   126.082     0.150
     8.621   221.980     0.150
    12.139   173.180     0.150
    65.441   642.203     0.150
    68.163   660.305     0.150
     0.524    10.604     0.150
     0.524    10.834     0.150
     0.524    16.895     0.150
     0.679    12.084     0.150
     0.679    12.434     0.150
     0.680    12.705     0.150
     0.680    21.965     0.150
     0.770    14.424     0.150
     0.770    14.564     0.150
     0.770    25.924     0.150
     0.784    14.484     0.150
     0.784    24.273     0.150
     0.784    25.193     0.150
     0.808    15.744     0.150
     0.852    16.613     0.150
     0.948    18.904     0.150
     0.948    31.613     0.150
     0.973    19.273     0.150
     0.973    32.164     0.150
     1.053    18.854     0.150
     1.053    33.424     0.150
     1.080    20.785     0.150
     1.080    19.863     0.150
     1.150    20.094     0.150
     1.150    37.994     0.150
     1.123    22.094     0.150
     1.123    37.023     0.150
     1.182    21.285     0.150
     1.182    37.693     0.150
     1.280    25.264     0.150
     1.280    42.754     0.150
     1.244    23.354     0.150
     1.244    40.504     0.150
     1.244    23.715     0.150
     1.244    40.193     0.150
     1.291    22.564     0.150
     1.291    42.504     0.150
     1.257    24.574     0.150
     1.257    41.824     0.150
     1.257    42.104     0.150
     1.280    42.875     0.150
     1.341    25.334     0.150
     1.402    24.545     0.150
     1.402    43.895     0.150
     1.500    28.395     0.150
     1.500    48.984     0.150
     1.562    27.484     0.150
     1.574    27.834     0.150
     1.574    48.113     0.150
     1.718    31.604     0.150
     1.749    32.254     0.150
     1.753    32.113     0.150
     1.908    33.805     0.150
     1.907    33.184     0.150
     1.907    59.273     0.150
     1.941    34.854     0.150
     1.934    34.834     0.150
     1.934    34.045     0.150
     2.001    35.234     0.150
     2.013    35.004     0.150
     2.168    39.455     0.150
     2.168    39.664     0.150
     2.168    65.584     0.150
     2.168    69.773     0.150
     2.263    39.154     0.150
     2.282    40.693     0.150
     2.345    39.715     0.150
     2.426    41.295     0.150
     2.412    41.314     0.150
     2.456    41.504     0.150
     2.459    42.113     0.150
     2.459    41.494     0.150
     2.459    72.725     0.150
     2.598    44.314     0.150
     2.675    45.844     0.150
     2.918    48.904     0.150
     2.921    49.014     0.150
     2.958    47.725     0.150
     2.992    47.674     0.150
     3.067    49.234     0.150
     3.067    49.404     0.150
     3.067    95.334     0.150
     3.215    52.674     0.150
     3.229    52.184     0.150
     3.395    54.434     0.150
     3.450    55.215     0.150
     3.769    61.285     0.150
     3.769   103.773     0.150
     3.769   118.014     0.150
     3.796    60.045     0.150
     3.774    59.984     0.150
     3.774    60.693     0.150
     3.774   119.773     0.150
     3.903    61.625     0.150
     3.903    62.754     0.150
     3.961    62.693     0.150
     4.128    65.645     0.150
     4.166    65.914     0.150
     4.373    68.705     0.150
     4.407    68.594     0.150
     4.437    69.225     0.150
     4.670    72.785     0.150
     5.027    77.273     0.150
     5.340    81.465     0.150
     5.340   141.145     0.150
     5.373    83.164     0.150
     5.714    87.135     0.150
     5.921    89.734     0.150
     7.497   111.135     0.150
     8.469   125.215     0.150
     0.262     6.105     0.150
     0.262    10.914     0.150
     0.461    10.035     0.150
     0.800    15.453     0.150
     0.800    27.074     0.150
     0.826    15.586     0.150
     0.826    26.953     0.150
     0.826    26.844     0.150
     1.083    19.156     0.150
     1.083    34.066     0.150
     1.083    19.363     0.150
     1.083    34.203     0.150
     1.118    20.766     0.150
     1.118    35.645     0.150
     1.119    20.383     0.150
     1.119    35.086     0.150
     1.119    35.316     0.150
     1.261    21.926     0.150
     1.261    38.715     0.150
     1.261    22.066     0.150
     1.261    38.996     0.150
     1.256    22.594     0.150
     1.256    39.695     0.150
     1.256    39.895     0.150
     1.395    25.203     0.150
     1.395    44.215     0.150
     1.397    25.324     0.150
     1.397    44.453     0.150
     1.381    24.156     0.150
     1.381    43.473     0.150
     1.381    24.406     0.150
     1.461    25.695     0.150
     1.461    26.254     0.150
     1.561    27.625     0.150
     1.491    26.055     0.150
     1.491    25.344     0.150
     1.491    44.523     0.150
     1.561    27.895     0.150
     1.532    26.605     0.150
     1.532    47.164     0.150
     1.533    26.535     0.150
     1.533    45.836     0.150
     1.656    28.203     0.150
     1.656    49.906     0.150
     1.689    28.453     0.150
     1.689    49.633     0.150
     1.694    28.836     0.150
     1.845    30.723     0.150
     1.845    31.043     0.150
     1.845    55.074     0.150
     1.879    31.094     0.150
     1.901    31.805     0.150
     1.901    56.664     0.150
     1.956    32.676     0.150
     1.956    33.195     0.150
     1.956    34.844     0.150
     1.971    32.395     0.150
     2.038    34.375     0.150
     2.038    34.094     0.150
     2.037    34.336     0.150
     2.069    34.176     0.150
     2.088    34.176     0.150
     2.073    34.426     0.150
     2.039    33.734     0.150
     2.279    36.703     0.150
     2.298    37.254     0.150
     2.372    38.164     0.150
     2.371    38.363     0.150
     2.458    39.445     0.150
     2.624    42.004     0.150
     2.624    41.895     0.150
     2.624    46.934     0.150
     2.508    41.484     0.150
     2.717    43.434     0.150
     2.625    41.645     0.150
     2.625    41.984     0.150
     2.761    43.656     0.150
     2.757    44.113     0.150
     2.813    44.516     0.150
     2.819    44.336     0.150
     3.125    49.363     0.150
     3.139    50.035     0.150
     3.233    51.484     0.150
     3.304    51.633     0.150
     3.389    53.465     0.150
     3.460    54.215     0.150
     3.641    56.305     0.150
     3.692    57.746     0.150
     4.012    61.586     0.150
     4.103    62.094     0.150
     4.164    62.906     0.150
     4.164    63.734     0.150
     4.608    69.195     0.150
     4.647    69.383     0.150
     4.709    70.633     0.150
     4.709    71.203     0.150
     4.894    72.805     0.150
     4.958    74.664     0.150
     5.023    74.223     0.150
     5.507    80.566     0.150
     0.813    15.289     0.150
     0.813    25.910     0.150
     0.908    18.008     0.150
     0.908    31.367     0.150
     0.997    18.668     0.150
     0.997    31.980     0.150
     1.329    24.020     0.150
     1.329    41.469     0.150
     1.439    28.090     0.150
     1.439    48.148     0.150
     1.466    27.320     0.150
     1.466    47.328     0.150
     1.660    29.617     0.150
     1.660    51.980     0.150
     1.686    30.211     0.150
     1.686    52.379     0.150
     1.793    33.020     0.150
     1.793    56.480     0.150
     2.118    38.711     0.150
     2.118    64.141     0.150
     2.100    36.879     0.150
     2.100    64.840     0.150
     2.127    40.039     0.150
     2.127    64.938     0.150
     3.293    60.469     0.150
     3.293   103.430     0.150
     3.615    58.828     0.150
     4.428    70.438     0.150
     5.064    85.027     0.150
     0.709    13.726     0.150
     0.709    22.585     0.150
     0.754    14.706     0.150
     0.754    24.515     0.150
     0.754    14.595     0.150
     0.754    24.745     0.150
     0.862    17.025     0.150
     0.862    28.655     0.150
     0.945    18.785     0.150
     0.945    32.265     0.150
     0.945    18.965     0.150
     0.948    19.085     0.150
     0.948    31.855     0.150
     0.948    32.135     0.150
     1.027    18.925     0.150
     1.106    22.045     0.150
     1.106    37.655     0.150
     1.152    21.436     0.150
     1.266    25.146     0.150
     1.266    42.275     0.150
     1.249    23.865     0.150
     1.249    40.655     0.150
     1.249    24.125     0.150
     1.249    40.875     0.150
     1.254    24.625     0.150
     1.254    41.335     0.150
     1.254    41.835     0.150
     1.348    25.865     0.150
     1.348    45.045     0.150
     1.375    24.805     0.150
     1.375    24.695     0.150
     1.375    42.855     0.150
     1.419    25.365     0.150
     1.419    44.795     0.150
     1.419    25.375     0.150
     1.419    46.345     0.150
     1.472    28.235     0.150
     1.472    48.515     0.150
     1.538    48.995     0.150
     1.538    27.155     0.150
     1.546    28.146     0.150
     1.546    50.045     0.150
     1.546    28.015     0.150
     1.662    29.615     0.150
     1.662    54.065     0.150
     1.698    31.485     0.150
     1.698    54.815     0.150
     1.734    32.335     0.150
     1.879    33.565     0.150
     1.879    57.875     0.150
     1.879    33.675     0.150
     1.879    35.275     0.150
     1.987    62.325     0.150
     1.987    35.416     0.150
     1.985    62.226     0.150
     1.985    34.706     0.150
     2.139    38.755     0.150
     2.139    38.985     0.150
     2.236    69.285     0.150
     2.236    38.805     0.150
     2.251    39.385     0.150
     2.436    41.186     0.150
     2.472    41.745     0.150
     2.472    41.985     0.150
     2.472    74.255     0.150
     2.647    45.315     0.150
     2.647    79.775     0.150
     2.733    47.085     0.150
     2.938    48.146     0.150
     2.889    47.945     0.150
     2.892    48.485     0.150
     3.023    48.825     0.150
     3.021    49.005     0.150
     3.021    85.775     0.150
     3.021    49.375     0.150
     3.095    49.476     0.150
     3.189    51.936     0.150
     3.168    50.726     0.150
     3.172    52.476     0.150
     3.199    52.706     0.150
     3.295    53.545     0.150
     3.408    53.945     0.150
     3.424    54.505     0.150
     3.478    55.335     0.150
     3.619    57.436     0.150
     3.660    58.655     0.150
     3.660    59.575     0.150
     3.660   115.535     0.150
     3.797    59.545     0.150
     3.766    60.456     0.150
     3.745    60.686     0.150
     3.745    61.255     0.150
     3.745   107.035     0.150
     3.923    60.965     0.150
     3.935    62.765     0.150
     3.966    62.515     0.150
     4.136    66.105     0.150
     4.349    68.785     0.150
     4.496    71.726     0.150
     4.521    71.235     0.150
     4.645    72.245     0.150
     4.855    75.515     0.150
     4.978    76.635     0.150
     4.997    76.666     0.150
     5.151    77.896     0.150
     5.428    83.396     0.150
     5.473    82.585     0.150
     5.568    83.565     0.150
     5.564    84.416     0.150
     5.687    87.265     0.150
     5.896    89.735     0.150
     5.967    90.115     0.150
     6.560    98.075     0.150
     0.592    11.297     0.150
     0.592    18.289     0.150
     0.803    16.426     0.150
     0.803    27.117     0.150
     0.886    16.617     0.150
     0.886    28.605     0.150
     0.946    19.367     0.150
     0.946    32.176     0.150
     1.044    20.656     0.150
     1.044    35.117     0.150
     1.151    21.086     0.150
     1.151    37.059     0.150
     1.169    23.387     0.150
     1.169    39.289     0.150
     1.210    23.766     0.150
     1.210    39.809     0.150
     1.310    26.086     0.150
     1.252    24.918     0.150
     1.252    41.367     0.150
     1.501    27.539     0.150
     1.501    47.168     0.150
     1.547    28.727     0.150
     1.547    49.129     0.150
     1.586    30.086     0.150
     1.586    52.297     0.150
     1.676    30.516     0.150
     1.676    53.008     0.150
     1.837    33.156     0.150
     1.837    56.918     0.150
     2.009    36.918     0.150
     2.399    41.438     0.150
     2.399    71.988     0.150
     2.966    48.137     0.150
     3.639   101.199     0.150
     3.803   105.758     0.150
     3.803   120.996     0.150
     3.837    61.797     0.150
     3.837   106.977     0.150
     4.603    71.777     0.150
     4.603   125.379     0.150
     4.603   146.098     0.150
     4.678    73.066     0.150
     4.678   126.559     0.150
     5.248   162.988     0.150
     0.586    11.048     0.150
     0.586    17.628     0.150
     0.796    16.158     0.150
     0.796    27.528     0.150
     0.897    17.038     0.150
     0.897    28.998     0.150
     0.943    19.108     0.150
     0.943    32.148     0.150
     1.050    20.438     0.150
     1.050    34.948     0.150
     1.161    22.098     0.150
     1.161    36.858     0.150
     1.171    23.208     0.150
     1.171    38.878     0.150
     1.204    23.519     0.150
     1.204    39.368     0.150
     1.511    28.318     0.150
     1.511    47.388     0.150
     1.558    29.058     0.150
     1.558    48.928     0.150
     1.593    29.898     0.150
     1.593    51.578     0.150
     1.826    33.108     0.150
     1.826    57.479     0.150
     2.020    35.808     0.150
     2.020    62.498     0.150
     2.391    41.308     0.150
     2.391    72.088     0.150
     4.673    72.738     0.150
     4.673   126.328     0.150
     5.238   161.218     0.150
     0.292     5.973     0.150
     0.292    10.715     0.150
     0.292    10.965     0.150
     0.889    16.516     0.150
     0.889    28.812     0.150
     0.889    16.633     0.150
     1.149    20.652     0.150
     1.149    35.312     0.150
     1.149    35.414     0.150
     1.139    21.344     0.150
     1.139    36.324     0.150
     1.340    24.453     0.150
     1.340    42.402     0.150
     1.340    42.633     0.150
     1.319    24.203     0.150
     1.319    42.426     0.150
     1.319    24.023     0.150
     1.319    41.895     0.150
     1.367    23.613     0.150
     1.367    42.793     0.150
     1.438    26.695     0.150
     1.438    45.844     0.150
     1.438    45.703     0.150
     1.431    26.594     0.150
     1.431    45.562     0.150
     1.431    26.113     0.150
     1.507    27.004     0.150
     1.507    47.234     0.150
     1.541    26.973     0.150
     1.541    47.094     0.150
     1.556    28.793     0.150
     1.720    29.434     0.150
     1.720    30.402     0.150
     1.720    52.023     0.150
     1.664    29.312     0.150
     1.664    50.855     0.150
     1.779    30.254     0.150
     1.779    54.684     0.150
     1.779    30.395     0.150
     1.779    31.273     0.150
     1.779    54.645     0.150
     1.842    30.965     0.150
     1.886    32.523     0.150
     1.886    59.285     0.150
     1.908    33.312     0.150
     1.937    32.676     0.150
     1.959    33.293     0.150
     2.154    36.832     0.150
     2.169    36.344     0.150
     2.252    37.805     0.150
     2.251    38.176     0.150
     2.251    68.113     0.150
     2.333    38.613     0.150
     2.403    39.633     0.150
     2.403    69.434     0.150
     2.478    40.562     0.150
     2.593    41.613     0.150
     2.626    42.453     0.150
     2.673    42.824     0.150
     2.681    43.613     0.150
     2.753    44.832     0.150
     2.753    44.266     0.150
     3.001    47.766     0.150
     2.947    46.176     0.150
     3.071    49.562     0.150
     3.173    49.523     0.150
     3.513    54.305     0.150
     3.528    55.465     0.150
     3.561    56.594     0.150
     3.757    58.543     0.150
     3.974    61.285     0.150
     4.126    63.445     0.150
     4.266    64.625     0.150
     4.477    67.164     0.150
     4.558    68.504     0.150
     4.771    72.234     0.150
     4.785    72.473     0.150
     4.956    75.652     0.150
     5.183    77.414     0.150
     0.496     9.695     0.150
     0.496    17.426     0.150
     0.914    16.426     0.150
     0.914    28.234     0.150
     0.914    16.805     0.150
     0.914    28.535     0.150
     0.998    18.953     0.150
     0.998    31.793     0.150
     1.114    19.633     0.150
     1.114    35.574     0.150
     1.114    34.484     0.150
     1.160    21.824     0.150
     1.160    37.676     0.150
     1.160    36.094     0.150
     1.208    22.465     0.150
     1.208    39.184     0.150
     1.208    38.293     0.150
     1.281    22.965     0.150
     1.281    40.125     0.150
     1.300    22.914     0.150
     1.300    40.125     0.150
     1.307    22.844     0.150
     1.307    41.152     0.150
     1.317    23.914     0.150
     1.317    41.715     0.150
     1.364    25.152     0.150
     1.364    24.332     0.150
     1.364    41.984     0.150
     1.516    26.934     0.150
     1.516    45.492     0.150
     1.414    24.676     0.150
     1.414    43.344     0.150
     1.414    24.965     0.150
     1.414    43.145     0.150
     1.468    25.492     0.150
     1.468    45.555     0.150
     1.468    25.273     0.150
     1.466    26.484     0.150
     1.466    46.344     0.150
     1.466    26.305     0.150
     1.466    44.766     0.150
     1.502    26.465     0.150
     1.502    46.324     0.150
     1.516    27.285     0.150
     1.529    26.492     0.150
     1.529    47.043     0.150
     1.528    26.383     0.150
     1.589    27.582     0.150
     1.589    48.914     0.150
     1.679    29.023     0.150
     1.693    29.105     0.150
     1.693    51.414     0.150
     1.706    29.152     0.150
     1.706    52.223     0.150
     1.717    30.926     0.150
     1.717    53.844     0.150
     1.717    29.945     0.150
     1.717    50.883     0.150
     1.705    29.375     0.150
     1.705    52.344     0.150
     1.907    32.074     0.150
     1.907    56.992     0.150
     1.928    32.375     0.150
     1.928    57.125     0.150
     1.910    32.043     0.150
     2.003    33.793     0.150
     2.003    56.574     0.150
     2.002    33.895     0.150
     2.080    61.164     0.150
     2.080    33.516     0.150
     2.260    36.414     0.150
     2.260    64.812     0.150
     2.341    37.773     0.150
     2.341    66.844     0.150
     2.387    37.645     0.150
     2.387    68.402     0.150
     2.437    38.934     0.150
     2.410    39.254     0.150
     2.469    39.434     0.150
     2.574    40.645     0.150
     2.574    71.473     0.150
     2.748    44.113     0.150
     2.861    45.254     0.150
     2.932    46.254     0.150
     3.066    48.395     0.150
     3.121    48.434     0.150
     3.121    47.426     0.150
     3.259    51.074     0.150
     3.292    51.855     0.150
     3.324    52.543     0.150
     3.316    51.242     0.150
     3.391    51.863     0.150
     3.634    55.113     0.150
     3.750    56.434     0.150
     3.745    57.355     0.150
     3.827    58.824     0.150
     3.927    59.004     0.150
     4.005    61.242     0.150
     4.011    60.734     0.150
     4.077    61.805     0.150
     4.077    61.152     0.150
     4.233    63.254     0.150
     4.342    65.035     0.150
     4.349    64.676     0.150
     4.447    66.414     0.150
     4.519    67.934     0.150
     4.653    69.484     0.150
     4.885    73.133     0.150
     4.885   128.184     0.150
     4.940    73.234     0.150
     5.139    75.543     0.150
     5.178    76.945     0.150
     5.391    80.223     0.150
     5.448    80.125     0.150
     5.422    79.574     0.150
     5.768    87.152     0.150
     5.862    84.324     0.150
     0.250     4.109     0.150
     0.296     5.594     0.150
     0.555    10.781     0.150
     0.546    11.523     0.150
     0.827    17.234     0.150
     0.842    16.000     0.150
     1.124    21.875     0.150
     0.995    19.453     0.150
     1.224    23.945     0.150
     1.088    22.039     0.150
     1.405    26.953     0.150
     1.501    28.234     0.150
     1.589    29.852     0.150
     1.683    30.703     0.150
     1.793    31.586     0.150
     1.783    31.555     0.150
     1.623    29.781     0.150
     2.003    35.266     0.150
     2.045    36.414     0.150
     2.017    37.227     0.150
     2.368    42.000     0.150
     2.407    43.320     0.150
     2.778    46.109     0.150
     2.875    47.289     0.150
     2.964    48.562     0.150
     3.025    49.352     0.150
     3.077    48.266     0.150
     3.046    49.703     0.150
     3.309    53.836     0.150
     3.402    56.266     0.150
     3.882    62.422     0.150
     4.058    64.023     0.150
     4.001    63.242     0.150
     4.318    67.156     0.150
     4.458    69.727     0.150
     4.500    70.023     0.150
     4.659    72.555     0.150
     4.676    72.695     0.150
     5.113    78.461     0.150
     7.084   236.430     0.150
     0.397     8.008     0.150
     0.397    13.336     0.150
     0.399     8.027     0.150
     0.399    13.227     0.150
     0.470     8.867     0.150
     0.659    12.918     0.150
     0.954    18.688     0.150
     0.954    32.105     0.150
     1.028    19.027     0.150
     1.028    32.828     0.150
     1.028    19.137     0.150
     1.028    32.707     0.150
     1.162    22.559     0.150
     1.162    38.625     0.150
     1.243    23.617     0.150
     1.243    23.316     0.150
     1.243    40.746     0.150
     1.283    23.836     0.150
     1.257    24.246     0.150
     1.257    42.465     0.150
     1.257    24.617     0.150
     1.257    42.047     0.150
     1.379    26.695     0.150
     1.379    45.957     0.150
     1.426    26.246     0.150
     1.426    46.098     0.150
     1.635    29.676     0.150
     1.635    29.188     0.150
     1.685    30.168     0.150
     1.685    53.508     0.150
     1.684    29.785     0.150
     1.684    53.738     0.150
     1.715    32.336     0.150
     1.715    55.535     0.150
     1.715    31.887     0.150
     1.709    30.758     0.150
     1.709    53.848     0.150
     1.709    30.926     0.150
     1.709    53.445     0.150
     1.780    31.945     0.150
     1.780    53.785     0.150
     1.815    32.785     0.150
     1.815    57.426     0.150
     1.815    33.188     0.150
     1.815    57.836     0.150
     1.902    33.695     0.150
     1.902    57.777     0.150
     1.910    33.809     0.150
     1.910    58.957     0.150
     2.149    38.465     0.150
     2.149    68.348     0.150
     2.198    38.777     0.150
     2.198    66.008     0.150
     2.247    38.367     0.150
     2.335    40.715     0.150
     2.335    69.336     0.150
     2.335    40.465     0.150
     2.335    70.285     0.150
     2.384    42.348     0.150
     2.384    44.578     0.150
     2.384    71.738     0.150
     2.501    41.746     0.150
     2.516    42.387     0.150
     2.747    45.586     0.150
     2.830    46.637     0.150
     2.830    46.777     0.150
     2.912    49.027     0.150
     3.006    50.426     0.150
     3.151    51.375     0.150
     3.154    52.457     0.150
     3.443    55.777     0.150
     3.443    97.797     0.150
     3.472    56.656     0.150
     3.516    55.258     0.150
     3.862   108.926     0.150
     3.944    63.656     0.150
     3.944    63.156     0.150
     3.944   110.309     0.150
     3.944   122.809     0.150
     4.142    65.375     0.150
     4.192    66.617     0.150
     4.402    70.516     0.150
     4.419    68.438     0.150
     4.591    72.387     0.150
     4.634    72.656     0.150
     4.677    73.016     0.150
     4.725    75.496     0.150
     4.779    74.688     0.150
     4.894    76.348     0.150
     4.946    77.508     0.150
     5.150    78.906     0.150
     5.576    85.215     0.150
     3.142    51.488     0.150
     0.416     8.078     0.150
     0.416    13.312     0.150
     0.416     7.945     0.150
     0.416    13.742     0.150
     0.493     9.883     0.150
     0.493    17.125     0.150
     0.495     9.883     0.150
     0.495    16.688     0.150
     0.759    15.234     0.150
     0.759    26.633     0.150
     0.977    19.023     0.150
     0.977    32.344     0.150
     0.977    31.867     0.150
     1.061    19.945     0.150
     1.061    34.062     0.150
     1.140    20.125     0.150
     1.140    36.672     0.150
     1.140    20.359     0.150
     1.140    36.195     0.150
     1.152    22.203     0.150
     1.152    37.734     0.150
     1.152    21.836     0.150
     1.152    37.336     0.150
     1.234    22.836     0.150
     1.234    40.406     0.150
     1.234    39.734     0.150
     1.265    24.273     0.150
     1.265    41.164     0.150
     1.265    23.914     0.150
     1.302    24.516     0.150
     1.302    42.258     0.150
     1.302    24.727     0.150
     1.407    26.836     0.150
     1.407    45.539     0.150
     1.345    25.016     0.150
     1.345    43.555     0.150
     1.345    43.188     0.150
     1.397    24.812     0.150
     1.397    43.789     0.150
     1.407    26.273     0.150
     1.537    27.469     0.150
     1.537    48.414     0.150
     1.748    30.508     0.150
     1.748    53.188     0.150
     1.748    54.594     0.150
     1.799    32.898     0.150
     1.799    56.625     0.150
     1.799    33.008     0.150
     1.799    56.945     0.150
     1.798    31.227     0.150
     1.798    55.633     0.150
     1.798    31.242     0.150
     1.798    54.484     0.150
     1.893    32.828     0.150
     1.893    56.844     0.150
     1.928    34.039     0.150
     1.928    57.508     0.150
     1.928    33.789     0.150
     1.928    60.094     0.150
     2.014    34.844     0.150
     2.014    60.859     0.150
     2.088    35.883     0.150
     2.262    38.289     0.150
     2.262    38.375     0.150
     2.262    64.383     0.150
     2.260    38.406     0.150
     2.257    37.922     0.150
     2.361    39.336     0.150
     2.467    45.078     0.150
     2.612    43.438     0.150
     2.615    43.023     0.150
     2.641    44.406     0.150
     2.716    44.812     0.150
     2.716    43.547     0.150
     2.716    75.039     0.150
     3.375    53.055     0.150
     3.556    55.586     0.150
     3.575    55.438     0.150
     3.580    56.945     0.150
     3.639    57.203     0.150
     4.003    62.625     0.150
     4.003    62.992     0.150
     4.003   109.359     0.150
     4.241    67.086     0.150
     4.241    77.117     0.150
     4.241    65.305     0.150
     4.305    66.766     0.150
     4.498    68.836     0.150
     4.747    72.297     0.150
     4.798    72.984     0.150
     4.798    73.945     0.150
     4.798    89.133     0.150
     4.798   125.383     0.150
     3.230    50.984     0.150
     0.418     8.164     0.150
     0.418    13.734     0.150
     0.418     8.047     0.150
     0.418    13.867     0.150
     0.497    10.008     0.150
     0.497    17.125     0.150
     0.500    10.008     0.150
     0.500    16.648     0.150
     0.763    15.469     0.150
     0.763    25.680     0.150
     0.763    15.148     0.150
     0.763    26.625     0.150
     0.974    19.039     0.150
     0.974    32.500     0.150
     0.974    31.984     0.150
     1.065    19.891     0.150
     1.065    34.586     0.150
     1.065    19.570     0.150
     1.065    34.477     0.150
     1.142    20.406     0.150
     1.142    36.328     0.150
     1.142    20.516     0.150
     1.142    36.820     0.150
     1.148    21.711     0.150
     1.148    21.539     0.150
     1.148    37.188     0.150
     1.234    22.898     0.150
     1.234    40.375     0.150
     1.234    40.008     0.150
     1.262    23.688     0.150
     1.262    41.516     0.150
     1.262    24.219     0.150
     1.262    41.156     0.150
     1.300    24.664     0.150
     1.300    42.586     0.150
     1.300    24.391     0.150
     1.405    26.930     0.150
     1.405    45.617     0.150
     1.349    25.148     0.150
     1.349    42.602     0.150
     1.349    24.734     0.150
     1.349    43.305     0.150
     1.400    25.789     0.150
     1.400    44.734     0.150
     1.400    24.914     0.150
     1.405    26.781     0.150
     1.540    27.180     0.150
     1.540    48.656     0.150
     1.593    27.906     0.150
     1.593    49.938     0.150
     1.593    28.266     0.150
     1.593    49.477     0.150
     1.751    30.664     0.150
     1.751    55.008     0.150
     1.751    30.805     0.150
     1.751    53.250     0.150
     1.801    31.336     0.150
     1.801    54.938     0.150
     1.801    30.836     0.150
     1.801    56.984     0.150
     1.800    32.484     0.150
     1.800    31.945     0.150
     1.800    55.945     0.150
     1.896    32.938     0.150
     1.931    33.586     0.150
     1.931    60.852     0.150
     1.931    33.945     0.150
     1.931    58.688     0.150
     2.017    34.688     0.150
     2.021    61.711     0.150
     2.084    36.617     0.150
     2.265    37.914     0.150
     2.265    69.102     0.150
     2.265    38.602     0.150
     2.265    65.977     0.150
     2.264    37.930     0.150
     2.252    37.969     0.150
     2.252    65.148     0.150
     2.364    39.656     0.150
     2.614    43.328     0.150
     2.618    43.367     0.150
     2.639    43.148     0.150
     2.713    45.250     0.150
     2.713    43.539     0.150
     2.713    75.008     0.150
     2.713    84.125     0.150
     2.843    45.117     0.150
     3.235    53.070     0.150
     3.559    55.547     0.150
     3.578    57.516     0.150
     4.002    62.641     0.150
     4.002   109.008     0.150
     4.242    66.031     0.150
     4.242    77.039     0.150
     4.242   116.039     0.150
     4.242    64.875     0.150
     4.309    66.398     0.150
     4.797    72.711     0.150
     4.797    73.781     0.150
     4.797    88.484     0.150
     4.797   128.664     0.150
     5.011    75.852     0.150
     3.231    50.430     0.150
     0.497     9.797     0.150
     0.497    16.891     0.150
     0.745    13.977     0.150
     0.858    16.820     0.150
     0.933    17.258     0.150
     0.988    19.875     0.150
     1.060    19.750     0.150
     1.168    20.875     0.150
     1.250    24.094     0.150
     1.428    25.156     0.150
     1.507    26.758     0.150
     1.542    27.477     0.150
     1.658    29.875     0.150
     1.689    30.336     0.150
     1.988    35.008     0.150
     2.095    36.344     0.150
     2.112    35.750     0.150
     2.169    37.555     0.150
     2.118    38.297     0.150
     2.288    39.227     0.150
     2.353    39.461     0.150
     2.515    42.055     0.150
     2.579    43.250     0.150
     2.617    42.344     0.150
     2.886    48.766     0.150
     2.971    47.898     0.150
     2.990    48.141     0.150
     3.105    50.258     0.150
     3.169    51.906     0.150
     3.205    51.180     0.150
     3.470    56.164     0.150
     3.893    60.164     0.150
     3.901    60.914     0.150
     4.517    69.719     0.150
     1.250    24.953     0.150
     2.288    39.609     0.150
     2.288    39.750     0.150
     2.288    39.469     0.150
     2.990    48.555     0.150
     2.990    48.664     0.150
     3.105    52.164     0.150
     3.169    52.867     0.150
     3.669    60.609     0.150
     4.000    63.164     0.150
     5.217    79.469     0.150
     5.483    82.875     0.150
     0.471     9.266     0.150
     0.641    12.086     0.150
     0.964    32.023     0.150
     0.964    17.641     0.150
     1.273    24.125     0.150
     1.343    25.141     0.150
     1.482    26.109     0.150
     1.580    28.406     0.150
     1.620    27.945     0.150
     1.620    50.125     0.150
     1.756    54.844     0.150
     1.756    31.594     0.150
     1.750    30.000     0.150
     1.741    30.680     0.150
     1.912    33.664     0.150
     1.947    34.266     0.150
     2.720    46.539     0.150
     2.867    48.094     0.150
     3.152    50.664     0.150
     3.396    54.922     0.150
     3.778    60.352     0.150
     3.794    59.734     0.150
     3.772    59.344     0.150
     4.008    62.734     0.150
     4.007    63.000     0.150
     4.262    66.023     0.150
     4.560    70.266     0.150
     4.853    74.664     0.150
     5.015    75.281     0.150
     5.098    78.453     0.150
     5.386    80.992     0.150
     5.890    89.430     0.150
     6.176    93.312     0.150
     6.179    92.422     0.150
     6.613   100.289     0.150
     7.250   107.000     0.150
     7.351   108.594     0.150
     7.914   116.094     0.150
     8.417   123.070     0.150
     9.429   138.734     0.150
     9.530   140.336     0.150
    11.283   162.180     0.150
    12.285   175.336     0.150
    12.704   181.164     0.150
    12.891   184.930     0.150
    15.340   218.859     0.150
    16.004   224.641     0.150
    19.949   271.102     0.150
    20.739   279.352     0.150
    29.028   359.992     0.150
    75.085   703.445     0.150
     7.250   107.211     0.150
    35.130   413.312     0.150
    39.967   456.609     0.150
    45.278   498.414     0.150
    48.585   523.312     0.150
    59.517   604.609     0.150
    60.749   611.211     0.150
    61.073   614.812     0.150
    62.800   625.211     0.150
    63.996   634.414     0.150
    65.157   641.016     0.150
    67.993   658.812     0.150
     0.508    17.195     0.150
     0.753    23.703     0.150
     0.753    14.266     0.150
     0.860    27.086     0.150
     0.860    15.906     0.150
     0.942    17.883     0.150
     0.978    19.055     0.150
     1.050    20.211     0.150
     1.259    41.773     0.150
     1.259    24.711     0.150
     1.434    27.367     0.150
     1.542    29.023     0.150
     1.511    46.914     0.150
     1.511    27.047     0.150
     1.545    27.406     0.150
     1.545    47.727     0.150
     1.660    31.023     0.150
     1.660    51.172     0.150
     1.694    31.164     0.150
     1.836    57.414     0.150
     1.836    34.336     0.150
     1.876    34.602     0.150
     1.876    60.414     0.150
     1.920    35.203     0.150
     1.990    36.281     0.150
     2.279    40.117     0.150
     2.356    41.281     0.150
     2.524    42.922     0.150
     2.586    44.133     0.150
     2.615    45.805     0.150
     3.112    50.414     0.150
     3.174    52.570     0.150
     3.202    53.773     0.150
     3.983    62.312     0.150
     3.897    63.273     0.150
     4.518    71.375     0.150
     4.984    76.227     0.150
     5.018    77.961     0.150
     6.600    98.695     0.150
     6.764    99.461     0.150
     7.333   109.500     0.150
    15.999   224.852     0.150
    19.316   268.273     0.150
    20.726   280.445     0.150
     0.489    16.141     0.150
     0.886    15.672     0.150
     0.944    17.945     0.150
     0.944    31.492     0.150
     1.259    42.375     0.150
     1.259    24.445     0.150
     1.312    43.766     0.150
     1.312    25.211     0.150
     1.568    47.531     0.150
     1.809    55.961     0.150
     1.809    33.219     0.150
     1.885    58.984     0.150
     1.925    60.883     0.150
     1.925    34.883     0.150
     2.110    37.086     0.150
     2.110    65.625     0.150
     2.179    38.125     0.150
     2.153    39.055     0.150
     2.381    41.766     0.150
     2.524    42.539     0.150
     2.594    43.844     0.150
     2.651    45.086     0.150
     3.122    50.906     0.150
     3.192    51.680     0.150
     3.240    53.570     0.150
     3.499    56.109     0.150
     3.988    62.133     0.150
     3.936    63.180     0.150
     4.190    66.266     0.150
     4.991    75.789     0.150
     5.839    90.883     0.150
     5.853    88.836     0.150
     6.138    93.633     0.150
     6.824   102.266     0.150
     7.247   107.930     0.150
     7.336   108.922     0.150
     8.266   121.414     0.150
     9.355   137.484     0.150
    10.246   149.164     0.150
    11.278   163.500     0.150
    12.242   179.266     0.150
     0.528    10.305     0.150
     0.665    21.016     0.150
     0.665    12.945     0.150
     0.829    15.125     0.150
     0.829    25.938     0.150
     0.915    29.562     0.150
     0.915    17.422     0.150
     0.885    17.297     0.150
     0.997    18.469     0.150
     1.153    39.031     0.150
     1.141    22.172     0.150
     1.141    37.992     0.150
     1.327    40.844     0.150
     1.354    42.125     0.150
     1.354    23.953     0.150
     1.439    27.281     0.150
     1.464    45.766     0.150
     1.464    27.055     0.150
     1.524    27.102     0.150
     1.652    29.125     0.150
     1.730    55.445     0.150
     1.730    32.148     0.150
     1.788    56.742     0.150
     1.788    33.125     0.150
     1.959    35.828     0.150
     1.924    35.188     0.150
     1.932    61.992     0.150
     1.932    36.867     0.150
     2.058    37.352     0.150
     2.034    36.016     0.150
     2.161    39.438     0.150
     2.409    41.328     0.150
     2.441    42.875     0.150
     2.412    42.758     0.150
     2.606    45.023     0.150
     3.002    50.914     0.150
     3.140    52.102     0.150
     3.341    54.008     0.150
     3.313    55.906     0.150
     3.500    55.531     0.150
     3.617    57.234     0.150
     3.521    57.672     0.150
     3.633    59.305     0.150
     3.698    60.242     0.150
     3.848    60.914     0.150
     3.878    61.898     0.150
     3.955    63.758     0.150
     4.319    68.227     0.150
     4.667    73.797     0.150
     4.821    75.672     0.150
     4.863    77.031     0.150
     5.149    79.766     0.150
     5.614    84.523     0.150
     5.621    87.438     0.150
     7.154   106.023     0.150
     7.204   107.555     0.150
     8.149   120.594     0.150
     9.394   137.648     0.150
    10.204   149.008     0.150
    10.557   153.562     0.150
    10.866   158.812     0.150
    15.889   225.094     0.150
    36.881   430.844     0.150
     0.543    17.828     0.150
     0.736    23.438     0.150
     0.736    13.969     0.150
     0.917    16.875     0.150
     0.917    29.133     0.150
     0.995    17.328     0.150
     0.995    32.828     0.150
     0.984    33.633     0.150
     0.984    19.469     0.150
     1.007    32.633     0.150
     1.007    19.914     0.150
     1.311    44.289     0.150
     1.311    25.078     0.150
     1.358    44.930     0.150
     1.358    25.664     0.150
     1.491    27.883     0.150
     1.569    48.727     0.150
     1.594    51.086     0.150
     1.602    50.703     0.150
     1.602    28.539     0.150
     1.717    53.484     0.150
     1.752    31.477     0.150
     1.752    55.047     0.150
     1.779    55.477     0.150
     1.779    32.578     0.150
     1.878    33.508     0.150
     1.878    57.078     0.150
     1.932    35.086     0.150
     1.932    61.492     0.150
     1.975    62.133     0.150
     2.046    36.812     0.150
     2.158    37.836     0.150
     2.172    38.398     0.150
     2.231    38.773     0.150
     2.227    39.227     0.150
     2.413    42.156     0.150
     2.576    42.938     0.150
     2.642    44.234     0.150
     2.663    47.703     0.150
     2.825    46.938     0.150
     3.169    51.305     0.150
     3.232    52.766     0.150
     3.247    54.234     0.150
     3.384    54.562     0.150
     4.038    62.906     0.150
     5.061    78.914     0.150
     6.550    97.594     0.150
     8.318   122.539     0.150
     8.461   123.734     0.150
     8.583   125.859     0.150
     9.624   139.984     0.150
    10.291   149.234     0.150
     0.479     9.570     0.150
     0.479    16.539     0.150
     0.629    11.547     0.150
     0.629    20.000     0.150
     0.769    13.867     0.150
     0.900    16.766     0.150
     0.900    28.945     0.150
     0.949    17.266     0.150
     0.949    29.664     0.150
     1.093    21.586     0.150
     1.099    19.945     0.150
     1.222    38.219     0.150
     1.315    23.531     0.150
     1.378    45.836     0.150
     1.429    44.961     0.150
     1.475    26.000     0.150
     1.603    27.836     0.150
     1.675    54.750     0.150
     1.675    30.695     0.150
     1.730    56.500     0.150
     1.747    57.797     0.150
     1.747    32.445     0.150
     1.759    31.930     0.150
     1.885    33.891     0.150
     1.904    34.547     0.150
     1.946    62.969     0.150
     1.946    35.547     0.150
     1.999    36.219     0.150
     2.067    36.719     0.150
     2.125    38.125     0.150
     2.350    40.469     0.150
     2.386    40.648     0.150
     2.400    41.688     0.150
     2.465    75.430     0.150
     2.465    42.461     0.150
     2.537    78.875     0.150
     2.537    44.164     0.150
     2.580    47.250     0.150
     2.600    46.180     0.150
     2.698    46.031     0.150
     2.702    49.391     0.150
     2.737    82.898     0.150
     2.904    48.758     0.150
     2.951    48.875     0.150
     2.997    50.656     0.150
     3.099    52.047     0.150
     3.099    92.961     0.150
     3.116    97.031     0.150
     3.186    52.609     0.150
     3.219    56.375     0.150
     3.287    53.680     0.150
     3.262    54.078     0.150
     3.440    54.945     0.150
     3.552    56.414     0.150
     3.614    58.797     0.150
     3.695    60.117     0.150
     3.791    59.914     0.150
     3.839    62.367     0.150
     3.955    63.625     0.150
     3.974    63.695     0.150
     4.287    68.148     0.150
     4.293    69.688     0.150
     4.818    75.414     0.150
     4.898    76.719     0.150
     5.123    80.625     0.150
     5.885    90.547     0.150
     6.434    97.961     0.150
     6.718    98.914     0.150
     8.106   121.258     0.150
     9.130   136.109     0.150
     9.238   137.094     0.150
    33.974   405.406     0.150
     0.468     9.094     0.150
     0.468    15.828     0.150
     0.957    29.375     0.150
     1.093    21.734     0.150
     1.228    37.727     0.150
     1.378    26.180     0.150
     1.378    45.625     0.150
     1.482    26.562     0.150
     1.482    45.695     0.150
     1.771    31.094     0.150
     1.908    34.258     0.150
     1.895    33.258     0.150
     2.001    35.914     0.150
     1.961    35.547     0.150
     2.055    36.703     0.150
     2.055    63.406     0.150
     2.136    36.766     0.150
     2.351    40.242     0.150
     2.391    41.477     0.150
     2.415    42.586     0.150
     2.461    41.484     0.150
     2.593    45.844     0.150
     2.714    46.008     0.150
     2.910    47.812     0.150
     2.959    48.719     0.150
     3.012    50.594     0.150
     3.128    53.234     0.150
     3.171    53.188     0.150
     3.206    51.609     0.150
     3.292    52.930     0.150
     3.269    53.508     0.150
     3.575    56.953     0.150
     3.540    56.625     0.150
     3.566    57.734     0.150
     3.628    58.789     0.150
     3.710    60.094     0.150
     3.795    59.398     0.150
     3.849    61.539     0.150
     3.970    63.664     0.150
     4.020    63.727     0.150
     3.989    64.273     0.150
     4.092    64.828     0.150
     4.079    65.844     0.150
     4.101    65.289     0.150
     4.102    64.492     0.150
     4.181    65.664     0.150
     4.198    66.438     0.150
     4.284    66.336     0.150
     4.302    67.523     0.150
     4.299    67.609     0.150
     4.308    69.062     0.150
     4.391    69.445     0.150
     4.398    70.117     0.150
     4.410    70.039     0.150
     4.568    71.609     0.150
     4.632    73.383     0.150
     4.789    72.945     0.150
     4.871    76.016     0.150
     4.833    75.133     0.150
     4.912    76.719     0.150
     5.121    78.094     0.150
     5.102    78.445     0.150
     5.136    79.992     0.150
     5.339    83.195     0.150
     5.356    81.984     0.150
     5.430    98.680     0.150
     5.500    83.945     0.150
     5.562    83.586     0.150
     5.532    84.273     0.150
     5.595    86.742     0.150
     5.639    86.898     0.150
     5.666    87.258     0.150
     5.771    87.297     0.150
     5.906    90.367     0.150
     5.899    90.195     0.150
     6.305    96.125     0.150
     6.327    96.367     0.150
     6.369    95.430     0.150
     6.387    96.742     0.150
     6.452    98.227     0.150
     6.566    98.242     0.150
     6.525    99.125     0.150
     6.807   102.273     0.150
     7.094   104.828     0.150
     7.150   106.648     0.150
     7.247   109.117     0.150
     7.239   108.539     0.150
     7.586   112.289     0.150
     7.681   113.242     0.150
     7.891   116.133     0.150
     8.231   121.180     0.150
     8.310   123.055     0.150
     9.145   136.359     0.150
     9.217   136.930     0.150
     9.286   138.383     0.150
     9.561   139.242     0.150
    10.028   145.734     0.150
    10.289   151.836     0.150
    10.524   152.375     0.150
    10.818   156.688     0.150
    11.118   160.539     0.150
    11.082   162.047     0.150
    12.403   178.703     0.150
    16.141   231.383     0.150
    20.547   279.328     0.150
    21.215   289.906     0.150
    22.451   301.828     0.150
    25.111   327.359     0.150
    34.069   407.703     0.150
    37.918   439.219     0.150
    59.208   602.836     0.150
    59.294   602.984     0.150
    59.467   605.406     0.150
    60.456   609.906     0.150
    64.237   636.680     0.150
    67.697   657.742     0.150
    67.761   658.148     0.150
    69.413   669.180     0.150
    70.487   677.195     0.150
    71.513   682.625     0.150
    73.429   694.266     0.150
    73.790   695.828     0.150
    74.657   700.859     0.150
    74.762   702.258     0.150
    74.795   702.648     0.150
    75.185   704.539     0.150
    76.312   710.734     0.150
    78.347   721.797     0.150
    78.806   725.375     0.150
    79.968   730.836     0.150
    88.264   773.977     0.150
     0.472     9.219     0.150
     0.472    15.227     0.150
     0.637    11.852     0.150
     1.093    21.531     0.150
     1.093    37.742     0.150
     1.227    37.875     0.150
     1.481    26.094     0.150
     1.481    46.477     0.150
     1.767    31.508     0.150
     1.767    55.031     0.150
     1.907    34.094     0.150
     2.001    35.812     0.150
     2.133    36.352     0.150
     2.058    63.703     0.150
     2.058    35.477     0.150
     2.351    40.586     0.150
     2.390    40.594     0.150
     2.411    42.344     0.150
     2.590    45.047     0.150
     2.462    42.172     0.150
     2.709    46.164     0.150
     2.909    46.719     0.150
     2.957    47.969     0.150
     3.007    49.117     0.150
     3.291    52.656     0.150
     3.176    51.742     0.150
     3.267    52.172     0.150
     3.573    56.102     0.150
     3.624    57.352     0.150
     3.543    56.312     0.150
     3.562    58.023     0.150
     3.794    59.125     0.150
     3.705    59.586     0.150
     3.846    60.648     0.150
     3.965    62.445     0.150
     3.985    63.523     0.150
     4.090    64.258     0.150
     4.179    64.914     0.150
     4.106    65.492     0.150
     4.282    66.633     0.150
     4.299    67.625     0.150
     4.296    68.055     0.150
     4.303    68.781     0.150
     4.388    68.945     0.150
     4.566    71.305     0.150
     4.630    72.016     0.150
     4.869    74.922     0.150
     4.829    73.695     0.150
     4.907    75.484     0.150
     5.132    79.266     0.150
     5.335    83.031     0.150
     5.495    83.375     0.150
     5.592    86.445     0.150
     5.634    86.234     0.150
     5.895    88.812     0.150
     6.324    96.602     0.150
     7.094   104.914     0.150
     7.234   107.453     0.150
     7.890   115.969     0.150
     8.306   122.156     0.150
     9.140   135.156     0.150
    10.285   151.148     0.150
    10.360   152.117     0.150
    17.622   247.453     0.150
    17.935   251.203     0.150
    18.502   258.383     0.150
    18.552   260.547     0.150
    18.878   262.633     0.150
    18.979   262.523     0.150
    19.651   271.016     0.150
    19.739   272.203     0.150
    20.613   280.953     0.150
    21.071   286.414     0.150
     0.500    16.555     0.150
     0.517     9.750     0.150
     0.517    17.320     0.150
     0.694    12.773     0.150
     0.842    26.930     0.150
     0.842    15.375     0.150
     1.002    31.305     0.150
     1.002    17.305     0.150
     1.018    34.953     0.150
     1.018    20.531     0.150
     1.120    35.250     0.150
     1.120    20.680     0.150
     1.173    37.391     0.150
     1.173    21.430     0.150
     1.203    21.633     0.150
     1.302    44.492     0.150
     1.317    24.430     0.150
     1.317    41.570     0.150
     1.369    23.859     0.150
     1.369    43.586     0.150
     1.497    25.875     0.150
     1.497    46.266     0.150
     1.578    29.242     0.150
     1.639    31.109     0.150
     1.663    31.742     0.150
     1.647    29.336     0.150
     1.647    51.227     0.150
     1.774    53.984     0.150
     1.774    31.586     0.150
     1.808    57.391     0.150
     1.808    32.555     0.150
     1.914    35.023     0.150
     1.874    34.680     0.150
     2.013    34.922     0.150
     2.266    39.320     0.150
     2.289    39.016     0.150
     2.178    66.430     0.150
     2.300    40.344     0.150
     2.625    44.523     0.150
     2.560    42.383     0.150
     2.803    45.852     0.150
     2.842    46.656     0.150
     3.188    50.352     0.150
     3.158    51.391     0.150
     3.462    55.594     0.150
     3.508    57.016     0.150
     3.600    58.195     0.150
     3.697    58.805     0.150
     3.727    59.805     0.150
     3.864    61.711     0.150
     3.977    62.164     0.150
     4.069    63.922     0.150
     4.166    65.461     0.150
     4.181    65.836     0.150
     4.176    66.031     0.150
     4.757    73.859     0.150
     4.746    73.461     0.150
     4.725    73.805     0.150
     5.472    84.555     0.150
     5.701    87.336     0.150
     6.021    90.977     0.150
     6.218    94.023     0.150
     7.014   104.305     0.150
     9.917   144.562     0.150
     0.473     9.320     0.150
     0.473    17.172     0.150
     0.640    20.695     0.150
     0.640    11.492     0.150
     0.773    24.836     0.150
     0.889    28.086     0.150
     0.958    30.094     0.150
     1.097    37.102     0.150
     1.097    21.570     0.150
     1.293    39.992     0.150
     1.325    40.414     0.150
     1.382    46.586     0.150
     1.382    26.414     0.150
     1.440    25.953     0.150
     1.440    45.016     0.150
     1.484    45.680     0.150
     1.484    26.289     0.150
     1.611    28.070     0.150
     1.682    31.266     0.150
     1.682    54.375     0.150
     1.770    31.391     0.150
     1.770    54.961     0.150
     1.910    34.031     0.150
     2.004    36.359     0.150
     1.956    36.336     0.150
     2.056    36.500     0.150
     2.136    36.922     0.150
     2.354    39.984     0.150
     2.393    40.195     0.150
     2.412    42.445     0.150
     2.548    44.672     0.150
     2.592    45.273     0.150
     2.710    46.062     0.150
     2.713    47.539     0.150
     2.912    47.266     0.150
     2.960    48.594     0.150
     3.008    50.070     0.150
     3.108    52.133     0.150
     3.126    53.516     0.150
     3.174    52.648     0.150
     3.294    53.398     0.150
     3.270    53.031     0.150
     3.444    54.531     0.150
     3.625    59.094     0.150
     3.706    59.555     0.150
     3.797    59.094     0.150
     3.849    61.055     0.150
     3.966    63.602     0.150
     3.986    62.469     0.150
     4.020    63.766     0.150
     4.093    63.898     0.150
     4.182    64.750     0.150
     4.201    67.883     0.150
     4.285    67.422     0.150
     4.302    67.711     0.150
     4.298    67.609     0.150
     4.395    70.500     0.150
     4.632    73.133     0.150
     4.791    72.703     0.150
     4.830    74.492     0.150
     4.872    75.242     0.150
     4.906    76.016     0.150
     5.123    78.664     0.150
     5.134    80.320     0.150
     5.337    82.750     0.150
     5.352    81.469     0.150
     5.352    80.961     0.150
     5.430    98.883     0.150
     5.497    84.953     0.150
     5.564    83.195     0.150
     5.594    85.680     0.150
     5.768    87.523     0.150
     5.907    89.531     0.150
     5.897    89.891     0.150
     6.074    92.133     0.150
     6.138    92.984     0.150
     6.326    96.000     0.150
     6.520    98.883     0.150
     6.584    99.953     0.150
     6.620   100.125     0.150
     6.749   101.609     0.150
     7.097   104.742     0.150
     7.153   106.336     0.150
     7.234   108.383     0.150
     7.745   114.992     0.150
     7.820   116.023     0.150
     7.909   117.086     0.150
     7.916   116.930     0.150
     8.090   119.320     0.150
     8.094   119.266     0.150
     8.154   120.320     0.150
     8.118   121.844     0.150
     8.183   120.539     0.150
     8.188   121.086     0.150
     8.234   121.562     0.150
     8.284   122.062     0.150
     8.319   122.742     0.150
     8.306   124.875     0.150
     8.307   124.219     0.150
     8.351   122.719     0.150
     8.415   124.023     0.150
     8.486   124.703     0.150
     8.905   130.820     0.150
    10.029   146.031     0.150
    10.360   152.039     0.150
    17.932   251.875     0.150
    18.708   263.125     0.150
    19.411   269.398     0.150
    19.455   268.852     0.150
    19.576   269.375     0.150
    19.649   271.531     0.150
    20.610   280.773     0.150
    21.343   288.734     0.150
    21.425   289.398     0.150
    22.452   301.094     0.150
    36.937   430.734     0.150
    37.623   436.336     0.150
     0.499     9.633     0.150
     0.499    17.164     0.150
     0.805    25.688     0.150
     0.805    14.828     0.150
     1.222    40.953     0.150
     1.222    23.797     0.150
     1.385    25.297     0.150
     1.385    41.844     0.150
     1.644    28.320     0.150
     1.644    51.219     0.150
     1.934    34.492     0.150
     1.934    60.008     0.150
     1.891    34.773     0.150
     1.891    60.781     0.150
     2.058    63.844     0.150
     2.058    36.641     0.150
     2.065    38.312     0.150
     2.139    38.023     0.150
     2.301    39.867     0.150
     2.318    39.992     0.150
     2.486    42.422     0.150
     2.541    42.820     0.150
     2.560    44.133     0.150
     2.753    47.273     0.150
     2.828    46.922     0.150
     3.065    49.984     0.150
     3.028    50.414     0.150
     3.122    50.828     0.150
     3.045    49.531     0.150
     3.149    52.438     0.150
     3.445    54.734     0.150
     3.427    55.484     0.150
     3.380    54.211     0.150
     3.627    59.141     0.150
     3.734    59.273     0.150
     3.782    60.484     0.150
     3.844    60.867     0.150
     3.941    61.109     0.150
     4.014    63.672     0.150
     3.950    62.859     0.150
     4.099    64.820     0.150
     4.056    65.562     0.150
     4.129    65.898     0.150
     4.254    66.938     0.150
     4.340    67.398     0.150
     4.448    69.500     0.150
     4.467    69.820     0.150
     4.462    69.859     0.150
     4.453    70.422     0.150
     4.551    71.508     0.150
     4.733    73.500     0.150
     4.939    75.320     0.150
     4.966    76.961     0.150
     5.032    77.602     0.150
     5.277    80.070     0.150
     5.296    80.828     0.150
     5.266    95.883     0.150
     5.497    84.734     0.150
     5.496    83.250     0.150
     5.496    83.078     0.150
     5.540    83.391     0.150
     5.648    85.414     0.150
     5.678    85.312     0.150
     5.710    85.414     0.150
     5.760    87.797     0.150
     5.763    86.859     0.150
     5.911    88.953     0.150
     6.069    92.094     0.150
     6.050    90.734     0.150
     6.464    97.133     0.150
     6.491    97.938     0.150
     6.543    98.828     0.150
     6.615    98.758     0.150
     6.638   100.953     0.150
     6.655   100.258     0.150
     7.219   106.641     0.150
     7.293   108.609     0.150
     7.342   109.742     0.150
     7.400   110.672     0.150
     7.632   113.469     0.150
     7.748   114.109     0.150
     8.254   122.641     0.150
     8.370   123.383     0.150
     8.461   126.578     0.150
     9.171   134.000     0.150
     9.265   137.438     0.150
     9.374   138.781     0.150
     9.515   138.844     0.150
    10.481   154.523     0.150
    11.245   161.719     0.150
    12.129   176.109     0.150
    12.469   180.180     0.150
    17.768   248.523     0.150
    20.445   278.828     0.150
    22.288   299.242     0.150
    22.544   300.750     0.150
    59.363   604.070     0.150
     0.515    10.020     0.150
     0.515    17.400     0.150
     0.780    14.880     0.150
     0.780    25.600     0.150
     0.825    26.710     0.150
     0.825    15.780     0.150
     0.897    30.410     0.150
     0.897    17.220     0.150
     0.927    18.930     0.150
     0.927    31.870     0.150
     1.101    20.010     0.150
     1.101    34.500     0.150
     1.077    35.060     0.150
     1.077    20.830     0.150
     1.218    42.030     0.150
     1.218    23.820     0.150
     1.243    22.840     0.150
     1.436    44.950     0.150
     1.436    25.860     0.150
     1.467    46.160     0.150
     1.467    26.660     0.150
     1.579    50.120     0.150
     1.626    28.150     0.150
     1.626    51.050     0.150
     1.753    53.490     0.150
     1.753    30.760     0.150
     1.819    59.090     0.150
     1.908    59.900     0.150
     1.908    34.330     0.150
     1.918    34.650     0.150
     1.918    60.220     0.150
     2.037    35.930     0.150
     2.046    37.020     0.150
     2.031    66.190     0.150
     2.031    37.670     0.150
     2.132    38.370     0.150
     2.276    39.600     0.150
     2.326    40.410     0.150
     2.481    42.460     0.150
     2.530    43.680     0.150
     2.528    44.310     0.150
     2.724    47.490     0.150
     2.793    47.380     0.150
     2.798    47.920     0.150
     3.051    50.120     0.150
     3.061    50.900     0.150
     3.103    51.110     0.150
     3.073    50.080     0.150
     3.115    52.380     0.150
     3.264    55.440     0.150
     3.432    54.740     0.150
     3.409    55.460     0.150
     3.412    55.230     0.150
     3.566    56.930     0.150
     3.595    59.430     0.150
     3.718    59.810     0.150
     3.751    60.930     0.150
     3.811    60.950     0.150
     3.932    62.200     0.150
     3.990    64.640     0.150
     3.982    63.250     0.150
     4.065    64.360     0.150
     4.096    65.530     0.150
     4.162    67.080     0.150
     4.236    67.260     0.150
     4.324    67.620     0.150
     4.428    70.090     0.150
     4.420    70.940     0.150
     4.436    70.180     0.150
     4.444    69.490     0.150
     4.521    71.720     0.150
     4.711    73.530     0.150
     4.775    75.120     0.150
     4.928    75.350     0.150
     4.932    77.030     0.150
     5.015    78.110     0.150
     5.263    79.850     0.150
     5.287    96.750     0.150
     5.478    85.800     0.150
     5.463    83.050     0.150
     5.549    85.580     0.150
     5.616    86.960     0.150
     5.735    88.890     0.150
     5.729    89.210     0.150
     5.877    89.580     0.150
     5.964    90.990     0.150
     6.217    94.420     0.150
     6.280    95.060     0.150
     6.296    96.550     0.150
     6.458    98.690     0.150
     6.466    98.340     0.150
     6.555    99.330     0.150
     6.550   100.360     0.150
     6.588    99.420     0.150
     6.723   101.420     0.150
     6.686   100.540     0.150
     7.217   106.600     0.150
     7.285   108.580     0.150
     7.308   109.650     0.150
     7.600   114.170     0.150
     8.034   118.670     0.150
     8.266   122.200     0.150
     8.363   123.560     0.150
     8.430   127.000     0.150
     8.535   127.260     0.150
     9.314   138.930     0.150
     9.322   139.230     0.150
     9.727   144.550     0.150
    10.094   148.840     0.150
    10.171   148.060     0.150
    10.447   153.990     0.150
    15.277   217.240     0.150
    15.960   224.360     0.150
    16.169   229.120     0.150
    17.478   246.910     0.150
    17.796   251.410     0.150
    18.660   259.610     0.150
    21.097   288.790     0.150
    21.201   288.930     0.150
    21.912   295.690     0.150
    21.974   297.390     0.150
    21.966   296.581     0.150
    22.315   300.490     0.150
    23.168   306.870     0.150
    23.180   306.430     0.150
    68.806   665.701     0.150
     0.542    10.499     0.150
     0.542    17.049     0.150
     0.674    12.969     0.150
     0.674    21.879     0.150
     1.168    22.729     0.150
     1.126    22.209     0.150
     1.536    27.129     0.150
     1.800    32.829     0.150
     1.973    35.529     0.150
     1.928    36.609     0.150
     2.073    37.499     0.150
     2.028    36.489     0.150
     2.170    38.419     0.150
     2.424    42.139     0.150
     2.413    43.339     0.150
     2.455    42.579     0.150
     2.394    41.679     0.150
     2.611    46.619     0.150
     2.970    49.529     0.150
     3.008    50.299     0.150
    15.390   219.719     0.150
    15.904   225.149     0.150
    16.094   229.189     0.150
    17.337   247.109     0.150
    17.582   247.409     0.150
    17.907   252.799     0.150
    18.163   255.109     0.150
    18.227   255.539     0.150
    20.212   278.739     0.150
    20.367   279.829     0.150
    20.481   281.599     0.150
    21.228   288.989     0.150
    21.305   289.369     0.150
    21.355   290.359     0.150
    21.467   292.049     0.150
    21.478   292.899     0.150
    22.326   300.259     0.150
    25.030   328.729     0.150
    25.895   337.039     0.150
    26.861   345.379     0.150
    28.816   360.509     0.150
    34.057   408.749     0.150
    34.821   413.319     0.150
    40.142   457.059     0.150
    40.561   461.969     0.150
    40.594   461.719     0.150
    40.789   463.199     0.150
    41.717   471.939     0.150
    41.906   473.039     0.150
    59.332   604.609     0.150
    59.477   606.209     0.150
    60.441   611.129     0.150
    60.441   611.179     0.150
    62.509   625.589     0.150
    64.210   636.629     0.150
    64.850   640.759     0.150
    64.956   640.719     0.150
    67.684   658.909     0.150
    67.747   659.209     0.150
    68.732   665.749     0.150
    69.378   670.379     0.150
    69.378   670.119     0.150
    70.391   677.889     0.150
    73.410   694.329     0.150
    73.767   696.369     0.150
    78.351   722.739     0.150
    79.912   731.349     0.150
     2.394    41.879     0.150
     3.512    58.639     0.150
     5.685    86.129     0.150
     7.169   106.639     0.150
     8.214   121.739     0.150
     8.777   129.999     0.150
    10.302   153.279     0.150
    12.876   185.259     0.150
    17.907   253.449     0.150
    18.674   262.019     0.150
    20.625   282.929     0.150
    21.355   290.009     0.150
    21.305   290.029     0.150
    22.326   300.929     0.150
    22.834   307.279     0.150
    23.740   314.609     0.150
    23.740   315.129     0.150
    23.728   315.999     0.150
    24.932   327.479     0.150
    25.487   332.249     0.150
    27.957   354.259     0.150
    28.395   357.389     0.150
    30.136   373.109     0.150
    30.649   377.549     0.150
    34.057   408.889     0.150
    34.821   412.899     0.150
    34.867   414.639     0.150
    36.600   429.069     0.150
    36.657   431.079     0.150
    36.867   432.009     0.150
    36.831   431.609     0.150
    37.613   436.479     0.150
    38.052   440.679     0.150
    39.357   451.999     0.150
    39.941   457.399     0.150
    40.142   458.009     0.150
    40.789   464.269     0.150
    40.799   465.989     0.150
    41.053   468.249     0.150
    41.906   473.699     0.150
    42.133   475.309     0.150
    42.537   478.819     0.150
    49.925   535.439     0.150
    50.758   541.889     0.150
    51.894   550.879     0.150
    52.691   556.159     0.150
    53.479   562.719     0.150
    53.552   562.889     0.150
    54.197   567.439     0.150
    54.831   572.039     0.150
    56.563   584.599     0.150
    56.645   585.119     0.150
    57.021   587.559     0.150
    57.176   589.039     0.150
    58.049   597.789     0.150
    58.822   600.019     0.150
    58.918   600.899     0.150
    59.218   604.429     0.150
    59.658   606.679     0.150
    59.812   607.529     0.150
    60.834   614.339     0.150
    61.298   617.669     0.150
    63.371   632.099     0.150
    64.210   637.129     0.150
    64.850   640.649     0.150
    64.956   641.529     0.150
    65.234   643.999     0.150
    66.067   648.799     0.150
    66.339   650.889     0.150
    66.760   653.919     0.150
    66.905   654.599     0.150
    67.085   656.239     0.150
    67.119   656.139     0.150
    67.274   657.329     0.150
    67.334   657.739     0.150
    67.543   659.239     0.150
    67.562   659.199     0.150
    67.747   659.109     0.150
    67.759   660.759     0.150
    67.856   660.749     0.150
    67.950   662.149     0.150
    68.050   664.469     0.150
    68.091   662.519     0.150
    68.173   662.829     0.150
    68.253   663.629     0.150
    68.336   663.809     0.150
    68.338   664.069     0.150
    68.354   664.209     0.150
    68.414   664.139     0.150
    68.419   664.399     0.150
    68.428   664.629     0.150
    68.486   665.539     0.150
    68.486   664.969     0.150
    68.530   665.189     0.150
    68.529   665.059     0.150
    68.543   666.529     0.150
    68.543   665.619     0.150
    68.615   666.019     0.150
    68.671   665.839     0.150
    68.808   666.989     0.150
    68.816   666.913     0.150
    68.927   667.889     0.150
    68.959   667.799     0.150
    69.240   669.439     0.150
    69.834   674.219     0.150
    70.127   675.559     0.150
    70.391   677.599     0.150
    70.399   677.059     0.150
    70.400   677.099     0.150
    70.416   677.329     0.150
    70.501   678.279     0.150
    70.612   679.122     0.150
    70.612   678.379     0.150
    70.672   678.589     0.150
    70.706   678.889     0.150
    70.774   678.649     0.150
    71.040   680.569     0.150
    71.043   680.769     0.150
    71.222   681.360     0.150
    71.246   681.839     0.150
    71.353   683.209     0.150
    71.482   683.898     0.150
    71.563   684.807     0.150
    71.718   685.987     0.150
    71.738   687.318     0.150
    72.126   686.619     0.150
    72.153   688.674     0.150
    72.177   687.239     0.150
    72.205   686.413     0.150
    72.218   687.778     0.150
    72.435   688.437     0.150
    72.571   690.349     0.150
    72.795   691.510     0.150
    72.856   692.405     0.150
    73.007   693.002     0.150
    73.049   693.558     0.150
    73.085   693.077     0.150
    73.085   692.379     0.150
    73.246   694.333     0.150
    73.298   693.749     0.150
    73.291   694.161     0.150
    73.317   693.979     0.150
    73.357   694.529     0.150
    73.369   695.838     0.150
    73.410   695.329     0.150
    73.410   695.019     0.150
    73.414   695.109     0.150
    73.487   694.919     0.150
    73.624   696.029     0.150
    73.696   696.369     0.150
    73.717   697.087     0.150
    74.185   700.451     0.150
    74.190   700.099     0.150
    74.601   703.149     0.150
    74.680   702.309     0.150
    74.741   702.589     0.150
    75.174   704.634     0.150
    75.163   705.329     0.150
    75.798   708.929     0.150
    75.814   708.819     0.150
    76.647   713.629     0.150
    77.006   716.439     0.150
    78.324   722.729     0.150
    79.731   732.117     0.150
    80.505   735.559     0.150
    83.970   754.259     0.150
    86.116   763.969     0.150
    87.901   772.479     0.150
    87.963   772.969     0.150
    87.963   772.989     0.150
    91.197   786.739     0.150
    91.543   790.849     0.150
    99.732   827.409     0.150
   101.482   834.319     0.150
     0.513    16.310     0.150
     0.513     9.990     0.150
     0.759    14.310     0.150
     0.759    24.990     0.150
     0.858    16.000     0.150
     0.858    26.960     0.150
     0.944    17.330     0.150
     0.972    19.790     0.150
     1.047    34.670     0.150
     1.047    20.310     0.150
     1.261    24.700     0.150
     1.261    42.300     0.150
     1.434    45.090     0.150
     1.510    27.050     0.150
     1.510    47.350     0.150
     1.545    29.330     0.150
     1.545    51.570     0.150
     1.543    27.870     0.150
     1.543    48.650     0.150
     1.658    30.170     0.150
     1.658    52.690     0.150
     1.694    29.260     0.150
     1.877    34.630     0.150
     1.877    60.550     0.150
     1.922    35.290     0.150
     1.922    61.660     0.150
     1.927    35.550     0.150
     1.837    32.490     0.150
     1.837    57.940     0.150
     1.988    35.520     0.150
     1.988    63.050     0.150
     2.103    66.110     0.150
     2.103    37.570     0.150
     2.180    38.650     0.150
     2.107    37.880     0.150
     2.354    40.770     0.150
     2.277    39.490     0.150
     2.526    42.820     0.150
     2.587    44.270     0.150
     2.611    45.890     0.150
     3.113    50.940     0.150
    16.247   233.780     0.150
    17.715   251.000     0.150
    18.489   262.600     0.150
    20.739   284.570     0.150
    20.865   284.690     0.150
    21.014   287.500     0.150
    21.607   295.470     0.150
    22.138   298.990     0.150
    22.234   301.060     0.150
    22.426   302.830     0.150
    25.298   331.850     0.150
    25.298   331.770     0.150
    36.393   429.640     0.150
    37.964   440.170     0.150
    57.952   593.710     0.150
    69.552   670.530     0.150
     0.513     9.952     0.150
     0.513    17.502     0.150
     0.570    11.022     0.150
     0.570    19.032     0.150
     0.747    13.362     0.150
     0.907    18.532     0.150
     0.960    18.143     0.150
     0.960    32.002     0.150
     1.072    20.763     0.150
     1.229    22.343     0.150
     1.229    38.843     0.150
     1.257    23.042     0.150
     1.228    23.702     0.150
     1.228    41.192     0.150
     1.369    25.442     0.150
     1.427    24.902     0.150
     1.697    31.582     0.150
     1.698    30.442     0.150
     1.866    33.562     0.150
     1.887    35.252     0.150
     1.971    36.053     0.150
     2.066    36.112     0.150
     2.128    66.173     0.150
     2.322    70.183     0.150
     2.347    72.772     0.150
     2.517    82.902     0.150
     2.538    79.372     0.150
     2.501    77.723     0.150
     2.899    85.022     0.150
     2.932    88.792     0.150
     3.054    96.853     0.150
     3.180    91.393     0.150
     3.246    97.752     0.150
     3.251   102.032     0.150
     3.520   102.933     0.150
     3.781   107.652     0.150
    16.202   235.942     0.150
    21.294   288.862     0.150
    21.306   290.553     0.150
    25.097   328.482     0.150
    33.700   402.553     0.150
    36.908   432.553     0.150
    39.527   454.232     0.150
    39.528   455.192     0.150
    49.757   533.872     0.150
    57.826   592.532     0.150
    59.227   603.272     0.150
    59.227   602.832     0.150
    59.389   605.542     0.150
    60.376   610.292     0.150
    62.474   624.593     0.150
    64.160   636.312     0.150
    64.789   639.292     0.150
    67.617   658.162     0.150
    68.732   664.473     0.150
    68.726   664.582     0.150
    69.339   669.643     0.150
    69.339   669.763     0.150
    71.457   682.803     0.150
    73.712   696.173     0.150
    74.684   701.332     0.150
    76.233   710.893     0.150
    78.296   721.513     0.150
    79.907   731.183     0.150
    79.923   729.723     0.150
     0.484     9.433     0.150
     0.484    16.603     0.150
     0.597    11.332     0.150
     0.747    13.422     0.150
     0.919    16.862     0.150
     0.923    17.442     0.150
     0.931    18.652     0.150
     1.071    20.632     0.150
     1.252    22.742     0.150
     1.224    22.893     0.150
     1.283    23.263     0.150
     1.357    26.162     0.150
     1.357    45.683     0.150
     1.397    26.042     0.150
     1.648    30.882     0.150
     1.705    32.282     0.150
     1.727    30.702     0.150
     1.853    32.723     0.150
     1.876    34.002     0.150
     1.924    36.322     0.150
     1.975    35.982     0.150
    25.113   327.603     0.150
    25.486   331.122     0.150
    25.969   337.312     0.150
    30.231   373.502     0.150
    34.114   408.372     0.150
    34.373   409.603     0.150
    34.603   410.942     0.150
    34.908   414.112     0.150
    35.535   419.522     0.150
    36.702   429.303     0.150
    36.932   431.632     0.150
    37.606   437.542     0.150
    37.948   439.962     0.150
    38.671   446.422     0.150
    38.917   447.922     0.150
    39.440   452.172     0.150
    39.490   452.272     0.150
    39.496   453.922     0.150
    39.497   454.202     0.150
    40.035   458.103     0.150
    41.358   467.652     0.150
    41.815   472.553     0.150
    43.524   485.553     0.150
    45.108   499.002     0.150
    49.790   533.992     0.150
    57.859   592.522     0.150
    59.492   604.792     0.150
    60.413   610.452     0.150
    60.413   610.422     0.150
    62.511   625.263     0.150
    64.197   636.942     0.150
    64.826   639.162     0.150
    67.654   657.992     0.150
    67.718   658.372     0.150
    68.765   664.912     0.150
    68.759   664.792     0.150
    69.376   669.822     0.150
    69.376   669.792     0.150
    70.446   676.842     0.150
    71.489   682.912     0.150
    72.792   692.532     0.150
    73.749   695.952     0.150
    73.822   696.732     0.150
    74.752   702.742     0.150
    76.270   711.092     0.150
    77.335   717.902     0.150
    78.333   722.912     0.150
    78.773   726.082     0.150
    79.941   730.442     0.150
     0.532    10.398     0.150
     0.532    17.788     0.150
     0.777    14.848     0.150
     0.777    24.688     0.150
     0.858    16.108     0.150
     0.858    27.688     0.150
     0.955    32.868     0.150
     0.955    17.088     0.150
     1.031    20.658     0.150
     1.031    34.988     0.150
     1.274    42.358     0.150
     1.274    24.309     0.150
     1.311    22.948     0.150
     1.512    47.809     0.150
     1.512    26.788     0.150
     1.544    48.428     0.150
     1.544    27.248     0.150
     1.557    29.388     0.150
     1.557    51.288     0.150
     1.657    52.008     0.150
     1.657    29.708     0.150
     1.699    29.538     0.150
     1.826    31.638     0.150
     1.885    34.348     0.150
     1.839    33.428     0.150
     1.839    58.278     0.150
     1.932    61.408     0.150
     1.987    35.968     0.150
     2.092    37.698     0.150
     2.112    37.388     0.150
     2.114    37.608     0.150
     2.191    38.548     0.150
     2.266    39.488     0.150
     2.354    41.088     0.150
     2.538    42.458     0.150
     2.596    43.559     0.150
     2.603    44.769     0.150
     2.766    47.378     0.150
     2.802    48.068     0.150
     2.862    49.028     0.150
     2.988    49.568     0.150
     2.995    48.388     0.150
     3.120    50.328     0.150
     3.177    51.148     0.150
     3.188    52.098     0.150
     3.331    53.118     0.150
     7.269   106.858     0.150
     8.106   119.718     0.150
     8.601   127.338     0.150
    10.241   149.098     0.150
    10.465   152.378     0.150
    10.511   154.878     0.150
    15.355   221.708     0.150
    16.748   238.648     0.150
    17.717   249.348     0.150
    21.124   286.208     0.150
    21.427   291.088     0.150
    22.428   302.028     0.150
    27.651   353.519     0.150
     0.478     9.406     0.150
     0.478    16.387     0.150
     0.566    18.616     0.150
     0.566    10.887     0.150
     0.718    22.807     0.150
     0.718    13.387     0.150
     0.886    16.547     0.150
     0.886    28.036     0.150
     0.938    17.566     0.150
     0.938    30.337     0.150
     0.943    18.616     0.150
     0.943    32.316     0.150
     1.039    32.507     0.150
     1.039    18.767     0.150
     1.043    20.066     0.150
     1.043    35.547     0.150
     1.160    35.616     0.150
     1.220    38.906     0.150
     1.251    39.557     0.150
     1.254    23.406     0.150
     1.254    39.887     0.150
     1.328    45.156     0.150
     1.696    30.337     0.150
     1.844    33.446     0.150
     1.945    35.477     0.150
     1.912    35.587     0.150
     2.062    35.937     0.150
     2.129    66.316     0.150
     2.129    38.307     0.150
     2.296    39.616     0.150
     2.326    40.427     0.150
     2.347    41.837     0.150
     2.520    45.026     0.150
     2.523    79.207     0.150
     2.523    46.326     0.150
     2.660    45.616     0.150
     2.843    46.597     0.150
     2.887    48.217     0.150
     2.947    49.196     0.150
    22.216   298.486     0.150
    22.432   302.576     0.150
    22.497   301.486     0.150
    22.575   303.257     0.150
    22.618   304.477     0.150
    22.900   305.937     0.150
    22.927   307.677     0.150
    23.288   310.727     0.150
    23.654   313.267     0.150
    23.839   317.557     0.150
    24.186   315.896     0.150
    24.192   317.106     0.150
    25.132   327.156     0.150
    25.985   334.687     0.150
    26.975   346.276     0.150
    27.003   344.847     0.150
    28.865   359.767     0.150
    31.011   379.797     0.150
    33.121   398.137     0.150
    33.286   398.257     0.150
    33.480   401.986     0.150
    34.141   408.517     0.150
    34.636   410.757     0.150
    34.763   411.286     0.150
    36.355   425.526     0.150
    36.720   429.427     0.150
    36.944   431.387     0.150
    39.762   455.146     0.150
    40.126   459.576     0.150
    40.910   463.606     0.150
    41.185   465.687     0.150
    41.603   469.896     0.150
    42.176   474.767     0.150
    42.204   474.757     0.150
    42.275   474.196     0.150
    42.476   476.437     0.150
    43.378   483.786     0.150
    43.556   484.847     0.150
    44.758   494.917     0.150
    46.234   508.637     0.150
    46.641   510.127     0.150
    48.432   524.477     0.150
    49.651   532.286     0.150
    49.789   533.207     0.150
    51.788   548.196     0.150
    51.954   549.967     0.150
    57.063   588.656     0.150
    57.859   592.286     0.150
    59.136   602.606     0.150
    59.220   602.797     0.150
    59.220   603.347     0.150
    60.331   610.486     0.150
    60.393   610.007     0.150
    60.393   610.007     0.150
    62.500   624.547     0.150
    62.909   627.156     0.150
    63.588   630.847     0.150
    64.182   635.257     0.150
    64.808   639.606     0.150
    67.634   657.347     0.150
    67.697   657.957     0.150
    68.477   663.347     0.150
    68.598   664.656     0.150
    68.764   664.517     0.150
    68.759   664.727     0.150
    72.210   687.356     0.150
    73.261   692.557     0.150
    73.369   693.017     0.150
    75.826   707.196     0.150
    76.044   708.967     0.150
    76.252   710.557     0.150
    77.167   715.097     0.150
    77.328   715.937     0.150
    78.316   721.776     0.150
    79.757   729.826     0.150
     0.573    19.355     0.150
     0.573    11.195     0.150
     0.580    19.075     0.150
     0.580    11.235     0.150
     0.799    14.335     0.150
     0.845    29.306     0.150
     0.845    16.925     0.150
     0.924    28.915     0.150
     0.924    17.095     0.150
     1.003    18.735     0.150
     1.003    33.695     0.150
     1.098    19.295     0.150
     1.122    21.516     0.150
     1.122    39.226     0.150
     1.247    22.655     0.150
     1.269    23.115     0.150
     1.375    25.715     0.150
     1.406    47.245     0.150
     1.453    25.665     0.150
     1.581    28.115     0.150
     1.674    54.315     0.150
     2.073    36.715     0.150
     2.127    38.595     0.150
     2.314    40.385     0.150
     2.368    40.735     0.150
     2.383    41.125     0.150
     2.465    42.255     0.150
     2.893    48.315     0.150
     2.920    48.795     0.150
     2.905    48.405     0.150
     3.546    56.985     0.150
     3.794    60.056     0.150
     0.576    10.131     0.150
     0.522    17.301     0.150
     0.522    10.689     0.150
     1.084    20.609     0.150
     1.188    21.270     0.150
     1.436    25.020     0.150
     1.876    31.730     0.150
     1.982    33.199     0.150
     2.334    37.900     0.150
     2.358    37.881     0.150
     2.907    46.301     0.150
     3.257    50.990     0.150
     3.226    50.930     0.150
     3.251    51.520     0.150
     3.427    53.420     0.150
     3.277    50.779     0.150
     3.529    54.709     0.150
     3.766    58.350     0.150
     3.612    55.760     0.150
     3.788    59.090     0.150
     3.889    60.619     0.150
     4.136    62.811     0.150
     4.243    65.551     0.150
     4.318    67.221     0.150
     4.823    73.020     0.150
     4.845    73.881     0.150
     5.063    76.359     0.150
     5.276    78.391     0.150
     5.421    80.410     0.150
     5.531    81.820     0.150
     5.558    83.709     0.150
     5.854    87.010     0.150
     5.770    84.900     0.150
     6.262    93.439     0.150
     6.383    94.459     0.150
     6.444    95.869     0.150
     7.081   103.881     0.150
     7.124   104.859     0.150
     7.170   105.301     0.150
     7.406   108.199     0.150
     7.515   109.529     0.150
     7.846   114.391     0.150
     8.062   117.279     0.150
     9.209   134.939     0.150
    10.284   151.119     0.150
    11.102   159.029     0.150
    12.336   176.721     0.150
    18.253   254.000     0.150
    19.042   263.400     0.150
    19.483   267.529     0.150
    19.722   271.580     0.150
    21.387   287.881     0.150
    21.564   290.561     0.150
    23.085   307.779     0.150
    24.675   322.160     0.150
    25.077   326.150     0.150
    25.584   329.971     0.150
    25.937   335.449     0.150
    26.112   334.721     0.150
    26.694   340.150     0.150
    28.913   359.641     0.150
    29.356   364.230     0.150
    34.144   406.471     0.150
    43.154   481.520     0.150
     0.493     9.734     0.150
     0.493    15.625     0.150
     0.637    21.135     0.150
     0.637    12.195     0.150
     0.785    25.475     0.150
     0.905    17.205     0.150
     1.109    22.186     0.150
     1.109    36.926     0.150
     1.324    41.346     0.150
     1.394    26.715     0.150
     1.394    46.545     0.150
     1.437    26.385     0.150
     1.437    45.676     0.150
     1.487    27.176     0.150
     1.689    54.885     0.150
     1.689    31.766     0.150
     1.745    31.945     0.150
     1.762    58.145     0.150
     1.762    33.016     0.150
     1.766    32.266     0.150
     1.766    55.166     0.150
     1.917    60.605     0.150
     1.917    34.586     0.150
     2.014    36.775     0.150
     1.940    36.756     0.150
     2.059    37.404     0.150
     2.133    37.375     0.150
     2.365    40.916     0.150
     2.400    41.756     0.150
     2.401    42.465     0.150
     2.450    42.635     0.150
     2.918    47.795     0.150
     2.962    49.416     0.150
     2.996    50.295     0.150
     3.213    51.496     0.150
     3.301    53.234     0.150
     3.275    54.314     0.150
     3.580    57.064     0.150
     3.547    56.426     0.150
     3.542    58.705     0.150
     3.694    60.016     0.150
     3.806    59.965     0.150
     3.953    63.734     0.150
     4.096    65.426     0.150
     4.286    68.324     0.150
     4.301    68.145     0.150
     4.294    68.125     0.150
     4.569    71.984     0.150
     4.798    73.574     0.150
     4.875    76.496     0.150
     4.887    77.654     0.150
     5.487    86.176     0.150
     5.572    83.926     0.150
     5.592    87.516     0.150
     5.909    90.695     0.150
     6.615   100.275     0.150
     6.934   104.965     0.150
     7.236   111.246     0.150
     9.200   137.215     0.150
    15.442   219.234     0.150
    16.054   228.256     0.150
    34.561   411.125     0.150
    36.917   431.965     0.150
    37.907   439.916     0.150
    41.777   471.695     0.150
    43.182   483.135     0.150
    57.860   593.016     0.150
    60.439   610.215     0.150
    62.526   624.635     0.150
    64.851   640.455     0.150
    68.761   665.006     0.150
    68.766   665.256     0.150
    69.392   669.375     0.150
    69.392   668.605     0.150
    70.437   677.516     0.150
    70.462   677.086     0.150
    71.488   682.965     0.150
    73.771   696.365     0.150
     0.517    10.023     0.150
     0.517    17.033     0.150
     0.751    14.344     0.150
     0.751    23.975     0.150
     0.872    16.383     0.150
     0.872    27.914     0.150
     0.954    31.674     0.150
     0.977    19.793     0.150
     0.977    33.555     0.150
     1.040    34.004     0.150
     1.185    21.104     0.150
     1.271    24.854     0.150
     1.271    42.693     0.150
     1.314    24.184     0.150
     1.314    43.164     0.150
     1.446    25.584     0.150
     1.523    47.113     0.150
     1.554    50.443     0.150
     1.557    47.994     0.150
     1.672    51.934     0.150
     1.706    30.164     0.150
     1.824    57.094     0.150
     1.824    33.184     0.150
     1.888    60.043     0.150
     1.932    35.225     0.150
     1.932    61.254     0.150
     1.937    34.793     0.150
     2.001    35.994     0.150
     2.001    61.863     0.150
     2.114    65.404     0.150
     2.114    37.504     0.150
     2.127    64.943     0.150
     2.127    37.645     0.150
     2.190    38.434     0.150
     2.267    39.174     0.150
     2.368    40.584     0.150
     2.536    42.654     0.150
     2.599    44.174     0.150
     2.624    45.074     0.150
     2.820    48.234     0.150
     2.882    47.584     0.150
     2.965    49.744     0.150
     2.978    48.334     0.150
     3.124    50.943     0.150
     3.186    51.484     0.150
     3.210    53.344     0.150
     3.313    53.133     0.150
     3.503    55.443     0.150
     3.488    56.123     0.150
     3.662    59.334     0.150
     3.796    59.555     0.150
     3.847    61.264     0.150
     3.905    62.773     0.150
     3.885    61.604     0.150
     3.995    62.424     0.150
     4.158    65.934     0.150
     4.191    65.574     0.150
     4.317    67.594     0.150
     4.402    68.494     0.150
     4.512    70.533     0.150
     4.516    71.533     0.150
     4.530    70.463     0.150
     4.532    70.543     0.150
     4.618    72.293     0.150
     4.799    74.754     0.150
     4.861    75.744     0.150
     4.990    77.773     0.150
     5.742    86.273     0.150
     5.973    90.244     0.150
     6.547    96.514     0.150
     6.590    98.314     0.150
    15.237   216.873     0.150
    16.221   231.264     0.150
    22.412   302.523     0.150
    25.284   330.443     0.150
    36.930   431.203     0.150
    57.958   593.244     0.150
    69.562   669.975     0.150
    69.562   669.713     0.150
     0.466     9.131     0.150
     0.466    15.699     0.150
     0.613    10.801     0.150
     0.613    19.240     0.150
     1.071    20.420     0.150
     1.071    35.990     0.150
     1.455    25.439     0.150
     1.743    30.840     0.150
     1.882    33.539     0.150
     1.978    35.449     0.150
     2.109    35.930     0.150
     2.328    39.449     0.150
     2.365    40.459     0.150
     2.392    41.221     0.150
     2.567    45.080     0.150
     2.697    44.949     0.150
     2.884    47.170     0.150
     2.932    48.020     0.150
     2.990    49.330     0.150
     3.266    52.209     0.150
     3.195    52.900     0.150
     3.242    52.689     0.150
     3.233    51.529     0.150
     3.548    56.230     0.150
     3.603    58.160     0.150
     3.566    56.160     0.150
     3.689    58.949     0.150
     3.770    58.910     0.150
     3.949    62.641     0.150
     4.065    63.750     0.150
     4.154    65.051     0.150
     4.127    63.480     0.150
     4.257    66.561     0.150
     4.274    66.980     0.150
     4.272    66.910     0.150
     4.365    69.270     0.150
     4.541    70.539     0.150
     4.604    71.010     0.150
     4.763    72.289     0.150
     4.844    74.420     0.150
     4.812    74.391     0.150
     4.906    75.850     0.150
     5.095    77.959     0.150
     5.079    77.529     0.150
    16.017   228.539     0.150
    16.484   235.381     0.150
    21.239   290.270     0.150
    36.947   430.408     0.150
    39.478   453.471     0.150
    39.479   453.350     0.150
    40.866   463.041     0.150
    57.879   591.939     0.150
    60.435   609.729     0.150
    60.435   609.729     0.150
    64.848   639.369     0.150
    67.676   657.920     0.150
    68.785   664.529     0.150
    68.779   664.400     0.150
    69.398   669.189     0.150
    69.398   669.189     0.150
    70.487   675.939     0.150
    71.508   681.240     0.150
    73.771   695.510     0.150
     0.490     9.562     0.150
     0.490    15.949     0.150
     0.598    11.172     0.150
     0.598    19.582     0.150
     1.077    20.883     0.150
     1.197    21.383     0.150
     1.448    25.582     0.150
     1.727    30.922     0.150
     1.881    33.859     0.150
     1.981    35.492     0.150
     2.094    36.262     0.150
     2.332    40.152     0.150
     2.363    40.891     0.150
     2.369    41.172     0.150
     2.670    45.180     0.150
     2.880    47.539     0.150
     2.923    48.512     0.150
     2.966    49.371     0.150
     3.263    52.230     0.150
     3.236    53.152     0.150
     3.218    53.332     0.150
     3.541    56.531     0.150
     3.582    58.570     0.150
     3.585    56.789     0.150
     3.664    58.609     0.150
     3.769    59.250     0.150
     3.924    62.652     0.150
     4.057    64.391     0.150
     4.147    64.980     0.150
     4.148    65.172     0.150
     4.247    66.520     0.150
     4.262    67.383     0.150
     4.256    66.930     0.150
     4.261    68.270     0.150
     4.244    66.910     0.150
     4.346    69.352     0.150
     4.529    70.449     0.150
     4.594    72.223     0.150
     4.761    72.582     0.150
     4.787    73.660     0.150
     4.836    75.461     0.150
     4.880    75.910     0.150
    15.480   220.312     0.150
    19.693   273.172     0.150
    20.429   281.902     0.150
    21.123   287.680     0.150
    21.261   290.121     0.150
    21.710   293.641     0.150
    25.558   332.582     0.150
    25.983   336.652     0.150
    36.925   431.633     0.150
    37.943   439.781     0.150
    38.914   448.801     0.150
    39.497   453.781     0.150
    40.685   462.660     0.150
    41.810   472.270     0.150
    57.853   592.223     0.150
    60.410   609.949     0.150
    60.410   609.949     0.150
    67.651   657.711     0.150
    67.715   658.109     0.150
    68.759   664.539     0.150
    69.371   669.141     0.150
    69.371   669.012     0.150
    70.439   677.000     0.150
    71.483   682.582     0.150
    73.745   695.281     0.150
    77.330   716.531     0.150
    79.935   730.789     0.150
     0.483    16.742     0.150
     0.609    11.543     0.150
     0.609    19.609     0.150
     0.756    26.172     0.150
     0.930    30.180     0.150
     0.930    18.320     0.150
     0.930    18.352     0.150
     0.930    32.520     0.150
     1.080    21.191     0.150
     1.080    36.980     0.150
     1.204    37.531     0.150
     1.204    22.871     0.150
     1.366    26.570     0.150
     1.366    45.449     0.150
     1.409    25.590     0.150
     1.409    44.473     0.150
     1.456    26.723     0.150
     1.456    46.750     0.150
     1.584    47.922     0.150
     1.584    27.820     0.150
     1.659    54.090     0.150
     1.715    55.383     0.150
     1.733    55.980     0.150
     1.733    32.922     0.150
     1.738    31.500     0.150
     1.738    53.582     0.150
     1.865    57.852     0.150
     1.887    33.660     0.150
     1.931    35.582     0.150
     1.931    62.070     0.150
     1.985    60.262     0.150
     1.985    35.621     0.150
     2.105    36.199     0.150
     2.105    63.551     0.150
     2.087    37.441     0.150
     2.087    64.531     0.150
     2.336    40.180     0.150
     2.336    68.902     0.150
     2.370    40.770     0.150
     2.370    71.992     0.150
     2.381    41.352     0.150
     2.517    76.312     0.150
     2.517    43.902     0.150
     2.481    41.891     0.150
     2.481    73.570     0.150
     2.560    45.691     0.150
     2.580    78.551     0.150
     2.717    81.492     0.150
     2.682    46.383     0.150
     2.887    47.602     0.150
     2.887    84.312     0.150
     2.932    48.750     0.150
     2.932    85.531     0.150
     2.978    49.602     0.150
     3.594    59.230     0.150
     3.676    59.891     0.150
     3.775    59.430     0.150
     4.364    70.770     0.150
     4.603    73.410     0.150
     4.767    73.262     0.150
     4.800    75.160     0.150
     5.097    78.492     0.150
     5.068    78.680     0.150
     5.542    83.512     0.150
     5.564    85.531     0.150
     5.606    86.902     0.150
     5.865    89.750     0.150
    17.384   244.582     0.150
    18.696   260.172     0.150
    20.973   285.242     0.150
    21.043   286.461     0.150
    21.408   290.242     0.150
    21.676   292.949     0.150
    22.484   302.461     0.150
    22.674   304.051     0.150
    25.108   328.461     0.150
    27.778   350.359     0.150
    32.508   393.082     0.150
    33.733   402.930     0.150
    34.591   411.062     0.150
    36.698   428.730     0.150
    36.930   431.492     0.150
    37.937   439.500     0.150
     0.569    11.066     0.150
     0.569    19.156     0.150
     0.684    22.797     0.150
     0.868    28.496     0.150
     0.868    15.637     0.150
     0.938    29.824     0.150
     1.023    18.836     0.150
     1.023    31.984     0.150
     0.846    29.586     0.150
     0.846    16.598     0.150
     1.193    40.375     0.150
     1.193    23.965     0.150
     1.187    37.098     0.150
     1.187    20.938     0.150
     1.305    39.867     0.150
     1.305    23.848     0.150
     1.349    42.734     0.150
     1.373    43.516     0.150
     1.478    49.016     0.150
     1.478    28.176     0.150
     1.480    27.438     0.150
     1.551    27.906     0.150
     1.551    48.688     0.150
     1.680    50.777     0.150
     1.764    55.984     0.150
     1.823    57.855     0.150
     1.844    34.586     0.150
     1.844    60.418     0.150
     1.806    56.695     0.150
     1.806    32.668     0.150
     1.993    62.266     0.150
     1.993    35.586     0.150
     1.943    60.195     0.150
     1.913    62.008     0.150
     1.913    34.855     0.150
     2.095    37.887     0.150
     2.095    65.426     0.150
     2.023    36.195     0.150
     2.023    62.297     0.150
     2.177    67.117     0.150
     2.177    38.496     0.150
     2.447    41.918     0.150
     2.409    42.766     0.150
     2.613    46.484     0.150
     2.674    45.645     0.150
     2.988    49.246     0.150
     3.021    50.215     0.150
     2.995    49.805     0.150
     3.159    53.746     0.150
     3.181    52.324     0.150
     3.183    51.117     0.150
     3.490    56.918     0.150
     3.635    59.617     0.150
     3.976    64.668     0.150
     4.389    70.266     0.150
     4.400    70.285     0.150
     4.689    74.246     0.150
     4.774    74.938     0.150
     4.938    76.668     0.150
     4.900    76.215     0.150
     5.197    79.598     0.150
     5.095    78.836     0.150
     5.156    80.977     0.150
     5.343    81.324     0.150
     5.647    84.875     0.150
     5.637    87.734     0.150
     5.608    86.266     0.150
     5.757    88.324     0.150
     5.990    91.727     0.150
     6.049    92.457     0.150
     6.063    92.348     0.150
     6.126    93.305     0.150
     6.138    93.047     0.150
     6.208    93.047     0.150
     6.323    97.105     0.150
     6.366    96.258     0.150
     6.444    96.867     0.150
     6.355    95.734     0.150
     6.488    97.277     0.150
     6.483    97.668     0.150
     6.688   102.105     0.150
     7.253   110.355     0.150
     7.481   112.137     0.150
     7.612   112.906     0.150
     7.908   117.367     0.150
     7.962   117.617     0.150
     8.180   120.895     0.150
     8.100   118.867     0.150
    15.372   219.355     0.150
    15.634   221.957     0.150
    16.135   230.816     0.150
    16.444   235.438     0.150
    17.807   253.035     0.150
    17.846   252.918     0.150
    17.903   252.785     0.150
    18.094   252.785     0.150
    18.227   255.984     0.150
    18.524   260.527     0.150
    18.581   260.297     0.150
    18.857   262.734     0.150
    18.939   265.367     0.150
    18.989   264.336     0.150
    19.227   266.215     0.150
    19.393   270.176     0.150
    19.634   272.734     0.150
    19.715   272.336     0.150
    20.362   280.938     0.150
    20.573   281.457     0.150
    20.932   287.047     0.150
    20.993   286.426     0.150
    20.974   286.875     0.150
    21.059   288.465     0.150
    21.296   289.816     0.150
    21.345   290.445     0.150
    21.361   290.688     0.150
    21.327   288.875     0.150
    21.479   291.785     0.150
    21.601   293.055     0.150
    21.635   294.477     0.150
    21.608   293.977     0.150
    21.648   293.246     0.150
    22.147   298.496     0.150
    22.320   301.066     0.150
    22.407   302.277     0.150
    22.615   303.906     0.150
    22.745   304.145     0.150
    22.792   306.574     0.150
    22.972   305.918     0.150
    23.013   309.477     0.150
    23.144   309.598     0.150
    23.105   308.176     0.150
    23.439   313.457     0.150
    23.950   317.836     0.150
    23.977   319.418     0.150
    24.151   320.188     0.150
    25.482   332.457     0.150
    25.938   336.176     0.150
    25.983   335.824     0.150
    26.058   335.887     0.150
    26.852   345.055     0.150
    27.822   352.617     0.150
    27.960   353.695     0.150
    31.502   385.285     0.150
    33.820   403.145     0.150
    34.058   409.305     0.150
    34.498   410.008     0.150
    34.758   413.297     0.150
    34.843   412.574     0.150
    36.052   424.035     0.150
    36.559   428.246     0.150
    36.925   432.137     0.150
    37.600   437.188     0.150
    37.792   440.457     0.150
    37.833   439.945     0.150
    37.831   439.746     0.150
    38.049   440.688     0.150
    38.096   442.066     0.150
    38.326   444.266     0.150
    38.580   446.316     0.150
    38.924   449.676     0.150
    39.306   452.484     0.150
    39.429   453.137     0.150
    40.674   462.996     0.150
    40.776   464.496     0.150
    40.807   466.016     0.150
    40.930   465.457     0.150
    41.043   466.715     0.150
    41.245   468.566     0.150
    41.530   471.418     0.150
    41.547   471.496     0.150
    41.591   470.836     0.150
    41.635   470.887     0.150
    41.942   474.324     0.150
    41.972   474.527     0.150
    42.599   480.176     0.150
    42.921   481.715     0.150
    43.042   481.367     0.150
    43.039   482.207     0.150
    43.407   486.258     0.150
    43.529   487.484     0.150
    44.182   492.496     0.150
    44.722   496.758     0.150
    45.002   497.516     0.150
    45.371   499.887     0.150
    45.449   501.035     0.150
    46.023   505.734     0.150
    49.735   533.637     0.150
    52.072   552.195     0.150
    53.989   567.246     0.150
    55.233   574.688     0.150
    57.802   592.137     0.150
    59.216   603.215     0.150
    60.431   610.285     0.150
    60.431   610.285     0.150
    64.839   640.207     0.150
    66.418   650.926     0.150
    67.734   660.215     0.150
    68.709   664.406     0.150
    69.363   669.406     0.150
    69.362   668.957     0.150
    70.365   676.668     0.150
    70.390   676.727     0.150
    70.837   679.477     0.150
    71.129   680.227     0.150
    71.427   682.316     0.150
     0.508    17.316     0.150
     0.508     9.914     0.150
     0.866    16.156     0.150
     0.866    27.625     0.150
     0.983    19.406     0.150
     0.983    34.184     0.150
     0.945    31.496     0.150
     1.049    20.215     0.150
     1.049    34.387     0.150
     1.178    21.004     0.150
     1.178    36.953     0.150
     1.262    42.637     0.150
     1.262    24.656     0.150
     1.306    43.355     0.150
     1.551    47.926     0.150
     1.545    50.445     0.150
     1.545    28.934     0.150
     1.667    51.375     0.150
     1.667    29.766     0.150
     1.699    50.977     0.150
     1.699    29.555     0.150
     1.880    34.227     0.150
     1.880    58.945     0.150
     1.829    57.086     0.150
     1.829    32.293     0.150
     1.924    35.105     0.150
     1.924    60.863     0.150
     1.928    35.074     0.150
     1.928    60.875     0.150
     1.997    35.676     0.150
     1.997    61.844     0.150
     2.119    37.676     0.150
     2.119    68.137     0.150
     2.121    64.664     0.150
     2.106    65.043     0.150
     2.181    38.637     0.150
     2.181    66.863     0.150
     2.276    39.004     0.150
     2.276    71.215     0.150
     2.362    71.637     0.150
     2.362    40.805     0.150
     2.527    42.965     0.150
     2.527    75.246     0.150
     2.622    45.316     0.150
     2.590    76.805     0.150
     2.590    44.203     0.150
     2.816    49.137     0.150
     2.837    48.555     0.150
     2.883    48.184     0.150
     2.982    49.254     0.150
     2.967    48.875     0.150
     3.117    51.035     0.150
     3.209    53.453     0.150
     3.180    52.004     0.150
     3.317    53.316     0.150
     3.495    55.285     0.150
     3.667    58.996     0.150
     3.607    57.594     0.150
     3.845    61.996     0.150
     3.905    62.516     0.150
     3.987    62.496     0.150
     3.995    64.613     0.150
     4.525    70.855     0.150
     4.855    75.934     0.150
     4.995    77.934     0.150
     5.088    78.066     0.150
     5.207    80.195     0.150
     5.454    83.516     0.150
     5.821    89.785     0.150
     6.113    93.703     0.150
     6.947   104.934     0.150
     7.254   107.387     0.150
     7.394   110.824     0.150
     8.524   126.605     0.150
     9.229   135.113     0.150
     9.343   136.414     0.150
    10.239   148.535     0.150
    10.345   152.004     0.150
    10.537   155.566     0.150
    10.453   152.254     0.150
    11.023   161.094     0.150
    11.284   163.824     0.150
    12.890   185.926     0.150
    15.530   222.695     0.150
    16.002   226.516     0.150
    16.237   233.066     0.150
    17.130   244.285     0.150
    17.706   250.004     0.150
    18.750   261.977     0.150
    19.513   270.273     0.150
    20.169   278.137     0.150
    20.273   279.016     0.150
    20.383   279.676     0.150
    20.419   281.203     0.150
    20.730   284.266     0.150
    20.856   285.523     0.150
    21.019   287.086     0.150
    21.150   287.734     0.150
    21.270   290.016     0.150
    21.421   291.477     0.150
    21.418   290.926     0.150
    21.443   291.066     0.150
    21.793   294.844     0.150
    21.879   295.785     0.150
    21.902   295.516     0.150
    22.003   297.637     0.150
    22.226   299.453     0.150
    22.416   301.863     0.150
    22.482   303.184     0.150
    22.599   303.613     0.150
    22.630   304.785     0.150
    23.241   310.453     0.150
    23.535   314.016     0.150
    23.956   317.504     0.150
    25.289   330.543     0.150
    25.289   330.324     0.150
    27.748   351.977     0.150
    27.862   353.605     0.150
    28.124   355.543     0.150
    28.225   356.105     0.150
    37.256   434.395     0.150
    37.728   437.605     0.150
    37.960   439.844     0.150
    39.271   451.016     0.150
    39.228   452.105     0.150
    41.312   467.793     0.150
    41.624   471.477     0.150
    42.973   481.816     0.150
    45.234   499.656     0.150
    45.878   504.953     0.150
    49.899   534.816     0.150
    60.645   612.926     0.150
    62.691   626.586     0.150
     0.513     9.887     0.150
     0.615    11.758     0.150
     0.615    20.137     0.150
     0.783    26.988     0.150
     0.900    30.789     0.150
     0.900    18.258     0.150
     0.945    17.488     0.150
     0.945    30.656     0.150
     0.934    31.367     0.150
     0.934    18.000     0.150
     1.107    21.340     0.150
     1.107    37.387     0.150
     1.222    38.277     0.150
     1.303    23.578     0.150
     1.392    26.738     0.150
     1.415    44.906     0.150
     1.472    46.527     0.150
     1.472    25.828     0.150
     1.737    56.797     0.150
     1.743    54.797     0.150
     1.743    31.977     0.150
     1.874    58.656     0.150
     1.874    33.938     0.150
     1.908    34.520     0.150
     1.912    35.117     0.150
     2.009    36.520     0.150
     2.111    65.750     0.150
     2.111    36.957     0.150
     2.083    36.707     0.150
     2.083    66.547     0.150
     2.360    40.906     0.150
     2.374    42.977     0.150
     2.390    41.418     0.150
     2.459    41.898     0.150
     2.560    46.328     0.150
     2.666    46.039     0.150
     2.726    82.879     0.150
     2.905    48.059     0.150
     2.945    49.379     0.150
     2.968    49.750     0.150
     3.226    92.840     0.150
     3.213    53.297     0.150
     3.290    53.199     0.150
     3.237    52.297     0.150
     3.261    53.770     0.150
     3.516    56.727     0.150
     3.565    57.180     0.150
     3.591    59.348     0.150
     3.572    57.418     0.150
     3.665    60.047     0.150
     3.797    60.020     0.150
     3.924    62.430     0.150
     3.946    63.867     0.150
     4.080    65.066     0.150
     4.172    65.797     0.150
     4.140    66.148     0.150
     4.269    68.137     0.150
     4.266    68.699     0.150
     4.282    67.969     0.150
     4.240    68.449     0.150
     4.358    69.988     0.150
     4.549    71.879     0.150
     4.862    76.566     0.150
     5.313    80.598     0.150
     5.448    83.738     0.150
    15.454   220.078     0.150
    20.985   286.508     0.150
    21.035   286.898     0.150
    21.389   290.250     0.150
    21.405   290.500     0.150
    21.699   293.738     0.150
    25.077   328.957     0.150
    36.900   431.777     0.150
    37.916   439.270     0.150
    39.563   454.500     0.150
    41.362   469.039     0.150
    43.212   483.949     0.150
    43.534   486.316     0.150
    44.268   492.098     0.150
    49.767   534.367     0.150
    57.835   592.949     0.150
    60.410   611.148     0.150
    64.822   640.707     0.150
    67.652   659.199     0.150
    68.742   665.316     0.150
    70.416   677.328     0.150
     0.557    19.789     0.150
     0.622    20.270     0.150
     0.855    17.828     0.150
     1.142    21.949     0.150
     1.142    39.309     0.150
     1.311    41.688     0.150
     1.427    47.930     0.150
     1.427    27.527     0.150
     1.419    26.727     0.150
     1.490    45.578     0.150
     1.490    25.637     0.150
     1.618    28.848     0.150
     1.746    31.039     0.150
     1.746    56.078     0.150
     1.881    33.809     0.150
     1.881    58.918     0.150
     1.934    34.898     0.150
     1.934    61.508     0.150
     1.881    35.547     0.150
     2.041    36.910     0.150
     2.116    37.207     0.150
     2.083    36.520     0.150
     2.393    41.570     0.150
     2.415    41.668     0.150
     2.358    42.430     0.150
     2.928    49.059     0.150
     2.959    48.410     0.150
     2.948    49.047     0.150
     3.229    53.520     0.150
     3.281    53.668     0.150
     3.583    57.977     0.150
     3.901    62.957     0.150
     4.127    66.898     0.150
     4.163    65.840     0.150
     4.271    68.188     0.150
     4.559    71.418     0.150
     4.767    74.578     0.150
    20.990   287.527     0.150
    22.040   300.809     0.150
    23.063   308.668     0.150
    24.687   323.270     0.150
    26.108   335.750     0.150
    26.914   344.848     0.150
    29.331   365.398     0.150
    29.575   367.848     0.150
    30.042   371.379     0.150
    34.113   408.328     0.150
    42.062   474.688     0.150
    59.162   603.789     0.150
     0.512    10.141     0.150
     0.512    17.074     0.150
     0.763    14.582     0.150
     0.763    24.754     0.150
     0.834    15.762     0.150
     0.885    29.781     0.150
     0.885    16.082     0.150
     0.924    32.031     0.150
     0.924    18.633     0.150
     1.085    33.703     0.150
     1.085    19.621     0.150
     1.088    34.941     0.150
     1.206    23.633     0.150
     1.355    41.312     0.150
     1.610    27.891     0.150
     1.738    30.051     0.150
     1.805    33.301     0.150
     1.892    59.422     0.150
     1.892    33.301     0.150
     2.032    35.422     0.150
     2.021    35.082     0.150
     2.120    36.371     0.150
     2.260    38.621     0.150
     2.468    41.102     0.150
     2.516    41.980     0.150
     2.513    42.121     0.150
     2.785    47.902     0.150
    15.947   225.363     0.150
    57.893   592.203     0.150
    59.316   602.062     0.150
    59.575   605.422     0.150
    60.538   610.262     0.150
    60.538   610.152     0.150
    64.304   635.781     0.150
    67.782   658.383     0.150
    67.845   659.461     0.150
    68.795   664.941     0.150
    68.801   665.613     0.150
    68.893   665.914     0.150
    69.085   667.434     0.150
    69.468   669.344     0.150
    69.468   669.113     0.150
    73.862   695.254     0.150
     0.519    17.383     0.150
     0.519    10.203     0.150
     0.775    25.223     0.150
     0.775    14.781     0.150
     0.831    27.582     0.150
     0.831    15.863     0.150
     0.896    16.320     0.150
     0.922    31.922     0.150
     0.922    18.832     0.150
     1.097    35.082     0.150
     1.097    19.980     0.150
     1.077    35.672     0.150
     1.077    20.801     0.150
     1.218    23.820     0.150
     1.218    42.801     0.150
     1.367    42.582     0.150
     1.622    28.133     0.150
     1.903    33.621     0.150
     1.923    33.750     0.150
     1.923    60.742     0.150
     2.032    62.711     0.150
     2.044    35.723     0.150
     2.024    36.680     0.150
     2.024    66.852     0.150
     2.131    37.312     0.150
     2.131    68.633     0.150
     2.271    39.500     0.150
     2.328    39.832     0.150
     2.480    73.762     0.150
     2.480    41.941     0.150
     2.527    42.621     0.150
     2.527    76.133     0.150
     2.521    42.750     0.150
     2.521    80.141     0.150
     2.718    46.422     0.150
     2.740    86.262     0.150
     2.740    46.312     0.150
     2.791    47.250     0.150
     2.884    88.621     0.150
     3.099    90.992     0.150
     3.067    92.773     0.150
     3.079    96.320     0.150
    15.311   218.500     0.150
    15.539   219.891     0.150
    15.959   225.211     0.150
    16.441   233.762     0.150
    16.833   238.262     0.150
    17.482   246.223     0.150
    18.842   262.172     0.150
    19.323   268.703     0.150
    20.136   275.621     0.150
    20.476   280.602     0.150
    21.120   287.340     0.150
    21.245   288.043     0.150
    33.359   400.691     0.150
    33.949   406.102     0.150
    34.426   409.641     0.150
    34.928   413.523     0.150
    40.250   457.000     0.150
    42.961   481.430     0.150
    43.051   482.203     0.150
    44.931   497.273     0.150
    59.326   603.625     0.150
    59.585   604.789     0.150
    60.545   611.570     0.150
    60.545   611.352     0.150
    62.601   625.703     0.150
    64.309   637.273     0.150
    64.701   640.164     0.150
    64.953   640.930     0.150
    68.795   665.500     0.150
    68.801   665.852     0.150
    69.472   670.094     0.150
    69.473   669.523     0.150
    70.670   678.391     0.150
    73.868   696.094     0.150
    78.452   722.758     0.150
     2.328    40.082     0.150
     3.588    58.703     0.150
     7.217   106.953     0.150
     8.269   122.160     0.150
     8.698   128.203     0.150
    10.203   152.141     0.150
    10.199   150.852     0.150
    12.072   173.250     0.150
    12.879   184.383     0.150
    14.034   202.820     0.150
    15.918   229.152     0.150
    17.801   251.340     0.150
    18.572   263.312     0.150
    20.263   278.930     0.150
    20.518   281.492     0.150
    21.206   288.320     0.150
    21.384   289.613     0.150
    22.223   299.113     0.150
    22.727   305.352     0.150
    23.847   315.562     0.150
    23.847   316.152     0.150
    24.824   326.562     0.150
    25.033   328.891     0.150
    30.059   372.461     0.150
    30.833   382.453     0.150
    30.833   381.203     0.150
    30.983   378.750     0.150
    33.278   401.750     0.150
    33.498   400.750     0.150
    33.949   407.070     0.150
    38.103   440.312     0.150
    40.250   459.852     0.150
    49.267   533.555     0.150
    50.826   544.844     0.150
    52.760   558.219     0.150
    54.265   569.031     0.150
    55.098   578.469     0.150
    57.725   594.852     0.150
    58.960   602.352     0.150
    59.326   606.453     0.150
    60.087   609.852     0.150
    61.941   623.453     0.150
    62.601   627.148     0.150
    63.793   634.250     0.150
    64.309   639.148     0.150
    64.701   640.609     0.150
    64.701   641.148     0.150
    67.789   658.750     0.150
    68.147   663.750     0.150
    68.195   664.133     0.150
    68.307   665.164     0.150
    68.542   666.508     0.150
    68.594   666.961     0.150
    68.801   666.164     0.150
    68.863   669.812     0.150
    68.891   667.758     0.150
    69.011   669.773     0.150
    70.458   679.945     0.150
    70.551   678.570     0.150
    70.670   680.609     0.150
    71.409   684.609     0.150
    72.182   689.000     0.150
    73.374   695.141     0.150
    73.514   696.055     0.150
    73.514   695.281     0.150
    75.901   709.211     0.150
    77.299   719.352     0.150
    78.425   725.281     0.150
    84.078   754.625     0.150
    88.391   774.648     0.150
     0.467     9.148     0.150
     0.467    15.320     0.150
     0.624    19.914     0.150
     0.624    11.883     0.150
     0.895    16.852     0.150
     0.895    27.984     0.150
     0.945    18.531     0.150
     1.080    21.453     0.150
     1.080    36.297     0.150
     1.212    37.664     0.150
     1.276    22.648     0.150
     1.276    40.773     0.150
     1.308    23.289     0.150
     1.308    41.992     0.150
     1.365    26.312     0.150
     1.365    46.289     0.150
     1.424    25.852     0.150
     1.466    25.820     0.150
     1.594    50.422     0.150
     1.594    27.922     0.150
     1.664    54.547     0.150
     1.664    30.391     0.150
     1.719    31.633     0.150
     1.879    32.914     0.150
     1.893    33.469     0.150
     1.987    36.047     0.150
     2.120    37.617     0.150
     2.337    40.633     0.150
     2.375    41.398     0.150
     2.401    41.070     0.150
     2.577    44.617     0.150
     2.894    47.602     0.150
     2.998    49.883     0.150
     3.186    51.672     0.150
     3.612    58.102     0.150
     3.697    59.008     0.150
     3.957    62.367     0.150
     4.212    65.180     0.150
     4.908    75.953     0.150
     7.081   104.703     0.150
    18.197   253.789     0.150
    18.992   263.750     0.150
    19.552   269.594     0.150
    19.592   269.867     0.150
    19.663   270.930     0.150
    20.348   279.891     0.150
    20.533   279.562     0.150
    21.013   285.117     0.150
    21.082   285.812     0.150
    22.372   299.828     0.150
    23.710   313.062     0.150
    26.298   336.469     0.150
    26.918   342.672     0.150
    28.880   359.219     0.150
    29.326   365.812     0.150
    30.957   378.570     0.150
    33.422   399.992     0.150
    34.084   406.117     0.150
    34.815   411.352     0.150
    36.709   429.039     0.150
    36.944   430.742     0.150
    37.677   436.500     0.150
    39.784   454.023     0.150
    40.115   456.594     0.150
    40.670   461.500     0.150
    40.855   463.039     0.150
    41.373   467.281     0.150
    41.546   469.633     0.150
    41.804   470.812     0.150
    42.226   473.898     0.150
    42.208   473.734     0.150
    42.359   475.852     0.150
    42.448   476.508     0.150
    42.731   478.453     0.150
    43.335   483.844     0.150
    43.526   484.594     0.150
    44.291   491.414     0.150
    54.049   565.680     0.150
    59.192   602.367     0.150
    59.506   604.578     0.150
    62.538   624.781     0.150
    64.226   635.891     0.150
    64.856   639.672     0.150
    67.685   658.328     0.150
    67.747   658.109     0.150
    68.787   664.812     0.150
    72.155   686.812     0.150
    73.417   693.500     0.150
    73.846   696.234     0.150
    75.856   707.664     0.150
    75.987   709.250     0.150
    76.113   709.430     0.150
    77.060   715.008     0.150
    77.212   714.961     0.150
    79.781   729.250     0.150
    87.690   770.023     0.150
   120.718  1133.398     0.150
   140.330  1170.258     0.150
   146.550  1180.812     0.150
   148.730  1183.453     0.150
   149.112  1189.688     0.150
   149.527  1188.141     0.150
   159.890  1237.961     0.150
     1.080    20.625     0.150
     1.080    37.148     0.150
     2.476    41.766     0.150
     2.476    42.000     0.150
     3.223    51.578     0.150
     3.561    57.773     0.150
     3.561    57.969     0.150
     5.711    86.070     0.150
     6.514    98.484     0.150
     7.081   104.844     0.150
     8.279   121.195     0.150
     8.279   121.297     0.150
     8.852   130.867     0.150
     9.133   135.398     0.150
    10.348   153.023     0.150
    12.260   175.078     0.150
    12.386   178.398     0.150
    12.735   184.398     0.150
    12.963   185.562     0.150
    14.236   211.750     0.150
    15.768   224.039     0.150
    16.099   232.992     0.150
    16.157   228.922     0.150
    17.470   244.695     0.150
    17.948   253.820     0.150
    18.724   260.688     0.150
    20.412   280.773     0.150
    20.657   282.844     0.150
    21.360   290.062     0.150
    21.360   289.633     0.150
    22.372   301.289     0.150
    22.372   300.648     0.150
    22.870   306.562     0.150
    23.710   313.727     0.150
    23.710   313.578     0.150
    24.882   327.609     0.150
    24.961   327.211     0.150
    25.117   327.672     0.150
    25.532   331.922     0.150
    25.978   335.219     0.150
    26.359   338.570     0.150
    26.529   339.961     0.150
    26.529   339.039     0.150
    26.918   344.367     0.150
    26.918   343.891     0.150
    27.977   354.102     0.150
    28.476   357.281     0.150
    28.530   358.930     0.150
    28.880   360.617     0.150
    29.326   365.023     0.150
    30.213   372.898     0.150
    30.638   378.039     0.150
    30.714   376.984     0.150
    30.957   380.234     0.150
    30.959   380.773     0.150
    31.000   381.008     0.150
    31.917   388.203     0.150
    33.179   398.359     0.150
    33.422   402.125     0.150
    33.422   402.844     0.150
    33.422   402.602     0.150
    33.644   403.562     0.150
    34.084   408.328     0.150
    34.084   408.664     0.150
    34.303   408.609     0.150
    34.815   412.039     0.150
    34.928   414.289     0.150
    34.920   413.664     0.150
    36.709   430.000     0.150
    36.709   430.320     0.150
    36.694   430.453     0.150
    36.882   431.188     0.150
    36.944   432.289     0.150
    37.601   437.227     0.150
    37.601   437.102     0.150
    37.677   436.867     0.150
    38.120   440.844     0.150
    39.415   451.852     0.150
    39.784   456.641     0.150
    39.784   456.422     0.150
    40.016   456.672     0.150
    40.115   456.938     0.150
    40.115   456.344     0.150
    40.830   465.766     0.150
    40.830   465.867     0.150
    40.855   464.164     0.150
    41.298   467.672     0.150
    41.658   469.812     0.150
    41.988   473.867     0.150
    42.217   476.961     0.150
    42.442   478.820     0.150
    44.980   497.039     0.150
    45.162   499.242     0.150
    45.611   503.195     0.150
    45.778   505.664     0.150
    48.269   522.438     0.150
    49.129   530.242     0.150
    49.982   535.867     0.150
    50.813   542.133     0.150
    51.948   551.070     0.150
    53.530   562.992     0.150
    54.049   566.891     0.150
    54.049   567.000     0.150
    54.251   566.648     0.150
    54.886   571.297     0.150
    56.042   582.844     0.150
    56.618   585.773     0.150
    57.231   590.211     0.150
    57.958   594.984     0.150
    58.194   596.547     0.150
    58.715   600.414     0.150
    58.877   599.320     0.150
    59.192   603.438     0.150
    59.506   606.727     0.150
    59.506   606.070     0.150
    59.574   606.188     0.150
    59.738   606.891     0.150
    59.868   607.172     0.150
    59.953   610.922     0.150
    59.924   609.617     0.150
    60.164   609.984     0.150
    60.388   611.117     0.150
    60.443   610.375     0.150
    60.889   613.258     0.150
    61.747   621.047     0.150
    62.059   622.672     0.150
    62.059   622.484     0.150
    62.538   624.930     0.150
    63.608   634.312     0.150
    64.226   636.094     0.150
    64.856   639.961     0.150
    65.015   640.938     0.150
    65.089   644.508     0.150
    65.305   645.258     0.150
    65.466   645.047     0.150
    65.698   648.141     0.150
    65.861   649.234     0.150
    66.130   651.312     0.150
    66.140   650.781     0.150
    66.309   651.461     0.150
    66.389   653.172     0.150
    66.828   653.578     0.150
    66.971   654.133     0.150
    67.152   656.117     0.150
    67.339   657.234     0.150
    67.555   658.242     0.150
    67.608   658.750     0.150
    67.628   658.391     0.150
    67.684   658.414     0.150
    67.685   661.188     0.150
    67.685   661.281     0.150
    67.824   659.828     0.150
    67.922   661.078     0.150
    68.015   661.242     0.150
    68.156   662.078     0.150
    68.237   662.648     0.150
    68.318   663.031     0.150
    68.372   664.328     0.150
    68.372   664.508     0.150
    68.398   663.352     0.150
    68.405   663.578     0.150
    68.419   664.148     0.150
    68.487   664.461     0.150
    68.492   664.148     0.150
    68.508   666.141     0.150
    68.521   665.891     0.150
    68.550   665.109     0.150
    68.550   664.281     0.150
    68.570   663.484     0.150
    68.594   664.930     0.150
    68.610   665.391     0.150
    68.680   665.719     0.150
    68.737   665.438     0.150
    68.787   664.945     0.150
    68.787   665.102     0.150
    68.872   667.102     0.150
    68.881   666.828     0.150
    68.907   667.117     0.150
    68.919   669.531     0.150
    68.969   666.383     0.150
    68.991   667.773     0.150
    69.025   667.531     0.150
    69.059   668.828     0.150
    69.094   669.539     0.150
    69.171   670.352     0.150
    69.301   668.758     0.150
    69.435   669.820     0.150
    69.804   670.680     0.150
    69.906   675.078     0.150
    69.945   673.930     0.150
    69.964   673.531     0.150
    70.126   676.242     0.150
    70.388   676.344     0.150
    70.412   679.938     0.150
    70.461   677.438     0.150
    70.461   675.539     0.150
    70.462   677.461     0.150
    70.466   678.094     0.150
    70.487   677.719     0.150
    70.612   679.141     0.150
    70.674   678.844     0.150
    70.674   677.828     0.150
    70.738   677.922     0.150
    70.767   679.141     0.150
    70.767   678.117     0.150
    70.832   677.891     0.150
    70.935   681.062     0.150
    71.026   681.844     0.150
    71.105   681.070     0.150
    71.112   680.859     0.150
    71.166   678.961     0.150
    71.222   681.062     0.150
    71.277   680.539     0.150
    71.270   683.258     0.150
    71.317   685.141     0.150
    71.317   682.047     0.150
    71.314   681.383     0.150
    71.418   682.641     0.150
    71.434   683.438     0.150
    71.540   683.539     0.150
    71.622   682.945     0.150
    71.622   684.234     0.150
    71.630   686.844     0.150
    71.962   686.500     0.150
    71.999   685.305     0.150
    72.140   686.414     0.150
    72.190   690.141     0.150
    72.190   686.086     0.150
    72.190   685.750     0.150
    72.212   688.234     0.150
    72.155   687.062     0.150
    72.155   687.297     0.150
    72.215   688.258     0.150
    72.242   686.773     0.150
    72.265   687.781     0.150
    72.278   690.844     0.150
    72.492   687.836     0.150
    72.506   689.062     0.150
    72.759   689.438     0.150
    72.886   691.422     0.150
    72.921   692.367     0.150
    73.026   694.469     0.150
    73.069   691.930     0.150
    73.147   692.352     0.150
    73.307   694.242     0.150
    73.348   694.211     0.150
    73.380   693.359     0.150
    73.417   694.125     0.150
    73.414   694.594     0.150
    73.415   695.164     0.150
    73.427   695.656     0.150
    73.547   694.148     0.150
    73.684   696.570     0.150
    73.684   696.070     0.150
    73.713   696.414     0.150
    73.713   696.188     0.150
    73.778   696.445     0.150
    74.133   700.438     0.150
    74.203   699.867     0.150
    74.203   699.969     0.150
    74.244   698.984     0.150
    74.854   703.430     0.150
    75.856   709.227     0.150
    75.856   707.867     0.150
    75.856   708.211     0.150
    75.990   711.258     0.150
    75.990   710.562     0.150
    75.987   711.391     0.150
    76.313   709.797     0.150
    77.212   715.914     0.150
    77.574   719.148     0.150
    77.982   720.711     0.150
    78.335   722.523     0.150
    79.380   728.914     0.150
    79.679   729.273     0.150
    79.774   731.961     0.150
    79.781   731.672     0.150
    79.781   730.883     0.150
    80.566   735.422     0.150
    83.446   751.648     0.150
    83.953   753.109     0.150
    87.865   771.430     0.150
    87.926   771.781     0.150
    87.926   771.344     0.150
    87.926   771.367     0.150
    88.415   775.984     0.150
    91.259   786.617     0.150
    91.259   786.352     0.150
    93.831   801.781     0.150
    34.586   409.164     0.150
     0.439    14.781     0.150
     0.439     8.609     0.150
     0.614    19.203     0.150
     0.614    11.227     0.150
     1.052    20.758     0.150
     1.052    35.953     0.150
     1.241    23.109     0.150
     1.447    25.070     0.150
     1.447    46.742     0.150
     1.745    31.398     0.150
     1.869    59.039     0.150
     1.869    33.648     0.150
     1.960    35.156     0.150
     1.960    62.320     0.150
     1.967    36.773     0.150
     2.109    36.648     0.150
     2.109    63.703     0.150
     2.082    65.070     0.150
     2.404    41.656     0.150
     2.501    77.992     0.150
     3.703    68.000     0.150
     4.209    78.539     0.150
     4.371    69.320     0.150
     4.750    72.133     0.150
     4.931    77.406     0.150
     5.084    77.141     0.150
     5.091    79.039     0.150
     5.115    79.398     0.150
     5.319    82.602     0.150
     5.346    82.312     0.150
     5.523    82.812     0.150
     5.520    84.398     0.150
     5.566    86.398     0.150
     5.636    86.406     0.150
     7.052   104.312     0.150
    10.241   148.547     0.150
    11.077   160.148     0.150
    12.679   182.406     0.150
    14.561   208.031     0.150
    15.371   216.812     0.150
    15.790   222.227     0.150
    15.999   226.641     0.150
    16.478   235.477     0.150
    16.726   236.062     0.150
    16.936   238.602     0.150
    16.981   240.500     0.150
    17.442   244.492     0.150
    17.956   251.773     0.150
    18.736   264.094     0.150
    19.562   269.961     0.150
    19.667   270.938     0.150
    21.239   290.344     0.150
    25.149   327.312     0.150
    26.009   337.078     0.150
    26.632   341.203     0.150
    28.906   362.438     0.150
    33.535   402.469     0.150
    34.087   407.422     0.150
    36.974   430.961     0.150
    40.156   460.211     0.150
    41.362   468.406     0.150
    41.366   471.281     0.150
    41.563   469.344     0.150
    43.164   483.508     0.150
    59.190   602.930     0.150
    62.554   624.570     0.150
    64.238   635.094     0.150
    64.865   639.477     0.150
    67.754   657.570     0.150
    68.811   664.172     0.150
    69.121   666.742     0.150
    70.700   677.641     0.150
    71.535   681.961     0.150
    73.426   693.742     0.150
    75.877   709.109     0.150
    77.223   714.523     0.150
    80.937   736.594     0.150
    87.859   771.188     0.150
     0.462     9.530     0.150
     0.462    14.860     0.150
     0.842    15.380     0.150
     0.842    27.830     0.150
     0.902    15.930     0.150
     1.218    23.300     0.150
     1.267    21.970     0.150
     1.501    28.090     0.150
     1.487    25.670     0.150
     1.523    26.210     0.150
     1.642    28.610     0.150
     1.665    28.190     0.150
     1.840    33.210     0.150
     1.882    34.030     0.150
     1.973    34.550     0.150
     2.066    35.860     0.150
     2.093    36.830     0.150
     2.137    36.760     0.150
     2.337    39.710     0.150
     2.320    40.390     0.150
     2.483    41.330     0.150
     2.550    42.690     0.150
     2.614    44.070     0.150
     2.798    46.980     0.150
     2.817    50.150     0.150
     2.889    48.210     0.150
     2.893    51.730     0.150
     2.973    47.330     0.150
     3.003    48.150     0.150
     3.078    50.150     0.150
     3.146    50.920     0.150
     3.205    52.320     0.150
     3.336    52.220     0.150
     3.455    54.620     0.150
     3.444    55.530     0.150
     3.562    56.280     0.150
     3.753    59.010     0.150
     3.689    58.260     0.150
     3.831    60.410     0.150
     3.945    61.380     0.150
     3.902    61.740     0.150
     4.185    66.000     0.150
     4.275    66.330     0.150
     4.358    67.480     0.150
     4.473    69.270     0.150
     4.497    69.720     0.150
     4.502    69.620     0.150
     4.506    70.670     0.150
     4.596    71.170     0.150
     4.762    73.660     0.150
     4.823    74.390     0.150
     4.947    74.470     0.150
     5.021    77.300     0.150
    18.575   258.320     0.150
    18.775   260.930     0.150
    19.334   266.660     0.150
    19.377   266.880     0.150
    19.378   266.780     0.150
    19.430   267.940     0.150
    19.443   267.640     0.150
    20.686   280.360     0.150
    21.507   290.390     0.150
    21.623   291.590     0.150
    22.730   304.630     0.150
    24.411   318.850     0.150
    25.090   326.440     0.150
    25.981   334.630     0.150
    26.707   341.090     0.150
    26.729   340.880     0.150
    27.784   351.220     0.150
    28.964   360.470     0.150
    30.742   376.770     0.150
    33.202   398.390     0.150
    33.865   404.250     0.150
    35.024   413.420     0.150
    36.697   428.250     0.150
    37.475   434.770     0.150
    39.745   453.710     0.150
    39.893   454.550     0.150
    40.247   457.910     0.150
    40.334   457.880     0.150
    40.577   461.110     0.150
    40.656   461.380     0.150
    41.090   465.040     0.150
    41.327   467.470     0.150
    41.899   471.920     0.150
    42.038   472.580     0.150
    42.054   473.220     0.150
    42.253   473.670     0.150
    42.390   475.090     0.150
    42.473   475.890     0.150
    43.308   483.260     0.150
    43.782   486.830     0.150
    44.590   494.600     0.150
    46.894   511.930     0.150
    49.791   533.360     0.150
    51.942   549.640     0.150
    53.835   563.870     0.150
    55.356   574.460     0.150
    57.911   592.750     0.150
    59.411   603.700     0.150
    59.547   604.030     0.150
    60.600   611.210     0.150
    62.705   625.100     0.150
    63.710   632.430     0.150
    64.412   636.610     0.150
    65.053   640.420     0.150
    66.530   651.390     0.150
    67.753   658.660     0.150
    67.951   659.860     0.150
    68.544   663.370     0.150
    68.898   665.350     0.150
    69.576   670.190     0.150
    69.576   669.850     0.150
    71.953   685.110     0.150
    73.614   694.460     0.150
    73.860   696.000     0.150
    75.898   708.210     0.150
    75.997   707.900     0.150
    77.401   715.610     0.150
    78.554   722.630     0.150
    79.754   728.950     0.150
    79.898   729.690     0.150
    87.492   768.960     0.150
   117.378  1125.680     0.150
   120.843  1133.521     0.150
   129.297  1147.950     0.150
   144.316  1176.840     0.150
   149.129  1189.990     0.150
   149.569  1188.640     0.150
   159.676  1197.550     0.150
     3.003    47.440     0.150
     3.689    58.670     0.150
     3.689    58.440     0.150
     4.001    62.340     0.150
     4.823    75.340     0.150
     5.290    80.340     0.150
     5.552    84.540     0.150
     5.543    85.540     0.150
     5.715    85.240     0.150
     6.002    89.434     0.150
     6.527    99.040     0.150
     6.699   101.340     0.150
     6.699   100.354     0.150
     6.935   103.940     0.150
     6.932   104.340     0.150
     7.209   107.240     0.150
     7.209   106.417     0.150
     7.209   106.940     0.150
     7.209   107.050     0.150
     7.880   116.140     0.150
     8.204   121.240     0.150
     8.361   120.931     0.150
     8.361   121.750     0.150
     8.670   127.640     0.150
     8.670   127.090     0.150
     9.326   137.143     0.150
    10.131   149.390     0.150
    12.144   172.435     0.150
    12.605   180.698     0.150
    12.931   186.270     0.150
    12.936   183.650     0.150
    13.956   201.200     0.150
    15.878   225.497     0.150
    15.985   226.940     0.150
    15.903   227.789     0.150
    15.903   227.330     0.150
    15.954   225.480     0.150
    16.096   227.845     0.150
    16.157   228.382     0.150
    17.728   249.830     0.150
    18.235   254.995     0.150
    18.508   259.570     0.150
    20.193   278.310     0.150
    20.437   280.000     0.150
    21.147   287.830     0.150
    21.147   287.450     0.150
    21.460   290.010     0.150
    21.668   296.081     0.150
    22.154   298.001     0.150
    22.154   297.830     0.150
    22.649   303.650     0.150
    23.562   313.730     0.150
    23.930   315.989     0.150
    24.427   321.275     0.150
    24.663   323.560     0.150
    24.741   324.500     0.150
    25.090   326.940     0.150
    25.313   329.370     0.150
    26.139   336.680     0.150
    26.348   337.640     0.150
    26.348   338.380     0.150
    26.321   338.784     0.150
    26.707   342.210     0.150
    26.707   342.110     0.150
    27.760   351.630     0.150
    28.312   355.200     0.150
    28.313   356.834     0.150
    28.964   360.279     0.150
    29.316   364.420     0.150
    29.445   367.280     0.150
    30.418   374.620     0.150
    30.514   375.043     0.150
    30.514   374.930     0.150
    30.742   378.440     0.150
    30.744   378.137     0.150
    30.742   378.060     0.150
    30.780   378.400     0.150
    31.058   379.140     0.150
    31.206   382.400     0.150
    31.860   387.520     0.150
    33.202   400.167     0.150
    33.202   399.840     0.150
    33.397   400.090     0.150
    33.488   402.240     0.150
    33.545   401.340     0.150
    33.865   406.442     0.150
    33.865   406.120     0.150
    34.094   406.820     0.150
    34.397   409.690     0.150
    34.831   413.090     0.150
    35.024   414.140     0.150
    35.023   414.570     0.150
    35.266   418.580     0.150
    36.474   427.870     0.150
    36.697   430.040     0.150
    36.697   429.467     0.150
    36.697   429.300     0.150
    36.667   429.250     0.150
    36.977   431.940     0.150
    37.500   436.401     0.150
    37.475   435.216     0.150
    37.941   440.880     0.150
    38.192   440.760     0.150
    38.378   443.680     0.150
    39.206   449.860     0.150
    39.745   454.570     0.150
    39.893   456.540     0.150
    39.893   456.750     0.150
    39.833   455.860     0.150
    39.898   457.010     0.150
    40.334   458.540     0.150
    40.610   463.497     0.150
    40.656   462.019     0.150
    40.656   462.130     0.150
    40.739   463.210     0.150
    41.087   465.920     0.150
    41.028   465.840     0.150
    41.058   468.260     0.150
    41.296   466.970     0.150
    41.659   469.480     0.150
    41.826   472.270     0.150
    41.969   470.770     0.150
    42.038   475.941     0.150
    42.038   475.150     0.150
    42.038   475.540     0.150
    42.253   475.100     0.150
    42.320   476.770     0.150
    42.356   476.600     0.150
    42.417   476.870     0.150
    42.390   478.810     0.150
    43.435   485.270     0.150
    43.782   488.060     0.150
    44.966   497.800     0.150
    45.189   498.090     0.150
    45.189   497.940     0.150
    45.509   501.998     0.150
    45.509   501.780     0.150
    45.558   503.760     0.150
    46.064   506.170     0.150
    46.894   513.407     0.150
    46.894   514.140     0.150
    46.894   513.270     0.150
    46.823   512.490     0.150
    47.023   512.540     0.150
    48.487   524.040     0.150
    49.349   532.140     0.150
    49.791   533.867     0.150
    50.088   535.710     0.150
    50.923   542.210     0.150
    51.917   549.880     0.150
    51.942   550.040     0.150
    52.062   550.860     0.150
    52.858   556.420     0.150
    53.649   563.030     0.150
    53.722   563.200     0.150
    53.835   565.511     0.150
    53.835   565.240     0.150
    53.975   565.940     0.150
    54.363   567.490     0.150
    54.647   569.130     0.150
    54.995   572.260     0.150
    55.086   577.010     0.150
    55.356   575.913     0.150
    55.356   575.740     0.150
    55.622   579.648     0.150
    56.146   580.290     0.150
    56.480   583.090     0.150
    56.521   582.720     0.150
    56.729   584.820     0.150
    56.816   585.150     0.150
    56.815   585.065     0.150
    57.138   588.250     0.150
    57.153   587.527     0.150
    57.185   587.700     0.150
    57.334   590.453     0.150
    57.334   590.040     0.150
    57.334   590.840     0.150
    57.341   589.240     0.150
    57.817   594.440     0.150
    57.911   593.520     0.150
    58.018   593.277     0.150
    58.018   593.777     0.150
    58.018     3.800     0.150
    58.059   593.700     0.150
    57.913   595.210     0.150
    58.201   597.140     0.150
    58.239   595.920     0.150
    58.355   596.140     0.150
    58.563   599.240     0.150
    58.746   599.680     0.150
    58.989   600.080     0.150
    59.054   601.640     0.150
    59.084   601.040     0.150
    59.081   601.200     0.150
    59.411   604.940     0.150
    59.411   605.349     0.150
    59.411   605.240     0.150
    59.489   605.436     0.150
    59.542   604.815     0.150
    59.542   605.265     0.150
    59.542     2.900     0.150
    59.542     3.400     0.150
    59.547   605.234     0.150
    59.547   605.340     0.150
    59.611   605.580     0.150
    59.709   607.257     0.150
    59.761   606.290     0.150
    59.917   607.240     0.150
    59.917   607.510     0.150
    59.977   607.580     0.150
    59.984   607.930     0.150
    60.028   608.850     0.150
    60.187   608.540     0.150
    60.200   609.490     0.150
    60.240   609.850     0.150
    60.275   610.190     0.150
    60.354   611.750     0.150
    60.520   611.400     0.150
    60.600   613.197     0.150
    60.600   613.080     0.150
    60.600   612.940     0.150
    60.644   611.861     0.150
    60.644   612.040     0.150
    60.569   615.640     0.150
    60.687   612.590     0.150
    60.860   614.009     0.150
    60.902   614.840     0.150
    60.999   614.240     0.150
    60.999   614.590     0.150
    61.132   615.920     0.150
    61.155   615.740     0.150
    61.380   617.610     0.150
    61.456   617.510     0.150
    61.652   619.640     0.150
    61.784   620.530     0.150
    61.830   620.650     0.150
    61.843   621.419     0.150
    61.843   621.000     0.150
    62.044   622.340     0.150
    62.153   623.240     0.150
    62.656   626.420     0.150
    62.705   627.154     0.150
    62.705   626.240     0.150
    62.805   627.000     0.150
    63.064   628.780     0.150
    63.170   629.410     0.150
    63.220   630.300     0.150
    63.509   632.300     0.150
    63.710   633.320     0.150
    63.890   634.840     0.150
    64.223   635.440     0.150
    64.393   638.380     0.150
    64.412   638.032     0.150
    64.479   637.580     0.150
    64.627   639.710     0.150
    64.775   640.910     0.150
    64.775   640.660     0.150
    64.807   640.890     0.150
    65.016   640.840     0.150
    65.053   641.576     0.150
    65.053   641.300     0.150
    65.114   641.340     0.150
    65.114   641.630     0.150
    65.175   642.750     0.150
    65.207   642.610     0.150
    65.307   643.760     0.150
    65.365   644.060     0.150
    65.407   644.370     0.150
    65.461   644.640     0.150
    65.534   645.750     0.150
    65.750   647.200     0.150
    65.755   646.760     0.150
    65.838   647.210     0.150
    65.917   647.830     0.150
    65.979   648.160     0.150
    66.033   648.540     0.150
    66.188   649.770     0.150
    66.193   649.540     0.150
    66.379   650.780     0.150
    66.456   651.110     0.150
    66.480   651.030     0.150
    66.750   652.990     0.150
    66.846   654.410     0.150
    66.898   654.240     0.150
    67.013   654.620     0.150
    67.047   654.720     0.150
    67.227   656.270     0.150
    67.259   656.390     0.150
    67.420   657.360     0.150
    67.477   657.840     0.150
    67.373   657.570     0.150
    67.635   658.910     0.150
    67.689   659.300     0.150
    67.701   659.260     0.150
    67.708   659.260     0.150
    67.753   659.760     0.150
    67.753   659.660     0.150
    67.812   660.090     0.150
    67.887   659.240     0.150
    67.905   660.780     0.150
    67.911   660.500     0.150
    67.951   659.760     0.150
    67.999   661.140     0.150
    68.097   662.100     0.150
    68.115   661.830     0.150
    68.113   662.421     0.150
    68.113   660.950     0.150
    68.188   662.410     0.150
    68.238   662.800     0.150
    68.235   662.710     0.150
    68.281   662.920     0.150
    68.321   663.357     0.150
    68.320   662.730     0.150
    68.364   663.570     0.150
    68.389   663.440     0.150
    68.392   663.600     0.150
    68.398   663.710     0.150
    68.428   663.886     0.150
    68.428   663.780     0.150
    68.476   663.860     0.150
    68.480   664.390     0.150
    68.488   663.549     0.150
    68.488   663.770     0.150
    68.501   664.330     0.150
    68.544   664.846     0.150
    68.544   664.740     0.150
    68.544   664.470     0.150
    68.558   664.820     0.150
    68.575   664.690     0.150
    68.575   664.540     0.150
    68.589   664.780     0.150
    68.634   664.940     0.150
    68.655   665.240     0.150
    68.650   665.060     0.150
    68.676   665.400     0.150
    68.683   665.740     0.150
    68.683   665.890     0.150
    68.763   665.800     0.150
    68.815   666.040     0.150
    68.898   665.747     0.150
    68.898   665.850     0.150
    68.955   666.420     0.150
    68.962   667.140     0.150
    68.862   667.547     0.150
    68.862   667.320     0.150
    68.980   667.360     0.150
    68.992   667.310     0.150
    69.046   667.210     0.150
    69.075   668.230     0.150
    69.100   668.200     0.150
    69.118   667.770     0.150
    69.174   668.340     0.150
    69.229   669.020     0.150
    69.237   669.120     0.150
    69.396   670.740     0.150
    69.396   669.860     0.150
    69.382   669.250     0.150
    69.498   670.800     0.150
    69.836   672.870     0.150
    69.856   673.190     0.150
    69.963   673.950     0.150
    70.039   672.800     0.150
    70.038   673.600     0.150
    70.121   675.430     0.150
    70.204   675.040     0.150
    70.279   675.750     0.150
    70.272   678.300     0.150
    70.491   677.140     0.150
    70.522   677.780     0.150
    70.545   677.040     0.150
    70.552   677.640     0.150
    70.552   676.900     0.150
    70.549   677.850     0.150
    70.639   678.000     0.150
    70.681   678.100     0.150
    70.688   677.882     0.150
    70.688   677.670     0.150
    70.762   678.520     0.150
    70.815   678.800     0.150
    70.861   677.690     0.150
    70.915   679.730     0.150
    70.933   678.720     0.150
    70.961   679.730     0.150
    70.993   679.630     0.150
    71.026   680.987     0.150
    71.079   680.450     0.150
    71.182   680.500     0.150
    71.186   681.110     0.150
    71.234   680.210     0.150
    71.293   680.840     0.150
    71.319   682.000     0.150
    71.387   681.950     0.150
    71.414   682.300     0.150
    71.417   683.270     0.150
    71.500   683.490     0.150
    71.526   684.030     0.150
    71.901   684.090     0.150
    71.748   683.550     0.150
    71.763   684.660     0.150
    71.825   684.410     0.150
    71.999   685.770     0.150
    71.953   686.408     0.150
    71.953   686.190     0.150
    72.146   686.570     0.150
    72.180   687.350     0.150
    72.167   687.850     0.150
    72.266   688.271     0.150
    72.274   687.000     0.150
    72.324   687.620     0.150
    72.559   689.410     0.150
    72.563   689.930     0.150
    72.670   689.820     0.150
    72.863   690.710     0.150
    72.946   691.350     0.150
    73.002   691.900     0.150
    73.120   691.690     0.150
    73.237   692.850     0.150
    73.440   694.550     0.150
    73.466   694.300     0.150
    73.501   694.740     0.150
    73.510   694.910     0.150
    73.518   695.220     0.150
    73.527   694.521     0.150
    73.544   694.785     0.150
    73.614   695.329     0.150
    73.614   695.440     0.150
    73.643   694.870     0.150
    73.725   695.630     0.150
    73.811   696.590     0.150
    73.860   697.405     0.150
    73.860   697.110     0.150
    74.142   699.370     0.150
    74.157   700.640     0.150
    74.231   699.470     0.150
    74.280   698.860     0.150
    74.309   699.331     0.150
    74.394   700.561     0.150
    74.725   702.280     0.150
    74.726   702.561     0.150
    74.761   702.227     0.150
    74.830   702.620     0.150
    74.854   702.629     0.150
    75.077   704.200     0.150
    75.239   705.694     0.150
    75.239   705.140     0.150
    75.366   706.291     0.150
    75.772   710.064     0.150
    75.997   709.302     0.150
    75.997   709.061     0.150
    76.001   709.581     0.150
    75.898   710.960     0.150
    76.073   709.530     0.150
    76.179   711.090     0.150
    76.220   710.840     0.150
    76.244   710.331     0.150
    76.308   711.880     0.150
    76.406   711.100     0.150
    76.441   712.041     0.150
    76.427   712.360     0.150
    76.540   712.640     0.150
    76.689   712.740     0.150
    76.953   715.530     0.150
    77.141   716.840     0.150
    77.209   716.880     0.150
    77.401   717.699     0.150
    77.401   717.240     0.150
    77.444   718.190     0.150
    77.444   717.690     0.150
    77.645   719.130     0.150
    77.907   719.840     0.150
    77.944   719.630     0.150
    77.944   718.630     0.150
    78.054   718.750     0.150
    78.081   720.730     0.150
    78.273   722.490     0.150
    78.446   724.920     0.150
    78.495   723.811     0.150
    78.527   724.380     0.150
    78.554   724.099     0.150
    78.680   724.780     0.150
    78.739   724.670     0.150
    79.523   730.480     0.150
    79.668   729.970     0.150
    79.754   732.240     0.150
    79.754   732.583     0.150
    79.754   732.061     0.150
    79.812   731.850     0.150
    79.898   731.271     0.150
    80.083   731.840     0.150
    80.599   735.840     0.150
    80.736   735.140     0.150
    80.980   736.550     0.150
    81.592   739.480     0.150
    81.754   740.230     0.150
    82.367   744.620     0.150
    83.209   747.200     0.150
    83.312   748.910     0.150
    84.122   752.640     0.150
    84.169   754.500     0.150
    84.813   754.440     0.150
    86.298   763.860     0.150
    87.492   769.850     0.150
    87.492   769.541     0.150
    87.776   771.480     0.150
    88.085   772.539     0.150
    88.147   772.704     0.150
    88.147   773.041     0.150
    88.146   772.660     0.150
    88.468   774.940     0.150
    88.538   775.360     0.150
    88.576   775.420     0.150
    89.337   778.745     0.150
    89.337   778.570     0.150
    90.157   783.201     0.150
    90.157   782.950     0.150
    91.055   786.489     0.150
    91.055   786.311     0.150
    91.211   787.480     0.150
    92.372   793.320     0.150
    96.288   810.630     0.150
    98.940   822.680     0.150
   103.239   842.170     0.150
    34.583   412.150     0.150
   129.297  1151.940     0.150
   138.391  1172.140     0.150
     0.501     9.756     0.150
     0.501    17.616     0.150
     0.755    14.436     0.150
     0.850    15.526     0.150
     0.850    27.116     0.150
     0.931    31.096     0.150
     0.931    16.956     0.150
     0.979    19.696     0.150
     1.059    20.346     0.150
     1.249    24.256     0.150
     1.249    42.916     0.150
     1.249    41.966     0.150
     1.291    43.256     0.150
     1.291    23.436     0.150
     1.535    27.256     0.150
     1.684    28.896     0.150
     1.684    51.295     0.150
     1.845    32.625     0.150
     1.845    59.446     0.150
     1.980    35.166     0.150
     1.980    61.156     0.150
     2.107    39.065     0.150
     2.167    38.355     0.150
     2.289    39.476     0.150
     2.346    40.736     0.150
     2.514    42.716     0.150
     2.576    43.936     0.150
     2.607    44.496     0.150
     2.800    47.806     0.150
     2.871    48.295     0.150
     2.981    49.196     0.150
     2.998    48.835     0.150
     3.101    49.996     0.150
     3.164    51.625     0.150
     3.195    52.426     0.150
     3.333    53.256     0.150
     3.480    55.186     0.150
     3.465    55.526     0.150
     3.594    56.996     0.150
     3.660    59.166     0.150
     3.773    59.646     0.150
     3.829    61.416     0.150
     3.903    61.236     0.150
     3.891    62.406     0.150
     4.294    67.236     0.150
     4.379    68.026     0.150
     4.490    70.216     0.150
     4.510    70.506     0.150
     4.509    70.596     0.150
     4.500    71.625     0.150
     4.598    72.506     0.150
     4.776    73.806     0.150
     4.838    75.006     0.150
     4.973    75.206     0.150
     4.989    78.366     0.150
     5.543    83.916     0.150
     6.140    93.516     0.150
     6.661   100.386     0.150
     6.681   101.045     0.150
     7.383   110.496     0.150
     7.679   113.946     0.150
     9.213   134.656     0.150
    10.524   155.105     0.150
    22.242   299.906     0.150
    25.513   330.526     0.150
     0.492     9.570     0.150
     0.492    16.539     0.150
     0.584    11.160     0.150
     0.584    19.301     0.150
     0.744    13.359     0.150
     0.908    28.641     0.150
     0.908    16.641     0.150
     0.937    31.578     0.150
     0.937    18.059     0.150
     0.925    18.961     0.150
     0.925    32.129     0.150
     1.068    36.961     0.150
     1.068    20.641     0.150
     1.229    23.418     0.150
     1.229    40.129     0.150
     1.435    25.039     0.150
     1.563    27.598     0.150
     1.714    30.609     0.150
     1.841    32.629     0.150
     1.869    33.430     0.150
     1.911    34.898     0.150
     1.970    35.281     0.150
     2.081    36.059     0.150
     2.081    64.570     0.150
     2.111    36.648     0.150
     2.111    66.781     0.150
     2.321    71.551     0.150
     2.321    39.258     0.150
     2.351    40.098     0.150
     2.351    74.309     0.150
     2.357    40.629     0.150
     2.535    44.090     0.150
     2.498    42.008     0.150
     2.664    46.879     0.150
     2.867    47.398     0.150
     2.910    47.770     0.150
     2.954    48.941     0.150
     3.264    51.461     0.150
     3.527    56.949     0.150
     3.598    56.539     0.150
     3.653    58.789     0.150
     3.758    58.750     0.150
     4.161    63.250     0.150
     4.249    66.539     0.150
     4.876    74.699     0.150
    15.801   223.441     0.150
    16.010   226.879     0.150
    17.453   242.539     0.150
    18.720   258.660     0.150
    21.416   290.500     0.150
    22.412   299.281     0.150
    25.572   332.711     0.150
    39.509   454.238     0.150
    39.510   454.480     0.150
    57.848   592.430     0.150
    59.149   602.090     0.150
    59.409   603.848     0.150
    60.399   609.648     0.150
    60.399   610.219     0.150
    62.498   624.738     0.150
    64.813   639.758     0.150
    68.754   665.289     0.150
    71.479   683.301     0.150
     0.519    10.047     0.150
     0.519    16.906     0.150
     0.635    12.055     0.150
     0.635    20.422     0.150
     0.801    25.305     0.150
     0.927    31.656     0.150
     0.927    17.836     0.150
     0.894    30.703     0.150
     0.894    18.227     0.150
     0.965    17.641     0.150
     1.125    21.766     0.150
     1.125    37.992     0.150
     1.123    19.633     0.150
     1.170    37.641     0.150
     1.170    22.445     0.150
     1.295    23.297     0.150
     1.323    41.891     0.150
     1.434    45.641     0.150
     1.492    26.242     0.150
     1.620    28.242     0.150
     1.699    31.391     0.150
     1.699    55.211     0.150
     1.757    57.016     0.150
     1.762    31.805     0.150
     1.893    33.367     0.150
     1.928    34.688     0.150
     1.919    35.000     0.150
     2.028    35.562     0.150
     2.064    36.406     0.150
     2.131    36.773     0.150
     2.379    40.461     0.150
     2.410    41.336     0.150
     2.388    41.672     0.150
     2.439    41.422     0.150
     2.543    80.094     0.150
     2.578    44.172     0.150
     2.600    83.320     0.150
     2.926    48.164     0.150
     2.965    48.336     0.150
     2.981    49.633     0.150
     3.199    51.531     0.150
     3.220    51.586     0.150
     3.310    52.797     0.150
     3.281    53.586     0.150
     3.471    54.656     0.150
     3.555    57.133     0.150
     3.517    57.172     0.150
     3.585    57.297     0.150
     3.607    59.000     0.150
     3.678    59.484     0.150
     3.817    59.891     0.150
     3.847    62.016     0.150
     3.936    62.453     0.150
     3.960    63.461     0.150
     4.125    64.453     0.150
     4.100    64.625     0.150
     4.226    66.086     0.150
     4.192    65.500     0.150
     4.289    67.164     0.150
     4.301    67.516     0.150
     4.281    67.742     0.150
     4.375    69.195     0.150
     4.370    70.133     0.150
     4.382    70.031     0.150
     4.569    71.211     0.150
     4.635    72.305     0.150
     4.808    73.156     0.150
     4.800    74.914     0.150
     4.880    75.422     0.150
     4.862    75.555     0.150
     4.994    76.781     0.150
    36.892   431.266     0.150
    57.835   592.281     0.150
    67.728   658.500     0.150
    69.371   669.344     0.150
    69.371   669.344     0.150
     0.498     9.602     0.150
     0.498    16.832     0.150
     0.787    24.642     0.150
     0.787    14.912     0.150
     0.808    15.182     0.150
     0.808    25.692     0.150
     0.904    16.092     0.150
     0.959    19.122     0.150
     1.123    36.052     0.150
     1.077    34.792     0.150
     1.077    20.502     0.150
     1.223    24.232     0.150
     1.223    41.952     0.150
     1.258    21.632     0.150
     1.461    25.632     0.150
     1.461    45.972     0.150
     1.493    26.272     0.150
     1.608    51.342     0.150
     1.608    28.792     0.150
     1.646    28.822     0.150
     1.773    30.702     0.150
     1.833    33.532     0.150
     1.879    34.692     0.150
     1.888    34.222     0.150
     1.938    35.162     0.150
     2.059    36.722     0.150
     2.064    36.602     0.150
     2.070    37.602     0.150
     2.140    37.982     0.150
     2.304    40.362     0.150
     2.317    40.652     0.150
     2.487    42.042     0.150
     2.543    42.822     0.150
     2.565    44.932     0.150
     2.716    46.822     0.150
     2.757    47.832     0.150
     2.837    48.822     0.150
     2.915    49.472     0.150
     3.023    50.712     0.150
     3.067    50.172     0.150
     3.041    50.562     0.150
     3.125    51.632     0.150
     3.153    52.112     0.150
     3.276    54.272     0.150
     3.294    55.712     0.150
     3.404    55.412     0.150
     3.376    55.212     0.150
     3.447    54.652     0.150
     3.430    55.972     0.150
     3.570    57.062     0.150
     3.631    58.282     0.150
     3.737    59.742     0.150
     3.786    60.892     0.150
     3.849    61.462     0.150
     3.942    62.222     0.150
     3.946    62.852     0.150
     4.017    63.882     0.150
     4.052    66.092     0.150
     4.104    65.052     0.150
     4.134    66.272     0.150
     4.257    66.872     0.150
     4.343    68.162     0.150
     4.451    69.792     0.150
     4.470    69.942     0.150
     4.466    70.242     0.150
     4.457    71.012     0.150
     4.555    71.822     0.150
     4.736    73.402     0.150
     4.799    73.802     0.150
     4.941    75.322     0.150
     4.970    77.102     0.150
     4.964    77.402     0.150
     5.035    78.232     0.150
     5.146    80.802     0.150
     5.251    80.952     0.150
     5.279    80.472     0.150
     5.259    81.452     0.150
     5.300    82.222     0.150
    21.937   295.602     0.150
    57.933   593.442     0.150
    67.834   659.582     0.150
    67.851   660.652     0.150
    69.518   670.162     0.150
    69.518   670.392     0.150
     0.540    10.676     0.150
     0.540    17.926     0.150
     0.735    13.865     0.150
     0.735    23.176     0.150
     0.915    28.977     0.150
     0.915    16.865     0.150
     0.993    17.545     0.150
     0.993    32.486     0.150
     0.986    19.646     0.150
     1.009    19.615     0.150
     1.009    33.637     0.150
     1.308    25.295     0.150
     1.308    43.846     0.150
     1.356    44.326     0.150
     1.356    23.766     0.150
     1.567    48.195     0.150
     1.715    53.426     0.150
     1.750    54.566     0.150
     1.750    29.816     0.150
     1.781    55.695     0.150
     1.781    32.236     0.150
     1.876    58.316     0.150
     2.045    63.545     0.150
     2.045    36.387     0.150
     2.155    67.295     0.150
     2.155    38.045     0.150
     2.145    38.557     0.150
     2.170    67.076     0.150
     2.228    69.346     0.150
     2.228    38.986     0.150
     2.230    39.166     0.150
     2.411    41.336     0.150
     2.640    44.406     0.150
     2.662    45.646     0.150
     2.913    48.875     0.150
     2.929    49.467     0.150
     2.936    48.436     0.150
     3.166    51.406     0.150
     3.678    60.016     0.150
     3.839    60.105     0.150
     3.846    60.906     0.150
     3.888    61.906     0.150
     3.940    63.416     0.150
     3.958    63.775     0.150
     4.192    66.945     0.150
     4.228    67.816     0.150
     4.556    71.375     0.150
     4.572    71.195     0.150
     4.659    73.566     0.150
     5.595    87.307     0.150
     5.751    88.756     0.150
     5.805    86.945     0.150
     5.852    90.016     0.150
     5.870    90.445     0.150
     6.154    94.016     0.150
     6.572   101.186     0.150
    10.289   149.477     0.150
    10.566   156.096     0.150
    11.329   163.416     0.150
    12.677   181.887     0.150
    12.866   184.436     0.150
     0.565    11.012     0.150
     0.583    10.973     0.150
     1.119    21.250     0.150
     1.187    22.590     0.150
     1.706    30.301     0.150
     1.706    52.922     0.150
     1.903    34.141     0.150
     1.852    35.293     0.150
     1.852    60.453     0.150
     2.014    62.562     0.150
     2.014    36.500     0.150
     2.077    63.641     0.150
     2.077    36.391     0.150
     2.122    36.883     0.150
     2.122    66.211     0.150
     2.366    40.730     0.150
     2.383    41.223     0.150
     2.321    40.363     0.150
     2.465    41.883     0.150
     2.922    48.430     0.150
     3.266    53.781     0.150
     3.281    52.391     0.150
     3.281    52.191     0.150
     3.457    56.613     0.150
     3.542    57.551     0.150
     3.609    58.680     0.150
     4.190    67.090     0.150
     4.589    72.480     0.150
     4.732    73.312     0.150
     4.805    75.820     0.150
     5.477    83.273     0.150
     6.267    95.430     0.150
     7.115   105.301     0.150
     8.179   120.820     0.150
     8.856   130.781     0.150
    10.811   156.730     0.150
    11.962   171.750     0.150
    18.001   253.070     0.150
    20.462   282.023     0.150
    20.576   281.660     0.150
    21.343   290.062     0.150
    25.894   335.562     0.150
     3.457    56.422     0.150
     7.115   104.953     0.150
     7.115   105.582     0.150
     8.179   120.992     0.150
     8.856   130.141     0.150
    10.396   154.312     0.150
    12.165   173.953     0.150
    12.888   184.621     0.150
    16.182   229.633     0.150
    18.001   254.133     0.150
    18.767   264.652     0.150
    20.720   283.383     0.150
    21.343   289.941     0.150
    21.396   289.930     0.150
    22.929   307.160     0.150
    23.645   313.312     0.150
    25.027   328.230     0.150
    26.952   347.441     0.150
    28.051   354.711     0.150
    28.779   360.652     0.150
    30.782   376.551     0.150
    33.478   404.082     0.150
    34.152   409.191     0.150
    34.731   411.652     0.150
    36.853   431.332     0.150
    38.021   439.250     0.150
    39.448   452.363     0.150
    40.894   465.863     0.150
    42.620   478.750     0.150
    44.950   496.453     0.150
    45.642   502.250     0.150
    48.223   521.750     0.150
    53.185   559.652     0.150
    56.593   584.273     0.150
    58.761   599.453     0.150
    59.123   603.852     0.150
    59.123   603.621     0.150
    60.184   612.430     0.150
    60.353   609.953     0.150
    62.437   624.352     0.150
    63.598   632.852     0.150
    64.130   636.551     0.150
    64.764   640.250     0.150
    64.764   639.113     0.150
    64.912   641.863     0.150
    67.948   660.863     0.150
    68.684   664.461     0.150
    70.470   676.980     0.150
    70.730   677.570     0.150
    71.214   680.801     0.150
    75.080   702.320     0.150
    83.877   753.043     0.150
    88.190   774.152     0.150
     0.566    18.207     0.150
     0.566    11.195     0.150
     0.590    18.715     0.150
     0.590    11.254     0.150
     0.801    14.234     0.150
     0.932    17.074     0.150
     0.850    29.727     0.150
     0.850    17.586     0.150
     0.991    18.914     0.150
     1.104    19.195     0.150
     1.124    21.566     0.150
     1.256    39.695     0.150
     1.256    22.414     0.150
     1.181    22.945     0.150
     1.386    25.355     0.150
     1.461    25.605     0.150
     1.589    28.047     0.150
     1.712    31.195     0.150
     1.909    34.164     0.150
     1.855    35.066     0.150
     2.019    36.117     0.150
     2.083    36.555     0.150
     2.116    37.715     0.150
     2.326    40.438     0.150
     2.371    40.457     0.150
     2.389    41.027     0.150
     2.546    46.406     0.150
     2.459    41.477     0.150
     2.613    44.324     0.150
     2.900    48.117     0.150
     2.928    49.016     0.150
     3.287    53.234     0.150
     3.252    53.574     0.150
     3.261    53.695     0.150
     3.275    52.727     0.150
     3.458    56.977     0.150
     3.553    56.348     0.150
     3.547    58.555     0.150
     3.614    58.977     0.150
     3.611    57.047     0.150
     3.799    59.977     0.150
     3.802    61.406     0.150
     3.871    61.566     0.150
     4.065    64.547     0.150
     4.161    65.707     0.150
     4.250    67.477     0.150
     4.258    67.047     0.150
     4.185    64.938     0.150
     4.319    69.516     0.150
     4.527    71.465     0.150
     4.595    71.906     0.150
     4.736    73.598     0.150
     4.786    73.047     0.150
     4.846    74.785     0.150
     5.013    77.145     0.150
     5.065    79.227     0.150
     5.108    78.137     0.150
     5.413    83.074     0.150
     5.545    85.336     0.150
     5.543    85.984     0.150
     5.563    84.266     0.150
     5.471    83.105     0.150
     5.815    88.348     0.150
     5.774    87.117     0.150
     5.874    89.617     0.150
     6.272    94.938     0.150
     6.390    95.777     0.150
     7.121   105.375     0.150
     7.158   107.234     0.150
     7.166   107.266     0.150
     7.357   109.785     0.150
     7.397   110.645     0.150
     7.519   111.555     0.150
     7.672   113.727     0.150
     7.871   117.055     0.150
     8.068   118.457     0.150
     8.244   120.715     0.150
     8.178   120.555     0.150
     8.967   131.395     0.150
    10.122   147.598     0.150
    10.484   152.605     0.150
    11.141   160.465     0.150
    12.344   178.055     0.150
    12.885   184.727     0.150
    21.341   288.746     0.150
    21.438   289.688     0.150
    22.707   303.266     0.150
    25.039   325.805     0.150
    25.526   331.195     0.150
    25.891   334.695     0.150
     0.546    10.852     0.150
     0.546    18.344     0.150
     0.606    11.031     0.150
     1.123    21.883     0.150
     1.226    37.172     0.150
     1.178    22.703     0.150
     1.472    25.875     0.150
     1.915    34.184     0.150
     1.880    34.395     0.150
     2.021    35.773     0.150
     2.097    36.652     0.150
     2.373    40.113     0.150
     2.350    40.023     0.150
     2.396    40.703     0.150
     2.452    41.484     0.150
     2.909    47.223     0.150
     2.941    48.145     0.150
     3.294    52.113     0.150
     3.237    52.414     0.150
     3.262    53.152     0.150
     3.254    52.473     0.150
     3.466    55.375     0.150
     3.482    56.383     0.150
     3.565    56.152     0.150
     3.570    57.453     0.150
     3.590    57.715     0.150
     3.638    57.984     0.150
     3.805    59.762     0.150
     3.818    60.543     0.150
     3.896    61.832     0.150
     3.920    62.652     0.150
     4.077    64.473     0.150
     4.172    64.941     0.150
     4.162    66.062     0.150
     4.264    66.602     0.150
     4.257    67.242     0.150
     4.274    66.984     0.150
     4.542    71.172     0.150
     4.793    73.184     0.150
     4.761    73.281     0.150
     4.858    74.715     0.150
     5.037    78.004     0.150
     5.086    78.473     0.150
     5.117    77.941     0.150
     5.287    81.574     0.150
     5.437    83.242     0.150
     5.467    84.215     0.150
     5.455    82.633     0.150
     5.555    85.492     0.150
     5.569    83.594     0.150
     5.563    85.305     0.150
     5.728    86.281     0.150
     5.751    86.984     0.150
     5.838    89.555     0.150
     5.887    89.254     0.150
     6.253    95.113     0.150
     6.383    95.125     0.150
     6.409    96.875     0.150
     7.188   108.133     0.150
     7.372   110.492     0.150
     7.681   112.492     0.150
     7.882   115.602     0.150
     7.939   117.594     0.150
     8.049   119.582     0.150
     8.087   118.793     0.150
     8.248   120.625     0.150
     8.199   119.582     0.150
     8.506   122.875     0.150
    14.624   207.164     0.150
    15.225   216.203     0.150
    15.433   218.465     0.150
    15.452   218.863     0.150
    15.853   223.684     0.150
    16.161   228.762     0.150
    16.512   232.062     0.150
    16.617   235.773     0.150
    16.824   236.852     0.150
    17.008   240.543     0.150
    17.404   244.883     0.150
    17.651   247.102     0.150
    17.707   248.973     0.150
    17.878   251.164     0.150
    17.976   252.164     0.150
    18.231   255.082     0.150
    18.295   256.504     0.150
    18.650   260.273     0.150
    18.743   261.031     0.150
    18.926   262.484     0.150
    19.014   264.184     0.150
    19.298   267.273     0.150
    19.462   269.594     0.150
    19.497   269.344     0.150
    19.575   270.383     0.150
    19.610   270.262     0.150
    19.702   271.484     0.150
    20.281   277.812     0.150
    20.310   278.805     0.150
    20.436   279.562     0.150
    20.548   280.734     0.150
    20.649   281.613     0.150
    21.002   285.273     0.150
    21.291   289.805     0.150
    21.357   289.031     0.150
    21.373   289.832     0.150
    22.056   297.215     0.150
    22.822   304.113     0.150
    25.050   327.203     0.150
    25.905   335.305     0.150
    26.930   344.293     0.150
    31.290   381.852     0.150
    31.421   383.352     0.150
    32.066   387.844     0.150
    33.452   401.305     0.150
    34.124   408.332     0.150
    36.868   432.625     0.150
    40.075   458.332     0.150
    40.092   458.191     0.150
    40.093   457.852     0.150
    40.855   463.703     0.150
    41.715   470.074     0.150
    41.768   471.512     0.150
    41.872   472.074     0.150
    42.022   472.684     0.150
     2.452    41.953     0.150
     3.482    56.902     0.150
     5.751    86.781     0.150
     7.121   104.902     0.150
     8.199   120.594     0.150
     8.840   130.344     0.150
    10.371   152.254     0.150
    12.895   184.055     0.150
    14.209   206.242     0.150
    15.746   224.305     0.150
    17.976   253.742     0.150
    18.743   261.582     0.150
    20.436   280.652     0.150
    20.693   283.305     0.150
    21.357   289.512     0.150
    21.373   290.004     0.150
    22.395   300.324     0.150
    22.902   306.523     0.150
    23.672   313.672     0.150
    23.797   315.863     0.150
    24.910   327.852     0.150
    25.050   327.055     0.150
    25.000   327.324     0.150
    25.556   331.812     0.150
    26.394   342.184     0.150
    26.515   338.082     0.150
    28.022   354.281     0.150
    28.453   357.102     0.150
    28.800   360.402     0.150
    30.198   373.184     0.150
    30.808   376.902     0.150
    31.006   381.602     0.150
    31.038   381.574     0.150
    31.856   387.531     0.150
    33.452   403.102     0.150
    33.452   402.262     0.150
    33.616   403.133     0.150
    33.613   403.102     0.150
    34.124   409.082     0.150
    34.867   413.434     0.150
    36.726   430.914     0.150
    36.868   431.113     0.150
    36.900   431.555     0.150
    37.552   437.055     0.150
    38.040   439.555     0.150
    39.426   451.973     0.150
    40.092   458.293     0.150
    40.075   459.305     0.150
    40.075   459.191     0.150
    40.855   463.922     0.150
    40.867   466.191     0.150
    41.965   473.484     0.150
    42.602   478.582     0.150
    45.159   499.012     0.150
    44.971   497.203     0.150
    45.813   506.184     0.150
    48.247   523.402     0.150
    52.666   559.023     0.150
    53.451   564.172     0.150
    58.116   595.453     0.150
    58.797   599.012     0.150
    58.789   599.203     0.150
    59.151   605.203     0.150
    59.151   604.504     0.150
    59.151   603.691     0.150
    59.151   603.902     0.150
    59.428   606.672     0.150
    59.662   605.594     0.150
    59.788   607.004     0.150
    59.926   609.102     0.150
    60.382   611.004     0.150
    60.375   609.902     0.150
    60.809   614.102     0.150
    60.809   613.363     0.150
    60.928   616.805     0.150
    63.627   634.004     0.150
    64.793   640.125     0.150
    66.061   648.305     0.150
    66.609   653.875     0.150
    67.107   655.703     0.150
    67.744   659.914     0.150
    67.935   661.594     0.150
    68.076   661.543     0.150
    68.157   662.133     0.150
    68.238   662.703     0.150
    68.530   665.703     0.150
    68.530   664.941     0.150
    68.707   664.691     0.150
    68.980   666.191     0.150
    69.259   668.391     0.150
    69.884   674.984     0.150
    70.025   673.988     0.150
    70.044   673.930     0.150
    70.046   674.305     0.150
    70.103   674.148     0.150
    70.109   674.625     0.150
    70.308   679.004     0.150
    70.308   675.602     0.150
    70.383   676.574     0.150
    70.380   678.805     0.150
    70.380   678.305     0.150
    70.407   679.004     0.150
    70.489   676.992     0.150
    70.594   678.695     0.150
    70.594   677.973     0.150
    70.594   677.602     0.150
    70.648   677.922     0.150
    70.658   678.242     0.150
    70.658   678.805     0.150
    70.686   677.754     0.150
    70.686   677.902     0.150
    70.752   678.305     0.150
    70.752   677.723     0.150
    70.946   681.402     0.150
    71.032   682.363     0.150
    71.144   680.969     0.150
    71.197   681.648     0.150
    71.234   681.082     0.150
    71.234   680.805     0.150
    71.460   683.707     0.150
    71.542   683.711     0.150
    71.598   683.012     0.150
    72.028   687.375     0.150
    72.028   685.805     0.150
    72.136   687.805     0.150
    72.185   687.418     0.150
    72.156   687.094     0.150
    72.428   688.824     0.150
    72.679   693.094     0.150
    73.066   692.727     0.150
    73.066   692.504     0.150
    73.066   692.305     0.150
    73.364   692.191     0.150
    73.327   694.543     0.150
    73.327   692.875     0.150
    73.334   694.133     0.150
    73.335   694.746     0.150
    73.416   696.203     0.150
    73.416   694.945     0.150
    73.416   694.203     0.150
    73.467   694.004     0.150
    73.603   695.816     0.150
    73.603   694.113     0.150
    73.633   696.637     0.150
    73.633   696.312     0.150
    73.698   696.887     0.150
    74.123   699.344     0.150
    74.134   701.043     0.150
    74.464   701.250     0.150
    74.592   701.062     0.150
    74.663   701.703     0.150
    75.187   705.102     0.150
    75.155   704.520     0.150
    75.910   708.762     0.150
    76.002   709.004     0.150
    76.470   714.602     0.150
    76.950   717.492     0.150
    77.146   718.504     0.150
    77.494   718.664     0.150
    77.793   719.145     0.150
    77.902   720.422     0.150
    78.270   725.754     0.150
    78.517   723.984     0.150
    83.905   753.352     0.150
    88.216   773.902     0.150
   157.826  1229.035     0.150
   159.940  1237.965     0.150
   161.479  1245.805     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
