#!/bin/bash
gmt begin hubbard5.7_sel1 pdf,ps
proj=-JM16.0c+
reg=-R-140.2/-139.3/60.2/60.7
gmt basemap $proj $reg -Bxa0.2f0.1 -Bya0.2f0.1 -BWeSn+t'Base Map hubbard5.7'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -139.481    60.410 97
  -139.410    60.307 98
  -139.467    60.419 99
  -139.454    60.378 100
  -139.760    60.562 101
  -139.355    60.402 102
  -139.870    60.534 103
  -139.860    60.520 104
  -139.862    60.524 105
  -140.071    60.586 106
  -139.856    60.525 107
  -139.556    60.453 108
  -139.579    60.486 109
  -139.733    60.571 110
  -139.464    60.425 111
  -139.953    60.585 112
  -139.927    60.550 113
  -139.446    60.443 114
  -139.993    60.555 115
  -139.886    60.638 116
  -139.933    60.592 117
  -139.843    60.543 118
  -139.442    60.417 119
  -139.913    60.529 120
  -139.919    60.556 121
  -139.905    60.546 122
  -139.696    60.591 123
  -139.458    60.413 124
  -139.865    60.570 125
  -139.818    60.608 126
  -139.607    60.494 127
  -139.583    60.492 128
  -139.892    60.526 129
  -139.939    60.505 130
  -139.541    60.391 131
  -139.488    60.420 132
  -139.943    60.562 133
  -139.824    60.567 134
  -139.552    60.449 135
  -139.360    60.401 136
  -139.885    60.629 137
  -139.873    60.627 138
  -139.856    60.604 139
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -139.546    60.359
  -139.481    60.410
>
  -139.443    60.245
  -139.410    60.307
>
  -139.567    60.315
  -139.467    60.419
>
  -139.492    60.289
  -139.454    60.378
>
  -139.840    60.481
  -139.760    60.562
>
  -139.365    60.376
  -139.355    60.402
>
  -139.922    60.518
  -139.870    60.534
>
  -139.949    60.478
  -139.860    60.520
>
  -140.086    60.476
  -139.862    60.524
>
  -140.230    60.555
  -140.071    60.586
>
  -139.932    60.507
  -139.856    60.525
>
  -139.684    60.444
  -139.556    60.453
>
  -139.634    60.475
  -139.579    60.486
>
  -139.899    60.566
  -139.733    60.571
>
  -139.649    60.415
  -139.464    60.425
>
  -140.095    60.563
  -139.953    60.585
>
  -139.990    60.554
  -139.927    60.550
>
  -139.530    60.453
  -139.446    60.443
>
  -140.051    60.539
  -139.993    60.555
>
  -139.941    60.627
  -139.886    60.638
>
  -140.131    60.592
  -139.933    60.592
>
  -139.951    60.478
  -139.843    60.543
>
  -139.487    60.420
  -139.442    60.417
>
  -140.077    60.499
  -139.913    60.529
>
  -140.042    60.536
  -139.919    60.556
>
  -140.000    60.529
  -139.905    60.546
>
  -139.873    60.493
  -139.696    60.591
>
  -139.475    60.507
  -139.458    60.413
>
  -139.935    60.580
  -139.865    60.570
>
  -139.997    60.548
  -139.818    60.608
>
  -139.614    60.445
  -139.607    60.494
>
  -139.651    60.479
  -139.583    60.492
>
  -139.865    60.509
  -139.892    60.526
>
  -140.075    60.450
  -139.939    60.505
>
  -139.594    60.340
  -139.541    60.391
>
  -139.499    60.372
  -139.488    60.420
>
  -140.021    60.542
  -139.943    60.562
>
  -139.830    60.519
  -139.824    60.567
>
  -139.605    60.429
  -139.552    60.449
>
  -139.385    60.395
  -139.360    60.401
>
  -139.956    60.533
  -139.885    60.629
>
  -139.995    60.614
  -139.873    60.627
>
  -139.967    60.582
  -139.856    60.604
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -139.480    60.410
  -139.481    60.410
>
  -139.408    60.307
  -139.410    60.307
>
  -139.466    60.419
  -139.467    60.419
>
  -139.453    60.377
  -139.454    60.378
>
  -139.760    60.562
  -139.760    60.562
>
  -139.354    60.402
  -139.355    60.402
>
  -139.869    60.533
  -139.870    60.534
>
  -139.861    60.519
  -139.860    60.520
>
  -139.861    60.525
  -139.862    60.524
>
  -140.072    60.586
  -140.071    60.586
>
  -139.856    60.525
  -139.856    60.525
>
  -139.557    60.454
  -139.556    60.453
>
  -139.579    60.486
  -139.579    60.486
>
  -139.733    60.571
  -139.733    60.571
>
  -139.464    60.424
  -139.464    60.425
>
  -139.955    60.585
  -139.953    60.585
>
  -139.926    60.550
  -139.927    60.550
>
  -139.446    60.443
  -139.446    60.443
>
  -139.990    60.555
  -139.993    60.555
>
  -139.885    60.637
  -139.886    60.638
>
  -139.936    60.591
  -139.933    60.592
>
  -139.843    60.543
  -139.843    60.543
>
  -139.442    60.417
  -139.442    60.417
>
  -139.912    60.529
  -139.913    60.529
>
  -139.918    60.556
  -139.919    60.556
>
  -139.905    60.546
  -139.905    60.546
>
  -139.696    60.591
  -139.696    60.591
>
  -139.458    60.413
  -139.458    60.413
>
  -139.865    60.570
  -139.865    60.570
>
  -139.819    60.608
  -139.818    60.608
>
  -139.607    60.493
  -139.607    60.494
>
  -139.585    60.492
  -139.583    60.492
>
  -139.891    60.526
  -139.892    60.526
>
  -139.939    60.505
  -139.939    60.505
>
  -139.541    60.391
  -139.541    60.391
>
  -139.488    60.420
  -139.488    60.420
>
  -139.944    60.562
  -139.943    60.562
>
  -139.824    60.568
  -139.824    60.567
>
  -139.551    60.450
  -139.552    60.449
>
  -139.360    60.401
  -139.360    60.401
>
  -139.885    60.629
  -139.885    60.629
>
  -139.873    60.627
  -139.873    60.627
>
  -139.855    60.604
  -139.856    60.604
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -139.481    60.410    81.674     2.666     2.899
  -139.410    60.307   -47.305     2.370     2.680
  -139.467    60.419   -54.792     2.384     3.214
  -139.454    60.378   -78.713     3.446     5.740
  -139.760    60.562   -21.770     2.133     2.708
  -139.355    60.402   -66.891     2.405     2.600
  -139.870    60.534   -27.828     1.870     3.067
  -139.860    60.520    -0.911     1.538     1.975
  -139.862    60.524   -18.016     2.247     2.947
  -140.071    60.586     4.870     3.916     4.283
  -139.856    60.525   -12.464     2.083     3.022
  -139.556    60.453    -2.139     2.109     2.331
  -139.579    60.486    -1.228     1.340     1.578
  -139.733    60.571    26.367     1.386     1.542
  -139.464    60.425    83.116     1.895     2.296
  -139.953    60.585   -60.652     1.657     1.912
  -139.927    60.550   -19.830     1.609     1.736
  -139.446    60.443   -64.492     2.024     2.245
  -139.993    60.555    34.798     1.565     1.692
  -139.886    60.638    -4.084     2.146     2.781
  -139.933    60.592   -26.471     2.631     3.810
  -139.843    60.543   -13.493     2.008     2.211
  -139.442    60.417    26.404     1.408     1.665
  -139.913    60.529   -11.686     1.858     2.257
  -139.919    60.556   -10.871     1.651     1.987
  -139.905    60.546    75.396     1.985     3.052
  -139.696    60.591   -82.844     1.325     1.612
  -139.458    60.413   -87.779     1.195     1.778
  -139.865    60.570   -19.624     1.638     1.825
  -139.818    60.608    71.930     4.025     4.503
  -139.607    60.494    22.749     2.236     3.619
  -139.583    60.492    66.855     1.896     2.140
  -139.892    60.526   -48.732     1.227     1.353
  -139.939    60.505    85.274     1.785     2.267
  -139.541    60.391   -83.601     1.265     1.780
  -139.488    60.420    -2.817     1.790     1.994
  -139.943    60.562   -11.473     2.080     2.450
  -139.824    60.567    -8.640     1.606     1.943
  -139.552    60.449     8.571     1.925     2.135
  -139.360    60.401    80.677     2.050     2.160
  -139.885    60.629    21.240     1.962     2.122
  -139.873    60.627   -19.942     1.730     2.121
  -139.856    60.604   -72.803     1.400     1.728
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -139.481    60.410     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -140.064    60.261    45.700     1.924     2.324
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -140.041    60.261   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -140.064    60.261     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -140.064    60.261     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -140.064    60.216   5 km
EOF
gmt end
