#!/bin/bash
gmt begin hubbard5.7_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-3/5/0/53
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya20f10+l'Counts' -BWeSn+t'Origin Time Mislocation hubbard5.7' << EOF
     1.176
     0.406
     0.684
     0.895
     0.758
    -0.633
    -1.500
    -0.070
     0.918
     0.664
     0.730
     0.898
     1.281
     1.084
    -0.500
     1.145
     0.691
     0.240
     0.516
    -0.266
    -1.582
     0.559
     1.180
     0.164
    -0.359
    -0.207
     1.195
     1.070
    -1.562
     2.125
     0.871
     0.003
    -1.245
     0.824
     1.031
     1.656
     1.027
     0.359
     0.414
     1.191
     1.082
    -0.002
     0.992
     0.211
     0.983
     0.941
     0.578
     0.977
     0.826
     1.000
     0.039
    -0.430
     0.550
     0.896
     0.961
     1.150
     1.055
     0.305
     1.039
    -0.016
     0.032
    -0.156
     0.740
    -0.720
     0.404
     0.465
     0.794
     0.373
     0.438
     0.623
     0.586
     1.062
     0.270
     0.261
     0.836
    -0.219
     0.391
     0.553
     0.875
     0.576
     0.273
    -0.465
     0.484
     0.344
     0.484
    -0.867
     1.039
    -0.305
     0.891
     1.109
    -0.008
    -0.406
     1.383
     0.508
     0.625
     0.633
     2.594
     0.961
     2.219
     1.938
     2.375
     1.547
     1.258
     2.656
     2.273
     2.141
     1.969
     2.367
     2.331
     1.759
     2.080
     1.043
     1.522
     1.378
     0.827
     0.996
     1.270
     2.195
     1.824
     2.020
     2.230
     2.055
     2.871
     1.715
     1.812
     2.582
     0.711
     1.496
     0.891
     1.305
     1.261
     0.826
     0.641
     1.250
     1.762
     1.125
     1.031
     0.906
     1.117
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.891    46.783 Median =   0.9 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.9  0.
  0.9  45.9
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -2.800    50.217 Author: all ( 139 samples)
EOF
gmt end
