#!/bin/bash
gmt begin hubbard5.7_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-20/20/-20/20
gmt basemap $proj $reg -Bxa10f5+l'km' -Bya10f5+l'km' -BWeSn+t'Epicentral Mislocation hubbard5.7'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     9.538     9.538
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.119    -5.520
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.736     1.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.938     5.295
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.391     3.980
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.098    -5.611
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.805    13.270
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.805    13.270 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.213    -2.633
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.260     1.336
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.591    -7.702
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.464     8.053
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.345    -0.623
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.549    -1.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.031    -7.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.206    -0.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.226     4.376
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.895     8.479
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.895     8.479 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.509     3.054
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.831    -6.832
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.159     8.162
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.609     4.640
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.609     4.640 20
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.325     8.521
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.325     8.521 21
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.091     4.286
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.345     5.021
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.695     4.612
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.546    -1.226
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.636    -0.945
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.155    -8.871
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.172    -1.656
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.310    -8.176
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.310    -8.176 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.787     8.394
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.787     8.394 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.722     1.700
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.879    -3.527
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.449    -2.833
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.112    -2.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.985    -3.952
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.405    -2.490
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.747    -4.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.394     5.629
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.003     0.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.676    -6.254
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.030    -5.025
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.270     0.467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.730    -6.034
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.782     0.947
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.092    -3.571
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.582    -0.772
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.913     0.882
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.609    -2.898
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.469     0.129
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.748    -5.379
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.260     4.954
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.787    -2.338
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.101    -1.151
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.862     1.455
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.340    -1.472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.980    -4.612
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.607    -5.255
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.229     0.798
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.410    -1.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.500     1.636
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.573    -0.316
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.559     0.323
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.165    -3.154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.380     0.367
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.820     1.841
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.034    -0.385
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.175    -3.481
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.014    -4.642
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.452     1.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.097     0.370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.251    -6.114
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.820    -3.562
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.712     0.285
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.431    -6.334
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.223     7.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.608    -0.528
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.400     2.268
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.707    -3.660
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.213    -1.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.304    -2.170
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.489    -3.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.993     0.035
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.922     1.155
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.398    -3.838
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.667    -0.765
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.130     8.039
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.016    -2.676
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.194    -5.762
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.604    -7.390
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.943    -4.699
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.163     3.903
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.166     2.747
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.414   -15.899
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.414   -15.899 93
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.012    -1.156
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.576     3.900
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.778     0.867
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.593    -5.750
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.853    -6.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.436   -11.657
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.436   -11.657 99
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.093    -9.847
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.093    -9.847 100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.436    -9.095
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.436    -9.095 101
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.572    -2.942
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.855    -1.854
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.917    -4.586
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.257    -5.457
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.257    -5.457 105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.744    -3.356
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.179    -2.038
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.084    -1.122
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.048    -1.170
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.080    -0.476
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.181    -1.070
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.181    -1.070 111
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.804    -2.386
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.441     0.484
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.616     1.151
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.201    -1.774
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.023    -1.221
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.888    -0.000
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.888    -0.000 117
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.923    -7.315
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.477     0.348
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.021    -3.283
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.021    -3.283 120
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.784    -2.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.239    -1.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.628   -11.076
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.628   -11.076 123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.923    10.548
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.923    10.548 124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.831     1.171
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.880    -6.664
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.880    -6.664 126
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.380    -5.433
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.705    -1.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.436    -1.905
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.525    -6.094
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.525    -6.094 130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.917    -5.724
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.566    -5.381
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.311    -2.197
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.285    -5.442
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.907    -2.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.391    -0.678
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.897   -10.707
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.897   -10.707 137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.707    -1.548
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.095    -2.463
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -1.930    -1.453     0.000     1.500     1.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -18.500    18.500 Author: all ( 139 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -18.500   -18.500 Average =   2.4 km at 233.0 deg; median =    4.8 km
EOF
gmt end
