#!/bin/bash
gmt begin hubbard5.7_ell pdf,ps
proj=-JM16.0c+
reg=-R-140.2/-138.9/59.8/60.7
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map hubbard5.7'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -139.519    60.100    14.196     2.131     3.856
  -139.629    60.117    11.499     0.430     2.278
  -139.443    60.130   -24.930     1.547     2.181
  -139.463    60.128   -26.321     1.255     1.828
  -139.210    60.143    17.621     2.010     3.308
  -139.378    60.071   -56.171     1.997     2.735
  -139.402    60.096   -56.660     1.812     2.606
  -139.409    60.106   -56.665     1.601     2.867
  -139.652    60.241   -28.241     1.599     2.620
  -139.167    59.912    -3.258     3.864     4.827
  -139.585    60.167   -13.182     1.551     2.760
  -139.055    59.980   -40.025     3.089     3.420
  -139.692    60.263   -64.453     2.298     3.276
  -139.600    60.243   -21.378     1.899     3.454
  -139.591    60.235   -23.545     1.715     3.571
  -139.425    60.183   -11.209     1.862     2.806
  -139.419    60.131   -30.302     1.841     3.321
  -139.297    59.993   -47.224     2.784     3.190
  -139.365    60.172   -16.262     1.753     2.358
  -139.844    60.092   -51.637     1.305     2.096
  -139.634    60.184    -4.337     2.703     3.868
  -139.739    60.228   -30.285     1.582     2.797
  -139.369    60.139   -70.232     0.942     1.511
  -139.391    60.123   -64.030     0.926     1.547
  -139.387    60.133   -36.220     1.801     2.076
  -139.373    60.154   -58.685     1.647     2.109
  -139.396    60.171   -32.940     2.154     2.622
  -139.535    60.336   -52.551     3.547     4.696
  -139.376    60.135   -20.652     1.477     2.468
  -139.486    60.135   -52.907     1.251     3.216
  -139.833    60.056   -83.599     1.199     1.929
  -139.542    60.205    76.997     1.847     2.324
  -139.658    60.184   -70.931     1.366     1.781
  -139.577    60.200     6.690     0.881     1.297
  -139.188    60.224    67.343     1.578     2.099
  -139.619    60.243   -14.159     1.142     1.626
  -139.422    60.098    76.150     1.873     2.269
  -139.636    60.190   -13.698     0.925     1.397
  -139.436    60.120    29.325     0.820     1.192
  -139.478    60.044    39.579     1.964     2.110
  -139.391    60.099    45.611     1.741     2.137
  -139.419    60.072    44.232     1.244     1.840
  -139.436    60.206    70.969     1.736     2.445
  -139.525    60.164    19.106     0.725     0.776
  -139.196    60.225    67.724     1.338     1.695
  -139.531    60.183    67.686     1.015     1.158
  -139.555    60.163    24.558     1.105     1.217
  -139.554    60.250    56.648     0.933     1.212
  -139.584    60.242     9.434     0.765     1.162
  -139.407    60.123   -88.347     1.225     1.612
  -139.508    60.140    51.192     0.976     1.121
  -139.452    60.109    64.278     0.951     1.170
  -139.505    60.155    27.596     0.781     0.972
  -139.576    60.441    19.125     0.994     1.084
  -139.564    60.227    67.802     0.945     1.242
  -139.770    60.212    60.292     1.278     1.794
  -139.383    60.114    79.024     1.126     1.538
  -139.152    59.902    66.987     1.152     1.449
  -139.782    60.319    34.582     1.864     2.040
  -139.645    60.307    -5.057     0.716     0.835
  -139.373    59.977    84.990     1.113     1.918
  -139.475    60.115    89.264     1.608     1.859
  -139.366    59.978   -89.907     1.275     1.747
  -139.366    59.987    67.060     1.727     1.829
  -139.370    59.982   -89.715     0.768     1.074
  -139.794    60.296   -22.862     1.218     1.479
  -139.453    60.111    80.019     1.064     1.262
  -139.595    59.979   -80.391     2.264     2.797
  -139.110    59.977    81.970     0.903     1.357
  -139.642    60.254    19.277     0.997     1.283
  -139.226    60.009    83.120     1.598     2.083
  -139.557    60.400    60.305     1.523     1.972
  -139.174    60.011   -89.495     0.820     1.361
  -139.865    60.275   -20.122     0.950     1.258
  -139.590    60.203    75.917     0.912     1.118
  -139.567    60.220    80.620     1.139     1.807
  -139.242    59.976    79.589     2.267     3.156
  -139.011    60.457    30.901     1.299     2.081
  -139.499    60.161    53.511     1.722     2.171
  -139.274    60.038    63.927     1.824     2.479
  -139.831    60.443    28.080     2.016     2.356
  -139.852    60.156   -66.530     3.829     6.917
  -139.450    60.098    80.132     1.610     1.927
  -139.428    60.107    81.978     1.690     2.033
  -139.800    60.315    71.816     1.681     2.026
  -139.246    59.918    71.262     1.939     2.631
  -139.115    60.467   -18.422     2.607     3.389
  -139.835    60.340   -89.412     1.375     1.825
  -139.650    60.245    -5.836     2.152     2.763
  -139.631    60.240    -4.997     2.807     3.640
  -139.495    59.955    70.473     2.032     2.178
  -139.930    60.084    86.268     1.889     2.771
  -139.699    60.201    71.943     4.061     4.440
  -139.464    60.136   -85.325     1.723     2.007
  -139.269    60.078    37.148     1.327     1.610
  -139.261    60.079    65.368     1.456     1.604
  -139.481    60.410    81.674     2.666     2.899
  -139.410    60.307   -47.305     2.370     2.680
  -139.467    60.419   -54.792     2.384     3.214
  -139.454    60.378   -78.713     3.446     5.740
  -139.760    60.562   -21.770     2.133     2.708
  -139.355    60.402   -66.891     2.405     2.600
  -139.870    60.534   -27.828     1.870     3.067
  -139.860    60.520    -0.911     1.538     1.975
  -139.862    60.524   -18.016     2.247     2.947
  -140.071    60.586     4.870     3.916     4.283
  -139.856    60.525   -12.464     2.083     3.022
  -139.556    60.453    -2.139     2.109     2.331
  -139.579    60.486    -1.228     1.340     1.578
  -139.733    60.571    26.367     1.386     1.542
  -139.464    60.425    83.116     1.895     2.296
  -139.953    60.585   -60.652     1.657     1.912
  -139.927    60.550   -19.830     1.609     1.736
  -139.446    60.443   -64.492     2.024     2.245
  -139.993    60.555    34.798     1.565     1.692
  -139.886    60.638    -4.084     2.146     2.781
  -139.933    60.592   -26.471     2.631     3.810
  -139.843    60.543   -13.493     2.008     2.211
  -139.442    60.417    26.404     1.408     1.665
  -139.913    60.529   -11.686     1.858     2.257
  -139.919    60.556   -10.871     1.651     1.987
  -139.905    60.546    75.396     1.985     3.052
  -139.696    60.591   -82.844     1.325     1.612
  -139.458    60.413   -87.779     1.195     1.778
  -139.865    60.570   -19.624     1.638     1.825
  -139.818    60.608    71.930     4.025     4.503
  -139.607    60.494    22.749     2.236     3.619
  -139.583    60.492    66.855     1.896     2.140
  -139.892    60.526   -48.732     1.227     1.353
  -139.939    60.505    85.274     1.785     2.267
  -139.541    60.391   -83.601     1.265     1.780
  -139.488    60.420    -2.817     1.790     1.994
  -139.943    60.562   -11.473     2.080     2.450
  -139.824    60.567    -8.640     1.606     1.943
  -139.552    60.449     8.571     1.925     2.135
  -139.360    60.401    80.677     2.050     2.160
  -139.885    60.629    21.240     1.962     2.122
  -139.873    60.627   -19.942     1.730     2.121
  -139.856    60.604   -72.803     1.400     1.728
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -139.481    60.410     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -140.065    59.856    45.700     1.924     2.324
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -140.043    59.856   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -140.065    59.856     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -140.065    59.856     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -140.065    59.811   5 km
EOF
gmt end
