#!/bin/bash
gmt begin hubbard5.7_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-25/15/0/14
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation hubbard5.7' << EOF
    -0.000
    -7.000
    -3.000
    -3.000
    -3.000
   -20.000
   -16.000
    -4.000
     1.000
    -8.800
   -11.000
    -9.000
    -0.000
    -5.000
    -9.300
     5.000
    -2.000
    -5.000
     1.000
    -5.200
   -18.000
    -8.000
    -0.500
    -7.200
    -1.000
     1.000
    -0.000
    -6.000
    -5.000
    -1.000
   -12.000
    -4.900
   -13.100
     3.200
    -2.000
     5.000
    -2.000
    -8.100
    -4.000
    -0.000
    -2.000
    -3.500
    -4.000
    -2.300
    -4.000
    -8.300
   -11.500
    -3.800
    -8.600
    -2.000
   -12.500
    -7.700
     0.100
     1.000
    -6.700
    -1.000
    -2.000
    -4.800
    -1.000
    -8.900
   -13.000
    -7.000
    -3.900
    -1.600
    -3.700
    -5.900
    -4.900
   -10.000
    -5.300
    -4.100
    -5.500
     1.000
    -5.100
     8.500
    -7.000
    -4.000
    -3.400
    -2.000
    -9.000
   -10.400
    -8.400
    -8.000
    -2.400
    -1.400
    -5.500
   -19.000
     1.000
    -3.500
    -0.900
    -2.000
    -7.600
   -17.200
    -4.000
     1.200
    -2.200
     1.100
     2.000
    -0.000
    10.000
     7.000
    10.000
     0.800
     5.000
     9.100
     4.000
     6.000
     6.000
     6.000
    10.000
     5.000
     5.000
     3.000
     2.000
     2.000
    -0.000
     3.000
    -7.000
    10.000
     6.000
     3.000
     6.000
     9.000
     8.000
     3.000
     5.000
    10.000
     3.000
     8.200
     1.300
    -1.000
     4.000
    -0.500
    -0.000
    -0.500
     3.000
     3.000
     2.000
     1.800
     0.300
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -2.000    12.735 Median =  -2.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -2.0  0.
 -2.0  12.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -24.000    13.265 Author: all ( 139 samples)
EOF
gmt end
