#!/bin/bash
gmt begin hubbard5.7_dcal pdf,ps
proj=-JM16.0c+
reg=-R-143.8/-135.3/58.0/62.5
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration hubbard5.7'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -139.729    59.553
  -139.519    60.100
>
  -140.257    60.097
  -139.629    60.117
>
  -139.397    59.669
  -139.443    60.130
>
  -139.729    59.553
  -139.443    60.130
>
  -138.877    59.452
  -139.443    60.130
>
  -139.397    59.669
  -139.463    60.128
>
  -139.729    59.553
  -139.463    60.128
>
  -138.877    59.452
  -139.463    60.128
>
  -139.635    59.953
  -139.210    60.143
>
  -139.729    59.553
  -139.210    60.143
>
  -137.504    60.825
  -139.210    60.143
>
  -137.504    60.825
  -139.210    60.143
>
  -139.729    59.553
  -139.378    60.071
>
  -139.729    59.553
  -139.402    60.096
>
  -140.257    60.097
  -139.409    60.106
>
  -140.257    60.097
  -139.409    60.106
>
  -139.397    59.669
  -139.409    60.106
>
  -139.397    59.669
  -139.409    60.106
>
  -138.877    59.452
  -139.409    60.106
>
  -138.877    59.452
  -139.409    60.106
>
  -139.635    59.953
  -139.652    60.241
>
  -139.635    59.953
  -139.652    60.241
>
  -140.257    60.097
  -139.652    60.241
>
  -140.257    60.097
  -139.652    60.241
>
  -139.397    59.669
  -139.652    60.241
>
  -141.117    60.063
  -139.652    60.241
>
  -139.635    59.953
  -139.167    59.912
>
  -139.397    59.669
  -139.167    59.912
>
  -139.729    59.553
  -139.167    59.912
>
  -139.635    59.953
  -139.585    60.167
>
  -139.635    59.953
  -139.585    60.167
>
  -139.397    59.669
  -139.585    60.167
>
  -139.729    59.553
  -139.585    60.167
>
  -141.745    60.363
  -139.585    60.167
>
  -141.745    60.363
  -139.585    60.167
>
  -139.635    59.953
  -139.055    59.980
>
  -139.635    59.953
  -139.055    59.980
>
  -139.397    59.669
  -139.055    59.980
>
  -139.729    59.553
  -139.055    59.980
>
  -140.257    60.097
  -139.055    59.980
>
  -141.117    60.063
  -139.055    59.980
>
  -141.117    60.063
  -139.055    59.980
>
  -139.635    59.953
  -139.692    60.263
>
  -140.257    60.097
  -139.692    60.263
>
  -141.117    60.063
  -139.692    60.263
>
  -141.745    60.363
  -139.692    60.263
>
  -139.635    59.953
  -139.600    60.243
>
  -139.635    59.953
  -139.600    60.243
>
  -140.257    60.097
  -139.600    60.243
>
  -140.257    60.097
  -139.600    60.243
>
  -139.397    59.669
  -139.600    60.243
>
  -139.729    59.553
  -139.600    60.243
>
  -139.635    59.953
  -139.591    60.235
>
  -139.635    59.953
  -139.591    60.235
>
  -140.257    60.097
  -139.591    60.235
>
  -139.397    59.669
  -139.591    60.235
>
  -139.397    59.669
  -139.591    60.235
>
  -139.729    59.553
  -139.591    60.235
>
  -139.635    59.953
  -139.425    60.183
>
  -139.729    59.553
  -139.425    60.183
>
  -139.635    59.953
  -139.419    60.131
>
  -140.257    60.097
  -139.419    60.131
>
  -139.729    59.553
  -139.419    60.131
>
  -141.117    60.063
  -139.419    60.131
>
  -141.117    60.063
  -139.419    60.131
>
  -139.635    59.953
  -139.297    59.993
>
  -139.397    59.669
  -139.297    59.993
>
  -139.729    59.553
  -139.297    59.993
>
  -139.635    59.953
  -139.365    60.172
>
  -139.397    59.669
  -139.365    60.172
>
  -139.729    59.553
  -139.365    60.172
>
  -139.635    59.953
  -139.844    60.092
>
  -139.729    59.553
  -139.844    60.092
>
  -139.729    59.553
  -139.634    60.184
>
  -140.257    60.097
  -139.739    60.228
>
  -140.257    60.097
  -139.739    60.228
>
  -139.635    59.953
  -139.739    60.228
>
  -139.397    59.669
  -139.739    60.228
>
  -139.729    59.553
  -139.739    60.228
>
  -141.745    60.363
  -139.739    60.228
>
  -141.333    60.965
  -139.739    60.228
>
  -139.397    59.669
  -139.369    60.139
>
  -139.397    59.669
  -139.369    60.139
>
  -139.671    59.512
  -139.369    60.139
>
  -141.117    60.063
  -139.369    60.139
>
  -140.257    60.097
  -139.391    60.123
>
  -140.257    60.097
  -139.391    60.123
>
  -139.397    59.669
  -139.391    60.123
>
  -139.397    59.669
  -139.391    60.123
>
  -139.671    59.512
  -139.391    60.123
>
  -141.117    60.063
  -139.391    60.123
>
  -139.397    59.669
  -139.387    60.133
>
  -139.397    59.669
  -139.387    60.133
>
  -139.671    59.512
  -139.387    60.133
>
  -141.117    60.063
  -139.387    60.133
>
  -139.397    59.669
  -139.373    60.154
>
  -139.671    59.512
  -139.373    60.154
>
  -141.117    60.063
  -139.373    60.154
>
  -139.397    59.669
  -139.396    60.171
>
  -139.397    59.669
  -139.396    60.171
>
  -139.397    59.669
  -139.535    60.336
>
  -140.781    60.130
  -139.535    60.336
>
  -140.781    60.130
  -139.535    60.336
>
  -139.671    59.512
  -139.376    60.135
>
  -139.671    59.512
  -139.376    60.135
>
  -141.117    60.063
  -139.376    60.135
>
  -140.257    60.097
  -139.486    60.135
>
  -140.257    60.097
  -139.486    60.135
>
  -139.397    59.669
  -139.486    60.135
>
  -140.781    60.130
  -139.486    60.135
>
  -140.781    60.130
  -139.486    60.135
>
  -141.117    60.063
  -139.486    60.135
>
  -141.142    60.440
  -139.486    60.135
>
  -141.142    60.440
  -139.486    60.135
>
  -141.346    60.300
  -139.486    60.135
>
  -141.346    60.300
  -139.486    60.135
>
  -141.003    60.825
  -139.486    60.135
>
  -141.003    60.825
  -139.486    60.135
>
  -140.257    60.097
  -139.833    60.056
>
  -140.257    60.097
  -139.833    60.056
>
  -140.257    60.097
  -139.833    60.056
>
  -139.397    59.669
  -139.833    60.056
>
  -139.397    59.669
  -139.833    60.056
>
  -140.781    60.130
  -139.833    60.056
>
  -140.781    60.130
  -139.833    60.056
>
  -141.117    60.063
  -139.833    60.056
>
  -141.142    60.440
  -139.833    60.056
>
  -141.142    60.440
  -139.833    60.056
>
  -141.346    60.300
  -139.833    60.056
>
  -141.346    60.300
  -139.833    60.056
>
  -138.140    60.531
  -139.833    60.056
>
  -138.140    60.531
  -139.833    60.056
>
  -141.949    60.179
  -139.833    60.056
>
  -141.949    60.179
  -139.833    60.056
>
  -140.257    60.097
  -139.542    60.205
>
  -140.257    60.097
  -139.542    60.205
>
  -139.397    59.669
  -139.542    60.205
>
  -138.140    60.531
  -139.542    60.205
>
  -138.140    60.531
  -139.542    60.205
>
  -138.363    60.943
  -139.542    60.205
>
  -138.363    60.943
  -139.542    60.205
>
  -140.257    60.097
  -139.658    60.184
>
  -140.257    60.097
  -139.658    60.184
>
  -140.257    60.097
  -139.658    60.184
>
  -140.257    60.097
  -139.658    60.184
>
  -139.397    59.669
  -139.658    60.184
>
  -139.397    59.669
  -139.658    60.184
>
  -140.781    60.130
  -139.658    60.184
>
  -139.671    59.512
  -139.658    60.184
>
  -141.117    60.063
  -139.658    60.184
>
  -138.140    60.531
  -139.658    60.184
>
  -138.140    60.531
  -139.658    60.184
>
  -141.346    60.300
  -139.658    60.184
>
  -141.346    60.300
  -139.658    60.184
>
  -138.363    60.943
  -139.658    60.184
>
  -138.363    60.943
  -139.658    60.184
>
  -139.635    59.953
  -139.577    60.200
>
  -139.635    59.953
  -139.577    60.200
>
  -140.257    60.097
  -139.577    60.200
>
  -140.257    60.097
  -139.577    60.200
>
  -140.257    60.097
  -139.577    60.200
>
  -139.397    59.669
  -139.577    60.200
>
  -140.781    60.130
  -139.577    60.200
>
  -139.671    59.512
  -139.577    60.200
>
  -139.671    59.512
  -139.577    60.200
>
  -138.140    60.531
  -139.577    60.200
>
  -138.140    60.531
  -139.577    60.200
>
  -138.140    60.531
  -139.577    60.200
>
  -141.346    60.300
  -139.577    60.200
>
  -141.346    60.300
  -139.577    60.200
>
  -138.363    60.943
  -139.577    60.200
>
  -138.363    60.943
  -139.577    60.200
>
  -138.363    60.943
  -139.577    60.200
>
  -139.397    59.669
  -139.188    60.224
>
  -139.397    59.669
  -139.188    60.224
>
  -140.257    60.097
  -139.188    60.224
>
  -140.257    60.097
  -139.188    60.224
>
  -140.257    60.097
  -139.188    60.224
>
  -138.140    60.531
  -139.188    60.224
>
  -138.140    60.531
  -139.188    60.224
>
  -138.140    60.531
  -139.188    60.224
>
  -139.671    59.512
  -139.188    60.224
>
  -138.363    60.943
  -139.188    60.224
>
  -138.363    60.943
  -139.188    60.224
>
  -141.117    60.063
  -139.188    60.224
>
  -141.142    60.440
  -139.188    60.224
>
  -141.142    60.440
  -139.188    60.224
>
  -137.504    60.825
  -139.188    60.224
>
  -137.504    60.825
  -139.188    60.224
>
  -141.346    60.300
  -139.188    60.224
>
  -141.346    60.300
  -139.188    60.224
>
  -141.346    60.300
  -139.188    60.224
>
  -141.003    60.825
  -139.188    60.224
>
  -139.635    59.953
  -139.619    60.243
>
  -139.635    59.953
  -139.619    60.243
>
  -140.257    60.097
  -139.619    60.243
>
  -140.257    60.097
  -139.619    60.243
>
  -140.257    60.097
  -139.619    60.243
>
  -140.781    60.130
  -139.619    60.243
>
  -139.397    59.669
  -139.619    60.243
>
  -139.671    59.512
  -139.619    60.243
>
  -141.117    60.063
  -139.619    60.243
>
  -138.140    60.531
  -139.619    60.243
>
  -141.346    60.300
  -139.619    60.243
>
  -141.346    60.300
  -139.619    60.243
>
  -141.003    60.825
  -139.619    60.243
>
  -141.003    60.825
  -139.619    60.243
>
  -138.363    60.943
  -139.619    60.243
>
  -138.363    60.943
  -139.619    60.243
>
  -141.745    60.363
  -139.619    60.243
>
  -141.745    60.363
  -139.619    60.243
>
  -139.397    59.669
  -139.422    60.098
>
  -140.257    60.097
  -139.422    60.098
>
  -140.781    60.130
  -139.422    60.098
>
  -138.140    60.531
  -139.422    60.098
>
  -138.140    60.531
  -139.422    60.098
>
  -141.346    60.300
  -139.422    60.098
>
  -141.346    60.300
  -139.422    60.098
>
  -138.363    60.943
  -139.422    60.098
>
  -138.363    60.943
  -139.422    60.098
>
  -141.003    60.825
  -139.422    60.098
>
  -141.003    60.825
  -139.422    60.098
>
  -139.635    59.953
  -139.636    60.190
>
  -139.635    59.953
  -139.636    60.190
>
  -140.257    60.097
  -139.636    60.190
>
  -140.257    60.097
  -139.636    60.190
>
  -140.257    60.097
  -139.636    60.190
>
  -140.781    60.130
  -139.636    60.190
>
  -140.781    60.130
  -139.636    60.190
>
  -140.781    60.130
  -139.636    60.190
>
  -139.397    59.669
  -139.636    60.190
>
  -139.397    59.669
  -139.636    60.190
>
  -139.671    59.512
  -139.636    60.190
>
  -139.671    59.512
  -139.636    60.190
>
  -141.117    60.063
  -139.636    60.190
>
  -141.142    60.440
  -139.636    60.190
>
  -141.142    60.440
  -139.636    60.190
>
  -141.142    60.440
  -139.636    60.190
>
  -138.140    60.531
  -139.636    60.190
>
  -138.140    60.531
  -139.636    60.190
>
  -141.346    60.300
  -139.636    60.190
>
  -141.346    60.300
  -139.636    60.190
>
  -138.363    60.943
  -139.636    60.190
>
  -138.363    60.943
  -139.636    60.190
>
  -141.745    60.363
  -139.636    60.190
>
  -141.745    60.363
  -139.636    60.190
>
  -139.635    59.953
  -139.436    60.120
>
  -139.635    59.953
  -139.436    60.120
>
  -140.257    60.097
  -139.436    60.120
>
  -140.257    60.097
  -139.436    60.120
>
  -140.257    60.097
  -139.436    60.120
>
  -140.257    60.097
  -139.436    60.120
>
  -139.397    59.669
  -139.436    60.120
>
  -139.671    59.512
  -139.436    60.120
>
  -140.781    60.130
  -139.436    60.120
>
  -138.140    60.531
  -139.436    60.120
>
  -138.140    60.531
  -139.436    60.120
>
  -138.140    60.531
  -139.436    60.120
>
  -141.117    60.063
  -139.436    60.120
>
  -141.142    60.440
  -139.436    60.120
>
  -141.142    60.440
  -139.436    60.120
>
  -141.346    60.300
  -139.436    60.120
>
  -141.346    60.300
  -139.436    60.120
>
  -138.363    60.943
  -139.436    60.120
>
  -138.363    60.943
  -139.436    60.120
>
  -138.363    60.943
  -139.436    60.120
>
  -141.003    60.825
  -139.436    60.120
>
  -139.397    59.669
  -139.478    60.044
>
  -139.397    59.669
  -139.478    60.044
>
  -140.257    60.097
  -139.478    60.044
>
  -140.781    60.130
  -139.478    60.044
>
  -138.140    60.531
  -139.478    60.044
>
  -141.142    60.440
  -139.478    60.044
>
  -141.346    60.300
  -139.478    60.044
>
  -138.363    60.943
  -139.478    60.044
>
  -138.363    60.943
  -139.478    60.044
>
  -141.003    60.825
  -139.478    60.044
>
  -139.397    59.669
  -139.391    60.099
>
  -139.397    59.669
  -139.391    60.099
>
  -140.257    60.097
  -139.391    60.099
>
  -140.781    60.130
  -139.391    60.099
>
  -138.140    60.531
  -139.391    60.099
>
  -138.140    60.531
  -139.391    60.099
>
  -141.142    60.440
  -139.391    60.099
>
  -141.142    60.440
  -139.391    60.099
>
  -141.346    60.300
  -139.391    60.099
>
  -141.346    60.300
  -139.391    60.099
>
  -138.363    60.943
  -139.391    60.099
>
  -138.363    60.943
  -139.391    60.099
>
  -141.003    60.825
  -139.391    60.099
>
  -141.003    60.825
  -139.391    60.099
>
  -139.635    59.953
  -139.419    60.072
>
  -139.635    59.953
  -139.419    60.072
>
  -139.397    59.669
  -139.419    60.072
>
  -139.397    59.669
  -139.419    60.072
>
  -140.257    60.097
  -139.419    60.072
>
  -140.257    60.097
  -139.419    60.072
>
  -140.257    60.097
  -139.419    60.072
>
  -140.257    60.097
  -139.419    60.072
>
  -139.671    59.512
  -139.419    60.072
>
  -140.781    60.130
  -139.419    60.072
>
  -140.781    60.130
  -139.419    60.072
>
  -138.140    60.531
  -139.419    60.072
>
  -138.140    60.531
  -139.419    60.072
>
  -138.140    60.531
  -139.419    60.072
>
  -141.142    60.440
  -139.419    60.072
>
  -141.142    60.440
  -139.419    60.072
>
  -141.142    60.440
  -139.419    60.072
>
  -138.363    60.943
  -139.419    60.072
>
  -138.363    60.943
  -139.419    60.072
>
  -140.257    60.097
  -139.436    60.206
>
  -140.257    60.097
  -139.436    60.206
>
  -139.397    59.669
  -139.436    60.206
>
  -140.781    60.130
  -139.436    60.206
>
  -140.781    60.130
  -139.436    60.206
>
  -138.140    60.531
  -139.436    60.206
>
  -138.140    60.531
  -139.436    60.206
>
  -141.142    60.440
  -139.436    60.206
>
  -141.142    60.440
  -139.436    60.206
>
  -138.363    60.943
  -139.436    60.206
>
  -138.363    60.943
  -139.436    60.206
>
  -141.003    60.825
  -139.436    60.206
>
  -139.635    59.953
  -139.525    60.164
>
  -139.635    59.953
  -139.525    60.164
>
  -140.257    60.097
  -139.525    60.164
>
  -140.257    60.097
  -139.525    60.164
>
  -140.257    60.097
  -139.525    60.164
>
  -140.257    60.097
  -139.525    60.164
>
  -140.257    60.097
  -139.525    60.164
>
  -138.576    60.302
  -139.525    60.164
>
  -138.576    60.302
  -139.525    60.164
>
  -138.576    60.302
  -139.525    60.164
>
  -138.576    60.302
  -139.525    60.164
>
  -139.397    59.669
  -139.525    60.164
>
  -139.397    59.669
  -139.525    60.164
>
  -139.397    59.669
  -139.525    60.164
>
  -140.781    60.130
  -139.525    60.164
>
  -140.781    60.130
  -139.525    60.164
>
  -139.671    59.512
  -139.525    60.164
>
  -139.671    59.512
  -139.525    60.164
>
  -140.191    60.772
  -139.525    60.164
>
  -140.191    60.772
  -139.525    60.164
>
  -141.117    60.063
  -139.525    60.164
>
  -138.140    60.531
  -139.525    60.164
>
  -138.140    60.531
  -139.525    60.164
>
  -141.142    60.440
  -139.525    60.164
>
  -141.142    60.440
  -139.525    60.164
>
  -141.003    60.825
  -139.525    60.164
>
  -141.003    60.825
  -139.525    60.164
>
  -138.363    60.943
  -139.525    60.164
>
  -138.363    60.943
  -139.525    60.164
>
  -138.363    60.943
  -139.525    60.164
>
  -137.738    59.630
  -139.525    60.164
>
  -137.738    59.630
  -139.525    60.164
>
  -137.738    59.630
  -139.525    60.164
>
  -138.576    60.302
  -139.196    60.225
>
  -138.576    60.302
  -139.196    60.225
>
  -140.257    60.097
  -139.196    60.225
>
  -140.257    60.097
  -139.196    60.225
>
  -140.257    60.097
  -139.196    60.225
>
  -140.257    60.097
  -139.196    60.225
>
  -139.397    59.669
  -139.196    60.225
>
  -139.397    59.669
  -139.196    60.225
>
  -139.397    59.669
  -139.196    60.225
>
  -138.140    60.531
  -139.196    60.225
>
  -138.140    60.531
  -139.196    60.225
>
  -140.191    60.772
  -139.196    60.225
>
  -140.191    60.772
  -139.196    60.225
>
  -140.191    60.772
  -139.196    60.225
>
  -140.191    60.772
  -139.196    60.225
>
  -140.781    60.130
  -139.196    60.225
>
  -138.363    60.943
  -139.196    60.225
>
  -138.363    60.943
  -139.196    60.225
>
  -137.504    60.825
  -139.196    60.225
>
  -137.504    60.825
  -139.196    60.225
>
  -139.765    61.284
  -139.196    60.225
>
  -139.765    61.284
  -139.196    60.225
>
  -140.257    60.097
  -139.531    60.183
>
  -140.257    60.097
  -139.531    60.183
>
  -140.257    60.097
  -139.531    60.183
>
  -140.257    60.097
  -139.531    60.183
>
  -138.576    60.302
  -139.531    60.183
>
  -138.576    60.302
  -139.531    60.183
>
  -139.397    59.669
  -139.531    60.183
>
  -139.397    59.669
  -139.531    60.183
>
  -139.397    59.669
  -139.531    60.183
>
  -140.781    60.130
  -139.531    60.183
>
  -140.191    60.772
  -139.531    60.183
>
  -140.191    60.772
  -139.531    60.183
>
  -140.191    60.772
  -139.531    60.183
>
  -138.140    60.531
  -139.531    60.183
>
  -138.140    60.531
  -139.531    60.183
>
  -138.363    60.943
  -139.531    60.183
>
  -138.363    60.943
  -139.531    60.183
>
  -138.363    60.943
  -139.531    60.183
>
  -141.003    60.825
  -139.531    60.183
>
  -137.738    59.630
  -139.531    60.183
>
  -137.738    59.630
  -139.531    60.183
>
  -139.635    59.953
  -139.555    60.163
>
  -139.635    59.953
  -139.555    60.163
>
  -140.257    60.097
  -139.555    60.163
>
  -140.257    60.097
  -139.555    60.163
>
  -140.257    60.097
  -139.555    60.163
>
  -140.257    60.097
  -139.555    60.163
>
  -140.257    60.097
  -139.555    60.163
>
  -138.576    60.302
  -139.555    60.163
>
  -138.576    60.302
  -139.555    60.163
>
  -139.397    59.669
  -139.555    60.163
>
  -139.397    59.669
  -139.555    60.163
>
  -139.397    59.669
  -139.555    60.163
>
  -139.397    59.669
  -139.555    60.163
>
  -140.781    60.130
  -139.555    60.163
>
  -139.671    59.512
  -139.555    60.163
>
  -140.191    60.772
  -139.555    60.163
>
  -140.191    60.772
  -139.555    60.163
>
  -140.191    60.772
  -139.555    60.163
>
  -138.140    60.531
  -139.555    60.163
>
  -138.140    60.531
  -139.555    60.163
>
  -138.363    60.943
  -139.555    60.163
>
  -138.363    60.943
  -139.555    60.163
>
  -138.363    60.943
  -139.555    60.163
>
  -141.003    60.825
  -139.555    60.163
>
  -141.003    60.825
  -139.555    60.163
>
  -141.003    60.825
  -139.555    60.163
>
  -137.738    59.630
  -139.555    60.163
>
  -137.738    59.630
  -139.555    60.163
>
  -137.738    59.630
  -139.555    60.163
>
  -140.257    60.097
  -139.554    60.250
>
  -140.257    60.097
  -139.554    60.250
>
  -140.257    60.097
  -139.554    60.250
>
  -140.257    60.097
  -139.554    60.250
>
  -138.576    60.302
  -139.554    60.250
>
  -138.576    60.302
  -139.554    60.250
>
  -139.397    59.669
  -139.554    60.250
>
  -139.397    59.669
  -139.554    60.250
>
  -139.397    59.669
  -139.554    60.250
>
  -140.781    60.130
  -139.554    60.250
>
  -140.191    60.772
  -139.554    60.250
>
  -140.191    60.772
  -139.554    60.250
>
  -138.140    60.531
  -139.554    60.250
>
  -138.140    60.531
  -139.554    60.250
>
  -141.003    60.825
  -139.554    60.250
>
  -138.363    60.943
  -139.554    60.250
>
  -138.363    60.943
  -139.554    60.250
>
  -138.363    60.943
  -139.554    60.250
>
  -139.765    61.284
  -139.554    60.250
>
  -139.765    61.284
  -139.554    60.250
>
  -139.635    59.953
  -139.584    60.242
>
  -139.635    59.953
  -139.584    60.242
>
  -140.257    60.097
  -139.584    60.242
>
  -140.257    60.097
  -139.584    60.242
>
  -138.576    60.302
  -139.584    60.242
>
  -138.576    60.302
  -139.584    60.242
>
  -140.781    60.130
  -139.584    60.242
>
  -139.397    59.669
  -139.584    60.242
>
  -139.397    59.669
  -139.584    60.242
>
  -140.191    60.772
  -139.584    60.242
>
  -140.191    60.772
  -139.584    60.242
>
  -139.671    59.512
  -139.584    60.242
>
  -139.671    59.512
  -139.584    60.242
>
  -141.142    60.440
  -139.584    60.242
>
  -141.142    60.440
  -139.584    60.242
>
  -141.142    60.440
  -139.584    60.242
>
  -138.140    60.531
  -139.584    60.242
>
  -141.003    60.825
  -139.584    60.242
>
  -138.363    60.943
  -139.584    60.242
>
  -138.363    60.943
  -139.584    60.242
>
  -139.765    61.284
  -139.584    60.242
>
  -139.765    61.284
  -139.584    60.242
>
  -139.397    59.669
  -139.407    60.123
>
  -139.397    59.669
  -139.407    60.123
>
  -139.397    59.669
  -139.407    60.123
>
  -140.257    60.097
  -139.407    60.123
>
  -140.257    60.097
  -139.407    60.123
>
  -140.257    60.097
  -139.407    60.123
>
  -140.257    60.097
  -139.407    60.123
>
  -138.576    60.302
  -139.407    60.123
>
  -138.576    60.302
  -139.407    60.123
>
  -140.781    60.130
  -139.407    60.123
>
  -140.781    60.130
  -139.407    60.123
>
  -138.140    60.531
  -139.407    60.123
>
  -140.191    60.772
  -139.407    60.123
>
  -140.191    60.772
  -139.407    60.123
>
  -141.142    60.440
  -139.407    60.123
>
  -141.142    60.440
  -139.407    60.123
>
  -137.738    59.630
  -139.407    60.123
>
  -137.738    59.630
  -139.407    60.123
>
  -137.738    59.630
  -139.407    60.123
>
  -137.738    59.630
  -139.407    60.123
>
  -138.363    60.943
  -139.407    60.123
>
  -138.363    60.943
  -139.407    60.123
>
  -138.363    60.943
  -139.407    60.123
>
  -141.003    60.825
  -139.407    60.123
>
  -141.003    60.825
  -139.407    60.123
>
  -139.635    59.953
  -139.508    60.140
>
  -139.635    59.953
  -139.508    60.140
>
  -140.257    60.097
  -139.508    60.140
>
  -140.257    60.097
  -139.508    60.140
>
  -140.257    60.097
  -139.508    60.140
>
  -140.257    60.097
  -139.508    60.140
>
  -140.257    60.097
  -139.508    60.140
>
  -138.576    60.302
  -139.508    60.140
>
  -138.576    60.302
  -139.508    60.140
>
  -138.576    60.302
  -139.508    60.140
>
  -139.397    59.669
  -139.508    60.140
>
  -139.397    59.669
  -139.508    60.140
>
  -139.397    59.669
  -139.508    60.140
>
  -139.397    59.669
  -139.508    60.140
>
  -140.781    60.130
  -139.508    60.140
>
  -140.781    60.130
  -139.508    60.140
>
  -140.191    60.772
  -139.508    60.140
>
  -140.191    60.772
  -139.508    60.140
>
  -140.191    60.772
  -139.508    60.140
>
  -139.671    59.512
  -139.508    60.140
>
  -138.140    60.531
  -139.508    60.140
>
  -138.140    60.531
  -139.508    60.140
>
  -138.140    60.531
  -139.508    60.140
>
  -141.142    60.440
  -139.508    60.140
>
  -141.142    60.440
  -139.508    60.140
>
  -141.346    60.300
  -139.508    60.140
>
  -141.346    60.300
  -139.508    60.140
>
  -138.363    60.943
  -139.508    60.140
>
  -138.363    60.943
  -139.508    60.140
>
  -138.363    60.943
  -139.508    60.140
>
  -141.003    60.825
  -139.508    60.140
>
  -141.003    60.825
  -139.508    60.140
>
  -141.003    60.825
  -139.508    60.140
>
  -137.738    59.630
  -139.508    60.140
>
  -137.738    59.630
  -139.508    60.140
>
  -137.738    59.630
  -139.508    60.140
>
  -139.635    59.953
  -139.452    60.109
>
  -139.635    59.953
  -139.452    60.109
>
  -139.397    59.669
  -139.452    60.109
>
  -139.397    59.669
  -139.452    60.109
>
  -140.257    60.097
  -139.452    60.109
>
  -140.257    60.097
  -139.452    60.109
>
  -140.257    60.097
  -139.452    60.109
>
  -140.257    60.097
  -139.452    60.109
>
  -140.257    60.097
  -139.452    60.109
>
  -138.576    60.302
  -139.452    60.109
>
  -138.576    60.302
  -139.452    60.109
>
  -139.671    59.512
  -139.452    60.109
>
  -139.671    59.512
  -139.452    60.109
>
  -140.781    60.130
  -139.452    60.109
>
  -140.781    60.130
  -139.452    60.109
>
  -140.781    60.130
  -139.452    60.109
>
  -138.140    60.531
  -139.452    60.109
>
  -138.140    60.531
  -139.452    60.109
>
  -138.140    60.531
  -139.452    60.109
>
  -140.191    60.772
  -139.452    60.109
>
  -140.191    60.772
  -139.452    60.109
>
  -141.142    60.440
  -139.452    60.109
>
  -141.142    60.440
  -139.452    60.109
>
  -141.142    60.440
  -139.452    60.109
>
  -137.738    59.630
  -139.452    60.109
>
  -137.738    59.630
  -139.452    60.109
>
  -137.738    59.630
  -139.452    60.109
>
  -137.738    59.630
  -139.452    60.109
>
  -137.738    59.630
  -139.452    60.109
>
  -141.346    60.300
  -139.452    60.109
>
  -141.346    60.300
  -139.452    60.109
>
  -141.346    60.300
  -139.452    60.109
>
  -141.346    60.300
  -139.452    60.109
>
  -138.363    60.943
  -139.452    60.109
>
  -138.363    60.943
  -139.452    60.109
>
  -141.003    60.825
  -139.452    60.109
>
  -141.003    60.825
  -139.452    60.109
>
  -141.003    60.825
  -139.452    60.109
>
  -139.635    59.953
  -139.505    60.155
>
  -139.635    59.953
  -139.505    60.155
>
  -140.257    60.097
  -139.505    60.155
>
  -140.257    60.097
  -139.505    60.155
>
  -140.257    60.097
  -139.505    60.155
>
  -140.257    60.097
  -139.505    60.155
>
  -140.257    60.097
  -139.505    60.155
>
  -139.397    59.669
  -139.505    60.155
>
  -139.397    59.669
  -139.505    60.155
>
  -139.397    59.669
  -139.505    60.155
>
  -138.576    60.302
  -139.505    60.155
>
  -138.576    60.302
  -139.505    60.155
>
  -140.781    60.130
  -139.505    60.155
>
  -140.781    60.130
  -139.505    60.155
>
  -139.671    59.512
  -139.505    60.155
>
  -139.671    59.512
  -139.505    60.155
>
  -140.191    60.772
  -139.505    60.155
>
  -140.191    60.772
  -139.505    60.155
>
  -140.191    60.772
  -139.505    60.155
>
  -138.140    60.531
  -139.505    60.155
>
  -138.140    60.531
  -139.505    60.155
>
  -138.140    60.531
  -139.505    60.155
>
  -141.346    60.300
  -139.505    60.155
>
  -141.346    60.300
  -139.505    60.155
>
  -138.363    60.943
  -139.505    60.155
>
  -138.363    60.943
  -139.505    60.155
>
  -141.003    60.825
  -139.505    60.155
>
  -141.003    60.825
  -139.505    60.155
>
  -141.003    60.825
  -139.505    60.155
>
  -137.738    59.630
  -139.505    60.155
>
  -137.738    59.630
  -139.505    60.155
>
  -137.738    59.630
  -139.505    60.155
>
  -140.191    60.772
  -139.576    60.441
>
  -140.191    60.772
  -139.576    60.441
>
  -140.257    60.097
  -139.576    60.441
>
  -140.257    60.097
  -139.576    60.441
>
  -140.257    60.097
  -139.576    60.441
>
  -140.257    60.097
  -139.576    60.441
>
  -139.635    59.953
  -139.576    60.441
>
  -139.635    59.953
  -139.576    60.441
>
  -138.576    60.302
  -139.576    60.441
>
  -138.576    60.302
  -139.576    60.441
>
  -138.576    60.302
  -139.576    60.441
>
  -140.781    60.130
  -139.576    60.441
>
  -140.781    60.130
  -139.576    60.441
>
  -138.140    60.531
  -139.576    60.441
>
  -138.140    60.531
  -139.576    60.441
>
  -138.140    60.531
  -139.576    60.441
>
  -141.142    60.440
  -139.576    60.441
>
  -141.003    60.825
  -139.576    60.441
>
  -141.003    60.825
  -139.576    60.441
>
  -138.363    60.943
  -139.576    60.441
>
  -138.363    60.943
  -139.576    60.441
>
  -139.397    59.669
  -139.576    60.441
>
  -139.765    61.284
  -139.576    60.441
>
  -139.765    61.284
  -139.576    60.441
>
  -139.765    61.284
  -139.576    60.441
>
  -139.765    61.284
  -139.576    60.441
>
  -139.671    59.512
  -139.576    60.441
>
  -141.333    60.965
  -139.576    60.441
>
  -141.333    60.965
  -139.576    60.441
>
  -141.340    60.965
  -139.576    60.441
>
  -141.340    60.965
  -139.576    60.441
>
  -137.504    60.825
  -139.576    60.441
>
  -137.504    60.825
  -139.576    60.441
>
  -140.257    60.097
  -139.564    60.227
>
  -140.257    60.097
  -139.564    60.227
>
  -140.257    60.097
  -139.564    60.227
>
  -140.257    60.097
  -139.564    60.227
>
  -138.576    60.302
  -139.564    60.227
>
  -138.576    60.302
  -139.564    60.227
>
  -138.576    60.302
  -139.564    60.227
>
  -139.397    59.669
  -139.564    60.227
>
  -139.397    59.669
  -139.564    60.227
>
  -139.397    59.669
  -139.564    60.227
>
  -140.781    60.130
  -139.564    60.227
>
  -140.781    60.130
  -139.564    60.227
>
  -138.140    60.531
  -139.564    60.227
>
  -138.140    60.531
  -139.564    60.227
>
  -141.142    60.440
  -139.564    60.227
>
  -141.142    60.440
  -139.564    60.227
>
  -141.003    60.825
  -139.564    60.227
>
  -138.363    60.943
  -139.564    60.227
>
  -138.363    60.943
  -139.564    60.227
>
  -138.363    60.943
  -139.564    60.227
>
  -139.765    61.284
  -139.564    60.227
>
  -139.765    61.284
  -139.564    60.227
>
  -137.738    59.630
  -139.564    60.227
>
  -137.738    59.630
  -139.564    60.227
>
  -137.738    59.630
  -139.564    60.227
>
  -140.257    60.097
  -139.770    60.212
>
  -140.257    60.097
  -139.770    60.212
>
  -140.257    60.097
  -139.770    60.212
>
  -140.257    60.097
  -139.770    60.212
>
  -140.781    60.130
  -139.770    60.212
>
  -140.781    60.130
  -139.770    60.212
>
  -139.397    59.669
  -139.770    60.212
>
  -139.397    59.669
  -139.770    60.212
>
  -139.397    59.669
  -139.770    60.212
>
  -138.576    60.302
  -139.770    60.212
>
  -138.576    60.302
  -139.770    60.212
>
  -138.576    60.302
  -139.770    60.212
>
  -141.003    60.825
  -139.770    60.212
>
  -141.003    60.825
  -139.770    60.212
>
  -138.140    60.531
  -139.770    60.212
>
  -138.140    60.531
  -139.770    60.212
>
  -138.363    60.943
  -139.770    60.212
>
  -138.363    60.943
  -139.770    60.212
>
  -138.363    60.943
  -139.770    60.212
>
  -138.363    60.943
  -139.770    60.212
>
  -141.333    60.965
  -139.770    60.212
>
  -141.333    60.965
  -139.770    60.212
>
  -141.340    60.965
  -139.770    60.212
>
  -141.340    60.965
  -139.770    60.212
>
  -139.765    61.284
  -139.770    60.212
>
  -139.765    61.284
  -139.770    60.212
>
  -139.765    61.284
  -139.770    60.212
>
  -139.397    59.669
  -139.383    60.114
>
  -139.397    59.669
  -139.383    60.114
>
  -140.257    60.097
  -139.383    60.114
>
  -140.257    60.097
  -139.383    60.114
>
  -140.257    60.097
  -139.383    60.114
>
  -140.257    60.097
  -139.383    60.114
>
  -138.576    60.302
  -139.383    60.114
>
  -138.576    60.302
  -139.383    60.114
>
  -140.781    60.130
  -139.383    60.114
>
  -138.140    60.531
  -139.383    60.114
>
  -138.140    60.531
  -139.383    60.114
>
  -141.142    60.440
  -139.383    60.114
>
  -141.142    60.440
  -139.383    60.114
>
  -137.738    59.630
  -139.383    60.114
>
  -137.738    59.630
  -139.383    60.114
>
  -138.363    60.943
  -139.383    60.114
>
  -138.363    60.943
  -139.383    60.114
>
  -138.363    60.943
  -139.383    60.114
>
  -141.003    60.825
  -139.383    60.114
>
  -139.635    59.953
  -139.152    59.902
>
  -139.397    59.669
  -139.152    59.902
>
  -139.397    59.669
  -139.152    59.902
>
  -139.671    59.512
  -139.152    59.902
>
  -139.671    59.512
  -139.152    59.902
>
  -138.576    60.302
  -139.152    59.902
>
  -138.576    60.302
  -139.152    59.902
>
  -140.257    60.097
  -139.152    59.902
>
  -140.257    60.097
  -139.152    59.902
>
  -140.257    60.097
  -139.152    59.902
>
  -140.257    60.097
  -139.152    59.902
>
  -140.257    60.097
  -139.152    59.902
>
  -137.738    59.630
  -139.152    59.902
>
  -137.738    59.630
  -139.152    59.902
>
  -137.738    59.630
  -139.152    59.902
>
  -137.738    59.630
  -139.152    59.902
>
  -138.140    60.531
  -139.152    59.902
>
  -138.140    60.531
  -139.152    59.902
>
  -140.781    60.130
  -139.152    59.902
>
  -140.781    60.130
  -139.152    59.902
>
  -140.781    60.130
  -139.152    59.902
>
  -140.191    60.772
  -139.782    60.319
>
  -140.191    60.772
  -139.782    60.319
>
  -140.191    60.772
  -139.782    60.319
>
  -140.781    60.130
  -139.782    60.319
>
  -140.781    60.130
  -139.782    60.319
>
  -138.576    60.302
  -139.782    60.319
>
  -138.576    60.302
  -139.782    60.319
>
  -138.576    60.302
  -139.782    60.319
>
  -139.397    59.669
  -139.782    60.319
>
  -139.397    59.669
  -139.782    60.319
>
  -139.397    59.669
  -139.782    60.319
>
  -138.140    60.531
  -139.782    60.319
>
  -138.140    60.531
  -139.782    60.319
>
  -138.363    60.943
  -139.782    60.319
>
  -138.363    60.943
  -139.782    60.319
>
  -138.363    60.943
  -139.782    60.319
>
  -138.363    60.943
  -139.782    60.319
>
  -139.765    61.284
  -139.782    60.319
>
  -139.765    61.284
  -139.782    60.319
>
  -139.765    61.284
  -139.782    60.319
>
  -139.765    61.284
  -139.782    60.319
>
  -141.333    60.965
  -139.782    60.319
>
  -141.340    60.965
  -139.782    60.319
>
  -141.340    60.965
  -139.782    60.319
>
  -141.949    60.179
  -139.782    60.319
>
  -141.949    60.179
  -139.782    60.319
>
  -141.949    60.179
  -139.782    60.319
>
  -139.635    59.953
  -139.645    60.307
>
  -139.635    59.953
  -139.645    60.307
>
  -140.257    60.097
  -139.645    60.307
>
  -140.257    60.097
  -139.645    60.307
>
  -140.257    60.097
  -139.645    60.307
>
  -140.257    60.097
  -139.645    60.307
>
  -140.191    60.772
  -139.645    60.307
>
  -140.191    60.772
  -139.645    60.307
>
  -140.191    60.772
  -139.645    60.307
>
  -138.576    60.302
  -139.645    60.307
>
  -138.576    60.302
  -139.645    60.307
>
  -138.576    60.302
  -139.645    60.307
>
  -140.781    60.130
  -139.645    60.307
>
  -139.397    59.669
  -139.645    60.307
>
  -139.397    59.669
  -139.645    60.307
>
  -139.397    59.669
  -139.645    60.307
>
  -141.142    60.440
  -139.645    60.307
>
  -138.140    60.531
  -139.645    60.307
>
  -138.140    60.531
  -139.645    60.307
>
  -138.140    60.531
  -139.645    60.307
>
  -139.671    59.512
  -139.645    60.307
>
  -139.671    59.512
  -139.645    60.307
>
  -141.003    60.825
  -139.645    60.307
>
  -141.003    60.825
  -139.645    60.307
>
  -141.346    60.300
  -139.645    60.307
>
  -141.346    60.300
  -139.645    60.307
>
  -138.363    60.943
  -139.645    60.307
>
  -138.363    60.943
  -139.645    60.307
>
  -139.765    61.284
  -139.645    60.307
>
  -139.765    61.284
  -139.645    60.307
>
  -139.765    61.284
  -139.645    60.307
>
  -139.765    61.284
  -139.645    60.307
>
  -141.333    60.965
  -139.645    60.307
>
  -141.340    60.965
  -139.645    60.307
>
  -141.340    60.965
  -139.645    60.307
>
  -139.635    59.953
  -139.373    59.977
>
  -139.635    59.953
  -139.373    59.977
>
  -139.397    59.669
  -139.373    59.977
>
  -140.257    60.097
  -139.373    59.977
>
  -140.257    60.097
  -139.373    59.977
>
  -139.671    59.512
  -139.373    59.977
>
  -138.576    60.302
  -139.373    59.977
>
  -138.576    60.302
  -139.373    59.977
>
  -138.576    60.302
  -139.373    59.977
>
  -140.191    60.772
  -139.373    59.977
>
  -140.191    60.772
  -139.373    59.977
>
  -137.738    59.630
  -139.373    59.977
>
  -137.738    59.630
  -139.373    59.977
>
  -137.738    59.630
  -139.373    59.977
>
  -141.142    60.440
  -139.373    59.977
>
  -138.363    60.943
  -139.373    59.977
>
  -138.363    60.943
  -139.373    59.977
>
  -140.257    60.097
  -139.475    60.115
>
  -140.257    60.097
  -139.475    60.115
>
  -139.397    59.669
  -139.475    60.115
>
  -139.397    59.669
  -139.475    60.115
>
  -138.576    60.302
  -139.475    60.115
>
  -138.576    60.302
  -139.475    60.115
>
  -140.191    60.772
  -139.475    60.115
>
  -140.191    60.772
  -139.475    60.115
>
  -138.363    60.943
  -139.475    60.115
>
  -138.363    60.943
  -139.475    60.115
>
  -137.738    59.630
  -139.475    60.115
>
  -139.397    59.669
  -139.366    59.978
>
  -139.397    59.669
  -139.366    59.978
>
  -139.397    59.669
  -139.366    59.978
>
  -140.257    60.097
  -139.366    59.978
>
  -140.257    60.097
  -139.366    59.978
>
  -140.257    60.097
  -139.366    59.978
>
  -140.257    60.097
  -139.366    59.978
>
  -138.576    60.302
  -139.366    59.978
>
  -138.576    60.302
  -139.366    59.978
>
  -138.576    60.302
  -139.366    59.978
>
  -140.781    60.130
  -139.366    59.978
>
  -140.781    60.130
  -139.366    59.978
>
  -138.140    60.531
  -139.366    59.978
>
  -138.140    60.531
  -139.366    59.978
>
  -137.738    59.630
  -139.366    59.978
>
  -137.738    59.630
  -139.366    59.978
>
  -140.191    60.772
  -139.366    59.978
>
  -140.191    60.772
  -139.366    59.978
>
  -141.142    60.440
  -139.366    59.978
>
  -141.142    60.440
  -139.366    59.978
>
  -141.346    60.300
  -139.366    59.978
>
  -141.346    60.300
  -139.366    59.978
>
  -138.363    60.943
  -139.366    59.978
>
  -138.363    60.943
  -139.366    59.978
>
  -139.397    59.669
  -139.366    59.987
>
  -139.397    59.669
  -139.366    59.987
>
  -140.257    60.097
  -139.366    59.987
>
  -140.257    60.097
  -139.366    59.987
>
  -138.576    60.302
  -139.366    59.987
>
  -138.576    60.302
  -139.366    59.987
>
  -140.191    60.772
  -139.366    59.987
>
  -140.191    60.772
  -139.366    59.987
>
  -137.738    59.630
  -139.366    59.987
>
  -137.738    59.630
  -139.366    59.987
>
  -138.363    60.943
  -139.366    59.987
>
  -138.363    60.943
  -139.366    59.987
>
  -139.635    59.953
  -139.370    59.982
>
  -139.397    59.669
  -139.370    59.982
>
  -139.397    59.669
  -139.370    59.982
>
  -139.397    59.669
  -139.370    59.982
>
  -139.397    59.669
  -139.370    59.982
>
  -140.257    60.097
  -139.370    59.982
>
  -140.257    60.097
  -139.370    59.982
>
  -140.257    60.097
  -139.370    59.982
>
  -140.257    60.097
  -139.370    59.982
>
  -138.576    60.302
  -139.370    59.982
>
  -138.576    60.302
  -139.370    59.982
>
  -138.576    60.302
  -139.370    59.982
>
  -138.576    60.302
  -139.370    59.982
>
  -140.781    60.130
  -139.370    59.982
>
  -140.781    60.130
  -139.370    59.982
>
  -140.781    60.130
  -139.370    59.982
>
  -138.140    60.531
  -139.370    59.982
>
  -138.140    60.531
  -139.370    59.982
>
  -138.140    60.531
  -139.370    59.982
>
  -140.191    60.772
  -139.370    59.982
>
  -140.191    60.772
  -139.370    59.982
>
  -140.191    60.772
  -139.370    59.982
>
  -140.191    60.772
  -139.370    59.982
>
  -141.117    60.063
  -139.370    59.982
>
  -141.117    60.063
  -139.370    59.982
>
  -137.738    59.630
  -139.370    59.982
>
  -137.738    59.630
  -139.370    59.982
>
  -137.738    59.630
  -139.370    59.982
>
  -137.738    59.630
  -139.370    59.982
>
  -141.142    60.440
  -139.370    59.982
>
  -141.142    60.440
  -139.370    59.982
>
  -141.142    60.440
  -139.370    59.982
>
  -141.346    60.300
  -139.370    59.982
>
  -141.346    60.300
  -139.370    59.982
>
  -138.363    60.943
  -139.370    59.982
>
  -138.363    60.943
  -139.370    59.982
>
  -140.257    60.097
  -139.794    60.296
>
  -140.257    60.097
  -139.794    60.296
>
  -139.635    59.953
  -139.794    60.296
>
  -139.635    59.953
  -139.794    60.296
>
  -140.191    60.772
  -139.794    60.296
>
  -140.191    60.772
  -139.794    60.296
>
  -140.191    60.772
  -139.794    60.296
>
  -140.191    60.772
  -139.794    60.296
>
  -140.781    60.130
  -139.794    60.296
>
  -140.781    60.130
  -139.794    60.296
>
  -138.576    60.302
  -139.794    60.296
>
  -138.576    60.302
  -139.794    60.296
>
  -139.397    59.669
  -139.794    60.296
>
  -139.397    59.669
  -139.794    60.296
>
  -141.142    60.440
  -139.794    60.296
>
  -141.117    60.063
  -139.794    60.296
>
  -141.117    60.063
  -139.794    60.296
>
  -141.346    60.300
  -139.794    60.296
>
  -141.346    60.300
  -139.794    60.296
>
  -139.671    59.512
  -139.794    60.296
>
  -141.003    60.825
  -139.794    60.296
>
  -138.363    60.943
  -139.794    60.296
>
  -138.363    60.943
  -139.794    60.296
>
  -141.745    60.363
  -139.794    60.296
>
  -139.765    61.284
  -139.794    60.296
>
  -139.765    61.284
  -139.794    60.296
>
  -141.333    60.965
  -139.794    60.296
>
  -141.340    60.965
  -139.794    60.296
>
  -141.754    60.732
  -139.794    60.296
>
  -141.949    60.179
  -139.794    60.296
>
  -141.949    60.179
  -139.794    60.296
>
  -141.949    60.179
  -139.794    60.296
>
  -141.949    60.179
  -139.794    60.296
>
  -140.257    60.097
  -139.453    60.111
>
  -140.257    60.097
  -139.453    60.111
>
  -140.257    60.097
  -139.453    60.111
>
  -140.257    60.097
  -139.453    60.111
>
  -139.397    59.669
  -139.453    60.111
>
  -139.397    59.669
  -139.453    60.111
>
  -139.397    59.669
  -139.453    60.111
>
  -138.576    60.302
  -139.453    60.111
>
  -138.576    60.302
  -139.453    60.111
>
  -140.781    60.130
  -139.453    60.111
>
  -140.781    60.130
  -139.453    60.111
>
  -140.191    60.772
  -139.453    60.111
>
  -140.191    60.772
  -139.453    60.111
>
  -141.142    60.440
  -139.453    60.111
>
  -141.346    60.300
  -139.453    60.111
>
  -141.346    60.300
  -139.453    60.111
>
  -137.738    59.630
  -139.453    60.111
>
  -137.738    59.630
  -139.453    60.111
>
  -138.363    60.943
  -139.453    60.111
>
  -138.363    60.943
  -139.453    60.111
>
  -138.363    60.943
  -139.453    60.111
>
  -141.003    60.825
  -139.453    60.111
>
  -141.003    60.825
  -139.453    60.111
>
  -139.397    59.669
  -139.595    59.979
>
  -140.257    60.097
  -139.595    59.979
>
  -140.257    60.097
  -139.595    59.979
>
  -138.576    60.302
  -139.595    59.979
>
  -138.576    60.302
  -139.595    59.979
>
  -140.191    60.772
  -139.595    59.979
>
  -140.191    60.772
  -139.595    59.979
>
  -140.191    60.772
  -139.595    59.979
>
  -141.346    60.300
  -139.595    59.979
>
  -138.140    60.531
  -139.595    59.979
>
  -137.738    59.630
  -139.595    59.979
>
  -137.738    59.630
  -139.595    59.979
>
  -141.003    60.825
  -139.595    59.979
>
  -139.635    59.953
  -139.110    59.977
>
  -139.635    59.953
  -139.110    59.977
>
  -139.397    59.669
  -139.110    59.977
>
  -139.397    59.669
  -139.110    59.977
>
  -139.397    59.669
  -139.110    59.977
>
  -138.576    60.302
  -139.110    59.977
>
  -138.576    60.302
  -139.110    59.977
>
  -138.576    60.302
  -139.110    59.977
>
  -138.576    60.302
  -139.110    59.977
>
  -139.671    59.512
  -139.110    59.977
>
  -140.257    60.097
  -139.110    59.977
>
  -140.257    60.097
  -139.110    59.977
>
  -140.257    60.097
  -139.110    59.977
>
  -140.257    60.097
  -139.110    59.977
>
  -140.257    60.097
  -139.110    59.977
>
  -140.257    60.097
  -139.110    59.977
>
  -138.140    60.531
  -139.110    59.977
>
  -138.140    60.531
  -139.110    59.977
>
  -137.738    59.630
  -139.110    59.977
>
  -137.738    59.630
  -139.110    59.977
>
  -137.738    59.630
  -139.110    59.977
>
  -137.738    59.630
  -139.110    59.977
>
  -137.738    59.630
  -139.110    59.977
>
  -140.781    60.130
  -139.110    59.977
>
  -140.781    60.130
  -139.110    59.977
>
  -140.191    60.772
  -139.110    59.977
>
  -140.191    60.772
  -139.110    59.977
>
  -140.191    60.772
  -139.110    59.977
>
  -140.191    60.772
  -139.110    59.977
>
  -141.117    60.063
  -139.110    59.977
>
  -138.363    60.943
  -139.110    59.977
>
  -138.363    60.943
  -139.110    59.977
>
  -138.363    60.943
  -139.110    59.977
>
  -138.363    60.943
  -139.110    59.977
>
  -136.960    60.122
  -139.110    59.977
>
  -136.960    60.122
  -139.110    59.977
>
  -136.960    60.122
  -139.110    59.977
>
  -136.960    60.122
  -139.110    59.977
>
  -136.960    60.122
  -139.110    59.977
>
  -136.960    60.122
  -139.110    59.977
>
  -139.635    59.953
  -139.642    60.254
>
  -139.635    59.953
  -139.642    60.254
>
  -140.257    60.097
  -139.642    60.254
>
  -140.257    60.097
  -139.642    60.254
>
  -140.257    60.097
  -139.642    60.254
>
  -140.257    60.097
  -139.642    60.254
>
  -138.576    60.302
  -139.642    60.254
>
  -138.576    60.302
  -139.642    60.254
>
  -138.576    60.302
  -139.642    60.254
>
  -140.781    60.130
  -139.642    60.254
>
  -140.191    60.772
  -139.642    60.254
>
  -140.191    60.772
  -139.642    60.254
>
  -139.397    59.669
  -139.642    60.254
>
  -139.397    59.669
  -139.642    60.254
>
  -141.117    60.063
  -139.642    60.254
>
  -139.671    59.512
  -139.642    60.254
>
  -141.142    60.440
  -139.642    60.254
>
  -138.140    60.531
  -139.642    60.254
>
  -138.140    60.531
  -139.642    60.254
>
  -141.346    60.300
  -139.642    60.254
>
  -141.003    60.825
  -139.642    60.254
>
  -138.363    60.943
  -139.642    60.254
>
  -138.363    60.943
  -139.642    60.254
>
  -139.765    61.284
  -139.642    60.254
>
  -139.765    61.284
  -139.642    60.254
>
  -139.765    61.284
  -139.642    60.254
>
  -141.745    60.363
  -139.642    60.254
>
  -141.333    60.965
  -139.642    60.254
>
  -139.397    59.669
  -139.226    60.009
>
  -139.397    59.669
  -139.226    60.009
>
  -138.576    60.302
  -139.226    60.009
>
  -138.576    60.302
  -139.226    60.009
>
  -138.576    60.302
  -139.226    60.009
>
  -138.576    60.302
  -139.226    60.009
>
  -140.257    60.097
  -139.226    60.009
>
  -140.257    60.097
  -139.226    60.009
>
  -140.257    60.097
  -139.226    60.009
>
  -140.257    60.097
  -139.226    60.009
>
  -138.140    60.531
  -139.226    60.009
>
  -138.140    60.531
  -139.226    60.009
>
  -137.738    59.630
  -139.226    60.009
>
  -137.738    59.630
  -139.226    60.009
>
  -137.738    59.630
  -139.226    60.009
>
  -137.738    59.630
  -139.226    60.009
>
  -140.781    60.130
  -139.226    60.009
>
  -140.781    60.130
  -139.226    60.009
>
  -140.191    60.772
  -139.226    60.009
>
  -140.191    60.772
  -139.226    60.009
>
  -138.363    60.943
  -139.226    60.009
>
  -138.363    60.943
  -139.226    60.009
>
  -138.363    60.943
  -139.226    60.009
>
  -138.363    60.943
  -139.226    60.009
>
  -141.142    60.440
  -139.226    60.009
>
  -141.142    60.440
  -139.226    60.009
>
  -141.346    60.300
  -139.226    60.009
>
  -141.346    60.300
  -139.226    60.009
>
  -140.257    60.097
  -139.557    60.400
>
  -140.257    60.097
  -139.557    60.400
>
  -140.257    60.097
  -139.557    60.400
>
  -140.257    60.097
  -139.557    60.400
>
  -140.191    60.772
  -139.557    60.400
>
  -140.191    60.772
  -139.557    60.400
>
  -140.191    60.772
  -139.557    60.400
>
  -140.191    60.772
  -139.557    60.400
>
  -138.576    60.302
  -139.557    60.400
>
  -138.576    60.302
  -139.557    60.400
>
  -138.576    60.302
  -139.557    60.400
>
  -138.576    60.302
  -139.557    60.400
>
  -140.781    60.130
  -139.557    60.400
>
  -139.397    59.669
  -139.557    60.400
>
  -139.397    59.669
  -139.557    60.400
>
  -138.140    60.531
  -139.557    60.400
>
  -138.140    60.531
  -139.557    60.400
>
  -141.142    60.440
  -139.557    60.400
>
  -141.003    60.825
  -139.557    60.400
>
  -141.003    60.825
  -139.557    60.400
>
  -138.363    60.943
  -139.557    60.400
>
  -138.363    60.943
  -139.557    60.400
>
  -138.363    60.943
  -139.557    60.400
>
  -141.346    60.300
  -139.557    60.400
>
  -139.765    61.284
  -139.557    60.400
>
  -139.765    61.284
  -139.557    60.400
>
  -139.765    61.284
  -139.557    60.400
>
  -141.333    60.965
  -139.557    60.400
>
  -141.333    60.965
  -139.557    60.400
>
  -141.340    60.965
  -139.557    60.400
>
  -141.340    60.965
  -139.557    60.400
>
  -139.034    61.370
  -139.557    60.400
>
  -137.504    60.825
  -139.557    60.400
>
  -137.504    60.825
  -139.557    60.400
>
  -137.504    60.825
  -139.557    60.400
>
  -139.635    59.953
  -139.174    60.011
>
  -138.576    60.302
  -139.174    60.011
>
  -138.576    60.302
  -139.174    60.011
>
  -138.576    60.302
  -139.174    60.011
>
  -140.257    60.097
  -139.174    60.011
>
  -140.257    60.097
  -139.174    60.011
>
  -140.257    60.097
  -139.174    60.011
>
  -140.257    60.097
  -139.174    60.011
>
  -140.257    60.097
  -139.174    60.011
>
  -139.671    59.512
  -139.174    60.011
>
  -138.140    60.531
  -139.174    60.011
>
  -138.140    60.531
  -139.174    60.011
>
  -138.140    60.531
  -139.174    60.011
>
  -140.191    60.772
  -139.174    60.011
>
  -140.191    60.772
  -139.174    60.011
>
  -140.191    60.772
  -139.174    60.011
>
  -140.191    60.772
  -139.174    60.011
>
  -140.191    60.772
  -139.174    60.011
>
  -138.363    60.943
  -139.174    60.011
>
  -138.363    60.943
  -139.174    60.011
>
  -138.363    60.943
  -139.174    60.011
>
  -141.142    60.440
  -139.174    60.011
>
  -141.142    60.440
  -139.174    60.011
>
  -141.142    60.440
  -139.174    60.011
>
  -140.257    60.097
  -139.865    60.275
>
  -140.257    60.097
  -139.865    60.275
>
  -140.257    60.097
  -139.865    60.275
>
  -139.635    59.953
  -139.865    60.275
>
  -139.635    59.953
  -139.865    60.275
>
  -140.191    60.772
  -139.865    60.275
>
  -140.191    60.772
  -139.865    60.275
>
  -140.191    60.772
  -139.865    60.275
>
  -138.576    60.302
  -139.865    60.275
>
  -138.576    60.302
  -139.865    60.275
>
  -138.576    60.302
  -139.865    60.275
>
  -139.671    59.512
  -139.865    60.275
>
  -139.671    59.512
  -139.865    60.275
>
  -141.346    60.300
  -139.865    60.275
>
  -141.346    60.300
  -139.865    60.275
>
  -141.346    60.300
  -139.865    60.275
>
  -141.003    60.825
  -139.865    60.275
>
  -141.003    60.825
  -139.865    60.275
>
  -141.003    60.825
  -139.865    60.275
>
  -141.003    60.825
  -139.865    60.275
>
  -138.140    60.531
  -139.865    60.275
>
  -138.140    60.531
  -139.865    60.275
>
  -141.949    60.179
  -139.865    60.275
>
  -141.949    60.179
  -139.865    60.275
>
  -141.949    60.179
  -139.865    60.275
>
  -141.333    60.965
  -139.865    60.275
>
  -141.333    60.965
  -139.865    60.275
>
  -141.754    60.732
  -139.865    60.275
>
  -141.754    60.732
  -139.865    60.275
>
  -141.754    60.732
  -139.865    60.275
>
  -138.363    60.943
  -139.865    60.275
>
  -138.363    60.943
  -139.865    60.275
>
  -139.765    61.284
  -139.865    60.275
>
  -139.765    61.284
  -139.865    60.275
>
  -140.257    60.097
  -139.590    60.203
>
  -140.257    60.097
  -139.590    60.203
>
  -140.257    60.097
  -139.590    60.203
>
  -140.257    60.097
  -139.590    60.203
>
  -138.576    60.302
  -139.590    60.203
>
  -138.576    60.302
  -139.590    60.203
>
  -138.576    60.302
  -139.590    60.203
>
  -140.191    60.772
  -139.590    60.203
>
  -140.191    60.772
  -139.590    60.203
>
  -140.191    60.772
  -139.590    60.203
>
  -139.671    59.512
  -139.590    60.203
>
  -139.671    59.512
  -139.590    60.203
>
  -138.140    60.531
  -139.590    60.203
>
  -138.140    60.531
  -139.590    60.203
>
  -141.346    60.300
  -139.590    60.203
>
  -141.346    60.300
  -139.590    60.203
>
  -141.003    60.825
  -139.590    60.203
>
  -138.363    60.943
  -139.590    60.203
>
  -138.363    60.943
  -139.590    60.203
>
  -138.363    60.943
  -139.590    60.203
>
  -139.765    61.284
  -139.590    60.203
>
  -139.765    61.284
  -139.590    60.203
>
  -139.765    61.284
  -139.590    60.203
>
  -140.257    60.097
  -139.567    60.220
>
  -140.257    60.097
  -139.567    60.220
>
  -140.257    60.097
  -139.567    60.220
>
  -140.257    60.097
  -139.567    60.220
>
  -138.576    60.302
  -139.567    60.220
>
  -138.576    60.302
  -139.567    60.220
>
  -140.191    60.772
  -139.567    60.220
>
  -140.191    60.772
  -139.567    60.220
>
  -139.671    59.512
  -139.567    60.220
>
  -138.140    60.531
  -139.567    60.220
>
  -138.140    60.531
  -139.567    60.220
>
  -141.346    60.300
  -139.567    60.220
>
  -141.346    60.300
  -139.567    60.220
>
  -138.363    60.943
  -139.567    60.220
>
  -138.363    60.943
  -139.567    60.220
>
  -138.363    60.943
  -139.567    60.220
>
  -141.003    60.825
  -139.567    60.220
>
  -141.003    60.825
  -139.567    60.220
>
  -139.765    61.284
  -139.567    60.220
>
  -139.765    61.284
  -139.567    60.220
>
  -137.738    59.630
  -139.567    60.220
>
  -137.738    59.630
  -139.567    60.220
>
  -137.738    59.630
  -139.567    60.220
>
  -137.738    59.630
  -139.567    60.220
>
  -139.397    59.669
  -139.242    59.976
>
  -139.397    59.669
  -139.242    59.976
>
  -139.397    59.669
  -139.242    59.976
>
  -138.576    60.302
  -139.242    59.976
>
  -138.576    60.302
  -139.242    59.976
>
  -140.257    60.097
  -139.242    59.976
>
  -140.257    60.097
  -139.242    59.976
>
  -140.257    60.097
  -139.242    59.976
>
  -140.257    60.097
  -139.242    59.976
>
  -138.140    60.531
  -139.242    59.976
>
  -138.140    60.531
  -139.242    59.976
>
  -140.781    60.130
  -139.242    59.976
>
  -140.781    60.130
  -139.242    59.976
>
  -140.781    60.130
  -139.242    59.976
>
  -140.191    60.772
  -139.242    59.976
>
  -140.191    60.772
  -139.242    59.976
>
  -140.191    60.772
  -139.242    59.976
>
  -140.191    60.772
  -139.242    59.976
>
  -141.117    60.063
  -139.242    59.976
>
  -138.363    60.943
  -139.242    59.976
>
  -138.576    60.302
  -139.011    60.457
>
  -138.576    60.302
  -139.011    60.457
>
  -138.140    60.531
  -139.011    60.457
>
  -139.635    59.953
  -139.011    60.457
>
  -139.635    59.953
  -139.011    60.457
>
  -138.363    60.943
  -139.011    60.457
>
  -138.363    60.943
  -139.011    60.457
>
  -140.191    60.772
  -139.011    60.457
>
  -140.191    60.772
  -139.011    60.457
>
  -140.257    60.097
  -139.011    60.457
>
  -139.397    59.669
  -139.011    60.457
>
  -137.504    60.825
  -139.011    60.457
>
  -137.504    60.825
  -139.011    60.457
>
  -140.781    60.130
  -139.011    60.457
>
  -137.859    61.131
  -139.011    60.457
>
  -137.859    61.131
  -139.011    60.457
>
  -139.765    61.284
  -139.011    60.457
>
  -139.765    61.284
  -139.011    60.457
>
  -139.034    61.370
  -139.011    60.457
>
  -139.034    61.370
  -139.011    60.457
>
  -137.738    59.630
  -139.011    60.457
>
  -141.003    60.825
  -139.011    60.457
>
  -136.960    60.122
  -139.011    60.457
>
  -140.257    60.097
  -139.499    60.161
>
  -140.257    60.097
  -139.499    60.161
>
  -139.397    59.669
  -139.499    60.161
>
  -138.576    60.302
  -139.499    60.161
>
  -138.576    60.302
  -139.499    60.161
>
  -140.191    60.772
  -139.499    60.161
>
  -140.191    60.772
  -139.499    60.161
>
  -138.140    60.531
  -139.499    60.161
>
  -138.140    60.531
  -139.499    60.161
>
  -141.142    60.440
  -139.499    60.161
>
  -141.346    60.300
  -139.499    60.161
>
  -141.346    60.300
  -139.499    60.161
>
  -138.363    60.943
  -139.499    60.161
>
  -138.363    60.943
  -139.499    60.161
>
  -141.003    60.825
  -139.499    60.161
>
  -141.003    60.825
  -139.499    60.161
>
  -139.397    59.669
  -139.274    60.038
>
  -139.397    59.669
  -139.274    60.038
>
  -138.576    60.302
  -139.274    60.038
>
  -138.576    60.302
  -139.274    60.038
>
  -140.257    60.097
  -139.274    60.038
>
  -140.257    60.097
  -139.274    60.038
>
  -140.781    60.130
  -139.274    60.038
>
  -140.781    60.130
  -139.274    60.038
>
  -138.140    60.531
  -139.274    60.038
>
  -138.140    60.531
  -139.274    60.038
>
  -140.191    60.772
  -139.274    60.038
>
  -140.191    60.772
  -139.274    60.038
>
  -141.142    60.440
  -139.274    60.038
>
  -141.142    60.440
  -139.274    60.038
>
  -138.363    60.943
  -139.274    60.038
>
  -138.363    60.943
  -139.274    60.038
>
  -141.346    60.300
  -139.274    60.038
>
  -141.346    60.300
  -139.274    60.038
>
  -140.257    60.097
  -139.831    60.443
>
  -140.257    60.097
  -139.831    60.443
>
  -140.253    60.096
  -139.831    60.443
>
  -140.253    60.096
  -139.831    60.443
>
  -140.781    60.130
  -139.831    60.443
>
  -140.781    60.130
  -139.831    60.443
>
  -141.142    60.440
  -139.831    60.443
>
  -141.142    60.440
  -139.831    60.443
>
  -141.003    60.825
  -139.831    60.443
>
  -141.003    60.825
  -139.831    60.443
>
  -141.003    60.825
  -139.831    60.443
>
  -141.346    60.300
  -139.831    60.443
>
  -139.397    59.669
  -139.831    60.443
>
  -139.397    59.669
  -139.831    60.443
>
  -139.765    61.284
  -139.831    60.443
>
  -139.765    61.284
  -139.831    60.443
>
  -138.140    60.531
  -139.831    60.443
>
  -138.140    60.531
  -139.831    60.443
>
  -138.363    60.943
  -139.831    60.443
>
  -141.754    60.732
  -139.831    60.443
>
  -141.754    60.732
  -139.831    60.443
>
  -141.949    60.179
  -139.831    60.443
>
  -141.949    60.179
  -139.831    60.443
>
  -139.034    61.370
  -139.831    60.443
>
  -139.034    61.370
  -139.831    60.443
>
  -141.660    61.060
  -139.831    60.443
>
  -140.253    60.096
  -139.852    60.156
>
  -140.253    60.096
  -139.852    60.156
>
  -140.781    60.130
  -139.852    60.156
>
  -140.781    60.130
  -139.852    60.156
>
  -139.397    59.669
  -139.852    60.156
>
  -139.397    59.669
  -139.852    60.156
>
  -141.117    60.063
  -139.852    60.156
>
  -141.117    60.063
  -139.852    60.156
>
  -141.142    60.440
  -139.852    60.156
>
  -141.346    60.300
  -139.852    60.156
>
  -141.346    60.300
  -139.852    60.156
>
  -141.745    60.363
  -139.852    60.156
>
  -141.745    60.363
  -139.852    60.156
>
  -141.949    60.179
  -139.852    60.156
>
  -141.949    60.179
  -139.852    60.156
>
  -140.253    60.096
  -139.450    60.098
>
  -140.257    60.097
  -139.450    60.098
>
  -139.397    59.669
  -139.450    60.098
>
  -140.781    60.130
  -139.450    60.098
>
  -141.142    60.440
  -139.450    60.098
>
  -141.142    60.440
  -139.450    60.098
>
  -141.142    60.440
  -139.450    60.098
>
  -141.142    60.440
  -139.450    60.098
>
  -141.346    60.300
  -139.450    60.098
>
  -141.346    60.300
  -139.450    60.098
>
  -141.346    60.300
  -139.450    60.098
>
  -138.363    60.943
  -139.450    60.098
>
  -138.363    60.943
  -139.450    60.098
>
  -141.003    60.825
  -139.450    60.098
>
  -141.003    60.825
  -139.450    60.098
>
  -141.003    60.825
  -139.450    60.098
>
  -141.003    60.825
  -139.450    60.098
>
  -140.253    60.096
  -139.428    60.107
>
  -140.253    60.096
  -139.428    60.107
>
  -140.257    60.097
  -139.428    60.107
>
  -139.397    59.669
  -139.428    60.107
>
  -140.781    60.130
  -139.428    60.107
>
  -140.781    60.130
  -139.428    60.107
>
  -141.142    60.440
  -139.428    60.107
>
  -141.142    60.440
  -139.428    60.107
>
  -141.142    60.440
  -139.428    60.107
>
  -141.142    60.440
  -139.428    60.107
>
  -141.346    60.300
  -139.428    60.107
>
  -141.346    60.300
  -139.428    60.107
>
  -141.346    60.300
  -139.428    60.107
>
  -138.363    60.943
  -139.428    60.107
>
  -141.003    60.825
  -139.428    60.107
>
  -141.003    60.825
  -139.428    60.107
>
  -141.003    60.825
  -139.428    60.107
>
  -141.003    60.825
  -139.428    60.107
>
  -140.781    60.130
  -139.800    60.315
>
  -140.781    60.130
  -139.800    60.315
>
  -140.781    60.130
  -139.800    60.315
>
  -141.142    60.440
  -139.800    60.315
>
  -141.142    60.440
  -139.800    60.315
>
  -139.397    59.669
  -139.800    60.315
>
  -139.397    59.669
  -139.800    60.315
>
  -141.346    60.300
  -139.800    60.315
>
  -141.346    60.300
  -139.800    60.315
>
  -141.346    60.300
  -139.800    60.315
>
  -141.003    60.825
  -139.800    60.315
>
  -141.003    60.825
  -139.800    60.315
>
  -141.003    60.825
  -139.800    60.315
>
  -139.671    59.512
  -139.800    60.315
>
  -138.140    60.531
  -139.800    60.315
>
  -138.363    60.943
  -139.800    60.315
>
  -138.363    60.943
  -139.800    60.315
>
  -139.765    61.284
  -139.800    60.315
>
  -139.765    61.284
  -139.800    60.315
>
  -141.754    60.732
  -139.800    60.315
>
  -141.754    60.732
  -139.800    60.315
>
  -141.949    60.179
  -139.800    60.315
>
  -141.949    60.179
  -139.800    60.315
>
  -139.397    59.669
  -139.246    59.918
>
  -139.397    59.669
  -139.246    59.918
>
  -139.671    59.512
  -139.246    59.918
>
  -140.781    60.130
  -139.246    59.918
>
  -140.781    60.130
  -139.246    59.918
>
  -138.140    60.531
  -139.246    59.918
>
  -138.140    60.531
  -139.246    59.918
>
  -138.140    60.531
  -139.246    59.918
>
  -141.142    60.440
  -139.246    59.918
>
  -141.142    60.440
  -139.246    59.918
>
  -141.142    60.440
  -139.246    59.918
>
  -141.142    60.440
  -139.246    59.918
>
  -139.397    59.669
  -139.115    60.467
>
  -139.397    59.669
  -139.115    60.467
>
  -139.034    61.370
  -139.115    60.467
>
  -139.034    61.370
  -139.115    60.467
>
  -141.003    60.825
  -139.115    60.467
>
  -141.003    60.825
  -139.115    60.467
>
  -139.397    59.669
  -139.835    60.340
>
  -139.397    59.669
  -139.835    60.340
>
  -141.003    60.825
  -139.835    60.340
>
  -141.003    60.825
  -139.835    60.340
>
  -141.003    60.825
  -139.835    60.340
>
  -141.003    60.825
  -139.835    60.340
>
  -138.140    60.531
  -139.835    60.340
>
  -138.140    60.531
  -139.835    60.340
>
  -138.363    60.943
  -139.835    60.340
>
  -138.363    60.943
  -139.835    60.340
>
  -138.363    60.943
  -139.835    60.340
>
  -139.765    61.284
  -139.835    60.340
>
  -139.765    61.284
  -139.835    60.340
>
  -139.765    61.284
  -139.835    60.340
>
  -141.754    60.732
  -139.835    60.340
>
  -139.397    59.669
  -139.650    60.245
>
  -139.397    59.669
  -139.650    60.245
>
  -138.140    60.531
  -139.650    60.245
>
  -138.140    60.531
  -139.650    60.245
>
  -141.003    60.825
  -139.650    60.245
>
  -141.003    60.825
  -139.650    60.245
>
  -138.363    60.943
  -139.650    60.245
>
  -138.363    60.943
  -139.650    60.245
>
  -139.765    61.284
  -139.650    60.245
>
  -139.765    61.284
  -139.650    60.245
>
  -139.397    59.669
  -139.631    60.240
>
  -139.397    59.669
  -139.631    60.240
>
  -138.140    60.531
  -139.631    60.240
>
  -138.140    60.531
  -139.631    60.240
>
  -141.003    60.825
  -139.631    60.240
>
  -141.003    60.825
  -139.631    60.240
>
  -138.363    60.943
  -139.631    60.240
>
  -138.363    60.943
  -139.631    60.240
>
  -139.765    61.284
  -139.631    60.240
>
  -139.765    61.284
  -139.631    60.240
>
  -139.397    59.669
  -139.495    59.955
>
  -139.397    59.669
  -139.495    59.955
>
  -139.397    59.669
  -139.495    59.955
>
  -138.140    60.531
  -139.495    59.955
>
  -138.140    60.531
  -139.495    59.955
>
  -138.140    60.531
  -139.495    59.955
>
  -139.397    59.669
  -139.930    60.084
>
  -139.397    59.669
  -139.930    60.084
>
  -141.003    60.825
  -139.930    60.084
>
  -141.003    60.825
  -139.930    60.084
>
  -141.003    60.825
  -139.930    60.084
>
  -141.003    60.825
  -139.930    60.084
>
  -138.140    60.531
  -139.930    60.084
>
  -138.140    60.531
  -139.930    60.084
>
  -139.637    59.953
  -139.699    60.201
>
  -140.253    60.096
  -139.699    60.201
>
  -139.397    59.669
  -139.699    60.201
>
  -140.781    60.130
  -139.699    60.201
>
  -141.346    60.300
  -139.699    60.201
>
  -138.140    60.531
  -139.699    60.201
>
  -138.363    60.943
  -139.699    60.201
>
  -139.765    61.284
  -139.699    60.201
>
  -140.253    60.096
  -139.464    60.136
>
  -140.253    60.096
  -139.464    60.136
>
  -140.257    60.097
  -139.464    60.136
>
  -140.257    60.097
  -139.464    60.136
>
  -139.397    59.669
  -139.464    60.136
>
  -140.781    60.130
  -139.464    60.136
>
  -141.346    60.300
  -139.464    60.136
>
  -141.346    60.300
  -139.464    60.136
>
  -141.003    60.825
  -139.464    60.136
>
  -141.003    60.825
  -139.464    60.136
>
  -141.003    60.825
  -139.464    60.136
>
  -141.003    60.825
  -139.464    60.136
>
  -139.397    59.669
  -139.269    60.078
>
  -139.397    59.669
  -139.269    60.078
>
  -139.397    59.669
  -139.269    60.078
>
  -139.397    59.669
  -139.269    60.078
>
  -140.253    60.096
  -139.269    60.078
>
  -140.253    60.096
  -139.269    60.078
>
  -140.257    60.097
  -139.269    60.078
>
  -140.257    60.097
  -139.269    60.078
>
  -140.781    60.130
  -139.269    60.078
>
  -140.781    60.130
  -139.269    60.078
>
  -138.363    60.943
  -139.269    60.078
>
  -138.363    60.943
  -139.269    60.078
>
  -138.363    60.943
  -139.269    60.078
>
  -141.346    60.300
  -139.269    60.078
>
  -141.346    60.300
  -139.269    60.078
>
  -139.397    59.669
  -139.261    60.079
>
  -139.397    59.669
  -139.261    60.079
>
  -139.397    59.669
  -139.261    60.079
>
  -139.397    59.669
  -139.261    60.079
>
  -140.253    60.096
  -139.261    60.079
>
  -140.253    60.096
  -139.261    60.079
>
  -140.257    60.097
  -139.261    60.079
>
  -140.257    60.097
  -139.261    60.079
>
  -140.781    60.130
  -139.261    60.079
>
  -140.781    60.130
  -139.261    60.079
>
  -140.781    60.130
  -139.261    60.079
>
  -140.781    60.130
  -139.261    60.079
>
  -138.363    60.943
  -139.261    60.079
>
  -138.363    60.943
  -139.261    60.079
>
  -138.363    60.943
  -139.261    60.079
>
  -141.346    60.300
  -139.261    60.079
>
  -141.346    60.300
  -139.261    60.079
>
  -141.346    60.300
  -139.261    60.079
>
  -141.346    60.300
  -139.261    60.079
>
  -140.253    60.096
  -139.481    60.410
>
  -140.253    60.096
  -139.481    60.410
>
  -139.397    59.669
  -139.481    60.410
>
  -141.003    60.825
  -139.481    60.410
>
  -141.346    60.300
  -139.481    60.410
>
  -139.034    61.370
  -139.481    60.410
>
  -137.504    60.825
  -139.481    60.410
>
  -140.253    60.096
  -139.410    60.307
>
  -139.397    59.669
  -139.410    60.307
>
  -141.346    60.300
  -139.410    60.307
>
  -141.346    60.300
  -139.410    60.307
>
  -140.253    60.096
  -139.467    60.419
>
  -139.397    59.669
  -139.467    60.419
>
  -139.397    59.669
  -139.467    60.419
>
  -141.003    60.825
  -139.467    60.419
>
  -141.003    60.825
  -139.467    60.419
>
  -141.346    60.300
  -139.467    60.419
>
  -139.034    61.370
  -139.467    60.419
>
  -137.504    60.825
  -139.467    60.419
>
  -140.253    60.096
  -139.454    60.378
>
  -141.003    60.825
  -139.454    60.378
>
  -141.346    60.300
  -139.454    60.378
>
  -141.346    60.300
  -139.454    60.378
>
  -140.253    60.096
  -139.760    60.562
>
  -141.003    60.825
  -139.760    60.562
>
  -141.003    60.825
  -139.760    60.562
>
  -141.346    60.300
  -139.760    60.562
>
  -141.346    60.300
  -139.760    60.562
>
  -139.397    59.669
  -139.760    60.562
>
  -139.397    59.669
  -139.760    60.562
>
  -139.034    61.370
  -139.760    60.562
>
  -141.754    60.732
  -139.760    60.562
>
  -140.253    60.096
  -139.355    60.402
>
  -139.397    59.669
  -139.355    60.402
>
  -139.397    59.669
  -139.355    60.402
>
  -141.003    60.825
  -139.355    60.402
>
  -141.003    60.825
  -139.355    60.402
>
  -141.346    60.300
  -139.355    60.402
>
  -141.346    60.300
  -139.355    60.402
>
  -139.034    61.370
  -139.355    60.402
>
  -139.034    61.370
  -139.355    60.402
>
  -137.504    60.825
  -139.355    60.402
>
  -137.504    60.825
  -139.355    60.402
>
  -140.253    60.096
  -139.870    60.534
>
  -140.253    60.096
  -139.870    60.534
>
  -141.003    60.825
  -139.870    60.534
>
  -141.003    60.825
  -139.870    60.534
>
  -141.346    60.300
  -139.870    60.534
>
  -139.397    59.669
  -139.870    60.534
>
  -139.397    59.669
  -139.870    60.534
>
  -141.754    60.732
  -139.870    60.534
>
  -141.754    60.732
  -139.870    60.534
>
  -141.949    60.179
  -139.870    60.534
>
  -142.089    60.490
  -139.870    60.534
>
  -140.253    60.096
  -139.860    60.520
>
  -140.253    60.096
  -139.860    60.520
>
  -141.754    60.732
  -139.860    60.520
>
  -141.949    60.179
  -139.860    60.520
>
  -140.253    60.096
  -139.862    60.524
>
  -140.253    60.096
  -139.862    60.524
>
  -141.003    60.825
  -139.862    60.524
>
  -141.949    60.179
  -139.862    60.524
>
  -141.949    60.179
  -139.862    60.524
>
  -140.253    60.096
  -140.071    60.586
>
  -141.003    60.825
  -140.071    60.586
>
  -141.003    60.825
  -140.071    60.586
>
  -141.346    60.300
  -140.071    60.586
>
  -141.754    60.732
  -140.071    60.586
>
  -141.754    60.732
  -140.071    60.586
>
  -142.089    60.490
  -140.071    60.586
>
  -142.089    60.490
  -140.071    60.586
>
  -141.949    60.179
  -140.071    60.586
>
  -141.949    60.179
  -140.071    60.586
>
  -140.253    60.096
  -139.856    60.525
>
  -140.253    60.096
  -139.856    60.525
>
  -141.003    60.825
  -139.856    60.525
>
  -141.003    60.825
  -139.856    60.525
>
  -141.346    60.300
  -139.856    60.525
>
  -139.397    59.669
  -139.856    60.525
>
  -141.754    60.732
  -139.856    60.525
>
  -141.949    60.179
  -139.856    60.525
>
  -141.949    60.179
  -139.856    60.525
>
  -140.253    60.096
  -139.556    60.453
>
  -140.253    60.096
  -139.556    60.453
>
  -141.003    60.825
  -139.556    60.453
>
  -141.003    60.825
  -139.556    60.453
>
  -140.253    60.096
  -139.579    60.486
>
  -140.253    60.096
  -139.579    60.486
>
  -141.003    60.825
  -139.579    60.486
>
  -141.003    60.825
  -139.579    60.486
>
  -139.397    59.669
  -139.579    60.486
>
  -139.397    59.669
  -139.579    60.486
>
  -141.346    60.300
  -139.579    60.486
>
  -141.346    60.300
  -139.579    60.486
>
  -139.034    61.370
  -139.579    60.486
>
  -139.034    61.370
  -139.579    60.486
>
  -137.504    60.825
  -139.579    60.486
>
  -137.504    60.825
  -139.579    60.486
>
  -140.253    60.096
  -139.733    60.571
>
  -140.253    60.096
  -139.733    60.571
>
  -141.003    60.825
  -139.733    60.571
>
  -141.003    60.825
  -139.733    60.571
>
  -140.253    60.096
  -139.464    60.425
>
  -140.253    60.096
  -139.464    60.425
>
  -139.397    59.669
  -139.464    60.425
>
  -139.397    59.669
  -139.464    60.425
>
  -141.003    60.825
  -139.464    60.425
>
  -141.003    60.825
  -139.464    60.425
>
  -141.346    60.300
  -139.464    60.425
>
  -139.034    61.370
  -139.464    60.425
>
  -137.504    60.825
  -139.464    60.425
>
  -137.504    60.825
  -139.464    60.425
>
  -140.253    60.096
  -139.953    60.585
>
  -140.253    60.096
  -139.953    60.585
>
  -141.003    60.825
  -139.953    60.585
>
  -141.003    60.825
  -139.953    60.585
>
  -141.346    60.300
  -139.953    60.585
>
  -139.034    61.370
  -139.953    60.585
>
  -139.397    59.669
  -139.953    60.585
>
  -139.397    59.669
  -139.953    60.585
>
  -141.949    60.179
  -139.953    60.585
>
  -140.253    60.096
  -139.927    60.550
>
  -140.253    60.096
  -139.927    60.550
>
  -141.003    60.825
  -139.927    60.550
>
  -141.346    60.300
  -139.927    60.550
>
  -141.754    60.732
  -139.927    60.550
>
  -139.397    59.669
  -139.927    60.550
>
  -139.034    61.370
  -139.927    60.550
>
  -141.949    60.179
  -139.927    60.550
>
  -140.253    60.096
  -139.446    60.443
>
  -140.253    60.096
  -139.446    60.443
>
  -139.397    59.669
  -139.446    60.443
>
  -139.397    59.669
  -139.446    60.443
>
  -141.003    60.825
  -139.446    60.443
>
  -141.003    60.825
  -139.446    60.443
>
  -141.346    60.300
  -139.446    60.443
>
  -141.346    60.300
  -139.446    60.443
>
  -137.504    60.825
  -139.446    60.443
>
  -137.504    60.825
  -139.446    60.443
>
  -140.253    60.096
  -139.993    60.555
>
  -140.253    60.096
  -139.993    60.555
>
  -141.003    60.825
  -139.993    60.555
>
  -141.003    60.825
  -139.993    60.555
>
  -141.346    60.300
  -139.993    60.555
>
  -141.346    60.300
  -139.993    60.555
>
  -141.754    60.732
  -139.993    60.555
>
  -141.754    60.732
  -139.993    60.555
>
  -139.397    59.669
  -139.993    60.555
>
  -139.397    59.669
  -139.993    60.555
>
  -139.034    61.370
  -139.993    60.555
>
  -139.034    61.370
  -139.993    60.555
>
  -142.089    60.490
  -139.993    60.555
>
  -142.089    60.490
  -139.993    60.555
>
  -141.949    60.179
  -139.993    60.555
>
  -141.949    60.179
  -139.993    60.555
>
  -140.253    60.096
  -139.886    60.638
>
  -140.253    60.096
  -139.886    60.638
>
  -141.003    60.825
  -139.886    60.638
>
  -141.003    60.825
  -139.886    60.638
>
  -141.346    60.300
  -139.886    60.638
>
  -139.034    61.370
  -139.886    60.638
>
  -139.034    61.370
  -139.886    60.638
>
  -141.754    60.732
  -139.886    60.638
>
  -141.754    60.732
  -139.886    60.638
>
  -139.397    59.669
  -139.886    60.638
>
  -139.397    59.669
  -139.886    60.638
>
  -142.089    60.490
  -139.886    60.638
>
  -141.003    60.825
  -139.933    60.592
>
  -140.253    60.096
  -139.933    60.592
>
  -140.253    60.096
  -139.933    60.592
>
  -141.949    60.179
  -139.933    60.592
>
  -140.253    60.096
  -139.843    60.543
>
  -140.253    60.096
  -139.843    60.543
>
  -141.003    60.825
  -139.843    60.543
>
  -141.003    60.825
  -139.843    60.543
>
  -141.346    60.300
  -139.843    60.543
>
  -139.397    59.669
  -139.843    60.543
>
  -140.253    60.096
  -139.442    60.417
>
  -140.253    60.096
  -139.442    60.417
>
  -139.397    59.669
  -139.442    60.417
>
  -139.397    59.669
  -139.442    60.417
>
  -141.003    60.825
  -139.442    60.417
>
  -141.003    60.825
  -139.442    60.417
>
  -141.346    60.300
  -139.442    60.417
>
  -139.034    61.370
  -139.442    60.417
>
  -139.034    61.370
  -139.442    60.417
>
  -137.504    60.825
  -139.442    60.417
>
  -140.253    60.096
  -139.913    60.529
>
  -140.253    60.096
  -139.913    60.529
>
  -141.003    60.825
  -139.913    60.529
>
  -141.003    60.825
  -139.913    60.529
>
  -141.949    60.179
  -139.913    60.529
>
  -141.949    60.179
  -139.913    60.529
>
  -140.253    60.096
  -139.919    60.556
>
  -140.253    60.096
  -139.919    60.556
>
  -141.003    60.825
  -139.919    60.556
>
  -141.003    60.825
  -139.919    60.556
>
  -141.949    60.179
  -139.919    60.556
>
  -140.253    60.096
  -139.905    60.546
>
  -141.003    60.825
  -139.905    60.546
>
  -141.003    60.825
  -139.905    60.546
>
  -141.346    60.300
  -139.905    60.546
>
  -141.754    60.732
  -139.905    60.546
>
  -141.754    60.732
  -139.905    60.546
>
  -139.034    61.370
  -139.905    60.546
>
  -139.034    61.370
  -139.905    60.546
>
  -141.949    60.179
  -139.905    60.546
>
  -141.949    60.179
  -139.905    60.546
>
  -140.253    60.096
  -139.696    60.591
>
  -140.253    60.096
  -139.696    60.591
>
  -141.003    60.825
  -139.696    60.591
>
  -141.346    60.300
  -139.696    60.591
>
  -141.346    60.300
  -139.696    60.591
>
  -139.397    59.669
  -139.696    60.591
>
  -141.754    60.732
  -139.696    60.591
>
  -141.754    60.732
  -139.696    60.591
>
  -139.034    61.370
  -139.696    60.591
>
  -139.034    61.370
  -139.696    60.591
>
  -140.253    60.096
  -139.458    60.413
>
  -140.253    60.096
  -139.458    60.413
>
  -141.003    60.825
  -139.458    60.413
>
  -141.003    60.825
  -139.458    60.413
>
  -139.034    61.370
  -139.458    60.413
>
  -139.034    61.370
  -139.458    60.413
>
  -141.346    60.300
  -139.458    60.413
>
  -137.504    60.825
  -139.458    60.413
>
  -137.504    60.825
  -139.458    60.413
>
  -140.253    60.096
  -139.865    60.570
>
  -141.003    60.825
  -139.865    60.570
>
  -141.003    60.825
  -139.865    60.570
>
  -141.346    60.300
  -139.865    60.570
>
  -139.034    61.370
  -139.865    60.570
>
  -139.034    61.370
  -139.865    60.570
>
  -141.754    60.732
  -139.865    60.570
>
  -141.754    60.732
  -139.865    60.570
>
  -139.397    59.669
  -139.865    60.570
>
  -139.397    59.669
  -139.865    60.570
>
  -140.253    60.096
  -139.818    60.608
>
  -141.003    60.825
  -139.818    60.608
>
  -139.034    61.370
  -139.818    60.608
>
  -140.253    60.096
  -139.607    60.494
>
  -140.253    60.096
  -139.607    60.494
>
  -141.003    60.825
  -139.607    60.494
>
  -141.003    60.825
  -139.607    60.494
>
  -139.397    59.669
  -139.607    60.494
>
  -141.346    60.300
  -139.607    60.494
>
  -141.346    60.300
  -139.607    60.494
>
  -139.034    61.370
  -139.607    60.494
>
  -139.034    61.370
  -139.607    60.494
>
  -141.754    60.732
  -139.607    60.494
>
  -141.754    60.732
  -139.607    60.494
>
  -137.504    60.825
  -139.607    60.494
>
  -140.253    60.096
  -139.583    60.492
>
  -140.253    60.096
  -139.583    60.492
>
  -141.003    60.825
  -139.583    60.492
>
  -141.003    60.825
  -139.583    60.492
>
  -139.397    59.669
  -139.583    60.492
>
  -139.397    59.669
  -139.583    60.492
>
  -141.346    60.300
  -139.583    60.492
>
  -139.034    61.370
  -139.583    60.492
>
  -139.034    61.370
  -139.583    60.492
>
  -141.754    60.732
  -139.583    60.492
>
  -141.754    60.732
  -139.583    60.492
>
  -137.504    60.825
  -139.583    60.492
>
  -137.504    60.825
  -139.583    60.492
>
  -140.253    60.096
  -139.892    60.526
>
  -140.253    60.096
  -139.892    60.526
>
  -141.003    60.825
  -139.892    60.526
>
  -141.003    60.825
  -139.892    60.526
>
  -139.397    59.669
  -139.892    60.526
>
  -139.397    59.669
  -139.892    60.526
>
  -139.034    61.370
  -139.892    60.526
>
  -141.949    60.179
  -139.892    60.526
>
  -141.949    60.179
  -139.892    60.526
>
  -141.949    60.179
  -139.892    60.526
>
  -141.949    60.179
  -139.892    60.526
>
  -140.253    60.096
  -139.939    60.505
>
  -140.253    60.096
  -139.939    60.505
>
  -141.003    60.825
  -139.939    60.505
>
  -141.003    60.825
  -139.939    60.505
>
  -141.949    60.179
  -139.939    60.505
>
  -141.949    60.179
  -139.939    60.505
>
  -140.253    60.096
  -139.541    60.391
>
  -140.253    60.096
  -139.541    60.391
>
  -141.003    60.825
  -139.541    60.391
>
  -141.003    60.825
  -139.541    60.391
>
  -141.346    60.300
  -139.541    60.391
>
  -140.253    60.096
  -139.488    60.420
>
  -140.253    60.096
  -139.488    60.420
>
  -139.397    59.669
  -139.488    60.420
>
  -141.003    60.825
  -139.488    60.420
>
  -141.003    60.825
  -139.488    60.420
>
  -141.346    60.300
  -139.488    60.420
>
  -141.346    60.300
  -139.488    60.420
>
  -139.034    61.370
  -139.488    60.420
>
  -137.504    60.825
  -139.488    60.420
>
  -140.253    60.096
  -139.943    60.562
>
  -140.253    60.096
  -139.943    60.562
>
  -141.003    60.825
  -139.943    60.562
>
  -141.003    60.825
  -139.943    60.562
>
  -141.346    60.300
  -139.943    60.562
>
  -141.754    60.732
  -139.943    60.562
>
  -141.754    60.732
  -139.943    60.562
>
  -139.397    59.669
  -139.943    60.562
>
  -139.397    59.669
  -139.943    60.562
>
  -139.034    61.370
  -139.943    60.562
>
  -139.034    61.370
  -139.943    60.562
>
  -141.949    60.179
  -139.943    60.562
>
  -141.949    60.179
  -139.943    60.562
>
  -140.253    60.096
  -139.824    60.567
>
  -140.253    60.096
  -139.824    60.567
>
  -141.003    60.825
  -139.824    60.567
>
  -141.003    60.825
  -139.824    60.567
>
  -141.346    60.300
  -139.824    60.567
>
  -139.397    59.669
  -139.824    60.567
>
  -139.397    59.669
  -139.824    60.567
>
  -139.034    61.370
  -139.824    60.567
>
  -139.034    61.370
  -139.824    60.567
>
  -141.754    60.732
  -139.824    60.567
>
  -140.253    60.096
  -139.552    60.449
>
  -140.253    60.096
  -139.552    60.449
>
  -139.397    59.669
  -139.552    60.449
>
  -139.397    59.669
  -139.552    60.449
>
  -141.003    60.825
  -139.552    60.449
>
  -141.003    60.825
  -139.552    60.449
>
  -141.346    60.300
  -139.552    60.449
>
  -139.034    61.370
  -139.552    60.449
>
  -137.504    60.825
  -139.552    60.449
>
  -137.504    60.825
  -139.552    60.449
>
  -140.253    60.096
  -139.360    60.401
>
  -140.253    60.096
  -139.360    60.401
>
  -139.397    59.669
  -139.360    60.401
>
  -139.397    59.669
  -139.360    60.401
>
  -141.003    60.825
  -139.360    60.401
>
  -141.003    60.825
  -139.360    60.401
>
  -141.346    60.300
  -139.360    60.401
>
  -141.346    60.300
  -139.360    60.401
>
  -139.034    61.370
  -139.360    60.401
>
  -137.504    60.825
  -139.360    60.401
>
  -137.504    60.825
  -139.360    60.401
>
  -140.253    60.096
  -139.885    60.629
>
  -141.003    60.825
  -139.885    60.629
>
  -140.253    60.096
  -139.873    60.627
>
  -140.253    60.096
  -139.873    60.627
>
  -141.003    60.825
  -139.873    60.627
>
  -141.003    60.825
  -139.873    60.627
>
  -141.346    60.300
  -139.873    60.627
>
  -141.754    60.732
  -139.873    60.627
>
  -139.034    61.370
  -139.873    60.627
>
  -139.034    61.370
  -139.873    60.627
>
  -139.397    59.669
  -139.873    60.627
>
  -140.253    60.096
  -139.856    60.604
>
  -140.253    60.096
  -139.856    60.604
>
  -141.003    60.825
  -139.856    60.604
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -139.729    59.553     0.300
  -140.257    60.097     0.300
  -139.397    59.669     0.300
  -138.877    59.452     0.300
  -139.635    59.953     0.300
  -137.504    60.825     0.300
  -141.117    60.063     0.300
  -141.745    60.363     0.300
  -141.333    60.965     0.300
  -139.671    59.512     0.300
  -140.781    60.130     0.300
  -141.142    60.440     0.300
  -141.346    60.300     0.300
  -141.003    60.825     0.300
  -138.140    60.531     0.300
  -141.949    60.179     0.300
  -138.363    60.943     0.300
  -140.257    60.097     0.300
  -138.576    60.302     0.300
  -140.191    60.772     0.300
  -137.738    59.630     0.300
  -139.765    61.284     0.300
  -141.340    60.965     0.300
  -141.754    60.732     0.300
  -136.960    60.122     0.300
  -139.034    61.370     0.300
  -137.859    61.131     0.300
  -140.253    60.096     0.300
  -141.660    61.060     0.300
  -139.637    59.953     0.300
  -142.089    60.490     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -139.519    60.100     0.200
>
  -139.629    60.117     0.200
>
  -139.443    60.130     0.200
>
  -139.463    60.128     0.200
>
  -139.210    60.143     0.200
>
  -139.378    60.071     0.200
>
  -139.402    60.096     0.200
>
  -139.409    60.106     0.200
>
  -139.652    60.241     0.200
>
  -139.167    59.912     0.200
>
  -139.585    60.167     0.200
>
  -139.055    59.980     0.200
>
  -139.692    60.263     0.200
>
  -139.600    60.243     0.200
>
  -139.591    60.235     0.200
>
  -139.425    60.183     0.200
>
  -139.419    60.131     0.200
>
  -139.297    59.993     0.200
>
  -139.365    60.172     0.200
>
  -139.844    60.092     0.200
>
  -139.634    60.184     0.200
>
  -139.739    60.228     0.200
>
  -139.369    60.139     0.200
>
  -139.391    60.123     0.200
>
  -139.387    60.133     0.200
>
  -139.373    60.154     0.200
>
  -139.396    60.171     0.200
>
  -139.535    60.336     0.200
>
  -139.376    60.135     0.200
>
  -139.486    60.135     0.200
>
  -139.833    60.056     0.200
>
  -139.542    60.205     0.200
>
  -139.658    60.184     0.200
>
  -139.577    60.200     0.200
>
  -139.188    60.224     0.200
>
  -139.619    60.243     0.200
>
  -139.422    60.098     0.200
>
  -139.636    60.190     0.200
>
  -139.436    60.120     0.200
>
  -139.478    60.044     0.200
>
  -139.391    60.099     0.200
>
  -139.419    60.072     0.200
>
  -139.436    60.206     0.200
>
  -139.525    60.164     0.200
>
  -139.196    60.225     0.200
>
  -139.531    60.183     0.200
>
  -139.555    60.163     0.200
>
  -139.554    60.250     0.200
>
  -139.584    60.242     0.200
>
  -139.407    60.123     0.200
>
  -139.508    60.140     0.200
>
  -139.452    60.109     0.200
>
  -139.505    60.155     0.200
>
  -139.576    60.441     0.200
>
  -139.564    60.227     0.200
>
  -139.770    60.212     0.200
>
  -139.383    60.114     0.200
>
  -139.152    59.902     0.200
>
  -139.782    60.319     0.200
>
  -139.645    60.307     0.200
>
  -139.373    59.977     0.200
>
  -139.475    60.115     0.200
>
  -139.366    59.978     0.200
>
  -139.366    59.987     0.200
>
  -139.370    59.982     0.200
>
  -139.794    60.296     0.200
>
  -139.453    60.111     0.200
>
  -139.595    59.979     0.200
>
  -139.110    59.977     0.200
>
  -139.642    60.254     0.200
>
  -139.226    60.009     0.200
>
  -139.557    60.400     0.200
>
  -139.174    60.011     0.200
>
  -139.865    60.275     0.200
>
  -139.590    60.203     0.200
>
  -139.567    60.220     0.200
>
  -139.242    59.976     0.200
>
  -139.011    60.457     0.200
>
  -139.499    60.161     0.200
>
  -139.274    60.038     0.200
>
  -139.831    60.443     0.200
>
  -139.852    60.156     0.200
>
  -139.450    60.098     0.200
>
  -139.428    60.107     0.200
>
  -139.800    60.315     0.200
>
  -139.246    59.918     0.200
>
  -139.115    60.467     0.200
>
  -139.835    60.340     0.200
>
  -139.650    60.245     0.200
>
  -139.631    60.240     0.200
>
  -139.495    59.955     0.200
>
  -139.930    60.084     0.200
>
  -139.699    60.201     0.200
>
  -139.464    60.136     0.200
>
  -139.269    60.078     0.200
>
  -139.261    60.079     0.200
>
  -139.481    60.410     0.200
>
  -139.410    60.307     0.200
>
  -139.467    60.419     0.200
>
  -139.454    60.378     0.200
>
  -139.760    60.562     0.200
>
  -139.355    60.402     0.200
>
  -139.870    60.534     0.200
>
  -139.860    60.520     0.200
>
  -139.862    60.524     0.200
>
  -140.071    60.586     0.200
>
  -139.856    60.525     0.200
>
  -139.556    60.453     0.200
>
  -139.579    60.486     0.200
>
  -139.733    60.571     0.200
>
  -139.464    60.425     0.200
>
  -139.953    60.585     0.200
>
  -139.927    60.550     0.200
>
  -139.446    60.443     0.200
>
  -139.993    60.555     0.200
>
  -139.886    60.638     0.200
>
  -139.933    60.592     0.200
>
  -139.843    60.543     0.200
>
  -139.442    60.417     0.200
>
  -139.913    60.529     0.200
>
  -139.919    60.556     0.200
>
  -139.905    60.546     0.200
>
  -139.696    60.591     0.200
>
  -139.458    60.413     0.200
>
  -139.865    60.570     0.200
>
  -139.818    60.608     0.200
>
  -139.607    60.494     0.200
>
  -139.583    60.492     0.200
>
  -139.892    60.526     0.200
>
  -139.939    60.505     0.200
>
  -139.541    60.391     0.200
>
  -139.488    60.420     0.200
>
  -139.943    60.562     0.200
>
  -139.824    60.567     0.200
>
  -139.552    60.449     0.200
>
  -139.360    60.401     0.200
>
  -139.885    60.629     0.200
>
  -139.873    60.627     0.200
>
  -139.856    60.604     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -139.560    60.264     0.000   222.000   222.000
  -139.560    60.264     0.000   444.000   444.000
EOF
gmt end
