#!/bin/bash
gmt begin herat11.41_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases herat11.41'
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -105.000 Indirect calibration: shifted hypocenters used
EOF
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.500     2.979
     2.000    -0.880
     2.500    -4.739
     3.000    -8.599
     3.500   -12.458
     4.000   -16.320
     4.500   -20.182
     5.000   -24.047
     5.500   -27.914
     6.000   -31.782
     6.500   -35.652
     7.000   -39.525
     7.500   -43.401
     8.000   -47.279
     8.500   -51.161
     9.000   -55.046
     9.500   -58.935
    10.000   -62.827
    10.500   -66.724
    11.000   -70.625
    11.500   -74.530
    12.000   -78.441
    12.500   -82.356
    13.000   -86.276
    13.500   -90.201
    14.000   -94.134
    14.500   -98.071
    15.000  -102.015
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -83.276 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.002
     1.000    -0.298
     1.500    -0.648
     2.000    -1.914
     2.500    -3.180
     3.000    -4.446
     3.500    -5.715
     4.000    -6.985
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -9.985 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     4.495     3.508     0.200
     4.471     5.123     0.200
     4.422     2.580     0.200
     4.508     3.939     0.200
     4.508     2.067     0.200
     4.567     1.863     0.200
     4.494     0.552     0.200
     4.500     2.862     0.200
     4.453     2.600     0.200
     4.526     3.159     0.200
     4.555     1.973     0.200
     4.504     2.423     0.200
     4.520     2.414     0.200
     4.486     3.027     0.200
     4.580     3.477     0.200
     4.537     3.560     0.200
     4.493     2.436     0.200
     4.460     2.840     0.200
     4.499     4.934     0.200
     4.531     2.886     0.200
     4.574     3.203     0.200
     4.594     4.041     0.200
     4.518     1.717     0.200
     4.501     4.572     0.200
     4.552     4.292     0.200
     4.592     4.091     0.200
     4.466     3.123     0.200
     4.495     1.774     0.200
     4.541     2.785     0.200
     4.528     3.562     0.200
     4.531     4.226     0.200
     4.574     2.238     0.200
     4.592     3.905     0.200
     4.545     3.372     0.200
     4.633     2.607     0.200
     4.539     1.902     0.200
     4.638     2.168     0.200
     4.574     2.193     0.200
     4.498     1.612     0.200
     4.537     2.963     0.200
     4.472     3.342     0.200
     4.448     4.161     0.200
     4.451     5.982     0.200
     4.496     3.980     0.200
     4.604     4.140     0.200
     4.596     1.756     0.200
     4.505     4.280     0.200
     4.438     2.300     0.200
     4.494     2.967     0.200
     4.465     2.800     0.200
     4.504    -0.645     0.200
     4.522     5.033     0.200
     4.556     2.884     0.200
     4.581     3.787     0.200
     4.617     2.559     0.200
     4.631     3.851     0.200
    19.931    -0.698     0.200
     4.636     1.541     0.200
     4.632     2.228     0.200
     4.594     2.934     0.200
     4.599     1.021     0.200
     4.620     2.900     0.200
     4.506     4.206     0.200
     4.648     3.802     0.200
     4.551     1.747     0.200
     4.610     3.113     0.200
     4.595     0.274     0.200
     4.601     4.962     0.200
     4.587     5.251     0.200
     4.594     2.135     0.200
     4.628     4.598     0.200
     4.587     1.266     0.200
     4.520     3.803     0.200
     4.566     2.968     0.200
     4.477     0.641     0.200
     4.507     1.748     0.200
     4.539     1.885     0.200
     4.583     3.325     0.200
     4.542     3.544     0.200
     4.558     1.753     0.200
     4.562     1.680     0.200
     4.486     4.208     0.200
     4.494     2.561     0.200
     4.556     3.622     0.200
     4.465     2.712     0.200
     4.493     4.564     0.200
     4.629     2.125     0.200
     4.479     4.585     0.200
     4.552     3.562     0.200
     4.565     2.816     0.200
     4.475     6.513     0.200
     4.432     0.386     0.200
     4.640     3.656     0.200
     2.637     7.290     0.200
     3.301     6.245     0.200
     4.460     1.797     0.200
     2.748     6.095     0.200
     4.657     1.073     0.200
     4.618     0.891     0.200
     4.566     4.291     0.200
     4.442     3.900     0.200
     4.329     1.193     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.462   -19.841     0.200
     7.137   -42.368     0.200
     9.908   -57.829     0.200
     9.951   -60.125     0.200
    10.295   -66.308     0.200
    10.779   -69.368     0.200
    10.779   -70.630     0.200
    11.270   -68.804     0.200
    11.832   -72.498     0.200
    12.664   -82.163     0.200
    12.664   -84.171     0.200
    13.058   -78.769     0.200
    13.204   -82.787     0.200
    13.301   -85.770     0.200
    13.695   -86.354     0.200
    13.862   -87.967     0.200
    14.527   -94.031     0.200
    15.344   -99.671     0.200
    15.715  -103.292     0.200
    15.715  -102.491     0.200
    15.786  -102.186     0.200
    16.018  -114.207     0.200
    16.360  -108.711     0.200
    17.485  -116.513     0.200
    19.052  -126.089     0.200
    19.332  -136.547     0.200
    20.481  -136.539     0.200
    21.568  -153.292     0.200
    21.702  -154.875     0.200
    21.819  -152.861     0.200
     4.475   -21.712     0.200
     7.130   -42.920     0.200
    10.773   -71.016     0.200
    11.286   -66.132     0.200
    11.819   -72.423     0.200
    12.655   -82.573     0.200
    12.655   -81.661     0.200
    13.316   -82.076     0.200
    13.710   -83.772     0.200
    13.878   -85.098     0.200
    13.943   -88.261     0.200
    14.662  -101.788     0.200
    15.648  -107.551     0.200
    16.024  -111.925     0.200
    16.024  -111.122     0.200
    21.300  -145.681     0.200
     4.495   -18.788     0.200
     7.181   -40.862     0.200
     9.792   -57.135     0.200
     9.864   -57.363     0.200
     9.907   -58.212     0.200
    10.823   -71.445     0.200
    10.823   -69.826     0.200
    10.817   -63.002     0.200
    11.262   -67.546     0.200
    11.871   -74.628     0.200
    12.707   -80.550     0.200
    12.707   -81.730     0.200
    13.058   -81.473     0.200
    13.201   -81.499     0.200
    13.220   -78.263     0.200
    13.300   -83.628     0.200
    13.691   -85.733     0.200
    13.853   -85.983     0.200
    13.933   -89.509     0.200
    14.504   -90.221     0.200
    14.569   -94.291     0.200
    14.690   -98.815     0.200
    15.387  -100.469     0.200
    15.696  -107.953     0.200
    15.696  -109.582     0.200
    15.757  -101.666     0.200
    15.828  -102.831     0.200
    16.050  -115.154     0.200
    16.050  -114.619     0.200
    16.402  -106.699     0.200
    17.282  -113.784     0.200
    17.487  -117.470     0.200
    17.771  -115.268     0.200
    19.325  -130.627     0.200
    22.720  -161.142     0.200
    16.042  -112.232     0.200
     7.100   -41.516     0.200
    10.745   -71.658     0.200
    10.745   -69.525     0.200
    11.330   -66.871     0.200
    11.776   -71.711     0.200
    12.620   -79.636     0.200
    12.620   -80.511     0.200
    13.260   -81.250     0.200
    13.356   -84.001     0.200
    13.752   -84.941     0.200
    13.923   -85.746     0.200
    13.980   -91.674     0.200
    14.481   -93.404     0.200
    14.667  -103.408     0.200
    14.667  -102.742     0.200
    15.297   -99.570     0.200
    15.627  -108.277     0.200
    15.668  -102.545     0.200
    16.311  -106.877     0.200
    16.033  -111.081     0.200
    16.033  -111.794     0.200
    19.381  -129.387     0.200
     4.508   -22.285     0.200
    10.740   -71.095     0.200
    12.614   -80.834     0.200
    12.614   -80.082     0.200
    14.663  -103.260     0.200
    16.029  -114.018     0.200
    12.574   -80.966     0.200
     4.500   -21.256     0.200
    11.325   -67.299     0.200
    11.773   -74.819     0.200
    12.615   -80.217     0.200
    13.254   -81.347     0.200
    13.350   -83.492     0.200
    13.746   -85.046     0.200
    13.917   -86.280     0.200
    16.023  -115.575     0.200
     7.129   -41.684     0.200
    10.770   -71.204     0.200
    11.265   -65.600     0.200
    11.827   -75.319     0.200
    12.657   -84.198     0.200
    13.197   -80.443     0.200
    13.294   -82.317     0.200
    13.688   -83.619     0.200
    13.857   -84.666     0.200
    14.645  -101.187     0.200
    15.642  -109.903     0.200
    16.007  -111.512     0.200
    16.007  -110.898     0.200
    10.799   -73.219     0.200
    14.698   -99.455     0.200
    12.638   -84.128     0.200
    16.052  -115.860     0.200
    10.789   -70.764     0.200
    12.669   -82.772     0.200
    16.041  -113.152     0.200
    12.607   -86.403     0.200
    12.714   -85.737     0.200
    16.044  -115.009     0.200
     4.499   -22.761     0.200
     7.186   -44.353     0.200
     7.980   -49.562     0.200
     8.964   -55.551     0.200
     9.307   -58.788     0.200
    11.288   -66.515     0.200
    12.708   -82.985     0.200
    12.708   -81.172     0.200
    13.227   -80.504     0.200
    16.073  -113.580     0.200
    16.073  -115.166     0.200
    10.849   -71.529     0.200
    12.722   -83.103     0.200
    12.722   -84.791     0.200
    14.746  -102.332     0.200
    10.791   -72.853     0.200
    11.790   -72.581     0.200
    12.653   -79.945     0.200
    12.653   -83.751     0.200
    16.106  -114.753     0.200
    16.106  -117.089     0.200
    12.660   -82.155     0.200
    10.753   -71.061     0.200
    16.044  -117.208     0.200
    16.044  -115.633     0.200
     4.501   -21.705     0.200
    10.758   -67.781     0.200
    12.634   -81.327     0.200
    14.670   -99.162     0.200
    16.034  -114.557     0.200
    16.034  -111.268     0.200
    10.821   -69.992     0.200
    12.689   -82.931     0.200
    12.689   -82.572     0.200
    14.743  -103.903     0.200
    16.106  -113.840     0.200
    16.106  -116.934     0.200
    10.821   -70.965     0.200
    12.681   -81.367     0.200
    12.681   -82.441     0.200
    14.770  -101.959     0.200
    16.135  -112.788     0.200
    10.864   -71.403     0.200
    11.913   -76.597     0.200
    12.750   -83.423     0.200
    12.750   -85.368     0.200
    14.711  -101.991     0.200
    16.068  -115.403     0.200
    16.068  -114.867     0.200
     4.495   -20.560     0.200
    10.759   -71.760     0.200
    12.637   -81.026     0.200
    12.637   -80.587     0.200
    14.667  -100.417     0.200
    16.031  -114.342     0.200
    16.031  -111.048     0.200
    10.731   -72.461     0.200
    10.731   -73.362     0.200
    11.746   -73.546     0.200
    12.598   -82.001     0.200
    12.598   -81.614     0.200
    13.394   -82.804     0.200
    13.791   -83.466     0.200
    14.680  -101.671     0.200
    16.049  -115.267     0.200
    16.049  -114.747     0.200
    17.575  -117.939     0.200
    19.419  -134.288     0.200
    10.765   -71.750     0.200
    10.765   -71.328     0.200
    11.786   -72.991     0.200
    12.636   -82.827     0.200
    12.636   -82.046     0.200
    14.693   -99.876     0.200
    16.058  -114.884     0.200
    16.058  -112.724     0.200
    17.556  -116.910     0.200
    19.344  -140.234     0.200
    19.398  -130.691     0.200
     9.966   -58.071     0.200
    10.008   -56.539     0.200
    10.553   -60.111     0.200
    10.633   -60.071     0.200
    10.715   -70.249     0.200
    10.968   -68.086     0.200
    11.736   -73.068     0.200
    12.585   -80.961     0.200
    13.388   -83.241     0.200
    13.785   -84.532     0.200
    13.958   -85.428     0.200
    14.008   -91.492     0.200
    14.444   -91.872     0.200
    14.664  -104.387     0.200
    15.700  -103.101     0.200
    16.032  -113.049     0.200
    16.032  -116.365     0.200
    17.567  -117.440     0.200
     4.574   -22.912     0.200
     5.815   -32.079     0.200
     7.132   -40.054     0.200
     9.380   -51.042     0.200
     9.749   -61.505     0.200
     9.900   -57.895     0.200
    10.493   -61.584     0.200
    10.780   -68.738     0.200
    11.031   -68.316     0.200
    11.034   -63.892     0.200
    11.138   -65.815     0.200
    11.383   -66.762     0.200
    11.779   -74.106     0.200
    11.963   -80.872     0.200
    12.642   -82.430     0.200
    12.642   -80.492     0.200
    13.035   -78.761     0.200
    13.173   -79.396     0.200
    13.318   -80.604     0.200
    13.809   -84.565     0.200
    13.936   -90.597     0.200
    13.974   -85.511     0.200
    14.210   -86.976     0.200
    14.732  -101.241     0.200
    14.732  -102.236     0.200
    14.793   -94.456     0.200
    15.671  -109.943     0.200
    16.099  -117.173     0.200
    16.099  -113.477     0.200
    16.238  -103.853     0.200
    17.365  -111.755     0.200
    17.594  -115.334     0.200
    17.600  -117.038     0.200
    19.440  -130.486     0.200
    19.782  -130.300     0.200
    20.087  -136.804     0.200
    20.124  -132.917     0.200
    20.943  -142.596     0.200
    21.400  -146.108     0.200
    21.848  -154.741     0.200
    10.722   -70.456     0.200
    12.580   -84.150     0.200
    12.580   -79.924     0.200
    14.709   -98.435     0.200
     1.713     0.013     0.200
    12.624   -80.196     0.200
    16.066  -113.502     0.200
     1.767    -0.316     0.200
    12.585   -80.759     0.200
    14.744  -103.363     0.200
    16.117  -117.081     0.200
    16.117  -113.903     0.200
    14.737  -101.043     0.200
    16.099  -114.960     0.200
    12.609   -80.778     0.200
    12.609   -78.655     0.200
    16.081  -115.220     0.200
     4.498   -18.963     0.200
    10.743   -72.057     0.200
    11.779   -72.990     0.200
    12.620   -81.003     0.200
    12.620   -82.788     0.200
    14.659  -102.874     0.200
    15.624  -108.674     0.200
    16.024  -115.203     0.200
    16.024  -113.123     0.200
    19.314  -139.224     0.200
    10.775   -71.805     0.200
    12.658   -82.739     0.200
    12.658   -81.617     0.200
    14.661  -103.342     0.200
    16.023  -115.602     0.200
    16.023  -112.821     0.200
    12.745   -79.595     0.200
    16.050  -113.677     0.200
    10.872   -72.395     0.200
    12.762   -81.716     0.200
    14.706  -101.706     0.200
    16.062  -113.850     0.200
    16.062  -111.389     0.200
    10.711   -71.438     0.200
    10.711   -67.806     0.200
    12.587   -82.212     0.200
    14.637  -104.049     0.200
    14.637  -103.783     0.200
    16.004  -114.896     0.200
    10.697   -69.428     0.200
    12.551   -82.326     0.200
    14.701  -104.210     0.200
    16.074  -112.881     0.200
    10.804   -70.835     0.200
    11.867   -74.482     0.200
    12.694   -84.521     0.200
    12.694   -80.825     0.200
    16.015  -116.983     0.200
    16.015  -115.237     0.200
     1.615     0.365     0.200
     1.615     0.705     0.200
     4.494   -20.385     0.200
    12.715   -83.941     0.200
    16.072  -112.069     0.200
     7.168   -44.218     0.200
     7.962   -47.961     0.200
     9.299   -57.886     0.200
    10.810   -72.843     0.200
    12.695   -83.483     0.200
    12.695   -82.725     0.200
    14.678  -102.217     0.200
    16.037  -116.473     0.200
    16.037  -114.770     0.200
    17.483  -113.495     0.200
    19.360  -140.069     0.200
    12.696   -82.170     0.200
    12.591   -81.711     0.200
    16.057  -114.910     0.200
     4.581   -20.563     0.200
     7.069   -38.431     0.200
    10.002   -61.419     0.200
    10.553   -64.939     0.200
    10.717   -69.184     0.200
    10.717   -69.483     0.200
    10.906   -66.147     0.200
    11.415   -68.994     0.200
    11.714   -74.675     0.200
    12.467   -73.894     0.200
    12.498   -76.562     0.200
    12.577   -79.710     0.200
    12.577   -80.569     0.200
    13.342   -82.305     0.200
    13.438   -82.531     0.200
    13.835   -84.014     0.200
    14.007   -88.177     0.200
    14.058   -93.288     0.200
    14.411   -93.518     0.200
    14.434   -94.353     0.200
    14.698  -100.517     0.200
    14.698  -103.789     0.200
    15.247  -100.922     0.200
    15.620  -102.824     0.200
    15.688  -103.758     0.200
    16.069  -112.601     0.200
    17.618  -118.836     0.200
    19.500  -131.363     0.200
    20.373  -136.067     0.200
    21.420  -144.614     0.200
    21.561  -143.669     0.200
    21.701  -150.130     0.200
    21.824  -150.166     0.200
    12.519   -84.681     0.200
     5.698   -32.342     0.200
     7.012   -39.195     0.200
    10.662   -66.573     0.200
    11.647   -75.534     0.200
    12.515   -81.139     0.200
    12.515   -81.487     0.200
    13.383   -79.649     0.200
    13.477   -81.720     0.200
    13.877   -83.398     0.200
    14.055   -84.642     0.200
    16.056  -113.464     0.200
    19.281  -137.582     0.200
    20.038  -130.431     0.200
    12.534   -79.539     0.200
    16.092  -116.618     0.200
    12.602   -81.614     0.200
    16.126  -115.204     0.200
    10.710   -69.510     0.200
    12.566   -81.319     0.200
    16.075  -112.618     0.200
    10.681   -68.122     0.200
    12.536   -82.570     0.200
    12.536   -79.279     0.200
    13.465   -84.929     0.200
    13.864   -86.474     0.200
    14.040   -87.253     0.200
    14.688  -102.406     0.200
    16.062  -116.877     0.200
    16.062  -112.662     0.200
    19.296  -135.632     0.200
    10.674   -70.313     0.200
    11.653   -72.060     0.200
    12.525   -81.953     0.200
    12.525   -79.524     0.200
    14.698  -105.818     0.200
    16.074  -116.790     0.200
    16.074  -115.913     0.200
     1.682     0.271     0.200
    10.774   -71.277     0.200
    12.649   -84.632     0.200
    12.649   -83.300     0.200
    14.684   -99.212     0.200
    16.047  -114.495     0.200
    10.757   -68.652     0.200
    11.721   -73.209     0.200
    12.603   -82.453     0.200
    12.603   -79.557     0.200
    19.522  -128.600     0.200
    10.733   -71.375     0.200
    12.599   -83.529     0.200
    12.599   -82.919     0.200
    14.688  -101.801     0.200
    16.069  -116.691     0.200
     4.601   -19.210     0.200
    10.767   -70.430     0.200
    12.624   -81.432     0.200
    16.112  -111.876     0.200
    10.643   -68.022     0.200
    12.500   -80.832     0.200
    12.500   -80.317     0.200
    16.032  -113.167     0.200
    10.768   -69.815     0.200
    14.681  -101.201     0.200
    16.046  -113.008     0.200
    10.750   -69.862     0.200
    14.690  -100.014     0.200
    16.057  -114.415     0.200
     4.568   -17.952     0.200
    10.694   -69.429     0.200
    14.676  -102.291     0.200
    16.048  -110.515     0.200
    16.048  -115.456     0.200
     7.019   -41.942     0.200
    12.524   -83.044     0.200
    16.051  -116.113     0.200
    10.671   -70.068     0.200
    14.701  -102.317     0.200
    16.077  -115.102     0.200
     4.587   -21.820     0.200
    12.509   -83.889     0.200
    12.509   -79.975     0.200
    14.662  -101.732     0.200
    16.037  -114.844     0.200
    19.266  -136.396     0.200
    10.734   -70.132     0.200
    12.607   -82.174     0.200
    12.607   -82.854     0.200
    14.668  -101.934     0.200
    16.035  -115.609     0.200
    16.035  -116.037     0.200
    10.679   -69.433     0.200
    12.540   -83.277     0.200
    16.037  -113.643     0.200
    10.764   -71.328     0.200
    12.645   -84.479     0.200
    12.645   -81.453     0.200
    12.645   -80.556     0.200
    14.658   -99.603     0.200
    16.021  -114.088     0.200
    10.747   -69.002     0.200
    12.622   -81.586     0.200
    14.668  -102.775     0.200
    16.033  -114.954     0.200
    16.033  -113.870     0.200
    10.834   -72.364     0.200
    12.704   -82.228     0.200
    12.704   -81.220     0.200
    14.742   -99.819     0.200
    16.105  -115.309     0.200
     4.542   -22.903     0.200
    10.772   -70.317     0.200
    12.641   -80.678     0.200
    12.641   -81.943     0.200
    16.073  -114.182     0.200
    16.073  -115.080     0.200
    10.674   -70.939     0.200
    12.537   -80.991     0.200
    14.656  -105.119     0.200
    16.028  -115.848     0.200
     7.020   -40.367     0.200
    10.668   -70.374     0.200
    11.675   -73.145     0.200
    12.530   -80.520     0.200
    12.530   -82.301     0.200
    12.530   -79.262     0.200
    13.184   -81.986     0.200
    14.044   -93.966     0.200
    14.655  -101.509     0.200
    15.562  -110.433     0.200
    16.028  -113.880     0.200
    16.028  -115.521     0.200
    17.607  -117.587     0.200
    19.173  -126.756     0.200
    19.271  -140.035     0.200
    19.454  -132.063     0.200
     1.608     0.606     0.200
    10.839   -69.246     0.200
    12.721   -80.207     0.200
    14.710   -99.842     0.200
    16.069  -114.412     0.200
    16.072  -113.991     0.200
    19.391  -138.224     0.200
    12.620   -84.931     0.200
    12.667   -84.310     0.200
    12.667   -84.545     0.200
    14.684  -103.793     0.200
    16.046  -114.393     0.200
    16.046  -116.355     0.200
    12.496   -82.499     0.200
    12.496   -82.765     0.200
    12.496   -78.460     0.200
    14.687  -102.194     0.200
    16.064  -112.833     0.200
    16.064  -110.598     0.200
    10.770   -71.080     0.200
    12.651   -82.806     0.200
    12.651   -81.785     0.200
    14.662  -103.416     0.200
    16.025  -114.237     0.200
    16.025  -112.016     0.200
    10.753   -70.682     0.200
    14.683  -100.031     0.200
    16.050  -110.618     0.200
    10.737   -68.851     0.200
    12.602   -82.294     0.200
    14.691  -104.136     0.200
    10.746   -71.804     0.200
    12.609   -82.529     0.200
    14.705  -105.217     0.200
    15.637  -110.953     0.200
    16.074  -115.826     0.200
    16.074  -116.475     0.200
     4.475   -17.612     0.200
    10.739   -68.796     0.200
    12.620   -79.350     0.200
    12.620   -80.257     0.200
    14.641  -100.075     0.200
    16.005  -110.654     0.200
    12.711   -85.831     0.200
    16.019  -115.647     0.200
    12.512   -81.049     0.200
    10.730   -69.303     0.200
    12.595   -78.392     0.200
     4.618   -18.577     0.200
    16.073  -111.228     0.200
    15.995  -114.729     0.200
     2.105     7.959     0.200
     4.329   -21.132     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.405     0.879     0.200
     1.546    -0.594     0.200
     1.447     0.000     0.200
     1.468     0.666     0.200
     1.702    -2.818     0.200
     1.492     0.415     0.200
     1.449    -0.356     0.200
     1.478     0.065     0.200
     1.434     0.257     0.200
     1.546    -0.150     0.200
     1.493     1.216     0.200
     1.444     0.234     0.200
     1.394     1.275     0.200
     1.433     1.083     0.200
     1.458     1.393     0.200
     1.523     1.472     0.200
     1.540     0.291     0.200
     1.481     1.204     0.200
     1.461     0.753     0.200
     1.489     0.265     0.200
     1.530     0.373     0.200
     1.387     0.277     0.200
     1.455     1.036     0.200
     1.693    -0.211     0.200
     1.513     1.441     0.200
     1.509     1.322     0.200
     1.527     1.577     0.200
     1.527     0.587     0.200
     1.507     1.091     0.200
     1.603     0.376     0.200
     1.629    -0.489     0.200
     1.539    -0.612     0.200
     1.464     0.606     0.200
     1.497     0.328     0.200
     1.426     0.234     0.200
     1.438     0.665     0.200
     1.571     0.695     0.200
     1.462     1.576     0.200
     1.380     0.750     0.200
     1.632    -0.595     0.200
     1.441     1.673     0.200
     1.484     0.704     0.200
     1.529     0.868     0.200
     1.621     0.584     0.200
     1.627    -0.176     0.200
     1.625     0.250     0.200
     1.817    -2.951     0.200
     1.574     0.651     0.200
     1.461     0.471     0.200
     1.610    -0.424     0.200
     1.521     0.778     0.200
     1.602     0.676     0.200
     1.598    -0.968     0.200
     1.558     0.865     0.200
     1.466     0.798     0.200
     1.501     0.801     0.200
     1.554     1.052     0.200
     1.590     1.077     0.200
     1.436     1.215     0.200
     1.472     0.265     0.200
     1.472     0.612     0.200
     1.695    -0.653     0.200
     1.552     1.115     0.200
     1.416     1.075     0.200
     1.416     1.437     0.200
     1.519    -0.123     0.200
     1.424     0.383     0.200
     1.435     0.958     0.200
     1.489     1.797     0.200
     1.443     0.873     0.200
     1.368     1.199     0.200
     1.638    -0.613     0.200
     1.526     1.559     0.200
     1.412     0.310     0.200
     1.638     0.290     0.200
     1.611     0.165     0.200
     1.439     0.736     0.200
EOF
gmt end
