#!/bin/bash
gmt begin herat11.41_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional herat11.41'
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     6.000     2.000 Indirect calibration: shifted hypocenters used
EOF
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.879
    15.000    42.601
    15.500    42.320
    16.000    42.036
    16.500    41.746
    17.000    41.450
    17.500    41.146
    18.000    40.831
    18.500    40.505
    19.000    40.163
    19.500    39.805
    20.000    39.428
    20.500    39.030
    21.000    38.609
    21.500    38.161
    22.000    37.686
    22.500    37.181
    23.000    36.645
    23.500    36.075
    24.000    34.873
    24.500    33.601
    25.000    32.320
    25.500    31.028
    26.000    29.726
    26.500    28.412
    27.000    27.085
    27.500    25.742
    28.000    24.379
    28.500    23.001
    29.000    21.611
    29.500    20.212
    30.000    18.806
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.379 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    11.110
     2.000    12.084
     2.500    13.059
     3.000    14.034
     3.500    15.008
     4.000    15.981
     4.500    16.953
     5.000    17.925
     5.500    18.895
     6.000    19.865
     6.500    20.833
     7.000    21.800
     7.500    22.765
     8.000    23.729
     8.500    24.691
     9.000    25.651
     9.500    26.609
    10.000    27.564
    10.500    28.518
    11.000    29.456
    11.500    30.369
    12.000    31.270
    12.500    32.159
    13.000    33.038
    13.500    33.904
    14.000    34.762
    14.500    35.618
    15.000    36.469
    15.500    37.316
    16.000    38.157
    16.500    38.990
    17.000    39.562
    17.500    39.984
    18.000    40.333
    18.500    40.624
    19.000    40.857
    19.500    41.031
    20.000    41.148
    20.500    41.205
    21.000    41.202
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    30.038 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.097
     1.000     6.024
     1.500     8.989
     2.000    11.441
     2.500    13.878
     3.000    16.314
     3.500    18.749
     4.000    21.184
     4.500    23.617
     5.000    26.050
     5.500    28.480
     6.000    30.909
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    24.050 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    33.024
     2.000    39.180
     2.500    45.336
     3.000    51.491
     3.500    57.647
     4.000    63.800
     4.500    69.953
     5.000    76.103
     5.500    82.251
     6.000    88.398
     6.500    94.543
     7.000   100.685
     7.500   106.824
     8.000   112.961
     8.500   119.094
     9.000   125.224
     9.500   131.350
    10.000   137.473
    10.500   143.591
    11.000   149.705
    11.500   155.815
    12.000   161.919
    12.500   168.019
    13.000   174.114
    13.500   180.204
    14.000   186.286
    14.500   192.364
    15.000   198.435
    15.500   204.501
    16.000   210.559
    16.500   216.611
    17.000   222.656
    17.500   234.886
    18.000   241.158
    18.500   247.418
    19.000   253.664
    19.500   259.898
    20.000   266.117
    20.500   272.322
    21.000   278.512
    21.500   284.688
    22.000   290.847
    22.500   296.991
    23.000   303.118
    23.500   309.228
    24.000   315.322
    24.500   321.398
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    61.800 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.017
     1.000    19.732
     1.500    29.397
     2.000    38.146
     2.500    46.895
     3.000    55.644
     3.500    64.390
     4.000    73.135
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    62.390 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    14.695   218.560     0.150
    18.115   252.137     0.150
    18.275   255.084     0.150
    19.586   259.661     0.150
    19.584   258.524     0.150
    19.667   261.250     0.150
    20.037   264.380     0.150
    20.670   268.240     0.150
    21.285   279.066     0.150
    21.863   277.635     0.150
    21.863    57.922     0.150
    21.863   281.320     0.150
    22.663   280.103     0.150
    22.728   267.357     0.150
    22.728   284.976     0.150
    23.014   266.449     0.150
    23.014   292.750     0.150
    23.195   282.157     0.150
    23.263   289.611     0.150
    23.574   292.662     0.150
    24.275   293.075     0.150
    25.128   300.444     0.150
    25.214   247.487     0.150
    25.214    68.526     0.150
    25.214   305.725     0.150
    25.510   303.064     0.150
    26.811   303.088     0.150
    26.941   308.305     0.150
    26.941    70.163     0.150
    26.941  -310.146     0.150
    27.298   306.616     0.150
    28.177   312.807     0.150
    28.572   213.034     0.150
    28.572   316.534     0.150
    28.579  -329.212     0.150
    29.326   207.475     0.150
    20.465   260.515     0.150
    21.042    41.789     0.150
    21.908    66.480     0.150
    22.714   268.395     0.150
    22.714   285.286     0.150
    23.030   265.706     0.150
    25.197   247.420     0.150
    26.953    70.602     0.150
    28.586   212.475     0.150
    28.593  -330.346     0.150
    21.920   309.127     0.150
    22.697   268.678     0.150
    22.697   285.979     0.150
    25.185    68.183     0.150
    26.982    68.748     0.150
    19.054   257.806     0.150
    19.671   260.705     0.150
    21.286   277.464     0.150
    21.897   278.003     0.150
    21.897    58.933     0.150
    21.897   282.033     0.150
    21.897   307.433     0.150
    21.960   277.894     0.150
    22.064   281.487     0.150
    22.720   268.340     0.150
    23.003   266.822     0.150
    23.003   291.728     0.150
    23.533   295.340     0.150
    24.290   293.207     0.150
    25.237    67.151     0.150
    25.237   299.051     0.150
    25.237   303.051     0.150
    25.237   695.350     0.150
    26.843   304.905     0.150
    26.903   307.806     0.150
    26.958   307.973     0.150
    29.324   314.003     0.150
    22.775   266.972     0.150
    22.775   286.882     0.150
    17.538    45.016     0.150
    17.652   247.871     0.150
    19.105   259.338     0.150
    19.719   263.082     0.150
    21.340   277.463     0.150
    21.874   277.487     0.150
    22.195   285.488     0.150
    22.679   269.333     0.150
    22.679   287.763     0.150
    23.075   265.783     0.150
    23.629   293.649     0.150
    26.749   303.536     0.150
    26.922    69.416     0.150
    28.621   213.646     0.150
    28.628  -329.194     0.150
    21.870    57.641     0.150
    22.679   267.567     0.150
    22.679   286.375     0.150
    18.141    43.538     0.150
    22.687   267.811     0.150
    22.687   284.769     0.150
    23.070   264.324     0.150
    28.613   211.716     0.150
    28.620  -330.923     0.150
    21.852    58.392     0.150
    21.852   310.392     0.150
    22.177   285.103     0.150
    22.736   268.104     0.150
    22.736   286.155     0.150
    26.809   304.948     0.150
    26.876    69.666     0.150
    28.563   213.071     0.150
    28.570  -329.744     0.150
    18.084    42.359     0.150
    21.919   278.610     0.150
    18.001    43.634     0.150
    19.411    44.213     0.150
    21.918   277.764     0.150
    21.918    58.772     0.150
    21.840   275.325     0.150
    21.887   277.318     0.150
    21.887    57.675     0.150
    21.887   279.375     0.150
    22.645   268.875     0.150
    22.645   285.324     0.150
    26.951    70.083     0.150
    27.009    69.501     0.150
    21.900   276.615     0.150
    21.900    58.248     0.150
    21.900   281.548     0.150
    22.659   269.413     0.150
    22.659   287.460     0.150
    27.003    70.394     0.150
    28.647  -329.904     0.150
    17.622   247.953     0.150
    20.499   261.781     0.150
    21.370   275.662     0.150
    21.828   311.114     0.150
    21.871   277.538     0.150
    21.871    60.218     0.150
    21.871   282.218     0.150
    21.871   308.620     0.150
    22.189   285.201     0.150
    22.654   269.263     0.150
    22.654   286.314     0.150
    26.938    69.782     0.150
    26.997   308.799     0.150
    28.603  -330.802     0.150
    28.646   213.001     0.150
    28.653  -331.193     0.150
    19.167   259.399     0.150
    19.238   259.634     0.150
    19.565   259.804     0.150
    20.045   265.199     0.150
    20.556   261.190     0.150
    21.877   492.070     0.150
    21.939    58.847     0.150
    21.939   306.747     0.150
    22.136   283.253     0.150
    22.259   281.219     0.150
    22.614    59.497     0.150
    22.614   268.977     0.150
    22.614   285.527     0.150
    23.124   291.490     0.150
    23.153   290.642     0.150
    23.424   284.923     0.150
    23.565   294.764     0.150
    23.688    65.233     0.150
    24.080   295.830     0.150
    24.384   293.116     0.150
    24.398   295.954     0.150
    24.413   296.566     0.150
    24.565   298.958     0.150
    25.117   250.039     0.150
    25.135   300.102     0.150
    25.387   301.613     0.150
    25.377   302.414     0.150
    25.750   304.578     0.150
    26.735   232.578     0.150
    26.735   305.378     0.150
    26.991   228.689     0.150
    27.048   308.523     0.150
    27.071   310.934     0.150
    27.189   308.653     0.150
    28.102   313.059     0.150
    28.685   213.033     0.150
    28.685   315.719     0.150
    29.413   316.628     0.150
    22.594    60.035     0.150
    22.594   269.875     0.150
    22.594   285.245     0.150
    23.720   293.822     0.150
    22.642    59.759     0.150
    22.642   268.959     0.150
    22.642   285.299     0.150
    21.866    57.940     0.150
    26.970    73.276     0.150
    28.618  -331.008     0.150
    21.844    56.497     0.150
    21.844   306.598     0.150
    22.590    58.455     0.150
    22.590   268.455     0.150
    22.590   284.064     0.150
    21.884   277.419     0.150
    21.884    57.224     0.150
    21.884   278.326     0.150
    22.210   283.619     0.150
    22.726    59.451     0.150
    22.726   268.123     0.150
    22.726   285.380     0.150
    26.949    71.016     0.150
    20.099    44.442     0.150
    15.297   223.923     0.150
    16.922   242.286     0.150
    17.425   244.560     0.150
    17.894   246.822     0.150
    19.984   265.736     0.150
    20.091   264.489     0.150
    21.905   278.434     0.150
    21.905    58.315     0.150
    21.905   278.815     0.150
    22.157   284.983     0.150
    22.221   284.326     0.150
    22.604    60.386     0.150
    22.604   269.475     0.150
    22.604   286.356     0.150
    23.160   728.675     0.150
    23.425   286.376     0.150
    23.710   293.151     0.150
    24.040   297.283     0.150
    24.270   298.573     0.150
    24.390   295.616     0.150
    24.395   296.305     0.150
    24.383   290.702     0.150
    24.553   299.410     0.150
    25.066   248.405     0.150
    25.752   301.926     0.150
    26.675   303.256     0.150
    26.829   317.354     0.150
    27.044    71.143     0.150
    27.044   310.442     0.150
    27.044  -310.607     0.150
    27.188   307.721     0.150
    28.072   313.135     0.150
    28.762   309.323     0.150
    28.696   211.191     0.150
    28.703  -331.675     0.150
    29.371   316.774     0.150
    21.888   278.779     0.150
    21.888    59.261     0.150
    21.888   280.161     0.150
    22.200   283.016     0.150
    22.578    59.967     0.150
    22.578   269.477     0.150
    22.578   285.698     0.150
    28.724   211.001     0.150
    21.895   279.075     0.150
    21.895    57.506     0.150
    21.895   279.206     0.150
    22.209   284.347     0.150
    21.974   282.091     0.150
    22.289   285.018     0.150
    27.115    71.104     0.150
    21.875   281.077     0.150
    26.990  -312.968     0.150
    26.990    68.794     0.150
    21.777    66.963     0.150
    22.627    58.381     0.150
    22.627   268.262     0.150
    22.627   284.022     0.150
    11.675    34.196     0.150
    17.582   248.515     0.150
    17.880   246.879     0.150
    18.234    43.680     0.150
    19.783   262.869     0.150
    21.862    58.312     0.150
    21.862   277.312     0.150
    22.176   283.436     0.150
    22.622    58.827     0.150
    22.622   268.647     0.150
    22.622   284.045     0.150
    23.163   726.446     0.150
    23.373   295.211     0.150
    26.644   304.501     0.150
    27.017    69.646     0.150
    27.017  -311.401     0.150
    28.637  -329.793     0.150
    28.679   212.101     0.150
    28.679   212.382     0.150
    28.686  -330.371     0.150
    29.300  -337.839     0.150
     1.442   691.351     0.150
    21.894   278.252     0.150
    27.077  -313.587     0.150
    27.077  -312.587     0.150
    27.077   309.163     0.150
    19.346   260.070     0.150
    21.869    56.222     0.150
    21.869   308.822     0.150
    21.898   278.516     0.150
    21.847    66.862     0.150
    21.912    57.002     0.150
    27.034   225.928     0.150
    11.886    40.061     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    16.032    42.774     0.200
    16.760    41.527     0.200
    17.187    41.290     0.200
    17.403    39.287     0.200
    17.534    41.291     0.200
    17.814    41.366     0.200
    18.115    39.838     0.200
    18.275    41.093     0.200
    18.866    39.574     0.200
    18.846    40.371     0.200
    19.052    40.828     0.200
    19.154    38.435     0.200
    19.332    39.433     0.200
    19.337    38.008     0.200
    19.337    38.387     0.200
    19.335    40.288     0.200
    19.407    37.685     0.200
    19.407    37.830     0.200
    19.407    37.464     0.200
    19.578    38.797     0.200
    19.584    38.024     0.200
    19.584    38.149     0.200
    19.584    38.508     0.200
    19.584    38.624     0.200
    19.584    38.823     0.200
    19.584    37.464     0.200
    19.584    38.024     0.200
    20.037    38.806     0.200
    20.037    38.050     0.200
    20.037    39.031     0.200
    20.127    40.546     0.200
    20.144    38.586     0.200
    20.144    38.848     0.200
    20.144    38.246     0.200
    20.144    39.086     0.200
    20.144    40.284     0.200
    20.144    39.356     0.200
    20.376    39.223     0.200
    20.516    37.547     0.200
    20.670    36.352     0.200
    20.780    40.053     0.200
    20.817    39.661     0.200
    20.903    39.723     0.200
    21.055    38.452     0.200
    21.058    37.722     0.200
    21.122    36.896     0.200
    21.122    36.308     0.200
    21.305    37.042     0.200
    21.250    38.316     0.200
    21.285    39.366     0.200
    21.338    40.057     0.200
    21.437    38.093     0.200
    21.568    36.028     0.200
    21.702    38.069     0.200
    21.819    37.254     0.200
    21.909    36.992     0.200
    21.963    37.464     0.200
    21.863    38.320     0.200
    21.863    38.150     0.200
    21.863    37.980     0.200
    21.863    37.121     0.200
    21.919    37.899     0.200
    22.039    38.847     0.200
    22.047    39.012     0.200
    22.047    38.003     0.200
    22.047    39.374     0.200
    22.049    37.154     0.200
    22.188    37.633     0.200
    22.295    36.508     0.200
    22.225    38.693     0.200
    22.307    38.554     0.200
    22.307    38.335     0.200
    22.541    35.818     0.200
    22.490    38.615     0.200
    22.663    36.651     0.200
    22.728    35.325     0.200
    22.766    37.279     0.200
    22.993    37.171     0.200
    23.011    36.135     0.200
    23.013    36.700     0.200
    23.014    36.799     0.200
    23.014    36.381     0.200
    23.014    36.670     0.200
    23.014    36.100     0.200
    23.014    38.377     0.200
    23.014    36.500     0.200
    23.014    36.090     0.200
    23.078    36.535     0.200
    23.195    33.487     0.200
    23.263    35.521     0.200
    23.265    33.464     0.200
    23.303    37.517     0.200
    23.303    37.201     0.200
    23.303    35.818     0.200
    23.313    35.600     0.200
    23.471    35.643     0.200
    23.417    36.597     0.200
    23.417    36.356     0.200
    23.417    35.427     0.200
    23.544    36.367     0.200
    23.566    36.347     0.200
    23.574    36.762     0.200
    23.673    35.912     0.200
    23.673    35.588     0.200
    23.673    36.107     0.200
    23.673    36.762     0.200
    23.673    36.258     0.200
    24.006    34.247     0.200
    24.014    34.720     0.200
    24.188    33.324     0.200
    24.275    33.876     0.200
    24.418    33.288     0.200
    24.509    33.790     0.200
    24.528    32.069     0.200
    24.679    33.390     0.200
    24.620    34.604     0.200
    24.930    34.119     0.200
    25.129    32.740     0.200
    25.128    31.419     0.200
    25.128    31.106     0.200
    25.128    31.419     0.200
    25.128    31.419     0.200
    25.128    31.159     0.200
    25.214    31.305     0.200
    25.214    31.805     0.200
    25.214    31.926     0.200
    25.217    33.097     0.200
    25.335    31.813     0.200
    25.485    31.133     0.200
    25.501    30.466     0.200
    25.430    31.498     0.200
    25.430    31.799     0.200
    25.430    31.033     0.200
    25.430    31.187     0.200
    25.430    30.847     0.200
    25.430    31.629     0.200
    25.510    30.913     0.200
    25.472    30.777     0.200
    25.988    30.294     0.200
    26.089    27.318     0.200
    26.090    28.394     0.200
    26.282    27.750     0.200
    26.551    29.002     0.200
    26.587    28.896     0.200
    26.611    29.118     0.200
    26.811    27.889     0.200
    26.859    29.367     0.200
    26.978    26.227     0.200
    26.886    28.611     0.200
    26.950    26.256     0.200
    26.941    27.862     0.200
    26.941    27.255     0.200
    26.941    27.663     0.200
    26.941    26.891     0.200
    27.298    27.247     0.200
    27.191    27.619     0.200
    27.217    27.994     0.200
    27.252    25.532     0.200
    27.280    27.111     0.200
    27.289    27.193     0.200
    27.382    27.286     0.200
    27.433    26.239     0.200
    27.433    26.368     0.200
    27.433    25.218     0.200
    27.433    25.827     0.200
    27.433    27.028     0.200
    27.472    24.868     0.200
    27.472    25.271     0.200
    27.469    26.702     0.200
    27.482    26.654     0.200
    27.482    26.955     0.200
    27.531    24.919     0.200
    27.531    25.479     0.200
    27.653    25.576     0.200
    27.750    25.396     0.200
    27.750    25.726     0.200
    27.810    25.924     0.200
    27.817    26.754     0.200
    27.815    26.328     0.200
    27.926    24.783     0.200
    27.915    26.039     0.200
    27.941    26.183     0.200
    27.991    25.211     0.200
    27.991    25.512     0.200
    28.075    23.713     0.200
    28.177    25.198     0.200
    28.082    25.858     0.200
    28.089    26.874     0.200
    28.085    25.735     0.200
    28.201    23.795     0.200
    28.244    24.610     0.200
    28.189    23.039     0.200
    28.195    24.531     0.200
    28.283    24.398     0.200
    28.352    23.104     0.200
    28.356    25.073     0.200
    28.603    22.073     0.200
    28.529    22.835     0.200
    28.554    22.740     0.200
    28.525    24.480     0.200
    28.572    22.935     0.200
    28.572    23.085     0.200
    28.572    22.735     0.200
    28.579    22.852     0.200
    28.579    21.604     0.200
    28.579    22.655     0.200
    28.579    23.043     0.200
    28.575    23.001     0.200
    28.583    22.710     0.200
    28.604    24.993     0.200
    28.629    22.569     0.200
    28.636    22.582     0.200
    28.649    22.931     0.200
    28.653    22.490     0.200
    28.676    23.972     0.200
    28.672    22.465     0.200
    28.676    23.833     0.200
    28.706    22.106     0.200
    28.712    24.437     0.200
    28.707    22.355     0.200
    28.817    23.466     0.200
    28.817    22.341     0.200
    28.817    22.577     0.200
    28.817    23.981     0.200
    28.779    23.439     0.200
    28.904    21.669     0.200
    28.833    23.684     0.200
    28.848    23.360     0.200
    28.848    21.911     0.200
    28.848    23.710     0.200
    28.852    24.169     0.200
    28.861    21.485     0.200
    28.853    24.606     0.200
    28.852    23.830     0.200
    28.861    22.604     0.200
    28.861    22.956     0.200
    28.899    24.017     0.200
    28.899    23.795     0.200
    29.031    20.930     0.200
    29.064    22.085     0.200
    29.145    20.188     0.200
    29.073    24.008     0.200
    29.080    22.663     0.200
    29.225    20.755     0.200
    29.167    20.711     0.200
    29.167    20.596     0.200
    29.188    20.547     0.200
    29.214    22.539     0.200
    29.254    20.726     0.200
    29.279    21.775     0.200
    29.249    21.612     0.200
    29.249    21.807     0.200
    29.249    21.186     0.200
    29.251    22.757     0.200
    29.277    22.505     0.200
    29.326    22.961     0.200
    29.326    21.826     0.200
    29.326    22.242     0.200
    29.352    21.533     0.200
    29.352    21.931     0.200
    29.519    20.530     0.200
    29.449    20.647     0.200
    29.449    19.983     0.200
    29.449    20.095     0.200
    29.527    19.936     0.200
    29.643    17.486     0.200
    29.578    18.807     0.200
    29.578    18.930     0.200
    29.609    18.391     0.200
    29.497    22.334     0.200
    29.620    18.287     0.200
    29.673    18.363     0.200
    29.673    18.960     0.200
    29.780    18.647     0.200
    29.786    20.866     0.200
    29.807    19.819     0.200
    29.878    20.196     0.200
    29.868    18.960     0.200
    29.899    19.844     0.200
    14.695    41.261     0.200
    14.919    41.270     0.200
    15.774    41.756     0.200
    16.206    42.623     0.200
    16.707    42.875     0.200
    17.406    39.833     0.200
    17.500    43.519     0.200
    17.976    41.236     0.200
    18.178    40.439     0.200
    18.414    41.800     0.200
    19.332    40.468     0.200
    19.399    39.816     0.200
    19.399    40.073     0.200
    19.399    40.296     0.200
    19.399    38.603     0.200
    19.575    41.001     0.200
    19.575    40.603     0.200
    19.575    39.902     0.200
    19.575    40.027     0.200
    19.575    39.702     0.200
    19.575    41.003     0.200
    20.032    40.569     0.200
    20.032    39.856     0.200
    20.139    39.894     0.200
    20.139    39.707     0.200
    20.139    41.224     0.200
    20.500    39.216     0.200
    20.664    38.918     0.200
    20.834    39.898     0.200
    20.919    40.852     0.200
    21.105    38.699     0.200
    21.105    38.397     0.200
    21.288    39.009     0.200
    21.266    39.935     0.200
    21.300    41.068     0.200
    21.893    40.559     0.200
    21.869    39.540     0.200
    21.869    39.081     0.200
    21.869    39.268     0.200
    21.908    39.169     0.200
    22.055    38.437     0.200
    22.063    40.924     0.200
    22.063    38.004     0.200
    22.061    38.290     0.200
    22.241    40.396     0.200
    22.323    38.586     0.200
    22.524    38.086     0.200
    22.714    35.556     0.200
    22.782    38.339     0.200
    23.009    38.514     0.200
    23.027    37.122     0.200
    23.030    38.526     0.200
    23.030    38.247     0.200
    23.030    38.087     0.200
    23.030    38.288     0.200
    23.030    38.587     0.200
    23.094    36.786     0.200
    23.249    38.133     0.200
    23.319    38.364     0.200
    23.319    38.518     0.200
    23.319    37.239     0.200
    23.319    36.815     0.200
    23.326    36.429     0.200
    23.433    36.065     0.200
    23.433    36.723     0.200
    23.433    36.284     0.200
    23.560    37.366     0.200
    23.579    36.879     0.200
    23.589    37.862     0.200
    23.689    37.657     0.200
    23.689    37.157     0.200
    23.689    37.507     0.200
    23.990    36.083     0.200
    24.006    35.795     0.200
    24.287    35.210     0.200
    24.637    34.349     0.200
    24.946    33.439     0.200
    25.123    32.922     0.200
    25.123    32.360     0.200
    25.123    32.760     0.200
    25.123    32.489     0.200
    25.197    32.190     0.200
    25.197    33.321     0.200
    25.233    34.168     0.200
    25.342    34.200     0.200
    25.446    32.486     0.200
    25.446    32.204     0.200
    25.488    31.786     0.200
    26.005    30.081     0.200
    26.298    28.617     0.200
    26.534    29.728     0.200
    26.796    27.536     0.200
    26.961    27.755     0.200
    26.967    26.904     0.200
    26.953    28.245     0.200
    26.953    27.403     0.200
    26.953    28.952     0.200
    27.448    27.205     0.200
    27.448    26.423     0.200
    27.547    25.346     0.200
    27.669    26.575     0.200
    27.765    26.382     0.200
    27.765    27.023     0.200
    27.831    26.996     0.200
    27.931    26.966     0.200
    28.097    26.044     0.200
    28.185    24.429     0.200
    28.228    24.167     0.200
    28.298    24.705     0.200
    28.372    25.220     0.200
    28.543    23.549     0.200
    28.568    23.454     0.200
    28.586    23.824     0.200
    28.586    23.979     0.200
    28.586    23.449     0.200
    28.593    23.861     0.200
    28.596    23.424     0.200
    28.643    23.283     0.200
    28.650    23.295     0.200
    28.667    23.204     0.200
    28.686    23.179     0.200
    28.721    23.069     0.200
    28.727    24.450     0.200
    28.888    23.445     0.200
    28.863    24.789     0.200
    28.863    22.809     0.200
    28.867    25.067     0.200
    28.877    23.456     0.200
    28.914    24.283     0.200
    28.914    24.315     0.200
    28.914    24.847     0.200
    29.088    25.370     0.200
    29.208    21.872     0.200
    29.202    21.456     0.200
    29.265    22.626     0.200
    29.265    22.417     0.200
    29.342    24.370     0.200
    29.342    23.469     0.200
    29.342    24.680     0.200
    29.465    20.659     0.200
    29.594    19.822     0.200
    29.802    21.879     0.200
    17.209    41.895     0.200
    17.273    42.147     0.200
    17.509    43.397     0.200
    19.392    40.973     0.200
    19.396    39.184     0.200
    19.396    41.043     0.200
    19.458    39.430     0.200
    19.458    39.029     0.200
    19.670    39.681     0.200
    19.635    39.290     0.200
    19.635    38.890     0.200
    19.635    39.490     0.200
    19.635    39.099     0.200
    20.094    39.780     0.200
    20.201    40.265     0.200
    20.201    39.574     0.200
    20.201    39.775     0.200
    20.377    39.790     0.200
    20.518    38.386     0.200
    20.784    39.939     0.200
    20.819    39.995     0.200
    20.912    39.644     0.200
    21.124    36.885     0.200
    21.306    37.884     0.200
    21.255    39.868     0.200
    21.488    37.964     0.200
    21.911    39.922     0.200
    21.963    38.924     0.200
    21.920    38.894     0.200
    21.920    38.115     0.200
    22.245    38.223     0.200
    22.542    38.564     0.200
    22.697    36.389     0.200
    23.018    37.012     0.200
    23.021    38.416     0.200
    23.021    37.076     0.200
    23.021    38.777     0.200
    23.021    38.777     0.200
    23.021    38.416     0.200
    23.268    36.785     0.200
    23.284    36.503     0.200
    23.550    38.643     0.200
    25.225    31.481     0.200
    25.185    31.819     0.200
    25.185    31.895     0.200
    25.185    31.509     0.200
    25.386    32.621     0.200
    25.386    33.269     0.200
    25.988    31.097     0.200
    26.928    30.081     0.200
    26.982    28.983     0.200
    26.982    27.649     0.200
    27.769    27.936     0.200
    28.558    23.150     0.200
    28.584    23.156     0.200
    28.601    23.059     0.200
    28.601    23.797     0.200
    28.601    23.047     0.200
    28.601    22.348     0.200
    28.608    23.258     0.200
    28.608    22.967     0.200
    28.608    23.447     0.200
    28.612    23.023     0.200
    28.666    22.898     0.200
    28.702    22.777     0.200
    28.737    22.668     0.200
    29.215    21.382     0.200
    29.345    24.112     0.200
    29.345    22.741     0.200
    29.345    21.122     0.200
    14.892    41.602     0.200
    15.071    42.215     0.200
    16.026    44.147     0.200
    16.211    41.439     0.200
    16.423    41.754     0.200
    16.752    43.380     0.200
    17.070    43.210     0.200
    17.441    42.215     0.200
    17.505    41.983     0.200
    17.805    42.650     0.200
    18.822    40.430     0.200
    19.170    40.449     0.200
    19.374    41.633     0.200
    19.378    39.737     0.200
    19.451    40.324     0.200
    19.451    39.730     0.200
    19.451    39.863     0.200
    19.627    40.317     0.200
    19.627    39.919     0.200
    19.627    40.397     0.200
    19.627    39.708     0.200
    19.627    39.919     0.200
    19.685    40.543     0.200
    19.799    38.714     0.200
    20.081    40.729     0.200
    20.081    41.424     0.200
    20.081    40.620     0.200
    20.188    40.294     0.200
    20.188    39.513     0.200
    20.188    41.349     0.200
    20.188    40.773     0.200
    20.188    40.058     0.200
    20.210    40.357     0.200
    20.361    41.150     0.200
    20.476    41.612     0.200
    20.467    40.611     0.200
    20.524    40.006     0.200
    20.533    38.949     0.200
    20.802    40.326     0.200
    20.893    40.982     0.200
    21.044    41.759     0.200
    21.075    38.127     0.200
    21.139    38.064     0.200
    21.139    38.458     0.200
    21.238    40.573     0.200
    21.286    40.864     0.200
    21.322    37.745     0.200
    21.481    38.688     0.200
    21.584    40.429     0.200
    21.809    40.393     0.200
    21.897    39.751     0.200
    21.897    39.634     0.200
    21.897    39.033     0.200
    21.897    38.831     0.200
    21.897    39.533     0.200
    21.897    39.853     0.200
    21.926    38.587     0.200
    21.960    39.285     0.200
    22.016    38.547     0.200
    22.022    40.327     0.200
    22.022    39.676     0.200
    22.064    38.587     0.200
    22.200    40.069     0.200
    22.223    39.023     0.200
    22.281    39.972     0.200
    22.281    39.412     0.200
    22.405    39.027     0.200
    22.464    40.110     0.200
    22.557    36.623     0.200
    22.720    36.209     0.200
    22.986    38.108     0.200
    23.000    37.462     0.200
    23.003    37.694     0.200
    23.003    38.257     0.200
    23.003    38.001     0.200
    23.003    38.134     0.200
    23.070    37.914     0.200
    23.250    39.600     0.200
    23.275    38.492     0.200
    23.275    38.691     0.200
    23.275    36.851     0.200
    23.283    37.653     0.200
    23.326    37.152     0.200
    23.397    37.607     0.200
    23.397    37.486     0.200
    23.397    36.826     0.200
    23.532    37.709     0.200
    23.533    37.819     0.200
    23.573    37.174     0.200
    23.580    37.092     0.200
    23.662    37.077     0.200
    23.662    37.194     0.200
    23.662    36.710     0.200
    23.662    37.434     0.200
    23.753    38.058     0.200
    24.025    36.368     0.200
    24.058    36.313     0.200
    24.203    35.132     0.200
    24.290    35.406     0.200
    24.497    35.026     0.200
    24.529    34.949     0.200
    24.604    34.241     0.200
    24.674    35.140     0.200
    25.172    33.835     0.200
    25.172    32.775     0.200
    25.172    32.720     0.200
    25.208    34.251     0.200
    25.237    32.532     0.200
    25.237    33.391     0.200
    25.362    33.189     0.200
    25.416    32.867     0.200
    25.416    32.735     0.200
    25.416    32.467     0.200
    25.461    31.705     0.200
    25.501    32.400     0.200
    25.972    31.034     0.200
    26.107    34.226     0.200
    26.143    31.005     0.200
    26.265    29.120     0.200
    26.578    30.301     0.200
    26.572    29.978     0.200
    26.603    30.397     0.200
    26.711    28.017     0.200
    26.843    29.405     0.200
    26.860    29.863     0.200
    26.903    30.007     0.200
    26.937    27.910     0.200
    26.958    29.090     0.200
    26.958    28.873     0.200
    26.958    29.268     0.200
    26.958    28.272     0.200
    26.958    28.768     0.200
    26.997    28.528     0.200
    27.154    29.038     0.200
    27.182    28.814     0.200
    27.174    29.315     0.200
    27.213    28.806     0.200
    27.273    29.021     0.200
    27.278    28.337     0.200
    27.279    28.423     0.200
    27.378    28.605     0.200
    27.429    27.982     0.200
    27.429    27.719     0.200
    27.429    26.869     0.200
    27.429    27.869     0.200
    27.455    26.267     0.200
    27.455    26.068     0.200
    27.459    27.921     0.200
    27.455    26.466     0.200
    27.477    28.610     0.200
    27.477    28.411     0.200
    27.517    26.149     0.200
    27.517    26.569     0.200
    27.642    27.243     0.200
    27.642    27.018     0.200
    27.748    26.692     0.200
    27.811    27.177     0.200
    27.914    26.845     0.200
    27.911    25.410     0.200
    27.939    26.855     0.200
    27.985    26.478     0.200
    27.985    26.677     0.200
    28.059    24.880     0.200
    28.075    26.771     0.200
    28.083    28.339     0.200
    28.084    25.425     0.200
    28.148    26.638     0.200
    28.173    24.436     0.200
    28.190    26.418     0.200
    28.162    25.307     0.200
    28.214    26.409     0.200
    28.210    24.899     0.200
    28.223    25.419     0.200
    28.286    25.270     0.200
    28.265    24.803     0.200
    28.338    24.408     0.200
    28.349    25.777     0.200
    28.507    26.355     0.200
    28.535    23.858     0.200
    28.547    25.650     0.200
    28.561    23.865     0.200
    28.559    26.030     0.200
    28.518    25.261     0.200
    28.578    24.107     0.200
    28.578    23.988     0.200
    28.578    23.757     0.200
    28.578    24.257     0.200
    28.585    24.347     0.200
    28.585    23.988     0.200
    28.585    23.677     0.200
    28.589    23.731     0.200
    28.589    25.162     0.200
    28.602    26.258     0.200
    28.635    23.592     0.200
    28.636    25.284     0.200
    28.643    23.606     0.200
    28.638    24.360     0.200
    28.659    23.513     0.200
    28.671    24.964     0.200
    28.679    23.487     0.200
    28.694    23.314     0.200
    28.707    24.934     0.200
    28.714    23.378     0.200
    28.779    24.364     0.200
    28.773    24.912     0.200
    28.773    23.902     0.200
    28.773    25.172     0.200
    28.803    25.705     0.200
    28.831    25.156     0.200
    28.847    24.768     0.200
    28.847    22.928     0.200
    28.847    24.934     0.200
    28.849    25.402     0.200
    28.850    25.837     0.200
    28.851    25.157     0.200
    28.852    23.735     0.200
    28.897    24.635     0.200
    28.897    24.776     0.200
    28.905    22.563     0.200
    28.920    22.188     0.200
    28.987    24.937     0.200
    29.019    22.138     0.200
    29.059    23.251     0.200
    29.044    23.122     0.200
    29.070    25.383     0.200
    29.073    23.142     0.200
    29.085    23.193     0.200
    29.149    22.341     0.200
    29.149    22.091     0.200
    29.164    22.990     0.200
    29.193    22.088     0.200
    29.214    23.444     0.200
    29.272    22.565     0.200
    29.240    22.944     0.200
    29.237    21.993     0.200
    29.240    23.082     0.200
    29.240    22.551     0.200
    29.250    24.268     0.200
    29.245    22.176     0.200
    29.275    24.035     0.200
    29.292    23.034     0.200
    29.324    24.278     0.200
    29.324    23.177     0.200
    29.344    22.229     0.200
    29.344    23.229     0.200
    29.433    21.332     0.200
    29.433    21.037     0.200
    29.423    21.759     0.200
    29.483    21.992     0.200
    29.516    20.760     0.200
    29.562    20.024     0.200
    29.562    19.581     0.200
    29.584    23.485     0.200
    29.593    20.016     0.200
    29.492    23.303     0.200
    29.604    19.685     0.200
    29.657    19.761     0.200
    29.762    19.619     0.200
    29.785    21.904     0.200
    29.811    20.977     0.200
    29.869    21.492     0.200
    29.892    20.332     0.200
    29.892    21.133     0.200
    29.859    20.524     0.200
    29.872    22.036     0.200
    19.401    40.837     0.200
    19.689    39.254     0.200
    20.129    39.525     0.200
    20.236    38.454     0.200
    22.775    36.032     0.200
    22.929    38.149     0.200
    22.929    38.674     0.200
    22.929    37.578     0.200
    25.221    31.090     0.200
    26.187    28.526     0.200
    14.253    41.212     0.200
    14.397    41.564     0.200
    14.422    43.145     0.200
    14.738    41.833     0.200
    14.738    41.497     0.200
    14.964    41.399     0.200
    16.820    43.472     0.200
    17.006    42.511     0.200
    18.433    40.283     0.200
    18.890    40.423     0.200
    19.091    39.604     0.200
    19.320    39.490     0.200
    19.324    39.628     0.200
    19.324    40.720     0.200
    19.365    38.965     0.200
    19.365    40.321     0.200
    19.381    41.221     0.200
    19.541    39.163     0.200
    19.541    39.353     0.200
    19.541    39.652     0.200
    19.541    39.353     0.200
    19.541    38.863     0.200
    19.541    39.251     0.200
    19.605    40.314     0.200
    19.720    39.067     0.200
    20.007    39.691     0.200
    20.007    39.128     0.200
    20.007    40.017     0.200
    20.114    39.675     0.200
    20.114    39.800     0.200
    20.114    39.150     0.200
    20.114    40.021     0.200
    20.452    38.220     0.200
    20.440    40.382     0.200
    20.439    40.542     0.200
    20.637    38.007     0.200
    20.842    40.670     0.200
    20.880    40.279     0.200
    20.880    39.469     0.200
    20.995    37.692     0.200
    21.058    38.129     0.200
    21.058    37.690     0.200
    21.058    36.651     0.200
    21.241    37.513     0.200
    21.394    38.330     0.200
    21.312    40.197     0.200
    21.340    40.262     0.200
    21.644    40.564     0.200
    21.773    39.658     0.200
    21.845    37.164     0.200
    21.868    39.535     0.200
    21.874    38.464     0.200
    21.874    37.804     0.200
    21.874    38.234     0.200
    21.874    38.634     0.200
    22.090    37.615     0.200
    22.103    39.806     0.200
    22.111    40.748     0.200
    22.111    39.020     0.200
    22.195    38.088     0.200
    22.289    40.540     0.200
    22.382    37.831     0.200
    22.371    40.282     0.200
    22.371    39.922     0.200
    22.477    36.388     0.200
    22.608    36.874     0.200
    22.679    36.904     0.200
    22.828    40.155     0.200
    23.052    38.372     0.200
    23.072    37.351     0.200
    23.075    38.273     0.200
    23.075    37.486     0.200
    23.075    37.717     0.200
    23.075    37.916     0.200
    23.075    36.676     0.200
    23.201    36.939     0.200
    23.138    37.605     0.200
    23.356    36.933     0.200
    23.367    38.011     0.200
    23.367    37.261     0.200
    23.367    37.011     0.200
    23.461    37.286     0.200
    23.480    36.094     0.200
    23.480    36.773     0.200
    23.608    36.890     0.200
    23.606    36.581     0.200
    23.629    35.948     0.200
    23.734    37.331     0.200
    23.734    36.507     0.200
    23.734    38.235     0.200
    23.734    37.985     0.200
    23.820    38.476     0.200
    23.942    36.252     0.200
    23.973    35.929     0.200
    24.125    36.038     0.200
    24.316    34.933     0.200
    24.472    35.034     0.200
    24.629    35.077     0.200
    24.683    35.741     0.200
    25.098    31.204     0.200
    25.098    31.825     0.200
    25.098    32.112     0.200
    25.098    31.961     0.200
    25.098    31.291     0.200
    25.149    32.680     0.200
    25.149    32.317     0.200
    25.149    33.067     0.200
    25.278    34.509     0.200
    25.356    32.397     0.200
    25.447    32.842     0.200
    25.446    33.997     0.200
    25.452    32.040     0.200
    25.493    33.000     0.200
    25.493    31.994     0.200
    25.493    31.379     0.200
    25.493    32.359     0.200
    25.533    31.785     0.200
    26.027    33.904     0.200
    26.051    30.259     0.200
    26.345    29.375     0.200
    26.385    29.282     0.200
    26.487    30.350     0.200
    26.749    28.737     0.200
    26.788    30.400     0.200
    26.914    28.123     0.200
    26.922    29.217     0.200
    26.980    28.047     0.200
    26.980    28.187     0.200
    26.980    27.627     0.200
    26.980    28.656     0.200
    27.013    27.442     0.200
    27.137    29.987     0.200
    27.215    29.469     0.200
    27.275    29.353     0.200
    27.336    29.008     0.200
    27.490    26.620     0.200
    27.490    26.483     0.200
    27.490    26.723     0.200
    27.490    27.194     0.200
    27.490    27.993     0.200
    27.530    26.823     0.200
    27.535    24.941     0.200
    27.535    26.265     0.200
    27.535    27.044     0.200
    27.540    27.910     0.200
    27.540    27.111     0.200
    27.594    26.961     0.200
    27.594    25.231     0.200
    27.709    27.597     0.200
    27.714    26.872     0.200
    27.806    25.490     0.200
    27.806    27.600     0.200
    27.867    27.992     0.200
    27.875    27.559     0.200
    27.971    28.156     0.200
    27.997    28.073     0.200
    27.989    26.149     0.200
    28.137    24.644     0.200
    28.180    25.041     0.200
    28.141    27.030     0.200
    28.138    24.456     0.200
    28.282    25.363     0.200
    28.336    26.016     0.200
    28.414    23.916     0.200
    28.578    23.896     0.200
    28.603    23.800     0.200
    28.621    22.721     0.200
    28.621    23.096     0.200
    28.621    23.795     0.200
    28.621    23.195     0.200
    28.628    22.843     0.200
    28.628    22.486     0.200
    28.628    23.714     0.200
    28.628    23.234     0.200
    28.628    23.515     0.200
    28.631    23.772     0.200
    28.653    24.698     0.200
    28.660    26.394     0.200
    28.678    23.628     0.200
    28.685    23.540     0.200
    28.702    23.552     0.200
    28.721    23.524     0.200
    28.711    25.348     0.200
    28.756    23.417     0.200
    28.841    23.408     0.200
    28.770    25.266     0.200
    28.768    22.765     0.200
    28.827    25.243     0.200
    28.861    26.349     0.200
    28.889    25.596     0.200
    28.856    25.163     0.200
    28.856    22.796     0.200
    28.856    24.231     0.200
    28.856    25.407     0.200
    28.904    23.522     0.200
    28.904    22.991     0.200
    28.904    24.891     0.200
    28.908    24.724     0.200
    28.908    25.741     0.200
    28.909    25.037     0.200
    28.922    23.200     0.200
    28.922    21.984     0.200
    28.955    24.599     0.200
    28.954    24.334     0.200
    28.981    22.003     0.200
    29.081    22.806     0.200
    29.161    21.874     0.200
    29.123    24.135     0.200
    29.129    25.096     0.200
    29.138    23.789     0.200
    29.218    24.871     0.200
    29.238    22.088     0.200
    29.230    22.838     0.200
    29.341    21.877     0.200
    29.307    23.282     0.200
    29.339    22.812     0.200
    29.310    22.265     0.200
    29.310    22.015     0.200
    29.310    21.435     0.200
    29.333    24.235     0.200
    29.382    22.896     0.200
    29.382    21.826     0.200
    29.382    23.707     0.200
    29.511    20.580     0.200
    29.614    20.414     0.200
    29.644    23.427     0.200
    29.641    20.521     0.200
    29.556    24.281     0.200
    29.842    21.915     0.200
    29.844    20.738     0.200
    14.741    40.844     0.200
    16.747    43.434     0.200
    17.243    43.240     0.200
    17.305    43.422     0.200
    17.540    43.580     0.200
    17.818    43.632     0.200
    19.315    39.291     0.200
    19.319    39.955     0.200
    19.359    38.847     0.200
    19.359    39.419     0.200
    19.535    39.939     0.200
    19.535    40.490     0.200
    19.535    39.240     0.200
    19.535    38.750     0.200
    19.535    40.689     0.200
    20.002    39.901     0.200
    20.108    37.944     0.200
    20.108    40.788     0.200
    20.845    38.312     0.200
    20.883    37.841     0.200
    21.870    38.359     0.200
    21.870    37.481     0.200
    21.870    39.242     0.200
    21.870    39.621     0.200
    21.862    39.640     0.200
    22.191    39.200     0.200
    22.679    35.836     0.200
    23.078    36.663     0.200
    23.078    39.153     0.200
    23.078    37.632     0.200
    23.078    36.772     0.200
    23.078    39.052     0.200
    23.968    36.466     0.200
    25.092    32.820     0.200
    25.145    31.434     0.200
    28.621    23.213     0.200
    28.621    24.357     0.200
    19.434    39.979     0.200
    19.611    39.654     0.200
    19.311    40.797     0.200
    19.978    40.768     0.200
    20.085    39.303     0.200
    28.683    22.839     0.200
    19.341    40.561     0.200
    19.346    38.921     0.200
    19.399    38.959     0.200
    19.575    38.556     0.200
    19.575    38.368     0.200
    20.037    39.673     0.200
    20.143    38.310     0.200
    21.883    37.467     0.200
    17.296    42.452     0.200
    19.311    41.242     0.200
    19.359    38.968     0.200
    19.359    39.136     0.200
    19.536    39.617     0.200
    19.536    40.718     0.200
    19.536    40.742     0.200
    19.536    40.168     0.200
    20.000    41.052     0.200
    20.107    39.677     0.200
    20.107    39.857     0.200
    21.062    38.478     0.200
    21.245    38.469     0.200
    21.308    38.629     0.200
    21.389    38.896     0.200
    21.849    39.024     0.200
    21.864    38.249     0.200
    21.864    39.340     0.200
    21.864    39.117     0.200
    21.864    38.945     0.200
    21.864    37.746     0.200
    21.864    39.219     0.200
    22.101    38.506     0.200
    22.481    38.146     0.200
    22.687    35.312     0.200
    23.067    38.007     0.200
    23.070    36.332     0.200
    23.070    37.973     0.200
    23.070    37.871     0.200
    23.070    38.422     0.200
    23.070    36.672     0.200
    23.477    35.859     0.200
    23.601    39.203     0.200
    23.967    35.198     0.200
    25.151    31.353     0.200
    25.151    33.502     0.200
    25.090    32.498     0.200
    25.090    32.873     0.200
    25.090    32.467     0.200
    25.346    33.435     0.200
    26.913    30.422     0.200
    26.971    28.848     0.200
    28.613    23.888     0.200
    28.613    23.107     0.200
    28.613    23.685     0.200
    28.613    22.486     0.200
    28.620    23.534     0.200
    28.620    23.776     0.200
    28.620    23.186     0.200
    28.620    23.335     0.200
    28.748    23.106     0.200
    14.674    41.344     0.200
    14.674    41.758     0.200
    14.674    41.242     0.200
    17.180    42.010     0.200
    17.494    43.096     0.200
    18.091    42.460     0.200
    18.421    41.326     0.200
    18.876    39.550     0.200
    19.158    40.835     0.200
    19.322    39.468     0.200
    19.326    40.399     0.200
    19.326    39.732     0.200
    19.400    39.726     0.200
    19.400    39.191     0.200
    19.319    41.051     0.200
    19.331    41.326     0.200
    19.576    40.149     0.200
    19.576    39.348     0.200
    19.576    39.848     0.200
    19.576    39.949     0.200
    19.576    39.289     0.200
    19.659    40.980     0.200
    20.028    40.627     0.200
    20.135    41.112     0.200
    20.135    39.659     0.200
    20.135    41.230     0.200
    20.135    40.679     0.200
    20.519    39.248     0.200
    20.661    37.552     0.200
    20.776    40.199     0.200
    20.814    40.058     0.200
    20.898    41.228     0.200
    21.125    38.331     0.200
    21.308    39.541     0.200
    21.246    39.082     0.200
    21.430    38.216     0.200
    21.852    39.478     0.200
    21.852    38.142     0.200
    21.852    39.251     0.200
    21.914    38.532     0.200
    21.912    39.595     0.200
    22.039    38.405     0.200
    22.038    39.572     0.200
    22.177    38.900     0.200
    22.544    38.219     0.200
    22.736    36.214     0.200
    22.762    39.539     0.200
    23.006    37.723     0.200
    23.009    39.181     0.200
    23.009    37.790     0.200
    23.009    37.688     0.200
    23.009    38.489     0.200
    23.009    39.833     0.200
    23.009    39.142     0.200
    23.009    37.900     0.200
    23.304    36.846     0.200
    23.304    37.453     0.200
    23.414    37.261     0.200
    23.557    35.695     0.200
    23.540    38.385     0.200
    23.567    37.678     0.200
    23.668    37.869     0.200
    23.668    37.099     0.200
    23.668    38.818     0.200
    24.006    36.649     0.200
    24.266    35.324     0.200
    25.119    32.741     0.200
    25.119    31.964     0.200
    25.119    32.764     0.200
    25.119    32.354     0.200
    25.119    32.663     0.200
    25.215    31.939     0.200
    25.215    33.209     0.200
    25.212    34.261     0.200
    25.323    33.280     0.200
    25.985    30.028     0.200
    26.809    29.550     0.200
    26.876    30.466     0.200
    26.932    28.014     0.200
    26.932    28.295     0.200
    26.932    28.115     0.200
    27.273    28.327     0.200
    27.743    25.679     0.200
    28.276    25.125     0.200
    28.521    24.168     0.200
    28.546    24.073     0.200
    28.563    23.895     0.200
    28.563    23.571     0.200
    28.563    23.770     0.200
    28.563    24.071     0.200
    28.563    23.367     0.200
    28.570    23.939     0.200
    28.570    23.377     0.200
    28.570    23.767     0.200
    28.570    24.287     0.200
    28.574    24.043     0.200
    28.621    23.905     0.200
    28.628    23.915     0.200
    28.644    23.825     0.200
    28.664    23.798     0.200
    28.699    23.690     0.200
    28.841    24.437     0.200
    28.841    23.327     0.200
    28.892    24.735     0.200
    29.074    23.424     0.200
    29.244    22.593     0.200
    29.244    21.824     0.200
    29.320    23.915     0.200
    29.320    21.774     0.200
    29.320    23.645     0.200
    29.475    22.524     0.200
    29.581    22.794     0.200
    29.780    21.663     0.200
    19.553    40.140     0.200
    21.895    38.380     0.200
    21.895    37.607     0.200
    25.113    31.707     0.200
    19.610    39.979     0.200
    20.084    40.923     0.200
    25.174    31.721     0.200
    19.597    40.176     0.200
    19.341    40.111     0.200
    19.559    40.136     0.200
    20.027    40.624     0.200
    21.894    38.883     0.200
    23.078    37.647     0.200
    25.117    33.220     0.200
    28.632    22.209     0.200
    17.273    43.252     0.200
    19.350    40.515     0.200
    19.354    39.344     0.200
    19.354    40.407     0.200
    19.413    38.872     0.200
    19.413    37.989     0.200
    19.413    39.568     0.200
    19.590    39.938     0.200
    19.590    39.410     0.200
    19.590    40.387     0.200
    19.590    38.539     0.200
    20.155    40.591     0.200
    20.155    38.911     0.200
    20.155    40.103     0.200
    20.155    40.310     0.200
    20.155    39.962     0.200
    20.798    38.966     0.200
    21.443    37.085     0.200
    21.920    39.017     0.200
    21.886    39.387     0.200
    21.886    38.817     0.200
    21.886    39.048     0.200
    23.033    37.621     0.200
    23.033    38.383     0.200
    23.033    37.512     0.200
    24.021    36.499     0.200
    25.139    32.872     0.200
    25.139    30.896     0.200
    25.358    32.745     0.200
    25.358    34.292     0.200
    28.595    23.639     0.200
    28.602    23.445     0.200
    28.602    22.996     0.200
    19.530    39.554     0.200
    20.013    38.600     0.200
    25.103    31.323     0.200
    19.563    39.931     0.200
    20.035    40.124     0.200
    23.092    36.904     0.200
    25.125    32.145     0.200
    19.347    41.525     0.200
    19.583    39.651     0.200
    20.043    40.328     0.200
    25.134    32.021     0.200
    19.374    40.179     0.200
    19.634    39.457     0.200
    20.085    39.965     0.200
    21.892    39.500     0.200
    25.176    32.003     0.200
    15.777    42.290     0.200
    16.416    41.401     0.200
    17.514    42.117     0.200
    19.389    40.185     0.200
    19.393    39.190     0.200
    19.393    39.987     0.200
    19.393    39.729     0.200
    19.452    39.289     0.200
    19.452    39.016     0.200
    19.452    40.469     0.200
    19.629    39.566     0.200
    19.629    39.340     0.200
    19.629    40.215     0.200
    19.629    39.059     0.200
    20.089    40.919     0.200
    20.196    40.892     0.200
    20.196    38.502     0.200
    20.196    40.432     0.200
    20.196    41.017     0.200
    20.791    39.319     0.200
    20.825    39.421     0.200
    21.262    39.397     0.200
    21.482    38.012     0.200
    21.919    38.399     0.200
    21.919    38.712     0.200
    21.919    38.978     0.200
    23.027    37.156     0.200
    23.027    38.578     0.200
    23.027    38.430     0.200
    23.027    38.289     0.200
    23.556    39.044     0.200
    24.060    35.623     0.200
    25.180    32.533     0.200
    25.180    31.479     0.200
    25.218    32.577     0.200
    25.218    32.912     0.200
    25.387    33.536     0.200
    25.995    30.271     0.200
    26.985    29.093     0.200
    28.606    23.074     0.200
    28.613    23.541     0.200
    19.418    40.599     0.200
    20.111    40.639     0.200
    15.078    41.419     0.200
    19.382    40.257     0.200
    19.400    40.085     0.200
    19.576    40.067     0.200
    19.576    39.483     0.200
    20.056    39.667     0.200
    20.163    40.865     0.200
    20.884    38.647     0.200
    21.888    38.811     0.200
    21.946    38.205     0.200
    21.946    38.617     0.200
    23.119    37.394     0.200
    23.119    37.765     0.200
    23.649    38.475     0.200
    25.146    32.145     0.200
    25.146    31.725     0.200
    26.089    30.665     0.200
    28.685    23.522     0.200
    28.692    23.786     0.200
    28.692    23.456     0.200
    20.068    39.698     0.200
    21.966    38.060     0.200
    23.135    35.124     0.200
    25.157    30.479     0.200
    19.330    38.991     0.200
    19.547    39.098     0.200
    21.886    39.041     0.200
    25.106    31.576     0.200
    18.122    41.776     0.200
    19.328    40.402     0.200
    19.555    40.049     0.200
    20.019    39.513     0.200
    21.877    38.450     0.200
    25.109    31.505     0.200
    19.400    40.828     0.200
    19.611    39.819     0.200
    20.084    38.720     0.200
    25.175    32.330     0.200
    19.415    40.779     0.200
    19.604    40.866     0.200
    20.087    40.676     0.200
    25.177    31.312     0.200
    17.238    41.836     0.200
    17.474    43.430     0.200
    19.407    40.824     0.200
    19.411    39.014     0.200
    19.411    40.725     0.200
    19.411    39.885     0.200
    19.493    39.365     0.200
    19.493    39.057     0.200
    19.670    39.479     0.200
    19.670    39.804     0.200
    19.670    39.757     0.200
    19.670    39.456     0.200
    20.121    40.691     0.200
    20.227    38.544     0.200
    20.227    40.294     0.200
    20.227    40.395     0.200
    20.227    39.376     0.200
    21.169    38.401     0.200
    21.351    39.180     0.200
    21.523    37.576     0.200
    21.603    39.640     0.200
    21.918    39.565     0.200
    21.918    38.741     0.200
    21.918    39.671     0.200
    21.918    39.132     0.200
    21.956    40.615     0.200
    22.003    38.275     0.200
    22.587    38.261     0.200
    22.978    37.784     0.200
    22.978    38.995     0.200
    22.978    37.445     0.200
    22.978    38.246     0.200
    22.978    39.496     0.200
    24.100    35.704     0.200
    25.212    31.975     0.200
    25.212    31.534     0.200
    25.271    31.641     0.200
    25.271    33.109     0.200
    25.376    33.609     0.200
    28.570    23.979     0.200
    28.570    22.401     0.200
    28.570    22.740     0.200
    18.118    41.784     0.200
    19.327    39.468     0.200
    19.331    41.127     0.200
    19.381    40.425     0.200
    19.557    39.869     0.200
    20.020    40.957     0.200
    21.873    38.192     0.200
    21.873    39.099     0.200
    23.056    38.300     0.200
    25.110    32.049     0.200
    28.607    22.999     0.200
    17.279    42.049     0.200
    18.949    41.010     0.200
    19.319    39.574     0.200
    19.323    39.348     0.200
    19.323    39.598     0.200
    19.323    40.147     0.200
    19.344    39.460     0.200
    19.344    39.710     0.200
    19.344    38.473     0.200
    19.521    39.244     0.200
    19.521    39.795     0.200
    19.521    40.795     0.200
    19.521    40.295     0.200
    19.521    39.784     0.200
    19.755    41.161     0.200
    19.995    40.484     0.200
    20.102    39.593     0.200
    20.102    38.763     0.200
    20.102    38.126     0.200
    20.102    40.831     0.200
    20.479    38.341     0.200
    20.623    38.190     0.200
    20.882    38.401     0.200
    20.920    38.580     0.200
    21.003    39.123     0.200
    21.018    38.239     0.200
    21.373    38.179     0.200
    21.352    38.439     0.200
    21.887    39.343     0.200
    21.887    37.935     0.200
    21.887    39.074     0.200
    22.120    37.855     0.200
    22.206    39.656     0.200
    22.143    38.889     0.200
    22.151    39.972     0.200
    22.151    37.661     0.200
    22.410    40.798     0.200
    22.645    35.916     0.200
    23.112    38.585     0.200
    23.115    37.050     0.200
    23.115    37.350     0.200
    23.115    38.499     0.200
    23.115    37.011     0.200
    23.115    39.149     0.200
    23.388    35.961     0.200
    23.520    36.646     0.200
    23.520    36.476     0.200
    23.640    36.224     0.200
    23.667    37.606     0.200
    23.646    37.621     0.200
    23.774    36.690     0.200
    23.954    36.256     0.200
    24.347    34.075     0.200
    25.085    32.659     0.200
    25.085    32.508     0.200
    25.110    32.976     0.200
    26.951    27.782     0.200
    27.009    28.501     0.200
    27.009    29.091     0.200
    28.613    23.486     0.200
    28.638    23.791     0.200
    28.656    23.538     0.200
    28.656    23.488     0.200
    28.663    23.487     0.200
    28.663    22.827     0.200
    28.663    23.377     0.200
    28.666    23.263     0.200
    28.756    23.217     0.200
    29.274    21.773     0.200
    29.349    21.781     0.200
    29.421    23.941     0.200
    14.752    45.057     0.200
    17.259    41.906     0.200
    18.918    41.382     0.200
    19.344    40.176     0.200
    19.348    38.363     0.200
    19.348    39.324     0.200
    19.348    39.753     0.200
    19.382    38.973     0.200
    19.382    38.286     0.200
    19.382    39.673     0.200
    19.398    41.145     0.200
    19.558    39.952     0.200
    19.558    40.577     0.200
    19.558    39.777     0.200
    19.558    39.198     0.200
    19.597    40.725     0.200
    20.028    40.143     0.200
    20.028    38.917     0.200
    20.135    40.545     0.200
    20.135    38.967     0.200
    20.135    39.846     0.200
    20.199    41.418     0.200
    20.445    39.229     0.200
    21.050    39.428     0.200
    21.233    38.722     0.200
    21.323    39.968     0.200
    21.410    37.857     0.200
    21.838    38.771     0.200
    21.900    39.091     0.200
    21.900    37.849     0.200
    21.900    38.748     0.200
    22.112    38.168     0.200
    22.114    39.854     0.200
    22.114    39.475     0.200
    22.291    40.028     0.200
    22.469    39.702     0.200
    22.659    37.573     0.200
    23.086    38.298     0.200
    23.086    38.451     0.200
    23.086    37.939     0.200
    23.086    39.001     0.200
    23.378    36.097     0.200
    23.367    37.876     0.200
    23.367    37.727     0.200
    23.487    37.258     0.200
    23.630    37.448     0.200
    23.617    38.890     0.200
    23.646    38.873     0.200
    23.745    37.017     0.200
    23.991    35.846     0.200
    24.338    34.590     0.200
    25.118    32.490     0.200
    25.118    32.190     0.200
    25.118    32.088     0.200
    25.146    33.128     0.200
    25.381    32.668     0.200
    25.381    32.516     0.200
    26.060    30.275     0.200
    26.753    29.714     0.200
    26.946    29.560     0.200
    27.003    28.562     0.200
    27.003    28.894     0.200
    28.598    24.083     0.200
    28.623    23.488     0.200
    28.640    23.583     0.200
    28.640    22.622     0.200
    28.640    23.083     0.200
    28.640    22.884     0.200
    28.647    23.604     0.200
    28.647    22.882     0.200
    28.647    24.003     0.200
    28.647    23.393     0.200
    28.651    23.458     0.200
    28.741    22.912     0.200
    28.920    24.968     0.200
    29.257    21.084     0.200
    29.322    22.387     0.200
    29.398    24.161     0.200
    29.398    22.883     0.200
    14.773    41.246     0.200
    17.272    42.185     0.200
    17.451    41.686     0.200
    18.016    42.205     0.200
    18.223    42.354     0.200
    19.052    40.012     0.200
    19.248    40.526     0.200
    19.302    40.649     0.200
    19.306    39.768     0.200
    19.306    40.339     0.200
    19.330    39.377     0.200
    19.330    38.385     0.200
    19.330    40.565     0.200
    19.330    39.557     0.200
    19.434    41.560     0.200
    19.489    40.570     0.200
    19.506    39.333     0.200
    19.506    40.110     0.200
    19.506    40.360     0.200
    19.565    41.027     0.200
    19.746    41.710     0.200
    19.979    41.573     0.200
    20.086    40.452     0.200
    20.086    39.799     0.200
    20.086    39.530     0.200
    20.086    41.405     0.200
    20.607    37.904     0.200
    21.019    38.154     0.200
    21.202    39.424     0.200
    21.359    38.492     0.200
    21.370    40.760     0.200
    21.452    39.306     0.200
    21.611    42.299     0.200
    21.806    38.978     0.200
    21.828    39.571     0.200
    21.871    39.687     0.200
    21.871    39.140     0.200
    21.871    39.417     0.200
    22.108    38.246     0.200
    22.145    40.246     0.200
    22.153    39.957     0.200
    22.153    39.571     0.200
    22.189    39.604     0.200
    22.331    39.688     0.200
    22.413    39.369     0.200
    22.413    39.779     0.200
    22.438    38.898     0.200
    22.654    36.822     0.200
    22.654    38.603     0.200
    22.865    40.473     0.200
    23.096    37.865     0.200
    23.109    38.173     0.200
    23.112    38.838     0.200
    23.112    39.287     0.200
    23.112    38.018     0.200
    23.112    38.737     0.200
    23.161    38.057     0.200
    23.377    36.047     0.200
    23.424    35.773     0.200
    23.409    38.206     0.200
    23.409    39.366     0.200
    23.521    36.910     0.200
    23.521    37.090     0.200
    23.521    38.563     0.200
    23.628    38.010     0.200
    23.643    37.795     0.200
    23.660    38.138     0.200
    23.771    37.418     0.200
    23.771    36.227     0.200
    23.902    36.071     0.200
    23.939    36.775     0.200
    24.315    35.814     0.200
    24.335    35.066     0.200
    25.026    32.525     0.200
    25.069    33.196     0.200
    25.069    33.145     0.200
    25.069    32.118     0.200
    25.108    33.703     0.200
    25.314    34.516     0.200
    25.360    33.398     0.200
    25.360    33.195     0.200
    25.531    32.602     0.200
    25.531    32.321     0.200
    25.987    30.418     0.200
    26.384    28.574     0.200
    26.446    29.097     0.200
    26.874    28.145     0.200
    26.938    28.082     0.200
    26.997    29.096     0.200
    26.997    28.928     0.200
    26.997    28.397     0.200
    27.368    28.470     0.200
    27.522    26.866     0.200
    27.575    25.154     0.200
    27.584    27.645     0.200
    27.751    26.803     0.200
    27.838    26.321     0.200
    27.838    27.180     0.200
    28.055    26.347     0.200
    28.096    24.835     0.200
    28.175    27.681     0.200
    28.365    25.632     0.200
    28.603    24.050     0.200
    28.629    23.954     0.200
    28.646    23.973     0.200
    28.646    23.239     0.200
    28.646    23.950     0.200
    28.646    24.149     0.200
    28.653    23.939     0.200
    28.653    23.158     0.200
    28.653    24.268     0.200
    28.653    24.471     0.200
    28.732    23.058     0.200
    28.747    24.967     0.200
    28.802    23.174     0.200
    28.893    25.227     0.200
    28.935    24.647     0.200
    28.935    25.179     0.200
    28.941    26.174     0.200
    28.940    24.318     0.200
    28.986    25.382     0.200
    28.986    25.402     0.200
    29.040    22.458     0.200
    29.120    22.112     0.200
    29.161    25.561     0.200
    29.173    23.740     0.200
    29.249    24.365     0.200
    29.265    22.330     0.200
    29.301    22.535     0.200
    29.346    22.639     0.200
    29.414    23.815     0.200
    29.874    21.497     0.200
    14.793    42.226     0.200
    16.145    43.559     0.200
    16.300    41.161     0.200
    16.873    43.019     0.200
    17.452    41.630     0.200
    17.946    41.824     0.200
    18.265    43.114     0.200
    18.387    42.014     0.200
    18.847    41.306     0.200
    19.048    40.887     0.200
    19.373    40.087     0.200
    19.377    40.136     0.200
    19.377    40.747     0.200
    19.389    39.027     0.200
    19.389    38.807     0.200
    19.389    40.123     0.200
    19.389    39.367     0.200
    19.440    40.806     0.200
    19.558    39.129     0.200
    19.565    38.851     0.200
    19.565    39.768     0.200
    19.565    38.353     0.200
    19.565    39.775     0.200
    19.565    38.924     0.200
    19.565    39.054     0.200
    19.563    39.880     0.200
    20.045    39.599     0.200
    20.045    39.738     0.200
    20.087    39.776     0.200
    20.124    40.062     0.200
    20.152    39.202     0.200
    20.152    39.579     0.200
    20.152    39.772     0.200
    20.152    40.733     0.200
    20.234    40.990     0.200
    20.372    40.253     0.200
    20.402    40.435     0.200
    20.411    38.285     0.200
    20.483    40.819     0.200
    20.556    40.190     0.200
    20.672    37.391     0.200
    20.952    38.065     0.200
    20.943    40.128     0.200
    20.925    40.885     0.200
    21.016    37.078     0.200
    21.016    36.945     0.200
    21.015    40.875     0.200
    21.199    37.681     0.200
    21.360    40.565     0.200
    21.417    37.643     0.200
    21.400    39.837     0.200
    21.451    38.847     0.200
    21.461    37.396     0.200
    21.804    38.422     0.200
    21.848    39.698     0.200
    21.877    38.460     0.200
    21.939    38.707     0.200
    21.939    38.547     0.200
    21.939    39.157     0.200
    22.136    38.423     0.200
    22.158    37.497     0.200
    22.191    36.916     0.200
    22.191    36.586     0.200
    22.141    39.358     0.200
    22.141    39.777     0.200
    22.259    37.919     0.200
    22.318    38.961     0.200
    22.435    36.261     0.200
    22.399    38.916     0.200
    22.399    39.516     0.200
    22.614    35.987     0.200
    22.614    38.017     0.200
    22.876    38.956     0.200
    23.086    37.849     0.200
    23.106    38.738     0.200
    23.161    36.489     0.200
    23.121    37.650     0.200
    23.124    38.216     0.200
    23.124    36.348     0.200
    23.124    38.195     0.200
    23.124    37.115     0.200
    23.124    38.912     0.200
    23.124    38.115     0.200
    23.124    37.515     0.200
    23.153    36.852     0.200
    23.191    38.152     0.200
    23.390    37.732     0.200
    23.390    37.369     0.200
    23.390    37.112     0.200
    23.424    36.323     0.200
    23.424    36.523     0.200
    23.519    36.552     0.200
    23.519    36.812     0.200
    23.519    35.913     0.200
    23.565    36.714     0.200
    23.654    36.973     0.200
    23.676    36.277     0.200
    23.688    37.934     0.200
    23.784    36.432     0.200
    23.784    36.822     0.200
    23.784    36.977     0.200
    23.903    35.692     0.200
    23.873    37.717     0.200
    24.080    34.880     0.200
    24.313    36.559     0.200
    24.384    34.217     0.200
    24.384    34.317     0.200
    24.398    34.584     0.200
    24.413    34.346     0.200
    24.565    34.288     0.200
    24.494    36.675     0.200
    24.915    35.112     0.200
    25.117    32.345     0.200
    25.117    32.099     0.200
    25.117    32.619     0.200
    25.117    32.959     0.200
    25.135    32.583     0.200
    25.135    31.693     0.200
    25.135    30.952     0.200
    25.135    31.802     0.200
    25.135    31.532     0.200
    25.329    33.312     0.200
    25.387    31.813     0.200
    25.377    31.093     0.200
    25.424    32.377     0.200
    25.397    32.078     0.200
    25.538    31.646     0.200
    25.538    31.496     0.200
    25.538    32.596     0.200
    25.583    31.132     0.200
    25.750    31.068     0.200
    25.979    32.037     0.200
    25.985    29.673     0.200
    26.095    29.811     0.200
    26.387    28.528     0.200
    26.387    28.278     0.200
    26.450    28.943     0.200
    26.735    29.378     0.200
    26.875    26.461     0.200
    26.833    27.612     0.200
    26.974    30.025     0.200
    27.048    28.123     0.200
    27.048    29.024     0.200
    27.048    27.863     0.200
    27.048    27.571     0.200
    27.071    29.934     0.200
    27.060    28.611     0.200
    27.189    26.723     0.200
    27.302    25.214     0.200
    27.273    28.982     0.200
    27.303    29.073     0.200
    27.324    29.343     0.200
    27.332    29.340     0.200
    27.360    25.720     0.200
    27.394    27.984     0.200
    27.547    26.553     0.200
    27.547    27.063     0.200
    27.547    27.618     0.200
    27.578    26.829     0.200
    27.578    26.277     0.200
    27.596    27.034     0.200
    27.639    25.988     0.200
    27.764    26.194     0.200
    27.794    27.124     0.200
    27.864    25.628     0.200
    27.864    27.698     0.200
    27.864    26.521     0.200
    27.886    27.747     0.200
    27.924    28.599     0.200
    27.924    27.097     0.200
    27.929    27.795     0.200
    27.930    26.897     0.200
    28.049    25.209     0.200
    28.030    26.819     0.200
    28.034    25.648     0.200
    28.055    25.962     0.200
    28.102    23.999     0.200
    28.105    25.194     0.200
    28.144    24.346     0.200
    28.129    26.657     0.200
    28.200    24.869     0.200
    28.254    23.875     0.200
    28.265    26.839     0.200
    28.296    23.941     0.200
    28.309    25.756     0.200
    28.327    26.620     0.200
    28.332    27.444     0.200
    28.332    26.459     0.200
    28.330    24.918     0.200
    28.398    24.498     0.200
    28.395    26.515     0.200
    28.398    24.871     0.200
    28.426    27.045     0.200
    28.426    25.465     0.200
    28.460    24.057     0.200
    28.493    26.054     0.200
    28.624    26.090     0.200
    28.642    22.419     0.200
    28.661    24.989     0.200
    28.668    23.125     0.200
    28.672    24.247     0.200
    28.675    25.655     0.200
    28.677    25.997     0.200
    28.685    22.944     0.200
    28.685    23.069     0.200
    28.685    23.019     0.200
    28.685    23.119     0.200
    28.692    22.868     0.200
    28.692    24.059     0.200
    28.638    24.569     0.200
    28.692    22.249     0.200
    28.692    23.395     0.200
    28.696    22.794     0.200
    28.737    23.291     0.200
    28.718    26.040     0.200
    28.725    26.377     0.200
    28.742    23.053     0.200
    28.756    25.461     0.200
    28.766    22.675     0.200
    28.798    22.707     0.200
    28.760    23.364     0.200
    28.760    25.847     0.200
    28.760    24.639     0.200
    28.786    22.748     0.200
    28.791    25.181     0.200
    28.790    25.058     0.200
    28.804    25.106     0.200
    28.826    25.054     0.200
    28.829    22.874     0.200
    28.829    23.537     0.200
    28.829    25.427     0.200
    28.878    24.742     0.200
    28.893    24.562     0.200
    28.919    25.111     0.200
    28.947    25.307     0.200
    28.963    23.832     0.200
    28.963    22.682     0.200
    28.963    25.882     0.200
    28.963    24.726     0.200
    28.966    25.343     0.200
    28.967    24.378     0.200
    28.967    25.613     0.200
    28.973    23.809     0.200
    28.973    23.201     0.200
    29.043    21.170     0.200
    29.013    25.033     0.200
    29.013    25.689     0.200
    29.013    24.707     0.200
    29.124    20.962     0.200
    29.083    22.455     0.200
    29.105    24.556     0.200
    29.141    21.930     0.200
    29.178    22.480     0.200
    29.178    21.468     0.200
    29.187    24.784     0.200
    29.277    24.292     0.200
    29.271    22.223     0.200
    29.271    21.670     0.200
    29.302    20.624     0.200
    29.328    22.738     0.200
    29.343    24.712     0.200
    29.392    21.203     0.200
    29.392    21.969     0.200
    29.366    24.609     0.200
    29.362    21.680     0.200
    29.362    21.807     0.200
    29.359    21.048     0.200
    29.413    21.378     0.200
    29.391    24.076     0.200
    29.405    21.731     0.200
    29.441    23.134     0.200
    29.441    22.664     0.200
    29.441    24.604     0.200
    29.441    23.649     0.200
    29.464    21.207     0.200
    29.464    22.028     0.200
    29.556    20.578     0.200
    29.556    20.307     0.200
    29.597    22.221     0.200
    29.638    20.322     0.200
    29.684    19.753     0.200
    29.684    19.527     0.200
    29.702    23.009     0.200
    29.715    19.963     0.200
    29.731    22.677     0.200
    29.779    20.457     0.200
    29.884    18.896     0.200
    15.131    42.945     0.200
    17.393    43.556     0.200
    17.628    42.946     0.200
    17.628    42.217     0.200
    18.191    41.260     0.200
    18.191    40.790     0.200
    19.329    40.763     0.200
    19.334    40.899     0.200
    19.503    39.607     0.200
    19.990    39.852     0.200
    20.097    38.605     0.200
    20.966    39.211     0.200
    20.973    43.742     0.200
    21.813    39.882     0.200
    22.199    41.484     0.200
    22.376    37.816     0.200
    22.594    35.985     0.200
    23.165    38.197     0.200
    23.168    38.253     0.200
    23.168    37.963     0.200
    23.168    38.913     0.200
    23.571    36.655     0.200
    23.699    38.877     0.200
    23.720    38.222     0.200
    23.827    38.522     0.200
    25.061    34.235     0.200
    25.061    33.015     0.200
    25.061    33.625     0.200
    25.079    32.461     0.200
    25.079    32.611     0.200
    25.079    32.951     0.200
    25.079    33.261     0.200
    26.144    30.644     0.200
    26.996    31.889     0.200
    28.707    22.852     0.200
    28.707    22.927     0.200
    14.699    45.733     0.200
    14.772    45.786     0.200
    15.413    44.982     0.200
    18.072    41.369     0.200
    19.342    40.134     0.200
    19.546    39.007     0.200
    22.642    36.249     0.200
    23.107    37.651     0.200
    23.107    39.001     0.200
    23.508    37.545     0.200
    25.110    31.996     0.200
    25.110    32.601     0.200
    26.081    30.725     0.200
    28.658    22.520     0.200
    28.665    23.329     0.200
    19.334    39.923     0.200
    19.355    39.139     0.200
    19.509    40.682     0.200
    19.509    39.776     0.200
    19.509    38.816     0.200
    20.005    40.412     0.200
    20.112    38.599     0.200
    20.969    38.874     0.200
    21.439    38.244     0.200
    21.951    38.939     0.200
    23.203    36.498     0.200
    23.203    36.623     0.200
    25.094    32.222     0.200
    25.094    30.932     0.200
    28.747    22.271     0.200
    16.194    42.944     0.200
    19.400    38.884     0.200
    19.404    39.440     0.200
    19.442    39.719     0.200
    19.618    40.599     0.200
    19.618    39.794     0.200
    19.618    39.004     0.200
    20.088    39.936     0.200
    20.088    40.578     0.200
    20.195    39.442     0.200
    20.195    40.152     0.200
    20.866    40.070     0.200
    21.944    37.400     0.200
    21.944    37.574     0.200
    21.944    38.784     0.200
    22.252    38.501     0.200
    23.068    37.456     0.200
    23.068    36.347     0.200
    25.178    31.593     0.200
    25.178    31.904     0.200
    19.453    39.573     0.200
    19.453    38.923     0.200
    25.041    33.275     0.200
    25.041    31.766     0.200
    19.344    40.295     0.200
    19.531    39.763     0.200
    19.531    38.886     0.200
    20.013    38.753     0.200
    20.120    38.331     0.200
    21.919    37.516     0.200
    25.103    31.412     0.200
    25.103    30.813     0.200
    28.687    23.530     0.200
    15.029    42.320     0.200
    17.232    43.116     0.200
    17.293    42.798     0.200
    17.528    43.457     0.200
    19.314    40.590     0.200
    19.319    40.114     0.200
    19.319    41.075     0.200
    19.365    40.156     0.200
    19.365    39.717     0.200
    19.365    40.897     0.200
    19.541    40.143     0.200
    19.541    40.369     0.200
    19.541    40.869     0.200
    19.541    40.668     0.200
    19.541    39.578     0.200
    20.005    41.435     0.200
    20.005    40.207     0.200
    20.005    40.560     0.200
    20.111    41.475     0.200
    20.111    40.504     0.200
    20.111    39.787     0.200
    20.111    41.613     0.200
    21.250    38.929     0.200
    21.394    37.445     0.200
    21.500    38.809     0.200
    21.870    39.495     0.200
    21.854    38.181     0.200
    21.866    39.840     0.200
    22.486    37.804     0.200
    23.063    39.071     0.200
    23.066    38.337     0.200
    23.066    39.436     0.200
    23.066    37.737     0.200
    23.066    39.186     0.200
    23.066    39.436     0.200
    23.360    37.998     0.200
    25.095    32.754     0.200
    25.095    33.353     0.200
    25.095    32.693     0.200
    25.157    31.653     0.200
    25.157    33.803     0.200
    25.347    34.416     0.200
    26.970    29.876     0.200
    28.568    23.226     0.200
    28.593    24.032     0.200
    28.611    24.253     0.200
    28.611    23.028     0.200
    28.611    24.028     0.200
    28.618    24.016     0.200
    28.618    23.447     0.200
    28.621    23.503     0.200
    29.373    22.015     0.200
    19.551    40.298     0.200
    20.023    39.861     0.200
    21.902    38.255     0.200
    25.114    31.335     0.200
    18.093    42.176     0.200
    19.333    39.562     0.200
    19.337    40.942     0.200
    19.402    40.314     0.200
    19.402    40.420     0.200
    19.578    39.625     0.200
    19.578    39.722     0.200
    20.034    40.478     0.200
    20.141    38.279     0.200
    20.141    40.752     0.200
    21.868    39.070     0.200
    21.868    38.777     0.200
    23.026    38.745     0.200
    25.125    32.238     0.200
    28.582    22.720     0.200
    19.664    39.939     0.200
    19.664    38.560     0.200
    20.111    40.322     0.200
    20.218    39.077     0.200
    21.900    39.484     0.200
    22.355    36.794     0.200
    22.964    36.277     0.200
    25.203    31.541     0.200
    28.552    22.070     0.200
    19.409    40.506     0.200
    19.681    39.454     0.200
    20.128    39.861     0.200
    21.913    40.056     0.200
    22.959    38.488     0.200
    25.220    31.318     0.200
    17.532    42.921     0.200
    19.285    39.758     0.200
    19.290    41.109     0.200
    19.508    40.033     0.200
    19.972    41.241     0.200
    21.844    39.239     0.200
    21.844    39.098     0.200
    23.079    35.391     0.200
    23.079    39.290     0.200
    23.940    35.341     0.200
    25.063    32.437     0.200
    28.611    23.557     0.200
    28.611    22.834     0.200
    19.475    40.605     0.200
    19.965    39.104     0.200
    25.054    32.118     0.200
    18.871    40.941     0.200
    19.335    39.873     0.200
    19.339    39.364     0.200
    19.574    39.725     0.200
    20.033    41.145     0.200
    20.139    39.944     0.200
    21.874    37.330     0.200
    22.271    36.411     0.200
    25.123    32.411     0.200
    25.123    32.091     0.200
    19.335    41.169     0.200
    22.135    37.419     0.200
    22.590    35.154     0.200
    23.173    36.321     0.200
    25.079    32.797     0.200
    19.338    40.534     0.200
    19.565    40.058     0.200
    20.029    40.316     0.200
    23.062    37.930     0.200
    17.221    42.391     0.200
    17.247    42.517     0.200
    19.345    39.599     0.200
    19.349    38.430     0.200
    19.349    39.660     0.200
    19.436    39.409     0.200
    19.436    38.827     0.200
    19.436    40.659     0.200
    19.613    40.150     0.200
    19.613    39.224     0.200
    20.060    40.810     0.200
    20.167    40.885     0.200
    20.167    37.956     0.200
    20.167    41.065     0.200
    20.744    40.143     0.200
    21.467    37.832     0.200
    21.863    38.794     0.200
    21.863    37.325     0.200
    21.863    38.505     0.200
    22.269    38.184     0.200
    22.332    38.535     0.200
    22.979    37.620     0.200
    22.979    37.050     0.200
    22.979    37.390     0.200
    25.151    32.393     0.200
    25.151    31.264     0.200
    25.252    33.942     0.200
    25.252    32.114     0.200
    28.546    23.204     0.200
    28.546    22.586     0.200
    28.553    24.006     0.200
    28.553    23.256     0.200
    29.295    24.566     0.200
    19.392    40.293     0.200
    19.635    40.303     0.200
    20.094    40.095     0.200
    21.919    38.794     0.200
    23.019    37.479     0.200
    25.185    32.111     0.200
    14.671    45.397     0.200
    16.535    45.246     0.200
    17.247    43.238     0.200
    17.247    42.836     0.200
    17.409    43.648     0.200
    17.483    42.587     0.200
    18.832    40.780     0.200
    19.050    41.400     0.200
    19.360    40.109     0.200
    19.364    39.474     0.200
    19.364    39.794     0.200
    19.438    39.247     0.200
    19.438    39.747     0.200
    19.324    41.278     0.200
    19.614    39.615     0.200
    19.614    40.013     0.200
    19.614    40.365     0.200
    19.614    39.752     0.200
    19.667    41.507     0.200
    20.068    40.800     0.200
    20.174    40.801     0.200
    20.174    39.422     0.200
    20.174    40.281     0.200
    20.113    41.370     0.200
    20.362    40.809     0.200
    20.531    39.120     0.200
    20.768    40.845     0.200
    20.804    41.105     0.200
    20.804    40.867     0.200
    20.893    40.285     0.200
    21.137    37.780     0.200
    21.320    38.314     0.200
    21.238    40.172     0.200
    21.282    40.153     0.200
    21.468    38.083     0.200
    21.571    39.486     0.200
    21.924    39.758     0.200
    21.949    38.874     0.200
    21.884    39.193     0.200
    21.884    38.224     0.200
    21.884    38.826     0.200
    21.949    39.003     0.200
    22.020    39.141     0.200
    22.210    38.619     0.200
    22.311    37.830     0.200
    22.311    37.720     0.200
    22.286    39.824     0.200
    22.555    38.294     0.200
    22.726    35.802     0.200
    23.000    38.009     0.200
    23.003    37.723     0.200
    23.003    37.973     0.200
    23.003    38.172     0.200
    23.003    37.473     0.200
    23.003    37.934     0.200
    23.003    38.973     0.200
    23.106    36.666     0.200
    23.281    35.029     0.200
    23.319    35.682     0.200
    23.572    36.325     0.200
    23.532    38.349     0.200
    23.570    37.357     0.200
    23.662    37.671     0.200
    24.045    36.010     0.200
    24.282    35.344     0.200
    24.920    34.653     0.200
    25.159    32.613     0.200
    25.159    32.261     0.200
    25.159    32.113     0.200
    25.233    32.558     0.200
    25.233    32.776     0.200
    25.351    31.368     0.200
    25.461    32.211     0.200
    26.267    29.510     0.200
    26.949    27.313     0.200
    27.745    26.490     0.200
    28.530    23.367     0.200
    28.555    23.976     0.200
    28.573    23.468     0.200
    28.573    23.366     0.200
    28.573    23.866     0.200
    28.580    23.598     0.200
    28.580    23.157     0.200
    28.584    23.342     0.200
    28.844    23.731     0.200
    29.188    21.793     0.200
    29.240    22.384     0.200
    29.240    22.056     0.200
    29.321    23.947     0.200
    25.109    32.864     0.200
    18.173    41.911     0.200
    19.320    38.971     0.200
    19.338    39.212     0.200
    19.514    39.220     0.200
    19.514    39.837     0.200
    19.992    39.908     0.200
    21.366    39.638     0.200
    21.894    38.704     0.200
    21.894    38.915     0.200
    22.175    36.873     0.200
    23.131    37.891     0.200
    23.131    37.516     0.200
    25.081    31.581     0.200
    28.670    23.041     0.200
    14.822    45.745     0.200
    15.049    41.426     0.200
    15.182    40.673     0.200
    16.905    43.683     0.200
    17.968    40.759     0.200
    18.002    41.641     0.200
    18.127    41.529     0.200
    18.213    42.056     0.200
    18.905    40.225     0.200
    19.324    38.539     0.200
    19.324    38.855     0.200
    19.324    38.980     0.200
    19.324    38.249     0.200
    19.321    39.625     0.200
    19.325    38.991     0.200
    19.325    38.432     0.200
    19.519    40.158     0.200
    19.500    38.987     0.200
    19.500    38.498     0.200
    19.500    39.487     0.200
    19.500    38.912     0.200
    19.500    38.477     0.200
    19.463    41.322     0.200
    19.797    41.324     0.200
    19.984    39.710     0.200
    19.984    39.375     0.200
    19.984    40.736     0.200
    20.091    39.088     0.200
    20.091    39.984     0.200
    20.091    39.878     0.200
    20.091    39.319     0.200
    20.091    37.777     0.200
    20.091    39.689     0.200
    20.091    39.565     0.200
    20.091    40.088     0.200
    20.367    38.563     0.200
    20.275    41.508     0.200
    20.973    38.195     0.200
    20.973    37.784     0.200
    20.965    41.825     0.200
    21.048    40.870     0.200
    21.156    39.356     0.200
    21.407    38.234     0.200
    21.420    41.088     0.200
    21.397    39.943     0.200
    21.420    39.974     0.200
    21.701    39.246     0.200
    21.811    39.040     0.200
    21.905    38.715     0.200
    21.905    38.835     0.200
    21.905    38.533     0.200
    21.905    38.315     0.200
    22.146    37.804     0.200
    22.157    37.983     0.200
    22.186    38.384     0.200
    22.194    40.550     0.200
    22.194    39.050     0.200
    22.221    38.126     0.200
    22.392    38.233     0.200
    22.371    40.182     0.200
    22.527    37.416     0.200
    22.452    40.122     0.200
    22.452    38.763     0.200
    22.604    36.856     0.200
    22.913    39.858     0.200
    23.048    36.118     0.200
    23.116    36.781     0.200
    23.152    37.859     0.200
    23.157    37.910     0.200
    23.160    37.676     0.200
    23.160    37.675     0.200
    23.160    37.110     0.200
    23.160    37.875     0.200
    23.160    36.975     0.200
    23.160    37.575     0.200
    23.160    36.775     0.200
    23.213    36.150     0.200
    23.326    35.460     0.200
    23.450    37.117     0.200
    23.425    36.576     0.200
    23.446    37.632     0.200
    23.446    36.922     0.200
    23.446    38.533     0.200
    23.545    38.302     0.200
    23.565    36.547     0.200
    23.565    37.398     0.200
    23.565    36.347     0.200
    23.677    37.842     0.200
    23.691    37.217     0.200
    23.710    36.251     0.200
    23.858    35.301     0.200
    23.819    36.285     0.200
    23.819    36.725     0.200
    23.819    36.504     0.200
    23.819    36.942     0.200
    23.819    36.605     0.200
    23.935    36.232     0.200
    23.904    38.375     0.200
    24.040    34.163     0.200
    24.270    36.813     0.200
    24.390    33.986     0.200
    24.395    34.955     0.200
    24.383    34.302     0.200
    24.553    35.090     0.200
    24.499    36.192     0.200
    24.769    33.861     0.200
    24.899    36.553     0.200
    24.981    32.395     0.200
    25.066    33.095     0.200
    25.066    33.225     0.200
    25.073    32.343     0.200
    25.073    31.566     0.200
    25.073    32.037     0.200
    25.073    31.743     0.200
    25.073    32.193     0.200
    25.362    33.883     0.200
    25.401    32.225     0.200
    25.578    31.455     0.200
    25.578    31.783     0.200
    25.578    32.594     0.200
    25.578    32.104     0.200
    25.752    32.735     0.200
    25.942    29.359     0.200
    25.943    31.849     0.200
    26.297    30.941     0.200
    26.402    31.214     0.200
    26.430    29.051     0.200
    26.675    29.256     0.200
    26.829    26.423     0.200
    26.756    29.543     0.200
    26.807    27.675     0.200
    26.873    30.126     0.200
    26.994    29.310     0.200
    27.044    27.043     0.200
    27.044    29.355     0.200
    27.044    27.752     0.200
    27.044    28.833     0.200
    27.044    28.043     0.200
    27.188    28.181     0.200
    27.300    28.318     0.200
    27.335    29.137     0.200
    27.351    27.971     0.200
    27.358    29.134     0.200
    27.401    26.034     0.200
    27.418    27.483     0.200
    27.420    28.393     0.200
    27.435    27.971     0.200
    27.522    28.666     0.200
    27.572    26.626     0.200
    27.572    27.541     0.200
    27.572    26.882     0.200
    27.572    27.081     0.200
    27.620    25.258     0.200
    27.620    26.372     0.200
    27.679    25.776     0.200
    27.813    27.671     0.200
    27.819    27.661     0.200
    27.888    26.404     0.200
    27.888    26.794     0.200
    28.008    25.272     0.200
    27.917    26.006     0.200
    27.949    25.382     0.200
    27.956    26.047     0.200
    27.958    26.267     0.200
    28.053    23.972     0.200
    28.072    25.994     0.200
    28.096    24.412     0.200
    28.052    27.117     0.200
    28.075    24.522     0.200
    28.078    26.816     0.200
    28.153    27.052     0.200
    28.223    24.244     0.200
    28.222    24.821     0.200
    28.225    26.574     0.200
    28.354    26.554     0.200
    28.292    23.526     0.200
    28.338    24.057     0.200
    28.337    24.984     0.200
    28.352    25.675     0.200
    28.357    25.422     0.200
    28.374    23.659     0.200
    28.415    25.046     0.200
    28.415    23.617     0.200
    28.416    25.810     0.200
    28.447    25.768     0.200
    28.500    24.585     0.200
    28.519    25.160     0.200
    28.689    23.923     0.200
    28.649    25.287     0.200
    28.653    23.264     0.200
    28.756    22.622     0.200
    28.679    23.169     0.200
    28.693    24.286     0.200
    28.696    22.891     0.200
    28.696    23.165     0.200
    28.696    23.266     0.200
    28.703    23.254     0.200
    28.703    22.985     0.200
    28.698    23.983     0.200
    28.703    24.552     0.200
    28.707    23.142     0.200
    28.737    24.006     0.200
    28.741    25.431     0.200
    28.749    25.304     0.200
    28.753    22.999     0.200
    28.761    22.908     0.200
    28.777    23.622     0.200
    28.796    22.654     0.200
    28.796    23.805     0.200
    28.797    23.395     0.200
    28.818    23.559     0.200
    28.831    22.787     0.200
    28.893    24.159     0.200
    28.893    25.269     0.200
    28.893    25.519     0.200
    28.893    23.749     0.200
    28.853    22.726     0.200
    28.853    23.928     0.200
    28.912    23.684     0.200
    28.914    24.394     0.200
    28.923    24.835     0.200
    28.943    23.568     0.200
    28.970    23.971     0.200
    29.076    21.669     0.200
    28.985    24.421     0.200
    28.985    23.391     0.200
    28.990    24.633     0.200
    28.990    24.316     0.200
    28.991    24.854     0.200
    29.007    22.351     0.200
    29.036    24.398     0.200
    29.036    24.675     0.200
    29.036    23.507     0.200
    29.066    21.781     0.200
    29.118    22.159     0.200
    29.130    23.785     0.200
    29.207    21.688     0.200
    29.177    21.136     0.200
    29.211    24.102     0.200
    29.222    22.262     0.200
    29.249    23.911     0.200
    29.371    21.374     0.200
    29.299    23.565     0.200
    29.315    22.149     0.200
    29.315    21.206     0.200
    29.315    21.742     0.200
    29.349    22.575     0.200
    29.366    22.616     0.200
    29.389    22.796     0.200
    29.423    21.074     0.200
    29.394    21.543     0.200
    29.394    21.918     0.200
    29.403    21.446     0.200
    29.415    23.022     0.200
    29.423    21.675     0.200
    29.428    23.192     0.200
    29.464    23.932     0.200
    29.464    23.201     0.200
    29.496    21.898     0.200
    29.582    21.860     0.200
    29.597    20.161     0.200
    29.597    20.857     0.200
    29.597    20.352     0.200
    29.616    21.102     0.200
    29.673    20.021     0.200
    29.718    19.324     0.200
    29.726    19.977     0.200
    29.726    18.927     0.200
    29.726    21.941     0.200
    29.754    21.674     0.200
    29.757    19.176     0.200
    29.768    18.846     0.200
    29.780    19.449     0.200
    29.805    22.056     0.200
    29.821    19.783     0.200
    29.821    19.595     0.200
    29.822    19.330     0.200
    29.929    19.479     0.200
    19.274    38.554     0.200
    19.424    38.331     0.200
    19.919    38.277     0.200
    25.008    33.618     0.200
    19.268    40.378     0.200
    19.298    40.209     0.200
    19.443    40.939     0.200
    19.941    40.903     0.200
    20.048    38.560     0.200
    21.910    39.083     0.200
    23.230    37.841     0.200
    25.030    33.095     0.200
    25.030    32.825     0.200
    28.749    22.486     0.200
    14.867    41.293     0.200
    14.867    41.431     0.200
    14.867    43.401     0.200
    15.099    41.277     0.200
    15.891    42.224     0.200
    15.946    42.014     0.200
    16.724    42.236     0.200
    16.951    42.937     0.200
    17.359    43.907     0.200
    17.552    41.595     0.200
    17.581    42.223     0.200
    17.647    42.649     0.200
    17.653    42.604     0.200
    18.226    43.580     0.200
    18.492    40.372     0.200
    18.952    39.922     0.200
    19.263    39.809     0.200
    19.263    39.358     0.200
    19.263    39.639     0.200
    19.281    40.474     0.200
    19.286    39.594     0.200
    19.464    40.243     0.200
    19.439    40.039     0.200
    19.439    39.882     0.200
    19.439    39.638     0.200
    19.439    39.688     0.200
    19.439    39.478     0.200
    19.581    39.884     0.200
    19.931    41.144     0.200
    20.038    40.442     0.200
    20.038    40.566     0.200
    20.038    40.147     0.200
    20.038    41.054     0.200
    20.038    39.723     0.200
    20.038    40.677     0.200
    20.312    38.948     0.200
    20.555    37.830     0.200
    20.854    38.418     0.200
    20.918    38.705     0.200
    20.918    37.480     0.200
    21.019    41.058     0.200
    21.019    40.838     0.200
    21.101    38.139     0.200
    21.096    41.040     0.200
    21.290    39.034     0.200
    21.351    38.127     0.200
    21.457    39.785     0.200
    21.519    40.379     0.200
    21.679    39.570     0.200
    21.746    39.001     0.200
    21.785    40.187     0.200
    21.888    39.231     0.200
    21.888    38.304     0.200
    21.888    37.621     0.200
    21.888    38.861     0.200
    21.888    39.461     0.200
    21.888    39.091     0.200
    22.090    38.029     0.200
    22.090    38.214     0.200
    22.173    38.327     0.200
    22.200    38.715     0.200
    22.247    38.314     0.200
    22.256    39.867     0.200
    22.337    36.613     0.200
    22.490    37.267     0.200
    22.433    39.367     0.200
    22.578    36.548     0.200
    22.515    39.600     0.200
    22.515    39.409     0.200
    22.964    39.231     0.200
    23.060    36.277     0.200
    23.133    39.033     0.200
    23.206    37.370     0.200
    23.209    38.341     0.200
    23.209    38.035     0.200
    23.209    37.435     0.200
    23.209    37.435     0.200
    23.209    37.915     0.200
    23.233    36.956     0.200
    23.445    37.186     0.200
    23.510    38.574     0.200
    23.510    37.874     0.200
    23.510    37.624     0.200
    23.623    36.632     0.200
    23.623    36.112     0.200
    23.695    36.865     0.200
    23.801    36.834     0.200
    23.742    37.263     0.200
    23.748    36.844     0.200
    23.875    36.972     0.200
    23.868    37.393     0.200
    23.868    36.638     0.200
    23.868    36.508     0.200
    23.868    37.623     0.200
    23.868    37.098     0.200
    23.987    36.312     0.200
    24.351    34.847     0.200
    24.374    35.734     0.200
    24.400    35.346     0.200
    24.523    35.563     0.200
    24.823    34.898     0.200
    25.006    34.320     0.200
    25.006    34.013     0.200
    25.020    32.847     0.200
    25.020    32.883     0.200
    25.331    32.527     0.200
    25.325    32.431     0.200
    25.367    32.474     0.200
    25.394    32.737     0.200
    25.410    34.237     0.200
    25.631    31.975     0.200
    25.631    31.624     0.200
    26.609    29.964     0.200
    26.772    27.307     0.200
    26.803    29.795     0.200
    26.927    29.958     0.200
    27.058    29.219     0.200
    27.058    29.837     0.200
    27.058    28.831     0.200
    27.058    28.589     0.200
    27.058    28.320     0.200
    27.382    27.850     0.200
    27.393    29.093     0.200
    27.457    27.660     0.200
    27.484    27.477     0.200
    27.849    26.139     0.200
    27.993    25.605     0.200
    27.928    25.639     0.200
    27.928    27.269     0.200
    28.037    25.229     0.200
    28.001    26.299     0.200
    28.129    25.578     0.200
    28.261    26.286     0.200
    28.269    26.351     0.200
    28.449    24.691     0.200
    28.701    23.778     0.200
    28.682    23.572     0.200
    28.707    23.277     0.200
    28.724    23.801     0.200
    28.724    23.207     0.200
    28.724    23.676     0.200
    28.724    23.276     0.200
    28.724    22.876     0.200
    28.731    23.305     0.200
    28.731    23.204     0.200
    28.731    24.014     0.200
    28.731    24.145     0.200
    28.735    23.253     0.200
    28.736    25.061     0.200
    28.781    23.108     0.200
    28.780    25.288     0.200
    28.789    23.116     0.200
    28.805    23.034     0.200
    28.825    23.005     0.200
    28.845    23.865     0.200
    28.850    23.908     0.200
    28.860    22.898     0.200
    28.939    22.525     0.200
    28.896    23.939     0.200
    28.952    24.608     0.200
    28.952    24.285     0.200
    28.952    21.275     0.200
    28.952    23.805     0.200
    29.018    22.759     0.200
    28.951    23.298     0.200
    28.982    24.618     0.200
    29.009    24.303     0.200
    29.024    24.088     0.200
    29.024    23.977     0.200
    29.024    24.677     0.200
    29.029    24.071     0.200
    29.031    24.612     0.200
    29.031    25.102     0.200
    29.075    23.539     0.200
    29.075    23.483     0.200
    29.200    22.158     0.200
    29.251    23.734     0.200
    29.266    23.550     0.200
    29.337    23.786     0.200
    29.346    21.826     0.200
    29.385    23.289     0.200
    29.428    22.227     0.200
    29.442    22.122     0.200
    29.454    23.049     0.200
    29.504    23.597     0.200
    29.504    22.697     0.200
    29.650    20.386     0.200
    29.650    20.569     0.200
    29.652    22.422     0.200
    29.767    22.607     0.200
    29.781    18.778     0.200
    19.283    39.056     0.200
    19.314    39.810     0.200
    19.319    39.995     0.200
    19.459    39.257     0.200
    19.459    39.368     0.200
    19.958    40.426     0.200
    20.064    38.811     0.200
    21.923    38.399     0.200
    21.923    38.157     0.200
    23.228    38.048     0.200
    23.228    35.839     0.200
    25.046    32.817     0.200
    25.046    31.967     0.200
    19.369    38.743     0.200
    19.527    39.352     0.200
    20.022    39.200     0.200
    25.111    31.515     0.200
    19.490    39.417     0.200
    19.978    39.600     0.200
    23.176    39.517     0.200
    25.067    31.929     0.200
    14.854    43.582     0.200
    16.712    44.275     0.200
    16.850    41.781     0.200
    17.349    44.565     0.200
    17.408    42.669     0.200
    17.469    41.822     0.200
    19.296    39.670     0.200
    19.284    38.781     0.200
    19.301    40.086     0.200
    19.460    39.760     0.200
    19.460    39.430     0.200
    19.460    39.930     0.200
    19.460    39.219     0.200
    19.460    38.869     0.200
    19.460    40.030     0.200
    19.820    41.030     0.200
    19.950    39.638     0.200
    19.950    39.854     0.200
    20.056    39.955     0.200
    20.056    38.314     0.200
    20.935    38.894     0.200
    21.311    37.424     0.200
    21.895    38.807     0.200
    22.107    37.902     0.200
    22.170    37.605     0.200
    22.209    38.248     0.200
    23.191    39.079     0.200
    23.194    36.045     0.200
    23.194    38.274     0.200
    23.194    39.346     0.200
    23.440    35.776     0.200
    23.726    38.479     0.200
    23.895    36.766     0.200
    24.396    34.324     0.200
    25.039    31.923     0.200
    25.039    32.380     0.200
    25.039    32.193     0.200
    25.039    32.823     0.200
    25.025    33.224     0.200
    25.398    32.725     0.200
    26.630    30.349     0.200
    27.055    29.087     0.200
    27.055    29.235     0.200
    28.699    23.402     0.200
    28.717    21.870     0.200
    28.717    23.899     0.200
    28.717    24.200     0.200
    28.717    23.999     0.200
    28.724    23.459     0.200
    28.724    23.818     0.200
    19.274    39.356     0.200
    19.274    39.106     0.200
    19.274    38.896     0.200
    19.297    37.769     0.200
    19.302    39.562     0.200
    19.449    39.657     0.200
    19.449    38.391     0.200
    19.944    38.925     0.200
    20.051    39.252     0.200
    20.051    41.191     0.200
    21.300    37.065     0.200
    21.456    37.904     0.200
    21.753    38.777     0.200
    21.905    37.828     0.200
    21.905    38.899     0.200
    23.218    37.478     0.200
    23.218    36.685     0.200
    23.218    37.258     0.200
    25.033    31.994     0.200
    25.033    31.865     0.200
    25.002    34.253     0.200
    28.738    22.358     0.200
    28.745    23.336     0.200
    29.515    20.346     0.200
    29.657    20.349     0.200
    14.727    43.915     0.200
    16.047    41.972     0.200
    18.107    41.463     0.200
    19.344    39.953     0.200
    19.394    38.685     0.200
    19.394    39.415     0.200
    19.571    38.597     0.200
    19.571    38.777     0.200
    20.035    39.652     0.200
    20.142    38.512     0.200
    20.142    38.061     0.200
    21.890    37.896     0.200
    21.890    38.716     0.200
    23.060    36.951     0.200
    23.060    37.320     0.200
    23.060    36.731     0.200
    25.126    32.195     0.200
    25.126    31.432     0.200
    28.618    22.430     0.200
    28.624    23.459     0.200
    14.876    45.842     0.200
    17.382    43.279     0.200
    17.674    42.305     0.200
    17.679    41.794     0.200
    19.353    38.324     0.200
    19.378    40.236     0.200
    19.383    40.931     0.200
    19.528    38.985     0.200
    19.528    39.136     0.200
    19.528    39.886     0.200
    19.528    38.027     0.200
    19.528    40.437     0.200
    19.529    41.417     0.200
    19.860    41.470     0.200
    20.027    40.629     0.200
    20.134    38.057     0.200
    20.973    40.498     0.200
    21.008    40.934     0.200
    21.008    40.815     0.200
    21.098    39.416     0.200
    21.444    39.323     0.200
    21.481    40.754     0.200
    21.826    39.228     0.200
    21.974    38.492     0.200
    21.974    38.693     0.200
    21.974    38.353     0.200
    22.289    37.618     0.200
    22.398    37.690     0.200
    23.205    38.528     0.200
    23.208    37.532     0.200
    23.208    38.592     0.200
    23.208    37.692     0.200
    23.208    38.692     0.200
    23.208    37.874     0.200
    23.738    39.160     0.200
    23.769    38.844     0.200
    23.966    35.554     0.200
    25.116    32.232     0.200
    25.116    32.507     0.200
    25.116    31.943     0.200
    25.037    32.772     0.200
    25.472    33.975     0.200
    25.667    31.830     0.200
    26.178    30.814     0.200
    27.115    28.104     0.200
    27.946    26.182     0.200
    28.719    22.785     0.200
    28.744    23.391     0.200
    28.761    23.161     0.200
    28.761    24.087     0.200
    28.761    23.386     0.200
    28.761    24.187     0.200
    28.768    22.577     0.200
    28.862    23.516     0.200
    29.379    20.278     0.200
    29.445    21.448     0.200
    29.522    24.427     0.200
    17.394    42.305     0.200
    19.328    40.082     0.200
    19.521    40.445     0.200
    19.521    40.054     0.200
    19.998    40.224     0.200
    20.104    39.395     0.200
    20.487    40.327     0.200
    21.895    38.485     0.200
    21.895    38.263     0.200
    21.895    39.103     0.200
    23.123    38.270     0.200
    23.123    38.258     0.200
    23.123    37.700     0.200
    25.087    32.662     0.200
    25.087    31.525     0.200
    28.672    23.457     0.200
    19.298    40.035     0.200
    19.456    40.031     0.200
    19.949    39.892     0.200
    25.038    32.381     0.200
    19.429    40.181     0.200
    19.919    40.402     0.200
    25.008    32.432     0.200
    19.371    41.277     0.200
    19.548    40.044     0.200
    20.035    40.772     0.200
    23.157    37.723     0.200
    25.124    31.533     0.200
    28.713    22.659     0.200
    14.656    41.446     0.200
    16.032    43.503     0.200
    17.631    42.017     0.200
    19.040    40.702     0.200
    19.247    39.166     0.200
    19.258    41.192     0.200
    19.423    39.849     0.200
    19.423    38.927     0.200
    19.911    40.448     0.200
    21.863    37.967     0.200
    23.199    37.512     0.200
    23.199    37.403     0.200
    25.000    32.012     0.200
    25.000    32.340     0.200
    28.713    22.780     0.200
    19.339    39.943     0.200
    19.564    40.095     0.200
    20.029    40.191     0.200
    21.888    38.866     0.200
    23.065    38.434     0.200
    25.120    32.210     0.200
    19.541    38.594     0.200
    20.014    38.503     0.200
    23.102    35.890     0.200
    25.104    32.876     0.200
    14.676    41.290     0.200
    19.297    40.349     0.200
    19.479    39.928     0.200
    19.961    40.376     0.200
    23.158    38.321     0.200
    25.050    31.779     0.200
    19.283    41.007     0.200
    19.448    39.343     0.200
    19.448    40.447     0.200
    19.937    40.490     0.200
    20.044    39.808     0.200
    22.105    36.731     0.200
    22.240    37.403     0.200
    23.194    39.416     0.200
    23.194    36.881     0.200
    25.026    32.727     0.200
    19.297    40.094     0.200
    19.444    38.657     0.200
    19.941    41.053     0.200
    21.908    39.119     0.200
    21.908    39.010     0.200
    23.227    38.350     0.200
    25.030    31.119     0.200
    17.629    42.481     0.200
    18.260    41.157     0.200
    19.266    39.580     0.200
    19.432    38.714     0.200
    19.920    39.707     0.200
    20.027    40.092     0.200
    21.868    38.952     0.200
    23.195    39.833     0.200
    25.009    32.880     0.200
    28.705    23.368     0.200
    28.712    23.669     0.200
    14.755    43.307     0.200
    17.318    43.462     0.200
    17.480    46.372     0.200
    17.553    43.221     0.200
    19.315    39.862     0.200
    19.319    40.450     0.200
    19.319    40.730     0.200
    19.352    38.945     0.200
    19.528    41.468     0.200
    19.528    40.418     0.200
    19.528    38.529     0.200
    19.997    41.094     0.200
    20.104    39.568     0.200
    21.474    40.763     0.200
    21.875    39.171     0.200
    21.875    39.037     0.200
    21.875    39.278     0.200
    22.213    39.906     0.200
    22.460    38.959     0.200
    23.092    37.901     0.200
    23.092    39.081     0.200
    23.092    38.381     0.200
    23.092    37.471     0.200
    23.092    39.681     0.200
    23.961    36.439     0.200
    25.088    32.716     0.200
    25.088    32.331     0.200
    25.360    33.406     0.200
    26.069    30.606     0.200
    28.634    22.607     0.200
    28.634    23.706     0.200
    28.634    24.507     0.200
    28.641    23.835     0.200
    19.287    38.747     0.200
    19.287    40.817     0.200
    19.282    38.438     0.200
    19.287    40.384     0.200
    19.463    39.280     0.200
    19.463    39.475     0.200
    19.945    39.474     0.200
    19.945    39.162     0.200
    20.902    38.312     0.200
    21.871    37.714     0.200
    21.871    38.746     0.200
    23.162    38.086     0.200
    25.035    31.237     0.200
    28.683    23.119     0.200
    14.701    44.484     0.200
    19.325    40.331     0.200
    19.389    37.988     0.200
    19.389    39.528     0.200
    19.565    40.122     0.200
    19.565    38.968     0.200
    20.023    40.505     0.200
    20.130    39.759     0.200
    20.130    40.599     0.200
    21.865    38.708     0.200
    21.865    38.216     0.200
    23.036    38.191     0.200
    23.036    38.011     0.200
    25.114    32.319     0.200
    25.114    32.135     0.200
    25.340    32.782     0.200
    28.589    22.794     0.200
    28.596    23.443     0.200
    23.073    35.306     0.200
    19.407    39.803     0.200
    19.450    39.901     0.200
    19.626    40.221     0.200
    20.096    40.561     0.200
    21.949    38.881     0.200
    21.949    38.381     0.200
    23.065    37.668     0.200
    25.187    31.981     0.200
    28.647    23.206     0.200
    19.928    40.155     0.200
    23.187    38.830     0.200
    25.018    32.764     0.200
    21.913    38.652     0.200
    23.096    38.056     0.200
    25.126    31.961     0.200
    28.654    22.947     0.200
    19.275    39.386     0.200
    19.280    40.117     0.200
    19.284    38.639     0.200
    19.284    38.088     0.200
    19.284    40.498     0.200
    19.460    39.216     0.200
    19.460    38.349     0.200
    19.460    38.730     0.200
    19.940    39.802     0.200
    21.312    37.402     0.200
    21.777    38.963     0.200
    21.863    38.631     0.200
    21.863    38.243     0.200
    21.863    38.434     0.200
    22.196    38.820     0.200
    22.627    35.250     0.200
    23.156    37.463     0.200
    23.156    38.174     0.200
    23.156    37.233     0.200
    25.030    32.632     0.200
    25.030    31.677     0.200
    28.675    23.269     0.200
    16.248    41.727     0.200
    16.905    43.597     0.200
    17.313    42.693     0.200
    17.440    43.132     0.200
    17.582    41.234     0.200
    18.495    40.898     0.200
    18.956    41.156     0.200
    19.173    40.981     0.200
    19.197    41.010     0.200
    19.277    39.650     0.200
    19.277    39.377     0.200
    19.277    38.845     0.200
    19.277    38.470     0.200
    19.277    40.181     0.200
    19.277    39.877     0.200
    19.271    39.130     0.200
    19.276    39.513     0.200
    19.276    39.123     0.200
    19.453    39.831     0.200
    19.453    39.143     0.200
    19.453    40.323     0.200
    19.453    39.722     0.200
    19.453    39.737     0.200
    19.453    39.292     0.200
    19.509    39.968     0.200
    19.486    41.540     0.200
    19.783    40.869     0.200
    19.934    39.854     0.200
    19.934    39.455     0.200
    20.041    40.802     0.200
    20.041    40.950     0.200
    20.041    40.357     0.200
    20.041    40.224     0.200
    20.041    40.661     0.200
    20.041    41.200     0.200
    20.284    40.650     0.200
    20.357    38.769     0.200
    20.532    39.907     0.200
    20.560    39.466     0.200
    20.900    38.336     0.200
    20.963    38.271     0.200
    20.963    38.514     0.200
    20.961    39.930     0.200
    20.934    39.885     0.200
    20.973    41.140     0.200
    20.973    39.461     0.200
    21.049    39.519     0.200
    21.146    37.958     0.200
    21.305    39.016     0.200
    21.395    38.651     0.200
    21.402    39.204     0.200
    21.411    40.176     0.200
    21.722    39.651     0.200
    21.769    39.392     0.200
    21.769    39.493     0.200
    21.862    39.304     0.200
    21.862    39.515     0.200
    21.862    38.859     0.200
    22.131    38.461     0.200
    22.176    39.037     0.200
    22.205    38.366     0.200
    22.214    39.904     0.200
    22.214    38.583     0.200
    22.382    36.438     0.200
    22.391    39.357     0.200
    22.474    39.477     0.200
    22.622    38.498     0.200
    22.917    38.750     0.200
    23.105    36.702     0.200
    23.176    37.337     0.200
    23.160    37.863     0.200
    23.163    37.336     0.200
    23.163    37.438     0.200
    23.163    37.922     0.200
    23.163    38.203     0.200
    23.163    36.501     0.200
    23.163    37.126     0.200
    23.223    38.528     0.200
    23.402    37.037     0.200
    23.471    37.891     0.200
    23.471    37.774     0.200
    23.471    37.532     0.200
    23.578    36.886     0.200
    23.578    36.058     0.200
    23.578    36.777     0.200
    23.653    36.010     0.200
    23.695    37.029     0.200
    23.702    37.336     0.200
    23.845    36.420     0.200
    23.822    37.071     0.200
    23.822    36.868     0.200
    23.822    36.071     0.200
    23.822    37.735     0.200
    23.887    36.880     0.200
    24.358    35.082     0.200
    24.398    34.994     0.200
    24.417    35.280     0.200
    24.568    35.701     0.200
    24.778    33.969     0.200
    25.048    33.666     0.200
    25.048    32.307     0.200
    25.048    33.775     0.200
    25.024    32.288     0.200
    25.024    33.101     0.200
    25.024    32.811     0.200
    25.024    32.546     0.200
    25.024    32.413     0.200
    25.024    33.014     0.200
    25.377    32.068     0.200
    25.362    32.478     0.200
    25.362    32.860     0.200
    25.363    33.525     0.200
    25.585    31.061     0.200
    25.585    31.904     0.200
    26.146    30.033     0.200
    26.440    28.496     0.200
    26.440    27.816     0.200
    26.644    28.798     0.200
    26.756    29.854     0.200
    26.881    27.874     0.200
    27.017    28.349     0.200
    27.017    27.802     0.200
    27.017    28.247     0.200
    27.017    28.052     0.200
    27.335    28.140     0.200
    27.411    27.451     0.200
    27.437    27.980     0.200
    27.567    26.758     0.200
    27.567    26.500     0.200
    27.567    26.015     0.200
    27.567    27.234     0.200
    27.567    27.437     0.200
    27.628    27.571     0.200
    27.630    25.883     0.200
    27.803    26.112     0.200
    27.881    25.890     0.200
    27.881    26.460     0.200
    27.943    26.635     0.200
    27.951    27.305     0.200
    27.954    26.856     0.200
    28.037    25.155     0.200
    28.044    26.559     0.200
    28.070    26.997     0.200
    28.083    24.803     0.200
    28.223    26.634     0.200
    28.403    24.749     0.200
    28.637    23.950     0.200
    28.662    23.951     0.200
    28.679    22.187     0.200
    28.679    22.788     0.200
    28.679    23.851     0.200
    28.679    23.546     0.200
    28.686    23.738     0.200
    28.686    23.067     0.200
    28.686    23.887     0.200
    28.686    24.004     0.200
    28.690    23.829     0.200
    28.746    24.249     0.200
    28.733    23.980     0.200
    28.733    24.462     0.200
    28.737    23.683     0.200
    28.742    24.538     0.200
    28.744    23.693     0.200
    28.799    22.770     0.200
    28.849    25.092     0.200
    28.886    24.649     0.200
    28.904    24.188     0.200
    28.963    24.843     0.200
    28.978    24.261     0.200
    28.978    24.871     0.200
    28.982    24.651     0.200
    28.984    24.398     0.200
    29.062    22.537     0.200
    29.028    24.175     0.200
    29.028    24.126     0.200
    29.125    23.937     0.200
    29.220    22.397     0.200
    29.290    23.260     0.200
    29.300    22.208     0.200
    29.327    21.504     0.200
    29.339    22.842     0.200
    29.381    23.010     0.200
    29.395    22.255     0.200
    29.407    23.573     0.200
    29.457    23.608     0.200
    29.457    21.077     0.200
    29.457    23.069     0.200
    29.605    20.591     0.200
    29.605    20.052     0.200
    29.605    19.950     0.200
    29.606    21.560     0.200
    29.720    22.178     0.200
    29.735    19.184     0.200
    19.393    40.179     0.200
    19.465    39.797     0.200
    19.641    38.907     0.200
    20.098    38.850     0.200
    20.205    38.460     0.200
    21.494    37.201     0.200
    21.917    38.673     0.200
    21.917    38.354     0.200
    21.917    38.915     0.200
    21.971    39.471     0.200
    22.310    38.015     0.200
    25.189    31.942     0.200
    25.236    33.813     0.200
    19.438    40.160     0.200
    25.020    32.329     0.200
    15.341    44.467     0.200
    15.721    41.633     0.200
    16.215    43.293     0.200
    17.284    44.993     0.200
    19.391    40.078     0.200
    19.395    41.419     0.200
    19.457    40.417     0.200
    19.634    40.561     0.200
    20.093    39.774     0.200
    20.200    39.958     0.200
    20.377    39.674     0.200
    20.784    41.472     0.200
    20.818    39.598     0.200
    20.912    40.696     0.200
    21.255    40.354     0.200
    21.918    38.855     0.200
    21.918    37.730     0.200
    22.291    39.454     0.200
    23.020    38.049     0.200
    23.020    37.932     0.200
    23.020    38.050     0.200
    25.184    32.004     0.200
    25.225    31.819     0.200
    25.988    31.418     0.200
    28.601    23.122     0.200
    17.351    42.095     0.200
    19.345    40.101     0.200
    19.543    39.474     0.200
    25.110    31.579     0.200
    19.318    40.802     0.200
    19.565    40.295     0.200
    20.020    40.861     0.200
    21.855    38.469     0.200
    25.111    32.074     0.200
    19.352    40.692     0.200
    19.588    40.401     0.200
    20.049    40.624     0.200
    21.891    39.208     0.200
    23.041    38.497     0.200
    25.140    32.325     0.200
    28.603    24.100     0.200
    14.894    44.229     0.200
    17.606    46.493     0.200
    19.277    39.461     0.200
    19.282    39.077     0.200
    19.282    40.436     0.200
    19.420    40.140     0.200
    19.420    38.515     0.200
    19.918    40.741     0.200
    20.025    38.486     0.200
    20.025    39.954     0.200
    21.271    37.915     0.200
    21.723    40.037     0.200
    21.894    38.745     0.200
    21.894    39.010     0.200
    21.894    39.549     0.200
    22.193    37.760     0.200
    23.238    38.816     0.200
    23.238    38.144     0.200
    23.715    36.992     0.200
    23.857    36.636     0.200
    25.007    33.469     0.200
    25.007    32.695     0.200
    28.747    23.619     0.200
    28.754    22.514     0.200
    14.700    45.444     0.200
    17.207    41.830     0.200
    17.269    43.203     0.200
    18.101    39.732     0.200
    19.330    39.274     0.200
    19.335    38.868     0.200
    19.346    39.871     0.200
    19.395    38.157     0.200
    19.395    39.038     0.200
    19.571    38.238     0.200
    19.571    39.712     0.200
    20.029    40.394     0.200
    20.136    39.828     0.200
    20.136    40.148     0.200
    21.869    38.515     0.200
    21.869    37.472     0.200
    22.273    36.718     0.200
    23.035    37.437     0.200
    23.035    37.917     0.200
    23.035    37.818     0.200
    23.035    38.318     0.200
    24.002    35.627     0.200
    25.120    31.433     0.200
    25.120    30.534     0.200
    25.120    31.683     0.200
    25.192    31.234     0.200
    25.344    32.571     0.200
    28.590    22.967     0.200
    28.590    22.893     0.200
    28.597    22.642     0.200
    19.332    41.776     0.200
    19.546    39.525     0.200
    19.546    41.235     0.200
    20.015    40.252     0.200
    20.122    39.226     0.200
    21.890    38.867     0.200
    21.890    37.583     0.200
    23.089    36.782     0.200
    25.106    32.450     0.200
    25.106    31.580     0.200
    28.638    22.873     0.200
    28.638    21.993     0.200
    17.350    42.391     0.200
    17.585    42.149     0.200
    19.328    39.815     0.200
    19.525    40.115     0.200
    19.525    39.340     0.200
    19.525    40.715     0.200
    20.002    40.276     0.200
    21.377    37.101     0.200
    21.898    38.585     0.200
    23.123    38.228     0.200
    23.123    37.378     0.200
    23.123    36.548     0.200
    23.959    36.373     0.200
    25.105    32.375     0.200
    25.091    32.554     0.200
    25.091    31.423     0.200
    25.387    31.202     0.200
    27.021    28.938     0.200
    28.666    23.510     0.200
    28.666    23.234     0.200
    28.673    23.554     0.200
    14.796    43.148     0.200
    16.803    42.123     0.200
    17.361    43.408     0.200
    17.523    44.619     0.200
    19.335    39.436     0.200
    19.340    39.737     0.200
    19.345    39.450     0.200
    19.356    38.223     0.200
    19.532    39.826     0.200
    19.532    40.373     0.200
    19.532    39.552     0.200
    19.532    40.779     0.200
    20.011    40.255     0.200
    20.118    39.586     0.200
    20.118    37.805     0.200
    21.384    37.761     0.200
    21.847    39.065     0.200
    21.912    38.643     0.200
    21.912    38.440     0.200
    21.912    38.901     0.200
    23.131    37.626     0.200
    23.131    38.181     0.200
    23.131    37.853     0.200
    23.131    39.283     0.200
    23.966    36.226     0.200
    25.101    32.288     0.200
    25.101    31.655     0.200
    25.101    32.585     0.200
    25.401    34.083     0.200
    26.105    29.096     0.200
    26.976    26.106     0.200
    27.034    28.928     0.200
    28.678    23.240     0.200
    28.678    23.091     0.200
    28.678    23.443     0.200
    28.685    23.589     0.200
    19.316    38.181     0.200
    19.388    39.600     0.200
    19.918    39.283     0.200
    25.004    33.201     0.200
    19.302    41.081     0.200
    19.540    38.856     0.200
    19.998    39.775     0.200
    21.847    38.698     0.200
    25.089    32.616     0.200
    17.447    44.363     0.200
    19.356    39.659     0.200
    19.360    38.236     0.200
    19.630    39.887     0.200
    19.630    39.786     0.200
    19.630    39.559     0.200
    19.630    39.684     0.200
    20.075    40.775     0.200
    20.181    39.445     0.200
    20.181    40.554     0.200
    21.868    37.783     0.200
    21.868    39.072     0.200
    21.971    39.168     0.200
    22.965    38.561     0.200
    22.965    37.428     0.200
    24.059    36.200     0.200
    25.166    32.326     0.200
    25.166    31.630     0.200
    25.268    32.024     0.200
    25.329    34.484     0.200
    28.538    23.802     0.200
    28.538    23.348     0.200
    28.545    23.924     0.200
    19.296    40.036     0.200
    19.436    39.654     0.200
    23.241    39.273     0.200
    25.025    31.185     0.200
    28.758    22.014     0.200
    19.331    41.004     0.200
    19.584    40.160     0.200
    20.037    39.097     0.200
    19.474    40.661     0.200
    19.977    39.404     0.200
    25.066    32.048     0.200
    19.298    41.478     0.200
    19.451    39.346     0.200
    19.946    40.614     0.200
    23.215    38.264     0.200
    25.035    31.908     0.200
    28.736    22.945     0.200
    19.457    40.137     0.200
    25.029    31.951     0.200
    19.184    39.103     0.200
    19.571    40.790     0.200
    19.571    38.279     0.200
    20.020    38.599     0.200
    24.000    35.696     0.200
    25.111    32.631     0.200
    25.111    30.998     0.200
    25.311    33.897     0.200
    28.553    23.810     0.200
    22.820    38.783     0.200
    28.426    23.310     0.200
    19.604    39.015     0.200
    25.156    31.619     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.222    12.132     0.200
     2.353    12.112     0.200
     2.299    11.239     0.200
     2.547    12.346     0.200
     2.532    12.317     0.200
     2.680    12.686     0.200
     2.761    13.443     0.200
     2.962    13.102     0.200
     3.198    14.043     0.200
     3.542    14.336     0.200
     3.542    14.487     0.200
     3.793    15.197     0.200
     3.889    15.188     0.200
     3.889    15.506     0.200
     3.957    15.995     0.200
     4.077    15.153     0.200
     4.084    15.109     0.200
     4.420    15.986     0.200
     4.397    16.649     0.200
     4.462    16.376     0.200
     4.592    15.880     0.200
     4.621    16.546     0.200
     4.722    17.352     0.200
     5.172    17.615     0.200
     5.562    18.459     0.200
     5.562    19.160     0.200
     5.668    18.726     0.200
     5.725    18.958     0.200
     5.906    20.340     0.200
     5.906    20.074     0.200
     5.906    19.539     0.200
     5.863    18.952     0.200
     5.983    21.237     0.200
     5.983    19.616     0.200
     6.034    19.853     0.200
     6.118    20.271     0.200
     6.125    19.797     0.200
     6.231    20.155     0.200
     6.231    19.915     0.200
     6.496    20.694     0.200
     6.594    21.413     0.200
     6.585    20.123     0.200
     6.814    21.343     0.200
     6.870    21.599     0.200
     6.920    21.705     0.200
     7.096    21.558     0.200
     7.096    22.109     0.200
     7.137    20.599     0.200
     7.137    20.360     0.200
     7.137    20.759     0.200
     7.246    21.513     0.200
     7.246    21.712     0.200
     7.216    22.751     0.200
     7.357    22.606     0.200
     7.543    22.646     0.200
     7.547    22.791     0.200
     7.784    22.979     0.200
     7.931    22.201     0.200
     7.948    23.414     0.200
     8.124    23.860     0.200
     8.146    24.400     0.200
     8.451    24.943     0.200
     8.522    25.721     0.200
     8.513    25.320     0.200
     8.592    25.095     0.200
     8.662    25.088     0.200
     8.660    25.006     0.200
     8.658    25.224     0.200
     8.737    25.710     0.200
     8.737    26.319     0.200
     8.776    25.616     0.200
     8.734    24.045     0.200
     8.884    26.001     0.200
     8.922    23.690     0.200
     8.922    23.952     0.200
     9.024    26.651     0.200
     9.114    23.313     0.200
     9.114    24.272     0.200
     9.085    26.659     0.200
     9.269    24.623     0.200
     9.304    26.892     0.200
     9.370    26.717     0.200
     9.476    26.582     0.200
     9.476    26.880     0.200
     9.476    27.201     0.200
     9.542    26.139     0.200
     9.563    27.762     0.200
     9.681    28.195     0.200
     9.748    25.246     0.200
     9.748    24.557     0.200
     9.776    27.088     0.200
     9.908    27.723     0.200
     9.908    27.069     0.200
     9.899    28.458     0.200
     9.951    27.868     0.200
     9.951    27.307     0.200
    10.009    24.521     0.200
     9.986    28.135     0.200
     9.986    29.674     0.200
    10.124    27.724     0.200
    10.124    28.435     0.200
    10.246    28.239     0.200
    10.444    29.161     0.200
    10.498    28.158     0.200
    10.507    28.328     0.200
    10.508    29.061     0.200
    10.655    25.470     0.200
    10.709    30.776     0.200
    10.779    27.161     0.200
    10.779    26.514     0.200
    10.860    30.226     0.200
    10.860    27.107     0.200
    10.860    29.258     0.200
    10.860    27.828     0.200
    10.860    28.738     0.200
    10.860    27.447     0.200
    10.860    26.887     0.200
    10.815    30.154     0.200
    10.876    30.501     0.200
    11.017    28.974     0.200
    10.996    29.967     0.200
    10.996    29.166     0.200
    10.924    29.485     0.200
    10.992    26.278     0.200
    11.043    30.415     0.200
    11.043    29.494     0.200
    11.022    29.843     0.200
    11.037    27.140     0.200
    11.152    30.608     0.200
    11.152    30.340     0.200
    11.088    28.367     0.200
    11.088    28.109     0.200
    11.149    30.423     0.200
    11.287    30.623     0.200
    11.287    29.900     0.200
    11.270    31.043     0.200
    11.474    29.841     0.200
    11.504    31.167     0.200
    11.504    30.607     0.200
    11.504    30.550     0.200
    11.572    29.247     0.200
    11.709    31.569     0.200
    11.709    31.235     0.200
    11.735    30.480     0.200
    11.729    31.890     0.200
    11.837    31.077     0.200
    11.837    30.971     0.200
    11.832    28.691     0.200
    11.909    31.696     0.200
    12.034    30.673     0.200
    12.129    29.613     0.200
    12.214    31.772     0.200
    12.135    32.754     0.200
    12.158    33.188     0.200
    12.273    29.560     0.200
    12.278    32.407     0.200
    12.290    31.691     0.200
    12.249    28.802     0.200
    12.454    32.962     0.200
    12.559    32.088     0.200
    12.488    32.031     0.200
    12.616    32.300     0.200
    12.643    30.868     0.200
    12.684    31.666     0.200
    12.664    29.677     0.200
    12.664    29.500     0.200
    12.664    29.947     0.200
    12.664    30.048     0.200
    12.664    30.337     0.200
    12.664    31.677     0.200
    12.664    31.177     0.200
    12.664    31.316     0.200
    12.759    34.372     0.200
    12.876    34.277     0.200
    12.906    32.447     0.200
    12.906    32.901     0.200
    12.904    34.278     0.200
    12.951    31.826     0.200
    13.038    31.808     0.200
    13.027    30.238     0.200
    13.041    35.899     0.200
    13.037    29.801     0.200
    13.064    35.101     0.200
    13.141    33.803     0.200
    13.058    33.182     0.200
    13.232    34.304     0.200
    13.232    33.425     0.200
    13.231    36.314     0.200
    13.277    33.762     0.200
    13.204    34.881     0.200
    13.301    34.046     0.200
    13.316    35.367     0.200
    13.482    31.732     0.200
    13.495    33.306     0.200
    13.546    33.888     0.200
    13.553    33.830     0.200
    13.579    36.495     0.200
    13.600    36.150     0.200
    13.676    34.006     0.200
    13.695    35.650     0.200
    13.772    35.022     0.200
    13.784    33.749     0.200
    13.784    35.220     0.200
    13.787    32.610     0.200
    13.862    36.095     0.200
    13.929    36.018     0.200
    14.051    34.861     0.200
    14.114    31.753     0.200
    14.114    34.554     0.200
    14.193    35.811     0.200
    14.316    36.722     0.200
    14.346    34.539     0.200
    14.349    34.755     0.200
    14.373    33.812     0.200
    14.362    32.895     0.200
    14.399    34.403     0.200
    14.486    35.722     0.200
    14.695    32.620     0.200
    14.657    32.533     0.200
    14.657    33.023     0.200
    14.657    33.184     0.200
    14.679    39.260     0.200
    14.679    36.973     0.200
    14.679    38.528     0.200
    14.679    36.309     0.200
    14.679    37.659     0.200
    14.679    37.120     0.200
    14.841    37.161     0.200
    14.903    39.546     0.200
    14.976    39.083     0.200
    15.082    35.960     0.200
    15.168    36.268     0.200
    15.147    33.322     0.200
    15.344    33.288     0.200
    15.321    36.457     0.200
    15.573    39.228     0.200
    15.596    37.673     0.200
    15.652    35.455     0.200
    15.652    34.207     0.200
    15.715    33.665     0.200
    15.697    36.356     0.200
    15.707    37.590     0.200
    15.786    33.885     0.200
    15.758    39.085     0.200
    15.787    36.467     0.200
    16.018    35.012     0.200
    16.018    35.836     0.200
    16.360    34.927     0.200
    16.169    34.218     0.200
    16.169    35.153     0.200
    16.169    35.843     0.200
    16.343    36.860     0.200
    16.404    39.783     0.200
    16.542    39.805     0.200
    17.064    36.737     0.200
    17.239    34.909     0.200
    17.250    38.737     0.200
    17.250    39.561     0.200
    17.250    38.160     0.200
    17.283    39.411     0.200
    17.312    39.386     0.200
    17.403    38.727     0.200
    17.483    37.329     0.200
    17.483    38.444     0.200
    17.485    38.016     0.200
    17.485    38.130     0.200
    17.485    38.385     0.200
    17.485    39.815     0.200
    17.485    38.969     0.200
    17.506    40.973     0.200
    17.766    38.134     0.200
    17.974    38.712     0.200
    17.985    39.209     0.200
    18.086    38.355     0.200
    18.086    38.898     0.200
    18.086    38.680     0.200
    18.175    39.638     0.200
    18.148    37.457     0.200
    18.148    39.135     0.200
    18.411    39.169     0.200
    19.348    41.031     0.200
    19.326    41.135     0.200
    19.335    41.128     0.200
    19.335    42.452     0.200
    19.534    42.639     0.200
    19.586    40.170     0.200
    19.667    40.950     0.200
    20.238    39.816     0.200
    20.513    39.632     0.200
    20.817    40.500     0.200
     2.315    12.226     0.200
     2.547    12.918     0.200
     2.693    13.317     0.200
     2.773    14.699     0.200
     2.977    13.707     0.200
     3.213    14.948     0.200
     3.549    15.623     0.200
     3.904    15.580     0.200
     3.904    15.800     0.200
     4.091    16.360     0.200
     4.098    16.015     0.200
     4.435    16.885     0.200
     4.411    16.964     0.200
     4.475    18.672     0.200
     4.607    17.484     0.200
     4.634    16.963     0.200
     4.736    17.853     0.200
     5.183    18.263     0.200
     5.577    20.129     0.200
     5.675    19.611     0.200
     5.735    19.815     0.200
     5.891    17.882     0.200
     5.878    19.446     0.200
     6.041    20.747     0.200
     6.130    21.105     0.200
     6.141    20.796     0.200
     6.235    20.852     0.200
     6.510    21.919     0.200
     6.601    21.512     0.200
     6.933    22.335     0.200
     7.109    21.879     0.200
     7.109    23.160     0.200
     7.130    22.577     0.200
     7.130    22.208     0.200
     7.241    23.544     0.200
     7.241    24.413     0.200
     7.374    23.294     0.200
     7.559    23.734     0.200
     7.564    24.378     0.200
     7.799    25.443     0.200
     7.924    24.257     0.200
     8.161    25.101     0.200
     8.465    25.655     0.200
     8.528    25.125     0.200
     8.677    25.785     0.200
     8.676    26.492     0.200
     8.792    26.136     0.200
     8.900    27.508     0.200
     8.912    25.953     0.200
     9.112    26.976     0.200
     9.258    26.580     0.200
     9.742    27.307     0.200
     9.792    28.508     0.200
     9.913    30.403     0.200
     9.909    28.272     0.200
     9.956    30.115     0.200
    10.001    27.515     0.200
    10.503    31.289     0.200
    10.511    30.581     0.200
    10.647    28.127     0.200
    10.773    26.609     0.200
    10.773    28.455     0.200
    10.865    27.274     0.200
    10.865    32.625     0.200
    11.000    31.010     0.200
    11.000    32.627     0.200
    11.048    33.039     0.200
    11.030    29.891     0.200
    11.091    29.992     0.200
    11.091    28.855     0.200
    11.157    32.215     0.200
    11.286    32.933     0.200
    11.478    33.819     0.200
    11.738    33.365     0.200
    11.841    32.728     0.200
    11.819    33.914     0.200
    11.925    33.284     0.200
    12.035    33.630     0.200
    12.119    29.993     0.200
    12.217    34.871     0.200
    12.273    32.530     0.200
    12.262    33.893     0.200
    12.561    35.080     0.200
    12.649    33.414     0.200
    12.685    33.482     0.200
    12.655    31.692     0.200
    12.655    31.882     0.200
    12.655    32.561     0.200
    12.655    30.763     0.200
    13.316    36.445     0.200
    13.472    33.324     0.200
    13.710    38.046     0.200
    13.878    37.785     0.200
    13.933    34.791     0.200
    13.943    35.625     0.200
    14.052    36.803     0.200
    14.104    34.355     0.200
    14.104    35.355     0.200
    14.333    36.350     0.200
    14.351    34.381     0.200
    14.662    34.810     0.200
    14.662    34.489     0.200
    14.662    35.460     0.200
    14.695    39.447     0.200
    14.695    38.171     0.200
    14.856    38.243     0.200
    15.169    38.305     0.200
    15.334    37.075     0.200
    15.337    38.046     0.200
    15.648    36.369     0.200
    15.705    37.619     0.200
    15.704    38.692     0.200
    15.776    38.344     0.200
    15.798    37.681     0.200
    15.798    37.357     0.200
    16.024    36.391     0.200
    16.024    36.190     0.200
    16.024    36.541     0.200
    16.349    38.767     0.200
    16.159    38.547     0.200
    16.325    38.988     0.200
    17.202    41.392     0.200
    17.236    40.822     0.200
    17.265    40.239     0.200
    17.485    39.097     0.200
    18.097    39.885     0.200
    18.097    39.596     0.200
    18.097    39.436     0.200
    18.157    39.603     0.200
    18.869    40.586     0.200
    19.067    42.732     0.200
    19.138    42.002     0.200
    19.341    42.133     0.200
    19.351    43.418     0.200
    19.652    41.009     0.200
    19.682    42.259     0.200
    20.834    41.447     0.200
     2.306    12.315     0.200
     2.257    12.982     0.200
     2.306    12.122     0.200
     2.494    13.118     0.200
     2.554    12.718     0.200
     2.642    12.995     0.200
     2.800    13.947     0.200
     3.223    14.617     0.200
     3.489    15.011     0.200
     3.489    14.861     0.200
     3.826    16.476     0.200
     3.903    16.451     0.200
     4.050    15.705     0.200
     4.057    15.588     0.200
     4.398    16.498     0.200
     4.427    17.162     0.200
     4.495    18.395     0.200
     4.567    16.428     0.200
     4.588    16.985     0.200
     4.749    18.133     0.200
     5.127    17.692     0.200
     5.615    19.401     0.200
     5.583    19.678     0.200
     5.678    19.564     0.200
     5.922    17.565     0.200
     5.980    19.943     0.200
     6.078    20.498     0.200
     6.173    20.186     0.200
     6.314    18.107     0.200
     6.464    21.125     0.200
     6.882    21.813     0.200
     7.061    22.328     0.200
     7.061    22.568     0.200
     7.189    24.533     0.200
     7.189    23.251     0.200
     7.191    22.037     0.200
     7.351    23.238     0.200
     7.547    23.359     0.200
     7.759    24.755     0.200
     7.986    22.863     0.200
     8.122    25.040     0.200
     8.119    23.977     0.200
     8.681    26.955     0.200
     8.764    25.993     0.200
     8.881    27.235     0.200
     8.970    24.688     0.200
     9.314    25.603     0.200
     9.488    26.101     0.200
     9.765    28.203     0.200
     9.852    28.330     0.200
    10.061    26.177     0.200
    10.707    27.002     0.200
    10.834    27.250     0.200
    11.041    27.091     0.200
    11.147    28.507     0.200
    11.972    30.059     0.200
    12.177    29.409     0.200
    12.714    32.726     0.200
    12.714    32.526     0.200
    12.714    31.485     0.200
    12.714    32.255     0.200
    13.192    33.460     0.200
    13.530    34.429     0.200
    13.503    37.172     0.200
    14.160    34.075     0.200
    14.160    35.176     0.200
    14.406    34.604     0.200
    14.406    34.934     0.200
    14.527    38.666     0.200
    14.693    37.060     0.200
    14.693    36.755     0.200
    14.713    36.677     0.200
    14.713    36.917     0.200
    14.863    38.312     0.200
    15.341    39.075     0.200
    15.578    39.300     0.200
    15.771    41.412     0.200
    15.833    37.391     0.200
    16.009    37.031     0.200
    16.073    37.483     0.200
    16.216    37.585     0.200
    17.284    39.531     0.200
    17.273    39.511     0.200
    17.273    40.849     0.200
    17.509    40.637     0.200
    17.509    41.098     0.200
    18.042    39.121     0.200
    18.042    38.892     0.200
    19.155    40.493     0.200
    20.127    41.724     0.200
    20.201    41.084     0.200
    20.819    41.274     0.200
    21.059    41.668     0.200
     2.234    13.402     0.200
     2.287    12.572     0.200
     2.311    12.803     0.200
     2.533    14.212     0.200
     2.503    13.456     0.200
     2.642    13.440     0.200
     2.964    14.877     0.200
     3.201    14.917     0.200
     3.498    15.847     0.200
     3.498    15.636     0.200
     3.883    16.656     0.200
     3.883    17.406     0.200
     3.959    17.467     0.200
     4.044    17.255     0.200
     4.051    16.395     0.200
     4.404    18.073     0.200
     4.390    17.236     0.200
     4.471    18.592     0.200
     4.560    17.450     0.200
     5.130    18.598     0.200
     5.561    19.670     0.200
     5.683    20.251     0.200
     5.857    20.418     0.200
     5.933    19.553     0.200
     5.990    21.067     0.200
     6.009    24.259     0.200
     6.009    22.029     0.200
     6.079    20.731     0.200
     6.115    21.378     0.200
     6.187    21.296     0.200
     6.322    19.206     0.200
     6.460    21.948     0.200
     6.553    22.490     0.200
     6.801    22.598     0.200
     7.059    23.132     0.200
     7.181    22.299     0.200
     7.181    21.918     0.200
     7.175    23.038     0.200
     7.211    23.520     0.200
     7.337    24.142     0.200
     7.524    24.666     0.200
     7.531    23.883     0.200
     7.752    25.683     0.200
     7.932    24.400     0.200
     7.975    24.318     0.200
     8.105    25.387     0.200
     8.115    25.465     0.200
     8.416    25.149     0.200
     8.480    26.602     0.200
     8.478    26.334     0.200
     8.577    26.576     0.200
     8.632    26.228     0.200
     8.641    26.625     0.200
     8.640    25.942     0.200
     8.752    26.921     0.200
     8.714    24.981     0.200
     8.693    26.922     0.200
     8.693    27.473     0.200
     8.866    27.012     0.200
     8.964    27.004     0.200
     8.964    26.015     0.200
     8.981    27.058     0.200
     9.067    27.309     0.200
     9.075    26.798     0.200
     9.270    26.785     0.200
     9.311    26.952     0.200
     9.339    28.177     0.200
     9.342    28.048     0.200
     9.500    28.204     0.200
     9.499    28.795     0.200
     9.531    29.142     0.200
     9.649    27.768     0.200
     9.753    28.906     0.200
     9.792    27.262     0.200
     9.857    28.587     0.200
     9.864    28.557     0.200
     9.864    28.761     0.200
     9.907    29.211     0.200
     9.907    28.557     0.200
     9.971    31.670     0.200
    10.053    27.292     0.200
    10.104    29.669     0.200
    10.401    30.453     0.200
    10.454    30.116     0.200
    10.463    28.965     0.200
    10.463    30.127     0.200
    10.529    31.913     0.200
    10.699    28.544     0.200
    10.689    32.191     0.200
    10.788    31.467     0.200
    10.823    28.860     0.200
    10.823    28.782     0.200
    10.817    29.742     0.200
    10.817    29.517     0.200
    10.817    30.584     0.200
    10.817    30.207     0.200
    10.817    30.967     0.200
    10.846    31.805     0.200
    10.908    31.069     0.200
    10.908    31.569     0.200
    10.952    30.096     0.200
    10.952    30.953     0.200
    11.000    31.132     0.200
    11.035    28.111     0.200
    11.081    29.688     0.200
    11.125    28.533     0.200
    11.125    28.873     0.200
    11.109    31.037     0.200
    11.109    31.315     0.200
    11.210    31.891     0.200
    11.262    32.336     0.200
    11.243    30.826     0.200
    11.243    31.541     0.200
    11.431    30.044     0.200
    11.460    31.900     0.200
    11.460    32.697     0.200
    11.530    31.897     0.200
    11.665    31.343     0.200
    11.665    32.593     0.200
    11.707    32.950     0.200
    11.693    30.618     0.200
    11.794    31.462     0.200
    11.794    32.768     0.200
    11.775    33.170     0.200
    11.871    30.838     0.200
    11.896    33.036     0.200
    11.992    32.818     0.200
    12.121    34.319     0.200
    12.137    33.224     0.200
    12.172    29.415     0.200
    12.171    33.513     0.200
    12.232    32.885     0.200
    12.246    32.439     0.200
    12.292    31.486     0.200
    12.410    33.965     0.200
    12.516    34.181     0.200
    12.634    34.866     0.200
    12.610    32.482     0.200
    12.643    33.108     0.200
    12.707    32.540     0.200
    12.707    31.966     0.200
    12.707    32.796     0.200
    12.707    33.276     0.200
    12.707    31.575     0.200
    12.707    33.995     0.200
    12.736    34.936     0.200
    12.834    35.163     0.200
    12.886    35.587     0.200
    12.862    33.785     0.200
    12.994    32.417     0.200
    13.005    35.438     0.200
    13.005    35.905     0.200
    13.022    35.784     0.200
    13.058    33.680     0.200
    13.070    32.955     0.200
    13.080    32.685     0.200
    13.183    37.128     0.200
    13.190    33.153     0.200
    13.201    36.213     0.200
    13.192    35.425     0.200
    13.194    35.681     0.200
    13.188    35.392     0.200
    13.220    35.048     0.200
    13.233    35.947     0.200
    13.300    35.462     0.200
    13.300    37.967     0.200
    13.423    36.301     0.200
    13.487    38.019     0.200
    13.525    33.636     0.200
    13.503    34.678     0.200
    13.538    34.365     0.200
    13.590    37.269     0.200
    13.596    33.058     0.200
    13.590    35.633     0.200
    13.691    36.895     0.200
    13.678    36.884     0.200
    13.728    34.759     0.200
    13.741    35.870     0.200
    13.853    37.499     0.200
    13.933    35.169     0.200
    13.984    34.932     0.200
    14.010    36.696     0.200
    14.156    34.066     0.200
    14.156    35.566     0.200
    14.186    36.882     0.200
    14.170    36.636     0.200
    14.333    36.467     0.200
    14.343    37.730     0.200
    14.358    37.634     0.200
    14.361    37.320     0.200
    14.403    33.622     0.200
    14.384    35.437     0.200
    14.464    36.499     0.200
    14.504    36.919     0.200
    14.569    34.294     0.200
    14.673    37.707     0.200
    14.673    39.330     0.200
    14.673    37.826     0.200
    14.673    38.436     0.200
    14.673    37.436     0.200
    14.673    40.590     0.200
    14.690    35.982     0.200
    14.690    35.010     0.200
    14.842    37.436     0.200
    15.124    37.273     0.200
    15.127    39.687     0.200
    15.187    37.202     0.200
    15.320    37.723     0.200
    15.387    35.666     0.200
    15.464    39.899     0.200
    15.561    39.943     0.200
    15.580    38.973     0.200
    15.696    35.102     0.200
    15.702    39.798     0.200
    15.728    37.805     0.200
    15.751    40.422     0.200
    15.757    37.832     0.200
    15.809    38.988     0.200
    15.809    37.998     0.200
    15.828    36.144     0.200
    16.050    36.817     0.200
    16.402    38.208     0.200
    16.211    35.484     0.200
    16.211    36.543     0.200
    16.360    39.474     0.200
    16.377    38.144     0.200
    16.392    39.815     0.200
    16.538    41.193     0.200
    16.693    39.456     0.200
    16.711    41.065     0.200
    17.251    39.466     0.200
    17.251    40.145     0.200
    17.251    38.944     0.200
    17.268    40.311     0.200
    17.282    38.546     0.200
    17.359    39.525     0.200
    17.441    39.987     0.200
    17.487    39.362     0.200
    17.487    39.476     0.200
    17.487    39.624     0.200
    17.487    40.095     0.200
    17.487    39.095     0.200
    17.487    40.724     0.200
    17.706    40.959     0.200
    17.771    38.981     0.200
    17.931    40.299     0.200
    17.960    40.310     0.200
    18.044    39.784     0.200
    18.044    39.528     0.200
    18.044    39.970     0.200
    18.044    39.233     0.200
    18.044    39.649     0.200
    18.126    41.325     0.200
    18.172    39.378     0.200
    18.131    40.710     0.200
    18.368    41.637     0.200
    18.831    42.529     0.200
    19.054    42.806     0.200
    19.325    42.548     0.200
    19.323    43.965     0.200
    19.323    43.715     0.200
    19.323    42.783     0.200
    19.323    44.264     0.200
    19.534    42.899     0.200
    19.595    42.428     0.200
    19.627    42.143     0.200
    20.111    41.590     0.200
    20.117    42.439     0.200
    20.188    42.294     0.200
    20.767    41.300     0.200
    20.802    41.897     0.200
     2.187    12.981     0.200
     2.214    12.871     0.200
     2.244    12.322     0.200
     2.446    12.861     0.200
     2.471    13.270     0.200
     2.567    12.952     0.200
     2.905    14.409     0.200
     3.141    14.850     0.200
     3.441    14.449     0.200
     3.752    16.614     0.200
     3.899    17.200     0.200
     3.963    16.040     0.200
     3.970    15.569     0.200
     4.309    16.521     0.200
     4.422    15.801     0.200
     4.479    16.830     0.200
     4.506    17.016     0.200
     4.670    16.629     0.200
     5.497    19.549     0.200
     5.566    19.047     0.200
     5.616    19.370     0.200
     6.014    18.971     0.200
     6.005    20.130     0.200
     6.042    19.749     0.200
     6.144    20.305     0.200
     6.262    17.725     0.200
     6.482    21.957     0.200
     7.236    21.230     0.200
     9.030    24.924     0.200
    10.113    27.037     0.200
    10.760    27.105     0.200
    10.875    27.381     0.200
    11.075    28.166     0.200
    12.770    33.381     0.200
    12.770    32.605     0.200
    14.688    35.099     0.200
    14.688    35.789     0.200
    16.042    37.320     0.200
    16.279    37.380     0.200
    17.420    38.708     0.200
     2.361    11.852     0.200
     2.587    12.609     0.200
     2.801    13.838     0.200
     3.015    13.412     0.200
     3.252    13.954     0.200
     3.840    15.883     0.200
     3.947    15.334     0.200
     4.010    16.006     0.200
     4.138    15.168     0.200
     4.145    15.127     0.200
     4.508    17.494     0.200
     4.483    16.085     0.200
     4.654    16.289     0.200
     4.680    16.489     0.200
     4.773    17.498     0.200
     5.222    17.457     0.200
     5.617    18.846     0.200
     5.617    19.564     0.200
     5.843    21.466     0.200
     5.843    20.237     0.200
     5.773    19.132     0.200
     5.919    22.086     0.200
     5.921    19.400     0.200
     6.186    19.397     0.200
     6.258    19.620     0.200
     6.408    17.493     0.200
     6.555    20.793     0.200
     6.646    21.241     0.200
     6.877    21.449     0.200
     6.932    21.797     0.200
     6.976    21.590     0.200
     7.100    21.891     0.200
     7.100    21.776     0.200
     7.100    22.298     0.200
     7.154    21.919     0.200
     7.154    21.798     0.200
     7.237    22.839     0.200
     7.237    24.389     0.200
     7.421    23.192     0.200
     7.606    23.033     0.200
     7.610    23.385     0.200
     7.896    23.538     0.200
     7.846    23.468     0.200
     8.011    24.308     0.200
     8.188    24.348     0.200
     8.209    24.405     0.200
     8.511    24.875     0.200
     8.554    23.475     0.200
     8.575    25.134     0.200
     8.655    24.994     0.200
     8.724    26.195     0.200
     8.725    25.382     0.200
     8.876    24.632     0.200
     8.771    26.817     0.200
     8.798    26.432     0.200
     8.841    25.661     0.200
     8.948    26.870     0.200
     9.219    25.963     0.200
     9.118    24.189     0.200
     9.118    26.468     0.200
     9.148    27.059     0.200
     9.412    27.062     0.200
     9.412    28.747     0.200
     9.566    28.317     0.200
     9.714    26.754     0.200
     9.968    26.632     0.200
     9.840    27.682     0.200
     9.938    29.818     0.200
     9.938    29.931     0.200
     9.947    28.366     0.200
     9.980    30.059     0.200
    10.048    29.436     0.200
    10.048    30.006     0.200
    10.187    28.612     0.200
    10.187    28.231     0.200
    10.371    23.821     0.200
    10.613    26.662     0.200
    10.526    31.107     0.200
    10.534    31.358     0.200
    10.534    31.061     0.200
    10.536    31.189     0.200
    10.604    31.104     0.200
    10.604    31.403     0.200
    10.745    27.550     0.200
    10.773    32.262     0.200
    10.947    26.883     0.200
    10.879    31.043     0.200
    10.887    30.666     0.200
    10.887    29.496     0.200
    10.887    28.707     0.200
    10.887    31.871     0.200
    10.887    31.215     0.200
    10.887    29.707     0.200
    11.089    28.204     0.200
    11.023    31.017     0.200
    11.023    31.838     0.200
    11.073    32.196     0.200
    11.194    29.966     0.200
    11.179    31.516     0.200
    11.179    32.599     0.200
    11.330    32.975     0.200
    11.316    32.348     0.200
    11.316    32.789     0.200
    11.498    32.303     0.200
    11.534    33.401     0.200
    11.534    33.582     0.200
    11.587    32.076     0.200
    11.776    30.570     0.200
    11.740    33.374     0.200
    11.754    32.527     0.200
    11.864    31.906     0.200
    11.970    33.006     0.200
    12.083    28.233     0.200
    12.049    33.109     0.200
    12.206    29.491     0.200
    12.222    32.973     0.200
    12.236    33.633     0.200
    12.283    31.303     0.200
    12.317    33.693     0.200
    12.579    34.413     0.200
    12.620    30.981     0.200
    12.620    31.153     0.200
    12.620    31.967     0.200
    12.620    30.582     0.200
    12.620    31.256     0.200
    12.620    30.733     0.200
    12.620    32.522     0.200
    12.549    32.550     0.200
    12.577    34.393     0.200
    12.657    32.607     0.200
    12.698    33.200     0.200
    12.907    31.479     0.200
    12.983    30.306     0.200
    12.975    34.024     0.200
    12.994    29.964     0.200
    12.922    36.306     0.200
    12.939    34.439     0.200
    12.967    34.770     0.200
    13.098    32.162     0.200
    13.113    34.775     0.200
    13.100    36.491     0.200
    13.260    36.552     0.200
    13.289    36.609     0.200
    13.289    37.260     0.200
    13.303    36.289     0.200
    13.436    32.205     0.200
    13.356    35.829     0.200
    13.324    35.228     0.200
    13.451    31.050     0.200
    13.506    32.546     0.200
    13.620    36.291     0.200
    13.589    35.941     0.200
    13.685    37.806     0.200
    13.752    37.712     0.200
    13.904    34.057     0.200
    13.923    38.024     0.200
    13.996    37.806     0.200
    13.980    34.350     0.200
    14.065    35.154     0.200
    14.065    34.404     0.200
    14.064    37.128     0.200
    14.270    36.952     0.200
    14.285    36.665     0.200
    14.285    36.309     0.200
    14.311    32.874     0.200
    14.311    33.985     0.200
    14.312    36.688     0.200
    14.253    37.536     0.200
    14.393    38.091     0.200
    14.481    34.137     0.200
    14.577    38.181     0.200
    14.667    34.028     0.200
    14.738    39.886     0.200
    14.738    37.613     0.200
    14.738    38.103     0.200
    14.896    36.740     0.200
    15.033    36.466     0.200
    15.094    34.553     0.200
    15.094    34.139     0.200
    15.182    38.809     0.200
    15.297    35.576     0.200
    15.377    37.610     0.200
    15.627    35.099     0.200
    15.668    35.854     0.200
    15.635    39.558     0.200
    15.714    36.722     0.200
    15.659    40.238     0.200
    15.765    39.937     0.200
    15.819    37.672     0.200
    15.819    37.502     0.200
    15.817    40.427     0.200
    16.311    37.007     0.200
    16.033    35.474     0.200
    16.033    35.773     0.200
    16.121    35.789     0.200
    16.121    36.525     0.200
    16.121    38.719     0.200
    16.280    39.029     0.200
    16.291    39.300     0.200
    16.245    40.115     0.200
    16.652    40.210     0.200
    16.599    40.546     0.200
    16.745    39.481     0.200
    17.217    36.847     0.200
    17.242    41.387     0.200
    17.303    36.319     0.200
    17.303    40.868     0.200
    17.303    37.868     0.200
    17.346    41.458     0.200
    17.501    40.845     0.200
    17.538    38.836     0.200
    17.538    39.096     0.200
    17.538    40.926     0.200
    17.538    38.426     0.200
    17.538    37.543     0.200
    17.538    40.656     0.200
    17.652    40.662     0.200
    17.993    40.712     0.200
    18.049    40.524     0.200
    18.175    39.724     0.200
    18.175    38.974     0.200
    18.137    38.628     0.200
    18.137    38.527     0.200
    18.137    39.158     0.200
    18.137    38.796     0.200
    18.198    41.030     0.200
    18.909    41.700     0.200
    19.105    43.539     0.200
    19.412    41.894     0.200
    19.397    42.163     0.200
    19.397    42.562     0.200
    19.397    41.812     0.200
    19.525    40.889     0.200
    19.719    41.882     0.200
    20.190    41.802     0.200
    20.963    41.288     0.200
     2.364    12.284     0.200
     2.588    13.262     0.200
     2.593    13.011     0.200
     2.742    13.174     0.200
     2.800    15.003     0.200
     3.016    14.066     0.200
     3.253    14.708     0.200
     3.587    14.709     0.200
     3.587    15.559     0.200
     3.841    17.150     0.200
     3.950    16.476     0.200
     3.950    16.656     0.200
     4.011    16.561     0.200
     4.143    17.047     0.200
     4.447    17.668     0.200
     4.508    17.810     0.200
     4.488    17.196     0.200
     4.659    16.898     0.200
     4.685    17.494     0.200
     4.774    18.777     0.200
     5.228    18.157     0.200
     5.619    19.695     0.200
     5.619    19.996     0.200
     5.713    19.997     0.200
     5.838    18.868     0.200
     6.076    20.756     0.200
     6.189    20.904     0.200
     6.178    20.769     0.200
     6.263    20.673     0.200
     6.263    20.343     0.200
     6.413    17.803     0.200
     6.560    21.307     0.200
     7.095    21.643     0.200
     7.095    22.623     0.200
     7.159    23.372     0.200
     7.851    25.358     0.200
     8.845    25.830     0.200
     8.870    25.679     0.200
     8.870    24.909     0.200
     8.870    25.859     0.200
     9.213    25.871     0.200
     9.962    26.669     0.200
    10.607    27.590     0.200
    10.740    28.264     0.200
    10.740    28.139     0.200
    11.085    28.760     0.200
    11.771    34.904     0.200
    12.077    28.769     0.200
    12.614    32.389     0.200
    12.614    31.130     0.200
    12.614    30.079     0.200
    12.614    31.009     0.200
    13.092    34.439     0.200
    14.060    34.791     0.200
    14.306    34.471     0.200
    14.306    33.692     0.200
    14.663    33.256     0.200
    14.663    34.145     0.200
    14.663    34.516     0.200
    14.897    34.892     0.200
    15.041    40.276     0.200
    15.817    36.528     0.200
    16.029    35.504     0.200
    17.305    37.547     0.200
    18.142    39.537     0.200
    20.108    41.315     0.200
     2.225    12.657     0.200
     2.288    12.423     0.200
     2.528    13.221     0.200
     2.655    13.136     0.200
     2.766    14.225     0.200
     2.959    14.392     0.200
     3.195    15.133     0.200
     3.515    14.901     0.200
     3.794    16.539     0.200
     3.881    16.233     0.200
     3.881    16.553     0.200
     3.953    17.085     0.200
     4.061    15.528     0.200
     4.399    17.388     0.200
     4.397    16.808     0.200
     4.596    16.582     0.200
     5.641    19.492     0.200
     5.698    19.922     0.200
     6.007    19.916     0.200
     6.092    20.724     0.200
     6.205    20.608     0.200
     6.205    20.198     0.200
     6.568    21.072     0.200
    10.806    28.500     0.200
    12.691    31.372     0.200
    14.674    36.268     0.200
     2.326    13.365     0.200
     2.435    12.299     0.200
     2.655    13.627     0.200
     3.082    14.448     0.200
     4.019    16.610     0.200
     4.076    17.248     0.200
     4.208    15.496     0.200
     4.567    15.966     0.200
     4.837    17.321     0.200
     5.686    20.758     0.200
     5.686    20.281     0.200
     5.749    20.024     0.200
     5.825    20.138     0.200
     6.233    21.280     0.200
     6.284    21.074     0.200
     6.260    21.072     0.200
     6.452    16.762     0.200
     6.622    20.646     0.200
     6.703    22.293     0.200
     7.218    21.260     0.200
     7.916    23.405     0.200
     8.915    26.094     0.200
     8.827    25.266     0.200
     9.023    27.197     0.200
     9.926    27.241     0.200
    10.570    28.685     0.200
    10.712    29.276     0.200
    10.898    28.769     0.200
    12.574    31.693     0.200
    12.574    31.474     0.200
    14.686    35.270     0.200
    14.686    36.200     0.200
    14.963    34.976     0.200
    15.836    36.451     0.200
    16.057    36.458     0.200
    17.605    38.806     0.200
    17.629    39.055     0.200
    18.212    38.963     0.200
     2.365    12.074     0.200
     2.332    12.662     0.200
     2.254    12.666     0.200
     2.566    13.134     0.200
     2.791    14.313     0.200
     3.232    15.662     0.200
     3.548    15.469     0.200
     3.548    15.309     0.200
     3.922    15.904     0.200
     3.922    16.514     0.200
     3.990    17.513     0.200
     4.494    16.434     0.200
     4.755    18.214     0.200
     6.039    20.503     0.200
     6.230    20.476     0.200
     7.132    22.621     0.200
     8.911    25.978     0.200
    10.002    27.696     0.200
    10.647    27.400     0.200
    10.776    28.668     0.200
    10.981    28.190     0.200
    12.118    28.728     0.200
    12.655    30.989     0.200
    12.655    31.134     0.200
    13.471    33.248     0.200
    14.348    34.937     0.200
    14.676    36.628     0.200
    14.875    35.148     0.200
    16.040    37.216     0.200
     2.259    13.031     0.200
     2.405    12.729     0.200
     2.356    12.806     0.200
     2.593    13.542     0.200
     2.580    13.487     0.200
     2.792    14.381     0.200
     3.008    14.294     0.200
     3.245    15.234     0.200
     3.587    15.535     0.200
     3.587    15.637     0.200
     3.832    16.477     0.200
     3.942    15.700     0.200
     3.942    16.758     0.200
     4.139    16.881     0.200
     4.146    16.317     0.200
     4.483    16.586     0.200
     4.439    17.197     0.200
     4.500    16.415     0.200
     4.654    17.186     0.200
     4.681    17.768     0.200
     4.766    18.706     0.200
     5.713    19.524     0.200
     5.611    19.921     0.200
     5.611    20.281     0.200
     5.777    19.577     0.200
     5.844    18.641     0.200
     6.077    20.880     0.200
     6.266    19.880     0.200
     6.266    20.501     0.200
     6.181    21.025     0.200
     6.413    19.316     0.200
     7.094    22.356     0.200
     7.889    22.848     0.200
     8.185    25.483     0.200
     8.870    25.400     0.200
     8.870    25.021     0.200
     9.215    25.651     0.200
     9.707    26.267     0.200
     9.962    26.883     0.200
    10.364    24.235     0.200
    10.608    27.870     0.200
    10.738    28.723     0.200
    10.941    27.814     0.200
    10.993    29.177     0.200
    11.079    29.394     0.200
    11.325    30.839     0.200
    11.773    31.405     0.200
    12.078    30.740     0.200
    12.201    30.208     0.200
    12.615    32.088     0.200
    12.615    32.256     0.200
    12.615    31.564     0.200
    12.615    32.557     0.200
    12.615    30.986     0.200
    12.615    31.377     0.200
    12.901    31.942     0.200
    12.978    31.719     0.200
    12.989    30.531     0.200
    13.094    34.249     0.200
    13.254    34.827     0.200
    13.350    34.008     0.200
    13.445    31.753     0.200
    13.746    35.484     0.200
    13.898    34.483     0.200
    13.917    36.386     0.200
    14.061    34.909     0.200
    14.307    35.393     0.200
    14.657    34.670     0.200
    14.657    34.560     0.200
    14.733    35.988     0.200
    14.733    36.449     0.200
    14.733    38.070     0.200
    14.889    38.289     0.200
    15.034    40.624     0.200
    15.371    37.845     0.200
    15.630    37.541     0.200
    15.663    38.271     0.200
    15.733    38.412     0.200
    16.307    39.342     0.200
    16.023    36.338     0.200
    16.239    40.496     0.200
    16.286    39.005     0.200
    17.209    39.982     0.200
    17.296    41.049     0.200
    17.342    39.435     0.200
    17.531    39.730     0.200
    17.531    41.007     0.200
    17.531    38.308     0.200
    17.555    38.736     0.200
    18.141    38.639     0.200
    18.141    39.487     0.200
    18.165    40.496     0.200
    19.095    41.257     0.200
    19.608    41.173     0.200
    20.456    40.375     0.200
     2.213    12.774     0.200
     2.295    12.226     0.200
     2.359    12.574     0.200
     2.525    13.438     0.200
     2.555    13.090     0.200
     2.751    14.691     0.200
     2.954    14.224     0.200
     3.191    15.067     0.200
     3.550    15.078     0.200
     3.785    16.637     0.200
     3.883    16.190     0.200
     3.883    16.432     0.200
     3.949    17.219     0.200
     4.079    15.816     0.200
     4.086    15.922     0.200
     4.389    17.884     0.200
     4.453    17.317     0.200
     4.421    16.611     0.200
     4.593    17.001     0.200
     4.624    17.046     0.200
     4.714    18.273     0.200
     5.177    17.783     0.200
     5.555    19.778     0.200
     5.676    19.269     0.200
     5.731    19.720     0.200
     5.907    16.950     0.200
     5.857    19.656     0.200
     6.042    20.393     0.200
     6.120    20.641     0.200
     6.123    20.953     0.200
     6.240    20.281     0.200
     6.374    18.296     0.200
     6.499    21.845     0.200
     6.600    22.184     0.200
     6.810    22.226     0.200
     6.925    22.991     0.200
     7.129    21.920     0.200
     7.129    22.217     0.200
     7.100    22.553     0.200
     7.100    22.952     0.200
     7.257    22.719     0.200
     7.257    22.918     0.200
     7.223    23.119     0.200
     7.923    22.976     0.200
     7.786    25.388     0.200
     7.945    24.589     0.200
     8.122    24.724     0.200
     8.454    25.346     0.200
     8.589    26.073     0.200
     8.776    25.836     0.200
     8.746    26.782     0.200
     8.915    25.005     0.200
     8.881    26.730     0.200
     9.032    26.901     0.200
     9.264    26.071     0.200
     9.125    25.261     0.200
     9.264    26.700     0.200
     9.477    25.705     0.200
     9.477    29.365     0.200
     9.477    29.638     0.200
     9.739    26.658     0.200
     9.775    28.138     0.200
    10.001    26.388     0.200
     9.905    29.490     0.200
     9.961    29.310     0.200
    10.121    29.112     0.200
    10.648    27.474     0.200
    10.516    28.975     0.200
    10.770    28.541     0.200
    10.770    28.236     0.200
    10.985    27.638     0.200
    10.870    30.733     0.200
    10.870    31.912     0.200
    10.870    29.791     0.200
    10.870    30.252     0.200
    10.870    31.119     0.200
    11.028    29.207     0.200
    11.077    28.952     0.200
    11.077    28.616     0.200
    11.162    31.645     0.200
    11.265    32.040     0.200
    11.484    31.787     0.200
    11.513    32.823     0.200
    11.827    31.179     0.200
    11.718    32.936     0.200
    11.746    32.693     0.200
    11.847    33.052     0.200
    12.122    29.769     0.200
    12.045    32.203     0.200
    12.242    29.567     0.200
    12.224    31.537     0.200
    12.284    30.187     0.200
    12.462    36.135     0.200
    12.657    31.451     0.200
    12.657    31.322     0.200
    12.657    31.592     0.200
    12.657    32.174     0.200
    12.657    31.998     0.200
    12.569    33.500     0.200
    12.661    29.552     0.200
    12.695    32.012     0.200
    12.944    32.118     0.200
    13.019    31.551     0.200
    13.029    30.687     0.200
    13.143    31.981     0.200
    13.051    34.302     0.200
    13.197    35.993     0.200
    13.294    35.264     0.200
    13.475    32.848     0.200
    13.488    32.705     0.200
    13.547    33.162     0.200
    13.688    37.060     0.200
    13.932    34.001     0.200
    13.857    37.193     0.200
    14.108    33.863     0.200
    14.108    35.164     0.200
    14.062    35.993     0.200
    14.356    33.899     0.200
    14.356    34.039     0.200
    14.520    34.248     0.200
    14.645    33.841     0.200
    14.645    35.369     0.200
    14.645    34.072     0.200
    14.674    36.605     0.200
    14.674    35.582     0.200
    14.674    38.863     0.200
    14.834    36.570     0.200
    15.076    35.471     0.200
    14.972    40.205     0.200
    15.142    35.807     0.200
    15.142    35.050     0.200
    15.338    35.163     0.200
    15.315    38.711     0.200
    15.569    39.354     0.200
    15.708    36.420     0.200
    15.686    37.247     0.200
    15.780    35.736     0.200
    15.701    38.528     0.200
    15.777    38.039     0.200
    15.752    41.317     0.200
    16.007    36.028     0.200
    16.007    38.090     0.200
    16.354    37.028     0.200
    16.163    37.041     0.200
    16.163    36.256     0.200
    16.327    37.324     0.200
    16.685    39.494     0.200
    17.229    38.634     0.200
    17.243    39.033     0.200
    17.243    40.982     0.200
    17.243    38.685     0.200
    17.280    40.660     0.200
    17.404    39.894     0.200
    17.413    39.255     0.200
    17.472    39.479     0.200
    17.478    39.819     0.200
    17.478    40.245     0.200
    17.478    39.550     0.200
    17.478    41.237     0.200
    17.478    38.839     0.200
    17.478    40.944     0.200
    17.478    38.690     0.200
    17.499    41.891     0.200
    17.984    40.570     0.200
    17.984    40.235     0.200
    18.137    40.284     0.200
    18.137    40.577     0.200
    18.091    40.124     0.200
    18.091    40.538     0.200
    18.091    39.499     0.200
    18.185    41.559     0.200
    18.843    42.332     0.200
    19.228    43.198     0.200
    19.400    41.879     0.200
    19.400    41.730     0.200
    19.576    42.684     0.200
    19.671    40.846     0.200
     2.286    12.873     0.200
     2.392    12.636     0.200
     2.371    13.074     0.200
     2.574    13.004     0.200
     2.602    13.483     0.200
     2.820    14.115     0.200
     3.031    14.478     0.200
     3.267    16.321     0.200
     3.568    14.985     0.200
     3.960    15.631     0.200
     4.025    17.071     0.200
     4.137    16.034     0.200
     4.144    15.684     0.200
     4.464    17.956     0.200
     4.484    16.819     0.200
     4.789    18.334     0.200
     5.214    18.199     0.200
     5.695    19.693     0.200
     5.632    20.020     0.200
     5.632    18.992     0.200
     5.763    19.790     0.200
     6.166    20.991     0.200
     6.242    20.505     0.200
     6.242    20.267     0.200
     6.197    20.473     0.200
     6.396    18.159     0.200
     6.638    21.879     0.200
     7.217    22.579     0.200
     7.846    23.609     0.200
    10.760    27.340     0.200
    14.688    36.179     0.200
    14.688    36.871     0.200
    16.054    36.678     0.200
    19.407    43.455     0.200
     2.339    12.227     0.200
     2.316    13.402     0.200
     2.618    13.572     0.200
     2.856    13.786     0.200
     3.050    15.136     0.200
     3.286    15.279     0.200
     3.510    15.164     0.200
     3.510    14.922     0.200
     3.968    16.268     0.200
     4.103    15.652     0.200
     4.110    15.968     0.200
     4.555    18.501     0.200
     4.637    17.111     0.200
     4.812    17.028     0.200
     5.636    19.852     0.200
     5.647    19.427     0.200
     5.710    19.590     0.200
     6.119    20.814     0.200
     6.180    20.229     0.200
     6.199    20.377     0.200
     6.339    18.377     0.200
    12.688    31.033     0.200
    16.108    38.796     0.200
     2.265    12.941     0.200
     2.345    12.012     0.200
     2.531    12.835     0.200
     2.571    12.968     0.200
     3.238    15.586     0.200
     3.924    16.577     0.200
     3.996    17.237     0.200
     4.439    17.374     0.200
     4.504    16.837     0.200
     5.166    18.085     0.200
     5.166    18.585     0.200
     5.600    20.218     0.200
     5.652    20.016     0.200
     6.016    20.870     0.200
    10.799    29.063     0.200
    12.676    30.089     0.200
    14.698    36.464     0.200
     2.280    12.807     0.200
     2.363    12.438     0.200
     2.569    12.740     0.200
     2.595    13.534     0.200
     2.815    14.228     0.200
     3.024    14.425     0.200
     3.260    15.365     0.200
     3.563    15.240     0.200
     3.563    15.130     0.200
     3.852    16.262     0.200
     3.953    16.189     0.200
     4.019    17.018     0.200
     4.457    17.396     0.200
     4.520    17.145     0.200
     4.783    19.098     0.200
     5.625    19.931     0.200
     5.689    19.826     0.200
     6.052    20.091     0.200
     6.159    21.044     0.200
     6.189    20.575     0.200
     6.238    20.722     0.200
     6.390    18.237     0.200
     6.631    22.233     0.200
    12.638    31.980     0.200
    16.052    38.414     0.200
    17.312    38.757     0.200
     2.247    12.906     0.200
     2.318    12.075     0.200
     2.350    12.704     0.200
     2.540    13.187     0.200
     2.555    13.113     0.200
     2.785    14.303     0.200
     2.985    14.293     0.200
     3.221    14.631     0.200
     3.534    14.881     0.200
     3.534    15.210     0.200
     3.817    16.673     0.200
     3.910    16.052     0.200
     3.979    16.685     0.200
     4.084    16.701     0.200
     4.091    15.881     0.200
     4.421    17.629     0.200
     4.430    16.329     0.200
     4.486    17.953     0.200
     4.600    17.538     0.200
     4.625    16.947     0.200
     4.745    17.619     0.200
     5.170    18.091     0.200
     5.584    19.727     0.200
     5.660    19.570     0.200
     5.722    19.751     0.200
     5.894    16.006     0.200
     5.894    16.237     0.200
     6.025    20.409     0.200
     6.119    20.517     0.200
     6.145    20.218     0.200
     6.218    20.258     0.200
     6.218    20.520     0.200
     6.359    18.218     0.200
     6.501    21.139     0.200
     6.593    22.379     0.200
     7.146    20.946     0.200
     7.146    23.333     0.200
     7.146    22.626     0.200
     7.940    21.411     0.200
     8.926    25.641     0.200
     8.926    25.430     0.200
     9.271    24.331     0.200
     9.463    24.294     0.200
    10.016    25.178     0.200
    10.662    26.834     0.200
    10.789    27.163     0.200
    10.789    27.987     0.200
    12.133    29.720     0.200
    12.669    31.693     0.200
    12.669    32.275     0.200
    12.669    31.286     0.200
    14.117    34.682     0.200
    14.117    34.870     0.200
    14.363    33.163     0.200
    14.679    35.150     0.200
    14.679    35.122     0.200
    14.700    40.173     0.200
    14.864    38.013     0.200
    15.665    35.954     0.200
    16.041    36.399     0.200
    16.172    37.563     0.200
    16.172    38.512     0.200
    18.084    39.491     0.200
    18.084    39.081     0.200
    18.084    39.702     0.200
    18.172    39.950     0.200
     2.431    12.374     0.200
     3.325    15.939     0.200
     3.589    15.465     0.200
     3.913    17.280     0.200
     4.020    16.232     0.200
     4.083    17.495     0.200
     4.193    16.314     0.200
     4.520    18.197     0.200
     4.580    19.095     0.200
     4.722    17.047     0.200
     5.247    18.610     0.200
     5.715    20.054     0.200
     5.691    20.031     0.200
     6.204    20.745     0.200
     6.249    20.724     0.200
    12.607    29.414     0.200
     2.297    12.824     0.200
     2.611    13.362     0.200
     3.040    14.953     0.200
     3.277    15.491     0.200
     3.968    16.428     0.200
     4.035    17.045     0.200
     5.206    17.974     0.200
     5.641    20.003     0.200
     5.684    19.502     0.200
     5.755    20.075     0.200
     6.160    20.950     0.200
     6.229    20.940     0.200
     6.631    22.151     0.200
    12.641    31.652     0.200
     2.254    12.703     0.200
     2.358    12.390     0.200
     2.546    13.588     0.200
     2.563    13.491     0.200
     2.791    13.821     0.200
     2.993    14.775     0.200
     3.230    15.716     0.200
     3.541    15.182     0.200
     3.541    14.893     0.200
     3.825    16.868     0.200
     3.919    16.769     0.200
     3.919    16.179     0.200
     3.988    17.465     0.200
     4.094    16.196     0.200
     4.101    15.845     0.200
     4.440    16.892     0.200
     4.493    16.485     0.200
     4.635    16.614     0.200
     4.753    18.094     0.200
     5.179    17.773     0.200
     5.593    19.233     0.200
     5.667    19.972     0.200
     5.730    19.840     0.200
     6.031    20.519     0.200
     6.128    20.989     0.200
     6.154    20.431     0.200
     6.223    20.284     0.200
     6.602    22.059     0.200
    12.662    31.920     0.200
     2.223    12.722     0.200
     2.302    12.091     0.200
     2.497    12.819     0.200
     2.520    13.353     0.200
     3.188    15.454     0.200
     3.492    14.709     0.200
     3.791    16.916     0.200
     3.870    16.200     0.200
     3.947    16.506     0.200
     4.039    15.627     0.200
     4.392    17.504     0.200
     4.460    18.036     0.200
     4.548    16.885     0.200
     4.574    16.787     0.200
     5.122    17.493     0.200
     5.618    19.799     0.200
     5.675    20.136     0.200
     5.985    20.723     0.200
     6.069    20.338     0.200
     6.184    20.795     0.200
    12.714    30.129     0.200
    16.044    34.852     0.200
     2.261    13.017     0.200
     2.312    11.925     0.200
     2.313    12.316     0.200
     2.500    12.729     0.200
     2.560    13.238     0.200
     2.804    14.439     0.200
     2.991    14.394     0.200
     3.228    14.839     0.200
     3.495    14.624     0.200
     3.495    15.100     0.200
     3.830    16.308     0.200
     3.909    16.088     0.200
     3.986    16.489     0.200
     4.057    15.690     0.200
     4.064    15.479     0.200
     4.432    17.392     0.200
     4.406    16.991     0.200
     4.499    17.504     0.200
     4.575    17.317     0.200
     4.595    17.075     0.200
     4.754    18.028     0.200
     5.134    18.390     0.200
     5.588    19.397     0.200
     5.588    19.264     0.200
     5.621    19.414     0.200
     5.685    19.865     0.200
     5.915    19.529     0.200
     5.985    20.457     0.200
     6.085    20.894     0.200
     6.140    20.334     0.200
     6.178    20.516     0.200
     6.178    20.180     0.200
     6.320    18.006     0.200
     6.471    21.380     0.200
     6.558    21.672     0.200
     6.825    22.459     0.200
     6.889    21.712     0.200
     7.186    22.019     0.200
     7.186    22.589     0.200
     7.068    22.524     0.200
     7.546    23.350     0.200
     7.980    21.596     0.200
     8.964    25.153     0.200
     8.964    24.614     0.200
     9.307    25.432     0.200
     9.481    27.665     0.200
    10.055    26.573     0.200
    10.701    26.938     0.200
    10.829    27.061     0.200
    10.829    27.506     0.200
    11.034    27.025     0.200
    11.145    28.774     0.200
    11.288    31.679     0.200
    12.171    29.255     0.200
    12.708    31.685     0.200
    12.708    30.825     0.200
    12.708    31.005     0.200
    12.708    31.349     0.200
    13.186    34.069     0.200
    13.227    35.245     0.200
    13.524    33.787     0.200
    14.154    34.232     0.200
    14.154    33.412     0.200
    14.211    39.025     0.200
    14.713    33.758     0.200
    14.713    35.672     0.200
    14.869    36.490     0.200
    14.985    40.308     0.200
    15.182    34.739     0.200
    15.347    36.121     0.200
    15.585    38.594     0.200
    15.706    36.392     0.200
    15.728    38.534     0.200
    16.073    36.437     0.200
    16.073    37.195     0.200
    16.209    35.750     0.200
    17.278    39.493     0.200
    17.291    41.331     0.200
    17.830    40.778     0.200
    18.048    39.688     0.200
    18.048    39.352     0.200
    19.246    42.693     0.200
     2.294    12.653     0.200
     3.021    14.872     0.200
     3.257    15.613     0.200
     3.478    14.837     0.200
     3.934    15.611     0.200
     4.016    16.763     0.200
     4.413    16.821     0.200
     4.463    18.046     0.200
     4.531    18.020     0.200
     4.596    17.190     0.200
     5.604    19.025     0.200
     5.673    19.511     0.200
     6.080    20.872     0.200
     6.154    20.101     0.200
     6.550    22.086     0.200
    10.849    28.762     0.200
    12.722    32.275     0.200
    12.722    32.900     0.200
    14.746    36.278     0.200
    19.644    42.740     0.200
    19.644    41.803     0.200
     2.335    13.004     0.200
     2.404    11.990     0.200
     2.645    12.686     0.200
     2.870    14.262     0.200
     3.075    14.166     0.200
     3.311    14.907     0.200
     3.543    14.900     0.200
     3.906    16.766     0.200
     3.998    16.586     0.200
     3.998    15.977     0.200
     4.069    17.358     0.200
     4.143    15.516     0.200
     4.150    16.022     0.200
     4.495    16.294     0.200
     4.510    17.312     0.200
     4.574    17.845     0.200
     4.662    16.843     0.200
     4.677    17.170     0.200
     4.835    18.054     0.200
     5.201    18.056     0.200
     5.669    19.489     0.200
     5.674    19.931     0.200
     5.674    19.601     0.200
     5.746    19.888     0.200
     5.824    16.668     0.200
     6.158    21.087     0.200
     6.207    20.517     0.200
     6.232    20.465     0.200
     6.372    18.605     0.200
     6.553    21.626     0.200
     6.626    22.221     0.200
     6.918    22.414     0.200
     7.143    21.745     0.200
     7.166    22.825     0.200
     7.166    22.705     0.200
     7.639    24.299     0.200
     7.939    22.016     0.200
     8.906    24.591     0.200
     8.906    24.731     0.200
     9.242    26.362     0.200
    10.005    27.269     0.200
    10.649    27.162     0.200
    10.791    27.319     0.200
    10.791    27.839     0.200
    10.977    27.013     0.200
    12.113    28.599     0.200
    12.653    31.514     0.200
    12.653    32.002     0.200
    12.653    31.234     0.200
    12.653    30.439     0.200
    12.653    31.033     0.200
    13.465    31.739     0.200
    13.465    32.398     0.200
    14.091    34.373     0.200
    14.091    33.983     0.200
    14.739    34.542     0.200
    14.739    33.534     0.200
    14.789    37.683     0.200
    14.789    37.557     0.200
    14.789    37.183     0.200
    14.954    38.318     0.200
    15.113    35.420     0.200
    15.682    34.773     0.200
    16.106    38.470     0.200
    16.106    36.742     0.200
    16.148    36.737     0.200
    17.363    40.576     0.200
    18.115    39.517     0.200
    18.115    39.748     0.200
    19.338    43.385     0.200
     2.355    13.027     0.200
     2.663    13.728     0.200
     3.094    14.704     0.200
     3.330    15.645     0.200
     3.536    14.949     0.200
     3.926    16.990     0.200
     4.016    16.647     0.200
     4.089    17.095     0.200
     4.155    16.323     0.200
     4.530    17.841     0.200
     4.594    18.318     0.200
     4.680    16.597     0.200
     5.198    18.347     0.200
     5.662    19.739     0.200
     5.742    20.397     0.200
     6.021    20.651     0.200
     6.157    20.953     0.200
     6.195    20.918     0.200
     6.624    22.005     0.200
    12.660    32.417     0.200
    16.126    38.544     0.200
     2.278    12.763     0.200
     2.367    12.025     0.200
     2.812    14.059     0.200
     3.025    14.754     0.200
     3.575    15.034     0.200
     3.575    15.566     0.200
     3.851    17.413     0.200
     3.955    16.391     0.200
     3.955    16.211     0.200
     4.019    17.147     0.200
     4.145    16.474     0.200
     4.457    17.641     0.200
     4.484    17.319     0.200
     4.518    17.150     0.200
     4.783    17.914     0.200
     5.218    17.652     0.200
     5.626    19.790     0.200
     5.626    20.462     0.200
     6.249    21.019     0.200
     6.554    20.941     0.200
    10.753    27.838     0.200
    14.679    33.692     0.200
    16.044    35.913     0.200
     2.261    12.799     0.200
     2.795    14.273     0.200
     3.242    15.847     0.200
     3.568    14.947     0.200
     3.833    16.753     0.200
     3.936    16.251     0.200
     3.936    15.681     0.200
     4.000    16.199     0.200
     4.122    15.755     0.200
     4.129    16.193     0.200
     4.439    17.583     0.200
     4.467    16.851     0.200
     4.501    16.609     0.200
     4.664    17.354     0.200
     4.764    18.443     0.200
     5.207    18.415     0.200
     5.607    20.548     0.200
     5.607    19.798     0.200
     5.758    19.986     0.200
     6.157    20.731     0.200
     6.174    20.758     0.200
     6.247    20.381     0.200
     6.247    20.104     0.200
     6.394    17.735     0.200
     6.539    22.019     0.200
     6.631    22.200     0.200
     7.113    22.762     0.200
    10.758    28.490     0.200
    12.634    31.087     0.200
    12.634    32.696     0.200
    14.670    34.069     0.200
    16.034    35.261     0.200
    16.034    36.328     0.200
     2.313    12.684     0.200
     3.047    14.924     0.200
     3.283    15.064     0.200
     3.509    15.127     0.200
     3.883    17.163     0.200
     3.965    16.807     0.200
     4.042    17.117     0.200
     4.453    16.717     0.200
     4.486    17.832     0.200
     4.552    18.913     0.200
     4.635    17.090     0.200
     5.709    19.961     0.200
     6.180    20.563     0.200
    10.821    27.650     0.200
    12.689    30.798     0.200
    12.689    30.571     0.200
    14.743    33.776     0.200
    16.106    36.418     0.200
     2.656    13.774     0.200
     3.088    15.041     0.200
     3.324    15.282     0.200
     4.006    16.525     0.200
     4.082    16.631     0.200
     4.135    16.018     0.200
     4.483    17.354     0.200
     4.526    17.652     0.200
     4.592    19.563     0.200
     5.177    17.759     0.200
     5.641    19.748     0.200
     6.136    21.064     0.200
     6.175    20.407     0.200
    10.821    26.764     0.200
    12.681    31.631     0.200
    12.681    30.737     0.200
    14.770    37.537     0.200
    16.135    36.248     0.200
    16.135    37.666     0.200
     2.230    12.724     0.200
     2.263    12.340     0.200
     2.519    13.256     0.200
     2.777    13.991     0.200
     2.952    14.201     0.200
     3.188    14.845     0.200
     3.456    14.513     0.200
     3.456    14.646     0.200
     3.797    16.742     0.200
     3.863    16.267     0.200
     3.863    16.380     0.200
     3.946    16.593     0.200
     4.004    16.115     0.200
     4.011    15.544     0.200
     4.352    16.766     0.200
     4.396    17.351     0.200
     4.466    17.904     0.200
     4.466    19.630     0.200
     4.521    16.992     0.200
     4.543    17.032     0.200
     4.716    17.239     0.200
     5.087    18.081     0.200
     5.546    19.731     0.200
     5.546    19.532     0.200
     5.582    19.204     0.200
     5.640    19.434     0.200
     5.949    20.129     0.200
     5.969    18.582     0.200
     6.036    20.211     0.200
     6.091    20.648     0.200
     6.149    20.393     0.200
     6.149    20.514     0.200
     6.280    17.999     0.200
     6.419    21.003     0.200
     6.510    21.273     0.200
     7.017    22.995     0.200
     7.222    21.418     0.200
     9.007    24.867     0.200
     9.354    25.483     0.200
    10.095    26.154     0.200
    10.741    27.851     0.200
    10.864    27.570     0.200
    10.864    27.800     0.200
    11.078    27.103     0.200
    11.913    32.422     0.200
    12.214    29.286     0.200
    12.750    32.578     0.200
    12.750    30.590     0.200
    12.750    29.715     0.200
    12.750    31.762     0.200
    12.750    31.160     0.200
    13.567    33.816     0.200
    14.199    33.546     0.200
    14.446    35.483     0.200
    14.711    36.769     0.200
    14.711    36.331     0.200
    14.827    37.565     0.200
    15.230    35.212     0.200
    16.068    36.937     0.200
    16.068    35.511     0.200
    16.254    36.012     0.200
    18.001    39.173     0.200
    18.001    38.693     0.200
    19.199    40.995     0.200
    19.715    43.578     0.200
    20.740    41.450     0.200
    20.774    40.962     0.200
     2.255    12.945     0.200
     2.341    12.137     0.200
     2.383    12.550     0.200
     2.571    13.361     0.200
     2.571    13.254     0.200
     2.790    14.224     0.200
     3.000    13.957     0.200
     3.236    15.698     0.200
     3.566    15.249     0.200
     3.566    15.119     0.200
     3.827    16.399     0.200
     3.930    16.103     0.200
     3.994    17.150     0.200
     4.117    16.383     0.200
     4.124    16.131     0.200
     4.433    17.533     0.200
     4.495    17.718     0.200
     4.462    16.992     0.200
     4.633    17.395     0.200
     4.659    16.989     0.200
     4.758    18.493     0.200
     5.204    18.233     0.200
     5.601    20.199     0.200
     5.601    19.639     0.200
     5.692    19.737     0.200
     5.755    20.200     0.200
     6.056    20.787     0.200
     6.167    20.499     0.200
     6.153    20.556     0.200
     6.246    20.268     0.200
     6.246    19.948     0.200
     6.535    21.094     0.200
     6.627    22.521     0.200
     7.115    22.291     0.200
     7.133    22.514     0.200
     7.586    23.334     0.200
     8.188    25.412     0.200
    10.759    28.117     0.200
    12.637    31.461     0.200
    12.637    31.714     0.200
    12.637    32.242     0.200
    14.667    33.864     0.200
    14.720    37.518     0.200
    16.031    35.331     0.200
    16.031    36.107     0.200
    17.288    38.264     0.200
    17.517    38.836     0.200
     2.301    13.046     0.200
     2.401    12.383     0.200
     2.426    12.583     0.200
     2.625    13.669     0.200
     2.606    13.184     0.200
     2.831    14.529     0.200
     3.052    13.981     0.200
     3.289    15.421     0.200
     3.600    15.285     0.200
     3.600    15.475     0.200
     3.874    16.887     0.200
     3.987    16.374     0.200
     4.047    16.675     0.200
     4.174    16.159     0.200
     4.181    16.109     0.200
     4.482    17.695     0.200
     4.541    17.675     0.200
     4.520    16.547     0.200
     4.690    16.661     0.200
     4.809    17.748     0.200
     4.713    17.295     0.200
     5.249    18.239     0.200
     5.655    19.402     0.200
     5.655    20.213     0.200
     5.804    17.219     0.200
     5.804    18.668     0.200
     5.726    19.874     0.200
     5.798    19.740     0.200
     5.960    20.843     0.200
     6.088    20.655     0.200
     6.226    20.631     0.200
     6.202    21.019     0.200
     6.269    20.446     0.200
     6.428    17.982     0.200
     6.589    21.445     0.200
     6.689    21.044     0.200
     6.674    22.317     0.200
     7.084    21.666     0.200
     7.084    22.127     0.200
     7.007    23.029     0.200
     7.186    22.468     0.200
     7.225    23.477     0.200
     7.646    24.165     0.200
     7.880    21.932     0.200
     7.882    24.353     0.200
     8.228    24.879     0.200
     8.245    24.976     0.200
     8.546    25.973     0.200
     8.695    26.124     0.200
     8.852    24.094     0.200
     8.852    24.795     0.200
     8.762    25.942     0.200
     8.880    26.271     0.200
     8.988    26.462     0.200
     9.193    24.923     0.200
     9.188    27.608     0.200
     9.114    27.685     0.200
     9.373    25.920     0.200
     9.373    25.029     0.200
     9.700    25.794     0.200
     9.781    26.190     0.200
     9.948    26.442     0.200
     9.880    28.232     0.200
     9.972    28.533     0.200
    10.243    25.465     0.200
    10.228    29.393     0.200
    10.593    27.230     0.200
    10.731    27.795     0.200
    10.731    27.973     0.200
    10.923    27.622     0.200
    10.983    28.234     0.200
    10.897    30.268     0.200
    11.096    28.502     0.200
    11.247    28.940     0.200
    11.746    31.424     0.200
    12.060    29.763     0.200
    12.175    33.651     0.200
    12.598    31.696     0.200
    12.598    31.420     0.200
    12.598    30.924     0.200
    12.598    31.276     0.200
    12.598    31.975     0.200
    12.598    31.545     0.200
    12.589    33.983     0.200
    12.935    34.720     0.200
    13.070    32.610     0.200
    13.150    34.139     0.200
    13.213    36.883     0.200
    13.412    32.680     0.200
    13.394    34.486     0.200
    13.791    37.162     0.200
    13.888    33.915     0.200
    14.040    33.950     0.200
    14.040    33.550     0.200
    14.285    34.024     0.200
    14.245    36.374     0.200
    14.680    33.158     0.200
    14.680    32.866     0.200
    14.680    32.889     0.200
    14.690    38.670     0.200
    14.778    38.389     0.200
    14.778    35.585     0.200
    14.933    36.343     0.200
    15.007    35.563     0.200
    15.078    40.046     0.200
    15.272    36.270     0.200
    15.415    37.366     0.200
    15.619    33.553     0.200
    15.619    33.725     0.200
    15.644    36.923     0.200
    15.713    36.945     0.200
    15.675    38.060     0.200
    15.845    37.430     0.200
    15.804    39.362     0.200
    16.286    37.792     0.200
    16.049    35.761     0.200
    16.049    34.556     0.200
    16.097    36.062     0.200
    16.097    35.054     0.200
    16.270    37.613     0.200
    16.782    39.848     0.200
    17.210    39.144     0.200
    17.340    38.936     0.200
    17.340    39.736     0.200
    17.502    40.846     0.200
    17.570    40.335     0.200
    17.575    39.585     0.200
    17.575    39.195     0.200
    18.088    39.566     0.200
    18.198    38.662     0.200
    18.164    40.040     0.200
    18.164    38.880     0.200
    19.142    42.908     0.200
    19.334    43.115     0.200
    20.102    41.411     0.200
    20.920    41.180     0.200
     2.289    13.210     0.200
     2.372    12.339     0.200
     2.387    12.256     0.200
     2.570    12.829     0.200
     2.604    13.631     0.200
     2.823    14.564     0.200
     3.033    14.323     0.200
     3.269    15.165     0.200
     3.564    15.030     0.200
     3.564    14.878     0.200
     3.861    16.864     0.200
     3.961    15.985     0.200
     3.961    16.357     0.200
     4.027    16.919     0.200
     4.135    16.095     0.200
     4.142    15.785     0.200
     4.466    17.696     0.200
     4.482    16.614     0.200
     4.528    17.770     0.200
     4.652    16.931     0.200
     4.673    17.175     0.200
     4.792    18.569     0.200
     5.210    18.317     0.200
     5.634    20.071     0.200
     5.690    19.718     0.200
     5.759    19.610     0.200
     5.841    20.284     0.200
     5.935    20.451     0.200
     6.052    20.586     0.200
     6.198    20.338     0.200
     6.549    21.399     0.200
     6.634    21.895     0.200
     6.887    22.647     0.200
     7.119    21.246     0.200
     7.119    22.196     0.200
     7.146    22.320     0.200
     7.146    22.473     0.200
     7.843    24.396     0.200
     8.194    24.587     0.200
     8.207    25.245     0.200
     8.506    25.553     0.200
     8.724    25.401     0.200
     8.844    26.329     0.200
     8.890    24.515     0.200
     8.955    26.754     0.200
     9.232    25.044     0.200
     9.408    28.320     0.200
     9.408    27.141     0.200
     9.844    27.949     0.200
     9.985    26.040     0.200
    10.630    26.842     0.200
    10.765    27.898     0.200
    10.765    27.691     0.200
    10.765    27.351     0.200
    10.962    27.043     0.200
    11.786    30.777     0.200
    12.098    29.147     0.200
    12.636    31.675     0.200
    12.636    32.022     0.200
    12.636    30.823     0.200
    12.636    31.237     0.200
    12.636    31.456     0.200
    13.110    33.308     0.200
    13.450    31.151     0.200
    14.079    33.116     0.200
    14.079    33.514     0.200
    14.266    36.510     0.200
    14.324    32.185     0.200
    14.693    34.050     0.200
    14.693    34.257     0.200
    14.693    34.511     0.200
    14.752    37.780     0.200
    14.752    38.679     0.200
    14.913    37.076     0.200
    15.048    40.011     0.200
    15.393    37.504     0.200
    15.649    33.531     0.200
    15.646    38.392     0.200
    15.779    37.345     0.200
    16.058    34.989     0.200
    16.135    35.679     0.200
    16.135    35.073     0.200
    16.477    38.696     0.200
    17.321    38.732     0.200
    17.321    39.580     0.200
    17.321    38.181     0.200
    17.355    40.602     0.200
    17.483    39.491     0.200
    17.556    39.828     0.200
    17.556    38.609     0.200
    17.556    39.437     0.200
    18.051    38.927     0.200
    18.124    38.736     0.200
    18.124    39.205     0.200
    18.124    38.837     0.200
    19.083    41.921     0.200
    19.737    41.682     0.200
    20.889    41.462     0.200
    20.986    42.104     0.200
     2.291    13.621     0.200
     2.398    12.866     0.200
     2.439    13.089     0.200
     2.618    14.100     0.200
     2.621    13.666     0.200
     2.819    14.908     0.200
     3.045    14.920     0.200
     3.281    14.661     0.200
     3.615    15.567     0.200
     3.615    15.817     0.200
     3.864    16.553     0.200
     3.982    16.283     0.200
     3.982    16.603     0.200
     4.039    17.317     0.200
     4.181    16.352     0.200
     4.188    16.278     0.200
     4.473    17.855     0.200
     4.531    17.723     0.200
     4.526    17.336     0.200
     4.697    18.043     0.200
     4.722    17.648     0.200
     4.800    18.769     0.200
     5.261    18.551     0.200
     5.648    20.133     0.200
     5.648    20.344     0.200
     5.741    20.454     0.200
     5.800    20.591     0.200
     5.810    20.341     0.200
     5.955    20.952     0.200
     6.103    21.031     0.200
     6.213    21.145     0.200
     6.223    20.951     0.200
     6.285    20.805     0.200
     6.285    21.028     0.200
     6.442    18.389     0.200
     6.597    22.050     0.200
     6.689    22.589     0.200
     6.685    22.232     0.200
     6.915    22.858     0.200
     6.971    22.696     0.200
     7.017    22.561     0.200
     7.069    21.858     0.200
     7.069    22.725     0.200
     7.195    23.384     0.200
     7.195    23.103     0.200
     7.242    23.432     0.200
     7.242    22.905     0.200
     7.647    24.515     0.200
     7.864    23.933     0.200
     7.888    24.390     0.200
     8.228    25.226     0.200
     8.251    26.157     0.200
     8.767    26.335     0.200
     8.801    26.440     0.200
     8.839    25.261     0.200
     8.882    26.753     0.200
     8.988    26.954     0.200
     9.132    25.955     0.200
     9.180    25.975     0.200
     9.188    28.413     0.200
     9.370    27.398     0.200
     9.370    28.413     0.200
     9.370    28.038     0.200
     9.590    27.319     0.200
     9.684    26.726     0.200
     9.766    27.991     0.200
     9.882    28.605     0.200
     9.934    26.700     0.200
     9.966    29.375     0.200
     9.985    28.816     0.200
    10.008    28.797     0.200
    10.008    29.340     0.200
    10.087    31.148     0.200
    10.228    30.200     0.200
    10.342    24.391     0.200
    10.579    27.655     0.200
    10.553    30.157     0.200
    10.553    30.961     0.200
    10.563    30.663     0.200
    10.715    28.331     0.200
    10.715    28.026     0.200
    10.910    27.238     0.200
    10.914    31.248     0.200
    10.914    30.357     0.200
    10.914    32.041     0.200
    10.914    31.576     0.200
    10.968    28.842     0.200
    11.049    30.401     0.200
    11.049    32.144     0.200
    11.079    27.934     0.200
    11.101    31.109     0.200
    11.101    31.429     0.200
    11.206    31.464     0.200
    11.206    32.226     0.200
    11.344    32.646     0.200
    11.522    32.627     0.200
    11.562    32.535     0.200
    11.606    33.174     0.200
    11.736    31.597     0.200
    11.769    32.636     0.200
    11.776    33.859     0.200
    11.890    32.232     0.200
    12.046    29.612     0.200
    12.068    33.798     0.200
    12.171    31.151     0.200
    12.174    33.715     0.200
    12.260    33.796     0.200
    12.260    34.799     0.200
    12.299    34.865     0.200
    12.512    36.061     0.200
    12.585    31.740     0.200
    12.585    32.056     0.200
    12.585    31.338     0.200
    12.585    31.595     0.200
    12.585    32.185     0.200
    12.585    31.920     0.200
    12.599    33.725     0.200
    12.599    34.409     0.200
    12.716    32.478     0.200
    12.871    32.119     0.200
    12.948    31.916     0.200
    12.960    31.528     0.200
    13.142    35.344     0.200
    13.213    34.912     0.200
    13.330    36.776     0.200
    13.399    32.584     0.200
    13.388    35.516     0.200
    13.415    33.521     0.200
    13.469    33.521     0.200
    13.559    38.031     0.200
    13.785    37.181     0.200
    13.873    34.796     0.200
    13.851    35.602     0.200
    13.958    37.856     0.200
    14.028    33.650     0.200
    14.008    34.179     0.200
    14.082    36.517     0.200
    14.082    38.466     0.200
    14.213    36.922     0.200
    14.273    32.417     0.200
    14.273    34.585     0.200
    14.275    36.259     0.200
    14.288    37.796     0.200
    14.316    35.760     0.200
    14.444    34.084     0.200
    14.664    34.623     0.200
    14.664    34.775     0.200
    14.664    35.904     0.200
    14.773    37.043     0.200
    14.773    40.750     0.200
    14.773    41.070     0.200
    14.926    37.409     0.200
    14.995    35.861     0.200
    15.055    34.986     0.200
    15.077    40.326     0.200
    15.259    35.633     0.200
    15.342    39.562     0.200
    15.408    37.626     0.200
    15.602    34.663     0.200
    15.631    36.279     0.200
    15.673    38.999     0.200
    15.700    36.155     0.200
    15.798    39.886     0.200
    16.273    37.590     0.200
    16.032    36.401     0.200
    16.032    36.093     0.200
    16.084    34.952     0.200
    16.256    37.980     0.200
    17.194    38.703     0.200
    17.333    39.602     0.200
    17.333    38.578     0.200
    17.385    40.694     0.200
    17.451    39.870     0.200
    17.495    40.187     0.200
    17.567    38.608     0.200
    17.567    39.937     0.200
    17.567    39.538     0.200
    17.622    41.250     0.200
    18.090    39.244     0.200
    18.176    39.790     0.200
    18.176    40.243     0.200
    18.176    40.583     0.200
    18.176    40.462     0.200
    18.283    40.334     0.200
    18.456    42.144     0.200
    18.915    42.020     0.200
    19.134    42.451     0.200
    19.412    43.810     0.200
    19.434    43.619     0.200
    20.229    41.657     0.200
    20.499    42.731     0.200
    20.919    41.449     0.200
     2.334    12.638     0.200
     2.387    12.316     0.200
     2.409    11.659     0.200
     2.561    12.787     0.200
     2.647    13.087     0.200
     2.869    14.090     0.200
     3.077    13.873     0.200
     3.313    14.614     0.200
     3.555    14.495     0.200
     3.555    14.745     0.200
     3.906    16.194     0.200
     4.002    15.671     0.200
     4.002    16.061     0.200
     4.071    16.566     0.200
     4.153    15.751     0.200
     4.159    15.536     0.200
     4.511    17.333     0.200
     4.504    16.315     0.200
     4.574    17.575     0.200
     4.671    16.961     0.200
     4.687    16.778     0.200
     4.836    17.879     0.200
     5.072    17.145     0.200
     5.212    18.053     0.200
     5.677    19.631     0.200
     5.677    19.231     0.200
     5.681    19.184     0.200
     5.758    19.584     0.200
     5.815    20.315     0.200
     5.815    20.495     0.200
     5.815    20.785     0.200
     5.815    19.615     0.200
     5.892    20.471     0.200
     5.892    21.966     0.200
     5.892    20.775     0.200
     5.976    19.735     0.200
     6.041    20.184     0.200
     6.169    20.287     0.200
     6.218    20.218     0.200
     6.218    19.988     0.200
     6.236    20.057     0.200
     6.384    17.000     0.200
     6.563    20.673     0.200
     6.637    21.518     0.200
     6.687    21.734     0.200
     6.924    21.878     0.200
     6.977    22.654     0.200
     6.975    22.478     0.200
     7.132    21.715     0.200
     7.173    22.367     0.200
     7.173    22.797     0.200
     7.157    22.553     0.200
     7.157    21.773     0.200
     7.253    23.231     0.200
     7.459    22.830     0.200
     7.646    23.649     0.200
     7.653    23.862     0.200
     7.862    23.363     0.200
     7.928    22.895     0.200
     8.055    24.578     0.200
     8.227    24.571     0.200
     8.227    24.770     0.200
     8.518    25.067     0.200
     8.521    25.139     0.200
     8.590    25.736     0.200
     8.699    26.354     0.200
     8.737    25.716     0.200
     8.737    26.777     0.200
     8.747    25.197     0.200
     8.763    26.007     0.200
     8.762    26.025     0.200
     8.872    25.634     0.200
     8.835    25.869     0.200
     8.894    24.932     0.200
     8.988    26.143     0.200
     9.044    26.738     0.200
     9.060    25.452     0.200
     9.231    25.221     0.200
     9.189    26.501     0.200
     9.380    27.409     0.200
     9.380    28.149     0.200
     9.380    28.348     0.200
     9.378    27.239     0.200
     9.430    27.930     0.200
     9.522    27.669     0.200
     9.640    28.075     0.200
     9.749    27.590     0.200
     9.759    28.191     0.200
     9.830    25.921     0.200
     9.830    28.416     0.200
     9.872    27.805     0.200
     9.900    28.336     0.200
     9.900    29.851     0.200
     9.994    25.760     0.200
     9.932    28.697     0.200
     9.941    28.337     0.200
     9.941    29.450     0.200
    10.069    28.667     0.200
    10.094    28.480     0.200
    10.094    29.430     0.200
    10.226    28.834     0.200
    10.226    28.564     0.200
    10.233    27.639     0.200
    10.469    30.502     0.200
    10.469    30.032     0.200
    10.486    30.893     0.200
    10.493    27.792     0.200
    10.493    29.758     0.200
    10.496    28.946     0.200
    10.638    26.343     0.200
    10.780    27.278     0.200
    10.780    27.348     0.200
    10.816    27.265     0.200
    10.810    30.919     0.200
    10.846    27.603     0.200
    10.846    28.133     0.200
    10.846    27.747     0.200
    10.846    29.483     0.200
    10.846    28.512     0.200
    10.846    28.003     0.200
    10.846    30.932     0.200
    10.846    29.243     0.200
    10.854    30.315     0.200
    10.906    31.007     0.200
    10.966    26.475     0.200
    10.959    30.863     0.200
    11.031    28.265     0.200
    10.982    29.838     0.200
    10.982    31.810     0.200
    11.031    30.549     0.200
    11.031    31.709     0.200
    11.034    30.547     0.200
    11.034    31.905     0.200
    11.066    30.640     0.200
    11.150    28.613     0.200
    11.150    28.726     0.200
    11.177    30.883     0.200
    11.138    29.839     0.200
    11.138    32.263     0.200
    11.258    28.142     0.200
    11.277    30.595     0.200
    11.277    32.614     0.200
    11.383    32.138     0.200
    11.454    29.584     0.200
    11.454    30.469     0.200
    11.508    30.795     0.200
    11.536    30.550     0.200
    11.676    31.914     0.200
    11.703    31.296     0.200
    11.703    33.502     0.200
    11.706    31.630     0.200
    11.779    30.320     0.200
    11.823    31.751     0.200
    11.823    33.039     0.200
    11.828    32.648     0.200
    11.998    32.230     0.200
    12.019    32.720     0.200
    12.102    29.361     0.200
    12.230    30.843     0.200
    12.191    34.016     0.200
    12.228    31.318     0.200
    12.243    33.599     0.200
    12.259    33.714     0.200
    12.276    31.619     0.200
    12.465    34.516     0.200
    12.553    32.365     0.200
    12.528    34.047     0.200
    12.642    30.145     0.200
    12.642    30.477     0.200
    12.642    31.185     0.200
    12.642    32.952     0.200
    12.642    30.655     0.200
    12.642    29.945     0.200
    12.642    31.808     0.200
    12.642    31.515     0.200
    12.642    31.375     0.200
    12.599    33.745     0.200
    12.601    32.194     0.200
    12.634    30.104     0.200
    12.646    33.679     0.200
    12.857    34.636     0.200
    12.928    30.412     0.200
    12.904    33.195     0.200
    12.904    33.969     0.200
    12.905    35.767     0.200
    13.006    32.286     0.200
    13.019    32.056     0.200
    13.009    34.667     0.200
    13.095    36.285     0.200
    13.107    35.421     0.200
    13.107    36.132     0.200
    13.173    33.752     0.200
    13.262    34.249     0.200
    13.294    35.945     0.200
    13.296    35.103     0.200
    13.318    35.955     0.200
    13.327    35.461     0.200
    13.454    32.169     0.200
    13.471    30.866     0.200
    13.423    35.836     0.200
    13.423    36.716     0.200
    13.522    31.379     0.200
    13.522    35.941     0.200
    13.562    32.911     0.200
    13.567    34.541     0.200
    13.693    36.069     0.200
    13.712    37.159     0.200
    13.741    34.399     0.200
    13.794    35.385     0.200
    13.809    36.927     0.200
    13.798    36.888     0.200
    13.936    32.903     0.200
    13.944    33.227     0.200
    13.974    37.196     0.200
    14.011    36.491     0.200
    14.080    33.164     0.200
    14.043    37.292     0.200
    14.080    31.864     0.200
    14.097    37.060     0.200
    14.210    37.804     0.200
    14.221    38.232     0.200
    14.283    38.743     0.200
    14.306    37.435     0.200
    14.348    38.755     0.200
    14.371    33.993     0.200
    14.439    36.149     0.200
    14.476    34.321     0.200
    14.500    33.114     0.200
    14.583    33.988     0.200
    14.629    38.353     0.200
    14.629    39.223     0.200
    14.732    35.981     0.200
    14.732    34.016     0.200
    14.732    34.351     0.200
    14.732    36.131     0.200
    14.793    38.146     0.200
    14.793    37.648     0.200
    14.793    38.777     0.200
    14.793    39.156     0.200
    14.793    38.346     0.200
    14.793    39.966     0.200
    14.793    38.506     0.200
    14.956    38.091     0.200
    15.047    34.378     0.200
    15.014    40.459     0.200
    15.102    33.955     0.200
    15.084    39.550     0.200
    15.129    38.688     0.200
    15.313    34.212     0.200
    15.342    38.103     0.200
    15.436    38.218     0.200
    15.671    35.973     0.200
    15.671    34.797     0.200
    15.685    34.618     0.200
    15.683    40.437     0.200
    15.702    39.563     0.200
    15.754    34.820     0.200
    15.781    37.270     0.200
    15.822    37.178     0.200
    15.820    41.011     0.200
    15.888    36.384     0.200
    15.888    37.061     0.200
    15.871    40.602     0.200
    16.326    36.004     0.200
    16.099    35.697     0.200
    16.099    36.089     0.200
    16.137    35.674     0.200
    16.137    35.298     0.200
    16.137    33.557     0.200
    16.315    36.844     0.200
    16.514    41.068     0.200
    16.656    40.603     0.200
    16.807    39.044     0.200
    17.263    37.728     0.200
    17.302    40.761     0.200
    17.365    39.082     0.200
    17.365    37.932     0.200
    17.365    38.932     0.200
    17.390    40.660     0.200
    17.425    40.186     0.200
    17.452    38.882     0.200
    17.526    39.743     0.200
    17.594    39.977     0.200
    17.600    38.687     0.200
    17.600    38.439     0.200
    17.600    39.107     0.200
    17.600    38.087     0.200
    17.600    39.487     0.200
    17.600    40.200     0.200
    17.600    38.978     0.200
    17.880    38.712     0.200
    18.079    40.140     0.200
    18.126    38.989     0.200
    18.126    39.144     0.200
    18.126    38.764     0.200
    18.126    39.804     0.200
    18.154    41.534     0.200
    18.244    39.152     0.200
    18.244    39.953     0.200
    18.887    42.887     0.200
    18.954    42.799     0.200
    19.167    43.199     0.200
    19.238    42.844     0.200
    19.343    42.854     0.200
    19.445    43.389     0.200
    19.445    42.498     0.200
    19.782    41.725     0.200
    20.152    41.209     0.200
    20.889    41.160     0.200
     2.452    13.425     0.200
     2.623    13.928     0.200
     2.678    14.185     0.200
     3.341    16.242     0.200
     3.616    15.741     0.200
     4.040    17.085     0.200
     4.216    15.687     0.200
     4.222    16.960     0.200
     4.533    18.931     0.200
     4.565    18.062     0.200
     4.592    20.051     0.200
     5.113    18.767     0.200
     5.113    17.137     0.200
     5.276    18.659     0.200
     5.756    21.559     0.200
     5.756    19.199     0.200
     5.708    19.687     0.200
     6.234    21.188     0.200
     6.272    21.143     0.200
     6.272    20.513     0.200
     6.279    20.373     0.200
     6.445    17.978     0.200
     6.627    21.604     0.200
     6.702    22.822     0.200
     6.740    22.682     0.200
     7.074    22.947     0.200
     7.040    23.079     0.200
     7.222    23.257     0.200
     7.222    22.887     0.200
     7.512    23.568     0.200
     7.870    23.902     0.200
     7.925    24.082     0.200
     8.279    26.617     0.200
     8.831    25.556     0.200
     8.831    25.186     0.200
     8.795    25.980     0.200
     8.808    26.248     0.200
     8.929    26.098     0.200
     9.039    27.094     0.200
     9.098    26.411     0.200
     9.167    26.759     0.200
     9.324    27.129     0.200
     9.324    27.739     0.200
     9.933    27.049     0.200
     9.929    28.394     0.200
    10.576    27.378     0.200
    10.722    28.079     0.200
    10.722    28.204     0.200
    10.722    28.714     0.200
    10.862    31.571     0.200
    10.793    29.242     0.200
    10.903    27.556     0.200
    11.118    29.088     0.200
    12.039    30.944     0.200
    12.124    34.097     0.200
    12.115    29.211     0.200
    12.460    34.751     0.200
    12.494    36.005     0.200
    12.509    30.879     0.200
    12.580    33.119     0.200
    12.580    32.548     0.200
    12.580    31.349     0.200
    12.580    33.827     0.200
    12.580    32.429     0.200
    12.580    31.709     0.200
    13.043    33.993     0.200
    13.161    36.573     0.200
    14.016    34.167     0.200
    14.016    34.467     0.200
    14.068    36.857     0.200
    14.259    34.623     0.200
    14.346    37.286     0.200
    14.709    35.608     0.200
    15.619    36.241     0.200
    16.080    36.605     0.200
    17.393    41.581     0.200
    17.555    40.665     0.200
     2.305    12.957     0.200
     2.402    12.732     0.200
     2.392    12.441     0.200
     2.581    13.342     0.200
     2.623    13.050     0.200
     2.838    14.298     0.200
     3.052    14.347     0.200
     3.288    15.488     0.200
     3.982    16.394     0.200
     3.982    15.784     0.200
     4.046    17.041     0.200
     4.154    16.032     0.200
     4.161    16.803     0.200
     4.502    16.422     0.200
     4.545    17.065     0.200
     4.671    17.347     0.200
     4.692    17.007     0.200
     4.810    18.107     0.200
     5.103    17.525     0.200
     5.701    20.133     0.200
     5.653    19.827     0.200
     5.773    19.791     0.200
     5.820    19.227     0.200
     6.179    21.054     0.200
     6.243    20.701     0.200
     6.243    20.181     0.200
     6.219    20.548     0.200
     6.403    17.371     0.200
     6.568    21.546     0.200
     7.110    22.428     0.200
     7.164    22.399     0.200
     8.226    25.059     0.200
     8.976    26.330     0.200
     9.865    28.407     0.200
     9.974    27.884     0.200
    10.619    28.491     0.200
    10.949    28.087     0.200
    12.624    31.809     0.200
    12.624    31.970     0.200
    14.772    35.660     0.200
    16.066    37.271     0.200
    17.340    38.578     0.200
    18.139    39.935     0.200
     3.609    15.538     0.200
     3.609    15.118     0.200
     4.077    17.670     0.200
     4.233    15.643     0.200
     4.239    16.679     0.200
     4.585    17.139     0.200
     4.633    17.271     0.200
     4.764    16.951     0.200
     5.086    18.128     0.200
     5.734    19.234     0.200
     5.733    16.599     0.200
     5.733    21.159     0.200
     5.747    20.580     0.200
     5.821    20.215     0.200
     6.090    21.175     0.200
     6.255    20.649     0.200
     6.255    20.850     0.200
     6.240    21.226     0.200
     6.440    17.610     0.200
     7.003    23.823     0.200
     7.048    22.702     0.200
     7.085    20.978     0.200
     7.232    22.378     0.200
     7.943    24.310     0.200
     8.834    25.533     0.200
     9.166    25.205     0.200
     9.940    26.106     0.200
    10.583    27.063     0.200
    10.736    27.891     0.200
    10.736    28.386     0.200
    10.907    27.990     0.200
    11.707    32.430     0.200
    12.042    29.412     0.200
    12.175    31.143     0.200
    12.509    30.244     0.200
    12.585    32.131     0.200
    12.585    31.844     0.200
    12.585    32.870     0.200
    12.585    33.105     0.200
    12.950    32.195     0.200
    12.964    30.987     0.200
    13.413    32.497     0.200
    14.017    34.266     0.200
    14.258    34.532     0.200
    14.744    35.474     0.200
    14.744    33.896     0.200
    14.744    35.154     0.200
    14.868    39.528     0.200
    15.025    36.728     0.200
    15.507    36.654     0.200
    15.638    37.356     0.200
    16.075    36.818     0.200
    16.117    36.314     0.200
    16.117    36.573     0.200
    17.433    38.804     0.200
    17.662    38.183     0.200
    18.193    38.069     0.200
    18.193    39.689     0.200
     2.301    12.567     0.200
     2.353    12.651     0.200
     2.329    12.534     0.200
     2.601    13.258     0.200
     2.509    12.732     0.200
     2.841    13.799     0.200
     3.033    13.821     0.200
     3.269    15.162     0.200
     3.503    14.962     0.200
     3.870    16.549     0.200
     3.951    16.411     0.200
     3.951    16.771     0.200
     4.028    16.813     0.200
     4.088    15.766     0.200
     4.095    16.230     0.200
     4.472    17.424     0.200
     4.439    17.210     0.200
     4.539    17.645     0.200
     4.607    16.857     0.200
     4.623    17.165     0.200
     4.795    18.427     0.200
     5.049    17.394     0.200
     5.049    17.204     0.200
     5.153    18.285     0.200
     5.630    20.416     0.200
     5.630    19.686     0.200
     5.700    19.593     0.200
     5.879    18.452     0.200
     5.879    20.222     0.200
     5.992    20.292     0.200
     6.181    21.301     0.200
     6.107    20.545     0.200
     6.177    20.432     0.200
     6.177    20.202     0.200
     6.331    16.954     0.200
     6.499    21.161     0.200
     6.577    21.757     0.200
     6.913    22.544     0.200
     7.094    22.212     0.200
     7.180    22.156     0.200
     7.180    22.316     0.200
     7.166    22.886     0.200
     7.166    22.306     0.200
     7.585    24.399     0.200
     7.797    23.318     0.200
     8.165    25.425     0.200
     8.682    26.490     0.200
     8.808    25.974     0.200
     8.691    25.635     0.200
     8.928    26.739     0.200
     8.950    25.152     0.200
     9.290    26.836     0.200
     9.809    28.573     0.200
     9.875    28.396     0.200
    10.045    26.895     0.200
    10.165    28.688     0.200
    10.690    27.710     0.200
    10.825    29.213     0.200
    10.825    26.922     0.200
    12.696    30.700     0.200
    12.696    31.014     0.200
    12.696    32.194     0.200
    13.510    34.286     0.200
    14.137    34.530     0.200
    14.737    34.466     0.200
    14.740    36.649     0.200
    14.740    37.265     0.200
    15.709    36.529     0.200
    16.099    35.728     0.200
    16.194    40.201     0.200
    17.320    37.809     0.200
    17.331    39.628     0.200
    18.067    39.604     0.200
    18.067    39.345     0.200
     2.509    13.164     0.200
     4.638    17.234     0.200
     5.790    20.078     0.200
     6.146    20.625     0.200
     6.308    20.632     0.200
     6.296    21.075     0.200
     7.030    21.438     0.200
     8.778    24.805     0.200
    10.527    27.869     0.200
    10.681    29.109     0.200
    14.714    35.676     0.200
     2.333    12.941     0.200
     2.595    13.389     0.200
     2.654    13.398     0.200
     2.864    14.593     0.200
     3.082    15.201     0.200
     3.318    15.142     0.200
     3.588    15.198     0.200
     3.588    14.848     0.200
     3.906    17.282     0.200
     4.013    16.333     0.200
     4.013    16.663     0.200
     4.077    17.096     0.200
     4.182    14.959     0.200
     4.188    16.592     0.200
     4.531    17.392     0.200
     4.513    17.900     0.200
     4.574    17.780     0.200
     4.717    17.416     0.200
     4.840    18.759     0.200
     5.100    18.087     0.200
     5.245    18.361     0.200
     5.714    19.887     0.200
     5.684    19.835     0.200
     6.074    20.789     0.200
     6.201    20.903     0.200
     6.249    20.738     0.200
     6.249    20.477     0.200
     6.251    20.393     0.200
     6.417    16.462     0.200
     6.670    21.828     0.200
     7.099    22.543     0.200
     8.861    25.174     0.200
     9.960    26.921     0.200
    10.604    27.785     0.200
    10.747    28.793     0.200
    11.290    31.132     0.200
    12.609    31.620     0.200
    12.609    32.307     0.200
    12.609    33.417     0.200
    14.712    34.571     0.200
    14.712    34.201     0.200
    16.081    36.832     0.200
     2.258    13.367     0.200
     2.400    13.008     0.200
     2.577    13.439     0.200
     2.587    13.517     0.200
     2.790    14.908     0.200
     3.005    14.943     0.200
     3.582    15.713     0.200
     3.582    15.342     0.200
     3.830    17.216     0.200
     3.938    16.658     0.200
     3.938    16.177     0.200
     4.000    17.636     0.200
     4.133    16.202     0.200
     4.140    16.399     0.200
     4.437    18.238     0.200
     4.498    17.776     0.200
     4.477    16.867     0.200
     4.648    17.366     0.200
     4.675    17.353     0.200
     4.763    18.030     0.200
     5.134    17.964     0.200
     5.221    18.590     0.200
     5.607    20.475     0.200
     5.607    19.863     0.200
     5.849    17.021     0.200
     5.849    18.921     0.200
     5.708    20.200     0.200
     5.772    20.558     0.200
     6.072    21.054     0.200
     6.177    20.727     0.200
     6.170    21.414     0.200
     6.261    20.647     0.200
     6.261    20.759     0.200
     6.408    17.893     0.200
     6.551    22.286     0.200
     6.644    22.777     0.200
     6.868    23.267     0.200
     7.099    22.287     0.200
     7.099    23.118     0.200
     6.973    23.239     0.200
     7.150    23.964     0.200
     7.245    24.363     0.200
     7.245    23.012     0.200
     7.840    25.465     0.200
     8.876    25.279     0.200
     9.221    24.410     0.200
     9.968    26.812     0.200
    10.743    28.753     0.200
    10.743    28.729     0.200
    10.947    28.192     0.200
    11.082    29.299     0.200
    11.779    31.848     0.200
    12.083    29.100     0.200
    12.563    30.852     0.200
    12.620    32.297     0.200
    12.620    31.429     0.200
    12.620    31.595     0.200
    12.620    32.695     0.200
    13.099    34.283     0.200
    13.436    32.212     0.200
    14.067    34.154     0.200
    14.313    36.769     0.200
    14.659    35.034     0.200
    14.659    33.919     0.200
    14.659    35.133     0.200
    14.886    38.959     0.200
    15.624    35.704     0.200
    16.024    36.810     0.200
    16.024    36.375     0.200
    16.122    37.076     0.200
    17.293    41.523     0.200
    17.455    41.408     0.200
    17.523    41.071     0.200
    17.528    40.326     0.200
    17.528    41.056     0.200
    18.135    39.240     0.200
    18.135    40.230     0.200
    19.100    44.218     0.200
    19.371    44.248     0.200
    19.613    42.429     0.200
    20.461    40.435     0.200
     2.297    12.881     0.200
     2.382    12.284     0.200
     2.576    13.128     0.200
     2.831    14.573     0.200
     3.570    15.127     0.200
     3.869    16.833     0.200
     3.972    16.735     0.200
     4.037    16.975     0.200
     4.145    16.065     0.200
     4.152    16.037     0.200
     4.537    16.616     0.200
     4.683    17.034     0.200
     4.801    19.219     0.200
     5.104    18.829     0.200
     5.218    18.390     0.200
     5.644    19.904     0.200
     5.767    19.990     0.200
     6.171    20.971     0.200
     6.397    16.799     0.200
     6.559    21.023     0.200
     7.209    24.255     0.200
     7.209    23.915     0.200
    16.062    37.968     0.200
     2.233    12.770     0.200
     2.311    12.058     0.200
     2.544    13.242     0.200
     2.552    13.144     0.200
     2.770    14.140     0.200
     2.973    14.229     0.200
     3.210    15.771     0.200
     3.547    14.837     0.200
     3.804    16.637     0.200
     3.900    16.305     0.200
     3.900    16.079     0.200
     3.968    16.622     0.200
     4.087    16.260     0.200
     4.094    15.646     0.200
     4.408    17.682     0.200
     4.431    16.017     0.200
     4.472    18.368     0.200
     4.630    17.090     0.200
     4.733    18.013     0.200
     5.118    18.315     0.200
     5.573    20.056     0.200
     5.673    19.624     0.200
     6.038    20.357     0.200
     6.137    20.614     0.200
     6.126    20.731     0.200
     6.371    17.032     0.200
     6.505    21.277     0.200
     6.602    22.079     0.200
     7.105    23.347     0.200
     7.241    24.400     0.200
     7.795    24.424     0.200
     8.788    26.810     0.200
     8.896    26.460     0.200
     9.788    28.981     0.200
    10.775    27.878     0.200
    12.658    30.938     0.200
    12.658    31.793     0.200
    12.658    32.277     0.200
    12.658    31.918     0.200
    14.661    34.227     0.200
    16.023    35.698     0.200
    16.023    34.077     0.200
     2.212    12.955     0.200
     2.249    11.920     0.200
     2.271    12.363     0.200
     2.468    12.664     0.200
     2.502    13.369     0.200
     2.759    14.385     0.200
     2.935    14.418     0.200
     3.171    14.558     0.200
     3.463    14.854     0.200
     3.463    14.983     0.200
     3.779    16.169     0.200
     3.848    15.664     0.200
     3.848    15.437     0.200
     3.930    16.709     0.200
     3.999    15.896     0.200
     4.006    15.217     0.200
     4.345    16.855     0.200
     4.378    17.775     0.200
     4.448    17.230     0.200
     4.516    16.773     0.200
     4.541    16.680     0.200
     4.699    18.140     0.200
     5.090    18.273     0.200
     5.064    18.568     0.200
     5.064    17.158     0.200
     5.529    19.840     0.200
     5.529    19.941     0.200
     5.589    19.145     0.200
     5.643    19.510     0.200
     5.956    20.555     0.200
     6.036    20.625     0.200
     6.077    19.878     0.200
     5.977    18.348     0.200
     6.159    20.489     0.200
     6.159    20.290     0.200
     6.416    21.454     0.200
     6.512    21.370     0.200
     7.015    23.392     0.200
     7.207    24.664     0.200
     7.207    22.312     0.200
     7.214    22.077     0.200
     7.214    22.284     0.200
     8.708    26.330     0.200
     9.003    25.841     0.200
     9.709    28.454     0.200
     9.817    28.830     0.200
    10.089    28.022     0.200
    10.735    27.566     0.200
    10.855    27.648     0.200
    12.745    32.008     0.200
    12.745    31.387     0.200
    13.563    33.824     0.200
    14.196    35.488     0.200
    16.050    37.236     0.200
    16.251    38.162     0.200
    17.221    37.898     0.200
    18.004    38.125     0.200
    18.004    39.527     0.200
     2.216    12.673     0.200
     2.254    12.426     0.200
     2.501    13.141     0.200
     2.764    13.928     0.200
     2.935    14.081     0.200
     3.171    15.124     0.200
     3.446    14.816     0.200
     3.782    16.102     0.200
     3.845    16.068     0.200
     3.845    15.916     0.200
     3.930    16.673     0.200
     3.986    15.061     0.200
     3.993    15.641     0.200
     4.380    17.123     0.200
     4.451    18.012     0.200
     4.526    16.815     0.200
     4.700    17.075     0.200
     5.049    17.208     0.200
     5.049    16.946     0.200
     5.073    17.828     0.200
     5.528    19.519     0.200
     5.572    19.412     0.200
     5.627    19.670     0.200
     6.020    20.275     0.200
     6.072    20.393     0.200
     6.142    20.053     0.200
     6.142    20.362     0.200
     6.401    21.299     0.200
     6.496    22.025     0.200
    10.872    28.510     0.200
    12.762    33.099     0.200
    14.706    36.915     0.200
    15.739    34.634     0.200
    16.062    38.700     0.200
     2.255    13.000     0.200
     2.583    13.479     0.200
     2.784    13.995     0.200
     3.009    14.001     0.200
     3.245    14.844     0.200
     3.615    15.231     0.200
     3.829    16.635     0.200
     3.948    16.452     0.200
     4.003    16.699     0.200
     4.161    16.164     0.200
     4.168    15.779     0.200
     4.437    17.239     0.200
     4.496    16.829     0.200
     4.765    18.051     0.200
     5.162    17.580     0.200
     5.253    18.219     0.200
     5.613    20.012     0.200
     5.613    19.122     0.200
     5.741    20.021     0.200
     5.804    20.078     0.200
     6.105    20.572     0.200
     6.190    20.357     0.200
     6.201    20.152     0.200
     6.293    20.779     0.200
     6.293    20.510     0.200
     6.580    22.251     0.200
     6.676    21.906     0.200
     7.268    23.053     0.200
     7.617    23.731     0.200
    10.711    27.727     0.200
    12.587    30.745     0.200
    12.587    31.167     0.200
    12.587    32.327     0.200
    12.587    32.014     0.200
    14.637    34.124     0.200
    14.637    34.300     0.200
    16.004    35.898     0.200
    16.004    38.347     0.200
    17.297    38.984     0.200
    17.297    39.956     0.200
    17.459    39.565     0.200
    20.079    41.995     0.200
     2.651    13.260     0.200
     3.122    15.166     0.200
     4.061    16.604     0.200
     4.116    17.366     0.200
     4.604    16.026     0.200
     5.769    19.967     0.200
     5.852    19.810     0.200
     6.265    20.488     0.200
    10.697    27.609     0.200
    12.551    32.046     0.200
    12.551    30.577     0.200
    14.701    37.477     0.200
    14.852    37.739     0.200
     2.244    12.765     0.200
     2.556    13.225     0.200
     2.781    13.903     0.200
     2.985    14.614     0.200
     3.222    15.154     0.200
     3.550    15.148     0.200
     3.815    16.526     0.200
     3.913    16.888     0.200
     3.980    16.706     0.200
     4.097    16.060     0.200
     4.104    15.657     0.200
     4.441    17.219     0.200
     4.420    17.772     0.200
     4.483    17.557     0.200
     4.613    17.321     0.200
     5.115    17.723     0.200
     5.186    18.135     0.200
     5.676    19.808     0.200
     5.586    19.667     0.200
     5.737    19.594     0.200
     5.884    18.656     0.200
     6.041    20.549     0.200
     6.134    20.368     0.200
     6.234    20.799     0.200
     6.150    21.296     0.200
     6.376    15.958     0.200
     6.514    21.386     0.200
     6.609    22.126     0.200
     7.129    22.100     0.200
     7.566    23.349     0.200
     8.683    25.118     0.200
     9.255    24.989     0.200
    10.000    26.755     0.200
    10.645    28.078     0.200
    10.773    28.053     0.200
    12.598    30.643     0.200
    12.653    31.557     0.200
    14.667    35.532     0.200
    16.030    35.653     0.200
     2.355    13.210     0.200
     2.458    12.806     0.200
     2.682    13.694     0.200
     2.883    14.733     0.200
     3.109    14.608     0.200
     3.346    15.248     0.200
     3.617    15.787     0.200
     3.617    15.486     0.200
     3.929    16.843     0.200
     4.045    16.590     0.200
     4.104    17.305     0.200
     4.219    16.507     0.200
     4.226    15.477     0.200
     4.538    17.940     0.200
     4.596    18.136     0.200
     4.755    17.308     0.200
     5.112    18.939     0.200
     5.112    18.189     0.200
     5.279    17.991     0.200
     5.743    19.877     0.200
     5.713    19.725     0.200
     5.713    20.455     0.200
     5.824    19.734     0.200
     5.752    18.355     0.200
     5.752    21.285     0.200
     6.101    21.093     0.200
     6.236    21.218     0.200
     6.272    21.399     0.200
     6.272    21.020     0.200
     6.284    20.388     0.200
     6.447    17.051     0.200
     6.631    21.676     0.200
     7.197    24.505     0.200
     7.197    24.275     0.200
     7.225    23.203     0.200
     7.073    22.665     0.200
     8.796    25.551     0.200
     8.933    26.048     0.200
     9.165    26.546     0.200
     9.933    29.265     0.200
     9.931    28.167     0.200
    14.711    37.566     0.200
    14.711    37.066     0.200
    15.756    37.541     0.200
     2.265    12.775     0.200
     2.579    13.411     0.200
     2.801    14.073     0.200
     3.008    14.203     0.200
     3.245    14.745     0.200
     3.558    15.194     0.200
     3.837    16.632     0.200
     3.936    16.171     0.200
     4.003    16.596     0.200
     4.116    16.256     0.200
     4.505    17.338     0.200
     4.657    17.268     0.200
     5.110    18.075     0.200
     5.110    17.653     0.200
     5.684    19.679     0.200
     6.173    20.127     0.200
     6.236    20.263     0.200
     6.532    21.959     0.200
     7.225    22.787     0.200
    10.865    29.348     0.200
    11.640    32.165     0.200
    16.043    38.385     0.200
     2.200    12.937     0.200
     2.264    12.093     0.200
     2.321    12.223     0.200
     2.503    13.205     0.200
     2.741    14.360     0.200
     2.520    12.905     0.200
     2.933    14.076     0.200
     3.170    15.020     0.200
     3.514    14.896     0.200
     3.514    15.158     0.200
     3.769    16.120     0.200
     3.856    15.912     0.200
     3.856    16.271     0.200
     3.928    16.768     0.200
     4.039    16.016     0.200
     4.046    15.994     0.200
     4.372    17.291     0.200
     4.382    16.975     0.200
     4.554    17.168     0.200
     5.138    18.145     0.200
     5.110    17.378     0.200
     5.532    19.355     0.200
     5.640    19.488     0.200
     5.693    19.772     0.200
     5.945    18.995     0.200
     6.091    19.912     0.200
     6.008    19.997     0.200
     6.083    20.820     0.200
     6.210    20.139     0.200
     6.210    20.369     0.200
     6.337    16.594     0.200
     6.458    21.552     0.200
     6.560    21.849     0.200
     7.163    22.337     0.200
     7.059    22.065     0.200
     7.246    22.476     0.200
     8.738    26.287     0.200
     8.847    27.186     0.200
     9.303    25.310     0.200
     9.738    29.286     0.200
    10.038    26.008     0.200
    10.684    27.755     0.200
    10.804    28.135     0.200
    10.804    27.682     0.200
    11.867    33.520     0.200
    12.694    31.291     0.200
    12.694    31.443     0.200
    12.694    31.912     0.200
    12.694    32.322     0.200
    13.183    33.448     0.200
    14.147    34.428     0.200
    14.656    34.734     0.200
    14.656    33.663     0.200
    14.656    34.702     0.200
    14.767    34.813     0.200
    14.812    37.178     0.200
    15.674    38.412     0.200
    16.015    35.593     0.200
    16.015    35.288     0.200
    15.998    36.818     0.200
    19.197    43.088     0.200
     2.256    12.942     0.200
     2.553    13.276     0.200
     2.985    14.234     0.200
     3.488    14.863     0.200
     3.825    16.534     0.200
     3.901    16.142     0.200
     3.980    17.329     0.200
     4.049    15.105     0.200
     4.055    15.745     0.200
     4.426    17.521     0.200
     4.494    18.178     0.200
     4.566    17.088     0.200
     4.587    16.945     0.200
     5.060    17.016     0.200
     5.060    16.809     0.200
     5.126    17.950     0.200
     5.581    20.039     0.200
     5.581    18.867     0.200
     5.614    19.454     0.200
     5.677    19.819     0.200
     5.924    15.813     0.200
     5.979    20.396     0.200
     6.077    20.755     0.200
     6.132    20.414     0.200
     6.173    20.437     0.200
     6.173    19.886     0.200
     6.463    21.164     0.200
     6.550    21.932     0.200
     7.060    21.986     0.200
     7.757    23.305     0.200
     8.762    25.633     0.200
     8.880    26.738     0.200
     9.080    27.194     0.200
     9.763    28.724     0.200
    12.715    31.834     0.200
    12.715    31.002     0.200
    16.072    36.308     0.200
     2.227    12.927     0.200
     2.323    12.708     0.200
     2.529    13.300     0.200
     2.516    12.947     0.200
     2.768    14.142     0.200
     2.960    14.070     0.200
     3.196    14.612     0.200
     3.511    14.838     0.200
     3.511    14.940     0.200
     3.796    16.509     0.200
     3.881    15.922     0.200
     3.881    15.742     0.200
     3.955    16.462     0.200
     4.052    16.439     0.200
     4.059    15.549     0.200
     4.399    17.384     0.200
     4.397    16.904     0.200
     4.465    17.808     0.200
     4.568    16.212     0.200
     4.594    16.805     0.200
     5.093    17.274     0.200
     5.093    17.934     0.200
     5.142    18.307     0.200
     5.558    18.952     0.200
     5.558    19.284     0.200
     5.637    19.529     0.200
     5.695    19.757     0.200
     5.927    17.212     0.200
     5.855    19.186     0.200
     6.003    20.055     0.200
     6.115    20.587     0.200
     6.089    20.654     0.200
     6.201    20.550     0.200
     6.201    19.960     0.200
     6.335    16.512     0.200
     6.469    21.241     0.200
     6.565    21.804     0.200
     6.802    22.433     0.200
     7.168    20.969     0.200
     7.168    22.429     0.200
     7.224    21.120     0.200
     7.526    23.280     0.200
     7.759    25.130     0.200
     7.962    21.309     0.200
     8.108    23.600     0.200
     8.706    26.209     0.200
     8.757    26.574     0.200
     8.868    26.998     0.200
     9.299    24.773     0.200
     9.495    25.903     0.200
     9.495    29.383     0.200
     9.757    28.601     0.200
    10.040    26.199     0.200
     9.869    28.916     0.200
    10.686    26.998     0.200
    10.810    28.110     0.200
    10.810    27.966     0.200
    11.023    26.930     0.200
    11.112    28.107     0.200
    11.953    26.767     0.200
    12.159    29.836     0.200
    12.695    31.464     0.200
    12.695    30.859     0.200
    12.695    31.773     0.200
    12.695    32.269     0.200
    12.695    31.179     0.200
    12.695    32.097     0.200
    13.198    37.089     0.200
    13.297    36.345     0.200
    13.512    32.826     0.200
    13.689    38.367     0.200
    13.853    38.753     0.200
    14.144    33.050     0.200
    14.678    33.825     0.200
    14.678    34.836     0.200
    14.671    38.393     0.200
    14.838    35.683     0.200
    14.962    40.155     0.200
    15.317    37.086     0.200
    15.561    37.334     0.200
    15.700    41.607     0.200
    15.799    36.095     0.200
    16.037    36.656     0.200
    16.037    34.691     0.200
    16.199    39.138     0.200
    16.689    39.546     0.200
    17.184    41.376     0.200
    17.247    38.937     0.200
    17.269    39.880     0.200
    17.305    40.330     0.200
    17.483    39.247     0.200
    17.502    40.066     0.200
    18.162    38.588     0.200
    18.056    39.400     0.200
    19.169    40.715     0.200
    19.197    42.281     0.200
    19.683    40.613     0.200
     2.265    12.931     0.200
     2.322    12.273     0.200
     2.567    13.212     0.200
     3.234    15.419     0.200
     3.506    14.745     0.200
     3.835    16.711     0.200
     3.917    16.251     0.200
     3.993    16.972     0.200
     4.077    15.086     0.200
     4.418    16.902     0.200
     4.437    17.685     0.200
     4.504    17.315     0.200
     4.608    16.883     0.200
     5.147    18.100     0.200
     5.632    19.535     0.200
     5.595    19.969     0.200
     5.697    19.980     0.200
     6.098    20.403     0.200
     6.188    20.055     0.200
     6.571    21.686     0.200
    12.696    33.100     0.200
    19.381    42.808     0.200
    20.079    41.854     0.200
     2.282    12.702     0.200
     2.395    12.588     0.200
     2.370    12.780     0.200
     2.578    13.249     0.200
     2.599    13.200     0.200
     2.816    14.245     0.200
     3.028    14.297     0.200
     3.264    15.538     0.200
     3.572    14.847     0.200
     3.854    16.852     0.200
     3.958    16.142     0.200
     3.958    16.312     0.200
     4.022    16.592     0.200
     4.138    16.677     0.200
     4.145    16.458     0.200
     4.485    16.796     0.200
     4.522    17.811     0.200
     4.678    17.339     0.200
     4.786    18.628     0.200
     5.113    17.633     0.200
     5.698    19.436     0.200
     5.629    19.758     0.200
     6.168    21.048     0.200
     6.246    20.442     0.200
     6.196    20.531     0.200
     6.399    15.955     0.200
     6.641    22.134     0.200
     2.315    12.918     0.200
     2.640    13.422     0.200
     2.845    14.046     0.200
     3.068    15.138     0.200
     3.304    15.379     0.200
     3.606    15.149     0.200
     3.606    15.282     0.200
     3.889    16.750     0.200
     4.003    16.625     0.200
     4.003    15.992     0.200
     4.062    17.034     0.200
     4.187    15.648     0.200
     4.194    16.490     0.200
     4.497    17.960     0.200
     4.556    18.591     0.200
     4.726    17.287     0.200
     4.824    18.335     0.200
     5.124    17.651     0.200
     5.259    18.364     0.200
     5.671    20.156     0.200
     5.671    19.867     0.200
     5.732    19.837     0.200
     5.789    17.180     0.200
     5.789    20.523     0.200
     5.806    20.272     0.200
     6.093    20.426     0.200
     6.213    21.229     0.200
     6.242    20.575     0.200
     6.435    16.163     0.200
     6.602    21.967     0.200
     6.684    22.533     0.200
     7.079    20.143     0.200
     7.079    22.010     0.200
     7.219    23.386     0.200
     7.219    23.245     0.200
     7.875    21.785     0.200
     9.183    26.417     0.200
     9.942    26.782     0.200
    10.586    27.433     0.200
    10.726    27.346     0.200
    10.916    27.347     0.200
    12.526    30.565     0.200
    12.591    31.037     0.200
    12.591    31.303     0.200
    12.591    31.537     0.200
    13.404    30.855     0.200
    14.687    33.433     0.200
    14.687    33.863     0.200
    14.794    37.108     0.200
    14.794    37.921     0.200
    14.948    36.708     0.200
    15.431    37.688     0.200
    15.691    38.211     0.200
    16.057    34.853     0.200
    16.088    35.846     0.200
    17.356    38.487     0.200
    20.099    41.216     0.200
     2.340    12.740     0.200
     2.453    12.523     0.200
     2.626    12.702     0.200
     2.668    13.115     0.200
     2.868    13.884     0.200
     3.095    13.933     0.200
     3.331    14.474     0.200
     3.619    15.213     0.200
     4.031    15.805     0.200
     4.031    15.956     0.200
     4.089    16.430     0.200
     4.213    15.755     0.200
     4.220    15.908     0.200
     4.523    16.869     0.200
     4.561    17.022     0.200
     4.581    17.742     0.200
     4.730    16.948     0.200
     4.750    17.223     0.200
     4.851    17.822     0.200
     5.122    17.481     0.200
     5.278    18.460     0.200
     5.761    20.918     0.200
     5.761    21.562     0.200
     5.761    20.657     0.200
     5.761    19.718     0.200
     5.761    21.388     0.200
     5.761    19.867     0.200
     5.699    19.246     0.200
     5.699    20.306     0.200
     5.745    19.603     0.200
     5.838    21.866     0.200
     5.838    22.162     0.200
     5.838    23.037     0.200
     5.824    19.790     0.200
     6.005    19.875     0.200
     6.104    20.411     0.200
     6.234    20.302     0.200
     6.278    20.287     0.200
     6.278    20.558     0.200
     6.271    20.637     0.200
     6.449    16.083     0.200
     6.626    21.600     0.200
     6.703    21.827     0.200
     6.733    22.074     0.200
     6.962    22.205     0.200
     7.069    21.813     0.200
     7.069    21.348     0.200
     7.018    22.153     0.200
     7.210    22.714     0.200
     7.210    23.435     0.200
     7.221    22.485     0.200
     7.221    22.725     0.200
     7.319    23.636     0.200
     7.506    23.458     0.200
     7.691    23.295     0.200
     7.696    23.442     0.200
     7.865    22.866     0.200
     8.096    24.565     0.200
     8.272    24.910     0.200
     8.285    25.360     0.200
     8.583    25.190     0.200
     8.650    25.711     0.200
     8.800    27.356     0.200
     8.800    25.566     0.200
     8.804    25.511     0.200
     8.808    25.755     0.200
     8.807    26.273     0.200
     8.923    26.237     0.200
     9.033    26.880     0.200
     9.107    25.770     0.200
     9.107    26.711     0.200
     9.109    26.450     0.200
     9.165    25.613     0.200
     9.233    28.298     0.200
     9.329    27.979     0.200
     9.329    28.575     0.200
     9.580    28.652     0.200
     9.686    26.843     0.200
     9.700    28.750     0.200
     9.766    28.167     0.200
     9.818    29.972     0.200
     9.929    25.570     0.200
     9.961    28.860     0.200
     9.961    30.156     0.200
     9.923    28.105     0.200
    10.002    29.233     0.200
    10.002    30.087     0.200
     9.998    29.053     0.200
    10.134    30.192     0.200
    10.134    30.352     0.200
    10.227    28.297     0.200
    10.294    28.237     0.200
    10.272    29.034     0.200
    10.345    23.659     0.200
    10.586    29.437     0.200
    10.547    31.381     0.200
    10.535    30.641     0.200
    10.573    26.674     0.200
    10.553    27.380     0.200
    10.553    29.352     0.200
    10.557    29.818     0.200
    10.628    31.453     0.200
    10.717    27.667     0.200
    10.717    27.151     0.200
    10.869    29.874     0.200
    10.803    29.115     0.200
    10.900    26.574     0.200
    10.857    31.447     0.200
    10.857    32.006     0.200
    10.906    30.178     0.200
    10.906    27.943     0.200
    10.906    30.687     0.200
    10.906    29.958     0.200
    10.906    29.734     0.200
    10.906    28.697     0.200
    10.891    31.857     0.200
    10.967    29.000     0.200
    11.008    30.354     0.200
    11.053    31.921     0.200
    11.042    28.404     0.200
    11.042    31.720     0.200
    11.017    31.572     0.200
    11.133    31.559     0.200
    11.095    31.204     0.200
    11.095    33.239     0.200
    11.072    29.878     0.200
    11.108    28.143     0.200
    11.108    28.006     0.200
    11.198    31.392     0.200
    11.198    32.077     0.200
    11.338    31.515     0.200
    11.338    33.404     0.200
    11.323    27.882     0.200
    11.415    32.041     0.200
    11.512    29.572     0.200
    11.512    30.662     0.200
    11.557    33.407     0.200
    11.557    33.852     0.200
    11.571    31.305     0.200
    11.589    30.387     0.200
    11.631    29.742     0.200
    11.606    31.606     0.200
    11.714    30.150     0.200
    11.762    31.389     0.200
    11.765    32.542     0.200
    11.765    33.231     0.200
    11.883    32.367     0.200
    11.883    32.850     0.200
    11.877    32.148     0.200
    12.036    28.750     0.200
    12.051    33.725     0.200
    12.055    32.163     0.200
    12.165    29.616     0.200
    12.249    34.056     0.200
    12.278    30.635     0.200
    12.306    32.639     0.200
    12.467    32.766     0.200
    12.498    31.257     0.200
    12.530    34.708     0.200
    12.577    30.081     0.200
    12.577    29.912     0.200
    12.577    30.791     0.200
    12.577    30.600     0.200
    12.577    30.287     0.200
    12.577    32.466     0.200
    12.577    31.297     0.200
    12.577    31.131     0.200
    12.617    30.961     0.200
    12.584    33.750     0.200
    12.649    30.210     0.200
    12.694    32.587     0.200
    12.634    33.108     0.200
    12.698    33.538     0.200
    12.890    32.133     0.200
    12.862    30.909     0.200
    12.941    31.330     0.200
    12.954    31.658     0.200
    12.993    34.327     0.200
    12.967    33.610     0.200
    12.970    35.141     0.200
    13.042    30.993     0.200
    13.302    33.339     0.200
    13.302    33.581     0.200
    13.321    36.683     0.200
    13.388    30.910     0.200
    13.388    32.189     0.200
    13.358    35.131     0.200
    13.358    35.818     0.200
    13.358    35.571     0.200
    13.406    31.823     0.200
    13.342    35.944     0.200
    13.391    35.048     0.200
    13.457    31.950     0.200
    13.438    35.130     0.200
    13.465    37.278     0.200
    13.586    35.551     0.200
    13.632    34.294     0.200
    13.654    37.568     0.200
    13.756    35.496     0.200
    13.803    34.443     0.200
    13.803    34.305     0.200
    13.911    33.765     0.200
    13.873    34.145     0.200
    13.863    34.120     0.200
    13.860    35.975     0.200
    13.835    36.897     0.200
    14.013    33.830     0.200
    14.040    34.624     0.200
    14.014    33.205     0.200
    14.014    33.505     0.200
    14.063    37.351     0.200
    14.007    37.087     0.200
    14.058    33.394     0.200
    14.202    35.453     0.200
    14.237    34.536     0.200
    14.257    32.696     0.200
    14.312    34.826     0.200
    14.306    33.543     0.200
    14.337    37.934     0.200
    14.411    33.934     0.200
    14.434    34.023     0.200
    14.639    34.617     0.200
    14.662    39.445     0.200
    14.698    32.750     0.200
    14.698    35.166     0.200
    14.698    33.220     0.200
    14.822    40.175     0.200
    14.822    40.284     0.200
    14.822    36.569     0.200
    14.822    39.199     0.200
    14.822    39.885     0.200
    14.981    34.620     0.200
    14.981    35.920     0.200
    15.036    34.367     0.200
    14.976    37.541     0.200
    15.123    40.800     0.200
    15.272    37.891     0.200
    15.247    34.893     0.200
    15.459    38.188     0.200
    15.620    35.608     0.200
    15.688    35.592     0.200
    15.781    38.770     0.200
    15.720    40.554     0.200
    15.754    38.114     0.200
    15.744    39.433     0.200
    15.876    37.129     0.200
    15.876    36.588     0.200
    15.901    41.078     0.200
    16.260    36.965     0.200
    16.071    35.393     0.200
    16.071    35.029     0.200
    16.071    38.686     0.200
    16.071    35.999     0.200
    16.069    35.920     0.200
    16.069    36.811     0.200
    16.250    36.748     0.200
    16.825    39.901     0.200
    17.206    37.468     0.200
    17.425    40.369     0.200
    17.383    39.089     0.200
    17.383    38.989     0.200
    17.508    39.393     0.200
    17.508    40.514     0.200
    17.545    39.597     0.200
    17.612    39.465     0.200
    17.618    39.449     0.200
    17.618    38.138     0.200
    17.618    38.709     0.200
    17.618    40.150     0.200
    17.618    38.449     0.200
    17.618    38.869     0.200
    17.894    38.721     0.200
    18.131    39.173     0.200
    18.233    39.346     0.200
    18.192    39.085     0.200
    18.192    38.881     0.200
    18.192    40.251     0.200
    18.192    39.815     0.200
    18.192    39.321     0.200
    18.226    40.360     0.200
    18.445    42.469     0.200
    19.006    41.349     0.200
    18.920    43.947     0.200
    19.200    41.692     0.200
    19.185    41.764     0.200
    19.482    42.699     0.200
    19.482    43.749     0.200
    20.047    41.777     0.200
    20.105    40.951     0.200
    20.367    41.168     0.200
    20.373    41.393     0.200
     2.895    14.738     0.200
     3.144    15.170     0.200
     3.694    15.700     0.200
     4.091    16.076     0.200
     4.137    17.676     0.200
     4.297    15.734     0.200
     4.617    16.908     0.200
     4.895    18.174     0.200
     5.751    20.104     0.200
     6.336    21.137     0.200
     6.525    17.246     0.200
     6.710    21.803     0.200
    12.500    31.154     0.200
     2.518    12.705     0.200
     2.683    13.481     0.200
     2.911    14.375     0.200
     3.675    15.755     0.200
     4.098    17.371     0.200
     4.289    16.602     0.200
     4.631    17.467     0.200
     4.907    18.870     0.200
     5.684    17.565     0.200
     6.319    20.993     0.200
     6.341    21.585     0.200
     6.506    16.636     0.200
     6.700    21.654     0.200
     7.019    21.783     0.200
     7.210    23.343     0.200
     9.874    26.719     0.200
    10.517    27.906     0.200
    10.670    27.877     0.200
    10.840    27.622     0.200
    11.394    31.515     0.200
    11.976    29.574     0.200
    12.443    30.128     0.200
    12.519    30.192     0.200
    12.519    29.728     0.200
    13.328    33.258     0.200
    13.951    33.484     0.200
    14.703    34.796     0.200
    14.703    35.647     0.200
    15.036    40.085     0.200
    16.009    36.827     0.200
    16.079    36.246     0.200
     2.365    13.384     0.200
     2.518    13.105     0.200
     2.687    13.829     0.200
     2.706    14.204     0.200
     2.886    13.852     0.200
     3.131    15.152     0.200
     3.680    16.047     0.200
     3.680    15.787     0.200
     3.941    17.203     0.200
     4.076    17.221     0.200
     4.124    17.257     0.200
     4.279    16.635     0.200
     4.286    16.077     0.200
     4.552    18.361     0.200
     4.606    17.760     0.200
     4.626    17.005     0.200
     4.796    17.223     0.200
     4.816    17.583     0.200
     4.883    18.756     0.200
     5.159    18.405     0.200
     5.343    18.837     0.200
     5.698    21.357     0.200
     5.698    21.787     0.200
     5.698    21.153     0.200
     5.775    22.390     0.200
     5.737    20.943     0.200
     5.805    20.240     0.200
     5.888    20.479     0.200
     6.049    20.296     0.200
     6.163    21.367     0.200
     6.300    21.367     0.200
     6.330    21.218     0.200
     6.320    21.501     0.200
     6.510    16.817     0.200
     6.692    22.452     0.200
     6.791    21.741     0.200
     7.012    22.730     0.200
     7.012    22.331     0.200
     7.014    23.437     0.200
     7.072    23.464     0.200
     7.106    22.661     0.200
     7.231    24.601     0.200
     7.231    24.271     0.200
     7.287    23.645     0.200
     7.287    23.255     0.200
     7.748    24.367     0.200
     7.809    23.703     0.200
     8.330    25.777     0.200
     8.351    25.437     0.200
     8.649    26.553     0.200
     8.715    26.580     0.200
     8.856    27.436     0.200
     8.868    26.499     0.200
     8.985    26.719     0.200
     9.100    26.287     0.200
     9.089    27.480     0.200
     9.141    26.337     0.200
     9.268    28.229     0.200
     9.268    28.523     0.200
     9.268    28.693     0.200
     9.290    28.627     0.200
     9.629    27.838     0.200
     9.631    26.128     0.200
     9.710    26.518     0.200
     9.869    26.499     0.200
    10.015    28.357     0.200
     9.984    29.072     0.200
    10.055    28.402     0.200
    10.055    29.504     0.200
    10.062    30.062     0.200
    10.170    27.301     0.200
    10.291    23.971     0.200
    10.330    29.742     0.200
    10.512    27.742     0.200
    10.599    30.564     0.200
    10.605    27.939     0.200
    10.609    29.763     0.200
    10.662    27.592     0.200
    10.662    27.837     0.200
    10.682    31.645     0.200
    10.809    31.203     0.200
    10.838    27.253     0.200
    10.910    28.568     0.200
    10.915    30.706     0.200
    10.957    30.087     0.200
    10.957    30.466     0.200
    10.957    31.030     0.200
    10.957    29.176     0.200
    10.957    31.236     0.200
    10.957    31.486     0.200
    11.093    31.589     0.200
    11.093    29.949     0.200
    11.081    28.316     0.200
    11.081    27.909     0.200
    11.148    31.802     0.200
    11.127    31.682     0.200
    11.249    32.375     0.200
    11.249    31.942     0.200
    11.391    32.192     0.200
    11.461    33.336     0.200
    11.547    33.281     0.200
    11.561    31.675     0.200
    11.561    31.429     0.200
    11.610    33.034     0.200
    11.610    33.638     0.200
    11.632    31.880     0.200
    11.647    31.063     0.200
    11.628    31.668     0.200
    11.808    31.266     0.200
    11.934    33.439     0.200
    11.934    31.924     0.200
    11.973    29.522     0.200
    11.937    34.488     0.200
    12.093    33.154     0.200
    12.104    30.437     0.200
    12.296    32.649     0.200
    12.316    31.648     0.200
    12.411    33.795     0.200
    12.387    33.323     0.200
    12.435    36.062     0.200
    12.443    30.177     0.200
    12.515    31.378     0.200
    12.515    31.100     0.200
    12.515    30.509     0.200
    12.515    31.703     0.200
    12.629    33.419     0.200
    12.685    29.570     0.200
    12.739    32.911     0.200
    12.800    31.102     0.200
    12.833    33.069     0.200
    12.879    31.195     0.200
    12.893    31.505     0.200
    12.977    32.162     0.200
    13.325    33.084     0.200
    13.344    32.857     0.200
    13.393    32.840     0.200
    13.383    37.710     0.200
    13.424    37.053     0.200
    13.477    36.516     0.200
    13.652    37.707     0.200
    13.816    33.049     0.200
    13.822    37.353     0.200
    13.877    38.150     0.200
    13.922    36.020     0.200
    13.950    34.093     0.200
    14.055    38.872     0.200
    14.103    35.330     0.200
    14.141    36.503     0.200
    14.150    33.831     0.200
    14.090    32.161     0.200
    14.178    34.923     0.200
    14.206    38.191     0.200
    14.243    34.636     0.200
    14.365    34.749     0.200
    14.365    34.648     0.200
    14.371    34.145     0.200
    14.384    38.563     0.200
    14.681    33.855     0.200
    14.681    33.590     0.200
    14.681    33.155     0.200
    14.917    35.208     0.200
    14.867    39.485     0.200
    14.971    35.952     0.200
    14.971    35.102     0.200
    15.012    38.964     0.200
    15.184    35.594     0.200
    15.240    38.484     0.200
    15.222    40.238     0.200
    15.176    40.219     0.200
    15.497    39.434     0.200
    15.556    36.395     0.200
    15.624    36.045     0.200
    15.743    36.622     0.200
    15.771    41.267     0.200
    15.799    40.132     0.200
    16.196    37.112     0.200
    16.007    35.889     0.200
    16.056    35.989     0.200
    16.140    37.865     0.200
    16.188    38.130     0.200
    16.531    39.842     0.200
    16.879    38.792     0.200
    17.159    40.833     0.200
    17.159    41.643     0.200
    17.418    41.141     0.200
    17.418    39.917     0.200
    17.489    39.586     0.200
    17.653    41.652     0.200
    17.653    40.463     0.200
    17.653    41.200     0.200
    17.653    40.282     0.200
    17.653    40.782     0.200
    17.653    41.513     0.200
    18.048    39.427     0.200
    18.193    40.381     0.200
    18.226    38.968     0.200
    18.261    40.680     0.200
    18.257    39.438     0.200
    18.257    39.268     0.200
    18.257    39.115     0.200
    18.967    43.371     0.200
    19.219    42.497     0.200
    19.501    42.114     0.200
    19.532    43.253     0.200
    19.828    42.291     0.200
    20.357    40.550     0.200
    20.330    41.632     0.200
    20.918    43.186     0.200
     2.396    12.896     0.200
     3.157    15.410     0.200
     3.659    15.753     0.200
     3.659    15.532     0.200
     4.098    17.230     0.200
     4.098    17.550     0.200
     4.151    17.410     0.200
     4.278    16.509     0.200
     4.285    15.652     0.200
     4.628    17.040     0.200
     4.581    17.390     0.200
     4.636    17.824     0.200
     4.812    17.500     0.200
     5.126    18.025     0.200
     4.911    19.365     0.200
     5.330    18.456     0.200
     5.784    19.850     0.200
     5.872    20.025     0.200
     5.763    20.634     0.200
     6.140    21.196     0.200
     6.303    21.017     0.200
     6.290    21.149     0.200
     6.340    21.791     0.200
     6.490    16.024     0.200
     6.688    21.896     0.200
     6.756    22.311     0.200
     7.036    21.067     0.200
     7.036    22.487     0.200
     9.115    26.019     0.200
     9.260    23.473     0.200
     9.890    26.087     0.200
    10.533    26.574     0.200
    10.687    27.508     0.200
    10.856    27.675     0.200
    11.991    29.787     0.200
    12.458    30.428     0.200
    12.534    30.198     0.200
    12.534    30.809     0.200
    12.534    30.569     0.200
    13.343    32.691     0.200
    13.966    33.661     0.200
    14.717    34.720     0.200
    14.717    33.120     0.200
    16.024    36.993     0.200
    16.092    36.357     0.200
    18.243    39.091     0.200
    18.243    38.722     0.200
     2.391    12.823     0.200
     2.712    13.078     0.200
     3.141    14.879     0.200
     3.377    16.120     0.200
     3.591    15.817     0.200
     3.964    17.264     0.200
     4.070    17.126     0.200
     4.135    17.074     0.200
     4.572    18.777     0.200
     4.632    18.327     0.200
     6.223    21.101     0.200
    12.602    32.217     0.200
    16.126    37.493     0.200
     2.353    13.077     0.200
     2.465    12.569     0.200
     2.683    13.027     0.200
     3.110    14.549     0.200
     3.346    15.091     0.200
     3.629    15.589     0.200
     4.104    17.447     0.200
     4.235    16.314     0.200
     4.537    18.296     0.200
     4.594    17.127     0.200
     6.247    21.032     0.200
    16.075    35.823     0.200
     2.359    12.798     0.200
     2.496    12.795     0.200
     2.695    13.571     0.200
     2.666    13.107     0.200
     2.881    14.467     0.200
     3.120    14.408     0.200
     3.357    14.950     0.200
     3.659    15.324     0.200
     3.659    15.464     0.200
     3.933    16.719     0.200
     4.063    16.613     0.200
     4.063    17.232     0.200
     4.114    16.909     0.200
     4.257    16.500     0.200
     4.264    16.162     0.200
     4.544    17.591     0.200
     4.599    17.394     0.200
     4.775    17.805     0.200
     4.794    17.374     0.200
     4.874    19.486     0.200
     5.145    17.582     0.200
     5.145    18.342     0.200
     5.321    18.626     0.200
     5.718    18.908     0.200
     5.726    20.580     0.200
     5.785    20.215     0.200
     5.866    19.766     0.200
     6.143    20.437     0.200
     6.305    20.260     0.200
     6.278    21.159     0.200
     6.312    20.828     0.200
     6.489    16.296     0.200
     6.670    21.550     0.200
     6.747    22.390     0.200
     7.031    22.086     0.200
     7.084    22.253     0.200
     7.222    24.571     0.200
     7.265    22.836     0.200
     7.265    23.086     0.200
     7.730    23.711     0.200
     7.828    21.890     0.200
     8.312    26.022     0.200
     8.787    24.890     0.200
     9.122    26.058     0.200
     9.071    27.279     0.200
     9.287    25.639     0.200
     9.287    27.940     0.200
     9.889    25.983     0.200
    10.533    26.905     0.200
    10.681    26.829     0.200
    10.681    27.396     0.200
    10.859    26.890     0.200
    11.092    28.221     0.200
    11.669    30.642     0.200
    11.994    29.738     0.200
    12.125    29.218     0.200
    12.465    30.109     0.200
    12.536    31.110     0.200
    12.536    30.618     0.200
    12.536    30.870     0.200
    12.536    31.263     0.200
    12.536    31.729     0.200
    12.821    31.211     0.200
    12.900    32.136     0.200
    12.914    31.317     0.200
    12.998    32.421     0.200
    13.347    32.369     0.200
    13.347    32.968     0.200
    13.365    30.866     0.200
    13.415    33.195     0.200
    13.465    34.683     0.200
    13.864    36.628     0.200
    13.972    32.575     0.200
    13.972    33.995     0.200
    13.972    33.075     0.200
    14.026    36.645     0.200
    14.040    36.574     0.200
    14.214    34.232     0.200
    14.214    33.251     0.200
    14.370    36.449     0.200
    14.688    34.640     0.200
    14.688    34.211     0.200
    14.688    35.011     0.200
    14.688    35.101     0.200
    14.854    38.851     0.200
    14.939    35.691     0.200
    14.993    34.760     0.200
    14.993    34.340     0.200
    15.002    35.932     0.200
    15.486    36.340     0.200
    15.581    37.081     0.200
    15.816    36.438     0.200
    15.878    36.996     0.200
    16.029    36.356     0.200
    16.062    35.574     0.200
    16.062    35.926     0.200
    17.408    40.415     0.200
    17.408    40.269     0.200
    17.571    41.075     0.200
    17.643    41.203     0.200
    17.643    39.773     0.200
    17.643    40.232     0.200
    17.643    40.933     0.200
    17.669    41.221     0.200
    18.228    39.782     0.200
    18.235    39.008     0.200
    18.235    39.389     0.200
    18.969    42.061     0.200
    19.210    43.847     0.200
    19.481    41.078     0.200
    20.329    40.982     0.200
    20.871    42.054     0.200
     2.380    13.071     0.200
     2.510    12.847     0.200
     2.718    13.921     0.200
     2.677    13.202     0.200
     2.901    14.445     0.200
     3.143    14.961     0.200
     3.669    15.524     0.200
     3.669    15.274     0.200
     3.954    16.791     0.200
     4.086    17.087     0.200
     4.137    17.565     0.200
     4.277    16.441     0.200
     4.284    16.344     0.200
     4.566    18.156     0.200
     4.626    17.152     0.200
     4.795    18.081     0.200
     4.896    18.656     0.200
     4.813    17.570     0.200
     5.143    17.926     0.200
     5.336    18.173     0.200
     5.696    17.562     0.200
     5.749    20.149     0.200
     5.749    20.399     0.200
     5.795    20.116     0.200
     5.879    20.228     0.200
     6.151    20.952     0.200
     6.329    20.422     0.200
     6.294    20.585     0.200
     6.316    20.718     0.200
     6.689    21.727     0.200
     6.762    22.432     0.200
     7.024    20.909     0.200
     7.024    22.009     0.200
     7.214    24.034     0.200
     7.754    24.356     0.200
     8.775    25.855     0.200
     8.775    25.215     0.200
     9.108    26.185     0.200
     9.880    26.052     0.200
    10.523    27.298     0.200
    10.674    27.545     0.200
    10.674    27.719     0.200
    10.847    27.452     0.200
    11.653    33.350     0.200
    11.983    29.482     0.200
    12.451    30.385     0.200
    12.525    31.584     0.200
    12.525    29.404     0.200
    12.525    31.062     0.200
    12.525    31.242     0.200
    12.984    31.855     0.200
    13.334    32.566     0.200
    13.334    32.705     0.200
    13.958    34.344     0.200
    13.958    33.715     0.200
    14.200    34.701     0.200
    14.393    36.692     0.200
    14.584    34.685     0.200
    14.698    34.393     0.200
    14.698    33.813     0.200
    14.877    37.656     0.200
    14.977    34.702     0.200
    14.977    34.483     0.200
    15.024    38.185     0.200
    15.578    36.174     0.200
    15.509    38.702     0.200
    15.802    36.409     0.200
    15.901    38.802     0.200
    16.016    36.330     0.200
    16.074    34.950     0.200
    16.074    35.979     0.200
    17.431    38.182     0.200
    17.665    40.738     0.200
    17.692    41.172     0.200
    18.250    39.855     0.200
    18.250    39.646     0.200
    20.051    41.451     0.200
     2.267    12.631     0.200
     3.245    15.115     0.200
     3.552    15.034     0.200
     3.552    14.743     0.200
     3.936    16.653     0.200
     3.936    15.952     0.200
     4.003    17.466     0.200
     4.112    15.719     0.200
     4.119    16.219     0.200
     4.443    18.032     0.200
     4.506    18.295     0.200
     4.768    18.290     0.200
     5.105    16.752     0.200
     5.609    18.948     0.200
     6.042    20.478     0.200
     6.144    20.791     0.200
     6.172    20.846     0.200
     6.231    19.956     0.200
     6.528    21.447     0.200
     7.129    22.238     0.200
     7.126    22.560     0.200
     7.220    21.659     0.200
     9.997    27.297     0.200
    10.643    28.147     0.200
    10.774    28.031     0.200
    10.774    28.236     0.200
    12.112    30.136     0.200
    12.649    30.236     0.200
    12.649    32.266     0.200
    12.649    33.387     0.200
    12.649    31.957     0.200
    13.465    32.238     0.200
    14.095    33.939     0.200
    14.684    34.239     0.200
    14.684    34.698     0.200
    14.727    36.845     0.200
    14.727    36.694     0.200
    14.888    36.680     0.200
    15.123    35.658     0.200
    15.369    38.343     0.200
    15.654    38.490     0.200
    16.047    36.212     0.200
    17.297    38.383     0.200
    18.107    39.723     0.200
     2.105    11.160     0.200
     2.437    12.492     0.200
     2.727    13.103     0.200
     2.598    13.315     0.200
     2.937    13.557     0.200
     3.156    14.001     0.200
     3.589    15.143     0.200
     4.085    15.960     0.200
     4.225    15.886     0.200
     4.231    16.055     0.200
     4.648    18.345     0.200
     4.580    16.789     0.200
     4.754    16.852     0.200
     4.914    18.085     0.200
     5.062    17.086     0.200
     5.264    18.904     0.200
     5.737    19.224     0.200
     5.737    16.355     0.200
     5.805    19.891     0.200
     6.070    20.990     0.200
     6.320    20.256     0.200
     6.227    20.667     0.200
     6.233    19.818     0.200
     6.631    21.464     0.200
     6.691    21.951     0.200
     7.142    22.988     0.200
     7.142    21.949     0.200
     7.221    23.466     0.200
     7.221    21.796     0.200
     7.729    23.938     0.200
     8.852    25.238     0.200
     8.952    26.764     0.200
     9.071    26.229     0.200
     9.182    25.597     0.200
     9.182    25.377     0.200
     9.300    26.701     0.200
     9.960    25.341     0.200
     9.953    28.470     0.200
     9.979    28.164     0.200
    10.178    30.020     0.200
    10.309    29.224     0.200
    10.757    27.852     0.200
    10.757    26.372     0.200
    10.925    26.960     0.200
    11.721    31.454     0.200
    12.060    29.125     0.200
    12.525    30.087     0.200
    12.603    31.279     0.200
    12.603    31.925     0.200
    12.603    30.859     0.200
    12.603    31.562     0.200
    12.603    31.119     0.200
    13.057    32.831     0.200
    13.411    32.421     0.200
    14.033    33.162     0.200
    14.274    33.926     0.200
    14.274    34.566     0.200
    14.389    35.619     0.200
    14.767    33.817     0.200
    14.767    33.606     0.200
    14.767    34.737     0.200
    14.794    38.388     0.200
    14.876    38.801     0.200
    14.876    37.002     0.200
    14.876    40.733     0.200
    15.036    38.049     0.200
    15.167    40.858     0.200
    15.517    38.836     0.200
    15.767    39.295     0.200
    15.786    39.576     0.200
    15.875    36.280     0.200
    15.903    38.663     0.200
    16.092    36.579     0.200
    16.140    36.983     0.200
    16.140    35.968     0.200
    16.386    40.909     0.200
    16.886    39.570     0.200
    17.444    37.558     0.200
    17.444    40.257     0.200
    17.474    40.689     0.200
    17.679    39.014     0.200
    17.702    40.955     0.200
    17.958    38.561     0.200
    18.010    41.276     0.200
    18.158    40.986     0.200
    18.177    40.552     0.200
    18.177    39.822     0.200
    19.528    41.437     0.200
    19.522    41.817     0.200
    20.134    41.737     0.200
    20.567    41.938     0.200
     2.310    12.744     0.200
     2.634    13.371     0.200
     2.840    14.507     0.200
     3.061    14.480     0.200
     3.298    15.022     0.200
     3.346    13.960     0.200
     3.599    15.504     0.200
     3.599    14.664     0.200
     3.884    16.684     0.200
     3.995    16.381     0.200
     3.995    16.881     0.200
     4.056    17.074     0.200
     4.178    16.074     0.200
     4.185    16.264     0.200
     4.491    17.893     0.200
     4.525    17.092     0.200
     4.551    18.297     0.200
     4.695    17.412     0.200
     4.717    17.259     0.200
     4.818    17.807     0.200
     5.251    18.232     0.200
     5.664    18.904     0.200
     5.664    20.174     0.200
     5.725    20.391     0.200
     5.798    17.705     0.200
     5.798    20.339     0.200
     6.204    21.101     0.200
     6.234    21.931     0.200
     6.265    20.487     0.200
     6.265    20.597     0.200
     6.427    16.167     0.200
     6.593    21.689     0.200
     6.675    22.305     0.200
     7.086    21.244     0.200
     7.218    23.668     0.200
     7.218    24.918     0.200
     8.852    24.842     0.200
     9.191    25.361     0.200
     9.949    27.059     0.200
    10.594    27.696     0.200
    10.733    28.833     0.200
    10.733    27.835     0.200
    10.820    30.057     0.200
    12.059    29.692     0.200
    12.599    30.122     0.200
    12.599    31.739     0.200
    12.599    30.678     0.200
    13.412    33.489     0.200
    14.688    35.707     0.200
    14.688    36.625     0.200
    14.688    35.816     0.200
    14.942    37.592     0.200
    15.424    38.996     0.200
    16.057    35.800     0.200
    16.096    37.385     0.200
    19.324    41.871     0.200
    20.890    40.875     0.200
     2.369    12.997     0.200
     2.706    13.764     0.200
     3.131    13.801     0.200
     4.074    16.907     0.200
     4.125    17.203     0.200
     4.555    17.391     0.200
     4.610    18.273     0.200
     4.614    17.100     0.200
     4.802    17.805     0.200
     6.284    21.108     0.200
     6.752    22.749     0.200
     7.030    22.441     0.200
    12.532    31.388     0.200
    12.532    31.271     0.200
     2.525    12.626     0.200
     2.697    13.126     0.200
     2.697    14.018     0.200
     3.121    14.975     0.200
     3.357    14.816     0.200
     4.115    17.279     0.200
     4.542    17.398     0.200
     5.728    19.948     0.200
     6.342    20.783     0.200
    12.506    30.350     0.200
    12.506    32.178     0.200
     2.361    13.019     0.200
     2.677    13.326     0.200
     2.893    14.536     0.200
     3.213    14.171     0.200
     3.571    15.193     0.200
     3.571    15.854     0.200
     4.034    16.294     0.200
     4.034    16.626     0.200
     4.101    16.813     0.200
     4.183    16.588     0.200
     4.189    15.983     0.200
     4.539    17.697     0.200
     4.535    16.549     0.200
     4.601    17.733     0.200
     4.715    17.144     0.200
     4.865    18.067     0.200
     5.072    17.783     0.200
     5.072    17.592     0.200
     5.235    18.181     0.200
     5.707    20.067     0.200
     5.707    19.829     0.200
     5.779    20.129     0.200
     6.194    20.990     0.200
     6.227    20.698     0.200
     6.227    20.448     0.200
     6.269    21.173     0.200
     6.591    21.826     0.200
     6.661    22.138     0.200
     7.118    22.357     0.200
     7.164    24.364     0.200
     7.164    22.833     0.200
    12.624    30.753     0.200
    12.624    32.187     0.200
    16.112    35.667     0.200
     2.347    12.959     0.200
     2.530    12.817     0.200
     2.703    13.597     0.200
     3.115    14.891     0.200
     3.332    14.556     0.200
     3.696    15.612     0.200
     3.922    16.669     0.200
     4.063    16.720     0.200
     4.108    16.993     0.200
     4.289    16.987     0.200
     4.535    17.925     0.200
     4.587    16.937     0.200
     4.627    16.942     0.200
     4.822    17.970     0.200
     5.182    18.064     0.200
     5.700    16.041     0.200
     5.722    20.063     0.200
     5.822    19.998     0.200
     6.350    20.740     0.200
     6.309    21.009     0.200
     6.780    22.524     0.200
     6.994    21.353     0.200
     6.994    22.275     0.200
     8.751    24.622     0.200
     9.088    25.285     0.200
     9.852    26.615     0.200
    10.496    27.713     0.200
    10.643    27.961     0.200
    10.643    28.164     0.200
    10.823    27.436     0.200
    11.959    29.511     0.200
    12.431    30.182     0.200
    12.500    32.715     0.200
    12.500    31.231     0.200
    12.500    31.793     0.200
    12.500    31.660     0.200
    13.937    33.043     0.200
    14.656    37.923     0.200
    14.960    34.084     0.200
    14.854    38.987     0.200
    14.997    38.319     0.200
    15.994    35.982     0.200
    16.032    36.175     0.200
     2.269    12.878     0.200
     2.583    13.515     0.200
     3.012    14.906     0.200
     3.176    14.394     0.200
     3.249    15.447     0.200
     3.841    16.835     0.200
     3.940    15.873     0.200
     4.007    16.699     0.200
     4.126    15.911     0.200
     4.446    17.373     0.200
     4.465    16.953     0.200
     4.509    18.041     0.200
     4.659    16.586     0.200
     5.200    18.375     0.200
     5.685    19.519     0.200
     5.750    20.453     0.200
     6.048    20.577     0.200
     6.151    20.680     0.200
     6.624    21.359     0.200
    10.768    27.816     0.200
    12.643    31.885     0.200
    14.681    34.001     0.200
    16.046    36.178     0.200
    16.046    35.630     0.200
     2.297    12.780     0.200
     2.616    13.459     0.200
     2.586    13.112     0.200
     3.045    14.459     0.200
     3.870    16.327     0.200
     3.976    16.893     0.200
     4.039    17.353     0.200
     4.161    16.334     0.200
     4.476    17.950     0.200
     4.501    17.062     0.200
     4.537    17.387     0.200
     4.671    17.382     0.200
     4.693    17.127     0.200
     6.068    20.580     0.200
     7.631    23.641     0.200
    10.750    28.196     0.200
    14.690    33.685     0.200
    16.057    38.722     0.200
     2.328    13.055     0.200
     2.660    13.172     0.200
     2.853    13.984     0.200
     3.086    14.401     0.200
     3.389    14.365     0.200
     3.641    15.131     0.200
     3.641    15.534     0.200
     3.902    16.381     0.200
     4.027    15.830     0.200
     4.027    16.307     0.200
     4.080    17.402     0.200
     4.224    15.704     0.200
     4.512    17.866     0.200
     4.568    18.855     0.200
     4.570    17.381     0.200
     4.763    17.235     0.200
     4.841    18.107     0.200
     5.146    17.810     0.200
     5.296    18.020     0.200
     5.691    19.942     0.200
     5.843    20.433     0.200
     6.269    21.575     0.200
     6.250    21.177     0.200
     6.301    20.985     0.200
     6.301    20.704     0.200
     6.639    22.595     0.200
     7.232    23.176     0.200
    16.048    37.943     0.200
     2.353    12.919     0.200
     2.507    12.922     0.200
     2.678    13.521     0.200
     2.692    13.359     0.200
     2.874    14.953     0.200
     3.117    14.803     0.200
     3.309    14.358     0.200
     3.353    14.646     0.200
     3.671    15.136     0.200
     3.928    16.939     0.200
     4.061    16.083     0.200
     4.061    15.873     0.200
     4.264    16.591     0.200
     4.271    16.332     0.200
     4.594    18.080     0.200
     4.781    17.481     0.200
     4.803    17.332     0.200
     4.869    17.852     0.200
     5.158    19.193     0.200
     5.332    18.658     0.200
     5.714    16.377     0.200
     5.723    19.988     0.200
     5.723    20.957     0.200
     5.797    19.927     0.200
     5.877    19.891     0.200
     6.155    20.646     0.200
     6.325    21.079     0.200
     6.288    20.899     0.200
     6.305    20.807     0.200
     6.501    16.630     0.200
     6.757    22.624     0.200
     7.019    22.036     0.200
     9.877    26.198     0.200
    10.521    26.157     0.200
    10.668    27.528     0.200
    10.847    27.588     0.200
    11.983    28.635     0.200
    12.454    30.217     0.200
    12.524    30.311     0.200
    12.524    31.710     0.200
    13.961    33.427     0.200
    14.998    37.656     0.200
    16.018    37.209     0.200
    16.051    35.338     0.200
     2.388    13.152     0.200
     2.517    12.747     0.200
     2.682    13.415     0.200
     2.727    13.692     0.200
     2.908    14.337     0.200
     3.321    14.655     0.200
     3.388    15.676     0.200
     3.430    14.692     0.200
     3.674    15.338     0.200
     3.674    15.608     0.200
     4.095    16.922     0.200
     4.146    16.836     0.200
     4.286    16.204     0.200
     4.293    16.315     0.200
     4.574    18.236     0.200
     4.628    18.276     0.200
     4.635    17.222     0.200
     4.822    17.448     0.200
     4.904    18.981     0.200
     5.143    18.000     0.200
     5.343    18.367     0.200
     5.758    20.449     0.200
     5.800    19.936     0.200
     5.886    19.629     0.200
     6.156    20.777     0.200
     6.302    21.372     0.200
     6.338    21.796     0.200
     6.319    21.068     0.200
     6.319    21.209     0.200
     6.698    22.444     0.200
     6.769    21.826     0.200
     7.020    21.993     0.200
     7.211    24.300     0.200
    10.671    27.271     0.200
    12.519    31.308     0.200
    12.519    32.023     0.200
    12.519    32.144     0.200
    14.701    34.020     0.200
    16.077    35.446     0.200
    16.077    35.915     0.200
     2.346    12.830     0.200
     2.689    13.531     0.200
     2.866    14.187     0.200
     3.113    14.983     0.200
     3.078    13.687     0.200
     3.323    14.533     0.200
     3.438    14.492     0.200
     3.687    15.904     0.200
     3.921    16.651     0.200
     4.060    16.727     0.200
     4.060    16.867     0.200
     4.107    16.787     0.200
     4.274    17.002     0.200
     4.534    18.505     0.200
     4.587    18.385     0.200
     4.814    17.433     0.200
     4.864    18.200     0.200
     5.175    17.822     0.200
     5.175    18.080     0.200
     5.720    20.550     0.200
     5.813    20.274     0.200
     5.892    20.352     0.200
     6.171    20.496     0.200
     6.306    21.593     0.200
     6.301    20.782     0.200
     6.341    21.011     0.200
     6.341    21.168     0.200
     6.517    16.357     0.200
     6.689    22.066     0.200
     6.771    21.696     0.200
     7.002    21.742     0.200
     7.250    22.810     0.200
     7.250    23.927     0.200
    10.652    27.172     0.200
    12.509    30.103     0.200
    12.509    30.212     0.200
    12.509    30.728     0.200
    14.662    33.103     0.200
    14.969    34.919     0.200
    16.037    35.892     0.200
    16.037    35.392     0.200
     2.280    13.359     0.200
     2.378    12.313     0.200
     2.416    13.172     0.200
     2.602    13.498     0.200
     2.599    13.628     0.200
     2.811    14.499     0.200
     2.752    13.843     0.200
     3.030    14.506     0.200
     3.266    15.448     0.200
     3.337    14.624     0.200
     3.593    15.926     0.200
     3.593    15.437     0.200
     3.853    17.201     0.200
     3.964    16.607     0.200
     3.964    16.857     0.200
     4.024    17.402     0.200
     4.156    16.503     0.200
     4.163    16.481     0.200
     4.460    18.015     0.200
     4.520    17.989     0.200
     4.520    17.004     0.200
     4.501    17.136     0.200
     4.672    17.442     0.200
     4.697    17.650     0.200
     4.787    17.371     0.200
     5.132    17.676     0.200
     5.238    18.941     0.200
     5.632    20.532     0.200
     5.720    20.114     0.200
     5.787    20.425     0.200
     6.082    21.182     0.200
     6.203    20.882     0.200
     6.189    21.042     0.200
     6.267    20.827     0.200
     6.267    20.956     0.200
     6.572    21.823     0.200
     6.661    22.623     0.200
     7.089    22.053     0.200
     7.089    22.234     0.200
     6.993    22.660     0.200
     7.237    23.612     0.200
     7.237    22.852     0.200
     7.624    24.688     0.200
     8.861    26.190     0.200
     9.204    27.004     0.200
     9.955    27.424     0.200
     9.859    28.613     0.200
    10.600    28.026     0.200
    10.734    27.541     0.200
    10.734    27.991     0.200
    10.734    28.062     0.200
    10.933    29.139     0.200
    12.607    31.937     0.200
    12.607    32.783     0.200
    12.607    32.143     0.200
    12.607    33.093     0.200
    13.422    34.433     0.200
    14.051    34.291     0.200
    14.668    37.402     0.200
    14.668    33.407     0.200
    14.668    36.942     0.200
    14.755    40.545     0.200
    14.910    38.300     0.200
    15.619    34.388     0.200
    16.035    36.130     0.200
    16.107    36.038     0.200
    17.257    41.977     0.200
    17.318    39.563     0.200
    18.152    39.711     0.200
    18.152    39.541     0.200
    19.074    43.273     0.200
    19.587    42.585     0.200
    20.104    42.447     0.200
    20.435    42.190     0.200
    20.977    42.563     0.200
     2.325    13.099     0.200
     2.487    12.811     0.200
     2.663    13.757     0.200
     2.662    13.876     0.200
     2.849    14.506     0.200
     2.830    13.619     0.200
     3.087    14.313     0.200
     3.288    14.171     0.200
     3.323    15.157     0.200
     3.405    14.601     0.200
     3.656    15.165     0.200
     3.656    15.548     0.200
     3.900    16.824     0.200
     4.030    16.512     0.200
     4.030    16.160     0.200
     4.081    16.918     0.200
     4.236    16.670     0.200
     4.243    15.815     0.200
     4.511    18.197     0.200
     4.566    18.699     0.200
     4.582    17.265     0.200
     4.776    17.299     0.200
     4.840    18.094     0.200
     5.160    18.018     0.200
     5.160    18.158     0.200
     5.311    18.758     0.200
     5.693    19.403     0.200
     5.782    19.753     0.200
     5.858    20.371     0.200
     6.142    20.858     0.200
     6.273    20.705     0.200
     6.317    20.922     0.200
     6.652    21.785     0.200
     7.031    20.563     0.200
     7.245    24.246     0.200
    10.679    27.240     0.200
    12.540    30.288     0.200
    12.540    31.702     0.200
    12.540    30.803     0.200
    14.821    37.550     0.200
    15.004    35.139     0.200
    16.037    36.584     0.200
    16.037    35.131     0.200
    17.375    41.129     0.200
    18.999    42.421     0.200
    19.511    42.841     0.200
    20.359    40.243     0.200
     2.238    12.910     0.200
     2.322    12.128     0.200
     2.373    12.532     0.200
     2.552    13.046     0.200
     2.564    13.200     0.200
     2.774    14.327     0.200
     2.703    13.279     0.200
     2.981    14.039     0.200
     3.217    15.680     0.200
     3.168    13.752     0.200
     3.297    14.148     0.200
     3.559    15.092     0.200
     3.559    14.832     0.200
     3.910    16.193     0.200
     3.910    16.424     0.200
     3.975    16.733     0.200
     4.101    15.755     0.200
     4.108    15.881     0.200
     4.415    17.507     0.200
     4.477    16.849     0.200
     4.445    16.755     0.200
     4.616    17.451     0.200
     4.644    17.126     0.200
     4.740    18.601     0.200
     5.125    17.711     0.200
     5.125    18.591     0.200
     5.193    17.626     0.200
     5.582    19.684     0.200
     5.582    20.715     0.200
     5.685    19.681     0.200
     5.745    19.979     0.200
     5.882    17.298     0.200
     6.050    20.619     0.200
     6.148    20.270     0.200
     6.140    21.267     0.200
     6.244    20.362     0.200
     6.244    20.772     0.200
     6.520    21.543     0.200
     6.616    22.119     0.200
     7.121    22.389     0.200
     7.119    21.853     0.200
     7.245    25.225     0.200
     7.809    24.239     0.200
     8.119    24.471     0.200
     8.902    24.290     0.200
     9.248    25.409     0.200
     9.991    26.518     0.200
    10.637    27.582     0.200
    10.764    27.758     0.200
    10.764    27.894     0.200
    10.873    29.855     0.200
    12.109    29.381     0.200
    12.645    31.602     0.200
    12.645    31.288     0.200
    12.645    31.396     0.200
    12.645    32.918     0.200
    12.645    30.388     0.200
    13.462    34.791     0.200
    14.094    34.213     0.200
    14.658    34.078     0.200
    14.658    34.258     0.200
    14.861    37.012     0.200
    16.021    36.011     0.200
    16.021    35.091     0.200
    17.269    40.597     0.200
     2.267    12.865     0.200
     2.399    12.629     0.200
     2.586    13.246     0.200
     2.585    13.358     0.200
     2.800    14.544     0.200
     2.734    13.320     0.200
     3.014    14.447     0.200
     3.321    14.270     0.200
     3.579    15.054     0.200
     3.579    15.194     0.200
     3.840    16.615     0.200
     3.946    15.571     0.200
     3.946    16.601     0.200
     4.009    16.841     0.200
     4.136    16.087     0.200
     4.143    15.874     0.200
     4.446    17.139     0.200
     4.507    15.973     0.200
     4.481    16.832     0.200
     4.652    17.436     0.200
     4.677    16.938     0.200
     4.772    18.281     0.200
     5.045    19.298     0.200
     5.126    16.995     0.200
     5.220    18.204     0.200
     5.616    20.081     0.200
     5.705    19.642     0.200
     6.069    20.602     0.200
     6.185    21.437     0.200
     6.170    20.918     0.200
     6.256    20.603     0.200
     6.553    22.112     0.200
     7.151    22.946     0.200
     7.237    21.750     0.200
     7.844    25.446     0.200
     8.156    24.739     0.200
    10.747    28.326     0.200
    11.660    33.903     0.200
    12.622    31.012     0.200
    12.622    31.387     0.200
    14.668    34.733     0.200
    16.033    35.539     0.200
    16.033    36.955     0.200
     2.301    12.927     0.200
     2.321    12.606     0.200
     2.350    12.662     0.200
     2.501    13.103     0.200
     2.600    13.141     0.200
     2.665    13.091     0.200
     2.843    14.331     0.200
     3.032    14.402     0.200
     3.121    13.861     0.200
     3.240    14.280     0.200
     3.268    15.342     0.200
     3.495    14.702     0.200
     3.871    16.813     0.200
     3.948    16.499     0.200
     4.027    16.594     0.200
     4.081    15.652     0.200
     4.087    15.585     0.200
     4.472    17.497     0.200
     4.539    18.310     0.200
     4.600    17.210     0.200
     4.615    16.827     0.200
     4.795    18.824     0.200
     5.042    17.640     0.200
     5.144    17.754     0.200
     5.621    19.390     0.200
     5.628    20.705     0.200
     5.628    20.103     0.200
     5.692    19.562     0.200
     5.983    20.663     0.200
     6.168    20.600     0.200
     6.168    20.862     0.200
     6.178    21.592     0.200
     6.491    21.691     0.200
     6.569    22.028     0.200
     6.905    22.811     0.200
     7.086    21.946     0.200
     7.160    22.814     0.200
     7.188    22.428     0.200
     8.115    24.587     0.200
    10.834    27.522     0.200
    12.704    31.692     0.200
    12.704    31.251     0.200
    14.742    35.683     0.200
    16.105    36.520     0.200
    16.105    35.575     0.200
    17.319    39.224     0.200
    18.058    39.516     0.200
     2.342    12.987     0.200
     2.511    12.717     0.200
     2.684    13.292     0.200
     2.683    13.509     0.200
     2.855    13.396     0.200
     3.107    14.057     0.200
     3.312    14.864     0.200
     3.343    15.003     0.200
     3.428    14.317     0.200
     3.677    15.204     0.200
     3.917    16.707     0.200
     4.053    15.923     0.200
     4.101    16.962     0.200
     4.271    16.480     0.200
     4.529    18.169     0.200
     4.583    19.712     0.200
     4.609    17.431     0.200
     4.803    17.766     0.200
     5.803    20.394     0.200
     5.881    20.383     0.200
     6.290    20.711     0.200
     6.333    20.612     0.200
    12.518    32.120     0.200
     2.302    12.922     0.200
     2.382    11.999     0.200
     2.384    12.768     0.200
     2.564    13.172     0.200
     2.726    13.375     0.200
     2.837    14.242     0.200
     3.046    13.951     0.200
     3.184    13.731     0.200
     3.303    14.343     0.200
     3.558    15.073     0.200
     3.558    15.263     0.200
     3.973    16.530     0.200
     3.973    16.240     0.200
     4.040    17.044     0.200
     4.138    15.906     0.200
     4.144    15.928     0.200
     4.486    16.939     0.200
     4.542    17.784     0.200
     4.655    16.868     0.200
     4.675    17.337     0.200
     4.805    18.190     0.200
     5.091    17.149     0.200
     5.207    18.421     0.200
     5.646    20.103     0.200
     5.684    19.561     0.200
     5.755    20.026     0.200
     6.208    20.512     0.200
     6.228    20.813     0.200
     6.551    21.596     0.200
     6.896    22.611     0.200
     6.966    22.094     0.200
     6.999    21.920     0.200
     7.147    22.702     0.200
     7.198    21.523     0.200
     7.621    23.952     0.200
     7.846    23.235     0.200
     8.165    24.605     0.200
    10.772    27.529     0.200
    12.641    31.743     0.200
    14.763    38.948     0.200
    16.073    37.251     0.200
    16.073    38.276     0.200
    17.334    39.309     0.200
    18.122    39.171     0.200
    19.355    41.998     0.200
    19.563    41.627     0.200
    20.036    41.847     0.200
     2.317    12.867     0.200
     2.444    11.686     0.200
     2.489    12.658     0.200
     2.654    13.431     0.200
     2.666    13.387     0.200
     2.840    14.250     0.200
     2.830    13.280     0.200
     3.079    13.572     0.200
     3.315    14.914     0.200
     3.289    14.123     0.200
     3.407    14.340     0.200
     3.660    14.813     0.200
     3.892    16.490     0.200
     4.023    16.058     0.200
     4.023    16.247     0.200
     4.073    16.773     0.200
     4.235    16.095     0.200
     4.242    15.904     0.200
     4.502    17.461     0.200
     4.558    15.567     0.200
     4.579    16.565     0.200
     4.750    17.467     0.200
     4.775    17.074     0.200
     4.832    17.893     0.200
     5.167    17.253     0.200
     5.312    18.311     0.200
     5.685    19.759     0.200
     5.748    16.927     0.200
     5.860    20.018     0.200
     6.146    20.477     0.200
     6.267    20.068     0.200
     6.265    21.088     0.200
     6.322    20.325     0.200
     6.322    20.735     0.200
     6.651    21.826     0.200
     7.026    21.096     0.200
     7.026    21.535     0.200
     7.070    22.599     0.200
     7.094    22.021     0.200
     7.249    22.813     0.200
     7.253    23.264     0.200
     7.942    24.796     0.200
     8.253    24.686     0.200
     8.278    24.699     0.200
     8.790    24.628     0.200
     9.130    25.347     0.200
     9.888    26.706     0.200
    10.533    26.747     0.200
    10.674    27.312     0.200
    10.674    27.646     0.200
    10.862    26.954     0.200
    11.683    31.764     0.200
    12.537    29.212     0.200
    12.537    31.102     0.200
    12.537    29.356     0.200
    12.537    32.022     0.200
    13.978    33.583     0.200
    14.222    34.130     0.200
    14.330    37.479     0.200
    14.656    34.269     0.200
    14.814    38.022     0.200
    14.814    37.277     0.200
    14.960    37.794     0.200
    15.568    33.829     0.200
    16.028    34.429     0.200
    16.028    35.923     0.200
    16.034    37.162     0.200
    17.367    36.984     0.200
    18.143    40.179     0.200
    18.226    39.091     0.200
    18.226    38.292     0.200
     2.451    12.539     0.200
     2.497    13.300     0.200
     2.674    13.635     0.200
     2.660    13.897     0.200
     2.838    13.715     0.200
     2.843    14.576     0.200
     3.085    14.738     0.200
     3.297    14.461     0.200
     3.321    14.981     0.200
     3.415    14.983     0.200
     3.667    15.440     0.200
     3.667    15.847     0.200
     3.896    16.574     0.200
     4.029    16.618     0.200
     4.078    17.641     0.200
     4.243    16.170     0.200
     4.250    16.041     0.200
     4.507    18.136     0.200
     4.562    17.600     0.200
     4.588    17.298     0.200
     4.759    16.901     0.200
     4.784    17.609     0.200
     4.837    18.528     0.200
     5.171    18.093     0.200
     5.320    18.648     0.200
     5.691    19.728     0.200
     5.691    20.283     0.200
     5.739    21.317     0.200
     5.739    21.450     0.200
     5.739    18.325     0.200
     5.739    20.661     0.200
     5.793    20.036     0.200
     5.816    22.005     0.200
     5.868    20.460     0.200
     6.002    20.094     0.200
     6.153    20.733     0.200
     6.274    21.124     0.200
     6.274    21.143     0.200
     6.328    21.089     0.200
     6.660    21.838     0.200
     6.745    22.726     0.200
     6.746    22.206     0.200
     6.968    22.724     0.200
     7.020    21.549     0.200
     7.020    21.846     0.200
     7.020    21.417     0.200
     7.020    21.268     0.200
     7.026    22.741     0.200
     7.078    21.937     0.200
     7.102    22.658     0.200
     7.255    23.480     0.200
     7.257    22.747     0.200
     7.257    23.068     0.200
     7.520    23.281     0.200
     7.704    23.636     0.200
     7.816    23.415     0.200
     7.951    25.267     0.200
     8.106    24.845     0.200
     8.133    24.529     0.200
     8.262    24.725     0.200
     8.286    25.343     0.200
     8.314    25.121     0.200
     8.523    25.179     0.200
     8.616    26.094     0.200
     8.749    26.234     0.200
     8.783    25.372     0.200
     8.829    26.104     0.200
     8.943    26.687     0.200
     9.122    26.056     0.200
     9.156    25.614     0.200
     9.156    27.293     0.200
     9.311    25.885     0.200
     9.311    29.494     0.200
     9.311    29.604     0.200
     9.470    28.324     0.200
     9.538    28.930     0.200
     9.554    27.939     0.200
     9.554    28.439     0.200
     9.637    27.002     0.200
     9.717    26.656     0.200
     9.881    26.194     0.200
    10.011    30.068     0.200
    10.011    29.185     0.200
    10.052    29.890     0.200
    10.052    28.984     0.200
    10.178    28.360     0.200
    10.285    28.908     0.200
    10.285    29.127     0.200
    10.344    30.786     0.200
    10.525    26.965     0.200
    10.597    30.312     0.200
    10.603    30.547     0.200
    10.603    28.555     0.200
    10.607    31.179     0.200
    10.668    27.868     0.200
    10.668    27.618     0.200
    10.854    26.697     0.200
    10.871    32.271     0.200
    10.919    29.151     0.200
    10.956    28.485     0.200
    10.956    29.125     0.200
    10.956    28.110     0.200
    10.956    31.360     0.200
    10.956    29.000     0.200
    10.956    30.399     0.200
    10.956    28.368     0.200
    10.992    31.633     0.200
    11.061    28.265     0.200
    11.061    28.093     0.200
    11.092    31.517     0.200
    11.145    31.617     0.200
    11.145    32.344     0.200
    11.248    32.201     0.200
    11.388    32.180     0.200
    11.415    31.822     0.200
    11.415    31.026     0.200
    11.562    32.566     0.200
    11.562    31.206     0.200
    11.607    32.965     0.200
    11.620    31.770     0.200
    11.640    29.268     0.200
    11.675    31.196     0.200
    11.813    32.169     0.200
    11.814    33.391     0.200
    11.814    30.962     0.200
    11.894    33.342     0.200
    11.933    32.822     0.200
    11.933    32.369     0.200
    11.990    29.487     0.200
    12.047    33.552     0.200
    12.115    33.488     0.200
    12.101    33.591     0.200
    12.118    30.157     0.200
    12.299    33.245     0.200
    12.328    31.164     0.200
    12.321    33.556     0.200
    12.386    33.025     0.200
    12.455    33.894     0.200
    12.464    30.071     0.200
    12.530    30.728     0.200
    12.530    30.619     0.200
    12.530    30.986     0.200
    12.530    31.307     0.200
    12.530    30.861     0.200
    12.530    32.166     0.200
    12.578    33.466     0.200
    12.634    34.442     0.200
    12.698    30.131     0.200
    12.748    33.665     0.200
    12.816    31.557     0.200
    12.877    33.621     0.200
    12.894    31.317     0.200
    12.924    35.119     0.200
    13.016    33.465     0.200
    13.016    34.826     0.200
    13.064    35.585     0.200
    13.157    34.744     0.200
    13.161    34.515     0.200
    13.184    34.084     0.200
    13.196    35.259     0.200
    13.343    33.025     0.200
    13.360    31.633     0.200
    13.336    34.803     0.200
    13.372    34.928     0.200
    13.391    36.090     0.200
    13.393    36.718     0.200
    13.412    32.954     0.200
    13.430    34.107     0.200
    13.666    38.062     0.200
    13.679    33.914     0.200
    13.730    37.607     0.200
    13.749    37.389     0.200
    13.790    37.419     0.200
    13.824    33.928     0.200
    13.830    35.746     0.200
    13.853    34.399     0.200
    13.906    34.966     0.200
    13.911    35.465     0.200
    13.970    33.307     0.200
    14.008    36.066     0.200
    14.044    33.042     0.200
    14.113    36.828     0.200
    14.158    36.219     0.200
    14.224    37.018     0.200
    14.382    34.627     0.200
    14.337    38.486     0.200
    14.388    33.837     0.200
    14.655    34.760     0.200
    14.655    32.143     0.200
    14.655    36.057     0.200
    14.663    39.465     0.200
    14.721    37.745     0.200
    14.820    40.696     0.200
    14.820    36.954     0.200
    14.820    39.376     0.200
    14.820    39.633     0.200
    14.820    39.883     0.200
    14.820    40.329     0.200
    14.820    40.008     0.200
    14.937    34.918     0.200
    14.995    35.027     0.200
    14.995    35.426     0.200
    14.966    37.042     0.200
    15.131    40.175     0.200
    15.202    35.095     0.200
    15.451    37.799     0.200
    15.562    34.211     0.200
    15.574    36.973     0.200
    15.713    36.723     0.200
    15.725    38.096     0.200
    15.754    39.198     0.200
    15.844    38.072     0.200
    15.844    37.494     0.200
    15.844    40.397     0.200
    15.899    39.929     0.200
    16.216    36.621     0.200
    16.027    36.002     0.200
    16.027    35.712     0.200
    16.028    35.598     0.200
    16.185    37.236     0.200
    16.202    38.417     0.200
    16.317    41.224     0.200
    16.555    41.088     0.200
    16.814    39.615     0.200
    16.926    40.572     0.200
    17.155    38.046     0.200
    17.155    41.632     0.200
    17.372    39.142     0.200
    17.372    39.306     0.200
    17.491    39.534     0.200
    17.534    39.912     0.200
    17.558    41.490     0.200
    17.607    39.157     0.200
    17.607    39.352     0.200
    17.607    39.743     0.200
    17.607    38.016     0.200
    17.607    40.157     0.200
    17.634    41.852     0.200
    17.880    39.277     0.200
    17.960    42.463     0.200
    18.053    40.982     0.200
    18.151    39.257     0.200
    18.191    38.899     0.200
    18.191    39.431     0.200
    18.234    39.368     0.200
    18.234    38.821     0.200
    18.234    39.211     0.200
    18.234    39.610     0.200
    18.263    41.410     0.200
    18.997    40.444     0.200
    19.382    43.107     0.200
    19.486    43.134     0.200
    19.486    43.282     0.200
    20.117    40.544     0.200
    20.399    40.789     0.200
     2.249    12.825     0.200
     2.295    12.094     0.200
     2.544    13.079     0.200
     2.633    12.947     0.200
     2.977    14.035     0.200
     3.213    15.575     0.200
     3.222    13.676     0.200
     3.483    15.526     0.200
     3.892    15.950     0.200
     3.892    16.880     0.200
     3.971    16.927     0.200
     4.039    16.202     0.200
     4.046    15.752     0.200
     4.388    16.268     0.200
     4.418    17.014     0.200
     4.486    18.042     0.200
     4.557    17.196     0.200
     4.578    16.644     0.200
     5.060    16.609     0.200
     5.119    18.230     0.200
     5.572    19.842     0.200
     5.609    19.914     0.200
     5.670    19.098     0.200
     5.974    20.452     0.200
     5.933    19.140     0.200
     6.069    20.645     0.200
     6.169    20.973     0.200
     6.169    19.504     0.200
     6.543    21.617     0.200
     6.900    22.047     0.200
     7.051    23.623     0.200
     7.192    21.345     0.200
     7.196    22.388     0.200
     7.196    23.158     0.200
     7.527    23.128     0.200
     7.748    25.122     0.200
     8.977    26.078     0.200
     9.322    26.163     0.200
    10.067    27.358     0.200
    10.713    27.431     0.200
    10.839    28.081     0.200
    10.839    28.107     0.200
    11.048    27.502     0.200
    12.185    31.457     0.200
    12.721    31.814     0.200
    12.721    31.680     0.200
    12.721    31.189     0.200
    12.721    32.369     0.200
    13.537    34.578     0.200
    14.168    33.729     0.200
    14.710    35.185     0.200
    14.710    36.015     0.200
    14.710    35.295     0.200
    14.853    36.994     0.200
    16.224    39.423     0.200
    17.273    40.656     0.200
     2.372    12.768     0.200
     2.520    12.341     0.200
     2.688    13.276     0.200
     3.137    14.734     0.200
     3.434    14.973     0.200
     3.373    15.278     0.200
     3.693    15.652     0.200
     3.680    15.297     0.200
     3.947    17.586     0.200
     4.131    17.040     0.200
     4.559    17.745     0.200
     4.820    17.899     0.200
     5.744    20.815     0.200
     6.163    21.021     0.200
     6.329    20.685     0.200
     6.771    22.329     0.200
     2.256    12.893     0.200
     2.305    12.123     0.200
     2.307    12.704     0.200
     2.495    13.106     0.200
     2.643    13.083     0.200
     2.799    14.379     0.200
     2.986    13.884     0.200
     3.104    13.698     0.200
     3.222    14.625     0.200
     3.229    14.140     0.200
     3.490    15.546     0.200
     3.825    16.984     0.200
     3.902    16.289     0.200
     3.902    15.774     0.200
     3.980    16.971     0.200
     4.050    15.602     0.200
     4.057    15.781     0.200
     4.426    17.674     0.200
     4.494    16.882     0.200
     4.588    16.780     0.200
     4.748    18.234     0.200
     5.062    17.260     0.200
     5.062    17.854     0.200
     5.128    17.984     0.200
     5.582    19.485     0.200
     5.582    19.586     0.200
     5.616    19.087     0.200
     5.679    20.056     0.200
     5.922    20.310     0.200
     5.981    20.431     0.200
     6.079    20.586     0.200
     6.133    20.282     0.200
     6.174    20.274     0.200
     6.174    20.524     0.200
     6.464    21.500     0.200
     6.552    21.767     0.200
     6.818    22.057     0.200
     6.883    22.405     0.200
     7.061    22.462     0.200
     7.190    21.512     0.200
     7.190    22.676     0.200
     8.078    24.455     0.200
     8.119    24.275     0.200
     8.123    25.132     0.200
     8.764    25.921     0.200
     9.056    26.344     0.200
     9.056    26.219     0.200
     9.765    28.016     0.200
    10.833    27.888     0.200
    11.145    29.161     0.200
    14.712    35.502     0.200
    14.692    38.123     0.200
    14.692    38.615     0.200
    14.863    37.428     0.200
    15.578    39.949     0.200
    16.072    36.117     0.200
    16.409    40.342     0.200
    17.273    38.328     0.200
    17.508    38.241     0.200
    18.042    39.524     0.200
    18.042    38.883     0.200
    18.195    41.794     0.200
    18.847    42.837     0.200
     2.316    13.078     0.200
     2.635    13.364     0.200
     2.750    13.011     0.200
     3.063    14.667     0.200
     3.207    14.586     0.200
     3.324    14.618     0.200
     3.300    15.603     0.200
     3.577    15.067     0.200
     3.610    15.288     0.200
     3.889    16.725     0.200
     3.993    16.508     0.200
     4.058    17.162     0.200
     4.169    16.054     0.200
     4.495    17.954     0.200
     4.556    17.513     0.200
     2.225    12.752     0.200
     2.539    13.184     0.200
     2.700    13.215     0.200
     2.761    13.917     0.200
     2.968    14.678     0.200
     3.205    15.319     0.200
     3.297    14.545     0.200
     3.797    16.509     0.200
     3.898    16.027     0.200
     3.898    16.338     0.200
     3.963    17.173     0.200
     4.095    16.153     0.200
     4.102    15.649     0.200
     4.437    16.533     0.200
     4.402    17.549     0.200
     4.465    18.990     0.200
     4.610    17.625     0.200
     4.639    17.079     0.200
     4.727    18.602     0.200
     5.133    17.658     0.200
     5.191    18.543     0.200
     5.570    19.543     0.200
     5.686    19.063     0.200
     6.136    20.867     0.200
     6.248    20.909     0.200
     6.248    21.150     0.200
     6.613    21.940     0.200
     8.111    24.661     0.200
    12.645    31.195     0.200
     2.254    12.772     0.200
     2.326    12.340     0.200
     2.563    13.375     0.200
     2.792    14.192     0.200
     2.993    13.755     0.200
     3.149    13.833     0.200
     3.229    15.296     0.200
     3.275    14.161     0.200
     3.535    15.024     0.200
     3.825    16.240     0.200
     3.917    16.464     0.200
     3.917    16.714     0.200
     3.987    16.947     0.200
     4.090    15.915     0.200
     4.097    15.374     0.200
     4.429    17.095     0.200
     4.436    16.717     0.200
     4.493    18.832     0.200
     4.606    16.930     0.200
     4.630    16.946     0.200
     5.098    17.286     0.200
     5.098    17.536     0.200
     5.173    18.011     0.200
     5.592    20.020     0.200
     5.661    19.513     0.200
     5.724    19.579     0.200
     6.026    20.759     0.200
     6.123    20.629     0.200
     6.217    20.523     0.200
     6.217    20.683     0.200
     6.361    16.699     0.200
     6.506    21.709     0.200
     7.104    24.038     0.200
     7.219    22.037     0.200
     7.566    23.887     0.200
     8.113    24.505     0.200
    10.789    27.426     0.200
    12.667    32.445     0.200
    12.667    31.342     0.200
    14.684    33.843     0.200
    16.046    36.593     0.200
    16.046    35.652     0.200
     2.388    13.585     0.200
     2.906    14.868     0.200
     2.892    13.904     0.200
     3.028    14.618     0.200
     3.344    15.722     0.200
     3.453    15.351     0.200
     3.698    15.699     0.200
     3.698    15.871     0.200
     3.705    16.214     0.200
     4.104    17.158     0.200
     4.104    17.392     0.200
     4.307    17.984     0.200
     4.313    16.812     0.200
     4.576    17.745     0.200
     4.629    19.938     0.200
     4.629    18.797     0.200
     4.654    18.332     0.200
     4.843    18.132     0.200
     4.907    18.935     0.200
     5.366    18.733     0.200
     5.669    18.690     0.200
     5.764    21.021     0.200
     5.823    20.293     0.200
     5.909    20.390     0.200
     6.342    21.635     0.200
     6.342    21.440     0.200
     6.529    17.943     0.200
     6.719    22.371     0.200
     6.996    22.195     0.200
     7.227    24.012     0.200
     7.227    23.262     0.200
     8.745    25.596     0.200
     9.851    27.193     0.200
    10.494    28.323     0.200
    10.647    27.767     0.200
    10.647    28.002     0.200
    10.818    27.609     0.200
    11.953    30.055     0.200
    12.085    30.534     0.200
    12.421    30.304     0.200
    12.496    31.166     0.200
    12.496    31.401     0.200
    12.496    31.666     0.200
    12.496    33.135     0.200
    12.781    32.217     0.200
    12.861    32.877     0.200
    12.875    32.022     0.200
    13.305    32.685     0.200
    13.324    32.295     0.200
    13.928    34.103     0.200
    14.170    33.726     0.200
    14.687    36.645     0.200
    14.687    34.637     0.200
    14.687    36.106     0.200
    14.947    35.559     0.200
    15.986    37.072     0.200
    16.064    37.110     0.200
    16.064    35.720     0.200
    17.444    40.059     0.200
    18.280    39.581     0.200
    19.420    41.913     0.200
     2.239    12.503     0.200
     2.698    12.651     0.200
     2.776    13.512     0.200
     2.877    13.562     0.200
     2.981    13.746     0.200
     3.163    13.426     0.200
     3.218    14.487     0.200
     3.291    13.825     0.200
     3.608    14.329     0.200
     3.811    15.663     0.200
     3.909    15.512     0.200
     3.909    16.143     0.200
     3.976    16.437     0.200
     4.097    15.606     0.200
     4.104    15.343     0.200
     4.415    16.805     0.200
     4.441    15.811     0.200
     4.479    16.968     0.200
     4.479    17.448     0.200
     4.612    16.911     0.200
     4.639    16.692     0.200
     4.740    17.034     0.200
     5.120    17.385     0.200
     5.582    19.535     0.200
     5.679    19.360     0.200
     5.739    19.156     0.200
     5.885    16.635     0.200
     6.044    20.298     0.200
     6.146    20.006     0.200
     6.135    20.939     0.200
     6.238    19.841     0.200
     6.238    20.031     0.200
     6.265    20.827     0.200
     6.378    18.753     0.200
     6.515    20.688     0.200
     6.610    21.994     0.200
     7.127    21.109     0.200
     7.240    21.539     0.200
     7.240    21.159     0.200
     7.719    23.505     0.200
     7.988    23.221     0.200
     8.380    24.241     0.200
     8.908    24.921     0.200
     8.908    23.492     0.200
     9.254    24.232     0.200
     9.410    27.127     0.200
    10.426    27.578     0.200
    10.643    27.142     0.200
    10.770    26.818     0.200
    10.770    27.193     0.200
    10.978    25.927     0.200
    12.651    31.129     0.200
    12.651    30.285     0.200
    13.133    33.103     0.200
    14.662    33.014     0.200
    14.662    33.143     0.200
    14.662    33.684     0.200
    14.861    37.691     0.200
    15.131    36.331     0.200
    16.025    36.671     0.200
    16.025    35.026     0.200
    18.101    39.172     0.200
     2.286    12.709     0.200
     2.375    12.770     0.200
     2.399    12.586     0.200
     2.604    13.099     0.200
     2.582    12.954     0.200
     2.738    13.336     0.200
     2.819    14.398     0.200
     2.924    13.862     0.200
     3.032    14.298     0.200
     3.198    14.265     0.200
     3.320    14.445     0.200
     3.576    14.684     0.200
     3.858    16.459     0.200
     3.963    16.235     0.200
     3.963    17.145     0.200
     4.027    16.391     0.200
     4.151    15.944     0.200
     4.464    17.984     0.200
     4.526    18.393     0.200
     4.526    17.658     0.200
     4.490    17.583     0.200
     4.660    18.098     0.200
     4.683    17.529     0.200
     4.790    19.039     0.200
     5.114    17.800     0.200
     5.221    18.450     0.200
     5.702    19.742     0.200
     5.771    19.841     0.200
     6.064    20.712     0.200
     6.173    20.641     0.200
     6.249    20.459     0.200
     6.249    20.859     0.200
     6.293    21.244     0.200
     6.403    19.060     0.200
     6.646    22.230     0.200
     7.107    22.435     0.200
     7.156    22.299     0.200
     7.221    25.953     0.200
     7.709    26.299     0.200
     8.878    25.801     0.200
     9.973    27.749     0.200
    10.618    29.162     0.200
    10.753    27.906     0.200
    12.624    31.906     0.200
    12.624    32.083     0.200
    14.683    36.427     0.200
    14.683    36.530     0.200
    14.683    37.397     0.200
    14.912    36.356     0.200
    16.050    38.434     0.200
    16.050    38.617     0.200
    16.123    38.302     0.200
     2.408    11.964     0.200
     2.424    12.886     0.200
     2.602    13.709     0.200
     2.766    12.888     0.200
     2.842    14.610     0.200
     2.951    14.238     0.200
     3.224    14.246     0.200
     3.299    15.976     0.200
     3.342    14.267     0.200
     3.595    15.943     0.200
     3.885    17.330     0.200
     3.995    16.142     0.200
     4.057    17.429     0.200
     4.183    15.658     0.200
     4.492    17.643     0.200
     4.552    18.870     0.200
     4.552    16.954     0.200
     4.523    16.482     0.200
     4.693    16.604     0.200
     4.714    17.157     0.200
     4.819    19.768     0.200
     5.117    17.681     0.200
     5.247    18.137     0.200
     5.800    19.720     0.200
     5.665    20.102     0.200
     5.721    20.102     0.200
     5.795    20.045     0.200
     6.082    20.689     0.200
     6.201    20.504     0.200
     6.234    21.619     0.200
     6.261    20.900     0.200
     6.316    21.468     0.200
     6.424    18.996     0.200
     6.590    21.936     0.200
     6.672    22.309     0.200
     7.090    20.823     0.200
     7.215    23.476     0.200
     7.215    24.197     0.200
     7.186    21.728     0.200
     7.709    24.681     0.200
     8.201    24.665     0.200
     8.856    24.455     0.200
     9.953    26.579     0.200
    10.597    27.568     0.200
    10.737    27.647     0.200
    10.737    27.413     0.200
    12.063    29.714     0.200
    12.538    30.286     0.200
    12.602    30.519     0.200
    12.602    31.760     0.200
    12.602    30.826     0.200
    14.043    33.888     0.200
    14.287    33.348     0.200
    14.691    33.351     0.200
    14.691    33.896     0.200
    14.691    34.390     0.200
    14.786    39.333     0.200
    15.068    33.652     0.200
    14.943    37.378     0.200
    16.100    37.608     0.200
    16.060    35.926     0.200
    16.060    35.784     0.200
    17.350    39.115     0.200
    20.108    41.504     0.200
     2.416    12.217     0.200
     2.594    12.538     0.200
     2.763    13.367     0.200
     2.856    14.223     0.200
     2.963    14.143     0.200
     3.073    14.355     0.200
     3.220    14.042     0.200
     3.336    14.384     0.200
     3.897    16.737     0.200
     4.005    16.077     0.200
     4.005    16.288     0.200
     4.068    16.843     0.200
     4.176    16.629     0.200
     4.183    16.098     0.200
     4.504    17.154     0.200
     4.565    17.793     0.200
     4.565    18.770     0.200
     4.525    17.310     0.200
     4.694    17.840     0.200
     4.713    17.414     0.200
     4.831    18.500     0.200
     5.104    17.657     0.200
     5.104    17.837     0.200
     5.242    18.336     0.200
     5.675    20.058     0.200
     5.714    19.134     0.200
     5.796    17.214     0.200
     5.796    21.832     0.200
     5.789    19.753     0.200
     6.074    20.633     0.200
     6.242    20.512     0.200
     6.198    21.086     0.200
     6.251    20.564     0.200
     6.251    20.665     0.200
     6.309    21.591     0.200
     6.416    18.089     0.200
     6.589    22.030     0.200
     6.668    22.604     0.200
     7.003    22.888     0.200
     7.099    21.652     0.200
     7.184    23.254     0.200
     7.246    23.159     0.200
     7.201    22.186     0.200
     7.201    22.671     0.200
     7.695    24.959     0.200
     8.204    25.073     0.200
     8.888    27.038     0.200
     9.200    25.660     0.200
     9.483    27.127     0.200
     9.889    29.356     0.200
     9.961    26.634     0.200
    10.605    27.514     0.200
    10.746    27.782     0.200
    11.387    31.832     0.200
    11.750    31.692     0.200
    12.543    30.424     0.200
    12.609    31.310     0.200
    12.609    31.130     0.200
    12.609    31.864     0.200
    13.318    35.891     0.200
    13.422    32.680     0.200
    13.974    37.146     0.200
    14.705    33.653     0.200
    14.954    37.360     0.200
    15.072    35.558     0.200
    15.637    34.176     0.200
    16.074    35.510     0.200
    16.105    37.136     0.200
    16.105    36.746     0.200
    17.361    38.431     0.200
    18.223    41.600     0.200
    18.157    38.916     0.200
    20.118    41.235     0.200
     2.600    13.169     0.200
     2.743    13.795     0.200
     2.972    13.730     0.200
     3.162    14.811     0.200
     3.294    15.072     0.200
     3.411    14.502     0.200
     3.501    14.849     0.200
     3.530    16.216     0.200
     3.703    15.899     0.200
     3.731    15.667     0.200
     4.097    17.093     0.200
     4.287    17.280     0.200
     4.413    16.703     0.200
     4.763    17.523     0.200
     4.762    18.513     0.200
     4.928    17.997     0.200
     4.934    17.734     0.200
     6.471    21.993     0.200
    12.460    29.741     0.200
     2.398    12.331     0.200
     2.590    13.491     0.200
     2.331    12.605     0.200
     2.235    12.735     0.200
     2.727    13.190     0.200
     2.555    13.000     0.200
     3.192    14.251     0.200
     3.219    13.942     0.200
     4.129    15.425     0.200
     3.807    16.180     0.200
     3.916    16.804     0.200
     3.977    16.995     0.200
     4.464    17.219     0.200
     4.666    17.552     0.200
     4.414    17.703     0.200
     4.475    18.265     0.200
     5.710    19.674     0.200
     5.585    20.227     0.200
     7.166    22.682     0.200
    10.739    27.970     0.200
    12.620    30.256     0.200
    12.620    32.709     0.200
    14.641    33.668     0.200
    16.005    35.957     0.200
     2.194    12.661     0.200
     2.303    12.189     0.200
     2.503    12.653     0.200
     2.737    14.250     0.200
     2.627    13.018     0.200
     2.830    13.942     0.200
     2.924    14.047     0.200
     3.095    13.744     0.200
     3.231    13.868     0.200
     3.570    14.603     0.200
     3.763    16.354     0.200
     3.844    16.111     0.200
     3.844    16.228     0.200
     3.919    16.837     0.200
     4.021    16.252     0.200
     4.028    15.668     0.200
     4.364    17.338     0.200
     4.432    17.627     0.200
     4.432    17.885     0.200
     4.364    16.644     0.200
     4.565    16.897     0.200
     4.686    17.708     0.200
     5.121    18.314     0.200
     5.521    19.636     0.200
     5.521    19.847     0.200
     5.624    19.541     0.200
     5.676    19.336     0.200
     5.992    20.439     0.200
     6.077    20.377     0.200
     6.065    20.692     0.200
     6.196    20.262     0.200
     6.321    19.839     0.200
     6.440    21.274     0.200
     6.879    22.298     0.200
     7.179    20.652     0.200
     7.077    22.581     0.200
     7.240    22.632     0.200
     7.705    23.617     0.200
     8.039    24.554     0.200
     9.320    25.199     0.200
    10.054    26.267     0.200
    10.701    27.383     0.200
    10.819    27.842     0.200
    11.886    34.264     0.200
    12.663    30.595     0.200
    12.711    30.701     0.200
    12.711    31.178     0.200
    12.711    31.732     0.200
    14.661    34.631     0.200
    16.019    36.032     0.200
     2.526    13.018     0.200
     2.528    13.094     0.200
     2.690    14.009     0.200
     2.740    13.919     0.200
     3.165    14.863     0.200
     3.331    14.122     0.200
     3.438    14.580     0.200
     3.401    16.012     0.200
     3.681    15.139     0.200
     3.687    15.681     0.200
     4.109    16.445     0.200
     4.159    17.173     0.200
     4.306    16.252     0.200
     4.649    17.352     0.200
     4.640    18.271     0.200
     4.834    17.388     0.200
     5.807    20.032     0.200
     5.895    20.002     0.200
     6.162    20.881     0.200
     6.324    21.100     0.200
    12.512    31.755     0.200
    16.083    36.214     0.200
     2.313    12.824     0.200
     2.431    13.142     0.200
     2.637    13.236     0.200
     2.952    14.269     0.200
     3.065    15.052     0.200
     3.232    14.004     0.200
     3.301    14.989     0.200
     3.887    16.462     0.200
     3.999    16.748     0.200
     4.059    16.846     0.200
     4.494    17.667     0.200
     4.722    17.321     0.200
     5.122    17.650     0.200
     6.268    19.866     0.200
    10.730    27.644     0.200
    12.595    33.588     0.200
     6.680    21.971     0.200
     2.298    11.764     0.200
     2.353    12.520     0.200
     2.531    13.346     0.200
     2.680    13.100     0.200
     3.197    14.771     0.200
     3.603    14.831     0.200
     3.792    16.528     0.200
     3.887    15.714     0.200
     3.887    16.284     0.200
     3.955    16.522     0.200
     4.076    16.199     0.200
     4.083    15.226     0.200
     4.419    17.004     0.200
     4.591    17.499     0.200
     4.720    18.792     0.200
     4.983    18.727     0.200
     4.983    18.866     0.200
     5.121    17.916     0.200
     5.560    19.988     0.200
     5.560    19.639     0.200
     6.124    21.203     0.200
     6.231    20.057     0.200
     6.366    20.303     0.200
     6.934    21.797     0.200
     8.094    25.024     0.200
     2.416    12.929     0.200
     2.748    14.355     0.200
     2.940    14.036     0.200
     3.055    14.468     0.200
     3.174    14.879     0.200
     3.411    15.720     0.200
     3.643    15.305     0.200
     4.112    17.506     0.200
     4.168    17.076     0.200
     4.276    17.322     0.200
     4.282    16.149     0.200
     4.628    17.808     0.200
     4.600    18.237     0.200
     4.657    16.928     0.200
     4.807    16.926     0.200
     4.929    18.849     0.200
     5.102    18.468     0.200
     5.768    20.004     0.200
     5.779    20.565     0.200
     6.123    20.663     0.200
     6.283    20.699     0.200
     6.283    20.429     0.200
     6.351    21.781     0.200
     7.139    22.411     0.200
     6.746    21.901     0.200
     2.377    12.789     0.200
     2.507    12.676     0.200
     2.715    14.252     0.200
     2.858    13.274     0.200
     2.899    13.717     0.200
     3.017    14.825     0.200
     3.140    14.987     0.200
     3.376    15.534     0.200
     3.678    15.308     0.200
     3.952    16.816     0.200
     4.083    17.563     0.200
     4.134    17.092     0.200
     4.274    16.063     0.200
     4.281    16.275     0.200
     4.563    17.878     0.200
     4.618    18.171     0.200
     4.810    17.101     0.200
     4.893    18.404     0.200
     5.142    17.681     0.200
     5.189    19.090     0.200
     5.301    18.973     0.200
     5.792    20.536     0.200
     5.746    20.521     0.200
     5.877    20.448     0.200
     6.315    20.939     0.200
     6.315    20.572     0.200
     6.686    22.606     0.200
     6.759    22.459     0.200
    16.073    36.461     0.200
     2.325    13.050     0.200
     2.493    12.697     0.200
     2.835    13.406     0.200
     2.848    13.535     0.200
     2.965    14.493     0.200
     3.088    14.557     0.200
     3.324    14.995     0.200
     3.662    15.699     0.200
     3.688    15.457     0.200
     4.032    15.940     0.200
     4.082    16.256     0.200
     4.242    17.079     0.200
     4.248    16.412     0.200
     4.566    18.275     0.200
     4.841    17.835     0.200
     5.694    20.730     0.200
     2.202    12.578     0.200
     2.516    13.024     0.200
     2.739    14.434     0.200
     2.840    14.239     0.200
     2.945    14.117     0.200
     3.181    14.758     0.200
     3.774    16.440     0.200
     3.875    16.265     0.200
     3.939    17.010     0.200
     4.078    15.278     0.200
     4.379    17.482     0.200
     4.442    16.233     0.200
     4.456    18.275     0.200
     4.624    17.313     0.200
     4.704    18.088     0.200
     5.142    18.828     0.200
     5.115    18.785     0.200
     5.682    19.570     0.200
     5.736    19.442     0.200
     6.249    20.555     0.200
     6.935    22.150     0.200
     7.743    25.945     0.200
    10.763    28.093     0.200
    12.651    33.038     0.200
    12.651    31.534     0.200
     6.603    22.020     0.200
    15.995    35.097     0.200
     2.187    11.970     0.200
     2.098    12.714     0.200
     2.492    12.613     0.200
     2.654    13.556     0.200
     2.729    13.742     0.200
     3.040    15.019     0.200
     3.511    14.424     0.200
     3.707    15.633     0.200
     3.871    15.264     0.200
     3.879    15.526     0.200
     3.798    16.872     0.200
     4.212    16.745     0.200
     4.253    17.261     0.200
     4.311    17.184     0.200
     4.329    16.834     0.200
     4.570    16.646     0.200
     4.987    19.490     0.200
     5.393    19.293     0.200
     6.127    20.089     0.200
     6.295    20.629     0.200
     6.926    22.670     0.200
     6.415    21.130     0.200
     2.337    12.396     0.200
     2.672    12.883     0.200
     2.798    14.086     0.200
     3.134    14.195     0.200
     3.519    14.995     0.200
     3.519    14.683     0.200
     3.572    15.281     0.200
     3.915    16.673     0.200
     3.915    16.244     0.200
     4.077    17.301     0.200
     4.084    15.503     0.200
     4.424    16.727     0.200
     4.754    17.892     0.200
     6.148    21.774     0.200
     6.201    21.294     0.200
     6.201    20.911     0.200
     6.937    21.877     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     4.508    30.810     0.200
     4.054    28.361     0.200
     4.101    28.204     0.200
     4.129    29.581     0.200
     4.493    30.547     0.200
     4.460    30.587     0.200
     4.531    31.020     0.200
     4.518    31.462     0.200
     4.501    31.211     0.200
     4.466    31.830     0.200
     4.495    30.706     0.200
     4.541    31.476     0.200
     4.528    31.044     0.200
     4.574    31.600     0.200
     4.633    31.449     0.200
     4.472    30.442     0.200
     4.448    30.609     0.200
     4.451    31.489     0.200
     4.496    30.630     0.200
     4.494    30.932     0.200
     4.617    31.357     0.200
     4.636    31.580     0.200
     4.506    31.021     0.200
     4.601    32.475     0.200
     7.892    61.296     0.200
     4.594    31.104     0.200
     6.678    47.370     0.200
     4.520    31.464     0.200
     4.542    31.202     0.200
     4.562    30.819     0.200
     4.486    31.091     0.200
     4.465    30.766     0.200
     4.629    32.813     0.200
     4.479    30.218     0.200
     4.552    31.169     0.200
     4.565    31.121     0.200
     4.475    30.343     0.200
     4.640    32.247     0.200
     2.516    19.944     0.200
     4.329    30.300     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.414     9.170     0.200
     1.414     9.519     0.200
     1.662     9.270     0.200
     1.662     9.430     0.200
     1.769    10.427     0.200
     1.769    11.187     0.200
     1.958    11.009     0.200
     1.430     9.461     0.200
     1.430    10.410     0.200
     1.673    10.624     0.200
     1.673    10.154     0.200
     1.783    10.842     0.200
     1.783    12.191     0.200
     1.966    12.217     0.200
     2.555    13.230     0.200
     1.427     9.775     0.200
     1.616    10.025     0.200
     1.800    11.421     0.200
     1.800    11.940     0.200
     2.009    11.805     0.200
     1.407    10.548     0.200
     1.620    10.259     0.200
     1.777    12.533     0.200
     1.338     9.690     0.200
     1.338     9.540     0.200
     1.553     9.385     0.200
     1.726    11.666     0.200
     1.726    10.776     0.200
     1.968    11.149     0.200
     1.473     8.906     0.200
     1.473     9.435     0.200
     1.817    11.191     0.200
     1.982    11.706     0.200
     1.476    10.247     0.200
     1.476    10.086     0.200
     1.717    10.130     0.200
     1.717    10.511     0.200
     1.818    11.552     0.200
     1.818    12.482     0.200
     1.980    12.329     0.200
     2.407    12.780     0.200
     1.405     9.523     0.200
     1.636     9.833     0.200
     1.769    11.577     0.200
     1.769    11.696     0.200
     1.970    11.647     0.200
     2.326    12.375     0.200
     2.520    13.311     0.200
     1.546    10.273     0.200
     1.546     9.312     0.200
     1.765    10.411     0.200
     1.880    11.878     0.200
     2.019    12.276     0.200
     2.454    13.077     0.200
     2.629    13.727     0.200
     4.567    29.642     0.200
     1.447     9.584     0.200
     1.675    10.126     0.200
     1.801    12.054     0.200
     1.801    12.245     0.200
     2.554    13.274     0.200
     1.468    10.369     0.200
     1.716    10.179     0.200
     1.716    10.417     0.200
     1.810    11.581     0.200
     1.810    12.183     0.200
     1.973    11.897     0.200
     4.500    30.364     0.200
     1.408    10.171     0.200
     1.408    10.440     0.200
     1.669     9.934     0.200
     1.669    10.321     0.200
     1.760    11.961     0.200
     1.760    12.320     0.200
     1.947    11.892     0.200
     1.486     9.409     0.200
     1.486     9.940     0.200
     1.702     9.981     0.200
     1.702    10.422     0.200
     1.834    12.138     0.200
     2.003    11.210     0.200
     1.492     9.513     0.200
     1.492     9.931     0.200
     1.651     9.662     0.200
     1.651    10.139     0.200
     1.861    11.814     0.200
     2.517    13.358     0.200
     1.449     9.267     0.200
     1.811    12.047     0.200
     1.478    10.070     0.200
     1.478    10.230     0.200
     1.695    10.129     0.200
     1.828    11.980     0.200
     1.828    11.828     0.200
     2.000    11.763     0.200
     2.385    12.685     0.200
     4.520    30.344     0.200
     1.434     9.786     0.200
     1.434    10.047     0.200
     1.660     9.855     0.200
     1.660    10.027     0.200
     1.793    11.604     0.200
     1.793    11.854     0.200
     1.982    11.274     0.200
     1.735    10.401     0.200
     1.891    11.382     0.200
     2.423    12.773     0.200
     2.596    13.153     0.200
     1.493    10.015     0.200
     1.694    10.162     0.200
     1.845    11.497     0.200
     2.383    12.622     0.200
     2.564    13.112     0.200
     4.537    29.745     0.200
     1.444    10.357     0.200
     1.444    10.217     0.200
     1.800    11.898     0.200
     1.800    11.316     0.200
     1.394     9.694     0.200
     1.612     9.848     0.200
     1.765    11.662     0.200
     1.433     9.887     0.200
     1.623     9.764     0.200
     1.804    11.849     0.200
     1.804    11.951     0.200
     2.010    12.070     0.200
     1.458     9.605     0.200
     1.613     9.698     0.200
     1.836    11.894     0.200
     2.302    12.354     0.200
     2.484    12.938     0.200
     1.523    10.176     0.200
     1.688    10.047     0.200
     1.688    10.157     0.200
     1.882    11.989     0.200
     2.056    12.216     0.200
     2.376    12.621     0.200
     2.550    12.992     0.200
     1.540     9.939     0.200
     1.686     9.738     0.200
     1.902    12.017     0.200
     2.373    12.720     0.200
     2.543    12.935     0.200
     4.594    30.568     0.200
     1.481     9.369     0.200
     1.481     9.197     0.200
     1.707    10.131     0.200
     1.707     9.529     0.200
     1.828    11.723     0.200
     1.828    11.863     0.200
     1.994    12.099     0.200
     2.396    12.784     0.200
     2.580    13.136     0.200
     1.461     9.827     0.200
     1.696    10.485     0.200
     1.696     9.946     0.200
     1.810    11.766     0.200
     1.810    11.387     0.200
     1.981    11.228     0.200
     2.386    12.536     0.200
     2.573    13.250     0.200
     1.489    10.298     0.200
     1.650     9.930     0.200
     1.858    11.800     0.200
     2.338    12.299     0.200
     2.516    13.123     0.200
     4.552    30.088     0.200
     1.530     9.418     0.200
     1.664    10.051     0.200
     1.898    12.021     0.200
     2.351    12.436     0.200
     2.522    13.244     0.200
     1.387     9.562     0.200
     1.577     9.843     0.200
     1.577    10.031     0.200
     1.770    11.591     0.200
     1.998    11.473     0.200
     2.461    12.724     0.200
     1.455     9.981     0.200
     1.693    10.102     0.200
     1.977    11.799     0.200
     1.513     9.945     0.200
     1.513    10.323     0.200
     1.852    11.982     0.200
     1.737    10.623     0.200
     1.737    10.405     0.200
     2.005    11.953     0.200
     1.487    10.168     0.200
     1.487    10.289     0.200
     1.698     9.998     0.200
     1.837    11.980     0.200
     2.007    11.839     0.200
     1.509    10.745     0.200
     1.750    10.633     0.200
     1.843    12.639     0.200
     1.990    12.467     0.200
     1.527     9.959     0.200
     1.699     9.544     0.200
     1.699     9.984     0.200
     5.892    28.866     0.200
     1.566     9.994     0.200
     1.764    10.820     0.200
     1.507    10.174     0.200
     1.713    10.051     0.200
     1.855    11.715     0.200
     1.855    12.185     0.200
     4.545    30.665     0.200
     1.603    11.047     0.200
     1.767    10.992     0.200
     2.453    12.926     0.200
     2.617    13.614     0.200
     1.475    10.405     0.200
     1.475    10.794     0.200
     1.640    10.071     0.200
     1.640    10.381     0.200
     1.845    12.488     0.200
     1.629    10.840     0.200
     1.539    10.711     0.200
     1.539     9.580     0.200
     1.884    11.885     0.200
     2.420    12.821     0.200
     1.464    10.330     0.200
     1.464    10.529     0.200
     1.710    10.359     0.200
     1.710    10.620     0.200
     1.807    12.423     0.200
     1.497    10.115     0.200
     1.706    10.175     0.200
     1.846    11.645     0.200
     1.846    11.903     0.200
     2.395    12.634     0.200
     4.537    30.588     0.200
     1.426     9.789     0.200
     1.426     9.980     0.200
     1.669     9.843     0.200
     1.779    11.559     0.200
     1.779    11.750     0.200
     2.360    12.490     0.200
     1.372     9.358     0.200
     1.372     9.748     0.200
     1.580     9.825     0.200
     1.580     9.985     0.200
     1.752    11.616     0.200
     1.752    11.866     0.200
     1.980    12.024     0.200
     1.369     9.760     0.200
     1.369     9.479     0.200
     1.564     9.782     0.200
     1.755    11.453     0.200
     1.990    11.791     0.200
     2.451    12.829     0.200
     1.475    10.204     0.200
     1.475    10.102     0.200
     1.808    12.023     0.200
     2.432    12.930     0.200
     2.621    13.535     0.200
     1.589     9.961     0.200
     1.918    12.015     0.200
     2.482    13.237     0.200
     4.604    30.850     0.200
     1.438     9.869     0.200
     1.675     9.700     0.200
     1.675     9.881     0.200
     1.791    11.951     0.200
     1.791    11.830     0.200
     2.365    12.546     0.200
     2.556    13.325     0.200
     4.483    28.782     0.200
     1.571    10.362     0.200
     1.766    10.384     0.200
     1.766    10.571     0.200
     1.908    12.228     0.200
     2.454    12.959     0.200
     2.624    13.373     0.200
     1.462     9.653     0.200
     1.462     9.521     0.200
     1.687    10.319     0.200
     1.687    10.022     0.200
     1.813    11.751     0.200
     2.563    13.095     0.200
     1.380     9.901     0.200
     1.380    10.120     0.200
     1.744    11.661     0.200
     1.744    11.958     0.200
     1.630     9.886     0.200
     1.630    10.015     0.200
     5.945    28.804     0.200
     1.615    10.122     0.200
     1.615     9.853     0.200
     1.799    11.878     0.200
     2.305    12.372     0.200
     2.494    12.872     0.200
     1.406     9.710     0.200
     1.632     9.867     0.200
     1.771    11.648     0.200
     1.771    11.370     0.200
     4.465    30.108     0.200
     5.927    28.723     0.200
     1.441     9.842     0.200
     1.636     9.780     0.200
     1.809    11.550     0.200
     2.325    12.431     0.200
     2.512    13.252     0.200
     1.484     9.819     0.200
     1.484    10.001     0.200
     1.705    10.034     0.200
     1.705    10.194     0.200
     1.831    11.464     0.200
     1.831    11.753     0.200
     4.522    29.161     0.200
     1.529     9.891     0.200
     1.747    10.351     0.200
     1.747    10.171     0.200
     1.867    11.943     0.200
     1.867    11.724     0.200
     2.435    12.814     0.200
     2.613    13.447     0.200
     4.556    30.341     0.200
     1.558     9.772     0.200
     1.765    10.051     0.200
     1.765    10.620     0.200
     1.893    11.255     0.200
     1.893    11.815     0.200
     1.621    10.747     0.200
     1.847    10.736     0.200
     1.936    12.171     0.200
     2.534    13.386     0.200
     2.702    14.029     0.200
     1.627    10.906     0.200
     1.627     9.477     0.200
     1.948    12.452     0.200
     1.948    12.302     0.200
     1.605    10.458     0.200
     1.605    10.298     0.200
     1.830    10.928     0.200
     1.830    10.658     0.200
     1.924    12.140     0.200
     1.625    10.685     0.200
     1.817    10.536     0.200
     1.952    12.271     0.200
     1.952    12.781     0.200
     2.667    13.628     0.200
     2.918    16.938     0.200
     1.596     9.810     0.200
     1.750    10.310     0.200
     1.942    12.363     0.200
     2.436    12.906     0.200
     2.599    13.393     0.200
     4.632    29.827     0.200
     1.574    10.372     0.200
     1.907    11.882     0.200
     2.636    13.575     0.200
     4.594    29.402     0.200
     1.591     9.560     0.200
     1.591    10.551     0.200
     1.809    10.219     0.200
     1.809    10.389     0.200
     1.915    11.873     0.200
     1.915    12.314     0.200
     2.036    12.207     0.200
     4.599    30.697     0.200
     1.614    10.403     0.200
     1.937    12.136     0.200
     1.937    12.286     0.200
     1.823    10.424     0.200
     2.051    11.902     0.200
     1.461     9.636     0.200
     1.682    10.677     0.200
     1.814    11.612     0.200
     1.993    11.770     0.200
     2.372    12.510     0.200
     2.558    13.238     0.200
     1.610     9.845     0.200
     1.610     9.554     0.200
     1.752    10.079     0.200
     4.648    30.669     0.200
     1.521    10.251     0.200
     1.521     9.921     0.200
     1.738    10.318     0.200
     1.862    11.780     0.200
     1.862    12.018     0.200
     2.427    12.780     0.200
     2.606    13.398     0.200
     4.551    30.498     0.200
     1.602    10.154     0.200
     1.814    10.879     0.200
     1.926    12.170     0.200
     2.501    13.156     0.200
     2.670    13.690     0.200
     4.610    29.250     0.200
     1.598    10.345     0.200
     1.838    11.455     0.200
     1.913    12.273     0.200
     1.558    10.179     0.200
     1.722    10.270     0.200
     1.910    11.880     0.200
     1.910    12.040     0.200
     2.069    12.714     0.200
     2.409    12.854     0.200
     2.578    13.181     0.200
     1.594     9.939     0.200
     1.842    10.441     0.200
     1.906    12.098     0.200
     1.466     9.654     0.200
     1.817    11.754     0.200
     2.564    13.435     0.200
     1.501     9.770     0.200
     1.847    11.635     0.200
     2.405    12.720     0.200
     1.554     9.980     0.200
     1.783    10.605     0.200
     1.783    10.195     0.200
     1.883    12.050     0.200
     1.883    12.199     0.200
     2.014    11.755     0.200
     2.472    13.173     0.200
     2.647    13.426     0.200
     1.590    10.323     0.200
     1.590    10.472     0.200
     1.819    10.448     0.200
     1.910    11.983     0.200
     1.910    12.572     0.200
     2.026    12.324     0.200
     1.624     9.967     0.200
     1.624    10.080     0.200
     1.830    10.460     0.200
     1.945    12.313     0.200
     1.945    12.185     0.200
     2.057    11.801     0.200
     4.628    30.151     0.200
     1.590    10.257     0.200
     1.833    10.622     0.200
     1.833    10.302     0.200
     1.905    11.876     0.200
     1.905    11.978     0.200
     2.014    12.018     0.200
     4.587    30.010     0.200
     1.490    10.676     0.200
     1.726    10.418     0.200
     1.726    10.599     0.200
     1.830    12.401     0.200
     1.988    11.759     0.200
     1.558    10.550     0.200
     1.558    10.331     0.200
     1.799    10.550     0.200
     1.799    10.300     0.200
     1.881    11.981     0.200
     1.881    12.114     0.200
     2.006    11.926     0.200
     2.487    12.913     0.200
     4.566    30.550     0.200
     1.436     9.971     0.200
     1.436     9.462     0.200
     1.683    10.088     0.200
     1.683     9.738     0.200
     1.786    11.788     0.200
     1.786    11.628     0.200
     1.965    12.099     0.200
     1.472     9.746     0.200
     1.472    10.134     0.200
     1.709     9.979     0.200
     1.817    11.522     0.200
     1.817    11.922     0.200
     1.982    11.796     0.200
     1.472     9.802     0.200
     1.632    10.041     0.200
     1.845    11.755     0.200
     2.045    12.532     0.200
     4.539    29.786     0.200
     1.582    10.455     0.200
     1.900    11.945     0.200
     4.583    30.865     0.200
     1.498    10.115     0.200
     1.695    10.107     0.200
     1.851    12.296     0.200
     2.022    11.966     0.200
     1.552     9.996     0.200
     1.552    10.146     0.200
     1.800    10.296     0.200
     1.873    11.742     0.200
     1.873    11.611     0.200
     1.997    11.478     0.200
     1.558    10.648     0.200
     1.558    10.851     0.200
     1.808    10.736     0.200
     1.878    11.816     0.200
     1.878    12.582     0.200
     1.998    12.009     0.200
     1.416     9.543     0.200
     1.416    10.174     0.200
     1.608     9.800     0.200
     1.608    10.021     0.200
     1.791    11.469     0.200
     2.004    11.909     0.200
     2.298    12.350     0.200
     2.488    12.832     0.200
     1.611     9.944     0.200
     1.930    11.724     0.200
     1.426    10.081     0.200
     1.617     9.856     0.200
     1.617    10.043     0.200
     1.799    11.730     0.200
     1.799    11.972     0.200
     2.007    11.948     0.200
     4.494    30.101     0.200
     1.519     9.794     0.200
     1.718    10.467     0.200
     1.866    11.833     0.200
     2.406    12.729     0.200
     2.584    13.365     0.200
     4.556    30.560     0.200
     1.424     9.403     0.200
     1.424     9.792     0.200
     1.773    11.629     0.200
     1.953    11.367     0.200
     2.372    12.440     0.200
     2.565    12.981     0.200
     1.442     9.950     0.200
     1.442     9.821     0.200
     1.662    10.082     0.200
     1.662     9.961     0.200
     1.988    11.919     0.200
     2.352    12.430     0.200
     2.541    13.230     0.200
     1.633    10.793     0.200
     1.853    10.919     0.200
     1.948    12.519     0.200
     1.948    12.707     0.200
     2.049    11.863     0.200
     2.540    13.209     0.200
     2.706    14.275     0.200
     1.435     9.193     0.200
     1.435     9.443     0.200
     1.677     9.663     0.200
     1.787    11.186     0.200
     1.787    11.075     0.200
     2.367    12.208     0.200
     2.558    12.477     0.200
     1.489    10.312     0.200
     1.489    10.181     0.200
     1.710    10.031     0.200
     1.835    11.668     0.200
     1.835    12.028     0.200
     1.521    10.015     0.200
     1.521    10.206     0.200
     1.735    10.124     0.200
     1.863    11.929     0.200
     1.530    10.259     0.200
     1.730    10.427     0.200
     1.730    10.317     0.200
     1.875    11.933     0.200
     2.418    12.691     0.200
     1.769    10.461     0.200
     1.918    10.921     0.200
     4.762    30.013     0.200
     1.443     9.772     0.200
     1.784    11.685     0.200
     1.368     9.705     0.200
     1.737    11.302     0.200
     1.737    11.662     0.200
     1.613     9.947     0.200
     1.638    10.093     0.200
     1.840    10.425     0.200
     1.526     9.915     0.200
     1.743    10.483     0.200
     1.865    11.751     0.200
     1.412     9.695     0.200
     1.662     9.868     0.200
     1.767    11.455     0.200
     1.767    11.576     0.200
     1.638    10.504     0.200
     1.807    10.638     0.200
     1.807    11.109     0.200
     1.971    11.921     0.200
     4.657    29.955     0.200
     1.611     9.832     0.200
     1.934    12.364     0.200
     1.934    11.528     0.200
     1.561    10.279     0.200
     1.804    10.514     0.200
     1.882    12.129     0.200
     1.400     9.339     0.200
     1.673     9.726     0.200
     1.750    11.562     0.200
     1.232     9.021     0.200
     1.496     9.393     0.200
     1.632    11.142     0.200
     2.105    11.726     0.200
     1.439     9.868     0.200
     1.439     9.485     0.200
     1.647     9.782     0.200
     1.803    12.227     0.200
     1.803    11.594     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.462    69.525     0.200
     7.137   100.585     0.200
     9.908   140.629     0.200
     9.951   139.198     0.200
    10.295   139.909     0.200
    10.779   146.538     0.200
    10.779   145.276     0.200
    11.270   156.941     0.200
    11.832   164.492     0.200
    12.664   171.498     0.200
    12.664   169.490     0.200
    13.058   182.782     0.200
    13.204   181.682     0.200
    13.301   180.646     0.200
    13.695   187.950     0.200
    13.862   189.694     0.200
    14.527   196.940     0.200
    15.344   207.678     0.200
    15.715   211.475     0.200
    15.715   212.276     0.200
    15.786   214.007     0.200
    16.018   206.637     0.200
    16.360   218.978     0.200
    17.485   233.715     0.200
    19.052   255.527     0.200
    19.332   250.683     0.200
    20.481   273.695     0.200
    21.568   278.718     0.200
    21.702   279.810     0.200
    21.819   284.165     0.200
     4.475    67.922     0.200
     7.130    99.892     0.200
    10.773   144.764     0.200
    11.286   159.933     0.200
    11.819   164.315     0.200
    12.655   170.905     0.200
    12.655   171.817     0.200
    13.316   184.646     0.200
    13.710   190.845     0.200
    13.878   192.884     0.200
    13.943   191.025     0.200
    14.662   191.890     0.200
    15.648   205.884     0.200
    16.024   209.041     0.200
    16.024   209.844     0.200
    21.300   280.968     0.200
     4.495    71.246     0.200
     7.181   102.971     0.200
     9.792   139.002     0.200
     9.864   140.216     0.200
     9.907   140.233     0.200
    10.823   145.342     0.200
    10.823   146.962     0.200
    10.817   153.656     0.200
    11.262   158.038     0.200
    11.871   163.139     0.200
    12.707   173.973     0.200
    12.707   172.794     0.200
    13.058   180.081     0.200
    13.201   182.914     0.200
    13.220   186.538     0.200
    13.300   182.762     0.200
    13.691   188.495     0.200
    13.853   191.499     0.200
    13.933   189.569     0.200
    14.504   200.290     0.200
    14.569   197.534     0.200
    14.690   195.432     0.200
    15.387   207.725     0.200
    15.696   206.430     0.200
    15.696   204.801     0.200
    15.757   213.951     0.200
    15.828   214.205     0.200
    16.050   206.319     0.200
    16.050   206.854     0.200
    16.402   221.829     0.200
    17.282   232.377     0.200
    17.487   232.794     0.200
    17.771   240.682     0.200
    19.325   256.449     0.200
    22.720   293.949     0.200
    16.042   209.092     0.200
     7.100   100.706     0.200
    10.745   143.570     0.200
    10.745   145.702     0.200
    11.330   160.075     0.200
    11.776   164.169     0.200
    12.620   173.145     0.200
    12.620   172.270     0.200
    13.260   184.352     0.200
    13.356   183.530     0.200
    13.752   190.513     0.200
    13.923   193.123     0.200
    13.980   188.350     0.200
    14.481   196.647     0.200
    14.667   190.370     0.200
    14.667   191.036     0.200
    15.297   206.826     0.200
    15.627   204.740     0.200
    15.668   211.284     0.200
    16.311   219.837     0.200
    16.033   210.052     0.200
    16.033   209.339     0.200
    19.381   258.820     0.200
     4.508    68.009     0.200
    10.740   144.017     0.200
    12.614   171.829     0.200
    12.614   172.581     0.200
    14.663   190.449     0.200
    16.029   207.053     0.200
    12.574   170.892     0.200
     4.500    68.872     0.200
    11.325   159.538     0.200
    11.773   161.002     0.200
    12.615   172.455     0.200
    13.254   184.128     0.200
    13.350   183.906     0.200
    13.746   190.285     0.200
    13.917   192.484     0.200
    16.023   205.362     0.200
     7.129   101.099     0.200
    10.770   144.525     0.200
    11.265   160.040     0.200
    11.827   161.581     0.200
    12.657   169.318     0.200
    13.197   183.896     0.200
    13.294   183.964     0.200
    13.688   190.560     0.200
    13.857   192.892     0.200
    14.645   192.162     0.200
    15.642   203.412     0.200
    16.007   209.106     0.200
    16.007   209.719     0.200
    10.799   143.090     0.200
    14.698   194.937     0.200
    12.638   169.003     0.200
    16.052   205.664     0.200
    10.789   145.339     0.200
    12.669   170.993     0.200
    16.041   208.149     0.200
    12.607   166.117     0.200
    12.714   168.929     0.200
    16.044   206.352     0.200
     4.499    67.355     0.200
     7.186    99.574     0.200
     7.980   110.284     0.200
     8.964   123.989     0.200
     9.307   127.635     0.200
    11.288   159.577     0.200
    12.708   171.552     0.200
    12.708   173.364     0.200
    13.227   184.441     0.200
    16.073   208.359     0.200
    16.073   206.773     0.200
    10.849   145.785     0.200
    12.722   171.720     0.200
    12.722   170.033     0.200
    14.746   193.036     0.200
    10.791   143.288     0.200
    11.790   163.564     0.200
    12.653   173.502     0.200
    12.653   169.696     0.200
    16.106   207.845     0.200
    16.106   205.508     0.200
    12.660   171.417     0.200
    10.753   144.319     0.200
    16.044   204.163     0.200
    16.044   205.738     0.200
     4.501    68.445     0.200
    10.758   147.693     0.200
    12.634   171.735     0.200
    14.670   194.674     0.200
    16.034   206.613     0.200
    16.034   209.902     0.200
    10.821   146.751     0.200
    12.689   171.224     0.200
    12.689   171.583     0.200
    14.743   191.394     0.200
    16.106   208.770     0.200
    16.106   205.676     0.200
    10.821   145.783     0.200
    12.681   172.631     0.200
    12.681   171.557     0.200
    14.770   193.877     0.200
    16.135   210.401     0.200
    10.864   146.195     0.200
    11.913   162.024     0.200
    12.750   171.953     0.200
    12.750   170.008     0.200
    14.711   192.675     0.200
    16.068   206.437     0.200
    16.068   206.972     0.200
     4.495    69.472     0.200
    10.759   143.740     0.200
    12.637   172.086     0.200
    12.637   172.525     0.200
    14.667   193.356     0.200
    16.031   206.756     0.200
    16.031   210.050     0.200
    10.731   142.473     0.200
    10.731   141.573     0.200
    11.746   161.724     0.200
    12.598   170.344     0.200
    12.598   170.731     0.200
    13.394   185.486     0.200
    13.791   192.762     0.200
    14.680   192.377     0.200
    16.049   206.187     0.200
    16.049   206.707     0.200
    17.575   234.095     0.200
    19.419   254.678     0.200
    10.765   143.870     0.200
    10.765   144.292     0.200
    11.786   163.077     0.200
    12.636   170.272     0.200
    12.636   171.054     0.200
    14.693   194.421     0.200
    16.058   206.766     0.200
    16.058   208.926     0.200
    17.556   234.738     0.200
    19.344   247.223     0.200
    19.398   257.844     0.200
     9.966   141.551     0.200
    10.008   143.914     0.200
    10.553   151.270     0.200
    10.633   152.899     0.200
    10.715   144.374     0.200
    10.968   151.604     0.200
    11.736   161.995     0.200
    12.585   171.107     0.200
    13.388   184.914     0.200
    13.785   191.580     0.200
    13.958   194.157     0.200
    14.008   189.081     0.200
    14.444   197.447     0.200
    14.664   189.330     0.200
    15.700   211.378     0.200
    16.032   208.081     0.200
    16.032   204.765     0.200
    17.567   234.437     0.200
     4.574    68.700     0.200
     5.815    84.396     0.200
     7.132   102.801     0.200
     9.380   136.844     0.200
     9.749   133.761     0.200
     9.900   140.400     0.200
    10.493   148.592     0.200
    10.780   147.178     0.200
    11.031   152.635     0.200
    11.034   157.119     0.200
    11.138   157.282     0.200
    11.383   161.238     0.200
    11.779   161.820     0.200
    11.963   158.738     0.200
    12.642   170.789     0.200
    12.642   172.727     0.200
    13.035   182.335     0.200
    13.173   184.452     0.200
    13.318   186.155     0.200
    13.809   192.027     0.200
    13.936   188.542     0.200
    13.974   194.395     0.200
    14.210   197.654     0.200
    14.732   193.846     0.200
    14.732   192.851     0.200
    14.793   201.840     0.200
    15.671   203.945     0.200
    16.099   205.297     0.200
    16.099   208.993     0.200
    16.238   221.391     0.200
    17.365   236.057     0.200
    17.594   237.077     0.200
    17.600   235.487     0.200
    19.440   258.906     0.200
    19.782   265.925     0.200
    20.087   265.546     0.200
    20.124   270.162     0.200
    20.943   276.898     0.200
    21.400   282.537     0.200
    21.848   282.878     0.200
    10.722   144.313     0.200
    12.580   167.823     0.200
    12.580   172.049     0.200
    14.709   196.183     0.200
     1.713    34.321     0.200
    12.624   172.659     0.200
    16.066   208.296     0.200
     1.767    35.072     0.200
    12.585   171.316     0.200
    14.744   191.966     0.200
    16.117   205.742     0.200
    16.117   208.919     0.200
    14.737   194.135     0.200
    16.099   207.512     0.200
    12.609   171.771     0.200
    12.609   173.894     0.200
    16.081   206.880     0.200
     4.498    71.126     0.200
    10.743   143.131     0.200
    11.779   162.949     0.200
    12.620   171.779     0.200
    12.620   169.994     0.200
    14.659   190.745     0.200
    15.624   204.273     0.200
    16.024   205.761     0.200
    16.024   207.841     0.200
    19.314   247.641     0.200
    10.775   144.023     0.200
    12.658   170.801     0.200
    12.658   171.922     0.200
    14.661   190.324     0.200
    16.023   205.347     0.200
    16.023   208.128     0.200
    12.745   175.680     0.200
    16.050   207.810     0.200
    10.872   145.378     0.200
    12.762   173.900     0.200
    14.706   192.864     0.200
    16.062   207.868     0.200
    16.062   210.329     0.200
    10.711   143.094     0.200
    10.711   146.727     0.200
    12.587   169.909     0.200
    14.637   189.136     0.200
    14.637   189.402     0.200
    16.004   205.671     0.200
    10.697   144.824     0.200
    12.551   169.070     0.200
    14.701   190.247     0.200
    16.074   209.083     0.200
    10.804   145.565     0.200
    11.867   163.220     0.200
    12.694   169.740     0.200
    12.694   173.435     0.200
    16.015   203.792     0.200
    16.015   205.538     0.200
     1.615    32.720     0.200
     1.615    33.060     0.200
     4.494    69.627     0.200
    12.715   170.736     0.200
    16.072   209.858     0.200
     7.168    99.347     0.200
     7.962   111.512     0.200
     9.299   128.374     0.200
    10.810   143.673     0.200
    12.695   170.788     0.200
    12.695   171.546     0.200
    14.678   191.778     0.200
    16.037   204.757     0.200
    16.037   206.460     0.200
    17.483   236.689     0.200
    19.360   247.710     0.200
    12.696   172.123     0.200
    12.591   170.491     0.200
    16.057   206.705     0.200
     4.581    71.192     0.200
     7.069   103.156     0.200
    10.002   138.916     0.200
    10.553   146.442     0.200
    10.717   145.481     0.200
    10.717   145.181     0.200
    10.906   152.300     0.200
    11.415   159.641     0.200
    11.714   159.951     0.200
    12.467   175.827     0.200
    12.498   173.776     0.200
    12.577   172.200     0.200
    12.577   171.340     0.200
    13.342   184.944     0.200
    13.438   186.630     0.200
    13.835   193.098     0.200
    14.007   192.386     0.200
    14.058   188.293     0.200
    14.411   195.133     0.200
    14.434   194.763     0.200
    14.698   193.892     0.200
    14.698   190.620     0.200
    15.247   204.483     0.200
    15.620   210.039     0.200
    15.688   210.472     0.200
    16.069   209.270     0.200
    17.618   234.050     0.200
    19.500   259.218     0.200
    20.373   272.012     0.200
    21.420   284.429     0.200
    21.561   288.201     0.200
    21.701   284.546     0.200
    21.824   286.978     0.200
    12.519   166.067     0.200
     5.698    81.799     0.200
     7.012   101.249     0.200
    10.662   146.981     0.200
    11.647   157.763     0.200
    12.515   169.534     0.200
    12.515   169.186     0.200
    13.383   188.410     0.200
    13.477   188.216     0.200
    13.877   194.549     0.200
    14.055   196.872     0.200
    16.056   208.139     0.200
    19.281   248.624     0.200
    20.038   270.927     0.200
    12.534   171.522     0.200
    16.092   205.708     0.200
    12.602   170.807     0.200
    16.126   207.792     0.200
    10.710   145.004     0.200
    12.566   170.384     0.200
    16.075   209.357     0.200
    10.681   145.818     0.200
    12.536   168.524     0.200
    12.536   171.815     0.200
    13.465   184.783     0.200
    13.864   191.227     0.200
    14.040   193.974     0.200
    14.688   191.800     0.200
    16.062   204.852     0.200
    16.062   209.066     0.200
    19.296   250.865     0.200
    10.674   143.496     0.200
    11.653   161.350     0.200
    12.525   168.922     0.200
    12.525   171.351     0.200
    14.698   188.585     0.200
    16.074   205.162     0.200
    16.074   206.039     0.200
     1.682    33.959     0.200
    10.774   144.519     0.200
    12.649   168.736     0.200
    12.649   170.068     0.200
    14.684   194.899     0.200
    16.047   206.937     0.200
    10.757   146.805     0.200
    11.721   161.553     0.200
    12.603   169.994     0.200
    12.603   172.890     0.200
    19.522   262.416     0.200
    10.733   143.602     0.200
    12.599   168.823     0.200
    12.599   169.432     0.200
    14.688   192.398     0.200
    16.069   205.170     0.200
     4.601    72.940     0.200
    10.767   145.240     0.200
    12.624   171.425     0.200
    16.112   210.843     0.200
    10.643   145.156     0.200
    12.500   169.535     0.200
    12.500   170.051     0.200
    16.032   207.949     0.200
    10.768   145.861     0.200
    14.681   192.866     0.200
    16.046   208.389     0.200
    10.750   145.463     0.200
    14.690   194.222     0.200
    16.057   207.200     0.200
     4.568    73.554     0.200
    10.694   144.782     0.200
    14.676   191.669     0.200
    16.048   210.919     0.200
    16.048   205.978     0.200
     7.019    98.646     0.200
    12.524   167.814     0.200
    16.051   205.385     0.200
    10.671   143.665     0.200
    14.701   192.145     0.200
    16.077   206.923     0.200
     4.587    70.056     0.200
    12.509   166.658     0.200
    12.509   170.572     0.200
    14.662   191.939     0.200
    16.037   206.369     0.200
    19.266   249.502     0.200
    10.734   144.880     0.200
    12.607   170.337     0.200
    12.607   169.658     0.200
    14.668   191.875     0.200
    16.035   205.580     0.200
    16.035   205.151     0.200
    10.679   144.459     0.200
    12.540   167.905     0.200
    16.037   207.576     0.200
    10.764   144.268     0.200
    12.645   168.801     0.200
    12.645   171.828     0.200
    12.645   172.724     0.200
    14.658   193.995     0.200
    16.021   206.812     0.200
    10.747   146.265     0.200
    12.622   171.239     0.200
    14.668   191.018     0.200
    16.033   206.190     0.200
    16.033   207.274     0.200
    10.834   144.639     0.200
    12.704   172.243     0.200
    12.704   173.251     0.200
    14.742   195.472     0.200
    16.105   207.266     0.200
     4.542    68.077     0.200
    10.772   145.452     0.200
    12.641   172.518     0.200
    12.641   171.253     0.200
    16.073   207.751     0.200
    16.073   206.853     0.200
    10.674   142.863     0.200
    12.537   170.134     0.200
    14.656   188.441     0.200
    16.028   205.198     0.200
     7.020   100.237     0.200
    10.668   143.298     0.200
    11.675   160.696     0.200
    12.530   170.455     0.200
    12.530   168.674     0.200
    12.530   171.713     0.200
    13.184   182.084     0.200
    14.044   187.339     0.200
    14.655   192.026     0.200
    15.562   201.274     0.200
    16.028   207.153     0.200
    16.028   205.512     0.200
    17.607   235.071     0.200
    19.173   257.286     0.200
    19.271   245.966     0.200
    19.454   257.608     0.200
     1.608    32.822     0.200
    10.839   147.866     0.200
    12.721   174.590     0.200
    14.710   194.800     0.200
    16.069   207.453     0.200
    16.072   207.922     0.200
    19.391   250.172     0.200
    12.620   167.854     0.200
    12.667   169.420     0.200
    12.667   169.185     0.200
    14.684   190.329     0.200
    16.046   207.018     0.200
    16.046   205.056     0.200
    12.496   167.791     0.200
    12.496   167.526     0.200
    12.496   171.830     0.200
    14.687   191.981     0.200
    16.064   208.931     0.200
    16.064   211.165     0.200
    10.770   144.636     0.200
    12.651   170.592     0.200
    12.651   171.614     0.200
    14.662   190.274     0.200
    16.025   206.749     0.200
    16.025   208.970     0.200
    10.753   144.691     0.200
    14.683   194.078     0.200
    16.050   210.856     0.200
    10.737   146.206     0.200
    12.602   170.133     0.200
    14.691   190.134     0.200
    10.746   143.438     0.200
    12.609   170.036     0.200
    14.705   189.333     0.200
    15.637   202.262     0.200
    16.074   206.135     0.200
    16.074   205.487     0.200
     4.475    72.015     0.200
    10.739   146.298     0.200
    12.620   173.428     0.200
    12.620   172.522     0.200
    14.641   193.176     0.200
    16.005   209.925     0.200
    12.711   168.772     0.200
    16.019   205.204     0.200
    12.512   169.559     0.200
    10.730   145.613     0.200
    12.595   173.885     0.200
     4.618    73.921     0.200
    16.073   210.711     0.200
    15.995   205.646     0.200
     2.105    50.126     0.200
     4.329    65.575     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     4.495    93.543     0.200
     4.471    94.686     0.200
     4.422    91.151     0.200
     4.508    94.230     0.200
     4.508    92.361     0.200
     4.567    93.341     0.200
     4.494    90.560     0.200
     4.500    92.989     0.200
     4.453    91.790     0.200
     4.526    93.807     0.200
     4.555    93.200     0.200
     4.504    92.638     0.200
     4.520    92.946     0.200
     4.486    92.875     0.200
     4.580    95.220     0.200
     4.537    94.436     0.200
     4.493    92.430     0.200
     4.460    92.177     0.200
     4.499    95.050     0.200
     4.531    93.645     0.200
     4.574    94.820     0.200
     4.594    96.068     0.200
     4.518    92.220     0.200
     4.501    94.722     0.200
     4.552    95.463     0.200
     4.592    96.063     0.200
     4.466    92.580     0.200
     4.495    91.806     0.200
     4.541    93.750     0.200
     4.528    94.267     0.200
     4.531    94.985     0.200
     4.574    93.850     0.200
     4.592    95.876     0.200
     4.545    94.415     0.200
     4.633    95.398     0.200
     4.539    92.815     0.200
     4.638    95.067     0.200
     4.574    93.801     0.200
     4.498    91.700     0.200
     4.537    93.838     0.200
     4.472    92.914     0.200
     4.448    93.258     0.200
     4.451    95.137     0.200
     4.496    94.028     0.200
     4.604    96.350     0.200
     4.596    93.811     0.200
     4.505    94.513     0.200
     4.438    91.193     0.200
     4.494    92.979     0.200
     4.465    92.233     0.200
     4.504    89.561     0.200
     4.522    95.610     0.200
     4.556    94.138     0.200
     4.581    95.541     0.200
     4.617    95.033     0.200
     4.631    96.617     0.200
    19.931   398.519     0.200
     4.636    94.410     0.200
     4.632    95.001     0.200
     4.594    94.951     0.200
     4.599    93.148     0.200
     4.620    95.445     0.200
     4.506    94.470     0.200
     4.648    96.894     0.200
     4.551    92.899     0.200
     4.610    95.449     0.200
     4.595    92.303     0.200
     4.601    97.112     0.200
     4.587    97.132     0.200
     4.594    94.145     0.200
     4.628    97.304     0.200
     4.587    93.142     0.200
     4.520    94.339     0.200
     4.566    94.425     0.200
     4.477    90.324     0.200
     4.507    92.024     0.200
     4.539    92.810     0.200
     4.583    95.115     0.200
     4.542    94.524     0.200
     4.558    93.042     0.200
     4.562    93.053     0.200
     4.486    94.068     0.200
     4.494    92.578     0.200
     4.556    94.888     0.200
     4.465    92.141     0.200
     4.493    94.567     0.200
     4.629    94.836     0.200
     4.479    94.294     0.200
     4.552    94.745     0.200
     4.565    94.246     0.200
     4.475    96.140     0.200
     4.432    89.151     0.200
     4.640    96.599     0.200
     2.637    60.119     0.200
     3.301    72.371     0.200
     4.460    91.129     0.200
     2.748    61.134     0.200
     4.657    94.344     0.200
     4.618    93.389     0.200
     4.566    95.752     0.200
     4.442    92.869     0.200
     4.329    87.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.405    29.023     0.200
     1.546    30.371     0.200
     1.447    28.987     0.200
     1.468    30.069     0.200
     1.702    31.281     0.200
     1.492    30.310     0.200
     1.449    28.666     0.200
     1.478    29.667     0.200
     1.434    28.985     0.200
     1.546    30.810     0.200
     1.493    31.113     0.200
     1.444    29.154     0.200
     1.394    29.194     0.200
     1.433    29.785     0.200
     1.458    30.605     0.200
     1.523    31.976     0.200
     1.540    31.138     0.200
     1.481    30.869     0.200
     1.461    30.027     0.200
     1.489    30.099     0.200
     1.530    31.019     0.200
     1.387    28.062     0.200
     1.455    30.181     0.200
     1.693    33.702     0.200
     1.513    31.743     0.200
     1.509    31.542     0.200
     1.527    32.159     0.200
     1.527    31.169     0.200
     1.507    31.274     0.200
     1.603    32.477     0.200
     1.629    32.139     0.200
     1.539    30.211     0.200
     1.464    29.929     0.200
     1.497    30.315     0.200
     1.426    28.789     0.200
     1.438    29.468     0.200
     1.571    32.162     0.200
     1.462    30.853     0.200
     1.380    28.401     0.200
     1.632    32.097     0.200
     1.441    30.545     0.200
     1.484    30.421     0.200
     1.529    31.493     0.200
     1.621    33.047     0.200
     1.627    32.406     0.200
     1.625    32.806     0.200
     1.817    33.446     0.200
     1.574    32.173     0.200
     1.461    29.735     0.200
     1.610    31.823     0.200
     1.521    31.251     0.200
     1.602    32.755     0.200
     1.598    31.044     0.200
     1.558    32.082     0.200
     1.466    30.154     0.200
     1.501    30.870     0.200
     1.554    32.183     0.200
     1.590    32.922     0.200
     1.436    29.971     0.200
     1.472    29.746     0.200
     1.472    30.103     0.200
     1.695    33.307     0.200
     1.552    32.195     0.200
     1.416    29.443     0.200
     1.416    29.804     0.200
     1.519    30.294     0.200
     1.424    28.903     0.200
     1.435    29.693     0.200
     1.489    31.612     0.200
     1.443    29.772     0.200
     1.368    28.604     0.200
     1.638    32.187     0.200
     1.526    32.118     0.200
     1.412    28.596     0.200
     1.638    33.103     0.200
     1.611    32.434     0.200
     1.439    29.564     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
