#!/bin/bash
gmt begin herat11.41_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance herat11.41'
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   100.000 Indirect calibration: shifted hypocenters used
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.200    24.529
     1.300    25.891
     1.400    27.253
     1.500    28.615
     1.600    29.977
     1.700    31.339
     1.800    32.700
     1.900    34.062
     2.000    35.424
     2.100    36.786
     2.200    38.148
     2.300    39.510
     2.400    40.872
     2.500    42.234
     2.600    43.596
     2.700    44.958
     2.800    46.320
     2.900    47.682
     3.000    49.044
     3.100    50.405
     3.200    51.767
     3.300    53.129
     3.400    54.491
     3.500    55.853
     3.600    57.214
     3.700    58.576
     3.800    59.937
     3.900    61.299
     4.000    62.661
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    55.214 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.264
     0.200     3.803
     0.300     5.479
     0.400     7.196
     0.500     8.932
     0.600    10.677
     0.700    12.428
     0.800    14.181
     0.900    15.937
     1.000    17.694
     1.100    19.453
     1.200    21.212
     1.300    22.972
     1.400    24.733
     1.500    26.494
     1.600    28.164
     1.700    29.818
     1.800    31.473
     1.900    33.127
     2.000    34.781
     2.100    36.435
     2.200    38.090
     2.300    39.744
     2.400    41.398
     2.500    43.053
     2.600    44.707
     2.700    46.361
     2.800    48.015
     2.900    49.670
     3.000    51.324
     3.100    52.978
     3.200    54.633
     3.300    56.287
     3.400    57.941
     3.500    59.594
     3.600    61.248
     3.700    62.902
     3.800    64.556
     3.900    66.210
     4.000    67.864
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    60.248 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.200    43.335
     1.300    45.733
     1.400    48.131
     1.500    50.529
     1.600    52.927
     1.700    55.325
     1.800    57.724
     1.900    60.122
     2.000    62.520
     2.100    64.918
     2.200    67.316
     2.300    69.714
     2.400    72.112
     2.500    74.511
     2.600    76.909
     2.700    79.307
     2.800    81.705
     2.900    84.103
     3.000    86.501
     3.100    88.899
     3.200    91.298
     3.300    93.696
     3.400    96.094
     3.500    98.492
     3.600   100.890
     3.700   103.287
     3.800   105.685
     3.900   108.082
     4.000   110.480
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    98.890 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.018
     0.200     6.748
     0.300     9.722
     0.400    12.771
     0.500    15.852
     0.600    18.949
     0.700    22.055
     0.800    25.167
     0.900    28.283
     1.000    31.402
     1.100    34.522
     1.200    37.644
     1.300    40.768
     1.400    43.892
     1.500    46.902
     1.600    49.819
     1.700    52.735
     1.800    55.652
     1.900    58.569
     2.000    61.486
     2.100    64.403
     2.200    67.319
     2.300    70.236
     2.400    73.153
     2.500    76.070
     2.600    78.986
     2.700    81.903
     2.800    84.820
     2.900    87.737
     3.000    90.654
     3.100    93.570
     3.200    96.487
     3.300    99.403
     3.400   102.319
     3.500   105.235
     3.600   108.151
     3.700   111.067
     3.800   113.983
     3.900   116.899
     4.000   119.815
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   107.151 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.200    24.927
     1.300    26.289
     1.400    27.650
     1.500    29.012
     1.600    30.374
     1.700    31.736
     1.800    33.098
     1.900    34.460
     2.000    35.822
     2.100    37.184
     2.200    38.546
     2.300    39.908
     2.400    41.270
     2.500    42.631
     2.600    43.993
     2.700    45.355
     2.800    46.717
     2.900    48.079
     3.000    49.441
     3.100    50.803
     3.200    52.165
     3.300    53.527
     3.400    54.889
     3.500    56.250
     3.600    57.612
     3.700    58.974
     3.800    60.335
     3.900    61.697
     4.000    63.058
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.935
     0.200     3.617
     0.300     5.352
     0.400     7.102
     0.500     8.857
     0.600    10.615
     0.700    12.376
     0.800    14.137
     0.900    15.898
     1.000    17.661
     1.100    19.423
     1.200    21.186
     1.300    22.949
     1.400    24.712
     1.500    26.476
     1.600    28.239
     1.700    30.003
     1.800    31.689
     1.900    33.344
     2.000    34.998
     2.100    36.652
     2.200    38.306
     2.300    39.961
     2.400    41.615
     2.500    43.269
     2.600    44.924
     2.700    46.578
     2.800    48.232
     2.900    49.887
     3.000    51.541
     3.100    53.195
     3.200    54.850
     3.300    56.504
     3.400    58.158
     3.500    59.812
     3.600    61.465
     3.700    63.119
     3.800    64.773
     3.900    66.427
     4.000    68.081
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.200    44.049
     1.300    46.447
     1.400    48.845
     1.500    51.243
     1.600    53.641
     1.700    56.039
     1.800    58.438
     1.900    60.836
     2.000    63.234
     2.100    65.632
     2.200    68.030
     2.300    70.428
     2.400    72.826
     2.500    75.225
     2.600    77.623
     2.700    80.021
     2.800    82.419
     2.900    84.817
     3.000    87.215
     3.100    89.613
     3.200    92.012
     3.300    94.410
     3.400    96.808
     3.500    99.206
     3.600   101.604
     3.700   104.002
     3.800   106.399
     3.900   108.797
     4.000   111.194
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.433
     0.200     6.418
     0.300     9.498
     0.400    12.603
     0.500    15.718
     0.600    18.839
     0.700    21.962
     0.800    25.088
     0.900    28.214
     1.000    31.341
     1.100    34.469
     1.200    37.598
     1.300    40.727
     1.400    43.856
     1.500    46.985
     1.600    50.115
     1.700    53.138
     1.800    56.055
     1.900    58.971
     2.000    61.888
     2.100    64.805
     2.200    67.722
     2.300    70.639
     2.400    73.555
     2.500    76.472
     2.600    79.389
     2.700    82.306
     2.800    85.223
     2.900    88.139
     3.000    91.056
     3.100    93.973
     3.200    96.890
     3.300    99.806
     3.400   102.722
     3.500   105.638
     3.600   108.554
     3.700   111.470
     3.800   114.386
     3.900   117.302
     4.000   120.218
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    22.557
     1.200    23.919
     1.300    25.281
     1.400    26.643
     1.500    28.005
     1.600    29.367
     1.700    30.729
     1.800    32.091
     1.900    33.453
     2.000    34.814
     2.100    36.176
     2.200    37.538
     2.300    38.900
     2.400    40.262
     2.500    41.624
     2.600    42.986
     2.700    44.348
     2.800    45.710
     2.900    47.072
     3.000    48.434
     3.100    49.796
     3.200    51.158
     3.300    52.519
     3.400    53.881
     3.500    55.243
     3.600    56.605
     3.700    57.966
     3.800    59.328
     3.900    60.689
     4.000    62.051
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     2.963
     0.200     4.254
     0.300     5.800
     0.400     7.443
     0.500     9.130
     0.600    10.842
     0.700    12.568
     0.800    14.303
     0.900    16.044
     1.000    17.789
     1.100    19.537
     1.200    21.217
     1.300    22.871
     1.400    24.525
     1.500    26.180
     1.600    27.834
     1.700    29.488
     1.800    31.142
     1.900    32.797
     2.000    34.451
     2.100    36.105
     2.200    37.760
     2.300    39.414
     2.400    41.068
     2.500    42.722
     2.600    44.377
     2.700    46.031
     2.800    47.685
     2.900    49.340
     3.000    50.994
     3.100    52.648
     3.200    54.302
     3.300    55.956
     3.400    57.610
     3.500    59.263
     3.600    60.917
     3.700    62.571
     3.800    64.225
     3.900    65.879
     4.000    67.533
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    39.843
     1.200    42.241
     1.300    44.639
     1.400    47.037
     1.500    49.435
     1.600    51.833
     1.700    54.232
     1.800    56.630
     1.900    59.028
     2.000    61.426
     2.100    63.824
     2.200    66.222
     2.300    68.621
     2.400    71.019
     2.500    73.417
     2.600    75.815
     2.700    78.213
     2.800    80.611
     2.900    83.009
     3.000    85.408
     3.100    87.806
     3.200    90.204
     3.300    92.602
     3.400    95.000
     3.500    97.397
     3.600    99.795
     3.700   102.193
     3.800   104.590
     3.900   106.988
     4.000   109.386
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.257
     0.200     7.550
     0.300    10.293
     0.400    13.208
     0.500    16.203
     0.600    19.241
     0.700    22.304
     0.800    25.382
     0.900    28.472
     1.000    31.569
     1.100    34.621
     1.200    37.538
     1.300    40.454
     1.400    43.371
     1.500    46.288
     1.600    49.205
     1.700    52.122
     1.800    55.038
     1.900    57.955
     2.000    60.872
     2.100    63.789
     2.200    66.706
     2.300    69.622
     2.400    72.539
     2.500    75.456
     2.600    78.373
     2.700    81.289
     2.800    84.206
     2.900    87.123
     3.000    90.040
     3.100    92.956
     3.200    95.872
     3.300    98.788
     3.400   101.704
     3.500   104.620
     3.600   107.536
     3.700   110.452
     3.800   113.368
     3.900   116.284
     4.000   119.200
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     1.442   708.181     0.150
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.222    38.068     0.200
     2.353    39.568     0.200
     2.299    38.068     0.200
     2.547    42.068     0.200
     2.532    41.867     0.200
     2.680    43.967     0.200
     2.761    45.658     0.200
     2.962    47.668     0.200
     3.198    51.367     0.200
     3.542    55.668     0.200
     3.542    55.818     0.200
     3.793    59.467     0.200
     3.889    60.568     0.200
     3.889    60.887     0.200
     3.957    62.168     0.200
     4.077    62.729     0.200
     4.084    62.768     0.200
     4.420    67.568     0.200
     4.397    67.967     0.200
     4.462    68.443     0.200
     4.592    69.467     0.200
     4.621    70.467     0.200
     4.722    72.457     0.200
     5.172    77.967     0.200
     5.562    83.367     0.200
     5.562    84.068     0.200
     5.668    84.867     0.200
     5.725    85.768     0.200
     5.906    89.268     0.200
     5.906    89.002     0.200
     5.906    88.467     0.200
     5.863    87.367     0.200
     5.983    91.062     0.200
     5.983    89.441     0.200
     6.034    90.268     0.200
     6.118    91.668     0.200
     6.125    91.277     0.200
     6.231    92.867     0.200
     6.231    92.627     0.200
     6.496    96.498     0.200
     6.594    98.367     0.200
     6.585    96.967     0.200
     6.814   100.867     0.200
     6.870   101.768     0.200
     6.920   102.467     0.200
     7.096   104.367     0.200
     7.096   104.918     0.200
     7.137   103.887     0.200
     7.137   103.648     0.200
     7.137   104.047     0.200
     7.246   106.068     0.200
     7.246   106.268     0.200
     7.216   106.967     0.200
     7.357   108.467     0.200
     7.543   110.668     0.200
     7.547   110.867     0.200
     7.784   113.818     0.200
     7.931   114.758     0.200
     7.948   116.168     0.200
     8.124   118.668     0.200
     8.146   119.467     0.200
     8.451   123.568     0.200
     8.522   125.168     0.200
     8.513   124.668     0.200
     8.592   125.367     0.200
     8.662   126.168     0.200
     8.660   126.068     0.200
     8.658   126.268     0.200
     8.737   127.668     0.200
     8.737   128.277     0.200
     8.776   128.037     0.200
     8.734   125.967     0.200
     8.884   129.678     0.200
     8.922   127.807     0.200
     8.922   128.068     0.200
     9.024   131.967     0.200
     9.114   129.668     0.200
     9.114   130.627     0.200
     9.085   132.678     0.200
     9.269   132.797     0.200
     9.304   135.467     0.200
     9.370   136.068     0.200
     9.476   137.168     0.200
     9.476   137.467     0.200
     9.476   137.787     0.200
     9.542   137.498     0.200
     9.563   139.367     0.200
     9.681   141.168     0.200
     9.748   139.008     0.200
     9.748   138.318     0.200
     9.776   141.178     0.200
     9.908   143.350     0.200
     9.908   142.695     0.200
     9.899   143.979     0.200
     9.951   143.998     0.200
     9.951   143.438     0.200
    10.009   141.328     0.200
     9.986   144.668     0.200
     9.986   146.207     0.200
    10.124   145.867     0.200
    10.124   146.578     0.200
    10.246   147.805     0.200
    10.444   151.047     0.200
    10.498   150.670     0.200
    10.507   150.939     0.200
    10.508   151.691     0.200
    10.655   149.818     0.200
    10.709   155.748     0.200
    10.779   152.953     0.200
    10.779   152.307     0.200
    10.860   156.967     0.200
    10.860   153.848     0.200
    10.860   155.998     0.200
    10.860   154.568     0.200
    10.860   155.479     0.200
    10.860   154.188     0.200
    10.860   153.627     0.200
    10.815   156.367     0.200
    10.876   157.428     0.200
    11.017   157.537     0.200
    10.996   158.291     0.200
    10.996   157.490     0.200
    10.924   156.967     0.200
    10.992   154.557     0.200
    11.043   159.293     0.200
    11.043   158.371     0.200
    11.022   158.467     0.200
    11.037   155.938     0.200
    11.152   160.756     0.200
    11.152   160.488     0.200
    11.088   157.766     0.200
    11.088   157.508     0.200
    11.149   160.537     0.200
    11.287   162.344     0.200
    11.287   161.621     0.200
    11.270   162.568     0.200
    11.474   163.746     0.200
    11.504   165.418     0.200
    11.504   164.857     0.200
    11.504   164.807     0.200
    11.572   164.289     0.200
    11.709   168.213     0.200
    11.709   167.879     0.200
    11.735   167.432     0.200
    11.729   168.768     0.200
    11.837   169.217     0.200
    11.837   169.111     0.200
    11.832   166.768     0.200
    11.909   170.668     0.200
    12.034   171.111     0.200
    12.129   171.158     0.200
    12.214   174.312     0.200
    12.135   174.367     0.200
    12.158   175.068     0.200
    12.273   172.785     0.200
    12.278   175.697     0.200
    12.290   175.113     0.200
    12.249   171.748     0.200
    12.454   178.299     0.200
    12.559   178.650     0.200
    12.488   177.768     0.200
    12.616   179.527     0.200
    12.643   178.408     0.200
    12.684   179.689     0.200
    12.664   177.467     0.200
    12.664   177.289     0.200
    12.664   177.736     0.200
    12.664   177.838     0.200
    12.664   178.127     0.200
    12.664   179.467     0.200
    12.664   178.967     0.200
    12.664   179.105     0.200
    12.759   183.268     0.200
    12.876   184.543     0.200
    12.906   183.062     0.200
    12.906   183.516     0.200
    12.904   184.867     0.200
    12.951   182.967     0.200
    13.038   183.967     0.200
    13.027   182.258     0.200
    13.041   188.090     0.200
    13.037   181.938     0.200
    13.064   187.557     0.200
    13.141   187.158     0.200
    13.058   185.568     0.200
    13.232   188.725     0.200
    13.232   187.846     0.200
    13.231   190.717     0.200
    13.277   188.705     0.200
    13.204   188.967     0.200
    13.301   189.268     0.200
    13.316   190.768     0.200
    13.482   189.068     0.200
    13.495   190.797     0.200
    13.546   191.975     0.200
    13.553   191.998     0.200
    13.579   194.967     0.200
    13.600   194.867     0.200
    13.676   193.607     0.200
    13.695   195.467     0.200
    13.772   195.736     0.200
    13.784   194.611     0.200
    13.784   196.082     0.200
    13.787   193.510     0.200
    13.862   197.867     0.200
    13.929   198.568     0.200
    14.051   198.836     0.200
    14.114   196.467     0.200
    14.114   199.268     0.200
    14.193   201.447     0.200
    14.316   203.787     0.200
    14.346   201.957     0.200
    14.349   202.207     0.200
    14.373   201.547     0.200
    14.362   200.498     0.200
    14.399   202.438     0.200
    14.486   204.768     0.200
    14.695   204.107     0.200
    14.657   203.578     0.200
    14.657   204.068     0.200
    14.657   204.229     0.200
    14.679   210.568     0.200
    14.679   208.281     0.200
    14.679   209.836     0.200
    14.679   207.617     0.200
    14.679   208.967     0.200
    14.679   208.428     0.200
    14.841   210.357     0.200
    14.903   213.463     0.200
    14.976   213.848     0.200
    15.082   211.967     0.200
    15.168   213.281     0.200
    15.147   210.088     0.200
    15.344   212.357     0.200
    15.321   215.258     0.200
    15.573   220.967     0.200
    15.596   219.678     0.200
    15.652   218.115     0.200
    15.652   216.867     0.200
    15.715   217.057     0.200
    15.697   219.545     0.200
    15.707   220.887     0.200
    15.786   218.107     0.200
    15.758   222.979     0.200
    15.787   220.707     0.200
    16.018   221.943     0.200
    16.018   222.768     0.200
    16.360   225.848     0.200
    16.169   222.912     0.200
    16.169   223.848     0.200
    16.169   224.537     0.200
    16.343   227.588     0.200
    16.404   231.217     0.200
    16.542   232.848     0.200
    17.064   235.877     0.200
    17.239   236.088     0.200
    17.250   240.043     0.200
    17.250   240.867     0.200
    17.250   239.467     0.200
    17.283   241.107     0.200
    17.312   241.418     0.200
    17.403   241.816     0.200
    17.483   241.357     0.200
    17.483   242.473     0.200
    17.485   242.068     0.200
    17.485   242.182     0.200
    17.485   242.438     0.200
    17.485   243.867     0.200
    17.485   243.021     0.200
    17.506   245.268     0.200
    17.766   245.467     0.200
    17.974   248.463     0.200
    17.985   249.088     0.200
    18.086   249.414     0.200
    18.086   249.957     0.200
    18.086   249.738     0.200
    18.175   251.736     0.200
    18.148   249.240     0.200
    18.148   250.918     0.200
    18.411   254.025     0.200
    19.348   266.818     0.200
    19.326   266.668     0.200
    19.335   266.768     0.200
    19.335   268.092     0.200
    19.534   270.598     0.200
    19.586   268.738     0.200
    19.667   270.467     0.200
    20.238   275.998     0.200
    20.513   279.018     0.200
    20.817   283.438     0.200
     2.315    39.244     0.200
     2.547    42.645     0.200
     2.693    44.744     0.200
     2.773    47.055     0.200
     2.977    48.445     0.200
     3.213    52.445     0.200
     3.549    57.045     0.200
     3.904    61.145     0.200
     3.904    61.365     0.200
     4.091    64.105     0.200
     4.098    63.844     0.200
     4.435    68.645     0.200
     4.411    68.445     0.200
     4.475    70.895     0.200
     4.607    71.244     0.200
     4.634    71.045     0.200
     4.736    73.125     0.200
     5.183    78.744     0.200
     5.577    85.215     0.200
     5.675    85.844     0.200
     5.735    86.744     0.200
     5.891    86.625     0.200
     5.878    88.045     0.200
     6.041    91.244     0.200
     6.130    92.645     0.200
     6.141    92.465     0.200
     6.235    93.615     0.200
     6.510    97.885     0.200
     6.601    98.545     0.200
     6.933   103.244     0.200
     7.109   104.844     0.200
     7.109   106.125     0.200
     7.130   105.783     0.200
     7.130   105.414     0.200
     7.241   108.045     0.200
     7.241   108.914     0.200
     7.374   109.344     0.200
     7.559   111.945     0.200
     7.564   112.645     0.200
     7.799   116.455     0.200
     7.924   116.734     0.200
     8.161   120.344     0.200
     8.465   124.445     0.200
     8.528   124.645     0.200
     8.677   127.045     0.200
     8.676   127.744     0.200
     8.792   128.744     0.200
     8.900   131.375     0.200
     8.912   129.955     0.200
     9.112   133.314     0.200
     9.258   134.625     0.200
     9.742   140.994     0.200
     9.792   142.785     0.200
     9.913   146.090     0.200
     9.909   143.914     0.200
     9.956   146.303     0.200
    10.001   144.225     0.200
    10.503   153.855     0.200
    10.511   153.244     0.200
    10.647   152.375     0.200
    10.773   152.328     0.200
    10.773   154.174     0.200
    10.865   154.064     0.200
    10.865   159.416     0.200
    11.000   159.385     0.200
    11.000   161.002     0.200
    11.048   161.975     0.200
    11.030   158.605     0.200
    11.091   159.422     0.200
    11.091   158.285     0.200
    11.157   162.414     0.200
    11.286   164.645     0.200
    11.478   167.764     0.200
    11.738   170.344     0.200
    11.841   170.918     0.200
    11.819   171.844     0.200
    11.925   172.445     0.200
    12.035   174.082     0.200
    12.119   171.424     0.200
    12.217   177.447     0.200
    12.273   175.754     0.200
    12.262   176.994     0.200
    12.561   181.666     0.200
    12.649   181.025     0.200
    12.685   181.516     0.200
    12.655   179.375     0.200
    12.655   179.564     0.200
    12.655   180.244     0.200
    12.655   178.445     0.200
    13.316   191.844     0.200
    13.472   190.545     0.200
    13.710   198.045     0.200
    13.878   199.744     0.200
    13.933   197.395     0.200
    13.943   198.344     0.200
    14.052   200.785     0.200
    14.104   198.945     0.200
    14.104   199.945     0.200
    14.333   203.615     0.200
    14.351   201.855     0.200
    14.662   205.914     0.200
    14.662   205.594     0.200
    14.662   206.564     0.200
    14.695   210.939     0.200
    14.695   209.664     0.200
    14.856   211.615     0.200
    15.169   215.328     0.200
    15.334   216.025     0.200
    15.337   217.025     0.200
    15.648   218.984     0.200
    15.705   220.895     0.200
    15.704   221.959     0.200
    15.776   222.445     0.200
    15.798   222.039     0.200
    15.798   221.715     0.200
    16.024   223.395     0.200
    16.024   223.193     0.200
    16.024   223.545     0.200
    16.349   229.564     0.200
    16.159   227.121     0.200
    16.325   229.504     0.200
    17.202   242.145     0.200
    17.236   241.965     0.200
    17.265   241.719     0.200
    17.485   243.148     0.200
    18.097   251.074     0.200
    18.097   250.785     0.200
    18.097   250.625     0.200
    18.157   251.492     0.200
    18.869   260.791     0.200
    19.067   265.244     0.200
    19.138   265.344     0.200
    19.341   267.844     0.200
    19.351   269.246     0.200
    19.652   270.344     0.200
    19.682   271.945     0.200
    20.834   284.574     0.200
     2.306    39.227     0.200
     2.257    39.326     0.200
     2.306    39.027     0.200
     2.494    42.227     0.200
     2.554    42.527     0.200
     2.642    43.826     0.200
     2.800    46.627     0.200
     3.223    52.227     0.200
     3.489    55.727     0.200
     3.489    55.576     0.200
     3.826    61.127     0.200
     3.903    61.996     0.200
     4.050    62.967     0.200
     4.057    62.928     0.200
     4.398    67.826     0.200
     4.427    68.826     0.200
     4.495    70.852     0.200
     4.567    69.727     0.200
     4.588    70.527     0.200
     4.749    73.557     0.200
     5.127    77.527     0.200
     5.615    84.928     0.200
     5.583    84.826     0.200
     5.678    85.826     0.200
     5.922    86.678     0.200
     5.980    89.727     0.200
     6.078    91.428     0.200
     6.173    92.227     0.200
     6.314    91.797     0.200
     6.464    96.557     0.200
     6.882   102.127     0.200
     7.061   104.727     0.200
     7.061   104.967     0.200
     7.189   108.428     0.200
     7.189   107.146     0.200
     7.191   105.957     0.200
     7.351   109.027     0.200
     7.547   111.428     0.200
     7.759   115.297     0.200
     7.986   116.057     0.200
     8.122   119.826     0.200
     8.119   118.727     0.200
     8.681   128.268     0.200
     8.764   128.268     0.200
     8.881   130.877     0.200
     8.970   129.367     0.200
     9.314   134.297     0.200
     9.488   136.826     0.200
     9.765   142.156     0.200
     9.852   143.307     0.200
    10.061   143.588     0.200
    10.707   151.947     0.200
    10.834   153.688     0.200
    11.041   155.938     0.200
    11.147   158.588     0.200
    11.972   169.777     0.200
    12.177   171.518     0.200
    12.714   181.098     0.200
    12.714   180.898     0.200
    12.714   179.857     0.200
    12.714   180.627     0.200
    13.192   187.416     0.200
    13.530   192.326     0.200
    13.503   194.746     0.200
    14.160   199.326     0.200
    14.160   200.428     0.200
    14.406   202.727     0.200
    14.406   203.057     0.200
    14.527   208.197     0.200
    14.693   208.521     0.200
    14.693   208.217     0.200
    14.713   208.377     0.200
    14.713   208.617     0.200
    14.863   211.768     0.200
    15.341   218.107     0.200
    15.578   221.098     0.200
    15.771   225.457     0.200
    15.833   222.166     0.200
    16.009   223.857     0.200
    16.073   225.053     0.200
    16.216   226.826     0.200
    17.284   241.236     0.200
    17.273   241.090     0.200
    17.273   242.428     0.200
    17.509   244.967     0.200
    17.509   245.428     0.200
    18.042   249.666     0.200
    18.042   249.438     0.200
    19.155   264.027     0.200
    20.127   276.607     0.200
    20.201   276.826     0.200
    20.819   284.227     0.200
    21.059   287.428     0.200
     2.234    39.469     0.200
     2.287    39.268     0.200
     2.311    39.768     0.200
     2.533    43.768     0.200
     2.503    42.668     0.200
     2.642    44.268     0.200
     2.964    49.469     0.200
     3.201    52.268     0.200
     3.498    56.668     0.200
     3.498    56.457     0.200
     3.883    61.969     0.200
     3.883    62.719     0.200
     3.959    63.668     0.200
     4.044    64.447     0.200
     4.051    63.668     0.200
     4.404    69.469     0.200
     4.390    68.469     0.200
     4.471    70.773     0.200
     4.560    70.668     0.200
     5.130    78.469     0.200
     5.561    84.568     0.200
     5.683    86.568     0.200
     5.857    88.768     0.200
     5.933    88.787     0.200
     5.990    90.969     0.200
     6.009    94.389     0.200
     6.009    92.158     0.200
     6.079    91.668     0.200
     6.115    92.738     0.200
     6.187    93.498     0.200
     6.322    92.988     0.200
     6.460    97.338     0.200
     6.553    98.969     0.200
     6.801   101.969     0.200
     7.059   105.508     0.200
     7.181   106.100     0.200
     7.181   105.719     0.200
     7.175   106.768     0.200
     7.211   107.678     0.200
     7.337   109.768     0.200
     7.524   112.469     0.200
     7.531   111.768     0.200
     7.752   116.148     0.200
     7.932   116.969     0.200
     7.975   117.389     0.200
     8.105   119.969     0.200
     8.115   120.168     0.200
     8.416   123.367     0.200
     8.480   125.568     0.200
     8.478   125.268     0.200
     8.577   126.668     0.200
     8.632   126.969     0.200
     8.641   127.469     0.200
     8.640   126.768     0.200
     8.752   129.059     0.200
     8.714   126.668     0.200
     8.693   128.367     0.200
     8.693   128.918     0.200
     8.866   130.479     0.200
     8.964   131.617     0.200
     8.964   130.629     0.200
     8.981   131.867     0.200
     9.067   133.117     0.200
     9.075   132.697     0.200
     9.270   134.969     0.200
     9.311   135.607     0.200
     9.339   137.168     0.200
     9.342   137.068     0.200
     9.500   139.068     0.200
     9.499   139.648     0.200
     9.531   140.367     0.200
     9.649   140.367     0.200
     9.753   142.719     0.200
     9.792   141.537     0.200
     9.857   143.617     0.200
     9.864   143.672     0.200
     9.864   143.875     0.200
     9.907   144.830     0.200
     9.907   144.176     0.200
     9.971   148.037     0.200
    10.053   144.607     0.200
    10.104   147.588     0.200
    10.401   151.838     0.200
    10.454   152.117     0.200
    10.463   151.066     0.200
    10.463   152.229     0.200
    10.529   154.791     0.200
    10.699   153.398     0.200
    10.689   156.928     0.200
    10.788   157.367     0.200
    10.823   155.166     0.200
    10.823   155.088     0.200
    10.817   155.973     0.200
    10.817   155.748     0.200
    10.817   156.814     0.200
    10.817   156.438     0.200
    10.817   157.197     0.200
    10.846   158.379     0.200
    10.908   158.367     0.200
    10.908   158.867     0.200
    10.952   157.910     0.200
    10.952   158.768     0.200
    11.000   159.498     0.200
    11.035   156.889     0.200
    11.081   158.998     0.200
    11.125   158.367     0.200
    11.125   158.707     0.200
    11.109   160.676     0.200
    11.109   160.953     0.200
    11.210   162.707     0.200
    11.262   163.768     0.200
    11.243   162.035     0.200
    11.243   162.750     0.200
    11.431   163.443     0.200
    11.460   165.639     0.200
    11.460   166.436     0.200
    11.530   166.451     0.200
    11.665   167.475     0.200
    11.665   168.725     0.200
    11.707   169.568     0.200
    11.693   167.072     0.200
    11.794   169.092     0.200
    11.794   170.398     0.200
    11.775   170.588     0.200
    11.871   169.367     0.200
    11.896   171.867     0.200
    11.992   172.770     0.200
    12.121   175.768     0.200
    12.137   174.867     0.200
    12.172   171.457     0.200
    12.171   175.551     0.200
    12.232   175.637     0.200
    12.246   175.352     0.200
    12.292   174.938     0.200
    12.410   178.791     0.200
    12.516   180.248     0.200
    12.634   182.309     0.200
    12.610   179.637     0.200
    12.643   180.646     0.200
    12.707   180.832     0.200
    12.707   180.258     0.200
    12.707   181.088     0.200
    12.707   181.568     0.200
    12.707   179.867     0.200
    12.707   182.287     0.200
    12.736   183.568     0.200
    12.834   184.932     0.200
    12.886   185.969     0.200
    12.862   183.887     0.200
    12.994   184.059     0.200
    13.005   187.211     0.200
    13.005   187.678     0.200
    13.022   187.746     0.200
    13.058   186.068     0.200
    13.070   185.479     0.200
    13.080   185.328     0.200
    13.183   190.969     0.200
    13.190   187.078     0.200
    13.201   190.268     0.200
    13.192   189.375     0.200
    13.194   189.658     0.200
    13.188   189.301     0.200
    13.220   189.328     0.200
    13.233   190.381     0.200
    13.300   190.668     0.200
    13.300   193.178     0.200
    13.423   192.945     0.200
    13.487   195.418     0.200
    13.525   191.469     0.200
    13.503   192.260     0.200
    13.538   192.357     0.200
    13.590   195.867     0.200
    13.596   191.719     0.200
    13.590   194.230     0.200
    13.691   196.668     0.200
    13.678   196.508     0.200
    13.728   194.971     0.200
    13.741   196.223     0.200
    13.853   199.168     0.200
    13.933   197.768     0.200
    13.984   198.129     0.200
    14.010   200.189     0.200
    14.156   199.268     0.200
    14.156   200.768     0.200
    14.186   202.428     0.200
    14.170   201.998     0.200
    14.333   203.729     0.200
    14.343   205.107     0.200
    14.358   205.188     0.200
    14.361   204.908     0.200
    14.403   201.707     0.200
    14.384   203.299     0.200
    14.464   205.299     0.200
    14.504   206.178     0.200
    14.569   204.318     0.200
    14.673   208.939     0.200
    14.673   210.562     0.200
    14.673   209.059     0.200
    14.673   209.668     0.200
    14.673   208.668     0.200
    14.673   211.822     0.200
    14.690   207.418     0.200
    14.690   206.445     0.200
    14.842   210.639     0.200
    15.124   213.768     0.200
    15.127   216.217     0.200
    15.187   214.438     0.200
    15.320   216.508     0.200
    15.387   215.229     0.200
    15.464   220.367     0.200
    15.561   221.537     0.200
    15.580   220.787     0.200
    15.696   218.270     0.200
    15.702   223.037     0.200
    15.728   221.348     0.200
    15.751   224.238     0.200
    15.757   221.719     0.200
    15.809   223.479     0.200
    15.809   222.488     0.200
    15.828   220.857     0.200
    16.050   224.115     0.200
    16.402   229.617     0.200
    16.211   224.670     0.200
    16.211   225.729     0.200
    16.360   230.398     0.200
    16.377   229.268     0.200
    16.392   231.107     0.200
    16.538   234.188     0.200
    16.693   234.268     0.200
    16.711   236.078     0.200
    17.251   240.789     0.200
    17.251   241.469     0.200
    17.251   240.268     0.200
    17.268   241.828     0.200
    17.282   240.229     0.200
    17.359   242.109     0.200
    17.441   243.520     0.200
    17.487   243.436     0.200
    17.487   243.549     0.200
    17.487   243.697     0.200
    17.487   244.168     0.200
    17.487   243.168     0.200
    17.487   244.797     0.200
    17.706   247.588     0.200
    17.771   246.367     0.200
    17.931   249.551     0.200
    17.960   249.898     0.200
    18.044   250.363     0.200
    18.044   250.107     0.200
    18.044   250.549     0.200
    18.044   249.812     0.200
    18.044   250.229     0.200
    18.126   252.857     0.200
    18.172   251.447     0.200
    18.131   252.303     0.200
    18.368   255.990     0.200
    18.831   262.287     0.200
    19.054   265.168     0.200
    19.325   268.068     0.200
    19.323   269.469     0.200
    19.323   269.219     0.200
    19.323   268.287     0.200
    19.323   269.768     0.200
    19.534   270.857     0.200
    19.595   271.107     0.200
    19.627   271.193     0.200
    20.111   276.287     0.200
    20.117   277.207     0.200
    20.188   277.889     0.200
    20.767   283.648     0.200
    20.802   284.658     0.200
     2.187    38.504     0.200
     2.214    38.703     0.200
     2.244    38.504     0.200
     2.446    41.404     0.200
     2.471    42.104     0.200
     2.567    42.904     0.200
     2.905    48.305     0.200
     3.141    51.504     0.200
     3.441    54.604     0.200
     3.752    60.404     0.200
     3.899    62.703     0.200
     3.963    62.293     0.200
     3.970    61.904     0.200
     4.309    66.805     0.200
     4.422    67.404     0.200
     4.479    69.104     0.200
     4.506    69.604     0.200
     4.670    71.123     0.200
     5.497    83.703     0.200
     5.566    84.004     0.200
     5.616    84.904     0.200
     6.014    89.154     0.200
     6.005    90.203     0.200
     6.042    90.254     0.200
     6.144    92.004     0.200
     6.262    90.805     0.200
     6.482    97.604     0.200
     7.236   105.674     0.200
     9.030   130.305     0.200
    10.113   145.055     0.200
    10.760   152.674     0.200
    10.875   154.293     0.200
    11.075   157.414     0.200
    12.770   182.410     0.200
    12.770   181.635     0.200
    14.688   206.514     0.200
    14.688   207.203     0.200
    16.042   224.531     0.200
    16.279   227.354     0.200
    17.420   242.004     0.200
     2.361    39.400     0.200
     2.587    42.799     0.200
     2.801    46.520     0.200
     3.015    48.600     0.200
     3.252    51.900     0.200
     3.840    60.699     0.200
     3.947    61.400     0.200
     4.010    62.799     0.200
     4.138    63.459     0.200
     4.145    63.500     0.200
     4.508    70.100     0.200
     4.483    68.400     0.200
     4.654    70.600     0.200
     4.680    71.100     0.200
     4.773    73.199     0.200
     5.222    78.400     0.200
     5.617    84.400     0.200
     5.617    85.119     0.200
     5.843    89.648     0.200
     5.843    88.420     0.200
     5.773    86.500     0.200
     5.919    91.166     0.200
     5.921    88.500     0.200
     6.186    91.590     0.200
     6.258    92.650     0.200
     6.408    92.270     0.200
     6.555    97.289     0.200
     6.646    98.799     0.200
     6.877   101.699     0.200
     6.932   102.699     0.200
     6.976   103.000     0.200
     7.100   104.754     0.200
     7.100   104.639     0.200
     7.100   105.160     0.200
     7.154   105.400     0.200
     7.154   105.279     0.200
     7.237   107.299     0.200
     7.237   108.850     0.200
     7.421   109.799     0.200
     7.606   111.799     0.200
     7.610   112.199     0.200
     7.896   115.680     0.200
     7.846   115.029     0.200
     8.011   117.799     0.200
     8.188   119.900     0.200
     8.209   120.199     0.200
     8.511   124.199     0.200
     8.554   123.299     0.200
     8.575   125.199     0.200
     8.655   126.000     0.200
     8.724   128.000     0.200
     8.725   127.199     0.200
     8.876   128.209     0.200
     8.771   129.170     0.200
     8.798   129.100     0.200
     8.841   128.830     0.200
     8.948   131.289     0.200
     9.219   133.549     0.200
     9.118   130.600     0.200
     9.118   132.879     0.200
     9.148   133.820     0.200
     9.412   136.900     0.200
     9.412   138.586     0.200
     9.566   139.949     0.200
     9.714   140.119     0.200
     9.968   142.959     0.200
     9.840   142.520     0.200
     9.938   145.793     0.200
     9.938   145.906     0.200
     9.947   144.449     0.200
     9.980   146.525     0.200
    10.048   146.699     0.200
    10.048   147.270     0.200
    10.187   147.500     0.200
    10.187   147.119     0.200
    10.371   144.850     0.200
    10.613   150.520     0.200
    10.526   153.945     0.200
    10.534   154.287     0.200
    10.534   153.990     0.200
    10.536   154.146     0.200
    10.604   154.852     0.200
    10.604   155.150     0.200
    10.745   152.947     0.200
    10.773   157.980     0.200
    10.947   154.629     0.200
    10.879   158.000     0.200
    10.887   157.719     0.200
    10.887   156.549     0.200
    10.887   155.760     0.200
    10.887   158.924     0.200
    10.887   158.268     0.200
    10.887   156.760     0.200
    11.089   157.609     0.200
    11.023   159.654     0.200
    11.023   160.475     0.200
    11.073   161.414     0.200
    11.194   160.600     0.200
    11.179   161.977     0.200
    11.179   163.061     0.200
    11.330   165.199     0.200
    11.316   164.406     0.200
    11.316   164.848     0.200
    11.498   166.482     0.200
    11.534   167.998     0.200
    11.534   168.180     0.200
    11.587   167.295     0.200
    11.776   168.000     0.200
    11.740   170.379     0.200
    11.754   169.701     0.200
    11.864   170.357     0.200
    11.970   172.699     0.200
    12.083   169.240     0.200
    12.049   173.721     0.200
    12.206   171.939     0.200
    12.222   175.600     0.200
    12.236   176.432     0.200
    12.283   174.645     0.200
    12.317   177.430     0.200
    12.579   181.209     0.200
    12.620   178.258     0.200
    12.620   178.430     0.200
    12.620   179.244     0.200
    12.620   177.859     0.200
    12.620   178.533     0.200
    12.620   178.010     0.200
    12.620   179.799     0.200
    12.549   179.000     0.200
    12.577   181.168     0.200
    12.657   180.314     0.200
    12.698   181.383     0.200
    12.907   182.100     0.200
    12.983   181.820     0.200
    12.975   185.439     0.200
    12.994   181.609     0.200
    12.922   187.111     0.200
    12.939   185.439     0.200
    12.967   186.100     0.200
    13.098   185.010     0.200
    13.113   187.799     0.200
    13.100   189.371     0.200
    13.260   191.299     0.200
    13.289   191.693     0.200
    13.289   192.344     0.200
    13.303   191.539     0.200
    13.436   189.000     0.200
    13.356   191.699     0.200
    13.324   190.719     0.200
    13.451   188.020     0.200
    13.506   190.160     0.200
    13.620   195.240     0.200
    13.589   194.529     0.200
    13.685   197.510     0.200
    13.752   198.199     0.200
    13.904   196.320     0.200
    13.923   200.500     0.200
    13.996   201.139     0.200
    13.980   197.500     0.200
    14.065   199.299     0.200
    14.065   198.549     0.200
    14.064   201.252     0.200
    14.270   203.480     0.200
    14.285   203.369     0.200
    14.285   203.010     0.200
    14.311   199.889     0.200
    14.311   201.000     0.200
    14.312   203.709     0.200
    14.253   203.869     0.200
    14.393   206.061     0.200
    14.481   203.129     0.200
    14.577   208.299     0.200
    14.667   205.191     0.200
    14.738   211.883     0.200
    14.738   209.609     0.200
    14.738   210.100     0.200
    14.896   210.570     0.200
    15.033   211.900     0.200
    15.094   210.703     0.200
    15.094   210.289     0.200
    15.182   215.979     0.200
    15.297   214.090     0.200
    15.377   217.061     0.200
    15.627   217.471     0.200
    15.668   218.699     0.200
    15.635   222.020     0.200
    15.714   220.105     0.200
    15.659   222.980     0.200
    15.765   223.910     0.200
    15.819   222.279     0.200
    15.819   222.109     0.200
    15.817   225.010     0.200
    16.311   227.359     0.200
    16.033   222.574     0.200
    16.033   222.873     0.200
    16.121   223.924     0.200
    16.121   224.660     0.200
    16.121   226.854     0.200
    16.280   229.020     0.200
    16.291   229.420     0.200
    16.245   229.699     0.200
    16.652   234.539     0.200
    16.599   234.260     0.200
    16.745   234.900     0.200
    17.217   237.770     0.200
    17.242   242.600     0.200
    17.303   238.250     0.200
    17.303   242.799     0.200
    17.303   239.799     0.200
    17.346   243.889     0.200
    17.501   245.084     0.200
    17.538   243.510     0.200
    17.538   243.770     0.200
    17.538   245.600     0.200
    17.538   243.100     0.200
    17.538   242.217     0.200
    17.538   245.330     0.200
    17.652   246.660     0.200
    17.993   250.695     0.200
    18.049   251.150     0.200
    18.175   251.820     0.200
    18.175   251.070     0.200
    18.137   250.281     0.200
    18.137   250.180     0.200
    18.137   250.811     0.200
    18.137   250.449     0.200
    18.198   253.404     0.200
    18.909   262.369     0.200
    19.105   266.500     0.200
    19.412   268.430     0.200
    19.397   268.521     0.200
    19.397   268.920     0.200
    19.397   268.170     0.200
    19.525   268.750     0.200
    19.719   272.000     0.200
    20.190   277.420     0.200
    20.963   285.930     0.200
     2.364    39.867     0.200
     2.588    43.469     0.200
     2.593    43.268     0.200
     2.742    45.168     0.200
     2.800    47.678     0.200
     3.016    49.268     0.200
     3.253    52.668     0.200
     3.587    56.568     0.200
     3.587    57.418     0.200
     3.841    61.969     0.200
     3.950    62.568     0.200
     3.950    62.748     0.200
     4.011    63.367     0.200
     4.143    65.398     0.200
     4.447    69.568     0.200
     4.508    70.418     0.200
     4.488    69.568     0.200
     4.659    71.268     0.200
     4.685    72.168     0.200
     4.774    74.488     0.200
     5.228    79.168     0.200
     5.619    85.268     0.200
     5.619    85.568     0.200
     5.713    86.668     0.200
     5.838    86.998     0.200
     6.076    91.668     0.200
     6.189    93.129     0.200
     6.178    92.867     0.200
     6.263    93.768     0.200
     6.263    93.438     0.200
     6.413    92.648     0.200
     6.560    97.867     0.200
     7.095   104.438     0.200
     7.095   105.418     0.200
     7.159   106.918     0.200
     7.851   116.979     0.200
     8.845   129.049     0.200
     8.870   129.188     0.200
     8.870   128.418     0.200
     8.870   129.367     0.200
     9.213   133.389     0.200
     9.962   142.928     0.200
    10.607   151.379     0.200
    10.740   153.594     0.200
    10.740   153.469     0.200
    11.085   158.117     0.200
    11.771   172.268     0.200
    12.077   169.707     0.200
    12.614   179.598     0.200
    12.614   178.338     0.200
    12.614   177.287     0.200
    12.614   178.217     0.200
    13.092   187.219     0.200
    14.060   198.867     0.200
    14.306   201.418     0.200
    14.306   200.639     0.200
    14.663   204.379     0.200
    14.663   205.268     0.200
    14.663   205.639     0.200
    14.897   208.738     0.200
    15.041   215.809     0.200
    15.817   221.117     0.200
    16.029   222.568     0.200
    17.305   239.492     0.200
    18.142   251.258     0.200
    20.108   275.979     0.200
     2.225    38.619     0.200
     2.288    39.119     0.200
     2.528    42.721     0.200
     2.655    44.119     0.200
     2.766    46.500     0.200
     2.959    48.920     0.200
     3.195    52.420     0.200
     3.515    55.920     0.200
     3.794    60.820     0.200
     3.881    61.520     0.200
     3.881    61.840     0.200
     3.953    63.221     0.200
     4.061    62.920     0.200
     4.399    68.721     0.200
     4.397    68.119     0.200
     4.596    70.221     0.200
     5.641    85.320     0.200
     5.698    86.420     0.200
     6.007    90.020     0.200
     6.092    91.820     0.200
     6.205    93.020     0.200
     6.205    92.609     0.200
     6.568    97.721     0.200
    10.806   154.602     0.200
    12.691   179.475     0.200
    14.674   207.514     0.200
     2.326    40.514     0.200
     2.435    40.713     0.200
     2.655    44.611     0.200
     3.082    50.412     0.200
     4.019    63.514     0.200
     4.076    64.814     0.200
     4.208    64.604     0.200
     4.567    69.264     0.200
     4.837    73.771     0.200
     5.686    87.111     0.200
     5.686    86.635     0.200
     5.749    87.111     0.200
     5.825    88.111     0.200
     6.233    94.014     0.200
     6.284    94.412     0.200
     6.260    94.123     0.200
     6.452    92.053     0.200
     6.622    97.924     0.200
     6.703   100.514     0.200
     7.218   105.494     0.200
     7.916   115.791     0.200
     8.915   130.135     0.200
     8.827   128.271     0.200
     9.023   132.494     0.200
     9.926   143.072     0.200
    10.570   152.033     0.200
    10.712   154.283     0.200
    10.898   155.951     0.200
    12.574   178.432     0.200
    12.574   178.213     0.200
    14.686   206.654     0.200
    14.686   207.584     0.200
    14.963   209.592     0.200
    15.836   221.252     0.200
    16.057   223.838     0.200
    17.605   244.252     0.200
    17.629   244.791     0.200
    18.212   251.502     0.200
     2.365    39.676     0.200
     2.332    39.875     0.200
     2.254    38.973     0.200
     2.566    43.074     0.200
     2.791    46.883     0.200
     3.232    53.375     0.200
     3.548    56.875     0.200
     3.548    56.715     0.200
     3.922    61.676     0.200
     3.922    62.285     0.200
     3.990    64.074     0.200
     4.494    68.875     0.200
     4.755    73.703     0.200
     6.039    90.973     0.200
     6.230    93.176     0.200
     7.132   105.855     0.200
     8.911   129.965     0.200
    10.002   144.414     0.200
    10.647   151.652     0.200
    10.776   154.426     0.200
    10.981   156.344     0.200
    12.118   170.145     0.200
    12.655   178.668     0.200
    12.655   178.812     0.200
    13.471   190.453     0.200
    14.348   202.375     0.200
    14.676   207.902     0.200
    14.875   208.734     0.200
    16.040   224.398     0.200
     2.259    39.398     0.200
     2.405    40.801     0.200
     2.356    40.301     0.200
     2.593    43.801     0.200
     2.580    43.598     0.200
     2.792    46.961     0.200
     3.008    49.398     0.200
     3.245    53.098     0.200
     3.587    57.398     0.200
     3.587    57.500     0.200
     3.832    61.199     0.200
     3.942    61.699     0.200
     3.942    62.758     0.200
     4.139    65.180     0.200
     4.146    64.699     0.200
     4.483    68.898     0.200
     4.439    69.000     0.200
     4.500    68.926     0.200
     4.654    71.500     0.200
     4.681    72.398     0.200
     4.766    74.320     0.200
     5.713    86.199     0.200
     5.611    85.398     0.200
     5.611    85.758     0.200
     5.777    87.000     0.200
     5.844    86.840     0.200
     6.077    91.801     0.200
     6.266    93.000     0.200
     6.266    93.621     0.200
     6.181    93.160     0.200
     6.413    94.160     0.200
     7.094   105.141     0.200
     7.889   114.910     0.200
     8.185   121.000     0.200
     8.870   128.918     0.200
     8.870   128.539     0.200
     9.215   133.188     0.200
     9.707   139.551     0.200
     9.962   143.141     0.200
    10.364   145.180     0.200
    10.608   151.660     0.200
    10.738   154.039     0.200
    10.941   155.500     0.200
    10.993   157.469     0.200
    11.079   158.688     0.200
    11.325   163.000     0.200
    11.773   168.801     0.200
    12.078   171.688     0.200
    12.201   172.590     0.200
    12.615   179.301     0.200
    12.615   179.469     0.200
    12.615   178.777     0.200
    12.615   179.770     0.200
    12.615   178.199     0.200
    12.615   178.590     0.200
    12.901   182.500     0.200
    12.978   183.168     0.200
    12.989   182.109     0.200
    13.094   187.051     0.200
    13.254   189.500     0.200
    13.350   189.801     0.200
    13.445   188.660     0.200
    13.746   195.898     0.200
    13.898   196.668     0.200
    13.917   198.801     0.200
    14.061   199.000     0.200
    14.307   202.359     0.200
    14.657   205.719     0.200
    14.657   205.609     0.200
    14.733   207.918     0.200
    14.733   208.379     0.200
    14.733   210.000     0.200
    14.889   212.039     0.200
    15.034   216.070     0.200
    15.371   217.219     0.200
    15.630   219.949     0.200
    15.663   221.059     0.200
    15.733   222.020     0.200
    16.307   229.641     0.200
    16.023   223.324     0.200
    16.239   230.000     0.200
    16.286   229.059     0.200
    17.209   240.809     0.200
    17.296   242.898     0.200
    17.342   241.820     0.200
    17.531   244.320     0.200
    17.531   245.598     0.200
    17.531   242.898     0.200
    17.555   243.598     0.200
    18.141   250.340     0.200
    18.141   251.188     0.200
    18.165   252.480     0.200
    19.095   264.098     0.200
    19.608   270.000     0.200
    20.456   279.098     0.200
     2.213    38.605     0.200
     2.295    39.004     0.200
     2.359    40.105     0.200
     2.525    42.906     0.200
     2.555    42.906     0.200
     2.751    46.793     0.200
     2.954    48.703     0.200
     3.191    52.305     0.200
     3.550    56.504     0.200
     3.785    60.805     0.200
     3.883    61.504     0.200
     3.883    61.746     0.200
     3.949    63.305     0.200
     4.079    63.414     0.200
     4.086    63.605     0.200
     4.389    69.105     0.200
     4.453    69.281     0.200
     4.421    68.203     0.200
     4.593    70.605     0.200
     4.624    71.004     0.200
     4.714    73.285     0.200
     5.177    78.203     0.200
     5.555    84.605     0.200
     5.676    85.504     0.200
     5.731    86.605     0.200
     5.907    85.883     0.200
     5.857    88.004     0.200
     6.042    90.906     0.200
     6.120    92.066     0.200
     6.123    92.406     0.200
     6.240    93.105     0.200
     6.374    92.676     0.200
     6.499    97.684     0.200
     6.600    99.203     0.200
     6.810   101.703     0.200
     6.925   103.805     0.200
     7.129   105.109     0.200
     7.129   105.406     0.200
     7.100   105.406     0.200
     7.100   105.805     0.200
     7.257   107.406     0.200
     7.257   107.605     0.200
     7.223   107.406     0.200
     7.923   115.434     0.200
     7.786   116.246     0.200
     7.945   117.305     0.200
     8.122   119.504     0.200
     8.454   124.004     0.200
     8.589   126.305     0.200
     8.776   128.246     0.200
     8.746   128.844     0.200
     8.915   129.043     0.200
     8.881   130.375     0.200
     9.032   132.305     0.200
     9.264   134.176     0.200
     9.125   131.746     0.200
     9.264   134.805     0.200
     9.477   136.305     0.200
     9.477   139.965     0.200
     9.477   140.238     0.200
     9.739   140.316     0.200
     9.775   142.215     0.200
    10.001   143.105     0.200
     9.905   145.086     0.200
     9.961   145.551     0.200
    10.121   147.227     0.200
    10.648   151.734     0.200
    10.516   151.699     0.200
    10.770   154.230     0.200
    10.770   153.926     0.200
    10.985   155.836     0.200
    10.870   157.586     0.200
    10.870   158.766     0.200
    10.870   156.645     0.200
    10.870   157.105     0.200
    10.870   157.973     0.200
    11.028   157.906     0.200
    11.077   158.219     0.200
    11.077   157.883     0.200
    11.162   161.906     0.200
    11.265   163.504     0.200
    11.484   165.809     0.200
    11.513   167.184     0.200
    11.827   169.203     0.200
    11.718   169.688     0.200
    11.746   169.766     0.200
    11.847   171.305     0.200
    12.122   171.234     0.200
    12.045   172.766     0.200
    12.242   172.426     0.200
    12.224   174.195     0.200
    12.284   173.539     0.200
    12.462   181.566     0.200
    12.657   179.156     0.200
    12.657   179.027     0.200
    12.657   179.297     0.200
    12.657   179.879     0.200
    12.657   179.703     0.200
    12.569   180.184     0.200
    12.661   177.301     0.200
    12.695   180.160     0.200
    12.944   183.176     0.200
    13.019   183.484     0.200
    13.029   182.734     0.200
    13.143   185.363     0.200
    13.051   186.605     0.200
    13.197   190.004     0.200
    13.294   190.406     0.200
    13.475   190.105     0.200
    13.488   190.113     0.200
    13.547   191.254     0.200
    13.688   196.805     0.200
    13.932   196.586     0.200
    13.857   198.906     0.200
    14.108   198.504     0.200
    14.108   199.805     0.200
    14.062   200.094     0.200
    14.356   201.434     0.200
    14.356   201.574     0.200
    14.520   203.695     0.200
    14.645   204.754     0.200
    14.645   206.281     0.200
    14.645   204.984     0.200
    14.674   207.848     0.200
    14.674   206.824     0.200
    14.674   210.105     0.200
    14.834   209.684     0.200
    15.076   211.406     0.200
    14.972   214.926     0.200
    15.142   212.512     0.200
    15.142   211.754     0.200
    15.338   214.156     0.200
    15.315   217.434     0.200
    15.569   221.043     0.200
    15.708   219.734     0.200
    15.686   220.305     0.200
    15.780   219.883     0.200
    15.701   221.754     0.200
    15.777   222.156     0.200
    15.752   225.145     0.200
    16.007   222.828     0.200
    16.007   224.891     0.200
    16.354   227.875     0.200
    16.163   225.660     0.200
    16.163   224.875     0.200
    16.327   227.855     0.200
    16.685   234.203     0.200
    17.229   239.695     0.200
    17.243   240.254     0.200
    17.243   242.203     0.200
    17.243   239.906     0.200
    17.280   242.316     0.200
    17.404   243.004     0.200
    17.413   242.461     0.200
    17.472   243.379     0.200
    17.478   243.785     0.200
    17.478   244.211     0.200
    17.478   243.516     0.200
    17.478   245.203     0.200
    17.478   242.805     0.200
    17.478   244.910     0.200
    17.478   242.656     0.200
    17.499   246.105     0.200
    17.984   250.441     0.200
    17.984   250.105     0.200
    18.137   251.941     0.200
    18.137   252.234     0.200
    18.091   251.250     0.200
    18.091   251.664     0.200
    18.091   250.625     0.200
    18.185   253.773     0.200
    18.843   262.227     0.200
    19.228   267.586     0.200
    19.400   268.273     0.200
    19.400   268.125     0.200
    19.576   271.141     0.200
    19.671   270.406     0.200
     2.286    39.547     0.200
     2.392    40.547     0.200
     2.371    40.746     0.200
     2.574    43.047     0.200
     2.602    43.848     0.200
     2.820    47.020     0.200
     3.031    49.848     0.200
     3.267    54.449     0.200
     3.568    56.629     0.200
     3.960    61.848     0.200
     4.025    64.047     0.200
     4.137    64.316     0.200
     4.144    64.047     0.200
     4.464    70.047     0.200
     4.484    69.148     0.200
     4.789    74.227     0.200
     5.214    79.047     0.200
     5.695    86.148     0.200
     5.632    85.746     0.200
     5.632    84.719     0.200
     5.763    87.047     0.200
     6.166    92.949     0.200
     6.242    93.348     0.200
     6.242    93.109     0.200
     6.197    92.797     0.200
     6.396    92.797     0.200
     6.638    99.348     0.200
     7.217   106.797     0.200
     7.846   115.168     0.200
    10.760   152.906     0.200
    14.688   207.586     0.200
    14.688   208.277     0.200
    16.054   224.023     0.200
    19.407   269.938     0.200
     2.339    39.527     0.200
     2.316    40.430     0.200
     2.618    44.129     0.200
     2.856    47.109     0.200
     3.050    50.727     0.200
     3.286    53.629     0.200
     3.510    56.129     0.200
     3.510    55.887     0.200
     3.968    62.578     0.200
     4.103    63.539     0.200
     4.110    63.930     0.200
     4.555    71.652     0.200
     4.637    71.227     0.200
     4.812    73.180     0.200
     5.636    85.629     0.200
     5.647    85.328     0.200
     5.710    86.227     0.200
     6.119    92.227     0.200
     6.180    92.348     0.200
     6.199    92.719     0.200
     6.339    92.348     0.200
    12.688   179.098     0.200
    16.108   226.777     0.200
     2.265    39.375     0.200
     2.345    39.375     0.200
     2.531    42.375     0.200
     2.571    42.973     0.200
     3.238    53.375     0.200
     3.924    62.375     0.200
     3.996    63.875     0.200
     4.439    69.176     0.200
     4.504    69.398     0.200
     5.166    78.375     0.200
     5.166    78.875     0.200
     5.600    85.574     0.200
     5.652    85.973     0.200
     6.016    91.074     0.200
    10.799   155.090     0.200
    12.676   178.020     0.200
    14.698   207.984     0.200
     2.280    39.414     0.200
     2.363    40.016     0.200
     2.569    42.715     0.200
     2.595    43.816     0.200
     2.815    47.074     0.200
     3.024    49.715     0.200
     3.260    53.414     0.200
     3.563    56.816     0.200
     3.563    56.707     0.200
     3.852    61.215     0.200
     3.953    62.316     0.200
     4.019    63.914     0.200
     4.457    69.414     0.200
     4.520    69.891     0.200
     4.783    74.914     0.200
     5.625    85.574     0.200
     5.689    86.215     0.200
     6.052    90.715     0.200
     6.159    92.914     0.200
     6.189    92.805     0.200
     6.238    93.516     0.200
     6.390    92.805     0.200
     6.631    99.617     0.200
    12.638   179.461     0.200
    16.052   225.742     0.200
    17.312   240.789     0.200
     2.247    39.125     0.200
     2.318    39.125     0.200
     2.350    40.125     0.200
     2.540    42.824     0.200
     2.555    42.926     0.200
     2.785    46.805     0.200
     2.985    49.125     0.200
     3.221    52.223     0.200
     3.534    56.125     0.200
     3.534    56.453     0.200
     3.817    61.223     0.200
     3.910    61.676     0.200
     3.979    63.125     0.200
     4.084    64.363     0.200
     4.091    63.625     0.200
     4.421    69.223     0.200
     4.430    68.023     0.200
     4.486    70.301     0.200
     4.600    71.223     0.200
     4.625    70.926     0.200
     4.745    72.996     0.200
     5.170    78.426     0.200
     5.584    84.895     0.200
     5.660    85.625     0.200
     5.722    86.523     0.200
     5.894    84.793     0.200
     5.894    85.023     0.200
     6.025    90.723     0.200
     6.119    91.926     0.200
     6.145    91.926     0.200
     6.218    92.824     0.200
     6.218    93.086     0.200
     6.359    92.434     0.200
     6.501    97.004     0.200
     6.593    99.324     0.200
     7.146   104.336     0.200
     7.146   106.723     0.200
     7.146   106.016     0.200
     7.940   114.074     0.200
     8.926   129.805     0.200
     8.926   129.594     0.200
     9.271   132.523     0.200
     9.463   134.723     0.200
    10.016   142.062     0.200
    10.662   151.254     0.200
    10.789   153.070     0.200
    10.789   153.895     0.200
    12.133   171.312     0.200
    12.669   179.543     0.200
    12.669   180.125     0.200
    12.669   179.137     0.200
    14.117   199.426     0.200
    14.117   199.613     0.200
    14.363   200.785     0.200
    14.679   206.453     0.200
    14.679   206.426     0.200
    14.700   211.723     0.200
    14.864   211.473     0.200
    15.665   218.770     0.200
    16.041   223.598     0.200
    16.172   226.293     0.200
    16.172   227.242     0.200
    18.084   250.535     0.200
    18.084   250.125     0.200
    18.084   250.746     0.200
    18.172   252.016     0.200
     2.431    40.746     0.200
     3.325    54.746     0.200
     3.589    57.348     0.200
     3.913    62.945     0.200
     4.020    63.148     0.200
     4.083    65.148     0.200
     4.193    65.246     0.200
     4.520    70.945     0.200
     4.580    72.547     0.200
     4.722    72.148     0.200
     5.247    79.848     0.200
     5.715    86.746     0.200
     5.691    86.445     0.200
     6.204    93.148     0.200
     6.249    93.648     0.200
    12.607   176.539     0.200
     2.297    39.633     0.200
     2.611    43.832     0.200
     3.040    50.434     0.200
     3.277    53.730     0.200
     3.968    62.730     0.200
     4.035    64.133     0.200
     5.206    78.730     0.200
     5.641    85.832     0.200
     5.684    85.832     0.200
     5.755    87.230     0.200
     6.160    92.832     0.200
     6.229    93.633     0.200
     6.631    99.531     0.200
    12.641   179.176     0.200
     2.254    39.004     0.200
     2.358    39.906     0.200
     2.546    43.305     0.200
     2.563    43.406     0.200
     2.791    46.395     0.200
     2.993    49.707     0.200
     3.230    53.406     0.200
     3.541    56.504     0.200
     3.541    56.215     0.200
     3.825    61.504     0.200
     3.919    62.504     0.200
     3.919    61.914     0.200
     3.988    64.004     0.200
     4.094    63.977     0.200
     4.101    63.707     0.200
     4.440    68.707     0.200
     4.493    68.918     0.200
     4.635    70.707     0.200
     4.753    73.566     0.200
     5.179    78.207     0.200
     5.593    84.504     0.200
     5.667    86.105     0.200
     5.730    86.707     0.200
     6.031    90.906     0.200
     6.128    92.504     0.200
     6.154    92.254     0.200
     6.223    92.906     0.200
     6.602    99.105     0.200
    12.662   179.684     0.200
     2.223    38.660     0.200
     2.302    38.961     0.200
     2.497    41.961     0.200
     2.520    42.762     0.200
     3.188    52.660     0.200
     3.492    55.461     0.200
     3.791    61.160     0.200
     3.870    61.359     0.200
     3.947    62.562     0.200
     4.039    62.762     0.200
     4.392    68.762     0.200
     4.460    70.086     0.200
     4.548    69.961     0.200
     4.574    70.160     0.200
     5.122    77.262     0.200
     5.618    85.359     0.200
     5.675    86.359     0.200
     5.985    90.562     0.200
     6.069    91.160     0.200
     6.184    92.961     0.200
    12.714   178.504     0.200
    16.044   222.086     0.200
     2.261    39.406     0.200
     2.312    38.906     0.200
     2.313    39.305     0.200
     2.500    41.906     0.200
     2.560    43.109     0.200
     2.804    47.156     0.200
     2.991    49.305     0.200
     3.228    52.508     0.200
     3.495    55.406     0.200
     3.495    55.883     0.200
     3.830    61.008     0.200
     3.909    61.703     0.200
     3.986    63.008     0.200
     4.057    63.039     0.200
     4.064    62.906     0.200
     4.432    69.109     0.200
     4.406    68.406     0.200
     4.499    70.008     0.200
     4.575    70.703     0.200
     4.595    70.703     0.200
     4.754    73.508     0.200
     5.134    78.305     0.200
     5.588    84.609     0.200
     5.588    84.477     0.200
     5.621    85.008     0.200
     5.685    86.203     0.200
     5.915    88.555     0.200
     5.985    90.305     0.200
     6.085    91.906     0.200
     6.140    91.984     0.200
     6.178    92.609     0.200
     6.178    92.273     0.200
     6.320    91.766     0.200
     6.471    96.898     0.200
     6.558    98.203     0.200
     6.825   102.109     0.200
     6.889   102.109     0.200
     7.186   105.875     0.200
     7.186   106.445     0.200
     7.068   105.008     0.200
     7.546   111.406     0.200
     7.980   114.727     0.200
     8.964   129.758     0.200
     8.964   129.219     0.200
     9.307   134.047     0.200
     9.481   138.305     0.200
    10.055   143.914     0.200
    10.701   151.812     0.200
    10.829   153.438     0.200
    10.829   153.883     0.200
    11.034   155.797     0.200
    11.145   158.836     0.200
    11.288   163.406     0.200
    12.171   171.289     0.200
    12.708   179.984     0.200
    12.708   179.125     0.200
    12.708   179.305     0.200
    12.708   179.648     0.200
    13.186   187.945     0.200
    13.227   189.609     0.200
    13.524   191.609     0.200
    14.154   199.406     0.200
    14.154   198.586     0.200
    14.211   204.867     0.200
    14.713   205.453     0.200
    14.713   207.367     0.200
    14.869   210.008     0.200
    14.985   215.180     0.200
    15.182   211.914     0.200
    15.347   215.219     0.200
    15.585   220.469     0.200
    15.706   219.680     0.200
    15.728   222.078     0.200
    16.073   224.008     0.200
    16.073   224.766     0.200
    16.209   224.914     0.200
    17.278   241.133     0.200
    17.291   243.117     0.200
    17.830   248.859     0.200
    18.048   250.312     0.200
    18.048   249.977     0.200
    19.246   267.289     0.200
     2.294    39.422     0.200
     3.021    50.125     0.200
     3.257    53.625     0.200
     3.478    55.422     0.200
     3.934    61.523     0.200
     4.016    63.625     0.200
     4.413    68.320     0.200
     4.463    70.125     0.200
     4.531    70.898     0.200
     4.596    70.820     0.200
     5.604    84.422     0.200
     5.673    85.719     0.200
     6.080    91.820     0.200
     6.154    91.922     0.200
     6.550    98.523     0.200
    10.849   155.375     0.200
    12.722   180.742     0.200
    12.722   181.367     0.200
    14.746   208.367     0.200
    19.644   271.984     0.200
    19.644   271.047     0.200
     2.335    40.248     0.200
     2.404    40.049     0.200
     2.645    43.549     0.200
     2.870    47.759     0.200
     3.075    50.049     0.200
     3.311    53.549     0.200
     3.543    56.248     0.200
     3.906    62.349     0.200
     3.998    63.248     0.200
     3.998    62.639     0.200
     4.069    64.849     0.200
     4.143    63.868     0.200
     4.150    64.448     0.200
     4.495    68.748     0.200
     4.510    69.948     0.200
     4.574    71.224     0.200
     4.662    71.248     0.200
     4.677    71.748     0.200
     4.835    74.479     0.200
     5.201    78.748     0.200
     5.669    85.648     0.200
     5.674    86.148     0.200
     5.674    85.818     0.200
     5.746    86.948     0.200
     5.824    84.629     0.200
     6.158    92.948     0.200
     6.207    92.948     0.200
     6.232    93.188     0.200
     6.372    92.969     0.200
     6.553    98.099     0.200
     6.626    99.549     0.200
     6.918   103.148     0.200
     7.143   105.108     0.200
     7.166   106.448     0.200
     7.166   106.328     0.200
     7.639   113.448     0.200
     7.939   114.668     0.200
     8.906   128.519     0.200
     8.906   128.658     0.200
     9.242   134.219     0.200
    10.005   144.028     0.200
    10.649   151.438     0.200
    10.791   153.248     0.200
    10.791   153.769     0.200
    10.977   155.118     0.200
    12.113   169.958     0.200
    12.653   179.179     0.200
    12.653   179.667     0.200
    12.653   178.898     0.200
    12.653   178.104     0.200
    12.653   178.698     0.200
    13.465   188.879     0.200
    13.465   189.538     0.200
    14.091   198.818     0.200
    14.091   198.429     0.200
    14.739   206.549     0.200
    14.739   205.541     0.200
    14.789   210.269     0.200
    14.789   210.143     0.200
    14.789   209.769     0.200
    14.954   212.828     0.200
    15.113   211.788     0.200
    15.682   217.777     0.200
    16.106   226.424     0.200
    16.106   224.695     0.200
    16.148   225.188     0.200
    17.363   243.198     0.200
    18.115   250.918     0.200
    18.115   251.148     0.200
    19.338   269.059     0.200
     2.355    40.511     0.200
     2.663    44.811     0.200
     3.094    50.811     0.200
     3.330    54.511     0.200
     3.536    56.211     0.200
     3.926    62.811     0.200
     4.016    63.511     0.200
     4.089    64.811     0.200
     4.155    64.811     0.200
     4.530    70.711     0.200
     4.594    71.936     0.200
     4.680    71.211     0.200
     5.198    79.011     0.200
     5.662    85.811     0.200
     5.742    87.411     0.200
     6.021    90.911     0.200
     6.157    92.811     0.200
     6.195    93.211     0.200
     6.624    99.311     0.200
    12.660   180.154     0.200
    16.126   226.735     0.200
     2.278    39.352     0.200
     2.367    39.652     0.200
     2.812    46.871     0.200
     3.025    50.051     0.200
     3.575    56.750     0.200
     3.575    57.281     0.200
     3.851    62.352     0.200
     3.955    62.551     0.200
     3.955    62.371     0.200
     4.019    64.051     0.200
     4.145    64.852     0.200
     4.457    69.652     0.200
     4.484    69.652     0.200
     4.518    69.879     0.200
     4.783    73.730     0.200
     5.218    78.551     0.200
     5.626    85.449     0.200
     5.626    86.121     0.200
     6.249    93.949     0.200
     6.554    97.430     0.200
    10.753   153.324     0.200
    14.679   204.992     0.200
    16.044   223.152     0.200
     2.261    39.184     0.200
     2.795    46.895     0.200
     3.242    53.684     0.200
     3.568    56.582     0.200
     3.833    61.484     0.200
     3.936    62.184     0.200
     3.936    61.613     0.200
     4.000    62.883     0.200
     4.122    63.863     0.200
     4.129    64.383     0.200
     4.439    69.383     0.200
     4.467    68.984     0.200
     4.501    69.133     0.200
     4.664    71.781     0.200
     4.764    74.043     0.200
     5.207    79.184     0.200
     5.607    85.984     0.200
     5.607    85.234     0.200
     5.758    87.184     0.200
     6.157    92.582     0.200
     6.174    92.805     0.200
     6.247    93.281     0.200
     6.247    93.004     0.200
     6.394    92.352     0.200
     6.539    98.332     0.200
     6.631    99.582     0.200
     7.113   105.773     0.200
    10.758   154.031     0.200
    12.634   178.527     0.200
    12.634   180.137     0.200
    14.670   205.266     0.200
    16.034   222.383     0.200
    16.034   223.449     0.200
     2.313    39.680     0.200
     3.047    50.480     0.200
     3.283    53.379     0.200
     3.509    56.082     0.200
     3.883    62.480     0.200
     3.965    63.082     0.200
     4.042    64.281     0.200
     4.453    68.680     0.200
     4.486    70.180     0.200
     4.552    72.031     0.200
     4.635    71.180     0.200
     5.709    86.582     0.200
     6.180    92.680     0.200
    10.821   153.930     0.200
    12.689   178.875     0.200
    12.689   178.648     0.200
    14.743   205.824     0.200
    16.106   224.379     0.200
     2.656    44.773     0.200
     3.088    51.074     0.200
     3.324    54.074     0.200
     4.006    63.273     0.200
     4.082    64.273     0.200
     4.135    64.273     0.200
     4.483    69.672     0.200
     4.526    70.473     0.200
     4.592    73.148     0.200
     5.177    78.172     0.200
     5.641    85.574     0.200
     6.136    92.672     0.200
     6.175    92.473     0.200
    10.821   153.047     0.200
    12.681   179.617     0.200
    12.681   178.723     0.200
    14.770   209.898     0.200
    16.135   224.547     0.200
    16.135   225.965     0.200
     2.230    38.750     0.200
     2.263    38.750     0.200
     2.519    42.648     0.200
     2.777    46.398     0.200
     2.952    48.648     0.200
     3.188    52.051     0.200
     3.456    54.848     0.200
     3.456    54.980     0.200
     3.797    61.051     0.200
     3.863    61.348     0.200
     3.863    61.461     0.200
     3.946    62.648     0.200
     4.004    62.840     0.200
     4.011    62.348     0.200
     4.352    67.551     0.200
     4.396    68.648     0.200
     4.466    70.023     0.200
     4.466    71.750     0.200
     4.521    69.750     0.200
     4.543    70.051     0.200
     4.716    72.277     0.200
     5.087    77.449     0.200
     5.546    84.449     0.200
     5.546    84.250     0.200
     5.582    84.348     0.200
     5.640    85.250     0.200
     5.949    89.551     0.200
     5.969    88.238     0.200
     6.036    90.648     0.200
     6.091    91.730     0.200
     6.149    92.148     0.200
     6.149    92.270     0.200
     6.280    91.289     0.200
     6.419    95.910     0.200
     6.510    97.250     0.200
     7.017   104.879     0.200
     7.222   105.699     0.200
     9.007   129.980     0.200
     9.354   134.641     0.200
    10.095   143.961     0.200
    10.741   153.199     0.200
    10.864   154.348     0.200
    10.864   154.578     0.200
    11.078   156.379     0.200
    11.913   171.449     0.200
    12.214   171.828     0.200
    12.750   181.367     0.200
    12.750   179.379     0.200
    12.750   178.504     0.200
    12.750   180.551     0.200
    12.750   179.949     0.200
    13.567   192.148     0.200
    14.199   199.250     0.200
    14.446   204.070     0.200
    14.711   208.449     0.200
    14.711   208.012     0.200
    14.827   210.598     0.200
    15.230   212.949     0.200
    16.068   224.449     0.200
    16.068   223.023     0.200
    16.254   225.699     0.200
    18.001   249.250     0.200
    18.001   248.770     0.200
    19.199   265.051     0.200
    19.715   273.648     0.200
    20.740   283.488     0.200
    20.774   283.398     0.200
     2.255    39.261     0.200
     2.341    39.461     0.200
     2.383    40.361     0.200
     2.571    43.361     0.200
     2.571    43.261     0.200
     2.790    46.781     0.200
     3.000    48.961     0.200
     3.236    53.461     0.200
     3.566    56.861     0.200
     3.566    56.731     0.200
     3.827    61.061     0.200
     3.930    61.961     0.200
     3.994    63.761     0.200
     4.117    64.431     0.200
     4.124    64.261     0.200
     4.433    69.261     0.200
     4.495    70.173     0.200
     4.462    69.061     0.200
     4.633    71.461     0.200
     4.659    71.361     0.200
     4.758    74.021     0.200
     5.204    78.961     0.200
     5.601    85.561     0.200
     5.601    85.001     0.200
     5.692    86.161     0.200
     5.755    87.361     0.200
     6.056    91.461     0.200
     6.167    92.471     0.200
     6.153    92.361     0.200
     6.246    93.161     0.200
     6.246    92.841     0.200
     6.535    97.351     0.200
     6.627    99.861     0.200
     7.115   105.321     0.200
     7.133   105.761     0.200
     7.586   111.861     0.200
     8.188   120.961     0.200
    10.759   153.672     0.200
    12.637   178.930     0.200
    12.637   179.183     0.200
    12.637   179.711     0.200
    14.667   205.023     0.200
    14.720   209.305     0.200
    16.031   222.411     0.200
    16.031   223.187     0.200
    17.288   240.011     0.200
    17.517   243.261     0.200
     2.301    39.898     0.200
     2.401    40.398     0.200
     2.426    40.898     0.200
     2.625    44.299     0.200
     2.606    43.600     0.200
     2.831    47.568     0.200
     3.052    49.600     0.200
     3.289    53.799     0.200
     3.600    57.299     0.200
     3.600    57.488     0.200
     3.874    62.100     0.200
     3.987    62.898     0.200
     4.047    63.898     0.200
     4.174    64.869     0.200
     4.181    64.898     0.200
     4.482    69.998     0.200
     4.541    70.674     0.200
     4.520    69.299     0.200
     4.690    71.398     0.200
     4.809    73.869     0.200
     4.713    72.299     0.200
     5.249    79.498     0.200
     5.655    85.398     0.200
     5.655    86.209     0.200
     5.804    84.949     0.200
     5.804    86.398     0.200
     5.726    86.699     0.200
     5.798    87.398     0.200
     5.960    90.398     0.200
     6.088    91.699     0.200
     6.226    93.289     0.200
     6.202    93.398     0.200
     6.269    93.600     0.200
     6.428    92.998     0.200
     6.589    98.338     0.200
     6.689    99.100     0.200
     6.674   100.199     0.200
     7.084   104.338     0.200
     7.084   104.799     0.200
     7.007   104.799     0.200
     7.186   106.328     0.200
     7.225   107.799     0.200
     7.646   113.398     0.200
     7.880   113.889     0.200
     7.882   116.338     0.200
     8.228   120.898     0.200
     8.245   121.199     0.200
     8.546   125.699     0.200
     8.695   127.600     0.200
     8.852   127.398     0.200
     8.852   128.100     0.200
     8.762   128.199     0.200
     8.880   129.898     0.200
     8.988   131.350     0.200
     9.193   132.199     0.200
     9.188   134.838     0.200
     9.114   134.049     0.200
     9.373   135.299     0.200
     9.373   134.408     0.200
     9.700   138.988     0.200
     9.781   140.338     0.200
     9.948   142.539     0.200
     9.880   143.529     0.200
     9.972   144.908     0.200
    10.243   144.998     0.200
    10.228   148.748     0.200
    10.593   150.850     0.200
    10.731   153.021     0.200
    10.731   153.199     0.200
    10.923   155.100     0.200
    10.983   156.408     0.200
    10.897   157.439     0.200
    11.096   157.998     0.200
    11.247   160.189     0.200
    11.746   168.498     0.200
    12.060   170.498     0.200
    12.175   175.729     0.200
    12.598   178.719     0.200
    12.598   178.443     0.200
    12.598   177.947     0.200
    12.598   178.299     0.200
    12.598   178.998     0.200
    12.598   178.568     0.200
    12.589   180.898     0.200
    12.935   185.668     0.200
    13.070   185.139     0.200
    13.150   187.600     0.200
    13.213   191.078     0.200
    13.412   189.199     0.200
    13.394   190.799     0.200
    13.791   198.100     0.200
    13.888   195.988     0.200
    14.040   197.799     0.200
    14.040   197.398     0.200
    14.285   200.729     0.200
    14.245   202.619     0.200
    14.680   204.479     0.200
    14.680   204.186     0.200
    14.680   204.209     0.200
    14.690   210.100     0.200
    14.778   210.844     0.200
    14.778   208.039     0.200
    14.933   210.609     0.200
    15.007   210.699     0.200
    15.078   216.010     0.200
    15.272   214.498     0.200
    15.415   217.260     0.200
    15.619   215.826     0.200
    15.619   215.998     0.200
    15.644   219.488     0.200
    15.713   220.318     0.200
    15.675   220.988     0.200
    15.845   222.338     0.200
    15.804   223.789     0.200
    16.286   227.850     0.200
    16.049   223.049     0.200
    16.049   221.844     0.200
    16.097   223.908     0.200
    16.097   222.900     0.200
    16.270   227.488     0.200
    16.782   235.699     0.200
    17.210   239.988     0.200
    17.340   241.299     0.200
    17.340   242.100     0.200
    17.502   245.100     0.200
    17.570   245.373     0.200
    17.575   244.689     0.200
    17.575   244.299     0.200
    18.088   250.648     0.200
    18.198   251.029     0.200
    18.164   252.010     0.200
    18.164   250.850     0.200
    19.142   266.299     0.200
    19.334   268.738     0.200
    20.102   275.998     0.200
    20.920   285.318     0.200
     2.289    39.918     0.200
     2.372    40.016     0.200
     2.387    40.117     0.200
     2.570    42.816     0.200
     2.604    44.016     0.200
     2.823    47.508     0.200
     3.033    49.715     0.200
     3.269    53.316     0.200
     3.564    56.617     0.200
     3.564    56.465     0.200
     3.861    61.918     0.200
     3.961    62.215     0.200
     3.961    62.586     0.200
     4.027    63.918     0.200
     4.135    64.348     0.200
     4.142    64.117     0.200
     4.466    69.816     0.200
     4.482    68.918     0.200
     4.528    70.617     0.200
     4.652    71.215     0.200
     4.673    71.715     0.200
     4.792    74.488     0.200
     5.210    79.117     0.200
     5.634    85.816     0.200
     5.690    86.117     0.200
     5.759    86.816     0.200
     5.841    88.445     0.200
     5.935    89.715     0.200
     6.052    91.215     0.200
     6.198    92.668     0.200
     6.549    97.828     0.200
     6.634    99.316     0.200
     6.887   103.016     0.200
     7.119   104.328     0.200
     7.119   105.277     0.200
     7.146   105.715     0.200
     7.146   105.867     0.200
     7.843   115.926     0.200
     8.194   120.215     0.200
     8.207   121.016     0.200
     8.506   124.816     0.200
     8.724   127.215     0.200
     8.844   129.535     0.200
     8.890   128.266     0.200
     8.955   131.258     0.200
     9.232   132.777     0.200
     9.408   138.117     0.200
     9.408   136.938     0.200
     9.844   142.828     0.200
     9.985   142.566     0.200
    10.630   150.895     0.200
    10.765   153.523     0.200
    10.765   153.316     0.200
    10.765   152.977     0.200
    10.962   154.965     0.200
    11.786   168.316     0.200
    12.098   170.328     0.200
    12.636   179.137     0.200
    12.636   179.484     0.200
    12.636   178.285     0.200
    12.636   178.699     0.200
    12.636   178.918     0.200
    13.110   186.297     0.200
    13.450   188.117     0.200
    14.079   197.418     0.200
    14.079   197.816     0.200
    14.266   202.996     0.200
    14.324   199.348     0.200
    14.693   205.516     0.200
    14.693   205.723     0.200
    14.693   205.977     0.200
    14.752   209.938     0.200
    14.752   210.836     0.200
    14.913   211.105     0.200
    15.048   215.617     0.200
    15.393   217.145     0.200
    15.649   216.160     0.200
    15.646   220.977     0.200
    15.779   221.488     0.200
    16.058   222.391     0.200
    16.135   223.977     0.200
    16.135   223.371     0.200
    16.477   230.977     0.200
    17.321   240.867     0.200
    17.321   241.715     0.200
    17.321   240.316     0.200
    17.355   243.137     0.200
    17.483   243.516     0.200
    17.556   244.707     0.200
    17.556   243.488     0.200
    17.556   244.316     0.200
    18.051   249.586     0.200
    18.124   250.246     0.200
    18.124   250.715     0.200
    18.124   250.348     0.200
    19.083   264.617     0.200
    19.737   272.016     0.200
    20.889   285.238     0.200
    20.986   287.016     0.200
     2.291    40.352     0.200
     2.398    40.852     0.200
     2.439    41.551     0.200
     2.618    44.648     0.200
     2.621    44.250     0.200
     2.819    47.809     0.200
     3.045    50.449     0.200
     3.281    52.949     0.200
     3.615    57.750     0.200
     3.615    58.000     0.200
     3.864    61.648     0.200
     3.982    62.750     0.200
     3.982    63.070     0.200
     4.039    64.449     0.200
     4.181    65.141     0.200
     4.188    65.148     0.200
     4.473    70.051     0.200
     4.531    70.602     0.200
     4.526    70.148     0.200
     4.697    72.852     0.200
     4.722    72.750     0.200
     4.800    74.789     0.200
     5.261    79.949     0.200
     5.648    86.051     0.200
     5.648    86.262     0.200
     5.741    87.449     0.200
     5.800    88.281     0.200
     5.810    88.148     0.200
     5.955    90.449     0.200
     6.103    92.250     0.200
     6.213    93.648     0.200
     6.223    93.570     0.200
     6.285    94.148     0.200
     6.285    94.371     0.200
     6.442    93.570     0.200
     6.597    99.039     0.200
     6.689   100.648     0.200
     6.685   100.250     0.200
     6.915   103.551     0.200
     6.971   104.051     0.200
     7.017   104.449     0.200
     7.069   104.352     0.200
     7.069   105.219     0.200
     7.195   107.352     0.200
     7.195   107.070     0.200
     7.242   107.949     0.200
     7.242   107.422     0.200
     7.647   113.750     0.200
     7.864   115.711     0.200
     7.888   116.449     0.200
     8.228   121.250     0.200
     8.251   122.449     0.200
     8.767   128.648     0.200
     8.801   129.148     0.200
     8.839   128.410     0.200
     8.882   130.410     0.200
     8.988   131.840     0.200
     9.132   132.520     0.200
     9.180   133.109     0.200
     9.188   135.641     0.200
     9.370   136.750     0.200
     9.370   137.766     0.200
     9.370   137.391     0.200
     9.590   139.238     0.200
     9.684   139.738     0.200
     9.766   141.961     0.200
     9.882   143.930     0.200
     9.934   142.629     0.200
     9.966   145.680     0.200
     9.985   145.340     0.200
    10.008   145.586     0.200
    10.008   146.129     0.200
    10.087   148.859     0.200
    10.228   149.559     0.200
    10.342   145.078     0.200
    10.579   151.109     0.200
    10.553   153.312     0.200
    10.553   154.117     0.200
    10.563   153.938     0.200
    10.715   153.375     0.200
    10.715   153.070     0.200
    10.910   154.559     0.200
    10.914   158.609     0.200
    10.914   157.719     0.200
    10.914   159.402     0.200
    10.914   158.938     0.200
    10.968   156.840     0.200
    11.049   159.348     0.200
    11.049   161.090     0.200
    11.079   157.230     0.200
    11.101   160.652     0.200
    11.101   160.973     0.200
    11.206   162.234     0.200
    11.206   162.996     0.200
    11.344   165.027     0.200
    11.522   167.094     0.200
    11.562   167.461     0.200
    11.606   168.621     0.200
    11.736   168.551     0.200
    11.769   169.977     0.200
    11.776   171.289     0.200
    11.890   170.992     0.200
    12.046   170.191     0.200
    12.068   174.637     0.200
    12.171   173.191     0.200
    12.174   175.781     0.200
    12.260   176.871     0.200
    12.260   177.875     0.200
    12.299   178.398     0.200
    12.512   182.078     0.200
    12.585   178.602     0.200
    12.585   178.918     0.200
    12.585   178.199     0.200
    12.585   178.457     0.200
    12.585   179.047     0.200
    12.585   178.781     0.200
    12.599   180.750     0.200
    12.599   181.434     0.200
    12.716   180.879     0.200
    12.871   182.320     0.200
    12.948   183.020     0.200
    12.960   182.770     0.200
    13.142   188.715     0.200
    13.213   189.109     0.200
    13.330   192.332     0.200
    13.399   188.949     0.200
    13.388   191.750     0.200
    13.415   190.070     0.200
    13.469   190.699     0.200
    13.559   196.270     0.200
    13.785   198.051     0.200
    13.873   196.691     0.200
    13.851   197.246     0.200
    13.958   200.750     0.200
    14.028   197.352     0.200
    14.008   197.648     0.200
    14.082   200.852     0.200
    14.082   202.801     0.200
    14.213   202.789     0.200
    14.273   198.980     0.200
    14.273   201.148     0.200
    14.275   202.852     0.200
    14.288   204.539     0.200
    14.316   202.828     0.200
    14.444   202.648     0.200
    14.664   205.750     0.200
    14.664   205.902     0.200
    14.664   207.031     0.200
    14.773   209.441     0.200
    14.773   213.148     0.200
    14.773   213.469     0.200
    14.926   211.590     0.200
    14.995   210.852     0.200
    15.055   210.672     0.200
    15.077   216.270     0.200
    15.259   213.711     0.200
    15.342   218.602     0.200
    15.408   217.441     0.200
    15.602   216.742     0.200
    15.631   218.691     0.200
    15.673   221.898     0.200
    15.700   219.379     0.200
    15.798   224.250     0.200
    16.273   227.500     0.200
    16.032   223.500     0.200
    16.032   223.191     0.200
    16.084   222.648     0.200
    16.256   227.691     0.200
    17.194   239.352     0.200
    17.333   241.875     0.200
    17.333   240.852     0.200
    17.385   243.578     0.200
    17.451   243.520     0.200
    17.495   244.352     0.200
    17.567   243.621     0.200
    17.567   244.949     0.200
    17.567   244.551     0.200
    17.622   246.898     0.200
    18.090   250.359     0.200
    18.176   251.898     0.200
    18.176   252.352     0.200
    18.176   252.691     0.200
    18.176   252.570     0.200
    18.283   253.691     0.200
    18.456   257.531     0.200
    18.915   262.758     0.200
    19.134   265.750     0.200
    19.412   270.352     0.200
    19.434   270.410     0.200
    20.229   277.730     0.200
    20.499   281.949     0.200
    20.919   285.570     0.200
     2.334    39.876     0.200
     2.387    40.176     0.200
     2.409    39.776     0.200
     2.561    42.676     0.200
     2.647    43.976     0.200
     2.869    47.566     0.200
     3.077    49.776     0.200
     3.313    53.276     0.200
     3.555    55.976     0.200
     3.555    56.226     0.200
     3.906    61.776     0.200
     4.002    62.376     0.200
     4.002    62.766     0.200
     4.071    64.076     0.200
     4.153    64.216     0.200
     4.159    64.076     0.200
     4.511    69.976     0.200
     4.504    68.876     0.200
     4.574    70.951     0.200
     4.671    71.476     0.200
     4.687    71.476     0.200
     4.836    74.316     0.200
     5.072    76.336     0.200
     5.212    78.876     0.200
     5.677    85.876     0.200
     5.677    85.476     0.200
     5.681    85.476     0.200
     5.758    86.776     0.200
     5.815    88.176     0.200
     5.815    88.356     0.200
     5.815    88.646     0.200
     5.815    87.476     0.200
     5.892    89.226     0.200
     5.892    90.721     0.200
     5.892    89.530     0.200
     5.976    89.476     0.200
     6.041    90.676     0.200
     6.169    92.276     0.200
     6.218    92.776     0.200
     6.218    92.546     0.200
     6.236    92.836     0.200
     6.384    91.496     0.200
     6.563    97.266     0.200
     6.637    98.976     0.200
     6.687    99.776     0.200
     6.924   102.676     0.200
     6.977   104.076     0.200
     6.975   103.876     0.200
     7.132   104.946     0.200
     7.173   106.076     0.200
     7.173   106.506     0.200
     7.157   106.076     0.200
     7.157   105.296     0.200
     7.253   107.876     0.200
     7.459   109.876     0.200
     7.646   112.876     0.200
     7.653   113.176     0.200
     7.862   115.116     0.200
     7.928   115.416     0.200
     8.055   118.576     0.200
     8.227   120.576     0.200
     8.227   120.776     0.200
     8.518   124.476     0.200
     8.521   124.576     0.200
     8.590   125.976     0.200
     8.699   127.876     0.200
     8.737   127.676     0.200
     8.737   128.736     0.200
     8.747   127.276     0.200
     8.763   128.276     0.200
     8.762   128.276     0.200
     8.872   129.166     0.200
     8.835   128.976     0.200
     8.894   128.726     0.200
     8.988   131.036     0.200
     9.044   132.276     0.200
     9.060   131.186     0.200
     9.231   132.946     0.200
     9.189   133.736     0.200
     9.380   136.876     0.200
     9.380   137.616     0.200
     9.380   137.815     0.200
     9.378   136.676     0.200
     9.430   137.976     0.200
     9.522   138.786     0.200
     9.640   140.576     0.200
     9.749   141.356     0.200
     9.759   142.076     0.200
     9.830   140.631     0.200
     9.830   143.126     0.200
     9.872   143.016     0.200
     9.900   143.867     0.200
     9.900   145.382     0.200
     9.994   142.386     0.200
     9.932   144.606     0.200
     9.941   144.347     0.200
     9.941   145.460     0.200
    10.069   146.176     0.200
    10.094   146.276     0.200
    10.094   147.226     0.200
    10.226   148.176     0.200
    10.226   147.906     0.200
    10.233   147.062     0.200
    10.469   152.676     0.200
    10.469   152.206     0.200
    10.486   153.266     0.200
    10.493   150.246     0.200
    10.493   152.212     0.200
    10.496   151.437     0.200
    10.638   150.486     0.200
    10.780   153.076     0.200
    10.780   153.146     0.200
    10.816   153.486     0.200
    10.810   157.076     0.200
    10.846   154.176     0.200
    10.846   154.706     0.200
    10.846   154.320     0.200
    10.846   156.056     0.200
    10.846   155.085     0.200
    10.846   154.576     0.200
    10.846   157.505     0.200
    10.846   155.816     0.200
    10.854   156.976     0.200
    10.906   158.276     0.200
    10.966   154.446     0.200
    10.959   158.756     0.200
    11.031   156.996     0.200
    10.982   157.996     0.200
    10.982   159.968     0.200
    11.031   159.276     0.200
    11.031   160.436     0.200
    11.034   159.313     0.200
    11.034   160.671     0.200
    11.066   159.776     0.200
    11.150   158.733     0.200
    11.150   158.846     0.200
    11.177   161.316     0.200
    11.138   159.821     0.200
    11.138   162.244     0.200
    11.258   159.526     0.200
    11.277   162.198     0.200
    11.277   164.217     0.200
    11.383   164.976     0.200
    11.454   163.249     0.200
    11.454   164.134     0.200
    11.508   165.087     0.200
    11.536   165.173     0.200
    11.676   168.176     0.200
    11.703   167.868     0.200
    11.703   170.074     0.200
    11.706   168.244     0.200
    11.779   167.776     0.200
    11.823   169.722     0.200
    11.823   171.010     0.200
    11.828   170.676     0.200
    11.998   172.244     0.200
    12.019   172.976     0.200
    12.102   170.586     0.200
    12.230   173.566     0.200
    12.191   176.284     0.200
    12.228   174.021     0.200
    12.243   176.476     0.200
    12.259   176.776     0.200
    12.276   174.878     0.200
    12.465   179.986     0.200
    12.553   178.856     0.200
    12.528   180.254     0.200
    12.642   177.676     0.200
    12.642   178.008     0.200
    12.642   178.716     0.200
    12.642   180.483     0.200
    12.642   178.186     0.200
    12.642   177.476     0.200
    12.642   179.339     0.200
    12.642   179.046     0.200
    12.642   178.906     0.200
    12.599   180.776     0.200
    12.601   179.244     0.200
    12.634   177.546     0.200
    12.646   181.254     0.200
    12.857   184.676     0.200
    12.928   181.276     0.200
    12.904   183.790     0.200
    12.904   184.564     0.200
    12.905   186.363     0.200
    13.006   184.066     0.200
    13.019   183.986     0.200
    13.009   186.476     0.200
    13.095   189.106     0.200
    13.107   188.383     0.200
    13.107   189.094     0.200
    13.173   187.476     0.200
    13.262   189.014     0.200
    13.294   191.091     0.200
    13.296   190.264     0.200
    13.318   191.376     0.200
    13.327   190.986     0.200
    13.454   189.176     0.200
    13.471   188.076     0.200
    13.423   192.476     0.200
    13.423   193.356     0.200
    13.522   189.186     0.200
    13.522   193.744     0.200
    13.562   191.176     0.200
    13.567   192.866     0.200
    13.693   195.869     0.200
    13.712   197.176     0.200
    13.741   194.756     0.200
    13.794   196.364     0.200
    13.809   198.076     0.200
    13.798   197.914     0.200
    13.936   195.536     0.200
    13.944   195.956     0.200
    13.974   200.276     0.200
    14.011   199.998     0.200
    14.080   197.476     0.200
    14.043   201.176     0.200
    14.080   196.176     0.200
    14.097   201.576     0.200
    14.210   203.636     0.200
    14.221   204.186     0.200
    14.283   205.426     0.200
    14.306   204.386     0.200
    14.348   206.196     0.200
    14.371   201.706     0.200
    14.439   204.646     0.200
    14.476   203.261     0.200
    14.500   202.326     0.200
    14.583   204.176     0.200
    14.629   209.076     0.200
    14.629   209.946     0.200
    14.732   207.906     0.200
    14.732   205.941     0.200
    14.732   206.276     0.200
    14.732   208.056     0.200
    14.793   210.776     0.200
    14.793   210.278     0.200
    14.793   211.407     0.200
    14.793   211.786     0.200
    14.793   210.976     0.200
    14.793   212.596     0.200
    14.793   211.136     0.200
    14.956   212.626     0.200
    15.047   209.976     0.200
    15.014   215.667     0.200
    15.102   210.192     0.200
    15.084   215.576     0.200
    15.129   215.245     0.200
    15.313   212.916     0.200
    15.342   217.146     0.200
    15.436   218.356     0.200
    15.671   218.852     0.200
    15.671   217.676     0.200
    15.685   217.666     0.200
    15.683   223.456     0.200
    15.702   222.806     0.200
    15.754   218.666     0.200
    15.781   221.440     0.200
    15.822   221.826     0.200
    15.820   225.636     0.200
    15.888   221.799     0.200
    15.888   222.476     0.200
    15.871   225.816     0.200
    16.326   226.526     0.200
    16.099   223.576     0.200
    16.099   223.968     0.200
    16.137   223.993     0.200
    16.137   223.617     0.200
    16.137   221.876     0.200
    16.315   227.236     0.200
    16.514   233.786     0.200
    16.656   234.976     0.200
    16.807   235.176     0.200
    17.263   239.186     0.200
    17.302   242.676     0.200
    17.365   241.726     0.200
    17.365   240.576     0.200
    17.365   241.576     0.200
    17.390   243.606     0.200
    17.425   243.536     0.200
    17.452   242.551     0.200
    17.526   244.276     0.200
    17.594   245.301     0.200
    17.600   244.076     0.200
    17.600   243.828     0.200
    17.600   244.496     0.200
    17.600   243.476     0.200
    17.600   244.876     0.200
    17.600   245.589     0.200
    17.600   244.367     0.200
    17.880   247.376     0.200
    18.079   251.116     0.200
    18.126   250.521     0.200
    18.126   250.676     0.200
    18.126   250.296     0.200
    18.126   251.336     0.200
    18.154   253.394     0.200
    18.244   252.055     0.200
    18.244   252.856     0.200
    18.887   263.296     0.200
    18.954   263.986     0.200
    19.167   266.876     0.200
    19.238   267.356     0.200
    19.343   268.586     0.200
    19.445   270.316     0.200
    19.445   269.425     0.200
    19.782   272.576     0.200
    20.152   276.383     0.200
    20.889   284.936     0.200
     2.452    42.035     0.200
     2.623    44.535     0.200
     2.678    45.435     0.200
     3.341    55.235     0.200
     3.616    57.935     0.200
     4.040    64.235     0.200
     4.216    64.885     0.200
     4.222    66.235     0.200
     4.533    71.835     0.200
     4.565    71.335     0.200
     4.592    73.635     0.200
     5.113    78.435     0.200
     5.113    76.805     0.200
     5.276    80.235     0.200
     5.756    88.735     0.200
     5.756    86.375     0.200
     5.708    86.305     0.200
     6.234    93.935     0.200
     6.272    94.335     0.200
     6.272    93.705     0.200
     6.279    93.655     0.200
     6.445    93.195     0.200
     6.627    98.945     0.200
     6.702   101.035     0.200
     6.740   101.335     0.200
     7.074   105.495     0.200
     7.040   105.235     0.200
     7.222   107.535     0.200
     7.222   107.165     0.200
     7.512   111.235     0.200
     7.870   115.745     0.200
     7.925   116.565     0.200
     8.279   123.235     0.200
     8.831   128.615     0.200
     8.831   128.245     0.200
     8.795   128.615     0.200
     8.808   129.035     0.200
     8.929   130.295     0.200
     9.039   132.585     0.200
     9.098   132.585     0.200
     9.167   133.735     0.200
     9.324   135.935     0.200
     9.324   136.545     0.200
     9.933   142.965     0.200
     9.929   144.265     0.200
    10.576   150.805     0.200
    10.722   153.210     0.200
    10.722   153.335     0.200
    10.722   153.845     0.200
    10.862   158.335     0.200
    10.793   155.195     0.200
    10.903   154.795     0.200
    11.118   158.835     0.200
    12.039   171.435     0.200
    12.124   175.585     0.200
    12.115   170.595     0.200
    12.460   180.165     0.200
    12.494   181.805     0.200
    12.509   176.865     0.200
    12.580   179.925     0.200
    12.580   179.354     0.200
    12.580   178.155     0.200
    12.580   180.633     0.200
    12.580   179.235     0.200
    12.580   178.515     0.200
    13.043   186.205     0.200
    13.161   190.165     0.200
    14.016   197.735     0.200
    14.016   198.035     0.200
    14.068   201.035     0.200
    14.259   201.025     0.200
    14.346   204.705     0.200
    14.709   207.260     0.200
    15.619   218.517     0.200
    16.080   224.260     0.200
    17.393   244.560     0.200
    17.555   245.535     0.200
     2.305    39.859     0.200
     2.402    40.759     0.200
     2.392    40.359     0.200
     2.581    43.459     0.200
     2.623    43.659     0.200
     2.838    47.419     0.200
     3.052    49.959     0.200
     3.288    53.859     0.200
     3.982    62.859     0.200
     3.982    62.249     0.200
     4.046    64.259     0.200
     4.154    64.509     0.200
     4.161    65.359     0.200
     4.502    68.959     0.200
     4.545    70.109     0.200
     4.671    71.859     0.200
     4.692    71.759     0.200
     4.810    74.239     0.200
     5.103    77.079     0.200
     5.701    86.659     0.200
     5.653    85.799     0.200
     5.773    87.159     0.200
     5.820    87.149     0.200
     6.179    93.159     0.200
     6.243    93.559     0.200
     6.243    93.039     0.200
     6.219    93.119     0.200
     6.403    92.089     0.200
     6.568    98.189     0.200
     7.110   105.399     0.200
     7.164   105.999     0.200
     8.226   121.059     0.200
     8.976   131.079     0.200
     9.865   143.529     0.200
     9.974   144.279     0.200
    10.619   152.409     0.200
    10.949   155.859     0.200
    12.624   179.128     0.200
    12.624   179.289     0.200
    14.772   208.053     0.200
    16.066   224.759     0.200
    17.340   240.934     0.200
    18.139   251.619     0.200
     3.609    57.650     0.200
     3.609    57.230     0.200
     4.077    65.250     0.200
     4.233    65.040     0.200
     4.239    66.150     0.200
     4.585    70.650     0.200
     4.633    71.333     0.200
     4.764    72.550     0.200
     5.086    77.480     0.200
     5.734    86.150     0.200
     5.733    83.500     0.200
     5.733    88.060     0.200
     5.747    87.650     0.200
     5.821    88.150     0.200
     6.090    92.250     0.200
     6.255    93.650     0.200
     6.255    93.850     0.200
     6.240    94.050     0.200
     6.440    92.760     0.200
     7.003   105.550     0.200
     7.048   104.950     0.200
     7.085   103.660     0.200
     7.232   106.780     0.200
     7.943   117.000     0.200
     8.834   128.630     0.200
     9.166   132.170     0.200
     9.940   142.110     0.200
    10.583   150.570     0.200
    10.736   153.175     0.200
    10.736   153.670     0.200
    10.907   155.270     0.200
    11.707   169.050     0.200
    12.042   169.940     0.200
    12.175   173.220     0.200
    12.509   176.220     0.200
    12.585   178.997     0.200
    12.585   178.710     0.200
    12.585   179.736     0.200
    12.585   179.970     0.200
    12.950   183.320     0.200
    12.964   182.280     0.200
    13.413   189.030     0.200
    14.017   197.840     0.200
    14.258   200.920     0.200
    14.744   207.540     0.200
    14.744   205.962     0.200
    14.744   207.220     0.200
    14.868   213.037     0.200
    15.025   212.070     0.200
    15.507   217.620     0.200
    15.638   219.855     0.200
    16.075   224.410     0.200
    16.117   224.399     0.200
    16.117   224.657     0.200
    17.433   242.243     0.200
    17.662   244.298     0.200
    18.193   250.380     0.200
    18.193   252.000     0.200
     2.301    39.415     0.200
     2.353    40.115     0.200
     2.329    39.714     0.200
     2.601    43.615     0.200
     2.509    42.015     0.200
     2.841    46.955     0.200
     3.033    49.214     0.200
     3.269    53.314     0.200
     3.503    55.845     0.200
     3.870    61.714     0.200
     3.951    62.515     0.200
     3.951    62.875     0.200
     4.028    63.814     0.200
     4.088    63.475     0.200
     4.095    64.015     0.200
     4.472    69.615     0.200
     4.439    69.015     0.200
     4.539    70.613     0.200
     4.607    70.615     0.200
     4.623    71.115     0.200
     4.795    74.385     0.200
     5.049    76.314     0.200
     5.049    76.125     0.200
     5.153    78.415     0.200
     5.630    86.115     0.200
     5.630    85.385     0.200
     5.700    86.115     0.200
     5.879    87.064     0.200
     5.879    88.834     0.200
     5.992    90.214     0.200
     6.181    93.435     0.200
     6.107    91.814     0.200
     6.177    92.515     0.200
     6.177    92.285     0.200
     6.331    90.834     0.200
     6.499    97.004     0.200
     6.577    98.515     0.200
     6.913   103.214     0.200
     7.094   104.995     0.200
     7.180   105.944     0.200
     7.180   106.104     0.200
     7.166   106.515     0.200
     7.166   105.935     0.200
     7.585   112.915     0.200
     7.797   114.314     0.200
     8.165   120.714     0.200
     8.682   127.814     0.200
     8.808   128.765     0.200
     8.691   127.055     0.200
     8.928   130.924     0.200
     8.950   129.595     0.200
     9.290   135.245     0.200
     9.809   143.044     0.200
     9.875   143.635     0.200
    10.045   144.125     0.200
    10.165   147.314     0.200
    10.690   152.464     0.200
    10.825   155.544     0.200
    10.825   153.254     0.200
    12.696   178.860     0.200
    12.696   179.174     0.200
    12.696   180.354     0.200
    13.510   191.944     0.200
    14.137   199.515     0.200
    14.737   206.444     0.200
    14.740   208.669     0.200
    14.740   209.285     0.200
    15.709   219.850     0.200
    16.099   223.608     0.200
    16.194   229.185     0.200
    17.320   239.934     0.200
    17.331   241.885     0.200
    18.067   250.444     0.200
    18.067   250.185     0.200
     2.509    42.450     0.200
     4.638    71.358     0.200
     5.790    87.649     0.200
     6.146    92.350     0.200
     6.308    94.250     0.200
     6.296    94.549     0.200
     7.030   103.479     0.200
     8.778   127.240     0.200
    10.527   150.720     0.200
    10.681   153.759     0.200
    14.714   207.390     0.200
     2.333    40.169     0.200
     2.595    43.669     0.200
     2.654    44.368     0.200
     2.864    48.019     0.200
     3.082    51.169     0.200
     3.318    53.868     0.200
     3.588    57.068     0.200
     3.588    56.719     0.200
     3.906    62.868     0.200
     4.013    63.169     0.200
     4.013    63.499     0.200
     4.077    64.669     0.200
     4.182    63.759     0.200
     4.188    65.469     0.200
     4.531    70.269     0.200
     4.513    70.568     0.200
     4.574    71.153     0.200
     4.717    72.469     0.200
     4.840    75.238     0.200
     5.100    77.599     0.200
     5.245    79.568     0.200
     5.714    86.568     0.200
     5.684    86.169     0.200
     6.074    91.669     0.200
     6.201    93.269     0.200
     6.249    93.669     0.200
     6.249    93.408     0.200
     6.251    93.339     0.200
     6.417    91.349     0.200
     6.670    99.669     0.200
     7.099   105.389     0.200
     8.861   128.578     0.200
     9.960   143.158     0.200
    10.604   151.538     0.200
    10.747   154.209     0.200
    11.290   162.889     0.200
    12.609   178.762     0.200
    12.609   179.448     0.200
    12.609   180.559     0.200
    14.712   206.259     0.200
    14.712   205.889     0.200
    16.081   224.496     0.200
     2.258    39.713     0.200
     2.400    41.014     0.200
     2.577    43.514     0.200
     2.587    43.713     0.200
     2.790    47.473     0.200
     3.005    50.014     0.200
     3.582    57.514     0.200
     3.582    57.143     0.200
     3.830    61.914     0.200
     3.938    62.613     0.200
     3.938    62.133     0.200
     4.000    64.312     0.200
     4.133    64.434     0.200
     4.140    64.713     0.200
     4.437    70.014     0.200
     4.498    70.264     0.200
     4.477    69.113     0.200
     4.648    71.613     0.200
     4.675    71.914     0.200
     4.763    73.613     0.200
     5.134    77.873     0.200
     5.221    79.514     0.200
     5.607    85.914     0.200
     5.607    85.303     0.200
     5.849    85.283     0.200
     5.849    87.184     0.200
     5.708    86.812     0.200
     5.772    87.914     0.200
     6.072    91.914     0.200
     6.177    92.812     0.200
     6.170    93.414     0.200
     6.261    93.713     0.200
     6.261    93.824     0.200
     6.408    92.674     0.200
     6.551    98.732     0.200
     6.644   100.312     0.200
     6.868   103.414     0.200
     7.099   105.133     0.200
     7.099   105.963     0.200
     6.973   104.613     0.200
     7.150   107.402     0.200
     7.245   108.914     0.200
     7.245   107.562     0.200
     7.840   116.963     0.200
     8.876   128.863     0.200
     9.221   132.014     0.200
     9.968   143.133     0.200
    10.743   154.127     0.200
    10.743   154.104     0.200
    10.947   155.943     0.200
    11.082   158.623     0.200
    11.779   169.312     0.200
    12.083   170.113     0.200
    12.563   177.463     0.200
    12.620   179.574     0.200
    12.620   178.707     0.200
    12.620   178.873     0.200
    12.620   179.973     0.200
    13.099   187.152     0.200
    13.436   189.014     0.200
    14.067   198.312     0.200
    14.313   203.803     0.200
    14.659   206.104     0.200
    14.659   204.988     0.200
    14.659   206.203     0.200
    14.886   212.674     0.200
    15.624   218.035     0.200
    16.024   223.812     0.200
    16.024   223.377     0.200
    16.122   225.223     0.200
    17.293   243.338     0.200
    17.455   245.113     0.200
    17.523   245.562     0.200
    17.528   244.883     0.200
    17.528   245.613     0.200
    18.135   250.873     0.200
    18.135   251.863     0.200
    19.100   267.113     0.200
    19.371   270.312     0.200
    19.613   271.312     0.200
    20.461   279.213     0.200
     2.297    39.688     0.200
     2.382    40.086     0.200
     2.576    43.188     0.200
     2.831    47.605     0.200
     3.570    56.785     0.200
     3.869    61.988     0.200
     3.972    63.086     0.200
     4.037    64.086     0.200
     4.145    64.438     0.200
     4.152    64.488     0.200
     4.537    69.562     0.200
     4.683    71.688     0.200
     4.801    75.246     0.200
     5.104    78.387     0.200
     5.218    79.285     0.200
     5.644    85.766     0.200
     5.767    87.285     0.200
     6.171    92.988     0.200
     6.397    91.457     0.200
     6.559    97.566     0.200
     7.209   108.387     0.200
     7.209   108.047     0.200
    16.062   225.410     0.200
     2.233    38.824     0.200
     2.311    39.027     0.200
     2.544    42.926     0.200
     2.552    42.926     0.200
     2.770    46.465     0.200
     2.973    48.926     0.200
     3.210    53.227     0.200
     3.547    56.227     0.200
     3.804    61.027     0.200
     3.900    61.824     0.200
     3.900    61.598     0.200
     3.968    62.926     0.200
     4.087    63.957     0.200
     4.094    63.426     0.200
     4.408    69.125     0.200
     4.431    67.727     0.200
     4.472    70.555     0.200
     4.630    71.125     0.200
     4.733    73.246     0.200
     5.118    78.047     0.200
     5.573    85.098     0.200
     5.673    85.824     0.200
     6.038    90.824     0.200
     6.137    92.234     0.200
     6.126    92.227     0.200
     6.371    91.387     0.200
     6.505    97.195     0.200
     6.602    99.125     0.200
     7.105   106.266     0.200
     7.241   108.906     0.200
     7.795   115.387     0.200
     8.788   129.367     0.200
     8.896   130.277     0.200
     9.788   143.207     0.200
    10.775   153.625     0.200
    12.658   178.656     0.200
    12.658   179.512     0.200
    12.658   179.996     0.200
    12.658   179.637     0.200
    14.661   205.324     0.200
    16.023   222.691     0.200
    16.023   221.070     0.200
     2.212    38.770     0.200
     2.249    38.168     0.200
     2.271    38.867     0.200
     2.468    41.469     0.200
     2.502    42.566     0.200
     2.759    46.578     0.200
     2.935    48.668     0.200
     3.171    51.566     0.200
     3.463    55.270     0.200
     3.463    55.398     0.200
     3.779    60.270     0.200
     3.848    60.566     0.200
     3.848    60.340     0.200
     3.930    62.566     0.200
     3.999    62.566     0.200
     4.006    61.969     0.200
     4.345    67.566     0.200
     4.378    68.867     0.200
     4.448    69.141     0.200
     4.516    69.469     0.200
     4.541    69.668     0.200
     4.699    72.977     0.200
     5.090    77.668     0.200
     5.064    77.668     0.200
     5.064    76.258     0.200
     5.529    84.367     0.200
     5.529    84.469     0.200
     5.589    84.367     0.200
     5.643    85.367     0.200
     5.956    90.066     0.200
     6.036    91.066     0.200
     6.077    90.797     0.200
     5.977    88.098     0.200
     6.159    92.367     0.200
     6.159    92.168     0.200
     6.416    96.328     0.200
     6.512    97.367     0.200
     7.015   105.258     0.200
     7.207   108.770     0.200
     7.207   106.418     0.200
     7.214   106.270     0.200
     7.214   106.477     0.200
     8.708   127.957     0.200
     9.003   130.906     0.200
     9.709   141.758     0.200
     9.817   143.398     0.200
    10.089   145.758     0.200
    10.735   152.848     0.200
    10.855   154.328     0.200
    12.745   180.738     0.200
    12.745   180.117     0.200
    13.563   192.109     0.200
    14.196   201.156     0.200
    16.050   224.543     0.200
    16.251   227.809     0.200
    17.221   238.867     0.200
    18.004   248.227     0.200
    18.004   249.629     0.200
     2.216    38.531     0.200
     2.254    38.734     0.200
     2.501    42.332     0.200
     2.764    46.184     0.200
     2.935    48.332     0.200
     3.171    52.133     0.200
     3.446    55.031     0.200
     3.782    60.234     0.200
     3.845    60.934     0.200
     3.845    60.781     0.200
     3.930    62.531     0.200
     3.986    61.574     0.200
     3.993    62.234     0.200
     4.380    68.234     0.200
     4.451    69.957     0.200
     4.526    69.633     0.200
     4.700    71.922     0.200
     5.049    76.133     0.200
     5.049    75.871     0.200
     5.073    77.031     0.200
     5.528    84.031     0.200
     5.572    84.434     0.200
     5.627    85.332     0.200
     6.020    90.531     0.200
     6.072    91.254     0.200
     6.142    91.734     0.200
     6.142    92.043     0.200
     6.401    96.004     0.200
     6.496    97.832     0.200
    10.872   155.391     0.200
    12.762   182.027     0.200
    14.706   208.539     0.200
    15.739   218.309     0.200
    16.062   226.141     0.200
     2.255    39.316     0.200
     2.583    43.617     0.200
     2.784    46.488     0.200
     3.009    49.117     0.200
     3.245    52.719     0.200
     3.615    57.418     0.200
     3.829    61.316     0.200
     3.948    62.520     0.200
     4.003    63.418     0.200
     4.161    64.719     0.200
     4.168    64.418     0.200
     4.437    69.020     0.200
     4.496    69.293     0.200
     4.765    73.656     0.200
     5.162    77.816     0.200
     5.253    79.520     0.200
     5.613    85.520     0.200
     5.613    84.629     0.200
     5.741    87.020     0.200
     5.804    87.816     0.200
     6.105    91.816     0.200
     6.190    92.590     0.200
     6.201    92.520     0.200
     6.293    94.219     0.200
     6.293    93.949     0.200
     6.580    99.039     0.200
     6.676    99.816     0.200
     7.268   107.867     0.200
     7.617   112.617     0.200
    10.711   152.719     0.200
    12.587   177.637     0.200
    12.587   178.059     0.200
    12.587   179.219     0.200
    12.587   178.906     0.200
    14.637   204.941     0.200
    14.637   205.117     0.200
    16.004   222.668     0.200
    16.004   225.117     0.200
    17.297   240.844     0.200
    17.297   241.816     0.200
    17.459   243.316     0.200
    20.079   276.316     0.200
     2.651    44.199     0.200
     3.122    51.598     0.200
     4.061    64.000     0.200
     4.116    65.398     0.200
     4.604    69.750     0.200
     5.769    87.297     0.200
     5.852    88.098     0.200
     6.265    93.598     0.200
    10.697   152.438     0.200
    12.551   178.516     0.200
    12.551   177.047     0.200
    14.701   209.035     0.200
    14.852   211.066     0.200
     2.244    38.951     0.200
     2.556    43.051     0.200
     2.781    46.352     0.200
     2.985    49.451     0.200
     3.222    52.750     0.200
     3.550    56.580     0.200
     3.815    61.051     0.200
     3.913    62.551     0.200
     3.980    63.150     0.200
     4.097    63.871     0.200
     4.104    63.551     0.200
     4.441    69.051     0.200
     4.420    69.352     0.200
     4.483    69.877     0.200
     4.613    71.150     0.200
     5.115    77.420     0.200
     5.186    78.650     0.200
     5.676    86.051     0.200
     5.586    84.852     0.200
     5.737    86.551     0.200
     5.884    87.320     0.200
     6.041    91.051     0.200
     6.134    91.951     0.200
     6.234    93.551     0.200
     6.150    93.061     0.200
     6.376    90.361     0.200
     6.514    97.410     0.200
     6.609    99.250     0.200
     7.129   105.301     0.200
     7.566   111.650     0.200
     8.683   126.451     0.200
     9.255   133.000     0.200
    10.000   143.451     0.200
    10.645   152.311     0.200
    10.773   153.771     0.200
    12.598   177.660     0.200
    12.653   179.221     0.200
    14.667   206.701     0.200
    16.030   222.727     0.200
     2.355    40.695     0.200
     2.458    41.496     0.200
     2.682    44.996     0.200
     2.883    48.375     0.200
     3.109    50.895     0.200
     3.346    54.293     0.200
     3.617    57.996     0.200
     3.617    57.695     0.200
     3.929    62.695     0.200
     4.045    63.793     0.200
     4.104    65.195     0.200
     4.219    65.746     0.200
     4.226    64.793     0.200
     4.538    70.895     0.200
     4.596    71.770     0.200
     4.755    72.793     0.200
     5.112    78.594     0.200
     5.112    77.844     0.200
     5.279    79.594     0.200
     5.743    86.895     0.200
     5.713    86.395     0.200
     5.713    87.125     0.200
     5.824    87.695     0.200
     5.752    85.484     0.200
     5.752    88.414     0.200
     6.101    92.293     0.200
     6.236    93.996     0.200
     6.272    94.594     0.200
     6.272    94.215     0.200
     6.284    93.723     0.200
     6.447    92.285     0.200
     6.631    99.055     0.200
     7.197   108.496     0.200
     7.197   108.266     0.200
     7.225   107.516     0.200
     7.073   105.203     0.200
     8.796   128.195     0.200
     8.933   130.293     0.200
     9.165   133.496     0.200
     9.933   145.184     0.200
     9.931   144.066     0.200
    14.711   209.246     0.200
    14.711   208.746     0.200
    15.756   221.414     0.200
     2.265    39.211     0.200
     2.579    43.508     0.200
     2.801    46.758     0.200
     3.008    49.309     0.200
     3.245    52.609     0.200
     3.558    56.711     0.200
     3.837    61.410     0.200
     3.936    62.109     0.200
     4.003    63.309     0.200
     4.116    64.289     0.200
     4.505    69.910     0.200
     4.657    71.609     0.200
     5.110    77.711     0.200
     5.110    77.289     0.200
     5.684    86.008     0.200
     6.173    92.168     0.200
     6.236    93.039     0.200
     6.532    98.188     0.200
     7.225   107.098     0.200
    10.865   156.148     0.200
    11.640   168.000     0.200
    16.043   225.609     0.200
     2.200    38.609     0.200
     2.264    38.512     0.200
     2.321    39.309     0.200
     2.503    42.410     0.200
     2.741    46.352     0.200
     2.520    42.309     0.200
     2.933    48.309     0.200
     3.170    52.012     0.200
     3.514    55.910     0.200
     3.514    56.172     0.200
     3.769    60.109     0.200
     3.856    60.910     0.200
     3.856    61.270     0.200
     3.928    62.609     0.200
     4.039    63.148     0.200
     4.046    63.211     0.200
     4.372    68.309     0.200
     4.382    68.109     0.200
     4.554    70.309     0.200
     5.138    78.109     0.200
     5.110    77.012     0.200
     5.532    83.910     0.200
     5.640    85.309     0.200
     5.693    86.211     0.200
     5.945    88.371     0.200
     6.091    90.988     0.200
     6.008    90.109     0.200
     6.083    91.809     0.200
     6.210    92.609     0.200
     6.210    92.840     0.200
     6.337    90.551     0.200
     6.458    96.922     0.200
     6.560    98.410     0.200
     7.163   105.930     0.200
     7.059   104.449     0.200
     7.246   107.031     0.200
     8.738   128.262     0.200
     8.847   130.430     0.200
     9.303   133.871     0.200
     9.738   142.930     0.200
    10.038   143.148     0.200
    10.684   152.441     0.200
    10.804   154.215     0.200
    10.804   153.762     0.200
    11.867   172.012     0.200
    12.694   179.430     0.200
    12.694   179.582     0.200
    12.694   180.051     0.200
    12.694   180.461     0.200
    13.183   187.289     0.200
    14.147   199.520     0.200
    14.656   205.770     0.200
    14.656   204.699     0.200
    14.656   205.738     0.200
    14.767   207.148     0.200
    14.812   210.031     0.200
    15.674   221.332     0.200
    16.015   222.484     0.200
    16.015   222.180     0.200
    15.998   223.520     0.200
    19.197   267.121     0.200
     2.256    39.273     0.200
     2.553    43.070     0.200
     2.985    49.070     0.200
     3.488    55.570     0.200
     3.825    61.172     0.200
     3.901    61.672     0.200
     3.980    63.773     0.200
     4.049    62.352     0.200
     4.055    63.070     0.200
     4.426    69.172     0.200
     4.494    70.621     0.200
     4.566    70.371     0.200
     4.587    70.473     0.200
     5.060    76.070     0.200
     5.060    75.863     0.200
     5.126    77.773     0.200
     5.581    85.172     0.200
     5.581    84.000     0.200
     5.614    84.973     0.200
     5.677    86.070     0.200
     5.924    84.941     0.200
     5.979    90.172     0.200
     6.077    91.672     0.200
     6.132    91.973     0.200
     6.173    92.473     0.200
     6.173    91.922     0.200
     6.463    96.582     0.200
     6.550    98.371     0.200
     7.060   104.371     0.200
     7.757   113.832     0.200
     8.762   127.891     0.200
     8.880   130.363     0.200
     9.080   133.160     0.200
     9.763   142.660     0.200
    12.715   180.215     0.200
    12.715   179.383     0.200
    16.072   223.871     0.200
     2.227    38.914     0.200
     2.323    39.812     0.200
     2.529    42.812     0.200
     2.516    42.312     0.200
     2.768    46.445     0.200
     2.960    48.613     0.200
     3.196    51.914     0.200
     3.511    55.812     0.200
     3.511    55.914     0.200
     3.796    60.812     0.200
     3.881    61.215     0.200
     3.881    61.035     0.200
     3.955    62.613     0.200
     4.052    63.723     0.200
     4.059    62.914     0.200
     4.399    68.715     0.200
     4.397    68.215     0.200
     4.465    69.914     0.200
     4.568    69.516     0.200
     4.594    70.414     0.200
     5.093    76.715     0.200
     5.093    77.375     0.200
     5.142    78.312     0.200
     5.558    83.812     0.200
     5.558    84.145     0.200
     5.637    85.312     0.200
     5.695    86.215     0.200
     5.927    86.383     0.200
     5.855    87.516     0.200
     6.003    90.113     0.200
     6.115    91.945     0.200
     6.089    91.715     0.200
     6.201    92.914     0.200
     6.201    92.324     0.200
     6.335    90.445     0.200
     6.469    96.734     0.200
     6.565    98.414     0.200
     6.802   101.812     0.200
     7.168   104.613     0.200
     7.168   106.074     0.200
     7.224   105.426     0.200
     7.526   111.113     0.200
     7.759   115.684     0.200
     7.962   114.223     0.200
     8.108   118.215     0.200
     8.706   127.812     0.200
     8.757   128.766     0.200
     8.868   130.492     0.200
     9.299   133.293     0.200
     9.495   136.715     0.200
     9.495   140.195     0.200
     9.757   142.465     0.200
    10.040   143.363     0.200
     9.869   144.086     0.200
    10.686   151.703     0.200
    10.810   154.258     0.200
    10.810   154.113     0.200
    11.023   155.562     0.200
    11.112   157.785     0.200
    11.953   166.254     0.200
    12.159   171.734     0.200
    12.695   179.609     0.200
    12.695   179.004     0.200
    12.695   179.918     0.200
    12.695   180.414     0.200
    12.695   179.324     0.200
    12.695   180.242     0.200
    13.198   191.113     0.200
    13.297   191.516     0.200
    13.512   190.516     0.200
    13.689   198.113     0.200
    13.853   200.414     0.200
    14.144   198.113     0.200
    14.678   205.113     0.200
    14.678   206.125     0.200
    14.671   209.609     0.200
    14.838   208.844     0.200
    14.962   214.766     0.200
    15.317   215.836     0.200
    15.561   218.934     0.200
    15.700   224.824     0.200
    15.799   220.473     0.200
    16.037   223.812     0.200
    16.037   221.848     0.200
    16.199   228.184     0.200
    16.689   234.312     0.200
    17.184   241.914     0.200
    17.247   240.215     0.200
    17.269   241.414     0.200
    17.305   242.285     0.200
    17.483   243.273     0.200
    17.502   244.312     0.200
    18.162   250.535     0.200
    18.056   250.113     0.200
    19.169   264.414     0.200
    19.197   266.312     0.200
    19.683   270.312     0.200
     2.265    39.367     0.200
     2.322    39.367     0.200
     2.567    43.164     0.200
     3.234    53.164     0.200
     3.506    55.664     0.200
     3.835    61.465     0.200
     3.917    61.965     0.200
     3.993    63.566     0.200
     4.077    62.664     0.200
     4.418    68.465     0.200
     4.437    69.465     0.200
     4.504    69.871     0.200
     4.608    70.664     0.200
     5.147    78.164     0.200
     5.632    85.266     0.200
     5.595    85.266     0.200
     5.697    86.465     0.200
     6.098    91.566     0.200
     6.188    92.266     0.200
     6.571    98.367     0.200
    12.696   181.258     0.200
    19.381   268.984     0.200
    20.079   276.172     0.200
     2.282    39.334     0.200
     2.395    40.533     0.200
     2.370    40.434     0.200
     2.578    43.334     0.200
     2.599    43.533     0.200
     2.816    47.104     0.200
     3.028    49.633     0.200
     3.264    53.633     0.200
     3.572    56.533     0.200
     3.854    61.834     0.200
     3.958    62.334     0.200
     3.958    62.504     0.200
     4.022    63.533     0.200
     4.138    64.973     0.200
     4.145    64.834     0.200
     4.485    69.133     0.200
     4.522    70.584     0.200
     4.678    71.934     0.200
     4.786    74.484     0.200
     5.113    77.303     0.200
     5.698    85.934     0.200
     5.629    85.453     0.200
     6.168    93.033     0.200
     6.246    93.334     0.200
     6.196    92.834     0.200
     6.399    90.633     0.200
     6.641    99.633     0.200
     2.315    39.938     0.200
     2.640    44.234     0.200
     2.845    47.242     0.200
     3.068    50.938     0.200
     3.304    53.938     0.200
     3.606    57.234     0.200
     3.606    57.367     0.200
     3.889    62.133     0.200
     4.003    63.336     0.200
     4.003    62.703     0.200
     4.062    64.438     0.200
     4.187    64.516     0.200
     4.194    65.438     0.200
     4.497    70.438     0.200
     4.556    71.758     0.200
     4.726    72.438     0.200
     4.824    74.633     0.200
     5.124    77.445     0.200
     5.259    79.734     0.200
     5.671    86.336     0.200
     5.671    86.047     0.200
     5.732    86.734     0.200
     5.789    84.734     0.200
     5.789    88.078     0.200
     5.806    88.031     0.200
     6.093    91.531     0.200
     6.213    93.734     0.200
     6.242    93.422     0.200
     6.435    91.258     0.200
     6.602    99.008     0.200
     6.684   100.531     0.200
     7.079   102.758     0.200
     7.079   104.625     0.200
     7.219   107.633     0.200
     7.219   107.492     0.200
     7.875   113.688     0.200
     9.183   133.586     0.200
     9.942   142.805     0.200
    10.586   150.977     0.200
    10.726   152.523     0.200
    10.916   154.734     0.200
    12.526   176.742     0.200
    12.591   177.977     0.200
    12.591   178.242     0.200
    12.591   178.477     0.200
    13.404   187.281     0.200
    14.687   204.836     0.200
    14.687   205.266     0.200
    14.794   209.750     0.200
    14.794   210.562     0.200
    14.948   211.156     0.200
    15.431   217.766     0.200
    15.691   221.328     0.200
    16.057   222.234     0.200
    16.088   223.594     0.200
    17.356   241.031     0.200
    20.099   275.766     0.200
     2.340    40.050     0.200
     2.453    41.150     0.200
     2.626    43.350     0.200
     2.668    44.250     0.200
     2.868    47.350     0.200
     3.095    50.050     0.200
     3.331    53.350     0.200
     3.619    57.450     0.200
     4.031    62.850     0.200
     4.031    63.000     0.200
     4.089    64.150     0.200
     4.213    64.920     0.200
     4.220    65.150     0.200
     4.523    69.650     0.200
     4.561    70.250     0.200
     4.581    71.200     0.200
     4.730    72.150     0.200
     4.750    72.650     0.200
     4.851    74.430     0.200
     5.122    77.250     0.200
     5.278    80.050     0.200
     5.761    88.150     0.200
     5.761    88.795     0.200
     5.761    87.890     0.200
     5.761    86.950     0.200
     5.761    88.620     0.200
     5.761    87.100     0.200
     5.699    85.750     0.200
     5.699    86.810     0.200
     5.745    86.650     0.200
     5.838    89.994     0.200
     5.838    90.290     0.200
     5.838    91.165     0.200
     5.824    87.750     0.200
     6.005    89.950     0.200
     6.104    91.650     0.200
     6.234    93.050     0.200
     6.278    93.550     0.200
     6.278    93.820     0.200
     6.271    93.820     0.200
     6.449    91.340     0.200
     6.626    98.920     0.200
     6.703   100.050     0.200
     6.733   100.650     0.200
     6.962   103.450     0.200
     7.069   104.305     0.200
     7.069   103.840     0.200
     7.018   104.050     0.200
     7.210   106.850     0.200
     7.210   107.570     0.200
     7.221   106.750     0.200
     7.221   106.990     0.200
     7.319   109.050     0.200
     7.506   111.050     0.200
     7.691   113.050     0.200
     7.696   113.250     0.200
     7.865   114.650     0.200
     8.096   119.050     0.200
     8.272   121.450     0.200
     8.285   122.050     0.200
     8.583   125.350     0.200
     8.650   126.650     0.200
     8.800   130.050     0.200
     8.800   128.260     0.200
     8.804   128.250     0.200
     8.808   128.550     0.200
     8.807   129.050     0.200
     8.923   130.370     0.200
     9.033   132.290     0.200
     9.107   132.050     0.200
     9.107   132.990     0.200
     9.109   132.750     0.200
     9.165   132.570     0.200
     9.233   136.050     0.200
     9.329   136.850     0.200
     9.329   137.445     0.200
     9.580   140.450     0.200
     9.686   139.880     0.200
     9.700   141.950     0.200
     9.766   142.140     0.200
     9.818   144.550     0.200
     9.929   141.440     0.200
     9.961   145.107     0.200
     9.961   146.403     0.200
     9.923   143.910     0.200
    10.002   145.954     0.200
    10.002   146.808     0.200
     9.998   145.730     0.200
    10.134   148.450     0.200
    10.134   148.610     0.200
    10.227   147.650     0.200
    10.294   148.365     0.200
    10.272   148.910     0.200
    10.345   144.390     0.200
    10.586   152.980     0.200
    10.547   154.460     0.200
    10.535   153.580     0.200
    10.573   150.060     0.200
    10.553   150.536     0.200
    10.553   152.508     0.200
    10.557   153.015     0.200
    10.628   155.483     0.200
    10.717   152.736     0.200
    10.717   152.220     0.200
    10.869   156.710     0.200
    10.803   155.190     0.200
    10.900   153.780     0.200
    10.857   158.150     0.200
    10.857   158.710     0.200
    10.906   157.450     0.200
    10.906   155.216     0.200
    10.906   157.960     0.200
    10.906   157.230     0.200
    10.906   157.007     0.200
    10.906   155.970     0.200
    10.891   158.950     0.200
    10.967   156.990     0.200
    11.008   158.820     0.200
    11.053   160.910     0.200
    11.042   157.262     0.200
    11.042   160.577     0.200
    11.017   160.140     0.200
    11.133   161.480     0.200
    11.095   160.683     0.200
    11.095   162.718     0.200
    11.072   159.090     0.200
    11.108   157.776     0.200
    11.108   157.640     0.200
    11.198   162.073     0.200
    11.198   162.758     0.200
    11.338   163.828     0.200
    11.338   165.718     0.200
    11.323   160.020     0.200
    11.415   165.250     0.200
    11.512   163.918     0.200
    11.512   165.008     0.200
    11.557   168.272     0.200
    11.557   168.718     0.200
    11.571   166.337     0.200
    11.589   165.636     0.200
    11.631   165.480     0.200
    11.606   167.050     0.200
    11.714   166.850     0.200
    11.762   168.656     0.200
    11.765   169.835     0.200
    11.765   170.523     0.200
    11.883   171.037     0.200
    11.883   171.520     0.200
    11.877   170.750     0.200
    12.036   169.210     0.200
    12.051   174.362     0.200
    12.055   172.850     0.200
    12.165   171.580     0.200
    12.249   176.996     0.200
    12.278   173.925     0.200
    12.306   176.250     0.200
    12.467   178.260     0.200
    12.498   177.110     0.200
    12.530   180.930     0.200
    12.577   176.850     0.200
    12.577   176.681     0.200
    12.577   177.560     0.200
    12.577   177.369     0.200
    12.577   177.056     0.200
    12.577   179.235     0.200
    12.577   178.066     0.200
    12.577   177.900     0.200
    12.617   178.200     0.200
    12.584   180.604     0.200
    12.649   177.826     0.200
    12.694   180.730     0.200
    12.634   180.550     0.200
    12.698   181.728     0.200
    12.890   182.560     0.200
    12.862   181.010     0.200
    12.941   182.350     0.200
    12.954   182.830     0.200
    12.993   185.950     0.200
    12.967   184.935     0.200
    12.970   186.504     0.200
    13.042   183.190     0.200
    13.302   188.575     0.200
    13.302   188.817     0.200
    13.321   192.145     0.200
    13.388   187.150     0.200
    13.388   188.430     0.200
    13.358   191.015     0.200
    13.358   191.702     0.200
    13.358   191.457     0.200
    13.406   188.270     0.200
    13.342   191.650     0.200
    13.391   191.317     0.200
    13.457   188.990     0.200
    13.438   191.950     0.200
    13.465   194.410     0.200
    13.586   194.095     0.200
    13.632   193.381     0.200
    13.654   196.910     0.200
    13.756   196.024     0.200
    13.803   195.528     0.200
    13.803   195.391     0.200
    13.911   196.110     0.200
    13.873   196.040     0.200
    13.863   195.902     0.200
    13.860   197.718     0.200
    13.835   198.350     0.200
    14.013   197.360     0.200
    14.040   198.470     0.200
    14.014   196.750     0.200
    14.014   197.050     0.200
    14.063   201.465     0.200
    14.007   200.550     0.200
    14.058   197.450     0.200
    14.202   201.190     0.200
    14.237   200.680     0.200
    14.257   199.080     0.200
    14.312   201.850     0.200
    14.306   200.490     0.200
    14.337   205.250     0.200
    14.411   202.109     0.200
    14.434   202.470     0.200
    14.639   205.450     0.200
    14.662   210.550     0.200
    14.698   204.280     0.200
    14.698   206.696     0.200
    14.698   204.750     0.200
    14.822   213.150     0.200
    14.822   213.259     0.200
    14.822   209.544     0.200
    14.822   212.174     0.200
    14.822   212.860     0.200
    14.981   209.450     0.200
    14.981   210.750     0.200
    15.036   209.840     0.200
    14.976   212.310     0.200
    15.123   217.290     0.200
    15.272   216.120     0.200
    15.247   212.830     0.200
    15.459   218.590     0.200
    15.620   217.890     0.200
    15.688   218.670     0.200
    15.781   222.930     0.200
    15.720   224.010     0.200
    15.754   221.960     0.200
    15.744   223.170     0.200
    15.876   222.401     0.200
    15.876   221.860     0.200
    15.901   226.640     0.200
    16.260   226.720     0.200
    16.071   222.944     0.200
    16.071   222.580     0.200
    16.071   226.237     0.200
    16.071   223.550     0.200
    16.069   223.450     0.200
    16.069   224.341     0.200
    16.250   226.380     0.200
    16.825   236.250     0.200
    17.206   238.260     0.200
    17.425   243.720     0.200
    17.383   241.950     0.200
    17.383   241.850     0.200
    17.508   243.706     0.200
    17.508   244.827     0.200
    17.545   244.350     0.200
    17.612   245.000     0.200
    17.618   245.050     0.200
    17.618   243.738     0.200
    17.618   244.310     0.200
    17.618   245.750     0.200
    17.618   244.050     0.200
    17.618   244.470     0.200
    17.894   247.550     0.200
    18.131   250.760     0.200
    18.233   252.130     0.200
    18.192   251.384     0.200
    18.192   251.180     0.200
    18.192   252.550     0.200
    18.192   252.114     0.200
    18.192   251.620     0.200
    18.226   253.060     0.200
    18.445   257.718     0.200
    19.006   263.150     0.200
    18.920   264.740     0.200
    19.200   265.760     0.200
    19.185   265.650     0.200
    19.482   270.050     0.200
    19.482   271.100     0.200
    20.047   275.720     0.200
    20.105   275.580     0.200
    20.367   278.850     0.200
    20.373   279.150     0.200
     2.895    48.520     0.200
     3.144    51.859     0.200
     3.694    58.810     0.200
     4.091    63.819     0.200
     4.137    65.960     0.200
     4.297    65.880     0.200
     4.617    70.785     0.200
     4.895    75.300     0.200
     5.751    87.220     0.200
     6.336    95.080     0.200
     6.525    93.390     0.200
     6.710   100.109     0.200
    12.500   177.028     0.200
     2.518    42.090     0.200
     2.683    44.790     0.200
     2.911    48.350     0.200
     3.675    58.640     0.200
     4.098    65.200     0.200
     4.289    66.650     0.200
     4.631    71.515     0.200
     4.907    76.140     0.200
     5.684    83.900     0.200
     6.319    94.740     0.200
     6.341    95.590     0.200
     6.506    92.560     0.200
     6.700    99.840     0.200
     7.019   103.700     0.200
     7.210   107.480     0.200
     9.874   141.950     0.200
    10.517   150.640     0.200
    10.670   152.400     0.200
    10.840   154.130     0.200
    11.394   164.480     0.200
    11.976   169.330     0.200
    12.443   175.340     0.200
    12.519   176.284     0.200
    12.519   175.820     0.200
    13.328   188.790     0.200
    13.951   196.290     0.200
    14.703   206.380     0.200
    14.703   207.230     0.200
    15.036   215.560     0.200
    16.009   223.650     0.200
    16.079   223.890     0.200
     2.365    40.988     0.200
     2.518    42.488     0.200
     2.687    45.188     0.200
     2.706    45.788     0.200
     2.886    47.528     0.200
     3.131    51.688     0.200
     3.680    58.988     0.200
     3.680    58.729     0.200
     3.941    63.188     0.200
     4.076    64.788     0.200
     4.124    65.389     0.200
     4.279    66.568     0.200
     4.286    66.089     0.200
     4.552    71.488     0.200
     4.606    71.514     0.200
     4.626    70.988     0.200
     4.796    73.188     0.200
     4.816    73.788     0.200
     4.883    75.738     0.200
     5.159    78.608     0.200
     5.343    81.188     0.200
     5.698    87.858     0.200
     5.698    88.288     0.200
     5.698    87.654     0.200
     5.775    89.788     0.200
     5.737    87.898     0.200
     5.805    87.988     0.200
     5.888    89.188     0.200
     6.049    90.889     0.200
     6.163    93.288     0.200
     6.300    94.889     0.200
     6.330    95.089     0.200
     6.320    95.259     0.200
     6.510    92.788     0.200
     6.692   100.549     0.200
     6.791   100.988     0.200
     7.012   104.557     0.200
     7.012   104.158     0.200
     7.014   105.288     0.200
     7.072   105.988     0.200
     7.106   105.589     0.200
     7.231   108.988     0.200
     7.231   108.658     0.200
     7.287   108.688     0.200
     7.287   108.299     0.200
     7.748   114.788     0.200
     7.809   114.828     0.200
     8.330   122.988     0.200
     8.351   122.889     0.200
     8.649   127.488     0.200
     8.715   128.288     0.200
     8.856   130.788     0.200
     8.868   129.988     0.200
     8.985   131.568     0.200
     9.100   132.488     0.200
     9.089   133.549     0.200
     9.141   133.009     0.200
     9.268   136.389     0.200
     9.268   136.683     0.200
     9.268   136.853     0.200
     9.290   137.038     0.200
     9.629   140.208     0.200
     9.631   138.519     0.200
     9.710   139.828     0.200
     9.869   141.669     0.200
    10.015   145.230     0.200
     9.984   145.589     0.200
    10.055   145.740     0.200
    10.055   146.842     0.200
    10.062   147.488     0.200
    10.170   145.988     0.200
    10.291   144.068     0.200
    10.330   150.288     0.200
    10.512   150.419     0.200
    10.599   154.253     0.200
    10.605   151.698     0.200
    10.609   153.570     0.200
    10.662   152.014     0.200
    10.662   152.259     0.200
    10.682   156.307     0.200
    10.809   157.349     0.200
    10.838   153.729     0.200
    10.910   155.889     0.200
    10.915   158.089     0.200
    10.957   157.960     0.200
    10.957   158.339     0.200
    10.957   158.902     0.200
    10.957   157.049     0.200
    10.957   159.108     0.200
    10.957   159.358     0.200
    11.093   161.047     0.200
    11.093   159.406     0.200
    11.081   157.636     0.200
    11.081   157.229     0.200
    11.148   161.900     0.200
    11.127   161.528     0.200
    11.249   163.656     0.200
    11.249   163.224     0.200
    11.391   165.123     0.200
    11.461   167.089     0.200
    11.547   168.038     0.200
    11.561   166.593     0.200
    11.561   166.347     0.200
    11.610   168.523     0.200
    11.610   169.127     0.200
    11.632   167.623     0.200
    11.647   166.988     0.200
    11.628   167.367     0.200
    11.808   169.063     0.200
    11.934   172.708     0.200
    11.934   171.192     0.200
    11.973   169.248     0.200
    11.937   173.788     0.200
    12.093   174.282     0.200
    12.104   171.688     0.200
    12.296   176.147     0.200
    12.316   175.381     0.200
    12.411   178.629     0.200
    12.387   177.883     0.200
    12.435   181.179     0.200
    12.443   175.389     0.200
    12.515   177.427     0.200
    12.515   177.148     0.200
    12.515   176.558     0.200
    12.515   177.752     0.200
    12.629   180.795     0.200
    12.685   177.604     0.200
    12.739   181.580     0.200
    12.800   180.479     0.200
    12.833   182.828     0.200
    12.879   181.498     0.200
    12.893   181.969     0.200
    12.977   183.599     0.200
    13.325   188.589     0.200
    13.344   188.578     0.200
    13.393   189.139     0.200
    13.383   193.889     0.200
    13.424   193.715     0.200
    13.477   193.788     0.200
    13.652   197.028     0.200
    13.816   194.278     0.200
    13.822   198.658     0.200
    13.877   200.089     0.200
    13.922   198.488     0.200
    13.950   196.889     0.200
    14.055   202.889     0.200
    14.103   199.912     0.200
    14.141   201.528     0.200
    14.150   198.958     0.200
    14.090   196.589     0.200
    14.178   200.379     0.200
    14.206   203.979     0.200
    14.243   200.849     0.200
    14.365   202.389     0.200
    14.365   202.288     0.200
    14.371   201.858     0.200
    14.384   206.419     0.200
    14.681   205.179     0.200
    14.681   204.913     0.200
    14.681   204.479     0.200
    14.917   209.288     0.200
    14.867   212.982     0.200
    14.971   210.658     0.200
    14.971   209.809     0.200
    15.012   214.158     0.200
    15.184   212.788     0.200
    15.240   216.339     0.200
    15.222   217.881     0.200
    15.176   217.328     0.200
    15.497   220.288     0.200
    15.556   217.938     0.200
    15.624   218.379     0.200
    15.743   220.340     0.200
    15.771   225.318     0.200
    15.799   224.509     0.200
    16.196   226.118     0.200
    16.007   222.695     0.200
    16.056   223.363     0.200
    16.140   226.219     0.200
    16.188   227.049     0.200
    16.531   232.759     0.200
    16.879   235.769     0.200
    17.159   241.078     0.200
    17.159   241.889     0.200
    17.418   244.413     0.200
    17.418   243.188     0.200
    17.489   243.682     0.200
    17.653   247.658     0.200
    17.653   246.469     0.200
    17.653   247.206     0.200
    17.653   246.288     0.200
    17.653   246.788     0.200
    17.653   247.519     0.200
    18.048   250.050     0.200
    18.193   252.688     0.200
    18.226   251.669     0.200
    18.261   253.791     0.200
    18.257   252.498     0.200
    18.257   252.328     0.200
    18.257   252.175     0.200
    18.967   264.719     0.200
    19.219   266.788     0.200
    19.501   269.688     0.200
    19.532   271.190     0.200
    19.828   273.688     0.200
    20.357   278.118     0.200
    20.330   278.879     0.200
    20.918   287.299     0.200
     2.396    40.854     0.200
     3.157    52.254     0.200
     3.659    58.453     0.200
     3.659    58.232     0.200
     4.098    65.053     0.200
     4.098    65.373     0.200
     4.151    65.854     0.200
     4.278    66.434     0.200
     4.285    65.652     0.200
     4.628    71.053     0.200
     4.581    70.854     0.200
     4.636    71.932     0.200
     4.812    73.652     0.200
     5.126    77.844     0.200
     4.911    76.674     0.200
     5.330    80.652     0.200
     5.784    87.354     0.200
     5.872    88.553     0.200
     5.763    87.883     0.200
     6.140    92.854     0.200
     6.303    94.572     0.200
     6.290    94.553     0.200
     6.340    95.773     0.200
     6.490    91.764     0.200
     6.688    99.943     0.200
     6.756   101.152     0.200
     7.036   103.174     0.200
     7.036   104.594     0.200
     9.115   132.393     0.200
     9.260   131.533     0.200
     9.890   141.504     0.200
    10.533   149.492     0.200
    10.687   152.223     0.200
    10.856   154.363     0.200
    11.991   169.723     0.200
    12.458   175.812     0.200
    12.534   176.473     0.200
    12.534   177.084     0.200
    12.534   176.844     0.200
    13.343   188.402     0.200
    13.966   196.643     0.200
    14.717   206.463     0.200
    14.717   204.863     0.200
    16.024   223.992     0.200
    16.092   224.152     0.200
    18.243   251.992     0.200
    18.243   251.623     0.200
     2.391    40.729     0.200
     2.712    44.729     0.200
     3.141    51.529     0.200
     3.377    55.529     0.200
     3.591    57.729     0.200
     3.964    63.529     0.200
     4.070    64.629     0.200
     4.135    65.330     0.200
     4.572    72.129     0.200
     4.632    72.379     0.200
     6.223    93.729     0.200
    12.602   179.283     0.200
    16.126   225.680     0.200
     2.353    40.539     0.200
     2.465    41.338     0.200
     2.683    44.338     0.200
     3.110    50.838     0.200
     3.346    54.139     0.200
     3.629    57.938     0.200
     4.104    65.338     0.200
     4.235    65.738     0.200
     4.537    71.238     0.200
     4.594    70.738     0.200
     6.247    93.938     0.200
    16.075   223.414     0.200
     2.359    40.324     0.200
     2.496    41.924     0.200
     2.695    45.023     0.200
     2.666    44.223     0.200
     2.881    48.094     0.200
     3.120    50.824     0.200
     3.357    54.123     0.200
     3.659    58.023     0.200
     3.659    58.164     0.200
     3.933    62.623     0.200
     4.063    64.023     0.200
     4.063    64.643     0.200
     4.114    64.924     0.200
     4.257    66.184     0.200
     4.264    65.924     0.200
     4.544    70.623     0.200
     4.599    71.070     0.200
     4.775    73.523     0.200
     4.794    73.324     0.200
     4.874    76.363     0.200
     5.145    77.623     0.200
     5.145    78.383     0.200
     5.321    80.723     0.200
     5.718    85.643     0.200
     5.726    87.404     0.200
     5.785    87.723     0.200
     5.866    88.223     0.200
     6.143    92.123     0.200
     6.305    93.844     0.200
     6.278    94.424     0.200
     6.312    94.484     0.200
     6.489    92.023     0.200
     6.670    99.393     0.200
     6.747   101.123     0.200
     7.031   104.143     0.200
     7.084   104.924     0.200
     7.222   108.854     0.200
     7.265   107.623     0.200
     7.265   107.873     0.200
     7.730   113.924     0.200
     7.828   113.244     0.200
     8.312   123.023     0.200
     8.787   127.434     0.200
     9.122   132.514     0.200
     9.071   133.143     0.200
     9.287   134.023     0.200
     9.287   136.324     0.200
     9.889   141.393     0.200
    10.533   149.824     0.200
    10.681   151.477     0.200
    10.681   152.043     0.200
    10.859   153.613     0.200
    11.092   157.664     0.200
    11.669   166.824     0.200
    11.994   169.713     0.200
    12.125   170.713     0.200
    12.465   175.574     0.200
    12.536   177.404     0.200
    12.536   176.912     0.200
    12.536   177.164     0.200
    12.536   177.557     0.200
    12.536   178.023     0.200
    12.821   180.834     0.200
    12.900   182.684     0.200
    12.914   182.023     0.200
    12.998   184.113     0.200
    13.347   188.123     0.200
    13.347   188.723     0.200
    13.365   186.834     0.200
    13.415   189.744     0.200
    13.465   191.824     0.200
    13.864   198.424     0.200
    13.972   195.623     0.200
    13.972   197.043     0.200
    13.972   196.123     0.200
    14.026   200.324     0.200
    14.040   200.424     0.200
    14.214   200.113     0.200
    14.214   199.133     0.200
    14.370   204.143     0.200
    14.688   206.053     0.200
    14.688   205.623     0.200
    14.688   206.424     0.200
    14.688   206.514     0.200
    14.854   212.193     0.200
    14.939   210.023     0.200
    14.993   209.723     0.200
    14.993   209.303     0.200
    15.002   211.004     0.200
    15.486   217.062     0.200
    15.581   218.910     0.200
    15.816   221.014     0.200
    15.878   222.293     0.200
    16.029   223.414     0.200
    16.062   223.021     0.200
    16.062   223.373     0.200
    17.408   243.570     0.200
    17.408   243.424     0.200
    17.571   246.123     0.200
    17.643   247.094     0.200
    17.643   245.664     0.200
    17.643   246.123     0.200
    17.643   246.824     0.200
    17.669   247.424     0.200
    18.228   252.504     0.200
    18.235   251.812     0.200
    18.235   252.193     0.200
    18.969   263.424     0.200
    19.210   268.023     0.200
    19.481   268.424     0.200
    20.329   278.223     0.200
    20.871   285.623     0.200
     2.380    40.840     0.200
     2.510    42.139     0.200
     2.718    45.639     0.200
     2.677    44.439     0.200
     2.901    48.299     0.200
     3.143    51.639     0.200
     3.669    58.340     0.200
     3.669    58.090     0.200
     3.954    62.939     0.200
     4.086    64.770     0.200
     4.137    65.840     0.200
     4.277    66.359     0.200
     4.284    66.340     0.200
     4.566    71.439     0.200
     4.626    71.139     0.200
     4.795    74.039     0.200
     4.896    75.789     0.200
     4.813    73.738     0.200
     5.143    77.939     0.200
     5.336    80.439     0.200
     5.696    84.039     0.200
     5.749    87.238     0.200
     5.749    87.488     0.200
     5.795    87.738     0.200
     5.879    88.840     0.200
     6.151    92.738     0.200
     6.329    94.279     0.200
     6.294    94.039     0.200
     6.316    94.430     0.200
     6.689    99.789     0.200
     6.762   101.340     0.200
     7.024   102.879     0.200
     7.024   103.979     0.200
     7.214   108.219     0.200
     7.754   114.840     0.200
     8.775   128.260     0.200
     8.775   127.619     0.200
     9.108   132.479     0.200
     9.880   141.350     0.200
    10.523   150.100     0.200
    10.674   152.115     0.200
    10.674   152.289     0.200
    10.847   154.039     0.200
    11.653   169.340     0.200
    11.983   169.318     0.200
    12.451   175.689     0.200
    12.525   177.750     0.200
    12.525   175.570     0.200
    12.525   177.229     0.200
    12.525   177.408     0.200
    12.984   183.379     0.200
    13.334   188.180     0.200
    13.334   188.318     0.200
    13.958   197.238     0.200
    13.958   196.609     0.200
    14.200   200.420     0.200
    14.393   204.658     0.200
    14.584   204.879     0.200
    14.698   205.920     0.200
    14.698   205.340     0.200
    14.877   211.270     0.200
    14.977   209.488     0.200
    14.977   209.270     0.200
    15.024   213.520     0.200
    15.578   217.969     0.200
    15.509   219.689     0.200
    15.802   220.818     0.200
    15.901   224.369     0.200
    16.016   223.238     0.200
    16.074   222.527     0.200
    16.074   223.557     0.200
    17.431   241.598     0.200
    17.665   246.889     0.200
    17.692   247.639     0.200
    18.250   252.828     0.200
    18.250   252.619     0.200
    20.051   275.449     0.200
     2.267    39.086     0.200
     3.245    52.986     0.200
     3.552    56.486     0.200
     3.552    56.195     0.200
     3.936    62.586     0.200
     3.936    61.885     0.200
     4.003    64.186     0.200
     4.112    63.705     0.200
     4.119    64.285     0.200
     4.443    69.885     0.200
     4.506    70.885     0.200
     4.768    73.936     0.200
     5.105    76.326     0.200
     5.609    84.406     0.200
     6.042    90.986     0.200
     6.144    92.486     0.200
     6.172    92.875     0.200
     6.231    92.666     0.200
     6.528    97.625     0.200
     7.129   105.436     0.200
     7.126   105.715     0.200
     7.220   105.916     0.200
     9.997   143.965     0.200
    10.643   152.346     0.200
    10.774   153.760     0.200
    10.774   153.965     0.200
    12.112   171.486     0.200
    12.649   177.855     0.200
    12.649   179.885     0.200
    12.649   181.006     0.200
    12.649   179.576     0.200
    13.465   189.375     0.200
    14.095   198.426     0.200
    14.684   205.596     0.200
    14.684   206.055     0.200
    14.727   208.705     0.200
    14.727   208.555     0.200
    14.888   210.426     0.200
    15.123   212.146     0.200
    15.369   217.695     0.200
    15.654   221.176     0.200
    16.047   223.486     0.200
    17.297   240.236     0.200
    18.107   251.035     0.200
     2.105    35.723     0.200
     2.437    40.932     0.200
     2.727    44.932     0.200
     2.598    43.633     0.200
     2.937    47.832     0.200
     3.156    50.832     0.200
     3.589    57.031     0.200
     4.085    63.633     0.200
     4.225    65.191     0.200
     4.231    65.432     0.200
     4.648    72.582     0.200
     4.580    70.232     0.200
     4.754    72.332     0.200
     4.914    75.432     0.200
     5.062    76.162     0.200
     5.264    80.332     0.200
     5.737    86.172     0.200
     5.737    83.303     0.200
     5.805    87.633     0.200
     6.070    91.832     0.200
     6.320    94.012     0.200
     6.227    93.332     0.200
     6.233    92.562     0.200
     6.631    98.842     0.200
     6.691   100.031     0.200
     7.142   106.332     0.200
     7.142   105.293     0.200
     7.221   107.732     0.200
     7.221   106.062     0.200
     7.729   114.133     0.200
     8.852   128.543     0.200
     8.952   131.232     0.200
     9.071   132.092     0.200
     9.182   132.752     0.200
     9.182   132.531     0.200
     9.300   135.232     0.200
     9.960   141.572     0.200
     9.953   144.621     0.200
     9.979   144.621     0.200
    10.178   148.793     0.200
    10.309   149.531     0.200
    10.757   153.383     0.200
    10.757   151.902     0.200
    10.925   154.451     0.200
    11.721   168.232     0.200
    12.060   169.861     0.200
    12.525   176.252     0.200
    12.603   178.361     0.200
    12.603   179.008     0.200
    12.603   177.941     0.200
    12.603   178.645     0.200
    12.603   178.201     0.200
    13.057   185.201     0.200
    13.411   188.932     0.200
    14.033   196.932     0.200
    14.274   200.502     0.200
    14.274   201.143     0.200
    14.389   203.543     0.200
    14.767   206.152     0.200
    14.767   205.941     0.200
    14.767   207.072     0.200
    14.794   211.031     0.200
    14.876   212.400     0.200
    14.876   210.602     0.200
    14.876   214.332     0.200
    15.036   213.521     0.200
    15.167   217.861     0.200
    15.517   219.922     0.200
    15.767   223.293     0.200
    15.786   223.793     0.200
    15.875   221.543     0.200
    15.903   224.252     0.200
    16.092   224.371     0.200
    16.140   225.332     0.200
    16.140   224.316     0.200
    16.386   232.133     0.200
    16.886   236.633     0.200
    17.444   241.133     0.200
    17.444   243.832     0.200
    17.474   244.611     0.200
    17.679   245.332     0.200
    17.702   247.531     0.200
    17.958   248.133     0.200
    18.010   251.451     0.200
    18.158   252.893     0.200
    18.177   252.682     0.200
    18.177   251.951     0.200
    19.528   269.332     0.200
    19.522   269.633     0.200
    20.134   276.701     0.200
    20.567   281.951     0.200
     2.310    39.705     0.200
     2.634    44.105     0.200
     2.840    47.654     0.200
     3.061    50.205     0.200
     3.298    53.506     0.200
     3.346    53.006     0.200
     3.599    57.506     0.200
     3.599    56.666     0.200
     3.884    62.006     0.200
     3.995    63.006     0.200
     3.995    63.506     0.200
     4.056    64.404     0.200
     4.178    64.836     0.200
     4.185    65.105     0.200
     4.491    70.305     0.200
     4.525    69.904     0.200
     4.551    71.404     0.200
     4.695    72.205     0.200
     4.717    72.305     0.200
     4.818    74.035     0.200
     5.251    79.506     0.200
     5.664    85.006     0.200
     5.664    86.275     0.200
     5.725    87.205     0.200
     5.798    85.365     0.200
     5.798    88.006     0.200
     6.204    93.506     0.200
     6.234    94.686     0.200
     6.265    93.605     0.200
     6.265    93.715     0.200
     6.427    91.176     0.200
     6.593    98.625     0.200
     6.675   100.205     0.200
     7.086   103.936     0.200
     7.218   107.904     0.200
     7.218   109.154     0.200
     8.852   128.145     0.200
     9.191   132.625     0.200
     9.949   143.166     0.200
    10.594   151.324     0.200
    10.733   154.084     0.200
    10.733   153.086     0.200
    10.820   156.324     0.200
    12.059   170.426     0.200
    12.599   177.148     0.200
    12.599   178.766     0.200
    12.599   177.705     0.200
    13.412   190.006     0.200
    14.688   207.115     0.200
    14.688   208.033     0.200
    14.688   207.225     0.200
    14.942   211.965     0.200
    15.424   218.994     0.200
    16.057   223.180     0.200
    16.096   225.225     0.200
    19.324   267.381     0.200
    20.890   284.666     0.200
     2.369    40.645     0.200
     2.706    45.344     0.200
     3.131    50.344     0.200
     4.074    64.445     0.200
     4.125    65.344     0.200
     4.555    70.547     0.200
     4.610    72.070     0.200
     4.614    70.945     0.200
     4.802    73.844     0.200
     6.284    94.445     0.200
     6.752   101.547     0.200
     7.030   104.477     0.200
    12.532   177.641     0.200
    12.532   177.523     0.200
     2.525    42.098     0.200
     2.697    44.598     0.200
     2.697    45.496     0.200
     3.121    51.398     0.200
     3.357    53.996     0.200
     4.115    65.297     0.200
     4.542    70.398     0.200
     5.728    86.797     0.200
     6.342    94.797     0.200
    12.506   176.289     0.200
    12.506   178.117     0.200
     2.361    40.566     0.200
     2.677    44.566     0.200
     2.893    48.297     0.200
     3.213    51.668     0.200
     3.571    56.867     0.200
     3.571    57.527     0.200
     4.034    63.367     0.200
     4.034    63.699     0.200
     4.101    64.668     0.200
     4.183    65.398     0.200
     4.189    64.867     0.200
     4.539    70.668     0.200
     4.535    69.469     0.200
     4.601    71.422     0.200
     4.715    72.168     0.200
     4.865    74.840     0.200
     5.072    76.969     0.200
     5.072    76.777     0.200
     5.235    79.270     0.200
     5.707    86.668     0.200
     5.707    86.430     0.200
     5.779    87.566     0.200
     6.194    93.270     0.200
     6.227    93.367     0.200
     6.227    93.117     0.200
     6.269    94.328     0.200
     6.591    98.746     0.200
     6.661    99.867     0.200
     7.118   105.430     0.200
     7.164   107.969     0.200
     7.164   106.438     0.200
    12.624   178.074     0.200
    12.624   179.508     0.200
    16.112   223.691     0.200
     2.347    40.344     0.200
     2.530    42.344     0.200
     2.703    45.141     0.200
     3.115    51.242     0.200
     3.332    53.438     0.200
     3.696    58.742     0.200
     3.922    62.438     0.200
     4.063    64.141     0.200
     4.108    64.938     0.200
     4.289    67.039     0.200
     4.535    70.844     0.200
     4.587    70.469     0.200
     4.627    70.938     0.200
     4.822    74.242     0.200
     5.182    78.539     0.200
     5.700    82.562     0.200
     5.722    86.844     0.200
     5.822    87.938     0.200
     6.350    94.844     0.200
     6.309    94.641     0.200
     6.780   101.641     0.200
     6.994   102.969     0.200
     6.994   103.891     0.200
     8.751   126.750     0.200
     9.088   131.344     0.200
     9.852   141.594     0.200
    10.496   150.203     0.200
    10.643   152.164     0.200
    10.643   152.367     0.200
    10.823   153.742     0.200
    11.959   169.070     0.200
    12.431   175.250     0.200
    12.500   178.586     0.200
    12.500   177.102     0.200
    12.500   177.664     0.200
    12.500   177.531     0.200
    13.937   195.688     0.200
    14.656   208.961     0.200
    14.960   208.664     0.200
    14.854   212.336     0.200
    14.997   213.328     0.200
    15.994   222.633     0.200
    16.032   223.266     0.200
     2.269    39.357     0.200
     2.583    43.658     0.200
     3.012    50.058     0.200
     3.176    51.458     0.200
     3.249    53.357     0.200
     3.841    61.658     0.200
     3.940    61.857     0.200
     4.007    63.458     0.200
     4.126    64.058     0.200
     4.446    69.257     0.200
     4.465    69.058     0.200
     4.509    70.658     0.200
     4.659    70.958     0.200
     5.200    79.058     0.200
     5.685    85.857     0.200
     5.750    87.558     0.200
     6.048    91.158     0.200
     6.151    92.458     0.200
     6.624    98.658     0.200
    10.768   153.475     0.200
    12.643   179.427     0.200
    14.681   205.333     0.200
    16.046   223.433     0.200
    16.046   222.884     0.200
     2.297    39.589     0.200
     2.616    43.989     0.200
     2.586    43.289     0.200
     3.045    49.989     0.200
     3.870    61.489     0.200
     3.976    63.289     0.200
     4.039    64.489     0.200
     4.161    64.890     0.200
     4.476    70.189     0.200
     4.501    69.589     0.200
     4.537    70.339     0.200
     4.671    71.890     0.200
     4.693    71.890     0.200
     6.068    91.390     0.200
     7.631   112.689     0.200
    10.750   153.650     0.200
    14.690   205.114     0.200
    16.057   226.104     0.200
     2.328    40.219     0.200
     2.660    44.219     0.200
     2.853    47.277     0.200
     3.086    50.418     0.200
     3.389    53.918     0.200
     3.641    57.617     0.200
     3.641    58.020     0.200
     3.902    61.918     0.200
     4.027    62.820     0.200
     4.027    63.297     0.200
     4.080    65.020     0.200
     4.224    65.000     0.200
     4.512    70.520     0.200
     4.568    72.168     0.200
     4.570    70.719     0.200
     4.763    72.820     0.200
     4.841    74.598     0.200
     5.146    77.859     0.200
     5.296    79.820     0.200
     5.691    86.359     0.200
     5.843    88.617     0.200
     6.269    94.730     0.200
     6.250    94.117     0.200
     6.301    94.520     0.200
     6.301    94.238     0.200
     6.639   100.070     0.200
     7.232   107.578     0.200
    16.048   225.219     0.200
     2.353    40.377     0.200
     2.507    42.177     0.200
     2.678    44.776     0.200
     2.692    44.776     0.200
     2.874    48.496     0.200
     3.117    51.177     0.200
     3.309    52.977     0.200
     3.353    53.776     0.200
     3.671    57.977     0.200
     3.928    62.776     0.200
     4.061    63.477     0.200
     4.061    63.267     0.200
     4.264    66.356     0.200
     4.271    66.177     0.200
     4.594    71.688     0.200
     4.781    73.276     0.200
     4.803    73.377     0.200
     4.869    74.677     0.200
     5.158    79.387     0.200
     5.332    80.877     0.200
     5.714    83.057     0.200
     5.723    86.776     0.200
     5.723    87.746     0.200
     5.797    87.576     0.200
     5.877    88.477     0.200
     6.155    92.477     0.200
     6.325    94.887     0.200
     6.288    94.276     0.200
     6.305    94.387     0.200
     6.501    92.496     0.200
     6.757   101.477     0.200
     7.019   103.946     0.200
     9.877   141.467     0.200
    10.521   148.937     0.200
    10.668   152.026     0.200
    10.847   154.177     0.200
    11.983   168.477     0.200
    12.454   175.557     0.200
    12.524   176.468     0.200
    12.524   177.866     0.200
    13.961   196.347     0.200
    14.998   212.687     0.200
    16.018   224.137     0.200
    16.051   222.651     0.200
     2.388    41.016     0.200
     2.517    42.117     0.200
     2.682    44.715     0.200
     2.727    45.516     0.200
     2.908    48.277     0.200
     3.321    53.414     0.200
     3.388    55.215     0.200
     3.430    54.715     0.200
     3.674    58.215     0.200
     3.674    58.484     0.200
     4.095    64.715     0.200
     4.146    65.215     0.200
     4.286    66.227     0.200
     4.293    66.414     0.200
     4.574    71.617     0.200
     4.628    72.289     0.200
     4.635    71.316     0.200
     4.822    73.715     0.200
     4.904    76.215     0.200
     5.143    78.016     0.200
     5.343    80.715     0.200
     5.758    87.645     0.200
     5.800    87.617     0.200
     5.886    88.316     0.200
     6.156    92.617     0.200
     6.302    94.914     0.200
     6.338    95.766     0.200
     6.319    94.816     0.200
     6.319    94.957     0.200
     6.698   100.605     0.200
     6.769   100.816     0.200
     7.020   103.914     0.200
     7.211   108.457     0.200
    10.671   151.797     0.200
    12.519   177.410     0.200
    12.519   178.125     0.200
    12.519   178.246     0.200
    14.701   205.582     0.200
    16.077   223.066     0.200
    16.077   223.535     0.200
     2.346    40.211     0.200
     2.689    44.914     0.200
     2.866    47.633     0.200
     3.113    51.312     0.200
     3.078    49.609     0.200
     3.323    53.312     0.200
     3.438    54.609     0.200
     3.687    58.930     0.200
     3.921    62.414     0.200
     4.060    64.109     0.200
     4.060    64.250     0.200
     4.107    64.711     0.200
     4.274    66.883     0.200
     4.534    71.414     0.200
     4.587    71.914     0.200
     4.814    73.609     0.200
     4.864    74.969     0.200
     5.175    78.211     0.200
     5.175    78.469     0.200
     5.720    87.305     0.200
     5.813    88.109     0.200
     5.892    89.109     0.200
     6.171    92.516     0.200
     6.306    95.180     0.200
     6.301    94.312     0.200
     6.341    95.016     0.200
     6.341    95.172     0.200
     6.517    92.406     0.200
     6.689   100.133     0.200
     6.771   100.711     0.200
     7.002   103.461     0.200
     7.250   107.414     0.200
     7.250   108.531     0.200
    10.652   151.477     0.200
    12.509   176.078     0.200
    12.509   176.188     0.200
    12.509   176.703     0.200
    14.662   204.203     0.200
    14.969   209.602     0.200
    16.037   223.039     0.200
    16.037   222.539     0.200
     2.280    39.963     0.200
     2.378    40.062     0.200
     2.416    41.362     0.200
     2.602    43.862     0.200
     2.599    43.963     0.200
     2.811    47.303     0.200
     2.752    45.963     0.200
     3.030    49.862     0.200
     3.266    53.562     0.200
     3.337    53.562     0.200
     3.593    57.862     0.200
     3.593    57.373     0.200
     3.853    62.163     0.200
     3.964    62.862     0.200
     3.964    63.112     0.200
     4.024    64.362     0.200
     4.156    65.003     0.200
     4.163    65.062     0.200
     4.460    70.062     0.200
     4.520    70.737     0.200
     4.520    69.753     0.200
     4.501    69.663     0.200
     4.672    71.963     0.200
     4.697    72.463     0.200
     4.787    73.232     0.200
     5.132    77.562     0.200
     5.238    80.062     0.200
     5.632    86.263     0.200
     5.720    86.862     0.200
     5.787    87.963     0.200
     6.082    92.163     0.200
     6.203    93.272     0.200
     6.189    93.263     0.200
     6.267    93.963     0.200
     6.267    94.093     0.200
     6.572    98.522     0.200
     6.661   100.362     0.200
     7.089   104.782     0.200
     7.089   104.963     0.200
     6.993   104.263     0.200
     7.237   108.062     0.200
     7.237   107.303     0.200
     7.624   113.663     0.200
     8.861   129.603     0.200
     9.204   134.413     0.200
     9.955   143.603     0.200
     9.859   143.663     0.200
    10.600   151.732     0.200
    10.734   152.812     0.200
    10.734   153.263     0.200
    10.734   153.333     0.200
    10.933   156.723     0.200
    12.607   179.057     0.200
    12.607   179.902     0.200
    12.607   179.263     0.200
    12.607   180.213     0.200
    13.422   191.062     0.200
    14.051   198.263     0.200
    14.668   208.583     0.200
    14.668   204.588     0.200
    14.668   208.123     0.200
    14.755   212.731     0.200
    14.910   212.303     0.200
    15.619   216.663     0.200
    16.035   223.263     0.200
    16.107   224.003     0.200
    17.257   243.362     0.200
    17.318   241.663     0.200
    18.152   251.543     0.200
    18.152   251.373     0.200
    19.074   265.862     0.200
    19.587   271.163     0.200
    20.104   277.062     0.200
    20.435   280.663     0.200
    20.977   287.362     0.200
     2.325    40.234     0.200
     2.487    41.836     0.200
     2.663    44.836     0.200
     2.662    44.938     0.200
     2.849    47.750     0.200
     2.830    46.641     0.200
     3.087    50.336     0.200
     3.288    52.539     0.200
     3.323    53.938     0.200
     3.405    54.336     0.200
     3.656    57.836     0.200
     3.656    58.219     0.200
     3.900    62.336     0.200
     4.030    63.539     0.200
     4.030    63.188     0.200
     4.081    64.539     0.200
     4.236    66.109     0.200
     4.243    65.336     0.200
     4.511    70.836     0.200
     4.566    71.984     0.200
     4.582    70.734     0.200
     4.776    73.039     0.200
     4.840    74.578     0.200
     5.160    78.234     0.200
     5.160    78.375     0.200
     5.311    80.734     0.200
     5.693    85.836     0.200
     5.782    87.234     0.200
     5.858    88.734     0.200
     6.142    92.539     0.200
     6.273    93.914     0.200
     6.317    94.641     0.200
     6.652    99.414     0.200
     7.031   102.609     0.200
     7.245   108.789     0.200
    10.679   151.859     0.200
    12.540   176.633     0.200
    12.540   178.047     0.200
    12.540   177.148     0.200
    14.821   210.508     0.200
    15.004   210.234     0.200
    16.037   223.734     0.200
    16.037   222.281     0.200
    17.375   243.891     0.200
    18.999   264.141     0.200
    19.511   270.539     0.200
    20.359   277.836     0.200
     2.238    39.025     0.200
     2.322    39.226     0.200
     2.373    40.226     0.200
     2.552    42.825     0.200
     2.564    43.126     0.200
     2.774    46.695     0.200
     2.703    44.825     0.200
     2.981    48.825     0.200
     3.217    53.226     0.200
     3.168    50.726     0.200
     3.297    52.626     0.200
     3.559    56.626     0.200
     3.559    56.365     0.200
     3.910    61.825     0.200
     3.910    62.056     0.200
     3.975    63.126     0.200
     4.101    63.615     0.200
     4.108    63.825     0.200
     4.415    69.025     0.200
     4.477    69.101     0.200
     4.445    68.626     0.200
     4.616    71.325     0.200
     4.644    71.325     0.200
     4.740    73.916     0.200
     5.125    77.525     0.200
     5.125    78.405     0.200
     5.193    78.226     0.200
     5.582    84.825     0.200
     5.582    85.855     0.200
     5.685    86.025     0.200
     5.745    87.025     0.200
     5.882    85.936     0.200
     6.050    91.226     0.200
     6.148    92.016     0.200
     6.140    92.926     0.200
     6.244    93.226     0.200
     6.244    93.636     0.200
     6.520    97.626     0.200
     6.616    99.325     0.200
     7.121   105.485     0.200
     7.119   104.936     0.200
     7.245   109.775     0.200
     7.809   115.365     0.200
     8.119   119.226     0.200
     8.902   128.176     0.200
     9.248   133.336     0.200
     9.991   143.115     0.200
    10.637   151.716     0.200
    10.764   153.370     0.200
    10.764   153.506     0.200
    10.873   156.745     0.200
    12.109   170.695     0.200
    12.645   179.170     0.200
    12.645   178.855     0.200
    12.645   178.964     0.200
    12.645   180.485     0.200
    12.645   177.956     0.200
    13.462   191.896     0.200
    14.094   198.686     0.200
    14.658   205.136     0.200
    14.658   205.315     0.200
    14.861   210.436     0.200
    16.021   222.976     0.200
    16.021   222.056     0.200
    17.269   242.126     0.200
     2.267    39.320     0.200
     2.399    40.621     0.200
     2.586    43.422     0.200
     2.585    43.521     0.200
     2.800    47.221     0.200
     2.734    45.221     0.200
     3.014    49.621     0.200
     3.321    53.021     0.200
     3.579    56.820     0.200
     3.579    56.961     0.200
     3.840    61.422     0.200
     3.946    61.621     0.200
     3.946    62.650     0.200
     4.009    63.621     0.200
     4.136    64.352     0.200
     4.143    64.221     0.200
     4.446    69.021     0.200
     4.507    68.570     0.200
     4.481    69.121     0.200
     4.652    71.721     0.200
     4.677    71.521     0.200
     4.772    73.971     0.200
     5.045    78.172     0.200
     5.126    76.820     0.200
     5.220    79.121     0.200
     5.616    85.621     0.200
     5.705    86.221     0.200
     6.069    91.422     0.200
     6.185    93.611     0.200
     6.170    92.922     0.200
     6.256    93.611     0.200
     6.553    98.582     0.200
     7.151   106.400     0.200
     7.237   106.201     0.200
     7.844   116.980     0.200
     8.156   119.922     0.200
    10.747   153.746     0.200
    11.660   169.971     0.200
    12.622   178.314     0.200
    12.622   178.689     0.200
    14.668   205.904     0.200
    16.033   222.646     0.200
    16.033   224.062     0.200
     2.301    39.785     0.200
     2.321    39.688     0.200
     2.350    40.086     0.200
     2.501    42.285     0.200
     2.600    43.484     0.200
     2.665    44.188     0.200
     2.843    47.508     0.200
     3.032    49.785     0.200
     3.121    50.285     0.200
     3.240    52.086     0.200
     3.268    53.484     0.200
     3.495    55.484     0.200
     3.871    61.984     0.200
     3.948    62.574     0.200
     4.027    63.586     0.200
     4.081    63.277     0.200
     4.087    63.285     0.200
     4.472    69.688     0.200
     4.539    71.285     0.200
     4.600    70.887     0.200
     4.615    70.688     0.200
     4.795    74.777     0.200
     5.042    76.477     0.200
     5.144    77.785     0.200
     5.621    84.984     0.200
     5.628    86.387     0.200
     5.628    85.785     0.200
     5.692    85.984     0.200
     5.983    90.484     0.200
     6.168    92.586     0.200
     6.168    92.848     0.200
     6.178    93.688     0.200
     6.491    97.445     0.200
     6.569    98.688     0.200
     6.905   103.387     0.200
     7.086   104.637     0.200
     7.160   106.375     0.200
     7.188   106.316     0.200
     8.115   119.285     0.200
    10.834   153.953     0.200
    12.704   179.953     0.200
    12.704   179.512     0.200
    14.742   207.727     0.200
    16.105   224.461     0.200
    16.105   223.516     0.200
    17.319   241.336     0.200
    18.058   250.258     0.200
     2.342    40.316     0.200
     2.511    42.020     0.200
     2.684    44.617     0.200
     2.683    44.816     0.200
     2.855    46.719     0.200
     3.107    50.316     0.200
     3.312    53.520     0.200
     3.343    54.020     0.200
     3.428    54.316     0.200
     3.677    58.117     0.200
     3.917    62.418     0.200
     4.053    63.219     0.200
     4.101    64.816     0.200
     4.271    66.316     0.200
     4.529    71.020     0.200
     4.583    73.191     0.200
     4.609    71.219     0.200
     4.803    73.816     0.200
     5.803    88.117     0.200
     5.881    89.020     0.200
     6.290    94.117     0.200
     6.333    94.520     0.200
    12.518   178.211     0.200
     2.302    39.792     0.200
     2.382    39.792     0.200
     2.384    40.592     0.200
     2.564    43.092     0.200
     2.726    45.192     0.200
     2.837    47.352     0.200
     3.046    49.492     0.200
     3.184    50.892     0.200
     3.303    52.892     0.200
     3.558    56.592     0.200
     3.558    56.782     0.200
     3.973    62.892     0.200
     3.973    62.602     0.200
     4.040    64.192     0.200
     4.138    64.192     0.200
     4.144    64.292     0.200
     4.486    69.292     0.200
     4.542    70.792     0.200
     4.655    71.192     0.200
     4.675    71.892     0.200
     4.805    74.262     0.200
     5.091    76.562     0.200
     5.207    79.192     0.200
     5.646    85.992     0.200
     5.684    85.892     0.200
     5.755    87.192     0.200
     6.208    92.962     0.200
     6.228    93.492     0.200
     6.551    98.042     0.200
     6.896   103.092     0.200
     6.966   103.392     0.200
     6.999   103.592     0.200
     7.147   106.102     0.200
     7.198   105.522     0.200
     7.621   112.892     0.200
     7.846   114.802     0.200
     8.165   119.892     0.200
    10.772   153.242     0.200
    12.641   179.261     0.200
    14.763   211.236     0.200
    16.073   224.817     0.200
    16.073   225.842     0.200
    17.334   241.592     0.200
    18.122   250.652     0.200
    19.355   267.872     0.200
    19.563   269.927     0.200
    20.036   275.667     0.200
     2.317    39.904     0.200
     2.444    40.203     0.200
     2.489    41.703     0.200
     2.654    44.404     0.200
     2.666    44.504     0.200
     2.840    47.393     0.200
     2.830    46.303     0.200
     3.079    49.504     0.200
     3.315    53.604     0.200
     3.289    52.504     0.200
     3.407    54.104     0.200
     3.660    57.523     0.200
     3.892    61.904     0.200
     4.023    63.004     0.200
     4.023    63.193     0.200
     4.073    64.303     0.200
     4.235    65.514     0.200
     4.242    65.404     0.200
     4.502    70.004     0.200
     4.558    68.754     0.200
     4.579    70.004     0.200
     4.750    72.904     0.200
     4.775    72.803     0.200
     4.832    74.283     0.200
     5.167    77.553     0.200
     5.312    80.303     0.200
     5.685    86.104     0.200
     5.748    84.004     0.200
     5.860    88.404     0.200
     6.146    92.203     0.200
     6.267    93.203     0.200
     6.265    94.203     0.200
     6.322    94.104     0.200
     6.322    94.514     0.200
     6.651    99.443     0.200
     7.026   103.094     0.200
     7.026   103.533     0.200
     7.070   105.104     0.200
     7.094   104.803     0.200
     7.249   107.404     0.200
     7.253   107.904     0.200
     7.942   117.484     0.200
     8.253   121.004     0.200
     8.278   121.303     0.200
     8.790   127.213     0.200
     9.130   131.893     0.200
     9.888   142.104     0.200
    10.533   149.664     0.200
    10.674   151.879     0.200
    10.674   152.213     0.200
    10.862   153.713     0.200
    11.683   168.104     0.200
    12.537   175.523     0.200
    12.537   177.414     0.200
    12.537   175.668     0.200
    12.537   178.334     0.200
    13.978   196.703     0.200
    14.222   200.104     0.200
    14.330   204.713     0.200
    14.656   205.305     0.200
    14.814   210.898     0.200
    14.814   210.154     0.200
    14.960   212.383     0.200
    15.568   215.502     0.200
    16.028   221.479     0.200
    16.028   222.973     0.200
    16.034   224.283     0.200
    17.367   239.654     0.200
    18.143   251.904     0.200
    18.226   251.793     0.200
    18.226   250.994     0.200
     2.451    41.141     0.200
     2.497    42.438     0.200
     2.674    44.836     0.200
     2.660    44.938     0.200
     2.838    46.836     0.200
     2.843    47.758     0.200
     3.085    50.734     0.200
     3.297    52.938     0.200
     3.321    53.734     0.200
     3.415    54.836     0.200
     3.667    58.234     0.200
     3.667    58.641     0.200
     3.896    62.039     0.200
     4.029    63.641     0.200
     4.078    65.234     0.200
     4.243    65.688     0.200
     4.250    65.641     0.200
     4.507    70.734     0.200
     4.562    70.836     0.200
     4.588    70.836     0.200
     4.759    72.438     0.200
     4.784    73.438     0.200
     4.837    74.977     0.200
     5.171    78.438     0.200
     5.320    80.734     0.200
     5.691    86.141     0.200
     5.691    86.695     0.200
     5.739    88.297     0.200
     5.739    88.430     0.200
     5.739    85.305     0.200
     5.739    87.641     0.200
     5.793    87.641     0.200
     5.816    89.883     0.200
     5.868    88.938     0.200
     6.002    90.141     0.200
     6.153    92.539     0.200
     6.274    94.336     0.200
     6.274    94.359     0.200
     6.328    94.938     0.200
     6.660    99.555     0.200
     6.745   101.438     0.200
     6.746   100.938     0.200
     6.968   104.039     0.200
     7.020   103.469     0.200
     7.020   103.766     0.200
     7.020   103.336     0.200
     7.020   103.188     0.200
     7.026   104.734     0.200
     7.078   104.539     0.200
     7.102   105.539     0.200
     7.255   108.141     0.200
     7.257   107.438     0.200
     7.257   107.758     0.200
     7.520   111.039     0.200
     7.704   113.539     0.200
     7.816   114.625     0.200
     7.951   118.055     0.200
     8.106   119.438     0.200
     8.133   119.438     0.200
     8.262   121.141     0.200
     8.286   122.039     0.200
     8.314   122.141     0.200
     8.523   124.641     0.200
     8.616   126.641     0.200
     8.749   128.336     0.200
     8.783   127.867     0.200
     8.829   129.141     0.200
     8.943   131.047     0.200
     9.122   132.508     0.200
     9.156   132.461     0.200
     9.156   134.141     0.200
     9.311   134.539     0.200
     9.311   138.148     0.200
     9.311   138.258     0.200
     9.470   138.836     0.200
     9.538   140.234     0.200
     9.554   139.438     0.200
     9.554   139.938     0.200
     9.637   139.461     0.200
     9.717   140.055     0.200
     9.881   141.508     0.200
    10.011   146.898     0.200
    10.011   146.016     0.200
    10.052   147.195     0.200
    10.052   146.289     0.200
    10.178   147.141     0.200
    10.285   148.938     0.200
    10.285   149.156     0.200
    10.344   151.500     0.200
    10.525   149.797     0.200
    10.597   153.977     0.200
    10.603   154.289     0.200
    10.603   152.297     0.200
    10.607   154.961     0.200
    10.668   152.359     0.200
    10.668   152.109     0.200
    10.854   153.367     0.200
    10.871   159.141     0.200
    10.919   156.570     0.200
    10.956   156.344     0.200
    10.956   156.984     0.200
    10.956   155.969     0.200
    10.956   159.219     0.200
    10.956   156.859     0.200
    10.956   158.258     0.200
    10.956   156.227     0.200
    10.992   159.906     0.200
    11.061   157.352     0.200
    11.061   157.180     0.200
    11.092   160.961     0.200
    11.145   161.680     0.200
    11.145   162.406     0.200
    11.248   163.469     0.200
    11.388   165.078     0.200
    11.415   165.039     0.200
    11.415   164.234     0.200
    11.562   167.500     0.200
    11.562   166.141     0.200
    11.607   168.414     0.200
    11.620   167.375     0.200
    11.640   165.102     0.200
    11.675   167.438     0.200
    11.813   170.023     0.200
    11.814   171.266     0.200
    11.814   168.836     0.200
    11.894   172.141     0.200
    11.933   172.078     0.200
    11.933   171.625     0.200
    11.990   169.414     0.200
    12.047   174.141     0.200
    12.115   174.875     0.200
    12.101   174.812     0.200
    12.118   171.570     0.200
    12.299   176.773     0.200
    12.328   175.031     0.200
    12.321   177.336     0.200
    12.386   177.570     0.200
    12.455   179.250     0.200
    12.464   175.531     0.200
    12.530   176.953     0.200
    12.530   176.844     0.200
    12.530   177.211     0.200
    12.530   177.531     0.200
    12.530   177.086     0.200
    12.530   178.391     0.200
    12.578   180.250     0.200
    12.634   181.883     0.200
    12.698   178.320     0.200
    12.748   182.438     0.200
    12.816   181.117     0.200
    12.877   183.898     0.200
    12.894   181.789     0.200
    12.924   185.938     0.200
    13.016   185.367     0.200
    13.016   186.719     0.200
    13.064   188.039     0.200
    13.157   188.281     0.200
    13.161   188.109     0.200
    13.184   187.938     0.200
    13.196   189.258     0.200
    13.343   188.734     0.200
    13.360   187.539     0.200
    13.336   190.438     0.200
    13.372   190.977     0.200
    13.391   192.367     0.200
    13.393   193.016     0.200
    13.412   189.469     0.200
    13.430   190.836     0.200
    13.666   197.539     0.200
    13.679   193.547     0.200
    13.730   197.836     0.200
    13.749   197.836     0.200
    13.790   198.344     0.200
    13.824   195.250     0.200
    13.830   197.141     0.200
    13.853   196.062     0.200
    13.906   197.250     0.200
    13.911   197.805     0.200
    13.970   196.336     0.200
    14.008   199.539     0.200
    14.044   196.938     0.200
    14.113   201.523     0.200
    14.158   201.438     0.200
    14.224   203.016     0.200
    14.382   202.461     0.200
    14.337   205.797     0.200
    14.388   201.750     0.200
    14.655   205.781     0.200
    14.655   203.164     0.200
    14.655   207.078     0.200
    14.663   210.578     0.200
    14.721   209.539     0.200
    14.820   213.648     0.200
    14.820   209.906     0.200
    14.820   212.328     0.200
    14.820   212.586     0.200
    14.820   212.836     0.200
    14.820   213.281     0.200
    14.820   212.961     0.200
    14.937   209.234     0.200
    14.995   210.016     0.200
    14.995   210.414     0.200
    14.966   211.695     0.200
    15.131   216.750     0.200
    15.202   212.508     0.200
    15.451   218.109     0.200
    15.562   215.820     0.200
    15.574   218.727     0.200
    15.713   220.094     0.200
    15.725   221.609     0.200
    15.754   223.047     0.200
    15.844   222.969     0.200
    15.844   222.391     0.200
    15.844   225.297     0.200
    15.899   225.469     0.200
    16.216   225.859     0.200
    16.027   223.031     0.200
    16.027   222.742     0.200
    16.028   222.641     0.200
    16.185   226.117     0.200
    16.202   227.500     0.200
    16.317   231.641     0.200
    16.555   234.289     0.200
    16.814   235.836     0.200
    16.926   238.094     0.200
    17.155   238.250     0.200
    17.155   241.836     0.200
    17.372   241.875     0.200
    17.372   242.039     0.200
    17.491   243.648     0.200
    17.534   244.539     0.200
    17.558   246.391     0.200
    17.607   244.625     0.200
    17.607   244.820     0.200
    17.607   245.211     0.200
    17.607   243.484     0.200
    17.607   245.625     0.200
    17.634   247.641     0.200
    17.880   247.938     0.200
    17.960   252.055     0.200
    18.053   251.656     0.200
    18.151   251.078     0.200
    18.191   251.188     0.200
    18.191   251.719     0.200
    18.234   252.164     0.200
    18.234   251.617     0.200
    18.234   252.008     0.200
    18.234   252.406     0.200
    18.263   254.539     0.200
    18.997   262.141     0.200
    19.382   269.297     0.200
    19.486   270.531     0.200
    19.486   270.680     0.200
    20.117   275.305     0.200
    20.399   278.844     0.200
     2.249    39.070     0.200
     2.295    38.871     0.200
     2.544    42.771     0.200
     2.633    43.672     0.200
     2.977    48.771     0.200
     3.213    53.070     0.200
     3.222    51.271     0.200
     3.483    56.172     0.200
     3.892    61.371     0.200
     3.892    62.301     0.200
     3.971    63.271     0.200
     4.039    63.342     0.200
     4.046    62.971     0.200
     4.388    67.471     0.200
     4.418    68.570     0.200
     4.486    70.396     0.200
     4.557    70.371     0.200
     4.578    70.070     0.200
     5.060    75.660     0.200
     5.119    77.971     0.200
     5.572    84.871     0.200
     5.609    85.371     0.200
     5.670    85.271     0.200
     5.974    90.172     0.200
     5.933    88.381     0.200
     6.069    91.471     0.200
     6.169    92.971     0.200
     6.169    91.502     0.200
     6.543    97.971     0.200
     6.900   102.570     0.200
     7.051   105.910     0.200
     7.192   105.271     0.200
     7.196   106.371     0.200
     7.196   107.141     0.200
     7.527   110.971     0.200
     7.748   115.541     0.200
     8.977   130.842     0.200
     9.322   134.951     0.200
    10.067   144.842     0.200
    10.713   152.451     0.200
    10.839   154.576     0.200
    10.839   154.602     0.200
    11.048   156.432     0.200
    12.185   173.650     0.200
    12.721   180.266     0.200
    12.721   180.131     0.200
    12.721   179.641     0.200
    12.721   180.820     0.200
    13.537   192.561     0.200
    14.168   199.070     0.200
    14.710   206.852     0.200
    14.710   207.682     0.200
    14.710   206.961     0.200
    14.853   210.332     0.200
    16.224   228.752     0.200
    17.273   242.230     0.200
     2.372    40.445     0.200
     2.520    41.746     0.200
     2.688    44.645     0.200
     3.137    51.344     0.200
     3.434    55.047     0.200
     3.373    54.645     0.200
     3.693    58.746     0.200
     3.680    58.246     0.200
     3.947    63.645     0.200
     4.131    65.246     0.200
     4.559    70.945     0.200
     4.820    74.145     0.200
     5.744    87.844     0.200
     6.163    92.945     0.200
     6.329    94.547     0.200
     6.771   101.344     0.200
     2.256    39.227     0.200
     2.305    39.023     0.200
     2.307    39.625     0.200
     2.495    42.227     0.200
     2.643    43.922     0.200
     2.799    47.047     0.200
     2.986    48.727     0.200
     3.104    49.922     0.200
     3.222    52.227     0.200
     3.229    51.828     0.200
     3.490    56.273     0.200
     3.825    61.625     0.200
     3.902    61.828     0.200
     3.902    61.312     0.200
     3.980    63.422     0.200
     4.050    62.867     0.200
     4.057    63.125     0.200
     4.426    69.328     0.200
     4.494    69.328     0.200
     4.588    70.328     0.200
     4.748    73.648     0.200
     5.062    76.328     0.200
     5.062    76.922     0.200
     5.128    77.828     0.200
     5.582    84.625     0.200
     5.582    84.727     0.200
     5.616    84.625     0.200
     5.679    86.328     0.200
     5.922    89.422     0.200
     5.981    90.227     0.200
     6.079    91.523     0.200
     6.133    91.852     0.200
     6.174    92.328     0.200
     6.174    92.578     0.200
     6.464    96.938     0.200
     6.552    98.227     0.200
     6.818   101.625     0.200
     6.883   102.727     0.200
     7.061   104.867     0.200
     7.190   105.422     0.200
     7.190   106.586     0.200
     8.078   118.727     0.200
     8.119   119.023     0.200
     8.123   119.922     0.200
     8.764   128.195     0.200
     9.056   132.023     0.200
     9.056   131.898     0.200
     9.765   141.969     0.200
    10.833   154.312     0.200
    11.145   159.227     0.200
    14.712   207.188     0.200
    14.692   209.578     0.200
    14.692   210.070     0.200
    14.863   210.875     0.200
    15.578   221.742     0.200
    16.072   223.672     0.200
    16.409   231.836     0.200
    17.273   239.898     0.200
    17.508   242.562     0.200
    18.042   250.078     0.200
    18.042   249.438     0.200
    18.195   254.133     0.200
    18.847   262.781     0.200
     2.316    40.109     0.200
     2.635    44.109     0.200
     2.750    45.109     0.200
     3.063    50.414     0.200
     3.207    52.016     0.200
     3.324    53.414     0.200
     3.300    54.109     0.200
     3.577    56.812     0.200
     3.610    57.414     0.200
     3.889    62.109     0.200
     3.993    63.109     0.200
     4.058    64.516     0.200
     4.169    64.711     0.200
     4.495    70.414     0.200
     4.556    70.688     0.200
     2.225    38.719     0.200
     2.539    42.818     0.200
     2.700    44.719     0.200
     2.761    46.139     0.200
     2.968    49.318     0.200
     3.205    52.719     0.200
     3.297    53.020     0.200
     3.797    60.818     0.200
     3.898    61.520     0.200
     3.898    61.830     0.200
     3.963    63.420     0.200
     4.095    63.939     0.200
     4.102    63.520     0.200
     4.437    68.318     0.200
     4.402    68.920     0.200
     4.465    71.094     0.200
     4.610    71.420     0.200
     4.639    71.219     0.200
     4.727    73.770     0.200
     5.133    77.559     0.200
     5.191    79.119     0.200
     5.570    84.539     0.200
     5.686    85.420     0.200
     6.136    92.479     0.200
     6.248    93.818     0.200
     6.248    94.059     0.200
     6.613    99.119     0.200
     8.111   119.318     0.200
    12.645   178.764     0.200
     2.254    39.081     0.200
     2.326    39.480     0.200
     2.563    43.280     0.200
     2.792    46.780     0.200
     2.993    48.681     0.200
     3.149    50.581     0.200
     3.229    52.980     0.200
     3.275    52.380     0.200
     3.535    56.280     0.200
     3.825    60.880     0.200
     3.917    62.181     0.200
     3.917    62.431     0.200
     3.987    63.480     0.200
     4.090    63.641     0.200
     4.097    63.181     0.200
     4.429    68.780     0.200
     4.436    68.480     0.200
     4.493    71.271     0.200
     4.606    70.681     0.200
     4.630    70.980     0.200
     5.098    76.780     0.200
     5.098    77.030     0.200
     5.173    78.380     0.200
     5.592    85.280     0.200
     5.661    85.581     0.200
     5.724    86.380     0.200
     6.026    91.081     0.200
     6.123    92.081     0.200
     6.217    93.081     0.200
     6.217    93.240     0.200
     6.361    90.931     0.200
     6.506    97.630     0.200
     7.104   106.940     0.200
     7.219   106.280     0.200
     7.566   112.181     0.200
     8.113   119.181     0.200
    10.789   153.331     0.200
    12.667   180.274     0.200
    12.667   179.171     0.200
    14.684   205.206     0.200
    16.046   223.855     0.200
    16.046   222.915     0.200
     2.388    41.453     0.200
     2.906    48.781     0.200
     2.892    47.648     0.200
     3.028    49.953     0.200
     3.344    54.750     0.200
     3.453    55.648     0.200
     3.698    58.852     0.200
     3.698    59.023     0.200
     3.705    59.453     0.200
     4.104    65.047     0.200
     4.104    65.281     0.200
     4.307    68.242     0.200
     4.313    67.148     0.200
     4.576    71.148     0.200
     4.629    73.953     0.200
     4.629    72.812     0.200
     4.654    72.648     0.200
     4.843    74.648     0.200
     4.907    76.203     0.200
     5.366    81.352     0.200
     5.669    84.852     0.200
     5.764    88.281     0.200
     5.823    88.250     0.200
     5.909    89.352     0.200
     6.342    95.648     0.200
     6.342    95.453     0.200
     6.529    94.133     0.200
     6.719   100.781     0.200
     6.996   103.844     0.200
     7.227   108.352     0.200
     7.227   107.602     0.200
     8.745   127.656     0.200
     9.851   142.156     0.200
    10.494   150.789     0.200
    10.647   152.023     0.200
    10.647   152.258     0.200
    10.818   153.852     0.200
    11.953   169.547     0.200
    12.085   171.570     0.200
    12.421   175.258     0.200
    12.496   176.992     0.200
    12.496   177.227     0.200
    12.496   177.492     0.200
    12.496   178.961     0.200
    12.781   181.367     0.200
    12.861   182.961     0.200
    12.875   182.273     0.200
    13.305   187.953     0.200
    13.324   187.789     0.200
    13.928   196.648     0.200
    14.170   199.094     0.200
    14.687   208.039     0.200
    14.687   206.031     0.200
    14.687   207.500     0.200
    14.947   209.992     0.200
    15.986   223.633     0.200
    16.064   224.578     0.200
    16.064   223.188     0.200
    17.444   243.625     0.200
    18.280   252.906     0.200
    19.420   268.547     0.200
     2.239    38.635     0.200
     2.698    44.135     0.200
     2.776    45.904     0.200
     2.877    47.135     0.200
     2.981    48.535     0.200
     3.163    50.334     0.200
     3.218    52.035     0.200
     3.291    52.234     0.200
     3.608    56.436     0.200
     3.811    60.135     0.200
     3.909    61.135     0.200
     3.909    61.766     0.200
     3.976    62.834     0.200
     4.097    63.414     0.200
     4.104    63.234     0.200
     4.415    68.334     0.200
     4.441    67.635     0.200
     4.479    69.234     0.200
     4.479    69.715     0.200
     4.612    70.734     0.200
     4.639    70.834     0.200
     4.740    72.355     0.200
     5.120    77.135     0.200
     5.582    84.674     0.200
     5.679    85.635     0.200
     5.739    86.135     0.200
     5.885    85.314     0.200
     6.044    90.834     0.200
     6.146    91.734     0.200
     6.135    92.535     0.200
     6.238    92.635     0.200
     6.238    92.824     0.200
     6.265    93.936     0.200
     6.378    93.186     0.200
     6.515    96.715     0.200
     6.610    99.135     0.200
     7.127   104.275     0.200
     7.240   106.035     0.200
     7.240   105.654     0.200
     7.719   113.584     0.200
     7.988   116.436     0.200
     8.380   122.035     0.200
     8.908   128.875     0.200
     8.908   127.445     0.200
     9.254   132.225     0.200
     9.410   136.945     0.200
    10.426   149.254     0.200
    10.643   151.346     0.200
    10.770   152.500     0.200
    10.770   152.875     0.200
    10.978   154.045     0.200
    12.651   178.766     0.200
    12.651   177.922     0.200
    13.133   186.365     0.200
    14.662   204.125     0.200
    14.662   204.254     0.200
    14.662   204.795     0.200
    14.861   211.115     0.200
    15.131   212.904     0.200
    16.025   223.686     0.200
    16.025   222.041     0.200
    18.101   250.414     0.200
     2.286    39.383     0.200
     2.375    40.483     0.200
     2.399    40.583     0.200
     2.604    43.483     0.200
     2.582    43.083     0.200
     2.738    45.283     0.200
     2.819    47.293     0.200
     2.924    47.983     0.200
     3.032    49.684     0.200
     3.198    51.583     0.200
     3.320    53.184     0.200
     3.576    56.413     0.200
     3.858    61.483     0.200
     3.963    62.483     0.200
     3.963    63.394     0.200
     4.027    63.383     0.200
     4.151    64.383     0.200
     4.464    70.083     0.200
     4.526    71.208     0.200
     4.526    70.474     0.200
     4.490    69.983     0.200
     4.660    72.483     0.200
     4.683    72.184     0.200
     4.790    74.943     0.200
     5.114    77.483     0.200
     5.221    79.383     0.200
     5.702    86.283     0.200
     5.771    87.184     0.200
     6.064    91.483     0.200
     6.173    92.684     0.200
     6.249    93.383     0.200
     6.249    93.783     0.200
     6.293    94.684     0.200
     6.403    93.783     0.200
     6.646    99.783     0.200
     7.107   105.373     0.200
     7.156   105.813     0.200
     7.221   110.224     0.200
     7.709   116.264     0.200
     8.878   129.413     0.200
     9.973   144.133     0.200
    10.618   153.073     0.200
    10.753   153.389     0.200
    12.624   179.228     0.200
    12.624   179.405     0.200
    14.683   207.783     0.200
    14.683   207.886     0.200
    14.683   208.753     0.200
    14.912   210.383     0.200
    16.050   225.733     0.200
    16.050   225.916     0.200
    16.123   226.463     0.200
     2.408    40.070     0.200
     2.424    41.170     0.200
     2.602    44.070     0.200
     2.766    45.170     0.200
     2.842    47.781     0.200
     2.951    48.670     0.200
     3.224    51.871     0.200
     3.299    54.471     0.200
     3.342    53.270     0.200
     3.595    57.900     0.200
     3.885    62.670     0.200
     3.995    62.770     0.200
     4.057    64.770     0.200
     4.183    64.471     0.200
     4.492    70.070     0.200
     4.552    71.996     0.200
     4.552    70.080     0.200
     4.523    69.270     0.200
     4.693    71.371     0.200
     4.714    72.170     0.200
     4.819    76.010     0.200
     5.117    77.391     0.200
     5.247    79.371     0.200
     5.800    87.400     0.200
     5.665    86.211     0.200
     5.721    86.871     0.200
     5.795    87.670     0.200
     6.082    91.670     0.200
     6.201    92.871     0.200
     6.234    94.371     0.200
     6.261    93.971     0.200
     6.316    95.170     0.200
     6.424    93.961     0.200
     6.590    98.840     0.200
     6.672   100.170     0.200
     7.090   103.561     0.200
     7.215   107.670     0.200
     7.215   108.391     0.200
     7.186   105.590     0.200
     7.709   114.641     0.200
     8.201   120.371     0.200
     8.856   127.801     0.200
     9.953   142.730     0.200
    10.597   151.240     0.200
    10.737   152.945     0.200
    10.737   152.711     0.200
    12.063   170.490     0.200
    12.538   176.600     0.200
    12.602   177.590     0.200
    12.602   178.830     0.200
    12.602   177.896     0.200
    14.043   197.770     0.200
    14.287   200.080     0.200
    14.691   204.801     0.200
    14.691   205.346     0.200
    14.691   205.840     0.200
    14.786   211.891     0.200
    15.068   209.490     0.200
    14.943   211.760     0.200
    16.100   225.490     0.200
    16.060   223.346     0.200
    16.060   223.203     0.200
    17.350   241.596     0.200
    20.108   276.170     0.200
     2.416    40.414     0.200
     2.594    42.812     0.200
     2.763    45.617     0.200
     2.856    47.547     0.200
     2.963    48.719     0.200
     3.073    50.219     0.200
     3.220    51.617     0.200
     3.336    53.312     0.200
     3.897    62.219     0.200
     4.005    62.812     0.200
     4.005    63.023     0.200
     4.068    64.312     0.200
     4.176    65.367     0.200
     4.183    64.914     0.200
     4.504    69.719     0.200
     4.565    71.062     0.200
     4.565    72.039     0.200
     4.525    70.117     0.200
     4.694    72.617     0.200
     4.713    72.414     0.200
     4.831    74.875     0.200
     5.104    77.219     0.200
     5.104    77.398     0.200
     5.242    79.516     0.200
     5.675    86.289     0.200
     5.714    85.812     0.200
     5.796    84.859     0.200
     5.796    89.477     0.200
     5.789    87.312     0.200
     6.074    91.516     0.200
     6.242    93.359     0.200
     6.198    93.414     0.200
     6.251    93.516     0.200
     6.251    93.617     0.200
     6.309    95.219     0.200
     6.416    92.969     0.200
     6.589    98.922     0.200
     6.668   100.414     0.200
     7.003   104.617     0.200
     7.099   104.492     0.200
     7.184   107.094     0.200
     7.246   107.719     0.200
     7.201   106.219     0.200
     7.201   106.703     0.200
     7.695   114.766     0.200
     8.204   120.812     0.200
     8.888   130.766     0.200
     9.200   133.023     0.200
     9.483   137.789     0.200
     9.889   144.758     0.200
     9.961   142.875     0.200
    10.605   151.273     0.200
    10.746   153.188     0.200
    11.387   164.719     0.200
    11.750   168.812     0.200
    12.543   176.797     0.200
    12.609   178.461     0.200
    12.609   178.281     0.200
    12.609   179.016     0.200
    13.318   191.312     0.200
    13.422   189.312     0.200
    13.974   200.219     0.200
    14.705   205.266     0.200
    14.954   211.867     0.200
    15.072   211.445     0.200
    15.637   216.664     0.200
    16.074   223.094     0.200
    16.105   225.086     0.200
    16.105   224.695     0.200
    17.361   241.039     0.200
    18.223   254.266     0.200
    18.157   250.805     0.200
    20.118   276.016     0.200
     2.600    43.508     0.200
     2.743    45.808     0.200
     2.972    48.408     0.200
     3.162    51.708     0.200
     3.294    53.508     0.200
     3.411    54.308     0.200
     3.501    55.708     0.200
     3.530    57.408     0.200
     3.703    59.108     0.200
     3.731    59.208     0.200
     4.097    64.908     0.200
     4.287    67.308     0.200
     4.413    68.208     0.200
     4.763    73.108     0.200
     4.762    74.083     0.200
     4.928    75.508     0.200
     4.934    75.308     0.200
     6.471    97.508     0.200
    12.460   175.152     0.200
     2.398    40.312     0.200
     2.590    43.711     0.200
     2.331    39.812     0.200
     2.235    38.812     0.200
     2.727    45.008     0.200
     2.555    42.812     0.200
     3.192    51.508     0.200
     3.219    51.508     0.200
     4.129    63.609     0.200
     3.807    60.609     0.200
     3.916    62.508     0.200
     3.977    63.406     0.200
     4.464    69.312     0.200
     4.666    72.008     0.200
     4.414    69.211     0.200
     4.475    70.484     0.200
     5.710    86.312     0.200
     5.585    85.406     0.200
     7.166   106.312     0.200
    10.739   153.289     0.200
    12.620   177.531     0.200
    12.620   179.984     0.200
    14.641   204.523     0.200
    16.005   222.734     0.200
     2.194    38.266     0.200
     2.303    39.070     0.200
     2.503    41.867     0.200
     2.737    46.195     0.200
     2.627    43.672     0.200
     2.830    46.969     0.200
     2.924    48.172     0.200
     3.095    49.867     0.200
     3.231    51.570     0.200
     3.570    56.266     0.200
     3.763    60.266     0.200
     3.844    60.969     0.200
     3.844    61.086     0.200
     3.919    62.570     0.200
     4.021    63.172     0.200
     4.028    62.672     0.200
     4.364    68.266     0.200
     4.432    69.344     0.200
     4.432    69.602     0.200
     4.364    67.570     0.200
     4.565    70.172     0.200
     4.686    72.398     0.200
     5.121    78.070     0.200
     5.521    84.070     0.200
     5.521    84.281     0.200
     5.624    85.172     0.200
     5.676    85.570     0.200
     5.992    90.367     0.200
     6.077    91.297     0.200
     6.065    91.469     0.200
     6.196    92.570     0.200
     6.321    93.602     0.200
     6.440    96.430     0.200
     6.879   102.570     0.200
     7.179   104.430     0.200
     7.077   105.172     0.200
     7.240   107.125     0.200
     7.705   113.531     0.200
     8.039   118.367     0.200
     9.320   133.969     0.200
    10.054   143.602     0.200
    10.701   152.266     0.200
    10.819   154.102     0.200
    11.886   172.969     0.200
    12.663   178.367     0.200
    12.711   179.039     0.200
    12.711   179.516     0.200
    12.711   180.070     0.200
    14.661   205.727     0.200
    16.019   222.969     0.200
     2.526    42.500     0.200
     2.528    42.602     0.200
     2.690    45.398     0.200
     2.740    45.898     0.200
     3.165    51.797     0.200
     3.331    53.000     0.200
     3.438    54.703     0.200
     3.401    55.703     0.200
     3.681    58.102     0.200
     3.687    58.703     0.200
     4.109    64.398     0.200
     4.159    65.703     0.200
     4.306    66.500     0.200
     4.649    71.602     0.200
     4.640    72.422     0.200
     4.834    73.797     0.200
     5.807    87.797     0.200
     5.895    88.797     0.200
     6.162    92.797     0.200
     6.324    94.898     0.200
    12.512   177.766     0.200
    16.083   223.898     0.200
     2.313    39.820     0.200
     2.431    41.516     0.200
     2.637    44.016     0.200
     2.952    48.719     0.200
     3.065    50.820     0.200
     3.232    51.719     0.200
     3.301    53.516     0.200
     3.887    61.820     0.200
     3.999    63.422     0.200
     4.059    64.219     0.200
     4.494    70.117     0.200
     4.722    72.422     0.200
     5.122    77.422     0.200
     6.268    93.016     0.200
    10.730   152.859     0.200
    12.595   180.570     0.200
     6.680    99.922     0.200
     2.298    38.576     0.200
     2.353    39.977     0.200
     2.531    42.877     0.200
     2.680    44.377     0.200
     3.197    52.076     0.200
     3.603    56.877     0.200
     3.792    60.777     0.200
     3.887    61.076     0.200
     3.887    61.646     0.200
     3.955    62.676     0.200
     4.076    63.766     0.200
     4.083    62.877     0.200
     4.419    68.576     0.200
     4.591    71.076     0.200
     4.720    73.877     0.200
     4.983    76.877     0.200
     4.983    77.016     0.200
     5.121    77.676     0.200
     5.560    84.877     0.200
     5.560    84.527     0.200
     6.124    92.666     0.200
     6.231    92.777     0.200
     6.366    94.596     0.200
     6.934   102.717     0.200
     8.094   119.477     0.200
     2.416    41.121     0.200
     2.748    46.422     0.200
     2.940    48.342     0.200
     3.055    50.121     0.200
     3.174    51.922     0.200
     3.411    55.521     0.200
     3.643    57.820     0.200
     4.112    65.490     0.200
     4.168    65.721     0.200
     4.276    67.221     0.200
     4.282    66.121     0.200
     4.628    71.820     0.200
     4.600    71.922     0.200
     4.657    71.270     0.200
     4.807    73.021     0.200
     4.929    76.371     0.200
     5.102    78.012     0.200
     5.768    87.320     0.200
     5.779    88.002     0.200
     6.123    92.121     0.200
     6.283    94.021     0.200
     6.283    93.752     0.200
     6.351    95.900     0.200
     7.139   105.721     0.200
     6.746   100.621     0.200
     2.377    40.531     0.200
     2.507    41.938     0.200
     2.715    45.938     0.200
     2.858    46.633     0.200
     2.899    47.547     0.200
     3.017    50.031     0.200
     3.140    51.633     0.200
     3.376    54.938     0.200
     3.678    58.234     0.200
     3.952    62.938     0.200
     4.083    65.211     0.200
     4.134    65.336     0.200
     4.274    65.945     0.200
     4.281    66.234     0.200
     4.563    71.133     0.200
     4.618    72.062     0.200
     4.810    73.234     0.200
     4.893    75.508     0.200
     5.142    77.688     0.200
     5.189    79.641     0.200
     5.301    80.836     0.200
     5.792    88.133     0.200
     5.746    87.578     0.200
     5.877    89.031     0.200
     6.315    94.633     0.200
     6.315    94.266     0.200
     6.686   100.633     0.200
     6.759   101.336     0.200
    16.073   224.031     0.200
     2.325    40.188     0.200
     2.493    41.789     0.200
     2.835    46.492     0.200
     2.848    46.773     0.200
     2.965    49.094     0.200
     3.088    50.594     0.200
     3.324    53.789     0.200
     3.662    58.438     0.200
     3.688    58.492     0.200
     4.032    62.992     0.200
     4.082    63.891     0.200
     4.242    66.578     0.200
     4.248    65.992     0.200
     4.566    71.562     0.200
     4.841    74.328     0.200
     5.694    87.180     0.200
     2.202    38.279     0.200
     2.516    42.381     0.200
     2.739    46.400     0.200
     2.840    47.381     0.200
     2.945    48.480     0.200
     3.181    51.881     0.200
     3.774    60.480     0.200
     3.875    61.480     0.200
     3.939    62.980     0.200
     4.078    62.869     0.200
     4.379    68.580     0.200
     4.442    68.068     0.200
     4.456    70.279     0.200
     4.624    71.279     0.200
     4.704    72.980     0.200
     5.142    78.830     0.200
     5.115    78.480     0.200
     5.682    85.881     0.200
     5.736    86.381     0.200
     6.249    93.480     0.200
     6.935   103.080     0.200
     7.743   116.301     0.200
    10.763   153.695     0.200
    12.651   180.680     0.200
    12.651   179.176     0.200
     6.603    99.080     0.200
    15.995   221.756     0.200
     2.187    37.493     0.200
     2.098    37.193     0.200
     2.492    41.693     0.200
     2.654    44.523     0.200
     2.729    45.593     0.200
     3.040    50.493     0.200
     3.511    55.393     0.200
     3.707    58.893     0.200
     3.871    60.443     0.200
     3.879    60.793     0.200
     3.798    61.193     0.200
     4.212    65.893     0.200
     4.253    66.893     0.200
     4.311    67.493     0.200
     4.329    67.352     0.200
     4.570    69.983     0.200
     4.987    77.693     0.200
     5.393    82.233     0.200
     6.127    91.593     0.200
     6.295    94.093     0.200
     6.926   103.493     0.200
     6.415    95.993     0.200
     2.337    39.664     0.200
     2.672    44.062     0.200
     2.798    46.734     0.200
     3.134    50.766     0.200
     3.519    56.062     0.200
     3.519    55.750     0.200
     3.572    56.961     0.200
     3.915    62.359     0.200
     3.915    61.930     0.200
     4.077    64.883     0.200
     4.084    63.164     0.200
     4.424    68.359     0.200
     4.754    73.375     0.200
     6.148    93.523     0.200
     6.201    93.664     0.200
     6.201    93.281     0.200
     6.937   102.836     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     4.508    83.418     0.200
     4.054    75.670     0.200
     4.101    76.062     0.200
     4.129    77.766     0.200
     4.493    82.980     0.200
     4.460    82.637     0.200
     4.531    83.898     0.200
     4.518    84.191     0.200
     4.501    83.734     0.200
     4.466    83.949     0.200
     4.495    83.161     0.200
     4.541    84.475     0.200
     4.528    83.891     0.200
     4.574    84.976     0.200
     4.633    85.511     0.200
     4.472    82.629     0.200
     4.448    82.520     0.200
     4.451    83.434     0.200
     4.496    83.094     0.200
     4.494    83.375     0.200
     4.617    85.234     0.200
     4.636    85.688     0.200
     4.506    83.611     0.200
     4.601    86.164     0.200
     7.892   153.398     0.200
     4.594    84.712     0.200
     6.678   125.307     0.200
     4.520    84.213     0.200
     4.542    84.210     0.200
     4.562    84.055     0.200
     4.486    83.445     0.200
     4.465    82.869     0.200
     4.629    86.828     0.200
     4.479    82.484     0.200
     4.552    84.295     0.200
     4.565    84.391     0.200
     4.475    82.562     0.200
     4.640    86.398     0.200
     2.516    49.301     0.200
     4.329    80.818     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.414    25.668     0.200
     1.414    26.018     0.200
     1.662    28.668     0.200
     1.662    28.828     0.200
     1.769    31.068     0.200
     1.769    31.828     0.200
     1.958    33.857     0.200
     1.430    26.145     0.200
     1.430    27.094     0.200
     1.673    30.145     0.200
     1.673    29.674     0.200
     1.783    31.645     0.200
     1.783    32.994     0.200
     1.966    35.164     0.200
     2.555    43.045     0.200
     1.427    26.428     0.200
     1.616    28.887     0.200
     1.800    32.428     0.200
     1.800    32.947     0.200
     2.009    35.246     0.200
     1.407    26.969     0.200
     1.620    29.168     0.200
     1.777    33.268     0.200
     1.338    25.305     0.200
     1.338    25.154     0.200
     1.553    27.504     0.200
     1.726    31.805     0.200
     1.726    30.914     0.200
     1.968    34.113     0.200
     1.473    26.100     0.200
     1.473    26.629     0.200
     1.817    32.400     0.200
     1.982    34.840     0.200
     1.476    27.469     0.200
     1.476    27.309     0.200
     1.717    30.168     0.200
     1.717    30.549     0.200
     1.818    32.768     0.200
     1.818    33.697     0.200
     1.980    35.438     0.200
     2.407    40.867     0.200
     1.405    25.920     0.200
     1.636    28.920     0.200
     1.769    32.221     0.200
     1.769    32.340     0.200
     1.970    34.641     0.200
     2.326    39.520     0.200
     2.520    42.721     0.200
     1.546    28.314     0.200
     1.546    27.354     0.200
     1.765    31.014     0.200
     1.880    33.814     0.200
     2.019    35.842     0.200
     2.454    41.713     0.200
     2.629    44.412     0.200
     4.567    82.939     0.200
     1.447    26.473     0.200
     1.675    29.676     0.200
     1.801    33.074     0.200
     1.801    33.266     0.200
     2.554    43.074     0.200
     1.468    27.500     0.200
     1.716    30.199     0.200
     1.716    30.438     0.200
     1.810    32.699     0.200
     1.810    33.301     0.200
     1.973    34.918     0.200
     4.500    82.875     0.200
     1.408    26.605     0.200
     1.408    26.875     0.200
     1.669    29.406     0.200
     1.669    29.793     0.200
     1.760    32.504     0.200
     1.760    32.863     0.200
     1.947    34.613     0.200
     1.486    26.746     0.200
     1.486    27.277     0.200
     1.702    29.848     0.200
     1.702    30.289     0.200
     1.834    33.547     0.200
     2.003    34.586     0.200
     1.492    26.930     0.200
     1.492    27.348     0.200
     1.651    28.930     0.200
     1.651    29.406     0.200
     1.861    33.527     0.200
     2.517    42.727     0.200
     1.449    26.176     0.200
     1.811    33.176     0.200
     1.478    27.316     0.200
     1.478    27.477     0.200
     1.695    29.914     0.200
     1.828    33.316     0.200
     1.828    33.164     0.200
     2.000    35.105     0.200
     2.385    40.516     0.200
     4.520    83.090     0.200
     1.434    26.523     0.200
     1.434    26.785     0.200
     1.660    29.223     0.200
     1.660    29.395     0.200
     1.793    32.523     0.200
     1.793    32.773     0.200
     1.982    34.402     0.200
     1.735    30.648     0.200
     1.891    33.445     0.200
     2.423    41.047     0.200
     2.596    43.445     0.200
     1.493    27.434     0.200
     1.694    29.934     0.200
     1.845    33.031     0.200
     2.383    40.434     0.200
     2.564    43.031     0.200
     4.537    82.691     0.200
     1.444    27.207     0.200
     1.444    27.066     0.200
     1.800    32.906     0.200
     1.800    32.324     0.200
     1.394    25.961     0.200
     1.612    28.660     0.200
     1.765    32.262     0.200
     1.433    26.609     0.200
     1.623    28.703     0.200
     1.804    32.906     0.200
     1.804    33.008     0.200
     2.010    35.523     0.200
     1.458    26.625     0.200
     1.613    28.523     0.200
     1.836    33.320     0.200
     2.302    39.219     0.200
     2.484    41.922     0.200
     1.523    27.948     0.200
     1.688    29.748     0.200
     1.688    29.858     0.200
     1.882    33.948     0.200
     2.056    36.208     0.200
     2.376    40.349     0.200
     2.550    42.748     0.200
     1.540    27.911     0.200
     1.686    29.411     0.200
     1.902    34.211     0.200
     2.373    40.411     0.200
     2.543    42.610     0.200
     4.594    84.186     0.200
     1.481    26.652     0.200
     1.481    26.480     0.200
     1.707    30.051     0.200
     1.707    29.449     0.200
     1.828    33.051     0.200
     1.828    33.191     0.200
     1.994    35.371     0.200
     2.396    40.750     0.200
     2.580    43.250     0.200
     1.461    26.883     0.200
     1.696    30.281     0.200
     1.696    29.742     0.200
     1.810    32.883     0.200
     1.810    32.504     0.200
     1.981    34.352     0.200
     2.386    40.383     0.200
     2.573    43.281     0.200
     1.489    27.680     0.200
     1.650    29.180     0.200
     1.858    33.480     0.200
     2.338    39.582     0.200
     2.516    42.480     0.200
     4.552    83.207     0.200
     1.530    27.273     0.200
     1.664    29.473     0.200
     1.898    34.172     0.200
     2.351    39.875     0.200
     2.522    42.672     0.200
     1.387    25.750     0.200
     1.577    28.250     0.200
     1.577    28.438     0.200
     1.770    32.250     0.200
     1.998    34.789     0.200
     2.461    41.449     0.200
     1.455    26.961     0.200
     1.693    29.861     0.200
     1.977    34.871     0.200
     1.513    27.600     0.200
     1.513    27.979     0.200
     1.852    33.600     0.200
     1.737    30.898     0.200
     1.737    30.680     0.200
     2.005    35.350     0.200
     1.487    27.516     0.200
     1.487    27.637     0.200
     1.698    29.816     0.200
     1.837    33.418     0.200
     2.007    35.266     0.200
     1.509    28.352     0.200
     1.750    31.051     0.200
     1.843    34.148     0.200
     1.990    35.691     0.200
     1.527    27.776     0.200
     1.699    29.376     0.200
     1.699    29.816     0.200
     5.892    97.621     0.200
     1.566    28.275     0.200
     1.764    31.405     0.200
     1.507    27.759     0.200
     1.713    30.039     0.200
     1.855    33.359     0.200
     1.855    33.829     0.200
     4.545    83.709     0.200
     1.603    29.750     0.200
     1.767    31.610     0.200
     2.453    41.550     0.200
     2.617    44.150     0.200
     1.475    27.615     0.200
     1.475    28.004     0.200
     1.640    29.214     0.200
     1.640    29.524     0.200
     1.845    34.015     0.200
     1.629    29.850     0.200
     1.539    28.669     0.200
     1.539    27.538     0.200
     1.884    33.868     0.200
     2.420    41.068     0.200
     1.464    27.414     0.200
     1.464    27.613     0.200
     1.710    30.312     0.200
     1.710    30.574     0.200
     1.807    33.514     0.200
     1.497    27.586     0.200
     1.706    30.086     0.200
     1.846    33.188     0.200
     1.846    33.445     0.200
     2.395    40.586     0.200
     4.537    83.535     0.200
     1.426    26.426     0.200
     1.426    26.617     0.200
     1.669    29.324     0.200
     1.779    32.324     0.200
     1.779    32.516     0.200
     2.360    40.027     0.200
     1.372    25.367     0.200
     1.372    25.758     0.200
     1.580    28.270     0.200
     1.580    28.430     0.200
     1.752    32.066     0.200
     1.752    32.316     0.200
     1.980    35.129     0.200
     1.369    25.734     0.200
     1.369    25.453     0.200
     1.564    28.031     0.200
     1.755    31.934     0.200
     1.990    35.012     0.200
     2.451    41.434     0.200
     1.475    27.418     0.200
     1.475    27.316     0.200
     1.808    33.117     0.200
     2.432    41.316     0.200
     2.621    44.117     0.200
     1.589    28.500     0.200
     1.918    34.398     0.200
     2.482    42.199     0.200
     4.604    84.574     0.200
     1.438    26.650     0.200
     1.675    29.250     0.200
     1.675    29.432     0.200
     1.791    32.852     0.200
     1.791    32.730     0.200
     2.365    40.150     0.200
     2.556    43.150     0.200
     4.483    81.102     0.200
     1.571    28.695     0.200
     1.766    30.996     0.200
     1.766    31.184     0.200
     1.908    34.496     0.200
     2.454    41.594     0.200
     2.624    43.996     0.200
     1.462    26.711     0.200
     1.462    26.578     0.200
     1.687    30.008     0.200
     1.687    29.711     0.200
     1.813    32.910     0.200
     2.563    43.008     0.200
     1.380    26.012     0.200
     1.380    26.230     0.200
     1.744    32.012     0.200
     1.744    32.309     0.200
     1.630    28.910     0.200
     1.630    29.039     0.200
     5.945    98.180     0.200
     1.615    28.973     0.200
     1.615    28.703     0.200
     1.799    32.871     0.200
     2.305    39.273     0.200
     2.494    41.973     0.200
     1.406    26.113     0.200
     1.632    28.914     0.200
     1.771    32.312     0.200
     1.771    32.035     0.200
     4.465    82.215     0.200
     5.927    97.895     0.200
     1.441    26.664     0.200
     1.636    28.867     0.200
     1.809    32.664     0.200
     2.325    39.566     0.200
     2.512    42.566     0.200
     1.484    27.133     0.200
     1.484    27.314     0.200
     1.705    29.934     0.200
     1.705    30.094     0.200
     1.831    32.834     0.200
     1.831    33.123     0.200
     4.522    81.934     0.200
     1.529    27.734     0.200
     1.747    30.734     0.200
     1.747    30.555     0.200
     1.867    33.734     0.200
     1.867    33.516     0.200
     2.435    41.234     0.200
     2.613    43.938     0.200
     4.556    83.508     0.200
     1.558    27.950     0.200
     1.765    30.650     0.200
     1.765    31.220     0.200
     1.893    33.350     0.200
     1.893    33.910     0.200
     1.621    29.660     0.200
     1.847    32.290     0.200
     1.936    34.760     0.200
     2.534    42.960     0.200
     2.702    45.560     0.200
     1.627    29.890     0.200
     1.627    28.460     0.200
     1.948    35.190     0.200
     1.948    35.040     0.200
     1.605    29.188     0.200
     1.605    29.028     0.200
     1.830    32.288     0.200
     1.830    32.019     0.200
     1.924    34.589     0.200
     1.625    29.652     0.200
     1.817    31.742     0.200
     1.952    35.053     0.200
     1.952    35.562     0.200
     2.667    44.754     0.200
     2.918    50.992     0.200
     1.596    28.430     0.200
     1.750    30.729     0.200
     1.942    35.029     0.200
     2.436    41.330     0.200
     2.599    43.729     0.200
     4.632    83.879     0.200
     1.574    28.738     0.200
     1.907    34.139     0.200
     2.636    44.338     0.200
     4.594    83.014     0.200
     1.591    28.123     0.200
     1.591    29.113     0.200
     1.809    31.324     0.200
     1.809    31.494     0.200
     1.915    34.223     0.200
     1.915    34.664     0.200
     2.036    35.963     0.200
     4.599    84.373     0.200
     1.614    29.238     0.200
     1.937    34.738     0.200
     1.937    34.889     0.200
     1.823    31.699     0.200
     2.051    35.840     0.200
     1.461    26.686     0.200
     1.682    30.305     0.200
     1.814    32.785     0.200
     1.993    35.025     0.200
     2.372    40.186     0.200
     2.558    43.086     0.200
     1.610    28.633     0.200
     1.610    28.342     0.200
     1.752    30.521     0.200
     4.648    84.906     0.200
     1.521    28.006     0.200
     1.521    27.676     0.200
     1.738    30.605     0.200
     1.862    33.506     0.200
     1.862    33.744     0.200
     2.427    41.105     0.200
     2.606    43.805     0.200
     4.551    83.605     0.200
     1.602    28.844     0.200
     1.814    32.047     0.200
     1.926    34.645     0.200
     2.501    42.344     0.200
     2.670    44.844     0.200
     4.610    83.047     0.200
     1.598    28.996     0.200
     1.838    32.898     0.200
     1.913    34.598     0.200
     1.558    28.367     0.200
     1.722    30.367     0.200
     1.910    34.168     0.200
     1.910    34.328     0.200
     2.069    36.859     0.200
     2.409    40.969     0.200
     2.578    43.270     0.200
     1.594    28.539     0.200
     1.842    31.938     0.200
     1.906    34.344     0.200
     1.466    26.757     0.200
     1.817    32.958     0.200
     2.564    43.357     0.200
     1.501    27.289     0.200
     1.847    33.189     0.200
     2.405    40.789     0.200
     1.554    28.117     0.200
     1.783    31.418     0.200
     1.783    31.008     0.200
     1.883    34.020     0.200
     1.883    34.168     0.200
     2.014    35.258     0.200
     2.472    42.020     0.200
     2.647    44.320     0.200
     1.590    28.877     0.200
     1.590    29.026     0.200
     1.819    31.677     0.200
     1.910    34.276     0.200
     1.910    34.866     0.200
     2.026    35.967     0.200
     1.624    28.914     0.200
     1.624    29.027     0.200
     1.830    31.816     0.200
     1.945    35.016     0.200
     1.945    34.887     0.200
     2.057    35.805     0.200
     4.628    84.164     0.200
     1.590    28.812     0.200
     1.833    32.016     0.200
     1.833    31.695     0.200
     1.905    34.109     0.200
     1.905    34.211     0.200
     2.014    35.523     0.200
     4.587    83.539     0.200
     1.490    28.062     0.200
     1.726    30.562     0.200
     1.726    30.743     0.200
     1.830    33.763     0.200
     1.988    34.963     0.200
     1.558    28.734     0.200
     1.558    28.516     0.200
     1.799    31.539     0.200
     1.799    31.289     0.200
     1.881    33.938     0.200
     1.881    34.070     0.200
     2.006    35.336     0.200
     2.487    41.938     0.200
     4.566    83.836     0.200
     1.436    26.726     0.200
     1.436    26.216     0.200
     1.683    29.726     0.200
     1.683    29.376     0.200
     1.786    32.626     0.200
     1.786    32.466     0.200
     1.965    35.025     0.200
     1.472    26.922     0.200
     1.472    27.311     0.200
     1.709    29.922     0.200
     1.817    32.721     0.200
     1.817    33.121     0.200
     1.982    34.932     0.200
     1.472    26.984     0.200
     1.632    29.086     0.200
     1.845    33.285     0.200
     2.045    36.395     0.200
     4.539    82.762     0.200
     1.582    28.918     0.200
     1.900    34.117     0.200
     4.583    84.344     0.200
     1.498    27.592     0.200
     1.695    29.892     0.200
     1.851    33.892     0.200
     2.022    35.562     0.200
     1.552    28.104     0.200
     1.552    28.254     0.200
     1.800    31.303     0.200
     1.873    33.604     0.200
     1.873    33.473     0.200
     1.997    34.783     0.200
     1.558    28.836     0.200
     1.558    29.039     0.200
     1.808    31.836     0.200
     1.878    33.734     0.200
     1.878    34.500     0.200
     1.998    35.328     0.200
     1.416    26.070     0.200
     1.416    26.701     0.200
     1.608    28.570     0.200
     1.608    28.791     0.200
     1.791    32.371     0.200
     2.004    35.291     0.200
     2.298    39.172     0.200
     2.488    41.871     0.200
     1.611    28.746     0.200
     1.930    34.246     0.200
     1.426    26.727     0.200
     1.617    28.727     0.200
     1.617    28.914     0.200
     1.799    32.727     0.200
     1.799    32.969     0.200
     2.007    35.375     0.200
     4.494    82.547     0.200
     1.519    27.516     0.200
     1.718    30.516     0.200
     1.866    33.609     0.200
     2.406    40.812     0.200
     2.584    43.516     0.200
     4.556    83.734     0.200
     1.424    26.020     0.200
     1.424    26.408     0.200
     1.773    32.318     0.200
     1.953    34.158     0.200
     2.372    40.119     0.200
     2.565    42.920     0.200
     1.442    26.780     0.200
     1.442    26.650     0.200
     1.662    29.480     0.200
     1.662    29.360     0.200
     1.988    35.121     0.200
     2.352    39.880     0.200
     2.541    42.880     0.200
     1.633    29.852     0.200
     1.853    32.547     0.200
     1.948    35.250     0.200
     1.948    35.438     0.200
     2.049    35.773     0.200
     2.540    42.852     0.200
     2.706    45.852     0.200
     1.435    25.936     0.200
     1.435    26.186     0.200
     1.677    29.234     0.200
     1.787    32.035     0.200
     1.787    31.924     0.200
     2.367    39.834     0.200
     2.558    42.334     0.200
     1.489    27.684     0.200
     1.489    27.553     0.200
     1.710    29.983     0.200
     1.835    33.083     0.200
     1.835    33.443     0.200
     1.521    27.770     0.200
     1.521    27.961     0.200
     1.735    30.371     0.200
     1.863    33.670     0.200
     1.530    28.117     0.200
     1.730    30.617     0.200
     1.730    30.508     0.200
     1.875    33.812     0.200
     2.418    40.914     0.200
     1.769    31.108     0.200
     1.918    33.308     0.200
     4.762    85.583     0.200
     1.443    26.609     0.200
     1.784    32.508     0.200
     1.368    25.672     0.200
     1.737    31.570     0.200
     1.737    31.930     0.200
     1.613    28.766     0.200
     1.638    29.203     0.200
     1.840    31.898     0.200
     1.526    27.719     0.200
     1.743    30.820     0.200
     1.865    33.516     0.200
     1.412    26.176     0.200
     1.662    29.266     0.200
     1.767    32.076     0.200
     1.767    32.197     0.200
     1.638    29.621     0.200
     1.807    31.721     0.200
     1.807    32.191     0.200
     1.971    34.922     0.200
     4.657    84.297     0.200
     1.611    28.633     0.200
     1.934    34.938     0.200
     1.934    34.102     0.200
     1.561    28.492     0.200
     1.804    31.570     0.200
     1.882    34.094     0.200
     1.400    25.680     0.200
     1.673    29.250     0.200
     1.750    31.980     0.200
     1.232    23.393     0.200
     1.496    26.853     0.200
     1.632    30.193     0.200
     2.105    36.293     0.200
     1.439    26.664     0.200
     1.439    26.281     0.200
     1.647    29.000     0.200
     1.803    33.266     0.200
     1.803    32.633     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.462   121.592     0.200
     7.137   183.873     0.200
     9.908   256.256     0.200
     9.951   255.328     0.200
    10.295   260.057     0.200
    10.779   272.330     0.200
    10.779   271.068     0.200
    11.270   288.467     0.200
    11.832   302.568     0.200
    12.664   319.287     0.200
    12.664   317.279     0.200
    13.058   335.168     0.200
    13.204   335.768     0.200
    13.301   335.867     0.200
    13.695   347.768     0.200
    13.862   351.467     0.200
    14.527   366.467     0.200
    15.344   386.748     0.200
    15.715   394.867     0.200
    15.715   395.668     0.200
    15.786   398.229     0.200
    16.018   393.568     0.200
    16.360   409.898     0.200
    17.485   437.768     0.200
    19.052   477.867     0.200
    19.332   476.293     0.200
    20.481   512.707     0.200
    21.568   530.418     0.200
    21.702   533.068     0.200
    21.819   538.787     0.200
     4.475   120.145     0.200
     7.130   183.098     0.200
    10.773   270.482     0.200
    11.286   291.645     0.200
    11.819   302.244     0.200
    12.655   318.588     0.200
    12.655   319.500     0.200
    13.316   340.045     0.200
    13.710   350.844     0.200
    13.878   354.844     0.200
    13.943   353.744     0.200
    14.662   362.994     0.200
    15.648   388.500     0.200
    16.024   396.045     0.200
    16.024   396.848     0.200
    21.300   529.545     0.200
     4.495   123.703     0.200
     7.181   186.771     0.200
     9.792   253.277     0.200
     9.864   255.330     0.200
     9.907   255.852     0.200
    10.823   271.648     0.200
    10.823   273.268     0.200
    10.817   279.887     0.200
    11.262   289.469     0.200
    11.871   301.668     0.200
    12.707   322.266     0.200
    12.707   321.086     0.200
    13.058   332.469     0.200
    13.201   336.969     0.200
    13.220   340.818     0.200
    13.300   337.969     0.200
    13.691   348.268     0.200
    13.853   353.168     0.200
    13.933   352.168     0.200
    14.504   369.549     0.200
    14.569   367.559     0.200
    14.690   366.867     0.200
    15.387   387.287     0.200
    15.696   389.598     0.200
    15.696   387.969     0.200
    15.757   397.838     0.200
    15.828   398.918     0.200
    16.050   393.617     0.200
    16.050   394.152     0.200
    16.402   413.238     0.200
    17.282   434.059     0.200
    17.487   436.867     0.200
    17.771   448.068     0.200
    19.325   481.969     0.200
    22.720   559.098     0.200
    16.042   396.303     0.200
     7.100   183.568     0.200
    10.745   268.967     0.200
    10.745   271.100     0.200
    11.330   292.299     0.200
    11.776   301.600     0.200
    12.620   320.422     0.200
    12.620   319.547     0.200
    13.260   339.100     0.200
    13.356   339.400     0.200
    13.752   351.000     0.200
    13.923   355.600     0.200
    13.980   351.500     0.200
    14.481   365.639     0.200
    14.667   361.533     0.200
    14.667   362.199     0.200
    15.297   385.340     0.200
    15.627   387.111     0.200
    15.668   394.129     0.200
    16.311   410.189     0.200
    16.033   397.152     0.200
    16.033   396.439     0.200
    19.381   485.000     0.200
     4.508   120.617     0.200
    10.740   269.348     0.200
    12.614   319.037     0.200
    12.614   319.789     0.200
    14.663   361.572     0.200
    16.029   394.117     0.200
    12.574   317.631     0.200
     4.500   121.383     0.200
    11.325   291.699     0.200
    11.773   298.398     0.200
    12.615   319.668     0.200
    13.254   338.801     0.200
    13.350   339.699     0.200
    13.746   350.699     0.200
    13.917   354.898     0.200
    16.023   392.348     0.200
     7.129   184.289     0.200
    10.770   270.215     0.200
    11.265   291.504     0.200
    11.827   299.605     0.200
    12.657   317.023     0.200
    13.197   337.906     0.200
    13.294   339.105     0.200
    13.688   350.305     0.200
    13.857   354.605     0.200
    14.645   363.074     0.200
    15.642   385.957     0.200
    16.007   395.906     0.200
    16.007   396.520     0.200
    10.799   269.117     0.200
    14.698   366.457     0.200
    12.638   316.484     0.200
    16.052   392.992     0.200
    10.789   271.246     0.200
    12.669   318.844     0.200
    16.041   395.348     0.200
    12.607   313.242     0.200
    12.714   317.305     0.200
    16.044   393.586     0.200
     4.499   119.859     0.200
     7.186   183.430     0.200
     7.980   203.414     0.200
     8.964   228.594     0.200
     9.307   236.250     0.200
    11.288   291.305     0.200
    12.708   319.852     0.200
    12.708   321.664     0.200
    13.227   338.805     0.200
    16.073   395.930     0.200
    16.073   394.344     0.200
    10.849   272.398     0.200
    12.722   320.188     0.200
    12.722   318.500     0.200
    14.746   365.125     0.200
    10.791   269.217     0.200
    11.790   301.148     0.200
    12.653   321.167     0.200
    12.653   317.361     0.200
    16.106   395.799     0.200
    16.106   393.462     0.200
    12.660   319.154     0.200
    10.753   269.805     0.200
    16.044   391.402     0.200
    16.044   392.977     0.200
     4.501   120.969     0.200
    10.758   273.234     0.200
    12.634   319.176     0.200
    14.670   365.871     0.200
    16.034   393.734     0.200
    16.034   397.023     0.200
    10.821   273.031     0.200
    12.689   319.301     0.200
    12.689   319.660     0.200
    14.743   363.441     0.200
    16.106   396.730     0.200
    16.106   393.637     0.200
    10.821   272.066     0.200
    12.681   320.617     0.200
    12.681   319.543     0.200
    14.770   366.238     0.200
    16.135   398.699     0.200
    10.864   272.973     0.200
    11.913   301.051     0.200
    12.750   320.742     0.200
    12.750   318.797     0.200
    14.711   364.355     0.200
    16.068   393.949     0.200
    16.068   394.484     0.200
     4.495   121.927     0.200
    10.759   269.295     0.200
    12.637   319.555     0.200
    12.637   319.994     0.200
    14.667   364.515     0.200
    16.031   393.836     0.200
    16.031   397.130     0.200
    10.731   267.699     0.200
    10.731   266.799     0.200
    11.746   298.799     0.200
    12.598   317.367     0.200
    12.598   317.754     0.200
    13.394   341.799     0.200
    13.791   353.699     0.200
    14.680   363.697     0.200
    16.049   393.475     0.200
    16.049   393.994     0.200
    17.575   439.199     0.200
    19.419   481.299     0.200
    10.765   269.496     0.200
    10.765   269.918     0.200
    11.786   300.617     0.200
    12.636   317.734     0.200
    12.636   318.516     0.200
    14.693   365.887     0.200
    16.058   394.168     0.200
    16.058   396.328     0.200
    17.556   439.617     0.200
    19.344   472.965     0.200
    19.398   484.215     0.200
     9.966   257.855     0.200
    10.008   260.703     0.200
    10.553   274.426     0.200
    10.633   276.980     0.200
    10.715   269.418     0.200
    10.968   279.602     0.200
    11.736   298.949     0.200
    12.585   317.969     0.200
    13.388   341.148     0.200
    13.785   352.449     0.200
    13.958   357.051     0.200
    14.008   352.551     0.200
    14.444   366.012     0.200
    14.664   360.457     0.200
    15.700   394.602     0.200
    16.032   395.180     0.200
    16.032   391.863     0.200
    17.567   439.449     0.200
     4.574   122.076     0.200
     5.815   152.257     0.200
     7.132   186.032     0.200
     9.380   246.311     0.200
     9.749   247.527     0.200
     9.900   255.931     0.200
    10.493   271.046     0.200
    10.780   272.976     0.200
    11.031   281.366     0.200
    11.034   285.885     0.200
    11.138   287.263     0.200
    11.383   294.076     0.200
    11.779   299.276     0.200
    11.963   298.340     0.200
    12.642   318.320     0.200
    12.642   320.258     0.200
    13.035   334.456     0.200
    13.173   338.176     0.200
    13.318   341.576     0.200
    13.809   353.176     0.200
    13.936   351.176     0.200
    13.974   357.476     0.200
    14.210   363.486     0.200
    14.732   365.771     0.200
    14.732   364.776     0.200
    14.793   374.470     0.200
    15.671   386.824     0.200
    16.099   393.176     0.200
    16.099   396.872     0.200
    16.238   410.886     0.200
    17.365   438.701     0.200
    17.594   442.401     0.200
    17.600   440.876     0.200
    19.440   485.776     0.200
    19.782   496.776     0.200
    20.087   499.966     0.200
    20.124   505.006     0.200
    20.943   521.306     0.200
    21.400   532.276     0.200
    21.848   537.846     0.200
    10.722   269.444     0.200
    12.580   314.629     0.200
    12.580   318.855     0.200
    14.709   367.835     0.200
     1.713    54.309     0.200
    12.624   319.978     0.200
    16.066   395.784     0.200
     1.767    55.690     0.200
    12.585   318.182     0.200
    14.744   364.032     0.200
    16.117   393.826     0.200
    16.117   397.004     0.200
    14.737   366.114     0.200
    16.099   395.393     0.200
    12.609   318.912     0.200
    12.609   321.035     0.200
    16.081   394.544     0.200
     4.498   123.613     0.200
    10.743   268.506     0.200
    11.779   300.414     0.200
    12.620   319.057     0.200
    12.620   317.271     0.200
    14.659   361.814     0.200
    15.624   386.604     0.200
    16.024   392.764     0.200
    16.024   394.844     0.200
    19.314   473.039     0.200
    10.775   269.770     0.200
    12.658   318.520     0.200
    12.658   319.641     0.200
    14.661   361.422     0.200
    16.023   392.340     0.200
    16.023   395.121     0.200
    12.745   324.410     0.200
    16.050   395.117     0.200
    10.872   272.258     0.200
    12.762   322.828     0.200
    14.706   364.488     0.200
    16.062   395.309     0.200
    16.062   397.770     0.200
    10.711   268.086     0.200
    10.711   271.719     0.200
    12.587   316.801     0.200
    14.637   359.953     0.200
    14.637   360.219     0.200
    16.004   392.441     0.200
    10.697   269.652     0.200
    12.551   315.539     0.200
    14.701   361.805     0.200
    16.074   396.668     0.200
    10.804   271.645     0.200
    11.867   301.711     0.200
    12.694   317.879     0.200
    12.694   321.574     0.200
    16.015   390.684     0.200
    16.015   392.430     0.200
     1.615    51.570     0.200
     1.615    51.910     0.200
     4.494   122.070     0.200
    12.715   319.117     0.200
    16.072   397.422     0.200
     7.168   182.992     0.200
     7.962   204.426     0.200
     9.299   236.895     0.200
    10.810   269.820     0.200
    12.695   318.934     0.200
    12.695   319.691     0.200
    14.678   363.066     0.200
    16.037   391.914     0.200
    16.037   393.617     0.200
    17.483   440.715     0.200
    19.360   473.641     0.200
    12.696   320.281     0.200
    12.591   317.430     0.200
    16.057   394.086     0.200
     4.581   124.650     0.200
     7.069   185.647     0.200
    10.002   255.637     0.200
    10.553   269.598     0.200
    10.717   270.550     0.200
    10.717   270.250     0.200
    10.906   279.572     0.200
    11.415   292.850     0.200
    11.714   296.650     0.200
    12.467   321.320     0.200
    12.498   319.630     0.200
    12.577   318.969     0.200
    12.577   318.109     0.200
    13.342   340.650     0.200
    13.438   343.450     0.200
    13.835   354.550     0.200
    14.007   355.850     0.200
    14.058   352.350     0.200
    14.411   363.308     0.200
    14.434   363.210     0.200
    14.698   365.422     0.200
    14.698   362.150     0.200
    15.247   382.420     0.200
    15.620   392.320     0.200
    15.688   393.550     0.200
    16.069   396.800     0.200
    17.618   439.650     0.200
    19.500   486.780     0.200
    20.373   509.770     0.200
    21.420   534.400     0.200
    21.561   539.820     0.200
    21.701   537.800     0.200
    21.824   541.670     0.200
    12.519   312.159     0.200
     5.698   148.301     0.200
     7.012   183.076     0.200
    10.662   271.402     0.200
    11.647   293.688     0.200
    12.515   315.582     0.200
    12.515   315.234     0.200
    13.383   344.589     0.200
    13.477   345.488     0.200
    13.877   356.488     0.200
    14.055   360.889     0.200
    16.056   395.514     0.200
    19.281   473.639     0.200
    20.038   504.769     0.200
    12.534   317.797     0.200
    16.092   393.504     0.200
    12.602   317.873     0.200
    16.126   395.979     0.200
    10.710   269.986     0.200
    12.566   317.033     0.200
    16.075   396.947     0.200
    10.681   270.465     0.200
    12.536   314.818     0.200
    12.536   318.109     0.200
    13.465   341.924     0.200
    13.864   353.023     0.200
    14.040   357.824     0.200
    14.688   363.213     0.200
    16.062   392.299     0.200
    16.062   396.514     0.200
    19.296   476.049     0.200
    10.674   268.066     0.200
    11.653   297.340     0.200
    12.525   315.088     0.200
    12.525   317.518     0.200
    14.698   360.111     0.200
    16.074   392.740     0.200
    16.074   393.617     0.200
     1.682    53.586     0.200
    10.774   270.248     0.200
    12.649   316.355     0.200
    12.649   317.688     0.200
    14.684   366.256     0.200
    16.047   394.211     0.200
    10.757   272.336     0.200
    11.721   298.332     0.200
    12.603   317.076     0.200
    12.603   319.973     0.200
    19.522   490.232     0.200
    10.733   268.854     0.200
    12.599   315.850     0.200
    12.599   316.459     0.200
    14.688   363.807     0.200
    16.069   392.695     0.200
     4.601   126.629     0.200
    10.767   270.895     0.200
    12.624   318.746     0.200
    16.112   398.867     0.200
    10.643   269.359     0.200
    12.500   315.406     0.200
    12.500   315.922     0.200
    16.032   395.039     0.200
    10.768   271.520     0.200
    14.681   364.198     0.200
    16.046   395.644     0.200
    10.750   270.917     0.200
    14.690   365.651     0.200
    16.057   394.581     0.200
     4.568   126.867     0.200
    10.694   269.586     0.200
    14.676   362.938     0.200
    16.048   398.195     0.200
    16.048   393.254     0.200
     7.019   180.557     0.200
    12.524   313.971     0.200
    16.051   392.698     0.200
    10.671   268.191     0.200
    14.701   363.707     0.200
    16.077   394.543     0.200
     4.587   123.586     0.200
    12.509   312.633     0.200
    12.509   316.547     0.200
    14.662   363.039     0.200
    16.037   393.516     0.200
    19.266   474.336     0.200
    10.734   270.151     0.200
    12.607   317.457     0.200
    12.607   316.777     0.200
    14.668   363.056     0.200
    16.035   392.713     0.200
    16.035   392.284     0.200
    10.679   269.078     0.200
    12.540   314.250     0.200
    16.037   394.727     0.200
    10.764   269.880     0.200
    12.645   316.369     0.200
    12.645   319.396     0.200
    12.645   320.292     0.200
    14.658   365.053     0.200
    16.021   393.776     0.200
    10.747   271.686     0.200
    12.622   318.541     0.200
    14.668   362.189     0.200
    16.033   393.297     0.200
    16.033   394.381     0.200
    10.834   271.070     0.200
    12.704   320.504     0.200
    12.704   321.512     0.200
    14.742   367.516     0.200
    16.105   395.207     0.200
     4.542   121.085     0.200
    10.772   271.165     0.200
    12.641   320.036     0.200
    12.641   318.771     0.200
    16.073   395.317     0.200
    16.073   394.419     0.200
    10.674   267.430     0.200
    12.537   316.445     0.200
    14.656   359.477     0.200
    16.028   392.248     0.200
     7.020   182.156     0.200
    10.668   267.789     0.200
    11.675   296.938     0.200
    12.530   316.680     0.200
    12.530   314.898     0.200
    12.530   317.938     0.200
    13.184   335.938     0.200
    14.044   351.234     0.200
    14.655   363.047     0.200
    15.562   382.883     0.200
    16.028   394.195     0.200
    16.028   392.555     0.200
    17.607   440.539     0.200
    19.173   481.039     0.200
    19.271   470.859     0.200
    19.454   484.641     0.200
     1.608    51.592     0.200
    10.839   274.361     0.200
    12.721   323.041     0.200
    14.710   366.467     0.200
    16.069   394.980     0.200
    16.072   395.477     0.200
    19.391   476.461     0.200
    12.620   315.133     0.200
    12.667   317.250     0.200
    12.667   317.015     0.200
    14.684   361.691     0.200
    16.046   394.280     0.200
    16.046   392.318     0.200
    12.496   313.617     0.200
    12.496   313.352     0.200
    12.496   317.656     0.200
    14.687   363.375     0.200
    16.064   396.398     0.200
    16.064   398.633     0.200
    10.770   270.318     0.200
    12.651   318.229     0.200
    12.651   319.250     0.200
    14.662   361.385     0.200
    16.025   393.764     0.200
    16.025   395.984     0.200
    10.753   270.174     0.200
    14.683   365.434     0.200
    16.050   398.155     0.200
    10.737   271.504     0.200
    12.602   317.203     0.200
    14.691   361.584     0.200
    10.746   268.844     0.200
    12.609   317.188     0.200
    14.705   360.945     0.200
    15.637   384.750     0.200
    16.074   393.719     0.200
    16.074   393.070     0.200
     4.475   124.234     0.200
    10.739   271.617     0.200
    12.620   320.703     0.200
    12.620   319.797     0.200
    14.641   364.031     0.200
    16.005   396.703     0.200
    12.711   317.109     0.200
    16.019   392.141     0.200
    12.512   315.570     0.200
    10.730   270.828     0.200
    12.595   320.867     0.200
     4.618   127.812     0.200
    16.073   398.281     0.200
    15.995   392.305     0.200
     2.105    74.693     0.200
     4.329   116.093     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.405    45.420     0.200
     1.546    48.412     0.200
     1.447    45.875     0.200
     1.468    47.199     0.200
     1.702    51.148     0.200
     1.492    47.727     0.200
     1.449    45.574     0.200
     1.478    46.914     0.200
     1.434    45.723     0.200
     1.546    48.848     0.200
     1.493    48.531     0.200
     1.444    46.004     0.200
     1.394    45.461     0.200
     1.433    46.508     0.200
     1.458    47.625     0.200
     1.523    49.748     0.200
     1.540    49.110     0.200
     1.481    48.152     0.200
     1.461    47.082     0.200
     1.489    47.480     0.200
     1.530    48.875     0.200
     1.387    44.250     0.200
     1.455    47.161     0.200
     1.693    53.461     0.200
     1.513    49.398     0.200
     1.509    49.148     0.200
     1.527    49.976     0.200
     1.527    48.986     0.200
     1.507    48.859     0.200
     1.603    51.180     0.200
     1.629    51.149     0.200
     1.539    48.169     0.200
     1.464    47.014     0.200
     1.497    47.785     0.200
     1.426    45.426     0.200
     1.438    46.250     0.200
     1.571    50.496     0.200
     1.462    47.910     0.200
     1.380    44.512     0.200
     1.632    51.145     0.200
     1.441    47.367     0.200
     1.484    47.734     0.200
     1.529    49.336     0.200
     1.621    51.960     0.200
     1.627    51.390     0.200
     1.625    51.773     0.200
     1.817    54.652     0.200
     1.574    50.539     0.200
     1.461    46.785     0.200
     1.610    50.611     0.200
     1.521    49.006     0.200
     1.602    51.445     0.200
     1.598    49.695     0.200
     1.558    50.270     0.200
     1.466    47.257     0.200
     1.501    48.390     0.200
     1.554    50.320     0.200
     1.590    51.477     0.200
     1.436    46.726     0.200
     1.472    46.922     0.200
     1.472    47.285     0.200
     1.695    53.092     0.200
     1.552    50.303     0.200
     1.416    45.971     0.200
     1.416    46.332     0.200
     1.519    48.016     0.200
     1.424    45.520     0.200
     1.435    46.436     0.200
     1.489    48.983     0.200
     1.443    46.609     0.200
     1.368    44.570     0.200
     1.638    51.297     0.200
     1.526    49.922     0.200
     1.412    45.076     0.200
     1.638    52.221     0.200
     1.611    51.234     0.200
     1.439    46.359     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     4.495   146.000     0.200
     4.471   146.867     0.200
     4.422   142.754     0.200
     4.508   146.836     0.200
     4.508   144.969     0.200
     4.567   146.639     0.200
     4.494   143.000     0.200
     4.500   145.500     0.200
     4.453   143.754     0.200
     4.526   146.621     0.200
     4.555   146.352     0.200
     4.504   145.199     0.200
     4.520   145.691     0.200
     4.486   145.223     0.200
     4.580   148.672     0.200
     4.537   147.383     0.200
     4.493   144.863     0.200
     4.460   144.227     0.200
     4.499   147.555     0.200
     4.531   146.523     0.200
     4.574   148.198     0.200
     4.594   149.686     0.200
     4.518   144.949     0.200
     4.501   147.246     0.200
     4.552   148.582     0.200
     4.592   149.648     0.200
     4.466   144.699     0.200
     4.495   144.261     0.200
     4.541   146.748     0.200
     4.528   147.113     0.200
     4.531   147.863     0.200
     4.574   147.226     0.200
     4.592   149.460     0.200
     4.545   147.459     0.200
     4.633   149.460     0.200
     4.539   145.783     0.200
     4.638   149.191     0.200
     4.574   147.174     0.200
     4.498   144.188     0.200
     4.537   146.785     0.200
     4.472   145.102     0.200
     4.448   145.168     0.200
     4.451   147.082     0.200
     4.496   146.492     0.200
     4.604   150.074     0.200
     4.596   147.445     0.200
     4.505   147.086     0.200
     4.438   142.984     0.200
     4.494   145.422     0.200
     4.465   144.340     0.200
     4.504   142.117     0.200
     4.522   148.383     0.200
     4.556   147.305     0.200
     4.581   149.000     0.200
     4.617   148.910     0.200
     4.631   150.665     0.200
    19.931   631.113     0.200
     4.636   148.518     0.200
     4.632   149.053     0.200
     4.594   148.562     0.200
     4.599   146.824     0.200
     4.620   149.363     0.200
     4.506   147.061     0.200
     4.648   151.131     0.200
     4.551   146.006     0.200
     4.610   149.246     0.200
     4.595   145.922     0.200
     4.601   150.801     0.200
     4.587   150.664     0.200
     4.594   147.752     0.200
     4.628   151.316     0.200
     4.587   146.672     0.200
     4.520   147.088     0.200
     4.566   147.711     0.200
     4.477   142.575     0.200
     4.507   144.621     0.200
     4.539   145.785     0.200
     4.583   148.594     0.200
     4.542   147.532     0.200
     4.558   146.229     0.200
     4.562   146.289     0.200
     4.486   146.422     0.200
     4.494   145.023     0.200
     4.556   148.062     0.200
     4.465   144.244     0.200
     4.493   147.005     0.200
     4.629   148.852     0.200
     4.479   146.561     0.200
     4.552   147.871     0.200
     4.565   147.516     0.200
     4.475   148.359     0.200
     4.432   140.867     0.200
     4.640   150.750     0.200
     2.637    90.898     0.200
     3.301   110.898     0.200
     4.460   143.176     0.200
     2.748    93.201     0.200
     4.657   148.686     0.200
     4.618   147.281     0.200
     4.566   149.039     0.200
     4.442   144.705     0.200
     4.329   138.418     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.405    45.420     0.200
     1.546    48.412     0.200
     1.447    45.875     0.200
     1.468    47.199     0.200
     1.702    51.148     0.200
     1.492    47.727     0.200
     1.449    45.574     0.200
     1.478    46.914     0.200
     1.434    45.723     0.200
     1.546    48.848     0.200
     1.493    48.531     0.200
     1.444    46.004     0.200
     1.394    45.461     0.200
     1.433    46.508     0.200
     1.458    47.625     0.200
     1.523    49.748     0.200
     1.540    49.110     0.200
     1.481    48.152     0.200
     1.461    47.082     0.200
     1.489    47.480     0.200
     1.530    48.875     0.200
     1.387    44.250     0.200
     1.455    47.161     0.200
     1.693    53.461     0.200
     1.513    49.398     0.200
     1.509    49.148     0.200
     1.527    49.976     0.200
     1.527    48.986     0.200
     1.507    48.859     0.200
     1.603    51.180     0.200
     1.629    51.149     0.200
     1.539    48.169     0.200
     1.464    47.014     0.200
     1.497    47.785     0.200
     1.426    45.426     0.200
     1.438    46.250     0.200
     1.571    50.496     0.200
     1.462    47.910     0.200
     1.380    44.512     0.200
     1.632    51.145     0.200
     1.441    47.367     0.200
     1.484    47.734     0.200
     1.529    49.336     0.200
     1.621    51.960     0.200
     1.627    51.390     0.200
     1.625    51.773     0.200
     1.817    54.652     0.200
     1.574    50.539     0.200
     1.461    46.785     0.200
     1.610    50.611     0.200
     1.521    49.006     0.200
     1.602    51.445     0.200
     1.598    49.695     0.200
     1.558    50.270     0.200
     1.466    47.257     0.200
     1.501    48.390     0.200
     1.554    50.320     0.200
     1.590    51.477     0.200
     1.436    46.726     0.200
     1.472    46.922     0.200
     1.472    47.285     0.200
     1.695    53.092     0.200
     1.552    50.303     0.200
     1.416    45.971     0.200
     1.416    46.332     0.200
     1.519    48.016     0.200
     1.424    45.520     0.200
     1.435    46.436     0.200
     1.489    48.983     0.200
     1.443    46.609     0.200
     1.368    44.570     0.200
     1.638    51.297     0.200
     1.526    49.922     0.200
     1.412    45.076     0.200
     1.638    52.221     0.200
     1.611    51.234     0.200
     1.439    46.359     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
