#!/bin/bash
gmt begin herat11.41_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic herat11.41'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.725
   137.000     1.817
   137.500     1.911
   138.000     2.010
   138.500     2.111
   139.000     2.216
   139.500     2.325
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.801
   142.000     2.932
   142.500     3.066
   143.000     3.206
   143.500     3.352
   144.000     3.502
   144.500     3.659
   145.000     3.821
   145.500     3.989
   146.000     4.164
   146.500     4.345
   147.000     4.534
   147.500     4.729
   148.000     4.933
   148.500     5.143
   149.000     5.363
   149.500     5.591
   150.000     5.829
   150.500     6.077
   151.000     6.335
   151.500     6.604
   152.000     6.883
   152.500     7.171
   153.000     7.470
   153.500     7.780
   154.000     8.100
   154.500     8.431
   155.000     8.773
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.692
   145.500     0.270
   146.000     1.296
   146.500     2.365
   147.000     3.469
   147.500     4.603
   148.000     5.764
   148.500     6.950
   149.000     8.160
   149.500     9.392
   150.000    10.647
   150.500    11.922
   151.000    13.219
   151.500    14.535
   152.000    15.870
   152.500    17.223
   153.000    18.595
   153.500    19.984
   154.000    21.391
   154.500    22.815
   155.000    24.256
   155.500    25.714
   156.000    27.190
   156.500    28.682
   157.000    30.190
   157.500    31.716
   158.000    33.258
   158.500    34.816
   159.000    36.391
   159.500    37.983
   160.000    39.591
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.695
   145.500     0.072
   146.000     0.766
   146.500     1.408
   147.000     2.007
   147.500     2.567
   148.000     3.092
   148.500     3.585
   149.000     4.051
   149.500     4.497
   150.000     4.927
   150.500     5.344
   151.000     5.751
   151.500     6.148
   152.000     6.537
   152.500     6.918
   153.000     7.294
   153.500     7.665
   154.000     8.034
   154.500     8.401
   155.000     8.765
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   138.462    -0.814     0.200
   139.616    -1.552     0.200
   142.246    -2.187     0.200
   142.246    -1.437     0.200
   143.600    -2.957     0.200
   144.344     1.694     0.200
   147.609    -0.861     0.200
   142.259    -0.137     0.200
   142.259    -0.688     0.200
   142.209    -0.281     0.200
   135.981    -1.282     0.200
   136.294    -1.632     0.200
   136.427    -0.229     0.200
   138.436     1.012     0.200
   139.587     0.727     0.200
   139.587    -2.593     0.200
   142.208     0.932     0.200
   142.208    -0.587     0.200
   143.560    -3.158     0.200
   144.303    -1.307     0.200
   136.366     0.790     0.200
   138.520    -0.082     0.200
   142.303    -3.260     0.200
   143.652    -2.996     0.200
   142.250    -1.234     0.200
   142.250    -1.054     0.200
   142.335     0.406     0.200
   142.295     0.046     0.200
   142.344    -1.124     0.200
   138.553    -0.630     0.200
   140.964    -4.813     0.200
   142.304     0.886     0.200
   143.644    -0.682     0.200
   143.644    -1.482     0.200
   143.644    -1.232     0.200
   143.924    -0.334     0.200
   143.924    -2.849     0.200
   144.385    -0.152     0.200
   144.662    -0.968     0.200
   144.662    -1.733     0.200
   147.690    -0.419     0.200
   142.369     0.342     0.200
   135.807    -3.002     0.200
   139.758    -2.909     0.200
   143.518    -0.734     0.200
   143.709    -2.346     0.200
   143.709    -0.646     0.200
   143.990    -1.287     0.200
   143.990    -1.962     0.200
   144.450    -1.364     0.200
   144.464    -1.163     0.200
   144.464    -2.013     0.200
   144.727    -2.240     0.200
   144.727    -2.095     0.200
   147.770    -1.927     0.200
   147.786    -1.178     0.200
   147.869     0.924     0.200
   136.253    -0.075     0.200
   142.435    -1.698     0.200
   143.775    -2.593     0.200
   147.053    -0.045     0.200
   136.218     0.060     0.200
   142.406    -1.312     0.200
   142.406    -0.687     0.200
   142.406     0.891     0.200
   144.769    -1.648     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   147.205     2.832     0.200
   147.192     1.860     0.200
   147.242     2.528     0.200
   147.578     3.067     0.200
   147.672     3.412     0.200
   147.853     2.116     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   147.146     3.541     0.200
   147.082     3.629     0.200
   147.243     3.460     0.200
   147.015     3.528     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   135.317     2.078     0.200
   135.659     3.072     0.200
   136.154     1.320     0.200
   136.296     3.407     0.200
   136.305     0.919     0.200
   139.616     1.628     0.200
   147.226     4.826     0.200
   138.478     1.830     0.200
   139.631     1.517     0.200
   140.228     2.312     0.200
   135.295     1.199     0.200
   135.444     1.250     0.200
   135.637     0.965     0.200
   135.761     2.929     0.200
   136.271     1.180     0.200
   147.264     4.641     0.200
   138.526     1.948     0.200
   139.679     2.684     0.200
   140.948     2.667     0.200
   140.948     6.716     0.200
   147.148     4.090     0.200
   135.564     4.123     0.200
   135.942     1.166     0.200
   136.545     0.974     0.200
   138.809     3.377     0.200
   140.964     4.087     0.200
   142.304     2.276     0.200
   147.308     4.909     0.200
   135.288     3.015     0.200
   135.465     4.355     0.200
   135.931     3.538     0.200
   136.152     4.627     0.200
   136.301     3.749     0.200
   136.442     1.287     0.200
   136.451     2.301     0.200
   138.607     3.723     0.200
   138.864     2.753     0.200
   147.103     4.134     0.200
   139.822     2.441     0.200
   147.036     4.912     0.200
   136.052     1.266     0.200
EOF
# Indirect calibration
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000   -10.000 Indirect calibration: shifted hypocenters used
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
