#!/bin/bash
gmt begin herat11.41_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P herat11.41'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.715
    79.000     8.540
    80.000     7.448
    81.000     6.443
    82.000     5.524
    83.000     4.689
    84.000     3.937
    85.000     3.273
    86.000     2.695
    87.000     2.195
    88.000     1.798
    89.000     1.498
    90.000     1.240
    91.000     1.014
    92.000     0.813
    93.000     0.630
    94.000     0.465
    95.000     0.320
    96.000     0.200
    97.000     0.107
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    16.032     4.993     0.200
    16.760     2.961     0.200
    17.187     2.346     0.200
    17.403     0.171     0.200
    17.534     2.075     0.200
    17.814     1.953     0.200
    18.115     0.234     0.200
    18.275     1.395     0.200
    18.866     0.173     0.200
    18.846     0.956     0.200
    19.052     1.557     0.200
    19.154    -0.764     0.200
    19.332     0.362     0.200
    19.337    -1.060     0.200
    19.337    -0.681     0.200
    19.335     1.219     0.200
    19.407    -1.332     0.200
    19.407    -1.187     0.200
    19.407    -1.552     0.200
    19.578    -0.094     0.200
    19.584    -0.863     0.200
    19.584    -0.738     0.200
    19.584    -0.378     0.200
    19.584    -0.263     0.200
    19.584    -0.064     0.200
    19.584    -1.423     0.200
    19.584    -0.863     0.200
    20.037     0.265     0.200
    20.037    -0.491     0.200
    20.037     0.490     0.200
    20.127     2.075     0.200
    20.144     0.129     0.200
    20.144     0.391     0.200
    20.144    -0.211     0.200
    20.144     0.629     0.200
    20.144     1.826     0.200
    20.144     0.898     0.200
    20.376     0.951     0.200
    20.516    -0.610     0.200
    20.670    -1.678     0.200
    20.780     2.116     0.200
    20.817     1.756     0.200
    20.903     1.891     0.200
    21.055     0.752     0.200
    21.058     0.025     0.200
    21.122    -0.744     0.200
    21.122    -1.332     0.200
    21.305    -0.435     0.200
    21.250     0.791     0.200
    21.285     1.873     0.200
    21.338     2.610     0.200
    21.437     0.738     0.200
    21.568    -1.206     0.200
    21.702     0.961     0.200
    21.819     0.258     0.200
    21.909     0.083     0.200
    21.963     0.607     0.200
    21.863     1.367     0.200
    21.863     1.197     0.200
    21.863     1.027     0.200
    21.863     0.168     0.200
    21.919     1.000     0.200
    22.039     2.065     0.200
    22.047     2.239     0.200
    22.047     1.229     0.200
    22.047     2.600     0.200
    22.049     0.383     0.200
    22.188     1.000     0.200
    22.295    -0.017     0.200
    22.225     2.097     0.200
    22.307     2.041     0.200
    22.307     1.823     0.200
    22.541    -0.452     0.200
    22.490     2.291     0.200
    22.663     0.510     0.200
    22.728    -0.746     0.200
    22.766     1.249     0.200
    22.993     1.389     0.200
    23.011     0.372     0.200
    23.013     0.941     0.200
    23.014     1.040     0.200
    23.014     0.622     0.200
    23.014     0.911     0.200
    23.014     0.340     0.200
    23.014     2.618     0.200
    23.014     0.741     0.200
    23.014     0.331     0.200
    23.078     0.848     0.200
    23.195    -2.068     0.200
    23.263     0.043     0.200
    23.265    -2.011     0.200
    23.303     2.086     0.200
    23.303     1.770     0.200
    23.303     0.387     0.200
    23.313     0.181     0.200
    23.471     0.407     0.200
    23.417     1.297     0.200
    23.417     1.056     0.200
    23.417     0.127     0.200
    23.544     1.260     0.200
    23.566     1.296     0.200
    23.574     1.729     0.200
    23.673     1.129     0.200
    23.673     0.804     0.200
    23.673     1.324     0.200
    23.673     1.978     0.200
    23.673     1.474     0.200
    24.006     0.307     0.200
    24.014     0.801     0.200
    24.188    -0.155     0.200
    24.275     0.620     0.200
    24.418     0.396     0.200
    24.509     1.129     0.200
    24.528    -0.544     0.200
    24.679     1.165     0.200
    24.620     2.228     0.200
    24.930     2.538     0.200
    25.129     1.672     0.200
    25.128     0.348     0.200
    25.128     0.036     0.200
    25.128     0.348     0.200
    25.128     0.348     0.200
    25.128     0.088     0.200
    25.214     0.454     0.200
    25.214     0.954     0.200
    25.214     1.075     0.200
    25.217     2.256     0.200
    25.335     1.275     0.200
    25.485     0.983     0.200
    25.501     0.361     0.200
    25.430     1.207     0.200
    25.430     1.508     0.200
    25.430     0.742     0.200
    25.430     0.897     0.200
    25.430     0.557     0.200
    25.430     1.338     0.200
    25.510     0.831     0.200
    25.472     0.596     0.200
    25.988     1.458     0.200
    26.089    -1.255     0.200
    26.090    -0.176     0.200
    26.282    -0.317     0.200
    26.551     1.645     0.200
    26.587     1.635     0.200
    26.611     1.921     0.200
    26.811     1.220     0.200
    26.859     2.829     0.200
    26.978     0.004     0.200
    26.886     2.143     0.200
    26.950    -0.040     0.200
    26.941     1.542     0.200
    26.941     0.934     0.200
    26.941     1.343     0.200
    26.941     0.571     0.200
    27.298     1.883     0.200
    27.191     1.966     0.200
    27.217     2.412     0.200
    27.252     0.045     0.200
    27.280     1.697     0.200
    27.289     1.805     0.200
    27.382     2.147     0.200
    27.433     1.238     0.200
    27.433     1.366     0.200
    27.433     0.216     0.200
    27.433     0.825     0.200
    27.433     2.027     0.200
    27.472    -0.027     0.200
    27.472     0.375     0.200
    27.469     1.799     0.200
    27.482     1.785     0.200
    27.482     2.086     0.200
    27.531     0.183     0.200
    27.531     0.744     0.200
    27.653     1.172     0.200
    27.750     1.255     0.200
    27.750     1.586     0.200
    27.810     1.947     0.200
    27.817     2.795     0.200
    27.815     2.366     0.200
    27.926     1.126     0.200
    27.915     2.351     0.200
    27.941     2.565     0.200
    27.991     1.731     0.200
    27.991     2.032     0.200
    28.075     0.462     0.200
    28.177     2.230     0.200
    28.082     2.626     0.200
    28.089     3.662     0.200
    28.085     2.514     0.200
    28.201     0.892     0.200
    28.244     1.826     0.200
    28.189     0.104     0.200
    28.195     1.612     0.200
    28.283     1.723     0.200
    28.352     0.617     0.200
    28.356     2.598     0.200
    28.603     0.281     0.200
    28.529     0.839     0.200
    28.554     0.814     0.200
    28.525     2.473     0.200
    28.572     1.057     0.200
    28.572     1.207     0.200
    28.572     0.858     0.200
    28.579     0.994     0.200
    28.579    -0.254     0.200
    28.579     0.796     0.200
    28.579     1.185     0.200
    28.575     1.131     0.200
    28.583     0.862     0.200
    28.604     3.204     0.200
    28.629     0.850     0.200
    28.636     0.883     0.200
    28.649     1.268     0.200
    28.653     0.837     0.200
    28.676     2.385     0.200
    28.672     0.866     0.200
    28.676     2.246     0.200
    28.706     0.601     0.200
    28.712     2.948     0.200
    28.707     0.853     0.200
    28.817     2.270     0.200
    28.817     1.145     0.200
    28.817     1.381     0.200
    28.817     2.785     0.200
    28.779     2.136     0.200
    28.904     0.715     0.200
    28.833     2.532     0.200
    28.848     2.250     0.200
    28.848     0.801     0.200
    28.848     2.600     0.200
    28.852     3.069     0.200
    28.861     0.412     0.200
    28.853     3.510     0.200
    28.852     2.732     0.200
    28.861     1.531     0.200
    28.861     1.883     0.200
    28.899     3.049     0.200
    28.899     2.826     0.200
    29.031     0.329     0.200
    29.064     1.579     0.200
    29.145    -0.095     0.200
    29.073     3.525     0.200
    29.080     2.199     0.200
    29.225     0.696     0.200
    29.167     0.490     0.200
    29.167     0.375     0.200
    29.188     0.385     0.200
    29.214     2.449     0.200
    29.254     0.750     0.200
    29.279     1.870     0.200
    29.249     1.622     0.200
    29.249     1.818     0.200
    29.249     1.197     0.200
    29.251     2.773     0.200
    29.277     2.592     0.200
    29.326     3.186     0.200
    29.326     2.052     0.200
    29.326     2.468     0.200
    29.352     1.830     0.200
    29.352     2.228     0.200
    29.519     1.296     0.200
    29.449     1.216     0.200
    29.449     0.552     0.200
    29.449     0.663     0.200
    29.527     0.723     0.200
    29.643    -1.399     0.200
    29.578    -0.263     0.200
    29.578    -0.140     0.200
    29.609    -0.590     0.200
    29.497     3.039     0.200
    29.620    -0.664     0.200
    29.673    -0.439     0.200
    29.673     0.159     0.200
    29.780     0.147     0.200
    29.786     2.383     0.200
    29.807     1.395     0.200
    29.878     1.970     0.200
    29.868     0.708     0.200
    29.899     1.679     0.200
    29.903     2.545     0.200
    29.928     2.707     0.200
    29.941     1.940     0.200
    29.941     2.206     0.200
    29.973     0.449     0.200
    29.997     1.759     0.200
    30.022     0.296     0.200
    30.012     2.623     0.200
    30.022     1.232     0.200
    30.029     2.039     0.200
    30.210     1.720     0.200
    30.210    -0.751     0.200
    30.210     1.064     0.200
    30.206     1.968     0.200
    30.217     2.640     0.200
    30.222     2.131     0.200
    30.223     0.888     0.200
    30.314     2.612     0.200
    30.321     0.430     0.200
    30.337     0.294     0.200
    30.450     2.012     0.200
    30.399     2.716     0.200
    30.413     1.078     0.200
    30.436     1.021     0.200
    30.436     1.533     0.200
    30.515     1.731     0.200
    30.512     1.864     0.200
    30.543    -0.379     0.200
    30.599     1.138     0.200
    30.617     1.636     0.200
    30.665     0.770     0.200
    30.668     3.986     0.200
    30.681     1.537     0.200
    30.695     1.065     0.200
    30.684     2.181     0.200
    30.719     1.882     0.200
    30.740     0.537     0.200
    30.746     1.193     0.200
    30.789     0.603     0.200
    30.790     0.389     0.200
    30.826     0.774     0.200
    30.836     1.676     0.200
    30.836     1.936     0.200
    30.844     1.154     0.200
    30.859     1.799     0.200
    30.884     1.017     0.200
    30.905     1.284     0.200
    30.903     1.597     0.200
    30.913     1.042     0.200
    30.910    -1.948     0.200
    30.937    -0.668     0.200
    30.937    -0.162     0.200
    30.960    -0.535     0.200
    30.977     0.234     0.200
    30.968     1.239     0.200
    30.980     2.131     0.200
    31.054     0.684     0.200
    31.058     1.298     0.200
    31.066     0.626     0.200
    31.059     2.962     0.200
    31.101     1.259     0.200
    31.101     1.560     0.200
    31.076     0.517     0.200
    31.088     0.534     0.200
    31.087     0.766     0.200
    31.102     1.218     0.200
    31.109     0.234     0.200
    31.129     2.914     0.200
    31.148     0.610     0.200
    31.254     1.495     0.200
    31.254     0.372     0.200
    31.254     0.864     0.200
    31.151     2.425     0.200
    31.170     3.167     0.200
    31.197     1.834     0.200
    31.198     1.383     0.200
    31.203     0.933     0.200
    31.211     1.273     0.200
    31.243     0.996     0.200
    31.243     1.515     0.200
    31.245     2.068     0.200
    31.268     0.385     0.200
    31.300    -1.122     0.200
    31.299     2.037     0.200
    31.340    -0.218     0.200
    31.359     2.312     0.200
    31.359     2.492     0.200
    31.371    -0.594     0.200
    31.392    -0.684     0.200
    31.386     2.650     0.200
    31.441     2.269     0.200
    31.464    -0.749     0.200
    31.457     2.623     0.200
    31.472     2.195     0.200
    31.492     2.318     0.200
    31.492     2.139     0.200
    31.525     2.029     0.200
    31.545     0.456     0.200
    31.555    -0.674     0.200
    31.586     0.030     0.200
    31.586     0.840     0.200
    31.609     1.184     0.200
    31.622     0.840     0.200
    31.622     1.074     0.200
    31.680    -0.896     0.200
    31.744     2.283     0.200
    31.744     2.703     0.200
    31.792     3.079     0.200
    31.806     0.905     0.200
    31.959    -0.411     0.200
    31.959    -0.747     0.200
    31.873    -0.229     0.200
    31.911    -0.758     0.200
    31.984    -0.529     0.200
    31.983     0.077     0.200
    32.001     1.793     0.200
    32.012    -1.954     0.200
    32.018     2.959     0.200
    32.047    -1.204     0.200
    32.072     2.703     0.200
    32.074     2.073     0.200
    32.074     2.251     0.200
    32.091     3.376     0.200
    32.126    -0.531     0.200
    32.126     0.977     0.200
    32.135    -0.681     0.200
    32.141     1.879     0.200
    32.164    -0.980     0.200
    32.160     2.076     0.200
    32.299     1.534     0.200
    32.299     1.198     0.200
    32.299     1.057     0.200
    32.299     3.547     0.200
    32.221     2.278     0.200
    32.238    -0.534     0.200
    32.286     1.336     0.200
    32.263     1.879     0.200
    32.263     2.561     0.200
    32.294    -0.605     0.200
    32.294    -0.347     0.200
    32.328     1.322     0.200
    32.326     1.088     0.200
    32.359     1.852     0.200
    32.359     0.963     0.200
    32.359     2.102     0.200
    32.368    -0.835     0.200
    32.397     2.564     0.200
    32.397     2.399     0.200
    32.420    -0.990     0.200
    32.441    -0.455     0.200
    32.458    -0.083     0.200
    32.480    -1.445     0.200
    32.468     1.454     0.200
    32.468     2.445     0.200
    32.547    -0.376     0.200
    32.555    -1.288     0.200
    32.571     0.588     0.200
    32.655    -0.166     0.200
    32.671     0.290     0.200
    32.675     2.772     0.200
    32.688    -1.585     0.200
    33.043     0.612     0.200
    32.958     2.052     0.200
    33.076    -0.101     0.200
    33.084    -1.754     0.200
    33.090    -0.853     0.200
    33.100    -0.777     0.200
    33.119    -1.526     0.200
    33.119    -0.399     0.200
    33.153     2.052     0.200
    33.209    -1.303     0.200
    33.314     1.429     0.200
    33.220    -1.149     0.200
    33.210    -1.008     0.200
    33.210     0.184     0.200
    33.282    -0.085     0.200
    33.282     0.423     0.200
    33.293     0.906     0.200
    33.328     1.466     0.200
    33.328     0.725     0.200
    33.328     1.026     0.200
    33.328     1.827     0.200
    33.328     1.622     0.200
    33.377    -0.860     0.200
    33.416     0.975     0.200
    33.468     2.725     0.200
    33.484     2.070     0.200
    33.484     2.561     0.200
    33.509    -0.265     0.200
    33.509     0.577     0.200
    33.523     0.921     0.200
    33.688    -0.541     0.200
    33.688    -0.312     0.200
    33.678    -0.619     0.200
    33.678    -0.472     0.200
    33.759     3.295     0.200
    33.759     3.516     0.200
    33.795     2.372     0.200
    33.795     1.452     0.200
    33.851     0.375     0.200
    33.847     1.401     0.200
    33.961     0.911     0.200
    33.945     0.355     0.200
    33.945     1.068     0.200
    33.961     2.459     0.200
    34.056     1.383     0.200
    34.089     1.523     0.200
    34.123     1.508     0.200
    34.123     1.618     0.200
    34.151     1.762     0.200
    34.166     1.536     0.200
    34.252     2.485     0.200
    34.327     2.165     0.200
    34.327     2.325     0.200
    34.327     2.656     0.200
    34.328     1.030     0.200
    34.328     0.751     0.200
    34.427     3.673     0.200
    34.459     1.396     0.200
    34.477     1.703     0.200
    34.477     1.951     0.200
    34.526     1.612     0.200
    34.543     1.766     0.200
    34.591     1.276     0.200
    34.591     1.674     0.200
    34.607    -0.085     0.200
    34.667    -0.593     0.200
    34.758     1.422     0.200
    34.758     1.701     0.200
    34.797     2.573     0.200
    34.834     1.448     0.200
    34.824     1.841     0.200
    34.832     1.703     0.200
    34.840     2.176     0.200
    34.846     1.946     0.200
    34.846     1.573     0.200
    35.086    -0.119     0.200
    35.003     0.692     0.200
    35.022     1.000     0.200
    35.022     0.830     0.200
    35.043     1.691     0.200
    35.075     1.671     0.200
    35.101     1.845     0.200
    35.110     1.675     0.200
    35.222     0.504     0.200
    35.145     1.288     0.200
    35.209     1.721     0.200
    35.209     1.871     0.200
    35.209     1.395     0.200
    35.209     1.815     0.200
    35.304     1.797     0.200
    35.347     2.053     0.200
    35.347     2.334     0.200
    35.384     2.671     0.200
    35.384     2.411     0.200
    35.474     0.034     0.200
    35.474     0.907     0.200
    35.481     0.379     0.200
    35.487     0.423     0.200
    35.442     1.841     0.200
    35.442     0.210     0.200
    35.442     1.111     0.200
    35.452     1.626     0.200
    35.458     1.673     0.200
    35.465     2.827     0.200
    35.504     3.081     0.200
    35.587     1.893     0.200
    35.587     2.163     0.200
    35.589     2.159     0.200
    35.648     1.343     0.200
    35.783     1.970     0.200
    35.783     1.271     0.200
    35.913    -0.168     0.200
    35.830     0.639     0.200
    35.848     1.731     0.200
    35.918     1.559     0.200
    35.918     1.065     0.200
    35.907     1.422     0.200
    35.956     0.195     0.200
    35.956    -0.122     0.200
    35.956     0.328     0.200
    36.001     0.994     0.200
    36.008     1.455     0.200
    36.020     1.243     0.200
    36.058     1.825     0.200
    36.116     1.803     0.200
    36.141     1.140     0.200
    36.141     2.023     0.200
    36.141     1.744     0.200
    36.145     1.683     0.200
    36.186     1.475     0.200
    36.242     1.790     0.200
    36.242     1.618     0.200
    36.307     1.346     0.200
    36.431     0.275     0.200
    36.431     0.140     0.200
    36.435     0.046     0.200
    36.367     1.879     0.200
    36.462     0.475     0.200
    36.466     0.617     0.200
    36.446     2.474     0.200
    36.446     0.535     0.200
    36.446     2.314     0.200
    36.495     1.876     0.200
    36.625    -0.390     0.200
    36.625     0.231     0.200
    36.534     2.105     0.200
    36.534     2.904     0.200
    36.534     2.404     0.200
    36.640     0.057     0.200
    36.541     2.326     0.200
    36.541     1.996     0.200
    36.658     0.102     0.200
    36.587     0.895     0.200
    36.647     2.493     0.200
    36.644     0.849     0.200
    36.663     1.503     0.200
    36.663     2.478     0.200
    36.663     2.357     0.200
    36.673     1.162     0.200
    36.673     4.222     0.200
    36.678     1.581     0.200
    36.681     1.773     0.200
    36.681     1.951     0.200
    36.700     1.164     0.200
    36.700     0.904     0.200
    36.735     0.753     0.200
    36.739     1.020     0.200
    36.739     2.117     0.200
    36.739     1.338     0.200
    36.791    -0.332     0.200
    36.824     0.606     0.200
    36.838     1.990     0.200
    36.859     1.689     0.200
    36.957     1.641     0.200
    36.957     1.498     0.200
    36.993     1.918     0.200
    37.152     0.458     0.200
    37.295     0.775     0.200
    37.322     1.815     0.200
    37.327     1.668     0.200
    37.330     1.932     0.200
    37.347     1.098     0.200
    37.533     0.768     0.200
    37.540     1.009     0.200
    37.540     0.679     0.200
    37.540     1.909     0.200
    37.540     1.811     0.200
    37.562     1.143     0.200
    37.580     0.079     0.200
    37.580    -0.230     0.200
    37.591     1.579     0.200
    37.618     1.882     0.200
    37.652     1.254     0.200
    37.715     1.647     0.200
    37.715     1.526     0.200
    37.862     1.033     0.200
    37.919     1.527     0.200
    37.935     0.666     0.200
    37.928     1.115     0.200
    37.946     1.320     0.200
    37.950     1.810     0.200
    37.976     1.086     0.200
    37.976     0.575     0.200
    37.978     1.573     0.200
    37.984     1.504     0.200
    37.993     1.568     0.200
    37.993     0.330     0.200
    37.993     1.503     0.200
    38.001     1.561     0.200
    38.001     0.690     0.200
    38.076     1.876     0.200
    38.015    -0.192     0.200
    38.038     1.821     0.200
    38.093     1.348     0.200
    38.093     0.646     0.200
    38.093     0.937     0.200
    38.108     1.027     0.200
    38.124     0.436     0.200
    38.138     0.038     0.200
    38.138     0.820     0.200
    38.160     1.843     0.200
    38.161     1.795     0.200
    38.161     2.033     0.200
    38.213     1.709     0.200
    38.225     1.553     0.200
    38.278     1.830     0.200
    38.278     1.219     0.200
    38.278     0.778     0.200
    38.278     1.647     0.200
    38.321     1.539     0.200
    38.321     0.628     0.200
    38.321     0.921     0.200
    38.399     0.801     0.200
    38.451     0.895     0.200
    38.563     0.582     0.200
    38.563     0.702     0.200
    38.548     1.332     0.200
    38.548     0.922     0.200
    38.553     0.818     0.200
    38.553    -0.141     0.200
    38.588     1.559     0.200
    38.622     1.382     0.200
    38.651     1.438     0.200
    38.651     0.496     0.200
    38.651     1.717     0.200
    38.708     1.862     0.200
    38.728     1.329     0.200
    38.780     1.037     0.200
    38.780     0.277     0.200
    38.849     1.583     0.200
    38.861     0.965     0.200
    38.904     2.058     0.200
    38.910     1.972     0.200
    39.151     0.151     0.200
    39.151    -0.169     0.200
    39.018     0.857     0.200
    39.027     1.678     0.200
    39.037     0.692     0.200
    39.067     1.453     0.200
    39.105     2.086     0.200
    39.109     0.265     0.200
    38.987     2.304     0.200
    38.987     2.586     0.200
    39.281     0.820     0.200
    39.281     0.470     0.200
    39.265     1.563     0.200
    39.334     2.323     0.200
    39.328     1.240     0.200
    39.334     1.004     0.200
    39.338     1.310     0.200
    39.351     1.690     0.200
    39.369     0.898     0.200
    39.367     1.681     0.200
    39.391     1.205     0.200
    39.392     1.478     0.200
    39.410     2.073     0.200
    39.430     1.788     0.200
    39.437     1.056     0.200
    39.437     1.305     0.200
    39.466     2.140     0.200
    39.529     1.174     0.200
    39.578     1.283     0.200
    39.602     2.099     0.200
    39.606     1.687     0.200
    39.620     0.819     0.200
    39.641     1.905     0.200
    39.641     2.014     0.200
    39.662     2.190     0.200
    39.662     0.182     0.200
    39.691     0.568     0.200
    39.758     0.891     0.200
    39.756     1.324     0.200
    39.769     1.739     0.200
    39.769     1.899     0.200
    39.848     1.418     0.200
    39.848     1.688     0.200
    39.848     0.553     0.200
    39.874     1.107     0.200
    39.889     1.930     0.200
    39.922     0.708     0.200
    39.949     0.807     0.200
    39.996     0.613     0.200
    39.996     1.163     0.200
    40.113     0.012     0.200
    40.113     0.953     0.200
    40.040     1.152     0.200
    40.047     3.313     0.200
    40.080     1.152     0.200
    40.136     0.560     0.200
    40.175     1.559     0.200
    40.175     1.277     0.200
    40.178     2.521     0.200
    40.239     1.461     0.200
    40.239     0.791     0.200
    40.239     1.316     0.200
    40.239     0.831     0.200
    40.247     0.825     0.200
    40.268     0.493     0.200
    40.278     1.059     0.200
    40.278     0.569     0.200
    40.326     0.194     0.200
    40.329     0.521     0.200
    40.335     2.095     0.200
    40.363     0.696     0.200
    40.363    -0.466     0.200
    40.517     1.796     0.200
    40.524     0.719     0.200
    40.537     0.855     0.200
    40.533     1.162     0.200
    40.561     0.718     0.200
    40.567     2.071     0.200
    40.572     1.810     0.200
    40.578     2.045     0.200
    40.830     2.044     0.200
    40.916     0.791     0.200
    40.917     1.863     0.200
    40.936     0.438     0.200
    40.968     1.348     0.200
    40.968     0.348     0.200
    40.968     0.613     0.200
    41.017     0.645     0.200
    41.027     2.022     0.200
    41.097     0.333     0.200
    41.156     0.174     0.200
    41.156    -0.246     0.200
    41.271     1.780     0.200
    41.258     0.781     0.200
    41.276     0.859     0.200
    41.318     0.789     0.200
    41.346     0.615     0.200
    41.398     1.804     0.200
    41.435     1.714     0.200
    41.452     0.350     0.200
    41.462     1.278     0.200
    41.470     2.143     0.200
    41.474     2.402     0.200
    41.482     0.689     0.200
    41.497     0.700     0.200
    41.492     0.601     0.200
    41.513     0.593     0.200
    41.513     0.192     0.200
    41.513     0.792     0.200
    41.513     0.468     0.200
    41.518     0.626     0.200
    41.532     0.686     0.200
    41.547     0.636     0.200
    41.548     0.927     0.200
    41.548     0.548     0.200
    41.548     0.227     0.200
    41.548     0.708     0.200
    41.548    -0.097     0.200
    41.573     2.045     0.200
    41.573     2.295     0.200
    41.668     1.624     0.200
    41.682     0.945     0.200
    41.682     0.749     0.200
    41.682     0.640     0.200
    41.727     1.416     0.200
    41.855    -0.148     0.200
    41.855    -0.670     0.200
    41.801     1.326     0.200
    41.933    -0.185     0.200
    41.946     0.428     0.200
    41.948     1.029     0.200
    41.948     1.709     0.200
    41.977     1.755     0.200
    41.977     0.949     0.200
    42.142     1.351     0.200
    42.173     1.336     0.200
    42.203     1.015     0.200
    42.230     1.482     0.200
    42.230     0.633     0.200
    42.290     1.742     0.200
    42.245     1.805     0.200
    42.245     0.706     0.200
    42.273     1.150     0.200
    42.349     1.662     0.200
    42.321     0.357     0.200
    42.333     0.854     0.200
    42.333     0.719     0.200
    42.336     0.792     0.200
    42.427     1.340     0.200
    42.427     0.856     0.200
    42.427     1.565     0.200
    42.358     1.384     0.200
    42.374     0.918     0.200
    42.414     1.337     0.200
    42.439     1.065     0.200
    42.497     0.885     0.200
    42.517     1.940     0.200
    42.517     1.190     0.200
    42.517     2.240     0.200
    42.590    -0.629     0.200
    42.522     0.924     0.200
    42.538     0.978     0.200
    42.553     1.952     0.200
    42.556     1.435     0.200
    42.567     1.223     0.200
    42.680     0.268     0.200
    42.590     0.844     0.200
    42.606     1.220     0.200
    42.713     0.677     0.200
    42.844    -0.136     0.200
    42.772     1.172     0.200
    42.856     0.997     0.200
    42.935     0.432     0.200
    42.935     1.851     0.200
    42.854     2.352     0.200
    42.873     1.331     0.200
    42.915     1.987     0.200
    42.953     2.331     0.200
    42.953     1.870     0.200
    42.953     1.489     0.200
    42.953     2.000     0.200
    42.953     0.522     0.200
    43.076     0.455     0.200
    43.076     0.797     0.200
    43.009     1.702     0.200
    43.045    -0.004     0.200
    43.076     1.009     0.200
    43.076     0.627     0.200
    43.076     1.597     0.200
    43.034     2.018     0.200
    43.036     1.259     0.200
    43.081     1.568     0.200
    43.102     2.260     0.200
    43.258     1.368     0.200
    43.343     0.963     0.200
    43.461    -0.132     0.200
    43.473     2.140     0.200
    43.476     2.316     0.200
    43.539     2.095     0.200
    43.539     2.274     0.200
    43.661     0.235     0.200
    43.589     1.449     0.200
    43.613     1.685     0.200
    43.831     2.065     0.200
    43.847     2.238     0.200
    43.848     1.033     0.200
    43.863     0.846     0.200
    43.985     0.027     0.200
    43.917     1.574     0.200
    43.948     2.093     0.200
    43.980     1.792     0.200
    44.035     0.898     0.200
    44.057     2.456     0.200
    44.078     1.701     0.200
    44.078     1.442     0.200
    44.135     1.998     0.200
    44.191     1.778     0.200
    44.211     1.818     0.200
    44.260     1.733     0.200
    44.275     1.614     0.200
    44.347     0.007     0.200
    44.356     0.793     0.200
    44.356     1.662     0.200
    44.369     1.453     0.200
    44.360     1.176     0.200
    44.360     0.856     0.200
    44.360     0.655     0.200
    44.412     1.690     0.200
    44.414     1.721     0.200
    44.517     1.674     0.200
    44.483     2.342     0.200
    44.538     1.319     0.200
    44.579     2.031     0.200
    44.623     1.024     0.200
    44.617     0.759     0.200
    44.782     2.257     0.200
    44.908    -0.213     0.200
    44.908    -0.431     0.200
    44.956     1.869     0.200
    44.962     0.891     0.200
    45.027     1.901     0.200
    45.114    -0.492     0.200
    45.114     0.198     0.200
    45.151     1.915     0.200
    45.275    -1.596     0.200
    45.164     2.666     0.200
    45.450     1.342     0.200
    45.468     0.482     0.200
    45.468     0.741     0.200
    45.607     1.034     0.200
    45.607     0.124     0.200
    45.607     1.255     0.200
    45.607     0.624     0.200
    45.976     0.025     0.200
    45.974    -0.020     0.200
    46.085     2.326     0.200
    46.140     1.458     0.200
    46.160     0.536     0.200
    46.299     0.872     0.200
    46.334     1.218     0.200
    46.419     0.503     0.200
    46.453     0.031     0.200
    46.587     0.713     0.200
    46.639    -0.223     0.200
    46.647     1.515     0.200
    46.679     1.339     0.200
    46.866    -1.101     0.200
    46.866    -1.390     0.200
    46.866    -1.611     0.200
    46.990     0.187     0.200
    46.990     0.318     0.200
    47.052     0.027     0.200
    47.052    -0.235     0.200
    47.052    -0.594     0.200
    46.977     1.362     0.200
    47.099     1.247     0.200
    47.099     1.647     0.200
    47.099     0.128     0.200
    47.115     2.353     0.200
    47.116     1.242     0.200
    47.132     0.879     0.200
    47.141     1.768     0.200
    47.162    -1.816     0.200
    47.301     1.102     0.200
    47.275     0.633     0.200
    47.387     0.332     0.200
    47.392     1.393     0.200
    47.390     0.475     0.200
    47.422     0.602     0.200
    47.508     0.674     0.200
    47.566     0.789     0.200
    47.625     0.998     0.200
    47.698     2.354     0.200
    47.698     0.727     0.200
    47.717     0.631     0.200
    47.882     0.295     0.200
    47.882    -0.144     0.200
    47.783     0.807     0.200
    47.795     0.955     0.200
    47.871     1.165     0.200
    47.871     1.045     0.200
    48.022     0.905     0.200
    48.069     0.245     0.200
    48.016     0.528     0.200
    48.097     0.923     0.200
    48.091     1.259     0.200
    48.113     0.834     0.200
    48.226     0.631     0.200
    48.223     0.851     0.200
    48.261     0.440     0.200
    48.406     0.428     0.200
    48.442     0.285     0.200
    48.446     0.929     0.200
    48.457     1.087     0.200
    48.457     1.267     0.200
    48.473     1.690     0.200
    48.473     0.901     0.200
    48.473     0.541     0.200
    48.473     1.520     0.200
    48.473     1.340     0.200
    48.473     1.190     0.200
    48.481     0.740     0.200
    48.500     0.277     0.200
    48.603     0.643     0.200
    48.629     0.675     0.200
    48.642     1.300     0.200
    48.739     2.373     0.200
    48.758     0.434     0.200
    48.854     0.995     0.200
    48.854     1.440     0.200
    48.854     1.309     0.200
    48.873     1.146     0.200
    48.901     1.229     0.200
    48.892     0.163     0.200
    48.926     0.861     0.200
    48.992     0.535     0.200
    49.068     0.912     0.200
    49.072     1.253     0.200
    49.181     0.635     0.200
    49.181     1.785     0.200
    49.181     0.139     0.200
    49.145     0.545     0.200
    49.213     0.840     0.200
    49.170     0.987     0.200
    49.314     1.172     0.200
    49.314     0.990     0.200
    49.247     0.929     0.200
    49.252     1.143     0.200
    49.322     0.734     0.200
    49.369     0.847     0.200
    49.445     0.978     0.200
    49.460     1.404     0.200
    49.600     0.984     0.200
    49.633     0.644     0.200
    49.753     0.090     0.200
    49.753    -0.089     0.200
    49.753     1.321     0.200
    49.726     0.392     0.200
    49.962     0.630     0.200
    50.144     0.499     0.200
    50.144    -0.028     0.200
    50.149     0.910     0.200
    50.152     0.901     0.200
    50.152     0.702     0.200
    50.248     1.154     0.200
    50.248     0.815     0.200
    50.248     1.434     0.200
    50.228     0.914     0.200
    50.228     0.154     0.200
    50.280     0.377     0.200
    50.280     0.578     0.200
    50.280     0.717     0.200
    50.370     0.551     0.200
    50.360     0.890     0.200
    50.392     0.619     0.200
    50.392     0.769     0.200
    50.509     0.927     0.200
    50.509     2.240     0.200
    50.509     1.787     0.200
    50.538     0.342     0.200
    50.630     0.312     0.200
    50.932    -0.340     0.200
    50.865     0.522     0.200
    50.865     1.202     0.200
    50.865     0.801     0.200
    50.953     1.458     0.200
    51.136     0.167     0.200
    51.443     0.571     0.200
    51.483     0.574     0.200
    51.483     0.293     0.200
    51.553     1.441     0.200
    51.622     1.220     0.200
    51.652     1.197     0.200
    51.661     0.499     0.200
    51.662     0.568     0.200
    51.717     0.015     0.200
    51.680    -0.127     0.200
    51.684     0.558     0.200
    51.985     1.313     0.200
    51.998     2.178     0.200
    51.998     0.618     0.200
    52.036     1.563     0.200
    52.036     1.782     0.200
    52.036     0.634     0.200
    51.984     0.417     0.200
    51.984     0.888     0.200
    52.158     0.327     0.200
    52.152     1.172     0.200
    52.233     0.454     0.200
    52.263     2.112     0.200
    52.264     1.136     0.200
    52.393     2.041     0.200
    52.393    -0.267     0.200
    52.384    -0.269     0.200
    52.384    -0.623     0.200
    52.347     1.022     0.200
    52.443     0.330     0.200
    52.443     0.615     0.200
    52.443     0.560     0.200
    52.457     0.707     0.200
    52.461     0.778     0.200
    52.443     0.659     0.200
    52.564     0.678     0.200
    52.894    -0.261     0.200
    52.894    -0.610     0.200
    53.048     0.904     0.200
    53.045     2.742     0.200
    53.045     2.226     0.200
    53.045     1.658     0.200
    53.210     2.111     0.200
    53.482     0.844     0.200
    53.484     0.297     0.200
    53.484    -0.174     0.200
    53.484     0.501     0.200
    53.484    -0.163     0.200
    53.496     0.839     0.200
    53.978     0.527     0.200
    54.004     0.176     0.200
    54.079     1.462     0.200
    54.079     0.833     0.200
    54.079     1.618     0.200
    54.144     1.893     0.200
    54.272     2.329     0.200
    54.270     1.036     0.200
    54.341     0.342     0.200
    54.341    -0.289     0.200
    54.341     0.582     0.200
    54.397     1.450     0.200
    54.403     0.041     0.200
    54.403     0.740     0.200
    54.403     1.211     0.200
    54.403     1.000     0.200
    54.479     0.855     0.200
    54.492     1.029     0.200
    54.493     0.328     0.200
    54.573     2.021     0.200
    54.573     1.072     0.200
    54.573     0.172     0.200
    54.527     0.579     0.200
    54.527    -0.222     0.200
    54.600     0.577     0.200
    54.590     0.449     0.200
    54.590     0.592     0.200
    54.590     0.918     0.200
    54.604     1.547     0.200
    54.765     0.068     0.200
    54.765    -0.461     0.200
    54.770     0.841     0.200
    54.936     0.761     0.200
    54.862     1.647     0.200
    55.011     0.527     0.200
    55.011     0.859     0.200
    55.079     1.807     0.200
    55.168     1.170     0.200
    55.168     2.084     0.200
    55.168     0.469     0.200
    55.168     1.408     0.200
    55.168     2.914     0.200
    55.165     0.435     0.200
    55.165     0.752     0.200
    55.394     0.514     0.200
    55.564     0.654     0.200
    55.712     0.627     0.200
    55.712     2.518     0.200
    55.813    -0.138     0.200
    55.813     0.723     0.200
    55.813     0.606     0.200
    55.742     1.716     0.200
    55.742     1.405     0.200
    55.790     0.659     0.200
    55.898     0.670     0.200
    55.921     1.417     0.200
    56.089     0.833     0.200
    56.089     0.237     0.200
    56.232    -1.656     0.200
    56.226     1.252     0.200
    56.243     2.118     0.200
    56.400     0.461     0.200
    56.400    -0.213     0.200
    56.400     0.220     0.200
    56.400     0.730     0.200
    56.415     2.925     0.200
    56.415     2.698     0.200
    56.415     0.149     0.200
    56.415     1.220     0.200
    56.522     0.182     0.200
    56.522     0.520     0.200
    56.691    -0.096     0.200
    56.691    -0.516     0.200
    56.691     1.605     0.200
    56.746    -0.432     0.200
    56.813     1.686     0.200
    56.870    -0.143     0.200
    57.201     0.610     0.200
    57.201    -0.937     0.200
    57.201     0.811     0.200
    57.201     1.421     0.200
    57.201     1.135     0.200
    57.566     1.740     0.200
    58.187    -0.995     0.200
    58.187    -0.770     0.200
    58.187     0.198     0.200
    58.187    -0.591     0.200
    58.318     1.069     0.200
    58.283     1.380     0.200
    58.733     2.567     0.200
    59.089     1.029     0.200
    59.089     0.757     0.200
    59.380     1.221     0.200
    59.511     1.110     0.200
    59.869     0.744     0.200
    59.869     0.269     0.200
    59.869     1.045     0.200
    59.869     0.474     0.200
    59.994     0.685     0.200
    59.982     1.788     0.200
    59.982     0.868     0.200
    60.070     0.768     0.200
    60.070     0.499     0.200
    60.070     0.278     0.200
    60.185     0.724     0.200
    60.227    -0.184     0.200
    60.227     0.316     0.200
    60.300     0.382     0.200
    60.300     0.558     0.200
    60.316     1.178     0.200
    60.316     1.988     0.200
    60.316     1.678     0.200
    60.491     0.096     0.200
    60.491    -0.264     0.200
    60.493     0.376     0.200
    60.493     0.583     0.200
    60.934     0.761     0.200
    60.934     0.040     0.200
    61.219     1.387     0.200
    61.921     0.645     0.200
    62.601     1.866     0.200
    62.773     0.877     0.200
    62.773     1.219     0.200
    62.717     1.173     0.200
    62.717     0.911     0.200
    62.717     1.071     0.200
    62.885     0.571     0.200
    63.468     0.873     0.200
    63.468     0.443     0.200
    63.809    -0.378     0.200
    63.941     0.337     0.200
    63.941     0.821     0.200
    64.110     0.038     0.200
    64.110    -0.489     0.200
    64.110     0.742     0.200
    64.096     0.983     0.200
    64.096     0.766     0.200
    64.096     2.001     0.200
    64.443    -0.304     0.200
    64.537     0.470     0.200
    64.591     1.139     0.200
    64.693    -2.113     0.200
    64.947     0.570     0.200
    65.405     0.915     0.200
    65.405     0.177     0.200
    65.405     0.696     0.200
    65.553     0.878     0.200
    65.553     0.349     0.200
    65.686     0.659     0.200
    66.232    -2.043     0.200
    66.352    -1.432     0.200
    66.343     1.116     0.200
    66.342     1.062     0.200
    66.342    -0.158     0.200
    66.342    -0.389     0.200
    66.354     0.985     0.200
    66.639     0.956     0.200
    66.639     0.650     0.200
    66.829    -0.493     0.200
    66.894     0.556     0.200
    66.894    -0.745     0.200
    66.998     0.649     0.200
    66.998    -1.095     0.200
    66.998    -2.148     0.200
    67.192    -1.350     0.200
    67.192    -1.462     0.200
    67.192    -0.382     0.200
    67.192    -2.368     0.200
    67.192    -1.141     0.200
    67.127     0.077     0.200
    67.127     0.292     0.200
    67.900     0.186     0.200
    67.900    -0.035     0.200
    67.900     0.795     0.200
    67.990     1.880     0.200
    68.131     1.214     0.200
    68.131    -0.001     0.200
    68.131     1.349     0.200
    68.131     0.999     0.200
    68.251    -1.472     0.200
    68.251    -1.189     0.200
    68.491     0.932     0.200
    68.603     0.911     0.200
    68.603     0.392     0.200
    68.603     0.661     0.200
    69.000     0.488     0.200
    68.995     0.652     0.200
    68.995     1.460     0.200
    69.411     1.297     0.200
    69.537     1.135     0.200
    69.537    -0.365     0.200
    69.537     0.135     0.200
    69.537     0.465     0.200
    70.038    -1.505     0.200
    69.855     0.112     0.200
    70.143    -0.297     0.200
    70.143    -0.527     0.200
    70.143    -0.066     0.200
    70.324    -0.066     0.200
    70.324     0.786     0.200
    71.044     0.039     0.200
    71.044     1.634     0.200
    71.044     1.249     0.200
    71.822     0.366     0.200
    71.822    -0.358     0.200
    71.822     0.091     0.200
    71.859     0.828     0.200
    72.133     0.243     0.200
    72.263     0.341     0.200
    72.409     1.376     0.200
    72.409    -0.015     0.200
    72.409     2.315     0.200
    72.881    -0.928     0.200
    72.910     0.366     0.200
    72.937     1.777     0.200
    73.150     0.945     0.200
    73.638    -0.299     0.200
    73.658    -0.146     0.200
    73.658    -1.016     0.200
    73.658    -2.148     0.200
    73.647     0.828     0.200
    73.695     0.788     0.200
    74.261     0.834     0.200
    74.341     0.784     0.200
    74.341     0.628     0.200
    74.344     1.423     0.200
    74.388     1.662     0.200
    74.388     0.943     0.200
    74.388     1.560     0.200
    74.398     2.089     0.200
    74.398     1.788     0.200
    74.380     0.033     0.200
    74.738     0.653     0.200
    74.738    -0.896     0.200
    74.738    -0.666     0.200
    74.656     0.001     0.200
    74.857     0.452     0.200
    74.941     0.957     0.200
    75.130    -1.244     0.200
    75.238    -1.862     0.200
    75.344     0.112     0.200
    75.612     1.100     0.200
    75.612     0.301     0.200
    75.612     0.180     0.200
    75.550     0.511     0.200
    75.550     1.378     0.200
    75.641     1.203     0.200
    75.641     0.294     0.200
    75.641     0.033     0.200
    75.968     0.874     0.200
    75.979     0.139     0.200
    76.393    -2.362     0.200
    76.701     1.093     0.200
    76.701     0.854     0.200
    76.701     0.403     0.200
    77.047     1.125     0.200
    77.047     0.842     0.200
    77.047     0.252     0.200
    77.047     0.031     0.200
    77.302     0.499     0.200
    77.417     0.274     0.200
    77.594     0.647     0.200
    77.990    -0.870     0.200
    77.951     1.429     0.200
    77.998     2.704     0.200
    77.998     0.794     0.200
    77.998     0.915     0.200
    77.998     1.775     0.200
    77.998     3.880     0.200
    78.092     1.632     0.200
    78.096     1.237     0.200
    78.096     0.502     0.200
    78.121     1.381     0.200
    78.129     0.281     0.200
    78.360     0.133     0.200
    78.360    -0.006     0.200
    78.575     0.932     0.200
    78.763     0.387     0.200
    78.934     0.370     0.200
    79.582     0.330     0.200
    79.653     0.144     0.200
    79.761    -0.840     0.200
    79.866    -0.773     0.200
    80.101    -0.043     0.200
    80.176     1.175     0.200
    80.268     0.861     0.200
    80.597     0.536     0.200
    80.596     0.445     0.200
    80.596     0.256     0.200
    80.805     0.509     0.200
    80.805     0.073     0.200
    80.804     0.292     0.200
    80.834     0.777     0.200
    80.846     1.023     0.200
    80.846     2.132     0.200
    80.974     0.330     0.200
    81.238    -0.455     0.200
    81.238    -1.254     0.200
    81.238     0.026     0.200
    81.162     0.140     0.200
    81.433    -0.502     0.200
    81.433     0.271     0.200
    81.433    -0.010     0.200
    81.555     1.613     0.200
    81.731     0.568     0.200
    81.664     1.080     0.200
    81.982     1.280     0.200
    82.202     0.328     0.200
    82.242     0.262     0.200
    82.224     0.766     0.200
    82.716     1.126     0.200
    82.961    -1.418     0.200
    82.961    -1.643     0.200
    83.022     0.960     0.200
    83.030     0.617     0.200
    83.063     0.226     0.200
    83.079     1.825     0.200
    83.146     0.428     0.200
    83.329    -0.039     0.200
    83.381    -0.986     0.200
    83.296     0.695     0.200
    83.459     1.237     0.200
    83.459     0.728     0.200
    83.459     0.587     0.200
    83.459     0.913     0.200
    83.488     3.014     0.200
    83.488     0.506     0.200
    83.543     0.723     0.200
    83.672    -0.830     0.200
    83.726     1.076     0.200
    83.925    -0.877     0.200
    84.035     0.896     0.200
    84.035     0.226     0.200
    84.035    -0.264     0.200
    84.073     0.732     0.200
    84.285    -1.546     0.200
    84.901    -0.419     0.200
    84.793     0.223     0.200
    84.827     0.790     0.200
    84.827     0.261     0.200
    84.956    -0.294     0.200
    84.956    -1.948     0.200
    85.148     0.160     0.200
    85.165     0.755     0.200
    85.288     0.501     0.200
    85.880    -0.413     0.200
    86.042     1.744     0.200
    86.018     0.811     0.200
    86.065     1.970     0.200
    86.065     0.743     0.200
    86.302    -0.343     0.200
    86.504     0.067     0.200
    86.419     2.446     0.200
    86.596    -0.308     0.200
    86.525     0.706     0.200
    86.740     0.011     0.200
    86.857    -0.209     0.200
    87.182     0.726     0.200
    87.469     0.997     0.200
    87.602     0.230     0.200
    87.602    -0.311     0.200
    87.602    -0.022     0.200
    87.762    -0.060     0.200
    89.579     0.252     0.200
    89.579    -0.153     0.200
    89.579     0.273     0.200
    89.611     0.194     0.200
    89.630     0.458     0.200
    89.900     0.866     0.200
    89.900     0.625     0.200
    90.095     0.633     0.200
    90.095    -0.156     0.200
    90.095     0.235     0.200
    90.761     1.033     0.200
    91.211     1.543     0.200
    91.910     0.353     0.200
    93.200    -0.046     0.200
    93.376    -0.188     0.200
    93.282     0.181     0.200
    93.769    -0.223     0.200
    94.328    -0.050     0.200
    95.515     0.298     0.200
    96.207    -0.304     0.200
    96.386     1.215     0.200
    96.415     1.127     0.200
    96.660    -0.079     0.200
    96.660    -0.428     0.200
    96.732    -0.552     0.200
    96.735    -0.798     0.200
    96.948     0.141     0.200
    97.222    -0.204     0.200
    97.445    -0.569     0.200
    97.632    -0.048     0.200
    97.770    -1.101     0.200
    98.452     0.462     0.200
    14.695     4.771     0.200
    14.919     4.341     0.200
    15.774     3.540     0.200
    16.206     3.868     0.200
    16.707     3.584     0.200
    17.406    -0.072     0.200
    17.500     3.542     0.200
    17.976     0.925     0.200
    18.178     0.002     0.200
    18.414     1.246     0.200
    19.332     0.548     0.200
    19.399    -0.056     0.200
    19.399     0.202     0.200
    19.399     0.424     0.200
    19.399    -1.269     0.200
    19.575     1.259     0.200
    19.575     0.860     0.200
    19.575     0.159     0.200
    19.575     0.284     0.200
    19.575    -0.040     0.200
    19.575     1.261     0.200
    20.032     1.173     0.200
    20.032     0.461     0.200
    20.139     0.582     0.200
    20.139     0.394     0.200
    20.139     1.912     0.200
    20.500     0.193     0.200
    20.664     0.031     0.200
    20.834     1.154     0.200
    20.919     2.180     0.200
    21.105     0.190     0.200
    21.105    -0.113     0.200
    21.288     0.663     0.200
    21.266     1.569     0.200
    21.300     2.732     0.200
    21.893     2.776     0.200
    21.869     1.734     0.200
    21.869     1.275     0.200
    21.869     1.462     0.200
    21.908     1.401     0.200
    22.055     0.813     0.200
    22.063     3.308     0.200
    22.063     0.388     0.200
    22.061     0.671     0.200
    22.241     2.957     0.200
    22.323     1.231     0.200
    22.524     0.938     0.200
    22.714    -1.392     0.200
    22.782     1.464     0.200
    23.009     1.886     0.200
    23.027     0.515     0.200
    23.030     1.922     0.200
    23.030     1.643     0.200
    23.030     1.483     0.200
    23.030     1.684     0.200
    23.030     1.983     0.200
    23.094     0.253     0.200
    23.249     1.775     0.200
    23.319     2.086     0.200
    23.319     2.240     0.200
    23.319     0.961     0.200
    23.319     0.537     0.200
    23.326     0.160     0.200
    23.433    -0.081     0.200
    23.433     0.578     0.200
    23.433     0.138     0.200
    23.560     1.390     0.200
    23.579     0.950     0.200
    23.589     1.959     0.200
    23.689     2.006     0.200
    23.689     1.506     0.200
    23.689     1.855     0.200
    23.990     1.193     0.200
    24.006     0.946     0.200
    24.287     1.075     0.200
    24.637     1.105     0.200
    24.946     0.989     0.200
    25.123     0.927     0.200
    25.123     0.365     0.200
    25.123     0.765     0.200
    25.123     0.494     0.200
    25.197     0.387     0.200
    25.197     1.518     0.200
    25.233     2.457     0.200
    25.342     2.772     0.200
    25.446     1.327     0.200
    25.446     1.045     0.200
    25.488     0.736     0.200
    26.005     0.375     0.200
    26.298    -0.319     0.200
    26.534     1.416     0.200
    26.796    -0.084     0.200
    26.961     0.575     0.200
    26.967    -0.261     0.200
    26.953     1.043     0.200
    26.953     0.201     0.200
    26.953     1.750     0.200
    27.448     1.331     0.200
    27.448     0.550     0.200
    27.547    -0.259     0.200
    27.669     1.300     0.200
    27.765     1.369     0.200
    27.765     2.010     0.200
    27.831     2.162     0.200
    27.931     2.406     0.200
    28.097     1.941     0.200
    28.185     0.566     0.200
    28.228     0.422     0.200
    28.298     1.155     0.200
    28.372     1.873     0.200
    28.543     0.675     0.200
    28.568     0.650     0.200
    28.586     1.070     0.200
    28.586     1.224     0.200
    28.586     0.695     0.200
    28.593     1.125     0.200
    28.596     0.699     0.200
    28.643     0.687     0.200
    28.650     0.720     0.200
    28.667     0.674     0.200
    28.686     0.703     0.200
    28.721     0.690     0.200
    28.727     2.088     0.200
    28.888     1.530     0.200
    28.863     2.806     0.200
    28.863     0.825     0.200
    28.867     3.094     0.200
    28.877     1.511     0.200
    28.914     2.440     0.200
    28.914     2.474     0.200
    28.914     3.005     0.200
    29.088     4.013     0.200
    29.208     0.851     0.200
    29.202     0.418     0.200
    29.265     1.765     0.200
    29.265     1.556     0.200
    29.342     3.721     0.200
    29.342     2.821     0.200
    29.342     4.032     0.200
    29.465     0.356     0.200
    29.594    -0.119     0.200
    29.802     2.522     0.200
    29.915     1.697     0.200
    29.957     2.229     0.200
    30.226     0.961     0.200
    30.226     0.537     0.200
    30.221     2.494     0.200
    30.238     2.183     0.200
    30.238     1.475     0.200
    30.312     0.885     0.200
    30.436     2.693     0.200
    30.735     1.852     0.200
    30.852     1.530     0.200
    30.852     1.731     0.200
    30.929     0.027     0.200
    31.039     2.372     0.200
    31.117     1.378     0.200
    31.242     1.404     0.200
    31.242    -0.467     0.200
    31.214     1.660     0.200
    31.226     1.287     0.200
    31.259     1.333     0.200
    31.374     2.789     0.200
    31.401     3.068     0.200
    31.472     2.330     0.200
    31.474     0.501     0.200
    31.507     2.743     0.200
    31.507     2.403     0.200
    31.602     0.917     0.200
    31.621     1.778     0.200
    31.638     0.891     0.200
    31.746     1.252     0.200
    31.759     1.596     0.200
    31.759     1.926     0.200
    31.943     0.559     0.200
    31.943    -0.027     0.200
    32.089     1.650     0.200
    32.176     1.988     0.200
    32.286     0.614     0.200
    32.237     2.306     0.200
    32.278     1.359     0.200
    32.310    -0.503     0.200
    32.341     0.515     0.200
    32.374     1.824     0.200
    32.374     1.375     0.200
    32.374     2.523     0.200
    32.413     2.463     0.200
    32.412     2.897     0.200
    32.479    -0.464     0.200
    33.027     0.911     0.200
    32.973     2.048     0.200
    33.223    -0.438     0.200
    33.298     0.438     0.200
    33.341     1.819     0.200
    33.341     1.270     0.200
    33.341     0.569     0.200
    33.432     1.244     0.200
    33.499     2.117     0.200
    33.525    -0.139     0.200
    33.525     0.210     0.200
    33.672    -0.246     0.200
    33.672    -0.068     0.200
    33.694    -0.368     0.200
    33.810     2.386     0.200
    33.810     1.457     0.200
    33.810     2.677     0.200
    33.947     0.592     0.200
    33.960     0.463     0.200
    33.960     1.143     0.200
    34.042     2.964     0.200
    34.134     1.442     0.200
    34.267     3.311     0.200
    34.318     2.770     0.200
    34.318     1.568     0.200
    34.318     0.568     0.200
    34.318     2.520     0.200
    34.343     0.814     0.200
    34.492     1.495     0.200
    34.492     1.639     0.200
    34.604     2.097     0.200
    34.770     0.352     0.200
    34.855     2.240     0.200
    34.861     1.484     0.200
    35.058     1.874     0.200
    35.207    -0.112     0.200
    35.156     0.987     0.200
    35.156     1.327     0.200
    35.221     1.390     0.200
    35.223     1.509     0.200
    35.320     1.808     0.200
    35.361     2.020     0.200
    35.361     1.859     0.200
    35.399     2.564     0.200
    35.463    -0.057     0.200
    35.463     0.632     0.200
    35.470     0.325     0.200
    35.477     0.269     0.200
    35.458     1.689     0.200
    35.458     1.259     0.200
    35.480     3.389     0.200
    35.519     2.005     0.200
    35.602     1.841     0.200
    35.602     2.290     0.200
    35.602     1.489     0.200
    35.604     2.082     0.200
    35.604     1.871     0.200
    35.799     2.291     0.200
    35.799     1.072     0.200
    35.897    -0.076     0.200
    35.907     1.898     0.200
    35.907     1.221     0.200
    35.907     1.670     0.200
    35.972     0.074     0.200
    35.972     0.408     0.200
    36.017    -0.368     0.200
    36.023     1.498     0.200
    36.130     2.151     0.200
    36.155     1.708     0.200
    36.155     1.536     0.200
    36.160     1.532     0.200
    36.201     1.445     0.200
    36.257     1.534     0.200
    36.415     0.375     0.200
    36.415     0.240     0.200
    36.419     0.258     0.200
    36.382     1.893     0.200
    36.446     0.663     0.200
    36.450     0.445     0.200
    36.460     2.402     0.200
    36.460     1.592     0.200
    36.460     2.041     0.200
    36.510     1.585     0.200
    36.609     0.141     0.200
    36.609    -0.131     0.200
    36.609     0.289     0.200
    36.548     1.903     0.200
    36.548     1.663     0.200
    36.556     2.944     0.200
    36.556     2.724     0.200
    36.624    -0.553     0.200
    36.642    -0.609     0.200
    36.603     0.951     0.200
    36.654     1.782     0.200
    36.662     2.021     0.200
    36.678     2.824     0.200
    36.690     1.135     0.200
    36.693     1.662     0.200
    36.697     1.806     0.200
    36.697     1.075     0.200
    36.697     1.923     0.200
    36.716     1.206     0.200
    36.716     0.956     0.200
    36.747     1.319     0.200
    36.747     1.168     0.200
    36.800     0.348     0.200
    36.834     1.516     0.200
    36.853     1.961     0.200
    36.972     1.224     0.200
    36.972     1.523     0.200
    37.009     1.752     0.200
    37.305     0.866     0.200
    37.338     1.455     0.200
    37.338     1.662     0.200
    37.342     1.783     0.200
    37.345     1.821     0.200
    37.540     0.663     0.200
    37.540     0.473     0.200
    37.540     0.862     0.200
    37.540     1.262     0.200
    37.549     1.040     0.200
    37.555     1.236     0.200
    37.577     1.482     0.200
    37.595     0.036     0.200
    37.606     1.302     0.200
    37.632     2.306     0.200
    37.730     1.631     0.200
    37.794     1.282     0.200
    37.878     1.033     0.200
    37.927     1.623     0.200
    37.942     0.722     0.200
    37.951     0.832     0.200
    37.961     1.189     0.200
    37.965     1.895     0.200
    37.991     1.165     0.200
    37.991     1.063     0.200
    37.993     1.486     0.200
    37.999     1.358     0.200
    38.008     1.400     0.200
    38.008     0.822     0.200
    38.008     0.875     0.200
    38.017     1.371     0.200
    38.017     0.929     0.200
    38.029    -0.356     0.200
    38.053     1.641     0.200
    38.054     1.134     0.200
    38.108     1.421     0.200
    38.108     1.210     0.200
    38.108     0.460     0.200
    38.151     0.353     0.200
    38.177     1.629     0.200
    38.176     1.814     0.200
    38.222     1.668     0.200
    38.239     1.644     0.200
    38.294     1.854     0.200
    38.294     2.364     0.200
    38.294     0.932     0.200
    38.294     0.793     0.200
    38.335     1.527     0.200
    38.335     0.531     0.200
    38.415     1.003     0.200
    38.466     1.081     0.200
    38.548     0.553     0.200
    38.564     1.322     0.200
    38.564     1.063     0.200
    38.568     1.764     0.200
    38.597     1.660     0.200
    38.637     1.439     0.200
    38.666     1.834     0.200
    38.666     1.319     0.200
    38.722     2.091     0.200
    38.744     1.273     0.200
    38.796     0.916     0.200
    38.796     0.775     0.200
    38.919     2.061     0.200
    38.924     1.978     0.200
    38.941     0.623     0.200
    38.941     0.049     0.200
    39.031     0.924     0.200
    39.042     1.620     0.200
    39.135     0.351     0.200
    39.135    -0.309     0.200
    39.081     1.008     0.200
    39.120     2.861     0.200
    39.124     0.367     0.200
    38.971     2.419     0.200
    38.971     2.067     0.200
    39.264     0.726     0.200
    39.279     1.535     0.200
    39.343     1.035     0.200
    39.349     0.683     0.200
    39.353     1.452     0.200
    39.366     1.562     0.200
    39.381     2.324     0.200
    39.384     0.348     0.200
    39.406     1.806     0.200
    39.405     1.733     0.200
    39.424     2.178     0.200
    39.445     1.572     0.200
    39.452     0.938     0.200
    39.452     1.908     0.200
    39.481     2.124     0.200
    39.544     1.236     0.200
    39.594     1.033     0.200
    39.617     2.742     0.200
    39.635     0.614     0.200
    39.676     2.153     0.200
    39.681     1.298     0.200
    39.706     0.268     0.200
    39.769     1.041     0.200
    39.783     1.555     0.200
    39.863     1.505     0.200
    39.863     0.888     0.200
    39.887     1.423     0.200
    39.937     0.598     0.200
    39.965     0.473     0.200
    40.004     1.087     0.200
    40.004     1.417     0.200
    40.004     1.558     0.200
    40.004     1.237     0.200
    40.050     1.361     0.200
    40.097     1.216     0.200
    40.097     0.964     0.200
    40.092     0.919     0.200
    40.189     1.334     0.200
    40.189     0.381     0.200
    40.248     1.304     0.200
    40.248     0.964     0.200
    40.248     0.814     0.200
    40.248     1.253     0.200
    40.256     0.999     0.200
    40.278     0.615     0.200
    40.281     0.980     0.200
    40.294     1.357     0.200
    40.294     1.107     0.200
    40.350     1.831     0.200
    40.378     0.425     0.200
    40.378     0.685     0.200
    40.438     1.191     0.200
    40.539     0.676     0.200
    40.539     0.814     0.200
    40.542     1.312     0.200
    40.553     0.262     0.200
    40.574     0.476     0.200
    40.581     1.556     0.200
    40.581     1.966     0.200
    40.592     2.054     0.200
    40.845     2.280     0.200
    40.931     0.538     0.200
    40.931     0.809     0.200
    40.931     2.126     0.200
    40.951     0.672     0.200
    40.983     1.309     0.200
    40.983     0.648     0.200
    40.983     0.877     0.200
    41.030     0.463     0.200
    41.090    -0.145     0.200
    41.090     0.855     0.200
    41.171     0.209     0.200
    41.171    -0.099     0.200
    41.256     2.042     0.200
    41.268     1.148     0.200
    41.288     0.680     0.200
    41.330     0.933     0.200
    41.362     0.716     0.200
    41.412     1.998     0.200
    41.443     1.495     0.200
    41.467     0.319     0.200
    41.475     1.138     0.200
    41.485     2.246     0.200
    41.494     1.072     0.200
    41.513     0.671     0.200
    41.504     1.096     0.200
    41.525     0.436     0.200
    41.525    -0.465     0.200
    41.525     0.936     0.200
    41.525     0.660     0.200
    41.533     1.557     0.200
    41.547     0.513     0.200
    41.562     0.625     0.200
    41.563     0.505     0.200
    41.563     0.896     0.200
    41.563     0.380     0.200
    41.587     0.978     0.200
    41.587     1.369     0.200
    41.677     1.433     0.200
    41.698     0.899     0.200
    41.698     1.030     0.200
    41.737     1.398     0.200
    41.839    -0.185     0.200
    41.812     1.073     0.200
    41.916    -0.411     0.200
    41.956     0.765     0.200
    41.961     0.269     0.200
    41.991     1.861     0.200
    41.991     0.889     0.200
    42.045     3.340     0.200
    42.151     1.106     0.200
    42.183     1.026     0.200
    42.214     1.032     0.200
    42.242     0.629     0.200
    42.278     2.380     0.200
    42.260     1.878     0.200
    42.260     0.671     0.200
    42.284     0.771     0.200
    42.335     1.613     0.200
    42.336     0.585     0.200
    42.348     0.917     0.200
    42.348     1.139     0.200
    42.348     0.807     0.200
    42.348     1.327     0.200
    42.352     0.217     0.200
    42.367     2.046     0.200
    42.367     1.394     0.200
    42.368     1.161     0.200
    42.434     1.465     0.200
    42.434     0.209     0.200
    42.434     0.769     0.200
    42.389     0.911     0.200
    42.425     1.012     0.200
    42.449     1.176     0.200
    42.513     0.837     0.200
    42.533     1.449     0.200
    42.533     0.599     0.200
    42.533     2.474     0.200
    42.533     1.998     0.200
    42.574     0.103     0.200
    42.537     0.696     0.200
    42.549     0.963     0.200
    42.567     2.144     0.200
    42.578     1.019     0.200
    42.600     0.865     0.200
    42.616     1.406     0.200
    42.729     1.102     0.200
    42.784     1.055     0.200
    42.872     0.941     0.200
    42.922     1.067     0.200
    42.841     1.598     0.200
    42.885     0.948     0.200
    42.928     1.782     0.200
    42.968     2.170     0.200
    42.968     1.650     0.200
    42.968     1.434     0.200
    43.061    -0.050     0.200
    43.082     1.165     0.200
    43.082     1.014     0.200
    43.049     1.919     0.200
    43.051     1.185     0.200
    43.095     1.669     0.200
    43.273     1.249     0.200
    43.353     0.300     0.200
    43.476    -0.127     0.200
    43.486     2.087     0.200
    43.489     2.243     0.200
    43.554     1.835     0.200
    43.600     1.281     0.200
    43.846     1.916     0.200
    43.879     1.608     0.200
    43.970     0.385     0.200
    43.930     1.353     0.200
    43.963     1.803     0.200
    44.051     0.820     0.200
    44.203     1.514     0.200
    44.288     1.311     0.200
    44.336     0.526     0.200
    44.346     2.124     0.200
    44.346     0.352     0.200
    44.346     1.573     0.200
    44.375     0.789     0.200
    44.375     0.650     0.200
    44.424     1.227     0.200
    44.426     1.161     0.200
    44.503     1.620     0.200
    44.632     0.616     0.200
    44.892    -0.341     0.200
    44.964     0.135     0.200
    45.170     1.419     0.200
    45.484     0.460     0.200
    45.484    -0.249     0.200
    45.616     1.108     0.200
    45.616     1.239     0.200
    45.616     0.928     0.200
    45.616    -0.332     0.200
    45.992    -0.055     0.200
    45.990    -0.120     0.200
    46.315     0.831     0.200
    46.348     1.030     0.200
    46.695     0.719     0.200
    46.851    -1.550     0.200
    46.975    -0.797     0.200
    46.975    -1.043     0.200
    47.036     0.036     0.200
    47.036    -0.652     0.200
    46.991     1.691     0.200
    47.083     0.876     0.200
    47.102     0.987     0.200
    47.148     0.378     0.200
    47.148     1.756     0.200
    47.288     1.437     0.200
    47.403     0.469     0.200
    47.437     0.544     0.200
    47.522     0.685     0.200
    47.705     1.824     0.200
    47.705     0.668     0.200
    47.705     1.094     0.200
    47.731     0.663     0.200
    47.797     1.091     0.200
    47.809     0.268     0.200
    47.887     0.962     0.200
    48.056     0.370     0.200
    48.126     0.669     0.200
    48.242     0.458     0.200
    48.236     0.739     0.200
    48.274     0.944     0.200
    48.435     0.972     0.200
    48.457     0.634     0.200
    48.460     0.677     0.200
    48.471     1.280     0.200
    48.487     1.036     0.200
    48.487     1.138     0.200
    48.487     0.776     0.200
    48.495     0.390     0.200
    48.617     0.572     0.200
    48.642     0.561     0.200
    48.656     1.191     0.200
    48.656     0.541     0.200
    48.861     1.396     0.200
    48.861     1.247     0.200
    48.861     1.568     0.200
    48.905     0.519     0.200
    48.980     0.656     0.200
    49.085     1.086     0.200
    49.158     0.681     0.200
    49.203     1.046     0.200
    49.299     1.411     0.200
    49.299     1.122     0.200
    49.262     0.617     0.200
    49.267     1.007     0.200
    49.384     0.645     0.200
    49.747     0.603     0.200
    49.747    -0.006     0.200
    49.747     0.494     0.200
    49.747     0.324     0.200
    49.740     0.430     0.200
    50.052     1.477     0.200
    50.160     0.375     0.200
    50.165     0.785     0.200
    50.264     1.060     0.200
    50.264     0.790     0.200
    50.264     1.599     0.200
    50.242     0.891     0.200
    50.242     0.670     0.200
    50.278     0.560     0.200
    50.278     0.354     0.200
    50.376     0.869     0.200
    50.406     0.712     0.200
    50.523     0.777     0.200
    50.523     0.507     0.200
    50.916    -0.367     0.200
    50.916    -0.848     0.200
    50.879     0.831     0.200
    50.879     0.322     0.200
    50.967     1.281     0.200
    50.967     1.082     0.200
    51.470     0.197     0.200
    51.470    -0.014     0.200
    51.470     0.516     0.200
    51.567     1.260     0.200
    51.638     0.725     0.200
    51.668     0.702     0.200
    51.677     0.545     0.200
    51.678     0.601     0.200
    51.705     0.224     0.200
    51.698     1.277     0.200
    51.969     1.730     0.200
    51.982     1.998     0.200
    51.982    -0.244     0.200
    52.020     1.658     0.200
    52.020    -0.227     0.200
    52.000     0.619     0.200
    52.000     0.727     0.200
    52.148     0.326     0.200
    52.279     2.416     0.200
    52.278     1.055     0.200
    52.377     1.849     0.200
    52.371     0.282     0.200
    52.371     0.070     0.200
    52.361     0.840     0.200
    52.430     1.016     0.200
    52.444     0.029     0.200
    52.447     0.099     0.200
    52.430     0.731     0.200
    52.580     0.563     0.200
    52.910    -0.246     0.200
    53.064     0.951     0.200
    53.059     1.005     0.200
    53.226     1.642     0.200
    53.470     0.249     0.200
    53.473     0.042     0.200
    53.473    -0.067     0.200
    53.473     0.080     0.200
    53.473    -0.209     0.200
    53.485     0.242     0.200
    54.094     1.309     0.200
    54.094     0.889     0.200
    54.277     0.449     0.200
    54.289     2.641     0.200
    54.414     1.076     0.200
    54.411     0.872     0.200
    54.411     0.672     0.200
    54.495     1.327     0.200
    54.509     0.552     0.200
    54.509     0.310     0.200
    54.606     0.447     0.200
    54.606     0.177     0.200
    54.606     0.922     0.200
    54.620     1.122     0.200
    54.761     1.031     0.200
    54.871     0.823     0.200
    55.027     0.724     0.200
    55.095     2.778     0.200
    55.169    -0.419     0.200
    55.169     0.200     0.200
    55.181     0.401     0.200
    55.181     0.643     0.200
    55.410     0.538     0.200
    55.580     0.667     0.200
    55.728     0.539     0.200
    55.752     1.303     0.200
    55.752     1.053     0.200
    55.914     0.612     0.200
    56.105     0.761     0.200
    56.105     0.923     0.200
    56.242     1.602     0.200
    56.259     2.419     0.200
    56.416     0.543     0.200
    56.416     0.672     0.200
    56.416     0.832     0.200
    56.427     2.556     0.200
    56.427     2.841     0.200
    56.427    -0.251     0.200
    56.427     0.855     0.200
    56.508     1.370     0.200
    56.677     0.400     0.200
    56.677     0.027     0.200
    56.829     1.987     0.200
    57.218     0.612     0.200
    57.218     1.487     0.200
    58.188    -0.877     0.200
    58.188    -0.514     0.200
    58.305     1.243     0.200
    58.305     0.399     0.200
    58.547     1.408     0.200
    59.096    -0.007     0.200
    59.096     0.840     0.200
    59.096     0.707     0.200
    59.859     0.424     0.200
    59.859     0.723     0.200
    59.859     0.174     0.200
    59.987     1.758     0.200
    59.987     0.820     0.200
    59.987     1.480     0.200
    60.057     0.444     0.200
    60.057     0.159     0.200
    60.294     0.037     0.200
    60.294     1.115     0.200
    60.294     0.537     0.200
    60.325     1.328     0.200
    60.325     1.787     0.200
    60.325     1.608     0.200
    60.479    -0.077     0.200
    60.481    -0.238     0.200
    60.481     0.262     0.200
    60.516     0.121     0.200
    60.923     0.478     0.200
    61.910     0.270     0.200
    62.780     0.667     0.200
    62.780     1.197     0.200
    62.727     1.009     0.200
    62.901     0.749     0.200
    63.465     0.928     0.200
    63.465     0.819     0.200
    63.956     0.399     0.200
    63.956     0.119     0.200
    64.094     0.543     0.200
    64.094     0.033     0.200
    64.094    -0.346     0.200
    64.450    -0.110     0.200
    64.544     0.513     0.200
    64.600     0.607     0.200
    64.963     0.798     0.200
    65.562     0.763     0.200
    65.562     0.563     0.200
    66.351     0.918     0.200
    66.334     0.513     0.200
    66.334    -1.887     0.200
    66.334    -0.987     0.200
    66.334    -0.528     0.200
    66.347     0.435     0.200
    66.649     0.412     0.200
    66.649     0.171     0.200
    66.834    -0.489     0.200
    67.142    -0.017     0.200
    67.142    -0.193     0.200
    67.142    -0.423     0.200
    67.142    -0.532     0.200
    67.912     0.715     0.200
    68.139     0.828     0.200
    68.139    -0.066     0.200
    68.139     1.014     0.200
    68.498     1.027     0.200
    68.609     0.374     0.200
    68.609    -0.058     0.200
    68.609     1.044     0.200
    69.520    -0.687     0.200
    69.520    -0.138     0.200
    69.520    -0.337     0.200
    70.046    -0.572     0.200
    70.127    -0.371     0.200
    70.127    -0.269     0.200
    70.331    -0.149     0.200
    70.331     0.210     0.200
    71.052     1.185     0.200
    71.052     1.335     0.200
    71.052     1.644     0.200
    71.828    -0.379     0.200
    71.828    -0.498     0.200
    71.828    -0.748     0.200
    72.425     0.554     0.200
    72.425     0.203     0.200
    72.917     0.358     0.200
    73.150     0.726     0.200
    73.642     0.533     0.200
    74.389     1.582     0.200
    74.389     1.272     0.200
    75.551     0.820     0.200
    75.624     0.420     0.200
    75.624     0.006     0.200
    75.624    -0.283     0.200
    76.493     1.047     0.200
    76.703     0.770     0.200
    76.703     0.942     0.200
    77.053     0.825     0.200
    77.417     1.022     0.200
    78.096     0.970     0.200
    78.096     0.779     0.200
    78.203     0.777     0.200
    78.360    -0.531     0.200
    78.934     0.657     0.200
    79.582     0.683     0.200
    80.085    -0.018     0.200
    80.091     0.542     0.200
    80.177     1.008     0.200
    80.606     0.435     0.200
    80.606    -0.218     0.200
    80.606     0.782     0.200
    80.789     0.221     0.200
    80.789     0.042     0.200
    80.789    -0.298     0.200
    80.787    -0.142     0.200
    80.834     0.963     0.200
    80.974     0.714     0.200
    81.224    -0.981     0.200
    81.224    -0.415     0.200
    81.715    -0.167     0.200
    82.226     0.280     0.200
    82.947    -1.594     0.200
    83.150     0.362     0.200
    83.313    -0.404     0.200
    83.457     0.755     0.200
    83.488     2.002     0.200
    83.544     0.989     0.200
    84.036     0.120     0.200
    84.886    -0.728     0.200
    84.942    -1.647     0.200
    84.942    -2.741     0.200
    84.942    -1.051     0.200
    85.301     0.337     0.200
    85.866    -1.641     0.200
    86.066     1.925     0.200
    86.288    -0.789     0.200
    86.489     0.238     0.200
    86.582    -0.765     0.200
    86.726    -0.722     0.200
    87.183     0.276     0.200
    87.527    -0.315     0.200
    87.586    -0.199     0.200
    87.586    -0.371     0.200
    87.586    -0.395     0.200
    87.586    -0.709     0.200
    87.586    -1.670     0.200
    87.746    -0.367     0.200
    88.097     0.198     0.200
    89.563    -0.155     0.200
    89.563    -0.806     0.200
    89.563    -0.356     0.200
    89.563    -0.575     0.200
    89.596    -0.759     0.200
    89.906     0.460     0.200
    89.906     0.191     0.200
    89.906     0.890     0.200
    90.080    -0.237     0.200
    90.080    -0.823     0.200
    91.894    -0.053     0.200
    93.207    -0.936     0.200
    93.207     0.189     0.200
    93.360    -0.519     0.200
    93.754    -0.854     0.200
    95.041     1.057     0.200
    95.060     0.138     0.200
    17.209     2.410     0.200
    17.273     2.610     0.200
    17.509     3.675     0.200
    19.392     1.380     0.200
    19.396    -0.407     0.200
    19.396     1.452     0.200
    19.458    -0.116     0.200
    19.458    -0.516     0.200
    19.670     0.292     0.200
    19.635    -0.125     0.200
    19.635    -0.525     0.200
    19.635     0.075     0.200
    19.635    -0.316     0.200
    20.094     0.716     0.200
    20.201     1.285     0.200
    20.201     0.594     0.200
    20.201     0.795     0.200
    20.377     0.951     0.200
    20.518    -0.339     0.200
    20.784     1.437     0.200
    20.819     1.522     0.200
    20.912     1.251     0.200
    21.124    -1.323     0.200
    21.306    -0.161     0.200
    21.255     1.777     0.200
    21.488     0.085     0.200
    21.911     2.443     0.200
    21.963     1.495     0.200
    21.920     1.423     0.200
    21.920     0.644     0.200
    22.245     1.075     0.200
    22.542     1.721     0.200
    22.697    -0.289     0.200
    23.018     0.682     0.200
    23.021     2.089     0.200
    23.021     0.749     0.200
    23.021     2.451     0.200
    23.021     2.451     0.200
    23.021     2.089     0.200
    23.268     0.738     0.200
    23.284     0.474     0.200
    23.550     2.943     0.200
    25.225     0.053     0.200
    25.185     0.287     0.200
    25.185     0.363     0.200
    25.185    -0.023     0.200
    25.386     1.610     0.200
    25.386     2.258     0.200
    25.988     1.652     0.200
    26.928     3.116     0.200
    26.982     2.162     0.200
    26.982     0.828     0.200
    27.769     3.237     0.200
    28.558     0.625     0.200
    28.584     0.700     0.200
    28.601     0.653     0.200
    28.601     1.391     0.200
    28.601     0.641     0.200
    28.601    -0.058     0.200
    28.608     0.871     0.200
    28.608     0.580     0.200
    28.608     1.061     0.200
    28.612     0.647     0.200
    28.666     0.671     0.200
    28.702     0.650     0.200
    28.737     0.638     0.200
    29.215     0.686     0.200
    29.345     3.778     0.200
    29.345     2.407     0.200
    29.345     0.788     0.200
    30.241     1.798     0.200
    30.245     1.865     0.200
    30.483     2.361     0.200
    30.855     1.614     0.200
    31.765     2.179     0.200
    32.377     1.759     0.200
    32.377     1.639     0.200
    33.363     1.365     0.200
    33.363     0.564     0.200
    33.432     2.267     0.200
    33.685    -0.872     0.200
    33.784     3.687     0.200
    33.817     2.656     0.200
    33.990     2.183     0.200
    33.957     1.024     0.200
    33.957     0.595     0.200
    35.188     0.211     0.200
    35.520     1.295     0.200
    35.520     1.119     0.200
    35.526     0.032     0.200
    35.533     0.077     0.200
    35.964     0.879     0.200
    35.964     1.200     0.200
    36.266     2.552     0.200
    36.429     0.167     0.200
    36.433     0.063     0.200
    36.473     0.124     0.200
    36.477     0.446     0.200
    36.389     1.131     0.200
    36.623    -1.228     0.200
    36.623     0.041     0.200
    36.623     0.262     0.200
    36.471     2.879     0.200
    36.638    -0.181     0.200
    36.656    -0.136     0.200
    36.516     0.709     0.200
    36.682     1.999     0.200
    36.702     1.661     0.200
    36.702     0.151     0.200
    36.702     1.331     0.200
    36.709     1.685     0.200
    36.873     1.087     0.200
    37.013     1.281     0.200
    37.342     1.003     0.200
    37.347     1.386     0.200
    37.599     1.438     0.200
    37.599     0.666     0.200
    37.599     0.246     0.200
    37.599     2.147     0.200
    37.583     1.504     0.200
    37.583     0.998     0.200
    37.947     0.306     0.200
    37.964     0.373     0.200
    37.968     1.539     0.200
    37.970     1.190     0.200
    37.994     1.621     0.200
    37.999     1.401     0.200
    38.016     2.125     0.200
    38.016     1.367     0.200
    38.181     1.433     0.200
    38.260     1.816     0.200
    38.590     0.893     0.200
    38.637     1.500     0.200
    38.643     0.855     0.200
    38.748     0.887     0.200
    38.799     2.088     0.200
    38.863     1.544     0.200
    38.874     1.127     0.200
    39.143     0.253     0.200
    39.143     0.404     0.200
    38.985     2.326     0.200
    38.985     2.076     0.200
    39.278     0.424     0.200
    39.349     1.019     0.200
    39.390     1.323     0.200
    39.492     1.857     0.200
    39.640     0.886     0.200
    39.772     1.299     0.200
    39.969     0.681     0.200
    40.135     0.038     0.200
    40.046     0.334     0.200
    40.046     0.943     0.200
    40.089     1.176     0.200
    40.118     0.571     0.200
    40.289     0.416     0.200
    40.289     1.191     0.200
    40.544     0.666     0.200
    40.991     1.769     0.200
    40.991     0.408     0.200
    41.152     0.252     0.200
    41.152    -0.238     0.200
    41.174     0.339     0.200
    41.174    -0.092     0.200
    41.315     1.155     0.200
    41.357     0.507     0.200
    41.511     0.485     0.200
    41.521     0.651     0.200
    41.552     0.408     0.200
    41.552     0.658     0.200
    41.856    -0.450     0.200
    42.355     0.546     0.200
    42.520     1.668     0.200
    42.520     1.441     0.200
    42.520     0.502     0.200
    42.537     0.533     0.200
    42.729     1.122     0.200
    42.872     0.488     0.200
    43.021     0.888     0.200
    43.056     1.246     0.200
    43.274     0.861     0.200
    44.378     0.705     0.200
    44.378     0.475     0.200
    44.549     1.748     0.200
    45.556     0.235     0.200
    46.315     0.839     0.200
    46.693     1.031     0.200
    47.752     1.507     0.200
    48.238    -0.138     0.200
    48.457    -0.390     0.200
    48.478     1.469     0.200
    48.907     1.422     0.200
    49.261     1.001     0.200
    49.809     0.124     0.200
    49.809     0.022     0.200
    50.235     2.216     0.200
    50.235     1.235     0.200
    50.339     0.317     0.200
    51.634     0.453     0.200
    51.664     0.529     0.200
    51.673    -0.058     0.200
    51.675     0.451     0.200
    51.997     0.652     0.200
    52.205    -0.003     0.200
    52.479     0.395     0.200
    52.479     0.274     0.200
    52.493    -0.039     0.200
    52.497     0.032     0.200
    52.479     0.613     0.200
    52.575     0.534     0.200
    53.525     0.048     0.200
    53.528    -0.486     0.200
    54.093     1.292     0.200
    54.093     0.331     0.200
    54.454     0.518     0.200
    54.497     0.570     0.200
    54.497     0.798     0.200
    54.602     0.415     0.200
    56.406     0.219     0.200
    58.127    -1.076     0.200
    59.034     0.522     0.200
    59.034     0.791     0.200
    60.050    -0.590     0.200
    60.365     1.336     0.200
    60.532     0.196     0.200
    60.532    -0.271     0.200
    66.395    -0.819     0.200
    68.080     0.796     0.200
    68.547     0.327     0.200
    70.140     0.058     0.200
    71.766    -0.299     0.200
    74.448     0.229     0.200
    75.641     0.632     0.200
    75.641     0.132     0.200
    76.039     0.550     0.200
    76.515     0.896     0.200
    76.552     1.146     0.200
    76.760     0.473     0.200
    77.477     0.661     0.200
    77.531     0.889     0.200
    78.188     0.779     0.200
    78.419     0.253     0.200
    78.419     0.784     0.200
    78.640     0.765     0.200
    79.641     0.404     0.200
    80.085    -0.548     0.200
    80.085    -0.147     0.200
    80.385     0.744     0.200
    80.844     0.673     0.200
    83.203     0.213     0.200
    83.203     1.027     0.200
    83.518     0.588     0.200
    87.590    -0.471     0.200
    87.590    -0.641     0.200
    89.563     0.010     0.200
    89.563    -0.140     0.200
    89.563    -0.499     0.200
    89.596     0.057     0.200
    14.892     4.485     0.200
    15.071     4.749     0.200
    16.026     5.354     0.200
    16.211     2.423     0.200
    16.423     2.498     0.200
    16.752     3.785     0.200
    17.070     3.322     0.200
    17.441     2.021     0.200
    17.505     1.740     0.200
    17.805     2.189     0.200
    18.822    -0.131     0.200
    19.170     0.130     0.200
    19.374     1.461     0.200
    19.378    -0.433     0.200
    19.451     0.207     0.200
    19.451    -0.387     0.200
    19.451    -0.254     0.200
    19.627     0.330     0.200
    19.627    -0.068     0.200
    19.627     0.411     0.200
    19.627    -0.279     0.200
    19.627    -0.068     0.200
    19.685     0.599     0.200
    19.799    -1.144     0.200
    20.081     1.088     0.200
    20.081     1.783     0.200
    20.081     0.978     0.200
    20.188     0.737     0.200
    20.188    -0.044     0.200
    20.188     1.792     0.200
    20.188     1.215     0.200
    20.188     0.501     0.200
    20.210     0.817     0.200
    20.361     1.730     0.200
    20.476     2.286     0.200
    20.467     1.277     0.200
    20.524     0.718     0.200
    20.533    -0.331     0.200
    20.802     1.271     0.200
    20.893     2.005     0.200
    21.044     2.911     0.200
    21.075    -0.693     0.200
    21.139    -0.701     0.200
    21.139    -0.306     0.200
    21.238     1.896     0.200
    21.286     2.230     0.200
    21.322    -0.857     0.200
    21.481     0.232     0.200
    21.584     2.067     0.200
    21.809     2.243     0.200
    21.897     1.687     0.200
    21.897     1.569     0.200
    21.897     0.968     0.200
    21.897     0.767     0.200
    21.897     1.468     0.200
    21.897     1.788     0.200
    21.926     0.551     0.200
    21.960     1.281     0.200
    22.016     0.598     0.200
    22.022     2.384     0.200
    22.022     1.734     0.200
    22.064     0.685     0.200
    22.200     2.303     0.200
    22.223     1.280     0.200
    22.281     2.287     0.200
    22.281     1.726     0.200
    22.405     1.469     0.200
    22.464     2.613     0.200
    22.557    -0.778     0.200
    22.720    -1.019     0.200
    22.986     1.168     0.200
    23.000     0.537     0.200
    23.003     0.773     0.200
    23.003     1.335     0.200
    23.003     1.079     0.200
    23.003     1.213     0.200
    23.070     1.067     0.200
    23.250     2.956     0.200
    23.275     1.876     0.200
    23.275     2.075     0.200
    23.275     0.235     0.200
    23.283     1.046     0.200
    23.326     0.595     0.200
    23.397     1.131     0.200
    23.397     1.010     0.200
    23.397     0.350     0.200
    23.532     1.392     0.200
    23.533     1.502     0.200
    23.573     0.927     0.200
    23.580     0.862     0.200
    23.662     1.055     0.200
    23.662     1.172     0.200
    23.662     0.688     0.200
    23.662     1.412     0.200
    23.753     2.267     0.200
    24.025     1.264     0.200
    24.058     1.292     0.200
    24.203     0.479     0.200
    24.290     0.974     0.200
    24.497     1.122     0.200
    24.529     1.127     0.200
    24.604     0.611     0.200
    24.674     1.689     0.200
    25.172     1.664     0.200
    25.172     0.604     0.200
    25.172     0.549     0.200
    25.208     2.172     0.200
    25.237     0.528     0.200
    25.237     1.387     0.200
    25.362     1.509     0.200
    25.416     1.325     0.200
    25.416     1.193     0.200
    25.416     0.925     0.200
    25.461     0.281     0.200
    25.501     1.079     0.200
    25.972     0.940     0.200
    26.107     4.486     0.200
    26.143     1.360     0.200
    26.265    -0.207     0.200
    26.578     1.800     0.200
    26.572     1.460     0.200
    26.603     1.961     0.200
    26.711    -0.134     0.200
    26.843     1.607     0.200
    26.860     2.109     0.200
    26.903     2.369     0.200
    26.937     0.362     0.200
    26.958     1.596     0.200
    26.958     1.379     0.200
    26.958     1.774     0.200
    26.958     0.778     0.200
    26.958     1.274     0.200
    26.997     1.138     0.200
    27.154     2.068     0.200
    27.182     1.921     0.200
    27.174     2.399     0.200
    27.213     1.996     0.200
    27.273     2.371     0.200
    27.278     1.700     0.200
    27.279     1.789     0.200
    27.378     2.237     0.200
    27.429     1.753     0.200
    27.429     1.489     0.200
    27.429     0.640     0.200
    27.429     1.640     0.200
    27.455     0.107     0.200
    27.455    -0.092     0.200
    27.459     1.771     0.200
    27.455     0.307     0.200
    27.477     2.510     0.200
    27.477     2.311     0.200
    27.517     0.155     0.200
    27.517     0.575     0.200
    27.642     1.589     0.200
    27.642     1.364     0.200
    27.748     1.326     0.200
    27.811     1.984     0.200
    27.914     1.934     0.200
    27.911     0.491     0.200
    27.939     2.013     0.200
    27.985     1.762     0.200
    27.985     1.962     0.200
    28.059     0.366     0.200
    28.075     2.301     0.200
    28.083     3.891     0.200
    28.084     0.981     0.200
    28.148     2.370     0.200
    28.173     0.236     0.200
    28.190     2.265     0.200
    28.162     1.076     0.200
    28.214     2.322     0.200
    28.210     0.799     0.200
    28.223     1.355     0.200
    28.286     1.381     0.200
    28.265     0.857     0.200
    28.338     0.661     0.200
    28.349     2.061     0.200
    28.507     3.076     0.200
    28.535     0.659     0.200
    28.547     2.484     0.200
    28.561     0.736     0.200
    28.559     2.897     0.200
    28.518     2.014     0.200
    28.578     1.027     0.200
    28.578     0.908     0.200
    28.578     0.677     0.200
    28.578     1.177     0.200
    28.585     1.286     0.200
    28.585     0.926     0.200
    28.585     0.616     0.200
    28.589     0.681     0.200
    28.589     2.112     0.200
    28.602     3.243     0.200
    28.635     0.670     0.200
    28.636     2.364     0.200
    28.643     0.704     0.200
    28.638     1.446     0.200
    28.659     0.658     0.200
    28.671     2.141     0.200
    28.679     0.685     0.200
    28.694     0.554     0.200
    28.707     2.211     0.200
    28.714     0.674     0.200
    28.779     1.840     0.200
    28.773     2.373     0.200
    28.773     1.363     0.200
    28.773     2.633     0.200
    28.803     3.248     0.200
    28.831     2.778     0.200
    28.847     2.433     0.200
    28.847     0.593     0.200
    28.847     2.599     0.200
    28.849     3.073     0.200
    28.850     3.512     0.200
    28.851     2.833     0.200
    28.852     1.414     0.200
    28.897     2.441     0.200
    28.897     2.582     0.200
    28.905     0.391     0.200
    28.920     0.058     0.200
    28.987     2.993     0.200
    29.019     0.282     0.200
    29.059     1.507     0.200
    29.044     1.337     0.200
    29.070     3.671     0.200
    29.073     1.439     0.200
    29.085     1.523     0.200
    29.149     0.848     0.200
    29.149     0.598     0.200
    29.164     1.540     0.200
    29.193     0.718     0.200
    29.214     2.132     0.200
    29.272     1.416     0.200
    29.240     1.707     0.200
    29.237     0.746     0.200
    29.240     1.846     0.200
    29.240     1.314     0.200
    29.250     3.057     0.200
    29.245     0.953     0.200
    29.275     2.895     0.200
    29.292     1.940     0.200
    29.324     3.275     0.200
    29.324     2.173     0.200
    29.344     1.280     0.200
    29.344     2.280     0.200
    29.433     0.635     0.200
    29.433     0.341     0.200
    29.423     1.034     0.200
    29.483     1.434     0.200
    29.516     0.295     0.200
    29.562    -0.313     0.200
    29.562    -0.756     0.200
    29.584     3.212     0.200
    29.593    -0.233     0.200
    29.492     2.769     0.200
    29.604    -0.534     0.200
    29.657    -0.309     0.200
    29.762    -0.154     0.200
    29.785     2.194     0.200
    29.811     1.340     0.200
    29.869     2.021     0.200
    29.892     0.923     0.200
    29.892     1.724     0.200
    29.859     1.021     0.200
    29.872     2.571     0.200
    29.900     2.347     0.200
    29.925     3.125     0.200
    29.939     2.204     0.200
    29.955    -0.081     0.200
    29.988     1.765     0.200
    30.012     2.625     0.200
    30.004     0.593     0.200
    30.013     1.467     0.200
    30.023     1.993     0.200
    30.192    -0.418     0.200
    30.192    -0.145     0.200
    30.192    -0.309     0.200
    30.207     2.237     0.200
    30.203     1.105     0.200
    30.220     2.152     0.200
    30.220     2.394     0.200
    30.224     1.106     0.200
    30.230     2.105     0.200
    30.264     1.755     0.200
    30.307     2.449     0.200
    30.303     0.275     0.200
    30.319     0.216     0.200
    30.396     2.900     0.200
    30.404     1.015     0.200
    30.423     3.233     0.200
    30.426     0.888     0.200
    30.470     3.427     0.200
    30.486     2.167     0.200
    30.506     2.995     0.200
    30.506     1.440     0.200
    30.526    -1.136     0.200
    30.585     0.352     0.200
    30.608     1.987     0.200
    30.652     0.882     0.200
    30.670     1.108     0.200
    30.685     2.731     0.200
    30.682     0.649     0.200
    30.710     1.441     0.200
    30.710     1.791     0.200
    30.726     0.501     0.200
    30.729    -0.390     0.200
    30.775     1.015     0.200
    30.777     0.872     0.200
    30.813     0.730     0.200
    30.834     1.817     0.200
    30.834     1.545     0.200
    30.837    -0.093     0.200
    30.852     2.338     0.200
    30.895     0.563     0.200
    30.894     1.533     0.200
    30.892     1.022     0.200
    30.896     0.011     0.200
    30.896    -0.243     0.200
    30.917     1.973     0.200
    30.919    -0.234     0.200
    30.919    -0.466     0.200
    30.942    -0.614     0.200
    30.964     0.421     0.200
    30.969     0.705     0.200
    30.993     2.766     0.200
    31.016     2.189     0.200
    31.041    -0.255     0.200
    31.045     0.507     0.200
    31.054     0.577     0.200
    31.059     3.163     0.200
    31.093     1.706     0.200
    31.059    -0.171     0.200
    31.075     0.495     0.200
    31.075     0.791     0.200
    31.092     1.082     0.200
    31.128     2.898     0.200
    31.135     0.268     0.200
    31.147     2.033     0.200
    31.170     2.945     0.200
    31.194     1.398     0.200
    31.195     1.192     0.200
    31.193     0.422     0.200
    31.208     1.846     0.200
    31.234     1.079     0.200
    31.243     1.517     0.200
    31.256     0.189     0.200
    31.241     3.147     0.200
    31.241     1.313     0.200
    31.284    -0.404     0.200
    31.286    -1.153     0.200
    31.295     1.837     0.200
    31.313     2.063     0.200
    31.327    -0.184     0.200
    31.359     2.383     0.200
    31.359     3.184     0.200
    31.358    -0.858     0.200
    31.360    -0.484     0.200
    31.376     0.049     0.200
    31.384     2.813     0.200
    31.434     2.503     0.200
    31.451     1.991     0.200
    31.450    -0.785     0.200
    31.455     1.194     0.200
    31.476     2.136     0.200
    31.490     2.114     0.200
    31.490     2.606     0.200
    31.522     1.530     0.200
    31.532     0.186     0.200
    31.540    -1.598     0.200
    31.563    -0.929     0.200
    31.576     0.358     0.200
    31.576     0.183     0.200
    31.597    -1.161     0.200
    31.613     1.075     0.200
    31.620     1.388     0.200
    31.667    -1.090     0.200
    31.726     1.288     0.200
    31.743     2.264     0.200
    31.793     2.745     0.200
    31.795     0.178     0.200
    31.860    -0.265     0.200
    31.897    -0.939     0.200
    31.971    -1.168     0.200
    31.972    -0.200     0.200
    31.998     1.711     0.200
    31.974     0.785     0.200
    31.974    -0.431     0.200
    31.999    -1.019     0.200
    32.016     2.118     0.200
    32.034    -1.170     0.200
    32.072     3.103     0.200
    32.075     2.178     0.200
    32.103     3.087     0.200
    32.113    -0.423     0.200
    32.116     0.768     0.200
    32.138     1.660     0.200
    32.151    -1.098     0.200
    32.155     2.107     0.200
    32.225    -0.501     0.200
    32.267     1.816     0.200
    32.267     2.457     0.200
    32.279    -0.711     0.200
    32.286     1.993     0.200
    32.286     0.290     0.200
    32.286    -0.694     0.200
    32.286     3.765     0.200
    32.286     2.419     0.200
    32.320     1.384     0.200
    32.328     0.747     0.200
    32.356     1.940     0.200
    32.356     1.170     0.200
    32.354    -0.500     0.200
    32.378     2.768     0.200
    32.399     2.404     0.200
    32.406    -0.501     0.200
    32.429    -0.800     0.200
    32.448     0.011     0.200
    32.465    -1.324     0.200
    32.487     1.585     0.200
    32.487     1.956     0.200
    32.534    -1.840     0.200
    32.542    -1.483     0.200
    32.559     0.162     0.200
    32.643    -0.587     0.200
    32.661     0.754     0.200
    32.672     3.030     0.200
    32.714    -2.236     0.200
    32.960     2.135     0.200
    33.071    -1.717     0.200
    33.077    -1.193     0.200
    33.064     0.802     0.200
    33.086    -0.299     0.200
    33.088    -1.197     0.200
    33.106    -1.123     0.200
    33.108    -0.824     0.200
    33.156     1.503     0.200
    33.163    -1.196     0.200
    33.197    -2.022     0.200
    33.207    -1.564     0.200
    33.219    -0.945     0.200
    33.219    -0.666     0.200
    33.219    -1.304     0.200
    33.271    -0.063     0.200
    33.309     1.021     0.200
    33.326    -1.351     0.200
    33.339     1.490     0.200
    33.339     0.888     0.200
    33.299     1.126     0.200
    33.364    -0.602     0.200
    33.411     0.960     0.200
    33.467     2.811     0.200
    33.486     1.662     0.200
    33.486     2.421     0.200
    33.498    -0.250     0.200
    33.498    -0.109     0.200
    33.515     0.269     0.200
    33.667    -0.600     0.200
    33.667    -0.347     0.200
    33.702    -0.609     0.200
    33.702    -0.742     0.200
    33.762     3.326     0.200
    33.762     4.016     0.200
    33.796     2.820     0.200
    33.796     2.431     0.200
    33.796     1.210     0.200
    33.842     0.331     0.200
    33.854     2.016     0.200
    33.937     0.389     0.200
    33.937     0.569     0.200
    33.937     1.522     0.200
    33.995     2.270     0.200
    34.111     0.944     0.200
    34.090     1.761     0.200
    34.139     1.394     0.200
    34.146     1.882     0.200
    34.161     1.449     0.200
    34.254     2.439     0.200
    34.327     0.904     0.200
    34.370     2.379     0.200
    34.370     2.242     0.200
    34.370     1.093     0.200
    34.421     0.897     0.200
    34.454     1.707     0.200
    34.474     1.691     0.200
    34.474     1.922     0.200
    34.521     1.632     0.200
    34.537     2.292     0.200
    34.538     1.780     0.200
    34.602     1.616     0.200
    34.602     1.466     0.200
    34.656    -0.444     0.200
    34.773     1.150     0.200
    34.793     1.778     0.200
    34.818     1.856     0.200
    34.831     1.666     0.200
    34.840     2.367     0.200
    34.840     2.265     0.200
    34.842     1.957     0.200
    34.843     1.570     0.200
    34.878     1.245     0.200
    34.997     1.013     0.200
    35.035     0.813     0.200
    35.042     1.920     0.200
    35.070     1.784     0.200
    35.097    -0.548     0.200
    35.106     1.576     0.200
    35.110    -0.058     0.200
    35.164     1.326     0.200
    35.211     1.866     0.200
    35.226     1.107     0.200
    35.226     1.388     0.200
    35.251     0.822     0.200
    35.304     1.882     0.200
    35.349     2.084     0.200
    35.349     1.883     0.200
    35.386     2.587     0.200
    35.386     2.693     0.200
    35.438     1.782     0.200
    35.438     0.974     0.200
    35.438     2.196     0.200
    35.447     1.638     0.200
    35.454     1.780     0.200
    35.464     2.939     0.200
    35.505     2.241     0.200
    35.516     1.454     0.200
    35.516     1.036     0.200
    35.523     0.888     0.200
    35.529     0.833     0.200
    35.590     2.010     0.200
    35.590     2.209     0.200
    35.590     2.160     0.200
    35.644     1.642     0.200
    35.782     1.954     0.200
    35.782     0.973     0.200
    35.844     2.132     0.200
    35.850     1.074     0.200
    35.902     1.428     0.200
    35.947    -0.167     0.200
    35.947     0.313     0.200
    35.929    -0.467     0.200
    35.960     1.635     0.200
    35.960     2.106     0.200
    35.960     1.055     0.200
    35.996     1.095     0.200
    36.008     1.624     0.200
    36.039     1.586     0.200
    36.055     1.724     0.200
    36.119     2.056     0.200
    36.119     2.176     0.200
    36.142     1.853     0.200
    36.142     1.697     0.200
    36.143     1.756     0.200
    36.186     1.590     0.200
    36.244     1.763     0.200
    36.305     1.464     0.200
    36.367     1.782     0.200
    36.449     2.413     0.200
    36.449     1.564     0.200
    36.446     0.258     0.200
    36.446    -0.275     0.200
    36.446     0.460     0.200
    36.450     0.106     0.200
    36.495     1.712     0.200
    36.485     0.443     0.200
    36.490     0.595     0.200
    36.537     2.027     0.200
    36.537     2.718     0.200
    36.545     2.424     0.200
    36.545     2.133     0.200
    36.580     0.478     0.200
    36.651     2.529     0.200
    36.669     0.859     0.200
    36.667     2.343     0.200
    36.667     2.493     0.200
    36.640    -0.066     0.200
    36.640     0.567     0.200
    36.640     0.073     0.200
    36.664     1.230     0.200
    36.681     1.837     0.200
    36.681     1.436     0.200
    36.654     0.301     0.200
    36.690     1.284     0.200
    36.690     1.044     0.200
    36.672     0.146     0.200
    36.753     0.733     0.200
    36.753     0.532     0.200
    36.765     1.524     0.200
    36.765     1.124     0.200
    36.765     0.883     0.200
    36.818    -0.590     0.200
    36.839     2.088     0.200
    36.848     1.148     0.200
    36.958     1.612     0.200
    36.992     1.825     0.200
    37.168     0.449     0.200
    37.316     0.817     0.200
    37.320     1.885     0.200
    37.326     2.399     0.200
    37.327     1.956     0.200
    37.366     0.627     0.200
    37.525     1.745     0.200
    37.562     1.358     0.200
    37.562     1.511     0.200
    37.581     1.625     0.200
    37.581     0.086     0.200
    37.581     1.025     0.200
    37.583     0.195     0.200
    37.592     1.634     0.200
    37.620     1.952     0.200
    37.717     1.695     0.200
    37.717     1.474     0.200
    37.859     0.851     0.200
    37.928     0.593     0.200
    37.939     0.859     0.200
    37.944     1.706     0.200
    37.943     1.292     0.200
    37.949     1.657     0.200
    37.973     1.079     0.200
    37.978     1.358     0.200
    37.985     1.519     0.200
    37.994     0.321     0.200
    37.994     1.331     0.200
    37.994     1.532     0.200
    37.999     1.551     0.200
    37.999     0.970     0.200
    38.018    -0.140     0.200
    38.036     1.807     0.200
    38.037     1.275     0.200
    38.094     0.767     0.200
    38.094     1.386     0.200
    38.121     1.148     0.200
    38.114     1.719     0.200
    38.139     0.733     0.200
    38.147     0.247     0.200
    38.160     1.816     0.200
    38.160     1.536     0.200
    38.232     1.388     0.200
    38.236     1.782     0.200
    38.271     1.762     0.200
    38.271     1.879     0.200
    38.271     0.918     0.200
    38.271     1.445     0.200
    38.326     1.483     0.200
    38.326     1.282     0.200
    38.326     0.339     0.200
    38.384     0.758     0.200
    38.384     0.898     0.200
    38.444     0.600     0.200
    38.548     1.336     0.200
    38.548     1.197     0.200
    38.554     0.917     0.200
    38.554     0.116     0.200
    38.612     1.626     0.200
    38.596     0.666     0.200
    38.621     1.420     0.200
    38.656     1.684     0.200
    38.656     1.215     0.200
    38.656     1.465     0.200
    38.656     0.432     0.200
    38.714     1.558     0.200
    38.727     1.224     0.200
    38.843     1.520     0.200
    38.855     0.901     0.200
    38.907     2.145     0.200
    38.913     2.018     0.200
    38.936     1.974     0.200
    39.028     1.229     0.200
    39.028     0.600     0.200
    39.029     1.670     0.200
    39.059     0.711     0.200
    39.077     0.955     0.200
    39.107     2.087     0.200
    39.112     0.562     0.200
    39.162     0.182     0.200
    39.266     1.689     0.200
    39.002     2.401     0.200
    39.294     0.864     0.200
    39.294     0.524     0.200
    39.327     1.006     0.200
    39.331     0.724     0.200
    39.339     1.358     0.200
    39.353     1.647     0.200
    39.368     0.793     0.200
    39.368     1.807     0.200
    39.372     2.265     0.200
    39.392     1.254     0.200
    39.402     1.036     0.200
    39.413     2.079     0.200
    39.432     1.833     0.200
    39.438     1.266     0.200
    39.469     2.262     0.200
    39.530     1.184     0.200
    39.579     1.161     0.200
    39.544     0.971     0.200
    39.604     2.131     0.200
    39.610     1.791     0.200
    39.619     0.636     0.200
    39.650     1.945     0.200
    39.664     2.183     0.200
    39.664     0.914     0.200
    39.690     0.585     0.200
    39.699     1.385     0.200
    39.752     0.485     0.200
    39.767     0.914     0.200
    39.773     1.710     0.200
    39.853     1.502     0.200
    39.853     1.703     0.200
    39.853     0.670     0.200
    39.885     1.459     0.200
    39.885     2.214     0.200
    39.921     0.391     0.200
    39.948     0.773     0.200
    40.022     0.553     0.200
    40.022     1.303     0.200
    40.056     2.357     0.200
    40.065     1.236     0.200
    40.094     1.214     0.200
    40.133     0.841     0.200
    40.143     1.041     0.200
    40.143     0.830     0.200
    40.179     1.685     0.200
    40.179     0.404     0.200
    40.184     2.064     0.200
    40.265     1.395     0.200
    40.265     0.735     0.200
    40.265     1.334     0.200
    40.273     0.871     0.200
    40.279     0.730     0.200
    40.277     1.191     0.200
    40.321     1.065     0.200
    40.340     2.035     0.200
    40.353     0.561     0.200
    40.363     0.788     0.200
    40.363    -0.042     0.200
    40.490     1.073     0.200
    40.523     0.662     0.200
    40.523     0.863     0.200
    40.536     0.863     0.200
    40.558     1.143     0.200
    40.553     1.754     0.200
    40.573     0.707     0.200
    40.571     2.084     0.200
    40.578     2.124     0.200
    40.585     1.993     0.200
    40.836     2.008     0.200
    40.880     0.196     0.200
    40.914     0.801     0.200
    40.914     0.301     0.200
    40.919     1.622     0.200
    40.969     1.277     0.200
    40.969     0.746     0.200
    40.969     0.164     0.200
    40.969     1.512     0.200
    41.030     0.804     0.200
    41.033     2.042     0.200
    41.141     0.601     0.200
    41.141     0.271     0.200
    41.154     0.039     0.200
    41.185     2.531     0.200
    41.283     0.835     0.200
    41.291     0.682     0.200
    41.305     1.858     0.200
    41.333     0.723     0.200
    41.339     0.605     0.200
    41.452     0.386     0.200
    41.461     1.543     0.200
    41.473     2.186     0.200
    41.476     1.050     0.200
    41.480     2.286     0.200
    41.497     0.267     0.200
    41.491     0.725     0.200
    41.507     0.760     0.200
    41.522     0.241     0.200
    41.528     0.524     0.200
    41.528    -0.277     0.200
    41.528     0.723     0.200
    41.528     0.971     0.200
    41.531     0.650     0.200
    41.547     1.522     0.200
    41.547     0.737     0.200
    41.548     0.320     0.200
    41.548     0.478     0.200
    41.548     0.148     0.200
    41.548    -0.167     0.200
    41.548     0.978     0.200
    41.583     1.809     0.200
    41.583     1.270     0.200
    41.606    -1.314     0.200
    41.672     0.655     0.200
    41.672     0.814     0.200
    41.672     0.435     0.200
    41.692     1.576     0.200
    41.750     1.541     0.200
    41.817     1.142     0.200
    41.871    -0.210     0.200
    41.871    -0.392     0.200
    41.966     0.624     0.200
    41.961     0.273     0.200
    41.961     1.292     0.200
    41.951    -0.022     0.200
    41.982     1.798     0.200
    41.982     0.552     0.200
    42.038     1.598     0.200
    42.166     1.283     0.200
    42.194     1.141     0.200
    42.224     1.227     0.200
    42.241     1.479     0.200
    42.241     0.918     0.200
    42.249     1.695     0.200
    42.249     0.726     0.200
    42.291    -0.349     0.200
    42.320     0.505     0.200
    42.333     1.539     0.200
    42.333     0.639     0.200
    42.333     0.258     0.200
    42.333     0.940     0.200
    42.333     0.829     0.200
    42.335     0.949     0.200
    42.330     1.970     0.200
    42.355     2.152     0.200
    42.369     0.997     0.200
    42.379     1.154     0.200
    42.385     1.719     0.200
    42.383     1.309     0.200
    42.383     0.977     0.200
    42.383     0.655     0.200
    42.383     1.795     0.200
    42.435     1.115     0.200
    42.461     1.016     0.200
    42.492     0.856     0.200
    42.503     1.597     0.200
    42.503     0.454     0.200
    42.517     1.003     0.200
    42.559     0.913     0.200
    42.557     1.836     0.200
    42.573     0.706     0.200
    42.588     1.096     0.200
    42.613     0.891     0.200
    42.627     1.213     0.200
    42.601     0.191     0.200
    42.601    -0.001     0.200
    42.709     0.774     0.200
    42.709     0.484     0.200
    42.706    -0.392     0.200
    42.788     1.115     0.200
    42.851     0.966     0.200
    42.850     0.015     0.200
    42.890     0.791     0.200
    42.927     1.704     0.200
    42.955     2.305     0.200
    42.955     2.053     0.200
    42.955     1.034     0.200
    42.972     0.876     0.200
    42.892     2.096     0.200
    43.041    -0.020     0.200
    42.991     0.937     0.200
    43.037     2.093     0.200
    43.037     1.974     0.200
    43.035     1.323     0.200
    43.032     0.153     0.200
    43.032     0.684     0.200
    43.084     1.652     0.200
    43.032     0.510     0.200
    43.032     0.973     0.200
    43.032     1.424     0.200
    43.124     0.480     0.200
    43.271     1.610     0.200
    43.253     1.342     0.200
    43.364     0.558     0.200
    43.457    -0.324     0.200
    43.486     2.212     0.200
    43.489     2.184     0.200
    43.542     2.074     0.200
    43.605     1.247     0.200
    43.616     0.635     0.200
    43.690     0.549     0.200
    43.834     1.403     0.200
    43.859     0.729     0.200
    43.932     1.574     0.200
    43.951     1.782     0.200
    43.983     1.857     0.200
    44.030     0.916     0.200
    44.017    -0.076     0.200
    44.069     1.894     0.200
    44.082     1.554     0.200
    44.082     0.843     0.200
    44.082     1.064     0.200
    44.138     1.482     0.200
    44.205     1.615     0.200
    44.199     0.964     0.200
    44.263     1.776     0.200
    44.289     1.460     0.200
    44.357     0.589     0.200
    44.357     0.936     0.200
    44.357     0.356     0.200
    44.357     1.097     0.200
    44.389     1.221     0.200
    44.399     0.614     0.200
    44.399     1.924     0.200
    44.426     1.307     0.200
    44.428     1.309     0.200
    44.553    -0.182     0.200
    44.552     1.635     0.200
    44.594     1.243     0.200
    44.616     0.821     0.200
    44.616    -0.079     0.200
    44.703     0.533     0.200
    44.914    -0.309     0.200
    44.984     1.203     0.200
    45.015     1.545     0.200
    45.135    -0.511     0.200
    45.135     0.118     0.200
    45.194     2.322     0.200
    45.460     0.475     0.200
    45.460     0.104     0.200
    45.563     1.386     0.200
    45.563     0.902     0.200
    45.563     0.171     0.200
    45.563    -0.209     0.200
    45.563     1.220     0.200
    45.971     0.073     0.200
    45.971    -0.056     0.200
    45.971     0.333     0.200
    45.969     0.079     0.200
    46.111     1.064     0.200
    46.144     1.222     0.200
    46.295     0.870     0.200
    46.295     0.321     0.200
    46.339     0.649     0.200
    46.345    -0.273     0.200
    46.407     0.841     0.200
    46.441     0.272     0.200
    46.469     1.350     0.200
    46.578     0.416     0.200
    46.626    -0.278     0.200
    46.633     1.665     0.200
    46.673     1.038     0.200
    46.701     0.734     0.200
    46.867    -1.366     0.200
    46.884     1.446     0.200
    46.867    -1.822     0.200
    46.867    -1.515     0.200
    46.980     1.534     0.200
    46.989     0.678     0.200
    46.989     0.238     0.200
    47.056    -0.421     0.200
    47.056    -0.242     0.200
    47.056    -0.552     0.200
    47.127     0.122     0.200
    47.138     1.151     0.200
    47.124     0.901     0.200
    47.124    -0.427     0.200
    47.140     2.798     0.200
    47.170     1.921     0.200
    47.150     0.922     0.200
    47.279     0.830     0.200
    47.339     1.150     0.200
    47.380     0.728     0.200
    47.403     0.784     0.200
    47.411     0.990     0.200
    47.421     0.479     0.200
    47.513     0.491     0.200
    47.513     0.621     0.200
    47.632     0.697     0.200
    47.723     0.233     0.200
    47.728     1.791     0.200
    47.728     1.545     0.200
    47.790     1.147     0.200
    47.802     0.909     0.200
    47.852     0.962     0.200
    47.862     1.164     0.200
    47.897     0.443     0.200
    47.897     0.583     0.200
    48.010     0.837     0.200
    48.098     0.764     0.200
    48.114     0.363     0.200
    48.108     0.478     0.200
    48.121     1.043     0.200
    48.219     0.792     0.200
    48.233     0.922     0.200
    48.268     1.142     0.200
    48.408     0.571     0.200
    48.437     0.166     0.200
    48.454     0.828     0.200
    48.464     1.217     0.200
    48.464     0.989     0.200
    48.481     1.216     0.200
    48.481     0.886     0.200
    48.481     0.255     0.200
    48.481     0.685     0.200
    48.481     1.075     0.200
    48.486     0.907     0.200
    48.504     0.429     0.200
    48.608     0.533     0.200
    48.638     0.258     0.200
    48.648     1.233     0.200
    48.648     0.964     0.200
    48.769     0.484     0.200
    48.884     1.565     0.200
    48.884     0.426     0.200
    48.884     1.426     0.200
    48.889     0.956     0.200
    48.901     0.188     0.200
    48.931     0.844     0.200
    49.032     0.763     0.200
    49.155     0.805     0.200
    49.140    -0.059     0.200
    49.140    -0.233     0.200
    49.140     0.326     0.200
    49.252     0.915     0.200
    49.253     1.101     0.200
    49.255     0.952     0.200
    49.329     0.774     0.200
    49.347     1.153     0.200
    49.372     0.677     0.200
    49.452     0.887     0.200
    49.661     2.016     0.200
    49.661     1.565     0.200
    49.797     0.135     0.200
    49.797     0.242     0.200
    49.797     0.820     0.200
    50.003     0.753     0.200
    50.134     0.525     0.200
    50.134     0.376     0.200
    50.141     0.330     0.200
    50.160     0.834     0.200
    50.231     0.834     0.200
    50.231     0.664     0.200
    50.223     1.001     0.200
    50.223     1.132     0.200
    50.223     0.882     0.200
    50.223     1.581     0.200
    50.323     0.821     0.200
    50.323     0.596     0.200
    50.323     0.227     0.200
    50.357     0.941     0.200
    50.399    -0.240     0.200
    50.399    -0.449     0.200
    50.408     0.655     0.200
    50.515     0.943     0.200
    50.515     0.822     0.200
    50.528    -0.052     0.200
    50.668     0.480     0.200
    50.870     0.873     0.200
    50.870     0.594     0.200
    50.961     1.100     0.200
    50.961     0.109     0.200
    50.935    -0.025     0.200
    50.935    -0.216     0.200
    51.126     0.127     0.200
    51.482     0.450     0.200
    51.520     0.590     0.200
    51.520     0.373     0.200
    51.520     0.852     0.200
    51.559     1.425     0.200
    51.615     0.504     0.200
    51.645     0.481     0.200
    51.654     0.314     0.200
    51.655     0.553     0.200
    51.670     0.316     0.200
    51.689     1.148     0.200
    51.757     0.540     0.200
    51.977     0.702     0.200
    51.977     0.872     0.200
    51.995    -0.547     0.200
    51.988     1.201     0.200
    51.988     0.361     0.200
    52.013     1.815     0.200
    52.013     1.106     0.200
    52.027     0.841     0.200
    52.027     0.230     0.200
    52.064     1.755     0.200
    52.064     1.441     0.200
    52.064     0.251     0.200
    52.159     1.247     0.200
    52.200     0.659     0.200
    52.222     0.312     0.200
    52.222    -0.961     0.200
    52.226    -0.565     0.200
    52.271     0.116     0.200
    52.352    -0.688     0.200
    52.421     0.719     0.200
    52.421     0.061     0.200
    52.422     1.347     0.200
    52.480     0.290     0.200
    52.480     0.195     0.200
    52.480     0.759     0.200
    52.494     0.357     0.200
    52.498     0.428     0.200
    52.481     0.759     0.200
    52.556     0.660     0.200
    52.884    -0.212     0.200
    53.044     0.834     0.200
    53.044     0.975     0.200
    53.050     0.047     0.200
    53.050     1.086     0.200
    53.108     1.323     0.200
    53.522     0.471     0.200
    53.525     0.114     0.200
    53.525     0.504     0.200
    53.525    -0.117     0.200
    53.537     0.265     0.200
    54.073     1.411     0.200
    54.073     1.000     0.200
    54.073     1.635     0.200
    54.301     1.078     0.200
    54.331     0.017     0.200
    54.430     0.826     0.200
    54.430    -0.064     0.200
    54.430     0.977     0.200
    54.479     0.738     0.200
    54.480     0.266     0.200
    54.518     0.347     0.200
    54.583     0.619     0.200
    54.583     0.418     0.200
    54.610     0.755     0.200
    54.610     0.511     0.200
    54.610     0.130     0.200
    54.813     0.856     0.200
    54.888     1.516     0.200
    55.004     0.826     0.200
    55.157     0.659     0.200
    55.157     0.400     0.200
    55.126     0.364     0.200
    55.126     0.104     0.200
    55.126     0.243     0.200
    55.126     0.694     0.200
    55.126     2.563     0.200
    55.386     0.673     0.200
    55.556     0.600     0.200
    55.701     0.691     0.200
    55.764     1.856     0.200
    55.764     1.215     0.200
    55.733    -0.259     0.200
    55.783     0.680     0.200
    55.774     1.219     0.200
    55.774     1.323     0.200
    55.774     1.114     0.200
    55.774     0.294     0.200
    55.889     0.630     0.200
    55.889     0.300     0.200
    56.081    -0.534     0.200
    56.081     0.658     0.200
    56.081     0.517     0.200
    56.388     0.505     0.200
    56.388     0.845     0.200
    56.433     2.958     0.200
    56.433     2.714     0.200
    56.433     0.913     0.200
    56.433     1.413     0.200
    56.557     0.270     0.200
    56.557     0.729     0.200
    56.724     0.277     0.200
    56.724     0.035     0.200
    56.833     0.536     0.200
    57.188     0.737     0.200
    57.188     0.307     0.200
    57.188     1.188     0.200
    58.145    -0.583     0.200
    58.145    -0.862     0.200
    58.145    -0.972     0.200
    58.145    -0.733     0.200
    58.355     1.083     0.200
    58.355     1.290     0.200
    58.599     1.448     0.200
    59.045     0.148     0.200
    59.045     1.068     0.200
    59.045     0.837     0.200
    59.543     2.139     0.200
    59.702     1.356     0.200
    59.911     0.566     0.200
    59.911     0.027     0.200
    59.911    -0.315     0.200
    60.014     1.678     0.200
    60.014     0.858     0.200
    60.014     1.557     0.200
    60.038     1.096     0.200
    60.108     0.821     0.200
    60.108     0.130     0.200
    60.108     0.511     0.200
    60.185     0.144     0.200
    60.265    -0.612     0.200
    60.341     1.619     0.200
    60.341     1.769     0.200
    60.341     1.318     0.200
    60.344     0.093     0.200
    60.344     1.013     0.200
    60.344     0.343     0.200
    60.344     0.804     0.200
    60.530     0.469     0.200
    60.530     0.045     0.200
    60.530    -0.465     0.200
    60.532     0.480     0.200
    60.567     0.171     0.200
    60.802     1.573     0.200
    60.799     1.589     0.200
    60.975    -1.026     0.200
    60.975    -0.294     0.200
    60.975    -0.044     0.200
    61.963     0.420     0.200
    62.611     1.896     0.200
    62.737     0.856     0.200
    62.729     0.357     0.200
    62.729     1.008     0.200
    62.872     0.536     0.200
    63.511     0.594     0.200
    63.511     1.588     0.200
    63.511     0.774     0.200
    63.851     0.148     0.200
    63.909     0.668     0.200
    63.909     0.389     0.200
    63.909    -0.021     0.200
    63.909     1.168     0.200
    64.086     0.583     0.200
    64.086     1.073     0.200
    64.123     0.378     0.200
    64.123    -0.142     0.200
    64.399     0.178     0.200
    64.493     0.262     0.200
    64.617     1.114     0.200
    64.934     0.549     0.200
    65.577     0.435     0.200
    65.601     0.660     0.200
    65.642     0.713     0.200
    66.270     0.548     0.200
    66.299     1.118     0.200
    66.356    -2.015     0.200
    66.386     0.281     0.200
    66.386    -0.629     0.200
    66.386    -0.606     0.200
    66.398     0.305     0.200
    66.662     0.276     0.200
    66.662     0.026     0.200
    66.786    -1.105     0.200
    66.938    -0.049     0.200
    66.938    -0.524     0.200
    67.011    -2.358     0.200
    67.011    -2.020     0.200
    67.097    -0.081     0.200
    67.097     0.220     0.200
    67.097    -0.235     0.200
    67.201    -1.023     0.200
    67.201     0.661     0.200
    67.201    -0.509     0.200
    67.919     0.508     0.200
    67.987     1.578     0.200
    68.087     0.984     0.200
    68.087     0.609     0.200
    68.087     0.798     0.200
    68.257    -1.554     0.200
    68.447     0.774     0.200
    68.559     0.234     0.200
    68.559     0.359     0.200
    68.559     0.773     0.200
    68.559     0.564     0.200
    69.014     0.749     0.200
    69.014    -0.051     0.200
    69.043    -0.085     0.200
    69.553     0.579     0.200
    69.553    -0.380     0.200
    69.553    -0.241     0.200
    69.995    -1.802     0.200
    69.995    -1.411     0.200
    69.888     0.225     0.200
    70.157     0.212     0.200
    70.157    -0.609     0.200
    70.157    -1.085     0.200
    70.157    -0.257     0.200
    70.280     0.108     0.200
    70.280     0.899     0.200
    71.000     0.395     0.200
    71.000     1.241     0.200
    71.000     1.516     0.200
    71.778    -0.103     0.200
    71.778    -0.378     0.200
    71.778    -0.204     0.200
    71.778    -0.673     0.200
    71.900     0.755     0.200
    72.387     0.946     0.200
    72.387     0.516     0.200
    72.895     0.117     0.200
    72.979     0.236     0.200
    73.655    -0.261     0.200
    73.666    -0.557     0.200
    73.666    -0.862     0.200
    74.297     0.414     0.200
    74.297    -0.129     0.200
    74.429     1.774     0.200
    74.440     2.369     0.200
    74.752    -0.633     0.200
    74.752    -1.082     0.200
    74.752     0.347     0.200
    74.985    -0.011     0.200
    75.300     0.019     0.200
    75.607     0.734     0.200
    75.607     0.009     0.200
    75.607     0.289     0.200
    75.657     0.745     0.200
    75.657     0.376     0.200
    75.657    -0.335     0.200
    75.657    -0.175     0.200
    76.086     1.087     0.200
    76.566     0.389     0.200
    76.712     1.635     0.200
    76.739     0.971     0.200
    76.739     0.840     0.200
    76.739     0.471     0.200
    77.003     0.758     0.200
    77.003     0.531     0.200
    77.003    -0.119     0.200
    77.597     0.533     0.200
    77.597     1.107     0.200
    77.979     1.666     0.200
    77.979     0.730     0.200
    77.979     0.271     0.200
    77.992    -0.159     0.200
    78.092     1.291     0.200
    78.092     0.426     0.200
    78.137     1.092     0.200
    78.137     0.448     0.200
    78.400     0.089     0.200
    78.506     0.856     0.200
    78.531     0.594     0.200
    78.975     0.425     0.200
    79.062     0.495     0.200
    79.622     0.389     0.200
    79.694     0.609     0.200
    79.851    -0.366     0.200
    79.907    -0.338     0.200
    80.105    -0.053     0.200
    80.215     1.097     0.200
    80.381     0.486     0.200
    80.616     0.183     0.200
    80.616     0.853     0.200
    80.616     0.423     0.200
    80.637     0.618     0.200
    80.656    -0.014     0.200
    80.656    -0.123     0.200
    80.812     0.031     0.200
    80.812     0.220     0.200
    80.812    -0.229     0.200
    80.813     0.239     0.200
    80.813     0.114     0.200
    80.875     0.735     0.200
    80.887     1.912     0.200
    81.015     0.387     0.200
    81.270     0.475     0.200
    81.234    -0.506     0.200
    81.234    -1.227     0.200
    81.234    -0.278     0.200
    81.427    -1.154     0.200
    81.427    -1.490     0.200
    81.427    -0.269     0.200
    81.499     0.485     0.200
    81.500     1.430     0.200
    81.596     1.793     0.200
    81.741    -0.064     0.200
    82.023     1.416     0.200
    82.262     0.210     0.200
    82.262     0.475     0.200
    82.954    -1.408     0.200
    82.954    -2.024     0.200
    83.113     0.824     0.200
    83.158     0.439     0.200
    83.181     0.370     0.200
    83.181     0.418     0.200
    83.338    -0.114     0.200
    83.374    -1.081     0.200
    83.500     1.144     0.200
    83.500     0.853     0.200
    83.500     1.019     0.200
    83.528     2.459     0.200
    83.664    -0.767     0.200
    84.074     0.277     0.200
    84.278    -1.779     0.200
    84.948    -1.209     0.200
    84.948    -1.365     0.200
    85.302    -0.250     0.200
    85.875    -0.736     0.200
    86.033    -0.144     0.200
    86.443    -0.203     0.200
    86.458     1.641     0.200
    86.506     0.227     0.200
    86.591    -0.392     0.200
    86.591    -1.351     0.200
    86.738    -0.034     0.200
    87.610    -0.292     0.200
    87.609    -0.075     0.200
    87.609    -0.441     0.200
    87.769    -0.455     0.200
    88.133     0.556     0.200
    89.356     0.813     0.200
    89.584     0.288     0.200
    89.584    -0.312     0.200
    89.583    -0.413     0.200
    89.583    -0.182     0.200
    89.616    -0.265     0.200
    89.931     0.808     0.200
    89.931     0.513     0.200
    89.931    -0.047     0.200
    89.931     0.363     0.200
    90.093     0.557     0.200
    90.093    -0.344     0.200
    90.093    -0.004     0.200
    91.919     0.324     0.200
    91.919    -0.447     0.200
    91.919    -0.176     0.200
    93.228    -0.821     0.200
    93.379    -0.240     0.200
    93.770    -0.390     0.200
    94.136    -0.095     0.200
    94.534     0.328     0.200
    95.081     0.471     0.200
    95.473     0.031     0.200
    96.422     1.150     0.200
    96.434     0.629     0.200
    96.660    -0.644     0.200
    96.660    -1.728     0.200
    96.734     1.596     0.200
    96.747    -0.562     0.200
    96.747     1.151     0.200
    96.953    -0.021     0.200
    97.383     0.160     0.200
    97.481    -0.199     0.200
    98.717     0.497     0.200
    98.848    -0.372     0.200
    98.903    -0.093     0.200
    19.401     0.967     0.200
    19.689    -0.403     0.200
    20.129     0.205     0.200
    20.236    -0.782     0.200
    22.775    -0.850     0.200
    22.929     1.433     0.200
    22.929     1.959     0.200
    22.929     0.863     0.200
    25.221    -0.653     0.200
    26.187    -0.702     0.200
    36.716     1.064     0.200
    36.716     0.605     0.200
    40.244    -0.216     0.200
    41.193     0.863     0.200
    41.193     1.486     0.200
    41.486    -0.034     0.200
    46.604     0.834     0.200
    47.058     0.360     0.200
    51.585     0.236     0.200
    51.585    -0.094     0.200
    51.906    -0.087     0.200
    71.729    -0.234     0.200
    77.371    -1.859     0.200
    87.680     0.171     0.200
    89.652    -0.362     0.200
    14.253     5.592     0.200
    14.397     5.659     0.200
    14.422     7.191     0.200
    14.738     5.258     0.200
    14.738     4.922     0.200
    14.964     4.381     0.200
    16.820     4.071     0.200
    17.006     2.940     0.200
    18.433    -0.259     0.200
    18.890     0.191     0.200
    19.091    -0.487     0.200
    19.320    -0.439     0.200
    19.324    -0.298     0.200
    19.324     0.794     0.200
    19.365    -0.931     0.200
    19.365     0.425     0.200
    19.381     1.336     0.200
    19.541    -0.604     0.200
    19.541    -0.414     0.200
    19.541    -0.116     0.200
    19.541    -0.414     0.200
    19.541    -0.905     0.200
    19.541    -0.516     0.200
    19.605     0.594     0.200
    19.720    -0.567     0.200
    20.007     0.275     0.200
    20.007    -0.287     0.200
    20.007     0.601     0.200
    20.114     0.343     0.200
    20.114     0.468     0.200
    20.114    -0.183     0.200
    20.114     0.689     0.200
    20.452    -0.841     0.200
    20.440     1.311     0.200
    20.439     1.470     0.200
    20.637    -0.903     0.200
    20.842     1.934     0.200
    20.880     1.575     0.200
    20.880     0.764     0.200
    20.995    -0.913     0.200
    21.058    -0.421     0.200
    21.058    -0.860     0.200
    21.058    -1.899     0.200
    21.241    -0.875     0.200
    21.394     0.080     0.200
    21.312     1.872     0.200
    21.340     1.962     0.200
    21.644     2.545     0.200
    21.773     1.760     0.200
    21.845    -0.664     0.200
    21.868     1.728     0.200
    21.874     0.663     0.200
    21.874     0.003     0.200
    21.874     0.432     0.200
    21.874     0.833     0.200
    22.090     0.024     0.200
    22.103     2.230     0.200
    22.111     3.180     0.200
    22.111     1.451     0.200
    22.195     0.602     0.200
    22.289     3.150     0.200
    22.382     0.536     0.200
    22.371     2.975     0.200
    22.371     2.616     0.200
    22.477    -0.809     0.200
    22.608    -0.187     0.200
    22.679    -0.081     0.200
    22.828     3.329     0.200
    23.052     1.793     0.200
    23.072     0.794     0.200
    23.075     1.719     0.200
    23.075     0.932     0.200
    23.075     1.163     0.200
    23.075     1.362     0.200
    23.075     0.122     0.200
    23.201     0.527     0.200
    23.138     1.123     0.200
    23.356     0.699     0.200
    23.367     1.788     0.200
    23.367     1.038     0.200
    23.367     0.788     0.200
    23.461     1.173     0.200
    23.480     0.004     0.200
    23.480     0.683     0.200
    23.608     1.036     0.200
    23.606     0.720     0.200
    23.629     0.146     0.200
    23.734     1.793     0.200
    23.734     0.969     0.200
    23.734     2.697     0.200
    23.734     2.447     0.200
    23.820     3.155     0.200
    23.942     1.241     0.200
    23.973     0.997     0.200
    24.125     1.491     0.200
    24.316     0.871     0.200
    24.472     1.369     0.200
    24.629     1.814     0.200
    24.683     2.616     0.200
    25.098    -0.857     0.200
    25.098    -0.236     0.200
    25.098     0.051     0.200
    25.098    -0.099     0.200
    25.098    -0.769     0.200
    25.149     0.753     0.200
    25.149     0.390     0.200
    25.149     1.140     0.200
    25.278     2.913     0.200
    25.356     1.003     0.200
    25.447     1.685     0.200
    25.446     2.837     0.200
    25.452     0.895     0.200
    25.493     1.961     0.200
    25.493     0.955     0.200
    25.493     0.340     0.200
    25.493     1.320     0.200
    25.533     0.852     0.200
    26.027     4.257     0.200
    26.051     0.676     0.200
    26.345     0.563     0.200
    26.385     0.576     0.200
    26.487     1.912     0.200
    26.749     0.993     0.200
    26.788     2.759     0.200
    26.914     0.817     0.200
    26.922     1.933     0.200
    26.980     0.916     0.200
    26.980     1.057     0.200
    26.980     0.496     0.200
    26.980     1.525     0.200
    27.013     0.399     0.200
    27.137     3.277     0.200
    27.215     2.969     0.200
    27.275     3.012     0.200
    27.336     2.833     0.200
    27.490     0.859     0.200
    27.490     0.722     0.200
    27.490     0.962     0.200
    27.490     1.433     0.200
    27.490     2.232     0.200
    27.530     1.171     0.200
    27.535    -0.698     0.200
    27.535     0.626     0.200
    27.535     1.405     0.200
    27.540     2.284     0.200
    27.540     1.485     0.200
    27.594     1.482     0.200
    27.594    -0.249     0.200
    27.709     2.430     0.200
    27.714     1.720     0.200
    27.806     0.589     0.200
    27.806     2.699     0.200
    27.867     3.257     0.200
    27.875     2.844     0.200
    27.971     3.706     0.200
    27.997     3.693     0.200
    27.989     1.749     0.200
    28.137     0.649     0.200
    28.180     1.165     0.200
    28.141     3.047     0.200
    28.138     0.464     0.200
    28.282     1.767     0.200
    28.336     2.571     0.200
    28.414     0.688     0.200
    28.578     1.119     0.200
    28.603     1.094     0.200
    28.621     0.063     0.200
    28.621     0.438     0.200
    28.621     1.137     0.200
    28.621     0.538     0.200
    28.628     0.204     0.200
    28.628    -0.153     0.200
    28.628     1.076     0.200
    28.628     0.595     0.200
    28.628     0.876     0.200
    28.631     1.144     0.200
    28.653     2.131     0.200
    28.660     3.844     0.200
    28.678     1.129     0.200
    28.685     1.062     0.200
    28.702     1.119     0.200
    28.721     1.145     0.200
    28.711     2.940     0.200
    28.756     1.135     0.200
    28.841     1.362     0.200
    28.770     3.023     0.200
    28.768     0.516     0.200
    28.827     3.158     0.200
    28.861     4.359     0.200
    28.889     3.683     0.200
    28.856     3.160     0.200
    28.856     0.793     0.200
    28.856     2.228     0.200
    28.856     3.404     0.200
    28.904     1.651     0.200
    28.904     1.120     0.200
    28.904     3.020     0.200
    28.908     2.866     0.200
    28.908     3.882     0.200
    28.909     3.181     0.200
    28.922     1.380     0.200
    28.922     0.163     0.200
    28.955     2.870     0.200
    28.954     2.604     0.200
    28.981     0.347     0.200
    29.081     1.429     0.200
    29.161     0.720     0.200
    29.123     2.875     0.200
    29.129     3.853     0.200
    29.138     2.573     0.200
    29.218     3.876     0.200
    29.238     1.151     0.200
    29.230     1.879     0.200
    29.341     1.228     0.200
    29.307     2.538     0.200
    29.339     2.157     0.200
    29.310     1.528     0.200
    29.310     1.278     0.200
    29.310     0.698     0.200
    29.333     3.563     0.200
    29.382     2.362     0.200
    29.382     1.292     0.200
    29.382     3.173     0.200
    29.511     0.408     0.200
    29.614     0.530     0.200
    29.644     3.628     0.200
    29.641     0.712     0.200
    29.556     4.234     0.200
    29.842     2.673     0.200
    29.844     1.499     0.200
    29.938     1.954     0.200
    29.959     1.266     0.200
    29.933     3.202     0.200
    29.929     1.136     0.200
    30.083     0.535     0.200
    30.087     2.919     0.200
    30.277     1.649     0.200
    30.260     2.706     0.200
    30.277     0.444     0.200
    30.279     1.255     0.200
    30.279     2.513     0.200
    30.273     0.546     0.200
    30.273     0.374     0.200
    30.279     2.406     0.200
    30.391     1.544     0.200
    30.331    -0.444     0.200
    30.373     2.803     0.200
    30.384     0.582     0.200
    30.400     0.596     0.200
    30.497     0.102     0.200
    30.563     3.826     0.200
    30.575     0.731     0.200
    30.677     2.021     0.200
    30.738     2.527     0.200
    30.742     1.292     0.200
    30.779     1.408     0.200
    30.802     0.900     0.200
    30.809     0.368     0.200
    30.851     0.891     0.200
    30.928     1.541     0.200
    30.893     1.042     0.200
    30.893     2.665     0.200
    30.905     0.607     0.200
    30.918     3.289     0.200
    30.968    -2.349     0.200
    30.964     2.022     0.200
    30.967     1.872     0.200
    31.000     1.234     0.200
    31.000     0.812     0.200
    31.023     0.889     0.200
    31.039     2.325     0.200
    31.040     0.147     0.200
    31.082     2.244     0.200
    31.116     0.671     0.200
    31.161     2.546     0.200
    31.139     1.412     0.200
    31.148     1.273     0.200
    31.150     0.446     0.200
    31.162     1.270     0.200
    31.212     0.703     0.200
    31.212     0.921     0.200
    31.212    -0.229     0.200
    31.184     3.941     0.200
    31.208     2.432     0.200
    31.226     2.907     0.200
    31.210     0.146     0.200
    31.264     1.209     0.200
    31.302     1.207     0.200
    31.303     1.642     0.200
    31.330     0.892     0.200
    31.413     3.220     0.200
    31.402     0.143     0.200
    31.436    -0.310     0.200
    31.516     3.038     0.200
    31.515     2.224     0.200
    31.526    -0.163     0.200
    31.582     2.745     0.200
    31.606     0.364     0.200
    31.652     1.070     0.200
    31.647     0.967     0.200
    31.647    -0.383     0.200
    31.691     3.781     0.200
    31.799     1.300     0.200
    31.799     3.029     0.200
    31.896     0.402     0.200
    31.867     0.807     0.200
    31.974     0.203     0.200
    32.075     3.412     0.200
    32.128     1.643     0.200
    32.187    -0.022     0.200
    32.219     2.635     0.200
    32.257     0.262     0.200
    32.257    -0.103     0.200
    32.261     3.314     0.200
    32.278     3.031     0.200
    32.315     3.527     0.200
    32.356    -0.618     0.200
    32.356     0.046     0.200
    32.380     1.233     0.200
    32.415     1.028     0.200
    32.415     1.139     0.200
    32.415     1.919     0.200
    32.430    -0.326     0.200
    32.450     2.687     0.200
    32.450     3.316     0.200
    32.453     2.964     0.200
    32.503     2.226     0.200
    32.503     3.246     0.200
    32.482     0.865     0.200
    32.503     2.597     0.200
    32.542    -0.260     0.200
    32.632     0.790     0.200
    32.714    -0.995     0.200
    32.717    -0.036     0.200
    32.732     0.712     0.200
    32.979     0.683     0.200
    33.012     2.482     0.200
    33.138    -0.047     0.200
    33.146    -0.574     0.200
    33.160     0.101     0.200
    33.162     0.027     0.200
    33.181    -0.948     0.200
    33.181    -0.723     0.200
    33.256     0.009     0.200
    33.256     0.310     0.200
    33.273    -0.532     0.200
    33.372     1.242     0.200
    33.372     0.172     0.200
    33.344    -0.037     0.200
    33.439    -0.056     0.200
    33.474     0.390     0.200
    33.523     3.718     0.200
    33.538     2.764     0.200
    33.538     3.404     0.200
    33.626    -1.251     0.200
    33.626    -0.928     0.200
    33.570     0.455     0.200
    33.583     0.808     0.200
    33.812     2.568     0.200
    33.812     2.969     0.200
    33.900     2.075     0.200
    33.850     2.691     0.200
    33.850     1.451     0.200
    33.850     1.771     0.200
    33.897     2.483     0.200
    33.996     2.321     0.200
    34.011     1.558     0.200
    34.004     1.191     0.200
    34.004     1.310     0.200
    34.161     1.718     0.200
    34.283     1.984     0.200
    34.283     2.896     0.200
    34.283     0.906     0.200
    34.283    -0.073     0.200
    34.210     0.865     0.200
    34.224     2.642     0.200
    34.305     3.435     0.200
    34.383     1.365     0.200
    34.485     2.474     0.200
    34.533     2.287     0.200
    34.585     0.816     0.200
    34.635     1.894     0.200
    34.666     0.012     0.200
    34.791     0.231     0.200
    34.728    -0.750     0.200
    34.797     2.197     0.200
    34.887     1.586     0.200
    34.882     1.747     0.200
    34.895     2.415     0.200
    34.895     2.735     0.200
    34.902     0.814     0.200
    34.904     2.056     0.200
    35.022     0.242     0.200
    35.062     0.895     0.200
    35.159     0.356     0.200
    35.098     2.951     0.200
    35.180     0.435     0.200
    35.159    -0.542     0.200
    35.247     1.182     0.200
    35.261     2.178     0.200
    35.425     1.270     0.200
    35.425     0.549     0.200
    35.431     0.312     0.200
    35.438     0.356     0.200
    35.500     1.784     0.200
    35.500     0.774     0.200
    35.500     1.323     0.200
    35.500     3.223     0.200
    35.510     0.035     0.200
    35.516     0.684     0.200
    35.558     3.225     0.200
    35.640     1.510     0.200
    35.640     2.920     0.200
    35.705     0.759     0.200
    35.869     1.691     0.200
    35.869     1.556     0.200
    35.839     2.839     0.200
    35.839     0.878     0.200
    35.905     1.447     0.200
    35.965     0.436     0.200
    36.017     0.247     0.200
    36.017    -0.024     0.200
    36.063     1.093     0.200
    36.059    -0.007     0.200
    36.168     1.762     0.200
    36.194     2.495     0.200
    36.194     2.975     0.200
    36.241     1.784     0.200
    36.368    -0.264     0.200
    36.368    -0.040     0.200
    36.372    -0.282     0.200
    36.398     0.229     0.200
    36.402     0.951     0.200
    36.364     2.827     0.200
    36.421     1.775     0.200
    36.498     2.897     0.200
    36.498     1.557     0.200
    36.498     2.477     0.200
    36.563    -0.295     0.200
    36.563    -0.230     0.200
    36.563    -0.121     0.200
    36.577     0.197     0.200
    36.596     0.141     0.200
    36.549     2.451     0.200
    36.585     1.651     0.200
    36.585     2.972     0.200
    36.593     2.130     0.200
    36.593     3.062     0.200
    36.672     0.242     0.200
    36.647     0.772     0.200
    36.761     0.347     0.200
    36.761     0.640     0.200
    36.761    -0.331     0.200
    36.761     2.229     0.200
    36.737     0.929     0.200
    36.737     0.638     0.200
    36.737     1.691     0.200
    36.734     1.099     0.200
    36.773     1.802     0.200
    36.761     1.760     0.200
    36.761     0.430     0.200
    36.815    -0.728     0.200
    36.852     0.173     0.200
    36.892     1.641     0.200
    37.327     0.571     0.200
    37.378     0.985     0.200
    37.378     1.888     0.200
    37.383     1.659     0.200
    37.528     0.914     0.200
    37.528     0.045     0.200
    37.528     0.615     0.200
    37.528     1.414     0.200
    37.593     0.542     0.200
    37.617     0.764     0.200
    37.617     1.447     0.200
    37.632     1.053     0.200
    37.632     0.834     0.200
    37.670     1.191     0.200
    37.944     1.217     0.200
    37.919     1.339     0.200
    38.020     1.358     0.200
    37.974     0.429     0.200
    38.002     0.658     0.200
    37.995     0.648     0.200
    38.006     2.711     0.200
    38.032     0.742     0.200
    38.032     0.902     0.200
    38.033     1.613     0.200
    38.038     1.784     0.200
    38.047     2.652     0.200
    38.047     0.789     0.200
    38.047     2.078     0.200
    38.057     0.473     0.200
    38.066    -0.285     0.200
    38.094     1.093     0.200
    38.147     0.518     0.200
    38.147     1.390     0.200
    38.184     1.519     0.200
    38.216     1.019     0.200
    38.216     2.828     0.200
    38.274     1.456     0.200
    38.337     2.571     0.200
    38.337     2.123     0.200
    38.337     1.092     0.200
    38.371     1.390     0.200
    38.371     2.566     0.200
    38.501     0.200     0.200
    38.462     0.706     0.200
    38.509    -0.277     0.200
    38.606     1.621     0.200
    38.677     1.269     0.200
    38.703     2.579     0.200
    38.703     1.910     0.200
    38.758     1.893     0.200
    38.784     1.256     0.200
    38.836     0.378     0.200
    38.836     0.269     0.200
    38.907     1.453     0.200
    38.920     0.843     0.200
    38.957     2.110     0.200
    38.962     2.516     0.200
    39.090    -0.218     0.200
    39.090    -0.687     0.200
    39.063     0.179     0.200
    39.080     2.707     0.200
    38.924     2.103     0.200
    38.924     1.812     0.200
    39.218     0.455     0.200
    39.218     0.312     0.200
    39.158     1.238     0.200
    39.277    -0.203     0.200
    39.384     1.101     0.200
    39.390     0.525     0.200
    39.420     2.727     0.200
    39.438     0.147     0.200
    39.424     1.572     0.200
    39.445     1.716     0.200
    39.461     1.955     0.200
    39.490     2.099     0.200
    39.490     1.729     0.200
    39.518     1.737     0.200
    39.583     2.085     0.200
    39.657     2.181     0.200
    39.655     3.109     0.200
    39.687     3.229     0.200
    39.715     2.889     0.200
    39.715     3.186     0.200
    39.746     0.523     0.200
    39.801     0.182     0.200
    39.820     1.975     0.200
    39.816     0.877     0.200
    39.899     1.039     0.200
    40.050     0.673     0.200
    40.050     0.074     0.200
    40.050     1.724     0.200
    39.977     0.588     0.200
    40.020     0.512     0.200
    40.020     0.733     0.200
    40.020     0.993     0.200
    40.020     1.223     0.200
    40.005     0.857     0.200
    40.067     0.938     0.200
    40.121     0.951     0.200
    40.225     2.219     0.200
    40.225     2.447     0.200
    40.227     3.394     0.200
    40.264     0.885     0.200
    40.264     0.959     0.200
    40.264     0.724     0.200
    40.272     0.919     0.200
    40.312     1.095     0.200
    40.334     0.976     0.200
    40.386     1.323     0.200
    40.418     1.543     0.200
    40.418     0.591     0.200
    40.579    -0.160     0.200
    40.579     0.698     0.200
    40.644     0.959     0.200
    40.605     0.006     0.200
    40.621     3.065     0.200
    40.627     1.882     0.200
    40.627     2.989     0.200
    40.806    -0.034     0.200
    40.881     3.076     0.200
    40.972     0.749     0.200
    41.062    -0.183     0.200
    41.062    -0.328     0.200
    40.993     0.751     0.200
    41.022     0.603     0.200
    41.022     2.220     0.200
    41.077     3.329     0.200
    41.210     1.577     0.200
    41.212    -0.112     0.200
    41.212     0.057     0.200
    41.232     3.472     0.200
    41.285     0.757     0.200
    41.316     1.105     0.200
    41.359     1.055     0.200
    41.405    -0.835     0.200
    41.449     2.017     0.200
    41.521     0.531     0.200
    41.532     0.564     0.200
    41.523     3.202     0.200
    41.523     2.900     0.200
    41.553     0.361     0.200
    41.553    -0.238     0.200
    41.553     1.063     0.200
    41.553    -0.414     0.200
    41.588     0.266     0.200
    41.601     1.627     0.200
    41.602     0.945     0.200
    41.602     1.218     0.200
    41.602     0.740     0.200
    41.602     1.558     0.200
    41.619     1.496     0.200
    41.619     1.217     0.200
    41.792    -0.446     0.200
    41.792    -0.215     0.200
    41.742     0.489     0.200
    41.742     0.300     0.200
    41.869    -0.448     0.200
    41.990     2.483     0.200
    42.027     2.470     0.200
    42.027     2.718     0.200
    42.236     1.574     0.200
    42.290     1.835     0.200
    42.273    -0.129     0.200
    42.296     1.532     0.200
    42.376     0.246     0.200
    42.387     1.940     0.200
    42.387    -0.019     0.200
    42.387     0.852     0.200
    42.387     1.141     0.200
    42.392     0.282     0.200
    42.404     2.093     0.200
    42.528     0.134     0.200
    42.463     2.091     0.200
    42.463     1.303     0.200
    42.463     0.427     0.200
    42.463     3.128     0.200
    42.463     2.526     0.200
    42.463     2.315     0.200
    42.616    -0.116     0.200
    42.555    -0.222     0.200
    42.580     1.128     0.200
    42.580     1.503     0.200
    42.785     0.057     0.200
    42.771     0.245     0.200
    42.878     2.515     0.200
    42.878    -0.133     0.200
    42.798     2.306     0.200
    43.006     2.844     0.200
    43.006     1.305     0.200
    43.006     1.635     0.200
    43.006     3.235     0.200
    43.086     1.820     0.200
    43.086     1.490     0.200
    43.133     0.962     0.200
    43.110     0.843     0.200
    43.110     0.404     0.200
    43.110     1.214     0.200
    43.598     0.336     0.200
    43.592     1.472     0.200
    43.923     0.420     0.200
    43.884     2.237     0.200
    43.921     1.776     0.200
    44.032     2.197     0.200
    44.093     0.336     0.200
    44.130     2.196     0.200
    44.187     1.722     0.200
    44.299     2.131     0.200
    44.308     1.593     0.200
    44.308     0.740     0.200
    44.457     1.238     0.200
    44.417    -0.016     0.200
    44.417     0.164     0.200
    44.417     1.064     0.200
    44.417     0.805     0.200
    44.672     0.381     0.200
    44.850    -0.206     0.200
    44.850    -0.716     0.200
    45.050     0.107     0.200
    45.050    -0.082     0.200
    45.220    -0.612     0.200
    45.528    -0.114     0.200
    45.528     0.166     0.200
    45.650     0.856     0.200
    45.650     0.422     0.200
    45.650     0.582     0.200
    45.650     1.852     0.200
    46.021     0.719     0.200
    46.035    -0.447     0.200
    46.033    -0.470     0.200
    46.191     1.106     0.200
    46.357     0.326     0.200
    46.811    -1.481     0.200
    46.811    -1.352     0.200
    46.936     0.635     0.200
    46.936     0.875     0.200
    46.995    -0.576     0.200
    46.995    -0.770     0.200
    47.035     1.671     0.200
    47.035     0.154     0.200
    47.055     0.106     0.200
    47.028     1.418     0.200
    47.160     1.391     0.200
    47.244     1.432     0.200
    47.190     0.011     0.200
    47.433     0.844     0.200
    47.477     0.267     0.200
    47.558     1.031     0.200
    47.558     0.272     0.200
    47.674     0.446     0.200
    47.715     1.106     0.200
    47.820     1.678     0.200
    47.820     1.295     0.200
    47.820     0.125     0.200
    47.766     0.984     0.200
    47.766     0.523     0.200
    47.831     0.642     0.200
    47.843     0.535     0.200
    47.931     1.045     0.200
    48.160     0.937     0.200
    48.268     0.756     0.200
    48.285     0.238     0.200
    48.309     0.832     0.200
    48.467     0.771     0.200
    48.494     0.273     0.200
    48.505     1.931     0.200
    48.505     1.800     0.200
    48.499     0.315     0.200
    48.521     0.971     0.200
    48.521     1.821     0.200
    48.521     0.539     0.200
    48.521     1.369     0.200
    48.521     2.440     0.200
    48.521     2.199     0.200
    48.531     0.127     0.200
    48.551     1.399     0.200
    48.696     0.388     0.200
    48.674     0.557     0.200
    48.692     1.333     0.200
    48.871     1.015     0.200
    48.871    -0.006     0.200
    48.871     1.535     0.200
    48.871     1.343     0.200
    48.871     1.164     0.200
    48.939    -0.075     0.200
    48.938     0.382     0.200
    48.976     1.164     0.200
    49.166     0.580     0.200
    49.114     0.289     0.200
    49.119     0.963     0.200
    49.252     0.123     0.200
    49.190     0.809     0.200
    49.194     0.427     0.200
    49.298     0.626     0.200
    49.306     0.175     0.200
    49.421     0.533     0.200
    49.489     0.633     0.200
    49.720    -0.264     0.200
    49.720     0.455     0.200
    49.720     0.054     0.200
    49.772     1.401     0.200
    49.911     1.299     0.200
    50.260    -0.237     0.200
    50.260    -0.108     0.200
    50.260     0.292     0.200
    50.260     0.152     0.200
    50.204     0.723     0.200
    50.280     1.161     0.200
    50.280     0.712     0.200
    50.312     0.879     0.200
    50.312     1.231     0.200
    50.312     0.520     0.200
    50.441     1.973     0.200
    50.441     0.284     0.200
    50.558     1.895     0.200
    50.558     0.766     0.200
    50.874    -0.780     0.200
    50.874    -1.008     0.200
    50.874    -1.168     0.200
    50.915     1.446     0.200
    50.915     1.106     0.200
    50.915     0.305     0.200
    51.000     1.902     0.200
    51.000     0.862     0.200
    51.426     1.741     0.200
    51.426    -0.179     0.200
    51.426     0.270     0.200
    51.602     1.151     0.200
    51.682     1.156     0.200
    51.711     1.133     0.200
    51.734     0.865     0.200
    51.720     0.216     0.200
    51.722    -0.294     0.200
    51.722    -0.124     0.200
    51.921     2.216     0.200
    51.921     2.105     0.200
    51.935     1.925     0.200
    51.935     2.098     0.200
    51.935     0.827     0.200
    51.935     0.268     0.200
    51.973     1.704     0.200
    51.973     0.553     0.200
    51.973    -0.216     0.200
    51.973     0.284     0.200
    52.044     0.155     0.200
    52.044    -0.267     0.200
    52.200     0.893     0.200
    52.326     0.029     0.200
    52.326    -0.127     0.200
    52.326    -0.397     0.200
    52.329     1.788     0.200
    52.329     1.479     0.200
    52.329     0.719     0.200
    52.386     0.123     0.200
    52.386    -0.258     0.200
    52.386    -0.139     0.200
    52.313     0.251     0.200
    52.400     0.308     0.200
    52.404     0.279     0.200
    52.386     0.710     0.200
    52.397    -0.373     0.200
    52.955    -0.190     0.200
    53.095     2.527     0.200
    53.095     1.564     0.200
    53.430     0.399     0.200
    53.432    -0.199     0.200
    53.432     0.481     0.200
    53.433    -0.020     0.200
    53.433    -0.549     0.200
    53.445     0.392     0.200
    54.137     0.401     0.200
    54.137     1.132     0.200
    54.286     0.497     0.200
    54.425     0.027     0.200
    54.425     0.925     0.200
    54.401     1.415     0.200
    54.515     1.414     0.200
    54.515     1.590     0.200
    54.460    -0.098     0.200
    54.554     0.203     0.200
    54.555     0.422     0.200
    54.587    -0.275     0.200
    54.725     0.542     0.200
    54.881    -0.453     0.200
    54.887    -0.142     0.200
    55.182     0.943     0.200
    55.182     0.770     0.200
    55.182    -0.092     0.200
    55.182     1.539     0.200
    55.225     0.203     0.200
    55.225    -0.323     0.200
    55.454     0.069     0.200
    55.772     2.013     0.200
    55.772    -0.267     0.200
    55.772     2.653     0.200
    55.774     1.399     0.200
    55.776     0.876     0.200
    55.816     1.995     0.200
    55.816     0.044     0.200
    56.174     1.747     0.200
    56.149     0.995     0.200
    56.149     1.161     0.200
    56.149    -0.040     0.200
    56.462     1.013     0.200
    56.462     1.427     0.200
    56.462    -0.184     0.200
    56.452     1.980     0.200
    56.452     2.230     0.200
    56.452     1.560     0.200
    56.452     1.031     0.200
    56.461     0.163     0.200
    56.461     0.653     0.200
    56.630    -0.217     0.200
    56.630    -0.354     0.200
    57.264    -0.281     0.200
    57.264     0.120     0.200
    57.264     1.360     0.200
    58.201     0.012     0.200
    58.201    -0.570     0.200
    58.201    -1.801     0.200
    58.260     1.810     0.200
    58.512     1.807     0.200
    59.125     0.603     0.200
    59.125     1.374     0.200
    59.125     0.904     0.200
    59.821     0.836     0.200
    59.821     0.613     0.200
    59.964     0.857     0.200
    60.014     0.710     0.200
    60.014     0.532     0.200
    60.014     0.413     0.200
    59.994     0.958     0.200
    59.994     1.239     0.200
    59.994     2.088     0.200
    60.170     0.708     0.200
    60.170     0.929     0.200
    60.267     2.079     0.200
    60.267     1.536     0.200
    60.267     0.511     0.200
    60.342     0.966     0.200
    60.342     1.676     0.200
    60.436    -0.202     0.200
    60.436    -0.368     0.200
    60.436     0.542     0.200
    60.438     0.063     0.200
    60.438    -0.461     0.200
    60.882    -0.122     0.200
    60.882    -0.419     0.200
    60.882    -0.230     0.200
    61.871     0.611     0.200
    62.032    -1.742     0.200
    62.540     0.702     0.200
    62.750     0.252     0.200
    62.750     0.412     0.200
    62.750     0.832     0.200
    62.810     0.841     0.200
    62.810     0.309     0.200
    63.446     1.780     0.200
    63.446     0.700     0.200
    63.446     1.088     0.200
    64.048     0.290     0.200
    64.048     0.081     0.200
    64.048    -0.109     0.200
    64.048     0.411     0.200
    64.003     1.475     0.200
    64.003     0.446     0.200
    64.156     1.899     0.200
    64.156     0.960     0.200
    64.477     0.244     0.200
    64.616     0.406     0.200
    64.573    -0.170     0.200
    65.009     1.284     0.200
    65.580    -0.199     0.200
    65.725     1.195     0.200
    66.303     0.565     0.200
    66.303     0.766     0.200
    66.303    -0.810     0.200
    66.303    -0.685     0.200
    66.316     0.589     0.200
    66.383     0.949     0.200
    66.669     1.403     0.200
    66.669     0.601     0.200
    66.856     0.737     0.200
    66.936    -0.575     0.200
    67.132     0.054     0.200
    67.132    -0.153     0.200
    67.190    -0.029     0.200
    67.190     0.186     0.200
    67.936    -0.255     0.200
    67.936     0.546     0.200
    68.047     2.688     0.200
    68.193    -0.540     0.200
    68.173     0.619     0.200
    68.173     1.008     0.200
    68.173     0.748     0.200
    68.173     1.367     0.200
    68.528     0.775     0.200
    68.636     0.265     0.200
    68.636     0.788     0.200
    69.030     1.176     0.200
    69.473    -0.598     0.200
    69.473     0.417     0.200
    70.076    -1.012     0.200
    70.076    -0.541     0.200
    70.081    -0.953     0.200
    70.081    -1.191     0.200
    70.081     0.469     0.200
    70.359     1.692     0.200
    71.085     1.142     0.200
    71.085     2.296     0.200
    71.849     0.629     0.200
    71.854    -0.589     0.200
    71.854    -0.199     0.200
    71.854    -0.749     0.200
    72.473     1.331     0.200
    72.473     0.933     0.200
    72.473     1.702     0.200
    72.818     0.230     0.200
    73.142     0.873     0.200
    73.575     0.090     0.200
    73.598    -0.097     0.200
    73.598    -1.017     0.200
    74.381     2.488     0.200
    74.380     0.850     0.200
    74.374     0.359     0.200
    74.374    -0.008     0.200
    74.675     0.453     0.200
    74.675     0.082     0.200
    74.908     3.097     0.200
    74.908     1.649     0.200
    75.372     1.179     0.200
    75.578    -0.112     0.200
    75.578     0.441     0.200
    75.560     0.979     0.200
    75.560     0.770     0.200
    76.359     0.272     0.200
    76.651     0.180     0.200
    76.699     0.710     0.200
    76.699     0.230     0.200
    76.699     0.858     0.200
    77.080     1.020     0.200
    77.080     1.241     0.200
    77.080     0.709     0.200
    77.693     0.907     0.200
    78.038    -0.172     0.200
    78.038     0.556     0.200
    78.087     0.063     0.200
    78.087    -0.074     0.200
    78.087     0.688     0.200
    78.119     0.180     0.200
    78.062     1.987     0.200
    78.062     1.812     0.200
    78.062     0.663     0.200
    78.350     0.025     0.200
    78.691     0.737     0.200
    78.923     0.869     0.200
    79.000     0.727     0.200
    79.033     0.608     0.200
    79.235    -0.186     0.200
    79.574     0.814     0.200
    80.043    -0.236     0.200
    80.170     0.404     0.200
    80.629     1.026     0.200
    80.682     1.099     0.200
    80.743    -0.073     0.200
    80.746     0.087     0.200
    80.746     0.258     0.200
    80.746     0.489     0.200
    80.823     0.479     0.200
    80.964     0.825     0.200
    81.150     0.502     0.200
    81.187    -1.043     0.200
    81.187    -1.162     0.200
    81.384    -0.493     0.200
    81.384    -0.973     0.200
    81.384     0.587     0.200
    81.431     0.418     0.200
    81.652     0.292     0.200
    81.670    -0.313     0.200
    81.595     0.175     0.200
    81.595     2.724     0.200
    82.087    -0.150     0.200
    82.178     0.303     0.200
    82.178     0.801     0.200
    82.178     0.493     0.200
    82.482     1.123     0.200
    82.912    -0.805     0.200
    82.912    -1.186     0.200
    83.084     1.131     0.200
    83.152     0.207     0.200
    83.160     0.391     0.200
    83.268    -0.482     0.200
    83.331    -0.915     0.200
    83.443     0.568     0.200
    83.443     0.251     0.200
    83.479     2.681     0.200
    83.625    -0.579     0.200
    83.718     1.092     0.200
    83.875    -0.816     0.200
    84.030     0.619     0.200
    84.030    -0.214     0.200
    84.236    -1.744     0.200
    84.850    -0.558     0.200
    84.864     1.663     0.200
    84.864     0.452     0.200
    84.908    -0.420     0.200
    84.908    -1.494     0.200
    85.143     1.001     0.200
    85.830    -0.821     0.200
    85.995    -0.332     0.200
    86.254    -0.793     0.200
    86.413     1.954     0.200
    86.449     0.048     0.200
    86.546    -0.078     0.200
    86.546    -0.324     0.200
    86.688    -0.517     0.200
    87.177     0.635     0.200
    87.543    -1.205     0.200
    87.702    -0.467     0.200
    88.472     0.319     0.200
    89.521    -0.291     0.200
    89.521     0.447     0.200
    89.521    -0.603     0.200
    89.521    -0.422     0.200
    89.553     0.493     0.200
    89.914     0.476     0.200
    89.914    -0.263     0.200
    89.914     0.806     0.200
    90.042     0.235     0.200
    90.042     0.360     0.200
    90.042     0.510     0.200
    90.515     2.737     0.200
    90.768     0.289     0.200
    91.245     1.790     0.200
    91.785     0.780     0.200
    91.850    -0.430     0.200
    92.395     1.141     0.200
    93.220     0.636     0.200
    93.220     0.786     0.200
    93.319    -0.354     0.200
    93.358     0.087     0.200
    93.714    -0.182     0.200
    94.061     0.263     0.200
    94.458     0.671     0.200
    95.039     0.399     0.200
    95.039     0.548     0.200
    95.073     0.763     0.200
    96.389     1.117     0.200
    96.451     1.032     0.200
    96.673     0.475     0.200
    96.675    -0.410     0.200
    96.894     0.660     0.200
    97.577    -0.685     0.200
    98.782     0.511     0.200
    99.387     0.153     0.200
    14.741     4.265     0.200
    16.747     4.103     0.200
    17.243     3.465     0.200
    17.305     3.597     0.200
    17.540     3.573     0.200
    17.818     3.426     0.200
    19.315    -0.641     0.200
    19.319     0.026     0.200
    19.359    -1.054     0.200
    19.359    -0.482     0.200
    19.535     0.167     0.200
    19.535     0.718     0.200
    19.535    -0.532     0.200
    19.535    -1.022     0.200
    19.535     0.918     0.200
    20.002     0.481     0.200
    20.108    -1.393     0.200
    20.108     1.451     0.200
    20.845    -0.422     0.200
    20.883    -0.861     0.200
    21.870     0.555     0.200
    21.870    -0.324     0.200
    21.870     1.438     0.200
    21.870     1.817     0.200
    21.862     1.827     0.200
    22.191     1.710     0.200
    22.679    -1.149     0.200
    23.078     0.112     0.200
    23.078     2.602     0.200
    23.078     1.081     0.200
    23.078     0.222     0.200
    23.078     2.501     0.200
    23.968     1.519     0.200
    25.092     0.745     0.200
    25.145    -0.503     0.200
    28.621     0.556     0.200
    28.621     1.701     0.200
    30.386     2.860     0.200
    33.586    -0.944     0.200
    34.160     1.195     0.200
    35.179     1.280     0.200
    36.560     0.609     0.200
    36.560     0.855     0.200
    38.048     2.222     0.200
    40.120     0.487     0.200
    40.262    -0.531     0.200
    41.057     0.083     0.200
    41.552     0.636     0.200
    41.552    -0.989     0.200
    41.558     0.595     0.200
    42.916     0.596     0.200
    44.418     0.169     0.200
    46.740     0.528     0.200
    48.287     0.078     0.200
    48.494    -0.290     0.200
    51.724     0.856     0.200
    52.380     0.261     0.200
    54.139    -0.325     0.200
    68.191    -1.547     0.200
    76.439    -0.134     0.200
    78.346    -0.558     0.200
    78.563    -0.593     0.200
    87.540    -0.485     0.200
    89.519     0.224     0.200
    89.519    -1.584     0.200
    19.434     0.133     0.200
    19.611    -0.062     0.200
    19.311     0.863     0.200
    19.978     1.331     0.200
    20.085    -0.052     0.200
    28.683     0.353     0.200
    36.488    -0.030     0.200
    41.028    -0.861     0.200
    41.028    -0.686     0.200
    51.794    -0.069     0.200
    74.377     0.029     0.200
    76.350    -1.003     0.200
    87.471    -1.143     0.200
    89.450    -1.159     0.200
    89.450    -1.339     0.200
    19.341     0.648     0.200
    19.346    -0.989     0.200
    19.399    -0.913     0.200
    19.575    -1.186     0.200
    19.575    -1.374     0.200
    20.037     0.281     0.200
    20.143    -0.999     0.200
    21.883    -0.325     0.200
    41.094     0.260     0.200
    51.696    -1.128     0.200
    52.423     0.007     0.200
    17.296     2.634     0.200
    19.311     1.307     0.200
    19.359    -0.932     0.200
    19.359    -0.764     0.200
    19.536    -0.155     0.200
    19.536     0.947     0.200
    19.536     0.970     0.200
    19.536     0.396     0.200
    20.000     1.631     0.200
    20.107     0.340     0.200
    20.107     0.519     0.200
    21.062    -0.069     0.200
    21.245     0.083     0.200
    21.308     0.300     0.200
    21.389     0.640     0.200
    21.849     1.199     0.200
    21.864     0.438     0.200
    21.864     1.529     0.200
    21.864     1.306     0.200
    21.864     1.135     0.200
    21.864    -0.065     0.200
    21.864     1.408     0.200
    22.101     0.927     0.200
    22.481     0.953     0.200
    22.687    -1.665     0.200
    23.067     1.445     0.200
    23.070    -0.227     0.200
    23.070     1.413     0.200
    23.070     1.312     0.200
    23.070     1.863     0.200
    23.070     0.113     0.200
    23.477    -0.235     0.200
    23.601     3.331     0.200
    23.967     0.251     0.200
    25.151    -0.568     0.200
    25.151     1.580     0.200
    25.090     0.419     0.200
    25.090     0.793     0.200
    25.090     0.387     0.200
    25.346     2.016     0.200
    26.913     3.114     0.200
    26.971     1.694     0.200
    28.613     1.209     0.200
    28.613     0.427     0.200
    28.613     1.005     0.200
    28.613    -0.194     0.200
    28.620     0.874     0.200
    28.620     1.116     0.200
    28.620     0.526     0.200
    28.620     0.674     0.200
    28.748     0.802     0.200
    30.272     2.020     0.200
    30.389     2.559     0.200
    31.900     0.079     0.200
    32.372     0.895     0.200
    33.630    -0.175     0.200
    33.843     1.999     0.200
    34.278     2.285     0.200
    34.895     1.751     0.200
    35.160     1.451     0.200
    35.171     1.393     0.200
    35.420     2.247     0.200
    35.420     0.876     0.200
    35.427     0.150     0.200
    35.433     0.095     0.200
    35.864     0.094     0.200
    35.864     1.723     0.200
    36.372     0.644     0.200
    36.376     0.623     0.200
    36.400     0.709     0.200
    36.567    -0.795     0.200
    36.567     0.584     0.200
    36.582    -0.439     0.200
    36.600    -0.696     0.200
    36.490     3.129     0.200
    36.730     0.164     0.200
    37.519     0.189     0.200
    38.040     2.360     0.200
    38.210     1.636     0.200
    38.332    -0.069     0.200
    38.915    -0.199     0.200
    39.095     0.662     0.200
    39.095    -1.311     0.200
    38.928     2.516     0.200
    38.928     1.957     0.200
    39.223     1.097     0.200
    39.810    -0.142     0.200
    40.010     0.194     0.200
    40.112     1.037     0.200
    40.255     1.013     0.200
    40.255     0.255     0.200
    40.328    -0.079     0.200
    40.411     0.138     0.200
    40.572     0.325     0.200
    41.056    -1.103     0.200
    41.056    -1.392     0.200
    41.512     0.564     0.200
    41.523     0.367     0.200
    41.550     0.681     0.200
    41.544     0.434     0.200
    41.544     0.484     0.200
    41.795     0.045     0.200
    41.795    -0.408     0.200
    42.470     0.271     0.200
    42.381     0.996     0.200
    42.575     0.962     0.200
    42.791     0.479     0.200
    42.765     1.443     0.200
    43.117     1.059     0.200
    44.456     1.749     0.200
    44.410     1.004     0.200
    44.410     0.453     0.200
    45.656     0.409     0.200
    46.351     0.643     0.200
    46.817    -0.885     0.200
    47.001     0.211     0.200
    47.001    -0.828     0.200
    47.242     0.453     0.200
    47.705     1.143     0.200
    48.279     0.551     0.200
    48.486     0.885     0.200
    48.691     0.029     0.200
    48.861    -0.142     0.200
    49.161     1.417     0.200
    49.713     0.077     0.200
    49.713     0.206     0.200
    49.713    -0.794     0.200
    50.252     0.317     0.200
    50.252    -0.426     0.200
    50.252    -0.285     0.200
    51.676     0.895     0.200
    51.706     0.974     0.200
    51.715    -0.043     0.200
    51.716     0.720     0.200
    51.716    -0.042     0.200
    51.973     2.079     0.200
    52.038    -0.005     0.200
    52.038     0.425     0.200
    52.106     0.636     0.200
    52.106    -0.106     0.200
    52.383    -0.060     0.200
    52.383    -0.599     0.200
    52.397    -0.175     0.200
    52.401    -0.103     0.200
    52.383     0.877     0.200
    52.619     0.552     0.200
    53.429    -0.041     0.200
    53.429     0.189     0.200
    54.131    -0.148     0.200
    54.415     0.806     0.200
    54.550    -0.485     0.200
    54.643     0.196     0.200
    55.065     0.686     0.200
    55.769     2.443     0.200
    56.172     1.200     0.200
    56.172     0.653     0.200
    56.443     2.367     0.200
    57.152    -1.109     0.200
    57.259    -0.479     0.200
    59.956     0.806     0.200
    59.956     0.506     0.200
    60.168    -0.414     0.200
    60.435    -0.008     0.200
    60.470    -0.014     0.200
    60.878    -0.343     0.200
    61.866    -0.189     0.200
    63.430     0.108     0.200
    64.052     0.273     0.200
    64.052    -0.880     0.200
    64.052    -0.317     0.200
    66.309     0.229     0.200
    68.643     0.223     0.200
    69.477     0.023     0.200
    69.477    -0.215     0.200
    70.085    -0.028     0.200
    70.085    -0.157     0.200
    71.861    -0.316     0.200
    71.861    -0.664     0.200
    72.113     0.826     0.200
    73.038     0.243     0.200
    73.603    -1.027     0.200
    73.670     0.459     0.200
    73.976     0.007     0.200
    74.245     0.134     0.200
    74.329     0.255     0.200
    74.371     1.282     0.200
    74.635    -0.225     0.200
    74.834    -0.117     0.200
    75.059     0.815     0.200
    75.581     0.419     0.200
    75.581    -0.241     0.200
    75.532    -0.336     0.200
    75.959    -0.002     0.200
    76.435     0.712     0.200
    76.475     1.536     0.200
    76.689     0.613     0.200
    77.280     1.338     0.200
    77.398     0.949     0.200
    77.450     1.155     0.200
    78.077     1.069     0.200
    78.077     0.838     0.200
    78.110     0.230     0.200
    78.182     0.838     0.200
    78.293     0.304     0.200
    78.341     0.326     0.200
    78.449     0.837     0.200
    78.559     0.793     0.200
    78.663    -0.251     0.200
    79.000     0.629     0.200
    79.057    -0.126     0.200
    79.239     0.729     0.200
    79.239     0.979     0.200
    79.632     0.389     0.200
    79.807     0.185     0.200
    79.859    -0.272     0.200
    80.049    -0.844     0.200
    79.956    -0.740     0.200
    80.069    -0.178     0.200
    80.302     0.050     0.200
    80.751     0.471     0.200
    80.693     0.522     0.200
    80.768     0.641     0.200
    80.814    -0.514     0.200
    80.955     0.609     0.200
    80.955     0.374     0.200
    81.115     0.281     0.200
    81.141     0.618     0.200
    81.202     0.715     0.200
    81.556     0.268     0.200
    82.078    -0.273     0.200
    83.013     0.040     0.200
    83.035    -0.003     0.200
    83.143     0.609     0.200
    83.434     0.806     0.200
    83.434     0.521     0.200
    83.434    -0.092     0.200
    83.527    -0.532     0.200
    87.548    -0.832     0.200
    88.086    -0.086     0.200
    89.527     0.019     0.200
    89.527    -0.880     0.200
    14.674     4.774     0.200
    14.674     5.189     0.200
    14.674     4.673     0.200
    17.180     2.157     0.200
    17.494     2.993     0.200
    18.091     1.944     0.200
    18.421     0.636     0.200
    18.876    -0.833     0.200
    19.158     0.649     0.200
    19.322    -0.601     0.200
    19.326     0.334     0.200
    19.326    -0.334     0.200
    19.400    -0.286     0.200
    19.400    -0.821     0.200
    19.319     0.980     0.200
    19.331     1.264     0.200
    19.576     0.266     0.200
    19.576    -0.535     0.200
    19.576    -0.035     0.200
    19.576     0.066     0.200
    19.576    -0.594     0.200
    19.659     1.159     0.200
    20.028     1.086     0.200
    20.135     1.655     0.200
    20.135     0.202     0.200
    20.135     1.772     0.200
    20.135     1.221     0.200
    20.519     0.099     0.200
    20.661    -1.480     0.200
    20.776     1.264     0.200
    20.814     1.155     0.200
    20.898     2.397     0.200
    21.125    -0.303     0.200
    21.308     1.069     0.200
    21.246     0.556     0.200
    21.430    -0.145     0.200
    21.852     1.513     0.200
    21.852     0.177     0.200
    21.852     1.286     0.200
    21.914     0.627     0.200
    21.912     1.687     0.200
    22.039     0.622     0.200
    22.038     1.788     0.200
    22.177     1.253     0.200
    22.544     0.948     0.200
    22.736    -0.854     0.200
    22.762     2.499     0.200
    23.006     0.949     0.200
    23.009     2.410     0.200
    23.009     1.019     0.200
    23.009     0.918     0.200
    23.009     1.718     0.200
    23.009     3.062     0.200
    23.009     2.371     0.200
    23.009     1.129     0.200
    23.304     0.407     0.200
    23.304     1.014     0.200
    23.414     0.949     0.200
    23.557    -0.440     0.200
    23.540     2.220     0.200
    23.567     1.568     0.200
    23.668     2.013     0.200
    23.668     1.244     0.200
    23.668     2.963     0.200
    24.006     1.650     0.200
    24.266     0.982     0.200
    25.119     0.585     0.200
    25.119    -0.193     0.200
    25.119     0.608     0.200
    25.119     0.198     0.200
    25.119     0.506     0.200
    25.215     0.029     0.200
    25.215     1.299     0.200
    25.212     2.345     0.200
    25.323     1.651     0.200
    25.985     0.120     0.200
    26.809     1.812     0.200
    26.876     2.907     0.200
    26.932     0.603     0.200
    26.932     0.884     0.200
    26.932     0.704     0.200
    27.273     1.829     0.200
    27.743     0.454     0.200
    28.276     1.361     0.200
    28.521     1.080     0.200
    28.546     1.055     0.200
    28.563     0.926     0.200
    28.563     0.602     0.200
    28.563     0.801     0.200
    28.563     1.101     0.200
    28.563     0.398     0.200
    28.570     0.989     0.200
    28.570     0.427     0.200
    28.570     0.817     0.200
    28.570     1.337     0.200
    28.574     1.104     0.200
    28.621     1.094     0.200
    28.628     1.125     0.200
    28.644     1.081     0.200
    28.664     1.107     0.200
    28.699     1.097     0.200
    28.841     2.239     0.200
    28.841     1.130     0.200
    28.892     2.679     0.200
    29.074     1.874     0.200
    29.244     1.520     0.200
    29.244     0.751     0.200
    29.320     3.052     0.200
    29.320     0.912     0.200
    29.320     2.783     0.200
    29.475     2.096     0.200
    29.581     2.664     0.200
    29.780     2.091     0.200
    29.935     2.030     0.200
    30.005     1.636     0.200
    30.198     1.799     0.200
    30.215     0.879     0.200
    30.216     2.044     0.200
    30.216     2.454     0.200
    30.446     2.207     0.200
    30.677     2.715     0.200
    30.875     1.075     0.200
    30.830     1.659     0.200
    30.830     2.405     0.200
    31.017     2.268     0.200
    31.192     1.532     0.200
    31.204     1.500     0.200
    31.263     0.859     0.200
    31.263    -0.442     0.200
    31.239     1.636     0.200
    31.352     2.650     0.200
    31.452     1.329     0.200
    31.451     2.182     0.200
    31.485     2.143     0.200
    31.599     1.311     0.200
    31.737     2.018     0.200
    31.737     2.428     0.200
    32.067     2.110     0.200
    32.135     2.330     0.200
    32.279     2.668     0.200
    32.154     1.901     0.200
    32.215     2.407     0.200
    32.308     3.109     0.200
    32.290    -0.391     0.200
    32.319     0.918     0.200
    32.352     1.883     0.200
    32.352     0.754     0.200
    32.352     2.223     0.200
    32.389     2.288     0.200
    32.389     2.597     0.200
    32.951     2.329     0.200
    33.145     3.683     0.200
    33.278     0.528     0.200
    33.319    -0.053     0.200
    33.319     0.768     0.200
    33.410     0.461     0.200
    33.752     3.122     0.200
    33.788     1.578     0.200
    33.788     2.125     0.200
    33.788     1.214     0.200
    33.939     0.915     0.200
    34.113     1.425     0.200
    34.470     1.201     0.200
    34.839     1.189     0.200
    35.135     1.015     0.200
    35.222    -0.034     0.200
    35.298     1.485     0.200
    35.339     1.787     0.200
    35.468     1.827     0.200
    35.468    -0.552     0.200
    35.475    -0.309     0.200
    35.481    -0.365     0.200
    35.436     2.734     0.200
    35.436     1.261     0.200
    35.580     1.769     0.200
    35.582     2.046     0.200
    35.582     2.667     0.200
    35.912     1.495     0.200
    35.912     1.937     0.200
    35.912     0.366     0.200
    35.912     1.335     0.200
    36.133     0.943     0.200
    36.179     1.461     0.200
    36.235     2.179     0.200
    36.435     0.126     0.200
    36.435     0.536     0.200
    36.439     0.144     0.200
    36.463     0.721     0.200
    36.438     2.137     0.200
    36.438     0.958     0.200
    36.488     0.940     0.200
    36.526     2.118     0.200
    36.534     2.468     0.200
    36.629    -0.304     0.200
    36.629     0.505     0.200
    36.629     0.036     0.200
    36.644    -0.420     0.200
    36.662    -0.376     0.200
    36.634     1.139     0.200
    36.727     1.218     0.200
    36.727     1.351     0.200
    36.727     0.406     0.200
    36.727     1.468     0.200
    36.675     0.541     0.200
    36.695     1.120     0.200
    36.695     0.601     0.200
    36.780    -0.583     0.200
    36.814     1.261     0.200
    37.285     0.858     0.200
    37.320     1.119     0.200
    37.529    -1.257     0.200
    37.529    -0.632     0.200
    37.529     0.055     0.200
    37.529     2.055     0.200
    37.528     0.366     0.200
    37.908     1.622     0.200
    37.920     0.727     0.200
    37.969     1.045     0.200
    37.969     0.346     0.200
    37.986     0.568     0.200
    38.007    -0.394     0.200
    38.086     1.863     0.200
    38.202     1.751     0.200
    38.154     2.247     0.200
    38.154     1.063     0.200
    38.272     1.579     0.200
    38.272     2.547     0.200
    38.272     1.020     0.200
    38.272     0.879     0.200
    38.313     0.670     0.200
    38.395     0.865     0.200
    38.561     0.753     0.200
    38.561     0.479     0.200
    38.577     1.743     0.200
    38.541     1.603     0.200
    38.615     1.496     0.200
    38.722     1.149     0.200
    38.774     1.377     0.200
    38.843     1.021     0.200
    38.856     0.527     0.200
    38.902     2.769     0.200
    39.009     0.862     0.200
    39.058     1.447     0.200
    39.156     0.252     0.200
    39.156    -0.279     0.200
    38.991     2.777     0.200
    38.991     2.097     0.200
    39.284     1.888     0.200
    39.321     0.205     0.200
    39.327     0.879     0.200
    39.383     2.072     0.200
    39.384     1.885     0.200
    39.402     2.488     0.200
    39.458     2.256     0.200
    39.522     0.914     0.200
    39.661     1.181     0.200
    39.747     1.179     0.200
    39.840     1.314     0.200
    39.865     1.412     0.200
    39.985     0.854     0.200
    39.985     1.354     0.200
    39.943     0.827     0.200
    40.030     1.240     0.200
    40.070     0.668     0.200
    40.229     1.262     0.200
    40.229     0.531     0.200
    40.229     1.281     0.200
    40.229     1.480     0.200
    40.236     0.466     0.200
    40.272     1.144     0.200
    40.272     1.335     0.200
    40.356     0.814     0.200
    40.522     1.019     0.200
    40.517     0.472     0.200
    40.570     2.024     0.200
    40.822     1.588     0.200
    40.909     1.912     0.200
    40.929     0.655     0.200
    40.961     1.097     0.200
    40.961     0.925     0.200
    41.088     0.628     0.200
    41.088     0.058     0.200
    41.008     0.640     0.200
    41.149     0.754     0.200
    41.248     1.117     0.200
    41.266     0.473     0.200
    41.266     0.664     0.200
    41.309     0.616     0.200
    41.424     1.409     0.200
    41.472     0.667     0.200
    41.483     0.809     0.200
    41.503     0.718     0.200
    41.503     0.218     0.200
    41.503     0.616     0.200
    41.492     0.692     0.200
    41.525     0.140     0.200
    41.540    -0.018     0.200
    41.540     0.811     0.200
    41.540     1.213     0.200
    41.657     1.440     0.200
    41.717     1.297     0.200
    41.677     0.687     0.200
    41.677     0.347     0.200
    41.791     0.851     0.200
    41.858    -0.080     0.200
    41.935     0.371     0.200
    41.939     0.850     0.200
    42.131     1.142     0.200
    42.162     1.117     0.200
    42.193     0.926     0.200
    42.220     1.133     0.200
    42.345     2.031     0.200
    42.326     0.640     0.200
    42.326     0.793     0.200
    42.330     0.519     0.200
    42.404     0.977     0.200
    42.368     0.551     0.200
    42.428     0.907     0.200
    42.435     0.702     0.200
    42.557     1.053     0.200
    42.516     0.736     0.200
    42.580     0.765     0.200
    42.513     0.842     0.200
    42.513     0.967     0.200
    42.513     2.291     0.200
    42.595     1.378     0.200
    42.707     1.103     0.200
    42.850     1.830     0.200
    42.850     0.969     0.200
    42.906     1.447     0.200
    43.039     0.029     0.200
    43.029     1.257     0.200
    43.085     1.528     0.200
    43.085     0.919     0.200
    43.085     0.630     0.200
    43.252     0.699     0.200
    43.532     2.139     0.200
    43.579     1.327     0.200
    43.857     1.386     0.200
    43.908     1.544     0.200
    44.047     1.693     0.200
    44.182     1.506     0.200
    44.350     0.633     0.200
    44.353     0.696     0.200
    44.353     0.458     0.200
    44.513     1.939     0.200
    44.610     0.437     0.200
    45.463     0.520     0.200
    45.614     0.783     0.200
    45.614     1.826     0.200
    45.968     0.073     0.200
    46.293     0.784     0.200
    46.674     1.111     0.200
    47.058     0.282     0.200
    47.058     0.040     0.200
    47.126     0.189     0.200
    47.297     0.267     0.200
    47.415     0.488     0.200
    47.687     1.074     0.200
    47.687     1.234     0.200
    48.220     0.425     0.200
    48.438     0.851     0.200
    48.436     1.255     0.200
    48.465     0.639     0.200
    48.843     1.646     0.200
    48.843     0.868     0.200
    48.843     1.485     0.200
    48.843     0.446     0.200
    48.843     2.009     0.200
    49.206     1.123     0.200
    49.245     0.688     0.200
    49.744     0.506     0.200
    49.744    -0.583     0.200
    49.744    -0.181     0.200
    50.270     0.493     0.200
    50.270     0.922     0.200
    50.270     0.344     0.200
    50.247     0.579     0.200
    50.247     1.306     0.200
    50.354     0.936     0.200
    51.711     0.182     0.200
    51.617     0.887     0.200
    51.647     0.863     0.200
    51.656     0.628     0.200
    51.657     0.410     0.200
    51.657     0.516     0.200
    52.036     1.702     0.200
    52.036    -0.341     0.200
    51.979     0.786     0.200
    51.979     0.544     0.200
    51.979     0.891     0.200
    51.979     0.216     0.200
    52.151     0.901     0.200
    52.380    -0.102     0.200
    52.439     0.475     0.200
    52.439     1.081     0.200
    52.439     0.034     0.200
    52.453    -0.339     0.200
    52.457    -0.367     0.200
    52.439     0.713     0.200
    52.559     0.633     0.200
    52.889    -0.141     0.200
    53.042     0.743     0.200
    53.476    -0.290     0.200
    53.478    -0.378     0.200
    53.478    -0.108     0.200
    53.478     0.067     0.200
    53.478    -0.269     0.200
    53.490    -0.299     0.200
    54.073     1.346     0.200
    54.073     1.065     0.200
    54.259     0.489     0.200
    54.392     0.751     0.200
    54.392     0.411     0.200
    54.584     0.443     0.200
    54.851     0.716     0.200
    55.006     0.779     0.200
    55.160     0.273     0.200
    55.160     0.598     0.200
    55.559     0.752     0.200
    56.405     0.607     0.200
    57.197     0.405     0.200
    58.198     0.327     0.200
    59.097     0.982     0.200
    59.097     1.732     0.200
    59.862     0.802     0.200
    59.862     0.649     0.200
    59.862    -0.370     0.200
    59.984     1.159     0.200
    59.970     1.745     0.200
    59.970     0.506     0.200
    59.970     1.616     0.200
    60.066     0.855     0.200
    60.066    -0.203     0.200
    60.305     1.060     0.200
    60.305     1.861     0.200
    60.305     1.662     0.200
    60.487     0.276     0.200
    60.487     0.045     0.200
    60.489    -0.096     0.200
    60.929     0.035     0.200
    60.929    -0.383     0.200
    63.458     1.143     0.200
    63.450    -0.233     0.200
    63.458     0.944     0.200
    64.452     2.651     0.200
    66.334    -0.587     0.200
    66.334    -0.888     0.200
    66.334    -0.317     0.200
    66.358     0.989     0.200
    66.629     0.258     0.200
    66.629    -0.063     0.200
    67.890     0.897     0.200
    67.890     0.338     0.200
    68.030     1.979     0.200
    68.138     0.390     0.200
    68.138     1.018     0.200
    68.138     0.768     0.200
    68.612     0.799     0.200
    68.612     0.494     0.200
    70.047    -0.833     0.200
    71.831    -0.547     0.200
    71.831    -0.024     0.200
    73.047     0.432     0.200
    73.139     0.800     0.200
    73.684    -0.170     0.200
    73.986     0.429     0.200
    74.250     0.347     0.200
    74.332     1.506     0.200
    74.377     1.509     0.200
    74.377     1.373     0.200
    74.369     0.473     0.200
    74.847     0.982     0.200
    75.065     1.488     0.200
    75.644    -0.339     0.200
    75.969     0.095     0.200
    76.034     0.330     0.200
    76.445     0.208     0.200
    76.482     1.599     0.200
    76.514     1.583     0.200
    76.659     0.964     0.200
    76.690     0.931     0.200
    77.056     1.263     0.200
    77.202    -0.114     0.200
    77.247    -0.170     0.200
    77.798     0.321     0.200
    77.937    -0.349     0.200
    78.085     0.947     0.200
    78.085     1.267     0.200
    78.085    -0.123     0.200
    78.085     1.537     0.200
    78.349     0.026     0.200
    78.397     0.016     0.200
    79.244     0.924     0.200
    80.107     0.574     0.200
    80.107    -0.356     0.200
    80.164     1.283     0.200
    80.164    -0.088     0.200
    80.258    -0.570     0.200
    80.773     0.121     0.200
    80.823     0.103     0.200
    80.811    -0.059     0.200
    80.811     0.434     0.200
    81.567     0.021     0.200
    81.735     1.096     0.200
    83.135     0.362     0.200
    83.334     0.034     0.200
    83.448     0.985     0.200
    83.448     0.465     0.200
    83.448     0.356     0.200
    83.532     0.354     0.200
    86.711     0.500     0.200
    87.608    -1.479     0.200
    87.767    -0.067     0.200
    89.585    -0.212     0.200
    89.585     0.084     0.200
    89.888    -0.414     0.200
    92.657     1.078     0.200
    96.405     1.602     0.200
    97.434     0.278     0.200
    98.441    -0.495     0.200
    19.553     0.381     0.200
    21.895     0.599     0.200
    21.895    -0.174     0.200
    25.113    -0.314     0.200
    35.514     2.543     0.200
    36.553     0.451     0.200
    41.077    -0.152     0.200
    68.180    -0.589     0.200
    74.400     1.112     0.200
    75.987     0.268     0.200
    79.660     0.804     0.200
    87.530    -0.846     0.200
    87.530    -0.385     0.200
    89.507    -0.191     0.200
    89.507    -0.421     0.200
    19.610     0.262     0.200
    20.084     1.568     0.200
    25.174    -0.142     0.200
    36.558    -1.108     0.200
    51.740    -0.531     0.200
    52.434     0.378     0.200
    19.597     0.450     0.200
    36.595    -1.181     0.200
    41.117    -0.055     0.200
    51.697    -0.714     0.200
    87.567    -1.297     0.200
    19.341     0.197     0.200
    19.559     0.381     0.200
    20.027     1.224     0.200
    21.894     1.101     0.200
    23.078     1.097     0.200
    25.117     1.210     0.200
    28.632    -0.419     0.200
    35.196     0.066     0.200
    36.562    -0.104     0.200
    40.135     0.614     0.200
    41.082     1.349     0.200
    41.567     0.460     0.200
    41.567    -0.040     0.200
    51.727    -0.639     0.200
    52.398     0.132     0.200
    87.538    -1.040     0.200
    89.515    -0.558     0.200
    17.273     3.454     0.200
    19.350     0.608     0.200
    19.354    -0.560     0.200
    19.354     0.503     0.200
    19.413    -0.989     0.200
    19.413    -1.872     0.200
    19.413    -0.293     0.200
    19.590     0.206     0.200
    19.590    -0.321     0.200
    19.590     0.655     0.200
    19.590    -1.192     0.200
    20.155     1.292     0.200
    20.155    -0.388     0.200
    20.155     0.803     0.200
    20.155     1.010     0.200
    20.155     0.663     0.200
    20.798     0.192     0.200
    21.443    -1.121     0.200
    21.920     1.260     0.200
    21.886     1.598     0.200
    21.886     1.027     0.200
    21.886     1.258     0.200
    23.033     1.021     0.200
    23.033     1.783     0.200
    23.033     0.912     0.200
    24.021     1.687     0.200
    25.139     0.920     0.200
    25.139    -1.057     0.200
    25.358     1.358     0.200
    25.358     2.905     0.200
    28.595     0.911     0.200
    28.602     0.736     0.200
    28.602     0.287     0.200
    30.244     1.869     0.200
    31.766     2.395     0.200
    32.293     2.617     0.200
    33.670    -2.171     0.200
    35.170     1.249     0.200
    35.476     1.730     0.200
    35.920     2.059     0.200
    36.413     0.663     0.200
    36.417     0.630     0.200
    36.608     0.665     0.200
    36.608    -1.077     0.200
    36.669     1.632     0.200
    37.557     1.815     0.200
    37.557    -0.989     0.200
    37.557     1.491     0.200
    37.641     2.007     0.200
    37.943     1.571     0.200
    38.016     1.716     0.200
    38.237     1.880     0.200
    40.104     0.486     0.200
    40.263     1.616     0.200
    40.263    -0.084     0.200
    41.107     0.379     0.200
    41.107    -0.675     0.200
    41.498     2.952     0.200
    41.537     0.187     0.200
    41.518     0.669     0.200
    45.488     1.199     0.200
    46.321     0.438     0.200
    46.700     0.638     0.200
    47.086    -1.041     0.200
    51.683    -0.055     0.200
    51.683    -0.161     0.200
    52.161    -0.297     0.200
    52.440     1.236     0.200
    52.585     0.601     0.200
    54.100     1.209     0.200
    54.427     0.438     0.200
    54.610     0.823     0.200
    62.581    -1.148     0.200
    70.030    -2.136     0.200
    87.582    -0.519     0.200
    87.582    -1.546     0.200
    89.557     0.102     0.200
    19.530    -0.221     0.200
    20.013    -0.810     0.200
    25.103    -0.724     0.200
    87.470    -0.034     0.200
    89.448     0.487     0.200
    19.563     0.180     0.200
    20.035     0.731     0.200
    23.092     0.369     0.200
    25.125     0.155     0.200
    36.549    -0.189     0.200
    87.523    -0.258     0.200
    89.500    -0.537     0.200
    19.347     1.615     0.200
    19.583    -0.086     0.200
    20.043     0.941     0.200
    25.134     0.054     0.200
    36.597    -0.405     0.200
    41.101    -0.615     0.200
    51.693    -0.244     0.200
    19.374     0.290     0.200
    19.634    -0.242     0.200
    20.085     0.610     0.200
    21.892     1.717     0.200
    25.176     0.146     0.200
    36.653     0.661     0.200
    41.146    -0.151     0.200
    51.642     0.591     0.200
    87.622    -0.536     0.200
    15.777     4.070     0.200
    16.416     2.410     0.200
    17.514     2.129     0.200
    19.389     0.306     0.200
    19.393    -0.686     0.200
    19.393     0.111     0.200
    19.393    -0.147     0.200
    19.452    -0.543     0.200
    19.452    -0.817     0.200
    19.452     0.636     0.200
    19.629    -0.136     0.200
    19.629    -0.363     0.200
    19.629     0.512     0.200
    19.629    -0.644     0.200
    20.089     1.568     0.200
    20.196     1.625     0.200
    20.196    -0.766     0.200
    20.196     1.164     0.200
    20.196     1.750     0.200
    20.791     0.538     0.200
    20.825     0.669     0.200
    21.262     1.027     0.200
    21.482    -0.158     0.200
    21.919     0.642     0.200
    21.919     0.955     0.200
    21.919     1.220     0.200
    23.027     0.549     0.200
    23.027     1.971     0.200
    23.027     1.823     0.200
    23.027     1.682     0.200
    23.556     3.058     0.200
    24.060     0.911     0.200
    25.180     0.685     0.200
    25.180    -0.370     0.200
    25.218     0.826     0.200
    25.218     1.162     0.200
    25.387     2.224     0.200
    25.995     0.541     0.200
    26.985     1.977     0.200
    28.606     0.376     0.200
    28.613     0.861     0.200
    30.246     2.409     0.200
    30.476     2.401     0.200
    30.860     1.938     0.200
    32.383     2.168     0.200
    33.678    -0.139     0.200
    33.789     2.052     0.200
    35.191     1.276     0.200
    35.513     1.294     0.200
    36.470     0.847     0.200
    36.616     0.269     0.200
    36.616     0.167     0.200
    37.353     1.637     0.200
    37.970     1.489     0.200
    37.970     1.244     0.200
    38.262     1.609     0.200
    38.648     1.206     0.200
    38.683     0.882     0.200
    38.869     0.720     0.200
    38.881     1.365     0.200
    40.047    -0.009     0.200
    40.047     1.241     0.200
    40.091     1.373     0.200
    40.122     0.458     0.200
    40.291     0.848     0.200
    41.147     0.732     0.200
    41.180     1.192     0.200
    41.524     0.771     0.200
    41.517     0.817     0.200
    41.555     0.650     0.200
    41.555     0.650     0.200
    41.697     1.218     0.200
    42.878     0.797     0.200
    44.383     1.018     0.200
    46.321     0.971     0.200
    46.699     0.736     0.200
    47.752     0.089     0.200
    48.244     0.599     0.200
    49.254     1.013     0.200
    49.803     0.247     0.200
    49.803     0.364     0.200
    51.680     0.600     0.200
    51.681     0.316     0.200
    51.681     0.511     0.200
    51.996     0.754     0.200
    52.003     0.470     0.200
    52.199     0.010     0.200
    52.472     0.825     0.200
    54.455     0.758     0.200
    54.608     0.647     0.200
    55.029     0.735     0.200
    59.040     1.211     0.200
    60.366     2.003     0.200
    63.523     0.771     0.200
    68.552     0.539     0.200
    69.465    -1.439     0.200
    71.771    -1.592     0.200
    71.771    -0.607     0.200
    72.871    -0.413     0.200
    74.318     0.048     0.200
    76.036     0.469     0.200
    87.584    -0.673     0.200
    89.557    -0.964     0.200
    19.418     0.741     0.200
    20.111     1.304     0.200
    41.167    -0.470     0.200
    51.705    -0.726     0.200
    87.559    -1.744     0.200
    15.078     4.193     0.200
    19.382     0.373     0.200
    19.400     0.215     0.200
    19.576     0.326     0.200
    19.576    -0.259     0.200
    20.056     0.290     0.200
    20.163     1.571     0.200
    20.884    -0.055     0.200
    21.888     1.024     0.200
    21.946     0.474     0.200
    21.946     0.886     0.200
    23.119     0.891     0.200
    23.119     1.261     0.200
    23.649     2.723     0.200
    25.146     0.209     0.200
    25.146    -0.211     0.200
    26.089     1.180     0.200
    28.685     1.042     0.200
    28.692     1.326     0.200
    28.692     0.996     0.200
    33.323     0.562     0.200
    35.252     0.595     0.200
    36.329     0.485     0.200
    36.333     0.393     0.200
    36.523     0.208     0.200
    36.780     3.354     0.200
    38.018     1.345     0.200
    38.314     1.776     0.200
    38.501     1.426     0.200
    38.689     1.947     0.200
    39.178     1.400     0.200
    40.141     0.977     0.200
    40.190     0.560     0.200
    40.338     0.623     0.200
    40.390     1.791     0.200
    40.448     2.018     0.200
    40.680     2.225     0.200
    41.107     0.223     0.200
    41.107    -0.017     0.200
    41.591     0.585     0.200
    41.607     0.817     0.200
    41.623     0.537     0.200
    41.623     0.587     0.200
    41.788     1.230     0.200
    41.788    -0.030     0.200
    42.484     1.152     0.200
    42.607     0.562     0.200
    42.620     1.273     0.200
    42.632     1.219     0.200
    42.824     1.113     0.200
    42.967     1.005     0.200
    43.156    -0.197     0.200
    43.148     1.347     0.200
    44.471     0.415     0.200
    44.471     0.685     0.200
    46.410     0.700     0.200
    46.789     0.996     0.200
    48.335     0.443     0.200
    48.559     0.769     0.200
    49.004     1.754     0.200
    51.770     0.553     0.200
    51.771     0.458     0.200
    51.771     0.033     0.200
    52.093     0.514     0.200
    52.395     1.439     0.200
    54.189     1.126     0.200
    54.499     0.588     0.200
    58.831     1.100     0.200
    76.031     0.295     0.200
    77.522     0.992     0.200
    77.980    -1.981     0.200
    83.504     0.506     0.200
    87.493    -0.118     0.200
    87.493    -1.047     0.200
    87.495    -0.959     0.200
    89.468    -0.257     0.200
    89.468    -0.538     0.200
    20.068     0.330     0.200
    21.966     0.349     0.200
    23.135    -1.362     0.200
    25.157    -1.429     0.200
    19.330    -0.931     0.200
    19.547    -0.665     0.200
    21.886     1.252     0.200
    25.106    -0.464     0.200
    36.557     0.602     0.200
    40.132     0.036     0.200
    41.070    -1.354     0.200
    51.730     0.589     0.200
    87.535    -0.068     0.200
    18.122     1.374     0.200
    19.328     0.479     0.200
    19.555     0.292     0.200
    20.019     0.107     0.200
    21.877     0.652     0.200
    25.109    -0.525     0.200
    35.177     0.928     0.200
    35.440    -0.106     0.200
    36.576    -0.510     0.200
    40.115     0.743     0.200
    41.075    -0.005     0.200
    41.548     0.212     0.200
    51.710     0.051     0.200
    87.554    -0.502     0.200
    89.532    -0.173     0.200
    19.400     0.958     0.200
    19.611     0.103     0.200
    20.084    -0.635     0.200
    25.175     0.468     0.200
    36.561    -0.184     0.200
    41.138     0.245     0.200
    41.605     0.679     0.200
    51.737     0.394     0.200
    87.527    -0.199     0.200
    19.415     0.919     0.200
    19.604     1.146     0.200
    20.087     1.323     0.200
    25.177    -0.545     0.200
    36.522    -0.303     0.200
    51.778    -0.232     0.200
    87.487    -0.110     0.200
    17.238     2.066     0.200
    17.474     3.473     0.200
    19.407     0.958     0.200
    19.411    -0.849     0.200
    19.411     0.862     0.200
    19.411     0.022     0.200
    19.493    -0.438     0.200
    19.493    -0.746     0.200
    19.670    -0.193     0.200
    19.670     0.131     0.200
    19.670     0.085     0.200
    19.670    -0.216     0.200
    20.121     1.364     0.200
    20.227    -0.699     0.200
    20.227     1.051     0.200
    20.227     1.153     0.200
    20.227     0.133     0.200
    21.169    -0.053     0.200
    21.351     0.890     0.200
    21.523    -0.557     0.200
    21.603     1.583     0.200
    21.918     1.806     0.200
    21.918     0.982     0.200
    21.918     1.912     0.200
    21.918     1.373     0.200
    21.956     2.894     0.200
    22.003     0.599     0.200
    22.587     1.178     0.200
    22.978     1.123     0.200
    22.978     2.334     0.200
    22.978     0.783     0.200
    22.978     1.584     0.200
    22.978     2.834     0.200
    24.100     1.092     0.200
    25.212     0.210     0.200
    25.212    -0.232     0.200
    25.271     0.029     0.200
    25.271     1.498     0.200
    25.376     2.269     0.200
    28.570     1.179     0.200
    28.570    -0.399     0.200
    28.570    -0.059     0.200
    30.407     3.850     0.200
    35.559     1.369     0.200
    35.559    -0.744     0.200
    36.003     2.458     0.200
    36.667    -0.220     0.200
    37.613     2.243     0.200
    40.093     0.398     0.200
    41.182     1.102     0.200
    41.527     0.530     0.200
    46.653     0.915     0.200
    51.634     0.562     0.200
    51.634     0.113     0.200
    52.243     0.389     0.200
    52.243     1.420     0.200
    52.523     0.647     0.200
    87.631    -0.477     0.200
    87.631    -0.028     0.200
    89.603    -0.938     0.200
    18.118     1.383     0.200
    19.327    -0.456     0.200
    19.331     1.207     0.200
    19.381     0.540     0.200
    19.557     0.113     0.200
    20.020     1.551     0.200
    21.873     0.390     0.200
    21.873     1.297     0.200
    23.056     1.725     0.200
    25.110     0.022     0.200
    28.607     0.303     0.200
    35.171     0.628     0.200
    35.443     0.497     0.200
    36.583    -0.273     0.200
    40.110    -0.038     0.200
    41.076    -0.136     0.200
    41.542    -0.184     0.200
    48.480     0.318     0.200
    51.704    -1.370     0.200
    52.406     0.652     0.200
    87.561    -0.806     0.200
    89.538    -0.524     0.200
    17.279     2.245     0.200
    18.949     0.819     0.200
    19.319    -0.356     0.200
    19.323    -0.579     0.200
    19.323    -0.329     0.200
    19.323     0.220     0.200
    19.344    -0.451     0.200
    19.344    -0.201     0.200
    19.344    -1.438     0.200
    19.521    -0.538     0.200
    19.521     0.012     0.200
    19.521     1.012     0.200
    19.521     0.513     0.200
    19.521     0.001     0.200
    19.755     1.553     0.200
    19.995     1.059     0.200
    20.102     0.251     0.200
    20.102    -0.579     0.200
    20.102    -1.216     0.200
    20.102     1.489     0.200
    20.479    -0.699     0.200
    20.623    -0.732     0.200
    20.882    -0.301     0.200
    20.920    -0.090     0.200
    21.003     0.525     0.200
    21.018    -0.347     0.200
    21.373    -0.091     0.200
    21.352     0.150     0.200
    21.887     1.555     0.200
    21.887     0.147     0.200
    21.887     1.286     0.200
    22.120     0.295     0.200
    22.206     2.182     0.200
    22.143     1.351     0.200
    22.151     2.442     0.200
    22.151     0.132     0.200
    22.410     3.531     0.200
    22.645    -1.105     0.200
    23.112     2.072     0.200
    23.115     0.540     0.200
    23.115     0.841     0.200
    23.115     1.990     0.200
    23.115     0.502     0.200
    23.115     2.640     0.200
    23.388    -0.237     0.200
    23.520     0.603     0.200
    23.520     0.433     0.200
    23.640     0.449     0.200
    23.667     1.900     0.200
    23.646     1.862     0.200
    23.774     1.253     0.200
    23.954     1.275     0.200
    24.347     0.091     0.200
    25.085     0.565     0.200
    25.085     0.415     0.200
    25.110     0.948     0.200
    26.951     0.574     0.200
    27.009     1.450     0.200
    27.009     2.039     0.200
    28.613     0.807     0.200
    28.638     1.182     0.200
    28.656     0.977     0.200
    28.656     0.927     0.200
    28.663     0.945     0.200
    28.663     0.285     0.200
    28.663     0.836     0.200
    28.666     0.732     0.200
    28.756     0.935     0.200
    29.274     0.935     0.200
    29.349     1.155     0.200
    29.421     3.514     0.200
    30.256     1.840     0.200
    30.314     0.465     0.200
    30.317     1.795     0.200
    30.358     1.635     0.200
    30.931     2.023     0.200
    31.450     2.401     0.200
    31.586     2.402     0.200
    31.685     1.256     0.200
    31.837     2.027     0.200
    31.856    -0.692     0.200
    32.165     2.557     0.200
    32.224     2.594     0.200
    32.352     1.077     0.200
    32.397     0.014     0.200
    32.454     2.052     0.200
    32.661     2.064     0.200
    32.939     0.631     0.200
    33.049     2.177     0.200
    33.242     1.985     0.200
    33.290    -0.634     0.200
    33.404     1.748     0.200
    33.404    -0.551     0.200
    33.383     0.551     0.200
    33.513     0.300     0.200
    33.610     0.157     0.200
    33.849     2.760     0.200
    33.849     3.469     0.200
    33.887     2.454     0.200
    33.887     0.495     0.200
    33.961     2.226     0.200
    34.261     2.846     0.200
    34.342     3.415     0.200
    34.571     1.205     0.200
    34.924     2.431     0.200
    34.940     1.706     0.200
    34.982     0.181     0.200
    35.121     1.679     0.200
    35.136     2.205     0.200
    35.208     0.765     0.200
    35.208     0.636     0.200
    35.276     1.731     0.200
    35.298     2.393     0.200
    35.399     0.188     0.200
    35.399    -0.288     0.200
    35.406     1.034     0.200
    35.397     1.463     0.200
    35.436     2.080     0.200
    35.539     2.042     0.200
    35.595     2.505     0.200
    35.677     1.786     0.200
    35.681     3.071     0.200
    35.681     2.681     0.200
    35.843     1.497     0.200
    35.843     1.878     0.200
    36.101     1.471     0.200
    36.098     1.620     0.200
    36.230     2.348     0.200
    36.278     1.142     0.200
    36.333     1.764     0.200
    36.328     0.423     0.200
    36.328     0.274     0.200
    36.332     0.210     0.200
    36.358     1.565     0.200
    36.458     1.474     0.200
    36.534     1.646     0.200
    36.534     0.315     0.200
    36.523    -0.778     0.200
    36.523     0.212     0.200
    36.523    -0.778     0.200
    36.587     2.686     0.200
    36.537     0.338     0.200
    36.621     1.604     0.200
    36.621     2.262     0.200
    36.630     2.311     0.200
    36.695     2.201     0.200
    36.782     0.460     0.200
    36.752     3.021     0.200
    36.802     1.204     0.200
    36.774     1.526     0.200
    36.774     0.426     0.200
    36.774     1.672     0.200
    36.836    -1.012     0.200
    36.774     1.460     0.200
    36.801     1.540     0.200
    36.876     1.442     0.200
    36.929     1.878     0.200
    37.047     1.634     0.200
    37.353     0.779     0.200
    37.416     1.272     0.200
    37.420     2.253     0.200
    37.528     0.816     0.200
    37.520    -0.434     0.200
    37.654     1.805     0.200
    37.654     1.534     0.200
    37.668     0.025     0.200
    37.707     2.661     0.200
    37.805     1.800     0.200
    37.966     1.738     0.200
    38.007     0.809     0.200
    38.040     1.086     0.200
    38.044     1.348     0.200
    38.070     0.890     0.200
    38.071     1.329     0.200
    38.084     0.064     0.200
    38.084     1.705     0.200
    38.102    -0.379     0.200
    38.095     1.339     0.200
    38.132     1.450     0.200
    38.265     1.581     0.200
    38.309     1.593     0.200
    38.406     1.253     0.200
    38.466     0.501     0.200
    38.638     1.938     0.200
    38.641     1.317     0.200
    38.715     1.376     0.200
    38.739     1.567     0.200
    38.794     2.417     0.200
    38.822     1.406     0.200
    38.875    -0.182     0.200
    38.993     2.054     0.200
    38.998     2.301     0.200
    39.096     0.803     0.200
    39.050     0.234     0.200
    39.147     1.505     0.200
    39.194     2.670     0.200
    38.884     2.367     0.200
    39.178     0.316     0.200
    39.246     0.060     0.200
    39.421     0.954     0.200
    39.462     1.521     0.200
    39.520     2.149     0.200
    39.555     2.352     0.200
    39.693     2.292     0.200
    39.784     0.289     0.200
    39.834     1.089     0.200
    39.856     1.687     0.200
    39.934     1.484     0.200
    39.950     1.252     0.200
    40.041     1.773     0.200
    40.041     1.904     0.200
    40.014     0.082     0.200
    40.043     0.621     0.200
    40.090     1.176     0.200
    40.151     0.996     0.200
    40.286     0.052     0.200
    40.286    -0.489     0.200
    40.345     0.575     0.200
    40.422     1.777     0.200
    40.456     0.319     0.200
    40.582     1.374     0.200
    40.637     0.420     0.200
    40.617     0.657     0.200
    40.654     2.039     0.200
    40.662     2.195     0.200
    41.047     0.441     0.200
    41.047    -0.153     0.200
    41.032     0.091     0.200
    41.059     1.105     0.200
    41.091     0.742     0.200
    41.251     0.312     0.200
    41.347     0.574     0.200
    41.347     0.853     0.200
    41.389     0.305     0.200
    41.480     1.985     0.200
    41.535     1.081     0.200
    41.551     0.233     0.200
    41.562     0.035     0.200
    41.545     0.240     0.200
    41.583     0.513     0.200
    41.583    -0.287     0.200
    41.583     0.613     0.200
    41.583     0.763     0.200
    41.595     0.672     0.200
    41.625     0.587     0.200
    41.717     1.815     0.200
    41.781     1.475     0.200
    41.752    -0.068     0.200
    41.782     0.753     0.200
    41.868     1.183     0.200
    42.021     1.165     0.200
    42.192     1.677     0.200
    42.229     1.185     0.200
    42.262     1.073     0.200
    42.336     1.411     0.200
    42.416     1.392     0.200
    42.425     1.106     0.200
    42.425    -0.294     0.200
    42.430     0.502     0.200
    42.474     1.278     0.200
    42.494     1.234     0.200
    42.470     1.037     0.200
    42.597     1.302     0.200
    42.626     1.210     0.200
    42.645     0.669     0.200
    42.479     1.118     0.200
    42.479     0.294     0.200
    42.664     1.152     0.200
    42.618     0.642     0.200
    42.620     1.626     0.200
    42.620     0.671     0.200
    42.620     2.052     0.200
    42.841     1.737     0.200
    42.809     1.080     0.200
    42.939     0.981     0.200
    42.953     0.278     0.200
    42.992     1.734     0.200
    43.130     1.204     0.200
    43.125     1.381     0.200
    43.354     1.242     0.200
    43.546     3.040     0.200
    43.550     2.121     0.200
    43.629     1.168     0.200
    43.657     1.201     0.200
    43.988     1.464     0.200
    43.960     1.404     0.200
    44.131     1.807     0.200
    44.264     1.197     0.200
    44.348     1.384     0.200
    44.484     1.642     0.200
    44.486     1.756     0.200
    44.455     0.627     0.200
    44.455     0.037     0.200
    44.710     0.551     0.200
    45.568     0.403     0.200
    45.671     1.173     0.200
    45.671     0.083     0.200
    45.671     0.882     0.200
    45.671     0.682     0.200
    46.074    -0.135     0.200
    46.072    -0.229     0.200
    46.396     0.700     0.200
    47.178     2.437     0.200
    47.515     0.423     0.200
    47.593     0.526     0.200
    47.733     0.707     0.200
    47.733     1.132     0.200
    48.324     0.355     0.200
    48.528     0.859     0.200
    48.555     1.396     0.200
    48.555     2.677     0.200
    48.538     1.014     0.200
    48.727     1.400     0.200
    48.889     0.640     0.200
    48.889     0.979     0.200
    48.889     1.290     0.200
    49.343     0.930     0.200
    49.706     0.631     0.200
    50.254     0.813     0.200
    50.254     0.393     0.200
    50.351     0.873     0.200
    50.351     0.203     0.200
    50.475     0.721     0.200
    50.456     0.655     0.200
    50.836     0.362     0.200
    50.950     0.389     0.200
    51.035     2.305     0.200
    51.637     1.190     0.200
    51.721     0.761     0.200
    51.769     1.000     0.200
    51.760     0.331     0.200
    51.761     0.461     0.200
    51.761     0.220     0.200
    52.087     0.535     0.200
    52.083     0.362     0.200
    52.083     0.551     0.200
    52.348     2.092     0.200
    52.354     0.745     0.200
    52.664     0.448     0.200
    52.995    -0.505     0.200
    53.145     0.769     0.200
    53.405    -0.519     0.200
    53.405    -1.068     0.200
    53.405    -0.549     0.200
    54.176     1.255     0.200
    54.303     0.596     0.200
    54.445     0.595     0.200
    54.445     0.175     0.200
    54.595     0.682     0.200
    54.688     0.241     0.200
    54.910     0.807     0.200
    55.110     0.429     0.200
    55.184     1.974     0.200
    56.501     0.208     0.200
    57.304     1.077     0.200
    59.142     0.128     0.200
    59.142     0.337     0.200
    60.364     1.721     0.200
    62.001     3.133     0.200
    63.439     1.662     0.200
    66.693     0.593     0.200
    67.227    -0.650     0.200
    67.227    -0.127     0.200
    68.194     1.246     0.200
    68.194     0.246     0.200
    68.194     1.377     0.200
    68.651     0.218     0.200
    68.651    -0.333     0.200
    70.093    -1.716     0.200
    71.867    -0.530     0.200
    71.867    -0.280     0.200
    75.968     0.158     0.200
    76.515     0.015     0.200
    76.646     0.434     0.200
    76.705     0.845     0.200
    76.705    -0.185     0.200
    77.458     0.578     0.200
    78.088     0.910     0.200
    78.088     0.480     0.200
    78.352     0.267     0.200
    78.352     0.116     0.200
    78.411     0.349     0.200
    79.251     0.870     0.200
    80.779     0.428     0.200
    80.822     0.249     0.200
    80.964    -0.078     0.200
    83.163     0.025     0.200
    83.163    -0.356     0.200
    83.163     0.374     0.200
    83.441     0.504     0.200
    83.441     0.164     0.200
    83.540     0.583     0.200
    87.503    -0.117     0.200
    87.503    -0.387     0.200
    87.506    -0.129     0.200
    89.482    -0.021     0.200
    89.482     0.319     0.200
    89.930    -0.189     0.200
    90.005     0.182     0.200
    91.810     0.464     0.200
    14.752     8.456     0.200
    17.259     2.119     0.200
    18.918     1.169     0.200
    19.344     0.264     0.200
    19.348    -1.546     0.200
    19.348    -0.585     0.200
    19.348    -0.155     0.200
    19.382    -0.911     0.200
    19.382    -1.598     0.200
    19.382    -0.212     0.200
    19.398     1.272     0.200
    19.558     0.197     0.200
    19.558     0.822     0.200
    19.558     0.021     0.200
    19.558    -0.557     0.200
    19.597     0.999     0.200
    20.028     0.744     0.200
    20.028    -0.483     0.200
    20.135     1.229     0.200
    20.135    -0.349     0.200
    20.135     0.530     0.200
    20.199     2.153     0.200
    20.445     0.161     0.200
    21.050     0.871     0.200
    21.233     0.327     0.200
    21.323     1.653     0.200
    21.410    -0.379     0.200
    21.838     0.935     0.200
    21.900     1.315     0.200
    21.900     0.073     0.200
    21.900     0.971     0.200
    22.112     0.600     0.200
    22.114     2.288     0.200
    22.114     1.909     0.200
    22.291     2.640     0.200
    22.469     2.497     0.200
    22.659     0.567     0.200
    23.086     1.757     0.200
    23.086     1.910     0.200
    23.086     1.398     0.200
    23.086     2.460     0.200
    23.378    -0.112     0.200
    23.367     1.653     0.200
    23.367     1.505     0.200
    23.487     1.175     0.200
    23.630     1.649     0.200
    23.617     3.056     0.200
    23.646     3.113     0.200
    23.745     1.508     0.200
    23.991     0.957     0.200
    24.338     0.585     0.200
    25.118     0.483     0.200
    25.118     0.182     0.200
    25.118     0.080     0.200
    25.146     1.191     0.200
    25.381     1.340     0.200
    25.381     1.188     0.200
    26.060     0.715     0.200
    26.753     1.980     0.200
    26.946     2.338     0.200
    27.003     1.493     0.200
    27.003     1.825     0.200
    28.598     1.361     0.200
    28.623     0.836     0.200
    28.640     0.980     0.200
    28.640     0.019     0.200
    28.640     0.480     0.200
    28.640     0.281     0.200
    28.647     1.020     0.200
    28.647     0.298     0.200
    28.647     1.419     0.200
    28.647     0.809     0.200
    28.651     0.885     0.200
    28.741     0.588     0.200
    28.920     3.142     0.200
    29.257     0.199     0.200
    29.322     1.685     0.200
    29.398     3.671     0.200
    29.398     2.394     0.200
    30.294     0.768     0.200
    30.295     2.423     0.200
    30.398     1.900     0.200
    30.909     2.141     0.200
    30.949     0.339     0.200
    31.430     2.284     0.200
    31.564     2.814     0.200
    31.816     2.991     0.200
    32.145     2.239     0.200
    32.334     1.673     0.200
    32.431     2.049     0.200
    33.223     2.866     0.200
    33.355     0.616     0.200
    33.393     1.642     0.200
    33.393     0.255     0.200
    33.393     1.282     0.200
    33.616    -0.696     0.200
    33.830     3.318     0.200
    33.867     2.189     0.200
    33.905     2.204     0.200
    34.000     2.199     0.200
    34.323     2.197     0.200
    34.549     2.057     0.200
    34.918     1.433     0.200
    35.115     1.247     0.200
    35.160     2.269     0.200
    35.204     1.196     0.200
    35.204     1.087     0.200
    35.270     1.690     0.200
    35.376     1.873     0.200
    35.438     1.034     0.200
    35.438     0.643     0.200
    35.451     1.460     0.200
    35.455     3.044     0.200
    35.515     1.641     0.200
    35.515     1.134     0.200
    35.658     1.924     0.200
    35.661     2.491     0.200
    35.661     2.761     0.200
    35.882     1.850     0.200
    35.882     0.221     0.200
    36.074     1.564     0.200
    36.257     1.752     0.200
    36.313     1.695     0.200
    36.359    -0.022     0.200
    36.359    -0.163     0.200
    36.363    -0.145     0.200
    36.394     1.578     0.200
    36.516     2.657     0.200
    36.516     1.099     0.200
    36.553     0.068     0.200
    36.553    -0.033     0.200
    36.568    -0.504     0.200
    36.566     1.467     0.200
    36.586    -0.062     0.200
    36.604     1.812     0.200
    36.612     2.470     0.200
    36.697     1.347     0.200
    36.753     1.583     0.200
    36.746    -0.147     0.200
    36.787     1.408     0.200
    36.787     1.029     0.200
    36.877     1.258     0.200
    36.909     1.699     0.200
    36.930     1.710     0.200
    37.065     1.702     0.200
    37.351     1.019     0.200
    37.394     1.845     0.200
    37.399     2.016     0.200
    37.553    -1.074     0.200
    37.634     1.569     0.200
    37.634     1.272     0.200
    37.650     0.125     0.200
    37.786     1.579     0.200
    37.969     1.610     0.200
    38.018     1.154     0.200
    38.048     1.047     0.200
    38.064     0.947     0.200
    38.064     0.772     0.200
    38.073     1.314     0.200
    38.085    -0.185     0.200
    38.110     1.813     0.200
    38.164     1.318     0.200
    38.233     0.919     0.200
    38.266     1.732     0.200
    38.351     1.855     0.200
    38.471     0.966     0.200
    38.620     1.371     0.200
    38.640     1.621     0.200
    38.694     1.237     0.200
    38.721     1.970     0.200
    38.800     1.046     0.200
    38.852     0.950     0.200
    39.078     1.497     0.200
    39.078     1.067     0.200
    39.098     2.173     0.200
    38.915     2.858     0.200
    39.208     1.852     0.200
    39.400     0.626     0.200
    39.406     0.850     0.200
    39.536     2.229     0.200
    39.676     2.211     0.200
    39.839     1.725     0.200
    39.918     1.717     0.200
    40.021     0.926     0.200
    40.045     1.022     0.200
    40.051     1.450     0.200
    40.092     1.290     0.200
    40.143     1.283     0.200
    40.289     1.217     0.200
    40.289     0.303     0.200
    40.350     1.300     0.200
    40.350     0.409     0.200
    40.435     0.768     0.200
    40.584     0.844     0.200
    40.595     0.669     0.200
    40.609     1.124     0.200
    40.637     2.360     0.200
    40.647     2.263     0.200
    41.040     1.119     0.200
    41.082     0.248     0.200
    41.082    -0.252     0.200
    41.228     0.336     0.200
    41.339     0.577     0.200
    41.339     0.538     0.200
    41.418    -0.189     0.200
    41.484     1.851     0.200
    41.524     0.276     0.200
    41.544    -0.006     0.200
    41.555     0.363     0.200
    41.575     0.192     0.200
    41.575     0.520     0.200
    41.570     0.657     0.200
    41.604     0.682     0.200
    41.719     1.288     0.200
    41.754     0.628     0.200
    41.754    -0.231     0.200
    41.781     1.520     0.200
    41.783     0.390     0.200
    41.862     0.911     0.200
    42.002     0.319     0.200
    42.193     1.182     0.200
    42.228     0.569     0.200
    42.260     1.146     0.200
    42.315     2.377     0.200
    42.393     0.597     0.200
    42.404     0.872     0.200
    42.404     0.598     0.200
    42.446     0.899     0.200
    42.494     0.954     0.200
    42.594     1.014     0.200
    42.589     1.965     0.200
    42.624     1.204     0.200
    42.622     2.216     0.200
    42.645     1.567     0.200
    42.786     1.433     0.200
    42.806     1.057     0.200
    42.929     0.773     0.200
    43.024     2.589     0.200
    43.118     0.263     0.200
    43.108     1.136     0.200
    43.091     0.608     0.200
    43.330     1.204     0.200
    43.540     2.239     0.200
    43.610     2.634     0.200
    44.432     0.907     0.200
    44.432     0.567     0.200
    44.463     2.106     0.200
    44.689     0.798     0.200
    45.541     0.281     0.200
    45.634     0.885     0.200
    46.049    -0.123     0.200
    46.372     0.765     0.200
    47.185     2.099     0.200
    47.494     0.315     0.200
    47.741     0.312     0.200
    48.514     0.558     0.200
    48.514     0.556     0.200
    48.897     1.323     0.200
    48.897     0.163     0.200
    49.181     0.884     0.200
    49.323     0.028     0.200
    50.219     0.338     0.200
    50.283     0.384     0.200
    50.283    -0.476     0.200
    50.283    -0.761     0.200
    50.283     0.594     0.200
    50.315     0.872     0.200
    50.315     0.243     0.200
    50.433     0.620     0.200
    50.859     0.544     0.200
    51.021     0.457     0.200
    51.735     0.496     0.200
    51.735    -0.090     0.200
    52.057     0.272     0.200
    52.057     0.580     0.200
    52.125    -0.191     0.200
    52.125     0.368     0.200
    52.394    -0.682     0.200
    52.394     0.415     0.200
    52.637     0.644     0.200
    53.121     0.862     0.200
    53.445    -0.315     0.200
    54.151     1.425     0.200
    54.312     0.776     0.200
    54.450     0.668     0.200
    54.565     0.704     0.200
    54.662     0.604     0.200
    55.084     0.642     0.200
    55.238     0.100     0.200
    57.274     0.148     0.200
    58.177    -2.013     0.200
    59.984     1.231     0.200
    60.367     1.650     0.200
    60.447     0.925     0.200
    67.189    -0.439     0.200
    68.156    -0.192     0.200
    71.833    -1.011     0.200
    73.702     0.104     0.200
    74.405     0.381     0.200
    75.093     0.255     0.200
    75.992    -0.036     0.200
    78.111     0.948     0.200
    78.111     0.569     0.200
    78.375     0.154     0.200
    78.375    -0.186     0.200
    79.273     0.299     0.200
    80.028    -0.156     0.200
    80.802     0.146     0.200
    83.178     0.366     0.200
    83.467     0.974     0.200
    84.055     0.095     0.200
    87.529    -0.724     0.200
    89.506    -0.216     0.200
    89.506     0.182     0.200
    14.773     4.241     0.200
    17.272     1.995     0.200
    17.451     1.354     0.200
    18.016     1.473     0.200
    18.223     1.493     0.200
    19.052    -0.531     0.200
    19.248     0.121     0.200
    19.302     0.283     0.200
    19.306    -0.595     0.200
    19.306    -0.024     0.200
    19.330    -0.969     0.200
    19.330    -1.961     0.200
    19.330     0.219     0.200
    19.330    -0.789     0.200
    19.434     1.289     0.200
    19.489     0.340     0.200
    19.506    -0.885     0.200
    19.506    -0.108     0.200
    19.506     0.143     0.200
    19.565     0.853     0.200
    19.746     1.671     0.200
    19.979     1.711     0.200
    20.086     0.672     0.200
    20.086     0.020     0.200
    20.086    -0.250     0.200
    20.086     1.625     0.200
    20.607    -1.457     0.200
    21.019    -0.858     0.200
    21.202     0.573     0.200
    21.359    -0.218     0.200
    21.370     2.060     0.200
    21.452     0.680     0.200
    21.611     3.820     0.200
    21.806     0.682     0.200
    21.828     1.298     0.200
    21.871     1.454     0.200
    21.871     0.907     0.200
    21.871     1.184     0.200
    22.108     0.245     0.200
    22.145     2.282     0.200
    22.153     2.001     0.200
    22.153     1.615     0.200
    22.189     1.683     0.200
    22.331     1.911     0.200
    22.413     1.676     0.200
    22.413     2.086     0.200
    22.438     1.231     0.200
    22.654    -0.620     0.200
    22.654     1.161     0.200
    22.865     3.257     0.200
    23.096     0.903     0.200
    23.109     1.226     0.200
    23.112     1.894     0.200
    23.112     2.343     0.200
    23.112     1.074     0.200
    23.112     1.792     0.200
    23.161     1.169     0.200
    23.377    -0.596     0.200
    23.424    -0.815     0.200
    23.409     1.600     0.200
    23.409     2.760     0.200
    23.521     0.435     0.200
    23.521     0.615     0.200
    23.521     2.087     0.200
    23.628     1.751     0.200
    23.643     1.574     0.200
    23.660     1.959     0.200
    23.771     1.519     0.200
    23.771     0.327     0.200
    23.902     0.505     0.200
    23.939     1.302     0.200
    24.315     1.294     0.200
    24.335     0.597     0.200
    25.026    -0.175     0.200
    25.069     0.607     0.200
    25.069     0.556     0.200
    25.069    -0.472     0.200
    25.108     1.214     0.200
    25.314     2.558     0.200
    25.360     1.560     0.200
    25.360     1.357     0.200
    25.531     1.207     0.200
    25.531     0.926     0.200
    25.987     0.212     0.200
    26.384    -0.590     0.200
    26.446     0.095     0.200
    26.874     0.276     0.200
    26.938     0.384     0.200
    26.997     1.555     0.200
    26.997     1.387     0.200
    26.997     0.855     0.200
    27.368     1.922     0.200
    27.522     0.735     0.200
    27.575    -0.835     0.200
    27.584     1.680     0.200
    27.751     1.294     0.200
    27.838     1.049     0.200
    27.838     1.908     0.200
    28.055     1.669     0.200
    28.096     0.269     0.200
    28.175     3.334     0.200
    28.365     1.808     0.200
    28.603     0.886     0.200
    28.629     0.861     0.200
    28.646     0.928     0.200
    28.646     0.194     0.200
    28.646     0.905     0.200
    28.646     1.104     0.200
    28.653     0.913     0.200
    28.653     0.132     0.200
    28.653     1.241     0.200
    28.653     1.445     0.200
    28.732     0.251     0.200
    28.747     2.203     0.200
    28.802     0.560     0.200
    28.893     2.866     0.200
    28.935     2.406     0.200
    28.935     2.937     0.200
    28.941     3.948     0.200
    28.940     2.090     0.200
    28.986     3.282     0.200
    28.986     3.301     0.200
    29.040     0.510     0.200
    29.120     0.386     0.200
    29.161     3.949     0.200
    29.173     2.161     0.200
    29.249     2.998     0.200
    29.265     1.009     0.200
    29.301     1.316     0.200
    29.346     1.543     0.200
    29.414     2.912     0.200
    29.874     1.884     0.200
    30.030     2.330     0.200
    30.242     2.755     0.200
    30.289     2.233     0.200
    30.311     1.945     0.200
    30.311     2.378     0.200
    30.349     2.203     0.200
    30.768     2.923     0.200
    30.949     0.606     0.200
    30.925     1.459     0.200
    30.925     2.088     0.200
    31.117     2.230     0.200
    31.196     1.827     0.200
    31.288     1.642     0.200
    31.300     1.532     0.200
    31.443     2.388     0.200
    31.472     3.154     0.200
    31.548     1.718     0.200
    31.549     2.279     0.200
    31.580     2.349     0.200
    31.614     1.454     0.200
    31.674     1.296     0.200
    31.830     2.129     0.200
    31.830     2.551     0.200
    31.858     0.287     0.200
    32.157     1.907     0.200
    32.252     2.113     0.200
    32.294     2.879     0.200
    32.311     1.997     0.200
    32.343     1.703     0.200
    32.343     2.152     0.200
    32.447     1.841     0.200
    32.447     2.329     0.200
    32.463     2.671     0.200
    32.479     2.107     0.200
    32.479     2.954     0.200
    32.485     2.688     0.200
    32.518     1.618     0.200
    33.042     2.156     0.200
    33.254     1.810     0.200
    33.280    -0.773     0.200
    33.280    -0.465     0.200
    33.350     1.116     0.200
    33.380     0.269     0.200
    33.393     1.536     0.200
    33.393     0.536     0.200
    33.553     3.173     0.200
    33.567     2.596     0.200
    33.587    -1.887     0.200
    33.840     3.200     0.200
    33.840     3.641     0.200
    33.880     2.018     0.200
    34.039     0.926     0.200
    34.248     2.914     0.200
    34.248     2.523     0.200
    34.248     2.156     0.200
    34.334     1.976     0.200
    34.413     0.691     0.200
    34.564     1.413     0.200
    34.564     1.976     0.200
    34.925     2.314     0.200
    34.934     1.452     0.200
    35.117     0.810     0.200
    35.129     1.542     0.200
    35.195     1.700     0.200
    35.263     1.510     0.200
    35.289     2.193     0.200
    35.386     1.186     0.200
    35.386     0.967     0.200
    35.391     1.713     0.200
    35.428     2.087     0.200
    35.467     2.305     0.200
    35.467     2.063     0.200
    35.533     1.510     0.200
    35.551     3.587     0.200
    35.587     2.759     0.200
    35.668     1.684     0.200
    35.668     2.364     0.200
    35.673     2.152     0.200
    35.673     2.023     0.200
    35.830     1.672     0.200
    35.830     1.864     0.200
    35.830     1.352     0.200
    35.830     1.544     0.200
    35.871     1.947     0.200
    36.053    -0.464     0.200
    36.093     1.619     0.200
    36.093     0.826     0.200
    36.196     1.770     0.200
    36.196     1.238     0.200
    36.223     1.634     0.200
    36.271     1.524     0.200
    36.330     0.057     0.200
    36.330     0.311     0.200
    36.330    -0.173     0.200
    36.334     0.165     0.200
    36.325     1.520     0.200
    36.325     1.305     0.200
    36.356     0.369     0.200
    36.361     0.194     0.200
    36.396     2.554     0.200
    36.451     1.564     0.200
    36.525    -0.075     0.200
    36.525     0.136     0.200
    36.525    -0.005     0.200
    36.526     2.185     0.200
    36.526     0.924     0.200
    36.579     1.582     0.200
    36.613     2.034     0.200
    36.613     2.456     0.200
    36.621     2.223     0.200
    36.621     2.012     0.200
    36.648     1.512     0.200
    36.681     1.126     0.200
    36.727     1.808     0.200
    36.743     2.542     0.200
    36.743     2.671     0.200
    36.767     0.778     0.200
    36.767     1.571     0.200
    36.767     1.385     0.200
    36.767     1.787     0.200
    36.797     0.899     0.200
    36.821     0.204     0.200
    36.862     1.264     0.200
    36.921     1.850     0.200
    37.039     1.418     0.200
    37.039     1.617     0.200
    37.080     1.621     0.200
    37.339     1.183     0.200
    37.410     1.474     0.200
    37.410     1.611     0.200
    37.414     2.156     0.200
    37.476     1.587     0.200
    37.511     1.499     0.200
    37.511     0.046     0.200
    37.511     1.347     0.200
    37.647     1.322     0.200
    37.647     1.459     0.200
    37.660    -0.097     0.200
    37.699     1.886     0.200
    37.797     1.454     0.200
    37.797     1.621     0.200
    37.951     1.722     0.200
    37.978     2.092     0.200
    37.996     1.336     0.200
    38.034     0.938     0.200
    38.037     1.351     0.200
    38.064     1.021     0.200
    38.064     1.411     0.200
    38.067     1.520     0.200
    38.077     1.389     0.200
    38.077     0.314     0.200
    38.089     1.371     0.200
    38.094    -0.422     0.200
    38.125     1.375     0.200
    38.127     1.083     0.200
    38.176     1.040     0.200
    38.208     0.397     0.200
    38.208     0.545     0.200
    38.250     1.842     0.200
    38.247     1.550     0.200
    38.299     1.479     0.200
    38.324    -0.428     0.200
    38.372     1.698     0.200
    38.397     1.678     0.200
    38.459     0.445     0.200
    38.459     0.613     0.200
    38.624     1.688     0.200
    38.634     1.264     0.200
    38.635     1.172     0.200
    38.708     1.001     0.200
    38.730     1.756     0.200
    38.784     2.307     0.200
    38.815     1.111     0.200
    38.868     0.787     0.200
    38.985     2.138     0.200
    38.990     1.866     0.200
    39.000     2.235     0.200
    39.000     1.415     0.200
    39.054    -0.038     0.200
    39.085     0.990     0.200
    39.109     1.581     0.200
    39.137     1.560     0.200
    38.886     2.381     0.200
    39.186     2.095     0.200
    39.236     0.229     0.200
    39.347     1.560     0.200
    39.414     0.872     0.200
    39.421     0.834     0.200
    39.455     0.481     0.200
    39.461     1.841     0.200
    39.475     1.045     0.200
    39.488     2.192     0.200
    39.513     1.499     0.200
    39.520     1.560     0.200
    39.520     1.568     0.200
    39.546     2.038     0.200
    39.599     1.952     0.200
    39.613     1.294     0.200
    39.684     1.620     0.200
    39.683     2.543     0.200
    39.710     2.248     0.200
    39.706     0.535     0.200
    39.743     1.875     0.200
    39.777     0.221     0.200
    39.823     1.485     0.200
    39.847     1.456     0.200
    39.850     0.222     0.200
    39.925     1.165     0.200
    39.939     1.518     0.200
    39.980     1.930     0.200
    40.007     0.632     0.200
    40.007     0.321     0.200
    40.026     1.306     0.200
    40.036     0.651     0.200
    40.076     1.363     0.200
    40.139     1.543     0.200
    40.252     1.871     0.200
    40.271     1.385     0.200
    40.271     0.639     0.200
    40.334     1.561     0.200
    40.365     0.992     0.200
    40.413     2.034     0.200
    40.449     0.644     0.200
    40.567     0.460     0.200
    40.610     0.619     0.200
    40.626     0.647     0.200
    40.645     2.135     0.200
    40.652     2.019     0.200
    40.769    -0.065     0.200
    40.998     1.952     0.200
    41.003     0.451     0.200
    41.032     0.626     0.200
    41.032    -0.081     0.200
    41.052     1.573     0.200
    41.080     0.221     0.200
    41.247     2.837     0.200
    41.244     0.100     0.200
    41.294     0.967     0.200
    41.335     0.737     0.200
    41.439     0.387     0.200
    41.465     1.604     0.200
    41.539    -0.142     0.200
    41.537     0.052     0.200
    41.551     2.018     0.200
    41.571     0.397     0.200
    41.571    -0.204     0.200
    41.571     0.569     0.200
    41.590     0.476     0.200
    41.619     0.393     0.200
    41.631    -0.226     0.200
    41.632     0.558     0.200
    41.632     1.296     0.200
    41.642     2.233     0.200
    41.702     1.720     0.200
    41.752     0.059     0.200
    41.752    -0.121     0.200
    41.766     1.684     0.200
    41.855     1.320     0.200
    41.991     0.757     0.200
    42.010     1.005     0.200
    42.010    -0.015     0.200
    42.054     1.614     0.200
    42.177     1.200     0.200
    42.215     1.282     0.200
    42.248     2.260     0.200
    42.248     1.317     0.200
    42.295     0.041     0.200
    42.295     0.412     0.200
    42.323     0.370     0.200
    42.324     2.142     0.200
    42.402     1.257     0.200
    42.407     0.205     0.200
    42.417     0.680     0.200
    42.417     0.110     0.200
    42.424    -0.083     0.200
    42.433     1.995     0.200
    42.465     0.706     0.200
    42.480     0.973     0.200
    42.495     1.112     0.200
    42.495     1.354     0.200
    42.495     0.952     0.200
    42.495     0.623     0.200
    42.584     0.566     0.200
    42.588     0.951     0.200
    42.612     1.373     0.200
    42.613     0.828     0.200
    42.630     1.308     0.200
    42.618     2.250     0.200
    42.631     1.955     0.200
    42.650     1.225     0.200
    42.751     0.147     0.200
    42.804     0.478     0.200
    42.828     1.431     0.200
    42.756     2.425     0.200
    42.947     0.704     0.200
    42.980     1.877     0.200
    42.980     1.658     0.200
    43.035     2.054     0.200
    43.035     1.874     0.200
    43.135     0.073     0.200
    43.114     1.813     0.200
    43.123     1.279     0.200
    43.141     1.297     0.200
    43.141     0.949     0.200
    43.348     1.100     0.200
    43.539     2.217     0.200
    43.621     2.174     0.200
    43.880     0.044     0.200
    43.954     0.751     0.200
    44.030     2.017     0.200
    44.126     0.600     0.200
    44.215     2.177     0.200
    44.336     1.479     0.200
    44.415     1.255     0.200
    44.449     0.687     0.200
    44.449     0.547     0.200
    44.472     1.458     0.200
    44.475     1.429     0.200
    44.703     0.516     0.200
    45.010     1.012     0.200
    45.041    -0.137     0.200
    45.564     0.353     0.200
    45.564     0.095     0.200
    45.685     0.023     0.200
    45.685     0.492     0.200
    46.069    -0.023     0.200
    46.067    -0.167     0.200
    46.390     0.632     0.200
    46.780    -1.462     0.200
    47.013     1.615     0.200
    47.162     2.119     0.200
    47.508     0.426     0.200
    47.584     0.796     0.200
    47.717     1.648     0.200
    47.974    -0.058     0.200
    48.518     0.739     0.200
    48.530     0.818     0.200
    48.532     0.766     0.200
    48.545     1.093     0.200
    48.545     0.362     0.200
    48.545     1.831     0.200
    48.545     0.671     0.200
    48.661     1.934     0.200
    48.718     0.807     0.200
    48.873     0.298     0.200
    48.873     1.708     0.200
    48.873     1.321     0.200
    49.129     0.039     0.200
    49.335     0.926     0.200
    49.690     0.318     0.200
    49.690    -0.521     0.200
    49.690    -0.045     0.200
    49.872     0.971     0.200
    50.238     0.487     0.200
    50.238    -0.052     0.200
    50.238     0.366     0.200
    50.238     0.796     0.200
    50.223     1.267     0.200
    50.308     0.564     0.200
    50.353     0.789     0.200
    50.353    -0.020     0.200
    50.451     0.656     0.200
    50.466     0.889     0.200
    50.466     1.272     0.200
    50.842     0.903     0.200
    50.941     0.884     0.200
    51.025     1.405     0.200
    51.025     1.057     0.200
    51.626    -0.054     0.200
    51.628     1.434     0.200
    51.760     1.841     0.200
    51.757     0.396     0.200
    51.757     0.040     0.200
    52.073     0.806     0.200
    52.078    -0.129     0.200
    52.078     0.359     0.200
    52.078     0.461     0.200
    52.225     1.784     0.200
    52.285     0.325     0.200
    52.344     0.072     0.200
    52.344     0.053     0.200
    52.338     1.035     0.200
    52.345     0.943     0.200
    52.424     1.504     0.200
    52.660     0.414     0.200
    52.991    -0.545     0.200
    53.139     0.854     0.200
    53.393     0.003     0.200
    53.393    -0.057     0.200
    53.393    -0.229     0.200
    54.171     1.045     0.200
    54.287     0.684     0.200
    54.430     0.740     0.200
    54.430     0.599     0.200
    54.592     0.343     0.200
    54.684     0.468     0.200
    55.489     0.519     0.200
    55.658     0.840     0.200
    56.107    -1.566     0.200
    56.420     1.557     0.200
    56.499     0.041     0.200
    57.302     0.522     0.200
    58.220     0.186     0.200
    58.218     1.168     0.200
    59.157     0.391     0.200
    59.157     0.562     0.200
    59.157     0.242     0.200
    59.784     0.360     0.200
    59.784     0.621     0.200
    59.784    -0.300     0.200
    59.936     0.119     0.200
    59.992     0.506     0.200
    59.992     1.689     0.200
    59.992     0.916     0.200
    60.349     0.781     0.200
    60.349     1.800     0.200
    60.395     0.040     0.200
    60.397     0.679     0.200
    60.397    -0.172     0.200
    60.842     0.105     0.200
    60.842    -0.415     0.200
    63.423     1.401     0.200
    63.423     0.971     0.200
    63.423     0.651     0.200
    64.046     0.568     0.200
    64.623     1.227     0.200
    66.271    -0.436     0.200
    66.271    -0.710     0.200
    66.823     1.106     0.200
    67.233     0.126     0.200
    67.233    -0.046     0.200
    68.208     0.771     0.200
    68.208     0.552     0.200
    68.666    -0.019     0.200
    68.666     0.453     0.200
    69.524     2.824     0.200
    70.042    -0.648     0.200
    71.119     1.194     0.200
    71.883    -0.040     0.200
    71.883    -0.665     0.200
    72.514    -0.656     0.200
    73.535     0.209     0.200
    74.240     0.081     0.200
    74.923    -0.145     0.200
    75.053     0.235     0.200
    75.538    -1.109     0.200
    76.341    -0.145     0.200
    76.688     0.809     0.200
    76.951    -0.019     0.200
    77.188     0.290     0.200
    77.441     0.210     0.200
    78.071     1.010     0.200
    78.071    -0.318     0.200
    78.335     0.519     0.200
    78.335    -0.161     0.200
    78.551     0.583     0.200
    79.218    -0.241     0.200
    79.234     0.689     0.200
    80.010     0.000     0.200
    80.711     0.029     0.200
    80.762     0.666     0.200
    80.805     1.026     0.200
    83.146     0.739     0.200
    83.146     0.614     0.200
    83.424     1.145     0.200
    83.424     0.586     0.200
    83.523     0.275     0.200
    86.519    -1.233     0.200
    87.508    -0.463     0.200
    89.487    -0.099     0.200
    89.487    -0.717     0.200
    89.914     0.385     0.200
    89.914    -0.373     0.200
    91.814    -0.904     0.200
    92.390     0.202     0.200
    93.223    -0.550     0.200
    93.223    -0.683     0.200
    98.747    -0.485     0.200
    14.793     5.666     0.200
    16.145     5.004     0.200
    16.300     2.427     0.200
    16.873     3.699     0.200
    17.452     1.820     0.200
    17.946     1.665     0.200
    18.265     2.759     0.200
    18.387     1.590     0.200
    18.847     1.185     0.200
    19.048     0.906     0.200
    19.373     0.338     0.200
    19.377     0.390     0.200
    19.377     1.001     0.200
    19.389    -0.711     0.200
    19.389    -0.931     0.200
    19.389     0.386     0.200
    19.389    -0.371     0.200
    19.440     1.106     0.200
    19.558    -0.484     0.200
    19.565    -0.757     0.200
    19.565     0.160     0.200
    19.565    -1.255     0.200
    19.565     0.166     0.200
    19.565    -0.685     0.200
    19.565    -0.555     0.200
    19.563     0.270     0.200
    20.045     0.355     0.200
    20.045     0.494     0.200
    20.087     0.565     0.200
    20.124     0.879     0.200
    20.152     0.042     0.200
    20.152     0.419     0.200
    20.152     0.611     0.200
    20.152     1.573     0.200
    20.234     1.894     0.200
    20.372     1.268     0.200
    20.402     1.475     0.200
    20.411    -0.668     0.200
    20.483     1.924     0.200
    20.556     1.355     0.200
    20.672    -1.347     0.200
    20.952    -0.436     0.200
    20.943     1.620     0.200
    20.925     2.361     0.200
    21.016    -1.367     0.200
    21.016    -1.500     0.200
    21.015     2.429     0.200
    21.199    -0.602     0.200
    21.360     2.426     0.200
    21.417    -0.444     0.200
    21.400     1.734     0.200
    21.451     0.790     0.200
    21.461    -0.651     0.200
    21.804     0.697     0.200
    21.848     2.015     0.200
    21.877     0.805     0.200
    21.939     1.112     0.200
    21.939     0.952     0.200
    21.939     1.562     0.200
    22.136     1.022     0.200
    22.158     0.117     0.200
    22.191    -0.430     0.200
    22.191    -0.760     0.200
    22.141     1.962     0.200
    22.141     2.382     0.200
    22.259     0.641     0.200
    22.318     1.744     0.200
    22.435    -0.837     0.200
    22.399     1.781     0.200
    22.399     2.380     0.200
    22.614    -0.923     0.200
    22.614     1.107     0.200
    22.876     2.327     0.200
    23.086     1.452     0.200
    23.106     2.363     0.200
    23.161     0.175     0.200
    23.121     1.292     0.200
    23.124     1.861     0.200
    23.124    -0.007     0.200
    23.124     1.840     0.200
    23.124     0.760     0.200
    23.124     2.557     0.200
    23.124     1.760     0.200
    23.124     1.160     0.200
    23.153     0.530     0.200
    23.191     1.872     0.200
    23.390     1.681     0.200
    23.390     1.318     0.200
    23.390     1.061     0.200
    23.424     0.311     0.200
    23.424     0.511     0.200
    23.519     0.652     0.200
    23.519     0.912     0.200
    23.519     0.012     0.200
    23.565     0.902     0.200
    23.654     1.385     0.200
    23.676     0.745     0.200
    23.688     2.432     0.200
    23.784     1.171     0.200
    23.784     1.561     0.200
    23.784     1.716     0.200
    23.903     0.732     0.200
    23.873     2.683     0.200
    24.080     0.370     0.200
    24.313     2.642     0.200
    24.384     0.479     0.200
    24.384     0.579     0.200
    24.398     0.882     0.200
    24.413     0.683     0.200
    24.565     1.013     0.200
    24.494     3.217     0.200
    24.915     2.733     0.200
    25.117     0.487     0.200
    25.117     0.240     0.200
    25.117     0.760     0.200
    25.117     1.101     0.200
    25.135     0.771     0.200
    25.135    -0.119     0.200
    25.135    -0.860     0.200
    25.135    -0.010     0.200
    25.135    -0.280     0.200
    25.329     2.002     0.200
    25.387     0.651     0.200
    25.377    -0.093     0.200
    25.424     1.312     0.200
    25.397     0.941     0.200
    25.538     0.876     0.200
    25.538     0.727     0.200
    25.538     1.827     0.200
    25.583     0.480     0.200
    25.750     0.849     0.200
    25.979     2.415     0.200
    25.985     0.068     0.200
    26.095     0.494     0.200
    26.387    -0.021     0.200
    26.387    -0.271     0.200
    26.450     0.560     0.200
    26.735     1.749     0.200
    26.875    -0.798     0.200
    26.833     0.243     0.200
    26.974     3.031     0.200
    27.048     1.327     0.200
    27.048     2.228     0.200
    27.048     1.067     0.200
    27.048     0.775     0.200
    27.071     3.201     0.200
    27.060     1.846     0.200
    27.189     0.304     0.200
    27.302    -0.902     0.200
    27.273     2.789     0.200
    27.303     2.961     0.200
    27.324     3.288     0.200
    27.332     3.305     0.200
    27.360    -0.241     0.200
    27.394     2.117     0.200
    27.547     1.099     0.200
    27.547     1.609     0.200
    27.547     2.164     0.200
    27.578     1.457     0.200
    27.578     0.905     0.200
    27.596     1.712     0.200
    27.639     0.784     0.200
    27.764     1.329     0.200
    27.794     2.341     0.200
    27.864     1.038     0.200
    27.864     3.108     0.200
    27.864     1.931     0.200
    27.886     3.215     0.200
    27.924     4.173     0.200
    27.924     2.671     0.200
    27.929     3.384     0.200
    27.930     2.488     0.200
    28.049     1.124     0.200
    28.030     2.684     0.200
    28.034     1.522     0.200
    28.055     1.896     0.200
    28.102     0.060     0.200
    28.105     1.264     0.200
    28.144     0.524     0.200
    28.129     2.794     0.200
    28.200     1.201     0.200
    28.254     0.354     0.200
    28.265     3.349     0.200
    28.296     0.536     0.200
    28.309     2.389     0.200
    28.327     3.303     0.200
    28.332     4.139     0.200
    28.332     3.154     0.200
    28.330     1.607     0.200
    28.398     1.377     0.200
    28.395     3.385     0.200
    28.398     1.749     0.200
    28.426     4.001     0.200
    28.426     2.421     0.200
    28.460     1.107     0.200
    28.493     3.195     0.200
    28.624     3.594     0.200
    28.642    -0.026     0.200
    28.661     2.597     0.200
    28.668     0.750     0.200
    28.672     1.886     0.200
    28.675     3.302     0.200
    28.677     3.649     0.200
    28.685     0.618     0.200
    28.685     0.743     0.200
    28.685     0.693     0.200
    28.685     0.793     0.200
    28.692     0.562     0.200
    28.692     1.752     0.200
    28.638     2.112     0.200
    28.692    -0.058     0.200
    28.692     1.088     0.200
    28.696     0.498     0.200
    28.737     1.108     0.200
    28.718     3.806     0.200
    28.725     4.162     0.200
    28.742     0.886     0.200
    28.756     3.332     0.200
    28.766     0.574     0.200
    28.798     0.693     0.200
    28.760     1.246     0.200
    28.760     3.729     0.200
    28.760     2.521     0.200
    28.786     0.701     0.200
    28.791     3.149     0.200
    28.790     3.023     0.200
    28.804     3.111     0.200
    28.826     3.119     0.200
    28.829     0.947     0.200
    28.829     1.610     0.200
    28.829     3.500     0.200
    28.878     2.952     0.200
    28.893     2.815     0.200
    28.919     3.436     0.200
    28.947     3.710     0.200
    28.963     2.278     0.200
    28.963     1.128     0.200
    28.963     4.328     0.200
    28.963     3.172     0.200
    28.966     3.798     0.200
    28.967     2.836     0.200
    28.967     4.072     0.200
    28.973     2.284     0.200
    28.973     1.676     0.200
    29.043    -0.161     0.200
    29.013     3.620     0.200
    29.013     4.277     0.200
    29.013     3.295     0.200
    29.124    -0.143     0.200
    29.083     1.238     0.200
    29.105     3.399     0.200
    29.141     0.872     0.200
    29.178     1.527     0.200
    29.178     0.515     0.200
    29.187     3.856     0.200
    29.277     3.617     0.200
    29.271     1.530     0.200
    29.271     0.977     0.200
    29.302     0.018     0.200
    29.328     2.205     0.200
    29.343     4.221     0.200
    29.392     0.849     0.200
    29.392     1.615     0.200
    29.366     4.181     0.200
    29.362     1.241     0.200
    29.362     1.368     0.200
    29.359     0.600     0.200
    29.413     1.082     0.200
    29.391     3.721     0.200
    29.405     1.413     0.200
    29.441     2.916     0.200
    29.441     2.446     0.200
    29.441     4.386     0.200
    29.441     3.431     0.200
    29.464     1.056     0.200
    29.464     1.877     0.200
    29.556     0.684     0.200
    29.556     0.413     0.200
    29.597     2.441     0.200
    29.638     0.657     0.200
    29.684     0.219     0.200
    29.684    -0.007     0.200
    29.702     3.524     0.200
    29.715     0.516     0.200
    29.731     3.276     0.200
    29.779     1.190     0.200
    29.884    -0.074     0.200
    29.901     2.990     0.200
    29.942     3.070     0.200
    29.990     1.594     0.200
    30.012     1.012     0.200
    30.012     1.725     0.200
    29.980     1.380     0.200
    30.043     3.399     0.200
    30.056     2.425     0.200
    30.054     2.964     0.200
    30.078     0.596     0.200
    30.109     1.823     0.200
    30.127     3.193     0.200
    30.134     1.375     0.200
    30.173     1.178     0.200
    30.320     3.198     0.200
    30.314    -0.071     0.200
    30.314     1.001     0.200
    30.326     1.848     0.200
    30.337     1.168     0.200
    30.337     3.073     0.200
    30.337     1.823     0.200
    30.386     1.718     0.200
    30.349     2.730     0.200
    30.376    -0.168     0.200
    30.427     2.156     0.200
    30.425     0.579     0.200
    30.441     0.370     0.200
    30.500     0.657     0.200
    30.525     1.074     0.200
    30.547     1.172     0.200
    30.586     3.607     0.200
    30.622     3.137     0.200
    30.626     2.498     0.200
    30.627     1.496     0.200
    30.648    -0.460     0.200
    30.708     1.843     0.200
    30.729     1.442     0.200
    30.774     1.251     0.200
    30.792     1.094     0.200
    30.799     3.599     0.200
    30.804     0.267     0.200
    30.811     3.667     0.200
    30.831     0.674     0.200
    30.831     1.490     0.200
    30.849     0.495     0.200
    30.851     0.511     0.200
    30.898    -0.039     0.200
    30.899     1.313     0.200
    30.935     0.347     0.200
    30.951     1.351     0.200
    30.951     3.001     0.200
    30.995     0.902     0.200
    30.956     0.631     0.200
    30.959    -0.467     0.200
    30.972     2.345     0.200
    31.015     1.367     0.200
    31.014     0.789     0.200
    31.046     4.190     0.200
    31.018     0.647     0.200
    31.018    -0.091     0.200
    31.034     2.761     0.200
    31.041    -0.612     0.200
    31.064    -0.161     0.200
    31.086    -0.110     0.200
    31.093     2.176     0.200
    31.136     1.935     0.200
    31.144     1.889     0.200
    31.144     2.115     0.200
    31.163     0.861     0.200
    31.174     3.624     0.200
    31.168     1.324     0.200
    31.176     0.641     0.200
    31.214     1.504     0.200
    31.214     1.111     0.200
    31.181    -0.019     0.200
    31.197     0.479     0.200
    31.197    -0.037     0.200
    31.213     0.692     0.200
    31.218     0.486     0.200
    31.244     3.848     0.200
    31.257     0.410     0.200
    31.265     2.461     0.200
    31.315     1.005     0.200
    31.355     0.611     0.200
    31.355     1.173     0.200
    31.360     2.506     0.200
    31.378     0.780     0.200
    31.406    -1.160     0.200
    31.408    -1.533     0.200
    31.449     0.033     0.200
    31.473     2.216     0.200
    31.473     2.911     0.200
    31.480    -0.490     0.200
    31.482    -0.192     0.200
    31.500     3.286     0.200
    31.498    -0.400     0.200
    31.554     2.216     0.200
    31.573     1.086     0.200
    31.573    -1.316     0.200
    31.600     0.491     0.200
    31.606     3.364     0.200
    31.606     2.425     0.200
    31.639     2.767     0.200
    31.654    -0.049     0.200
    31.663    -2.051     0.200
    31.679     0.467     0.200
    31.686    -0.781     0.200
    31.697     1.455     0.200
    31.697     0.543     0.200
    31.719     1.511     0.200
    31.719    -0.046     0.200
    31.734     1.581     0.200
    31.734     1.333     0.200
    31.751     3.150     0.200
    31.789    -0.723     0.200
    31.844     1.871     0.200
    31.859     1.967     0.200
    31.859     3.237     0.200
    31.885    -0.386     0.200
    31.916     0.089     0.200
    31.982    -0.724     0.200
    32.019    -0.121     0.200
    32.094    -0.214     0.200
    32.094    -0.953     0.200
    32.115     2.026     0.200
    32.121    -1.476     0.200
    32.141     3.612     0.200
    32.157    -1.105     0.200
    32.189     1.851     0.200
    32.189     0.930     0.200
    32.189     1.461     0.200
    32.189     2.531     0.200
    32.189     1.979     0.200
    32.189     2.662     0.200
    32.201     2.348     0.200
    32.235    -0.432     0.200
    32.238     0.301     0.200
    32.245    -0.585     0.200
    32.256     2.586     0.200
    32.274     2.266     0.200
    32.273    -0.733     0.200
    32.319     3.154     0.200
    32.335     3.210     0.200
    32.362     0.381     0.200
    32.347    -1.036     0.200
    32.378     2.269     0.200
    32.378     3.959     0.200
    32.402    -0.267     0.200
    32.402    -0.432     0.200
    32.441     1.215     0.200
    32.441     1.316     0.200
    32.473     1.501     0.200
    32.473     0.791     0.200
    32.477    -0.357     0.200
    32.493     3.030     0.200
    32.493     2.832     0.200
    32.511     2.376     0.200
    32.511     2.907     0.200
    32.512     3.426     0.200
    32.509     0.440     0.200
    32.528     3.191     0.200
    32.528    -1.557     0.200
    32.547     1.065     0.200
    32.551     0.015     0.200
    32.572     1.912     0.200
    32.572     0.362     0.200
    32.572     2.272     0.200
    32.569    -0.153     0.200
    32.587    -1.105     0.200
    32.656    -0.500     0.200
    32.664    -0.967     0.200
    32.681     0.898     0.200
    32.752     3.340     0.200
    32.782    -2.567     0.200
    32.765    -0.524     0.200
    32.783     0.812     0.200
    32.790     3.414     0.200
    32.943     0.430     0.200
    32.941     0.170     0.200
    32.980     3.284     0.200
    33.073     2.030     0.200
    33.205     1.921     0.200
    33.205     2.669     0.200
    33.186    -0.084     0.200
    33.193    -1.350     0.200
    33.199    -0.603     0.200
    33.210    -0.984     0.200
    33.228    -0.983     0.200
    33.230    -0.538     0.200
    33.267     3.394     0.200
    33.285    -1.203     0.200
    33.330     2.147     0.200
    33.322    -0.706     0.200
    33.322    -0.356     0.200
    33.322    -0.996     0.200
    33.322     0.294     0.200
    33.319    -1.508     0.200
    33.330    -1.274     0.200
    33.401     1.031     0.200
    33.401     0.891     0.200
    33.393    -0.751     0.200
    33.393     0.099     0.200
    33.439     1.249     0.200
    33.439     0.539     0.200
    33.439     1.499     0.200
    33.439     2.349     0.200
    33.439     2.144     0.200
    33.449    -0.313     0.200
    33.487    -0.387     0.200
    33.492    -0.762     0.200
    33.530     1.833     0.200
    33.582     2.757     0.200
    33.582     3.368     0.200
    33.582    -0.014     0.200
    33.599     3.573     0.200
    33.599     3.703     0.200
    33.620    -0.231     0.200
    33.620     0.719     0.200
    33.635     1.785     0.200
    33.789    -0.838     0.200
    33.888     0.728     0.200
    33.874     3.041     0.200
    33.874     3.401     0.200
    33.910     2.096     0.200
    33.910     2.816     0.200
    33.910     1.916     0.200
    33.984     1.555     0.200
    33.961     1.754     0.200
    33.963     0.046     0.200
    34.058     0.115     0.200
    34.058    -0.475     0.200
    34.058     0.919     0.200
    34.075     1.762     0.200
    34.189     0.398     0.200
    34.229     1.344     0.200
    34.305     1.660     0.200
    34.305     1.957     0.200
    34.305     1.030     0.200
    34.305     1.770     0.200
    34.305     2.808     0.200
    34.305     2.216     0.200
    34.265     2.816     0.200
    34.338     1.560     0.200
    34.338     1.919     0.200
    34.338     1.440     0.200
    34.367     2.332     0.200
    34.442     1.547     0.200
    34.540     1.132     0.200
    34.573     1.450     0.200
    34.591     1.191     0.200
    34.640     1.269     0.200
    34.654     2.643     0.200
    34.657     1.721     0.200
    34.702     2.315     0.200
    34.814     0.468     0.200
    34.778    -0.715     0.200
    34.866     1.688     0.200
    34.866     0.998     0.200
    34.946     2.002     0.200
    34.990    -0.056     0.200
    34.955     2.677     0.200
    34.955     2.847     0.200
    34.960     1.003     0.200
    34.960     1.802     0.200
    35.137    -0.522     0.200
    35.117     1.453     0.200
    35.131     1.116     0.200
    35.131     0.386     0.200
    35.157     1.433     0.200
    35.189     1.329     0.200
    35.224     2.230     0.200
    35.249     0.631     0.200
    35.315     1.130     0.200
    35.323     2.374     0.200
    35.323     1.704     0.200
    35.438     0.480     0.200
    35.445     1.430     0.200
    35.451     1.274     0.200
    35.419     1.339     0.200
    35.461     2.017     0.200
    35.499     3.203     0.200
    35.499     1.613     0.200
    35.556     1.148     0.200
    35.556     1.738     0.200
    35.556     1.268     0.200
    35.566     1.187     0.200
    35.580     3.509     0.200
    35.619     3.534     0.200
    35.702     1.539     0.200
    35.702     2.919     0.200
    35.702     2.617     0.200
    35.704     1.952     0.200
    35.704     2.401     0.200
    35.762     2.101     0.200
    35.882     1.215     0.200
    35.882     1.945     0.200
    35.882     0.805     0.200
    35.882     1.721     0.200
    35.898     2.087     0.200
    35.898     2.317     0.200
    35.933     0.189     0.200
    35.962     1.591     0.200
    36.068    -0.402     0.200
    36.068     0.073     0.200
    36.068     0.623     0.200
    36.124     0.333     0.200
    36.115     0.667     0.200
    36.123     1.511     0.200
    36.173     2.386     0.200
    36.230     1.832     0.200
    36.230     1.592     0.200
    36.255     1.600     0.200
    36.255     1.331     0.200
    36.255     2.805     0.200
    36.323    -0.502     0.200
    36.323     0.403     0.200
    36.323     0.218     0.200
    36.323     1.143     0.200
    36.327    -0.465     0.200
    36.365     0.041     0.200
    36.357     1.408     0.200
    36.357     1.271     0.200
    36.422     1.225     0.200
    36.481     0.653     0.200
    36.517    -0.370     0.200
    36.517     0.396     0.200
    36.517    -0.410     0.200
    36.517    -0.180     0.200
    36.532    -0.383     0.200
    36.550    -0.439     0.200
    36.560     2.545     0.200
    36.560     1.475     0.200
    36.648     1.917     0.200
    36.656     2.119     0.200
    36.656     1.958     0.200
    36.700     0.182     0.200
    36.741     0.524     0.200
    36.762     2.155     0.200
    36.778     2.679     0.200
    36.778     2.519     0.200
    36.777     1.184     0.200
    36.785     0.727     0.200
    36.785     2.507     0.200
    36.796     1.434     0.200
    36.796     0.724     0.200
    36.830     1.696     0.200
    36.830     1.861     0.200
    36.830     1.296     0.200
    36.830     1.476     0.200
    36.830     2.046     0.200
    36.830     2.236     0.200
    36.812     0.841     0.200
    36.812     0.721     0.200
    36.841     1.447     0.200
    36.841     1.237     0.200
    36.921     0.846     0.200
    36.974     1.751     0.200
    37.071     1.442     0.200
    37.071     1.185     0.200
    37.260     0.252     0.200
    37.396     1.184     0.200
    37.450     0.868     0.200
    37.437     1.550     0.200
    37.437     0.874     0.200
    37.442     0.818     0.200
    37.444     1.357     0.200
    37.582     0.558     0.200
    37.582     0.691     0.200
    37.582     1.491     0.200
    37.645     1.153     0.200
    37.654     1.737     0.200
    37.654     1.477     0.200
    37.677     1.288     0.200
    37.695    -0.283     0.200
    37.695     0.837     0.200
    37.705     1.645     0.200
    37.732     1.848     0.200
    37.732     2.818     0.200
    37.830     1.653     0.200
    38.019     1.499     0.200
    37.995     2.897     0.200
    38.013     1.446     0.200
    38.040     0.948     0.200
    38.060     0.869     0.200
    38.065     1.260     0.200
    38.090     0.695     0.200
    38.090     0.945     0.200
    38.099     1.472     0.200
    38.108     2.146     0.200
    38.108     1.471     0.200
    38.108     1.416     0.200
    38.116     1.120     0.200
    38.116     0.710     0.200
    38.129    -0.492     0.200
    38.153     1.540     0.200
    38.153     1.063     0.200
    38.208     1.185     0.200
    38.218     0.398     0.200
    38.232     0.388     0.200
    38.250     0.126     0.200
    38.276     1.233     0.200
    38.276     0.661     0.200
    38.310     1.403     0.200
    38.338     1.533     0.200
    38.366     0.711     0.200
    38.391     1.311     0.200
    38.391     0.981     0.200
    38.391     0.875     0.200
    38.435     1.625     0.200
    38.435     0.585     0.200
    38.435     1.916     0.200
    38.487     0.450     0.200
    38.487    -0.130     0.200
    38.506     0.310     0.200
    38.564     0.717     0.200
    38.663     0.984     0.200
    38.667     1.369     0.200
    38.667    -0.461     0.200
    38.684     2.096     0.200
    38.737     0.945     0.200
    38.766     1.793     0.200
    38.766     1.133     0.200
    38.766     1.330     0.200
    38.766     3.013     0.200
    38.822     1.560     0.200
    38.843     1.033     0.200
    38.895     0.521     0.200
    38.895     1.121     0.200
    38.962     2.304     0.200
    38.975     0.671     0.200
    39.040    -0.556     0.200
    39.019     1.932     0.200
    39.019     2.392     0.200
    39.024     1.617     0.200
    39.024     1.998     0.200
    39.041     2.309     0.200
    39.041     1.551     0.200
    39.129     1.666     0.200
    39.129     1.486     0.200
    39.138     0.813     0.200
    38.879     1.750     0.200
    39.172     0.080     0.200
    39.172     0.720     0.200
    39.142     1.892     0.200
    39.220     2.443     0.200
    39.223     0.579     0.200
    39.277     2.034     0.200
    39.379     1.779     0.200
    39.443     0.303     0.200
    39.448     1.142     0.200
    39.453     1.787     0.200
    39.481     1.727     0.200
    39.484     0.824     0.200
    39.504     1.946     0.200
    39.506     1.591     0.200
    39.524     1.789     0.200
    39.534     2.651     0.200
    39.545     1.666     0.200
    39.551     1.243     0.200
    39.551     1.392     0.200
    39.581     1.889     0.200
    39.631     2.017     0.200
    39.644     1.021     0.200
    39.693     1.411     0.200
    39.693     1.661     0.200
    39.716     2.318     0.200
    39.720     1.568     0.200
    39.734     0.596     0.200
    39.764     1.553     0.200
    39.753     2.482     0.200
    39.753     2.922     0.200
    39.776     2.469     0.200
    39.776     1.570     0.200
    39.868     0.890     0.200
    39.871    -0.011     0.200
    39.883     1.621     0.200
    39.962     1.453     0.200
    39.962     1.427     0.200
    39.985     0.997     0.200
    40.029    -0.614     0.200
    40.029     0.306     0.200
    40.003     2.005     0.200
    40.036     0.247     0.200
    40.064     0.946     0.200
    40.089     1.074     0.200
    40.089     1.414     0.200
    40.136     1.337     0.200
    40.160     2.772     0.200
    40.189     0.757     0.200
    40.250     1.284     0.200
    40.289     1.405     0.200
    40.289     0.506     0.200
    40.291     2.652     0.200
    40.333     1.076     0.200
    40.333     0.946     0.200
    40.333     0.821     0.200
    40.333     0.436     0.200
    40.341     0.981     0.200
    40.379     0.595     0.200
    40.376     0.589     0.200
    40.423     1.204     0.200
    40.393     0.712     0.200
    40.393     0.852     0.200
    40.426     0.918     0.200
    40.452     2.265     0.200
    40.440     0.384     0.200
    40.450     1.862     0.200
    40.450     1.582     0.200
    40.478     1.309     0.200
    40.478     0.319     0.200
    40.595     1.831     0.200
    40.628     1.595     0.200
    40.638     0.242     0.200
    40.638     0.380     0.200
    40.672     1.045     0.200
    40.681     1.641     0.200
    40.681     1.869     0.200
    40.685     2.604     0.200
    40.692     1.639     0.200
    40.757    -0.092     0.200
    41.031     1.810     0.200
    41.030     0.499     0.200
    41.030     0.848     0.200
    41.096     0.149     0.200
    41.096    -0.451     0.200
    41.083     0.894     0.200
    41.083     0.414     0.200
    41.083     0.777     0.200
    41.083     2.099     0.200
    41.127     0.370     0.200
    41.141     2.706     0.200
    41.198     0.907     0.200
    41.270     0.043     0.200
    41.270    -0.167     0.200
    41.289     2.782     0.200
    41.298     3.239     0.200
    41.355     1.591     0.200
    41.427    -0.071     0.200
    41.459     0.195     0.200
    41.528     1.041     0.200
    41.512     1.498     0.200
    41.567    -0.020     0.200
    41.589     0.014     0.200
    41.585     2.004     0.200
    41.585     1.727     0.200
    41.588     3.269     0.200
    41.600     0.646     0.200
    41.621     0.335     0.200
    41.621     0.035     0.200
    41.621     0.635     0.200
    41.621     0.160     0.200
    41.611     0.470     0.200
    41.632     1.122     0.200
    41.647     0.106     0.200
    41.661     2.110     0.200
    41.661     0.846     0.200
    41.662     0.867     0.200
    41.662     0.377     0.200
    41.662     0.197     0.200
    41.662     1.217     0.200
    41.685     2.038     0.200
    41.749    -0.123     0.200
    41.749    -0.442     0.200
    41.749     2.617     0.200
    41.749     3.317     0.200
    41.763     1.531     0.200
    41.825     1.571     0.200
    41.907     1.564     0.200
    42.047     0.637     0.200
    42.058     1.563     0.200
    42.058     1.432     0.200
    42.058     1.152     0.200
    42.091     2.044     0.200
    42.091     1.184     0.200
    42.144     2.216     0.200
    42.242     2.060     0.200
    42.237     1.006     0.200
    42.284     1.617     0.200
    42.273     0.680     0.200
    42.305     1.176     0.200
    42.340     1.398     0.200
    42.340     0.458     0.200
    42.359     1.793     0.200
    42.359     1.341     0.200
    42.377     1.969     0.200
    42.436     0.113     0.200
    42.459     1.391     0.200
    42.448     0.614     0.200
    42.448     1.534     0.200
    42.448     0.954     0.200
    42.448     1.294     0.200
    42.431     2.406     0.200
    42.431     2.139     0.200
    42.431     1.427     0.200
    42.431     1.209     0.200
    42.431     1.816     0.200
    42.431     2.661     0.200
    42.431     0.746     0.200
    42.451     0.378     0.200
    42.467     2.350     0.200
    42.467     1.801     0.200
    42.479    -0.122     0.200
    42.479    -0.342     0.200
    42.488     0.669     0.200
    42.516     1.065     0.200
    42.538     1.476     0.200
    42.588     0.142     0.200
    42.611     0.627     0.200
    42.640     1.028     0.200
    42.626     1.536     0.200
    42.626     1.726     0.200
    42.636     0.725     0.200
    42.662     1.345     0.200
    42.669     1.495     0.200
    42.667     2.122     0.200
    42.689     1.631     0.200
    42.707     1.476     0.200
    42.827     0.801     0.200
    42.877     0.878     0.200
    42.877     2.268     0.200
    42.797     1.847     0.200
    42.879     1.519     0.200
    42.979     0.371     0.200
    42.970     0.822     0.200
    43.068     2.189     0.200
    43.068     1.726     0.200
    43.068     2.689     0.200
    43.068     1.588     0.200
    43.077     1.087     0.200
    43.077     0.798     0.200
    43.077     0.588     0.200
    43.077     1.518     0.200
    43.118     2.144     0.200
    43.159    -0.189     0.200
    43.148     1.778     0.200
    43.148     1.478     0.200
    43.151     0.920     0.200
    43.201     1.083     0.200
    43.195     2.270     0.200
    43.195     2.074     0.200
    43.272     2.616     0.200
    43.272     3.008     0.200
    43.382     2.602     0.200
    43.372     1.013     0.200
    43.443     0.658     0.200
    43.576     0.047     0.200
    43.565     1.473     0.200
    43.583     2.643     0.200
    43.575    -0.326     0.200
    43.654     2.408     0.200
    43.696     1.172     0.200
    43.727     2.321     0.200
    43.905     1.495     0.200
    43.946     1.611     0.200
    43.956     2.389     0.200
    43.978     1.106     0.200
    44.063     1.660     0.200
    44.094     1.880     0.200
    44.149     0.571     0.200
    44.167     2.157     0.200
    44.193     2.250     0.200
    44.193     2.099     0.200
    44.193     1.250     0.200
    44.249     1.636     0.200
    44.315     0.834     0.200
    44.324     0.409     0.200
    44.324     1.189     0.200
    44.321     1.064     0.200
    44.375     2.002     0.200
    44.450     1.229     0.200
    44.474     0.546     0.200
    44.474     0.686     0.200
    44.474     1.636     0.200
    44.474     1.426     0.200
    44.477     1.610     0.200
    44.521     1.572     0.200
    44.523     1.975     0.200
    44.592     1.394     0.200
    44.646     1.760     0.200
    44.688     1.837     0.200
    44.732     0.780     0.200
    44.733     1.372     0.200
    44.891     0.814     0.200
    44.900     1.238     0.200
    45.014     0.034     0.200
    45.014     0.391     0.200
    45.045     1.775     0.200
    45.076     1.875     0.200
    45.160    -0.911     0.200
    45.137     1.352     0.200
    45.261     1.471     0.200
    45.560     1.198     0.200
    45.580     0.116     0.200
    45.628     0.773     0.200
    45.628     1.548     0.200
    45.628     0.953     0.200
    45.628     1.433     0.200
    45.628     2.263     0.200
    45.993     1.575     0.200
    46.081     2.232     0.200
    46.090    -0.417     0.200
    46.090    -0.549     0.200
    46.088    -0.272     0.200
    46.215     2.420     0.200
    46.254     1.412     0.200
    46.269     0.206     0.200
    46.413     0.458     0.200
    46.448     0.696     0.200
    46.529     1.162     0.200
    46.751    -1.182     0.200
    46.699     0.485     0.200
    46.751    -1.672     0.200
    46.751    -1.452     0.200
    46.751    -0.871     0.200
    46.737     2.360     0.200
    46.755     0.985     0.200
    46.793     0.792     0.200
    46.823     0.758     0.200
    46.875    -0.344     0.200
    46.875     1.019     0.200
    46.938    -0.641     0.200
    46.938    -0.906     0.200
    46.938    -0.531     0.200
    47.005     1.091     0.200
    47.005     1.291     0.200
    47.021     0.806     0.200
    46.992     1.625     0.200
    47.042     1.043     0.200
    47.091     1.811     0.200
    47.243     1.278     0.200
    47.227     1.197     0.200
    47.244     1.394     0.200
    47.246    -0.217     0.200
    47.389     1.096     0.200
    47.500     0.962     0.200
    47.502     1.958     0.200
    47.536     0.611     0.200
    47.622     0.839     0.200
    47.680     1.463     0.200
    47.739     1.239     0.200
    47.783     0.665     0.200
    47.830     0.899     0.200
    47.896     1.341     0.200
    47.970     1.997     0.200
    48.018     0.156     0.200
    47.974     0.896     0.200
    47.983     1.077     0.200
    47.983     0.707     0.200
    48.128     1.192     0.200
    48.132     0.774     0.200
    48.207     0.791     0.200
    48.225     1.114     0.200
    48.335     1.497     0.200
    48.339     0.347     0.200
    48.374     1.346     0.200
    48.477     0.913     0.200
    48.491     1.507     0.200
    48.534     2.044     0.200
    48.559     0.829     0.200
    48.556     0.276     0.200
    48.570     1.555     0.200
    48.586     1.661     0.200
    48.586     2.019     0.200
    48.586     0.931     0.200
    48.586     1.181     0.200
    48.579     1.726     0.200
    48.595     2.001     0.200
    48.588     0.558     0.200
    48.614     1.887     0.200
    48.719     2.345     0.200
    48.741     0.822     0.200
    48.756     1.535     0.200
    48.746     2.439     0.200
    48.869     1.929     0.200
    48.939     1.607     0.200
    48.939     0.812     0.200
    48.939     1.382     0.200
    48.939     1.212     0.200
    48.982     1.126     0.200
    49.004     0.981     0.200
    49.040     2.037     0.200
    49.095     0.382     0.200
    49.184     0.580     0.200
    49.141     2.701     0.200
    49.141     1.920     0.200
    49.180     1.820     0.200
    49.185     1.267     0.200
    49.239     0.310     0.200
    49.256     1.237     0.200
    49.258     2.613     0.200
    49.283     2.185     0.200
    49.293     0.990     0.200
    49.361     1.185     0.200
    49.367     0.735     0.200
    49.417    -0.201     0.200
    49.436     1.284     0.200
    49.513     0.764     0.200
    49.484     1.002     0.200
    49.486     1.943     0.200
    49.545     0.430     0.200
    49.526     0.865     0.200
    49.556     1.248     0.200
    49.572     1.412     0.200
    49.755    -0.209     0.200
    49.755    -0.406     0.200
    49.755    -0.029     0.200
    49.755     0.621     0.200
    49.766     2.027     0.200
    49.838     0.789     0.200
    49.922     0.752     0.200
    50.265     1.043     0.200
    50.256     0.159     0.200
    50.262     1.142     0.200
    50.307    -0.241     0.200
    50.307     0.699     0.200
    50.307     0.829     0.200
    50.314     0.811     0.200
    50.342     0.984     0.200
    50.343     0.630     0.200
    50.343     1.409     0.200
    50.343     1.199     0.200
    50.343     1.909     0.200
    50.475     0.353     0.200
    50.506     0.079     0.200
    50.506     1.029     0.200
    50.572     0.148     0.200
    50.623     1.125     0.200
    50.623     0.398     0.200
    50.650     0.335     0.200
    50.685    -1.626     0.200
    50.717     0.933     0.200
    50.817    -0.794     0.200
    50.817    -0.026     0.200
    50.817    -0.654     0.200
    50.979     1.901     0.200
    50.979     2.161     0.200
    51.066     1.846     0.200
    51.066     1.496     0.200
    51.390     0.264     0.200
    51.424     1.059     0.200
    51.424     1.529     0.200
    51.424     0.129     0.200
    51.422     1.035     0.200
    51.666     1.606     0.200
    51.774    -0.110     0.200
    51.775     0.140     0.200
    51.775    -0.110     0.200
    51.798     1.123     0.200
    51.791     0.429     0.200
    51.897     1.974     0.200
    51.897     1.204     0.200
    51.912     2.069     0.200
    51.912     1.812     0.200
    51.949     1.686     0.200
    51.949     2.594     0.200
    51.949     0.626     0.200
    52.128     0.259     0.200
    52.128    -0.034     0.200
    52.097     0.091     0.200
    52.097     0.301     0.200
    52.097     0.911     0.200
    52.265     0.946     0.200
    52.307     2.495     0.200
    52.307     3.132     0.200
    52.323     0.152     0.200
    52.323    -0.578     0.200
    52.384     0.982     0.200
    52.384    -0.063     0.200
    52.384     0.027     0.200
    52.343     0.961     0.200
    52.385     0.256     0.200
    52.378     1.307     0.200
    52.461     1.890     0.200
    53.022     1.641     0.200
    53.006    -0.601     0.200
    53.159     0.461     0.200
    53.159     2.047     0.200
    53.159     0.631     0.200
    53.162     0.637     0.200
    53.442     0.096     0.200
    53.442     0.646     0.200
    53.442     0.045     0.200
    53.442    -0.485     0.200
    53.665     1.113     0.200
    54.010    -0.981     0.200
    54.059     2.797     0.200
    54.192     0.816     0.200
    54.192     0.316     0.200
    54.192     2.101     0.200
    54.353     0.915     0.200
    54.382     1.083     0.200
    54.453     0.540     0.200
    54.453     0.740     0.200
    54.510     1.484     0.200
    54.510     0.272     0.200
    54.494     0.392     0.200
    54.494     1.339     0.200
    54.494     0.612     0.200
    54.602     0.437     0.200
    54.602     0.715     0.200
    54.651    -0.208     0.200
    54.639     0.465     0.200
    54.745     0.234     0.200
    54.703     0.113     0.200
    54.703     0.703     0.200
    54.956     2.026     0.200
    55.124     0.494     0.200
    55.130     1.534     0.200
    55.130     1.919     0.200
    55.130     1.118     0.200
    55.278    -0.084     0.200
    55.278     0.676     0.200
    55.677     0.812     0.200
    55.717     1.264     0.200
    55.758     2.153     0.200
    55.758     2.783     0.200
    55.758     0.913     0.200
    55.758     2.983     0.200
    55.841     3.184     0.200
    55.823     1.935     0.200
    55.903     0.798     0.200
    56.010     0.763     0.200
    56.202     0.922     0.200
    56.202     1.112     0.200
    56.202     0.442     0.200
    56.374     0.224     0.200
    56.454     1.564     0.200
    56.454     0.114     0.200
    56.521     3.332     0.200
    56.510     1.035     0.200
    56.510     0.864     0.200
    56.614    -0.096     0.200
    56.614     1.364     0.200
    56.614    -0.216     0.200
    56.647     1.439     0.200
    56.728     0.203     0.200
    57.310     0.521     0.200
    57.310     0.621     0.200
    57.310     0.401     0.200
    58.149     0.431     0.200
    58.149     1.131     0.200
    58.256     0.831     0.200
    58.256     1.881     0.200
    58.714     1.537     0.200
    59.094     0.496     0.200
    59.094     1.130     0.200
    59.094     1.576     0.200
    59.586     0.103     0.200
    59.838     0.359     0.200
    59.838    -0.051     0.200
    59.838     0.162     0.200
    59.838    -0.581     0.200
    60.002     1.832     0.200
    60.013     0.093     0.200
    60.013     1.064     0.200
    60.060     1.503     0.200
    60.060     1.073     0.200
    60.060     2.253     0.200
    60.060     1.803     0.200
    60.070    -2.116     0.200
    60.170     1.036     0.200
    60.170     0.564     0.200
    60.170     1.596     0.200
    60.301     1.084     0.200
    60.301     1.224     0.200
    60.301     0.594     0.200
    60.437    -0.421     0.200
    60.437     0.544     0.200
    60.437     0.329     0.200
    60.411     1.032     0.200
    60.411     1.882     0.200
    60.411     2.032     0.200
    60.439     0.385     0.200
    60.439     0.046     0.200
    60.723     0.997     0.200
    60.723     0.787     0.200
    60.721     0.013     0.200
    60.721     0.813     0.200
    60.890    -0.017     0.200
    60.890     0.456     0.200
    60.929     2.269     0.200
    60.929     1.728     0.200
    60.929     3.342     0.200
    61.881     1.399     0.200
    61.881     1.585     0.200
    61.881     1.249     0.200
    61.881     0.179     0.200
    62.489     1.221     0.200
    62.781     1.327     0.200
    62.781    -0.214     0.200
    62.819     1.369     0.200
    62.819     1.509     0.200
    62.994     0.775     0.200
    63.010    -1.259     0.200
    63.492     1.315     0.200
    63.492     0.775     0.200
    63.492     1.660     0.200
    63.492     1.910     0.200
    63.778     1.427     0.200
    64.001     0.607     0.200
    64.001    -0.163     0.200
    64.019     0.582     0.200
    64.019     0.792     0.200
    64.019     0.412     0.200
    64.207     1.841     0.200
    64.207     1.512     0.200
    64.207     1.261     0.200
    64.317     1.580     0.200
    64.317     1.960     0.200
    64.444    -0.696     0.200
    64.540     3.192     0.200
    64.685     0.887     0.200
    65.056     0.528     0.200
    65.649     0.584     0.200
    65.649     0.814     0.200
    65.697     0.905     0.200
    65.697     0.165     0.200
    65.723     1.116     0.200
    66.187     1.183     0.200
    66.332     0.922     0.200
    66.332    -0.761     0.200
    66.341     1.007     0.200
    66.341     0.667     0.200
    66.738     0.248     0.200
    66.738     0.898     0.200
    66.816     0.342     0.200
    66.885    -0.628     0.200
    66.885    -0.345     0.200
    66.885    -0.898     0.200
    66.885    -0.508     0.200
    66.889    -1.404     0.200
    67.210     0.374     0.200
    67.210    -0.276     0.200
    67.210    -0.036     0.200
    67.210     1.034     0.200
    67.583     0.424     0.200
    67.583    -1.093     0.200
    68.005     0.861     0.200
    68.105     1.966     0.200
    68.105     2.247     0.200
    68.149     0.275     0.200
    68.149     0.965     0.200
    68.149     0.635     0.200
    68.149    -0.404     0.200
    68.601     0.465     0.200
    68.601     0.255     0.200
    68.601     0.855     0.200
    68.601     1.145     0.200
    69.099    -0.232     0.200
    69.099     0.398     0.200
    69.099    -0.052     0.200
    69.430     0.614     0.200
    69.430    -0.126     0.200
    69.496     0.765     0.200
    70.045    -1.355     0.200
    69.932     1.879     0.200
    70.034    -0.278     0.200
    70.034     0.136     0.200
    70.034    -0.584     0.200
    71.059     1.538     0.200
    71.059     2.058     0.200
    71.059     2.504     0.200
    71.059     3.148     0.200
    71.817    -0.279     0.200
    71.817     0.078     0.200
    71.817     0.711     0.200
    71.817    -1.589     0.200
    71.817    -1.199     0.200
    71.904     0.502     0.200
    72.175     0.343     0.200
    72.301     0.338     0.200
    72.508     1.546     0.200
    72.508     0.474     0.200
    72.772     0.065     0.200
    72.969     0.733     0.200
    72.969     0.605     0.200
    72.996     0.896     0.200
    73.102     0.921     0.200
    73.185     1.002     0.200
    73.185     1.746     0.200
    73.198     1.082     0.200
    73.532    -0.481     0.200
    73.545    -0.447     0.200
    73.545    -0.196     0.200
    73.545    -0.826     0.200
    73.545     0.153     0.200
    73.729     0.471     0.200
    74.038     0.483     0.200
    74.395     0.799     0.200
    74.431     2.404     0.200
    74.436     1.693     0.200
    74.436     0.503     0.200
    74.436     1.313     0.200
    74.475     0.044     0.200
    74.630     0.278     0.200
    74.895     0.334     0.200
    74.942     1.241     0.200
    74.942     1.080     0.200
    75.201     0.324     0.200
    75.534     0.269     0.200
    75.534     0.799     0.200
    75.534    -0.251     0.200
    75.537     0.613     0.200
    75.535     0.645     0.200
    75.596     0.344     0.200
    75.596     2.222     0.200
    76.022     0.052     0.200
    76.020     0.801     0.200
    76.091     0.780     0.200
    76.412     0.326     0.200
    76.498     0.625     0.200
    76.569     0.633     0.200
    76.700     0.886     0.200
    76.758     0.494     0.200
    76.758     0.664     0.200
    76.758     0.234     0.200
    77.022     0.319     0.200
    77.084     0.921     0.200
    77.045     2.142     0.200
    77.045     1.590     0.200
    77.045     0.650     0.200
    77.045     1.469     0.200
    77.259     1.216     0.200
    77.291     0.889     0.200
    77.342     0.334     0.200
    77.461     0.334     0.200
    77.512     0.769     0.200
    77.618     0.489     0.200
    77.879    -0.025     0.200
    77.978     1.379     0.200
    77.996     0.959     0.200
    77.994     0.495     0.200
    78.142     0.653     0.200
    78.142     1.168     0.200
    78.142     0.333     0.200
    78.142     1.893     0.200
    78.102     1.916     0.200
    78.102     1.644     0.200
    78.102     1.176     0.200
    78.102     2.141     0.200
    78.173    -0.233     0.200
    78.243     0.190     0.200
    78.243     0.190     0.200
    78.342     0.721     0.200
    78.342    -0.848     0.200
    78.357     0.060     0.200
    78.406     0.201     0.200
    78.406    -0.139     0.200
    78.406    -0.659     0.200
    78.428     0.599     0.200
    78.459     1.078     0.200
    78.465     0.053     0.200
    78.622     0.480     0.200
    78.727    -0.373     0.200
    78.811    -0.230     0.200
    78.978     0.772     0.200
    79.062     0.182     0.200
    79.124     0.219     0.200
    79.289    -0.391     0.200
    79.305     0.739     0.200
    79.305     0.069     0.200
    79.435     0.609     0.200
    79.630     0.352     0.200
    79.694    -0.248     0.200
    79.708     0.495     0.200
    79.767     0.004     0.200
    79.767    -1.176     0.200
    79.767    -0.907     0.200
    79.871     0.201     0.200
    79.908     0.193     0.200
    79.908     0.943     0.200
    79.902     0.284     0.200
    79.924    -0.233     0.200
    79.987    -0.404     0.200
    80.018    -0.393     0.200
    80.128     0.610     0.200
    80.227     0.728     0.200
    80.227     0.359     0.200
    80.314     0.057     0.200
    80.314     1.475     0.200
    80.363     1.188     0.200
    80.644     0.924     0.200
    80.692     0.426     0.200
    80.692    -0.531     0.200
    80.692     0.059     0.200
    80.692     0.819     0.200
    80.692    -0.541     0.200
    80.698    -0.072     0.200
    80.698     0.815     0.200
    80.698     0.468     0.200
    80.756     0.338     0.200
    80.750     0.870     0.200
    80.833     0.203     0.200
    80.876    -0.106     0.200
    80.892     0.529     0.200
    80.892     2.829     0.200
    80.941     0.747     0.200
    80.978     0.589     0.200
    81.015     0.746     0.200
    81.018     0.778     0.200
    81.119     0.599     0.200
    81.115     0.650     0.200
    81.124    -0.425     0.200
    81.178     0.537     0.200
    81.203     0.401     0.200
    81.261     0.824     0.200
    81.320     1.643     0.200
    81.320     1.300     0.200
    81.488     1.122     0.200
    81.501     0.253     0.200
    81.600     0.830     0.200
    81.600     1.298     0.200
    81.618    -0.177     0.200
    81.620     0.560     0.200
    81.593     1.125     0.200
    81.593     1.345     0.200
    81.706     0.840     0.200
    81.706     1.818     0.200
    81.938     0.836     0.200
    81.963     1.413     0.200
    82.029     1.120     0.200
    82.029     1.878     0.200
    82.140     0.214     0.200
    82.140    -0.143     0.200
    82.178     0.966     0.200
    82.291     0.835     0.200
    82.359    -0.923     0.200
    82.438     0.824     0.200
    82.542     0.846     0.200
    82.589     1.101     0.200
    82.684     1.413     0.200
    82.750     0.981     0.200
    82.763     2.179     0.200
    82.841     0.705     0.200
    82.848     0.263     0.200
    82.848     0.123     0.200
    83.029     1.271     0.200
    83.079     0.986     0.200
    83.148     0.749     0.200
    83.217    -0.608     0.200
    83.216    -0.004     0.200
    83.216     0.186     0.200
    83.224     0.133     0.200
    83.322     1.593     0.200
    83.322     0.390     0.200
    83.494     1.382     0.200
    83.494     1.582     0.200
    83.494     1.122     0.200
    83.494     1.832     0.200
    83.535     3.223     0.200
    83.594     0.689     0.200
    83.811     0.532     0.200
    84.088     0.672     0.200
    84.088     0.333     0.200
    84.122     1.560     0.200
    84.171    -1.532     0.200
    84.843    -0.149     0.200
    84.843    -0.709     0.200
    84.879     0.570     0.200
    84.932     1.049     0.200
    85.223     0.130     0.200
    85.397     0.771     0.200
    85.766     0.061     0.200
    85.929     1.528     0.200
    86.125     0.910     0.200
    86.189    -0.635     0.200
    86.390     0.030     0.200
    86.456     0.839     0.200
    86.471     1.782     0.200
    86.482     0.682     0.200
    86.482     1.327     0.200
    86.536     0.267     0.200
    86.626    -0.403     0.200
    87.234     1.128     0.200
    87.489     0.383     0.200
    87.489     0.147     0.200
    87.537     0.844     0.200
    87.649    -0.246     0.200
    87.743     0.467     0.200
    88.157     0.721     0.200
    88.530     0.868     0.200
    88.738     1.868     0.200
    89.370     2.310     0.200
    89.465     0.417     0.200
    89.465     0.439     0.200
    89.465    -0.746     0.200
    89.684     0.568     0.200
    89.678     0.487     0.200
    89.981     0.669     0.200
    89.981     0.834     0.200
    89.981     0.159     0.200
    89.981     1.384     0.200
    89.981     0.637     0.200
    89.981    -0.168     0.200
    90.038     1.532     0.200
    90.523     1.201     0.200
    90.584     0.979     0.200
    90.723     0.527     0.200
    90.742     1.191     0.200
    91.057     2.200     0.200
    91.315     1.253     0.200
    91.798    -0.156     0.200
    91.798    -0.916     0.200
    91.817     1.336     0.200
    91.854     0.616     0.200
    92.288    -1.527     0.200
    92.459     0.427     0.200
    92.772     1.774     0.200
    92.826     1.776     0.200
    93.022     1.773     0.200
    93.136     2.057     0.200
    93.262    -0.138     0.200
    93.288     0.289     0.200
    93.288     0.157     0.200
    93.293     0.741     0.200
    93.381     0.157     0.200
    93.427     1.193     0.200
    93.655    -0.273     0.200
    94.013     0.047     0.200
    94.024     1.051     0.200
    94.203     2.206     0.200
    94.411     0.778     0.200
    94.431     1.721     0.200
    94.431     2.061     0.200
    94.474     0.420     0.200
    94.474     0.740     0.200
    94.641     1.497     0.200
    95.101     1.891     0.200
    95.101     0.421     0.200
    95.142     0.136     0.200
    95.142     0.725     0.200
    95.142     0.445     0.200
    95.276     2.161     0.200
    95.495     2.443     0.200
    95.619     2.204     0.200
    95.736     1.604     0.200
    96.452     1.588     0.200
    96.520     1.090     0.200
    96.520     0.848     0.200
    96.520     1.480     0.200
    96.545     0.363     0.200
    96.625     0.222     0.200
    96.625    -0.044     0.200
    96.625     1.092     0.200
    96.617     1.309     0.200
    96.664     2.297     0.200
    96.664     2.947     0.200
    96.864     1.430     0.200
    96.955     1.867     0.200
    97.514     0.801     0.200
    97.518     0.831     0.200
    97.981     0.719     0.200
    98.489    -0.712     0.200
    98.664     0.755     0.200
    98.755     0.436     0.200
    98.769     1.013     0.200
    98.840     0.606     0.200
    98.871     0.431     0.200
    15.131     5.263     0.200
    17.393     3.269     0.200
    17.628     2.480     0.200
    17.628     1.750     0.200
    18.191     0.419     0.200
    18.191    -0.051     0.200
    19.329     0.417     0.200
    19.334     0.556     0.200
    19.503    -0.613     0.200
    19.990    -0.002     0.200
    20.097    -1.166     0.200
    20.966     0.154     0.200
    20.973     4.690     0.200
    21.813     1.593     0.200
    22.199     3.573     0.200
    22.376     0.085     0.200
    22.594    -1.521     0.200
    23.165     1.313     0.200
    23.168     1.372     0.200
    23.168     1.082     0.200
    23.168     2.032     0.200
    23.571     0.254     0.200
    23.699     2.797     0.200
    23.720     2.195     0.200
    23.827     2.766     0.200
    25.061     1.625     0.200
    25.061     0.405     0.200
    25.061     1.015     0.200
    25.079    -0.102     0.200
    25.079     0.048     0.200
    25.079     0.388     0.200
    25.079     0.698     0.200
    26.144     0.848     0.200
    26.996     4.346     0.200
    28.707    -0.025     0.200
    28.707     0.050     0.200
    33.533    -1.544     0.200
    34.097     1.727     0.200
    34.097     0.197     0.200
    35.252     1.307     0.200
    35.592     2.385     0.200
    35.818     2.017     0.200
    35.931     0.578     0.200
    36.152     0.724     0.200
    36.275     0.557     0.200
    36.275     0.087     0.200
    36.279     0.524     0.200
    36.309     0.261     0.200
    36.313     0.573     0.200
    36.470    -0.294     0.200
    36.470    -0.115     0.200
    36.470     0.285     0.200
    36.484    -0.238     0.200
    36.503    -0.194     0.200
    36.740     0.250     0.200
    36.827     3.628     0.200
    37.470     2.076     0.200
    37.474     1.872     0.200
    37.687     0.985     0.200
    38.137     1.296     0.200
    38.185     1.443     0.200
    38.307     1.185     0.200
    38.430     1.771     0.200
    38.430     1.221     0.200
    38.430     0.871     0.200
    38.768     1.067     0.200
    38.997     0.163     0.200
    38.997    -0.437     0.200
    39.000     1.947     0.200
    39.013     1.485     0.200
    38.831     2.681     0.200
    39.125     0.980     0.200
    39.968    -0.188     0.200
    40.068     0.749     0.200
    40.096     0.514     0.200
    40.199     0.911     0.200
    40.325     0.430     0.200
    40.713     0.133     0.200
    40.670     0.807     0.200
    40.670     0.295     0.200
    41.038     0.211     0.200
    41.304     0.443     0.200
    41.304     0.302     0.200
    41.699    -0.091     0.200
    41.630     0.396     0.200
    41.630    -0.004     0.200
    41.649     0.411     0.200
    42.467    -0.087     0.200
    42.478     1.153     0.200
    42.490     0.322     0.200
    42.484     0.295     0.200
    42.693     0.297     0.200
    42.672     1.074     0.200
    42.673     1.114     0.200
    42.673     1.739     0.200
    42.673     0.589     0.200
    42.732     1.607     0.200
    42.863     1.823     0.200
    43.006     1.711     0.200
    43.135     1.564     0.200
    43.183     1.100     0.200
    43.973     0.808     0.200
    44.386     1.675     0.200
    44.508     1.046     0.200
    44.508     0.166     0.200
    44.508     0.396     0.200
    44.508     0.676     0.200
    44.763     0.153     0.200
    45.690    -0.398     0.200
    46.450     1.013     0.200
    46.720    -1.507     0.200
    46.720    -1.337     0.200
    46.831     0.514     0.200
    47.766     0.864     0.200
    48.378     0.383     0.200
    48.578     0.333     0.200
    49.121     0.690     0.200
    49.396     1.349     0.200
    49.698    -0.119     0.200
    50.400     1.594     0.200
    50.400     1.334     0.200
    50.510     1.030     0.200
    50.782    -1.425     0.200
    51.359    -0.572     0.200
    51.775     0.420     0.200
    51.804     0.098     0.200
    51.813    -0.380     0.200
    51.815     0.170     0.200
    51.815    -0.030     0.200
    52.064    -0.439     0.200
    52.137     0.421     0.200
    52.137     0.761     0.200
    52.137     0.121     0.200
    52.320     0.160     0.200
    52.718     0.671     0.200
    53.378    -0.509     0.200
    54.230     1.442     0.200
    54.230     0.783     0.200
    54.482     0.557     0.200
    54.482    -0.033     0.200
    54.648    -0.266     0.200
    54.648     0.592     0.200
    54.742     0.679     0.200
    54.742     0.369     0.200
    55.163     0.968     0.200
    55.318    -0.228     0.200
    55.717     0.466     0.200
    59.153     1.103     0.200
    59.949    -0.387     0.200
    60.374    -0.756     0.200
    60.410    -0.447     0.200
    66.825    -0.219     0.200
    68.211     0.285     0.200
    68.211    -0.085     0.200
    68.211     0.465     0.200
    68.659    -0.086     0.200
    68.659     0.254     0.200
    70.105    -1.084     0.200
    69.988     0.035     0.200
    71.874    -0.224     0.200
    71.874    -0.664     0.200
    73.482     0.606     0.200
    75.485     0.252     0.200
    75.979     0.504     0.200
    76.456     0.034     0.200
    77.419     0.177     0.200
    77.576     0.038     0.200
    77.953    -0.820     0.200
    78.132     0.035     0.200
    78.201     0.382     0.200
    78.316     0.115     0.200
    78.365     0.583     0.200
    78.365    -0.517     0.200
    78.365     0.473     0.200
    78.381     0.579     0.200
    78.579     0.174     0.200
    79.087     0.351     0.200
    79.590     0.266     0.200
    79.951     0.176     0.200
    79.951    -0.894     0.200
    79.974    -0.991     0.200
    80.713     0.032     0.200
    80.794     0.479     0.200
    80.834    -0.552     0.200
    80.976     0.197     0.200
    81.448     0.427     0.200
    83.189    -0.544     0.200
    83.189     0.881     0.200
    83.189     0.381     0.200
    83.449    -0.367     0.200
    87.450    -0.598     0.200
    87.450    -0.413     0.200
    87.452    -0.034     0.200
    89.429    -0.287     0.200
    89.428    -0.236     0.200
    89.461    -0.340     0.200
    89.953    -0.339     0.200
    93.274     0.521     0.200
    14.699     9.236     0.200
    14.772     9.144     0.200
    15.413     7.263     0.200
    18.072     0.998     0.200
    19.342     0.222     0.200
    19.546    -0.757     0.200
    22.642    -0.776     0.200
    23.107     1.133     0.200
    23.107     2.483     0.200
    23.508     1.487     0.200
    25.110    -0.031     0.200
    25.110     0.574     0.200
    26.081     1.219     0.200
    28.658    -0.034     0.200
    28.665     0.794     0.200
    30.313     1.844     0.200
    35.218     0.593     0.200
    36.532    -0.860     0.200
    40.158     0.498     0.200
    40.300     0.523     0.200
    40.300     1.038     0.200
    41.248     0.466     0.200
    41.559     0.392     0.200
    41.570     0.454     0.200
    41.590     0.412     0.200
    41.590    -0.226     0.200
    42.428     0.611     0.200
    42.610     0.338     0.200
    42.610     1.018     0.200
    46.772     1.109     0.200
    48.319     0.507     0.200
    48.531    -0.237     0.200
    51.754     0.183     0.200
    51.756    -0.237     0.200
    51.756     0.043     0.200
    52.112    -0.548     0.200
    52.077     0.053     0.200
    52.377    -0.063     0.200
    54.172     0.901     0.200
    56.613     0.992     0.200
    71.841    -1.116     0.200
    74.405     1.403     0.200
    74.964     0.513     0.200
    75.504     0.824     0.200
    75.991     0.354     0.200
    76.509     1.242     0.200
    77.482     0.766     0.200
    78.213     0.764     0.200
    78.375    -0.250     0.200
    78.375     0.210     0.200
    78.591     0.765     0.200
    79.664     0.174     0.200
    83.183    -0.966     0.200
    87.509    -1.608     0.200
    87.509    -0.553     0.200
    87.511     0.085     0.200
    89.486    -0.881     0.200
    19.334     0.005     0.200
    19.355    -0.764     0.200
    19.509     0.892     0.200
    19.509    -0.015     0.200
    19.509    -0.975     0.200
    20.005     0.995     0.200
    20.112    -0.734     0.200
    20.969     0.246     0.200
    21.439     0.035     0.200
    21.951     1.213     0.200
    23.203     0.088     0.200
    23.203     0.213     0.200
    25.094     0.152     0.200
    25.094    -1.138     0.200
    28.747    -0.035     0.200
    35.293     0.641     0.200
    36.437     0.094     0.200
    36.437    -0.446     0.200
    38.176     0.646     0.200
    40.240     0.919     0.200
    40.364     0.524     0.200
    41.050     0.123     0.200
    41.671     0.641     0.200
    41.671    -0.265     0.200
    51.851     0.069     0.200
    52.311    -0.298     0.200
    71.859     0.545     0.200
    71.859    -1.842     0.200
    78.393    -0.408     0.200
    83.223    -1.121     0.200
    87.413    -0.607     0.200
    87.413    -1.201     0.200
    89.391     0.599     0.200
    16.194     4.204     0.200
    19.400    -0.987     0.200
    19.404    -0.428     0.200
    19.442    -0.122     0.200
    19.618     0.888     0.200
    19.618     0.083     0.200
    19.618    -0.707     0.200
    20.088     0.584     0.200
    20.088     1.225     0.200
    20.195     0.173     0.200
    20.195     0.883     0.200
    20.866     1.354     0.200
    21.944    -0.334     0.200
    21.944    -0.160     0.200
    21.944     1.050     0.200
    22.252     1.073     0.200
    23.068     0.895     0.200
    23.068    -0.214     0.200
    25.178    -0.259     0.200
    25.178     0.052     0.200
    35.496    -0.312     0.200
    35.496     0.082     0.200
    36.576    -0.717     0.200
    36.576    -0.605     0.200
    40.160     1.117     0.200
    41.142     1.374     0.200
    41.593     0.700     0.200
    48.286     0.525     0.200
    51.723     0.273     0.200
    51.723    -0.685     0.200
    71.773    -0.941     0.200
    71.773    -0.710     0.200
    89.516     0.607     0.200
    19.453    -0.259     0.200
    19.453    -0.909     0.200
    25.041     1.068     0.200
    25.041    -0.442     0.200
    40.238     0.653     0.200
    42.110    -0.176     0.200
    87.388    -1.807     0.200
    19.344     0.384     0.200
    19.531    -0.012     0.200
    19.531    -0.889     0.200
    20.013    -0.657     0.200
    20.120    -0.997     0.200
    21.919    -0.241     0.200
    25.103    -0.636     0.200
    25.103    -1.234     0.200
    28.687     1.057     0.200
    35.405     0.691     0.200
    36.500    -1.406     0.200
    41.063     0.243     0.200
    41.595    -0.148     0.200
    41.616     0.490     0.200
    51.788    -1.251     0.200
    15.029     4.690     0.200
    17.232     2.828     0.200
    17.293     2.460     0.200
    17.528     2.933     0.200
    19.314     0.092     0.200
    19.319    -0.382     0.200
    19.319     0.579     0.200
    19.365    -0.306     0.200
    19.365    -0.745     0.200
    19.365     0.434     0.200
    19.541    -0.191     0.200
    19.541     0.036     0.200
    19.541     0.536     0.200
    19.541     0.334     0.200
    19.541    -0.755     0.200
    20.005     1.451     0.200
    20.005     0.223     0.200
    20.005     0.576     0.200
    20.111     1.573     0.200
    20.111     0.603     0.200
    20.111    -0.114     0.200
    20.111     1.712     0.200
    21.250    -0.022     0.200
    21.394    -1.377     0.200
    21.500     0.085     0.200
    21.870     1.118     0.200
    21.854    -0.211     0.200
    21.866     1.460     0.200
    22.486     0.042     0.200
    23.063     1.928     0.200
    23.066     1.197     0.200
    23.066     2.297     0.200
    23.066     0.598     0.200
    23.066     2.047     0.200
    23.066     2.297     0.200
    23.360     1.192     0.200
    25.095     0.080     0.200
    25.095     0.679     0.200
    25.095     0.019     0.200
    25.157    -0.862     0.200
    25.157     1.289     0.200
    25.347     2.392     0.200
    26.970     2.110     0.200
    28.568    -0.189     0.200
    28.593     0.687     0.200
    28.611     0.956     0.200
    28.611    -0.268     0.200
    28.611     0.732     0.200
    28.618     0.738     0.200
    28.618     0.170     0.200
    28.621     0.236     0.200
    29.373     0.842     0.200
    33.802     3.244     0.200
    33.840     0.876     0.200
    34.001     3.979     0.200
    35.170     0.748     0.200
    35.426     1.056     0.200
    35.433     0.399     0.200
    36.377     0.314     0.200
    36.381     0.291     0.200
    36.572     0.541     0.200
    36.586     1.118     0.200
    36.604     0.662     0.200
    36.768     0.247     0.200
    36.725     1.336     0.200
    37.992     1.296     0.200
    38.037    -0.043     0.200
    38.231     1.669     0.200
    38.207     2.157     0.200
    39.645     4.044     0.200
    40.111     0.815     0.200
    41.061    -0.502     0.200
    41.061    -0.773     0.200
    41.543     0.535     0.200
    41.543     0.609     0.200
    42.571     1.064     0.200
    42.996     1.855     0.200
    44.407     0.520     0.200
    46.348     0.585     0.200
    48.484    -0.591     0.200
    50.304     1.896     0.200
    51.712     0.155     0.200
    52.034     0.303     0.200
    52.034    -0.297     0.200
    52.389     0.764     0.200
    52.615     0.209     0.200
    54.128     1.128     0.200
    54.416     0.656     0.200
    54.546     0.255     0.200
    55.061     0.358     0.200
    55.144    -0.214     0.200
    60.174     2.636     0.200
    60.392    -0.019     0.200
    62.200     0.379     0.200
    66.253     0.143     0.200
    68.173     0.647     0.200
    78.345    -0.539     0.200
    78.563     0.085     0.200
    83.145     0.246     0.200
    87.552    -0.555     0.200
    89.530    -0.403     0.200
    89.530    -0.192     0.200
    89.906     0.030     0.200
    19.551     0.538     0.200
    20.023     0.459     0.200
    21.902     0.482     0.200
    25.114    -0.684     0.200
    35.211     1.001     0.200
    36.542    -0.667     0.200
    51.746     0.085     0.200
    87.519    -0.826     0.200
    89.496    -0.598     0.200
    18.093     1.791     0.200
    19.333    -0.357     0.200
    19.337     1.026     0.200
    19.402     0.445     0.200
    19.402     0.550     0.200
    19.578    -0.116     0.200
    19.578    -0.018     0.200
    20.034     1.083     0.200
    20.141    -1.032     0.200
    20.141     1.441     0.200
    21.868     1.263     0.200
    21.868     0.970     0.200
    23.026     2.136     0.200
    25.125     0.249     0.200
    28.582    -0.044     0.200
    35.154     0.960     0.200
    35.467     1.140     0.200
    36.419    -0.175     0.200
    36.613    -0.522     0.200
    41.093    -0.438     0.200
    51.674     0.205     0.200
    87.590    -0.732     0.200
    89.567    -0.489     0.200
    19.664     0.263     0.200
    19.664    -1.116     0.200
    20.111     0.987     0.200
    20.218    -0.173     0.200
    21.900     1.709     0.200
    22.355    -0.529     0.200
    22.964    -0.399     0.200
    25.203    -0.249     0.200
    28.552    -0.778     0.200
    35.149    -0.023     0.200
    35.556     0.928     0.200
    36.680     0.040     0.200
    40.075     0.261     0.200
    41.173    -1.077     0.200
    41.173    -0.225     0.200
    41.509    -1.085     0.200
    51.619    -0.433     0.200
    52.524     1.256     0.200
    71.747    -1.716     0.200
    83.187    -0.006     0.200
    87.645    -0.982     0.200
    89.618    -0.088     0.200
    19.409     0.642     0.200
    19.681    -0.209     0.200
    20.128     0.540     0.200
    21.913     2.293     0.200
    22.959     1.806     0.200
    25.220    -0.427     0.200
    35.573     1.293     0.200
    36.687    -0.232     0.200
    41.190     0.841     0.200
    51.615    -0.115     0.200
    52.539    -0.091     0.200
    87.649    -0.934     0.200
    17.532     2.919     0.200
    19.285    -0.195     0.200
    19.290     1.159     0.200
    19.508     0.241     0.200
    19.972     1.799     0.200
    21.844     1.409     0.200
    21.844     1.269     0.200
    23.079    -1.158     0.200
    23.079     2.740     0.200
    23.940     0.324     0.200
    25.063     0.287     0.200
    28.611     0.871     0.200
    28.611     0.148     0.200
    35.161     1.231     0.200
    35.394     1.278     0.200
    36.556    -0.158     0.200
    40.104    -0.108     0.200
    41.028     0.043     0.200
    41.536    -0.010     0.200
    51.722     0.369     0.200
    52.359    -0.370     0.200
    52.359     0.630     0.200
    78.317    -0.268     0.200
    83.122     0.858     0.200
    87.542    -0.759     0.200
    89.522    -0.490     0.200
    19.475     0.789     0.200
    19.965    -0.344     0.200
    25.054    -0.054     0.200
    35.257     0.500     0.200
    36.445    -0.074     0.200
    51.836     0.367     0.200
    87.428    -0.253     0.200
    89.408    -0.328     0.200
    18.871     0.696     0.200
    19.335    -0.045     0.200
    19.339    -0.551     0.200
    19.574    -0.019     0.200
    20.033     1.749     0.200
    20.139     0.632     0.200
    21.874    -0.471     0.200
    22.271    -0.998     0.200
    25.123     0.417     0.200
    25.123     0.097     0.200
    35.164     1.160     0.200
    35.461     0.943     0.200
    35.461    -0.038     0.200
    36.601     0.475     0.200
    36.601    -0.916     0.200
    41.090    -0.087     0.200
    51.687    -0.859     0.200
    52.425     0.802     0.200
    75.142    -0.033     0.200
    75.982     0.198     0.200
    87.578    -0.417     0.200
    87.578    -0.983     0.200
    19.335     1.251     0.200
    22.135    -0.126     0.200
    22.590    -1.926     0.200
    23.173    -0.123     0.200
    25.079     0.688     0.200
    35.816     0.617     0.200
    36.465     0.748     0.200
    36.465    -0.252     0.200
    41.602    -0.188     0.200
    41.634    -0.035     0.200
    51.819    -0.854     0.200
    51.819    -0.577     0.200
    52.317     0.567     0.200
    53.375     0.287     0.200
    60.103     0.567     0.200
    60.657     0.518     0.200
    60.823     0.615     0.200
    72.134     0.438     0.200
    72.258     0.560     0.200
    73.996    -0.497     0.200
    75.980     0.052     0.200
    76.051     0.040     0.200
    77.220    -0.319     0.200
    77.299    -0.640     0.200
    77.470    -0.189     0.200
    78.133     0.252     0.200
    78.202     0.030     0.200
    78.201     0.261     0.200
    78.580    -0.655     0.200
    87.445    -0.464     0.200
    87.445    -0.620     0.200
    87.448    -0.542     0.200
    89.424     0.146     0.200
    89.424    -1.143     0.200
    19.338     0.618     0.200
    19.565     0.308     0.200
    20.029     0.918     0.200
    23.062     1.362     0.200
    36.578     0.954     0.200
    41.085     1.261     0.200
    52.409    -0.254     0.200
    87.554    -0.801     0.200
    89.531    -0.790     0.200
    17.221     2.635     0.200
    17.247     2.740     0.200
    19.345    -0.311     0.200
    19.349    -1.478     0.200
    19.349    -0.247     0.200
    19.436    -0.436     0.200
    19.436    -1.018     0.200
    19.436     0.814     0.200
    19.613     0.436     0.200
    19.613    -0.490     0.200
    20.060     1.436     0.200
    20.167     1.595     0.200
    20.167    -1.335     0.200
    20.167     1.774     0.200
    20.744     1.324     0.200
    21.467    -0.352     0.200
    21.863     0.982     0.200
    21.863    -0.487     0.200
    21.863     0.693     0.200
    22.269     0.773     0.200
    22.332     1.188     0.200
    22.979     0.959     0.200
    22.979     0.389     0.200
    22.979     0.729     0.200
    25.151     0.471     0.200
    25.151    -0.658     0.200
    25.252     2.279     0.200
    25.252     0.451     0.200
    28.546     0.339     0.200
    28.546    -0.278     0.200
    28.553     1.160     0.200
    28.553     0.410     0.200
    29.295     3.788     0.200
    30.193     0.653     0.200
    30.191     2.263     0.200
    33.731     2.894     0.200
    35.129     0.802     0.200
    36.467     0.456     0.200
    36.471     0.466     0.200
    36.554     0.479     0.200
    36.662     0.040     0.200
    37.915     0.856     0.200
    38.624     1.380     0.200
    39.986     1.380     0.200
    41.122    -0.161     0.200
    41.122    -0.337     0.200
    41.462     0.117     0.200
    41.493     0.460     0.200
    41.493    -0.212     0.200
    42.465     0.155     0.200
    46.647     0.746     0.200
    51.628     0.420     0.200
    51.629     0.457     0.200
    51.629     0.078     0.200
    52.074     0.678     0.200
    52.479     0.129     0.200
    52.479     0.679     0.200
    57.213     3.336     0.200
    78.107     1.425     0.200
    78.370    -0.373     0.200
    78.370    -0.643     0.200
    87.635    -0.566     0.200
    87.635    -0.019     0.200
    89.611    -0.363     0.200
    89.611     0.324     0.200
    19.392     0.416     0.200
    19.635     0.605     0.200
    20.094     0.748     0.200
    21.919     1.037     0.200
    23.019     0.864     0.200
    25.185     0.276     0.200
    35.187     0.175     0.200
    36.625     0.605     0.200
    40.117     0.499     0.200
    40.289     0.244     0.200
    41.153    -0.531     0.200
    41.551    -0.135     0.200
    51.673     0.216     0.200
    87.591     0.376     0.200
    89.565     0.014     0.200
    14.671     8.954     0.200
    16.535     6.128     0.200
    17.247     3.460     0.200
    17.247     3.058     0.200
    17.409     3.740     0.200
    17.483     2.623     0.200
    18.832     0.508     0.200
    19.050     1.280     0.200
    19.360     0.209     0.200
    19.364    -0.423     0.200
    19.364    -0.103     0.200
    19.438    -0.597     0.200
    19.438    -0.097     0.200
    19.324     1.352     0.200
    19.614    -0.098     0.200
    19.614     0.300     0.200
    19.614     0.652     0.200
    19.614     0.038     0.200
    19.667     1.833     0.200
    20.068     1.432     0.200
    20.174     1.516     0.200
    20.174     0.137     0.200
    20.174     0.997     0.200
    20.113     2.037     0.200
    20.362     1.674     0.200
    20.531     0.123     0.200
    20.768     2.045     0.200
    20.804     2.335     0.200
    20.804     2.097     0.200
    20.893     1.591     0.200
    21.137    -0.701     0.200
    21.320    -0.005     0.200
    21.238     1.781     0.200
    21.282     1.801     0.200
    21.468    -0.101     0.200
    21.571     1.397     0.200
    21.924     2.006     0.200
    21.949     1.145     0.200
    21.884     1.402     0.200
    21.884     0.433     0.200
    21.884     1.035     0.200
    21.949     1.274     0.200
    22.020     1.482     0.200
    22.210     1.149     0.200
    22.311     0.461     0.200
    22.311     0.352     0.200
    22.286     2.430     0.200
    22.555     1.179     0.200
    22.726    -1.133     0.200
    23.000     1.371     0.200
    23.003     1.089     0.200
    23.003     1.339     0.200
    23.003     1.538     0.200
    23.003     0.839     0.200
    23.003     1.300     0.200
    23.003     2.339     0.200
    23.106     0.147     0.200
    23.281    -1.292     0.200
    23.319    -0.596     0.200
    23.572     0.380     0.200
    23.532     2.320     0.200
    23.570     1.405     0.200
    23.662     1.952     0.200
    24.045     1.259     0.200
    24.282     1.196     0.200
    24.920     2.137     0.200
    25.159     0.710     0.200
    25.159     0.358     0.200
    25.159     0.210     0.200
    25.233     0.846     0.200
    25.233     1.064     0.200
    25.351    -0.038     0.200
    25.461     1.090     0.200
    26.267     0.492     0.200
    26.949     0.102     0.200
    27.745     1.421     0.200
    28.530     0.458     0.200
    28.555     1.136     0.200
    28.573     0.678     0.200
    28.573     0.576     0.200
    28.573     1.076     0.200
    28.580     0.827     0.200
    28.580     0.386     0.200
    28.584     0.582     0.200
    28.844     1.692     0.200
    29.188     0.714     0.200
    29.240     1.451     0.200
    29.240     1.123     0.200
    29.321     3.242     0.200
    30.352     2.103     0.200
    30.220     1.150     0.200
    30.220     1.673     0.200
    30.217     2.065     0.200
    30.477     2.700     0.200
    30.888     1.017     0.200
    31.613     0.859     0.200
    32.280    -0.013     0.200
    32.354     1.595     0.200
    32.354     1.416     0.200
    32.395     2.631     0.200
    33.061     1.084     0.200
    32.956     2.399     0.200
    33.151     1.894     0.200
    33.332     1.322     0.200
    33.332     1.052     0.200
    33.409     0.660     0.200
    33.701    -0.039     0.200
    33.758     3.154     0.200
    33.792     2.396     0.200
    33.987     0.948     0.200
    33.936     0.762     0.200
    33.936     0.453     0.200
    34.250     2.828     0.200
    34.841     1.208     0.200
    35.155     0.637     0.200
    35.155     1.406     0.200
    35.300     1.814     0.200
    35.504     0.941     0.200
    35.504     0.671     0.200
    35.517    -0.711     0.200
    35.436     2.845     0.200
    35.948     1.290     0.200
    35.948     1.880     0.200
    35.994     0.265     0.200
    36.444     0.166     0.200
    36.444     0.018     0.200
    36.448     0.121     0.200
    36.485     0.555     0.200
    36.639    -0.311     0.200
    36.639    -0.261     0.200
    36.639     0.009     0.200
    36.639     0.290     0.200
    36.653    -0.634     0.200
    36.671    -0.590     0.200
    36.677     1.429     0.200
    37.941     1.082     0.200
    37.991     1.070     0.200
    38.841     1.861     0.200
    39.162    -0.653     0.200
    39.000     1.857     0.200
    40.136     0.334     0.200
    40.087     0.598     0.200
    40.254     0.980     0.200
    40.254     0.332     0.200
    40.965     1.135     0.200
    41.127     0.047     0.200
    41.151     1.007     0.200
    41.520    -0.053     0.200
    41.520    -0.279     0.200
    41.870     0.623     0.200
    42.504     0.504     0.200
    42.504     0.606     0.200
    43.046     1.174     0.200
    46.672     0.880     0.200
    47.058    -0.539     0.200
    47.716    -0.286     0.200
    48.217     0.572     0.200
    48.448     0.535     0.200
    49.783     0.385     0.200
    50.309    -0.626     0.200
    51.653     0.238     0.200
    51.654     0.000     0.200
    52.471    -0.524     0.200
    52.471    -0.395     0.200
    52.471     0.546     0.200
    53.514    -0.099     0.200
    53.514    -0.438     0.200
    54.480     0.667     0.200
    59.899     0.917     0.200
    60.024     0.334     0.200
    60.963    -0.388     0.200
    66.373    -1.192     0.200
    66.373    -0.810     0.200
    66.373    -0.993     0.200
    68.572     0.121     0.200
    71.792    -0.764     0.200
    71.792    -0.213     0.200
    73.673     0.955     0.200
    73.723     0.807     0.200
    74.024     0.511     0.200
    74.287     1.084     0.200
    74.369     1.096     0.200
    74.415     0.749     0.200
    75.167     0.294     0.200
    75.511     1.203     0.200
    75.577     0.639     0.200
    76.006     0.532     0.200
    77.014     0.518     0.200
    77.499     1.076     0.200
    77.832     0.689     0.200
    78.231     0.971     0.200
    78.386     0.554     0.200
    78.386     0.202     0.200
    78.729     0.547     0.200
    79.680     0.451     0.200
    79.918     1.012     0.200
    80.107     0.375     0.200
    81.001     0.339     0.200
    82.128     0.071     0.200
    83.168    -0.411     0.200
    83.168     0.124     0.200
    83.168     0.566     0.200
    83.486     0.683     0.200
    87.610    -0.841     0.200
    87.613    -0.427     0.200
    89.585    -0.189     0.200
    36.606    -0.581     0.200
    41.136     1.495     0.200
    51.690    -0.937     0.200
    52.459    -0.055     0.200
    87.575    -1.014     0.200
    89.549    -0.300     0.200
    25.109     0.832     0.200
    36.555    -0.127     0.200
    41.568     0.471     0.200
    51.732     0.487     0.200
    87.532    -0.321     0.200
    18.173     1.478     0.200
    19.320    -0.957     0.200
    19.338    -0.704     0.200
    19.514    -0.567     0.200
    19.514     0.050     0.200
    19.992     0.481     0.200
    21.366     1.362     0.200
    21.894     0.923     0.200
    21.894     1.134     0.200
    22.175    -0.632     0.200
    23.131     1.400     0.200
    23.131     1.025     0.200
    25.081    -0.521     0.200
    28.670     0.521     0.200
    35.220     0.274     0.200
    35.390     0.416     0.200
    35.390    -0.373     0.200
    36.507     0.432     0.200
    36.507    -0.225     0.200
    40.297     1.986     0.200
    41.043     0.104     0.200
    41.043     0.385     0.200
    41.596     0.836     0.200
    41.596     0.711     0.200
    51.777     0.503     0.200
    78.354     0.195     0.200
    87.487     0.090     0.200
    87.487    -0.991     0.200
    87.487     0.235     0.200
    89.466    -0.114     0.200
    89.466    -0.419     0.200
    14.822     9.005     0.200
    15.049     4.244     0.200
    15.182     3.292     0.200
    16.905     4.203     0.200
    17.968     0.453     0.200
    18.002     1.313     0.200
    18.127     1.123     0.200
    18.213     1.599     0.200
    18.905     0.003     0.200
    19.324    -1.387     0.200
    19.324    -1.071     0.200
    19.324    -0.946     0.200
    19.324    -1.677     0.200
    19.321    -0.303     0.200
    19.325    -0.933     0.200
    19.325    -1.493     0.200
    19.519     0.375     0.200
    19.500    -0.811     0.200
    19.500    -1.300     0.200
    19.500    -0.311     0.200
    19.500    -0.886     0.200
    19.500    -1.321     0.200
    19.463     1.497     0.200
    19.797     1.747     0.200
    19.984     0.277     0.200
    19.984    -0.058     0.200
    19.984     1.303     0.200
    20.091    -0.262     0.200
    20.091     0.634     0.200
    20.091     0.528     0.200
    20.091    -0.031     0.200
    20.091    -1.573     0.200
    20.091     0.339     0.200
    20.091     0.215     0.200
    20.091     0.738     0.200
    20.367    -0.568     0.200
    20.275     2.303     0.200
    20.973    -0.430     0.200
    20.973    -0.841     0.200
    20.965     3.194     0.200
    21.048     2.311     0.200
    21.156     0.892     0.200
    21.407    -0.005     0.200
    21.420     2.861     0.200
    21.397     1.696     0.200
    21.420     1.748     0.200
    21.701     1.281     0.200
    21.811     1.179     0.200
    21.905     0.944     0.200
    21.905     1.064     0.200
    21.905     0.763     0.200
    21.905     0.545     0.200
    22.146     0.270     0.200
    22.157     0.459     0.200
    22.186     0.890     0.200
    22.194     3.063     0.200
    22.194     1.563     0.200
    22.221     0.667     0.200
    22.392     0.948     0.200
    22.371     2.875     0.200
    22.527     0.271     0.200
    22.452     2.899     0.200
    22.452     1.540     0.200
    22.604    -0.208     0.200
    22.913     3.126     0.200
    23.048    -0.465     0.200
    23.116     0.273     0.200
    23.152     1.391     0.200
    23.157     1.448     0.200
    23.160     1.217     0.200
    23.160     1.216     0.200
    23.160     0.652     0.200
    23.160     1.417     0.200
    23.160     0.516     0.200
    23.160     1.116     0.200
    23.160     0.316     0.200
    23.213    -0.248     0.200
    23.326    -0.810     0.200
    23.450     0.991     0.200
    23.425     0.422     0.200
    23.446     1.502     0.200
    23.446     0.792     0.200
    23.446     2.403     0.200
    23.545     2.288     0.200
    23.565     0.583     0.200
    23.565     1.434     0.200
    23.565     0.383     0.200
    23.677     2.161     0.200
    23.691     1.571     0.200
    23.710     0.654     0.200
    23.858     0.076     0.200
    23.819     0.962     0.200
    23.819     1.402     0.200
    23.819     1.181     0.200
    23.819     1.619     0.200
    23.819     1.282     0.200
    23.935     1.202     0.200
    23.904     3.266     0.200
    24.040    -0.600     0.200
    24.270     2.633     0.200
    24.390     0.113     0.200
    24.395     1.093     0.200
    24.383     0.410     0.200
    24.553     1.632     0.200
    24.499     2.597     0.200
    24.769     0.954     0.200
    24.899     3.981     0.200
    24.981     0.034     0.200
    25.066     0.955     0.200
    25.066     1.084     0.200
    25.073     0.220     0.200
    25.073    -0.557     0.200
    25.073    -0.086     0.200
    25.073    -0.380     0.200
    25.073     0.070     0.200
    25.362     2.506     0.200
    25.401     0.947     0.200
    25.578     0.637     0.200
    25.578     0.965     0.200
    25.578     1.777     0.200
    25.578     1.287     0.200
    25.752     2.370     0.200
    25.942    -0.511     0.200
    25.943     1.982     0.200
    26.297     2.003     0.200
    26.402     2.553     0.200
    26.430     0.463     0.200
    26.675     1.314     0.200
    26.829    -1.108     0.200
    26.756     1.817     0.200
    26.807     0.085     0.200
    26.873     2.713     0.200
    26.994     2.217     0.200
    27.044     0.085     0.200
    27.044     2.397     0.200
    27.044     0.794     0.200
    27.044     1.875     0.200
    27.044     1.085     0.200
    27.188     1.608     0.200
    27.300     2.045     0.200
    27.335     2.958     0.200
    27.351     1.836     0.200
    27.358     3.016     0.200
    27.401     0.031     0.200
    27.418     1.528     0.200
    27.420     2.443     0.200
    27.435     2.062     0.200
    27.522     2.991     0.200
    27.572     1.088     0.200
    27.572     2.003     0.200
    27.572     1.344     0.200
    27.572     1.543     0.200
    27.620    -0.149     0.200
    27.620     0.964     0.200
    27.679     0.528     0.200
    27.813     2.789     0.200
    27.819     2.794     0.200
    27.888     1.727     0.200
    27.888     2.117     0.200
    28.008     0.924     0.200
    27.917     1.409     0.200
    27.949     0.872     0.200
    27.956     1.554     0.200
    27.958     1.780     0.200
    28.053    -0.253     0.200
    28.072     1.822     0.200
    28.096     0.304     0.200
    28.052     2.890     0.200
    28.075     0.356     0.200
    28.078     2.660     0.200
    28.153     3.100     0.200
    28.223     0.486     0.200
    28.222     1.061     0.200
    28.225     2.820     0.200
    28.354     3.159     0.200
    28.292    -0.041     0.200
    28.338     0.616     0.200
    28.337     1.540     0.200
    28.352     2.273     0.200
    28.357     2.035     0.200
    28.374     0.318     0.200
    28.415     1.819     0.200
    28.415     0.389     0.200
    28.416     2.584     0.200
    28.447     2.630     0.200
    28.500     1.591     0.200
    28.519     2.221     0.200
    28.689     1.454     0.200
    28.649     2.708     0.200
    28.653     0.697     0.200
    28.756     0.339     0.200
    28.679     0.672     0.200
    28.693     1.828     0.200
    28.696     0.443     0.200
    28.696     0.717     0.200
    28.696     0.818     0.200
    28.703     0.825     0.200
    28.703     0.556     0.200
    28.698     1.539     0.200
    28.703     2.123     0.200
    28.707     0.723     0.200
    28.737     1.670     0.200
    28.741     3.108     0.200
    28.749     3.002     0.200
    28.753     0.709     0.200
    28.761     0.640     0.200
    28.777     1.399     0.200
    28.796     0.482     0.200
    28.796     1.633     0.200
    28.797     1.225     0.200
    28.818     1.449     0.200
    28.831     0.715     0.200
    28.893     2.258     0.200
    28.893     3.368     0.200
    28.893     3.618     0.200
    28.893     1.848     0.200
    28.853     0.713     0.200
    28.853     1.916     0.200
    28.912     1.835     0.200
    28.914     2.551     0.200
    28.923     3.019     0.200
    28.943     1.805     0.200
    28.970     2.286     0.200
    29.076     0.279     0.200
    28.985     2.777     0.200
    28.985     1.748     0.200
    28.990     3.003     0.200
    28.990     2.685     0.200
    28.991     3.227     0.200
    29.007     0.766     0.200
    29.036     2.896     0.200
    29.036     3.173     0.200
    29.036     2.004     0.200
    29.066     0.362     0.200
    29.118     0.885     0.200
    29.130     2.545     0.200
    29.207     0.662     0.200
    29.177     0.028     0.200
    29.211     3.088     0.200
    29.222     1.279     0.200
    29.249     3.004     0.200
    29.371     0.807     0.200
    29.299     2.797     0.200
    29.315     1.428     0.200
    29.315     0.484     0.200
    29.315     1.020     0.200
    29.349     1.946     0.200
    29.366     2.037     0.200
    29.389     2.280     0.200
    29.423     0.654     0.200
    29.394     1.042     0.200
    29.394     1.417     0.200
    29.403     0.969     0.200
    29.415     2.578     0.200
    29.423     1.256     0.200
    29.428     2.786     0.200
    29.464     3.628     0.200
    29.464     2.897     0.200
    29.496     1.683     0.200
    29.582     1.886     0.200
    29.597     0.228     0.200
    29.597     0.924     0.200
    29.597     0.419     0.200
    29.616     1.224     0.200
    29.673     0.302     0.200
    29.718    -0.268     0.200
    29.726     0.408     0.200
    29.726    -0.642     0.200
    29.726     2.373     0.200
    29.754     2.183     0.200
    29.757    -0.305     0.200
    29.768    -0.605     0.200
    29.780     0.032     0.200
    29.805     2.709     0.200
    29.821     0.481     0.200
    29.821     0.293     0.200
    29.822     0.031     0.200
    29.924     2.361     0.200
    29.929     0.480     0.200
    29.964     1.251     0.200
    30.022     1.434     0.200
    30.043     1.039     0.200
    30.014     0.653     0.200
    30.016     2.309     0.200
    30.068     1.846     0.200
    30.082     2.212     0.200
    30.121     0.327     0.200
    30.141     1.360     0.200
    30.148     1.629     0.200
    30.167     0.988     0.200
    30.234     1.487     0.200
    30.171     2.401     0.200
    30.210     0.331     0.200
    30.323     1.798     0.200
    30.340     1.848     0.200
    30.358    -1.122     0.200
    30.358     0.175     0.200
    30.357     1.599     0.200
    30.361     2.670     0.200
    30.365     1.109     0.200
    30.416    -0.576     0.200
    30.469     0.196     0.200
    30.485     0.136     0.200
    30.541     0.996     0.200
    30.559     0.946     0.200
    30.565     2.578     0.200
    30.582     0.630     0.200
    30.607     2.222     0.200
    30.644     2.358     0.200
    30.650     3.420     0.200
    30.659     1.069     0.200
    30.692    -0.728     0.200
    30.761     0.718     0.200
    30.746     0.430     0.200
    30.813     0.399     0.200
    30.819     2.101     0.200
    30.826     2.233     0.200
    30.827     0.588     0.200
    30.837     2.254     0.200
    30.842     0.389     0.200
    30.864     0.885     0.200
    30.894    -0.244     0.200
    30.937     0.044     0.200
    30.937     0.462     0.200
    30.999     1.650     0.200
    30.973     0.097     0.200
    30.975     1.349     0.200
    30.975     3.116     0.200
    30.990     0.763     0.200
    31.143     2.435     0.200
    31.143     1.618     0.200
    31.143     2.740     0.200
    31.048     0.901     0.200
    31.053     0.538     0.200
    31.057     2.392     0.200
    31.061     1.317     0.200
    31.061     0.053     0.200
    31.108     1.327     0.200
    31.115     2.612     0.200
    31.125     0.049     0.200
    31.166     2.154     0.200
    31.195     2.140     0.200
    31.201     0.122     0.200
    31.206     0.286     0.200
    31.245     0.780     0.200
    31.213     0.168     0.200
    31.233    -0.143     0.200
    31.236     0.010     0.200
    31.247     0.712     0.200
    31.257     0.608     0.200
    31.265     1.777     0.200
    31.295     0.009     0.200
    31.307     2.821     0.200
    31.338     1.532     0.200
    31.349    -0.062     0.200
    31.350     0.789     0.200
    31.384     1.715     0.200
    31.387     0.332     0.200
    31.415    -0.070     0.200
    31.436    -0.365     0.200
    31.439    -0.259     0.200
    31.446    -1.191     0.200
    31.448    -1.153     0.200
    31.454     1.865     0.200
    31.455     1.856     0.200
    31.488    -0.332     0.200
    31.519    -0.482     0.200
    31.521    -0.409     0.200
    31.523     3.177     0.200
    31.541     0.269     0.200
    31.598     1.536     0.200
    31.612    -1.122     0.200
    31.630     2.869     0.200
    31.632     0.587     0.200
    31.630     2.528     0.200
    31.664     0.872     0.200
    31.692    -0.075     0.200
    31.703    -1.563     0.200
    31.723     0.682     0.200
    31.727     1.764     0.200
    31.732     0.447     0.200
    31.758     0.936     0.200
    31.767     0.179     0.200
    31.827    -1.051     0.200
    31.870     0.368     0.200
    31.880     1.928     0.200
    31.880     2.168     0.200
    31.917    -0.215     0.200
    31.952     0.440     0.200
    32.021    -0.941     0.200
    32.059    -1.054     0.200
    32.189     1.653     0.200
    32.189     3.394     0.200
    32.189     2.175     0.200
    32.189     1.368     0.200
    32.130    -0.125     0.200
    32.140     2.394     0.200
    32.204     1.921     0.200
    32.157     2.001     0.200
    32.160     1.265     0.200
    32.194    -0.647     0.200
    32.208     1.773     0.200
    32.208     2.288     0.200
    32.208     2.633     0.200
    32.272     0.394     0.200
    32.273    -0.761     0.200
    32.283    -0.538     0.200
    32.281     2.380     0.200
    32.311    -0.987     0.200
    32.344     2.069     0.200
    32.364     0.563     0.200
    32.361     1.698     0.200
    32.394     2.451     0.200
    32.442    -0.789     0.200
    32.442    -0.001     0.200
    32.472     1.522     0.200
    32.497     1.510     0.200
    32.497     1.649     0.200
    32.529     2.174     0.200
    32.535     1.997     0.200
    32.543     0.383     0.200
    32.565     0.559     0.200
    32.568     0.844     0.200
    32.640     2.005     0.200
    32.581     0.708     0.200
    32.588     0.248     0.200
    32.604     0.048     0.200
    32.694     1.529     0.200
    32.702    -0.810     0.200
    32.717     0.461     0.200
    32.763    -2.077     0.200
    32.895     0.669     0.200
    32.802    -0.402     0.200
    32.814     1.610     0.200
    32.817     0.565     0.200
    32.857    -0.740     0.200
    32.974    -0.448     0.200
    33.019     1.588     0.200
    33.092     2.586     0.200
    33.206     1.652     0.200
    33.223    -0.450     0.200
    33.232    -0.898     0.200
    33.245    -0.151     0.200
    33.247    -0.751     0.200
    33.266    -0.227     0.200
    33.266    -0.640     0.200
    33.284     1.568     0.200
    33.319     1.261     0.200
    33.324    -1.200     0.200
    33.329    -0.246     0.200
    33.329    -0.025     0.200
    33.356    -1.652     0.200
    33.368    -1.157     0.200
    33.379     0.633     0.200
    33.397     1.680     0.200
    33.397     0.880     0.200
    33.397     1.360     0.200
    33.429    -0.441     0.200
    33.442     2.128     0.200
    33.442     0.988     0.200
    33.442     0.477     0.200
    33.540    -1.648     0.200
    33.540    -0.785     0.200
    33.603     3.374     0.200
    33.603     2.781     0.200
    33.616    -0.075     0.200
    33.648     0.645     0.200
    33.827     0.763     0.200
    33.827     1.218     0.200
    33.824    -0.753     0.200
    33.923     1.207     0.200
    33.891     2.914     0.200
    33.891     4.144     0.200
    33.930     3.043     0.200
    33.930     2.883     0.200
    33.972     2.377     0.200
    34.088     0.931     0.200
    34.088     0.471     0.200
    34.087     2.277     0.200
    34.088     0.815     0.200
    34.175     1.074     0.200
    34.239     2.005     0.200
    34.239     2.268     0.200
    34.239     1.558     0.200
    34.239     3.002     0.200
    34.225     1.594     0.200
    34.293     1.392     0.200
    34.354     1.094     0.200
    34.354     2.256     0.200
    34.385     2.399     0.200
    34.569     0.701     0.200
    34.599     1.638     0.200
    34.614     1.929     0.200
    34.614     2.069     0.200
    34.668     1.344     0.200
    34.680     0.942     0.200
    34.685     1.401     0.200
    34.748     1.653     0.200
    34.705     2.565     0.200
    34.705     0.415     0.200
    34.939    -0.093     0.200
    34.863     0.717     0.200
    34.937     1.421     0.200
    34.965     1.977     0.200
    34.967     2.359     0.200
    34.984     1.229     0.200
    34.987     1.488     0.200
    35.080     0.386     0.200
    35.132     0.542     0.200
    35.145     0.526     0.200
    35.179     2.572     0.200
    35.217     1.409     0.200
    35.241     1.621     0.200
    35.241     1.500     0.200
    35.242     1.593     0.200
    35.249     4.030     0.200
    35.372     1.493     0.200
    35.372     1.323     0.200
    35.310     2.055     0.200
    35.310     1.235     0.200
    35.379     0.716     0.200
    35.385     0.760     0.200
    35.340     2.251     0.200
    35.340     2.451     0.200
    35.479     2.675     0.200
    35.517     3.214     0.200
    35.517     2.508     0.200
    35.583     2.372     0.200
    35.583     1.063     0.200
    35.583     1.388     0.200
    35.593     1.271     0.200
    35.599     1.322     0.200
    35.601     4.286     0.200
    35.638     1.289     0.200
    35.719     2.335     0.200
    35.719     1.788     0.200
    35.723     1.254     0.200
    35.816     1.090     0.200
    35.816     1.618     0.200
    35.816     1.379     0.200
    35.923     0.396     0.200
    35.921     2.609     0.200
    35.988     1.488     0.200
    36.047     0.976     0.200
    36.102    -0.880     0.200
    36.102     0.553     0.200
    36.102     0.345     0.200
    36.115     1.447     0.200
    36.143     1.742     0.200
    36.283     0.355     0.200
    36.283     0.100     0.200
    36.283    -0.380     0.200
    36.287     0.067     0.200
    36.198     1.984     0.200
    36.247     2.522     0.200
    36.315     0.390     0.200
    36.319     0.542     0.200
    36.247     1.972     0.200
    36.273     2.357     0.200
    36.273     1.447     0.200
    36.273     1.676     0.200
    36.283     1.223     0.200
    36.321     1.031     0.200
    36.375     2.361     0.200
    36.375     1.544     0.200
    36.478     0.048     0.200
    36.478     0.497     0.200
    36.478     0.048     0.200
    36.492    -0.026     0.200
    36.510    -0.082     0.200
    36.446     2.947     0.200
    36.501     1.251     0.200
    36.526     2.092     0.200
    36.526     0.852     0.200
    36.576     3.009     0.200
    36.576     2.259     0.200
    36.630     1.358     0.200
    36.663     1.828     0.200
    36.663     2.568     0.200
    36.671     2.885     0.200
    36.671     2.745     0.200
    36.724     1.419     0.200
    36.777     2.942     0.200
    36.793     3.075     0.200
    36.808     2.202     0.200
    36.808     1.842     0.200
    36.808     1.292     0.200
    36.818     1.458     0.200
    36.818     1.255     0.200
    36.819     1.788     0.200
    36.836     1.892     0.200
    36.836     1.192     0.200
    36.846     1.718     0.200
    36.863     0.614     0.200
    36.905     1.645     0.200
    36.971     1.291     0.200
    36.992     1.718     0.200
    37.090     1.324     0.200
    37.131     1.479     0.200
    37.256     0.709     0.200
    37.384     1.466     0.200
    37.441     0.714     0.200
    37.460     2.404     0.200
    37.460     1.553     0.200
    37.464     1.215     0.200
    37.468     1.284     0.200
    37.531    -0.008     0.200
    37.531     1.153     0.200
    37.531     0.143     0.200
    37.671     2.183     0.200
    37.671     1.654     0.200
    37.697     1.042     0.200
    37.710     0.652     0.200
    37.710    -0.378     0.200
    37.724     2.103     0.200
    37.749     2.546     0.200
    37.848     1.962     0.200
    37.954     1.660     0.200
    38.011     2.082     0.200
    38.019     0.446     0.200
    38.045     0.574     0.200
    38.088     1.363     0.200
    38.114     1.052     0.200
    38.127     2.105     0.200
    38.127     1.663     0.200
    38.139     2.133     0.200
    38.144    -0.682     0.200
    38.176     2.365     0.200
    38.226     1.838     0.200
    38.226     1.269     0.200
    38.230     0.921     0.200
    38.258     0.912     0.200
    38.258     0.612     0.200
    38.294     2.136     0.200
    38.298     2.426     0.200
    38.298     1.581     0.200
    38.427     0.177     0.200
    38.427     0.487     0.200
    38.373     2.509     0.200
    38.421     1.408     0.200
    38.421     2.486     0.200
    38.421     1.827     0.200
    38.421     0.382     0.200
    38.447     2.199     0.200
    38.447     1.308     0.200
    38.447     1.567     0.200
    38.547     1.530     0.200
    38.667     2.101     0.200
    38.686     1.523     0.200
    38.686     1.260     0.200
    38.758     0.739     0.200
    38.780     2.349     0.200
    38.780     1.909     0.200
    38.835     2.733     0.200
    39.005     0.023     0.200
    38.918     1.614     0.200
    38.839     2.267     0.200
    39.133     0.576     0.200
    39.035     1.972     0.200
    39.040     2.620     0.200
    39.040     2.138     0.200
    39.049     1.812     0.200
    39.126     0.276     0.200
    39.135     0.700     0.200
    39.212     1.090     0.200
    39.159     2.355     0.200
    39.186     1.699     0.200
    39.237     2.539     0.200
    39.465     0.582     0.200
    39.499     2.385     0.200
    39.505     0.556     0.200
    39.581     1.560     0.200
    39.539     2.174     0.200
    39.539     2.756     0.200
    39.570     1.835     0.200
    39.597     1.874     0.200
    39.713     1.269     0.200
    39.734     2.377     0.200
    39.756     0.436     0.200
    39.794     2.811     0.200
    39.794     2.349     0.200
    39.827     0.221     0.200
    39.972     0.283     0.200
    39.897     2.282     0.200
    39.975     2.133     0.200
    39.975     1.591     0.200
    40.068     0.863     0.200
    40.068     1.203     0.200
    40.068     1.854     0.200
    40.058     0.172     0.200
    40.086     0.526     0.200
    40.119     1.651     0.200
    40.188    -0.179     0.200
    40.357     0.865     0.200
    40.302     2.232     0.200
    40.302     1.779     0.200
    40.302     3.439     0.200
    40.313     0.628     0.200
    40.313     1.552     0.200
    40.313     1.028     0.200
    40.389     1.405     0.200
    40.321     1.162     0.200
    40.409     1.382     0.200
    40.416     1.881     0.200
    40.464     2.715     0.200
    40.464     2.193     0.200
    40.467     2.761     0.200
    40.499     0.402     0.200
    40.499     0.900     0.200
    40.721     0.338     0.200
    40.660     0.371     0.200
    40.660    -0.095     0.200
    40.696     2.225     0.200
    40.696     3.870     0.200
    40.702     2.722     0.200
    40.702     2.120     0.200
    41.033     0.235     0.200
    41.033     0.015     0.200
    41.049     2.434     0.200
    41.137     1.328     0.200
    41.053     1.427     0.200
    41.053     0.347     0.200
    41.102     1.054     0.200
    41.102     1.422     0.200
    41.129     0.606     0.200
    41.154     3.361     0.200
    41.294     0.944     0.200
    41.337     1.292     0.200
    41.425     0.360     0.200
    41.489     1.817     0.200
    41.525     2.437     0.200
    41.587     0.412     0.200
    41.601     2.844     0.200
    41.601     2.321     0.200
    41.707     0.112     0.200
    41.707    -0.648     0.200
    41.619     0.169     0.200
    41.619     0.669     0.200
    41.619     0.070     0.200
    41.648     2.094     0.200
    41.681     0.200     0.200
    41.682     1.271     0.200
    41.682     1.161     0.200
    41.682     0.341     0.200
    41.682     0.752     0.200
    41.692     2.155     0.200
    41.754     3.993     0.200
    41.827     0.697     0.200
    41.827     1.226     0.200
    41.827     0.296     0.200
    42.058     1.175     0.200
    42.058     1.465     0.200
    42.058     0.414     0.200
    42.104     2.492     0.200
    42.177     1.810     0.200
    42.104     1.910     0.200
    42.221     1.749     0.200
    42.155     1.698     0.200
    42.344     0.299     0.200
    42.443     0.037     0.200
    42.374     2.540     0.200
    42.374     1.958     0.200
    42.534    -0.805     0.200
    42.495     0.658     0.200
    42.495     2.208     0.200
    42.495     1.067     0.200
    42.495     0.888     0.200
    42.495     1.717     0.200
    42.495     2.677     0.200
    42.457     1.126     0.200
    42.468     0.779     0.200
    42.468     1.338     0.200
    42.468     1.008     0.200
    42.483     2.875     0.200
    42.483     2.424     0.200
    42.702     0.427     0.200
    42.638     1.584     0.200
    42.663     1.633     0.200
    42.665     1.361     0.200
    42.665     1.636     0.200
    42.813     1.627     0.200
    42.733     1.786     0.200
    42.854     1.883     0.200
    43.086     2.673     0.200
    43.086     1.058     0.200
    43.086     1.643     0.200
    43.086     2.481     0.200
    43.140    -0.088     0.200
    43.140     0.756     0.200
    43.140     1.129     0.200
    43.140     0.897     0.200
    43.140     1.427     0.200
    43.165     2.655     0.200
    43.165     0.835     0.200
    43.397     1.796     0.200
    43.519     0.223     0.200
    43.671     1.258     0.200
    43.671     2.159     0.200
    43.742     1.015     0.200
    43.847     0.686     0.200
    43.962     0.585     0.200
    43.995     2.296     0.200
    43.995     1.593     0.200
    44.004     1.449     0.200
    44.080     1.811     0.200
    44.176     1.670     0.200
    44.249     0.156     0.200
    44.249     2.056     0.200
    44.249     1.176     0.200
    44.258     1.883     0.200
    44.209     1.610     0.200
    44.257     1.391     0.200
    44.266     0.482     0.200
    44.387     1.348     0.200
    44.358     2.184     0.200
    44.391     1.651     0.200
    44.499     1.008     0.200
    44.499     1.607     0.200
    44.499     0.857     0.200
    44.499     0.727     0.200
    44.517     1.513     0.200
    44.630     2.209     0.200
    44.753     0.427     0.200
    44.770     0.895     0.200
    44.862     1.559     0.200
    44.966     0.128     0.200
    44.966    -0.641     0.200
    45.091     3.572     0.200
    45.174     1.575     0.200
    45.299     1.687     0.200
    45.598     1.217     0.200
    45.693     0.756     0.200
    45.693     1.323     0.200
    45.693     0.963     0.200
    46.118     0.406     0.200
    46.118    -0.446     0.200
    46.268     1.851     0.200
    46.308    -0.086     0.200
    46.440     0.953     0.200
    46.730    -1.696     0.200
    46.565    -0.310     0.200
    46.600     0.416     0.200
    46.730    -1.136     0.200
    46.730    -1.537     0.200
    46.731    -0.009     0.200
    46.857     0.253     0.200
    46.857     1.028     0.200
    46.857     0.008     0.200
    46.786     0.263     0.200
    46.794     0.697     0.200
    46.860     0.884     0.200
    46.953    -0.154     0.200
    46.953     2.018     0.200
    46.969     0.532     0.200
    46.981     0.834     0.200
    47.179     0.795     0.200
    47.106     1.720     0.200
    47.201     2.417     0.200
    47.201     2.526     0.200
    47.403     0.872     0.200
    47.501     0.020     0.200
    47.527     1.184     0.200
    47.539     0.789     0.200
    47.634     1.458     0.200
    47.634     1.338     0.200
    47.755     1.286     0.200
    47.750     0.922     0.200
    47.842     0.826     0.200
    47.905     0.534     0.200
    48.013     1.208     0.200
    48.134     0.891     0.200
    48.152     1.736     0.200
    48.169     0.506     0.200
    48.215     1.040     0.200
    48.233     1.571     0.200
    48.341     0.999     0.200
    48.384     1.116     0.200
    48.514     0.543     0.200
    48.526     0.746     0.200
    48.568     1.154     0.200
    48.568     0.749     0.200
    48.580     2.466     0.200
    48.580     1.906     0.200
    48.654     1.762     0.200
    48.595     1.557     0.200
    48.595     0.731     0.200
    48.595     0.361     0.200
    48.595     0.901     0.200
    48.608     0.479     0.200
    48.615     1.664     0.200
    48.624     0.393     0.200
    48.628     1.317     0.200
    48.730     0.426     0.200
    48.747     0.740     0.200
    48.768     1.896     0.200
    48.768     0.766     0.200
    48.782     2.677     0.200
    48.911     0.708     0.200
    48.911     0.821     0.200
    48.911     1.931     0.200
    48.911     1.791     0.200
    49.011     0.664     0.200
    49.020     1.051     0.200
    49.052     1.519     0.200
    49.118     0.698     0.200
    49.178     0.039     0.200
    49.178     1.199     0.200
    49.193     1.051     0.200
    49.193     2.179     0.200
    49.193     2.879     0.200
    49.187     0.601     0.200
    49.193     1.175     0.200
    49.262     0.909     0.200
    49.294     2.854     0.200
    49.326     3.337     0.200
    49.457     0.208     0.200
    49.375     0.939     0.200
    49.385     1.816     0.200
    49.448     1.612     0.200
    49.454    -0.467     0.200
    49.563     0.501     0.200
    49.604     1.072     0.200
    49.693     0.141     0.200
    49.693     0.571     0.200
    49.693    -0.279     0.200
    49.693    -0.019     0.200
    49.773     0.980     0.200
    49.856     0.267     0.200
    49.844     0.754     0.200
    50.249     0.565     0.200
    50.251    -0.197     0.200
    50.251     0.109     0.200
    50.251     0.260     0.200
    50.273     1.412     0.200
    50.289    -0.305     0.200
    50.294     0.511     0.200
    50.358     1.539     0.200
    50.358     0.259     0.200
    50.394     0.225     0.200
    50.394     0.885     0.200
    50.394     1.235     0.200
    50.508     0.348     0.200
    50.501     1.632     0.200
    50.516     1.317     0.200
    50.516     0.168     0.200
    50.634     3.674     0.200
    50.634     2.340     0.200
    50.634     0.174     0.200
    50.683     0.265     0.200
    50.792    -1.178     0.200
    50.792     0.595     0.200
    50.722    -0.688     0.200
    50.991     0.781     0.200
    50.991     1.082     0.200
    51.074     2.457     0.200
    51.074     1.856     0.200
    51.325     0.755     0.200
    51.360     0.533     0.200
    51.360     1.275     0.200
    51.360    -0.086     0.200
    51.282     0.161     0.200
    51.459     1.472     0.200
    51.609    -0.153     0.200
    51.678     0.936     0.200
    51.817     0.666     0.200
    51.841     2.123     0.200
    51.766     0.978     0.200
    51.856     1.503     0.200
    51.856     2.267     0.200
    51.856     0.007     0.200
    51.795     0.356     0.200
    51.893     0.144     0.200
    51.893     2.088     0.200
    51.893     0.829     0.200
    51.806    -0.122     0.200
    51.810     0.745     0.200
    51.825     0.357     0.200
    52.062     0.370     0.200
    52.128     0.479     0.200
    52.250     1.057     0.200
    52.250     3.279     0.200
    52.259     0.670     0.200
    52.259     0.000     0.200
    52.320     0.188     0.200
    52.320     0.338     0.200
    52.334     0.244     0.200
    52.338     0.215     0.200
    52.320     0.398     0.200
    52.275     1.388     0.200
    52.388     0.442     0.200
    52.474     0.908     0.200
    52.709     0.728     0.200
    52.956     1.639     0.200
    53.172     3.952     0.200
    53.172     1.801     0.200
    53.172     1.051     0.200
    53.374     0.060     0.200
    53.377    -0.357     0.200
    53.377     0.617     0.200
    53.377    -0.418     0.200
    53.389     0.055     0.200
    53.599     0.508     0.200
    54.097     1.426     0.200
    54.097     1.858     0.200
    54.221     1.053     0.200
    54.447     0.517     0.200
    54.471    -0.278     0.200
    54.471     1.342     0.200
    54.471     0.041     0.200
    54.631    -1.265     0.200
    54.545     0.754     0.200
    54.680     0.623     0.200
    54.640     0.335     0.200
    54.672     2.622     0.200
    54.733     0.558     0.200
    54.733     1.198     0.200
    55.183     0.580     0.200
    55.183     1.125     0.200
    55.183     1.971     0.200
    55.183     2.861     0.200
    55.183     0.425     0.200
    55.183     1.380     0.200
    55.309     0.389     0.200
    55.309     1.089     0.200
    55.538     0.472     0.200
    55.708     0.474     0.200
    55.803     0.254     0.200
    55.803     0.872     0.200
    55.803     2.432     0.200
    55.803     0.402     0.200
    55.827     2.789     0.200
    55.933     0.538     0.200
    56.104     2.162     0.200
    56.042     0.530     0.200
    56.234    -0.094     0.200
    56.234     1.479     0.200
    56.392     0.402     0.200
    56.392     1.512     0.200
    56.554     2.103     0.200
    56.514     2.876     0.200
    56.546     1.107     0.200
    56.997    -0.098     0.200
    57.349     0.639     0.200
    58.202     0.076     0.200
    58.202    -0.325     0.200
    58.193     1.688     0.200
    58.193     1.188     0.200
    58.193     0.839     0.200
    58.468     1.662     0.200
    59.158     0.668     0.200
    59.158     0.169     0.200
    59.158     1.288     0.200
    59.772     0.124     0.200
    59.772     0.659     0.200
    59.772     0.374     0.200
    59.772    -0.126     0.200
    59.772     1.034     0.200
    59.840    -0.155     0.200
    59.949     0.768     0.200
    59.949    -0.092     0.200
    59.941     0.765     0.200
    60.049    -0.060     0.200
    60.028     1.786     0.200
    60.028     1.635     0.200
    60.092     2.718     0.200
    60.106     2.826     0.200
    60.238     0.126     0.200
    60.238     0.946     0.200
    60.238    -0.234     0.200
    60.238    -0.074     0.200
    60.238     0.616     0.200
    60.373     0.198     0.200
    60.373    -0.146     0.200
    60.373     0.154     0.200
    60.375     0.429     0.200
    60.375    -1.058     0.200
    60.410    -0.150     0.200
    60.392     1.521     0.200
    60.392     2.591     0.200
    60.589     0.245     0.200
    60.658     0.408     0.200
    60.687     0.757     0.200
    60.825     0.422     0.200
    60.825     0.571     0.200
    60.981     1.310     0.200
    60.981     0.859     0.200
    60.981    -0.391     0.200
    60.981     1.719     0.200
    60.981     0.479     0.200
    61.097     4.464     0.200
    61.095    -0.160     0.200
    61.207     0.651     0.200
    61.483     0.453     0.200
    61.753     0.776     0.200
    61.815     1.334     0.200
    61.815    -2.026     0.200
    61.815    -1.786     0.200
    61.815     0.014     0.200
    61.815    -0.916     0.200
    62.868    -0.032     0.200
    63.370    -1.096     0.200
    63.435     0.705     0.200
    63.427    -0.195     0.200
    63.435     0.460     0.200
    63.435     0.965     0.200
    63.712     3.773     0.200
    63.963    -0.048     0.200
    63.963    -0.488     0.200
    64.078     0.470     0.200
    64.078     1.260     0.200
    64.078    -0.160     0.200
    64.272     3.192     0.200
    64.506     1.935     0.200
    64.603     2.830     0.200
    65.095     1.279     0.200
    65.762     1.291     0.200
    66.268    -0.156     0.200
    66.268    -1.456     0.200
    66.268    -0.680     0.200
    66.280    -0.134     0.200
    66.323     1.032     0.200
    66.723     0.804     0.200
    66.723    -0.096     0.200
    66.723     0.954     0.200
    66.851     0.810     0.200
    66.851     2.229     0.200
    66.851    -0.212     0.200
    66.820    -0.352     0.200
    66.820    -1.388     0.200
    67.048     1.225     0.200
    67.048    -1.265     0.200
    67.048    -0.914     0.200
    67.268    -0.658     0.200
    67.268     0.193     0.200
    67.268     0.628     0.200
    67.268    -0.522     0.200
    67.998     0.358     0.200
    68.110    -2.058     0.200
    68.155     4.032     0.200
    68.214     1.393     0.200
    68.214     0.878     0.200
    68.206     3.602     0.200
    68.235     4.528     0.200
    68.442    -1.211     0.200
    68.664    -0.205     0.200
    68.664     0.635     0.200
    68.664     0.286     0.200
    68.823     4.326     0.200
    68.910     4.381     0.200
    68.920     3.541     0.200
    69.091     1.180     0.200
    69.091     0.680     0.200
    69.091     2.500     0.200
    69.388     1.104     0.200
    69.388     0.385     0.200
    69.481     0.320     0.200
    70.109    -0.636     0.200
    69.805     4.610     0.200
    69.995    -0.427     0.200
    69.995     0.442     0.200
    69.935     3.466     0.200
    70.467    -0.994     0.200
    70.627     0.485     0.200
    71.063     4.327     0.200
    71.124     2.100     0.200
    71.124     3.225     0.200
    71.275     3.042     0.200
    71.879    -0.126     0.200
    71.879    -1.251     0.200
    71.879    -0.601     0.200
    71.879    -1.501     0.200
    72.557     0.716     0.200
    72.557     1.563     0.200
    72.915    -0.335     0.200
    73.486     0.742     0.200
    73.513    -1.141     0.200
    73.513     0.481     0.200
    73.575    -1.962     0.200
    74.387     1.326     0.200
    74.387     1.526     0.200
    74.402     0.607     0.200
    75.483    -0.366     0.200
    75.492     0.306     0.200
    75.547     1.094     0.200
    75.971     0.142     0.200
    76.714     0.703     0.200
    76.714     0.322     0.200
    77.107     1.777     0.200
    77.107     0.808     0.200
    77.107     1.008     0.200
    77.107     0.519     0.200
    77.958     0.072     0.200
    77.958    -0.858     0.200
    77.958     0.252     0.200
    77.958    -0.638     0.200
    77.947     0.904     0.200
    78.092     0.827     0.200
    78.092     0.327     0.200
    78.092     0.507     0.200
    78.111     0.947     0.200
    78.147     2.023     0.200
    78.147     3.693     0.200
    78.323    -0.402     0.200
    78.323     0.738     0.200
    78.357    -0.258     0.200
    78.357    -0.308     0.200
    78.927     0.097     0.200
    79.581     0.225     0.200
    79.857     0.209     0.200
    80.180     0.751     0.200
    80.265     0.529     0.200
    80.658     0.885     0.200
    80.662     0.815     0.200
    80.662    -0.010     0.200
    80.687     0.843     0.200
    80.687     0.352     0.200
    80.785     0.928     0.200
    80.843     1.562     0.200
    80.952    -0.791     0.200
    80.953    -0.900     0.200
    80.967    -0.095     0.200
    80.968    -0.046     0.200
    81.109    -0.130     0.200
    81.109    -0.600     0.200
    81.209     1.659     0.200
    81.309     1.158     0.200
    81.309     0.838     0.200
    81.585     0.277     0.200
    81.550     1.511     0.200
    81.608     2.043     0.200
    81.611     1.553     0.200
    81.625     1.131     0.200
    81.655     2.295     0.200
    81.658     2.845     0.200
    81.658     1.790     0.200
    81.658     4.311     0.200
    81.979     1.025     0.200
    82.714     2.401     0.200
    82.838    -1.041     0.200
    83.184     0.046     0.200
    83.155     1.268     0.200
    83.179    -0.103     0.200
    83.179    -0.562     0.200
    83.179     0.546     0.200
    83.441     1.089     0.200
    83.441     0.412     0.200
    83.441     0.644     0.200
    83.550    -0.269     0.200
    83.480     1.116     0.200
    83.485     2.552     0.200
    83.500     2.394     0.200
    83.800    -0.430     0.200
    83.923     0.821     0.200
    84.042    -0.034     0.200
    84.270    -0.145     0.200
    84.281     1.702     0.200
    84.772    -0.223     0.200
    84.834    -1.198     0.200
    84.834    -0.916     0.200
    84.834    -0.153     0.200
    84.852     0.413     0.200
    85.753    -1.921     0.200
    85.922     0.469     0.200
    86.070     2.705     0.200
    86.367     0.147     0.200
    86.469    -1.001     0.200
    86.425     2.038     0.200
    86.609     0.785     0.200
    86.734     1.022     0.200
    87.459    -0.725     0.200
    87.459     0.048     0.200
    87.461    -0.562     0.200
    87.461    -0.242     0.200
    89.323     2.604     0.200
    89.438    -0.014     0.200
    89.438    -0.214     0.200
    89.438    -0.563     0.200
    89.470    -0.166     0.200
    89.963     1.056     0.200
    89.963     0.530     0.200
    89.951     0.805     0.200
    89.951     0.446     0.200
    90.520     1.066     0.200
    90.526     0.075     0.200
    90.538     1.064     0.200
    91.305     1.859     0.200
    91.623     2.701     0.200
    91.623    -1.369     0.200
    91.765    -0.548     0.200
    93.095     0.036     0.200
    93.237    -0.068     0.200
    93.263    -1.087     0.200
    93.263    -0.062     0.200
    93.633     0.183     0.200
    94.372     0.984     0.200
    95.117     0.998     0.200
    96.412     0.996     0.200
    96.525     0.723     0.200
    96.546     1.314     0.200
    96.588     0.145     0.200
    96.588    -0.405     0.200
    96.588     0.025     0.200
    96.593    -0.824     0.200
    96.512     1.852     0.200
    96.807     0.134     0.200
    98.698     0.019     0.200
    19.274    -1.407     0.200
    19.424    -1.522     0.200
    19.919    -1.206     0.200
    25.008     1.327     0.200
    36.408     0.900     0.200
    40.964    -0.136     0.200
    19.268     0.411     0.200
    19.298     0.265     0.200
    19.443     1.099     0.200
    19.941     1.437     0.200
    20.048    -0.823     0.200
    21.910     1.317     0.200
    23.230     1.462     0.200
    25.030     0.860     0.200
    25.030     0.589     0.200
    28.749     0.185     0.200
    35.276     0.159     0.200
    36.405     0.210     0.200
    38.489    -0.111     0.200
    40.985     0.846     0.200
    41.660    -0.004     0.200
    51.873    -0.311     0.200
    74.334     0.888     0.200
    75.471     0.404     0.200
    75.949     0.026     0.200
    76.498    -0.026     0.200
    79.620     0.181     0.200
    87.391    -0.909     0.200
    14.867     4.345     0.200
    14.867     4.483     0.200
    14.867     6.453     0.200
    15.099     3.894     0.200
    15.891     3.729     0.200
    15.946     3.449     0.200
    16.724     2.799     0.200
    16.951     3.285     0.200
    17.359     3.908     0.200
    17.552     1.448     0.200
    17.581     2.054     0.200
    17.647     2.432     0.200
    17.653     2.382     0.200
    18.226     2.983     0.200
    18.492    -0.271     0.200
    18.952    -0.409     0.200
    19.263    -0.302     0.200
    19.263    -0.753     0.200
    19.263    -0.472     0.200
    19.281     0.376     0.200
    19.286    -0.501     0.200
    19.464     0.277     0.200
    19.439     0.055     0.200
    19.439    -0.102     0.200
    19.439    -0.346     0.200
    19.439    -0.296     0.200
    19.439    -0.506     0.200
    19.581     0.004     0.200
    19.931     1.528     0.200
    20.038     0.909     0.200
    20.038     1.033     0.200
    20.038     0.613     0.200
    20.038     1.520     0.200
    20.038     0.189     0.200
    20.038     1.144     0.200
    20.312    -0.369     0.200
    20.555    -1.290     0.200
    20.854    -0.451     0.200
    20.918    -0.110     0.200
    20.918    -1.335     0.200
    21.019     2.331     0.200
    21.019     2.111     0.200
    21.101    -0.516     0.200
    21.096     2.380     0.200
    21.290     0.547     0.200
    21.351    -0.306     0.200
    21.457     1.449     0.200
    21.519     2.100     0.200
    21.679     1.440     0.200
    21.746     0.935     0.200
    21.785     2.158     0.200
    21.888     1.300     0.200
    21.888     0.373     0.200
    21.888    -0.309     0.200
    21.888     0.930     0.200
    21.888     1.530     0.200
    21.888     1.160     0.200
    22.090     0.296     0.200
    22.090     0.480     0.200
    22.173     0.677     0.200
    22.200     1.092     0.200
    22.247     0.738     0.200
    22.256     2.299     0.200
    22.337    -0.871     0.200
    22.490    -0.060     0.200
    22.433     1.980     0.200
    22.578    -0.688     0.200
    22.515     2.298     0.200
    22.515     2.108     0.200
    22.964     2.410     0.200
    23.060    -0.437     0.200
    23.133     2.400     0.200
    23.206     0.820     0.200
    23.209     1.795     0.200
    23.209     1.489     0.200
    23.209     0.888     0.200
    23.209     0.888     0.200
    23.209     1.369     0.200
    23.233     0.437     0.200
    23.445     0.910     0.200
    23.510     2.375     0.200
    23.510     1.675     0.200
    23.510     1.425     0.200
    23.623     0.662     0.200
    23.623     0.142     0.200
    23.695     1.079     0.200
    23.801     1.313     0.200
    23.742     1.594     0.200
    23.748     1.192     0.200
    23.875     1.638     0.200
    23.868     2.043     0.200
    23.868     1.288     0.200
    23.868     1.158     0.200
    23.868     2.273     0.200
    23.868     1.748     0.200
    23.987     1.262     0.200
    24.351     0.723     0.200
    24.374     1.668     0.200
    24.400     1.345     0.200
    24.523     1.877     0.200
    24.823     1.980     0.200
    25.006     1.870     0.200
    25.006     1.564     0.200
    25.020     0.434     0.200
    25.020     0.470     0.200
    25.331     0.917     0.200
    25.325     0.805     0.200
    25.367     0.958     0.200
    25.394     1.292     0.200
    25.410     2.832     0.200
    25.631     1.143     0.200
    25.631     0.793     0.200
    26.609     1.696     0.200
    26.772    -0.528     0.200
    26.803     2.042     0.200
    26.927     2.534     0.200
    27.058     2.146     0.200
    27.058     2.764     0.200
    27.058     1.758     0.200
    27.058     1.516     0.200
    27.058     1.246     0.200
    27.382     1.644     0.200
    27.393     2.919     0.200
    27.457     1.659     0.200
    27.484     1.547     0.200
    27.849     1.203     0.200
    27.993     1.063     0.200
    27.928     0.918     0.200
    27.928     2.548     0.200
    28.037     0.807     0.200
    28.001     1.778     0.200
    28.129     1.408     0.200
    28.261     2.480     0.200
    28.269     2.568     0.200
    28.449     1.404     0.200
    28.701     1.190     0.200
    28.682     0.931     0.200
    28.707     0.706     0.200
    28.724     1.278     0.200
    28.724     0.684     0.200
    28.724     1.153     0.200
    28.724     0.753     0.200
    28.724     0.354     0.200
    28.731     0.801     0.200
    28.731     0.701     0.200
    28.731     1.510     0.200
    28.731     1.641     0.200
    28.735     0.759     0.200
    28.736     2.571     0.200
    28.781     0.744     0.200
    28.780     2.920     0.200
    28.789     0.774     0.200
    28.805     0.735     0.200
    28.825     0.761     0.200
    28.845     1.679     0.200
    28.850     1.735     0.200
    28.860     0.751     0.200
    28.939     0.598     0.200
    28.896     1.892     0.200
    28.952     2.719     0.200
    28.952     2.396     0.200
    28.952    -0.614     0.200
    28.952     1.917     0.200
    29.018     1.054     0.200
    28.951     1.405     0.200
    28.982     2.813     0.200
    29.009     2.573     0.200
    29.024     2.399     0.200
    29.024     2.289     0.200
    29.024     2.989     0.200
    29.029     2.397     0.200
    29.031     2.943     0.200
    29.031     3.432     0.200
    29.075     1.992     0.200
    29.075     1.937     0.200
    29.200     0.960     0.200
    29.251     2.679     0.200
    29.266     2.539     0.200
    29.337     2.972     0.200
    29.346     1.036     0.200
    29.385     2.610     0.200
    29.428     1.668     0.200
    29.442     1.602     0.200
    29.454     2.562     0.200
    29.504     3.251     0.200
    29.504     2.351     0.200
    29.650     0.451     0.200
    29.650     0.634     0.200
    29.652     2.493     0.200
    29.767     3.001     0.200
    29.781    -0.790     0.200
    30.057     2.357     0.200
    30.120     2.279     0.200
    30.172     2.419     0.200
    30.185     2.543     0.200
    30.256     2.173     0.200
    30.214     2.606     0.200
    30.375     2.518     0.200
    30.392     1.268     0.200
    30.401     2.055     0.200
    30.579     2.732     0.200
    30.855     1.985     0.200
    31.020    -0.232     0.200
    31.015     1.620     0.200
    31.124     1.018     0.200
    31.124     0.868     0.200
    31.124     0.347     0.200
    31.211     2.143     0.200
    31.303     2.530     0.200
    31.332     2.173     0.200
    31.378     1.310     0.200
    31.391     1.763     0.200
    31.423     2.038     0.200
    31.639     1.827     0.200
    31.642     2.366     0.200
    31.704     2.402     0.200
    31.744     1.631     0.200
    31.809     3.144     0.200
    31.911     1.686     0.200
    31.918     2.310     0.200
    31.918     1.620     0.200
    32.144     2.140     0.200
    32.171     0.566     0.200
    32.180     1.880     0.200
    32.196     2.554     0.200
    32.243     1.117     0.200
    32.243     2.146     0.200
    32.245     2.693     0.200
    32.321     2.586     0.200
    32.345     2.372     0.200
    32.385     2.028     0.200
    32.402     1.872     0.200
    32.426     2.309     0.200
    32.426     2.699     0.200
    32.495    -0.001     0.200
    32.538     1.743     0.200
    32.578     2.129     0.200
    32.538     2.283     0.200
    32.563     2.371     0.200
    32.563     2.661     0.200
    32.574     2.645     0.200
    32.836     0.570     0.200
    32.855     3.534     0.200
    33.189     1.680     0.200
    33.354    -0.823     0.200
    33.354    -0.613     0.200
    33.488    -0.543     0.200
    33.488    -0.785     0.200
    33.464     1.437     0.200
    33.464     0.617     0.200
    33.464     0.287     0.200
    33.641     2.934     0.200
    33.761     1.223     0.200
    33.761     1.368     0.200
    33.856     1.568     0.200
    33.924     2.997     0.200
    33.924     3.716     0.200
    33.966     2.312     0.200
    33.966     1.892     0.200
    34.045     0.357     0.200
    34.133     0.232     0.200
    34.177     2.931     0.200
    34.177     2.109     0.200
    34.177     0.180     0.200
    34.177     2.449     0.200
    34.133     1.039     0.200
    34.386     1.675     0.200
    34.386     1.411     0.200
    34.386     1.890     0.200
    34.419     1.987     0.200
    34.654     1.554     0.200
    34.654     1.948     0.200
    34.878     0.019     0.200
    35.016     1.026     0.200
    35.005     1.940     0.200
    35.012     2.278     0.200
    35.023     1.132     0.200
    35.218     2.036     0.200
    35.251     1.422     0.200
    35.251     0.301     0.200
    35.308     1.373     0.200
    35.308     1.783     0.200
    35.314     1.255     0.200
    35.321     1.100     0.200
    35.323     1.921     0.200
    35.373     1.669     0.200
    35.479     1.581     0.200
    35.513     1.826     0.200
    35.552     2.227     0.200
    35.624     1.689     0.200
    35.624     2.022     0.200
    35.673     2.468     0.200
    35.752     0.397     0.200
    35.752     1.729     0.200
    35.752     1.907     0.200
    35.752     1.841     0.200
    35.752     2.591     0.200
    35.759     1.901     0.200
    35.759     1.731     0.200
    35.960     1.639     0.200
    36.230     0.262     0.200
    36.230     0.369     0.200
    36.234     0.256     0.200
    36.181     1.759     0.200
    36.254     0.591     0.200
    36.259     0.663     0.200
    36.280     1.883     0.200
    36.280     1.673     0.200
    36.307     0.967     0.200
    36.307     1.737     0.200
    36.322     1.262     0.200
    36.425     0.343     0.200
    36.425     0.333     0.200
    36.359     1.982     0.200
    36.439    -0.192     0.200
    36.458    -0.048     0.200
    36.410     1.368     0.200
    36.538     2.505     0.200
    36.609     2.214     0.200
    36.666     2.347     0.200
    36.695     2.151     0.200
    36.695     2.561     0.200
    36.803     0.807     0.200
    36.810     2.252     0.200
    36.826     2.542     0.200
    36.826     2.312     0.200
    36.859    -0.671     0.200
    36.856     1.460     0.200
    36.856     2.098     0.200
    36.867     2.183     0.200
    36.895     0.929     0.200
    37.007     2.148     0.200
    37.026     1.607     0.200
    37.125     1.410     0.200
    37.169     1.996     0.200
    37.390     1.562     0.200
    37.492     0.705     0.200
    37.492     0.415     0.200
    37.492     1.154     0.200
    37.492     1.455     0.200
    37.499     1.886     0.200
    37.502     2.470     0.200
    37.508     1.480     0.200
    37.705     1.774     0.200
    37.734     0.753     0.200
    37.734     1.559     0.200
    37.743    -0.641     0.200
    37.743    -0.271     0.200
    37.760     1.688     0.200
    37.782     1.727     0.200
    37.888     2.006     0.200
    37.882     1.644     0.200
    37.882     1.354     0.200
    38.044     1.790     0.200
    38.123     0.958     0.200
    38.154     0.478     0.200
    38.151     1.679     0.200
    38.153     1.046     0.200
    38.162     1.140     0.200
    38.162     1.989     0.200
    38.162     1.040     0.200
    38.176    -0.669     0.200
    38.178     1.237     0.200
    38.215     1.279     0.200
    38.261     1.257     0.200
    38.261     1.157     0.200
    38.296     2.107     0.200
    38.361     0.716     0.200
    38.336     1.538     0.200
    38.336     2.062     0.200
    38.377     1.433     0.200
    38.466     2.090     0.200
    38.466     1.371     0.200
    38.466     0.831     0.200
    38.568     3.478     0.200
    38.600     1.035     0.200
    38.667     2.094     0.200
    38.721     2.192     0.200
    38.721     1.107     0.200
    38.796     1.544     0.200
    38.812     0.758     0.200
    38.812     1.928     0.200
    38.956     0.126     0.200
    38.864     2.388     0.200
    38.904     1.630     0.200
    38.958     0.556     0.200
    38.786     2.238     0.200
    39.081     0.607     0.200
    39.069     2.166     0.200
    39.073     2.177     0.200
    39.146     2.430     0.200
    39.270     2.720     0.200
    39.432     1.979     0.200
    39.534     2.289     0.200
    39.534     1.448     0.200
    39.543     1.222     0.200
    39.560     1.188     0.200
    39.571     1.994     0.200
    39.597     1.300     0.200
    39.605     1.093     0.200
    39.605     1.185     0.200
    39.629     1.995     0.200
    39.698     0.989     0.200
    39.750     1.370     0.200
    39.766     2.149     0.200
    39.828     2.640     0.200
    39.907     0.829     0.200
    39.928     1.557     0.200
    40.065     1.424     0.200
    40.065     1.304     0.200
    40.119     0.994     0.200
    40.124     0.289     0.200
    40.204     1.291     0.200
    40.322     2.139     0.200
    40.311     1.131     0.200
    40.311     0.381     0.200
    40.311     0.941     0.200
    40.319     0.866     0.200
    40.510     1.361     0.200
    40.455     1.002     0.200
    40.494     2.153     0.200
    40.536     0.447     0.200
    40.670     0.438     0.200
    40.698     0.480     0.200
    40.698    -0.195     0.200
    40.727     2.161     0.200
    40.730     2.347     0.200
    40.977     0.031     0.200
    41.071     1.756     0.200
    41.083     1.486     0.200
    41.092     0.518     0.200
    41.138     1.254     0.200
    41.337     1.194     0.200
    41.334     0.070     0.200
    41.441     0.510     0.200
    41.534     0.240     0.200
    41.652     0.014     0.200
    41.602     0.588     0.200
    41.625     0.045     0.200
    41.628     3.167     0.200
    41.635     0.323     0.200
    41.635     0.023     0.200
    41.635     0.523     0.200
    41.635     0.299     0.200
    41.635     2.102     0.200
    41.684     0.687     0.200
    41.707     0.599     0.200
    41.718     0.305     0.200
    41.719     0.099     0.200
    41.719     0.296     0.200
    41.875     1.248     0.200
    42.134     1.907     0.200
    42.394     0.233     0.200
    42.406     1.894     0.200
    42.495     0.282     0.200
    42.504     0.256     0.200
    42.504     0.824     0.200
    42.504     0.124     0.200
    42.504    -0.086     0.200
    42.516     2.499     0.200
    42.552     1.634     0.200
    42.552     1.413     0.200
    42.552     0.333     0.200
    42.552     0.573     0.200
    42.552     1.953     0.200
    42.552     0.882     0.200
    42.557     0.866     0.200
    42.657     0.068     0.200
    42.712     1.948     0.200
    42.717     1.468     0.200
    42.717     1.093     0.200
    42.896     1.294     0.200
    43.040     0.367     0.200
    43.120     2.227     0.200
    43.120     1.838     0.200
    43.196     0.989     0.200
    43.196     1.276     0.200
    43.196     0.604     0.200
    43.196     1.524     0.200
    43.198     2.261     0.200
    43.198     1.360     0.200
    43.212     1.422     0.200
    43.440     1.330     0.200
    43.705     1.951     0.200
    43.705     1.531     0.200
    43.781     1.193     0.200
    43.996     1.099     0.200
    44.114     1.823     0.200
    44.185     1.449     0.200
    44.185     0.174     0.200
    44.185     0.999     0.200
    44.321     1.163     0.200
    44.539     0.558     0.200
    44.539     0.717     0.200
    44.723     0.095     0.200
    44.791     0.818     0.200
    45.104    -0.953     0.200
    45.659     0.289     0.200
    45.755     1.298     0.200
    45.755     0.407     0.200
    45.755     0.157     0.200
    45.755     1.017     0.200
    46.160    -0.160     0.200
    46.483     0.491     0.200
    46.692    -1.320     0.200
    46.692    -1.721     0.200
    46.822     0.247     0.200
    46.822     0.004     0.200
    46.822    -0.237     0.200
    46.891     0.878     0.200
    46.891     1.042     0.200
    47.112     1.695     0.200
    47.192     2.021     0.200
    47.596     0.513     0.200
    47.744     1.701     0.200
    47.744     1.576     0.200
    47.871     1.595     0.200
    48.593     1.814     0.200
    48.593     0.586     0.200
    48.593     1.060     0.200
    48.607     1.570     0.200
    48.620     1.557     0.200
    48.620     1.323     0.200
    48.625     1.431     0.200
    48.900     1.746     0.200
    48.900     1.077     0.200
    48.900     1.967     0.200
    48.900     1.376     0.200
    49.055     1.463     0.200
    49.112     0.896     0.200
    49.421     1.057     0.200
    49.638     0.675     0.200
    49.638    -0.298     0.200
    49.638     0.182     0.200
    49.638     0.412     0.200
    49.791     0.842     0.200
    50.205     0.586     0.200
    50.205     0.356     0.200
    50.205     1.106     0.200
    50.456     1.151     0.200
    50.456     0.902     0.200
    50.456     1.282     0.200
    50.456     0.561     0.200
    50.543     1.440     0.200
    50.662     2.779     0.200
    50.662     2.539     0.200
    50.750    -0.088     0.200
    50.750    -0.244     0.200
    51.021     1.349     0.200
    51.021     0.838     0.200
    51.021     1.238     0.200
    51.100     1.422     0.200
    51.100     0.941     0.200
    51.293     0.594     0.200
    51.706     1.002     0.200
    51.778     1.721     0.200
    51.778     1.559     0.200
    51.791     1.949     0.200
    51.791     1.677     0.200
    51.791     0.267     0.200
    51.829     2.037     0.200
    51.829     1.865     0.200
    51.829     0.485     0.200
    51.840     1.804     0.200
    51.841     0.398     0.200
    51.851     0.070     0.200
    51.851    -0.050     0.200
    51.998     0.922     0.200
    52.186     2.495     0.200
    52.186     1.886     0.200
    52.186     0.736     0.200
    52.193     0.495     0.200
    52.193    -0.055     0.200
    52.173     0.522     0.200
    52.173     0.651     0.200
    52.173     0.332     0.200
    52.173     0.022     0.200
    52.254     1.044     0.200
    52.254     0.633     0.200
    52.268    -0.081     0.200
    52.272     0.489     0.200
    52.254     0.822     0.200
    52.416     1.414     0.200
    52.504     1.665     0.200
    52.755     0.492     0.200
    52.890     0.804     0.200
    53.088    -0.540     0.200
    53.201     3.112     0.200
    53.231     1.002     0.200
    53.309     0.520     0.200
    53.311     0.002     0.200
    53.311     0.452     0.200
    53.323     0.014     0.200
    53.534     0.168     0.200
    54.264     0.514     0.200
    54.312    -0.200     0.200
    54.465     0.690     0.200
    54.465     0.461     0.200
    54.691     0.691     0.200
    54.778     0.543     0.200
    54.778     0.390     0.200
    54.935    -0.116     0.200
    55.224     0.392     0.200
    55.224    -0.099     0.200
    55.356     0.072     0.200
    55.584     0.540     0.200
    55.753     0.455     0.200
    55.834     0.268     0.200
    55.834    -0.225     0.200
    55.834    -0.795     0.200
    56.325     1.799     0.200
    56.489     0.701     0.200
    56.489     0.508     0.200
    57.401     0.397     0.200
    57.401     0.168     0.200
    58.243    -0.565     0.200
    58.243    -0.992     0.200
    58.243    -1.297     0.200
    58.126     1.471     0.200
    58.406     1.472     0.200
    59.215     0.447     0.200
    59.215     0.882     0.200
    59.215     0.566     0.200
    59.215     0.686     0.200
    59.215    -0.083     0.200
    59.709     0.439     0.200
    59.709     0.609     0.200
    59.883     0.433     0.200
    59.888     0.808     0.200
    60.012     1.564     0.200
    60.182     1.386     0.200
    60.182     0.903     0.200
    60.182     0.736     0.200
    60.306     0.175     0.200
    60.306     0.016     0.200
    60.308     0.587     0.200
    60.308     0.333     0.200
    60.343    -0.017     0.200
    60.391     2.057     0.200
    60.391     1.547     0.200
    60.391     0.958     0.200
    60.593     0.343     0.200
    60.593    -0.303     0.200
    60.591    -0.308     0.200
    60.759    -0.106     0.200
    60.759     0.045     0.200
    61.021    -0.741     0.200
    61.021    -1.405     0.200
    61.021    -0.384     0.200
    61.021    -1.054     0.200
    62.816     0.657     0.200
    62.903    -0.180     0.200
    62.903     1.291     0.200
    63.387     1.194     0.200
    63.387     1.037     0.200
    63.387     0.214     0.200
    63.911     0.037     0.200
    63.911    -0.721     0.200
    63.911    -0.161     0.200
    64.144     0.979     0.200
    64.144     0.505     0.200
    64.144     0.234     0.200
    64.214     1.185     0.200
    64.562    -0.744     0.200
    64.660     1.235     0.200
    65.146     0.709     0.200
    65.632     0.922     0.200
    66.209    -0.902     0.200
    66.480     1.245     0.200
    66.762    -0.878     0.200
    66.762    -1.238     0.200
    66.927    -1.379     0.200
    67.333     0.249     0.200
    67.333    -0.818     0.200
    67.333     0.432     0.200
    67.333     0.022     0.200
    67.333    -0.168     0.200
    67.333    -0.298     0.200
    68.008     0.509     0.200
    68.008    -0.221     0.200
    68.276     1.001     0.200
    68.276     0.280     0.200
    68.276     0.080     0.200
    68.276     0.389     0.200
    68.276     0.500     0.200
    68.276    -0.180     0.200
    68.619     0.800     0.200
    68.719     0.205     0.200
    68.719    -0.186     0.200
    69.100     1.097     0.200
    69.334     0.007     0.200
    69.334     0.208     0.200
    69.334    -0.302     0.200
    70.167    -0.917     0.200
    69.943    -0.683     0.200
    69.943    -0.360     0.200
    71.184     1.660     0.200
    71.933    -0.099     0.200
    71.933    -0.443     0.200
    71.933    -1.203     0.200
    72.680     0.344     0.200
    72.617     0.478     0.200
    72.617    -1.267     0.200
    72.617    -0.017     0.200
    73.434    -0.467     0.200
    73.467    -1.430     0.200
    74.333     2.347     0.200
    74.351     1.568     0.200
    74.457     0.325     0.200
    74.457     0.375     0.200
    75.438     0.717     0.200
    75.452     0.217     0.200
    75.932     0.296     0.200
    76.684     0.706     0.200
    76.684     0.586     0.200
    76.684     0.367     0.200
    77.922    -0.911     0.200
    78.055     0.698     0.200
    78.055     0.515     0.200
    78.320     0.117     0.200
    78.320     0.018     0.200
    78.320     0.237     0.200
    78.890     0.377     0.200
    79.224     0.717     0.200
    79.545     0.292     0.200
    79.919     0.066     0.200
    80.146     1.396     0.200
    80.610    -0.013     0.200
    80.617     0.020     0.200
    80.617    -0.095     0.200
    80.694     0.863     0.200
    80.694     0.287     0.200
    80.750     0.929     0.200
    80.930     0.230     0.200
    81.078    -1.231     0.200
    81.078    -1.680     0.200
    81.281    -0.181     0.200
    81.281    -0.591     0.200
    81.536    -0.422     0.200
    83.136    -0.212     0.200
    83.133     0.354     0.200
    83.156     0.585     0.200
    83.156     0.334     0.200
    83.165     0.992     0.200
    83.399     0.789     0.200
    83.399     0.662     0.200
    83.525    -1.100     0.200
    84.009     0.505     0.200
    84.009     0.204     0.200
    84.134    -1.382     0.200
    84.134    -1.642     0.200
    84.742    -0.876     0.200
    84.808    -1.595     0.200
    84.808    -0.656     0.200
    84.808    -1.166     0.200
    84.841    -0.764     0.200
    86.037     1.857     0.200
    86.154    -0.968     0.200
    86.329     0.252     0.200
    86.439    -1.537     0.200
    86.439    -1.957     0.200
    86.576    -0.280     0.200
    86.704     1.219     0.200
    87.413    -0.435     0.200
    87.416    -0.672     0.200
    87.416    -0.252     0.200
    87.416    -0.382     0.200
    89.395    -0.098     0.200
    89.395    -0.592     0.200
    89.395     0.227     0.200
    89.929    -0.042     0.200
    89.929    -0.709     0.200
    89.929    -1.359     0.200
    89.937     0.711     0.200
    89.937     0.220     0.200
    91.718    -0.405     0.200
    93.196    -0.626     0.200
    93.255    -0.978     0.200
    93.255    -0.253     0.200
    93.255    -0.353     0.200
    93.595    -0.814     0.200
    93.925    -0.400     0.200
    94.320     0.824     0.200
    95.033     1.228     0.200
    95.110    -0.772     0.200
    97.452    -0.567     0.200
    19.283    -0.899     0.200
    19.314    -0.123     0.200
    19.319     0.065     0.200
    19.459    -0.571     0.200
    19.459    -0.460     0.200
    19.958     0.972     0.200
    20.064    -0.560     0.200
    21.923     0.646     0.200
    21.923     0.404     0.200
    23.228     1.667     0.200
    23.228    -0.542     0.200
    25.046     0.623     0.200
    25.046    -0.226     0.200
    35.285     1.515     0.200
    41.001     0.551     0.200
    41.001     0.310     0.200
    51.873     0.807     0.200
    74.349     0.411     0.200
    74.385     0.043     0.200
    75.965    -0.223     0.200
    87.392    -0.319     0.200
    89.372     0.299     0.200
    19.369    -1.151     0.200
    19.527    -0.427     0.200
    20.022    -0.204     0.200
    25.111    -0.512     0.200
    35.296     0.710     0.200
    36.447    -1.252     0.200
    40.241     0.432     0.200
    41.067    -0.091     0.200
    51.844     1.145     0.200
    87.420     0.065     0.200
    89.397     0.207     0.200
    19.490    -0.388     0.200
    19.978     0.162     0.200
    23.176     3.077     0.200
    25.067    -0.211     0.200
    35.251     0.920     0.200
    36.461    -0.072     0.200
    41.025    -0.428     0.200
    87.443     0.165     0.200
    89.422    -0.301     0.200
    14.854     6.781     0.200
    16.712     4.979     0.200
    16.850     2.352     0.200
    17.349     4.705     0.200
    17.408     2.762     0.200
    17.469     1.869     0.200
    19.296    -0.276     0.200
    19.284    -1.173     0.200
    19.301     0.143     0.200
    19.460    -0.067     0.200
    19.460    -0.397     0.200
    19.460     0.103     0.200
    19.460    -0.608     0.200
    19.460    -0.958     0.200
    19.460     0.202     0.200
    19.820     1.470     0.200
    19.950     0.178     0.200
    19.950     0.395     0.200
    20.056     0.578     0.200
    20.056    -1.063     0.200
    20.935     0.236     0.200
    21.311    -0.902     0.200
    21.895     1.027     0.200
    22.107     0.329     0.200
    22.170     0.095     0.200
    22.209     0.776     0.200
    23.191     2.657     0.200
    23.194    -0.375     0.200
    23.194     1.854     0.200
    23.194     2.926     0.200
    23.440    -0.361     0.200
    23.726     2.922     0.200
    23.895     1.636     0.200
    24.396     0.465     0.200
    25.039    -0.289     0.200
    25.039     0.168     0.200
    25.039    -0.020     0.200
    25.039     0.611     0.200
    25.025     0.976     0.200
    25.398     1.441     0.200
    26.630     2.290     0.200
    27.055     2.158     0.200
    27.055     2.307     0.200
    28.699     0.963     0.200
    28.717    -0.521     0.200
    28.717     1.508     0.200
    28.717     1.809     0.200
    28.717     1.607     0.200
    28.724     1.087     0.200
    28.724     1.446     0.200
    30.278     2.667     0.200
    31.015     1.473     0.200
    31.907     1.945     0.200
    32.417     3.526     0.200
    32.573     2.178     0.200
    32.599     2.833     0.200
    34.199     1.385     0.200
    35.249     1.022     0.200
    35.249     1.401     0.200
    35.329    -0.344     0.200
    35.329    -0.716     0.200
    35.336     1.857     0.200
    35.342     2.101     0.200
    36.441    -0.385     0.200
    36.441     0.683     0.200
    36.441     0.183     0.200
    36.456     0.260     0.200
    36.474    -0.396     0.200
    37.390     0.902     0.200
    37.506     1.622     0.200
    40.201     0.729     0.200
    40.314     2.200     0.200
    40.314     0.549     0.200
    40.314     1.008     0.200
    40.996    -0.338     0.200
    40.996    -0.979     0.200
    41.631     0.641     0.200
    41.631     0.666     0.200
    42.532     1.474     0.200
    42.701     1.316     0.200
    43.176     1.493     0.200
    44.527     0.933     0.200
    49.077     1.293     0.200
    49.657    -0.942     0.200
    50.222     0.325     0.200
    51.838     0.314     0.200
    52.020     0.356     0.200
    52.276    -0.247     0.200
    53.333    -0.404     0.200
    59.730     0.387     0.200
    71.914     0.270     0.200
    78.069     0.809     0.200
    78.334     0.391     0.200
    78.334    -0.177     0.200
    83.165    -0.111     0.200
    87.427     0.177     0.200
    89.408     0.100     0.200
    89.408    -0.060     0.200
    19.274    -0.606     0.200
    19.274    -0.856     0.200
    19.274    -1.066     0.200
    19.297    -2.175     0.200
    19.302    -0.380     0.200
    19.449    -0.178     0.200
    19.449    -1.444     0.200
    19.944    -0.539     0.200
    20.051    -0.129     0.200
    20.051     1.810     0.200
    21.300    -1.270     0.200
    21.456    -0.290     0.200
    21.753     0.860     0.200
    21.905     0.057     0.200
    21.905     1.128     0.200
    23.218     1.085     0.200
    23.218     0.293     0.200
    23.218     0.865     0.200
    25.033    -0.233     0.200
    25.033    -0.362     0.200
    25.002     1.947     0.200
    28.738     0.026     0.200
    28.745     1.023     0.200
    29.515     0.185     0.200
    29.657     0.587     0.200
    31.681     2.452     0.200
    33.481    -0.007     0.200
    35.267     1.161     0.200
    35.339     1.378     0.200
    36.223     0.804     0.200
    36.223    -0.735     0.200
    36.227     0.780     0.200
    36.251     1.126     0.200
    36.418     0.410     0.200
    36.867     0.734     0.200
    38.948    -0.376     0.200
    38.969     1.717     0.200
    38.779     2.363     0.200
    39.519     1.234     0.200
    40.220     0.485     0.200
    40.328     0.834     0.200
    40.466     0.884     0.200
    40.548     0.385     0.200
    40.710     0.530     0.200
    40.989     0.064     0.200
    40.989    -0.216     0.200
    41.345     1.323     0.200
    41.650     0.402     0.200
    41.650     0.359     0.200
    42.525     0.816     0.200
    44.254     1.765     0.200
    48.608     0.066     0.200
    51.114    -0.416     0.200
    51.861     0.304     0.200
    51.861     0.966     0.200
    52.007    -0.981     0.200
    68.707     0.146     0.200
    72.102     0.593     0.200
    71.920    -0.430     0.200
    74.245     0.631     0.200
    74.332     0.988     0.200
    74.368     1.538     0.200
    75.469     0.403     0.200
    75.949     0.358     0.200
    76.335     0.459     0.200
    78.167     0.458     0.200
    78.170     0.132     0.200
    78.336    -0.352     0.200
    78.547     0.807     0.200
    79.620     0.351     0.200
    87.404    -1.000     0.200
    87.406    -0.818     0.200
    89.385    -1.274     0.200
    89.385    -0.325     0.200
    14.727     7.363     0.200
    16.047     3.407     0.200
    18.107     1.070     0.200
    19.344     0.041     0.200
    19.394    -1.190     0.200
    19.394    -0.460     0.200
    19.571    -1.148     0.200
    19.571    -0.969     0.200
    20.035     0.259     0.200
    20.142    -0.798     0.200
    20.142    -1.250     0.200
    21.890     0.111     0.200
    21.890     0.931     0.200
    23.060     0.381     0.200
    23.060     0.751     0.200
    23.060     0.161     0.200
    25.126     0.207     0.200
    25.126    -0.557     0.200
    28.618    -0.237     0.200
    28.624     0.811     0.200
    35.185     0.470     0.200
    35.454    -0.816     0.200
    38.040     0.599     0.200
    40.123     0.498     0.200
    41.091     0.289     0.200
    41.091     0.133     0.200
    41.524     0.604     0.200
    41.555     0.227     0.200
    41.555    -0.673     0.200
    42.384     0.428     0.200
    46.727     0.952     0.200
    48.273     0.247     0.200
    48.492     0.065     0.200
    51.708     0.552     0.200
    51.710    -0.243     0.200
    51.710     0.551     0.200
    52.032     0.780     0.200
    52.414    -0.259     0.200
    74.008     0.981     0.200
    74.360     1.721     0.200
    74.403     1.240     0.200
    74.867     1.526     0.200
    75.501     1.246     0.200
    75.992     0.749     0.200
    77.483     0.386     0.200
    78.215     1.292     0.200
    78.374     0.233     0.200
    78.592     0.956     0.200
    79.033     0.496     0.200
    79.665     0.496     0.200
    87.555    -0.693     0.200
    87.557    -0.249     0.200
    89.531    -0.434     0.200
    14.876     8.998     0.200
    17.382     3.393     0.200
    17.674     2.199     0.200
    17.679     1.684     0.200
    19.353    -1.581     0.200
    19.378     0.350     0.200
    19.383     1.048     0.200
    19.528    -0.791     0.200
    19.528    -0.641     0.200
    19.528     0.109     0.200
    19.528    -1.750     0.200
    19.528     0.660     0.200
    19.529     1.640     0.200
    19.860     1.941     0.200
    20.027     1.229     0.200
    20.134    -1.259     0.200
    20.973     1.873     0.200
    21.008     2.340     0.200
    21.008     2.221     0.200
    21.098     0.901     0.200
    21.444     1.118     0.200
    21.481     2.582     0.200
    21.826     1.380     0.200
    21.974     0.788     0.200
    21.974     0.989     0.200
    21.974     0.649     0.200
    22.289     0.228     0.200
    22.398     0.411     0.200
    23.205     2.121     0.200
    23.208     1.128     0.200
    23.208     2.188     0.200
    23.208     1.288     0.200
    23.208     2.288     0.200
    23.208     1.470     0.200
    23.738     3.633     0.200
    23.769     3.396     0.200
    23.966     0.603     0.200
    25.116     0.218     0.200
    25.116     0.493     0.200
    25.116    -0.071     0.200
    25.037     0.555     0.200
    25.472     2.882     0.200
    25.667     1.243     0.200
    26.178     1.563     0.200
    27.115     1.334     0.200
    27.946     1.663     0.200
    28.719     0.399     0.200
    28.744     1.075     0.200
    28.761     0.894     0.200
    28.761     1.820     0.200
    28.761     1.119     0.200
    28.761     1.920     0.200
    28.768     0.329     0.200
    28.862     1.528     0.200
    29.379    -0.265     0.200
    29.445     1.090     0.200
    29.522     4.285     0.200
    30.322     2.490     0.200
    31.033     2.162     0.200
    31.688     3.040     0.200
    31.940     2.848     0.200
    32.555     2.337     0.200
    35.042     1.962     0.200
    35.312     0.432     0.200
    36.240     0.374     0.200
    36.240    -0.316     0.200
    36.243     0.341     0.200
    36.434     0.955     0.200
    36.434     0.656     0.200
    36.434     0.955     0.200
    36.869     1.947     0.200
    38.956     0.366     0.200
    39.659     2.904     0.200
    40.257     1.479     0.200
    40.558     0.631     0.200
    40.768     2.743     0.200
    41.071     0.918     0.200
    41.657     0.531     0.200
    41.689     0.280     0.200
    41.689     0.392     0.200
    42.709     2.805     0.200
    42.709     1.456     0.200
    44.556     1.630     0.200
    50.929     0.396     0.200
    52.323     1.034     0.200
    54.685     1.455     0.200
    58.145     0.822     0.200
    60.923    -0.909     0.200
    78.416     0.856     0.200
    87.406    -0.438     0.200
    87.406    -0.662     0.200
    87.408    -0.225     0.200
    89.382     0.028     0.200
    89.382    -0.312     0.200
    17.394     2.409     0.200
    19.328     0.160     0.200
    19.521     0.663     0.200
    19.521     0.272     0.200
    19.998     0.801     0.200
    20.104     0.055     0.200
    20.487     1.293     0.200
    21.895     0.705     0.200
    21.895     0.482     0.200
    21.895     1.322     0.200
    23.123     1.770     0.200
    23.123     1.758     0.200
    23.123     1.200     0.200
    25.087     0.575     0.200
    25.087    -0.562     0.200
    28.672     0.941     0.200
    35.217     1.042     0.200
    36.515     0.484     0.200
    36.515    -0.246     0.200
    37.533     0.197     0.200
    40.161     0.827     0.200
    40.295     0.975     0.200
    40.381     1.773     0.200
    41.049     0.065     0.200
    41.049    -0.232     0.200
    41.592     0.344     0.200
    41.592     0.668     0.200
    42.843     0.103     0.200
    51.770     0.393     0.200
    52.351     0.032     0.200
    52.351     0.988     0.200
    53.404    -0.052     0.200
    60.405    -0.588     0.200
    75.972     0.658     0.200
    75.973     0.274     0.200
    76.651    -0.112     0.200
    77.293     0.382     0.200
    77.464    -0.074     0.200
    78.195     0.155     0.200
    78.357     0.414     0.200
    78.357     0.015     0.200
    78.357    -0.246     0.200
    80.785     0.315     0.200
    87.495    -0.568     0.200
    87.495    -0.260     0.200
    89.473    -0.423     0.200
    89.473    -0.576     0.200
    19.298     0.090     0.200
    19.456     0.201     0.200
    19.949     0.432     0.200
    25.038     0.166     0.200
    36.430     0.099     0.200
    40.994    -0.030     0.200
    87.416    -0.850     0.200
    19.429     0.331     0.200
    19.919     0.918     0.200
    25.008     0.140     0.200
    36.430    -0.401     0.200
    40.965     0.187     0.200
    87.421    -0.773     0.200
    89.404    -0.505     0.200
    19.371     1.385     0.200
    19.548     0.281     0.200
    20.035     1.379     0.200
    23.157     1.261     0.200
    25.124    -0.459     0.200
    28.713     0.258     0.200
    35.271     0.577     0.200
    36.485    -0.558     0.200
    40.213     0.315     0.200
    41.083    -0.090     0.200
    41.645    -0.122     0.200
    51.807     0.208     0.200
    87.457    -0.467     0.200
    89.433    -0.536     0.200
    14.656     5.032     0.200
    16.032     4.958     0.200
    17.631     1.943     0.200
    19.040     0.575     0.200
    19.247    -0.815     0.200
    19.258     1.219     0.200
    19.423    -0.005     0.200
    19.423    -0.927     0.200
    19.911     0.958     0.200
    21.863     0.156     0.200
    23.199     1.098     0.200
    23.199     0.988     0.200
    25.000    -0.299     0.200
    25.000     0.029     0.200
    28.713     0.378     0.200
    36.434     0.366     0.200
    40.958     0.738     0.200
    40.958    -0.137     0.200
    51.839    -0.776     0.200
    54.682     0.575     0.200
    73.925     0.327     0.200
    74.328     0.372     0.200
    75.909    -0.090     0.200
    87.426    -0.453     0.200
    89.409    -0.941     0.200
    19.339     0.028     0.200
    19.564     0.345     0.200
    20.029     0.793     0.200
    21.888     1.079     0.200
    23.065     1.869     0.200
    25.120     0.207     0.200
    41.085    -0.411     0.200
    51.714     0.169     0.200
    87.550    -1.033     0.200
    19.541    -1.173     0.200
    20.014    -0.907     0.200
    23.102    -0.633     0.200
    25.104     0.832     0.200
    14.676     4.837     0.200
    19.297     0.404     0.200
    19.479     0.114     0.200
    19.961     0.925     0.200
    23.158     1.860     0.200
    25.050    -0.403     0.200
    36.478     0.465     0.200
    87.463    -0.429     0.200
    19.283     1.052     0.200
    19.448    -0.493     0.200
    19.448     0.611     0.200
    19.937     1.021     0.200
    20.044     0.421     0.200
    22.105    -0.844     0.200
    22.240    -0.037     0.200
    23.194     2.996     0.200
    23.194     0.462     0.200
    25.026     0.481     0.200
    36.440     0.844     0.200
    36.440    -0.927     0.200
    40.983     0.793     0.200
    40.983    -0.002     0.200
    41.124     0.081     0.200
    87.428    -0.102     0.200
    19.297     0.148     0.200
    19.444    -1.182     0.200
    19.941     1.587     0.200
    21.908     1.351     0.200
    21.908     1.242     0.200
    23.227     1.968     0.200
    25.030    -1.117     0.200
    36.213    -0.384     0.200
    36.408     0.759     0.200
    40.985     0.368     0.200
    78.336    -0.331     0.200
    87.394    -0.624     0.200
    89.375    -0.057     0.200
    17.629     2.408     0.200
    18.260     0.673     0.200
    19.266    -0.387     0.200
    19.432    -1.134     0.200
    19.920     0.224     0.200
    20.027     0.692     0.200
    21.868     1.145     0.200
    23.195     3.414     0.200
    25.009     0.591     0.200
    28.705     0.945     0.200
    28.712     1.266     0.200
    35.231     1.083     0.200
    35.304     0.265     0.200
    36.438     0.343     0.200
    40.967     0.517     0.200
    41.615     0.092     0.200
    52.254     0.652     0.200
    83.138     0.817     0.200
    14.755     6.216     0.200
    17.318     3.104     0.200
    17.480     5.885     0.200
    17.553     2.679     0.200
    19.315    -0.636     0.200
    19.319    -0.045     0.200
    19.319     0.235     0.200
    19.352    -1.527     0.200
    19.528     1.125     0.200
    19.528     0.075     0.200
    19.528    -1.814     0.200
    19.997     1.104     0.200
    20.104    -0.340     0.200
    21.474     2.015     0.200
    21.875     0.800     0.200
    21.875     0.666     0.200
    21.875     0.906     0.200
    22.213     1.866     0.200
    22.460     1.170     0.200
    23.092     0.791     0.200
    23.092     1.970     0.200
    23.092     1.270     0.200
    23.092     0.361     0.200
    23.092     2.571     0.200
    23.961     0.870     0.200
    25.088     0.022     0.200
    25.088    -0.362     0.200
    25.360     1.417     0.200
    26.069     0.462     0.200
    28.634    -0.626     0.200
    28.634     0.474     0.200
    28.634     1.275     0.200
    28.641     0.622     0.200
    35.189     1.016     0.200
    35.189     0.446     0.200
    35.410    -0.604     0.200
    36.545    -0.085     0.200
    36.545     0.375     0.200
    40.131     0.281     0.200
    40.270     0.822     0.200
    41.051     1.272     0.200
    41.051     0.243     0.200
    41.531     0.548     0.200
    41.542     0.899     0.200
    41.563     0.017     0.200
    41.563    -0.007     0.200
    48.506     0.465     0.200
    51.738     0.136     0.200
    52.369     0.362     0.200
    71.864    -1.303     0.200
    71.864    -1.852     0.200
    87.526    -1.131     0.200
    87.529    -0.843     0.200
    89.505    -0.634     0.200
    19.287    -1.205     0.200
    19.287     0.865     0.200
    19.282    -1.518     0.200
    19.287     0.432     0.200
    19.463    -0.545     0.200
    19.463    -0.350     0.200
    19.945     0.011     0.200
    19.945    -0.301     0.200
    20.902    -0.374     0.200
    21.871    -0.089     0.200
    21.871     0.942     0.200
    23.162     1.631     0.200
    25.035    -0.986     0.200
    28.683     0.635     0.200
    35.218     0.457     0.200
    36.277     0.087     0.200
    36.472     0.179     0.200
    40.994     0.861     0.200
    87.460     0.056     0.200
    14.701     7.982     0.200
    19.325     0.406     0.200
    19.389    -1.891     0.200
    19.389    -0.351     0.200
    19.565     0.373     0.200
    19.565    -0.782     0.200
    20.023     1.102     0.200
    20.130     0.439     0.200
    20.130     1.279     0.200
    21.865     0.898     0.200
    21.865     0.406     0.200
    23.036     1.594     0.200
    23.036     1.415     0.200
    25.114     0.301     0.200
    25.114     0.117     0.200
    25.340     1.348     0.200
    28.589     0.048     0.200
    28.596     0.716     0.200
    33.937     0.249     0.200
    35.156     0.476     0.200
    41.081    -0.463     0.200
    41.526    -0.043     0.200
    46.701     0.934     0.200
    48.247     0.423     0.200
    48.463    -0.672     0.200
    51.684     0.386     0.200
    52.420     0.336     0.200
    75.132     0.019     0.200
    87.580    -0.309     0.200
    87.580    -0.189     0.200
    87.583    -0.371     0.200
    89.558    -0.499     0.200
    89.558     0.671     0.200
    23.073    -1.249     0.200
    35.180    -0.621     0.200
    36.565     0.126     0.200
    51.720    -0.088     0.200
    87.544    -0.515     0.200
    89.522     0.113     0.200
    19.407    -0.062     0.200
    19.450     0.067     0.200
    19.626     0.516     0.200
    20.096     1.215     0.200
    21.949     1.153     0.200
    21.949     0.653     0.200
    23.065     1.103     0.200
    25.187     0.151     0.200
    28.647     0.620     0.200
    35.229     0.538     0.200
    35.505     0.480     0.200
    36.580    -0.189     0.200
    40.162     0.340     0.200
    41.151    -0.184     0.200
    41.595    -0.058     0.200
    51.720     0.126     0.200
    52.455     0.229     0.200
    87.545    -0.830     0.200
    89.518    -0.603     0.200
    19.928     0.679     0.200
    23.187     2.402     0.200
    25.018     0.498     0.200
    35.229    -0.280     0.200
    36.447     0.328     0.200
    87.437    -0.376     0.200
    89.419    -0.944     0.200
    21.913     0.889     0.200
    23.096     1.527     0.200
    25.126    -0.026     0.200
    28.654     0.381     0.200
    35.218     1.169     0.200
    36.544    -0.327     0.200
    40.157     0.603     0.200
    41.590     0.152     0.200
    41.590    -0.073     0.200
    51.746     0.014     0.200
    52.394     1.808     0.200
    19.275    -0.292     0.200
    19.280     0.442     0.200
    19.284    -1.033     0.200
    19.284    -1.583     0.200
    19.284     0.827     0.200
    19.460    -0.328     0.200
    19.460    -1.195     0.200
    19.460    -0.814     0.200
    19.940     0.618     0.200
    21.312    -0.638     0.200
    21.777     1.355     0.200
    21.863     1.106     0.200
    21.863     0.717     0.200
    21.863     0.908     0.200
    22.196     1.623     0.200
    22.627    -1.504     0.200
    23.156     1.288     0.200
    23.156     1.999     0.200
    23.156     1.058     0.200
    25.030     0.700     0.200
    25.030    -0.255     0.200
    28.675     1.067     0.200
    30.296     2.698     0.200
    30.341     0.959     0.200
    35.209     1.158     0.200
    35.336     0.942     0.200
    36.283    -0.547     0.200
    36.478     0.506     0.200
    36.478     0.156     0.200
    38.405     1.027     0.200
    39.010    -0.332     0.200
    38.839     2.102     0.200
    40.159     1.008     0.200
    40.276     0.752     0.200
    40.990     0.276     0.200
    40.990     0.112     0.200
    41.558     0.525     0.200
    41.590     0.470     0.200
    41.590     0.572     0.200
    42.461     0.651     0.200
    43.069     1.006     0.200
    48.361     1.052     0.200
    48.545     0.199     0.200
    51.796     0.098     0.200
    51.798    -0.092     0.200
    52.291     0.834     0.200
    71.923    -1.631     0.200
    71.923    -0.742     0.200
    74.218     0.065     0.200
    74.342     0.983     0.200
    74.898     0.264     0.200
    75.442     0.982     0.200
    75.925     0.253     0.200
    77.415     0.824     0.200
    78.078     0.490     0.200
    78.147     0.485     0.200
    78.311     0.128     0.200
    78.311    -0.142     0.200
    78.366     0.804     0.200
    78.525     0.585     0.200
    80.659     0.477     0.200
    83.135     0.481     0.200
    87.467    -0.177     0.200
    87.467    -0.562     0.200
    87.469    -0.112     0.200
    89.448    -0.425     0.200
    16.248     2.796     0.200
    16.905     3.987     0.200
    17.313     2.732     0.200
    17.440     3.069     0.200
    17.582     1.064     0.200
    18.495     0.256     0.200
    18.956     0.828     0.200
    19.173     0.806     0.200
    19.197     0.852     0.200
    19.277    -0.451     0.200
    19.277    -0.724     0.200
    19.277    -1.256     0.200
    19.277    -1.631     0.200
    19.277     0.080     0.200
    19.277    -0.224     0.200
    19.271    -0.976     0.200
    19.276    -0.589     0.200
    19.276    -0.979     0.200
    19.453    -0.143     0.200
    19.453    -0.830     0.200
    19.453     0.349     0.200
    19.453    -0.252     0.200
    19.453    -0.237     0.200
    19.453    -0.682     0.200
    19.509     0.036     0.200
    19.486     1.590     0.200
    19.783     1.141     0.200
    19.934     0.240     0.200
    19.934    -0.158     0.200
    20.041     1.271     0.200
    20.041     1.419     0.200
    20.041     0.826     0.200
    20.041     0.693     0.200
    20.041     1.130     0.200
    20.041     1.669     0.200
    20.284     1.311     0.200
    20.357    -0.512     0.200
    20.532     0.769     0.200
    20.560     0.351     0.200
    20.900    -0.494     0.200
    20.963    -0.504     0.200
    20.963    -0.262     0.200
    20.961     1.153     0.200
    20.934     1.084     0.200
    20.973     2.374     0.200
    20.973     0.694     0.200
    21.049     0.819     0.200
    21.146    -0.658     0.200
    21.305     0.542     0.200
    21.395     0.259     0.200
    21.402     0.818     0.200
    21.411     1.798     0.200
    21.722     1.562     0.200
    21.769     1.347     0.200
    21.769     1.449     0.200
    21.862     1.348     0.200
    21.862     1.559     0.200
    21.862     0.903     0.200
    22.131     0.769     0.200
    22.176     1.391     0.200
    22.205     0.747     0.200
    22.214     2.294     0.200
    22.214     0.974     0.200
    22.382    -1.000     0.200
    22.391     1.927     0.200
    22.474     2.134     0.200
    22.622     1.310     0.200
    22.917     1.878     0.200
    23.105     0.038     0.200
    23.176     0.752     0.200
    23.160     1.261     0.200
    23.163     0.737     0.200
    23.163     0.839     0.200
    23.163     1.323     0.200
    23.163     1.605     0.200
    23.163    -0.098     0.200
    23.163     0.527     0.200
    23.223     1.997     0.200
    23.402     0.712     0.200
    23.471     1.646     0.200
    23.471     1.529     0.200
    23.471     1.287     0.200
    23.578     0.805     0.200
    23.578    -0.023     0.200
    23.578     0.696     0.200
    23.653     0.117     0.200
    23.695     1.243     0.200
    23.702     1.566     0.200
    23.845     1.012     0.200
    23.822     1.604     0.200
    23.822     1.400     0.200
    23.822     0.604     0.200
    23.822     2.268     0.200
    23.887     1.577     0.200
    24.358     0.974     0.200
    24.398     0.989     0.200
    24.417     1.323     0.200
    24.568     2.131     0.200
    24.778     0.935     0.200
    25.048     1.326     0.200
    25.048    -0.033     0.200
    25.048     1.436     0.200
    25.024    -0.115     0.200
    25.024     0.698     0.200
    25.024     0.409     0.200
    25.024     0.143     0.200
    25.024     0.010     0.200
    25.024     0.612     0.200
    25.377     0.577     0.200
    25.362     0.948     0.200
    25.362     1.331     0.200
    25.363     1.999     0.200
    25.585     0.110     0.200
    25.585     0.954     0.200
    26.146     0.546     0.200
    26.440    -0.217     0.200
    26.440    -0.897     0.200
    26.644     0.623     0.200
    26.756     1.978     0.200
    26.881     0.329     0.200
    27.017     1.166     0.200
    27.017     0.619     0.200
    27.017     1.065     0.200
    27.017     0.869     0.200
    27.335     1.809     0.200
    27.411     1.324     0.200
    27.437     1.924     0.200
    27.567     1.052     0.200
    27.567     0.794     0.200
    27.567     0.310     0.200
    27.567     1.529     0.200
    27.567     1.732     0.200
    27.628     2.031     0.200
    27.630     0.350     0.200
    27.803     1.048     0.200
    27.881     1.041     0.200
    27.881     1.612     0.200
    27.943     1.957     0.200
    27.951     2.647     0.200
    27.954     2.207     0.200
    28.037     0.732     0.200
    28.044     2.157     0.200
    28.070     2.667     0.200
    28.083     0.507     0.200
    28.223     2.723     0.200
    28.403     1.336     0.200
    28.637     1.184     0.200
    28.662     1.255     0.200
    28.679    -0.461     0.200
    28.679     0.141     0.200
    28.679     1.203     0.200
    28.679     0.899     0.200
    28.686     1.110     0.200
    28.686     0.438     0.200
    28.686     1.259     0.200
    28.686     1.376     0.200
    28.690     1.210     0.200
    28.746     1.787     0.200
    28.733     1.482     0.200
    28.733     1.965     0.200
    28.737     1.195     0.200
    28.742     2.063     0.200
    28.744     1.226     0.200
    28.799     0.454     0.200
    28.849     2.915     0.200
    28.886     2.576     0.200
    28.904     2.166     0.200
    28.963     2.983     0.200
    28.978     2.443     0.200
    28.978     3.053     0.200
    28.982     2.846     0.200
    28.984     2.598     0.200
    29.062     0.954     0.200
    29.028     2.499     0.200
    29.028     2.449     0.200
    29.125     2.529     0.200
    29.220     1.255     0.200
    29.290     2.316     0.200
    29.300     1.291     0.200
    29.327     0.662     0.200
    29.339     2.033     0.200
    29.381     2.320     0.200
    29.395     1.604     0.200
    29.407     2.957     0.200
    29.457     3.131     0.200
    29.457     0.600     0.200
    29.457     2.592     0.200
    29.605     0.528     0.200
    29.605    -0.011     0.200
    29.605    -0.113     0.200
    29.606     1.500     0.200
    29.720     2.440     0.200
    29.735    -0.512     0.200
    30.010     2.489     0.200
    30.073     1.943     0.200
    30.138     2.131     0.200
    30.187     2.631     0.200
    30.168     1.442     0.200
    30.287     2.347     0.200
    30.329     1.975     0.200
    30.329     2.077     0.200
    30.346     0.115     0.200
    30.346     1.529     0.200
    30.354     2.026     0.200
    30.369    -0.166     0.200
    30.533     2.248     0.200
    30.809     2.560     0.200
    30.821     1.721     0.200
    30.977     0.977     0.200
    31.167     0.606     0.200
    31.167     0.395     0.200
    31.167    -1.050     0.200
    31.164     2.307     0.200
    31.185     2.843     0.200
    31.332     1.505     0.200
    31.344     1.262     0.200
    31.377     1.364     0.200
    31.578     2.510     0.200
    31.592     1.146     0.200
    31.623     2.566     0.200
    31.623     2.238     0.200
    31.701     1.263     0.200
    31.735     0.081     0.200
    31.763     2.882     0.200
    31.804     0.303     0.200
    31.804    -0.478     0.200
    31.864     1.160     0.200
    31.872     2.159     0.200
    31.872     2.276     0.200
    32.157     2.872     0.200
    32.150     1.988     0.200
    32.213     1.039     0.200
    32.213    -1.336     0.200
    32.299     1.845     0.200
    32.338     2.446     0.200
    32.356     1.657     0.200
    32.449    -0.621     0.200
    32.449    -1.019     0.200
    32.491     1.808     0.200
    32.504     2.514     0.200
    32.517     2.166     0.200
    32.517     2.315     0.200
    32.527     2.644     0.200
    32.535     1.778     0.200
    32.535     0.950     0.200
    32.593     2.446     0.200
    32.880     0.834     0.200
    33.081     1.961     0.200
    33.231     0.513     0.200
    33.231     0.881     0.200
    33.310    -0.798     0.200
    33.310    -1.118     0.200
    33.371     1.067     0.200
    33.371     1.246     0.200
    33.420     1.571     0.200
    33.420     0.672     0.200
    33.420     1.415     0.200
    33.534    -0.434     0.200
    33.534    -0.637     0.200
    33.594     2.828     0.200
    33.658    -0.153     0.200
    33.658    -0.692     0.200
    33.795     0.594     0.200
    33.795     0.844     0.200
    33.827    -0.648     0.200
    33.891     1.218     0.200
    33.879     3.192     0.200
    33.920     2.564     0.200
    33.920     2.252     0.200
    33.920     0.713     0.200
    33.956     2.053     0.200
    34.071     2.369     0.200
    34.087    -0.155     0.200
    34.087     1.017     0.200
    34.087     0.829     0.200
    34.193     2.876     0.200
    34.193     2.532     0.200
    34.193     1.227     0.200
    34.193     2.095     0.200
    34.193     3.024     0.200
    34.197     1.525     0.200
    34.340     1.589     0.200
    34.340     1.886     0.200
    34.340     0.433     0.200
    34.373     2.433     0.200
    34.454     0.603     0.200
    34.607     1.513     0.200
    34.607     1.162     0.200
    34.701    -0.310     0.200
    34.683     1.622     0.200
    34.837     1.437     0.200
    34.959     1.657     0.200
    34.966     2.704     0.200
    34.977     1.414     0.200
    35.055     0.937     0.200
    35.108     1.207     0.200
    35.171     1.878     0.200
    35.211     0.454     0.200
    35.211     0.993     0.200
    35.282     1.576     0.200
    35.328     0.431     0.200
    35.335     0.928     0.200
    35.341     1.373     0.200
    35.327     1.980     0.200
    35.432     1.788     0.200
    35.467     2.114     0.200
    35.467     1.888     0.200
    35.506     2.581     0.200
    35.506     2.221     0.200
    35.578     1.709     0.200
    35.578     0.732     0.200
    35.592     1.470     0.200
    35.627     2.213     0.200
    35.706     1.893     0.200
    35.706     2.237     0.200
    35.706     1.729     0.200
    35.713     2.086     0.200
    35.713     1.875     0.200
    35.772     1.569     0.200
    35.772     2.459     0.200
    35.772     1.874     0.200
    35.772     0.084     0.200
    35.914     2.100     0.200
    36.103    -0.021     0.200
    36.103     0.167     0.200
    36.103    -0.974     0.200
    36.134     1.763     0.200
    36.139     1.038     0.200
    36.234     2.006     0.200
    36.234     2.217     0.200
    36.276     0.258     0.200
    36.276     0.954     0.200
    36.280     0.264     0.200
    36.297     0.772     0.200
    36.261     1.592     0.200
    36.301     0.664     0.200
    36.312     1.618     0.200
    36.364     1.728     0.200
    36.364     1.619     0.200
    36.471     0.373     0.200
    36.471    -0.228     0.200
    36.471     1.131     0.200
    36.471     0.123     0.200
    36.471    -0.853     0.200
    36.440     2.576     0.200
    36.485     0.366     0.200
    36.503     0.711     0.200
    36.492     1.554     0.200
    36.509     1.764     0.200
    36.509     1.318     0.200
    36.563     2.430     0.200
    36.620     1.434     0.200
    36.649     2.117     0.200
    36.649     1.945     0.200
    36.658     2.259     0.200
    36.658     2.494     0.200
    36.689     0.982     0.200
    36.764     2.287     0.200
    36.764     2.787     0.200
    36.770     1.249     0.200
    36.770     1.429     0.200
    36.770     0.397     0.200
    36.770     1.538     0.200
    36.780     2.671     0.200
    36.780     2.453     0.200
    36.793     1.469     0.200
    36.808     0.863     0.200
    36.809     1.753     0.200
    36.809     0.167     0.200
    36.810     1.697     0.200
    36.821     0.969     0.200
    36.826    -0.638     0.200
    36.848     1.836     0.200
    36.870     1.092     0.200
    36.961     1.931     0.200
    37.079     1.382     0.200
    37.123     1.663     0.200
    37.262     1.359     0.200
    37.352     1.031     0.200
    37.452     1.788     0.200
    37.455     2.262     0.200
    37.481     0.482     0.200
    37.481     1.099     0.200
    37.481     1.294     0.200
    37.481     1.599     0.200
    37.659     1.423     0.200
    37.688     1.371     0.200
    37.697    -0.083     0.200
    37.697     0.269     0.200
    37.714     1.724     0.200
    37.737     2.094     0.200
    37.836     1.564     0.200
    37.917     1.711     0.200
    37.910     1.175     0.200
    37.958     1.624     0.200
    37.998     2.424     0.200
    38.024     1.023     0.200
    38.077     1.313     0.200
    38.080     1.677     0.200
    38.108     1.148     0.200
    38.105     1.225     0.200
    38.107     1.472     0.200
    38.116     1.559     0.200
    38.116     1.325     0.200
    38.132     1.570     0.200
    38.132     0.828     0.200
    38.168     1.841     0.200
    38.215     1.093     0.200
    38.215     1.195     0.200
    38.238     0.474     0.200
    38.260     1.773     0.200
    38.289     1.615     0.200
    38.289     1.490     0.200
    38.332     1.663     0.200
    38.354     0.073     0.200
    38.396     0.667     0.200
    38.420     1.879     0.200
    38.420     1.738     0.200
    38.431     1.530     0.200
    38.554     0.869     0.200
    38.632     1.573     0.200
    38.675     0.500     0.200
    38.675     1.302     0.200
    38.749     1.287     0.200
    38.766     1.551     0.200
    38.766     0.957     0.200
    38.858     1.252     0.200
    38.911     0.916     0.200
    39.003     0.255     0.200
    39.023     2.253     0.200
    39.023     2.511     0.200
    39.028     2.167     0.200
    38.831     2.513     0.200
    39.114     1.194     0.200
    39.175    -0.064     0.200
    39.147     1.898     0.200
    39.167     1.604     0.200
    39.224     2.981     0.200
    39.386     2.052     0.200
    39.456     0.904     0.200
    39.460     1.395     0.200
    39.473     1.515     0.200
    39.488     1.889     0.200
    39.497     0.533     0.200
    39.514     1.459     0.200
    39.525     2.245     0.200
    39.551     2.102     0.200
    39.559     1.490     0.200
    39.559     1.210     0.200
    39.583     2.225     0.200
    39.637     1.846     0.200
    39.652     1.606     0.200
    39.704     1.316     0.200
    39.704     1.271     0.200
    39.720     1.165     0.200
    39.722     1.814     0.200
    39.748     0.467     0.200
    39.782     2.134     0.200
    39.783     2.072     0.200
    39.818     0.263     0.200
    39.851     1.227     0.200
    39.883     1.578     0.200
    39.945     0.857     0.200
    39.960     1.561     0.200
    39.966     1.362     0.200
    40.031     0.003     0.200
    40.031     1.425     0.200
    40.031     1.527     0.200
    40.031     1.120     0.200
    40.049     0.463     0.200
    40.084     1.293     0.200
    40.078     0.604     0.200
    40.162     1.287     0.200
    40.277     1.471     0.200
    40.277     1.260     0.200
    40.277     0.408     0.200
    40.277     0.572     0.200
    40.285     1.195     0.200
    40.311     1.078     0.200
    40.311     5.476     0.200
    40.287     1.526     0.200
    40.362     1.292     0.200
    40.408     1.416     0.200
    40.449     1.944     0.200
    40.490     0.801     0.200
    40.557     1.568     0.200
    40.574     1.204     0.200
    40.651     0.714     0.200
    40.652     0.722     0.200
    40.680     2.582     0.200
    40.685     2.266     0.200
    40.984     0.725     0.200
    40.984    -0.166     0.200
    41.037     1.833     0.200
    41.046     0.704     0.200
    41.105     2.123     0.200
    41.092     1.412     0.200
    41.092     0.350     0.200
    41.138     2.609     0.200
    41.288     0.364     0.200
    41.288    -0.347     0.200
    41.289     0.722     0.200
    41.302     1.003     0.200
    41.357     0.768     0.200
    41.400     0.599     0.200
    41.470     1.513     0.200
    41.487     1.811     0.200
    41.510     2.019     0.200
    41.547     1.313     0.200
    41.561     0.095     0.200
    41.578     0.483     0.200
    41.589     2.210     0.200
    41.593     0.612     0.200
    41.593     0.112     0.200
    41.593     0.714     0.200
    41.593     0.612     0.200
    41.638     0.936     0.200
    41.697    -0.089     0.200
    41.697    -0.957     0.200
    41.661     0.730     0.200
    41.671     0.754     0.200
    41.672     0.597     0.200
    41.672     0.832     0.200
    41.672    -0.309     0.200
    41.672     0.964     0.200
    41.710     1.690     0.200
    41.776     1.089     0.200
    41.829     0.903     0.200
    41.829    -0.113     0.200
    41.875     1.188     0.200
    42.005     0.635     0.200
    42.034    -0.498     0.200
    42.034     0.534     0.200
    42.034     1.034     0.200
    42.089     1.901     0.200
    42.186     2.064     0.200
    42.185     1.214     0.200
    42.227     1.083     0.200
    42.262     1.357     0.200
    42.340     1.060     0.200
    42.360     2.056     0.200
    42.415     1.394     0.200
    42.448     0.598     0.200
    42.458     0.612     0.200
    42.458     1.034     0.200
    42.470     2.248     0.200
    42.474     1.102     0.200
    42.513    -0.100     0.200
    42.491     0.929     0.200
    42.510     1.125     0.200
    42.544     1.163     0.200
    42.544    -0.118     0.200
    42.544     1.296     0.200
    42.544     0.952     0.200
    42.544     1.530     0.200
    42.560     1.300     0.200
    42.598     1.279     0.200
    42.626     1.362     0.200
    42.628     1.201     0.200
    42.641     0.945     0.200
    42.659     1.247     0.200
    42.664     1.495     0.200
    42.704     0.220     0.200
    42.666     2.059     0.200
    42.671     1.315     0.200
    42.671     1.026     0.200
    42.775     1.981     0.200
    42.849     1.228     0.200
    42.849     1.169     0.200
    42.945     1.195     0.200
    42.993     1.158     0.200
    43.007     1.698     0.200
    43.074     2.768     0.200
    43.074     1.096     0.200
    43.152     2.241     0.200
    43.166     1.354     0.200
    43.189     0.689     0.200
    43.189     0.932     0.200
    43.189     0.822     0.200
    43.189     1.189     0.200
    43.398     0.757     0.200
    43.394     1.497     0.200
    43.493     0.458     0.200
    43.559     2.495     0.200
    43.564     2.270     0.200
    43.659     1.962     0.200
    43.659     2.259     0.200
    43.665     1.387     0.200
    43.818     1.046     0.200
    43.950     0.877     0.200
    43.999     1.776     0.200
    44.000     1.525     0.200
    44.068     2.071     0.200
    44.172     0.992     0.200
    44.204    -0.172     0.200
    44.204     0.828     0.200
    44.214     1.722     0.200
    44.276     1.517     0.200
    44.353     1.755     0.200
    44.360     1.471     0.200
    44.492     0.983     0.200
    44.492     1.186     0.200
    44.496     1.405     0.200
    44.619     1.033     0.200
    44.662     1.180     0.200
    44.770     0.062     0.200
    44.951    -1.023     0.200
    45.740     1.013     0.200
    45.740     0.122     0.200
    45.740     0.826     0.200
    45.740     1.341     0.200
    46.115     0.128     0.200
    46.113     0.160     0.200
    46.436     0.940     0.200
    46.738    -1.432     0.200
    46.738    -1.643     0.200
    46.868     0.078     0.200
    46.868    -0.375     0.200
    46.868    -1.086     0.200
    46.918    -0.241     0.200
    46.933     1.369     0.200
    46.950     1.504     0.200
    47.092     1.122     0.200
    47.141     1.217     0.200
    47.161     1.840     0.200
    47.478     0.274     0.200
    47.619     0.960     0.200
    47.619     0.475     0.200
    47.714     0.241     0.200
    47.733     1.012     0.200
    47.826     1.463     0.200
    47.826     0.549     0.200
    47.913     0.715     0.200
    47.887     0.187     0.200
    48.016     1.345     0.200
    48.197     1.045     0.200
    48.366     1.164     0.200
    48.549     0.239     0.200
    48.549    -0.417     0.200
    48.562     1.710     0.200
    48.562     1.445     0.200
    48.576     1.101     0.200
    48.576    -0.117     0.200
    48.576     1.890     0.200
    48.578     1.119     0.200
    48.716     0.473     0.200
    48.752     0.941     0.200
    48.752    -0.082     0.200
    48.839     0.568     0.200
    48.870     1.373     0.200
    48.870    -0.088     0.200
    48.870     0.873     0.200
    48.870     1.232     0.200
    49.073     1.072     0.200
    49.175     0.894     0.200
    49.242     0.008     0.200
    49.375     1.499     0.200
    49.643     0.426     0.200
    49.643     0.270     0.200
    49.643    -0.761     0.200
    49.643    -0.183     0.200
    49.643     0.122     0.200
    49.753     0.500     0.200
    49.813     0.919     0.200
    50.201     0.391     0.200
    50.201    -0.140     0.200
    50.290     0.392     0.200
    50.414     1.022     0.200
    50.414     1.139     0.200
    50.414     0.499     0.200
    50.495     1.200     0.200
    50.498     0.865     0.200
    50.797    -0.390     0.200
    50.797    -1.179     0.200
    51.056     1.592     0.200
    51.117     0.112     0.200
    51.567     0.190     0.200
    51.817     1.474     0.200
    51.817     1.771     0.200
    51.830     1.285     0.200
    51.803    -0.333     0.200
    51.803     1.050     0.200
    51.804     0.172     0.200
    51.804    -0.109     0.200
    51.868     1.882     0.200
    51.868     1.656     0.200
    51.868     0.132     0.200
    52.017     0.737     0.200
    52.126     1.086     0.200
    52.126     0.015     0.200
    52.126     0.211     0.200
    52.126     0.687     0.200
    52.126     0.398     0.200
    52.223     0.298     0.200
    52.223     0.188     0.200
    52.283     0.610     0.200
    52.283    -0.218     0.200
    52.297     0.553     0.200
    52.301     0.719     0.200
    52.283     0.648     0.200
    52.709     0.685     0.200
    52.915     1.873     0.200
    53.041    -0.285     0.200
    53.332     0.098     0.200
    53.334    -0.217     0.200
    53.334     0.142     0.200
    53.334    -0.358     0.200
    53.346     0.397     0.200
    53.557     0.541     0.200
    54.218     1.485     0.200
    54.283     0.793     0.200
    54.433     0.794     0.200
    54.433     0.950     0.200
    54.645     0.196     0.200
    54.731     0.796     0.200
    54.749     0.045     0.200
    54.901     1.742     0.200
    55.153     0.923     0.200
    55.233     0.049     0.200
    55.233     0.174     0.200
    55.233    -1.060     0.200
    55.233     1.846     0.200
    55.309     0.499     0.200
    55.793     1.941     0.200
    55.793     0.425     0.200
    55.793     1.519     0.200
    55.851     0.216     0.200
    55.851    -1.714     0.200
    56.076     0.897     0.200
    56.358     1.169     0.200
    56.381     1.712     0.200
    56.525     0.261     0.200
    56.551     0.537     0.200
    58.252    -0.755     0.200
    58.252     0.034     0.200
    58.252    -0.356     0.200
    58.156     1.302     0.200
    58.422     1.314     0.200
    59.207    -0.440     0.200
    59.207     1.419     0.200
    59.207     0.669     0.200
    59.207     0.427     0.200
    59.207     0.817     0.200
    59.727     0.963     0.200
    59.727     0.455     0.200
    59.727    -0.412     0.200
    59.727     0.557     0.200
    59.891     1.635     0.200
    59.911     0.464     0.200
    59.911    -0.529     0.200
    59.985     1.658     0.200
    59.985     0.385     0.200
    59.985     1.783     0.200
    60.068     0.848     0.200
    60.068     1.223     0.200
    60.189     0.591     0.200
    60.189     2.099     0.200
    60.334    -0.701     0.200
    60.334    -0.302     0.200
    60.336    -0.119     0.200
    60.336    -0.768     0.200
    60.356     0.444     0.200
    60.356     1.756     0.200
    60.783     0.306     0.200
    61.773    -0.070     0.200
    61.773     2.758     0.200
    63.384     0.463     0.200
    63.384     0.994     0.200
    63.384     1.244     0.200
    63.384     0.775     0.200
    63.957     0.098     0.200
    63.957    -0.051     0.200
    63.957    -0.762     0.200
    64.108     0.478     0.200
    64.652     0.295     0.200
    65.597     1.043     0.200
    65.597     0.660     0.200
    66.220    -0.819     0.200
    66.232    -0.100     0.200
    66.689     0.028     0.200
    66.689     0.450     0.200
    66.689    -0.535     0.200
    66.689     0.551     0.200
    66.772    -0.463     0.200
    66.845     1.422     0.200
    66.845    -0.492     0.200
    67.295    -0.286     0.200
    67.295    -0.935     0.200
    67.295     0.120     0.200
    67.295    -0.161     0.200
    67.968     0.373     0.200
    67.968     0.545     0.200
    68.262     0.650     0.200
    68.262     0.791     0.200
    68.262    -0.045     0.200
    68.262     0.900     0.200
    68.610     0.830     0.200
    68.713     0.348     0.200
    68.713     0.473     0.200
    69.379     0.120     0.200
    69.379    -0.028     0.200
    69.379    -0.130     0.200
    70.158    -0.904     0.200
    69.989    -0.344     0.200
    71.929    -0.173     0.200
    71.929    -0.517     0.200
    71.929    -0.775     0.200
    72.726    -0.609     0.200
    73.479    -0.251     0.200
    73.479    -0.938     0.200
    73.526     0.816     0.200
    73.594     0.660     0.200
    73.626     0.426     0.200
    74.338     1.461     0.200
    74.583    -0.487     0.200
    74.583    -0.706     0.200
    75.483     0.537     0.200
    75.483    -0.143     0.200
    75.921    -0.026     0.200
    75.925     0.070     0.200
    76.225     0.817     0.200
    76.666     0.984     0.200
    78.043     1.186     0.200
    78.043     1.061     0.200
    78.043    -0.220     0.200
    78.043     0.600     0.200
    78.307     0.235     0.200
    78.307    -0.530     0.200
    78.686     0.824     0.200
    79.209     1.055     0.200
    79.965     0.036     0.200
    79.965    -0.730     0.200
    80.131     0.920     0.200
    80.663     0.074     0.200
    80.663     0.347     0.200
    80.736     0.355     0.200
    81.123    -1.196     0.200
    81.582    -0.294     0.200
    83.133     0.190     0.200
    83.133     0.503     0.200
    83.183    -0.402     0.200
    83.391     1.103     0.200
    83.437     1.710     0.200
    83.993     0.185     0.200
    84.787    -0.621     0.200
    85.768    -1.010     0.200
    86.022     1.507     0.200
    86.375     0.186     0.200
    86.376     1.907     0.200
    86.484    -0.521     0.200
    86.484    -0.123     0.200
    86.622     0.007     0.200
    87.460    -0.279     0.200
    87.460    -0.316     0.200
    87.463    -0.250     0.200
    87.463    -0.125     0.200
    87.463    -0.687     0.200
    89.442     0.026     0.200
    89.442    -0.598     0.200
    89.442    -0.731     0.200
    89.909     0.552     0.200
    89.909    -0.175     0.200
    89.909     1.005     0.200
    89.975    -0.138     0.200
    89.975    -1.349     0.200
    91.267    -1.026     0.200
    91.765    -0.441     0.200
    93.223    -0.669     0.200
    93.971     0.591     0.200
    95.078     0.203     0.200
    96.482     0.697     0.200
    96.584     0.384     0.200
    19.393     0.303     0.200
    19.465    -0.026     0.200
    19.641    -0.786     0.200
    20.098    -0.494     0.200
    20.205    -0.800     0.200
    21.494    -0.958     0.200
    21.917     0.913     0.200
    21.917     0.595     0.200
    21.917     1.155     0.200
    21.971     1.764     0.200
    22.310     0.646     0.200
    25.189     0.118     0.200
    25.236     2.111     0.200
    36.634    -0.318     0.200
    36.634    -0.879     0.200
    39.155    -0.893     0.200
    40.041     0.420     0.200
    40.110     0.219     0.200
    40.284     0.919     0.200
    40.284     0.744     0.200
    41.513    -0.511     0.200
    41.544     0.505     0.200
    41.544     0.880     0.200
    48.904     1.104     0.200
    50.341     0.597     0.200
    51.663     0.430     0.200
    51.664     0.535     0.200
    51.664     0.320     0.200
    52.489    -0.281     0.200
    74.403     1.068     0.200
    74.448     0.602     0.200
    76.040    -0.448     0.200
    80.844     0.316     0.200
    87.601    -0.161     0.200
    87.603    -0.615     0.200
    89.574    -0.229     0.200
    19.438     0.317     0.200
    25.020     0.070     0.200
    36.419    -1.074     0.200
    40.977     1.651     0.200
    87.407    -0.699     0.200
    89.389    -0.832     0.200
    15.341     6.852     0.200
    15.721     3.487     0.200
    16.215     4.528     0.200
    17.284     5.185     0.200
    19.391     0.200     0.200
    19.395     1.545     0.200
    19.457     0.588     0.200
    19.634     0.863     0.200
    20.093     0.425     0.200
    20.200     0.694     0.200
    20.377     0.551     0.200
    20.784     2.685     0.200
    20.818     0.840     0.200
    20.912     2.018     0.200
    21.255     1.978     0.200
    21.918     1.097     0.200
    21.918    -0.028     0.200
    22.291     2.066     0.200
    23.020     1.435     0.200
    23.020     1.318     0.200
    23.020     1.435     0.200
    25.184     0.166     0.200
    25.225     0.087     0.200
    25.988     1.668     0.200
    28.601     0.408     0.200
    35.187     0.668     0.200
    35.519     1.205     0.200
    35.519     0.275     0.200
    36.624     0.497     0.200
    36.624    -0.518     0.200
    36.624     0.068     0.200
    38.015     1.337     0.200
    40.117     0.714     0.200
    40.288     1.135     0.200
    40.288     0.892     0.200
    41.151    -0.435     0.200
    41.151    -0.185     0.200
    41.551     0.099     0.200
    41.551     0.529     0.200
    46.693     0.913     0.200
    49.260     0.690     0.200
    51.674     0.014     0.200
    52.204     0.351     0.200
    52.479    -0.005     0.200
    53.527    -0.223     0.200
    59.035     0.421     0.200
    71.767    -1.006     0.200
    78.418    -0.750     0.200
    78.418     0.500     0.200
    87.590    -0.784     0.200
    87.590    -0.401     0.200
    89.564    -0.229     0.200
    89.564     0.271     0.200
    17.351     2.233     0.200
    19.345     0.190     0.200
    19.543    -0.292     0.200
    25.110    -0.451     0.200
    36.521    -1.207     0.200
    41.071     0.680     0.200
    87.497     0.203     0.200
    19.318     0.871     0.200
    19.565     0.545     0.200
    20.020     1.456     0.200
    21.855     0.649     0.200
    25.111     0.048     0.200
    36.613     0.164     0.200
    41.079    -0.851     0.200
    51.672    -0.431     0.200
    87.592    -0.273     0.200
    89.570    -0.662     0.200
    19.352     0.786     0.200
    19.588     0.668     0.200
    20.049     1.241     0.200
    21.891     1.424     0.200
    23.041     1.905     0.200
    25.140     0.373     0.200
    28.603     1.394     0.200
    35.177     1.375     0.200
    35.474     0.665     0.200
    36.600    -0.221     0.200
    40.112     0.879     0.200
    41.106     0.196     0.200
    41.545     0.320     0.200
    51.691     0.342     0.200
    87.574    -0.698     0.200
    89.550    -0.256     0.200
    14.894     6.984     0.200
    17.606     6.043     0.200
    19.277    -0.923     0.200
    19.282    -1.303     0.200
    19.282     0.056     0.200
    19.420    -0.141     0.200
    19.420    -1.766     0.200
    19.918     0.832     0.200
    20.025    -1.341     0.200
    20.025     0.128     0.200
    21.271    -0.875     0.200
    21.723     1.663     0.200
    21.894     0.534     0.200
    21.894     0.799     0.200
    21.894     1.338     0.200
    22.193    -0.157     0.200
    23.238     2.014     0.200
    23.238     1.342     0.200
    23.715     0.953     0.200
    23.857     0.955     0.200
    25.007     0.719     0.200
    25.007    -0.055     0.200
    28.747     0.855     0.200
    28.754    -0.230     0.200
    30.230     2.657     0.200
    35.286     0.913     0.200
    35.286    -1.353     0.200
    35.286     2.452     0.200
    35.268     0.488     0.200
    36.396     0.679     0.200
    40.224     0.530     0.200
    40.323    -0.445     0.200
    40.323    -0.578     0.200
    40.962     0.281     0.200
    40.962     0.156     0.200
    41.654     0.116     0.200
    41.654     0.444     0.200
    49.035     1.168     0.200
    49.624     1.268     0.200
    50.197     0.554     0.200
    51.879    -0.215     0.200
    51.879    -1.114     0.200
    52.228    -0.896     0.200
    78.317    -0.437     0.200
    78.317    -1.101     0.200
    87.386     0.576     0.200
    87.388    -1.014     0.200
    89.368    -0.041     0.200
    14.700     9.549     0.200
    17.207     2.738     0.200
    17.269     4.061     0.200
    18.101     0.004     0.200
    19.330     0.060     0.200
    19.335    -0.343     0.200
    19.346     0.668     0.200
    19.395    -1.010     0.200
    19.395    -0.129     0.200
    19.571    -0.800     0.200
    19.571     0.675     0.200
    20.029     1.704     0.200
    20.136     1.222     0.200
    20.136     1.542     0.200
    21.869     1.424     0.200
    21.869     0.381     0.200
    22.273     0.028     0.200
    23.035     1.558     0.200
    23.035     2.038     0.200
    23.035     1.939     0.200
    23.035     2.439     0.200
    24.002     1.526     0.200
    25.120     0.189     0.200
    25.120    -0.710     0.200
    25.120     0.439     0.200
    25.192     0.176     0.200
    25.344     1.905     0.200
    28.590     0.987     0.200
    28.590     0.912     0.200
    28.597     0.681     0.200
    30.308     2.175     0.200
    35.159     1.453     0.200
    35.159     1.563     0.200
    35.459     1.440     0.200
    36.604     0.477     0.200
    36.604    -1.052     0.200
    37.538     0.037     0.200
    41.087     0.576     0.200
    41.087    -0.401     0.200
    41.528     0.778     0.200
    41.528     0.054     0.200
    50.276     0.161     0.200
    51.683     0.646     0.200
    52.425     1.053     0.200
    78.359     0.390     0.200
    83.150     0.132     0.200
    83.150     0.607     0.200
    87.581    -0.220     0.200
    89.558     0.093     0.200
    19.332     1.856     0.200
    19.546    -0.239     0.200
    19.546     1.471     0.200
    20.015     0.843     0.200
    20.122    -0.100     0.200
    21.890     1.081     0.200
    21.890    -0.202     0.200
    23.089     0.245     0.200
    25.106     0.411     0.200
    25.106    -0.460     0.200
    28.638     0.264     0.200
    28.638    -0.616     0.200
    35.198     1.420     0.200
    35.198     0.051     0.200
    36.549    -0.382     0.200
    40.139     0.547     0.200
    41.571     0.296     0.200
    41.571    -0.605     0.200
    51.737     0.449     0.200
    51.737    -0.676     0.200
    73.155     1.026     0.200
    74.268    -0.736     0.200
    75.139    -0.007     0.200
    78.581    -0.535     0.200
    87.527    -1.172     0.200
    89.505    -0.844     0.200
    17.350     2.530     0.200
    17.585     2.108     0.200
    19.328    -0.108     0.200
    19.525     0.336     0.200
    19.525    -0.439     0.200
    19.525     0.936     0.200
    20.002     0.857     0.200
    21.377    -1.165     0.200
    21.898     0.807     0.200
    23.123     1.728     0.200
    23.123     0.878     0.200
    23.123     0.048     0.200
    23.959     1.403     0.200
    25.105     0.333     0.200
    25.091     0.478     0.200
    25.091    -0.653     0.200
    25.387    -0.110     0.200
    27.021     1.917     0.200
    28.666     0.978     0.200
    28.666     0.703     0.200
    28.673     1.042     0.200
    35.219     1.068     0.200
    35.219     0.707     0.200
    35.401     1.501     0.200
    36.515     0.495     0.200
    40.009     1.299     0.200
    40.163     0.726     0.200
    41.053     0.614     0.200
    41.053     0.079     0.200
    41.563     0.392     0.200
    41.594     0.590     0.200
    41.594     0.491     0.200
    50.263     0.403     0.200
    51.770     0.567     0.200
    55.175     2.970     0.200
    69.892     0.759     0.200
    72.924     0.380     0.200
    73.685     0.404     0.200
    74.267     0.258     0.200
    74.351     0.964     0.200
    74.950     0.814     0.200
    75.156     0.662     0.200
    78.361    -0.764     0.200
    83.174    -0.535     0.200
    87.495    -0.554     0.200
    89.473    -0.207     0.200
    14.796     6.461     0.200
    16.803     2.738     0.200
    17.361     3.538     0.200
    17.523     4.624     0.200
    19.335    -0.481     0.200
    19.340    -0.177     0.200
    19.345    -0.461     0.200
    19.356    -1.680     0.200
    19.532     0.052     0.200
    19.532     0.598     0.200
    19.532    -0.222     0.200
    19.532     1.005     0.200
    20.011     0.843     0.200
    20.118     0.258     0.200
    20.118    -1.524     0.200
    21.384    -0.499     0.200
    21.847     1.238     0.200
    21.912     0.879     0.200
    21.912     0.676     0.200
    21.912     1.137     0.200
    23.131     1.135     0.200
    23.131     1.690     0.200
    23.131     1.362     0.200
    23.131     2.792     0.200
    23.966     1.277     0.200
    25.101     0.237     0.200
    25.101    -0.396     0.200
    25.101     0.534     0.200
    25.401     2.807     0.200
    26.105    -0.346     0.200
    26.976    -1.035     0.200
    27.034     1.942     0.200
    28.678     0.742     0.200
    28.678     0.593     0.200
    28.678     0.945     0.200
    28.685     1.110     0.200
    31.842    -0.926     0.200
    35.233     0.914     0.200
    35.233     1.086     0.200
    35.407     1.403     0.200
    36.349     0.762     0.200
    36.508    -0.099     0.200
    36.508    -0.669     0.200
    36.508     0.401     0.200
    38.965     1.871     0.200
    40.176     0.637     0.200
    40.312     1.304     0.200
    40.312     1.187     0.200
    41.062    -0.712     0.200
    41.608     0.432     0.200
    41.608     0.432     0.200
    48.342     0.212     0.200
    51.777     0.306     0.200
    51.779     0.342     0.200
    52.357     0.493     0.200
    74.006     1.150     0.200
    74.364     0.761     0.200
    75.168     0.729     0.200
    75.565     1.007     0.200
    76.537     0.028     0.200
    76.728    -0.192     0.200
    77.429     0.976     0.200
    78.142     0.842     0.200
    78.374    -0.141     0.200
    78.589     1.115     0.200
    79.662     0.283     0.200
    79.677     0.320     0.200
    79.986     0.123     0.200
    80.724     0.877     0.200
    80.986     0.124     0.200
    82.511     1.227     0.200
    83.188     0.417     0.200
    83.188    -0.317     0.200
    83.462     1.100     0.200
    87.486    -0.616     0.200
    87.486    -0.764     0.200
    87.486    -0.014     0.200
    89.463    -0.070     0.200
    89.463    -0.336     0.200
    19.316    -1.751     0.200
    19.388    -0.280     0.200
    19.918    -0.201     0.200
    25.004     0.900     0.200
    19.302     1.139     0.200
    19.540    -0.912     0.200
    19.998     0.353     0.200
    21.847     0.871     0.200
    25.089     0.534     0.200
    35.148    -0.119     0.200
    41.056    -0.194     0.200
    17.447     4.426     0.200
    19.356    -0.243     0.200
    19.360    -1.663     0.200
    19.630     0.185     0.200
    19.630     0.084     0.200
    19.630    -0.143     0.200
    19.630    -0.018     0.200
    20.075     1.412     0.200
    20.181     0.166     0.200
    20.181     1.275     0.200
    21.868    -0.025     0.200
    21.868     1.265     0.200
    21.971     1.462     0.200
    22.965     1.885     0.200
    22.965     0.752     0.200
    24.059     1.485     0.200
    25.166     0.442     0.200
    25.166    -0.253     0.200
    25.268     0.404     0.200
    25.329     3.021     0.200
    28.538     0.915     0.200
    28.538     0.462     0.200
    28.545     1.057     0.200
    32.773     1.760     0.200
    35.126     0.391     0.200
    35.126     0.735     0.200
    35.525     1.381     0.200
    35.525    -0.376     0.200
    36.676     0.346     0.200
    36.676     0.791     0.200
    36.652     2.118     0.200
    37.563     0.202     0.200
    40.055     0.253     0.200
    41.137     0.121     0.200
    41.114     0.596     0.200
    41.489     0.702     0.200
    44.396    -0.340     0.200
    50.310     0.545     0.200
    51.617     0.460     0.200
    52.497     0.294     0.200
    52.497     0.653     0.200
    76.002     0.484     0.200
    77.594    -0.011     0.200
    78.380     1.380     0.200
    78.380     0.927     0.200
    78.603     0.718     0.200
    79.681     0.201     0.200
    80.233     0.984     0.200
    83.154     0.321     0.200
    89.623    -0.113     0.200
    19.296     0.091     0.200
    19.436    -0.190     0.200
    23.241     2.906     0.200
    25.025    -1.062     0.200
    28.758    -0.261     0.200
    35.283     1.069     0.200
    36.394     0.411     0.200
    40.979    -0.328     0.200
    83.180    -0.657     0.200
    19.331     1.083     0.200
    19.584     0.423     0.200
    20.037    -0.296     0.200
    83.145     0.223     0.200
    19.474     0.844     0.200
    19.977    -0.034     0.200
    25.066    -0.095     0.200
    35.335     0.554     0.200
    41.019     0.014     0.200
    19.298     1.533     0.200
    19.451    -0.487     0.200
    19.946     1.151     0.200
    23.215     1.868     0.200
    25.035    -0.314     0.200
    28.736     0.606     0.200
    35.265     0.308     0.200
    36.421    -0.038     0.200
    40.991    -0.500     0.200
    41.648    -0.090     0.200
    87.407    -1.086     0.200
    89.387    -0.075     0.200
    19.457     0.308     0.200
    25.029    -0.286     0.200
    19.184    -0.923     0.200
    19.571     1.045     0.200
    19.571    -1.467     0.200
    20.020    -0.806     0.200
    24.000     0.832     0.200
    25.111     0.606     0.200
    25.111    -1.027     0.200
    25.311     2.388     0.200
    28.553     0.964     0.200
    87.616    -0.189     0.200
    89.593    -0.881     0.200
    22.820     1.950     0.200
    28.426     0.112     0.200
    36.825     0.080     0.200
    51.477     0.026     0.200
    89.759     0.743     0.200
    19.604    -0.706     0.200
    25.156    -0.292     0.200
    35.183     0.889     0.200
    36.606    -0.335     0.200
    51.688    -0.228     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
    99.514     0.340     0.200
    99.918     1.554     0.200
    99.918    -0.167     0.200
    99.903     1.798     0.200
   100.553     1.928     0.200
   101.948     3.805     0.200
   101.948     0.006     0.200
   102.551     1.550     0.200
   104.668     0.588     0.200
   107.280     1.449     0.200
    99.903    -1.331     0.200
   107.292     0.714     0.200
   107.961    -2.712     0.200
    99.583     0.074     0.200
    99.936     1.682     0.200
    99.921    -0.708     0.200
   100.583     1.325     0.200
   101.912     1.717     0.200
   101.912    -1.578     0.200
   102.180     0.860     0.200
   102.584     1.626     0.200
   107.316     2.508     0.200
   111.580    -0.254     0.200
    99.813    -0.710     0.200
    99.861    -0.841     0.200
    99.912     1.558     0.200
   100.568     1.677     0.200
   101.943     1.877     0.200
   102.110     0.611     0.200
   102.562     1.749     0.200
   102.769    -0.197     0.200
   107.285     2.930     0.200
   109.919     3.410     0.200
    99.577     0.280     0.200
    99.619     0.006     0.200
    99.645     1.157     0.200
    99.645     1.051     0.200
    99.753    -0.183     0.200
    99.804    -0.356     0.200
    99.804    -0.817     0.200
    99.804     0.581     0.200
    99.977     2.007     0.200
   100.635     2.076     0.200
   100.635     1.599     0.200
   100.730     1.053     0.200
   100.928     0.580     0.200
   101.723     1.772     0.200
   101.880    -1.115     0.200
   102.058     1.860     0.200
   102.151     1.568     0.200
   102.521     0.239     0.200
   102.628     1.005     0.200
   102.708     0.203     0.200
   102.758     2.501     0.200
   103.151     1.401     0.200
   103.346     2.676     0.200
   103.944     2.608     0.200
   104.221     1.234     0.200
   104.992     1.778     0.200
   107.347     0.838     0.200
   109.986     4.435     0.200
   116.018     1.529     0.200
   116.126    -3.899     0.200
    99.622     0.697     0.200
    99.732     2.434     0.200
    99.779    -0.902     0.200
    99.779    -0.002     0.200
    99.943     2.196     0.200
   100.606     1.741     0.200
   101.687    -1.858     0.200
   101.919    -1.389     0.200
   102.026     2.286     0.200
   102.595     0.679     0.200
   103.197     1.022     0.200
   104.661     0.197     0.200
   106.237     2.957     0.200
   107.308     0.237     0.200
    99.739     0.947     0.200
   101.978     0.917     0.200
   101.943    -0.830     0.200
    99.584     0.307     0.200
   101.958    -1.495     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    22.728   231.285     0.200
    23.014   230.690     0.200
    25.214   216.636     0.200
    28.572   191.157     0.200
    29.326   187.700     0.200
    30.210   181.783     0.200
    33.961   159.011     0.200
    36.625   143.830     0.200
    36.791   143.469     0.200
    37.993   135.503     0.200
    38.651   132.037     0.200
    40.537   123.114     0.200
    42.517   113.891     0.200
    43.613   107.135     0.200
    44.191   105.858     0.200
    44.347   104.456     0.200
    48.854    85.800     0.200
    49.753    82.020     0.200
    50.280    81.648     0.200
    66.894    25.236     0.200
    98.841     3.122     0.200
    98.963     0.709     0.200
    99.313     2.398     0.200
    22.714   231.447     0.200
    23.030   229.102     0.200
    25.197   215.617     0.200
    28.586   189.720     0.200
    32.286   169.315     0.200
    35.463   148.824     0.200
    36.415   144.769     0.200
    36.609   142.721     0.200
    36.697   141.706     0.200
    36.853   141.504     0.200
    37.009   141.305     0.200
    38.008   135.150     0.200
    39.343   128.162     0.200
    39.384   128.194     0.200
    39.635   126.973     0.200
    39.706   126.135     0.200
    39.937   124.895     0.200
    39.965   125.639     0.200
    40.539   122.391     0.200
    42.533   112.699     0.200
    42.841   111.797     0.200
    44.375   104.000     0.200
    49.747    80.795     0.200
    50.278    78.175     0.200
    51.678    72.800     0.200
    22.697   232.000     0.200
    22.720   231.112     0.200
    23.003   229.900     0.200
    36.640   143.653     0.200
    40.536   122.728     0.200
    42.972   110.846     0.200
    42.892   111.996     0.200
    43.834   107.172     0.200
    44.082   107.183     0.200
    44.389   104.768     0.200
    49.797    79.420     0.200
    51.655    74.744     0.200
    97.383     1.134     0.200
    97.634     0.979     0.200
    98.197     2.121     0.200
    98.848     1.149     0.200
    98.963     0.789     0.200
    22.775   230.089     0.200
    22.679   232.349     0.200
    23.075   229.229     0.200
    28.621   190.989     0.200
    33.900   158.049     0.200
    36.563   143.760     0.200
    37.049   142.103     0.200
    38.006   138.268     0.200
    38.047   136.479     0.200
    38.703   133.710     0.200
    39.384   128.271     0.200
    39.424   126.594     0.200
    39.675   127.174     0.200
    39.746   127.070     0.200
    40.005   126.724     0.200
    40.579   123.155     0.200
    42.463   114.264     0.200
    42.798   111.806     0.200
    43.592   105.863     0.200
    44.299   105.106     0.200
    49.720    81.154     0.200
    51.722    73.997     0.200
    97.361     1.985     0.200
    97.770     1.821     0.200
    98.160     0.687     0.200
    98.408     1.117     0.200
    98.907     0.621     0.200
    99.316     2.508     0.200
    22.679   230.582     0.200
    22.687   230.835     0.200
    23.070   227.765     0.200
    28.613   189.037     0.200
    36.567   142.533     0.200
    51.716    72.814     0.200
    22.736   231.037     0.200
    28.563   190.102     0.200
    36.629   143.606     0.200
    37.986   135.267     0.200
    48.438    85.426     0.200
    49.744    77.518     0.200
    35.429   149.630     0.200
    22.645   231.854     0.200
    36.523   143.761     0.200
    36.523   142.812     0.200
    38.084   135.888     0.200
    22.659   232.407     0.200
    22.654   231.822     0.200
    28.646   189.955     0.200
    36.525   144.339     0.200
    36.579   141.539     0.200
    36.767   141.729     0.200
    36.921   142.483     0.200
    37.080   140.344     0.200
    38.077   135.732     0.200
    39.706   126.336     0.200
    39.777   125.947     0.200
    40.007   125.504     0.200
    40.036   125.865     0.200
    40.610   122.795     0.200
    49.690    77.857     0.200
    51.757    73.279     0.200
    22.614   232.067     0.200
    25.117   218.180     0.200
    26.735   204.948     0.200
    26.991   201.741     0.200
    28.685   190.707     0.200
    33.888   158.760     0.200
    33.984   159.555     0.200
    36.517   143.899     0.200
    36.830   142.116     0.200
    36.952   141.461     0.200
    37.108   141.726     0.200
    38.108   135.910     0.200
    38.766   132.413     0.200
    39.443   129.220     0.200
    39.484   128.293     0.200
    39.734   127.492     0.200
    39.805   127.093     0.200
    40.036   126.159     0.200
    40.064   127.075     0.200
    40.638   123.500     0.200
    42.431   113.586     0.200
    42.626   111.553     0.200
    42.797   113.647     0.200
    43.727   105.441     0.200
    43.905   108.495     0.200
    43.946   107.181     0.200
    44.026   104.918     0.200
    44.063   106.580     0.200
    44.094   106.330     0.200
    44.193   107.040     0.200
    44.249   104.416     0.200
    44.300   105.597     0.200
    47.042    95.843     0.200
    48.559    85.454     0.200
    49.755    81.521     0.200
    51.775    75.174     0.200
    52.128    73.109     0.200
    53.442    67.937     0.200
    56.374    60.724     0.200
    60.439    46.236     0.200
    62.933    39.418     0.200
    63.778    39.227     0.200
    97.114     1.769     0.200
    97.293     2.161     0.200
    97.299     1.723     0.200
    97.339     1.031     0.200
    97.415     1.000     0.200
    97.426     1.932     0.200
    97.514     1.364     0.200
    97.571     1.316     0.200
    98.103     1.439     0.200
    98.515     1.430     0.200
    98.721     1.151     0.200
    98.728     1.007     0.200
    98.848     2.321     0.200
    98.880     1.448     0.200
    98.891     1.192     0.200
    98.928     1.724     0.200
    98.960     1.292     0.200
    99.063     2.460     0.200
    99.286     1.438     0.200
    99.378     1.630     0.200
    22.594   232.369     0.200
    22.642   231.934     0.200
    22.590   231.375     0.200
    22.726   231.188     0.200
    36.639   143.438     0.200
    36.639   143.138     0.200
    37.991   135.399     0.200
    22.604   232.411     0.200
    25.066   216.264     0.200
    28.696   188.743     0.200
    33.827   160.282     0.200
    36.478   143.248     0.200
    36.863   140.814     0.200
    38.780   132.909     0.200
    40.357   124.965     0.200
    40.313   123.705     0.200
    42.177   116.810     0.200
    42.495   114.368     0.200
    43.086   107.633     0.200
    43.165   106.955     0.200
    43.397   105.916     0.200
    43.742   106.635     0.200
    44.080   105.590     0.200
    44.110   105.517     0.200
    44.249   105.956     0.200
    44.266   106.432     0.200
    44.387   106.248     0.200
    49.693    81.411     0.200
    51.609    78.047     0.200
    62.868    42.768     0.200
    97.393     1.210     0.200
    97.495     1.772     0.200
    98.698     1.685     0.200
    98.826     1.419     0.200
    99.338     0.735     0.200
    22.578   232.241     0.200
    28.724   188.479     0.200
    36.425   144.183     0.200
    37.007   140.990     0.200
    37.499   138.564     0.200
    37.734   137.287     0.200
    38.151   134.470     0.200
    38.162   134.439     0.200
    38.904   129.394     0.200
    39.794   125.643     0.200
    39.865   126.166     0.200
    40.095   122.570     0.200
    40.124   124.544     0.200
    40.698   122.095     0.200
    43.198   107.640     0.200
    44.185   104.624     0.200
    48.593    87.211     0.200
    49.638    81.812     0.200
    97.452     0.909     0.200
    98.652     0.453     0.200
    98.789     0.311     0.200
    22.627   231.508     0.200
    22.622   231.458     0.200
    28.679   189.453     0.200
    28.679   189.735     0.200
    33.795   158.828     0.200
    35.328   149.564     0.200
    36.312   144.384     0.200
    36.471   142.803     0.200
    36.471   143.530     0.200
    36.620   141.950     0.200
    36.809   141.815     0.200
    36.961   141.509     0.200
    37.123   139.718     0.200
    38.116   133.505     0.200
    38.749   130.029     0.200
    38.766   130.262     0.200
    38.858   130.026     0.200
    39.456   127.209     0.200
    39.497   126.651     0.200
    39.748   125.935     0.200
    39.818   125.614     0.200
    40.049   124.580     0.200
    40.078   124.917     0.200
    40.277   121.533     0.200
    40.311   128.680     0.200
    40.651   121.582     0.200
    42.544   111.983     0.200
    42.544   111.444     0.200
    44.204   104.156     0.200
    47.714    87.632     0.200
    48.549    84.380     0.200
    51.804    72.352     0.200
    51.804    72.844     0.200
    52.283    70.211     0.200
    97.429     0.965     0.200
    27.034   198.942     0.200
EOF
# Indirect calibration
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
    12.000    -7.500 Indirect calibration: shifted hypocenters used
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
