#!/bin/bash
gmt begin herat11.41_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times herat11.41'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   324.070
    25.500   328.613
    26.000   333.146
    26.500   337.667
    27.000   342.175
    27.500   346.667
    28.000   351.139
    28.500   355.596
    29.000   360.041
    29.500   364.477
    30.000   368.906
    30.500   373.327
    31.000   377.740
    31.500   382.146
    32.000   386.543
    32.500   390.931
    33.000   395.308
    33.500   399.673
    34.000   404.024
    34.500   408.359
    35.000   412.680
    35.500   416.985
    36.000   421.276
    36.500   425.551
    37.000   429.811
    37.500   434.055
    38.000   438.283
    38.500   442.495
    39.000   446.691
    39.500   450.869
    40.000   455.031
    40.500   459.175
    41.000   463.303
    41.500   467.413
    42.000   471.506
    42.500   475.583
    43.000   479.641
    43.500   483.682
    44.000   487.706
    44.500   491.711
    45.000   495.699
    45.500   499.669
    46.000   503.621
    46.500   507.555
    47.000   511.470
    47.500   515.368
    48.000   519.247
    48.500   523.109
    49.000   526.952
    49.500   530.777
    50.000   534.584
    50.500   538.372
    51.000   542.142
    51.500   545.894
    52.000   549.628
    52.500   553.344
    53.000   557.042
    53.500   560.723
    54.000   564.385
    54.500   568.029
    55.000   571.654
    55.500   575.261
    56.000   578.850
    56.500   582.420
    57.000   585.971
    57.500   589.505
    58.000   593.021
    58.500   596.518
    59.000   599.997
    59.500   603.458
    60.000   606.901
    60.500   610.325
    61.000   613.730
    61.500   617.118
    62.000   620.487
    62.500   623.838
    63.000   627.171
    63.500   630.486
    64.000   633.784
    64.500   637.063
    65.000   640.325
    65.500   643.568
    66.000   646.794
    66.500   650.001
    67.000   653.190
    67.500   656.362
    68.000   659.515
    68.500   662.650
    69.000   665.766
    69.500   668.865
    70.000   671.945
    70.500   675.008
    71.000   678.052
    71.500   681.078
    72.000   684.086
    72.500   687.075
    73.000   690.047
    73.500   692.999
    74.000   695.934
    74.500   698.849
    75.000   701.745
    75.500   704.623
    76.000   707.483
    76.500   710.324
    77.000   713.148
    77.500   715.953
    78.000   718.740
    78.500   721.510
    79.000   724.260
    79.500   726.993
    80.000   729.707
    80.500   732.402
    81.000   735.077
    81.500   737.733
    82.000   740.370
    82.500   742.989
    83.000   745.588
    83.500   748.169
    84.000   750.730
    84.500   753.271
    85.000   755.792
    85.500   758.292
    86.000   760.774
    86.500   763.238
    87.000   765.685
    87.500   768.108
    88.000   770.497
    88.500   772.864
    89.000   775.218
    89.500   777.564
    90.000   779.902
    90.500   782.233
    91.000   784.558
    91.500   786.877
    92.000   789.192
    92.500   791.503
    93.000   793.810
    93.500   796.114
    94.000   798.414
    94.500   800.710
    95.000   803.000
    95.500   805.284
    96.000   807.563
    96.500   809.834
    97.000   812.100
    97.500   814.358
    98.000   816.610
    98.500   818.854
    99.000   821.091
    99.500   823.319
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1122.340
   116.000  1123.302
   116.500  1124.264
   117.000  1125.226
   117.500  1126.188
   118.000  1127.150
   118.500  1128.112
   119.000  1129.074
   119.500  1130.035
   120.000  1130.997
   120.500  1131.958
   121.000  1132.918
   121.500  1133.879
   122.000  1134.839
   122.500  1135.799
   123.000  1136.759
   123.500  1137.718
   124.000  1138.676
   124.500  1139.635
   125.000  1140.592
   125.500  1141.549
   126.000  1142.506
   126.500  1143.462
   127.000  1144.417
   127.500  1145.371
   128.000  1146.325
   128.500  1147.278
   129.000  1148.230
   129.500  1149.181
   130.000  1150.130
   130.500  1151.079
   131.000  1152.027
   131.500  1152.973
   132.000  1153.918
   132.500  1154.862
   133.000  1155.804
   133.500  1156.745
   134.000  1157.684
   134.500  1158.621
   135.000  1159.556
   135.500  1160.489
   136.000  1161.420
   136.500  1162.349
   137.000  1163.276
   137.500  1164.200
   138.000  1165.121
   138.500  1166.040
   139.000  1166.955
   139.500  1167.868
   140.000  1168.778
   140.500  1169.684
   141.000  1170.586
   141.500  1171.485
   142.000  1172.380
   142.500  1173.270
   143.000  1174.156
   143.500  1175.037
   144.000  1175.914
   144.500  1176.785
   145.000  1177.650
   145.500  1178.510
   146.000  1179.364
   146.500  1180.212
   147.000  1181.053
   147.500  1181.887
   148.000  1182.714
   148.500  1183.534
   149.000  1184.345
   149.500  1185.148
   150.000  1185.941
   150.500  1186.725
   151.000  1187.498
   151.500  1188.261
   152.000  1189.015
   152.500  1189.758
   153.000  1190.492
   153.500  1191.215
   154.000  1191.927
   154.500  1192.629
   155.000  1193.319
   155.500  1193.998
   156.000  1194.665
   156.500  1195.321
   157.000  1195.965
   157.500  1196.596
   158.000  1197.215
   158.500  1197.822
   159.000  1198.416
   159.500  1198.998
   160.000  1199.566
   160.500  1200.122
   161.000  1200.664
   161.500  1201.193
   162.000  1201.710
   162.500  1202.213
   163.000  1202.702
   163.500  1203.178
   164.000  1203.641
   164.500  1204.089
   165.000  1204.523
   165.500  1204.944
   166.000  1205.351
   166.500  1205.744
   167.000  1206.123
   167.500  1206.489
   168.000  1206.840
   168.500  1207.177
   169.000  1207.500
   169.500  1207.808
   170.000  1208.103
   170.500  1208.383
   171.000  1208.649
   171.500  1208.901
   172.000  1209.139
   172.500  1209.362
   173.000  1209.571
   173.500  1209.766
   174.000  1209.946
   174.500  1210.112
   175.000  1210.263
   175.500  1210.400
   176.000  1210.523
   176.500  1210.631
   177.000  1210.725
   177.500  1210.804
   178.000  1210.869
   178.500  1210.920
   179.000  1210.956
   179.500  1210.978
   180.000  1210.985
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   993.284
     1.000   993.292
     1.500   993.306
     2.000   993.325
     2.500   993.351
     3.000   993.381
     3.500   993.418
     4.000   993.460
     4.500   993.507
     5.000   993.560
     5.500   993.619
     6.000   993.683
     6.500   993.753
     7.000   993.829
     7.500   993.910
     8.000   993.996
     8.500   994.089
     9.000   994.186
     9.500   994.290
    10.000   994.399
    10.500   994.513
    11.000   994.633
    11.500   994.759
    12.000   994.890
    12.500   995.026
    13.000   995.169
    13.500   995.316
    14.000   995.469
    14.500   995.628
    15.000   995.792
    15.500   995.962
    16.000   996.138
    16.500   996.318
    17.000   996.505
    17.500   996.696
    18.000   996.893
    18.500   997.096
    19.000   997.304
    19.500   997.518
    20.000   997.737
    20.500   997.961
    21.000   998.191
    21.500   998.427
    22.000   998.668
    22.500   998.914
    23.000   999.165
    23.500   999.422
    24.000   999.685
    24.500   999.953
    25.000  1000.226
    25.500  1000.504
    26.000  1000.788
    26.500  1001.077
    27.000  1001.371
    27.500  1001.671
    28.000  1001.976
    28.500  1002.287
    29.000  1002.602
    29.500  1002.923
    30.000  1003.250
    30.500  1003.581
    31.000  1003.918
    31.500  1004.260
    32.000  1004.607
    32.500  1004.959
    33.000  1005.317
    33.500  1005.680
    34.000  1006.048
    34.500  1006.421
    35.000  1006.799
    35.500  1007.182
    36.000  1007.571
    36.500  1007.964
    37.000  1008.363
    37.500  1008.767
    38.000  1009.176
    38.500  1009.590
    39.000  1010.009
    39.500  1010.433
    40.000  1010.862
    40.500  1011.296
    41.000  1011.735
    41.500  1012.179
    42.000  1012.627
    42.500  1013.081
    43.000  1013.540
    43.500  1014.004
    44.000  1014.472
    44.500  1014.946
    45.000  1015.424
    45.500  1015.907
    46.000  1016.395
    46.500  1016.888
    47.000  1017.386
    47.500  1017.888
    48.000  1018.395
    48.500  1018.907
    49.000  1019.424
    49.500  1019.945
    50.000  1020.471
    50.500  1021.002
    51.000  1021.537
    51.500  1022.077
    52.000  1022.622
    52.500  1023.171
    53.000  1023.725
    53.500  1024.284
    54.000  1024.847
    54.500  1025.415
    55.000  1025.987
    55.500  1026.563
    56.000  1027.145
    56.500  1027.730
    57.000  1028.320
    57.500  1028.915
    58.000  1029.514
    58.500  1030.117
    59.000  1030.725
    59.500  1031.337
    60.000  1031.953
    60.500  1032.574
    61.000  1033.199
    61.500  1033.828
    62.000  1034.462
    62.500  1035.099
    63.000  1035.741
    63.500  1036.388
    64.000  1037.038
    64.500  1037.693
    65.000  1038.351
    65.500  1039.014
    66.000  1039.681
    66.500  1040.352
    67.000  1041.027
    67.500  1041.706
    68.000  1042.390
    68.500  1043.077
    69.000  1043.768
    69.500  1044.463
    70.000  1045.162
    70.500  1045.865
    71.000  1046.572
    71.500  1047.282
    72.000  1047.997
    72.500  1048.715
    73.000  1049.438
    73.500  1050.164
    74.000  1050.893
    74.500  1051.627
    75.000  1052.364
    75.500  1053.105
    76.000  1053.850
    76.500  1054.598
    77.000  1055.350
    77.500  1056.105
    78.000  1056.864
    78.500  1057.627
    79.000  1058.393
    79.500  1059.163
    80.000  1059.936
    80.500  1060.713
    81.000  1061.493
    81.500  1062.277
    82.000  1063.064
    82.500  1063.854
    83.000  1064.648
    83.500  1065.445
    84.000  1066.245
    84.500  1067.049
    85.000  1067.856
    85.500  1068.667
    86.000  1069.480
    86.500  1070.297
    87.000  1071.116
    87.500  1071.939
    88.000  1072.766
    88.500  1073.595
    89.000  1074.427
    89.500  1075.263
    90.000  1076.101
    90.500  1076.943
    91.000  1077.787
    91.500  1078.635
    92.000  1079.485
    92.500  1080.338
    93.000  1081.195
    93.500  1082.054
    94.000  1082.916
    94.500  1083.781
    95.000  1084.648
    95.500  1085.518
    96.000  1086.392
    96.500  1087.267
    97.000  1088.146
    97.500  1089.027
    98.000  1089.911
    98.500  1090.798
    99.000  1091.687
    99.500  1092.579
   100.000  1093.473
   100.500  1094.370
   101.000  1095.269
   101.500  1096.171
   102.000  1097.076
   102.500  1097.983
   103.000  1098.892
   103.500  1099.803
   104.000  1100.718
   104.500  1101.634
   105.000  1102.552
   105.500  1103.474
   106.000  1104.397
   106.500  1105.322
   107.000  1106.250
   107.500  1107.180
   108.000  1108.112
   108.500  1109.047
   109.000  1109.983
   109.500  1110.922
   110.000  1111.862
   110.500  1112.805
   111.000  1113.750
   111.500  1114.697
   112.000  1115.645
   112.500  1116.596
   113.000  1117.549
   113.500  1118.503
   114.000  1119.460
   114.500  1120.418
   115.000  1121.378
   115.500  1122.340
   116.000  1123.304
   116.500  1124.270
   117.000  1125.237
   117.500  1126.206
   118.000  1127.177
   118.500  1128.149
   119.000  1129.123
   119.500  1130.099
   120.000  1131.076
   120.500  1132.055
   121.000  1133.036
   121.500  1134.018
   122.000  1135.001
   122.500  1135.986
   123.000  1136.973
   123.500  1137.961
   124.000  1138.950
   124.500  1139.941
   125.000  1140.933
   125.500  1141.926
   126.000  1142.921
   126.500  1143.917
   127.000  1144.914
   127.500  1145.913
   128.000  1146.913
   128.500  1147.914
   129.000  1148.916
   129.500  1149.919
   130.000  1150.924
   130.500  1151.929
   131.000  1152.936
   131.500  1153.944
   132.000  1154.952
   132.500  1155.962
   133.000  1156.973
   133.500  1157.985
   134.000  1158.997
   134.500  1160.011
   135.000  1161.026
   135.500  1162.041
   136.000  1163.057
   136.500  1164.074
   137.000  1165.092
   137.500  1166.111
   138.000  1167.130
   138.500  1168.151
   139.000  1169.172
   139.500  1170.193
   140.000  1171.216
   140.500  1172.239
   141.000  1173.262
   141.500  1174.286
   142.000  1175.311
   142.500  1176.336
   143.000  1177.362
   143.500  1178.389
   144.000  1179.416
   144.500  1180.443
   145.000  1181.471
   145.500  1182.499
   146.000  1183.528
   146.500  1184.557
   147.000  1185.587
   147.500  1186.617
   148.000  1187.647
   148.500  1188.677
   149.000  1189.708
   149.500  1190.739
   150.000  1191.770
   150.500  1192.802
   151.000  1193.833
   151.500  1194.865
   152.000  1195.898
   152.500  1196.930
   153.000  1197.962
   153.500  1198.995
   154.000  1200.027
   154.500  1201.059
   155.000  1202.092
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.958
   145.500  1178.780
   146.000  1180.661
   146.500  1182.577
   147.000  1184.522
   147.500  1186.490
   148.000  1188.478
   148.500  1190.484
   149.000  1192.505
   149.500  1194.540
   150.000  1196.588
   150.500  1198.647
   151.000  1200.717
   151.500  1202.797
   152.000  1204.885
   152.500  1206.982
   153.000  1209.087
   153.500  1211.199
   154.000  1213.318
   154.500  1215.443
   155.000  1217.575
   155.500  1219.713
   156.000  1221.855
   156.500  1224.003
   157.000  1226.155
   157.500  1228.312
   158.000  1230.473
   158.500  1232.638
   159.000  1234.808
   159.500  1236.981
   160.000  1239.157
   160.500  1241.336
   161.000  1243.519
   161.500  1245.704
   162.000  1247.892
   162.500  1250.083
   163.000  1252.276
   163.500  1254.472
   164.000  1256.669
   164.500  1258.869
   165.000  1261.070
   165.500  1263.274
   166.000  1265.479
   166.500  1267.685
   167.000  1269.894
   167.500  1272.103
   168.000  1274.314
   168.500  1276.526
   169.000  1278.740
   169.500  1280.954
   170.000  1283.170
   170.500  1285.386
   171.000  1287.603
   171.500  1289.821
   172.000  1292.040
   172.500  1294.259
   173.000  1296.479
   173.500  1298.700
   174.000  1300.921
   174.500  1303.142
   175.000  1305.364
   175.500  1307.586
   176.000  1309.808
   176.500  1312.031
   177.000  1314.254
   177.500  1316.476
   178.000  1318.699
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.956
   145.500  1178.583
   146.000  1180.130
   146.500  1181.620
   147.000  1183.060
   147.500  1184.454
   148.000  1185.807
   148.500  1187.119
   149.000  1188.396
   149.500  1189.645
   150.000  1190.868
   150.500  1192.069
   151.000  1193.249
   151.500  1194.410
   152.000  1195.552
   152.500  1196.677
   153.000  1197.786
   153.500  1198.880
   154.000  1199.961
   154.500  1201.030
   155.000  1202.084
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   510.159
     1.000   510.195
     1.500   510.255
     2.000   510.339
     2.500   510.447
     3.000   510.579
     3.500   510.735
     4.000   510.915
     4.500   511.118
     5.000   511.346
     5.500   511.597
     6.000   511.872
     6.500   512.171
     7.000   512.493
     7.500   512.839
     8.000   513.208
     8.500   513.601
     9.000   514.017
     9.500   514.457
    10.000   514.919
    10.500   515.405
    11.000   515.914
    11.500   516.445
    12.000   517.000
    12.500   517.577
    13.000   518.177
    13.500   518.799
    14.000   519.444
    14.500   520.111
    15.000   520.800
    15.500   521.511
    16.000   522.244
    16.500   522.998
    17.000   523.775
    17.500   524.573
    18.000   525.392
    18.500   526.232
    19.000   527.094
    19.500   527.976
    20.000   528.879
    20.500   529.803
    21.000   530.747
    21.500   531.712
    22.000   532.697
    22.500   533.701
    23.000   534.726
    23.500   535.770
    24.000   536.834
    24.500   537.917
    25.000   539.019
    25.500   540.140
    26.000   541.280
    26.500   542.438
    27.000   543.615
    27.500   544.810
    28.000   546.023
    28.500   547.255
    29.000   548.504
    29.500   549.770
    30.000   551.054
    30.500   552.355
    31.000   553.673
    31.500   555.008
    32.000   556.359
    32.500   557.727
    33.000   559.111
    33.500   560.511
    34.000   561.927
    34.500   563.359
    35.000   564.807
    35.500   566.269
    36.000   567.747
    36.500   569.240
    37.000   570.747
    37.500   572.269
    38.000   573.806
    38.500   575.356
    39.000   576.921
    39.500   578.499
    40.000   580.092
    40.500   581.697
    41.000   583.316
    41.500   584.948
    42.000   586.593
    42.500   588.251
    43.000   589.921
    43.500   591.603
    44.000   593.298
    44.500   595.005
    45.000   596.724
    45.500   598.454
    46.000   600.196
    46.500   601.949
    47.000   603.713
    47.500   605.488
    48.000   607.274
    48.500   609.071
    49.000   610.878
    49.500   612.695
    50.000   614.523
    50.500   616.360
    51.000   618.208
    51.500   620.065
    52.000   621.931
    52.500   623.807
    53.000   625.691
    53.500   627.585
    54.000   629.488
    54.500   631.399
    55.000   633.319
    55.500   635.247
    56.000   637.184
    56.500   639.128
    57.000   641.080
    57.500   643.041
    58.000   645.008
    58.500   646.984
    59.000   648.966
    59.500   650.956
    60.000   652.953
    60.500   654.956
    61.000   656.967
    61.500   658.984
    62.000   661.008
    62.500   663.038
    63.000   665.074
    63.500   667.116
    64.000   669.164
    64.500   671.219
    65.000   673.278
    65.500   675.344
    66.000   677.415
    66.500   679.491
    67.000   681.572
    67.500   683.659
    68.000   685.750
    68.500   687.847
    69.000   689.948
    69.500   692.054
    70.000   694.164
    70.500   696.279
    71.000   698.398
    71.500   700.521
    72.000   702.648
    72.500   704.779
    73.000   706.914
    73.500   709.053
    74.000   711.196
    74.500   713.342
    75.000   715.491
    75.500   717.644
    76.000   719.800
    76.500   721.959
    77.000   724.122
    77.500   726.287
    78.000   728.455
    78.500   730.626
    79.000   732.800
    79.500   734.976
    80.000   737.155
    80.500   739.336
    81.000   741.520
    81.500   743.706
    82.000   745.894
    82.500   748.085
    83.000   750.277
    83.500   752.471
    84.000   754.667
    84.500   756.865
    85.000   759.065
    85.500   761.266
    86.000   763.469
    86.500   765.674
    87.000   767.880
    87.500   770.087
    88.000   772.296
    88.500   774.506
    89.000   776.717
    89.500   778.929
    90.000   781.142
    90.500   783.356
    91.000   785.572
    91.500   787.788
    92.000   790.005
    92.500   792.222
    93.000   794.441
    93.500   796.660
    94.000   798.879
    94.500   801.099
    95.000   803.320
    95.500   805.541
    96.000   807.763
    96.500   809.984
    97.000   812.206
    97.500   814.429
    98.000   816.651
    98.500   818.874
    99.000   821.097
    99.500   823.320
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.888
    29.000   425.445
    29.500   431.002
    30.000   436.558
    30.500   442.113
    31.000   447.667
    31.500   453.219
    32.000   458.769
    32.500   464.316
    33.000   469.861
    33.500   475.402
    34.000   480.940
    34.500   486.473
    35.000   492.002
    35.500   497.526
    36.000   503.044
    36.500   508.556
    37.000   514.062
    37.500   519.560
    38.000   525.051
    38.500   530.533
    39.000   536.007
    39.500   541.471
    40.000   546.926
    40.500   552.369
    41.000   557.802
    41.500   563.223
    42.000   568.631
    42.500   574.027
    43.000   579.409
    43.500   584.778
    44.000   590.132
    44.500   595.471
    45.000   600.796
    45.500   606.104
    46.000   611.396
    46.500   616.672
    47.000   621.930
    47.500   626.691
    48.000   631.261
    48.500   635.828
    49.000   640.389
    49.500   644.946
    50.000   649.497
    50.500   654.044
    51.000   658.585
    51.500   663.120
    52.000   667.650
    52.500   672.175
    53.000   676.693
    53.500   681.206
    54.000   685.711
    54.500   690.208
    55.000   694.697
    55.500   699.175
    56.000   703.643
    56.500   708.103
    57.000   712.557
    57.500   717.005
    58.000   721.449
    58.500   725.888
    59.000   730.322
    59.500   734.753
    60.000   739.180
    60.500   743.603
    61.000   748.023
    61.500   752.438
    62.000   756.850
    62.500   761.258
    63.000   765.661
    63.500   770.061
    64.000   774.457
    64.500   778.847
    65.000   783.233
    65.500   787.614
    66.000   791.989
    66.500   796.357
    67.000   800.719
    67.500   805.074
    68.000   809.422
    68.500   813.762
    69.000   818.094
    69.500   822.419
    70.000   826.737
    70.500   831.047
    71.000   835.349
    71.500   839.644
    72.000   843.931
    72.500   848.211
    73.000   852.483
    73.500   856.747
    74.000   861.004
    74.500   865.253
    75.000   869.493
    75.500   873.726
    76.000   877.951
    76.500   882.168
    77.000   886.376
    77.500   890.577
    78.000   894.769
    78.500   898.952
    79.000   903.127
    79.500   907.294
    80.000   911.452
    80.500   915.601
    81.000   919.742
    81.500   923.874
    82.000   927.998
    82.500   932.113
    83.000   936.220
    83.500   940.318
    84.000   944.408
    84.500   948.489
    85.000   952.562
    85.500   956.625
    86.000   960.680
    86.500   964.726
    87.000   968.764
    87.500   972.792
    88.000   976.812
    88.500   980.823
    89.000   984.824
    89.500   988.817
    90.000   992.801
    90.500   996.776
    91.000  1000.742
    91.500  1004.699
    92.000  1008.647
    92.500  1012.586
    93.000  1016.516
    93.500  1020.437
    94.000  1024.349
    94.500  1028.252
    95.000  1032.145
    95.500  1036.030
    96.000  1039.906
    96.500  1043.772
    97.000  1047.630
    97.500  1051.478
    98.000  1055.318
    98.500  1059.148
    99.000  1062.969
    99.500  1066.781
   100.000  1070.584
   100.500  1074.377
   101.000  1078.162
   101.500  1081.937
   102.000  1085.703
   102.500  1089.460
   103.000  1093.208
   103.500  1096.947
   104.000  1100.677
   104.500  1104.398
   105.000  1108.110
   105.500  1111.814
   106.000  1115.508
   106.500  1119.193
   107.000  1122.870
   107.500  1126.537
   108.000  1130.196
   108.500  1133.845
   109.000  1137.485
   109.500  1141.116
   110.000  1144.737
   110.500  1148.349
   111.000  1151.952
   111.500  1155.546
   112.000  1159.130
   112.500  1162.705
   113.000  1166.271
   113.500  1169.828
   114.000  1173.376
   114.500  1176.915
   115.000  1180.444
   115.500  1183.965
   116.000  1187.476
   116.500  1190.979
   117.000  1194.472
   117.500  1197.957
   118.000  1201.432
   118.500  1204.898
   119.000  1208.355
   119.500  1211.803
   120.000  1215.241
   120.500  1218.671
   121.000  1222.091
   121.500  1225.502
   122.000  1228.903
   122.500  1232.296
   123.000  1235.679
   123.500  1239.053
   124.000  1242.418
   124.500  1245.774
   125.000  1249.121
   125.500  1252.460
   126.000  1255.789
   126.500  1259.109
   127.000  1262.420
   127.500  1265.722
   128.000  1269.016
   128.500  1272.300
   129.000  1275.576
   129.500  1278.842
   130.000  1282.100
   130.500  1285.348
   131.000  1288.588
   131.500  1291.818
   132.000  1295.040
   132.500  1298.252
   133.000  1301.456
   133.500  1304.650
   134.000  1307.836
   134.500  1311.012
   135.000  1314.179
   135.500  1317.337
   136.000  1320.486
   136.500  1323.626
   137.000  1326.757
   137.500  1329.879
   138.000  1332.992
   138.500  1336.095
   139.000  1339.190
   139.500  1342.275
   140.000  1345.352
   140.500  1348.419
   141.000  1351.477
   141.500  1354.526
   142.000  1357.567
   142.500  1360.598
   143.000  1363.620
   143.500  1366.632
   144.000  1369.636
   144.500  1372.631
   145.000  1375.617
   145.500  1378.593
   146.000  1381.560
   146.500  1384.518
   147.000  1387.467
   147.500  1390.406
   148.000  1393.336
   148.500  1396.256
   149.000  1399.167
   149.500  1402.069
   150.000  1404.961
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.542
   100.500   827.765
   101.000   829.988
   101.500   832.211
   102.000   834.434
   102.500   836.657
   103.000   838.879
   103.500   841.102
   104.000   843.325
   104.500   845.548
   105.000   847.771
   105.500   849.994
   106.000   852.216
   106.500   854.439
   107.000   856.662
   107.500   858.885
   108.000   861.108
   108.500   863.331
   109.000   865.553
   109.500   867.776
   110.000   869.999
   110.500   872.222
   111.000   874.445
   111.500   876.668
   112.000   878.890
   112.500   881.113
   113.000   883.336
   113.500   885.559
   114.000   887.782
   114.500   890.005
   115.000   892.227
   115.500   894.450
   116.000   896.673
   116.500   898.896
   117.000   901.119
   117.500   903.342
   118.000   905.564
   118.500   907.787
   119.000   910.010
   119.500   912.233
   120.000   914.456
   120.500   916.679
   121.000   918.901
   121.500   921.124
   122.000   923.347
   122.500   925.570
   123.000   927.793
   123.500   930.016
   124.000   932.238
   124.500   934.461
   125.000   936.684
   125.500   938.907
   126.000   941.130
   126.500   943.353
   127.000   945.575
   127.500   947.798
   128.000   950.021
   128.500   952.244
   129.000   954.467
   129.500   956.690
   130.000   958.912
   130.500   961.135
   131.000   963.358
   131.500   965.581
   132.000   967.804
   132.500   970.027
   133.000   972.250
   133.500   974.472
   134.000   976.695
   134.500   978.918
   135.000   981.141
   135.500   983.364
   136.000   985.586
   136.500   987.809
   137.000   990.032
   137.500   992.255
   138.000   994.478
   138.500   996.701
   139.000   998.923
   139.500  1001.146
   140.000  1003.369
   140.500  1005.592
   141.000  1007.815
   141.500  1010.038
   142.000  1012.260
   142.500  1014.483
   143.000  1016.706
   143.500  1018.929
   144.000  1021.152
   144.500  1023.375
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.962
    15.000   396.201
    15.500   406.436
    16.000   416.664
    16.500   426.882
    17.000   437.086
    17.500   447.271
    18.000   457.434
    18.500   467.569
    19.000   477.670
    19.500   487.732
    20.000   497.748
    20.500   507.713
    21.000   517.621
    21.500   527.466
    22.000   537.243
    22.500   546.947
    23.000   555.656
    23.500   563.799
    24.000   571.910
    24.500   579.987
    25.000   588.021
    25.500   595.976
    26.000   603.888
    26.500   611.788
    27.000   619.679
    27.500   627.564
    28.000   635.441
    28.500   643.311
    29.000   651.175
    29.500   659.033
    30.000   666.883
    30.500   674.725
    31.000   682.557
    31.500   690.378
    32.000   698.186
    32.500   705.980
    33.000   713.759
    33.500   721.521
    34.000   729.265
    34.500   736.991
    35.000   744.698
    35.500   752.385
    36.000   760.052
    36.500   767.700
    37.000   775.327
    37.500   782.934
    38.000   790.519
    38.500   798.083
    39.000   805.625
    39.500   813.144
    40.000   820.641
    40.500   828.114
    41.000   835.564
    41.500   842.990
    42.000   850.393
    42.500   857.771
    43.000   865.125
    43.500   872.454
    44.000   879.759
    44.500   887.039
    45.000   894.293
    45.500   901.523
    46.000   908.726
    46.500   915.904
    47.000   923.056
    47.500   930.181
    48.000   937.280
    48.500   944.352
    49.000   951.397
    49.500   958.415
    50.000   965.406
    50.500   972.369
    51.000   979.306
    51.500   986.215
    52.000   993.097
    52.500   999.950
    53.000  1006.777
    53.500  1013.578
    54.000  1020.352
    54.500  1027.101
    55.000  1033.823
    55.500  1040.517
    56.000  1047.185
    56.500  1053.824
    57.000  1060.436
    57.500  1067.019
    58.000  1073.574
    58.500  1080.101
    59.000  1086.601
    59.500  1093.073
    60.000  1099.518
    60.500  1105.934
    61.000  1112.323
    61.500  1118.684
    62.000  1125.017
    62.500  1131.321
    63.000  1137.597
    63.500  1143.844
    64.000  1150.062
    64.500  1156.253
    65.000  1162.415
    65.500  1168.549
    66.000  1174.655
    66.500  1180.732
    67.000  1186.781
    67.500  1192.802
    68.000  1198.793
    68.500  1204.757
    69.000  1210.692
    69.500  1216.598
    70.000  1222.475
    70.500  1228.323
    71.000  1234.143
    71.500  1239.934
    72.000  1245.696
    72.500  1251.428
    73.000  1257.131
    73.500  1262.804
    74.000  1268.446
    74.500  1274.059
    75.000  1279.642
    75.500  1285.195
    76.000  1290.719
    76.500  1296.214
    77.000  1301.679
    77.500  1307.115
    78.000  1312.519
    78.500  1317.894
    79.000  1323.238
    79.500  1328.553
    80.000  1333.839
    80.500  1339.095
    81.000  1344.321
    81.500  1349.516
    82.000  1354.679
    82.500  1359.811
    83.000  1364.910
    83.500  1369.978
    84.000  1375.015
    84.500  1380.021
    85.000  1384.995
    85.500  1389.939
    86.000  1394.850
    86.500  1399.730
    87.000  1404.577
    87.500  1409.392
    88.000  1414.174
    88.500  1418.923
    89.000  1423.639
    89.500  1428.321
    90.000  1432.969
    90.500  1437.584
    91.000  1442.164
    91.500  1446.712
    92.000  1451.225
    92.500  1455.704
    93.000  1460.149
    93.500  1464.561
    94.000  1468.946
    94.500  1473.314
    95.000  1477.669
    95.500  1482.012
    96.000  1486.344
    96.500  1490.663
    97.000  1494.965
    97.500  1499.248
    98.000  1503.510
    98.500  1507.752
    99.000  1511.975
    99.500  1516.178
   100.000  1520.359
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   721.167
     1.000   721.214
     1.500   721.292
     2.000   721.400
     2.500   721.540
     3.000   721.712
     3.500   721.914
     4.000   722.147
     4.500   722.411
     5.000   722.705
     5.500   723.031
     6.000   723.387
     6.500   723.774
     7.000   724.191
     7.500   724.639
     8.000   725.117
     8.500   725.625
     9.000   726.163
     9.500   726.731
    10.000   727.329
    10.500   727.957
    11.000   728.614
    11.500   729.300
    12.000   730.016
    12.500   730.760
    13.000   731.534
    13.500   732.336
    14.000   733.166
    14.500   734.025
    15.000   734.911
    15.500   735.826
    16.000   736.768
    16.500   737.738
    17.000   738.735
    17.500   739.759
    18.000   740.809
    18.500   741.887
    19.000   742.990
    19.500   744.119
    20.000   745.274
    20.500   746.455
    21.000   747.661
    21.500   748.892
    22.000   750.148
    22.500   751.428
    23.000   752.732
    23.500   754.060
    24.000   755.411
    24.500   756.786
    25.000   758.184
    25.500   759.605
    26.000   761.048
    26.500   762.513
    27.000   764.000
    27.500   765.509
    28.000   767.039
    28.500   768.589
    29.000   770.161
    29.500   771.752
    30.000   773.364
    30.500   774.995
    31.000   776.645
    31.500   778.314
    32.000   780.002
    32.500   781.709
    33.000   783.433
    33.500   785.175
    34.000   786.935
    34.500   788.711
    35.000   790.504
    35.500   792.313
    36.000   794.139
    36.500   795.980
    37.000   797.836
    37.500   799.708
    38.000   801.594
    38.500   803.494
    39.000   805.408
    39.500   807.337
    40.000   809.278
    40.500   811.232
    41.000   813.199
    41.500   815.179
    42.000   817.170
    42.500   819.173
    43.000   821.188
    43.500   823.213
    44.000   825.249
    44.500   827.295
    45.000   829.352
    45.500   831.418
    46.000   833.493
    46.500   835.578
    47.000   837.671
    47.500   839.772
    48.000   841.882
    48.500   844.000
    49.000   846.124
    49.500   848.256
    50.000   850.395
    50.500   852.541
    51.000   854.693
    51.500   856.850
    52.000   859.013
    52.500   861.182
    53.000   863.356
    53.500   865.534
    54.000   867.717
    54.500   869.905
    55.000   872.096
    55.500   874.291
    56.000   876.489
    56.500   878.691
    57.000   880.896
    57.500   883.103
    58.000   885.313
    58.500   887.525
    59.000   889.739
    59.500   891.955
    60.000   894.172
    60.500   896.391
    61.000   898.611
    61.500   900.832
    62.000   903.053
    62.500   905.276
    63.000   907.498
    63.500   909.721
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   933.221
     1.000   933.288
     1.500   933.398
     2.000   933.553
     2.500   933.752
     3.000   933.996
     3.500   934.283
     4.000   934.615
     4.500   934.990
     5.000   935.410
     5.500   935.873
     6.000   936.381
     6.500   936.932
     7.000   937.526
     7.500   938.164
     8.000   938.845
     8.500   939.570
     9.000   940.337
     9.500   941.148
    10.000   942.001
    10.500   942.897
    11.000   943.836
    11.500   944.816
    12.000   945.839
    12.500   946.904
    13.000   948.011
    13.500   949.159
    14.000   950.348
    14.500   951.578
    15.000   952.850
    15.500   954.162
    16.000   955.515
    16.500   956.907
    17.000   958.340
    17.500   959.813
    18.000   961.325
    18.500   962.876
    19.000   964.466
    19.500   966.095
    20.000   967.762
    20.500   969.467
    21.000   971.211
    21.500   972.991
    22.000   974.809
    22.500   976.664
    23.000   978.556
    23.500   980.484
    24.000   982.448
    24.500   984.449
    25.000   986.484
    25.500   988.555
    26.000   990.660
    26.500   992.800
    27.000   994.975
    27.500   997.183
    28.000   999.425
    28.500  1001.700
    29.000  1004.008
    29.500  1006.348
    30.000  1008.721
    30.500  1011.126
    31.000  1013.562
    31.500  1016.030
    32.000  1018.528
    32.500  1021.057
    33.000  1023.617
    33.500  1026.206
    34.000  1028.825
    34.500  1031.473
    35.000  1034.150
    35.500  1036.856
    36.000  1039.589
    36.500  1042.351
    37.000  1045.141
    37.500  1047.957
    38.000  1050.801
    38.500  1053.671
    39.000  1056.567
    39.500  1059.489
    40.000  1062.436
    40.500  1065.409
    41.000  1068.407
    41.500  1071.429
    42.000  1074.476
    42.500  1077.546
    43.000  1080.640
    43.500  1083.758
    44.000  1086.898
    44.500  1090.061
    45.000  1093.246
    45.500  1096.453
    46.000  1099.682
    46.500  1102.932
    47.000  1106.203
    47.500  1109.495
    48.000  1112.807
    48.500  1116.139
    49.000  1119.491
    49.500  1122.863
    50.000  1126.253
    50.500  1129.663
    51.000  1133.091
    51.500  1136.538
    52.000  1140.002
    52.500  1143.484
    53.000  1146.984
    53.500  1150.501
    54.000  1154.034
    54.500  1157.584
    55.000  1161.151
    55.500  1164.733
    56.000  1168.331
    56.500  1171.945
    57.000  1175.574
    57.500  1179.217
    58.000  1182.876
    58.500  1186.548
    59.000  1190.235
    59.500  1193.936
    60.000  1197.650
    60.500  1201.378
    61.000  1205.119
    61.500  1208.872
    62.000  1212.638
    62.500  1216.417
    63.000  1220.208
    63.500  1224.010
    64.000  1227.824
    64.500  1231.650
    65.000  1235.487
    65.500  1239.335
    66.000  1243.193
    66.500  1247.062
    67.000  1250.941
    67.500  1254.830
    68.000  1258.729
    68.500  1262.638
    69.000  1266.556
    69.500  1270.483
    70.000  1274.420
    70.500  1278.365
    71.000  1282.318
    71.500  1286.280
    72.000  1290.250
    72.500  1294.228
    73.000  1298.214
    73.500  1302.207
    74.000  1306.208
    74.500  1310.216
    75.000  1314.231
    75.500  1318.252
    76.000  1322.281
    76.500  1326.316
    77.000  1330.357
    77.500  1334.404
    78.000  1338.457
    78.500  1342.516
    79.000  1346.580
    79.500  1350.650
    80.000  1354.725
    80.500  1358.805
    81.000  1362.891
    81.500  1366.980
    82.000  1371.075
    82.500  1375.174
    83.000  1379.277
    83.500  1383.384
    84.000  1387.496
    84.500  1391.611
    85.000  1395.730
    85.500  1399.852
    86.000  1403.978
    86.500  1408.107
    87.000  1412.239
    87.500  1416.374
    88.000  1420.512
    88.500  1424.653
    89.000  1428.796
    89.500  1432.942
    90.000  1437.090
    90.500  1441.241
    91.000  1445.393
    91.500  1449.547
    92.000  1453.704
    92.500  1457.862
    93.000  1462.021
    93.500  1466.182
    94.000  1470.344
    94.500  1474.508
    95.000  1478.673
    95.500  1482.839
    96.000  1487.005
    96.500  1491.173
    97.000  1495.341
    97.500  1499.510
    98.000  1503.679
    98.500  1507.849
    99.000  1512.019
    99.500  1516.189
   100.000  1520.359
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.917
    29.500   784.156
    30.000   794.394
    30.500   804.631
    31.000   814.865
    31.500   825.095
    32.000   835.322
    32.500   845.543
    33.000   855.759
    33.500   865.968
    34.000   876.169
    34.500   886.361
    35.000   896.543
    35.500   906.714
    36.000   916.872
    36.500   927.016
    37.000   937.145
    37.500   947.258
    38.000   957.352
    38.500   967.038
    39.000   977.482
    39.500   987.513
    40.000   997.521
    40.500  1007.502
    41.000  1017.457
    41.500  1027.383
    42.000  1037.280
    42.500  1047.145
    43.000  1056.978
    43.500  1066.776
    44.000  1076.540
    44.500  1086.268
    45.000  1095.958
    45.500  1105.368
    46.000  1113.539
    46.500  1121.692
    47.000  1129.828
    47.500  1137.949
    48.000  1146.052
    48.500  1154.140
    49.000  1162.209
    49.500  1170.259
    50.000  1178.282
    50.500  1186.269
    51.000  1194.200
    51.500  1202.117
    52.000  1210.026
    52.500  1217.929
    53.000  1225.827
    53.500  1233.721
    54.000  1241.611
    54.500  1249.497
    55.000  1257.380
    55.500  1265.259
    56.000  1273.135
    56.500  1281.007
    57.000  1288.877
    57.500  1296.743
    58.000  1304.605
    58.500  1312.465
    59.000  1320.320
    59.500  1328.173
    60.000  1336.021
    60.500  1343.866
    61.000  1351.706
    61.500  1359.541
    62.000  1367.371
    62.500  1375.196
    63.000  1383.014
    63.500  1390.826
    64.000  1398.632
    64.500  1406.431
    65.000  1414.222
    65.500  1422.006
    66.000  1429.781
    66.500  1437.548
    67.000  1445.306
    67.500  1453.056
    68.000  1460.796
    68.500  1468.528
    69.000  1476.250
    69.500  1483.962
    70.000  1491.664
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     1.414    46.068     0.150
     4.462    82.943     0.150
     4.984    62.438     0.150
     5.906    88.467     0.150
     5.906    88.467     0.150
    46.885   101.088     0.150
     7.137   103.867     0.150
     7.137   103.568     0.150
     8.922   127.768     0.150
     9.269   132.768     0.150
     9.476   137.178     0.150
     9.748   138.268     0.150
    10.009   141.367     0.150
    10.403   143.947     0.150
    10.403   143.867     0.150
    10.655   149.867     0.150
    10.779   152.867     0.150
    10.779   152.268     0.150
    10.860   155.973     0.150
    10.860   155.957     0.150
    10.992   154.568     0.150
    11.979   302.094     0.150
    12.664   177.328     0.150
    12.664   177.367     0.150
    12.664   177.287     0.150
    12.664   177.547     0.150
    13.236   184.418     0.150
    13.196   191.668     0.150
    13.482   189.068     0.150
    13.743   193.023     0.150
    13.743   196.279     0.150
    13.929   356.168     0.150
    14.114   196.508     0.150
    14.316   369.137     0.150
    14.349   370.098     0.150
    14.362   200.467     0.150
    14.399   202.367     0.150
    14.527   201.588     0.150
    14.527   201.568     0.150
    14.527   366.467     0.150
    14.657   209.010     0.150
    14.657   373.777     0.150
    14.657   368.467     0.150
    14.679   211.463     0.150
    14.679   218.688     0.150
    15.082   211.947     0.150
    15.344   212.268     0.150
    15.344   386.668     0.150
    15.446   215.578     0.150
    15.652   391.049     0.150
    15.715   216.967     0.150
    15.786   218.068     0.150
    15.786   398.168     0.150
    16.018   226.238     0.150
    16.018   406.887     0.150
    16.018   399.367     0.150
    16.360   225.768     0.150
    16.360   409.867     0.150
    16.169   223.867     0.150
    16.708   231.568     0.150
    16.692   232.168     0.150
    17.239   236.068     0.150
    17.312   241.467     0.150
    17.485   242.018     0.150
    17.485   242.068     0.150
    17.485   241.938     0.150
    17.485   242.488     0.150
    17.506   245.258     0.150
    18.086   249.367     0.150
    18.086   249.879     0.150
    18.086   249.463     0.150
    18.086   253.277     0.150
    19.337   263.668     0.150
    19.326   485.768     0.150
    19.335   268.018     0.150
    19.407   264.367     0.150
    19.407   264.467     0.150
    19.407   264.248     0.150
    19.584   267.068     0.150
    20.144   273.838     0.150
    20.144   273.264     0.150
    20.144   274.088     0.150
    20.481   277.488     0.150
    20.455   506.242     0.150
    20.670   277.568     0.150
    20.670   509.367     0.150
    21.122   283.367     0.150
    21.437   288.287     0.150
    21.919   287.367     0.150
    21.919    10.600     0.150
    21.919   537.068     0.150
    21.863   293.361     0.150
    21.863   293.268     0.150
    21.863   568.768     0.150
    21.863   293.537     0.150
    21.863   293.307     0.150
    21.863     4.871     0.150
    22.728     4.281     0.150
    22.993   305.467     0.150
    23.014   304.967     0.150
    23.014   305.068     0.150
    23.303   309.197     0.150
    23.303   309.193     0.150
    23.313   561.668     0.150
    23.417   309.668     0.150
    27.726   312.578     0.150
    27.726   570.098     0.150
    23.673   312.359     0.150
    25.128   324.568     0.150
    25.129  8506.768     0.150
    25.214   596.367     0.150
    25.214   649.967     0.150
    25.214   325.568     0.150
    25.988   333.568     0.150
    45.275   335.887     0.150
    26.282   334.508     0.150
    26.811     4.000     0.150
    26.886   387.467     0.150
    26.941   617.768     0.150
    26.941   342.348     0.150
    26.941   342.215     0.150
    26.941   342.037     0.150
    26.941   341.568     0.150
    26.941   342.262     0.150
    26.941   342.248     0.150
    27.280   345.439     0.150
    27.433   347.197     0.150
    27.472   345.848     0.150
    27.472   345.857     0.150
    27.750   349.615     0.150
    27.810   350.494     0.150
   106.270   349.729     0.150
    28.283   354.449     0.150
    28.572   356.268     0.150
    28.572   356.268     0.150
    28.579   356.168     0.150
    28.649   357.307     0.150
    28.848   360.383     0.150
    28.852   360.824     0.150
    28.899   361.264     0.150
    28.919   359.723     0.150
    26.531   361.188     0.150
    29.405   363.078     0.150
    29.326   365.168     0.150
    29.326   365.154     0.150
    29.519   665.527     0.150
    29.449   363.668     0.150
    84.126   364.967     0.150
    29.899   368.768     0.150
    29.903   369.629     0.150
    29.941   369.689     0.150
    30.210   370.807     0.150
    30.206   371.812     0.150
    30.222   372.033     0.150
    30.268   371.715     0.150
    30.450     5.000     0.150
    30.512   374.346     0.150
    30.719   376.268     0.150
    30.884   376.807     0.150
    30.884   376.807     0.150
    30.884   445.137     0.150
    30.884   779.777     0.150
    30.884   794.717     0.150
    30.884   376.768     0.150
    30.884   436.168     0.150
    30.884   680.568     0.150
    30.884   779.768     0.150
    31.023   378.668     0.150
    31.023   379.967     0.150
    31.023   379.945     0.150
    31.129   380.865     0.150
    31.254   380.498     0.150
    31.151   380.604     0.150
    31.359   382.469     0.150
    31.373   378.758     0.150
    31.492   383.461     0.150
    31.525   383.461     0.150
    31.586   381.967     0.150
    31.744   386.098     0.150
    32.299   389.268     0.150
    32.299   385.590     0.150
    32.299     0.932     0.150
    32.299   391.787     0.150
    32.263   390.467     0.150
    32.294   387.627     0.150
    32.359   390.850     0.150
    32.397   391.467     0.150
    32.397   391.465     0.150
    32.688   708.768     0.150
    33.043     4.500     0.150
    33.153   397.803     0.150
    33.210   394.158     0.150
    33.210   395.168     0.150
    33.484   401.158     0.150
    33.523   399.818     0.150
    33.688   399.838     0.150
    33.759   404.568     0.150
    33.795   402.768     0.150
    33.851   402.168     0.150
    33.945   402.898     0.150
    33.945   402.867     0.150
    33.961   405.268     0.150
    34.056     6.400     0.150
    34.056   722.867     0.150
    34.252   407.727     0.150
    34.327   408.018     0.150
    34.327   408.268     0.150
    34.327   404.916     0.150
    34.327   408.307     0.150
    34.840   414.467     0.150
    34.840   414.463     0.150
    35.086   750.967     0.150
    35.209   415.268     0.150
    35.474   416.768     0.150
    35.442   417.428     0.150
    35.504   419.150     0.150
    39.183   417.928     0.150
    35.587   418.867     0.150
    35.587   418.736     0.150
    35.587   418.846     0.150
    35.589   418.967     0.150
    35.589   418.984     0.150
    35.918   420.668     0.150
    35.918   421.248     0.150
    35.956   419.898     0.150
    36.008   421.828     0.150
    36.116   423.168     0.150
    36.141   423.549     0.150
    36.141   423.338     0.150
    36.242   424.168     0.150
    36.307   424.367     0.150
    36.462     3.400     0.150
    36.446   426.668     0.150
    36.625   425.877     0.150
    36.625   425.867     0.150
    36.534   427.768     0.150
    36.541   426.967     0.150
    36.647   428.367     0.150
    36.663   945.357     0.150
    36.663   428.367     0.150
    36.739   427.707     0.150
    36.739   427.748     0.150
    36.739   428.088     0.150
    36.791   918.068     0.150
    36.824   427.967     0.150
    37.322   433.441     0.150
    37.540   434.068     0.150
    37.540   435.268     0.150
    37.562   434.873     0.150
    37.580   433.568     0.150
    37.591   435.467     0.150
    37.618   435.967     0.150
    37.862   437.268     0.150
    38.076   527.367     0.150
    38.076   806.668     0.150
    38.015   437.268     0.150
    38.015   437.320     0.150
    38.093   439.068     0.150
    38.278   441.527     0.150
    38.278   440.867     0.150
    38.399   441.607     0.150
    38.563     5.381     0.150
    38.553   442.867     0.150
    38.588   443.867     0.150
    38.651   444.268     0.150
    38.651   549.568     0.150
    38.651   559.768     0.150
    38.651   802.768     0.150
    38.651   802.768     0.150
    38.651   444.348     0.150
    38.910   445.863     0.150
    39.018   446.758     0.150
    39.334     4.301     0.150
    39.334   449.568     0.150
    39.410   450.121     0.150
    39.578   451.867     0.150
    39.578   451.209     0.150
    39.641   452.967     0.150
    39.672   451.848     0.150
    39.996   455.297     0.150
    39.996   454.707     0.150
    39.996   455.338     0.150
    40.239   821.367     0.150
    40.335   457.730     0.150
    40.447   457.467     0.150
    40.447   576.168     0.150
    40.447   586.668     0.150
    40.524   459.205     0.150
    40.567   458.885     0.150
    40.578   460.967     0.150
    40.578   459.066     0.150
   124.260   461.367     0.150
   124.260   460.857     0.150
    40.916   462.457     0.150
    40.968   462.467     0.150
    62.929   464.238     0.150
    41.017   463.107     0.150
    41.271     5.301     0.150
    41.271   844.168     0.150
    41.271  1012.268     0.150
    41.258   465.287     0.150
    41.452   466.467     0.150
    41.470   468.367     0.150
    41.470   466.699     0.150
    41.497   467.168     0.150
    41.513   466.768     0.150
    41.513   847.689     0.150
    22.977   468.697     0.150
    41.547   472.674     0.150
    41.548   467.568     0.150
    41.548   467.588     0.150
    41.573   469.168     0.150
    41.948   471.197     0.150
    42.245   473.314     0.150
    42.333   473.957     0.150
    42.333   473.967     0.150
    42.333   474.168     0.150
    42.333   474.217     0.150
    42.333   473.967     0.150
    42.427   475.418     0.150
    42.352   473.828     0.150
    42.556   851.178     0.150
    42.680   861.467     0.150
    42.935   478.568     0.150
    42.915   478.877     0.150
    42.953   479.768     0.150
    43.076   480.307     0.150
    43.076   482.988     0.150
    43.034   480.918     0.150
    43.034   480.967     0.150
    43.831   885.438     0.150
    43.985     5.799     0.150
    43.985     8.100     0.150
    43.985   876.467     0.150
    43.948   888.607     0.150
    44.078   488.988     0.150
    44.078   488.967     0.150
    44.356   490.367     0.150
    44.360   490.268     0.150
    44.360   490.268     0.150
    44.360   490.818     0.150
    44.360   490.598     0.150
    44.517     5.500     0.150
    44.617   492.467     0.150
    45.607   500.588     0.150
    45.607   499.768     0.150
    45.607   499.668     0.150
    45.607   500.887     0.150
    45.607   500.838     0.150
    45.976   499.891     0.150
    45.976   506.127     0.150
    56.219   504.371     0.150
    56.219   504.508     0.150
    56.219   503.457     0.150
    46.299   505.867     0.150
    46.713   510.367     0.150
    46.866   507.867     0.150
    46.866   508.398     0.150
    47.116     4.699     0.150
    47.508   515.127     0.150
    47.698   934.029     0.150
    47.698   516.768     0.150
    89.610   517.668     0.150
    48.473   522.887     0.150
    48.473   522.838     0.150
    48.642   524.617     0.150
    48.854   525.898     0.150
    48.854   525.867     0.150
    48.992     5.102     0.150
    49.213   960.268     0.150
    49.753    10.398     0.150
    49.753   701.967     0.150
    49.753  1257.168     0.150
    49.753   531.777     0.150
    50.248   536.617     0.150
    50.248   536.867     0.150
    50.248   536.367     0.150
    50.280   536.127     0.150
    50.392   539.918     0.150
    50.509   538.367     0.150
    50.932   540.238     0.150
    50.932   540.207     0.150
    50.953   542.367     0.150
    51.483   545.457     0.150
    51.483   545.068     0.150
    51.661   546.617     0.150
    51.717     5.398     0.150
    51.984   549.010     0.150
    51.984   548.938     0.150
    52.384   551.297     0.150
    52.384   550.867     0.150
    52.443   552.568     0.150
    96.925   554.994     0.150
    96.925   555.088     0.150
    96.925   553.088     0.150
    53.898   560.365     0.150
    54.341   566.467     0.150
    54.403   567.068     0.150
    54.590   568.307     0.150
    55.165   572.318     0.150
    55.742   577.768     0.150
    56.089   579.348     0.150
    56.089   581.062     0.150
    56.415   580.967     0.150
    56.415   577.188     0.150
    56.415   583.627     0.150
    56.522   581.867     0.150
   110.961   582.252     0.150
   110.961   582.568     0.150
   110.961   583.578     0.150
    58.187   595.168     0.150
    58.318   595.377     0.150
    58.318   595.258     0.150
    58.556   598.168     0.150
    59.089   600.627     0.150
    59.089   598.479     0.150
    59.089   600.488     0.150
    44.690   600.746     0.150
    59.869   735.068     0.150
    59.994  1095.967     0.150
    59.982   606.668     0.150
    59.982   607.488     0.150
    59.982   607.658     0.150
    60.070   607.268     0.150
    60.300   608.457     0.150
    60.300   608.457     0.150
    60.316   609.258     0.150
    60.491   609.367     0.150
    60.493   609.867     0.150
    60.528   610.367     0.150
    60.934   612.338     0.150
    61.219   619.918     0.150
    61.921   619.668     0.150
    63.468   630.178     0.150
    63.809   863.967     0.150
    63.941   632.838     0.150
    64.110   633.568     0.150
    64.096   634.328     0.150
    66.342   647.867     0.150
    66.342   647.957     0.150
    66.342   647.967     0.150
    66.585   642.457     0.150
    66.639   650.568     0.150
    66.639   650.457     0.150
    66.894   648.768     0.150
    66.894   898.068     0.150
    67.192   653.068     0.150
    67.127   653.018     0.150
    67.127   652.928     0.150
    67.127   653.188     0.150
    67.900   657.867     0.150
    68.251   660.867     0.150
    68.387   654.617     0.150
    68.603   663.938     0.150
    68.603   662.668     0.150
    69.426   661.158     0.150
    69.537   670.088     0.150
    70.038   669.758     0.150
    69.855   670.168     0.150
    70.143   671.338     0.150
    70.143   671.637     0.150
    70.414   669.578     0.150
    70.568   668.648     0.150
    71.044   677.357     0.150
    71.044   677.348     0.150
    73.658   692.008     0.150
    74.341   694.158     0.150
    74.398   699.268     0.150
    74.380   697.168     0.150
    74.941   701.447     0.150
    75.641   704.828     0.150
    76.701   711.367     0.150
    77.047   716.537     0.150
    77.047   713.174     0.150
    78.096   718.768     0.150
    78.934   723.268     0.150
    79.761   726.588     0.150
    80.596   732.367     0.150
    80.805   733.068     0.150
    80.805   735.518     0.150
    98.005   734.047     0.150
    80.974   734.268     0.150
    82.242   741.592     0.150
    82.242   740.867     0.150
   105.824   741.037     0.150
    50.196   744.168     0.150
    83.459   747.568     0.150
    83.672   747.168     0.150
   102.748   750.229     0.150
    84.285   750.742     0.150
    84.793   753.947     0.150
    84.956   754.217     0.150
    86.857   763.768     0.150
    87.602   767.268     0.150
    89.579   777.168     0.150
    89.900   779.068     0.150
    94.520   805.293     0.150
    95.053   805.717     0.150
    96.386   809.467     0.150
    96.494   813.857     0.150
    96.735   809.068     0.150
    96.948   810.088     0.150
    97.445   812.568     0.150
    98.963   820.568     0.150
    99.556   820.943     0.150
    99.867   829.668     0.150
    99.903   825.867     0.150
   100.553   828.867     0.150
   100.859   834.068     0.150
   101.948   836.992     0.150
   102.171   840.318     0.150
   102.634   833.168     0.150
   103.703   852.463     0.150
   114.906  1765.793     0.150
   114.959  1180.797     0.150
   115.191  1119.334     0.150
   115.191  1756.260     0.150
   116.413  1125.717     0.150
   116.850  1127.268     0.150
   116.850  1123.467     0.150
   121.187  1137.467     0.150
   121.187  1134.312     0.150
    67.089  1133.488     0.150
   135.468  1154.443     0.150
   140.886  1164.467     0.150
     2.236    38.445     0.150
     2.363    40.545     0.150
     3.549    57.135     0.150
     3.807    59.645     0.150
     3.971    62.045     0.150
     5.001    65.254     0.150
     5.891    86.645     0.150
     5.891    86.545     0.150
    46.870   102.055     0.150
     7.130   105.805     0.150
     7.130   105.844     0.150
     7.130   105.744     0.150
     8.912   129.945     0.150
     8.912   129.945     0.150
     9.258   134.645     0.150
     9.460   133.953     0.150
     9.742   140.945     0.150
    10.001   144.244     0.150
    10.397   146.355     0.150
    10.397   146.344     0.150
    10.647   152.344     0.150
    10.773   152.344     0.150
    10.773   270.445     0.150
    10.773   154.145     0.150
    11.509   168.943     0.150
    11.714   171.715     0.150
    12.462   181.818     0.150
    12.655   179.664     0.150
    12.655   179.760     0.150
    12.655   180.154     0.150
    12.655   179.375     0.150
    13.244   192.119     0.150
    13.472   190.545     0.150
    13.781   199.766     0.150
    13.933   197.344     0.150
    14.104   198.904     0.150
    14.351   201.844     0.150
    14.517   205.504     0.150
    14.517   205.445     0.150
    14.662   205.645     0.150
    14.662   363.045     0.150
    15.334   215.945     0.150
    15.648   218.945     0.150
    15.648   388.545     0.150
    15.705   220.844     0.150
    15.776   222.445     0.150
    16.024   396.844     0.150
    16.349   229.545     0.150
    16.159   227.145     0.150
    16.325   229.445     0.150
    17.236   241.945     0.150
    17.521   247.344     0.150
    17.521   247.365     0.150
    18.097   251.025     0.150
    18.097   250.744     0.150
    18.097   251.018     0.150
    18.157   251.424     0.150
    19.332   479.295     0.150
    19.341   488.945     0.150
    19.399   266.445     0.150
    19.575   269.045     0.150
    20.032   273.645     0.150
    20.664   280.045     0.150
    21.105   284.744     0.150
    21.869   294.504     0.150
    21.869     3.430     0.150
    21.908   293.545     0.150
    23.009   307.045     0.150
    23.030   306.844     0.150
    23.030   307.014     0.150
    23.589   572.145     0.150
    23.689   313.645     0.150
    25.197   326.244     0.150
    25.446   329.465     0.150
    25.446   329.254     0.150
    26.005   333.545     0.150
    26.298   335.494     0.150
    26.796     5.100     0.150
    26.953   343.514     0.150
    27.448   347.557     0.150
    27.448   347.545     0.150
    27.765   350.996     0.150
   106.285   351.895     0.150
    28.298   354.902     0.150
    28.586   357.344     0.150
    28.586   358.844     0.150
    28.593   357.445     0.150
    28.593   357.434     0.150
    28.593   357.445     0.150
    28.863   361.645     0.150
    28.867   361.971     0.150
    28.877   360.445     0.150
    28.914   361.709     0.150
    29.389   365.375     0.150
    29.342   365.844     0.150
    29.465   364.545     0.150
    29.957   370.783     0.150
    30.221   373.336     0.150
    30.238   373.096     0.150
    31.039   380.426     0.150
    31.374   383.744     0.150
    31.374   383.828     0.150
    31.507   384.963     0.150
    31.602   383.945     0.150
    31.759   386.381     0.150
    32.286   384.859     0.150
    32.374   392.336     0.150
    32.412   393.064     0.150
    32.479   390.244     0.150
    33.223   396.844     0.150
    33.774   403.615     0.150
    33.810   405.129     0.150
    33.960   404.035     0.150
    33.960   403.945     0.150
    34.042     7.301     0.150
    34.267   409.674     0.150
    35.399   418.686     0.150
    35.463   417.344     0.150
    35.519   419.141     0.150
    39.195   418.594     0.150
    35.602   419.689     0.150
    35.602   420.129     0.150
    35.604   419.715     0.150
    35.907   421.744     0.150
    35.972   421.156     0.150
    35.972   421.045     0.150
    36.023   424.344     0.150
    36.155   424.238     0.150
    36.257   426.645     0.150
    36.257   424.922     0.150
    36.450     3.100     0.150
    36.460   427.244     0.150
    36.609   426.844     0.150
    36.556   428.744     0.150
    36.662   428.945     0.150
    36.678   430.344     0.150
    36.678   430.344     0.150
    36.747   428.920     0.150
    36.747   428.945     0.150
    36.747   428.855     0.150
    36.834   429.945     0.150
    37.555   435.744     0.150
    37.595   434.945     0.150
    37.595   434.945     0.150
    37.606   436.244     0.150
    37.632   437.445     0.150
    37.730   436.744     0.150
    37.878   438.244     0.150
    38.029   438.145     0.150
    38.108   439.645     0.150
    38.151   439.865     0.150
    38.176   441.508     0.150
    38.294   441.645     0.150
    38.548   443.445     0.150
    38.548     2.879     0.150
    38.666   445.645     0.150
    38.666   445.645     0.150
    39.349   450.244     0.150
    39.424   451.275     0.150
    39.531   453.875     0.150
    39.594   452.645     0.150
    40.004   456.135     0.150
    40.097     3.600     0.150
    40.248   458.344     0.150
    40.350   458.186     0.150
    40.438   562.244     0.150
    40.592   461.945     0.150
    40.592   460.236     0.150
   124.275   461.764     0.150
    40.983   463.844     0.150
    41.268   466.605     0.150
    41.485   469.545     0.150
    41.485   468.504     0.150
    41.513   468.145     0.150
    41.525   467.145     0.150
    22.993   469.475     0.150
    41.563   468.744     0.150
    41.563   468.744     0.150
    41.563   468.744     0.150
    41.587   469.145     0.150
    41.698   469.943     0.150
    41.961   471.424     0.150
    42.260   475.545     0.150
    42.348   475.145     0.150
    42.434   475.844     0.150
    42.729   478.545     0.150
    42.922   480.045     0.150
    42.928   480.754     0.150
    42.968   481.105     0.150
    42.968   481.045     0.150
    43.082   481.424     0.150
    43.082   481.477     0.150
    43.082   481.314     0.150
    43.049   481.885     0.150
    43.049   481.945     0.150
    43.970     4.000     0.150
    44.203   569.465     0.150
    44.346     5.150     0.150
    44.346   490.844     0.150
    44.375   491.590     0.150
    44.375   491.445     0.150
    44.375   491.645     0.150
    44.375   491.344     0.150
    44.632   493.344     0.150
    45.616   501.824     0.150
    45.616   501.545     0.150
    45.616   501.914     0.150
    45.616   501.605     0.150
    56.206   505.484     0.150
    46.315   506.945     0.150
    46.851   508.773     0.150
    46.851   508.695     0.150
    89.595   518.664     0.150
    48.471   524.105     0.150
    48.487   524.045     0.150
    48.487   523.795     0.150
    48.487   524.045     0.150
    48.861   527.045     0.150
    48.861   527.334     0.150
    48.861   527.434     0.150
    48.861   527.145     0.150
    49.299     3.590     0.150
    49.747   533.145     0.150
    49.747    10.400     0.150
    49.747   702.545     0.150
    49.747  1258.945     0.150
    50.264   537.721     0.150
    50.264   537.695     0.150
    50.264   537.344     0.150
    50.278   537.305     0.150
    50.278   537.344     0.150
    50.406   538.344     0.150
    50.879   542.045     0.150
    50.967   543.045     0.150
    51.470   545.844     0.150
    51.677   547.844     0.150
    51.678   547.764     0.150
    52.000   550.375     0.150
    52.148   988.844     0.150
    96.928   556.174     0.150
    54.411   568.154     0.150
    54.411   568.246     0.150
    54.411   568.244     0.150
    54.606   569.283     0.150
    55.169   572.455     0.150
    55.752   578.344     0.150
    56.427   584.674     0.150
   110.967   583.496     0.150
   110.967   582.945     0.150
    57.218   588.195     0.150
    58.188   593.844     0.150
    59.096   600.605     0.150
    59.096   601.404     0.150
    59.096   601.334     0.150
    59.859   606.244     0.150
    59.859   606.615     0.150
    59.989   605.244     0.150
    59.987   607.645     0.150
    60.294   609.465     0.150
    60.325   610.424     0.150
    60.479   610.125     0.150
    60.481   610.445     0.150
    62.727   626.365     0.150
    62.727   626.355     0.150
    66.334   648.445     0.150
    66.649   651.275     0.150
    67.142   653.934     0.150
    67.912   659.645     0.150
    67.912   659.635     0.150
    68.139   660.244     0.150
    68.139   661.264     0.150
    68.609   663.244     0.150
    68.609   663.734     0.150
    71.052   679.584     0.150
    71.828   682.305     0.150
    72.425   687.105     0.150
    74.347   696.090     0.150
    74.389   699.445     0.150
    76.703   712.244     0.150
    76.703   712.244     0.150
    78.934   724.545     0.150
    79.582   728.145     0.150
    98.008   734.545     0.150
    80.974   735.645     0.150
    83.457   748.773     0.150
    83.457   748.744     0.150
   102.754   751.375     0.150
    84.036   751.045     0.150
    89.906   779.986     0.150
   107.284  1106.820     0.150
   107.961   858.215     0.150
    67.081  1131.014     0.150
    70.977  1133.945     0.150
    34.957  1137.615     0.150
    34.957  1134.645     0.150
    37.632  1137.145     0.150
    94.440  1134.244     0.150
   143.612  1169.695     0.150
     1.427    47.227     0.150
     1.427    26.496     0.150
     2.986    47.227     0.150
     3.981    61.428     0.150
     4.988    64.236     0.150
     5.583    84.816     0.150
     5.922    86.727     0.150
     6.173    92.197     0.150
     6.133    90.188     0.150
    46.865   102.807     0.150
     7.191   105.928     0.150
     8.970   129.326     0.150
     9.314   134.326     0.150
     9.488   136.867     0.150
    10.061   143.627     0.150
    10.119   156.268     0.150
    10.707   151.928     0.150
    10.834   153.727     0.150
    11.041   155.928     0.150
    12.714   180.727     0.150
    12.714   181.197     0.150
    12.714   181.027     0.150
    13.080   190.027     0.150
    13.530   192.326     0.150
    14.160   199.326     0.150
    14.406   203.027     0.150
    16.216   226.826     0.150
    17.509   245.057     0.150
    18.042   249.627     0.150
    19.396   265.527     0.150
    19.458   266.527     0.150
    21.124   283.428     0.150
    21.488   288.697     0.150
    21.920   293.826     0.150
    21.920   294.727     0.150
    21.920   538.928     0.150
    21.920   294.717     0.150
    22.034   299.277     0.150
    23.021   307.027     0.150
    23.594   314.727     0.150
    25.225   325.826     0.150
    25.988   334.428     0.150
    26.982   345.178     0.150
    27.769   352.027     0.150
    28.601   358.826     0.150
    28.608   357.127     0.150
    29.259   365.297     0.150
    31.511   386.227     0.150
    31.511   386.188     0.150
    31.765   386.326     0.150
    32.377   391.227     0.150
    32.981   399.197     0.150
    33.784   405.527     0.150
    33.817   404.826     0.150
    34.864   414.768     0.150
    35.234   419.027     0.150
    35.234   419.066     0.150
    35.251   417.707     0.150
    35.612   421.928     0.150
    35.612   421.943     0.150
    36.207   423.027     0.150
    36.266   425.826     0.150
    36.623   426.527     0.150
    36.560   430.447     0.150
    36.560   430.428     0.150
    36.860   429.266     0.150
    36.873   429.527     0.150
    37.342   436.396     0.150
    37.543   433.547     0.150
    38.041   440.316     0.150
    38.041   440.326     0.150
    38.116   442.447     0.150
    38.116   442.428     0.150
    38.400   444.557     0.150
    38.637   444.826     0.150
    38.678   447.996     0.150
    38.678   447.928     0.150
    38.678     0.199     0.150
    38.929   450.387     0.150
    38.929   450.428     0.150
    39.711   453.500     0.150
    39.942   453.461     0.150
    40.046   455.387     0.150
    40.046   455.986     0.150
    40.384   460.166     0.150
    40.544   459.939     0.150
   124.281   461.746     0.150
    40.991   463.326     0.150
    41.307   468.326     0.150
    41.307   468.287     0.150
    41.511   467.627     0.150
    41.570   471.246     0.150
    41.570   471.227     0.150
    41.856   469.598     0.150
    42.342   476.537     0.150
    42.355   474.627     0.150
    42.729   478.227     0.150
    43.021   480.467     0.150
    42.977   483.646     0.150
    42.977   483.627     0.150
    44.378   490.928     0.150
    44.378   490.928     0.150
    44.378   491.117     0.150
    56.252   504.857     0.150
    46.845   507.217     0.150
    46.845   507.598     0.150
    48.478   524.127     0.150
    50.235   537.326     0.150
    51.675   547.287     0.150
    51.997   549.928     0.150
    51.997   549.938     0.150
    52.479   553.127     0.150
    53.528   560.156     0.150
    54.454   567.826     0.150
    54.602   568.826     0.150
    55.176   575.678     0.150
    56.406   584.316     0.150
    59.034   600.406     0.150
    78.419   721.527     0.150
   142.209  1172.127     0.150
     1.407    47.668     0.150
     1.620    29.688     0.150
     1.777    33.408     0.150
     1.985    36.059     0.150
     2.776    47.988     0.150
     4.471    84.604     0.150
     4.971    64.838     0.150
     5.561    86.158     0.150
     5.933    92.672     0.150
     5.933    88.768     0.150
     6.009    95.168     0.150
     6.187    93.969     0.150
    46.886   105.348     0.150
     7.181   105.768     0.150
     7.181   106.107     0.150
     8.964   130.668     0.150
     9.311   135.568     0.150
     9.500   139.068     0.150
     9.792   141.469     0.150
     9.792   253.268     0.150
    10.053   144.568     0.150
    10.104   145.969     0.150
    10.447   146.537     0.150
    10.447   146.469     0.150
    10.529   153.822     0.150
    10.699   153.367     0.150
    10.823   155.068     0.150
    10.823   155.068     0.150
    10.817   156.059     0.150
    10.817   155.969     0.150
    11.000   159.496     0.150
    11.035   156.867     0.150
    11.460   164.078     0.150
    11.953   166.008     0.150
    12.707   180.861     0.150
    12.707   182.734     0.150
    12.707   180.934     0.150
    12.707   181.119     0.150
    12.707   179.809     0.150
    13.194   189.699     0.150
    13.220   340.818     0.150
    13.525   191.428     0.150
    13.984   198.068     0.150
    14.156   199.287     0.150
    14.373   206.168     0.150
    14.403   201.668     0.150
    14.569   204.268     0.150
    14.569   367.469     0.150
    14.673   209.738     0.150
    14.690   359.475     0.150
    14.690   206.367     0.150
    15.124   213.719     0.150
    15.387   215.168     0.150
    15.387   387.268     0.150
    15.696   218.268     0.150
    15.757   221.668     0.150
    15.757   397.768     0.150
    15.828   220.768     0.150
    15.828   398.867     0.150
    16.050   224.182     0.150
    16.050   224.168     0.150
    16.050   399.367     0.150
    16.402   229.568     0.150
    16.402   413.168     0.150
    16.211   225.768     0.150
    16.377   229.268     0.150
    17.188   241.469     0.150
    17.282   240.168     0.150
    17.282   433.969     0.150
    17.487   243.783     0.150
    17.487   243.488     0.150
    17.487   243.258     0.150
    17.505   246.287     0.150
    18.044   250.068     0.150
    19.451   266.867     0.150
    19.671   269.469     0.150
    20.081   511.713     0.150
    20.188   275.928     0.150
    20.188   277.037     0.150
    20.188     7.506     0.150
    20.476   503.209     0.150
    21.139   281.268     0.150
    21.139   285.168     0.150
    21.481   289.367     0.150
    21.897   295.037     0.150
    21.960   289.367     0.150
    21.960     4.420     0.150
    22.663   300.357     0.150
    22.720   304.238     0.150
    22.986   306.367     0.150
    23.003   306.168     0.150
    23.003   306.168     0.150
    23.326   565.268     0.150
    23.573   570.668     0.150
    23.662   313.367     0.150
    27.716   314.867     0.150
    25.172   326.469     0.150
    25.172   326.518     0.150
    25.173  8730.668     0.150
    25.237   327.867     0.150
    25.237   643.268     0.150
    25.237   327.068     0.150
    25.362   607.918     0.150
    25.362   329.068     0.150
    25.416   329.367     0.150
    25.416   329.457     0.150
    25.972   334.168     0.150
    26.107   338.898     0.150
    26.265   335.607     0.150
    26.315   340.867     0.150
    26.843     3.801     0.150
    26.843     6.199     0.150
    26.958   635.086     0.150
    26.958   343.549     0.150
    26.958   343.549     0.150
    26.958   343.697     0.150
    27.278   346.639     0.150
    27.429   346.969     0.150
    27.429   347.934     0.150
    27.429   348.018     0.150
    27.455   346.469     0.150
    27.748   350.469     0.150
   106.269   351.398     0.150
    28.214   355.705     0.150
    28.286   355.357     0.150
    28.924   356.148     0.150
    28.578   357.668     0.150
    28.585   357.867     0.150
    28.585   357.246     0.150
    28.585   357.668     0.150
    28.585   357.654     0.150
    28.638   358.609     0.150
    28.773   360.648     0.150
    28.847   361.367     0.150
    28.849   362.127     0.150
    28.852   360.416     0.150
    28.852   360.469     0.150
    28.897   361.855     0.150
    26.552   363.078     0.150
    29.324   365.469     0.150
    29.324   365.469     0.150
    29.324   366.561     0.150
    29.433   364.867     0.150
    29.433   364.842     0.150
    84.093   366.068     0.150
    29.900   370.660     0.150
    29.939   370.865     0.150
    30.207   373.312     0.150
    30.426   373.867     0.150
    30.506   376.750     0.150
    30.662   379.367     0.150
    30.834   378.469     0.150
    30.895   377.678     0.150
    30.895   377.678     0.150
    30.895   445.988     0.150
    30.895   780.738     0.150
    30.895   795.688     0.150
    30.895   377.668     0.150
    30.895   437.469     0.150
    30.895   681.469     0.150
    30.895   780.668     0.150
    30.904   373.568     0.150
    30.973   380.668     0.150
    31.016   380.367     0.150
    31.016   380.412     0.150
    31.128   382.098     0.150
    31.147   381.400     0.150
    31.241   381.557     0.150
    31.241   381.438     0.150
    31.359   383.568     0.150
    31.490   384.469     0.150
    31.522   384.197     0.150
    31.576   383.469     0.150
    31.743   386.867     0.150
    31.743   386.871     0.150
    32.075   389.768     0.150
    32.123   386.299     0.150
    32.267   391.668     0.150
    32.279   388.588     0.150
    32.286   389.668     0.150
    32.286   393.113     0.150
    32.356   391.867     0.150
    32.356   391.836     0.150
    32.399   392.668     0.150
    32.399   392.711     0.150
    32.714   458.068     0.150
    33.064   394.969     0.150
    33.064   837.768     0.150
    33.156   398.484     0.150
    33.219   396.668     0.150
    33.219   396.867     0.150
    33.339   399.367     0.150
    33.339   399.328     0.150
    33.486   402.273     0.150
    33.515   400.357     0.150
    33.702   401.219     0.150
    33.762   406.268     0.150
    33.796   405.395     0.150
    33.842   403.268     0.150
    33.937   404.367     0.150
    33.967   413.818     0.150
    34.090     4.301     0.150
    34.090   738.768     0.150
    34.139   406.498     0.150
    34.254   408.951     0.150
    34.327   408.107     0.150
    34.370   408.598     0.150
    34.370   409.969     0.150
    34.370   406.562     0.150
    34.370   412.588     0.150
    34.773   412.068     0.150
    34.840   413.844     0.150
    35.035   414.197     0.150
    35.211   416.668     0.150
    35.211   416.707     0.150
    35.251   747.469     0.150
    35.438   418.568     0.150
    35.505   419.594     0.150
    35.590   419.996     0.150
    35.590   420.367     0.150
    35.590   420.289     0.150
    35.590   420.168     0.150
    35.590   420.146     0.150
    39.199   419.416     0.150
    39.199   419.389     0.150
    35.947   420.998     0.150
    35.947   420.908     0.150
    35.960   420.293     0.150
    36.008   423.299     0.150
    36.119   424.768     0.150
    36.142   424.668     0.150
    36.142   424.650     0.150
    36.142   424.695     0.150
    36.244   425.469     0.150
    36.244   425.467     0.150
    36.305   425.668     0.150
    36.449   427.867     0.150
    36.449   426.969     0.150
    36.485     5.000     0.150
    36.490     4.580     0.150
    36.537   428.867     0.150
    36.537   428.834     0.150
    36.545   428.367     0.150
    36.651   429.668     0.150
    36.667   429.768     0.150
    36.640   427.188     0.150
    36.640   427.168     0.150
    36.681   429.297     0.150
    36.765   429.268     0.150
    36.765   427.338     0.150
    36.848   429.969     0.150
    36.958   431.270     0.150
    37.320   434.656     0.150
    37.542   434.969     0.150
    37.542   434.969     0.150
    37.581   436.668     0.150
    37.583   435.268     0.150
    37.583   435.268     0.150
    37.592   436.768     0.150
    37.620   437.268     0.150
    37.859   438.268     0.150
    37.973   439.379     0.150
    38.018   438.568     0.150
    38.094   440.068     0.150
    38.094   440.068     0.150
    38.114     4.100     0.150
    38.160   441.807     0.150
    38.263   445.697     0.150
    38.271   441.867     0.150
    38.271   441.768     0.150
    38.554   443.344     0.150
    38.612   445.367     0.150
    38.596   444.309     0.150
    38.656   445.568     0.150
    38.656   537.668     0.150
    38.656   553.668     0.150
    38.656   572.068     0.150
    38.913   446.902     0.150
    39.162   448.498     0.150
    39.002   449.457     0.150
    39.331   450.469     0.150
    39.372     3.301     0.150
    39.413   451.254     0.150
    39.579   452.068     0.150
    39.579   452.076     0.150
    39.544   452.510     0.150
    39.650   454.367     0.150
    39.650   454.309     0.150
    40.022   455.996     0.150
    40.022   456.049     0.150
    40.022   456.828     0.150
    40.265   545.107     0.150
    40.265   458.867     0.150
    40.265   458.867     0.150
    40.340   458.697     0.150
    40.490   471.068     0.150
    40.490   574.867     0.150
    40.571   460.109     0.150
    40.585   461.168     0.150
    40.585   461.078     0.150
   124.259   462.379     0.150
    40.969   464.068     0.150
    62.972   465.607     0.150
    41.030   464.738     0.150
    41.141   828.643     0.150
    41.154   464.898     0.150
    41.283   466.729     0.150
    41.452   466.768     0.150
    41.476  1017.309     0.150
    41.473   468.568     0.150
    41.473   468.518     0.150
    41.491   467.568     0.150
    22.970   469.719     0.150
    41.528   467.668     0.150
    41.548   468.668     0.150
    41.548   468.668     0.150
    41.583   470.168     0.150
    41.961   471.719     0.150
    42.249   474.576     0.150
    42.333   475.168     0.150
    42.333   474.768     0.150
    42.355   475.113     0.150
    42.379  1017.078     0.150
    42.383   853.289     0.150
    42.383   476.338     0.150
    42.383   476.168     0.150
    42.503   477.506     0.150
    42.588   567.578     0.150
    42.627  1042.469     0.150
    42.927   481.018     0.150
    42.955   481.719     0.150
    42.955   480.668     0.150
    42.972   480.568     0.150
    42.892   872.568     0.150
    43.037   482.367     0.150
    43.032   480.809     0.150
    43.489  1061.148     0.150
    43.542   486.479     0.150
    43.834   879.328     0.150
    43.951   883.168     0.150
    43.951   488.367     0.150
    44.017     4.699     0.150
    44.017   885.969     0.150
    44.082   489.469     0.150
    44.357   491.469     0.150
    44.357   491.268     0.150
    44.357   491.748     0.150
    44.355   492.867     0.150
    44.399   491.867     0.150
    44.426  1075.559     0.150
    44.428  1075.248     0.150
    44.552   895.969     0.150
    44.914   495.027     0.150
    45.563   501.908     0.150
    45.563   500.668     0.150
    45.563   501.469     0.150
    45.563   501.812     0.150
    56.255   506.537     0.150
    56.255   505.658     0.150
    56.255   505.357     0.150
    46.867   509.219     0.150
    46.867   509.357     0.150
    46.989   512.287     0.150
    47.124   513.688     0.150
    47.151   517.469     0.150
    47.150     4.201     0.150
    47.339   934.068     0.150
    47.728   925.955     0.150
    47.862   518.686     0.150
    89.615   518.938     0.150
    48.108   936.568     0.150
    48.481   524.188     0.150
    48.481   524.568     0.150
    48.481   524.639     0.150
    48.481     0.049     0.150
    48.884   528.008     0.150
    48.884   527.947     0.150
    48.884   527.768     0.150
    49.032     4.000     0.150
    49.032     8.600     0.150
    49.347   530.969     0.150
    49.797   533.498     0.150
    49.797    10.500     0.150
    49.797   705.668     0.150
    49.797   533.648     0.150
    50.160   536.838     0.150
    50.223   537.758     0.150
    50.223   537.598     0.150
    50.223   537.469     0.150
    50.515   539.668     0.150
    50.668   972.398     0.150
    50.870   542.068     0.150
    50.935   541.648     0.150
    51.300   527.768     0.150
    51.520   546.768     0.150
    51.655   547.908     0.150
    51.977   550.438     0.150
    51.977   550.639     0.150
    52.200   552.068     0.150
    52.421   553.219     0.150
    52.421   553.268     0.150
    52.480   554.268     0.150
    96.963   556.299     0.150
    96.963   556.389     0.150
    96.963   555.488     0.150
    53.050   558.867     0.150
    53.525   562.068     0.150
    54.331   567.059     0.150
    54.331   567.068     0.150
    54.430   568.648     0.150
    54.430   568.668     0.150
    54.583   569.527     0.150
    55.386  1040.969     0.150
    55.386   574.469     0.150
    55.556  1043.207     0.150
    55.783   578.367     0.150
    56.433   585.264     0.150
    56.433   584.947     0.150
    56.557   583.488     0.150
   110.992   583.707     0.150
   110.992   583.688     0.150
   110.992   584.129     0.150
    56.724   584.408     0.150
    58.355   596.979     0.150
    59.045   600.748     0.150
    59.045   601.588     0.150
    59.702   606.568     0.150
    60.014   608.168     0.150
    60.014   610.988     0.150
    60.108   608.188     0.150
    60.530   610.867     0.150
    60.532   611.268     0.150
    61.963   620.998     0.150
    62.737   626.639     0.150
    63.851  1400.367     0.150
    63.909   633.918     0.150
    64.086   635.258     0.150
    64.123   635.229     0.150
    65.577   644.729     0.150
    66.386   648.969     0.150
    66.386   649.078     0.150
    66.938   650.768     0.150
    67.097   654.258     0.150
    67.097   654.117     0.150
    67.201   654.268     0.150
    67.919   659.777     0.150
    68.087   661.148     0.150
    68.257   668.240     0.150
    68.559   663.559     0.150
    69.014   666.178     0.150
    69.553   669.037     0.150
    69.888   671.768     0.150
    71.000   679.678     0.150
    71.000   678.787     0.150
    71.778   682.828     0.150
    72.387   687.719     0.150
    73.666   693.457     0.150
    74.440   701.168     0.150
    74.985   702.027     0.150
    76.739   712.469     0.150
    78.162   708.355     0.150
    78.400  2322.518     0.150
    78.975   724.867     0.150
    79.088   725.438     0.150
    80.105   730.457     0.150
    98.041   735.607     0.150
    80.812   733.568     0.150
    81.015   735.867     0.150
    81.427   737.367     0.150
    82.023   736.297     0.150
    82.262   742.469     0.150
    82.756   741.256     0.150
    83.500   749.367     0.150
    83.664   748.568     0.150
    84.074   751.607     0.150
    84.278   751.418     0.150
    84.948   754.668     0.150
    84.948   754.568     0.150
    89.583   778.068     0.150
    89.931   780.469     0.150
    89.931   780.639     0.150
    90.093   780.367     0.150
    91.231   790.918     0.150
    96.422   810.867     0.150
    96.532   816.129     0.150
    96.747   816.438     0.150
    96.747   810.768     0.150
    96.953   811.648     0.150
    97.481   814.367     0.150
    98.963   821.969     0.150
    99.936   827.268     0.150
   100.583   829.768     0.150
   101.912   839.844     0.150
   103.730   853.963     0.150
   116.086  1122.090     0.150
   121.212  1136.264     0.150
   121.212  1142.363     0.150
    67.133  1134.688     0.150
    34.963  1138.037     0.150
    34.963  1137.068     0.150
    37.620  1139.168     0.150
    94.445  1135.568     0.150
   125.910  1142.537     0.150
    32.374  1142.768     0.150
   143.362  1170.219     0.150
     1.338    45.604     0.150
     1.553    27.523     0.150
     2.737    44.514     0.150
     3.441    53.533     0.150
     3.814    58.984     0.150
     4.895    61.984     0.150
     5.497    83.654     0.150
     6.144    90.805     0.150
     6.381    94.443     0.150
    73.767   692.715     0.150
    74.450   697.934     0.150
    87.680   769.779     0.150
     1.473    50.299     0.150
     1.711    29.199     0.150
     1.711    29.340     0.150
     1.817    32.420     0.150
     2.268    38.699     0.150
     2.401    39.799     0.150
     2.587    41.500     0.150
     2.736    44.199     0.150
     3.581    55.500     0.150
     3.581    56.070     0.150
     3.947    61.189     0.150
     4.447    68.400     0.150
     5.047    63.650     0.150
     5.707    85.400     0.150
     5.843    88.400     0.150
     5.919    93.900     0.150
     6.071    90.600     0.150
     6.172    91.500     0.150
     6.258    92.500     0.150
    46.830   101.760     0.150
     7.100   104.600     0.150
     7.100   104.600     0.150
     8.722   127.199     0.150
     8.876   128.199     0.150
     9.067   131.600     0.150
     9.219   133.600     0.150
     9.412   136.930     0.150
     9.714   140.100     0.150
     9.968   143.000     0.150
     9.938   261.574     0.150
     9.980   146.463     0.150
    10.371   144.799     0.150
    10.489   156.430     0.150
    10.613   150.500     0.150
    10.745   152.900     0.150
    10.947   154.600     0.150
    10.887   156.600     0.150
    11.000   158.100     0.150
    11.089   157.561     0.150
    11.073   161.434     0.150
    11.740   170.457     0.150
    12.552   175.330     0.150
    12.620   179.158     0.150
    12.620   178.500     0.150
    12.620   179.129     0.150
    12.939   186.928     0.150
    13.100   189.379     0.150
    13.198   191.150     0.150
    13.436   188.959     0.150
    13.661   195.600     0.150
    13.776   197.080     0.150
    13.904   196.299     0.150
    13.816   199.568     0.150
    14.065   199.299     0.150
    14.314   206.529     0.150
    14.481   203.100     0.150
    14.481   365.600     0.150
    14.667   205.100     0.150
    14.738   210.100     0.150
    15.033   211.939     0.150
    15.094   210.199     0.150
    15.297   214.000     0.150
    15.297   385.299     0.150
    15.382   219.969     0.150
    15.627   217.400     0.150
    15.668   218.600     0.150
    15.668   394.100     0.150
    16.311   227.299     0.150
    16.311   410.100     0.150
    16.033   222.799     0.150
    16.033   396.400     0.150
    16.121   224.699     0.150
    16.291   229.400     0.150
    17.217   237.699     0.150
    17.426   244.498     0.150
    17.538   243.750     0.150
    17.538   436.900     0.150
    17.817   248.699     0.150
    18.137   252.699     0.150
    18.137   250.359     0.150
    19.320   487.168     0.150
    19.324   265.139     0.150
    19.324   265.100     0.150
    19.324     3.971     0.150
    19.365   264.990     0.150
    19.365   265.078     0.150
    19.365   265.000     0.150
    19.541   267.299     0.150
    20.114   273.961     0.150
    20.114   274.400     0.150
    20.114     5.311     0.150
    20.637   278.799     0.150
    21.058   283.400     0.150
    21.394   287.949     0.150
    21.868   288.699     0.150
    21.868     8.100     0.150
    21.868     4.738     0.150
    21.874   293.768     0.150
    21.874   531.299     0.150
    21.874   293.869     0.150
    23.052   307.400     0.150
    23.075   306.799     0.150
    23.075   307.100     0.150
    23.480   310.799     0.150
    27.787   315.119     0.150
    23.734   313.500     0.150
    25.098   324.799     0.150
    25.149   326.199     0.150
    25.149   325.799     0.150
    25.447     0.699     0.150
    25.493   330.400     0.150
    26.027   337.639     0.150
    26.051   334.299     0.150
    45.220   337.020     0.150
    26.671   342.141     0.150
    26.922   623.400     0.150
    26.980   345.844     0.150
    26.980   342.580     0.150
    26.980   342.600     0.150
    27.137   346.680     0.150
    27.336   348.100     0.150
    27.336   348.160     0.150
    27.350   348.102     0.150
    27.439   350.086     0.150
    27.490   348.795     0.150
    27.535   347.561     0.150
    27.806   352.191     0.150
    27.867   353.291     0.150
   106.325   352.189     0.150
    28.050   354.799     0.150
    28.147   357.100     0.150
    28.336   356.723     0.150
    28.621   356.699     0.150
    28.628   357.010     0.150
    28.616   361.439     0.150
    28.628   357.611     0.150
    28.711   360.434     0.150
    28.904   362.297     0.150
    28.908   363.156     0.150
    28.922   360.699     0.150
    28.955   362.559     0.150
    26.467   362.010     0.150
    29.382   366.605     0.150
    29.412   368.600     0.150
    84.116   367.100     0.150
    29.960   372.400     0.150
    29.960   372.408     0.150
    29.998   372.100     0.150
    29.998   372.162     0.150
    30.036   371.244     0.150
    30.057   370.535     0.150
    30.067   375.418     0.150
    30.260   373.951     0.150
    30.563   377.738     0.150
    30.568   380.525     0.150
    30.726   380.600     0.150
    30.928   378.639     0.150
    30.928   378.639     0.150
    30.928   447.680     0.150
    30.928   798.820     0.150
    30.928   378.600     0.150
    30.928   438.799     0.150
    30.928   683.299     0.150
    30.928   783.799     0.150
    31.082   381.199     0.150
    31.082   380.701     0.150
    31.184   383.312     0.150
    31.208   382.025     0.150
    31.255   382.545     0.150
    31.268   383.098     0.150
    31.371   387.172     0.150
    31.363   381.967     0.150
    31.413   386.102     0.150
    31.441   386.102     0.150
    31.500   380.600     0.150
    31.548   383.799     0.150
    31.548   383.799     0.150
    31.582   385.672     0.150
    31.647   384.400     0.150
    31.742   384.174     0.150
    31.787   388.244     0.150
    31.799   387.816     0.150
    31.896   386.070     0.150
    32.045   388.180     0.150
    32.128   391.033     0.150
    32.198   392.320     0.150
    32.257   388.699     0.150
    32.257   382.785     0.150
    32.315   392.799     0.150
    32.356   389.119     0.150
    32.415   392.105     0.150
    32.433   394.270     0.150
    32.450   393.791     0.150
    32.519   393.234     0.150
    33.205   402.602     0.150
    33.256   397.570     0.150
    33.256   397.900     0.150
    33.372   399.699     0.150
    33.538   403.416     0.150
    33.583   401.180     0.150
    33.739   402.221     0.150
    33.812   405.400     0.150
    33.850   405.412     0.150
    33.996     7.801     0.150
    34.011   405.699     0.150
    34.004   405.199     0.150
    34.305   410.107     0.150
    34.383   408.699     0.150
    34.533   411.637     0.150
    34.601   410.199     0.150
    34.895   414.451     0.150
    35.134   412.600     0.150
    35.261   417.061     0.150
    35.360   416.699     0.150
    35.438   417.584     0.150
    39.222   419.410     0.150
    39.222   418.119     0.150
    35.558   420.650     0.150
    35.640   418.713     0.150
    35.640   421.127     0.150
    35.643   421.500     0.150
    35.643   421.514     0.150
    35.869   420.170     0.150
    36.017   422.930     0.150
    36.063   422.980     0.150
    36.116   422.900     0.150
    36.168   424.500     0.150
    36.194   423.234     0.150
    36.194   425.932     0.150
    36.296   426.410     0.150
    36.296   426.400     0.150
    36.296   424.055     0.150
    36.364   427.199     0.150
    36.498   427.100     0.150
    36.563   425.730     0.150
    36.563   425.799     0.150
    36.585   429.199     0.150
    36.593   429.400     0.150
    36.699   430.900     0.150
    36.699   430.900     0.150
    36.715   431.100     0.150
    36.715   431.100     0.150
    36.852   428.699     0.150
    37.010   432.369     0.150
    37.010   430.320     0.150
    37.049   433.098     0.150
    37.632   436.199     0.150
    37.645   438.299     0.150
    37.645   438.299     0.150
    37.670   436.699     0.150
    37.768   438.639     0.150
    37.919   438.900     0.150
    38.057   439.279     0.150
    38.066   438.600     0.150
    38.147   440.900     0.150
    38.241   441.359     0.150
    38.216   441.100     0.150
    38.337   442.299     0.150
    38.337   442.199     0.150
    38.462   441.900     0.150
    38.615   444.029     0.150
    38.615   444.000     0.150
    38.603   443.170     0.150
    38.603   443.639     0.150
    38.606   445.000     0.150
    38.703   446.699     0.150
    38.703   446.869     0.150
    38.957   448.400     0.150
    38.962   449.451     0.150
    39.114   448.311     0.150
    39.161   451.000     0.150
    39.318   451.949     0.150
    39.391   452.240     0.150
    39.390   450.500     0.150
    39.405   452.299     0.150
    39.461   453.600     0.150
    39.570   451.760     0.150
    39.633   454.061     0.150
    39.633   454.100     0.150
    39.633   454.318     0.150
    39.687   455.699     0.150
    39.675   453.848     0.150
    39.899   456.781     0.150
    39.918   454.430     0.150
    39.947   455.109     0.150
    40.020   455.680     0.150
    40.402   458.900     0.150
    40.386   461.273     0.150
    40.618   463.139     0.150
    40.618   463.115     0.150
    40.627   462.119     0.150
   124.316   462.119     0.150
   124.316   461.010     0.150
    40.972   462.779     0.150
    41.022   463.990     0.150
    41.022   464.000     0.150
    41.060   463.520     0.150
    41.285   466.439     0.150
    41.507   466.770     0.150
    41.507   466.799     0.150
    41.523   470.500     0.150
    41.523   470.795     0.150
    41.553   467.600     0.150
    41.553   470.400     0.150
    41.556   467.619     0.150
    41.556   467.600     0.150
    41.602   469.400     0.150
    41.602   469.797     0.150
    41.742   469.811     0.150
    42.296   475.500     0.150
    42.387   477.139     0.150
    42.387   475.500     0.150
    42.431   475.119     0.150
    42.528   476.010     0.150
    42.580   476.139     0.150
    42.580   477.400     0.150
    42.771   478.000     0.150
    42.878   478.500     0.150
    42.914   479.020     0.150
    42.959   479.859     0.150
    43.006   481.000     0.150
    43.102   479.500     0.150
    43.086   482.199     0.150
    43.092   480.949     0.150
    43.110   480.949     0.150
    43.110   480.969     0.150
    43.315   482.730     0.150
    43.592   484.490     0.150
    43.923     6.699     0.150
    44.001   488.830     0.150
    44.130   490.900     0.150
    44.308   490.900     0.150
    44.312   493.170     0.150
    44.417   490.865     0.150
    44.417   491.199     0.150
    44.672   493.500     0.150
    45.050   496.113     0.150
    45.650   501.799     0.150
    45.650   501.400     0.150
    56.160   504.426     0.150
    56.160   504.449     0.150
    56.160   504.820     0.150
    46.357   506.799     0.150
    46.738   509.350     0.150
    46.811   508.518     0.150
    46.811   508.500     0.150
    46.811   508.529     0.150
    46.995   510.770     0.150
    47.035   513.330     0.150
    47.055     5.299     0.150
    48.521   525.119     0.150
    48.871   528.799     0.150
    49.720   532.150     0.150
    49.720   532.830     0.150
    49.720    10.400     0.150
    49.720   701.000     0.150
    49.720  1255.199     0.150
    50.312   540.119     0.150
    50.312   539.590     0.150
    50.312   537.500     0.150
    50.418   537.779     0.150
    50.558   539.600     0.150
    51.426   545.199     0.150
    51.665   548.299     0.150
    51.921   548.590     0.150
    52.111   549.199     0.150
    52.044   550.080     0.150
    52.044   549.699     0.150
    52.326   551.699     0.150
    52.386   552.400     0.150
    96.925   555.344     0.150
    96.925   552.719     0.150
    52.624   553.910     0.150
    53.106   557.689     0.150
    53.959   563.170     0.150
    54.425   567.580     0.150
    54.425   567.600     0.150
    54.425   567.600     0.150
    54.649   568.967     0.150
    54.649   568.709     0.150
    54.649   568.959     0.150
    55.070   572.189     0.150
    55.624   576.119     0.150
    55.772   576.900     0.150
    55.816   579.490     0.150
    55.957   578.590     0.150
    55.957   580.600     0.150
    56.452   584.223     0.150
    56.630   583.020     0.150
    58.201   593.934     0.150
    58.260   596.660     0.150
    59.821   606.439     0.150
    59.994   608.100     0.150
    60.342   610.279     0.150
    60.342   610.219     0.150
    60.436   609.500     0.150
    61.871   620.199     0.150
    64.003   635.455     0.150
    64.003   635.869     0.150
    64.156   636.730     0.150
    66.303   648.100     0.150
    66.669   651.699     0.150
    66.669   652.520     0.150
    67.132   653.811     0.150
    67.132   653.799     0.150
    67.190   654.400     0.150
    67.190   654.600     0.150
    67.190   654.639     0.150
    67.936   658.930     0.150
    67.936   658.900     0.150
    68.636   663.709     0.150
    69.473   669.100     0.150
    71.085   679.680     0.150
    71.854   682.600     0.150
    71.854   682.949     0.150
    75.578   704.939     0.150
    76.699   711.699     0.150
    77.080   714.600     0.150
    78.609   723.900     0.150
    78.923   724.699     0.150
    79.235   725.400     0.150
    80.043   729.779     0.150
    80.629   734.199     0.150
    80.629   734.100     0.150
    80.964   735.699     0.150
    81.595   738.410     0.150
    67.121   741.389     0.150
    82.178   741.600     0.150
    83.152   746.600     0.150
    83.443   748.100     0.150
    84.908   754.879     0.150
    87.543   767.100     0.150
    89.521  1412.750     0.150
    89.521   777.199     0.150
    89.914   780.199     0.150
    91.850   788.139     0.150
    92.395   792.199     0.150
    98.782   820.590     0.150
    99.577   824.836     0.150
   102.562  1797.650     0.150
   107.285  1801.150     0.150
   114.926  1767.250     0.150
   114.926  1122.600     0.150
   116.147  1123.160     0.150
   116.818  1124.100     0.150
   105.013  1131.100     0.150
    67.050  1135.520     0.150
    67.050  1133.799     0.150
    67.050  1383.199     0.150
    70.967  1134.900     0.150
    34.983  1138.920     0.150
    37.670  1138.000     0.150
   124.465  1719.719     0.150
    32.444  1142.400     0.150
   127.709  1145.600     0.150
   128.471  1142.219     0.150
   138.520  1155.143     0.150
   142.303  1169.447     0.150
   147.169  1185.199     0.150
     2.268    38.768     0.150
     5.050    64.438     0.150
     5.838    86.969     0.150
     5.838    86.969     0.150
     5.838    86.969     0.150
    46.828    99.857     0.150
     7.095   104.469     0.150
     7.095   104.367     0.150
     7.095   104.367     0.150
     8.870   128.469     0.150
     8.870   128.367     0.150
     9.213   133.367     0.150
     9.213   133.367     0.150
     9.962   142.969     0.150
    10.607   151.367     0.150
    10.740   153.568     0.150
    10.740   269.367     0.150
    10.740   153.469     0.150
    11.771   303.668     0.150
    12.614   179.668     0.150
    14.060   198.898     0.150
    14.306   200.668     0.150
    14.663   205.268     0.150
    14.663   361.568     0.150
    16.029   222.557     0.150
    16.029   390.670     0.150
    18.142   251.268     0.150
    19.319   265.367     0.150
    19.359   264.768     0.150
    20.108   275.367     0.150
    21.870   537.469     0.150
    22.375   297.518     0.150
    25.092   322.838     0.150
    25.092   325.668     0.150
    25.145   324.867     0.150
    28.621   360.168     0.150
    33.586   399.498     0.150
    35.063   411.068     0.150
    35.179   418.367     0.150
    36.369   426.537     0.150
    36.560   429.168     0.150
    36.738   427.287     0.150
    38.239   442.508     0.150
    39.215   451.738     0.150
    40.262   456.668     0.150
    41.558   468.469     0.150
    44.418   491.268     0.150
    45.219   499.348     0.150
    96.921   553.107     0.150
    67.935   656.049     0.150
    67.935   656.068     0.150
    75.963   704.938     0.150
    76.480   709.248     0.150
    87.540   771.117     0.150
     1.405    27.189     0.150
     1.636    30.039     0.150
     3.515    55.939     0.150
     4.972    63.930     0.150
    10.806   264.133     0.150
    16.034   227.650     0.150
    20.064   271.637     0.150
     1.765    30.092     0.150
     1.880    33.783     0.150
     2.854    48.463     0.150
     3.318    55.213     0.150
     3.623    56.322     0.150
     4.019    62.143     0.150
     4.567    82.939     0.150
     5.121    76.932     0.150
     6.284    92.674     0.150
    12.034   172.342     0.150
    13.386   192.752     0.150
    17.421   240.451     0.150
    28.683   353.064     0.150
    33.545   398.475     0.150
    33.644   398.412     0.150
    35.227   413.854     0.150
     1.447    26.473     0.150
     1.675    30.684     0.150
     1.983    34.504     0.150
     5.878    84.586     0.150
     7.809   108.426     0.150
     8.806   124.562     0.150
     8.916   126.645     0.150
    12.655   312.020     0.150
    14.676   208.105     0.150
    16.040   388.250     0.150
    21.883   292.125     0.150
    23.047   302.973     0.150
    23.047   302.285     0.150
    25.184   322.934     0.150
    40.111   455.039     0.150
    41.543   465.750     0.150
     1.468    27.578     0.150
     4.003    62.699     0.150
     4.500    82.875     0.150
     5.042    64.570     0.150
     5.844    86.801     0.150
     5.844    86.801     0.150
     7.094   105.199     0.150
     7.094   105.199     0.150
     8.870   128.500     0.150
     8.870   128.500     0.150
     9.215   133.199     0.150
     9.707   139.500     0.150
     9.962   143.098     0.150
    10.364   145.098     0.150
    10.608   151.699     0.150
    10.738   154.000     0.150
    10.941   155.500     0.150
    12.615   179.500     0.150
    13.898   196.598     0.150
    14.061   199.039     0.150
    14.061   199.098     0.150
    14.307   202.398     0.150
    14.476   206.570     0.150
    14.476   206.609     0.150
    14.476   206.598     0.150
    14.733   208.398     0.150
    15.292   216.508     0.150
    15.292   216.500     0.150
    15.663   221.000     0.150
    15.733   222.000     0.150
    16.307   229.598     0.150
    16.286   229.000     0.150
    17.209   240.801     0.150
    17.235   240.699     0.150
    17.296   237.824     0.150
    17.458   242.598     0.150
    17.555   243.621     0.150
    18.141   250.301     0.150
    19.359   265.098     0.150
    19.392   266.410     0.150
    20.998   285.398     0.150
    21.062   284.301     0.150
    21.389   288.520     0.150
    21.864   530.199     0.150
    21.864     3.168     0.150
    21.864   294.500     0.150
    22.081   298.199     0.150
    23.070   305.898     0.150
    23.348   311.898     0.150
    24.307   323.000     0.150
    25.151     3.070     0.150
    25.151   324.898     0.150
    26.913   381.000     0.150
    28.620   357.598     0.150
    28.620   357.199     0.150
    84.125   366.598     0.150
    32.409   389.801     0.150
    32.409   389.801     0.150
    33.843   404.699     0.150
    35.636   423.801     0.150
    35.636   423.832     0.150
    36.372   425.051     0.150
    36.372   425.000     0.150
    36.567   423.621     0.150
    36.490   428.598     0.150
    38.210   441.699     0.150
    38.332   441.000     0.150
    38.501   443.898     0.150
    38.597   446.328     0.150
    38.695   443.098     0.150
    38.695   443.098     0.150
    38.902   445.711     0.150
    40.010   455.258     0.150
    40.255   458.199     0.150
   124.309   462.148     0.150
   124.309   460.980     0.150
    41.550   468.500     0.150
    42.381   475.598     0.150
    42.533   476.969     0.150
    42.575   475.680     0.150
    42.575   477.098     0.150
    42.765   479.199     0.150
    42.795   478.000     0.150
    43.117   479.918     0.150
    44.410   491.898     0.150
    44.410   491.398     0.150
    44.410   491.859     0.150
    56.159   505.488     0.150
    56.159   504.020     0.150
    46.817   507.699     0.150
    46.817   509.141     0.150
    46.817   507.738     0.150
    46.732   509.141     0.150
    48.861   525.699     0.150
    49.713   534.668     0.150
    52.038   549.871     0.150
    52.383   551.898     0.150
    53.429   560.199     0.150
    53.429   561.500     0.150
    54.415   568.199     0.150
    54.415   568.199     0.150
    54.550   567.320     0.150
    56.443   584.398     0.150
    57.152   585.898     0.150
    59.132   600.000     0.150
    59.132   599.988     0.150
    61.866   619.398     0.150
    68.643   662.398     0.150
    68.643   662.410     0.150
    69.477   667.320     0.150
    73.133   690.738     0.150
    75.581   704.898     0.150
    80.751   732.570     0.150
    97.999   734.301     0.150
    80.814   733.598     0.150
    80.955   735.230     0.150
    81.536   736.371     0.150
    67.129   741.230     0.150
    87.548   767.430     0.150
     3.550    56.434     0.150
     4.980    63.375     0.150
     5.555    84.664     0.150
     5.907    93.359     0.150
     5.907    85.906     0.150
     5.907    85.805     0.150
     5.984    95.141     0.150
     6.240    93.133     0.150
    46.892   102.293     0.150
     7.129   105.406     0.150
     7.129   105.105     0.150
     7.129   105.055     0.150
     8.915   129.004     0.150
     8.915   129.004     0.150
     9.264   134.203     0.150
     9.477   136.305     0.150
     9.739   140.305     0.150
    10.001   143.105     0.150
    10.394   145.184     0.150
    10.648   151.703     0.150
    10.770   154.203     0.150
    10.770   270.203     0.150
    10.770   153.906     0.150
    10.985   155.805     0.150
    11.053   162.766     0.150
    11.297   166.066     0.150
    12.657   179.336     0.150
    12.657   317.082     0.150
    12.657   178.953     0.150
    12.657   179.203     0.150
    12.657   179.156     0.150
    12.657   179.266     0.150
    13.475   190.055     0.150
    13.932   196.504     0.150
    13.779   198.691     0.150
    14.108   198.465     0.150
    14.356   201.605     0.150
    14.520   203.605     0.150
    14.645   206.305     0.150
    14.645   363.105     0.150
    15.076   211.383     0.150
    15.338   214.105     0.150
    15.642   221.203     0.150
    15.642   221.203     0.150
    15.642   386.004     0.150
    15.708   219.703     0.150
    15.780   219.805     0.150
    16.007   225.605     0.150
    16.007   396.504     0.150
    16.354   227.805     0.150
    16.163   224.906     0.150
    16.327   227.805     0.150
    17.229   239.605     0.150
    17.499   246.074     0.150
    18.091   251.156     0.150
    18.091   251.203     0.150
    19.326   265.305     0.150
    19.326   265.234     0.150
    19.326     4.012     0.150
    19.400   265.605     0.150
    19.400   265.574     0.150
    19.319   487.203     0.150
    19.331   271.887     0.150
    20.028   276.309     0.150
    20.028   276.305     0.150
    20.135   276.098     0.150
    20.135   277.457     0.150
    20.135   276.055     0.150
    20.661   278.605     0.150
    21.061   285.906     0.150
    21.125   286.484     0.150
    21.125   284.906     0.150
    21.278   290.605     0.150
    21.430   288.266     0.150
    21.852   294.422     0.150
    21.852   293.203     0.150
    21.852   294.406     0.150
    21.852   541.004     0.150
    21.852     4.199     0.150
    21.914   289.105     0.150
    22.307   302.246     0.150
    22.736   551.496     0.150
    23.009   307.703     0.150
    23.668   313.305     0.150
    25.215   326.203     0.150
    25.985   333.305     0.150
    26.932   388.605     0.150
    27.273   346.617     0.150
    27.743   349.406     0.150
    28.276   355.117     0.150
    28.570   357.402     0.150
    28.570   357.406     0.150
    28.570   357.684     0.150
    28.841   361.004     0.150
    28.841   361.012     0.150
    28.892   361.934     0.150
    29.320   365.816     0.150
    84.137   366.703     0.150
    29.935   370.488     0.150
    30.198   372.578     0.150
    30.446     3.602     0.150
    30.875   377.855     0.150
    30.875   377.855     0.150
    30.875   446.676     0.150
    30.875   797.324     0.150
    30.875   377.805     0.150
    30.875   437.703     0.150
    30.875   682.203     0.150
    30.875   782.305     0.150
    31.017   380.344     0.150
    31.352   383.605     0.150
    31.485   384.344     0.150
    31.737   386.801     0.150
    32.352   391.953     0.150
    32.389   392.742     0.150
    33.145   400.434     0.150
    33.752   405.105     0.150
    33.788   403.953     0.150
    34.054   411.605     0.150
    33.939   404.605     0.150
    35.339   420.703     0.150
    35.580   419.605     0.150
    35.582   420.461     0.150
    35.912   422.203     0.150
    35.916   423.633     0.150
    36.235   425.605     0.150
    36.435   425.305     0.150
    36.435   425.305     0.150
    36.438   426.105     0.150
    36.526   428.004     0.150
    36.629   429.672     0.150
    36.814   429.605     0.150
    37.584   429.906     0.150
    38.007   438.105     0.150
    38.086   429.605     0.150
    38.086   441.004     0.150
    38.154   442.004     0.150
    38.272   441.703     0.150
    38.395   442.605     0.150
    38.561     2.801     0.150
    38.577   445.004     0.150
    39.327   450.504     0.150
    39.985   456.434     0.150
    39.985   456.516     0.150
    39.985   455.945     0.150
    40.229   458.605     0.150
    40.517   459.996     0.150
    40.570   461.906     0.150
   124.253   464.363     0.150
   124.253   462.355     0.150
    40.961   464.105     0.150
    41.268   465.203     0.150
    41.248   466.574     0.150
    41.503   467.805     0.150
    41.492   468.203     0.150
    41.858   470.316     0.150
    41.939   471.945     0.150
    41.939   472.004     0.150
    42.348   475.105     0.150
    42.326   475.004     0.150
    42.435   479.316     0.150
    42.435   479.805     0.150
    42.707   478.504     0.150
    43.085   481.906     0.150
    43.085   483.715     0.150
    43.467   485.203     0.150
    44.350   491.305     0.150
    44.353   491.434     0.150
    44.353   491.316     0.150
    44.353   491.504     0.150
    44.353   491.305     0.150
    44.610   493.203     0.150
    45.614   504.613     0.150
    45.614   504.898     0.150
    45.614   501.504     0.150
    45.614   501.504     0.150
    56.216   507.395     0.150
    47.058   513.176     0.150
    48.465   523.605     0.150
    48.843   527.523     0.150
    49.744   529.305     0.150
    49.744     9.398     0.150
    49.744   643.703     0.150
    49.744   696.906     0.150
    49.744  1253.305     0.150
    50.270   535.273     0.150
    50.270   537.203     0.150
    50.247   537.203     0.150
    51.979   550.375     0.150
    52.380   552.504     0.150
    52.439   553.105     0.150
    52.439   553.805     0.150
    54.392   568.234     0.150
    54.392   567.805     0.150
    54.392   567.715     0.150
    54.584   569.305     0.150
    54.584   569.176     0.150
    56.405   582.504     0.150
    57.197   587.953     0.150
    58.198   596.535     0.150
    58.315   594.703     0.150
    59.097   604.684     0.150
    59.097   603.781     0.150
    59.097   601.766     0.150
    59.097   604.484     0.150
    59.097   604.516     0.150
    59.970   607.406     0.150
    60.305   610.234     0.150
    60.487   610.406     0.150
    60.489   610.246     0.150
    62.781   630.285     0.150
    66.334   648.504     0.150
    66.334   648.805     0.150
    66.351   653.156     0.150
    66.629   650.906     0.150
    67.002   657.125     0.150
    67.890   659.305     0.150
    68.138   665.020     0.150
    68.499   666.605     0.150
    68.612   664.227     0.150
    68.612   666.934     0.150
    68.612   664.203     0.150
    70.047   674.066     0.150
    70.147   676.254     0.150
    71.052   683.086     0.150
    71.831   685.324     0.150
    71.831   683.246     0.150
    71.831   684.934     0.150
    73.641   697.445     0.150
    74.369   698.703     0.150
    75.644   709.586     0.150
    76.690   712.504     0.150
    78.349   720.766     0.150
    80.258   730.703     0.150
    97.993   734.227     0.150
    80.823   734.406     0.150
    80.811   734.176     0.150
    82.244   745.695     0.150
    83.135   746.805     0.150
    83.448   749.078     0.150
    86.511   764.152     0.150
    89.585   778.203     0.150
    89.888   779.105     0.150
    93.189   792.844     0.150
    93.189   792.805     0.150
    97.434   814.504     0.150
   115.201  1120.406     0.150
   127.647  1146.613     0.150
   131.819  1154.406     0.150
   142.250  1171.906     0.150
     1.486    46.387     0.150
     1.834    33.527     0.150
     3.960    61.836     0.150
     4.526    73.273     0.150
     5.056    64.086     0.150
     5.839    82.707     0.150
     7.114   101.039     0.150
     8.886   125.008     0.150
     9.407   131.977     0.150
    10.760   154.969     0.150
    10.760   274.504     0.150
    10.957   157.520     0.150
    12.631   175.492     0.150
    14.688   202.164     0.150
    14.688   359.059     0.150
    14.911   215.188     0.150
    18.128   256.039     0.150
    19.338   263.797     0.150
    19.553   264.199     0.150
    19.553   264.777     0.150
    20.023   270.523     0.150
    25.144   321.809     0.150
    25.113   322.246     0.150
    35.200   416.988     0.150
    36.553   423.770     0.150
     1.861    32.707     0.150
     2.052    34.488     0.150
     5.053    64.270     0.150
    41.137   466.305     0.150
    87.524   764.805     0.150
     1.655    29.973     0.150
     2.331    39.875     0.150
     4.504    82.098     0.150
    25.151   327.449     0.150
     1.695    29.836     0.150
     3.953    62.355     0.150
     4.520    83.090     0.150
     5.048    63.605     0.150
     6.238    93.477     0.150
     5.002    63.414     0.150
    46.863   102.496     0.150
     8.926   129.625     0.150
     9.271   132.523     0.150
     9.463   134.715     0.150
    10.016   142.023     0.150
    10.662   151.223     0.150
    10.789   153.023     0.150
    10.789   271.223     0.150
    10.789   153.926     0.150
    12.669   180.223     0.150
    12.669   180.035     0.150
    13.486   187.625     0.150
    13.486   187.594     0.150
    14.117   199.453     0.150
    14.363   200.824     0.150
    14.679   202.285     0.150
    14.679   358.895     0.150
    15.665   218.723     0.150
    16.041   220.871     0.150
    16.041   391.422     0.150
    16.172   226.324     0.150
    18.084   250.125     0.150
    19.350   479.574     0.150
    19.354   265.223     0.150
    19.354     4.012     0.150
    19.413   264.523     0.150
    19.413   266.074     0.150
    21.443   287.285     0.150
    21.886   292.445     0.150
    21.886   531.223     0.150
    22.279   294.086     0.150
    23.033   306.426     0.150
    23.033   306.324     0.150
    28.595   360.223     0.150
    28.602   356.824     0.150
    31.766   386.926     0.150
    35.920   419.344     0.150
    35.920   419.324     0.150
    36.849   431.355     0.150
    36.849   431.324     0.150
    37.641   437.223     0.150
    39.684   451.836     0.150
    40.263   457.125     0.150
    41.518   468.223     0.150
    52.005   548.625     0.150
    52.005   548.613     0.150
    54.427   567.926     0.150
    64.404   633.574     0.150
    73.638   690.746     0.150
    87.582   770.723     0.150
     1.546    28.246     0.150
     2.661    45.148     0.150
    16.086   389.672     0.150
    36.494   421.945     0.150
     3.558    55.633     0.150
     4.537    82.691     0.150
     1.668    30.906     0.150
     1.668    31.297     0.150
     1.985    33.785     0.150
     5.013    64.387     0.150
     6.223    92.004     0.150
    87.572   765.285     0.150
    89.597   779.242     0.150
     1.433    26.656     0.150
     1.623    28.750     0.150
     3.909    61.664     0.150
     4.499    82.055     0.150
     4.995    63.758     0.150
     5.915    88.609     0.150
    46.859   103.117     0.150
     7.186   105.906     0.150
     7.186   183.406     0.150
     8.964   129.805     0.150
     8.964   129.703     0.150
     9.481   138.258     0.150
    10.055   143.906     0.150
    10.701   151.805     0.150
    10.829   275.562     0.150
    10.829   153.406     0.150
    10.829   275.609     0.150
    10.829   153.906     0.150
    11.034   155.805     0.150
    12.708   179.609     0.150
    13.524   191.633     0.150
    14.154   199.430     0.150
    14.713   370.414     0.150
    14.713   207.406     0.150
    14.713   370.406     0.150
    15.706   393.750     0.150
    15.706   219.703     0.150
    15.706   393.703     0.150
    16.073   224.805     0.150
    16.073   394.305     0.150
    16.209   224.906     0.150
    18.048   250.289     0.150
    18.048   250.305     0.150
    18.198   249.109     0.150
    19.452   266.305     0.150
    19.629   443.633     0.150
    20.196   276.625     0.150
    21.482   288.664     0.150
    21.919   312.008     0.150
    25.218   326.906     0.150
    25.995   333.609     0.150
    28.613   357.508     0.150
    32.383   392.109     0.150
    33.789   404.203     0.150
    37.018   432.984     0.150
    38.575   443.500     0.150
    38.575   442.938     0.150
    38.979   446.250     0.150
    39.975   454.648     0.150
    40.047   456.703     0.150
    40.047   455.406     0.150
    40.291   458.289     0.150
    40.291   458.305     0.150
    42.375   473.805     0.150
    49.803   529.703     0.150
    50.242   540.398     0.150
    50.242   540.406     0.150
    52.003   550.133     0.150
    54.455   568.508     0.150
    60.366   611.398     0.150
    68.552   663.508     0.150
    71.771   682.109     0.150
    71.916   682.289     0.150
    78.416   719.555     0.150
    89.557   776.906     0.150
    23.049   303.469     0.150
    25.202   324.320     0.150
    36.596   422.969     0.150
     1.523    28.019     0.150
     1.882    33.898     0.150
     3.543    56.288     0.150
     4.574    71.229     0.150
     5.088    65.019     0.150
     6.029    89.948     0.150
     6.207    92.969     0.150
    11.790   173.049     0.150
    14.739   358.776     0.150
    14.789   210.318     0.150
    15.682   382.465     0.150
    16.106   226.429     0.150
    18.115   249.038     0.150
    19.382   266.448     0.150
    20.056   271.651     0.150
    20.163   272.599     0.150
    20.163   271.651     0.150
    20.163   276.198     0.150
    21.946   294.358     0.150
    33.994   400.148     0.150
    33.994     4.400     0.150
    35.252   415.438     0.150
    36.776   431.668     0.150
    38.097   438.408     0.150
    42.448   474.448     0.150
    96.994   552.708     0.150
     2.420    41.610     0.150
     4.594    84.186     0.150
    16.126   401.485     0.150
     4.139    67.012     0.150
     5.053    65.109     0.150
     6.249    93.922     0.150
    10.753   153.324     0.150
    14.679   358.742     0.150
    16.044   223.109     0.150
    20.015   270.465     0.150
    22.107   299.449     0.150
     1.461    26.941     0.150
     3.568    56.562     0.150
     5.694    85.383     0.150
    12.634   323.375     0.150
    12.634   180.062     0.150
    19.328   480.879     0.150
     4.552    83.207     0.150
    16.106   227.262     0.150
     2.353    39.773     0.150
     3.515    54.773     0.150
     4.592    83.750     0.150
     4.659    70.574     0.150
    16.135   398.738     0.150
     1.387    25.848     0.150
     1.770    32.270     0.150
     2.268    38.949     0.150
     4.944    62.121     0.150
     5.969    88.250     0.150
     5.969    88.148     0.150
    46.902   105.480     0.150
     7.222   105.750     0.150
     7.222   105.648     0.150
     7.712   120.020     0.150
     9.007   129.949     0.150
     9.007   129.949     0.150
     9.354   134.648     0.150
     9.354   134.551     0.150
    10.095   143.949     0.150
    10.741   153.250     0.150
    10.864   154.348     0.150
    10.864   272.949     0.150
    10.864   154.551     0.150
    11.078   156.348     0.150
    13.567   192.129     0.150
    14.199   199.277     0.150
    14.446   204.051     0.150
    14.652   210.551     0.150
    14.711   208.051     0.150
    14.711   364.348     0.150
    14.711   210.168     0.150
    15.733   216.297     0.150
    15.733   216.250     0.150
    16.254   225.613     0.150
    16.254   225.750     0.150
    18.001   249.250     0.150
    19.493   263.531     0.150
    19.493   266.848     0.150
    20.121   272.723     0.150
    20.121   272.750     0.150
    21.169   285.449     0.150
    21.523   288.758     0.150
    21.918   541.148     0.150
    21.918   568.750     0.150
    22.003     2.699     0.150
    25.212   327.848     0.150
    25.271   326.551     0.150
    28.570   358.949     0.150
    35.559   420.848     0.150
    36.473   423.328     0.150
    36.667   425.199     0.150
    41.527   469.848     0.150
    49.837   534.949     0.150
    50.359   539.750     0.150
    52.523   555.750     0.150
    87.631   768.250     0.150
    89.603   779.777     0.150
    89.603   779.750     0.150
     1.455    26.951     0.150
     1.693    53.461     0.150
     1.693    29.851     0.150
     3.930    61.881     0.150
     5.027    62.831     0.150
     6.392    95.461     0.150
    46.846   102.091     0.150
     7.133   105.741     0.150
    42.560   475.011     0.150
     1.852    33.600     0.150
     1.737    53.799     0.150
     3.987    62.908     0.150
     4.541    70.680     0.150
     6.269    93.668     0.150
    46.792   101.449     0.150
     7.084   104.889     0.150
     7.225   107.760     0.150
     8.786   131.738     0.150
     9.193   132.199     0.150
     9.700   138.898     0.150
     9.781   140.299     0.150
     9.948   142.498     0.150
    10.357   144.559     0.150
    10.357   144.498     0.150
    10.593   150.898     0.150
    10.731   152.998     0.150
    10.731   153.199     0.150
    10.923   155.100     0.150
    10.897   160.488     0.150
    10.897   160.600     0.150
    12.598   178.689     0.150
    12.540   188.680     0.150
    13.412   189.209     0.150
    13.888   195.898     0.150
    14.040   197.799     0.150
    14.285   200.789     0.150
    14.285   200.799     0.150
    14.458   203.838     0.150
    14.458   203.799     0.150
    14.680   204.199     0.150
    14.680   363.699     0.150
    14.778   212.799     0.150
    15.007   210.709     0.150
    15.272   214.498     0.150
    15.644   219.398     0.150
    15.713   220.299     0.150
    16.286   227.799     0.150
    16.097   223.898     0.150
    16.270   227.398     0.150
    17.210   239.898     0.150
    17.386   240.818     0.150
    17.575   244.709     0.150
    17.575   244.799     0.150
    18.164   251.998     0.150
    19.344   265.498     0.150
    19.344   265.578     0.150
    19.419   265.699     0.150
    19.521   267.600     0.150
    20.512   502.725     0.150
    20.623   278.799     0.150
    21.018   283.498     0.150
    21.373   287.568     0.150
    21.377   294.799     0.150
    21.840   287.299     0.150
    21.887   294.398     0.150
    21.887   294.389     0.150
    21.887     2.400     0.150
    23.405   312.799     0.150
    23.774   314.100     0.150
    25.085   325.328     0.150
    25.110     3.039     0.150
    26.713   344.100     0.150
    26.713   627.998     0.150
    26.951   394.898     0.150
    27.009   610.699     0.150
    27.528   350.469     0.150
    27.528   350.498     0.150
    28.656   357.998     0.150
    28.663   357.299     0.150
    29.421   367.299     0.150
    84.102   371.600     0.150
    31.450   384.100     0.150
    31.586   385.338     0.150
    31.837   387.100     0.150
    32.454   390.328     0.150
    32.454   390.299     0.150
    32.939     3.000     0.150
    33.242   399.439     0.150
    33.290   397.199     0.150
    33.779   403.859     0.150
    33.849   406.199     0.150
    33.887   403.498     0.150
    33.961     3.600     0.150
    34.261   409.100     0.150
    34.342   410.414     0.150
    34.932   415.908     0.150
    34.932   415.898     0.150
    35.208   415.229     0.150
    35.595   420.305     0.150
    35.681   421.561     0.150
    36.101   423.619     0.150
    36.333   425.898     0.150
    36.328   424.328     0.150
    36.534   426.199     0.150
    36.621   428.799     0.150
    36.782   428.398     0.150
    36.876   430.199     0.150
    37.087   431.420     0.150
    37.707   438.498     0.150
    37.988   449.100     0.150
    38.084   439.049     0.150
    38.084   574.879     0.150
    38.102   438.799     0.150
    38.638   445.600     0.150
    38.739   446.100     0.150
    38.739   446.100     0.150
    39.713   454.145     0.150
    40.372   461.068     0.150
    40.617   460.865     0.150
    40.662   462.689     0.150
   124.353   463.930     0.150
   124.353   460.219     0.150
    41.010   465.139     0.150
    41.059   464.898     0.150
    41.309   468.199     0.150
    41.309   468.209     0.150
    41.545   467.998     0.150
    41.583   467.799     0.150
    41.595   468.898     0.150
    41.782   470.398     0.150
    42.005   470.789     0.150
    42.257   478.600     0.150
    42.257   850.898     0.150
    42.425   474.699     0.150
    42.594   480.408     0.150
    42.809   479.199     0.150
    42.746   480.049     0.150
    42.766   481.898     0.150
    43.886   490.998     0.150
    44.455   491.398     0.150
    44.455   491.959     0.150
    44.710   493.898     0.150
    44.811   496.600     0.150
    45.671   502.158     0.150
    56.127   505.449     0.150
    56.127   504.449     0.150
    48.555   524.979     0.150
    48.889   526.699     0.150
    49.143   526.398     0.150
    50.351   537.398     0.150
    52.083   550.578     0.150
    52.083   550.498     0.150
    52.083   550.609     0.150
    54.445   568.199     0.150
    54.445   568.199     0.150
    55.265   577.369     0.150
    55.184   574.998     0.150
   110.992   585.350     0.150
    58.203   596.549     0.150
    59.142   601.129     0.150
    60.364   609.600     0.150
    60.364   609.600     0.150
    60.364   611.059     0.150
    67.227   654.498     0.150
    68.651   663.770     0.150
    71.867   682.998     0.150
    76.705   711.299     0.150
    79.576   728.498     0.150
    80.822   734.398     0.150
    80.706   736.350     0.150
    81.151   737.898     0.150
    83.441   747.998     0.150
    87.503   767.998     0.150
    87.506   767.959     0.150
    89.482   777.799     0.150
    89.930   779.398     0.150
   131.925  1155.898     0.150
     1.698    29.816     0.150
     1.837    33.508     0.150
     4.528    70.617     0.150
     4.528    83.895     0.150
     5.057    64.348     0.150
     5.634    85.797     0.150
     5.841    88.418     0.150
     5.841    88.418     0.150
    46.813   101.477     0.150
    46.813   104.645     0.150
     7.119   104.316     0.150
     8.890   128.316     0.150
     9.232   132.816     0.150
     9.408   138.145     0.150
     9.985   142.617     0.150
    10.630   150.918     0.150
    10.765   153.016     0.150
    10.962   155.016     0.150
    12.636   317.738     0.150
    12.636   321.918     0.150
    12.636   178.918     0.150
    12.636   179.156     0.150
    13.450   188.117     0.150
    14.079   197.457     0.150
    14.324   199.316     0.150
    14.693   205.715     0.150
    14.693   365.918     0.150
    15.649   216.117     0.150
    16.058   222.395     0.150
    16.058   222.449     0.150
    16.135   224.016     0.150
    17.556   244.715     0.150
    19.344   265.918     0.150
    19.348     4.430     0.150
    19.382   265.117     0.150
    19.558   268.117     0.150
    20.028   501.516     0.150
    20.028   272.617     0.150
    20.135   275.496     0.150
    20.135     4.371     0.150
    21.050   285.117     0.150
    21.410   287.758     0.150
    21.880   283.418     0.150
    21.900   532.188     0.150
    21.900   294.617     0.150
    21.900   557.918     0.150
    21.900   294.555     0.150
    22.659   551.926     0.150
    23.367   310.418     0.150
    23.367   317.316     0.150
    23.745   314.117     0.150
    26.060   334.418     0.150
    26.946   388.016     0.150
    26.946   397.516     0.150
    27.003   343.668     0.150
    27.003   343.688     0.150
    28.647   357.215     0.150
    28.920   362.516     0.150
    84.090   367.117     0.150
    30.949   377.625     0.150
    30.949   377.625     0.150
    30.949   446.656     0.150
    30.949   797.777     0.150
    30.949   377.617     0.150
    30.949   437.918     0.150
    30.949   681.918     0.150
    30.949   782.715     0.150
    31.430   383.816     0.150
    31.564   385.547     0.150
    31.674   385.867     0.150
    31.816   387.918     0.150
    32.334   391.117     0.150
    32.431   392.418     0.150
    32.974   397.418     0.150
    32.974     4.199     0.150
    33.030   398.438     0.150
    33.223   400.141     0.150
    33.830   405.816     0.150
    33.867   405.016     0.150
    34.000     2.402     0.150
    34.323   409.035     0.150
    35.204   415.625     0.150
    35.658   420.215     0.150
    35.661   421.141     0.150
    35.882   422.117     0.150
    36.313   425.617     0.150
    36.359   424.348     0.150
    36.516   426.816     0.150
    36.604   428.215     0.150
    36.877   430.016     0.150
    38.055   439.645     0.150
    38.064   571.766     0.150
    38.064   439.598     0.150
    38.064   571.766     0.150
    38.085   438.816     0.150
    38.164   441.016     0.150
    38.233   441.117     0.150
    38.351   443.117     0.150
    38.505   444.617     0.150
    38.505   444.125     0.150
    38.505     3.801     0.150
    38.640   445.316     0.150
    38.915   449.438     0.150
    39.406   450.918     0.150
    40.045   456.375     0.150
    40.045   456.375     0.150
    40.595   460.625     0.150
    40.647   462.617     0.150
   124.332   463.188     0.150
    40.795   462.836     0.150
    41.040   464.715     0.150
    41.468   466.875     0.150
    41.524   467.918     0.150
    41.575   467.316     0.150
    41.575   467.316     0.150
    41.570   468.617     0.150
    42.296   477.516     0.150
    42.414   475.535     0.150
    42.404   475.418     0.150
    42.471   475.797     0.150
    42.589   478.316     0.150
    42.786   479.316     0.150
    42.834   478.328     0.150
    43.024   482.418     0.150
    44.432   492.117     0.150
    56.167   506.527     0.150
    50.315   537.215     0.150
    52.057   550.336     0.150
    52.057   550.695     0.150
    52.394   551.918     0.150
    52.967   560.168     0.150
    53.445   559.988     0.150
    54.450   568.316     0.150
    54.450   568.336     0.150
    59.836   607.816     0.150
    59.836   607.758     0.150
    60.447   610.875     0.150
    60.447   610.918     0.150
    62.957   626.336     0.150
    67.189   653.945     0.150
    67.189   653.918     0.150
    71.833   682.066     0.150
    71.833   682.117     0.150
    78.593   720.445     0.150
    80.195   729.168     0.150
    83.178   746.867     0.150
    87.529   767.516     0.150
    89.506   777.816     0.150
    89.940   781.516     0.150
     1.509    28.371     0.150
     1.750    31.059     0.150
     1.843    34.191     0.150
     4.531    70.602     0.150
     5.085    64.648     0.150
     5.800    88.250     0.150
     5.800    88.250     0.150
    46.799   102.031     0.150
     7.069   104.352     0.150
     7.069   104.352     0.150
     7.462   109.852     0.150
     8.839   128.449     0.150
     8.839   128.352     0.150
     9.180   133.148     0.150
     9.180   133.051     0.150
     9.370   136.750     0.150
     9.370   136.762     0.150
     9.684   139.648     0.150
     9.766   141.949     0.150
     9.934   142.648     0.150
     9.966   145.633     0.150
    10.342   145.051     0.150
    10.579   151.148     0.150
    10.715   153.352     0.150
    10.715   269.352     0.150
    10.715   153.051     0.150
    10.854   151.621     0.150
    10.910   154.551     0.150
    10.914   158.551     0.150
    11.890   170.992     0.150
    12.174   315.410     0.150
    12.585   178.621     0.150
    12.585   320.566     0.150
    12.585   178.641     0.150
    12.585   178.648     0.150
    12.585   178.551     0.150
    12.672   183.332     0.150
    12.959   183.859     0.150
    13.399   188.969     0.150
    13.873   196.648     0.150
    14.028   197.371     0.150
    14.316   202.750     0.150
    14.444   202.551     0.150
    14.444   365.949     0.150
    14.664   205.852     0.150
    14.773   213.684     0.150
    14.995   210.840     0.150
    15.259   213.648     0.150
    15.602   216.648     0.150
    15.631   218.648     0.150
    15.700   219.352     0.150
    15.700   394.551     0.150
    16.273   227.449     0.150
    16.084   222.551     0.150
    16.256   227.648     0.150
    17.194   239.352     0.150
    17.333   241.949     0.150
    17.567   244.488     0.150
    19.302   470.676     0.150
    19.306   265.051     0.150
    19.412   490.148     0.150
    19.506   266.949     0.150
    20.086   274.852     0.150
    20.086   274.852     0.150
    20.413   279.352     0.150
    20.607   278.352     0.150
    20.955   285.352     0.150
    21.019   283.449     0.150
    21.359   287.750     0.150
    21.611   294.500     0.150
    21.828   282.148     0.150
    21.828    19.703     0.150
    21.828   525.949     0.150
    21.871   294.949     0.150
    21.871   294.910     0.150
    23.771   313.648     0.150
    23.771   314.891     0.150
    25.108   326.750     0.150
    25.108   326.777     0.150
    26.997   354.250     0.150
    26.997   343.949     0.150
    26.997   343.949     0.150
    27.368   347.895     0.150
    27.575   346.949     0.150
    27.744   354.367     0.150
    27.838   352.020     0.150
    28.365   356.684     0.150
    28.646   358.250     0.150
    28.653   358.391     0.150
    28.653   358.660     0.150
    28.653   358.898     0.150
    28.747   360.453     0.150
    28.935   362.852     0.150
    28.940   362.039     0.150
    28.986   363.664     0.150
    29.414   367.148     0.150
    29.414   367.156     0.150
    29.680   369.180     0.150
    84.119   368.148     0.150
    30.030   371.918     0.150
    30.289   374.117     0.150
    30.949   378.352     0.150
    30.949   378.352     0.150
    30.949   447.391     0.150
    30.949   799.160     0.150
    30.949   378.352     0.150
    30.949   438.551     0.150
    30.949   683.250     0.150
    30.949   784.051     0.150
    31.117   381.453     0.150
    31.443   384.449     0.150
    31.580   385.672     0.150
    31.580   385.672     0.150
    31.614   385.090     0.150
    31.830   388.055     0.150
    32.343   392.148     0.150
    32.395   391.379     0.150
    32.447   393.281     0.150
    32.479   394.121     0.150
    32.518   393.148     0.150
    33.280   397.750     0.150
    33.350   399.949     0.150
    33.840   406.750     0.150
    33.880   405.473     0.150
    33.880   405.539     0.150
    33.953   400.750     0.150
    34.334   409.363     0.150
    34.413   408.711     0.150
    34.925   414.852     0.150
    34.980   412.250     0.150
    35.195   416.512     0.150
    69.453   417.039     0.150
    35.587   420.977     0.150
    35.668   420.602     0.150
    35.668   421.246     0.150
    35.673   420.949     0.150
    36.093   424.172     0.150
    36.196   424.648     0.150
    36.223   425.297     0.150
    36.330   424.648     0.150
    36.325   426.051     0.150
    36.396   427.648     0.150
    36.526   427.148     0.150
    36.613   429.449     0.150
    36.621   429.051     0.150
    36.727   429.750     0.150
    36.743   430.750     0.150
    36.862   430.352     0.150
    37.699   438.051     0.150
    38.077   440.781     0.150
    38.077   575.121     0.150
    38.094   439.148     0.150
    38.176   441.352     0.150
    38.176   441.352     0.150
    38.372   443.551     0.150
    38.459     2.941     0.150
    38.624   445.648     0.150
    38.730   446.551     0.150
    38.730   446.551     0.150
    38.730   539.250     0.150
    39.236   816.449     0.150
    39.710   455.352     0.150
    40.026   457.031     0.150
    40.610   461.078     0.150
    40.652   462.949     0.150
   124.346   462.191     0.150
   124.346   461.898     0.150
    41.052   465.750     0.150
    41.294   467.191     0.150
    41.537   468.250     0.150
    41.571   468.250     0.150
    41.590   469.051     0.150
    23.072   470.961     0.150
    41.642   471.250     0.150
    42.010   472.980     0.150
    42.010   472.961     0.150
    42.417   475.988     0.150
    42.417   475.449     0.150
    42.460   475.629     0.150
    42.804   478.949     0.150
    43.114   482.762     0.150
    43.550   486.262     0.150
    43.880     6.602     0.150
    44.449   492.449     0.150
    44.703   494.352     0.150
    45.685   501.648     0.150
    56.118   505.078     0.150
    56.118   504.430     0.150
    46.780   508.789     0.150
    46.780   508.828     0.150
    48.545   525.031     0.150
    48.873   528.172     0.150
    48.873   528.141     0.150
    48.873   526.750     0.150
    49.690   533.051     0.150
    49.690     9.102     0.150
    49.690   643.949     0.150
    49.690   695.250     0.150
    49.690  1258.250     0.150
    50.353   538.602     0.150
    50.353   537.750     0.150
    52.078   550.512     0.150
    52.344   552.750     0.150
    96.915   555.930     0.150
    53.393   560.449     0.150
    54.430   568.750     0.150
    59.157   601.922     0.150
    59.784   606.301     0.150
    59.992   607.852     0.150
    60.349   610.551     0.150
    60.349   611.660     0.150
    68.208   662.059     0.150
    68.666   664.191     0.150
    71.119   680.410     0.150
    76.688   712.648     0.150
    78.071   719.352     0.150
    79.218   725.750     0.150
    80.010   730.262     0.150
    80.711   734.102     0.150
    82.138   739.926     0.150
    82.888   747.621     0.150
    83.424   748.852     0.150
    84.211   754.449     0.150
    87.508   768.102     0.150
    89.914   779.648     0.150
    92.390   791.648     0.150
    93.223   794.750     0.150
   142.344  1172.359     0.150
     1.527    27.746     0.150
     4.574    70.946     0.150
     5.093    64.116     0.150
     5.815    88.106     0.150
     5.815    88.076     0.150
     5.815    88.196     0.150
     5.815    88.076     0.150
     5.892    89.176     0.150
    46.771   101.406     0.150
     7.132   104.936     0.150
     7.132   104.976     0.150
     7.132   104.876     0.150
     7.132   106.896     0.150
     8.894   128.776     0.150
     8.894   128.676     0.150
     9.231   132.976     0.150
     9.380   136.896     0.150
     9.749   141.276     0.150
     9.830   143.076     0.150
     9.994   142.376     0.150
     9.941   263.145     0.150
    10.407   144.906     0.150
    10.407   144.876     0.150
    10.486   276.231     0.150
    10.567   153.094     0.150
    10.567   156.736     0.150
    10.567   279.147     0.150
    10.638   150.476     0.150
    10.780   267.327     0.150
    10.780   153.076     0.150
    10.780   153.176     0.150
    10.810   157.166     0.150
    10.846   154.521     0.150
    10.846   154.356     0.150
    10.966   154.476     0.150
    10.982   284.767     0.150
    11.495   168.511     0.150
    11.495   302.053     0.150
    12.074   167.456     0.150
    12.574   176.066     0.150
    12.642   178.070     0.150
    12.642   176.564     0.150
    12.642   178.646     0.150
    13.130   183.306     0.150
    13.213   337.106     0.150
    13.294   191.101     0.150
    13.454   189.146     0.150
    13.741   194.756     0.150
    13.798   197.914     0.150
    13.936   195.476     0.150
    13.936   351.176     0.150
    14.043   358.476     0.150
    14.080   197.486     0.150
    14.371   201.676     0.150
    14.476   203.176     0.150
    14.500   202.276     0.150
    14.793   210.220     0.150
    14.793   211.776     0.150
    15.047   209.936     0.150
    15.102   210.276     0.150
    15.102   210.286     0.150
    15.313   212.876     0.150
    15.685   217.576     0.150
    15.754   218.576     0.150
    16.326   226.476     0.150
    16.099   223.876     0.150
    16.099   396.776     0.150
    16.315   227.176     0.150
    23.528   229.346     0.150
    17.263   239.176     0.150
    17.382   244.264     0.150
    17.592   244.006     0.150
    17.600   244.106     0.150
    17.600   244.146     0.150
    17.600   244.476     0.150
    17.926   252.476     0.150
    18.126   250.676     0.150
    19.373   483.476     0.150
    19.373   266.166     0.150
    19.377   266.276     0.150
    19.389   265.076     0.150
    19.565   266.276     0.150
    19.565  2325.376     0.150
    20.045  2324.376     0.150
    20.152   274.976     0.150
    20.152   274.721     0.150
    20.152   275.926     0.150
    20.672   278.576     0.150
    21.016   282.176     0.150
    21.417   287.526     0.150
    21.400     3.400     0.150
    21.877   277.476     0.150
    21.877   523.676     0.150
    21.939   538.776     0.150
    23.106   308.376     0.150
    23.124   306.976     0.150
    23.124   307.976     0.150
    27.837   311.956     0.150
    27.837   570.666     0.150
    23.688   572.076     0.150
    23.784   313.937     0.150
    23.784   314.376     0.150
    23.784   316.159     0.150
    23.784   314.616     0.150
    24.494   322.516     0.150
    25.117   325.176     0.150
    25.135  2304.977     0.150
    25.135   325.076     0.150
    25.538   329.649     0.150
    25.538   329.646     0.150
    26.095   334.376     0.150
    26.724   342.921     0.150
    26.991   350.776     0.150
    26.991   398.676     0.150
    26.991   713.176     0.150
    27.048   383.276     0.150
    27.048   396.576     0.150
    27.048   343.436     0.150
    27.048   343.776     0.150
    27.048   343.821     0.150
    27.048   343.746     0.150
    27.392   349.229     0.150
    27.394   347.688     0.150
    27.547   348.055     0.150
    27.547   348.476     0.150
    27.547   348.576     0.150
    27.578   348.676     0.150
    27.578   348.686     0.150
    27.639   348.466     0.150
    27.794   351.471     0.150
   106.384   352.056     0.150
    28.202   357.776     0.150
    28.802   352.846     0.150
    28.398   356.315     0.150
    28.685   357.676     0.150
    28.692   357.787     0.150
    28.692   357.666     0.150
    28.692   357.776     0.150
    28.692   357.676     0.150
    28.816   359.689     0.150
    28.829   364.301     0.150
    28.966   363.412     0.150
    28.973   361.976     0.150
    29.028   361.560     0.150
    29.362   364.276     0.150
    29.556   366.371     0.150
    29.556   366.576     0.150
    29.556   366.600     0.150
    84.050   366.976     0.150
    29.726   366.464     0.150
    29.990   370.176     0.150
    30.012   370.576     0.150
    30.018   372.676     0.150
    30.018   372.681     0.150
    30.056   373.176     0.150
    30.320   374.778     0.150
    30.314   371.370     0.150
    30.622   377.415     0.150
    30.626   376.763     0.150
    30.729   376.676     0.150
    30.811   379.540     0.150
    30.995   378.436     0.150
    30.995   378.436     0.150
    30.995   447.246     0.150
    30.995   805.216     0.150
    30.995   378.376     0.150
    30.995   439.176     0.150
    30.995   683.976     0.150
    30.995   786.976     0.150
    30.995   805.176     0.150
    31.136   380.676     0.150
    31.136   380.776     0.150
    31.136   380.801     0.150
    31.144   386.396     0.150
    31.214   380.576     0.150
    31.244   383.549     0.150
    31.265   382.343     0.150
    31.285   384.282     0.150
    31.473   386.076     0.150
    31.606   387.076     0.150
    31.697   385.176     0.150
    31.859   388.371     0.150
    32.189   390.646     0.150
    32.187   391.510     0.150
    32.378   393.676     0.150
    32.402   389.576     0.150
    32.473   391.376     0.150
    32.511   393.795     0.150
    32.782   390.676     0.150
    32.943     4.800     0.150
    32.943   716.276     0.150
    32.943   830.976     0.150
    33.267   400.883     0.150
    33.322   397.576     0.150
    33.579   397.592     0.150
    33.579   401.626     0.150
    33.599   404.123     0.150
    33.635   402.436     0.150
    33.789   401.126     0.150
    33.888  2269.602     0.150
    33.874   406.176     0.150
    33.910   405.146     0.150
    33.984     5.500     0.150
    33.961   914.476     0.150
    34.075   406.276     0.150
    34.229   407.116     0.150
    34.305   408.366     0.150
    34.338   410.386     0.150
    34.338   410.376     0.150
    34.367   409.342     0.150
    34.937   414.676     0.150
    34.990   748.176     0.150
    34.955   415.014     0.150
    35.137   741.976     0.150
    35.249  2263.136     0.150
    35.249   415.296     0.150
    35.249   415.276     0.150
    69.434   414.406     0.150
    35.315   415.596     0.150
    35.323   417.676     0.150
    35.438  2262.556     0.150
    35.438   416.836     0.150
    35.438   416.876     0.150
    35.461   418.576     0.150
    35.461   418.476     0.150
    35.499   419.976     0.150
    35.619   421.391     0.150
    35.702   422.576     0.150
    35.702   420.021     0.150
    35.704   420.997     0.150
    35.882   420.876     0.150
    35.882   421.796     0.150
    36.068   421.266     0.150
    36.068   421.174     0.150
    36.123   423.626     0.150
    36.230   424.676     0.150
    36.255   426.776     0.150
    36.323   423.396     0.150
    36.323   423.396     0.150
    36.301   423.565     0.150
    36.369   423.856     0.150
    36.369     2.910     0.150
    36.357   425.576     0.150
    36.422   425.976     0.150
    36.517  2257.926     0.150
    36.517   425.176     0.150
    36.560   428.476     0.150
    36.560   427.376     0.150
    36.609   425.983     0.150
    36.648   430.566     0.150
    36.648   430.576     0.150
    36.656   428.676     0.150
    36.762   429.776     0.150
    36.778   430.276     0.150
    36.796   429.364     0.150
    36.921   429.776     0.150
    36.952   429.505     0.150
    36.974   431.176     0.150
    37.108   431.239     0.150
    37.582   435.056     0.150
    37.654   436.676     0.150
    37.677   435.506     0.150
    37.695   436.376     0.150
    37.705   437.276     0.150
    37.732   437.676     0.150
    37.830   438.276     0.150
    38.019     3.300     0.150
    38.019   800.176     0.150
    37.977   438.176     0.150
    37.977   438.206     0.150
    38.048   440.256     0.150
    38.108   441.159     0.150
    38.108   440.496     0.150
    38.129   438.676     0.150
    38.208   441.016     0.150
    38.208   440.976     0.150
    38.208   440.976     0.150
    38.250   440.376     0.150
    38.250   521.286     0.150
    38.250   440.476     0.150
    38.276   441.676     0.150
    38.391   442.737     0.150
    38.391   442.776     0.150
    38.391   442.376     0.150
    38.487     4.600     0.150
    38.506   442.506     0.150
    38.663   444.706     0.150
    38.667   443.264     0.150
    38.684   445.976     0.150
    38.766   445.676     0.150
    38.766   534.276     0.150
    38.766   540.276     0.150
    38.766   540.276     0.150
    38.766   544.076     0.150
    38.766   554.276     0.150
    38.766   801.276     0.150
    38.766   801.276     0.150
    39.019   449.076     0.150
    39.041   449.196     0.150
    38.879   446.726     0.150
    39.180   450.346     0.150
    39.223   448.995     0.150
    39.277     3.000     0.150
    39.448   451.376     0.150
    39.466   451.676     0.150
    39.481   452.236     0.150
    39.524   452.756     0.150
    39.551   452.366     0.150
    39.693   454.036     0.150
    39.753   455.276     0.150
    39.776   454.529     0.150
    39.805   452.951     0.150
    39.962   456.976     0.150
    40.089   457.086     0.150
    40.089   457.146     0.150
    40.089   456.626     0.150
    40.089   457.126     0.150
    40.333   547.356     0.150
    40.333   830.660     0.150
    40.333   458.076     0.150
    40.423   573.076     0.150
    40.452   827.576     0.150
    40.450   460.197     0.150
   124.375   460.636     0.150
   124.375   460.596     0.150
    40.692   461.476     0.150
    40.692   461.426     0.150
    41.096   841.142     0.150
    41.083   464.276     0.150
    62.941   466.576     0.150
    41.127   466.316     0.150
    41.198     5.800     0.150
    41.384   466.456     0.150
    41.384   854.386     0.150
    41.571   469.956     0.150
    41.621   468.276     0.150
    23.090   470.586     0.150
    41.662   469.446     0.150
    41.662   468.976     0.150
    41.662   469.426     0.150
    41.662   574.368     0.150
    41.685   470.806     0.150
    42.058   473.366     0.150
    42.058   818.146     0.150
    42.058   473.036     0.150
    42.242     8.100     0.150
    42.340  1030.156     0.150
    42.448   475.876     0.150
    42.448   475.976     0.150
    42.448   476.576     0.150
    42.431   477.276     0.150
    42.431   476.326     0.150
    42.431   477.616     0.150
    42.588   849.876     0.150
    42.626   478.076     0.150
    42.731   476.486     0.150
    42.877   479.376     0.150
    43.026   482.016     0.150
    43.026   482.296     0.150
    43.068   481.826     0.150
    43.068   482.676     0.150
    43.077   481.246     0.150
    43.586   484.276     0.150
    43.654   487.186     0.150
    43.905     3.700     0.150
    44.026   490.586     0.150
    44.193   491.176     0.150
    44.324   490.576     0.150
    44.300   492.256     0.150
    44.300   877.606     0.150
    44.384   492.726     0.150
    44.474   491.996     0.150
    44.474   491.976     0.150
    45.014   496.056     0.150
    45.248   501.986     0.150
    45.580   500.196     0.150
    45.628   501.476     0.150
    45.628   503.440     0.150
    45.628   501.396     0.150
    45.993   906.876     0.150
    56.154   504.126     0.150
    56.154   504.124     0.150
    56.154   503.756     0.150
    46.751   508.146     0.150
    46.875   510.076     0.150
    47.042     3.600     0.150
    47.227   514.276     0.150
    38.835   516.876     0.150
    48.018   944.676     0.150
    48.586   525.266     0.150
    48.586   524.576     0.150
    48.586   525.646     0.150
    48.586   525.236     0.150
    48.717   526.296     0.150
    48.756   526.516     0.150
    48.946   527.876     0.150
    48.946     3.500     0.150
    48.939   527.666     0.150
    48.939   527.486     0.150
    48.939   527.176     0.150
    49.184     4.000     0.150
    49.184   960.576     0.150
    49.141   529.701     0.150
    49.239   528.176     0.150
    49.545   531.423     0.150
    49.755   700.776     0.150
    49.755   968.176     0.150
    49.755  1257.276     0.150
    49.755   532.216     0.150
    50.256   535.697     0.150
    50.307   536.506     0.150
    50.307   537.366     0.150
    50.342   537.916     0.150
    50.343   537.666     0.150
    50.343   538.226     0.150
    50.343   537.676     0.150
    50.623   540.276     0.150
    51.066   543.976     0.150
    51.248   543.362     0.150
    51.358   548.906     0.150
    51.424   546.216     0.150
    51.424   545.276     0.150
    51.897   550.661     0.150
    52.097   550.236     0.150
    52.097   551.666     0.150
    52.323   551.276     0.150
    52.384   552.376     0.150
    96.986   555.646     0.150
    96.986   555.389     0.150
    96.986   552.956     0.150
    52.677   554.656     0.150
    54.453   568.276     0.150
    54.703   569.356     0.150
    55.130   573.946     0.150
    55.507   576.136     0.150
    55.758   579.676     0.150
    55.841   580.816     0.150
    56.374   780.676     0.150
    56.374  1267.876     0.150
    56.454   583.576     0.150
    56.933   587.566     0.150
    58.149   594.336     0.150
    58.256   594.486     0.150
    58.534   598.676     0.150
    58.714  1086.276     0.150
    59.094   603.014     0.150
    59.094   605.866     0.150
    59.094   600.956     0.150
    59.094   600.936     0.150
    59.094   601.646     0.150
    59.838   824.176     0.150
    59.838   605.696     0.150
    60.013   606.996     0.150
    60.060   608.176     0.150
    60.060   608.996     0.150
    60.301   610.055     0.150
    60.437   609.316     0.150
    60.437   609.276     0.150
    60.411   610.536     0.150
    60.439  2381.839     0.150
    60.439   609.776     0.150
    60.890   612.726     0.150
    60.929   615.346     0.150
    61.881   620.776     0.150
    61.881   620.796     0.150
    62.819   627.206     0.150
    62.933   622.676     0.150
    62.933   760.876     0.150
    62.933   856.176     0.150
    62.933  1209.576     0.150
    62.933  1541.676     0.150
    63.307   625.806     0.150
    63.492   632.156     0.150
    64.001   635.146     0.150
    64.019   630.946     0.150
    64.317   637.306     0.150
    66.332   649.676     0.150
    66.332   648.046     0.150
    66.528   645.376     0.150
    66.528  1216.876     0.150
    66.738   651.671     0.150
    66.738   651.726     0.150
    66.738   651.616     0.150
    66.738   651.776     0.150
    66.885   651.896     0.150
    66.885  1239.676     0.150
    66.889   648.971     0.150
    67.210   654.651     0.150
    67.210   654.046     0.150
    67.210   653.966     0.150
    67.583   657.076     0.150
    68.005   660.196     0.150
    68.149   660.656     0.150
    68.497   665.156     0.150
    68.601   665.676     0.150
    68.601   663.626     0.150
    68.601   663.546     0.150
    69.099   666.526     0.150
    69.430   669.996     0.150
    70.045   669.596     0.150
    69.932   673.276     0.150
    71.059   679.776     0.150
    71.817   682.626     0.150
    71.817   683.576     0.150
    72.508   684.616     0.150
    74.431   699.026     0.150
    74.431   699.076     0.150
    74.431   700.656     0.150
    74.475   698.576     0.150
    74.942   702.476     0.150
    76.540   710.876     0.150
    76.758   711.876     0.150
    78.142   719.676     0.150
    78.102   720.736     0.150
    78.163   721.584     0.150
    78.406  2338.876     0.150
    78.406   720.176     0.150
    78.978   724.776     0.150
    79.085   725.016     0.150
    79.289   725.276     0.150
    79.767   728.226     0.150
    80.314   731.276     0.150
    98.071   733.966     0.150
    98.071   734.416     0.150
    80.876   734.176     0.150
    81.018   735.766     0.150
    81.124   737.171     0.150
    81.600     0.080     0.150
    81.593   739.176     0.150
    82.140   741.176     0.150
    67.081   741.116     0.150
   105.922   742.466     0.150
    31.473   741.456     0.150
   123.888   743.006     0.150
    50.310   745.356     0.150
    83.216  2326.151     0.150
    83.267   748.703     0.150
    83.494   749.376     0.150
   102.825   751.116     0.150
    84.088   751.266     0.150
    84.843   754.676     0.150
    84.879   755.606     0.150
    87.489   768.076     0.150
    87.537   768.976     0.150
    89.465   776.476     0.150
    89.981   779.776     0.150
    91.057   786.876     0.150
    92.459   791.576     0.150
    93.288   795.176     0.150
    94.411   802.246     0.150
    96.625   811.276     0.150
   127.850   817.696     0.150
    98.960   822.076     0.150
    85.157   822.126     0.150
   101.880   836.764     0.150
   103.795   855.781     0.150
   107.347  1800.901     0.150
   116.098  1125.015     0.150
   116.324  1125.176     0.150
   116.749  1123.826     0.150
   105.083  1131.876     0.150
   121.224  1134.376     0.150
    67.078  1136.796     0.150
    67.078  1135.256     0.150
    71.023  1135.976     0.150
    35.051  1139.996     0.150
    35.051  1137.976     0.150
   123.700  1132.789     0.150
    37.732  1139.376     0.150
   124.402  1138.291     0.150
   124.402  1724.021     0.150
   125.949  1143.576     0.150
    32.495  1145.176     0.150
   126.642  1143.476     0.150
   127.728  2103.776     0.150
   128.418  1146.416     0.150
   129.732  1154.714     0.150
   131.924  1155.151     0.150
   134.248  1162.596     0.150
   142.304  1176.276     0.150
   142.304  1165.626     0.150
   147.167  1188.226     0.150
     1.566    29.635     0.150
     1.566    49.455     0.150
     1.764    32.435     0.150
     2.351    41.835     0.150
     2.879    47.455     0.150
     3.105    52.635     0.150
     3.616    56.715     0.150
     3.925    63.935     0.150
     4.040    62.885     0.150
     4.099    66.335     0.150
     4.592    84.260     0.150
     4.592    84.255     0.150
     4.751    74.335     0.150
     4.861    73.655     0.150
     5.140    66.295     0.150
     5.756    86.335     0.150
     5.756    86.335     0.150
     5.756    88.715     0.150
     5.741    87.735     0.150
    46.739   102.565     0.150
     7.074   105.535     0.150
     7.074   105.435     0.150
     8.831   128.235     0.150
     9.167   133.735     0.150
     9.167   133.735     0.150
     9.324   135.965     0.150
     9.933   142.935     0.150
    10.576   150.835     0.150
    10.722   269.435     0.150
    10.722   153.835     0.150
    10.903   154.835     0.150
    10.864   161.935     0.150
    14.016   197.715     0.150
    14.016   197.715     0.150
    14.259   201.035     0.150
    14.709   207.235     0.150
    14.709   367.835     0.150
    14.831   213.229     0.150
    15.619   218.535     0.150
    16.080   392.960     0.150
    17.332   240.235     0.150
    18.191   253.535     0.150
    19.329   266.335     0.150
    19.334   266.535     0.150
    20.966   283.935     0.150
    22.139   299.325     0.150
    22.457   304.695     0.150
    23.168   308.535     0.150
    23.168   308.635     0.150
    23.168   309.335     0.150
    23.571   313.855     0.150
    23.827   316.535     0.150
    25.061   325.435     0.150
    26.144   335.735     0.150
    27.055   340.335     0.150
    31.092   382.525     0.150
    31.890   390.675     0.150
    31.890   390.635     0.150
    33.663   406.525     0.150
    33.920   409.035     0.150
    33.920     5.900     0.150
    34.097   405.535     0.150
    35.076   412.335     0.150
    34.993   417.355     0.150
    35.252   416.615     0.150
    35.818   422.135     0.150
    36.110   424.425     0.150
    36.275   424.635     0.150
    36.470   425.625     0.150
    36.819   428.035     0.150
    37.140   434.041     0.150
    37.470   438.425     0.150
    37.954   435.135     0.150
    37.954   753.535     0.150
    38.093   439.575     0.150
    38.124   441.815     0.150
    38.137   441.195     0.150
    38.307   444.855     0.150
    38.307   444.835     0.150
    38.430   443.635     0.150
    38.457   445.905     0.150
    38.554   446.255     0.150
    38.554   445.505     0.150
    38.694   448.005     0.150
    38.875   446.610     0.150
    38.928   449.485     0.150
    39.212   442.535     0.150
    39.212   796.835     0.150
    39.474   453.957     0.150
    39.494   455.595     0.150
    39.837   456.504     0.150
    39.986   459.555     0.150
    40.425   462.355     0.150
   124.407   461.405     0.150
   124.407   460.285     0.150
    42.490   476.335     0.150
    43.195   484.135     0.150
    43.681   489.495     0.150
    44.508   492.435     0.150
    45.690   501.235     0.150
    56.089   507.295     0.150
    46.127   507.215     0.150
    46.125   506.775     0.150
    46.450   510.635     0.150
    46.903   513.145     0.150
    46.979   509.335     0.150
    49.396   534.335     0.150
    50.400   539.435     0.150
    51.359   544.735     0.150
    52.137   551.495     0.150
    52.137   551.535     0.150
    53.198   561.445     0.150
    56.242   584.035     0.150
    57.357   591.275     0.150
    59.153   602.585     0.150
    59.775   603.935     0.150
    63.442   629.835     0.150
    65.643   648.125     0.150
    68.009   662.375     0.150
    68.659   664.055     0.150
    71.874   683.135     0.150
    78.936   724.035     0.150
    80.834   734.135     0.150
    87.450   767.935     0.150
    87.452   768.345     0.150
    89.428   777.545     0.150
   114.054  1111.979     0.150
   115.202  1107.570     0.150
     1.507    27.779     0.150
     1.713    31.359     0.150
     3.575    55.159     0.150
     3.878    63.359     0.150
     4.545    83.709     0.150
     4.545    70.109     0.150
     8.877   131.119     0.150
    10.079   120.719     0.150
    10.215   135.729     0.150
    10.756   155.089     0.150
    10.800   147.879     0.150
    12.085   173.049     0.150
    12.055   156.489     0.150
    12.624   179.349     0.150
    14.065   201.089     0.150
    19.342   487.559     0.150
    19.342   265.859     0.150
    20.020   271.434     0.150
    35.218   415.139     0.150
    41.073   462.305     0.150
    71.841   684.479     0.150
    74.667   700.679     0.150
     1.603    28.300     0.150
     1.767    32.350     0.150
     1.944    35.850     0.150
     2.392    41.850     0.150
     2.920    45.920     0.150
     3.966    64.550     0.150
     4.077    62.510     0.150
     4.139    66.850     0.150
     4.574    72.550     0.150
     4.633    71.330     0.150
     4.752    74.150     0.150
     4.901    74.090     0.150
     5.173    64.870     0.150
     5.747    85.860     0.150
     6.314    93.730     0.150
     6.641    98.110     0.150
    10.736   272.523     0.150
    11.909   293.526     0.150
    12.585   308.869     0.150
    12.585   179.890     0.150
    15.638   389.769     0.150
    16.117   224.400     0.150
    19.355   265.010     0.150
    21.810   292.350     0.150
    23.203   304.720     0.150
    33.905   395.350     0.150
    33.905     9.500     0.150
    35.293   415.840     0.150
    38.176   440.410     0.150
    39.037   445.310     0.150
    42.522   473.460     0.150
    46.868   510.560     0.150
    89.391   775.330     0.150
     4.539    81.805     0.150
     4.539    70.615     0.150
     4.539    81.805     0.150
     5.035    64.075     0.150
     5.629    84.515     0.150
    46.817   102.984     0.150
     7.180   105.915     0.150
     9.290   135.214     0.150
    10.825   287.102     0.150
    11.021   158.205     0.150
    12.157   174.225     0.150
    12.632   179.464     0.150
    12.696   312.208     0.150
    12.696   183.546     0.150
    12.696   335.555     0.150
    12.696   179.075     0.150
    14.737   202.150     0.150
    14.740   211.595     0.150
    15.709   400.975     0.150
    16.099   218.270     0.150
    16.099   395.456     0.150
    19.400   265.274     0.150
    20.088   503.689     0.150
    52.447   552.067     0.150
    87.542   769.729     0.150
    89.516   779.395     0.150
     1.823    33.450     0.150
     4.154    66.850     0.150
     4.638    84.221     0.150
     4.638    71.359     0.150
     4.638    84.220     0.150
    14.714   210.339     0.150
    22.072   290.509     0.150
    27.640   346.419     0.150
    35.317   412.509     0.150
    43.150   479.910     0.150
    87.388   764.790     0.150
     1.732    31.568     0.150
     1.732    28.589     0.150
     1.884    32.719     0.150
     2.425    41.868     0.150
     4.574    81.934     0.150
     4.574    71.148     0.150
     5.110    65.318     0.150
     6.593    96.908     0.150
    10.747   149.257     0.150
    10.747   277.984     0.150
    12.609   172.163     0.150
    14.712   200.813     0.150
    14.712   374.730     0.150
    16.081   224.499     0.150
    16.081   219.989     0.150
    19.344   266.038     0.150
    19.532   259.368     0.150
    28.687   354.959     0.150
    28.694   356.679     0.150
    34.342   406.729     0.150
    35.241   412.136     0.150
    35.241   412.139     0.150
    35.405   413.654     0.150
    40.184   455.470     0.150
    42.459   474.108     0.150
    48.921   525.868     0.150
    51.788   546.769     0.150
    87.477   765.974     0.150
     1.807    33.533     0.150
     4.498    84.088     0.150
     4.498    70.264     0.150
     4.498    84.084     0.150
     4.498   123.613     0.150
     5.038    64.652     0.150
     5.849    85.312     0.150
    46.840   102.402     0.150
     7.099   105.113     0.150
     8.876   128.914     0.150
     9.221   132.014     0.150
     9.968   143.113     0.150
    10.743   154.113     0.150
    10.743   268.514     0.150
    10.743   154.113     0.150
    10.947   155.914     0.150
    12.620   319.053     0.150
    12.620   178.807     0.150
    12.620   178.613     0.150
    12.620   179.514     0.150
    13.436   189.014     0.150
    14.067   198.283     0.150
    14.313   203.812     0.150
    14.659   205.014     0.150
    14.659   361.812     0.150
    15.624   218.014     0.150
    15.624   386.613     0.150
    16.122   225.213     0.150
    17.293   243.312     0.150
    17.528   445.312     0.150
    18.135   250.914     0.150
    19.314   265.994     0.150
    19.319   265.613     0.150
    19.365   265.713     0.150
    19.371   488.812     0.150
    20.111   276.324     0.150
    21.003   285.414     0.150
    21.394   287.094     0.150
    21.866   539.213     0.150
    21.866   561.014     0.150
    21.866   294.914     0.150
    21.866     2.340     0.150
    23.210   304.914     0.150
    23.360   313.553     0.150
    25.157   325.213     0.150
    28.611   358.143     0.150
    28.618   358.004     0.150
    28.618   357.414     0.150
    29.373   364.812     0.150
    33.802   406.113     0.150
    33.840   404.123     0.150
    34.001     4.000     0.150
    35.170   415.504     0.150
    35.170   417.113     0.150
    35.426   418.014     0.150
    36.377   425.414     0.150
    36.377   425.494     0.150
    36.572   427.312     0.150
    36.572   427.312     0.150
    38.028   441.383     0.150
    38.037   439.164     0.150
    38.207   442.812     0.150
    38.596   447.223     0.150
    38.596   447.213     0.150
    39.099   450.982     0.150
    38.933   451.953     0.150
    42.996   482.113     0.150
    44.407   492.113     0.150
    56.164   506.074     0.150
    46.348   507.613     0.150
    48.275   521.664     0.150
    48.490   527.783     0.150
    50.304   539.414     0.150
    52.034   550.793     0.150
    54.416   568.713     0.150
    66.253   649.213     0.150
    78.345   720.764     0.150
    83.145   747.244     0.150
    83.145   750.312     0.150
    87.552   768.463     0.150
    89.906   780.113     0.150
     1.497    27.668     0.150
     1.706    29.996     0.150
     3.570    56.809     0.150
     3.972    63.105     0.150
     4.537    83.535     0.150
     5.067    62.898     0.150
     1.669    31.055     0.150
     3.547    56.297     0.150
     4.996    64.805     0.150
     5.118    79.227     0.150
    46.874   102.527     0.150
    19.333   468.602     0.150
    20.034   274.242     0.150
    52.434   551.375     0.150
     4.448    69.137     0.150
     4.448    82.520     0.150
     4.931    61.777     0.150
     6.286    94.090     0.150
    46.918   104.406     0.150
     7.707   111.668     0.150
    12.745   324.406     0.150
    14.637   203.488     0.150
    14.637   203.488     0.150
    16.050   224.547     0.150
    19.393   268.219     0.150
    19.393   488.098     0.150
    19.393   268.219     0.150
    19.393   488.098     0.150
    21.900   295.059     0.150
    22.964   301.828     0.150
    28.552   355.277     0.150
    35.149   413.938     0.150
    35.556   418.387     0.150
    36.680   427.117     0.150
    46.638   507.359     0.150
    51.619   546.340     0.150
    71.747   680.840     0.150
    83.187   746.547     0.150
    87.645   767.816     0.150
    89.618   778.020     0.150
     1.564    27.973     0.150
     1.755    31.883     0.150
     2.244    38.633     0.150
     4.925    61.574     0.150
     5.528    84.062     0.150
    16.062   226.559     0.150
     1.808    33.137     0.150
     1.742    32.117     0.150
     1.742    32.039     0.150
     3.615    57.438     0.150
     3.948    62.449     0.150
     5.053    64.777     0.150
     5.162    77.797     0.150
    46.834   102.648     0.150
    10.711   152.719     0.150
    16.004   392.383     0.150
    16.004   225.020     0.150
    16.004   392.316     0.150
    19.508   267.617     0.150
    21.844   539.020     0.150
    21.844   293.988     0.150
    25.063   324.918     0.150
    35.161   415.316     0.150
    36.556   428.918     0.150
    38.140   437.617     0.150
    38.140   437.617     0.150
     1.589    48.398     0.150
     1.794    30.699     0.150
     3.937    64.297     0.150
     4.547    72.098     0.150
     4.604    84.574     0.150
     1.438    26.750     0.150
     3.913    62.650     0.150
     4.483    81.102     0.150
     4.483   148.848     0.150
     5.009    62.801     0.150
     5.586    84.910     0.150
     6.234    93.521     0.150
    46.861   104.330     0.150
     7.235   110.791     0.150
    19.574   268.160     0.150
    20.841   283.102     0.150
    21.874   292.219     0.150
    89.555   775.199     0.150
     1.571    28.633     0.150
     1.908    34.445     0.150
     4.045    63.746     0.150
     4.596    71.773     0.150
     5.144    63.926     0.150
    46.735   102.586     0.150
    10.575   153.016     0.150
    10.901   157.094     0.150
    12.037   173.164     0.150
    12.578   181.113     0.150
    12.578   181.223     0.150
    13.389   192.195     0.150
    16.083   226.469     0.150
    16.083   226.473     0.150
    18.193   249.664     0.150
    23.173   305.406     0.150
    39.571   448.816     0.150
    74.397   697.723     0.150
     1.462    45.359     0.150
     1.813    32.840     0.150
     2.347    40.109     0.150
     3.558    56.629     0.150
     3.936    62.121     0.150
    12.644   182.152     0.150
    12.644   182.730     0.150
    25.120   327.633     0.150
    51.710   546.035     0.150
     4.438    66.836     0.150
     4.948    62.391     0.150
     5.110    77.059     0.150
     5.532    83.852     0.150
    46.915   103.332     0.150
    46.915   102.582     0.150
     7.163   105.988     0.150
     7.746   118.211     0.150
    12.645   177.172     0.150
    12.694   180.129     0.150
    14.656   365.969     0.150
    17.280   242.629     0.150
    18.052   252.621     0.150
    18.052   252.520     0.150
    21.158   286.641     0.150
    21.953   296.910     0.150
    34.094   398.211     0.150
    36.662   428.648     0.150
    36.662   428.770     0.150
    40.060   454.336     0.150
   124.230   465.629     0.150
    41.464   471.250     0.150
    47.084   513.531     0.150
    54.395   566.699     0.150
    60.106   606.141     0.150
    80.838   735.930     0.150
     1.799    31.562     0.150
     2.304    39.672     0.150
     2.799    44.750     0.150
     3.488    54.070     0.150
     3.901    59.992     0.150
     4.748    71.094     0.150
     4.986    71.242     0.150
     6.314    88.980     0.150
     7.189   103.832     0.150
    13.013   184.750     0.150
    52.480   551.703     0.150
     1.406    26.074     0.150
     1.632    28.836     0.150
     1.632    51.145     0.150
     2.288    38.715     0.150
     4.465    82.215     0.150
     4.465    69.914     0.150
     4.465    82.215     0.150
     4.972    62.543     0.150
     5.927   152.254     0.150
     5.927    86.414     0.150
    46.889   102.645     0.150
     7.168   104.613     0.150
     7.068   106.773     0.150
     9.299   133.312     0.150
     9.299   236.914     0.150
     9.495   136.695     0.150
    10.040   143.414     0.150
    10.686   151.715     0.150
    10.810   154.113     0.150
    11.023   155.613     0.150
    10.853   155.285     0.150
    13.009   182.203     0.150
    13.512   190.535     0.150
    14.144   198.074     0.150
    14.508   201.492     0.150
    14.671   206.043     0.150
    14.671   212.016     0.150
    14.671   212.016     0.150
    16.199   228.215     0.150
    17.305   242.312     0.150
    17.502   244.344     0.150
    18.056   251.793     0.150
    18.056   251.812     0.150
    19.360   266.043     0.150
    19.364   265.414     0.150
    19.438   266.113     0.150
    19.614   483.891     0.150
    20.174   276.164     0.150
    21.137   284.414     0.150
    21.468   288.613     0.150
    21.884   532.805     0.150
    21.884   294.312     0.150
    21.884   294.375     0.150
    22.056   294.516     0.150
    22.027   299.113     0.150
    23.662   313.812     0.150
    25.159   325.914     0.150
    25.233   327.016     0.150
    25.351    11.898     0.150
    28.573   356.914     0.150
    28.573   356.914     0.150
    28.580   357.176     0.150
    28.580   356.715     0.150
    84.105   366.812     0.150
    30.888   377.766     0.150
    30.888   377.766     0.150
    30.888   448.055     0.150
    30.888   680.023     0.150
    30.888   797.125     0.150
    30.888   377.715     0.150
    30.888   438.613     0.150
    30.888   448.016     0.150
    30.888   680.016     0.150
    30.888   781.812     0.150
    30.888   797.113     0.150
    32.354   391.016     0.150
    32.395   393.715     0.150
    32.395   393.703     0.150
    33.151   398.523     0.150
    33.301   397.883     0.150
    34.250   409.008     0.150
    35.155   414.645     0.150
    35.504   417.715     0.150
    39.191   418.844     0.150
    35.586   423.215     0.150
    35.586   423.188     0.150
    37.991   439.266     0.150
    37.991   573.594     0.150
    40.254   457.516     0.150
   124.256   462.402     0.150
    40.965   464.113     0.150
    51.654   546.945     0.150
    52.471   552.715     0.150
    66.373   648.016     0.150
    66.373   648.215     0.150
    68.572   663.195     0.150
    71.792   682.562     0.150
    78.386   721.113     0.150
    81.001   735.445     0.150
    83.486   748.812     0.150
    87.610   767.793     0.150
    87.610   771.414     0.150
    87.613   768.176     0.150
    89.585   777.812     0.150
     2.998    50.465     0.150
     4.504    80.469     0.150
     3.572    55.553     0.150
     4.522    81.934     0.150
     5.055    63.783     0.150
     6.246    93.395     0.150
     1.529    27.805     0.150
     4.556    83.508     0.150
     4.556    71.766     0.150
     4.556    83.508     0.150
     5.103    63.641     0.150
    46.777   100.312     0.150
    46.777   101.227     0.150
    12.591   317.461     0.150
    18.173   254.047     0.150
    18.173     3.570     0.150
    19.320   482.250     0.150
    19.320   264.438     0.150
    19.320   482.242     0.150
    20.099   275.797     0.150
    21.830   296.531     0.150
    21.894     3.633     0.150
    25.081   324.203     0.150
    35.220   414.844     0.150
    40.165   455.266     0.150
    51.777   548.375     0.150
     1.558    50.850     0.150
     1.558    28.820     0.150
     3.619    57.430     0.150
     3.914    61.450     0.150
     4.581    71.200     0.150
     4.581   124.650     0.150
     5.122    77.310     0.150
     5.132    63.860     0.150
     5.761    88.240     0.150
     5.761    87.850     0.150
     5.761   158.605     0.150
    46.749   100.610     0.150
    46.749   100.990     0.150
     7.069   103.850     0.150
     7.069   104.250     0.150
     9.165   132.550     0.150
     9.165   132.550     0.150
     9.329   136.850     0.150
     9.329   245.854     0.150
     9.329   136.890     0.150
     9.329   136.850     0.150
     9.686   139.850     0.150
     9.766   142.050     0.150
     9.929   141.450     0.150
     9.961   255.158     0.150
    10.345   144.350     0.150
    10.547   268.590     0.150
    10.573   150.050     0.150
    10.628   156.746     0.150
    10.717   152.650     0.150
    10.717   152.250     0.150
    10.900   153.750     0.150
    10.906   157.480     0.150
    10.906   157.260     0.150
    10.906   157.420     0.150
    10.960   158.350     0.150
    11.042   279.255     0.150
    12.106   167.430     0.150
    12.577   176.930     0.150
    12.577   177.520     0.150
    12.577   176.750     0.150
    12.577   177.120     0.150
    12.577   177.090     0.150
    12.967   186.568     0.150
    13.052   186.250     0.150
    13.161   190.920     0.150
    13.175   189.950     0.150
    13.175   189.620     0.150
    13.388   187.170     0.150
    13.539   357.890     0.150
    13.746   196.150     0.150
    13.873   195.950     0.150
    14.014   196.770     0.150
    14.237   374.690     0.150
    14.257   199.050     0.150
    14.306   200.450     0.150
    14.428   202.220     0.150
    14.428   201.750     0.150
    14.411   202.050     0.150
    14.411   366.250     0.150
    14.434   202.450     0.150
    14.434   363.150     0.150
    14.639   205.510     0.150
    14.698   206.650     0.150
    14.822   213.210     0.150
    14.822   213.250     0.150
    14.822   213.250     0.150
    14.822   213.150     0.150
    14.981   209.450     0.150
    15.247   212.750     0.150
    15.247   382.350     0.150
    15.297   215.400     0.150
    15.620   217.850     0.150
    15.620   392.250     0.150
    15.688   218.650     0.150
    15.688   393.450     0.150
    16.260   226.650     0.150
    16.069   399.276     0.150
    16.069   224.250     0.150
    16.069   399.250     0.150
    16.250   226.350     0.150
    23.593   231.150     0.150
    16.682   236.440     0.150
    17.206   238.250     0.150
    17.322   242.250     0.150
    17.440   243.747     0.150
    17.618   245.110     0.150
    17.618   245.010     0.150
    17.618   244.480     0.150
    18.213     1.161     0.150
    18.192   251.440     0.150
    18.192   251.345     0.150
    18.905     3.870     0.150
    19.185   486.250     0.150
    19.324   263.750     0.150
    19.324   264.500     0.150
    19.321   482.055     0.150
    19.321   482.060     0.150
    19.325   264.550     0.150
    19.500   266.950     0.150
    19.500   267.050     0.150
    19.500   486.780     0.150
    19.500   266.450     0.150
    19.463   486.850     0.150
    19.482   270.061     0.150
    19.482   275.150     0.150
    19.797   499.950     0.150
    20.091   274.070     0.150
    20.544   280.300     0.150
    20.544   499.425     0.150
    20.909   283.450     0.150
    20.973   282.550     0.150
    21.420   530.550     0.150
    21.811     3.189     0.150
    21.905   294.190     0.150
    21.905   534.070     0.150
    21.905   294.250     0.150
    21.905   294.250     0.150
    22.194   302.100     0.150
    22.371   303.750     0.150
    22.452   306.470     0.150
    23.160   307.427     0.150
    23.446   311.250     0.150
    23.446   316.150     0.150
    27.872   312.270     0.150
    27.872   570.030     0.150
    23.565   311.550     0.150
    23.819   314.334     0.150
    23.819   314.250     0.150
    23.819   314.250     0.150
    24.899   327.120     0.150
    25.066   592.850     0.150
    25.073   597.245     0.150
    25.073   324.730     0.150
    25.368   327.360     0.150
    26.402   628.580     0.150
    26.985   347.450     0.150
    26.985   393.250     0.150
    26.985   403.550     0.150
    27.044   343.270     0.150
    27.044   343.390     0.150
    27.418   347.475     0.150
    27.572   348.869     0.150
    27.799   351.240     0.150
    27.813   352.290     0.150
    27.888   352.290     0.150
    27.949   351.557     0.150
    28.357   356.443     0.150
    28.447   357.760     0.150
    28.500   355.618     0.150
    28.696  2289.050     0.150
    28.696   357.820     0.150
    28.696   357.750     0.150
    28.703   358.160     0.150
    28.703   358.050     0.150
    28.703   357.900     0.150
    28.703   357.867     0.150
    28.703   357.950     0.150
    28.703   358.031     0.150
    28.796   359.863     0.150
    28.893   361.240     0.150
    26.383   360.190     0.150
    28.985   362.750     0.150
    28.985   362.795     0.150
    28.990   363.039     0.150
    29.249   365.268     0.150
    29.464   367.080     0.150
    29.597   365.750     0.150
    29.597   365.743     0.150
    84.084   367.750     0.150
    30.080   372.550     0.150
    30.080   372.567     0.150
    30.340   373.788     0.150
    30.361   374.670     0.150
    30.538   375.010     0.150
    30.644   376.964     0.150
    30.837   378.645     0.150
    30.888   376.795     0.150
    30.999   379.370     0.150
    30.999   379.370     0.150
    30.999   449.380     0.150
    30.999   793.120     0.150
    30.999   802.570     0.150
    30.999   379.350     0.150
    30.999   440.350     0.150
    30.999   449.350     0.150
    30.999   685.350     0.150
    30.999   793.050     0.150
    30.999   802.550     0.150
    31.143   381.790     0.150
    31.166   380.557     0.150
    31.166   381.361     0.150
    31.265   381.852     0.150
    31.291   381.950     0.150
    31.291   381.993     0.150
    31.598   384.498     0.150
    31.630   386.247     0.150
    31.664   384.537     0.150
    31.772   385.270     0.150
    31.880   387.713     0.150
    32.189   391.590     0.150
    32.189   390.350     0.150
    32.189     0.513     0.150
    32.132   389.329     0.150
    32.302   390.645     0.150
    32.385   391.921     0.150
    32.394   392.470     0.150
    32.394   392.450     0.150
    32.472   391.240     0.150
    32.497   392.599     0.150
    32.513   394.670     0.150
    32.515   392.691     0.150
    32.565   395.840     0.150
    32.628   392.772     0.150
    32.763   703.850     0.150
    33.206   398.700     0.150
    33.237   398.796     0.150
    33.329   397.900     0.150
    33.329   397.950     0.150
    33.397   400.050     0.150
    33.655   402.300     0.150
    33.824   404.210     0.150
    33.923     9.101     0.150
    33.923   725.150     0.150
    33.891   407.250     0.150
    33.930   406.524     0.150
    33.972   958.550     0.150
    33.997   405.250     0.150
    34.087   407.050     0.150
    34.239   408.340     0.150
    34.239   408.410     0.150
    34.225   407.980     0.150
    34.354   409.330     0.150
    34.354   409.350     0.150
    34.463   410.010     0.150
    34.939   742.850     0.150
    34.863   416.290     0.150
    34.975   412.950     0.150
    35.080   742.350     0.150
    35.241   416.370     0.150
    35.372   417.250     0.150
    35.340   417.850     0.150
    39.287   417.888     0.150
    35.441   418.850     0.150
    35.719   419.228     0.150
    35.816   421.050     0.150
    35.816   420.857     0.150
    35.816   421.320     0.150
    36.144   424.660     0.150
    36.315   759.650     0.150
    36.319     2.960     0.150
    36.247   425.350     0.150
    36.273   425.091     0.150
    36.478   568.600     0.150
    36.478   425.410     0.150
    36.478   425.350     0.150
    36.526   427.790     0.150
    36.526   427.750     0.150
    36.576   770.550     0.150
    36.576   428.450     0.150
    36.663   429.550     0.150
    36.671   429.750     0.150
    36.777   430.850     0.150
    36.793   429.950     0.150
    36.793   429.950     0.150
    36.808   429.550     0.150
    36.808   433.070     0.150
    36.808   429.940     0.150
    36.863   509.450     0.150
    36.863   926.750     0.150
    36.992   431.450     0.150
    37.090   432.750     0.150
    37.468   438.400     0.150
    37.468   528.450     0.150
    37.531   435.550     0.150
    37.671   437.150     0.150
    37.697   436.784     0.150
    37.710   435.450     0.150
    37.724   774.750     0.150
    37.724   438.050     0.150
    37.848   439.180     0.150
    37.954   795.550     0.150
    37.994   440.380     0.150
    38.084   440.940     0.150
    38.114   441.050     0.150
    38.118   441.350     0.150
    38.127   441.450     0.150
    38.127   438.575     0.150
    38.127   572.650     0.150
    38.127   438.580     0.150
    38.219   438.930     0.150
    38.226   441.450     0.150
    38.427   954.250     0.150
    38.349   443.300     0.150
    38.421   444.350     0.150
    38.667   445.950     0.150
    38.684   445.950     0.150
    38.686   445.550     0.150
    38.780   446.658     0.150
    38.780   446.750     0.150
    38.780   555.750     0.150
    38.780   577.750     0.150
    38.780   804.750     0.150
    38.780   804.750     0.150
    38.780  1007.750     0.150
    38.866   446.230     0.150
    39.133   448.410     0.150
    39.035   449.710     0.150
    39.035   448.950     0.150
    39.135   450.340     0.150
    39.212   967.350     0.150
    39.240   450.808     0.150
    39.510   454.520     0.150
    39.713   454.430     0.150
    39.760   457.590     0.150
    39.872   457.590     0.150
    39.972     3.120     0.150
    39.897   460.100     0.150
    39.988   458.420     0.150
    40.068   457.460     0.150
    40.068   456.490     0.150
    40.068   456.450     0.150
    40.167   460.930     0.150
    40.357   469.350     0.150
    40.313   581.330     0.150
    40.383   461.770     0.150
   124.397   461.200     0.150
   124.397   460.880     0.150
    40.631   455.908     0.150
    40.675   462.330     0.150
    40.696   463.530     0.150
    41.137   836.550     0.150
    41.102   468.445     0.150
    41.129   467.630     0.150
    62.881   468.300     0.150
    41.297   470.690     0.150
    41.588   469.100     0.150
    41.619   467.750     0.150
    41.619   467.750     0.150
    41.640   469.970     0.150
    23.121   471.240     0.150
    41.669   470.070     0.150
    41.681   474.003     0.150
    41.682   469.250     0.150
    41.682   469.558     0.150
    41.682   469.570     0.150
    42.058   473.070     0.150
    42.177     3.500     0.150
    42.177     7.000     0.150
    42.443   476.270     0.150
    42.534   848.750     0.150
    42.495   476.530     0.150
    42.495   477.750     0.150
    42.495   476.539     0.150
    42.495   476.680     0.150
    42.468   476.050     0.150
    42.468   479.100     0.150
    42.514   477.480     0.150
    42.665   478.500     0.150
    42.733     4.600     0.150
    42.997   481.330     0.150
    43.086   486.800     0.150
    43.140   481.460     0.150
    43.140   484.820     0.150
    43.185   481.770     0.150
    43.174   483.050     0.150
    43.398   484.860     0.150
    43.600   487.150     0.150
    43.962   592.090     0.150
    44.110   489.810     0.150
    44.258     2.770     0.150
    44.209   492.900     0.150
    44.387   884.550     0.150
    44.499   495.600     0.150
    44.767   494.920     0.150
    44.966     3.790     0.150
    45.693   502.000     0.150
    45.693   500.120     0.150
    45.693   502.250     0.150
    45.693   502.170     0.150
    45.693   501.930     0.150
    56.091   503.488     0.150
    56.091   504.760     0.150
    56.091   504.030     0.150
    46.116   505.330     0.150
    46.730   507.610     0.150
    47.201   515.550     0.150
    47.558   517.110     0.150
    47.755   518.650     0.150
    47.842   520.000     0.150
    48.016   523.220     0.150
    48.016   521.842     0.150
    48.595   525.350     0.150
    48.595   525.360     0.150
    48.595   524.550     0.150
    48.595   527.620     0.150
    48.881   529.850     0.150
    48.911   525.300     0.150
    48.911   526.970     0.150
    49.193   530.610     0.150
    49.693   531.950     0.150
    49.693   532.350     0.150
    49.693   699.550     0.150
    49.693  1254.850     0.150
    49.856   961.650     0.150
    50.251   536.280     0.150
    50.251   536.750     0.150
    50.273   539.440     0.150
    50.289   537.970     0.150
    50.289   541.630     0.150
    50.394   538.400     0.150
    50.394   538.520     0.150
    50.394   542.050     0.150
    50.394   538.450     0.150
    50.991   545.700     0.150
    51.360   545.450     0.150
    51.609     4.800     0.150
    51.841   548.438     0.150
    51.806   548.040     0.150
    52.128   551.020     0.150
    52.128   550.960     0.150
    52.128   551.080     0.150
    52.128   550.950     0.150
    52.128   551.160     0.150
    52.259   552.260     0.150
    52.320   552.350     0.150
    52.350   554.510     0.150
    52.350   553.150     0.150
    96.943   554.803     0.150
    96.943   555.010     0.150
    53.189   559.960     0.150
    54.221   570.295     0.150
    54.324   569.150     0.150
    54.447   568.200     0.150
    54.447   572.870     0.150
    54.471   567.750     0.150
    55.183   573.530     0.150
    55.803   577.640     0.150
   111.013   581.709     0.150
   111.013   583.310     0.150
    56.554   585.400     0.150
    56.514   588.112     0.150
    58.202   594.500     0.150
    58.202   591.760     0.150
    58.648   589.850     0.150
    59.158   602.310     0.150
    59.158   601.790     0.150
    59.158   603.640     0.150
    59.158   601.820     0.150
    59.484   608.760     0.150
    59.772   824.950     0.150
    59.772   605.250     0.150
    59.949   607.360     0.150
    59.949   607.230     0.150
    60.028   608.750     0.150
    60.028   612.420     0.150
    60.028   608.860     0.150
    60.238   609.510     0.150
    60.373   609.710     0.150
    60.373   609.340     0.150
    60.373   609.350     0.150
    60.375  2382.150     0.150
    60.375   608.450     0.150
    60.825   612.960     0.150
    60.981   613.160     0.150
    61.097   618.847     0.150
    62.868   861.250     0.150
    62.809   624.750     0.150
    62.844   629.080     0.150
    63.072   624.550     0.150
    63.032   630.670     0.150
    63.435   634.920     0.150
    63.712  1150.250     0.150
    63.712  1384.550     0.150
    63.963   633.550     0.150
    64.078   636.580     0.150
    64.665   635.930     0.150
    65.632   642.910     0.150
    66.268   647.060     0.150
    66.420   651.520     0.150
    66.723   652.160     0.150
    66.723   651.350     0.150
    66.723   651.420     0.150
    66.851   649.254     0.150
    66.820   651.660     0.150
    66.820  1445.050     0.150
    66.820  1620.650     0.150
    67.048   652.250     0.150
    67.268   655.050     0.150
    67.873   663.950     0.150
    67.873   663.950     0.150
    68.021   665.040     0.150
    68.021   665.040     0.150
    68.129   665.460     0.150
    68.129   665.460     0.150
    68.155   664.510     0.150
    68.214   661.650     0.150
    68.214   661.670     0.150
    68.214   661.720     0.150
    68.206   664.400     0.150
    68.235   665.510     0.150
    68.240   667.300     0.150
    68.240   667.300     0.150
    68.561   662.480     0.150
    68.664   664.275     0.150
    68.664   666.460     0.150
    68.664   664.220     0.150
    68.808   672.110     0.150
    68.808   672.110     0.150
    68.823   668.980     0.150
    68.910   669.580     0.150
    68.920   668.800     0.150
    69.249   673.990     0.150
    69.249   673.990     0.150
    69.287   672.690     0.150
    69.287   672.690     0.150
    69.511   673.970     0.150
    69.511   673.970     0.150
    69.575   675.270     0.150
    69.575   675.270     0.150
    69.575   673.945     0.150
    69.708   675.100     0.150
    69.708   675.100     0.150
    70.109   675.430     0.150
    69.805   675.350     0.150
    69.864   676.990     0.150
    69.864   676.990     0.150
    69.995   670.264     0.150
    69.995   675.170     0.150
    69.934   676.640     0.150
    69.934   676.640     0.150
    69.935   675.000     0.150
    69.957   676.790     0.150
    69.957   676.790     0.150
    71.063   682.750     0.150
    71.124   683.095     0.150
    71.275   682.750     0.150
    71.879   684.760     0.150
    71.879   682.740     0.150
    73.513   690.705     0.150
    73.513   695.620     0.150
    75.344   697.360     0.150
    76.452   707.450     0.150
    76.714   710.900     0.150
    77.107   717.260     0.150
    77.107   717.370     0.150
    78.092   724.020     0.150
    78.147   723.220     0.150
    78.357   720.350     0.150
    80.687   732.725     0.150
    98.031   734.590     0.150
    81.658   740.350     0.150
    82.189   745.058     0.150
    83.256   747.095     0.150
    83.441   748.550     0.150
    83.441   752.470     0.150
    84.161   751.625     0.150
    84.834   753.740     0.150
    84.852   755.400     0.150
    86.180   761.895     0.150
    87.459   767.250     0.150
    87.459   767.150     0.150
    87.461   767.370     0.150
    87.461   767.450     0.150
    87.461   767.670     0.150
    89.438   776.750     0.150
    89.438   776.750     0.150
    89.951   780.150     0.150
    89.951   780.150     0.150
    89.951   783.170     0.150
    96.588   809.850     0.150
    96.512   808.270     0.150
   100.606   828.350     0.150
   102.494   837.425     0.150
   108.896   870.820     0.150
   111.031  2331.150     0.150
   114.062  1121.075     0.150
   114.968  1121.750     0.150
   115.210  1759.336     0.150
   116.348  1127.100     0.150
   105.071  1132.450     0.150
   121.041  1134.020     0.150
    67.014  1135.120     0.150
    67.014  1134.150     0.150
    70.973  1134.550     0.150
    35.046  1138.370     0.150
    35.046  1136.910     0.150
    35.046  1137.450     0.150
   124.441  1729.869     0.150
    37.749  1138.650     0.150
   125.327  1146.093     0.150
    32.528  1142.950     0.150
   126.667  1142.710     0.150
   127.419  1145.319     0.150
   136.598  1167.800     0.150
   140.353  1163.600     0.150
   142.368  1168.475     0.150
   142.368  1167.875     0.150
   147.854  1183.979     0.150
     1.621    26.720     0.150
     1.847    33.960     0.150
     1.936    33.450     0.150
     2.376    41.560     0.150
     5.201    67.240     0.150
     5.165    80.939     0.150
     6.341    95.870     0.150
     7.233   111.700     0.150
    22.265   296.058     0.150
    51.866   546.734     0.150
     1.831    31.140     0.150
     2.391    42.490     0.150
     4.631    85.840     0.150
     4.631    71.510     0.150
     4.631    85.840     0.150
     5.204    76.600     0.150
    46.687   101.450     0.150
    12.519   312.160     0.150
    16.079   391.890     0.150
    16.079   223.890     0.150
    19.298   265.420     0.150
    28.749   357.990     0.150
    35.276   415.210     0.150
     1.924    34.669     0.150
     4.076    64.759     0.150
     4.606   154.264     0.150
     4.606    71.519     0.150
     5.698    88.785     0.150
     5.698    87.889     0.150
     5.698    87.719     0.150
     6.330    95.129     0.150
    46.711   100.839     0.150
    46.711   101.049     0.150
     7.012   104.188     0.150
     7.012   104.259     0.150
     7.751   115.688     0.150
     8.856   130.778     0.150
     9.100   132.488     0.150
     9.268   136.379     0.150
     9.631   138.488     0.150
     9.710   139.788     0.150
     9.869   141.688     0.150
    10.015   145.330     0.150
    10.291   143.988     0.150
    10.512   150.389     0.150
    10.599   269.303     0.150
    10.662   152.288     0.150
    10.838   153.688     0.150
    11.148   161.927     0.150
    11.461   305.288     0.150
    12.515   177.379     0.150
    12.515   177.208     0.150
    12.515   177.158     0.150
    12.515   177.688     0.150
    12.515   177.444     0.150
    12.515   177.658     0.150
    12.589   177.867     0.150
    13.109   191.488     0.150
    13.325   188.589     0.150
    13.424   195.905     0.150
    13.424   195.310     0.150
    13.816   194.188     0.150
    13.950   196.858     0.150
    14.090   351.988     0.150
    14.243   200.788     0.150
    14.371   201.788     0.150
    14.681   368.038     0.150
    14.867   214.782     0.150
    14.917   209.238     0.150
    14.971   210.559     0.150
    15.184   212.688     0.150
    15.556   217.889     0.150
    15.624   218.288     0.150
    16.196   226.089     0.150
    16.007   222.778     0.150
    16.007   222.788     0.150
    16.188   226.988     0.150
    16.860   238.089     0.150
    17.653   246.559     0.150
    17.653   246.576     0.150
    17.926   249.688     0.150
    18.257   252.288     0.150
    18.257   252.269     0.150
    19.263   264.188     0.150
    19.281   265.488     0.150
    19.286   264.578     0.150
    19.286   264.589     0.150
    19.286   264.719     0.150
    19.439   266.688     0.150
    19.501   489.089     0.150
    19.931   504.764     0.150
    19.931   273.671     0.150
    20.038   274.889     0.150
    20.555   277.688     0.150
    20.918   282.799     0.150
    20.918   282.788     0.150
    21.290   287.498     0.150
    21.746     3.990     0.150
    21.888   534.208     0.150
    22.090   295.868     0.150
    22.256   299.498     0.150
    23.209   308.889     0.150
    23.209   309.144     0.150
    23.209   308.188     0.150
    23.623   312.269     0.150
    23.868   315.089     0.150
    23.868   315.038     0.150
    25.020   324.788     0.150
    25.020   324.839     0.150
    25.020   324.889     0.150
    25.124   330.068     0.150
    25.631   331.184     0.150
    25.631   331.089     0.150
    25.886   334.238     0.150
    26.609     3.300     0.150
    26.997   349.889     0.150
    26.997   396.889     0.150
    26.997   405.889     0.150
    26.997   705.488     0.150
    27.058   392.389     0.150
    27.457   348.138     0.150
    27.613   352.642     0.150
    27.613   353.184     0.150
    27.675   351.608     0.150
    27.732   351.759     0.150
    27.928   353.274     0.150
    28.449   356.719     0.150
    28.731   358.669     0.150
    28.731   358.488     0.150
    28.731   358.748     0.150
    28.731   358.488     0.150
    28.845   360.562     0.150
    26.324   361.219     0.150
    29.024   363.401     0.150
    29.031   363.937     0.150
    29.075   362.839     0.150
    29.372   366.898     0.150
    29.504   367.832     0.150
    29.650   366.688     0.150
    29.650   366.776     0.150
    84.102   367.688     0.150
    29.963   370.152     0.150
    30.120   372.402     0.150
    30.375   374.955     0.150
    31.020   377.828     0.150
    31.020   377.828     0.150
    31.020   447.889     0.150
    31.020   801.318     0.150
    31.020   377.788     0.150
    31.020   438.889     0.150
    31.020   683.788     0.150
    31.020   785.889     0.150
    31.015   379.717     0.150
    31.117   380.938     0.150
    31.211   381.939     0.150
    31.303   383.092     0.150
    31.332   383.072     0.150
    31.561   384.779     0.150
    31.669   385.288     0.150
    31.669   385.342     0.150
    31.669   385.408     0.150
    31.704   386.489     0.150
    31.918   387.593     0.150
    32.426   393.089     0.150
    32.538   393.754     0.150
    32.563   394.330     0.150
    33.354   397.889     0.150
    33.412   401.009     0.150
    33.704   405.269     0.150
    33.856     5.200     0.150
    33.924   407.188     0.150
    33.966   406.223     0.150
    34.133   405.589     0.150
    34.238   406.868     0.150
    34.386   409.389     0.150
    34.419   409.797     0.150
    35.251   416.408     0.150
    35.308   417.288     0.150
    35.513   422.488     0.150
    35.673   421.130     0.150
    35.752   420.958     0.150
    35.752   421.909     0.150
    35.759   421.057     0.150
    36.230   423.788     0.150
    36.259     2.630     0.150
    36.280   425.488     0.150
    36.307   425.848     0.150
    36.425   425.349     0.150
    36.425   425.389     0.150
    36.609   428.889     0.150
    36.609   428.889     0.150
    36.695   429.889     0.150
    36.810   430.589     0.150
    36.826   430.788     0.150
    37.026   431.788     0.150
    37.705   441.788     0.150
    37.743   435.988     0.150
    37.760   438.089     0.150
    37.992   440.698     0.150
    38.162   440.839     0.150
    38.162   574.238     0.150
    38.261   441.788     0.150
    38.361   442.188     0.150
    38.466   444.488     0.150
    38.476   441.879     0.150
    38.812   447.188     0.150
    38.812   534.688     0.150
    38.812   554.688     0.150
    39.081   448.169     0.150
    39.069   449.089     0.150
    39.069   449.089     0.150
    39.503   450.733     0.150
    39.794   453.222     0.150
    39.907   455.198     0.150
    40.005   455.408     0.150
    40.065   457.158     0.150
   124.435   461.068     0.150
   124.435   460.738     0.150
    41.635   468.688     0.150
    23.167   471.498     0.150
    41.719   469.738     0.150
    41.719   469.488     0.150
    41.719   469.788     0.150
    42.552   476.488     0.150
    42.552   477.639     0.150
    42.552   476.688     0.150
    42.552   476.707     0.150
    43.196   481.938     0.150
    43.227   484.438     0.150
    44.539   492.769     0.150
    44.539   492.799     0.150
    45.755   503.179     0.150
    45.755   503.148     0.150
    45.755   502.288     0.150
    56.024   504.284     0.150
    56.024   504.238     0.150
    46.692   507.946     0.150
    46.692   507.479     0.150
    46.692   507.839     0.150
    46.891   511.578     0.150
    48.593   525.089     0.150
    48.593   611.188     0.150
    48.620   525.538     0.150
    48.620   525.669     0.150
    48.620   525.688     0.150
    48.900   527.389     0.150
    49.638   532.589     0.150
    49.638   700.089     0.150
    49.638   967.389     0.150
    49.638  1256.089     0.150
    49.638   532.219     0.150
    50.205   536.688     0.150
    50.456   539.349     0.150
    50.456   539.488     0.150
    50.542   542.648     0.150
    50.750   540.208     0.150
    52.173   551.568     0.150
    52.173   551.309     0.150
    52.254   552.288     0.150
    52.286   554.195     0.150
    52.286   554.019     0.150
    52.286   552.688     0.150
    96.915   554.699     0.150
    96.915   554.669     0.150
    96.915   552.948     0.150
    52.429   556.608     0.150
    55.224   573.299     0.150
    55.224   573.288     0.150
    55.224   573.278     0.150
    56.280   584.599     0.150
   111.000   582.595     0.150
   111.000   582.309     0.150
    58.243   594.219     0.150
    58.126   595.479     0.150
    59.215   602.038     0.150
    59.709   605.535     0.150
    59.709   605.479     0.150
    59.709   605.389     0.150
    59.883   606.589     0.150
    59.883   606.679     0.150
    60.182   609.248     0.150
    60.182   608.988     0.150
    60.391   611.759     0.150
    60.759   612.368     0.150
    61.021   613.188     0.150
    63.387   630.969     0.150
    63.911   633.438     0.150
    66.209   646.738     0.150
    66.725   654.788     0.150
    67.333   655.488     0.150
    67.914  1455.549     0.150
    68.170  1460.528     0.150
    68.196  1504.389     0.150
    68.719   664.299     0.150
    68.719   664.349     0.150
    68.719   664.278     0.150
    68.862  1512.358     0.150
    68.949  1532.299     0.150
    69.100   670.599     0.150
    69.334   667.938     0.150
    69.943   671.099     0.150
    71.099  1531.299     0.150
    71.312  1522.328     0.150
    71.933   683.688     0.150
    71.933   683.389     0.150
    74.457   699.089     0.150
    78.055   719.839     0.150
    78.055   719.788     0.150
    78.320  2339.038     0.150
    80.617   733.229     0.150
    81.078   734.389     0.150
    83.156   747.099     0.150
    83.399   748.383     0.150
    83.399   748.398     0.150
    83.399   748.389     0.150
    83.772   746.983     0.150
    84.808   753.379     0.150
    84.841   754.419     0.150
    87.413   767.339     0.150
    87.413   767.389     0.150
    87.416   767.538     0.150
    89.395   776.688     0.150
    89.929   779.089     0.150
    89.937   780.528     0.150
    89.937   780.528     0.150
    89.937   780.488     0.150
   107.284  1104.639     0.150
   114.960  1756.188     0.150
   123.225  1135.288     0.150
   126.674  1143.769     0.150
   142.435  1168.313     0.150
   142.435  1167.339     0.150
   142.435  1171.589     0.150
     1.625    51.254     0.150
     1.625    29.693     0.150
     1.817    33.152     0.150
     1.952    61.924     0.150
     2.070    38.604     0.150
     2.503    42.053     0.150
     5.692    81.914     0.150
    46.686    99.414     0.150
    46.686   101.402     0.150
    21.923   294.072     0.150
    36.408   422.154     0.150
    41.668   471.078     0.150
    87.394   765.703     0.150
     4.632    83.879     0.150
     1.778    32.338     0.150
     4.594    83.014     0.150
    10.710   154.430     0.150
    12.566   175.807     0.150
    14.702   211.131     0.150
    14.702   368.604     0.150
     4.599    84.373     0.150
     4.605    69.723     0.150
     5.168    66.324     0.150
     5.718    85.623     0.150
     5.718    89.863     0.150
    46.722   100.062     0.150
     7.031   104.123     0.150
     8.787   127.424     0.150
     9.122   132.523     0.150
     9.287   134.062     0.150
     9.889   141.424     0.150
    10.533   149.824     0.150
    10.681   151.424     0.150
    10.681   270.424     0.150
    10.681   152.023     0.150
    10.859   153.623     0.150
    12.536   177.123     0.150
    13.347   188.094     0.150
    13.972   195.664     0.150
    14.214   199.123     0.150
    14.688   363.223     0.150
    14.854   208.434     0.150
    14.939   209.984     0.150
    15.581   218.924     0.150
    16.029   223.424     0.150
    17.669   245.934     0.150
    17.917   250.223     0.150
    18.235   252.223     0.150
    19.032   260.373     0.150
    19.284   263.793     0.150
    19.284   263.824     0.150
    19.301   263.264     0.150
    19.490   265.924     0.150
    19.490   481.723     0.150
    19.950   272.623     0.150
    20.056   274.045     0.150
    20.056   272.424     0.150
    20.313   275.084     0.150
    20.935   283.223     0.150
    21.311   286.133     0.150
    21.368   291.324     0.150
    21.895   292.213     0.150
    22.354   301.824     0.150
    23.229   305.723     0.150
    23.194   305.562     0.150
    23.194   311.623     0.150
    23.194   305.443     0.150
    25.025   325.223     0.150
    26.995   346.324     0.150
    27.055   393.424     0.150
    28.674   359.623     0.150
    28.724   356.283     0.150
    28.724   356.324     0.150
    28.727   359.623     0.150
    31.015   379.334     0.150
    31.015   379.334     0.150
    31.015   448.904     0.150
    31.015   803.604     0.150
    31.015   379.324     0.150
    31.015   440.223     0.150
    31.015   448.824     0.150
    31.015   685.023     0.150
    31.015   786.623     0.150
    31.015   803.523     0.150
    31.907   387.623     0.150
    32.417   393.723     0.150
    32.526   389.004     0.150
    32.526   389.023     0.150
    32.573   393.723     0.150
    35.329   414.824     0.150
    35.773   418.824     0.150
    35.773   418.812     0.150
    36.273   422.824     0.150
    38.297   443.062     0.150
    38.803   441.523     0.150
    38.803   441.523     0.150
    40.314   458.623     0.150
    41.614   471.834     0.150
    41.614   471.824     0.150
    42.532   477.324     0.150
    43.201   483.363     0.150
    44.527   492.824     0.150
    50.222   535.354     0.150
    50.222   536.623     0.150
    50.436   541.553     0.150
    50.436   541.523     0.150
    71.914   685.773     0.150
    71.914   683.824     0.150
    87.427   767.924     0.150
    87.429   768.723     0.150
    87.429   768.723     0.150
     1.614    29.299     0.150
     4.620    69.215     0.150
     4.620    82.215     0.150
     5.192    63.898     0.150
     5.143    78.039     0.150
     5.696    84.039     0.150
    46.700   101.068     0.150
     7.024   102.840     0.150
     8.775   127.539     0.150
     9.108   132.439     0.150
    12.525   177.740     0.150
    14.200   200.369     0.150
    14.698   205.906     0.150
    18.250   252.648     0.150
    19.297   262.971     0.150
    19.449   264.000     0.150
    22.084   298.789     0.150
    25.002   321.828     0.150
    28.745   358.709     0.150
    34.665   407.059     0.150
    38.312   444.670     0.150
    39.531   451.488     0.150
    39.618   451.930     0.150
    40.466   459.828     0.150
    23.176   471.020     0.150
    41.730   467.969     0.150
    41.719   468.000     0.150
    42.516   473.939     0.150
    45.669   499.619     0.150
    47.608   514.859     0.150
    47.677   514.189     0.150
    48.635   523.379     0.150
    48.635   523.309     0.150
    50.221   534.611     0.150
    52.285   550.350     0.150
    98.023   734.309     0.150
     1.461    26.705     0.150
     1.682    30.885     0.150
     1.814    32.846     0.150
     2.803    45.475     0.150
     3.838    62.486     0.150
     5.031    64.096     0.150
     5.743    88.086     0.150
     6.378    89.996     0.150
     7.129   105.525     0.150
    12.009   173.375     0.150
    14.684   210.064     0.150
    16.047   400.801     0.150
    19.571   272.336     0.150
    25.171   323.256     0.150
    29.373   362.807     0.150
    36.579   424.236     0.150
    36.579   423.945     0.150
    50.286   535.221     0.150
    73.660   695.396     0.150
     1.958    34.031     0.150
     1.958    33.072     0.150
     2.407    40.133     0.150
     3.392    53.531     0.150
     3.589    57.092     0.150
     4.085    63.082     0.150
     4.151    64.332     0.150
     4.587    70.133     0.150
     4.648    84.906     0.150
     5.177    65.021     0.150
     5.758    85.963     0.150
     5.737    86.133     0.150
     6.421    89.951     0.150
    46.690   101.611     0.150
    46.690   101.652     0.150
     7.106   102.352     0.150
     7.106   102.332     0.150
     8.852   126.652     0.150
     8.852   126.633     0.150
     9.182   132.732     0.150
     9.300   135.182     0.150
     9.960   141.531     0.150
    10.757   151.932     0.150
    10.925   154.432     0.150
    10.861   160.432     0.150
    12.603   177.932     0.150
    12.603   178.732     0.150
    13.411   188.912     0.150
    14.033   196.883     0.150
    14.274   201.133     0.150
    14.767   369.650     0.150
    16.092   224.332     0.150
    16.140   393.656     0.150
    16.140   402.969     0.150
    17.679   248.133     0.150
    17.702   247.521     0.150
    18.177   252.732     0.150
    19.353   264.133     0.150
    19.353   264.223     0.150
    19.383   264.182     0.150
    19.427   271.463     0.150
    20.134   277.332     0.150
    21.974   293.133     0.150
    21.974   312.732     0.150
    23.208   308.732     0.150
    25.037   324.932     0.150
    26.178   336.332     0.150
    26.664   342.932     0.150
    26.664     4.000     0.150
    27.115   709.432     0.150
    27.946   352.332     0.150
    28.768   357.252     0.150
    28.768   357.232     0.150
    28.768   357.232     0.150
    28.772   358.031     0.150
    29.445   366.602     0.150
    29.522   368.932     0.150
    30.418   376.031     0.150
    31.688   386.871     0.150
    31.940   388.832     0.150
    32.555   393.732     0.150
    33.915   392.133     0.150
    35.312   415.832     0.150
    35.500   417.021     0.150
    35.781   423.723     0.150
    35.781   423.732     0.150
    36.240   423.633     0.150
    38.590   445.482     0.150
    40.719   462.332     0.150
    40.768   464.133     0.150
    44.556   493.732     0.150
    51.859   550.182     0.150
    54.542   570.143     0.150
    54.542   570.133     0.150
    71.838   684.457     0.150
    71.838   684.572     0.150
    71.838   684.531     0.150
    72.182   684.432     0.150
    87.406   767.031     0.150
    87.408   767.473     0.150
    99.722   822.832     0.150
    99.722   822.883     0.150
     1.738    30.625     0.150
     2.014    37.545     0.150
     2.985    49.205     0.150
     3.227    53.605     0.150
     4.551    83.605     0.150
     5.095    69.945     0.150
    46.783   101.305     0.150
    46.783   100.154     0.150
    12.599   181.451     0.150
    16.057   391.404     0.150
    19.521   272.795     0.150
    51.770   548.330     0.150
    60.405   611.861     0.150
     3.305    54.344     0.150
     4.610    83.047     0.150
    46.711   101.785     0.150
    12.532   310.613     0.150
     1.598    18.375     0.150
     1.838    22.266     0.150
     1.913    24.105     0.150
     2.020    27.707     0.150
     2.354    39.695     0.150
     2.873    37.957     0.150
     3.690    48.938     0.150
     4.068    53.918     0.150
     4.281    56.348     0.150
     4.595    80.945     0.150
     4.872    66.059     0.150
     5.173    70.176     0.150
     5.179    66.387     0.150
     5.728    76.598     0.150
     6.314    84.227     0.150
     6.696    89.266     0.150
     7.246    99.938     0.150
     1.558    28.398     0.150
     1.722    30.367     0.150
     3.106    49.770     0.150
     5.126    61.770     0.150
     5.697    85.270     0.150
    46.740   101.137     0.150
     7.184   123.867     0.150
    10.767   145.777     0.150
    12.624   169.199     0.150
    12.624   313.508     0.150
    14.743   204.066     0.150
    14.743   374.598     0.150
    16.112   221.285     0.150
    16.112   409.047     0.150
    19.548   257.387     0.150
     4.587    85.219     0.150
     5.354    81.844     0.150
    46.727    99.133     0.150
    46.727   100.203     0.150
    14.656   208.797     0.150
     4.509    82.408     0.150
     4.509   149.908     0.150
     4.537    82.765     0.150
     4.537   150.789     0.150
     1.554    28.098     0.150
     4.231    66.520     0.150
     4.568   154.344     0.150
     6.470    91.090     0.150
     7.235   130.168     0.150
    10.694   150.867     0.150
     1.819    31.746     0.150
     3.671    57.156     0.150
     4.594    71.687     0.150
     5.169    65.116     0.150
    46.725   100.057     0.150
    46.725   178.146     0.150
     7.019   101.316     0.150
     9.111   129.356     0.150
    12.524   176.486     0.150
    16.051   222.646     0.150
    19.283   266.036     0.150
    25.026   322.637     0.150
     1.830    31.844     0.150
     4.095    64.777     0.150
     4.628    84.164     0.150
     5.143    78.027     0.150
    46.691   101.785     0.150
    12.519   318.938     0.150
     1.590    28.812     0.150
     2.521    42.109     0.150
     2.694    44.516     0.150
     3.687    57.016     0.150
     4.587    83.539     0.150
    46.729   100.516     0.150
    10.652   270.602     0.150
    14.851   212.953     0.150
    16.037   390.820     0.150
    21.868   294.242     0.150
    78.304   719.164     0.150
    87.429   768.812     0.150
     1.490    49.763     0.150
     1.490    27.982     0.150
     1.830    32.743     0.150
     4.520    69.663     0.150
     5.132    77.473     0.150
     5.632    86.293     0.150
     6.421    90.463     0.150
    46.815   102.072     0.150
    46.815   101.993     0.150
     7.089   104.763     0.150
     7.089   104.763     0.150
     8.861   129.562     0.150
     8.861   129.562     0.150
     9.204   134.463     0.150
     9.955   143.562     0.150
    10.600   151.763     0.150
    10.734   270.163     0.150
    10.734   153.362     0.150
    10.933   156.763     0.150
    11.760   173.062     0.150
    12.607   178.988     0.150
    13.422   191.072     0.150
    14.051   198.282     0.150
    14.668   204.562     0.150
    14.668   363.062     0.150
    14.755   212.763     0.150
    15.619   215.858     0.150
    15.619   380.562     0.150
    16.035   221.438     0.150
    16.107   223.963     0.150
    18.152   251.562     0.150
    19.315   265.263     0.150
    19.319   265.862     0.150
    19.352   263.301     0.150
    19.352   264.763     0.150
    19.528   264.792     0.150
    21.852   297.362     0.150
    21.852     3.000     0.150
    21.875   294.473     0.150
    26.069   334.862     0.150
    26.990   346.562     0.150
    26.990     0.200     0.150
    26.990   628.963     0.150
    26.990   718.562     0.150
    32.232   389.562     0.150
    35.189   415.933     0.150
    36.545   428.463     0.150
    71.864   682.083     0.150
    87.526   767.663     0.150
    87.529   768.103     0.150
     3.045    50.039     0.150
     4.566    83.836     0.150
     5.693    85.828     0.150
     6.317    94.648     0.150
     6.485    90.898     0.150
    46.756   100.016     0.150
     7.249   111.195     0.150
    15.573   213.547     0.150
    18.225   254.055     0.150
     1.683    49.806     0.150
     2.933    47.926     0.150
     4.477    69.105     0.150
     6.384    89.075     0.150
    46.865   101.815     0.150
    46.865   102.016     0.150
    10.973   157.575     0.150
    14.658   205.195     0.150
    16.021   390.301     0.150
    16.021   222.976     0.150
    19.325   265.855     0.150
    19.329   262.155     0.150
    19.329   262.025     0.150
    21.865   293.815     0.150
    28.589   356.426     0.150
    35.156   414.495     0.150
    36.602   428.176     0.150
    40.093   455.476     0.150
     1.709    31.240     0.150
     6.405    89.131     0.150
     6.644    98.521     0.150
     8.769   137.480     0.150
    12.622   320.869     0.150
    19.321   263.195     0.150
    21.874   290.314     0.150
    25.099   322.547     0.150
    41.064   461.621     0.150
    41.552   466.422     0.150
     1.472    27.035     0.150
     1.472    47.336     0.150
     1.632    29.086     0.150
     1.845    33.355     0.150
     2.878    48.086     0.150
     3.495    55.445     0.150
     4.539    82.762     0.150
     6.322    87.996     0.150
    46.819   103.324     0.150
     7.790   126.734     0.150
    12.704   180.047     0.150
    16.105   391.336     0.150
    18.058   246.938     0.150
    21.949     2.660     0.150
     1.823    32.816     0.150
     3.068    50.219     0.150
     4.583    84.344     0.150
     1.498    27.642     0.150
     1.695    53.092     0.150
     1.695    29.942     0.150
     5.646    85.982     0.150
     6.386    87.972     0.150
    46.801   102.972     0.150
     6.999   103.652     0.150
    12.641   177.258     0.150
    14.707   209.717     0.150
    14.707   359.204     0.150
    87.518   769.517     0.150
    89.494   779.166     0.150
     1.800    31.223     0.150
     3.047    50.404     0.150
     5.685    86.174     0.150
     6.489    89.223     0.150
    46.763    99.984     0.150
    46.763   100.473     0.150
     7.094   104.873     0.150
     7.249   107.344     0.150
     7.253   107.893     0.150
    19.284   261.705     0.150
    20.926   282.723     0.150
    21.777     6.000     0.150
    21.777   321.104     0.150
    40.276   457.854     0.150
    97.987   733.404     0.150
     1.808    31.805     0.150
     2.321    40.734     0.150
     3.054    50.539     0.150
     4.029    63.695     0.150
     4.562    70.836     0.150
     4.562    84.055     0.150
     5.171    78.367     0.150
     5.739    85.336     0.150
     5.739    93.391     0.150
     5.739   162.562     0.150
     5.739    87.664     0.150
     6.328    94.977     0.150
     6.496    89.688     0.150
    46.758   100.570     0.150
    46.758   178.086     0.150
    46.758   100.508     0.150
    46.758   100.664     0.150
     7.020   103.734     0.150
     7.102   105.547     0.150
     7.255   108.109     0.150
     8.783   127.836     0.150
     9.122   132.539     0.150
     9.122   132.438     0.150
     9.311   134.484     0.150
     9.637   139.438     0.150
     9.717   140.039     0.150
     9.730   141.641     0.150
     9.881   141.539     0.150
    10.011   253.875     0.150
    10.052   255.961     0.150
    10.296   144.844     0.150
    10.296   144.836     0.150
    10.525   149.836     0.150
    10.668   152.141     0.150
    10.678   152.344     0.150
    10.854   153.336     0.150
    10.956   157.039     0.150
    11.248   163.406     0.150
    11.607   170.672     0.150
    11.675   170.438     0.150
    12.530   177.195     0.150
    12.530   177.438     0.150
    12.530   177.461     0.150
    12.530   177.414     0.150
    12.629   183.906     0.150
    13.343   188.719     0.150
    13.427   193.305     0.150
    13.547   196.688     0.150
    13.824   195.234     0.150
    13.970   196.367     0.150
    14.252   206.609     0.150
    14.382   202.438     0.150
    14.388   201.734     0.150
    14.820   214.188     0.150
    14.820   212.336     0.150
    14.820   214.266     0.150
    14.937   209.227     0.150
    14.995   209.969     0.150
    15.053   217.211     0.150
    15.202   212.438     0.150
    15.285   218.094     0.150
    15.574   218.641     0.150
    16.216   225.836     0.150
    16.027   222.984     0.150
    16.027   223.039     0.150
    16.028   220.680     0.150
    16.202   227.438     0.150
    16.678   236.086     0.150
    17.607   244.641     0.150
    17.607   244.555     0.150
    17.634   247.664     0.150
    18.234   252.234     0.150
    19.276   264.039     0.150
    19.276   264.406     0.150
    19.453   266.836     0.150
    19.454   267.039     0.150
    20.041   274.734     0.150
    20.512   498.883     0.150
    20.560   279.336     0.150
    20.963   283.141     0.150
    21.305   287.625     0.150
    21.411   532.539     0.150
    21.769     4.000     0.150
    21.769   532.734     0.150
    21.769     2.516     0.150
    21.862   530.102     0.150
    21.862   294.336     0.150
    21.862   294.438     0.150
    21.862   294.641     0.150
    22.474   299.414     0.150
    22.622   297.750     0.150
    23.160     4.594     0.150
    23.163   307.734     0.150
    23.702   566.539     0.150
    23.822   315.742     0.150
    23.822   315.070     0.150
    23.822     3.438     0.150
    25.048     3.070     0.150
    25.048   324.641     0.150
    25.585   330.539     0.150
    25.585   329.586     0.150
    25.585   330.555     0.150
    26.146   335.141     0.150
    26.957   347.938     0.150
    26.957   388.039     0.150
    26.957   405.039     0.150
    27.017   397.438     0.150
    27.017   343.711     0.150
    27.017   343.695     0.150
    27.411   347.359     0.150
    27.567   349.211     0.150
    27.881   351.922     0.150
    27.943   352.805     0.150
   106.396   352.539     0.150
    28.679   357.438     0.150
    28.679   547.039     0.150
    28.686   358.500     0.150
    28.686   358.539     0.150
    28.686   358.445     0.150
    28.686   357.836     0.150
    28.978   362.336     0.150
    28.978   363.109     0.150
    28.984   361.578     0.150
    28.984   362.727     0.150
    26.367   361.070     0.150
    29.028   362.984     0.150
    29.204   364.062     0.150
    29.395   363.617     0.150
    29.457   366.891     0.150
    84.128   367.141     0.150
    30.073   371.664     0.150
    30.977   378.656     0.150
    30.977   378.656     0.150
    30.977   448.039     0.150
    30.977   800.914     0.150
    30.977   378.641     0.150
    30.977   439.039     0.150
    30.977   684.141     0.150
    30.977   785.734     0.150
    31.164   381.656     0.150
    31.623   385.984     0.150
    31.735   384.438     0.150
    31.872   387.922     0.150
    32.213   387.234     0.150
    32.491   390.891     0.150
    32.491   392.734     0.150
    32.491   392.836     0.150
    32.517   393.578     0.150
    32.727   386.836     0.150
    32.727   700.938     0.150
    33.310   395.305     0.150
    33.310   397.039     0.150
    33.371   398.938     0.150
    33.891     5.500     0.150
    33.879   406.328     0.150
    33.879   406.336     0.150
    33.920   406.070     0.150
    34.071   407.141     0.150
    34.087   403.820     0.150
    34.193   408.406     0.150
    34.340   408.711     0.150
    34.340   409.039     0.150
    34.373   409.844     0.150
    34.920   412.938     0.150
    34.966   413.875     0.150
    34.966   415.203     0.150
    35.211   415.094     0.150
    35.328   416.156     0.150
    35.328   564.555     0.150
    39.261   417.758     0.150
    39.261   417.078     0.150
    35.627   420.391     0.150
    35.706   421.234     0.150
    35.713   420.859     0.150
    35.772   421.266     0.150
    35.772   421.414     0.150
    36.234   425.641     0.150
    36.276   424.000     0.150
    36.276   424.086     0.150
    36.297     3.000     0.150
    36.261   425.336     0.150
    36.261   425.211     0.150
    36.261   425.352     0.150
    36.301     2.805     0.150
    36.509   427.141     0.150
    36.563   428.734     0.150
    36.563   428.734     0.150
    36.649   428.938     0.150
    36.658   429.539     0.150
    36.764   430.234     0.150
    36.780   430.539     0.150
    36.809   430.125     0.150
    37.079   432.070     0.150
    37.452   435.617     0.150
    37.688   437.094     0.150
    37.697   436.141     0.150
    37.714   437.734     0.150
    37.836   438.539     0.150
    38.116   440.734     0.150
    38.116   572.914     0.150
    38.131   441.828     0.150
    38.215   441.438     0.150
    38.238   440.828     0.150
    38.396   442.367     0.150
    38.420   443.734     0.150
    38.766   449.539     0.150
    38.766   445.836     0.150
    38.766   542.039     0.150
    38.766   554.438     0.150
    38.766  1280.438     0.150
    38.766  1340.438     0.150
    39.023   449.539     0.150
    39.945   455.539     0.150
    39.945     3.375     0.150
    40.031   456.984     0.150
    40.031   455.406     0.150
    40.311   463.234     0.150
    40.311   574.836     0.150
   124.388   461.391     0.150
   124.388   460.656     0.150
    40.651   461.305     0.150
    41.105     4.297     0.150
    41.092   464.539     0.150
    41.105   465.945     0.150
    41.593   468.438     0.150
    23.120   470.398     0.150
    41.672   469.734     0.150
    41.829   471.195     0.150
    42.034   471.391     0.150
    42.458   476.039     0.150
    42.513   857.938     0.150
    42.544   477.234     0.150
    42.544   476.039     0.150
    42.544   476.039     0.150
    42.544   587.539     0.150
    42.544   477.227     0.150
    42.544   477.289     0.150
    42.671   475.812     0.150
    43.007   480.875     0.150
    43.152   480.156     0.150
    43.493   875.438     0.150
    44.492   492.734     0.150
    44.492   492.750     0.150
    45.613   499.914     0.150
    45.740   502.641     0.150
    45.740   502.789     0.150
    45.740   502.539     0.150
    45.740   502.695     0.150
    56.056   504.547     0.150
    56.056   504.539     0.150
    56.056   503.648     0.150
    46.738   508.070     0.150
    46.738   508.117     0.150
    46.738   508.086     0.150
    46.868   510.141     0.150
    46.918   510.719     0.150
    46.933   512.445     0.150
    48.367   521.375     0.150
    48.576   525.016     0.150
    48.576   524.977     0.150
    48.870   527.570     0.150
    48.870   527.586     0.150
    49.643   532.305     0.150
    49.643   644.438     0.150
    49.643   700.141     0.150
    49.643  1248.336     0.150
    50.201   536.719     0.150
    50.201   536.781     0.150
    50.201   536.836     0.150
    50.414   539.055     0.150
    50.414   538.336     0.150
    50.797   540.359     0.150
    51.830   549.789     0.150
    52.126   550.750     0.150
    52.126   551.336     0.150
    52.223   551.539     0.150
    52.283   551.641     0.150
    52.325   554.508     0.150
    52.325   554.562     0.150
    52.325   551.328     0.150
    96.896   555.328     0.150
    96.896   555.281     0.150
    96.896   552.781     0.150
    53.334   558.664     0.150
    54.433   568.461     0.150
    54.433   568.375     0.150
    54.634   566.141     0.150
    54.731   570.688     0.150
    55.233   573.539     0.150
    55.309   574.445     0.150
    55.793   577.938     0.150
    56.358   582.672     0.150
    58.252   594.172     0.150
    58.156   595.531     0.150
    59.207   601.164     0.150
    59.207   602.359     0.150
    59.727   606.055     0.150
    59.727   605.758     0.150
    59.911   606.922     0.150
    59.985   607.336     0.150
    60.356   609.914     0.150
    60.356   611.234     0.150
    60.783   612.656     0.150
    61.773   619.078     0.150
    63.957   633.734     0.150
    66.220  2365.109     0.150
    66.220   647.539     0.150
    66.689   650.836     0.150
    67.295   654.914     0.150
    67.295   654.938     0.150
    67.295   654.984     0.150
    68.262   662.039     0.150
    68.262   661.961     0.150
    68.713   664.430     0.150
    68.713   663.148     0.150
    68.713   664.336     0.150
    68.713   663.141     0.150
    68.713   664.516     0.150
    69.989   671.680     0.150
    69.989   671.641     0.150
    71.929   683.641     0.150
    71.929   683.234     0.150
    73.479   692.086     0.150
    75.483   705.148     0.150
    76.666   712.438     0.150
    79.656   730.047     0.150
    82.855   746.070     0.150
    83.133   746.617     0.150
    83.391   748.961     0.150
    83.391   747.148     0.150
    83.391   747.141     0.150
    87.460   767.758     0.150
    89.909   780.164     0.150
    91.267   784.930     0.150
    93.223   794.328     0.150
   107.262  1105.953     0.150
   107.262  1779.086     0.150
   114.929  1755.742     0.150
   121.021  1132.633     0.150
   125.716  1140.820     0.150
   126.706  1142.234     0.150
   126.706  1142.258     0.150
   127.814  1145.781     0.150
   131.983  1154.141     0.150
   142.406  1172.539     0.150
     2.858    47.871     0.150
     4.486    83.451     0.150
     6.900   102.660     0.150
    46.875   104.531     0.150
     8.753   129.582     0.150
    12.664   179.771     0.150
    16.069   221.057     0.150
    25.189   323.672     0.150
    35.181   412.980     0.150
    35.181   412.980     0.150
    36.484   427.871     0.150
    38.668   551.871     0.150
    53.536   559.781     0.150
    60.359   608.701     0.150
    71.761   680.301     0.150
    98.061   734.801     0.150
     1.611    52.246     0.150
     1.832    31.246     0.150
     2.503    43.047     0.150
     2.713    46.246     0.150
     4.612    80.891     0.150
     4.612   144.117     0.150
    19.284   269.430     0.150
     1.426    26.695     0.150
     2.866    47.828     0.150
     4.494    82.547     0.150
     4.494    69.328     0.150
     4.494    82.547     0.150
     4.987    71.125     0.150
     6.315    86.062     0.150
     7.759   106.969     0.150
     8.969   127.438     0.150
     9.488   133.945     0.150
    10.060   138.258     0.150
    14.712   210.062     0.150
    19.391   266.367     0.150
    19.634   269.695     0.150
    21.918   530.617     0.150
    21.918   294.562     0.150
    21.918   294.727     0.150
    25.184   327.523     0.150
    35.187   414.953     0.150
    38.015   439.742     0.150
    51.674   547.203     0.150
    53.527   560.773     0.150
     4.556    83.734     0.150
     4.700    71.016     0.150
    12.620   176.078     0.150
     1.773    32.238     0.150
     3.560    57.889     0.150
     4.997    70.729     0.150
     6.385    86.850     0.150
    35.144   413.191     0.150
     1.442   708.181     0.150
     2.911    48.280     0.150
     3.535    56.291     0.150
     5.592    86.250     0.150
     6.152    93.960     0.150
     7.219   106.221     0.150
    10.789   265.872     0.150
     1.633    29.781     0.150
     1.853    32.547     0.150
     5.669    81.977     0.150
     5.669    81.953     0.150
    46.686   100.367     0.150
     6.792   101.148     0.150
     6.996   103.852     0.150
     8.745   127.648     0.150
     9.239   130.352     0.150
     9.239   130.367     0.150
     9.851   142.148     0.150
    10.494   150.750     0.150
    10.647   271.398     0.150
    10.647   152.047     0.150
    10.647   271.453     0.150
    10.647   152.250     0.150
    10.818   153.852     0.150
    12.496   177.250     0.150
    12.496   313.352     0.150
    13.305   187.977     0.150
    13.928   196.641     0.150
    14.170   199.047     0.150
    14.687   206.047     0.150
    15.986   223.648     0.150
    16.064   224.578     0.150
    16.885   244.352     0.150
    17.385   249.648     0.150
    17.444   249.953     0.150
    17.678   252.250     0.150
    18.280   252.953     0.150
    19.245   262.578     0.150
    19.245   262.547     0.150
    19.277   264.422     0.150
    20.888   278.602     0.150
    20.888   278.648     0.150
    21.271   286.156     0.150
    23.238   309.352     0.150
    23.465   291.648     0.150
    24.419   318.352     0.150
    24.976   320.797     0.150
    24.976   320.852     0.150
    25.007   325.352     0.150
    27.077   348.352     0.150
    27.077   702.750     0.150
    28.754   358.047     0.150
    31.765   387.641     0.150
    35.268   415.930     0.150
    35.730   422.648     0.150
    36.396   421.102     0.150
    40.323   457.547     0.150
    45.774   501.188     0.150
    45.774   501.148     0.150
    49.624   529.828     0.150
    50.197   538.047     0.150
    52.228   553.648     0.150
    87.386   765.742     0.150
    87.386   765.750     0.150
    87.388   767.047     0.150
     1.677    29.334     0.150
     2.320    39.035     0.150
     2.552    42.936     0.150
     3.553    57.436     0.150
     5.006    69.334     0.150
     5.120    77.035     0.150
     5.885    85.334     0.150
    46.865   101.016     0.150
     7.127   104.234     0.150
     8.908   127.436     0.150
     9.254   132.234     0.150
     9.997   140.834     0.150
     9.997   140.834     0.150
    10.426   149.234     0.150
    10.643   151.334     0.150
    10.770   152.535     0.150
    10.770   270.334     0.150
    10.770   152.834     0.150
    10.978   154.035     0.150
    12.651   178.729     0.150
    12.651   178.855     0.150
    12.651   318.225     0.150
    14.662   204.234     0.150
    14.662   361.436     0.150
    14.700   217.035     0.150
    14.997   220.164     0.150
    15.779   230.834     0.150
    16.025   223.686     0.150
    18.101   250.436     0.150
    19.254   270.924     0.150
    19.330   264.855     0.150
    19.335   264.535     0.150
    19.395   265.334     0.150
    19.571   268.105     0.150
    19.571   268.135     0.150
    21.869   293.734     0.150
    21.869   538.535     0.150
    25.192   325.234     0.150
    28.590   356.635     0.150
    28.597   356.334     0.150
    35.159   414.725     0.150
    78.359   720.285     0.150
    83.150   745.664     0.150
    87.581   767.436     0.150
    89.558   777.084     0.150
    89.558   777.135     0.150
     1.710    29.983     0.150
     5.060    71.663     0.150
    46.813   102.293     0.150
    12.563   179.133     0.150
    12.624   181.153     0.150
    12.624   315.069     0.150
    16.050   225.733     0.150
    19.332   267.383     0.150
    23.089   303.934     0.150
    23.089   304.313     0.150
    36.549   423.923     0.150
    74.352   697.303     0.150
    87.527   765.894     0.150
    89.505   775.883     0.150
     1.521    49.770     0.150
     1.735    30.461     0.150
     1.863    33.701     0.150
     2.312    40.770     0.150
     3.995    62.850     0.150
     5.800    87.371     0.150
     5.800    93.730     0.150
     6.261    93.920     0.150
     7.090   103.570     0.150
     8.856   127.770     0.150
     9.953   142.770     0.150
    10.597   151.270     0.150
    10.737   152.971     0.150
    10.737   271.471     0.150
    10.737   152.670     0.150
    11.747   173.570     0.150
    12.602   322.289     0.150
    12.602   177.871     0.150
    12.602   317.170     0.150
    13.160   189.570     0.150
    14.043   197.770     0.150
    14.287   200.070     0.150
    14.691   205.371     0.150
    14.691   361.570     0.150
    14.786   211.871     0.150
    16.100   225.471     0.150
    16.060   391.570     0.150
    16.060   390.863     0.150
    19.525   267.180     0.150
    21.377   286.580     0.150
    21.898   292.061     0.150
    21.898   294.070     0.150
    21.898   311.471     0.150
    23.123   306.371     0.150
    25.105   325.371     0.150
    28.673   358.170     0.150
    30.972   380.160     0.150
    30.972   380.160     0.150
    30.972   380.160     0.150
    30.972   447.871     0.150
    30.972   802.801     0.150
    30.972   380.070     0.150
    30.972   438.670     0.150
    30.972   447.871     0.150
    30.972   685.371     0.150
    30.972   787.270     0.150
    30.972   802.770     0.150
    35.219   415.270     0.150
    40.298   456.627     0.150
    40.298   456.660     0.150
    40.298   456.670     0.150
    55.175   575.871     0.150
    69.892   672.070     0.150
     1.530    28.078     0.150
     1.875    33.773     0.150
     3.588    58.117     0.150
     4.565    72.016     0.150
     5.796    84.812     0.150
     5.796    84.812     0.150
     7.099   104.414     0.150
     7.099   104.516     0.150
     7.885   128.992     0.150
     9.200   133.016     0.150
     9.200   133.016     0.150
     9.555   152.023     0.150
     9.961   142.914     0.150
    10.605   151.312     0.150
    12.609   309.234     0.150
    12.609   178.484     0.150
    13.422   189.359     0.150
    14.796   219.062     0.150
    14.796   215.812     0.150
    16.074   221.117     0.150
    16.105   225.117     0.150
    17.300   242.414     0.150
    18.157   250.812     0.150
    19.340   265.438     0.150
    19.345   265.219     0.150
    19.532   267.484     0.150
    21.384   287.273     0.150
    21.847     6.000     0.150
    21.847   321.812     0.150
    21.912   539.516     0.150
    23.131   307.617     0.150
    23.966     3.102     0.150
    26.105   333.719     0.150
    28.678   357.812     0.150
    28.685   358.312     0.150
    35.233   415.812     0.150
    36.508   423.758     0.150
    38.464   445.312     0.150
    40.312   458.812     0.150
    46.795   509.242     0.150
    51.779   548.273     0.150
    73.166   692.625     0.150
    76.728   711.414     0.150
    78.374   720.688     0.150
    98.042   734.195     0.150
    80.986   735.062     0.150
    83.188   746.219     0.150
    83.462   749.117     0.150
     2.084    37.708     0.150
     4.762    85.583     0.150
     4.762   146.058     0.150
    12.460   305.077     0.150
    16.155   222.153     0.150
    16.155   384.938     0.150
     2.958    49.508     0.150
     3.322    54.109     0.150
     3.638    59.008     0.150
    16.005   398.359     0.150
    16.005   221.750     0.150
    28.588   354.242     0.150
    36.591   423.008     0.150
    83.127   743.234     0.150
    87.574   763.938     0.150
    89.552   775.062     0.150
     1.368    25.609     0.150
     2.864    47.172     0.150
     3.498    57.672     0.150
     4.432    69.570     0.150
     4.934    72.258     0.150
     5.101    67.500     0.150
     6.196    92.656     0.150
     6.879   102.602     0.150
     7.179   104.469     0.150
     9.320   133.969     0.150
    10.054   143.570     0.150
    10.701   152.266     0.150
    10.819   154.070     0.150
    11.886   178.766     0.150
    19.360   264.172     0.150
    21.868   292.195     0.150
    25.268   326.867     0.150
    28.545   357.070     0.150
    35.126   414.469     0.150
    35.525   416.766     0.150
    36.676   429.570     0.150
    39.388   447.867     0.150
    52.497   553.570     0.150
    63.726   629.266     0.150
    63.726   673.469     0.150
    78.380   721.766     0.150
    82.296   743.039     0.150
    82.296   743.070     0.150
    89.623   779.617     0.150
     3.039    51.102     0.150
     1.526    53.195     0.150
     1.865    62.195     0.150
     2.313    88.281     0.150
     2.774   103.320     0.150
     3.232   112.695     0.150
     3.887   128.828     0.150
     3.999   152.102     0.150
     4.059   144.625     0.150
     4.190   143.898     0.150
     4.530   164.039     0.150
     4.722   173.219     0.150
     1.412    26.086     0.150
     1.662    30.477     0.150
     1.767    65.117     0.150
     2.531    88.816     0.150
     3.197   113.316     0.150
     3.278    71.947     0.150
     3.542    53.547     0.150
     3.792   128.607     0.150
     3.955   137.566     0.150
     4.083   138.197     0.150
     4.419   150.256     0.150
     4.460    76.252     0.150
     4.620   171.736     0.150
     5.121   164.176     0.150
     5.121    75.867     0.150
     6.231   103.297     0.150
     6.231    90.457     0.150
     6.495    96.176     0.150
     1.638    58.762     0.150
     1.971    81.221     0.150
     1.971    34.900     0.150
     3.411   118.932     0.150
     3.643    59.111     0.150
     3.990    62.320     0.150
     3.990   132.730     0.150
     4.112    63.521     0.150
     4.112   157.561     0.150
     4.168   155.990     0.150
     4.282   156.262     0.150
     4.628   183.480     0.150
     4.657    84.297     0.150
     4.807   175.861     0.150
     5.211    84.061     0.150
     5.860    87.820     0.150
     6.475    98.111     0.150
     6.683   101.502     0.150
     7.139   107.311     0.150
     8.403   127.432     0.150
     1.611    28.664     0.150
     2.502   103.797     0.150
     2.715    97.297     0.150
     2.858   105.336     0.150
     3.376   115.711     0.150
     3.678    76.992     0.150
     3.667    54.805     0.150
     4.134   144.766     0.150
     4.281   159.633     0.150
     4.623   156.375     0.150
     4.618    84.188     0.150
     4.810   171.195     0.150
     6.497    90.117     0.150
     1.561    60.594     0.150
     2.453    96.094     0.150
     2.835   105.172     0.150
     3.324   112.461     0.150
     3.688   128.047     0.150
     3.900   133.422     0.150
     4.082   147.828     0.150
     4.566    83.281     0.150
     4.587   157.109     0.150
     5.140    71.961     0.150
     6.491    82.828     0.150
     6.657    70.492     0.150
     7.753   103.281     0.150
     9.246    94.203     0.150
     1.400    47.381     0.150
     1.400    50.041     0.150
     1.750    64.420     0.150
     2.687    43.779     0.150
     2.687   109.041     0.150
     2.840   106.480     0.150
     3.181   108.090     0.150
     3.290   119.221     0.150
     3.556    58.051     0.150
     3.621    55.980     0.150
     3.621   126.141     0.150
     3.774   139.689     0.150
     3.875   132.439     0.150
     4.085    64.580     0.150
     4.085   146.961     0.150
     4.442    80.805     0.150
     4.456   158.439     0.150
     4.592    69.279     0.150
     4.624   166.100     0.150
     4.974    74.041     0.150
     5.115   170.980     0.150
     5.682   189.119     0.150
     5.736   208.400     0.150
     6.380    84.199     0.150
    10.763   274.664     0.150
    12.651   176.332     0.150
    12.651   315.734     0.150
    12.651   322.574     0.150
    19.311   263.256     0.150
    19.316   266.881     0.150
    20.127   276.881     0.150
    21.840   291.070     0.150
    23.002   303.312     0.150
    36.636   428.779     0.150
    36.636   423.801     0.150
    41.081   461.221     0.150
    51.649   545.248     0.150
    52.437   549.982     0.150
     1.232    41.893     0.150
     1.632    60.453     0.150
     2.492    90.493     0.150
     2.368    41.993     0.150
     2.368    77.673     0.150
     3.040   104.863     0.150
     3.402    32.663     0.150
     3.511   121.353     0.150
     3.879   143.273     0.150
     3.798   133.703     0.150
     4.212   160.093     0.150
     4.311   149.273     0.150
     4.786    62.983     0.150
     6.092    91.093     0.150
     6.217    78.603     0.150
    19.396   269.168     0.150
    20.155   277.718     0.150
     1.803    65.383     0.150
     2.258    40.164     0.150
     2.258    91.383     0.150
     2.672    57.945     0.150
     2.895    49.164     0.150
     2.895   108.883     0.150
     3.134   120.719     0.150
     3.572   124.023     0.150
     3.915    80.461     0.150
     4.084   158.500     0.150
     4.424   160.344     0.150
     4.431    71.062     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     1.414    25.668     0.150
     1.414    26.018     0.150
     1.662    28.668     0.150
     1.662    28.828     0.150
     1.769    31.068     0.150
     1.769    31.828     0.150
     1.958    33.857     0.150
     2.222    38.068     0.150
     2.353    39.568     0.150
     2.299    38.068     0.150
     2.547    42.068     0.150
     2.532    41.867     0.150
     2.680    43.967     0.150
     2.761    45.658     0.150
     2.962    47.668     0.150
     3.198    51.367     0.150
     3.542    55.668     0.150
     3.542    55.818     0.150
     3.793    59.467     0.150
     3.889    60.568     0.150
     3.889    60.887     0.150
     3.957    62.168     0.150
     4.077    62.729     0.150
     4.084    62.768     0.150
     4.420    67.568     0.150
     4.397    67.967     0.150
     4.462    68.443     0.150
     4.462   121.592     0.150
     4.592    69.467     0.150
     4.621    70.467     0.150
     4.722    72.457     0.150
     5.172    77.967     0.150
     5.562    83.367     0.150
     5.562    84.068     0.150
     5.668    84.867     0.150
     5.725    85.768     0.150
     5.906    89.268     0.150
     5.906    89.002     0.150
     5.906    88.467     0.150
     5.863    87.367     0.150
     5.983    91.062     0.150
     5.983    89.441     0.150
     6.034    90.268     0.150
     6.118    91.668     0.150
     6.125    91.277     0.150
     6.231    92.867     0.150
     6.231    92.627     0.150
     6.496    96.498     0.150
     6.594    98.367     0.150
     6.585    96.967     0.150
     6.814   100.867     0.150
     6.870   101.768     0.150
     6.920   102.467     0.150
     7.096   104.367     0.150
     7.096   104.918     0.150
     7.137   103.887     0.150
     7.137   183.873     0.150
     7.137   103.648     0.150
     7.137   104.047     0.150
     7.246   106.068     0.150
     7.246   106.268     0.150
     7.216   106.967     0.150
     7.357   108.467     0.150
     7.543   110.668     0.150
     7.547   110.867     0.150
     7.784   113.818     0.150
     7.931   114.758     0.150
     7.948   116.168     0.150
     8.124   118.668     0.150
     8.146   119.467     0.150
     8.451   123.568     0.150
     8.522   125.168     0.150
     8.513   124.668     0.150
     8.592   125.367     0.150
     8.662   126.168     0.150
     8.660   126.068     0.150
     8.658   126.268     0.150
     8.737   127.668     0.150
     8.737   128.277     0.150
     8.776   128.037     0.150
     8.734   125.967     0.150
     8.884   129.678     0.150
     8.922   127.807     0.150
     8.922   128.068     0.150
     9.024   131.967     0.150
     9.114   129.668     0.150
     9.114   130.627     0.150
     9.085   132.678     0.150
     9.269   132.797     0.150
     9.304   135.467     0.150
     9.370   136.068     0.150
     9.476   137.168     0.150
     9.476   137.467     0.150
     9.476   137.787     0.150
     9.542   137.498     0.150
     9.563   139.367     0.150
     9.681   141.168     0.150
     9.748   139.008     0.150
     9.748   138.318     0.150
     9.776   141.178     0.150
     9.908   143.350     0.150
     9.908   142.695     0.150
     9.908   256.256     0.150
     9.899   143.979     0.150
     9.951   143.998     0.150
     9.951   143.438     0.150
     9.951   255.328     0.150
    10.009   141.328     0.150
     9.986   144.668     0.150
     9.986   146.207     0.150
    10.124   145.867     0.150
    10.124   146.578     0.150
    10.246   147.805     0.150
    10.295   260.057     0.150
    10.444   151.047     0.150
    10.498   150.670     0.150
    10.507   150.939     0.150
    10.508   151.691     0.150
    10.655   149.818     0.150
    10.709   155.748     0.150
    10.779   152.953     0.150
    10.779   272.330     0.150
    10.779   271.068     0.150
    10.779   152.307     0.150
    10.860   156.967     0.150
    10.860   153.848     0.150
    10.860   155.998     0.150
    10.860   154.568     0.150
    10.860   155.479     0.150
    10.860   154.188     0.150
    10.860   153.627     0.150
    10.815   156.367     0.150
    10.876   157.428     0.150
    11.017   157.537     0.150
    10.996   158.291     0.150
    10.996   157.490     0.150
    10.924   156.967     0.150
    10.992   154.557     0.150
    11.043   159.293     0.150
    11.043   158.371     0.150
    11.022   158.467     0.150
    11.037   155.938     0.150
    11.152   160.756     0.150
    11.152   160.488     0.150
    11.088   157.766     0.150
    11.088   157.508     0.150
    11.149   160.537     0.150
    11.287   162.344     0.150
    11.287   161.621     0.150
    11.270   162.568     0.150
    11.270   288.467     0.150
    11.474   163.746     0.150
    11.504   165.418     0.150
    11.504   164.857     0.150
    11.504   164.807     0.150
    11.572   164.289     0.150
    11.709   168.213     0.150
    11.709   167.879     0.150
    11.735   167.432     0.150
    11.729   168.768     0.150
    11.837   169.217     0.150
    11.837   169.111     0.150
    11.832   166.768     0.150
    11.832   302.568     0.150
    11.909   170.668     0.150
    12.034   171.111     0.150
    12.129   171.158     0.150
    12.214   174.312     0.150
    12.135   174.367     0.150
    12.158   175.068     0.150
    12.273   172.785     0.150
    12.278   175.697     0.150
    12.290   175.113     0.150
    12.249   171.748     0.150
    12.454   178.299     0.150
    12.559   178.650     0.150
    12.488   177.768     0.150
    12.616   179.527     0.150
    12.643   178.408     0.150
    12.684   179.689     0.150
    12.664   177.467     0.150
    12.664   177.289     0.150
    12.664   177.736     0.150
    12.664   319.287     0.150
    12.664   177.838     0.150
    12.664   317.279     0.150
    12.664   178.127     0.150
    12.664   179.467     0.150
    12.664   178.967     0.150
    12.664   179.105     0.150
    12.759   183.268     0.150
    12.876   184.543     0.150
    12.906   183.062     0.150
    12.906   183.516     0.150
    12.904   184.867     0.150
    12.951   182.967     0.150
    13.038   183.967     0.150
    13.027   182.258     0.150
    13.041   188.090     0.150
    13.037   181.938     0.150
    13.064   187.557     0.150
    13.141   187.158     0.150
    13.058   185.568     0.150
    13.058   335.168     0.150
    13.232   188.725     0.150
    13.232   187.846     0.150
    13.231   190.717     0.150
    13.277   188.705     0.150
    13.204   188.967     0.150
    13.204   335.768     0.150
    13.301   189.268     0.150
    13.301   335.867     0.150
    13.316   190.768     0.150
    13.482   189.068     0.150
    13.495   190.797     0.150
    13.546   191.975     0.150
    13.553   191.998     0.150
    13.579   194.967     0.150
    13.600   194.867     0.150
    13.676   193.607     0.150
    13.695   195.467     0.150
    13.695   347.768     0.150
    13.772   195.736     0.150
    13.784   194.611     0.150
    13.784   196.082     0.150
    13.787   193.510     0.150
    13.862   197.867     0.150
    13.862   351.467     0.150
    13.929   198.568     0.150
    14.051   198.836     0.150
    14.114   196.467     0.150
    14.114   199.268     0.150
    14.193   201.447     0.150
    14.316   203.787     0.150
    14.346   201.957     0.150
    14.349   202.207     0.150
    14.373   201.547     0.150
    14.362   200.498     0.150
    14.399   202.438     0.150
    14.486   204.768     0.150
    14.527   366.467     0.150
    14.695   204.107     0.150
    14.695   390.047     0.150
    14.657   203.578     0.150
    14.657   204.068     0.150
    14.657   204.229     0.150
    14.679   210.568     0.150
    14.679   208.281     0.150
    14.679   209.836     0.150
    14.679   207.617     0.150
    14.679   208.967     0.150
    14.679   208.428     0.150
    14.841   210.357     0.150
    14.903   213.463     0.150
    14.976   213.848     0.150
    15.082   211.967     0.150
    15.168   213.281     0.150
    15.147   210.088     0.150
    15.344   212.357     0.150
    15.344   386.748     0.150
    15.321   215.258     0.150
    15.573   220.967     0.150
    15.596   219.678     0.150
    15.652   218.115     0.150
    15.652   216.867     0.150
    15.715   217.057     0.150
    15.715   394.867     0.150
    15.715   395.668     0.150
    15.697   219.545     0.150
    15.707   220.887     0.150
    15.786   218.107     0.150
    15.786   398.229     0.150
    15.758   222.979     0.150
    15.787   220.707     0.150
    16.018   221.943     0.150
    16.018   393.568     0.150
    16.018   222.768     0.150
    16.032   229.867     0.150
    16.360   225.848     0.150
    16.360   409.898     0.150
    16.169   222.912     0.150
    16.169   223.848     0.150
    16.169   224.537     0.150
    16.343   227.588     0.150
    16.404   231.217     0.150
    16.542   232.848     0.150
    16.760   237.119     0.150
    17.064   235.877     0.150
    17.187   241.867     0.150
    17.239   236.088     0.150
    17.250   240.043     0.150
    17.250   240.867     0.150
    17.250   239.467     0.150
    17.283   241.107     0.150
    17.312   241.418     0.150
    17.403   241.816     0.150
    17.403   242.377     0.150
    17.483   241.357     0.150
    17.483   242.473     0.150
    17.534   245.918     0.150
    17.485   242.068     0.150
    17.485   242.182     0.150
    17.485   242.438     0.150
    17.485   243.867     0.150
    17.485   437.768     0.150
    17.485   243.021     0.150
    17.506   245.268     0.150
    17.766   245.467     0.150
    17.814   249.258     0.150
    17.974   248.463     0.150
    17.985   249.088     0.150
    18.115   251.238     0.150
    18.115   463.537     0.150
    18.086   249.414     0.150
    18.086   249.957     0.150
    18.086   249.738     0.150
    18.175   251.736     0.150
    18.148   249.240     0.150
    18.148   250.918     0.150
    18.275   254.357     0.150
    18.275   468.348     0.150
    18.411   254.025     0.150
    18.866   259.736     0.150
    18.846   260.307     0.150
    19.052   263.168     0.150
    19.052   477.867     0.150
    19.154   261.967     0.150
    19.348   266.818     0.150
    19.332   265.043     0.150
    19.332   476.293     0.150
    19.337   263.668     0.150
    19.337   264.047     0.150
    19.326   266.668     0.150
    19.335   266.768     0.150
    19.335   268.092     0.150
    19.335   265.928     0.150
    19.407   264.168     0.150
    19.407   264.312     0.150
    19.407   263.947     0.150
    19.534   270.598     0.150
    19.586   268.738     0.150
    19.586   488.229     0.150
    19.578   267.268     0.150
    19.584   266.568     0.150
    19.584   266.693     0.150
    19.584   267.053     0.150
    19.584   267.168     0.150
    19.584   267.367     0.150
    19.584   487.068     0.150
    19.584   266.008     0.150
    19.584   266.568     0.150
    19.667   270.467     0.150
    19.667   490.768     0.150
    20.037   272.643     0.150
    20.037   498.217     0.150
    20.037   271.887     0.150
    20.037   272.867     0.150
    20.238   275.998     0.150
    20.127   275.428     0.150
    20.144   273.668     0.150
    20.144   273.930     0.150
    20.144   273.328     0.150
    20.144   274.168     0.150
    20.144   275.365     0.150
    20.144   274.438     0.150
    20.376   277.008     0.150
    20.481   512.707     0.150
    20.513   279.018     0.150
    20.516   276.967     0.150
    20.670   277.568     0.150
    20.670   509.457     0.150
    20.780   282.557     0.150
    20.817   283.438     0.150
    20.817   282.598     0.150
    20.903   283.658     0.150
    21.055   284.158     0.150
    21.058   283.467     0.150
    21.122   283.385     0.150
    21.122   282.797     0.150
    21.305   285.668     0.150
    21.250   286.307     0.150
    21.285   287.768     0.150
    21.285   527.467     0.150
    21.338   289.068     0.150
    21.437   288.268     0.150
    21.568   287.729     0.150
    21.568   530.418     0.150
    21.702   291.328     0.150
    21.702   533.068     0.150
    21.819   291.877     0.150
    21.819   538.787     0.150
    21.909   292.668     0.150
    21.963   293.768     0.150
    21.863   293.467     0.150
    21.863   293.297     0.150
    21.863   532.781     0.150
    21.863   293.127     0.150
    21.863   292.268     0.150
    21.863   313.068     0.150
    21.863   536.467     0.150
    21.919   293.697     0.150
    22.039   296.043     0.150
    22.047   296.307     0.150
    22.047   295.297     0.150
    22.047   296.668     0.150
    22.049   294.467     0.150
    22.188   296.568     0.150
    22.295   296.688     0.150
    22.225   298.057     0.150
    22.307   298.877     0.150
    22.307   298.658     0.150
    22.541   298.867     0.150
    22.490   301.068     0.150
    22.663   301.127     0.150
    22.663   544.578     0.150
    22.728   300.557     0.150
    22.728   532.588     0.150
    22.728   550.207     0.150
    22.766   302.959     0.150
    22.993   305.498     0.150
    23.011   304.668     0.150
    23.013   305.268     0.150
    23.014   305.367     0.150
    23.014   304.949     0.150
    23.014   305.238     0.150
    23.014   304.668     0.150
    23.014   306.945     0.150
    23.014   305.068     0.150
    23.014   535.018     0.150
    23.014   561.318     0.150
    23.014   304.658     0.150
    23.078   305.857     0.150
    23.195   304.178     0.150
    23.195   552.848     0.150
    23.263   306.998     0.150
    23.263   561.088     0.150
    23.265   304.967     0.150
    23.303   309.467     0.150
    23.303   309.150     0.150
    23.303   307.768     0.150
    23.313   307.668     0.150
    23.471   309.547     0.150
    23.417   309.867     0.150
    23.417   309.627     0.150
    23.417   308.697     0.150
    23.544   311.127     0.150
    23.566   311.367     0.150
    23.574   311.867     0.150
    23.574   567.768     0.150
    23.673   312.172     0.150
    23.673   311.848     0.150
    23.673   312.367     0.150
    23.673   313.021     0.150
    23.673   312.518     0.150
    24.006   314.398     0.150
    24.014   314.967     0.150
    24.188   315.598     0.150
    24.275   317.168     0.150
    24.275   576.367     0.150
    24.418   318.248     0.150
    24.509   319.807     0.150
    24.528   318.307     0.150
    24.679   321.398     0.150
    24.620   321.922     0.150
    24.930   325.057     0.150
    25.129   325.998     0.150
    25.128   324.668     0.150
    25.128   324.355     0.150
    25.128   324.668     0.150
    25.128   324.668     0.150
    25.128   593.693     0.150
    25.128   324.408     0.150
    25.214   325.547     0.150
    25.214   326.047     0.150
    25.214   541.729     0.150
    25.214   326.168     0.150
    25.214   362.768     0.150
    25.214   599.967     0.150
    25.217   327.383     0.150
    25.335   327.467     0.150
    25.485   328.537     0.150
    25.501   328.068     0.150
    25.430   328.268     0.150
    25.430   328.568     0.150
    25.430   327.803     0.150
    25.430   327.957     0.150
    25.430   327.617     0.150
    25.430   328.398     0.150
    25.510   328.617     0.150
    25.510   600.768     0.150
    25.472   328.037     0.150
    25.988   333.578     0.150
    26.089   331.777     0.150
    26.090   332.867     0.150
    26.282   334.457     0.150
    26.551   338.848     0.150
    26.587   339.168     0.150
    26.611   339.672     0.150
    26.811   340.768     0.150
    26.811   615.967     0.150
    26.859   342.816     0.150
    26.978   341.057     0.150
    26.886   342.367     0.150
    26.950   340.768     0.150
    26.941   342.268     0.150
    26.941   341.660     0.150
    26.941   622.711     0.150
    26.941   342.068     0.150
    26.941   384.568     0.150
    26.941   341.297     0.150
    26.941     4.260     0.150
    27.298   345.818     0.150
    27.298   625.188     0.150
    27.191   344.934     0.150
    27.217   345.621     0.150
    27.252   343.568     0.150
    27.280   345.467     0.150
    27.289   345.658     0.150
    27.382   346.832     0.150
    27.433   346.379     0.150
    27.433   346.508     0.150
    27.433   345.357     0.150
    27.433   345.967     0.150
    27.433   347.168     0.150
    27.472   345.465     0.150
    27.472   345.867     0.150
    27.469   347.268     0.150
    27.482   347.367     0.150
    27.482   347.668     0.150
    27.531   346.207     0.150
    27.531   346.768     0.150
    27.653   348.287     0.150
    27.750   349.238     0.150
    27.750   349.568     0.150
    27.810   350.467     0.150
    27.817   351.373     0.150
    27.815   350.934     0.150
    27.926   350.686     0.150
    27.915   351.812     0.150
    27.941   352.252     0.150
    27.991   351.867     0.150
    27.991   352.168     0.150
    28.075   351.346     0.150
    28.177   354.027     0.150
    28.177   641.637     0.150
    28.082   353.570     0.150
    28.089   354.668     0.150
    28.085   353.492     0.150
    28.201   352.898     0.150
    28.244   354.217     0.150
    28.189   352.008     0.150
    28.195   353.570     0.150
    28.283   354.467     0.150
    28.352   353.971     0.150
    28.356   355.988     0.150
    28.603   355.867     0.150
    28.529   355.768     0.150
    28.554   355.967     0.150
    28.525   357.367     0.150
    28.572   356.367     0.150
    28.572   546.467     0.150
    28.572   649.967     0.150
    28.572   356.518     0.150
    28.572   356.168     0.150
    28.579   356.365     0.150
    28.579   355.117     0.150
    28.579   356.168     0.150
    28.579   356.557     0.150
    28.579     4.301     0.150
    28.575   356.467     0.150
    28.583   356.268     0.150
    28.604   358.799     0.150
    28.629   356.668     0.150
    28.636   356.768     0.150
    28.649   357.268     0.150
    28.653   356.867     0.150
    28.676   358.625     0.150
    28.672   357.068     0.150
    28.676   358.484     0.150
    28.706   357.105     0.150
    28.712   359.504     0.150
    28.707   357.367     0.150
    28.817   359.762     0.150
    28.817   358.637     0.150
    28.817   358.873     0.150
    28.817   360.277     0.150
    28.779   359.285     0.150
    28.904   358.979     0.150
    28.833   360.164     0.150
    28.848   360.018     0.150
    28.848   358.568     0.150
    28.848   360.367     0.150
    28.852   360.867     0.150
    28.861   358.297     0.150
    28.853   361.318     0.150
    28.852   360.537     0.150
    28.861   359.416     0.150
    28.861   359.768     0.150
    28.899   361.268     0.150
    28.899   361.043     0.150
    29.031   359.717     0.150
    29.064   361.268     0.150
    29.145   360.307     0.150
    29.073   363.287     0.150
    29.080   362.021     0.150
    29.225   361.807     0.150
    29.167   361.088     0.150
    29.167   360.973     0.150
    29.188   361.168     0.150
    29.214   363.461     0.150
    29.254   362.125     0.150
    29.279   363.467     0.150
    29.249   362.953     0.150
    29.249   363.148     0.150
    29.249   362.527     0.150
    29.251   364.121     0.150
    29.277   364.166     0.150
    29.326   365.197     0.150
    29.326   364.062     0.150
    29.326   549.711     0.150
    29.326   364.479     0.150
    29.352   364.068     0.150
    29.352   364.467     0.150
    29.519   365.018     0.150
    29.449   364.312     0.150
    29.449   363.648     0.150
    29.449   363.760     0.150
    29.527   364.512     0.150
    29.643   363.424     0.150
    29.578   363.979     0.150
    29.578   364.102     0.150
    29.609   363.928     0.150
    29.497   366.568     0.150
    29.620   363.951     0.150
    29.673   364.643     0.150
    29.673   365.244     0.150
    29.780   366.182     0.150
    29.786   368.473     0.150
    29.807   367.668     0.150
    29.878   368.867     0.150
    29.868   367.523     0.150
    29.899   368.768     0.150
    29.903   369.668     0.150
    29.928   370.055     0.150
    29.941   369.395     0.150
    29.941   369.668     0.150
    29.973   368.189     0.150
    29.997   369.709     0.150
    30.022   368.471     0.150
    30.012   370.713     0.150
    30.022   369.410     0.150
    30.029   370.275     0.150
    30.210   371.555     0.150
    30.210   551.617     0.150
    30.210   369.084     0.150
    30.210   370.898     0.150
    30.206   371.768     0.150
    30.217   372.539     0.150
    30.222   372.078     0.150
    30.223   370.838     0.150
    30.314   373.367     0.150
    30.321   371.246     0.150
    30.337   371.254     0.150
    30.450   373.967     0.150
    30.450   679.367     0.150
    30.399   374.225     0.150
    30.413   372.715     0.150
    30.436   372.855     0.150
    30.436   373.367     0.150
    30.515   374.262     0.150
    30.512   374.367     0.150
    30.543   372.406     0.150
    30.599   374.410     0.150
    30.617   375.068     0.150
    30.665   374.631     0.150
    30.668   377.867     0.150
    30.681   375.539     0.150
    30.695   375.184     0.150
    30.684   376.209     0.150
    30.719   376.215     0.150
    30.740   375.057     0.150
    30.746   375.766     0.150
    30.789   375.557     0.150
    30.790   375.350     0.150
    30.826   376.051     0.150
    30.836   377.047     0.150
    30.836   377.307     0.150
    30.844   376.596     0.150
    30.859   377.367     0.150
    30.884   376.807     0.150
    30.884   436.258     0.150
    30.884   680.578     0.150
    30.905   377.262     0.150
    30.903   377.557     0.150
    30.913   377.088     0.150
    30.910   374.068     0.150
    30.937   375.588     0.150
    30.937   376.094     0.150
    30.960   375.926     0.150
    30.977   376.848     0.150
    30.968   377.768     0.150
    30.980   378.768     0.150
    31.054   377.975     0.150
    31.058   378.627     0.150
    31.066   378.021     0.150
    31.059   380.299     0.150
    31.101   378.967     0.150
    31.101   379.268     0.150
    31.076   378.000     0.150
    31.088   378.125     0.150
    31.087   378.344     0.150
    31.102   378.928     0.150
    31.109   378.012     0.150
    31.129   380.867     0.150
    31.148   378.729     0.150
    31.254   380.549     0.150
    31.254   379.426     0.150
    31.254   379.918     0.150
    31.151   380.568     0.150
    31.170   381.482     0.150
    31.197   380.383     0.150
    31.198   379.945     0.150
    31.203   379.537     0.150
    31.211   379.945     0.150
    31.243   379.947     0.150
    31.243   380.467     0.150
    31.245   381.043     0.150
    31.268   379.564     0.150
    31.300   378.336     0.150
    31.299   381.482     0.150
    31.340   379.594     0.150
    31.359   382.287     0.150
    31.359   382.467     0.150
    31.371   379.490     0.150
    31.392   379.586     0.150
    31.386   382.861     0.150
    31.441   382.967     0.150
    31.464   380.154     0.150
    31.457   383.461     0.150
    31.472   383.168     0.150
    31.492   383.467     0.150
    31.492   383.287     0.150
    31.525   383.467     0.150
    31.545   382.066     0.150
    31.555   381.031     0.150
    31.586   382.008     0.150
    31.586   382.818     0.150
    31.609   383.357     0.150
    31.622   383.133     0.150
    31.622   383.367     0.150
    31.680   381.902     0.150
    31.744   385.648     0.150
    31.744   386.068     0.150
    31.792   386.867     0.150
    31.806   384.812     0.150
    31.959   384.844     0.150
    31.959   384.508     0.150
    31.873   384.273     0.150
    31.911   384.076     0.150
    31.984   384.949     0.150
    31.983   385.545     0.150
    32.001   387.416     0.150
    32.012   383.770     0.150
    32.018   388.736     0.150
    32.047   384.826     0.150
    32.072   388.955     0.150
    32.074   388.338     0.150
    32.074   388.516     0.150
    32.091   389.787     0.150
    32.126   386.191     0.150
    32.126   387.701     0.150
    32.135   386.125     0.150
    32.141   388.736     0.150
    32.164   386.072     0.150
    32.160   389.100     0.150
    32.299   389.773     0.150
    32.299   389.438     0.150
    32.299   389.297     0.150
    32.221   389.834     0.150
    32.238   387.170     0.150
    32.286   389.467     0.150
    32.263   389.807     0.150
    32.263   390.488     0.150
    32.294   387.590     0.150
    32.294   387.848     0.150
    32.328   389.818     0.150
    32.326   389.568     0.150
    32.359   390.617     0.150
    32.359   389.729     0.150
    32.359   390.867     0.150
    32.368   388.010     0.150
    32.397   391.668     0.150
    32.397   391.498     0.150
    32.420   388.311     0.150
    32.441   389.033     0.150
    32.458   389.555     0.150
    32.480   388.379     0.150
    32.468   391.178     0.150
    32.468   392.168     0.150
    32.547   390.039     0.150
    32.555   389.193     0.150
    32.571   391.211     0.150
    32.655   391.195     0.150
    32.671   391.795     0.150
    32.675   394.311     0.150
    32.688   390.068     0.150
    32.688   462.168     0.150
    33.043   395.367     0.150
    33.043   710.168     0.150
    33.043   721.568     0.150
    32.958   396.068     0.150
    33.076   394.943     0.150
    33.084   393.361     0.150
    33.090   394.312     0.150
    33.100   394.475     0.150
    33.119   393.891     0.150
    33.119   395.021     0.150
    33.153   397.768     0.150
    33.209   394.904     0.150
    33.314   398.547     0.150
    33.220   395.154     0.150
    33.210   395.207     0.150
    33.210   396.398     0.150
    33.282   396.760     0.150
    33.282   397.268     0.150
    33.293   397.848     0.150
    33.328   398.707     0.150
    33.328   397.967     0.150
    33.328   398.268     0.150
    33.328   399.068     0.150
    33.328   398.863     0.150
    33.377   396.814     0.150
    33.416   398.988     0.150
    33.468   401.188     0.150
    33.484   400.678     0.150
    33.484   401.168     0.150
    33.509   398.557     0.150
    33.509   399.398     0.150
    33.523   399.867     0.150
    33.688   399.840     0.150
    33.688   400.068     0.150
    33.678   399.672     0.150
    33.678   399.818     0.150
    33.759   404.297     0.150
    33.759   404.518     0.150
    33.795   403.688     0.150
    33.795   402.768     0.150
    33.851   402.178     0.150
    33.847   403.168     0.150
    33.847   727.967     0.150
    33.961   403.668     0.150
    33.961   561.768     0.150
    33.961   731.492     0.150
    33.945   402.967     0.150
    33.945     4.201     0.150
    33.945   403.680     0.150
    33.961   405.217     0.150
    34.056   404.967     0.150
    34.056   473.768     0.150
    34.056   854.068     0.150
    34.089   405.387     0.150
    34.123   405.668     0.150
    34.123   405.777     0.150
    34.151   406.168     0.150
    34.166   406.068     0.150
    34.252   407.768     0.150
    34.327   408.098     0.150
    34.327   408.258     0.150
    34.327   408.588     0.150
    34.328   406.967     0.150
    34.328   406.688     0.150
    34.427   410.467     0.150
    34.459   408.467     0.150
    34.477   408.928     0.150
    34.477   409.176     0.150
    34.526   409.268     0.150
    34.543   409.568     0.150
    34.591   409.488     0.150
    34.591   409.887     0.150
    34.607   408.268     0.150
    34.667   408.277     0.150
    34.758   411.078     0.150
    34.758   411.357     0.150
    34.797   412.568     0.150
    34.834   411.768     0.150
    34.824   412.068     0.150
    34.832   411.998     0.150
    34.840   412.547     0.150
    34.846   412.367     0.150
    34.846   411.988     0.150
    35.086   412.367     0.150
    35.086   876.168     0.150
    35.003   412.467     0.150
    35.022   412.938     0.150
    35.022   412.768     0.150
    35.043   413.807     0.150
    35.075   414.068     0.150
    35.101   414.467     0.150
    35.110   414.367     0.150
    35.222   414.168     0.150
    35.222   747.967     0.150
    35.145   414.287     0.150
    35.145   748.436     0.150
    35.209   415.268     0.150
    35.209   753.268     0.150
    35.209   415.418     0.150
    35.209   414.947     0.150
    35.209   415.367     0.150
    35.304   416.168     0.150
    35.347   416.787     0.150
    35.347   417.068     0.150
    35.384   417.729     0.150
    35.384   417.469     0.150
    35.474   415.865     0.150
    35.474   416.738     0.150
    35.481   416.268     0.150
    35.487   416.367     0.150
    35.442   417.398     0.150
    35.442   415.768     0.150
    35.442   416.668     0.150
    35.452   417.268     0.150
    35.458   417.367     0.150
    35.465   418.578     0.150
    35.504   419.168     0.150
    35.587   418.697     0.150
    35.587   418.967     0.150
    35.589   418.979     0.150
    35.648   418.668     0.150
    35.783   420.457     0.150
    35.783   419.758     0.150
    35.913   419.428     0.150
    35.830   419.527     0.150
    35.848   420.768     0.150
    35.918   421.201     0.150
    35.918   420.707     0.150
    35.907   420.967     0.150
    35.956   420.164     0.150
    35.956   419.848     0.150
    35.956   420.297     0.150
    36.001   421.348     0.150
    36.008   421.867     0.150
    36.020   421.758     0.150
    36.058   422.668     0.150
    36.116   423.137     0.150
    36.141   422.686     0.150
    36.141   762.211     0.150
    36.141   423.568     0.150
    36.141   423.289     0.150
    36.145   423.268     0.150
    36.186   423.408     0.150
    36.242   424.207     0.150
    36.242   424.035     0.150
    36.307   424.318     0.150
    36.431   424.303     0.150
    36.431   424.168     0.150
    36.435   424.107     0.150
    36.367   425.357     0.150
    36.462   424.768     0.150
    36.462   511.867     0.150
    36.462   767.268     0.150
    36.466   424.947     0.150
    36.446   426.627     0.150
    36.446   424.688     0.150
    36.446   426.467     0.150
    36.446   773.568     0.150
    36.495   426.447     0.150
    36.625   425.297     0.150
    36.625   425.918     0.150
    36.625   569.518     0.150
    36.534   427.008     0.150
    36.534   427.807     0.150
    36.534   427.307     0.150
    36.640   425.867     0.150
    36.541   427.297     0.150
    36.541   426.967     0.150
    36.658   426.068     0.150
    36.587   426.258     0.150
    36.647   428.367     0.150
    36.644   426.697     0.150
    36.663   427.508     0.150
    36.663   772.578     0.150
    36.663   428.488     0.150
    36.663   428.367     0.150
    36.673   427.258     0.150
    36.673   430.318     0.150
    36.678   427.717     0.150
    36.678   515.268     0.150
    36.681   427.938     0.150
    36.681   428.115     0.150
    36.700   427.488     0.150
    36.700   427.229     0.150
    36.735   427.377     0.150
    36.739   427.670     0.150
    36.739   428.768     0.150
    36.739   427.988     0.150
    36.739   514.338     0.150
    36.791   426.768     0.150
    36.791   510.268     0.150
    36.791   570.568     0.150
    36.791   771.268     0.150
    36.824   427.988     0.150
    36.838   429.484     0.150
    36.859   429.367     0.150
    36.957   430.148     0.150
    36.957   430.006     0.150
    36.993   430.736     0.150
    37.152   430.627     0.150
    37.295   432.158     0.150
    37.322   433.428     0.150
    37.327   433.322     0.150
    37.330   433.607     0.150
    37.330   520.398     0.150
    37.330   786.887     0.150
    37.347   432.918     0.150
    37.533   434.168     0.150
    37.540   434.467     0.150
    37.540   434.137     0.150
    37.540   435.367     0.150
    37.540   435.268     0.150
    37.540   793.068     0.150
    37.562   434.787     0.150
    37.580   433.877     0.150
    37.580   433.568     0.150
    37.580   791.967     0.150
    37.591   435.467     0.150
    37.618   435.998     0.150
    37.652   435.658     0.150
    37.715   436.588     0.150
    37.715   436.467     0.150
    37.715   793.867     0.150
    37.862   437.217     0.150
    37.919   438.188     0.150
    37.935   437.467     0.150
    37.928   437.857     0.150
    37.946   438.207     0.150
    37.950   438.736     0.150
    37.976   438.229     0.150
    37.976   437.717     0.150
    37.978   438.736     0.150
    37.984   438.717     0.150
    37.993   438.857     0.150
    37.993   437.619     0.150
    37.993   438.793     0.150
    37.993   572.793     0.150
    37.993   788.287     0.150
    38.001   438.918     0.150
    38.001   438.047     0.150
    38.076   439.867     0.150
    38.076   792.967     0.150
    38.015   437.277     0.150
    38.038   439.488     0.150
    38.093   439.479     0.150
    38.093   438.777     0.150
    38.093   439.068     0.150
    38.093   790.367     0.150
    38.108   439.287     0.150
    38.124   438.828     0.150
    38.138   438.547     0.150
    38.138   439.328     0.150
    38.160   440.543     0.150
    38.161   440.498     0.150
    38.161   440.736     0.150
    38.213   440.848     0.150
    38.225   440.797     0.150
    38.278   441.520     0.150
    38.278   440.908     0.150
    38.278   440.467     0.150
    38.278   441.336     0.150
    38.321   441.588     0.150
    38.321   440.678     0.150
    38.321   440.971     0.150
    38.399   441.508     0.150
    38.451   442.037     0.150
    38.563   442.668     0.150
    38.563   799.967     0.150
    38.563   442.787     0.150
    38.548   443.297     0.150
    38.548   442.887     0.150
    38.553   442.818     0.150
    38.553   441.859     0.150
    38.588   443.857     0.150
    38.622   443.965     0.150
    38.651   444.268     0.150
    38.651   443.326     0.150
    38.651   530.768     0.150
    38.651   574.867     0.150
    38.651   802.768     0.150
    38.651   444.547     0.150
    38.708   445.168     0.150
    38.728   444.805     0.150
    38.780   444.947     0.150
    38.780   444.188     0.150
    38.849   446.068     0.150
    38.861   445.557     0.150
    38.904   447.008     0.150
    38.910   446.967     0.150
    39.151   447.168     0.150
    39.151   446.848     0.150
    39.018   446.758     0.150
    39.027   447.658     0.150
    39.037   446.758     0.150
    39.067   447.768     0.150
    39.105   448.717     0.150
    39.109   446.930     0.150
    38.987   447.947     0.150
    38.987   448.229     0.150
    39.281   448.918     0.150
    39.281   448.568     0.150
    39.265   449.527     0.150
    39.334   450.867     0.150
    39.334   544.768     0.150
    39.334   817.168     0.150
    39.334   974.867     0.150
    39.328   449.736     0.150
    39.334   449.547     0.150
    39.338   449.887     0.150
    39.351   450.377     0.150
    39.369   449.736     0.150
    39.367   450.498     0.150
    39.391   450.229     0.150
    39.392   450.508     0.150
    39.410   451.248     0.150
    39.430   451.137     0.150
    39.437   450.457     0.150
    39.437   450.707     0.150
    39.466   451.787     0.150
    39.529   451.348     0.150
    39.578   451.867     0.150
    39.602   452.877     0.150
    39.606   452.498     0.150
    39.620   451.746     0.150
    39.641   453.008     0.150
    39.641   453.117     0.150
    39.662   453.467     0.150
    39.662   451.459     0.150
    39.691   452.086     0.150
    39.758   452.967     0.150
    39.756   453.387     0.150
    39.769   453.908     0.150
    39.769   454.068     0.150
    39.848   454.248     0.150
    39.848   454.518     0.150
    39.848   453.383     0.150
    39.874   454.148     0.150
    39.889   455.098     0.150
    39.922   454.148     0.150
    39.949   454.477     0.150
    39.996   454.668     0.150
    39.996   455.219     0.150
    40.113   455.037     0.150
    40.113   455.979     0.150
    40.040   455.578     0.150
    40.047   457.797     0.150
    40.080   455.906     0.150
    40.080   824.492     0.150
    40.136   455.777     0.150
    40.175   457.098     0.150
    40.175   456.816     0.150
    40.178   458.088     0.150
    40.239   457.537     0.150
    40.239   456.867     0.150
    40.239   457.393     0.150
    40.239   549.492     0.150
    40.239   456.908     0.150
    40.247   456.967     0.150
    40.268   456.807     0.150
    40.278   457.457     0.150
    40.278   456.967     0.150
    40.326   456.988     0.150
    40.329   457.338     0.150
    40.335   458.967     0.150
    40.363   457.797     0.150
    40.363   456.635     0.150
    40.447   553.168     0.150
    40.517   460.168     0.150
    40.517   832.967     0.150
    40.524   459.148     0.150
    40.537   459.398     0.150
    40.537   581.658     0.150
    40.537   825.988     0.150
    40.533   459.668     0.150
    40.561   459.457     0.150
    40.567   460.857     0.150
    40.572   460.637     0.150
    40.578   460.928     0.150
    40.830   463.008     0.150
    40.916   462.457     0.150
    40.917   463.537     0.150
    40.936   462.268     0.150
    40.968   463.447     0.150
    40.968   462.447     0.150
    40.968   462.713     0.150
    41.017   463.148     0.150
    41.027   464.607     0.150
    41.097   463.492     0.150
    41.097   835.143     0.150
    41.156   463.818     0.150
    41.156   463.398     0.150
    41.271   466.367     0.150
    41.271  1066.168     0.150
    41.258   465.268     0.150
    41.276   465.488     0.150
    41.318   465.768     0.150
    41.346   465.818     0.150
    41.398   467.438     0.150
    41.435   467.648     0.150
    41.452   466.428     0.150
    41.462   467.438     0.150
    41.470   468.367     0.150
    41.474   468.658     0.150
    41.482   467.008     0.150
    41.497   467.148     0.150
    41.492   467.008     0.150
    41.513   467.168     0.150
    41.513   466.768     0.150
    41.513   467.367     0.150
    41.513   467.043     0.150
    41.513   562.668     0.150
    41.518   467.244     0.150
    41.532   467.418     0.150
    41.547   467.488     0.150
    41.547     4.689     0.150
    41.548   467.787     0.150
    41.548   467.408     0.150
    41.548   467.088     0.150
    41.548   467.568     0.150
    41.548   466.764     0.150
    41.573   469.117     0.150
    41.573   469.367     0.150
    41.668   469.467     0.150
    41.682   468.902     0.150
    41.682   468.707     0.150
    41.682   468.598     0.150
    41.727   469.748     0.150
    41.727   564.287     0.150
    41.727   845.127     0.150
    41.727  1029.117     0.150
    41.855   469.229     0.150
    41.855   468.707     0.150
    41.801   470.258     0.150
    41.801   567.229     0.150
    41.801  1033.637     0.150
    41.933   469.828     0.150
    41.946   470.547     0.150
    41.948   471.168     0.150
    41.948   471.848     0.150
    41.977   472.127     0.150
    41.977   471.320     0.150
    42.142   473.068     0.150
    42.173   473.307     0.150
    42.203   473.238     0.150
    42.230   473.918     0.150
    42.230   473.068     0.150
    42.290   474.668     0.150
    42.290   859.367     0.150
    42.245   474.367     0.150
    42.245   473.268     0.150
    42.273   473.938     0.150
    42.273   570.918     0.150
    42.273  1045.748     0.150
    42.349   475.068     0.150
    42.349   859.367     0.150
    42.321   473.537     0.150
    42.333   474.133     0.150
    42.333   473.998     0.150
    42.336   474.098     0.150
    42.427   475.383     0.150
    42.427   856.793     0.150
    42.427   474.898     0.150
    42.427   475.607     0.150
    42.358   474.867     0.150
    42.358   570.408     0.150
    42.358   818.828     0.150
    42.358   861.248     0.150
    42.374   474.527     0.150
    42.414   475.277     0.150
    42.439   475.207     0.150
    42.497   475.498     0.150
    42.517   476.717     0.150
    42.517   588.668     0.150
    42.517   475.967     0.150
    42.517   477.018     0.150
    42.590   474.738     0.150
    42.522   475.738     0.150
    42.538   475.928     0.150
    42.553   477.018     0.150
    42.556   476.527     0.150
    42.556   576.229     0.150
    42.556  1046.438     0.150
    42.567   476.408     0.150
    42.680   476.367     0.150
    42.590   476.217     0.150
    42.606   476.717     0.150
    42.606   573.988     0.150
    42.606   819.908     0.150
    42.606   861.348     0.150
    42.606  1049.777     0.150
    42.713   477.047     0.150
    42.844   477.297     0.150
    42.772   478.018     0.150
    42.772   863.018     0.150
    42.772  1050.377     0.150
    42.856   478.527     0.150
    42.935   478.598     0.150
    42.935   480.018     0.150
    42.854   479.867     0.150
    42.854   577.967     0.150
    42.854   863.367     0.150
    42.854  1051.268     0.150
    42.873   478.998     0.150
    42.915   479.998     0.150
    42.953   480.648     0.150
    42.953   480.188     0.150
    42.953   479.807     0.150
    42.953   480.318     0.150
    42.953   871.088     0.150
    42.953   478.840     0.150
    43.076   479.766     0.150
    43.076   480.107     0.150
    43.009   480.467     0.150
    43.045   479.057     0.150
    43.076   480.320     0.150
    43.076   479.938     0.150
    43.076   480.908     0.150
    43.034   480.988     0.150
    43.036   480.248     0.150
    43.081   480.918     0.150
    43.102   481.777     0.150
    43.102   582.398     0.150
    43.102   873.217     0.150
    43.102  1059.877     0.150
    43.258   482.148     0.150
    43.343   482.428     0.150
    43.461   482.287     0.150
    43.473   484.658     0.150
    43.476   484.857     0.150
    43.539   485.148     0.150
    43.539   485.328     0.150
    43.539   586.607     0.150
    43.539   879.268     0.150
    43.661   484.268     0.150
    43.661   875.068     0.150
    43.589   484.898     0.150
    43.613   485.328     0.150
    43.613   590.777     0.150
    43.831   487.467     0.150
    43.847   487.768     0.150
    43.848   486.568     0.150
    43.863   486.508     0.150
    43.985   486.668     0.150
    43.917   487.668     0.150
    43.917   590.818     0.150
    43.917  1075.637     0.150
    43.948   488.438     0.150
    43.980   488.387     0.150
    43.980   589.107     0.150
    44.035   487.938     0.150
    44.057   489.668     0.150
    44.078   489.088     0.150
    44.078   488.828     0.150
    44.135   489.838     0.150
    44.135   890.607     0.150
    44.191   490.068     0.150
    44.191   594.148     0.150
    44.191   882.148     0.150
    44.211   490.268     0.150
    44.260   490.578     0.150
    44.275   490.578     0.150
    44.347   489.543     0.150
    44.347   593.992     0.150
    44.347   885.992     0.150
    44.356   490.408     0.150
    44.356   491.277     0.150
    44.369   491.168     0.150
    44.360   490.818     0.150
    44.360   490.498     0.150
    44.360   490.297     0.150
    44.412   491.748     0.150
    44.412   888.998     0.150
    44.412  1088.258     0.150
    44.414   491.797     0.150
    44.517   492.568     0.150
    44.517   890.568     0.150
    44.483   492.967     0.150
    44.538   492.387     0.150
    44.579   493.428     0.150
    44.579   597.688     0.150
    44.579  1086.627     0.150
    44.623   492.768     0.150
    44.617   492.457     0.150
    44.782   495.268     0.150
    44.908   493.807     0.150
    44.908   493.588     0.150
    44.956   496.268     0.150
    44.962   495.338     0.150
    45.027   496.867     0.150
    45.114   495.168     0.150
    45.114   895.568     0.150
    45.114   495.857     0.150
    45.151   497.867     0.150
    45.275   495.338     0.150
    45.164   498.717     0.150
    45.450   499.668     0.150
    45.468   498.947     0.150
    45.468   499.207     0.150
    45.607   500.598     0.150
    45.607   499.688     0.150
    45.607   500.818     0.150
    45.607   500.188     0.150
    45.607     3.289     0.150
    45.976   502.508     0.150
    45.974   502.447     0.150
    46.085   505.668     0.150
    46.085   913.367     0.150
    46.140   505.229     0.150
    46.160   504.467     0.150
    46.299   505.898     0.150
    46.334   506.518     0.150
    46.419   506.467     0.150
    46.453   506.268     0.150
    46.587   507.996     0.150
    46.639   507.467     0.150
    46.647   509.268     0.150
    46.679   509.348     0.150
    46.866   508.367     0.150
    46.866   508.078     0.150
    46.866   507.857     0.150
    46.990   510.627     0.150
    46.990   510.758     0.150
    47.052   510.949     0.150
    47.052   510.688     0.150
    47.052   510.328     0.150
    46.977   511.697     0.150
    47.099   512.537     0.150
    47.099   512.938     0.150
    47.099   511.418     0.150
    47.115   513.768     0.150
    47.116   512.668     0.150
    47.116   626.068     0.150
    47.132   512.428     0.150
    47.141   513.387     0.150
    47.162   509.967     0.150
    47.301   513.967     0.150
    47.301   927.367     0.150
    47.275   513.297     0.150
    47.387   513.867     0.150
    47.392   514.967     0.150
    47.390   514.037     0.150
    47.422   514.408     0.150
    47.508   515.148     0.150
    47.566   515.717     0.150
    47.625   516.387     0.150
    47.698   518.307     0.150
    47.698   516.680     0.150
    47.698   628.342     0.150
    47.717   516.729     0.150
    47.882   517.678     0.150
    47.882   517.238     0.150
    47.783   517.418     0.150
    47.795   517.658     0.150
    47.871   518.457     0.150
    47.871   518.338     0.150
    48.022   519.367     0.150
    48.069   519.068     0.150
    48.069   941.867     0.150
    48.016   518.947     0.150
    48.097   519.967     0.150
    48.091   520.258     0.150
    48.113   519.998     0.150
    48.226   520.668     0.150
    48.223   520.867     0.150
    48.261   520.748     0.150
    48.406   521.857     0.150
    48.442   521.988     0.150
    48.446   522.668     0.150
    48.446   634.693     0.150
    48.446   945.258     0.150
    48.457   522.908     0.150
    48.457   523.088     0.150
    48.473   523.637     0.150
    48.473   522.848     0.150
    48.473   522.488     0.150
    48.473   523.467     0.150
    48.473   523.287     0.150
    48.473   523.137     0.150
    48.481   522.748     0.150
    48.500   522.428     0.150
    48.603   523.588     0.150
    48.629   523.818     0.150
    48.642   524.547     0.150
    48.739   526.367     0.150
    48.758   524.568     0.150
    48.854   525.873     0.150
    48.854   526.318     0.150
    48.854   610.678     0.150
    48.854   526.188     0.150
    48.873   526.168     0.150
    48.901   526.467     0.150
    48.892   525.328     0.150
    48.926   526.287     0.150
    48.992   526.467     0.150
    48.992   642.867     0.150
    49.068   527.428     0.150
    49.072   527.797     0.150
    49.181   528.018     0.150
    49.181   529.168     0.150
    49.181   527.521     0.150
    49.145   527.648     0.150
    49.213   528.467     0.150
    49.213  1117.568     0.150
    49.170   528.287     0.150
    49.314   529.568     0.150
    49.314   643.068     0.150
    49.314   952.367     0.150
    49.314   529.387     0.150
    49.247   528.818     0.150
    49.252   529.068     0.150
    49.322   529.197     0.150
    49.369   529.668     0.150
    49.445   530.377     0.150
    49.460   530.916     0.150
    49.600   531.568     0.150
    49.600   961.467     0.150
    49.633   531.479     0.150
    49.753   531.838     0.150
    49.753   531.658     0.150
    49.753   533.068     0.150
    49.753   613.768     0.150
    49.753   647.967     0.150
    49.753   960.068     0.150
    49.753   977.867     0.150
    49.753  1121.867     0.150
    49.726   531.938     0.150
    49.962   533.967     0.150
    50.144   535.217     0.150
    50.144   534.689     0.150
    50.149   535.668     0.150
    50.152   535.678     0.150
    50.152   535.479     0.150
    50.248   536.658     0.150
    50.248   536.318     0.150
    50.248   536.938     0.150
    50.228   536.268     0.150
    50.228   535.508     0.150
    50.280   536.127     0.150
    50.280   536.328     0.150
    50.280   617.398     0.150
    50.280   536.467     0.150
    50.370   536.979     0.150
    50.370   966.398     0.150
    50.360   537.248     0.150
    50.392   537.217     0.150
    50.392   537.367     0.150
    50.509   538.408     0.150
    50.509   539.721     0.150
    50.509   539.268     0.150
    50.538   538.043     0.150
    50.630   538.707     0.150
    50.630   969.787     0.150
    50.932   540.328     0.150
    50.865   540.688     0.150
    50.865   541.367     0.150
    50.865   540.967     0.150
    50.953   542.287     0.150
    51.136   542.375     0.150
    51.443   545.078     0.150
    51.443   981.498     0.150
    51.483   545.379     0.150
    51.483   545.098     0.150
    51.553   546.768     0.150
    51.622   547.068     0.150
    51.652   547.268     0.150
    51.661   546.637     0.150
    51.662   546.717     0.150
    51.662   992.418     0.150
    51.717   546.568     0.150
    51.717   987.768     0.150
    51.717  1137.168     0.150
    51.680   546.148     0.150
    51.684   546.867     0.150
    51.985   549.867     0.150
    51.998   550.828     0.150
    51.998   549.268     0.150
    52.036   550.498     0.150
    52.036   550.717     0.150
    52.036   549.568     0.150
    51.984   548.967     0.150
    51.984   549.438     0.150
    52.158   550.168     0.150
    52.158   993.367     0.150
    52.152   550.967     0.150
    52.233   550.854     0.150
    52.263   552.736     0.150
    52.264   551.768     0.150
    52.393   553.627     0.150
    52.393   551.318     0.150
    52.384   551.252     0.150
    52.384   550.898     0.150
    52.347   552.268     0.150
    52.443   552.287     0.150
    52.443   552.572     0.150
    52.443   552.518     0.150
    52.457   552.768     0.150
    52.461   552.867     0.150
    52.443   552.617     0.150
    52.443   998.668     0.150
    52.564   553.537     0.150
    52.894   555.037     0.150
    52.894   554.688     0.150
    53.048   557.338     0.150
    53.045   559.152     0.150
    53.045   558.637     0.150
    53.045   558.068     0.150
    53.210   559.736     0.150
    53.482   560.467     0.150
    53.484   559.938     0.150
    53.484   559.467     0.150
    53.484   560.143     0.150
    53.484   559.479     0.150
    53.496   560.568     0.150
    53.978   563.785     0.150
    54.004   563.629     0.150
    54.079   565.457     0.150
    54.079   564.828     0.150
    54.079   565.613     0.150
    54.144   566.363     0.150
    54.272   567.736     0.150
    54.270   566.428     0.150
    54.341   566.248     0.150
    54.341   565.617     0.150
    54.341   566.488     0.150
    54.397   567.768     0.150
    54.403   566.398     0.150
    54.403   567.098     0.150
    54.403   567.568     0.150
    54.403   567.357     0.150
    54.479   567.766     0.150
    54.492   568.037     0.150
    54.493   567.338     0.150
    54.573   569.617     0.150
    54.573   568.668     0.150
    54.573   567.768     0.150
    54.527   567.838     0.150
    54.527   567.037     0.150
    54.600   568.363     0.150
    54.590   568.164     0.150
    54.590   568.307     0.150
    54.590   568.633     0.150
    54.604   569.363     0.150
    54.765   569.057     0.150
    54.765   568.527     0.150
    54.770   569.867     0.150
    54.936   570.988     0.150
    54.862   571.338     0.150
    55.011   571.295     0.150
    55.011   571.627     0.150
    55.079   573.066     0.150
    55.168   573.068     0.150
    55.168   573.982     0.150
    55.168   572.367     0.150
    55.168   573.307     0.150
    55.168   574.812     0.150
    55.165   572.316     0.150
    55.165   572.633     0.150
    55.394   574.047     0.150
    55.394  1039.447     0.150
    55.564   575.408     0.150
    55.564  1041.627     0.150
    55.712   576.447     0.150
    55.712   578.338     0.150
    55.813   576.404     0.150
    55.813   577.266     0.150
    55.813   577.148     0.150
    55.742   577.748     0.150
    55.742   577.438     0.150
    55.790   577.037     0.150
    55.790  1044.748     0.150
    55.898   577.818     0.150
    55.898  1046.467     0.150
    55.921   578.736     0.150
    56.089   579.354     0.150
    56.089   578.758     0.150
    56.232   577.887     0.150
    56.226   580.746     0.150
    56.243   581.736     0.150
    56.400   581.197     0.150
    56.400   580.523     0.150
    56.400   580.957     0.150
    56.400   581.467     0.150
    56.415   583.773     0.150
    56.415   583.547     0.150
    56.415   580.998     0.150
    56.415   582.068     0.150
    56.415     6.490     0.150
    56.522   581.789     0.150
    56.522   582.127     0.150
    56.691   582.717     0.150
    56.691   582.297     0.150
    56.691   584.418     0.150
    56.746   582.768     0.150
    56.746  1060.568     0.150
    56.813   585.363     0.150
    56.870   583.938     0.150
    57.201   587.037     0.150
    57.201   585.490     0.150
    57.201   587.238     0.150
    57.201   587.848     0.150
    57.201   587.562     0.150
    57.566   590.736     0.150
    58.187   592.363     0.150
    58.187   592.588     0.150
    58.187   593.557     0.150
    58.187   592.768     0.150
    58.318   595.346     0.150
    58.283   595.412     0.150
    58.556  1082.467     0.150
    58.733   599.736     0.150
    59.089   600.668     0.150
    59.089   600.396     0.150
    59.089     3.699     0.150
    59.380   602.875     0.150
    59.511   603.668     0.150
    59.869   605.768     0.150
    59.869  1097.168     0.150
    59.869   605.293     0.150
    59.869   606.068     0.150
    59.869   605.498     0.150
    59.994   606.568     0.150
    59.982   607.588     0.150
    59.982   606.668     0.150
    60.070   607.178     0.150
    60.070   606.908     0.150
    60.070   606.688     0.150
    60.185   607.918     0.150
    60.227   607.297     0.150
    60.227   607.797     0.150
    60.300   608.367     0.150
    60.300   608.543     0.150
    60.316   609.268     0.150
    60.316   610.078     0.150
    60.316   609.768     0.150
    60.491   609.387     0.150
    60.491   609.027     0.150
    60.491     4.180     0.150
    60.493   609.680     0.150
    60.493   609.887     0.150
    60.934   613.068     0.150
    60.934   612.348     0.150
    61.219   615.627     0.150
    61.921   619.627     0.150
    62.601   625.398     0.150
    62.773   625.557     0.150
    62.773   625.898     0.150
    62.717   625.479     0.150
    62.717   625.217     0.150
    62.717   625.377     0.150
    62.885   625.998     0.150
    63.468   630.168     0.150
    63.468   629.738     0.150
    63.809   631.168     0.150
    63.809  1147.967     0.150
    63.941   632.754     0.150
    63.941   633.238     0.150
    64.110   633.564     0.150
    64.110   633.037     0.150
    64.110   634.268     0.150
    64.096   634.414     0.150
    64.096   634.197     0.150
    64.096   635.432     0.150
    64.443   635.408     0.150
    64.537   636.797     0.150
    64.591   637.818     0.150
    64.693   635.229     0.150
    64.947   639.568     0.150
    65.405   642.887     0.150
    65.405   642.148     0.150
    65.405   642.668     0.150
    65.553   643.807     0.150
    65.553   643.277     0.150
    65.686   644.447     0.150
    66.232   645.258     0.150
    66.352   646.637     0.150
    66.343   649.127     0.150
    66.342   649.068     0.150
    66.342   647.848     0.150
    66.342   647.617     0.150
    66.354   649.068     0.150
    66.639   650.863     0.150
    66.639   650.557     0.150
    66.639     5.070     0.150
    66.829   650.627     0.150
    66.894   652.088     0.150
    66.894   650.787     0.150
    66.894   676.768     0.150
    66.894   795.967     0.150
    66.894  1179.967     0.150
    66.894  1439.068     0.150
    66.998   652.842     0.150
    66.998   651.098     0.150
    66.998   650.045     0.150
    67.192   652.078     0.150
    67.192   651.967     0.150
    67.192   653.047     0.150
    67.192   651.061     0.150
    67.192   652.287     0.150
    67.127   653.092     0.150
    67.127   653.307     0.150
    67.900   658.088     0.150
    67.900   657.867     0.150
    67.900   658.697     0.150
    67.990   660.348     0.150
    68.131   660.562     0.150
    68.131   659.348     0.150
    68.131   660.697     0.150
    68.131   660.348     0.150
    68.131     3.391     0.150
    68.251   658.635     0.150
    68.251   658.918     0.150
    68.491   662.537     0.150
    68.603   663.217     0.150
    68.603   662.697     0.150
    68.603   662.967     0.150
    68.603     3.311     0.150
    69.000   665.268     0.150
    68.995   665.398     0.150
    68.995   666.207     0.150
    69.411   668.627     0.150
    69.537   669.238     0.150
    69.537   667.738     0.150
    69.537   668.238     0.150
    69.537   668.568     0.150
    70.038   669.688     0.150
    69.855   670.178     0.150
    70.143   671.537     0.150
    70.143   671.307     0.150
    70.143   671.768     0.150
    70.324   672.877     0.150
    70.324   673.729     0.150
    71.044   677.367     0.150
    71.044   678.963     0.150
    71.044   678.578     0.150
    71.822   682.393     0.150
    71.822   681.668     0.150
    71.822   682.117     0.150
    71.859   683.078     0.150
    72.133   684.137     0.150
    72.263   685.008     0.150
    72.409   686.918     0.150
    72.409   685.527     0.150
    72.409   687.857     0.150
    72.881   687.418     0.150
    72.910   688.887     0.150
    72.937   690.455     0.150
    73.150   690.887     0.150
    73.638   692.518     0.150
    73.658   692.787     0.150
    73.658   691.918     0.150
    73.658   690.785     0.150
    73.647   693.697     0.150
    73.695   693.938     0.150
    74.261   697.297     0.150
    74.341   697.713     0.150
    74.341   697.557     0.150
    74.344   698.367     0.150
    74.388   698.867     0.150
    74.388   698.148     0.150
    74.388   698.766     0.150
    74.398   699.348     0.150
    74.398   699.047     0.150
    74.380   697.188     0.150
    74.738   699.887     0.150
    74.738   698.338     0.150
    74.738   698.568     0.150
    74.656   698.758     0.150
    74.857   700.377     0.150
    74.941   701.367     0.150
    75.130   700.258     0.150
    75.238   700.258     0.150
    75.344   702.842     0.150
    75.612   705.367     0.150
    75.612   704.568     0.150
    75.612   704.447     0.150
    75.550   704.428     0.150
    75.550   705.295     0.150
    75.641   705.637     0.150
    75.641   704.729     0.150
    75.641   704.467     0.150
    75.968   707.178     0.150
    75.979   706.508     0.150
    76.393   706.357     0.150
    76.701   711.557     0.150
    76.701   711.318     0.150
    76.701   710.867     0.150
    77.047   713.541     0.150
    77.047   713.258     0.150
    77.047   712.668     0.150
    77.047   712.447     0.150
    77.302   714.348     0.150
    77.417   714.768     0.150
    77.594   716.127     0.150
    77.990   716.816     0.150
    77.951   718.896     0.150
    77.998   720.438     0.150
    77.998   718.527     0.150
    77.998   718.648     0.150
    77.998   719.508     0.150
    77.998   721.613     0.150
    78.092   719.887     0.150
    78.096   719.512     0.150
    78.096   718.777     0.150
    78.121   719.795     0.150
    78.129   718.738     0.150
    78.360   719.867     0.150
    78.360  1842.268     0.150
    78.360  1854.717     0.150
    78.360  2340.168     0.150
    78.360   719.729     0.150
    78.575   721.857     0.150
    78.763   722.348     0.150
    78.934   723.268     0.150
    79.582   726.768     0.150
    79.653   726.967     0.150
    79.761   726.568     0.150
    79.866   727.207     0.150
    80.101   729.207     0.150
    80.176   730.828     0.150
    80.268   731.016     0.150
    80.597   732.457     0.150
    80.596   732.357     0.150
    80.596   732.168     0.150
    80.596  1851.168     0.150
    80.805   733.543     0.150
    80.805   733.107     0.150
    80.804   733.318     0.150
    80.834   733.967     0.150
    80.846   734.277     0.150
    80.846   735.387     0.150
    80.974   734.268     0.150
    81.238   734.887     0.150
    81.238   734.088     0.150
    81.238   735.367     0.150
    81.162   735.078     0.150
    81.433   735.875     0.150
    81.433   736.648     0.150
    81.433   736.367     0.150
    81.555   738.635     0.150
    81.731   738.518     0.150
    81.664   738.676     0.150
    81.982   740.555     0.150
    82.202   740.756     0.150
    82.242   740.898     0.150
    82.224   741.307     0.150
    82.716   744.236     0.150
    82.961   742.963     0.150
    82.961   742.738     0.150
    83.022   745.658     0.150
    83.030   745.357     0.150
    83.063   745.137     0.150
    83.079   746.816     0.150
    83.146   745.768     0.150
    83.146  1365.240     0.150
    83.329   746.242     0.150
    83.381   745.562     0.150
    83.296   746.807     0.150
    83.459   748.188     0.150
    83.459   747.678     0.150
    83.459   747.537     0.150
    83.459   747.863     0.150
    83.488   750.115     0.150
    83.488   747.607     0.150
    83.543   748.107     0.150
    83.672   747.217     0.150
    83.726   749.398     0.150
    83.925   748.463     0.150
    84.035   750.797     0.150
    84.035   750.127     0.150
    84.035   749.637     0.150
    84.073   750.828     0.150
    84.285   749.627     0.150
    84.901   753.865     0.150
    84.793   753.967     0.150
    84.827   754.707     0.150
    84.827   754.178     0.150
    84.956   754.268     0.150
    84.956   752.613     0.150
    85.148   755.688     0.150
    85.165   756.367     0.150
    85.288   756.729     0.150
    85.880   758.758     0.150
    86.042   761.717     0.150
    86.018   760.668     0.150
    86.065   762.055     0.150
    86.065   760.828     0.150
    86.302   760.912     0.150
    86.504   762.318     0.150
    86.419   764.275     0.150
    86.596   762.393     0.150
    86.525   763.057     0.150
    86.740   763.418     0.150
    86.857   763.768     0.150
    87.182   766.287     0.150
    87.469   767.947     0.150
    87.602   767.818     0.150
    87.602  1395.393     0.150
    87.602  1831.143     0.150
    87.602  2322.943     0.150
    87.602   767.277     0.150
    87.602   767.568     0.150
    87.762   768.293     0.150
    89.579   777.172     0.150
    89.579  1403.842     0.150
    89.579  1827.318     0.150
    89.579  2319.668     0.150
    89.579   776.768     0.150
    89.579   777.193     0.150
    89.611   777.268     0.150
    89.630   777.617     0.150
    89.900   779.287     0.150
    89.900   779.047     0.150
    90.095   779.967     0.150
    90.095   779.178     0.150
    90.095   779.568     0.150
    90.761   783.467     0.150
    91.211   786.068     0.150
    91.910   788.117     0.150
    93.200   793.672     0.150
    93.200  1818.693     0.150
    93.376   794.342     0.150
    93.282   794.277     0.150
    93.769   796.117     0.150
    94.328   798.857     0.150
    95.515   804.637     0.150
    96.207   807.188     0.150
    96.386   809.518     0.150
    96.415   809.562     0.150
    96.660   809.467     0.150
    96.660   809.117     0.150
    96.732   809.318     0.150
    96.735   809.088     0.150
    96.948   810.992     0.150
    97.222   811.887     0.150
    97.445   812.527     0.150
    97.632   813.893     0.150
    97.770   813.457     0.150
    98.452   818.088     0.150
    98.841   822.488     0.150
    98.963   820.617     0.150
    99.313   823.867     0.150
    99.514   822.707     0.150
    99.918   825.717     0.150
    99.918   823.996     0.150
    99.918  1456.793     0.150
    99.918  1803.842     0.150
    99.903   825.893     0.150
   100.553   828.912     0.150
   101.948   833.193     0.150
   101.948  1467.617     0.150
   101.948  1798.818     0.150
   102.551   837.418     0.150
   102.551  1794.717     0.150
   102.551  2295.168     0.150
   104.668   845.867     0.150
   104.668  1100.768     0.150
   107.280   858.342     0.150
   107.280  1781.242     0.150
   107.280  2286.367     0.150
   111.019  1111.568     0.150
   114.046  1117.725     0.150
   114.046  1763.664     0.150
   114.810  1122.588     0.150
   114.906  1121.143     0.150
   114.906  1178.717     0.150
   114.906  1756.443     0.150
   114.906  2273.443     0.150
   114.959  1121.627     0.150
   115.191  1119.316     0.150
   115.191  1756.377     0.150
   115.191  1120.078     0.150
   115.191  2271.811     0.150
   116.022  1120.936     0.150
   116.022  1755.459     0.150
   116.129  1121.412     0.150
   116.129  1755.525     0.150
   116.413  1122.967     0.150
   118.486  1127.338     0.150
   122.259  1134.018     0.150
   123.052  1138.242     0.150
   123.568  1137.318     0.150
   123.692  1137.967     0.150
   123.738  1137.863     0.150
   123.738  1137.568     0.150
   124.469  1137.111     0.150
   124.667  1136.967     0.150
   124.788  1139.371     0.150
   125.143  1139.047     0.150
   125.270  1139.768     0.150
   125.480  1139.381     0.150
   125.852  1140.961     0.150
   125.882  1141.768     0.150
   125.821  1140.008     0.150
   125.900  1142.537     0.150
   125.959  1143.078     0.150
   126.080  1141.357     0.150
   126.331  1142.967     0.150
   126.464  1142.367     0.150
   126.731  1142.787     0.150
   126.731  1141.967     0.150
   126.731  1141.568     0.150
   127.117  1147.627     0.150
   127.215  1143.607     0.150
   127.279  1141.748     0.150
   127.360  1144.877     0.150
   127.646  1143.992     0.150
   127.817  1146.088     0.150
   128.192  1147.443     0.150
   128.277  1147.568     0.150
   128.415  1150.467     0.150
   129.617  1151.475     0.150
   131.079  1150.807     0.150
   131.720  1151.367     0.150
   131.821  1154.043     0.150
   131.821  1153.117     0.150
   133.600  1161.967     0.150
   134.005  1159.463     0.150
   134.157  1159.238     0.150
   134.362  1157.867     0.150
   134.477  1158.617     0.150
   134.602  1156.547     0.150
   135.317  1161.188     0.150
   135.659  1162.818     0.150
   136.154  1161.988     0.150
   136.296  1164.338     0.150
   136.305  1161.867     0.150
   138.462  1164.117     0.150
   139.616  1165.488     0.150
   139.616  1168.668     0.150
   142.246  1169.592     0.150
   142.246  1170.342     0.150
   143.600  1171.217     0.150
   144.344  1177.168     0.150
   147.205  1183.188     0.150
   147.226  1185.217     0.150
   147.609  1180.168     0.150
     1.430    26.145     0.150
     1.430    27.094     0.150
     1.673    30.145     0.150
     1.673    29.674     0.150
     1.783    31.645     0.150
     1.783    32.994     0.150
     1.966    35.164     0.150
     2.315    39.244     0.150
     2.555    43.045     0.150
     2.547    42.645     0.150
     2.693    44.744     0.150
     2.773    47.055     0.150
     2.977    48.445     0.150
     3.213    52.445     0.150
     3.549    57.045     0.150
     3.904    61.145     0.150
     3.904    61.365     0.150
     4.091    64.105     0.150
     4.098    63.844     0.150
     4.435    68.645     0.150
     4.411    68.445     0.150
     4.475    70.895     0.150
     4.475   120.145     0.150
     4.607    71.244     0.150
     4.634    71.045     0.150
     4.736    73.125     0.150
     5.183    78.744     0.150
     5.577    85.215     0.150
     5.675    85.844     0.150
     5.735    86.744     0.150
     5.891    86.625     0.150
     5.878    88.045     0.150
     6.041    91.244     0.150
     6.130    92.645     0.150
     6.141    92.465     0.150
     6.235    93.615     0.150
     6.510    97.885     0.150
     6.601    98.545     0.150
     6.933   103.244     0.150
     7.109   104.844     0.150
     7.109   106.125     0.150
     7.130   105.783     0.150
     7.130   183.098     0.150
     7.130   105.414     0.150
     7.241   108.045     0.150
     7.241   108.914     0.150
     7.374   109.344     0.150
     7.559   111.945     0.150
     7.564   112.645     0.150
     7.799   116.455     0.150
     7.924   116.734     0.150
     8.161   120.344     0.150
     8.465   124.445     0.150
     8.528   124.645     0.150
     8.677   127.045     0.150
     8.676   127.744     0.150
     8.792   128.744     0.150
     8.900   131.375     0.150
     8.912   129.955     0.150
     9.112   133.314     0.150
     9.258   134.625     0.150
     9.742   140.994     0.150
     9.792   142.785     0.150
     9.913   146.090     0.150
     9.909   143.914     0.150
     9.956   146.303     0.150
    10.001   144.225     0.150
    10.503   153.855     0.150
    10.511   153.244     0.150
    10.647   152.375     0.150
    10.773   152.328     0.150
    10.773   270.482     0.150
    10.773   154.174     0.150
    10.865   154.064     0.150
    10.865   159.416     0.150
    11.000   159.385     0.150
    11.000   161.002     0.150
    11.048   161.975     0.150
    11.030   158.605     0.150
    11.091   159.422     0.150
    11.091   158.285     0.150
    11.157   162.414     0.150
    11.286   164.645     0.150
    11.286   291.645     0.150
    11.478   167.764     0.150
    11.738   170.344     0.150
    11.841   170.918     0.150
    11.819   171.844     0.150
    11.819   302.244     0.150
    11.925   172.445     0.150
    12.035   174.082     0.150
    12.119   171.424     0.150
    12.217   177.447     0.150
    12.273   175.754     0.150
    12.262   176.994     0.150
    12.561   181.666     0.150
    12.649   181.025     0.150
    12.685   181.516     0.150
    12.655   179.375     0.150
    12.655   179.564     0.150
    12.655   318.588     0.150
    12.655   319.500     0.150
    12.655   180.244     0.150
    12.655   178.445     0.150
    13.316   191.844     0.150
    13.316   340.045     0.150
    13.472   190.545     0.150
    13.710   198.045     0.150
    13.710   350.844     0.150
    13.878   199.744     0.150
    13.878   354.844     0.150
    13.933   197.395     0.150
    13.943   198.344     0.150
    13.943   353.744     0.150
    14.052   200.785     0.150
    14.104   198.945     0.150
    14.104   199.945     0.150
    14.333   203.615     0.150
    14.351   201.855     0.150
    14.662   205.914     0.150
    14.662   205.594     0.150
    14.662   362.994     0.150
    14.662   206.564     0.150
    14.695   210.939     0.150
    14.695   209.664     0.150
    14.695   212.754     0.150
    14.856   211.615     0.150
    14.919   215.375     0.150
    15.169   215.328     0.150
    15.334   216.025     0.150
    15.337   217.025     0.150
    15.648   218.984     0.150
    15.648   388.500     0.150
    15.705   220.895     0.150
    15.704   221.959     0.150
    15.776   222.445     0.150
    15.774   225.834     0.150
    15.798   222.039     0.150
    15.798   221.715     0.150
    16.024   223.395     0.150
    16.024   396.045     0.150
    16.024   223.193     0.150
    16.024   396.848     0.150
    16.024   223.545     0.150
    16.349   229.564     0.150
    16.159   227.121     0.150
    16.206   231.744     0.150
    16.325   229.504     0.150
    16.707   237.844     0.150
    17.202   242.145     0.150
    17.236   241.965     0.150
    17.265   241.719     0.150
    17.406   242.963     0.150
    17.485   243.148     0.150
    17.500   247.744     0.150
    17.976   251.016     0.150
    18.097   251.074     0.150
    18.097   250.785     0.150
    18.097   250.625     0.150
    18.178   252.578     0.150
    18.157   251.492     0.150
    18.414   256.691     0.150
    18.869   260.791     0.150
    19.067   265.244     0.150
    19.138   265.344     0.150
    19.332   266.070     0.150
    19.341   267.844     0.150
    19.351   269.246     0.150
    19.399   266.197     0.150
    19.399   266.455     0.150
    19.399   266.678     0.150
    19.399   264.984     0.150
    19.575   269.443     0.150
    19.575   269.045     0.150
    19.575   268.344     0.150
    19.575   268.469     0.150
    19.575   268.145     0.150
    19.575   269.445     0.150
    19.652   270.344     0.150
    19.682   271.945     0.150
    20.032   274.344     0.150
    20.032   273.631     0.150
    20.139   274.914     0.150
    20.139   274.727     0.150
    20.139   276.244     0.150
    20.500   278.445     0.150
    20.465   499.344     0.150
    20.664   280.064     0.150
    20.834   284.574     0.150
    20.834   283.025     0.150
    20.919   284.975     0.150
    21.042   287.344     0.150
    21.105   284.998     0.150
    21.105   284.695     0.150
    21.288   287.445     0.150
    21.266   288.115     0.150
    21.300   289.645     0.150
    21.300   529.545     0.150
    21.893   296.045     0.150
    21.869   294.746     0.150
    21.869   294.287     0.150
    21.869   294.475     0.150
    21.908   322.145     0.150
    21.908   294.834     0.150
    22.055   295.820     0.150
    22.063   298.404     0.150
    22.063   295.484     0.150
    22.061   295.744     0.150
    22.241   299.945     0.150
    22.323   299.094     0.150
    22.524   300.945     0.150
    22.714   300.625     0.150
    22.714   533.465     0.150
    22.714   550.355     0.150
    22.782   304.207     0.150
    23.009   307.025     0.150
    23.027   305.844     0.150
    23.030   307.283     0.150
    23.030   307.004     0.150
    23.030   306.844     0.150
    23.030   307.045     0.150
    23.030   534.463     0.150
    23.030   307.344     0.150
    23.094   306.295     0.150
    23.249   309.445     0.150
    23.319   310.494     0.150
    23.319   310.648     0.150
    23.319   309.369     0.150
    23.319   308.945     0.150
    23.326   308.645     0.150
    23.433   309.525     0.150
    23.433   310.184     0.150
    23.433   309.744     0.150
    23.560   312.314     0.150
    23.579   312.045     0.150
    23.589   313.145     0.150
    23.689   314.105     0.150
    23.689   313.605     0.150
    23.689   313.955     0.150
    23.990   316.045     0.150
    24.006   315.945     0.150
    24.287   318.645     0.150
    24.637   321.857     0.150
    24.946   324.564     0.150
    25.123   326.107     0.150
    25.123   325.545     0.150
    25.123   325.945     0.150
    25.123   325.674     0.150
    25.197   326.244     0.150
    25.197   327.375     0.150
    25.197   541.475     0.150
    25.233   328.641     0.150
    25.342   329.945     0.150
    25.446   329.445     0.150
    25.446   329.164     0.150
    25.488   329.234     0.150
    26.005   333.555     0.150
    26.298   335.514     0.150
    26.534   339.385     0.150
    26.796   340.244     0.150
    26.961   342.395     0.150
    26.967   341.605     0.150
    26.953   342.787     0.150
    26.953   341.945     0.150
    26.953   385.145     0.150
    26.953   343.494     0.150
    27.448   347.525     0.150
    27.448   346.744     0.150
    27.547   346.824     0.150
    27.669   349.475     0.150
    27.765   350.404     0.150
    27.765   351.045     0.150
    27.831   351.783     0.150
    27.931   352.918     0.150
    28.097   353.941     0.150
    28.185   353.344     0.150
    28.228   353.584     0.150
    28.298   354.945     0.150
    28.372   356.320     0.150
    28.543   356.645     0.150
    28.568   356.844     0.150
    28.586   357.420     0.150
    28.586   546.070     0.150
    28.586   357.574     0.150
    28.586   357.045     0.150
    28.593   357.537     0.150
    28.593     3.330     0.150
    28.596   357.145     0.150
    28.643   357.545     0.150
    28.650   357.645     0.150
    28.667   357.744     0.150
    28.686   357.945     0.150
    28.721   358.244     0.150
    28.727   359.699     0.150
    28.888   360.564     0.150
    28.863   361.625     0.150
    28.863   359.645     0.150
    28.867   361.945     0.150
    28.877   360.455     0.150
    28.914   361.709     0.150
    28.914   361.744     0.150
    28.914   362.275     0.150
    29.088   364.828     0.150
    29.208   362.734     0.150
    29.202   362.244     0.150
    29.265   364.154     0.150
    29.265   363.945     0.150
    29.342   366.785     0.150
    29.342   365.885     0.150
    29.342   367.096     0.150
    29.465   364.514     0.150
    29.594   365.184     0.150
    29.802   369.664     0.150
    29.915   369.844     0.150
    29.957   370.744     0.150
    30.226   371.857     0.150
    30.226   371.434     0.150
    30.221   373.344     0.150
    30.238   373.184     0.150
    30.238   372.475     0.150
    30.312   372.545     0.150
    30.436   375.445     0.150
    30.735   377.244     0.150
    30.852   377.955     0.150
    30.852   378.156     0.150
    30.929   377.135     0.150
    31.039   380.445     0.150
    31.117   380.145     0.150
    31.242   381.266     0.150
    31.242   379.395     0.150
    31.214   381.277     0.150
    31.226   381.014     0.150
    31.259   381.344     0.150
    31.374   383.814     0.150
    31.401   384.332     0.150
    31.472   384.225     0.150
    31.474   382.410     0.150
    31.507   384.945     0.150
    31.507   384.605     0.150
    31.602   383.955     0.150
    31.621   384.984     0.150
    31.638   384.244     0.150
    31.746   385.551     0.150
    31.759   386.014     0.150
    31.759   386.344     0.150
    31.943   386.590     0.150
    31.943   386.004     0.150
    32.089   388.965     0.150
    32.176   390.068     0.150
    32.286   389.664     0.150
    32.286     3.301     0.150
    32.286   558.365     0.150
    32.237   390.918     0.150
    32.278   390.334     0.150
    32.310   388.754     0.150
    32.341   390.045     0.150
    32.374   391.645     0.150
    32.374   391.195     0.150
    32.374   392.344     0.150
    32.413   392.621     0.150
    32.412   393.045     0.150
    32.479   390.275     0.150
    33.027   396.445     0.150
    32.973   397.115     0.150
    33.223   396.814     0.150
    33.298   398.344     0.150
    33.341   400.094     0.150
    33.341   399.545     0.150
    33.341   398.844     0.150
    33.432   400.314     0.150
    33.499   401.775     0.150
    33.525   399.744     0.150
    33.525   400.094     0.150
    33.672   400.914     0.150
    33.672   401.092     0.150
    33.694   400.984     0.150
    33.810   404.754     0.150
    33.810   403.824     0.150
    33.810   405.045     0.150
    33.947   404.145     0.150
    33.960   404.135     0.150
    33.960     4.100     0.150
    33.960   404.814     0.150
    34.042   407.344     0.150
    34.134   406.625     0.150
    34.267   409.645     0.150
    34.318   409.545     0.150
    34.318   408.344     0.150
    34.318   407.344     0.150
    34.318   409.295     0.150
    34.343   407.805     0.150
    34.492   409.775     0.150
    34.492   409.920     0.150
    34.604   411.344     0.150
    34.770   411.035     0.150
    34.855   413.664     0.150
    34.861   412.955     0.150
    35.058   415.045     0.150
    35.207   414.344     0.150
    35.156   415.004     0.150
    35.156   415.344     0.150
    35.221   415.965     0.150
    35.223   416.105     0.150
    35.320   417.234     0.150
    35.361   417.805     0.150
    35.361   417.645     0.150
    35.399   418.674     0.150
    35.463   416.605     0.150
    35.463   565.486     0.150
    35.463   417.295     0.150
    35.470   417.045     0.150
    35.477   417.045     0.150
    35.458   418.305     0.150
    35.458   417.875     0.150
    35.480   420.195     0.150
    35.519   419.145     0.150
    35.602   419.695     0.150
    35.602   420.145     0.150
    35.602   419.344     0.150
    35.604   419.955     0.150
    35.604   419.744     0.150
    35.799   421.834     0.150
    35.799   420.615     0.150
    35.897   420.305     0.150
    35.907   422.373     0.150
    35.907   421.695     0.150
    35.907   422.145     0.150
    35.972   421.105     0.150
    35.972   421.439     0.150
    36.017   421.045     0.150
    36.023   422.965     0.150
    36.130   424.535     0.150
    36.155   424.305     0.150
    36.155   424.133     0.150
    36.160   424.174     0.150
    36.201   424.434     0.150
    36.257   425.004     0.150
    36.415   425.189     0.150
    36.415   425.055     0.150
    36.415     3.609     0.150
    36.415   569.584     0.150
    36.419   425.105     0.150
    36.382   426.426     0.150
    36.446   425.744     0.150
    36.450   425.564     0.150
    36.460   427.605     0.150
    36.460   426.795     0.150
    36.460   427.244     0.150
    36.510   427.211     0.150
    36.609   426.615     0.150
    36.609   426.344     0.150
    36.609   569.195     0.150
    36.609   426.764     0.150
    36.548   427.855     0.150
    36.548   427.615     0.150
    36.556   428.965     0.150
    36.556   428.744     0.150
    36.624   426.045     0.150
    36.642   426.145     0.150
    36.603   427.375     0.150
    36.654   428.635     0.150
    36.662   428.945     0.150
    36.678   429.885     0.150
    36.690   428.295     0.150
    36.693   428.855     0.150
    36.697   429.025     0.150
    36.697   428.295     0.150
    36.697   429.143     0.150
    36.697   568.926     0.150
    36.716   428.594     0.150
    36.716   428.344     0.150
    36.747   428.965     0.150
    36.747   428.814     0.150
    36.800   428.445     0.150
    36.834   429.904     0.150
    36.853   430.510     0.150
    36.853   570.053     0.150
    36.972   430.785     0.150
    36.972   431.084     0.150
    37.009   431.627     0.150
    37.009   571.180     0.150
    37.305   433.264     0.150
    37.338   434.125     0.150
    37.338   434.332     0.150
    37.342   434.494     0.150
    37.345   434.555     0.150
    37.540   435.045     0.150
    37.540   434.855     0.150
    37.540   435.244     0.150
    37.540   435.645     0.150
    37.549   435.504     0.150
    37.555   435.744     0.150
    37.577   436.182     0.150
    37.595   434.885     0.150
    37.606   436.244     0.150
    37.632   437.475     0.150
    37.730   437.625     0.150
    37.794   437.814     0.150
    37.878   438.275     0.150
    37.927   439.285     0.150
    37.942   438.504     0.150
    37.951   438.695     0.150
    37.961   439.135     0.150
    37.965   439.879     0.150
    37.991   439.365     0.150
    37.991   439.264     0.150
    37.993   439.705     0.150
    37.999   439.625     0.150
    38.008   439.744     0.150
    38.008   439.166     0.150
    38.008   439.219     0.150
    38.008   573.494     0.150
    38.017   439.785     0.150
    38.017   439.344     0.150
    38.029   438.164     0.150
    38.053   440.365     0.150
    38.054   439.865     0.150
    38.108   440.605     0.150
    38.108   440.395     0.150
    38.108   439.645     0.150
    38.151   439.904     0.150
    38.177   441.395     0.150
    38.176   441.574     0.150
    38.222   441.814     0.150
    38.239   441.934     0.150
    38.294   442.605     0.150
    38.294   443.115     0.150
    38.294   441.684     0.150
    38.294   441.545     0.150
    38.335   442.625     0.150
    38.335   441.629     0.150
    38.415   442.775     0.150
    38.466   443.285     0.150
    38.548   443.445     0.150
    38.564   444.344     0.150
    38.564   444.084     0.150
    38.568   444.818     0.150
    38.597   444.965     0.150
    38.637   445.078     0.150
    38.666   445.715     0.150
    38.666   445.199     0.150
    38.666     3.600     0.150
    38.666   535.145     0.150
    38.722   446.445     0.150
    38.744   445.807     0.150
    38.796   445.885     0.150
    38.796   445.744     0.150
    38.919   448.064     0.150
    38.924   448.025     0.150
    38.941   446.814     0.150
    38.941   446.240     0.150
    39.031   447.865     0.150
    39.042   448.654     0.150
    39.135   448.164     0.150
    39.135   447.504     0.150
    39.081   448.365     0.150
    39.120   450.545     0.150
    39.124   448.084     0.150
    38.971   448.855     0.150
    38.971   448.504     0.150
    39.264   449.619     0.150
    39.279   450.555     0.150
    39.343   450.590     0.150
    39.343   577.717     0.150
    39.349   450.285     0.150
    39.353   451.084     0.150
    39.366   451.305     0.150
    39.381   452.195     0.150
    39.384   450.244     0.150
    39.384   578.090     0.150
    39.406   451.885     0.150
    39.405   451.805     0.150
    39.424   452.404     0.150
    39.445   451.975     0.150
    39.452   451.395     0.150
    39.452   452.365     0.150
    39.481   452.824     0.150
    39.544   452.465     0.150
    39.594   452.674     0.150
    39.617   454.574     0.150
    39.635   452.600     0.150
    39.635   578.959     0.150
    39.676   454.484     0.150
    39.681   453.664     0.150
    39.706   452.844     0.150
    39.706   578.711     0.150
    39.769   454.145     0.150
    39.783   454.775     0.150
    39.863   455.385     0.150
    39.863   454.768     0.150
    39.887   455.504     0.150
    39.937   455.096     0.150
    39.937   579.393     0.150
    39.965   455.201     0.150
    39.965   580.367     0.150
    40.004   456.145     0.150
    40.004   456.475     0.150
    40.004   456.615     0.150
    40.004   456.295     0.150
    40.050   456.795     0.150
    40.097   457.047     0.150
    40.097   456.795     0.150
    40.092   456.707     0.150
    40.189   457.924     0.150
    40.189   456.971     0.150
    40.248   458.385     0.150
    40.248   458.045     0.150
    40.248   457.895     0.150
    40.248   549.795     0.150
    40.248   458.334     0.150
    40.256   458.145     0.150
    40.278   457.945     0.150
    40.281   458.334     0.150
    40.294   458.814     0.150
    40.294   458.564     0.150
    40.350   459.754     0.150
    40.378   458.584     0.150
    40.378   458.844     0.150
    40.438   459.844     0.150
    40.539   460.164     0.150
    40.539   460.303     0.150
    40.539   581.879     0.150
    40.542   460.824     0.150
    40.553   459.865     0.150
    40.574   460.254     0.150
    40.581   461.395     0.150
    40.581   461.805     0.150
    40.592   461.984     0.150
    40.845   464.295     0.150
    40.931   463.264     0.150
    40.931   463.535     0.150
    40.931   464.855     0.150
    40.951   463.564     0.150
    40.983   464.465     0.150
    40.983   463.805     0.150
    40.983   464.033     0.150
    41.030   464.004     0.150
    41.090   463.895     0.150
    41.090   464.895     0.150
    41.171   464.914     0.150
    41.171   464.605     0.150
    41.256   467.445     0.150
    41.256   842.145     0.150
    41.256  1065.844     0.150
    41.268   466.645     0.150
    41.288   466.344     0.150
    41.330   466.945     0.150
    41.362   466.984     0.150
    41.412   468.684     0.150
    41.443   468.434     0.150
    41.467   467.455     0.150
    41.475   468.334     0.150
    41.485   469.525     0.150
    41.494   468.424     0.150
    41.513   468.184     0.150
    41.504   468.535     0.150
    41.525   468.045     0.150
    41.525   467.145     0.150
    41.525   468.545     0.150
    41.525   468.270     0.150
    41.533   469.229     0.150
    41.547   468.305     0.150
    41.562   468.535     0.150
    41.563   468.424     0.150
    41.563   468.814     0.150
    41.563   468.299     0.150
    41.587   469.094     0.150
    41.587   469.484     0.150
    41.677   470.285     0.150
    41.698   469.924     0.150
    41.698   470.055     0.150
    41.737   470.744     0.150
    41.839   469.994     0.150
    41.812   471.035     0.150
    41.916   470.404     0.150
    41.956   471.904     0.150
    41.961   471.445     0.150
    41.991   473.285     0.150
    41.991   472.312     0.150
    42.045   475.205     0.150
    42.151   473.834     0.150
    42.183   474.014     0.150
    42.214   474.275     0.150
    42.242   474.105     0.150
    42.278   476.145     0.150
    42.260   475.494     0.150
    42.260   474.287     0.150
    42.284   474.584     0.150
    42.335   475.844     0.150
    42.336   474.824     0.150
    42.348   475.254     0.150
    42.348   475.477     0.150
    42.348   475.145     0.150
    42.348   475.664     0.150
    42.352   474.584     0.150
    42.367   476.535     0.150
    42.367   475.883     0.150
    42.368   475.664     0.150
    42.434   476.500     0.150
    42.434   475.244     0.150
    42.434   475.805     0.150
    42.389   475.584     0.150
    42.425   475.975     0.150
    42.449   476.334     0.150
    42.513   476.514     0.150
    42.533   477.295     0.150
    42.533   588.545     0.150
    42.533   476.445     0.150
    42.533   478.320     0.150
    42.533   477.844     0.150
    42.574   476.275     0.150
    42.537   476.574     0.150
    42.549   476.934     0.150
    42.567   478.264     0.150
    42.578   477.225     0.150
    42.600   477.254     0.150
    42.616   477.924     0.150
    42.729   478.535     0.150
    42.784   478.934     0.150
    42.872   479.535     0.150
    42.922   480.064     0.150
    42.841   479.945     0.150
    42.841   590.145     0.150
    42.841   864.145     0.150
    42.885   479.645     0.150
    42.928   480.834     0.150
    42.968   481.545     0.150
    42.968   481.025     0.150
    42.968   480.809     0.150
    43.061   480.074     0.150
    43.082   481.465     0.150
    43.082   481.314     0.150
    43.049   481.945     0.150
    43.049   578.805     0.150
    43.051   481.234     0.150
    43.095   482.074     0.150
    43.273   483.094     0.150
    43.353   482.785     0.150
    43.476   483.355     0.150
    43.486   485.645     0.150
    43.489   485.824     0.150
    43.554   485.945     0.150
    43.600   485.764     0.150
    43.846   488.375     0.150
    43.879   488.334     0.150
    43.970   487.844     0.150
    43.970   878.945     0.150
    43.930   488.484     0.150
    43.963   489.205     0.150
    44.051   488.924     0.150
    44.203   490.844     0.150
    44.288   491.314     0.150
    44.336   490.920     0.150
    44.336   593.969     0.150
    44.346   492.596     0.150
    44.346   490.824     0.150
    44.346   492.045     0.150
    44.375   491.494     0.150
    44.375   491.355     0.150
    44.375   594.705     0.150
    44.424   492.324     0.150
    44.426   492.275     0.150
    44.503   493.344     0.150
    44.632   493.375     0.150
    44.892   494.494     0.150
    44.964   495.535     0.150
    45.170   498.465     0.150
    45.484   499.994     0.150
    45.484   499.285     0.150
    45.616   501.684     0.150
    45.616   501.814     0.150
    45.616   501.504     0.150
    45.616   500.244     0.150
    45.616     3.359     0.150
    45.992   503.494     0.150
    45.990   503.414     0.150
    46.315   506.924     0.150
    46.348   507.385     0.150
    46.695   509.795     0.150
    46.851   508.744     0.150
    46.975   510.471     0.150
    46.975   510.225     0.150
    47.036   511.781     0.150
    47.036   511.094     0.150
    46.991   513.084     0.150
    47.083   512.986     0.150
    47.102   513.244     0.150
    47.148   512.994     0.150
    47.148   514.375     0.150
    47.288   515.145     0.150
    47.288   930.445     0.150
    47.403   515.074     0.150
    47.437   515.414     0.150
    47.522   516.215     0.150
    47.705   518.775     0.150
    47.705   517.619     0.150
    47.705   518.045     0.150
    47.731   517.814     0.150
    47.797   518.754     0.150
    47.809   518.025     0.150
    47.887   519.324     0.150
    48.056   520.045     0.150
    48.056   942.844     0.150
    48.126   520.885     0.150
    48.242   521.564     0.150
    48.236   521.805     0.150
    48.274   522.305     0.150
    48.435   523.574     0.150
    48.457   523.404     0.150
    48.460   523.469     0.150
    48.471   524.154     0.150
    48.487   524.035     0.150
    48.487   524.137     0.150
    48.487   523.775     0.150
    48.495   523.455     0.150
    48.617   524.574     0.150
    48.642   524.754     0.150
    48.656   525.494     0.150
    48.656   524.844     0.150
    48.861   527.273     0.150
    48.861   527.125     0.150
    48.861   527.445     0.150
    48.905   526.734     0.150
    48.980   527.445     0.150
    49.085   528.684     0.150
    49.158   528.834     0.150
    49.203   529.545     0.150
    49.299   530.645     0.150
    49.299   530.355     0.150
    49.262   529.564     0.150
    49.267   529.994     0.150
    49.384   530.525     0.150
    49.747   533.254     0.150
    49.747   532.645     0.150
    49.747   533.145     0.150
    49.747   613.445     0.150
    49.747   648.045     0.150
    49.747   960.744     0.150
    49.747   978.645     0.150
    49.747  1121.645     0.150
    49.747  1175.145     0.150
    49.747   532.975     0.150
    49.747     2.660     0.150
    49.740   533.025     0.150
    50.052   536.445     0.150
    50.160   536.164     0.150
    50.165   536.615     0.150
    50.264   537.635     0.150
    50.264   537.365     0.150
    50.264   538.174     0.150
    50.242   537.305     0.150
    50.242   537.084     0.150
    50.278   537.240     0.150
    50.278   537.035     0.150
    50.278   614.855     0.150
    50.376   538.295     0.150
    50.406   538.365     0.150
    50.523   539.314     0.150
    50.523   539.045     0.150
    50.916   541.135     0.150
    50.916   540.654     0.150
    50.879   542.055     0.150
    50.879   541.545     0.150
    50.967   543.164     0.150
    50.967   542.965     0.150
    51.470   545.855     0.150
    51.470   545.645     0.150
    51.470   546.174     0.150
    51.567   547.645     0.150
    51.638   547.645     0.150
    51.668   547.844     0.150
    51.677   547.754     0.150
    51.678   547.820     0.150
    51.678   620.020     0.150
    51.705   547.645     0.150
    51.698   548.645     0.150
    51.969   551.121     0.150
    51.982   551.486     0.150
    51.982   549.244     0.150
    52.020   551.430     0.150
    52.020   549.545     0.150
    52.000   550.240     0.150
    52.000   550.348     0.150
    52.000     3.629     0.150
    52.148   551.045     0.150
    52.279   554.113     0.150
    52.278   552.744     0.150
    52.377   554.273     0.150
    52.371   552.658     0.150
    52.371   552.445     0.150
    52.361   553.145     0.150
    52.430   553.830     0.150
    52.444   552.945     0.150
    52.447   553.045     0.150
    52.430   553.545     0.150
    52.580   554.494     0.150
    52.910   556.125     0.150
    53.064   558.455     0.150
    53.059   558.475     0.150
    53.226   560.342     0.150
    53.470   560.744     0.150
    53.473   560.555     0.150
    53.473   560.445     0.150
    53.473   560.594     0.150
    53.473   560.305     0.150
    53.485   560.844     0.150
    54.094   566.375     0.150
    54.094   565.955     0.150
    54.277   566.844     0.150
    54.289   569.123     0.150
    54.414   568.469     0.150
    54.411   568.244     0.150
    54.411   568.045     0.150
    54.495   569.312     0.150
    54.509   568.635     0.150
    54.509   568.395     0.150
    54.606   569.234     0.150
    54.606   568.965     0.150
    54.606   569.709     0.150
    54.620   570.014     0.150
    54.761   570.945     0.150
    54.871   571.535     0.150
    55.027   572.564     0.150
    55.095   575.113     0.150
    55.169   572.445     0.150
    55.169   573.064     0.150
    55.181   573.355     0.150
    55.181   573.598     0.150
    55.410   575.145     0.150
    55.580   576.494     0.150
    55.728   577.434     0.150
    55.752   578.365     0.150
    55.752   578.115     0.150
    55.914   578.834     0.150
    56.105   580.355     0.150
    56.105   580.518     0.150
    56.242   582.172     0.150
    56.259   583.113     0.150
    56.416   582.355     0.150
    56.416   582.484     0.150
    56.416   582.645     0.150
    56.427   584.445     0.150
    56.427   584.730     0.150
    56.427   581.639     0.150
    56.427   582.744     0.150
    56.508   583.838     0.150
    56.677   584.068     0.150
    56.677   583.695     0.150
    56.829   586.740     0.150
    57.218   588.115     0.150
    57.218   588.990     0.150
    58.188   593.451     0.150
    58.188   593.814     0.150
    58.305   596.389     0.150
    58.305   595.545     0.150
    58.547   598.244     0.150
    59.096   600.645     0.150
    59.096   601.492     0.150
    59.096   601.359     0.150
    59.096     3.820     0.150
    59.859   606.344     0.150
    59.859   606.643     0.150
    59.859   606.094     0.150
    59.859     3.199     0.150
    59.989  1104.045     0.150
    59.987   608.562     0.150
    59.987   607.625     0.150
    59.987   608.285     0.150
    60.057   607.730     0.150
    60.057   607.445     0.150
    60.294   608.945     0.150
    60.294   610.023     0.150
    60.294   609.445     0.150
    60.325   610.445     0.150
    60.325   610.904     0.150
    60.325   610.725     0.150
    60.479   610.094     0.150
    60.479     4.639     0.150
    60.481   609.945     0.150
    60.481   610.445     0.150
    60.516   610.545     0.150
    60.923   613.674     0.150
    61.910   620.145     0.150
    62.780   626.365     0.150
    62.780   626.895     0.150
    62.727   626.355     0.150
    62.901   627.254     0.150
    63.465   631.174     0.150
    63.465   631.064     0.150
    63.956   633.885     0.150
    63.956   633.605     0.150
    64.094   634.934     0.150
    64.094   634.424     0.150
    64.094   634.045     0.150
    64.450   636.615     0.150
    64.544   637.855     0.150
    64.600   638.314     0.150
    64.963   640.875     0.150
    65.562   644.725     0.150
    65.562   644.525     0.150
    66.351   649.955     0.150
    66.334   649.445     0.150
    66.334   647.045     0.150
    66.334   647.945     0.150
    66.334   648.404     0.150
    66.347   649.445     0.150
    66.649   651.355     0.150
    66.649   651.115     0.150
    66.649     3.500     0.150
    66.834   651.635     0.150
    67.142   654.070     0.150
    67.142   653.895     0.150
    67.142   653.664     0.150
    67.142   653.555     0.150
    67.912   659.664     0.150
    68.139   661.209     0.150
    68.139   660.314     0.150
    68.139   661.395     0.150
    68.498   663.654     0.150
    68.609   663.695     0.150
    68.609   663.264     0.150
    68.609   664.365     0.150
    69.520   668.295     0.150
    69.520   668.844     0.150
    69.520   668.645     0.150
    70.046   671.645     0.150
    70.127   672.344     0.150
    70.127   672.445     0.150
    70.331   673.814     0.150
    70.331   674.174     0.150
    71.052   679.545     0.150
    71.052   679.695     0.150
    71.052   680.004     0.150
    71.828   682.664     0.150
    71.828   682.545     0.150
    71.828   682.295     0.150
    72.425   687.176     0.150
    72.425   686.824     0.150
    72.917   689.904     0.150
    73.150   691.654     0.150
    73.642   694.357     0.150
    74.389   699.775     0.150
    74.389   699.465     0.150
    75.551   705.725     0.150
    75.624   705.748     0.150
    75.624   705.334     0.150
    75.624   705.045     0.150
    76.493   711.324     0.150
    76.703   712.234     0.150
    76.703   712.406     0.150
    77.053   714.264     0.150
    77.417   716.504     0.150
    78.096   720.236     0.150
    78.096   720.045     0.150
    78.203   720.635     0.150
    78.360   720.195     0.150
    78.360   896.844     0.150
    78.934   724.545     0.150
    79.582   728.115     0.150
    80.085   730.141     0.150
    80.091   730.734     0.150
    80.177   731.660     0.150
    80.606   733.396     0.150
    80.606   732.744     0.150
    80.606   733.744     0.150
    80.789   734.164     0.150
    80.789   733.984     0.150
    80.789   733.645     0.150
    80.787   733.791     0.150
    80.834   735.145     0.150
    80.974   735.645     0.150
    81.224   735.277     0.150
    81.224   735.844     0.150
    81.715   738.691     0.150
    82.226   741.826     0.150
    82.947   743.711     0.150
    83.150   746.719     0.150
    83.313   746.791     0.150
    83.457   748.695     0.150
    83.488   750.102     0.150
    83.544   749.375     0.150
    84.036   751.025     0.150
    84.886   754.482     0.150
    84.942   753.844     0.150
    84.942   752.750     0.150
    84.942   754.439     0.150
    85.301   757.625     0.150
    85.866   758.459     0.150
    86.066   763.016     0.150
    86.288   761.398     0.150
    86.489   763.414     0.150
    86.582   762.865     0.150
    86.726   763.613     0.150
    87.183   766.844     0.150
    87.527   767.912     0.150
    87.586   768.316     0.150
    87.586   768.145     0.150
    87.586   768.119     0.150
    87.586   972.695     0.150
    87.586   767.805     0.150
    87.586   766.844     0.150
    87.746   768.912     0.150
    88.097   771.145     0.150
    89.563   777.695     0.150
    89.563   777.045     0.150
    89.563   777.494     0.150
    89.563   988.295     0.150
    89.563   777.275     0.150
    89.596   777.244     0.150
    89.906   779.914     0.150
    89.906   779.645     0.150
    89.906   780.344     0.150
    90.080   780.031     0.150
    90.080   779.445     0.150
    91.894   788.641     0.150
    93.207   793.820     0.150
    93.207   794.945     0.150
    93.360   794.943     0.150
    93.754   796.420     0.150
    95.041   804.234     0.150
    95.060   803.406     0.150
    99.903   823.770     0.150
   102.556  1097.395     0.150
   102.556  1794.545     0.150
   107.292   858.664     0.150
   107.284  1781.195     0.150
   111.020  1111.344     0.150
   114.047  1118.646     0.150
   114.047  1760.805     0.150
   114.913  1120.670     0.150
   114.913  1179.244     0.150
   115.192  1119.980     0.150
   115.192  1756.406     0.150
   115.192  1120.256     0.150
   115.192  1119.312     0.150
   116.024  1121.857     0.150
   116.024  1755.480     0.150
   116.131  1122.506     0.150
   116.131  1752.275     0.150
   116.405  1123.695     0.150
   121.125  1133.545     0.150
   121.844  1131.045     0.150
   122.312  1134.645     0.150
   123.067  1136.570     0.150
   123.450  1137.645     0.150
   123.494  1135.744     0.150
   123.754  1138.689     0.150
   124.265  1136.844     0.150
   124.378  1136.844     0.150
   124.465  1137.088     0.150
   125.836  1141.498     0.150
   125.866  1138.764     0.150
   125.884  1140.855     0.150
   126.463  1139.844     0.150
   126.630  1141.998     0.150
   126.724  1142.990     0.150
   127.264  1144.344     0.150
   127.344  1145.795     0.150
   127.661  1143.994     0.150
   128.716  1145.264     0.150
   128.721  1146.588     0.150
   129.051  1147.537     0.150
   131.838  1154.270     0.150
   131.838  1153.344     0.150
   134.173  1160.064     0.150
   138.478  1167.820     0.150
   139.631  1169.615     0.150
   140.228  1171.494     0.150
   142.259  1172.695     0.150
   142.259  1172.145     0.150
   147.192  1183.225     0.150
     1.427    26.428     0.150
     1.616    28.887     0.150
     1.800    32.428     0.150
     1.800    32.947     0.150
     2.009    35.246     0.150
     2.306    39.227     0.150
     2.257    39.326     0.150
     2.306    39.027     0.150
     2.494    42.227     0.150
     2.554    42.527     0.150
     2.642    43.826     0.150
     2.800    46.627     0.150
     3.223    52.227     0.150
     3.489    55.727     0.150
     3.489    55.576     0.150
     3.826    61.127     0.150
     3.903    61.996     0.150
     4.050    62.967     0.150
     4.057    62.928     0.150
     4.398    67.826     0.150
     4.427    68.826     0.150
     4.495    70.852     0.150
     4.495   123.703     0.150
     4.495   146.000     0.150
     4.567    69.727     0.150
     4.588    70.527     0.150
     4.749    73.557     0.150
     5.127    77.527     0.150
     5.615    84.928     0.150
     5.583    84.826     0.150
     5.678    85.826     0.150
     5.922    86.678     0.150
     5.980    89.727     0.150
     6.078    91.428     0.150
     6.173    92.227     0.150
     6.314    91.797     0.150
     6.464    96.557     0.150
     6.882   102.127     0.150
     7.061   104.727     0.150
     7.061   104.967     0.150
     7.189   108.428     0.150
     7.189   107.146     0.150
     7.191   105.957     0.150
     7.351   109.027     0.150
     7.547   111.428     0.150
     7.759   115.297     0.150
     7.986   116.057     0.150
     8.122   119.826     0.150
     8.119   118.727     0.150
     8.681   128.268     0.150
     8.764   128.268     0.150
     8.881   130.877     0.150
     8.970   129.367     0.150
     9.314   134.297     0.150
     9.488   136.826     0.150
     9.765   142.156     0.150
     9.852   143.307     0.150
    10.061   143.588     0.150
    10.707   151.947     0.150
    10.834   153.688     0.150
    11.041   155.938     0.150
    11.147   158.588     0.150
    11.972   169.777     0.150
    12.177   171.518     0.150
    12.714   181.098     0.150
    12.714   180.898     0.150
    12.714   179.857     0.150
    12.714   180.627     0.150
    13.192   187.416     0.150
    13.530   192.326     0.150
    13.503   194.746     0.150
    14.160   199.326     0.150
    14.160   200.428     0.150
    14.406   202.727     0.150
    14.406   203.057     0.150
    14.527   208.197     0.150
    14.693   208.521     0.150
    14.693   208.217     0.150
    14.713   208.377     0.150
    14.713   208.617     0.150
    14.863   211.768     0.150
    15.341   218.107     0.150
    15.578   221.098     0.150
    15.771   225.457     0.150
    15.833   222.166     0.150
    16.009   223.857     0.150
    16.073   225.053     0.150
    16.216   226.826     0.150
    17.209   242.727     0.150
    17.284   241.236     0.150
    17.273   241.090     0.150
    17.273   242.428     0.150
    17.273   243.727     0.150
    17.509   244.967     0.150
    17.509   245.428     0.150
    17.509   247.727     0.150
    18.042   249.666     0.150
    18.042   249.438     0.150
    19.155   264.027     0.150
    19.392   267.277     0.150
    19.396   265.537     0.150
    19.396   267.396     0.150
    19.458   266.508     0.150
    19.458   266.107     0.150
    19.670   269.227     0.150
    19.635   268.428     0.150
    19.635   268.027     0.150
    19.635   268.627     0.150
    19.635   268.236     0.150
    20.094   274.277     0.150
    20.127   276.607     0.150
    20.201   276.008     0.150
    20.201   275.316     0.150
    20.201   276.826     0.150
    20.201   275.518     0.150
    20.377   277.588     0.150
    20.518   277.826     0.150
    20.784   282.486     0.150
    20.819   284.227     0.150
    20.819   282.947     0.150
    20.912   283.688     0.150
    21.059   287.428     0.150
    21.124   283.396     0.150
    21.306   286.527     0.150
    21.255   287.916     0.150
    21.488   288.727     0.150
    21.911   295.627     0.150
    21.963   295.227     0.150
    21.920   294.695     0.150
    21.920   293.916     0.150
    21.920   564.928     0.150
    22.245   297.826     0.150
    22.542   301.627     0.150
    22.697   301.268     0.150
    22.697   533.557     0.150
    22.697   550.857     0.150
    23.018   305.627     0.150
    23.021   307.066     0.150
    23.021   305.727     0.150
    23.021   307.428     0.150
    23.021   307.428     0.150
    23.021   307.066     0.150
    23.268   308.326     0.150
    23.284   308.227     0.150
    23.550   313.467     0.150
    25.225   325.857     0.150
    25.185   325.727     0.150
    25.185   325.803     0.150
    25.185   362.090     0.150
    25.185   325.416     0.150
    25.386   328.879     0.150
    25.386   329.527     0.150
    25.988   334.377     0.150
    26.928   344.326     0.150
    26.982   343.861     0.150
    26.982   342.527     0.150
    26.982   383.627     0.150
    27.769   351.996     0.150
    28.558   356.428     0.150
    28.584   356.727     0.150
    28.601   356.838     0.150
    28.601   357.576     0.150
    28.601   356.826     0.150
    28.601   356.127     0.150
    28.608   357.117     0.150
    28.608   356.826     0.150
    28.608   357.307     0.150
    28.612   356.928     0.150
    28.666   357.428     0.150
    28.702   357.727     0.150
    28.737   358.027     0.150
    29.215   362.326     0.150
    29.345   366.566     0.150
    29.345   365.195     0.150
    29.345   363.576     0.150
    30.241   372.518     0.150
    30.245   372.627     0.150
    30.483   375.227     0.150
    30.855   377.758     0.150
    31.765   386.338     0.150
    32.377   391.297     0.150
    32.377   391.178     0.150
    33.363   399.527     0.150
    33.363   398.727     0.150
    33.432   401.027     0.150
    33.685   400.098     0.150
    33.784   405.518     0.150
    33.817   404.777     0.150
    33.990   405.803     0.150
    33.957   404.357     0.150
    33.957   403.928     0.150
    35.188   414.197     0.150
    35.520   418.133     0.150
    35.520   417.957     0.150
    35.526   416.928     0.150
    35.526     3.799     0.150
    35.533   417.027     0.150
    35.964   421.527     0.150
    35.964   421.848     0.150
    36.266   425.787     0.150
    36.429   424.797     0.150
    36.433   424.727     0.150
    36.473   425.127     0.150
    36.477   425.486     0.150
    36.389   425.414     0.150
    36.623   425.057     0.150
    36.623   426.326     0.150
    36.623   426.547     0.150
    36.471   427.867     0.150
    36.638   426.227     0.150
    36.656   426.428     0.150
    36.516   426.082     0.150
    36.682   428.787     0.150
    36.702   428.617     0.150
    36.702   427.107     0.150
    36.702   428.287     0.150
    36.709   428.697     0.150
    36.873   429.496     0.150
    37.013   430.883     0.150
    37.342   433.396     0.150
    37.347   433.830     0.150
    37.599   436.018     0.150
    37.599   435.246     0.150
    37.599   434.826     0.150
    37.599   436.727     0.150
    37.583   435.947     0.150
    37.583   435.441     0.150
    37.947   437.826     0.150
    37.964   438.037     0.150
    37.968   439.236     0.150
    37.970   438.898     0.150
    37.994   439.537     0.150
    37.999   439.361     0.150
    38.016   440.227     0.150
    38.016   439.469     0.150
    38.181   440.926     0.150
    38.260   441.977     0.150
    38.590   443.826     0.150
    38.637   444.826     0.150
    38.643   444.230     0.150
    38.748   445.146     0.150
    38.799   446.777     0.150
    38.863   446.768     0.150
    38.874   446.447     0.150
    39.143   447.826     0.150
    39.143   447.977     0.150
    38.985   448.576     0.150
    38.985   448.326     0.150
    39.278   449.117     0.150
    39.349   450.307     0.150
    39.390   450.953     0.150
    39.492   452.338     0.150
    39.640   452.604     0.150
    39.772   454.117     0.150
    39.969   455.139     0.150
    40.135   455.867     0.150
    40.046   455.428     0.150
    40.046   456.037     0.150
    40.089   456.627     0.150
    40.118   456.266     0.150
    40.289   457.527     0.150
    40.289   458.303     0.150
    40.544   459.887     0.150
    40.991   464.678     0.150
    40.991   463.316     0.150
    41.152   464.486     0.150
    41.152   463.996     0.150
    41.174   464.758     0.150
    41.174   464.326     0.150
    41.315   466.727     0.150
    41.357   466.428     0.150
    41.511   467.666     0.150
    41.521   467.916     0.150
    41.552   467.928     0.150
    41.552   468.178     0.150
    41.856   469.557     0.150
    42.355   474.627     0.150
    42.520   477.094     0.150
    42.520   476.867     0.150
    42.520   475.928     0.150
    42.537   476.098     0.150
    42.729   478.246     0.150
    42.872   478.768     0.150
    43.021   480.377     0.150
    43.056   481.018     0.150
    43.274   482.396     0.150
    44.378   491.117     0.150
    44.378   490.887     0.150
    44.549   493.527     0.150
    45.556   500.027     0.150
    46.315   506.617     0.150
    46.693   509.777     0.150
    47.752   518.506     0.150
    48.238   520.627     0.150
    48.457   522.066     0.150
    48.478   524.082     0.150
    48.907   527.338     0.150
    49.261   529.627     0.150
    49.809   532.928     0.150
    49.809   532.826     0.150
    50.235   538.258     0.150
    50.235   537.277     0.150
    50.339   537.146     0.150
    51.634   547.027     0.150
    51.664   547.326     0.150
    51.673   546.807     0.150
    51.675   547.326     0.150
    51.997   549.928     0.150
    52.205   550.826     0.150
    52.479   553.258     0.150
    52.479   553.137     0.150
    52.493   552.928     0.150
    52.497   553.027     0.150
    52.479   553.477     0.150
    52.575   554.107     0.150
    53.525   560.627     0.150
    53.528   560.111     0.150
    54.093   566.027     0.150
    54.093   565.066     0.150
    54.454   567.887     0.150
    54.497   568.246     0.150
    54.497   568.477     0.150
    54.602   568.857     0.150
    56.406   581.637     0.150
    58.127   592.508     0.150
    59.034   600.428     0.150
    59.034   600.697     0.150
    60.050   606.326     0.150
    60.365   610.406     0.150
    60.532   610.406     0.150
    60.532   609.939     0.150
    66.395   648.178     0.150
    68.080   660.477     0.150
    68.547   662.938     0.150
    70.140   672.527     0.150
    71.766   682.045     0.150
    74.448   698.438     0.150
    75.641   705.727     0.150
    75.641   705.227     0.150
    76.039   707.916     0.150
    76.515   710.967     0.150
    76.552   711.428     0.150
    76.760   711.928     0.150
    77.477   716.146     0.150
    77.531   716.678     0.150
    78.188   720.227     0.150
    78.419   720.977     0.150
    78.419   721.508     0.150
    78.640   722.707     0.150
    79.641   727.826     0.150
    80.085   729.277     0.150
    80.085   729.678     0.150
    80.385   732.188     0.150
    80.844   734.576     0.150
    83.203   746.512     0.150
    83.203   747.326     0.150
    83.518   748.508     0.150
    87.590   767.727     0.150
    87.590   767.557     0.150
    89.563   777.527     0.150
    89.563   777.377     0.150
    89.563   777.018     0.150
    89.596   777.727     0.150
   124.412  1137.871     0.150
   127.623  1143.701     0.150
   142.209  1172.119     0.150
     1.407    26.969     0.150
     1.620    29.168     0.150
     1.777    33.268     0.150
     2.234    39.469     0.150
     2.287    39.268     0.150
     2.311    39.768     0.150
     2.533    43.768     0.150
     2.503    42.668     0.150
     2.642    44.268     0.150
     2.964    49.469     0.150
     3.201    52.268     0.150
     3.498    56.668     0.150
     3.498    56.457     0.150
     3.883    61.969     0.150
     3.883    62.719     0.150
     3.959    63.668     0.150
     4.044    64.447     0.150
     4.051    63.668     0.150
     4.404    69.469     0.150
     4.390    68.469     0.150
     4.471    70.773     0.150
     4.471   146.867     0.150
     4.560    70.668     0.150
     5.130    78.469     0.150
     5.561    84.568     0.150
     5.683    86.568     0.150
     5.857    88.768     0.150
     5.933    88.787     0.150
     5.990    90.969     0.150
     6.009    94.389     0.150
     6.009    92.158     0.150
     6.079    91.668     0.150
     6.115    92.738     0.150
     6.187    93.498     0.150
     6.322    92.988     0.150
     6.460    97.338     0.150
     6.553    98.969     0.150
     6.801   101.969     0.150
     7.059   105.508     0.150
     7.181   106.100     0.150
     7.181   186.771     0.150
     7.181   105.719     0.150
     7.175   106.768     0.150
     7.211   107.678     0.150
     7.337   109.768     0.150
     7.524   112.469     0.150
     7.531   111.768     0.150
     7.752   116.148     0.150
     7.932   116.969     0.150
     7.975   117.389     0.150
     8.105   119.969     0.150
     8.115   120.168     0.150
     8.416   123.367     0.150
     8.480   125.568     0.150
     8.478   125.268     0.150
     8.577   126.668     0.150
     8.632   126.969     0.150
     8.641   127.469     0.150
     8.640   126.768     0.150
     8.752   129.059     0.150
     8.714   126.668     0.150
     8.693   128.367     0.150
     8.693   128.918     0.150
     8.866   130.479     0.150
     8.964   131.617     0.150
     8.964   130.629     0.150
     8.981   131.867     0.150
     9.067   133.117     0.150
     9.075   132.697     0.150
     9.270   134.969     0.150
     9.311   135.607     0.150
     9.339   137.168     0.150
     9.342   137.068     0.150
     9.500   139.068     0.150
     9.499   139.648     0.150
     9.531   140.367     0.150
     9.649   140.367     0.150
     9.753   142.719     0.150
     9.792   141.537     0.150
     9.792   253.277     0.150
     9.857   143.617     0.150
     9.864   143.672     0.150
     9.864   143.875     0.150
     9.864   255.330     0.150
     9.907   144.830     0.150
     9.907   144.176     0.150
     9.907   255.852     0.150
     9.971   148.037     0.150
    10.053   144.607     0.150
    10.104   147.588     0.150
    10.401   151.838     0.150
    10.454   152.117     0.150
    10.463   151.066     0.150
    10.463   152.229     0.150
    10.529   154.791     0.150
    10.699   153.398     0.150
    10.689   156.928     0.150
    10.788   157.367     0.150
    10.823   155.166     0.150
    10.823   271.648     0.150
    10.823   273.268     0.150
    10.823   155.088     0.150
    10.817   155.973     0.150
    10.817   155.748     0.150
    10.817   156.814     0.150
    10.817   279.887     0.150
    10.817   156.438     0.150
    10.817   157.197     0.150
    10.846   158.379     0.150
    10.908   158.367     0.150
    10.908   158.867     0.150
    10.952   157.910     0.150
    10.952   158.768     0.150
    11.000   159.498     0.150
    11.035   156.889     0.150
    11.081   158.998     0.150
    11.125   158.367     0.150
    11.125   158.707     0.150
    11.109   160.676     0.150
    11.109   160.953     0.150
    11.210   162.707     0.150
    11.262   163.768     0.150
    11.262   289.469     0.150
    11.243   162.035     0.150
    11.243   162.750     0.150
    11.431   163.443     0.150
    11.460   165.639     0.150
    11.460   166.436     0.150
    11.530   166.451     0.150
    11.665   167.475     0.150
    11.665   168.725     0.150
    11.707   169.568     0.150
    11.693   167.072     0.150
    11.794   169.092     0.150
    11.794   170.398     0.150
    11.775   170.588     0.150
    11.871   169.367     0.150
    11.871   301.668     0.150
    11.896   171.867     0.150
    11.992   172.770     0.150
    12.121   175.768     0.150
    12.137   174.867     0.150
    12.172   171.457     0.150
    12.171   175.551     0.150
    12.232   175.637     0.150
    12.246   175.352     0.150
    12.292   174.938     0.150
    12.410   178.791     0.150
    12.516   180.248     0.150
    12.634   182.309     0.150
    12.610   179.637     0.150
    12.643   180.646     0.150
    12.707   180.832     0.150
    12.707   322.266     0.150
    12.707   180.258     0.150
    12.707   321.086     0.150
    12.707   181.088     0.150
    12.707   181.568     0.150
    12.707   179.867     0.150
    12.707   182.287     0.150
    12.736   183.568     0.150
    12.834   184.932     0.150
    12.886   185.969     0.150
    12.862   183.887     0.150
    12.994   184.059     0.150
    13.005   187.211     0.150
    13.005   187.678     0.150
    13.022   187.746     0.150
    13.058   186.068     0.150
    13.058   332.469     0.150
    13.070   185.479     0.150
    13.080   185.328     0.150
    13.183   190.969     0.150
    13.190   187.078     0.150
    13.201   190.268     0.150
    13.201   336.969     0.150
    13.192   189.375     0.150
    13.194   189.658     0.150
    13.188   189.301     0.150
    13.220   189.328     0.150
    13.233   190.381     0.150
    13.300   190.668     0.150
    13.300   337.969     0.150
    13.300   193.178     0.150
    13.423   192.945     0.150
    13.487   195.418     0.150
    13.525   191.469     0.150
    13.503   192.260     0.150
    13.538   192.357     0.150
    13.590   195.867     0.150
    13.596   191.719     0.150
    13.590   194.230     0.150
    13.691   196.668     0.150
    13.691   348.268     0.150
    13.678   196.508     0.150
    13.728   194.971     0.150
    13.741   196.223     0.150
    13.853   199.168     0.150
    13.853   353.168     0.150
    13.933   197.768     0.150
    13.933   352.168     0.150
    13.984   198.129     0.150
    14.010   200.189     0.150
    14.156   199.268     0.150
    14.156   200.768     0.150
    14.186   202.428     0.150
    14.170   201.998     0.150
    14.333   203.729     0.150
    14.343   205.107     0.150
    14.358   205.188     0.150
    14.361   204.908     0.150
    14.403   201.707     0.150
    14.384   203.299     0.150
    14.464   205.299     0.150
    14.504   206.178     0.150
    14.504   369.549     0.150
    14.569   204.318     0.150
    14.569   367.559     0.150
    14.673   208.939     0.150
    14.673   210.562     0.150
    14.673   209.059     0.150
    14.673   209.668     0.150
    14.673   208.668     0.150
    14.673   211.822     0.150
    14.690   207.418     0.150
    14.690   206.445     0.150
    14.690   366.867     0.150
    14.842   210.639     0.150
    14.892   215.389     0.150
    15.071   218.098     0.150
    15.124   213.768     0.150
    15.127   216.217     0.150
    15.187   214.438     0.150
    15.320   216.508     0.150
    15.387   215.229     0.150
    15.387   387.287     0.150
    15.464   220.367     0.150
    15.561   221.537     0.150
    15.580   220.787     0.150
    15.696   218.270     0.150
    15.696   389.598     0.150
    15.696   387.969     0.150
    15.702   223.037     0.150
    15.728   221.348     0.150
    15.751   224.238     0.150
    15.757   221.719     0.150
    15.757   397.838     0.150
    15.809   223.479     0.150
    15.809   222.488     0.150
    15.828   220.857     0.150
    15.828   398.918     0.150
    16.026   231.168     0.150
    16.050   224.115     0.150
    16.050   393.617     0.150
    16.050   394.152     0.150
    16.402   229.617     0.150
    16.402   413.238     0.150
    16.211   224.670     0.150
    16.211   225.729     0.150
    16.211   230.625     0.150
    16.423   233.408     0.150
    16.360   230.398     0.150
    16.377   229.268     0.150
    16.392   231.107     0.150
    16.538   234.188     0.150
    16.693   234.268     0.150
    16.711   236.078     0.150
    16.752   238.875     0.150
    17.070   242.418     0.150
    17.251   240.789     0.150
    17.251   241.469     0.150
    17.251   240.268     0.150
    17.268   241.828     0.150
    17.282   240.229     0.150
    17.282   434.059     0.150
    17.359   242.109     0.150
    17.441   245.748     0.150
    17.441   243.520     0.150
    17.487   243.436     0.150
    17.487   243.549     0.150
    17.487   243.697     0.150
    17.487   244.168     0.150
    17.487   243.168     0.150
    17.487   436.867     0.150
    17.487   244.797     0.150
    17.505   246.268     0.150
    17.706   247.588     0.150
    17.771   246.367     0.150
    17.771   448.068     0.150
    17.805   250.438     0.150
    17.931   249.551     0.150
    17.960   249.898     0.150
    18.044   250.363     0.150
    18.044   250.107     0.150
    18.044   250.549     0.150
    18.044   249.812     0.150
    18.044   250.229     0.150
    18.126   252.857     0.150
    18.172   251.447     0.150
    18.131   252.303     0.150
    18.368   255.990     0.150
    18.831   262.287     0.150
    18.822   260.086     0.150
    19.054   265.168     0.150
    19.054   480.168     0.150
    19.170   264.168     0.150
    19.325   268.068     0.150
    19.325   481.969     0.150
    19.323   269.469     0.150
    19.323   269.219     0.150
    19.323   268.287     0.150
    19.323   269.768     0.150
    19.374   267.727     0.150
    19.378   265.879     0.150
    19.451   267.312     0.150
    19.451   266.719     0.150
    19.451   266.852     0.150
    19.534   270.857     0.150
    19.595   271.107     0.150
    19.627   271.193     0.150
    19.627   269.367     0.150
    19.627   268.969     0.150
    19.627   269.447     0.150
    19.627   268.758     0.150
    19.627   268.969     0.150
    19.671   490.268     0.150
    19.685   270.268     0.150
    19.799   269.768     0.150
    20.081   275.078     0.150
    20.081   275.773     0.150
    20.081   274.969     0.150
    20.111   276.287     0.150
    20.117   277.207     0.150
    20.188   275.889     0.150
    20.188   275.107     0.150
    20.188   276.943     0.150
    20.188   276.367     0.150
    20.188   275.652     0.150
    20.188   277.889     0.150
    20.210   276.207     0.150
    20.361   278.758     0.150
    20.476   280.570     0.150
    20.467   279.457     0.150
    20.524   279.518     0.150
    20.533   278.568     0.150
    20.767   283.648     0.150
    20.802   284.658     0.150
    20.802   283.088     0.150
    20.893   284.809     0.150
    21.044   287.338     0.150
    21.075   284.068     0.150
    21.139   284.754     0.150
    21.139   285.148     0.150
    21.238   288.418     0.150
    21.286   289.268     0.150
    21.286   525.867     0.150
    21.322   286.568     0.150
    21.481   289.367     0.150
    21.584   292.309     0.150
    21.809   294.898     0.150
    21.897   295.287     0.150
    21.897   295.170     0.150
    21.897   533.539     0.150
    21.897   294.568     0.150
    21.897   294.367     0.150
    21.897   295.068     0.150
    21.897   314.469     0.150
    21.897   537.568     0.150
    21.897   562.969     0.150
    21.897   295.389     0.150
    21.926   294.469     0.150
    21.960   534.168     0.150
    21.960   295.559     0.150
    22.016   295.469     0.150
    22.022   297.328     0.150
    22.022   296.678     0.150
    22.064   296.068     0.150
    22.064   538.969     0.150
    22.200   299.139     0.150
    22.223   298.367     0.150
    22.281   299.988     0.150
    22.281   299.428     0.150
    22.405   300.498     0.150
    22.464   302.268     0.150
    22.557   299.867     0.150
    22.720   301.357     0.150
    22.720   533.488     0.150
    22.720   559.098     0.150
    22.986   306.357     0.150
    23.000   305.867     0.150
    23.003   306.135     0.150
    23.003   306.697     0.150
    23.003   306.441     0.150
    23.003   306.574     0.150
    23.003   535.262     0.150
    23.003   560.168     0.150
    23.070   307.139     0.150
    23.250   310.928     0.150
    23.275   310.109     0.150
    23.275   310.309     0.150
    23.275   308.469     0.150
    23.283   309.367     0.150
    23.326   309.367     0.150
    23.397   310.648     0.150
    23.397   310.527     0.150
    23.397   309.867     0.150
    23.532   312.328     0.150
    23.533   312.447     0.150
    23.533   569.969     0.150
    23.573   312.268     0.150
    23.580   312.268     0.150
    23.662   313.211     0.150
    23.662   313.328     0.150
    23.662   312.844     0.150
    23.662   313.568     0.150
    23.753   315.260     0.150
    24.025   316.738     0.150
    24.058   317.068     0.150
    24.203   317.578     0.150
    24.290   318.867     0.150
    24.290   576.668     0.150
    24.497   320.908     0.150
    24.529   321.207     0.150
    24.604   321.371     0.150
    24.674   323.088     0.150
    25.172   327.598     0.150
    25.172   326.537     0.150
    25.172   326.482     0.150
    25.208   328.430     0.150
    25.237   327.049     0.150
    25.237   327.908     0.150
    25.237   361.668     0.150
    25.237   593.568     0.150
    25.237   597.568     0.150
    25.237   989.867     0.150
    25.362   329.168     0.150
    25.416   329.469     0.150
    25.416   329.336     0.150
    25.416   329.068     0.150
    25.461   328.838     0.150
    25.501   329.998     0.150
    25.972   334.129     0.150
    26.143   336.100     0.150
    26.265   335.629     0.150
    26.578   340.469     0.150
    26.572   340.068     0.150
    26.603   340.850     0.150
    26.711   339.729     0.150
    26.843   342.668     0.150
    26.843   618.168     0.150
    26.860   343.316     0.150
    26.903   343.969     0.150
    26.903   621.768     0.150
    26.937   342.268     0.150
    26.958   343.686     0.150
    26.958   343.469     0.150
    26.958   622.568     0.150
    26.958   343.863     0.150
    26.958   342.867     0.150
    26.958   343.363     0.150
    26.997   343.578     0.150
    27.154   345.924     0.150
    27.182   346.031     0.150
    27.174   346.438     0.150
    27.213   346.387     0.150
    27.273   347.297     0.150
    27.278   346.668     0.150
    27.279   346.770     0.150
    27.378   348.105     0.150
    27.429   348.082     0.150
    27.429   347.818     0.150
    27.429   346.969     0.150
    27.429   347.969     0.150
    27.455   346.668     0.150
    27.455   346.469     0.150
    27.459   348.367     0.150
    27.455   346.867     0.150
    27.477   349.268     0.150
    27.477   349.068     0.150
    27.517   347.268     0.150
    27.517   347.688     0.150
    27.642   349.824     0.150
    27.642   349.598     0.150
    27.748   350.508     0.150
    27.811   351.734     0.150
    27.914   352.604     0.150
    27.911   351.133     0.150
    27.939   352.906     0.150
    27.985   353.068     0.150
    27.985   353.268     0.150
    28.059   352.330     0.150
    28.075   354.406     0.150
    28.083   356.068     0.150
    28.084   353.168     0.150
    28.148   355.131     0.150
    28.173   353.217     0.150
    28.190   355.400     0.150
    28.162   353.957     0.150
    28.214   355.668     0.150
    28.210   354.105     0.150
    28.223   354.777     0.150
    28.286   355.367     0.150
    28.265   354.658     0.150
    28.338   355.107     0.150
    28.349   356.605     0.150
    28.507   359.029     0.150
    28.535   356.867     0.150
    28.547   358.799     0.150
    28.561   357.168     0.150
    28.559   359.316     0.150
    28.518   358.068     0.150
    28.578   357.617     0.150
    28.578   357.498     0.150
    28.578   357.268     0.150
    28.578   357.768     0.150
    28.585   357.938     0.150
    28.585   357.578     0.150
    28.585   357.268     0.150
    28.589   357.367     0.150
    28.589   358.799     0.150
    28.602   360.045     0.150
    28.635   357.768     0.150
    28.636   359.471     0.150
    28.643   357.867     0.150
    28.638   358.568     0.150
    28.659   357.969     0.150
    28.671   359.557     0.150
    28.679   358.168     0.150
    28.694   358.174     0.150
    28.707   359.945     0.150
    28.714   358.469     0.150
    28.779   360.211     0.150
    28.773   360.697     0.150
    28.773   359.688     0.150
    28.773   360.957     0.150
    28.803   361.834     0.150
    28.831   361.617     0.150
    28.847   361.408     0.150
    28.847   359.568     0.150
    28.847   361.574     0.150
    28.849   362.068     0.150
    28.850   362.521     0.150
    28.851   361.844     0.150
    28.852   360.438     0.150
    28.897   361.867     0.150
    28.897   362.008     0.150
    28.905   359.889     0.150
    28.920   359.688     0.150
    28.987   363.217     0.150
    29.019   360.785     0.150
    29.059   362.367     0.150
    29.044   362.068     0.150
    29.070   364.635     0.150
    29.073   362.428     0.150
    29.085   362.619     0.150
    29.149   362.508     0.150
    29.149   362.258     0.150
    29.164   363.338     0.150
    29.193   362.768     0.150
    29.214   364.367     0.150
    29.272   364.168     0.150
    29.240   364.180     0.150
    29.237   363.184     0.150
    29.240   364.318     0.150
    29.240   363.787     0.150
    29.250   365.611     0.150
    29.245   363.469     0.150
    29.275   365.674     0.150
    29.292   364.867     0.150
    29.324   366.488     0.150
    29.324   365.387     0.150
    29.324   656.213     0.150
    29.344   364.668     0.150
    29.344   365.668     0.150
    29.433   364.820     0.150
    29.433   364.525     0.150
    29.423   365.129     0.150
    29.483   366.057     0.150
    29.516   365.209     0.150
    29.562   365.008     0.150
    29.562   364.564     0.150
    29.584   368.734     0.150
    29.593   365.365     0.150
    29.492   367.469     0.150
    29.604   365.162     0.150
    29.657   365.854     0.150
    29.762   366.943     0.150
    29.785   369.492     0.150
    29.811   368.867     0.150
    29.869   370.068     0.150
    29.892   369.168     0.150
    29.892   369.969     0.150
    29.859   368.973     0.150
    29.872   370.639     0.150
    29.900   370.668     0.150
    29.925   371.666     0.150
    29.939   370.867     0.150
    29.955   368.727     0.150
    29.988   370.861     0.150
    30.012   371.938     0.150
    30.004   369.832     0.150
    30.013   370.787     0.150
    30.023   371.402     0.150
    30.192   370.484     0.150
    30.192   370.758     0.150
    30.192   370.594     0.150
    30.207   373.268     0.150
    30.203   372.107     0.150
    30.220   373.299     0.150
    30.220   373.541     0.150
    30.224   372.287     0.150
    30.230   373.344     0.150
    30.264   373.291     0.150
    30.307   374.367     0.150
    30.303   372.156     0.150
    30.319   372.240     0.150
    30.396   375.604     0.150
    30.404   373.791     0.150
    30.423   376.178     0.150
    30.426   373.855     0.150
    30.470   376.787     0.150
    30.486   375.668     0.150
    30.486   680.168     0.150
    30.506   376.668     0.150
    30.506   375.117     0.150
    30.526   372.719     0.150
    30.585   374.729     0.150
    30.608   376.568     0.150
    30.652   375.848     0.150
    30.670   376.238     0.150
    30.685   377.986     0.150
    30.682   375.877     0.150
    30.710   376.918     0.150
    30.710   377.268     0.150
    30.726   376.123     0.150
    30.729   375.254     0.150
    30.775   377.072     0.150
    30.777   376.943     0.150
    30.813   377.119     0.150
    30.834   378.389     0.150
    30.834   378.121     0.150
    30.837   376.504     0.150
    30.852   379.068     0.150
    30.895   377.678     0.150
    30.895   437.518     0.150
    30.895   681.498     0.150
    30.894   378.633     0.150
    30.892   378.105     0.150
    30.896   377.129     0.150
    30.896   376.875     0.150
    30.917   379.281     0.150
    30.919   377.088     0.150
    30.919   376.855     0.150
    30.942   376.912     0.150
    30.964   378.141     0.150
    30.969   378.469     0.150
    30.993   380.744     0.150
    31.016   380.367     0.150
    31.041   378.145     0.150
    31.045   378.945     0.150
    31.054   379.094     0.150
    31.059   381.725     0.150
    31.093   380.568     0.150
    31.059   378.387     0.150
    31.075   379.193     0.150
    31.075   379.490     0.150
    31.092   379.930     0.150
    31.128   382.068     0.150
    31.135   379.496     0.150
    31.147   381.367     0.150
    31.170   382.479     0.150
    31.194   381.143     0.150
    31.195   380.951     0.150
    31.193   380.164     0.150
    31.208   381.715     0.150
    31.234   381.176     0.150
    31.243   381.695     0.150
    31.256   380.482     0.150
    31.241   383.312     0.150
    31.241   381.479     0.150
    31.284   380.135     0.150
    31.286   379.402     0.150
    31.295   382.479     0.150
    31.313   382.861     0.150
    31.327   380.736     0.150
    31.359   383.588     0.150
    31.359   384.389     0.150
    31.358   380.332     0.150
    31.360   380.725     0.150
    31.376   381.398     0.150
    31.384   384.236     0.150
    31.434   384.367     0.150
    31.451   384.006     0.150
    31.450   381.223     0.150
    31.455   383.242     0.150
    31.476   384.367     0.150
    31.490   384.469     0.150
    31.490   384.961     0.150
    31.522   384.168     0.150
    31.532   382.912     0.150
    31.540   381.197     0.150
    31.563   382.070     0.150
    31.576   383.469     0.150
    31.576   383.293     0.150
    31.597   382.137     0.150
    31.613   384.512     0.150
    31.620   384.889     0.150
    31.667   382.820     0.150
    31.726   385.725     0.150
    31.743   386.848     0.150
    31.793   387.768     0.150
    31.795   385.213     0.150
    31.860   385.344     0.150
    31.897   384.994     0.150
    31.971   385.422     0.150
    31.972   386.395     0.150
    31.998   388.533     0.150
    31.974   387.395     0.150
    31.974   386.178     0.150
    31.999   385.812     0.150
    32.016   389.100     0.150
    32.034   385.973     0.150
    32.072   390.580     0.150
    32.075   389.678     0.150
    32.103   390.828     0.150
    32.113   387.410     0.150
    32.116   388.629     0.150
    32.138   389.717     0.150
    32.151   387.068     0.150
    32.155   390.309     0.150
    32.225   388.316     0.150
    32.267   390.998     0.150
    32.267   391.639     0.150
    32.279   388.582     0.150
    32.286   391.342     0.150
    32.286   389.639     0.150
    32.286   388.654     0.150
    32.286   391.768     0.150
    32.320   391.037     0.150
    32.328   390.469     0.150
    32.356   391.908     0.150
    32.356   391.139     0.150
    32.354   389.453     0.150
    32.378   392.928     0.150
    32.399   392.748     0.150
    32.406   389.902     0.150
    32.429   389.805     0.150
    32.448   390.781     0.150
    32.465   389.596     0.150
    32.487   392.697     0.150
    32.487   393.068     0.150
    32.534   389.686     0.150
    32.542   390.113     0.150
    32.559   391.910     0.150
    32.643   391.895     0.150
    32.661   393.398     0.150
    32.672   395.770     0.150
    32.714   390.867     0.150
    32.714   709.469     0.150
    32.960   397.389     0.150
    33.071   394.506     0.150
    33.077   395.084     0.150
    33.064   396.969     0.150
    33.064   714.469     0.150
    33.086   396.059     0.150
    33.088   395.176     0.150
    33.106   395.412     0.150
    33.108   395.723     0.150
    33.156   398.469     0.150
    33.163   395.836     0.150
    33.197   395.303     0.150
    33.207   395.854     0.150
    33.219   396.578     0.150
    33.219   396.857     0.150
    33.219   396.219     0.150
    33.271   397.912     0.150
    33.309   399.328     0.150
    33.326   397.107     0.150
    33.339   400.059     0.150
    33.339   399.457     0.150
    33.299   399.348     0.150
    33.364   398.188     0.150
    33.411   400.158     0.150
    33.467   402.498     0.150
    33.486   401.508     0.150
    33.486   402.268     0.150
    33.498   399.707     0.150
    33.498   399.848     0.150
    33.515   400.367     0.150
    33.667   400.824     0.150
    33.667   401.078     0.150
    33.702   401.121     0.150
    33.702   400.988     0.150
    33.762   405.578     0.150
    33.762   406.268     0.150
    33.796   405.367     0.150
    33.796   404.979     0.150
    33.796   403.758     0.150
    33.842   403.277     0.150
    33.854   405.068     0.150
    33.854   479.668     0.150
    33.854   874.068     0.150
    33.937   404.168     0.150
    33.937   404.348     0.150
    33.937     3.500     0.150
    33.937   405.301     0.150
    33.995   406.549     0.150
    34.111   406.229     0.150
    34.090   406.867     0.150
    34.139   406.928     0.150
    34.146   407.469     0.150
    34.161   407.168     0.150
    34.254   408.969     0.150
    34.327   408.068     0.150
    34.370   409.914     0.150
    34.370   409.777     0.150
    34.370   408.629     0.150
    34.370   742.762     0.150
    34.421   408.867     0.150
    34.454   409.969     0.150
    34.474   410.129     0.150
    34.474   410.359     0.150
    34.521   410.469     0.150
    34.537   411.268     0.150
    34.538   410.768     0.150
    34.602   411.158     0.150
    34.602   411.008     0.150
    34.656   409.568     0.150
    34.773   412.168     0.150
    34.793   412.969     0.150
    34.818   413.268     0.150
    34.831   413.188     0.150
    34.840   413.969     0.150
    34.840   413.867     0.150
    34.842   413.568     0.150
    34.843   413.197     0.150
    34.878   413.168     0.150
    34.878   493.867     0.150
    34.997   413.969     0.150
    35.035   414.098     0.150
    35.042   415.258     0.150
    35.070   415.367     0.150
    35.097   413.268     0.150
    35.106   415.469     0.150
    35.110   413.867     0.150
    35.164   415.719     0.150
    35.164   747.299     0.150
    35.211   416.668     0.150
    35.226   416.037     0.150
    35.226   416.318     0.150
    35.251   415.969     0.150
    35.304   417.479     0.150
    35.349   418.068     0.150
    35.349   417.867     0.150
    35.386   418.889     0.150
    35.386   418.994     0.150
    35.438   418.537     0.150
    35.438   417.729     0.150
    35.438   418.951     0.150
    35.447   418.469     0.150
    35.454   418.668     0.150
    35.464   419.918     0.150
    35.505   419.568     0.150
    35.516   418.875     0.150
    35.516   418.457     0.150
    35.523   418.367     0.150
    35.529   418.367     0.150
    35.590   420.068     0.150
    35.590   420.268     0.150
    35.590   420.219     0.150
    35.644   420.168     0.150
    35.782   421.658     0.150
    35.782   420.678     0.150
    35.844   422.367     0.150
    35.850   421.367     0.150
    35.902   422.168     0.150
    35.947   420.955     0.150
    35.947   421.436     0.150
    35.929   420.498     0.150
    35.960   422.867     0.150
    35.960   423.338     0.150
    35.960   422.287     0.150
    35.996   422.639     0.150
    36.008   423.268     0.150
    36.039   423.498     0.150
    36.055   423.768     0.150
    36.119   424.648     0.150
    36.119   424.768     0.150
    36.142   424.648     0.150
    36.142   424.492     0.150
    36.143   424.559     0.150
    36.186   424.756     0.150
    36.244   425.428     0.150
    36.305   425.648     0.150
    36.367   426.498     0.150
    36.449   427.828     0.150
    36.449   426.979     0.150
    36.449   774.268     0.150
    36.446   425.646     0.150
    36.446   425.113     0.150
    36.446   425.848     0.150
    36.446     4.820     0.150
    36.450   425.527     0.150
    36.495   427.518     0.150
    36.485   426.168     0.150
    36.485   770.268     0.150
    36.485   914.469     0.150
    36.490   426.357     0.150
    36.537   428.197     0.150
    36.537   428.889     0.150
    36.545   428.658     0.150
    36.545   428.367     0.150
    36.580   427.008     0.150
    36.651   429.668     0.150
    36.669   428.148     0.150
    36.667   429.617     0.150
    36.667   429.768     0.150
    36.640   426.979     0.150
    36.640   427.611     0.150
    36.640   427.117     0.150
    36.640   570.697     0.150
    36.664   428.479     0.150
    36.681   429.229     0.150
    36.681   428.828     0.150
    36.654   427.469     0.150
    36.690   428.758     0.150
    36.690   428.518     0.150
    36.672   427.469     0.150
    36.753   428.738     0.150
    36.753   428.537     0.150
    36.765   429.639     0.150
    36.765   429.238     0.150
    36.765   428.998     0.150
    36.818   427.969     0.150
    36.839   430.826     0.150
    36.848   429.969     0.150
    36.958   431.367     0.150
    36.992   431.865     0.150
    37.168   431.988     0.150
    37.316   433.617     0.150
    37.320   434.719     0.150
    37.326   435.281     0.150
    37.327   434.848     0.150
    37.366   433.848     0.150
    37.525   436.309     0.150
    37.562   436.238     0.150
    37.562   436.391     0.150
    37.581   436.668     0.150
    37.581   435.129     0.150
    37.581   436.068     0.150
    37.583   435.258     0.150
    37.592   436.768     0.150
    37.620   437.328     0.150
    37.717   437.889     0.150
    37.717   437.668     0.150
    37.859   438.248     0.150
    37.928   438.568     0.150
    37.939   438.928     0.150
    37.944   439.818     0.150
    37.943   439.398     0.150
    37.949   439.807     0.150
    37.973   439.438     0.150
    37.978   439.756     0.150
    37.985   439.979     0.150
    37.994   438.857     0.150
    37.994   439.867     0.150
    37.994   440.068     0.150
    37.999   440.129     0.150
    37.999   439.549     0.150
    38.018   438.598     0.150
    38.036   440.697     0.150
    38.037   440.168     0.150
    38.094   440.148     0.150
    38.094   440.768     0.150
    38.094   791.367     0.150
    38.121   440.758     0.150
    38.114   441.268     0.150
    38.114   535.268     0.150
    38.114   795.068     0.150
    38.114   807.367     0.150
    38.139   440.488     0.150
    38.147   440.068     0.150
    38.160   441.748     0.150
    38.160   441.469     0.150
    38.232   441.928     0.150
    38.236   442.357     0.150
    38.271   442.631     0.150
    38.271   442.748     0.150
    38.271   441.787     0.150
    38.271   442.314     0.150
    38.326   442.818     0.150
    38.326   442.617     0.150
    38.326   441.674     0.150
    38.384   442.578     0.150
    38.384   442.719     0.150
    38.444   442.928     0.150
    38.548   444.537     0.150
    38.548   444.398     0.150
    38.554   444.168     0.150
    38.554   443.367     0.150
    38.612   445.367     0.150
    38.596   444.268     0.150
    38.596   801.469     0.150
    38.621   445.236     0.150
    38.656   445.787     0.150
    38.656   445.318     0.150
    38.656   445.568     0.150
    38.656   444.535     0.150
    38.656   530.668     0.150
    38.656   801.668     0.150
    38.714   446.148     0.150
    38.727   445.926     0.150
    38.843   447.197     0.150
    38.855   446.678     0.150
    38.907   448.357     0.150
    38.913   448.277     0.150
    38.936   448.428     0.150
    39.028   448.457     0.150
    39.028   447.828     0.150
    39.029   448.908     0.150
    39.059   448.197     0.150
    39.077   448.588     0.150
    39.107   449.979     0.150
    39.112   448.492     0.150
    39.162   448.527     0.150
    39.266   450.908     0.150
    39.002   449.408     0.150
    39.294   450.318     0.150
    39.294   449.979     0.150
    39.327   450.736     0.150
    39.331   450.488     0.150
    39.339   451.188     0.150
    39.353   451.588     0.150
    39.368   450.865     0.150
    39.368   451.879     0.150
    39.372   452.367     0.150
    39.372   543.268     0.150
    39.372   977.168     0.150
    39.392   451.527     0.150
    39.402   451.389     0.150
    39.413   452.527     0.150
    39.432   452.438     0.150
    39.438   451.918     0.150
    39.469   453.178     0.150
    39.530   452.607     0.150
    39.579   452.988     0.150
    39.544   452.508     0.150
    39.604   454.168     0.150
    39.610   453.879     0.150
    39.619   452.797     0.150
    39.650   454.367     0.150
    39.664   454.719     0.150
    39.664   453.449     0.150
    39.690   453.338     0.150
    39.699   454.219     0.150
    39.752   453.758     0.150
    39.767   454.309     0.150
    39.773   455.158     0.150
    39.853   455.617     0.150
    39.853   455.818     0.150
    39.853   454.785     0.150
    39.885   455.838     0.150
    39.885   456.588     0.150
    39.921   455.068     0.150
    39.948   455.676     0.150
    40.022   456.068     0.150
    40.022   456.818     0.150
    40.056   458.158     0.150
    40.065   457.107     0.150
    40.094   457.330     0.150
    40.133   457.277     0.150
    40.143   457.559     0.150
    40.143   457.348     0.150
    40.179   458.508     0.150
    40.179   457.227     0.150
    40.184   458.928     0.150
    40.265   458.928     0.150
    40.265  1006.479     0.150
    40.265   458.268     0.150
    40.265   458.867     0.150
    40.265   550.893     0.150
    40.273   458.469     0.150
    40.279   458.379     0.150
    40.277   458.818     0.150
    40.321   459.064     0.150
    40.340   460.188     0.150
    40.353   458.818     0.150
    40.363   459.129     0.150
    40.363   458.299     0.150
    40.490   460.469     0.150
    40.490   555.867     0.150
    40.523   460.328     0.150
    40.523   460.529     0.150
    40.536   460.639     0.150
    40.536   582.504     0.150
    40.558   461.098     0.150
    40.553   461.668     0.150
    40.553   832.168     0.150
    40.573   460.787     0.150
    40.571   462.148     0.150
    40.578   462.248     0.150
    40.585   462.178     0.150
    40.836   464.258     0.150
    40.880   462.809     0.150
    40.914   463.697     0.150
    40.914   463.197     0.150
    40.919   464.559     0.150
    40.969   464.629     0.150
    40.969   464.098     0.150
    40.969   463.516     0.150
    40.969   464.863     0.150
    41.030   464.658     0.150
    41.033   465.918     0.150
    41.141   465.367     0.150
    41.141   465.037     0.150
    41.154   464.908     0.150
    41.185   467.658     0.150
    41.283   466.768     0.150
    41.291   466.678     0.150
    41.305   467.969     0.150
    41.305   845.568     0.150
    41.305  1019.367     0.150
    41.333   467.068     0.150
    41.339   466.998     0.150
    41.452   467.707     0.150
    41.461   468.938     0.150
    41.473   469.678     0.150
    41.476   468.568     0.150
    41.476   566.277     0.150
    41.480   469.838     0.150
    41.497   467.957     0.150
    41.491   468.367     0.150
    41.507   468.537     0.150
    41.522   468.135     0.150
    41.528   468.469     0.150
    41.528   467.668     0.150
    41.528   468.668     0.150
    41.528   468.916     0.150
    41.528   565.119     0.150
    41.528   842.818     0.150
    41.531   468.617     0.150
    41.547   469.623     0.150
    41.547   468.838     0.150
    41.548   468.430     0.150
    41.548   468.588     0.150
    41.548   468.258     0.150
    41.548   467.943     0.150
    41.548   469.088     0.150
    41.583   470.207     0.150
    41.583   469.668     0.150
    41.606   467.268     0.150
    41.672   469.779     0.150
    41.672   469.938     0.150
    41.672   469.559     0.150
    41.692   470.867     0.150
    41.750   471.309     0.150
    41.817   471.457     0.150
    41.871   470.549     0.150
    41.871   470.367     0.150
    41.966   472.158     0.150
    41.961   471.768     0.150
    41.961   472.787     0.150
    41.951   471.389     0.150
    41.982   473.457     0.150
    41.982   472.211     0.150
    42.038   473.719     0.150
    42.166   474.447     0.150
    42.194   474.537     0.150
    42.194  1039.838     0.150
    42.224   474.867     0.150
    42.241   475.258     0.150
    42.241   474.697     0.150
    42.249   475.537     0.150
    42.249   474.568     0.150
    42.291   473.838     0.150
    42.320   474.928     0.150
    42.333   476.068     0.150
    42.333   475.168     0.150
    42.333   474.787     0.150
    42.333   475.469     0.150
    42.333   475.357     0.150
    42.335   475.488     0.150
    42.330   476.469     0.150
    42.355   476.857     0.150
    42.369   475.818     0.150
    42.379   476.059     0.150
    42.385   476.668     0.150
    42.385   859.668     0.150
    42.383   476.242     0.150
    42.383   475.910     0.150
    42.383   475.588     0.150
    42.383   476.729     0.150
    42.435   476.469     0.150
    42.461   476.588     0.150
    42.492   476.678     0.150
    42.503   477.510     0.150
    42.503   857.344     0.150
    42.503   476.367     0.150
    42.517   477.027     0.150
    42.559   477.277     0.150
    42.557   478.188     0.150
    42.573   477.188     0.150
    42.588   477.697     0.150
    42.588   864.607     0.150
    42.588  1040.258     0.150
    42.613   477.697     0.150
    42.627   478.129     0.150
    42.627   577.828     0.150
    42.601   476.898     0.150
    42.601   476.707     0.150
    42.709   478.357     0.150
    42.709   478.068     0.150
    42.706   477.168     0.150
    42.706   859.668     0.150
    42.788   479.338     0.150
    42.851   479.707     0.150
    42.850   478.748     0.150
    42.890   479.848     0.150
    42.890   580.238     0.150
    42.890  1057.908     0.150
    42.927   481.059     0.150
    42.955   481.889     0.150
    42.955   481.637     0.150
    42.955   480.617     0.150
    42.955   874.158     0.150
    42.972   480.598     0.150
    42.972   590.568     0.150
    42.892   481.168     0.150
    42.892   591.068     0.150
    42.892   823.469     0.150
    43.041   480.258     0.150
    42.991   480.809     0.150
    43.037   482.338     0.150
    43.037   482.219     0.150
    43.035   481.549     0.150
    43.032   480.357     0.150
    43.032   480.889     0.150
    43.084   482.277     0.150
    43.032   480.715     0.150
    43.032   481.178     0.150
    43.032   481.629     0.150
    43.124   481.428     0.150
    43.271   483.748     0.150
    43.253   483.338     0.150
    43.364   483.447     0.150
    43.457   483.318     0.150
    43.486   486.088     0.150
    43.489   486.078     0.150
    43.489   584.768     0.150
    43.489   873.428     0.150
    43.542   486.398     0.150
    43.605   486.078     0.150
    43.616   485.559     0.150
    43.616   589.838     0.150
    43.690   486.068     0.150
    43.690   872.768     0.150
    43.834   488.078     0.150
    43.834   593.848     0.150
    43.859   487.607     0.150
    43.932   489.037     0.150
    43.951   489.398     0.150
    43.951   590.178     0.150
    43.983   489.729     0.150
    44.030   489.168     0.150
    44.017   488.068     0.150
    44.069   490.457     0.150
    44.069   590.168     0.150
    44.069   883.658     0.150
    44.069  1077.098     0.150
    44.082   490.219     0.150
    44.082   489.508     0.150
    44.082   489.729     0.150
    44.082   595.848     0.150
    44.138   490.598     0.150
    44.138   886.338     0.150
    44.205   491.268     0.150
    44.199   490.568     0.150
    44.263   491.898     0.150
    44.289   491.787     0.150
    44.357   491.461     0.150
    44.357   491.809     0.150
    44.357   491.229     0.150
    44.357   491.969     0.150
    44.357     4.959     0.150
    44.389   492.348     0.150
    44.389   595.895     0.150
    44.399   491.818     0.150
    44.399   493.129     0.150
    44.426   492.729     0.150
    44.428   492.748     0.150
    44.428   881.027     0.150
    44.553   492.258     0.150
    44.552   494.068     0.150
    44.594   494.008     0.150
    44.616   493.768     0.150
    44.616   492.867     0.150
    44.703   494.168     0.150
    44.914   495.008     0.150
    44.984   497.078     0.150
    44.984  1087.719     0.150
    45.015   497.668     0.150
    45.135   496.568     0.150
    45.135   896.568     0.150
    45.135   497.197     0.150
    45.194   499.867     0.150
    45.460   500.129     0.150
    45.460   499.758     0.150
    45.563   501.863     0.150
    45.563   501.379     0.150
    45.563   500.648     0.150
    45.563   500.268     0.150
    45.563   501.697     0.150
    45.971   503.768     0.150
    45.971   503.639     0.150
    45.971   504.027     0.150
    45.969   503.758     0.150
    46.111   505.867     0.150
    46.111   912.668     0.150
    46.144   506.287     0.150
    46.295   507.117     0.150
    46.295   506.568     0.150
    46.339   507.248     0.150
    46.345   506.367     0.150
    46.407   507.969     0.150
    46.441   507.668     0.150
    46.469   508.969     0.150
    46.578   508.891     0.150
    46.626   508.568     0.150
    46.633   510.568     0.150
    46.673   510.258     0.150
    46.701   510.168     0.150
    46.867   509.367     0.150
    46.884   512.318     0.150
    46.867   508.912     0.150
    46.867   509.219     0.150
    46.980   513.158     0.150
    46.989   512.367     0.150
    46.989   511.928     0.150
    47.056   511.789     0.150
    47.056   511.969     0.150
    47.056   511.658     0.150
    47.127   512.889     0.150
    47.138   514.008     0.150
    47.124   513.646     0.150
    47.124   512.318     0.150
    47.140   515.668     0.150
    47.170   515.027     0.150
    47.150   513.867     0.150
    47.279   514.787     0.150
    47.339   515.568     0.150
    47.380   515.469     0.150
    47.403   515.707     0.150
    47.411   515.969     0.150
    47.421   515.537     0.150
    47.513   516.268     0.150
    47.513   516.398     0.150
    47.632   517.398     0.150
    47.723   517.639     0.150
    47.728   519.238     0.150
    47.728   518.992     0.150
    47.790   519.078     0.150
    47.802   518.928     0.150
    47.852   519.367     0.150
    47.862   519.648     0.150
    47.897   519.197     0.150
    47.897   519.338     0.150
    48.010   520.469     0.150
    48.098   521.078     0.150
    48.114   520.799     0.150
    48.108   520.867     0.150
    48.121   521.537     0.150
    48.219   522.037     0.150
    48.233   522.277     0.150
    48.268   522.768     0.150
    48.408   523.277     0.150
    48.437   523.098     0.150
    48.454   523.893     0.150
    48.464   524.357     0.150
    48.464   524.129     0.150
    48.481   524.488     0.150
    48.481   524.158     0.150
    48.481   523.527     0.150
    48.481   523.957     0.150
    48.481   524.348     0.150
    48.481     3.980     0.150
    48.486   524.219     0.150
    48.504   523.879     0.150
    48.608   524.777     0.150
    48.638   524.738     0.150
    48.648   525.787     0.150
    48.648   525.518     0.150
    48.769   525.969     0.150
    48.884   527.938     0.150
    48.884   526.799     0.150
    48.884   527.799     0.150
    48.889   527.367     0.150
    48.901   526.688     0.150
    48.931   527.578     0.150
    49.032   528.268     0.150
    49.155   529.248     0.150
    49.140   528.271     0.150
    49.140   528.098     0.150
    49.140   528.656     0.150
    49.252   530.107     0.150
    49.253   530.299     0.150
    49.255   530.168     0.150
    49.329   530.549     0.150
    49.347   531.068     0.150
    49.347   952.969     0.150
    49.372   530.787     0.150
    49.452   531.604     0.150
    49.661   534.330     0.150
    49.661   533.879     0.150
    49.797   533.482     0.150
    49.797   533.590     0.150
    49.797   963.836     0.150
    49.797   534.168     0.150
    49.797   612.768     0.150
    49.797   649.867     0.150
    49.797   964.469     0.150
    49.797  1122.367     0.150
    50.003   535.668     0.150
    50.134   536.438     0.150
    50.134   536.289     0.150
    50.141   536.289     0.150
    50.160   536.938     0.150
    50.231   537.479     0.150
    50.231   537.309     0.150
    50.223   537.588     0.150
    50.223   537.719     0.150
    50.223   537.469     0.150
    50.223   538.168     0.150
    50.323   538.162     0.150
    50.323   537.938     0.150
    50.323   537.568     0.150
    50.357   538.537     0.150
    50.399   537.678     0.150
    50.399   537.469     0.150
    50.408   538.639     0.150
    50.408   968.549     0.150
    50.515   539.738     0.150
    50.515   539.617     0.150
    50.528   538.844     0.150
    50.668   540.428     0.150
    50.870   542.348     0.150
    50.870   542.068     0.150
    50.961   543.258     0.150
    50.961   542.268     0.150
    50.935   541.939     0.150
    50.935   541.748     0.150
    51.126   543.527     0.150
    51.482   546.518     0.150
    51.482   983.268     0.150
    51.520   546.945     0.150
    51.520   546.729     0.150
    51.520   547.207     0.150
    51.559   548.068     0.150
    51.615   547.568     0.150
    51.645   547.768     0.150
    51.654   547.668     0.150
    51.655   547.918     0.150
    51.655   622.109     0.150
    51.670   547.787     0.150
    51.689   548.768     0.150
    51.757   548.668     0.150
    51.977   550.469     0.150
    51.977   550.639     0.150
    51.977     4.939     0.150
    51.995   549.350     0.150
    51.988   551.047     0.150
    51.988   550.207     0.150
    52.013   551.848     0.150
    52.013   551.139     0.150
    52.027   550.979     0.150
    52.027   550.367     0.150
    52.064   552.172     0.150
    52.064   551.857     0.150
    52.064   550.668     0.150
    52.159   552.367     0.150
    52.200   552.086     0.150
    52.222   551.898     0.150
    52.222   550.625     0.150
    52.226   551.053     0.150
    52.271   552.068     0.150
    52.352   551.867     0.150
    52.421   553.787     0.150
    52.421   553.129     0.150
    52.422   554.418     0.150
    52.480   553.799     0.150
    52.480   553.703     0.150
    52.480   554.268     0.150
    52.494   553.969     0.150
    52.498   554.068     0.150
    52.481   554.268     0.150
    52.556   554.729     0.150
    52.884   556.287     0.150
    53.044   558.508     0.150
    53.044   558.648     0.150
    53.050   557.770     0.150
    53.050   558.809     0.150
    53.108   559.469     0.150
    53.522   561.668     0.150
    53.525   561.328     0.150
    53.525   561.719     0.150
    53.525   561.098     0.150
    53.537   561.568     0.150
    54.073   566.639     0.150
    54.073   566.229     0.150
    54.073   566.863     0.150
    54.301   567.969     0.150
    54.331   567.129     0.150
    54.430   568.658     0.150
    54.430   567.768     0.150
    54.430   568.809     0.150
    54.479   568.928     0.150
    54.480   568.457     0.150
    54.518   568.818     0.150
    54.583   569.559     0.150
    54.583   569.357     0.150
    54.610   569.893     0.150
    54.610   569.648     0.150
    54.610   569.268     0.150
    54.813   571.469     0.150
    54.888   572.668     0.150
    55.004   572.818     0.150
    55.157   573.758     0.150
    55.157   573.498     0.150
    55.126   573.238     0.150
    55.126   572.979     0.150
    55.126   573.117     0.150
    55.126   573.568     0.150
    55.126   575.438     0.150
    55.386   575.428     0.150
    55.556   576.578     0.150
    55.701   577.707     0.150
    55.764   579.328     0.150
    55.764   578.688     0.150
    55.733   576.988     0.150
    55.783   578.287     0.150
    55.774   578.764     0.150
    55.774   578.867     0.150
    55.774   578.658     0.150
    55.774   577.838     0.150
    55.889   578.998     0.150
    55.889   578.668     0.150
    56.081   579.207     0.150
    56.081   580.398     0.150
    56.081   580.258     0.150
    56.388   582.438     0.150
    56.388   582.777     0.150
    56.433   585.213     0.150
    56.433   584.969     0.150
    56.433   583.168     0.150
    56.433   583.668     0.150
    56.433     4.191     0.150
    56.557   583.408     0.150
    56.557   583.867     0.150
    56.724   584.600     0.150
    56.724   584.357     0.150
    56.833   585.639     0.150
    57.188   588.348     0.150
    57.188   587.918     0.150
    57.188   588.799     0.150
    58.145   593.768     0.150
    58.145   593.488     0.150
    58.145   593.379     0.150
    58.145   593.617     0.150
    58.355   596.900     0.150
    58.355   597.107     0.150
    58.599   598.969     0.150
    58.599  1081.268     0.150
    59.045   600.768     0.150
    59.045   601.688     0.150
    59.045   601.457     0.150
    59.045     6.221     0.150
    59.543   606.207     0.150
    59.702   606.518     0.150
    59.911   607.168     0.150
    59.911  1100.168     0.150
    59.911   606.629     0.150
    59.911   606.287     0.150
    60.014   608.988     0.150
    60.014   608.168     0.150
    60.014   608.867     0.150
    60.014     4.971     0.150
    60.038   608.568     0.150
    60.038  1105.568     0.150
    60.108   608.779     0.150
    60.108   608.088     0.150
    60.108   608.469     0.150
    60.185   608.629     0.150
    60.265   608.418     0.150
    60.341   611.168     0.150
    60.341   611.318     0.150
    60.341   610.867     0.150
    60.344   609.668     0.150
    60.344   610.588     0.150
    60.344   609.918     0.150
    60.344   610.379     0.150
    60.530   611.312     0.150
    60.530   610.889     0.150
    60.530   610.379     0.150
    60.532   611.336     0.150
    60.567   611.268     0.150
    60.802   614.268     0.150
    60.799   614.268     0.150
    60.975   612.846     0.150
    60.975   613.578     0.150
    60.975   613.828     0.150
    61.963   620.969     0.150
    62.611   626.787     0.150
    62.737   626.588     0.150
    62.729   626.037     0.150
    62.729   626.688     0.150
    62.872   627.168     0.150
    63.511   631.469     0.150
    63.511   632.463     0.150
    63.511   631.648     0.150
    63.511     3.650     0.150
    63.851   633.268     0.150
    63.851  1149.168     0.150
    63.909   634.168     0.150
    63.909   633.889     0.150
    63.909   633.479     0.150
    63.909   634.668     0.150
    64.086   635.248     0.150
    64.086   635.738     0.150
    64.123   635.287     0.150
    64.123   634.768     0.150
    64.399   636.898     0.150
    64.493   637.598     0.150
    64.617   639.258     0.150
    64.934   640.758     0.150
    65.577   644.818     0.150
    65.601   645.197     0.150
    65.642   645.518     0.150
    66.270   649.389     0.150
    66.299   650.148     0.150
    66.356   647.379     0.150
    66.386   649.867     0.150
    66.386   648.957     0.150
    66.386   648.980     0.150
    66.386   797.693     0.150
    66.398   649.969     0.150
    66.662   651.629     0.150
    66.662   651.379     0.150
    66.786   651.037     0.150
    66.938   653.062     0.150
    66.938   652.588     0.150
    66.938  1180.969     0.150
    66.938  1442.469     0.150
    67.011   651.219     0.150
    67.011   651.557     0.150
    67.097   654.043     0.150
    67.097   654.344     0.150
    67.097   653.889     0.150
    67.201   653.764     0.150
    67.201   655.447     0.150
    67.201   654.277     0.150
    67.919   659.828     0.150
    67.987   661.328     0.150
    68.087   661.363     0.150
    68.087   660.988     0.150
    68.087   661.178     0.150
    68.257   659.891     0.150
    68.447   663.408     0.150
    68.559   663.568     0.150
    68.559   663.693     0.150
    68.559   664.107     0.150
    68.559   663.898     0.150
    69.014   666.918     0.150
    69.014   666.117     0.150
    69.043   666.268     0.150
    69.553   670.088     0.150
    69.553   669.129     0.150
    69.553   669.268     0.150
    69.995   670.428     0.150
    69.995   670.818     0.150
    69.888   671.799     0.150
    70.157   673.438     0.150
    70.157   672.617     0.150
    70.157   672.141     0.150
    70.157   672.969     0.150
    70.280   674.088     0.150
    70.280   674.879     0.150
    71.000   678.768     0.150
    71.000   679.613     0.150
    71.000   679.889     0.150
    71.778   682.969     0.150
    71.778   682.693     0.150
    71.778   682.867     0.150
    71.778   682.398     0.150
    71.900   684.559     0.150
    72.387   687.668     0.150
    72.387   687.238     0.150
    72.895   689.857     0.150
    72.979   690.477     0.150
    73.655   693.969     0.150
    73.666   693.738     0.150
    73.666   693.434     0.150
    74.297   698.400     0.150
    74.297   697.857     0.150
    74.429   700.527     0.150
    74.440   701.188     0.150
    74.752   699.998     0.150
    74.752   699.549     0.150
    74.752   700.979     0.150
    74.985   701.969     0.150
    75.300   703.812     0.150
    75.607   706.293     0.150
    75.607   705.568     0.150
    75.607   705.848     0.150
    75.657   706.588     0.150
    75.657   706.219     0.150
    75.657   705.508     0.150
    75.657   705.668     0.150
    76.086   709.379     0.150
    76.566   711.408     0.150
    76.712   713.479     0.150
    76.739   712.969     0.150
    76.739   712.838     0.150
    76.739   712.469     0.150
    77.003   714.244     0.150
    77.003   714.018     0.150
    77.003   713.367     0.150
    77.597   717.348     0.150
    77.597   717.922     0.150
    77.979   720.613     0.150
    77.979   719.678     0.150
    77.979   719.219     0.150
    77.992   718.855     0.150
    78.092   720.863     0.150
    78.092   719.998     0.150
    78.137   720.912     0.150
    78.137   720.268     0.150
    78.400   721.367     0.150
    78.400  1856.367     0.150
    78.400  2054.719     0.150
    78.506   722.719     0.150
    78.531   722.598     0.150
    78.975   724.867     0.150
    79.062   725.418     0.150
    79.622   728.367     0.150
    79.694   728.979     0.150
    79.851   728.857     0.150
    79.907   729.188     0.150
    80.105   730.543     0.150
    80.215   732.287     0.150
    80.381   732.568     0.150
    80.616   733.527     0.150
    80.616   734.197     0.150
    80.616   733.768     0.150
    80.637   734.078     0.150
    80.656   733.547     0.150
    80.656   733.438     0.150
    80.812   734.428     0.150
    80.812   734.617     0.150
    80.812   734.168     0.150
    80.813   734.643     0.150
    80.813   734.518     0.150
    80.875   735.469     0.150
    80.887   736.707     0.150
    81.015   735.867     0.150
    81.270   737.309     0.150
    81.234   736.139     0.150
    81.234   735.418     0.150
    81.234   736.367     0.150
    81.427   736.514     0.150
    81.427   736.178     0.150
    81.427   737.398     0.150
    81.499   738.537     0.150
    81.500   739.488     0.150
    81.596   740.355     0.150
    81.741   739.268     0.150
    82.023   742.229     0.150
    82.262   742.277     0.150
    82.262   742.543     0.150
    82.954   744.264     0.150
    82.954   743.648     0.150
    83.113   747.318     0.150
    83.158   747.168     0.150
    83.181   747.219     0.150
    83.181   747.268     0.150
    83.338   747.543     0.150
    83.374   746.764     0.150
    83.500   749.639     0.150
    83.500   749.348     0.150
    83.500   749.514     0.150
    83.528   751.096     0.150
    83.664   748.568     0.150
    84.074   751.707     0.150
    84.278   750.688     0.150
    84.948   754.643     0.150
    84.948   754.486     0.150
    85.302   757.379     0.150
    85.875   759.742     0.150
    86.033   761.117     0.150
    86.443   763.078     0.150
    86.458   764.996     0.150
    86.506   763.818     0.150
    86.591   763.617     0.150
    86.591   762.658     0.150
    86.738   764.693     0.150
    87.610   768.668     0.150
    87.609   768.883     0.150
    87.609  1838.992     0.150
    87.609  2323.553     0.150
    87.609   768.518     0.150
    87.769   769.268     0.150
    88.133   772.008     0.150
    89.356   778.027     0.150
    89.584   778.568     0.150
    89.584   777.969     0.150
    89.583   777.867     0.150
    89.583  1076.176     0.150
    89.583  1832.719     0.150
    89.583  2320.439     0.150
    89.583   778.098     0.150
    89.616   778.168     0.150
    89.931   780.713     0.150
    89.931   780.418     0.150
    89.931   779.857     0.150
    89.931   780.268     0.150
    90.093   781.219     0.150
    90.093   780.318     0.150
    90.093   780.658     0.150
    91.919   789.469     0.150
    91.919   788.697     0.150
    91.919   788.969     0.150
    93.228   794.367     0.150
    93.379   795.643     0.150
    93.770   797.293     0.150
    94.136   799.268     0.150
    94.534   801.518     0.150
    95.081   804.168     0.150
    95.473   805.518     0.150
    96.422   810.957     0.150
    96.434   810.488     0.150
    96.660   810.242     0.150
    96.660   809.158     0.150
    96.734   812.818     0.150
    96.747   810.719     0.150
    96.747   812.432     0.150
    96.953   812.193     0.150
    97.383   815.293     0.150
    97.383   814.318     0.150
    97.481   814.398     0.150
    97.634   816.268     0.150
    98.197   819.943     0.150
    98.717   820.648     0.150
    98.848   821.889     0.150
    98.848   820.367     0.150
    98.903   820.889     0.150
    98.963   822.043     0.150
    99.583   824.090     0.150
    99.936   827.268     0.150
    99.921   824.809     0.150
   100.583   829.787     0.150
   101.912   836.088     0.150
   101.912   832.793     0.150
   101.912  1804.768     0.150
   102.180   836.418     0.150
   102.584   838.980     0.150
   102.584  1796.268     0.150
   104.629  1107.068     0.150
   107.316   860.902     0.150
   107.316  1108.041     0.150
   107.316  1783.018     0.150
   107.316  2286.436     0.150
   110.978  1112.367     0.150
   111.580   877.098     0.150
   114.004  1118.734     0.150
   114.004  1760.855     0.150
   114.935  1121.893     0.150
   114.935  1179.342     0.150
   114.935  1758.469     0.150
   114.932  1180.908     0.150
   115.149  1120.113     0.150
   115.149  1756.734     0.150
   115.149  1120.379     0.150
   115.149  1119.355     0.150
   115.149  1756.135     0.150
   115.979  1121.959     0.150
   115.979  1752.461     0.150
   116.086  1755.359     0.150
   116.384  1124.168     0.150
   116.829  1125.768     0.150
   116.829  1123.469     0.150
   121.127  1732.787     0.150
   122.703  1137.367     0.150
   122.898  1136.068     0.150
   123.051  1138.396     0.150
   123.306  1139.277     0.150
   123.436  1136.969     0.150
   123.721  1138.764     0.150
   123.721  1138.367     0.150
   124.015  1139.287     0.150
   124.248  1138.568     0.150
   124.362  1138.068     0.150
   124.433  1138.037     0.150
   124.433  1245.490     0.150
   125.100  1140.570     0.150
   125.466  1141.971     0.150
   125.778  1141.768     0.150
   125.834  1142.268     0.150
   125.856  1142.320     0.150
   125.884  1142.027     0.150
   126.467  1143.129     0.150
   126.482  1142.559     0.150
   126.650  1145.191     0.150
   126.728  1143.367     0.150
   126.703  1142.969     0.150
   126.703  1143.463     0.150
   127.283  1144.879     0.150
   127.369  1145.799     0.150
   127.616  1144.537     0.150
   128.281  1143.078     0.150
   128.396  1144.432     0.150
   128.746  1145.891     0.150
   129.076  1147.650     0.150
   131.802  1155.193     0.150
   131.802  1154.543     0.150
   133.580  1159.168     0.150
   133.984  1159.713     0.150
   134.131  1160.488     0.150
   134.131  1160.088     0.150
   134.456  1160.168     0.150
   134.607  1162.799     0.150
   135.295  1161.639     0.150
   135.444  1161.969     0.150
   135.637  1162.043     0.150
   135.761  1164.238     0.150
   135.981  1160.438     0.150
   136.271  1163.438     0.150
   136.294  1160.668     0.150
   136.427  1162.318     0.150
   138.436  1167.268     0.150
   139.587  1169.088     0.150
   139.587  1165.768     0.150
   142.208  1174.018     0.150
   142.208  1172.498     0.150
   143.560  1172.318     0.150
   144.303  1175.469     0.150
   147.242  1184.320     0.150
   147.264  1186.469     0.150
   147.578  1185.418     0.150
     1.338    25.305     0.150
     1.338    25.154     0.150
     1.553    27.504     0.150
     1.726    31.805     0.150
     1.726    30.914     0.150
     1.968    34.113     0.150
     2.187    38.504     0.150
     2.214    38.703     0.150
     2.244    38.504     0.150
     2.446    41.404     0.150
     2.471    42.104     0.150
     2.567    42.904     0.150
     2.905    48.305     0.150
     3.141    51.504     0.150
     3.441    54.604     0.150
     3.752    60.404     0.150
     3.899    62.703     0.150
     3.963    62.293     0.150
     3.970    61.904     0.150
     4.309    66.805     0.150
     4.422    67.404     0.150
     4.422   142.754     0.150
     4.479    69.104     0.150
     4.506    69.604     0.150
     4.670    71.123     0.150
     5.497    83.703     0.150
     5.566    84.004     0.150
     5.616    84.904     0.150
     6.014    89.154     0.150
     6.005    90.203     0.150
     6.042    90.254     0.150
     6.144    92.004     0.150
     6.262    90.805     0.150
     6.482    97.604     0.150
     7.236   105.674     0.150
     9.030   130.305     0.150
    10.113   145.055     0.150
    10.760   152.674     0.150
    10.875   154.293     0.150
    11.075   157.414     0.150
    12.770   182.410     0.150
    12.770   181.635     0.150
    14.688   206.514     0.150
    14.688   207.203     0.150
    16.042   224.531     0.150
    16.042   396.303     0.150
    16.279   227.354     0.150
    17.420   242.004     0.150
    19.401   267.244     0.150
    19.689   269.023     0.150
    20.129   274.430     0.150
    20.236   274.604     0.150
    22.775   301.814     0.150
    22.775   532.754     0.150
    22.775   552.664     0.150
    22.929   305.725     0.150
    22.929   306.250     0.150
    22.929   305.154     0.150
    25.221   325.416     0.150
    26.187   334.123     0.150
    36.716   428.453     0.150
    36.716   427.994     0.150
    40.244   456.828     0.150
    41.193   465.750     0.150
    41.193   466.373     0.150
    41.486   467.254     0.150
    46.604   509.193     0.150
    47.058   512.273     0.150
    51.585   546.754     0.150
    51.585   546.424     0.150
    51.906   548.834     0.150
    71.729   682.215     0.150
    77.371   713.363     0.150
    87.680   769.135     0.150
    89.652   777.904     0.150
     1.473    26.100     0.150
     1.473    26.629     0.150
     1.817    32.400     0.150
     1.982    34.840     0.150
     2.361    39.400     0.150
     2.587    42.799     0.150
     2.801    46.520     0.150
     3.015    48.600     0.150
     3.252    51.900     0.150
     3.840    60.699     0.150
     3.947    61.400     0.150
     4.010    62.799     0.150
     4.138    63.459     0.150
     4.145    63.500     0.150
     4.508    70.100     0.150
     4.508   146.836     0.150
     4.483    68.400     0.150
     4.654    70.600     0.150
     4.680    71.100     0.150
     4.773    73.199     0.150
     5.222    78.400     0.150
     5.617    84.400     0.150
     5.617    85.119     0.150
     5.843    89.648     0.150
     5.843    88.420     0.150
     5.773    86.500     0.150
     5.919    91.166     0.150
     5.921    88.500     0.150
     6.186    91.590     0.150
     6.258    92.650     0.150
     6.408    92.270     0.150
     6.555    97.289     0.150
     6.646    98.799     0.150
     6.877   101.699     0.150
     6.932   102.699     0.150
     6.976   103.000     0.150
     7.100   104.754     0.150
     7.100   183.568     0.150
     7.100   104.639     0.150
     7.100   105.160     0.150
     7.154   105.400     0.150
     7.154   105.279     0.150
     7.237   107.299     0.150
     7.237   108.850     0.150
     7.421   109.799     0.150
     7.606   111.799     0.150
     7.610   112.199     0.150
     7.896   115.680     0.150
     7.846   115.029     0.150
     8.011   117.799     0.150
     8.188   119.900     0.150
     8.209   120.199     0.150
     8.511   124.199     0.150
     8.554   123.299     0.150
     8.575   125.199     0.150
     8.655   126.000     0.150
     8.724   128.000     0.150
     8.725   127.199     0.150
     8.876   128.209     0.150
     8.771   129.170     0.150
     8.798   129.100     0.150
     8.841   128.830     0.150
     8.948   131.289     0.150
     9.219   133.549     0.150
     9.118   130.600     0.150
     9.118   132.879     0.150
     9.148   133.820     0.150
     9.412   136.900     0.150
     9.412   138.586     0.150
     9.566   139.949     0.150
     9.714   140.119     0.150
     9.968   142.959     0.150
     9.840   142.520     0.150
     9.938   145.793     0.150
     9.938   145.906     0.150
     9.947   144.449     0.150
     9.980   146.525     0.150
    10.048   146.699     0.150
    10.048   147.270     0.150
    10.187   147.500     0.150
    10.187   147.119     0.150
    10.371   144.850     0.150
    10.613   150.520     0.150
    10.526   153.945     0.150
    10.534   154.287     0.150
    10.534   153.990     0.150
    10.536   154.146     0.150
    10.604   154.852     0.150
    10.604   155.150     0.150
    10.745   152.947     0.150
    10.745   268.967     0.150
    10.745   271.100     0.150
    10.773   157.980     0.150
    10.947   154.629     0.150
    10.879   158.000     0.150
    10.887   157.719     0.150
    10.887   156.549     0.150
    10.887   155.760     0.150
    10.887   158.924     0.150
    10.887   158.268     0.150
    10.887   156.760     0.150
    11.089   157.609     0.150
    11.023   159.654     0.150
    11.023   160.475     0.150
    11.073   161.414     0.150
    11.194   160.600     0.150
    11.179   161.977     0.150
    11.179   163.061     0.150
    11.330   165.199     0.150
    11.330   292.299     0.150
    11.316   164.406     0.150
    11.316   164.848     0.150
    11.498   166.482     0.150
    11.534   167.998     0.150
    11.534   168.180     0.150
    11.587   167.295     0.150
    11.776   168.000     0.150
    11.776   301.600     0.150
    11.740   170.379     0.150
    11.754   169.701     0.150
    11.864   170.357     0.150
    11.970   172.699     0.150
    12.083   169.240     0.150
    12.049   173.721     0.150
    12.206   171.939     0.150
    12.222   175.600     0.150
    12.236   176.432     0.150
    12.283   174.645     0.150
    12.317   177.430     0.150
    12.579   181.209     0.150
    12.620   178.258     0.150
    12.620   178.430     0.150
    12.620   179.244     0.150
    12.620   320.422     0.150
    12.620   177.859     0.150
    12.620   178.533     0.150
    12.620   319.547     0.150
    12.620   178.010     0.150
    12.620   179.799     0.150
    12.549   179.000     0.150
    12.577   181.168     0.150
    12.657   180.314     0.150
    12.698   181.383     0.150
    12.907   182.100     0.150
    12.983   181.820     0.150
    12.975   185.439     0.150
    12.994   181.609     0.150
    12.922   187.111     0.150
    12.939   185.439     0.150
    12.967   186.100     0.150
    13.098   185.010     0.150
    13.113   187.799     0.150
    13.100   189.371     0.150
    13.260   191.299     0.150
    13.260   339.100     0.150
    13.289   191.693     0.150
    13.289   192.344     0.150
    13.303   191.539     0.150
    13.436   189.000     0.150
    13.356   191.699     0.150
    13.356   339.400     0.150
    13.324   190.719     0.150
    13.451   188.020     0.150
    13.506   190.160     0.150
    13.620   195.240     0.150
    13.589   194.529     0.150
    13.685   197.510     0.150
    13.752   198.199     0.150
    13.752   351.000     0.150
    13.904   196.320     0.150
    13.923   200.500     0.150
    13.923   355.600     0.150
    13.996   201.139     0.150
    13.980   197.500     0.150
    13.980   351.500     0.150
    14.065   199.299     0.150
    14.065   198.549     0.150
    14.064   201.252     0.150
    14.253   207.539     0.150
    14.270   203.480     0.150
    14.285   203.369     0.150
    14.285   203.010     0.150
    14.311   199.889     0.150
    14.311   201.000     0.150
    14.312   203.709     0.150
    14.253   203.869     0.150
    14.393   206.061     0.150
    14.397   209.580     0.150
    14.422   211.449     0.150
    14.481   203.129     0.150
    14.481   365.639     0.150
    14.577   208.299     0.150
    14.667   205.191     0.150
    14.667   361.533     0.150
    14.667   362.199     0.150
    14.738   211.883     0.150
    14.738   209.609     0.150
    14.738   210.100     0.150
    14.738   213.830     0.150
    14.738   213.494     0.150
    14.896   210.570     0.150
    15.033   211.900     0.150
    14.964   216.031     0.150
    15.094   210.703     0.150
    15.094   210.289     0.150
    15.182   215.979     0.150
    15.297   214.090     0.150
    15.297   385.340     0.150
    15.377   217.061     0.150
    15.627   217.471     0.150
    15.627   387.111     0.150
    15.668   218.699     0.150
    15.668   394.129     0.150
    15.635   222.020     0.150
    15.714   220.105     0.150
    15.659   222.980     0.150
    15.765   223.910     0.150
    15.819   222.279     0.150
    15.819   222.109     0.150
    15.817   225.010     0.150
    16.311   227.359     0.150
    16.311   410.189     0.150
    16.033   222.574     0.150
    16.033   397.152     0.150
    16.033   222.873     0.150
    16.033   396.439     0.150
    16.121   223.924     0.150
    16.121   224.660     0.150
    16.121   226.854     0.150
    16.280   229.020     0.150
    16.291   229.420     0.150
    16.245   229.699     0.150
    16.652   234.539     0.150
    16.599   234.260     0.150
    16.745   234.900     0.150
    16.820   239.764     0.150
    17.006   240.969     0.150
    17.217   237.770     0.150
    17.242   242.600     0.150
    17.303   238.250     0.150
    17.303   242.799     0.150
    17.303   239.799     0.150
    17.346   243.889     0.150
    17.501   245.084     0.150
    17.538   243.510     0.150
    17.538   243.770     0.150
    17.538   245.600     0.150
    17.538   243.100     0.150
    17.538   242.217     0.150
    17.538   245.330     0.150
    17.538   249.689     0.150
    17.652   246.660     0.150
    17.652   453.869     0.150
    17.993   250.695     0.150
    18.049   251.150     0.150
    18.175   251.820     0.150
    18.175   251.070     0.150
    18.137   250.281     0.150
    18.137   250.180     0.150
    18.137   250.811     0.150
    18.137   250.449     0.150
    18.198   253.404     0.150
    18.433   255.395     0.150
    18.890   260.869     0.150
    18.909   262.369     0.150
    19.091   262.400     0.150
    19.105   266.500     0.150
    19.105   482.299     0.150
    19.320   264.949     0.150
    19.324   265.139     0.150
    19.324   266.230     0.150
    19.365   264.955     0.150
    19.365   266.311     0.150
    19.412   268.430     0.150
    19.381   267.400     0.150
    19.381   485.000     0.150
    19.397   268.521     0.150
    19.397   268.920     0.150
    19.397   268.170     0.150
    19.541   267.211     0.150
    19.541   267.400     0.150
    19.541   267.699     0.150
    19.541   267.400     0.150
    19.541   266.910     0.150
    19.541   267.299     0.150
    19.525   268.750     0.150
    19.605   269.100     0.150
    19.720   269.199     0.150
    19.719   272.000     0.150
    19.719   493.199     0.150
    20.007   273.174     0.150
    20.007   272.611     0.150
    20.007   273.500     0.150
    20.114   274.404     0.150
    20.114   274.529     0.150
    20.114   273.879     0.150
    20.114   274.750     0.150
    20.190   277.420     0.150
    20.452   276.900     0.150
    20.440   278.920     0.150
    20.439   279.061     0.150
    20.637   278.840     0.150
    20.842   283.900     0.150
    20.880   283.949     0.150
    20.880   283.139     0.150
    20.995   282.699     0.150
    20.963   285.930     0.150
    21.058   283.879     0.150
    21.058   283.439     0.150
    21.058   282.400     0.150
    21.241   285.400     0.150
    21.394   288.000     0.150
    21.312   288.910     0.150
    21.340   289.299     0.150
    21.340   526.500     0.150
    21.644   293.150     0.150
    21.773   293.750     0.150
    21.845   292.100     0.150
    21.868   294.730     0.150
    21.874   293.730     0.150
    21.874   532.754     0.150
    21.874   293.070     0.150
    21.874   293.500     0.150
    21.874   293.900     0.150
    22.090   295.400     0.150
    22.103   297.750     0.150
    22.111   298.789     0.150
    22.111   297.061     0.150
    22.195   297.100     0.150
    22.195   544.500     0.150
    22.289   300.650     0.150
    22.382   299.029     0.150
    22.371   301.350     0.150
    22.371   300.990     0.150
    22.477   298.699     0.150
    22.608   300.709     0.150
    22.679   301.570     0.150
    22.679   534.000     0.150
    22.679   552.430     0.150
    22.828   306.555     0.150
    23.052   307.389     0.150
    23.072   306.600     0.150
    23.075   307.557     0.150
    23.075   306.770     0.150
    23.075   307.000     0.150
    23.075   307.199     0.150
    23.075   535.066     0.150
    23.075   305.959     0.150
    23.201   307.699     0.150
    23.138   307.629     0.150
    23.356   309.500     0.150
    23.367   310.699     0.150
    23.367   309.949     0.150
    23.367   309.699     0.150
    23.461   311.070     0.150
    23.480   310.109     0.150
    23.480   310.789     0.150
    23.608   312.400     0.150
    23.606   312.061     0.150
    23.629   311.699     0.150
    23.629   569.400     0.150
    23.734   314.305     0.150
    23.734   313.480     0.150
    23.734   315.209     0.150
    23.734   314.959     0.150
    23.820   316.451     0.150
    23.942   315.660     0.150
    23.973   315.699     0.150
    24.125   317.580     0.150
    24.316   318.699     0.150
    24.472   320.619     0.150
    24.629   322.500     0.150
    24.683   323.795     0.150
    25.098   324.092     0.150
    25.098   324.713     0.150
    25.098   325.000     0.150
    25.098   324.850     0.150
    25.098   324.180     0.150
    25.149   326.174     0.150
    25.149   325.811     0.150
    25.149   326.561     0.150
    25.278   329.500     0.150
    25.356   328.299     0.150
    25.447   329.811     0.150
    25.446   330.949     0.150
    25.452   329.061     0.150
    25.493   330.500     0.150
    25.493   329.494     0.150
    25.493   328.879     0.150
    25.493   329.859     0.150
    25.533   329.760     0.150
    26.051   334.279     0.150
    26.345   336.820     0.150
    26.385   337.199     0.150
    26.487   339.449     0.150
    26.749   340.900     0.150
    26.749   615.699     0.150
    26.788   343.018     0.150
    26.914   342.209     0.150
    26.922   343.400     0.150
    26.922   383.600     0.150
    26.980   342.900     0.150
    26.980   343.041     0.150
    26.980   342.480     0.150
    26.980   343.510     0.150
    27.013   342.680     0.150
    27.215   347.072     0.150
    27.275   347.650     0.150
    27.336   348.023     0.150
    27.490   347.426     0.150
    27.490   347.289     0.150
    27.490   347.529     0.150
    27.490   348.000     0.150
    27.490   348.799     0.150
    27.530   348.100     0.150
    27.535   346.275     0.150
    27.535   347.600     0.150
    27.535   348.379     0.150
    27.540   349.299     0.150
    27.540   348.500     0.150
    27.594   348.980     0.150
    27.594   347.250     0.150
    27.709   350.959     0.150
    27.714   350.299     0.150
    27.806   349.990     0.150
    27.806   352.100     0.150
    27.867   353.199     0.150
    27.875   352.855     0.150
    27.971   354.578     0.150
    27.997   354.793     0.150
    27.989   352.785     0.150
    28.137   353.000     0.150
    28.180   353.900     0.150
    28.141   355.436     0.150
    28.138   352.824     0.150
    28.282   355.410     0.150
    28.336   356.699     0.150
    28.414   355.514     0.150
    28.578   357.400     0.150
    28.603   357.600     0.150
    28.621   356.725     0.150
    28.621   547.650     0.150
    28.621   357.100     0.150
    28.621   357.799     0.150
    28.621   357.199     0.150
    28.628   356.928     0.150
    28.628   356.570     0.150
    28.628   357.799     0.150
    28.628     4.891     0.150
    28.628   357.318     0.150
    28.628   357.600     0.150
    28.631   357.900     0.150
    28.653   359.080     0.150
    28.660   360.852     0.150
    28.678   358.299     0.150
    28.685   358.299     0.150
    28.702   358.500     0.150
    28.721   358.699     0.150
    28.711   360.400     0.150
    28.756   359.000     0.150
    28.841   359.980     0.150
    28.770   361.010     0.150
    28.768   358.484     0.150
    28.827   361.654     0.150
    28.861   363.156     0.150
    28.889   362.727     0.150
    28.856   361.916     0.150
    28.856   359.549     0.150
    28.856   360.984     0.150
    28.856   362.160     0.150
    28.904   360.830     0.150
    28.904   360.299     0.150
    28.904   362.199     0.150
    28.908   362.084     0.150
    28.908   363.100     0.150
    28.909   362.406     0.150
    28.922   360.719     0.150
    28.922   359.502     0.150
    28.955   362.500     0.150
    28.954   362.232     0.150
    28.981   360.209     0.150
    29.081   362.180     0.150
    29.161   362.180     0.150
    29.123   364.000     0.150
    29.129   365.031     0.150
    29.138   363.834     0.150
    29.218   365.842     0.150
    29.238   363.299     0.150
    29.230   363.957     0.150
    29.341   364.289     0.150
    29.307   365.299     0.150
    29.339   365.199     0.150
    29.310   364.311     0.150
    29.310   364.061     0.150
    29.310   363.480     0.150
    29.333   366.551     0.150
    29.382   365.789     0.150
    29.382   364.719     0.150
    29.382   366.600     0.150
    29.511   364.979     0.150
    29.614   366.012     0.150
    29.644   369.375     0.150
    29.641   366.430     0.150
    29.556   369.199     0.150
    29.842   370.174     0.150
    29.844   369.014     0.150
    29.938   370.299     0.150
    29.959   369.799     0.150
    29.933   371.506     0.150
    29.929   369.406     0.150
    30.083   370.166     0.150
    30.087   372.590     0.150
    30.277   373.000     0.150
    30.260   373.900     0.150
    30.277   371.789     0.150
    30.279   372.619     0.150
    30.279   373.877     0.150
    30.273   371.859     0.150
    30.273   371.688     0.150
    30.279   373.773     0.150
    30.391   373.900     0.150
    30.331   371.383     0.150
    30.373   375.000     0.150
    30.384   372.877     0.150
    30.400   373.035     0.150
    30.497   373.393     0.150
    30.563   377.699     0.150
    30.575   374.711     0.150
    30.677   376.900     0.150
    30.738   377.951     0.150
    30.742   376.752     0.150
    30.779   377.191     0.150
    30.802   376.889     0.150
    30.809   376.418     0.150
    30.851   377.312     0.150
    30.928   378.639     0.150
    30.928   438.869     0.150
    30.928   683.389     0.150
    30.928   783.820     0.150
    30.893   377.830     0.150
    30.893   379.453     0.150
    30.905   377.504     0.150
    30.918   380.299     0.150
    30.968   375.100     0.150
    30.964   379.434     0.150
    30.967   379.316     0.150
    31.000   378.969     0.150
    31.000   378.547     0.150
    31.023   378.828     0.150
    31.039   380.400     0.150
    31.040   378.229     0.150
    31.082   380.699     0.150
    31.116   379.428     0.150
    31.161   381.699     0.150
    31.139   380.371     0.150
    31.148   380.311     0.150
    31.150   379.504     0.150
    31.162   380.434     0.150
    31.212   380.301     0.150
    31.212   380.520     0.150
    31.212   379.369     0.150
    31.184   383.299     0.150
    31.208   382.000     0.150
    31.226   382.627     0.150
    31.210   379.730     0.150
    31.264   381.266     0.150
    31.302   381.598     0.150
    31.303   382.043     0.150
    31.330   381.535     0.150
    31.413   384.590     0.150
    31.402   381.420     0.150
    31.436   381.260     0.150
    31.516   385.312     0.150
    31.515   384.494     0.150
    31.526   382.207     0.150
    31.582   385.600     0.150
    31.606   383.438     0.150
    31.652   384.549     0.150
    31.647   384.400     0.150
    31.647   383.051     0.150
    31.691   387.602     0.150
    31.799   386.070     0.150
    31.799   387.799     0.150
    31.896   386.025     0.150
    31.867   386.172     0.150
    31.974   386.506     0.150
    32.075   390.604     0.150
    32.128   389.299     0.150
    32.187   388.156     0.150
    32.219   391.090     0.150
    32.257   389.055     0.150
    32.257   388.689     0.150
    32.261   392.145     0.150
    32.278   392.010     0.150
    32.315   392.830     0.150
    32.356   389.045     0.150
    32.356   389.709     0.150
    32.380   391.100     0.150
    32.415   391.209     0.150
    32.415   391.320     0.150
    32.415   392.100     0.150
    32.430   389.984     0.150
    32.450   393.170     0.150
    32.450   393.799     0.150
    32.453   393.479     0.150
    32.503   393.180     0.150
    32.503   394.199     0.150
    32.482   391.633     0.150
    32.503   393.547     0.150
    32.542   391.033     0.150
    32.632   392.871     0.150
    32.714   391.799     0.150
    32.714   461.199     0.150
    32.717   392.785     0.150
    32.732   393.670     0.150
    32.979   395.799     0.150
    33.012   397.889     0.150
    33.138   396.457     0.150
    33.146   396.006     0.150
    33.160   396.797     0.150
    33.162   396.738     0.150
    33.181   395.930     0.150
    33.181   396.154     0.150
    33.256   397.549     0.150
    33.256   397.850     0.150
    33.273   397.150     0.150
    33.372   399.789     0.150
    33.372   398.719     0.150
    33.372     3.100     0.150
    33.344   398.264     0.150
    33.439   399.080     0.150
    33.474   399.830     0.150
    33.523   403.580     0.150
    33.538   402.760     0.150
    33.538   403.400     0.150
    33.626   399.508     0.150
    33.626   399.830     0.150
    33.570   400.730     0.150
    33.583   401.199     0.150
    33.812   404.949     0.150
    33.812   405.350     0.150
    33.900   405.225     0.150
    33.900   561.199     0.150
    33.850   405.400     0.150
    33.850   404.160     0.150
    33.850   404.480     0.150
    33.897   405.600     0.150
    33.996   406.299     0.150
    34.011   405.670     0.150
    34.004   405.240     0.150
    34.004   405.359     0.150
    34.161   407.129     0.150
    34.283   408.457     0.150
    34.283   409.369     0.150
    34.283   407.379     0.150
    34.283   406.400     0.150
    34.210   406.699     0.150
    34.224   408.600     0.150
    34.305   410.100     0.150
    34.383   408.699     0.150
    34.485   410.699     0.150
    34.533   410.920     0.150
    34.585   409.900     0.150
    34.635   411.410     0.150
    34.666   409.799     0.150
    34.791   411.100     0.150
    34.791  1033.400     0.150
    34.728   409.570     0.150
    34.797   413.119     0.150
    34.887   413.279     0.150
    34.882   413.400     0.150
    34.895   414.180     0.150
    34.895   414.500     0.150
    34.902   412.639     0.150
    34.904   413.900     0.150
    35.022   413.100     0.150
    35.062   414.100     0.150
    35.159   414.400     0.150
    35.098   416.469     0.150
    35.180   414.660     0.150
    35.159   413.500     0.150
    35.247   415.980     0.150
    35.261   417.100     0.150
    35.425   417.600     0.150
    35.425   416.879     0.150
    35.431   416.699     0.150
    35.438   416.799     0.150
    35.500   418.760     0.150
    35.500   417.750     0.150
    35.500   418.299     0.150
    35.500   420.199     0.150
    35.510   417.100     0.150
    35.516   417.799     0.150
    35.558   420.699     0.150
    35.640   419.689     0.150
    35.640   421.100     0.150
    35.705   419.500     0.150
    35.869   421.834     0.150
    35.869   421.699     0.150
    35.839   422.730     0.150
    35.839   420.770     0.150
    35.905   421.900     0.150
    35.965   421.400     0.150
    36.017   421.660     0.150
    36.017   421.389     0.150
    36.063   422.900     0.150
    36.059   421.770     0.150
    36.168   424.469     0.150
    36.194   425.420     0.150
    36.194   425.900     0.150
    36.241   425.111     0.150
    36.368   424.154     0.150
    36.368   424.379     0.150
    36.368     4.141     0.150
    36.372   424.170     0.150
    36.398   424.900     0.150
    36.402   425.660     0.150
    36.364   427.209     0.150
    36.421   426.645     0.150
    36.498   428.420     0.150
    36.498   427.080     0.150
    36.498   428.000     0.150
    36.563   425.785     0.150
    36.563   425.850     0.150
    36.563   569.840     0.150
    36.563   425.959     0.150
    36.577   426.400     0.150
    36.596   426.500     0.150
    36.549   428.414     0.150
    36.585   427.920     0.150
    36.585   429.240     0.150
    36.593   428.469     0.150
    36.593   429.400     0.150
    36.672   427.250     0.150
    36.647   427.570     0.150
    36.761   428.117     0.150
    36.761   428.410     0.150
    36.761   427.439     0.150
    36.761   430.000     0.150
    36.737   428.490     0.150
    36.737   428.199     0.150
    36.737   429.252     0.150
    36.734   428.639     0.150
    36.773   429.670     0.150
    36.761   429.529     0.150
    36.761   428.199     0.150
    36.815   427.500     0.150
    36.852   428.719     0.150
    36.892   430.521     0.150
    37.049   572.322     0.150
    37.327   433.150     0.150
    37.378   434.000     0.150
    37.378   434.902     0.150
    37.383   434.711     0.150
    37.528   435.199     0.150
    37.528   434.330     0.150
    37.528   434.900     0.150
    37.528   435.699     0.150
    37.593   435.379     0.150
    37.617   435.799     0.150
    37.617   436.482     0.150
    37.632   436.219     0.150
    37.632   436.000     0.150
    37.670   436.680     0.150
    37.944   439.020     0.150
    37.919   438.930     0.150
    38.020   439.799     0.150
    37.974   438.480     0.150
    38.002   438.949     0.150
    37.995   438.879     0.150
    38.006   441.037     0.150
    38.006   576.594     0.150
    38.032   439.289     0.150
    38.032   439.449     0.150
    38.033   440.168     0.150
    38.038   440.379     0.150
    38.047   441.324     0.150
    38.047   439.461     0.150
    38.047   530.758     0.150
    38.047   575.150     0.150
    38.047   440.750     0.150
    38.057   439.230     0.150
    38.066   438.549     0.150
    38.094   440.160     0.150
    38.147   440.029     0.150
    38.147   440.900     0.150
    38.184   441.350     0.150
    38.216   441.119     0.150
    38.216   442.928     0.150
    38.274   442.039     0.150
    38.337   443.688     0.150
    38.337   443.240     0.150
    38.337   442.209     0.150
    38.371   442.789     0.150
    38.371   443.965     0.150
    38.501   442.699     0.150
    38.462   442.869     0.150
    38.509   442.289     0.150
    38.606   445.000     0.150
    38.677   445.244     0.150
    38.703   446.770     0.150
    38.703   446.100     0.150
    38.703   536.600     0.150
    38.703   577.900     0.150
    38.758   446.549     0.150
    38.784   446.129     0.150
    38.836   445.689     0.150
    38.836   445.580     0.150
    38.907   447.359     0.150
    38.920   446.859     0.150
    38.957   448.430     0.150
    38.962   448.879     0.150
    39.090   447.219     0.150
    39.090   446.750     0.150
    39.063   447.389     0.150
    39.080   450.061     0.150
    38.924   448.150     0.150
    38.924   447.859     0.150
    39.218   448.963     0.150
    39.218   448.820     0.150
    39.158   449.240     0.150
    39.277   448.799     0.150
    39.384   450.990     0.150
    39.384   578.160     0.150
    39.390   450.469     0.150
    39.420   452.920     0.150
    39.438   450.490     0.150
    39.424   451.803     0.150
    39.424   576.824     0.150
    39.445   452.119     0.150
    39.461   452.490     0.150
    39.490   452.879     0.150
    39.490   452.510     0.150
    39.518   452.750     0.150
    39.583   453.639     0.150
    39.657   454.350     0.150
    39.655   455.260     0.150
    39.687   455.650     0.150
    39.675   579.494     0.150
    39.715   455.539     0.150
    39.715   455.836     0.150
    39.746   453.432     0.150
    39.746   579.979     0.150
    39.801   453.549     0.150
    39.820   455.500     0.150
    39.816   454.369     0.150
    39.899   455.219     0.150
    40.050   456.109     0.150
    40.050   455.510     0.150
    40.050   457.160     0.150
    39.977   455.418     0.150
    40.020   455.699     0.150
    40.020   455.920     0.150
    40.020   456.180     0.150
    40.020   456.410     0.150
    40.005   455.920     0.150
    40.005   581.787     0.150
    40.067   456.520     0.150
    40.121   456.975     0.150
    40.225   459.109     0.150
    40.225   459.338     0.150
    40.227   460.299     0.150
    40.264   458.100     0.150
    40.264   458.174     0.150
    40.264   549.850     0.150
    40.264   457.939     0.150
    40.272   458.199     0.150
    40.312   458.709     0.150
    40.334   458.770     0.150
    40.386   459.549     0.150
    40.418   460.031     0.150
    40.418   459.080     0.150
    40.579   459.660     0.150
    40.579   460.518     0.150
    40.579   582.975     0.150
    40.644   461.320     0.150
    40.605   460.039     0.150
    40.621   463.230     0.150
    40.627   462.100     0.150
    40.627   463.207     0.150
    40.806   461.660     0.150
    40.881   465.389     0.150
    40.972   463.811     0.150
    41.062   463.625     0.150
    41.062   463.480     0.150
    40.993   463.990     0.150
    41.022   464.080     0.150
    41.022   465.697     0.150
    41.077   467.260     0.150
    41.210   466.600     0.150
    41.212   464.930     0.150
    41.212   465.100     0.150
    41.232   468.680     0.150
    41.285   466.400     0.150
    41.316   467.000     0.150
    41.359   467.299     0.150
    41.405   465.789     0.150
    41.449   469.000     0.150
    41.521   468.109     0.150
    41.532   468.230     0.150
    41.523   470.799     0.150
    41.523   470.490     0.150
    41.553   468.199     0.150
    41.553   467.600     0.150
    41.553   468.900     0.150
    41.553   467.424     0.150
    41.553   566.422     0.150
    41.588   468.389     0.150
    41.601   469.859     0.150
    41.602   469.186     0.150
    41.602   469.459     0.150
    41.602   468.980     0.150
    41.602   469.799     0.150
    41.619   469.879     0.150
    41.619   469.600     0.150
    41.792   469.350     0.150
    41.792   469.580     0.150
    41.742   469.879     0.150
    41.742   469.689     0.150
    41.869   469.980     0.150
    41.990   473.900     0.150
    42.027   474.189     0.150
    42.027   474.438     0.150
    42.236   475.000     0.150
    42.290   475.699     0.150
    42.273   473.600     0.150
    42.296   475.449     0.150
    42.376   474.811     0.150
    42.387   476.598     0.150
    42.387   474.639     0.150
    42.387   475.510     0.150
    42.387   475.799     0.150
    42.392   474.980     0.150
    42.404   476.889     0.150
    42.528   475.939     0.150
    42.463   477.363     0.150
    42.463   476.576     0.150
    42.463   589.537     0.150
    42.463   475.699     0.150
    42.463   478.400     0.150
    42.463   477.799     0.150
    42.463   477.588     0.150
    42.616   476.400     0.150
    42.555   475.799     0.150
    42.580   477.350     0.150
    42.580   477.725     0.150
    42.785   477.949     0.150
    42.771   478.020     0.150
    42.878   481.158     0.150
    42.878   478.510     0.150
    42.798   480.299     0.150
    42.798   589.799     0.150
    43.006   482.529     0.150
    43.006   480.990     0.150
    43.006   481.320     0.150
    43.006   482.920     0.150
    43.086   482.150     0.150
    43.086   481.820     0.150
    43.133   481.670     0.150
    43.110   481.369     0.150
    43.110   480.930     0.150
    43.110   481.740     0.150
    43.598   484.799     0.150
    43.598   875.000     0.150
    43.592   590.279     0.150
    43.592   485.889     0.150
    43.923   487.500     0.150
    43.884   489.000     0.150
    43.921   488.840     0.150
    44.032   490.150     0.150
    44.093   488.779     0.150
    44.130   490.939     0.150
    44.187   490.920     0.150
    44.187   590.439     0.150
    44.299   492.225     0.150
    44.299   595.199     0.150
    44.308   491.764     0.150
    44.308   490.910     0.150
    44.457   492.600     0.150
    44.417   491.020     0.150
    44.417   491.199     0.150
    44.417   492.100     0.150
    44.417   491.840     0.150
    44.672   493.459     0.150
    44.850   494.289     0.150
    44.850   493.779     0.150
    45.050   496.199     0.150
    45.050   496.010     0.150
    45.220   496.830     0.150
    45.528   499.770     0.150
    45.528   500.049     0.150
    45.650   501.703     0.150
    45.650   501.270     0.150
    45.650   501.430     0.150
    45.650   502.699     0.150
    46.021   504.500     0.150
    46.021   907.799     0.150
    46.035   503.439     0.150
    46.033   503.400     0.150
    46.191   506.219     0.150
    46.357   506.750     0.150
    46.811   508.500     0.150
    46.811   508.629     0.150
    46.936   511.600     0.150
    46.936   511.840     0.150
    46.995   510.844     0.150
    46.995   510.650     0.150
    47.035   513.406     0.150
    47.035   511.889     0.150
    47.055   512.000     0.150
    47.028   513.100     0.150
    47.160   514.100     0.150
    47.244   514.799     0.150
    47.190   512.959     0.150
    47.433   515.680     0.150
    47.477   515.449     0.150
    47.558   516.840     0.150
    47.558   516.080     0.150
    47.674   517.160     0.150
    47.715   518.137     0.150
    47.820   519.521     0.150
    47.820   519.139     0.150
    47.820   517.969     0.150
    47.766   518.410     0.150
    47.766   517.949     0.150
    47.831   518.570     0.150
    47.843   518.561     0.150
    47.931   519.750     0.150
    48.160   521.410     0.150
    48.268   522.070     0.150
    48.285   521.680     0.150
    48.309   522.459     0.150
    48.467   523.619     0.150
    48.494   523.324     0.150
    48.505   525.070     0.150
    48.505   524.939     0.150
    48.499   523.410     0.150
    48.521   524.230     0.150
    48.521   525.080     0.150
    48.521   523.799     0.150
    48.521   524.629     0.150
    48.521   525.699     0.150
    48.521   525.459     0.150
    48.521     3.102     0.150
    48.531   523.469     0.150
    48.551   524.889     0.150
    48.696   525.000     0.150
    48.674   525.000     0.150
    48.692   525.910     0.150
    48.871   526.971     0.150
    48.871   525.949     0.150
    48.871   527.490     0.150
    48.871   527.299     0.150
    48.871     4.291     0.150
    48.871   527.119     0.150
    48.939   526.400     0.150
    48.938   526.850     0.150
    48.976   527.920     0.150
    49.166   528.799     0.150
    49.114   528.109     0.150
    49.119   528.820     0.150
    49.252   529.000     0.150
    49.190   529.209     0.150
    49.194   528.855     0.150
    49.298   529.850     0.150
    49.306   529.459     0.150
    49.421   530.699     0.150
    49.489   531.320     0.150
    49.720   532.182     0.150
    49.720   532.900     0.150
    49.720   532.500     0.150
    49.720   613.600     0.150
    49.720   647.299     0.150
    49.720   959.000     0.150
    49.720   976.799     0.150
    49.720  1121.199     0.150
    49.720  1173.000     0.150
    49.772   534.240     0.150
    49.911   535.199     0.150
    50.260   536.311     0.150
    50.260   536.439     0.150
    50.260   536.840     0.150
    50.260   536.699     0.150
    50.204   536.850     0.150
    50.280   537.859     0.150
    50.280   537.410     0.150
    50.312   537.818     0.150
    50.312   538.170     0.150
    50.312   537.459     0.150
    50.441   539.889     0.150
    50.441   538.199     0.150
    50.558   540.699     0.150
    50.558   539.570     0.150
    50.874   540.408     0.150
    50.874   540.180     0.150
    50.874   540.020     0.150
    50.915   542.939     0.150
    50.915   542.600     0.150
    50.915   541.799     0.150
    51.000   544.039     0.150
    51.000   543.000     0.150
    51.426   547.070     0.150
    51.426   545.150     0.150
    51.426   545.600     0.150
    51.602   547.799     0.150
    51.682   548.400     0.150
    51.711   548.600     0.150
    51.734   548.500     0.150
    51.720   547.750     0.150
    51.722   547.250     0.150
    51.722   621.541     0.150
    51.722   547.420     0.150
    51.921   551.250     0.150
    51.921   551.139     0.150
    51.935   551.057     0.150
    51.935   551.230     0.150
    51.935   549.959     0.150
    51.935   549.400     0.150
    51.973   551.119     0.150
    51.973   549.969     0.150
    51.973   549.199     0.150
    51.973   549.699     0.150
    52.044   550.100     0.150
    52.044   549.678     0.150
    52.200   552.000     0.150
    52.326   552.076     0.150
    52.326   551.920     0.150
    52.326   551.650     0.150
    52.329   553.857     0.150
    52.329   553.549     0.150
    52.329   552.789     0.150
    52.386   552.611     0.150
    52.386   552.230     0.150
    52.386   552.350     0.150
    52.313   552.199     0.150
    52.400   552.900     0.150
    52.404   552.900     0.150
    52.386   553.199     0.150
    52.397   552.199     0.150
    52.955   556.510     0.150
    53.095   560.262     0.150
    53.095   559.299     0.150
    53.430   560.600     0.150
    53.432   560.020     0.150
    53.432   560.699     0.150
    53.433   560.199     0.150
    53.433   559.670     0.150
    53.445   560.699     0.150
    54.137   565.779     0.150
    54.137   566.510     0.150
    54.286   566.959     0.150
    54.425   567.502     0.150
    54.425   568.400     0.150
    54.401   568.719     0.150
    54.515   569.543     0.150
    54.515   569.719     0.150
    54.460   567.629     0.150
    54.554   568.619     0.150
    54.555   568.840     0.150
    54.587   568.379     0.150
    54.725   570.199     0.150
    54.881   570.330     0.150
    54.887   570.689     0.150
    55.182   573.904     0.150
    55.182   573.730     0.150
    55.182   572.869     0.150
    55.182   574.500     0.150
    55.225   573.475     0.150
    55.225   572.949     0.150
    55.454   574.990     0.150
    55.772   579.219     0.150
    55.772   576.939     0.150
    55.772   579.859     0.150
    55.774   578.619     0.150
    55.776   578.109     0.150
    55.816   579.521     0.150
    55.816   577.570     0.150
    56.174   581.830     0.150
    56.149   580.904     0.150
    56.149   581.070     0.150
    56.149   579.869     0.150
    56.462   583.156     0.150
    56.462   583.570     0.150
    56.462   581.959     0.150
    56.452   584.049     0.150
    56.452   584.299     0.150
    56.452   583.629     0.150
    56.452   583.100     0.150
    56.461   582.299     0.150
    56.461   582.789     0.150
    56.630   583.117     0.150
    56.630   582.980     0.150
    57.264   587.549     0.150
    57.264   587.949     0.150
    57.264   589.189     0.150
    58.201   594.432     0.150
    58.201   593.850     0.150
    58.201   592.619     0.150
    58.260   596.645     0.150
    58.512   598.400     0.150
    59.125   601.459     0.150
    59.125   602.230     0.150
    59.125   601.760     0.150
    59.821   606.500     0.150
    59.821  1099.500     0.150
    59.821   606.277     0.150
    59.964   607.500     0.150
    60.014   607.697     0.150
    60.014   607.520     0.150
    60.014   607.400     0.150
    59.994   607.809     0.150
    59.994   608.090     0.150
    59.994   608.939     0.150
    60.170   608.770     0.150
    60.170   608.990     0.150
    60.267   610.799     0.150
    60.267   610.256     0.150
    60.267   609.230     0.150
    60.342   610.199     0.150
    60.342   610.910     0.150
    60.436   609.676     0.150
    60.436   609.510     0.150
    60.436   610.420     0.150
    60.438   609.953     0.150
    60.438   609.430     0.150
    60.882   612.797     0.150
    60.882   612.500     0.150
    60.882   612.689     0.150
    61.871   620.219     0.150
    62.032   618.949     0.150
    62.540   624.799     0.150
    62.750   625.750     0.150
    62.750   625.910     0.150
    62.750   626.330     0.150
    62.810   626.740     0.150
    62.810   626.209     0.150
    63.446   631.900     0.150
    63.446   630.820     0.150
    63.446   631.209     0.150
    64.048   634.379     0.150
    64.048   634.170     0.150
    64.048   633.980     0.150
    64.048   634.500     0.150
    64.003   635.270     0.150
    64.003   634.240     0.150
    64.156   636.699     0.150
    64.156   635.760     0.150
    64.477   637.150     0.150
    64.616   638.219     0.150
    64.573   637.359     0.150
    65.009   641.660     0.150
    65.580   643.879     0.150
    65.725   646.209     0.150
    66.303   649.299     0.150
    66.303   649.500     0.150
    66.303   647.924     0.150
    66.303   648.049     0.150
    66.316   649.400     0.150
    66.383   650.189     0.150
    66.669   652.473     0.150
    66.669   651.670     0.150
    66.856   653.000     0.150
    66.936   652.199     0.150
    67.132   654.076     0.150
    67.132   653.869     0.150
    67.190   654.359     0.150
    67.190   654.574     0.150
    67.936   658.850     0.150
    67.936   659.650     0.150
    68.047   662.490     0.150
    68.193   660.178     0.150
    68.173   661.211     0.150
    68.173   661.600     0.150
    68.173   661.340     0.150
    68.173   661.959     0.150
    68.528   663.590     0.150
    68.636   663.756     0.150
    68.636   664.279     0.150
    69.030   667.119     0.150
    69.473   668.094     0.150
    69.473   669.109     0.150
    70.076   671.389     0.150
    70.076   671.859     0.150
    70.081   671.479     0.150
    70.081   671.240     0.150
    70.081   672.900     0.150
    70.359   675.830     0.150
    71.085   679.699     0.150
    71.085   680.854     0.150
    71.849   683.799     0.150
    71.854   682.609     0.150
    71.854   683.000     0.150
    71.854   682.449     0.150
    72.473   688.238     0.150
    72.473   687.840     0.150
    72.473   688.609     0.150
    72.818   689.189     0.150
    73.142   691.750     0.150
    73.575   693.520     0.150
    73.598   693.469     0.150
    73.598   692.549     0.150
    74.381   700.635     0.150
    74.380   698.992     0.150
    74.374   698.467     0.150
    74.374   698.100     0.150
    74.675   700.311     0.150
    74.675   699.939     0.150
    74.908   704.299     0.150
    74.908   702.852     0.150
    75.372   705.059     0.150
    75.578   704.947     0.150
    75.578   705.500     0.150
    75.560   705.939     0.150
    75.560   705.730     0.150
    76.359   709.789     0.150
    76.651   711.350     0.150
    76.699   712.150     0.150
    76.699   711.670     0.150
    76.699   712.299     0.150
    77.080   714.609     0.150
    77.080   714.830     0.150
    77.080   714.299     0.150
    77.693   717.930     0.150
    78.038   718.771     0.150
    78.038   719.500     0.150
    78.087   719.275     0.150
    78.087   719.139     0.150
    78.087   719.900     0.150
    78.119   719.570     0.150
    78.062   721.064     0.150
    78.062   720.889     0.150
    78.062   719.740     0.150
    78.350   720.699     0.150
    78.691   723.289     0.150
    78.923   724.699     0.150
    79.000   724.980     0.150
    79.033   725.039     0.150
    79.235   725.350     0.150
    79.574   728.199     0.150
    80.043   729.695     0.150
    80.170   731.018     0.150
    80.629   734.109     0.150
    80.682   734.469     0.150
    80.743   733.621     0.150
    80.746   733.797     0.150
    80.746   733.969     0.150
    80.746   734.199     0.150
    80.823   734.600     0.150
    80.964   735.699     0.150
    81.150   736.369     0.150
    81.187   735.020     0.150
    81.187   734.900     0.150
    81.384   736.619     0.150
    81.384   736.139     0.150
    81.384   737.699     0.150
    81.431   737.779     0.150
    81.652   738.820     0.150
    81.670   738.309     0.150
    81.595   738.400     0.150
    81.595   740.949     0.150
    82.087   740.670     0.150
    82.178   741.600     0.150
    82.178   742.098     0.150
    82.178   741.789     0.150
    82.482   744.010     0.150
    82.912   744.320     0.150
    82.912   743.939     0.150
    83.084   747.145     0.150
    83.152   746.574     0.150
    83.160   746.801     0.150
    83.268   746.484     0.150
    83.331   746.377     0.150
    83.443   748.436     0.150
    83.443   748.119     0.150
    83.479   750.734     0.150
    83.625   748.221     0.150
    83.718   750.369     0.150
    83.875   749.270     0.150
    84.030   751.492     0.150
    84.030   750.660     0.150
    84.236   750.180     0.150
    84.850   754.469     0.150
    84.864   756.760     0.150
    84.864   755.549     0.150
    84.908   754.900     0.150
    84.908   753.826     0.150
    85.143   757.500     0.150
    85.830   759.100     0.150
    85.995   760.410     0.150
    86.254   761.227     0.150
    86.413   764.758     0.150
    86.449   763.025     0.150
    86.546   763.375     0.150
    86.546   763.129     0.150
    86.688   763.633     0.150
    87.177   767.170     0.150
    87.543   767.100     0.150
    87.543  2325.799     0.150
    87.702   768.604     0.150
    88.472   773.039     0.150
    89.521   777.361     0.150
    89.521   778.100     0.150
    89.521   777.049     0.150
    89.521  1074.982     0.150
    89.521   777.230     0.150
    89.553   778.299     0.150
    89.914   779.969     0.150
    89.914   779.230     0.150
    89.914   780.299     0.150
    90.042   780.324     0.150
    90.042   780.449     0.150
    90.042   780.600     0.150
    90.515   785.029     0.150
    90.768   783.762     0.150
    91.245   787.479     0.150
    91.785   788.969     0.150
    91.850   788.059     0.150
    92.395   792.150     0.150
    93.220   795.449     0.150
    93.220  1014.525     0.150
    93.220  1822.150     0.150
    93.220   795.600     0.150
    93.319   794.918     0.150
    93.358   795.539     0.150
    93.714   796.908     0.150
    94.061   798.949     0.150
    94.458   801.178     0.150
    95.039   803.570     0.150
    95.039   803.719     0.150
    95.073   804.090     0.150
    96.389   810.439     0.150
    96.451   810.633     0.150
    96.673   811.086     0.150
    96.675   810.211     0.150
    96.894   812.270     0.150
    97.361   815.707     0.150
    97.577   814.010     0.150
    97.770   817.389     0.150
    98.160   818.006     0.150
    98.408   819.549     0.150
    98.782   820.617     0.150
    98.907   821.289     0.150
    99.316   824.998     0.150
    99.387   822.959     0.150
    99.813   823.990     0.150
    99.861   824.076     0.150
    99.861  1094.412     0.150
    99.912   826.701     0.150
   100.568   829.736     0.150
   101.943   836.049     0.150
   101.943  1096.930     0.150
   102.110   835.525     0.150
   102.562   838.674     0.150
   102.562  1090.531     0.150
   102.769   837.645     0.150
   104.673  1101.100     0.150
   104.673  1107.699     0.150
   107.285   860.848     0.150
   107.285  1107.936     0.150
   107.285  1783.350     0.150
   109.919   873.041     0.150
   111.032  1112.699     0.150
   114.061  1118.506     0.150
   114.926  1122.574     0.150
   114.926  1180.574     0.150
   114.926  1758.375     0.150
   115.023  1181.170     0.150
   115.207  1121.012     0.150
   115.207  1756.229     0.150
   115.207  1121.510     0.150
   115.207  1120.369     0.150
   115.207  1756.416     0.150
   115.207  1121.299     0.150
   116.039  1121.928     0.150
   116.147  1755.113     0.150
   116.392  1123.449     0.150
   118.523  1130.445     0.150
   121.123  1131.494     0.150
   121.164  1133.600     0.150
   121.486  1134.619     0.150
   122.322  1136.330     0.150
   122.952  1134.900     0.150
   123.107  1139.100     0.150
   123.534  1137.699     0.150
   123.654  1138.473     0.150
   123.756  1139.359     0.150
   123.801  1138.645     0.150
   124.306  1138.000     0.150
   124.313  1139.730     0.150
   124.418  1138.199     0.150
   124.465  1138.145     0.150
   125.179  1142.010     0.150
   125.206  1141.629     0.150
   125.409  1142.613     0.150
   125.423  1140.893     0.150
   125.794  1141.812     0.150
   125.825  1139.549     0.150
   125.839  1143.430     0.150
   125.836  1138.900     0.150
   125.903  1140.750     0.150
   125.884  1143.330     0.150
   125.958  1142.561     0.150
   125.958  1254.240     0.150
   126.143  1143.139     0.150
   126.407  1143.279     0.150
   126.421  1140.930     0.150
   126.386  1142.100     0.150
   126.587  1140.473     0.150
   126.711  1144.145     0.150
   126.837  1145.039     0.150
   127.154  1144.219     0.150
   127.222  1144.939     0.150
   127.300  1146.020     0.150
   127.759  1146.219     0.150
   127.709  1145.574     0.150
   128.330  1147.162     0.150
   128.466  1147.689     0.150
   128.583  1148.699     0.150
   128.671  1145.805     0.150
   128.677  1147.023     0.150
   129.007  1148.232     0.150
   129.672  1153.057     0.150
   131.138  1152.990     0.150
   131.885  1155.549     0.150
   131.885  1154.275     0.150
   131.885  1294.949     0.150
   134.221  1161.420     0.150
   134.409  1160.010     0.150
   134.545  1160.900     0.150
   136.366  1162.881     0.150
   138.520  1165.984     0.150
   138.520  1334.695     0.150
   138.526  1168.025     0.150
   139.679  1170.869     0.150
   140.948  1173.150     0.150
   140.948  1177.199     0.150
   142.303  1169.650     0.150
   143.652  1172.299     0.150
   147.148  1185.381     0.150
   147.672  1185.574     0.150
     1.476    27.469     0.150
     1.476    27.309     0.150
     1.717    30.168     0.150
     1.717    30.549     0.150
     1.818    32.768     0.150
     1.818    33.697     0.150
     1.980    35.438     0.150
     2.364    39.867     0.150
     2.407    40.867     0.150
     2.588    43.469     0.150
     2.593    43.268     0.150
     2.742    45.168     0.150
     2.800    47.678     0.150
     3.016    49.268     0.150
     3.253    52.668     0.150
     3.587    56.568     0.150
     3.587    57.418     0.150
     3.841    61.969     0.150
     3.950    62.568     0.150
     3.950    62.748     0.150
     4.011    63.367     0.150
     4.143    65.398     0.150
     4.447    69.568     0.150
     4.508    70.418     0.150
     4.508    83.418     0.150
     4.508   120.617     0.150
     4.508   144.969     0.150
     4.488    69.568     0.150
     4.659    71.268     0.150
     4.685    72.168     0.150
     4.774    74.488     0.150
     5.228    79.168     0.150
     5.619    85.268     0.150
     5.619    85.568     0.150
     5.713    86.668     0.150
     5.838    86.998     0.150
     6.076    91.668     0.150
     6.189    93.129     0.150
     6.178    92.867     0.150
     6.263    93.768     0.150
     6.263    93.438     0.150
     6.413    92.648     0.150
     6.560    97.867     0.150
     7.095   104.438     0.150
     7.095   105.418     0.150
     7.159   106.918     0.150
     7.851   116.979     0.150
     8.845   129.049     0.150
     8.870   129.188     0.150
     8.870   128.418     0.150
     8.870   129.367     0.150
     9.213   133.389     0.150
     9.962   142.928     0.150
    10.607   151.379     0.150
    10.740   153.594     0.150
    10.740   269.348     0.150
    10.740   153.469     0.150
    11.085   158.117     0.150
    11.771   172.268     0.150
    12.077   169.707     0.150
    12.614   179.598     0.150
    12.614   178.338     0.150
    12.614   319.037     0.150
    12.614   177.287     0.150
    12.614   178.217     0.150
    12.614   319.789     0.150
    13.092   187.219     0.150
    14.060   198.867     0.150
    14.306   201.418     0.150
    14.306   200.639     0.150
    14.663   204.379     0.150
    14.663   205.268     0.150
    14.663   361.572     0.150
    14.663   205.639     0.150
    14.741   212.867     0.150
    14.897   208.738     0.150
    15.041   215.809     0.150
    15.817   221.117     0.150
    16.029   222.568     0.150
    16.029   394.117     0.150
    16.747   238.867     0.150
    17.243   244.469     0.150
    17.305   239.492     0.150
    17.305   245.367     0.150
    17.540   248.268     0.150
    17.818   251.568     0.150
    18.142   251.258     0.150
    19.315   264.693     0.150
    19.319   265.408     0.150
    19.359   264.768     0.150
    19.359   265.340     0.150
    19.535   267.918     0.150
    19.535   268.469     0.150
    19.535   267.219     0.150
    19.535   266.729     0.150
    19.535   268.668     0.150
    20.002   273.318     0.150
    20.108   275.979     0.150
    20.108   272.607     0.150
    20.108   275.451     0.150
    20.845   281.578     0.150
    20.883   281.549     0.150
    21.870   293.586     0.150
    21.870   292.707     0.150
    21.870   294.469     0.150
    21.870   312.867     0.150
    21.870   294.848     0.150
    21.862   294.768     0.150
    22.191   298.168     0.150
    22.679   300.498     0.150
    22.679   532.229     0.150
    22.679   551.037     0.150
    23.078   305.979     0.150
    23.078   308.469     0.150
    23.078   306.947     0.150
    23.078   306.088     0.150
    23.078   308.367     0.150
    23.968   316.168     0.150
    25.092   325.643     0.150
    25.145   324.879     0.150
    28.621   357.223     0.150
    28.621   358.367     0.150
    30.386   375.168     0.150
    33.586   399.469     0.150
    34.160   406.598     0.150
    35.179   415.494     0.150
    36.560   426.662     0.150
    36.560   426.908     0.150
    38.048   440.904     0.150
    40.120   456.506     0.150
    40.262   456.666     0.150
    41.057   463.844     0.150
    41.552   468.469     0.150
    41.552   466.844     0.150
    41.558   468.479     0.150
    42.916   479.549     0.150
    44.418   491.219     0.150
    46.740   509.957     0.150
    48.287   521.537     0.150
    48.494   522.764     0.150
    51.724   548.418     0.150
    52.380   552.709     0.150
    54.139   565.068     0.150
    68.191   659.158     0.150
    76.439   709.838     0.150
    78.346   720.090     0.150
    78.563   721.258     0.150
    87.540   767.809     0.150
    89.519   777.867     0.150
    89.519   776.059     0.150
     1.405    25.920     0.150
     1.405    45.420     0.150
     1.636    28.920     0.150
     1.769    32.221     0.150
     1.769    32.340     0.150
     1.970    34.641     0.150
     2.225    38.619     0.150
     2.326    39.520     0.150
     2.288    39.119     0.150
     2.520    42.721     0.150
     2.528    42.721     0.150
     2.655    44.119     0.150
     2.766    46.500     0.150
     2.959    48.920     0.150
     3.195    52.420     0.150
     3.515    55.920     0.150
     3.794    60.820     0.150
     3.881    61.520     0.150
     3.881    61.840     0.150
     3.953    63.221     0.150
     4.054    75.670     0.150
     4.061    62.920     0.150
     4.399    68.721     0.150
     4.397    68.119     0.150
     4.596    70.221     0.150
     5.641    85.320     0.150
     5.698    86.420     0.150
     6.007    90.020     0.150
     6.092    91.820     0.150
     6.205    93.020     0.150
     6.205    92.609     0.150
     6.568    97.721     0.150
    10.806   154.602     0.150
    12.691   179.475     0.150
    14.674   207.514     0.150
    19.434   266.775     0.150
    19.611   268.512     0.150
     1.546    28.314     0.150
     1.546    48.412     0.150
     1.546    27.354     0.150
     1.765    31.014     0.150
     1.880    33.814     0.150
     2.019    35.842     0.150
     2.326    40.514     0.150
     2.454    41.713     0.150
     2.435    40.713     0.150
     2.629    44.412     0.150
     2.655    44.611     0.150
     3.082    50.412     0.150
     4.019    63.514     0.150
     4.076    64.814     0.150
     4.208    64.604     0.150
     4.567    69.264     0.150
     4.567   146.639     0.150
     4.837    73.771     0.150
     5.686    87.111     0.150
     5.686    86.635     0.150
     5.749    87.111     0.150
     5.825    88.111     0.150
     6.233    94.014     0.150
     6.284    94.412     0.150
     6.260    94.123     0.150
     6.452    92.053     0.150
     6.622    97.924     0.150
     6.703   100.514     0.150
     7.218   105.494     0.150
     7.916   115.791     0.150
     8.915   130.135     0.150
     8.827   128.271     0.150
     9.023   132.494     0.150
     9.926   143.072     0.150
    10.570   152.033     0.150
    10.712   154.283     0.150
    10.898   155.951     0.150
    12.574   178.432     0.150
    12.574   317.631     0.150
    12.574   178.213     0.150
    14.686   206.654     0.150
    14.686   207.584     0.150
    14.963   209.592     0.150
    15.836   221.252     0.150
    16.057   223.838     0.150
    17.605   244.252     0.150
    17.629   244.791     0.150
    18.212   251.502     0.150
    19.311   266.162     0.150
    19.978   273.912     0.150
    20.085   273.693     0.150
    28.683   357.564     0.150
    36.488   425.412     0.150
    41.028   462.662     0.150
    41.028   462.838     0.150
    51.794   548.014     0.150
    74.377   698.154     0.150
    76.350   708.463     0.150
    87.471   766.814     0.150
    89.450   776.162     0.150
    89.450   775.982     0.150
     1.447    26.473     0.150
     1.447    45.875     0.150
     1.675    29.676     0.150
     1.801    33.074     0.150
     1.801    33.266     0.150
     2.365    39.676     0.150
     2.332    39.875     0.150
     2.254    38.973     0.150
     2.554    43.074     0.150
     2.566    43.074     0.150
     2.791    46.883     0.150
     3.232    53.375     0.150
     3.548    56.875     0.150
     3.548    56.715     0.150
     3.922    61.676     0.150
     3.922    62.285     0.150
     4.101    76.062     0.150
     3.990    64.074     0.150
     4.494    68.875     0.150
     4.494   143.000     0.150
     4.755    73.703     0.150
     6.039    90.973     0.150
     6.230    93.176     0.150
     7.132   105.855     0.150
     8.911   129.965     0.150
    10.002   144.414     0.150
    10.647   151.652     0.150
    10.776   154.426     0.150
    10.981   156.344     0.150
    12.118   170.145     0.150
    12.655   178.668     0.150
    12.655   178.812     0.150
    13.471   190.453     0.150
    14.348   202.375     0.150
    14.676   207.902     0.150
    14.875   208.734     0.150
    16.040   224.398     0.150
    19.341   266.273     0.150
    19.346   264.684     0.150
    19.399   265.344     0.150
    19.575   267.000     0.150
    19.575   266.812     0.150
    20.037   273.500     0.150
    20.143   273.383     0.150
    21.883   292.844     0.150
    41.094   464.324     0.150
    51.696   546.223     0.150
    52.423   552.773     0.150
     1.468    27.500     0.150
     1.468    47.199     0.150
     1.716    30.199     0.150
     1.716    30.438     0.150
     1.810    32.699     0.150
     1.810    33.301     0.150
     1.973    34.918     0.150
     2.259    39.398     0.150
     2.405    40.801     0.150
     2.356    40.301     0.150
     2.593    43.801     0.150
     2.580    43.598     0.150
     2.792    46.961     0.150
     3.008    49.398     0.150
     3.245    53.098     0.150
     3.587    57.398     0.150
     3.587    57.500     0.150
     3.832    61.199     0.150
     3.942    61.699     0.150
     3.942    62.758     0.150
     4.139    65.180     0.150
     4.146    64.699     0.150
     4.483    68.898     0.150
     4.439    69.000     0.150
     4.500    68.926     0.150
     4.500   121.383     0.150
     4.500   145.500     0.150
     4.654    71.500     0.150
     4.681    72.398     0.150
     4.766    74.320     0.150
     5.713    86.199     0.150
     5.611    85.398     0.150
     5.611    85.758     0.150
     5.777    87.000     0.150
     5.844    86.840     0.150
     6.077    91.801     0.150
     6.266    93.000     0.150
     6.266    93.621     0.150
     6.181    93.160     0.150
     6.413    94.160     0.150
     7.094   105.141     0.150
     7.889   114.910     0.150
     8.185   121.000     0.150
     8.870   128.918     0.150
     8.870   128.539     0.150
     9.215   133.188     0.150
     9.707   139.551     0.150
     9.962   143.141     0.150
    10.364   145.180     0.150
    10.608   151.660     0.150
    10.738   154.039     0.150
    10.941   155.500     0.150
    10.993   157.469     0.150
    11.079   158.688     0.150
    11.325   163.000     0.150
    11.325   291.699     0.150
    11.773   168.801     0.150
    11.773   298.398     0.150
    12.078   171.688     0.150
    12.201   172.590     0.150
    12.615   179.301     0.150
    12.615   179.469     0.150
    12.615   319.668     0.150
    12.615   178.777     0.150
    12.615   179.770     0.150
    12.615   178.199     0.150
    12.615   178.590     0.150
    12.901   182.500     0.150
    12.978   183.168     0.150
    12.989   182.109     0.150
    13.094   187.051     0.150
    13.254   189.500     0.150
    13.254   338.801     0.150
    13.350   189.801     0.150
    13.350   339.699     0.150
    13.445   188.660     0.150
    13.746   195.898     0.150
    13.746   350.699     0.150
    13.898   196.668     0.150
    13.917   198.801     0.150
    13.917   354.898     0.150
    14.061   199.000     0.150
    14.307   202.359     0.150
    14.657   205.719     0.150
    14.657   205.609     0.150
    14.733   207.918     0.150
    14.733   208.379     0.150
    14.733   210.000     0.150
    14.889   212.039     0.150
    15.034   216.070     0.150
    15.371   217.219     0.150
    15.630   219.949     0.150
    15.663   221.059     0.150
    15.733   222.020     0.150
    16.307   229.641     0.150
    16.023   223.324     0.150
    16.023   392.348     0.150
    16.239   230.000     0.150
    16.286   229.059     0.150
    17.209   240.809     0.150
    17.296   242.898     0.150
    17.296   244.301     0.150
    17.342   241.820     0.150
    17.531   244.320     0.150
    17.531   245.598     0.150
    17.531   242.898     0.150
    17.555   243.598     0.150
    18.141   250.340     0.150
    18.141   251.188     0.150
    18.141   255.238     0.150
    18.165   252.480     0.150
    19.095   264.098     0.150
    19.311   266.598     0.150
    19.359   264.891     0.150
    19.359   265.059     0.150
    19.608   270.000     0.150
    19.536   267.598     0.150
    19.536   268.699     0.150
    19.536   268.723     0.150
    19.536   268.148     0.150
    20.000   274.449     0.150
    20.107   274.320     0.150
    20.107   274.500     0.150
    20.456   279.098     0.150
    21.062   284.270     0.150
    21.245   286.398     0.150
    21.308   287.289     0.150
    21.389   288.500     0.150
    21.849   294.000     0.150
    21.864   293.398     0.150
    21.864   294.492     0.150
    21.864   294.270     0.150
    21.864   294.098     0.150
    21.864   292.898     0.150
    21.864   294.371     0.150
    22.101   296.426     0.150
    22.481   300.500     0.150
    22.687   300.070     0.150
    22.687   532.570     0.150
    22.687   549.527     0.150
    23.067   307.199     0.150
    23.070   305.559     0.150
    23.070   307.199     0.150
    23.070   307.098     0.150
    23.070   307.648     0.150
    23.070   533.551     0.150
    23.070   305.898     0.150
    23.477   309.840     0.150
    23.601   314.629     0.150
    23.967   314.898     0.150
    25.151   324.871     0.150
    25.151   327.020     0.150
    25.090   325.301     0.150
    25.090   325.676     0.150
    25.090   325.270     0.150
    25.346   329.223     0.150
    26.913   344.500     0.150
    26.971   343.598     0.150
    28.613   357.801     0.150
    28.613   545.629     0.150
    28.613   357.020     0.150
    28.613   357.598     0.150
    28.613   356.398     0.150
    28.620   357.527     0.150
    28.620   357.770     0.150
    28.620   357.180     0.150
    28.620   357.328     0.150
    28.620     3.070     0.150
    28.748   358.598     0.150
    30.272   373.328     0.150
    30.389   374.898     0.150
    31.900   385.738     0.150
    32.372   390.699     0.150
    33.630   400.621     0.150
    33.843   404.648     0.150
    34.278   408.711     0.150
    34.895   413.520     0.150
    35.160   415.500     0.150
    35.171   415.539     0.150
    35.420   418.539     0.150
    35.420   417.168     0.150
    35.427   416.500     0.150
    35.427     3.301     0.150
    35.433   416.500     0.150
    35.864   420.199     0.150
    35.864   421.828     0.150
    36.372   425.098     0.150
    36.372     4.391     0.150
    36.376   425.109     0.150
    36.400   425.398     0.150
    36.567   425.320     0.150
    36.567   426.699     0.150
    36.567   568.648     0.150
    36.582   425.801     0.150
    36.600   425.699     0.150
    36.490   428.590     0.150
    36.730   427.668     0.150
    37.519   434.398     0.150
    38.040   440.973     0.150
    38.040   801.098     0.150
    38.210   441.680     0.150
    38.332   441.000     0.150
    38.915   445.770     0.150
    39.095   448.141     0.150
    39.095   446.168     0.150
    38.928   448.598     0.150
    38.928   448.039     0.150
    39.223   449.641     0.150
    39.810   453.301     0.150
    40.010   455.301     0.150
    40.112   456.988     0.150
    40.255   458.148     0.150
    40.255   457.391     0.150
    40.328   457.660     0.150
    40.411   458.570     0.150
    40.572   460.090     0.150
    41.056   462.648     0.150
    41.056   462.359     0.150
    41.512   468.070     0.150
    41.523   467.961     0.150
    41.550   468.500     0.150
    41.544   468.199     0.150
    41.544   468.250     0.150
    41.795   469.871     0.150
    41.795   469.418     0.150
    42.470   475.598     0.150
    42.381   475.598     0.150
    42.575   477.148     0.150
    42.791   478.418     0.150
    42.765   479.168     0.150
    43.117   481.641     0.150
    44.456   493.098     0.150
    44.410   491.988     0.150
    44.410   491.438     0.150
    44.410     3.418     0.150
    45.656   501.301     0.150
    46.351   507.020     0.150
    46.817   509.148     0.150
    47.001   511.680     0.150
    47.001   510.641     0.150
    47.242   513.801     0.150
    47.705   518.098     0.150
    48.279   521.949     0.150
    48.486   523.875     0.150
    48.691   524.598     0.150
    48.861   525.738     0.150
    49.161   529.598     0.150
    49.713   532.469     0.150
    49.713   532.598     0.150
    49.713   531.598     0.150
    50.252   536.801     0.150
    50.252   536.059     0.150
    50.252   536.199     0.150
    51.676   548.098     0.150
    51.706   548.398     0.150
    51.715   547.449     0.150
    51.716   548.223     0.150
    51.716   620.316     0.150
    51.716   547.461     0.150
    51.973   551.500     0.150
    52.038   549.898     0.150
    52.038   550.328     0.150
    52.106   551.043     0.150
    52.106   550.301     0.150
    52.383   552.410     0.150
    52.383   551.871     0.150
    52.397   552.398     0.150
    52.401   552.500     0.150
    52.383   553.348     0.150
    52.619   554.770     0.150
    53.429   560.148     0.150
    53.429   560.379     0.150
    54.131   565.188     0.150
    54.415   568.211     0.150
    54.550   567.898     0.150
    54.643   569.258     0.150
    55.065   572.801     0.150
    55.769   579.629     0.150
    56.172   581.270     0.150
    56.172   580.723     0.150
    56.443   584.371     0.150
    57.152   585.930     0.150
    57.259   587.320     0.150
    59.956   607.398     0.150
    59.956   607.098     0.150
    60.168   607.629     0.150
    60.435   609.863     0.150
    60.470   610.098     0.150
    60.878   612.551     0.150
    61.866   619.391     0.150
    63.430   630.125     0.150
    64.052   634.391     0.150
    64.052   633.238     0.150
    64.052   633.801     0.150
    66.309   649.000     0.150
    68.643   663.758     0.150
    69.477   668.738     0.150
    69.477   668.500     0.150
    70.085   672.430     0.150
    70.085   672.301     0.150
    71.861   682.926     0.150
    71.861   682.578     0.150
    72.113   685.578     0.150
    73.038   690.508     0.150
    73.603   692.570     0.150
    73.670   694.449     0.150
    73.976   695.789     0.150
    74.245   697.488     0.150
    74.329   698.098     0.150
    74.371   699.371     0.150
    74.635   699.398     0.150
    74.834   700.660     0.150
    75.059   702.891     0.150
    75.581   705.500     0.150
    75.581   704.840     0.150
    75.532   704.461     0.150
    75.959   707.238     0.150
    76.435   710.660     0.150
    76.475   711.711     0.150
    76.689   712.000     0.150
    77.280   716.051     0.150
    77.398   716.320     0.150
    77.450   716.820     0.150
    78.077   720.230     0.150
    78.077   720.000     0.150
    78.110   719.570     0.150
    78.182   720.578     0.150
    78.293   720.660     0.150
    78.341   720.949     0.150
    78.449   722.059     0.150
    78.559   722.621     0.150
    78.663   722.148     0.150
    79.000   724.879     0.150
    79.057   724.438     0.150
    79.239   726.289     0.150
    79.239   726.539     0.150
    79.632   728.090     0.150
    79.807   728.840     0.150
    79.859   728.660     0.150
    80.049   729.121     0.150
    79.956   728.719     0.150
    80.069   729.891     0.150
    80.302   731.379     0.150
    80.751   734.211     0.150
    80.693   733.949     0.150
    80.768   734.469     0.150
    80.814   733.559     0.150
    80.955   735.438     0.150
    80.955   735.199     0.150
    81.115   735.961     0.150
    81.141   736.438     0.150
    81.202   736.859     0.150
    81.556   738.289     0.150
    82.078   740.500     0.150
    83.013   745.688     0.150
    83.035   745.758     0.150
    83.143   746.926     0.150
    83.434   748.629     0.150
    83.434   748.344     0.150
    83.434   747.730     0.150
    83.527   747.770     0.150
    87.548   767.500     0.150
    88.086   770.809     0.150
    89.527   777.699     0.150
    89.527   776.801     0.150
   124.474  1138.910     0.150
   124.474  1136.969     0.150
     1.408    26.605     0.150
     1.408    26.875     0.150
     1.669    29.406     0.150
     1.669    29.793     0.150
     1.760    32.504     0.150
     1.760    32.863     0.150
     1.947    34.613     0.150
     2.213    38.605     0.150
     2.295    39.004     0.150
     2.359    40.105     0.150
     2.525    42.906     0.150
     2.555    42.906     0.150
     2.751    46.793     0.150
     2.954    48.703     0.150
     3.191    52.305     0.150
     3.550    56.504     0.150
     3.785    60.805     0.150
     3.883    61.504     0.150
     3.883    61.746     0.150
     3.949    63.305     0.150
     4.079    63.414     0.150
     4.086    63.605     0.150
     4.389    69.105     0.150
     4.453    69.281     0.150
     4.453   143.754     0.150
     4.421    68.203     0.150
     4.593    70.605     0.150
     4.624    71.004     0.150
     4.714    73.285     0.150
     5.177    78.203     0.150
     5.555    84.605     0.150
     5.676    85.504     0.150
     5.731    86.605     0.150
     5.907    85.883     0.150
     5.857    88.004     0.150
     6.042    90.906     0.150
     6.120    92.066     0.150
     6.123    92.406     0.150
     6.240    93.105     0.150
     6.374    92.676     0.150
     6.499    97.684     0.150
     6.600    99.203     0.150
     6.810   101.703     0.150
     6.925   103.805     0.150
     7.129   105.109     0.150
     7.129   184.289     0.150
     7.129   105.406     0.150
     7.100   105.406     0.150
     7.100   105.805     0.150
     7.257   107.406     0.150
     7.257   107.605     0.150
     7.223   107.406     0.150
     7.923   115.434     0.150
     7.786   116.246     0.150
     7.945   117.305     0.150
     8.122   119.504     0.150
     8.454   124.004     0.150
     8.589   126.305     0.150
     8.776   128.246     0.150
     8.746   128.844     0.150
     8.915   129.043     0.150
     8.881   130.375     0.150
     9.032   132.305     0.150
     9.264   134.176     0.150
     9.125   131.746     0.150
     9.264   134.805     0.150
     9.477   136.305     0.150
     9.477   139.965     0.150
     9.477   140.238     0.150
     9.739   140.316     0.150
     9.775   142.215     0.150
    10.001   143.105     0.150
     9.905   145.086     0.150
     9.961   145.551     0.150
    10.121   147.227     0.150
    10.648   151.734     0.150
    10.516   151.699     0.150
    10.770   154.230     0.150
    10.770   270.215     0.150
    10.770   153.926     0.150
    10.985   155.836     0.150
    10.870   157.586     0.150
    10.870   158.766     0.150
    10.870   156.645     0.150
    10.870   157.105     0.150
    10.870   157.973     0.150
    11.028   157.906     0.150
    11.077   158.219     0.150
    11.077   157.883     0.150
    11.162   161.906     0.150
    11.265   163.504     0.150
    11.265   291.504     0.150
    11.484   165.809     0.150
    11.513   167.184     0.150
    11.827   169.203     0.150
    11.827   299.605     0.150
    11.718   169.688     0.150
    11.746   169.766     0.150
    11.847   171.305     0.150
    12.122   171.234     0.150
    12.045   172.766     0.150
    12.242   172.426     0.150
    12.224   174.195     0.150
    12.284   173.539     0.150
    12.462   181.566     0.150
    12.657   179.156     0.150
    12.657   179.027     0.150
    12.657   179.297     0.150
    12.657   317.023     0.150
    12.657   179.879     0.150
    12.657   179.703     0.150
    12.569   180.184     0.150
    12.661   177.301     0.150
    12.695   180.160     0.150
    12.944   183.176     0.150
    13.019   183.484     0.150
    13.029   182.734     0.150
    13.143   185.363     0.150
    13.051   186.605     0.150
    13.197   190.004     0.150
    13.197   337.906     0.150
    13.294   190.406     0.150
    13.294   339.105     0.150
    13.475   190.105     0.150
    13.488   190.113     0.150
    13.547   191.254     0.150
    13.688   196.805     0.150
    13.688   350.305     0.150
    13.932   196.586     0.150
    13.857   198.906     0.150
    13.857   354.605     0.150
    14.108   198.504     0.150
    14.108   199.805     0.150
    14.062   200.094     0.150
    14.356   201.434     0.150
    14.356   201.574     0.150
    14.520   203.695     0.150
    14.645   204.754     0.150
    14.645   206.281     0.150
    14.645   363.074     0.150
    14.645   204.984     0.150
    14.674   212.586     0.150
    14.674   207.848     0.150
    14.674   206.824     0.150
    14.674   210.105     0.150
    14.674   213.000     0.150
    14.674   212.484     0.150
    14.834   209.684     0.150
    15.076   211.406     0.150
    14.972   214.926     0.150
    15.142   212.512     0.150
    15.142   211.754     0.150
    15.338   214.156     0.150
    15.315   217.434     0.150
    15.642   385.957     0.150
    15.569   221.043     0.150
    15.708   219.734     0.150
    15.686   220.305     0.150
    15.780   219.883     0.150
    15.701   221.754     0.150
    15.777   222.156     0.150
    15.752   225.145     0.150
    16.007   222.828     0.150
    16.007   395.906     0.150
    16.007   224.891     0.150
    16.007   396.520     0.150
    16.354   227.875     0.150
    16.163   225.660     0.150
    16.163   224.875     0.150
    16.327   227.855     0.150
    16.685   234.203     0.150
    17.229   239.695     0.150
    17.180   242.504     0.150
    17.243   240.254     0.150
    17.243   242.203     0.150
    17.243   239.906     0.150
    17.280   242.316     0.150
    17.404   243.004     0.150
    17.413   242.461     0.150
    17.472   243.379     0.150
    17.478   243.785     0.150
    17.478   244.211     0.150
    17.478   243.516     0.150
    17.478   245.203     0.150
    17.478   242.805     0.150
    17.478   244.910     0.150
    17.478   242.656     0.150
    17.499   246.105     0.150
    17.494   247.246     0.150
    17.984   250.441     0.150
    17.984   250.105     0.150
    18.137   251.941     0.150
    18.137   252.234     0.150
    18.091   251.250     0.150
    18.091   251.664     0.150
    18.091   250.625     0.150
    18.091   253.586     0.150
    18.185   253.773     0.150
    18.421   256.301     0.150
    18.843   262.227     0.150
    18.876   259.828     0.150
    19.158   264.406     0.150
    19.322   264.953     0.150
    19.326   265.934     0.150
    19.326   265.266     0.150
    19.228   267.586     0.150
    19.400   266.121     0.150
    19.400   265.586     0.150
    19.400   268.273     0.150
    19.400   268.125     0.150
    19.319   266.504     0.150
    19.331   266.914     0.150
    19.576   268.605     0.150
    19.576   271.141     0.150
    19.576   267.805     0.150
    19.576   268.305     0.150
    19.576   268.406     0.150
    19.576   267.746     0.150
    19.671   270.406     0.150
    19.659   270.406     0.150
    20.028   274.355     0.150
    20.135   276.086     0.150
    20.135   274.633     0.150
    20.135   276.203     0.150
    20.135   275.652     0.150
    20.519   278.703     0.150
    20.661   278.664     0.150
    20.776   282.656     0.150
    20.814   282.953     0.150
    20.898   285.105     0.150
    21.125   284.855     0.150
    21.308   288.203     0.150
    21.246   287.023     0.150
    21.430   288.305     0.150
    21.852   294.492     0.150
    21.852   293.156     0.150
    21.852   313.406     0.150
    21.852   565.406     0.150
    21.852   294.266     0.150
    21.914   294.266     0.150
    21.912   295.305     0.150
    22.039   295.605     0.150
    22.038   296.754     0.150
    22.177   297.703     0.150
    22.177   543.906     0.150
    22.544   301.305     0.150
    22.736   301.543     0.150
    22.736   533.434     0.150
    22.736   551.484     0.150
    22.762   305.168     0.150
    23.006   306.203     0.150
    23.009   307.695     0.150
    23.009   306.305     0.150
    23.009   306.203     0.150
    23.009   307.004     0.150
    23.009   308.348     0.150
    23.009   307.656     0.150
    23.009   306.414     0.150
    23.304   308.805     0.150
    23.304   309.406     0.150
    23.414   310.504     0.150
    23.557   310.605     0.150
    23.540   313.094     0.150
    23.567   312.703     0.150
    23.668   314.074     0.150
    23.668   313.305     0.150
    23.668   315.023     0.150
    24.006   316.805     0.150
    24.266   318.504     0.150
    25.119   325.883     0.150
    25.119   325.105     0.150
    25.119   325.906     0.150
    25.119   325.496     0.150
    25.119   325.805     0.150
    25.215   326.195     0.150
    25.215   327.465     0.150
    25.212   328.488     0.150
    25.323   328.805     0.150
    25.985   333.273     0.150
    26.809   342.406     0.150
    26.809   617.805     0.150
    26.876   344.105     0.150
    26.876   383.305     0.150
    26.932   342.305     0.150
    26.932   342.586     0.150
    26.932   342.406     0.150
    27.273   346.605     0.150
    27.743   349.445     0.150
    28.276   355.105     0.150
    28.521   357.004     0.150
    28.546   357.203     0.150
    28.563   357.230     0.150
    28.563   546.406     0.150
    28.563   356.906     0.150
    28.563   357.105     0.150
    28.563   357.406     0.150
    28.563   356.703     0.150
    28.570   357.355     0.150
    28.570   356.793     0.150
    28.570   357.184     0.150
    28.570     3.672     0.150
    28.570   357.703     0.150
    28.574   357.504     0.150
    28.621   357.906     0.150
    28.628   358.004     0.150
    28.644   358.105     0.150
    28.664   358.305     0.150
    28.699   358.605     0.150
    28.841   361.016     0.150
    28.841   359.906     0.150
    28.892   361.906     0.150
    29.074   362.715     0.150
    29.244   363.875     0.150
    29.244   363.105     0.150
    29.320   366.074     0.150
    29.320   363.934     0.150
    29.320   365.805     0.150
    29.475   366.496     0.150
    29.581   368.004     0.150
    29.780   369.191     0.150
    29.935   370.504     0.150
    30.005   370.734     0.150
    30.198   372.605     0.150
    30.215   371.836     0.150
    30.216   373.004     0.150
    30.216   373.414     0.150
    30.446   375.203     0.150
    30.677   377.750     0.150
    30.875   377.855     0.150
    30.875   437.727     0.150
    30.875   682.293     0.150
    30.875   782.336     0.150
    30.830   378.043     0.150
    30.830   378.789     0.150
    31.017   380.305     0.150
    31.192   381.109     0.150
    31.204   381.188     0.150
    31.263   381.066     0.150
    31.263   379.766     0.150
    31.239   381.625     0.150
    31.352   383.633     0.150
    31.452   383.199     0.150
    31.451   384.039     0.150
    31.485   384.305     0.150
    31.599   384.477     0.150
    31.737   386.395     0.150
    31.737   386.805     0.150
    32.067   389.383     0.150
    32.135   390.203     0.150
    32.279   391.805     0.150
    32.154   389.945     0.150
    32.215   390.980     0.150
    32.308   392.504     0.150
    32.290   388.844     0.150
    32.319   390.406     0.150
    32.352   391.664     0.150
    32.352   390.535     0.150
    32.352   392.004     0.150
    32.389   392.395     0.150
    32.389   392.703     0.150
    32.951   397.355     0.150
    33.145   400.406     0.150
    33.278   398.406     0.150
    33.319   398.184     0.150
    33.319   399.004     0.150
    33.410   399.496     0.150
    33.752   405.133     0.150
    33.788   403.906     0.150
    33.788   404.453     0.150
    33.788   403.543     0.150
    33.939   404.555     0.150
    33.939     3.199     0.150
    34.113   406.574     0.150
    34.470   409.445     0.150
    34.839   412.625     0.150
    35.135   415.004     0.150
    35.222   414.703     0.150
    35.298   416.875     0.150
    35.339   417.535     0.150
    35.468   418.684     0.150
    35.468   416.305     0.150
    35.475   416.605     0.150
    35.481   416.605     0.150
    35.436   419.316     0.150
    35.436   417.844     0.150
    35.580   419.586     0.150
    35.582   419.883     0.150
    35.582   420.504     0.150
    35.912   422.164     0.150
    35.912   422.605     0.150
    35.912   421.035     0.150
    35.912   422.004     0.150
    36.133   423.504     0.150
    36.179   424.414     0.150
    36.235   425.613     0.150
    36.435   425.266     0.150
    36.435   425.676     0.150
    36.439   425.316     0.150
    36.463   426.105     0.150
    36.438   427.305     0.150
    36.438   426.125     0.150
    36.488   426.531     0.150
    36.526   428.035     0.150
    36.534   428.453     0.150
    36.629   426.496     0.150
    36.629   427.305     0.150
    36.629   570.406     0.150
    36.629   426.836     0.150
    36.644   426.504     0.150
    36.662   426.703     0.150
    36.634   427.977     0.150
    36.727   428.855     0.150
    36.727   428.988     0.150
    36.727   428.043     0.150
    36.727   429.105     0.150
    36.675   427.727     0.150
    36.695   428.484     0.150
    36.695   427.965     0.150
    36.780   427.504     0.150
    36.814   429.633     0.150
    37.285   433.234     0.150
    37.320   433.797     0.150
    37.529   433.191     0.150
    37.529   433.816     0.150
    37.529   434.504     0.150
    37.529   436.504     0.150
    37.528   434.805     0.150
    37.908   439.273     0.150
    37.920   438.477     0.150
    37.969   439.215     0.150
    37.969   438.516     0.150
    37.986   438.879     0.150
    37.986   573.578     0.150
    38.007   438.094     0.150
    38.086   441.016     0.150
    38.202   441.883     0.150
    38.154   441.977     0.150
    38.154   440.793     0.150
    38.272   442.305     0.150
    38.272   443.273     0.150
    38.272   441.746     0.150
    38.272   441.605     0.150
    38.313   441.734     0.150
    38.395   442.625     0.150
    38.561   443.906     0.150
    38.561   443.633     0.150
    38.577   445.035     0.150
    38.541   444.594     0.150
    38.615   445.105     0.150
    38.722   445.652     0.150
    38.774   446.316     0.150
    38.843   446.543     0.150
    38.856   446.156     0.150
    38.902   448.785     0.150
    39.009   447.773     0.150
    39.058   448.773     0.150
    39.156   448.395     0.150
    39.156   447.863     0.150
    38.991   449.535     0.150
    38.991   448.855     0.150
    39.284   451.105     0.150
    39.321   449.730     0.150
    39.327   450.453     0.150
    39.383   452.113     0.150
    39.384   451.934     0.150
    39.402   452.684     0.150
    39.458   452.926     0.150
    39.522   452.113     0.150
    39.661   453.543     0.150
    39.747   454.254     0.150
    39.840   455.164     0.150
    39.865   455.465     0.150
    39.985   455.906     0.150
    39.985   456.406     0.150
    39.943   455.527     0.150
    40.030   456.664     0.150
    40.070   456.430     0.150
    40.229   458.336     0.150
    40.229   457.605     0.150
    40.229   458.355     0.150
    40.229   458.555     0.150
    40.236   457.605     0.150
    40.272   458.574     0.150
    40.272   458.766     0.150
    40.356   458.945     0.150
    40.522   460.523     0.150
    40.517   459.934     0.150
    40.570   461.926     0.150
    40.822   463.574     0.150
    40.909   464.613     0.150
    40.929   463.523     0.150
    40.961   464.227     0.150
    40.961   464.055     0.150
    41.088   464.805     0.150
    41.088   464.234     0.150
    41.008   464.156     0.150
    41.149   465.434     0.150
    41.248   466.605     0.150
    41.266   466.113     0.150
    41.266   466.305     0.150
    41.309   466.605     0.150
    41.424   468.344     0.150
    41.472   467.996     0.150
    41.483   468.227     0.150
    41.503   468.305     0.150
    41.503   467.805     0.150
    41.503   468.203     0.150
    41.492   468.184     0.150
    41.525   467.906     0.150
    41.540   467.875     0.150
    41.540   468.703     0.150
    41.540   469.105     0.150
    41.657   470.285     0.150
    41.717   470.633     0.150
    41.677   469.695     0.150
    41.677   469.355     0.150
    41.791   470.793     0.150
    41.858   470.414     0.150
    41.935   471.496     0.150
    41.939   472.004     0.150
    42.131   473.863     0.150
    42.162   474.094     0.150
    42.193   474.156     0.150
    42.220   474.586     0.150
    42.345   476.504     0.150
    42.326   474.953     0.150
    42.326   475.105     0.150
    42.330   474.863     0.150
    42.404   475.926     0.150
    42.368   475.203     0.150
    42.428   476.055     0.150
    42.435   475.906     0.150
    42.557   477.246     0.150
    42.516   476.594     0.150
    42.580   477.145     0.150
    42.513   476.680     0.150
    42.513   476.805     0.150
    42.513   478.129     0.150
    42.595   477.883     0.150
    42.707   478.516     0.150
    42.850   480.406     0.150
    42.850   479.543     0.150
    42.906   480.477     0.150
    43.039   480.133     0.150
    43.029   481.285     0.150
    43.085   482.004     0.150
    43.085   481.395     0.150
    43.085   481.105     0.150
    43.252   482.523     0.150
    43.532   486.227     0.150
    43.579   485.793     0.150
    43.857   488.094     0.150
    43.908   488.656     0.150
    44.047   489.926     0.150
    44.182   490.816     0.150
    44.350   491.293     0.150
    44.353   491.383     0.150
    44.353   491.145     0.150
    44.353     4.660     0.150
    44.513   493.906     0.150
    44.610   493.176     0.150
    45.463   500.043     0.150
    45.614   501.504     0.150
    45.614   502.547     0.150
    45.968   503.594     0.150
    46.293   506.863     0.150
    46.674   510.176     0.150
    47.058   512.355     0.150
    47.058   512.113     0.150
    47.126   512.793     0.150
    47.297   514.203     0.150
    47.415   515.344     0.150
    47.687   518.043     0.150
    47.687   518.203     0.150
    48.220   521.523     0.150
    48.438   523.629     0.150
    48.438   608.203     0.150
    48.436   524.016     0.150
    48.465   523.625     0.150
    48.843   527.543     0.150
    48.843   526.766     0.150
    48.843   527.383     0.150
    48.843   526.344     0.150
    48.843   527.906     0.150
    49.206   529.805     0.150
    49.245   529.664     0.150
    49.744   533.293     0.150
    49.744   532.203     0.150
    49.744   532.605     0.150
    49.744   610.305     0.150
    49.744   958.906     0.150
    49.744  1121.105     0.150
    49.744  1172.703     0.150
    50.270   537.273     0.150
    50.270   537.703     0.150
    50.270   537.125     0.150
    50.270     3.781     0.150
    50.247   537.184     0.150
    50.247   537.910     0.150
    50.354   538.355     0.150
    51.711   547.805     0.150
    51.617   547.805     0.150
    51.647   548.004     0.150
    51.656   547.836     0.150
    51.657   547.629     0.150
    51.657   547.734     0.150
    52.036   551.746     0.150
    52.036   549.703     0.150
    51.979   550.406     0.150
    51.979   550.164     0.150
    51.979   550.512     0.150
    51.979   549.836     0.150
    51.979     4.258     0.150
    52.151   551.805     0.150
    52.380   552.504     0.150
    52.439   553.516     0.150
    52.439   554.121     0.150
    52.439   553.074     0.150
    52.453   552.805     0.150
    52.457   552.805     0.150
    52.439   553.754     0.150
    52.559   554.566     0.150
    52.889   556.234     0.150
    53.042   558.246     0.150
    53.476   560.406     0.150
    53.478   560.336     0.150
    53.478   560.605     0.150
    53.478   560.781     0.150
    53.478   560.445     0.150
    53.490   560.504     0.150
    54.073   566.414     0.150
    54.073   566.133     0.150
    54.259   566.914     0.150
    54.392   568.145     0.150
    54.392   567.805     0.150
    54.584   569.234     0.150
    54.851   571.445     0.150
    55.006   572.625     0.150
    55.160   573.234     0.150
    55.160   573.559     0.150
    55.559   576.586     0.150
    56.405   582.504     0.150
    57.197   587.926     0.150
    58.198   594.883     0.150
    59.097   601.805     0.150
    59.097   602.555     0.150
    59.862   606.906     0.150
    59.862   606.754     0.150
    59.862   605.734     0.150
    59.984   608.105     0.150
    59.970   608.594     0.150
    59.970   607.355     0.150
    59.970   608.465     0.150
    60.066   608.363     0.150
    60.066   607.305     0.150
    60.305   610.203     0.150
    60.305   611.004     0.150
    60.305   610.805     0.150
    60.487   610.664     0.150
    60.487   610.434     0.150
    60.489   610.305     0.150
    60.929   613.434     0.150
    60.929   613.016     0.150
    63.458   631.504     0.150
    63.450   630.078     0.150
    63.458   631.305     0.150
    64.452   639.555     0.150
    66.334   648.504     0.150
    66.334   648.203     0.150
    66.334   648.773     0.150
    66.358   650.234     0.150
    66.629   651.234     0.150
    66.629   650.914     0.150
    67.890   659.875     0.150
    67.890   659.316     0.150
    68.030   661.836     0.150
    68.138   660.926     0.150
    68.138   661.555     0.150
    68.138   661.305     0.150
    68.612   664.301     0.150
    68.612   663.996     0.150
    68.612     2.980     0.150
    70.047   671.555     0.150
    71.831   682.680     0.150
    71.831   683.203     0.150
    73.047   690.914     0.150
    73.139   691.824     0.150
    73.684   694.066     0.150
    73.986   696.434     0.150
    74.250   697.895     0.150
    74.332   699.535     0.150
    74.377   699.801     0.150
    74.377   699.664     0.150
    74.369   698.715     0.150
    74.847   701.996     0.150
    75.065   703.766     0.150
    75.644   705.266     0.150
    75.969   707.555     0.150
    76.034   708.164     0.150
    76.445   710.375     0.150
    76.482   711.977     0.150
    76.514   712.145     0.150
    76.659   712.344     0.150
    76.690   712.484     0.150
    77.056   714.883     0.150
    77.202   714.324     0.150
    77.247   714.523     0.150
    77.798   718.094     0.150
    77.937   718.195     0.150
    78.085   720.316     0.150
    78.085   720.637     0.150
    78.085   719.246     0.150
    78.085   720.906     0.150
    78.349   720.855     0.150
    78.397   721.113     0.150
    79.244   726.676     0.150
    80.107   731.016     0.150
    80.107   730.086     0.150
    80.164   732.035     0.150
    80.164   730.664     0.150
    80.258   730.684     0.150
    80.773   734.145     0.150
    80.823   734.395     0.150
    80.811   734.164     0.150
    80.811   734.656     0.150
    81.567   738.266     0.150
    81.735   740.230     0.150
    83.135   746.805     0.150
    83.334   747.504     0.150
    83.448   749.043     0.150
    83.448   748.523     0.150
    83.448   748.414     0.150
    83.532   748.844     0.150
    86.711   764.930     0.150
    87.608   767.305     0.150
    87.767   769.480     0.150
    89.585   777.906     0.150
    89.585   778.203     0.150
    89.888   779.125     0.150
    92.657   793.465     0.150
    96.405   811.164     0.150
    97.434   814.496     0.150
    98.441   818.254     0.150
   114.895  1177.355     0.150
   115.201  1119.922     0.150
   115.201  1120.383     0.150
   124.480  1139.395     0.150
   124.480  1137.699     0.150
   127.647  1144.605     0.150
   127.647  1146.605     0.150
   131.819  1153.480     0.150
   131.819  1154.414     0.150
   142.250  1171.754     0.150
   142.250  1171.934     0.150
     1.486    26.746     0.150
     1.486    27.277     0.150
     1.702    29.848     0.150
     1.702    30.289     0.150
     1.702    51.148     0.150
     1.834    33.547     0.150
     2.003    34.586     0.150
     2.286    39.547     0.150
     2.392    40.547     0.150
     2.371    40.746     0.150
     2.574    43.047     0.150
     2.602    43.848     0.150
     2.820    47.020     0.150
     3.031    49.848     0.150
     3.267    54.449     0.150
     3.568    56.629     0.150
     3.960    61.848     0.150
     4.025    64.047     0.150
     4.137    64.316     0.150
     4.144    64.047     0.150
     4.464    70.047     0.150
     4.484    69.148     0.150
     4.526   146.621     0.150
     4.789    74.227     0.150
     5.214    79.047     0.150
     5.695    86.148     0.150
     5.632    85.746     0.150
     5.632    84.719     0.150
     5.763    87.047     0.150
     6.166    92.949     0.150
     6.242    93.348     0.150
     6.242    93.109     0.150
     6.197    92.797     0.150
     6.396    92.797     0.150
     6.638    99.348     0.150
     7.217   106.797     0.150
     7.846   115.168     0.150
    10.760   152.906     0.150
    14.688   207.586     0.150
    14.688   208.277     0.150
    16.054   224.023     0.150
    19.553   268.324     0.150
    19.407   269.938     0.150
    21.895   293.891     0.150
    21.895   293.117     0.150
    25.113   324.773     0.150
    35.514   419.637     0.150
    36.553   426.449     0.150
    41.077   463.773     0.150
    68.180   660.047     0.150
    74.400   699.367     0.150
    75.987   707.668     0.150
    79.660   728.656     0.150
    87.530   767.398     0.150
    87.530   767.859     0.150
    89.507   777.398     0.150
    89.507   777.168     0.150
     1.492    26.930     0.150
     1.492    47.727     0.150
     1.492    27.348     0.150
     1.651    28.930     0.150
     1.651    29.406     0.150
     1.861    33.527     0.150
     2.339    39.527     0.150
     2.316    40.430     0.150
     2.517    42.727     0.150
     2.618    44.129     0.150
     2.856    47.109     0.150
     3.050    50.727     0.150
     3.286    53.629     0.150
     3.510    56.129     0.150
     3.510    55.887     0.150
     3.968    62.578     0.150
     4.103    63.539     0.150
     4.110    63.930     0.150
     4.555    71.652     0.150
     4.555   146.352     0.150
     4.637    71.227     0.150
     4.812    73.180     0.150
     5.636    85.629     0.150
     5.647    85.328     0.150
     5.710    86.227     0.150
     6.119    92.227     0.150
     6.180    92.348     0.150
     6.199    92.719     0.150
     6.339    92.348     0.150
    12.688   179.098     0.150
    16.108   226.777     0.150
    19.610   268.828     0.150
    20.084   275.305     0.150
    25.174   325.504     0.150
    36.558   424.930     0.150
    51.740   547.152     0.150
    52.434   553.227     0.150
     1.449    26.176     0.150
     1.449    45.574     0.150
     1.811    33.176     0.150
     2.265    39.375     0.150
     2.345    39.375     0.150
     2.531    42.375     0.150
     2.571    42.973     0.150
     3.238    53.375     0.150
     3.924    62.375     0.150
     3.996    63.875     0.150
     4.439    69.176     0.150
     4.504    69.398     0.150
     4.504   145.199     0.150
     5.166    78.375     0.150
     5.166    78.875     0.150
     5.600    85.574     0.150
     5.652    85.973     0.150
     6.016    91.074     0.150
    10.799   155.090     0.150
    10.799   269.117     0.150
    12.676   178.020     0.150
    14.698   207.984     0.150
    14.698   366.457     0.150
    19.597   268.875     0.150
    36.595   425.176     0.150
    41.117   464.199     0.150
    51.697   546.648     0.150
    87.567   767.125     0.150
     1.478    27.316     0.150
     1.478    46.914     0.150
     1.478    27.477     0.150
     1.695    29.914     0.150
     1.828    33.316     0.150
     1.828    33.164     0.150
     2.000    35.105     0.150
     2.280    39.414     0.150
     2.363    40.016     0.150
     2.385    40.516     0.150
     2.569    42.715     0.150
     2.595    43.816     0.150
     2.815    47.074     0.150
     3.024    49.715     0.150
     3.260    53.414     0.150
     3.563    56.816     0.150
     3.563    56.707     0.150
     3.852    61.215     0.150
     3.953    62.316     0.150
     4.019    63.914     0.150
     4.129    77.766     0.150
     4.457    69.414     0.150
     4.520    69.891     0.150
     4.520   145.691     0.150
     4.783    74.914     0.150
     5.625    85.574     0.150
     5.689    86.215     0.150
     6.052    90.715     0.150
     6.159    92.914     0.150
     6.189    92.805     0.150
     6.238    93.516     0.150
     6.390    92.805     0.150
     6.631    99.617     0.150
    12.638   179.461     0.150
    12.638   316.484     0.150
    16.052   225.742     0.150
    16.052   392.992     0.150
    17.312   240.789     0.150
    19.341   265.816     0.150
    19.559   268.391     0.150
    20.027   274.340     0.150
    21.894   294.383     0.150
    23.078   306.965     0.150
    25.117   326.340     0.150
    28.632   356.340     0.150
    35.196   414.426     0.150
    36.562   425.965     0.150
    40.135   456.754     0.150
    41.082   465.316     0.150
    41.567   468.414     0.150
    41.567   467.914     0.150
    51.727   546.941     0.150
    52.398   552.715     0.150
    87.538   767.242     0.150
    89.515   777.066     0.150
   127.701  1146.141     0.150
     1.434    26.523     0.150
     1.434    45.723     0.150
     1.434    26.785     0.150
     1.660    29.223     0.150
     1.660    29.395     0.150
     1.793    32.523     0.150
     1.793    32.773     0.150
     1.982    34.402     0.150
     2.247    39.125     0.150
     2.318    39.125     0.150
     2.350    40.125     0.150
     2.540    42.824     0.150
     2.555    42.926     0.150
     2.785    46.805     0.150
     2.985    49.125     0.150
     3.221    52.223     0.150
     3.534    56.125     0.150
     3.534    56.453     0.150
     3.817    61.223     0.150
     3.910    61.676     0.150
     3.979    63.125     0.150
     4.084    64.363     0.150
     4.091    63.625     0.150
     4.421    69.223     0.150
     4.430    68.023     0.150
     4.486    70.301     0.150
     4.486   145.223     0.150
     4.600    71.223     0.150
     4.625    70.926     0.150
     4.745    72.996     0.150
     5.170    78.426     0.150
     5.584    84.895     0.150
     5.660    85.625     0.150
     5.722    86.523     0.150
     5.894    84.793     0.150
     5.894    85.023     0.150
     6.025    90.723     0.150
     6.119    91.926     0.150
     6.145    91.926     0.150
     6.218    92.824     0.150
     6.218    93.086     0.150
     6.359    92.434     0.150
     6.501    97.004     0.150
     6.593    99.324     0.150
     7.146   104.336     0.150
     7.146   106.723     0.150
     7.146   106.016     0.150
     7.940   114.074     0.150
     8.926   129.805     0.150
     8.926   129.594     0.150
     9.271   132.523     0.150
     9.463   134.723     0.150
    10.016   142.062     0.150
    10.662   151.254     0.150
    10.789   153.070     0.150
    10.789   271.246     0.150
    10.789   153.895     0.150
    12.133   171.312     0.150
    12.669   179.543     0.150
    12.669   318.844     0.150
    12.669   180.125     0.150
    12.669   179.137     0.150
    14.117   199.426     0.150
    14.117   199.613     0.150
    14.363   200.785     0.150
    14.679   206.453     0.150
    14.679   206.426     0.150
    14.700   211.723     0.150
    14.864   211.473     0.150
    15.665   218.770     0.150
    16.041   223.598     0.150
    16.041   395.348     0.150
    16.172   226.293     0.150
    16.172   227.242     0.150
    17.273   244.824     0.150
    18.084   250.535     0.150
    18.084   250.125     0.150
    18.084   250.746     0.150
    18.084   253.402     0.150
    18.172   252.016     0.150
    19.350   266.324     0.150
    19.354   265.203     0.150
    19.354   266.266     0.150
    19.413   265.426     0.150
    19.413   264.543     0.150
    19.413   266.121     0.150
    19.590   268.551     0.150
    19.590   268.023     0.150
    19.590   269.000     0.150
    19.590   267.152     0.150
    20.155   275.805     0.150
    20.155   274.125     0.150
    20.155   275.316     0.150
    20.155   275.523     0.150
    20.155   275.176     0.150
    20.798   281.684     0.150
    21.443   287.324     0.150
    21.920   294.824     0.150
    21.886   294.793     0.150
    21.886   294.223     0.150
    21.886   294.453     0.150
    23.033   306.414     0.150
    23.033   307.176     0.150
    23.033   306.305     0.150
    24.021   316.824     0.150
    25.139   326.250     0.150
    25.139   324.273     0.150
    25.358   328.676     0.150
    25.358   330.223     0.150
    28.595   357.348     0.150
    28.602   357.234     0.150
    28.602   356.785     0.150
    30.244   372.926     0.150
    31.766   386.875     0.150
    32.293   391.723     0.150
    33.670   398.973     0.150
    35.170   415.383     0.150
    35.476   418.504     0.150
    35.920   422.645     0.150
    36.413   425.465     0.150
    36.417   425.465     0.150
    36.608   427.125     0.150
    36.608   425.383     0.150
    36.669   428.613     0.150
    37.557   436.348     0.150
    37.557   433.543     0.150
    37.557   436.023     0.150
    37.641   437.246     0.150
    37.943   439.363     0.150
    38.016   440.125     0.150
    38.237   442.152     0.150
    40.104   456.375     0.150
    40.263   458.824     0.150
    40.263   457.125     0.150
    41.107   464.551     0.150
    41.107   463.496     0.150
    41.498   470.336     0.150
    41.537   467.898     0.150
    41.518   468.223     0.150
    45.488   500.766     0.150
    46.321   506.574     0.150
    46.700   509.754     0.150
    47.086   511.094     0.150
    51.683   547.199     0.150
    51.683   547.094     0.150
    52.161   550.523     0.150
    52.440   554.125     0.150
    52.585   554.562     0.150
    54.100   566.312     0.150
    54.427   567.926     0.150
    54.610   569.645     0.150
    62.581   623.223     0.150
    70.030   669.984     0.150
    87.582   767.973     0.150
    87.582   766.945     0.150
    89.557   777.926     0.150
     1.546    48.848     0.150
     1.735    30.648     0.150
     1.891    33.445     0.150
     2.423    41.047     0.150
     2.431    40.746     0.150
     2.596    43.445     0.150
     3.325    54.746     0.150
     3.589    57.348     0.150
     3.913    62.945     0.150
     4.020    63.148     0.150
     4.083    65.148     0.150
     4.193    65.246     0.150
     4.520    70.945     0.150
     4.580    72.547     0.150
     4.580   148.672     0.150
     4.722    72.148     0.150
     5.247    79.848     0.150
     5.715    86.746     0.150
     5.691    86.445     0.150
     6.204    93.148     0.150
     6.249    93.648     0.150
    12.607   176.539     0.150
    12.607   313.242     0.150
    19.530   267.473     0.150
    20.013   272.156     0.150
    25.103   324.273     0.150
    87.470   767.922     0.150
    89.448   777.797     0.150
     1.493    27.434     0.150
     1.493    48.531     0.150
     1.694    29.934     0.150
     1.845    33.031     0.150
     2.297    39.633     0.150
     2.383    40.434     0.150
     2.564    43.031     0.150
     2.611    43.832     0.150
     3.040    50.434     0.150
     3.277    53.730     0.150
     3.968    62.730     0.150
     4.035    64.133     0.150
     4.537   147.383     0.150
     5.206    78.730     0.150
     5.641    85.832     0.150
     5.684    85.832     0.150
     5.755    87.230     0.150
     6.160    92.832     0.150
     6.229    93.633     0.150
     6.631    99.531     0.150
    12.641   179.176     0.150
    19.563   268.234     0.150
    20.035   273.934     0.150
    23.092   306.383     0.150
    25.125   325.355     0.150
    36.549   425.770     0.150
    87.523   767.953     0.150
    89.500   777.016     0.150
     1.444    27.207     0.150
     1.444    46.004     0.150
     1.444    27.066     0.150
     1.800    32.906     0.150
     1.800    32.324     0.150
     2.254    39.004     0.150
     2.358    39.906     0.150
     2.546    43.305     0.150
     2.563    43.406     0.150
     2.791    46.395     0.150
     2.993    49.707     0.150
     3.230    53.406     0.150
     3.541    56.504     0.150
     3.541    56.215     0.150
     3.825    61.504     0.150
     3.919    62.504     0.150
     3.919    61.914     0.150
     3.988    64.004     0.150
     4.094    63.977     0.150
     4.101    63.707     0.150
     4.440    68.707     0.150
     4.493    68.918     0.150
     4.493    82.980     0.150
     4.493   144.863     0.150
     4.635    70.707     0.150
     4.753    73.566     0.150
     5.179    78.207     0.150
     5.593    84.504     0.150
     5.667    86.105     0.150
     5.730    86.707     0.150
     6.031    90.906     0.150
     6.128    92.504     0.150
     6.154    92.254     0.150
     6.223    92.906     0.150
     6.602    99.105     0.150
    12.662   179.684     0.150
    19.347   267.305     0.150
    19.583   268.180     0.150
    20.043   274.234     0.150
    25.134   325.336     0.150
    36.597   425.969     0.150
    41.101   463.508     0.150
    51.693   547.082     0.150
     1.394    25.961     0.150
     1.394    45.461     0.150
     1.612    28.660     0.150
     1.765    32.262     0.150
     2.223    38.660     0.150
     2.302    38.961     0.150
     2.497    41.961     0.150
     2.520    42.762     0.150
     3.188    52.660     0.150
     3.492    55.461     0.150
     3.791    61.160     0.150
     3.870    61.359     0.150
     3.947    62.562     0.150
     4.039    62.762     0.150
     4.392    68.762     0.150
     4.460    70.086     0.150
     4.460    82.637     0.150
     4.460   144.227     0.150
     4.548    69.961     0.150
     4.574    70.160     0.150
     5.122    77.262     0.150
     5.618    85.359     0.150
     5.675    86.359     0.150
     5.985    90.562     0.150
     6.069    91.160     0.150
     6.184    92.961     0.150
    12.714   178.504     0.150
    12.714   317.305     0.150
    16.044   222.086     0.150
    16.044   393.586     0.150
    19.374   266.273     0.150
    19.634   268.586     0.150
    20.085   274.359     0.150
    21.892   294.980     0.150
    25.176   325.812     0.150
    36.653   427.512     0.150
    41.146   464.344     0.150
    51.642   547.539     0.150
    87.622   768.152     0.150
     1.433    26.609     0.150
     1.433    46.508     0.150
     1.623    28.703     0.150
     1.804    32.906     0.150
     1.804    33.008     0.150
     2.010    35.523     0.150
     2.261    39.406     0.150
     2.312    38.906     0.150
     2.313    39.305     0.150
     2.500    41.906     0.150
     2.560    43.109     0.150
     2.804    47.156     0.150
     2.991    49.305     0.150
     3.228    52.508     0.150
     3.495    55.406     0.150
     3.495    55.883     0.150
     3.830    61.008     0.150
     3.909    61.703     0.150
     3.986    63.008     0.150
     4.057    63.039     0.150
     4.064    62.906     0.150
     4.432    69.109     0.150
     4.406    68.406     0.150
     4.499    70.008     0.150
     4.499   119.859     0.150
     4.499   147.555     0.150
     4.575    70.703     0.150
     4.595    70.703     0.150
     4.754    73.508     0.150
     5.134    78.305     0.150
     5.588    84.609     0.150
     5.588    84.477     0.150
     5.621    85.008     0.150
     5.685    86.203     0.150
     5.915    88.555     0.150
     5.985    90.305     0.150
     6.085    91.906     0.150
     6.140    91.984     0.150
     6.178    92.609     0.150
     6.178    92.273     0.150
     6.320    91.766     0.150
     6.471    96.898     0.150
     6.558    98.203     0.150
     6.825   102.109     0.150
     6.889   102.109     0.150
     7.186   105.875     0.150
     7.186   183.430     0.150
     7.186   106.445     0.150
     7.068   105.008     0.150
     7.546   111.406     0.150
     7.980   114.727     0.150
     7.980   203.414     0.150
     8.964   129.758     0.150
     8.964   129.219     0.150
     8.964   228.594     0.150
     9.307   134.047     0.150
     9.307   236.250     0.150
     9.481   138.305     0.150
    10.055   143.914     0.150
    10.701   151.812     0.150
    10.829   153.438     0.150
    10.829   153.883     0.150
    11.034   155.797     0.150
    11.145   158.836     0.150
    11.288   163.406     0.150
    11.288   291.305     0.150
    12.171   171.289     0.150
    12.708   179.984     0.150
    12.708   179.125     0.150
    12.708   319.852     0.150
    12.708   179.305     0.150
    12.708   179.648     0.150
    12.708   321.664     0.150
    13.186   187.945     0.150
    13.227   189.609     0.150
    13.227   338.805     0.150
    13.524   191.609     0.150
    14.154   199.406     0.150
    14.154   198.586     0.150
    14.211   204.867     0.150
    14.713   205.453     0.150
    14.713   207.367     0.150
    14.869   210.008     0.150
    14.985   215.180     0.150
    15.182   211.914     0.150
    15.347   215.219     0.150
    15.585   220.469     0.150
    15.706   219.680     0.150
    15.728   222.078     0.150
    15.777   226.406     0.150
    16.073   224.008     0.150
    16.073   395.930     0.150
    16.073   224.766     0.150
    16.073   394.344     0.150
    16.209   224.914     0.150
    16.416   232.977     0.150
    17.278   241.133     0.150
    17.291   243.117     0.150
    17.514   246.508     0.150
    17.830   248.859     0.150
    18.048   250.312     0.150
    18.048   249.977     0.150
    19.246   267.289     0.150
    19.389   266.453     0.150
    19.393   265.508     0.150
    19.393   266.305     0.150
    19.393   266.047     0.150
    19.452   266.297     0.150
    19.452   266.023     0.150
    19.452   267.477     0.150
    19.629   268.633     0.150
    19.629   268.406     0.150
    19.629   269.281     0.150
    19.629   268.125     0.150
    20.089   275.359     0.150
    20.196   276.578     0.150
    20.196   274.188     0.150
    20.196   276.117     0.150
    20.196   276.703     0.150
    20.791   281.945     0.150
    20.825   282.453     0.150
    21.262   287.523     0.150
    21.482   288.703     0.150
    21.919   294.195     0.150
    21.919   294.508     0.150
    21.919   534.406     0.150
    21.919   294.773     0.150
    23.027   305.883     0.150
    23.027   307.305     0.150
    23.027   307.156     0.150
    23.027   307.016     0.150
    23.556   313.945     0.150
    24.060   316.406     0.150
    25.180   326.383     0.150
    25.180   325.328     0.150
    25.218   326.867     0.150
    25.218   327.203     0.150
    25.387   329.805     0.150
    25.995   333.633     0.150
    26.985   344.008     0.150
    28.606   356.906     0.150
    28.613   357.453     0.150
    30.246   373.484     0.150
    30.476   375.508     0.150
    30.860   378.438     0.150
    32.383   392.062     0.150
    33.678   401.078     0.150
    33.789   404.234     0.150
    35.191   415.594     0.150
    35.513   418.383     0.150
    36.470   426.133     0.150
    36.616   426.805     0.150
    36.616   426.703     0.150
    37.353   434.438     0.150
    37.970   439.508     0.150
    37.970   439.266     0.150
    38.262   442.094     0.150
    38.648   444.938     0.150
    38.683   444.906     0.150
    38.869   446.305     0.150
    38.881   447.047     0.150
    40.047   455.406     0.150
    40.047   456.656     0.150
    40.091   457.148     0.150
    40.122   456.492     0.150
    40.291   458.281     0.150
    41.147   465.234     0.150
    41.180   465.969     0.150
    41.524   468.375     0.150
    41.517   468.359     0.150
    41.555   468.508     0.150
    41.555   468.508     0.150
    41.697   470.234     0.150
    42.878   479.438     0.150
    44.383   491.789     0.150
    46.321   507.109     0.150
    46.699   509.844     0.150
    47.752   517.406     0.150
    48.244   521.727     0.150
    49.254   529.906     0.150
    49.803   533.328     0.150
    49.803   533.445     0.150
    51.680   547.828     0.150
    51.681   547.555     0.150
    51.681   547.750     0.150
    51.996   550.344     0.150
    52.003   550.109     0.150
    52.199   551.109     0.150
    52.472   553.953     0.150
    54.455   568.453     0.150
    54.608   569.453     0.150
    55.029   572.594     0.150
    59.040   601.477     0.150
    60.366   611.406     0.150
    63.523   631.398     0.150
    68.552   663.508     0.150
    69.465   667.203     0.150
    71.771   681.109     0.150
    71.771   682.094     0.150
    72.871   688.859     0.150
    74.318   697.828     0.150
    76.036   708.148     0.150
    87.584   767.828     0.150
    89.557   776.859     0.150
     1.458    26.625     0.150
     1.458    47.625     0.150
     1.613    28.523     0.150
     1.836    33.320     0.150
     2.302    39.219     0.150
     2.294    39.422     0.150
     2.484    41.922     0.150
     3.021    50.125     0.150
     3.257    53.625     0.150
     3.478    55.422     0.150
     3.934    61.523     0.150
     4.016    63.625     0.150
     4.413    68.320     0.150
     4.463    70.125     0.150
     4.531    70.898     0.150
     4.531    83.898     0.150
     4.531   146.523     0.150
     4.596    70.820     0.150
     5.604    84.422     0.150
     5.673    85.719     0.150
     6.080    91.820     0.150
     6.154    91.922     0.150
     6.550    98.523     0.150
    10.849   155.375     0.150
    10.849   272.398     0.150
    12.722   180.742     0.150
    12.722   320.188     0.150
    12.722   181.367     0.150
    12.722   318.500     0.150
    14.746   208.367     0.150
    14.746   365.125     0.150
    19.418   267.203     0.150
    19.644   271.984     0.150
    19.644   271.047     0.150
    20.111   275.336     0.150
    41.167   464.195     0.150
    51.705   546.695     0.150
    87.559   766.641     0.150
     1.523    27.948     0.150
     1.523    49.748     0.150
     1.688    29.748     0.150
     1.688    29.858     0.150
     1.882    33.948     0.150
     2.056    36.208     0.150
     2.335    40.248     0.150
     2.376    40.349     0.150
     2.404    40.049     0.150
     2.550    42.748     0.150
     2.645    43.549     0.150
     2.870    47.759     0.150
     3.075    50.049     0.150
     3.311    53.549     0.150
     3.543    56.248     0.150
     3.906    62.349     0.150
     3.998    63.248     0.150
     3.998    62.639     0.150
     4.069    64.849     0.150
     4.143    63.868     0.150
     4.150    64.448     0.150
     4.495    68.748     0.150
     4.510    69.948     0.150
     4.574    71.224     0.150
     4.574   148.198     0.150
     4.662    71.248     0.150
     4.677    71.748     0.150
     4.835    74.479     0.150
     5.201    78.748     0.150
     5.669    85.648     0.150
     5.674    86.148     0.150
     5.674    85.818     0.150
     5.746    86.948     0.150
     5.824    84.629     0.150
     6.158    92.948     0.150
     6.207    92.948     0.150
     6.232    93.188     0.150
     6.372    92.969     0.150
     6.553    98.099     0.150
     6.626    99.549     0.150
     6.918   103.148     0.150
     7.143   105.108     0.150
     7.166   106.448     0.150
     7.166   106.328     0.150
     7.639   113.448     0.150
     7.939   114.668     0.150
     8.906   128.519     0.150
     8.906   128.658     0.150
     9.242   134.219     0.150
    10.005   144.028     0.150
    10.649   151.438     0.150
    10.791   153.248     0.150
    10.791   269.217     0.150
    10.791   153.769     0.150
    10.977   155.118     0.150
    11.790   301.148     0.150
    12.113   169.958     0.150
    12.653   179.179     0.150
    12.653   179.667     0.150
    12.653   321.167     0.150
    12.653   178.898     0.150
    12.653   178.104     0.150
    12.653   317.361     0.150
    12.653   178.698     0.150
    13.465   188.879     0.150
    13.465   189.538     0.150
    14.091   198.818     0.150
    14.091   198.429     0.150
    14.739   206.549     0.150
    14.739   205.541     0.150
    14.789   210.269     0.150
    14.789   210.143     0.150
    14.789   209.769     0.150
    14.954   212.828     0.150
    15.113   211.788     0.150
    15.078   217.379     0.150
    15.682   217.777     0.150
    16.106   226.424     0.150
    16.106   395.799     0.150
    16.106   224.695     0.150
    16.106   393.462     0.150
    16.148   225.188     0.150
    17.363   243.198     0.150
    18.115   250.918     0.150
    18.115   251.148     0.150
    19.338   269.059     0.150
    19.382   266.448     0.150
    19.400   266.488     0.150
    19.576   268.523     0.150
    19.576   267.938     0.150
    20.056   273.724     0.150
    20.163   276.168     0.150
    20.884   282.358     0.150
    21.888   294.248     0.150
    21.946   294.316     0.150
    21.946   294.729     0.150
    23.119   307.198     0.150
    23.119   307.568     0.150
    23.649   314.458     0.150
    25.146   325.599     0.150
    25.146   325.179     0.150
    26.089   335.118     0.150
    28.685   358.273     0.150
    28.692   358.618     0.150
    28.692   358.288     0.150
    33.323   398.679     0.150
    35.252   415.438     0.150
    36.329   424.568     0.150
    36.333   424.509     0.150
    36.523   425.948     0.150
    36.780   431.288     0.150
    38.018   439.769     0.150
    38.314   442.698     0.150
    38.501   443.918     0.150
    38.689   446.019     0.150
    39.178   449.568     0.150
    40.141   457.168     0.150
    40.190   457.161     0.150
    40.338   458.448     0.150
    40.390   460.049     0.150
    40.448   460.759     0.150
    40.680   462.879     0.150
    41.107   464.398     0.150
    41.107   464.158     0.150
    41.591   468.738     0.150
    41.607   469.099     0.150
    41.623   468.948     0.150
    41.623   468.998     0.150
    41.788   470.998     0.150
    41.788   469.738     0.150
    42.484   476.599     0.150
    42.607   477.009     0.150
    42.620   477.823     0.150
    42.632   477.868     0.150
    42.824   479.318     0.150
    42.967   480.368     0.150
    43.156   480.698     0.150
    43.148   482.179     0.150
    44.471   491.889     0.150
    44.471   492.158     0.150
    46.410   507.538     0.150
    46.789   510.809     0.150
    48.335   522.269     0.150
    48.559   524.323     0.150
    49.004   528.729     0.150
    51.770   548.458     0.150
    51.771   548.373     0.150
    51.771   547.948     0.150
    52.093   550.828     0.150
    52.395   553.998     0.150
    54.189   566.879     0.150
    54.499   568.599     0.150
    58.831   599.918     0.150
    76.031   707.948     0.150
    77.522   717.059     0.150
    77.980   716.639     0.150
    83.504   748.688     0.150
    87.493   767.948     0.150
    87.493   767.019     0.150
    87.495   767.118     0.150
    89.468   777.148     0.150
    89.468   776.868     0.150
     1.540    27.911     0.150
     1.540    49.110     0.150
     1.686    29.411     0.150
     1.902    34.211     0.150
     2.355    40.511     0.150
     2.373    40.411     0.150
     2.543    42.610     0.150
     2.663    44.811     0.150
     3.094    50.811     0.150
     3.330    54.511     0.150
     3.536    56.211     0.150
     3.926    62.811     0.150
     4.016    63.511     0.150
     4.089    64.811     0.150
     4.155    64.811     0.150
     4.530    70.711     0.150
     4.594    71.936     0.150
     4.594   149.686     0.150
     4.680    71.211     0.150
     5.198    79.011     0.150
     5.662    85.811     0.150
     5.742    87.411     0.150
     6.021    90.911     0.150
     6.157    92.811     0.150
     6.195    93.211     0.150
     6.624    99.311     0.150
    12.660   180.154     0.150
    12.660   319.154     0.150
    16.126   226.735     0.150
    20.068   273.886     0.150
    21.966   294.403     0.150
    23.135   305.110     0.150
    25.157   324.061     0.150
     1.481    26.652     0.150
     1.481    48.152     0.150
     1.481    26.480     0.150
     1.707    30.051     0.150
     1.707    29.449     0.150
     1.828    33.051     0.150
     1.828    33.191     0.150
     1.994    35.371     0.150
     2.278    39.352     0.150
     2.367    39.652     0.150
     2.396    40.750     0.150
     2.580    43.250     0.150
     2.812    46.871     0.150
     3.025    50.051     0.150
     3.575    56.750     0.150
     3.575    57.281     0.150
     3.851    62.352     0.150
     3.955    62.551     0.150
     3.955    62.371     0.150
     4.019    64.051     0.150
     4.145    64.852     0.150
     4.457    69.652     0.150
     4.484    69.652     0.150
     4.518    69.879     0.150
     4.518    84.191     0.150
     4.518   144.949     0.150
     4.783    73.730     0.150
     5.218    78.551     0.150
     5.626    85.449     0.150
     5.626    86.121     0.150
     6.249    93.949     0.150
     6.554    97.430     0.150
    10.753   153.324     0.150
    10.753   269.805     0.150
    14.679   204.992     0.150
    16.044   223.152     0.150
    16.044   391.402     0.150
    16.044   392.977     0.150
    19.330   264.570     0.150
    19.547   267.215     0.150
    21.886   294.445     0.150
    25.106   324.559     0.150
    35.429   565.996     0.150
    36.557   426.629     0.150
    40.132   456.152     0.150
    41.070   462.516     0.150
    51.730   548.191     0.150
    87.535   768.199     0.150
     1.461    26.883     0.150
     1.461    47.082     0.150
     1.696    30.281     0.150
     1.696    29.742     0.150
     1.810    32.883     0.150
     1.810    32.504     0.150
     1.981    34.352     0.150
     2.261    39.184     0.150
     2.386    40.383     0.150
     2.573    43.281     0.150
     2.795    46.895     0.150
     3.242    53.684     0.150
     3.568    56.582     0.150
     3.833    61.484     0.150
     3.936    62.184     0.150
     3.936    61.613     0.150
     4.000    62.883     0.150
     4.122    63.863     0.150
     4.129    64.383     0.150
     4.439    69.383     0.150
     4.467    68.984     0.150
     4.501    69.133     0.150
     4.501    83.734     0.150
     4.501   120.969     0.150
     4.501   147.246     0.150
     4.664    71.781     0.150
     4.764    74.043     0.150
     5.207    79.184     0.150
     5.607    85.984     0.150
     5.607    85.234     0.150
     5.758    87.184     0.150
     6.157    92.582     0.150
     6.174    92.805     0.150
     6.247    93.281     0.150
     6.247    93.004     0.150
     6.394    92.352     0.150
     6.539    98.332     0.150
     6.631    99.582     0.150
     7.113   105.773     0.150
    10.758   154.031     0.150
    10.758   273.234     0.150
    12.634   178.527     0.150
    12.634   319.176     0.150
    12.634   180.137     0.150
    14.670   205.266     0.150
    14.670   365.871     0.150
    16.034   222.383     0.150
    16.034   393.734     0.150
    16.034   223.449     0.150
    16.034   397.023     0.150
    18.122   253.254     0.150
    19.328   265.957     0.150
    19.555   268.258     0.150
    20.019   273.133     0.150
    21.877   293.750     0.150
    25.109   324.531     0.150
    35.177   415.121     0.150
    35.440   416.352     0.150
    36.576   425.684     0.150
    40.115   456.723     0.150
    41.075   463.906     0.150
    41.548   468.008     0.150
    51.710   547.508     0.150
    87.554   767.859     0.150
    89.532   777.531     0.150
     1.489    27.680     0.150
     1.489    47.480     0.150
     1.650    29.180     0.150
     1.858    33.480     0.150
     2.313    39.680     0.150
     2.338    39.582     0.150
     2.516    42.480     0.150
     3.047    50.480     0.150
     3.283    53.379     0.150
     3.509    56.082     0.150
     3.883    62.480     0.150
     3.965    63.082     0.150
     4.042    64.281     0.150
     4.453    68.680     0.150
     4.486    70.180     0.150
     4.552    72.031     0.150
     4.552   148.582     0.150
     4.635    71.180     0.150
     5.709    86.582     0.150
     6.180    92.680     0.150
    10.821   153.930     0.150
    10.821   273.031     0.150
    12.689   178.875     0.150
    12.689   319.301     0.150
    12.689   178.648     0.150
    12.689   319.660     0.150
    14.743   205.824     0.150
    14.743   363.441     0.150
    16.106   224.379     0.150
    16.106   396.730     0.150
    16.106   393.637     0.150
    19.400   267.230     0.150
    19.611   268.680     0.150
    20.084   273.105     0.150
    25.175   326.117     0.150
    36.561   425.879     0.150
    41.138   464.672     0.150
    41.605   468.945     0.150
    51.737   548.055     0.150
    87.527   768.031     0.150
     1.530    27.273     0.150
     1.530    48.875     0.150
     1.664    29.473     0.150
     1.898    34.172     0.150
     2.351    39.875     0.150
     2.522    42.672     0.150
     2.656    44.773     0.150
     3.088    51.074     0.150
     3.324    54.074     0.150
     4.006    63.273     0.150
     4.082    64.273     0.150
     4.135    64.273     0.150
     4.483    69.672     0.150
     4.526    70.473     0.150
     4.592    73.148     0.150
     4.592   149.648     0.150
     5.177    78.172     0.150
     5.641    85.574     0.150
     6.136    92.672     0.150
     6.175    92.473     0.150
    10.821   153.047     0.150
    10.821   272.066     0.150
    12.681   179.617     0.150
    12.681   320.617     0.150
    12.681   178.723     0.150
    12.681   319.543     0.150
    14.770   209.898     0.150
    14.770   366.238     0.150
    16.135   224.547     0.150
    16.135   398.699     0.150
    16.135   225.965     0.150
    19.415   267.348     0.150
    19.604   269.648     0.150
    20.087   275.094     0.150
    25.177   325.125     0.150
    36.522   425.430     0.150
    51.778   547.730     0.150
    87.487   767.926     0.150
     1.387    25.750     0.150
     1.387    44.250     0.150
     1.577    28.250     0.150
     1.577    28.438     0.150
     1.770    32.250     0.150
     1.998    34.789     0.150
     2.230    38.750     0.150
     2.263    38.750     0.150
     2.519    42.648     0.150
     2.461    41.449     0.150
     2.777    46.398     0.150
     2.952    48.648     0.150
     3.188    52.051     0.150
     3.456    54.848     0.150
     3.456    54.980     0.150
     3.797    61.051     0.150
     3.863    61.348     0.150
     3.863    61.461     0.150
     3.946    62.648     0.150
     4.004    62.840     0.150
     4.011    62.348     0.150
     4.352    67.551     0.150
     4.396    68.648     0.150
     4.466    70.023     0.150
     4.466    83.949     0.150
     4.466   144.699     0.150
     4.466    71.750     0.150
     4.521    69.750     0.150
     4.543    70.051     0.150
     4.716    72.277     0.150
     5.087    77.449     0.150
     5.546    84.449     0.150
     5.546    84.250     0.150
     5.582    84.348     0.150
     5.640    85.250     0.150
     5.949    89.551     0.150
     5.969    88.238     0.150
     6.036    90.648     0.150
     6.091    91.730     0.150
     6.149    92.148     0.150
     6.149    92.270     0.150
     6.280    91.289     0.150
     6.419    95.910     0.150
     6.510    97.250     0.150
     7.017   104.879     0.150
     7.222   105.699     0.150
     9.007   129.980     0.150
     9.354   134.641     0.150
    10.095   143.961     0.150
    10.741   153.199     0.150
    10.864   154.348     0.150
    10.864   272.973     0.150
    10.864   154.578     0.150
    11.078   156.379     0.150
    11.913   171.449     0.150
    11.913   301.051     0.150
    12.214   171.828     0.150
    12.750   181.367     0.150
    12.750   320.742     0.150
    12.750   179.379     0.150
    12.750   178.504     0.150
    12.750   318.797     0.150
    12.750   180.551     0.150
    12.750   179.949     0.150
    13.567   192.148     0.150
    14.199   199.250     0.150
    14.446   204.070     0.150
    14.711   208.449     0.150
    14.711   208.012     0.150
    14.711   364.355     0.150
    14.827   210.598     0.150
    15.230   212.949     0.150
    16.068   224.449     0.150
    16.068   393.949     0.150
    16.068   223.023     0.150
    16.068   394.484     0.150
    16.254   225.699     0.150
    17.238   243.000     0.150
    17.474   247.348     0.150
    18.001   249.250     0.150
    18.001   248.770     0.150
    18.001   253.711     0.150
    19.199   265.051     0.150
    19.407   267.301     0.150
    19.411   265.539     0.150
    19.411   267.250     0.150
    19.411   266.410     0.150
    19.411   270.738     0.150
    19.493   266.848     0.150
    19.493   266.539     0.150
    19.670   269.023     0.150
    19.670   269.348     0.150
    19.670   269.301     0.150
    19.670   269.000     0.150
    19.715   273.648     0.150
    20.121   275.500     0.150
    20.227   274.598     0.150
    20.227   276.348     0.150
    20.227   276.449     0.150
    20.227   275.430     0.150
    20.740   283.488     0.150
    20.774   283.398     0.150
    21.169   285.438     0.150
    21.351   288.348     0.150
    21.523   288.750     0.150
    21.603   291.750     0.150
    21.918   295.344     0.150
    21.918   533.543     0.150
    21.918   294.520     0.150
    21.918   295.449     0.150
    21.918   314.551     0.150
    21.918   294.910     0.150
    21.956   296.848     0.150
    22.003   295.051     0.150
    22.587   301.848     0.150
    22.978   305.938     0.150
    22.978   307.148     0.150
    22.978   305.598     0.150
    22.978   306.398     0.150
    22.978   307.648     0.150
    24.100   316.949     0.150
    25.212   326.199     0.150
    25.212   325.758     0.150
    25.271   326.559     0.150
    25.271   328.027     0.150
    25.376   329.750     0.150
    28.570   357.387     0.150
    28.570   355.809     0.150
    28.570   356.148     0.150
    30.407   376.348     0.150
    35.559   418.852     0.150
    35.559   416.738     0.150
    36.003   423.750     0.150
    36.667   426.750     0.150
    37.613   437.250     0.150
    40.093   456.195     0.150
    41.182   465.891     0.150
    41.527   468.160     0.150
    46.653   509.660     0.150
    51.634   547.449     0.150
    51.634   547.000     0.150
    52.243   551.816     0.150
    52.243   552.848     0.150
    52.523   554.152     0.150
    87.631   768.250     0.150
    87.631   768.699     0.150
    89.603   777.098     0.150
     1.455    26.961     0.150
     1.455    47.161     0.150
     1.693    29.861     0.150
     1.977    34.871     0.150
     2.255    39.261     0.150
     2.341    39.461     0.150
     2.383    40.361     0.150
     2.571    43.361     0.150
     2.571    43.261     0.150
     2.790    46.781     0.150
     3.000    48.961     0.150
     3.236    53.461     0.150
     3.566    56.861     0.150
     3.566    56.731     0.150
     3.827    61.061     0.150
     3.930    61.961     0.150
     3.994    63.761     0.150
     4.117    64.431     0.150
     4.124    64.261     0.150
     4.433    69.261     0.150
     4.495    70.173     0.150
     4.495    83.161     0.150
     4.495   121.927     0.150
     4.495   144.261     0.150
     4.462    69.061     0.150
     4.633    71.461     0.150
     4.659    71.361     0.150
     4.758    74.021     0.150
     5.204    78.961     0.150
     5.601    85.561     0.150
     5.601    85.001     0.150
     5.692    86.161     0.150
     5.755    87.361     0.150
     6.056    91.461     0.150
     6.167    92.471     0.150
     6.153    92.361     0.150
     6.246    93.161     0.150
     6.246    92.841     0.150
     6.535    97.351     0.150
     6.627    99.861     0.150
     7.115   105.321     0.150
     7.133   105.761     0.150
     7.586   111.861     0.150
     8.188   120.961     0.150
    10.759   153.672     0.150
    10.759   269.295     0.150
    12.637   178.930     0.150
    12.637   319.555     0.150
    12.637   179.183     0.150
    12.637   319.994     0.150
    12.637   179.711     0.150
    14.667   205.023     0.150
    14.667   364.515     0.150
    14.720   209.305     0.150
    16.031   222.411     0.150
    16.031   393.836     0.150
    16.031   223.187     0.150
    16.031   397.130     0.150
    17.288   240.011     0.150
    17.517   243.261     0.150
    18.118   253.221     0.150
    19.327   265.011     0.150
    19.331   266.721     0.150
    19.381   266.601     0.150
    19.557   268.104     0.150
    20.020   274.586     0.150
    21.873   293.454     0.150
    21.873   294.361     0.150
    23.056   307.361     0.150
    25.110   325.086     0.150
    28.607   356.840     0.150
    35.171   414.776     0.150
    35.443   416.981     0.150
    36.583   425.974     0.150
    40.110   455.895     0.150
    41.076   463.786     0.150
    41.542   467.567     0.150
    48.480   523.266     0.150
    51.704   546.039     0.150
    52.406   553.289     0.150
    87.561   767.586     0.150
    89.538   777.210     0.150
     1.513    27.600     0.150
     1.513    49.398     0.150
     1.513    27.979     0.150
     1.852    33.600     0.150
     1.737    30.898     0.150
     1.737    30.680     0.150
     2.005    35.350     0.150
     2.301    39.898     0.150
     2.401    40.398     0.150
     2.426    40.898     0.150
     2.625    44.299     0.150
     2.606    43.600     0.150
     2.831    47.568     0.150
     3.052    49.600     0.150
     3.289    53.799     0.150
     3.600    57.299     0.150
     3.600    57.488     0.150
     3.874    62.100     0.150
     3.987    62.898     0.150
     4.047    63.898     0.150
     4.174    64.869     0.150
     4.181    64.898     0.150
     4.482    69.998     0.150
     4.541    70.674     0.150
     4.541    84.475     0.150
     4.541   146.748     0.150
     4.520    69.299     0.150
     4.690    71.398     0.150
     4.809    73.869     0.150
     4.713    72.299     0.150
     5.249    79.498     0.150
     5.655    85.398     0.150
     5.655    86.209     0.150
     5.804    84.949     0.150
     5.804    86.398     0.150
     5.726    86.699     0.150
     5.798    87.398     0.150
     5.960    90.398     0.150
     6.088    91.699     0.150
     6.226    93.289     0.150
     6.202    93.398     0.150
     6.269    93.600     0.150
     6.428    92.998     0.150
     6.589    98.338     0.150
     6.689    99.100     0.150
     6.674   100.199     0.150
     7.084   104.338     0.150
     7.084   104.799     0.150
     7.007   104.799     0.150
     7.186   106.328     0.150
     7.225   107.799     0.150
     7.646   113.398     0.150
     7.880   113.889     0.150
     7.882   116.338     0.150
     8.228   120.898     0.150
     8.245   121.199     0.150
     8.546   125.699     0.150
     8.695   127.600     0.150
     8.852   127.398     0.150
     8.852   128.100     0.150
     8.762   128.199     0.150
     8.880   129.898     0.150
     8.988   131.350     0.150
     9.193   132.199     0.150
     9.188   134.838     0.150
     9.114   134.049     0.150
     9.373   135.299     0.150
     9.373   134.408     0.150
     9.700   138.988     0.150
     9.781   140.338     0.150
     9.948   142.539     0.150
     9.880   143.529     0.150
     9.972   144.908     0.150
    10.243   144.998     0.150
    10.228   148.748     0.150
    10.593   150.850     0.150
    10.731   153.021     0.150
    10.731   267.699     0.150
    10.731   266.799     0.150
    10.731   153.199     0.150
    10.923   155.100     0.150
    10.983   156.408     0.150
    10.897   157.439     0.150
    11.096   157.998     0.150
    11.247   160.189     0.150
    11.746   168.498     0.150
    11.746   298.799     0.150
    12.060   170.498     0.150
    12.175   175.729     0.150
    12.598   178.719     0.150
    12.598   178.443     0.150
    12.598   317.367     0.150
    12.598   177.947     0.150
    12.598   317.754     0.150
    12.598   178.299     0.150
    12.598   178.998     0.150
    12.598   178.568     0.150
    12.589   180.898     0.150
    12.935   185.668     0.150
    13.070   185.139     0.150
    13.150   187.600     0.150
    13.213   191.078     0.150
    13.412   189.199     0.150
    13.394   190.799     0.150
    13.394   341.799     0.150
    13.791   198.100     0.150
    13.791   353.699     0.150
    13.888   195.988     0.150
    14.040   197.799     0.150
    14.040   197.398     0.150
    14.285   200.729     0.150
    14.245   202.619     0.150
    14.680   204.479     0.150
    14.680   204.186     0.150
    14.680   363.697     0.150
    14.680   204.209     0.150
    14.690   210.100     0.150
    14.778   210.844     0.150
    14.778   208.039     0.150
    14.933   210.609     0.150
    15.007   210.699     0.150
    15.078   216.010     0.150
    15.272   214.498     0.150
    15.415   217.260     0.150
    15.619   215.826     0.150
    15.619   215.998     0.150
    15.644   219.488     0.150
    15.713   220.318     0.150
    15.675   220.988     0.150
    15.845   222.338     0.150
    15.804   223.789     0.150
    16.286   227.850     0.150
    16.049   223.049     0.150
    16.049   393.475     0.150
    16.049   221.844     0.150
    16.049   393.994     0.150
    16.097   223.908     0.150
    16.097   222.900     0.150
    16.270   227.488     0.150
    16.782   235.699     0.150
    17.210   239.988     0.150
    17.279   243.699     0.150
    17.340   241.299     0.150
    17.340   242.100     0.150
    17.502   245.100     0.150
    17.570   245.373     0.150
    17.575   244.689     0.150
    17.575   244.299     0.150
    17.575   439.199     0.150
    18.088   250.648     0.150
    18.198   251.029     0.150
    18.164   252.010     0.150
    18.164   250.850     0.150
    18.949   262.148     0.150
    19.142   266.299     0.150
    19.319   265.023     0.150
    19.323   264.850     0.150
    19.323   265.100     0.150
    19.323   265.648     0.150
    19.344   265.209     0.150
    19.344   265.459     0.150
    19.344   264.223     0.150
    19.334   268.738     0.150
    19.419   481.299     0.150
    19.521   267.049     0.150
    19.521   267.600     0.150
    19.521   268.600     0.150
    19.521   268.100     0.150
    19.521   267.588     0.150
    19.755   271.699     0.150
    19.995   273.824     0.150
    20.102   274.180     0.150
    20.102   273.350     0.150
    20.102   272.713     0.150
    20.102   275.998     0.150
    20.102   275.418     0.150
    20.479   277.328     0.150
    20.623   278.859     0.150
    20.882   282.100     0.150
    20.920   285.318     0.150
    20.920   282.719     0.150
    21.003   284.229     0.150
    21.018   283.520     0.150
    21.373   287.600     0.150
    21.352   287.619     0.150
    21.840   530.199     0.150
    21.887   294.768     0.150
    21.887   532.742     0.150
    21.887   293.359     0.150
    21.887   294.498     0.150
    21.887   313.100     0.150
    21.887   534.799     0.150
    22.120   295.998     0.150
    22.206   298.799     0.150
    22.143   297.293     0.150
    22.151   298.469     0.150
    22.151   296.158     0.150
    22.410   302.318     0.150
    22.645   300.180     0.150
    22.645   533.139     0.150
    22.645   549.588     0.150
    23.112   308.299     0.150
    23.115   306.799     0.150
    23.115   307.100     0.150
    23.115   308.248     0.150
    23.115   306.760     0.150
    23.115   308.898     0.150
    23.388   308.898     0.150
    23.520   311.129     0.150
    23.520   310.959     0.150
    23.640   312.100     0.150
    23.667   313.799     0.150
    23.646   313.568     0.150
    23.774   314.129     0.150
    23.954   315.799     0.150
    24.347   318.199     0.150
    25.085   325.398     0.150
    25.085   325.248     0.150
    25.110   326.010     0.150
    26.951   342.299     0.150
    26.951   384.600     0.150
    27.009   343.699     0.150
    27.009   384.699     0.150
    27.009   344.289     0.150
    28.613   357.398     0.150
    28.638   357.998     0.150
    28.656   357.949     0.150
    28.656   357.898     0.150
    28.663   357.979     0.150
    28.663   357.318     0.150
    28.663   357.869     0.150
    28.666   357.799     0.150
    28.756   358.799     0.150
    29.274   363.398     0.150
    29.349   364.289     0.150
    29.421   367.279     0.150
    30.256   372.998     0.150
    30.314   372.139     0.150
    30.317   373.498     0.150
    30.358   373.699     0.150
    30.931   379.148     0.150
    31.450   384.100     0.150
    31.586   385.299     0.150
    31.685   385.020     0.150
    31.837   387.129     0.150
    31.856   384.578     0.150
    32.165   390.539     0.150
    32.224   391.100     0.150
    32.352   390.699     0.150
    32.397   390.029     0.150
    32.454   392.568     0.150
    32.661   394.398     0.150
    32.939   395.398     0.150
    33.049   397.908     0.150
    33.242   399.398     0.150
    33.290   397.199     0.150
    33.404   400.578     0.150
    33.404   398.279     0.150
    33.383   399.199     0.150
    33.513   400.078     0.150
    33.610   400.779     0.150
    33.849   405.459     0.150
    33.849   406.168     0.150
    33.887   405.488     0.150
    33.887   403.529     0.150
    33.961   405.898     0.150
    34.261   409.129     0.150
    34.342   410.398     0.150
    34.571   410.168     0.150
    34.924   414.449     0.150
    34.940   413.859     0.150
    34.982   412.699     0.150
    35.121   415.398     0.150
    35.136   416.049     0.150
    35.208   415.229     0.150
    35.208   415.100     0.150
    35.276   416.779     0.150
    35.298   417.629     0.150
    35.399   416.295     0.150
    35.399   415.818     0.150
    35.406   417.199     0.150
    35.397   417.559     0.150
    35.436   418.510     0.150
    35.539   419.350     0.150
    35.595   420.299     0.150
    35.677   420.279     0.150
    35.681   421.600     0.150
    35.681   421.209     0.150
    35.843   421.418     0.150
    35.843   421.799     0.150
    36.101   423.600     0.150
    36.098   423.729     0.150
    36.230   425.588     0.150
    36.278   424.791     0.150
    36.333   425.879     0.150
    36.328   424.498     0.150
    36.328   424.350     0.150
    36.328     2.961     0.150
    36.332   424.318     0.150
    36.358   425.898     0.150
    36.458   426.662     0.150
    36.534   427.479     0.150
    36.534   426.148     0.150
    36.523   424.959     0.150
    36.523   425.949     0.150
    36.523   569.498     0.150
    36.523   424.959     0.150
    36.523   568.549     0.150
    36.587   428.969     0.150
    36.537   426.199     0.150
    36.621   428.180     0.150
    36.621   428.838     0.150
    36.630   428.959     0.150
    36.695   429.408     0.150
    36.782   428.408     0.150
    36.752   430.709     0.150
    36.802   429.318     0.150
    36.774   429.408     0.150
    36.774   428.309     0.150
    36.774   429.555     0.150
    36.836   427.398     0.150
    36.774   429.338     0.150
    36.801   429.648     0.150
    36.876   430.189     0.150
    36.929   431.074     0.150
    37.047   431.838     0.150
    37.353   433.578     0.150
    37.416   434.609     0.150
    37.420   435.625     0.150
    37.528   435.100     0.150
    37.520   433.779     0.150
    37.654   437.158     0.150
    37.654   436.887     0.150
    37.668   435.498     0.150
    37.707   438.459     0.150
    37.805   438.430     0.150
    37.966   439.729     0.150
    38.007   439.139     0.150
    38.040   439.699     0.150
    38.044   439.994     0.150
    38.070   439.760     0.150
    38.071   440.201     0.150
    38.084   439.049     0.150
    38.084   574.873     0.150
    38.084   440.689     0.150
    38.102   438.760     0.150
    38.095   440.418     0.150
    38.132   440.838     0.150
    38.265   442.088     0.150
    38.309   442.469     0.150
    38.406   442.949     0.150
    38.466   442.699     0.150
    38.638   445.588     0.150
    38.641   444.988     0.150
    38.715   445.668     0.150
    38.739   446.059     0.150
    38.794   447.369     0.150
    38.822   446.598     0.150
    38.875   445.449     0.150
    38.993   448.680     0.150
    38.998   448.969     0.150
    39.096   448.289     0.150
    39.050   447.338     0.150
    39.147   449.418     0.150
    39.194   450.979     0.150
    38.884   448.078     0.150
    39.178   448.488     0.150
    39.246   448.799     0.150
    39.421   451.158     0.150
    39.462   452.066     0.150
    39.520   453.180     0.150
    39.555   453.668     0.150
    39.693   454.760     0.150
    39.784   453.512     0.150
    39.834   454.729     0.150
    39.856   455.510     0.150
    39.934   455.959     0.150
    39.950   455.859     0.150
    40.041   457.139     0.150
    40.041   457.270     0.150
    40.014   455.225     0.150
    40.043   455.998     0.150
    40.090   456.949     0.150
    40.151   457.273     0.150
    40.286   457.449     0.150
    40.286   456.908     0.150
    40.345   458.459     0.150
    40.422   460.299     0.150
    40.456   459.119     0.150
    40.582   461.219     0.150
    40.637   460.719     0.150
    40.617   460.789     0.150
    40.654   462.479     0.150
    40.662   462.699     0.150
    41.047   464.123     0.150
    41.047   463.529     0.150
    41.032   463.648     0.150
    41.059   464.889     0.150
    41.091   464.789     0.150
    41.251   465.668     0.150
    41.347   466.719     0.150
    41.347   466.998     0.150
    41.389   466.799     0.150
    41.480   469.229     0.150
    41.535   468.770     0.150
    41.551   468.059     0.150
    41.562   467.949     0.150
    41.545   468.010     0.150
    41.583   468.600     0.150
    41.583   467.799     0.150
    41.583   468.699     0.150
    41.583   468.850     0.150
    41.595   468.859     0.150
    41.625   469.020     0.150
    41.717   470.998     0.150
    41.781   471.180     0.150
    41.752   469.398     0.150
    41.782   470.469     0.150
    41.868   471.600     0.150
    42.021   472.838     0.150
    42.192   474.738     0.150
    42.229   474.549     0.150
    42.262   474.709     0.150
    42.336   475.648     0.150
    42.416   476.279     0.150
    42.425   476.068     0.150
    42.425   474.668     0.150
    42.430   475.510     0.150
    42.474   476.639     0.150
    42.494   476.760     0.150
    42.470   476.369     0.150
    42.597   477.668     0.150
    42.626   477.809     0.150
    42.645   477.418     0.150
    42.479   476.523     0.150
    42.479   475.699     0.150
    42.664   478.059     0.150
    42.618   477.180     0.150
    42.620   478.174     0.150
    42.620   477.219     0.150
    42.620   478.600     0.150
    42.841   480.078     0.150
    42.809   479.168     0.150
    42.939   480.119     0.150
    42.953   479.529     0.150
    42.992   481.299     0.150
    43.130   481.889     0.150
    43.125   482.029     0.150
    43.354   483.738     0.150
    43.546   487.088     0.150
    43.550   486.199     0.150
    43.629   485.879     0.150
    43.657   486.139     0.150
    43.988   489.068     0.150
    43.960   488.779     0.150
    44.131   490.559     0.150
    44.264   491.010     0.150
    44.348   491.869     0.150
    44.484   493.219     0.150
    44.486   493.350     0.150
    44.455   491.969     0.150
    44.455   491.379     0.150
    44.710   493.930     0.150
    45.568   500.600     0.150
    45.671   502.189     0.150
    45.671   501.100     0.150
    45.671   501.898     0.150
    45.671   501.699     0.150
    46.074   504.059     0.150
    46.072   503.949     0.150
    46.396   507.430     0.150
    47.178   515.289     0.150
    47.515   515.898     0.150
    47.593   516.609     0.150
    47.733   517.873     0.150
    47.733   518.299     0.150
    48.324   522.100     0.150
    48.528   524.174     0.150
    48.555   524.918     0.150
    48.555   526.199     0.150
    48.538   524.408     0.150
    48.727   526.248     0.150
    48.889   526.729     0.150
    48.889   527.068     0.150
    48.889   527.379     0.150
    49.343   530.498     0.150
    49.706   532.969     0.150
    50.254   537.318     0.150
    50.254   536.898     0.150
    50.351   538.109     0.150
    50.351   537.439     0.150
    50.475   538.898     0.150
    50.456   538.689     0.150
    50.836   541.260     0.150
    50.950   542.148     0.150
    51.035   544.699     0.150
    51.637   548.100     0.150
    51.721   548.299     0.150
    51.769   548.898     0.150
    51.760   548.158     0.150
    51.761   548.299     0.150
    51.761   548.059     0.150
    52.087   550.799     0.150
    52.083   550.600     0.150
    52.083   550.789     0.150
    52.348   554.299     0.150
    52.354   552.998     0.150
    52.664   554.998     0.150
    52.995   556.488     0.150
    53.145   558.869     0.150
    53.405   559.498     0.150
    53.405   558.949     0.150
    53.405   559.469     0.150
    54.176   566.918     0.150
    54.303   567.180     0.150
    54.445   568.219     0.150
    54.445   567.799     0.150
    54.595   569.389     0.150
    54.688   569.629     0.150
    54.910   571.799     0.150
    55.110   572.869     0.150
    55.184   574.949     0.150
    56.501   582.629     0.150
    57.304   589.189     0.150
    59.142   601.100     0.150
    59.142   601.309     0.150
    60.364   611.109     0.150
    62.001   623.619     0.150
    63.439   631.738     0.150
    66.693   651.818     0.150
    67.227   653.975     0.150
    67.227   654.498     0.150
    68.194   661.969     0.150
    68.194   660.969     0.150
    68.194   662.100     0.150
    68.651   663.799     0.150
    68.651   663.248     0.150
    68.651     3.451     0.150
    70.093   670.789     0.150
    71.867   682.748     0.150
    71.867   682.998     0.150
    75.968   707.449     0.150
    76.515   710.418     0.150
    76.646   711.578     0.150
    76.705   712.318     0.150
    76.705   711.289     0.150
    77.458   716.289     0.150
    78.088   720.129     0.150
    78.088   719.699     0.150
    78.352   720.949     0.150
    78.352   720.799     0.150
    78.411   721.359     0.150
    79.251   726.498     0.150
    80.779   734.318     0.150
    80.822   734.369     0.150
    80.964   734.799     0.150
    83.163   746.449     0.150
    83.163   746.068     0.150
    83.163   746.799     0.150
    83.441   748.359     0.150
    83.441   748.020     0.150
    83.540   748.949     0.150
    87.503   767.998     0.150
    87.503   767.729     0.150
    87.506   767.998     0.150
    89.482   777.449     0.150
    89.482   777.789     0.150
    89.930   779.379     0.150
    90.005   780.100     0.150
    91.810   788.770     0.150
   114.945  1121.148     0.150
   124.455  1137.818     0.150
   127.746  1144.600     0.150
   131.925  1155.898     0.150
   142.335  1173.373     0.150
     1.487    27.516     0.150
     1.487    27.637     0.150
     1.698    29.816     0.150
     1.837    33.418     0.150
     2.007    35.266     0.150
     2.289    39.918     0.150
     2.372    40.016     0.150
     2.387    40.117     0.150
     2.570    42.816     0.150
     2.604    44.016     0.150
     2.823    47.508     0.150
     3.033    49.715     0.150
     3.269    53.316     0.150
     3.564    56.617     0.150
     3.564    56.465     0.150
     3.861    61.918     0.150
     3.961    62.215     0.150
     3.961    62.586     0.150
     4.027    63.918     0.150
     4.135    64.348     0.150
     4.142    64.117     0.150
     4.466    69.816     0.150
     4.482    68.918     0.150
     4.528    70.617     0.150
     4.528    83.891     0.150
     4.528   147.113     0.150
     4.652    71.215     0.150
     4.673    71.715     0.150
     4.792    74.488     0.150
     5.210    79.117     0.150
     5.634    85.816     0.150
     5.690    86.117     0.150
     5.759    86.816     0.150
     5.841    88.445     0.150
     5.935    89.715     0.150
     6.052    91.215     0.150
     6.198    92.668     0.150
     6.549    97.828     0.150
     6.634    99.316     0.150
     6.887   103.016     0.150
     7.119   104.328     0.150
     7.119   105.277     0.150
     7.146   105.715     0.150
     7.146   105.867     0.150
     7.843   115.926     0.150
     8.194   120.215     0.150
     8.207   121.016     0.150
     8.506   124.816     0.150
     8.724   127.215     0.150
     8.844   129.535     0.150
     8.890   128.266     0.150
     8.955   131.258     0.150
     9.232   132.777     0.150
     9.408   138.117     0.150
     9.408   136.938     0.150
     9.844   142.828     0.150
     9.985   142.566     0.150
    10.630   150.895     0.150
    10.765   153.523     0.150
    10.765   269.496     0.150
    10.765   153.316     0.150
    10.765   269.918     0.150
    10.765   152.977     0.150
    10.962   154.965     0.150
    11.786   168.316     0.150
    11.786   300.617     0.150
    12.098   170.328     0.150
    12.636   179.137     0.150
    12.636   179.484     0.150
    12.636   317.734     0.150
    12.636   178.285     0.150
    12.636   178.699     0.150
    12.636   318.516     0.150
    12.636   178.918     0.150
    13.110   186.297     0.150
    13.450   188.117     0.150
    14.079   197.418     0.150
    14.079   197.816     0.150
    14.266   202.996     0.150
    14.324   199.348     0.150
    14.693   205.516     0.150
    14.693   205.723     0.150
    14.693   365.887     0.150
    14.693   205.977     0.150
    14.752   209.938     0.150
    14.752   217.215     0.150
    14.752   210.836     0.150
    14.913   211.105     0.150
    15.048   215.617     0.150
    15.393   217.145     0.150
    15.649   216.160     0.150
    15.646   220.977     0.150
    15.779   221.488     0.150
    16.058   222.391     0.150
    16.058   394.168     0.150
    16.058   396.328     0.150
    16.135   223.977     0.150
    16.135   223.371     0.150
    16.477   230.977     0.150
    17.259   243.316     0.150
    17.321   240.867     0.150
    17.321   241.715     0.150
    17.321   240.316     0.150
    17.355   243.137     0.150
    17.483   243.516     0.150
    17.556   244.707     0.150
    17.556   243.488     0.150
    17.556   244.316     0.150
    17.556   439.617     0.150
    18.051   249.586     0.150
    18.124   250.246     0.150
    18.124   250.715     0.150
    18.124   250.348     0.150
    18.918   262.156     0.150
    19.083   264.617     0.150
    19.344   265.918     0.150
    19.344   472.965     0.150
    19.348   264.156     0.150
    19.348   265.117     0.150
    19.348   265.547     0.150
    19.382   265.156     0.150
    19.382   264.469     0.150
    19.382   265.855     0.150
    19.398   267.516     0.150
    19.398   484.215     0.150
    19.558   268.191     0.150
    19.558   268.816     0.150
    19.558   268.016     0.150
    19.558   267.438     0.150
    19.597   269.418     0.150
    19.737   272.016     0.150
    20.028   273.867     0.150
    20.028   272.641     0.150
    20.135   275.516     0.150
    20.135   273.938     0.150
    20.135   274.816     0.150
    20.199   277.137     0.150
    20.445   277.816     0.150
    20.889   285.238     0.150
    20.986   287.016     0.150
    21.050   285.086     0.150
    21.233   286.516     0.150
    21.323   288.805     0.150
    21.410   287.715     0.150
    21.838   293.617     0.150
    21.900   294.660     0.150
    21.900   532.184     0.150
    21.900   293.418     0.150
    21.900   294.316     0.150
    21.900   313.816     0.150
    21.900   537.117     0.150
    22.112   296.215     0.150
    22.114   297.926     0.150
    22.114   297.547     0.150
    22.291   300.168     0.150
    22.469   301.918     0.150
    22.659   302.008     0.150
    22.659   533.848     0.150
    22.659   551.895     0.150
    23.086   307.715     0.150
    23.086   307.867     0.150
    23.086   307.355     0.150
    23.086   308.418     0.150
    23.378   308.918     0.150
    23.367   310.566     0.150
    23.367   310.418     0.150
    23.487   311.348     0.150
    23.630   313.215     0.150
    23.617   314.496     0.150
    23.646   314.816     0.150
    23.745   314.125     0.150
    23.991   315.816     0.150
    24.338   318.617     0.150
    25.118   325.617     0.150
    25.118   325.316     0.150
    25.118   325.215     0.150
    25.146   326.578     0.150
    25.381   328.867     0.150
    25.381   328.715     0.150
    26.060   334.395     0.150
    26.753   341.918     0.150
    26.946   344.016     0.150
    27.003   343.684     0.150
    27.003   344.016     0.150
    27.003   385.516     0.150
    28.598   357.816     0.150
    28.623   357.516     0.150
    28.640   357.816     0.150
    28.640   356.855     0.150
    28.640   357.316     0.150
    28.640   357.117     0.150
    28.647   357.918     0.150
    28.647   357.195     0.150
    28.647   358.316     0.150
    28.647   357.707     0.150
    28.647     4.410     0.150
    28.651   357.816     0.150
    28.741   358.316     0.150
    28.920   362.465     0.150
    29.257   362.516     0.150
    29.322   364.578     0.150
    29.398   367.238     0.150
    29.398   365.961     0.150
    30.294   372.266     0.150
    30.295   373.926     0.150
    30.398   374.316     0.150
    30.909   379.066     0.150
    30.949   377.625     0.150
    30.949   437.926     0.150
    30.949   681.988     0.150
    30.949   782.777     0.150
    31.430   383.805     0.150
    31.564   385.516     0.150
    31.816   387.906     0.150
    32.145   390.047     0.150
    32.334   391.137     0.150
    32.431   392.367     0.150
    33.223   400.117     0.150
    33.355   399.016     0.150
    33.393   400.375     0.150
    33.393   398.988     0.150
    33.393   400.016     0.150
    33.616   399.977     0.150
    33.830   405.855     0.150
    33.867   405.047     0.150
    33.905   405.391     0.150
    34.000   406.215     0.150
    34.323   409.016     0.150
    34.549   410.828     0.150
    34.918   413.395     0.150
    35.115   414.906     0.150
    35.160   416.316     0.150
    35.204   415.625     0.150
    35.204   415.516     0.150
    35.270   416.688     0.150
    35.376   417.785     0.150
    35.438   417.477     0.150
    35.438   417.086     0.150
    35.451   418.016     0.150
    35.455   419.637     0.150
    35.515   418.746     0.150
    35.515   418.238     0.150
    35.658   420.258     0.150
    35.661   420.848     0.150
    35.661   421.117     0.150
    35.882   422.105     0.150
    35.882   420.477     0.150
    36.074   423.465     0.150
    36.257   425.223     0.150
    36.313   425.645     0.150
    36.359   424.316     0.150
    36.359   424.176     0.150
    36.363   424.227     0.150
    36.394   426.215     0.150
    36.516   428.336     0.150
    36.516   426.777     0.150
    36.553   426.066     0.150
    36.553   425.965     0.150
    36.568   425.617     0.150
    36.566   427.574     0.150
    36.586   426.215     0.150
    36.604   428.238     0.150
    36.612   428.965     0.150
    36.697   428.566     0.150
    36.753   429.285     0.150
    36.746   427.496     0.150
    36.787   429.395     0.150
    36.787   429.016     0.150
    36.877   430.016     0.150
    36.909   430.727     0.150
    36.930   430.918     0.150
    37.065   432.059     0.150
    37.351   433.805     0.150
    37.394   434.996     0.150
    37.399   435.207     0.150
    37.553   433.418     0.150
    37.634   436.746     0.150
    37.634   436.449     0.150
    37.650   435.445     0.150
    37.786   438.047     0.150
    37.969   439.625     0.150
    38.018   439.578     0.150
    38.048   439.727     0.150
    38.064   439.766     0.150
    38.064   439.590     0.150
    38.073   440.207     0.150
    38.085   438.805     0.150
    38.110   441.016     0.150
    38.164   440.977     0.150
    38.233   441.156     0.150
    38.266   442.246     0.150
    38.351   443.086     0.150
    38.471   443.207     0.150
    38.620   444.867     0.150
    38.640   445.285     0.150
    38.694   445.352     0.150
    38.721   446.316     0.150
    38.721     4.102     0.150
    38.721   538.316     0.150
    38.800   446.055     0.150
    38.852   446.395     0.150
    39.078   448.836     0.150
    39.078   448.406     0.150
    39.098   449.676     0.150
    38.915   448.828     0.150
    39.208   450.277     0.150
    39.400   450.652     0.150
    39.406   450.926     0.150
    39.536   453.395     0.150
    39.676   454.535     0.150
    39.839   455.406     0.150
    39.918   456.055     0.150
    40.021   456.125     0.150
    40.045   456.418     0.150
    40.051   456.895     0.150
    40.092   457.078     0.150
    40.143   457.492     0.150
    40.289   458.641     0.150
    40.289   457.727     0.150
    40.350   459.227     0.150
    40.350   458.336     0.150
    40.435   459.395     0.150
    40.584   460.707     0.150
    40.595   460.625     0.150
    40.609   461.195     0.150
    40.637   462.656     0.150
    40.647   462.645     0.150
    41.040   464.738     0.150
    41.082   464.215     0.150
    41.082   463.715     0.150
    41.228   465.508     0.150
    41.339   466.656     0.150
    41.339   466.617     0.150
    41.418   466.547     0.150
    41.484   469.125     0.150
    41.524   467.875     0.150
    41.544   467.758     0.150
    41.555   468.215     0.150
    41.575   468.215     0.150
    41.575   468.543     0.150
    41.570   468.637     0.150
    41.604   468.938     0.150
    41.719   470.488     0.150
    41.754   470.117     0.150
    41.754   469.258     0.150
    41.781   471.227     0.150
    41.783   470.117     0.150
    41.862   471.277     0.150
    42.002   471.836     0.150
    42.193   474.258     0.150
    42.228   473.926     0.150
    42.260   474.766     0.150
    42.315   476.445     0.150
    42.393   475.297     0.150
    42.404   475.668     0.150
    42.404   475.395     0.150
    42.446   476.035     0.150
    42.494   476.477     0.150
    42.594   477.355     0.150
    42.589   478.266     0.150
    42.624   477.785     0.150
    42.622   478.785     0.150
    42.645   478.316     0.150
    42.786   479.328     0.150
    42.806   479.117     0.150
    42.929   479.828     0.150
    43.024   482.418     0.150
    43.118   480.848     0.150
    43.108   481.645     0.150
    43.091   480.977     0.150
    43.330   483.508     0.150
    43.540   486.238     0.150
    43.610   487.195     0.150
    44.432   492.066     0.150
    44.432   491.727     0.150
    44.463   493.516     0.150
    44.689   494.008     0.150
    45.541   500.266     0.150
    45.634   501.605     0.150
    46.049   503.875     0.150
    46.372   507.305     0.150
    47.185   515.008     0.150
    47.494   515.625     0.150
    47.741   517.543     0.150
    48.514   523.766     0.150
    48.514   523.766     0.150
    48.897   527.477     0.150
    48.897   526.316     0.150
    49.181   529.215     0.150
    49.323   529.445     0.150
    50.219   536.578     0.150
    50.283   537.105     0.150
    50.283   536.246     0.150
    50.283   535.961     0.150
    50.283   537.316     0.150
    50.315   537.836     0.150
    50.315   537.207     0.150
    50.433   538.477     0.150
    50.859   541.617     0.150
    51.021   542.746     0.150
    51.735   548.141     0.150
    51.735   547.555     0.150
    52.057   550.316     0.150
    52.057   550.625     0.150
    52.125   550.359     0.150
    52.125   550.918     0.150
    52.394   551.867     0.150
    52.394   552.965     0.150
    52.637   554.996     0.150
    53.121   558.785     0.150
    53.445   559.992     0.150
    54.151   566.906     0.150
    54.312   567.426     0.150
    54.450   568.328     0.150
    54.565   569.195     0.150
    54.662   569.805     0.150
    55.084   572.895     0.150
    55.238   573.465     0.150
    57.274   588.047     0.150
    58.177   592.238     0.150
    59.984   608.016     0.150
    60.367   611.055     0.150
    60.447   610.879     0.150
    67.189   653.941     0.150
    68.156   660.297     0.150
    71.833   682.066     0.150
    73.702   694.285     0.150
    74.405   698.668     0.150
    75.093   702.527     0.150
    75.992   707.395     0.150
    78.111   720.297     0.150
    78.111   719.918     0.150
    78.375   720.965     0.150
    78.375   720.625     0.150
    79.273   726.047     0.150
    80.028   729.695     0.150
    80.802   734.156     0.150
    83.178   746.867     0.150
    83.467   748.965     0.150
    84.055   751.098     0.150
    87.529   767.516     0.150
    89.506   777.367     0.150
    89.506   777.766     0.150
   114.951  1177.992     0.150
   124.439  1137.336     0.150
   142.295  1172.941     0.150
     1.509    28.352     0.150
     1.509    49.148     0.150
     1.750    31.051     0.150
     1.843    34.148     0.150
     1.990    35.691     0.150
     2.291    40.352     0.150
     2.398    40.852     0.150
     2.439    41.551     0.150
     2.618    44.648     0.150
     2.621    44.250     0.150
     2.819    47.809     0.150
     3.045    50.449     0.150
     3.281    52.949     0.150
     3.615    57.750     0.150
     3.615    58.000     0.150
     3.864    61.648     0.150
     3.982    62.750     0.150
     3.982    63.070     0.150
     4.039    64.449     0.150
     4.181    65.141     0.150
     4.188    65.148     0.150
     4.473    70.051     0.150
     4.531    70.602     0.150
     4.531   147.863     0.150
     4.526    70.148     0.150
     4.697    72.852     0.150
     4.722    72.750     0.150
     4.800    74.789     0.150
     5.261    79.949     0.150
     5.648    86.051     0.150
     5.648    86.262     0.150
     5.741    87.449     0.150
     5.800    88.281     0.150
     5.810    88.148     0.150
     5.955    90.449     0.150
     6.103    92.250     0.150
     6.213    93.648     0.150
     6.223    93.570     0.150
     6.285    94.148     0.150
     6.285    94.371     0.150
     6.442    93.570     0.150
     6.597    99.039     0.150
     6.689   100.648     0.150
     6.685   100.250     0.150
     6.915   103.551     0.150
     6.971   104.051     0.150
     7.017   104.449     0.150
     7.069   104.352     0.150
     7.069   105.219     0.150
     7.195   107.352     0.150
     7.195   107.070     0.150
     7.242   107.949     0.150
     7.242   107.422     0.150
     7.647   113.750     0.150
     7.864   115.711     0.150
     7.888   116.449     0.150
     8.228   121.250     0.150
     8.251   122.449     0.150
     8.767   128.648     0.150
     8.801   129.148     0.150
     8.839   128.410     0.150
     8.882   130.410     0.150
     8.988   131.840     0.150
     9.132   132.520     0.150
     9.180   133.109     0.150
     9.188   135.641     0.150
     9.370   136.750     0.150
     9.370   137.766     0.150
     9.370   137.391     0.150
     9.590   139.238     0.150
     9.684   139.738     0.150
     9.766   141.961     0.150
     9.882   143.930     0.150
     9.934   142.629     0.150
     9.966   145.680     0.150
     9.966   257.855     0.150
     9.985   145.340     0.150
    10.008   145.586     0.150
    10.008   146.129     0.150
    10.008   260.703     0.150
    10.087   148.859     0.150
    10.228   149.559     0.150
    10.342   145.078     0.150
    10.579   151.109     0.150
    10.553   153.312     0.150
    10.553   154.117     0.150
    10.553   274.426     0.150
    10.563   153.938     0.150
    10.633   276.980     0.150
    10.715   153.375     0.150
    10.715   269.418     0.150
    10.715   153.070     0.150
    10.910   154.559     0.150
    10.914   158.609     0.150
    10.914   157.719     0.150
    10.914   159.402     0.150
    10.914   158.938     0.150
    10.968   156.840     0.150
    10.968   279.602     0.150
    11.049   159.348     0.150
    11.049   161.090     0.150
    11.079   157.230     0.150
    11.101   160.652     0.150
    11.101   160.973     0.150
    11.206   162.234     0.150
    11.206   162.996     0.150
    11.344   165.027     0.150
    11.522   167.094     0.150
    11.562   167.461     0.150
    11.606   168.621     0.150
    11.736   168.551     0.150
    11.736   298.949     0.150
    11.769   169.977     0.150
    11.776   171.289     0.150
    11.890   170.992     0.150
    12.046   170.191     0.150
    12.068   174.637     0.150
    12.171   173.191     0.150
    12.174   175.781     0.150
    12.260   176.871     0.150
    12.260   177.875     0.150
    12.299   178.398     0.150
    12.512   182.078     0.150
    12.585   178.602     0.150
    12.585   178.918     0.150
    12.585   317.969     0.150
    12.585   178.199     0.150
    12.585   178.457     0.150
    12.585   179.047     0.150
    12.585   178.781     0.150
    12.599   180.750     0.150
    12.599   181.434     0.150
    12.716   180.879     0.150
    12.871   182.320     0.150
    12.948   183.020     0.150
    12.960   182.770     0.150
    13.142   188.715     0.150
    13.213   189.109     0.150
    13.330   192.332     0.150
    13.399   188.949     0.150
    13.388   191.750     0.150
    13.388   341.148     0.150
    13.415   190.070     0.150
    13.469   190.699     0.150
    13.559   196.270     0.150
    13.785   198.051     0.150
    13.785   352.449     0.150
    13.873   196.691     0.150
    13.851   197.246     0.150
    13.958   200.750     0.150
    13.958   357.051     0.150
    14.028   197.352     0.150
    14.008   197.648     0.150
    14.008   352.551     0.150
    14.082   200.852     0.150
    14.082   202.801     0.150
    14.213   202.789     0.150
    14.273   198.980     0.150
    14.273   201.148     0.150
    14.275   202.852     0.150
    14.288   204.539     0.150
    14.316   202.828     0.150
    14.444   202.648     0.150
    14.444   366.012     0.150
    14.664   205.750     0.150
    14.664   205.902     0.150
    14.664   360.457     0.150
    14.664   207.031     0.150
    14.773   213.645     0.150
    14.773   209.441     0.150
    14.773   213.148     0.150
    14.773   213.469     0.150
    14.926   211.590     0.150
    14.995   210.852     0.150
    15.055   210.672     0.150
    15.077   216.270     0.150
    15.259   213.711     0.150
    15.342   218.602     0.150
    15.408   217.441     0.150
    15.602   216.742     0.150
    15.631   218.691     0.150
    15.673   221.898     0.150
    15.700   219.379     0.150
    15.700   394.602     0.150
    15.798   224.250     0.150
    16.273   227.500     0.150
    16.032   223.500     0.150
    16.032   395.180     0.150
    16.032   223.191     0.150
    16.032   391.863     0.150
    16.084   222.648     0.150
    16.256   227.691     0.150
    17.194   239.352     0.150
    17.272   243.750     0.150
    17.333   241.875     0.150
    17.333   240.852     0.150
    17.385   243.578     0.150
    17.451   243.520     0.150
    17.451   245.336     0.150
    17.495   244.352     0.150
    17.567   243.621     0.150
    17.567   244.949     0.150
    17.567   244.551     0.150
    17.567   439.449     0.150
    17.622   246.898     0.150
    17.622   453.602     0.150
    18.016   252.449     0.150
    18.090   250.359     0.150
    18.176   251.898     0.150
    18.176   252.352     0.150
    18.176   252.691     0.150
    18.176   252.570     0.150
    18.223   255.016     0.150
    18.283   253.691     0.150
    18.456   257.531     0.150
    18.915   262.758     0.150
    19.052   262.352     0.150
    19.134   265.750     0.150
    19.248   265.148     0.150
    19.302   265.898     0.150
    19.306   265.070     0.150
    19.306   265.641     0.150
    19.330   264.961     0.150
    19.330   263.969     0.150
    19.330   266.148     0.150
    19.330   265.141     0.150
    19.412   270.352     0.150
    19.434   270.410     0.150
    19.434   268.352     0.150
    19.489   268.012     0.150
    19.506   266.973     0.150
    19.506   267.750     0.150
    19.506   268.000     0.150
    19.565   269.352     0.150
    19.746   272.148     0.150
    19.979   274.727     0.150
    20.086   274.852     0.150
    20.086   274.199     0.150
    20.086   273.930     0.150
    20.086   275.805     0.150
    20.229   277.730     0.150
    20.499   281.949     0.150
    20.499   501.000     0.150
    20.607   278.391     0.150
    20.919   285.570     0.150
    21.019   283.441     0.150
    21.202   286.852     0.150
    21.359   287.750     0.150
    21.370   290.148     0.150
    21.370   525.051     0.150
    21.452   289.648     0.150
    21.806   293.449     0.150
    21.828   565.852     0.150
    21.828   294.309     0.150
    21.871   294.918     0.150
    21.871   532.770     0.150
    21.871   294.371     0.150
    21.871   294.648     0.150
    21.871   315.449     0.150
    21.871   537.449     0.150
    21.871   563.852     0.150
    22.108   296.250     0.150
    22.145   298.676     0.150
    22.153   298.488     0.150
    22.153   298.102     0.150
    22.189   298.551     0.150
    22.189   544.148     0.150
    22.331   300.289     0.150
    22.413   300.930     0.150
    22.413   301.340     0.150
    22.438   300.750     0.150
    22.654   301.199     0.150
    22.654   533.641     0.150
    22.654   550.691     0.150
    22.654   302.980     0.150
    22.865   307.309     0.150
    23.096   307.391     0.150
    23.109   307.852     0.150
    23.112   308.551     0.150
    23.112   309.000     0.150
    23.112   307.730     0.150
    23.112   308.449     0.150
    23.161   308.352     0.150
    23.377   308.852     0.150
    23.424   309.129     0.150
    23.409   311.391     0.150
    23.409   312.551     0.150
    23.521   311.398     0.150
    23.521   311.578     0.150
    23.521   313.051     0.150
    23.628   313.750     0.150
    23.643   313.711     0.150
    23.660   314.250     0.150
    23.771   314.820     0.150
    23.771   313.629     0.150
    23.902   315.012     0.150
    23.939   316.148     0.150
    24.315   319.570     0.150
    24.335   319.051     0.150
    25.026   324.578     0.150
    25.069   325.750     0.150
    25.069   325.699     0.150
    25.069   324.672     0.150
    25.108   326.711     0.150
    25.314   329.926     0.150
    25.360   329.352     0.150
    25.360   329.148     0.150
    25.531   330.551     0.150
    25.531   330.270     0.150
    25.987   333.691     0.150
    26.384   336.480     0.150
    26.446   337.719     0.150
    26.874   341.762     0.150
    26.938   342.449     0.150
    26.938   384.148     0.150
    26.997   344.148     0.150
    26.997   623.852     0.150
    26.997   343.980     0.150
    26.997   343.449     0.150
    27.368   347.852     0.150
    27.522   348.051     0.150
    27.575   346.949     0.150
    27.584   349.547     0.150
    27.751   350.660     0.150
    27.838   351.191     0.150
    27.838   352.051     0.150
    28.055   353.750     0.150
    28.096   352.711     0.150
    28.175   356.484     0.150
    28.365   356.648     0.150
    28.603   357.852     0.150
    28.603     3.000     0.150
    28.629   358.051     0.150
    28.646   358.273     0.150
    28.646   547.301     0.150
    28.646   357.539     0.150
    28.646   358.250     0.150
    28.646   358.449     0.150
    28.653   358.320     0.150
    28.653   357.539     0.150
    28.653   358.648     0.150
    28.653     3.188     0.150
    28.653   358.852     0.150
    28.732   358.359     0.150
    28.747   360.449     0.150
    28.802   359.289     0.150
    28.893   362.402     0.150
    28.935   362.320     0.150
    28.935   362.852     0.150
    28.941   363.914     0.150
    28.940   362.051     0.150
    28.986   363.648     0.150
    28.986   363.664     0.150
    29.040   361.359     0.150
    29.120   361.941     0.150
    29.161   365.867     0.150
    29.173   364.184     0.150
    29.249   365.695     0.150
    29.265   363.852     0.150
    29.301   364.480     0.150
    29.346   365.102     0.150
    29.414   367.078     0.150
    84.119     3.703     0.150
    29.874   370.121     0.150
    30.030   371.949     0.150
    30.242   374.250     0.150
    30.289   374.148     0.150
    30.311   374.051     0.150
    30.311   374.484     0.150
    30.349   374.648     0.150
    30.349   675.551     0.150
    30.768   379.070     0.150
    30.949   378.352     0.150
    30.949   438.629     0.150
    30.949   683.289     0.150
    30.949   784.129     0.150
    30.925   378.988     0.150
    30.925   379.617     0.150
    31.117   381.449     0.150
    31.196   381.750     0.150
    31.288   382.367     0.150
    31.300   382.367     0.150
    31.443   384.480     0.150
    31.472   385.508     0.150
    31.548   384.738     0.150
    31.549   385.305     0.150
    31.580   385.648     0.150
    31.614   385.051     0.150
    31.674   385.422     0.150
    31.830   387.629     0.150
    31.830   388.051     0.150
    31.858   386.031     0.150
    32.157   390.281     0.150
    32.252   391.324     0.150
    32.294   392.453     0.150
    32.311   391.723     0.150
    32.343   391.711     0.150
    32.343   392.160     0.150
    32.447   392.762     0.150
    32.447   393.250     0.150
    32.463   393.730     0.150
    32.479   393.301     0.150
    32.479   394.148     0.150
    32.485   393.938     0.150
    32.518   393.160     0.150
    33.042   398.281     0.150
    33.254   399.789     0.150
    33.280   397.430     0.150
    33.280   397.738     0.150
    33.350   399.930     0.150
    33.380   399.352     0.150
    33.393   400.730     0.150
    33.393   399.730     0.150
    33.553   403.762     0.150
    33.567   403.309     0.150
    33.587   399.000     0.150
    33.840   406.289     0.150
    33.840   406.730     0.150
    33.880   405.449     0.150
    34.039   405.738     0.150
    34.248   409.539     0.150
    34.248   409.148     0.150
    34.248   408.781     0.150
    34.334   409.352     0.150
    34.413   408.750     0.150
    34.564   410.781     0.150
    34.564   411.344     0.150
    34.925   414.801     0.150
    34.934   414.012     0.150
    35.117   414.949     0.150
    35.129   415.789     0.150
    35.195   416.512     0.150
    35.263   416.910     0.150
    35.289   417.820     0.150
    35.386   417.648     0.150
    35.386   417.430     0.150
    35.391   418.211     0.150
    35.428   418.910     0.150
    35.467   419.461     0.150
    35.467   419.219     0.150
    35.533   419.230     0.150
    35.551   421.461     0.150
    35.587   420.949     0.150
    35.668   420.570     0.150
    35.668   421.250     0.150
    35.673   421.078     0.150
    35.673   420.949     0.150
    35.830   421.949     0.150
    35.830   422.141     0.150
    35.830   421.629     0.150
    35.830   421.820     0.150
    35.871   422.570     0.150
    36.053   421.719     0.150
    36.093   424.148     0.150
    36.093   423.352     0.150
    36.196   425.180     0.150
    36.196   424.648     0.150
    36.223   425.270     0.150
    36.271   425.574     0.150
    36.271   508.383     0.150
    36.330   424.609     0.150
    36.330   424.863     0.150
    36.330   424.379     0.150
    36.330     3.633     0.150
    36.334   424.750     0.150
    36.325   426.031     0.150
    36.325   425.816     0.150
    36.356   425.148     0.150
    36.361   425.012     0.150
    36.396   427.672     0.150
    36.451   427.152     0.150
    36.525   426.141     0.150
    36.525   426.352     0.150
    36.525   570.555     0.150
    36.525   426.211     0.150
    36.526   428.410     0.150
    36.526   427.148     0.150
    36.579   428.266     0.150
    36.579   514.598     0.150
    36.579   568.223     0.150
    36.613   429.000     0.150
    36.613   429.422     0.150
    36.621   429.262     0.150
    36.621   429.051     0.150
    36.648   428.781     0.150
    36.681   428.672     0.150
    36.727   429.750     0.150
    36.743   430.621     0.150
    36.743   430.750     0.150
    36.767   429.059     0.150
    36.767   429.852     0.150
    36.767   429.672     0.150
    36.767   430.074     0.150
    36.767   570.016     0.150
    36.797   429.441     0.150
    36.821   428.949     0.150
    36.862   430.352     0.150
    36.921   431.445     0.150
    36.921   517.469     0.150
    36.921   572.078     0.150
    37.039   432.020     0.150
    37.039   432.219     0.150
    37.080   432.570     0.150
    37.080   571.293     0.150
    37.339   434.328     0.150
    37.410   435.219     0.150
    37.410   435.355     0.150
    37.414   435.934     0.150
    37.476   435.898     0.150
    37.511   436.102     0.150
    37.511   434.648     0.150
    37.511   435.949     0.150
    37.647   437.078     0.150
    37.647   437.215     0.150
    37.660   435.770     0.150
    37.699   438.078     0.150
    37.797   438.480     0.150
    37.797   438.648     0.150
    37.951   440.051     0.150
    37.978   440.648     0.150
    37.996   440.039     0.150
    38.034   439.961     0.150
    38.037   440.406     0.150
    38.064   440.301     0.150
    38.064   440.688     0.150
    38.067   440.828     0.150
    38.077   440.773     0.150
    38.077   575.117     0.150
    38.077   439.699     0.150
    38.089   440.859     0.150
    38.094   439.109     0.150
    38.125   441.172     0.150
    38.127   440.891     0.150
    38.176   441.262     0.150
    38.208   440.891     0.150
    38.208   441.039     0.150
    38.250   442.691     0.150
    38.247   442.375     0.150
    38.299   442.738     0.150
    38.324   441.039     0.150
    38.372   443.570     0.150
    38.397   443.762     0.150
    38.459   443.051     0.150
    38.459   800.352     0.150
    38.459   443.219     0.150
    38.624   445.680     0.150
    38.634   445.340     0.150
    38.635   445.262     0.150
    38.708   445.699     0.150
    38.730   446.641     0.150
    38.730   537.250     0.150
    38.730   804.250     0.150
    38.730   974.250     0.150
    38.784   447.648     0.150
    38.815   446.711     0.150
    38.868   446.828     0.150
    38.985   449.160     0.150
    38.990   448.930     0.150
    39.000   449.379     0.150
    39.000   448.559     0.150
    39.054   447.559     0.150
    39.085   448.852     0.150
    39.109   449.641     0.150
    39.137   449.852     0.150
    38.886   448.570     0.150
    39.186   450.801     0.150
    39.236   449.352     0.150
    39.236   543.148     0.150
    39.347   451.609     0.150
    39.414   451.484     0.150
    39.421   451.500     0.150
    39.455   451.434     0.150
    39.461   452.840     0.150
    39.475   452.160     0.150
    39.488   453.422     0.150
    39.513   452.930     0.150
    39.520   453.051     0.150
    39.520   453.059     0.150
    39.546   453.750     0.150
    39.599   454.102     0.150
    39.613   453.559     0.150
    39.684   454.480     0.150
    39.683   455.398     0.150
    39.710   455.328     0.150
    39.706   453.578     0.150
    39.706   579.379     0.150
    39.743   455.230     0.150
    39.777   453.852     0.150
    39.777   579.578     0.150
    39.823   455.500     0.150
    39.847   455.672     0.150
    39.850   454.461     0.150
    39.925   456.031     0.150
    39.939   456.500     0.150
    39.980   457.250     0.150
    40.007   456.180     0.150
    40.007   455.871     0.150
    40.007   581.055     0.150
    40.026   457.012     0.150
    40.036   456.438     0.150
    40.036   548.441     0.150
    40.036   581.652     0.150
    40.076   457.480     0.150
    40.139   458.188     0.150
    40.252   459.449     0.150
    40.271   459.125     0.150
    40.271   551.824     0.150
    40.271   458.379     0.150
    40.334   459.820     0.150
    40.365   459.512     0.150
    40.413   460.949     0.150
    40.449   459.852     0.150
    40.567   460.648     0.150
    40.610   461.160     0.150
    40.610   558.852     0.150
    40.610   583.336     0.150
    40.626   461.320     0.150
    40.645   462.969     0.150
    40.652   462.910     0.150
    40.769   461.789     0.150
    40.998   465.699     0.150
    41.003   464.238     0.150
    41.032   464.648     0.150
    41.032   463.941     0.150
    41.052   465.762     0.150
    41.080   464.641     0.150
    41.247   468.629     0.150
    41.244   465.871     0.150
    41.294   467.148     0.150
    41.335   467.250     0.150
    41.439   467.762     0.150
    41.465   469.191     0.150
    41.539   468.051     0.150
    41.537   468.230     0.150
    41.551   470.309     0.150
    41.571   468.852     0.150
    41.571   468.250     0.150
    41.571   469.023     0.150
    41.590   469.090     0.150
    41.619   469.238     0.150
    41.631   468.719     0.150
    41.632   469.512     0.150
    41.632   470.250     0.150
    41.642   471.270     0.150
    41.702   471.250     0.150
    41.752   470.000     0.150
    41.752   469.820     0.150
    41.766   471.738     0.150
    41.855   472.102     0.150
    41.991   472.648     0.150
    42.010   473.051     0.150
    42.010   472.031     0.150
    42.054   474.020     0.150
    42.177   474.609     0.150
    42.215   475.000     0.150
    42.248   476.250     0.150
    42.248  1072.250     0.150
    42.248   475.309     0.150
    42.295   474.410     0.150
    42.295   474.781     0.150
    42.323   474.969     0.150
    42.324   476.750     0.150
    42.402   476.500     0.150
    42.407   475.488     0.150
    42.417   476.051     0.150
    42.417   475.480     0.150
    42.424   475.340     0.150
    42.433   477.488     0.150
    42.465   476.461     0.150
    42.480   476.852     0.150
    42.495   477.109     0.150
    42.495   477.352     0.150
    42.495   476.949     0.150
    42.495   476.621     0.150
    42.584   477.289     0.150
    42.588   477.711     0.150
    42.612   478.328     0.150
    42.613   477.789     0.150
    42.630   478.410     0.150
    42.618   479.250     0.150
    42.631   479.059     0.150
    42.650   478.488     0.150
    42.751   478.230     0.150
    42.804   478.988     0.150
    42.828   480.141     0.150
    42.756   480.551     0.150
    42.756   862.449     0.150
    42.947   480.379     0.150
    42.980   481.820     0.150
    42.980   481.602     0.150
    43.035   482.441     0.150
    43.035   482.262     0.150
    43.135   481.270     0.150
    43.114   482.840     0.150
    43.123   482.379     0.150
    43.141   482.539     0.150
    43.141   482.191     0.150
    43.348   484.020     0.150
    43.539   486.672     0.150
    43.621   487.289     0.150
    43.880   487.250     0.150
    43.954   488.551     0.150
    44.030   490.422     0.150
    44.030   591.430     0.150
    44.126   489.781     0.150
    44.215   492.070     0.150
    44.336   492.340     0.150
    44.415   492.750     0.150
    44.449   492.449     0.150
    44.449   492.309     0.150
    44.472   493.410     0.150
    44.475   493.398     0.150
    44.703   494.309     0.150
    45.010   497.250     0.150
    45.010   894.750     0.150
    45.041   496.352     0.150
    45.564   500.988     0.150
    45.564   500.730     0.150
    45.685   501.621     0.150
    45.685   502.090     0.150
    45.685     2.941     0.150
    46.069   504.602     0.150
    46.067   504.441     0.150
    46.390   507.789     0.150
    46.780   508.750     0.150
    47.013   513.648     0.150
    47.162   515.320     0.150
    47.508   516.320     0.150
    47.584   517.281     0.150
    47.717   519.164     0.150
    47.974   519.449     0.150
    48.518   524.449     0.150
    48.530   524.621     0.150
    48.532   524.590     0.150
    48.545   525.012     0.150
    48.545   524.281     0.150
    48.545   525.750     0.150
    48.545   524.590     0.150
    48.661   526.750     0.150
    48.718   526.059     0.150
    48.873   526.738     0.150
    48.873   528.148     0.150
    48.873   527.762     0.150
    49.129   528.449     0.150
    49.335   530.910     0.150
    49.690   533.012     0.150
    49.690   532.172     0.150
    49.690     2.738     0.150
    49.690   532.648     0.150
    49.690   610.551     0.150
    49.690   959.750     0.150
    49.690   976.551     0.150
    49.690  1120.551     0.150
    49.690  1173.551     0.150
    49.872   535.051     0.150
    50.238   537.340     0.150
    50.238   536.801     0.150
    50.238   537.219     0.150
    50.238   537.648     0.150
    50.223   538.012     0.150
    50.308   537.949     0.150
    50.353   538.520     0.150
    50.353   537.711     0.150
    50.353     2.367     0.150
    50.451   539.121     0.150
    50.466   539.469     0.150
    50.466   539.852     0.150
    50.842   542.320     0.150
    50.941   543.051     0.150
    51.025   544.199     0.150
    51.025   543.852     0.150
    51.626   547.250     0.150
    51.628   548.750     0.150
    51.760   550.148     0.150
    51.757   548.676     0.150
    51.757   621.559     0.150
    51.757   548.320     0.150
    52.073   551.449     0.150
    52.078   550.551     0.150
    52.078   551.039     0.150
    52.078   551.141     0.150
    52.225   553.551     0.150
    52.285   552.539     0.150
    52.344   552.730     0.150
    52.344   552.711     0.150
    52.338   553.648     0.150
    52.345   553.602     0.150
    52.424   554.750     0.150
    52.660   555.410     0.150
    52.991   556.898     0.150
    53.139   559.391     0.150
    53.393   560.410     0.150
    53.393   560.352     0.150
    53.393   560.180     0.150
    54.171   567.148     0.150
    54.287   567.629     0.150
    54.430   568.730     0.150
    54.430   568.590     0.150
    54.592   569.512     0.150
    54.684   570.301     0.150
    55.489   576.172     0.150
    55.658   577.711     0.150
    56.107   578.520     0.150
    56.420   583.879     0.150
    56.499   582.922     0.150
    57.302   589.102     0.150
    58.220   595.219     0.150
    58.218   596.191     0.150
    59.157   601.949     0.150
    59.157   602.121     0.150
    59.157   601.801     0.150
    59.784   606.250     0.150
    59.784  1098.148     0.150
    59.784  1334.648     0.150
    59.784   606.512     0.150
    59.784   605.590     0.150
    59.784     3.250     0.150
    59.936   607.051     0.150
    59.992   607.828     0.150
    59.992   609.012     0.150
    59.992   608.238     0.150
    60.349   610.551     0.150
    60.349   611.570     0.150
    60.395   610.121     0.150
    60.397   610.773     0.150
    60.397   609.922     0.150
    60.842   613.238     0.150
    60.842   612.719     0.150
    63.423   631.852     0.150
    63.423   631.422     0.150
    63.423   631.102     0.150
    64.046   635.129     0.150
    64.623   639.570     0.150
    66.271   648.574     0.150
    66.271   648.301     0.150
    66.823   653.648     0.150
    66.823  1183.250     0.150
    67.233   655.273     0.150
    67.233   655.102     0.150
    68.208   662.070     0.150
    68.208   661.852     0.150
    68.208     2.762     0.150
    68.666   664.148     0.150
    68.666   664.621     0.150
    69.524   672.320     0.150
    70.042   672.039     0.150
    71.119   680.449     0.150
    71.883   683.824     0.150
    71.883   683.199     0.150
    72.514   686.988     0.150
    73.535   693.898     0.150
    74.240   697.898     0.150
    74.923   701.641     0.150
    75.053   702.770     0.150
    75.538   704.219     0.150
    76.341   709.762     0.150
    76.688   712.680     0.150
    76.951   713.340     0.150
    77.188   714.980     0.150
    77.441   716.320     0.150
    78.071   720.629     0.150
    78.071   719.301     0.150
    78.335   721.602     0.150
    78.335   901.551     0.150
    78.335   720.922     0.150
    78.551   722.859     0.150
    79.218   725.699     0.150
    79.234   726.719     0.150
    80.010   730.250     0.150
    80.711   734.051     0.150
    80.762   734.961     0.150
    80.805   735.551     0.150
    83.146   747.574     0.150
    83.146   747.449     0.150
    83.424   749.410     0.150
    83.424   748.852     0.150
    83.523   749.051     0.150
    86.519   762.590     0.150
    87.508   768.176     0.150
    89.487   777.898     0.150
    89.487  1832.352     0.150
    89.487   777.281     0.150
    89.914   780.379     0.150
    89.914   779.621     0.150
    91.814   787.922     0.150
    92.390   791.691     0.150
    93.223   794.781     0.150
    93.223   794.648     0.150
    98.747   819.969     0.150
   114.929  1180.375     0.150
   114.929  1759.176     0.150
   124.472  1138.371     0.150
   124.472  1138.492     0.150
   127.752  1144.852     0.150
   131.926  1154.949     0.150
   131.926  1154.680     0.150
   142.344  1172.375     0.150
     1.527    27.776     0.150
     1.527    49.976     0.150
     1.527    48.986     0.150
     1.699    29.376     0.150
     1.699    29.816     0.150
     2.334    39.876     0.150
     2.387    40.176     0.150
     2.409    39.776     0.150
     2.561    42.676     0.150
     2.647    43.976     0.150
     2.869    47.566     0.150
     3.077    49.776     0.150
     3.313    53.276     0.150
     3.555    55.976     0.150
     3.555    56.226     0.150
     3.906    61.776     0.150
     4.002    62.376     0.150
     4.002    62.766     0.150
     4.071    64.076     0.150
     4.153    64.216     0.150
     4.159    64.076     0.150
     4.511    69.976     0.150
     4.504    68.876     0.150
     4.574    70.951     0.150
     4.574    84.976     0.150
     4.574   122.076     0.150
     4.574   147.226     0.150
     4.671    71.476     0.150
     4.687    71.476     0.150
     4.836    74.316     0.150
     5.072    76.336     0.150
     5.212    78.876     0.150
     5.677    85.876     0.150
     5.677    85.476     0.150
     5.681    85.476     0.150
     5.758    86.776     0.150
     5.815    88.176     0.150
     5.815    88.356     0.150
     5.815    88.646     0.150
     5.815    87.476     0.150
     5.815   152.257     0.150
     5.892    89.226     0.150
     5.892    90.721     0.150
     5.892    89.530     0.150
     5.892    97.621     0.150
     5.976    89.476     0.150
     6.041    90.676     0.150
     6.169    92.276     0.150
     6.218    92.776     0.150
     6.218    92.546     0.150
     6.236    92.836     0.150
     6.384    91.496     0.150
     6.563    97.266     0.150
     6.637    98.976     0.150
     6.687    99.776     0.150
     6.924   102.676     0.150
     6.977   104.076     0.150
     6.975   103.876     0.150
     7.132   104.946     0.150
     7.132   186.032     0.150
     7.173   106.076     0.150
     7.173   106.506     0.150
     7.157   106.076     0.150
     7.157   105.296     0.150
     7.253   107.876     0.150
     7.459   109.876     0.150
     7.646   112.876     0.150
     7.653   113.176     0.150
     7.862   115.116     0.150
     7.928   115.416     0.150
     8.055   118.576     0.150
     8.227   120.576     0.150
     8.227   120.776     0.150
     8.518   124.476     0.150
     8.521   124.576     0.150
     8.590   125.976     0.150
     8.699   127.876     0.150
     8.737   127.676     0.150
     8.737   128.736     0.150
     8.747   127.276     0.150
     8.763   128.276     0.150
     8.762   128.276     0.150
     8.872   129.166     0.150
     8.835   128.976     0.150
     8.894   128.726     0.150
     8.988   131.036     0.150
     9.044   132.276     0.150
     9.060   131.186     0.150
     9.231   132.946     0.150
     9.189   133.736     0.150
     9.380   136.876     0.150
     9.380   137.616     0.150
     9.380   137.815     0.150
     9.380   246.311     0.150
     9.378   136.676     0.150
     9.430   137.976     0.150
     9.522   138.786     0.150
     9.640   140.576     0.150
     9.749   247.527     0.150
     9.749   141.356     0.150
     9.759   142.076     0.150
     9.830   140.631     0.150
     9.830   143.126     0.150
     9.872   143.016     0.150
     9.900   143.867     0.150
     9.900   145.382     0.150
     9.900   255.931     0.150
     9.994   142.386     0.150
     9.932   144.606     0.150
     9.941   144.347     0.150
     9.941   145.460     0.150
    10.069   146.176     0.150
    10.094   146.276     0.150
    10.094   147.226     0.150
    10.226   148.176     0.150
    10.226   147.906     0.150
    10.233   147.062     0.150
    10.469   152.676     0.150
    10.469   152.206     0.150
    10.486   153.266     0.150
    10.493   150.246     0.150
    10.493   152.212     0.150
    10.493   271.046     0.150
    10.496   151.437     0.150
    10.638   150.486     0.150
    10.780   153.076     0.150
    10.780   272.976     0.150
    10.780   153.146     0.150
    10.816   153.486     0.150
    10.810   157.076     0.150
    10.846   154.176     0.150
    10.846   154.706     0.150
    10.846   154.320     0.150
    10.846   156.056     0.150
    10.846   155.085     0.150
    10.846   154.576     0.150
    10.846   157.505     0.150
    10.846   155.816     0.150
    10.854   156.976     0.150
    10.906   158.276     0.150
    10.966   154.446     0.150
    10.959   158.756     0.150
    11.031   156.996     0.150
    11.031   281.366     0.150
    10.982   157.996     0.150
    10.982   159.968     0.150
    11.031   159.276     0.150
    11.031   160.436     0.150
    11.034   159.313     0.150
    11.034   160.671     0.150
    11.034   285.885     0.150
    11.066   159.776     0.150
    11.150   158.733     0.150
    11.150   158.846     0.150
    11.177   161.316     0.150
    11.138   159.821     0.150
    11.138   162.244     0.150
    11.138   287.263     0.150
    11.258   159.526     0.150
    11.277   162.198     0.150
    11.277   164.217     0.150
    11.383   164.976     0.150
    11.383   294.076     0.150
    11.454   163.249     0.150
    11.454   164.134     0.150
    11.508   165.087     0.150
    11.536   165.173     0.150
    11.676   168.176     0.150
    11.703   167.868     0.150
    11.703   170.074     0.150
    11.706   168.244     0.150
    11.779   167.776     0.150
    11.779   299.276     0.150
    11.823   169.722     0.150
    11.823   171.010     0.150
    11.828   170.676     0.150
    11.963   298.340     0.150
    11.998   172.244     0.150
    12.019   172.976     0.150
    12.102   170.586     0.150
    12.230   173.566     0.150
    12.191   176.284     0.150
    12.228   174.021     0.150
    12.243   176.476     0.150
    12.259   176.776     0.150
    12.276   174.878     0.150
    12.465   179.986     0.150
    12.553   178.856     0.150
    12.528   180.254     0.150
    12.642   177.676     0.150
    12.642   178.008     0.150
    12.642   318.320     0.150
    12.642   178.716     0.150
    12.642   180.483     0.150
    12.642   320.258     0.150
    12.642   178.186     0.150
    12.642   177.476     0.150
    12.642   179.339     0.150
    12.642   179.046     0.150
    12.642   178.906     0.150
    12.599   180.776     0.150
    12.601   179.244     0.150
    12.634   177.546     0.150
    12.646   181.254     0.150
    12.857   184.676     0.150
    12.928   181.276     0.150
    12.904   183.790     0.150
    12.904   184.564     0.150
    12.905   186.363     0.150
    13.006   184.066     0.150
    13.019   183.986     0.150
    13.035   334.456     0.150
    13.009   186.476     0.150
    13.095   189.106     0.150
    13.107   188.383     0.150
    13.107   189.094     0.150
    13.173   187.476     0.150
    13.173   338.176     0.150
    13.262   189.014     0.150
    13.294   191.091     0.150
    13.296   190.264     0.150
    13.318   191.376     0.150
    13.318   341.576     0.150
    13.327   190.986     0.150
    13.454   189.176     0.150
    13.471   188.076     0.150
    13.423   192.476     0.150
    13.423   193.356     0.150
    13.522   189.186     0.150
    13.522   193.744     0.150
    13.562   191.176     0.150
    13.567   192.866     0.150
    13.693   195.869     0.150
    13.712   197.176     0.150
    13.741   194.756     0.150
    13.794   196.364     0.150
    13.809   198.076     0.150
    13.809   353.176     0.150
    13.798   197.914     0.150
    13.936   195.536     0.150
    13.936   351.176     0.150
    13.944   195.956     0.150
    13.974   200.276     0.150
    13.974   357.476     0.150
    14.011   199.998     0.150
    14.080   197.476     0.150
    14.043   201.176     0.150
    14.080   196.176     0.150
    14.097   201.576     0.150
    14.210   203.636     0.150
    14.210   363.486     0.150
    14.221   204.186     0.150
    14.283   205.426     0.150
    14.306   204.386     0.150
    14.348   206.196     0.150
    14.371   201.706     0.150
    14.439   204.646     0.150
    14.476   203.261     0.150
    14.500   202.326     0.150
    14.583   204.176     0.150
    14.629   209.076     0.150
    14.629   209.946     0.150
    14.732   207.906     0.150
    14.732   205.941     0.150
    14.732   365.771     0.150
    14.732   206.276     0.150
    14.732   364.776     0.150
    14.732   208.056     0.150
    14.793   210.776     0.150
    14.793   210.278     0.150
    14.793   211.407     0.150
    14.793   374.470     0.150
    14.793   211.786     0.150
    14.793   210.976     0.150
    14.793   214.856     0.150
    14.793   212.596     0.150
    14.793   211.136     0.150
    14.956   212.626     0.150
    15.047   209.976     0.150
    15.014   215.667     0.150
    15.102   210.192     0.150
    15.084   215.576     0.150
    15.129   215.245     0.150
    15.313   212.916     0.150
    15.342   217.146     0.150
    15.436   218.356     0.150
    15.671   218.852     0.150
    15.671   386.824     0.150
    15.671   217.676     0.150
    15.685   217.666     0.150
    15.683   223.456     0.150
    15.702   222.806     0.150
    15.754   218.666     0.150
    15.781   221.440     0.150
    15.822   221.826     0.150
    15.820   225.636     0.150
    15.888   221.799     0.150
    15.888   222.476     0.150
    15.871   225.816     0.150
    16.326   226.526     0.150
    16.099   223.576     0.150
    16.099   393.176     0.150
    16.099   223.968     0.150
    16.099   396.872     0.150
    16.137   223.993     0.150
    16.137   223.617     0.150
    16.137   221.876     0.150
    16.145   231.976     0.150
    16.300   231.386     0.150
    16.238   410.886     0.150
    16.315   227.236     0.150
    16.514   233.786     0.150
    16.656   234.976     0.150
    16.807   235.176     0.150
    16.873   239.923     0.150
    17.263   239.186     0.150
    17.302   242.676     0.150
    17.365   241.726     0.150
    17.365   438.701     0.150
    17.365   240.576     0.150
    17.365   241.576     0.150
    17.390   243.606     0.150
    17.425   243.536     0.150
    17.452   242.551     0.150
    17.452   245.299     0.150
    17.526   244.276     0.150
    17.594   245.301     0.150
    17.594   442.401     0.150
    17.600   244.076     0.150
    17.600   243.828     0.150
    17.600   244.496     0.150
    17.600   243.476     0.150
    17.600   244.876     0.150
    17.600   440.876     0.150
    17.600   245.589     0.150
    17.600   244.367     0.150
    17.880   247.376     0.150
    17.946   251.254     0.150
    18.079   251.116     0.150
    18.126   250.521     0.150
    18.126   250.676     0.150
    18.126   250.296     0.150
    18.126   251.336     0.150
    18.154   253.394     0.150
    18.244   252.055     0.150
    18.244   252.856     0.150
    18.265   256.266     0.150
    18.387   256.593     0.150
    18.847   261.244     0.150
    18.887   263.296     0.150
    18.954   263.986     0.150
    19.048   263.176     0.150
    19.167   266.876     0.150
    19.167   483.076     0.150
    19.238   267.356     0.150
    19.238   484.146     0.150
    19.373   266.164     0.150
    19.377   266.266     0.150
    19.377   266.876     0.150
    19.389   265.296     0.150
    19.389   265.076     0.150
    19.389   266.393     0.150
    19.389   265.636     0.150
    19.343   268.586     0.150
    19.440   267.676     0.150
    19.440   485.776     0.150
    19.445   270.316     0.150
    19.445   269.425     0.150
    19.558   267.376     0.150
    19.565   267.174     0.150
    19.565   268.091     0.150
    19.565   266.676     0.150
    19.565   268.097     0.150
    19.565   488.126     0.150
    19.565   267.246     0.150
    19.565   267.376     0.150
    19.563   268.176     0.150
    19.782   272.576     0.150
    19.782   496.776     0.150
    20.045   273.526     0.150
    20.045   499.126     0.150
    20.045   273.665     0.150
    20.087   274.196     0.150
    20.087   499.966     0.150
    20.124   274.906     0.150
    20.124   505.006     0.150
    20.152   274.376     0.150
    20.152   274.753     0.150
    20.152   274.946     0.150
    20.152   275.907     0.150
    20.152   276.383     0.150
    20.234   277.116     0.150
    20.372   277.996     0.150
    20.402   278.526     0.150
    20.411   276.476     0.150
    20.483   279.856     0.150
    20.556   280.076     0.150
    20.556   501.076     0.150
    20.672   278.636     0.150
    20.889   284.936     0.150
    20.952   282.576     0.150
    20.943   284.536     0.150
    20.943   521.306     0.150
    20.925   285.076     0.150
    21.016   282.339     0.150
    21.016   282.206     0.150
    21.015   286.116     0.150
    21.199   285.076     0.150
    21.360   289.836     0.150
    21.417   287.576     0.150
    21.400   289.576     0.150
    21.400   532.276     0.150
    21.451   289.176     0.150
    21.461   287.846     0.150
    21.804   292.876     0.150
    21.848   294.666     0.150
    21.848   537.846     0.150
    21.877   747.376     0.150
    21.877   293.766     0.150
    21.939   294.736     0.150
    21.939   294.576     0.150
    21.939   314.876     0.150
    21.939   562.776     0.150
    21.939   295.186     0.150
    22.136   296.746     0.150
    22.136   541.576     0.150
    22.158   296.076     0.150
    22.191   295.886     0.150
    22.191   295.556     0.150
    22.141   297.746     0.150
    22.141   298.166     0.150
    22.259   297.676     0.150
    22.259   540.976     0.150
    22.318   299.416     0.150
    22.435   298.076     0.150
    22.399   300.306     0.150
    22.399   300.906     0.150
    22.614   299.896     0.150
    22.614   323.406     0.150
    22.614   532.886     0.150
    22.614   549.436     0.150
    22.614   301.926     0.150
    22.876   305.919     0.150
    23.086   307.266     0.150
    23.106   308.386     0.150
    23.161   306.776     0.150
    23.121   307.476     0.150
    23.124   308.076     0.150
    23.124   306.209     0.150
    23.124   308.056     0.150
    23.124   306.976     0.150
    23.124   308.773     0.150
    23.124   307.976     0.150
    23.124   561.351     0.150
    23.124   307.376     0.150
    23.153   307.046     0.150
    23.153   560.836     0.150
    23.191   308.786     0.150
    23.390   310.696     0.150
    23.390   310.333     0.150
    23.390   310.076     0.150
    23.424   309.676     0.150
    23.424   309.876     0.150
    23.424   558.276     0.150
    23.519   311.016     0.150
    23.519   311.276     0.150
    23.519   310.376     0.150
    23.565   311.716     0.150
    23.565   569.766     0.150
    23.654   313.016     0.150
    23.676   312.576     0.150
    23.688   314.376     0.150
    23.688   341.676     0.150
    23.784   313.986     0.150
    23.784   314.376     0.150
    23.784   314.531     0.150
    23.903   314.636     0.150
    23.873   316.319     0.150
    24.080   315.896     0.150
    24.080   576.846     0.150
    24.313   320.296     0.150
    24.384   318.776     0.150
    24.384   318.876     0.150
    24.384   577.676     0.150
    24.398   319.306     0.150
    24.398   580.676     0.150
    24.413   319.246     0.150
    24.413   581.466     0.150
    24.565   320.966     0.150
    24.565   585.636     0.150
    24.915   325.866     0.150
    25.117   325.462     0.150
    25.117   325.216     0.150
    25.117   325.736     0.150
    25.117   543.156     0.150
    25.117   326.076     0.150
    25.135   325.907     0.150
    25.135   325.017     0.150
    25.135   324.276     0.150
    25.135   325.126     0.150
    25.135   593.426     0.150
    25.135   324.856     0.150
    25.329   328.904     0.150
    25.387   328.076     0.150
    25.387   597.876     0.150
    25.377   327.246     0.150
    25.377   598.566     0.150
    25.424   329.076     0.150
    25.397   328.456     0.150
    25.538   329.676     0.150
    25.538   329.526     0.150
    25.538   330.626     0.150
    25.583   329.686     0.150
    25.750   331.566     0.150
    25.750   605.076     0.150
    25.979   335.206     0.150
    25.985   332.916     0.150
    26.095   334.336     0.150
    26.387   336.466     0.150
    26.387   336.216     0.150
    26.450   337.616     0.150
    26.735   341.376     0.150
    26.735   544.576     0.150
    26.735   617.376     0.150
    26.875   340.086     0.150
    26.833   340.753     0.150
    26.974   344.812     0.150
    26.991   543.676     0.150
    27.048   343.776     0.150
    27.048   624.176     0.150
    27.048   344.677     0.150
    27.048   343.516     0.150
    27.048   343.224     0.150
    27.071   345.856     0.150
    27.071   626.856     0.150
    27.060   344.396     0.150
    27.189   344.016     0.150
    27.189   625.946     0.150
    27.302   343.826     0.150
    27.273   347.258     0.150
    27.303   347.699     0.150
    27.324   348.219     0.150
    27.332   348.299     0.150
    27.360   345.006     0.150
    27.394   347.676     0.150
    27.547   348.026     0.150
    27.547   348.536     0.150
    27.547   349.091     0.150
    27.578   348.658     0.150
    27.578   348.106     0.150
    27.596   349.076     0.150
    27.639   348.536     0.150
    27.764   350.196     0.150
    27.794   351.476     0.150
    27.864   350.806     0.150
    27.864   352.876     0.150
    27.864   351.699     0.150
    27.886   353.171     0.150
    27.924   354.476     0.150
    27.924   352.974     0.150
    27.929   353.732     0.150
    27.930   352.845     0.150
    28.049   352.536     0.150
    28.030   353.930     0.150
    28.034   352.800     0.150
    28.055   353.368     0.150
    28.102   351.946     0.150
    28.102   641.006     0.150
    28.105   353.176     0.150
    28.144   352.786     0.150
    28.129   354.927     0.150
    28.200   353.963     0.150
    28.254   353.593     0.150
    28.265   356.688     0.150
    28.296   354.151     0.150
    28.309   356.124     0.150
    28.327   357.201     0.150
    28.332   358.076     0.150
    28.332   357.091     0.150
    28.330   355.526     0.150
    28.398   355.906     0.150
    28.395   357.885     0.150
    28.398   356.276     0.150
    28.426   358.776     0.150
    28.426   357.196     0.150
    28.460   356.186     0.150
    28.493   358.566     0.150
    28.624   360.133     0.150
    28.642   356.676     0.150
    28.661   359.468     0.150
    28.668   357.676     0.150
    28.672   358.854     0.150
    28.675   360.295     0.150
    28.677   360.661     0.150
    28.685   357.701     0.150
    28.685   547.790     0.150
    28.685   650.476     0.150
    28.685   357.826     0.150
    28.685   357.776     0.150
    28.685   357.876     0.150
    28.692   357.706     0.150
    28.692   358.896     0.150
    28.638   358.776     0.150
    28.692   357.086     0.150
    28.692   358.232     0.150
    28.696   357.676     0.150
    28.737   358.646     0.150
    28.718   361.182     0.150
    28.725   361.597     0.150
    28.742   358.476     0.150
    28.756   361.044     0.150
    28.766   358.376     0.150
    28.798   358.776     0.150
    28.760   358.993     0.150
    28.760   361.476     0.150
    28.760   360.268     0.150
    28.786   358.676     0.150
    28.791   361.170     0.150
    28.790   361.038     0.150
    28.804   361.252     0.150
    28.826   361.450     0.150
    28.829   359.303     0.150
    28.829   359.966     0.150
    28.829   361.856     0.150
    28.878   361.748     0.150
    28.893   361.746     0.150
    28.919   362.599     0.150
    28.947   363.123     0.150
    28.963   361.826     0.150
    28.963   360.676     0.150
    28.963   363.876     0.150
    28.963   362.720     0.150
    28.966   363.376     0.150
    28.967   362.422     0.150
    28.967   363.661     0.150
    28.973   361.926     0.150
    28.973   361.318     0.150
    29.043   360.096     0.150
    29.013   363.618     0.150
    29.013   364.276     0.150
    29.013   363.294     0.150
    29.124   360.836     0.150
    29.083   361.856     0.150
    29.105   364.209     0.150
    29.141   362.001     0.150
    29.178   362.988     0.150
    29.178   361.976     0.150
    29.187   365.398     0.150
    29.277   365.956     0.150
    29.271   363.816     0.150
    29.271   363.263     0.150
    29.302   362.576     0.150
    29.328   364.998     0.150
    29.343   367.149     0.150
    29.392   364.210     0.150
    29.392   364.976     0.150
    29.366   367.309     0.150
    29.362   364.329     0.150
    29.362   364.456     0.150
    29.359   363.665     0.150
    29.413   364.626     0.150
    29.413   659.876     0.150
    29.391   367.074     0.150
    29.405   364.886     0.150
    29.441   366.706     0.150
    29.441   366.236     0.150
    29.441   368.176     0.150
    29.441   367.221     0.150
    29.464   365.055     0.150
    29.464   365.876     0.150
    29.556   365.496     0.150
    29.556   365.225     0.150
    29.597   367.615     0.150
    29.638   366.192     0.150
    29.684   366.166     0.150
    29.684   365.940     0.150
    29.702   369.628     0.150
    29.715   366.741     0.150
    29.731   369.643     0.150
    29.779   367.979     0.150
    29.884   367.647     0.150
    29.901   370.858     0.150
    29.942   371.305     0.150
    29.990   370.251     0.150
    30.012   369.863     0.150
    30.012   370.576     0.150
    29.980   369.947     0.150
    30.043   372.522     0.150
    30.056   371.664     0.150
    30.054   372.190     0.150
    30.078   370.027     0.150
    30.109   371.530     0.150
    30.127   373.062     0.150
    30.134   371.308     0.150
    30.173   371.453     0.150
    30.320   374.776     0.150
    30.314   371.454     0.150
    30.314   372.526     0.150
    30.326   373.473     0.150
    30.337   372.896     0.150
    30.337   374.796     0.150
    30.337   373.546     0.150
    30.386   373.876     0.150
    30.386   674.976     0.150
    30.349   374.559     0.150
    30.376   371.902     0.150
    30.427   374.676     0.150
    30.425   373.082     0.150
    30.441   373.016     0.150
    30.500   373.820     0.150
    30.525   374.462     0.150
    30.547   374.754     0.150
    30.586   377.528     0.150
    30.622   377.376     0.150
    30.626   376.776     0.150
    30.627   375.782     0.150
    30.648   374.017     0.150
    30.708   376.841     0.150
    30.729   376.631     0.150
    30.774   376.837     0.150
    30.792   376.840     0.150
    30.799   379.403     0.150
    30.804   376.115     0.150
    30.811   379.576     0.150
    30.831   376.760     0.150
    30.831   377.576     0.150
    30.849   376.738     0.150
    30.851   376.776     0.150
    30.898   376.638     0.150
    30.899   378.004     0.150
    30.935   377.355     0.150
    30.951   378.496     0.150
    30.951   380.146     0.150
    30.995   378.436     0.150
    30.995   439.266     0.150
    30.995   683.996     0.150
    30.995   786.976     0.150
    30.956   377.820     0.150
    30.959   376.750     0.150
    30.972   379.676     0.150
    31.015   379.077     0.150
    31.014   378.493     0.150
    31.046   382.176     0.150
    31.018   378.386     0.150
    31.018   377.648     0.150
    31.034   380.638     0.150
    31.041   377.329     0.150
    31.064   377.984     0.150
    31.086   378.229     0.150
    31.093   380.576     0.150
    31.136   380.712     0.150
    31.144   380.739     0.150
    31.144   380.965     0.150
    31.163   379.879     0.150
    31.174   382.737     0.150
    31.168   380.381     0.150
    31.176   379.773     0.150
    31.214   380.969     0.150
    31.214   380.576     0.150
    31.181   379.158     0.150
    31.197   379.794     0.150
    31.197   379.280     0.150
    31.213   380.150     0.150
    31.218   379.991     0.150
    31.244   383.576     0.150
    31.257   380.257     0.150
    31.265   382.376     0.150
    31.315   381.357     0.150
    31.355   381.314     0.150
    31.355   381.876     0.150
    31.360   383.254     0.150
    31.378   381.690     0.150
    31.406   379.998     0.150
    31.408   379.642     0.150
    31.449   381.571     0.150
    31.473   383.966     0.150
    31.473   384.660     0.150
    31.480   381.318     0.150
    31.482   381.635     0.150
    31.500   385.271     0.150
    31.498   381.568     0.150
    31.554   384.676     0.150
    31.573   383.711     0.150
    31.573   381.309     0.150
    31.600   383.354     0.150
    31.606   386.285     0.150
    31.606   385.346     0.150
    31.639   385.976     0.150
    31.654   383.293     0.150
    31.663   381.363     0.150
    31.679   384.024     0.150
    31.686   382.836     0.150
    31.697   385.176     0.150
    31.697   384.264     0.150
    31.719   385.426     0.150
    31.719   383.869     0.150
    31.734   385.624     0.150
    31.734   385.376     0.150
    31.751   387.343     0.150
    31.789   383.803     0.150
    31.844   386.884     0.150
    31.859   387.106     0.150
    31.859   388.376     0.150
    31.885   384.982     0.150
    31.916   385.735     0.150
    31.982   385.501     0.150
    32.019   386.429     0.150
    32.094   386.991     0.150
    32.094   386.251     0.150
    32.115   389.419     0.150
    32.121   385.970     0.150
    32.141   391.234     0.150
    32.157   386.651     0.150
    32.189   389.896     0.150
    32.189   388.975     0.150
    32.189   389.506     0.150
    32.189   390.576     0.150
    32.189   390.016     0.150
    32.189   390.699     0.150
    32.201   390.496     0.150
    32.235   388.015     0.150
    32.238   388.769     0.150
    32.245   387.949     0.150
    32.256   391.213     0.150
    32.274   391.053     0.150
    32.273   388.046     0.150
    32.319   392.334     0.150
    32.335   392.533     0.150
    32.362   389.936     0.150
    32.347   388.394     0.150
    32.378   391.966     0.150
    32.378   393.656     0.150
    32.402   389.641     0.150
    32.402   389.476     0.150
    32.441   391.465     0.150
    32.441   391.566     0.150
    32.473   392.036     0.150
    32.473   391.326     0.150
    32.477   390.209     0.150
    32.493   393.736     0.150
    32.493   393.538     0.150
    32.511   393.246     0.150
    32.511   393.776     0.150
    32.512   394.301     0.150
    32.509   391.289     0.150
    32.528   394.209     0.150
    32.528   389.460     0.150
    32.547   392.250     0.150
    32.551   391.230     0.150
    32.572   393.316     0.150
    32.572   391.766     0.150
    32.572   393.676     0.150
    32.569   391.224     0.150
    32.587   390.429     0.150
    32.656   391.637     0.150
    32.664   391.240     0.150
    32.681   393.255     0.150
    32.752   396.321     0.150
    32.782   710.076     0.150
    32.765   392.567     0.150
    32.783   394.059     0.150
    32.790   396.720     0.150
    32.943   395.076     0.150
    32.941   394.800     0.150
    32.980   398.257     0.150
    33.073   397.816     0.150
    33.205   398.856     0.150
    33.205   399.604     0.150
    33.186   396.687     0.150
    33.193   395.482     0.150
    33.199   396.282     0.150
    33.210   395.995     0.150
    33.228   396.159     0.150
    33.230   396.613     0.150
    33.267   400.876     0.150
    33.285   396.436     0.150
    33.330   400.176     0.150
    33.322   397.256     0.150
    33.322   397.606     0.150
    33.322   396.966     0.150
    33.322   398.256     0.150
    33.319   396.423     0.150
    33.330   396.750     0.150
    33.401   399.676     0.150
    33.401   399.536     0.150
    33.393   397.826     0.150
    33.393   398.676     0.150
    33.439   400.226     0.150
    33.439   399.516     0.150
    33.439   400.476     0.150
    33.439   401.326     0.150
    33.439   401.121     0.150
    33.449   398.751     0.150
    33.487   399.008     0.150
    33.492   398.675     0.150
    33.530   401.606     0.150
    33.582   402.986     0.150
    33.582   403.597     0.150
    33.582   400.211     0.150
    33.599   403.946     0.150
    33.599   404.076     0.150
    33.620   400.326     0.150
    33.620   401.276     0.150
    33.635   402.476     0.150
    33.789   401.185     0.150
    33.888   403.618     0.150
    33.888   561.650     0.150
    33.888   729.276     0.150
    33.874   405.806     0.150
    33.874   406.166     0.150
    33.910   405.176     0.150
    33.910   405.896     0.150
    33.910   404.996     0.150
    33.984   405.276     0.150
    33.984   473.776     0.150
    33.984   563.276     0.150
    33.984   729.076     0.150
    33.984   790.476     0.150
    33.961   405.276     0.150
    33.961   734.976     0.150
    33.961   856.576     0.150
    33.963   403.586     0.150
    34.058   404.476     0.150
    34.058   403.886     0.150
    34.058   405.280     0.150
    34.075   406.276     0.150
    34.189   405.896     0.150
    34.229   407.196     0.150
    34.305   408.166     0.150
    34.305   408.462     0.150
    34.305   407.536     0.150
    34.305   408.276     0.150
    34.305   409.313     0.150
    34.305   408.721     0.150
    34.265   408.976     0.150
    34.338   408.356     0.150
    34.338   408.715     0.150
    34.338   408.236     0.150
    34.367   409.376     0.150
    34.442   409.246     0.150
    34.540   409.676     0.150
    34.573   410.276     0.150
    34.591   410.176     0.150
    34.640   410.676     0.150
    34.654   412.176     0.150
    34.657   411.276     0.150
    34.702   412.256     0.150
    34.814   411.376     0.150
    34.778   409.886     0.150
    34.866   413.046     0.150
    34.866   412.356     0.150
    34.946   414.056     0.150
    34.990   412.376     0.150
    34.955   414.806     0.150
    34.955   414.976     0.150
    34.960   413.176     0.150
    34.960   413.976     0.150
    35.137   413.176     0.150
    35.117   414.976     0.150
    35.131   414.766     0.150
    35.131   414.036     0.150
    35.157   415.306     0.150
    35.189   415.476     0.150
    35.224   416.676     0.150
    35.249   415.296     0.150
    35.249   492.276     0.150
    35.249   750.356     0.150
    35.315   416.366     0.150
    35.323   417.676     0.150
    35.323   751.576     0.150
    35.323   417.006     0.150
    35.438   416.769     0.150
    35.438   751.776     0.150
    35.445   417.776     0.150
    35.451   417.676     0.150
    35.419   417.466     0.150
    35.461   418.506     0.150
    35.499   420.016     0.150
    35.499   418.426     0.150
    35.556   418.456     0.150
    35.556   419.046     0.150
    35.556   418.576     0.150
    35.566   418.576     0.150
    35.580   421.016     0.150
    35.619   421.376     0.150
    35.702   420.096     0.150
    35.702   421.476     0.150
    35.702   421.174     0.150
    35.704   420.526     0.150
    35.704   420.976     0.150
    35.762   421.176     0.150
    35.882   421.316     0.150
    35.882   422.046     0.150
    35.882   420.906     0.150
    35.882   421.822     0.150
    35.898   422.326     0.150
    35.898   422.556     0.150
    35.933   420.726     0.150
    35.962   422.376     0.150
    36.068   421.296     0.150
    36.068   421.771     0.150
    36.068   422.321     0.150
    36.124   422.506     0.150
    36.115   422.766     0.150
    36.123   423.676     0.150
    36.173   424.976     0.150
    36.230   424.916     0.150
    36.230   424.676     0.150
    36.255   424.896     0.150
    36.255   424.627     0.150
    36.255   426.101     0.150
    36.323   423.376     0.150
    36.323   424.281     0.150
    36.323   424.096     0.150
    36.323   425.021     0.150
    36.327   423.446     0.150
    36.365   424.276     0.150
    36.365   509.676     0.150
    36.365   764.876     0.150
    36.365   909.276     0.150
    36.357   425.576     0.150
    36.357   425.439     0.150
    36.422   425.946     0.150
    36.481   425.882     0.150
    36.517   425.166     0.150
    36.517   425.932     0.150
    36.517   425.126     0.150
    36.517   506.688     0.150
    36.517   569.435     0.150
    36.517   769.976     0.150
    36.517   798.196     0.150
    36.517  1008.874     0.150
    36.517   425.356     0.150
    36.532   425.276     0.150
    36.550   425.376     0.150
    36.560   428.446     0.150
    36.560   427.376     0.150
    36.648   428.566     0.150
    36.656   428.836     0.150
    36.656   428.676     0.150
    36.700   427.276     0.150
    36.741   427.966     0.150
    36.762   429.776     0.150
    36.778   430.436     0.150
    36.778   430.276     0.150
    36.778   775.676     0.150
    36.777   428.936     0.150
    36.785   428.546     0.150
    36.785   430.326     0.150
    36.796   429.346     0.150
    36.796   428.636     0.150
    36.830   429.896     0.150
    36.830   430.061     0.150
    36.830   429.496     0.150
    36.830   429.676     0.150
    36.830   430.246     0.150
    36.830   430.436     0.150
    36.830   570.316     0.150
    36.812   428.886     0.150
    36.812   428.766     0.150
    36.841   429.746     0.150
    36.841   429.536     0.150
    36.921   429.826     0.150
    36.952   570.703     0.150
    36.974   431.176     0.150
    36.974   779.176     0.150
    37.071   431.696     0.150
    37.071   431.439     0.150
    37.108   572.290     0.150
    37.260   432.106     0.150
    37.396   434.196     0.150
    37.450   434.336     0.150
    37.437   434.906     0.150
    37.437   434.230     0.150
    37.442   434.217     0.150
    37.444   434.776     0.150
    37.444     1.820     0.150
    37.582   435.143     0.150
    37.582   785.976     0.150
    37.582   435.276     0.150
    37.582   436.076     0.150
    37.645   436.276     0.150
    37.654   436.936     0.150
    37.654   436.676     0.150
    37.677   436.676     0.150
    37.695   435.256     0.150
    37.695   436.376     0.150
    37.695   789.576     0.150
    37.705   437.276     0.150
    37.732   437.706     0.150
    37.732   438.676     0.150
    37.732   793.376     0.150
    37.830   438.336     0.150
    38.019   439.776     0.150
    38.019   531.776     0.150
    38.019   790.576     0.150
    37.995   440.976     0.150
    37.995   799.576     0.150
    38.013   439.676     0.150
    38.040   439.406     0.150
    38.060   439.496     0.150
    38.065   439.926     0.150
    38.090   439.576     0.150
    38.090   439.826     0.150
    38.099   440.426     0.150
    38.108   441.176     0.150
    38.108   525.230     0.150
    38.108   440.501     0.150
    38.108   529.046     0.150
    38.108   574.940     0.150
    38.108   792.646     0.150
    38.108   440.446     0.150
    38.116   440.216     0.150
    38.116   439.806     0.150
    38.129   438.716     0.150
    38.153   440.946     0.150
    38.153   440.476     0.150
    38.153   531.036     0.150
    38.153   797.876     0.150
    38.208   441.056     0.150
    38.208   535.176     0.150
    38.208   798.476     0.150
    38.218   440.356     0.150
    38.232   440.466     0.150
    38.250   440.356     0.150
    38.276   441.676     0.150
    38.276   441.104     0.150
    38.310   442.136     0.150
    38.338   442.506     0.150
    38.366   441.916     0.150
    38.391   442.726     0.150
    38.391   442.396     0.150
    38.391   442.290     0.150
    38.435   443.406     0.150
    38.435   442.366     0.150
    38.435   443.697     0.150
    38.435   532.851     0.150
    38.487   442.676     0.150
    38.487   798.576     0.150
    38.487   442.096     0.150
    38.506   442.696     0.150
    38.564   443.586     0.150
    38.663   444.686     0.150
    38.667   445.106     0.150
    38.667   443.276     0.150
    38.667   535.251     0.150
    38.684   445.976     0.150
    38.737   445.264     0.150
    38.766   446.356     0.150
    38.766   445.696     0.150
    38.766   445.893     0.150
    38.766   447.576     0.150
    38.766   540.276     0.150
    38.766   576.976     0.150
    38.766   801.276     0.150
    38.766   970.276     0.150
    38.822   446.596     0.150
    38.843   446.244     0.150
    38.895   446.166     0.150
    38.895   446.766     0.150
    38.962   448.516     0.150
    38.975   446.986     0.150
    39.040   446.306     0.150
    39.019   448.616     0.150
    39.019   449.076     0.150
    39.019   811.076     0.150
    39.024   448.345     0.150
    39.024   536.168     0.150
    39.024   448.726     0.150
    39.041   449.176     0.150
    39.041   448.418     0.150
    39.129   449.276     0.150
    39.129   449.096     0.150
    39.138   448.496     0.150
    38.879   447.266     0.150
    39.172   448.046     0.150
    39.172   448.686     0.150
    39.142   449.606     0.150
    39.220   450.806     0.150
    39.223   448.976     0.150
    39.223   540.052     0.150
    39.277   450.876     0.150
    39.277   543.176     0.150
    39.277   810.576     0.150
    39.277   815.576     0.150
    39.277   972.076     0.150
    39.379   451.476     0.150
    39.443   450.532     0.150
    39.443   579.449     0.150
    39.448   451.416     0.150
    39.453   452.096     0.150
    39.481   452.276     0.150
    39.484   451.394     0.150
    39.484   578.863     0.150
    39.504   452.686     0.150
    39.506   452.346     0.150
    39.524   452.693     0.150
    39.524   541.580     0.150
    39.534   453.636     0.150
    39.545   452.746     0.150
    39.551   452.376     0.150
    39.551   452.526     0.150
    39.581   453.266     0.150
    39.631   453.816     0.150
    39.644   452.926     0.150
    39.693   453.726     0.150
    39.693   453.976     0.150
    39.693   545.290     0.150
    39.716   454.826     0.150
    39.720   454.106     0.150
    39.734   453.254     0.150
    39.734   580.150     0.150
    39.764   454.456     0.150
    39.753   455.296     0.150
    39.753   542.885     0.150
    39.753   455.736     0.150
    39.776   455.476     0.150
    39.776   454.576     0.150
    39.776   548.126     0.150
    39.805   580.341     0.150
    39.868   454.656     0.150
    39.871   453.786     0.150
    39.883   455.516     0.150
    39.962   456.006     0.150
    39.962   455.980     0.150
    39.962   543.983     0.150
    39.985   455.736     0.150
    40.029   454.496     0.150
    40.029   455.416     0.150
    40.029   547.036     0.150
    40.003   456.896     0.150
    40.036   455.416     0.150
    40.036   581.328     0.150
    40.064   456.344     0.150
    40.064   582.473     0.150
    40.089   456.676     0.150
    40.089   457.016     0.150
    40.089     2.120     0.150
    40.089   550.036     0.150
    40.136   457.336     0.150
    40.160   458.966     0.150
    40.189   457.189     0.150
    40.189   551.489     0.150
    40.189   824.688     0.150
    40.250   458.226     0.150
    40.289   458.666     0.150
    40.289   457.767     0.150
    40.289   548.566     0.150
    40.291   459.936     0.150
    40.333   458.706     0.150
    40.333   813.786     0.150
    40.333  1001.016     0.150
    40.333   458.576     0.150
    40.333   458.451     0.150
    40.333   550.841     0.150
    40.333   458.066     0.150
    40.341   458.676     0.150
    40.379   458.606     0.150
    40.376   458.576     0.150
    40.423   459.576     0.150
    40.423   557.976     0.150
    40.393   458.836     0.150
    40.393   458.976     0.150
    40.426   459.316     0.150
    40.452   460.876     0.150
    40.452   556.976     0.150
    40.440   458.898     0.150
    40.450   460.456     0.150
    40.450   460.176     0.150
    40.450   552.057     0.150
    40.478   460.136     0.150
    40.478   459.146     0.150
    40.595   461.626     0.150
    40.628   461.666     0.150
    40.615   549.875     0.150
    40.638   460.396     0.150
    40.638   460.534     0.150
    40.638   583.654     0.150
    40.672   461.476     0.150
    40.681   462.148     0.150
    40.681   554.807     0.150
    40.681   462.376     0.150
    40.685   463.146     0.150
    40.692   462.236     0.150
    40.757   461.046     0.150
    41.031   465.206     0.150
    41.030   463.886     0.150
    41.030   464.236     0.150
    41.096   464.076     0.150
    41.096   463.476     0.150
    41.083   464.716     0.150
    41.083   464.236     0.150
    41.083   464.599     0.150
    41.083   561.930     0.150
    41.083   465.921     0.150
    41.127   464.556     0.150
    41.141   467.006     0.150
    41.198   465.676     0.150
    41.198   564.176     0.150
    41.198   838.376     0.150
    41.198   846.276     0.150
    41.198  1017.076     0.150
    41.270   465.406     0.150
    41.270   465.196     0.150
    41.289   468.296     0.150
    41.298   468.826     0.150
    41.355   467.646     0.150
    41.384   563.696     0.150
    41.384   844.396     0.150
    41.384  1011.036     0.150
    41.427   466.576     0.150
    41.459   467.106     0.150
    41.528   468.516     0.150
    41.512   468.846     0.150
    41.571   566.456     0.150
    41.571   845.986     0.150
    41.571  1024.056     0.150
    41.567   467.776     0.150
    41.589   467.996     0.150
    41.585   469.946     0.150
    41.585   469.669     0.150
    41.585   567.385     0.150
    41.588   471.236     0.150
    41.600   468.716     0.150
    41.621   468.576     0.150
    41.621   468.276     0.150
    41.621   468.876     0.150
    41.621   468.401     0.150
    41.621   566.174     0.150
    41.621   843.534     0.150
    41.611   468.626     0.150
    41.632   469.456     0.150
    41.632   566.731     0.150
    41.647   468.556     0.150
    41.661   470.680     0.150
    41.661   469.416     0.150
    41.662   469.446     0.150
    41.662   468.956     0.150
    41.662   468.776     0.150
    41.662   469.796     0.150
    41.685   470.806     0.150
    41.749   469.166     0.150
    41.749   468.846     0.150
    41.749   471.906     0.150
    41.749   472.606     0.150
    41.763   470.936     0.150
    41.825   471.486     0.150
    41.907   472.146     0.150
    41.907   571.056     0.150
    41.907  1037.056     0.150
    42.047   472.366     0.150
    42.058   473.376     0.150
    42.058   473.246     0.150
    42.058   472.966     0.150
    42.058   571.346     0.150
    42.058  1033.466     0.150
    42.091   474.126     0.150
    42.091   473.266     0.150
    42.091   571.750     0.150
    42.144   474.736     0.150
    42.144   570.440     0.150
    42.242   475.376     0.150
    42.242   576.476     0.150
    42.237   474.286     0.150
    42.284   475.276     0.150
    42.284   575.076     0.150
    42.284   858.376     0.150
    42.273   474.246     0.150
    42.305   475.006     0.150
    42.340   475.516     0.150
    42.340   574.516     0.150
    42.340   474.576     0.150
    42.359   476.066     0.150
    42.359   475.614     0.150
    42.359   575.459     0.150
    42.377   476.386     0.150
    42.436   475.006     0.150
    42.459   476.476     0.150
    42.448   475.606     0.150
    42.448   476.526     0.150
    42.448   475.946     0.150
    42.448   476.286     0.150
    42.431   477.266     0.150
    42.431   476.999     0.150
    42.431   476.287     0.150
    42.431   571.976     0.150
    42.431   588.446     0.150
    42.431   856.576     0.150
    42.431   476.069     0.150
    42.431   476.676     0.150
    42.431   477.521     0.150
    42.431   475.606     0.150
    42.451   475.396     0.150
    42.467   477.496     0.150
    42.467   476.947     0.150
    42.467   578.708     0.150
    42.479   475.126     0.150
    42.479   474.906     0.150
    42.488   475.986     0.150
    42.516   476.616     0.150
    42.516   573.546     0.150
    42.516  1043.426     0.150
    42.538   477.206     0.150
    42.588   476.276     0.150
    42.588   579.976     0.150
    42.611   476.946     0.150
    42.640   477.586     0.150
    42.640   575.226     0.150
    42.640  1051.486     0.150
    42.626   477.976     0.150
    42.626   587.993     0.150
    42.626   861.501     0.150
    42.626   478.166     0.150
    42.636   477.246     0.150
    42.662   478.076     0.150
    42.669   478.286     0.150
    42.667   478.896     0.150
    42.667   579.824     0.150
    42.689   478.586     0.150
    42.689   574.116     0.150
    42.689   861.406     0.150
    42.689  1047.366     0.150
    42.707   478.576     0.150
    42.827   478.876     0.150
    42.877   479.356     0.150
    42.877   480.746     0.150
    42.797   479.676     0.150
    42.797   581.776     0.150
    42.797   591.476     0.150
    42.797   823.676     0.150
    42.797   862.876     0.150
    42.879   480.016     0.150
    42.979   479.676     0.150
    42.970   480.056     0.150
    43.026   581.216     0.150
    43.026   828.686     0.150
    43.068   482.216     0.150
    43.068   481.753     0.150
    43.068   482.716     0.150
    43.068   481.615     0.150
    43.068   582.220     0.150
    43.077   481.185     0.150
    43.077   480.896     0.150
    43.077   480.686     0.150
    43.077   481.616     0.150
    43.118   482.576     0.150
    43.159   480.576     0.150
    43.148   482.456     0.150
    43.148   482.156     0.150
    43.148   586.496     0.150
    43.151   481.616     0.150
    43.201   482.186     0.150
    43.195   483.326     0.150
    43.195   483.130     0.150
    43.272   484.296     0.150
    43.272   484.688     0.150
    43.382   485.166     0.150
    43.382   587.116     0.150
    43.372   483.496     0.150
    43.443   483.716     0.150
    43.576   484.176     0.150
    43.576   872.176     0.150
    43.565   485.516     0.150
    43.583   486.826     0.150
    43.583   587.726     0.150
    43.583   881.496     0.150
    43.583  1066.496     0.150
    43.575   483.796     0.150
    43.654   487.166     0.150
    43.696   486.266     0.150
    43.727   487.666     0.150
    43.727   590.786     0.150
    43.905   488.276     0.150
    43.905   595.276     0.150
    43.905   880.276     0.150
    43.946   488.716     0.150
    43.946   594.286     0.150
    43.956   489.576     0.150
    43.978   488.466     0.150
    44.026   592.666     0.150
    44.026   884.836     0.150
    44.026  1079.836     0.150
    44.063   489.706     0.150
    44.063   594.626     0.150
    44.094   490.176     0.150
    44.094   594.626     0.150
    44.149   489.306     0.150
    44.167   491.036     0.150
    44.193   491.336     0.150
    44.193   491.186     0.150
    44.193   490.336     0.150
    44.193   596.126     0.150
    44.249   491.176     0.150
    44.249   593.956     0.150
    44.315   490.898     0.150
    44.315   593.751     0.150
    44.315   883.851     0.150
    44.324   490.546     0.150
    44.324   491.326     0.150
    44.300   595.546     0.150
    44.300  1083.166     0.150
    44.321   491.176     0.150
    44.375   492.546     0.150
    44.375   595.126     0.150
    44.450   492.376     0.150
    44.450   598.876     0.150
    44.450   891.476     0.150
    44.474   491.886     0.150
    44.474   492.026     0.150
    44.474   492.976     0.150
    44.474   492.766     0.150
    44.477   492.976     0.150
    44.521   493.286     0.150
    44.521   597.216     0.150
    44.521   892.146     0.150
    44.521  1089.436     0.150
    44.523   493.706     0.150
    44.592   493.676     0.150
    44.646   494.476     0.150
    44.688   494.886     0.150
    44.732   494.176     0.150
    44.733   494.776     0.150
    44.891   495.476     0.150
    44.900   495.976     0.150
    45.014   495.676     0.150
    45.014   894.776     0.150
    45.014   496.033     0.150
    45.045   497.666     0.150
    45.045   896.486     0.150
    45.045  1093.456     0.150
    45.076   498.016     0.150
    45.160   495.896     0.150
    45.137   497.976     0.150
    45.261   499.076     0.150
    45.560   501.176     0.150
    45.580   500.256     0.150
    45.628   501.286     0.150
    45.628   502.061     0.150
    45.628   501.466     0.150
    45.628   501.946     0.150
    45.628   502.776     0.150
    45.993   504.976     0.150
    45.993   616.476     0.150
    46.081   506.326     0.150
    46.090   503.746     0.150
    46.090   503.614     0.150
    46.088   503.876     0.150
    46.215   507.566     0.150
    46.254   506.866     0.150
    46.269   505.776     0.150
    46.413   507.166     0.150
    46.448   507.676     0.150
    46.529   508.776     0.150
    46.751   508.176     0.150
    46.699   509.435     0.150
    46.751   507.686     0.150
    46.751   507.906     0.150
    46.751   508.487     0.150
    46.737   511.606     0.150
    46.755   510.376     0.150
    46.793   510.476     0.150
    46.823   510.676     0.150
    46.875   509.986     0.150
    46.875   511.349     0.150
    46.938   510.176     0.150
    46.938   509.911     0.150
    46.938   510.286     0.150
    47.005   512.436     0.150
    47.005   512.636     0.150
    47.021   512.276     0.150
    46.992   512.866     0.150
    47.042   512.676     0.150
    47.042   607.476     0.150
    47.042   626.176     0.150
    47.042   927.076     0.150
    47.091   513.826     0.150
    47.243   514.476     0.150
    47.243   929.376     0.150
    47.227   514.276     0.150
    47.244   514.606     0.150
    47.246   513.006     0.150
    47.389   515.436     0.150
    47.500   516.166     0.150
    47.502   517.176     0.150
    47.536   516.096     0.150
    47.622   516.986     0.150
    47.680   518.066     0.150
    47.739   518.296     0.150
    47.783   518.061     0.150
    47.783   933.826     0.150
    47.830   518.666     0.150
    47.896   519.616     0.150
    47.970   520.846     0.150
    48.018   519.376     0.150
    47.974   519.776     0.150
    47.983   520.026     0.150
    47.983   519.656     0.150
    48.128   521.266     0.150
    48.132   520.876     0.150
    48.207   521.476     0.150
    48.225   521.936     0.150
    48.335   523.166     0.150
    48.339   522.046     0.150
    48.374   523.316     0.150
    48.477   523.676     0.150
    48.491   524.376     0.150
    48.534   525.246     0.150
    48.559   524.226     0.150
    48.559   608.851     0.150
    48.559   637.601     0.150
    48.556   523.646     0.150
    48.570   525.036     0.150
    48.586   525.266     0.150
    48.586   525.624     0.150
    48.586   524.536     0.150
    48.586   524.786     0.150
    48.586     4.130     0.150
    48.586   637.236     0.150
    48.579   525.276     0.150
    48.595   525.676     0.150
    48.588   524.176     0.150
    48.614   525.706     0.150
    48.719   526.976     0.150
    48.741   525.616     0.150
    48.756   526.446     0.150
    48.746   527.276     0.150
    48.869   527.706     0.150
    48.946   643.676     0.150
    48.946   952.476     0.150
    48.946   957.276     0.150
    48.939   527.921     0.150
    48.939   527.126     0.150
    48.939   527.696     0.150
    48.939   527.526     0.150
    48.939     2.540     0.150
    48.939   642.776     0.150
    48.982   527.776     0.150
    49.004   527.796     0.150
    49.040   529.126     0.150
    49.095   527.896     0.150
    49.184   528.776     0.150
    49.184   647.376     0.150
    49.141   530.567     0.150
    49.141   529.786     0.150
    49.180   529.986     0.150
    49.185   529.466     0.150
    49.239   955.076     0.150
    49.239   528.926     0.150
    49.256   529.986     0.150
    49.258   531.376     0.150
    49.283   531.136     0.150
    49.293   530.018     0.150
    49.361   530.736     0.150
    49.367   530.326     0.150
    49.417   529.776     0.150
    49.436   531.406     0.150
    49.513   531.476     0.150
    49.513   961.376     0.150
    49.484   531.486     0.150
    49.486   532.446     0.150
    49.545   531.386     0.150
    49.526   531.676     0.150
    49.556   532.286     0.150
    49.572   532.573     0.150
    49.755   532.346     0.150
    49.755   532.149     0.150
    49.755   532.526     0.150
    49.755   533.176     0.150
    49.755     3.200     0.150
    49.755   614.076     0.150
    49.755   647.576     0.150
    49.755   962.776     0.150
    49.755  1124.876     0.150
    49.766   534.666     0.150
    49.838   533.976     0.150
    49.922   534.576     0.150
    50.265   537.466     0.150
    50.256   536.516     0.150
    50.262   537.542     0.150
    50.307   536.506     0.150
    50.307   537.446     0.150
    50.307   537.576     0.150
    50.314   537.606     0.150
    50.314   966.186     0.150
    50.342   537.996     0.150
    50.343   537.646     0.150
    50.343   538.426     0.150
    50.343   538.216     0.150
    50.343   538.926     0.150
    50.475   538.366     0.150
    50.506   538.326     0.150
    50.506   539.276     0.150
    50.572   538.896     0.150
    50.572   970.456     0.150
    50.623   540.256     0.150
    50.623   539.529     0.150
    50.650   539.671     0.150
    50.685   537.976     0.150
    50.717   540.776     0.150
    50.817   539.806     0.150
    50.817   540.574     0.150
    50.817   539.946     0.150
    50.979   543.716     0.150
    50.979   543.976     0.150
    51.066   544.316     0.150
    51.066   543.966     0.150
    51.390   545.166     0.150
    51.390   981.856     0.150
    51.424   546.216     0.150
    51.424   546.686     0.150
    51.424   545.286     0.150
    51.422   546.176     0.150
    51.666   548.576     0.150
    51.774   547.666     0.150
    51.775   547.926     0.150
    51.775   622.960     0.150
    51.775   667.267     0.150
    51.775   992.276     0.150
    51.775  2386.451     0.150
    51.775   547.676     0.150
    51.798   549.076     0.150
    51.791   548.331     0.150
    51.897   550.666     0.150
    51.897   549.896     0.150
    51.912   550.876     0.150
    51.912   550.619     0.150
    51.949   550.766     0.150
    51.949   551.674     0.150
    51.949   549.706     0.150
    52.128   550.669     0.150
    52.128   623.519     0.150
    52.128   995.894     0.150
    52.128   550.376     0.150
    52.128   993.876     0.150
    52.097   550.276     0.150
    52.097   550.486     0.150
    52.097   551.096     0.150
    52.265   552.376     0.150
    52.307   554.236     0.150
    52.307   554.873     0.150
    52.323   552.016     0.150
    52.323   551.286     0.150
    52.384   553.301     0.150
    52.384   552.256     0.150
    52.384   552.346     0.150
    52.343   552.976     0.150
    52.385   552.576     0.150
    52.385   997.826     0.150
    52.378   553.576     0.150
    52.461   554.776     0.150
    53.022   558.676     0.150
    53.006   556.316     0.150
    53.159   558.506     0.150
    53.159   560.092     0.150
    53.159   558.676     0.150
    53.162   558.706     0.150
    53.442   560.226     0.150
    53.442   560.776     0.150
    53.442   560.176     0.150
    53.442   628.068     0.150
    53.442  1014.077     0.150
    53.442   559.646     0.150
    53.665   562.876     0.150
    54.010   563.306     0.150
    54.059   567.446     0.150
    54.192   566.436     0.150
    54.192   565.936     0.150
    54.192   567.721     0.150
    54.353   567.706     0.150
    54.382   568.086     0.150
    54.453   568.056     0.150
    54.453   568.256     0.150
    54.510   569.417     0.150
    54.510   568.206     0.150
    54.494   568.206     0.150
    54.494   569.152     0.150
    54.494   568.426     0.150
    54.602   569.036     0.150
    54.602   569.316     0.150
    54.651   568.746     0.150
    54.639   569.336     0.150
    54.745   569.876     0.150
    54.703   569.446     0.150
    54.703   570.036     0.150
    54.956   573.196     0.150
    55.124   572.876     0.150
    55.130   573.962     0.150
    55.130   574.346     0.150
    55.130   573.546     0.150
    55.130     4.360     0.150
    55.278   573.406     0.150
    55.278   574.166     0.150
    55.507  1042.806     0.150
    55.677   577.176     0.150
    55.677  1045.116     0.150
    55.717   577.916     0.150
    55.758   579.096     0.150
    55.758   579.726     0.150
    55.758   577.856     0.150
    55.758   579.926     0.150
    55.758     3.350     0.150
    55.841   580.726     0.150
    55.823   579.346     0.150
    55.903   578.786     0.150
    55.903  1047.906     0.150
    56.010   579.516     0.150
    56.010  1049.526     0.150
    56.202   581.046     0.150
    56.202   581.236     0.150
    56.202   580.566     0.150
    56.374   581.576     0.150
    56.374   642.076     0.150
    56.454   583.486     0.150
    56.454   582.036     0.150
    56.521   585.731     0.150
    56.510   583.356     0.150
    56.510   583.186     0.150
    56.614   582.966     0.150
    56.614   584.426     0.150
    56.614   582.846     0.150
    56.647   584.735     0.150
    56.728   584.076     0.150
    56.728  1057.276     0.150
    57.310   588.516     0.150
    57.310   588.616     0.150
    57.310   588.396     0.150
    58.149   594.326     0.150
    58.149   595.026     0.150
    58.256   595.476     0.150
    58.256   596.526     0.150
    58.534  1084.176     0.150
    58.714   599.376     0.150
    59.094   600.976     0.150
    59.094   601.610     0.150
    59.094   602.056     0.150
    59.586   603.986     0.150
    59.838   605.976     0.150
    59.838   742.476     0.150
    59.838  1096.676     0.150
    59.838   605.566     0.150
    59.838   605.779     0.150
    59.838   605.036     0.150
    60.002   608.576     0.150
    60.002  1104.076     0.150
    60.013   606.916     0.150
    60.013   607.887     0.150
    60.060   608.646     0.150
    60.060   608.216     0.150
    60.060   609.396     0.150
    60.060   608.946     0.150
    60.060     2.240     0.150
    60.060   741.896     0.150
    60.070   605.096     0.150
    60.170   608.936     0.150
    60.170   608.464     0.150
    60.170   609.496     0.150
    60.301   609.876     0.150
    60.301   610.016     0.150
    60.301   609.386     0.150
    60.437   609.306     0.150
    60.437   610.271     0.150
    60.437   610.056     0.150
    60.437     3.430     0.150
    60.411   610.576     0.150
    60.411   611.426     0.150
    60.411   611.576     0.150
    60.439   610.125     0.150
    60.439   655.976     0.150
    60.439  1106.876     0.150
    60.439   609.786     0.150
    60.723   612.676     0.150
    60.723   612.466     0.150
    60.721   611.676     0.150
    60.721   612.476     0.150
    60.890   612.796     0.150
    60.890   613.269     0.150
    60.929   615.346     0.150
    60.929   614.805     0.150
    60.929   616.419     0.150
    61.881   620.916     0.150
    61.881   621.102     0.150
    61.881   620.766     0.150
    61.881   619.696     0.150
    61.881     2.520     0.150
    62.489   624.816     0.150
    62.781   626.866     0.150
    62.781   625.326     0.150
    62.819   627.166     0.150
    62.819   627.306     0.150
    62.933   665.976     0.150
    62.994   627.736     0.150
    63.010   625.806     0.150
    63.492   631.576     0.150
    63.492   631.036     0.150
    63.492   631.921     0.150
    63.492   632.171     0.150
    63.778   633.576     0.150
    63.778   671.376     0.150
    63.778  1148.876     0.150
    64.001   634.226     0.150
    64.001   633.456     0.150
    64.019   634.316     0.150
    64.019   634.526     0.150
    64.019   634.146     0.150
    64.207   636.816     0.150
    64.207   636.487     0.150
    64.207   636.236     0.150
    64.317   637.276     0.150
    64.317   637.656     0.150
    64.444   635.826     0.150
    64.540   640.346     0.150
    64.685   638.986     0.150
    65.056   641.046     0.150
    65.649   644.946     0.150
    65.649   645.176     0.150
    65.697   645.576     0.150
    65.697   644.836     0.150
    65.723   645.956     0.150
    66.187   649.006     0.150
    66.332   649.676     0.150
    66.332   647.993     0.150
    66.332   795.551     0.150
    66.332  1179.826     0.150
    66.332  2362.501     0.150
    66.341   649.816     0.150
    66.341   649.476     0.150
    66.738   651.596     0.150
    66.738   652.246     0.150
    66.816   652.186     0.150
    66.885   651.656     0.150
    66.885   651.939     0.150
    66.885   651.386     0.150
    66.885   651.776     0.150
    66.885   798.376     0.150
    66.885  1181.376     0.150
    66.889   650.906     0.150
    67.210   654.726     0.150
    67.210  1188.976     0.150
    67.210   654.076     0.150
    67.210   654.316     0.150
    67.210   655.386     0.150
    67.583   657.136     0.150
    67.583   655.619     0.150
    68.005   660.236     0.150
    68.105   661.966     0.150
    68.105   662.246     0.150
    68.149   660.556     0.150
    68.149   661.246     0.150
    68.149   660.916     0.150
    68.149   659.876     0.150
    68.149     3.380     0.150
    68.601   663.576     0.150
    68.601   663.366     0.150
    68.601   663.966     0.150
    68.601   664.256     0.150
    69.099   665.976     0.150
    69.099   666.606     0.150
    69.099   666.156     0.150
    69.430   668.876     0.150
    69.430   668.136     0.150
    69.496   669.436     0.150
    70.045   670.696     0.150
    69.932   673.236     0.150
    70.034   671.706     0.150
    70.034   672.120     0.150
    70.034   671.400     0.150
    71.059   679.776     0.150
    71.059   680.296     0.150
    71.059   680.742     0.150
    71.059   681.386     0.150
    71.817   682.536     0.150
    71.817   682.894     0.150
    71.817  1242.951     0.150
    71.817   683.526     0.150
    71.817   681.226     0.150
    71.817   681.616     0.150
    71.904   683.836     0.150
    72.175   685.306     0.150
    72.301   686.056     0.150
    72.508   688.498     0.150
    72.508   687.426     0.150
    72.772   688.586     0.150
    72.969   690.424     0.150
    72.969   690.296     0.150
    72.996   690.746     0.150
    73.102   691.396     0.150
    73.185   691.972     0.150
    73.185   692.716     0.150
    73.198   692.126     0.150
    73.532   692.536     0.150
    73.545   692.646     0.150
    73.545   692.897     0.150
    73.545   692.267     0.150
    73.545   693.246     0.150
    73.729   694.646     0.150
    74.038   696.466     0.150
    74.395   698.866     0.150
    74.431   700.676     0.150
    74.436   699.996     0.150
    74.436   698.806     0.150
    74.436   699.616     0.150
    74.475   698.576     0.150
    74.630   699.706     0.150
    74.895   701.296     0.150
    74.942   702.476     0.150
    74.942   702.315     0.150
    75.201   703.056     0.150
    75.534   704.916     0.150
    75.534   705.446     0.150
    75.534   704.396     0.150
    75.537   705.276     0.150
    75.535   705.296     0.150
    75.596   705.346     0.150
    75.596   707.224     0.150
    76.022   707.486     0.150
    76.020   708.226     0.150
    76.091   708.606     0.150
    76.412   709.976     0.150
    76.498   710.766     0.150
    76.569   711.176     0.150
    76.700   712.166     0.150
    76.758   712.106     0.150
    76.758   712.276     0.150
    76.758   711.846     0.150
    77.022   713.416     0.150
    77.084   714.366     0.150
    77.045   715.368     0.150
    77.045   714.816     0.150
    77.045   713.876     0.150
    77.045   714.696     0.150
    77.259   715.646     0.150
    77.291   715.496     0.150
    77.342   715.226     0.150
    77.461   715.896     0.150
    77.512   716.616     0.150
    77.618   716.926     0.150
    77.879   717.866     0.150
    77.978   719.821     0.150
    77.996   719.504     0.150
    77.994   719.026     0.150
    78.142   720.006     0.150
    78.142   720.521     0.150
    78.142   719.686     0.150
    78.142   721.246     0.150
    78.102   721.046     0.150
    78.102   720.774     0.150
    78.102   720.306     0.150
    78.102   721.271     0.150
    78.173   719.296     0.150
    78.243   720.106     0.150
    78.243   720.106     0.150
    78.342   721.186     0.150
    78.342   719.616     0.150
    78.357   720.606     0.150
    78.406   721.016     0.150
    78.406   720.676     0.150
    78.406   897.976     0.150
    78.406  1320.226     0.150
    78.406  1857.977     0.150
    78.406   720.156     0.150
    78.428   721.536     0.150
    78.459   722.186     0.150
    78.465   721.196     0.150
    78.622   722.486     0.150
    78.727   722.216     0.150
    78.811   722.816     0.150
    78.978   724.736     0.150
    79.062   724.606     0.150
    79.124   724.986     0.150
    79.289   725.276     0.150
    79.305   726.496     0.150
    79.305   725.826     0.150
    79.435   727.076     0.150
    79.630   727.876     0.150
    79.694   727.626     0.150
    79.708   728.446     0.150
    79.767   728.276     0.150
    79.767   727.096     0.150
    79.767   727.365     0.150
    79.871   729.036     0.150
    79.908   729.226     0.150
    79.908   729.976     0.150
    79.902   729.286     0.150
    79.924   728.886     0.150
    79.987   729.056     0.150
    80.018   729.236     0.150
    80.128   730.836     0.150
    80.227   731.486     0.150
    80.227   731.116     0.150
    80.314   731.286     0.150
    80.314   732.704     0.150
    80.363   732.676     0.150
    80.644   733.926     0.150
    80.692   733.683     0.150
    80.692   732.726     0.150
    80.692   733.316     0.150
    80.692   734.076     0.150
    80.692   732.716     0.150
    80.698   733.216     0.150
    80.698   734.103     0.150
    80.698  1342.151     0.150
    80.698   733.756     0.150
    80.756   733.936     0.150
    80.750   734.438     0.150
    80.833   734.216     0.150
    80.876   734.136     0.150
    80.892   734.856     0.150
    80.892   737.156     0.150
    80.941   735.336     0.150
    80.978   735.376     0.150
    81.015   735.726     0.150
    81.018   735.776     0.150
    81.119   736.136     0.150
    81.115   736.166     0.150
    81.124   735.136     0.150
    81.178   736.386     0.150
    81.203   736.386     0.150
    81.261   737.116     0.150
    81.320   738.246     0.150
    81.320   737.903     0.150
    81.488   738.616     0.150
    81.501   737.816     0.150
    81.600   738.916     0.150
    81.600   739.384     0.150
    81.618   738.006     0.150
    81.620   738.751     0.150
    81.593   739.176     0.150
    81.593   739.396     0.150
    81.706   739.486     0.150
    81.706   740.464     0.150
    81.938   740.706     0.150
    81.963   741.416     0.150
    82.029   741.466     0.150
    82.029   742.224     0.150
    82.140   741.146     0.150
    82.140   740.786     0.150
    82.178   742.096     0.150
    82.291   742.556     0.150
    82.359   741.156     0.150
    82.438   743.316     0.150
    82.542   743.876     0.150
    82.589   744.376     0.150
    82.684   745.186     0.150
    82.750   745.096     0.150
    82.763   746.364     0.150
    82.841   745.296     0.150
    82.848   744.886     0.150
    82.848   744.746     0.150
    83.029   746.836     0.150
    83.079   746.806     0.150
    83.148   746.926     0.150
    83.217   745.926     0.150
    83.216   746.526     0.150
    83.216   937.426     0.150
    83.216  1365.551     0.150
    83.216  1846.401     0.150
    83.216   746.716     0.150
    83.224   746.706     0.150
    83.322   748.668     0.150
    83.322   747.466     0.150
    83.494   749.346     0.150
    83.494   749.546     0.150
    83.494   749.086     0.150
    83.494   749.796     0.150
    83.535   751.396     0.150
    83.594   749.166     0.150
    83.811   750.121     0.150
    84.088   751.676     0.150
    84.088   751.336     0.150
    84.122   752.736     0.150
    84.171   749.896     0.150
    84.843   754.676     0.150
    84.843   754.116     0.150
    84.879   755.576     0.150
    84.932   756.326     0.150
    85.223   756.866     0.150
    85.397   758.376     0.150
    85.766   759.499     0.150
    85.929   761.777     0.150
    86.125   762.126     0.150
    86.189   760.896     0.150
    86.390   762.551     0.150
    86.456   763.686     0.150
    86.471   764.704     0.150
    86.482   763.656     0.150
    86.482   764.301     0.150
    86.536   763.506     0.150
    86.626   763.276     0.150
    87.234   767.776     0.150
    87.489   768.262     0.150
    87.489   973.801     0.150
    87.489  1072.988     0.150
    87.489  1395.351     0.150
    87.489  1837.926     0.150
    87.489  2325.201     0.150
    87.489   768.026     0.150
    87.537   768.956     0.150
    87.649   768.401     0.150
    87.743   769.566     0.150
    88.157   771.786     0.150
    88.530   773.696     0.150
    88.738   775.676     0.150
    89.370   779.086     0.150
    89.465   777.640     0.150
    89.465   777.661     0.150
    89.465  1075.263     0.150
    89.465  1404.976     0.150
    89.465  1833.076     0.150
    89.465  2321.376     0.150
    89.465   776.476     0.150
    89.684   778.816     0.150
    89.678   778.706     0.150
    89.981   780.306     0.150
    89.981   780.471     0.150
    89.981   779.796     0.150
    89.981   781.021     0.150
    89.981   780.271     0.150
    89.981   779.466     0.150
    90.038   781.436     0.150
    90.523   783.366     0.150
    90.584   783.426     0.150
    90.723   783.621     0.150
    90.723  1000.176     0.150
    90.742   784.376     0.150
    91.057   786.846     0.150
    91.315   787.094     0.150
    91.798   787.926     0.150
    91.798   787.166     0.150
    91.817   789.506     0.150
    91.854   788.956     0.150
    92.288   788.821     0.150
    92.459   791.566     0.150
    92.772   794.356     0.150
    92.826   794.606     0.150
    93.022   795.506     0.150
    93.136   796.316     0.150
    93.262   794.701     0.150
    93.288   795.248     0.150
    93.288  1018.085     0.150
    93.288  1425.451     0.150
    93.288  1822.526     0.150
    93.288   795.116     0.150
    93.293   795.726     0.150
    93.381   795.546     0.150
    93.427   796.796     0.150
    93.655   796.376     0.150
    94.013   798.346     0.150
    94.024   799.396     0.150
    94.203   801.376     0.150
    94.411   800.904     0.150
    94.431   801.936     0.150
    94.431   802.276     0.150
    94.474   800.836     0.150
    94.474   801.156     0.150
    94.641   802.676     0.150
    95.101   805.176     0.150
    95.101   803.706     0.150
    95.142   803.606     0.150
    95.142   804.196     0.150
    95.142   803.916     0.150
    95.276   806.246     0.150
    95.495   807.526     0.150
    95.619   807.856     0.150
    95.736   807.786     0.150
    96.452   811.026     0.150
    96.520   810.836     0.150
    96.520   810.594     0.150
    96.520   811.226     0.150
    96.545   810.226     0.150
    96.625   810.446     0.150
    96.625   810.180     0.150
    96.625   811.316     0.150
    96.617   811.498     0.150
    96.664   812.696     0.150
    96.664   813.346     0.150
    96.864   812.736     0.150
    96.955   813.586     0.150
    97.114   814.206     0.150
    97.293   815.406     0.150
    97.299   814.996     0.150
    97.339   814.486     0.150
    97.415   814.796     0.150
    97.426   815.782     0.150
    97.514   815.606     0.150
    97.514   815.043     0.150
    97.514  1052.895     0.150
    97.514  2305.795     0.150
    97.518   815.093     0.150
    97.571   815.816     0.150
    97.981   817.066     0.150
    98.103   818.336     0.150
    98.489   817.916     0.150
    98.515   820.176     0.150
    98.664   820.166     0.150
    98.721   820.816     0.150
    98.728   820.706     0.150
    98.755   820.256     0.150
    98.769   820.896     0.150
    98.848   822.555     0.150
    98.840   820.806     0.150
    98.871   820.766     0.150
    98.880   821.826     0.150
    98.891   821.616     0.150
    98.928   822.316     0.150
    98.960   822.026     0.150
    99.063   823.656     0.150
    99.286   823.626     0.150
    99.378   824.230     0.150
    99.577   823.766     0.150
    99.619   823.676     0.150
    99.645   824.946     0.150
    99.645   824.840     0.150
    99.753   824.083     0.150
    99.804   824.136     0.150
    99.804  1460.151     0.150
    99.804   823.676     0.150
    99.804   825.073     0.150
    99.977   827.271     0.150
   100.635   830.266     0.150
   100.635   829.789     0.150
   100.730   829.666     0.150
   100.928   830.069     0.150
   101.723   834.798     0.150
   101.880   832.608     0.150
   101.880  1096.184     0.150
   102.058   836.376     0.150
   102.151   836.496     0.150
   102.521   836.810     0.150
   102.628   838.054     0.150
   102.628  1088.776     0.150
   102.628  1795.426     0.150
   102.628  2295.026     0.150
   102.708   837.609     0.150
   102.758   840.126     0.150
   103.151   840.774     0.150
   103.151  1091.520     0.150
   103.346   842.916     0.150
   103.944   845.506     0.150
   104.221   845.366     0.150
   104.614  1100.076     0.150
   104.614  1105.276     0.150
   104.992   849.338     0.150
   104.992  2291.876     0.150
   107.347   858.867     0.150
   107.347  1107.990     0.150
   107.347  1123.176     0.150
   107.347  1781.751     0.150
   107.347  2287.001     0.150
   109.637  1112.766     0.150
   109.986   874.196     0.150
   110.979  1113.976     0.150
   110.979  2082.576     0.150
   114.009  1119.229     0.150
   114.994  1122.475     0.150
   114.994  1180.672     0.150
   114.994  1757.227     0.150
   115.049  1122.671     0.150
   115.049  1181.359     0.150
   115.156  1122.637     0.150
   115.156  1122.277     0.150
   115.156  1120.687     0.150
   115.156  1757.269     0.150
   115.990  1124.008     0.150
   116.098  1186.417     0.150
   116.324  1123.906     0.150
   117.736  1127.326     0.150
   118.592  1130.996     0.150
   118.592  1128.725     0.150
   119.015  1130.676     0.150
   120.599  1132.926     0.150
   121.094  1133.996     0.150
   121.376  1134.976     0.150
   121.517  1135.556     0.150
   121.705  1135.076     0.150
   122.343  1135.756     0.150
   122.412  1136.776     0.150
   123.013  1137.076     0.150
   123.167  1138.893     0.150
   123.491  1139.576     0.150
   123.550  1139.676     0.150
   123.594  1140.376     0.150
   123.669  1141.066     0.150
   123.669  1139.076     0.150
   123.745  1141.151     0.150
   123.782  1139.136     0.150
   123.782  1139.466     0.150
   123.844  1138.276     0.150
   124.097  1139.199     0.150
   124.216  1142.876     0.150
   124.335  1140.246     0.150
   124.402  1138.246     0.150
   124.402  1138.136     0.150
   124.478  1140.476     0.150
   124.673  1138.389     0.150
   124.922  1139.306     0.150
   124.922  1138.576     0.150
   124.968  1143.569     0.150
   124.984  1138.359     0.150
   125.245  1142.206     0.150
   125.234  1142.596     0.150
   125.350  1141.889     0.150
   125.365  1140.739     0.150
   125.502  1141.676     0.150
   125.738  1142.309     0.150
   125.767  1142.426     0.150
   125.789  1141.076     0.150
   125.844  1145.486     0.150
   125.894  1142.776     0.150
   125.910  1142.596     0.150
   125.989  1142.726     0.150
   126.163  1143.956     0.150
   126.207  1144.156     0.150
   126.349  1140.576     0.150
   126.364  1143.726     0.150
   126.445  1144.176     0.150
   126.531  1141.719     0.150
   126.642  1143.596     0.150
   126.642  1143.436     0.150
   126.718  1140.886     0.150
   126.847  1144.346     0.150
   127.004  1146.286     0.150
   127.103  1144.856     0.150
   127.165  1142.636     0.150
   127.248  1145.716     0.150
   127.392  1146.976     0.150
   127.459  1146.059     0.150
   127.477  1146.200     0.150
   127.728  1145.876     0.150
   127.728  1267.351     0.150
   127.728  1146.496     0.150
   128.162  1142.106     0.150
   128.276  1148.229     0.150
   128.391  1149.676     0.150
   128.481  1147.976     0.150
   128.481  1148.846     0.150
   128.529  1150.076     0.150
   128.625  1148.479     0.150
   128.625  1148.136     0.150
   128.642  1148.626     0.150
   128.642  1149.476     0.150
   128.955  1148.199     0.150
   128.979  1147.749     0.150
   131.147  1152.946     0.150
   131.924  1155.101     0.150
   131.924  1295.626     0.150
   131.924  1155.486     0.150
   133.702  1160.626     0.150
   135.564  1164.551     0.150
   135.942  1162.296     0.150
   136.545  1163.226     0.150
   138.553  1165.326     0.150
   138.809  1169.801     0.150
   140.964  1165.526     0.150
   140.964  1174.426     0.150
   142.304  1173.626     0.150
   142.304  1175.016     0.150
   143.644  1174.426     0.150
   143.644  1173.626     0.150
   143.644  1173.876     0.150
   143.924  1175.266     0.150
   143.924  1172.751     0.150
   144.385  1176.251     0.150
   144.662  1175.916     0.150
   144.662  1175.151     0.150
   147.146  1184.656     0.150
   147.308  1186.296     0.150
   147.690  1181.601     0.150
     1.566    28.275     0.150
     1.764    31.405     0.150
     2.452    42.035     0.150
     2.623    44.535     0.150
     2.678    45.435     0.150
     3.341    55.235     0.150
     3.616    57.935     0.150
     4.040    64.235     0.150
     4.216    64.885     0.150
     4.222    66.235     0.150
     4.533    71.835     0.150
     4.565    71.335     0.150
     4.592    73.635     0.150
     4.592   149.460     0.150
     5.113    78.435     0.150
     5.113    76.805     0.150
     5.276    80.235     0.150
     5.756    88.735     0.150
     5.756    86.375     0.150
     5.708    86.305     0.150
     6.234    93.935     0.150
     6.272    94.335     0.150
     6.272    93.705     0.150
     6.279    93.655     0.150
     6.445    93.195     0.150
     6.627    98.945     0.150
     6.702   101.035     0.150
     6.740   101.335     0.150
     7.074   105.495     0.150
     7.040   105.235     0.150
     7.222   107.535     0.150
     7.222   107.165     0.150
     7.512   111.235     0.150
     7.870   115.745     0.150
     7.925   116.565     0.150
     8.279   123.235     0.150
     8.831   128.615     0.150
     8.831   128.245     0.150
     8.795   128.615     0.150
     8.808   129.035     0.150
     8.929   130.295     0.150
     9.039   132.585     0.150
     9.098   132.585     0.150
     9.167   133.735     0.150
     9.324   135.935     0.150
     9.324   136.545     0.150
     9.933   142.965     0.150
     9.929   144.265     0.150
    10.576   150.805     0.150
    10.722   153.210     0.150
    10.722   269.444     0.150
    10.722   153.335     0.150
    10.722   153.845     0.150
    10.862   158.335     0.150
    10.793   155.195     0.150
    10.903   154.795     0.150
    11.118   158.835     0.150
    12.039   171.435     0.150
    12.124   175.585     0.150
    12.115   170.595     0.150
    12.460   180.165     0.150
    12.494   181.805     0.150
    12.509   176.865     0.150
    12.580   179.925     0.150
    12.580   179.354     0.150
    12.580   314.629     0.150
    12.580   178.155     0.150
    12.580   180.633     0.150
    12.580   318.855     0.150
    12.580   179.235     0.150
    12.580   178.515     0.150
    13.043   186.205     0.150
    13.161   190.165     0.150
    14.016   197.735     0.150
    14.016   198.035     0.150
    14.068   201.035     0.150
    14.259   201.025     0.150
    14.346   204.705     0.150
    14.709   207.260     0.150
    14.709   367.835     0.150
    15.131   219.525     0.150
    15.619   218.517     0.150
    16.080   224.260     0.150
    17.393   244.560     0.150
    17.393   246.535     0.150
    17.555   245.535     0.150
    17.628   248.665     0.150
    17.628   247.935     0.150
    18.191   253.545     0.150
    18.191   253.075     0.150
    19.329   266.335     0.150
    19.334   266.525     0.150
    19.503   267.210     0.150
    19.990   273.135     0.150
    20.097   273.135     0.150
    20.966   283.885     0.150
    20.973   288.495     0.150
    21.813   294.435     0.150
    22.199   300.545     0.150
    22.376   298.945     0.150
    22.594   299.655     0.150
    22.594   323.705     0.150
    22.594   533.545     0.150
    22.594   548.915     0.150
    23.165   308.535     0.150
    23.168   308.625     0.150
    23.168   308.335     0.150
    23.168   309.285     0.150
    23.571   311.735     0.150
    23.699   315.445     0.150
    23.720   315.035     0.150
    23.720   570.635     0.150
    23.827   316.585     0.150
    25.061   326.695     0.150
    25.061   325.475     0.150
    25.061   326.085     0.150
    25.079   325.135     0.150
    25.079   325.285     0.150
    25.079   325.625     0.150
    25.079   325.935     0.150
    26.144   335.745     0.150
    26.996   346.935     0.150
    28.707   357.860     0.150
    28.707   357.935     0.150
    33.533   398.865     0.150
    34.097   407.045     0.150
    34.097   405.515     0.150
    35.252   416.615     0.150
    35.592   420.615     0.150
    35.818   422.185     0.150
    35.931   421.715     0.150
    36.152   423.755     0.150
    36.275   424.645     0.150
    36.275   424.175     0.150
    36.279   424.645     0.150
    36.309   424.635     0.150
    36.313   424.985     0.150
    36.470   425.455     0.150
    36.470   425.635     0.150
    36.470   426.035     0.150
    36.484   425.635     0.150
    36.503   425.835     0.150
    36.740   428.305     0.150
    36.827   432.425     0.150
    37.470   436.329     0.150
    37.474   436.159     0.150
    37.687   437.075     0.150
    37.954   802.135     0.150
    38.137   441.191     0.150
    38.185   441.745     0.150
    38.307   442.516     0.150
    38.430   444.135     0.150
    38.430   443.585     0.150
    38.430   443.235     0.150
    38.768   446.270     0.150
    38.997   447.285     0.150
    38.997   446.685     0.150
    39.000   449.095     0.150
    39.013   448.745     0.150
    38.831   448.415     0.150
    39.125   449.175     0.150
    39.968   455.035     0.150
    40.068   456.799     0.150
    40.096   456.799     0.150
    40.199   458.048     0.150
    40.325   458.611     0.150
    40.713   461.525     0.150
    40.670   461.845     0.150
    40.670   461.333     0.150
    41.038   464.285     0.150
    41.304   466.705     0.150
    41.304   466.565     0.150
    41.699   469.415     0.150
    41.630   469.335     0.150
    41.630   468.935     0.150
    41.649   469.505     0.150
    42.467   475.685     0.150
    42.478   477.015     0.150
    42.490   476.285     0.150
    42.484   476.205     0.150
    42.693   477.905     0.150
    42.672   478.515     0.150
    42.673   478.560     0.150
    42.673   479.185     0.150
    42.673   478.035     0.150
    42.732   479.535     0.150
    42.863   480.815     0.150
    43.006   481.865     0.150
    43.135   482.755     0.150
    43.183   482.685     0.150
    43.973   488.755     0.150
    44.386   492.935     0.150
    44.508   493.285     0.150
    44.508   492.405     0.150
    44.508   492.635     0.150
    44.508   492.915     0.150
    44.508     2.430     0.150
    44.763   494.425     0.150
    45.690   501.235     0.150
    46.450   508.635     0.150
    46.720   508.235     0.150
    46.720   508.405     0.150
    46.831   511.125     0.150
    47.766   518.760     0.150
    48.378   523.015     0.150
    48.578   524.510     0.150
    49.121   529.035     0.150
    49.396   531.795     0.150
    49.698   532.635     0.150
    50.400   539.675     0.150
    50.400   539.415     0.150
    50.510   539.945     0.150
    50.782   539.545     0.150
    51.359   544.735     0.150
    51.775   548.835     0.150
    51.804   548.735     0.150
    51.813   548.325     0.150
    51.815   548.885     0.150
    51.815   548.685     0.150
    52.064   550.135     0.150
    52.137   551.535     0.150
    52.137   551.875     0.150
    52.137   551.235     0.150
    52.320   552.635     0.150
    52.718   556.095     0.150
    53.378   559.785     0.150
    54.230   567.975     0.150
    54.230   567.315     0.150
    54.482   568.925     0.150
    54.482   568.335     0.150
    54.482     2.800     0.150
    54.648   569.305     0.150
    54.648   570.165     0.150
    54.742   570.935     0.150
    54.742   570.625     0.150
    55.163   574.275     0.150
    55.318   574.195     0.150
    55.717   577.755     0.150
    59.153   602.635     0.150
    59.949   606.635     0.150
    60.374   609.185     0.150
    60.410   609.735     0.150
    66.825   652.335     0.150
    68.211   661.605     0.150
    68.211   661.235     0.150
    68.211   661.785     0.150
    68.211     2.340     0.150
    68.659   664.035     0.150
    68.659   664.375     0.150
    68.659     2.330     0.150
    70.105   671.985     0.150
    69.988   672.385     0.150
    71.874   683.585     0.150
    71.874   683.145     0.150
    73.482   693.985     0.150
    75.485   705.275     0.150
    75.979   708.355     0.150
    76.456   710.595     0.150
    77.419   716.165     0.150
    77.576   716.905     0.150
    77.953   718.145     0.150
    78.132   719.995     0.150
    78.201   720.725     0.150
    78.316   721.095     0.150
    78.365   721.835     0.150
    78.365   720.735     0.150
    78.365   721.725     0.150
    78.381   721.915     0.150
    78.579   722.605     0.150
    79.087   725.575     0.150
    79.590   728.235     0.150
    79.951   730.105     0.150
    79.951   729.035     0.150
    79.974   729.065     0.150
    80.713   734.065     0.150
    80.794   734.945     0.150
    80.834   734.125     0.150
    80.976   735.635     0.150
    81.448   738.375     0.150
    83.189   746.510     0.150
    83.189   747.935     0.150
    83.189   747.435     0.150
    83.449   748.029     0.150
    87.450   767.760     0.150
    87.450   767.945     0.150
    87.452   768.335     0.150
    89.429   777.435     0.150
    89.428   777.485     0.150
    89.461   777.535     0.150
    89.953   779.835     0.150
    93.274   796.085     0.150
   124.431  1138.385     0.150
   124.431  1137.754     0.150
   142.369  1173.885     0.150
     1.507    27.759     0.150
     1.507    48.859     0.150
     1.713    30.039     0.150
     1.713    54.309     0.150
     1.855    33.359     0.150
     1.855    33.829     0.150
     2.305    39.859     0.150
     2.402    40.759     0.150
     2.392    40.359     0.150
     2.581    43.459     0.150
     2.623    43.659     0.150
     2.838    47.419     0.150
     3.052    49.959     0.150
     3.288    53.859     0.150
     3.982    62.859     0.150
     3.982    62.249     0.150
     4.046    64.259     0.150
     4.154    64.509     0.150
     4.161    65.359     0.150
     4.502    68.959     0.150
     4.545    70.109     0.150
     4.545   147.459     0.150
     4.671    71.859     0.150
     4.692    71.759     0.150
     4.810    74.239     0.150
     5.103    77.079     0.150
     5.701    86.659     0.150
     5.653    85.799     0.150
     5.773    87.159     0.150
     5.820    87.149     0.150
     6.179    93.159     0.150
     6.243    93.559     0.150
     6.243    93.039     0.150
     6.219    93.119     0.150
     6.403    92.089     0.150
     6.568    98.189     0.150
     7.110   105.399     0.150
     7.164   105.999     0.150
     8.226   121.059     0.150
     8.976   131.079     0.150
     9.865   143.529     0.150
     9.974   144.279     0.150
    10.619   152.409     0.150
    10.949   155.859     0.150
    12.624   179.128     0.150
    12.624   319.978     0.150
    12.624   179.289     0.150
    14.699   217.269     0.150
    14.772   208.053     0.150
    14.772   218.179     0.150
    15.413   224.849     0.150
    16.066   224.759     0.150
    16.066   395.784     0.150
    17.340   240.934     0.150
    18.072   252.269     0.150
    18.139   251.619     0.150
    19.342   265.859     0.150
    19.546   267.109     0.150
    22.642   300.479     0.150
    22.642   323.989     0.150
    22.642   533.189     0.150
    22.642   549.529     0.150
    23.107   307.309     0.150
    23.107   308.659     0.150
    23.508   311.879     0.150
    25.110   325.034     0.150
    25.110   325.639     0.150
    26.081   335.089     0.150
    28.658   356.959     0.150
    28.665   357.849     0.150
    30.313   373.509     0.150
    35.218   415.139     0.150
    36.532   424.959     0.150
    40.158   456.834     0.150
    40.300   458.034     0.150
    40.300   458.549     0.150
    41.248   465.799     0.150
    41.559   468.279     0.150
    41.570   468.429     0.150
    41.590   468.559     0.150
    41.590   467.920     0.150
    42.428   475.599     0.150
    42.610   476.809     0.150
    42.610   477.489     0.150
    46.772   510.789     0.150
    48.319   522.209     0.150
    48.531   523.103     0.150
    51.754   547.969     0.150
    51.756   547.559     0.150
    51.756   547.839     0.150
    52.112   549.902     0.150
    52.077   550.249     0.150
    52.377   552.359     0.150
    54.172   566.529     0.150
    56.613   584.209     0.150
    71.841   682.009     0.150
    74.405   699.689     0.150
    74.964   702.039     0.150
    75.504   705.459     0.150
    75.991   707.779     0.150
    76.509   711.609     0.150
    77.482   716.609     0.150
    78.213   720.679     0.150
    78.375   720.559     0.150
    78.375   721.019     0.150
    78.591   722.769     0.150
    79.664   728.049     0.150
    83.183   745.559     0.150
    87.509   766.534     0.150
    87.509   767.589     0.150
    87.511   768.239     0.150
    89.486   776.609     0.150
   124.435  1137.128     0.150
     1.603    29.750     0.150
     1.603    51.180     0.150
     1.767    31.610     0.150
     1.767    55.690     0.150
     2.453    41.550     0.150
     2.617    44.150     0.150
     3.609    57.650     0.150
     3.609    57.230     0.150
     4.077    65.250     0.150
     4.233    65.040     0.150
     4.239    66.150     0.150
     4.585    70.650     0.150
     4.633    71.333     0.150
     4.633    85.511     0.150
     4.633   149.460     0.150
     4.764    72.550     0.150
     5.086    77.480     0.150
     5.734    86.150     0.150
     5.733    83.500     0.150
     5.733    88.060     0.150
     5.747    87.650     0.150
     5.821    88.150     0.150
     6.090    92.250     0.150
     6.255    93.650     0.150
     6.255    93.850     0.150
     6.240    94.050     0.150
     6.440    92.760     0.150
     7.003   105.550     0.150
     7.048   104.950     0.150
     7.085   103.660     0.150
     7.232   106.780     0.150
     7.943   117.000     0.150
     8.834   128.630     0.150
     9.166   132.170     0.150
     9.940   142.110     0.150
    10.583   150.570     0.150
    10.736   153.175     0.150
    10.736   153.670     0.150
    10.907   155.270     0.150
    11.707   169.050     0.150
    12.042   169.940     0.150
    12.175   173.220     0.150
    12.509   176.220     0.150
    12.585   178.997     0.150
    12.585   178.710     0.150
    12.585   179.736     0.150
    12.585   318.182     0.150
    12.585   179.970     0.150
    12.950   183.320     0.150
    12.964   182.280     0.150
    13.413   189.030     0.150
    14.017   197.840     0.150
    14.258   200.920     0.150
    14.744   207.540     0.150
    14.744   205.962     0.150
    14.744   364.032     0.150
    14.744   207.220     0.150
    14.868   213.037     0.150
    15.025   212.070     0.150
    15.507   217.620     0.150
    15.638   219.855     0.150
    16.075   224.410     0.150
    16.117   224.399     0.150
    16.117   393.826     0.150
    16.117   224.657     0.150
    16.117   397.004     0.150
    17.433   242.243     0.150
    17.662   244.298     0.150
    18.193   250.380     0.150
    18.193   252.000     0.150
    19.334   265.550     0.150
    19.355   265.011     0.150
    19.509   268.357     0.150
    19.509   267.450     0.150
    19.509   266.490     0.150
    20.005   273.875     0.150
    20.112   273.310     0.150
    20.969   283.580     0.150
    21.439   288.440     0.150
    21.951   295.110     0.150
    23.203   307.275     0.150
    23.203   307.400     0.150
    25.094   325.070     0.150
    25.094   323.780     0.150
    28.747   357.753     0.150
    35.293   415.840     0.150
    36.437   425.100     0.150
    36.437   424.560     0.150
    38.176   440.408     0.150
    40.240   457.932     0.150
    40.364   458.565     0.150
    41.050   463.830     0.150
    41.671   469.450     0.150
    41.671   468.544     0.150
    51.851   548.580     0.150
    52.311   551.633     0.150
    71.859   683.778     0.150
    71.859   681.390     0.150
    78.393   720.500     0.150
    83.223   745.610     0.150
    87.413   767.073     0.150
    87.413   766.480     0.150
    89.391   777.642     0.150
     1.475    27.615     0.150
     1.475    28.004     0.150
     1.640    29.214     0.150
     1.640    29.524     0.150
     1.845    34.015     0.150
     2.301    39.415     0.150
     2.353    40.115     0.150
     2.329    39.714     0.150
     2.601    43.615     0.150
     2.509    42.015     0.150
     2.841    46.955     0.150
     3.033    49.214     0.150
     3.269    53.314     0.150
     3.503    55.845     0.150
     3.870    61.714     0.150
     3.951    62.515     0.150
     3.951    62.875     0.150
     4.028    63.814     0.150
     4.088    63.475     0.150
     4.095    64.015     0.150
     4.472    69.615     0.150
     4.439    69.015     0.150
     4.539    70.613     0.150
     4.539   145.783     0.150
     4.607    70.615     0.150
     4.623    71.115     0.150
     4.795    74.385     0.150
     5.049    76.314     0.150
     5.049    76.125     0.150
     5.153    78.415     0.150
     5.630    86.115     0.150
     5.630    85.385     0.150
     5.700    86.115     0.150
     5.879    87.064     0.150
     5.879    88.834     0.150
     5.992    90.214     0.150
     6.181    93.435     0.150
     6.107    91.814     0.150
     6.177    92.515     0.150
     6.177    92.285     0.150
     6.331    90.834     0.150
     6.499    97.004     0.150
     6.577    98.515     0.150
     6.913   103.214     0.150
     7.094   104.995     0.150
     7.180   105.944     0.150
     7.180   106.104     0.150
     7.166   106.515     0.150
     7.166   105.935     0.150
     7.585   112.915     0.150
     7.797   114.314     0.150
     8.165   120.714     0.150
     8.682   127.814     0.150
     8.808   128.765     0.150
     8.691   127.055     0.150
     8.928   130.924     0.150
     8.950   129.595     0.150
     9.290   135.245     0.150
     9.809   143.044     0.150
     9.875   143.635     0.150
    10.045   144.125     0.150
    10.165   147.314     0.150
    10.690   152.464     0.150
    10.825   155.544     0.150
    10.825   153.254     0.150
    12.696   178.860     0.150
    12.696   179.174     0.150
    12.696   180.354     0.150
    13.510   191.944     0.150
    14.137   199.515     0.150
    14.737   366.114     0.150
    14.737   206.444     0.150
    14.740   208.669     0.150
    14.740   209.285     0.150
    15.709   219.850     0.150
    16.099   223.608     0.150
    16.099   395.393     0.150
    16.194   229.185     0.150
    16.194   231.928     0.150
    17.320   239.934     0.150
    17.331   241.885     0.150
    18.067   250.444     0.150
    18.067   250.185     0.150
    19.400   265.278     0.150
    19.404   265.885     0.150
    19.442   266.604     0.150
    19.618   269.540     0.150
    19.618   268.734     0.150
    19.618   267.944     0.150
    20.088   274.363     0.150
    20.088   275.004     0.150
    20.195   275.115     0.150
    20.195   275.825     0.150
    20.866   283.575     0.150
    21.944   293.480     0.150
    21.944   293.655     0.150
    21.944   294.865     0.150
    22.252   298.185     0.150
    23.068   306.665     0.150
    23.068   305.555     0.150
    25.178   325.423     0.150
    25.178   325.734     0.150
    35.496   416.630     0.150
    35.496   417.024     0.150
    36.576   425.473     0.150
    36.576   425.584     0.150
    40.160   457.468     0.150
    41.142   465.839     0.150
    41.593   468.869     0.150
    48.286   521.975     0.150
    51.723   547.823     0.150
    51.723   546.865     0.150
    71.773   681.773     0.150
    71.773   682.004     0.150
    89.516   778.234     0.150
     1.629    29.850     0.150
     1.629    51.149     0.150
     2.509    42.450     0.150
     4.638    71.358     0.150
     4.638   149.191     0.150
     5.790    87.649     0.150
     6.146    92.350     0.150
     6.308    94.250     0.150
     6.296    94.549     0.150
     7.030   103.479     0.150
     8.778   127.240     0.150
    10.527   150.720     0.150
    10.681   153.759     0.150
    14.714   207.390     0.150
    19.453   266.589     0.150
    19.453   265.939     0.150
    25.041   325.500     0.150
    25.041   323.990     0.150
    40.238   457.647     0.150
    42.110   472.220     0.150
    87.388   765.753     0.150
     1.539    28.669     0.150
     1.539    48.169     0.150
     1.539    27.538     0.150
     1.884    33.868     0.150
     2.420    41.068     0.150
     2.333    40.169     0.150
     2.595    43.669     0.150
     2.654    44.368     0.150
     2.864    48.019     0.150
     3.082    51.169     0.150
     3.318    53.868     0.150
     3.588    57.068     0.150
     3.588    56.719     0.150
     3.906    62.868     0.150
     4.013    63.169     0.150
     4.013    63.499     0.150
     4.077    64.669     0.150
     4.182    63.759     0.150
     4.188    65.469     0.150
     4.531    70.269     0.150
     4.513    70.568     0.150
     4.574    71.153     0.150
     4.574   147.174     0.150
     4.717    72.469     0.150
     4.840    75.238     0.150
     5.100    77.599     0.150
     5.245    79.568     0.150
     5.714    86.568     0.150
     5.684    86.169     0.150
     6.074    91.669     0.150
     6.201    93.269     0.150
     6.249    93.669     0.150
     6.249    93.408     0.150
     6.251    93.339     0.150
     6.417    91.349     0.150
     6.670    99.669     0.150
     7.099   105.389     0.150
     8.861   128.578     0.150
     9.960   143.158     0.150
    10.604   151.538     0.150
    10.747   154.209     0.150
    11.290   162.889     0.150
    12.609   178.762     0.150
    12.609   318.912     0.150
    12.609   179.448     0.150
    12.609   321.035     0.150
    12.609   180.559     0.150
    14.712   206.259     0.150
    14.712   205.889     0.150
    16.081   224.496     0.150
    16.081   394.544     0.150
    19.344   266.041     0.150
    19.531   267.695     0.150
    19.531   266.818     0.150
    20.013   272.305     0.150
    20.120   273.129     0.150
    21.919   293.309     0.150
    25.103   324.358     0.150
    25.103   323.760     0.150
    28.687   358.309     0.150
    35.405   416.849     0.150
    36.500   424.139     0.150
    41.063   464.055     0.150
    41.595   468.038     0.150
    41.616   468.848     0.150
    51.788   546.784     0.150
     1.464    27.414     0.150
     1.464    47.014     0.150
     1.464    27.613     0.150
     1.710    30.312     0.150
     1.710    30.574     0.150
     1.807    33.514     0.150
     2.258    39.713     0.150
     2.400    41.014     0.150
     2.577    43.514     0.150
     2.587    43.713     0.150
     2.790    47.473     0.150
     3.005    50.014     0.150
     3.582    57.514     0.150
     3.582    57.143     0.150
     3.830    61.914     0.150
     3.938    62.613     0.150
     3.938    62.133     0.150
     4.000    64.312     0.150
     4.133    64.434     0.150
     4.140    64.713     0.150
     4.437    70.014     0.150
     4.498    70.264     0.150
     4.498   123.613     0.150
     4.498   144.188     0.150
     4.477    69.113     0.150
     4.648    71.613     0.150
     4.675    71.914     0.150
     4.763    73.613     0.150
     5.134    77.873     0.150
     5.221    79.514     0.150
     5.607    85.914     0.150
     5.607    85.303     0.150
     5.849    85.283     0.150
     5.849    87.184     0.150
     5.708    86.812     0.150
     5.772    87.914     0.150
     6.072    91.914     0.150
     6.177    92.812     0.150
     6.170    93.414     0.150
     6.261    93.713     0.150
     6.261    93.824     0.150
     6.408    92.674     0.150
     6.551    98.732     0.150
     6.644   100.312     0.150
     6.868   103.414     0.150
     7.099   105.133     0.150
     7.099   105.963     0.150
     6.973   104.613     0.150
     7.150   107.402     0.150
     7.245   108.914     0.150
     7.245   107.562     0.150
     7.840   116.963     0.150
     8.876   128.863     0.150
     9.221   132.014     0.150
     9.968   143.133     0.150
    10.743   154.127     0.150
    10.743   268.506     0.150
    10.743   154.104     0.150
    10.947   155.943     0.150
    11.082   158.623     0.150
    11.779   169.312     0.150
    11.779   300.414     0.150
    12.083   170.113     0.150
    12.563   177.463     0.150
    12.620   179.574     0.150
    12.620   178.707     0.150
    12.620   319.057     0.150
    12.620   178.873     0.150
    12.620   317.271     0.150
    12.620   179.973     0.150
    13.099   187.152     0.150
    13.436   189.014     0.150
    14.067   198.312     0.150
    14.313   203.803     0.150
    14.659   206.104     0.150
    14.659   204.988     0.150
    14.659   361.814     0.150
    14.659   206.203     0.150
    14.886   212.674     0.150
    15.029   217.713     0.150
    15.624   218.035     0.150
    15.624   386.604     0.150
    16.024   223.812     0.150
    16.024   392.764     0.150
    16.024   223.377     0.150
    16.024   394.844     0.150
    16.122   225.223     0.150
    17.232   244.213     0.150
    17.293   243.338     0.150
    17.293   244.613     0.150
    17.455   245.113     0.150
    17.523   245.562     0.150
    17.528   244.883     0.150
    17.528   245.613     0.150
    17.528   248.014     0.150
    18.135   250.873     0.150
    18.135   251.863     0.150
    19.100   267.113     0.150
    19.314   265.988     0.150
    19.314   473.039     0.150
    19.319   265.562     0.150
    19.319   266.523     0.150
    19.365   266.143     0.150
    19.365   265.703     0.150
    19.365   266.883     0.150
    19.371   270.312     0.150
    19.541   268.188     0.150
    19.541   268.414     0.150
    19.541   268.914     0.150
    19.541   268.713     0.150
    19.541   267.623     0.150
    19.613   271.312     0.150
    20.005   274.889     0.150
    20.005   273.660     0.150
    20.005   274.014     0.150
    20.111   276.174     0.150
    20.111   275.203     0.150
    20.111   274.486     0.150
    20.111   276.312     0.150
    20.461   279.213     0.150
    21.250   286.914     0.150
    21.394   287.113     0.150
    21.500   289.713     0.150
    21.870   294.713     0.150
    21.854   293.213     0.150
    21.866   295.014     0.150
    21.866   313.113     0.150
    22.486   300.213     0.150
    23.063   308.213     0.150
    23.066   307.514     0.150
    23.066   308.613     0.150
    23.066   306.914     0.150
    23.066   308.363     0.150
    23.066   308.613     0.150
    23.360   310.613     0.150
    25.095   325.613     0.150
    25.095   326.213     0.150
    25.095   325.553     0.150
    25.157   325.232     0.150
    25.157   327.383     0.150
    25.347   330.213     0.150
    26.970   344.613     0.150
    26.970   388.014     0.150
    28.568   356.613     0.150
    28.593   357.713     0.150
    28.611   358.139     0.150
    28.611   356.914     0.150
    28.611   357.914     0.150
    28.618   357.982     0.150
    28.618   357.414     0.150
    28.618     2.959     0.150
    28.621   357.514     0.150
    29.373   364.793     0.150
    33.802   406.152     0.150
    33.840   404.113     0.150
    34.001   408.613     0.150
    35.170   415.504     0.150
    35.426   418.014     0.150
    35.433   417.414     0.150
    36.377   425.424     0.150
    36.377     2.670     0.150
    36.381   425.434     0.150
    36.572   427.312     0.150
    36.586   428.014     0.150
    36.604   427.713     0.150
    36.768   428.693     0.150
    36.725   429.414     0.150
    37.992   440.123     0.150
    38.037   439.164     0.150
    38.231   442.514     0.150
    38.207   442.793     0.150
    39.645   456.732     0.150
    40.111   457.377     0.150
    41.061   463.914     0.150
    41.061   463.643     0.150
    41.543   468.914     0.150
    41.543   468.988     0.150
    42.571   477.838     0.150
    42.996   482.084     0.150
    44.407   492.104     0.150
    46.348   507.562     0.150
    48.484   523.014     0.150
    50.304   539.414     0.150
    51.712   548.264     0.150
    52.034   550.812     0.150
    52.034   550.213     0.150
    52.389   553.914     0.150
    52.615   555.033     0.150
    54.128   567.074     0.150
    54.416   568.703     0.150
    54.546   569.244     0.150
    55.061   573.084     0.150
    55.144   573.113     0.150
    60.174   611.363     0.150
    60.392   610.203     0.150
    62.200   622.844     0.150
    66.253   649.203     0.150
    68.173   661.893     0.150
    78.345   720.764     0.150
    78.563   722.594     0.150
    83.145   747.238     0.150
    87.552   768.463     0.150
    89.530   777.963     0.150
    89.530   778.174     0.150
    89.906   780.152     0.150
     1.497    27.586     0.150
     1.497    47.785     0.150
     1.706    30.086     0.150
     1.846    33.188     0.150
     1.846    33.445     0.150
     2.297    39.688     0.150
     2.382    40.086     0.150
     2.395    40.586     0.150
     2.576    43.188     0.150
     2.831    47.605     0.150
     3.570    56.785     0.150
     3.869    61.988     0.150
     3.972    63.086     0.150
     4.037    64.086     0.150
     4.145    64.438     0.150
     4.152    64.488     0.150
     4.537    69.562     0.150
     4.537   146.785     0.150
     4.683    71.688     0.150
     4.801    75.246     0.150
     5.104    78.387     0.150
     5.218    79.285     0.150
     5.644    85.766     0.150
     5.767    87.285     0.150
     6.171    92.988     0.150
     6.397    91.457     0.150
     6.559    97.566     0.150
     7.209   108.387     0.150
     7.209   108.047     0.150
    16.062   225.410     0.150
    19.551   268.461     0.150
    20.023   273.535     0.150
    21.902   293.855     0.150
    25.114   324.410     0.150
    35.211   415.488     0.150
    36.542   425.238     0.150
    51.746   547.809     0.150
    87.519   767.363     0.150
    89.496   776.938     0.150
   116.018   898.273     0.150
   116.126   893.324     0.150
     1.426    26.426     0.150
     1.426    45.426     0.150
     1.426    26.617     0.150
     1.669    29.324     0.150
     1.779    32.324     0.150
     1.779    32.516     0.150
     2.233    38.824     0.150
     2.311    39.027     0.150
     2.360    40.027     0.150
     2.544    42.926     0.150
     2.552    42.926     0.150
     2.770    46.465     0.150
     2.973    48.926     0.150
     3.210    53.227     0.150
     3.547    56.227     0.150
     3.804    61.027     0.150
     3.900    61.824     0.150
     3.900    61.598     0.150
     3.968    62.926     0.150
     4.087    63.957     0.150
     4.094    63.426     0.150
     4.408    69.125     0.150
     4.431    67.727     0.150
     4.472    70.555     0.150
     4.472    82.629     0.150
     4.472   145.102     0.150
     4.630    71.125     0.150
     4.733    73.246     0.150
     5.118    78.047     0.150
     5.573    85.098     0.150
     5.673    85.824     0.150
     6.038    90.824     0.150
     6.137    92.234     0.150
     6.126    92.227     0.150
     6.371    91.387     0.150
     6.505    97.195     0.150
     6.602    99.125     0.150
     7.105   106.266     0.150
     7.241   108.906     0.150
     7.795   115.387     0.150
     8.788   129.367     0.150
     8.896   130.277     0.150
     9.788   143.207     0.150
    10.775   153.625     0.150
    10.775   269.770     0.150
    12.658   178.656     0.150
    12.658   318.520     0.150
    12.658   179.512     0.150
    12.658   319.641     0.150
    12.658   179.996     0.150
    12.658   179.637     0.150
    14.661   205.324     0.150
    14.661   361.422     0.150
    16.023   222.691     0.150
    16.023   392.340     0.150
    16.023   221.070     0.150
    16.023   395.121     0.150
    18.093   253.324     0.150
    19.333   265.176     0.150
    19.337   266.605     0.150
    19.402   266.730     0.150
    19.402   266.836     0.150
    19.578   268.102     0.150
    19.578   268.199     0.150
    20.034   274.277     0.150
    20.141   273.324     0.150
    20.141   275.797     0.150
    21.868   294.270     0.150
    21.868   293.977     0.150
    23.026   307.453     0.150
    25.125   325.449     0.150
    28.582   356.277     0.150
    35.154   414.957     0.150
    35.467   417.832     0.150
    36.419   424.676     0.150
    36.613   425.988     0.150
    41.093   463.621     0.150
    51.674   547.395     0.150
    87.590   767.801     0.150
    89.567   777.379     0.150
     1.372    25.367     0.150
     1.372    25.758     0.150
     1.580    28.270     0.150
     1.580    28.430     0.150
     1.752    32.066     0.150
     1.752    32.316     0.150
     1.980    35.129     0.150
     2.212    38.770     0.150
     2.249    38.168     0.150
     2.271    38.867     0.150
     2.468    41.469     0.150
     2.502    42.566     0.150
     2.759    46.578     0.150
     2.935    48.668     0.150
     3.171    51.566     0.150
     3.463    55.270     0.150
     3.463    55.398     0.150
     3.779    60.270     0.150
     3.848    60.566     0.150
     3.848    60.340     0.150
     3.930    62.566     0.150
     3.999    62.566     0.150
     4.006    61.969     0.150
     4.345    67.566     0.150
     4.378    68.867     0.150
     4.448    69.141     0.150
     4.448    82.520     0.150
     4.448   145.168     0.150
     4.516    69.469     0.150
     4.541    69.668     0.150
     4.699    72.977     0.150
     5.090    77.668     0.150
     5.064    77.668     0.150
     5.064    76.258     0.150
     5.529    84.367     0.150
     5.529    84.469     0.150
     5.589    84.367     0.150
     5.643    85.367     0.150
     5.956    90.066     0.150
     6.036    91.066     0.150
     6.077    90.797     0.150
     5.977    88.098     0.150
     6.159    92.367     0.150
     6.159    92.168     0.150
     6.416    96.328     0.150
     6.512    97.367     0.150
     7.015   105.258     0.150
     7.207   108.770     0.150
     7.207   106.418     0.150
     7.214   106.270     0.150
     7.214   106.477     0.150
     8.708   127.957     0.150
     9.003   130.906     0.150
     9.709   141.758     0.150
     9.817   143.398     0.150
    10.089   145.758     0.150
    10.735   152.848     0.150
    10.855   154.328     0.150
    12.745   180.738     0.150
    12.745   324.410     0.150
    12.745   180.117     0.150
    13.563   192.109     0.150
    14.196   201.156     0.150
    16.050   224.543     0.150
    16.050   395.117     0.150
    16.251   227.809     0.150
    17.221   238.867     0.150
    18.004   248.227     0.150
    18.004   249.629     0.150
    19.664   269.418     0.150
    19.664   268.039     0.150
    20.111   275.020     0.150
    20.218   275.020     0.150
    21.900   295.062     0.150
    22.355   297.680     0.150
    22.964   304.270     0.150
    25.203   325.656     0.150
    28.552   355.273     0.150
    35.149   413.934     0.150
    35.556   418.387     0.150
    36.680   427.117     0.150
    40.075   455.906     0.150
    41.173   463.645     0.150
    41.173   464.496     0.150
    41.509   466.395     0.150
    51.619   546.344     0.150
    52.524   554.770     0.150
    71.747   680.844     0.150
    83.187   746.543     0.150
    87.645   767.816     0.150
    89.618   778.020     0.150
     1.369    25.734     0.150
     1.369    25.453     0.150
     1.564    28.031     0.150
     1.755    31.934     0.150
     1.990    35.012     0.150
     2.216    38.531     0.150
     2.254    38.734     0.150
     2.451    41.434     0.150
     2.501    42.332     0.150
     2.764    46.184     0.150
     2.935    48.332     0.150
     3.171    52.133     0.150
     3.446    55.031     0.150
     3.782    60.234     0.150
     3.845    60.934     0.150
     3.845    60.781     0.150
     3.930    62.531     0.150
     3.986    61.574     0.150
     3.993    62.234     0.150
     4.380    68.234     0.150
     4.451    69.957     0.150
     4.451    83.434     0.150
     4.451   147.082     0.150
     4.526    69.633     0.150
     4.700    71.922     0.150
     5.049    76.133     0.150
     5.049    75.871     0.150
     5.073    77.031     0.150
     5.528    84.031     0.150
     5.572    84.434     0.150
     5.627    85.332     0.150
     6.020    90.531     0.150
     6.072    91.254     0.150
     6.142    91.734     0.150
     6.142    92.043     0.150
     6.401    96.004     0.150
     6.496    97.832     0.150
    10.872   155.391     0.150
    10.872   272.258     0.150
    12.762   182.027     0.150
    12.762   322.828     0.150
    14.706   208.539     0.150
    14.706   364.488     0.150
    15.739   218.309     0.150
    16.062   395.309     0.150
    16.062   226.141     0.150
    16.062   397.770     0.150
    19.409   267.008     0.150
    19.681   269.133     0.150
    20.128   274.758     0.150
    21.913   295.777     0.150
    22.959   306.418     0.150
    25.220   325.633     0.150
    35.573   418.895     0.150
    36.687   426.902     0.150
    41.190   465.703     0.150
    51.615   546.633     0.150
    52.539   553.535     0.150
    87.649   767.883     0.150
     1.475    27.418     0.150
     1.475    27.316     0.150
     1.808    33.117     0.150
     2.255    39.316     0.150
     2.432    41.316     0.150
     2.583    43.617     0.150
     2.621    44.117     0.150
     2.784    46.488     0.150
     3.009    49.117     0.150
     3.245    52.719     0.150
     3.615    57.418     0.150
     3.829    61.316     0.150
     3.948    62.520     0.150
     4.003    63.418     0.150
     4.161    64.719     0.150
     4.168    64.418     0.150
     4.437    69.020     0.150
     4.496    69.293     0.150
     4.496    83.094     0.150
     4.496   146.492     0.150
     4.765    73.656     0.150
     5.162    77.816     0.150
     5.253    79.520     0.150
     5.613    85.520     0.150
     5.613    84.629     0.150
     5.741    87.020     0.150
     5.804    87.816     0.150
     6.105    91.816     0.150
     6.190    92.590     0.150
     6.201    92.520     0.150
     6.293    94.219     0.150
     6.293    93.949     0.150
     6.580    99.039     0.150
     6.676    99.816     0.150
     7.268   107.867     0.150
     7.617   112.617     0.150
    10.711   152.719     0.150
    10.711   268.086     0.150
    10.711   271.719     0.150
    12.587   177.637     0.150
    12.587   178.059     0.150
    12.587   316.801     0.150
    12.587   179.219     0.150
    12.587   178.906     0.150
    14.637   204.941     0.150
    14.637   359.953     0.150
    14.637   205.117     0.150
    14.637   360.219     0.150
    16.004   222.668     0.150
    16.004   392.441     0.150
    16.004   225.117     0.150
    17.297   240.844     0.150
    17.297   241.816     0.150
    17.459   243.316     0.150
    17.532   247.520     0.150
    19.285   264.816     0.150
    19.290   266.219     0.150
    19.508   267.691     0.150
    19.972   274.316     0.150
    20.079   276.316     0.150
    21.844   294.160     0.150
    21.844   294.020     0.150
    21.844   311.418     0.150
    21.844   561.520     0.150
    23.079   304.719     0.150
    23.079   308.617     0.150
    23.940   314.719     0.150
    25.063   324.918     0.150
    28.611   357.441     0.150
    28.611   356.719     0.150
    35.161   415.289     0.150
    35.394   417.340     0.150
    36.556   425.867     0.150
    40.104   455.781     0.150
    41.028   463.566     0.150
    41.536   467.691     0.150
    51.722   547.918     0.150
    52.359   551.918     0.150
    52.359   552.918     0.150
    78.317   720.219     0.150
    83.122   747.066     0.150
    87.542   767.543     0.150
    89.522   777.168     0.150
     1.589    28.500     0.150
     1.918    34.398     0.150
     2.482    42.199     0.150
     2.651    44.199     0.150
     3.122    51.598     0.150
     4.061    64.000     0.150
     4.116    65.398     0.150
     4.604    69.750     0.150
     4.604   150.074     0.150
     5.769    87.297     0.150
     5.852    88.098     0.150
     6.265    93.598     0.150
    10.697   152.438     0.150
    10.697   269.652     0.150
    12.551   178.516     0.150
    12.551   177.047     0.150
    12.551   315.539     0.150
    14.701   209.035     0.150
    14.701   361.805     0.150
    14.852   211.066     0.150
    16.074   396.668     0.150
    19.475   267.875     0.150
    19.965   272.098     0.150
    25.054   324.500     0.150
    35.257   415.387     0.150
    36.445   425.000     0.150
    51.836   548.766     0.150
    87.428   767.500     0.150
    89.408   776.797     0.150
     1.438    26.650     0.150
     1.438    46.250     0.150
     1.675    29.250     0.150
     1.675    29.432     0.150
     1.791    32.852     0.150
     1.791    32.730     0.150
     2.244    38.951     0.150
     2.365    40.150     0.150
     2.556    43.150     0.150
     2.556    43.051     0.150
     2.781    46.352     0.150
     2.985    49.451     0.150
     3.222    52.750     0.150
     3.550    56.580     0.150
     3.815    61.051     0.150
     3.913    62.551     0.150
     3.980    63.150     0.150
     4.097    63.871     0.150
     4.104    63.551     0.150
     4.441    69.051     0.150
     4.420    69.352     0.150
     4.483    69.877     0.150
     4.613    71.150     0.150
     5.115    77.420     0.150
     5.186    78.650     0.150
     5.676    86.051     0.150
     5.586    84.852     0.150
     5.737    86.551     0.150
     5.884    87.320     0.150
     6.041    91.051     0.150
     6.134    91.951     0.150
     6.234    93.551     0.150
     6.150    93.061     0.150
     6.376    90.361     0.150
     6.514    97.410     0.150
     6.609    99.250     0.150
     7.129   105.301     0.150
     7.566   111.650     0.150
     8.683   126.451     0.150
     9.255   133.000     0.150
    10.000   143.451     0.150
    10.645   152.311     0.150
    10.773   153.771     0.150
    12.598   177.660     0.150
    12.653   179.221     0.150
    14.667   206.701     0.150
    16.030   222.727     0.150
    18.871   261.160     0.150
    19.335   265.510     0.150
    19.339   265.051     0.150
    19.574   268.150     0.150
    20.033   274.926     0.150
    20.139   274.971     0.150
    21.874   292.602     0.150
    22.271   296.311     0.150
    25.123   325.602     0.150
    25.123   325.281     0.150
    35.164   415.244     0.150
    35.461   417.582     0.150
    35.461   416.602     0.150
    36.601   426.881     0.150
    36.601   425.490     0.150
    41.090   463.951     0.150
    51.687   546.424     0.150
    52.425   553.584     0.150
    75.142   702.521     0.150
    75.982   707.570     0.150
    87.578   768.057     0.150
    87.578   767.490     0.150
     1.571    28.695     0.150
     1.571    50.496     0.150
     1.766    30.996     0.150
     1.766    31.184     0.150
     1.908    34.496     0.150
     2.355    40.695     0.150
     2.454    41.594     0.150
     2.458    41.496     0.150
     2.624    43.996     0.150
     2.682    44.996     0.150
     2.883    48.375     0.150
     3.109    50.895     0.150
     3.346    54.293     0.150
     3.617    57.996     0.150
     3.617    57.695     0.150
     3.929    62.695     0.150
     4.045    63.793     0.150
     4.104    65.195     0.150
     4.219    65.746     0.150
     4.226    64.793     0.150
     4.538    70.895     0.150
     4.596    71.770     0.150
     4.596   147.445     0.150
     4.755    72.793     0.150
     5.112    78.594     0.150
     5.112    77.844     0.150
     5.279    79.594     0.150
     5.743    86.895     0.150
     5.713    86.395     0.150
     5.713    87.125     0.150
     5.824    87.695     0.150
     5.752    85.484     0.150
     5.752    88.414     0.150
     6.101    92.293     0.150
     6.236    93.996     0.150
     6.272    94.594     0.150
     6.272    94.215     0.150
     6.284    93.723     0.150
     6.447    92.285     0.150
     6.631    99.055     0.150
     7.197   108.496     0.150
     7.197   108.266     0.150
     7.225   107.516     0.150
     7.073   105.203     0.150
     8.796   128.195     0.150
     8.933   130.293     0.150
     9.165   133.496     0.150
     9.933   145.184     0.150
     9.931   144.066     0.150
    14.711   209.246     0.150
    14.711   208.746     0.150
    15.756   221.414     0.150
    19.335   266.805     0.150
    22.135   295.734     0.150
    22.590   298.773     0.150
    22.590   322.074     0.150
    22.590   532.074     0.150
    22.590   547.684     0.150
    23.173   306.746     0.150
    25.079   325.465     0.150
    35.816   420.305     0.150
    36.465   425.996     0.150
    36.465   424.996     0.150
    41.602   468.055     0.150
    41.634   468.469     0.150
    51.819   547.418     0.150
    51.819   547.695     0.150
    52.317   552.543     0.150
    53.375   560.086     0.150
    60.103   608.164     0.150
    60.657   611.906     0.150
    60.823   613.133     0.150
    72.134   685.316     0.150
    72.258   686.184     0.150
    73.996   695.406     0.150
    75.980   707.414     0.150
    76.051   707.805     0.150
    77.220   714.055     0.150
    77.299   714.176     0.150
    77.470   715.586     0.150
    78.133   719.723     0.150
    78.202   719.883     0.150
    78.201   720.105     0.150
    78.580   721.285     0.150
    87.445   767.371     0.150
    87.445   767.215     0.150
    87.448   767.305     0.150
    89.424   777.344     0.150
    89.424   776.055     0.150
     1.462    26.711     0.150
     1.462    47.910     0.150
     1.462    26.578     0.150
     1.687    30.008     0.150
     1.687    29.711     0.150
     1.813    32.910     0.150
     2.265    39.211     0.150
     2.563    43.008     0.150
     2.579    43.508     0.150
     2.801    46.758     0.150
     3.008    49.309     0.150
     3.245    52.609     0.150
     3.558    56.711     0.150
     3.837    61.410     0.150
     3.936    62.109     0.150
     4.003    63.309     0.150
     4.116    64.289     0.150
     4.505    69.910     0.150
     4.505   147.086     0.150
     4.657    71.609     0.150
     5.110    77.711     0.150
     5.110    77.289     0.150
     5.684    86.008     0.150
     6.173    92.168     0.150
     6.236    93.039     0.150
     6.532    98.188     0.150
     7.225   107.098     0.150
    10.865   156.148     0.150
    11.640   168.000     0.150
    16.043   225.609     0.150
    19.338   266.211     0.150
    19.565   268.383     0.150
    20.029   274.059     0.150
    23.062   307.059     0.150
    36.578   427.160     0.150
    41.085   465.258     0.150
    52.409   552.410     0.150
    87.554   767.559     0.150
    89.531   776.910     0.150
     1.380    26.012     0.150
     1.380    44.512     0.150
     1.380    26.230     0.150
     1.744    32.012     0.150
     1.744    32.309     0.150
     1.630    28.910     0.150
     1.630    29.039     0.150
     2.200    38.609     0.150
     2.264    38.512     0.150
     2.321    39.309     0.150
     2.503    42.410     0.150
     2.741    46.352     0.150
     2.520    42.309     0.150
     2.933    48.309     0.150
     3.170    52.012     0.150
     3.514    55.910     0.150
     3.514    56.172     0.150
     3.769    60.109     0.150
     3.856    60.910     0.150
     3.856    61.270     0.150
     3.928    62.609     0.150
     4.039    63.148     0.150
     4.046    63.211     0.150
     4.372    68.309     0.150
     4.438   142.984     0.150
     4.382    68.109     0.150
     4.554    70.309     0.150
     5.138    78.109     0.150
     5.110    77.012     0.150
     5.532    83.910     0.150
     5.640    85.309     0.150
     5.693    86.211     0.150
     5.945    88.371     0.150
     5.945    98.180     0.150
     6.091    90.988     0.150
     6.008    90.109     0.150
     6.083    91.809     0.150
     6.210    92.609     0.150
     6.210    92.840     0.150
     6.337    90.551     0.150
     6.458    96.922     0.150
     6.560    98.410     0.150
     7.163   105.930     0.150
     7.059   104.449     0.150
     7.246   107.031     0.150
     8.738   128.262     0.150
     8.847   130.430     0.150
     9.303   133.871     0.150
     9.738   142.930     0.150
    10.038   143.148     0.150
    10.684   152.441     0.150
    10.804   154.215     0.150
    10.804   271.645     0.150
    10.804   153.762     0.150
    11.867   172.012     0.150
    11.867   301.711     0.150
    12.694   179.430     0.150
    12.694   317.879     0.150
    12.694   179.582     0.150
    12.694   180.051     0.150
    12.694   321.574     0.150
    12.694   180.461     0.150
    13.183   187.289     0.150
    14.147   199.520     0.150
    14.656   205.770     0.150
    14.656   204.699     0.150
    14.656   205.738     0.150
    14.767   207.148     0.150
    14.812   210.031     0.150
    15.674   221.332     0.150
    16.015   222.484     0.150
    16.015   390.684     0.150
    16.015   222.180     0.150
    16.015   392.430     0.150
    15.998   223.520     0.150
    17.221   243.359     0.150
    17.247   243.789     0.150
    19.197   267.121     0.150
    19.345   265.359     0.150
    19.349   264.238     0.150
    19.349   265.469     0.150
    19.436   266.230     0.150
    19.436   265.648     0.150
    19.436   267.480     0.150
    19.613   269.035     0.150
    19.613   268.109     0.150
    20.060   274.910     0.150
    20.167   276.230     0.150
    20.167   273.301     0.150
    20.167   276.410     0.150
    20.744   282.230     0.150
    21.467   288.352     0.150
    21.863   293.930     0.150
    21.863   292.461     0.150
    21.863   293.641     0.150
    22.269   298.059     0.150
    22.332   299.148     0.150
    22.979   305.781     0.150
    22.979   305.211     0.150
    22.979   305.551     0.150
    25.151   325.910     0.150
    25.151   324.781     0.150
    25.252   328.629     0.150
    25.252   326.801     0.150
    28.546   356.336     0.150
    28.546   355.719     0.150
    28.553   357.219     0.150
    28.553   356.469     0.150
    29.295   366.441     0.150
    30.193   371.262     0.150
    30.191   372.852     0.150
    33.731   404.570     0.150
    35.129   414.582     0.150
    36.467   425.719     0.150
    36.471   425.762     0.150
    36.554   426.480     0.150
    36.662   426.961     0.150
    37.915   438.410     0.150
    38.624   444.910     0.150
    39.986   456.289     0.150
    41.122   464.137     0.150
    41.122   463.961     0.150
    41.462   467.211     0.150
    41.493   467.809     0.150
    41.493   467.137     0.150
    42.465   475.441     0.150
    46.647   509.441     0.150
    51.628   547.262     0.150
    51.629   547.309     0.150
    51.629   546.930     0.150
    52.074   550.852     0.150
    52.479   553.309     0.150
    52.479   553.859     0.150
    57.213   590.809     0.150
    78.107   720.750     0.150
    78.370   720.410     0.150
    78.370   720.141     0.150
    87.635   768.184     0.150
    87.635   768.730     0.150
    89.611   777.711     0.150
    89.611   778.398     0.150
     1.615    28.973     0.150
     1.615    51.570     0.150
     1.615    28.703     0.150
     1.615    51.910     0.150
     1.799    32.871     0.150
     2.256    39.273     0.150
     2.305    39.273     0.150
     2.494    41.973     0.150
     2.553    43.070     0.150
     2.985    49.070     0.150
     3.488    55.570     0.150
     3.825    61.172     0.150
     3.901    61.672     0.150
     3.980    63.773     0.150
     4.049    62.352     0.150
     4.055    63.070     0.150
     4.426    69.172     0.150
     4.494    70.621     0.150
     4.494    83.375     0.150
     4.494   122.070     0.150
     4.494   145.422     0.150
     4.566    70.371     0.150
     4.587    70.473     0.150
     5.060    76.070     0.150
     5.060    75.863     0.150
     5.126    77.773     0.150
     5.581    85.172     0.150
     5.581    84.000     0.150
     5.614    84.973     0.150
     5.677    86.070     0.150
     5.924    84.941     0.150
     5.979    90.172     0.150
     6.077    91.672     0.150
     6.132    91.973     0.150
     6.173    92.473     0.150
     6.173    91.922     0.150
     6.463    96.582     0.150
     6.550    98.371     0.150
     7.060   104.371     0.150
     7.757   113.832     0.150
     8.762   127.891     0.150
     8.880   130.363     0.150
     9.080   133.160     0.150
     9.763   142.660     0.150
    12.715   180.215     0.150
    12.715   319.117     0.150
    12.715   179.383     0.150
    16.072   223.871     0.150
    16.072   397.422     0.150
    19.392   266.598     0.150
    19.635   269.449     0.150
    20.094   274.598     0.150
    21.919   294.590     0.150
    23.019   306.113     0.150
    25.185   326.023     0.150
    35.187   414.461     0.150
    36.625   427.211     0.150
    40.117   456.496     0.150
    40.289   457.660     0.150
    41.153   464.020     0.150
    41.551   467.688     0.150
    51.673   547.398     0.150
    87.591   768.914     0.150
    89.565   777.871     0.150
     1.406    26.113     0.150
     1.632    28.914     0.150
     1.771    32.312     0.150
     1.771    32.035     0.150
     2.227    38.914     0.150
     2.323    39.812     0.150
     2.529    42.812     0.150
     2.516    42.312     0.150
     2.768    46.445     0.150
     2.960    48.613     0.150
     3.196    51.914     0.150
     3.511    55.812     0.150
     3.511    55.914     0.150
     3.796    60.812     0.150
     3.881    61.215     0.150
     3.881    61.035     0.150
     3.955    62.613     0.150
     4.052    63.723     0.150
     4.059    62.914     0.150
     4.399    68.715     0.150
     4.397    68.215     0.150
     4.465    69.914     0.150
     4.465   144.340     0.150
     4.568    69.516     0.150
     4.594    70.414     0.150
     5.093    76.715     0.150
     5.093    77.375     0.150
     5.142    78.312     0.150
     5.558    83.812     0.150
     5.558    84.145     0.150
     5.637    85.312     0.150
     5.695    86.215     0.150
     5.927    86.383     0.150
     5.927    97.895     0.150
     5.855    87.516     0.150
     6.003    90.113     0.150
     6.115    91.945     0.150
     6.089    91.715     0.150
     6.201    92.914     0.150
     6.201    92.324     0.150
     6.335    90.445     0.150
     6.469    96.734     0.150
     6.565    98.414     0.150
     6.802   101.812     0.150
     7.168   104.613     0.150
     7.168   182.992     0.150
     7.168   106.074     0.150
     7.224   105.426     0.150
     7.526   111.113     0.150
     7.759   115.684     0.150
     7.962   114.223     0.150
     7.962   204.426     0.150
     8.108   118.215     0.150
     8.706   127.812     0.150
     8.757   128.766     0.150
     8.868   130.492     0.150
     9.299   133.293     0.150
     9.299   236.895     0.150
     9.495   136.715     0.150
     9.495   140.195     0.150
     9.757   142.465     0.150
    10.040   143.363     0.150
     9.869   144.086     0.150
    10.686   151.703     0.150
    10.810   154.258     0.150
    10.810   269.820     0.150
    10.810   154.113     0.150
    11.023   155.562     0.150
    11.112   157.785     0.150
    11.953   166.254     0.150
    12.159   171.734     0.150
    12.695   179.609     0.150
    12.695   318.934     0.150
    12.695   179.004     0.150
    12.695   179.918     0.150
    12.695   319.691     0.150
    12.695   180.414     0.150
    12.695   179.324     0.150
    12.695   180.242     0.150
    13.198   191.113     0.150
    13.297   191.516     0.150
    13.512   190.516     0.150
    13.689   198.113     0.150
    13.853   200.414     0.150
    14.144   198.113     0.150
    14.678   205.113     0.150
    14.678   206.125     0.150
    14.678   363.066     0.150
    14.671   209.609     0.150
    14.671   216.613     0.150
    14.838   208.844     0.150
    14.962   214.766     0.150
    15.317   215.836     0.150
    15.561   218.934     0.150
    15.700   224.824     0.150
    15.799   220.473     0.150
    16.037   223.812     0.150
    16.037   391.914     0.150
    16.037   221.848     0.150
    16.037   393.617     0.150
    16.199   228.184     0.150
    16.535   238.215     0.150
    16.689   234.312     0.150
    17.184   241.914     0.150
    17.247   240.215     0.150
    17.247   244.516     0.150
    17.247   244.113     0.150
    17.269   241.414     0.150
    17.305   242.285     0.150
    17.409   246.812     0.150
    17.483   243.273     0.150
    17.483   246.613     0.150
    17.483   440.715     0.150
    17.502   244.312     0.150
    18.162   250.535     0.150
    18.056   250.113     0.150
    18.832   260.555     0.150
    19.050   263.715     0.150
    19.169   264.414     0.150
    19.197   266.312     0.150
    19.360   266.039     0.150
    19.360   473.641     0.150
    19.364   265.453     0.150
    19.364   265.773     0.150
    19.438   266.086     0.150
    19.438   266.586     0.150
    19.324   266.785     0.150
    19.614   268.516     0.150
    19.614   268.914     0.150
    19.614   269.266     0.150
    19.614   268.652     0.150
    19.683   270.312     0.150
    19.667   271.016     0.150
    20.068   274.988     0.150
    20.174   276.234     0.150
    20.174   274.855     0.150
    20.174   275.715     0.150
    20.113   276.086     0.150
    20.362   278.434     0.150
    20.531   278.715     0.150
    20.768   283.203     0.150
    20.804   283.883     0.150
    20.804   283.645     0.150
    20.893   284.105     0.150
    21.137   284.445     0.150
    21.320   287.113     0.150
    21.238   288.023     0.150
    21.282   288.516     0.150
    21.468   288.613     0.150
    21.571   291.215     0.150
    21.924   295.613     0.150
    21.949   295.016     0.150
    21.884   294.582     0.150
    21.884   532.809     0.150
    21.884   293.613     0.150
    21.884   294.215     0.150
    21.884   312.613     0.150
    21.884   533.715     0.150
    21.949   295.145     0.150
    22.020   296.113     0.150
    22.210   297.812     0.150
    22.210   542.812     0.150
    22.311   298.195     0.150
    22.311   298.086     0.150
    22.286   299.902     0.150
    22.555   301.516     0.150
    22.726   301.016     0.150
    22.726   324.664     0.150
    22.726   533.336     0.150
    22.726   550.594     0.150
    23.000   306.414     0.150
    23.003   306.164     0.150
    23.003   306.414     0.150
    23.003   306.613     0.150
    23.003   305.914     0.150
    23.003   306.375     0.150
    23.003   307.414     0.150
    23.106   306.312     0.150
    23.281   306.715     0.150
    23.319   307.812     0.150
    23.572   311.414     0.150
    23.532   312.973     0.150
    23.570   312.414     0.150
    23.662   313.805     0.150
    24.045   316.613     0.150
    24.282   318.715     0.150
    24.920   325.473     0.150
    25.159   326.215     0.150
    25.159   325.863     0.150
    25.159   325.715     0.150
    25.233   327.023     0.150
    25.233   327.242     0.150
    25.351   327.215     0.150
    25.461   329.344     0.150
    26.267   336.043     0.150
    26.949   341.812     0.150
    26.949   385.516     0.150
    27.745   350.273     0.150
    28.530   356.312     0.150
    28.555   357.215     0.150
    28.573   356.914     0.150
    28.573   356.812     0.150
    28.573   357.312     0.150
    28.580   357.125     0.150
    28.580   356.684     0.150
    28.584   356.914     0.150
    28.844   360.336     0.150
    29.188   362.414     0.150
    29.240   363.613     0.150
    29.240   363.285     0.150
    29.321   366.125     0.150
    30.352   374.113     0.150
    30.220   371.992     0.150
    30.220   372.516     0.150
    30.217   372.883     0.150
    30.477   375.812     0.150
    30.888   377.766     0.150
    30.888   438.684     0.150
    30.888   781.812     0.150
    31.613   383.992     0.150
    32.280   388.984     0.150
    32.354   391.234     0.150
    32.354   391.055     0.150
    32.395   392.633     0.150
    33.061   396.914     0.150
    32.956   397.312     0.150
    33.151   398.516     0.150
    33.332   399.523     0.150
    33.332   399.254     0.150
    33.409   399.535     0.150
    33.701   401.375     0.150
    33.758   405.062     0.150
    33.792   404.605     0.150
    33.987   404.848     0.150
    33.936   404.223     0.150
    33.936   403.914     0.150
    34.250   409.016     0.150
    34.841   412.504     0.150
    35.155   414.645     0.150
    35.155   415.414     0.150
    35.300   417.074     0.150
    35.504   417.953     0.150
    35.504   417.684     0.150
    35.517   416.414     0.150
    35.436   419.273     0.150
    35.948   422.113     0.150
    35.948   422.703     0.150
    35.994   421.484     0.150
    36.444   425.234     0.150
    36.444   425.086     0.150
    36.448   425.223     0.150
    36.485   425.973     0.150
    36.639   426.414     0.150
    36.639   426.465     0.150
    36.639   570.164     0.150
    36.639   426.734     0.150
    36.639   569.863     0.150
    36.639   427.016     0.150
    36.653   426.215     0.150
    36.671   426.414     0.150
    36.677   428.484     0.150
    37.941   438.855     0.150
    37.991   439.266     0.150
    37.991   573.594     0.150
    38.841   447.215     0.150
    39.162   447.383     0.150
    39.000   448.543     0.150
    40.136   456.484     0.150
    40.087   456.340     0.150
    40.254   458.113     0.150
    40.254   457.465     0.150
    40.965   464.145     0.150
    41.127   464.391     0.150
    41.151   465.543     0.150
    41.520   467.516     0.150
    41.520   467.289     0.150
    41.870   471.055     0.150
    42.504   476.113     0.150
    42.504   476.215     0.150
    43.046   481.176     0.150
    46.672   509.773     0.150
    47.058   511.375     0.150
    47.716   516.754     0.150
    48.217   521.492     0.150
    48.448   523.238     0.150
    49.783   533.312     0.150
    50.309   536.293     0.150
    51.653   547.266     0.150
    51.654   547.039     0.150
    52.471   552.594     0.150
    52.471   552.723     0.150
    52.471   553.664     0.150
    53.514   560.715     0.150
    53.514   560.375     0.150
    54.480   568.543     0.150
    59.899   607.113     0.150
    60.024   607.391     0.150
    60.963   613.086     0.150
    66.373   647.984     0.150
    66.373   648.367     0.150
    66.373   648.184     0.150
    68.572   663.215     0.150
    71.792   682.062     0.150
    71.792   682.613     0.150
    73.673   694.965     0.150
    73.723   695.105     0.150
    74.024   696.574     0.150
    74.287   698.684     0.150
    74.369   699.176     0.150
    74.415   699.094     0.150
    75.167   702.992     0.150
    75.511   705.883     0.150
    75.577   705.695     0.150
    76.006   708.043     0.150
    77.014   713.734     0.150
    77.499   717.016     0.150
    77.832   718.484     0.150
    78.231   720.984     0.150
    78.386   721.426     0.150
    78.386   721.074     0.150
    78.729   723.312     0.150
    79.680   728.414     0.150
    79.918   730.266     0.150
    80.107   730.652     0.150
    81.001   735.414     0.150
    82.128   741.105     0.150
    83.168   746.039     0.150
    83.168   746.574     0.150
    83.168   747.016     0.150
    83.486   748.773     0.150
    87.610   767.789     0.150
    87.613   768.215     0.150
    89.585   777.766     0.150
     1.441    26.664     0.150
     1.441    47.367     0.150
     1.636    28.867     0.150
     1.809    32.664     0.150
     2.325    39.566     0.150
     2.265    39.367     0.150
     2.322    39.367     0.150
     2.512    42.566     0.150
     2.567    43.164     0.150
     3.234    53.164     0.150
     3.506    55.664     0.150
     3.835    61.465     0.150
     3.917    61.965     0.150
     3.993    63.566     0.150
     4.077    62.664     0.150
     4.418    68.465     0.150
     4.437    69.465     0.150
     4.504    69.871     0.150
     4.504   142.117     0.150
     4.608    70.664     0.150
     5.147    78.164     0.150
     5.632    85.266     0.150
     5.595    85.266     0.150
     5.697    86.465     0.150
     6.098    91.566     0.150
     6.188    92.266     0.150
     6.571    98.367     0.150
    12.696   181.258     0.150
    12.696   320.281     0.150
    19.381   268.984     0.150
    20.079   276.172     0.150
    36.606   425.867     0.150
    41.136   465.906     0.150
    51.690   546.367     0.150
    52.459   552.977     0.150
    87.575   767.445     0.150
    89.549   777.484     0.150
     1.484    27.133     0.150
     1.484    47.734     0.150
     1.484    27.314     0.150
     1.705    29.934     0.150
     1.705    30.094     0.150
     1.831    32.834     0.150
     1.831    33.123     0.150
     2.282    39.334     0.150
     2.395    40.533     0.150
     2.370    40.434     0.150
     2.578    43.334     0.150
     2.599    43.533     0.150
     2.816    47.104     0.150
     3.028    49.633     0.150
     3.264    53.633     0.150
     3.572    56.533     0.150
     3.854    61.834     0.150
     3.958    62.334     0.150
     3.958    62.504     0.150
     4.022    63.533     0.150
     4.138    64.973     0.150
     4.145    64.834     0.150
     4.485    69.133     0.150
     4.522    70.584     0.150
     4.522   148.383     0.150
     4.678    71.934     0.150
     4.786    74.484     0.150
     5.113    77.303     0.150
     5.698    85.934     0.150
     5.629    85.453     0.150
     6.168    93.033     0.150
     6.246    93.334     0.150
     6.196    92.834     0.150
     6.399    90.633     0.150
     6.641    99.633     0.150
    25.109   325.883     0.150
    36.555   425.883     0.150
    41.568   468.434     0.150
    51.732   548.109     0.150
    87.532   767.934     0.150
     1.529    27.734     0.150
     1.529    49.336     0.150
     1.747    30.734     0.150
     1.747    30.555     0.150
     1.867    33.734     0.150
     1.867    33.516     0.150
     2.315    39.938     0.150
     2.435    41.234     0.150
     2.613    43.938     0.150
     2.640    44.234     0.150
     2.845    47.242     0.150
     3.068    50.938     0.150
     3.304    53.938     0.150
     3.606    57.234     0.150
     3.606    57.367     0.150
     3.889    62.133     0.150
     4.003    63.336     0.150
     4.003    62.703     0.150
     4.062    64.438     0.150
     4.187    64.516     0.150
     4.194    65.438     0.150
     4.497    70.438     0.150
     4.556    71.758     0.150
     4.556   147.305     0.150
     4.726    72.438     0.150
     4.824    74.633     0.150
     5.124    77.445     0.150
     5.259    79.734     0.150
     5.671    86.336     0.150
     5.671    86.047     0.150
     5.732    86.734     0.150
     5.789    84.734     0.150
     5.789    88.078     0.150
     5.806    88.031     0.150
     6.093    91.531     0.150
     6.213    93.734     0.150
     6.242    93.422     0.150
     6.435    91.258     0.150
     6.602    99.008     0.150
     6.684   100.531     0.150
     7.079   102.758     0.150
     7.079   104.625     0.150
     7.219   107.633     0.150
     7.219   107.492     0.150
     7.875   113.688     0.150
     9.183   133.586     0.150
     9.942   142.805     0.150
    10.586   150.977     0.150
    10.726   152.523     0.150
    10.916   154.734     0.150
    12.526   176.742     0.150
    12.591   177.977     0.150
    12.591   317.430     0.150
    12.591   178.242     0.150
    12.591   178.477     0.150
    13.404   187.281     0.150
    14.687   204.836     0.150
    14.687   205.266     0.150
    14.794   209.750     0.150
    14.794   210.562     0.150
    14.948   211.156     0.150
    15.431   217.766     0.150
    15.691   221.328     0.150
    16.057   222.234     0.150
    16.057   394.086     0.150
    16.088   223.594     0.150
    17.356   241.031     0.150
    18.173   253.992     0.150
    19.320   264.438     0.150
    19.338   264.883     0.150
    19.514   266.945     0.150
    19.514   267.562     0.150
    19.992   273.211     0.150
    20.099   275.766     0.150
    20.099   278.992     0.150
    21.366   288.977     0.150
    21.894   294.211     0.150
    21.894   294.422     0.150
    22.175   295.656     0.150
    23.131   307.828     0.150
    23.131   307.453     0.150
    25.081   324.281     0.150
    28.670   357.625     0.150
    35.220   414.844     0.150
    35.390   416.445     0.150
    35.390   415.656     0.150
    36.507   426.031     0.150
    36.507   425.375     0.150
    40.297   459.469     0.150
    41.043   463.750     0.150
    41.043   464.031     0.150
    41.596   469.031     0.150
    41.596   468.906     0.150
    51.777   548.461     0.150
    78.354   720.891     0.150
    87.487   768.125     0.150
    87.487   767.047     0.150
    87.487   768.273     0.150
    89.466   777.281     0.150
    89.466   776.977     0.150
     1.558    27.950     0.150
     1.765    30.650     0.150
     1.765    31.220     0.150
     1.893    33.350     0.150
     1.893    33.910     0.150
     2.340    40.050     0.150
     2.453    41.150     0.150
     2.626    43.350     0.150
     2.668    44.250     0.150
     2.868    47.350     0.150
     3.095    50.050     0.150
     3.331    53.350     0.150
     3.619    57.450     0.150
     4.031    62.850     0.150
     4.031    63.000     0.150
     4.089    64.150     0.150
     4.213    64.920     0.150
     4.220    65.150     0.150
     4.523    69.650     0.150
     4.561    70.250     0.150
     4.581    71.200     0.150
     4.581   124.650     0.150
     4.581   149.000     0.150
     4.730    72.150     0.150
     4.750    72.650     0.150
     4.851    74.430     0.150
     5.122    77.250     0.150
     5.278    80.050     0.150
     5.761    88.150     0.150
     5.761    88.795     0.150
     5.761    87.890     0.150
     5.761    86.950     0.150
     5.761    88.620     0.150
     5.761    87.100     0.150
     5.699    85.750     0.150
     5.699    86.810     0.150
     5.745    86.650     0.150
     5.838    89.994     0.150
     5.838    90.290     0.150
     5.838    91.165     0.150
     5.824    87.750     0.150
     6.005    89.950     0.150
     6.104    91.650     0.150
     6.234    93.050     0.150
     6.278    93.550     0.150
     6.278    93.820     0.150
     6.271    93.820     0.150
     6.449    91.340     0.150
     6.626    98.920     0.150
     6.703   100.050     0.150
     6.733   100.650     0.150
     6.962   103.450     0.150
     7.069   104.305     0.150
     7.069   185.647     0.150
     7.069   103.840     0.150
     7.018   104.050     0.150
     7.210   106.850     0.150
     7.210   107.570     0.150
     7.221   106.750     0.150
     7.221   106.990     0.150
     7.319   109.050     0.150
     7.506   111.050     0.150
     7.691   113.050     0.150
     7.696   113.250     0.150
     7.865   114.650     0.150
     8.096   119.050     0.150
     8.272   121.450     0.150
     8.285   122.050     0.150
     8.583   125.350     0.150
     8.650   126.650     0.150
     8.800   130.050     0.150
     8.800   128.260     0.150
     8.804   128.250     0.150
     8.808   128.550     0.150
     8.807   129.050     0.150
     8.923   130.370     0.150
     9.033   132.290     0.150
     9.107   132.050     0.150
     9.107   132.990     0.150
     9.109   132.750     0.150
     9.165   132.570     0.150
     9.233   136.050     0.150
     9.329   136.850     0.150
     9.329   137.445     0.150
     9.580   140.450     0.150
     9.686   139.880     0.150
     9.700   141.950     0.150
     9.766   142.140     0.150
     9.818   144.550     0.150
     9.929   141.440     0.150
     9.961   145.107     0.150
     9.961   146.403     0.150
     9.923   143.910     0.150
    10.002   145.954     0.150
    10.002   146.808     0.150
    10.002   255.637     0.150
     9.998   145.730     0.150
    10.134   148.450     0.150
    10.134   148.610     0.150
    10.227   147.650     0.150
    10.294   148.365     0.150
    10.272   148.910     0.150
    10.345   144.390     0.150
    10.586   152.980     0.150
    10.547   154.460     0.150
    10.535   153.580     0.150
    10.573   150.060     0.150
    10.553   150.536     0.150
    10.553   152.508     0.150
    10.553   269.598     0.150
    10.557   153.015     0.150
    10.628   155.483     0.150
    10.717   152.736     0.150
    10.717   270.550     0.150
    10.717   270.250     0.150
    10.717   152.220     0.150
    10.869   156.710     0.150
    10.803   155.190     0.150
    10.900   153.780     0.150
    10.857   158.150     0.150
    10.857   158.710     0.150
    10.906   157.450     0.150
    10.906   155.216     0.150
    10.906   157.960     0.150
    10.906   157.230     0.150
    10.906   157.007     0.150
    10.906   279.572     0.150
    10.906   155.970     0.150
    10.891   158.950     0.150
    10.967   156.990     0.150
    11.008   158.820     0.150
    11.053   160.910     0.150
    11.042   157.262     0.150
    11.042   160.577     0.150
    11.017   160.140     0.150
    11.133   161.480     0.150
    11.095   160.683     0.150
    11.095   162.718     0.150
    11.072   159.090     0.150
    11.108   157.776     0.150
    11.108   157.640     0.150
    11.198   162.073     0.150
    11.198   162.758     0.150
    11.338   163.828     0.150
    11.338   165.718     0.150
    11.323   160.020     0.150
    11.415   165.250     0.150
    11.415   292.850     0.150
    11.512   163.918     0.150
    11.512   165.008     0.150
    11.557   168.272     0.150
    11.557   168.718     0.150
    11.571   166.337     0.150
    11.589   165.636     0.150
    11.631   165.480     0.150
    11.606   167.050     0.150
    11.714   166.850     0.150
    11.714   296.650     0.150
    11.762   168.656     0.150
    11.765   169.835     0.150
    11.765   170.523     0.150
    11.883   171.037     0.150
    11.883   171.520     0.150
    11.877   170.750     0.150
    12.036   169.210     0.150
    12.051   174.362     0.150
    12.055   172.850     0.150
    12.165   171.580     0.150
    12.249   176.996     0.150
    12.278   173.925     0.150
    12.306   176.250     0.150
    12.467   178.260     0.150
    12.467   321.320     0.150
    12.498   177.110     0.150
    12.498   319.630     0.150
    12.530   180.930     0.150
    12.577   176.850     0.150
    12.577   176.681     0.150
    12.577   177.560     0.150
    12.577   177.369     0.150
    12.577   318.969     0.150
    12.577   177.056     0.150
    12.577   179.235     0.150
    12.577   318.109     0.150
    12.577   178.066     0.150
    12.577   177.900     0.150
    12.617   178.200     0.150
    12.584   180.604     0.150
    12.649   177.826     0.150
    12.694   180.730     0.150
    12.634   180.550     0.150
    12.698   181.728     0.150
    12.890   182.560     0.150
    12.862   181.010     0.150
    12.941   182.350     0.150
    12.954   182.830     0.150
    12.993   185.950     0.150
    12.967   184.935     0.150
    12.970   186.504     0.150
    13.042   183.190     0.150
    13.302   188.575     0.150
    13.302   188.817     0.150
    13.321   192.145     0.150
    13.388   187.150     0.150
    13.388   188.430     0.150
    13.358   191.015     0.150
    13.358   191.702     0.150
    13.358   191.457     0.150
    13.406   188.270     0.150
    13.342   191.650     0.150
    13.342   340.650     0.150
    13.391   191.317     0.150
    13.457   188.990     0.150
    13.438   191.950     0.150
    13.438   343.450     0.150
    13.465   194.410     0.150
    13.586   194.095     0.150
    13.632   193.381     0.150
    13.654   196.910     0.150
    13.756   196.024     0.150
    13.803   195.528     0.150
    13.803   195.391     0.150
    13.911   196.110     0.150
    13.873   196.040     0.150
    13.863   195.902     0.150
    13.860   197.718     0.150
    13.835   198.350     0.150
    13.835   354.550     0.150
    14.013   197.360     0.150
    14.040   198.470     0.150
    14.014   196.750     0.150
    14.014   197.050     0.150
    14.063   201.465     0.150
    14.007   200.550     0.150
    14.007   355.850     0.150
    14.058   197.450     0.150
    14.058   352.350     0.150
    14.202   201.190     0.150
    14.237   200.680     0.150
    14.257   199.080     0.150
    14.312   201.850     0.150
    14.306   200.490     0.150
    14.337   205.250     0.150
    14.411   202.109     0.150
    14.411   363.308     0.150
    14.434   202.470     0.150
    14.434   363.210     0.150
    14.639   205.450     0.150
    14.662   210.550     0.150
    14.698   204.280     0.150
    14.698   206.696     0.150
    14.698   365.422     0.150
    14.698   362.150     0.150
    14.698   204.750     0.150
    14.822   213.150     0.150
    14.822   213.259     0.150
    14.822   209.544     0.150
    14.822   212.174     0.150
    14.822   218.720     0.150
    14.822   212.860     0.150
    14.981   209.450     0.150
    14.981   210.750     0.150
    15.036   209.840     0.150
    14.976   212.310     0.150
    15.049   217.051     0.150
    15.182   217.842     0.150
    15.123   217.290     0.150
    15.272   216.120     0.150
    15.247   212.830     0.150
    15.247   382.420     0.150
    15.297   402.440     0.150
    15.459   218.590     0.150
    15.620   217.890     0.150
    15.620   392.320     0.150
    15.688   218.670     0.150
    15.688   393.550     0.150
    15.781   222.930     0.150
    15.720   224.010     0.150
    15.754   221.960     0.150
    15.744   223.170     0.150
    15.876   222.401     0.150
    15.876   221.860     0.150
    15.901   226.640     0.150
    16.260   226.720     0.150
    16.071   222.944     0.150
    16.071   222.580     0.150
    16.071   226.237     0.150
    16.071   223.550     0.150
    16.069   223.450     0.150
    16.069   396.800     0.150
    16.069   224.341     0.150
    16.250   226.380     0.150
    16.825   236.250     0.150
    16.922   439.770     0.150
    16.905   240.960     0.150
    17.206   238.260     0.150
    17.425   243.720     0.150
    17.425   447.910     0.150
    17.383   241.950     0.150
    17.383   241.850     0.150
    17.508   243.706     0.150
    17.508   244.827     0.150
    17.545   244.350     0.150
    17.612   245.000     0.150
    17.618   245.050     0.150
    17.618   243.738     0.150
    17.618   244.310     0.150
    17.618   245.750     0.150
    17.618   244.050     0.150
    17.618   439.650     0.150
    17.618   244.470     0.150
    17.968   250.450     0.150
    17.894   247.550     0.150
    17.894   455.650     0.150
    18.002   251.728     0.150
    18.127   253.070     0.150
    18.131   250.760     0.150
    18.233   252.130     0.150
    18.213   254.597     0.150
    18.192   251.384     0.150
    18.192   251.180     0.150
    18.192   252.550     0.150
    18.192   252.114     0.150
    18.192   251.620     0.150
    18.226   253.060     0.150
    18.445   257.718     0.150
    18.905   260.848     0.150
    19.006   263.150     0.150
    18.920   264.740     0.150
    19.200   265.760     0.150
    19.185   265.650     0.150
    19.324   264.050     0.150
    19.324   264.365     0.150
    19.324   264.490     0.150
    19.324   263.760     0.150
    19.321   265.100     0.150
    19.325   264.520     0.150
    19.325   263.960     0.150
    19.519   267.950     0.150
    19.500   266.550     0.150
    19.500   266.061     0.150
    19.500   267.050     0.150
    19.500   266.475     0.150
    19.500   486.780     0.150
    19.500   266.040     0.150
    19.463   268.450     0.150
    19.482   270.050     0.150
    19.482   271.100     0.150
    19.797   272.350     0.150
    19.984   272.925     0.150
    19.984   498.950     0.150
    19.984   272.590     0.150
    19.984   273.950     0.150
    20.047   275.720     0.150
    20.105   275.580     0.150
    20.091   273.550     0.150
    20.091   274.445     0.150
    20.091   274.340     0.150
    20.091   498.950     0.150
    20.091   273.780     0.150
    20.091   272.238     0.150
    20.091   274.150     0.150
    20.091   274.026     0.150
    20.091   274.550     0.150
    20.367   278.850     0.150
    20.367   276.250     0.150
    20.275   278.120     0.150
    20.373   279.150     0.150
    20.373   509.770     0.150
    20.973   282.951     0.150
    20.973   282.540     0.150
    20.965   286.490     0.150
    21.048   286.500     0.150
    21.156   286.250     0.150
    21.407   288.050     0.150
    21.420   291.060     0.150
    21.420   534.400     0.150
    21.397   289.650     0.150
    21.420   289.950     0.150
    21.561   539.820     0.150
    21.701   292.500     0.150
    21.701   537.800     0.150
    21.824   541.670     0.150
    21.811   293.580     0.150
    21.905   294.350     0.150
    21.905   294.470     0.150
    21.905   294.168     0.150
    21.905   534.068     0.150
    21.905   293.950     0.150
    21.905   313.950     0.150
    21.905   534.450     0.150
    22.146   296.250     0.150
    22.157   296.550     0.150
    22.157   543.550     0.150
    22.186   297.298     0.150
    22.194   299.550     0.150
    22.194   298.050     0.150
    22.221   297.450     0.150
    22.221   543.650     0.150
    22.392   299.550     0.150
    22.371   301.250     0.150
    22.527   300.310     0.150
    22.452   302.140     0.150
    22.452   300.780     0.150
    22.604   300.650     0.150
    22.604   324.180     0.150
    22.604   533.270     0.150
    22.604   550.150     0.150
    22.913   307.252     0.150
    23.048   305.090     0.150
    23.116   306.550     0.150
    23.152   308.040     0.150
    23.157   308.150     0.150
    23.160   307.950     0.150
    23.160   307.950     0.150
    23.160   307.386     0.150
    23.160   308.150     0.150
    23.160   307.250     0.150
    23.160   307.850     0.150
    23.160   998.950     0.150
    23.160   307.050     0.150
    23.213   307.050     0.150
    23.326   307.670     0.150
    23.450   310.780     0.150
    23.425   309.950     0.150
    23.425   559.750     0.150
    23.446   311.250     0.150
    23.446   310.540     0.150
    23.446   312.150     0.150
    23.545   313.070     0.150
    23.565   311.550     0.150
    23.565   312.400     0.150
    23.565   311.350     0.150
    23.677   314.150     0.150
    23.691   313.690     0.150
    23.710   312.950     0.150
    23.710   569.850     0.150
    23.858   313.720     0.150
    23.819   314.250     0.150
    23.819   314.690     0.150
    23.819   314.470     0.150
    23.819   314.907     0.150
    23.819   314.570     0.150
    23.935   315.550     0.150
    23.904   317.330     0.150
    24.040   314.710     0.150
    24.040   577.830     0.150
    24.270   320.040     0.150
    24.270   581.800     0.150
    24.390   318.620     0.150
    24.390   580.250     0.150
    24.395   319.640     0.150
    24.395   580.990     0.150
    24.383   318.850     0.150
    24.383   575.250     0.150
    24.553   321.620     0.150
    24.553   585.940     0.150
    24.499   322.100     0.150
    24.769   322.909     0.150
    24.981   323.920     0.150
    25.066   325.620     0.150
    25.066   540.930     0.150
    25.066   325.750     0.150
    25.073   324.950     0.150
    25.073   324.173     0.150
    25.073   324.644     0.150
    25.073   324.350     0.150
    25.073   324.800     0.150
    25.362   329.861     0.150
    25.401   328.650     0.150
    25.578   329.950     0.150
    25.578   330.278     0.150
    25.578   331.090     0.150
    25.578   330.600     0.150
    25.752   333.260     0.150
    25.752   602.450     0.150
    25.942   332.100     0.150
    25.943   334.600     0.150
    26.297   337.827     0.150
    26.402   339.330     0.150
    26.430   337.490     0.150
    26.675   340.550     0.150
    26.675   614.550     0.150
    26.829   339.520     0.150
    26.829   630.450     0.150
    26.756   341.785     0.150
    26.807   340.517     0.150
    26.873   343.739     0.150
    26.994   344.331     0.150
    27.044   342.650     0.150
    27.044   386.750     0.150
    27.044   626.050     0.150
    27.044   344.963     0.150
    27.044   343.359     0.150
    27.044   344.440     0.150
    27.044   343.650     0.150
    27.044     5.000     0.150
    27.188   345.470     0.150
    27.188   625.010     0.150
    27.300   346.909     0.150
    27.335   348.137     0.150
    27.351   347.159     0.150
    27.358   348.397     0.150
    27.401   345.799     0.150
    27.418   347.450     0.150
    27.420   348.381     0.150
    27.435   348.138     0.150
    27.522   349.847     0.150
    27.572   348.395     0.150
    27.572   349.310     0.150
    27.572   348.650     0.150
    27.572   348.850     0.150
    27.620   347.587     0.150
    27.620   348.700     0.150
    27.679   348.790     0.150
    27.813   352.250     0.150
    27.819   352.307     0.150
    27.888   351.860     0.150
    27.888   352.250     0.150
    28.008   352.130     0.150
    27.917   351.801     0.150
    27.949   351.550     0.150
    27.956   352.290     0.150
    27.958   352.534     0.150
    28.053   351.350     0.150
    28.072   353.600     0.150
    28.072   640.740     0.150
    28.096   352.290     0.150
    28.052   354.488     0.150
    28.075   352.153     0.150
    28.078   354.487     0.150
    28.153   355.593     0.150
    28.223   353.606     0.150
    28.222   354.175     0.150
    28.225   355.954     0.150
    28.762   644.980     0.150
    28.354   357.450     0.150
    28.292   353.693     0.150
    28.338   354.757     0.150
    28.337   355.672     0.150
    28.352   356.539     0.150
    28.357   356.350     0.150
    28.374   354.783     0.150
    28.415   356.650     0.150
    28.415   355.221     0.150
    28.416   357.420     0.150
    28.447   357.750     0.150
    28.500   357.176     0.150
    28.519   357.979     0.150
    28.689   358.720     0.150
    28.649   359.619     0.150
    28.653   357.650     0.150
    28.756   358.200     0.150
    28.679   357.850     0.150
    28.693   359.130     0.150
    28.696   357.775     0.150
    28.696   546.075     0.150
    28.696   358.050     0.150
    28.696   358.150     0.150
    28.703   358.220     0.150
    28.703   357.950     0.150
    28.703     3.290     0.150
    28.698   358.886     0.150
    28.703   359.516     0.150
    28.707   358.150     0.150
    28.737   359.361     0.150
    28.741   360.840     0.150
    28.749   360.801     0.150
    28.753   358.550     0.150
    28.761   358.550     0.150
    28.777   359.450     0.150
    28.796   358.698     0.150
    28.796   359.850     0.150
    28.797   359.450     0.150
    28.818   359.863     0.150
    28.831   359.250     0.150
    28.893   361.340     0.150
    28.893   362.450     0.150
    28.893   362.700     0.150
    28.893   360.930     0.150
    28.853   359.438     0.150
    28.853   360.642     0.150
    28.912   361.084     0.150
    28.914   361.817     0.150
    28.923   362.370     0.150
    28.943   361.329     0.150
    28.970   362.054     0.150
    29.076   360.990     0.150
    28.985   362.680     0.150
    28.985   361.650     0.150
    28.990   362.950     0.150
    28.990   362.628     0.150
    28.991   363.180     0.150
    29.007   360.857     0.150
    29.036   363.250     0.150
    29.036   363.527     0.150
    29.036   362.355     0.150
    29.066   360.981     0.150
    29.118   361.966     0.150
    29.130   363.733     0.150
    29.207   362.528     0.150
    29.177   361.636     0.150
    29.211   364.993     0.150
    29.222   363.283     0.150
    29.249   365.250     0.150
    29.371   364.130     0.150
    29.371   659.530     0.150
    29.299   365.482     0.150
    29.315   364.260     0.150
    29.315   363.316     0.150
    29.315   363.850     0.150
    29.349   365.072     0.150
    29.366   365.320     0.150
    29.389   365.765     0.150
    29.423   364.443     0.150
    29.394   364.575     0.150
    29.394   364.950     0.150
    29.403   364.578     0.150
    29.415   366.291     0.150
    29.423   365.047     0.150
    29.428   366.620     0.150
    29.464   367.780     0.150
    29.464   367.050     0.150
    29.496   366.118     0.150
    29.582   367.084     0.150
    29.597   365.555     0.150
    29.597   366.250     0.150
    29.597   365.745     0.150
    29.616   366.725     0.150
    29.673   366.304     0.150
    29.718   366.133     0.150
    29.726   366.880     0.150
    29.726   365.830     0.150
    29.726   368.850     0.150
    29.754   368.902     0.150
    29.757   366.443     0.150
    29.768   366.240     0.150
    29.780   366.982     0.150
    29.805   369.879     0.150
    29.821   367.793     0.150
    29.821   367.609     0.150
    29.822   367.353     0.150
    29.924   370.584     0.150
    29.929   368.746     0.150
    29.964   369.827     0.150
    30.022   370.525     0.150
    30.043   370.317     0.150
    30.014   369.674     0.150
    30.016   371.345     0.150
    30.068   371.345     0.150
    30.082   371.834     0.150
    30.121   370.299     0.150
    30.141   371.508     0.150
    30.148   371.834     0.150
    30.167   371.367     0.150
    30.234   372.450     0.150
    30.171   372.811     0.150
    30.210   371.089     0.150
    30.323   373.550     0.150
    30.323   676.550     0.150
    30.340   373.750     0.150
    30.358   370.943     0.150
    30.358   372.240     0.150
    30.357   373.650     0.150
    30.361   374.760     0.150
    30.365   373.230     0.150
    30.416   372.005     0.150
    30.469   373.242     0.150
    30.485   373.326     0.150
    30.541   374.677     0.150
    30.559   374.784     0.150
    30.565   376.475     0.150
    30.582   374.670     0.150
    30.607   376.489     0.150
    30.644   376.950     0.150
    30.650   378.061     0.150
    30.659   375.796     0.150
    30.692   374.286     0.150
    30.761   376.343     0.150
    30.746   375.922     0.150
    30.813   376.480     0.150
    30.819   378.234     0.150
    30.826   378.430     0.150
    30.827   376.798     0.150
    30.837   378.550     0.150
    30.842   376.727     0.150
    30.864   377.415     0.150
    30.894   376.557     0.150
    30.937   377.218     0.150
    30.937   377.640     0.150
    30.999   379.370     0.150
    30.999   440.350     0.150
    30.999   685.430     0.150
    30.973   377.589     0.150
    30.975   378.860     0.150
    30.975   380.628     0.150
    30.990   378.408     0.150
    31.143   381.428     0.150
    31.143   380.610     0.150
    31.143   381.732     0.150
    31.048   379.060     0.150
    31.053   378.733     0.150
    31.057   380.628     0.150
    31.061   379.590     0.150
    31.061   378.326     0.150
    31.108   380.016     0.150
    31.115   381.361     0.150
    31.125   378.882     0.150
    31.166   381.350     0.150
    31.195   381.587     0.150
    31.201   379.630     0.150
    31.206   379.832     0.150
    31.245   380.676     0.150
    31.213   379.774     0.150
    31.233   379.645     0.150
    31.236   379.819     0.150
    31.247   380.622     0.150
    31.257   380.603     0.150
    31.265   381.850     0.150
    31.295   380.344     0.150
    31.307   383.255     0.150
    31.338   382.239     0.150
    31.349   380.742     0.150
    31.350   381.606     0.150
    31.384   382.827     0.150
    31.387   381.479     0.150
    31.415   381.323     0.150
    31.436   381.210     0.150
    31.439   381.345     0.150
    31.446   380.467     0.150
    31.448   380.525     0.150
    31.454   383.600     0.150
    31.455   383.598     0.150
    31.488   381.696     0.150
    31.519   381.820     0.150
    31.521   381.911     0.150
    31.523   385.514     0.150
    31.541   382.764     0.150
    31.598   384.537     0.150
    31.612   381.998     0.150
    31.630   386.150     0.150
    31.632   383.890     0.150
    31.630   385.810     0.150
    31.664   384.450     0.150
    31.692   383.748     0.150
    31.703   382.364     0.150
    31.723   384.780     0.150
    31.727   385.901     0.150
    31.732   384.628     0.150
    31.758   385.343     0.150
    31.767   384.667     0.150
    31.827   383.961     0.150
    31.870   385.759     0.150
    31.880   387.410     0.150
    31.880   387.650     0.150
    31.917   385.587     0.150
    31.952   386.552     0.150
    32.021   385.777     0.150
    32.059   385.998     0.150
    32.189   389.849     0.150
    32.189   390.370     0.150
    32.189   389.563     0.150
    32.130   387.548     0.150
    32.140   390.156     0.150
    32.204   390.250     0.150
    32.157   389.912     0.150
    32.160   389.202     0.150
    32.194   387.595     0.150
    32.208   390.130     0.150
    32.208   390.645     0.150
    32.208   390.993     0.150
    32.272   389.316     0.150
    32.273   388.174     0.150
    32.283   388.479     0.150
    32.281   391.378     0.150
    32.311   388.277     0.150
    32.344   391.622     0.150
    32.364   390.290     0.150
    32.361   391.401     0.150
    32.394   392.440     0.150
    32.442   389.622     0.150
    32.442   390.410     0.150
    32.472   392.200     0.150
    32.497   392.410     0.150
    32.497   392.550     0.150
    32.529   393.350     0.150
    32.535   393.227     0.150
    32.543   391.679     0.150
    32.565   392.050     0.150
    32.568   392.358     0.150
    32.640   394.150     0.150
    32.581   392.337     0.150
    32.588   391.944     0.150
    32.604   391.885     0.150
    32.694   394.155     0.150
    32.702   391.881     0.150
    32.717   393.287     0.150
    32.763   391.150     0.150
    32.763   462.250     0.150
    32.895   395.050     0.150
    32.895   464.050     0.150
    32.895   709.050     0.150
    32.895   824.850     0.150
    32.802   393.164     0.150
    32.814   395.286     0.150
    32.817   394.265     0.150
    32.857   393.311     0.150
    32.974   394.622     0.150
    33.019   397.057     0.150
    33.092   398.690     0.150
    33.206   398.749     0.150
    33.223   396.798     0.150
    33.232   396.427     0.150
    33.245   397.288     0.150
    33.247   396.704     0.150
    33.266   397.394     0.150
    33.266   396.980     0.150
    33.284   399.350     0.150
    33.319   399.350     0.150
    33.324   396.930     0.150
    33.329   397.930     0.150
    33.329   398.150     0.150
    33.356   396.760     0.150
    33.368   397.353     0.150
    33.379   399.246     0.150
    33.397   400.450     0.150
    33.397   399.650     0.150
    33.397   400.130     0.150
    33.429   398.601     0.150
    33.442   401.290     0.150
    33.442   400.150     0.150
    33.442   399.640     0.150
    33.540   398.368     0.150
    33.540   399.230     0.150
    33.603   403.940     0.150
    33.603   403.348     0.150
    33.616   400.602     0.150
    33.648   401.600     0.150
    33.827   403.275     0.150
    33.827   562.795     0.150
    33.827   403.730     0.150
    33.824   401.731     0.150
    33.923   404.550     0.150
    33.923   475.050     0.150
    33.891   405.980     0.150
    33.891   407.210     0.150
    33.930   406.450     0.150
    33.930   406.290     0.150
    33.972   406.150     0.150
    33.972   732.050     0.150
    34.088   405.710     0.150
    34.088   405.250     0.150
    34.087   407.050     0.150
    34.088   405.594     0.150
    34.175   406.610     0.150
    34.239   408.098     0.150
    34.239   408.360     0.150
    34.239   407.650     0.150
    34.239   409.095     0.150
    34.239     3.130     0.150
    34.225   407.560     0.150
    34.293   407.950     0.150
    34.354   408.178     0.150
    34.354   409.340     0.150
    34.385   409.750     0.150
    34.569   409.650     0.150
    34.599   410.850     0.150
    34.614   411.270     0.150
    34.614   411.410     0.150
    34.668   411.150     0.150
    34.680   410.850     0.150
    34.685   411.350     0.150
    34.748   412.150     0.150
    34.705   412.690     0.150
    34.705   410.540     0.150
    34.939   412.050     0.150
    34.939   492.150     0.150
    34.939   877.250     0.150
    34.863   412.210     0.150
    34.937   413.550     0.150
    34.965   414.350     0.150
    34.967   414.750     0.150
    34.984   413.760     0.150
    34.987   414.050     0.150
    35.080   413.750     0.150
    35.132   414.350     0.150
    35.145   414.450     0.150
    35.179   416.790     0.150
    35.217   415.950     0.150
    35.241   416.370     0.150
    35.241   416.250     0.150
    35.242   416.350     0.150
    35.249   418.850     0.150
    35.372   417.370     0.150
    35.372   417.200     0.150
    35.310   417.400     0.150
    35.310   416.580     0.150
    35.379   416.650     0.150
    35.385   416.750     0.150
    35.340   417.850     0.150
    35.340   754.250     0.150
    35.340   418.050     0.150
    35.479   419.470     0.150
    35.517   420.340     0.150
    35.517   419.635     0.150
    35.583   420.060     0.150
    35.583   418.750     0.150
    35.583   419.075     0.150
    35.593   419.050     0.150
    35.599   419.150     0.150
    35.601   422.130     0.150
    35.638   419.450     0.150
    35.719   421.190     0.150
    35.719   420.644     0.150
    35.723   420.150     0.150
    35.816   420.781     0.150
    35.816   421.310     0.150
    35.816   421.070     0.150
    35.816     3.189     0.150
    35.923   421.000     0.150
    35.921   423.200     0.150
    35.988   422.650     0.150
    36.047   422.650     0.150
    36.102   421.258     0.150
    36.102   422.690     0.150
    36.102   422.482     0.150
    36.115   423.700     0.150
    36.143   424.230     0.150
    36.283   424.045     0.150
    36.283   423.790     0.150
    36.283   423.310     0.150
    36.283     3.351     0.150
    36.287   423.790     0.150
    36.198   424.950     0.150
    36.247   425.900     0.150
    36.315   424.350     0.150
    36.315   503.150     0.150
    36.315   908.650     0.150
    36.319   424.540     0.150
    36.247   425.350     0.150
    36.273   425.960     0.150
    36.273   425.050     0.150
    36.273   425.279     0.150
    36.283   424.910     0.150
    36.283   502.220     0.150
    36.321   425.049     0.150
    36.321   508.232     0.150
    36.375   426.840     0.150
    36.375   426.023     0.150
    36.478   425.400     0.150
    36.478   425.849     0.150
    36.478   425.400     0.150
    36.478   568.600     0.150
    36.492   425.450     0.150
    36.510   425.550     0.150
    36.446   428.030     0.150
    36.501   426.807     0.150
    36.501   511.340     0.150
    36.526   427.860     0.150
    36.526   426.620     0.150
    36.576   429.200     0.150
    36.576   428.450     0.150
    36.576   509.950     0.150
    36.630   428.008     0.150
    36.630   512.902     0.150
    36.663   428.760     0.150
    36.663   429.500     0.150
    36.671   429.890     0.150
    36.671   429.750     0.150
    36.724   428.870     0.150
    36.777   430.850     0.150
    36.793   431.120     0.150
    36.808   430.370     0.150
    36.808   430.010     0.150
    36.808   429.460     0.150
    36.808   513.130     0.150
    36.818   429.710     0.150
    36.818   429.507     0.150
    36.818   513.025     0.150
    36.818   775.653     0.150
    36.819   430.050     0.150
    36.836   430.300     0.150
    36.836   429.600     0.150
    36.846   430.210     0.150
    36.863   429.250     0.150
    36.863   569.450     0.150
    36.863   772.250     0.150
    36.905   430.640     0.150
    36.971   430.851     0.150
    36.971   517.535     0.150
    36.971   778.436     0.150
    36.992   431.450     0.150
    37.090   431.891     0.150
    37.131   432.392     0.150
    37.131   518.793     0.150
    37.256   432.690     0.150
    37.384   434.530     0.150
    37.441   434.260     0.150
    37.460   436.110     0.150
    37.460   435.260     0.150
    37.460   523.418     0.150
    37.460   784.389     0.150
    37.464   434.955     0.150
    37.464   521.785     0.150
    37.468   435.060     0.150
    37.468   515.820     0.150
    37.468   785.440     0.150
    37.468   940.960     0.150
    37.531   434.300     0.150
    37.531   435.460     0.150
    37.531   434.450     0.150
    37.671   437.680     0.150
    37.671   437.150     0.150
    37.671   792.750     0.150
    37.697   436.760     0.150
    37.697   525.717     0.150
    37.710   436.480     0.150
    37.710   435.450     0.150
    37.724   438.050     0.150
    37.724   526.150     0.150
    37.749   438.700     0.150
    37.848   438.950     0.150
    37.848   792.450     0.150
    37.954   439.550     0.150
    38.011   440.450     0.150
    38.019   438.880     0.150
    38.045   439.230     0.150
    38.088   440.377     0.150
    38.088   530.301     0.150
    38.088   789.394     0.150
    38.114   440.288     0.150
    38.114   530.235     0.150
    38.114   788.807     0.150
    38.127   441.450     0.150
    38.127   441.008     0.150
    38.127   530.310     0.150
    38.139   441.580     0.150
    38.144   438.810     0.150
    38.176   442.120     0.150
    38.226   442.020     0.150
    38.226   441.450     0.150
    38.226   529.750     0.150
    38.226   796.250     0.150
    38.230   441.140     0.150
    38.258   441.360     0.150
    38.258   441.060     0.150
    38.258   529.800     0.150
    38.294   442.890     0.150
    38.298   443.210     0.150
    38.298   442.365     0.150
    38.298   532.841     0.150
    38.298   792.527     0.150
    38.427   442.050     0.150
    38.427   536.050     0.150
    38.427   797.350     0.150
    38.427   442.360     0.150
    38.373   443.930     0.150
    38.421   443.231     0.150
    38.421   444.310     0.150
    38.421   443.650     0.150
    38.421   442.205     0.150
    38.447   444.240     0.150
    38.447   443.350     0.150
    38.447   443.608     0.150
    38.447   531.110     0.150
    38.547   444.410     0.150
    38.667   445.990     0.150
    38.686   445.570     0.150
    38.686   445.308     0.150
    38.686   536.360     0.150
    38.758   445.394     0.150
    38.758   537.924     0.150
    38.758   797.901     0.150
    38.780   447.190     0.150
    38.780   446.750     0.150
    38.780   577.750     0.150
    38.780   536.010     0.150
    38.780   535.750     0.150
    38.780   540.050     0.150
    38.780   804.750     0.150
    38.780   975.750     0.150
    38.835   448.030     0.150
    38.866   540.829     0.150
    38.866   799.471     0.150
    39.005   446.750     0.150
    38.918   447.610     0.150
    38.839   447.600     0.150
    39.133   448.371     0.150
    39.035   448.950     0.150
    39.040   449.640     0.150
    39.040   449.158     0.150
    39.040   540.010     0.150
    39.049   448.908     0.150
    39.049   536.560     0.150
    39.126   448.010     0.150
    39.135   448.510     0.150
    39.135   541.790     0.150
    39.212   449.550     0.150
    39.212   541.050     0.150
    39.212   811.350     0.150
    39.159   450.370     0.150
    39.186   449.940     0.150
    39.237   451.200     0.150
    39.240   542.010     0.150
    39.465   451.148     0.150
    39.465   545.410     0.150
    39.499   453.240     0.150
    39.505   451.463     0.150
    39.505   545.790     0.150
    39.581   453.100     0.150
    39.539   453.358     0.150
    39.539   544.910     0.150
    39.539   453.940     0.150
    39.570   453.280     0.150
    39.597   453.540     0.150
    39.713   453.908     0.150
    39.713   548.110     0.150
    39.734   455.190     0.150
    39.756   453.432     0.150
    39.756   548.567     0.150
    39.794   456.120     0.150
    39.794   455.658     0.150
    39.794   548.760     0.150
    39.827   453.805     0.150
    39.827   548.252     0.150
    39.972   455.070     0.150
    39.897   456.450     0.150
    39.975   456.950     0.150
    39.975   456.408     0.150
    39.975   548.010     0.150
    40.068   456.450     0.150
    40.068   456.790     0.150
    40.068   457.440     0.150
    40.068     3.810     0.150
    40.058   455.674     0.150
    40.058   552.661     0.150
    40.086   456.264     0.150
    40.086   553.142     0.150
    40.119   457.660     0.150
    40.188   456.400     0.150
    40.357   458.850     0.150
    40.357   558.550     0.150
    40.357   582.950     0.150
    40.357   814.350     0.150
    40.302   459.760     0.150
    40.302   459.308     0.150
    40.302   552.510     0.150
    40.302   460.970     0.150
    40.313   458.250     0.150
    40.313   459.175     0.150
    40.313   551.575     0.150
    40.313   581.327     0.150
    40.313   458.650     0.150
    40.389   459.650     0.150
    40.389   557.150     0.150
    40.389   830.250     0.150
    40.321   458.850     0.150
    40.409   459.800     0.150
    40.416   460.350     0.150
    40.464   461.580     0.150
    40.464   461.058     0.150
    40.464   555.060     0.150
    40.467   461.653     0.150
    40.499   459.560     0.150
    40.499   460.058     0.150
    40.499   557.510     0.150
    40.721   461.330     0.150
    40.660   460.860     0.150
    40.660   460.395     0.150
    40.660   559.473     0.150
    40.696   463.008     0.150
    40.696   558.160     0.150
    40.696   464.660     0.150
    40.702   463.560     0.150
    40.702   462.958     0.150
    40.702   556.260     0.150
    41.033   463.800     0.150
    41.033   463.580     0.150
    41.049   466.130     0.150
    41.137   465.750     0.150
    41.137   561.650     0.150
    41.053   465.160     0.150
    41.053   464.080     0.150
    41.102   465.190     0.150
    41.102   465.558     0.150
    41.102   563.960     0.150
    41.129   464.960     0.150
    41.154   467.920     0.150
    41.294   466.660     0.150
    41.337   467.360     0.150
    41.425   467.150     0.150
    41.489   469.130     0.150
    41.525   470.050     0.150
    41.587   468.530     0.150
    41.601   471.080     0.150
    41.601   470.558     0.150
    41.601   569.510     0.150
    41.707   469.210     0.150
    41.707   468.450     0.150
    41.619   468.550     0.150
    41.619   469.050     0.150
    41.619   468.450     0.150
    41.619   563.200     0.150
    41.648   470.708     0.150
    41.648   569.860     0.150
    41.681   469.090     0.150
    41.681     3.230     0.150
    41.682   470.170     0.150
    41.682   470.060     0.150
    41.682   469.240     0.150
    41.682   469.650     0.150
    41.682   571.760     0.150
    41.692   471.130     0.150
    41.754   473.480     0.150
    41.827   470.780     0.150
    41.827   471.310     0.150
    41.827   470.380     0.150
    42.058   473.150     0.150
    42.058   473.440     0.150
    42.058   472.390     0.150
    42.058   572.140     0.150
    42.104   474.840     0.150
    42.177   474.750     0.150
    42.177   573.850     0.150
    42.177   589.750     0.150
    42.177   858.050     0.150
    42.104   474.258     0.150
    42.104   574.510     0.150
    42.221   475.050     0.150
    42.221   574.350     0.150
    42.221   860.050     0.150
    42.155   474.458     0.150
    42.155   573.560     0.150
    42.344   474.600     0.150
    42.443   475.150     0.150
    42.374   477.090     0.150
    42.374   476.508     0.150
    42.374   577.860     0.150
    42.534   475.050     0.150
    42.534   578.750     0.150
    42.495   476.190     0.150
    42.495   477.740     0.150
    42.495   476.600     0.150
    42.495   589.900     0.150
    42.495   476.421     0.150
    42.495   477.250     0.150
    42.495   478.210     0.150
    42.457   476.350     0.150
    42.468   476.091     0.150
    42.468   476.650     0.150
    42.468   476.320     0.150
    42.468     2.720     0.150
    42.483   478.310     0.150
    42.483   477.858     0.150
    42.483   579.460     0.150
    42.702   477.640     0.150
    42.638   478.280     0.150
    42.663   478.530     0.150
    42.665   478.275     0.150
    42.665   478.550     0.150
    42.813   479.740     0.150
    42.733   479.250     0.150
    42.733   582.050     0.150
    42.733   861.750     0.150
    42.733  1078.550     0.150
    42.854   480.330     0.150
    43.086   483.000     0.150
    43.086   481.385     0.150
    43.086   481.970     0.150
    43.086   482.808     0.150
    43.086   587.960     0.150
    43.140   480.675     0.150
    43.140   481.520     0.150
    43.140   481.893     0.150
    43.140   481.660     0.150
    43.140   482.190     0.150
    43.165   483.620     0.150
    43.165   481.800     0.150
    43.165   587.920     0.150
    43.397   484.640     0.150
    43.397   588.760     0.150
    43.519   484.050     0.150
    43.519   874.150     0.150
    43.671   486.310     0.150
    43.671   487.210     0.150
    43.742   486.640     0.150
    43.742   592.260     0.150
    43.847   487.150     0.150
    43.847   590.250     0.150
    43.847   879.550     0.150
    43.962   487.980     0.150
    43.995   489.950     0.150
    43.995   489.250     0.150
    44.004   489.180     0.150
    44.080   490.150     0.150
    44.080   593.930     0.150
    44.110   594.100     0.150
    44.176   490.780     0.150
    44.249   489.850     0.150
    44.249   491.750     0.150
    44.249   595.650     0.150
    44.249   490.870     0.150
    44.258   491.650     0.150
    44.209   490.980     0.150
    44.257   491.150     0.150
    44.266   490.310     0.150
    44.266   596.260     0.150
    44.387   492.150     0.150
    44.387   597.050     0.150
    44.387  1087.250     0.150
    44.358   492.750     0.150
    44.391   492.480     0.150
    44.391   596.600     0.150
    44.499   492.700     0.150
    44.499   493.300     0.150
    44.499   492.550     0.150
    44.499   492.420     0.150
    44.517   493.350     0.150
    44.630   494.950     0.150
    44.753   494.150     0.150
    44.770   494.750     0.150
    44.862   496.150     0.150
    44.966   495.550     0.150
    44.966   895.150     0.150
    44.966   494.780     0.150
    45.091   499.990     0.150
    45.091   603.940     0.150
    45.174   498.650     0.150
    45.299   499.750     0.150
    45.598   501.650     0.150
    45.693   501.943     0.150
    45.693   502.510     0.150
    45.693   502.150     0.150
    45.693     3.641     0.150
    46.118   504.950     0.150
    46.118   504.098     0.150
    46.268   507.570     0.150
    46.308   505.950     0.150
    46.440   508.030     0.150
    46.730   507.650     0.150
    46.565   507.750     0.150
    46.600   508.750     0.150
    46.730   508.211     0.150
    46.730   507.810     0.150
    46.731   509.350     0.150
    46.857   510.595     0.150
    46.857   511.370     0.150
    46.857   510.350     0.150
    46.786   510.050     0.150
    46.794   510.550     0.150
    46.860   511.250     0.150
    46.953   510.938     0.150
    46.953   513.110     0.150
    46.969   511.750     0.150
    46.981   512.150     0.150
    46.981   622.750     0.150
    46.981   924.150     0.150
    47.179   513.650     0.150
    47.179   927.750     0.150
    47.106   514.010     0.150
    47.201   515.450     0.150
    47.201   515.560     0.150
    47.403   515.480     0.150
    47.501   515.390     0.150
    47.527   516.750     0.150
    47.539   516.450     0.150
    47.634   517.860     0.150
    47.634   517.740     0.150
    47.755   518.626     0.150
    47.750   518.220     0.150
    47.842   518.840     0.150
    47.905   519.040     0.150
    48.013   520.550     0.150
    48.134   521.170     0.150
    48.152   522.150     0.150
    48.169   521.050     0.150
    48.215   521.940     0.150
    48.233   522.610     0.150
    48.341   522.870     0.150
    48.384   523.320     0.150
    48.514   523.750     0.150
    48.526   524.050     0.150
    48.568   524.775     0.150
    48.568   524.370     0.150
    48.580   526.180     0.150
    48.580   525.620     0.150
    48.654   526.050     0.150
    48.595   525.386     0.150
    48.595   524.560     0.150
    48.595   524.190     0.150
    48.595   524.730     0.150
    48.608   524.410     0.150
    48.615   525.650     0.150
    48.624   524.450     0.150
    48.628   525.400     0.150
    48.730   525.300     0.150
    48.747   525.740     0.150
    48.768   527.060     0.150
    48.768   525.930     0.150
    48.782   527.950     0.150
    48.881   642.550     0.150
    48.881   955.150     0.150
    48.911   526.967     0.150
    48.911   527.080     0.150
    48.911     3.851     0.150
    48.911   643.200     0.150
    48.911   528.190     0.150
    48.911   528.050     0.150
    49.011   527.690     0.150
    49.020   528.150     0.150
    49.052   528.860     0.150
    49.118   528.550     0.150
    49.118  1122.050     0.150
    49.178   528.350     0.150
    49.178   952.550     0.150
    49.178   529.510     0.150
    49.193   529.472     0.150
    49.193   530.600     0.150
    49.193   531.300     0.150
    49.187   528.980     0.150
    49.193   529.600     0.150
    49.262   529.860     0.150
    49.294   532.050     0.150
    49.326   532.773     0.150
    49.457   530.650     0.150
    49.457   646.150     0.150
    49.457   961.550     0.150
    49.375   530.750     0.150
    49.385   531.710     0.150
    49.448   531.980     0.150
    49.454   529.950     0.150
    49.563   531.750     0.150
    49.604   532.631     0.150
    49.693   532.380     0.150
    49.693   532.810     0.150
    49.693   531.960     0.150
    49.693     3.101     0.150
    49.693   613.650     0.150
    49.693   646.950     0.150
    49.693   961.350     0.150
    49.693   972.850     0.150
    49.693  1124.150     0.150
    49.693   532.220     0.150
    49.693     2.771     0.150
    49.773   533.830     0.150
    49.856   533.750     0.150
    49.844   534.140     0.150
    50.249   537.030     0.150
    50.249   965.860     0.150
    50.251   536.284     0.150
    50.251   536.590     0.150
    50.251   536.740     0.150
    50.273   538.060     0.150
    50.289   536.464     0.150
    50.294   537.315     0.150
    50.358   538.830     0.150
    50.358   537.550     0.150
    50.394   537.790     0.150
    50.394   538.450     0.150
    50.394   538.800     0.150
    50.508   538.770     0.150
    50.508   969.490     0.150
    50.501   540.000     0.150
    50.516   539.800     0.150
    50.516   538.650     0.150
    50.634   543.050     0.150
    50.634   541.716     0.150
    50.634   539.550     0.150
    50.683   540.013     0.150
    50.792   539.388     0.150
    50.792   541.160     0.150
    50.722   539.350     0.150
    50.991   542.850     0.150
    50.991   543.150     0.150
    51.074   545.150     0.150
    51.074   544.550     0.150
    51.325   545.330     0.150
    51.325   981.180     0.150
    51.360   545.368     0.150
    51.360   546.110     0.150
    51.360   544.750     0.150
    51.282   544.413     0.150
    51.459   547.050     0.150
    51.609   546.550     0.150
    51.609   624.750     0.150
    51.609   988.050     0.150
    51.678   548.150     0.150
    51.817   548.918     0.150
    51.841   550.560     0.150
    51.766   548.850     0.150
    51.856   550.046     0.150
    51.856   550.810     0.150
    51.856   548.550     0.150
    51.795   548.450     0.150
    51.893   548.966     0.150
    51.893   550.910     0.150
    51.893   549.650     0.150
    51.806   548.050     0.150
    51.810   548.950     0.150
    51.825   548.672     0.150
    52.062   550.450     0.150
    52.062   995.250     0.150
    52.128   551.050     0.150
    52.250   552.538     0.150
    52.250   554.760     0.150
    52.259   552.220     0.150
    52.259   551.550     0.150
    52.320   552.190     0.150
    52.320   552.340     0.150
    52.334   552.350     0.150
    52.338   552.350     0.150
    52.320   552.400     0.150
    52.275   553.050     0.150
    52.388   552.950     0.150
    52.474   554.050     0.150
    52.709   555.610     0.150
    52.956   558.350     0.150
    53.172   562.250     0.150
    53.172   560.100     0.150
    53.172   559.350     0.150
    53.374   559.850     0.150
    53.377   559.450     0.150
    53.377   560.425     0.150
    53.377   559.390     0.150
    53.389   559.950     0.150
    53.599   561.950     0.150
    54.097   566.509     0.150
    54.097   566.940     0.150
    54.221   567.040     0.150
    54.447   568.150     0.150
    54.471   567.530     0.150
    54.471   569.150     0.150
    54.471   567.850     0.150
    54.631   567.710     0.150
    54.545   569.100     0.150
    54.680   569.950     0.150
    54.640   569.370     0.150
    54.672   571.890     0.150
    54.733   570.270     0.150
    54.733   570.910     0.150
    55.183   573.550     0.150
    55.183   574.095     0.150
    55.183   574.940     0.150
    55.183   575.830     0.150
    55.183   573.395     0.150
    55.183   574.350     0.150
    55.183     2.690     0.150
    55.309   574.270     0.150
    55.309   574.970     0.150
    55.538   576.000     0.150
    55.538  1043.190     0.150
    55.708   577.220     0.150
    55.708   701.620     0.150
    55.708  1045.520     0.150
    55.803   577.682     0.150
    55.803   578.300     0.150
    55.803   579.860     0.150
    55.803   577.830     0.150
    55.803     3.100     0.150
    55.827   580.390     0.150
    55.933   578.900     0.150
    55.933  1048.250     0.150
    56.104   581.750     0.150
    56.042   579.670     0.150
    56.042  1050.080     0.150
    56.234   580.418     0.150
    56.234   581.990     0.150
    56.392   582.040     0.150
    56.392   583.150     0.150
    56.554   584.900     0.150
    56.514   585.390     0.150
    56.546   583.850     0.150
    56.997   585.840     0.150
    57.349   589.070     0.150
    58.202   594.500     0.150
    58.202   594.100     0.150
    58.193   596.050     0.150
    58.193   595.550     0.150
    58.193   595.200     0.150
    58.468   597.950     0.150
    58.468  1081.750     0.150
    59.158   601.750     0.150
    59.158   601.251     0.150
    59.158   602.370     0.150
    59.772   605.450     0.150
    59.772   742.250     0.150
    59.772  1099.350     0.150
    59.772   605.985     0.150
    59.772   605.700     0.150
    59.772   605.200     0.150
    59.772   606.360     0.150
    59.772     2.819     0.150
    59.840   605.640     0.150
    59.949   607.311     0.150
    59.949   606.450     0.150
    59.949     3.529     0.150
    59.941   607.250     0.150
    59.941  1103.750     0.150
    60.049   607.170     0.150
    60.028   608.870     0.150
    60.028   608.720     0.150
    60.092   610.240     0.150
    60.106   610.445     0.150
    60.238   608.650     0.150
    60.238   609.470     0.150
    60.238   608.290     0.150
    60.238   608.450     0.150
    60.238   609.140     0.150
    60.373   609.645     0.150
    60.373   609.300     0.150
    60.373     3.190     0.150
    60.373   609.600     0.150
    60.375   609.888     0.150
    60.375   608.400     0.150
    60.410   609.550     0.150
    60.392   611.100     0.150
    60.392   612.170     0.150
    60.589   611.170     0.150
    60.658   611.800     0.150
    60.687   612.350     0.150
    60.825   612.950     0.150
    60.825   613.100     0.150
    60.981   614.900     0.150
    60.981   614.450     0.150
    60.981   613.200     0.150
    60.981   615.310     0.150
    60.981   614.070     0.150
    61.095   614.210     0.150
    61.207   615.780     0.150
    61.483   617.450     0.150
    61.753   619.590     0.150
    61.815   620.570     0.150
    61.815   617.210     0.150
    61.815   617.450     0.150
    61.815   619.250     0.150
    61.815   618.320     0.150
    62.868   626.250     0.150
    62.868   669.050     0.150
    62.868   765.150     0.150
    62.868  1134.750     0.150
    62.868  1217.250     0.150
    63.370   628.520     0.150
    63.435   630.750     0.150
    63.427   629.800     0.150
    63.435   630.505     0.150
    63.435   631.010     0.150
    63.712   635.650     0.150
    63.963   633.480     0.150
    63.963   633.040     0.150
    64.078   634.760     0.150
    64.078   635.550     0.150
    64.078   634.130     0.150
    64.272   638.750     0.150
    64.506   639.030     0.150
    64.603   640.560     0.150
    65.095   642.210     0.150
    65.762   646.540     0.150
    66.268   648.350     0.150
    66.268   647.050     0.150
    66.268   647.825     0.150
    66.268   795.300     0.150
    66.268  2364.425     0.150
    66.280   648.450     0.150
    66.323   649.890     0.150
    66.723   652.220     0.150
    66.723   651.320     0.150
    66.723   652.370     0.150
    66.723     2.650     0.150
    66.851   653.041     0.150
    66.851   654.460     0.150
    66.851   652.020     0.150
    66.820   651.687     0.150
    66.820   650.650     0.150
    66.820   798.850     0.150
    66.820  1183.350     0.150
    67.048   654.710     0.150
    67.048   652.220     0.150
    67.048   652.570     0.150
    67.268   654.225     0.150
    67.268   655.075     0.150
    67.268   655.510     0.150
    67.268   654.360     0.150
    67.268     2.760     0.150
    67.998   659.850     0.150
    68.110   658.137     0.150
    68.155   664.510     0.150
    68.214   662.245     0.150
    68.214   661.730     0.150
    68.206   664.400     0.150
    68.235   665.510     0.150
    68.442   661.070     0.150
    68.664   663.460     0.150
    68.664   664.300     0.150
    68.664   663.950     0.150
    68.823   668.980     0.150
    68.910   669.580     0.150
    68.920   668.800     0.150
    69.091   667.500     0.150
    69.091   667.000     0.150
    69.091   668.820     0.150
    69.388   669.270     0.150
    69.388   668.550     0.150
    69.481   669.060     0.150
    70.109   671.970     0.150
    69.805   675.350     0.150
    69.995   671.480     0.150
    69.995   672.350     0.150
    69.935   675.000     0.150
    70.467   673.800     0.150
    70.627   676.260     0.150
    71.063   682.750     0.150
    71.124   680.895     0.150
    71.124   682.020     0.150
    71.275   682.750     0.150
    71.879   683.225     0.150
    71.879   682.100     0.150
    71.879   682.750     0.150
    71.879   681.850     0.150
    72.557   688.123     0.150
    72.557   688.970     0.150
    72.915   689.198     0.150
    73.486   693.650     0.150
    73.513   691.928     0.150
    73.513   693.550     0.150
    73.575   691.470     0.150
    74.387   699.510     0.150
    74.387   699.710     0.150
    74.402   698.875     0.150
    75.483   704.150     0.150
    75.492   704.877     0.150
    75.547   705.978     0.150
    75.971   707.450     0.150
    76.714   712.230     0.150
    76.714   711.850     0.150
    77.107   715.520     0.150
    77.107   714.550     0.150
    77.107   714.750     0.150
    77.107   714.262     0.150
    77.958   718.570     0.150
    77.958   717.640     0.150
    77.958   718.750     0.150
    77.958   717.860     0.150
    77.947   719.338     0.150
    78.092   720.070     0.150
    78.092   719.570     0.150
    78.092   719.750     0.150
    78.111   720.298     0.150
    78.147   721.570     0.150
    78.147   723.240     0.150
    78.323   720.120     0.150
    78.323   721.260     0.150
    78.357   720.450     0.150
    78.357   720.400     0.150
    78.357  1854.750     0.150
    78.357  2341.100     0.150
    78.927   723.950     0.150
    79.581   727.650     0.150
    79.857   729.130     0.150
    80.180   731.420     0.150
    80.265   731.658     0.150
    80.658   734.125     0.150
    80.662   734.075     0.150
    80.662   733.250     0.150
    80.687   734.240     0.150
    80.687  1854.000     0.150
    80.687   733.750     0.150
    80.785   734.850     0.150
    80.843   735.790     0.150
    80.952   734.019     0.150
    80.953   733.916     0.150
    80.967   734.799     0.150
    80.968   734.850     0.150
    81.109   735.520     0.150
    81.109   735.050     0.150
    81.209   737.840     0.150
    81.309   737.870     0.150
    81.309   737.550     0.150
    81.585   738.450     0.150
    81.550   739.498     0.150
    81.608   740.338     0.150
    81.611   739.862     0.150
    81.625   739.518     0.150
    81.655   740.838     0.150
    81.658   741.404     0.150
    81.658   740.350     0.150
    81.658   742.870     0.150
    81.979   741.278     0.150
    82.714   746.498     0.150
    82.838   743.695     0.150
    83.184   746.575     0.150
    83.155   747.650     0.150
    83.179   746.400     0.150
    83.179  1847.525     0.150
    83.179   745.940     0.150
    83.179   747.050     0.150
    83.441   748.945     0.150
    83.441   748.269     0.150
    83.441   748.500     0.150
    83.550   748.150     0.150
    83.480   749.176     0.150
    83.485   750.636     0.150
    83.500   750.552     0.150
    83.800   749.270     0.150
    83.923   751.150     0.150
    84.042   750.900     0.150
    84.270   751.953     0.150
    84.281   753.853     0.150
    84.772   754.415     0.150
    84.834   753.750     0.150
    84.834   754.032     0.150
    84.834   754.795     0.150
    84.852   755.450     0.150
    85.753   757.620     0.150
    85.922   760.850     0.150
    86.070   763.818     0.150
    86.367   762.725     0.150
    86.469   762.075     0.150
    86.425   764.898     0.150
    86.609   764.550     0.150
    86.734   765.400     0.150
    87.459   767.175     0.150
    87.459  1411.650     0.150
    87.459  1839.125     0.150
    87.459   767.950     0.150
    87.461   767.350     0.150
    87.461   767.670     0.150
    89.323   779.330     0.150
    89.438   777.250     0.150
    89.438   777.050     0.150
    89.438   776.700     0.150
    89.438  1075.000     0.150
    89.438  1430.850     0.150
    89.438  1823.500     0.150
    89.438  1831.750     0.150
    89.470   777.250     0.150
    89.963   780.775     0.150
    89.963   780.250     0.150
    89.951   780.470     0.150
    89.951   780.110     0.150
    90.520   783.383     0.150
    90.526   782.421     0.150
    90.538   783.464     0.150
    91.305   787.825     0.150
    91.623   790.140     0.150
    91.623   786.070     0.150
    91.765   787.550     0.150
    93.095   794.275     0.150
    93.237   794.825     0.150
    93.263   793.925     0.150
    93.263  1019.575     0.150
    93.263  1818.033     0.150
    93.263   794.950     0.150
    93.633   796.900     0.150
    94.372   801.100     0.150
    95.117   804.525     0.150
    96.412   810.420     0.150
    96.525   810.660     0.150
    96.546   811.350     0.150
    96.588   810.370     0.150
    96.588   809.820     0.150
    96.588   810.250     0.150
    96.593   809.425     0.150
    96.512   811.730     0.150
    96.807   811.350     0.150
    97.393   815.075     0.150
    97.495   816.100     0.150
    98.698   821.416     0.150
    98.698   819.750     0.150
    98.826   821.725     0.150
    99.338   823.325     0.150
    99.622   824.550     0.150
    99.732   826.775     0.150
    99.779   823.650     0.150
    99.779   824.550     0.150
    99.943   827.475     0.150
   100.606   829.970     0.150
   101.687   831.175     0.150
   101.919   832.675     0.150
   101.919  1797.175     0.150
   102.026   836.825     0.150
   102.595   837.750     0.150
   102.595  1090.400     0.150
   102.595  1099.100     0.150
   102.595  1796.100     0.150
   103.197   840.767     0.150
   104.661   846.450     0.150
   104.661  1101.550     0.150
   104.661  1106.750     0.150
   106.237   856.220     0.150
   107.308   858.260     0.150
   107.308  1108.150     0.150
   107.308  1781.950     0.150
   107.308  2285.200     0.150
   109.957  1775.219     0.150
   110.656  1115.194     0.150
   111.031  1113.050     0.150
   111.031  1151.750     0.150
   111.031  2082.450     0.150
   114.062  1527.071     0.150
   114.062  1765.917     0.150
   114.968  1120.275     0.150
   114.968  1179.800     0.150
   114.968  1757.450     0.150
   114.968  1121.730     0.150
   115.103  1182.000     0.150
   115.210  1120.711     0.150
   115.210  1121.949     0.150
   115.210  1119.067     0.150
   115.210  1755.842     0.150
   115.210  1120.250     0.150
   116.045  1124.348     0.150
   116.045  1530.677     0.150
   116.045  1753.382     0.150
   116.153  1122.447     0.150
   116.153  1533.801     0.150
   116.153  1753.913     0.150
   116.348  1122.200     0.150
   116.761  1123.300     0.150
   116.761  1125.150     0.150
   118.227  1128.190     0.150
   118.268  1128.290     0.150
   118.587  1132.895     0.150
   118.980  1129.530     0.150
   120.653  1133.380     0.150
   121.041  1132.494     0.150
   121.041  1134.050     0.150
   121.041  1134.195     0.150
   121.079  1133.930     0.150
   121.244  1133.750     0.150
   121.434  1134.440     0.150
   121.568  1134.350     0.150
   121.758  1135.400     0.150
   121.843  1137.750     0.150
   122.400  1136.560     0.150
   122.433  1136.050     0.150
   122.802  1136.910     0.150
   123.033  1136.850     0.150
   123.188  1137.350     0.150
   123.188  1138.450     0.150
   123.491  1138.000     0.150
   123.568  1139.950     0.150
   123.614  1138.850     0.150
   123.691  1141.683     0.150
   123.717  1138.780     0.150
   123.836  1138.920     0.150
   124.441  1138.620     0.150
   124.441  1137.644     0.150
   124.441  1137.520     0.150
   124.392  1139.890     0.150
   124.387  1139.850     0.150
   124.499  1139.250     0.150
   124.651  1142.463     0.150
   124.807  1139.350     0.150
   124.963  1142.933     0.150
   125.288  1140.940     0.150
   125.711  1142.383     0.150
   125.743  1139.870     0.150
   125.743  1142.040     0.150
   125.754  1143.820     0.150
   125.917  1145.250     0.150
   125.965  1142.530     0.150
   125.970  1142.550     0.150
   126.221  1143.540     0.150
   126.325  1141.800     0.150
   126.339  1141.940     0.150
   126.268  1143.390     0.150
   126.466  1142.850     0.150
   126.667  1142.750     0.150
   126.667  1144.270     0.150
   126.870  1144.350     0.150
   126.909  1144.590     0.150
   127.069  1144.450     0.150
   127.139  1144.960     0.150
   127.139  1144.270     0.150
   127.216  1145.900     0.150
   127.419  1145.320     0.150
   127.786  1144.050     0.150
   128.387  1145.030     0.150
   128.587  1144.779     0.150
   128.541  1146.050     0.150
   128.541  1147.810     0.150
   128.551  1150.268     0.150
   128.922  1148.123     0.150
   128.946  1148.003     0.150
   129.753  1153.068     0.150
   131.209  1152.860     0.150
   131.970  1155.725     0.150
   131.970  1154.900     0.150
   131.970  1295.475     0.150
   133.749  1163.100     0.150
   134.153  1162.245     0.150
   134.302  1161.820     0.150
   134.453  1161.720     0.150
   134.453  1161.350     0.150
   134.625  1163.550     0.150
   135.288  1163.100     0.150
   135.465  1164.770     0.150
   135.807  1158.050     0.150
   135.931  1164.820     0.150
   136.152  1166.320     0.150
   136.301  1165.720     0.150
   136.442  1163.520     0.150
   136.451  1164.550     0.150
   138.607  1169.950     0.150
   138.864  1169.450     0.150
   139.758  1165.420     0.150
   143.518  1174.325     0.150
   143.709  1173.050     0.150
   143.709  1174.750     0.150
   143.990  1174.600     0.150
   143.990  1173.925     0.150
   144.450  1175.325     0.150
   144.464  1175.550     0.150
   144.464  1174.700     0.150
   144.727  1174.930     0.150
   144.727  1175.075     0.150
   147.082  1184.810     0.150
   147.103  1185.350     0.150
   147.243  1184.910     0.150
   147.770  1180.398     0.150
   147.786  1181.174     0.150
   147.853  1184.579     0.150
   147.869  1183.414     0.150
     1.621    29.660     0.150
     1.621    51.960     0.150
     1.847    32.290     0.150
     1.936    34.760     0.150
     2.534    42.960     0.150
     2.702    45.560     0.150
     2.895    48.520     0.150
     3.144    51.859     0.150
     3.694    58.810     0.150
     4.091    63.819     0.150
     4.137    65.960     0.150
     4.297    65.880     0.150
     4.617    70.785     0.150
     4.617    85.234     0.150
     4.617   148.910     0.150
     4.895    75.300     0.150
     5.751    87.220     0.150
     6.336    95.080     0.150
     6.525    93.390     0.150
     6.710   100.109     0.150
    12.500   177.028     0.150
    19.274   263.484     0.150
    19.424   265.010     0.150
    19.919   270.734     0.150
    25.008   325.460     0.150
    36.408   425.660     0.150
    40.964   462.859     0.150
     1.627    29.890     0.150
     1.627    51.390     0.150
     1.627    28.460     0.150
     1.948    35.190     0.150
     1.948    35.040     0.150
     2.518    42.090     0.150
     2.683    44.790     0.150
     2.911    48.350     0.150
     3.675    58.640     0.150
     4.098    65.200     0.150
     4.289    66.650     0.150
     4.631    71.515     0.150
     4.631   150.665     0.150
     4.907    76.140     0.150
     5.684    83.900     0.150
     6.319    94.740     0.150
     6.341    95.590     0.150
     6.506    92.560     0.150
     6.700    99.840     0.150
     7.019   103.700     0.150
     7.210   107.480     0.150
     9.874   141.950     0.150
    10.517   150.640     0.150
    10.670   152.400     0.150
    10.840   154.130     0.150
    11.394   164.480     0.150
    11.976   169.330     0.150
    12.443   175.340     0.150
    12.519   176.284     0.150
    12.519   312.159     0.150
    12.519   175.820     0.150
    13.328   188.790     0.150
    13.951   196.290     0.150
    14.703   206.380     0.150
    14.703   207.230     0.150
    15.036   215.560     0.150
    16.009   223.650     0.150
    16.079   223.890     0.150
    19.268   265.230     0.150
    19.298   265.415     0.150
    19.443   267.840     0.150
    19.941   273.615     0.150
    20.048   272.521     0.150
    21.910   294.771     0.150
    23.230   308.940     0.150
    25.030   325.190     0.150
    25.030   324.920     0.150
    28.749   357.990     0.150
    35.276   415.210     0.150
    36.405   424.940     0.150
    38.489   442.280     0.150
    40.985   464.015     0.150
    41.660   468.715     0.150
    51.873   548.365     0.150
    74.334   698.760     0.150
    75.471   704.850     0.150
    75.949   707.210     0.150
    76.498   710.280     0.150
    79.620   727.820     0.150
    87.391   766.665     0.150
     1.605    29.188     0.150
     1.605    29.028     0.150
     1.830    32.288     0.150
     1.830    32.019     0.150
     1.924    34.589     0.150
     2.365    40.988     0.150
     2.518    42.488     0.150
     2.687    45.188     0.150
     2.706    45.788     0.150
     2.886    47.528     0.150
     3.131    51.688     0.150
     3.680    58.988     0.150
     3.680    58.729     0.150
     3.941    63.188     0.150
     4.076    64.788     0.150
     4.124    65.389     0.150
     4.279    66.568     0.150
     4.286    66.089     0.150
     4.552    71.488     0.150
     4.606    71.514     0.150
     4.626    70.988     0.150
     4.796    73.188     0.150
     4.816    73.788     0.150
     4.883    75.738     0.150
     5.159    78.608     0.150
     5.343    81.188     0.150
     5.698    87.858     0.150
     5.698    88.288     0.150
     5.698    87.654     0.150
     5.698   148.301     0.150
     5.775    89.788     0.150
     5.737    87.898     0.150
     5.805    87.988     0.150
     5.888    89.188     0.150
     6.049    90.889     0.150
     6.163    93.288     0.150
     6.300    94.889     0.150
     6.330    95.089     0.150
     6.320    95.259     0.150
     6.510    92.788     0.150
     6.692   100.549     0.150
     6.791   100.988     0.150
     7.012   104.557     0.150
     7.012   183.076     0.150
     7.012   104.158     0.150
     7.014   105.288     0.150
     7.072   105.988     0.150
     7.106   105.589     0.150
     7.231   108.988     0.150
     7.231   108.658     0.150
     7.287   108.688     0.150
     7.287   108.299     0.150
     7.748   114.788     0.150
     7.809   114.828     0.150
     8.330   122.988     0.150
     8.351   122.889     0.150
     8.649   127.488     0.150
     8.715   128.288     0.150
     8.856   130.788     0.150
     8.868   129.988     0.150
     8.985   131.568     0.150
     9.100   132.488     0.150
     9.089   133.549     0.150
     9.141   133.009     0.150
     9.268   136.389     0.150
     9.268   136.683     0.150
     9.268   136.853     0.150
     9.290   137.038     0.150
     9.629   140.208     0.150
     9.631   138.519     0.150
     9.710   139.828     0.150
     9.869   141.669     0.150
    10.015   145.230     0.150
     9.984   145.589     0.150
    10.055   145.740     0.150
    10.055   146.842     0.150
    10.062   147.488     0.150
    10.170   145.988     0.150
    10.291   144.068     0.150
    10.330   150.288     0.150
    10.512   150.419     0.150
    10.599   154.253     0.150
    10.605   151.698     0.150
    10.609   153.570     0.150
    10.662   152.014     0.150
    10.662   271.402     0.150
    10.662   152.259     0.150
    10.682   156.307     0.150
    10.809   157.349     0.150
    10.838   153.729     0.150
    10.910   155.889     0.150
    10.915   158.089     0.150
    10.957   157.960     0.150
    10.957   158.339     0.150
    10.957   158.902     0.150
    10.957   157.049     0.150
    10.957   159.108     0.150
    10.957   159.358     0.150
    11.093   161.047     0.150
    11.093   159.406     0.150
    11.081   157.636     0.150
    11.081   157.229     0.150
    11.148   161.900     0.150
    11.127   161.528     0.150
    11.249   163.656     0.150
    11.249   163.224     0.150
    11.391   165.123     0.150
    11.461   167.089     0.150
    11.547   168.038     0.150
    11.561   166.593     0.150
    11.561   166.347     0.150
    11.610   168.523     0.150
    11.610   169.127     0.150
    11.632   167.623     0.150
    11.647   166.988     0.150
    11.647   293.688     0.150
    11.628   167.367     0.150
    11.808   169.063     0.150
    11.934   172.708     0.150
    11.934   171.192     0.150
    11.973   169.248     0.150
    11.937   173.788     0.150
    12.093   174.282     0.150
    12.104   171.688     0.150
    12.296   176.147     0.150
    12.316   175.381     0.150
    12.411   178.629     0.150
    12.387   177.883     0.150
    12.435   181.179     0.150
    12.443   175.389     0.150
    12.515   177.427     0.150
    12.515   177.148     0.150
    12.515   176.558     0.150
    12.515   315.582     0.150
    12.515   177.752     0.150
    12.515   315.234     0.150
    12.629   180.795     0.150
    12.685   177.604     0.150
    12.739   181.580     0.150
    12.800   180.479     0.150
    12.833   182.828     0.150
    12.879   181.498     0.150
    12.893   181.969     0.150
    12.977   183.599     0.150
    13.325   188.589     0.150
    13.344   188.578     0.150
    13.393   189.139     0.150
    13.383   193.889     0.150
    13.383   344.589     0.150
    13.424   193.715     0.150
    13.477   193.788     0.150
    13.477   345.488     0.150
    13.652   197.028     0.150
    13.816   194.278     0.150
    13.822   198.658     0.150
    13.877   200.089     0.150
    13.877   356.488     0.150
    13.922   198.488     0.150
    13.950   196.889     0.150
    14.055   202.889     0.150
    14.055   360.889     0.150
    14.103   199.912     0.150
    14.141   201.528     0.150
    14.150   198.958     0.150
    14.090   196.589     0.150
    14.178   200.379     0.150
    14.206   203.979     0.150
    14.243   200.849     0.150
    14.365   202.389     0.150
    14.365   202.288     0.150
    14.371   201.858     0.150
    14.384   206.419     0.150
    14.681   205.179     0.150
    14.681   204.913     0.150
    14.681   204.479     0.150
    14.867   214.791     0.150
    14.867   214.929     0.150
    14.867   216.898     0.150
    14.917   209.288     0.150
    14.867   212.982     0.150
    14.971   210.658     0.150
    14.971   209.809     0.150
    15.012   214.158     0.150
    15.099   217.482     0.150
    15.184   212.788     0.150
    15.240   216.339     0.150
    15.222   217.881     0.150
    15.176   217.328     0.150
    15.497   220.288     0.150
    15.556   217.938     0.150
    15.624   218.379     0.150
    15.743   220.340     0.150
    15.771   225.318     0.150
    15.799   224.509     0.150
    16.196   226.118     0.150
    15.891   227.669     0.150
    15.946   228.099     0.150
    16.007   222.695     0.150
    16.056   223.363     0.150
    16.056   395.514     0.150
    16.140   226.219     0.150
    16.188   227.049     0.150
    16.531   232.759     0.150
    16.724   237.408     0.150
    16.879   235.769     0.150
    16.951   240.760     0.150
    17.159   241.078     0.150
    17.159   241.889     0.150
    17.359   246.488     0.150
    17.418   244.413     0.150
    17.418   243.188     0.150
    17.489   243.682     0.150
    17.552   246.428     0.150
    17.581   247.389     0.150
    17.647   248.589     0.150
    17.653   247.658     0.150
    17.653   246.469     0.150
    17.653   247.206     0.150
    17.653   246.288     0.150
    17.653   246.788     0.150
    17.653   248.609     0.150
    17.653   247.519     0.150
    18.048   250.050     0.150
    18.193   252.688     0.150
    18.226   256.281     0.150
    18.226   251.669     0.150
    18.261   253.791     0.150
    18.257   252.498     0.150
    18.257   252.328     0.150
    18.257   252.175     0.150
    18.492   256.175     0.150
    18.952   261.089     0.150
    18.967   264.719     0.150
    19.263   264.608     0.150
    19.263   264.158     0.150
    19.263   264.438     0.150
    19.219   266.788     0.150
    19.281   265.488     0.150
    19.281   473.639     0.150
    19.286   264.663     0.150
    19.464   267.389     0.150
    19.439   266.889     0.150
    19.439   266.732     0.150
    19.439   266.488     0.150
    19.439   266.538     0.150
    19.439   266.328     0.150
    19.501   269.688     0.150
    19.581   268.389     0.150
    19.532   271.190     0.150
    19.828   273.688     0.150
    19.931   273.738     0.150
    19.931   631.113     0.150
    20.038   274.284     0.150
    20.038   274.408     0.150
    20.038   504.769     0.150
    20.038   273.988     0.150
    20.038   274.896     0.150
    20.038   273.564     0.150
    20.038   274.519     0.150
    20.312   275.988     0.150
    20.357   278.118     0.150
    20.330   278.879     0.150
    20.555   277.708     0.150
    20.854   281.788     0.150
    20.918   282.813     0.150
    20.918   281.589     0.150
    20.918   287.299     0.150
    21.019   286.349     0.150
    21.019   286.129     0.150
    21.101   284.389     0.150
    21.096   287.229     0.150
    21.290   287.488     0.150
    21.351   287.288     0.150
    21.457   290.188     0.150
    21.519   291.509     0.150
    21.679   292.559     0.150
    21.746   292.778     0.150
    21.785   294.419     0.150
    21.888   294.658     0.150
    21.888   293.731     0.150
    21.888   534.206     0.150
    21.888   293.049     0.150
    21.888   294.288     0.150
    21.888   294.889     0.150
    21.888   314.688     0.150
    21.888   535.589     0.150
    21.888   294.519     0.150
    22.090   295.813     0.150
    22.090   295.998     0.150
    22.173   297.089     0.150
    22.200   297.788     0.150
    22.200   542.089     0.150
    22.247   297.937     0.150
    22.256   299.589     0.150
    22.337   297.288     0.150
    22.490   299.729     0.150
    22.433   301.158     0.150
    22.578   300.028     0.150
    22.578   323.448     0.150
    22.578   532.958     0.150
    22.578   549.179     0.150
    22.515   302.349     0.150
    22.515   302.158     0.150
    22.964   307.216     0.150
    23.060   305.389     0.150
    23.133   308.998     0.150
    23.206   308.188     0.150
    23.209   309.194     0.150
    23.209   308.889     0.150
    23.209   308.288     0.150
    23.209   308.288     0.150
    23.209   308.769     0.150
    23.233   308.089     0.150
    23.445   310.788     0.150
    23.510   312.938     0.150
    23.510   312.238     0.150
    23.510   311.988     0.150
    23.623   312.309     0.150
    23.623   311.788     0.150
    23.695   313.389     0.150
    23.801   314.589     0.150
    23.742   314.328     0.150
    23.748   313.988     0.150
    23.875   315.589     0.150
    23.868   315.934     0.150
    23.868   315.179     0.150
    23.868   315.049     0.150
    23.868   316.164     0.150
    23.868   315.639     0.150
    23.987   316.238     0.150
    24.351   319.028     0.150
    24.374   320.179     0.150
    24.400   320.089     0.150
    24.523   321.748     0.150
    24.823   324.583     0.150
    25.006   326.135     0.150
    25.006   325.828     0.150
    25.020   324.827     0.150
    25.020   324.863     0.150
    25.331   328.139     0.150
    25.325   327.969     0.150
    25.367   328.509     0.150
    25.394   329.089     0.150
    25.410   330.771     0.150
    25.631   331.089     0.150
    25.631   330.738     0.150
    26.609   340.488     0.150
    26.772   339.738     0.150
    26.803   342.586     0.150
    26.927   344.194     0.150
    27.058   344.988     0.150
    27.058   345.606     0.150
    27.058   344.601     0.150
    27.058   344.358     0.150
    27.058   344.089     0.150
    27.382   347.395     0.150
    27.393   348.774     0.150
    27.457   348.089     0.150
    27.484   348.212     0.150
    27.849   351.139     0.150
    27.993   352.288     0.150
    27.928   351.559     0.150
    27.928   353.188     0.150
    28.037   352.419     0.150
    28.001   353.066     0.150
    28.129   353.838     0.150
    28.261   356.088     0.150
    28.269   356.254     0.150
    28.449   356.688     0.150
    28.701   358.719     0.150
    28.682   358.288     0.150
    28.707   358.288     0.150
    28.724   359.014     0.150
    28.724   546.214     0.150
    28.724   358.419     0.150
    28.724   358.889     0.150
    28.724   358.488     0.150
    28.724   358.089     0.150
    28.731   358.599     0.150
    28.731   358.498     0.150
    28.731   359.308     0.150
    28.731   359.438     0.150
    28.735   358.589     0.150
    28.736   360.414     0.150
    28.781   358.988     0.150
    28.780   361.150     0.150
    28.789   359.089     0.150
    28.805   359.188     0.150
    28.825   359.389     0.150
    28.845   360.488     0.150
    28.850   360.589     0.150
    28.860   359.688     0.150
    28.939   360.238     0.150
    28.896   361.150     0.150
    28.952   362.481     0.150
    28.952   362.158     0.150
    28.952   359.148     0.150
    28.952   361.679     0.150
    29.018   361.398     0.150
    28.951   361.150     0.150
    28.982   362.839     0.150
    29.009   362.839     0.150
    29.024   362.799     0.150
    29.024   362.688     0.150
    29.024   363.389     0.150
    29.029   362.839     0.150
    29.031   363.401     0.150
    29.031   363.889     0.150
    29.075   362.839     0.150
    29.075   362.788     0.150
    29.200   362.919     0.150
    29.251   365.089     0.150
    29.266   365.089     0.150
    29.337   366.146     0.150
    29.346   364.288     0.150
    29.385   366.215     0.150
    29.428   365.651     0.150
    29.442   365.708     0.150
    29.454   366.776     0.150
    29.504   367.908     0.150
    29.504   367.008     0.150
    29.650   366.405     0.150
    29.650   366.589     0.150
    29.652   368.465     0.150
    29.767   369.989     0.150
    29.781   366.318     0.150
    30.057   371.914     0.150
    30.120   372.389     0.150
    30.172   372.988     0.150
    30.185   373.229     0.150
    30.256   373.488     0.150
    30.214   373.554     0.150
    30.375   374.889     0.150
    30.392   373.788     0.150
    30.401   374.652     0.150
    30.579   376.903     0.150
    30.855   378.591     0.150
    31.020   377.828     0.150
    31.020   438.958     0.150
    31.020   683.879     0.150
    31.020   785.938     0.150
    31.015   379.639     0.150
    31.124   379.999     0.150
    31.124   379.849     0.150
    31.124   379.328     0.150
    31.211   381.889     0.150
    31.303   383.089     0.150
    31.332   382.988     0.150
    31.378   382.528     0.150
    31.391   383.092     0.150
    31.423   383.654     0.150
    31.639   385.342     0.150
    31.642   385.904     0.150
    31.704   386.488     0.150
    31.744   386.068     0.150
    31.809   388.154     0.150
    31.911   387.593     0.150
    31.918   388.278     0.150
    31.918   387.589     0.150
    32.144   390.089     0.150
    32.171   388.759     0.150
    32.180   390.150     0.150
    32.196   390.968     0.150
    32.243   389.938     0.150
    32.243   390.968     0.150
    32.245   391.530     0.150
    32.321   392.093     0.150
    32.345   392.093     0.150
    32.385   392.093     0.150
    32.402   392.093     0.150
    32.426   392.738     0.150
    32.426   393.129     0.150
    32.495   391.028     0.150
    32.538   393.148     0.150
    32.578   393.889     0.150
    32.538   393.688     0.150
    32.563   393.998     0.150
    32.563   394.288     0.150
    32.574   394.369     0.150
    32.836   394.589     0.150
    32.836   711.589     0.150
    32.855   397.719     0.150
    33.189   398.786     0.150
    33.354   397.719     0.150
    33.354   397.929     0.150
    33.488   399.170     0.150
    33.488   398.929     0.150
    33.464   400.938     0.150
    33.464   400.118     0.150
    33.464   399.788     0.150
    33.641   403.979     0.150
    33.761   403.313     0.150
    33.761   403.458     0.150
    33.856   404.488     0.150
    33.924   406.509     0.150
    33.924   407.229     0.150
    33.966   406.188     0.150
    33.966   405.769     0.150
    34.045   404.919     0.150
    34.133   405.559     0.150
    34.177   408.640     0.150
    34.177   407.818     0.150
    34.177   405.889     0.150
    34.177   408.158     0.150
    34.133   406.365     0.150
    34.386   409.192     0.150
    34.386   408.929     0.150
    34.386   409.408     0.150
    34.419   409.788     0.150
    34.654   411.389     0.150
    34.654   411.783     0.150
    34.878   411.788     0.150
    35.016   413.988     0.150
    35.005   414.809     0.150
    35.012   415.208     0.150
    35.023   414.158     0.150
    35.218   416.738     0.150
    35.251   416.408     0.150
    35.251   415.288     0.150
    35.308   416.849     0.150
    35.308   417.259     0.150
    35.314   416.788     0.150
    35.321   416.688     0.150
    35.323   417.528     0.150
    35.373   417.708     0.150
    35.479   418.528     0.150
    35.513   419.068     0.150
    35.552   419.809     0.150
    35.624   419.889     0.150
    35.624   420.222     0.150
    35.673   421.089     0.150
    35.752   419.688     0.150
    35.752   421.021     0.150
    35.752   421.198     0.150
    35.752   421.139     0.150
    35.752   421.889     0.150
    35.759   421.259     0.150
    35.759   421.089     0.150
    35.960   422.719     0.150
    36.230   423.651     0.150
    36.230   423.759     0.150
    36.234   423.679     0.150
    36.181   424.729     0.150
    36.254   424.188     0.150
    36.259   424.299     0.150
    36.280   425.698     0.150
    36.280   425.488     0.150
    36.307   425.019     0.150
    36.307   425.788     0.150
    36.322   425.438     0.150
    36.425   425.398     0.150
    36.425   425.389     0.150
    36.425   569.238     0.150
    36.359   426.471     0.150
    36.439   424.988     0.150
    36.458   425.288     0.150
    36.410   426.299     0.150
    36.538   428.525     0.150
    36.609   428.839     0.150
    36.666   429.465     0.150
    36.695   429.509     0.150
    36.695   429.919     0.150
    36.803   429.089     0.150
    36.810   430.589     0.150
    36.826   431.019     0.150
    36.826   430.788     0.150
    36.859   428.089     0.150
    36.856   430.188     0.150
    36.856   430.826     0.150
    36.867   431.009     0.150
    36.895   429.988     0.150
    37.007   432.165     0.150
    37.007   571.007     0.150
    37.026   431.788     0.150
    37.125   432.429     0.150
    37.169   433.393     0.150
    37.390   434.828     0.150
    37.492   434.839     0.150
    37.492   434.549     0.150
    37.492   435.288     0.150
    37.492   435.589     0.150
    37.499   436.078     0.150
    37.499   572.757     0.150
    37.502   436.688     0.150
    37.508   435.748     0.150
    37.705   437.708     0.150
    37.734   436.938     0.150
    37.734   437.744     0.150
    37.734   573.473     0.150
    37.743   435.618     0.150
    37.743   435.988     0.150
    37.760   438.089     0.150
    37.782   438.318     0.150
    37.888   439.488     0.150
    37.882   439.078     0.150
    37.882   438.788     0.150
    38.044   440.589     0.150
    38.123   440.429     0.150
    38.154   440.208     0.150
    38.151   441.385     0.150
    38.151   574.176     0.150
    38.153   440.769     0.150
    38.162   440.938     0.150
    38.162   441.788     0.150
    38.162   440.839     0.150
    38.162   574.238     0.150
    38.176   439.248     0.150
    38.178   441.169     0.150
    38.215   441.519     0.150
    38.261   441.889     0.150
    38.261   441.788     0.150
    38.296   443.028     0.150
    38.361   442.188     0.150
    38.336   442.799     0.150
    38.336   443.322     0.150
    38.377   443.038     0.150
    38.466   444.448     0.150
    38.466   443.729     0.150
    38.466   443.188     0.150
    38.568   446.688     0.150
    38.600   444.519     0.150
    38.667   446.139     0.150
    38.721   446.688     0.150
    38.721   445.608     0.150
    38.796   446.670     0.150
    38.812   446.019     0.150
    38.812   447.188     0.150
    38.812   802.688     0.150
    38.956   446.599     0.150
    38.864   448.089     0.150
    38.904   447.666     0.150
    38.904   575.430     0.150
    38.958   447.038     0.150
    38.786   447.278     0.150
    39.081   448.120     0.150
    39.069   449.578     0.150
    39.073   449.629     0.150
    39.146   450.488     0.150
    39.270   451.818     0.150
    39.432   452.429     0.150
    39.534   453.589     0.150
    39.534   452.748     0.150
    39.543   452.600     0.150
    39.560   452.708     0.150
    39.571   453.599     0.150
    39.597   453.129     0.150
    39.605   452.988     0.150
    39.605   453.078     0.150
    39.629   454.089     0.150
    39.698   453.658     0.150
    39.750   454.469     0.150
    39.766   455.379     0.150
    39.794   579.110     0.150
    39.828   456.389     0.150
    39.907   455.233     0.150
    39.865   580.219     0.150
    39.928   456.139     0.150
    40.065   457.139     0.150
    40.065   457.019     0.150
    40.095   578.540     0.150
    40.119   457.158     0.150
    40.124   456.500     0.150
    40.124   580.755     0.150
    40.204   458.163     0.150
    40.322   459.988     0.150
    40.311   458.889     0.150
    40.311   458.139     0.150
    40.311   458.698     0.150
    40.319   458.688     0.150
    40.510   460.769     0.150
    40.455   459.948     0.150
    40.494   461.429     0.150
    40.536   460.068     0.150
    40.670   461.169     0.150
    40.698   461.438     0.150
    40.698   460.764     0.150
    40.698   583.054     0.150
    40.727   463.358     0.150
    40.730   463.568     0.150
    40.977   463.288     0.150
    41.071   465.788     0.150
    41.083   465.618     0.150
    41.092   464.729     0.150
    41.138   465.839     0.150
    41.337   467.419     0.150
    41.334   466.269     0.150
    41.441   467.589     0.150
    41.534   468.078     0.150
    41.652   468.818     0.150
    41.602   468.988     0.150
    41.625   468.629     0.150
    41.628   471.778     0.150
    41.635   468.988     0.150
    41.635   468.688     0.150
    41.635   469.188     0.150
    41.635   468.964     0.150
    41.635   470.769     0.150
    41.684   469.759     0.150
    41.707   469.858     0.150
    41.718   469.648     0.150
    41.718     3.250     0.150
    41.719   469.451     0.150
    41.719   469.648     0.150
    41.875   471.882     0.150
    42.134   474.658     0.150
    42.394   475.099     0.150
    42.406   476.858     0.150
    42.495   475.969     0.150
    42.504   476.021     0.150
    42.504   476.589     0.150
    42.504   475.889     0.150
    42.504   475.679     0.150
    42.516   478.358     0.150
    42.552   477.790     0.150
    42.552   477.568     0.150
    42.552   476.488     0.150
    42.552   476.729     0.150
    42.552   478.108     0.150
    42.552   477.038     0.150
    42.557   477.059     0.150
    42.657   477.078     0.150
    42.712   479.398     0.150
    42.717   478.964     0.150
    42.717   478.589     0.150
    42.896   480.238     0.150
    43.040   480.479     0.150
    43.120   482.988     0.150
    43.120   482.599     0.150
    43.196   482.363     0.150
    43.196   482.650     0.150
    43.196   481.979     0.150
    43.196   482.898     0.150
    43.198   483.648     0.150
    43.198   482.748     0.150
    43.198   589.028     0.150
    43.212   482.929     0.150
    43.440   484.679     0.150
    43.705   487.429     0.150
    43.705   487.009     0.150
    43.781   487.288     0.150
    43.996   488.919     0.150
    44.114   490.589     0.150
    44.185   490.788     0.150
    44.185   489.514     0.150
    44.185   593.964     0.150
    44.185   490.339     0.150
    44.321   491.589     0.150
    44.539   492.729     0.150
    44.539   492.889     0.150
    44.539     3.399     0.150
    44.723   493.738     0.150
    44.791   494.998     0.150
    45.104   495.719     0.150
    45.659   501.368     0.150
    45.755   503.129     0.150
    45.755   502.238     0.150
    45.755   501.988     0.150
    45.755   502.849     0.150
    46.160   504.868     0.150
    46.483   508.059     0.150
    46.692   507.889     0.150
    46.692   507.488     0.150
    46.822   510.472     0.150
    46.822   510.229     0.150
    46.822   509.988     0.150
    46.891   511.645     0.150
    46.891   511.809     0.150
    47.112   514.188     0.150
    47.192   515.139     0.150
    47.596   516.778     0.150
    47.744   519.113     0.150
    47.744   518.988     0.150
    47.871   519.988     0.150
    48.593   525.788     0.150
    48.593   524.563     0.150
    48.593   611.188     0.150
    48.593   525.038     0.150
    48.607   525.648     0.150
    48.620   525.743     0.150
    48.620   525.509     0.150
    48.625   525.648     0.150
    48.900   528.077     0.150
    48.900   527.408     0.150
    48.900   528.299     0.150
    48.900   527.708     0.150
    49.055   528.988     0.150
    49.112   528.858     0.150
    49.421   531.379     0.150
    49.638   532.651     0.150
    49.638   531.679     0.150
    49.638   532.158     0.150
    49.638   532.389     0.150
    49.638     3.199     0.150
    49.638   613.788     0.150
    49.638   647.089     0.150
    49.638   961.988     0.150
    49.638  1124.389     0.150
    49.791   533.988     0.150
    50.205   536.879     0.150
    50.205   536.648     0.150
    50.205   537.398     0.150
    50.456   539.338     0.150
    50.456   539.089     0.150
    50.456   539.469     0.150
    50.456   538.748     0.150
    50.456     3.740     0.150
    50.543   540.288     0.150
    50.662   542.528     0.150
    50.662   542.288     0.150
    50.750   540.325     0.150
    50.750   540.169     0.150
    51.021   543.799     0.150
    51.021   543.288     0.150
    51.021   543.688     0.150
    51.100   544.469     0.150
    51.100   543.988     0.150
    51.293   545.089     0.150
    51.706   548.589     0.150
    51.778   549.841     0.150
    51.778   549.679     0.150
    51.791   550.171     0.150
    51.791   549.898     0.150
    51.791   548.488     0.150
    51.829   550.540     0.150
    51.829   550.368     0.150
    51.829   548.988     0.150
    51.840   550.389     0.150
    51.841   548.988     0.150
    51.851   548.738     0.150
    51.851  1136.389     0.150
    51.851   548.618     0.150
    51.998   550.688     0.150
    52.186   553.658     0.150
    52.186   553.049     0.150
    52.186   551.898     0.150
    52.193   551.708     0.150
    52.193   551.158     0.150
    52.173   551.589     0.150
    52.173   551.718     0.150
    52.173   551.398     0.150
    52.173   551.089     0.150
    52.254   552.710     0.150
    52.254   552.299     0.150
    52.268   551.688     0.150
    52.272   552.288     0.150
    52.254   552.488     0.150
    52.416   554.288     0.150
    52.504   555.188     0.150
    52.755   555.879     0.150
    52.890   557.188     0.150
    53.088   557.299     0.150
    53.201   561.788     0.150
    53.231   559.898     0.150
    53.309   559.988     0.150
    53.311   559.488     0.150
    53.311   559.938     0.150
    53.323   559.589     0.150
    53.534   561.288     0.150
    54.264   566.979     0.150
    54.312   566.608     0.150
    54.465   568.618     0.150
    54.465   568.389     0.150
    54.691   570.259     0.150
    54.778   570.742     0.150
    54.778   570.589     0.150
    54.935   571.219     0.150
    55.224   573.818     0.150
    55.224   573.328     0.150
    55.356   574.448     0.150
    55.584   576.559     0.150
    55.753   577.688     0.150
    55.834   578.081     0.150
    55.834   577.589     0.150
    55.834   577.019     0.150
    56.325   583.122     0.150
    56.489   583.190     0.150
    56.489   582.998     0.150
    57.401   589.358     0.150
    57.401   589.129     0.150
    58.243   594.306     0.150
    58.243   593.879     0.150
    58.243   593.574     0.150
    58.126   595.526     0.150
    58.406   597.488     0.150
    59.215   602.089     0.150
    59.215   602.523     0.150
    59.215   602.208     0.150
    59.215   602.328     0.150
    59.215   601.559     0.150
    59.215     3.970     0.150
    59.709   605.488     0.150
    59.709   605.658     0.150
    59.883   606.679     0.150
    59.888   607.089     0.150
    60.012   608.700     0.150
    60.182   609.688     0.150
    60.182   609.205     0.150
    60.182   609.038     0.150
    60.306   609.328     0.150
    60.306   609.169     0.150
    60.308   609.752     0.150
    60.308   609.498     0.150
    60.343   609.389     0.150
    60.391   611.788     0.150
    60.391   611.278     0.150
    60.391   610.688     0.150
    60.593   611.455     0.150
    60.593   610.809     0.150
    60.591   610.788     0.150
    60.759   612.138     0.150
    60.759   612.288     0.150
    61.021   613.281     0.150
    61.021   612.618     0.150
    61.021   613.639     0.150
    61.021   612.969     0.150
    62.816   626.759     0.150
    62.903   626.498     0.150
    62.903   627.969     0.150
    63.387   631.089     0.150
    63.387   630.932     0.150
    63.387   630.108     0.150
    63.911   633.387     0.150
    63.911   632.629     0.150
    63.911   633.188     0.150
    64.144   635.862     0.150
    64.144   635.389     0.150
    64.144   635.118     0.150
    64.214   636.528     0.150
    64.562   636.879     0.150
    64.660   639.498     0.150
    65.146   642.139     0.150
    65.632   645.498     0.150
    66.209   647.389     0.150
    66.480   651.269     0.150
    66.762   650.948     0.150
    66.762   650.589     0.150
    66.927   651.498     0.150
    67.333   655.705     0.150
    67.333   654.639     0.150
    67.333   655.889     0.150
    67.333   655.479     0.150
    67.333   655.288     0.150
    67.333   655.158     0.150
    67.333     3.400     0.150
    67.914  1455.549     0.150
    68.008   660.229     0.150
    68.008   659.498     0.150
    68.170  1460.528     0.150
    68.276   662.399     0.150
    68.276   661.679     0.150
    68.276   661.479     0.150
    68.276   661.788     0.150
    68.276   661.898     0.150
    68.276   661.219     0.150
    68.276     4.130     0.150
    68.619   664.349     0.150
    68.719   664.379     0.150
    68.719   663.988     0.150
    69.100   667.639     0.150
    69.334   667.997     0.150
    69.334   668.198     0.150
    69.334   667.688     0.150
    70.167   672.208     0.150
    69.943   671.066     0.150
    69.943   671.389     0.150
    71.184   680.983     0.150
    71.312  1522.328     0.150
    71.933   683.742     0.150
    71.933   683.398     0.150
    71.933   682.639     0.150
    72.680   688.648     0.150
    72.617   688.403     0.150
    72.617   686.658     0.150
    72.617   687.908     0.150
    73.434   692.299     0.150
    73.467   691.528     0.150
    74.333   700.381     0.150
    74.351   699.708     0.150
    74.457   699.080     0.150
    74.457   699.129     0.150
    75.438   705.139     0.150
    75.452   704.719     0.150
    75.932   707.549     0.150
    76.684   712.228     0.150
    76.684   712.108     0.150
    76.684   711.889     0.150
    77.922   717.552     0.150
    78.055   719.901     0.150
    78.055   719.719     0.150
    78.320   720.788     0.150
    78.320   720.688     0.150
    78.320   720.908     0.150
    78.890   724.188     0.150
    79.224   726.358     0.150
    79.545   727.688     0.150
    79.919   729.488     0.150
    80.146   732.049     0.150
    80.610   733.135     0.150
    80.617   733.204     0.150
    80.617   733.089     0.150
    80.694   734.464     0.150
    80.694   733.889     0.150
    80.750   734.828     0.150
    80.930   735.089     0.150
    81.078   734.417     0.150
    81.078   733.969     0.150
    81.281   736.549     0.150
    81.281   736.139     0.150
    81.536   737.657     0.150
    83.136   746.238     0.150
    83.133   746.788     0.150
    83.156   747.139     0.150
    83.156   746.889     0.150
    83.165   747.589     0.150
    83.399   748.596     0.150
    83.399   748.469     0.150
    83.525   747.353     0.150
    84.009   751.439     0.150
    84.009   751.139     0.150
    84.134   750.188     0.150
    84.134   749.929     0.150
    84.742   753.773     0.150
    84.808   753.389     0.150
    84.808   754.328     0.150
    84.808   753.818     0.150
    84.841   754.389     0.150
    86.037   762.974     0.150
    86.154   760.726     0.150
    86.329   762.807     0.150
    86.439   761.559     0.150
    86.439   761.139     0.150
    86.576   763.488     0.150
    86.704   765.613     0.150
    87.413   767.413     0.150
    87.416   767.188     0.150
    87.416   767.608     0.150
    87.416   767.479     0.150
    89.395   777.134     0.150
    89.395   776.639     0.150
    89.395  1433.938     0.150
    89.395   777.458     0.150
    89.929   779.686     0.150
    89.929   779.019     0.150
    89.929   778.368     0.150
    89.937   780.479     0.150
    89.937   779.988     0.150
    91.718   787.641     0.150
    93.196   794.248     0.150
    93.255   794.163     0.150
    93.255   794.889     0.150
    93.255   794.788     0.150
    93.595   795.896     0.150
    93.925   797.828     0.150
    94.320   800.867     0.150
    95.033   804.538     0.150
    95.110   802.889     0.150
    97.452   815.208     0.150
    97.452   813.732     0.150
    98.652   820.148     0.150
    98.789   820.615     0.150
    99.739   825.488     0.150
   101.978   835.413     0.150
   111.071  1112.389     0.150
   114.103  1119.289     0.150
   114.960  1121.514     0.150
   114.960  1180.089     0.150
   114.960  1121.688     0.150
   115.252  1121.100     0.150
   115.252  1119.893     0.150
   115.252  1119.230     0.150
   116.197  1123.000     0.150
   116.356  1123.889     0.150
   116.356  1123.719     0.150
   116.755  1123.339     0.150
   124.464  1138.358     0.150
   124.464  1136.683     0.150
   124.464  1137.889     0.150
   125.012  1139.438     0.150
   126.674  1143.788     0.150
   126.674  1143.608     0.150
   127.168  1145.458     0.150
   127.851  1144.288     0.150
   127.851  1146.208     0.150
   128.607  1148.309     0.150
   129.791  1153.156     0.150
   132.027  1155.214     0.150
   132.027  1153.514     0.150
   132.027  1154.419     0.150
   132.027  1154.028     0.150
   134.365  1160.509     0.150
   136.253  1161.979     0.150
   139.822  1171.059     0.150
   142.435  1171.618     0.150
   143.775  1173.089     0.150
   147.015  1184.769     0.150
   147.036  1186.188     0.150
     1.625    29.652     0.150
     1.625    51.773     0.150
     1.817    31.742     0.150
     1.817    54.652     0.150
     1.952    35.053     0.150
     1.952    35.562     0.150
     2.396    40.854     0.150
     2.667    44.754     0.150
     2.918    50.992     0.150
     3.157    52.254     0.150
     3.659    58.453     0.150
     3.659    58.232     0.150
     4.098    65.053     0.150
     4.098    65.373     0.150
     4.151    65.854     0.150
     4.278    66.434     0.150
     4.285    65.652     0.150
     4.628    71.053     0.150
     4.581    70.854     0.150
     4.636    71.932     0.150
     4.636    85.688     0.150
     4.636   148.518     0.150
     4.812    73.652     0.150
     5.126    77.844     0.150
     4.911    76.674     0.150
     5.330    80.652     0.150
     5.784    87.354     0.150
     5.872    88.553     0.150
     5.763    87.883     0.150
     6.140    92.854     0.150
     6.303    94.572     0.150
     6.290    94.553     0.150
     6.340    95.773     0.150
     6.490    91.764     0.150
     6.688    99.943     0.150
     6.756   101.152     0.150
     7.036   103.174     0.150
     7.036   104.594     0.150
     9.115   132.393     0.150
     9.260   131.533     0.150
     9.890   141.504     0.150
    10.533   149.492     0.150
    10.687   152.223     0.150
    10.856   154.363     0.150
    11.991   169.723     0.150
    12.458   175.812     0.150
    12.534   176.473     0.150
    12.534   317.797     0.150
    12.534   177.084     0.150
    12.534   176.844     0.150
    13.343   188.402     0.150
    13.966   196.643     0.150
    14.717   206.463     0.150
    14.717   204.863     0.150
    16.024   223.992     0.150
    16.092   224.152     0.150
    16.092   393.504     0.150
    18.243   251.992     0.150
    18.243   251.623     0.150
    19.283   264.094     0.150
    19.314   265.203     0.150
    19.319   265.443     0.150
    19.459   266.342     0.150
    19.459   266.453     0.150
    19.958   273.330     0.150
    20.064   272.963     0.150
    21.923   294.246     0.150
    21.923   294.004     0.150
    23.228   309.123     0.150
    23.228   306.914     0.150
    25.046   325.104     0.150
    25.046   324.254     0.150
    35.285   416.643     0.150
    41.001   463.854     0.150
    41.001   463.613     0.150
    51.873   549.479     0.150
    74.349   698.373     0.150
    74.385   698.213     0.150
    75.965   707.053     0.150
    87.392   767.258     0.150
    89.372   777.254     0.150
     1.596    28.430     0.150
     1.750    30.729     0.150
     1.942    35.029     0.150
     2.391    40.729     0.150
     2.436    41.330     0.150
     2.599    43.729     0.150
     2.712    44.729     0.150
     3.141    51.529     0.150
     3.377    55.529     0.150
     3.591    57.729     0.150
     3.964    63.529     0.150
     4.070    64.629     0.150
     4.135    65.330     0.150
     4.572    72.129     0.150
     4.632    72.379     0.150
     4.632   149.053     0.150
     6.223    93.729     0.150
    12.602   179.283     0.150
    12.602   317.873     0.150
    16.126   225.680     0.150
    16.126   395.979     0.150
    19.369   264.779     0.150
    19.527   267.227     0.150
    20.022   272.854     0.150
    25.111   324.555     0.150
    35.296   415.936     0.150
    36.447   423.836     0.150
    40.241   457.455     0.150
    41.067   463.754     0.150
    51.844   549.604     0.150
    87.420   767.779     0.150
    89.397   777.279     0.150
     1.574    28.738     0.150
     1.574    50.539     0.150
     1.907    34.139     0.150
     2.353    40.539     0.150
     2.465    41.338     0.150
     2.636    44.338     0.150
     2.683    44.338     0.150
     3.110    50.838     0.150
     3.346    54.139     0.150
     3.629    57.938     0.150
     4.104    65.338     0.150
     4.235    65.738     0.150
     4.537    71.238     0.150
     4.594    70.738     0.150
     4.594   148.562     0.150
     6.247    93.938     0.150
    10.710   269.986     0.150
    12.566   317.033     0.150
    16.075   223.414     0.150
    16.075   396.947     0.150
    19.490   266.863     0.150
    19.978   272.738     0.150
    23.176   309.982     0.150
    25.067   324.457     0.150
    35.251   415.758     0.150
    36.461   425.139     0.150
    41.025   463.072     0.150
    87.443   767.988     0.150
    89.422   776.889     0.150
     1.591    28.123     0.150
     1.591    29.113     0.150
     1.809    31.324     0.150
     1.809    31.494     0.150
     1.915    34.223     0.150
     1.915    34.664     0.150
     2.036    35.963     0.150
     2.359    40.324     0.150
     2.496    41.924     0.150
     2.695    45.023     0.150
     2.666    44.223     0.150
     2.881    48.094     0.150
     3.120    50.824     0.150
     3.357    54.123     0.150
     3.659    58.023     0.150
     3.659    58.164     0.150
     3.933    62.623     0.150
     4.063    64.023     0.150
     4.063    64.643     0.150
     4.114    64.924     0.150
     4.257    66.184     0.150
     4.264    65.924     0.150
     4.544    70.623     0.150
     4.599    71.070     0.150
     4.599   146.824     0.150
     4.775    73.523     0.150
     4.794    73.324     0.150
     4.874    76.363     0.150
     5.145    77.623     0.150
     5.145    78.383     0.150
     5.321    80.723     0.150
     5.718    85.643     0.150
     5.726    87.404     0.150
     5.785    87.723     0.150
     5.866    88.223     0.150
     6.143    92.123     0.150
     6.305    93.844     0.150
     6.278    94.424     0.150
     6.312    94.484     0.150
     6.489    92.023     0.150
     6.670    99.393     0.150
     6.747   101.123     0.150
     7.031   104.143     0.150
     7.084   104.924     0.150
     7.222   108.854     0.150
     7.265   107.623     0.150
     7.265   107.873     0.150
     7.730   113.924     0.150
     7.828   113.244     0.150
     8.312   123.023     0.150
     8.787   127.434     0.150
     9.122   132.514     0.150
     9.071   133.143     0.150
     9.287   134.023     0.150
     9.287   136.324     0.150
     9.889   141.393     0.150
    10.533   149.824     0.150
    10.681   151.477     0.150
    10.681   270.465     0.150
    10.681   152.043     0.150
    10.859   153.613     0.150
    11.092   157.664     0.150
    11.669   166.824     0.150
    11.994   169.713     0.150
    12.125   170.713     0.150
    12.465   175.574     0.150
    12.536   177.404     0.150
    12.536   176.912     0.150
    12.536   314.818     0.150
    12.536   177.164     0.150
    12.536   177.557     0.150
    12.536   318.109     0.150
    12.536   178.023     0.150
    12.821   180.834     0.150
    12.900   182.684     0.150
    12.914   182.023     0.150
    12.998   184.113     0.150
    13.347   188.123     0.150
    13.347   188.723     0.150
    13.365   186.834     0.150
    13.415   189.744     0.150
    13.465   191.824     0.150
    13.465   341.924     0.150
    13.864   198.424     0.150
    13.864   353.023     0.150
    13.972   195.623     0.150
    13.972   197.043     0.150
    13.972   196.123     0.150
    14.026   200.324     0.150
    14.040   200.424     0.150
    14.040   357.824     0.150
    14.214   200.113     0.150
    14.214   199.133     0.150
    14.370   204.143     0.150
    14.688   206.053     0.150
    14.688   205.623     0.150
    14.688   363.213     0.150
    14.688   206.424     0.150
    14.688   206.514     0.150
    14.854   212.193     0.150
    14.854   216.924     0.150
    14.939   210.023     0.150
    14.993   209.723     0.150
    14.993   209.303     0.150
    15.002   211.004     0.150
    15.486   217.062     0.150
    15.581   218.910     0.150
    15.816   221.014     0.150
    15.878   222.293     0.150
    16.029   223.414     0.150
    16.062   223.021     0.150
    16.062   392.299     0.150
    16.062   223.373     0.150
    16.062   396.514     0.150
    16.712   239.303     0.150
    16.850   238.424     0.150
    17.349   247.023     0.150
    17.408   243.570     0.150
    17.408   245.824     0.150
    17.408   243.424     0.150
    17.469   245.684     0.150
    17.571   246.123     0.150
    17.643   247.094     0.150
    17.643   245.664     0.150
    17.643   246.123     0.150
    17.643   246.824     0.150
    17.669   247.424     0.150
    18.228   252.504     0.150
    18.235   251.812     0.150
    18.235   252.193     0.150
    18.969   263.424     0.150
    19.210   268.023     0.150
    19.296   264.854     0.150
    19.296   476.049     0.150
    19.284   263.824     0.150
    19.301   265.324     0.150
    19.460   266.854     0.150
    19.460   266.523     0.150
    19.460   267.023     0.150
    19.460   266.312     0.150
    19.460   265.963     0.150
    19.460   267.123     0.150
    19.481   268.424     0.150
    19.820   272.324     0.150
    19.950   272.449     0.150
    19.950   272.666     0.150
    20.056   274.014     0.150
    20.056   272.373     0.150
    20.329   278.223     0.150
    20.871   285.623     0.150
    20.935   283.203     0.150
    21.311   286.123     0.150
    21.895   534.592     0.150
    21.895   294.324     0.150
    21.895   313.023     0.150
    21.895   534.723     0.150
    22.107   295.893     0.150
    22.170   296.324     0.150
    22.209   297.424     0.150
    22.209   543.523     0.150
    23.191   309.723     0.150
    23.194   306.723     0.150
    23.194   308.951     0.150
    23.194   310.023     0.150
    23.440   309.324     0.150
    23.726   315.363     0.150
    23.895   315.623     0.150
    24.396   319.023     0.150
    25.039   324.123     0.150
    25.039   324.580     0.150
    25.039   324.393     0.150
    25.039   325.023     0.150
    25.025   325.264     0.150
    25.398   329.123     0.150
    26.630   341.123     0.150
    27.055   344.824     0.150
    27.055   344.973     0.150
    28.699   358.324     0.150
    28.717   356.994     0.150
    28.717   359.023     0.150
    28.717   359.324     0.150
    28.717   359.123     0.150
    28.724   358.664     0.150
    28.724   359.023     0.150
    30.278   374.023     0.150
    31.015   379.334     0.150
    31.015   440.293     0.150
    31.015   685.033     0.150
    31.015   786.654     0.150
    31.907   387.664     0.150
    32.417   393.723     0.150
    32.573   393.744     0.150
    32.599   394.623     0.150
    34.199   407.123     0.150
    35.249   415.844     0.150
    35.249   416.223     0.150
    35.329   415.164     0.150
    35.329   414.793     0.150
    35.336   417.424     0.150
    35.342   417.723     0.150
    36.441   424.654     0.150
    36.441   425.723     0.150
    36.441   425.223     0.150
    36.456   425.424     0.150
    36.474   424.924     0.150
    37.390   434.014     0.150
    37.506   435.723     0.150
    40.201   457.416     0.150
    40.314   459.824     0.150
    40.314   458.174     0.150
    40.314   458.633     0.150
    40.996   462.924     0.150
    40.996   462.283     0.150
    41.631   469.123     0.150
    41.631   469.148     0.150
    42.532   477.312     0.150
    42.701   478.525     0.150
    43.176   482.553     0.150
    44.527   492.854     0.150
    49.077   528.824     0.150
    49.657   531.023     0.150
    50.222   536.584     0.150
    51.838   548.723     0.150
    52.020   550.123     0.150
    52.276   551.424     0.150
    53.333   559.084     0.150
    59.730   605.424     0.150
    71.914   683.834     0.150
    78.069   719.924     0.150
    78.334   720.973     0.150
    78.334   720.404     0.150
    83.165   746.324     0.150
    87.427   767.924     0.150
    89.408   777.223     0.150
    89.408   777.062     0.150
     1.614    29.238     0.150
     1.937    34.738     0.150
     1.937    34.889     0.150
     1.823    31.699     0.150
     2.051    35.840     0.150
     2.380    40.840     0.150
     2.510    42.139     0.150
     2.718    45.639     0.150
     2.677    44.439     0.150
     2.901    48.299     0.150
     3.143    51.639     0.150
     3.669    58.340     0.150
     3.669    58.090     0.150
     3.954    62.939     0.150
     4.086    64.770     0.150
     4.137    65.840     0.150
     4.277    66.359     0.150
     4.284    66.340     0.150
     4.566    71.439     0.150
     4.620   149.363     0.150
     4.626    71.139     0.150
     4.795    74.039     0.150
     4.896    75.789     0.150
     4.813    73.738     0.150
     5.143    77.939     0.150
     5.336    80.439     0.150
     5.696    84.039     0.150
     5.749    87.238     0.150
     5.749    87.488     0.150
     5.795    87.738     0.150
     5.879    88.840     0.150
     6.151    92.738     0.150
     6.329    94.279     0.150
     6.294    94.039     0.150
     6.316    94.430     0.150
     6.689    99.789     0.150
     6.762   101.340     0.150
     7.024   102.879     0.150
     7.024   103.979     0.150
     7.214   108.219     0.150
     7.754   114.840     0.150
     8.775   128.260     0.150
     8.775   127.619     0.150
     9.108   132.479     0.150
     9.880   141.350     0.150
    10.523   150.100     0.150
    10.674   152.115     0.150
    10.674   268.066     0.150
    10.674   152.289     0.150
    10.847   154.039     0.150
    11.653   169.340     0.150
    11.653   297.340     0.150
    11.983   169.318     0.150
    12.451   175.689     0.150
    12.525   177.750     0.150
    12.525   175.570     0.150
    12.525   315.088     0.150
    12.525   177.229     0.150
    12.525   317.518     0.150
    12.525   177.408     0.150
    12.984   183.379     0.150
    13.334   188.180     0.150
    13.334   188.318     0.150
    13.958   197.238     0.150
    13.958   196.609     0.150
    14.200   200.420     0.150
    14.393   204.658     0.150
    14.584   204.879     0.150
    14.698   205.920     0.150
    14.698   360.111     0.150
    14.698   205.340     0.150
    14.877   211.270     0.150
    14.977   209.488     0.150
    14.977   209.270     0.150
    15.024   213.520     0.150
    15.578   217.969     0.150
    15.509   219.689     0.150
    15.802   220.818     0.150
    15.901   224.369     0.150
    16.016   223.238     0.150
    16.074   222.527     0.150
    16.074   392.740     0.150
    16.074   223.557     0.150
    16.074   393.617     0.150
    17.431   241.598     0.150
    17.665   246.889     0.150
    17.692   247.639     0.150
    18.250   252.828     0.150
    18.250   252.619     0.150
    19.274   264.279     0.150
    19.274   264.029     0.150
    19.274   263.818     0.150
    19.302   264.818     0.150
    19.449   266.629     0.150
    19.449   265.363     0.150
    19.944   271.676     0.150
    20.051   275.449     0.150
    20.051   273.250     0.150
    20.051   275.189     0.150
    21.300   285.639     0.150
    21.456   288.299     0.150
    21.753   292.639     0.150
    21.905   293.459     0.150
    21.905   294.529     0.150
    23.218   308.430     0.150
    23.218   307.637     0.150
    23.218   308.209     0.150
    25.033   324.129     0.150
    25.033   324.000     0.150
    25.002   326.029     0.150
    28.738   357.730     0.150
    28.745   358.789     0.150
    29.515   364.789     0.150
    29.657   366.449     0.150
    31.681   386.180     0.150
    33.481   399.488     0.150
    35.267   416.133     0.150
    35.339   416.969     0.150
    36.223   423.979     0.150
    36.223   422.439     0.150
    36.227   423.988     0.150
    36.251   424.539     0.150
    36.418   425.250     0.150
    36.867   429.408     0.150
    38.948   445.869     0.150
    38.969   448.139     0.150
    38.779   447.189     0.150
    39.519   452.250     0.150
    40.220   457.330     0.150
    40.328   458.578     0.150
    40.466   459.770     0.150
    40.548   459.949     0.150
    40.710   461.430     0.150
    40.989   463.268     0.150
    40.989   462.988     0.150
    41.345   467.459     0.150
    41.650   469.039     0.150
    41.650   468.996     0.150
    42.525   476.590     0.150
    44.254   491.500     0.150
    48.608   523.994     0.150
    51.114   542.578     0.150
    51.861   548.887     0.150
    51.861   549.549     0.150
    52.007   548.693     0.150
    68.707   664.078     0.150
    72.102   685.279     0.150
    71.920   683.170     0.150
    74.245   697.988     0.150
    74.332   698.850     0.150
    74.368   699.609     0.150
    75.469   704.840     0.150
    75.949   707.539     0.150
    76.335   709.840     0.150
    78.167   720.119     0.150
    78.170   719.809     0.150
    78.336   720.244     0.150
    78.547   722.568     0.150
    79.620   727.988     0.150
    87.404   766.635     0.150
    87.406   766.828     0.150
    89.385   775.740     0.150
    89.385   776.689     0.150
     1.461    26.686     0.150
     1.461    46.785     0.150
     1.682    53.586     0.150
     1.682    30.305     0.150
     1.814    32.785     0.150
     1.993    35.025     0.150
     2.267    39.086     0.150
     2.372    40.186     0.150
     2.558    43.086     0.150
     3.245    52.986     0.150
     3.552    56.486     0.150
     3.552    56.195     0.150
     3.936    62.586     0.150
     3.936    61.885     0.150
     4.003    64.186     0.150
     4.112    63.705     0.150
     4.119    64.285     0.150
     4.443    69.885     0.150
     4.506    70.885     0.150
     4.506    83.611     0.150
     4.506   147.061     0.150
     4.768    73.936     0.150
     5.105    76.326     0.150
     5.609    84.406     0.150
     6.042    90.986     0.150
     6.144    92.486     0.150
     6.172    92.875     0.150
     6.231    92.666     0.150
     6.528    97.625     0.150
     7.129   105.436     0.150
     7.126   105.715     0.150
     7.220   105.916     0.150
     9.997   143.965     0.150
    10.643   152.346     0.150
    10.774   153.760     0.150
    10.774   270.248     0.150
    10.774   153.965     0.150
    12.112   171.486     0.150
    12.649   177.855     0.150
    12.649   316.355     0.150
    12.649   179.885     0.150
    12.649   181.006     0.150
    12.649   317.688     0.150
    12.649   179.576     0.150
    13.465   189.375     0.150
    14.095   198.426     0.150
    14.684   205.596     0.150
    14.684   366.256     0.150
    14.684   206.055     0.150
    14.727   208.705     0.150
    14.727   208.555     0.150
    14.727   215.775     0.150
    14.888   210.426     0.150
    15.123   212.146     0.150
    15.369   217.695     0.150
    15.654   221.176     0.150
    16.047   223.486     0.150
    16.047   394.211     0.150
    16.047   229.246     0.150
    17.297   240.236     0.150
    18.107   251.035     0.150
    18.107   252.775     0.150
    19.344   265.693     0.150
    19.394   265.016     0.150
    19.394   265.746     0.150
    19.571   266.986     0.150
    19.571   267.166     0.150
    20.035   273.461     0.150
    20.142   273.566     0.150
    20.142   273.115     0.150
    21.890   293.355     0.150
    21.890   294.176     0.150
    23.060   306.066     0.150
    23.060   306.436     0.150
    23.060   305.846     0.150
    25.126   325.410     0.150
    25.126   324.646     0.150
    28.618   356.396     0.150
    28.624   357.506     0.150
    35.185   414.740     0.150
    35.454   415.766     0.150
    38.040   439.213     0.150
    40.123   456.539     0.150
    41.091   464.332     0.150
    41.091   464.176     0.150
    41.524   468.205     0.150
    41.555   468.086     0.150
    41.555   467.186     0.150
    42.384   475.055     0.150
    46.727   510.275     0.150
    48.273   521.596     0.150
    48.492   523.100     0.150
    51.708   547.996     0.150
    51.710   547.211     0.150
    51.710   548.006     0.150
    52.032   550.635     0.150
    52.414   552.439     0.150
    74.008   696.955     0.150
    74.360   699.746     0.150
    74.403   699.516     0.150
    74.867   702.496     0.150
    75.501   705.865     0.150
    75.992   708.176     0.150
    77.483   716.236     0.150
    78.215   721.215     0.150
    78.374   721.035     0.150
    78.592   722.965     0.150
    79.033   724.926     0.150
    79.665   728.375     0.150
    87.555   767.670     0.150
    87.557   768.125     0.150
    89.531   777.268     0.150
     1.610    28.633     0.150
     1.610    28.342     0.150
     1.610    50.611     0.150
     1.752    30.521     0.150
     2.105    35.723     0.150
     2.437    40.932     0.150
     2.727    44.932     0.150
     2.598    43.633     0.150
     2.937    47.832     0.150
     3.156    50.832     0.150
     3.589    57.031     0.150
     4.085    63.633     0.150
     4.225    65.191     0.150
     4.231    65.432     0.150
     4.648    72.582     0.150
     4.648   151.131     0.150
     4.580    70.232     0.150
     4.754    72.332     0.150
     4.914    75.432     0.150
     5.062    76.162     0.150
     5.264    80.332     0.150
     5.737    86.172     0.150
     5.737    83.303     0.150
     5.805    87.633     0.150
     6.070    91.832     0.150
     6.320    94.012     0.150
     6.227    93.332     0.150
     6.233    92.562     0.150
     6.631    98.842     0.150
     6.691   100.031     0.150
     7.142   106.332     0.150
     7.142   105.293     0.150
     7.221   107.732     0.150
     7.221   106.062     0.150
     7.729   114.133     0.150
     8.852   128.543     0.150
     8.952   131.232     0.150
     9.071   132.092     0.150
     9.182   132.752     0.150
     9.182   132.531     0.150
     9.300   135.232     0.150
     9.960   141.572     0.150
     9.953   144.621     0.150
     9.979   144.621     0.150
    10.178   148.793     0.150
    10.309   149.531     0.150
    10.757   153.383     0.150
    10.757   272.336     0.150
    10.757   151.902     0.150
    10.925   154.451     0.150
    11.721   168.232     0.150
    11.721   298.332     0.150
    12.060   169.861     0.150
    12.525   176.252     0.150
    12.603   178.361     0.150
    12.603   179.008     0.150
    12.603   317.076     0.150
    12.603   177.941     0.150
    12.603   178.645     0.150
    12.603   319.973     0.150
    12.603   178.201     0.150
    13.057   185.201     0.150
    13.411   188.932     0.150
    14.033   196.932     0.150
    14.274   200.502     0.150
    14.274   201.143     0.150
    14.389   203.543     0.150
    14.767   206.152     0.150
    14.767   205.941     0.150
    14.767   207.072     0.150
    14.794   211.031     0.150
    14.876   212.400     0.150
    14.876   210.602     0.150
    14.876   214.332     0.150
    14.876   219.441     0.150
    15.036   213.521     0.150
    15.167   217.861     0.150
    15.517   219.922     0.150
    15.767   223.293     0.150
    15.786   223.793     0.150
    15.875   221.543     0.150
    15.903   224.252     0.150
    16.092   224.371     0.150
    16.140   225.332     0.150
    16.140   224.316     0.150
    16.386   232.133     0.150
    16.886   236.633     0.150
    17.382   246.133     0.150
    17.444   241.133     0.150
    17.444   243.832     0.150
    17.474   244.611     0.150
    17.674   248.557     0.150
    17.679   248.111     0.150
    17.679   245.332     0.150
    17.702   247.531     0.150
    17.958   248.133     0.150
    18.010   251.451     0.150
    18.158   252.893     0.150
    18.177   252.682     0.150
    18.177   251.951     0.150
    19.353   264.172     0.150
    19.378   266.383     0.150
    19.383   267.133     0.150
    19.528   266.881     0.150
    19.528   267.031     0.150
    19.528   269.332     0.150
    19.528   267.781     0.150
    19.528   265.922     0.150
    19.528   268.332     0.150
    19.522   269.633     0.150
    19.522   490.232     0.150
    19.529   269.322     0.150
    19.860   273.232     0.150
    20.027   274.346     0.150
    20.134   276.701     0.150
    20.134   273.021     0.150
    20.567   281.951     0.150
    20.973   285.252     0.150
    21.008   286.102     0.150
    21.008   285.982     0.150
    21.098   285.633     0.150
    21.444   289.572     0.150
    21.481   291.432     0.150
    21.826   293.932     0.150
    21.974   294.932     0.150
    21.974   295.133     0.150
    21.974   538.531     0.150
    21.974   294.793     0.150
    22.289   297.732     0.150
    22.289   545.133     0.150
    22.398   299.072     0.150
    23.205   309.332     0.150
    23.208   308.371     0.150
    23.208   309.432     0.150
    23.208   308.531     0.150
    23.208   309.531     0.150
    23.208   308.713     0.150
    23.738   316.182     0.150
    23.769   316.232     0.150
    23.966   315.232     0.150
    25.116   325.332     0.150
    25.116   325.607     0.150
    25.116   325.043     0.150
    25.037   324.951     0.150
    25.472   331.232     0.150
    25.667   331.361     0.150
    26.178   336.312     0.150
    27.115   344.531     0.150
    27.115   387.531     0.150
    27.946   352.312     0.150
    28.719   357.932     0.150
    28.744   358.832     0.150
    28.761   358.807     0.150
    28.761   359.732     0.150
    28.761   359.031     0.150
    28.761   359.832     0.150
    28.768   358.303     0.150
    28.862   360.332     0.150
    29.379   363.133     0.150
    29.445   365.072     0.150
    29.522   368.951     0.150
    30.322   374.232     0.150
    31.033   380.182     0.150
    31.688   386.832     0.150
    31.940   388.852     0.150
    32.555   393.742     0.150
    35.042   414.992     0.150
    35.312   415.793     0.150
    36.240   423.691     0.150
    36.240   423.002     0.150
    36.243   423.691     0.150
    36.434   425.932     0.150
    36.434   425.633     0.150
    36.434   425.932     0.150
    36.869   430.633     0.150
    38.956   446.682     0.150
    39.659   455.092     0.150
    40.257   458.635     0.150
    40.558   460.281     0.150
    40.768   464.121     0.150
    41.071   464.797     0.150
    41.657   469.223     0.150
    41.689   469.232     0.150
    41.689   469.344     0.150
    42.709   480.082     0.150
    42.709   478.732     0.150
    44.556   493.781     0.150
    50.929   541.992     0.150
    52.323   553.057     0.150
    54.685   570.822     0.150
    58.145   594.852     0.150
    60.923   612.293     0.150
    78.416   721.895     0.150
    87.406   767.207     0.150
    87.406   766.982     0.150
    87.408   767.432     0.150
    89.382   777.031     0.150
    89.382   776.691     0.150
     1.521    28.006     0.150
     1.521    49.006     0.150
     1.521    27.676     0.150
     1.738    30.605     0.150
     1.862    33.506     0.150
     1.862    33.744     0.150
     2.310    39.705     0.150
     2.427    41.105     0.150
     2.606    43.805     0.150
     2.634    44.105     0.150
     2.840    47.654     0.150
     3.061    50.205     0.150
     3.298    53.506     0.150
     3.346    53.006     0.150
     3.599    57.506     0.150
     3.599    56.666     0.150
     3.884    62.006     0.150
     3.995    63.006     0.150
     3.995    63.506     0.150
     4.056    64.404     0.150
     4.178    64.836     0.150
     4.185    65.105     0.150
     4.491    70.305     0.150
     4.525    69.904     0.150
     4.551    71.404     0.150
     4.551   146.006     0.150
     4.695    72.205     0.150
     4.717    72.305     0.150
     4.818    74.035     0.150
     5.251    79.506     0.150
     5.664    85.006     0.150
     5.664    86.275     0.150
     5.725    87.205     0.150
     5.798    85.365     0.150
     5.798    88.006     0.150
     6.204    93.506     0.150
     6.234    94.686     0.150
     6.265    93.605     0.150
     6.265    93.715     0.150
     6.427    91.176     0.150
     6.593    98.625     0.150
     6.675   100.205     0.150
     7.086   103.936     0.150
     7.218   107.904     0.150
     7.218   109.154     0.150
     8.852   128.145     0.150
     9.191   132.625     0.150
     9.949   143.166     0.150
    10.594   151.324     0.150
    10.733   154.084     0.150
    10.733   268.854     0.150
    10.733   153.086     0.150
    10.820   156.324     0.150
    12.059   170.426     0.150
    12.599   177.148     0.150
    12.599   315.850     0.150
    12.599   178.766     0.150
    12.599   316.459     0.150
    12.599   177.705     0.150
    13.412   190.006     0.150
    14.688   207.115     0.150
    14.688   208.033     0.150
    14.688   363.807     0.150
    14.688   207.225     0.150
    14.942   211.965     0.150
    15.424   218.994     0.150
    16.057   223.180     0.150
    16.096   225.225     0.150
    17.394   245.295     0.150
    19.324   267.381     0.150
    19.328   265.645     0.150
    19.521   268.256     0.150
    19.521   267.865     0.150
    19.998   273.596     0.150
    20.104   274.014     0.150
    20.487   279.404     0.150
    20.890   284.666     0.150
    21.895   293.998     0.150
    21.895   293.775     0.150
    21.895   294.615     0.150
    23.123   308.115     0.150
    23.123   308.104     0.150
    23.123   307.545     0.150
    25.087   325.432     0.150
    25.087   324.295     0.150
    28.672   358.057     0.150
    35.217   415.584     0.150
    36.515   426.154     0.150
    36.515   425.424     0.150
    37.533   434.525     0.150
    40.161   457.182     0.150
    40.295   458.443     0.150
    40.381   459.955     0.150
    41.049   463.764     0.150
    41.049   463.467     0.150
    41.592   468.506     0.150
    41.592   468.830     0.150
    42.843   478.467     0.150
    51.770   548.295     0.150
    52.351   552.264     0.150
    52.351   553.221     0.150
    53.404   559.955     0.150
    60.405   609.076     0.150
    75.972   707.975     0.150
    75.973   707.596     0.150
    76.651   711.057     0.150
    77.293   715.166     0.150
    77.464   715.666     0.150
    78.195   719.967     0.150
    78.357   721.127     0.150
    78.357   720.729     0.150
    78.357   720.467     0.150
    80.785   734.236     0.150
    87.495   767.506     0.150
    87.495   767.814     0.150
    89.473   777.006     0.150
    89.473   776.854     0.150
     1.602    28.844     0.150
     1.602    51.445     0.150
     1.814    32.047     0.150
     1.926    34.645     0.150
     2.369    40.645     0.150
     2.501    42.344     0.150
     2.706    45.344     0.150
     2.670    44.844     0.150
     3.131    50.344     0.150
     4.074    64.445     0.150
     4.125    65.344     0.150
     4.555    70.547     0.150
     4.610    72.070     0.150
     4.610   149.246     0.150
     4.614    70.945     0.150
     4.802    73.844     0.150
     6.284    94.445     0.150
     6.752   101.547     0.150
     7.030   104.477     0.150
    12.532   177.641     0.150
    12.532   177.523     0.150
    16.069   392.695     0.150
    19.298   265.246     0.150
    19.456   267.086     0.150
    19.949   272.695     0.150
    25.038   324.570     0.150
    36.430   425.047     0.150
    40.994   463.219     0.150
    87.416   766.844     0.150
     1.598    28.996     0.150
     1.598    49.695     0.150
     1.838    32.898     0.150
     1.913    34.598     0.150
     2.525    42.098     0.150
     2.697    44.598     0.150
     2.697    45.496     0.150
     3.121    51.398     0.150
     3.357    53.996     0.150
     4.115    65.297     0.150
     4.542    70.398     0.150
     4.595   145.922     0.150
     5.728    86.797     0.150
     6.342    94.797     0.150
    12.506   176.289     0.150
    12.506   178.117     0.150
    19.429   266.918     0.150
    19.919   272.855     0.150
    25.008   324.273     0.150
    36.430   424.547     0.150
    40.965   463.195     0.150
    87.421   766.945     0.150
    89.404   776.598     0.150
     1.558    28.367     0.150
     1.558    50.270     0.150
     1.722    30.367     0.150
     1.910    34.168     0.150
     1.910    34.328     0.150
     2.069    36.859     0.150
     2.361    40.566     0.150
     2.409    40.969     0.150
     2.578    43.270     0.150
     2.677    44.566     0.150
     2.893    48.297     0.150
     3.213    51.668     0.150
     3.571    56.867     0.150
     3.571    57.527     0.150
     4.034    63.367     0.150
     4.034    63.699     0.150
     4.101    64.668     0.150
     4.183    65.398     0.150
     4.189    64.867     0.150
     4.539    70.668     0.150
     4.535    69.469     0.150
     4.601    71.422     0.150
     4.601    86.164     0.150
     4.601   126.629     0.150
     4.601   150.801     0.150
     4.715    72.168     0.150
     4.865    74.840     0.150
     5.072    76.969     0.150
     5.072    76.777     0.150
     5.235    79.270     0.150
     5.707    86.668     0.150
     5.707    86.430     0.150
     5.779    87.566     0.150
     6.194    93.270     0.150
     6.227    93.367     0.150
     6.227    93.117     0.150
     6.269    94.328     0.150
     6.591    98.746     0.150
     6.661    99.867     0.150
     7.118   105.430     0.150
     7.164   107.969     0.150
     7.164   106.438     0.150
     7.892   153.398     0.150
    10.767   270.895     0.150
    12.624   178.074     0.150
    12.624   318.746     0.150
    12.624   179.508     0.150
    16.112   223.691     0.150
    16.112   398.867     0.150
    19.371   267.340     0.150
    19.548   268.164     0.150
    20.035   274.578     0.150
    23.157   307.961     0.150
    25.124   324.730     0.150
    28.713   357.742     0.150
    35.271   415.586     0.150
    36.485   424.855     0.150
    40.213   457.105     0.150
    41.083   463.887     0.150
    41.645   468.473     0.150
    51.807   548.391     0.150
    87.457   767.426     0.150
    89.433   776.707     0.150
     1.594    28.539     0.150
     1.842    31.938     0.150
     1.906    34.344     0.150
     2.347    40.344     0.150
     2.530    42.344     0.150
     2.703    45.141     0.150
     3.115    51.242     0.150
     3.332    53.438     0.150
     3.696    58.742     0.150
     3.922    62.438     0.150
     4.063    64.141     0.150
     4.108    64.938     0.150
     4.289    67.039     0.150
     4.535    70.844     0.150
     4.587    70.469     0.150
     4.587   150.664     0.150
     4.627    70.938     0.150
     4.822    74.242     0.150
     5.182    78.539     0.150
     5.700    82.562     0.150
     5.722    86.844     0.150
     5.822    87.938     0.150
     6.350    94.844     0.150
     6.309    94.641     0.150
     6.780   101.641     0.150
     6.994   102.969     0.150
     6.994   103.891     0.150
     8.751   126.750     0.150
     9.088   131.344     0.150
     9.852   141.594     0.150
    10.496   150.203     0.150
    10.643   152.164     0.150
    10.643   269.359     0.150
    10.643   152.367     0.150
    10.823   153.742     0.150
    11.959   169.070     0.150
    12.431   175.250     0.150
    12.500   178.586     0.150
    12.500   315.406     0.150
    12.500   177.102     0.150
    12.500   177.664     0.150
    12.500   315.922     0.150
    12.500   177.531     0.150
    13.937   195.688     0.150
    14.656   212.484     0.150
    14.656   208.961     0.150
    14.960   208.664     0.150
    14.854   212.336     0.150
    14.997   213.328     0.150
    15.994   222.633     0.150
    16.032   223.266     0.150
    16.032   395.039     0.150
    16.032   230.594     0.150
    17.631   247.766     0.150
    19.040   262.898     0.150
    19.247   263.781     0.150
    19.258   265.938     0.150
    19.423   266.516     0.150
    19.423   265.594     0.150
    19.911   272.812     0.150
    21.863   293.109     0.150
    23.199   308.242     0.150
    23.199   308.133     0.150
    25.000   323.766     0.150
    25.000   324.094     0.150
    28.713   357.859     0.150
    36.434   425.344     0.150
    40.958   463.688     0.150
    40.958   462.812     0.150
    51.839   547.641     0.150
    54.682   569.914     0.150
    73.925   695.812     0.150
    74.328   698.211     0.150
    75.909   706.867     0.150
    87.426   767.289     0.150
    89.409   776.188     0.150
     1.466    26.757     0.150
     1.466    47.257     0.150
     1.817    32.958     0.150
     2.269    39.357     0.150
     2.583    43.658     0.150
     2.564    43.357     0.150
     3.012    50.058     0.150
     3.176    51.458     0.150
     3.249    53.357     0.150
     3.841    61.658     0.150
     3.940    61.857     0.150
     4.007    63.458     0.150
     4.126    64.058     0.150
     4.446    69.257     0.150
     4.465    69.058     0.150
     4.509    70.658     0.150
     4.659    70.958     0.150
     5.200    79.058     0.150
     5.685    85.857     0.150
     5.750    87.558     0.150
     6.048    91.158     0.150
     6.151    92.458     0.150
     6.624    98.658     0.150
    10.768   153.475     0.150
    10.768   271.520     0.150
    12.643   179.427     0.150
    14.681   205.333     0.150
    14.681   364.198     0.150
    16.046   223.433     0.150
    16.046   222.884     0.150
    16.046   395.644     0.150
    19.339   265.632     0.150
    19.564   268.408     0.150
    20.029   273.933     0.150
    21.888   294.300     0.150
    23.065   307.607     0.150
    25.120   325.357     0.150
    41.085   463.582     0.150
    51.714   547.658     0.150
    87.550   767.308     0.150
     1.501    27.289     0.150
     1.501    48.390     0.150
     1.847    33.189     0.150
     2.297    39.589     0.150
     2.405    40.789     0.150
     2.616    43.989     0.150
     2.586    43.289     0.150
     3.045    49.989     0.150
     3.870    61.489     0.150
     3.976    63.289     0.150
     4.039    64.489     0.150
     4.161    64.890     0.150
     4.476    70.189     0.150
     4.501    69.589     0.150
     4.537    70.339     0.150
     4.671    71.890     0.150
     4.693    71.890     0.150
     6.068    91.390     0.150
     7.631   112.689     0.150
    10.750   153.650     0.150
    10.750   270.917     0.150
    14.690   205.114     0.150
    14.690   365.651     0.150
    16.057   226.104     0.150
    16.057   394.581     0.150
    19.541   266.640     0.150
    20.014   272.064     0.150
    23.102   305.489     0.150
    25.104   325.839     0.150
     1.554    28.117     0.150
     1.554    50.320     0.150
     1.783    31.418     0.150
     1.783    31.008     0.150
     1.883    34.020     0.150
     1.883    34.168     0.150
     2.014    35.258     0.150
     2.328    40.219     0.150
     2.472    42.020     0.150
     2.660    44.219     0.150
     2.647    44.320     0.150
     2.853    47.277     0.150
     3.086    50.418     0.150
     3.389    53.918     0.150
     3.641    57.617     0.150
     3.641    58.020     0.150
     3.902    61.918     0.150
     4.027    62.820     0.150
     4.027    63.297     0.150
     4.080    65.020     0.150
     4.224    65.000     0.150
     4.512    70.520     0.150
     4.568    72.168     0.150
     4.568   126.867     0.150
     4.570    70.719     0.150
     4.763    72.820     0.150
     4.841    74.598     0.150
     5.146    77.859     0.150
     5.296    79.820     0.150
     5.691    86.359     0.150
     5.843    88.617     0.150
     6.269    94.730     0.150
     6.250    94.117     0.150
     6.301    94.520     0.150
     6.301    94.238     0.150
     6.639   100.070     0.150
     7.232   107.578     0.150
    10.694   269.586     0.150
    14.676   212.559     0.150
    14.676   362.938     0.150
    16.048   225.219     0.150
    16.048   398.195     0.150
    16.048   393.254     0.150
    19.297   265.543     0.150
    19.479   267.246     0.150
    19.961   273.320     0.150
    23.158   308.570     0.150
    25.050   324.117     0.150
    36.478   425.820     0.150
    87.463   767.492     0.150
     1.590    28.877     0.150
     1.590    51.477     0.150
     1.590    29.026     0.150
     1.819    31.677     0.150
     1.910    34.276     0.150
     1.910    34.866     0.150
     2.026    35.967     0.150
     2.353    40.377     0.150
     2.507    42.177     0.150
     2.678    44.776     0.150
     2.692    44.776     0.150
     2.874    48.496     0.150
     3.117    51.177     0.150
     3.309    52.977     0.150
     3.353    53.776     0.150
     3.671    57.977     0.150
     3.928    62.776     0.150
     4.061    63.477     0.150
     4.061    63.267     0.150
     4.264    66.356     0.150
     4.271    66.177     0.150
     4.594    71.688     0.150
     4.594    84.712     0.150
     4.594   147.752     0.150
     4.781    73.276     0.150
     4.803    73.377     0.150
     4.869    74.677     0.150
     5.158    79.387     0.150
     5.332    80.877     0.150
     5.714    83.057     0.150
     5.723    86.776     0.150
     5.723    87.746     0.150
     5.797    87.576     0.150
     5.877    88.477     0.150
     6.155    92.477     0.150
     6.325    94.887     0.150
     6.288    94.276     0.150
     6.305    94.387     0.150
     6.501    92.496     0.150
     6.678   125.307     0.150
     6.757   101.477     0.150
     7.019   180.557     0.150
     7.019   103.946     0.150
     9.877   141.467     0.150
    10.521   148.937     0.150
    10.668   152.026     0.150
    10.847   154.177     0.150
    11.983   168.477     0.150
    12.454   175.557     0.150
    12.524   176.468     0.150
    12.524   313.971     0.150
    12.524   177.866     0.150
    13.961   196.347     0.150
    14.998   212.687     0.150
    16.018   224.137     0.150
    16.051   222.651     0.150
    16.051   392.698     0.150
    19.283   266.037     0.150
    19.448   266.297     0.150
    19.448   267.401     0.150
    19.937   273.151     0.150
    20.044   273.717     0.150
    22.105   294.696     0.150
    22.240   296.946     0.150
    23.194   310.091     0.150
    23.194   307.557     0.150
    25.026   324.776     0.150
    36.440   425.877     0.150
    36.440   424.106     0.150
    40.983   463.951     0.150
    40.983   463.156     0.150
    41.124   464.396     0.150
    87.428   767.651     0.150
     1.624    28.914     0.150
     1.624    29.027     0.150
     1.830    31.816     0.150
     1.945    35.016     0.150
     1.945    34.887     0.150
     2.057    35.805     0.150
     2.388    41.016     0.150
     2.517    42.117     0.150
     2.682    44.715     0.150
     2.727    45.516     0.150
     2.908    48.277     0.150
     3.321    53.414     0.150
     3.388    55.215     0.150
     3.430    54.715     0.150
     3.674    58.215     0.150
     3.674    58.484     0.150
     4.095    64.715     0.150
     4.146    65.215     0.150
     4.286    66.227     0.150
     4.293    66.414     0.150
     4.574    71.617     0.150
     4.628    72.289     0.150
     4.628   151.316     0.150
     4.635    71.316     0.150
     4.822    73.715     0.150
     4.904    76.215     0.150
     5.143    78.016     0.150
     5.343    80.715     0.150
     5.758    87.645     0.150
     5.800    87.617     0.150
     5.886    88.316     0.150
     6.156    92.617     0.150
     6.302    94.914     0.150
     6.338    95.766     0.150
     6.319    94.816     0.150
     6.319    94.957     0.150
     6.698   100.605     0.150
     6.769   100.816     0.150
     7.020   103.914     0.150
     7.211   108.457     0.150
    10.671   151.797     0.150
    10.671   268.191     0.150
    12.519   177.410     0.150
    12.519   178.125     0.150
    12.519   178.246     0.150
    14.701   205.582     0.150
    14.701   363.707     0.150
    16.077   223.066     0.150
    16.077   223.535     0.150
    16.077   394.543     0.150
    19.297   265.289     0.150
    19.444   265.566     0.150
    19.941   273.766     0.150
    21.908   294.785     0.150
    21.908   294.676     0.150
    23.227   309.414     0.150
    25.030   323.215     0.150
    36.213   422.707     0.150
    36.408   425.516     0.150
    40.985   463.539     0.150
    78.336   720.266     0.150
    87.394   766.965     0.150
    89.375   776.914     0.150
     1.590    28.812     0.150
     1.833    32.016     0.150
     1.833    31.695     0.150
     1.905    34.109     0.150
     1.905    34.211     0.150
     2.014    35.523     0.150
     2.346    40.211     0.150
     2.689    44.914     0.150
     2.866    47.633     0.150
     3.113    51.312     0.150
     3.078    49.609     0.150
     3.323    53.312     0.150
     3.438    54.609     0.150
     3.687    58.930     0.150
     3.921    62.414     0.150
     4.060    64.109     0.150
     4.060    64.250     0.150
     4.107    64.711     0.150
     4.274    66.883     0.150
     4.534    71.414     0.150
     4.587    71.914     0.150
     4.587   123.586     0.150
     4.587   146.672     0.150
     4.814    73.609     0.150
     4.864    74.969     0.150
     5.175    78.211     0.150
     5.175    78.469     0.150
     5.720    87.305     0.150
     5.813    88.109     0.150
     5.892    89.109     0.150
     6.171    92.516     0.150
     6.306    95.180     0.150
     6.301    94.312     0.150
     6.341    95.016     0.150
     6.341    95.172     0.150
     6.517    92.406     0.150
     6.689   100.133     0.150
     6.771   100.711     0.150
     7.002   103.461     0.150
     7.250   107.414     0.150
     7.250   108.531     0.150
    10.652   151.477     0.150
    12.509   176.078     0.150
    12.509   312.633     0.150
    12.509   176.188     0.150
    12.509   316.547     0.150
    12.509   176.703     0.150
    14.662   204.203     0.150
    14.662   363.039     0.150
    14.969   209.602     0.150
    16.037   223.039     0.150
    16.037   393.516     0.150
    16.037   222.539     0.150
    17.629   248.211     0.150
    18.260   254.250     0.150
    19.266   264.414     0.150
    19.266   474.336     0.150
    19.432   265.484     0.150
    19.920   272.172     0.150
    20.027   273.805     0.150
    21.868   294.156     0.150
    23.195   310.516     0.150
    25.009   324.734     0.150
    28.705   358.359     0.150
    28.712   358.742     0.150
    35.231   415.742     0.150
    35.304   415.555     0.150
    36.438   425.359     0.150
    40.967   463.539     0.150
    41.615   468.438     0.150
    52.254   552.164     0.150
    83.138   747.109     0.150
     1.490    28.062     0.150
     1.726    30.562     0.150
     1.726    30.743     0.150
     1.830    33.763     0.150
     1.988    34.963     0.150
     2.280    39.963     0.150
     2.378    40.062     0.150
     2.416    41.362     0.150
     2.602    43.862     0.150
     2.599    43.963     0.150
     2.811    47.303     0.150
     2.752    45.963     0.150
     3.030    49.862     0.150
     3.266    53.562     0.150
     3.337    53.562     0.150
     3.593    57.862     0.150
     3.593    57.373     0.150
     3.853    62.163     0.150
     3.964    62.862     0.150
     3.964    63.112     0.150
     4.024    64.362     0.150
     4.156    65.003     0.150
     4.163    65.062     0.150
     4.460    70.062     0.150
     4.520    70.737     0.150
     4.520    84.213     0.150
     4.520   147.088     0.150
     4.520    69.753     0.150
     4.501    69.663     0.150
     4.672    71.963     0.150
     4.697    72.463     0.150
     4.787    73.232     0.150
     5.132    77.562     0.150
     5.238    80.062     0.150
     5.632    86.263     0.150
     5.720    86.862     0.150
     5.787    87.963     0.150
     6.082    92.163     0.150
     6.203    93.272     0.150
     6.189    93.263     0.150
     6.267    93.963     0.150
     6.267    94.093     0.150
     6.572    98.522     0.150
     6.661   100.362     0.150
     7.089   104.782     0.150
     7.089   104.963     0.150
     6.993   104.263     0.150
     7.237   108.062     0.150
     7.237   107.303     0.150
     7.624   113.663     0.150
     8.861   129.603     0.150
     9.204   134.413     0.150
     9.955   143.603     0.150
     9.859   143.663     0.150
    10.600   151.732     0.150
    10.734   152.812     0.150
    10.734   270.151     0.150
    10.734   153.263     0.150
    10.734   153.333     0.150
    10.933   156.723     0.150
    12.607   179.057     0.150
    12.607   317.457     0.150
    12.607   179.902     0.150
    12.607   316.777     0.150
    12.607   179.263     0.150
    12.607   180.213     0.150
    13.422   191.062     0.150
    14.051   198.263     0.150
    14.668   208.583     0.150
    14.668   204.588     0.150
    14.668   363.056     0.150
    14.668   208.123     0.150
    14.755   212.731     0.150
    14.755   215.493     0.150
    14.910   212.303     0.150
    15.619   216.663     0.150
    16.035   223.263     0.150
    16.035   392.713     0.150
    16.035   392.284     0.150
    16.107   224.003     0.150
    17.257   243.362     0.150
    17.318   241.663     0.150
    17.318   245.562     0.150
    17.480   250.362     0.150
    17.553   248.062     0.150
    18.152   251.543     0.150
    18.152   251.373     0.150
    19.074   265.862     0.150
    19.315   265.263     0.150
    19.319   265.902     0.150
    19.319   266.183     0.150
    19.352   264.782     0.150
    19.528   269.362     0.150
    19.528   268.312     0.150
    19.528   266.423     0.150
    19.587   271.163     0.150
    19.997   274.463     0.150
    20.104   274.183     0.150
    20.104   277.062     0.150
    20.435   280.663     0.150
    20.977   287.362     0.150
    21.474   291.362     0.150
    21.875   294.456     0.150
    21.875   294.322     0.150
    21.875   294.562     0.150
    21.875   536.362     0.150
    22.213   299.133     0.150
    22.460   301.062     0.150
    23.092   307.383     0.150
    23.092   308.562     0.150
    23.092   307.862     0.150
    23.092   306.953     0.150
    23.092   309.163     0.150
    23.961   316.062     0.150
    25.088   325.487     0.150
    25.088   325.103     0.150
    25.360   329.362     0.150
    26.069   334.833     0.150
    26.990     2.000     0.150
    26.990   383.763     0.150
    28.634   356.763     0.150
    28.634   357.862     0.150
    28.634   358.663     0.150
    28.641   358.072     0.150
    35.189   415.933     0.150
    35.189   415.362     0.150
    35.410   416.214     0.150
    36.545   426.463     0.150
    36.545   426.923     0.150
    40.131   457.013     0.150
    40.270   458.707     0.150
    41.051   465.612     0.150
    41.051   464.583     0.150
    41.531   468.833     0.150
    41.542   469.272     0.150
    41.563   468.562     0.150
    41.563   468.538     0.150
    48.506   524.245     0.150
    51.738   548.438     0.150
    52.369   553.362     0.150
    71.864   682.612     0.150
    71.864   682.062     0.150
    87.526   767.763     0.150
    87.529   768.062     0.150
    89.505   777.612     0.150
   101.943   834.013     0.150
     1.558    28.734     0.150
     1.558    28.516     0.150
     1.799    31.539     0.150
     1.799    31.289     0.150
     1.881    33.938     0.150
     1.881    34.070     0.150
     2.006    35.336     0.150
     2.325    40.234     0.150
     2.487    41.836     0.150
     2.487    41.938     0.150
     2.663    44.836     0.150
     2.662    44.938     0.150
     2.849    47.750     0.150
     2.830    46.641     0.150
     3.087    50.336     0.150
     3.288    52.539     0.150
     3.323    53.938     0.150
     3.405    54.336     0.150
     3.656    57.836     0.150
     3.656    58.219     0.150
     3.900    62.336     0.150
     4.030    63.539     0.150
     4.030    63.188     0.150
     4.081    64.539     0.150
     4.236    66.109     0.150
     4.243    65.336     0.150
     4.511    70.836     0.150
     4.566    71.984     0.150
     4.566   147.711     0.150
     4.582    70.734     0.150
     4.776    73.039     0.150
     4.840    74.578     0.150
     5.160    78.234     0.150
     5.160    78.375     0.150
     5.311    80.734     0.150
     5.693    85.836     0.150
     5.782    87.234     0.150
     5.858    88.734     0.150
     6.142    92.539     0.150
     6.273    93.914     0.150
     6.317    94.641     0.150
     6.652    99.414     0.150
     7.031   102.609     0.150
     7.245   108.789     0.150
    10.679   151.859     0.150
    10.679   269.078     0.150
    12.540   176.633     0.150
    12.540   178.047     0.150
    12.540   314.250     0.150
    12.540   177.148     0.150
    14.821   210.508     0.150
    15.004   210.234     0.150
    16.037   223.734     0.150
    16.037   222.281     0.150
    16.037   394.727     0.150
    17.375   243.891     0.150
    18.999   264.141     0.150
    19.287   263.828     0.150
    19.287   265.898     0.150
    19.282   263.461     0.150
    19.287   265.461     0.150
    19.463   266.414     0.150
    19.463   266.609     0.150
    19.511   270.539     0.150
    19.945   272.234     0.150
    19.945   271.922     0.150
    20.359   277.836     0.150
    20.902   282.234     0.150
    21.871   292.953     0.150
    21.871   293.984     0.150
    23.162   308.391     0.150
    25.035   323.391     0.150
    28.683   357.852     0.150
    35.218   415.008     0.150
    36.277   423.727     0.150
    36.472   425.484     0.150
    40.994   464.109     0.150
    87.460   767.961     0.150
     1.436    26.726     0.150
     1.436    26.216     0.150
     1.436    46.726     0.150
     1.683    29.726     0.150
     1.683    29.376     0.150
     1.786    32.626     0.150
     1.786    32.466     0.150
     1.965    35.025     0.150
     2.238    39.025     0.150
     2.322    39.226     0.150
     2.373    40.226     0.150
     2.552    42.825     0.150
     2.564    43.126     0.150
     2.774    46.695     0.150
     2.703    44.825     0.150
     2.981    48.825     0.150
     3.217    53.226     0.150
     3.168    50.726     0.150
     3.297    52.626     0.150
     3.559    56.626     0.150
     3.559    56.365     0.150
     3.910    61.825     0.150
     3.910    62.056     0.150
     3.975    63.126     0.150
     4.101    63.615     0.150
     4.108    63.825     0.150
     4.415    69.025     0.150
     4.477    69.101     0.150
     4.477   142.575     0.150
     4.445    68.626     0.150
     4.616    71.325     0.150
     4.644    71.325     0.150
     4.740    73.916     0.150
     5.125    77.525     0.150
     5.125    78.405     0.150
     5.193    78.226     0.150
     5.582    84.825     0.150
     5.582    85.855     0.150
     5.685    86.025     0.150
     5.745    87.025     0.150
     5.882    85.936     0.150
     6.050    91.226     0.150
     6.148    92.016     0.150
     6.140    92.926     0.150
     6.244    93.226     0.150
     6.244    93.636     0.150
     6.520    97.626     0.150
     6.616    99.325     0.150
     7.121   105.485     0.150
     7.119   104.936     0.150
     7.245   109.775     0.150
     7.809   115.365     0.150
     8.119   119.226     0.150
     8.902   128.176     0.150
     9.248   133.336     0.150
     9.991   143.115     0.150
    10.637   151.716     0.150
    10.764   153.370     0.150
    10.764   269.880     0.150
    10.764   153.506     0.150
    10.873   156.745     0.150
    12.109   170.695     0.150
    12.645   179.170     0.150
    12.645   316.369     0.150
    12.645   178.855     0.150
    12.645   319.396     0.150
    12.645   178.964     0.150
    12.645   320.292     0.150
    12.645   180.485     0.150
    12.645   177.956     0.150
    13.462   191.896     0.150
    14.094   198.686     0.150
    14.658   205.136     0.150
    14.658   365.053     0.150
    14.658   205.315     0.150
    14.701   216.045     0.150
    14.861   210.436     0.150
    16.021   222.976     0.150
    16.021   222.056     0.150
    16.021   393.776     0.150
    17.269   242.126     0.150
    19.325   265.851     0.150
    19.389   264.256     0.150
    19.389   265.796     0.150
    19.565   268.450     0.150
    19.565   267.296     0.150
    20.023   274.176     0.150
    20.130   274.676     0.150
    20.130   275.516     0.150
    21.865   293.868     0.150
    21.865   293.376     0.150
    23.036   307.025     0.150
    23.036   306.846     0.150
    25.114   325.400     0.150
    25.114   325.216     0.150
    25.340   328.501     0.150
    28.589   356.426     0.150
    28.596   357.155     0.150
    33.937   403.716     0.150
    35.156   414.495     0.150
    38.670   451.226     0.150
    38.670   530.226     0.150
    41.081   463.501     0.150
    41.526   467.575     0.150
    46.701   510.056     0.150
    48.247   521.575     0.150
    48.463   522.141     0.150
    51.684   547.650     0.150
    52.420   553.075     0.150
    75.132   702.516     0.150
    87.580   768.176     0.150
    87.580   768.296     0.150
    87.583   768.126     0.150
    89.558   777.325     0.150
    89.558   778.495     0.150
     1.472    26.922     0.150
     1.472    46.922     0.150
     1.472    27.311     0.150
     1.709    29.922     0.150
     1.817    32.721     0.150
     1.817    33.121     0.150
     1.982    34.932     0.150
     2.267    39.320     0.150
     2.399    40.621     0.150
     2.586    43.422     0.150
     2.585    43.521     0.150
     2.800    47.221     0.150
     2.734    45.221     0.150
     3.014    49.621     0.150
     3.321    53.021     0.150
     3.579    56.820     0.150
     3.579    56.961     0.150
     3.840    61.422     0.150
     3.946    61.621     0.150
     3.946    62.650     0.150
     4.009    63.621     0.150
     4.136    64.352     0.150
     4.143    64.221     0.150
     4.446    69.021     0.150
     4.507    68.570     0.150
     4.507   144.621     0.150
     4.481    69.121     0.150
     4.652    71.721     0.150
     4.677    71.521     0.150
     4.772    73.971     0.150
     5.045    78.172     0.150
     5.126    76.820     0.150
     5.220    79.121     0.150
     5.616    85.621     0.150
     5.705    86.221     0.150
     6.069    91.422     0.150
     6.185    93.611     0.150
     6.170    92.922     0.150
     6.256    93.611     0.150
     6.553    98.582     0.150
     7.151   106.400     0.150
     7.237   106.201     0.150
     7.844   116.980     0.150
     8.156   119.922     0.150
    10.747   153.746     0.150
    10.747   271.686     0.150
    11.660   169.971     0.150
    12.622   178.314     0.150
    12.622   318.541     0.150
    12.622   178.689     0.150
    14.668   205.904     0.150
    14.668   362.189     0.150
    16.033   222.646     0.150
    16.033   393.297     0.150
    16.033   224.062     0.150
    16.033   394.381     0.150
    23.073   304.570     0.150
    35.180   413.602     0.150
    36.565   426.221     0.150
    51.720   547.445     0.150
    87.544   767.797     0.150
    89.522   777.771     0.150
     1.472    26.984     0.150
     1.472    47.285     0.150
     1.632    29.086     0.150
     1.845    33.285     0.150
     2.045    36.395     0.150
     2.301    39.785     0.150
     2.321    39.688     0.150
     2.350    40.086     0.150
     2.501    42.285     0.150
     2.600    43.484     0.150
     2.665    44.188     0.150
     2.843    47.508     0.150
     3.032    49.785     0.150
     3.121    50.285     0.150
     3.240    52.086     0.150
     3.268    53.484     0.150
     3.495    55.484     0.150
     3.871    61.984     0.150
     3.948    62.574     0.150
     4.027    63.586     0.150
     4.081    63.277     0.150
     4.087    63.285     0.150
     4.472    69.688     0.150
     4.539    71.285     0.150
     4.539   145.785     0.150
     4.600    70.887     0.150
     4.615    70.688     0.150
     4.795    74.777     0.150
     5.042    76.477     0.150
     5.144    77.785     0.150
     5.621    84.984     0.150
     5.628    86.387     0.150
     5.628    85.785     0.150
     5.692    85.984     0.150
     5.983    90.484     0.150
     6.168    92.586     0.150
     6.168    92.848     0.150
     6.178    93.688     0.150
     6.491    97.445     0.150
     6.569    98.688     0.150
     6.905   103.387     0.150
     7.086   104.637     0.150
     7.160   106.375     0.150
     7.188   106.316     0.150
     8.115   119.285     0.150
    10.834   153.953     0.150
    10.834   271.070     0.150
    12.704   179.953     0.150
    12.704   320.504     0.150
    12.704   179.512     0.150
    12.704   321.512     0.150
    14.742   207.727     0.150
    14.742   367.516     0.150
    16.105   224.461     0.150
    16.105   223.516     0.150
    16.105   395.207     0.150
    17.319   241.336     0.150
    18.058   250.258     0.150
    19.407   266.285     0.150
    19.450   266.887     0.150
    19.626   269.262     0.150
    20.096   275.086     0.150
    21.949   295.027     0.150
    21.949   294.527     0.150
    23.065   306.836     0.150
    25.187   325.910     0.150
    28.647   357.512     0.150
    35.229   415.188     0.150
    35.505   417.496     0.150
    36.580   426.035     0.150
    40.162   456.703     0.150
    41.151   464.352     0.150
    41.595   468.125     0.150
    51.720   547.656     0.150
    52.455   553.234     0.150
    87.545   767.484     0.150
    89.518   777.035     0.150
   127.656  1144.586     0.150
     1.582    28.918     0.150
     1.900    34.117     0.150
     2.342    40.316     0.150
     2.511    42.020     0.150
     2.684    44.617     0.150
     2.683    44.816     0.150
     2.855    46.719     0.150
     3.107    50.316     0.150
     3.312    53.520     0.150
     3.343    54.020     0.150
     3.428    54.316     0.150
     3.677    58.117     0.150
     3.917    62.418     0.150
     4.053    63.219     0.150
     4.101    64.816     0.150
     4.271    66.316     0.150
     4.529    71.020     0.150
     4.583    73.191     0.150
     4.583   148.594     0.150
     4.609    71.219     0.150
     4.803    73.816     0.150
     5.803    88.117     0.150
     5.881    89.020     0.150
     6.290    94.117     0.150
     6.333    94.520     0.150
    12.518   178.211     0.150
    19.928   272.719     0.150
    23.187   309.418     0.150
    25.018   324.719     0.150
    35.229   414.363     0.150
    36.447   425.418     0.150
    87.437   767.418     0.150
    89.419   776.230     0.150
     1.498    27.592     0.150
     1.695    29.892     0.150
     1.851    33.892     0.150
     2.022    35.562     0.150
     2.302    39.792     0.150
     2.382    39.792     0.150
     2.384    40.592     0.150
     2.564    43.092     0.150
     2.726    45.192     0.150
     2.837    47.352     0.150
     3.046    49.492     0.150
     3.184    50.892     0.150
     3.303    52.892     0.150
     3.558    56.592     0.150
     3.558    56.782     0.150
     3.973    62.892     0.150
     3.973    62.602     0.150
     4.040    64.192     0.150
     4.138    64.192     0.150
     4.144    64.292     0.150
     4.486    69.292     0.150
     4.542    70.792     0.150
     4.542    84.210     0.150
     4.542   121.085     0.150
     4.542   147.532     0.150
     4.655    71.192     0.150
     4.675    71.892     0.150
     4.805    74.262     0.150
     5.091    76.562     0.150
     5.207    79.192     0.150
     5.646    85.992     0.150
     5.684    85.892     0.150
     5.755    87.192     0.150
     6.208    92.962     0.150
     6.228    93.492     0.150
     6.551    98.042     0.150
     6.896   103.092     0.150
     6.966   103.392     0.150
     6.999   103.592     0.150
     7.147   106.102     0.150
     7.198   105.522     0.150
     7.621   112.892     0.150
     7.846   114.802     0.150
     8.165   119.892     0.150
    10.772   153.242     0.150
    10.772   271.165     0.150
    12.641   179.261     0.150
    12.641   320.036     0.150
    12.641   318.771     0.150
    14.763   211.236     0.150
    16.073   224.817     0.150
    16.073   395.317     0.150
    16.073   225.842     0.150
    16.073   394.419     0.150
    17.334   241.592     0.150
    18.122   250.652     0.150
    19.355   267.872     0.150
    19.563   269.927     0.150
    20.036   275.667     0.150
    21.913   294.382     0.150
    23.096   307.592     0.150
    25.126   325.182     0.150
    28.654   357.337     0.150
    35.218   415.722     0.150
    36.544   425.591     0.150
    40.157   456.930     0.150
    41.590   468.292     0.150
    41.590   468.067     0.150
    51.746   547.742     0.150
    52.394   554.357     0.150
     1.552    28.104     0.150
     1.552    50.303     0.150
     1.552    28.254     0.150
     1.800    31.303     0.150
     1.873    33.604     0.150
     1.873    33.473     0.150
     1.997    34.783     0.150
     2.317    39.904     0.150
     2.444    40.203     0.150
     2.489    41.703     0.150
     2.654    44.404     0.150
     2.666    44.504     0.150
     2.840    47.393     0.150
     2.830    46.303     0.150
     3.079    49.504     0.150
     3.315    53.604     0.150
     3.289    52.504     0.150
     3.407    54.104     0.150
     3.660    57.523     0.150
     3.892    61.904     0.150
     4.023    63.004     0.150
     4.023    63.193     0.150
     4.073    64.303     0.150
     4.235    65.514     0.150
     4.242    65.404     0.150
     4.502    70.004     0.150
     4.558    68.754     0.150
     4.558   146.229     0.150
     4.579    70.004     0.150
     4.750    72.904     0.150
     4.775    72.803     0.150
     4.832    74.283     0.150
     5.167    77.553     0.150
     5.312    80.303     0.150
     5.685    86.104     0.150
     5.748    84.004     0.150
     5.860    88.404     0.150
     6.146    92.203     0.150
     6.267    93.203     0.150
     6.265    94.203     0.150
     6.322    94.104     0.150
     6.322    94.514     0.150
     6.651    99.443     0.150
     7.026   103.094     0.150
     7.026   103.533     0.150
     7.070   105.104     0.150
     7.094   104.803     0.150
     7.249   107.404     0.150
     7.253   107.904     0.150
     7.942   117.484     0.150
     8.253   121.004     0.150
     8.278   121.303     0.150
     8.790   127.213     0.150
     9.130   131.893     0.150
     9.888   142.104     0.150
    10.533   149.664     0.150
    10.674   151.879     0.150
    10.674   267.430     0.150
    10.674   152.213     0.150
    10.862   153.713     0.150
    11.683   168.104     0.150
    12.537   175.523     0.150
    12.537   177.414     0.150
    12.537   175.668     0.150
    12.537   316.445     0.150
    12.537   178.334     0.150
    13.978   196.703     0.150
    14.222   200.104     0.150
    14.330   204.713     0.150
    14.656   205.305     0.150
    14.656   359.477     0.150
    14.814   210.898     0.150
    14.814   210.154     0.150
    14.960   212.383     0.150
    15.568   215.502     0.150
    16.028   221.479     0.150
    16.028   222.973     0.150
    16.028   392.248     0.150
    16.034   224.283     0.150
    17.367   239.654     0.150
    18.143   251.904     0.150
    18.226   251.793     0.150
    18.226   250.994     0.150
    19.275   264.328     0.150
    19.280   265.113     0.150
    19.284   263.684     0.150
    19.284   263.133     0.150
    19.284   265.543     0.150
    19.460   266.314     0.150
    19.460   265.447     0.150
    19.460   265.828     0.150
    19.940   272.504     0.150
    21.312   286.113     0.150
    21.777   293.104     0.150
    21.863   293.771     0.150
    21.863   293.383     0.150
    21.863   293.574     0.150
    22.196   297.852     0.150
    22.627   299.303     0.150
    22.627   322.434     0.150
    22.627   532.314     0.150
    22.627   548.074     0.150
    23.156   307.693     0.150
    23.156   308.404     0.150
    23.156   307.463     0.150
    25.030   324.729     0.150
    25.030   323.773     0.150
    28.675   357.904     0.150
    30.296   373.904     0.150
    30.341   372.564     0.150
    35.209   415.324     0.150
    35.336   416.203     0.150
    36.283   422.834     0.150
    36.283     3.859     0.150
    36.478   425.553     0.150
    36.478   425.203     0.150
    38.405   442.404     0.150
    39.010   446.123     0.150
    38.839   447.123     0.150
    40.159   457.041     0.150
    40.276   457.754     0.150
    40.990   463.178     0.150
    40.990   463.014     0.150
    41.558   468.094     0.150
    41.590   468.303     0.150
    41.590   468.404     0.150
    42.461   475.594     0.150
    43.069   480.883     0.150
    48.361   522.764     0.150
    48.545   523.328     0.150
    51.796   547.883     0.150
    51.798   547.703     0.150
    52.291   552.303     0.150
    71.923   681.654     0.150
    71.923   682.543     0.150
    74.218   696.934     0.150
    74.342   698.574     0.150
    74.898   701.084     0.150
    75.442   704.934     0.150
    75.925   706.973     0.150
    77.415   715.963     0.150
    78.078   719.324     0.150
    78.147   719.703     0.150
    78.311   720.254     0.150
    78.311   719.984     0.150
    78.366   721.234     0.150
    78.525   721.893     0.150
    80.659   733.393     0.150
    83.135   746.428     0.150
    87.467   767.428     0.150
    87.467   767.043     0.150
    87.469   767.504     0.150
    89.448   776.553     0.150
   124.484  1137.072     0.150
   147.053  1180.744     0.150
     1.558    28.836     0.150
     1.558    29.039     0.150
     1.808    31.836     0.150
     1.878    33.734     0.150
     1.878    34.500     0.150
     1.998    35.328     0.150
     2.451    41.141     0.150
     2.497    42.438     0.150
     2.674    44.836     0.150
     2.660    44.938     0.150
     2.838    46.836     0.150
     2.843    47.758     0.150
     3.085    50.734     0.150
     3.297    52.938     0.150
     3.321    53.734     0.150
     3.415    54.836     0.150
     3.667    58.234     0.150
     3.667    58.641     0.150
     3.896    62.039     0.150
     4.029    63.641     0.150
     4.078    65.234     0.150
     4.243    65.688     0.150
     4.250    65.641     0.150
     4.507    70.734     0.150
     4.562    70.836     0.150
     4.562    84.055     0.150
     4.562   146.289     0.150
     4.588    70.836     0.150
     4.759    72.438     0.150
     4.784    73.438     0.150
     4.837    74.977     0.150
     5.171    78.438     0.150
     5.320    80.734     0.150
     5.691    86.141     0.150
     5.691    86.695     0.150
     5.739    88.297     0.150
     5.739    88.430     0.150
     5.739    85.305     0.150
     5.739    87.641     0.150
     5.793    87.641     0.150
     5.816    89.883     0.150
     5.868    88.938     0.150
     6.002    90.141     0.150
     6.153    92.539     0.150
     6.274    94.336     0.150
     6.274    94.359     0.150
     6.328    94.938     0.150
     6.660    99.555     0.150
     6.745   101.438     0.150
     6.746   100.938     0.150
     6.968   104.039     0.150
     7.020   103.469     0.150
     7.020   182.156     0.150
     7.020   103.766     0.150
     7.020   103.336     0.150
     7.020   103.188     0.150
     7.026   104.734     0.150
     7.078   104.539     0.150
     7.102   105.539     0.150
     7.255   108.141     0.150
     7.257   107.438     0.150
     7.257   107.758     0.150
     7.520   111.039     0.150
     7.704   113.539     0.150
     7.816   114.625     0.150
     7.951   118.055     0.150
     8.106   119.438     0.150
     8.133   119.438     0.150
     8.262   121.141     0.150
     8.286   122.039     0.150
     8.314   122.141     0.150
     8.523   124.641     0.150
     8.616   126.641     0.150
     8.749   128.336     0.150
     8.783   127.867     0.150
     8.829   129.141     0.150
     8.943   131.047     0.150
     9.122   132.508     0.150
     9.156   132.461     0.150
     9.156   134.141     0.150
     9.311   134.539     0.150
     9.311   138.148     0.150
     9.311   138.258     0.150
     9.470   138.836     0.150
     9.538   140.234     0.150
     9.554   139.438     0.150
     9.554   139.938     0.150
     9.637   139.461     0.150
     9.717   140.055     0.150
     9.881   141.508     0.150
    10.011   146.898     0.150
    10.011   146.016     0.150
    10.052   147.195     0.150
    10.052   146.289     0.150
    10.178   147.141     0.150
    10.285   148.938     0.150
    10.285   149.156     0.150
    10.344   151.500     0.150
    10.525   149.797     0.150
    10.597   153.977     0.150
    10.603   154.289     0.150
    10.603   152.297     0.150
    10.607   154.961     0.150
    10.668   152.359     0.150
    10.668   267.789     0.150
    10.668   152.109     0.150
    10.854   153.367     0.150
    10.871   159.141     0.150
    10.919   156.570     0.150
    10.956   156.344     0.150
    10.956   156.984     0.150
    10.956   155.969     0.150
    10.956   159.219     0.150
    10.956   156.859     0.150
    10.956   158.258     0.150
    10.956   156.227     0.150
    10.992   159.906     0.150
    11.061   157.352     0.150
    11.061   157.180     0.150
    11.092   160.961     0.150
    11.145   161.680     0.150
    11.145   162.406     0.150
    11.248   163.469     0.150
    11.388   165.078     0.150
    11.415   165.039     0.150
    11.415   164.234     0.150
    11.562   167.500     0.150
    11.562   166.141     0.150
    11.607   168.414     0.150
    11.620   167.375     0.150
    11.640   165.102     0.150
    11.675   167.438     0.150
    11.675   296.938     0.150
    11.813   170.023     0.150
    11.814   171.266     0.150
    11.814   168.836     0.150
    11.894   172.141     0.150
    11.933   172.078     0.150
    11.933   171.625     0.150
    11.990   169.414     0.150
    12.047   174.141     0.150
    12.115   174.875     0.150
    12.101   174.812     0.150
    12.118   171.570     0.150
    12.299   176.773     0.150
    12.328   175.031     0.150
    12.321   177.336     0.150
    12.386   177.570     0.150
    12.455   179.250     0.150
    12.464   175.531     0.150
    12.530   176.953     0.150
    12.530   176.844     0.150
    12.530   316.680     0.150
    12.530   177.211     0.150
    12.530   177.531     0.150
    12.530   314.898     0.150
    12.530   177.086     0.150
    12.530   317.938     0.150
    12.530   178.391     0.150
    12.578   180.250     0.150
    12.634   181.883     0.150
    12.698   178.320     0.150
    12.748   182.438     0.150
    12.816   181.117     0.150
    12.877   183.898     0.150
    12.894   181.789     0.150
    12.924   185.938     0.150
    13.016   185.367     0.150
    13.016   186.719     0.150
    13.064   188.039     0.150
    13.157   188.281     0.150
    13.161   188.109     0.150
    13.184   187.938     0.150
    13.184   335.938     0.150
    13.196   189.258     0.150
    13.343   188.734     0.150
    13.360   187.539     0.150
    13.336   190.438     0.150
    13.372   190.977     0.150
    13.391   192.367     0.150
    13.393   193.016     0.150
    13.412   189.469     0.150
    13.430   190.836     0.150
    13.666   197.539     0.150
    13.679   193.547     0.150
    13.730   197.836     0.150
    13.749   197.836     0.150
    13.790   198.344     0.150
    13.824   195.250     0.150
    13.830   197.141     0.150
    13.853   196.062     0.150
    13.906   197.250     0.150
    13.911   197.805     0.150
    13.970   196.336     0.150
    14.008   199.539     0.150
    14.044   196.938     0.150
    14.044   351.234     0.150
    14.113   201.523     0.150
    14.158   201.438     0.150
    14.224   203.016     0.150
    14.382   202.461     0.150
    14.337   205.797     0.150
    14.388   201.750     0.150
    14.655   205.781     0.150
    14.655   203.164     0.150
    14.655   363.047     0.150
    14.655   207.078     0.150
    14.663   210.578     0.150
    14.721   209.539     0.150
    14.820   213.648     0.150
    14.820   209.906     0.150
    14.820   212.328     0.150
    14.820   212.586     0.150
    14.820   212.836     0.150
    14.820   213.281     0.150
    14.820   212.961     0.150
    14.937   209.234     0.150
    14.995   210.016     0.150
    14.995   210.414     0.150
    14.966   211.695     0.150
    15.131   216.750     0.150
    15.202   212.508     0.150
    15.451   218.109     0.150
    15.562   215.820     0.150
    15.562   382.883     0.150
    15.574   218.727     0.150
    15.713   220.094     0.150
    15.725   221.609     0.150
    15.754   223.047     0.150
    15.844   222.969     0.150
    15.844   222.391     0.150
    15.844   225.297     0.150
    15.899   225.469     0.150
    16.216   225.859     0.150
    16.027   223.031     0.150
    16.027   222.742     0.150
    16.028   222.641     0.150
    16.028   394.195     0.150
    16.028   392.555     0.150
    16.248   231.344     0.150
    16.185   226.117     0.150
    16.202   227.500     0.150
    16.317   231.641     0.150
    16.555   234.289     0.150
    16.814   235.836     0.150
    16.905   240.875     0.150
    16.926   238.094     0.150
    17.155   238.250     0.150
    17.155   241.836     0.150
    17.313   244.734     0.150
    17.372   241.875     0.150
    17.372   242.039     0.150
    17.440   246.656     0.150
    17.491   243.648     0.150
    17.534   244.539     0.150
    17.558   246.391     0.150
    17.582   246.414     0.150
    17.582   453.695     0.150
    17.607   244.625     0.150
    17.607   244.820     0.150
    17.607   245.211     0.150
    17.607   440.539     0.150
    17.607   243.484     0.150
    17.607   245.625     0.150
    17.634   247.641     0.150
    17.880   247.938     0.150
    17.880   455.539     0.150
    17.960   252.055     0.150
    18.053   251.656     0.150
    18.151   251.078     0.150
    18.191   251.188     0.150
    18.191   251.719     0.150
    18.234   252.164     0.150
    18.234   251.617     0.150
    18.234   252.008     0.150
    18.234   252.406     0.150
    18.234   256.477     0.150
    18.263   254.539     0.150
    18.495   256.734     0.150
    18.956   262.367     0.150
    18.997   262.141     0.150
    19.173   264.734     0.150
    19.173   481.039     0.150
    19.197   265.039     0.150
    19.277   264.609     0.150
    19.277   264.336     0.150
    19.277   263.805     0.150
    19.277   263.430     0.150
    19.277   265.141     0.150
    19.277   264.836     0.150
    19.271   264.023     0.150
    19.271   470.859     0.150
    19.276   264.461     0.150
    19.276   264.070     0.150
    19.382   269.297     0.150
    19.453   266.844     0.150
    19.453   266.156     0.150
    19.453   267.336     0.150
    19.453   266.734     0.150
    19.453   266.750     0.150
    19.453   266.305     0.150
    19.454   484.641     0.150
    19.509   267.641     0.150
    19.486   270.531     0.150
    19.486   270.680     0.150
    19.486   268.938     0.150
    19.783   271.734     0.150
    19.783   493.734     0.150
    19.934   272.484     0.150
    19.934   272.086     0.150
    20.041   274.680     0.150
    20.041   274.828     0.150
    20.041   274.234     0.150
    20.041   274.102     0.150
    20.041   274.539     0.150
    20.041   275.078     0.150
    20.117   275.305     0.150
    20.284   277.367     0.150
    20.357   276.336     0.150
    20.399   278.844     0.150
    20.532   279.516     0.150
    20.560   279.406     0.150
    20.900   282.234     0.150
    20.963   282.906     0.150
    20.963   283.148     0.150
    20.961   284.547     0.150
    20.934   284.180     0.150
    20.973   285.898     0.150
    20.973   284.219     0.150
    21.049   285.164     0.150
    21.146   284.734     0.150
    21.305   287.641     0.150
    21.395   288.336     0.150
    21.402   288.969     0.150
    21.411   290.039     0.150
    21.722   293.148     0.150
    21.769   293.438     0.150
    21.769   293.539     0.150
    21.862   294.430     0.150
    21.862   294.641     0.150
    21.862   293.984     0.150
    21.862   313.438     0.150
    21.862   532.438     0.150
    22.131   296.734     0.150
    22.176   297.836     0.150
    22.176   542.234     0.150
    22.205   297.492     0.150
    22.214   299.141     0.150
    22.214   297.820     0.150
    22.382   297.641     0.150
    22.391   300.664     0.150
    22.474   301.750     0.150
    22.622   322.828     0.150
    22.622   532.648     0.150
    22.622   548.047     0.150
    22.622   302.500     0.150
    22.917   306.195     0.150
    23.105   306.336     0.150
    23.176   307.797     0.150
    23.160   308.141     0.150
    23.163   307.648     0.150
    23.163   307.750     0.150
    23.163   308.234     0.150
    23.163   308.516     0.150
    23.163   306.812     0.150
    23.163   996.758     0.150
    23.163   307.438     0.150
    23.223   309.539     0.150
    23.373   567.969     0.150
    23.402   310.141     0.150
    23.471   311.797     0.150
    23.471   311.680     0.150
    23.471   311.438     0.150
    23.578   312.047     0.150
    23.578   311.219     0.150
    23.578   311.938     0.150
    23.653   312.039     0.150
    23.695   313.555     0.150
    23.702   313.938     0.150
    23.845   314.695     0.150
    23.822   315.070     0.150
    23.822   314.867     0.150
    23.822   314.070     0.150
    23.822   315.734     0.150
    23.887   315.641     0.150
    24.358   319.336     0.150
    24.398   319.719     0.150
    24.417   320.227     0.150
    24.568   322.414     0.150
    24.778   323.125     0.150
    25.048   325.977     0.150
    25.048   324.617     0.150
    25.048   326.086     0.150
    25.024   324.312     0.150
    25.024   325.125     0.150
    25.024   324.836     0.150
    25.024   324.570     0.150
    25.024   324.438     0.150
    25.024   325.039     0.150
    25.377   328.219     0.150
    25.362   328.453     0.150
    25.362   328.836     0.150
    25.363   329.516     0.150
    25.585   329.641     0.150
    25.585   330.484     0.150
    26.146   335.156     0.150
    26.440   337.055     0.150
    26.440   336.375     0.150
    26.644   339.734     0.150
    26.644   615.438     0.150
    26.756   342.102     0.150
    26.881   341.578     0.150
    27.017   343.641     0.150
    27.017   384.938     0.150
    27.017   343.094     0.150
    27.017   343.539     0.150
    27.017   343.344     0.150
    27.017     3.891     0.150
    27.335   347.141     0.150
    27.411   347.336     0.150
    27.437   348.172     0.150
    27.567   348.461     0.150
    27.567   348.203     0.150
    27.567   347.719     0.150
    27.567   348.938     0.150
    27.567   349.141     0.150
    27.628   349.984     0.150
    27.630   348.328     0.150
    27.803   350.570     0.150
    27.881   351.266     0.150
    27.881   351.836     0.150
    27.943   352.734     0.150
    27.951   353.492     0.150
    27.954   353.078     0.150
    28.037   352.344     0.150
    28.044   353.836     0.150
    28.070   354.578     0.150
    28.083   352.531     0.150
    28.223   355.992     0.150
    28.403   356.211     0.150
    28.637   358.141     0.150
    28.637     4.398     0.150
    28.662   358.438     0.150
    28.679   356.875     0.150
    28.679   546.789     0.150
    28.679   357.477     0.150
    28.679   547.070     0.150
    28.679   358.539     0.150
    28.679   358.234     0.150
    28.686   358.508     0.150
    28.686   357.836     0.150
    28.686     4.398     0.150
    28.686   358.656     0.150
    28.686   358.773     0.150
    28.690   358.641     0.150
    28.746   359.719     0.150
    28.733   359.297     0.150
    28.733   359.781     0.150
    28.737   359.039     0.150
    28.742   359.953     0.150
    28.744   359.141     0.150
    28.799   358.852     0.150
    28.849   361.758     0.150
    28.886   361.750     0.150
    28.904   361.500     0.150
    28.963   362.836     0.150
    28.978   362.430     0.150
    28.978   363.039     0.150
    28.982   362.875     0.150
    28.984   362.641     0.150
    29.062   361.688     0.150
    29.028   362.938     0.150
    29.028   362.883     0.150
    29.125   363.820     0.150
    29.220   363.391     0.150
    29.290   365.078     0.150
    29.300   364.141     0.150
    29.300     4.094     0.150
    29.327   363.750     0.150
    29.339   365.227     0.150
    29.381   365.891     0.150
    29.395   365.297     0.150
    29.407   366.758     0.150
    29.457   367.375     0.150
    29.457   364.844     0.150
    29.457   366.836     0.150
    29.605   366.078     0.150
    29.605   365.539     0.150
    29.605   365.438     0.150
    29.606   367.062     0.150
    29.720   369.016     0.150
    29.735   366.195     0.150
    30.010   371.633     0.150
    30.073   371.641     0.150
    30.138   372.406     0.150
    30.187   373.336     0.150
    30.168   371.977     0.150
    30.287   373.938     0.150
    30.287   432.438     0.150
    30.329   373.938     0.150
    30.329   374.039     0.150
    30.346   372.227     0.150
    30.346   373.641     0.150
    30.354   374.211     0.150
    30.369   372.148     0.150
    30.533   376.008     0.150
    30.809   378.758     0.150
    30.821   378.023     0.150
    30.977   378.656     0.150
    30.977   439.094     0.150
    30.977   684.227     0.150
    30.977   785.750     0.150
    31.167   379.961     0.150
    31.167   379.750     0.150
    31.167   378.305     0.150
    31.164   381.641     0.150
    31.185   382.359     0.150
    31.332   382.312     0.150
    31.344   382.180     0.150
    31.377   382.570     0.150
    31.578   385.484     0.150
    31.592   384.250     0.150
    31.623   385.938     0.150
    31.623   385.609     0.150
    31.701   385.320     0.150
    31.735   384.438     0.150
    31.763   387.484     0.150
    31.804   385.266     0.150
    31.804   384.484     0.150
    31.864   386.656     0.150
    31.872   387.719     0.150
    31.872   387.836     0.150
    32.157   390.938     0.150
    32.150   389.992     0.150
    32.213   389.602     0.150
    32.213   387.227     0.150
    32.299   391.156     0.150
    32.338   392.102     0.150
    32.356   391.469     0.150
    32.449   390.008     0.150
    32.449   389.609     0.150
    32.491   392.805     0.150
    32.504   393.625     0.150
    32.517   393.391     0.150
    32.517   393.539     0.150
    32.527   393.961     0.150
    32.535   393.164     0.150
    32.535   392.336     0.150
    32.593   394.336     0.150
    32.727   458.734     0.150
    32.880   395.234     0.150
    33.081   398.125     0.150
    33.231   397.984     0.150
    33.231   398.352     0.150
    33.310   397.359     0.150
    33.310   397.039     0.150
    33.371   399.758     0.150
    33.371   399.938     0.150
    33.420   400.695     0.150
    33.420   399.797     0.150
    33.420   400.539     0.150
    33.534   399.680     0.150
    33.534   399.477     0.150
    33.594   403.469     0.150
    33.658   401.039     0.150
    33.658   400.500     0.150
    33.795   402.984     0.150
    33.795   561.219     0.150
    33.795   403.234     0.150
    33.827   402.016     0.150
    33.891   404.438     0.150
    33.879   406.305     0.150
    33.920   406.039     0.150
    33.920   405.727     0.150
    33.920   404.188     0.150
    33.956   405.836     0.150
    34.071   407.156     0.150
    34.087   404.766     0.150
    34.087   405.938     0.150
    34.087   405.750     0.150
    34.193   408.719     0.150
    34.193   408.375     0.150
    34.193   407.070     0.150
    34.193   407.938     0.150
    34.193   408.867     0.150
    34.197   407.406     0.150
    34.340   408.711     0.150
    34.340   409.008     0.150
    34.340   407.555     0.150
    34.373   409.836     0.150
    34.454   408.711     0.150
    34.607   410.945     0.150
    34.607   410.594     0.150
    34.701   409.938     0.150
    34.683   411.711     0.150
    34.837   412.859     0.150
    34.959   414.125     0.150
    34.966   415.234     0.150
    34.977   414.039     0.150
    35.055   414.234     0.150
    35.108   414.961     0.150
    35.171   416.180     0.150
    35.211   415.102     0.150
    35.211   415.641     0.150
    35.282   416.836     0.150
    35.328   416.086     0.150
    35.328   565.219     0.150
    35.335   416.641     0.150
    35.341   417.141     0.150
    35.327   417.625     0.150
    35.432   418.336     0.150
    35.467   418.961     0.150
    35.467   418.734     0.150
    35.506   419.766     0.150
    35.506   419.406     0.150
    35.578   419.508     0.150
    35.578   418.531     0.150
    35.592   419.391     0.150
    35.627   420.438     0.150
    35.706   420.797     0.150
    35.706   421.141     0.150
    35.706   420.633     0.150
    35.713   421.047     0.150
    35.713   420.836     0.150
    35.772   421.039     0.150
    35.772   421.930     0.150
    35.772   421.344     0.150
    35.772   419.555     0.150
    35.914   422.781     0.150
    36.103   422.281     0.150
    36.103   422.469     0.150
    36.103   421.328     0.150
    36.134   424.336     0.150
    36.139   423.648     0.150
    36.234   425.430     0.150
    36.234   425.641     0.150
    36.276   424.039     0.150
    36.276   424.734     0.150
    36.280   424.078     0.150
    36.297   424.734     0.150
    36.297   766.234     0.150
    36.261   425.250     0.150
    36.301   424.664     0.150
    36.312   425.711     0.150
    36.312   568.477     0.150
    36.364   426.266     0.150
    36.364   426.156     0.150
    36.471   425.820     0.150
    36.471   425.219     0.150
    36.471   426.578     0.150
    36.471   425.570     0.150
    36.471   568.250     0.150
    36.471   424.594     0.150
    36.471   568.977     0.150
    36.440   427.758     0.150
    36.485   425.938     0.150
    36.503   426.438     0.150
    36.492   427.180     0.150
    36.509   427.539     0.150
    36.509   427.094     0.150
    36.563   428.664     0.150
    36.620   428.156     0.150
    36.620   568.672     0.150
    36.649   429.086     0.150
    36.649   428.914     0.150
    36.658   429.305     0.150
    36.658   429.539     0.150
    36.689   428.289     0.150
    36.764   430.234     0.150
    36.764   430.734     0.150
    36.770   429.250     0.150
    36.770   429.430     0.150
    36.770   428.398     0.150
    36.770   429.539     0.150
    36.780   430.758     0.150
    36.780   430.539     0.150
    36.793   429.664     0.150
    36.808   429.188     0.150
    36.809   430.086     0.150
    36.809   428.500     0.150
    36.809   570.148     0.150
    36.810   430.039     0.150
    36.821   429.398     0.150
    36.826   427.836     0.150
    36.826   511.938     0.150
    36.848   430.500     0.150
    36.870   429.945     0.150
    36.961   431.555     0.150
    36.961   571.133     0.150
    37.079   432.008     0.150
    37.123   432.664     0.150
    37.123   570.719     0.150
    37.262   433.539     0.150
    37.352   433.977     0.150
    37.452   435.586     0.150
    37.455   436.086     0.150
    37.481   434.523     0.150
    37.481   435.141     0.150
    37.481   435.336     0.150
    37.481   435.641     0.150
    37.659   436.969     0.150
    37.688   437.164     0.150
    37.697   435.789     0.150
    37.697   436.141     0.150
    37.714   437.734     0.150
    37.737   438.297     0.150
    37.836   438.609     0.150
    37.917   439.438     0.150
    37.910   438.844     0.150
    37.958   439.695     0.150
    37.998   440.836     0.150
    38.024   439.656     0.150
    38.077   440.391     0.150
    38.080   440.781     0.150
    38.108   440.484     0.150
    38.105   440.539     0.150
    38.107   440.805     0.150
    38.116   440.969     0.150
    38.116   440.734     0.150
    38.116   572.914     0.150
    38.132   441.109     0.150
    38.132   440.367     0.150
    38.168   441.688     0.150
    38.215   441.336     0.150
    38.215   441.438     0.150
    38.238   440.914     0.150
    38.260   442.391     0.150
    38.289   442.484     0.150
    38.289   442.359     0.150
    38.332   442.891     0.150
    38.354   441.484     0.150
    38.396   442.438     0.150
    38.396   799.438     0.150
    38.420   443.844     0.150
    38.420   443.703     0.150
    38.431   443.594     0.150
    38.554   443.969     0.150
    38.632   445.320     0.150
    38.675   444.609     0.150
    38.675   445.414     0.150
    38.749   446.023     0.150
    38.749   574.766     0.150
    38.766   446.430     0.150
    38.766   445.836     0.150
    38.766     3.703     0.150
    38.766   535.438     0.150
    38.766   575.141     0.150
    38.766   802.438     0.150
    38.766   974.438     0.150
    38.858   446.898     0.150
    38.858   575.672     0.150
    38.911   447.008     0.150
    39.003   447.117     0.150
    39.023   449.281     0.150
    39.023   449.539     0.150
    39.028   449.234     0.150
    38.831   447.938     0.150
    39.114   448.984     0.150
    39.175   448.234     0.150
    39.147   449.969     0.150
    39.167   449.836     0.150
    39.224   451.695     0.150
    39.386   452.117     0.150
    39.456   451.555     0.150
    39.456   577.859     0.150
    39.460   452.078     0.150
    39.473   452.305     0.150
    39.488   452.805     0.150
    39.497   451.523     0.150
    39.497   577.641     0.150
    39.514   452.594     0.150
    39.525   453.469     0.150
    39.551   453.547     0.150
    39.559   453.000     0.150
    39.559   452.719     0.150
    39.583   453.938     0.150
    39.637   454.008     0.150
    39.652   453.891     0.150
    39.704   454.031     0.150
    39.704   453.984     0.150
    39.720   454.016     0.150
    39.722   454.680     0.150
    39.748   453.547     0.150
    39.748   579.016     0.150
    39.782   455.500     0.150
    39.783   455.445     0.150
    39.818   453.930     0.150
    39.818   579.281     0.150
    39.851   455.164     0.150
    39.883   455.781     0.150
    39.945   455.578     0.150
    39.960   456.406     0.150
    39.966   456.258     0.150
    40.031   455.438     0.150
    40.031   456.859     0.150
    40.031   456.961     0.150
    40.031   456.555     0.150
    40.049   456.047     0.150
    40.049   580.164     0.150
    40.084   457.164     0.150
    40.078   456.430     0.150
    40.078   580.742     0.150
    40.162   457.812     0.150
    40.277   458.945     0.150
    40.277   458.734     0.150
    40.277   457.883     0.150
    40.277   549.195     0.150
    40.277   579.008     0.150
    40.277   458.047     0.150
    40.285   458.734     0.150
    40.311   458.836     0.150
    40.311   555.234     0.150
    40.311   586.438     0.150
    40.287   459.086     0.150
    40.362   459.469     0.150
    40.408   459.977     0.150
    40.449   460.844     0.150
    40.490   460.039     0.150
    40.557   461.359     0.150
    40.574   461.141     0.150
    40.651   461.289     0.150
    40.651   582.156     0.150
    40.652   461.305     0.150
    40.680   463.391     0.150
    40.685   463.117     0.150
    40.984   464.039     0.150
    40.984   463.148     0.150
    41.037   465.586     0.150
    41.046   464.531     0.150
    41.105   466.438     0.150
    41.105   839.734     0.150
    41.092   465.617     0.150
    41.092   464.555     0.150
    41.138   467.195     0.150
    41.288   466.180     0.150
    41.288   465.469     0.150
    41.289   466.547     0.150
    41.302   466.938     0.150
    41.357   467.156     0.150
    41.400   467.336     0.150
    41.470   468.828     0.150
    41.487   469.266     0.150
    41.510   469.664     0.150
    41.547   469.258     0.150
    41.561   468.156     0.150
    41.578   468.688     0.150
    41.589   470.500     0.150
    41.593   468.938     0.150
    41.593   468.438     0.150
    41.593   469.039     0.150
    41.593   468.938     0.150
    41.638   469.625     0.150
    41.697   469.086     0.150
    41.697   468.219     0.150
    41.661   469.609     0.150
    41.671   469.719     0.150
    41.672   469.570     0.150
    41.672   469.805     0.150
    41.672   468.664     0.150
    41.672   469.938     0.150
    41.710   470.969     0.150
    41.776   470.914     0.150
    41.829   471.156     0.150
    41.829   470.141     0.150
    41.875   471.820     0.150
    42.005   472.328     0.150
    42.034   471.438     0.150
    42.034   472.469     0.150
    42.034   472.969     0.150
    42.089   474.281     0.150
    42.186   475.234     0.150
    42.186   857.938     0.150
    42.186  1073.234     0.150
    42.185   474.375     0.150
    42.227   474.586     0.150
    42.262   475.148     0.150
    42.340   475.484     0.150
    42.360   476.648     0.150
    42.415   476.430     0.150
    42.448   475.906     0.150
    42.458   476.000     0.150
    42.458   476.422     0.150
    42.470   477.734     0.150
    42.474   476.625     0.150
    42.513   475.734     0.150
    42.491   476.586     0.150
    42.510   476.938     0.150
    42.544   477.250     0.150
    42.544   475.969     0.150
    42.544   588.070     0.150
    42.544   587.531     0.150
    42.544   477.383     0.150
    42.544   477.039     0.150
    42.544   477.617     0.150
    42.560   477.516     0.150
    42.598   477.805     0.150
    42.626   478.117     0.150
    42.628   477.969     0.150
    42.641   477.820     0.150
    42.659   478.266     0.150
    42.664   478.555     0.150
    42.704   477.609     0.150
    42.666   479.141     0.150
    42.671   478.438     0.150
    42.671   478.148     0.150
    42.775   479.945     0.150
    42.849   479.797     0.150
    42.849   479.734     0.150
    42.945   480.539     0.150
    42.993   480.891     0.150
    43.007   481.547     0.150
    43.074   483.156     0.150
    43.074   481.484     0.150
    43.152   483.258     0.150
    43.152   577.766     0.150
    43.166   482.484     0.150
    43.189   482.008     0.150
    43.189   482.250     0.150
    43.189   482.141     0.150
    43.189   482.508     0.150
    43.398   483.766     0.150
    43.394   484.469     0.150
    43.493   484.234     0.150
    43.559   486.805     0.150
    43.564   486.617     0.150
    43.659   487.070     0.150
    43.659   487.367     0.150
    43.665   486.547     0.150
    43.818   487.438     0.150
    43.950   488.328     0.150
    43.999   489.625     0.150
    44.000   489.375     0.150
    44.068   490.469     0.150
    44.068   589.945     0.150
    44.172   490.227     0.150
    44.204   489.320     0.150
    44.204   593.648     0.150
    44.204   490.320     0.150
    44.214   491.289     0.150
    44.276   491.586     0.150
    44.353   492.438     0.150
    44.360   492.211     0.150
    44.492   492.781     0.150
    44.492   492.984     0.150
    44.492     2.820     0.150
    44.496   493.234     0.150
    44.619   493.844     0.150
    44.662   494.336     0.150
    44.770   494.078     0.150
    44.951   494.438     0.150
    44.951   895.938     0.150
    45.740   502.727     0.150
    45.740   501.836     0.150
    45.740   502.539     0.150
    45.740   503.055     0.150
    46.115   504.805     0.150
    46.113   504.820     0.150
    46.436   508.141     0.150
    46.738   508.141     0.150
    46.738   507.930     0.150
    46.868   510.664     0.150
    46.868   510.211     0.150
    46.868   509.500     0.150
    46.918   510.734     0.150
    46.933   512.461     0.150
    46.950   512.734     0.150
    46.950   926.438     0.150
    47.092   513.461     0.150
    47.141   513.938     0.150
    47.141   927.438     0.150
    47.161   514.719     0.150
    47.478   515.617     0.150
    47.619   517.398     0.150
    47.619   516.914     0.150
    47.714   517.422     0.150
    47.714   604.812     0.150
    47.733   518.336     0.150
    47.826   519.508     0.150
    47.826   518.594     0.150
    47.913   519.438     0.150
    47.913   939.438     0.150
    47.887   518.711     0.150
    48.016   520.867     0.150
    48.197   521.969     0.150
    48.366   523.391     0.150
    48.549   523.875     0.150
    48.549   608.016     0.150
    48.549   523.219     0.150
    48.562   525.445     0.150
    48.562   525.180     0.150
    48.576   524.945     0.150
    48.576   523.727     0.150
    48.576   525.734     0.150
    48.578   524.977     0.150
    48.716   525.391     0.150
    48.752   526.141     0.150
    48.752   525.117     0.150
    48.839   526.438     0.150
    48.870   527.477     0.150
    48.870   526.016     0.150
    48.870   526.977     0.150
    48.870     4.414     0.150
    48.870   527.336     0.150
    49.073   528.734     0.150
    49.175   529.336     0.150
    49.242   528.961     0.150
    49.375   531.469     0.150
    49.643   532.445     0.150
    49.643   532.289     0.150
    49.643   531.258     0.150
    49.643   531.836     0.150
    49.643     3.133     0.150
    49.643   532.141     0.150
    49.643     3.695     0.150
    49.643   961.641     0.150
    49.643   972.641     0.150
    49.643  1122.836     0.150
    49.753   533.359     0.150
    49.813   534.234     0.150
    50.201   536.648     0.150
    50.201   536.117     0.150
    50.290   537.328     0.150
    50.414   538.891     0.150
    50.414   539.008     0.150
    50.414   538.367     0.150
    50.495   539.688     0.150
    50.498   539.375     0.150
    50.797   540.375     0.150
    50.797   539.586     0.150
    51.056   544.305     0.150
    51.117   543.281     0.150
    51.567   546.734     0.150
    51.817   549.891     0.150
    51.817   550.188     0.150
    51.830   549.797     0.150
    51.803   547.977     0.150
    51.803   549.359     0.150
    51.804   548.492     0.150
    51.804   620.672     0.150
    51.804   548.211     0.150
    51.804   621.164     0.150
    51.868   550.680     0.150
    51.868   550.453     0.150
    51.868   548.930     0.150
    52.017   550.641     0.150
    52.126   551.805     0.150
    52.126   550.734     0.150
    52.126   550.930     0.150
    52.126   551.406     0.150
    52.126   551.117     0.150
    52.223   551.734     0.150
    52.223   551.625     0.150
    52.283   552.492     0.150
    52.283   551.664     0.150
    52.297   552.539     0.150
    52.301   552.734     0.150
    52.283   552.531     0.150
    52.283   622.094     0.150
    52.709   555.727     0.150
    52.915   558.438     0.150
    53.041   557.211     0.150
    53.332   559.734     0.150
    53.334   559.438     0.150
    53.334   559.797     0.150
    53.334   559.297     0.150
    53.346   560.141     0.150
    53.557   561.836     0.150
    54.218   567.609     0.150
    54.283   567.391     0.150
    54.433   568.484     0.150
    54.433   568.641     0.150
    54.645   569.430     0.150
    54.731   570.656     0.150
    54.749   570.031     0.150
    54.901   572.828     0.150
    55.153   573.836     0.150
    55.233   573.539     0.150
    55.233   573.664     0.150
    55.233   572.430     0.150
    55.233   575.336     0.150
    55.309   574.539     0.150
    55.793   579.461     0.150
    55.793   577.945     0.150
    55.793   579.039     0.150
    55.851   578.148     0.150
    55.851   576.219     0.150
    56.076   580.445     0.150
    56.358   582.727     0.150
    56.381   583.438     0.150
    56.525   583.008     0.150
    56.551   583.469     0.150
    58.252   594.180     0.150
    58.252   594.969     0.150
    58.252   594.578     0.150
    58.156   595.570     0.150
    58.422   597.438     0.150
    59.207   601.141     0.150
    59.207   603.000     0.150
    59.207   602.250     0.150
    59.207   602.008     0.150
    59.207   602.398     0.150
    59.207     3.602     0.150
    59.727   606.141     0.150
    59.727  1099.039     0.150
    59.727   605.633     0.150
    59.727   604.766     0.150
    59.727   605.734     0.150
    59.727     3.586     0.150
    59.891   607.938     0.150
    59.911   606.906     0.150
    59.911   605.914     0.150
    59.985   608.609     0.150
    59.985   607.336     0.150
    59.985   608.734     0.150
    59.985     4.180     0.150
    60.068   608.367     0.150
    60.068   608.742     0.150
    60.189   608.938     0.150
    60.189   610.445     0.150
    60.334   608.641     0.150
    60.334   609.039     0.150
    60.336   609.234     0.150
    60.336   608.586     0.150
    60.356   609.938     0.150
    60.356   611.250     0.150
    60.783   612.711     0.150
    61.773   619.039     0.150
    61.773   621.867     0.150
    63.384   630.336     0.150
    63.384   630.867     0.150
    63.384   631.117     0.150
    63.384   630.648     0.150
    63.957   633.750     0.150
    63.957   633.602     0.150
    63.957   632.891     0.150
    64.108   635.125     0.150
    64.652   638.508     0.150
    65.597   645.391     0.150
    65.597   645.008     0.150
    66.220   647.539     0.150
    66.232   648.336     0.150
    66.689   651.391     0.150
    66.689   651.812     0.150
    66.689   650.828     0.150
    66.689   651.914     0.150
    66.772   651.430     0.150
    66.845   653.781     0.150
    66.845   651.867     0.150
    67.295   654.930     0.150
    67.295   654.281     0.150
    67.295   655.336     0.150
    67.295   655.055     0.150
    67.295     3.484     0.150
    67.968   659.844     0.150
    67.968   660.016     0.150
    68.262   661.961     0.150
    68.262   662.102     0.150
    68.262   661.266     0.150
    68.262   662.211     0.150
    68.262     2.680     0.150
    68.610   664.320     0.150
    68.713   664.484     0.150
    68.713   664.609     0.150
    68.713     3.422     0.150
    69.379   668.391     0.150
    69.379   668.242     0.150
    69.379   668.141     0.150
    70.158   672.164     0.150
    69.989   671.688     0.150
    71.929   683.641     0.150
    71.929   683.297     0.150
    71.929   683.039     0.150
    72.726   687.969     0.150
    73.479   692.781     0.150
    73.479   692.094     0.150
    73.526   694.125     0.150
    73.594   694.367     0.150
    73.626   694.320     0.150
    74.338   699.523     0.150
    74.583   699.000     0.150
    74.583   698.781     0.150
    75.483   705.219     0.150
    75.483   704.539     0.150
    75.921   707.164     0.150
    75.925   707.281     0.150
    76.225   709.734     0.150
    76.666   712.406     0.150
    78.043   720.320     0.150
    78.043   720.195     0.150
    78.043   718.914     0.150
    78.043   719.734     0.150
    78.307   720.836     0.150
    78.307   720.070     0.150
    78.686   723.516     0.150
    79.209   726.617     0.150
    79.965   729.711     0.150
    79.965   728.945     0.150
    80.131   731.492     0.150
    80.663   733.508     0.150
    80.663   733.781     0.150
    80.736   734.180     0.150
    81.123   734.695     0.150
    81.582   738.031     0.150
    83.133   746.625     0.150
    83.133   746.938     0.150
    83.183   746.289     0.150
    83.391   748.867     0.150
    83.437   749.711     0.150
    83.993   751.039     0.150
    84.787   754.258     0.150
    85.768   758.773     0.150
    86.022   762.547     0.150
    86.375   762.969     0.150
    86.376   764.695     0.150
    86.484   762.797     0.150
    86.484   763.195     0.150
    86.622   764.000     0.150
    87.460   767.797     0.150
    87.460   767.758     0.150
    87.463   767.836     0.150
    87.463   767.961     0.150
    87.463   767.398     0.150
    89.442   777.477     0.150
    89.442   776.852     0.150
    89.442  1074.164     0.150
    89.442   776.719     0.150
    89.442  1074.430     0.150
    89.909   780.188     0.150
    89.909   779.461     0.150
    89.909   780.641     0.150
    89.975   779.805     0.150
    89.975   778.594     0.150
    91.267   784.930     0.150
    91.765   787.820     0.150
    93.223   794.328     0.150
    93.971   799.031     0.150
    95.078   803.719     0.150
    96.482   810.609     0.150
    96.584   810.758     0.150
    97.429   815.164     0.150
    99.584   824.156     0.150
   102.552  1794.133     0.150
   114.929  1121.305     0.150
   114.929  1177.797     0.150
   116.387  1121.391     0.150
   116.387  1122.461     0.150
   120.172  1132.648     0.150
   123.859  1138.195     0.150
   124.486  1138.508     0.150
   124.486  1137.594     0.150
   124.486  1137.930     0.150
   124.836  1139.234     0.150
   125.750  1139.680     0.150
   125.750  1141.211     0.150
   126.331  1140.961     0.150
   126.706  1142.961     0.150
   127.144  1140.195     0.150
   127.215  1145.797     0.150
   127.215  1143.836     0.150
   127.814  1144.266     0.150
   127.814  1145.734     0.150
   128.571  1146.430     0.150
   128.571  1147.477     0.150
   128.657  1147.859     0.150
   131.983  1155.734     0.150
   131.983  1154.023     0.150
   131.983  1154.180     0.150
   131.983  1155.016     0.150
   134.324  1161.055     0.150
   136.052  1162.945     0.150
   136.218  1162.047     0.150
   142.406  1171.953     0.150
   142.406  1172.578     0.150
   142.406  1174.156     0.150
   144.769  1175.766     0.150
     1.416    26.070     0.150
     1.416    45.971     0.150
     1.416    26.701     0.150
     1.416    46.332     0.150
     1.608    28.570     0.150
     1.608    28.791     0.150
     1.608    51.592     0.150
     1.791    32.371     0.150
     2.004    35.291     0.150
     2.249    39.070     0.150
     2.295    38.871     0.150
     2.298    39.172     0.150
     2.488    41.871     0.150
     2.544    42.771     0.150
     2.633    43.672     0.150
     2.977    48.771     0.150
     3.213    53.070     0.150
     3.222    51.271     0.150
     3.483    56.172     0.150
     3.892    61.371     0.150
     3.892    62.301     0.150
     3.971    63.271     0.150
     4.039    63.342     0.150
     4.046    62.971     0.150
     4.388    67.471     0.150
     4.418    68.570     0.150
     4.486    70.396     0.150
     4.486    83.445     0.150
     4.486   146.422     0.150
     4.557    70.371     0.150
     4.578    70.070     0.150
     5.060    75.660     0.150
     5.119    77.971     0.150
     5.572    84.871     0.150
     5.609    85.371     0.150
     5.670    85.271     0.150
     5.974    90.172     0.150
     5.933    88.381     0.150
     6.069    91.471     0.150
     6.169    92.971     0.150
     6.169    91.502     0.150
     6.543    97.971     0.150
     6.900   102.570     0.150
     7.051   105.910     0.150
     7.192   105.271     0.150
     7.196   106.371     0.150
     7.196   107.141     0.150
     7.527   110.971     0.150
     7.748   115.541     0.150
     8.977   130.842     0.150
     9.322   134.951     0.150
    10.067   144.842     0.150
    10.713   152.451     0.150
    10.839   154.576     0.150
    10.839   274.361     0.150
    10.839   154.602     0.150
    11.048   156.432     0.150
    12.185   173.650     0.150
    12.721   180.266     0.150
    12.721   180.131     0.150
    12.721   179.641     0.150
    12.721   323.041     0.150
    12.721   180.820     0.150
    13.537   192.561     0.150
    14.168   199.070     0.150
    14.710   206.852     0.150
    14.710   207.682     0.150
    14.710   366.467     0.150
    14.710   206.961     0.150
    14.853   210.332     0.150
    16.069   394.980     0.150
    16.224   228.752     0.150
    17.273   242.230     0.150
    19.393   266.496     0.150
    19.465   266.951     0.150
    19.641   268.121     0.150
    20.098   273.396     0.150
    20.205   274.252     0.150
    21.494   288.041     0.150
    21.917   294.439     0.150
    21.917   294.121     0.150
    21.917   294.682     0.150
    21.971   295.871     0.150
    22.310   298.371     0.150
    25.189   325.900     0.150
    25.236   328.320     0.150
    36.634   426.371     0.150
    36.634   425.811     0.150
    38.668   531.871     0.150
    39.155   447.082     0.150
    40.041   455.781     0.150
    40.110   456.158     0.150
    40.284   458.297     0.150
    40.284   458.121     0.150
    41.513   467.002     0.150
    41.544   468.271     0.150
    41.544   468.646     0.150
    48.904   527.311     0.150
    50.341   537.762     0.150
    51.663   547.531     0.150
    51.664   547.646     0.150
    51.664   547.432     0.150
    52.489   552.971     0.150
    74.403   699.342     0.150
    74.448   699.141     0.150
    76.040   707.252     0.150
    80.844   734.551     0.150
    87.601   768.422     0.150
    87.603   767.980     0.150
    89.574   777.672     0.150
     1.611    28.746     0.150
     1.930    34.246     0.150
     2.372    40.445     0.150
     2.520    41.746     0.150
     2.688    44.645     0.150
     3.137    51.344     0.150
     3.434    55.047     0.150
     3.373    54.645     0.150
     3.693    58.746     0.150
     3.680    58.246     0.150
     3.947    63.645     0.150
     4.131    65.246     0.150
     4.559    70.945     0.150
     4.820    74.145     0.150
     5.744    87.844     0.150
     6.163    92.945     0.150
     6.329    94.547     0.150
     6.771   101.344     0.150
    19.438   267.000     0.150
    25.020   324.316     0.150
    36.419   423.777     0.150
    40.977   464.754     0.150
    87.407   766.953     0.150
    89.389   776.203     0.150
     1.426    26.727     0.150
     1.617    28.727     0.150
     1.617    28.914     0.150
     1.799    32.727     0.150
     1.799    32.969     0.150
     2.007    35.375     0.150
     2.256    39.227     0.150
     2.305    39.023     0.150
     2.307    39.625     0.150
     2.495    42.227     0.150
     2.643    43.922     0.150
     2.799    47.047     0.150
     2.986    48.727     0.150
     3.104    49.922     0.150
     3.222    52.227     0.150
     3.229    51.828     0.150
     3.490    56.273     0.150
     3.825    61.625     0.150
     3.902    61.828     0.150
     3.902    61.312     0.150
     3.980    63.422     0.150
     4.050    62.867     0.150
     4.057    63.125     0.150
     4.426    69.328     0.150
     4.494    69.328     0.150
     4.494   145.023     0.150
     4.588    70.328     0.150
     4.748    73.648     0.150
     5.062    76.328     0.150
     5.062    76.922     0.150
     5.128    77.828     0.150
     5.582    84.625     0.150
     5.582    84.727     0.150
     5.616    84.625     0.150
     5.679    86.328     0.150
     5.922    89.422     0.150
     5.981    90.227     0.150
     6.079    91.523     0.150
     6.133    91.852     0.150
     6.174    92.328     0.150
     6.174    92.578     0.150
     6.464    96.938     0.150
     6.552    98.227     0.150
     6.818   101.625     0.150
     6.883   102.727     0.150
     7.061   104.867     0.150
     7.190   105.422     0.150
     7.190   106.586     0.150
     8.078   118.727     0.150
     8.119   119.023     0.150
     8.123   119.922     0.150
     8.764   128.195     0.150
     9.056   132.023     0.150
     9.056   131.898     0.150
     9.765   141.969     0.150
    10.833   154.312     0.150
    11.145   159.227     0.150
    14.712   207.188     0.150
    14.692   209.578     0.150
    14.692   210.070     0.150
    14.863   210.875     0.150
    15.341   223.492     0.150
    15.578   221.742     0.150
    15.721   225.102     0.150
    16.072   223.672     0.150
    16.072   395.477     0.150
    16.215   232.523     0.150
    16.409   231.836     0.150
    17.273   239.898     0.150
    17.284   246.695     0.150
    17.508   242.562     0.150
    18.042   250.078     0.150
    18.042   249.438     0.150
    18.195   254.133     0.150
    18.847   262.781     0.150
    19.391   266.367     0.150
    19.391   476.461     0.150
    19.395   267.758     0.150
    19.457   267.484     0.150
    19.634   269.688     0.150
    20.093   274.258     0.150
    20.200   275.688     0.150
    20.377   277.469     0.150
    20.784   284.016     0.150
    20.818   282.547     0.150
    20.912   284.734     0.150
    21.255   288.398     0.150
    21.918   294.641     0.150
    21.918   293.516     0.150
    22.291   299.594     0.150
    23.020   306.695     0.150
    23.020   306.578     0.150
    23.020   306.695     0.150
    25.184   325.898     0.150
    25.225   326.195     0.150
    25.988   334.695     0.150
    28.601   356.891     0.150
    35.187   414.953     0.150
    35.519   418.344     0.150
    35.519   417.414     0.150
    36.624   427.094     0.150
    36.624   426.078     0.150
    36.624   426.664     0.150
    38.015   439.742     0.150
    40.117   456.711     0.150
    40.288   458.547     0.150
    40.288   458.305     0.150
    41.151   464.102     0.150
    41.151   464.352     0.150
    41.551   467.922     0.150
    41.551   468.352     0.150
    46.693   509.969     0.150
    49.260   529.625     0.150
    51.674   547.203     0.150
    52.204   551.492     0.150
    52.479   553.172     0.150
    53.527   560.688     0.150
    59.035   600.656     0.150
    71.767   681.672     0.150
    78.418   720.297     0.150
    78.418   721.547     0.150
    87.590   767.750     0.150
    87.590   768.133     0.150
    89.564   777.625     0.150
    89.564   778.125     0.150
     1.519    27.516     0.150
     1.519    48.016     0.150
     1.718    30.516     0.150
     1.866    33.609     0.150
     2.316    40.109     0.150
     2.406    40.812     0.150
     2.584    43.516     0.150
     2.635    44.109     0.150
     2.750    45.109     0.150
     3.063    50.414     0.150
     3.207    52.016     0.150
     3.324    53.414     0.150
     3.300    54.109     0.150
     3.577    56.812     0.150
     3.610    57.414     0.150
     3.889    62.109     0.150
     3.993    63.109     0.150
     4.058    64.516     0.150
     4.169    64.711     0.150
     4.495    70.414     0.150
     4.556    70.688     0.150
     4.556   148.062     0.150
    12.620   315.133     0.150
    17.351   244.586     0.150
    19.345   265.859     0.150
    19.543   267.539     0.150
    25.110   324.609     0.150
    36.521   424.516     0.150
    41.071   464.562     0.150
    87.497   768.289     0.150
     1.424    26.020     0.150
     1.424    45.520     0.150
     1.424    26.408     0.150
     1.773    32.318     0.150
     1.953    34.158     0.150
     2.225    38.719     0.150
     2.372    40.119     0.150
     2.565    42.920     0.150
     2.539    42.818     0.150
     2.700    44.719     0.150
     2.761    46.139     0.150
     2.968    49.318     0.150
     3.205    52.719     0.150
     3.297    53.020     0.150
     3.797    60.818     0.150
     3.898    61.520     0.150
     3.898    61.830     0.150
     3.963    63.420     0.150
     4.095    63.939     0.150
     4.102    63.520     0.150
     4.437    68.318     0.150
     4.402    68.920     0.150
     4.465    71.094     0.150
     4.465    82.869     0.150
     4.465   144.244     0.150
     4.610    71.420     0.150
     4.639    71.219     0.150
     4.727    73.770     0.150
     5.133    77.559     0.150
     5.191    79.119     0.150
     5.570    84.539     0.150
     5.686    85.420     0.150
     6.136    92.479     0.150
     6.248    93.818     0.150
     6.248    94.059     0.150
     6.613    99.119     0.150
     8.111   119.318     0.150
    12.645   178.764     0.150
    19.318   266.244     0.150
    19.565   268.619     0.150
    20.020   274.494     0.150
    21.855   293.512     0.150
    25.111   325.119     0.150
    36.613   426.670     0.150
    41.079   463.094     0.150
    51.672   546.744     0.150
    87.592   768.270     0.150
    89.570   777.219     0.150
   101.958   832.744     0.150
     1.442    26.780     0.150
     1.442    26.650     0.150
     1.662    29.480     0.150
     1.662    29.360     0.150
     1.988    35.121     0.150
     2.254    39.081     0.150
     2.326    39.480     0.150
     2.352    39.880     0.150
     2.541    42.880     0.150
     2.563    43.280     0.150
     2.792    46.780     0.150
     2.993    48.681     0.150
     3.149    50.581     0.150
     3.229    52.980     0.150
     3.275    52.380     0.150
     3.535    56.280     0.150
     3.825    60.880     0.150
     3.917    62.181     0.150
     3.917    62.431     0.150
     3.987    63.480     0.150
     4.090    63.641     0.150
     4.097    63.181     0.150
     4.429    68.780     0.150
     4.436    68.480     0.150
     4.493    71.271     0.150
     4.493   147.005     0.150
     4.606    70.681     0.150
     4.630    70.980     0.150
     5.098    76.780     0.150
     5.098    77.030     0.150
     5.173    78.380     0.150
     5.592    85.280     0.150
     5.661    85.581     0.150
     5.724    86.380     0.150
     6.026    91.081     0.150
     6.123    92.081     0.150
     6.217    93.081     0.150
     6.217    93.240     0.150
     6.361    90.931     0.150
     6.506    97.630     0.150
     7.104   106.940     0.150
     7.219   106.280     0.150
     7.566   112.181     0.150
     8.113   119.181     0.150
    10.789   153.331     0.150
    12.667   180.274     0.150
    12.667   317.250     0.150
    12.667   179.171     0.150
    12.667   317.015     0.150
    14.684   205.206     0.150
    14.684   361.691     0.150
    16.046   223.855     0.150
    16.046   394.280     0.150
    16.046   222.915     0.150
    16.046   392.318     0.150
    19.352   266.530     0.150
    19.588   268.996     0.150
    20.049   274.596     0.150
    21.891   294.673     0.150
    23.041   307.380     0.150
    25.140   325.706     0.150
    28.603   357.900     0.150
    35.177   415.570     0.150
    35.474   417.416     0.150
    36.600   426.174     0.150
    40.112   456.831     0.150
    41.106   464.365     0.150
    41.545   468.092     0.150
    51.691   547.655     0.150
    87.574   767.755     0.150
    89.550   777.530     0.150
     1.633    29.852     0.150
     1.853    32.547     0.150
     1.948    35.250     0.150
     1.948    35.438     0.150
     2.049    35.773     0.150
     2.388    41.453     0.150
     2.540    42.852     0.150
     2.706    45.852     0.150
     2.906    48.781     0.150
     2.892    47.648     0.150
     3.028    49.953     0.150
     3.344    54.750     0.150
     3.453    55.648     0.150
     3.698    58.852     0.150
     3.698    59.023     0.150
     3.705    59.453     0.150
     4.104    65.047     0.150
     4.104    65.281     0.150
     4.307    68.242     0.150
     4.313    67.148     0.150
     4.576    71.148     0.150
     4.629    73.953     0.150
     4.629    86.828     0.150
     4.629   148.852     0.150
     4.629    72.812     0.150
     4.654    72.648     0.150
     4.843    74.648     0.150
     4.907    76.203     0.150
     5.366    81.352     0.150
     5.669    84.852     0.150
     5.764    88.281     0.150
     5.823    88.250     0.150
     5.909    89.352     0.150
     6.342    95.648     0.150
     6.342    95.453     0.150
     6.529    94.133     0.150
     6.719   100.781     0.150
     6.996   103.844     0.150
     7.227   108.352     0.150
     7.227   107.602     0.150
     8.745   127.656     0.150
     9.851   142.156     0.150
    10.494   150.789     0.150
    10.647   152.023     0.150
    10.647   152.258     0.150
    10.818   153.852     0.150
    11.953   169.547     0.150
    12.085   171.570     0.150
    12.421   175.258     0.150
    12.496   176.992     0.150
    12.496   313.617     0.150
    12.496   177.227     0.150
    12.496   313.352     0.150
    12.496   177.492     0.150
    12.496   317.656     0.150
    12.496   178.961     0.150
    12.781   181.367     0.150
    12.861   182.961     0.150
    12.875   182.273     0.150
    13.305   187.953     0.150
    13.324   187.789     0.150
    13.928   196.648     0.150
    14.170   199.094     0.150
    14.687   208.039     0.150
    14.687   206.031     0.150
    14.687   363.375     0.150
    14.687   207.500     0.150
    14.894   218.047     0.150
    14.947   209.992     0.150
    15.986   223.633     0.150
    16.064   224.578     0.150
    16.064   396.398     0.150
    16.064   223.188     0.150
    16.064   398.633     0.150
    17.444   243.625     0.150
    17.606   251.953     0.150
    18.280   252.906     0.150
    19.277   264.422     0.150
    19.282   264.094     0.150
    19.282   265.453     0.150
    19.420   268.547     0.150
    19.420   266.773     0.150
    19.420   265.148     0.150
    19.918   273.188     0.150
    20.025   272.180     0.150
    20.025   273.648     0.150
    21.271   286.148     0.150
    21.723   293.547     0.150
    21.894   294.242     0.150
    21.894   294.508     0.150
    21.894   295.047     0.150
    21.894   533.750     0.150
    22.193   296.750     0.150
    23.238   310.000     0.150
    23.238   309.328     0.150
    23.715   313.750     0.150
    23.857   315.047     0.150
    25.007   325.297     0.150
    25.007   324.523     0.150
    27.077     2.398     0.150
    27.077     3.398     0.150
    27.077   625.148     0.150
    28.747   359.102     0.150
    28.754   358.078     0.150
    30.230   374.047     0.150
    35.286   416.508     0.150
    35.286   414.242     0.150
    35.286   418.047     0.150
    35.268   415.930     0.150
    36.396   425.797     0.150
    40.224   457.875     0.150
    40.323   457.727     0.150
    40.323   457.594     0.150
    40.962   463.727     0.150
    40.962   463.602     0.150
    41.654   469.250     0.150
    41.654   469.578     0.150
    49.035   528.852     0.150
    49.624   533.453     0.150
    50.197   537.102     0.150
    51.879   548.977     0.150
    51.879   548.078     0.150
    52.228   550.898     0.150
    78.317   720.547     0.150
    78.317   719.883     0.150
    87.386   768.625     0.150
    87.388   767.047     0.150
    89.368   777.398     0.150
     1.435    25.936     0.150
     1.435    46.436     0.150
     1.435    26.186     0.150
     1.677    29.234     0.150
     1.787    32.035     0.150
     1.787    31.924     0.150
     2.239    38.635     0.150
     2.367    39.834     0.150
     2.558    42.334     0.150
     2.698    44.135     0.150
     2.776    45.904     0.150
     2.877    47.135     0.150
     2.981    48.535     0.150
     3.163    50.334     0.150
     3.218    52.035     0.150
     3.291    52.234     0.150
     3.608    56.436     0.150
     3.811    60.135     0.150
     3.909    61.135     0.150
     3.909    61.766     0.150
     3.976    62.834     0.150
     4.097    63.414     0.150
     4.104    63.234     0.150
     4.415    68.334     0.150
     4.441    67.635     0.150
     4.479    69.234     0.150
     4.479    82.484     0.150
     4.479   146.561     0.150
     4.479    69.715     0.150
     4.612    70.734     0.150
     4.639    70.834     0.150
     4.740    72.355     0.150
     5.120    77.135     0.150
     5.582    84.674     0.150
     5.679    85.635     0.150
     5.739    86.135     0.150
     5.885    85.314     0.150
     6.044    90.834     0.150
     6.146    91.734     0.150
     6.135    92.535     0.150
     6.238    92.635     0.150
     6.238    92.824     0.150
     6.265    93.936     0.150
     6.378    93.186     0.150
     6.515    96.715     0.150
     6.610    99.135     0.150
     7.127   104.275     0.150
     7.240   106.035     0.150
     7.240   105.654     0.150
     7.719   113.584     0.150
     7.988   116.436     0.150
     8.380   122.035     0.150
     8.908   128.875     0.150
     8.908   127.445     0.150
     9.254   132.225     0.150
     9.410   136.945     0.150
    10.426   149.254     0.150
    10.643   151.346     0.150
    10.770   152.500     0.150
    10.770   270.318     0.150
    10.770   152.875     0.150
    10.978   154.045     0.150
    12.651   178.766     0.150
    12.651   318.229     0.150
    12.651   177.922     0.150
    12.651   319.250     0.150
    13.133   186.365     0.150
    14.662   204.125     0.150
    14.662   204.254     0.150
    14.662   361.385     0.150
    14.662   204.795     0.150
    14.700   216.994     0.150
    14.861   211.115     0.150
    15.131   212.904     0.150
    16.025   223.686     0.150
    16.025   393.764     0.150
    16.025   222.041     0.150
    16.025   395.984     0.150
    17.207   242.635     0.150
    17.269   244.734     0.150
    18.101   250.975     0.150
    18.101   250.414     0.150
    19.330   264.859     0.150
    19.335   264.504     0.150
    19.346   265.635     0.150
    19.346   485.834     0.150
    19.395   264.494     0.150
    19.395   265.375     0.150
    19.571   266.635     0.150
    19.571   268.109     0.150
    20.029   274.135     0.150
    20.136   274.814     0.150
    20.136   275.135     0.150
    21.869   293.729     0.150
    21.869   292.686     0.150
    21.869   311.436     0.150
    21.869   564.035     0.150
    22.273   296.645     0.150
    23.035   306.254     0.150
    23.035   306.734     0.150
    23.035   306.635     0.150
    23.035   307.135     0.150
    24.002   315.734     0.150
    25.120   324.584     0.150
    25.120   323.686     0.150
    25.120   324.834     0.150
    25.192   325.225     0.150
    25.344   328.334     0.150
    28.590   356.609     0.150
    28.590   356.535     0.150
    28.597   356.365     0.150
    30.308   373.035     0.150
    35.159   414.725     0.150
    35.159   414.834     0.150
    35.459   417.295     0.150
    36.604   426.135     0.150
    36.604   424.605     0.150
    37.538   433.635     0.150
    41.087   463.811     0.150
    41.087   462.834     0.150
    41.528   467.635     0.150
    41.528   466.910     0.150
    50.276   536.035     0.150
    50.276     4.799     0.150
    51.683   547.109     0.150
    52.425   553.035     0.150
    78.359   720.285     0.150
    83.150   745.660     0.150
    83.150   746.135     0.150
    87.581   767.436     0.150
    89.558   777.084     0.150
     1.489    27.684     0.150
     1.489    48.983     0.150
     1.489    27.553     0.150
     1.710    29.983     0.150
     1.835    33.083     0.150
     1.835    33.443     0.150
     2.286    39.383     0.150
     2.375    40.483     0.150
     2.399    40.583     0.150
     2.604    43.483     0.150
     2.582    43.083     0.150
     2.738    45.283     0.150
     2.819    47.293     0.150
     2.924    47.983     0.150
     3.032    49.684     0.150
     3.198    51.583     0.150
     3.320    53.184     0.150
     3.576    56.413     0.150
     3.858    61.483     0.150
     3.963    62.483     0.150
     3.963    63.394     0.150
     4.027    63.383     0.150
     4.151    64.383     0.150
     4.464    70.083     0.150
     4.526    71.208     0.150
     4.526    70.474     0.150
     4.490    69.983     0.150
     4.660    72.483     0.150
     4.683    72.184     0.150
     4.790    74.943     0.150
     5.114    77.483     0.150
     5.221    79.383     0.150
     5.702    86.283     0.150
     5.771    87.184     0.150
     6.064    91.483     0.150
     6.173    92.684     0.150
     6.249    93.383     0.150
     6.249    93.783     0.150
     6.293    94.684     0.150
     6.403    93.783     0.150
     6.646    99.783     0.150
     7.107   105.373     0.150
     7.156   105.813     0.150
     7.221   110.224     0.150
     7.709   116.264     0.150
     8.878   129.413     0.150
     9.973   144.133     0.150
    10.618   153.073     0.150
    10.753   153.389     0.150
    10.753   270.174     0.150
    12.624   179.228     0.150
    12.624   179.405     0.150
    14.683   207.783     0.150
    14.683   207.886     0.150
    14.683   365.434     0.150
    14.683   208.753     0.150
    14.912   210.383     0.150
    16.050   225.733     0.150
    16.050   225.916     0.150
    16.050   398.155     0.150
    16.123   226.463     0.150
    19.332   267.383     0.150
    19.546   267.623     0.150
    19.546   269.333     0.150
    20.015   273.833     0.150
    20.122   274.053     0.150
    21.890   294.326     0.150
    21.890   293.043     0.150
    23.089   306.233     0.150
    25.106   325.434     0.150
    25.106   324.563     0.150
    28.638   357.083     0.150
    28.638   356.203     0.150
    35.198   415.803     0.150
    35.198   414.434     0.150
    36.549   425.583     0.150
    40.139   456.722     0.150
    41.571   468.283     0.150
    41.571   467.383     0.150
    51.737   548.108     0.150
    51.737   546.983     0.150
    73.155   691.983     0.150
    74.268   696.753     0.150
    75.139   702.533     0.150
    78.581   721.413     0.150
    87.527   767.059     0.150
    89.505   776.733     0.150
     1.521    27.770     0.150
     1.521    27.961     0.150
     1.735    30.371     0.150
     1.863    33.670     0.150
     2.408    40.070     0.150
     2.424    41.170     0.150
     2.602    44.070     0.150
     2.766    45.170     0.150
     2.842    47.781     0.150
     2.951    48.670     0.150
     3.224    51.871     0.150
     3.299    54.471     0.150
     3.342    53.270     0.150
     3.595    57.900     0.150
     3.885    62.670     0.150
     3.995    62.770     0.150
     4.057    64.770     0.150
     4.183    64.471     0.150
     4.492    70.070     0.150
     4.552    71.996     0.150
     4.552    84.295     0.150
     4.552   147.871     0.150
     4.552    70.080     0.150
     4.523    69.270     0.150
     4.693    71.371     0.150
     4.714    72.170     0.150
     4.819    76.010     0.150
     5.117    77.391     0.150
     5.247    79.371     0.150
     5.800    87.400     0.150
     5.665    86.211     0.150
     5.721    86.871     0.150
     5.795    87.670     0.150
     6.082    91.670     0.150
     6.201    92.871     0.150
     6.234    94.371     0.150
     6.261    93.971     0.150
     6.316    95.170     0.150
     6.424    93.961     0.150
     6.590    98.840     0.150
     6.672   100.170     0.150
     7.090   103.561     0.150
     7.215   107.670     0.150
     7.215   108.391     0.150
     7.186   105.590     0.150
     7.709   114.641     0.150
     8.201   120.371     0.150
     8.856   127.801     0.150
     9.953   142.730     0.150
    10.597   151.240     0.150
    10.737   152.945     0.150
    10.737   271.504     0.150
    10.737   152.711     0.150
    12.063   170.490     0.150
    12.538   176.600     0.150
    12.602   177.590     0.150
    12.602   178.830     0.150
    12.602   177.896     0.150
    12.602   317.203     0.150
    14.043   197.770     0.150
    14.287   200.080     0.150
    14.691   204.801     0.150
    14.691   205.346     0.150
    14.691   361.584     0.150
    14.691   205.840     0.150
    14.786   211.891     0.150
    15.068   209.490     0.150
    14.943   211.760     0.150
    16.100   225.490     0.150
    16.060   223.346     0.150
    16.060   223.203     0.150
    17.350   241.596     0.150
    17.350   244.871     0.150
    17.585   247.371     0.150
    19.328   265.371     0.150
    19.525   267.971     0.150
    19.525   267.195     0.150
    19.525   268.570     0.150
    20.002   273.695     0.150
    20.108   276.170     0.150
    21.377   286.570     0.150
    21.898   294.139     0.150
    21.898   534.070     0.150
    23.123   308.070     0.150
    23.123   307.221     0.150
    23.123   306.391     0.150
    23.959   315.971     0.150
    25.105   325.350     0.150
    25.091   325.371     0.150
    25.091   324.240     0.150
    25.387   327.471     0.150
    27.021   344.270     0.150
    28.666   358.045     0.150
    28.666   357.770     0.150
    28.673   358.170     0.150
    30.972   438.750     0.150
    30.972   685.439     0.150
    30.972   787.291     0.150
    35.219   415.631     0.150
    35.219   415.270     0.150
    35.401   417.631     0.150
    36.515   426.170     0.150
    40.009   456.400     0.150
    40.163   457.098     0.150
    41.053   464.346     0.150
    41.053   463.811     0.150
    41.563   468.311     0.150
    41.594   468.770     0.150
    41.594   468.670     0.150
    50.263   536.971     0.150
    51.770   548.471     0.150
    55.175   575.881     0.150
    69.892   672.031     0.150
    72.924   689.971     0.150
    73.685   694.480     0.150
    74.267   697.740     0.150
    74.351   698.939     0.150
    74.950   702.260     0.150
    75.156   703.301     0.150
    78.361   719.971     0.150
    83.174   745.945     0.150
    87.495   767.520     0.150
    89.473   777.221     0.150
     1.530    28.117     0.150
     1.730    30.617     0.150
     1.730    30.508     0.150
     1.875    33.812     0.150
     2.416    40.414     0.150
     2.418    40.914     0.150
     2.594    42.812     0.150
     2.763    45.617     0.150
     2.856    47.547     0.150
     2.963    48.719     0.150
     3.073    50.219     0.150
     3.220    51.617     0.150
     3.336    53.312     0.150
     3.897    62.219     0.150
     4.005    62.812     0.150
     4.005    63.023     0.150
     4.068    64.312     0.150
     4.176    65.367     0.150
     4.183    64.914     0.150
     4.504    69.719     0.150
     4.565    71.062     0.150
     4.565    84.391     0.150
     4.565   147.516     0.150
     4.565    72.039     0.150
     4.525    70.117     0.150
     4.694    72.617     0.150
     4.713    72.414     0.150
     4.831    74.875     0.150
     5.104    77.219     0.150
     5.104    77.398     0.150
     5.242    79.516     0.150
     5.675    86.289     0.150
     5.714    85.812     0.150
     5.796    84.859     0.150
     5.796    89.477     0.150
     5.789    87.312     0.150
     6.074    91.516     0.150
     6.242    93.359     0.150
     6.198    93.414     0.150
     6.251    93.516     0.150
     6.251    93.617     0.150
     6.309    95.219     0.150
     6.416    92.969     0.150
     6.589    98.922     0.150
     6.668   100.414     0.150
     7.003   104.617     0.150
     7.099   104.492     0.150
     7.184   107.094     0.150
     7.246   107.719     0.150
     7.201   106.219     0.150
     7.201   106.703     0.150
     7.695   114.766     0.150
     8.204   120.812     0.150
     8.888   130.766     0.150
     9.200   133.023     0.150
     9.483   137.789     0.150
     9.889   144.758     0.150
     9.961   142.875     0.150
    10.605   151.273     0.150
    10.746   153.188     0.150
    10.746   268.844     0.150
    11.387   164.719     0.150
    11.750   168.812     0.150
    12.543   176.797     0.150
    12.609   178.461     0.150
    12.609   178.281     0.150
    12.609   317.188     0.150
    12.609   179.016     0.150
    13.318   191.312     0.150
    13.422   189.312     0.150
    13.974   200.219     0.150
    14.705   205.266     0.150
    14.705   360.945     0.150
    14.796   215.812     0.150
    14.954   211.867     0.150
    15.072   211.445     0.150
    15.637   216.664     0.150
    15.637   384.750     0.150
    16.074   223.094     0.150
    16.074   393.719     0.150
    16.074   393.070     0.150
    16.105   225.086     0.150
    16.105   224.695     0.150
    16.803   238.219     0.150
    17.361   241.039     0.150
    17.361   246.016     0.150
    17.523   249.117     0.150
    18.223   254.266     0.150
    18.157   250.805     0.150
    19.335   265.078     0.150
    19.340   265.438     0.150
    19.345   265.203     0.150
    19.356   264.109     0.150
    19.532   267.766     0.150
    19.532   268.312     0.150
    19.532   267.492     0.150
    19.532   268.719     0.150
    20.011   273.789     0.150
    20.118   274.367     0.150
    20.118   272.586     0.150
    20.118   276.016     0.150
    21.384   287.312     0.150
    21.847   294.016     0.150
    21.912   294.359     0.150
    21.912   294.156     0.150
    21.912   294.617     0.150
    21.912   312.719     0.150
    23.131   307.562     0.150
    23.131   308.117     0.150
    23.131   307.789     0.150
    23.131   309.219     0.150
    23.966   315.914     0.150
    25.101   325.219     0.150
    25.101   324.586     0.150
    25.101   325.516     0.150
    25.401   330.516     0.150
    26.105   333.742     0.150
    26.976   340.914     0.150
    27.034   344.414     0.150
    27.034   541.414     0.150
    28.678   357.914     0.150
    28.678   357.766     0.150
    28.678   358.117     0.150
    28.685   358.344     0.150
    31.842   384.219     0.150
    35.233   415.594     0.150
    35.233   415.766     0.150
    35.407   417.578     0.150
    36.349   425.016     0.150
    36.508   425.516     0.150
    36.508   424.945     0.150
    36.508   426.016     0.150
    38.965   448.258     0.150
    40.176   457.117     0.150
    40.312   458.914     0.150
    40.312   458.797     0.150
    41.062   463.094     0.150
    41.608   468.719     0.150
    41.608   468.719     0.150
    48.342   522.094     0.150
    51.777   548.266     0.150
    51.779   548.312     0.150
    52.357   552.766     0.150
    74.006   697.109     0.150
    74.364   698.812     0.150
    75.168   703.438     0.150
    75.565   705.992     0.150
    76.537   710.555     0.150
    76.728   711.414     0.150
    77.429   716.523     0.150
    78.142   720.359     0.150
    78.374   720.664     0.150
    78.589   723.109     0.150
    79.662   728.148     0.150
    79.677   728.266     0.150
    79.986   729.742     0.150
    80.724   734.469     0.150
    80.986   735.117     0.150
    82.511   744.266     0.150
    83.188   746.969     0.150
    83.188   746.234     0.150
    83.462   749.062     0.150
    87.486   767.414     0.150
    87.486   767.266     0.150
    87.486   768.016     0.150
    89.463   777.312     0.150
    89.463   777.047     0.150
     1.769    31.108     0.150
     1.918    33.308     0.150
     2.600    43.508     0.150
     2.743    45.808     0.150
     2.972    48.408     0.150
     3.162    51.708     0.150
     3.294    53.508     0.150
     3.411    54.308     0.150
     3.501    55.708     0.150
     3.530    57.408     0.150
     3.703    59.108     0.150
     3.731    59.208     0.150
     4.097    64.908     0.150
     4.287    67.308     0.150
     4.413    68.208     0.150
     4.763    73.108     0.150
     4.762    74.083     0.150
     4.928    75.508     0.150
     4.934    75.308     0.150
     6.471    97.508     0.150
    12.460   175.152     0.150
    19.316   263.597     0.150
    19.388   265.854     0.150
    19.918   271.725     0.150
    25.004   325.001     0.150
     1.443    26.609     0.150
     1.443    46.609     0.150
     1.784    32.508     0.150
     2.398    40.312     0.150
     2.590    43.711     0.150
     2.331    39.812     0.150
     2.235    38.812     0.150
     2.727    45.008     0.150
     2.555    42.812     0.150
     3.192    51.508     0.150
     3.219    51.508     0.150
     4.129    63.609     0.150
     3.807    60.609     0.150
     3.916    62.508     0.150
     3.977    63.406     0.150
     4.464    69.312     0.150
     4.666    72.008     0.150
     4.414    69.211     0.150
     4.475    70.484     0.150
     4.475    82.562     0.150
     4.475   124.234     0.150
     4.475   148.359     0.150
     5.710    86.312     0.150
     5.585    85.406     0.150
     7.166   106.312     0.150
    10.739   153.289     0.150
    10.739   271.617     0.150
    12.620   177.531     0.150
    12.620   320.703     0.150
    12.620   179.984     0.150
    12.620   319.797     0.150
    14.641   204.523     0.150
    14.641   364.031     0.150
    16.005   222.734     0.150
    16.005   396.703     0.150
    19.302   266.336     0.150
    19.540   266.891     0.150
    19.998   273.156     0.150
    21.847   293.656     0.150
    25.089   325.406     0.150
    35.148   413.828     0.150
    41.056   463.562     0.150
     1.368    25.672     0.150
     1.368    44.570     0.150
     1.737    31.570     0.150
     1.737    31.930     0.150
     1.613    28.766     0.150
     2.194    38.266     0.150
     2.303    39.070     0.150
     2.503    41.867     0.150
     2.737    46.195     0.150
     2.627    43.672     0.150