#!/bin/bash
gmt begin herat11.41_sel1 pdf,ps
proj=-JM16.0c+
reg=-R61.8/62.2/34.4/34.8
gmt basemap $proj $reg -Bxa0.2f0.1 -Bya0.2f0.1 -BWeSn+t'Base Map herat11.41'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Bubble plots and contours of slip
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0641.02.dat | gmt plot $proj $reg  -Sc -i0,1,2+d1 -Gred@90
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0641.02.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,red,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0712.50.dat | gmt plot $proj $reg  -Sc -i0,1,2+d1 -Gyellow@90
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0712.50.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,yellow,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0740.30.dat | gmt plot $proj $reg  -Sc -i0,1,2+d1 -Ggreen@90
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0740.30.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,green,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231011.0041.56.dat | gmt plot $proj $reg  -Sc -i0,1,2+d1 -Gcyan@90
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231011.0041.56.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,cyan,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231015.0336.01.dat | gmt plot $proj $reg  -Sc -i0,1,2+d1 -Gblue@90
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231015.0336.01.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,blue,solid
rm slip.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Calibration location confidence ellipses
gmt plot $proj $reg -SE -Wthick,yellow -Gyellow << EOF
    62.060    34.630     0.000     4.000     4.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    61.883    34.658 1
    61.852    34.623 4
    61.961    34.654 6
    61.996    34.591 35
    62.060    34.630 58
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    61.919    34.605
    61.883    34.658
>
    61.847    34.645
    61.852    34.623
>
    62.024    34.687
    61.961    34.654
>
    62.027    34.605
    61.996    34.591
>
    62.112    34.603
    62.060    34.630
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    61.928    34.527
    61.928    34.527
>
    61.897    34.491
    61.897    34.491
>
    62.005    34.522
    62.005    34.522
>
    62.041    34.460
    62.040    34.459
>
    62.105    34.500
    62.105    34.498
>
EOF

# Calibration shift (for indirect calibration) in red
gmt plot $proj $reg -Wthin,red << EOF
    61.883    34.658
    61.928    34.527
>
    61.852    34.623
    61.897    34.491
>
    61.961    34.654
    62.005    34.522
>
    61.996    34.591
    62.040    34.459
>
    62.060    34.630
    62.105    34.498
>
EOF

# Calibration locations marked by a red cross
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
    62.060    34.630     0.200
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    61.883    34.658    87.601     0.796     0.948
    61.852    34.623    89.439     0.787     0.945
    61.961    34.654   -79.293     1.149     1.552
    61.996    34.591    86.893     0.914     1.101
    62.060    34.630    89.034     0.970     1.203
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    61.883    34.658     0.200
    61.852    34.623     0.200
    61.996    34.591     0.200
    62.060    34.630     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    61.818    34.413    89.034     4.116     4.177
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    61.840    34.413   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    61.818    34.413     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    61.818    34.413     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    61.818    34.368   5 km
EOF
gmt end
