#!/bin/bash
gmt begin herat11.41_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-7/4/0/43
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya10f5+l'Counts' -BWeSn+t'Origin Time Mislocation herat11.41' << EOF
    -0.166
     0.080
    -0.107
     1.014
     0.836
    -0.094
     0.512
     0.205
     0.211
     0.824
     0.112
     0.321
     1.000
     0.275
     0.185
     0.629
     2.580
    -0.164
    -0.438
    -1.039
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.208    38.257 Median =   0.2 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.2  0.
  0.2  37.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -6.800    40.743 Author: all ( 111 samples)
EOF
gmt end
