#!/bin/bash
gmt begin herat11.41_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-31/31/-31/31
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation herat11.41'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    31.230    31.230
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.759     8.674
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.355    10.201
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.644     7.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.571    17.058
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.816    14.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.601    18.299
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.435    18.945
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.238     9.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.474     8.907
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.435    -7.403
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.862     6.135
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.135    19.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.170     9.373
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.808    11.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.262    14.945
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.285    13.188
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.368    12.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.661    11.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.569    13.784
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.521    10.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000    15.330
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.678    19.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.225    12.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.009    14.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.196    15.432
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.817    15.593
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.597    14.149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.704    15.335
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.043    17.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.628    19.627
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.475    16.858
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.230    25.487
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.846    17.561
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.498    15.772
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.134    16.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.030    14.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.404     7.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.744     8.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.922    24.557
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.431     5.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.441     5.814
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.073    18.931
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.771    13.290
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.285    16.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.380    14.287
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.692    15.267
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.413    20.977
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.381    14.644
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.718     6.493
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.516     8.216
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.241    13.591
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000    30.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.639    13.574
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.547    19.345
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.746     9.563
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.164     8.282
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.666    15.878
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.609    11.628
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.130    16.859
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.082    13.320
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.650    12.407
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.872     1.746
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.398    19.268
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.637    12.154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.020    23.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.878    25.152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.957    13.683
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.485    28.341
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.444    15.432
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.504    19.196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.363    12.971
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.535    15.317
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.625    10.651
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.428    17.755
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.544    18.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.502    18.882
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.449     9.140
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.971    18.756
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.772    19.139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.032    19.145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.836    14.953
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000    21.606
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.006    22.927
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.445    12.756
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.675    13.687
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000    17.554
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.437    17.785
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.125    13.416
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.341    14.408
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.011     7.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.402    17.502
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.120    12.514
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.882    10.088
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.235    12.677
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.404    16.046
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.822    17.817
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.213    17.343
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.126    15.960
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.682    22.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.454    10.932
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.771   -26.832
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.468    26.062
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -25.163     9.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.899     9.145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.945    11.334
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.916    13.438
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.141     3.368
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.611    14.178
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.254     8.645
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.659    -7.263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -22.160     7.200
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -2.780    13.844     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -29.000    29.000 Author: all ( 111 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -29.000   -29.000 Average =  14.1 km at 348.6 deg; median =   15.6 km
EOF
gmt end
