#!/bin/bash
gmt begin herat11.41_ell pdf,ps
proj=-JM16.0c+
reg=-R61.5/62.5/34.3/34.8
gmt basemap $proj $reg -Bxa0.2f0.1 -Bya0.2f0.1 -BWeSn+t'Base Map herat11.41'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Bubble plots and contours of slip
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0641.02.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gred@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0641.02.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,red,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0712.50.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gyellow@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0712.50.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,yellow,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0740.30.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Ggreen@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0740.30.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,green,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231011.0041.56.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gcyan@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231011.0041.56.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,cyan,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231015.0336.01.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gblue@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231015.0336.01.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,blue,solid
rm slip.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Calibration location confidence ellipses
gmt plot $proj $reg -SE -Wthick,yellow -Gyellow << EOF
    62.060    34.630     0.000     4.000     4.000
EOF

# Calibration locations marked by a red cross
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
    62.060    34.630     0.200
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    61.883    34.658    87.601     0.796     0.948
    61.902    34.655   -88.840     0.974     1.179
    61.865    34.601    75.968     1.413     1.826
    61.852    34.623    89.439     0.787     0.945
    61.754    34.618    20.574     2.816     4.283
    61.961    34.654   -79.293     1.149     1.552
    61.966    34.658    38.330     2.122     3.465
    61.860    34.639     9.585     2.520     6.562
    62.051    34.642    25.583     3.495     5.706
    61.918    34.641    20.710     3.317     5.249
    61.959    34.664    75.692     1.690     2.128
    61.882    34.670    65.994     1.189     1.425
    61.965    34.633    28.347     2.250     3.714
    61.939    34.574     8.733     3.526     6.997
    61.907    34.619     4.999     5.002     8.543
    61.955    34.633    12.267     2.293     4.376
    61.898    34.637    39.400     1.942     2.713
    62.032    34.610    13.058     4.649     8.228
    61.966    34.618    11.553     2.157     4.041
    61.911    34.637     2.127     2.818     6.084
    61.836    34.626     6.710     2.866     5.432
    61.874    34.602    44.794     1.595     2.115
    61.888    34.569    23.856     2.810     5.178
    61.986    34.583    40.595     1.569     2.408
    61.997    34.564     9.602     3.412     9.036
    61.964    34.642    14.026     2.870     5.934
    61.942    34.650    17.610     2.056     4.002
    61.935    34.576    20.733     2.343     4.443
    61.975    34.552    23.105     3.389     5.918
    61.809    34.598    37.533     1.991     2.860
    61.935    34.652    16.653     2.013     3.333
    62.008    34.644    66.520     1.360     1.656
    61.964    34.628    74.122     1.474     1.812
    62.012    34.661    83.861     1.031     1.199
    61.996    34.591    86.893     0.914     1.101
    62.066    34.620    80.138     1.731     2.495
    61.989    34.624    38.847     2.083     2.874
    62.096    34.587    50.714     2.091     4.505
    61.918    34.580    28.830     2.370     3.515
    62.150    34.621    41.029     5.463     9.159
    62.025    34.614    20.590     2.750     4.739
    61.952    34.661    49.619     1.865     2.570
    61.977    34.626    11.561     2.555     4.838
    61.897    34.655    20.184     1.903     2.989
    61.799    34.615    16.106     2.384     3.790
    61.786    34.602    10.837     2.546     4.901
    61.980    34.685    22.498     2.170     3.732
    62.102    34.631    34.461     3.835     6.489
    61.911    34.650    36.715     1.659     2.691
    62.071    34.618    33.395     2.523     3.601
    61.937    34.640     3.647     2.786     4.767
    61.837    34.656    62.604     1.562     2.109
    61.864    34.601    19.865     1.994     3.848
    61.858    34.636    81.774     1.327     1.703
    61.889    34.607    18.642     2.928     5.240
    61.965    34.638     1.475     2.451     5.334
    62.026    34.638    39.574     1.702     2.704
    62.060    34.630    89.034     0.970     1.203
    62.157    34.657    16.251     4.166     7.665
    62.153    34.633    59.381     3.017     4.502
    62.135    34.654   -88.819     0.985     1.191
    62.144    34.618    45.295     2.113     3.626
    62.080    34.576    19.925     3.724     7.260
    62.080    34.627     9.136     3.250     5.063
    62.111    34.644    59.117     1.573     2.235
    62.138    34.637    58.438     1.652     2.492
    61.933    34.635    37.188     1.857     3.420
    62.092    34.563    64.051     2.152     3.324
    62.015    34.637    35.399     1.675     2.669
    62.123    34.639    21.255     2.617     4.740
    62.134    34.669     6.037     5.259     6.283
    62.034    34.583    13.119     1.903     3.549
    62.133    34.678    49.015     2.103     3.441
    61.941    34.638    13.580     2.623     5.005
    61.986    34.633    15.129     3.399     7.722
    62.068    34.653    12.159     2.262     5.090
    62.117    34.657    36.052     2.474     3.383
    62.150    34.635    14.393     2.351     3.781
    62.125    34.672    14.201     2.455     4.203
    61.983    34.654    39.054     1.754     2.359
    62.080    34.666    27.109     2.065     2.924
    61.913    34.660    29.889     1.774     2.653
    61.958    34.653     5.825     2.342     4.478
    61.911    34.574    15.815     1.785     2.913
    62.113    34.669     5.047     3.620     6.759
    61.971    34.615    24.069     1.833     3.171
    62.075    34.674    50.749     1.638     2.185
    62.085    34.676    82.278     0.912     1.089
    61.852    34.603    36.338     1.935     3.288
    62.142    34.650     1.771     5.115     9.432
    61.865    34.602    20.166     1.732     2.609
    62.001    34.618    12.056     2.759     5.769
    61.903    34.669     9.387     2.169     4.327
    61.906    34.633    16.245     1.845     3.575
    62.171    34.651    43.050     2.051     3.498
    61.909    34.655    27.758     1.754     2.792
    61.972    34.638    22.687     2.763     4.463
    62.013    34.633    43.777     1.894     3.093
    62.017    34.620    46.803     1.435     2.439
    62.313    34.579    14.340     4.287     9.522
    61.934    34.678    17.434     3.828     6.546
    61.816    34.649    43.306     1.819     2.682
    62.167    34.631     7.623     3.806     6.018
    62.021    34.637     7.690     4.304     9.059
    61.882    34.660    -0.384     3.748     7.922
    62.147    34.593     3.703     3.525     7.561
    62.134    34.637     1.136     3.603     6.440
    62.085    34.670   -81.723     0.243     4.240
    61.878    34.682    11.674     3.411     5.229
    61.629    34.652     5.437     3.372     8.660
    61.894    34.620    -0.904     4.292     8.109
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    61.883    34.658     0.200
    61.852    34.623     0.200
    61.996    34.591     0.200
    62.060    34.630     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    61.594    34.374    89.034     4.116     4.177
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    61.617    34.374   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    61.594    34.374     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    61.594    34.374     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    61.594    34.329   5 km
EOF
gmt end
