#!/bin/bash
gmt begin herat11.41_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-14/29/0/100
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya50f10+lCounts -BWeSn+t'Focal Depth Mislocation herat11.41' << EOF
    -2.700
     2.400
    -1.000
     4.900
     3.900
     1.600
     1.600
    -0.100
     1.000
     3.700
    -2.500
     4.000
     5.000
    -0.400
     1.400
     5.000
    24.000
     0.600
     4.000
    -4.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     1.600    88.250 Median =   1.6 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  1.6  0.
  1.6  86.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -13.000    94.750 Author: all ( 111 samples)
EOF
gmt end
