#!/bin/bash
gmt begin herat11.41_base pdf,ps
proj=-JM16.0c+
reg=-R61.5/62.5/34.3/34.8
gmt basemap $proj $reg -Bxa0.2f0.1 -Bya0.2f0.1 -BWeSn+t'Base Map herat11.41'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Bubble plots and contours of slip
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0641.02.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gred@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0641.02.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,red,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0712.50.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gyellow@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0712.50.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,yellow,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0740.30.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Ggreen@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231007.0740.30.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,green,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231011.0041.56.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gcyan@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231011.0041.56.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,cyan,solid
rm slip.grd
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231015.0336.01.dat | gmt plot $proj $reg  -Sc -i0,1,2+d2 -Gblue@70
awk '{if(NR>1) print $2, $1, $3}' herat11/herat_slip/20231015.0336.01.dat | gmt xyz2grd -Gslip.grd $reg -I1k -Au
gmt grdcontour slip.grd $proj -Bwsne -C0.2,0.4,0.6,0.8,1.0 -Lp -Wthick,blue,solid
rm slip.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Calibration location confidence ellipses
gmt plot $proj $reg -SE -Wthick,yellow -Gyellow << EOF
    62.060    34.630     0.000     4.000     4.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    61.883    34.658 1
    61.902    34.655 2
    61.865    34.601 3
    61.852    34.623 4
    61.754    34.618 5
    61.961    34.654 6
    61.966    34.658 7
    61.860    34.639 8
    62.051    34.642 9
    61.918    34.641 10
    61.959    34.664 11
    61.882    34.670 12
    61.965    34.633 13
    61.939    34.574 14
    61.907    34.619 15
    61.955    34.633 16
    61.898    34.637 17
    62.032    34.610 18
    61.966    34.618 19
    61.911    34.637 20
    61.836    34.626 21
    61.874    34.602 22
    61.888    34.569 23
    61.986    34.583 24
    61.997    34.564 25
    61.964    34.642 26
    61.942    34.650 27
    61.935    34.576 28
    61.975    34.552 29
    61.809    34.598 30
    61.935    34.652 31
    62.008    34.644 32
    61.964    34.628 33
    62.012    34.661 34
    61.996    34.591 35
    62.066    34.620 36
    61.989    34.624 37
    62.096    34.587 38
    61.918    34.580 39
    62.150    34.621 40
    62.025    34.614 41
    61.952    34.661 42
    61.977    34.626 43
    61.897    34.655 44
    61.799    34.615 45
    61.786    34.602 46
    61.980    34.685 47
    62.102    34.631 48
    61.911    34.650 49
    62.071    34.618 50
    61.937    34.640 51
    61.837    34.656 52
    61.864    34.601 53
    61.858    34.636 54
    61.889    34.607 55
    61.965    34.638 56
    62.026    34.638 57
    62.060    34.630 58
    62.157    34.657 59
    62.153    34.633 60
    62.135    34.654 61
    62.144    34.618 62
    62.080    34.576 63
    62.080    34.627 64
    62.111    34.644 65
    62.138    34.637 66
    61.933    34.635 67
    62.092    34.563 68
    62.015    34.637 69
    62.123    34.639 70
    62.134    34.669 71
    62.034    34.583 72
    62.133    34.678 73
    61.941    34.638 74
    61.986    34.633 75
    62.068    34.653 76
    62.117    34.657 77
    62.150    34.635 78
    62.125    34.672 79
    61.983    34.654 80
    62.080    34.666 81
    61.913    34.660 82
    61.958    34.653 83
    61.911    34.574 84
    62.113    34.669 85
    61.971    34.615 86
    62.075    34.674 87
    62.085    34.676 88
    61.852    34.603 89
    62.142    34.650 90
    61.865    34.602 91
    62.001    34.618 92
    61.903    34.669 93
    61.906    34.633 94
    62.171    34.651 95
    61.909    34.655 96
    61.972    34.638 97
    62.013    34.633 98
    62.017    34.620 99
    62.313    34.579 100
    61.934    34.678 101
    61.816    34.649 102
    62.167    34.631 103
    62.021    34.637 104
    61.882    34.660 105
    62.147    34.593 106
    62.134    34.637 107
    62.085    34.670 108
    61.878    34.682 109
    61.629    34.652 110
    61.894    34.620 111
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    61.919    34.605
    61.883    34.658
>
    61.921    34.615
    61.902    34.655
>
    61.928    34.533
    61.865    34.601
>
    61.847    34.645
    61.852    34.623
>
    61.778    34.619
    61.754    34.618
>
    62.024    34.687
    61.961    34.654
>
    61.918    34.697
    61.966    34.658
>
    61.858    34.598
    61.860    34.639
>
    62.013    34.590
    62.051    34.642
>
    61.892    34.443
    61.918    34.641
>
    61.994    34.587
    61.959    34.664
>
    61.971    34.714
    61.882    34.670
>
    62.132    34.586
    61.965    34.633
>
    61.930    34.550
    61.939    34.574
>
    61.830    34.623
    61.907    34.619
>
    61.953    34.621
    61.955    34.633
>
    62.012    34.618
    61.898    34.637
>
    61.962    34.578
    62.032    34.610
>
    61.950    34.611
    61.966    34.618
>
    61.938    34.603
    61.911    34.637
>
    61.881    34.633
    61.836    34.626
>
    61.936    34.643
    61.874    34.602
>
    61.936    34.553
    61.888    34.569
>
    62.019    34.582
    61.986    34.583
>
    61.962    34.571
    61.997    34.564
>
    62.000    34.651
    61.964    34.642
>
    61.937    34.646
    61.942    34.650
>
    61.952    34.583
    61.935    34.576
>
    61.955    34.579
    61.975    34.552
>
    61.793    34.644
    61.809    34.598
>
    61.996    34.673
    61.935    34.652
>
    62.029    34.742
    62.008    34.644
>
    61.987    34.655
    61.964    34.628
>
    62.028    34.671
    62.012    34.661
>
    62.027    34.605
    61.996    34.591
>
    62.132    34.619
    62.066    34.620
>
    62.038    34.562
    61.989    34.624
>
    62.100    34.528
    62.096    34.587
>
    61.854    34.670
    61.918    34.580
>
    62.264    34.542
    62.150    34.621
>
    61.989    34.534
    62.025    34.614
>
    62.052    34.701
    61.952    34.661
>
    61.948    34.615
    61.977    34.626
>
    61.916    34.670
    61.897    34.655
>
    61.731    34.613
    61.799    34.615
>
    61.802    34.608
    61.786    34.602
>
    61.956    34.743
    61.980    34.685
>
    62.109    34.631
    62.102    34.631
>
    61.905    34.577
    61.911    34.650
>
    62.002    34.561
    62.071    34.618
>
    61.871    34.632
    61.937    34.640
>
    61.880    34.796
    61.837    34.656
>
    61.881    34.592
    61.864    34.601
>
    61.964    34.678
    61.858    34.636
>
    61.872    34.561
    61.889    34.607
>
    61.997    34.581
    61.965    34.638
>
    62.031    34.650
    62.026    34.638
>
    62.112    34.603
    62.060    34.630
>
    62.090    34.676
    62.157    34.657
>
    62.275    34.622
    62.153    34.633
>
    62.173    34.634
    62.135    34.654
>
    62.209    34.502
    62.144    34.618
>
    62.022    34.618
    62.080    34.576
>
    62.117    34.605
    62.080    34.627
>
    62.134    34.721
    62.111    34.644
>
    62.174    34.732
    62.138    34.637
>
    61.988    34.627
    61.933    34.635
>
    62.119    34.687
    62.092    34.563
>
    62.034    34.645
    62.015    34.637
>
    62.109    34.681
    62.123    34.639
>
    62.194    34.654
    62.134    34.669
>
    62.072    34.590
    62.034    34.583
>
    62.271    34.643
    62.133    34.678
>
    61.927    34.667
    61.941    34.638
>
    62.004    34.665
    61.986    34.633
>
    62.040    34.691
    62.068    34.653
>
    62.188    34.608
    62.117    34.657
>
    62.228    34.672
    62.150    34.635
>
    62.117    34.713
    62.125    34.672
>
    62.060    34.695
    61.983    34.654
>
    62.144    34.669
    62.080    34.666
>
    61.958    34.723
    61.913    34.660
>
    62.023    34.728
    61.958    34.653
>
    61.960    34.558
    61.911    34.574
>
    62.084    34.660
    62.113    34.669
>
    62.016    34.641
    61.971    34.615
>
    62.061    34.703
    62.075    34.674
>
    62.106    34.665
    62.085    34.676
>
    61.817    34.601
    61.852    34.603
>
    62.229    34.590
    62.142    34.650
>
    61.947    34.628
    61.865    34.602
>
    62.011    34.599
    62.001    34.618
>
    61.861    34.628
    61.903    34.669
>
    61.975    34.615
    61.906    34.633
>
    62.201    34.664
    62.171    34.651
>
    61.923    34.684
    61.909    34.655
>
    62.031    34.663
    61.972    34.638
>
    62.125    34.646
    62.013    34.633
>
    62.013    34.687
    62.017    34.620
>
    62.125    34.547
    62.313    34.579
>
    61.939    34.305
    61.934    34.678
>
    61.955    34.752
    61.816    34.649
>
    61.937    34.582
    62.167    34.631
>
    61.948    34.589
    62.021    34.637
>
    61.808    34.631
    61.882    34.660
>
    62.039    34.582
    62.147    34.593
>
    62.214    34.535
    62.134    34.637
>
    62.058    34.666
    62.085    34.670
>
    62.001    34.628
    61.878    34.682
>
    61.525    34.456
    61.629    34.652
>
    61.698    34.554
    61.894    34.620
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    61.928    34.527
    61.928    34.527
>
    61.947    34.523
    61.947    34.523
>
    61.911    34.470
    61.910    34.469
>
    61.897    34.491
    61.897    34.491
>
    61.798    34.486
    61.798    34.486
>
    62.005    34.522
    62.005    34.522
>
    62.011    34.526
    62.011    34.526
>
    61.904    34.508
    61.905    34.508
>
    62.093    34.510
    62.095    34.510
>
    61.963    34.510
    61.963    34.510
>
    62.004    34.532
    62.004    34.532
>
    61.927    34.538
    61.927    34.538
>
    62.008    34.501
    62.010    34.502
>
    61.983    34.443
    61.983    34.443
>
    61.954    34.488
    61.952    34.488
>
    61.999    34.502
    62.000    34.502
>
    61.943    34.506
    61.943    34.506
>
    62.076    34.478
    62.077    34.478
>
    62.009    34.487
    62.010    34.487
>
    61.956    34.505
    61.956    34.505
>
    61.881    34.494
    61.881    34.495
>
    61.919    34.470
    61.919    34.470
>
    61.933    34.437
    61.932    34.437
>
    62.030    34.451
    62.030    34.451
>
    62.040    34.432
    62.042    34.432
>
    62.008    34.511
    62.009    34.511
>
    61.987    34.518
    61.987    34.518
>
    61.979    34.444
    61.980    34.444
>
    62.018    34.420
    62.020    34.420
>
    61.853    34.467
    61.854    34.467
>
    61.980    34.521
    61.980    34.521
>
    62.053    34.512
    62.053    34.512
>
    62.008    34.497
    62.008    34.497
>
    62.056    34.530
    62.056    34.529
>
    62.041    34.460
    62.040    34.459
>
    62.111    34.488
    62.111    34.488
>
    62.034    34.492
    62.033    34.492
>
    62.140    34.454
    62.140    34.455
>
    61.963    34.449
    61.963    34.449
>
    62.195    34.489
    62.195    34.490
>
    62.069    34.482
    62.070    34.482
>
    61.998    34.529
    61.997    34.530
>
    62.022    34.494
    62.021    34.495
>
    61.942    34.523
    61.942    34.523
>
    61.843    34.483
    61.843    34.483
>
    61.829    34.471
    61.830    34.470
>
    62.023    34.553
    62.025    34.554
>
    62.145    34.499
    62.146    34.499
>
    61.956    34.518
    61.955    34.518
>
    62.116    34.486
    62.116    34.486
>
    61.982    34.508
    61.982    34.508
>
    61.881    34.525
    61.881    34.524
>
    61.906    34.470
    61.908    34.469
>
    61.903    34.505
    61.903    34.504
>
    61.933    34.475
    61.934    34.475
>
    62.010    34.507
    62.010    34.507
>
    62.071    34.507
    62.071    34.507
>
    62.105    34.500
    62.105    34.498
>
    62.203    34.524
    62.202    34.525
>
    62.198    34.502
    62.198    34.501
>
    62.180    34.522
    62.180    34.522
>
    62.190    34.487
    62.188    34.487
>
    62.122    34.444
    62.124    34.444
>
    62.124    34.496
    62.125    34.496
>
    62.156    34.513
    62.156    34.513
>
    62.183    34.505
    62.183    34.505
>
    61.977    34.504
    61.978    34.504
>
    62.135    34.431
    62.136    34.431
>
    62.060    34.505
    62.060    34.505
>
    62.167    34.507
    62.168    34.508
>
    62.178    34.537
    62.179    34.537
>
    62.078    34.452
    62.079    34.452
>
    62.177    34.548
    62.178    34.547
>
    61.986    34.507
    61.986    34.506
>
    62.031    34.501
    62.031    34.501
>
    62.112    34.521
    62.113    34.522
>
    62.163    34.525
    62.162    34.525
>
    62.194    34.503
    62.195    34.503
>
    62.170    34.541
    62.170    34.541
>
    62.026    34.523
    62.028    34.523
>
    62.125    34.534
    62.124    34.534
>
    61.958    34.528
    61.958    34.528
>
    62.003    34.522
    62.003    34.521
>
    61.955    34.443
    61.955    34.443
>
    62.155    34.539
    62.157    34.537
>
    62.014    34.484
    62.015    34.483
>
    62.120    34.543
    62.120    34.542
>
    62.130    34.544
    62.130    34.544
>
    61.895    34.471
    61.897    34.471
>
    62.186    34.519
    62.186    34.518
>
    61.910    34.471
    61.910    34.470
>
    62.043    34.487
    62.045    34.487
>
    61.947    34.537
    61.947    34.537
>
    61.950    34.501
    61.951    34.501
>
    62.219    34.526
    62.215    34.519
>
    61.954    34.522
    61.954    34.523
>
    62.017    34.506
    62.017    34.507
>
    62.058    34.502
    62.058    34.502
>
    62.063    34.488
    62.062    34.488
>
    62.358    34.449
    62.358    34.447
>
    61.978    34.547
    61.978    34.547
>
    61.861    34.518
    61.860    34.518
>
    62.211    34.500
    62.211    34.500
>
    62.065    34.506
    62.066    34.506
>
    61.927    34.528
    61.927    34.528
>
    62.192    34.461
    62.192    34.462
>
    62.179    34.506
    62.179    34.505
>
    62.130    34.539
    62.130    34.538
>
    61.923    34.550
    61.923    34.550
>
    61.672    34.520
    61.673    34.521
>
    61.938    34.488
    61.939    34.488
>
EOF

# Calibration shift (for indirect calibration) in red
gmt plot $proj $reg -Wthin,red << EOF
    61.883    34.658
    61.928    34.527
>
    61.902    34.655
    61.947    34.523
>
    61.865    34.601
    61.910    34.469
>
    61.852    34.623
    61.897    34.491
>
    61.754    34.618
    61.798    34.486
>
    61.961    34.654
    62.005    34.522
>
    61.966    34.658
    62.011    34.526
>
    61.860    34.639
    61.905    34.508
>
    62.051    34.642
    62.095    34.510
>
    61.918    34.641
    61.963    34.510
>
    61.959    34.664
    62.004    34.532
>
    61.882    34.670
    61.927    34.538
>
    61.965    34.633
    62.010    34.502
>
    61.939    34.574
    61.983    34.443
>
    61.907    34.619
    61.952    34.488
>
    61.955    34.633
    62.000    34.502
>
    61.898    34.637
    61.943    34.506
>
    62.032    34.610
    62.077    34.478
>
    61.966    34.618
    62.010    34.487
>
    61.911    34.637
    61.956    34.505
>
    61.836    34.626
    61.881    34.495
>
    61.874    34.602
    61.919    34.470
>
    61.888    34.569
    61.932    34.437
>
    61.986    34.583
    62.030    34.451
>
    61.997    34.564
    62.042    34.432
>
    61.964    34.642
    62.009    34.511
>
    61.942    34.650
    61.987    34.518
>
    61.935    34.576
    61.980    34.444
>
    61.975    34.552
    62.020    34.420
>
    61.809    34.598
    61.854    34.467
>
    61.935    34.652
    61.980    34.521
>
    62.008    34.644
    62.053    34.512
>
    61.964    34.628
    62.008    34.497
>
    62.012    34.661
    62.056    34.529
>
    61.996    34.591
    62.040    34.459
>
    62.066    34.620
    62.111    34.488
>
    61.989    34.624
    62.033    34.492
>
    62.096    34.587
    62.140    34.455
>
    61.918    34.580
    61.963    34.449
>
    62.150    34.621
    62.195    34.490
>
    62.025    34.614
    62.070    34.482
>
    61.952    34.661
    61.997    34.530
>
    61.977    34.626
    62.021    34.495
>
    61.897    34.655
    61.942    34.523
>
    61.799    34.615
    61.843    34.483
>
    61.786    34.602
    61.830    34.470
>
    61.980    34.685
    62.025    34.554
>
    62.102    34.631
    62.146    34.499
>
    61.911    34.650
    61.955    34.518
>
    62.071    34.618
    62.116    34.486
>
    61.937    34.640
    61.982    34.508
>
    61.837    34.656
    61.881    34.524
>
    61.864    34.601
    61.908    34.469
>
    61.858    34.636
    61.903    34.504
>
    61.889    34.607
    61.934    34.475
>
    61.965    34.638
    62.010    34.507
>
    62.026    34.638
    62.071    34.507
>
    62.060    34.630
    62.105    34.498
>
    62.157    34.657
    62.202    34.525
>
    62.153    34.633
    62.198    34.501
>
    62.135    34.654
    62.180    34.522
>
    62.144    34.618
    62.188    34.487
>
    62.080    34.576
    62.124    34.444
>
    62.080    34.627
    62.125    34.496
>
    62.111    34.644
    62.156    34.513
>
    62.138    34.637
    62.183    34.505
>
    61.933    34.635
    61.978    34.504
>
    62.092    34.563
    62.136    34.431
>
    62.015    34.637
    62.060    34.505
>
    62.123    34.639
    62.168    34.508
>
    62.134    34.669
    62.179    34.537
>
    62.034    34.583
    62.079    34.452
>
    62.133    34.678
    62.178    34.547
>
    61.941    34.638
    61.986    34.506
>
    61.986    34.633
    62.031    34.501
>
    62.068    34.653
    62.113    34.522
>
    62.117    34.657
    62.162    34.525
>
    62.150    34.635
    62.195    34.503
>
    62.125    34.672
    62.170    34.541
>
    61.983    34.654
    62.028    34.523
>
    62.080    34.666
    62.124    34.534
>
    61.913    34.660
    61.958    34.528
>
    61.958    34.653
    62.003    34.521
>
    61.911    34.574
    61.955    34.443
>
    62.113    34.669
    62.157    34.537
>
    61.971    34.615
    62.015    34.483
>
    62.075    34.674
    62.120    34.542
>
    62.085    34.676
    62.130    34.544
>
    61.852    34.603
    61.897    34.471
>
    62.142    34.650
    62.186    34.518
>
    61.865    34.602
    61.910    34.470
>
    62.001    34.618
    62.045    34.487
>
    61.903    34.669
    61.947    34.537
>
    61.906    34.633
    61.951    34.501
>
    62.171    34.651
    62.215    34.519
>
    61.909    34.655
    61.954    34.523
>
    61.972    34.638
    62.017    34.507
>
    62.013    34.633
    62.058    34.502
>
    62.017    34.620
    62.062    34.488
>
    62.313    34.579
    62.358    34.447
>
    61.934    34.678
    61.978    34.547
>
    61.816    34.649
    61.860    34.518
>
    62.167    34.631
    62.211    34.500
>
    62.021    34.637
    62.066    34.506
>
    61.882    34.660
    61.927    34.528
>
    62.147    34.593
    62.192    34.462
>
    62.134    34.637
    62.179    34.505
>
    62.085    34.670
    62.130    34.538
>
    61.878    34.682
    61.923    34.550
>
    61.629    34.652
    61.673    34.521
>
    61.894    34.620
    61.939    34.488
>
EOF

# Calibration locations marked by a red cross
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
    62.060    34.630     0.200
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    61.883    34.658    87.601     0.796     0.948
    61.902    34.655   -88.840     0.974     1.179
    61.865    34.601    75.968     1.413     1.826
    61.852    34.623    89.439     0.787     0.945
    61.754    34.618    20.574     2.816     4.283
    61.961    34.654   -79.293     1.149     1.552
    61.966    34.658    38.330     2.122     3.465
    61.860    34.639     9.585     2.520     6.562
    62.051    34.642    25.583     3.495     5.706
    61.918    34.641    20.710     3.317     5.249
    61.959    34.664    75.692     1.690     2.128
    61.882    34.670    65.994     1.189     1.425
    61.965    34.633    28.347     2.250     3.714
    61.939    34.574     8.733     3.526     6.997
    61.907    34.619     4.999     5.002     8.543
    61.955    34.633    12.267     2.293     4.376
    61.898    34.637    39.400     1.942     2.713
    62.032    34.610    13.058     4.649     8.228
    61.966    34.618    11.553     2.157     4.041
    61.911    34.637     2.127     2.818     6.084
    61.836    34.626     6.710     2.866     5.432
    61.874    34.602    44.794     1.595     2.115
    61.888    34.569    23.856     2.810     5.178
    61.986    34.583    40.595     1.569     2.408
    61.997    34.564     9.602     3.412     9.036
    61.964    34.642    14.026     2.870     5.934
    61.942    34.650    17.610     2.056     4.002
    61.935    34.576    20.733     2.343     4.443
    61.975    34.552    23.105     3.389     5.918
    61.809    34.598    37.533     1.991     2.860
    61.935    34.652    16.653     2.013     3.333
    62.008    34.644    66.520     1.360     1.656
    61.964    34.628    74.122     1.474     1.812
    62.012    34.661    83.861     1.031     1.199
    61.996    34.591    86.893     0.914     1.101
    62.066    34.620    80.138     1.731     2.495
    61.989    34.624    38.847     2.083     2.874
    62.096    34.587    50.714     2.091     4.505
    61.918    34.580    28.830     2.370     3.515
    62.150    34.621    41.029     5.463     9.159
    62.025    34.614    20.590     2.750     4.739
    61.952    34.661    49.619     1.865     2.570
    61.977    34.626    11.561     2.555     4.838
    61.897    34.655    20.184     1.903     2.989
    61.799    34.615    16.106     2.384     3.790
    61.786    34.602    10.837     2.546     4.901
    61.980    34.685    22.498     2.170     3.732
    62.102    34.631    34.461     3.835     6.489
    61.911    34.650    36.715     1.659     2.691
    62.071    34.618    33.395     2.523     3.601
    61.937    34.640     3.647     2.786     4.767
    61.837    34.656    62.604     1.562     2.109
    61.864    34.601    19.865     1.994     3.848
    61.858    34.636    81.774     1.327     1.703
    61.889    34.607    18.642     2.928     5.240
    61.965    34.638     1.475     2.451     5.334
    62.026    34.638    39.574     1.702     2.704
    62.060    34.630    89.034     0.970     1.203
    62.157    34.657    16.251     4.166     7.665
    62.153    34.633    59.381     3.017     4.502
    62.135    34.654   -88.819     0.985     1.191
    62.144    34.618    45.295     2.113     3.626
    62.080    34.576    19.925     3.724     7.260
    62.080    34.627     9.136     3.250     5.063
    62.111    34.644    59.117     1.573     2.235
    62.138    34.637    58.438     1.652     2.492
    61.933    34.635    37.188     1.857     3.420
    62.092    34.563    64.051     2.152     3.324
    62.015    34.637    35.399     1.675     2.669
    62.123    34.639    21.255     2.617     4.740
    62.134    34.669     6.037     5.259     6.283
    62.034    34.583    13.119     1.903     3.549
    62.133    34.678    49.015     2.103     3.441
    61.941    34.638    13.580     2.623     5.005
    61.986    34.633    15.129     3.399     7.722
    62.068    34.653    12.159     2.262     5.090
    62.117    34.657    36.052     2.474     3.383
    62.150    34.635    14.393     2.351     3.781
    62.125    34.672    14.201     2.455     4.203
    61.983    34.654    39.054     1.754     2.359
    62.080    34.666    27.109     2.065     2.924
    61.913    34.660    29.889     1.774     2.653
    61.958    34.653     5.825     2.342     4.478
    61.911    34.574    15.815     1.785     2.913
    62.113    34.669     5.047     3.620     6.759
    61.971    34.615    24.069     1.833     3.171
    62.075    34.674    50.749     1.638     2.185
    62.085    34.676    82.278     0.912     1.089
    61.852    34.603    36.338     1.935     3.288
    62.142    34.650     1.771     5.115     9.432
    61.865    34.602    20.166     1.732     2.609
    62.001    34.618    12.056     2.759     5.769
    61.903    34.669     9.387     2.169     4.327
    61.906    34.633    16.245     1.845     3.575
    62.171    34.651    43.050     2.051     3.498
    61.909    34.655    27.758     1.754     2.792
    61.972    34.638    22.687     2.763     4.463
    62.013    34.633    43.777     1.894     3.093
    62.017    34.620    46.803     1.435     2.439
    62.313    34.579    14.340     4.287     9.522
    61.934    34.678    17.434     3.828     6.546
    61.816    34.649    43.306     1.819     2.682
    62.167    34.631     7.623     3.806     6.018
    62.021    34.637     7.690     4.304     9.059
    61.882    34.660    -0.384     3.748     7.922
    62.147    34.593     3.703     3.525     7.561
    62.134    34.637     1.136     3.603     6.440
    62.085    34.670   -81.723     0.243     4.240
    61.878    34.682    11.674     3.411     5.229
    61.629    34.652     5.437     3.372     8.660
    61.894    34.620    -0.904     4.292     8.109
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    61.883    34.658     0.200
    61.852    34.623     0.200
    61.996    34.591     0.200
    62.060    34.630     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    61.594    34.374    89.034     4.116     4.177
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    61.617    34.374   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    61.594    34.374     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    61.594    34.374     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    61.594    34.329   5 km
EOF
gmt end
