#!/bin/bash
gmt begin haida1.26_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases haida1.26'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -3.279
     3.000    -3.355
     3.500    -3.431
     4.000    -3.506
     4.500    -3.582
     5.000    -3.658
     5.500    -3.734
     6.000    -3.810
     6.500    -3.885
     7.000    -3.961
     7.500    -4.037
     8.000    -4.113
     8.500    -4.189
     9.000    -4.264
     9.500    -4.340
    10.000    -4.416
    10.500    -4.492
    11.000    -4.568
    11.500    -4.643
    12.000    -4.719
    12.500    -4.795
    13.000    -4.871
    13.500    -4.947
    14.000    -5.022
    14.500    -5.098
    15.000    -5.174
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000    -1.871 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     1.679
     1.500    -2.021
     2.000    -5.720
     2.500    -9.419
     3.000   -13.118
     3.500   -16.817
     4.000   -20.520
     4.500   -24.224
     5.000   -27.928
     5.500   -31.636
     6.000   -35.346
     6.500   -39.057
     7.000   -42.772
     7.500   -46.489
     8.000   -50.209
     8.500   -53.934
     9.000   -57.661
     9.500   -61.393
    10.000   -65.128
    10.500   -68.868
    11.000   -72.612
    11.500   -76.361
    12.000   -80.115
    12.500   -83.874
    13.000   -87.638
    13.500   -91.408
    14.000   -95.184
    14.500   -98.967
    15.000  -102.755
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -84.638 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500    -0.105
     1.000    -0.682
     1.500    -1.510
     2.000    -2.965
     2.500    -4.420
     3.000    -5.877
     3.500    -7.336
     4.000    -8.795
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -11.795 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     7.188    -9.658     0.200
     7.195    -3.587     0.200
    17.119   -14.672     0.200
     3.924    -3.824     0.200
     2.548    -2.954     0.200
     3.270    -2.866     0.200
     4.113    -2.366     0.200
     4.176    -4.267     0.200
     2.567    -3.045     0.200
     3.242    -1.954     0.200
     4.171    -4.902     0.200
     4.644    -1.713     0.200
     4.771    -5.221     0.200
     5.239    -5.748     0.200
     7.198     0.744     0.200
     4.069    -2.332     0.200
     7.043    -3.319     0.200
     3.509    -5.567     0.200
     4.309    -2.323     0.200
     4.473    -5.631     0.200
     6.042     1.033     0.200
     6.299    -1.302     0.200
     2.651    -4.304     0.200
     2.651    -2.574     0.200
     3.883    -5.218     0.200
     4.104    -3.036     0.200
     4.694    -3.583     0.200
     5.825    -5.405     0.200
     6.057     0.249     0.200
     6.177    -9.272     0.200
     7.260   -10.025     0.200
    13.428     1.392     0.200
    18.263    -3.781     0.200
    21.160    -5.416     0.200
     2.948    -3.166     0.200
     4.154    -1.707     0.200
     4.666    -4.325     0.200
     4.778     0.920     0.200
     6.170    -3.815     0.200
     6.269    -3.245     0.200
     7.022    -4.276     0.200
     7.022    -4.924     0.200
    12.719    -1.701     0.200
     5.768    -5.473     0.200
     6.763    -4.407     0.200
    13.502    -4.965     0.200
    15.539    -2.540     0.200
     2.881    -3.314     0.200
     4.445    -4.287     0.200
     3.530     0.755     0.200
     4.428    -5.687     0.200
     5.503     1.224     0.200
     6.640    -1.936     0.200
     8.226    -1.868     0.200
     2.905    -2.932     0.200
     2.585    -3.644     0.200
     2.585    -3.394     0.200
     4.231    -3.239     0.200
     4.307    -0.432     0.200
     4.732    -6.235     0.200
     4.704    -3.237     0.200
     4.704    -3.663     0.200
     5.330    -8.417     0.200
     5.811    -4.408     0.200
     5.987    -6.980     0.200
     6.133    -6.894     0.200
     6.313    -8.568     0.200
     6.401    -9.452     0.200
     6.278    -5.621     0.200
     6.586    -9.620     0.200
     6.688    -8.573     0.200
     6.712    -4.483     0.200
     7.065    -8.742     0.200
     7.196    -8.473     0.200
     7.116    -7.016     0.200
     7.646    -6.384     0.200
     7.759     1.659     0.200
     8.038     0.420     0.200
     8.183    -6.640     0.200
     8.539    -4.178     0.200
     8.625    -8.313     0.200
    10.577    -8.261     0.200
    10.786    -3.792     0.200
    11.063    -2.700     0.200
    11.916    -4.115     0.200
    12.434    -0.717     0.200
     2.574    -3.187     0.200
     4.697    -2.801     0.200
     6.058    -2.446     0.200
     7.327    -1.376     0.200
    10.564    -8.500     0.200
    12.384    -2.711     0.200
     2.657    -3.394     0.200
     2.885    -3.099     0.200
     3.805    -3.251     0.200
     2.638    -4.836     0.200
     4.982    -5.399     0.200
     5.026    -6.897     0.200
     5.776    -3.950     0.200
     6.755    -4.836     0.200
     6.777    -4.078     0.200
     3.618    -3.388     0.200
     5.802    -7.821     0.200
    13.553    -9.860     0.200
    14.093    -1.939     0.200
     6.019    -4.626     0.200
    13.823    -6.307     0.200
     6.045    -3.129     0.200
     5.259    -4.079     0.200
     5.283    -4.964     0.200
     5.698    -5.788     0.200
     5.698    -4.835     0.200
    11.022    -8.038     0.200
    13.568    -6.027     0.200
    13.840    -2.199     0.200
    15.390    -3.966     0.200
     5.751    -4.233     0.200
    10.740    -8.613     0.200
     3.744    -3.001     0.200
     3.871    -5.980     0.200
     5.025    -4.239     0.200
     5.196    -6.304     0.200
     5.737    -5.921     0.200
     5.905    -4.834     0.200
     6.562    -7.108     0.200
     6.746    -4.817     0.200
     7.941    -5.367     0.200
     7.991    -3.134     0.200
     2.514    -3.072     0.200
     3.452    -0.580     0.200
     5.143    -6.160     0.200
     5.663    -5.500     0.200
     5.755    -1.666     0.200
     7.801    -3.719     0.200
    13.490    -2.751     0.200
     2.759    -4.985     0.200
     3.582    -2.610     0.200
     5.125    -7.415     0.200
     5.776    -4.249     0.200
     5.776    -5.688     0.200
     6.731    -2.618     0.200
     7.942    -7.667     0.200
     8.066   -10.082     0.200
     8.844    -6.185     0.200
     9.021    -9.031     0.200
     9.461    -9.354     0.200
    10.427   -10.936     0.200
    10.606   -10.980     0.200
    11.806    -7.837     0.200
    12.311    -8.453     0.200
    13.552    -8.037     0.200
    15.522    -3.016     0.200
    22.765    -6.321     0.200
     2.698    -4.047     0.200
     5.779    -1.898     0.200
     2.835    -5.088     0.200
     5.654    -9.005     0.200
    10.886   -10.006     0.200
    13.472    -6.886     0.200
     2.584    -4.654     0.200
     2.584    -4.880     0.200
     3.368    -4.554     0.200
     4.952    -6.573     0.200
     5.026    -4.463     0.200
     5.855    -7.257     0.200
     6.045    -5.035     0.200
     6.541    -1.323     0.200
     7.284    -4.086     0.200
     7.407    -6.661     0.200
     8.080    -5.791     0.200
     8.372    -5.813     0.200
     8.503    -6.069     0.200
     8.610     0.583     0.200
     8.899    -3.616     0.200
     8.885    -9.558     0.200
    10.614   -10.381     0.200
    13.549    -3.617     0.200
     2.703    -3.428     0.200
     4.338    -6.102     0.200
     4.611    -4.513     0.200
     3.972    -1.267     0.200
     2.638    -3.787     0.200
     2.648    -3.583     0.200
     2.873    -4.524     0.200
     4.268    -4.706     0.200
     4.268    -4.073     0.200
     5.173    -5.512     0.200
     5.188    -5.851     0.200
     5.694    -5.547     0.200
     5.694    -6.157     0.200
     5.694    -8.547     0.200
    13.524    -2.366     0.200
     2.905    -2.900     0.200
     3.103    -3.975     0.200
     3.701    -1.716     0.200
     4.334    -2.422     0.200
     4.490    -3.885     0.200
     2.505    -4.427     0.200
     2.854    -4.010     0.200
     5.158    -7.711     0.200
     5.157    -6.847     0.200
     6.501    -6.268     0.200
    10.904   -10.349     0.200
    15.392    -4.541     0.200
     4.383    -3.121     0.200
     4.486    -4.312     0.200
     5.122    -2.974     0.200
     2.576    -3.411     0.200
     2.634    -3.549     0.200
     2.641    -2.898     0.200
     2.952    -3.329     0.200
     3.256    -3.219     0.200
     3.361    -1.177     0.200
     4.169    -4.072     0.200
    13.460    -2.847     0.200
     2.571    -3.527     0.200
     2.630    -3.774     0.200
     2.637    -3.133     0.200
     2.948    -3.262     0.200
     5.190    -4.162     0.200
    11.004    -6.378     0.200
    13.457    -7.149     0.200
    13.775    -2.835     0.200
    15.291    -3.643     0.200
     2.587    -4.791     0.200
     2.649    -4.723     0.200
     2.958    -4.364     0.200
     2.958    -4.762     0.200
     4.187    -4.453     0.200
     5.209    -5.737     0.200
     5.607    -2.412     0.200
     5.607    -4.803     0.200
     5.923    -3.231     0.200
     6.862    -4.775     0.200
     6.937    -4.582     0.200
     7.172    -5.493     0.200
     7.167    -4.666     0.200
     7.283    -5.038     0.200
     2.704    -1.902     0.200
     4.438    -5.039     0.200
     4.784    -4.769     0.200
     5.133    -6.211     0.200
     5.433    -7.554     0.200
     6.252    -7.672     0.200
     6.466    -9.496     0.200
     6.752    -3.571     0.200
    12.551    -5.060     0.200
    14.621    -6.617     0.200
     4.798    -4.174     0.200
     4.826    -6.695     0.200
     2.704    -2.857     0.200
     2.698    -3.812     0.200
     2.698    -3.143     0.200
     4.332    -5.019     0.200
     4.661    -3.483     0.200
     6.292    -9.036     0.200
    10.690   -10.860     0.200
    17.131    -5.828     0.200
    22.108   -11.035     0.200
     2.702    -4.557     0.200
     4.655    -5.241     0.200
    12.407   -11.084     0.200
     3.155    -4.958     0.200
     2.878    -3.831     0.200
     5.790    -7.944     0.200
    10.915   -12.180     0.200
    13.613    -6.258     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     7.195   -41.384     0.200
     1.271    -0.594     0.200
     0.978    -0.034     0.200
     4.309   -21.823     0.200
     6.042   -36.467     0.200
     4.104   -21.536     0.200
     7.080   -42.532     0.200
     7.080   -41.282     0.200
     2.657   -11.713     0.200
     3.712   -22.420     0.200
     3.909   -20.361     0.200
     4.483   -24.008     0.200
     5.179   -30.084     0.200
     4.058   -20.515     0.200
     4.224   -25.995     0.200
     1.253    -0.602     0.200
     2.585   -10.784     0.200
     4.704   -22.584     0.200
     6.278   -37.562     0.200
     7.116   -43.040     0.200
     1.259    -0.420     0.200
     1.935    -5.301     0.200
     2.574    -9.147     0.200
     6.058   -31.455     0.200
     3.805   -19.600     0.200
    12.994   -85.957     0.200
     1.200    -1.027     0.200
     3.389   -19.940     0.200
     3.692   -22.718     0.200
     3.831   -23.811     0.200
     3.889   -22.521     0.200
     4.010   -22.228     0.200
     4.093   -24.378     0.200
     4.590   -24.193     0.200
     5.159   -30.965     0.200
     5.365   -31.089     0.200
     5.428   -31.600     0.200
    12.113   -74.640     0.200
     2.455   -10.953     0.200
     2.455   -10.464     0.200
     2.697    -9.926     0.200
     2.706   -15.137     0.200
     3.618   -17.087     0.200
     5.802   -33.192     0.200
     7.085   -39.515     0.200
    11.059   -67.314     0.200
    11.355   -71.071     0.200
    11.894   -74.252     0.200
    12.080   -76.174     0.200
    12.503   -87.602     0.200
    12.539   -80.096     0.200
    12.592   -80.042     0.200
    12.623   -81.209     0.200
    13.553   -95.309     0.200
    13.749   -88.795     0.200
    14.177   -91.854     0.200
    15.560  -107.306     0.200
     2.896   -16.390     0.200
     3.798   -18.658     0.200
     0.986     0.359     0.200
     2.975   -15.914     0.200
     3.463   -15.452     0.200
     4.037   -21.826     0.200
     4.173   -25.586     0.200
     4.225   -21.758     0.200
     4.353   -24.484     0.200
     4.439   -23.330     0.200
     4.340   -20.148     0.200
     4.725   -25.350     0.200
     5.505   -31.122     0.200
     5.389   -27.982     0.200
     6.651   -34.436     0.200
     6.835   -34.869     0.200
    12.213   -83.864     0.200
     2.653   -10.373     0.200
     2.697    -9.923     0.200
     2.921   -16.694     0.200
     1.280     0.714     0.200
     1.485    -3.322     0.200
     3.665   -18.483     0.200
     1.154    -0.876     0.200
     1.168     0.031     0.200
     3.730   -20.086     0.200
     4.049   -18.645     0.200
     4.131   -21.658     0.200
     5.196   -28.855     0.200
     5.737   -30.492     0.200
     7.991   -49.896     0.200
     2.858   -15.147     0.200
     2.858   -15.362     0.200
     3.452   -16.141     0.200
     3.618   -18.216     0.200
     3.937   -23.295     0.200
     4.078   -24.350     0.200
     4.337   -25.419     0.200
     4.375   -20.642     0.200
     4.826   -27.757     0.200
     5.338   -29.869     0.200
     5.402   -31.810     0.200
     5.610   -31.161     0.200
     5.663   -26.739     0.200
     5.663   -32.890     0.200
     5.674   -31.196     0.200
     2.759   -11.077     0.200
     2.759   -14.438     0.200
     3.498   -21.124     0.200
     3.942   -23.792     0.200
     3.996   -22.285     0.200
     4.208   -25.521     0.200
     4.699   -25.051     0.200
     5.275   -31.128     0.200
     5.480   -30.464     0.200
     5.776   -30.774     0.200
     7.942   -49.177     0.200
     8.437   -50.717     0.200
     2.698   -13.144     0.200
     2.698   -13.820     0.200
     3.472   -17.982     0.200
     3.747   -22.516     0.200
     3.885   -20.215     0.200
     4.149   -23.911     0.200
     5.216   -30.639     0.200
     5.779   -31.648     0.200
     6.237   -41.731     0.200
     7.967   -51.233     0.200
     1.929    -6.959     0.200
     2.835   -14.613     0.200
     3.618   -21.263     0.200
     3.918   -22.849     0.200
     5.382   -33.066     0.200
     5.654   -30.155     0.200
     5.654   -32.195     0.200
     7.801   -48.547     0.200
     8.473   -52.406     0.200
     9.315   -59.514     0.200
     9.578   -61.358     0.200
     9.664   -64.854     0.200
     9.819   -65.082     0.200
     2.584   -12.529     0.200
     2.584   -13.052     0.200
     2.584   -11.560     0.200
     3.305   -19.497     0.200
     3.613   -21.591     0.200
     3.803   -20.334     0.200
     3.929   -19.945     0.200
     4.016   -22.544     0.200
     5.016   -29.786     0.200
     5.083   -30.497     0.200
     5.347   -28.885     0.200
     5.855   -31.332     0.200
     9.562   -60.519     0.200
     9.629   -64.046     0.200
     9.896   -65.599     0.200
     9.980   -64.032     0.200
    10.136   -64.591     0.200
     1.681    -2.832     0.200
     1.802    -3.660     0.200
     2.088    -6.036     0.200
     2.349    -8.250     0.200
     2.967   -12.848     0.200
     1.301    -0.305     0.200
     1.482    -1.626     0.200
     1.277    -1.522     0.200
     1.611    -3.673     0.200
     1.943    -5.886     0.200
     2.194    -8.588     0.200
     2.203    -8.117     0.200
     3.145   -15.944     0.200
     2.537   -10.026     0.200
     2.873   -15.352     0.200
     2.873   -15.586     0.200
     3.181   -13.706     0.200
     3.479   -16.459     0.200
     3.636   -21.876     0.200
     4.080   -24.599     0.200
     4.259   -26.599     0.200
     4.711   -26.661     0.200
     4.659   -24.324     0.200
     5.047   -27.544     0.200
     5.047   -24.540     0.200
     5.408   -31.259     0.200
     5.439   -31.628     0.200
     7.279   -43.395     0.200
     1.529    -2.890     0.200
     1.312     0.139     0.200
     1.436     0.245     0.200
     1.466    -0.350     0.200
     2.227    -7.096     0.200
     2.213    -6.948     0.200
     2.491    -9.206     0.200
     3.286   -12.821     0.200
     1.100     0.219     0.200
     2.854   -14.642     0.200
     2.854   -15.109     0.200
     3.456   -17.991     0.200
     3.931   -23.294     0.200
     4.072   -22.875     0.200
     4.250   -24.248     0.200
     5.021   -26.656     0.200
     5.397   -31.632     0.200
     5.667   -28.328     0.200
     1.826    -4.341     0.200
     2.380    -7.254     0.200
     2.887    -9.427     0.200
     3.665   -14.945     0.200
     4.383   -19.910     0.200
     1.218    -1.124     0.200
     2.576   -13.241     0.200
     2.952   -14.353     0.200
     2.952   -14.518     0.200
     3.361   -17.177     0.200
     4.049   -23.958     0.200
     4.192   -25.818     0.200
     1.322    -3.069     0.200
     2.571   -14.068     0.200
     2.948   -16.321     0.200
     3.361   -19.625     0.200
     4.045   -24.331     0.200
     4.188   -25.337     0.200
     5.190   -32.543     0.200
     5.328   -35.057     0.200
     5.508   -35.859     0.200
    12.208   -83.391     0.200
    13.457   -92.043     0.200
     1.217    -1.821     0.200
     1.216    -1.883     0.200
     3.377   -16.762     0.200
     3.749   -21.544     0.200
     4.250   -25.531     0.200
     4.622   -28.566     0.200
     4.953   -29.527     0.200
     4.937   -30.771     0.200
     4.944   -30.587     0.200
     5.513   -34.804     0.200
     6.430   -40.542     0.200
     7.452   -50.007     0.200
     7.936   -52.236     0.200
     8.178   -57.935     0.200
     8.733   -59.902     0.200
     8.744   -61.978     0.200
     8.991   -61.690     0.200
     9.127   -64.782     0.200
     9.459   -64.584     0.200
     9.544   -65.919     0.200
     9.700   -68.810     0.200
     1.548    -3.850     0.200
     3.834   -18.971     0.200
     4.047   -17.699     0.200
     4.366   -20.184     0.200
     4.684   -23.020     0.200
     4.394   -22.541     0.200
     1.455    -1.398     0.200
     1.565    -2.431     0.200
     2.408    -7.583     0.200
     2.584    -9.267     0.200
     2.704   -11.258     0.200
     3.880   -19.848     0.200
     4.078   -20.483     0.200
     4.275   -22.172     0.200
     4.413   -22.020     0.200
     4.657   -22.593     0.200
     4.848   -25.952     0.200
     5.022   -27.603     0.200
     5.917   -34.040     0.200
     6.104   -35.275     0.200
     2.584    -8.458     0.200
     4.089   -21.160     0.200
     4.422   -22.219     0.200
     1.460    -1.379     0.200
     1.454    -1.176     0.200
     1.478    -1.511     0.200
     1.167    -0.242     0.200
     1.167    -0.604     0.200
     1.344    -1.493     0.200
     3.155   -17.133     0.200
     4.471   -24.772     0.200
     4.654   -24.956     0.200
     4.697   -25.537     0.200
     4.844   -25.726     0.200
     5.406   -29.673     0.200
     6.857   -43.040     0.200
     7.950   -48.787     0.200
     8.293   -50.246     0.200
     2.878   -14.081     0.200
     5.790   -32.772     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.556     0.159     0.200
     0.557     0.127     0.200
     0.495     0.927     0.200
     0.532     0.637     0.200
     0.957     0.964     0.200
     1.103    -0.442     0.200
     1.898    -1.854     0.200
     0.551     0.043     0.200
     0.784    -0.538     0.200
     0.952     0.528     0.200
     1.300    -0.888     0.200
     0.308     0.170     0.200
     0.989    -0.707     0.200
     2.080    -1.782     0.200
     0.420     1.250     0.200
     0.494     0.529     0.200
     0.759     0.101     0.200
     1.060    -1.128     0.200
     0.662    -0.024     0.200
     0.684    -1.489     0.200
     0.972     0.657     0.200
     1.230    -1.019     0.200
     0.382     0.284     0.200
     0.441     0.240     0.200
     1.216    -1.694     0.200
     1.184    -0.490     0.200
     1.492    -2.020     0.200
     2.657    -5.614     0.200
     0.218     2.370     0.200
     0.757    -0.041     0.200
     0.868    -0.174     0.200
     0.824    -0.840     0.200
     0.972    -0.538     0.200
     0.991    -0.022     0.200
     1.527    -1.257     0.200
     2.881    -5.264     0.200
     4.280   -10.861     0.200
     5.064   -14.210     0.200
     0.586     0.637     0.200
     0.866     0.042     0.200
     1.202    -1.870     0.200
     2.467    -4.024     0.200
     0.219     2.619     0.200
     0.519     0.400     0.200
     0.609     0.482     0.200
     0.663    -0.240     0.200
     0.926    -0.654     0.200
     1.211    -2.244     0.200
     3.998   -11.403     0.200
     4.224   -10.675     0.200
     4.564   -12.122     0.200
     4.623   -11.774     0.200
     0.404     1.391     0.200
     0.866    -0.873     0.200
     0.741    -0.002     0.200
     0.867     0.071     0.200
     0.905    -0.612     0.200
     4.757    -8.364     0.200
     5.696    -9.023     0.200
     6.529   -10.231     0.200
     0.417     1.361     0.200
     0.559     0.569     0.200
     0.751    -0.067     0.200
     0.751     0.153     0.200
     0.887    -0.560     0.200
     0.887    -0.980     0.200
     0.887    -0.978     0.200
     0.851    -0.015     0.200
     0.921     0.371     0.200
     1.259    -0.870     0.200
     0.637     0.255     0.200
     0.383     1.118     0.200
     0.414    -0.566     0.200
     0.398     0.877     0.200
     0.398     0.018     0.200
     0.457     0.070     0.200
     0.630    -0.321     0.200
     0.630    -0.470     0.200
     0.691    -0.416     0.200
     0.395     0.410     0.200
     0.395     0.518     0.200
     0.450     0.424     0.200
     2.706    -6.563     0.200
     0.595    -0.560     0.200
     0.595    -0.682     0.200
     0.632     0.038     0.200
     0.597     0.528     0.200
     0.644    -0.454     0.200
     0.619     0.084     0.200
     0.661     0.339     0.200
     0.306     0.167     0.200
     0.306     0.282     0.200
     0.323     0.617     0.200
     0.324     0.334     0.200
     0.538    -0.404     0.200
     0.759     0.381     0.200
     2.040    -4.073     0.200
     2.507    -5.784     0.200
     2.975    -6.360     0.200
     0.350     0.188     0.200
     0.351    -0.371     0.200
     0.591    -0.037     0.200
     0.625     0.544     0.200
     0.430    -0.344     0.200
     0.430     0.514     0.200
     0.455     0.657     0.200
     0.456     0.032     0.200
     0.615    -0.168     0.200
     0.717     0.516     0.200
     1.122    -2.112     0.200
     2.150    -3.567     0.200
     2.967    -7.037     0.200
     2.967    -5.763     0.200
     0.357     0.958     0.200
     0.351     0.118     0.200
     0.351     0.270     0.200
     0.410     0.290     0.200
     0.410     0.068     0.200
     0.454    -0.206     0.200
     0.611    -0.416     0.200
     0.897    -1.240     0.200
     1.919    -2.053     0.200
     2.664    -5.715     0.200
     0.239     0.411     0.200
     0.239     0.900     0.200
     0.295     0.589     0.200
     0.277     0.520     0.200
     0.278     0.357     0.200
     0.423    -0.546     0.200
     0.661     0.105     0.200
     0.817    -0.802     0.200
     0.998    -1.586     0.200
     1.103    -1.705     0.200
     1.949    -3.249     0.200
     2.858    -5.942     0.200
     0.239     0.986     0.200
     0.357     0.383     0.200
     0.357     0.628     0.200
     0.437     0.327     0.200
     0.528     0.156     0.200
     0.695    -0.584     0.200
     0.967    -0.756     0.200
     1.142    -1.334     0.200
     1.997    -4.117     0.200
     2.759    -5.638     0.200
     3.806    -7.530     0.200
     0.193     1.153     0.200
     0.376     0.365     0.200
     0.376     0.357     0.200
     0.409     0.098     0.200
     0.431     0.495     0.200
     0.432     0.458     0.200
     0.635    -0.749     0.200
     0.910    -0.829     0.200
     1.971    -2.779     0.200
     2.698    -5.289     0.200
     0.228     1.102     0.200
     0.228     0.851     0.200
     0.271     1.189     0.200
     0.399     0.475     0.200
     0.797    -0.173     0.200
     1.085    -1.589     0.200
     0.214     1.251     0.200
     0.336     0.563     0.200
     0.510    -0.515     0.200
     0.493    -0.022     0.200
     0.493     0.118     0.200
     1.296    -2.247     0.200
     1.990    -3.170     0.200
     0.474    -0.859     0.200
     0.659    -1.442     0.200
     0.660    -0.230     0.200
     0.696    -0.498     0.200
     0.734    -0.119     0.200
     0.937    -0.638     0.200
     0.978     0.141     0.200
     1.210    -0.287     0.200
     1.318    -0.611     0.200
     1.301    -0.880     0.200
     1.446    -1.017     0.200
     0.690     1.384     0.200
     0.759    -0.028     0.200
     0.847    -0.792     0.200
     0.919    -0.745     0.200
     0.977    -1.055     0.200
     0.989    -0.735     0.200
     1.151    -0.986     0.200
     1.600    -1.782     0.200
     2.046    -3.116     0.200
     0.197     1.452     0.200
     0.350    -0.127     0.200
     0.813    -0.270     0.200
     0.898    -0.152     0.200
     1.087    -0.645     0.200
     1.145    -1.055     0.200
     1.428    -2.118     0.200
     1.483    -2.378     0.200
     1.857    -2.900     0.200
     0.314     0.810     0.200
     0.271     0.852     0.200
     0.271     0.749     0.200
     0.454     0.375     0.200
     1.104    -1.841     0.200
     1.020    -0.333     0.200
     1.329    -3.142     0.200
     1.698    -2.448     0.200
     1.844    -2.926     0.200
     1.983    -2.579     0.200
     2.457    -6.496     0.200
     0.238     0.743     0.200
     0.644    -0.945     0.200
     1.005    -0.229     0.200
     1.093    -0.595     0.200
     1.091    -0.971     0.200
     1.249    -0.778     0.200
     1.529    -0.847     0.200
     1.682    -2.249     0.200
     1.682    -2.025     0.200
     1.907    -1.918     0.200
     1.962    -1.631     0.200
     1.976    -0.934     0.200
     2.185    -2.737     0.200
     2.397    -2.172     0.200
     0.514    -1.354     0.200
     0.735    -0.753     0.200
     1.125     0.729     0.200
     1.412    -1.268     0.200
     1.412    -0.756     0.200
     0.242     0.630     0.200
     0.242     0.762     0.200
     0.242     0.823     0.200
     0.422     0.046     0.200
     0.655     0.509     0.200
     0.655    -0.350     0.200
     0.745    -0.352     0.200
     1.003    -0.881     0.200
     1.811    -2.882     0.200
     1.811    -3.321     0.200
     2.121    -3.897     0.200
     2.430    -4.113     0.200
     2.854    -5.400     0.200
     0.518     0.550     0.200
     0.625    -0.489     0.200
     0.696    -0.149     0.200
     0.835    -0.694     0.200
     1.017     0.167     0.200
     1.033     0.258     0.200
     1.408    -1.395     0.200
     1.940    -3.198     0.200
     0.201     1.686     0.200
     0.389     0.907     0.200
     0.466     0.828     0.200
     0.656     0.530     0.200
     0.775    -0.082     0.200
     0.893    -0.668     0.200
     1.327    -1.615     0.200
     1.831    -2.173     0.200
     1.937    -2.273     0.200
     2.178    -3.062     0.200
     0.198     2.304     0.200
     0.385     0.729     0.200
     0.461     1.263     0.200
     0.655     0.031     0.200
     0.893    -0.944     0.200
     0.772     0.024     0.200
     1.214    -2.785     0.200
     1.827    -2.331     0.200
     1.933    -2.301     0.200
     2.173    -2.848     0.200
     0.219     1.548     0.200
     0.219     1.499     0.200
     0.219     1.397     0.200
     0.394     1.013     0.200
     0.479     0.893     0.200
     0.479     0.995     0.200
     0.774     0.454     0.200
     0.906     0.009     0.200
     0.906    -0.335     0.200
     1.341    -0.626     0.200
     1.341    -1.861     0.200
     1.847    -2.504     0.200
     1.954    -2.415     0.200
     2.190    -3.844     0.200
     2.426    -7.117     0.200
     0.465     0.766     0.200
     0.711     0.628     0.200
     0.712    -0.614     0.200
     0.712    -0.454     0.200
     0.712    -1.315     0.200
     0.712    -1.593     0.200
     1.045    -0.676     0.200
     1.045    -0.145     0.200
     1.188    -0.391     0.200
     1.508    -1.184     0.200
     1.508    -2.012     0.200
     1.571    -1.928     0.200
     2.489    -2.982     0.200
     0.138     1.501     0.200
     0.320     0.939     0.200
     0.298     1.534     0.200
     0.753     0.257     0.200
     1.126    -1.200     0.200
     1.334    -0.698     0.200
     1.374    -2.073     0.200
     1.723    -2.618     0.200
     1.965    -3.977     0.200
     0.284     0.653     0.200
     0.568     0.312     0.200
     0.691     0.089     0.200
     0.765    -0.225     0.200
     0.765    -0.613     0.200
     0.796    -0.247     0.200
     0.853    -0.609     0.200
     0.853    -0.978     0.200
     0.915     0.343     0.200
     0.915    -0.036     0.200
     0.995    -0.505     0.200
     1.306    -0.451     0.200
     1.481    -1.898     0.200
     1.605    -1.891     0.200
     1.605    -2.080     0.200
     1.824    -2.564     0.200
     0.549     0.487     0.200
     0.706    -0.058     0.200
     0.757     0.721     0.200
     0.777    -0.411     0.200
     0.839    -0.355     0.200
     0.932    -0.609     0.200
     1.303    -1.578     0.200
     1.500    -2.092     0.200
     1.582    -2.698     0.200
     1.606    -2.404     0.200
     0.685     0.201     0.200
     0.761    -0.765     0.200
     0.761     0.434     0.200
     0.852    -0.123     0.200
     0.852    -0.082     0.200
     0.913    -0.123     0.200
     1.599    -1.312     0.200
     1.599    -1.831     0.200
     1.830    -3.006     0.200
     5.442    -8.621     0.200
     0.287     2.033     0.200
     0.688     0.442     0.200
     0.766     0.033     0.200
     0.766    -0.287     0.200
     0.855    -0.799     0.200
     0.855    -0.517     0.200
     0.855    -0.598     0.200
     0.856    -0.516     0.200
     0.911    -0.346     0.200
     0.911    -0.233     0.200
     0.997    -0.689     0.200
     1.561    -1.180     0.200
     1.605    -1.609     0.200
     1.605    -1.988     0.200
     1.760    -1.425     0.200
     0.294     0.386     0.200
     0.748    -0.577     0.200
     0.748    -0.407     0.200
     0.748     0.045     0.200
     0.749     0.315     0.200
     0.854    -0.173     0.200
     0.854    -0.402     0.200
     1.034    -0.495     0.200
     1.464    -1.247     0.200
     0.367    -1.264     0.200
     0.367    -1.274     0.200
EOF
gmt end
