#!/bin/bash
gmt begin haida1.26_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional haida1.26'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.553
    15.000    42.274
    15.500    41.993
    16.000    41.709
    16.500    41.419
    17.000    41.123
    17.500    40.818
    18.000    40.503
    18.500    40.176
    19.000    39.834
    19.500    39.476
    20.000    39.098
    20.500    38.700
    21.000    38.277
    21.500    37.829
    22.000    37.353
    22.500    36.847
    23.000    36.310
    23.500    35.739
    24.000    34.520
    24.500    33.248
    25.000    31.967
    25.500    30.675
    26.000    29.372
    26.500    28.058
    27.000    26.730
    27.500    25.387
    28.000    24.024
    28.500    22.645
    29.000    21.255
    29.500    19.857
    30.000    18.450
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.024 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     7.341
     1.500     8.504
     2.000     9.667
     2.500    10.831
     3.000    11.994
     3.500    13.157
     4.000    14.319
     4.500    15.480
     5.000    16.640
     5.500    17.799
     6.000    18.956
     6.500    20.112
     7.000    21.267
     7.500    22.420
     8.000    23.570
     8.500    24.720
     9.000    25.867
     9.500    27.012
    10.000    28.154
    10.500    29.265
    11.000    30.210
    11.500    31.139
    12.000    32.044
    12.500    32.922
    13.000    33.771
    13.500    34.591
    14.000    35.379
    14.500    36.133
    15.000    36.852
    15.500    37.538
    16.000    38.134
    16.500    38.646
    17.000    39.097
    17.500    39.679
    18.000    40.026
    18.500    40.315
    19.000    40.545
    19.500    40.718
    20.000    40.832
    20.500    40.887
    21.000    40.883
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    30.771 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    14.309
     3.000    18.416
     3.500    22.524
     4.000    26.632
     4.500    30.739
     5.000    34.847
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    29.632 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.307
     1.000     6.341
     1.500     8.636
     2.000    10.833
     2.500    13.030
     3.000    15.225
     3.500    17.420
     4.000    19.614
     4.500    21.807
     5.000    23.999
     5.500    26.190
     6.000    28.379
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    21.999 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    21.709
     1.500    28.024
     2.000    34.340
     2.500    40.656
     3.000    46.972
     3.500    53.288
     4.000    59.600
     4.500    65.911
     5.000    72.222
     5.500    78.529
     6.000    84.834
     6.500    91.138
     7.000    97.438
     7.500   103.736
     8.000   110.031
     8.500   116.321
     9.000   122.609
     9.500   128.892
    10.000   135.172
    10.500   141.447
    11.000   147.718
    11.500   153.984
    12.000   160.245
    12.500   166.501
    13.000   172.752
    13.500   178.997
    14.000   185.236
    14.500   191.468
    15.000   197.695
    15.500   203.914
    16.000   210.127
    16.500   216.333
    17.000   222.531
    17.500   234.445
    18.000   240.716
    18.500   246.975
    19.000   253.221
    19.500   259.454
    20.000   265.673
    20.500   271.877
    21.000   278.067
    21.500   284.241
    22.000   290.400
    22.500   296.543
    23.000   302.669
    23.500   308.779
    24.000   314.871
    24.500   320.946
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    57.600 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     9.910
     1.000    19.348
     1.500    28.535
     2.000    37.095
     2.500    45.655
     3.000    54.213
     3.500    62.769
     4.000    71.325
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    60.769 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    46.796
     3.000    56.735
     3.500    66.674
     4.000    76.614
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    58.735 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    21.160   500.822     0.150
    18.022    53.925     0.150
    21.567   278.881     0.150
    16.065   334.909     0.150
    17.037    44.967     0.150
    17.419   321.967     0.150
    17.758    47.095     0.150
    15.336   343.902     0.150
    17.808    47.833     0.150
    18.559    48.000     0.150
    14.999    43.924     0.150
    15.197    43.409     0.150
    17.515    46.108     0.150
    17.932   316.427     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.547    46.942     0.200
    15.030    46.393     0.200
    15.793    45.301     0.200
    16.447    40.860     0.200
    16.660    42.077     0.200
    17.347    42.562     0.200
    17.526    41.476     0.200
    17.846    41.536     0.200
    18.171    43.450     0.200
    20.659    39.407     0.200
    21.168    39.974     0.200
    21.398    40.282     0.200
    21.756    41.106     0.200
    21.792    40.690     0.200
    21.967    37.947     0.200
    22.181    39.148     0.200
    22.566    39.652     0.200
    22.934    39.362     0.200
    22.945    37.939     0.200
    23.010    36.470     0.200
    23.616    37.403     0.200
    23.890    37.202     0.200
    25.409    31.974     0.200
    25.730    32.227     0.200
    25.733    32.493     0.200
    26.164    31.664     0.200
    29.825    21.446     0.200
    14.531    40.204     0.200
    14.869    44.459     0.200
    17.351    44.092     0.200
    20.739    37.456     0.200
    22.931    38.681     0.200
    22.945    40.046     0.200
    14.473    44.246     0.200
    17.672    43.203     0.200
    22.964    37.945     0.200
    14.792    42.495     0.200
    15.636    42.972     0.200
    21.160    37.623     0.200
    21.856    40.307     0.200
    22.083    35.548     0.200
    21.500    37.669     0.200
    22.153    40.474     0.200
    22.459    38.876     0.200
    23.050    36.688     0.200
    15.539    39.535     0.200
    17.240    39.539     0.200
    17.377    41.865     0.200
    22.070    38.058     0.200
    29.849    19.165     0.200
    18.147    43.640     0.200
    17.020    42.499     0.200
    17.827    43.017     0.200
    18.194    41.523     0.200
    18.194    44.533     0.200
    20.256    38.933     0.200
    21.111    37.203     0.200
    21.552    38.519     0.200
    22.018    36.796     0.200
    22.174    38.087     0.200
    23.993    35.400     0.200
    29.781    19.644     0.200
    18.181    44.214     0.200
    21.380    40.674     0.200
    24.811    34.344     0.200
    14.307    45.211     0.200
    15.012    44.715     0.200
    18.441    42.432     0.200
    18.852    43.549     0.200
    19.068    43.542     0.200
    19.340    43.281     0.200
    19.340    43.072     0.200
    19.394    42.323     0.200
    19.617    42.620     0.200
    19.617    42.491     0.200
    19.627    42.741     0.200
    19.868    41.969     0.200
    19.980    40.050     0.200
    20.095    41.743     0.200
    20.068    42.041     0.200
    20.186    41.495     0.200
    20.251    42.315     0.200
    20.237    41.615     0.200
    20.558    41.643     0.200
    20.643    38.843     0.200
    20.554    41.808     0.200
    20.590    41.188     0.200
    20.704    40.261     0.200
    20.704    41.123     0.200
    20.672    41.366     0.200
    20.780    41.255     0.200
    21.061    41.193     0.200
    21.151    40.848     0.200
    21.188    40.907     0.200
    21.450    39.233     0.200
    21.426    40.631     0.200
    21.461    41.391     0.200
    21.434    41.002     0.200
    21.454    40.391     0.200
    21.505    39.590     0.200
    21.567    40.240     0.200
    21.578    39.693     0.200
    21.646    39.428     0.200
    21.680    39.554     0.200
    21.711    38.307     0.200
    21.733    38.685     0.200
    21.732    40.114     0.200
    21.757    39.147     0.200
    21.761    40.193     0.200
    21.844    39.770     0.200
    22.071    39.289     0.200
    22.013    39.853     0.200
    22.186    39.436     0.200
    22.186    38.454     0.200
    22.188    39.389     0.200
    22.193    39.232     0.200
    22.207    39.695     0.200
    22.238    39.111     0.200
    22.731    38.507     0.200
    22.731    37.888     0.200
    22.811    39.152     0.200
    22.845    38.142     0.200
    23.194    37.939     0.200
    23.194    38.093     0.200
    23.176    37.505     0.200
    23.904    36.761     0.200
    23.904    36.603     0.200
    24.151    37.092     0.200
    24.599    35.724     0.200
    25.073    32.743     0.200
    25.233    33.201     0.200
    25.527    32.449     0.200
    25.527    32.168     0.200
    29.799    20.452     0.200
    14.115    38.981     0.200
    14.223    42.183     0.200
    14.273    43.084     0.200
    14.879    39.477     0.200
    15.068    39.944     0.200
    15.859    41.857     0.200
    16.039    42.789     0.200
    16.212    41.620     0.200
    16.220    41.993     0.200
    16.309    43.386     0.200
    16.516    40.740     0.200
    16.607    40.362     0.200
    16.717    41.724     0.200
    16.836    43.497     0.200
    16.901    43.219     0.200
    16.920    43.625     0.200
    16.920    43.496     0.200
    16.920    42.559     0.200
    16.974    43.083     0.200
    16.990    40.800     0.200
    17.086    42.201     0.200
    17.100    42.150     0.200
    17.100    43.529     0.200
    17.112    43.221     0.200
    17.357    42.327     0.200
    17.357    42.714     0.200
    17.768    43.601     0.200
    17.772    43.860     0.200
    17.814    44.120     0.200
    17.874    41.194     0.200
    17.874    41.515     0.200
    17.856    43.111     0.200
    17.856    42.275     0.200
    18.218    42.979     0.200
    18.218    41.985     0.200
    18.218    40.848     0.200
    18.218    42.977     0.200
    18.289    40.179     0.200
    18.346    42.038     0.200
    20.532    39.085     0.200
    21.118    38.664     0.200
    21.193    40.367     0.200
    21.197    39.829     0.200
    21.271    39.812     0.200
    21.317    39.503     0.200
    21.476    40.982     0.200
    21.476    39.755     0.200
    21.477    39.926     0.200
    21.486    39.643     0.200
    21.519    40.888     0.200
    21.583    40.592     0.200
    21.594    39.575     0.200
    21.626    39.937     0.200
    21.635    39.702     0.200
    21.637    39.080     0.200
    21.739    38.806     0.200
    21.740    41.089     0.200
    21.770    39.810     0.200
    21.792    40.034     0.200
    21.792    40.520     0.200
    21.823    38.625     0.200
    21.903    39.327     0.200
    21.909    38.727     0.200
    22.050    39.762     0.200
    22.056    36.851     0.200
    22.115    38.445     0.200
    22.652    34.128     0.200
    22.652    35.343     0.200
    22.652    32.632     0.200
    23.246    37.224     0.200
    23.302    37.220     0.200
    23.402    35.352     0.200
    23.416    35.778     0.200
    23.416    36.004     0.200
    23.949    35.706     0.200
    24.236    35.376     0.200
    24.622    34.688     0.200
    25.009    30.635     0.200
    25.201    32.337     0.200
    25.592    29.511     0.200
    25.592    32.660     0.200
    25.592    31.543     0.200
    25.646    33.881     0.200
    25.685    30.425     0.200
    26.209    29.618     0.200
    26.579    28.190     0.200
    26.906    28.778     0.200
    29.829    19.547     0.200
    29.829    19.218     0.200
    14.354    42.840     0.200
    15.111    43.806     0.200
    15.686    43.437     0.200
    15.865    44.877     0.200
    16.622    43.658     0.200
    17.232    41.790     0.200
    17.695    41.615     0.200
    18.234    43.977     0.200
    19.503    42.998     0.200
    20.034    42.271     0.200
    20.035    42.190     0.200
    20.525    41.348     0.200
    20.441    41.358     0.200
    20.369    42.373     0.200
    20.431    42.070     0.200
    20.517    41.398     0.200
    20.629    41.832     0.200
    21.256    40.927     0.200
    21.290    42.159     0.200
    21.354    40.418     0.200
    21.287    40.216     0.200
    21.396    40.496     0.200
    21.406    40.937     0.200
    21.407    39.517     0.200
    21.354    40.087     0.200
    21.460    39.418     0.200
    21.475    40.394     0.200
    21.509    39.664     0.200
    21.540    39.956     0.200
    21.563    39.838     0.200
    21.587    39.204     0.200
    21.592    40.315     0.200
    21.673    40.687     0.200
    21.679    40.592     0.200
    21.820    40.527     0.200
    21.772    40.794     0.200
    21.892    39.997     0.200
    22.100    42.681     0.200
    22.563    39.066     0.200
    22.525    39.595     0.200
    22.490    39.509     0.200
    22.681    37.708     0.200
    23.019    38.808     0.200
    23.139    38.844     0.200
    23.178    39.191     0.200
    23.410    37.571     0.200
    23.997    37.484     0.200
    25.360    33.397     0.200
    25.905    33.389     0.200
    26.945    28.293     0.200
    15.870    43.590     0.200
    15.961    43.556     0.200
    16.374    42.607     0.200
    16.779    41.456     0.200
    16.897    42.173     0.200
    16.900    42.980     0.200
    16.940    44.166     0.200
    16.985    42.550     0.200
    16.982    42.730     0.200
    17.035    42.601     0.200
    17.148    41.743     0.200
    17.173    43.502     0.200
    17.395    43.824     0.200
    17.451    43.205     0.200
    17.840    41.641     0.200
    17.840    42.883     0.200
    17.991    43.237     0.200
    18.279    42.764     0.200
    18.279    43.042     0.200
    18.279    42.941     0.200
    18.361    39.966     0.200
    19.207    39.322     0.200
    20.014    40.775     0.200
    20.060    40.653     0.200
    20.232    40.555     0.200
    20.228    40.705     0.200
    20.321    39.621     0.200
    20.368    40.907     0.200
    20.492    37.533     0.200
    20.618    39.490     0.200
    20.618    39.166     0.200
    20.711    40.286     0.200
    20.711    40.560     0.200
    20.728    40.371     0.200
    20.804    40.056     0.200
    21.089    38.899     0.200
    21.225    39.651     0.200
    21.229    39.898     0.200
    21.254    39.978     0.200
    21.411    38.299     0.200
    21.411    38.147     0.200
    21.538    40.827     0.200
    21.540    38.940     0.200
    21.575    39.472     0.200
    21.608    39.179     0.200
    21.641    38.887     0.200
    21.681    39.555     0.200
    21.691    40.025     0.200
    21.760    37.903     0.200
    21.794    40.013     0.200
    21.795    36.829     0.200
    21.825    36.157     0.200
    22.105    37.979     0.200
    22.173    37.353     0.200
    22.170    38.540     0.200
    22.345    37.716     0.200
    22.724    34.702     0.200
    22.724    36.748     0.200
    22.812    38.363     0.200
    22.812    37.492     0.200
    23.302    36.973     0.200
    23.489    35.413     0.200
    24.007    36.800     0.200
    24.284    35.903     0.200
    25.271    31.580     0.200
    25.645    29.804     0.200
    25.645    32.932     0.200
    25.737    33.036     0.200
    26.008    31.555     0.200
    26.281    29.391     0.200
    26.281    28.548     0.200
    26.978    27.502     0.200
    28.192    23.954     0.200
    29.890    19.409     0.200
    29.890    18.800     0.200
    14.489    41.180     0.200
    14.491    42.231     0.200
    14.519    43.856     0.200
    14.657    41.250     0.200
    15.228    43.994     0.200
    15.430    40.950     0.200
    15.364    43.038     0.200
    16.065    44.878     0.200
    16.247    42.552     0.200
    16.131    43.381     0.200
    16.152    44.080     0.200
    16.329    43.147     0.200
    16.540    43.397     0.200
    16.559    44.351     0.200
    16.760    42.202     0.200
    16.814    42.077     0.200
    16.814    42.675     0.200
    16.929    41.183     0.200
    16.999    41.293     0.200
    16.901    45.389     0.200
    17.029    43.146     0.200
    16.960    43.184     0.200
    16.967    43.580     0.200
    17.118    44.705     0.200
    17.145    41.896     0.200
    17.145    42.951     0.200
    17.166    44.228     0.200
    17.149    44.038     0.200
    17.283    43.897     0.200
    17.294    43.535     0.200
    17.304    43.399     0.200
    17.337    42.586     0.200
    17.826    43.097     0.200
    17.924    41.159     0.200
    17.845    44.423     0.200
    17.847    44.385     0.200
    18.135    41.100     0.200
    18.135    42.584     0.200
    18.098    42.273     0.200
    18.412    40.291     0.200
    18.481    40.935     0.200
    18.624    42.464     0.200
    19.265    41.874     0.200
    19.514    42.486     0.200
    19.556    42.440     0.200
    19.638    41.378     0.200
    19.771    42.418     0.200
    19.789    42.512     0.200
    20.078    41.432     0.200
    20.211    39.354     0.200
    20.211    40.057     0.200
    20.112    41.779     0.200
    20.226    42.228     0.200
    20.286    41.688     0.200
    20.350    41.129     0.200
    20.379    41.652     0.200
    20.460    41.334     0.200
    20.405    41.516     0.200
    20.453    42.053     0.200
    20.717    40.817     0.200
    20.717    41.356     0.200
    20.780    40.944     0.200
    20.923    40.098     0.200
    20.923    40.247     0.200
    20.971    41.110     0.200
    20.949    41.460     0.200
    21.118    40.282     0.200
    21.214    40.526     0.200
    21.239    40.718     0.200
    21.315    40.755     0.200
    21.341    40.544     0.200
    21.632    38.662     0.200
    21.632    38.881     0.200
    21.637    41.301     0.200
    21.676    38.917     0.200
    21.676    39.269     0.200
    21.684    39.141     0.200
    21.591    39.820     0.200
    21.673    40.227     0.200
    21.592    40.425     0.200
    21.621    40.555     0.200
    21.697    40.442     0.200
    21.736    40.267     0.200
    21.778    41.513     0.200
    21.791    39.946     0.200
    21.789    39.116     0.200
    21.841    39.464     0.200
    21.857    39.792     0.200
    21.891    39.017     0.200
    21.891    38.770     0.200
    21.922    40.128     0.200
    21.943    39.957     0.200
    21.945    40.054     0.200
    21.969    39.518     0.200
    21.971    40.811     0.200
    22.055    40.073     0.200
    22.062    39.034     0.200
    22.089    39.116     0.200
    22.082    39.962     0.200
    22.203    39.729     0.200
    22.175    39.482     0.200
    22.173    38.723     0.200
    22.291    38.306     0.200
    22.344    40.224     0.200
    22.344    39.619     0.200
    22.351    39.760     0.200
    22.375    39.371     0.200
    22.395    39.534     0.200
    22.660    39.313     0.200
    22.692    39.186     0.200
    22.968    36.997     0.200
    22.968    37.676     0.200
    22.868    39.255     0.200
    22.868    39.095     0.200
    22.939    38.489     0.200
    22.939    38.590     0.200
    22.981    39.371     0.200
    22.981    39.551     0.200
    23.001    39.780     0.200
    23.099    38.629     0.200
    23.187    38.797     0.200
    23.409    37.581     0.200
    23.409    38.495     0.200
    23.333    38.781     0.200
    23.456    37.970     0.200
    23.470    37.703     0.200
    23.670    36.353     0.200
    23.721    36.340     0.200
    23.721    36.132     0.200
    23.745    38.181     0.200
    23.890    37.628     0.200
    24.123    37.413     0.200
    24.123    36.479     0.200
    24.145    35.866     0.200
    24.345    35.240     0.200
    24.826    35.635     0.200
    24.826    34.928     0.200
    25.158    33.346     0.200
    25.246    33.621     0.200
    25.472    32.842     0.200
    25.472    32.514     0.200
    25.735    29.492     0.200
    25.735    33.148     0.200
    25.893    31.807     0.200
    25.819    32.907     0.200
    25.813    32.763     0.200
    26.089    32.461     0.200
    26.275    30.121     0.200
    26.519    28.622     0.200
    26.519    29.028     0.200
    26.619    29.060     0.200
    26.854    27.944     0.200
    26.854    28.092     0.200
    26.576    30.024     0.200
    27.205    27.431     0.200
    27.279    28.114     0.200
    28.254    26.024     0.200
    28.803    22.993     0.200
    28.864    24.735     0.200
    28.864    24.575     0.200
    14.651    40.723     0.200
    14.620    42.230     0.200
    14.896    42.505     0.200
    15.134    41.157     0.200
    15.101    44.373     0.200
    15.113    43.843     0.200
    15.344    43.762     0.200
    15.519    42.939     0.200
    16.785    42.134     0.200
    16.900    41.529     0.200
    16.798    43.354     0.200
    16.988    41.630     0.200
    17.089    42.169     0.200
    17.212    42.508     0.200
    18.003    41.083     0.200
    18.282    42.924     0.200
    18.282    42.533     0.200
    18.446    41.663     0.200
    18.446    42.624     0.200
    18.511    41.375     0.200
    18.753    40.326     0.200
    19.091    39.285     0.200
    19.405    42.052     0.200
    19.671    42.118     0.200
    19.954    40.689     0.200
    20.079    40.839     0.200
    20.094    41.282     0.200
    20.613    42.295     0.200
    20.795    39.749     0.200
    20.795    39.960     0.200
    21.210    40.700     0.200
    21.504    38.690     0.200
    21.504    39.002     0.200
    21.241    40.723     0.200
    21.546    38.997     0.200
    21.546    39.673     0.200
    22.163    38.914     0.200
    22.268    39.836     0.200
    22.845    38.574     0.200
    23.283    37.786     0.200
    23.283    38.270     0.200
    23.232    39.065     0.200
    23.594    35.868     0.200
    23.758    36.759     0.200
    23.995    35.381     0.200
    23.995    36.049     0.200
    25.030    35.220     0.200
    25.341    32.568     0.200
    25.341    31.978     0.200
    25.612    32.410     0.200
    27.077    30.732     0.200
    15.165    44.335     0.200
    15.165    43.913     0.200
    15.333    42.997     0.200
    16.005    40.975     0.200
    16.482    43.248     0.200
    16.968    42.663     0.200
    16.839    43.545     0.200
    17.057    44.208     0.200
    17.105    44.656     0.200
    17.274    42.688     0.200
    17.495    41.888     0.200
    17.763    42.725     0.200
    18.079    41.327     0.200
    18.036    42.645     0.200
    18.561    42.052     0.200
    18.561    42.447     0.200
    18.815    41.583     0.200
    18.971    41.501     0.200
    19.202    41.192     0.200
    19.451    41.827     0.200
    19.710    42.060     0.200
    19.710    42.630     0.200
    19.816    41.463     0.200
    19.907    40.863     0.200
    20.015    40.863     0.200
    20.024    41.346     0.200
    20.150    39.645     0.200
    20.150    40.113     0.200
    20.157    40.828     0.200
    20.064    42.002     0.200
    20.223    41.025     0.200
    20.164    42.172     0.200
    20.315    40.930     0.200
    20.287    40.753     0.200
    20.397    41.157     0.200
    20.390    41.500     0.200
    20.343    41.524     0.200
    20.583    42.139     0.200
    20.655    41.097     0.200
    20.655    41.707     0.200
    20.716    40.640     0.200
    20.861    40.216     0.200
    20.861    40.536     0.200
    20.804    41.082     0.200
    20.887    41.168     0.200
    21.253    40.611     0.200
    21.583    38.753     0.200
    21.583    38.585     0.200
    21.615    38.000     0.200
    21.615    39.000     0.200
    21.623    38.547     0.200
    21.574    39.446     0.200
    21.610    39.040     0.200
    21.528    39.538     0.200
    21.559    39.961     0.200
    21.673    39.268     0.200
    21.633    39.701     0.200
    21.715    39.409     0.200
    21.728    39.098     0.200
    21.726    39.172     0.200
    21.778    39.227     0.200
    21.794    38.809     0.200
    21.828    38.893     0.200
    21.828    38.724     0.200
    21.859    38.742     0.200
    21.882    38.906     0.200
    21.880    38.490     0.200
    21.906    38.292     0.200
    21.908    38.356     0.200
    21.991    38.738     0.200
    21.999    38.676     0.200
    22.026    39.339     0.200
    22.140    38.643     0.200
    22.114    39.446     0.200
    22.312    39.161     0.200
    22.334    38.305     0.200
    22.924    35.296     0.200
    22.924    35.819     0.200
    22.630    39.206     0.200
    22.805    37.987     0.200
    22.876    37.573     0.200
    22.876    38.003     0.200
    22.918    37.830     0.200
    22.918    38.139     0.200
    22.939    39.062     0.200
    23.038    36.220     0.200
    23.347    37.031     0.200
    23.347    37.543     0.200
    23.272    37.986     0.200
    23.615    36.560     0.200
    23.674    35.547     0.200
    23.674    34.528     0.200
    23.408    37.307     0.200
    23.408    38.322     0.200
    23.681    36.825     0.200
    23.831    35.917     0.200
    23.831    36.281     0.200
    24.061    36.238     0.200
    24.282    35.788     0.200
    25.096    33.611     0.200
    25.096    33.213     0.200
    25.184    33.469     0.200
    25.418    32.396     0.200
    25.672    29.948     0.200
    25.750    31.961     0.200
    25.750    31.770     0.200
    26.474    28.760     0.200
    26.559    29.440     0.200
    27.044    27.650     0.200
    27.044    28.954     0.200
    27.156    28.711     0.200
    27.759    28.138     0.200
    28.162    24.722     0.200
    28.801    23.143     0.200
    29.963    19.600     0.200
    18.400    40.578     0.200
    21.762    37.993     0.200
    16.614    44.359     0.200
    17.675    42.816     0.200
    17.602    42.947     0.200
    20.822    40.530     0.200
    22.937    34.810     0.200
    25.528    31.859     0.200
    25.936    30.282     0.200
    14.404    43.416     0.200
    15.513    39.555     0.200
    16.170    44.883     0.200
    16.369    42.200     0.200
    16.352    43.193     0.200
    16.577    46.044     0.200
    16.670    43.315     0.200
    16.796    42.502     0.200
    16.899    45.161     0.200
    16.981    42.742     0.200
    16.983    42.565     0.200
    16.927    44.476     0.200
    16.963    44.420     0.200
    17.010    43.721     0.200
    17.149    42.858     0.200
    17.163    43.947     0.200
    17.175    44.306     0.200
    17.438    44.295     0.200
    17.802    40.347     0.200
    17.749    42.778     0.200
    17.829    43.810     0.200
    17.932    42.429     0.200
    17.932    41.595     0.200
    17.997    41.761     0.200
    17.875    43.928     0.200
    17.999    43.593     0.200
    18.281    43.065     0.200
    18.281    43.082     0.200
    18.343    40.664     0.200
    18.410    42.001     0.200
    18.410    41.290     0.200
    18.603    42.318     0.200
    18.603    40.974     0.200
    19.223    42.165     0.200
    19.253    42.235     0.200
    19.435    41.958     0.200
    19.514    42.246     0.200
    19.514    41.720     0.200
    19.578    42.380     0.200
    19.617    42.110     0.200
    19.689    41.590     0.200
    19.811    41.163     0.200
    19.807    41.838     0.200
    20.058    40.938     0.200
    20.058    40.436     0.200
    20.066    41.696     0.200
    20.249    41.577     0.200
    20.254    41.801     0.200
    20.338    41.322     0.200
    20.341    40.840     0.200
    20.399    41.946     0.200
    20.611    41.061     0.200
    20.611    40.194     0.200
    20.746    40.989     0.200
    20.736    41.276     0.200
    20.736    40.858     0.200
    20.811    40.703     0.200
    20.811    40.397     0.200
    20.819    41.477     0.200
    20.957    40.619     0.200
    21.023    40.189     0.200
    21.253    40.916     0.200
    21.257    40.598     0.200
    21.392    39.180     0.200
    21.333    40.543     0.200
    21.378    40.380     0.200
    21.539    39.540     0.200
    21.539    38.057     0.200
    21.550    40.665     0.200
    21.584    41.380     0.200
    21.647    40.445     0.200
    21.620    39.910     0.200
    21.658    40.271     0.200
    21.691    40.391     0.200
    21.700    40.125     0.200
    21.701    39.265     0.200
    21.754    40.395     0.200
    21.770    39.238     0.200
    21.803    39.520     0.200
    21.804    39.293     0.200
    21.844    37.998     0.200
    21.834    39.264     0.200
    21.856    39.338     0.200
    21.856    38.903     0.200
    21.881    38.770     0.200
    21.887    39.579     0.200
    21.967    38.859     0.200
    21.973    39.182     0.200
    22.077    39.485     0.200
    22.114    39.108     0.200
    22.118    39.593     0.200
    22.179    39.143     0.200
    22.195    39.162     0.200
    22.228    40.169     0.200
    22.372    38.573     0.200
    22.372    38.702     0.200
    22.374    38.636     0.200
    22.384    39.803     0.200
    22.379    38.696     0.200
    22.476    40.060     0.200
    22.476    38.888     0.200
    22.425    39.195     0.200
    22.698    36.785     0.200
    22.698    38.631     0.200
    22.658    38.943     0.200
    22.708    37.548     0.200
    22.828    38.426     0.200
    22.858    38.133     0.200
    22.858    37.904     0.200
    22.986    38.047     0.200
    22.986    38.199     0.200
    23.032    37.703     0.200
    23.135    36.811     0.200
    23.211    37.184     0.200
    23.320    36.119     0.200
    23.320    36.414     0.200
    23.310    37.628     0.200
    23.310    36.991     0.200
    23.466    36.926     0.200
    23.466    35.616     0.200
    23.363    37.037     0.200
    23.444    37.806     0.200
    23.484    37.284     0.200
    23.484    36.676     0.200
    23.727    37.109     0.200
    23.727    35.236     0.200
    23.714    38.158     0.200
    23.917    36.665     0.200
    23.917    36.167     0.200
    24.013    36.390     0.200
    24.013    35.747     0.200
    24.150    36.393     0.200
    24.300    35.242     0.200
    24.685    34.530     0.200
    24.685    34.187     0.200
    25.045    33.036     0.200
    25.045    32.558     0.200
    25.258    32.271     0.200
    25.258    31.685     0.200
    25.246    33.820     0.200
    25.656    31.088     0.200
    25.656    31.713     0.200
    25.656    31.475     0.200
    25.705    31.461     0.200
    25.749    33.797     0.200
    25.791    31.679     0.200
    25.791    31.519     0.200
    26.020    31.135     0.200
    26.257    29.446     0.200
    26.257    28.999     0.200
    26.203    30.650     0.200
    26.563    27.531     0.200
    26.563    27.356     0.200
    26.461    29.564     0.200
    26.766    29.769     0.200
    26.958    28.312     0.200
    26.962    28.163     0.200
    27.250    27.627     0.200
    27.972    24.360     0.200
    28.084    24.711     0.200
    28.197    25.811     0.200
    28.197    24.903     0.200
    28.353    25.719     0.200
    28.314    24.666     0.200
    28.314    24.869     0.200
    28.444    23.452     0.200
    28.576    24.737     0.200
    28.800    23.579     0.200
    28.800    22.526     0.200
    29.410    21.016     0.200
    29.892    20.183     0.200
    29.892    19.849     0.200
    19.611    39.831     0.200
    19.906    40.080     0.200
    20.405    39.691     0.200
    25.497    30.716     0.200
    15.527    39.836     0.200
    17.584    42.407     0.200
    18.528    44.115     0.200
    14.069    42.999     0.200
    17.402    42.346     0.200
    18.251    42.163     0.200
    22.816    35.625     0.200
    25.407    31.584     0.200
    26.499    30.094     0.200
    26.499    28.255     0.200
    14.039    39.201     0.200
    14.023    45.077     0.200
    14.143    40.260     0.200
    14.380    44.380     0.200
    14.550    40.907     0.200
    14.669    39.322     0.200
    15.293    44.736     0.200
    15.421    45.512     0.200
    16.018    44.834     0.200
    16.159    40.653     0.200
    16.473    40.713     0.200
    16.853    41.011     0.200
    16.809    41.058     0.200
    16.954    41.563     0.200
    16.958    46.078     0.200
    17.040    41.007     0.200
    17.040    41.167     0.200
    17.039    42.600     0.200
    16.999    42.664     0.200
    17.039    42.447     0.200
    17.205    41.266     0.200
    17.219    41.838     0.200
    17.230    42.000     0.200
    17.196    42.634     0.200
    17.297    41.112     0.200
    17.492    42.144     0.200
    17.453    42.687     0.200
    17.509    41.767     0.200
    17.798    42.422     0.200
    17.860    41.988     0.200
    17.995    41.702     0.200
    17.995    41.882     0.200
    17.952    41.420     0.200
    18.050    42.243     0.200
    18.336    43.394     0.200
    18.336    41.095     0.200
    18.337    43.532     0.200
    18.337    43.409     0.200
    18.409    40.600     0.200
    20.356    39.250     0.200
    20.218    40.795     0.200
    20.433    40.134     0.200
    20.672    39.504     0.200
    20.769    40.057     0.200
    21.032    38.680     0.200
    21.160    39.950     0.200
    21.282    40.401     0.200
    21.458    39.159     0.200
    21.366    39.873     0.200
    21.596    38.929     0.200
    21.595    39.240     0.200
    21.595    38.254     0.200
    21.600    40.602     0.200
    21.634    40.444     0.200
    21.697    39.051     0.200
    21.666    39.551     0.200
    21.701    40.094     0.200
    21.740    40.289     0.200
    21.750    40.927     0.200
    21.751    39.983     0.200
    21.804    40.241     0.200
    21.819    39.918     0.200
    21.853    39.307     0.200
    21.854    39.461     0.200
    21.884    39.911     0.200
    21.906    39.493     0.200
    21.906    39.932     0.200
    21.931    39.187     0.200
    21.936    39.643     0.200
    22.017    39.258     0.200
    22.023    39.838     0.200
    22.144    37.459     0.200
    22.144    35.980     0.200
    22.164    38.962     0.200
    22.232    39.123     0.200
    22.228    38.205     0.200
    22.403    37.504     0.200
    22.419    39.096     0.200
    22.456    36.311     0.200
    22.531    40.443     0.200
    22.531    37.920     0.200
    22.765    36.012     0.200
    22.765    36.245     0.200
    22.742    37.363     0.200
    22.871    38.086     0.200
    22.907    37.871     0.200
    22.907    37.611     0.200
    23.361    37.884     0.200
    23.361    37.298     0.200
    23.375    36.161     0.200
    23.533    36.053     0.200
    23.533    35.522     0.200
    23.786    36.426     0.200
    23.786    36.164     0.200
    23.755    39.165     0.200
    24.066    35.991     0.200
    24.066    35.383     0.200
    24.268    32.086     0.200
    24.344    35.750     0.200
    24.742    34.656     0.200
    24.742    33.714     0.200
    25.121    32.291     0.200
    25.322    31.724     0.200
    25.322    31.128     0.200
    25.283    32.172     0.200
    25.705    29.180     0.200
    25.705    33.245     0.200
    25.705    31.112     0.200
    25.884    31.000     0.200
    25.831    30.611     0.200
    26.597    27.678     0.200
    26.597    30.356     0.200
    26.597    26.445     0.200
    27.024    25.723     0.200
    27.007    28.192     0.200
    27.791    25.399     0.200
    28.251    26.104     0.200
    28.251    23.184     0.200
    28.366    26.131     0.200
    28.366    22.403     0.200
    29.948    20.109     0.200
    29.948    19.584     0.200
    15.539    39.812     0.200
    18.012    41.359     0.200
    18.276    43.626     0.200
    18.276    43.325     0.200
    22.709    37.822     0.200
    25.261    32.118     0.200
    18.434    38.756     0.200
    14.368    44.083     0.200
    14.688    44.315     0.200
    16.904    44.431     0.200
    18.148    42.659     0.200
    18.148    44.671     0.200
    22.628    37.378     0.200
    25.155    32.653     0.200
    26.648    28.865     0.200
    29.759    20.504     0.200
    14.057    42.675     0.200
    14.173    44.018     0.200
    14.413    43.709     0.200
    14.844    43.102     0.200
    15.637    41.434     0.200
    16.157    41.005     0.200
    22.169    35.566     0.200
    28.879    20.368     0.200
    28.883    20.230     0.200
    29.009    19.227     0.200
    14.365    44.812     0.200
    15.336    42.572     0.200
    15.593    41.143     0.200
    16.222    43.041     0.200
    16.359    43.695     0.200
    16.763    41.455     0.200
    16.787    42.853     0.200
    18.450    42.892     0.200
    22.813    36.304     0.200
    26.502    29.478     0.200
    14.992    38.911     0.200
    15.564    42.648     0.200
    15.744    39.425     0.200
    15.847    42.507     0.200
    15.915    40.447     0.200
    16.296    39.762     0.200
    17.371    43.173     0.200
    17.499    42.052     0.200
    17.807    43.728     0.200
    19.266    42.399     0.200
    21.801    38.359     0.200
    22.151    37.355     0.200
    14.800    44.776     0.200
    15.212    44.620     0.200
    15.508    41.613     0.200
    16.092    39.310     0.200
    16.103    41.091     0.200
    16.241    42.194     0.200
    16.556    41.645     0.200
    16.542    41.515     0.200
    17.064    42.436     0.200
    16.939    42.507     0.200
    17.241    42.612     0.200
    17.423    41.739     0.200
    18.125    40.894     0.200
    18.556    39.722     0.200
    21.093    40.356     0.200
    21.669    37.096     0.200
    21.797    37.696     0.200
    22.042    38.233     0.200
    22.147    37.260     0.200
    22.169    38.919     0.200
    22.256    38.966     0.200
    22.261    38.832     0.200
    22.870    35.654     0.200
    24.373    34.249     0.200
    15.482    38.768     0.200
    15.928    38.896     0.200
    16.647    38.718     0.200
    16.689    39.170     0.200
    17.073    38.789     0.200
    17.819    39.259     0.200
    17.944    39.556     0.200
    18.038    38.855     0.200
    18.563    38.579     0.200
    20.871    38.146     0.200
    22.168    36.676     0.200
    22.887    37.484     0.200
    22.887    35.484     0.200
    15.933    41.576     0.200
    16.052    43.267     0.200
    16.111    42.100     0.200
    16.183    41.025     0.200
    16.272    42.016     0.200
    16.289    42.123     0.200
    16.640    41.412     0.200
    16.823    42.368     0.200
    16.822    42.064     0.200
    16.954    42.989     0.200
    17.080    41.162     0.200
    17.097    42.068     0.200
    17.102    41.821     0.200
    17.119    42.519     0.200
    17.194    42.783     0.200
    17.288    42.023     0.200
    17.571    42.200     0.200
    17.646    41.165     0.200
    17.787    41.454     0.200
    17.894    44.483     0.200
    17.894    43.303     0.200
    17.984    41.318     0.200
    18.023    42.014     0.200
    18.152    41.591     0.200
    18.277    41.098     0.200
    18.332    41.808     0.200
    18.331    41.240     0.200
    18.332    45.229     0.200
    18.332    41.999     0.200
    18.361    40.960     0.200
    19.785    40.674     0.200
    20.893    39.716     0.200
    20.921    39.446     0.200
    21.295    39.147     0.200
    21.837    38.238     0.200
    21.874    38.328     0.200
    21.987    37.923     0.200
    21.991    37.836     0.200
    22.018    38.483     0.200
    22.175    38.479     0.200
    22.515    37.338     0.200
    23.043    37.211     0.200
    25.577    31.551     0.200
    14.515    41.283     0.200
    17.131    42.335     0.200
    17.924    43.879     0.200
    17.932    43.003     0.200
    18.143    45.103     0.200
    18.299    43.904     0.200
    18.307    42.938     0.200
    20.000    39.111     0.200
    20.425    40.061     0.200
    20.465    39.751     0.200
    21.119    39.005     0.200
    21.167    39.153     0.200
    21.536    38.160     0.200
    21.918    37.559     0.200
    22.108    38.377     0.200
    22.108    39.049     0.200
    22.503    42.662     0.200
    22.533    38.754     0.200
    22.562    37.843     0.200
    22.924    40.150     0.200
    23.058    39.220     0.200
    23.058    37.751     0.200
    23.151    36.609     0.200
    23.252    37.245     0.200
    23.331    37.259     0.200
    23.611    36.726     0.200
    23.930    35.428     0.200
    24.083    35.291     0.200
    24.106    35.125     0.200
    24.618    35.079     0.200
    24.932    34.066     0.200
    24.932    33.074     0.200
    25.711    30.379     0.200
    25.829    30.997     0.200
    25.858    32.337     0.200
    25.858    30.517     0.200
    25.858    31.896     0.200
    25.859    31.086     0.200
    26.186    32.461     0.200
    26.186    31.270     0.200
    26.257    29.226     0.200
    26.325    28.998     0.200
    26.369    28.619     0.200
    27.262    27.122     0.200
    29.048    23.931     0.200
    29.048    20.842     0.200
    29.080    21.893     0.200
    29.894    19.598     0.200
    17.937    41.894     0.200
    18.311    42.777     0.200
    17.540    41.961     0.200
    18.450    41.793     0.200
    22.880    37.577     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.929     9.195     0.200
     2.572    10.385     0.200
     3.242    14.466     0.200
     3.929    13.645     0.200
     3.964    13.447     0.200
     4.082    15.460     0.200
     4.176    14.060     0.200
     4.644    16.906     0.200
     4.769    16.578     0.200
     4.776    16.563     0.200
     5.243    17.810     0.200
     5.322    17.829     0.200
     5.694    18.799     0.200
     5.984    19.465     0.200
     7.195    22.134     0.200
     7.415    25.730     0.200
     7.439    26.754     0.200
     7.736    26.114     0.200
     7.795    27.761     0.200
     7.949    27.630     0.200
     8.081    28.814     0.200
     8.135    26.990     0.200
     8.204    27.466     0.200
     8.213    27.217     0.200
     8.287    28.703     0.200
     8.325    28.483     0.200
     8.566    28.336     0.200
     8.600    27.537     0.200
     8.811    29.180     0.200
     9.034    28.076     0.200
     9.364    27.720     0.200
    10.236    30.544     0.200
    10.735    27.922     0.200
    10.784    34.151     0.200
    11.037    30.193     0.200
    11.388    33.998     0.200
    12.231    33.471     0.200
    12.941    33.677     0.200
    13.830    35.609     0.200
    13.830    36.109     0.200
    13.967    40.306     0.200
    14.027    38.811     0.200
    14.547    39.739     0.200
    14.543    36.679     0.200
    14.571    39.156     0.200
    14.869    36.474     0.200
    15.030    39.300     0.200
    15.373    39.391     0.200
    15.704    37.239     0.200
    15.793    39.996     0.200
    17.119    37.721     0.200
    18.523    43.335     0.200
    18.530    43.249     0.200
    18.692    44.157     0.200
    18.693    43.355     0.200
    20.297    42.136     0.200
    20.436    42.511     0.200
    20.747    40.780     0.200
    20.828    41.543     0.200
     1.940     8.935     0.200
     2.572    10.469     0.200
     3.227    14.822     0.200
     3.924    14.781     0.200
     4.164    13.192     0.200
     4.630    16.954     0.200
     4.773    16.727     0.200
     4.777    16.028     0.200
     5.246    16.558     0.200
     5.696    18.939     0.200
     5.968    19.935     0.200
     7.185    22.028     0.200
     8.597    28.459     0.200
    13.824    35.459     0.200
    15.702    39.542     0.200
    16.442    39.903     0.200
    17.106    39.157     0.200
    18.527    45.070     0.200
     1.271     7.967     0.200
     1.898    11.861     0.200
     2.548     9.980     0.200
     3.270    13.139     0.200
     4.113    15.809     0.200
     4.176    14.376     0.200
     4.673    17.473     0.200
     6.007    19.301     0.200
     2.567     9.966     0.200
     3.242    13.284     0.200
     3.934    13.514     0.200
     3.959    13.114     0.200
     4.084    15.160     0.200
     4.171    13.642     0.200
     4.644    16.917     0.200
     4.764    16.507     0.200
     4.771    16.340     0.200
     5.239    17.682     0.200
     5.689    18.589     0.200
     5.982    19.503     0.200
     7.198    22.016     0.200
     8.594    33.021     0.200
     9.359    30.594     0.200
    12.936    35.358     0.200
    14.545    36.578     0.200
     1.343     7.660     0.200
     2.080     9.771     0.200
     2.982    10.539     0.200
     3.320    13.396     0.200
     3.647    11.880     0.200
     4.069    15.255     0.200
     4.312    14.112     0.200
     4.636    14.840     0.200
     4.692    17.077     0.200
     5.093    17.155     0.200
     6.054    18.735     0.200
     6.190    19.805     0.200
     7.043    21.248     0.200
     7.524    23.631     0.200
    10.849    30.935     0.200
    11.067    33.284     0.200
    11.207    30.149     0.200
    11.873    30.377     0.200
    13.419    33.834     0.200
    14.478    36.479     0.200
    15.338    36.442     0.200
    16.152    38.942     0.200
    17.568    37.419     0.200
    20.523    40.037     0.200
     3.509    12.825     0.200
     3.748    12.333     0.200
     3.970    14.001     0.200
     4.309    15.786     0.200
     4.473    13.971     0.200
     6.299    20.468     0.200
     1.265     7.403     0.200
     2.651    10.696     0.200
     2.651     9.525     0.200
     3.007    14.069     0.200
     3.284    15.439     0.200
     3.883    13.040     0.200
     4.023    14.814     0.200
     4.104    15.368     0.200
     4.694    16.650     0.200
     4.821    18.185     0.200
     5.825    16.779     0.200
     6.057    20.574     0.200
     7.080    21.585     0.200
     7.080    20.335     0.200
     7.714    23.293     0.200
    13.428    34.658     0.200
    18.263    38.932     0.200
    20.261    42.391     0.200
    20.535    42.535     0.200
     2.948    11.741     0.200
     3.715    11.972     0.200
     4.154    15.499     0.200
     4.262    15.601     0.200
     4.666    15.528     0.200
     4.778    17.119     0.200
     4.792    17.081     0.200
     6.170    19.473     0.200
     6.269    21.116     0.200
     7.022    20.598     0.200
     7.022    20.801     0.200
    12.342    32.745     0.200
    12.719    29.551     0.200
    20.531    40.526     0.200
     1.184     6.779     0.200
     1.492     8.266     0.200
     2.657     9.399     0.200
     3.409    11.417     0.200
     3.712    10.578     0.200
     3.909    12.209     0.200
     4.030    11.466     0.200
     4.483    13.416     0.200
     4.573    14.176     0.200
     4.603    14.269     0.200
     4.993    14.665     0.200
     5.179    16.216     0.200
     5.768    19.733     0.200
     5.864    17.494     0.200
     5.920    17.607     0.200
     6.166    19.959     0.200
     6.220    20.888     0.200
     6.763    20.155     0.200
     6.854    21.532     0.200
     8.016    22.305     0.200
     8.918    26.023     0.200
    10.298    28.112     0.200
    13.502    31.809     0.200
    13.539    30.873     0.200
    13.539    31.404     0.200
    15.088    37.630     0.200
     1.527     8.315     0.200
     2.881    10.695     0.200
     3.614    14.075     0.200
     4.091    12.888     0.200
     4.280    13.490     0.200
     4.445    16.302     0.200
     4.445    16.842     0.200
     4.624    16.372     0.200
     4.625    15.582     0.200
     5.823    17.789     0.200
     6.801    20.854     0.200
    12.267    27.906     0.200
    18.462    41.720     0.200
     2.467     8.885     0.200
     3.530    10.723     0.200
     3.758    11.284     0.200
     4.058    13.244     0.200
     4.097    13.082     0.200
     4.533    14.976     0.200
     5.092    17.627     0.200
     6.082    20.096     0.200
     6.640    19.468     0.200
     7.274    21.741     0.200
     7.458    22.359     0.200
     0.926     5.885     0.200
     1.246     6.909     0.200
     2.905    10.010     0.200
     3.998    11.996     0.200
     4.224    13.695     0.200
     4.527    15.009     0.200
     4.623    14.780     0.200
     4.790    18.046     0.200
     5.047    15.827     0.200
     2.585    10.004     0.200
     3.769    12.193     0.200
     3.964    12.492     0.200
     3.936    13.848     0.200
     4.231    14.444     0.200
     4.231    14.343     0.200
     4.307    13.848     0.200
     4.303    14.782     0.200
     4.732    14.690     0.200
     4.757    15.720     0.200
     4.704    17.002     0.200
     4.704    16.854     0.200
     4.764    15.650     0.200
     5.696    17.948     0.200
     5.811    18.375     0.200
     6.401    21.474     0.200
     6.278    19.367     0.200
     6.688    21.311     0.200
     7.196    20.838     0.200
     7.116    21.771     0.200
     7.759    22.473     0.200
     8.038    23.416     0.200
     8.183    23.593     0.200
     8.539    24.698     0.200
    10.577    29.046     0.200
    11.063    29.989     0.200
    12.397    29.363     0.200
    12.434    29.698     0.200
    13.479    35.444     0.200
    14.382    35.821     0.200
    14.580    36.750     0.200
    14.580    37.762     0.200
    14.580    35.051     0.200
    15.174    38.831     0.200
    15.791    39.700     0.200
    16.457    38.573     0.200
    17.564    39.687     0.200
    19.879    42.445     0.200
    20.196    40.845     0.200
     1.259     7.770     0.200
     1.935     9.334     0.200
     2.574    10.437     0.200
     2.665    11.279     0.200
     3.942    13.899     0.200
     4.697    17.436     0.200
     5.149    16.221     0.200
     6.058    20.534     0.200
     7.116    21.375     0.200
     8.017    24.152     0.200
     9.361    26.275     0.200
    10.636    28.536     0.200
    12.051    31.985     0.200
    12.384    32.316     0.200
    12.823    33.038     0.200
    13.415    34.035     0.200
    13.484    35.695     0.200
    14.034    35.155     0.200
    15.634    37.558     0.200
    17.820    38.044     0.200
    18.181    39.262     0.200
    20.178    45.641     0.200
    20.458    42.776     0.200
     2.885    12.276     0.200
     5.779    19.602     0.200
     5.981    20.654     0.200
     5.981    18.486     0.200
     6.132    19.273     0.200
     7.049    20.916     0.200
     6.937    21.108     0.200
     7.262    22.405     0.200
     7.584    22.479     0.200
     8.665    23.980     0.200
     9.028    27.098     0.200
     9.266    27.847     0.200
    10.038    27.246     0.200
    10.146    28.961     0.200
    10.251    28.909     0.200
    10.311    28.738     0.200
    10.324    28.680     0.200
    10.423    28.981     0.200
    10.416    29.725     0.200
    10.666    28.887     0.200
    10.813    28.968     0.200
    10.772    31.826     0.200
    11.030    33.349     0.200
    11.519    30.097     0.200
    11.532    29.486     0.200
    11.533    34.903     0.200
    11.635    34.740     0.200
    11.914    31.713     0.200
    11.859    33.987     0.200
    12.038    29.808     0.200
    11.953    35.551     0.200
    12.033    33.956     0.200
    12.242    30.768     0.200
    12.586    32.996     0.200
    12.781    33.457     0.200
    12.994    33.010     0.200
    13.126    34.018     0.200
    13.153    33.860     0.200
    13.692    33.006     0.200
    13.692    33.000     0.200
    13.903    35.899     0.200
    13.800    35.062     0.200
    14.089    37.055     0.200
    14.269    34.814     0.200
    14.342    35.872     0.200
    14.371    37.034     0.200
    14.565    35.996     0.200
    14.677    37.629     0.200
    15.004    37.414     0.200
    15.012    36.889     0.200
    15.038    38.789     0.200
    15.562    39.697     0.200
    15.715    41.556     0.200
    16.199    41.992     0.200
    16.741    43.713     0.200
    16.788    42.833     0.200
    16.818    41.772     0.200
    16.942    40.804     0.200
    17.040    38.777     0.200
    16.983    43.126     0.200
    17.241    42.256     0.200
    17.241    42.612     0.200
    17.297    42.729     0.200
    17.643    43.293     0.200
    17.689    43.627     0.200
    18.187    41.652     0.200
    18.187    42.535     0.200
    18.276    42.703     0.200
    18.276    41.921     0.200
    19.510    43.557     0.200
    19.867    44.535     0.200
    20.558    43.147     0.200
     1.200     6.760     0.200
     1.942     9.034     0.200
     2.638    10.460     0.200
     2.698    10.107     0.200
     3.389    10.003     0.200
     3.607    13.108     0.200
     3.692    10.437     0.200
     3.831    12.209     0.200
     3.889    11.933     0.200
     4.010    11.993     0.200
     4.093    11.817     0.200
     4.387    13.090     0.200
     4.462    13.652     0.200
     4.590    14.202     0.200
     4.982    17.403     0.200
     5.159    13.180     0.200
     5.456    15.060     0.200
     5.595    17.518     0.200
     5.776    19.939     0.200
     5.776    21.080     0.200
     5.844    17.238     0.200
     6.200    20.165     0.200
     6.528    18.690     0.200
     6.755    20.063     0.200
     6.834    20.778     0.200
     6.868    20.810     0.200
     6.997    21.327     0.200
     7.106    21.550     0.200
     7.673    22.750     0.200
     7.939    23.952     0.200
     8.016    22.340     0.200
     8.453    25.274     0.200
     8.515    25.090     0.200
     8.515    24.148     0.200
     8.889    27.382     0.200
     8.901    24.375     0.200
     8.865    24.203     0.200
     9.103    27.373     0.200
     9.323    28.201     0.200
    10.154    26.655     0.200
    10.368    28.059     0.200
    10.521    32.188     0.200
    10.678    32.031     0.200
    10.690    28.642     0.200
    10.773    31.922     0.200
    11.125    30.699     0.200
    11.085    30.180     0.200
    11.096    30.270     0.200
    11.167    33.814     0.200
    11.292    34.346     0.200
    11.312    29.717     0.200
    11.387    30.062     0.200
    11.412    29.497     0.200
    11.536    33.732     0.200
    11.668    34.813     0.200
    11.768    34.147     0.200
    11.799    32.421     0.200
    11.863    30.880     0.200
    11.863    27.552     0.200
    11.924    34.940     0.200
    11.960    33.910     0.200
    11.938    30.734     0.200
    12.113    31.885     0.200
    12.322    33.864     0.200
    12.417    30.894     0.200
    12.461    33.348     0.200
    12.472    34.375     0.200
    12.476    30.261     0.200
    12.582    34.862     0.200
    12.558    31.435     0.200
    12.579    31.670     0.200
    12.675    35.709     0.200
    12.629    32.468     0.200
    12.659    33.944     0.200
    12.725    33.828     0.200
    12.830    34.637     0.200
    12.803    32.423     0.200
    12.821    33.370     0.200
    12.986    34.625     0.200
    13.110    38.030     0.200
    13.208    36.745     0.200
    13.192    33.754     0.200
    13.267    36.184     0.200
    13.501    30.884     0.200
    13.501    31.169     0.200
    13.539    32.869     0.200
    13.594    37.951     0.200
    13.697    34.870     0.200
    13.771    35.908     0.200
    13.788    35.574     0.200
    13.851    36.881     0.200
    13.949    36.219     0.200
    14.115    34.821     0.200
    14.209    36.699     0.200
    14.223    36.382     0.200
    14.273    36.682     0.200
    14.555    37.407     0.200
    14.822    37.807     0.200
    14.868    36.586     0.200
    15.127    37.282     0.200
    15.089    36.628     0.200
    15.200    38.711     0.200
    15.288    36.282     0.200
    15.288    36.540     0.200
    15.418    38.327     0.200
    15.551    38.112     0.200
    15.551    38.983     0.200
    15.551    35.913     0.200
    17.184    39.476     0.200
    17.959    38.753     0.200
    19.159    42.419     0.200
    19.192    42.047     0.200
    19.451    42.375     0.200
    19.451    42.164     0.200
    19.747    40.954     0.200
    19.747    42.012     0.200
    19.749    42.998     0.200
    19.964    41.444     0.200
    19.996    40.501     0.200
    19.996    42.974     0.200
    20.007    45.619     0.200
    20.066    42.480     0.200
    20.185    40.483     0.200
    20.193    41.162     0.200
    20.274    40.017     0.200
    20.314    40.789     0.200
    20.335    41.312     0.200
    20.352    40.611     0.200
    20.339    41.252     0.200
    20.551    39.996     0.200
    20.551    40.195     0.200
    20.675    40.585     0.200
    20.682    40.171     0.200
    20.747    40.693     0.200
    20.747    42.978     0.200
    20.755    41.562     0.200
    20.895    40.853     0.200
     2.455     9.974     0.200
     2.455     8.438     0.200
     2.916     9.525     0.200
     4.824    16.069     0.200
     5.814    17.540     0.200
     9.094    23.709     0.200
     9.164    24.851     0.200
    12.903    35.904     0.200
    13.050    30.793     0.200
    13.565    28.873     0.200
    13.351    35.397     0.200
    13.695    38.087     0.200
    15.084    41.680     0.200
    15.330    39.754     0.200
    15.660    38.293     0.200
    15.589    40.347     0.200
    15.847    40.690     0.200
    16.047    41.688     0.200
    16.619    40.832     0.200
    16.757    40.694     0.200
    16.657    41.283     0.200
    16.856    41.280     0.200
    17.114    42.437     0.200
    17.114    41.636     0.200
    17.169    42.540     0.200
    17.452    40.574     0.200
    18.002    41.649     0.200
    18.002    40.918     0.200
    18.002    40.711     0.200
    18.298    42.331     0.200
    18.920    43.176     0.200
    19.789    42.040     0.200
    19.728    43.089     0.200
    19.945    42.665     0.200
    20.083    42.413     0.200
     2.697    10.130     0.200
     2.706     8.461     0.200
     3.618    12.933     0.200
     4.575    13.829     0.200
     5.592    16.949     0.200
     5.802    19.940     0.200
     6.862    20.763     0.200
     7.085    19.636     0.200
     8.491    23.746     0.200
     8.503    24.109     0.200
     8.497    24.459     0.200
     9.154    26.588     0.200
     9.378    26.555     0.200
    10.150    27.785     0.200
    10.192    25.877     0.200
    10.532    29.600     0.200
    10.537    29.265     0.200
    10.563    31.037     0.200
    10.654    29.852     0.200
    11.052    31.680     0.200
    11.059    30.305     0.200
    11.355    30.377     0.200
    11.375    30.210     0.200
    11.772    31.105     0.200
    11.854    30.259     0.200
    11.894    30.194     0.200
    12.018    32.564     0.200
    12.080    31.205     0.200
    12.259    33.599     0.200
    12.296    32.011     0.200
    12.370    31.127     0.200
    12.426    31.965     0.200
    12.452    32.603     0.200
    12.428    30.388     0.200
    12.503    29.628     0.200
    12.539    32.035     0.200
    12.592    32.742     0.200
    12.623    34.058     0.200
    12.648    33.810     0.200
    12.706    32.460     0.200
    12.729    33.212     0.200
    12.810    32.950     0.200
    12.958    33.351     0.200
    13.152    34.296     0.200
    13.331    35.662     0.200
    13.331    35.955     0.200
    13.553    30.836     0.200
    13.553    32.137     0.200
    13.667    35.005     0.200
    13.772    36.059     0.200
    13.749    34.507     0.200
    13.827    34.370     0.200
    13.827    38.936     0.200
    13.920    35.025     0.200
    14.093    36.998     0.200
    14.093    34.205     0.200
    14.093    34.869     0.200
    14.177    35.855     0.200
    14.198    36.054     0.200
    14.249    35.854     0.200
    14.518    36.375     0.200
    14.838    37.000     0.200
    15.043    38.810     0.200
    15.122    39.624     0.200
    15.129    39.177     0.200
    15.186    38.819     0.200
    15.196    36.930     0.200
    15.351    37.897     0.200
    15.391    38.978     0.200
    15.560    36.756     0.200
    15.560    37.741     0.200
    16.275    40.032     0.200
    16.283    39.807     0.200
    16.795    40.895     0.200
    16.963    39.279     0.200
    16.985    40.574     0.200
    17.395    39.243     0.200
    18.030    40.031     0.200
    18.279    39.902     0.200
    18.503    43.826     0.200
    19.227    43.467     0.200
    19.491    42.201     0.200
    19.780    41.828     0.200
    19.780    41.988     0.200
    19.785    42.486     0.200
    20.060    42.181     0.200
    20.806    42.883     0.200
     2.844    11.602     0.200
     2.896     9.585     0.200
     2.896     9.206     0.200
     4.666    12.654     0.200
     5.724    16.918     0.200
     6.019    19.136     0.200
     6.019    20.058     0.200
     6.070    19.874     0.200
     6.985    21.948     0.200
     7.151    21.113     0.200
     7.150    23.200     0.200
     7.778    24.604     0.200
     7.890    24.598     0.200
     8.545    24.277     0.200
     8.606    25.102     0.200
     8.542    30.343     0.200
     8.842    30.009     0.200
     9.230    26.462     0.200
     9.480    27.667     0.200
     9.579    28.772     0.200
    10.158    28.605     0.200
    10.206    30.999     0.200
    10.552    30.649     0.200
    10.489    33.495     0.200
    10.656    26.681     0.200
    10.898    28.224     0.200
    10.932    33.722     0.200
    11.065    30.367     0.200
    11.059    30.543     0.200
    11.298    32.023     0.200
    11.221    33.722     0.200
    11.241    33.280     0.200
    11.373    30.068     0.200
    11.372    32.854     0.200
    11.674    34.043     0.200
    11.812    32.831     0.200
    11.682    34.512     0.200
    11.964    32.237     0.200
    11.848    35.930     0.200
    12.093    30.257     0.200
    12.129    35.673     0.200
    12.178    35.541     0.200
    12.341    32.888     0.200
    12.321    30.728     0.200
    12.373    29.651     0.200
    12.431    32.048     0.200
    12.517    34.062     0.200
    12.522    34.057     0.200
    12.462    36.561     0.200
    12.588    33.099     0.200
    12.624    33.292     0.200
    12.776    34.026     0.200
    12.635    33.399     0.200
    12.789    35.140     0.200
    12.730    36.355     0.200
    12.911    32.466     0.200
    12.990    33.646     0.200
    12.867    37.404     0.200
    13.136    37.584     0.200
    13.116    38.146     0.200
    13.145    37.895     0.200
    13.318    37.676     0.200
    13.288    36.966     0.200
    13.823    30.136     0.200
    13.823    31.808     0.200
    13.538    38.078     0.200
    13.860    32.803     0.200
    13.656    38.035     0.200
    13.881    38.838     0.200
    13.881    36.338     0.200
    13.952    37.689     0.200
    13.955    38.121     0.200
    13.890    40.030     0.200
    13.946    39.664     0.200
    14.152    37.019     0.200
    14.152    35.097     0.200
    14.152    37.429     0.200
    14.197    36.574     0.200
    14.245    36.577     0.200
    14.300    39.157     0.200
    14.224    39.478     0.200
    14.431    37.383     0.200
    14.457    40.324     0.200
    14.863    37.495     0.200
    14.999    37.566     0.200
    15.085    38.021     0.200
    15.274    39.634     0.200
    15.264    40.085     0.200
    15.388    39.100     0.200
    15.388    38.311     0.200
    15.220    39.430     0.200
    15.504    40.072     0.200
    15.726    35.954     0.200
    15.882    41.993     0.200
    15.946    41.439     0.200
    16.422    40.708     0.200
    16.428    40.891     0.200
    16.915    40.958     0.200
    16.935    40.885     0.200
    17.408    40.239     0.200
    17.465    42.335     0.200
    17.557    41.743     0.200
    17.801    42.388     0.200
    18.182    42.243     0.200
    18.412    41.876     0.200
    18.412    43.380     0.200
    18.412    41.783     0.200
    18.412    42.822     0.200
    18.575    41.967     0.200
    18.481    43.217     0.200
    18.528    43.428     0.200
    18.472    44.178     0.200
    18.624    43.136     0.200
    19.035    44.326     0.200
    19.018    43.602     0.200
    19.095    46.473     0.200
    19.215    47.872     0.200
    19.227    43.437     0.200
    19.514    42.756     0.200
    19.677    42.411     0.200
    19.771    43.554     0.200
    19.880    42.703     0.200
    19.970    42.227     0.200
    20.088    42.137     0.200
    20.008    43.663     0.200
    20.220    42.894     0.200
    20.472    46.492     0.200
    20.625    44.177     0.200
    20.794    41.239     0.200
    20.794    42.903     0.200
    20.867    42.322     0.200
     2.884    11.938     0.200
     3.821    13.198     0.200
     4.733    16.088     0.200
     5.773    18.763     0.200
     6.018    18.024     0.200
     6.018    18.751     0.200
     7.660    25.507     0.200
     8.669    25.037     0.200
     8.628    24.239     0.200
    10.099    30.392     0.200
    11.162    34.741     0.200
    11.469    30.555     0.200
    11.584    33.992     0.200
    11.735    34.239     0.200
    11.914    34.105     0.200
    12.018    34.781     0.200
    12.190    32.287     0.200
    12.082    36.502     0.200
    12.428    33.593     0.200
    12.596    34.208     0.200
    12.531    33.577     0.200
    12.682    32.764     0.200
    12.629    37.478     0.200
    12.552    35.471     0.200
    12.620    36.110     0.200
    12.725    38.356     0.200
    12.976    34.980     0.200
    12.768    36.223     0.200
    12.768    37.207     0.200
    13.081    37.267     0.200
    13.242    39.110     0.200
    13.768    33.843     0.200
    13.547    37.081     0.200
    14.234    39.031     0.200
    14.292    36.706     0.200
    14.331    37.602     0.200
    14.131    40.628     0.200
    14.385    38.339     0.200
    15.101    40.557     0.200
    15.934    39.292     0.200
    16.291    39.933     0.200
    17.013    40.770     0.200
    16.852    42.375     0.200
    17.037    41.437     0.200
    17.174    41.506     0.200
    20.662    41.917     0.200
    20.662    42.765     0.200
     2.886    12.065     0.200
    11.125    27.290     0.200
    11.433    31.217     0.200
    11.159    32.295     0.200
    11.621    33.860     0.200
    12.153    32.211     0.200
    12.066    35.172     0.200
    12.399    31.392     0.200
    12.391    33.266     0.200
    12.831    32.818     0.200
    12.756    34.078     0.200
    12.667    35.965     0.200
    13.049    31.402     0.200
    12.806    34.502     0.200
    13.055    37.466     0.200
    13.426    35.261     0.200
    13.478    38.064     0.200
    13.594    35.684     0.200
    14.011    33.878     0.200
    14.209    33.245     0.200
    14.209    34.729     0.200
    14.257    33.443     0.200
    14.165    40.282     0.200
    14.548    37.467     0.200
    14.626    37.291     0.200
    14.580    36.671     0.200
    14.857    34.954     0.200
    15.766    35.133     0.200
    15.819    38.547     0.200
    15.885    39.695     0.200
    16.186    39.825     0.200
    16.069    39.283     0.200
    16.362    39.310     0.200
    16.367    39.963     0.200
    16.699    40.219     0.200
    16.854    41.222     0.200
    17.087    42.092     0.200
    17.345    42.219     0.200
    17.345    39.602     0.200
    17.403    42.507     0.200
    18.351    42.585     0.200
    18.524    41.074     0.200
    18.418    42.330     0.200
    18.465    42.489     0.200
    19.165    43.218     0.200
    19.727    42.956     0.200
    20.737    41.487     0.200
    20.737    41.920     0.200
     2.873     8.876     0.200
     3.827    12.807     0.200
     4.694    12.635     0.200
     5.753    16.827     0.200
     8.571    23.136     0.200
     9.465    26.771     0.200
    11.398    30.636     0.200
    11.991    33.399     0.200
    12.806    31.978     0.200
    12.842    37.441     0.200
    13.016    32.838     0.200
    13.299    35.358     0.200
    13.846    29.356     0.200
    14.179    33.611     0.200
    17.385    41.695     0.200
     2.507     9.715     0.200
     3.463    12.630     0.200
     4.037    13.550     0.200
     4.173    13.237     0.200
     4.225    14.138     0.200
     4.353    14.353     0.200
     4.439    13.815     0.200
     4.340    13.288     0.200
     4.725    16.873     0.200
     4.806    16.248     0.200
     4.930    14.957     0.200
     5.283    18.908     0.200
     5.316    16.906     0.200
     5.439    17.412     0.200
     5.505    18.495     0.200
     5.389    17.045     0.200
     5.698    19.693     0.200
     5.698    19.169     0.200
     5.771    18.415     0.200
     5.794    18.908     0.200
     5.736    17.588     0.200
     6.190    18.531     0.200
     6.489    19.791     0.200
     6.547    20.607     0.200
     6.704    20.356     0.200
     6.769    21.063     0.200
     6.651    19.261     0.200
     6.835    20.715     0.200
     8.085    22.758     0.200
     8.119    24.764     0.200
     8.277    24.651     0.200
     8.277    24.003     0.200
     8.235    23.743     0.200
     8.626    24.472     0.200
     9.734    26.847     0.200
     9.832    27.568     0.200
     9.875    28.628     0.200
    10.261    29.389     0.200
    10.778    30.708     0.200
    10.781    29.868     0.200
    11.083    30.627     0.200
    11.097    30.667     0.200
    11.509    31.943     0.200
    11.633    30.762     0.200
    11.806    31.188     0.200
    12.202    30.654     0.200
    12.150    33.232     0.200
    12.257    32.697     0.200
    12.213    31.906     0.200
    12.313    32.753     0.200
    12.459    31.871     0.200
    12.476    33.064     0.200
    12.692    35.611     0.200
    12.870    31.764     0.200
    13.568    30.632     0.200
    13.568    30.632     0.200
    13.400    31.672     0.200
    13.572    33.298     0.200
    13.655    33.300     0.200
    13.840    34.432     0.200
    13.840    35.221     0.200
    13.840    36.619     0.200
    13.906    36.110     0.200
    13.939    35.853     0.200
    14.194    33.331     0.200
    14.131    37.173     0.200
    14.349    36.100     0.200
    14.569    36.488     0.200
    15.390    37.162     0.200
    15.390    38.873     0.200
    16.699    39.350     0.200
    18.206    35.611     0.200
    18.564    44.042     0.200
    20.209    44.220     0.200
     2.653    11.349     0.200
     2.697     9.443     0.200
     3.570    13.815     0.200
     4.537    14.126     0.200
     5.549    17.665     0.200
     5.751    19.661     0.200
     5.751    20.585     0.200
     6.820    21.233     0.200
     7.061    22.002     0.200
     7.401    22.825     0.200
     7.569    24.103     0.200
     7.807    19.737     0.200
     7.736    22.656     0.200
     8.003    23.769     0.200
     7.995    24.197     0.200
     8.171    25.484     0.200
     8.464    25.519     0.200
     8.458    22.817     0.200
     8.401    25.175     0.200
     8.517    26.428     0.200
     8.771    25.917     0.200
     8.846    26.349     0.200
     8.953    27.429     0.200
     9.168    26.995     0.200
     9.387    26.166     0.200
     9.440    26.657     0.200
     9.711    28.828     0.200
     9.966    29.150     0.200
    10.123    28.700     0.200
    10.216    27.904     0.200
    10.270    29.023     0.200
    10.341    28.763     0.200
    10.432    28.666     0.200
    10.490    30.331     0.200
    10.629    30.213     0.200
    10.520    30.086     0.200
    10.546    29.548     0.200
    10.692    26.059     0.200
    10.740    29.525     0.200
    10.740    30.320     0.200
    10.837    31.397     0.200
    11.025    28.163     0.200
    11.034    29.592     0.200
    10.958    31.798     0.200
    11.189    29.375     0.200
    11.327    30.338     0.200
    11.220    30.582     0.200
    11.350    30.083     0.200
    11.229    30.704     0.200
    11.224    32.264     0.200
    11.600    31.963     0.200
    11.813    31.842     0.200
    11.728    32.849     0.200
    11.831    33.913     0.200
    12.052    32.429     0.200
    12.024    31.376     0.200
    12.049    34.151     0.200
    12.264    32.814     0.200
    12.124    34.432     0.200
    12.248    34.600     0.200
    12.353    30.823     0.200
    12.400    32.464     0.200
    12.517    32.872     0.200
    12.494    30.010     0.200
    12.567    33.192     0.200
    12.597    32.978     0.200
    12.475    32.350     0.200
    12.643    35.203     0.200
    12.622    33.882     0.200
    12.739    33.841     0.200
    12.739    34.630     0.200
    12.728    35.632     0.200
    12.927    33.589     0.200
    12.908    34.605     0.200
    12.908    32.367     0.200
    13.129    32.865     0.200
    13.163    34.430     0.200
    13.171    36.164     0.200
    13.272    34.879     0.200
    13.329    36.035     0.200
    13.329    35.019     0.200
    13.503    31.862     0.200
    13.503    32.866     0.200
    13.320    34.955     0.200
    13.541    31.778     0.200
    13.638    34.537     0.200
    13.727    35.381     0.200
    13.725    35.374     0.200
    13.588    36.283     0.200
    13.657    34.833     0.200
    13.890    35.931     0.200
    14.059    35.513     0.200
    14.059    34.482     0.200
    14.059    35.212     0.200
    13.925    36.956     0.200
    13.963    37.498     0.200
    14.149    35.563     0.200
    14.165    34.708     0.200
    13.997    35.480     0.200
    14.216    36.665     0.200
    14.283    36.839     0.200
    14.493    36.528     0.200
    14.571    36.432     0.200
    14.609    37.132     0.200
    14.761    36.752     0.200
    14.808    36.966     0.200
    14.751    33.609     0.200
    14.942    36.928     0.200
    15.131    37.808     0.200
    15.129    38.440     0.200
    15.129    37.987     0.200
    15.185    36.701     0.200
    15.185    37.502     0.200
    15.360    37.572     0.200
    15.265    39.523     0.200
    15.349    38.192     0.200
    15.389    38.151     0.200
    15.921    40.631     0.200
    15.895    41.006     0.200
    15.989    41.455     0.200
    16.102    41.002     0.200
    16.152    41.826     0.200
    16.274    40.915     0.200
    16.282    41.527     0.200
    16.670    40.061     0.200
    16.780    41.823     0.200
    16.932    39.397     0.200
    16.981    40.381     0.200
    17.162    42.390     0.200
    17.247    41.988     0.200
    17.419    42.015     0.200
    17.419    41.908     0.200
    17.475    42.239     0.200
    17.920    42.518     0.200
    18.281    40.917     0.200
    18.281    41.711     0.200
    18.281    41.352     0.200
    18.343    41.641     0.200
    18.433    46.845     0.200
    18.653    42.936     0.200
    18.959    42.284     0.200
    19.031    42.400     0.200
    19.153    43.393     0.200
    19.894    42.941     0.200
    19.995    41.888     0.200
    20.028    42.099     0.200
    20.131    42.236     0.200
    20.470    41.118     0.200
    20.379    42.020     0.200
    20.932    42.399     0.200
     2.829    10.078     0.200
     2.921     9.460     0.200
     3.786    13.390     0.200
     4.646    13.754     0.200
     5.708    16.204     0.200
     6.012    20.008     0.200
     8.587    23.477     0.200
     9.257    26.505     0.200
     9.606    26.789     0.200
    11.349    28.635     0.200
    11.701    29.706     0.200
    11.946    28.169     0.200
    11.945    32.621     0.200
    12.069    30.897     0.200
    14.130    35.847     0.200
    14.173    34.699     0.200
    15.290    37.257     0.200
    17.433    40.280     0.200
    18.439    41.166     0.200
    19.539    41.286     0.200
     1.280     7.962     0.200
     2.150     8.535     0.200
     2.967     9.985     0.200
     2.967     9.716     0.200
     3.665    11.035     0.200
     3.602    12.602     0.200
     3.983    11.042     0.200
     4.112    13.062     0.200
     4.155    13.228     0.200
     4.296    12.316     0.200
     4.388    13.124     0.200
     4.750    14.555     0.200
     4.883    14.557     0.200
     5.257    16.156     0.200
     5.327    16.157     0.200
     5.836    19.771     0.200
     5.836    19.486     0.200
    13.955    36.303     0.200
    18.269    37.858     0.200
     1.154     6.800     0.200
     1.168     7.845     0.200
     1.919     8.859     0.200
     2.664     9.888     0.200
     3.730    11.034     0.200
     3.871    10.665     0.200
     4.049    13.466     0.200
     4.131    12.973     0.200
     4.501    14.504     0.200
     4.619    15.583     0.200
     5.025    16.641     0.200
     5.011    16.707     0.200
     5.132    16.883     0.200
     5.196    16.834     0.200
     5.468    17.295     0.200
     5.737    20.292     0.200
     6.562    21.334     0.200
     6.746    20.482     0.200
     7.941    22.420     0.200
     7.991    22.761     0.200
     8.107    24.806     0.200
    13.477    33.264     0.200
     1.949     8.096     0.200
     2.514    11.325     0.200
     2.858     9.706     0.200
     2.858     9.451     0.200
     3.452    13.048     0.200
     3.937    11.627     0.200
     4.078    12.264     0.200
     4.337    13.160     0.200
     4.375    14.491     0.200
     4.708    14.698     0.200
     4.826    15.492     0.200
     5.143    17.605     0.200
     5.338    15.720     0.200
     5.402    15.546     0.200
     5.663    19.647     0.200
     5.663    19.137     0.200
     5.663    19.357     0.200
     5.755    17.398     0.200
     6.086    18.090     0.200
     7.801    22.603     0.200
     7.801    22.272     0.200
    10.909    27.374     0.200
    13.490    32.304     0.200
    13.490    32.300     0.200
    13.889    37.342     0.200
    13.889    37.341     0.200
    15.186    38.482     0.200
    15.387    38.892     0.200
    16.535    39.088     0.200
    18.455    41.295     0.200
    20.288    41.241     0.200
    20.772    39.727     0.200
    20.989    39.729     0.200
     1.205     7.451     0.200
     1.997     8.374     0.200
     2.654    10.800     0.200
     2.759     9.239     0.200
     2.759     9.890     0.200
     3.533    10.625     0.200
     3.942    11.573     0.200
     3.996    12.690     0.200
     4.122    11.632     0.200
     4.208    12.371     0.200
     4.495    15.121     0.200
     4.524    13.469     0.200
     4.575    13.646     0.200
     4.699    14.178     0.200
     5.125    15.290     0.200
     5.085    15.193     0.200
     5.208    15.402     0.200
     5.540    17.194     0.200
     5.547    16.887     0.200
     5.564    17.249     0.200
     5.776    19.762     0.200
     5.776    19.239     0.200
     5.899    18.717     0.200
     5.899    18.516     0.200
     5.960    17.712     0.200
     6.258    18.560     0.200
     6.296    19.482     0.200
     6.317    18.529     0.200
     6.474    17.303     0.200
     6.656    18.886     0.200
     6.816    20.749     0.200
     6.946    20.407     0.200
     7.031    21.413     0.200
     7.110    21.666     0.200
     7.110    22.513     0.200
     7.110    21.401     0.200
     7.111    20.995     0.200
     7.112    21.082     0.200
     7.598    23.214     0.200
     7.623    23.690     0.200
     7.779    23.801     0.200
     7.840    23.418     0.200
     7.942    22.684     0.200
     7.942    22.444     0.200
     8.066    22.456     0.200
     8.054    25.266     0.200
     8.041    23.207     0.200
     8.303    24.384     0.200
     8.454    24.339     0.200
     8.454    23.810     0.200
     8.437    24.186     0.200
     8.437    24.036     0.200
     8.557    27.302     0.200
     8.725    26.375     0.200
     8.844    26.913     0.200
     8.804    24.349     0.200
     8.819    27.447     0.200
     9.021    25.596     0.200
     8.996    26.980     0.200
     9.149    27.058     0.200
     9.158    28.598     0.200
     9.214    27.049     0.200
     9.437    27.769     0.200
     9.496    27.868     0.200
     9.747    30.522     0.200
     9.925    28.281     0.200
    10.010    28.699     0.200
    10.026    28.630     0.200
    10.319    29.413     0.200
    10.397    31.328     0.200
    10.475    30.322     0.200
    10.526    31.530     0.200
    10.578    29.408     0.200
    10.622    31.052     0.200
    10.596    29.871     0.200
    10.798    30.101     0.200
    10.798    30.564     0.200
    10.995    29.554     0.200
    11.242    30.521     0.200
    11.260    32.848     0.200
    11.298    30.707     0.200
    11.431    30.739     0.200
    11.317    30.862     0.200
    11.648    32.826     0.200
    11.806    30.975     0.200
    11.806    29.795     0.200
    11.848    31.930     0.200
    11.835    32.009     0.200
    12.077    32.331     0.200
    12.022    31.869     0.200
    12.161    33.601     0.200
    12.311    35.268     0.200
    12.311    34.028     0.200
    12.241    32.609     0.200
    12.241    31.871     0.200
    12.357    35.072     0.200
    12.368    32.773     0.200
    12.480    33.614     0.200
    12.444    30.821     0.200
    12.534    32.384     0.200
    12.565    33.487     0.200
    12.703    34.540     0.200
    12.703    36.191     0.200
    12.653    35.391     0.200
    12.798    35.843     0.200
    12.761    32.168     0.200
    12.789    34.722     0.200
    12.902    34.308     0.200
    12.990    35.180     0.200
    12.936    32.122     0.200
    13.093    34.425     0.200
    13.191    34.855     0.200
    13.315    35.939     0.200
    13.387    35.611     0.200
    13.387    35.951     0.200
    13.552    31.688     0.200
    13.552    30.383     0.200
    13.587    31.807     0.200
    13.589    31.969     0.200
    13.589    31.018     0.200
    13.611    34.970     0.200
    13.729    34.909     0.200
    13.804    37.755     0.200
    14.039    35.822     0.200
    14.039    34.246     0.200
    14.120    36.696     0.200
    14.194    36.164     0.200
    14.474    36.810     0.200
    14.308    38.301     0.200
    14.383    35.633     0.200
    14.456    35.745     0.200
    14.460    37.388     0.200
    14.559    38.130     0.200
    14.528    35.440     0.200
    14.669    37.752     0.200
    14.730    37.979     0.200
    14.781    36.335     0.200
    14.999    38.634     0.200
    14.984    39.227     0.200
    15.181    39.261     0.200
    15.181    39.558     0.200
    15.248    37.663     0.200
    15.248    37.114     0.200
    15.408    38.890     0.200
    15.408    38.437     0.200
    15.336    38.152     0.200
    15.522    37.466     0.200
    15.522    36.675     0.200
    15.522    36.553     0.200
    16.184    40.358     0.200
    16.430    39.447     0.200
    16.384    39.638     0.200
    16.610    40.661     0.200
    16.727    38.847     0.200
    16.727    39.951     0.200
    16.809    38.947     0.200
    16.907    39.305     0.200
    17.204    37.140     0.200
    17.453    37.596     0.200
    18.063    38.615     0.200
    18.409    39.533     0.200
    18.458    42.399     0.200
    18.458    42.182     0.200
    18.619    41.787     0.200
    18.643    42.955     0.200
    18.643    41.720     0.200
    19.007    42.533     0.200
    19.065    41.371     0.200
    19.179    45.485     0.200
    19.266    42.732     0.200
    19.285    41.014     0.200
    19.550    42.155     0.200
    19.550    41.921     0.200
    19.610    46.502     0.200
    19.723    41.870     0.200
    19.843    42.430     0.200
    19.837    41.041     0.200
    19.942    44.998     0.200
    20.044    40.772     0.200
    20.074    41.565     0.200
    20.117    40.279     0.200
    20.291    40.973     0.200
    20.285    40.974     0.200
    20.380    40.881     0.200
    20.379    40.810     0.200
    20.428    40.878     0.200
    20.444    41.561     0.200
    20.449    41.465     0.200
    20.672    40.283     0.200
    20.710    40.567     0.200
    20.787    40.450     0.200
    20.769    41.143     0.200
    20.864    40.332     0.200
    20.864    40.160     0.200
    20.863    40.983     0.200
    20.975    43.251     0.200
    20.992    40.372     0.200
     1.208     7.136     0.200
     1.971     8.055     0.200
     2.678     9.891     0.200
     2.698     9.295     0.200
     2.698     9.651     0.200
     2.698     9.170     0.200
     3.472    11.878     0.200
     3.597    12.651     0.200
     3.747    10.831     0.200
     3.885    12.972     0.200
     4.149    12.505     0.200
     4.439    13.901     0.200
     4.517    13.981     0.200
     4.559    13.420     0.200
     4.640    14.131     0.200
     5.027    14.987     0.200
     5.076    15.535     0.200
     5.149    15.487     0.200
     5.216    14.841     0.200
     5.483    17.417     0.200
     5.574    16.610     0.200
     5.779    19.697     0.200
     5.779    19.361     0.200
     5.779    19.533     0.200
     5.901    17.814     0.200
     5.928    17.792     0.200
     6.200    17.710     0.200
     6.414    17.409     0.200
     6.844    19.563     0.200
     6.888    20.218     0.200
     7.537    21.167     0.200
     7.563    23.250     0.200
     7.724    23.431     0.200
     7.967    22.628     0.200
     7.967    22.499     0.200
     8.043    22.150     0.200
     8.478    21.534     0.200
     8.487    23.732     0.200
     8.961    25.399     0.200
     9.157    26.939     0.200
     9.378    26.383     0.200
    10.261    28.932     0.200
    10.425    28.144     0.200
    10.716    28.347     0.200
    10.737    29.007     0.200
    10.824    27.373     0.200
    11.182    30.016     0.200
    11.345    30.505     0.200
    11.837    30.378     0.200
    12.017    30.696     0.200
    12.070    31.298     0.200
    12.365    31.121     0.200
    12.583    31.858     0.200
    12.614    33.608     0.200
    12.794    33.331     0.200
    13.144    32.549     0.200
    13.529    31.575     0.200
    13.564    31.985     0.200
    13.566    32.351     0.200
    13.657    31.694     0.200
    13.741    33.417     0.200
    13.909    32.456     0.200
    14.080    35.633     0.200
    14.167    34.506     0.200
    14.510    36.199     0.200
    15.445    38.980     0.200
     1.086     6.948     0.200
     1.929     8.072     0.200
     2.835     9.471     0.200
     2.835     9.366     0.200
     3.618    10.560     0.200
     3.918    11.300     0.200
     4.119    12.909     0.200
     4.237    11.920     0.200
     5.136    17.825     0.200
     5.656    17.566     0.200
     5.654    17.596     0.200
     5.654    19.256     0.200
     5.757    17.456     0.200
     6.373    21.681     0.200
     6.826    20.084     0.200
     7.801    21.750     0.200
     8.160    27.995     0.200
     8.311    23.829     0.200
     8.661    25.829     0.200
     8.678    24.951     0.200
     9.006    27.748     0.200
     9.315    26.018     0.200
     9.578    25.948     0.200
     9.664    27.306     0.200
     9.819    26.198     0.200
    13.472    31.594     0.200
    13.897    33.726     0.200
    15.385    37.365     0.200
    17.587    38.095     0.200
     1.990     8.178     0.200
     2.584     9.035     0.200
     2.584     8.714     0.200
     2.584     9.398     0.200
     3.368    13.045     0.200
     3.305     9.647     0.200
     3.696    13.086     0.200
     3.613    10.393     0.200
     3.803    11.785     0.200
     3.929    11.159     0.200
     4.016    11.660     0.200
     4.302    13.709     0.200
     4.382    12.935     0.200
     4.508    13.426     0.200
     4.733    11.823     0.200
     4.952    16.776     0.200
     5.026    15.629     0.200
     5.016    15.375     0.200
     5.083    14.422     0.200
     5.347    16.632     0.200
     5.371    16.816     0.200
     5.689    15.346     0.200
     5.702    17.812     0.200
     5.855    20.070     0.200
     5.855    19.859     0.200
     5.855    20.289     0.200
     5.769    17.030     0.200
     6.045    17.710     0.200
     6.065    18.749     0.200
     6.104    18.293     0.200
     6.126    17.450     0.200
     6.282    16.273     0.200
     6.345    19.963     0.200
     6.457    20.434     0.200
     6.541    18.701     0.200
     6.772    20.411     0.200
     6.962    19.031     0.200
     7.284    20.757     0.200
     7.655    24.069     0.200
     7.993    23.720     0.200
     8.080    22.397     0.200
     8.080    22.206     0.200
     8.503    24.786     0.200
     8.464    28.563     0.200
     8.610    24.269     0.200
     8.610    25.070     0.200
     8.610    22.615     0.200
     8.610    23.354     0.200
     8.899    26.803     0.200
     8.857    25.971     0.200
     8.789    29.136     0.200
     8.885    25.797     0.200
     8.960    27.091     0.200
     9.020    28.368     0.200
     9.245    26.090     0.200
     9.344    32.796     0.200
     9.562    24.907     0.200
     9.629    25.543     0.200
     9.629    26.300     0.200
     9.688    28.996     0.200
     9.799    28.219     0.200
     9.896    25.493     0.200
     9.912    26.728     0.200
     9.980    26.634     0.200
     9.980    29.005     0.200
    10.136    27.401     0.200
    10.470    29.056     0.200
    10.745    29.474     0.200
    12.561    33.675     0.200
    12.669    34.386     0.200
    12.721    32.770     0.200
    12.917    33.400     0.200
    13.549    31.974     0.200
    13.549    32.157     0.200
    13.791    36.202     0.200
    14.211    37.508     0.200
    14.647    38.133     0.200
    15.641    38.918     0.200
    17.266    39.254     0.200
    19.361    42.550     0.200
     1.210     7.884     0.200
     1.301     8.236     0.200
     1.681     9.361     0.200
     1.802     9.789     0.200
     2.088     9.919     0.200
     2.967    11.029     0.200
     1.600     8.250     0.200
     1.767     8.946     0.200
     2.046     9.691     0.200
     2.703     9.630     0.200
     1.087     7.174     0.200
     1.145     6.865     0.200
     1.428     7.416     0.200
     1.483     7.725     0.200
     1.611     7.888     0.200
     1.943     8.780     0.200
     2.194     8.962     0.200
     3.145    11.041     0.200
     3.209    13.119     0.200
     3.972    15.132     0.200
     4.624    16.984     0.200
     1.698     7.507     0.200
     1.844     7.741     0.200
     1.983     8.244     0.200
     2.196     8.793     0.200
     2.457    10.229     0.200
     2.537     9.864     0.200
     2.537     9.680     0.200
     2.648     9.726     0.200
     2.873     9.400     0.200
     3.181    11.073     0.200
     3.479    12.855     0.200
     3.636    10.986     0.200
     4.080    12.384     0.200
     4.259    12.434     0.200
     4.268    15.668     0.200
     4.268    15.555     0.200
     4.392    13.064     0.200
     4.634    15.104     0.200
     4.711    14.435     0.200
     4.659    14.677     0.200
     4.832    14.918     0.200
     5.047    16.579     0.200
     5.047    17.020     0.200
     5.173    16.975     0.200
     5.188    17.263     0.200
     5.408    14.554     0.200
     5.426    17.310     0.200
     5.694    20.004     0.200
     5.694    17.344     0.200
     5.694    19.445     0.200
     5.694    17.895     0.200
     5.776    17.603     0.200
     6.026    18.874     0.200
     6.681    19.829     0.200
     6.693    18.773     0.200
     6.841    19.519     0.200
     7.190    17.916     0.200
     7.310    20.972     0.200
     7.279    21.831     0.200
     7.279    21.370     0.200
     7.279    21.530     0.200
     7.430    22.263     0.200
     7.430    22.028     0.200
     8.040    22.382     0.200
     8.061    22.531     0.200
     8.057    25.059     0.200
     8.225    23.914     0.200
     8.300    24.416     0.200
     8.326    24.251     0.200
     8.326    23.662     0.200
     8.510    26.888     0.200
     8.614    23.724     0.200
     8.725    25.255     0.200
     8.857    23.146     0.200
     8.861    24.606     0.200
     9.311    26.191     0.200
     9.323    26.207     0.200
     9.323    25.332     0.200
     9.489    27.601     0.200
     9.722    27.475     0.200
     9.722    26.901     0.200
     9.899    26.332     0.200
    10.143    27.955     0.200
    10.153    28.203     0.200
    10.428    27.839     0.200
    10.801    27.852     0.200
    11.158    30.731     0.200
    11.680    30.614     0.200
    11.678    31.826     0.200
    11.882    31.687     0.200
    12.026    31.630     0.200
    12.171    30.631     0.200
    12.424    33.494     0.200
    12.539    32.201     0.200
    12.633    33.223     0.200
    13.524    31.604     0.200
    13.550    34.021     0.200
    13.612    35.120     0.200
    13.903    34.984     0.200
    13.980    36.461     0.200
    14.006    35.128     0.200
    14.088    36.390     0.200
    14.264    34.130     0.200
    14.320    35.444     0.200
    14.382    35.452     0.200
    14.590    38.672     0.200
    14.642    37.066     0.200
    14.788    33.956     0.200
    14.999    37.612     0.200
    15.197    38.132     0.200
    15.287    36.621     0.200
    15.413    36.241     0.200
    15.531    38.678     0.200
    16.260    39.160     0.200
    16.769    39.624     0.200
    18.104    35.438     0.200
     1.091     6.835     0.200
     1.529     7.774     0.200
     1.682     8.473     0.200
     1.682     8.575     0.200
     1.907     8.863     0.200
     1.962     8.343     0.200
     2.013     8.746     0.200
     2.397    10.204     0.200
     3.103    11.256     0.200
     3.701    14.437     0.200
     1.312     8.638     0.200
     1.412     8.759     0.200
     1.412     8.789     0.200
     1.466     9.159     0.200
     1.943     9.283     0.200
     2.213    10.750     0.200
     3.286    14.161     0.200
     1.100     7.151     0.200
     1.811     7.909     0.200
     1.811     7.739     0.200
     2.121     8.810     0.200
     2.505     9.565     0.200
     2.430    10.050     0.200
     2.430     9.880     0.200
     2.518     9.736     0.200
     2.615     9.635     0.200
     2.854     9.643     0.200
     2.854     9.220     0.200
     2.854     9.493     0.200
     3.162    11.161     0.200
     3.456    12.924     0.200
     3.456    12.615     0.200
     3.630    10.329     0.200
     3.931    10.390     0.200
     4.072    11.787     0.200
     4.250    11.886     0.200
     4.239    16.073     0.200
     4.381    12.136     0.200
     4.702    14.500     0.200
     4.644    15.043     0.200
     5.021    17.579     0.200
     5.021    17.439     0.200
     5.158    18.337     0.200
     5.407    16.888     0.200
     5.407    15.108     0.200
     5.667    19.598     0.200
     5.667    19.294     0.200
     6.004    19.430     0.200
     6.501    20.786     0.200
     6.501    20.495     0.200
     6.661    20.680     0.200
     6.677    20.651     0.200
     6.827    20.154     0.200
     7.276    21.093     0.200
     7.257    22.213     0.200
     7.257    21.864     0.200
     7.806    22.622     0.200
     7.806    21.912     0.200
     8.204    23.481     0.200
     8.292    23.778     0.200
     9.104    24.949     0.200
     9.242    25.726     0.200
     9.312    26.399     0.200
    13.491    32.186     0.200
    15.392    37.657     0.200
    20.445    40.348     0.200
    20.768    41.209     0.200
     1.017     6.977     0.200
     1.033     7.059     0.200
     1.826     8.916     0.200
     1.940    10.020     0.200
     2.380    10.691     0.200
     2.887    12.126     0.200
     3.072    13.722     0.200
     3.675    13.935     0.200
     0.775     4.955     0.200
     0.893     5.323     0.200
     1.831     7.429     0.200
     1.937     8.510     0.200
     2.178     8.664     0.200
     2.576     9.522     0.200
     2.634     9.851     0.200
     2.641     9.557     0.200
     2.952     9.632     0.200
     3.256    11.148     0.200
     3.361    11.767     0.200
     3.750    11.024     0.200
     4.049    11.811     0.200
     4.169    13.476     0.200
     4.192    13.393     0.200
     4.821    13.993     0.200
     4.935    14.277     0.200
     4.935    14.198     0.200
     4.936    15.638     0.200
     5.195    16.239     0.200
     5.332    15.711     0.200
     5.512    15.996     0.200
     5.648    16.929     0.200
     5.908    16.888     0.200
     6.413    18.236     0.200
     6.503    18.570     0.200
     6.556    17.848     0.200
     6.711    19.484     0.200
     6.872    19.599     0.200
     6.920    19.145     0.200
     7.161    19.187     0.200
     7.155    19.883     0.200
     7.158    20.392     0.200
     7.265    19.983     0.200
     7.697    21.385     0.200
     7.932    21.871     0.200
     8.103    21.912     0.200
     8.169    22.914     0.200
     8.196    22.646     0.200
     8.732    24.403     0.200
     8.724    25.376     0.200
     8.982    24.552     0.200
     9.119    23.687     0.200
     9.198    25.269     0.200
     9.189    25.603     0.200
    11.550    28.442     0.200
    12.327    32.217     0.200
    12.799    32.019     0.200
    13.460    30.805     0.200
    13.499    30.966     0.200
    13.499    33.025     0.200
    13.483    33.244     0.200
    13.773    33.134     0.200
    13.916    33.997     0.200
    14.662    36.841     0.200
    15.291    36.535     0.200
    17.050    36.405     0.200
    17.114    35.892     0.200
    17.719    37.173     0.200
    18.560    39.712     0.200
     1.214     6.916     0.200
     1.827     7.736     0.200
     1.933     8.038     0.200
     2.173     8.314     0.200
     2.352    10.095     0.200
     2.412     9.387     0.200
     2.571     9.213     0.200
     2.630     8.860     0.200
     2.637     9.266     0.200
     3.057    10.704     0.200
     2.948    10.865     0.200
     2.948     9.535     0.200
     3.254    13.382     0.200
     3.361    12.500     0.200
     3.747    10.653     0.200
     4.168    15.213     0.200
     4.045    11.462     0.200
     4.263    12.876     0.200
     4.188    12.003     0.200
     4.531    14.878     0.200
     4.935    17.547     0.200
     4.817    13.814     0.200
     4.931    13.921     0.200
     4.931    14.211     0.200
     5.190    14.697     0.200
     5.289    16.226     0.200
     5.328    14.782     0.200
     5.649    16.798     0.200
     5.508    18.170     0.200
     5.508    14.798     0.200
     5.907    19.110     0.200
     5.907    17.229     0.200
     6.145    17.487     0.200
     6.190    17.838     0.200
     6.413    20.223     0.200
     6.413    18.973     0.200
     6.557    19.002     0.200
     6.557    18.213     0.200
     6.499    19.090     0.200
     6.546    19.010     0.200
     6.709    18.354     0.200
     6.916    20.188     0.200
     6.868    20.454     0.200
     7.137    21.007     0.200
     7.157    21.342     0.200
     7.157    20.321     0.200
     7.157    23.017     0.200
     7.262    20.573     0.200
     7.698    22.016     0.200
     7.698    21.606     0.200
     7.928    21.722     0.200
     7.933    21.569     0.200
     8.103    23.280     0.200
     8.171    22.369     0.200
     8.197    23.220     0.200
     8.225    24.289     0.200
     8.546    22.654     0.200
     8.596    22.567     0.200
     8.706    26.697     0.200
     8.725    24.173     0.200
     8.733    24.259     0.200
     8.733    23.800     0.200
     8.984    24.897     0.200
     8.984    23.916     0.200
     9.121    23.092     0.200
     9.191    25.019     0.200
     9.195    24.351     0.200
     9.198    24.804     0.200
     9.360    26.504     0.200
     9.453    24.979     0.200
     9.539    26.323     0.200
     9.398    25.563     0.200
     9.461    28.447     0.200
     9.461    24.039     0.200
     9.695    25.882     0.200
     9.771    24.626     0.200
     9.674    27.060     0.200
     9.674    25.269     0.200
     9.879    25.186     0.200
    10.015    26.519     0.200
    10.015    23.728     0.200
    10.026    27.939     0.200
    10.458    27.135     0.200
    10.338    30.298     0.200
    10.674    25.985     0.200
    10.558    30.623     0.200
    10.574    29.293     0.200
    10.881    32.372     0.200
    11.085    27.212     0.200
    11.094    29.190     0.200
    11.004    28.300     0.200
    11.004    32.195     0.200
    11.551    30.659     0.200
    11.551    29.069     0.200
    11.757    30.589     0.200
    12.104    31.866     0.200
    12.208    29.617     0.200
    12.301    31.484     0.200
    12.327    32.620     0.200
    12.327    31.610     0.200
    12.307    33.073     0.200
    12.636    32.509     0.200
    12.799    33.236     0.200
    12.832    33.761     0.200
    12.935    33.632     0.200
    13.295    33.078     0.200
    13.457    31.299     0.200
    13.496    31.909     0.200
    13.496    33.959     0.200
    13.496    31.078     0.200
    13.496    31.188     0.200
    13.593    37.304     0.200
    13.775    32.069     0.200
    13.855    35.420     0.200
    13.905    34.001     0.200
    13.916    35.084     0.200
    13.916    31.974     0.200
    14.197    36.183     0.200
    14.425    36.819     0.200
    14.425    37.040     0.200
    14.662    37.276     0.200
    14.880    37.028     0.200
    14.993    38.620     0.200
    14.993    34.401     0.200
    15.291    35.768     0.200
    15.291    37.718     0.200
    15.291    38.178     0.200
    15.565    38.610     0.200
    15.654    38.598     0.200
    15.668    37.983     0.200
    15.915    34.588     0.200
    16.298    38.224     0.200
    16.552    38.105     0.200
    17.048    37.536     0.200
    17.111    39.060     0.200
    17.372    36.341     0.200
    17.716    38.796     0.200
    18.125    36.195     0.200
    20.561    39.785     0.200
    20.860    40.772     0.200
     0.774     5.188     0.200
     0.906     5.487     0.200
     0.906     5.730     0.200
     1.216     6.858     0.200
     1.341     6.915     0.200
     1.341     6.517     0.200
     1.847     7.966     0.200
     1.954     8.716     0.200
     2.190     8.500     0.200
     2.426     9.977     0.200
     2.426     9.524     0.200
     2.587     9.760     0.200
     2.657     9.917     0.200
     2.958     9.922     0.200
     2.958     9.766     0.200
     3.071    10.802     0.200
     3.377    12.492     0.200
     3.377    12.226     0.200
     3.749    10.888     0.200
     3.749    11.091     0.200
     4.187    15.211     0.200
     4.273    12.529     0.200
     4.273    12.381     0.200
     4.250    12.793     0.200
     4.543    14.306     0.200
     4.622    14.076     0.200
     4.821    13.726     0.200
     4.953    15.618     0.200
     4.937    13.953     0.200
     4.944    14.201     0.200
     5.179    14.924     0.200
     5.298    15.048     0.200
     5.312    16.800     0.200
     5.331    14.775     0.200
     5.513    15.808     0.200
     5.513    15.440     0.200
     5.607    19.812     0.200
     5.607    16.218     0.200
     5.923    18.502     0.200
     5.923    17.901     0.200
     6.430    20.465     0.200
     6.430    17.957     0.200
     6.503    17.636     0.200
     6.571    18.767     0.200
     6.571    18.571     0.200
     6.577    18.874     0.200
     6.552    17.691     0.200
     6.722    19.291     0.200
     6.937    19.756     0.200
     7.146    19.495     0.200
     7.146    20.230     0.200
     7.172    20.821     0.200
     7.172    19.477     0.200
     7.167    19.919     0.200
     7.167    18.630     0.200
     7.452    19.872     0.200
     7.582    21.292     0.200
     7.711    21.830     0.200
     7.711    21.260     0.200
     7.797    20.520     0.200
     7.936    21.227     0.200
     7.945    22.127     0.200
     7.945    21.822     0.200
     8.052    22.502     0.200
     8.117    22.433     0.200
     8.178    22.173     0.200
     8.178    22.298     0.200
     8.159    22.454     0.200
     8.207    23.034     0.200
     8.354    22.647     0.200
     8.556    23.702     0.200
     8.608    22.285     0.200
     8.608    23.176     0.200
     8.733    22.900     0.200
     8.744    23.102     0.200
     8.828    23.030     0.200
     8.899    24.356     0.200
     8.991    23.915     0.200
     8.991    24.095     0.200
     9.127    24.383     0.200
     9.127    23.743     0.200
     9.212    25.494     0.200
     9.212    24.283     0.200
     9.367    24.909     0.200
     9.401    23.523     0.200
     9.459    24.387     0.200
     9.544    24.851     0.200
     9.671    25.381     0.200
     9.700    25.170     0.200
     9.770    25.323     0.200
     9.783    25.570     0.200
     9.783    24.617     0.200
     9.889    24.906     0.200
    10.021    25.498     0.200
    10.469    27.412     0.200
    10.469    27.100     0.200
    11.036    27.526     0.200
    11.097    27.939     0.200
    11.103    28.112     0.200
    11.698    29.441     0.200
    11.761    29.594     0.200
    11.906    29.764     0.200
    12.113    30.724     0.200
    12.203    29.237     0.200
    12.203    29.839     0.200
    12.340    32.542     0.200
    12.340    31.128     0.200
    12.813    31.650     0.200
    12.833    31.489     0.200
    12.947    32.359     0.200
    13.478    33.223     0.200
    13.478    32.817     0.200
    13.517    31.964     0.200
    13.782    33.762     0.200
    13.931    33.801     0.200
    14.072    34.042     0.200
    14.138    35.095     0.200
    14.199    34.038     0.200
    14.469    34.322     0.200
    14.676    35.133     0.200
    14.881    35.943     0.200
    15.005    36.594     0.200
    15.306    37.720     0.200
    15.306    37.360     0.200
    15.434    36.272     0.200
    15.518    37.978     0.200
    15.657    37.069     0.200
    15.668    36.691     0.200
    15.675    37.320     0.200
    15.757    38.431     0.200
    15.875    38.087     0.200
    16.138    37.386     0.200
    16.244    37.934     0.200
    17.413    38.332     0.200
    18.563    40.658     0.200
    18.657    39.302     0.200
     1.188     7.452     0.200
     1.508     8.343     0.200
     1.508     8.206     0.200
     1.548     8.087     0.200
     1.571     8.754     0.200
     1.610     8.170     0.200
     2.489    10.777     0.200
     2.704    11.090     0.200
     2.704    10.238     0.200
     3.834    12.042     0.200
     3.834    12.761     0.200
     3.883    13.783     0.200
     4.047    13.530     0.200
     4.048    13.996     0.200
     4.238    13.796     0.200
     4.366    14.231     0.200
     4.438    15.047     0.200
     4.684    16.069     0.200
     4.784    16.106     0.200
     4.784    17.637     0.200
     4.784    16.676     0.200
     4.819    16.331     0.200
     4.835    16.619     0.200
     4.910    16.178     0.200
     4.987    17.038     0.200
     5.133    16.600     0.200
     5.133    17.881     0.200
     5.433    17.704     0.200
     6.046    19.760     0.200
     6.046    19.397     0.200
     6.198    17.373     0.200
     6.252    19.753     0.200
     6.365    20.457     0.200
     6.365    19.906     0.200
     6.568    21.467     0.200
     6.835    21.577     0.200
     6.835    21.308     0.200
     6.872    21.219     0.200
     7.123    22.109     0.200
     7.123    21.726     0.200
     7.263    23.210     0.200
     7.583    22.097     0.200
     7.623    24.830     0.200
     7.736    22.741     0.200
     7.993    23.407     0.200
     8.037    26.159     0.200
     8.383    27.004     0.200
     8.396    23.815     0.200
     8.407    24.220     0.200
     8.419    23.639     0.200
     8.456    27.360     0.200
     8.505    24.079     0.200
     8.520    22.830     0.200
     8.535    25.078     0.200
     8.535    25.226     0.200
     8.571    26.480     0.200
     8.668    24.581     0.200
     8.683    27.686     0.200
     8.839    25.112     0.200
     8.839    27.733     0.200
     8.942    25.306     0.200
     8.942    25.143     0.200
     9.029    25.851     0.200
     9.055    25.356     0.200
     9.222    25.669     0.200
     9.278    25.552     0.200
     9.286    26.104     0.200
     9.294    26.101     0.200
     9.466    26.486     0.200
     9.497    26.847     0.200
     9.738    26.555     0.200
    10.006    26.696     0.200
    10.044    27.392     0.200
    10.141    28.306     0.200
    10.496    27.702     0.200
    10.721    31.109     0.200
    10.721    28.972     0.200
    11.053    29.838     0.200
    11.158    29.454     0.200
    11.571    29.463     0.200
    11.688    29.734     0.200
    11.706    29.950     0.200
    11.709    30.837     0.200
    12.015    32.772     0.200
    12.041    32.888     0.200
    12.067    31.432     0.200
    12.130    30.283     0.200
    12.138    30.884     0.200
    12.153    30.310     0.200
    12.302    31.581     0.200
    12.333    30.446     0.200
    12.382    31.737     0.200
    12.389    31.749     0.200
    12.389    30.550     0.200
    12.551    30.393     0.200
    12.589    32.170     0.200
    12.739    31.128     0.200
    12.857    33.664     0.200
    12.890    32.471     0.200
    13.031    32.554     0.200
    13.106    33.929     0.200
    13.177    32.652     0.200
    13.293    34.372     0.200
    13.317    33.701     0.200
    13.434    34.238     0.200
    13.434    34.019     0.200
    13.467    39.313     0.200
    13.612    35.441     0.200
    13.641    34.300     0.200
    13.942    34.264     0.200
    13.952    34.166     0.200
    14.100    35.121     0.200
    14.124    34.495     0.200
    14.179    33.972     0.200
    14.284    34.559     0.200
    14.492    35.949     0.200
    14.511    36.234     0.200
    14.621    36.837     0.200
    14.621    37.615     0.200
    14.737    37.055     0.200
    14.790    38.976     0.200
    14.805    38.914     0.200
    14.969    38.619     0.200
    14.986    37.609     0.200
    15.016    39.625     0.200
    15.074    37.065     0.200
    15.186    38.092     0.200
    15.207    37.581     0.200
    15.294    39.343     0.200
    15.290    37.889     0.200
    15.329    40.166     0.200
    15.465    39.639     0.200
    15.563    38.256     0.200
    15.612    38.875     0.200
    15.744    39.063     0.200
    15.858    38.955     0.200
    16.405    38.966     0.200
    16.679    41.070     0.200
    16.841    40.669     0.200
    17.068    40.687     0.200
    17.365    40.137     0.200
    18.106    40.756     0.200
    18.420    41.573     0.200
    18.599    42.342     0.200
    18.951    41.019     0.200
    19.186    42.013     0.200
    19.360    42.642     0.200
    19.776    41.391     0.200
    19.888    40.904     0.200
    19.947    40.769     0.200
    20.452    41.355     0.200
    20.585    41.182     0.200
     1.374     7.940     0.200
     1.723     8.539     0.200
     2.029     8.724     0.200
     3.095    10.512     0.200
     4.157    12.683     0.200
     4.394    15.054     0.200
     4.683    14.951     0.200
     5.017    15.639     0.200
     1.455     8.824     0.200
     1.565     8.552     0.200
     1.605     9.203     0.200
     1.605     8.524     0.200
     2.408    10.804     0.200
     2.584    11.725     0.200
     2.584    11.485     0.200
     2.704    10.711     0.200
     3.827    13.987     0.200
     3.880    12.789     0.200
     3.880    12.668     0.200
     3.975    14.467     0.200
     4.078    13.016     0.200
     4.078    13.247     0.200
     4.275    13.607     0.200
     4.335    14.709     0.200
     4.413    14.681     0.200
     4.657    17.060     0.200
     4.657    16.450     0.200
     4.677    15.069     0.200
     4.722    15.752     0.200
     4.848    15.829     0.200
     4.876    16.287     0.200
     4.852    17.073     0.200
     5.022    16.716     0.200
     5.361    17.545     0.200
     5.448    17.590     0.200
     5.845    19.300     0.200
     5.917    19.360     0.200
     6.104    19.059     0.200
     6.178    19.622     0.200
     6.229    19.658     0.200
     6.229    19.379     0.200
     6.544    20.195     0.200
     6.706    21.178     0.200
     6.807    21.062     0.200
     6.807    20.742     0.200
     6.977    20.621     0.200
     7.029    22.011     0.200
     7.197    21.036     0.200
     7.660    22.639     0.200
     7.660    22.821     0.200
     8.307    23.390     0.200
     8.428    25.232     0.200
     8.618    26.760     0.200
     8.771    26.379     0.200
     8.771    26.949     0.200
     8.790    26.718     0.200
     9.020    28.680     0.200
     9.487    27.418     0.200
     9.557    27.307     0.200
     9.703    27.566     0.200
    10.078    27.710     0.200
    10.969    29.578     0.200
    10.969    30.309     0.200
    11.400    31.174     0.200
    11.952    31.517     0.200
    11.952    31.978     0.200
    12.775    35.842     0.200
    14.984    37.725     0.200
    15.004    37.544     0.200
    15.320    37.430     0.200
    15.807    39.155     0.200
    16.028    39.230     0.200
    16.331    39.676     0.200
    16.578    39.513     0.200
     1.303     7.491     0.200
     1.582     8.109     0.200
     1.606     8.212     0.200
     2.584    11.049     0.200
     2.718    10.170     0.200
     3.888    12.153     0.200
     4.285    13.580     0.200
     4.355    14.784     0.200
     4.422    14.340     0.200
     4.662    17.020     0.200
     4.732    15.924     0.200
     5.032    17.025     0.200
     5.935    17.743     0.200
     1.460     8.761     0.200
     1.559     8.395     0.200
     1.599     8.762     0.200
     1.599     8.432     0.200
     1.760     8.497     0.200
     1.830    10.136     0.200
     2.414    10.537     0.200
     2.590    11.495     0.200
     2.590    11.315     0.200
     2.698    10.747     0.200
     2.698    10.913     0.200
     2.698    10.593     0.200
     3.834    14.274     0.200
     3.968    13.273     0.200
     4.072    13.069     0.200
     4.269    13.628     0.200
     4.332    14.625     0.200
     4.406    13.683     0.200
     4.661    17.117     0.200
     4.661    17.319     0.200
     4.683    16.291     0.200
     4.708    16.698     0.200
     4.716    15.435     0.200
     4.841    14.921     0.200
     4.858    16.331     0.200
     5.015    16.510     0.200
     5.057    17.405     0.200
     5.057    16.985     0.200
     5.355    17.607     0.200
     5.442    17.733     0.200
     5.871    18.717     0.200
     5.916    19.151     0.200
     5.968    19.657     0.200
     6.097    18.660     0.200
     6.224    19.655     0.200
     6.229    19.539     0.200
     6.229    19.338     0.200
     6.292    21.005     0.200
     6.292    21.006     0.200
     6.442    21.205     0.200
     6.510    20.360     0.200
     6.537    22.394     0.200
     6.801    21.819     0.200
     6.801    22.139     0.200
     6.801    21.369     0.200
     6.885    21.515     0.200
     6.978    20.458     0.200
     7.035    22.227     0.200
     7.035    21.897     0.200
     7.035    21.717     0.200
     7.213    22.326     0.200
     7.308    22.384     0.200
     7.308    24.247     0.200
     7.308    24.195     0.200
     7.309    24.624     0.200
     7.309    24.295     0.200
     7.376    21.758     0.200
     7.666    22.521     0.200
     7.666    23.072     0.200
     7.687    23.460     0.200
     7.741    23.836     0.200
     8.019    23.863     0.200
     8.133    23.384     0.200
     8.250    24.635     0.200
     8.303    24.249     0.200
     8.371    24.274     0.200
     8.390    26.709     0.200
     8.399    25.732     0.200
     8.412    24.320     0.200
     8.434    24.706     0.200
     8.434    24.956     0.200
     8.469    25.449     0.200
     8.543    24.198     0.200
     8.546    23.779     0.200
     8.621    24.972     0.200
     8.624    27.009     0.200
     8.796    26.354     0.200
     8.952    26.175     0.200
     8.977    25.349     0.200
     9.006    25.708     0.200
     9.185    25.736     0.200
     9.276    24.740     0.200
     9.304    25.774     0.200
     9.396    28.283     0.200
     9.478    29.532     0.200
     9.480    27.280     0.200
     9.478    28.481     0.200
     9.550    28.899     0.200
     9.593    29.997     0.200
     9.642    25.675     0.200
     9.901    30.067     0.200
    10.009    29.192     0.200
    10.057    30.251     0.200
    10.085    29.270     0.200
    10.212    30.780     0.200
    10.272    30.957     0.200
    10.380    31.448     0.200
    10.690    32.093     0.200
    12.416    31.081     0.200
    12.411    29.144     0.200
    13.380    34.517     0.200
    13.519    35.965     0.200
    14.515    36.463     0.200
    15.141    37.176     0.200
    15.180    37.982     0.200
    15.247    36.618     0.200
    15.287    38.047     0.200
    15.296    37.314     0.200
    15.314    39.877     0.200
    15.423    37.436     0.200
    15.513    36.946     0.200
    18.654    44.279     0.200
    19.805    41.259     0.200
    19.911    41.358     0.200
    20.025    41.499     0.200
    20.114    41.758     0.200
    20.425    41.942     0.200
    20.425    40.501     0.200
    20.755    39.969     0.200
     1.454     8.449     0.200
     1.561     8.342     0.200
     1.605     8.905     0.200
     1.605     8.472     0.200
     1.760     8.740     0.200
     2.409    10.731     0.200
     2.584    11.571     0.200
     2.584    11.372     0.200
     2.702    10.608     0.200
     3.829    13.539     0.200
     4.274    13.878     0.200
     4.332    15.283     0.200
     4.411    15.102     0.200
     4.655    15.414     0.200
     4.655    16.484     0.200
     4.655    17.210     0.200
     4.678    15.337     0.200
     4.720    16.054     0.200
     4.853    15.754     0.200
     4.846    16.061     0.200
     5.020    17.090     0.200
     5.359    17.510     0.200
     5.446    16.647     0.200
     5.845    17.876     0.200
     5.914    19.122     0.200
     5.963    17.694     0.200
     6.226    19.146     0.200
     6.226    19.408     0.200
     6.804    22.079     0.200
     9.004    22.732     0.200
     9.065    23.254     0.200
     9.309    24.225     0.200
     9.554    24.834     0.200
     9.597    24.845     0.200
     9.971    25.161     0.200
    10.000    25.796     0.200
    10.080    25.923     0.200
    10.491    27.160     0.200
    10.693    28.513     0.200
    10.878    27.070     0.200
    10.970    28.497     0.200
    11.189    27.670     0.200
    11.742    29.329     0.200
    11.881    29.708     0.200
    12.096    29.639     0.200
    12.100    29.430     0.200
    12.407    28.483     0.200
    13.375    35.029     0.200
    15.117    35.457     0.200
    15.115    35.152     0.200
    16.025    37.428     0.200
    16.275    37.856     0.200
    16.280    36.698     0.200
    16.332    37.535     0.200
    17.955    39.054     0.200
     1.167     7.539     0.200
     1.167     7.400     0.200
     1.344     8.425     0.200
     1.464     8.981     0.200
     2.061     9.067     0.200
     2.205     9.928     0.200
     2.477    10.863     0.200
     2.477    10.613     0.200
     3.155    11.031     0.200
     3.519    12.061     0.200
     3.636    12.150     0.200
     3.728    13.602     0.200
     4.471    15.002     0.200
     4.489    15.478     0.200
     4.550    14.813     0.200
     4.654    14.742     0.200
     4.697    16.774     0.200
     4.697    14.929     0.200
     4.697    18.044     0.200
     4.813    16.198     0.200
     4.844    16.498     0.200
     4.832    15.969     0.200
     5.406    18.580     0.200
     5.928    18.622     0.200
     6.313    20.400     0.200
     6.857    20.393     0.200
     6.857    20.764     0.200
     6.885    19.115     0.200
     7.292    21.898     0.200
     7.292    22.389     0.200
     7.950    23.233     0.200
     8.098    24.479     0.200
     8.293    23.873     0.200
    11.933    28.088     0.200
    12.673    29.883     0.200
    13.070    31.796     0.200
    14.418    33.491     0.200
    18.295    38.769     0.200
     2.878    10.768     0.200
     5.790    19.983     0.200
    10.915    28.697     0.200
    12.335    32.349     0.200
    13.613    33.239     0.200
    13.975    34.738     0.200
    15.505    37.042     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.548    14.777     0.200
     3.270    20.046     0.200
     4.176    25.775     0.200
     3.242    20.084     0.200
     4.084    26.461     0.200
     4.171    25.642     0.200
     3.509    22.825     0.200
     2.651    15.724     0.200
     3.284    22.439     0.200
     4.666    28.325     0.200
     4.778    31.017     0.200
     2.881    17.121     0.200
     2.881    16.096     0.200
     6.082    41.943     0.200
     2.905    17.830     0.200
     4.623    27.147     0.200
     2.585    15.379     0.200
     3.964    25.109     0.200
     4.231    27.124     0.200
     4.732    28.620     0.200
     4.704    29.354     0.200
     7.196    56.564     0.200
     7.646    59.235     0.200
     2.574    13.986     0.200
     2.657    15.803     0.200
     2.764    16.190     0.200
     2.764    15.627     0.200
     5.259    32.181     0.200
     5.663    38.467     0.200
     3.806    27.018     0.200
     2.584    16.765     0.200
     2.905    19.383     0.200
     4.490    28.109     0.200
     2.606    15.072     0.200
     2.615    14.925     0.200
     2.634    14.301     0.200
     2.958    17.094     0.200
     2.704    16.822     0.200
     2.702    15.557     0.200
     2.878    17.494     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.478     3.822     0.200
     0.556     3.804     0.200
     0.735     3.918     0.200
     0.794     5.235     0.200
     0.929     5.760     0.200
     0.946     5.455     0.200
     1.084     6.142     0.200
     1.300     7.626     0.200
     0.484     3.738     0.200
     0.557     3.782     0.200
     0.748     3.653     0.200
     0.810     5.327     0.200
     0.945     5.854     0.200
     0.955     5.930     0.200
     1.089     6.173     0.200
     1.315     7.644     0.200
     0.495     3.532     0.200
     0.532     3.594     0.200
     0.737     3.706     0.200
     0.802     4.951     0.200
     0.771     5.113     0.200
     0.915     5.626     0.200
     0.957     5.838     0.200
     0.484     3.773     0.200
     0.551     3.583     0.200
     0.718     4.538     0.200
     0.741     3.973     0.200
     0.796     5.231     0.200
     0.784     5.167     0.200
     0.933     5.735     0.200
     0.952     6.204     0.200
     1.090     6.196     0.200
     1.300     7.648     0.200
     1.927    11.729     0.200
     0.111     1.934     0.200
     0.308     2.342     0.200
     0.469     2.969     0.200
     0.655     4.498     0.200
     0.643     3.433     0.200
     0.744     4.960     0.200
     0.989     5.601     0.200
     2.080    12.466     0.200
     0.420     3.071     0.200
     0.698     3.733     0.200
     0.759     4.813     0.200
     0.978     5.560     0.200
     1.060     5.605     0.200
     1.123     5.869     0.200
     0.618     4.444     0.200
     0.639     3.802     0.200
     0.727     4.782     0.200
     0.893     4.646     0.200
     0.987     5.642     0.200
     0.252     2.036     0.200
     0.474     2.849     0.200
     0.574     4.276     0.200
     0.662     4.449     0.200
     0.684     3.703     0.200
     0.972     6.029     0.200
     1.230     6.418     0.200
     1.263     7.234     0.200
     3.112    14.452     0.200
     3.405    15.642     0.200
     0.382     2.639     0.200
     0.441     3.055     0.200
     1.216     6.243     0.200
     1.200     7.905     0.200
     0.218     2.265     0.200
     0.757     4.593     0.200
     0.868     5.337     0.200
     0.824     4.557     0.200
     0.972     6.078     0.200
     0.991     6.016     0.200
     0.361     2.578     0.200
     0.586     3.450     0.200
     0.866     5.202     0.200
     1.202     6.563     0.200
     0.219     2.436     0.200
     0.519     3.508     0.200
     0.609     3.765     0.200
     1.211     6.426     0.200
     0.571     3.998     0.200
     0.404     3.307     0.200
     0.866     5.482     0.200
     0.741     4.772     0.200
     0.867     5.383     0.200
     0.905     5.286     0.200
     1.253     7.405     0.200
     2.585    13.102     0.200
     5.696    28.718     0.200
     0.417     3.540     0.200
     0.559     4.275     0.200
     0.751     4.735     0.200
     0.751     5.044     0.200
     0.887     5.594     0.200
     0.887     5.544     0.200
     0.851     5.986     0.200
     0.921     5.471     0.200
     0.921     5.841     0.200
     1.259     7.610     0.200
     0.637     3.928     0.200
     0.383     3.050     0.200
     0.414     2.212     0.200
     0.398     2.846     0.200
     0.398     2.975     0.200
     0.398     2.166     0.200
     0.457     3.069     0.200
     0.395     2.780     0.200
     0.395     2.869     0.200
     0.450     3.140     0.200
     0.595     3.436     0.200
     0.595     3.216     0.200
     0.632     3.934     0.200
     0.597     3.720     0.200
     0.644     3.676     0.200
     0.619     3.240     0.200
     0.661     3.776     0.200
     0.306     2.192     0.200
     0.306     2.222     0.200
     0.323     2.417     0.200
     0.324     2.426     0.200
     0.538     3.298     0.200
     0.986     6.183     0.200
     1.145     7.473     0.200
     2.040    11.931     0.200
     0.350     2.099     0.200
     0.351     1.939     0.200
     0.591     3.955     0.200
     0.591     3.212     0.200
     0.625     4.050     0.200
     0.430     2.950     0.200
     0.430     2.731     0.200
     0.455     3.313     0.200
     0.456     3.198     0.200
     0.615     4.058     0.200
     0.717     4.480     0.200
     1.122     6.074     0.200
     2.150    12.367     0.200
     2.967    16.017     0.200
     0.140     1.314     0.200
     0.357     2.741     0.200
     0.351     2.351     0.200
     0.351     2.195     0.200
     0.410     2.940     0.200
     0.410     2.767     0.200
     0.454     2.638     0.200
     0.611     3.582     0.200
     0.897     5.049     0.200
     0.239     1.639     0.200
     0.239     2.199     0.200
     0.295     2.363     0.200
     0.277     2.503     0.200
     0.278     2.429     0.200
     0.423     2.780     0.200
     0.661     4.478     0.200
     0.817     4.897     0.200
     0.998     5.823     0.200
     1.097     6.710     0.200
     1.103     6.070     0.200
     1.949    11.456     0.200
     0.239     2.065     0.200
     0.357     2.734     0.200
     0.357     2.677     0.200
     0.437     2.957     0.200
     0.528     3.640     0.200
     0.695     4.205     0.200
     0.967     5.400     0.200
     1.142     6.169     0.200
     0.193     1.930     0.200
     0.376     2.889     0.200
     0.376     2.979     0.200
     0.409     3.065     0.200
     0.431     3.525     0.200
     0.432     3.273     0.200
     0.469     3.362     0.200
     0.635     3.880     0.200
     0.910     5.122     0.200
     1.173     6.588     0.200
     0.228     2.005     0.200
     0.228     2.035     0.200
     0.271     2.117     0.200
     0.399     2.854     0.200
     0.643     4.085     0.200
     0.797     4.613     0.200
     1.000     5.701     0.200
     1.085     5.936     0.200
     0.214     2.171     0.200
     0.336     2.633     0.200
     0.510     3.234     0.200
     0.493     3.336     0.200
     1.292     7.315     0.200
     1.296     6.695     0.200
     1.990    11.627     0.200
     0.474     3.014     0.200
     0.659     3.450     0.200
     0.660     4.205     0.200
     0.696     4.301     0.200
     0.734     4.809     0.200
     0.937     5.677     0.200
     0.978     6.854     0.200
     1.318     7.545     0.200
     1.446     8.165     0.200
     0.285     2.844     0.200
     0.690     4.533     0.200
     0.759     5.072     0.200
     0.794     4.872     0.200
     0.847     5.338     0.200
     0.919     5.563     0.200
     0.938     5.176     0.200
     0.977     5.695     0.200
     0.989     6.307     0.200
     1.151     6.834     0.200
     1.301     7.721     0.200
     1.482     8.528     0.200
     0.197     2.555     0.200
     0.350     2.364     0.200
     0.480     2.548     0.200
     0.813     5.149     0.200
     0.898     5.838     0.200
     1.277     6.791     0.200
     0.314     2.535     0.200
     0.271     2.248     0.200
     0.271     2.408     0.200
     0.271     2.306     0.200
     0.454     3.079     0.200
     0.454     3.266     0.200
     0.663     4.614     0.200
     1.104     5.895     0.200
     1.020     6.194     0.200
     1.326     6.443     0.200
     1.329     6.930     0.200
     1.698     9.796     0.200
     1.844    10.824     0.200
     0.238     2.092     0.200
     0.644     3.511     0.200
     1.005     6.365     0.200
     1.093     6.741     0.200
     1.249     7.250     0.200
     0.225     1.566     0.200
     0.334     1.676     0.200
     0.514     2.651     0.200
     0.735     4.310     0.200
     1.012     6.413     0.200
     1.125     7.233     0.200
     1.436     7.581     0.200
     2.227    11.597     0.200
     2.406    15.387     0.200
     2.491    14.618     0.200
     2.496    14.876     0.200
     0.242     2.434     0.200
     0.242     2.382     0.200
     0.242     2.442     0.200
     0.422     3.185     0.200
     0.655     4.500     0.200
     0.655     4.493     0.200
     0.745     5.006     0.200
     1.003     5.651     0.200
     1.294     6.460     0.200
     1.811    10.129     0.200
     2.121    11.489     0.200
     0.382     2.725     0.200
     0.518     3.591     0.200
     0.625     3.749     0.200
     0.696     4.825     0.200
     0.835     4.954     0.200
     1.408     8.380     0.200
     0.201     2.210     0.200
     0.389     2.950     0.200
     0.466     3.412     0.200
     0.656     4.473     0.200
     1.218     6.309     0.200
     1.327     7.089     0.200
     0.198     2.000     0.200
     0.198     2.141     0.200
     0.198     2.211     0.200
     0.385     2.878     0.200
     0.461     3.614     0.200
     0.461     3.374     0.200
     0.655     4.362     0.200
     0.893     5.174     0.200
     0.772     4.892     0.200
     1.214     6.067     0.200
     1.322     6.448     0.200
     0.219     2.412     0.200
     0.219     2.045     0.200
     0.219     2.302     0.200
     0.219     2.305     0.200
     0.394     3.044     0.200
     0.479     3.624     0.200
     1.217     6.069     0.200
     0.303     3.079     0.200
     0.465     3.268     0.200
     0.711     4.654     0.200
     0.712     4.260     0.200
     0.712     5.280     0.200
     0.712     4.785     0.200
     0.737     4.657     0.200
     0.861     5.290     0.200
     1.045     6.798     0.200
     0.138     1.619     0.200
     0.320     2.370     0.200
     0.298     2.614     0.200
     0.642     4.100     0.200
     0.753     4.857     0.200
     0.929     5.730     0.200
     1.126     6.425     0.200
     0.284     2.806     0.200
     0.568     3.988     0.200
     0.691     4.685     0.200
     0.765     4.980     0.200
     0.796     4.698     0.200
     0.796     4.807     0.200
     0.853     5.160     0.200
     0.915     5.776     0.200
     0.915     6.096     0.200
     0.995     6.113     0.200
     1.306     7.770     0.200
     1.481     8.175     0.200
     1.605     9.824     0.200
     1.824    11.298     0.200
     0.269     2.680     0.200
     0.549     3.867     0.200
     0.706     4.281     0.200
     0.757     4.876     0.200
     0.777     4.765     0.200
     0.839     5.046     0.200
     0.932     5.638     0.200
     0.987     6.017     0.200
     1.500     8.678     0.200
     0.291     2.565     0.200
     0.685     5.066     0.200
     0.685     4.716     0.200
     0.761     4.952     0.200
     0.761     5.122     0.200
     0.852     5.357     0.200
     0.852     5.066     0.200
     0.852     5.197     0.200
     0.852     5.243     0.200
     0.913     6.169     0.200
     0.913     5.849     0.200
     0.992     6.121     0.200
     1.476     8.201     0.200
     0.287     2.659     0.200
     0.688     4.619     0.200
     0.766     5.078     0.200
     0.855     5.329     0.200
     0.855     5.189     0.200
     0.856     5.186     0.200
     0.911     5.628     0.200
     0.911     5.886     0.200
     0.997     6.331     0.200
     1.478     8.255     0.200
     1.825    10.289     0.200
     0.294     2.193     0.200
     0.258     3.165     0.200
     0.748     4.631     0.200
     0.748     4.442     0.200
     0.748     4.561     0.200
     0.749     4.468     0.200
     0.854     5.462     0.200
     1.034     6.290     0.200
     1.344     7.645     0.200
     0.367     2.563     0.200
     0.367     2.595     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     7.195   102.735     0.200
     1.271    24.873     0.200
     0.978    19.560     0.200
     4.309    64.490     0.200
     6.042    84.560     0.200
     4.104    60.668     0.200
     7.080    99.284     0.200
     7.080   100.534     0.200
     2.657    41.499     0.200
     3.712    51.930     0.200
     3.909    57.938     0.200
     4.483    65.777     0.200
     5.179    73.656     0.200
     4.058    60.768     0.200
     4.224    58.617     0.200
     1.253    24.488     0.200
     2.585    40.988     0.200
     4.704    71.631     0.200
     6.278    88.188     0.200
     7.116    99.497     0.200
     1.259    24.800     0.200
     1.935    33.454     0.200
     2.574    42.407     0.200
     6.058    89.893     0.200
     3.805    56.617     0.200
    12.994   174.320     0.200
     1.200    23.018     0.200
     3.389    47.932     0.200
     3.692    51.227     0.200
     3.831    52.927     0.200
     3.889    55.374     0.200
     4.010    58.091     0.200
     4.093    57.610     0.200
     4.590    67.749     0.200
     5.159    72.371     0.200
     5.365    76.376     0.200
     5.428    77.129     0.200
    12.113   167.987     0.200
     2.455    38.224     0.200
     2.455    38.712     0.200
     2.697    44.098     0.200
     2.706    39.063     0.200
     3.618    55.383     0.200
     5.802    83.014     0.200
     7.085   102.394     0.200
    11.059   154.204     0.200
    11.355   156.365     0.200
    11.894   163.983     0.200
    12.080   165.783     0.200
    12.503   162.828     0.200
    12.539   171.063     0.200
    12.592   172.171     0.200
    12.623   171.628     0.200
    13.553   176.152     0.200
    13.749   186.596     0.200
    14.177   192.117     0.200
    15.560   204.358     0.200
     2.896    41.612     0.200
     3.798    57.411     0.200
     0.986    20.105     0.200
     2.975    43.678     0.200
     3.463    53.919     0.200
     4.037    59.026     0.200
     4.173    58.002     0.200
     4.225    62.872     0.200
     4.353    62.713     0.200
     4.439    65.581     0.200
     4.340    66.772     0.200
     4.725    69.295     0.200
     5.505    79.151     0.200
     5.389    79.951     0.200
     6.651    98.792     0.200
     6.835   102.044     0.200
    12.213   160.758     0.200
     2.653    42.769     0.200
     2.697    44.103     0.200
     2.921    41.812     0.200
     1.280    26.344     0.200
     1.485    26.423     0.200
     3.665    54.926     0.200
     1.154    22.230     0.200
     1.168    23.435     0.200
     3.730    54.624     0.200
     4.049    62.458     0.200
     4.131    61.082     0.200
     5.196    75.217     0.200
     5.737    84.420     0.200
     7.991   110.171     0.200
     2.858    42.107     0.200
     2.858    41.892     0.200
     3.452    52.997     0.200
     3.618    54.243     0.200
     3.937    55.557     0.200
     4.078    57.323     0.200
     4.337    61.461     0.200
     4.375    66.991     0.200
     4.826    68.902     0.200
     5.338    77.059     0.200
     5.402    76.395     0.200
     5.610    81.203     0.200
     5.663    86.698     0.200
     5.663    80.547     0.200
     5.674    82.460     0.200
     2.759    44.190     0.200
     2.759    40.829     0.200
     3.498    48.945     0.200
     3.942    55.173     0.200
     3.996    57.749     0.200
     4.208    58.769     0.200
     4.699    69.078     0.200
     5.275    74.530     0.200
     5.480    79.293     0.200
     5.776    84.912     0.200
     7.942   109.905     0.200
     8.437   118.266     0.200
     2.698    40.897     0.200
     2.698    40.221     0.200
     3.472    51.566     0.200
     3.747    52.538     0.200
     3.885    57.600     0.200
     4.149    59.196     0.200
     5.216    73.829     0.200
     5.779    84.096     0.200
     6.237    83.200     0.200
     7.967   108.351     0.200
     1.929    31.672     0.200
     2.835    42.171     0.200
     3.618    51.200     0.200
     3.918    55.621     0.200
     5.382    74.739     0.200
     5.654    83.096     0.200
     5.654    81.056     0.200
     7.801   107.710     0.200
     8.473   117.302     0.200
     9.315   127.058     0.200
     9.578   130.499     0.200
     9.664   128.706     0.200
     9.819   131.598     0.200
     2.584    39.238     0.200
     2.584    38.714     0.200
     2.584    40.207     0.200
     3.305    46.706     0.200
     3.613    50.780     0.200
     3.803    55.844     0.200
     3.929    58.761     0.200
     4.016    57.898     0.200
     5.016    70.676     0.200
     5.083    71.325     0.200
     5.347    78.222     0.200
     5.855    85.945     0.200
     9.562   131.009     0.200
     9.629   128.832     0.200
     9.896   132.614     0.200
     9.980   135.876     0.200
    10.136   138.432     0.200
     1.681    30.842     0.200
     1.802    32.437     0.200
     2.088    35.778     0.200
     2.349    38.804     0.200
     2.967    46.572     0.200
     1.301    25.745     0.200
     1.482    28.067     0.200
     1.277    24.053     0.200
     1.611    28.599     0.200
     1.943    33.042     0.200
     2.194    35.365     0.200
     2.203    36.004     0.200
     3.145    47.049     0.200
     2.537    40.794     0.200
     2.873    42.197     0.200
     2.873    41.963     0.200
     3.181    50.010     0.200
     3.479    53.222     0.200
     3.636    50.959     0.200
     4.080    57.114     0.200
     4.259    58.703     0.200
     4.711    67.704     0.200
     4.659    69.001     0.200
     5.047    73.540     0.200
     5.047    76.543     0.200
     5.408    77.061     0.200
     5.439    77.316     0.200
     7.279   102.397     0.200
     1.529    27.742     0.200
     1.312    26.411     0.200
     1.436    29.003     0.200
     1.466    29.011     0.200
     2.227    37.511     0.200
     2.213    37.383     0.200
     2.491    40.688     0.200
     3.286    52.997     0.200
     1.100    22.251     0.200
     2.854    42.520     0.200
     2.854    42.053     0.200
     3.456    51.235     0.200
     3.931    55.449     0.200
     4.072    58.687     0.200
     4.250    60.886     0.200
     5.021    73.920     0.200
     5.397    76.466     0.200
     5.667    85.181     0.200
     1.826    32.236     0.200
     2.380    40.409     0.200
     2.887    48.391     0.200
     3.665    58.459     0.200
     4.383    67.882     0.200
     1.218    23.269     0.200
     2.576    38.352     0.200
     2.952    44.782     0.200
     2.952    44.617     0.200
     3.361    50.146     0.200
     4.049    57.141     0.200
     4.192    58.143     0.200
     1.322    23.417     0.200
     2.571    37.432     0.200
     2.948    42.726     0.200
     3.361    47.689     0.200
     4.045    56.692     0.200
     4.188    58.552     0.200
     5.190    71.418     0.200
     5.328    71.661     0.200
     5.508    74.468     0.200
    12.208   161.142     0.200
    13.457   177.504     0.200
     1.217    22.545     0.200
     1.216    22.483     0.200
     3.377    50.874     0.200
     3.749    53.552     0.200
     4.250    59.597     0.200
     4.622    64.014     0.200
     4.953    69.673     0.200
     4.937    68.109     0.200
     4.944    68.443     0.200
     5.513    75.628     0.200
     6.430    88.246     0.200
     7.452    99.255     0.200
     7.936   106.727     0.200
     8.178   105.868     0.200
     8.733   115.017     0.200
     8.744   113.157     0.200
     8.991   118.392     0.200
     9.127   118.024     0.200
     9.459   124.879     0.200
     9.544   125.257     0.200
     9.700   125.491     0.200
     1.548    27.150     0.200
     3.834    57.831     0.200
     4.047    63.362     0.200
     4.366    67.262     0.200
     4.684    70.799     0.200
     4.394    65.464     0.200
     1.455    27.744     0.200
     1.565    28.911     0.200
     2.408    40.644     0.200
     2.584    42.495     0.200
     2.704    42.912     0.200
     3.880    57.859     0.200
     4.078    61.208     0.200
     4.275    63.466     0.200
     4.413    66.373     0.200
     4.657    70.679     0.200
     4.848    71.149     0.200
     5.022    72.986     0.200
     5.917    84.479     0.200
     6.104    86.989     0.200
     2.584    43.291     0.200
     4.089    60.742     0.200
     4.422    66.348     0.200
     1.460    27.861     0.200
     1.454    27.956     0.200
     1.478    28.087     0.200
     1.167    23.140     0.200
     1.167    22.779     0.200
     1.344    25.435     0.200
     3.155    46.057     0.200
     4.471    64.791     0.200
     4.654    68.261     0.200
     4.697    68.554     0.200
     4.844    71.309     0.200
     5.406    78.619     0.200
     6.857    94.303     0.200
     7.950   110.442     0.200
     8.293   115.863     0.200
     2.878    43.568     0.200
     5.790    83.206     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     7.188   134.319     0.200
     7.195   140.532     0.200
    17.119   328.221     0.200
     3.924    74.781     0.200
     2.548    48.074     0.200
     3.270    62.639     0.200
     4.113    80.012     0.200
     4.176    79.376     0.200
     2.567    48.364     0.200
     3.242    62.983     0.200
     4.171    78.642     0.200
     4.644    91.315     0.200
     4.771    90.340     0.200
     5.239    99.182     0.200
     7.198   144.918     0.200
     4.069    79.161     0.200
     7.043   137.748     0.200
     3.509    64.723     0.200
     4.309    83.990     0.200
     4.473    83.971     0.200
     6.042   122.060     0.200
     6.299   124.866     0.200
     2.651    48.794     0.200
     2.651    50.525     0.200
     3.883    72.552     0.200
     4.104    79.168     0.200
     4.694    90.446     0.200
     5.825   111.279     0.200
     6.057   121.574     0.200
     6.177   114.448     0.200
     7.260   135.391     0.200
    13.428   270.357     0.200
    18.263   362.030     0.200
    21.160   418.423     0.200
     2.948    55.890     0.200
     4.154    81.499     0.200
     4.666    89.129     0.200
     4.778    96.619     0.200
     6.170   119.770     0.200
     6.269   122.320     0.200
     7.022   136.379     0.200
     7.022   135.731     0.200
    12.719   253.051     0.200
     5.768   110.063     0.200
     6.763   131.054     0.200
    13.502   265.473     0.200
    15.539   308.710     0.200
     2.881    54.396     0.200
     4.445    84.753     0.200
     3.530    71.454     0.200
     4.428    83.008     0.200
     5.503   111.446     0.200
     6.640   131.058     0.200
     8.226   162.890     0.200
     2.905    55.260     0.200
     2.585    48.129     0.200
     2.585    48.379     0.200
     4.231    81.515     0.200
     4.307    85.841     0.200
     4.732    88.549     0.200
     4.704    90.979     0.200
     4.704    90.553     0.200
     5.330    98.342     0.200
     5.811   111.996     0.200
     5.987   112.930     0.200
     6.133   115.951     0.200
     6.313   117.889     0.200
     6.401   118.763     0.200
     6.278   120.129     0.200
     6.586   122.290     0.200
     6.688   125.393     0.200
     6.712   129.962     0.200
     7.065   132.773     0.200
     7.196   135.666     0.200
     7.116   135.521     0.200
     7.646   146.766     0.200
     7.759   157.063     0.200
     8.038   161.427     0.200
     8.183   157.261     0.200
     8.539   166.850     0.200
     8.625   164.442     0.200
    10.577   203.605     0.200
    10.786   212.252     0.200
    11.063   218.891     0.200
    11.916   234.557     0.200
    12.434   248.339     0.200
     2.574    48.367     0.200
     4.697    91.286     0.200
     6.058   118.903     0.200
     7.327   145.380     0.200
    10.564   203.097     0.200
    12.384   245.335     0.200
     2.657    49.833     0.200
     2.885    54.686     0.200
     3.805    72.967     0.200
     2.638    48.003     0.200
     4.982    94.384     0.200
     5.026    93.768     0.200
     5.776   111.748     0.200
     6.755   130.474     0.200
     6.777   131.669     0.200
     3.618    69.082     0.200
     5.802   108.385     0.200
    13.553   261.601     0.200
    14.093   280.346     0.200
     6.019   115.937     0.200
    13.823   270.566     0.200
     6.045   117.954     0.200
     5.259   101.260     0.200
     5.283   100.845     0.200
     5.698   108.341     0.200
     5.698   109.294     0.200
    11.022   212.728     0.200
    13.568   265.749     0.200
    13.840   275.017     0.200
    15.390   304.287     0.200
     5.751   110.960     0.200
    10.740   206.500     0.200
     3.744    71.998     0.200
     3.871    71.556     0.200
     5.025    96.410     0.200
     5.196    97.768     0.200
     5.737   108.991     0.200
     5.905   113.434     0.200
     6.562   124.326     0.200
     6.746   130.310     0.200
     7.941   153.689     0.200
     7.991   156.932     0.200
     2.514    47.275     0.200
     3.452    68.557     0.200
     5.143    96.864     0.200
     5.663   107.937     0.200
     5.755   113.607     0.200
     7.801   152.532     0.200
    13.490   267.455     0.200
     2.759    50.282     0.200
     3.582    69.131     0.200
     5.125    95.241     0.200
     5.776   111.438     0.200
     5.776   109.998     0.200
     6.731   132.213     0.200
     7.942   151.415     0.200
     8.066   151.486     0.200
     8.844   170.954     0.200
     9.021   171.657     0.200
     9.461   180.144     0.200
    10.427   197.923     0.200
    10.606   201.458     0.200
    11.806   228.635     0.200
    12.311   238.139     0.200
    13.552   263.400     0.200
    15.522   307.880     0.200
    22.765   449.659     0.200
     2.698    49.995     0.200
     5.779   113.846     0.200
     2.835    51.696     0.200
     5.654   104.246     0.200
    10.886   208.041     0.200
    13.472   262.957     0.200
     2.584    47.113     0.200
     2.584    46.886     0.200
     3.368    62.916     0.200
     4.952    92.616     0.200
     5.026    96.211     0.200
     5.855   110.019     0.200
     6.045   116.050     0.200
     6.541   129.694     0.200
     7.284   141.820     0.200
     7.407   141.706     0.200
     8.080   156.046     0.200
     8.372   161.882     0.200
     8.503   164.246     0.200
     8.610   173.038     0.200
     8.899   174.635     0.200
     8.885   168.414     0.200
    10.614   202.222     0.200
    13.549   267.775     0.200
     2.703    50.708     0.200
     4.338    80.794     0.200
     4.611    87.836     0.200
     3.972    78.284     0.200
     2.638    49.061     0.200
     2.648    49.452     0.200
     2.873    53.025     0.200
     4.268    80.777     0.200
     4.268    81.410     0.200
     5.173    98.104     0.200
     5.188    98.060     0.200
     5.694   108.504     0.200
     5.694   107.895     0.200
     5.694   105.504     0.200
    13.524   268.522     0.200
     2.905    55.282     0.200
     3.103    58.186     0.200
     3.701    72.425     0.200
     4.334    84.380     0.200
     4.490    86.058     0.200
     2.505    45.746     0.200
     2.854    53.153     0.200
     5.158    95.597     0.200
     5.157    96.440     0.200
     6.501   123.955     0.200
    10.904   208.052     0.200
    15.392   303.763     0.200
     4.383    84.671     0.200
     4.486    85.540     0.200
     5.122    99.618     0.200
     2.576    48.182     0.200
     2.634    49.212     0.200
     2.641    50.007     0.200
     2.952    55.807     0.200
     3.256    62.008     0.200
     3.361    66.146     0.200
     4.169    79.436     0.200
    13.460   266.760     0.200
     2.571    47.973     0.200
     2.630    48.899     0.200
     2.637    49.685     0.200
     2.948    55.785     0.200
     5.190    99.799     0.200
    11.004   214.025     0.200
    13.457   262.398     0.200
    13.775   273.071     0.200
    15.291   302.643     0.200
     2.587    47.018     0.200
     2.649    48.346     0.200
     2.958    54.891     0.200
     2.958    54.492     0.200
     4.187    79.407     0.200
     5.209    98.606     0.200
     5.607   109.890     0.200
     5.607   107.499     0.200
     5.923   115.409     0.200
     6.862   132.661     0.200
     6.937   134.366     0.200
     7.172   138.172     0.200
     7.167   138.896     0.200
     7.283   140.842     0.200
     2.704    52.250     0.200
     4.438    83.856     0.200
     4.784    91.059     0.200
     5.133    96.600     0.200
     5.433   101.274     0.200
     6.252   117.565     0.200
     6.466   120.008     0.200
     6.752   131.672     0.200
    12.551   246.331     0.200
    14.621   286.236     0.200
     4.798    91.932     0.200
     4.826    89.962     0.200
     2.704    51.312     0.200
     2.698    50.224     0.200
     2.698    50.894     0.200
     4.332    81.746     0.200
     4.661    89.867     0.200
     6.292   116.996     0.200
    10.690   203.267     0.200
    17.131   337.310     0.200
    22.108   431.799     0.200
     2.702    49.557     0.200
     4.655    88.007     0.200
    12.407   237.436     0.200
     3.155    58.233     0.200
     2.878    53.818     0.200
     5.790   108.034     0.200
    10.915   206.447     0.200
    13.613   266.415     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.556    11.304     0.200
     0.557    11.282     0.200
     0.495    10.836     0.200
     0.532    11.297     0.200
     0.957    20.135     0.200
     1.103    21.641     0.200
     1.898    36.158     0.200
     0.551    11.083     0.200
     0.784    15.167     0.200
     0.952    19.602     0.200
     1.300    25.148     0.200
     0.308     6.342     0.200
     0.989    19.101     0.200
     2.080    39.872     0.200
     0.420     9.669     0.200
     0.494    10.416     0.200
     0.759    15.313     0.200
     1.060    20.105     0.200
     0.662    13.245     0.200
     0.684    12.203     0.200
     0.972    20.131     0.200
     1.230    23.621     0.200
     0.382     7.937     0.200
     0.441     9.065     0.200
     1.216    22.653     0.200
     1.184    23.228     0.200
     1.492    27.865     0.200
     2.657    47.599     0.200
     0.218     6.735     0.200
     0.757    15.124     0.200
     0.868    17.217     0.200
     0.824    15.657     0.200
     0.972    18.928     0.200
     0.991    19.825     0.200
     1.527    29.335     0.200
     2.881    52.445     0.200
     4.280    74.870     0.200
     5.064    87.222     0.200
     0.586    12.368     0.200
     0.866    17.382     0.200
     1.202    22.211     0.200
     2.467    45.385     0.200
     0.219     7.006     0.200
     0.519    10.805     0.200
     0.609    12.686     0.200
     0.663    13.042     0.200
     0.926    17.901     0.200
     1.211    22.020     0.200
     3.998    68.684     0.200
     4.224    73.937     0.200
     4.564    79.289     0.200
     4.623    80.819     0.200
     0.404     9.487     0.200
     0.866    16.482     0.200
     0.741    14.831     0.200
     0.867    17.429     0.200
     0.905    17.509     0.200
     4.757    86.919     0.200
     5.696   105.077     0.200
     6.529   120.550     0.200
     0.417     9.710     0.200
     0.559    11.775     0.200
     0.751    14.985     0.200
     0.751    15.204     0.200
     0.887    17.204     0.200
     0.887    16.784     0.200
     0.887    16.785     0.200
     0.851    17.026     0.200
     0.921    18.810     0.200
     1.259    24.350     0.200
     0.637    13.020     0.200
     0.383     8.788     0.200
     0.414     7.732     0.200
     0.398     8.846     0.200
     0.398     7.986     0.200
     0.457     9.217     0.200
     0.630    12.292     0.200
     0.630    12.143     0.200
     0.691    13.427     0.200
     0.395     8.330     0.200
     0.395     8.440     0.200
     0.450     9.429     0.200
     2.706    47.637     0.200
     0.595    11.358     0.200
     0.595    11.236     0.200
     0.632    12.696     0.200
     0.597    12.493     0.200
     0.644    12.453     0.200
     0.619    12.490     0.200
     0.661    13.577     0.200
     0.306     6.301     0.200
     0.306     6.418     0.200
     0.323     7.089     0.200
     0.324     6.817     0.200
     0.538    10.376     0.200
     0.759    15.577     0.200
     2.040    36.783     0.200
     2.507    44.426     0.200
     2.975    53.233     0.200
     0.350     7.209     0.200
     0.351     6.650     0.200
     0.591    11.794     0.200
     0.625    13.069     0.200
     0.430     8.263     0.200
     0.430     9.122     0.200
     0.455     9.774     0.200
     0.456     9.159     0.200
     0.615    12.148     0.200
     0.717    14.871     0.200
     1.122    20.355     0.200
     2.150    39.496     0.200
     2.967    52.384     0.200
     2.967    53.657     0.200
     0.357     8.100     0.200
     0.351     7.152     0.200
     0.351     7.304     0.200
     0.410     8.499     0.200
     0.410     8.279     0.200
     0.454     8.896     0.200
     0.611    11.820     0.200
     0.897    16.717     0.200
     1.919    36.378     0.200
     2.664    47.650     0.200
     0.239     5.199     0.200
     0.239     5.689     0.200
     0.295     6.503     0.200
     0.277     6.073     0.200
     0.278     5.918     0.200
     0.423     7.930     0.200
     0.661    13.339     0.200
     0.817    15.557     0.200
     0.998    18.403     0.200
     1.103    20.381     0.200
     1.949    35.786     0.200
     2.858    51.312     0.200
     0.239     5.766     0.200
     0.357     7.533     0.200
     0.357     7.779     0.200
     0.437     9.086     0.200
     0.528    10.730     0.200
     0.695    13.344     0.200
     0.967    18.621     0.200
     1.142    21.548     0.200
     1.997    35.884     0.200
     2.759    49.630     0.200
     3.806    68.697     0.200
     0.193     5.028     0.200
     0.376     7.897     0.200
     0.376     7.889     0.200
     0.409     8.287     0.200
     0.431     9.135     0.200
     0.432     9.101     0.200
     0.635    11.962     0.200
     0.910    17.392     0.200
     1.971    36.703     0.200
     2.698    48.752     0.200
     0.228     5.675     0.200
     0.228     5.425     0.200
     0.271     6.617     0.200
     0.399     8.464     0.200
     0.797    15.783     0.200
     1.085    20.146     0.200
     0.214     5.538     0.200
     0.336     7.301     0.200
     0.510     9.703     0.200
     0.493     9.847     0.200
     0.493     9.988     0.200
     1.296    23.707     0.200
     1.990    36.698     0.200
     0.474     8.643     0.200
     0.659    11.758     0.200
     0.660    12.994     0.200
     0.696    13.434     0.200
     0.734    14.590     0.200
     0.937    18.126     0.200
     0.978    19.721     0.200
     1.210    23.942     0.200
     1.318    25.795     0.200
     1.301    25.177     0.200
     1.446    27.946     0.200
     0.690    15.205     0.200
     0.759    15.174     0.200
     0.847    16.181     0.200
     0.919    17.665     0.200
     0.977    18.523     0.200
     0.989    19.080     0.200
     1.151    22.068     0.200
     1.600    30.266     0.200
     2.046    37.870     0.200
     0.197     5.395     0.200
     0.350     6.891     0.200
     0.813    16.021     0.200
     0.898    17.838     0.200
     1.087    21.127     0.200
     1.145    21.885     0.200
     1.428    26.486     0.200
     1.483    27.326     0.200
     1.857    34.299     0.200
     0.314     7.105     0.200
     0.271     6.287     0.200
     0.271     6.185     0.200
     0.454     9.465     0.200
     1.104    20.277     0.200
     1.020    20.092     0.200
     1.329    23.469     0.200
     1.698    31.565     0.200
     1.844    34.011     0.200
     1.983    37.135     0.200
     2.457    42.718     0.200
     0.238     5.514     0.200
     0.644    11.949     0.200
     1.005    19.896     0.200
     1.093    21.304     0.200
     1.091    20.874     0.200
     1.249    24.230     0.200
     1.529    29.785     0.200
     1.682    31.441     0.200
     1.682    31.665     0.200
     1.907    36.285     0.200
     1.962    37.671     0.200
     1.976    38.637     0.200
     2.185    41.038     0.200
     2.397    45.845     0.200
     0.514     8.940     0.200
     0.735    13.974     0.200
     1.125    23.272     0.200
     1.412    27.009     0.200
     1.412    27.523     0.200
     0.242     5.474     0.200
     0.242     5.612     0.200
     0.242     5.673     0.200
     0.422     8.495     0.200
     0.655    13.619     0.200
     0.655    12.772     0.200
     0.745    14.566     0.200
     1.003    19.211     0.200
     1.811    33.399     0.200
     1.811    32.959     0.200
     2.121    38.579     0.200
     2.430    44.559     0.200
     2.854    51.762     0.200
     0.518    10.920     0.200
     0.625    12.023     0.200
     0.696    13.802     0.200
     0.835    16.040     0.200
     1.017    20.548     0.200
     1.033    20.942     0.200
     1.408    26.809     0.200
     1.940    35.653     0.200
     0.201     5.720     0.200
     0.389     8.700     0.200
     0.466    10.162     0.200
     0.656    13.673     0.200
     0.775    15.445     0.200
     0.893    17.213     0.200
     1.327    24.959     0.200
     1.831    34.509     0.200
     1.937    36.520     0.200
     2.178    40.563     0.200
     0.198     6.262     0.200
     0.385     8.437     0.200
     0.461    10.504     0.200
     0.655    13.153     0.200
     0.893    16.946     0.200
     0.772    15.482     0.200
     1.214    21.538     0.200
     1.827    34.266     0.200
     1.933    36.419     0.200
     2.173    40.685     0.200
     0.219     5.936     0.200
     0.219     5.888     0.200
     0.219     5.782     0.200
     0.394     8.903     0.200
     0.479    10.483     0.200
     0.479    10.585     0.200
     0.774    15.954     0.200
     0.906    18.159     0.200
     0.906    17.816     0.200
     1.341    26.243     0.200
     1.341    25.009     0.200
     1.847    34.497     0.200
     1.954    36.731     0.200
     2.190    40.031     0.200
     2.426    41.477     0.200
     0.465    10.088     0.200
     0.711    14.865     0.200
     0.712    13.650     0.200
     0.712    13.810     0.200
     0.712    12.948     0.200
     0.712    12.675     0.200
     1.045    20.247     0.200
     1.045    20.778     0.200
     1.188    23.413     0.200
     1.508    29.015     0.200
     1.508    28.187     0.200
     1.571    29.543     0.200
     2.489    46.867     0.200
     0.138     4.260     0.200
     0.320     7.351     0.200
     0.298     7.513     0.200
     0.753    15.346     0.200
     1.126    21.355     0.200
     1.334    26.032     0.200
     1.374    25.452     0.200
     1.723    31.898     0.200
     1.965    35.384     0.200
     0.284     6.346     0.200
     0.568    11.680     0.200
     0.691    13.935     0.200
     0.765    15.089     0.200
     0.765    14.701     0.200
     0.796    15.688     0.200
     0.853    16.471     0.200
     0.853    16.102     0.200
     0.915    18.666     0.200
     0.915    18.287     0.200
     0.995    19.421     0.200
     1.306    25.710     0.200
     1.481    27.774     0.200
     1.605    30.254     0.200
     1.605    30.065     0.200
     1.824    33.968     0.200
     0.549    11.476     0.200
     0.706    14.082     0.200
     0.757    15.884     0.200
     0.777    15.152     0.200
     0.839    16.456     0.200
     0.932    18.068     0.200
     1.303    24.511     0.200
     1.500    27.947     0.200
     1.582    28.988     0.200
     1.606    29.755     0.200
     0.685    13.916     0.200
     0.761    14.483     0.200
     0.761    15.682     0.200
     0.852    16.937     0.200
     0.852    16.983     0.200
     0.913    18.169     0.200
     1.599    30.723     0.200
     1.599    30.203     0.200
     1.830    33.656     0.200
     5.442   100.374     0.200
     0.287     7.788     0.200
     0.688    14.229     0.200
     0.766    15.379     0.200
     0.766    15.059     0.200
     0.855    16.337     0.200
     0.855    16.618     0.200
     0.855    16.537     0.200
     0.856    16.623     0.200
     0.911    17.905     0.200
     0.911    18.019     0.200
     0.997    19.272     0.200
     1.561    30.092     0.200
     1.605    30.534     0.200
     1.605    30.155     0.200
     1.760    33.830     0.200
     0.294     6.273     0.200
     0.748    14.411     0.200
     0.748    14.580     0.200
     0.748    15.032     0.200
     0.749    15.308     0.200
     0.854    16.941     0.200
     0.854    16.712     0.200
     1.034    20.210     0.200
     1.464    28.071     0.200
     0.367     6.083     0.200
     0.367     6.079     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
